﻿USE sofia;
DROP TABLE IF EXISTS sofia.mazNT_vpl;
CREATE TABLE mazNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mazNT_vpl WRITE;
INSERT INTO mazNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","E Jesucristo mi mboxbëche cja e Abraham, 'ñe cja e David. Juns'ü va o̱ tjũ'ũ c'o o̱ mboxpale e Jesús ndeze e Abraham. ");
INSERT INTO mazNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","E Abraham o jmusp'ü 'na t'i c'ü mi chjũ e Isaac. Nuc'ua e Isaac o jmusp'ü e Jacob. Nuc'ua e Jacob o jmusp'ü e Judá, 'ñe c'o nu cjuarma. ");
INSERT INTO mazNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nuc'ua e Judá o jmusp'ü e Fares 'ñe e Zara. C'ü nu nanavi mi chjũ e Tamar. Nuc'ua e Fares o jmusp'ü e Esrom. Nuc'ua e Esrom o jmusp'ü e Aram. ");
INSERT INTO mazNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Nuc'ua e Aram o jmusp'ü e Aminadab. Nuc'ua e Aminadab o jmusp'ü e Naasón. Nuc'ua e Naasón o jmusp'ü e Salmón. ");
INSERT INTO mazNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nuc'ua e Salmón o jmusp'ü e Booz. C'ü nu nana e Booz mi chjũ e Rahab. Nuc'ua e Booz o jmusp'ü e Obed. C'ü nu nana e Obed mi chjũ e Rut. Nuc'ua e Obed o jmusp'ü e Isaí. ");
INSERT INTO mazNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Nuc'ua e Isaí o jmusp'ü e David c'ü o nocü o mbëzhi jmu'u. E David o chjüntüvi c'e ndixũ c'ü mi ngue nu su e Urías c'ü vi bö't'ü. Nuc'ua c'e ndixũ o musp'ü 'na ts'it'i e David c'ü mi chjũ e Salomón. ");
INSERT INTO mazNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Nuc'ua e Salomón o jmusp'ü e Roboam. Nuc'ua e Roboam o jmusp'ü e Abías. Nuc'ua e Abías o jmusp'ü e Asa. ");
INSERT INTO mazNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Nuc'ua e Asa o jmusp'ü e Josafat. Nuc'ua e Josafat o jmusp'ü e Joram. Nuc'ua e Joram o jmusp'ü e Uzías. ");
INSERT INTO mazNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Nuc'ua e Uzías o jmusp'ü e Jotam. Nuc'ua e Jotam o jmusp'ü e Acaz. Nuc'ua e Acaz o jmusp'ü e Ezequías. ");
INSERT INTO mazNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Nuc'ua e Ezequías o jmusp'ü e Manasés. Nuc'ua e Manasés o jmusp'ü e Amón. Nuc'ua e Amón o jmusp'ü e Josías. ");
INSERT INTO mazNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Nuc'ua e Josías o jmusp'ü e Jeconías 'ñe c'o o̱ cjuarma. Mi ngue c'o pa 'ma o ndõpüji c'o menzumü a Israel o dyëdyiji a ma a Babilonia c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","'Ma ya ma cãji a ma a Babilonia, nuc'ua e Jeconías o jmusp'ü e Salatiel. Nuc'ua e Salatiel o jmusp'ü e Zorobabel. ");
INSERT INTO mazNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Nuc'ua e Zorobabel o jmusp'ü e Abiud. Nuc'ua e Abiud o jmusp'ü e Eliaquim. Nuc'ua e Eliaquim o jmusp'ü e Azor. ");
INSERT INTO mazNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Nuc'ua e Azor o jmusp'ü e Sadoc. Nuc'ua e Sadoc o jmusp'ü e Aquim. Nuc'ua e Aquim o jmusp'ü e Eliud. ");
INSERT INTO mazNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Nuc'ua e Eliud o jmusp'ü e Eleazar. Nuc'ua e Eleazar o jmusp'ü e Matán. Nuc'ua e Matán o jmusp'ü e Jacob. ");
INSERT INTO mazNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nuc'ua e Jacob o jmusp'ü e José, c'ü o chjüntüvi e María. E María ngue c'ü o mus'ü e Jesús. E Jesús ngue Cristo c'ü ne ra mama: Nu c'ü o 'ñeme Mizhocjimi ra manda. ");
INSERT INTO mazNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","C'o nu mboxpale e Jesucristo ndeze e Abraham hasta e David, o zö'ö catorce c'o. Nuc'ua, ndeze e David hasta 'ma o dyëdyiji c'o menzumü a Israel a ma a Babilonia, o zö'ö ndo 'na catorce c'o nu mboxpale. Nuc'ua, ndeze 'ma o dyëdyiji a ma a Babilonia hasta 'ma o jmus'ü e Cristo, o zö'ö ndo catorce. ");
INSERT INTO mazNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","C'ü nu nana e Jesucristo mi ngue e María. 'Ma o jmus'ü e Jesucristo, je va cjava. E José ya vi ñavi e María c'ü ro chjüntüvi. 'Ma dya be mi chjüntüvi, e María ya mi tũ'ũ 'na ts'it'i. Pero dya cjó mi dyojui; mi ngue o̱ Espíritu Mizhocjimi c'ü vi tsjapü o ndunte. ");
INSERT INTO mazNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","E José mi cja c'o mi mama c'o ley. Nguec'ua 'ma o dyärä ya mi ndunte e María, o nguijñi c'ü ro unü 'na xiscõmü e María c'ü dya ro chjüntui. Pero dya ro ma ngös'ü c'o pje mi pjëzhi, na ngue dya mi ne e José ro bëzhi o̱ tseje e María. ");
INSERT INTO mazNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nuc'ua 'ma mi cjijñi a cjanu e José, o nguinch'i 'na t'ĩjĩ o jñanda 'naja c'o o̱ anxe Mizhocjimi c'o ixi cãrã a jens'e. O ña c'ua c'e anxe o xipji e José: ―Nu'tsc'e José, o̱ mboxbëchets'ü e David, dya rí yembeñe. Ni jyodü rí tsjapü nin su e María. Na ngueje c'ü ya tũ'ũ c'ü, ixi nguetsjë o̱ Espíritu Mizhocjimi c'ü o tsjapü o nduns'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ra mus'ü 'na ts'it'i c'ü rí jñusp'ü o̱ tjũ e Jesús. Na ngueje angueze ra salva c'o nte c'o ya juajnü, ra jopcüji o̱ mü'büji c'o o̱ nzhubüji, eñe c'e anxe va xipji e José. ");
INSERT INTO mazNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Mi jinguã Mizhocjimi o 'ñünbü o̱ mü'bü 'na profeta o xipji c'o nte: Dyär'maji. Ra nduntetsjë 'na xunt'i c'ü dya dyojui 'na bëzo; ra mus'ü 'naja ts'it'i c'ü rguí chjũ e Emanuel, eñe c'e profeta va pätpä Mizhocjimi. E Emanuel ne ra mama: Bübü dya Mizhocjimi a ndezgöji. Nguec'ua 'ma o ndunte e María o mus'ü e Jesús, o zädä o̱ jña Mizhocjimi c'ü vi mama c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nuc'ua 'ma o zö e José a t'ĩjĩ, o tsja c'ua ja nzi va xipji c'ü o̱ anxe Mizhocjimi, o chjüntui e María. ");
INSERT INTO mazNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero dya juntavi hasta 'ma o mus'ü c'e ts'it'i c'ü primero o̱ t'i e María. Nuc'ua e José o jñusp'ü c'e ts'it'i e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","O jmus'ü e Jesús 'ma mi manda c'e rey Herodes a Judea. Je jmus'ü cja c'e jñiñi a Belén c'ü tsja a Judea, cja c'e xoñijõmü a Israel. O mezhtjo c'ua o ẽjẽ ja nzi nte c'o me mi pãrã, c'o mi xiji mago, vi 'ñeji nu ja ni mbes'e e jyarü. O säji a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nuc'ua c'o mago o mbürü o zopjüji c'o mi cãrã a Jerusalén, o xipjiji: ―Ya jítsijme 'na señal; ró jandajme o mbes'e 'na seje. Ngue c'ü rvá pãrãgöjme c'ü ya jmus'ü 'na ts'it'i c'ü ra manda cja yo menzumü a Israel. Nutscöjme rí ne rí xitscöjme ja bübü c'e ts'it'i. Na ngue rvá ẽcjöjme rá ẽ ndüñijõmüjme a jmi angueze, rá ma't'üjme, eñe c'o nte c'o mi xiji mago. ");
INSERT INTO mazNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nuc'ua c'e rey Herodes o mbãrã c'ü mi mama c'o mago c'ü ya vi jmus'ü 'na ts'it'i c'ü ro manda. Nguec'ua va pizhi na puncjü angueze, dya mi pãrã pje ro nguijñi. Me xo go pizhi c'ua texe c'o mi cãrã a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nuc'ua e Herodes o zojnü c'o ndamböcjimi cja c'o menzumü a Israel. Xo zojnü c'o mi xöpü o̱ ley Mizhocjimi. Cjanu o dyönüji ja je ngue c'ua ro jmus'ü e Cristo c'ü ro ẽ manda. ");
INSERT INTO mazNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Cjanu o ndünrüji: ―Nuc'ü, je ra jmus'ü cja c'e jñiñi a Belén c'ü tsja a Judea. Na ngue je ga cjava va dyopjü c'e profeta va pätpä Mizhocjimi: ");
INSERT INTO mazNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nu'tsc'eji i̱ṉ menzumüji a Belén, ni muvi in jñiñigueji cja c'o 'ñaja jñiñi a Judá. Na ngue ra tetsc'eji 'naja c'ü ra manda, 'ñe ra mbörü yo menzumü a Israel yo ró juajnügö, eñe c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nuc'ua e Herodes o zojnü c'o mago c'ü dya cjó ro mbãrã cjo mi ñaji c'o. Cjanu o tsjapüji na jo t'önü jinguã vi mbes'e c'e seje. Cjanu o ndünrü c'ua c'o mago o xiji jinguã vi mbes'e c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cjanu o ndäji c'ua a ma a Belén o xipjiji: ―Möji, ma tsjaji na jo o t'önü rgui jyodüji c'e ts'it'i. Nuc'ua 'ma rí chöt'üji, rí nzhogüji rí 'ñe xitscöji. Nguec'ua xo rá magö, rá ma ndüñijõmü a jmi rá ma'tc'ö c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nuc'ua 'ma ya vi nguarü vi ñaji c'e rey, cjanu o ma c'ua c'o mago. Nuc'ua c'e seje c'ü ya vi jñandaji ndeze 'ma o mbes'e, o 'ñetsetjo na yeje. Nu c'o mago 'ma o jñandaji c'e seje, go mäji na puncjü. Nuc'ua c'e seje mi ot'ü o̱ xo'ñiji c'ü, hasta 'ma cja zät'ä a xes'e nu cja c'e ngumü nu ja ma bübü c'e ts'it'i. Cja chi o böbütjo nu. ");
INSERT INTO mazNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Cjanu o zät'äji c'ua cja c'e ngumü, cjanu o cjogüji a mbo. O jñandaji c'e ts'it'i ma bübü cja c'e ngumü co e María c'ü nu nana. Cjanu o ndüñijõmüji a jmi c'e ts'it'i, o ma't'üji. Cjanu o xo's'üji c'ua o̱ cajaji c'o mi quiji o oro, 'ñe o nguichjünü, 'ñe o mirra c'o ma jo ma jyärä y me mi muvi. Cjanu o nguibiji, cjanu o unüji c'e ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nuc'ua Mizhocjimi o zopjü a t'ĩjĩ c'o mago, o xipjiji: ―Dya cja rí nzhogüji cja e Herodes, empji. Nguec'ua 'ma mü o nzhogüji cja c'e país nu ja mi menzumüji, o möji c'ü 'na 'ñiji. ");
INSERT INTO mazNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nuc'ua 'ma ya vi mbedye c'o mago, cjanu o nguinch'i c'ua 'na t'ĩjĩ e José o jñanda 'na c'o o̱ anxe Mizhocjimi. Cjanu o ña c'ua c'e anxe o zopjü e José, o xipji: ―Nu'tsc'e, ñanga rí sidyi ne ts'it'i 'ñejnu nu nana; rí c'ueñe rí möji a ma cja c'e xoñijõmü a Egipto. Na ngueje e Herodes ra jyodü ne ts'it'i ra mbö't'ü. Y rí mimitjoji nu hasta 'ma cja rá xi'ts'i, eñe c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nuc'ua cjanu o zö c'ua a t'ĩjĩ e José. Go zidyi c'ua c'e ts'it'i 'ñe c'ü nu nana, go mbedyeji c'ua c'e xõmü, o möji a ma a Egipto. ");
INSERT INTO mazNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nuc'ua o mimiji nu hasta 'ma cja o ndũ e Herodes. Mi jinguã mi bübü 'na profeta c'ü mi pätpä Mizhocjimi. C'e profeta o mama: “Rá penpe 'na jña c'ín Ch'igö c'ü ra mbedye a Egipto”, eñe Mizhocjimi. Nguec'ua 'ma o ma ga ma a Egipto e José co e María 'ñe e Jesús, o zädä o̱ jña Mizhocjimi c'ü vi mama c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","'Ma o unü ngüenda e Herodes c'ü dya nzhogü c'o mago ro ẽ xipjiji ja mi bübü c'e ts'it'i, me co üdü c'ua na puncjü angueze. Cjanu o manda o mbö't'üji texe c'o ts'it'i c'o mi cãrã a Belén, y hasta ja c'o mi tjorü c'e jñiñi c'ü. O mbö't'üji c'o cja vi mus'üji, cja na 'ñe c'o ya mi ëdyi ye cjë. Na ngue e Herodes ya vi dyönü na jo c'o mago, nguec'ua va mbãrã ja ya nzi zana vi mezhe ndeze 'ma ya vi mbes'e c'e seje. ");
INSERT INTO mazNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Mi jinguã vi dyopjü a cjava c'e profeta Jeremías: Cja c'e jñiñi a Ramá mi t'ärä 'na c'ü me ma huë na jens'e. Mi ngue c'e ndixũ c'ü mi chjũ e Raquel mi huëpi c'o o̱ mboxbëche. Dya go ne cjó ro chëzhi o̱ jmi pa ro mäjä, na ngueje ya vi mbö'tp'üji c'o o̱ mboxbëche, eñe c'e profeta va pätpä Mizhocjimi. Nguec'ua 'ma o manda e Herodes o mbö't'üji c'o ts'it'i, o zädä c'ü vi mama c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","O ẽ c'ua 'na nu pa, o ndũ e Herodes. 'Ma xe ma bübütjo e José a Egipto, o nguinch'i 'na t'ĩjĩ o jñanda 'na c'o o̱ anxe Mizhocjimi. Nuc'ua c'e anxe o zopjü o xipji: ");
INSERT INTO mazNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Nu'tsc'e, ñanga rí sidyi ne ts'it'i 'ñejnu nu nana, rí möji a ma cja c'e xoñijõmü a Israel nu ja vi 'ñecjeji. Na ngueje ya ndũ'ũ c'o mi jodü ro mbö't'ü ne ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","O nanga c'ua e José. Cjanu o zidyi c'e ts'it'i 'ñe c'ü nu nana, o möji c'ua a ma cja c'e xoñijõmü a Israel. ");
INSERT INTO mazNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nuc'ua cjanu o mbãrã e José c'ü ya mi manda e Arquelao a Judea c'ü tsja a Israel, chjëntjui c'ü ri bübütjo e Herodes c'ü ndunu tata. Nguec'ua mi sũ'ũ e José xe ro ma ga manu. Nuc'ua Mizhocjimi o yepe o zopjü a t'ĩjĩ e José. Nguec'ua va cjogütjoji a Judea o möji c'ua a ma cja c'e xoñijõmü a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","O zät'äji cja 'na jñiñi c'ü ni chjũ a Nazaret; o mimiji nu. Mi jinguã vi mama a cjava c'o profeta: “Ra xiji menzumü a Nazaret nu c'ü ra ẽjẽ”, eñe c'o profeta. Nguec'ua 'ma o ma mimi a Nazaret e José 'ñe e María 'ñe c'e ts'it'i, o zädä c'e jña c'ü ya vi mama c'o profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","O mezhe c'ua ja nzi cjë, o mbürü o pëpji cja Mizhocjimi 'na bëzo c'ü mi chjũ e Juan. Mi bübü cja c'e majyadü a ma a Judea. Mi zopjü c'o nte y mi jichiji co ndeje. ");
INSERT INTO mazNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mi xipjiji a cjava: ―Jyëziji c'o na s'o, ra nzhogü in mün'c'eji cja Mizhocjimi. Na ngueje nu c'ü o 'ñeme Mizhocjimi ra mandazüji, ya ngue ra manda, eñe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mi jinguã c'e profeta Isaías vi pätpä Mizhocjimi, vi mama ja rva cja e Juan. O mama c'e profeta c'ü ro bübü 'na nte cja 'na majyadü c'ü ro mapjü, ro zopjü c'o nte ro xipjiji: “Rí jyëzgueji c'e 'ñiji c'ü na s'o, rí jyëzgueji c'e 'ñiji c'ü mogü. Na ngue ya ngue ra ẽ c'ín Jmugöji c'ü bübü a jens'e”, ro 'ñeñe c'e nte. Je ga cjanu va mama c'e profeta c'ü ro mama c'e nte'e. ");
INSERT INTO mazNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","E Juan mi je'e 'na bitu c'ü vi t'ät'ä o̱ xi o camello, y mi nzünt'ü 'na xipjadü. Mi sa c'o mi nza cja o t'ãxã, y xo mi si o̱ miel o ngüjnü. ");
INSERT INTO mazNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nuc'ua ma ẽ c'ua c'o menzumü a Jerusalén, 'ñe c'o menzumü cja c'o 'ñaja jñiñi a Judea, cja na 'ñe c'o mi cãrã texe ja c'o cjogü c'e ndare a Jordán, ma säjäji cja e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mi xipjiji Mizhocjimi c'o ma s'o c'o mi cjaji, y mi jichi e Juan anguezeji cja c'e ndare a Jordán. ");
INSERT INTO mazNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Cja c'o menzumü a Israel mi cãrã c'o mi xiji fariseo, 'ñe c'o mi xiji saduceo. E Juan o jñanda ma ẽjẽ na puncjü anguezeji ro 'ñe ji'iji. Nguec'ua va mama e Juan va xipjiji: ―Nza cjatsc'eji o c'ijmi c'o sũ ga c'ueñe 'ma tjë o batjü. Na ngue i̱ṉ sũji ra jñün'c'eji ngüenda Mizhocjimi rí sufreji, nguec'ua va ẽgueji va 'ñe ji'iji. ");
INSERT INTO mazNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pero 'ma na cjuana nzhogü in mü'büji cja Mizhocjimi, rí tsjaji na jo, ngue c'ua ra 'ñetse o nzhogü in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","I̱ṉ pëzhgueji ra recibidots'üji Mizhocjimi, na ngueje o̱ mboxbëchets'üji e Abraham. Pero rí xi'tsc'öji, dya cja rí tsjijñiji c'ü ni jyodü ra recibidots'üji. Na ngueje me na zëzhi Mizhocjimi, sö ra tsjapü yo ndojo ra mbëzhi nte c'o ra jñu's'ü e Abraham, xo ra 'ñench'e o̱ mü'büji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Xe sido o ña e Juan o zopjü c'o fariseo 'ñe c'o saduceo, o xipjiji: ―Nza cjatsc'eji za'a c'o dya jo c'o quis'i, c'o ya juns'ütjo jacha cja o̱ dyü'ü. Texe za'a c'ü dya jo c'o quis'i, ya ngue ra dyëziji cja rrũ mboch'üji cja sivi. Je xo rga cjanu rgá tsja'c'eji, nu 'ma dya ra nzhogü in mü'büji cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Bübü mbëpji c'o o̱ cjaja c'ü nu lamu, xäpcäji o̱ mbäcua c'ü nu lamu ga mbös'ü. Pero nutscö dya pje pjëtscö rá pjösc'ö a cjanu nu c'ü cja va ẽjẽ. Na ngueje me na nojo na puncjü angueze, nutscö rí menutjogö que na ngue 'na mbëpji. Nutscö rí jichi co ndeje c'o ra nzhogü o̱ mü'bü cja Mizhocjimi. Pero nu c'ü cja va ẽjẽ, 'ma rí 'ñench'e in mün'c'eji angueze, ra dya'c'eji o̱ Espíritu Mizhocjimi c'ü. 'Ma dya rí 'ñench'e in mü'büji, ra dya'c'eji rí ma sufreji cja sivi, eñe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xe sido o ña e Juan o xipjiji 'na ejemplo o mama: ―'Na campesino ra jñüs'ü o̱ yelgo, cja rrũ mbitsi na jo o̱ ndëxü. C'o ndëxü ra dyüt'ü cja c'ü o̱ t'ujmü c'o, pero c'o paxa ra ndüt'ü co sivi c'o. Je xo ga cjanu rgá tsja nu c'ü cja va ẽjẽ. Ya bübü angueze ra recibido c'o ra nzhogü o̱ mü'bü, pero c'o dya ra nzhogü o̱ mü'bü, ya bübü ra mboch'üji a sivi c'ü dya ra juench'e, eñe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","E Jesús ma bübü a ma a Galilea. O ẽ 'na nu pa, o mbedye c'ua o ma a ma cja c'e ndare a Jordán nu ja ma bübü e Juan. Je o ma nu, ngue c'ua ro tsja e Juan ro jichi angueze. ");
INSERT INTO mazNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero e Juan dya mi ne ro jichi, mi xipji: ―Nu'tsc'e va ẽcje i̱ṉ negue rá ji'tsc'ö, maco nguetscö ni jyongö rí jitscö, eñe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Cjanu o ndünrü c'ua e Jesús o xipji: ―Iyö, rí jitscö, na ngue ni jyodü rá cjaji texe c'ua ja ga manda Mizhocjimi. Cjanu ne'e c'ua e Juan o jichi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nuc'ua 'ma nzi va nguarü va ji'i e Jesús, cjanu o mbes'e cja c'e ndare. O xogü c'ua a jens'e, y o jñanda e Jesús ma sjöbü o̱ Espíritu Mizhocjimi nza cja 'na mbaro, ma ẽjẽ ro 'ne ndägä a xes'e angueze. ");
INSERT INTO mazNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Cjanu o dyäräji c'ua 'naja c'ü mi ña a jens'e, o mama: ―Nujnu nguejnu ín Ch'igö nu rí s'iya, nguejnu rgá mäcjö nu, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nuc'ua o̱ Espíritu Mizhocjimi o 'ñünbü o̱ mü'bü e Jesús. Nguec'ua va ma a ma cja majyadü ro ndörüji angueze, ro tsja e Satanás c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","O mezhe cuarenta pa, xõmü ndempa c'ü dya pje zi'i e Jesús cja c'e majyadü. Nuc'ua cjanu o zant'a c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Cjanu o ẽ c'ua c'ü dya jo o 'ñe ndörü e Jesús, o xipji: ―Ngue'tsc'e o̱ T'itsc'e Mizhocjimi, nguec'ua rí xipjigue yo ndojo ra mbëzhi o xëdyi rí sigue, eñe c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Cjanu ndünrü c'ua e Jesús o xipji: ―Dya rá ä'tc'ägö c'ü i̱ṉ xitsi, na ngue je t'opjü o̱ jña Mizhocjimi c'ü dya nguextjo xëdyi c'ü rga minc'öjme, sino que ngue texe o̱ jña angueze c'ü pedye o̱ ne'e c'ü, enzgöjme Mizhocjimi. Nguec'ua, dya rá cjapü yo ndojo ra mbëzhi o xëdyi rá sigö, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nuc'ua c'ü dya jo, o zidyi e Jesús a ma a Jerusalén c'ü ngue o̱ ndajñiñi Mizhocjimi. Cjanu o 'ñe's'e c'ua a xes'e cja 'naja c'o torre c'o mi bübü cja c'e templo. ");
INSERT INTO mazNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Cjanu o xipji: ―Ngue'tsc'e o̱ T'itsc'e Mizhocjimi; nguec'ua rí dacü dya a ma a jõmü. Ni jyodü rí tsjague a cjanu, na ngueje ya xo t'opjü o̱ jña Mizhocjimi: Mizhocjimi ra ndäjä c'o o̱ anxe rguí 'ñeji a jens'e ra 'ñe pënchc'iji, ngue c'ua dya rí sos'ü cja ndojo ra s'onnc'ü in cua, ni pje rí tsja, eñe. Nguec'ua rí dacü ndeze va hasta a jõmü, eñe e Satanás c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Cjanu o ndünrü c'ua e Jesús o xipji: ―Dya rá dacü c'ua ja gui xitscö. Na ngue ya xo t'opjü c'ü dya rá söjme o̱ jña Mizhocjimi c'ín Jmugöji, enzgöjme. Nguec'ua dya rá dacü a ma a jõmü para rá nugö cjo ra mböxcö Mizhocjimi, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nuc'ua c'ü dya jo, o zidyi na yeje e Jesús a ma cja 'na t'eje c'ü me na ndã'ã. Cjanu o jíchi c'ua texe yo jñiñi cja ne xoñijõmü, cja na 'ñe texe c'o me na zö 'ñe me na jo c'o mi pë's'i yo jñiñi. ");
INSERT INTO mazNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Cjanu o xipji c'ua va ndörü e Jesús: ―Nu 'ma rí ndüñijõmügue cja ín jmigö rí matcügö, rá da'c'ügö c'ü rí mandague texe cja yo jñiñi yo rrã jí'ts'igö dya, eñe c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Cjanu o ndünrü c'ua e Jesús o xipji c'ü dya jo: ―Nu'tsc'e Satanás, c'ueñe cja ín jmigö. Dya rá ma'tc'ö, na ngueje ya t'opjü o̱ jña Mizhocjimi c'ü rá ndüñijõmüjme rá ma't'üjme Mizhocjimi c'ü ngue ín Jmuji. Y nguextjo angueze rá pëpijme, enzgöjme c'ü. Nguec'ua, dya rá ma'tc'ö, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nuc'ua c'ü dya jo o c'ueñe cja e Jesús. Cjanu o ẽ c'ua c'o anxe o 'ñe mbös'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","E Herodes ya vi manda o ngot'üji a pjörü e Juan. Nuc'ua 'ma o mbãrã e Jesús c'ü ya ma o'o a pjörü e Juan, cjanu o nzhogü o matjo c'ua a ma cja c'e xoñijõmü a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O zät'ä cja c'e jñiñi a Nazaret. Cjanu o mbedye c'ua nu, o ma a ma cja c'e jñiñi a Capernaum, o ma mimi nu. Nu c'e jñiñi bëxtjo mi järä cja c'e zapjü nu ja mi tjorü c'o xoñijõmü a Zabulón, 'ñe a Neftalí. ");
INSERT INTO mazNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","'Ma o ma mimi e Jesús a Capernaum, o zädä o̱ jña Mizhocjimi c'ü vi mama c'e profeta Isaías: ");
INSERT INTO mazNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ra bübü jya's'ü cja c'o xoñijõmü a Zabulón 'ñe a Neftalí. Xo ra bübü jya's'ü texe nu ja cjogü c'e 'ñiji c'ü ni ma cja c'e tazapjü, 'ñe texe cja c'e xoñijõmü c'ü tizhi lado a manu cja c'e ndare a Jordán. Texe a ma a Galilea nu ja dya pãrãji Mizhocjimi, ra bübü jya's'ü nu. ");
INSERT INTO mazNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","C'o nte c'o mi nzhodü cja bëxõmü, o jñandaji jya's'ü c'ü me na nojo. Nu c'o mi cãrã c'ua ja na bëxõmü c'ua ja tũji, o zät'ä o jya's'ü o̱ jmiji, eñe c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nuc'ua ndeze 'ma o mbürü o mimi e Jesús a Capernaum, o mbürü o zopjü c'o nte, o xipjiji: ―Jyëziji c'o na s'o, ra nzhogü in mün'c'eji cja Mizhocjimi, na ngue ya ngue ra manda nu c'ü o 'ñeme Mizhocjimi a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","'Na nu pa'a, mi nzhodü e Jesús a jmi c'e zapjü a Galilea. O jñanda c'ua yeje bëzo c'o ma pät'ä o̱ rrevi cja c'e zapjü. C'o bëzo mi cjuarma c'o. C'ü 'naja mi chjũ e Simón Pedro. C'ü nu cjuarma mi chjũ Andrés. Anguezevi mi mbëjmõvi. ");
INSERT INTO mazNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Cjanu o mama c'ua e Jesús o xipjivi: ―Nu'tsc'evi i̱ṉ mbëjmõguevi dya. Pero chjünt'üvi ín xütcjö rá mö dya, rá jí'ts'ivi rí zopjüvi yo nte ngue c'ua anguezeji xo ra ndünt'üji ín xütjügö, embevi. ");
INSERT INTO mazNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jo ni zogüvi c'ua c'o o̱ rrevi, cjanu o ndünt'üvi c'ua o̱ xütjü e Jesús, o möji. ");
INSERT INTO mazNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Xe go mötji mas a xo'ñi. E Jesus o jñanda c'ua xe ndo yeje bëzo c'o xo mi cjuarmavi. Mi chjũ Jacobo 'ñe e Juan, c'o mi ngue o̱ t'i e Zebedeo. Ma bübüvi cja 'na bü'ü co e Zebedeo c'ü nu tatavi, ma jocüji c'o o̱ rreji. Nuc'ua e Jesús o ma't'üvi. ");
INSERT INTO mazNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Anguezevi ixco zogüvi c'ua c'e bü'ü 'ñe c'ü nu tatavi, ixco ndünt'üvi c'ua o̱ xütjü e Jesús o möji. ");
INSERT INTO mazNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Mi nzhodü e Jesús texe a ma a Galilea, mi xöpü c'o nte cja c'o o̱ nintsjimi anguezeji. Y mi xipjiji o̱ jña Mizhocjimi; mi xipjiji ja rvá manda nu c'ü vi 'ñeme Mizhocjimi a jens'e. Y mi jocü c'o pje nde ma ngueme c'o mi sufre c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Me mi näntji e Jesús c'ü mi jocü c'o mi sö'dyë. Nguec'ua xo zät'ä c'e jña texe a ma cja c'e xoñijõmü a Siria, o dyäräji c'o mi cja e Jesús. Nguec'ua ma sinpiji texe c'o mi sö c'o pje nde ma ngueme. Xo ma sinpiji c'o me mi sufre; ngue c'o vi zürü o̱ s'ondajma c'ü dya jo, 'ñe c'o mi sürü o̱ taque, xo 'ñe c'o dya mi sö ro 'ñõmü. E Jesús mi jocü texe c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","O mbedye na puncjü nte a Galilea, 'ñe a Decápolis, 'ñe a Jerusalén, 'ñe cja c'o 'ñaja jñiñi c'o tsja a Judea, 'ñe texe a ma 'nanguarü cja c'e ndare a Jordán, mi pöji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nuc'ua 'ma o jñanda e Jesús c'o nte c'o ma puncjü, cjanu o ma c'ua cja 'na t'eje o mimi c'ua nu. Cjanu o ẽ c'ua c'o ya mi ätpä o̱ jña e Jesús c'o mi xiji discípulo, o säji cja jmi angueze. ");
INSERT INTO mazNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nuc'ua e Jesús o mbürü o xöpü c'o o̱ discípulo, o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Cãrã o nte c'o pãrã c'ü dya ni muviji, y ni jyodüji Mizhocjimi c'ü ra mbös'üji. Zö a cjanu c'o, pero ngue nu rguí mäji na ngueje ya ngue o̱ Jmuji dya Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Cãrã o nte c'o me ndumü. Pero zö ga cjanu ga sufreji, ngue nu rguí mäji nu, na ngueje ra unü Mizhocjimi c'ü rguí mäji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Cãrã o nte c'o dya cjapü na nojo, unü o̱ mü'büji ra dyätäji Mizhocjimi. 'Ma cjó c'o ra nguijñi a cjanu 'na pjeñe, ngue nu rguí mäjä, na ngueje Mizhocjimi ra unü ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Cãrã o nte c'o me ne o̱ mü'bü ra tsja c'o na jo. 'Ma ga cjanu, ngue nu rguí mäji nu, na ngueje ra unü Mizhocjimi c'ü rguí tsjaji c'o na jo. ");
INSERT INTO mazNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Cãrã o nte c'o juentse nu minteji ga mbös'üji. Nu c'o juentse a cjanu nu minteji, xo sö ra mäji na ngueje Mizhocjimi ra juentse anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’'Ma cjó c'o ra 'ñejme Mizhocjimi co texe o̱ mü'bü, ngue nu rguí mäjä c'o, na ngueje ra mbãrãji na jo ja ga cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’'Ma cjó c'o ra zopjü na jo yo nu minteji ngue c'ua ra pötca nuji, ngue nu rguí mäjä c'o, na ngueje ra 'mãrãji ngue o̱ t'i Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’'Ma cjó c'o ra tsja na jo, bübü c'o ra nu'u na ü, ra tsjapüji ra sufre. Pero ngue c'ü rguí mäjä c'ü, na ngueje Mizhocjimi ya ngue o̱ Jmu c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Nu'tsc'eji i̱ṉ ejmezügöji dya. Nguec'ua bübü 'ma ra zanc'eji, ra ndäc'eji, ra xo'sc'eji o bëchjine rga zanc'eji texe c'o me rrã s'o. Pero rí xi'tsc'öji, zö ra tsja'c'eji a cjanu, nguejyo rgui mäcjeji yo. ");
INSERT INTO mazNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nguec'ua 'ma ra tsja'c'eji a cjanu, rí mäcjeji na puncjü. Na ngueje Mizhocjimi ra dya'c'eji c'ü me na jo a jens'e. C'o profeta c'o mi cãrã mi jinguã xo o tsjapüji o sufreji, pero ya ch'unüji dya c'o me na jo, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","O sido o ña e Jesús o xipji c'o o̱ discípulo: ―O õ'õ, üt'üji cja o jmõ, ngue c'ua dya ra s'odü. Je xo rga cjatsc'eji nu, rí tsjaji na jo ngue c'ua dya nda rrã s'o cja ne xoñijõmü. Nu 'ma dya cja rga õxü o õ'õ, ¿ja rgá sö xe ra õxcü 'ma? Dya cja rguí muvi 'ma c'o, ra mbozüji a tji, ra yödü yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nu'tsc'eji nza cjatsc'eji o jya's'ü cja yo nte. 'Naja jñiñi c'ü je jäs'ä cja 'naja t'eje, dya sö ja ra tsjõ c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Je xo ga cjatjonu, 'ma tjütüji 'naja sivi, dya co'büji cja 'naja caja. Je ẽ's'ẽji nu ja na ts'ijens'e, ngue c'ua ra sö ra jñanda texe c'o ri cãrã cja c'e ngumü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Je xo rga cjatsc'eji nu, rí tsjagueji na jo cja yo nte, ngue c'ua ra unüji ngüenda c'ü na jo c'o i̱ṉ cjagueji. Nguec'ua xo ra mamaji c'ü me na jonte c'ü nin Tatagueji c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","O sido o ña e Jesús o xipji c'o o̱ discípulo: ―I̱ṉ pãrãgueji c'e ley c'ü o dyopjü e Moisés, 'ñe c'o o dyopjü c'o profeta. Pe i̱ṉ cjinncjeji c'ü rvá 'ñe xi'tsc'öji c'ü dya cja ni jyodü rí dyätäji c'o. Pero dya rí tsjijñiji a cjanu. C'ü rvá ẽcjö, ngue c'ü rá cjagö texe c'ua ja nzi ga mama c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na cjuana rí xi'tsc'öji, ni muvi texe yo letra yo bübü cja o̱ ley Mizhocjimi, 'ñe texe yo jña. Zö ra nguins'i ne jens'e 'ñe ne xoñijõmü, pero ot'ü ra zädä texe c'ü mama cja o̱ ley Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ni jyodü rí tsjapüji ngüenda rí tsjaji texe yo o̱ ley Mizhocjimi, zö ri ts'iquë c'e jña. Xo ni jyodü rí xöpüji yo nte, rí xipjiji ra tsjaji texe o̱ jña Mizhocjimi. 'Ma jiyö, ra tsja'c'eji c'ü dya rguí muvitsc'eji 'ma ra manda nu c'ü o 'ñeme Mizhocjimi a jens'e. Pero 'ma rí tsjagueji c'ü mama yo o̱ jña Mizhocjimi, 'ñe 'ma je rga cjanu rgui xöpüji yo nte, nu'ma, ra tsja'c'eji ra mbë'tsc'eji na nojo 'ma ra manda nu c'ü o 'ñeme Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","I̱ṉ pãrãgueji ja ga cja yo fariseo 'ñe yo xöpü o̱ jña Mizhocjimi yo xiji xöpüte. Rí xi'tsc'öji ni jyodü c'ü xenda rí tsjagueji na jo, que na ngue anguezeji. 'Ma jiyö, dya ra tsja'c'eji Mizhocjimi a jens'e o̱ ntetsc'eji c'ü ra mandats'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ya i̱ dyäräji o xi'tsc'eji c'o xöpüte c'ua ja va sjipji c'o mi cãrã mi jinguã. O xipjiji a cjava: “Dya rí pö't'ünteji. Nu 'ma cjó c'o ra pö't'ünte, ra mbë's'itsjë o̱ s'ocü 'ma, c'ü rguí tjünpü ngüenda ra sufre.” ");
INSERT INTO mazNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero nutscö rí xi'tsc'öji, 'ma cjó c'o ra ünbü nu minteji, zö dya ra mbö't'ü, ra mbë's'itsjë o̱ s'ocü 'ma, c'ü rguí tjünpü ngüenda ra sufre. Xo rí xi'tsc'öji, nu 'ma cjó c'o ra zo'bü nu minteji ra xipji: “Dya i̱ṉ pãrã pje i̱ṉ cja'a”, ra 'ñembe c'ü, xo ra mbë's'itsjë o̱ s'ocü 'ma c'ü, c'ü rguí tjünpü ngüenda ra sufre. Y 'ma cjó c'o xo ra xipji nu minteji: “Me na s'otsc'e”, ra 'ñembe, ra mbë's'itsjë o̱ s'ocü 'ma c'ü rguí ma sufre cja sivi a linfiernu. ");
INSERT INTO mazNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Bübü 'ma i̱ṉ pöji cja templo i̱ṉ sidyiji 'na animale ra mbö't'üji cja rrũ ndü'tp'üji Mizhocjimi cja c'e arta. Pero 'ma i̱ṉ sätc'eji, nu 'ma i̱ṉ mbeñeji c'ü pje vi tsjapqueji 'naja yo nin minteji, dya xtí unüji c'e animale ra mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","C'ü rí tsjagueji, rí sogueji nu c'ü ni mbeñc'eji Mizhocjimi. Ot'ü rí möji, rí ma dyötqueji c'ü nin minteji ra perdonaotsc'eji. Nuc'ua cja rrĩ 'ñeji c'ua, rí 'ñe unüji c'ü ni mbeñc'eji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’'Ma pje c'o rí tsjapüji na s'o 'naja yo nin minteji, 'ma ra zints'iji cja juesi, rí jo'tp'üji 'ma cja ri pötcjeji cja 'ñiji. 'Ma jiyö ra ma nzhöc'eji nu cja c'e juesi. Nuc'ua c'e juesi ra nzhöc'eji cja c'e mböpjörü. Nuc'ua ra ngo'c'ügueji a pjörü. ");
INSERT INTO mazNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na cjuana rí xi'tsc'öji, dya ra sö rí pedyegueji nu, hasta 'ma cja rí tsjõt'üji texe c'o ri tũgueji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ya i̱ dyäräji o xi'tsc'eji c'o xöpüte c'ua ja va sjipji c'o mi cãrã mi jinguã: “Dya rí tsãgueji o ndixũ.” ");
INSERT INTO mazNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero nutscö rí xi'tsc'öji dya, 'ma cjó c'o ra jñanda 'naja ndixũ y ra nguijñi cja o̱ mü'bü ra tsjavi c'ü na s'o, zö dya ra juntavi, chjëntcjui c'ü ya ri tsãjã o ndixũ, ya tsja na s'o co angueze cja o̱ mü'bü 'ma c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Maco i̱ṉ mamaji ngue in chöji c'ü cja'c'üji rí tsjaji c'o na s'o, jñü'müji 'ma, panaji. Xenda na jo rí sätc'eji cja jmi Mizhocjimi zö ri 'natjo in chöji, que na ngue ra pantc'aji texe in cuerpoji a ma a linfiernu. ");
INSERT INTO mazNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Maco i̱ṉ mamaji ngue in jodyëji c'ü cja'c'ü rí tsjaji c'o na s'o, dyocüji 'ma, panaji. Xenda na jo rí sätc'eji cja Mizhocjimi zö ri 'natjo in dyëji, que na ngueje ra pantc'aji texe in cuerpoji a ma a linfiernu. ");
INSERT INTO mazNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","O sido o ña e Jesús o xipji c'o o̱ discípulo: ―I̱ṉ pãrãgueji c'ü xo mamaji mi jinguã: “'Ma cjó c'o ne ra mbëzi nu su, ra unü o xiscõmü c'ü rguí jyanbüvi.” ");
INSERT INTO mazNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero nutscö rí xi'tsc'öji, dya cjó ra mbëzi nu su, nguextjo 'ma ri 'ñe 'naja bëzo. Zö dya ri cja na s'o 'na ndixũ pero 'ma ra tsja nu xĩra ra mbëzi, pe ra tsja c'e ndixũ ra chjüntui c'ü 'naja bëzo. Nguec'ua chjëntjui c'ü ri tsãjã bëzo c'e ndixũ. Nguec'ua c'e bëzo c'ü o mbëzi c'ü nu su, ri pë's'i nu s'ocü 'ma c'ü, chjëntjui c'ü ro tsjapü o̱ su ro tsãjã bëzo. Y c'e bëzo c'ü na yeje o̱ xĩra c'e ndixũ, xo ri pë's'i nu s'ocü chjëntjui c'ü ro tsãjã ndixũ. Na ngueje ya rguí chjüntui c'e ndixũ c'ü ya vi bëzi. ");
INSERT INTO mazNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ya i̱ dyäräji c'ü o xi'tsc'eji c'o xöpüte c'ua ja va sjipji c'o mi cãrã mi jinguã: “Dya rí ñädäji Mizhocjimi rí mamaji na cjuana, cja rrĩ mamaji o bëchjine. 'Ma i̱ṉ nädäji Mizhocjimi c'ü rí tsjagueji, tsjagueji 'ma”, eñe c'o xöpüte. ");
INSERT INTO mazNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero nutscö rí xi'tsc'öji, dya pje rí ñädäji. Dya rí manji nza mbãrã a jens'e. Na ngueje nguejnu manda Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni xo rí mamaji nza mbãrã ne xoñijõmü. Na ngueje ngue Mizhocjimi c'ü manda yo cãrã va. Ni xo rí mamaji nza mbãrã a Jerusalén. Na ngueje ngue c'ü o̱ ndajñiñi c'ín Jmugöji c'ü pjëzhi me na nojo. ");
INSERT INTO mazNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni xo rí mamaji nza mbãrã in ñigueji, na ngueje nu'tsc'eji, dya sö rí tsjapqueji c'ü rrã t'öxü ne rí 'na in ñixtegueji, ni xo ri tsjapqueji c'ü rrã potjü. ");
INSERT INTO mazNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","C'ü rí tsjagueji, rí mantji “jã” o “jiyö.” 'Ma xe rí mangueji cjó nza ärä, nu'ma, ngueje c'ü dya jo c'ü 'ñünnc'ü in mün'c'eji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ya i̱ dyäräji c'ua ja va sjipji c'o mi cãrã mi jinguã: “Nu 'ma cjó c'o ra jñü'pc'üji in chöji, rí nzhopcüji rí jñü'pc'üji a nzhö 'ma c'ü. Y nu 'ma cjó c'o ra jñü'pc'üji in s'ibiji, xo rí jñü'p'üji o̱ s'ibi 'ma c'ü”, mi eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero nutscö rí xi'tsc'öji, dya cjó rí nzhopcüji c'o ra tsja'c'üji c'o na s'o. Nu 'ma cjó c'o ra mbë'chc'iji in jojmiji, xo rí pjünbütjoji 'ma c'ü 'nanguarü ra mbë'chc'iji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nu 'ma cjó c'o ne ra jyonnc'eji o chũ, y ra zints'iji cja juesi ngue c'ua ra ngannc'aji c'o ri jegueji, xo rí jyëtspiji c'o ri tëgueji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nu 'ma cjó c'o ra xi'tsc'eji: “Chuns'ü yo rvá tuns'ügö, ma sogüzügö 'na kilometro nde”, ra 'ñentsc'eji, nu'tsc'eji xe rí ma sogüji 'ma c'ü xe 'na kilometro nde. ");
INSERT INTO mazNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Cjó c'o pje ra dyö'tc'ügueji, rí unüji. Y c'o pje c'o ra pe'sc'eji, dya xo rí tsänbäji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ya i̱ dyäräji c'ua ja va sjipji c'o mi cãrã mi jinguã: “Rí s'iyagueji yo in dyocjeji, pero c'o nuc'üji na ü, xo rí ñuji na ü”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero nutscö rí xi'tsc'öji, rí s'iyagueji c'o ra nuc'üji na ü, rí ma'tp'üji Mizhocjimi c'o ra zanc'eji. Tsjapqueji na jo c'o ra nuc'üji na ü, dyötpüji Mizhocjimi c'o ra jyonnc'eji o chũ, 'ñe c'o ra jñü'c'ügueji na ü. ");
INSERT INTO mazNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","'Ma rí tsjapüji na jo a cjanu yo nin minteji, zö rrã s'oji, ra jñu'sc'eji 'ma c'ü nin Tataji c'ü bübü a jens'e. Na ngueje angueze cjapü ra mbes'e e jyarü c'ü rguí jñanda texe yo nte, zö ri cja na jo, o zö ri cja na s'o. Xo va penpe o dyebe texe yo nte, zö ri cja na jo, o zö ri cja na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nu 'ma nguextjo c'o s'iyats'ügueji c'o rí s'iyagueji, ¿cjo ra dya'c'eji Mizhocjimi c'o na jo 'ma? Iyö. ¿Cjo dya je xo ga cjanu ga tsja c'o publicano, s'iya o̱ dyoji c'o; maco i̱ṉ mangueji me na s'o c'o? Jã, je ga cjanu ga tsjaji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nu 'ma nguextjo yo in dyocjeji yo i̱ṉ ne rí zenguaji, ¿ja bübü c'ü na jo c'ü i̱ṉ cjagueji 'ma? Maco yo dya pãrã Mizhocjimi, je xo ga cjatjonu, nguextjo c'o o̱ dyoji zenguaji. ");
INSERT INTO mazNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nguec'ua rí xi'tsc'öji, rí s'iyagueji texe yo nte c'ua ja nzi ga tsja c'ü nin Tatagueji c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’C'ü rgui tsjagueji c'o na jo, dya ngue c'ü ra jñantc'aji yo nte ra mamaji i̱ṉ cjaji na jo; ngue c'ü ra jñantc'aji c'ü in Tatagueji c'ü bübü a jens'e. Na ngue 'ma rí tsjaji na jo nguextjo c'ü rguí jñantc'aji yo nte, nu'ma, dya ra mama c'ü in Tatagueji c'ü na jo vi tsjagueji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Bübü nte c'o cjapü cja na jo; cjaji c'ü rguí mäpäji yo nte'e. Nguec'ua 'ma pöji nu ja cjogü na puncjü o nte, nza cja cja nintsjimi o cja 'ñiji, unüji o merio c'o dya pje pë's'i. Pero rí xi'tsc'öji c'ü na cjuana, zö ra mama yo nte na jonteji, pero Mizhocjimi dya ra mama na jonteji. Nu'tsc'eji, dya rí tsjaji nza cja anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero 'ma rí unüji merio c'o dya pje pë's'i, rí unüji c'ü dya cjó ra mbãrã. ");
INSERT INTO mazNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nguec'ua dya cjó ra mbãrã c'ü i̱ unügueji. Pero Mizhocjimi ra dya'c'eji c'o na jo, na ngueje angueze pã'tc'ãji in mün'c'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’C'o cjapü cja na jo, me ne o̱ mü'büji c'ü ra jñanda yo nte. Nguec'ua pöji cja nintsjimi, 'ñe c'ua ja pomü o 'ñiji, ni ma dyötüji Mizhocjimi. Pero rí xi'tsc'öji c'ü na cjuana, zö mama yo nte me na jonteji, Mizhocjimi dya ra mama na jonteji. Nu'tsc'eji, dya rí tsjaji nza cja anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","C'ü rí tsjaji, 'ma rí dyötqueji Mizhocjimi, rí tsjogüji a mbo cja in nzungueji, cja rrĩ tsotc'eji in nzoxtjiji. Cja rrĩ dyötqueji c'ua c'ü nin Tataji c'ü bübü nu ja dya cjó sö ra jñanda. Y angueze ra dya'c'eji c'o na jo'o, na ngueje pã'tc'ãji in mün'c'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’'Ma rí dyötqueji Mizhocjimi, dya rí tsjagueji c'ua ja nzi ga tsja yo nte yo dya pãrã Mizhocjimi. Anguezeji me yepeji c'o jña c'o ni dyötüji Mizhocjimi, pëzhiji ra dyärä Mizhocjimi na ngueje c'ü me yepeji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nguec'ua rí xi'tsc'öji, dya me rí yepegueji jña c'ua ja nzi ga tsja anguezeji. Na ngueje c'ü nin Tataji pãrã c'o ni jyonc'eji ante c'ü rí dyötqueji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nguec'ua nu'tsc'eji 'ma rí dyötqueji Mizhocjimi, rí xipjiji a cjava: Mi Tatats'ügöjme, je i̱ṉ bübü a jens'e, rí pjöxcüjme nutscöjme rí cãrãjme cja ne xoñijõmü, ngue c'ua rá sũc'üjme ja c'o nzi ga zũc'ü c'o cãrã a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Xo rí pjöxcüjme ngue c'ua dya ra mezhe ra zädä c'ü rá ä'tc'öjme ja c'o nzi ga dyä'tc'ä c'o cãrã a jens'e, na ngue ngue'tsc'e i̱ṉ mandague. Xo rí ö'tc'öjme rá cjajme c'ua ja nzi gui ñegue. ");
INSERT INTO mazNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dyacöjme dya o xëdyi c'o rá sigöjme ne pa dya. ");
INSERT INTO mazNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Perdonaozügöjme ín nzhubüjme c'ua ja nzi rgá perdonaojme 'ma cjó c'o pje cjacüjme. ");
INSERT INTO mazNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dya rí jyëzgue ra ndöcöjme c'ü dya jo. Pjöxcüjme ngue c'ua dya rá cjajme c'o na s'o. Na ngueje ngue'tsc'e i̱ṉ mandague, ngue'tsc'e me na zë'tsc'e, ngue'tsc'e me na notsc'e. Je ga cjatjotsc'e nu textjo c'o cjë c'o ra ẽjẽ. Amén. ");
INSERT INTO mazNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Nu 'ma rí perdonaogueji c'ü cjó pje ra tsja'c'eji, xo ra perdonaots'üji 'ma c'ü nin Tataji c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero 'ma dya rí perdonaogueji c'ü cjó pje ra tsja'c'eji, dya xo ra perdonaots'üji 'ma c'ü nin Tatagueji, nu c'o pje nde i̱ṉ cjagueji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Bübü c'o cjapü cja me na jo. Nguec'ua 'ma go mbempjeji, cjapü ndumüji, dya xo dyebeji. Je ga tsjaji a cjanu, ngue c'ua ra mbãrã yo nte c'ü mbempjeji, ra mamaji na jo c'ü cjaji. Na cjuana rí xi'tsc'öji, zö ra mama yo nte c'ü na jo cjaji, pero Mizhocjimi dya je ra mama a cjanu. Nu'tsc'eji, dya rí tsjagueji ga cjanu. ");
INSERT INTO mazNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nu 'ma rí mbempjeji, rí xinzhöji c'ua ja nzi gui tsjaji texe yo pa. Xo rí tsã't'ãji o aceite in ñi'iji, y rí dyebeji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nguec'ua dya ra mbã'c'ãji yo nte cjo i̱ṉ mbempjeji. C'ü ra mbãrã c'ü i̱ṉ mbempjeji, nguextjo c'ü nin Tataji c'ü dya cjó sö cjó ra jñanda. Y angueze ra xi'tsc'eji c'ü na jo vi tsjagueji, na ngueje pã'tc'ãji in mün'c'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Dya rí pë'sc'eji na puncjü c'o ni muvi cja ne xoñijõmü. Na ngueje ne xoñijõmü cãrã o dyoxü, ra dyo'tc'ügueji c'o in ch'opjüji 'ñe in bitugueji. Y xo ra zijõmü c'o in merioji de plata. Xo cãrã va o mbuẽ, ra xo'tc'ügueji in nzungueji, cja rrũ põnnc'üji c'o i̱ṉ pë's'iji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Jyodügueji ja rgá mbë'sc'iji a jens'e c'o ya ri bübü 'ma rí sätc'eji nu. Na ngueje a jens'e, dya cãrã o dyoxü nu, nu c'ü ra dyo'tc'eji c'o ri pë's'iji, ni pje xo ra zijõmü nu. Dya xo cãrã o mbuẽ nu, c'ü ra põnnc'ügueji c'o ri pë's'igueji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nu 'ma rí pë's'igueji na puncjü cja ne xoñijõmü, je ri mäjä in mü'büji cja ne xoñijõmü. Pero 'ma ra bë'sc'eji na puncjü a jens'e, je ngue a jens'e nda ra mäjä in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","’C'ü unü jya's'ü cja in cuerpogueji ngue in chöji. 'Ma janda na jo 'na nte, bübü jya's'ü 'ma texe o̱ cuerpo. Pero 'ma dya sö ra jñanda, chjëntjui c'ü ri bübü cja bëxõmü 'ma c'e nte. Je xo ga cjatsc'eji nu. Nu 'ma nguextjo Mizhocjimi rí jyodüji, ra bübü 'ma jya's'ü texe cja in mü'bügueji. Pero 'ma rí jyodüji Mizhocjimi, 'ñe rí jyodüji rí pë's'iji na puncjü cja ne xoñijõmü, 'ma rí jyodüji nza yeje, nu'ma, dya nda ra bübü jya's'ü in mü'büji. Y 'ma i̱ṉ pëzhgueji bübü jya's'ü in mün'c'eji, nu 'ma dya cjuana jya's'ü, nu'ma, ojtjo jya's'üts'üji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’'Ma cjó c'o ra mbëpi yeje lamu, dya ra sö ra dyätävi nza yejui. Na ngueje c'ü 'naja ri ünbüji, ra tsja c'e mbëpji; c'ü 'naja ri ne'e. O 'ma jiyö, 'naja c'ü ri cjapü dya rguí muvi. Je xo ga cjatsc'eji nu, 'ma i̱ṉ jodüji ja rgui pë's'iji na puncjü cja ne xoñijõmü, nu'ma, dya i̱ṉ pëpqueji 'ma Mizhocjimi c'ua ja nzi ga ne angueze. ");
INSERT INTO mazNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Nguec'ua rí xi'tsc'öji, dya rí tsjijñiji ja rgui chöt'üji c'ü rí siji. Dya xo rí tsjijñiji c'ü pje rí jyeji. Mizhocjimi me na nojo, ya ngambgaji va. Nadya, ¿cjo dya xo ra dya'c'eji c'ü rí siji, 'ñe c'ü rí jyegueji? ");
INSERT INTO mazNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jñant'maji yo s'ü. Dya podüji o ndëxü, dya xo tagüji, dya pje xo üt'üji cja t'ujmü; maco c'ü nin Tatagueji c'ü bübü a jens'e nde 'huiñi yo. Nu'tsc'eji, xenda ni muvits'ügueji na puncjü que na ngue yo s'ü. Nguec'ua, ¿cjo dya xo ra 'huiñtsc'eji Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Cjó bübütsc'eji c'ü sö ra chäcä nde metro c'ü xe rrã ndã'ã? Zö me ra nguijñi, dya cjó ra sö. ");
INSERT INTO mazNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Nguec'ua, ¿jenga i̱ṉ cjinncjeji ja rí chöt'üji c'ü rí jye'eji? Unüji ngüenda yo pje c'o ma ndäjnä yo cja'a cja juajma, ja ga te'eji. Dya pëpjiji, dya xo jench'eji o tjüjmü pa ra dyät'äji o̱ bituji. Pero me na zö yo. ");
INSERT INTO mazNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","E Salomón mi pjëzhi na nojo, mi je o̱ bitu c'o me ma zö. Pero xenda na zö yo ndäjnä. ");
INSERT INTO mazNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yo pjin'ño cja'a cja juajma dya, pero ra xõrü ra münü ra c'ant'a cja hornu ra ndüt'üji yo; maco Mizhocjimi unü c'ü na zö o̱ ndäjnä yo. Natsc'eji, ¿cjo dya xo ra dya'c'eji Mizhocjimi c'ü rí jyegueji? Nguec'ua, ¿jenga dya i̱ṉ ench'eji na jo in mü'büji Mizhocjimi ra dya'c'eji c'o ni jyonc'eji? ");
INSERT INTO mazNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nguec'ua rí xi'tsc'öji, dya me rí tsjijñiji rí mamaji: “Pãrã, ¿pje rá sigöji, o pje xo rá jegöji?”, rí 'ñeñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ngue yo dya pãrã Mizhocjimi yo me jodü ga cjanu. Pero nu'tsc'eji i̱ṉ 'ñejeji c'ü nin Tataji c'ü bübü a jens'e; angueze pãrã c'ü nde ni jyonc'eji texe yo. ");
INSERT INTO mazNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nu'tsc'eji ot'ü rí jyodüji Mizhocjimi, ngue c'ua ra mandats'üji. Y rí jyodüji rí tsjaji c'o na jo c'ua ja ga manda c'ü. Nuc'ua texe yo, nde ra dya'c'eji yo. ");
INSERT INTO mazNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nguec'ua, dya rí tsjinncjeji ja rgui chöt'üji c'ü rí siji 'ñe c'ü rí jyeji c'o pa c'o va ẽjẽ. 'Ma ra zädä c'o pa'a, cja rí ñuji ja rgui tsjapqueji. Na ngueje pama va ẽjẽ texe o ndumü c'ü ni jyodü rá sufregöji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Dya cjó rí so'bügueji. 'Ma jiyö ra jñün'c'ügueji ngüenda Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","C'ua ja nzi gui so'bütegueji, je xo rga cjanu rgá jñün'c'ügueji ngüenda Mizhocjimi. Mizhocjimi ra nzhocüts'üji c'ua ja nzi gui tsjagueji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","O dyaxü, xenda na nojo que na ngue o ngümpaxa. Je xo ga cjatjonu in nzhunc'eji. Pe na nojo in nzhunc'eji nza cja 'na dyaxü, y pe ts'iquë nza cja 'naja ngümpaxa c'o o̱ nzhubü yo nin minteji. Nguec'ua, ¿jenga i̱ṉ so'büji c'e ngümpaxa c'ü o'o a nzhö yo nin minteji? Maco dya i̱ṉ cö'tp'üji 'ñi c'e dyaxü c'ü o'o in chöji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Ja rgá sö rí xiqueji yo nin minteji: “Jyëzguijme rá cjü'pc'öjme ne ngümpaxa nu o'o nin chögue”, rí 'ñembeji? Maco dya ixi cjübügueji c'e dyaxü c'ü o'o in chögueji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nu'tsc'eji i̱ṉ cjapqueji c'ü na jotsc'eji, pero dya cjuana. C'ü rí tsjagueji, ot'ü rí tsjünc'eji c'e dyaxü c'ü o'o in chögueji, ngue c'ua ra sö rí jñandaji na jo rí tsjü'p'üji c'e ngümpaxa c'ü o'o a nzhö'ö c'ü nin minteji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Bübü nte c'o chjëntji nza cja o cuchi c'o ra yödü c'o pje ri unügueji c'o dya ri ne anguezeji. Xo chjëntji nza cja o dyo c'o ra ẽ ra 'ñe zac'eji 'ma pje c'o ri unügueji c'o dya ri neji. C'o nte c'o ga cjanu, dya cja xe rí zopjüji o̱ jña Mizhocjimi nu me na sjũ. ");
INSERT INTO mazNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Sido rí dyötqueji Mizhocjimi, ra dya'c'eji. Sido rí jyodüji Mizhocjimi, rí chötc'eji c'ü ni jyonc'eji. Sido rí ma't'üji Mizhocjimi, ra dyä'tc'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Na ngue texe c'o ra dyörü, ra ch'unü c'o. Y texe c'o ra jyodü, ra chöt'ü c'o. Y texe c'o ra mapjü, ra dyätäji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Nu'tsc'eji i̱ṉ 'ñecjeji in ch'igueji, 'ma ra chëzhi in jmiji in ch'igueji ra dyö'tc'eji 'na tjõmëch'i, ¿cjo rí unügueji 'na ndojo? Iyö, dya sö. ");
INSERT INTO mazNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Y 'ma ra dyö'tc'eji 'na jmõ'õ, ¿cjo rí unügueji 'na c'ijmi? Iyö, dya xo sö'ö. ");
INSERT INTO mazNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Maco i̱ṉ nteji i̱ṉ cjaji c'o na s'o, pero i̱ṉ pjëchiji rí unüji c'o na jo yo in ch'igueji. Na c'ü nin Tatagueji c'ü bübü a jens'e, ¿cjo dya xo ra dya'c'eji c'o na jo c'o rí dyötüji angueze? ");
INSERT INTO mazNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’C'ua ja nzi gui ñegueji c'ü ra s'iyats'üji yo nte, je xo ga cjanu rgui s'iyagueji yo. Na ngueje je ga cjanu ga mama o̱ jña Mizhocjimi c'ü xiji ley 'ñe profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Nu 'ma i̱ṉ ne rí nzhodüji cja o̱ 'ñiji Mizhocjimi, tsjogüji cja c'e ts'ingoxtji. Na ngueje bübü 'na ngoxtji, 'ñe 'na 'ñiji c'o me na mbät'ä, pero ni zidyji nu ja ra sufreji cja sivi. Me na puncjü c'o cjogü cja c'e ngoxtji c'ü na mbät'ä. ");
INSERT INTO mazNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero c'e 'ñiji c'ü ni zidyiji nu ja ra bübütjoji co Mizhocjimi, na s'ich'i c'ü. Xo 'ñe c'e ngoxtji, xo s'ich'i c'ü. Y dya puncjü c'o töt'ü c'e ngoxtji c'ü rguí möji c'e 'ñiji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Cãrã nte c'o ra ẽtsc'eji ra 'ñe tsjapü ri ñaji o̱ jña Mizhocjimi. Cjapüji na jo'oji nza cja ndënchjürü yo dya pje cja, pero a mbo o̱ mü'büji me na s'oji nza cja o min'ño yo me na sate. Nguec'ua rí pjötpüji ngüenda c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","C'ü rgui pãrãgueji c'o xöpüte, rí unnc'eji ngüenda ja ga mimi c'o. I̱ṉ pãrãgueji o visachi, dya quitsiji o uva c'o. Ni xo ri quitsiji o higo cja o bimpëdyi. Je xo ga cjatjonu c'o xöpüte c'o cjapü ri ña o̱ jña Mizhocjimi, dya sö ra mimi na jo c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Je xo ga cjatjonu texe o za'a c'o na jo, quis'i c'o na jo c'o. Pero c'o dya ga jo, quis'i c'o dya ga jo. ");
INSERT INTO mazNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'Na za'a c'ü na jo, dya sö ra nguis'i c'o dya ga jo. Ni xo ri ngue 'na za'a c'ü dya jo, dya sö ra nguis'i c'o na jo. ");
INSERT INTO mazNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Texe za'a c'o dya quis'i c'o na jo, ra dyëziji cja rrũ pant'aji a sivi. ");
INSERT INTO mazNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nguec'ua c'ü rgui pãrãgueji c'o xöpüte, rí unnc'eji ngüenda ja ga mimi c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Na puncjü c'o ra xitscö: “Nu'tsc'e ín Jmuts'ügö”, ra 'ñenzgöji. Pero dya texeji ra cjogüji c'ua ja manda Mizhocjimi. C'o ra cjogü nu, nguextjo c'o ra tsja c'ua ja nzi ga ne c'ü mi Tatagö c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","'Ma ra zädä c'e pa 'ma ra tjün ngüenda, me na puncjü c'o ra xitscö: “Nu'tsc'e ín Jmuts'ügö, ¿cjo dya mi nännc'äjme in chjũgue, 'ma mi zopcjöjme yo nte? ¿Cjo dya xo mi nännc'öjme in chjũgue 'ma mi pjongüjme o s'ondajma? ¿Cjo dya xo ngue co in chjũgue c'ü mi jocüjme c'o mi sö'dyë, 'ñe c'o na puncjü c'o na nojo c'o mi cjajme?”, ra 'ñenzgöji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nuc'ua rá tjüntcöji c'ua, rá xipjiji: “Dya ngue o̱ t'itsc'eji mi Tatagö. C'ueñeji cja ín jmigö dya, nu'tsc'eji i̱ tsjagueji c'o na s'o”, rá embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Nguec'ua, nu c'ü ra dyärä yo jña yo ró xi'tsc'öji dya, y ra tsja'a yo, rá jyëtspigö nza cja 'na bëzo c'ü na jo va mbeñe. O jyäbä 'naja ngumü a xes'e cja 'na peña. ");
INSERT INTO mazNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Go 'ñeje c'ua 'na tadyebe. Xo ẽjẽ 'na tareje c'ü je 'ne pjat'ü cja c'e ngumü. Xo ẽ 'na tandajma c'ü me mi vü'ü cja c'e ngumü. Pero dya go tunü c'e ngumü, na ngueje vi tjäbä a xes'e cja c'e peña. ");
INSERT INTO mazNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","'Ma cjó c'o ra dyärä yo jña yo ró xi'tsc'öji dya, 'ma dya ra tsja c'ua ja nzi va dyärä, rá jyëtspigö nza cja 'na bëzo c'ü dya nguijñi na jo c'ua ja ro jyäbä o̱ ngumü, je go jyäntjo cja 'ñõxõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Go 'ñeje c'ua 'na tadyebe. Xo ẽjẽ c'e ndare. Xo vü e ndajma c'ü o juant'a c'e ngumü. Jo nu tunü c'ua o̱ ngumü c'e bëzo, ixco chjorü, eñe e Jesús va nguarü va zopjüji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","'Ma o nguarü e Jesús o mama yo jña yo, me mi sũji, dya mi pãrã pje ro nguijñiji. ");
INSERT INTO mazNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Na ngueje o unüji ngüenda je vi 'ñe cja Mizhocjimi c'o vi mama e Jesús va xöpü anguezeji. Y dya je ma cjanu c'o xöpüte. ");
INSERT INTO mazNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nuc'ua o zöbü e Jesús cja c'e t'eje. Xo zöbü na puncjü o nte, mi pöji angueze. ");
INSERT INTO mazNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","O ẽjẽ c'ua 'naja bëzo c'ü mi sö 'naja ngueme c'ü xiji lepra, o 'ñe chëzhi cja e Jesús. Cjanu o ndüñijõmü c'ua a jmi, cjanu o xipji: ―Nu'tsc'e ín Jmuts'ügö, 'ma rí ñegue, ra sö rí jocüzü. ");
INSERT INTO mazNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Cjanu o c'uana c'ua a dyë e Jesús o ndörü c'e nte, o xipji: ―Rí negö. Ra jots'ü. Nzi va ndörü, nzi va ojtjo c'ua c'e ngueme. ");
INSERT INTO mazNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nuc'ua e Jesús o xipji: ―Pjöngüenda c'ü dya cjó rí ma xipjigue dya, nguextjo c'ü rí ma, rí ma jíchitsjë c'e mböcjimi c'ü ya jogüts'ü. Xo rí jñünü c'o rí unü Mizhocjimi c'ua ja nzi va mama e Moisés. Ixtí mague a cjanu ngue c'ua ra nu'tc'ügue c'e mböcjimi c'ü na cjuana ya jots'ü. Nguec'ua yo nte ra mbãrãji c'ü ya 'nin'tsc'i c'e ngueme. ");
INSERT INTO mazNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nuc'ua o zät'ä e Jesús cja c'e jñiñi c'ü mi chjũ Capernaum. Cja c'e jñiñi mi bübü 'naja bëzo c'ü mi manda 'naja ciento o tropa. 'Ma cja ma sät'ä e Jesús, o ẽ c'ua c'e bëzo o 'ñe ndünrü e Jesús. Cjanu o dyötü 'na favor. ");
INSERT INTO mazNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","O xipji: ―Nu'tsc'e ín Jmuts'ügö, dya cja sö ra 'ñõmü ín ch'i'i, ya zürü o ngueme. Ya dyobütjo ín nzungö, y me sufre na puncjü c'o na ü. ");
INSERT INTO mazNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Cjanu o ndünrü c'ua e Jesús o xipji: ―Jo rá magö, rá ma jocü. ");
INSERT INTO mazNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","O ndünrü c'ua c'e bëzo o xipji: ―Nu'tsc'e ín Jmuts'ügö, dya ga jozgö c'ü rí tsjogue a mbo cja ín nzungö. Zö nguextjo 'na jña c'ü rí mangue, ra jogü c'ín ch'i'i. ");
INSERT INTO mazNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na ngue xo 'ñetscö xo ch'acö poder, ngue c'ua rí mandagö o tropa. 'Ma rí xipjigö c'ü 'naja: “Ma'a”, rá embe, ra ma. 'Ma rí xipjigö c'ü 'naja: “Chjä'dä”, rá embe, ra ẽjẽ. Xo 'ñe 'ma rí xipjigö c'ín mbëpji: “Tsja'a yo”, rá embe, ra tsja'a. ");
INSERT INTO mazNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nuc'ua 'ma o dyärä e Jesús c'o vi mama c'e bëzo, me co nguentjo c'ua. Na ngue o unü ngüenda c'ü mi junt'ü o̱ mü'bü c'e bëzo c'ü pje ro mama e Jesús, ro zädä. Nguec'ua va xipji c'ua c'o mi pöji: ―Na cjuana rí xi'tsc'öji, ni ri 'na yo ín menzumüji a Israel ró tötc'ö c'ü ri ejme na jo nza cja ne bëzo nu. ");
INSERT INTO mazNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nutscö rí xi'tsc'öji, na puncjü o nte c'o rguí 'ñeje nu ja ni mbes'e e jyarü, 'ñe nu ja ni nguibi, xo 'ñe textjo cja ne xoñijõmü; ra 'ñe mimiji nu ja manda Mizhocjimi a jens'e, ra zi'iji o xëdyi co e Abraham, 'ñe e Isaac, 'ñe e Jacob. ");
INSERT INTO mazNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero c'o ot'ü vi zojnüji ro cjogü nu ja manda Mizhocjimi, ts'ëtjo c'o go ne. Nguec'ua c'o dya go ne'e, ra mboch'üji nu ja na bëxõmü, nu ja me ra huëji, y me ra nguünxt'ü o̱ s'ibi rgá sufreji na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nuc'ua e Jesús o xipji c'e bëzo c'ü mi manda 'naja ciento tropa: ―Ma dya in nzungue. C'ua ja nzi vi 'ñejmegue, je rga cjanu rgá jogü c'in ch'i'i. Ixco jogü c'ua c'e t'i c'e ndajme c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","O ma c'ua e Jesús cja o̱ ngumü e Pedro. O chöt'ü c'ua c'ü mi sö'dyë c'ü nu to'o e Pedro, mi sö pa'a c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nuc'ua e Jesús cjanu o ndötpü c'ua a dyë. Jo ni c'ueñe c'ua c'e pa'a. Cjanu o nanga c'ua c'e ndixũ o dyät'ä o jñõnü ro ziji. ");
INSERT INTO mazNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nuc'ua 'ma ya vi nguibi e jyarü, o sinpiji e Jesús na puncjü nte c'o vi zürü o̱ ndajma c'ü dya jo. E Jesús, nguextjo c'ü o mama ro mbedye c'o ndajma, y go mbedye c'ua c'o. Y texe c'o mi sö'dyë, o jocü c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nguec'ua ma zädä c'o vi mama c'e profeta Isaías: “Angueze me go juentsqueji o 'ñe jocüzüji c'o ngueme c'o mi sufregöji”, eñe c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ya vi mundo na puncjü nte cja e Jesús. Nguec'ua va ña e Jesús va xipji c'o o̱ discípulo ro dat'üji cja 'na bü, ngue c'ua ro mbes'eji a 'nanguarü cja c'e trazapjü. ");
INSERT INTO mazNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cjanu o sä c'ua 'naja bëzo c'ü mi xöpü c'ü o̱ ley Mizhocjimi c'ü o ẽ xipji e Jesús: ―Xöpüte, rá tjünt'ü in xütcje rá më nu ja c'o rí sätc'e. ");
INSERT INTO mazNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Cjanu o ndünrü c'ua e Jesús o xipji: ―Ante c'ü rá më, ixtí tsjijñi c'ü rá xi'tsc'ö. Yo min'ño bübü o̱ tjocüji, y yo s'ü pë's'i o̱ t'oxüji. Nutscö, zö rvá ẽcjö cja Mizhocjimi pero dya rí pë'sc'ö ja rá oxü, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nuc'ua cjanu o mama c'ua 'naja c'ü mi tjünt'ü a xütjü e Jesús, o xipji: ―Nu'tsc'e ín Jmuts'ügö, dyacö sjëtsi ot'ü rá ma'a, rá ma ögü mi tatagö, cja rrũ mëgövi. ");
INSERT INTO mazNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","O xipji c'ua e Jesús: ―Yo nte, chjëntjui c'ü ya ndũji na ngue dya creozüji. Jyëzgue anguezeji ra dyögüji c'o nín mi añimaji. Nu'tsc'e chjünt'ü ín xütcjö rá mëgövi. ");
INSERT INTO mazNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Cjanu o dat'ü c'ua e Jesús cja c'e bü. Cjanu o möji c'ua c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jo ni vü'ü c'ua 'naja tandajma. Me mi pjö's'ü c'e ndeje ma mbo'o c'e bü'ü. Pero e Jesús ma ĩjĩtjo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nuc'ua c'o discípulo o chëzhiji a jmi e Jesús, o xipjiji: ―Nu'tsc'e ín Jmuts'ügöjme, pjöcöjme para dya rá quibigöjme. ");
INSERT INTO mazNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji, ¿jenga i̱ṉ sũ'ũji? ¿Cjo dya i̱ṉ ejmezügöji c'ü sö rá pjö'c'eji? Cjanu o nanga c'ua e Jesús, cjanu o huënch'i c'e ndajma, 'ñe c'e ndeje. Ixco böbü c'ua c'e ndajma 'ñe c'e ndeje. ");
INSERT INTO mazNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Me co nguijñi c'ua c'o discípulo, mi mamaji: ―¿Pje ma poder c'ü pë's'i ne bëzo nu, nguec'ua ätä e ndajma 'ñe ne ndeje? ");
INSERT INTO mazNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nuc'ua o zät'äji a 'nanguarü cja c'e trazapjü cja c'e lugar c'ü mi chjũ a Gadara. O ẽ c'ua yeje bëzo c'o mi o'o o̱ mü'bü o demonio c'o ngue o̱ dyoji e Satanás c'ü dya jo; o 'ñe chjëji e Jesús. Je vi 'ñejui a nde cja c'o panteón cja campo santo. Me ma s'ovi 'ñe me ma cuëvi, nguec'ua dya cjó mi sö cjó xi ro cjogü cja c'e 'ñiji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nuc'ua c'o demonio o tsjapüji o mapjü na jens'e c'o bëzo va xipjivi e Jesús: ―Jesús, o̱ T'itsc'e Mizhocjimi, ¿pje i̱ṉ pë'sc'ü rí ñugöjme? ¿Cjo vi 'ñecje a 'ñecjua rí ẽ tsjacüjme rá sufrejme dya? Maco dya be sädä c'e pa 'ma ra tjün ngüenda, eñe c'o bëzo va 'ñõ'p'üji o̱ mü'bü c'ü dya jo ro ñavi. ");
INSERT INTO mazNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na jẽ nu ja ma ñõnü na puncjü o cuchi. ");
INSERT INTO mazNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nguec'ua va tsja c'o demonio o dyötüji e Jesús, o xipjiji: ―'Ma rí pjongüzüjme cja o̱ mü'bü yo bëzo, jyëzguijme rá ma quichc'öjme cja yo cuchi. ");
INSERT INTO mazNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Cjanu o mama c'ua e Jesús: ―Pedyeji ma tsich'iji, embeji. Nuc'ua c'o demonio go mbedyeji, go ma nguich'iji cja c'o cuchi. Nuc'ua texe c'o cuchi nde va dacütjoji va zöbüji cja c'e dyä'ä. Go ma jyäji c'ua cja c'e trazapjü. Nzhangua ndũji. ");
INSERT INTO mazNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nuc'ua c'o mi pjörü c'o cuchi go cjuan'diji c'ua, go möji na niji cja c'e jñiñi; o ma cösteji texe c'o vi jñandaji, o xipjiji ja va jogü c'o bëzo c'o vi dyo'o o̱ mü'bü c'o demonio. ");
INSERT INTO mazNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nuc'ua cjanu o mbedye texe c'o mi cãrã cja c'e jñiñi, o ma nuji e Jesús. 'Ma o zät'äji, o xipjiji c'ua e Jesús c'ü pje cjint'o tsja, ro mbedye cja c'ü o̱ jñiñiji. ");
INSERT INTO mazNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nuc'ua cjanu o dat'ü e Jesús cja c'e bü, xo 'ñe c'o o̱ discípulo. Cjanu o mbes'eji a 'nanguarü cja c'e trazapjü, o zät'äji nu cja c'e jñiñi nu ja mi oxü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","O ẽjẽ c'ua ja nzi nte ma siji 'na bëzo c'ü dya mi sö ro 'ñõmü; ma tũji cja 'naja pjinguã. Mi junt'ü o̱ mü'büji c'ü mi sö e Jesús ro jocü c'e bëzo. Nuc'ua 'ma o mbãrã e Jesús c'ü mi ejmeji, o zopjü c'ua c'e bëzo c'ü dya mi sö ro 'ñõmü, o xipji: ―Dya rí sũgue, sẽ'ẽ; ya ró perdonaots'ü dya in nzhunc'e, eñe e Jesús va xipji c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Xo mi cãrã nu, ja nzi xöpüte; o dyäräji e Jesús o perdonao c'e bëzo. Nguec'ua ma nguijñiji o̱ mü'bütsjëji: “Nujne Jesús chjëntjui c'ü o zadü Mizhocjimi nu”, ma nguijñiji. ");
INSERT INTO mazNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ixmi pãrã e Jesús c'o mi cjijñi anguezeji, nguec'ua va xipjiji c'ua: ―¿Jenga i̱ṉ cjijñiji c'o na s'o a mbo cja in mü'bügueji? ");
INSERT INTO mazNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ró xipji ne bëzo: “Rí perdonaots'ü in nzhunc'e”, ró embe, pero dya cjó sö ra mbãrã cjo ya ma o̱ nzhubü. Pero 'ma rá xipji ne bëzo: “Nu'tsc'e, ñanga rí nzhodü”, rá embe; 'ñe 'ma ra nanga c'ua ne bëzo ra nzhodü, ixtí pãrãgueji 'ma c'ü dya rí xi'ts'iji o bëchjine. ");
INSERT INTO mazNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nutscö rvá ẽcjö cja Mizhocjimi, ya ch'acö poder cja ne xoñijõmü rá perdonaots'üji in nzhubüji. Unnc'eji dya ngüenda ngue c'ua rí pãrãji c'ü rí pë'sc'ö c'e poder, embeji. Cjanu o zopjü c'ua c'e bëzo c'ü dya mi sö ro 'ñõmü, o xipji: ―Nu'tsc'e, ñanga, chuns'ü nu i̱ṉ os'ü, ma'a in nzumü, embeji c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","O nanga c'ua c'e bëzo, cjanu o ma c'ua o̱ ngumü. ");
INSERT INTO mazNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nuc'ua c'o nte 'ma mü o jñandaji ja va jogü c'e bëzo, me go nguijñiji c'ua, na ngue nunca mi jandaji a cjanu. Me xo go mamaji me na jo Mizhocjimi, na ngue vi tsja a cjanu vi unü poder cja yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nuc'ua o mbedye nu e Jesús, o cjogü nu ja ma jũ'ũ 'naja bëzo c'ü mi chjũ'ũ e Mateo, c'ü mi cobra o contribución. E Jesús o jñanda c'e bëzo, o xipji: ―Chjünt'ü ín xütcjö rá mëgövi, embe. Ixco böbü c'ua e Mateo o mëvi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","'Na nu pa, ya vi mimi e Jesús a mbo 'na ngumü, ma siji o xëdyi. Go ẽjẽ c'ua na puncjü c'o mi cobra o contribución, c'o mi xiji ma s'onte, xo 'ñe c'o dya mi sũpü o̱ ley c'o menzumü a Israel, nguec'ua xo ma sjiji ma s'oji. O 'ñe ziji o xëdyi co e Jesús, 'ñe c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","C'o fariseo o jñandaji c'ü ma jũji e Jesús c'o bëzo, nguec'ua va xipjiji c'ua c'o o̱ discípulo e Jesús: ―¿Jenga nin xöpütegueji nde si'iji o xëdyi co nujyo cobra o contribución 'ñejyo 'ñaja yo na s'o?, eñe c'o fariseo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","E Jesús o dyärä c'o vi mama c'o fariseo, cjanu o xipjiji c'ua 'na ejemplo: ―Nu c'o dya sö'dyë, dya ni jyodü cjó ra dyät'ä c'o; nguextjo c'o sö'dyë. Je xo ga cjatjonu yo tũ o̱ nzhubü, ngue c'o ni jyodü ra jocüji yo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","I̱ṉ pãrãji o̱ jña Mizhocjimi c'ü mama a cjava: “C'ü ni pötcöji o animal, cja rrĩ päscöji c'o, na jo c'ü. Pero c'ü xenda rí negö, ngue c'ü rí juentsqueji yo nin minteji”, eñe Mizhocjimi. Nujnu, ngue 'naja jña c'ü ni jyodü rí ma xörüji, xa'ma ra zi'ch'i in mün'c'eji nu. C'ua ja nzi ga mama ne jña nu, rí juentsetegö. Nguec'ua, dya ngue c'o cjapü cja na jo c'ü rvá 'ñe xipji ra nzhogü o̱ mü'büji cja Mizhocjimi. Ngue c'o pãrã tũ o̱ nzhubü. ");
INSERT INTO mazNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nuc'ua c'o o̱ discípulo e Juan o säji nu ja mi bübü e Jesús, o xipjiji: ―Nutscöjme rí mbempcjöjme na puncjü, xo 'ñe yo fariseo. ¿Jenga dya mbempje yo in discípulogue? ");
INSERT INTO mazNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","O ndünrü c'ua e Jesús o xipjiji 'naja jña ngue c'ua ro mbãrãji jenga dya mi mbempje c'o o̱ discípulo. O xipjiji: ―'Ma ra chjüntü 'naja sẽ, 'ma dya be cjuarü c'e chjüntü, dya sö ra ndumü c'o o̱ dyoji, na ngueje xe bübütjo c'e sẽ a nde anguezeji. Pero ra zädä c'o pa 'ma ra s'inbiji c'e sẽ. Nuc'ua cja ra mbempjeji rgá ndumüji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sido o ña e Jesús o xipjiji 'na ejemplo, o mama a cjava: ―'Na zëbitu, dya cjó sö ra mbä't'ä 'na bitu c'ü nuevo. Na ngue ro ñungü c'e nuevo bitu. Nuc'ua nu ja ya mi xüt'ü, xenda ro xüt'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dya xich'iji o õt'apjü cja zëmbota, na ngueje ro xüt'ü c'e zëmbota, ro pjödü c'e t'apjü. Dya cja ro jogü c'ua c'e zëmbota. Je xich'iji o õt'apjü cja mbota c'o cja nuevo, ngue c'ua dya ra xüt'ü c'e mbota ra pjödü c'e t'apjü, eñe e Jesús va xipjiji 'na ejemplo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","'Ma ndänt'ä ma mama e Jesús c'o jña c'o, o ẽ c'ua 'naja bëzo c'ü pje mi pjëzhi cja c'o menzumü a Israel; o 'ñe ndüñijõmü a jmi e Jesús, o xipji: ―C'ín xunt'igö cja ndũ mi ndajme. Pero rí ma'a, rí ma 'ñe's'e in dyëgue, ra tetjo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Cjanu o böbü c'ua e Jesús o mëvi c'e bëzo, xo 'ñe c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nuc'ua cjanu o ẽjẽ c'ua 'naja ndixũ c'ü mi sö'dyë, c'ü ya mi pa 'na doce cjë c'ü mi dagü o̱ cji. O ẽ chëzhi a xütjü e Jesús, o 'ne ndötpü o̱ fleco c'ü o̱ bitu c'ü mi je'e e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Na ngueje mi cjijñi c'e ndixũ: “Nguextjo c'ü rá tjötpü o̱ bitu nu, ixta ndixqui”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nuc'ua e Jesús o jñanda c'e ndixũ, o xipji: ―Dya rí sũgue, süngü; ya jots'ügue dya, na ngueje i̱ṉ ejmezügö c'ü sö rá jocüts'ü in nzeme. Nuc'ua ndeze c'e ndajme c'ü, o jogü na jo c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nuc'ua o zät'ä e Jesús cja o̱ ngumü c'e bëzo c'ü pje mi pjëzhi, cjanu o cjogü a mbo'o. O jñanda c'ua c'o mi jüxü o pito, 'ñe c'o nte c'o me mi huëñi. ");
INSERT INTO mazNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","O mama c'ua e Jesús o xipjiji: ―C'ueñeji va. Na ngueje ne xunt'i nu, dya tũ'ũ nu, ĩtjo nu. Nuc'ua c'o nte me go tsjapütjoji burla e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nuc'ua e Jesús o pjongü a tji c'o nte, cjanu o cjogü a mbo nu ja ma o'o c'e añima, cjanu o pënchp'i a dyë. Jo ni nanga c'ua c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nuc'ua texe cja c'e xoñijõmü, me mi nädätjoji c'ü vi tsja e Jesús vi tsjapü o te c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","O mbedye c'ua e Jesús cja o̱ ngumü c'e bëzo. 'Ma ya mi ma'a, ma ẽ c'ua a xütjü yeje bëzo c'o mi ndëzhö, mi mapjüvi mi mamavi: ―Nu'tsc'e o̱ mboxbëchets'ü e David, juentscöbe. ");
INSERT INTO mazNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nuc'ua 'ma mü o zät'ä e Jesús nu cja c'e ngumü nu ja mi oxü, o ẽ c'ua c'o mi ndëzhö, o chëzhivi a jmi. Nuc'ua e Jesús o xipjivi: ―¿Cjo i̱ṉ ejmevi c'ü sö rá jocüts'üvi in chövi? Cjanu o ndünrüvi c'ua: ―Jã, sö rí jocüzübe, ín Jmutsc'öbe, eñevi. ");
INSERT INTO mazNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nuc'ua e Jesús o ndötpü a nzhö'ö c'o mi ndëzhö, o xipjivi: ―Rá jocüts'üvi c'ua ja nzi gui 'ñejmevi, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jo ni jogü c'ua a nzhövi. Cjanu o xipjivi c'ua e Jesús c'ü dya cjó ro ma ngös'üvi. ");
INSERT INTO mazNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero 'ma ya vi mbedyevi, mi mamavi texe cja c'e xoñijõmü, mi xipjiji c'o nte c'ü vi tsja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nzi va mbedye c'o mi ndëzhö, o ẽ c'ua c'o ma siji 'naja bëzo c'ü mi ngone, ma sinpiji e Jesús. Nu c'e bëzo vi zürü 'naja ndajma c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nuc'ua e Jesús o pjongü c'e ndajma. Cjanu o ña c'ua na jo c'ü mi ngone. C'o nte, me co nguijñiji c'ua cjanu o mamaji: ―Nunca rí jandagöji va a Israel c'ü ri jogü yo ngone. ");
INSERT INTO mazNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero c'o fariseo mi mamaji: ―Ngue e Satanás c'ü dya jo c'ü unü poder ne bëzo nu, nguec'ua ga pjongü yo ndajma yo dya jo. ");
INSERT INTO mazNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mi nzhodü e Jesús texe cja c'o jñiñi, 'ñe cja c'o ndajñiñi, mi xöpüji cja c'o o̱ nintsjimi anguezeji, y mi xipjiji o̱ jña Mizhocjimi. Mi xipjiji ja rvá manda nu c'ü vi 'ñeme Mizhocjimi a jens'e. Mi jocü texe c'o mi sö o ngueme, 'ñe texe c'o mi sö'ö na ü. ");
INSERT INTO mazNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","E Jesús 'ma mü o jñanda c'o nte, me go juentseji c'ua anguezeji, na ngueje mi chjëntji nza cja ndënchjürü c'ü dya bübü o̱ mbörü, ya me ni pizhiji, ya me xo ni ponch'ü o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","E Jesús o xipji c'ua c'o o̱ discípulo va jyëtspiji ndëxü c'o nte'e: ―Na puncjü yo ndëxü yo ya jogü, pero ts'ëtjo yo ndagrëxü. ");
INSERT INTO mazNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mizhocjimi ngue o̱ cjaja yo ndëxü. Nguec'ua rí dyötqueji angueze ra ndäjä c'o xe 'ñaja mbëpji ra ẽji, ra 'ñe pëpjiji cja ne dagrëxü. ");
INSERT INTO mazNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nuc'ua e Jesús o ma't'ü c'o doce o̱ discípulo ro chëzhiji a jmi. Cjanu o unüji poder ngue c'ua ro sö ro pjongüji o ndajma c'o dya jo, y ro jocüji texe c'o ndötc'ijeme, 'ñe texe c'o mi sö na ü. ");
INSERT INTO mazNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nujyo, ngue o̱ tjũ'ũ c'o doce discípulo c'o o xipjiji c'ua apóstole: E Simón c'ü xo mi xiji Pedro, 'ñeje e Andrés c'ü nu cjuarma, 'ñe e Jacobo c'ü nu t'i e Zebedeo, 'ñe e Juan c'ü nu cjuarma e Jacobo. ");
INSERT INTO mazNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Xo 'ñe e Felipe, 'ñe e Bartolomé, 'ñe e Tomás. Xo 'ñe e Mateo c'ü mi cobra o contribución, 'ñe e Jacobo c'ü nu t'i e Alfeo, 'ñe e Lebeo c'ü xo mi xiji Tadeo. ");
INSERT INTO mazNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Xo 'ñe e Simón c'ü mi revolucionario, 'ñe e Judas Iscariote c'ü ro dyëdyi c'o nte ro ma zürüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","E Jesús ya mi ngue ro ndäjä c'o doce apóstole, nguec'ua va xipjiji c'ü ro tsjaji. O xipjiji a cjava: ―Dya rí möji cja o̱ 'ñiji yo dya menzumü a Israel, dya xo rí sät'äji cja o̱ jñiñi yo menzumü a Samaria. ");
INSERT INTO mazNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","C'ü rí tsjagueji, rí möji cja yo ín menzumüji a Israel, na ngue anguezeji chjënji nza cja ndënchjürü c'o ya bëzhi. ");
INSERT INTO mazNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'Ma rí möji, rí zopjüji c'o nte rí xiji c'ü ya ngue ra manda nu c'ü o 'ñeme Mizhocjimi a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Rí jocüji c'o ri sö'dyë. Y rí tsjapüji ra te'e c'o ya rguí ndũ'ũ. Y rí dyät'äji c'o ri sö o lepra. Y rí pjongüji o ndajma c'o dya jo cja o̱ mü'bü yo nte. 'Ma rí pjösc'eji a cjanu yo nte, dya rí cobraji. Na ngueje o dya'c'ütjoji Mizhocjimi ne poder. ");
INSERT INTO mazNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Y 'ma rí möji, dya rí jñünnc'eji oro, ni plata, ni pje ma t'opjü. ");
INSERT INTO mazNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dya xo rí tsanaji mape c'ü pje rgui tsant'aji o pje rgui jñunt'üji para cja 'ñiji. Dya xo rí tsanaji o bitu, ni xo rí tsidyiji mbäcua c'ü rgui pötüji. Dya xo rí jñünüji 'na chäjä rgui dänäji. Rí xi'tsc'öji a cjanu, na ngue 'na mbëpji ni jyodü ra ch'unü c'ü ra zi'i c'ü, 'ñe c'ü ra jye'e. ");
INSERT INTO mazNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Nu 'ma ja c'o rí sätc'eji, zö pje nde ma jñiñi o ndajñiñi, rí tsjaji t'önü nu, cjó ngue c'ü na jonte nu cja c'e jñiñi. Nguec'ua je rí oxüji cja o̱ ngumü c'ü, hasta 'ma cja rí ñe rí pedyeji; dya rí pötqueji ngumü rgui oxqueji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Ma rí tsjogüji cja c'e ngumü, rí ma'tp'üji Cjimi c'o ri cãrã nu. ");
INSERT INTO mazNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nu 'ma ra dyä'tc'eji in jñagueji c'o ri cãrã nu, ix na cjuana ra mbös'ü Mizhocjimi anguezeji c'ua ja nzi vi zenguaji. Pero 'ma dya ra dyä'tc'eji, iyö 'ma. ");
INSERT INTO mazNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'Ma dya ra säc'eji, 'ma dya ra dyä'tc'äji c'o rí xipjiji, rí pedyeji 'ma cja c'e ngumü, 'ñe cja c'e jñiñi; rí pjë'biji o jõmü c'o ya rguí jyäs'ä in mbäcuaji, ngue c'ua ra unü ngüenda c'o menzumü nu, que vi tsjaji c'o na s'o, dya säc'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na cjuana rí xi'tsc'öji, nu pa c'ü ra tjün ngüenda, xenda ra sufre c'o ri cãrã c'e jñiñi, que na ngueje ra sufre c'o ma cã a Sodoma, 'ñe a Gomorra c'o o chjotü Mizhocjimi mi jinguã na ngueje c'ü me ma s'oji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Dyäräji c'ü rí xi'tsc'öji. Rí täc'öji nza cja o ndënchjürü a nde cja o min'ño. Rí pjöngüendaji na jo cja yo nte, pero dya cjó pje rí tsjapüji. Rga cjatsc'eji o mbaro yo dya pje cja c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Rí pjötpüji ngüenda yo nte, na ngueje ra zints'iji nu ja ra jñün'c'üji ngüenda c'o pje pjëzhi. Y ra ndaxc'üji cja c'o o̱ nintsjimiji anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ra zints'iji cja c'o gobernador 'ñe cja c'o rey, na ngueje i̱ṉ ejmezgöji. Nguec'ua rí xiqueji anguezeji 'ñe c'o 'ñaja nte, ja ga cjazgö. ");
INSERT INTO mazNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","'Ma ra zints'iji, dya rí tsjijñiji c'ü ja rgui chjünrüji, o c'ü pje rí manji. Na ngueje c'e ndajme c'ü, ra ch'a'c'üji c'o rí mamaji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Na ngue c'ü rí ñagueji, dya ngue c'ü rí tsjijñitsjëji; ngue o̱ Espíritu Mizhocjimi c'ü nin Tatagueji ra dya'c'eji c'e jña'a. ");
INSERT INTO mazNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Cãrã c'o ra nzhö'ö nu cjuarma ra mbö't'üji. Cãrã o tata c'o ra nzhö'ö nu t'i. Cãrã t'i c'o ra chũtsjëji nu tataji 'ñe o̱ nanaji, y ra mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ra nuc'üji na ü texe yo nte, na ngue c'ü ni 'ñejmezügöji. C'o ra sido ra 'ñejmezü, zö ra mbö't'üji, ra salva c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","'Ma ra ndäc'äji cja 'na jñiñi, rí c'ueñeji c'ua rí möji c'ü 'naja jñiñi. Na cjuana rí xi'tsc'öji, dya be xi ri nzhonnc'eji texe cja yo jñiñi a Israel 'ma rá ẽgö na yeje cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Xe sido o ña e Jesús o xipji 'na ejemplo c'o o̱ apóstole, o mama: ―Xenda respetaoji 'na xöpüte que na ngue c'o o̱ discípulo. Y xenda respetaoji 'naja lamu que na ngue c'o o̱ mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nguec'ua 'ma ra sufre 'na xöpüte, xo ni jyodü ra sufre c'o o̱ discípulo. Y 'ma ra sufre 'na lamu, xo ni jyodü ra sufre c'o o̱ mbëpji. Y 'ma ra mama yo nte ra xiji dya jo 'naja bëzo, xenda ra xiji dya jo c'o ri cãrã o̱ ngumü. ");
INSERT INTO mazNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Nguec'ua, dya rí sũgueji c'ü ra tsja'c'eji yo nte. Pero rí tsjacjuanaji rí zopjüji, na ngueje ni jyodü ra jñandaji c'ü dya be jandaji dya, y ni jyodü ra mbãrãji c'ü dya be pãrãji dya. ");
INSERT INTO mazNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na puncjü c'o ín jñagö, nguextjotsc'eji i̱ dyäräji 'ma mi cãrãtsjëgöji. Nguec'ua ni jyodü rí xipjiji yo nin minteji texe c'ua ja rí chjëji. C'o jña c'o rí xi'tsc'ötsjëji, rí xipjiji ngue c'ua ra dyäräji texeji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dya rí sũgueji c'o ra mbö'tc'üji in cuerpoji, pero in aljmaji, dya ra sö ra mbö'tc'üji c'o. Nu c'ü rí sũgueji ngue Mizhocjimi c'ü sö'ö ra mbochc'üji a ma a linfiernu, nu ja me ra sufre in cuerpoji, xo 'ñe in aljmaji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Mizhocjimi c'ín Tatagöji pjörü yo ts'ins'ü. Nguec'ua 'ma dya ra ne angueze, dya ra sö ra ndũ ne rí 'na ts'ins'ü; maco dya ni muvi yo, pöji yeje por 'na cinco. ");
INSERT INTO mazNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Xo 'ñe in ñixtegueji, zö dya ni muvi yo, pero Mizhocjimi pãrã ja nzi sö'ö yo. ");
INSERT INTO mazNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nu'tsc'eji xenda ni muvits'ügueji que na ngueje na puncjü o ts'ins'ü. Nguec'ua dya rí sũgueji, xo ra mbö'c'eji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Texe c'o ra xipji yo nte c'ü pãcöji, xo rá xipjigö c'ü mi Tatagö c'ü bübü a jens'e c'ü rí pãrãgö c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero texe c'o ra xipji yo nte c'ü dya pãcöji, xo rá cänbägöji a jmi c'ü mi Tatagö c'ü bübü a jens'e, rá xipji c'ü dya rí pãrgö c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’I̱ṉ pëzhgueji rvá ẽcjö cja ne xoñijõmü ngue c'ua dya cja ra chũ yo nte. Pero dya rí tsjijñiji a cjanu. Dya ngue c'ü rvá ẽcjö c'ü. Na ngueje c'ü rvá ẽcjö, ra bübü o chũ cja yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na ngue c'ü rvá ẽcjö, cãrã bëzo c'o ra jyonbüji o chũ, ra tsja c'o o̱ t'iji. Cãrã ndixũ c'o ra jyonbüji o chũ, ra tsja c'o o̱ xunt'iji. Cãrã ndixũ c'o ra jyonbüji o chũ, ra tsja c'o o̱ cjöji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","C'o ra nu'u na ü c'o ri ejmezü, ngue c'o ri cãrã nu ngumütsjëji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’'Ma cjó c'o ne ra ndennguegö, ni jyodü xenda ra nezegö que na ngue c'ü nu tata 'ñe nu nana. Y ni jyodü xenda ra neze que na ngue c'ü nu t'i 'ñe nu xunt'i. 'Ma jiyö, dya ra sö rá cjapcö ín ntegö c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'Ma cjó c'o ne ra ndennguegö, ni jyodü ra bübü dispuesto ra sufreji o ra ndũji. 'Ma jiyö, dya ra sö rá cjapcö ín ntegö c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","C'o dya bübü dispuesto ra sufre na ngueje dya ne ra ndũji, dya ra chöt'üji c'ü rguí bübüji. Pero c'o bübü dispuesto ra bö't'ü na ngueje c'ü ni 'ñejmezügöji, ra chöt'üji c'ü rguí bünji. ");
INSERT INTO mazNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’C'o ra recibidots'üji, chjëntjui c'ü ri nguetscö ra recibidozgö c'o. Y c'o ra recibidozügö, chjëntjui c'ü ri recibidoji c'ü o ndäcjägö. ");
INSERT INTO mazNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","C'o ra säjä 'naja profeta na ngue c'ü ni ña o̱ jña Mizhocjimi, Mizhocjimi ra unüji c'o na jo, c'ua ja nzi rgá unü c'o profeta. C'o ra säjä 'na nte c'ü cja na jo na ngue c'ü ni tsja na jo, xo ra unüji c'o na jo c'ua ja nzi rgá unü c'o cja na jo. ");
INSERT INTO mazNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Rí xi'tsc'öji, 'ma cjó c'o ra unütjo 'naja ts'ixalo jörteje 'naja yo ín mbëpji yo dya nda pjëzhi, na ngue ín discípulogö, nuc'o, na cjuana ra unü Mizhocjimi c'o na jo c'o, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nuc'ua 'ma o nguarü e Jesús o xipji c'o doce o̱ discípulo c'ü ro tsjaji, cjanu ndäji o möji. Cjanu o mbedye c'ua e Jesús, cjanu o ma cja c'o o̱ jñiñi anguezeji, ngue c'ua ro xöpü c'o nte y ro zopjüji. ");
INSERT INTO mazNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E Juan xe ma o'otjo a pjörü. Nuc'ua 'ma o mbãrã angueze c'o mi cja e Jesucristo, o ndäjä c'ua yeje c'o o̱ discípulo o säjui cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","O xipjivi: ―¿Cjo ngue'tsc'e Cristo c'ü ro ẽjẽ, o xe rá te'bejme c'ü xe 'naja? ");
INSERT INTO mazNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Cjanu o ndünrü c'ua e Jesús o xipjivi: ―Mëvi ma xipjivi e Juan yo i̱ṉ ärävi, 'ñejyo i̱ṉ jandavi. ");
INSERT INTO mazNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Rí ma xipjivi e Juan c'ü ya janda yo mi ndëzhö; xipjivi c'ü ya nzhodü yo mi me'dye; xipjivi c'ü ya jogü yo mi sö'ö o lepra, 'ñe yo mi ngogõ, ya ärä yo. Xo rí xipjivi c'ü ya tetjo yo ya vi ndũ, 'ñe c'ü rí zopcjö yo dya pje pë's'i, rí xipjiji nu o̱ jña Mizhocjimi nu me na jo. ");
INSERT INTO mazNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Xo rí xipjivi, 'ma cjó c'o ra sido ra 'ñejmezü y dya ra yembeñe c'ü rguí xõgü co nutscö, ngue nu rguí mäjä 'ma c'ü, eñe e Jesús va xipji c'o o̱ discípulo e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","O ma c'ua c'o yeje o̱ discípulo e Juan. Nuc'ua e Jesús o mbürü o xipji c'o nte c'ua ja ma cja e Juan, o mama: ―'Ma i̱ ma ñuji e Juan cja c'e majyadü, ¿pje mi cjijñiji rvi ma chöt'üji? ¿Cjo mi cjijñiji c'ü rvi chöt'üji 'naja bëzo c'ü ri pötpü o̱ jña, nza cja ga pötü o̱ lugar 'naja xitji 'ma juant'a e ndajma? ");
INSERT INTO mazNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Pje mi cjinncjeji c'ü rvi ma chöt'üji? ¿Cjo mi cjinncjeji c'ü rvi chöt'üji 'naja bëzo c'ü ri je bitu c'o me ni muvi? Tsjijñiji. C'o je'e bitu c'o me ni muvi, ngue c'o rey 'ñe c'o cãrã cja o̱ palacio. ");
INSERT INTO mazNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nama, ¿pje mi cjijñiji c'ü rvi ma chöt'üji 'ma? ¿Cjo mi cjijñiji c'ü rvi chöt'üji 'naja profeta? Jã, rí mangö ngue 'naja profeta. Pero xenda ni muvi o̱ bëpji angueze que na ngueje c'o 'ñaja profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Je t'opjü o̱ jña Mizhocjimi c'ü mama ja ga cja e Juan: Dyärä, ró juajnügö 'na bëzo ra zopjü yo nte ra xipjiji ín jñagö. Ra ot'ü in xo'ñigue, ngue c'ua 'ma rí mague, ya rguí bübü dispuesto yo nte ra dyä'tc'äji, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na cjuana rí xi'tsc'öji, dya ch'unü 'naja bëpji yo nte c'ü ni muvi nza cja c'ü o unü Mizhocjimi e Juan. Zö me ma nojo c'e bëpji c'ü mi pë's'i e Juan, 'ñe me ma zö, pero xenda na zö 'ma cjó c'o ra tsjapü Mizhocjimi o̱ nte, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Xe sido o ña e Jesús o xipjiji: ―Bübü c'o zopjü yo nu minteji, xipjiji c'ü ni jyodü ra unü o̱ mü'büji Mizhocjimi ra tsjapüji o̱ Jmuji. Pero ndeze c'o pa 'ma o mbürü e Juan Bautista o zopjü yo nte, hasta yo pa dya, nu c'o ga cjanu ga zopjü yo nu minteji, sufreji cja dyë yo nte. Y c'o nte c'o jodü Mizhocjimi co texe o̱ mü'bü, ngue c'o cjapü Mizhocjimi o̱ nte. ");
INSERT INTO mazNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Texe c'o o̱ jña Mizhocjimi c'o o dyopjü c'o profeta, 'ñe c'o xiji ley, mi mamaji c'ü ro ẽjẽ c'e pa 'ma ro manda Mizhocjimi. Pero 'ma o mbürü e Juan o zopjü yo nte, ya ma sädä c'e pa. ");
INSERT INTO mazNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nu 'ma i̱ṉ ne rí creoji c'ü rí xi'tsc'öji, rí xi'tsc'öji e Juan o pätpä e Elías c'ü mi te'begueji ro ẽjẽ na yeje. ");
INSERT INTO mazNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nu'tsc'eji bübü in tsõji, rí dyäräji na jo yo jña yo rí xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","’Rá xi'tsc'öji ja ga cja yo nte yo cjë yo rí cãrãji dya. Anguezeji chjëntjui nza cja yo ts'it'i yo junrü cja chõjmü yo eñe cjaji o mbaxua, ma't'üji o̱ dyoji mamaji: “Ró pjë'pc'ijme o flauta, pero nu'tsc'eji dya i̱ nemeji”, embeji yo nu dyoji. O 'ma jiyö, eñeji cjaji como que ya vi ndũ 'na nte, eñe pa ögüji c'e añima, xipjiji nu mit'iji: “Me ró nzhumüjme rvá xörüjme, pero nu'tsc'eji dya i̱ huëgueji”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Je xo ga cjatjonu yo nte yo cãrã yo cjë dya. 'Ma o mbürü e Juan o pëpji, o xõgü, dya cjó go zivi o xëdyi c'ü rví mäjä. Nguec'ua yo nte mamaji: “E Juan bübü o̱ mü' bü c'ü dya jo”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nuc'ua nutscö rvá ẽcjö cja Mizhocjimi, rí mäjä rgá sigöji o xëdyi. Nguec'ua ga mama yo nte: “Chjã, 'na bëzo nu me ñõnü, y me si o vinu. Me xo joji yo cobra o contribución, 'ñe yo 'ñaja yo xiji na s'o”, eñeji. Pero rí xi'tsc'öji, c'o ätä Mizhocjimi unüji ngüenda Mizhocjimi me pãrã na jo c'ü cja'a; nguec'ua nde nan'ño bëpji va dyacöbe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nuc'ua e Jesús o mbürü o huënch'i c'o mi menzumü cja ja nzi c'o ndajñiñi. Na ngueje angueze vi jocü na puncjü c'o mi sö'dyë, 'ñe vi tsjapü o te ja nzi c'o ya vi ndũ'ũ, y na puncjü c'o pje nde vi tsja'a. Pero dya go nzhogü o̱ mü'büji cja Mizhocjimi. O mama a cjava e Jesús va huënch'iji: ");
INSERT INTO mazNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Nu'tsc'eji i̱ṉ menzumüji a Corazín, 'ñetsc'eji i̱ṉ menzumüji a Betsaida, juentsc'eji ra tsja'c'ü Mizhocjimi rí sufreji. Na ngueje cja in jñiñiji ró cjagö na puncjü c'o na nojo c'o nunca mi jandagueji, pero dya go nzhogü in mü'büji cja Mizhocjimi. Nu 'ma je ri ngueje a ma a Tiro 'ñeje a ma a Sidón c'ü ro jizhi a cjanu, ya rví mezhe c'ü ro nzhogü o̱ mü'büji cja Mizhocjimi c'o mi menzumü nu, zö ma s'oji. Ya rví jye'eji c'o na ãrã, y ya rví minji cja bozivi c'ü ro jizhiji c'ü ya vi nzhogü o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nguec'ua rí xi'tsc'öji 'ma ra tjün ngüenda, xenda ra jñus'ü c'ü rgui sufregueji que na ngue c'ü ra sufre c'o mi menzumü a Tiro, 'ñe c'o mi menzumü a Sidón. ");
INSERT INTO mazNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nu'tsc'eji i̱ṉ menzumüji a Capernaum, i̱ṉ pëzhgueji c'ü me na jotsc'eji rí sätc'eji a jens'e; pero rí xi'tsc'öji ra tsja'c'üji rí ma sufregueji a linfiernu. Na ngueje cja in jñiñiji ró cjagö na puncjü c'o me na nojo, pero dya nzhogü in mü'büji cja Mizhocjimi. Nu 'ma je ri ngueje a ma a Sodoma c'ü ro cjagö a cjanu, xe ri büntjo dya c'e jñiñi. ");
INSERT INTO mazNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nguec'ua rí xi'tsc'öji, nu pa c'ü ra tjün ngüenda, xenda ra jñus'ü c'ü rgui sufregueji que na ngueje c'ü ra sufre c'o mi menzumü a Sodoma, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","C'e ndajme, o dyötü Mizhocjimi e Jesús o mama: ―Mi Tatats'ügö, i̱ṉ mandague a jens'e 'ñe textjo cja ne xoñijõmü. Rí da'c'ü 'na pöjö na ngueje yo jña yo, dya i̱ unügue c'ü rví mbãrã c'o cjapü me pãrã. C'ü i̱ tsjague, i̱ unngue c'ü ro mbãrã c'o dya mi pãrã. ");
INSERT INTO mazNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jã, mi Tatats'ügö; je ga cjanu vi ñegue. ");
INSERT INTO mazNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nuc'ua e Jesús o xipji c'o o̱ discípulo: ―Texe o poder, ya nde dyacö mi Tatagö. Dya cjó pãcö c'ua ja ga cjazgö; nguextjo mi Tatagö c'ü pãcö. Dya cjó xo pãrã mi Tatagö; nguextjozgö o̱ T'izgö rí pãrãgö. Y nutscö rí jíchi c'o rí ne rá jíchi c'ua ja ga cja c'ü mi Tatagö; ngue c'ua xo ra mbãrã c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Cãrãtsc'eji i̱ṉ jonnc'eji rí tsjaji c'o ne Mizhocjimi, pero ya tõgü in mün'c'eji. Chjä'däji co nutscö, rá da'c'öji ra söya in mün'c'eji, dya cja pje rí mbeñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","O nzhünü äräji 'ma 'huëch'iji. Je xo rga cjatsc'eji nu, rí dyätcöji ín jñagö. Dya rá huënchc'eji rga jí'tsc'öji. Dya xo rí cjapütsjë na nozü c'ü rgui bëzhgueji in tseji. Nguec'ua ra söya in mün'c'eji, dya pje rí mbeñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na ngueje ín jñagö chjëntjui nza cja 'na yugo c'ü dya ga ü'ü nu; dya xo rí sögueji na jyü yo rí xi'ts'iji rí tsjagueji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","'Na nu pa, o cjogü e Jesús c'ua ja mi cja o ndëxü; mi ngue c'e pa 'ma mi söya c'o menzumü a Israel. Mi sant'a c'o o̱ discípulo e Jesús, nguec'ua ma tücüji o ñirëxü c'o mi tjõ't'üji; cja rrũ zaji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nuc'ua 'ma mü o jñanda c'o fariseo c'o mi cja c'o discípulo, cjanu o xiji c'ua e Jesús: ―Jñant'ma yo i̱ṉ xöpque, na cjaji c'o mama o̱ ley Mizhocjimi c'ü dya rá cjaji yo pa yo rí söyaji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji ya i̱ xörügueji nu c'ü o tsja e David 'ñe c'o mi dyoji, 'ma ya mi sant'aji; maco dya i̱ṉ so'büji anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O cjogü e David cja o̱ ngumü Mizhocjimi nu ja ma sjũ. Cjanu o jñü c'ua c'o tjõmëch'i c'o mi jũsp'üji Mizhocjimi nu. Nuc'ua e David 'ñe c'o mi dyoji o ziji c'o tjõmëch'i. Maco mama c'o ley c'ü dya mi sö e David ro zi c'o, ni ri ngue c'o mi dyoji; mi nguextjo mböcjimi c'o mi sö'ö ro zi c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nu'tsc'eji ya xo i̱ xörügueji c'ü mama c'e ley ja ga tsja o mböcjimi. Mama c'e ley c'ü pëpji yo mböcjimi a mbo cja c'e templo yo pa yo rí söyaji, pero dya pë's'iji nu s'ocüji; maco sjũpa yo. ");
INSERT INTO mazNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Rí xi'tsc'öji zo'c'üji dya nu 'naja nu xenda na sjũ que na ngueje c'e templo. ");
INSERT INTO mazNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ya t'opjü a cjava: “C'ü ni pötcöji o animale cja rrĩ päscöji c'o, na jo c'ü. Pero c'ü xenda rí negö, ngue c'ü rí juentsqueji yo nin minteji”, eñe Mizhocjimi. Nu'tsc'eji i̱ṉ fariseoji, nu 'ma rvi unnc'eji ngüenda c'ü pje ne ra mama ne jña nu, dya rvi so'bügueji 'ma nujyo ín discípulogö yo dya pë's'i nu s'ocü ga ndücüji yo ñirëxü ra zaji ne sjũpa. ");
INSERT INTO mazNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nutscö rvá ẽcjö cja Mizhocjimi, nguextjozgö sö rá mangö ja rgui sũpüji yo pa yo rí söyaji, embeji c'o fariseo. ");
INSERT INTO mazNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cjanu o mbedye c'ua e Jesús nu, o ma cja c'ü o̱ nintsjimi anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma bübü nu 'naja bëzo c'ü mi dyot'ü 'naja o̱ dyë. C'o fariseo c'o mi cãrã nu, mi jodü ja rvá ngöt'üji e Jesús cja c'o pje mi pjëzhi; nguec'ua va dyönüji e Jesús, o xiji: ―¿Cjo mama ne ley c'ü sö rá ät'äji yo sö'dyë ne pa nu rí söyaji?, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","O ndünrü c'ua e Jesús o xipjiji: ―'Ma ri 'ñegueji 'naja ndënchjürü, nu 'ma ra zo'o cja 'na pozo c'ü dya be cjuarü, ra zo'o nu pa c'ü rí söyaji, ¿cjo dya ri ma tsjünc'eji c'ü? ");
INSERT INTO mazNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Rí xi'tsc'öji c'ü xenda ni muvi 'naja nte que na ngueje 'naja ndënchjürü. Nguec'ua na jo rá pjös'üji nu pa c'ü rí söyaji c'o pje ni jyodü yo nín minteji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nuc'ua e Jesús o zopjü c'e bëzo c'ü mi dyot'ü a dyë, o xipji: ―C'uana dya in dyë. Cjanu o c'uana c'ua o̱ dyë. Ixco jogü c'ua, c'ua ja nzi ma cja c'ü 'naja o̱ dyë. ");
INSERT INTO mazNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Cjanu o mbedye c'ua c'o fariseo. Mi pötma mamaji ja rvá mbö't'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ya xmi pãrã e Jesús c'o mi ne ro tsja c'o fariseo ro mbö't'üji angueze; nguec'ua va mbedye nu. Na puncjü o nte c'o o möji angueze. Y angueze o jocü c'ua texe c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero o mama e Jesús o xipji c'o nte c'ü dya cjó ro ma ngös'üji c'ü pje mi pjëzhi angueze. ");
INSERT INTO mazNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nguec'ua ya ma sädä o̱ jña Mizhocjimi c'ü vi mama c'e profeta Isaías: ");
INSERT INTO mazNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Bünc'ua nín mbëpcjö nu ró juajnügö, nu me rí s'iya, nu me rí mäpägö. Angueze rá unngö ín Espíritu, ngue c'ua ra xipji yo dya menzumü a Israel ja rgá jogüji a jmi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nujnu, dya cjó ra zövi o jña nu. Dya xo ra ña rrã jens'e nu, ni xo ra ña cja nda'ñi c'ü rguí dyärä na puncjü o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Cãrã nte c'o nza cja 'naja dye'e c'ü ya cho't'ü, na ngue dya ga zëzhi ga 'ñejmeji. Xo cãrã c'o nza cja 'naja sivi c'ü me pjüt'ü, na ngue dya nda bübü jya 's'ü o̱ mü'büji. Pero nín mbëpcjö, dya ra chjotü c'o; ra mbös'ü c'o. Nguec'ua ra zädä c'ü ra tsjaji c'o na jo. ");
INSERT INTO mazNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yo dya menzumü a Israel nguejyo ra 'ñench'e o̱ mü'büji rgá nde'beji angueze, eñe c'e profeta va pätpä Mizhocjimi. Nguec'ua 'ma o ẽ e Jesús o 'ñe zopjü c'o nte, ma sädä c'ü vi mama c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","C'ü 'na nu pa, o ẽ c'o ma siji 'naja bëzo c'ü vi zürü 'naja o̱ ndajma c'ü dya jo; o sinpiji a jmi e Jesús. Nu c'e bëzo mi ndëzhö, y mi ngone. Nuc'ua e Jesús o jocü c'ua c'e bëzo. Nuc'ua c'e bëzo, cjanu o ña c'ua y o jñanda c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nguec'ua me mi cjijñi texe c'o nte mi mamaji: ―Pãrã, ¿cjo ri ngue o̱ mboxbëche e David nu rí te'beji ra manda?, mi eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nuc'ua 'ma mü o dyärä c'o fariseo c'o mi mama c'o nte, cjanu o manji c'ua: ―Je ngue e Satanás c'ü dya jo c'ü manda cja yo demonio c'ü o unü ne poder ne bëzo nu; nguec'ua ga pjongü yo demonio, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ixmi pãrã e Jesús c'o mi cjijñi c'o fariseo, nguec'ua va xipjiji: ―Cja 'na ndajñiñi c'ü ra chũtsjëji, ra chjorü 'ma c'o ri cãrã nu. Texe o ndajñiñi 'ñeje texe o ngumü, 'ma ra pötca chũtsjë c'o ri cãrã nu, ra chjorüji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Xo 'ñetjo e Satanás 'ma ro pjongü c'o demonio c'o ngue o̱ dyoji, ro chũtsjë 'ma c'o. Y 'ma rva cjanu, ¿ja rvá sö xe ro manda 'ma c'ü? ");
INSERT INTO mazNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","¿Jenga i̱ṉ xitscöji ngue e Satanás c'ü o dyacö ne poder nu rgá pjongü yo demonio? Maco c'o in dyocjeji xo pjongüji yo. Ixi 'ñetsetjo c'ü na s'o gui tsjijñiji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Rí xi'tsc'öji ngueje o̱ Espíritu Mizhocjimi c'ü o dyacö ne poder nu rí pjongü yo demonio. Nguec'ua rí jñunt'ü in mün'c'eji c'ü na cjuana ya säjä a ndetsc'eji nu c'ü o 'ñeme Mizhocjimi ra manda. ");
INSERT INTO mazNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Rí önnc'üji, ¿ja rgá sö'ö cjó ra cjogü cja nu ngumü 'naja bëzo c'ü me na zëzhi, cja rrũ jñünbü c'o ri pë's'i, 'ma dya ot'ü ra jyü'tp'ü a dyë c'ü na zëzhi? Nuc'ua ya ra sö ra põnbü 'ma texe c'o ri pë's'i cja o̱ ngumü. Je xo ga cjazgö nu, ya ró tõpü c'ü dya jo ngue c'ua sözgö rá pjongü dya yo demonio. ");
INSERT INTO mazNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’C'o dya tenngue co nuzgö, chjëntjui c'ü ri nugü na ü c'o. C'o dya ra xipji yo nte ra creozüji, chjëntjui c'ü ri c'a's'üji yo nte ngue c'ua dya xo ra creozüji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Nguec'ua rí xi'tsc'öji, texe c'o o̱ nzhubüji ra sö ra perdonaoji yo nte. Xo 'ñe texe c'o s'o va jña c'o ra xiji Mizhocjimi. Pero c'o ra zadü o̱ Espíritu Mizhocjimi ra mamaji o̱ bëpji o̱ Espíritu ngueje o̱ bëpji c'ü dya jo, nuc'o, nunca ra perdonaoji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","C'o pje nde ra xitscöji nutscö rvá ẽcjö cja Mizhocjimi, ra sö ra perdonaoji c'o. Pero c'o ra zadü o̱ Espíritu Mizhocjimi, nunca ra perdonaoji c'o, ni ri ngue yo cjë dya, ni xo ri ngueje c'o cjë c'o va ẽjẽ 'ma ya rguí nguins'i ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’'Na za'a c'ü na jo'o, quis'i c'o na jo. 'Na za'a c'ü dya ga jo'o, quis'i c'o dya ga jo. Je xo ga cjatjonu 'na nte. C'ü ni tsja 'na nte, je ngue c'ü ni 'mãtpãtjo c'e nte cjo na jo cjo jiyö. Nguec'ua 'ma na jo c'ü cja'a 'na nte, dya rí mangueji c'ü dya jo c'e nte. ");
INSERT INTO mazNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tsjijñiji o pozü, na s'oji na ngueje po'o o̱ posuña a ne. Je xo ga cjatsc'eji nu; na s'otsc'eji, nguec'ua ga mbedye in teji c'o na s'o. Na ngue c'o rí pë'sc'öji cja ín mü'büji, ngue c'o pedye cja ín tegöji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","C'o nte c'o cja na jo, mama c'ü na jo c'o, na ngueje pë's'iji na jo cja o̱ mü'büji. Pero c'o nte c'o cja na s'o, mama c'o na s'o jña c'o, na ngueje pë's'iji na s'o cja o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nutscö rí xi'tsc'öji, texe jña c'o ra mbedye o̱ ne yo nte, zö dya ra nguijñi o̱ ñi'iji, ra jñünpüji ngüenda c'o, nu pa c'ü ra tjün ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","C'o jña c'o na jo c'o i̱ṉ mangueji dya, ngue c'o rgui pedyeji na jo c'o. Pero c'o jña c'o na s'o c'o i̱ṉ mangueji dya, ngue c'o rguí tsja'c'üji rí sufregueji c'o, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cjanu o mama c'ua ja nzi c'o xöpüte 'ñe c'o fariseo, o xiji e Jesús: ―Xöpüte, rí negöjme c'ü pje rí tsjague c'ü rá jandgöjme, ngue c'ua rá pã'c'öjme pje pjë'tsc'e. ");
INSERT INTO mazNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Cjanu o ndünrü c'ua e Jesús o xipjiji: ―Me na s'o yo nte yo cãrã yo cjë dya, na ngueje ya jyëziji Mizhocjimi cja rrũ ndeñeji c'o dya cjuana. Nguec'ua ga dyörüji c'ü pje ra jñandaji, ngue c'ua ra mbãrãji pje pjëtscö. Pero dya ra ch'unüji c'ü ra jñandaji; nguextjo c'ua ja va tsja e Jonás c'ü mi profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","O mezhe jñipa cja 'na jñixõmü o dyo'o e Jonás a mbeme c'e trajmõ. Je xo rga cjazgö nu nutscö rvá ẽcjö cja Mizhocjimi, ra mezhe jñipa cja 'na jñixõmü rá o'o a jõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","C'e pa 'ma ra tjün ngüenda, ra bübü nu c'o mi cãrã a Nínive, xo 'ñejyo nte yo cãrã yo cjë dya. E Jonás o ma zopjü c'o mi menzumü a Nínive; nguec'ua va nzhogü o̱ mü'büji cja Mizhocjimi. Pero nu'tsc'eji i̱ṉ cãrãji yo cjë dya, dya nzhogü in mü'büji, maco zo'c'eji dya nu pjëzhi xenda na nojo que na ngue e Jonás. Nguec'ua ra jñün'c'eji ngüenda rí sufregueji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","C'e pa 'ma ra tjün ngüenda, ra bübü nu c'e ndixũ c'ü mi manda a ma Sur, xo 'ñejyo nte yo cãrã yo cjë dya. Nu c'e ndixũ o ẽjẽ ndeze nu ja tjorü ne xoñijõmü, o ẽ dyärä c'o mi mama e Salomón c'ü mi pë's'i na puncjü o̱ pjeñe. Pero nu'tsc'eji i̱ṉ cãrãji yo cjë dya, dya i̱ṉ ne rí dyäräji; maco bünc'ua dya nu 'naja nu xenda pë's'i o̱ pjeñe que na ngueje e Salomón. Nguec'ua ra jñün'c'eji ngüenda rí sufregueji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’'Naja demonio c'ü dya jo 'ma ra mbedye cja o̱ mü'bü 'naja nte, ra nzhodü c'ua ja na dyodü; jodü c'ua ja ra söya, pero dya ra chöt'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nguec'ua ra mama c'e demonio c'ü dya jo: “Rá nzhogü rá magö nu ja mi bünc'ö, nu ja ró pedyegö”, ra 'ñeñe. Nuc'ua 'ma ra zät'ä nu, ra chöt'ü c'ü ya rguí baxü, y ya xo rguí jocüji na jo, pero dya cjó ri bübü. ");
INSERT INTO mazNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nuc'ua ra ma c'ua c'e demonio xe ra ma siji c'o xe siete c'o nu midemonioji c'o xenda na s'o que na ngueje angueze; ra ẽ cjogüji cja o̱ mü'bü c'e bëzo, ra mimiji nu. Nuc'ua xenda ra sufre c'e nte c'ü, que na ngueje 'ma ot'ü. Na ngue xenda ra manda c'ü dya jo. Je xo rga cjanu rgá zädä yo nte yo cãrã yo cjë dya yo me na s'o ga tsja, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","'Ma ndänt'ä ma ña e Jesús ma zopjü c'o nte, ya mi böbü a tji c'ü nu nana, 'ñe c'o nu cjuarma e Jesús; na ngue mi ne ro ñaji. ");
INSERT INTO mazNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","O mama c'ua 'naja c'o nte o xipji e Jesús: ―Bübü a tji c'ü nin nana, 'ñe c'o nin cjuarma; ne rí ñagueji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","O ndünrü c'ua e Jesús o xipji c'e nte: ―Rá xi'tsc'öji cjó rí cjapcö mi nanagö 'ñe c'o mi cjuarmagö, embe c'e nte. ");
INSERT INTO mazNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nuc'ua e Jesús jo ni c'uana c'ua a dyë nu ja mi cãrã c'o o̱ discípulo, cjanu o mama: ―Je bünc'ua yo rí cjapcö mi nanagö 'ñejyo rí cjapcö mi cjuarmagö. ");
INSERT INTO mazNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Na ngueje texe c'o ra tsja c'ua ja ga ne'e c'ü mi Tatagö c'ü bübü a jens'e, nuc'o, rí cjapcö mi cjuarmagö c'o, 'ñe mi cjũgö c'o, 'ñe mi nanagö c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","C'e pa c'ü, o mbedye e Jesús cja c'e ngumü nu ja mi oxü, o ma mimi c'ua a ñünü cja c'e tazapjü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nuc'ua cjanu o jmurü na puncjü o nte nu ja mi bübü angueze. Nuc'ua e Jesús o dat'ü cja 'naja bü'ü, cjanu o mimi. Texe c'o nte mi böbütjoji a ñünü cja c'e ndeje. ");
INSERT INTO mazNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nuc'ua e Jesús o xipji na puncjü o ejemplo c'o nte, o mama: ―Dyäräji c'ü rá xi'tsc'öji. 'Na mbondëxü o mbedye, o ma mbodü o ndëxü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nuc'ua 'ma ya ma podü, bübü o ts'indëxü c'o o zobütjo cja 'ñiji. Cjanu o ẽ c'ua o s'ü, o 'ñe mbëchiji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bübü o ts'indëxü c'o je zobütjo cja o mbondojo nu ja dya ma pizhi o jõmü. Dya mezhe o mbes'e, na ngueje dya ma pizhi o jõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nuc'ua 'ma o mbes'e e jyarü, o zant'a c'o ndëxü ixco dyot'üji, na ngueje dya ma pizhi e jõmü c'ü rví tsizi o̱ dyü'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bübü o ts'indëxü c'o o zobütjo nu ja mi bodü o̱ ndö o bidyi. 'Natjo c'ua va mbes'eji. Ts'i vi nocü c'o bidyi, nguec'ua va mbö't'ütjo c'o ts'indëxü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bübü o ts'indëxü c'o je zobü c'ua ja ma jo jõmü. Nuc'o, o jogü na jo c'o. Bübü c'o o unü 'na ciento ts'indëxü nzi 'na mata; 'ñaja c'o o unü sesenta; 'ñaja c'o o unü treinta. ");
INSERT INTO mazNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nu'tsc'eji bübü in tsõgueji, rí dyäräji na jo yo jña yo rí xi'tsc'öji, eñe e Jesús va xipji ejemplo c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nuc'ua cjanu o chëzhi c'o o̱ discípulo a jmi, o xipjiji: ―¿Pje ni mangue yo ejemplo gui zopjü yo nte? ");
INSERT INTO mazNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","O ndünrü c'ua e Jesús: ―Nu'tsc'eji ya ch'a'c'eji rí pãrãgueji c'ua ja ga manda Mizhocjimi a jens'e, c'ü dya mi 'mãrã 'ma ot'ü. Pero yo 'ñaja nte, dya ch'unü ra mbãrãji. ");
INSERT INTO mazNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","C'o pãrã ja ga manda Mizhocjimi, Mizhocjimi ra unü c'ü xenda ra mbãrã c'o. Pero c'o dya unü ngüenda, ra jñünbüji c'ü ts'iquë c'ü pãrãji. ");
INSERT INTO mazNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yo nte, ya jñandaji c'o na jo c'o rí cjagö pero dya mbãrãji. O dyäräji c'o rí xipjiji pero dya ngötcöji 'ñi. Dya xo zo'o o̱ mü'büji c'o rí xipjiji. Nguec'ua rgá xicöji o ejemplo rgá zopjüji dya, nguec'ua dya unüji ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ya va sädä anguezeji c'ü o mama e Isaías. O mama a cjava: Rí dyäräji pero dya ra zo in mü'büji. Rí jñandaji pero dya rí pãrãji. ");
INSERT INTO mazNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yo nte, ya tsot'ü o̱ mü'büji. 'Ma ro xogü o̱ mü'büji, xa'ma ro zo ín jñagö. Y 'ma cjó c'o zopjüji, dya cja cjapüji ngüenda. 'Ma ro tsjapüji ngüenda, xa'ma ro dyäräji, y ro mbãrãji pje ri pjëzhi. Ya c'uinch'itjo a nzhöji. 'Ma ro jñandaji, xa'ma ro mbãrãji, ro nzhogü o̱ mü'büji. Nuc'ua ro salvagö yo, ro jopcüji o̱ mü'büji c'o na s'o, eñe c'e profeta va pätpä Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Xe sido o ña e Jesús o xipji c'o o̱ discípulo: ―Nu'tsc'eji 'ma i̱ṉ jandaji yo rí cjagö, i̱ṉ pãrãji. Y 'ma i̱ṉ äräji yo rí mangö, i̱ṉ pãrãji pje pjëzhi. Nuc'ü, ngue c'ü rgui mäcjeji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na cjuana rí xi'tsc'öji, na puncjü profeta c'o mi cãrã mi jinguã, 'ñe na puncjü nte c'o mi cja na jo, c'o me mi ne ro jñanda yo i̱ṉ jandgueji, pero dya go jñantji. Xo mi ne ro dyäräji yo i̱ṉ ärägueji, pero dya go dyäräji. ");
INSERT INTO mazNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Nu'tsc'eji rá xi'ts'iji pje ne ra mama c'e mbondëxü c'ü ró xi'ts'iji mi ndajme. ");
INSERT INTO mazNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","'Ma cjó c'o ra dyärä ja ga cja ga manda Mizhocjimi, nu 'ma dya ra zo'o na jo o̱ mü'bü, ra ẽ c'ua c'ü dya jo, ra 'ñe jñünbü c'o jña. Nuc'o, ngue c'o ts'indëxü c'o o zontjo cja 'ñiji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nu c'o o zontjo cja mbondojo, ngueje c'o ärä o̱ jña Mizhocjimi c'o. Nuc'ua me mäjä ga 'ñejme c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero dya xo so'o na jo o̱ mü'bü c'o y dya sido ejmeji. Na ngue c'ü ni 'ñejmeji o̱ jña Mizhocjimi, ra nu'uji na ü, ra tsja yo nte. O ra chötüji o ndumü. Nguec'ua ra nguijñiji: “¿Pje ra dyeje c'ü rá sidogö?”, ra 'ñeñeji. Ixta jyëztjoji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nu c'o ts'indëxü c'o o zontjo cja bidyi, ngueje c'o ärä o̱ jña Mizhocjimi. Nuc'ua me cjijñiji pje nde ra mbë's'iji cja ne xoñijõmü; y nu c'o pë's'iji ngue c'o ni dyonpüji c'o. Nguec'ua ga jyombeñeji c'o jña c'o vi dyäräji, y dya cjaji c'ua ja va dyäräji. ");
INSERT INTO mazNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nu c'o ts'indëxü c'o o zobü c'ua ja ma jo jõmü, ngueje c'o so'o na jo o̱ mü'büji 'ma äräji o̱ jña Mizhocjimi. Nguec'ua ga tsjaji c'ua ja nzi ga ne Mizhocjimi. Nguec'ua chjëntcjui c'o ndëxü c'o o unü ciento nzi 'naja, o nza cja c'o o unü sesenta, o nza cja c'o o unü treinta. ");
INSERT INTO mazNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nuc'ua e Jesús o mama c'ü 'na ejemplo, o xipjiji: ―Mizhocjimi a jens'e o 'ñeme 'naja c'ü ra manda. Nuc'ü, chjëntjui nza cja 'naja bëzo c'ü o juajnü ndëxü c'o na jo, cjanu o mbodü cja o̱ juajma. ");
INSERT INTO mazNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mi bübü 'na bëzo c'ü mi nu'u na ü c'ü vi mbodü o ndëxü. Nuc'ua 'ma ya ma ĩjĩ c'o nte, cjanu o ma c'ua c'e bëzo c'ü xõmü, o ma mbonbü o ndömpjin'ño nu ja ya vi mbodüji c'o ndëxü, cjanu o mbedye cja c'e juajma o ma c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nuc'ua 'ma ya ma nguĩjĩ c'o ndëxü, ya xo nde ma nzhäjnä c'ua c'o pjin'ño. Nguec'ua va 'ñetse c'ü dya nde mi ndëxü c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nuc'ua c'o mbëpji o ẽ o 'ñe xiji c'ü nu lamu: “Nu'tsc'e ín lamutsc'öjme, ¿cjo dya i̱ juajnü o ndëxü c'o na jo, i̱ podü cja in juancje? Maco nde cja'a o pjin'ño.” ");
INSERT INTO mazNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","O ndünrü c'ua angueze o xipjiji: “Pe ngue 'naja c'ü nugü na ü c'ü o ma mbodü c'o”, embeji c'o mbëpji. O mama c'ua c'o mbëpji: “¿Cjo i̱ṉ negue rá ma ta't'üjme?” ");
INSERT INTO mazNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","O mama c'ua c'e lamu: “Iyö. Na ngueje 'ma rí cha't'üji c'o, 'na rí ts'ü's'ütjoji 'ma c'o ndëxü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jyëziji 'natjo c'ua ra nocüji hasta 'ma ra zädä dagrëxü. Nuc'ua rá zopjü c'o ndagrëxü rá xipjiji c'ü ot'ü ra ngã'maji c'o pjin'ño ra ndũ't'üji o manaxo, cja rrũ ndüt'üji cja sivi. Nuc'ua ra mbäräji c'o ndëxü, cja rrũ ndeñeji c'ua ra 'ñe dyütcüji cja ín ch'ujmü, rá embeji c'o ndagrëxü.” ");
INSERT INTO mazNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Xe go ña e Jesús, o xipji c'ü 'na ejemplo c'o o̱ discípulo, o mama: ―C'ü ni manda Mizhocjimi chjëntjui nza cja 'na ndömortasa c'ü o jñü 'naja bëzo, cjanu o ma ndujmü cja o̱ juajma. ");
INSERT INTO mazNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","O ndömortasa xenda ts'iquë cja yo 'ña ndömpjin'ño, pero 'ma go nocü, xenda na nojo yo que na ngueje yo pje nde ma c'ajna, na ndã'ã yo. Nguec'ua va chëzhi yo s'ü va 'ñe jä's'äji o̱ t'oxüji nu. ");
INSERT INTO mazNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","O mama c'ua c'ü 'na ejemplo, o xipjiji: ―C'ü ni manda Mizhocjimi chjëntjui nza cja ixcjüjnü c'ü o jñü 'naja ndixũ o huanba jñi vola o jocjüjnü, hasta 'ma o ixqui texe c'e cjüjnü, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Texe c'o jña c'o o mama e Jesús va xipji c'o nte, nde go mama o ejemplo. Dya zopjüji ne rí 'naja jña c'ü dya ro mama o ejemplo. ");
INSERT INTO mazNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nguec'ua ya ma sädä o̱ jña Mizhocjimi c'ü vi mama c'e profeta: Texe c'o rá xipjiji, rá mama o ejemplo. Rá mangö c'o dya 'mãrã ndeze 'ma o dyät'ä Mizhocjimi ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nuc'ua e Jesús o 'ñezhe c'o nte. Cjanu o cjogü c'ua a mbo cja c'e ngumü nu ja mi oxü. Xo sä c'ua c'o o̱ discípulo o 'ñe xipjiji: ―Xitscöjme ja ga cja c'o ndömpjin'ño c'o o ma mbodüji cja juajma, c'ü i̱ xipji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","O ndünrü c'ua angueze: ―Nu c'ü o mbodü na jo ndëxü nguezgö rvá ẽcjö cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","C'e juajma, ngue ne xoñijõmü c'ü. C'o na jo ndëxü, ngue c'o o̱ t'i Mizhocjimi c'ü manda. Nu c'o pjin'ño, ngue c'o nte c'o o̱ t'i c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nu c'ü mi üvi c'e lamu, ngue c'ü dya jo c'ü. C'e dagrëxü, ngue 'ma ra nguins'i nu xoñijõmü. Nu c'o ndagrëxü, ngue c'o o̱ anxe Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","C'ua ja nzi va jmutüji c'o pjin'ño cjanu ndüt'üji cja trasivi, je xo rga cjanu 'ma ra nguins'i nu xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","C'o ra tsjapüji a cjanu ra sufre, ngue c'o cja na s'o, 'ñe cjapü nu minteji xo ga tsjaji c'o na s'o. Na ngueje nutscö rvá ẽcjö cja Mizhocjimi, rá täcjö c'o ín anxe ra ẽ ra 'ñe jmutüji anguezeji, cja rrũ pjongüji nu ja ri mandagö. ");
INSERT INTO mazNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Cja rrũ mboch'üji a ma a linfiernu nu ja me rva yorü 'naja trasivi. Je ra huëji nu, y me ra nguünxt'ü o̱ s'ibi rgá sufreji na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nuc'ua c'o vi tsja na jo ra bübüji nu ja ra manda c'ü nu Tataji c'ü bübü a jens'e, me ri juës'i c'o nza cja e jyarü. Nu'tsc'eji bübü in tsõji, rí dyäräji na jo yo jña yo rí xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’C'ü ni manda Mizhocjimi, xo chjëntjui nza cja 'naja caja c'ü mi quiji na puncjü c'o me ni muvi, c'ü vi dyögüji cja 'naja juajma. O chöt'ü 'naja bëzo, cjanu o dyögütjo na yeje. Me go mäjä c'e bëzo na ngue vi chöt'ü c'e caja, nguec'ua va ma mbö'ö texe c'o mi pë's'i, cjanu o ma ndõmü c'e juajma ngue c'ua ro tsjapü o̱ cjaja c'e caja. ");
INSERT INTO mazNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’'Ma cjó c'o jodü ja rgá tsjapü o̱ t'i Mizhocjimi c'ü manda, nuc'ü, chjëntjui nza cja 'na comerciante c'ü mi jodü perla c'o me ni muvi. ");
INSERT INTO mazNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nuc'ua o mbãrã c'e bëzo ja mi pë's'iji 'naja perla c'ü me mi muvi na puncjü. Nguec'ua va ma mbö c'ua texe c'o mi pë's'i, cjanu o ndõmü c'ua c'e perla. ");
INSERT INTO mazNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’C'ü ni manda Mizhocjimi c'ü bübü a jens'e, chjëntjui 'naja rre c'ü ra mbät'äji cja tazapjü, ra zo'o texe c'o pje nde ma jmõ. ");
INSERT INTO mazNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nuc'ua 'ma ya ra nizhi c'e rre, c'o mbëjmõ ra pjons'üji a ma a ñünü. Cja rrũ mimiji c'ua, ra juajnüji c'o na jo jmõ, ra dyüt'üji cja c'o o̱ bos'iji c'o. Pero c'o jmõ c'o dya s'a'a, ra mboztjoji nu c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Je xo rga cjatjonu, 'ma ra nguins'i nu xoñijõmü. Ra ẽ c'o o̱ anxe Mizhocjimi ra 'ñe pjongüji c'o nte c'o na s'o a nde cja c'o na jo. ");
INSERT INTO mazNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nuc'ua ra mboch'üji c'ua ja rva yorü 'naja trasivi nu ja ra huëji, y me ra nguünxt'ü o̱ s'ibi rgá sufreji na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Xe go xipjiji c'ua: ―¿Cjo i̱ pãrãgueji dya texe yo ya ró xi'tsc'öji? O ndünrü c'ua anguezeji: ―Jã, ín Jmuts'ügöjme, ya ró pãrãjme. ");
INSERT INTO mazNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nuc'ua angueze o xipjiji c'ua: ―I̱ pãrãji c'o ejemplo c'o ró xi'tsc'öji. Nguec'ua rí xi'tsc'öji, texe c'o ya mbãrã na jo ja ga manda Mizhocjimi a jens'e, chjëntjui 'naja bëzo c'ü ri pë's'i 'naja caja c'ü ri quiji c'o cja nuevo, 'ñe c'o ya mezhe. 'Ma pje c'o rguí jyodü c'o ri cãrã o̱ ngumü c'e bëzo, ra ma c'e bëzo ra ma ngama, o ra ma jñümü nu ja ri pë's'i c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nuc'ua 'ma mü o nguarü e Jesús o mama c'o ejemplo, cjanu o mbedye c'ua nu. ");
INSERT INTO mazNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Cjanu o ma nu ja mi menzumü. Cjanu o cjogü a mbo cja nintsjimi o xöpü c'o nu menzumüji. Nguec'ua anguezeji me co nguijñiji, o mamaji: ―¿Ja va mbãrã nu, 'ñe ja ga tsja'a yo me na nojo yo nunca rí nugöji? ");
INSERT INTO mazNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Cjo dya nguejnu o̱ t'i c'ü mi yaxü nu? ¿Cjo dya ngue nu nana c'ü ni chjũ e María? ¿Cjo dya ngue nu cjuarma e Jacobo, 'ñe e José, 'ñe e Simón, 'ñe e Judas? ");
INSERT INTO mazNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Cjo dya xo bübü c'o nu cjũ cja ne jñiñi va? Nama, ¿ja va mbãrã 'ma ne bëzo c'ü ni tsja yo? Maco xo menzumü va nu, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nguec'ua ma ünbüji e Jesús. E Jesús o xipji c'ua anguezeji: ―'Na profeta nde respetaoji nu ja dya ri menzumü y ätäji. Pero nu ja ri menzumü, dya respetaoji c'ü. Ni xo ri ngue c'o ri cãrã cja ngumü, dya xo respetaoji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nuc'ua e Jesús dya jocü nu na puncjü c'o mi sö'dyë, ni pje xe ro tsja, na ngueje dya mi ejmeji angueze. ");
INSERT INTO mazNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","E Herodes mi manda cja c'e xoñijõmü a Galilea. Nuc'ua c'o pa c'o, o dyärä e Herodes me mi mama c'o nte c'o mi cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","O mama c'ua e Herodes o xipji c'o o̱ mbëpji: ―Nu c'ü me nädäji, ngue e Juan c'ü mi jichi yo nte. O ndũ, pero pe ya tetjo, nguec'ua na zëzhi angueze ga jocü c'o sö'dyë. Y xo cja'a a cjanu na puncjü c'o na nojo, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","'Ma xe mi bübütjo e Juan, e Herodes mi bün'hui c'ü nu bëpe c'ü mi chjũ Herodías. Nu c'e ndixũ mi ngue o̱ su e Felipe c'ü nu cjuarma e Herodes. Nguec'ua ma mama e Juan ma xipji e Herodes: ―Dya pje ga jo rí 'ñenpe nu su nin cjuarma, embe. O ẽ c'ua 'na nu pa, o manda e Herodes o zürüji e Juan, o jyüt'üji co cadena, cjanu o ngot'üji a pjörü. ");
INSERT INTO mazNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Y nuc'ua e Herodes mi ne ro mbö't'ü e Juan. Pero mi sũ'ũ 'na pje ro tsjapü c'o nte, na ngueje mi junt'ü o̱ mü'büji c'ü mi profeta e Juan mi pätpä Mizhocjimi ma zopjü c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nuc'ua 'ma o cumple o̱ cjë e Herodes, o mbita o tsjaji o mbaxua. Nuc'ua c'ü o̱ xunt'i e Herodías o neme a jmi nu ja ma cãji. Me go mäjä c'ua e Herodes. ");
INSERT INTO mazNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","O xipji c'ua c'e xunt'i: ―C'ua ga mbãrã Cjimi 'ma pje rí dyötcü, nutscö rá da'c'ü, eñe e Herodes. ");
INSERT INTO mazNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nuc'ua c'ü nu nana c'e xunt'i o dyü't'ü o xipji c'ü pje ro dyötü e Herodes. O ma c'ua c'e xunt'i o ma xipji: ―Ixtí dyacö dya a ñi e Juan c'ü jichi yo nte, dyacö co 'naja mblato, eñe c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Me co ndumü c'ua c'e rey Herodes. Pero jo ni mbeñe c'ü vi nädä Cjimi, 'ñe c'ü ya vi dyärä c'o nte c'o ma cã'ã nu. Nguec'ua va manda ro unüji c'e xunt'i c'ü vi dyörü. ");
INSERT INTO mazNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","O manda ro ma jñüpcüji a ñi e Juan nu cja c'e pjörü. ");
INSERT INTO mazNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nuc'ua 'ma ya vi jñüpcüji o̱ ñi, cjanu o jünji c'ua cja 'naja mblato, cjanu o unüji c'e xunt'i. Cjanu o ma c'ua c'e xunt'i o ma unü c'ü nu nana. ");
INSERT INTO mazNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jo ni säjä c'ua c'o o̱ discípulo e Juan, o 'ñe ndunüji c'ü o̱ cuerpo e Juan. Cjanu o ma dyögüji c'ua c'ü. Cjanu o möji c'ua, o ma xiji e Jesús c'ü ya vi bö't'ü e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nuc'ua 'ma o mbãrã e Jesús c'ü vi mbö't'üji e Juan, o mbedye c'ua ja mi bübü. O ma c'ua cja 'naja bü'ü; je ro zät'ä nu ja dya cjó mi ndeñe, nu ja ro büntsjë. O mbãrã c'ua c'o nte c'ü vi dat'ü e Jesús cja c'e bü, ro mbes'e a 'nanguarü cja c'e tazapjü. Nguec'ua va mbedyeji cja c'o o̱ jñiñiji, o ngös'üji a ñünü ngue c'ua ro zät'äji nu ja ro zät'ä e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nuc'ua 'ma mü o mbes'e cja c'e bü, e Jesús o jñanda c'ü ya ma cã'ã na puncjü o nte. Y e Jesús o juentseji anguezeji, o jocü c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nuc'ua 'ma ya vi nzhä, o chëzhi c'o o̱ discípulo a jmi, o xiji: ―Nu va ja rí cãrãji, majyadü va. Ya xo nzhä'ä. Nguec'ua rí xipji yo nte ra möji cja c'o jñiñi, ra ma ndõmüji c'ü ra ziji. ");
INSERT INTO mazNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nuc'ua e Jesús o xipji c'o o̱ discípulo: ―Dya ni jyodü ra ma yo. Nu'tsc'eji rí unngueji c'ü ra ziji. ");
INSERT INTO mazNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","O ndünrü c'ua c'o discípulo o mamaji: ―Tsi'ch'atjo tjõmëch'i c'o jünji a 'ñecjua, cja na yeje jmõ'õ. Nguec'ua, ¿ja rgá sö rá 'huiñigöjme yo nte yo me na puncjü? ");
INSERT INTO mazNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","O mama c'ua e Jesús: ―Ma tsincöji a 'ñecjua c'o tjõmëch'i 'ñe c'o jmõ. ");
INSERT INTO mazNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nuc'ua e Jesús o xipji c'o nte ro mimiji cja t'ëbi. Cjanu o jñü c'ua c'o tsi'ch'a tjõmëch'i, 'ñe c'o yeje jmõ. Jo ni nä's'ä c'ua a jens'e va unü 'na pöjö Mizhocjimi. Cjanu o xëdyi c'ua c'o tjõmëch'i, o unü c'o o̱ discípulo. Nuc'ua c'o discípulo o unüji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Go ñõnüji texeji go nijmiji na jo. Xe go nguistjoji c'ua c'o ya nde mi ts'ipëraso, xe go nizhtjo doce bos'i. ");
INSERT INTO mazNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tsi'ch'a mil c'o bëzo c'o vi ñõnü; dya bezhe c'o ndixũ, ni ri ngue c'o ts'it'i, ni xo ri ngue c'o ts'ixut'i. ");
INSERT INTO mazNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nuc'ua e Jesús o xänbä c'o o̱ discípulo ro dat'üji cja c'e bü'ü, ro möji a 'nanguarü cja tazapjü. Nuc'ua 'ma ya mi ma c'o discípulo, e Jesús o xipji c'o nte ro möji o̱ ngumüji. ");
INSERT INTO mazNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nuc'ua 'ma ya vi ma c'o nte, o ma e Jesús cja 'naja t'eje, o ma dyötü Mizhocjimi. Nuc'ua 'ma ya vi xõmü, ya mi 'natsjë nu e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nu c'e bü'ü ya mi pa a nde cja c'e tazapjü. Pero me mi pjat'ü na zëzhi c'e ndeje cja c'e bü'ü, na ngueje c'e ndajma je mi 'ñeje nu ja mi ma c'e bü. ");
INSERT INTO mazNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nuc'ua 'ma ya ma 'ñetsajõmü, o ma e Jesús mi nzhodü a xes'e cja c'e ndeje; mi ma'a nu ja ma cã c'o o̱ discípulo cja c'e bü. ");
INSERT INTO mazNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nuc'ua c'o discípulo, 'ma mü o jñandaji ma nzhodü e Jesús a xes'e cja c'e ndeje, me co zũji c'ua go mapjüji na jens'e go manji: ―Chjã 'na piche nu va ẽ nu, eñeji va mapjüji. ");
INSERT INTO mazNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nuc'ua e Jesús o zopjüji o xipjiji: ―Nguezgö. Dya ra pi'tsc'eji, dya rí sũgueji. ");
INSERT INTO mazNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jo ni ndünrü c'ua e Pedro o xipji: ―Nu'tsc'e ín Jmuts'ügö, nu 'ma ngue'tsc'e, xitscö xo rá nzhodü a xes'e cja c'e ndeje rá ma tjün'c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","O ndünrü c'ua e Jesús o xipji: ―Chjä'dä, Pedro. O dagü c'ua e Pedro cja c'e bü, o nzhodü a xes'e cja c'e ndeje; mi ma'a nu ja ma ẽjẽ e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nuc'ua 'ma o zö'ö e Pedro que ma zëzhi c'e ndajma, me go zũ c'ua go mbürü go nguibi c'ua. Jo ni mapjü c'ua na jens'e, o mama: ―Nu'tsc'e ín Jmuts'ügö, tsjüxcö; 'ma jiyö rá quibigö cja ne ndeje. ");
INSERT INTO mazNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jo ni c'uana c'ua a dyë e Jesús go pënch'i e Pedro, o xipji: ―Nu'tsc'e dya i̱ṉ ejmezügö na jo. ¿Jenga i̱ yembeñe? ");
INSERT INTO mazNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nuc'ua 'ma ya vi ndes'evi cja c'e bü'ü, o böbü c'ua c'e ndajma. ");
INSERT INTO mazNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nuc'ua c'o discípulo c'o mi cã'ã cja c'e bü'ü, o ndüñijõmüji a jmi e Jesús, o xipjiji: ―Na cjuana o̱ T'itsc'e Mizhocjimi, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","'Ma ya vi zät'äji a 'nanguarü cja c'e tazapjü, o mbes'eji c'ua. Mi xiji a Genesaret c'e xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nuc'ua c'o bëzo c'o mi menzumü nu, o mbãrãji c'ü mi ngue e Jesús c'ü vi zät'ä nu. Nguec'ua o ndäjäji c'o ro ma cöste nu cja c'e jñiñi. Cjanu o sinpiji e Jesús texe c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","O tsja c'o nte o dyötüji sjëtsi e Jesús c'ü ro ndötpüji zö ri nguextjo o̱ fleco c'ü o̱ bitu angueze. Nuc'ua texe c'o o ndötpü, nde go ndis'i c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nuc'ua c'o fariseo 'ñe c'o mi xöpü o̱ ley Mizhocjimi, o mbedyeji a Jerusalén o säji cja e Jesús, o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Jenga yo in discípulogue, dya sũpüji yo tjũrü yo o zocüzüji c'o ín mboxatitaji? Maco dya xindyëji 'ma go ziji o xëdyi. ");
INSERT INTO mazNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","O ndünrü c'ua e Jesús o xiji: ―Nu'tsc'eji, ¿jenga i̱ṉ sũpqueji yo o̱ tjũrü c'o ín mboxatitaji? Maco dya i̱ṉ cjaji c'ü manda Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mizhocjimi mama a cjava: “Respetaoji nin tataji, 'ñe nin nanaji, y rí pjös'üji c'o rguí jyodüji. C'ü ra zadü nu tata o nu nana, ra mbö't'üji c'ü”, eñe Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Pero nu'tsc'eji nan'ño gui mangueji. I̱ṉ mangueji 'ma pje ni jyodü c'o nu tata 'naja nte, ra sö ra mama c'e nte ra xipji c'o nu tata: “Perdonaozüvi pero c'ü ro pjöxc'övi, ya ró mama rá mbeñe Mizhocjimi. Nguec'ua dya sö rá pjöxc'övi”, ra 'ñembevi. Nguec'ua nu'tsc'eji i̱ṉ fariseoji 'ñetsc'eji i̱ṉ xöpüteji i̱ṉ cjapüji c'ü dya ni muvi c'ü manda Mizhocjimi, na ngueje i̱ṉ jizhiji yo o̱ tjũrü c'o ín mboxatitaji. ");
INSERT INTO mazNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nu'tsc'eji i̱ṉ cjapqueji c'ü me na jotsc'eji, pero dya cjuana. Na cjuana c'ü o mama e Isaías c'ü ja ga cjatsc'eji. O mama a cjava: ");
INSERT INTO mazNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nujyo nte yo, sũcö yo, pero nguextjo co o̱ neji. C'o o̱ mü'büji, na jẽ bübü co nutscö. ");
INSERT INTO mazNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bë ga zũcö yo. Jizhiji yo o̱ tjũrü yo nte; cjapüji c'ü ri ngueje o̱ jña Mizhocjimi yo, eñe e Isaías va pätpä Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nuc'ua e Jesús o xipji c'o nte: ―Chëzhiji ga 'ñeva. Dyäräji na jo, ngue c'ua rí pãrãji ja ga cja. ");
INSERT INTO mazNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Zö dya ra xindyë 'na nte ante c'ü ra zi o xëdyi, pero dya ngue c'o jñõnü c'o ra s'onbü o̱ mü'bü c'ü rrã s'o c'e nte, iyö. C'ü ra s'onbü o̱ mü'bü c'e nte, ngue c'o na s'o c'o ra nguijñi a mbo o̱ mü'bü, cja rrũ ña c'o na s'o, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nuc'ua c'o discípulo o chëzhiji a jmi, o xiji: ―¿Cjo i̱ unnc'e ngüenda o üdü c'o fariseo 'ma o dyäräji c'o jña c'o i̱ mangue? ");
INSERT INTO mazNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","O ndünrü c'ua e Jesús o mama: ―Texe c'o za'a c'o dya ngant'a mi Tatagö c'ü bübü a jens'e, ra c'üs'ü c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jyëziji yo fariseo. Na ngueje cjapü jizhiji c'ü na jo 'ñiji c'o nte c'o dya pje pãrã, pero anguezeji chjëntji c'ü ri ndëzhöji. I̱ṉ pãrãgueji 'ma ra tsja 'naja ndëzhö ra ngüjnü nu mindëzhövi, ra zo'ovi nza yejui cja cöt'ü 'ma. ");
INSERT INTO mazNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","O ndünrü c'ua e Pedro o xipji e Jesús: ―Xitscöjme ja ga cja c'e ejemplo c'ü i̱ xitsijme mi ndajme. ");
INSERT INTO mazNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","O ndünrü c'ua e Jesús o mama: ―¿Cjo xo 'ñetsc'eji xo bë'tsc'eji c'ü rí pãrãgueji ja ga cja o jñõnü? ");
INSERT INTO mazNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Texe jñõnü c'o c'üt'ü 'naja nte'e, je nde sät'ä a mbeme c'o, y je nde ni mbedye a ndü'bü c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero c'o jña c'o pedye a ne 'naja nte, je ni 'ñeje cja o̱ mü'bü c'o. Nuc'o, ngue c'o ni s'onbü o̱ mü'bü c'e nte c'ü, ngue c'ua na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Je ngueje cja o̱ mü'bü yo nte, nu ja ni 'ñeje c'ü ni nguijñiji s'opjeñe, 'ñe c'ü ni pö't'ünteji, 'ñe c'ü ni tsãji o ndixũ, 'ñe yo ndixũ c'ü ni tsãji o bëzo. Je xo ni 'ñeje nu c'ü pje ni põnüji, 'ñe c'ü ni xosp'üji o bëchjine nu minteji, 'ñe c'ü ni santeji. ");
INSERT INTO mazNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nujyo, nguejyo ni s'odü o̱ mü'bü 'naja nte yo, dya ngue c'ü dya ni xindyë 'ma go zi o xëdyi. ");
INSERT INTO mazNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nuc'ua o mbedye nu e Jesús, o ma a ma cja c'o jñiñi a Tiro 'ñe a Sidón. ");
INSERT INTO mazNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nuc'ua 'ma ya mi pa e Jesús cja 'ñiji, o ẽ c'ua 'naja ndixũ c'ü mi menzumü a Canaán, c'ü vi mbedye cja c'ü o̱ jñiñi. Mi mapjü mi mama: ―Nu'tsc'e ín Jmuts'ügö o̱ mboxbëchets'ü e David, juentsquegö. Na ngueje ín xunt'i me 'nanga mbö't'ü; ya zürü 'naja s'ondajma. ");
INSERT INTO mazNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero e Jesús dya go ndüntü c'ü. Nuc'ua c'o o̱ discípulo e Jesús o chëzhiji a jmi e Jesús, o dyötüji na puncjü o xipjiji: ―Xöpüte, pjös'ü ne ndixũ, cja rrĩ xipji ra ma. Na ngue mapjü na jens'e ga ndünt'ü ín xütjüji. ");
INSERT INTO mazNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","O mama c'ua e Jesús: ―C'ü vi ndäcjö Mizhocjimi, ngue c'ü rá pjös'ü yo ín menzumügöji a Israel yo chjëntji nza cja ndënchjürü c'o ya bëzhi. Nguextjo yo vi ndäcjä rá pjös'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nuc'ua c'e ndixũ o ẽjẽ, o 'ñe ndüñijõmü a jmi e Jesús, o xipji: ―Nu'tsc'e ín Jmuts'ügö, pjöxcügö. ");
INSERT INTO mazNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","O ndünrü c'ua e Jesús: ―Dya jo ra jñünbüji o̱ xëdyi yo t'i, c'ü ra panbaji o dyo'o. ");
INSERT INTO mazNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","O mama c'ua c'e ndixũ: ―Jã, na cjuana c'ü i̱ṉ mangue, ín Jmuts'ügö. Pero zö jyëtsquijme dyo'o c'o in menzumügueji a Israel, i̱ṉ pãrãgue ja ga cja yo dyo'o, siji c'o ngünxëdyi c'o jäbä cja o̱ mexa nu jmuji, c'o jä'bä c'o ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","O ndünrü c'ua e Jesús o xipji: ―Nu'tsc'e ndixũ, na jo c'ua ja gui 'ñejme c'ü rá pjöxc'ü. Rá pjöxc'ü c'ua ja gui ñe, embe. Ixco jogü c'ua c'e ndajme c'ü o̱ xünt'i c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nuc'ua xe go matjo e Jesús, o cjogü a ñünü cja c'e tazapjü c'ü ni chjũ a Galilea. O ma cja 'na t'eje, o mimi c'ua nu. ");
INSERT INTO mazNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","O sä c'ua na puncjü o nte nu ja mi bübü e Jesús, ma sinpiji c'o mi sö'dyë. Ma sinpiji c'o mi me'dye, 'ñe c'o mi ndëzhö, 'ñe c'o mi ngone, 'ñe c'o mi dodyë, 'ñe c'o xe 'ñaja ndötc'ijeme. Ma ẽ'p'ẽji a jmi e Jesús. Nde go jocüji c'ua anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","C'o nte o jñandaji c'o mi ngone o mbürü o ña'a c'o, 'ñe c'o mi dodyë me go jogü c'o, 'ñe c'o mi me'dye me go nzhodü na jo c'o, 'ñe c'o mi ndëzhö me co jñanda c'ua c'o. Nguec'ua c'o nte me go nguijñiji na ngue nunca mi jandaji a cjanu. Y me co ma't'üji c'ua c'ü o̱ Mizhocjimi c'o menzumü a Israel, mi mamaji c'ü me na nojo angueze. ");
INSERT INTO mazNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nuc'ua e Jesús o ma't'ü c'o o̱ discípulo ro chëzhiji a jmi, cjanu o xipjiji: ―Rí juentscö yo nte, na ngueje ya ëdyi jñipa c'ü ya rí cãrgöji va yo, y dya cja jünji pje ra ziji. Dya rí ne rá täjä ra ma o̱ ngumüji c'ü dya ra ziji o xëdyi; ra tõgüji cja 'ñiji. ");
INSERT INTO mazNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","O ndünrü c'ua c'o o̱ discípulo o xipjiji e Jesús: ―¿Ja rá tötc'öjme tjõmëch'i c'ü rguí nijmi yo nte yo na puncjü? Na ngueje rí cãrgöji va cja ne majyadü. ");
INSERT INTO mazNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","O ndünrü c'ua e Jesús o xipjiji: ―¿Ja nzi tjõmëch'i va jüngueji? O manji anguezeji: ―Yencho tjõmëch'i, cja na ja nzitjo jmõ'õ. ");
INSERT INTO mazNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nuc'ua e Jesús o manda c'o nte ro minji a jõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Cjanu o jñü c'ua c'o yencho tjõmëch'i, cja na 'ñe c'o jmõ'õ, cjanu o unü 'na pöjö Mizhocjimi. Cjanu o xëdyi c'ua, cjanu o unü c'o o̱ discípulo. Nuc'ua c'o o̱ discípulo o unüji c'ua c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nuc'ua go ñõnüji texeji go nijmiji na jo. Y xe go nguistjoji c'o ts'ipëraso c'ü vi mboncjütjo, c'o xe yencho bos'i c'o go nizhtjo. ");
INSERT INTO mazNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mi nziyo mil c'o bëzo c'o vi ñõnü; dya mbezheji c'o ndixũ, ni ri ngueje c'o ts'it'i, ni xo ri ngueje c'o ts'ixut'i. ");
INSERT INTO mazNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nuc'ua e Jesús o xipji c'o nte ro möji o̱ ngumüji. Cjanu o dat'ü c'ua cja c'e bü'ü, o ma cja c'o jñiñi a ma a Magdalá. ");
INSERT INTO mazNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","'Ma ya vi zät'ä nu e Jesús, o säjä c'ua c'o fariseo 'ñe c'o saduceo. Chaque o ẽ dyönüji e Jesús o xipjiji: ―Jítscöjme 'na señal a jens'e c'ü me na nojo, ngue c'ua rá pãrãjme pje pjë'tsc'e. ");
INSERT INTO mazNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","O ndünrü c'ua e Jesús o xipji: ―'Ma ya mbat'ütjo a jens'e 'ma nzhä'ä, i̱ṉ mangueji ya ra jopa c'ü na ye nu pa. ");
INSERT INTO mazNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","'Ma xõrü 'ma va cjins'i tangõmü, i̱ṉ mangueji ra 'ñe dyebe 'ma. Nu'tsc'eji i̱ṉ cjapüji na jots'üji, i̱ṉ unüji ngüenda ja ga 'ñetse a jens'e, nguec'ua i̱ṉ pãrãji ja ga cja yo jopa, 'ñe yo ra 'ñeje dyebe. Pero dya i̱ṉ unnc'eji ngüenda ja ga pëpji Mizhocjimi yo cjë yo rí cãrãji dya. ");
INSERT INTO mazNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nu'tsc'eji i̱ṉ cãrãji yo cjë dya, na s'otsc'eji i̱ jyëzgueji Mizhocjimi. Nguec'ua i̱ṉ ötcügöji pje rí jñandgueji ngue c'ua rí pãrãgueji pje pjëtscö. Pero dya ra ch'a'c'eji pje rí jñandgueji; nguextjo c'ü o tsja e Jonás c'ü mi profeta, embeji. Ixco ma c'ua e Jesús o zogütjo c'o fariseo 'ñe c'o saduceo. ");
INSERT INTO mazNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nuc'ua c'o discípulo o möji a 'nanguarü cja c'e tazapjü. O jyombeñeji, dya jñünüji o tjõmëch'i. ");
INSERT INTO mazNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nuc'ua e Jesús o xipjiji: ―Pjötpüji ngüenda c'o o̱ levadura c'o fariseo 'ñe c'o saduceo. ");
INSERT INTO mazNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","C'o discípulo mi pötma mamaji: ―Xitscöji a cjanu e Jesús, na ngueje c'ü dya ró jüngöji o tjõmëch'i. ");
INSERT INTO mazNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mi pãrã e Jesús c'ü mi cjijñiji, nguec'ua va xipjiji c'ua: ―Nu'tsc'eji, dya i̱ṉ ejmezügöji na jo. ¿Jenga i̱ṉ pötqui dyönütsjëji na ngue c'ü dya i̱ jñüji o tjõmëch'i? ");
INSERT INTO mazNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Cjo dya be i̱ṉ pãrãgueji c'ü sö rá da'c'eji c'ü rí si'iji? ¿Cjo dya i̱ṉ mbennc'eji c'o tsi'ch'a tjõmëch'i? Maco o nijmi c'o tsi'ch'a mil o bëzo. ¿Cjo dya i̱ tsis'itjoji ja nzi bos'i c'o o mboncjütjo? ");
INSERT INTO mazNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Cjo dya xo i̱ṉ mbeñeji c'o yencho tjõmëch'i? Maco xo nijmi c'o nziyo mil o bëzo. Maco xo i̱ tsis'itjoji ja nzi bos'i c'o ts'ipëraso c'o o mboncjütjo. ");
INSERT INTO mazNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ró xi'tsc'öji rí pjötpüji ngüenda c'o o̱ levadura c'o fariseo 'ñe c'o saduceo, pero dya ngue c'o tjõmëch'i c'o ró mangö. ¿Jenga dya i̱ṉ unnc'eji ngüenda? ");
INSERT INTO mazNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nuc'ua, cja mbãrã c'ua c'o discípulo pje mi ne ro mama e Jesús va xipjiji ro mbötpüji ngüenda c'o o̱ levadura c'o fariseo, 'ñe c'o saduceo. O mbãrãji e Jesús vi jyëtsi o levadura c'o o̱ tjũrü c'o fariseo 'ñe c'o saduceo. O unüji ngüenda c'ü ro mbötpüji ngüenda c'o o̱ tjũrüji, dya ro tsjaji. ");
INSERT INTO mazNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nuc'ua e Jesús o ma a ma cja c'e jñiñi a Cesarea de Filipo. 'Ma o zät'ä nu, o tsja t'önü e Jesús o xipji c'o o̱ discípulo: ―¿Pje mama yo nte'e pje pjëtscö nutscö rvá ẽcjö cja Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Anguezeji o manji: ―Bübü c'o mama ngue'tsc'e e Juan c'ü mi jichi yo nte; 'ñaja c'o mama ngue'tsc'e c'e profeta Elías; 'ñaja c'o mama ngue'tsc'e c'e profeta Jeremías, o 'ma jiyö, c'ü 'naja profeta c'o ya ndũ. ");
INSERT INTO mazNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","O ndünrü c'ua e Jesús o xipjiji: ―Natsc'eji, ¿pje xo i̱ṉ mangueji, pje pjëtscö? ");
INSERT INTO mazNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","O ndünrü c'ua e Simón Pedro o xipji: ―Nutscö rí mangö ngue'tsc'e Cristo. Ngue'tsc'e o̱ T'itsc'e Mizhocjimi c'ü ixi bübü. ");
INSERT INTO mazNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","O ndünrü c'ua e Jesús o xipji: ―Nu'tsc'e Simón, o̱ t'itsc'e e Jonás, dya cjó xi'tsc'e 'na nte c'ü o̱ T'izgö Mizhocjimi. Nu c'ü o tsja'c'e i̱ pãrãgue, ngueje mi Tatagö c'ü bübü a jens'e. Nguec'ua ngue nu rgui mäcje. ");
INSERT INTO mazNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nutscö xo rí xi'tsc'ö ngue'tsc'e e Pedro. Nza cjatsc'e 'na ndojo c'ü ni jyäbäji ngumü. Na ngue c'e jna c'ü rí xipjigue yo nte, na puncjü c'o rá cjapcö ín ntegö. Zö ra ndũji, pero ra büntjo na ye co nuzgö c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Rá da'c'ü poder cja c'o nte c'o unü o̱ mü'büji Mizhocjimi c'ü manda. Rá da'c'ü poder cja ne xoñijõmü rí xipjiji pje ni mbë c'o na s'o c'o dya ra tsjaji, y xo rí xipjiji pje ni mbë c'o na jo c'o ra tsjaji. Nu c'ü rí xipjiji, ngue c'ü mama Mizhocjimi pje ni mbë c'o na jo ra tsjaji, 'ñe pje ni mbë c'o dya jo c'o dya ra tsjaji. ");
INSERT INTO mazNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Cjanu o xipji c'ua c'o o̱ discípulo: ―Dya cjó rí xiqueji cjo nguetscö Cristo, embeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ndeze c'o pa c'o, o mbürü e Jesús o xipji c'o o̱ discípulo c'ü mi jyodü ro zädä. O xipjiji: ―Ni jyodü rá magö a ma a Jerusalén, ra jñünncöji ngüenda rá sufregö na puncjü; ra tsja c'o tita c'o manda, 'ñe c'o ndamböcjimi, 'ñe c'o xöpüte. Xo ni jyodü ra mbötcöji, pero rá tetcjö c'ü na jñi nu pa, embeji c'o discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nuc'ua e Pedro o ndans'avi e Jesús ro ñatsjëvi. Cjanu o mama c'ua e Pedro o huënch'i e Jesús: ―Nu'tsc'e ín Jmuts'ügö, ra juen'tsc'e Mizhocjimi, dya ra jyëzi c'ü ra tsja'c'üji yo i̱ṉ mangue. ");
INSERT INTO mazNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nuc'ua e Jesús o jñanda e Pedro, o xipji: ―C'ueñe ín jmigö, na ngueje i̱ dyätque c'ü dya jo i̱ xitscö yo jña yo. Na ngueje c'e pjeñe c'ü i̱ṉ cjijñigue dya, dya ngue c'ü cjijñi Mizhocjimi; ngueje c'ü cjijñi yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nuc'ua e Jesús o xipji c'o o̱ discípulo: ―'Ma cjó c'o ne ra ndennguegö ra tsja c'ua ja nzi rgá cjagö, ni jyodü dya cja ra tsja c'o netsjë angueze. Y ra bübü dispuesto ra sufre o ra ndũ'ũ. Y ra tsjacjuana ra ndennguegö. ");
INSERT INTO mazNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","'Ma cjó c'o dya bübü dispuesto ra sufre o ra ndũ nguec'ua dya ra ne ra ndenngue co nutscö, dya ra chöt'üji c'ü rguí bübütjoji. C'o tenngue co nutscö, zö ra mbö't'üji, pero ra chöt'üji c'ü rguí bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nu 'ma ro tsja 'naja nte ro tsjapü o̱ cjaja texe yo bübü va cja ne xoñijõmü, pero 'ma dya ro 'ñejmezü, ¿pje ro dyeje 'ma? Na ngueje ro jyëzi Mizhocjimi c'e nte. Y 'ma ya jyëzi Mizhocjimi c'e nte, zö ro tsja c'e nte ro unü c'ua Mizhocjimi texe c'o ri pë's'i, pero dya ro ẽ bübü 'ma Mizhocjimi co c'e nte. ");
INSERT INTO mazNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nutscö rvá ẽcjö cja Mizhocjimi, rá ẽcjö na yeje co c'o ín anxe. Me rrã zö c'ua ja rva ẽcjö, c'ua ja ga cja me na zö c'ü mi Tatagö. Nuc'ua c'o o tsja na jo, rá unüji c'o na jo. Pero c'o o tsja na s'o, rá cjapüji ra sufreji. ");
INSERT INTO mazNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na cjuana rí xi'tsc'öji, bünc'ua ja nzi yo dya ra ndũ hasta 'ma cja ra jñandgöji c'ua ja rga cjazgö, 'ma rá ẽcjö rá ẽ manda. Nutscö rvá ẽcjö cja Mizhocjimi, ra jñandgöji c'ua ja ga cjazgö me rrã zëzhizgö, eñe e Jesús va xipji c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Xe go mezhtjo c'ua 'nanzo, e Jesús o zidyi e Pedro, 'ñe e Jacobo, 'ñe e Juan c'ü nu cjuarma e Jacobo. O mötsjëji c'ua cja 'na t'eje c'ü me ma jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","'Ma mi cãrãji nu, 'nangua juëns'i c'ua o̱ jmi e Jesús nza cja e jyarü. Y c'o o̱ bitu, me ma t'öxü me mi juëns'i. ");
INSERT INTO mazNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Cjanu o 'ñetse c'ua e Moisés, 'ñe e Elías, ya mi ñaji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jo nu ña c'ua e Pedro o xipji e Jesús: ―Nu'tsc'e ín Jmutsc'öjme, me na jo rí cãrãjme va co nu'tsc'e 'ñe e Moisés 'ñe e Elías. 'Ma i̱ṉ negue, rá ät'äjme va jñi ngumü. 'Naja c'ü rá ä'tc'öjme, 'naja c'ü rá ä'tp'äjme e Moisés, 'naja e Elías. ");
INSERT INTO mazNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","'Ma ndänt'ä ma ña e Pedro, o sä c'ua 'naja ngõmü c'ü me mi juëns'i, o 'ñe ngobü anguezeji. Xo t'ärä c'ua 'naja jña cja c'e ngõmü c'ü mi mama a cjava: ―Nujnu ngue ín Ch'igö, nu me rí ne'e y me rí mäpägö. Ni jyodü rí dyätqueji nu. ");
INSERT INTO mazNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nuc'ua 'ma mü o dyärä a cjanu c'o discípulo, 'nangua nügüji na ngueje me co pizhiji va zũji. ");
INSERT INTO mazNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nuc'ua o chëzhi e Jesús o 'ñe's'e o̱ dyë c'o discípulo, o xipjiji: ―Nu'tsc'eji ñangueji, dya rí sũji. ");
INSERT INTO mazNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nuc'ua 'ma o jñüs'ü o̱ ñi c'o discípulo, dya cja jñandaji e Moisés 'ñe e Elías; ya mi nguextjo e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nuc'ua 'ma ya ma sjöbüji cja c'e t'eje, cjanu o mama e Jesús o xipjiji: ―Dya cjó rí xipjiji yo cja i̱ jñandaji. Nutscö rvá ẽcjö cja Mizhocjimi, 'ma rá tũgö cja rrũ tegö, cja rí xipjiji 'ma yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nuc'ua c'o discípulo o dyönüji e Jesús: ―¿Jenga mama c'o xöpü o̱ ley Mizhocjimi c'ü ni jyodü ot'ü ra ẽjẽ na yeje e Elías, cja rrũ ẽjẽ Cristo? ");
INSERT INTO mazNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","O ndünrü c'ua e Jesús o mama: ―Na cjuana c'e jña c'ü mamaji, c'ü ot'ü ra ẽ na yeje e Elías ra 'ñe jocü texe. ");
INSERT INTO mazNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero nuzgö rí xi'tsc'öji, e Elías ya ẽ na yeje c'ü. Pero dya go mbãrã yo nte pje mi pjëzhi c'ü; go tsjapüji c'ü go ne anguezeji. Je xo rga cjazgö nu. Nutscö rvá ẽcjö cja Mizhocjimi, rá sufregö c'ua ja rgá ne yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","O mbãrã c'ua c'o discípulo c'ü vi mama e Jesús. O unüji ngüenda cjó mi ngue c'ü vi jyëtsivi e Elías; o mbãrãji c'ü vi jyëtsivi e Juan c'ü mi jichi yo nte cja ndare. ");
INSERT INTO mazNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nuc'ua 'ma o zät'äji cja c'o nte, o peje c'ua 'naja bëzo cja c'o nte, o 'ñe ndüñijõmü a jmi e Jesús, o xipji: ");
INSERT INTO mazNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Nu'tsc'e ín Jmuts'ügö, juentsquegö c'ín ch'i, na ngueje me pö't'ü o̱ taque, ndajmetjo ga ndũ. Ya na puncjü ga zo a sivi, y na puncjü ga c'ot'ü cja ndeje. ");
INSERT INTO mazNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ró sinpigö yo in discípulo; anguezeji dya go sö go jocüji. ");
INSERT INTO mazNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Cjanu o ndünrü c'ua e Jesús o xipji c'o discípulo: ―Nu'tsc'eji i̱ṉ cãrãji dya yo cjë dya, dya jo ga pjeñe c'o i̱ṉ cjijñiji. ¿Jenga dya i̱ṉ creozüji rá pjöxc'üji rí tsjaji c'o na nojo? Maco ya mezhe rí cãrãgöji, ya mezhe rí pë'sc'ö paciencia co nu'tsc'eji. Ma sinquiji a 'ñecjua c'e t'i. ");
INSERT INTO mazNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nuc'ua o tsja e Jesús o huënch'i c'e ndajma c'ü dya jo c'ü vi zürü c'e t'i, o xipji ro mbedye. Jo ni mbedye c'ua c'e ndajma. Ixco jogü c'ua c'e t'i c'e ndajme c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nuc'ua o chëzhi c'o discípulo a jmi e Jesús, o xipjitsjëji: ―¿Jenga dya sö ro pjombgüjme c'e ndajma? ");
INSERT INTO mazNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","O ndünrü c'ua e Jesús o xipjiji: ―Na ngueje dya i̱ṉ ejmeji na jo. Na cjuana rí xi'tsc'öji, nu 'ma rí jñunt'ü in mün'c'eji c'ü ra dya'c'eji Mizhocjimi c'ua ja nzi gui dyötqueji, ra sö rí xipjiji ne t'eje: “Chjans'a ga manu”, rí 'ñembeji, ra ma c'ua. Nu 'ma rí 'ñejmeji a cjanu Mizhocjimi, texe nde ra sö rí tsjaji, zö dya nda i̱ṉ ejmeji. ");
INSERT INTO mazNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Na puncjü o ndajma nza cja c'e ndajma c'ü vi zürü c'e t'i, pero dya ra mbedye ne ri 'naja c'o. Nguextjo 'ma rí dyötüji Mizhocjimi y rí mbempjeji, ra mbedye c'ua c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nuc'ua 'ma mi nzhodüji a ma a Galilea, o mama e Jesús o xipji c'o o discípulo: ―Nutscö rvá ẽcjö cja Mizhocjimi, ra nzhögügöji cja yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Y ra mbötcüji. Pero c'ü na jñi nu pa'a rá tetcjö, embeji. Me co nzhumüji c'ua na puncjü anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nuc'ua 'ma o zät'äji a Capernaum, o sä c'ua c'o mi jmutü o merio c'o mi örüji para cja c'e templo. O chëzhiji c'ua a jmi e Simón Pedro, o xipjiji: ―Na nin xöpütegueji, ¿cjo xo cjõt'ü c'o örüji? ");
INSERT INTO mazNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","O ndünrü c'ua e Pedro o xipjiji: ―Jã, xo cjõt'ü c'ü, embe c'o. Nuc'ua 'ma o cjogü e Pedro a mbo cja c'e ngumü, ya xmi pãtpã e Jesús c'ü pje ro mama e Pedro. Nguec'ua ot'ü o ña c'ua e Jesús o xipji: ―Yo rey yo manda cja ne xoñijõmü, 'ma jũ'p'üji o t'opjü, ¿cjo ngue c'o nu menzumüji c'o ötüji, o ngue c'o dya menzumüji? ¿Pje i̱ṉ mangue, Simón? ");
INSERT INTO mazNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","O ndünrü c'ua e Pedro o mama: ―Ngue c'o dya o̱ menzumüji c'o ötüji. O xipji c'ua e Jesús: ―Jã, ngue c'o dya o̱ menzumüji. Nguec'ua nujyo nu menzumüji, dya ni jyodü ra ngõt'ü 'ma yo. ");
INSERT INTO mazNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero pa dya ra üdü c'o örü ra nguijñiji na s'o rí cjaji, na jo rá cjõ't'üji c'ü örüji. Nguec'ua rí mague cja c'e tazapjü, ma pät'ä 'naja gancho. Nuc'ua c'e jmõ c'ü ot'ü rí sürü, rí pënch'i rí xejpje a ne'e. Rí chö'tp'ü c'ua 'naja t'opjü rí jñü'p'ü, ya xtí ma tsjõ't'ü c'ü t'ötcüvi. ");
INSERT INTO mazNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nuc'ua c'e ndajme c'ü, o jmurü c'o discípulo cja e Jesús, o mamaji: ―¿Cjó ngue c'ü nda na nozgöjme, nutscöjme ró unü ín mü'büjme Mizhocjimi c'ü manda?, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nuc'ua e Jesús o ma't'ü 'naja ts'it'i. O 'ñe'p'e c'ua a nde anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Cjanu o xipjiji: ―Nu'tsc'eji i̱ṉ cjapüji na nots'üji. Na cjuana c'ü rí xi'tsc'öji, ni jyodü rí jyëziji c'e pjeñe c'ü i̱ṉ cjijñiji a cjanu, rí tsjaji nza cja 'na ts'it'i c'ü dya cjapü na nojo. 'Ma jiyö, dya ra sö Mizhocjimi a jens'e ra tsja'c'eji o̱ ntetsc'eji ra mandats'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ne ts'it'i, dya cjapü na nojo nu. Nu c'o ga cjanu rgá tsja, ngue c'o nda rrã nojo cja c'o cjapü Mizhocjimi o̱ nte. ");
INSERT INTO mazNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","C'o ra recibido 'naja ts'it'i nza cja ne ts'it'i, na ngueje c'ü ni 'ñejmezgö c'e ts'it'i, chjëntjui c'ü ri nguezgö recibidozügö c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Cãrã c'o chjëntcjui nza cja ts'it'i na ngueje dya cjapüji na nojo pero ejmezgö c'o. 'Ma cjó c'o ra tsjapü ra tsja na s'o 'na c'o ejmezgö, ra nduns'ü 'ma na puncjü o̱ nzhubü. Xenda rvá jo ro 'nutpü 'na travacjüjnü o̱ dyizi c'e nte c'ü, cja rrũ ma pant'aji cja trazapjü nu ja na jẽ'ẽ, que na ngueje c'ü ro tsjapü ro tsja na s'o a cjanu 'na c'ü ejmezgö. ");
INSERT INTO mazNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Siempre bübü o nte c'o cjapü ra tsja c'o na s'o yo nu minteji. Juejme c'o cjapü a cjanu yo nu minteji; Mizhocjimi ra tsjapü me ra sufreji. ");
INSERT INTO mazNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Maco i̱ṉ mamaji ngue in dyëgueji o in cuagueji c'ü cja'c'üji rí tsjaji c'o na s'o, dyocüji 'ma, panaji. Na ngueje zö ri 'natjo in dyëji zö ri 'natjo in cuaji, pero xenda na jo rí ma bübütjoji co Mizhocjimi, que na ngueje 'ma ri tũ nza ye in dyëji 'ñe in cuaji ra pantc'aji cja c'e tasivi c'ü nunca ra juench'e. ");
INSERT INTO mazNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Maco i̱ṉ mamaji ngue in chögueji c'ü cja'c'eji rí tsjaji c'o na s'o, jñü'müji 'ma, panaji. Na ngueje zö ri 'natjo in chöji pero xenda na jo rí ma bübütjoji co Mizhocjimi, que na ngueje ri yeje in chöji ra pantc'aji cja c'e sivi a linfiernu. ");
INSERT INTO mazNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Pjötpüji ngüenda, dya rí tsjapüji menu ne ri 'naja yo chjëntjui ts'it'i na ngueje ejmezüji. Na ngue rí xi'tsc'öji cãrã c'o o̱ anxe Mizhocjimi c'o pjörü na jo yo. Y c'o anxe cãrãji a jmi c'ü mi Tatagö c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","C'ü rvá ẽgö cja Mizhocjimi, ngueje c'ü rvá ẽ jodü c'o ya bëzhi, rá salvaji. ");
INSERT INTO mazNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Pje i̱ṉ mangueji? 'Ma ri tsãjã 'naja ciento ndënchjürü 'naja bëzo, 'ma ra xõgü 'naja, ¿cjo dya ra zogü c'o noventa y nueve, ra ma jyodü c'ua c'ü ya rguí bëzhi? Jã, ra ma jyodü. ");
INSERT INTO mazNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na cjuana rí xi'tsc'öji 'ma ra chöt'ü c'ü vi xõgü, xenda ra mäpä c'ü, que na ngueje c'o noventa y nueve c'o dya bëzhi. ");
INSERT INTO mazNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Je xo ga cjatjonu c'ü mi Tatagö c'ü bübü a jens'e; dya ne'e c'ü ra bëzhi o̱ aljma ne ri 'naja yo ejmezgö, zö chjëntji ts'it'i c'ü dya cjapüji na nojo. ");
INSERT INTO mazNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’'Ma ra tsja'c'eji na s'o nin cjuarmaji, möji rí ma zopjütsjëji. 'Ma ra dyä'tc'äji c'o rí xipcjeji, ya i̱ jo'tp'ügueji 'ma c'e cjuarma c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero 'ma dya ra dyä'tc'ä c'o rí xipjiji, sidyiji xe 'naja o yeje cjuarma, ngue c'ua ra bübü c'o ra mbãrã c'ua ja rgui ñaguevi c'e cjuarma c'ü pje tsja'c'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nu'ma dya xo ra tsjapü ngüenda c'e cjuarma c'o yeje o jñi c'o rí möji, nu'ma, rí möji rí ma cösteji 'ma jmurü c'o cjuarma. 'Ma ra tsja c'e cjuarma, dya ra dyätä texe c'o cjuarma, dya cja rí tsjapüji nin cjuarmaji 'ma. Na ngueje chjëntjui c'o dya rí menzumügöji c'o dya ma't'ü Mizhocjimi. Y chjëntjui yo publicano yo xiji na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Nu'tsc'eji rí xipcjeji yo nin cjuarmaji pje ni mbë c'o na s'o c'o dya ra tsjaji. Xo rí xipcjeji pje ni mbë c'o na jo c'o ra tsjaji. Na cjuana rí xi'tsc'öji, nu c'ü rí xipcjeji ngueje c'ü mama Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Na cjuana rí xi'tsc'öji na yeje, 'ma i̱ṉ yejui, 'ñe 'ma 'natjo jña c'ü i̱ṉ mamavi gui dyötüvi Mizhocjimi nucjuã cja ne xoñijõmü, nuc'ua c'ü mi Tatagö c'ü bübü a jens'e ra tsja c'ua ja gui dyötquevi c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Na ngueje nu c'ua ja ri bübü c'o ra matcügö, zö ri yetjo o jñitjo, nujnu je rá bünc'ö a nde. ");
INSERT INTO mazNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nuc'ua o chëzhi e Pedro o xipji e Jesús: ―Nu'tsc'e ín Jmuts'ügö, ¿ja nzi ra zäs'ä rga perdonaogö yo mi cjuarma 'ma ra tsjacö c'o na s'o? ¿Cjo sietetjo vez rga perdonao? ");
INSERT INTO mazNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Cjanu o ndünrü c'ua e Jesús o xipji: ―Dya rí xi'tsc'ö sietetjo. Rí xi'tsc'ö rí perdonaogue hasta setenta c'o nde ga siete; siempre rí perdonaogue. ");
INSERT INTO mazNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Nu c'ü manda a jens'e chjënjui nza cja 'naja c'ü manda c'ü o mbeñe o tsjaji ngüenda c'o nu mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nuc'ua 'ma o mbürü o tsja ngüenda, o sinpiji 'naja bëzo c'ü mi tunpü na puncjü millón o mbëxo. ");
INSERT INTO mazNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero c'e bëzo, dya mi jün pje rví ngõ't'ü c'o mi tũ'ũ. O manda c'ua c'ü nu lamu ro mböji c'e bëzo, 'ñe c'ü nu su, 'ñe c'o o̱ t'i, 'ñe c'o pje xe mi pë's'i, ngue c'ua ro ngõ't'ü c'o mi tũ c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jo ni ndüñijõmü c'ua c'e mbëpji a jmi c'ü nu lamu, o xipji: “Nu'tsc'e ín lamuts'ügö, mbãxtjo nin chjũ, chepquegö ngue c'ua rá cjõ'tc'ü texe c'o rí tun'c'ü”, eñe c'e mbëpji c'ü mi tũ na puncjü o merio. ");
INSERT INTO mazNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nuc'ua c'e lamu o juentse c'e mbëpji. Cjanu o 'ñeme c'ua libre, o perdonao texe c'o mi tunpü. ");
INSERT INTO mazNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nuc'ua 'ma o mbedye c'e mbëpji, cjanu o chjëvi c'ua c'ü 'naja nu mimbëpjivi c'ü mi tunpü angueze como yetjo ciento mbëxo. Jo ni pënch'i c'ua go nde'chp'e o̱ dyizi, o xipji: “Tsjõtcü c'o i̱ṉ tuncü”, embe c'ü nu mimbëpjivi. ");
INSERT INTO mazNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nuc'ua c'ü nu mimbëpjivi jo ni ndüñijõmü a jmi, o xipji: “Mbãxtjo nin chjũ, xe rí chepque; jo rá 'ñe cjõ'tc'ü texe c'o rí tun'c'ü.” ");
INSERT INTO mazNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero c'e mbëpji, dya go ne go nde'be c'ü nu mimbëpjivi. Go zidyi c'ua ro ma ngot'üji a pjörü hasta 'ma cja ro ngõ't'ü texe c'o mi tunpü. Cja rrũ 'ñemeji c'ua libre c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nuc'ua 'ma o unü ngüenda c'o nu mimbëpjiji c'ü vi ngot'üji a pjörü c'e mbëpji, me co nguijñiji c'ua; go möji go ma ngösp'üji c'ua c'ü nu lamuji. ");
INSERT INTO mazNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nuc'ua c'e lamu o zojnü c'ua c'ü o̱ mbëpji c'ü vi tsjapü na s'o c'ü nu mimbëpjivi, o xipji: “Nu'tsc'e ín mbëpjits'ügö, me na s'otsc'e. Nu'tsc'e me mi tuncügö na puncjü; pero ró perdonaots'ü texe c'o, na ngueje me vi dyötcö favor. ");
INSERT INTO mazNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na c'ü nin mimbëpjiguevi, ¿cjo dya xo mi jyodü rvi juentsque c'ü, nzi rvá juen'tsc'egö?”, embe. ");
INSERT INTO mazNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nuc'ua me co üdü c'e lamu. Cjanu o nzhö c'ua c'ü o̱ mbëpji nu ja me ro tsjapüji me ro sufre c'ü, hasta 'ma cja ro ngõ't'ü texe c'o mi tunpü. Cja rrũ 'ñemeji 'ma libre c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Je xo rga cjatsc'eji nu; 'ma pje ra tsja'c'eji 'naja yo nin cjuarmaji, nu 'ma dya rí perdonaoji co texe in mü'büji, dya xo ra perdonaots'üji in nzhubüji c'ü mi Tatagö c'ü bübü a jens'e, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nuc'ua 'ma ya vi nguarü e Jesús vi xipji c'o jña c'o o̱ discípulo, cjanu o mbedye c'ua a Galilea; o ma cja 'na xoñijõmü c'ü je tsja a Judea, c'ü je bübü a 'nanguarü cja c'e ndare a Jordán. ");
INSERT INTO mazNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mi pöji na puncjü nte e Jesús. C'o mi sö'dyë, mi jocü e Jesús nu cja c'e xoñijõmü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","O säjä c'ua ja nzi c'o fariseo a jmi e Jesús. Chaque o tsjapüji t'önü e Jesús, mi cjijñiji 'na xo ro jyopü c'ü ro mama. O dyönüji: ―¿Ja ga mama cja o̱ ley Mizhocjimi? ¿Cjo na jo 'na bëzo ra mbëzi nu su 'ma dya cjacjuana, 'ma pje c'o cja'a? ");
INSERT INTO mazNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","O ndünrü c'ua e Jesús o xipjiji: ―¿Cjo dya i̱ xörügueji ja va tsja Mizhocjimi? Ndeze 'ma ot'ü o 'ñeme e bëzo 'ñe e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nguec'ua yo bëzo ra zogü nu tata 'ñe nu nana, ra min'hui c'ü nu su. Ya ri 'natjo o̱ ts'inguevi c'ua nza yejui. Je ga cjanu ga mama Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nguec'ua dya cja ri yeje, ya ri 'natjo o̱ ts'inguevi c'ua. Mizhocjimi ya 'ñe'chp'e e bëzo e ndixũ, ngue c'ua dya ra xõcü e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nuc'ua c'o fariseo o xipjiji: ―Maco o manda e Moisés e bëzo ro unü xiscõmü c'ü rví mbëzi nu su. ");
INSERT INTO mazNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji, na me in mü'bügueji, dya i̱ṉ ne rí s'iyagueji c'o nin suji. Nguec'ua va dya'c'eji sjëtsi e Moisés rí pëziji c'o. Pero 'ma o mbürü o ngãrã yo nte, dya ma cjanu ma tsja c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dyäräji c'ü rá xi'tsc'öji. Dya ra jogü ra tsja 'na bëzo ra mbëzi nu su, 'ma dya 'ñeje nan'ño bëzo c'e ndixũ c'ü. Na ngueje 'ma ra mbëzi ga cjanu c'ü nu su'u cja rrũ chjüntüvi c'ü xe 'na ndixũ, tsãjã ndixũ 'ma c'e bëzo c'ü. Xo 'ñe 'na bëzo, 'ma ra mbãrã c'ü vi bëzi c'e ndixũ c'ü, y ra chjüntui, xo ra mbë's'i nu s'ocü 'ma c'e bëzo c'ü, chjëntjui c'ü xo ri tsãjã ndixũ c'ü, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","O mama c'ua c'o discípulo: ―I̱ṉ mangue c'ü dya sö 'na bëzo ra mbëzi o̱ su, zö dya gusta o̱ jmandago c'ü cja. Nguec'ua xenda na jo, dya ra chjüntüji. ");
INSERT INTO mazNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","O ndünrü c'ua e Jesús o xipjiji: ―Dya texeji sö ra tsjaji c'ua ja vi mangueji c'ü dya ra chjüntüji. Nguextjo c'o ya unü Mizhocjimi a cjanu c'o dya ra chjüntü. ");
INSERT INTO mazNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bübü c'o dya chjüntü na ngueje ya c'i'p'iji. Bübü c'o dya chjüntü na ngue ndeze 'ma mü o mus'ü nu nana ixca cjatjonu c'o, dya chjüntü. Bübü c'o dya chjüntü na ngueje ne ra mbëpiji Mizhocjimi c'ü manda a jens'e. Nu c'o unü ngüenda c'ü vi ch'unü dya ra chjüntü, dya ra chjüntü c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nuc'ua c'o nte o siji ja nzi o ts'it'i, o sinpiji e Jesús ngue c'ua ro 'ñe's'e o̱ dyë cja c'o ts'it'i, ro dyötpü Mizhocjimi c'o. Nuc'ua c'o o̱ discípulo o huënch'i c'o nte c'o vi siji c'o ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nuc'ua e Jesús o xipji c'o o̱ discípulo: ―Jyëziji yo ts'it'i ra ẽji cja ín jmigö; dya rí ts'a's'üji yo. Na ngue nu c'o ra ẽjẽ co nuzgö nza cja yo ts'it'i, ngueje c'o cjapü Mizhocjimi o̱ nte c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nuc'ua 'ma o nguarü e Jesús o 'ñe's'e o̱ dyë cja c'o ts'it'i, o mbedye c'ua nu. ");
INSERT INTO mazNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","O ẽjẽ c'ua 'naja bëzo o 'ñe xipji e Jesús: ―Na jots'ügue, xöpüte. ¿Pje ni mbë c'ü na jo rá cjagö, ngue c'ua rá bübütjo? ");
INSERT INTO mazNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","O ndünrü c'ua e Jesús o xipji: ―¿Jenga i̱ṉ xitsi na jozü? Dya cjó bübü c'ü na jo'o; nguextjo Mizhocjimi. Pero rá xi'tsc'ö c'ü i̱ dyönngü. Nu 'ma i̱ṉ ne rí bübütjo, rí tsja c'o mandazüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","O ndünrü c'ua c'e bëzo o mama: ―¿Pje ma mandamiento c'o ni jyodü rá ätcö? O ndünrü c'ua e Jesús o xipji: ―Nujyo nguejyo rí tsjague. Dya rí pö't'ünte. Dya rí tsãjã o ndixũ. Dya pje rí põnü. Dya rí xos'ü o bëchjine. ");
INSERT INTO mazNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Respetao nin tata 'ñe nin nana. S'iya yo nin minteji c'ua ja nzi gui s'iyatsjëgue. ");
INSERT INTO mazNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","O mama c'ua c'e bëzo: ―Texe yo, ya nde ró cjagö yo ndeze cja mi ts'iquëgö. ¿Pje xe bëtsi dya 'ma? ");
INSERT INTO mazNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","O mama c'ua e Jesús o xipji: ―Nu 'ma i̱ṉ ne rí bübütjo, ma'a ma pö'ö texe c'o i̱ṉ pë's'i, cja rrĩ unü c'o merio c'o dya pje pë's'i. Dya ra me'ts'e c'ua ixtí chennguegö rá më. 'Ma rí tsjague a cjanu, rí pë's'igue 'ma a jens'e c'o me ni muvi. ");
INSERT INTO mazNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nuc'ua 'ma mü o dyärä c'e bëzo c'o vi mama e Jesús, me co ndumü va ma'a, na ngueje mi pë's'i na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nuc'ua e Jesús o xipji c'o o̱ discípulo: ―Na cjuana rí xi'tsc'öji, nu c'o pë's'i na puncjü, na s'ëzhi para ra unü o̱ mü'büji Mizhocjimi ra tsjapüji o̱ Jmuji. ");
INSERT INTO mazNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","'Naja camello, dya sö ra cjogü cja c'ü o̱ xãgö 'naja dyepjadü. Je xo ga cjatjonu 'na nte c'ü pë's'i na puncjü, dya sö ra unü o̱ mü'bü Mizhocjimi ra tsjapü o̱ nte. ");
INSERT INTO mazNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","'Ma mü o dyärä c'o discípulo c'o vi mama e Jesús, me co pizhi na puncjü c'o, o mamaji: ―¿Ja rgá sö cjó ra jogü o̱ mü'bü c'ü ra salva 'ma?, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nuc'ua e Jesús cjanu o jñandbaji a jmi c'o o̱ discípulo, o xipjiji: ―Dya cjó sö yo nte ra jocütsjë o̱ mü'bü c'o na s'o, pero Mizhocjimi nde sö ra tsja texe. ");
INSERT INTO mazNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","O ndünrü c'ua e Pedro o xipji: ―Nutscöjme ró sogüjme texe c'o mi pë's'ijme, ró tennc'ejme co nu'tsc'e. Nazgöjme, ¿pje xo ra ch'acöjme? ");
INSERT INTO mazNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","O ndünrü c'ua e Jesús o xipjiji: ―'Ma ya ndo ri nuevo ne xoñijõmü 'ñe a jens'e, nutscö rvá ẽgö cja Mizhocjimi rá mimigö nu ja rá mandagö. Xo 'ñetsc'eji i̱ chennguegöji, na cjuana c'ü rí xi'tsc'öji, xo rí mimigueji nu ja rá mandagö. Nguec'ua rí jñünpüji ngüenda c'o o̱ mboxbëche c'o doce o̱ t'i e Israel. ");
INSERT INTO mazNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Cãrã c'o ejmezügö. Nguec'ua ra zogü nu ngumüji, o nu cjuarmaji, o nu cjũji, o nu tataji, o nu nanaji, o nu suji, o nu t'iji, o o̱ juajmaji. Pero rí xi'tsc'öji c'o ra tsja a cjanu, ra ch'unüji c'ü rrã puncjü que na ngueje 'naja ciento c'ü ra yepe c'ü mi pë's'iji ot'ü. Xo ra ch'unüji c'ü rguí bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","C'o cjapü vi tsjaji c'o me ni muvi, dya rguí muvi a jmi Mizhocjimi c'o. C'o unü ngüenda c'ü dya ni muvi c'ü cjaji, rguí muvi na puncjü a jmi Mizhocjimi c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’C'ü manda a jens'e chjënjui nza cja 'naja bëzo c'ü tjë'ë o̱ juajma. Xõrtjo o mbedye, o ma jyodü mbëpji c'o ro mbëpi c'ü o̱ juajma. ");
INSERT INTO mazNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nuc'ua c'e bëzo o ñaji c'o ro pëpji, o xipjiji c'ü ro ngõ't'üji 'naja merio denario nu pa nzi 'najaji. Cjanu o xipjiji c'ua ro möji cja c'ü o̱ juajma ro ma pëpjiji. ");
INSERT INTO mazNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","O mbedyetjo c'ua na yeje c'e lamu 'ma ya mi ngue ro zünü nueve c'ü xõrü, o jñanda c'o 'ñaja bëzo c'o ma cã cja chõjmü c'o dya mi pë's'i bëpji. ");
INSERT INTO mazNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Cjanu o xipji c'ua c'o: “Nu'tsc'eji xo rí möcjeji cja c'ín juancjö, rá cjõ'tc'üji na jo.” Anguezeji go möji c'ua cja c'e bëpji. ");
INSERT INTO mazNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nuc'ua c'e lamu o matjo c'ua na jñi 'ma ya mi ngue ro zünü jñisiarü, o ma jyodü c'o 'ñaja mbëpji. Ndo nzhogü o mbedyetjo c'ua 'ma ya mi ngue ro zünü jñi c'ü nzhä, c'ü xe ro ma jyontjo o mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Xo mbedye 'ma ya mi ngue ro zünü tsi'ch'a c'ü nzhä, o jñanda c'o 'ñaja c'o dya xo mi pë's'i o bëpji, o xipjiji: “¿Jenga i̱ṉ cãrãtjoji va texe ne pa dya? Maco dya i̱ṉ pëjcjeji.” ");
INSERT INTO mazNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","O ndünrü c'ua anguezeji o mamaji: “Dya rí pëpcjöjme dya, na ngueje dya cjó xitscöjme o bëpji.” O ndünrü c'ua c'e bëzo o xipjiji: “Nu'tsc'eji xo rí möcjeji rí ma pëpcjeji cja c'ín juancjö, rá cjõ'tc'üji na jo.” ");
INSERT INTO mazNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nuc'ua c'ü nzhä'ä c'e pa c'ü, o ma c'e lamu c'ü mi ngue o̱ cjaja c'e juajma, o ma xipji c'ü o̱ mbëpji c'ü mi manda c'o mbëpji: “Ma't'ü c'o mbëpji rí tsjõ't'üji. Ot'ü rí tsjõ't'ü c'o cja ró ma jodü, cja rguí nguarü c'o ts'i vi pëpji.” ");
INSERT INTO mazNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","O ẽjẽ c'ua c'o cja vi nguich'i c'e bëpji 'ma mü o zünü tsi'ch'a c'e nzhä, o ts'õ't'üji 'naja denario nzi 'najaji. ");
INSERT INTO mazNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nuc'ua c'o ot'ü o pëpji, mi pëzhiji xe ro jñus'ü c'ü ro ts'õ't'ü anguezeji, pero xo ts'õ'xtjoji 'na denario nzi 'naja anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nuc'ua 'ma ya vi jñüji c'ü vi ts'õ't'üji, o mbürü o reclamaoji, o zopjüji c'e lamu. ");
INSERT INTO mazNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","O xipjiji: “Nujyo bëpja, cja pëpjiji 'natjo hora, pero nde 'na vi tsjõtcütjojme. Maco nuzgöjme 'napa rvá pëpjijme; ró sufregöjme jyarü.” ");
INSERT INTO mazNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","O ndünrü c'ua c'e lamu o xipji 'naja c'o mbëpji c'o mi reclamao: “Nu'tsc'e bëzo, dya pje rí jün'c'üts'ügö, maco i̱ xitscö na jo ro cjõ'tc'ü 'naja denario. ");
INSERT INTO mazNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nguec'ua rí mague, jñünü c'ü in rayague. Ró ne ró cjõ't'ügö yo cja bëpja ró ma siji, c'ua ja xo nzi rgá cjõ'tc'ügö. ");
INSERT INTO mazNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na, ¿cjo dya sö rá cjapcö c'ü rí negö ín meriogö? ¿Cjo i̱ṉ nepque c'ü ró cjõ't'ügö yo 'ñaja mbëpji na ngueje na jontezügö?”, embe. ");
INSERT INTO mazNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nguec'ua rí xi'tsc'öji, c'o cjapü vi tsjaji c'o me ni muvi, dya rguí muvi a jmi Mizhocjimi c'o. C'o unü ngüenda c'ü dya ni muvi c'ü cjaji, rguí muvi na puncjü a jmi Mizhocjimi c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","O ẽ 'na nu pa, ya mi nguins'i e Jesús ga ma a Jerusalén. O xõcü c'ua c'o doce o̱ discípulo cja 'ñiji, o ñatsjëji o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Dyäräji na jo c'ü rá xi'tsc'öji. Ya rrã möjö a ma a Jerusalén nu ja ra nzhögügöji nutscö rvá ẽgö cja Mizhocjimi. Ra nzhögügöji cja o̱ dyë c'o ndamböcjimi 'ñe c'o xöpü o̱ ley Mizhocjimi, ngue c'ua ra jñüncöji ngüenda c'ü rguí mbötcöji. ");
INSERT INTO mazNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ra nzhögügöji c'ua cja o̱ dyë c'o dya menzumü a Israel c'ü me rguí tsjacöji burla, ra mbäräzüji, cja rrũ ndät'äzüji cja ngronsi. Nuc'ua c'ü na jñi nu pa, rá tetcjö. ");
INSERT INTO mazNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nuc'ua o ẽjẽ c'ua c'ü nu su e Zebedeo c'ü ya vi ndũ, ma siji c'o o̱ t'i. O 'ñe ndüñijõmü a jmi e Jesús, o xipji: ―Rvá ẽ rvá 'ñe ö'tc'ü 'na favor. ");
INSERT INTO mazNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","O ndünrü c'ua e Jesús o xipji: ―Dya ndumü, xitsi pje ni 'ñeje. O ndünrü c'ua c'e ndixũ o xipji: ―Mamague yo yeje ín ch'igö ra mimivi co nu'tsc'e nu ja rí mandague; 'naja ra mimi cja in jodyëgue, nu 'naja ra mimi c'ü 'nanguarü. ");
INSERT INTO mazNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","O ndünrü c'ua e Jesús o xipji c'o ye o̱ discípulo c'o mi ngue o̱ t'i c'e ndixũ: ―Dya i̱ṉ unnc'evi na jo ngüenda c'ü na ötcügö nu nin nanavi. ¿Cjo ra sö rí sufreguevi c'o rá sufregö? O ndünrüvi c'ua: ―Jã, ra sözübe, eñevi. ");
INSERT INTO mazNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nuc'ua e Jesús o xijui: ―C'o rá sufregö, jã na cjuana xo rí sufreguevi c'o. Pero dya nguezgö tocazü rá unü cjó ra mimi cja ín jodyë, ne ri ngue c'ü 'nanguarü. Nguextjo c'ü mi Tatagö c'ü ya juajnü cjó ra mimi nu. ");
INSERT INTO mazNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nuc'ua 'ma o dyärä c'o diez discípulo c'ü vi mama c'e ndixũ, go ünbüji c'ua c'o ye discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero e Jesús o xipjiji ro chëzhiji cja o̱ jmi, cjanu o xipjiji c'ua: ―I̱ṉ pãrãgueji ja ga cja c'o pje nde pjëzhi cja yo nte yo dya pãrã Mizhocjimi, cjapüji yo nte ra tsjaji c'ü mandaji. Y xipjiji ra tsjaji c'o söji na jyü. ");
INSERT INTO mazNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nu'tsc'eji, dya rga cjatsc'eji c'o pje pjëzhi. 'Ma bübütsc'eji 'naja c'ü ne ra mbëzhi na nojo cja Mizhocjimi, ni jyodü ra mböxc'üji 'ma c'ü, dya ra mandatsc'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Y c'o ra ne ra tsja in xo'ñigueji, ni jyodü ra mbë'pc'iji c'o, dya me ra mandatsc'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nutscö c'ü rvá ẽcjö cja Mizhocjimi, dya ngue c'ü ra mböxcö yo nte; ngue c'ü rá pjösc'ö yo. Xo rvá ẽcjö rá tũgö, ngue c'ua rá cjõ'tp'ü o̱ nzhubü na puncjü o nte, eñe e Jesús va xipji c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nuc'ua 'ma ya ma pedyeji a Jericó, mi pöji na puncjü nte e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Cja c'e 'ñiji c'ü mi pöji, ma jũ'ũ yeje c'o mi ndëzhö. Nuc'ua c'o mi ndëzhö 'ma o mbãrãvi ya ma cjogü e Jesús cja c'e 'ñiji, o mapjüvi c'ua na jens'e mi mamavi: ―Nu'tsc'e ín Jmuts'ügöbe o̱ mboxbëchets'ü e David, juentsquegöbe. ");
INSERT INTO mazNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nuc'ua c'o nte o huënch'iji c'ua c'o mi ndëzhö, o xipjiji c'ü ro ngo't'ü a nevi. Pero anguezevi, xenda go mapjüvi c'ua na jens'e mi mamavi: ―Nu'tsc'e ín Jmuts'ügöbe o̱ mboxbëchets'ü e David, juentsquegöbe. ");
INSERT INTO mazNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","O böbü c'ua e Jesús o ma't'üvi o xipjivi: ―¿Pje i̱ṉ neguevi c'ü rá pjöxc'üvi? ");
INSERT INTO mazNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","O ndünrüvi c'ua: ―Nu'tsc'e ín Jmutsc'öbe, jocüzügöbe ín chöbe ngue c'ua rá jandgöbe, eñevi. ");
INSERT INTO mazNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","E Jesús o juentsevi o ndötpüvi c'ua a nzhövi. Jo ni jñandavi c'ua, cjaxnu ndeñevi co e Jesús o möji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ya vi zät'äji a Betfagé cja c'e t'eje c'ü ni chjũ Olivos, ya xo mi bëxtjo ro zät'äji a Jerusalén. Nuc'ua e Jesús o ndäjä yeje c'o o̱ discípulo c'o ro ot'ü a xo'ñi. ");
INSERT INTO mazNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","O xipjivi: ―Mëvi cja ne jñiñi nu bübü a xo'ñi. Rí chöt'üvi nu 'na burru c'ü ri 'nünt'ü, c'ü ri siji o̱ t'i. Rí xäpcävi c'e suburru rí dyënquivi ga 'ñecjua nza yejui. ");
INSERT INTO mazNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","'Ma cjó c'o pje ra xi'ts'ivi, rí xipjivi a cjava: “Ngue c'ín Jmugöji ni jyodü yo”, rí 'ñembevi. Nuc'ua ixta jyë'tsc'itjo rí dyëvi, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Mi jinguã vi mama a cjava 'na c'o o̱ profeta Mizhocjimi: Xipjiji c'o menzumü a ma a Sion c'ü ya va ẽjẽ anguezeji nu nu ra tsjapüji o̱ Jmuji. Xipjiji c'ü dya pje cjapü na nojo nu, na ngue va chägätjo 'na burru nu, eñe c'e profeta. Nguec'ua 'ma o tsja e Jesús o xipji c'o ye o̱ discípulo ro ma ë'ëvi c'e burru, o mbürü o zädä c'ua c'e jña c'ü vi mama c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Cjanu o ma c'ua c'o yeje discípulo o tsjavi c'ua ja nzi va xipjivi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","O ë'ëvi c'e burru 'ñe c'ü o̱ t'i. O ngãsp'ãvi c'ua c'o o̱ bituvi c'o mi tëjëvi. Cjanu o chägä c'ua e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma puncjü nte c'o mi pöji. Bübü c'o mi xĩ'mi o̱ bituji cja c'e 'ñiji; 'ñaja c'o mi ocü o̱ dyë c'o za'a mi xĩ'p'ĩji. ");
INSERT INTO mazNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","C'o nte c'o mi ot'ü a xo'ñi, 'ñe c'o ma bëpja, mi mapjüji mi mamaji: ―Me na nojo nu o̱ mboxbëche e David. Me na jo nu o 'ñeme Mizhocjimi ra mandazüji. Xo 'ñeje c'o cãrã a jens'e ra mamaji: “Me na nojo nu”, eñeji va mamaji. ");
INSERT INTO mazNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nuc'ua 'ma mü o zät'ä e Jesús a Jerusalén, dya mi pãrã pje ro nguijñi c'o mi menzumü nu. Mi mamaji: ―¿Cjó ri nguexã nu? ");
INSERT INTO mazNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nuc'ua c'o nte c'o mi pöji e Jesús, mi mama c'o: ―Nujnu ngue e Jesús nu profeta, nu je menzumü a Nazaret c'ü tsjaja a Galilea, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nuc'ua e Jesús o cjogü a mbo c'ü o̱ templo Mizhocjimi, cjanu o pjongü a tji texe c'o nte c'o pje nde ma pö, 'ñe c'o pje nde ma tõmü nu. Xo tunbü c'o o̱ mexa c'o mi pötü o merio, 'ñe c'o o̱ silla c'o mi pö o mbaro. ");
INSERT INTO mazNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Cjanu o xipjiji: ―Je t'opjü a cjava: “Nu ín nzungö rguí xiji ngumü c'ua ja ra dyötüji Mizhocjimi”, eñe o̱ jña Mizhocjimi. Nu'tsc'eji na cjapcütjoji nín nzungö nza cja 'ma ri ngue o̱ ngumü o mbẽ'ẽ c'ua ja tsjõjõji, embeji c'o pje ma pö, 'ñe c'o pje ma tõmü, 'ñe c'o ma pötü o merio. ");
INSERT INTO mazNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","O ẽjẽ c'ua ja nzi c'o mi ndëzhö 'ñe c'o mi me'dye, o chëzhiji a jmi e Jesús a mbo cja c'e templo. E Jesús o jocü c'ua c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","C'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi, o jñandaji c'o o tsja e Jesús o jocü c'o mi sö'dyë. Xo jñandaji c'o t'i'i c'o ma mapjü a mbo cja c'e templo. O dyäräji mi mamaji: “Me na nojo nu o̱ mboxbëche e David”, mi eñe c'o t'i. Me co üdü c'ua c'o ndamböcjimi, 'ñe c'o mi xöpü o̱ ley Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nguec'ua va mamaji o xipjiji e Jesús: ―¿Cjo i̱ṉ ärägue nu na s'o nu mama yo t'i? O ndünrü c'ua e Jesús o xipjiji: ―Jã, rí ärägö yo. ¿Cjo dya i̱ xörügueji c'ü mama a cjava: Ngue yo ts'it'i 'ñe yo sibatjo yo i̱ xõcü ra tõjõji c'o me na zö o alabanza rgá ma'tc'üji, eñe o̱ jña Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nuc'ua e Jesús o zogü c'o nte cja c'e templo, cjanu o mbedye c'ua nu a Jerusalén, o ma a ma a Betania o ma oxtjo nu. ");
INSERT INTO mazNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nuc'ua c'ü xõrü, xõrütjo o mbedye nu, o nzhogütjo ga 'ñe a Jerusalén. O zant'a c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O jñanda c'ua 'naja za'a c'ü mi ngue higo, c'ü bëxtjo mi 'netjo cja c'e 'ñiji. O ma nu'u, pero ojtjo dya pje chöt'ü c'ü ri quis'i. Mi nguextjo o̱ xi c'o mi cans'a. O mama c'ua e Jesús o xipji c'e higo: ―Dya cja xe ra nguis'its'ü, embe. 'Nangua dyoxtjo c'ua c'e za'a. ");
INSERT INTO mazNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nuc'ua 'ma o jñanda c'o discípulo c'ü vi dyot'ü c'e za'a, me co nguijñiji c'ua, mi mamaji: ―¿Jenga ixco dyot'ü dya ne higo? ");
INSERT INTO mazNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","O ndünrü c'ua e Jesús o xipjiji: ―Na cjuana rí xi'tsc'öji, 'ma rí jñunt'ü in mün'c'eji c'ü ra dyä'tc'eji Mizhocjimi 'ma rí dyötqueji, y 'ma dya rí yembeñeji, dya nguextjo nu ró cjapü ne higo nu ra sö rí tsjagueji. Xo ra sö rí xipjigueji ne t'eje nu bübü nu: “C'ueñe c'ua, ma so'o cja ne ndeje”, rí 'ñembeji. Ra ma c'ua, ra ma zo'o nu. ");
INSERT INTO mazNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Texe c'o pje nde rí dyötüji Mizhocjimi, 'ma rí jñunt'ü in mün'c'eji c'ü ra dyä'tc'eji c'ü, nde ra ch'a'c'eji c'ua ja nzi gui dyötüji, embeji c'o discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nuc'ua e Jesús o cjogü a mbo nu cja c'e templo, o mbürü o xöpü c'o nte. Nuc'ua 'ma ya ma xöpü e Jesús, cjanu o säjä c'ua c'o ndamböcjimi, 'ñe c'o tita c'o pje nde mi pjëzhi cja c'o nte, o 'ñe dyönüji e Jesús, o xipjiji: ―¿Pje pjë'tsc'e c'ü i̱ṉ cjague yo? ¿Cjó ngue c'ü o 'ñempc'e rí tsjague yo? ");
INSERT INTO mazNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","O ndünrü c'ua e Jesús o xipjiji: ―Xo rá önnc'ügöji 'naja t'önü. 'Ma xo rí xitscöji c'e t'önü c'ü rá önnc'üji, xo rá xi'tsc'öji 'ma c'ü pje pjëtscö nguec'ua rí cjagö yo. ");
INSERT INTO mazNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Cjó 'ñeme e Juan c'ü mi jichi yo nte co ndeje? ¿Cjo ngueje Mizhocjimi c'ü o 'ñeme, o ngueje yo nte?, embeji. Anguezeji me mi pötma ñatsjëji c'ua, mi mamaji: ―'Ma rá xipjiji ngueje Mizhocjimi c'ü o 'ñeme, ra xitscöji 'ma: “¿Jenga dya i̱ 'ñejmegueji 'ma c'ü mi xi'ts'iji e Juan?”, ra 'ñenzgöji nu. ");
INSERT INTO mazNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dya xo ra sö rá xipjiji ngueje yo nte yo o 'ñeme, na ngue rí sũgöji yo nte 'na pje c'o ra tsjacöji. Na ngue yo nte mamaji c'ü mi profeta e Juan, mi pätpä Mizhocjimi ma zopjüji, eñeji ma mantsjëji. ");
INSERT INTO mazNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","O ndünrü c'ua anguezeji o xipjiji e Jesús: ―Dya rí pãrägöjme cjó 'ñeme e Juan, eñeji. Xo va ndünrütjo c'ua e Jesús o xipjiji: ―Dya xo rá xi'tsc'öji pje pjëtscö nguec'ua rí cjagö yo. ");
INSERT INTO mazNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","O sido o ña e Jesús o xipjiji: ―Tsjijñiji c'e jña c'ü rá xi'tsc'öji dya. Mi bübü 'naja bëzo c'ü mi 'ñeje yeje o̱ t'i. 'Na nu pa o ma c'ua c'e bëzo, o ma xipji c'ü 'naja o̱ t'i: “Nu'tsc'e ín ch'itsc'ö, mague ma pëpji nu pa dya, cja ín juancjö.” ");
INSERT INTO mazNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","O ndünrü c'ua c'e t'i o xipji: “Iyö. Dya rá magö”, eñe. Nuc'ua o nzhogü o̱ mü'bü, o ma c'ua a bëpji. ");
INSERT INTO mazNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Xo ma c'e bëzo cja c'ü 'naja o̱ t'i, o xitjo c'ua ja nzi va xipji c'ü 'naja o̱ t'i. O ndünrü c'ua c'e t'i o mama: “Jã papá, jo rá magö”, eñe. Pero dya go ma. ");
INSERT INTO mazNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Pje i̱ṉ mangueji c'o yeje t'i? ¿Ja ngue c'ü o tsja c'ü mi ne'e c'ü nu tatavi? O mama c'ua anguezeji: ―Nu c'ü ot'ü o xipji, eñeji. Nuc'ua e Jesús o xipjiji: ―Je xo ga cjatjonu yo publicano, 'ñe c'o ndixũ c'o tsãjã o bëzo, nzhogü o̱ mü'büji cja Mizhocjimi 'ma rí zopcjöji. Nguec'ua rí xi'tsc'öji c'ü na cjuana, yo publicano 'ñe c'o ndixũ c'o tsãjã o bëzo, sö Mizhocjimi a jens'e ra tsjapüji o̱ nte ra mandaji anguezeji. Pero nu'tsc'eji, dya sö. ");
INSERT INTO mazNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","O ẽtsc'eji e Juan, o 'ñe xi'ts'iji ja rvi mimiji na jo. Pero dya i̱ 'ñejmegueji c'ü o xi'tsc'eji c'ü. Yo publicano 'ñe c'o ndixũ c'o tsãjã o bëzo o 'ñejmeji c'ü. Nu'tsc'eji zö xo i̱ jñandgueji ja ma creo c'o, pero nu'tsc'eji dya go nzhogü in mü'bügueji c'ü rvi creoji c'ü mi xi'tsc'eji e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Dyäräji nu xe 'naja jña nu rá xi'tsc'öji. Mi bübü 'na bëzo c'ü mi tjë o̱ juajma. Nuc'ü, o ngant'a o uva cja c'ü o̱ juajma, cjanu o ngot'ü o za'a a squina c'e juajma. Cjanu o dyö'büji nu ja ro jyät'äji o uva cja rrũ yödüji, ngue c'ua ro mbedye o̱ ndeje o uva. Cjanu ndä's'ä c'ua 'naja ts'ingumü nu ja ro mimi c'ü ro mbörü cja c'e juajma. ’Cjanu o unü c'ua media c'o ro mbëpi c'o uva. Cjanu o ma c'ua na jẽ. ");
INSERT INTO mazNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nuc'ua 'ma ya mi ngue ro jogü c'o uva, c'e lamu o ndäjä c'o o̱ mbëpji ro möji ja c'o mi pëpiji c'o uva, ngue c'ua ro unüji c'o uva c'o mi toca c'ü nu lamuji. ");
INSERT INTO mazNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nuc'ua c'o mi pëpi c'o uva, o zürüji c'ua c'o mbëpji c'o vi ndäjä c'e lamu. 'Naja c'ü o s'odüji, 'naja c'ü o mbö't'üji, 'naja c'ü o pjat'üji o ndojo. ");
INSERT INTO mazNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nuc'ua c'e lamu o yepe o ndäjä c'o 'ñaja o̱ mbëpji c'o xe ma puncjü. Nuc'ua c'o mi pëpi c'o uva, o yepe o tsjapütjoji c'o mbëpji c'ua ja nzi va tsjapüji c'o ot'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Nuc'ua c'ü na jñi, o ndäjätsjë c'ua c'ü o̱ t'i, o mama: “Nu nín ch'igö xenda ra dyätäji nu”, eñe c'e lamu. ");
INSERT INTO mazNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nuc'ua c'o mi pëpi c'o uva, 'ma mü o jñandaji ma ẽjẽ c'ü o̱ t'i c'e lamu, me co pötcua mamaji: “Nujnu nguejnu ra zopcüji texe yo pë's'i c'ü nu tata nu. Mö rá pö't'üji ngue c'ua rá cjapcöji ín tsjaji yo ra zopcüji nu.” ");
INSERT INTO mazNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nuc'ua 'ma o säjä c'ü o̱ t'i c'e lamu, jo ni zürüji c'ua c'ü, go pjongüji cja c'e juajma, o mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Xe sido o ña e Jesús o dyönüji: ―'Ma ra ẽjẽ c'e lamu c'ü ngue o̱ cjaja c'e juajma, ¿pãrã ja gui tsjijñiji? ¿Pje me ra tsjapüji c'o pëpi c'o uva? ");
INSERT INTO mazNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","O ndünrü c'ua c'o ndamböcjimi 'ñe c'o tita, o xiji e Jesús: ―Nu c'e lamu, dya ra juentse c'o ya tsja na s'o, ra mbö't'üji c'o. Ra unü c'ua media c'o 'ñaja nte c'o ra unü c'ü ra toca angueze 'ma ra jogü c'o uva, eñe c'o ndamböcjimi 'ñe c'o tita. ");
INSERT INTO mazNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","O ndünrü c'ua e Jesús o xipjiji va jyëtsitsjë 'na ndojo: ―¿Cjo dya i̱ xörügueji c'o ya t'opjü c'ü mama a cjava: Nu c'e ndojo c'ü dya ne c'o mi jäbä o ngumü, ngue c'ü ot'ü ya jñumüji cja squina c'ü. Ngueje Mizhocjimi c'ü o tsja a cjanu. Nguec'ua me rí mäcjöji rgá jandgöji. ¿Cjó ro nguijñi c'ü ro zädä a cjanu?, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nguec'ua rí xi'tsc'öji, ra zädä 'ma dya cja ra tsja'c'üji o̱ ntets'üji ra mandats'üji Mizhocjimi. Ra tsjapü o̱ nte c'o 'ñaja nte c'o ra tsja c'ua ja nzi ga ne angueze. ");
INSERT INTO mazNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","C'o ra pjeñe cja c'e ndojo c'ü rí xi'tsc'öji, ixta 'huagü na jo c'o. Y 'ma ra ẽ zë'bi c'e ndojo cja 'na nte, ixta nzhench'e 'ma c'e nte, embeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nuc'ua 'ma mü o dyärä c'o ndamböcjimi 'ñe c'o fariseo c'o jña c'o mi mama e Jesús, o unüji c'ua ngüenda c'ü mi ngueje anguezeji mi jyëtsiji. ");
INSERT INTO mazNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nguec'ua mi jodü ja rvá zürüji e Jesús. Pero mi sũji c'o nte, na ngueje c'o nte mi junt'ü o̱ mü'büji que mi profeta e Jesús mi pätpä Mizhocjimi ma ña'a. ");
INSERT INTO mazNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nuc'ua e Jesús xe go mama c'ua ja xe nzi ejemplo, o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Nu c'ü manda a jens'e chjënjui nza cja 'na c'ü manda c'ü xiji rey; ro dyät'ä 'na jñõnü 'ma ya ro chjüntü c'ü o̱ t'i. ");
INSERT INTO mazNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","O ndäjä c'o o̱ mbëpji o ma zojnüji c'o ya vi xipji ro ẽjẽ cja c'e chjüntü. Pero dya go ne go ẽji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nuc'ua c'e rey o xipji c'o 'ñaja mbëpji: “Möji cja c'o ya ró xipjigö ra ẽjẽ, ma xipjiji c'ü ya jogü c'o jñõnü, ya mbö't'üji c'o ín ts'inzhünü 'ñe c'o pje nda ma animale c'o ma pi. Xipjiji c'ü ya nde jogü texe cja ne chjüntü, nguec'ua ra ẽji”, eñe c'e rey va xipji c'o o̱ mbëpji. Cjanu o ma c'ua c'o mbëpji o ma xipjiji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero c'o ya vi s'ojnü, dya go tsjapüji ngüenda ro möji. C'ü o tsjaji, 'naja c'ü o ma cja o̱ juajma, 'naja c'ü o ma ma mbö'ö. ");
INSERT INTO mazNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","C'o 'ñaja o zürüji c'o mbëpji c'o vi ndäjä c'e rey, o mbäräji, cjanu o mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","'Ma mü o mbãrã c'e rey c'ü vi tsjapüji c'o o̱ mbëpji, me co üdü c'ua c'ü. O ndäjä c'ua c'o o̱ tropa o ma mbö't'üji c'ua c'o bëzo c'o vi mbö'tp'ü c'o o̱ mbëpji. Cjanu o ndü'tp'üji c'ü o̱ jñiñiji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nuc'ua c'e rey o xipji c'ua c'o 'ñaja o̱ mbëpji: “Yo jñõnü ya jogü yo. Pero c'o ró zojnü, dya go ne go ẽji. Nguec'ua na jo, dya ra ngãrãji dya cja ne chjüntü. ");
INSERT INTO mazNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nguec'ua möji dya ga ma a ñünü, c'ua ja ni mbedye c'o 'ñiji, rí ma xipjiji texe c'o rí chjëji, c'ü ra ẽji cja ne chjüntü”, eñe c'e rey. ");
INSERT INTO mazNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","O mbedye c'ua c'o mbëpji o möji cja 'ñiji, o ma siji texe c'o mi chjëji c'o ma s'o 'ñe c'o ma jo. Nuc'ua me go ndüji cja c'e chjüntü. ");
INSERT INTO mazNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Nuc'ua 'ma o cjogü c'e rey a mbo ngue c'ua ro jñanda c'o vi siji c'o mbëpji, o jñanda c'ua 'na bëzo c'ü dya mi je o̱ bitu c'ua ja nzi ma jyeji 'ma mi cjaji chjüntü. ");
INSERT INTO mazNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","O xipji c'ua: “Nu'tsc'e bëzo, ¿ja vi tsjogue va? Maco dya i̱ṉ jegue c'o bitu c'o jeji 'ma chjüntüji.” C'e bëzo dya go ndünrü. ");
INSERT INTO mazNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nuc'ua c'e rey o xipji c'o mi pjöste cja c'e chjüntü: “Jyü'tp'üji a ngua 'ñe a dyë ne bëzo nu. Ma pant'aji nu ja na bëxõmü nu ja me ra huë, y me ra nguünxt'ü o̱ s'ibi rgá sufre na puncjü”, embeji c'o pjöste. ");
INSERT INTO mazNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nguec'ua rí xi'tsc'öji, na puncjü c'o s'ojnü pero ja nzitjo c'o juajnüji, eñe e Jesús va nguarü va zopjüji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nuc'ua o mbedye c'o fariseo, mi pötma mamaji ja rvá dyönüji e Jesús c'ü rví jyopü angueze, ngue c'ua ro sö ro ngöt'üji cja c'o pje mi pjëzhi. ");
INSERT INTO mazNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nuc'ua c'o fariseo o ndäji c'o o̱ discípulo anguezeji, o möji co c'o nu dyoji e Herodes, o ma xipjiji e Jesús: ―Xöpüte, rí pãrãgöjme c'ü na cjuana c'ü i̱ṉ mangue, 'ñe c'ü i̱ṉ jizhigue c'ü na cjuana ja ga cja o̱ 'ñiji Mizhocjimi. Xo rí pãrãgöjme, dya cjó i̱ṉ sũgue rí zopjü, na ngueje dya i̱ṉ cjapque ngüenda zö pje ri pjëzhi 'na nte. ");
INSERT INTO mazNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nguec'ua rí xitsijme pje xo i̱ṉ cjijñigue, ¿cjo na jo rá cjõt'üji o contribución c'ü örü e César c'ü mero manda, o jiyö?, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero e Jesús ya xmi pãtpã c'ü ma s'o ma mbeñe anguezeji. Nguec'ua ixco xipjiji: ―Nu'tsc'eji i̱ṉ cjapüji na jots'üji, chaque i̱ṉ önngöji. ¿Jenga na sögöji? ");
INSERT INTO mazNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jítscöji c'e merio ja ga cja c'ü örü e César. Anguezeji o ma jünpüji c'ua 'naja merio c'ü mi xiji denario. ");
INSERT INTO mazNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nuc'ua e Jesús o xipjiji: ―¿Cjó o̱ ñi nu cuat'ü ne merio, 'ñe cjó o̱ tjũ nu juns'ü? ");
INSERT INTO mazNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","O ndünrü c'ua anguezeji o xiji: ―Ngue e César. O ndünrü c'ua e Jesús o xipjiji: ―C'ü toca e César, rí unüji e César. C'ü toca Mizhocjimi, rí unüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","'Ma o dyäräji c'o jña c'o, me co nguijñiji c'ua, cjanu o jyanbüji c'ua e Jesús, o möji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","C'o saduceo mamaji c'ü dya ra sö ra te c'o añima. Nuc'ua c'e pa c'ü, o ẽjẽ ja nzi anguezeji cja e Jesús, cjanu o dyönüji o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Nu'tsc'e xöpüte, o mama e Moisés 'ma cjó c'o ra ndũ, 'ma dya be 'ñejui t'i c'ü nu su, nuc'ua c'ü nu su ra chjüntüvi 'ma c'ü 'naja o̱ cjuarma c'e bëzo c'ü ya ndũ. Nuc'ua c'e bëzo c'ü vi ndũ, je ngue o̱ tjũ angueze c'ü ra jñusp'üji c'e t'i c'ü ot'ü ra jmus'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nuzgöjme, mi bübüzgöjme yencho bëzo c'o mi cjuarma. 'Naja anguezeji o chjüntü, pero o ndũ, dya jmusp'ü t'i c'ü. Nuc'ua c'ü na ye nu cjuarma o chjüntüvi c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","C'ua ja nzi va ndũ c'ü ot'ü, je xo va cjatjonu c'ü na yeje, 'ñe c'ü na jñi. Nde va cjatjoji c'ua nza yenchoji, dya jmusp'üji o̱ t'i. ");
INSERT INTO mazNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nuc'ua 'ma ya vi ndũ nza yencho c'o bëzo, xo ndũ c'ua c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nguec'ua rí önnc'üjme, 'ma ra te c'o añima ja c'o nzi gui mangue, ¿cjó ngue c'ü ra tsjapü nu su c'e ndixũ? Na ngueje nza yenchoji nde go tsjapü o̱ suji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","O ndünrü c'ua e Jesús o xipjiji: ―Dya jo c'ua ja gui mbeñegueji. Na ngueje 'ma i̱ṉ xörügueji o̱ jña Mizhocjimi, dya i̱ṉ unnc'eji ngüenda pje ne ra mama yo; dya xo i̱ṉ pãrãgueji ja ga cja c'ü me na zëzhi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yo nte chjüntüji. Xo 'ñe c'o o̱ t'iji, chjüntpüji. Pero 'ma ra te c'o añima, dya cja ra chjüntüji. Na ngue ra chjëntji nza cja c'o o̱ anxe Mizhocjimi c'o dya chjüntü. ");
INSERT INTO mazNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Cjo dya i̱ xörügueji yo o̱ jña Mizhocjimi c'ü mama ra tetjo c'o añima? ");
INSERT INTO mazNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Mama a cjava o̱ jña: “Nguezgö o̱ Mizhocjimizü e Abraham, 'ñe e Isaac, 'ñe e Jacob”, eñe Mizhocjimi. Nguec'ua ixi 'ñetsetjo zö ya ndũ e Abraham 'ñe e Isaac 'ñe e Jacob, pero bübütjoji y ra tetjoji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nuc'ua 'ma mü o dyärä c'o nte c'o jña c'o mi xöpü e Jesús, me mi sũji, dya mi pãrã pje ro nguijñiji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Xo 'ñe c'o saduceo dya cja mi pãrãji pje ro manji. Nuc'ua 'ma mü o mbãrã a cjanu c'o fariseo, cjanu o chëzhiji c'ua a jmi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Naja anguezeji c'ü me mi pãrã o̱ ley Mizhocjimi, chaque o tsjapü t'önü e Jesús ngue c'ua ro zö'ö, o xipji: ");
INSERT INTO mazNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Xöpüte, ¿ja ngue c'ü xenda ni muvi mandamiento cja o̱ ley Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","O ndünrü c'ua e Jesús o xipji: ―C'ü rí tsjaji, rí ñeji Mizhocjimi c'in Jmugueji. Rí ñegueji co texe in mü'büji, 'ñe co texe in aljmaji, 'ñe co texe in pjeñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nujnu nguejnu ot'ü yo o̱ mandamiento Mizhocjimi, ngue nu nda ni muvi. ");
INSERT INTO mazNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bübü c'ü 'naja o̱ mandamiento angueze c'ü xo chjënjui nu cja ró xi'ts'iji c'ü mama a cjava: “Rí s'iyaji yo nin minteji, c'ua ja nzi gui s'iyatsjëgueji”, eñe Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nu 'ma rí tsjague c'ü mama nujyo yeje o̱ mandamiento Mizhocjimi, ya xo i̱ tsjague 'ma c'ü mama texe o̱ jña Mizhocjimi yo xiji ley, 'ñe yo o dyopjü c'o profeta, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nuc'ua 'ma xe ma cãjã c'o fariseo, o ña e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","O xipjiji: ―¿Pje xo i̱ṉ mangueji ja rga cja c'ü ri ngue Cristo? ¿Cjó ri ngue o̱ mboxbëche? O ndünrüji c'ua: ―Ri mboxbëche cja e David. ");
INSERT INTO mazNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","O mama c'ua e Jesús o xipjiji: ―Na jo c'ü. Pero 'ma o mama e David c'ü ja ga cja e Cristo, ¿jenga o mama: “Nuc'ü, ín Jmugö c'ü”, eñe? I̱ṉ pãrãgueji o̱ Espíritu Mizhocjimi o 'ñünbü o̱ mü'bü e David o dyopjü a cjava: Mizhocjimi o zopjü ín Jmugö o xipji: “Mimi cja ín jodyëgö. Rí da'c'ü rí mandague hasta 'ma cja rí chõpü yo nuc'ü na ü”, eñe Mizhocjimi va dyopjü e David. ");
INSERT INTO mazNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","E David o nädä e Cristo o mama: “Ngue ín Jmugö”, eñe. ¿Pje ne ra mama c'ü ri mboxbëche e Cristo cja e David 'ñe c'ü xo ri ngue o̱ Jmu?, eñe e Jesús va tsjapü t'önü c'o fariseo. ");
INSERT INTO mazNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nguec'ua anguezeji dya sö ro ndünrüji. Ndeze c'e pa c'ü, dya cja cjó xe rezga xe ro dyönüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nuc'ua e Jesús o zopjü c'o nte 'ñe c'o o̱ discípulo, o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Nujyo xöpü o̱ ley Mizhocjimi 'ñe yo fariseo, ya ngamaji ra xöpüji yo nte, ra xipjiji ja ga cja c'ü o̱ ley Mizhocjimi c'ü o dyopjü e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nguec'ua texe c'o ra xi'tsc'eji yo, nde rí tsjagueji, dya rí jyëzgueji. Pero dya rí tsjagueji c'ua ja ga tsja anguezeji. Na ngueje mamaji c'ü na jo, pero dya cjaji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Anguezeji xipjiji yo nte c'o ley c'o na s'ëzhi, dya sö ra cumpleji. Nguec'ua chjëntjui c'ü ri ät'äji o trapöjö c'o ri tũtüji, c'o me na jyü rgá nduns'üji. Pero anguezeji dya ne ra mbasp'üji ne rí 'naja o̱ ñidyëji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Texe c'o cja yo fariseo 'ñe yo xöpü o̱ ley Mizhocjimi, cjaji c'ü rguí jñanda yo nte. C'ü cjaji, ät'äji xenda na nojo yo ts'icuëro yo tjün't'üji cja o̱ yüdüji 'ñe a nzhẽ'ẽji, nu ja pät'äji o̱ jña Mizhocjimi. Xo ät'äji xenda na maja yo fleco yo 'nüns'ü a squina o̱ bituji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","'Ma cjaji mbaxua, me juajnüji o lugar c'o xe na jo'o ja ra mimiji ra ziji o xëdyi, ngue c'ua yo nte ra jñandaji anguezeji ra mamaji me na joji. Xo 'ñe 'ma pöji cja nintsjimi, me xo juajnüji o lugar c'o na jo nu ja ra mimiji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Me neji ra tsja yo nte ra mbësp'iji t'ëcjañõmü rgá zenguaji cja chõjmü. Me xo ne o̱ mü'büji ra mama yo nte ra xiji xöpüte. ");
INSERT INTO mazNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero nu'tsc'eji ín discípulotsc'öji, dya rí ñe'eji c'ü cjó ra xi'tsc'eji xöpüte. Na ngueje 'natjo c'ü in xöpütegueji c'ü nguezgö e Cristo o 'ñempque Mizhocjimi, y texetsc'eji i̱ṉ cjuarmaji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dya cjó rí xipjiji tata cja ne xoñijõmü c'ü rí sũji nza cja Mizhocjimi. Na ngueje 'natjo c'ü nin Tatagueji; ngueje c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dya xo rí ñe'eji ra xi'ts'iji jmu, na ngueje 'natjo c'in Jmugueji, c'ü nguezgö e Cristo. ");
INSERT INTO mazNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nu 'ma i̱ṉ negueji ra mbë'tsc'eji na nojo, ni jyodü rí pjöstegueji cja yo in cjuarmaji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na ngueje c'o ra tsjapütsjë rrã nojo, ra tsjapüji dya pje rguí muvi c'o. Y c'o dya ra tsjapü na nojo, ra tsjapüji na nojo c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Nu'tsc'eji i̱ṉ xöpüji o̱ ley Mizhocjimi, 'ñetsc'eji i̱ṉ fariseoji, i̱ṉ cjapqueji na jots'üji pero dya cjuana. Juentsc'eji ra castigaots'üji Mizhocjimi. Na ngueje i̱ṉ c'asp'üji yo nte, ngue c'ua dya unü o̱ mü'büji Mizhocjimi c'ü manda. Nu'tsc'eji dya i̱ṉ jëziji ra mandats'üji c'ü, y c'o ne'e c'ü ra manda Mizhocjimi cja anguezeji, i̱ṉ c'asp'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Nu'tsc'eji i̱ṉ xöpüji o̱ ley Mizhocjimi, 'ñetsc'eji i̱ṉ fariseoji, i̱ṉ cjapqueji na jots'üji, juentsc'eji ra castigaots'üji Mizhocjimi. Na ngueje i̱ṉ jünbügueji c'o pë's'i c'o ndixũ c'o ya ndũ nu xĩra. Y para dya ra mama yo nte na s'otsc'eji, chaque me mezhe gui dyötqueji Mizhocjimi. Nguec'ua rí xi'tsc'öji, 'ma ra jñün'c'üji ngüenda Mizhocjimi, xenda ra jñu's'üts'üji c'ü rgui sufregueji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Nu'tsc'eji i̱ṉ xöpüteji 'ñetsc'eji i̱ṉ fariseoji, i̱ṉ cjapüji c'ü na jots'üji, juentsc'eji ra castigaots'üji Mizhocjimi. Na ngue i̱ṉ pes'eji cja mar i̱ṉ sätc'eji texe cja ne xoñijõmü. I̱ṉ xöpüji yo nte, xa'ma cjó ra 'ñejme c'ua ja nzi gui 'ñejmegueji. Nuc'ua c'o nte c'o ejme c'ua ja gui xiqueji, xenda cja na s'o c'o, que na ngue'tsc'eji. Nguec'ua xenda pë's'i o̱ s'ocüji c'ü rguí möji a ma a linfiernu. ");
INSERT INTO mazNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Nu'tsc'eji i̱ṉ xöpüteji 'ñetsc'eji i̱ṉ fariseoji, i̱ṉ cjapü i̱ṉ jizhigueji nu o̱ 'ñiji Mizhocjimi, pero ya tsot'ü in chögueji i̱ṉ chjëntcjeji nza cja 'na ndëzhö. Juentsc'eji, ra castigaots'üji Mizhocjimi, na ngueje i̱ṉ mamaji: “'Ma cjó c'o ra nädä nzi ga mbãrã ne templo, dya xo rguí muvi 'ma. Nguec'ua dya ni jyodü ra mama c'o na cjuana. Pero 'ma cjó c'o ra nädä c'o traste de oro c'o bübü a mbo cja ne templo, ni muvi 'ma c'ü ra nädä. Nguec'ua ni jyodü ra mama c'o na cjuana”, i̱ṉ eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nu'tsc'eji ya tsot'ü in chöji, dya i̱ṉ pãrãji ja ga cja. Rí xi'tsc'öji c'ü xenda ni muvi ne templo, que na ngueje c'o traste de oro c'o bübü a mbo. C'ü na sjũ c'o traste de oro, je ni 'ñeje cja ne templo. ");
INSERT INTO mazNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Dya xo i̱ṉ cjapüji me ni muvi c'e arta nu ja pö'tp'üji animale Mizhocjimi, cja rrũ ndü'tp'üji nu. Na ngueje i̱ṉ mangueji: “'Ma cjó c'o ra nädä nzi ga mbãrã c'e arta, dya ni muvi 'ma c'ü ra nädä. Pero 'ma cjó c'o ra nädä c'o animale c'o tjü'tp'üji nu, ni muvi 'ma”, i̱ṉ eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nu'tsc'eji ya tsot'ü in chöji, dya i̱ṉ pãrãji ja ga cja. Rí xi'tsc'öji c'ü xenda ni muvi c'e arta, que na ngue c'o animale c'o tjü'tp'üji Mizhocjimi nu. Na ngue c'ü na sjũ c'o animale, je ni 'ñeje cja c'e arta. ");
INSERT INTO mazNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","C'ü ra nädä nzi ga mbãrã c'e arta, nädä 'ma c'e arta 'ñe texe c'o animale c'o tjü'tp'üji Mizhocjimi nu. ");
INSERT INTO mazNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","C'ü ra nädä ne templo, xo nädä 'ma Mizhocjimi c'ü bübü cja ne templo. ");
INSERT INTO mazNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","C'ü ra nädä nzi ga mbãrã a jens'e, nädä 'ma c'ua ja manda Mizhocjimi, xo nädä 'ma Mizhocjimi c'ü manda nu. ");
INSERT INTO mazNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Nu'tsc'eji i̱ṉ xöpüteji 'ñetsc'eji i̱ṉ fariseoji, i̱ṉ cjapüji c'ü na jots'üji, i̱ṉ mbeñeji Mizhocjimi i̱ṉ unüji c'o in xits'ajnaji, 'ñe c'o 'ñaja in pjin'ñoji. Na jo rí tsjaji a cjanu, dya rí jyëzigueji. Pero juentsc'eji, ra castigaots'üji Mizhocjimi, na ngue dya i̱ṉ cö'tp'üji 'ñi c'o jña c'o xenda ni muvi cja o̱ ley Mizhocjimi. Mama c'e ley rá cjaji c'o na jo, 'ñe rá juentseteji, 'ñe rá cumpleji c'ua ja nzi rgá mamaji. Nujyo, nguejyo xenda mi jyodü rvi tsjagueji yo. ");
INSERT INTO mazNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¿Ja rgá sö rí jíchiji yo dya pãrã ngue c'ua ra mbãrãji o̱ 'ñiji Mizhocjimi? Maco ya tsot'ü in chöji, dya xo i̱ṉ pãrãgueji. C'ü ni jyodü rí tsjaji, dya i̱ṉ cjaji. Y c'ü dya nda ni muvi, ngue c'ü i̱ṉ jodü rí tsjaji c'ü. Nguec'ua i̱ṉ chjëntcjeji nza cja 'na bëzo c'ü ro ma cja mëjë ro paxü c'e ndeje ngue c'ua dya ro ts'üt'ü o ts'imörö. Cja rrũ zitjo c'e ndeje, maco ri o'o nu 'na camello. ");
INSERT INTO mazNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Bübü o nte c'o pe'ch'e a xes'e o mojmü 'ñe o xalo, pero dya xibi na jo a mbo. Nguec'ua na s'o a mbo c'o mojmü 'ñe c'o xalo. Je xo ga cjatsc'eji nu, nu'tsc'eji i̱ṉ fariseoji. I̱ṉ xindyëji i̱ṉ tjintsiji c'ü ni xes'ets'üji pero bübü a mbo in mü'büji c'o na s'o; me i̱ṉ jodü ja rgui tsjapü in tsjacjeji c'o pë's'i yo nin minteji. Juentsc'eji ra castigaots'üji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nu'tsc'eji i̱ṉ fariseoji, ya tsot'ü in chögueji, dyäräji c'ü rá xi'tsc'öji. Ot'ü rí jyodüji ja rgá ndin'tsc'i in mü'büji. Nuc'ua, rrã jo c'ü ni xes'ets'üji 'ñe a mbo in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Nu'tsc'eji i̱ṉ xöpüteji 'ñetsc'eji i̱ṉ fariseoji i̱ṉ cjapüji na jots'üji, juentsc'eji ra castigaots'üji Mizhocjimi. Na ngueje i̱ṉ chjëntcjeji nza cja o panteón cja campo santo. Ch'öxcüji a xes'e c'ü ni 'ñetse na zö, pero a jõmü me jä'ä c'o o̱ ndo'dye c'o añima, 'ñe cjo ts'ë me na xĩ'ĩ. ");
INSERT INTO mazNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Je xo ga cjatsc'eji nu, a xes'ets'üji i̱ṉ jizhiji c'ü ni mama yo nte na jotsc'eji. Me i̱ṉ cjapqueji c'ü na jots'üji, pero a mbo in mü'büji me bübü na puncjü c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Nu'tsc'eji i̱ṉ xöpüteji 'ñetsc'eji i̱ṉ fariseoji, juentsc'eji ra castigaots'üji Mizhocjimi. Na ngueje i̱ṉ cjapüji c'ü na jots'üji, pero dya cjuana. I̱ṉ jä'p'äji panteón c'ua ja dyögüji c'o profeta mi jinguã, 'ñe i̱ṉ ä'tp'äji me na zö'ö c'ua ja dyögüji c'o 'ñaja c'o o tsja na jo. ");
INSERT INTO mazNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","I̱ṉ mamaji 'ma ya ri bünc'eji c'o cjë 'ma mi cãrã c'o ín mboxpalegöji, dya rvi pjösp'ügueji 'ma mi pö't'üji c'o profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nguec'ua i̱ṉ mantsjëgueji ngue o̱ mboxbëchets'üji c'o o mbö't'ü c'o profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nguec'ua rí xi'tsc'öji rí cjuatügueji c'o na s'o c'o xe bëzhtjo ro tsja c'o in mboxpaleji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’C'o in mboxpalegueji, ma s'oji nza cja o c'ijmi. Nu'tsc'eji je xo ga cjatsc'eji nu. Nguec'ua, ¿ja rgá sö rí c'ueñeji c'ü dya ra jñün'c'üji ngüenda rgui möji a ma a linfiernu? ");
INSERT INTO mazNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nutscö rá täjä o profeta 'ñe c'o pãrã o̱ 'ñiji Mizhocjimi, 'ñe c'o ra xöpü o̱ jña angueze. Anguezeji, bübü c'o rí chät'äji cja ngronsi rgui pö't'ügueji; 'ñaja c'o rí cha's'üji cja nintsjimi. Y nzi 'na jñiñi rí chäji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Cja ne xoñijõmü ya mbö't'üji na puncjü o nte c'o mi cja na jo. C'ü ot'ü o mbö't'üji mi ngue e Abel c'ü mi cja na jo. C'ü bëpja o mbö't'üji mi ngue e Zacarías c'ü mi mböcjimi c'ü mi ngue o̱ t'i e Berequías. I̱ tsjogüji a nde nu ja na sjũ 'ñe cja c'e arta nu ja tjü'tp'üji animale Mizhocjimi, i̱ pö't'üji e Zacarías. Na ngue c'ü rí tsjapüji ra sufre c'o rá täjä ra ẽ zo'c'üji, ra jñün'c'üji ngüenda Mizhocjimi c'ü nde ngue in s'ocügueji c'ü vi mbö't'üji texe c'o mi cja na jo ndeze e Abel hasta e Zacarías. Nguec'ua me ra tsja'c'üji rí sufreji na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na cjuana rí xi'tsc'öji, nu'tsc'eji i̱ṉ cãrãji yo cjë dya, ngue'tsc'eji rí sufregueji yo. ");
INSERT INTO mazNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Nu'tsc'eji i̱ṉ menzumüji a Jerusalén, i̱ṉ pö't'üji c'o profeta, 'ñe i̱ṉ pjat'üji o ndojo c'o va täjä Mizhocjimi va ẽ zo'c'üji. Na puncjü rvá juen'tsc'öji. Mi negö ro jmu'tc'eji c'ua ja nzi ga tsja 'na ngöñi, juis'i c'o o̱ ts'ingöñi a mbo cja o̱ juaja, pero dya xo i̱ ñe ri chëzhgueji. ");
INSERT INTO mazNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tsjijñiji. Xe järätjo a Jerusalén nu nin ndajñiñigueji, pero ya jyëtsc'iji dya Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rí xi'tsc'öji ndeze ne ndajme dya, dya cja xe rí jñandgöji va hasta 'ma cja rí mamaji: “Me na jo nu va ẽjẽ nu o 'ñeme Mizhocjimi ra manda”, rí 'ñeñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nuc'ua 'ma ma pedye e Jesús cja c'e templo, o ẽjẽ c'ua c'o o̱ discípulo o chëzhiji a jmi, ngue c'ua ro jíchiji e Jesús c'ü me ma zö c'e templo. ");
INSERT INTO mazNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Cjanu o mama c'ua e Jesús o xipjiji: ―Me i̱ṉ jandgueji ne templo. Pero na cjuana rí xi'tsc'öji, ra zädä c'o pa 'ma dya cja ra jyäns'ä yeje ndojo c'o dya ra yät'ä. ");
INSERT INTO mazNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nuc'ua e Jesús o ma cja c'e t'eje c'ü ni chjũ Olivos, o mimi c'ua nu. Nuc'ua c'o o̱ discípulo o ẽji a jmi, o 'ñe xipjiji: ―Xitscöjme jinguã ra yät'ä ne templo. Xo rí xitscöjme pje ma señal c'ü rga pãrgöjme 'ma rí 'ñecje na yeje, y 'ma ra nguins'i ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Cjanu o ndünrü c'ua e Jesús o xipjiji: ―Pjötpüji ngüenda c'ü dya cjó ra dyon'c'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Na ngueje ra ẽjẽ na puncjü c'o ra jñüncügö ín chjũ, ra mamaji ngueje Cristo anguezeji, ngue c'ua ra dyonpüji na puncjü yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Y rí dyäräji ri cjaji o chũ. Xo ra mbezheji ya ri cjaji o chũ. Pjötpüji ngüenda c'ü dya rí sũgueji, na ngueje ni jyodü ra zädä yo. Pero dya be ri sädä 'ma ra nguins'i nu xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yo país ra chũji co yo 'ñaja país. C'o rey ra chũji co c'o 'ñaja rey. Na puncjü c'ua ja ra sufreji o tjimi, 'ñe c'ua ja ra mbi'i na zëzhi ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nujyo, nguejyo rguí mbürü ra sufreji yo. ");
INSERT INTO mazNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Nuc'ua texe cja yo país ra nuc'eji na ü, na ngueje c'ü ni 'ñejmezügöji. Ra nzhöc'ügueji nu ja rí sufreji, y ra mbö'tc'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nuc'ua na puncjü c'o ra xõgü cja Mizhocjimi, y ra pötca nzhötsjëji o̱ dyoji, y ra pötca nuji na ü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na puncjü c'o ra 'ñe tsjapü ri ña o̱ jña Mizhocjimi, ra 'ñe dyonpü na puncjü o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na puncjü c'o dya cja ra s'iya o̱ dyoji, na ngue dya cja ri ätäji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","C'o sido ra 'ñejmezüji, ra ma bübütjoji co Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nuc'ua textjo cja ne xoñijõmü ri cãrã c'o ra zopjü yo nte ra xipjiji ra dyätäji Mizhocjimi na ngue ngueje c'ü manda. Nu'ma, ngue 'ma ya ra nguins'i nu xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","’Mizhocjimi o 'ñünbü o̱ mü'bü c'e profeta Daniel o mama c'ü ra ẽ 'naja nte c'ü me rrã s'o a jmi Mizhocjimi, ra 'ñe chjotü texe, y ra 'ñe mimi c'ua ja me na sjũ. Nu'tsc'eji ri xörüji yo jña yo, rí unüji na jo ngüenda c'ü rgui pãrãji. Nguec'ua 'ma rí jñandaji c'ü ya ri bübü nu c'e nte, rí c'ueñeji rí möji a ma cja t'eje, nu'tsc'eji ri cãrãji a Judea. ");
INSERT INTO mazNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nu'tsc'eji ri tägäji a xes'e cja in nzungueji, ixtí c'ueñeji, dya pje rí chunüji c'o ri pë's'iji a mbo cja in nzungueji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nu'tsc'eji ri bünc'eji cja juajma, dya rí nzhogueji cja in nzungueji c'ü rí 'ñe tsanagueji in bituji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Juejme c'o ri ndunte 'ñe c'o ri jötü o̱ lëlë c'o pa c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dyötüji Mizhocjimi ngue c'ua 'ma rí c'ueñeji, dya ri ngue c'o pa c'o ri järä o së, ni xo ri ngue nu pa c'ü rí söyaji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Na ngueje me ra sufreji na puncjü c'o pa c'o, c'ü nunca go sufreji a cjanu ndeze 'ma o jyans'ü ne xoñijõmü. Y dya cja xe ra sufreji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pero Mizhocjimi ra tsjapü c'ü dya nda ra mezhe c'o pa c'o ra sufreji, ngue c'ua dya ra chjorü texe c'o nte. Ra tsjapü c'ü dya ra mezhe c'o pa c'o, na ngue ri cãrã c'o ya juajnü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Nuc'ua 'ma cjó c'o ra xi'ts'iji: “Je bünc'ua e Cristo” o ra xi'ts'iji: “Je bübü nu e Cristo”, ra 'ñents'eji, dya rí creoji c'o xi'tsc'eji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Na ngueje ra ẽjẽ c'o ra tsjapü ri ngueje e Cristo. Xo ra ẽ c'o ri cjapü profeta ri cjapü ri ñaji o̱ jña Mizhocjimi. Ra tsjaji c'o me na nojo c'o nunca mi janda c'o nte, nguec'ua me ra nguijñiji. C'o ri cjapü a cjanu profeta, ra tsjaji a cjanu, ngue c'ua xa'ma ra sö ra dyonpüji c'o ya juajnü Mizhocjimi ra tsjapü o̱ nte. ");
INSERT INTO mazNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nguec'ua rí xi'ts'iji dya, ante c'ü ra zädä c'o pa c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nguec'ua 'ma ra xi'ts'iji: “Je va bübü e Cristo cja majyadü”, dya rí pedyeji rí ma ñu'uji. O 'ma ra xi'ts'iji: “Je na bübü a mbo cja 'na ngumü c'ü”, dya xo rí creoji c'o xi'ts'iji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","'Ma go juë's'i dyebe nu ja ni mbes'e e jyarü, ixi 'ñetse textjo a lado hasta nu ja ni nguibi e jyarü. Je xo rga cjatjonu 'ma rá ẽcjö na yeje cja Mizhocjimi, ra jñandgöji texe cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dyäräji ne jña nu rá xi'tsc'öji dya: “C'ua ja ri 'mana c'e animale c'ü ya rguí ndũ, je nguejnu ra jmurü c'o ndopare.” ");
INSERT INTO mazNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Nuc'ua 'ma ra nguarü ra sufreji c'o pa c'o, ra bëxõmü e jyarü. Y dya ra 'ñetse e zana. Ra jyäbä yo seje. Y ra 'ñünü nujyo na zëzhi a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nuc'ua ra jñandaji 'na señal a jens'e c'ü rguí mbãrã yo nte c'ü ya rva ẽcjö na yeje cja Mizhocjimi. Y texe c'o ri cãrã cja ne xoñijõmü, me ra nzhumü rgá huëji na ngueje ra jñandgöji rva ẽcjö na yeje cja Mizhocjimi. Ra jñandgöji rva ẽcjö cja ngõmü, ra jñandgöji c'ü me rrã zëtsi 'ñe me rrã zözü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nuc'ua, ra mbë'biji na jens'e 'na corneta, y nutscö rá täjä c'o ín anxe ra 'ñe jmutüji c'o ya ró juajnügö c'o ri cãrã texe cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Nu'tsc'eji rí unüji ngüenda yo za yo xiji higo. 'Ma ya ra dogü, 'ma ya pjürü peje o̱ xi, i̱ṉ pãrãgueji ngue 'ma ya ra paja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Je xo rga cjatjonu, 'ma rí jñandaji ya ra zädä texe yo rí xi'tsc'öji, rí pãrãji 'ma c'ü ya ngue ra nguins'i ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na cjuana rí xi'tsc'öji, c'o ri cãrã c'o pa c'o, dya ra ndũ texe c'o, hasta 'ma cja ra zädä texe yo rí xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ra nguarü e jens'e 'ñe ne xoñijõmü, pero nín jñagö nunca ra nguarü nu. ");
INSERT INTO mazNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Dya cjó pãrã pje ma pa, ni pje ma ndajme 'ma ra zädä c'o, ni xo ri pãrã c'o o̱ anxe Mizhocjimi, ni xo ri pãrãgö nutscö o̱ T'izgö Mizhocjimi. Nguextjo mi Tatagö c'ü pãrã. ");
INSERT INTO mazNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’C'ua ja nzi ma cja c'o cjë 'ma mi bübü e Noé, je xo rga cjatjonu, 'ma rá ẽcjö na yeje cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","C'o cjë 'ma mi bübü e Noé, 'ma dya be mi ẽjẽ c'e tradyebe, mi ñõnüji 'ñe pje nde mi si'iji. Mi chjüntüji, xo mi chjüntpüji o̱ t'iji hasta 'ma cja zädä c'e pa 'ma mü o cjogü e Noé a mbo cja c'e barco. ");
INSERT INTO mazNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dya mbãrãji cjo ro 'ñeje c'e tradyebe hasta 'ma cja 'ñeje, go chjorüji c'ua texeji. Je xo rga cjatjonu, 'ma rá ẽcjö na yeje cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na ngueje ye bëzo c'o rva bübü cja juajma. 'Naja c'ü rá sidyi, 'naja c'ü rá sogü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ye ndixũ c'o 'natjo c'ua rva cüjnü. 'Naja c'ü rá sidyi, 'naja c'ü rá sogü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Nguec'ua rí xi'tsc'öji rí pjötpüji ngüenda, na ngueje dya i̱ṉ pãrãji c'e ndajme 'ma rá ẽcjö nutscö in Jmuzgöji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'Na bëzo c'ü ri xo'tp'üji o̱ ngumü, nu 'ma ro mbãrã pje ma ndajme c'ü xõmü c'ü ro ẽjẽ c'e mbẽ'ẽ, dya ro ĩjĩ; ro nde'betjo, dya ro jyëzi ro xo'tp'ü c'ü nu ngumü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Je xo rga cjatsc'eji nu, rí pjötpüji ngüenda, na ngueje nutscö rá ẽcjö na yeje cja Mizhocjimi c'e ndajme c'ü dya ri tepcöji. ");
INSERT INTO mazNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Nza cja 'na lamu c'ü 'ñeje 'na mbëpji c'ü cjacjuana, 'ñe c'ü pãrã ra pëpji na jo. Ra tsja c'e lamu ra xipji c'e mbëpji c'ü ra 'huinbi c'o ri cãrã cja ngumü, ra unüji o xëdyi 'ma nzi ga zant'aji. Ra ma c'ua c'e lamu. ");
INSERT INTO mazNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nuc'ua, 'ma ra nzhogü c'e lamu, 'ma ra ẽ chöt'ü c'e mbëpji rrã cja'a c'o vi xipji, me ra mäjä 'ma c'e mbëpji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na cjuana rí xi'tsc'öji, c'e lamu ra unü c'e mbëpji c'ü ra mbötpü texe c'o ri pë's'i c'e lamu. ");
INSERT INTO mazNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Pero 'ma ri s'ombëpji c'e mbëpji, 'ñe ra mamatsjë: “C'ín lamugö ra mezhtjo c'ü”, ra 'ñeñe, 'ñe 'ma ra yabü c'o nu mimbëpjiji, 'ñe me ra ziji o xëdyi 'ñe ra tĩji co c'o me tĩ'ĩ, nuc'ua ra ẽjẽ c'ü o̱ lamu nu c'e pa c'ü dya ri te'be, 'ñe c'e ndajme c'ü dya ri pãrã. ");
INSERT INTO mazNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nuc'ua c'e lamu ra manda ra ndas'üji na puncjü co chirrio c'e mbëpji, cja rrũ pant'aji c'ua ja rva cã c'o mi cjapü mi cja na jo. Je ra huë nu c'ü, 'ñe ra nguünxt'ü o̱ s'ibi rgá sufre na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Rá xi'tsc'öji dya 'na ejemplo c'ü ja rgá manda Mizhocjimi c'ü bübü a jens'e. Mi bübü dyëch'a xunt'i c'o mi tunü o̱ sivi. O mbedye o möji, ro ma ndünrüji 'na t'i c'ü ya ro chjüntü. ");
INSERT INTO mazNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tsi'ch'a anguezeji c'o dya mbeñe na jo, pero c'o tsich'a o mbene na jo c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nu c'o dya mi jün o̱ pjeñe, o ndunü o̱ siviji, pero dya xe go ndunüji petroleo c'ü ro xich'iji 'ma ro tjeze c'ü mi tjë. ");
INSERT INTO mazNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nu c'o o mbeñe na jo, o ndunüji petroleo co o̱ botiaji, 'ñe c'o xe mi po'o c'o o̱ siviji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nuc'ua xe mezhtjo ro säjä c'e t'i c'ü ro chjüntü. Nguec'ua c'o xunt'i o ndägäji o t'ĩjĩ, o ĩji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nuc'ua c'ü ndexõmü, o dyäräji 'na jña c'ü mi mapjü mi mama: “Ya va ẽjẽ nu ra chjüntü; pedyeji ma chjünrüji” ");
INSERT INTO mazNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","O böbü c'ua texe c'o xunt'i, cjanu o jocü c'o o̱ siviji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nu c'o dya mi pë's'i o̱ pjeñe, o xipjiji c'o vi mbeñe na jo: “Dyacöjme ts'ë in petroleooji, na ngueje ya ne ra juench'etjo yo ín sivigöjme” ");
INSERT INTO mazNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","O ndünrü c'ua c'o vi mbeñe na jo, o xipjiji: “Iyö, dya ra sö rá da'c'üjme. Na ngueje 'ma rá da'c'üjme, dya ra zögöjme, ni xo ri ngue'tsc'eji. Moji ma chõmüji nu ja pöji”, eñe c'o xunt'i c'o vi mbeñe na jo va xampja. ");
INSERT INTO mazNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nuc'ua 'ma cja vi mötji, o säjä c'ua c'e t'i c'ü ro chjüntü. Nu c'o ya vi xampja na jo, o cjogüji c'ua co angueze cja c'e ngumü nu ja ro tsjaji c'e chjüntü. Jo nu ngot'üji c'ua c'e ngoxtji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Dya mezhe c'ua o säjä c'o xunt'i c'o vi ma ndõmü o petroleo, o mamaji: “Xocüzüjme, nu'tsc'e nin t'ecjañõmü.” ");
INSERT INTO mazNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","O ndünrü c'ua c'e t'i o xipjiji: “Na cjuana rí xi'tsc'öji, dya rí pã'c'öji”, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nguec'ua rí xi'tsc'öji, rí pjötpüji ngüenda, na ngueje dya i̱ṉ pãrãgueji ja ma pa, ni pje ma ndajme 'ma rá ẽcjö na yeje cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Xe rá xi'tsc'öji c'ü 'na ejemplo c'ü ja ga manda c'ü o 'ñeme Mizhocjimi. Mi bübü 'na bëzo c'ü ro ma ne jẽ'ẽ. O ma't'ü c'o o̱ mbëpji, o zopcüji c'o mi pë's'i ngue c'ua ro mbötpüji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’C'ü 'na mbëpji o zopcüji tsi'ch'a ts'icaja o merio; c'ü 'na o zopcüji ye ts'icja; c'ü 'na ozopcüji 'naja ts'icaja. O zopcüji c'ua ja nzi rvá sö ro pëpjiji nzi 'naji. O ma c'ua na jẽ c'e lamu. ");
INSERT INTO mazNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nuc'ua c'ü vi s'opcü tsi'ch'a ts'icja, o ma ndõmü c'o ro mbö'ö c'ü. Y o ndõjõ c'o xe 'na tsi'ch'a ts'icaja o merio. ");
INSERT INTO mazNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Je xo va cjatjonu c'ü vi s'opcü ye ts'icaja, o ndõjõ c'o xe 'na yeje ts'icaja. ");
INSERT INTO mazNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero nu c'ü vi s'opcü 'na ts'icaja, o ma dyö'bü a jõmü, cjanu dyöpcütjo nu c'o o̱ merio c'ü nu lamu. ");
INSERT INTO mazNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’O mezhe c'ua na puncjü pa, cja nzhogü c'ü nu lamu c'o mbëpji, o zojnüji ngue c'ua ro tsjaji ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","O sä c'ua c'ü vi s'opcü tsi'ch'a ts'icaja o merio, xe ndo ma jüntjo c'o xe tsi'ch'a ts'icaja. Cjanu o xipji c'ua c'ü nu lamu: “Nu'tsc'e ín lamuts'ügö, i̱ socüzü tsi'ch'a ts'icaja. Xe va ẽcjuã yo xe 'na tsi'ch'a yo ró tõcjö”, ẽne. ");
INSERT INTO mazNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","O mama c'ua c'e lamu o xipji: “Me na jo ga mbëpjits'ügue. I̱ tsjacjuana i̱ tsjague na jo'o co c'o ts'ëtjo c'o ró socüts'ügö. Nudya rá da'c'ü o bëpji c'o xenda ni muvi. Tsjogü me rá mäjui na ngue i̱ pëpquigö na jo.” ");
INSERT INTO mazNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Xo säjä c'ua c'ü vi s'opcü yeje ts'icaja, o xipji c'ü nu lamu: “Nu'tsc'e ín lamuts'ügö, i̱ socüzügö ye ts'icaja. Nudya bünc'ua yo xe 'na yeje ts'icaja yo ró tõcjö”, eñe c'e mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nuc'ua c'ü nu lamu o xipji angueze: “Me na jo ga mbëpjits'ügue, i̱ tsjacjuanague i̱ tsjague na joco c'o ts'ëtjo c'o ró socüts'ügö. Nudya rá da'cü o bëpji c'o xenda nu muvi. Tsjogü me rá mäjui na ngue i̱ pëpcö na jo”, embe. ");
INSERT INTO mazNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Xo sä c'ua vi s'opcü 'naja ts'icaja, o xipji c'ü nu lamu: “Nu'tsc'e ín lamuts'ügö, rí pã'c'ãgö nu'tsc'e i̱ṉ dacüjme o bëpji c'o na jyü; maco ngue'tsc'e i̱ṉ cjapü in tsjacje yo rí tõgöjme. Zö nguetscöjme rí podüjme c'o in nzhëxügue 'ñe rí cjajme texe, pero ngue in ch'ujmügue nu ja rí ütc'öjme c'o ndëxü. ");
INSERT INTO mazNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nguec'ua ró sũgö, ró ma ö'ts'üts'ü nin ts'icaja nu i̱ socüzügö. Bünc'ua dya nin ts'icajague.” ");
INSERT INTO mazNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","O mama c'ua c'ü nu lamu o xipji: “Na s'o ga mbëpjitsc'e, me na mañats'ü. Nu'tsc'e i̱ṉ pãrãgue rí cjapü ín tsjacjö c'o ndëxü, zö dya rí podügö ni xo rí pitsigö; ngue'tsc'eji i̱ṉ cjaji texe c'e bëpji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nguec'ua ma jo rvi ma socüzü cja banco yo ín meriogö. Nguec'ua 'ma ro ẽcjö, ro dyacöji yo ín tsjacjö, 'ñe c'o ya rví ndõjõ yo”, embe. ");
INSERT INTO mazNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Cjanu o xipji c'ua c'o o̱ mbepji: “Jñünbüji ne ts'icaja nu jün nu, unnüji nujjjnu quiji dyëch'a ts'icaja. ");
INSERT INTO mazNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","C'o ch'unü pje rguí pëpjiji, 'ma ra ndõji, xe ra ch'unü 'ma c'o. Pero 'ma dya ra pëpjiji c'o vi ch'unü ra jñünbüji 'ma c'o vi ch'unüji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Rí pant'aji ne s'ombëpji a ma a linfiernu nu ja na bëxõmü. Nujnu, nguejnu je ra huë nu ne mbëpji, 'ñe me ra nguünxt'ü o̱ s'ibi rgá sufre nu”, eñe c'e lamu va xipji c'o o̱ mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Nu 'ma rá ẽcjö na yeje cja Mizhocjimi, me rrã zëzhizügö. Rá dyocjöjme texe c'o o̱ anxe Mizhocjimi. Nuc'ua rá mimi nu ja me na zö'ö, ngue c'ua rá jünpü ngüenda yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nuc'ua texe yo cãrã cja ne xoñijõmü, ra ngãrãji cja ín jmigö. Nuc'ua rá xõcüji nza cja 'na mbörü xõcü c'o o̱ ndënchjürü cja c'o chiva. ");
INSERT INTO mazNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","C'o rí jyëtscö ndënchjürü rá cama cja ín jodyë c'o, y nu c'o chiva rá cama c'ü 'nanguarü. ");
INSERT INTO mazNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nuc'ua nutscö rí mandagö rá xicö c'o ri cãrã ín jodyë: “Nu'tsc'eji na jots'üji cja jmi Mizhocjimi nu mi Tatagö, chjä'dägueji. Rá da'c'üji dya, c'ü xo rí mandagueji. Ndeze 'ma dya be mi t'ät'ä nu xoñijõmü, o xõcüts'üji a cjanu xo rí mandagueji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Rá ca'c'üji a cjanu, na ngueje 'ma mi santc'ö, nu'tsc'eji mi dacöji c'ü ro sigö. Y 'ma mi tũregö, nu'tsc'eji mi dacöji ndeje. Y 'ma ró sät'ägö cja in jñiñigueji i̱ säcjöji zö dya mi ngue in menzumüzgöji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Y 'ma dya mi cãjãgö pje ro jegö, nu'tsc'eji mi dacöji c'ü ro jegö. Y 'ma mi sö'dyëgö, nu'tsc'eji mi pa cjinngöji. Y 'ma mi cjocö a pjörü, nu'tsc'eji mi pa nugöji nu”, rá embe c'o ri cãrã cja ín jodyë. ");
INSERT INTO mazNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Rá ndünrü c'ua c'o vi tsja na jo, ra xitscöji: “Nu'tsc'e ín Jmuts'ügöjme, ¿jinguã ró jantc'ajme mi santc'e c'ü ró da'cö'jme 'na xëdyi? ¿Jinguã mi turegue c'ü ró da'c'üjme ndeje? ");
INSERT INTO mazNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jinguã i̱ sät'ägue cja ín jñiñigöjme c'ü ró säc'öjme? ¿Jinguã dya mi cãgue bitu c'ü ró da'cüjme c'ü ri jyegue? ");
INSERT INTO mazNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿jinguã ró jantc'ajme mi södyëgue, o c'ü mi cjo'cügue a pjörü c'ü ró ma cjinnc'ijme?”, ra 'ñenzgö c'o vi tsja na jo. ");
INSERT INTO mazNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nutscö rí mandagö rá tjünrü c'ua rá xipjiji: “Nu cjuana rí xi'tsc'öji, c'ü vi pjös'ügueji yo mi ts'icjuarmagö nujyo dya pje mi pjëzhi, xo 'ñetscö xo i̱ pjöxcöji”, rá embe c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Nuc'ua rá xipji c'o ri cãrã ín scerda: “Nu'tsc'eji, me na s'otsc'eji, c'ueñeji cja ín jmigö, möji cja sivi c'ü nunca ra juench'e, c'ü o dyät'ã Mizhocjimi c'ua ja ra sufre c'ü dya jo, 'ñe c'o demonio c'o ngue o̱ dyoji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na ngueje 'ma santc'ö dya i̱ dyacöji c'ü ro si. Y 'ma mi sufregö 'nure, dya i̱ dyacöji ts'ë ndeje. ");
INSERT INTO mazNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Y 'ma ró sät'ägö cja in jñiñgueji, cya i̱ recibidozüji. Y 'ma dya mi cãgö bitu c'ü ro je'e, dya i̱ dyacöji c'ü ro jegö. Y 'ma mi sö'dyëgö 'ñe 'ma mi cjocö a pjörü, dya mi pa cjinnguigöji.” ");
INSERT INTO mazNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nuc'ua anguezeji xo ra ndünrüji ra xitscöji: “Nu'tsc'e ín Jmuts'ügöjme, ¿jinguã ró jantc'ajme mi sant'ague o mi sufregue 'nure, o i̱ sät'ägue cja ín jñiñigöjme c'ü dya ró pjöxc'ume? ¿Jinguã dya mi cãgue bitu c'ü rvi jye, o mi sö'dyegue, o mi cjo'c'e apjörü, c'ü dya ró cö'tc'üjme 'ñi?” ");
INSERT INTO mazNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nuc'ua rá tjünrü rá xicöji: “Na cjuana rí xi'tsc'öji, dya i̱ pjösc'eji a cjanu ne rí 'na yo mi cjuarmagö yo dya pje mi pzëshi. C'ü dya vi pjösc'eji yo, xo ñezgö, dya xo i̱ pjöxcöji”, rá embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nuc'ua rá tägöji ra möji nu ja nunca ra nguarü rgá sufreji. Pero c'o vi tsja na jo, ra möji ra ma ngãrãji a jmi Mizhocjimi para siempre. ");
INSERT INTO mazNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nuc'ua 'ma o nguarü e Jesús o mama c'o jña c'o, xe go xipji c'ua c'o o̱ discípulo: ");
INSERT INTO mazNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―I̱ṉ pãrãji ya bëzhtjo yepa ra zädä c'e mbaxua c'ü ni chjũ Pascua. Nutscö rvá ẽcjö cja Mizhocjimi, ra nzhögügöji ngue c'ua ra ndät'äzüji cja ngronsi, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nuc'ua c'e xõmü c'ü, o ma c'o ndamböcjimi 'ñe c'o tita c'o pje nde mi pjëzhi, o ma jmurüji cja c'e palacio nu ja mi bübü c'ü mi mero ndamböcjimi c'ü mi chjũ Caifás. ");
INSERT INTO mazNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","O ñaji ja rva cja rvá zürüji e Jesús c'ü dya ro mbãrã c'o nte. Ro zürüji ngue c'uã ro mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mi mamaji: ―Dya ra jogü rá sürüji cja ne mbaxua; 'na ra huëñi yo nte ra tsja o̱ dyëji, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","'Na nu pa, mi bübü e Jesús a Betania nu cja nu ngumü e Simón c'ü mi sö 'na ngueme c'ü ni chjũ lepra. ");
INSERT INTO mazNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","O säjä c'ua 'na ndixũ nu ja mi bübü e Jesús, ma tũ 'na botia ndojo c'ü mi po'o c'o me ma jo ma jyärä. Me mi muvi na puncjü o merio c'ü. Cjanu xisp'i o̱ ñi e Jesús 'ma ya ma jũ'ũ cja mexa. ");
INSERT INTO mazNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","C'o o̱ discípulo e Jesús o jñandaji c'ü vi tsja c'e ndixũ. Me co üdüji c'ua go mamaji: ―Chjã, jyäctjo. ¿Jenga ya bëzhi yo me ni muvi? ");
INSERT INTO mazNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mi sö ro bö'ö na mizhi nu, ngue c'ua c'o merio c'o, ro ch'unü yo dya pje pë's'i, eñe c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","O unü ngüenda e Jesús c'o vi mama c'o discípulo, o xipjiji c'ua: ―¿Jenga na molestaoji ne ndixũ? Maco na jo c'ü o tsjacö nu. ");
INSERT INTO mazNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nu'tsc'eji xe rí mintcjeji nujyo dya pje pë's'i, pero nutscö ra zädä 'ma dya cja rá bünc'ö a ndetsc'eji. ");
INSERT INTO mazNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ne ndixũ nu, ya xisquigö ín cuerpo nujyo na jo ga jyärä, ngue c'ua ya na segurao c'ü rgá dyögüzgöji. ");
INSERT INTO mazNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na cjuana rí xi'tsc'öji, texe cja ne xoñijõmü c'ua ja ra zopjüji yo nte ra xipjiji ja ga cjazgö, nde ra nädäji nu o tsja ne ndixũ nu, ngue c'ua ra mbeñeji nu na jo nu o tsjacö, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","C'o doce discípulo, mi bübü 'naja c'ü mi chjũ Judas Iscariote. Nuc'ü, o ma c'ua cja c'o ndamböcjimi, o ma xipjiji: ―¿Ja nzi rí tsjõtcügöji ngue c'ua rá nzhö'c'üji e Jesús? Nuc'ua c'o ndamböcjimi o ngõ't'üji treinta merio o plata e Judas. ");
INSERT INTO mazNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ndeze c'ua, o mbürü e Judas o jyodü c'ü ja rvá tsjapü, ngue c'ua ro nzhö e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ya vi zädä c'e mbaxua c'ü ni chjũ Pascua, 'ma mi siji o tjõmëch'i c'o dya mi bäns'ä. C'ü ot'ü pa c'ü mi pjongüji c'e mbaxua, o ẽjẽ c'ua c'o discípulo cja e Jesús, o xipjiji: ―¿Ja ngue c'ua i̱ṉ ne rá ma ät'äjme o jñõnü c'ü rí sigue rgui sũpque ne mbaxua? ");
INSERT INTO mazNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","O ndünrü c'ua e Jesús o xipji c'ua yeje c'o o̱ discípulo: ―Mëvi a ma a Jerusalén rí ma zopjüvi c'e bëzo c'ü ya i̱ṉ pãrãguevi, rí xipjivi: “Va täcjöbe c'e xöpüte rá xi'ts'ibe c'ü ya va sädä c'ü ra sufre. Nguec'ua c'e mbaxua je ra zũpü cja in nzungue co c'o o̱ discípulo, va 'ñenzgöbe c'e xöpüte.” Je rí xipjivi a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nuc'ua c'o discípulo o mëvi c'ua ja va xipjivi e Jesús, o ma dyät'ävi c'e jñõnü c'ü rví zũpüji c'e mbaxua c'ü ni chjũ Pascua. ");
INSERT INTO mazNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nuc'ua 'ma ya vi nzhä, o mimi c'ua e Jesús cja c'e mexa ro ziji o xëdyi c'o doce o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","'Ma ndänt'ä ma siji o xëdyi, e Jesús o xipjiji: ―Na cjuana rí xi'tsc'öji, bübütsc'eji 'na c'ü ra nzhögügö cja o̱ dyë c'o ra mbötcö, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Anguezeji 'ma o dyäräji a cjanu, me go ndumüji c'ua. O mbürü o mama nzi 'naja anguezeji mi xipjiji e Jesús: ―¿Cjo nguetscö, ín Jmuts'ügö? ");
INSERT INTO mazNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","O ndünrü c'ua e Jesús o mama: ―'Naja c'ü ya ndü'bü o xëdyi co nuzgö cja ne mojmü nu rrã sigöji, ngue c'ü ra nzhögügö c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nutscö rvá ẽcjö cja Mizhocjimi, ra mbötcöji c'ua ja nzi ga t'opjü cja o̱ jña Mizhocjimi. Pero juejme c'e bëzo c'ü ra nzhögügö. Xenda rvá jo c'ü dya ro jmus'ü c'e bëzo c'ü, na ngueje ra ma sufre na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","O ndünrü c'ua e Judas nu c'ü ro nzhö'ö, o mama: ―¿Cjo nguetscö, xöpüte? O ndünrü c'ua e Jesús o xipji: ―Ya i̱ mantsjëgue, ngue'tsc'e. ");
INSERT INTO mazNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","'Ma ndänt'ä ma siji o xëdyi, o jñü c'ua e Jesús 'na tjõmëch'i, o unü 'na pöjö Mizhocjimi. Cjanu o xënmbi c'o o̱ discípulo, o xipjiji: ―Jñüji ne tjõmëch'i nu rrã xëñc'iji, rí siji. Nujnu ngue ín cuerpogö nu. ");
INSERT INTO mazNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Cjanu o ndës'i c'ua c'e vaso. O unü 'na pöjö Mizhocjimi, cjanu unü c'o o̱ discípulo, o xipjiji: ―Sigueji c'ü po'o nu i̱ṉ texeji. ");
INSERT INTO mazNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Na ngueje nujnu, ngue ín tsjigö nu. Na ngue c'ü rga pjödügö ín tsji rá tũgö, Mizhocjimi ra tsja dya c'ua ja nzi va mama; ra perdonao dya o̱ nzhubü na puncjü o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Rí xi'tsc'öji, ndeze dya, dya cja xe rá sigö o̱ ndeje o uva hasta 'ma cja ra zädä c'e pa 'ma 'natjo c'ua rá cãrãji nu ja rá mandagö, c'ua ja nzi va mama Mizhocjimi c'ü mi Tatagö. Cja rá sigöji 'ma c'o cja nuevo c'o me xe rrã jo, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nuc'ua o tõji 'na himno va ma't'üji Mizhocjimi. Cjanu o mbedyeji c'ua a tji, o möji cja c'e t'eje c'ü ni chjũ Olivos. ");
INSERT INTO mazNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nuc'ua e Jesús o xipjiji: ―Texets'ügueji nde rí jyëzguigöji ne xõmü dya, na ngue c'ü ra tsjacügöji. Na ngueje ya t'opjü a cjava: “Rá nzhö'ö c'e mbörü ra mbö't'üji. Nguec'ua c'o o̱ ndënchjürü ra mböt'ü c'o”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero 'ma rá tegö a nde cja c'o añima, ot'ü rá magö a ma a Galilea, ngue c'ua 'ma rí sätc'eji nu, ya rva bünc'ö nu. ");
INSERT INTO mazNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","O ndünrü c'ua e Pedro o xipji: ―Zö texe ra jyëtsc'igueji, pero nuzgö nunca rá jëtsc'igö, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","E Jesús o xipji c'ua: ―Na cjuana rí xi'tsc'ö, dya be ri huë'ë o tare ne xõmü dya, 'ma ya na jñi rgui tsädä c'ü dya i̱ṉ pãcãgö. ");
INSERT INTO mazNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","O mama c'ua e Pedro: ―Zö rá tũgö co nu'tsc'e, pero nunca rá cädägö c'ü rgá pã'c'ãgö, eñe c'ü. Xo nde va mantjo c'ua texe c'o discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nuc'ua o möji nu ja mi chjũ Getsemaní. Nuc'ua e Jesús o xipji c'o o̱ discípulo: ―Mimiji va, ndeze c'ü rá magö a manu, rá ma ötü Mizhocjimi c'ü mi Tatagö, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nuc'ua e Jesús o zidyi e Pedro 'ñe nza yeje c'o o̱ t'i e Zebedeo. O mbürü o ndumü c'ua e Jesús, y me mi cjijñi na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nuc'ua o xipjiji: ―Me rí ndumügö, rí sö ra mbötcügö c'ü rgá sentiogö. Chepquetjoji va, dya rí ĩji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Xe go ma c'ua xe ts'iquë a ma a xo'ñi, o ndüne a jõmü, o dyötü Mizhocjimi o mama: ―Mi Tatats'ügö, 'ma ra sö, rí ts'a's'ü c'ü dya ra zädä c'ü rá sufregö. Pero dya rí tsjague c'ua ja rgá negö, tsjague c'ua ja nzi gui ñegue, eñe e Jesús va dyötü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","O nzhogü c'ua e Jesús nu ja mi cãrã c'o jñi o̱ discípulo, o 'ñe chöt'ü ya nde vi ĩtjo c'o. E Jesús o xipji c'ua e Pedro: ―¿Cjo dya mi sö rvi chepquegöji 'na ts'indajme c'ü dya rvi ĩcjeji? ");
INSERT INTO mazNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Dya rí ĩji. Dyötqueji Mizhocjimi ngue c'ua dya ra ndö'c'eji c'ü dya jo. Jã, a mbo in mün'c'eji i̱ṉ neji c'ü dya rí ĩji ngue c'ua rí dyötqueji Mizhocjimi. Pero yo in cuerpoji, ya mbo o̱ cuë yo, embeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nuc'ua o ma na yeje, o ma dyötü Mizhocjimi o mama: ―Mi Tatats'ügö, 'ma dya sö ra cjogü c'ü rá sufre, rí ne rá sufregö 'ma. Na ngue je rí negö rí tsjacö c'ua ja nzi gui ñegue, eñe e Jesús va dyötü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","O nzhogü c'ua na yeje, o ẽ chöt'ütjo ya ma ĩtjoji na yeje, na ngueje me mi tägäji na puncjü o t'ĩjĩ. ");
INSERT INTO mazNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ndo zogütjoji c'ua, o ma dyötü Mizhocjimi c'ü na jñi, o mantjo c'ua ja nzi va mama 'ma ot'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nuc'ua ndo go nzhogü go ẽtjo c'ua cja c'o o̱ discípulo, o xipjiji: ―¿Cjo xe i̱ṉ ĩcjeji 'ñe i̱ṉ söyaji? Maco ya zädä ne ndajme nu ra nzhögügöji nutscö rvá ẽcjö cja Mizhocjimi. Ra nzhögügöji cja dyë c'o nte c'o me cja na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ya va säjä nu ra nzhögügö. Nguec'ua rí ñangaji; rá chjëji. ");
INSERT INTO mazNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","'Ma ndänt'ä ma ña e Jesús, o säjä e Judas c'ü mi ngue 'naja c'o doce discípulo. Ma dyoji na puncjü nte c'o vi ndäjä c'o ndamböcjimi, 'ñe c'o tita c'o pje nde mi pjëzhi cja c'e jñiñi, ma jünji tratjëdyi 'ñe ngarrote. ");
INSERT INTO mazNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","E Judas c'ü ro nzhö e Jesús, ya vi xipji a cjava c'o nte c'o mi pöji: ―Nu c'ü rá tjünegö, ngue c'ü i̱ṉ jonnc'eji c'ü. Nguec'ua rí pënch'iji c'ü, embeji. Nguec'ua ya mi pãxtjo c'ua c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nuc'ua e Judas ixco sätjo cja e Jesús, o zengua. Jo ni zü'tp'ü c'ua o̱ jmi. ");
INSERT INTO mazNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nuc'ua e Jesús o xipji: ―¿Pje vi 'ñecje, bëzo? Nuc'ua o säjä c'o nte, ixco pënch'iji c'ua e Jesús ngue c'ua ro zidyiji. ");
INSERT INTO mazNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nuc'ua 'naja c'o mi dyoji e Jesús o ngübü c'ü o̱ tratjëdyi, o mbetspi 'naja o̱ ngõ 'naja c'o o̱ mbëpji c'ü mi mero ndamböcjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nuc'ua e Jesús o xipji: ―Tsöt'ü nin chjëdyi c'ua ja mi o'o. Na ngueje texe c'o ra pö't'ünte co tjëdyi, tjëdyi rguí nzhũ c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Pje i̱ṉ mangue? ¿Cjo dya sö rá ötcö c'ü mi Tatagö, angueze ixta ndäjä c'ü ra cjogü doce mil o̱ anxe ra ẽ mböxcüji? Jã, sö. ");
INSERT INTO mazNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero 'ma ra ẽ c'o anxe, ja rgá zädä 'ma yo ya t'opjü yo ni jyodü rá sufregö. ");
INSERT INTO mazNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nuc'ua c'e ndajme c'ü, o mama e Jesús o xipji c'o nte: ―¿Ja cja c'ü i̱ṉ cjagueji? Maco i̱ pedyeji cja c'in jñiñiji va ẽ sücöji nza cja 'ma ri nguezgö 'na mbẽ'ẽ, va jünji in chjëdyiji 'ñe in ngarroteji. Pama mi cãrãgöji cja c'e templo mi jí'tsc'öji, maco dya mi pënzhguigöji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero texe yo, ya va sädä yo, ngue c'ua ra zädä c'ü o dyopjü c'o profeta, embeji. Nuc'ua texe c'o discípulo o c'ueñeji o zogüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","'Ma ya vi pënch'iji e Jesús, o zidyiji cja e Caifás c'ü mi mero ndamböcjimi, nu ja ya vi jmurü c'o tita 'ñe c'o mi xöpü o̱ ley Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","'Ma ya mi pöji, e Pedro mi bëpjatjo na jẽ, hasta 'ma o zät'ä nu cja c'ü o̱ tji c'ü mi mero ndamböcjimi. O cjogü c'ua e Pedro a mbo, o ma mimi nu ja ma cã c'o mbëpji, ngue c'ua ro nu'u pje ro tsjapüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma cã nu, c'o ndamböcjimi 'ñe c'o 'ñaja c'o ya vi jmurü ro jñünpüji ngüenda e Jesús. Nuc'ua mi jodüji testigo c'o ro xosp'ü o buëchjine e Jesús, ngue c'ua ro bö't'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Pero dya mimi yeje testigo c'o ro mama 'natjo o̱ jñavi. Nuc'ua 'ma ya vi mezhe ts'ë, o ẽjẽ c'ua yeje testigo o 'ñe ngöt'üvi o mamavi: ―Nujne Jesús o mama a cjava: “Sö rá yä'tp'ägö nu o̱ templo Mizhocjimi. Nuc'ua jñipatjo rá jäbä ngue c'ua ra jyärätjo na yeje”, eñe. Nuc'ü, ngue c'ü o mama c'o testigo. ");
INSERT INTO mazNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","O böbü c'ua c'ü mi mero ndamböcjimi o xipji e Jesús: ―¿Cjo dya sö rí chjünrügue? ¿Pje i̱ṉ mangue co nujyo jña yo na xi'tsc'eji? ");
INSERT INTO mazNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero e Jesús dya go ndünrü c'ü. Nuc'ua c'ü mi mero ndamböcjimi o dyönü o xipji: ―Xitsijme nza mbãrã Mizhocjimi c'ü bübü a jens'e, ¿cjo ngue'tsc'e Cristo c'ü ngue o̱ T'i Mizhocjimi, o jiyö? ");
INSERT INTO mazNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","O ndünrü c'ua e Jesús o xipji: ―C'ua ja gui mangue, nguezgö. Nutscö rvá ẽcjö cja Mizhocjimi, rí jñandgöji rva ẽcjö cja ngõmü a jens'e. Rí jñandgöji ri pë'sc'ö texe poder cja o̱ jodyë Mizhocjimi c'ü me na zëzhi. ");
INSERT INTO mazNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Go üdü c'ua c'ü mi mero ndamböcjimi, go ts'üdü c'o o̱ bitu c'o mi je'e c'ü, o mama: ―I̱ dyäräji o zadü Mizhocjimi nu. ¿Pje xe ni jyongöji o testigo? Cja i̱ dyäräji ya zadü Mizhocjimi nu. ");
INSERT INTO mazNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Pje xo i̱ṉ mangueji? O ndünrü c'ua anguezeji o mamaji: ―Pë's'i nu s'ocü c'ü rguí bö't'ü nu, eñe c'o ma jünpü ngüenda e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jo nu zosp'üji c'ua a jmi e Jesús. Bübü c'o mi ya'bü co punte, 'ñaja c'o mi pjë'chp'i a jmi c'ü dya mi janda e Jesús cjó mi ngue. ");
INSERT INTO mazNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nguec'ua mi xipjiji e Jesús: ―Maco i̱ṉ mangue ngue'tsc'e e Cristo, rí xitscöjme cjó ngue c'ü na pjë'chc'i in jmi dya. ");
INSERT INTO mazNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","E Pedro ya vi mintjo nu cja c'e tji. Mi bübü nu 'na ndixũ c'ü mi pëpji nu. Nu c'e ndixũ o chëzhi a jmi e Pedro, o xipji: ―Nu'tsc'e, xo mi dyocjevi e Jesús nu menzumü a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","O ngädätjo c'ua e Pedro o mama: ―Dya rí pãrãgö pje pjëzhi c'ü i̱ṉ mangue. Nde go dyärätjo c'ua texe c'o mi cãrã nu. ");
INSERT INTO mazNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nuc'ua e Pedro o mbedye c'ua cja c'e ngoxtji. Mi bübü nu c'ü 'na ndixũ c'ü xo mi pëpji nu. Angueze o jñanda e Pedro mi böbü nu, nguec'ua va xipji c'o mi cãrã nu: ―Xo 'ñe ne bëzo nu, nde mi bübüvi e Jesús nu menzumü a Nazaret, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","E Pedro o yepe o ngädätjo c'ua, o mama: ―C'ua ga mbãrã Mizhocjimi, dya rí pãrãgö ne bëzo nu. ");
INSERT INTO mazNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dya mezhe c'ua o chëzhi a jmi e Pedro nu c'o mi böntjo nu, o xipjiji: ―Na cjuana xo ngue'tsc'e 'naja yo o̱ dyoji nu, na ngueje c'ua ja gui ña, ixi 'mã'tc'ãtjo. ");
INSERT INTO mazNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nuc'ua e Pedro o mama: ―C'ua ga mbãrã Mizhocjimi, dya rí pãrgö ne bëzo nu. 'Ma dya cjuana c'ü rí xi'tsc'öji, ra zücö 'ma c'ü. Jo ni huë c'ua 'na tare. ");
INSERT INTO mazNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","O mbeñe c'ua e Pedro c'o jña c'o vi xipji e Jesús c'ü dya be ri huë tare 'ma ya na jñi rví ngädä c'ü mi pãrã. Cjanu o mbedye c'ua e Pedro a tji, me go huë c'ua co texe o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nuc'ua c'ü xõrü, texe c'o ndamböcjimi 'ñe c'o tita cja c'e jñiñi mi pötma dyü't'üji ja rvá tsjapüji e Jesús ngue c'ua ro mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","O jyü'tp'üji c'ua o̱ dyë e Jesús, cjanu zidyiji a ma cja e Pilato c'ü mi gobernador. ");
INSERT INTO mazNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Nuc'ua 'ma o mbãrã e Judas c'ü vi jñünpüji ngüenda e Jesús ro bö't'ü, me co nguijñi c'ua c'ü, na ngue vi nzhö'ö. Nuc'ua cjanu o jñünü c'ua c'o treinta merio o plata o ma zogütjo cja c'o ndamböcjimi, 'ñe c'o tita, cjanu o mama: ―Ró cjagö c'o na s'o. Na ngue ró nzhö'ö c'ü ra bö't'ü 'na bëzo c'ü dya pje tsja, eñe c'ü. Anguezeji cjanu o mamaji c'ua: ―¿Pje pë'sc'ü rá nugöjme? Nu'tsc'e rí ñu'u ja rgui tsjapü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nuc'ua e Judas o mbozü c'o merio a mbo cja c'e templo. Cjanu o ma c'ua, o ma ngant'atsjë tjüjmü o̱ dyizi, cjanu o chjüns'ütsjë cja 'na za'a. ");
INSERT INTO mazNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nuc'ua c'o ndamböcjimi o mbëchiji c'o merio, cjanu o mamaji: ―Nguejyo o 'nõmü 'na nte c'ü rguí bö't'ü. Nguec'ua dya ra sö rá üt'üji nu ja quiji c'o ni mbeñeji Mizhocjimi. Na ngue je ga mama a cjanu ín leyji, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nuc'ua 'ma ya vi ñaji, cjanu o jñüji c'o merio, o ma ndõmüji c'ü o̱ juajma 'na bëzo c'ü mi ät'ä o traste. O ndõmüji ngue c'ua je ro dyögüji nu, c'o dya ri menzumü cja c'e ndajñiñi c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nguec'ua c'e juajma c'ü, xe ni chjũtjo dya: “Juajma c'ü o 'nõmü co c'ü vi nzhũ 'na nte.” ");
INSERT INTO mazNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Je va cjanu va zädä o̱ jña Mizhocjimi c'ü vi mama c'e profeta Jeremías: “C'o o̱ mboxbëche e Israel o mamaji c'ü mi muvitjo treinta merio o plata c'e nte c'ü. Nguec'ua o ngõ't'üji, cjanu o nguis'iji c'o merio. ");
INSERT INTO mazNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nuc'ua co c'o merio, o ma ndõmüji c'ü o̱ juajma c'e bëzo c'ü mi ät'ä o traste, o ndõmüji c'ua ja nzi va xitsi Mizhocjimi ro tsjapüji c'o merio”, eñe e Jeremías. Nguec'ua 'ma o ndõmüji c'e juajma, o zädä c'e jña c'ü vi mama e Jeremías. ");
INSERT INTO mazNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","E Jesús ma böntjo a jmi c'e gobernador c'ü mi chjũ Pilato. Nuc'ua c'e gobernador o dyönü o xipji: ―¿Cjo ngue'tsc'e o̱ rey yo menzumü a Israel? O ndünrü c'ua e Jesús o xipji: ―Jã, c'ua ja gui mangue, nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nuc'ua c'o ndamböcjimi 'ñe c'o tita o ngöt'üji e Jesús cja c'e gobernador, pero e Jesús dya mi tjünrü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nuc'ua e Pilato c'ü mi gobernador o xipji: ―¿Cjo dya i̱ṉ ärägue texe yo pje nde xi'ts'iji? ");
INSERT INTO mazNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero dya go ndünrü e Jesús ne ri 'naja jña c'o pje nde ma xipjiji. Nguec'ua c'e gobernador, dya mi pãrã pje ro nguijñi. ");
INSERT INTO mazNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tsjë'ma mi cjaji c'e mbaxua c'ü ni chjũ Pascua, y xo mi cja c'o nte mi ötüji 'na favor c'e gobernador. Mi ötüji ro 'ñeme libre 'naja bëzo c'ü ma o'o a pjörü. Y c'e gobernador cja rrũ 'ñeme c'ua libre c'e nte. ");
INSERT INTO mazNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","C'o pa c'o, ma o'o a pjörü 'na bëzo c'ü mi chjũ Barrabás c'ü me mi näntji ma s'o. ");
INSERT INTO mazNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","C'o ndamböcjimi 'ñe c'o tita, mi mbidiaji e Jesús, nguec'ua va nzhöji cja e Pilato. E Pilato o unü ngüenda pje vi nzhöji, nguec'ua va dyönüji: ―¿Ja ngue c'ü i̱ṉ negueji rá pjongü cja ne pjörü ra ma libre? ¿Cjo ngue e Barrabás o ngue e Jesús nu xiji Cristo? ");
INSERT INTO mazNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma jũ'ũ e Pilato nu ja mi jün ngüenda. Nuc'ua c'ü nu su e Pilato o mbenpe 'na jña, o xipji: “Dya pje rí tsjapü c'e bëzo c'ü dya pje tsja c'o na s'o. Na ngueje mi xõmü ró cjinch'i angueze, me ró sufre rvá cjinch'i”, eñe c'e ndixũ. Nguec'ua e Pilato xenda mi ne ro 'ñeme libre e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero c'o ndamböcjimi 'ñe c'o tita mi ü't'üji c'o nte ro dyötüji e Pilato ro 'ñeme libre e Barrabás, y xo ro dyörüji c'ü ro mbö't'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Cjanu o mama c'ua e Pilato o xipjiji: ―¿Ja ngue c'ü i̱ṉ negueji rá eme libre? Anguezeji nzhangua ndünrüji c'ua: ―Rí 'ñeme libre e Barrabás, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nuc'ua e Pilato o mama: ―¿Pje rá cjapcö 'ma ne Jesús nu xiji e Cristo? Cjanu o mama c'ua texe c'o nte: ―Chät'ä cja ngronsi nu. ");
INSERT INTO mazNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nuc'ua e Pilato o mama: ―¿Pje ni mbë c'ü na s'o c'ü o tsja nu? Anguezeji xenda go mapjüji na jens'e o mamaji: ―Mangue ra dät'ä cja ngronsi nu, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nuc'ua o nu'u e Pilato c'ü dya mi sö ja rvá tsjapü, ro 'ñeme e Jesús. Na ngue xenda mi huëñi c'o nte, 'na ro tsjaji o̱ dyëji. Nguec'ua e Pilato o ma tjë 'na mojmü o ndeje, cjanu o xindyë a jmi cja c'o nte, o mama: ―Ra bö't'ü ne bëzo c'ua ja nzi gui mangueji, pero dya pje rí tö'tp'ügö nada nu. Nguec'ua rí xindyëgö c'ü rgui pãrãgueji c'ü dya rí pë'sc'ö ín s'ocü; ngue'tsc'eji i̱ṉ pë's'i nin s'oqueji c'ü ra bö't'ü nu, eñe e Pilato va xipji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Cjanu o ndünrü c'ua texe c'o menzumü a Israel o mamaji: ―Dya ra tsja, nguezgöjme rá tuns'ü ín nzhubüjme c'ü rguí bö't'ü nu. Xo 'ñe c'o ín ch'igöjme xo ra nguejmeji responsable. Xo 'ñe c'o ín bëchejme. ");
INSERT INTO mazNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nuc'ua e Pilato o 'ñeme c'ua libre e Barrabás c'ua ja va dyörü c'o nte. Cjanu o manda c'ua e Pilato o ndas'üji e Jesús co chirrio. Nuc'ua 'ma o nguarü o ndas'üji, cjanu o nzhöji e Jesús ngue c'ua ro ma ndät'äji cja ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nuc'ua c'o o̱ tropa c'e gobernador o zidyiji e Jesús o möji cja c'ü o̱ palacio. Nzhangua jmurü c'ua texe c'o tropa c'o mi cãrã nu. ");
INSERT INTO mazNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Cjanu o ts'osp'üji c'ua c'o o̱ bitu e Jesús. Cjanu o jyecheji c'ua 'naja bitu c'ü ma mbaja. ");
INSERT INTO mazNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nuc'ua o dyät'äji 'na corona c'ü mi dyavo bidyi, cjanu jñu'tp'üji a ñi e Jesús. Cjanu o ngö'tp'üji 'na xitji cja o̱ jodyë e Jesús. Nuc'ua cjanu o ndüñijõmüji a jmi, me mi pãtãji mi xipjiji: ―Nu'tsc'e o̱ reyts'ügue yo menzumü a Israel, sido rí mandague, mi embeji ma tsjapüji burla. ");
INSERT INTO mazNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Me mi sos'üji, y o jñünbüji c'ua c'e xitji c'ü vi ngö'tp'üji a dyë. Co nuc'ü, mi ya'p'üji a ñi. ");
INSERT INTO mazNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nuc'ua 'ma o nguarü o eñbeji, o ts'osp'üji c'ua c'e mbabitu c'ü vi jyecheji. Cja ndo nu jyecheji c'ua c'o o̱ bitutsjë. O zidyiji c'ua nu ja ro ma ndät'äji cja ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nuc'ua 'ma ya ma pedyeji cja c'e ndajñiñi, o chjëji 'na bëzo c'ü mi chjũ Simón, c'ü mi menzumü a Cirene. Nuc'ü, o tsjapüji o nduns'ü c'e ngronsi c'ü mi tuns'ü e Jesús c'ü rví ndät'äji. ");
INSERT INTO mazNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","O zät'äji c'ua, nu ja ni chjũ'ũ Gólgota c'ü ne ra mama: T'ejeñinte. ");
INSERT INTO mazNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nuc'ua mi unüji e Jesús ro zi o vino c'ü vi chjanbaji c'ü ma cjõ'õ. 'Ma mü o zö, dya go ne go zi c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nuc'ua c'o tropa 'ma o nguarü o ndät'äji e Jesús cja c'e ngronsi, o eñeji c'ua, cjó ngue c'ü ro tsjapü o̱ cjaja c'o o̱ bitu e Jesús. Nguec'ua va zädä c'o vi mama 'na profeta: “O eñeji cjó ngue c'o ro ngana c'o ín bitugö”, eñe cja o̱ jña Mizhocjimi c'ü o dyopjü c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Cjanu o mintji nu, mi pjörütjoji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Cjanu o cuatüji a ñi c'e ngronsi c'ü mi t'opjü, ngue c'ua ro 'mãrã pje vi tjünpü ngüenda angueze. Mi t'opjü a cjava: “Nujnu, ngueje e Jesús nu o̱ rey yo menzumü a Israel.” ");
INSERT INTO mazNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nuc'ua xo ndät'äji nu, yeje mbẽ. 'Naja c'ü o ndät'äji bëxtjo cja o̱ jodyë e Jesús, 'naja c'ü o ndät'äji c'ü 'nanguarü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Nu c'o mi cjogü nu, me mi juant'ü a ñi ma zadüji e Jesús, mi xipjiji: ―Nu'tsc'e mi mangue rvi yä't'ä c'e templo, y c'ü na jñi nu pa rvi cjuatü rvi jyäbätjo na yeje. 'Ma ngue'tsc'e o̱ T'itsc'e Mizhocjimi, 'ñemetsjë dya, dyagü cja ne ngronsi, mi embeji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Xo ma mantjo c'ua c'o ndamböcjimi, 'ñe c'o xöpüte, 'ñe c'o fariseo, 'ñe c'o tita. Me mi cjapüji burla e Jesús, mi mamaji: ");
INSERT INTO mazNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Maco o mbös'ü na puncjü o nte nu, maco dya sö ra 'ñemetsjë ra dagü cja ne ngronsi. 'Ma ngueje nu ra manda a Israel nu, ra dagü dya 'ma cja ne ngronsi, ngue c'ua rá ejmegöji 'ma nu. ");
INSERT INTO mazNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Maco mi ench'e o̱ mü'bü Mizhocjimi nu, na ngueje mi mama nu: “Nguezgö o̱ T'izügö Mizhocjimi”, mi eñe nu. Nguec'ua 'ma s'iya Mizhocjimi nu, sö ra ẽ dya Mizhocjimi ra 'ñe 'ñeme cja ne ngronsi, mi eñeji ma tsjapüji burla. ");
INSERT INTO mazNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nuc'ua c'o ye mbẽ c'o 'natjo c'ua vi ndät'äji e Jesús, xo nde ma xitjo c'ua c'o na s'o jña c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nuc'ua 'ma cja vi zünütjo jñisiarü, o bëxõmü c'ua textjo cja ne xoñijõmü, hasta 'ma cja zünü jñi c'ü nzhä. ");
INSERT INTO mazNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nuc'ua 'ma ya mi ngue ro zünü jñi c'ü nzhä, o mapjü c'ua na jens'e e Jesús o mama: ―Elí, Elí, lama sabactani, mi eñe. C'e jña ne ra mama: “Nu'tsc'e ín Mizhocjimits'ügö, ín Mizhocjimits'ügö, ¿jenga i̱ jyëzguigö?” ");
INSERT INTO mazNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","C'o mi cãrã nu, o dyäräji c'o vi mama e Jesús. Bübü anguezeji c'o o mama c'ua: ―Nujnu, ma't'ü e Elías rguí 'ñeje a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cjanu o cjuan'di c'ua 'naja anguezeji, o ma cãjã c'ua 'naja esponja. Cjanu o ngant'a cja vinagre, cjanu o ngãsp'ã cja 'na xitji, mi unüji e Jesús ro züt'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero c'o 'ñaja mi mamaji: ―Jyëzi, rá nuxãji cjo ra ẽjẽ e Elías ra 'ñe 'ñeme nu. ");
INSERT INTO mazNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nuc'ua e Jesús ndo go yepco mapjütjo na jens'e, ixco ndũtjo c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nzi va ndũ e Jesús, o chödü a nde c'e manta c'ü mi 'nüns'ü a mbo cja c'e templo, c'ü mi cjot'ü nu ja me ma sjũ. O xüt'ü ndeze nu ja mi 'nüns'ü hasta a jõmü. Go mbi c'ua na zëzhi ne xoñijõmü, go chädätsjë c'o ndojo. ");
INSERT INTO mazNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","C'o panteón nu ja mi cöt'üji o añima, go xogü c'o. Go yepe go mintjo na puncjü c'o nte c'o mi ejme Mizhocjimi c'o ya vi ndũ. ");
INSERT INTO mazNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'Ma mü o te e Jesús, cja xo mbedyeji c'ua anguezeji nu ja vi ngöt'üji, cjanu o möji c'ua a Jerusalén c'ü ngue o̱ ndajñiñi Mizhocjimi. Na puncjü nte c'o mi cãrã nu, c'o o ndäcä anguezeji c'ü ya vi tetjoji. ");
INSERT INTO mazNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","C'ü o̱ xo'ñi c'o tropa, 'ñe c'o o̱ tropa c'o mi pjörü e Jesús, o unüji ngüenda c'ü mi mbi ne xoñijõmü, 'ñe c'o pje nde mi cja. Me go zũ c'ua c'o, go mamaji: ―Na cjuana mi ngue o̱ T'i Mizhocjimi nu, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma jẽ ts'ë cja c'e ngronsi, mi cãrã na puncjü o ndixũ, mi jandaji e Jesús. Anguezeji mi pöji e Jesús ndeze a Galilea, mi pjös'üji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Cja c'o ndixũ c'o, mi bübü nu e María Magdalena, 'ñe e María c'ü nu nana e Jacobo 'ñe e José. Xo mi bübü nu, c'ü nu su e Zebedeo. ");
INSERT INTO mazNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Mi bübü 'na bëzo c'ü mi chjũ José c'ü mi menzumü a Arimatea. Mi pë's'i na puncjü o merio. Nu c'e bëzo mi ätpä o̱ jña e Jesús. 'Ma ya vi nzhä, o ma c'ua e José cja e Pilato, o ma dyötü c'ü o̱ cuerpo e Jesús. Nuc'ua e Pilato o manda ro unüji c'e cuerpo. ");
INSERT INTO mazNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nuc'ua e José o ndunü c'ü o̱ cuerpo e Jesús, cjanu o mböch'ü 'na t'öxbitu. ");
INSERT INTO mazNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","E José mi pë's'i 'na cueva c'ü dya cjó be mi cöt'üji nu, vi manda ro dyö't'üji cja peña. Je o ma ngöt'ü c'ua nu, c'ü o̱ cuerpo e Jesús. Cjanu o ngot'ü c'ua co 'na tralaja. Cjanu o ma c'ua c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nuc'ua e María Magdalena, 'ñe c'ü 'na María, o mintjovi a jmi cja c'e cueva. ");
INSERT INTO mazNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Nu c'e pa c'ü, ngue 'ma mi preparao c'o menzumü a Israel, na ngue c'ü na jyas'ü mi ngue c'e pa 'ma söyaji. Nuc'ua c'ü na jyas'ü, c'o ndamböcjimi 'ñe c'o fariseo o möji cja e Pilato, o xipjiji: ―Nu'tsc'e nin t'ecjañõmü, cja ró mbennc'öjme ja va mama c'e dyonpüte Jesús 'ma xe mi büntjo. O mama: “'Ma ya rguí zö'ö jñipa 'ma rá tũgö, rá tetcjö”, eñe c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nguec'ua rí mandague ra ma mbörüji cja c'e cueva hasta 'ma cja ra zö c'o jñipa. Na ngue 'ma jiyö, 'na ra ẽjẽ c'o o̱ discípulo ra 'ñe ngüs'üji c'e añima. Nuc'ua c'o discípulo ra xiji yo nte: “Ya tetjo e Jesús a nde cja c'o añima”, ra 'ñeñeji. Nu 'ma rga cjanu, xenda ra dyonpüji 'ma yo nte, que na ngue 'ma mi büntjo c'ü, eñe c'o ndamböcjimi 'ñe c'o fariseo va xipjiji e Pilato. ");
INSERT INTO mazNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Cjanu o mama c'ua e Pilato: ―Rá da'c'eji tropa ra ma mbörüji. Möji co anguezeji, tsjaji c'ua ja gui mbeñegueji, ngue c'ua dya cjó ra sö ra 'ñe ngüs'ü c'e añima. ");
INSERT INTO mazNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nuc'ua o möji anguezeji. Y pa dya cjó ro 'ñe ndörü c'e cueva, o meyaji c'ua c'e tralaja, cjanu o ngamaji c'o tropa o mbörüji nu. ");
INSERT INTO mazNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nuc'ua 'ma ya vi cjogü c'e pa 'ma mi söyaji, 'ma ya ma jya's'ü c'ü ot'ü pa'a nu ngo'o, o ẽjẽ c'ua e María Magdalena, 'ñe c'ü 'naja María ro 'ñe nu'uvi c'e cueva. ");
INSERT INTO mazNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nuc'ua o ẽjẽ c'ua 'naja c'o o̱ anxe Mizhocjimi, vi 'ñeje a jens'e o 'ñe chjen'chp'e c'e tralaja c'ü mi cjot'ü c'e cueva. Co nu c'ü vi 'ñe chjen'chp'e c'e tralaja, o mbi'i ne xoñijõmü. Nuc'ua c'e anxe cjanu mimi c'ua a xes'e cja c'e tralaja. ");
INSERT INTO mazNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","C'e anxe me mi juëns'i nza cja 'ma go juë's'i e dyebe. C'o o̱ bitu me mi jyaxtjo nza cja xitsji. ");
INSERT INTO mazNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nu c'o tropa 'ma o jñandaji c'e anxe c'ü vi 'ñe a jens'e, me co mbi'ch'i va pizhiji c'ua, y me co privaji. ");
INSERT INTO mazNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","6","Nuc'ua c'e anxe o xipji c'o ndixũ: ―Rí pãrãgö i̱ṉ jodüguevi e Jesús c'ü o ndät'äji cja ngronsi. Pero dya rí sũguevi, na ngueje dya cja bünc'ua c'ü; ya tetjo c'ua ja nzi va mama. Chjä'dä rí ñu'uvi nu ja ngöt'üji. ");
INSERT INTO mazNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nuc'ua 'ma rí cjuarü rí ñuvi, rí mëvi na niji rí ma xipjivi c'o o̱ discípulo e Jesús c'ü ya tetjo. Xipjiji c'ü ra ot'ü angueze ra ma a Galilea, je ra chjëji nu. Ya ró xi'ts'ivi, eñe c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nuc'ua c'o ndixũ ixco mbedyevi c'ua cja c'e cueva. Me mi sũvi, me xo mi mäjävi. O mëvi c'ua na niji ro ma xipjivi c'o discípulo c'o jña c'o vi dyärävi. ");
INSERT INTO mazNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","'Ma ndänt'ä ma mëvi, cjanu o ẽ c'ua e Jesús o 'ñe chjëji o zenguavi. Nuc'ua anguezevi o chëzhivi a jmi, o ndüñijõmüvi o nda'p'üvi a ngua, o ma't'üvi c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","E Jesús o xipji c'ua c'o ndixũ: ―Dya rí sũguevi. Mëvi rí ma xipjivi c'o mi cjuarmaji ra möji a Galilea, je rá chjëjme nu. ");
INSERT INTO mazNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nuc'ua 'ma ya vi ma c'o ye ndixũ, ja nzi c'o tropa c'o mi pjörü c'e cueva o möji a ma a Jerusalén, o ma ngös'üji c'o ndamböcjimi texe c'o vi ts'a. ");
INSERT INTO mazNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Nuc'ua c'o ndamböcjimi o jmurüji c'ua co c'o tita. Nuc'ua 'ma o nguarü o ñatsjëji, cjanu o unüji na puncjü o merio c'o tropa, cjanu o xipjiji: ―Nu'tsc'eji rí xipjiji yo nte c'ü o ẽjẽ c'o o̱ discípulo e Jesús mi xõmü, o 'ñe ndunüji c'ü o̱ cuerpo 'ma ya vi zü'c'eji t'ĩjĩ. ");
INSERT INTO mazNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nu 'ma ra mbãrã c'e gobernador c'ü vi ĩcjeji, jo rá ma jo'tp'ügöjme c'ü. Nguec'ua dya rí sũgueji, embeji c'o tropa. ");
INSERT INTO mazNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nuc'ua c'o tropa o nguiji c'ua c'o merio. Cjanu o ma tsjaji c'ua ja nzi va manda c'o ndamböcjimi. O xipjiji c'o nte c'ü vi 'ñeje c'o o̱ discípulo e Jesús, vi 'ñe ndunüji c'ü o̱ cuerpo. Nguec'ua hasta yo pa dya, xe mantji cja yo menzumü a Israel c'ü o ma ngüs'üji c'ü xõmü c'ü o̱ cuerpo e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nuc'ua c'o once discípulo cjanu o möji a ma a Galilea cja c'e t'eje nu ja ya vi xipjiji e Jesús ro möji. ");
INSERT INTO mazNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nuc'ua 'ma o jñandaji e Jesús, cjanu o ndüñijõmüji o ma't'üji. Pero bübü c'o discípulo c'o mi yembeñe mi mamaji: ―Pãrã, ¿cjo ri ngue e Jesús nu?, mi eñe c'o. ");
INSERT INTO mazNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nuc'ua e Jesús o chëzhi a jmi anguezeji, o zopjüji o xipjiji: ―Nutscö ya nde ch'acügö texe poder c'ü na zëzhi a jens'e, 'ñe cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nguec'ua nu'tsc'eji rí möcjeji cja yo nte yo cãrã texe cja ne xoñijõmü, rí xöpüji o̱ jña Mizhocjimi ngue c'ua ra 'ñejmezüji. Y 'ma rí jichiji cja ndeje, rí ñänbäji o̱ tjũ Mizhocjimi c'ü mi Tata, 'ñezgö nu T'izü, 'ñe o̱ Espíritu. ");
INSERT INTO mazNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Rí xöpüji yo nte ra tsjaji texe c'o ya ró xi'ts'iji. Jñunt'ü in mün'c'eji nutscö rí bübü co nu'tsc'eji textjo yo cjë, hasta 'ma ra nguarü ne xoñijõmü, dya rá jëtsc'iji. Je rga cjanu, amén.");
INSERT INTO mazNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Rá xi'tsc'öji ja ga cja e Jesucristo c'ü o̱ T'i Mizhocjimi. Ne historia o mbürü 'ma mi zopjü e Juan c'o nte, c'ua ja nzi va dyopjü mi jinguã e Isaías c'ü mi profeta. O dyopjü a cjava: Dyärä, ró juajnügö 'na bëzo ra zopjü yo nte ra xipjiji ín jñagö. Ra ot'ü in xo'ñigue ngue c'ua 'ma rí mague, ya rguí bübü dispuesto yo nte ra dyä'tc'äji. ");
INSERT INTO mazNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ri bübü 'na nte c'ü je ra mapjü cja ndajyadü, ra mama a cjava: “Rí jyëzigueji c'e 'ñiji c'ü na s'o, na ngueje ya ngue ra ẽjẽ c'ü ín Jmugöji c'ü bübü a jens'e”, ra 'ñeñe c'e nte. ");
INSERT INTO mazNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mi ngueje e Juan c'ü o mapjü a cjanu. O ma cja ndajyadü o ma jichi c'o nte cja ndeje. O zopjüji o xipjiji: ―Ra nzhogü in mü'büji, rí jiji, ngue c'ua Mizhocjimi ra perdonao in nzhubügueji, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Texe c'o mi cãrã a Judea 'ñe cja c'e jñiñi a Jerusalén o möji cja c'e ndajyadü o ma dyäräji c'o mi mama e Juan. O mamaji c'o na s'o c'o mi cjaji. Nuc'ua e Juan o jichiji cja c'e ndare c'ü ni chjũ a Jordán. ");
INSERT INTO mazNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","E Juan mi je'e 'na bitu c'ü vi t'ät'ä o̱ xi o camello, y mi nzünt'ü 'naja xipjadü. Mi sa'a c'o mi nza cja o t'ünxü 'ñe mi si o õt'apjü ngüjnü. ");
INSERT INTO mazNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","O mama a cjava e Juan o xipji c'o nte: ―Ra ẽjẽ 'naja bëzo c'ü me pjëzhi na nojo; nutscö rí menutjogö que na ngueje 'na mbëpji. Bübü o mbëpji c'o o̱ cjaja c'ü nu lamu, xäpcäji o̱ correa cja o̱ tjĩza c'ü nu lamu ga mbös'ü. Nutscö, dya pje pjëtscö rá pjösc'ö a cjanu nu c'ü va ẽjẽ. ");
INSERT INTO mazNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nutscö rí jichi co ndeje yo nte. Pero nu c'ü cja va ẽjẽ, 'ma rí 'ñench'e in mü'büji angueze, nuc'ü, ra dya'c'üji o̱ Espíritu Mizhocjimi c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","E Jesús ma bübü a Nazaret c'ü tsja a Galilea. O ẽ 'na nu pa, o mbedye o ma nu ja ma bübü e Juan. E Juan o jichi cja c'e ndare a Jordán. ");
INSERT INTO mazNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nuc'ua e Jesús, 'ma o mbes'e cja c'e ndeje o jñanda c'ua o xogü a jens'e. Xo o jñanda ma sjöbü o̱ Espíritu Mizhocjimi nza cja 'na mbaro, ma ẽ ndägä a xes'e angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","O dyäräji c'ua 'naja c'ü o ña a jens'e o mama: ―Ngue'tsc'e ín Ch'itsc'ö, me rí s'iyats'ü, me rí mä'c'ägö. ");
INSERT INTO mazNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nuc'ua o̱ Espíritu Mizhocjimi o ndäjä e Jesús, o ma cja 'na ndajyadü. ");
INSERT INTO mazNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","O mezhe nu cuarenta pa'a. Mi cãrã nu, c'o animal c'o na sate. Xo mi bübü nu, e Satanás nu c'ü dya jo; mi xipji e Jesús c'ü ro tsja c'o na s'o. Nuc'ua o ẽ c'ua c'o o̱ anxe Mizhocjimi, o ẽ mbös'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","'Ma o ngot'üji e Juan a pjörü, nuc'ua e Jesús o nzhogü o ma cja c'e xoñijõmü a Galilea. Mi zopjü o̱ jña Mizhocjimi c'o nte, mi xipjiji ja rvá sö ro 'ñemeji libre cja c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mi xipjiji: ―Ya zädä yo pa, ya ngue ra manda nu c'ü o 'ñeme Mizhocjimi. Tsjapüji ra nzhogü in mü'bügueji, 'ñejmeji o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","'Na nu pa, mi nzhodü e Jesús a jmi c'e zapjü a Galilea. O jñanda c'ua yeje bëzo c'o ma pät'ä o̱ t'ös'üvi cja c'e zapjü. C'o bëzo mi cjuarma c'o. 'Naja c'ü mi chjũ Simón. C'ü 'naja mi chjũ Andrés. Anguezevi mi mbajmõvi. ");
INSERT INTO mazNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Cjanu o mama c'ua e Jesús o xipjivi: ―Nu'tsc'evi i̱ṉ mbajmõvi dya. Pero chjünt'üvi ín xütcjö, rá jí'ts'ivi rí zopjüvi yo nte ngue c'ua anguezeji xo ra ndünt'üji ín xütjügö, embevi. ");
INSERT INTO mazNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jo ni zogüvi c'ua c'o o̱ t'ös'üvi, cjanu o ndünt'üvi c'ua o̱ xütjü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Xe möji a ma xo'ñi. E Jesús o jñanda c'ua xe yeje bëzo c'o xo mi cjuarmavi. 'Naja c'ü mi chjũ Jacobo. Nu c'ü nu cjuarma mi chjũ Juan. Mi ngue o̱ t'ivi e Zebedeo. Ma cãji cja 'na bü; ma jocüji c'o o̱ t'ös'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","E Jesús o ma't'ü c'ua c'o yeje cjuarma. O jyëzivi c'ua c'ü nu tatavi cja c'e bü co c'o mbëpji. Nuc'ua o ndünt'üvi a xütjü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","O möji c'ua a Capernaum. Nuc'ua nu pa c'ü söyaji, e Jesús o cjogü a mbo cja o̱ nitsjimi anguezeji. Je mi xöpü c'o nte nu. ");
INSERT INTO mazNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","C'o nte me mi dyönütsjëji na ngueje mi ña e Jesús c'o jña c'o vi unü Mizhocjimi. Mi mamaji: “Nu ne bëzo nu, nandyo ga xöcüji. Maco, dya xöcöji c'ua ja nzi ga cja c'o xöpü o̱ ley Mizhocjimi”, mi eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","O cjogü c'ua a mbo cja c'e nitsjimi 'naja bëzo c'ü mi o'o o̱ mü'bü 'naja demonio. O mapjü c'e bëzo o mama: ");
INSERT INTO mazNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Nu'tsc'e Jesús i̱ṉ menzumü a Nazaret, ¿pje i̱ṉ pë's'i c'ü rí ñu co nutscöjme? ¿Cjo vi 'ñecje rí tsjacü rá ma sufridogöjme? Nutscö rí pã'c'ã. Ngue'tsc'e o̱ T'itsc'e Mizhocjimi, dya bübüts'ü c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","E Jesús o huënch'i c'ua c'e demonio o xipji: ―Tso't'ü in te. Pedye cja ne bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nuc'ua c'e demonio o mapjü na jens'e, o tsjapü o nügü c'e bëzo. O mbedye c'ua cja c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Me co nguijñi c'ua c'o nte, mi pötma dyönüji o mamaji: ―¿Pãrã, pje ne ra mama nu cja'a ne bëzo? Xipji yo demonio ra mbedye, y pedye yo, o 'ñeñeji. ");
INSERT INTO mazNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nguec'ua dya mezhe c'ua, me mi näntji e Jesús texe cja c'o jñiñi c'o tsja a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nuc'ua e Jesús o mbedye cja c'e nitsjimi co e Simón 'ñe e Andrés 'ñe e Jacobo 'ñe e Juan. Cjanu o möji cja o̱ ngumü e Simón 'ñe e Andrés. ");
INSERT INTO mazNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","C'ü nu to'o e Simón mi orü cja ngama; nuc'ü, mi sö o pa'a c'ü. O xipjiji c'ua e Jesús mi sö'dyë c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Cjanu o ma c'ua nu ja mi orü c'e ndixũ. O pënchp'i o̱ dyë'ë, o xos'ü nu ja mi orü. O c'ueñe c'ua c'e pa'a. Nuc'ua c'e ndixũ o dyät'ä c'ua jñõnü, cjanu o 'huiñiji. ");
INSERT INTO mazNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nuc'ua 'ma ya vi nguibi e jyarü, o sinpiji e Jesús texe c'o mi sö'dyë 'ñe c'o mi bübü demonio cja o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Texe c'o mejñiñi o jmurüji a jmi cja c'e ngumü. ");
INSERT INTO mazNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","E Jesús o jocü na puncjü c'o mi sö'dyë. Xo o pjongü na puncjü o demonio cja o̱ mü'bü yo nte. Dya mi jëzi ra ñaji, na ngueje mi pãrãji pje mi pjëzhi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nuc'ua c'ü xõrü ts'i vi nanga e Jesús. Xe mi xõmütjo. O mbedye cja c'e ngumü. O ma cja 'na ndajyadü, mi ötü Mizhocjimi nu. ");
INSERT INTO mazNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","E Simón 'ñe c'o mi joji angueze o ma jyodüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","'Ma o chöt'üji o xipjiji: ―Texe yo nte me jonc'üji, o 'ñeñeji. ");
INSERT INTO mazNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","O ndünrü c'ua e Jesús o xipjiji: ―Möjö cja yo jñiñi yo bëxtjo, ngue c'ua xo rá zopjü yo nte yo cãrã, rá xipjiji o̱ jña Mizhocjimi. Na ngueje ngueje yo rvá ẽcjö yo. ");
INSERT INTO mazNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","O ma c'ua cja c'o dyaja jñiñi c'o tsja a Galilea, mi zopjüji cja c'o o̱ nitsjimiji 'ñe mi pjongü o demonio. ");
INSERT INTO mazNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","O ẽjẽ c'ua 'naja bëzo c'ü mi sö o lepra. O ndüñijõmü a jmi e Jesús, o dyötü ro jopcü. O xipji: ―Nu 'ma i̱ṉ ne'e, ra sö rí jocüzü ne lepra. ");
INSERT INTO mazNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","E Jesús o juentse c'ua c'e bëzo. Cjanu o c'uana c'ua o̱ dyë o ndörü c'e bëzo, o xipji: ―Rí negö ra jogüts'ü, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jo ni c'ueñe c'ua c'e lepra c'ü mi sö c'e bëzo. O jogü c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","E Jesús o 'ñezhe c'ua, o xipji: ");
INSERT INTO mazNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Pjötpügue ngüenda c'ü dya cjó rí ma xipjigue ja va jogüts'ü. C'ü rí tsja, rí ma cja c'e mböcjimi rí ma jizhitsjë c'ü ya jogüts'ü. Cja rrĩ unügue c'ua, c'ua ja nzi va manda e Moisés. Nuc'ua ra mbãrã yo nte c'ü ya jogüts'ü, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","O mbedye c'ua c'e bëzo. Zö vi xipji e Jesús c'ü dya cjó ro xipji, pero xenda o mama c'ü mi cja e Jesús. Nguec'ua e Jesús dya cja mi sö ro zät'ä cja 'na jñiñi na ngueje texe c'o nte ya mi pãrãji angueze. Nguec'ua je mi bübü nu ja dya cjó mi ndeñe. C'o nte c'o ja nde mi 'ñeje mi sät'äji nu ja mi bübü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","'Ma ya vi cjogü ja nzi pa, e Jesús o nzhogü a Capernaum. O dyäräji c'ua mi mama c'o nte, ya vi zät'ä e Jesús nu cja c'e ngumü nu ja mi oxü. ");
INSERT INTO mazNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","O jmurü c'ua na puncjü nte nu ja mi bübü angueze. Me mi nzhüji, dya cja mi sö ro cjogüji cja ngoxtji. E Jesús ma zopjü c'o nte o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nuc'ua o ẽjẽ nziyo bëzo c'o ma tuns'ü 'naja bëzo c'ü dya mi sö ro 'ñõmü. Ma sinpiji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero dya sö ja rvá tsjocüji cja o̱ jmi e Jesús, na ngueje me mi nzhüji nu cja c'e ngumü. O ndes'eji c'ua a xes'e cja c'e ngumü. O xä's'äji c'ua c'e techo, cjanu o sjö'büji c'e bëzo co texe c'ü mi os'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","E Jesús o unü ngüenda, c'o bëzo ya vi 'ñejmeji c'ü ro tsja angueze, ro jocü c'e bëzo. O mama c'ua e Jesús o xipji c'e bëzo: ―Nu'tsc'e sẽ, ró perdonaots'ü in nzhubügue, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Xo mi junrü nu, ja nzi c'o mi xöpü o̱ ley Mizhocjimi. O nguijñiji o dyönütsjëji a cjava: ");
INSERT INTO mazNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Jenga ña a cjanu ne bëzo nu ngueje Jesús? Chjëntjovi c'ü o zadü Mizhocjimi nu. Maco dya cjó sö cjó ra perdonao nzhubü; nguextjo Mizhocjimi c'ü sö.” ");
INSERT INTO mazNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Exmi pãrãtjo e Jesús c'o mi cjijñi anguezeji, nguec'ua o xipjiji c'ua: ―¿Jenga i̱ṉ cjijñiji a cjanu cja in mü'büji? ");
INSERT INTO mazNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ró xipji ne bëzo nu dya sö ra 'ñõmü: “Ró perdonaots'ü in nzhubügue.” Xo sö rá xipjigö ne bëzo: “Rí ñanga, rí chuns'ü yo i̱ṉ pjĩzhĩ, ma in nzungue.” ¿Ja ngue c'ü xenda na s'ëzhi c'ü ra zädä? ");
INSERT INTO mazNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Rvá ẽcjö cja Mizhocjimi, rí negö rí pãrãgueji sö rá perdonaogö yo nzhubü, nguec'ua dyäräji dya c'ü rá xipji ne bëzo. O xipji c'ua: ");
INSERT INTO mazNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Rí ñanga, chuns'ü nu in pjinguã nu i̱ṉ pjĩzhĩ, ma'a in nzumü, embe. ");
INSERT INTO mazNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","O nanga c'ua c'e bëzo c'ü dya mi sö ro 'ñõmü; o nduns'ü o̱ pjinguã c'ü mi pjĩzhĩ, cjanu o ma o̱ ngumü. Texeji o jñandaji 'ma o nanga c'e bëzo. Me go pizhiji go mamaji: ―Me na nojo Mizhocjimi. Nudya ró jandaji yo nunca rmí jandaji. ");
INSERT INTO mazNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","E Jesús o ma na yeje a ñünü c'e zapjü a Galilea. Me mi jmurü c'o nte nu ja mi bübü. E Jesús o xöpüji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","O mbedye c'ua nu, e Jesús; o jñanda e Leví c'ü nu t'i e Alfeo. Je mi junrü nu ja mi cobra o contribución. E Jesús o xipji c'ua: ―Chjünt'ü ín xütjügö. Cjanu o böbü c'ua e Leví, o ndünt'ü a xütjü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","'Na nu pa 'ma mi si xëdyi e Jesús cja o̱ ngumü e Leví, mi cãrã na puncjü c'o mi cobra o contribución 'ñe c'o nte c'o mi xiji na s'o na ngueje dya mi sũpüji o̱ ley c'o menzumü a Israel. 'Natjo c'ua mi siji xëdyi co e Jesús 'ñe c'o o̱ discípulo. Na ngueje na puncjü c'o mi tjünt'ü a xütjü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mi cãrã o fariseo c'o mi xöpü o̱ ley c'o menzumü a Israel. O jñandaji 'natjo c'ua ma siji xëdyi e Jesús 'ñe c'o mi cobra contribución 'ñe c'o dya mi sũpü o̱ leyji. Nguec'ua o xipjiji c'ua c'o o̱ discípulo e Jesús: ―¿Jenga nin xöpütegueji 'natjo c'ua siji o xëdyi yo cobra o contribución 'ñejyo dyaja yo na s'o'o?, eñe c'o fariseo. ");
INSERT INTO mazNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","E Jesús o dyärä c'o vi mama c'o fariseo, cjanu o xipjiji c'ua: ―Nu c'o dya sö'dyë, dya ni jyodü o médico c'o. C'o ni jyodü o médico ngueje c'o sö'dyë. Je xo ga cjatjonu, dya ngue c'o mama cja na jo, c'ü rvá ẽ rá xipji ra nzhogü o̱ mü'büji cja Mizhocjimi; ngue c'o pãrã tũ o̱ nzhubü c'ü rvá ẽ rá xipji ra nzhogü o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mi mbempje c'o o̱ discípulo e Juan 'ñe c'o fariseo. Nuc'ua o ẽjẽ ja nzi nte nu ja mi bübü e Jesús, o xipjiji: ―C'o o̱ discípulo e Juan me mbempje c'o; me ötüji Mizhocjimi. Je xo ga cjatjonu c'o o̱ discípulo c'o fariseo. Maco yo in discípulogue siji o xëdyi 'ma mbempje c'o dyaja. ");
INSERT INTO mazNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","O ndünrü c'ua e Jesús o xipjiji: ―'Ma ra chjüntü 'naja sẽ, 'ma dya be cjuarü c'e chjüntü, ¿cjo ra ne ra mbempje c'o o̱ dyoji? 'Ma ndänt'ä xe bübütjo c'e sẽ a nde anguezeji, dya ra mbempjeji. ");
INSERT INTO mazNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero ra zädä c'o pa 'ma ra zinbiji c'e sẽ. Nuc'ua cja ra mbempjeji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","O sido o ña e Jesús o xipjiji c'ü 'na jña: ―'Ma cjó c'o cãjã 'naja zëbitu c'ü ya xüt'ü, dya ra mbä't'ä c'ua co 'naja bitu c'ü cja dadyo. 'Ma rga cjanu, ra ñungü c'e bitu c'ü cja dadyo; xenda ra xüt'ü c'ua c'e zëbitu. ");
INSERT INTO mazNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Dya cjó xo xich'i o õt'apjü cja zëvota, na ngueje ro xüt'ü c'o zëvota, ro pjödü c'e t'apjü. O õt'apjü je xich'iji cja vota c'o cja dadyo, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","'Na nu pa 'ma mi söya c'o menzumü a Israel, e Jesús 'ñe c'o o̱ discípulo o cjogüji c'ua ja mi cja o ndëxü. C'o discípulo mi tücüji o ñirëxü, mi tjõ't'ü co o̱ dyëji, jo rron zaji. ");
INSERT INTO mazNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nuc'ua c'o fariseo o xipjiji e Jesús, o mamaji: ―Jñanda yo in discípulogue, na tücüji yo ñirëxü, maco mama c'ü o̱ ley Mizhocjimi c'ü dya sö rá cjaji a cjanu yo pa yo rí söyaji. ");
INSERT INTO mazNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji ya i̱ xörügueji nu c'ü o tsja e David 'ñe c'o mi dyoji, 'ma ya mi sant'aji. ");
INSERT INTO mazNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","O cjogü e David cja o̱ ngumü Mizhocjimi nu ja ma sjũ. Nuc'ua e David 'ñe c'o mi dyoji o ziji c'o tjõmëch'i c'o mi jũsp'üji Mizhocjimi nu. O tsjaji 'ma mi mero ndamböcjimi e Abiatar. Maco mama c'e ley c'ü dya cjó sö cjó ro zi c'o; nguextjo mböcjimi c'o sö ro zi c'o. Pero e David o zi; xo o unü o zi c'o mi dyoji angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","O sido o ña e Jesús o xipjiji: ―Mizhocjimi ot'ü o dyät'ä yo nte; cjanu o dyät'ä c'e pa c'ü ra söya yo nte. O tsja a cjanu ngue c'ua ra mbös'ü yo nte. Dya ot'ü o dyät'ä nu pa c'ü rí söyaji cja o dyät'ä c'ua yo nte ngue c'ua rvá zũpüji c'e pa. ");
INSERT INTO mazNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nutscö rvá ẽcjö cja Mizhocjimi. Nguextjozgö sö rá mangö ja rgui sũpüji yo pa yo rí söyaji, embeji c'o fariseo. ");
INSERT INTO mazNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nuc'ua e Jesús o ma na yeje cja c'ü o̱ nitsjimi anguezeji. Mi bübü nu 'naja bëzo c'ü mi dyot'ü o̱ dyë. ");
INSERT INTO mazNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Xo mi cãrã nu, c'o nte c'o mi jodü ja rvá ngöt'üji e Jesús cja c'o pje mi pjëzhi. Nguec'ua me mi jandaji e Jesús, mi nuji cjo ro jocü o nte c'e pa c'ü mi söyaji. ");
INSERT INTO mazNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nuc'ua e Jesús o xipji c'e bëzo c'ü mi dyot'ü o̱ dyë: ―Xä'dägue a 'ñecjua. ");
INSERT INTO mazNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nuc'ua e Jesús o tsja t'önü o xipji c'o nte: ―¿Ja ngue c'ü mama c'ü ín leygöji rá cjaji yo pa yo rí söyaji? ¿Cjo je mama a cjanu c'e ley rá cjaji c'o na jo o rá cjaji c'o na s'o? ¿Cjo je mama a cjanu c'e ley rá pjös'üji yo ín minteji ngue c'ua dya ra ndũji, o rá pö't'üji?, eñe. C'o nte dya pje o ndünrü c'o. O ngo't'ü o̱ neji. ");
INSERT INTO mazNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","E Jesús o nguinch'i na jo c'o nte. Mi üdü c'ü, pero mi juentseji. Me mi cjijñi e Jesús na ngueje me ma me o̱ mü'büji. Cjanu o xipji c'e bëzo: ―C'uana in dyë. Cjanu o c'uana c'ua o̱ dyë; o jogü c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pero c'o fariseo o mbedyeji cja c'e nitsjimi. O ma ñaji c'ua co nu c'o mi tjünt'ü a xütjü e Herodes. Mi jodüji ja rvá mbö't'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","E Jesús 'ñe c'o o̱ discípulo o möji c'ua cja c'e zapjü a Galilea. Na puncjü nte c'o o ndünt'ü c'ua a xütjü. Mi menzumüji a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","'Ma o dyäräji c'o mi cja e Jesús, xo o ẽjẽ na puncjü nte c'o mi menzumü a Judea, 'ñe a Jerusalén, 'ñe a Idumea, 'ñe c'o mi menzumü a 'nanguarü a Jordán. Xo o ẽjẽ c'o mi menzumü texe a ma a Tiro 'ñe a Sidón. O ẽ nuji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Me ma pizhi c'o nte c'o ma ẽjẽ. E Jesús o xipji c'o o̱ discípulo ro xõpcüji 'naja bü ngue c'ua dya ro s'is'iji. ");
INSERT INTO mazNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Na ngueje na puncjü c'o ya vi jocü. Nguec'ua texe c'o mi sö'dyë me mi chütüji, mi ne ro zät'äji cja o̱ jmi e Jesús, ro ndörüji. ");
INSERT INTO mazNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nu c'o demonio 'ma o jñandaji e Jesús, o ndüñijõmüji a jmi angueze. Mi mapjüji mi mamaji: ―Ngue'tsc'e o̱ T'its'ü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","E Jesús o huënch'iji o xipjiji c'ua c'ü dya cjó ro ma ngös'üji c'ü pje mi pjëzhi angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nuc'ua, o ma e Jesús cja 'na t'eje. O zojnü c'ua c'o bëzo c'o mi ne angueze. O möji nu ja mi bübü angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Cjanu o 'ñeme c'ua doce c'o ro dyoji angueze. O xipjiji: ―Ró empc'egöji rí ma zopjügueji yo nte ín jñagö. ");
INSERT INTO mazNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xo rí da'c'üji rí mandaji ngue c'ua rí jocüji c'o sö'dyë, y rí pjongüji o demonio, embeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nuyo, ngue o̱ tjũ'ũ c'o doce discípulo c'o o 'ñeme e Jesús: e Simón c'ü xo o jñusp'ü Pedro; ");
INSERT INTO mazNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","'ñe e Jacobo 'ñe e Juan c'ü nu cjuarma; o̱ t'ivi e Zebedeo. E Jesús o jñusp'üvi c'ü 'naja o̱ tjũvi Boanerges. C'e tjũ'ũ ne ra mama ngue bëzo c'ü na zëzhi nza cja 'ma yürü e dyebe. ");
INSERT INTO mazNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xo o 'ñeme e Andrés 'ñe e Felipe 'ñe e Bartolomé 'ñe e Mateo 'ñe e Tomás 'ñe e Jacobo c'ü nu t'i e Alfeo. Xo o 'ñeme e Tadeo 'ñe e Simón c'ü mi revolucionario. ");
INSERT INTO mazNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Xo o 'ñeme e Judas Iscariote, nu c'ü ro nzhö e Jesús. Nuc'ua e Jesús 'ñe c'o o̱ discípulo o cjogüji a mbo cja 'naja ngumü. ");
INSERT INTO mazNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","O ẽjẽ c'ua na yeje me na puncjü nte. Nguec'ua e Jesús 'ñe c'o o̱ discípulo dya mi sö ro ziji xëdyi. ");
INSERT INTO mazNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mi cãrã c'o nte c'o mi mama c'ü ya mi loco e Jesús. Nu c'ü nu mamá e Jesús 'ñe c'o o̱ cjuarma, 'ma o dyäräji c'ü mi mama c'o nte, o möji c'ua, ngue c'ua ro ma sijiji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Vi 'ñeje a Jerusalén c'o mi xöpü o̱ ley yo menzumü a Israel. Mi mamaji: ―Bübü demonio cja o̱ mü'bü ne Jesús. Nguetsjë e Satanás c'ü dya jo c'ü pjös'ü ne bëzo, nguec'ua pjongü o demonio. ");
INSERT INTO mazNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","E Jesús o ma't'ü c'ua c'o nte o xipjiji jña c'ü ro mbãrãji pje mi mama angueze. O mama e Jesús: ―¿Ja rgá sö e Satanás ra pjongü o demonio? Maco nguetsjë o̱ mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Cja 'na ndajñiñi c'ü ra chũtsjëji, ra chjorü 'ma c'o ri cãrã nu. ");
INSERT INTO mazNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Cja 'na ngumü, 'ma ra pötca chũtsjë c'o ri cãrã nu, ra chjorüji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Xo nzitjo e Satanás 'ma ro pjongü c'o demonio, xo ro chũtsjëji. 'Ma rva cjanu, ¿ja xe rvá sö ro manda 'ma c'ü? ");
INSERT INTO mazNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Dya cjó sö ra cjogü cja o̱ ngumü 'naja bëzo c'ü me na zëzhi, cja rron jñünbü c'o ri pë's'i, 'ma dya ot'ü ra jyü'tp'ü o̱ dyë c'e bëzo c'ü na zëzhi. Nguec'ua ra sö ra põnbü 'ma texe c'o ri pë's'i cja o̱ ngumü. ");
INSERT INTO mazNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","O sido o ña e Jesús o xipjiji: ―Rí xi'ts'iji, texe c'o na s'o c'o cja'a yo nte ra sö ra perdonaoji. Xo texe c'o me xipji na s'o jña, Mizhocjimi xo ra sö ra perdonaoji. ");
INSERT INTO mazNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero c'o ra zadü o̱ Espíritu Mizhocjimi ra mamaji o̱ bëpji o̱ Espíritu Mizhocjimi ngueje o̱ bëpji c'ü dya jo, nuc'o, dya ra perdonaoji. Nuc'o, tũ o̱ nzhubü c'ü dya ra perdonao Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","O mama a cjanu e Jesús na ngueje mi cãrã c'o o mama: “Bübü demonio cja o̱ mü'bü e Jesús.” ");
INSERT INTO mazNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","O säjä c'ua c'ü nu mamá e Jesús, cja na 'ñeje c'o o̱ cjuarma e Jesús. Mi böbütjoji a tji. O ndäjäji c'ua c'ü ro ma xipji e Jesús ro mbedye ro ẽ ñaji. ");
INSERT INTO mazNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nu ja mi bübü e Jesús mi junrü na puncjü o nte. O mama c'ua c'o nte o xipjiji e Jesús: ―Nin mamá 'ñe c'o nin cjuarma cãrãji a tji, neji c'ü rí ñaji. ");
INSERT INTO mazNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","O ndünrü c'ua e Jesús o xipji c'o nte: ―¿Cjó ngueje mi mamágö 'ñe mi cjuarmagö? ");
INSERT INTO mazNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","O jñanda c'ua c'o 'natjo c'ua mi junrüji. O mama: ―Je bübü va yo ngueje mi mamágö 'ñe mi cjuarmagö. ");
INSERT INTO mazNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Na ngueje texe c'o ra tsja c'ua ja ga ne'e Mizhocjimi, nuc'o, ngueje mi cjuarmagö c'o, 'ñe mi cjũgö c'o, 'ñe mi mamágö. ");
INSERT INTO mazNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","E Jesús o ma na yeje cja c'e zapjü a Galilea. Mi xöpü c'o nte nu. Cjanu o jmurü na puncjü nte nu ja mi bübü angueze. Nuc'ua e Jesús o dat'ü cja 'na bü'ü; je o mimi nu. C'e bü mi bübü cja ndeje. Texe c'o nte mi böbütjoji a ñünü cja c'e ndeje. ");
INSERT INTO mazNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nuc'ua e Jesús o xipjiji na puncjü jña c'o mi ngue ejemplo. O xipjiji a cjava: ");
INSERT INTO mazNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Dyäräji c'ü rá xi'ts'iji: 'Na mbonzhëxü o mbedye o ma mbodü o ndëxü. ");
INSERT INTO mazNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nuc'ua 'ma ya ma podü, bübü o ts'indëxü c'o o zobütjo cja 'ñiji nu ja mi cjogü o nte. O ẽjẽ c'ua c'o s'ü o mbëchiji c'o ts'indëxü. ");
INSERT INTO mazNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bübü o ts'indëxü c'o je zobütjo cja o mborojo nu ja dya ma pizhi o jõmü. Dya mezhe va mbes'e, na ngueje dya mi jäs'ä na puncjü jõmü. ");
INSERT INTO mazNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nuc'ua 'ma o mbes'e e jyarü, o banü c'o ndëxü o dyot'üji. Na ngueje dya vi mbeje o̱ dyüji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bübü o ts'indëxü c'o o zobütjo nu ja mi bodü o ndöbidyi. 'Natjo c'ua va mbes'eji. Ndajme o nocü c'o bidyi, nguec'ua dya jyëzi ro nocü c'o ndëxü. Nguec'ua dya nguiji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bübü o ts'indëxü c'o o zobü c'ua ja ma jo jõmü. Nuc'o, o nocü, o jogü na jo. Nzi 'na c'o ndëxü c'o o mbes'e, bübü c'o o unü treinta ts'indëxü. Dyaja c'o o unü sesenta; dyaja c'o o unü 'na ciento. ");
INSERT INTO mazNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","'Ma o nguarü o xipjiji a cjanu o mama c'ua e Jesús: ―Nu'tsc'eji bübü in tsõgueji, rí dyäräji na jo yo jña yo rí xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nuc'ua 'ma ya mi bübütsjë e Jesús, o ẽjẽ c'o doce discípulo, cja na 'ñeje ja nzi c'o dyaja nte c'o vi dyärä c'o o mama e Jesús. O ẽ dyönüji e Jesús o mamaji: ―¿Pje ne ra mama yo jña yo i̱ xitsijme? ");
INSERT INTO mazNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji o dya'c'üji Mizhocjimi rí pãrãji c'ü dya mi pãrã c'o nte 'ma ot'ü; o dya'c'üji rí pãrãji c'ua ja ga manda Mizhocjimi. Yo dyaja nte, rí xipjigö o ejemplo yo. ");
INSERT INTO mazNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngue c'ua zö ra jñandaji y ra dyäräji, pero dya ra mbãrãji pje ne ra mama yo jña. Na ngueje 'ma ro zo o̱ mü'büji, ro nzhogü o̱ mü'büji cja Mizhocjimi. Nuc'ua Mizhocjimi ro perdonao o̱ nzhubüji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nuc'ua e Jesús xe o xipjiji: ―¿Cjo dya i̱ṉ pãrãgueji pje ne ra mama yo jña yo cja ró xi'ts'iji? ¿Ja rgá sö rí pãrãgueji pje ne ra mama yo dyaja ejemplo yo rá xi'ts'iji? ");
INSERT INTO mazNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nu c'o jña c'o ró xi'ts'iji je a cjava c'o: Nu c'ü podü o ts'indëxü chjëntjovi nu c'ü zopjü o̱ jña Mizhocjimi yo nte. Nu c'o ts'indëxü ngueje o̱ jña Mizhocjimi c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","O ndëxü c'o o zobütjo cja 'ñiji, chjëntjoji c'o nte c'o ärä o̱ jña Mizhocjimi, nuc'ua va ẽjẽ e Satanás c'ü dya jo, va ẽ jünbü c'o jña c'o bübü cja o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","C'o ndëxü c'o o zobütjo cja mborojo, ngueje c'o ärä o̱ jña Mizhocjimi, nuc'ua me mäjä ga 'ñejme c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero dya si'ch'i cja o̱ mü'büji c'o jña. Nuc'ua 'ma ra ẽjẽ c'ü ra sufridoji 'ñe ra nuji na ü na ngue c'ü ni 'ñejmeji c'o jña, nuc'ua exta tõgüji, dya cja ra sidoji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nu c'o ts'indëxü c'o o zobütjo nu ja mi bodü o̱ ndö o bidyi, ngue c'o ärä o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero me mbeñeji c'o o̱ bëpjiji, 'ñe me jodüji ja rgá ndõjõji na puncjü o ch'opjü, 'ñe me mäpäji yo bübü cja ne xoñijõmü; cjaji c'o netsjëji. Nguec'ua dya cjaji c'ua ja nzi ga ne Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","C'o ndëxü c'o o zobü c'ua ja ma jo jõmü ngue c'o nte c'o ärä o̱ jña Mizhocjimi. Nuc'o, ejme co texe o̱ mü'bü c'o. Nguec'ua cjaji c'ua ja nzi ga ne Mizhocjimi. Chjëntjoji c'o ndëxü c'o me xo jogü na jo. Bübü c'o o unü treinta ts'indëxü; dyaja c'o o unü sesenta; dyaja c'o o unü 'na ciento. ");
INSERT INTO mazNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sido o ña e Jesús o xipjiji: ―'Ma tjütüji 'na sivi, dya co'büji co 'naja caja. Dya xo emeji a mbo cja 'na ngama. Je ẽ's'ẽji nu ja na ts'ijens'e, ngue c'ua ra jñandaji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","C'ua ja ga cja c'o, je xo ga cjatjonu ín jñagö. Zö dya pãrã dya yo nte, pje ne ra mama ín jñagö, pero ra zädä 'ma ra mbãrãji. Zö bübü o jña c'o dya mi pãrãji 'ma ot'ü, pero ra xogü o̱ ndö yo nte, ra unüji ngüenda ja ga cja. ");
INSERT INTO mazNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nu'tsc'eji bübü in tsõgueji, rí dyäräji na jo yo jña yo rí xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Xo o mama e Jesús o xipjiji: ―Rí dyätäji na jo yo o̱ jña Mizhocjimi yo i̱ṉ äräji; ra dya'c'üji mas rí pãrãji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","'Ma rí unnc'eji na jo ngüenda yo jña, Mizhocjimi ra dya'c'üji xenda rí tendiogueji yo. Zö i̱ṉ cjijñiji c'ü ya i̱ pãrãji 'na jña, pero 'ma dya rí unüji ngüenda, ra jñünnc'üji 'ma c'ü ts'iquë c'ü ya i̱ṉ pãrãji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Xe o ña e Jesús o mama: ―C'ü ni manda Mizhocjimi chjëntjovi nza cja 'na bëzo c'ü podü o ndëxü cja o̱ juajma. ");
INSERT INTO mazNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","'Ma xõmü ĩjĩ c'e bëzo. 'Ma ya ra jyas'ü, ra nanga ra ma pëpji. Nu c'o ndëxü c'o o mbodü nocü c'o. Pero dya pãrã c'e bëzo ja ga mbes'e c'o, ni ri ngueje ja ga te'e c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ngue e jõmü c'ü je cjapü ra te'e c'o ndëxü, 'ñe ra ngui'iji. Ot'ü ra mbes'e, nuc'ua ra nocü, cja rron c'os'ü o̱ nguĩ'ĩji. Nuc'ua ya ra ngui'i o ndëxü. ");
INSERT INTO mazNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nuc'ua 'ma ya ra jogüji ya ra ndagüji c'ua, na ngueje ya ni dyot'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Xe o ña e Jesús o xipjiji: ―Rá xi'ts'iji pje nza cja c'ü ni manda Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","C'ü ni manda Mizhocjimi, chjëntjovi nza cja 'na ndömortasa c'ü o jñü 'na bëzo, cjanu o ma ndujmü. O ndömortasa xenda ts'iquë cja yo dyaja ndöpjindyo. ");
INSERT INTO mazNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero 'ma ra nocü, xenda na nojo yo, que na ngueje yo pje nde ma c'ajna, na ndã'ã yo. Nguec'ua ga ẽjẽ yo s'ü ga dyät'äji o̱ t'oxüji nu. ");
INSERT INTO mazNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na puncjü ejemplo c'o mi mama e Jesús ma xipji c'o nte o̱ jña angueze. O xipjiji texe yo jña yo mi sö ro tendioji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dya zopjüji ne ri 'naja jña c'ü dya ro jyëntspiji 'na ejemplo. Pero o xipji na jo c'o o̱ discípulo ja cja. O xipjiji 'ma mi cãrãtsjëji. ");
INSERT INTO mazNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nuc'ua c'ü nzhä'ä c'e pa'a c'ü, o mama e Jesús o xipji c'o o̱ discípulo: ―Möjö je rá pes'eji 'nanguarü a manu cja ne zapjü, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","O 'ñezheji c'ua c'o nte. O dat'ü e Jesús cja 'na bü. C'o o̱ discípulo xo o dat'üji nu, o möji e Jesús. Mi järä nu, ja xe nzi o ts'ibü'ü c'o xo dat'ü c'o nte, xo möji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jo ni vü'ü c'ua 'na ndajma c'ü me ma zëzhi. Me mi pjõ's'ü c'e ndeje ma mbo'o c'e bü'ü. Mi cjijñiji ro nizhi ndeje c'e bü'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","E Jesús je mi orü cja o̱ squina c'e bü'ü. Ma ĩjĩ. Mi jũ's'ü o̱ ñi cja 'na almada. C'o o̱ discípulo o zopjüji c'ua e Jesús. O xipjiji: ―Nu'tsc'e xöpüte, ñanga. ¿Cjo dya i̱ṉ juentsquegöjme? 'Na rá tũgöjme. ");
INSERT INTO mazNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","O nanga c'ua e Jesús. O huënch'i c'e ndajma. O xipji c'e ndeje: ―Söya, juemegue. Cjanu o böbü c'ua c'e ndajma; c'o ndeje, dya cja mi pjõ's'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nuc'ua o mama e Jesús o xipji c'o o̱ discípulo: ―Nu'tsc'eji, ¿jenga i̱ṉ sũji? ¿Cjo dya i̱ṉ ejmezügöji rí pjö'c'ügöji? ");
INSERT INTO mazNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","C'o discípulo me mi sũji, mi pötma mamaji: ―¿Pãrã, pje pjëzhi ne Jesús? Maco manda ra böbü e ndajma 'ñe yo ndeje, y nujyo, ätäji nu. ");
INSERT INTO mazNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","O zät'äji c'ua a Gadara c'ü bübü a 'nanguarü c'e zapjü a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","'Ma ya vi mbes'e e Jesús cja c'e bü, o ẽjẽ c'ua 'na bëzo c'ü je vi 'ñeje cja panteón cja campo santo. O ẽ chjëvi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nu c'e bëzo, mi bübü demonio cja o̱ mü'bü. Dya cja mi bübü cja ngumü c'e bëzo; ya je mi bübü cja panteón cja campo santo. Dya cja mi sö ro ndün't'üji co cadena. ");
INSERT INTO mazNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Na ngueje ya ma puncjü vi ndün'tp'üji o̱ dyë 'ñe o̱ ngua co cadena. Nu c'e bëzo mi c'üdütjo c'o cadena. Dya mi sö ro zürüji. ");
INSERT INTO mazNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Xõmü ndempa mi nzhodü c'e bëzo cja t'eje 'ñe cja campo santo. Mi mapjü. Xo mi jüntsjë o ndojo cja rron dyodütsjë o̱ ts'ingue. ");
INSERT INTO mazNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nuc'ua c'e bëzo o jñanda e Jesús 'ma ma ẽjẽ na jẽ. O cjuañi c'ua c'e bëzo. 'Ma o zät'ä a jmi e Jesús, cjanu o ndüñijõmü nu. ");
INSERT INTO mazNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","O mapjü na jens'e o mama: ―Nu'tsc'e Jesús, o̱ T'its'ü Mizhocjimi a jens'e, ¿pje i̱ṉ pë'sc'ü rí ñugue co nutscö? Rí ö'tc'ügö, dya rí tsjacügö rá ma sufrido. ");
INSERT INTO mazNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","O mama a cjanu na ngueje e Jesús o mama: ―Nu'tsc'e demonio, pedyegue cja ne bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","E Jesús o dyönü c'ua c'e demonio: ―¿Pje ni chjũtsc'e? Cjanu o ndünrü c'ua: ―Ni chjũzü Legión na ngueje na puncjüzüjme, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","C'e demonio c'ü mi chjũ Legión mi ötü na puncjü e Jesús c'ü dya ro manda c'o demonio ro mbedyeji cja c'e xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mi cãrã na puncjü o cuchi cja c'e t'eje ma ñõnüji. ");
INSERT INTO mazNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nuc'ua c'o demonio o dyötüji e Jesús o xipjiji: ―Chäcjöjme nu cja yo cuchi ngue c'ua je rá quich'igöjme nu. ");
INSERT INTO mazNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nuc'ua e Jesús o jyëzi c'ua c'o demonio ro möji nu cja c'o cuchi. O mbedye c'ua c'o demonio cja o̱ mü'bü c'e bëzo. Je ma nguich'iji c'ua cja c'o cuchi. Nuc'ua texe c'o cuchi cjanu o zöbuji cja c'e dyä'ä, o ma jyäji nu cja c'e ndeje. O tsjünt'üji nu. C'o cuchi mi sö yeje mil c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","O cjuañi c'ua nu c'o mi c'as'ü c'o cuchi. O ma cöxteji cja c'e jñiñi 'ñe texetjo c'ua ja mi cjogüji. O mbedye c'ua c'o nte cja c'e jñiñi, o ma nuji pje na mbëjë c'o vi ts'a. ");
INSERT INTO mazNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","O zät'äji c'ua ja mi bübü e Jesús, o chöt'üji nu c'e bëzo c'ü vi mbedye c'o demonio. Mi junrü c'e bëzo, ya mi je'e o̱ bitu, ya vi ndümbeñe. O zũji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","O ña c'ua c'o nte c'o vi jñanda, o xipjiji c'o ma säjä ja va tsja e Jesús va pjongü c'o demonio c'o mi bübü o̱ mü'bü c'e bëzo. Nde xipjiji ja va ma nguich'i c'o demonio cja c'o cuchi. ");
INSERT INTO mazNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nuc'ua c'o nte ya mbürü o dyötüji e Jesús ro mbedye nu ja je mi jnorü o̱ xoñijõmü anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","O dat'ü c'ua e Jesús cja c'e bü. Nuc'ua c'e bëzo c'ü vi pjombgü demonio cja o̱ mü'bü mi ötü e Jesús c'ü ro mëvi. ");
INSERT INTO mazNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero e Jesús dya jyëzi ro mëvi, o xipji: ―Nzhogü, ma in nzungue. Rí xipji c'o in dyocjeji texe c'ua ja va juen'tsc'e Mizhocjimi 'ñe c'ua ja va mböxc'ü, embe. ");
INSERT INTO mazNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","O ma c'ua c'e bëzo cja c'o dyëch'a jñiñi c'o xiji Decápolis, o ma mama texe c'o vi tsja e Jesús 'ma o juentse. Texe c'o nte me mi dyönütsjëji ja va jocü e Jesús c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","'Ma ya mi bübü e Jesús cja c'e bü, cjanu o möji c'ua c'ü 'na lado c'e zapjü. 'Ma o zät'äji nu, o jmurü c'ua na puncjü o nte a ñünü c'e ndeje nu ja mi bübü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","O ẽjẽ c'ua 'naja bëzo c'ü mi chjũ Jairo. Nuc'ü, mi xo'ñi nu cja 'na nitsjimi a Israel. O jñanda mi bübü e Jesús, o ndüñijõmü c'ua cja o̱ jmi. ");
INSERT INTO mazNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mi mama c'e bëzo mi ötü e Jesús: ―Nu c'ü ín xunt'igö ya ngue ra ndũ. Xä'dä rí ma 'ñe's'e in dyë, ngue c'ua ra jogü y ra bübütjo. ");
INSERT INTO mazNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","O ma c'ua e Jesús, o mëvi c'e bëzo. Me ma puncjü nte mi pöji e Jesús, me mi chütüji ma möji. ");
INSERT INTO mazNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Xo mi pa 'na ndixũ c'ü ya vi mezhe doce cjë c'ü mi dagü o cji. ");
INSERT INTO mazNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ya vi dyät'ä cja na puncjü o médico, hasta ya vi ndeze texe o̱ merio. Pero dya cjó sö ro jocü; xenda mi cjatjo, sido mi sufrido. ");
INSERT INTO mazNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","C'e ndixũ o dyärä c'o mi mamaji c'o mi cja e Jesús. Nuc'ua c'e ndixũ je mi pa a xütjü e Jesús; o ndönbü c'ua o̱ bitu. ");
INSERT INTO mazNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Na ngueje mi cjijñi c'e ndixũ: “Nguextjo c'ü rá tjönbü o̱ bitu nu, exta ndixqui”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Exo böbü c'ua c'o cji c'o mi dagü. Exo zö c'ua c'ü ya vi jogü c'o me mi sufrido. ");
INSERT INTO mazNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","O mbãrã e Jesús c'ü cjó c'o vi jocü. O ñezhe a nde c'o nte, o mama: ―¿Cjó ngue c'ü o ndönngü ín bitu? ");
INSERT INTO mazNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","O ndünrü c'ua c'o o̱ discípulo o xipjiji: ―Nu'tsc'e i̱ṉ cjague t'önü cjó ngue c'ü o ndö'tc'ü in bitu. Maco me nzhü'ü yo nte, me s'ixc'igueji, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero e Jesús mi janda texe cja c'o nte ngue c'ua ro jñanda cjó mi ngue c'ü vi ndötpü o̱ bitu. ");
INSERT INTO mazNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","C'e ndixũ mi pãrã c'ü ngue e Jesús vi jocü. Nguec'ua o ndüñijõmü cja o̱ jmi, cjanu o xipji c'ua c'ü mi ngue angueze vi ndönbü o̱ bitu ngue c'ua ro ndis'i. Nu c'e ndixũ me mi sũ, me mi mbĩ. ");
INSERT INTO mazNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","O mama c'ua e Jesús o xipji c'e ndixũ: ―Nu'tsc'e süngü, ya jotsc'e dya, na ngueje i̱ 'ñejmezügö c'ü ro sö ro jo'c'üts'ü. Me rí mäjä rgui ma dya; dya cja rí sögue dya, c'ü me mi sufridogue. ");
INSERT INTO mazNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","'Ma xe ma ña e Jesús, o säjä c'ua 'naja c'ü je vi 'ñeje cja o̱ ngumü e Jairo, o ẽ xipji e Jairo: ―Nu c'ü rvá ẽcjö, nu c'ü in xunt'i ya ndũ c'ü. Dya cja ni jyodü rí xipji ne xöpüte ra ẽjẽ nu. ");
INSERT INTO mazNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","E Jesús dya tsjapü ngüenda c'o mi mamaji. C'ü o tsja, o xipji c'e bëzo c'ü mi xo'ñi: ―Dya rí sũ'ũ. Extí jñunt'ü in mü'bü c'ü ra bübütjo c'ü in xunt'igue. ");
INSERT INTO mazNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nuc'ua e Jesús o zidyi e Pedro 'ñe e Jacobo 'ñe e Juan c'ü nu cjuarma e Jacobo ro möji angueze. Nguextjo c'o o möji cja o̱ ngumü c'e bëzo c'ü mi xo'ñi cja c'e nitsjimi. Dya jyëzi c'o dyaja ro möji. ");
INSERT INTO mazNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","O zät'äji c'ua cja c'e ngumü. O jñanda e Jesús c'o nte c'o mi cãrã nu, me mi mapjü ma huëpiji c'e añima. ");
INSERT INTO mazNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nuc'ua e Jesús o cjogü a mbo. O mama c'ua o xipjiji: ―¿Jenga me i̱ṉ mapjü gui huëpiji ne xunt'i? Dya tũ nu, ĩjĩtjo. ");
INSERT INTO mazNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nuc'ua c'o nte o ndenbetjoji e Jesús va tsjapüji burla. Nuc'ua e Jesús, c'ü o tsja, o pjongü a tji c'o nte. Cjanu o tsjocü c'ü nu papá 'ñe c'ü nu mamá c'e xunt'i, cja na 'ñe c'o jñi discípulo c'o mi dyoji e Jesús. Nuc'o, 'ñe e Jesús o cjogüji a mbo nu ja ma o'o c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nuc'ua e Jesús o pënchp'i o̱ dyë c'e xunt'i, o xipji: ―Talita, cumi, o 'ñembe. C'o jña c'o, ne ra mama: Nu'tsc'e xunt'i, rí xi'ts'i, ñanga. ");
INSERT INTO mazNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","O nanga c'ua c'e xunt'i, o nzhodü c'ua. Ya mi pë's'i doce cjë'ë c'e xunt'i. Me co zũ c'ua c'o mi cãrã nu. Dya mi pãrãji pje ro nguijñiji. ");
INSERT INTO mazNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nuc'ua o xipji e Jesús anguezeji c'ü dya cjó ro xipjiji c'ü vi jñandaji. Cjanu o mama ro unüji pje ro zi c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Cjanu o mbedye c'ua nu e Jesús, o ma nu ja mi menzumü. O möji c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nuc'ua c'e pa c'ü mi söyaji, o mbürü o xöpü yo nte a mbo cja c'e nitsjimi. Na puncjü nte c'o mi ärä, me mi önütsjëji mi mamaji: ―¿Cjó jíchi ne bëzo? ¿Ja va mbãrã nu, 'ñe ja ga tsja c'o me na nojo c'o nunca rí ärägöji? ");
INSERT INTO mazNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Cjo dya nguejnu e yaxü nu, o̱ t'i e María? ¿Cjo dya ngue nu cjuarma e Jacobo 'ñe e José 'ñe e Judas 'ñe e Simón? ¿Cjo dya xo bübü c'o o̱ cjũ cja ne jñiñi va?, eñeji. Nguec'ua ma ünbüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","E Jesús o xipji c'ua anguezeji: ―'Na profeta nde respetaoji nu ja dya ri menzumü y ätäji. Pero nu ja ri menzumü, dya respetaoji c'ü. Ni xo ri ngue c'o o̱ dyoji, ni ri ngue c'o ri cãrã o̱ ngumü, dya xo respetaoji c'ü, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E Jesús dya sö ro tsja c'o na nojo cja c'e jñiñi. Nguextjo o 'ñe's'e o̱ dyë ja nzi c'o mi sö'dyë. O jocüji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Me mi cjijñi e Jesús na ngueje dya mi ejmeji angueze. Nuc'ua e Jesús o ma cja c'o ts'ijñiñi c'o bëxtjo mi järä, o ma xöpü c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nuc'ua e Jesús o ma't'ü c'o doce o̱ discípulo ro ẽjẽji cja o̱ jmi. Cjanu o ndäjäji c'ua nde yeje nde yeje ro ma zopjüji c'o nte. Xo o unüji c'ü ja rvá sö ro pjongüji o demonio cja o̱ mü'bü yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","O xipjiji, dya pje ro ndunüji c'o rví jyodüji cja 'ñiji. Nguextjo 'na ch'äjä c'ü ro jñünü nzi 'najaji. Dya ro ndunüji xëdyi ne ri ngueje merio. Dya xo ro nganaji mape. ");
INSERT INTO mazNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nguextjo o tjĩza ro ndin'ch'iji. Dya xo ro jyänsp'ä o̱ bituji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Xo o mama e Jesús o xipjiji: ―Cja ngumü c'ua ja rí sät'äji, je rí oxüji nu hasta 'ma cja rí ñe rí pedyeji, dya rí pötqueji ngumü rgui oxqueji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Ma rí sätc'eji cja 'na jñiñi, 'ma dya ra säc'eji, 'ma dya ra dyä'tc'äji c'o rí xipjiji, rí pedyeji 'ma nu. Rí jyä'bäji o jõmü c'o ya rguí jyäs'ä in cuaji, ngue c'ua ra unü ngüenda c'o menzumü nu, que vi tsjaji na s'o, dya säc'eji. Na cjuana rí xi'tsc'öji, nu pa c'ü ra tjün ngüenda, xenda ra sufrido c'o cãrã c'e jñiñi c'ü, que na ngueje ra sufrido c'o mi cãrã a Sodoma, 'ñe a Gomorra c'o o chjotü Mizhocjimi mi jinguã na ngueje c'ü me ma s'oji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nuc'ua c'o discípulo o möji c'ua. O ma zopjüji c'o nte. Mi xipjiji c'ü mi jyodü ro nzhogü o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mi pjongüji na puncjü o demonio cja o̱ mü'bü c'o nte. Xo mi cosp'üji aceite na puncjü c'o mi sö'dyë, y o jocüji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","E Herodes c'ü mi manda a Galilea, o dyärä texe c'o na nojo c'o mi cja e Jesús, na ngueje texetjo me mi mama c'o nte c'o. O mama c'ua e Herodes: ―E Juan c'ü mi jichi yo nte cja ndeje, ya tetjo, ya bübütjo na yeje. Nguec'ua na zëzhi angueze ga tsja'a na puncjü c'o na nojo, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bübü c'o mi mama: ―C'ü cja yo me na nojo, ngueje c'e profeta Elías c'ü ya ẽjẽ na yeje. Dyaja c'o mi mama: ―Ngueje 'naja profeta c'ü chjëntjovi nza cja c'o profeta c'o mi cãrã mi jinguã. ");
INSERT INTO mazNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero e Herodes 'ma o dyärä o mama: ―C'ü cja'a yo, ngueje e Juan c'ü ró mandagö o jñüpcüji o̱ ñi. Ya te'etjo c'ü, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ngue e Herodes c'ü vi manda o ma zürüji e Juan; cjanu o ngot'üji c'ua a pjörü. O tsja a cjanu e Herodes na ngueje, 'ma xe mi bübütjo e Juan, e Herodes vi chjüntüvi c'ü nu bëpe c'ü mi chjũ Herodías. Nu c'e ndixũ mi ngue o̱ su e Felipe c'ü nu cjuarma e Herodes. ");
INSERT INTO mazNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nguec'ua o mama e Juan o xipji e Herodes: ―Dya sö rí 'ñejegue nu su nin cjuarma, embe. ");
INSERT INTO mazNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nuc'ua e Herodías me mi ünmbü e Juan. Me mi ne ro mbö't'ü, pero dya mi sö. ");
INSERT INTO mazNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Na ngueje e Herodes mi sũ e Juan, na ngueje mi pãrã mi ngueje 'naja bëzo c'ü mi cja c'ua ja nzi ga ne Mizhocjimi. Nguec'ua e Herodes dya mi jëzi cjó pje ro tsjapü e Juan. Me mi mäjä e Herodes ma dyärä c'o mi mama e Juan, pero dya go creo na ngueje mi yembeñe. ");
INSERT INTO mazNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","O ẽ c'ua 'na nu pa'a, o chöt'ü e Herodías ja rvá mbö't'ü e Juan. C'e pa c'ü, vi säs'ä o̱ cjë e Herodes. O tsja mbaxua e Herodes. O zojnü c'o mi menzumü a Galilea c'o pje mi pjëzhi 'ñe c'o jmu 'ñe c'o comandante. ");
INSERT INTO mazNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nuc'ua c'ü o̱ xunt'i e Herodías o ẽ neme a jmi nu c'o mi cãrã cja c'e mbaxua. Me go mäjä c'ua e Herodes 'ñe c'o mi cãrã nu. Nuc'ua e Herodes c'ü mi rey o xipji c'e xunt'i: ―Dyötcü texe c'ü rí ñe, nde rá da'c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Xo o mama: ―C'ua ga mbãrã Cjimi 'ma pje rí dyötcü, zö ri ngue nde'e c'o rí mandagö, nutscö rá da'c'ü, eñe e Herodes. ");
INSERT INTO mazNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","O mbedye c'ua c'e xunt'i, o ma xipji c'ü nu mamá: ―Xitsi, ¿pje rá ötü e Herodes? O ndünrü c'ua c'ü nu mamá o xipji: ―Dyötpü o̱ ñi e Juan c'ü mi jichi cja ndeje yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nuc'ua nzi va cjogü c'e xunt'i nu ja mi bübü c'e rey Herodes, o xipji: ―Rí negö extí dyacü o̱ ñi e Juan c'ü mi jichi yo nte, jñüncü cja 'na tramojmü, eñe c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Me co nguijñi c'ua c'e rey Herodes. Pero jo ni mbeñe c'ü vi nädä Cjimi, 'ñe c'ü ya vi dyärä c'o nte c'o ma cã'ã nu; nguec'ua dya o ne ro xipji c'e xunt'i c'ü dya ro unü. ");
INSERT INTO mazNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","C'e rey jo ndäjä c'ua 'na xondaro c'ü ro ma jñüpcü o̱ ñi e Juan. O ma c'ua c'e xondaro, o ma jñüpcü o̱ ñi e Juan nu cja c'e pjörü. ");
INSERT INTO mazNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Cjanu o jün c'ua cja 'na tramojmü, cjanu o unü c'e xunt'i. Cjanu o ma c'ua c'e xunt'i o ma unü c'ü nu nana. ");
INSERT INTO mazNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nuc'ua c'o o̱ discípulo e Juan, 'ma o dyärä mi mamaji c'ü vi bö't'ü e Juan, o möji o ma nduns'üji o̱ cuerpo. Cjanu o ma dyögüji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nuc'ua c'o discípulo c'o vi ndäjä e Jesús o nzhogüji nu ja mi bübü angueze, o xipjiji e Jesús texe c'o vi tsjaji 'ñe c'o vi xöpüji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma puncjü nte c'o mi ma mi 'ñeje, nguec'ua e Jesús 'ñe c'o o̱ discípulo dya mi sö ro ziji xëdyi. Nguec'ua o mama e Jesús o xipji c'o o̱ discípulo: ―Möjö nu ja dya cjó ndeñe. Rá cãrãtsjëji nu ngue c'ua rá söyaji 'na ndajme, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","O mötsjëji c'ua cja 'naja bü o zät'äji nu ja dya mi cãrã o nte. ");
INSERT INTO mazNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Na puncjü nte c'o o jñanda 'ma o möji. O mbãrãji mi ngueje e Jesús 'ñe c'o o̱ discípulo. Nguec'ua c'o nte o mbedyeji cja c'o jñiñi o nzhodütjoji va möji. Ot'ü o zät'ä c'o nte nu ja ro zät'ä e Jesús 'ñe c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","'Ma o mbes'e e Jesús cja c'e bü, o jñanda ya mi cãrã na puncjü nte. Mi chjëntjoji nza cja o ndënchjürü 'ma dya cjó pjörü. E Jesús me mi juentse c'o nte. O mbürü o xöpüji c'ua, o xipjiji na puncjü jña. ");
INSERT INTO mazNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nuc'ua 'ma ya o nzhä'ä, o ẽjẽ c'o o̱ discípulo e Jesús cja o̱ jmi angueze, o xipjiji: ―Ya nzhä'ä. Nu va rí cãrãji, ndajyadü va. ");
INSERT INTO mazNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xipji yo nte ra möji cja yo jñiñi yo bëxtjo, 'ñe a ma a ñünü c'ua ja cãrã o nte, ngue c'ua ra ndõmüji pje ra ziji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji rí unügueji pje ra ziji. Anguezeji o ndünrüji o mamaji: ―¿Cjo i̱ṉ ne rá ma tõmüjme ye mil mbëxo o tjõmëch'i c'ü rá unüjme c'ü ra ziji? ");
INSERT INTO mazNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","O ndünrü c'ua e Jesús, o dyönüji: ―¿Ja nzi tjõmëch'i i̱ṉ jünji? Ma ñuji. O ma nuji c'ua. Cjanu o ẽji c'ua, o mamaji: ―Rí jünjme tsi'ch'a tjõmëch'i cja na yeje jmõ'õ. ");
INSERT INTO mazNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","O mama c'ua e Jesús o xipji c'o o̱ discípulo: ―Xipjiji yo nte ra mimiji cja o t'ëbi. Nde ra jyadüji rgá mimiji, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nuc'ua c'o nte o mimiji. O xõgüji, bübü c'o nde mi ciento va mimiji. Bübü c'o nde mi cincuenta va mimiji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nuc'ua e Jesús o jñü c'o tsi'ch'a tjõmëch'i 'ñe c'o yeje jmõ. Cjanu o nä's'ä c'ua a jens'e va unü na pöjö Mizhocjimi. Cjanu o xëdyi c'ua c'o tjõmëch'i. Cjanu o unü c'o o̱ discípulo ngue c'ua ro unüji c'o nte. Xo o xënmbiji texeji c'o yeje jmõ'õ. ");
INSERT INTO mazNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","O ziji texeji o nijmiji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nuc'ua c'o discípulo o nguis'iji c'ua c'o tjõmëch'i 'ñe c'o jmõ c'o o mboncjütjo. O nizhitjo doce bos'i. ");
INSERT INTO mazNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nu c'o bëzo c'o o zi c'o tjõmëch'i 'ñe c'o jmõ mi sö tsi'ch'a mil. ");
INSERT INTO mazNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nuc'ua e Jesús o xänbä c'o o̱ discípulo ro dat'üji cja c'e bü'ü, ro möji a Betsaida cja c'ü 'nanguarü c'e tazapjü. Nuc'ua 'ma ya mi ma c'o discípulo, e Jesús o xipji c'o nte ro möji o̱ ngumüji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nuc'ua 'ma ya vi ma c'o nte, o ma e Jesús cja 'na t'eje, o ma dyötü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nuc'ua 'ma ya vi xõmü, nu c'e bü'ü ya mi pa a nde cja c'e tazapjü. Pero e Jesús mi 'natsjë a ñünü cja c'e ndeje. ");
INSERT INTO mazNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","O jñanda e Jesús dya mi sö c'o o̱ discípulo ro ndütüji c'e bü na ngueje c'e ndajma mi 'ñeje nu ja mi möji. Nuc'ua 'ma ya ma 'ñetsajõmü, o ma e Jesús mi nzhodü a xes'e cja c'e ndeje; mi ma nu ja ma cã'ã c'o o̱ discípulo cja c'e bü'ü. Mi ne ro cjogütjo e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Nuc'ua c'o o̱ discípulo, 'ma o jñandaji ma nzhodü e Jesús a xes'e cja c'e ndeje, mi cjijñiji mi ngueje 'na piche. Me co zũji texeji. O mapjüji o mamaji: ―Chjã, 'na piche nu va ẽ nu, eñeji. Nuc'ua e Jesús o zopjüji o xipjiji: ―Nguezgö. Zëchi in mü'büji, dya rí sũgueji. ");
INSERT INTO mazNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","O dat'ü c'ua e Jesús cja c'e bü nu ja ma cã'ã c'o o̱ discípulo. O söya c'ua c'e ndajma. C'o discípulo me mi sũji me mi dyönütsjëji ja va zädä c'ü o söya c'e ndajma. ");
INSERT INTO mazNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Na ngueje dya mi pãrãji pje mi ne ro mama 'ma o tsjapü e Jesús o puncjü c'o tjõmëch'i. Ma me o̱ mü'büji, dya mi sö ro nguijñiji pje mi ne ro mama c'o na nojo c'o mi cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","O zät'äji c'ua cja 'nanguarü c'e zapjü cja c'e xoñijõmü c'ü xiji Genesaret. O ndün't'üji na jo c'e bü'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","'Ma o mbes'eji cja c'e bü'ü, c'o nte c'o mi cãrã nu, exo mbãrãji mi ngue e Jesús c'ü vi säjä. ");
INSERT INTO mazNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","O ma cöxteji texe cja c'e jñiñi. Cjanu o mbürü o sinpiji e Jesús c'o mi sö'dyë co texe c'o ma os'üji. O sinpiji nu c'ua ja mi äräji mi bübü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Texe c'ua ja mi sät'ä e Jesús, cja o ts'ijñiñi 'ñe cja o ndajñiñi 'ñe cja o ngumü c'o mi järätsjë cja batjü, mi emeji nu c'o mi sö'dyë cja o 'ñiji. C'o nte o dyötüji e Jesús c'ü ro ndötpüji zö ri nguextjo o̱ fleco c'ü o̱ bitu angueze. Texe c'o o ndötpü, o ndis'i c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nuc'ua c'o fariseo 'ñe c'o mi xöpü o̱ ley Mizhocjimi, o mbedyeji a Jerusalén o säjäji cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","O jñandaji c'ü dya o xindyë c'o o̱ discípulo e Jesús ante c'ü ro ziji o xëdyi. ");
INSERT INTO mazNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nu c'o fariseo 'ñe c'o dyaja menzumü a Israel mi cjaji c'ua ja nzi ma tsja o̱ tjũrü c'o o̱ mboxtitaji. Nguec'ua dya ra ziji xëdyi 'ma dya ot'ü ra xindyëji. ");
INSERT INTO mazNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","'Ma ra nzhogüji cja chõjmü, cja ra ziji xëdyi 'ma ya ra nguarü ra xindyëji na jo. Na puncjü tjũrü c'o mi sũpüji. Mi xibiji o xalo 'ñe o s'äbä 'ñe o mojmü c'o mi dyavo metal. ");
INSERT INTO mazNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nuc'ua c'o fariseo 'ñe c'o mi xöpü o̱ ley Mizhocjimi o xipjiji e Jesús o mamaji: ―¿Jenga yo in discípulogue, dya sũpüji yo tjũrü yo o zocüzüji c'o mi tataji? Maco dya xindyëji 'ma siji o xëdyi. ");
INSERT INTO mazNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji i̱ṉ cjapqueji c'ü me na jotsc'eji, pero dya cjuana. Na cjuana c'ü o mama e Isaías c'ü ja ga cjatsc'eji. O mama a cjava va pätpä Mizhocjimi: Nujyo nte yo, sũcö yo, pero nguextjo co o̱ neji. O̱ mü'büji, na jẽ jyadü co nuzgö. ");
INSERT INTO mazNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bë ga zũcö yo. Jizhiji yo o̱ tjũrü o nte, cjapüji c'ü ri ngueje o̱ jña Mizhocjimi yo jizhiji, eñe e Isaías. ");
INSERT INTO mazNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Dya i̱ṉ cjaji c'ü manda Mizhocjimi. Ngueje c'o o̱ tjũrü yo nte c'o i̱ṉ cjaji. ");
INSERT INTO mazNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Xo o xipjiji: ―I̱ṉ cjijñiji na jo c'ü i̱ṉ cjaji. Dya i̱ṉ cjapüji ngüenda c'ü manda Mizhocjimi, ngue c'ua gui tsjatsjëji in chjũrüji. ");
INSERT INTO mazNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","O mama a cjava e Moisés: “S'iyaji nin tataji, 'ñe nin nanaji. C'ü ra zadü nu tata o nu nana, ra mbö't'üji c'ü”, eñe e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero nu'tsc'eji i̱ṉ mangueji 'ma pje ni jyodü c'o nu tata 'naja nte, sö ra mama c'e nte ra xipji c'o nu tata: “Dya sö rá pjöxc'üvi. Ya ró mama rá unügö Mizhocjimi texe c'o ro sö ro da'c'üvi”, ra 'ñembevi. ");
INSERT INTO mazNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nguec'ua dya cja i̱ṉ jëziji pje xe ra unü c'ü nu tata 'ñe c'ü nu nana. ");
INSERT INTO mazNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A cjanu i̱ṉ cjapüji c'ü dya ni muvi c'ü mama Mizhocjimi, na ngueje i̱ṉ jizhiji yo o̱ tjũrü c'o nin mboxtitaji. Na puncjü c'o i̱ṉ cjaji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nuc'ua e Jesús o xipji na yeje c'o nte: ―Chëzhiji a 'ñecjua. Dyätcäji i̱ṉ texeji, ngue c'ua rí pãrãji ja ga cja'a. ");
INSERT INTO mazNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dya ngueje o jñõnü c'o ra zi 'na nte c'ü ra tsjapü ra tsja c'o na s'o. C'ü ra tsjapü ra tsja na s'o, ngue c'o na s'o c'o ra nguijñi a mbo o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nu'tsc'eji bübü in tsõji, rí dyäräji yo jña yo. ");
INSERT INTO mazNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nuc'ua e Jesús o xõgü cja c'o nte, o cjogü a mbo c'e ngumü. Nuc'ua c'o o̱ discípulo e Jesús o dyönüji pje mi ne ro mama c'o jña c'o cja vi mama angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","O ndünrü c'ua e Jesús o mama: ―¿Cjo xo 'ñetsc'eji xo bë'tsc'eji rí pãrãgueji ja cja c'o jña c'o cja ró mangö? O jñõnü c'o si 'naja nte, dya s'onbü o̱ mü'bü, na ngueje je sät'ä cja o̱ pjeme, y je nde ni mbedye a ndü'bü c'o. A cjanu o mama e Jesús c'ü nde na jo texe o jñõnü c'o pje nde si yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Xe o ña e Jesús o mama: ―Nu c'o bübü cja o̱ mü'bü 'na nte ngue c'o ni s'onbü c'e nte c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Na ngueje je ngueje cja o̱ mü'bü yo nte, nu ja ni 'ñeje c'o pjeñe c'o na s'o, nguec'ua ga tsãji o ndixũ, 'ñe yo ndixũ tsãji o bëzo, 'ñe cjaji a cjanu c'o pje nde na s'o, 'ñe pje c'o põnüji, 'ñe pö't'üteji, 'ñe nepeji c'o pë's'i yo nu minteji, 'ñe nuji na ü, 'ñe ojnüteji, 'ñe cjaji texe c'o va ẽjẽ o̱ pjeñeji, dya c'a's'üji, 'ñe envidiaji, 'ñe santeji, 'ñe cjapütsjëji na nojo, 'ñe dya pãrãji pje na mbëjë c'o na jo. ");
INSERT INTO mazNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Texe yo na s'o nguejyo ni s'odü o̱ mü'bü 'naja nte, na ngueje je ni 'ñeje cja o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nuc'ua o mbedye nu e Jesús, o ma cja c'o jñiñi a Tiro 'ñe a Sidón. O cjogü a mbo cja 'na ngumü. Mi ne c'ü dya cjó ro mbãrã cjo mi bübü nu; pero o mbãrãji. ");
INSERT INTO mazNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","'Naja ndixũ o dyärä mi mamaji mi bübü e Jesús. C'ü o̱ ts'ixunt'i c'e ndixũ mi bübü demonio cja o̱ mü'bü. Nuc'ua c'e ndixũ o ma nu ja mi bübü e Jesús; o ndüñijõmü cja o̱ jmi. ");
INSERT INTO mazNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","C'e ndixũ je mi menzumü a Fenicia c'ü tsja a Siria. Dya mi menzumü cja c'o mi Israel. C'e ndixũ o dyötü e Jesús ro pjongü c'e demonio cja c'ü nu ts'ixunt'i. ");
INSERT INTO mazNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","O ndünrü c'ua e Jesús o xipji: ―Ot'ü ra zi'i yo t'i; na ngueje dya jo ra jñünbüji o̱ xëdyi yo t'i, c'ü ra panbaji o dyo'o. ");
INSERT INTO mazNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","O ndünrü c'ua c'e ndixũ o xipji: ―Jãgã, na cjuana c'ü i̱ṉ mangue, ín Jmuts'ügö. Pero zö jyëntsquijme dyo'o c'o in menzumügueji a Israel, i̱ṉ pãrãgue ja ga cja yo dyo'o, si'iji c'o ngünxëdyi c'o jäbä cja mexa, c'o jä'bä c'o ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","O ndünrü c'ua e Jesús o xipji: ―Na jo c'ua ja gui mangue. Nguec'ua sö rí nzhogü cja in nzungue. C'e demonio ya mbedye cja in xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","O ma c'ua c'e ndixũ, o zät'ä o̱ ngumü. O nu'u ya vi mbedye c'e demonio cja c'e xunt'i, ya mi söya c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nuc'ua e Jesús o mbedye na yeje cja c'o jñiñi c'o mi järä a Tiro, o cjogü cja c'o jñiñi c'o mi järä a Sidón 'ñe a Decápolis. O zät'ä cja c'e zapjü a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","O sinpiji c'ua 'naja bëzo c'ü mi ngogõ, xo mi c'üjne c'e bëzo. O dyötüji e Jesús ro 'ñe's'e o̱ dyë cja c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","E Jesús o xõcü c'ua c'e bëzo c'ü mi ngogõ. O c'uã't'ã c'ua o̱ ñidyë cja o̱ ngõ'õ. Cjanu o zos'ü o̱ ñidyë, o ndötpü c'ua o̱ c'ijñi c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","O nä's'ä c'ua a jens'e e Jesús. O yeya, o mama c'ua: ―Efata, eñe. C'e jña ne ra mama: “Xogü.” ");
INSERT INTO mazNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ya o dyärä c'ua c'e bëzo. Xo o jogü c'ua o̱ c'ijñi, o ña c'ua na jo. ");
INSERT INTO mazNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","E Jesús o manda c'ua c'ü dya cjó ro ma xipjiji c'ü vi tsja angueze. Pero 'ma o xipjiji dya ro mamaji, xenda mi mamaji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Me mi sũ c'ua c'o nte, mi mamaji: ―Me na jo texe yo cja'a ne bëzo nu. Cjapü ra dyärä yo ngogõ, 'ñejyo ngone cjapü ra ña'a. ");
INSERT INTO mazNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Dya mezhe c'ua, o jmurü na yeje na puncjü o nte. Mi ojtjo pje ro ziji. Nuc'ua e Jesús o ma't'ü c'o o̱ discípulo c'ü je ro chëzhiji cja o̱ jmi, cjanu o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Rí juentscö yo nte, na ngueje ya pa jñipa c'ü ya ró cãrãgöji va, y dya cja jünji pje ra ziji. ");
INSERT INTO mazNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","'Ma rá täjäji ra möji o̱ ngumüji c'ü dya ra ziji o xëdyi, ra tõgüji cja 'ñiji. Cãrã yo vi 'ñeje na jẽ. ");
INSERT INTO mazNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","O ndünrü c'ua c'o o̱ discípulo o xipjiji e Jesús: ―¿Ja ri bübü va o tjõmëch'i c'ü rguí nijmi yo nte yo na puncjü? Na ngueje rí cãrãgöji va cja ne ndajyadü. ");
INSERT INTO mazNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","O ndünrü c'ua e Jesús o dyönüji: ―¿Ja nzi tjõmëch'i i̱ṉ jüngueji? Anguezeji o mamaji: ―Yenchotjo yo rí jünjme. ");
INSERT INTO mazNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nuc'ua e Jesús o manda c'ua c'o nte ro mimiji a jõmü. Cjanu o jñü c'ua c'o yencho tjõmëch'i. Cjanu o unü na pöjö Mizhocjimi. Cjanu o xëdyi c'ua c'o tjõmëch'i, cjanu o unü c'o o̱ discípulo. Nuc'ua c'o o̱ discípulo o unüji c'ua c'o nte'e. ");
INSERT INTO mazNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Xo mi jünji ja nzi ts'ijmõ. E Jesús xo o unü na pöjö Mizhocjimi c'o jmõ, cjanu o xipji c'o o̱ discípulo xo ro unüji c'ua c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","O ziji c'ua; o nijmiji na jo. Nuc'ua o nguis'itjoji c'ua c'o ts'ipëraso c'o vi mboncjütjo. O nizhi yencho bos'i c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nu c'o nte c'o o zi, mi nziyo mil c'o. Nuc'ua e Jesús o xipji c'ua c'o nte ro möji o̱ ngumüji. ");
INSERT INTO mazNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Cjanu o dat'ü c'ua cja c'e bü'ü co c'o o̱ discípulo. O möji c'ua cja c'o jñiñi a ma a Dalmanuta. ");
INSERT INTO mazNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","'Ma ya vi zät'äji nu, o säjä c'ua c'o fariseo. O ẽ zöji o jña e Jesús. O dyötüji c'ü pje ro jñandaji c'ü rví 'ñeje a jens'e, ngue c'ua ro mbãrãji pje mi pjëzhi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","O yeya e Jesús o xipjiji: ―Yo nte yo cãrã yo cjë dya, ¿jenga örüji pje ra jñandaji ngue c'ua ra mbãrãji pje pjëtscö? Na cjuana c'ü rí mangö, dya ra ch'unüji c'ü ra jñandaji. ");
INSERT INTO mazNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","O ma c'ua e Jesús o zogütjo c'o fariseo. O dat'ü cja c'e bü, o möji c'o o̱ discípulo c'ü 'na lado cja c'e zapjü. ");
INSERT INTO mazNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","C'o o̱ discípulo e Jesús, 'natjo tjõmëch'i c'ü vi jñünüji 'ma o dat'üji cja c'e bü, na ngueje vi jyombeñeji. ");
INSERT INTO mazNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nuc'ua e Jesús o xipjiji: ―Pjötpüji ngüenda c'o o̱ levadura c'o fariseo 'ñe c'o o̱ levadura e Herodes. ");
INSERT INTO mazNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","C'o discípulo mi pötma mamaji: ―Xitscöji a cjanu ne Jesús, na ngueje c'ü dya ró jüngöji o tjõmëch'i. ");
INSERT INTO mazNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mi pãrã e Jesús c'ü mi cjijñiji, nguec'ua o xipjiji c'ua: ―¿Jenga i̱ṉ pötqui mamaji na ngue c'ü dya i̱ jñüji o tjõmëch'i? ¿Cjo dya be i̱ṉ pãrãgueji c'ü sö rá da'c'eji c'ü rí si'iji? ¿Cjo ya me na me in mü'bügueji? ");
INSERT INTO mazNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Cjo dya i̱ṉ jandagueji co in chöji? Bübü in tsõji. ¿Cjo dya pje i̱ṉ äräji? ¿Cjo dya i̱ṉ mbeñeji? ");
INSERT INTO mazNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nu 'ma ró xënmbi c'o tsi'ch'a tjõmëch'i, o nijmi c'o tsi'ch'a mil o bëzo. ¿Ja nzi bos'i o ts'ipëraso c'o i̱ tsis'iji? Anguezeji o ndünrüji o xipjiji: ―O nizhi doce c'o bos'i c'o o mboncjü. ");
INSERT INTO mazNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Xe o ña e Jesús o xipjiji: ―Nu 'ma ró xënmbi c'o yencho tjõmëch'i, o nijmi c'o nziyo mil o bëzo. ¿Ja nzi o bos'i o ts'ipëraso c'o i̱ tsis'iji? Anguezeji o ndünrüji o xipjiji: ―O nizhi yencho c'o bos'i c'o o mboncjü. ");
INSERT INTO mazNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nuc'ua o mama e Jesús o xipjiji: ―¿Cjo dya be i̱ṉ tendioji ja cja c'ü rí xi'ts'igöji? ");
INSERT INTO mazNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nuc'ua o zät'ä e Jesús 'ñe c'o o̱ discípulo a Betsaida. C'o nte o sinpiji 'naja bëzo c'ü mi ndëzhö. Mi ötüji e Jesús ro 'ñe's'e o̱ dyë cja c'e bëzo c'ü mi ndëzhö. ");
INSERT INTO mazNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nuc'ua e Jesús o pënchp'i o̱ dyë, o zidyi a ñünü cja c'e jñiñi. Cjanu o ngosp'ü c'ijñi o̱ ndö'ö. Cjanu o 'ñe's'e c'ua o̱ dyë'ë. O mama c'ua e Jesús: ―Nu'tsc'e, ¿cjo ya i̱ṉ janda? ");
INSERT INTO mazNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","O ndünrü c'ua c'e bëzo o mama: ―Rí jandagö yo bëzo; 'ñetse nza cja za'a. Pero nzhodüji. ");
INSERT INTO mazNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nuc'ua e Jesús o 'ñe's'e na yeje o̱ dyë cja o̱ ndö c'e ndëzhö. O nguinch'i c'ua na jẽ c'e bëzo. O jogü o̱ ndö'ö. Ya ndäcä c'ua na jo texe. ");
INSERT INTO mazNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","E Jesús o ndäjä c'ua cja o̱ ngumü. O mama e Jesús o xipji c'e bëzo: ―Dya rí sät'ä cja c'e jñiñi. Dya cjó rí ma xipji nu, c'o ró cjagö. ");
INSERT INTO mazNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nuc'ua e Jesús 'ñe c'o o̱ discípulo o möji cja c'o jñiñi c'o tsja a Cesarea de Filipo. 'Ma mi pöji cja 'ñiji o tsja t'önü e Jesús o xipji c'o o̱ discípulo: ―¿Pje mama yo nte pjëtsigö? ");
INSERT INTO mazNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","O ndünrü c'ua anguezeji: ―Bübü c'o mama ngue'tsc'e e Juan c'ü mi jichi cja ndeje yo nte. Dyaja c'o mama ngue'tsc'e e Elías. Dyaja c'o mama ngue'tsc'e 'naja c'o profeta c'o mi cãrã mi jinguã. ");
INSERT INTO mazNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","O mama c'ua e Jesús o dyönüji: ―Natsc'eji, ¿pje i̱ṉ mangueji? ¿Pje pjëtsigö? O ndünrü c'ua e Pedro o xipji: ―Ngue'tsc'e e Cristo o 'ñempc'egue Mizhocjimi rí mandague. ");
INSERT INTO mazNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nuc'ua e Jesús o xipji c'ua c'o o̱ discípulo c'ü dya cjó ro xipjiji c'ü mi ngue Cristo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nuc'ua o mbürü e Jesús o xipji c'o o̱ discípulo c'ü mi jyodü ro zädä. O xipjiji: ―Nutscö rvá ẽcjö cja Mizhocjimi, ni jyodü me rá sufridogö na puncjü. Ra jñüncü ngüenda c'o tita c'o pje pjëzhi, 'ñe c'o ndamböcjimi, 'ñe c'o xöpü o̱ ley Mizhocjimi, ra mamaji c'ü na s'o c'ü rí cjagö. Nuzgö ra mbötcügöji. Nuc'ua c'ü na jñi nu pa, rá tegö rá bübütjo na yeje. ");
INSERT INTO mazNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O xipjiji na jo'o yo jña'a yo. Nuc'ua e Pedro o xõcü 'na lado e Jesús, y o mbürü o hüench'i. ");
INSERT INTO mazNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","O ñezhe c'ua e Jesús, o jñanda c'o dyaja o̱ discípulo. O mama c'ua e Jesús o huënch'i e Pedro: ―C'ueñe cja ín jmigö, Satanás. Nu c'ü i̱ṉ cjijñigue, dya pje ngue c'ü cjijñi Mizhocjimi; ngueje c'ü je cjijñi yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nuc'ua e Jesús o ma't'ü c'ua c'o nte 'ñe c'o o̱ discípulo; o xipjiji: ―'Ma cjó c'o ne ra ndünt'ü ín xütjügö, dya ra tsja c'ua ja nzi ga netsjë. Ra bübü dispuesto ra sufrido o ra ndũ. Y ra ndenngue co nutscö. ");
INSERT INTO mazNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Na ngueje nu c'o dya bübü dispuesto ra sufrido o ra ndũji, dya ra chöt'üji c'ü rguí bübütjoji. Pero nu c'o bübü dispuesto ra bö't'ü na ngue c'ü ni 'ñejmezügöji 'ñe c'ü ni xipjiji yo nte xo ra 'ñejmezüji, ra chöt'üji c'ü rguí bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nu 'ma ro tsja 'na nte ro tsjapü o̱ cjaja texe yo bübü va cja ne xoñijõmü, pero 'ma ro jyëzi Mizhocjimi c'e nte, ¿pje rví muvi? ");
INSERT INTO mazNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Na ngueje, 'ma ya jyëzi Mizhocjimi 'na nte, dya ra sö c'e nte pje ra unü Mizhocjimi ngue c'ua ra ẽ bübü Mizhocjimi co angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yo pa dya yo, ya mbëtspiji o̱ jña Mizhocjimi; me cjaji na s'o. Nu c'ü ra tseje rgá 'ñejmezü 'ñe ín jñagö, nuzgö dya rá recibido angueze 'ma rá ẽcjö na yeje cja Mizhocjimi. Rá ẽcjö na yeje; c'ua ja ga cja me na zö c'ü mi Tatagö, je rga cjazgö nu 'ma rá ẽcjö. Rá ẽcjö co o̱ anxe Mizhocjimi; me rrã zözgöjme. ");
INSERT INTO mazNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Xo o mama e Jesús: ―Na cjuana rí xi'tsc'öji, bübü nu yo cãrã va, yo dya ra ndũ'ũ hasta 'ma cja ra nu'uji ja ga cja 'ma ra manda Mizhocjimi co texe o̱ poder. ");
INSERT INTO mazNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","'Ma ya vi cjogü 'ñanto pa, e Jesús o zidyi e Pedro 'ñe e Jacobo 'ñe e Juan. O mötsjëji cja 'na t'eje c'ü me ma ndã'ã. 'Ma mi jandaji, 'nangua o pötü c'ua o̱ jmi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Xo pötü c'ua ja ma 'ñetse o̱ bitu, me mi juës'i, me ma t'öxü nza cja xitsji. Ni ri 'naja mbedye cja ne xoñijõmü c'ü ra tsjapü me rrã t'öxü a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jo ni 'ñetse c'ua e Elías 'ñe e Moisés, mi ñaji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nuc'ua o ña c'ua e Pedro o xipji e Jesús: ―Xöpüte, me na jo rí cãrãgöji va. Rá ät'äjme jñi ts'ingumü co dyëza. 'Naja c'ü rá ä'tc'öjme, 'naja c'ü rá ä'tp'äjme e Moisés, 'naja c'ü rá ä'tp'äjme e Elías, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","O mama a cjanu e Pedro na ngueje me mi sũ angueze 'ñe c'o yeje c'o mi dyoji. Nguec'ua dya mi pãrã pje ro mama. ");
INSERT INTO mazNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","O säjä c'ua 'na ngõmü c'ü o ẽ ngobü anguezeji. O dyäräji c'ua 'na jña cja c'e ngõmü c'ü mi mama a cjava: ―Nujnu ngue ín Ch'igö nu me rí s'iya. Dyätäji angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nuc'ua 'ma o ndäcä c'o discípulo, dya cja jñandaji e Moisés 'ñe e Elías; ya mi nguextjo e Jesús c'ü mi bübü. ");
INSERT INTO mazNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nuc'ua 'ma ya ma sjöbüji cja c'e t'eje, cjanu o mama c'ua e Jesús o xipjiji: ―Dya cjó rí xipjiji yo cja i̱ jñandaji. Nutscö rvá ẽcjö cja Mizhocjimi. 'Ma rá tũgö, rá tegö na yeje. Cja rí xipjiji 'ma yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nguec'ua mi cjijñitsjëji c'o vi jñandaji. Dya cjó mi xipjiji. Pero mi pötma mamaji pje mi ne ro mama c'ü ro te'e cja c'o añima. ");
INSERT INTO mazNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nuc'ua c'o discípulo o dyönüji e Jesús: ―¿Jenga mama c'o xöpü o̱ ley Mizhocjimi c'ü ni jyodü ot'ü ra ẽjẽ na yeje e Elías, cja rron ẽjẽ e Cristo? ");
INSERT INTO mazNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","O ndünrü c'ua e Jesús o mama: ―Na cjuana c'e jña c'ü mamaji, c'ü ot'ü ra ẽjẽ na yeje e Elías ra ẽ jocü texe. ¿Pje mama cja o̱ jña Mizhocjimi? Mama a cjava c'ü me rá sufridogö, nutscö rvá ẽcjö cja Mizhocjimi. Xo ra tsjacüji c'ü dya pje ni muvizügö. ");
INSERT INTO mazNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nuzgö rí xi'tsc'öji, e Elías ya ẽjẽ na yeje c'ü. O tsjapüji c'ü me mi ne anguezeji, c'ua ja nzi ga t'opjü c'ü ro tsjapüji. ");
INSERT INTO mazNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nuc'ua 'ma o zät'äji nu ja mi cãrã c'o dyaja discípulo, o jñandaji na puncjü nte c'o ya vi jmurü nu. Mi cãrã nu c'o mi xöpü o̱ ley Mizhocjimi. Mi söji jña co c'o discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nuc'ua c'o nte 'ma o jñandaji e Jesús, me co mäjäji. O cjuañiji o ma zenguaji angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nuc'ua e Jesús o dyönüji: ―¿Ja cja c'e jña c'ü i̱ṉ mangueji? ");
INSERT INTO mazNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","O ndünrü c'ua 'naja bëzo c'ü ma dyoji c'o nte, o mama: ―Xöpüte, ró sin'c'igö ín ch'igö na ngueje bübü demonio cja o̱ mü'bü c'ü cjapü ra ngone. ");
INSERT INTO mazNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","C'e demonio texe c'ua ja pënch'i me cjapü ra ñus'ü. Me pjont'ü pjügü a ne'e. Me s'i'ch'i o̱ s'ibi; me zëchi o̱ cuerpo. Ró xipji yo in discípulogue ro pjombgüji c'e demonio; dya sö ra pjongüji, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji i̱ṉ cãrãji yo cjë dya, dya i̱ṉ ejmeji. ¿Jenga dya i̱ṉ creozüji rá pjöxc'üji rí tsjaji c'o na nojo? Maco ya mezhe rí cãrãgöji, ya mezhe rí pë'sc'ö paciencia co nu'tsc'eji. Sinquiji ne t'i'i. ");
INSERT INTO mazNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","O sinpiji c'ua. C'e demonio 'ma o jñanda e Jesús, exo tsjapü o mbi'ch'i c'e t'i. O nügü c'e t'i; mi ñus'ü. Me mi pjont'ü pjügü a ne'e. ");
INSERT INTO mazNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nuc'ua e Jesús o tsja t'önü, o xipji c'ü nu tata c'e t'i'i: ―¿Jinguã ndeze o mbürü c'ü sufrido a cjanu ne t'i? O ndünrü c'ua c'ü nu tata c'e t'i o mama: ―Ndeze 'ma cja mi ts'it'i me sufrido a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","C'e demonio ya na puncjü ga tsjapü ga zo'o cja sivi 'ñe cja ndeje, ngue c'ua ra mbö't'ü. Nu 'ma sö pje rí tsjague, juentsquegöbe, pjöxcügöbe. ");
INSERT INTO mazNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","O ndünrü c'ua e Jesús o xipji: ―I̱ṉ önngü, ¿cjo sö pje rá cjagö? Rí önnc'ügö, nu'tsc'e, ¿cjo ra sö rí 'ñejmegue Mizhocjimi? Nu c'ü ejme Mizhocjimi, Mizhocjimi ra tsja texe c'o ra dyötü. ");
INSERT INTO mazNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Exo mapjü c'ua na jens'e c'ü nu tata c'e t'i, o mama: ―Rí ejmegö Mizhocjimi. Pero bëtsi, nguec'ua rí ö'tc'ügö rí pjöxcü rá ejmegö Mizhocjimi texe c'ua ja nzi ga ne angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nuc'ua 'ma o jñanda e Jesús ma jmurü na puncjü nte, o huënch'i c'ua c'e demonio, o xipji: ―Nu'tsc'e demonio i̱ṉ cjapü ra ngone 'ñe ra ngogõ ne t'i, rí mandats'ü rí pedye cja ne t'i. Y dya cja nzho xe rí tsich'i cja o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nuc'ua c'e demonio o mapjü; o tsjapü me mi mbi'ch'i c'e t'i. Cjanu o mbedye c'ua c'e demonio. Nuc'ua o jändũ c'e t'i. Mi nza cja c'ü ya vi ndũ. Nguec'ua na puncjü nte c'o mi mama: “Ya ndũ'ũ.” ");
INSERT INTO mazNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nuc'ua e Jesús o pënchp'i a dyë'ë, o xos'ü. O böbü c'ua c'e t'i'i. ");
INSERT INTO mazNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nuc'ua e Jesús o cjogü a mbo cja c'e ngumü nu ja mi oxü. C'o o̱ discípulo o xipjitsjëji c'ua: ―¿Jenga dya sö ro pjombgüjme c'e demonio? ");
INSERT INTO mazNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O ndünrü c'ua e Jesús o xipjiji: ―'Na demonio nza cja nu c'ü cja ró pjongü, dya cjó ra sö ra pjongü 'ma dya ra dyötü Mizhocjimi 'ñe ra mbempje. ");
INSERT INTO mazNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nuc'ua o möji a ma a Galilea. E Jesús dya mi ne cjó ro mbãrã ja mi bübü angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Na ngueje mi xöpü c'o o̱ discípulo. O xipjiji: ―Nutscö rvá ẽcjö cja Mizhocjimi, ra nzhögügöji cja yo nte ra mbötcüji. Nuc'ua c'ü na jñi nu pa, rá tetjogö, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Anguezeji, dya mi pãrãji pje mi ne ro mama c'o jña c'o. Mi sũji ro dyönüji ja ma cja c'o jña. ");
INSERT INTO mazNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","E Jesús 'ñe c'o o̱ discípulo o zät'äji a Capernaum. 'Ma ya mi cãrãji cja ngumü, o mama c'ua e Jesús o dyönüji: ―¿Ja cja c'o mi mamagueji 'ma ma ẽji cja 'ñiji? ");
INSERT INTO mazNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","C'o discípulo dya ndünrüji na ngueje vi pötva dyönüji cja 'ñiji cjó ngue nza texeji ro nguejme na nojo. ");
INSERT INTO mazNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nuc'ua o mimi e Jesús, cjanu o ma't'ü c'ua c'o doce discípulo o xipjiji: ―'Ma cjó c'o ne ra nguejme na nojo, ni jyodü dya ra tsjapü na nojo; ra pjöxte, ra mbös'ü texe yo nu minteji. ");
INSERT INTO mazNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nuc'ua e Jesús o ziji c'ua 'na ts'it'i. O 'ñeme c'ua a nde nu ja mi cãrãji. O ndës'i c'ua. Cjanu o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―'Naja nte c'ü s'iya 'naja yo ts'it'i na ngueje c'ü ejmezügö c'e nte, nguetscö s'iyazü. 'Ma cjó c'o s'iyazü, dya nguextjozügö c'ü s'iya, xo s'iya Mizhocjimi c'ü o ndäcjä va cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","O mama c'ua e Juan o xipji e Jesús: ―Xöpüte, ró jandajme 'na bëzo c'ü mi nännc'ägue in chjũ ma pjongü yo demonio. Ró xipjijme c'ü dya ro tsja a cjanu na ngueje, dya rí dyocjöji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","O ndünrü c'ua e Jesús o xipjiji: ―Dya rí ts'a's'üji c'e nte. Na ngueje dya cjó nänngä ín chjũgö ga tsja c'o na nojo, nuc'ua cja rron mama na s'ozügö. ");
INSERT INTO mazNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Na ngueje nu c'ü dya nugüji na ü, ngue ín dyocjöji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na cjuana rí xi'ts'iji, nu c'ü ra dya'c'üji ndeje rí siji na ngueje ín ntets'üji nutscö e Cristo, nuc'ü, Mizhocjimi ra ngõ't'ü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’'Ma cjó c'o ra tsjapü ra tsja na s'o 'naja yo ts'iquë yo ejmezügö, xenda rvá jo ro jyü'tp'üji 'na travacjüjnü o̱ dyizi c'e nte c'ü, cja rron pant'aji c'ua cja trazapjü, que na ngueje c'ü ro tsjapü ro tsja na s'o 'naja c'ü ejmezügö. ");
INSERT INTO mazNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Maco i̱ṉ mamaji ngue in dyëji c'ü cja'c'ü rí tsjaji c'o na s'o, dyocüji 'ma. Xenda na jo rí ma bübütjoji co Mizhocjimi c'ü ri 'natjo in dyëji que na ngueje ri bübü nza yeje in dyëji ri möji a linfiernu cja c'e sivi c'ü dya ra juench'e. ");
INSERT INTO mazNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Cja c'e lugar, dya tũ c'o dyoxü c'o jä'ä cja c'o ya ndũ; 'ñe c'e sivi dya juench'e. ");
INSERT INTO mazNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Maco i̱ṉ mamaji ngue in cuaji c'ü cja'c'ü rí tsjaji c'o na s'o, dyocüji 'ma. Xenda na jo rí ma bübütjoji co Mizhocjimi c'ü ri docuaji que na ngueje ri bübü nza yeje in cuaji, ra pantc'aji cja c'e sivi c'ü dya ra juench'e. ");
INSERT INTO mazNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Cja c'e lugar, dya tũ c'o dyoxü c'o jä'ä cja c'o ya ndũ; 'ñe c'e sivi dya juench'e. ");
INSERT INTO mazNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Maco i̱ṉ mamaji ngue in chöji cja'c'ü rí tsjaji c'o na s'o, jñü'müji 'ma. Xenda na jo rí tsjogüji nu ja manda Mizhocjimi c'ü ri 'natjo in chöji que na ngueje ri bübü nza yeje in chöji, ra pantc'aji cja c'e sivi a linfiernu. ");
INSERT INTO mazNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cja c'e lugar, dya tũ c'o dyoxü c'o jä'ä cja c'o ya ndũ; 'ñe c'e sivi dya juench'e. ");
INSERT INTO mazNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Mi jinguã mi tjüt'üji o animal c'o mi unüji Mizhocjimi; xo mi ü's'üji õ c'o. Texets'üji i̱ṉ chjentjoji c'o animal c'o mi tjüt'üji na ngueje rí tsjogüji na puncjü c'o na s'ëzhi. ");
INSERT INTO mazNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na jo o õ'õ. Pero 'ma rrã 'huë'ë c'o õ'õ, ¿ja xe rgá õxcü 'ma? Nu'tsc'eji ni jyodü rí chjëntjoji c'e õ'õ c'ü na quijmi. Ni jyodü rí pötqui ñe'eji. ");
INSERT INTO mazNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nuc'ua o mbedye c'ua nu, e Jesús. O ma cja c'o jñiñi c'o tsja a Judea. O mbes'e c'ü 'nanguarü c'e ndare a Jordán. Nuc'ua na yeje o jmurü na puncjü nte nu ja mi bübü e Jesús, c'ua ja nzi va jmurüji nu ja ot'ü mi bübü. O xöpüji c'ua ja nzi va xöpü c'o dyaja nte. ");
INSERT INTO mazNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","O säjä c'ua c'o fariseo. Chaque o tsjapüji t'önü e Jesús. C'ü mi 'ñejeji, ngue c'ü ro zöji e Jesús. Mi cjijñiji 'na ro jyopü c'ü ro mama. O dyönüji: ―¿Ja ga mama cja o̱ ley Mizhocjimi, cjo na jo 'na bëzo ra mbëzi nu su'u? ");
INSERT INTO mazNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","O ndünrü c'ua e Jesús o xipjiji: ―¿Pje mama cja yo mandamiento yo o dyopjü e Moisés? ");
INSERT INTO mazNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","O mama c'ua c'o fariseo: ―E Moisés o unü sjëtsi e bëzo ro unü xiscõma c'ü rví mbëzi nu su. ");
INSERT INTO mazNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji me na me in mü'büji, dya i̱ṉ s'iyaji c'o nin suji, nguec'ua o dya'c'eji sjëtsi e Moisés rí pëziji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero 'ma o mbürü o ngãrã yo nte, dya ma cjanu. Na ngueje ndeze 'ma ot'ü, Mizhocjimi o 'ñeme e bëzo 'ñe e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nguec'ua nu yo bëzo ga zogüji nu tata 'ñe nu nana, ga mimivi c'ü nu su. ");
INSERT INTO mazNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","C'o mi yeje ya ri 'natjo o̱ ts'inguevi. Dya cja ri yeje, ya ri 'natjo o̱ ts'inguevi c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nu c'o o tsjapü Mizhocjimi ra 'natjovi, dya ra xõcü e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nuc'ua e Jesús 'ñe c'o o̱ discípulo o cjogüji a mbo cja 'na ngumü. Nuc'ua c'o discípulo o dyönüji ja ma cja c'o cja vi mama. ");
INSERT INTO mazNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","O mama c'ua e Jesús o xipjiji: ―Nu c'ü ra mbëzi nu su, cja rron chjüntüvi c'ü 'naja ndixũ, tsãjã ndixũ 'ma c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nu 'ma ngueje e ndixũ ra mbëzi nu xĩra cja rron chjüntüvi c'ü 'naja bëzo, tsãjã bëzo 'ma c'e ndixũ c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ma ẽjẽ c'o nte ma siji c'o o̱ ts'it'iji cja o̱ jmi e Jesús, ngue c'ua e Jesús ro 'ñe's'e o̱ dyë anguezeji ro dyötpüji Mizhocjimi. Nuc'ua c'o discípulo 'ma o jñandaji c'o, o huënch'iji c'ua c'o ma siji c'o ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pero e Jesús 'ma o jñanda c'ü mi cja c'o o̱ discípulo, o üdü c'ua. O xipjiji: ―Jyëziji yo ts'it'i ra ẽji cja ín jmigö; dya rí ts'a's'üji yo, na ngueje nu c'o va ẽjẽ co nuzgö nza cja yo ts'it'i, ngueje c'o cjapü Mizhocjimi o̱ nte c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na cjuana rí xi'tsc'öji, 'ma cjó c'o dya ra ẽjẽ co nuzgö c'ua ja nzi ga 'ñeje yo ts'it'i, 'ma dya ra unü o̱ mü'bü Mizhocjimi ra dyätä, dya ra sö Mizhocjimi ra tsjapü o̱ nte, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nuc'ua o ndës'i c'ua nzi 'naja c'o ts'it'i. O 'ñe's'e o̱ dyë anguezeji o dyötpüji Mizhocjimi nzi 'naja. ");
INSERT INTO mazNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","'Ma ya mi pedye e Jesús ro ma cja 'ñiji, o cjuañi 'na bëzo o säjä nu ja mi bübü e Jesús. O ndüñijõmü cja o̱ jmi, cjanu o mama c'ua: ―Na jots'ügue, xöpüte. ¿Pje na mbë c'ü rá cjagö ngue c'ua ra ch'acü rá bübütjo co Mizhocjimi para siempre? ");
INSERT INTO mazNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","E Jesús o xipji: ―¿Jenga i̱ṉ xitsi na jozü? Dya cjó bübü c'ü na jo'o; nguextjo Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","I̱ṉ pãrãgue c'o o̱ mandamiento Mizhocjimi c'o o dya'c'üji. Mama a cjava c'o: “Dya rí tsãji ndixũ; yo ndixũ dya ra tsãjãji bëzo. Dya rí pö't'üteji. Dya pje rí põnüji. Dya rí xos'üji bëchjine. Dya cjó rí dyonpüji. Rí respetaoji nin tataji 'ñe nin nanaji.” ");
INSERT INTO mazNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","O ndünrü c'ua c'e bëzo: ―Xöpüte, texe yo, ya nde ró cjagö yo ndeze 'ma cja rmí ts'iquëgö. ");
INSERT INTO mazNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","E Jesús 'ma o jñanda c'e bëzo, o ne'e, cjanu o xipji: ―Nu'tsc'e, xe bëzhi 'naja c'ü rí tsjague. Ma pögue texe c'o i̱ṉ pë's'i, unügue c'o dya pje pë's'i. A cjanu rí pë's'igue a jens'e c'o me ni muvi. Cja rrĩ 'ñecje rí chjünt'ü ín xütjügö. ");
INSERT INTO mazNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nuc'ua 'ma o dyärä c'e bëzo c'o vi mama e Jesús, me co ndumü va ma'a, na ngueje mi pë's'i na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nuc'ua e Jesús o jñanda texe c'o mi cãrã nu, o xipji c'ua c'o o̱ discípulo: ―Nu c'o me pë's'i na puncjü, me na s'ëzhi c'ü ra unü o̱ mü'büji Mizhocjimi ra dyätäji angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","'Ma o dyärä c'o discípulo c'o vi mama e Jesús, o zũji. Pero e Jesús o xipjiji na yeje: ―Nu'tsc'eji ín ch'its'üji, me na s'ëzhi c'ü ra tsjapü o̱ nte Mizhocjimi nu c'o cjijñi me ra mbös'üji c'o pë's'iji. ");
INSERT INTO mazNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","'Naja camello, dya sö ra cjogü cja o̱ xãgö 'na dyepjadü. Je xo ga cjatjonu 'na nte c'ü pë's'i na puncjü, dya sö ra unü o̱ mü'bü Mizhocjimi ra tsjapü o̱ nte. ");
INSERT INTO mazNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nuc'ua anguezeji xenda mi sũji c'ua. O mamaji: ―'Ma a cjanu, ¿cjó ngue c'ü ra sö ra jogü o̱ mü'bü? ");
INSERT INTO mazNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","E Jesús cjanu o jñandaji c'ua, o xipjiji: ―Dya cjó sö yo nte ra jocütsjë o̱ mü'bü; pero Mizhocjimi sö ra jopcü o̱ mü'büji. Na ngueje Mizhocjimi sö ra tsja texe. ");
INSERT INTO mazNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","O mama c'ua e Pedro: ―Nutscöjme ró sogüjme texe c'o mi pë's'ijme ngue c'ua rí tjünt'ügöjme in xütjügue. ");
INSERT INTO mazNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","O ndünrü c'ua e Jesús o mama: ―Cãrã c'o ejmezügö c'o ra zopjü ín jñagö yo nte. Nguec'ua ra zogü o̱ ngumüji, o nu cjuarmaji, o nu cjũji, o nu 'ninzhõmüji, o nu cjũjuëji, o nu tataji 'ñe nu nanaji, o nu t'iji, o o̱ juajmaji. ");
INSERT INTO mazNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","C'o ra tsja a cjanu, ra ch'unüji c'ü rrã puncjü que na ngueje 'naja ciento c'ü mi pë's'iji 'ma ot'ü. Ra ch'unüji o̱ ngumüji, 'ñe nu cjuarmaji, 'ñe nu cjũji, 'ñe nu 'ninzhõmüji, 'ñe nu cjũjuëji, 'ñe nu nanaji, 'ñe nu t'iji, 'ñe o̱ juajmaji. Xo ra nuji na ü; ra tsja yo nte. Xo ra ch'unüji c'ü rguí bübütjoji co Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Je a cjanu, c'o cjapü vi tsjaji c'o me ni muvi, dya rguí muvi a jmi Mizhocjimi c'o. C'o unü ngüenda c'ü dya ni muvi c'ü cjaji, rguí muvi na puncjü a jmi Mizhocjimi c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","E Jesús 'ñe c'o o̱ discípulo mi pöji cja 'ñiji, mi cjins'iji a ma a Jerusalén. Mi ot'ü a xojñi e Jesús. Me mi sũ c'o discípulo 'ñe c'o nte c'o mi tjünt'ü a xütjü. Nuc'ua e Jesús o xõcü c'o doce o̱ discípulo, o ñatsjëji o xipjiji c'ü ro tsjapü c'o nte ro sufre angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","O xipjiji a cjava: ―Ya rrã möjö a ma a Jerusalén nu ja ra nzhögügöji nutscö rvá ẽcjö cja Mizhocjimi. Ra nzhögügöji cja o̱ dyë c'o ndamböcjimi 'ñe c'o xöpü o̱ ley Mizhocjimi, ngue c'ua ra jñüncöji ngüenda c'ü rguí mbötcöji. Ra nzhögügöji c'ua cja o̱ dyë c'o dya menzumü a Israel. ");
INSERT INTO mazNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Me ra tsjacüji burla ra zoxcüji, ra ndaxcöji o chirrio, ra mbötcüji. Nuc'ua c'ü na jñi nu pa, rá tetcjö rá bübütjo na yeje. ");
INSERT INTO mazNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nuc'ua e Jacobo co e Juan, c'o o̱ t'i e Zebedeo, o chëzhivi a jmi e Jesús. O xipjivi: ―Nu'tsc'e, xöpüte, rí negöbe rí tsjacübe 'na favor nu rá ö'tc'übe. ");
INSERT INTO mazNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","O ndünrü c'ua e Jesús o xipjivi: ―¿Pje na mbëjë c'ü i̱ṉ nevi rá cja'c'üvi? ");
INSERT INTO mazNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","O ndünrüvi o xipjivi: ―Dyacübe sjëtsi rá mimigöbe nu ja rí mandague; 'naja cja in jodyë, 'naja cja c'ü 'naja in dyë. ");
INSERT INTO mazNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","O ndünrü c'ua e Jesús o xipji c'o yeje o̱ discípulo: ―Dya i̱ṉ unnc'evi ngüenda c'ü i̱ṉ ötcügövi. Nuzgö rá sufridogö c'o ra tsjacü yo nte; y rá tũgö. Nu'tsc'evi dya, ¿cjo ra sö rí sufridovi c'o? ");
INSERT INTO mazNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","O ndünrüvi c'ua: ―Jãgã, ra sözübe, eñevi. Nuc'ua e Jesús o xipjivi: ―Nuzgö rá sufridogö y rá tũgö. Jã, na cjuana xo rí sufridoguevi y rí chũguevi. ");
INSERT INTO mazNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero dya nguezgö tocazü rá unü cjó ra mimi cja ín jodyë, ne ri ngue c'ü 'nanguarü. Nguextjo c'ü mi Tatagö c'ü ya juajnü cjó ra mimi nu. ");
INSERT INTO mazNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nuc'ua c'o dyëch'a discípulo 'ma o dyäräji, o mbürü o ünbüji c'ua e Jacobo 'ñe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero e Jesús o xipji c'ua c'o o̱ discípulo ro chëzhiji, cjanu o xipjiji c'ua: ―I̱ṉ pãrãgueji ja cja c'o pje nde pjëzhi cja yo nte yo dya pãrã Mizhocjimi, cjapüji yo nte ra tsjaji c'ü mandaji. Y xipjiji ra tsjaji c'o söji me na jyü. ");
INSERT INTO mazNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nu'tsc'eji, dya rga cjatsc'eji c'ua nzi ga cja c'o pje pjëzhi. 'Ma bübütsc'eji 'naja c'ü ne ra tsjapü na nojo a jmi Mizhocjimi, ni jyodü ra mböxc'üji 'ma c'ü, dya ra mandats'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Y c'o ra ne ra tsja in xojñigueji, ni jyodü ra mbë'pc'iji c'o, dya me ra mandats'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nutscö c'ü rvá ẽcjö cja Mizhocjimi, dya ngue c'ü ra mbëpqui yo nte'e; ngue c'ü rá pëpcö yo. Xo rvá ẽcjö rá tũgö, ngue c'ua rá cjõ'tp'ü o̱ nzhubü na puncjü o nte'e, c'ü rga emeji libre, eñe e Jesús va xipji c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","O zät'äji c'ua a Jericó. Nuc'ua o mbedyeji nu, e Jesús 'ñe c'o o̱ discípulo 'ñe na puncjü nte. Cja c'e 'ñiji c'ü mi pöji, mi junrü 'naja bëzo c'ü mi ndëzhö c'ü mi chjũ Bartimeo. Mi ngueje nu t'i e Timeo. Mi örü o merio. ");
INSERT INTO mazNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","C'e bëzo 'ma o dyärä mi ngueje e Jesús c'ü mi menzumü a Nazaret c'ü ma cjogü, o ña c'ua na jens'e o mama: ―Nu'tsc'e Jesús o̱ mboxbëchets'ü e David, juentsquegö. ");
INSERT INTO mazNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na puncjü c'o nte o huënch'iji c'ua c'e bëzo o xipjiji ro ngo't'ü o̱ ne. Pero nuc'ü, xenda o mapjü na jens'e: ―Nu'tsc'e o̱ mboxbëchets'ü e David, juentsquegö. ");
INSERT INTO mazNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nuc'ua e Jesús o böbü c'ua o mama: ―Ma't'üji ne bëzo ra chëzhi cja ín jmigö. O ma't'üji c'ua c'e bëzo c'ü mi ndëzhö o xipjiji: ―Böbü dya, mama e Jesús rí chëzhigue cja o̱ jmi. Jñunt'ü in mü'bügue ra joguts'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nuc'ua c'e bëzo o ngama c'ü mi tëjë. Exco böbü c'ua o chëzhi cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nuc'ua o dyönü e Jesús o xipji c'e bëzo: ―¿Pje i̱ṉ ne c'ü rá cja'c'ü? O ndünrü c'e bëzo c'ü mi ndëzhö o mama: ―Xöpüte, rí negö rí xocüzü ín chö rá janda. ");
INSERT INTO mazNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","E Jesús o xipji c'ua: ―Sö rí mague dya. Ya na jots'ü na ngueje i̱ 'ñejme c'ü ro jo'c'üts'ü. Jo ni zätä c'ua o̱ ndö c'e bëzo, ya jñanda c'ua. Cjanu o ndünt'ü a xütjü e Jesús nu ja mi ma'a. ");
INSERT INTO mazNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nuc'ua o zät'äji a Betfagé 'ñeje a Betania a jmi c'e t'eje c'ü ni chjũ Olivos; ya mi ngue ro zät'äji a Jerusalén. Nuc'ua e Jesús o ma't'ü c'ua yeje c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Cjanu o xipjivi: ―Mëvi cja ne jñiñi nu järä a xojñi. 'Ma rí sät'ävi nu, rí chöt'üvi 'na burru c'ü 'nünt'ü, nu c'ü dya cjó be chägä. Rí xäpcävi, jo rrĩ sijivi. ");
INSERT INTO mazNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nu 'ma cjó c'o ra dyönnc'üvi: “¿Jenga i̱ṉ xäpcävi ne burru?”, ra 'ñents'evi, nu'ma, rí xipjivi a cjava: “Ngue c'ü ín Jmugöji c'ü ni jyodü; pero jo rá ẽ socüts'ütjojme”, rí 'ñembevi c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","O mëvi c'ua, o chöt'üvi c'e burru. Mi 'nünt'ü a jmi 'na ngoxtji nu ja mi cjogü 'na 'ñiji. O xäpcävi c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nu c'o mi cãrã nu, bübü c'o o xipjivi: ―¿Pje na cjaguevi? ¿Jenga na xäpcävi ne burru? ");
INSERT INTO mazNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Anguezevi o ndünrüvi c'ua ja nzi va xipjivi e Jesús. Nguec'ua va jyëziji o mëvi c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","O sijivi c'ua c'e burru cja e Jesús. Cjanu o ngãsp'ãvi c'o mi tëjëvi cja xütjü c'e burru. Nuc'ua o chägä c'ua e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma puncjü nte c'o mi pöji. Dyaja c'o mi xĩ'mi o̱ bituji cja c'e 'ñiji; dyaja c'o mi ocü o dyëza mi xĩ'p'ĩji. ");
INSERT INTO mazNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","C'o nte c'o mi ot'ü a xojñi, 'ñe c'o ma bëpja, mi mapjüji mi mamaji: ―Me na jo nu va ẽjẽ nu o 'ñeme Mizhocjimi ra mandazüji. ");
INSERT INTO mazNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Me na jo c'ua ja rgá manda nu; ra manda c'ua ja nzi va manda ín mboxtitaji e David. Me na nojo Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nuc'ua o zät'ä e Jesús a Jerusalén. O cjogü c'ua a mbo cja c'e templo. O nu'u texe c'o mi cjaji nu. Ya mi nzhä'ä, ngue c'ua o mbedye nu o ma a Betania. O möji c'o doce o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nuc'ua c'ü na jyas'ü, o mbedyeji a Betania o möji a Jerusalén, ya mi sant'a e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","O jñanda c'ua na jẽ mi 'ne'e 'na za'a c'ü mi ngue higo c'ü mi cans'a o̱ xi. O ma nu'u cjo ri quis'i c'e higo. 'Ma o zät'ä cja c'e higo, o chöt'ü mi nguextjo o̱ xi c'o mi cans'a; na ngueje dya mi ngueje o pa'a c'o quis'i o higo. ");
INSERT INTO mazNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","O mama c'ua e Jesús o xipji c'e higo: ―Dya cja ra nguis'its'ü c'ü cjó ra zi'i, embe. O dyärä c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","O zät'äji c'ua a Jerusalén. Nuc'ua e Jesús o cjogü a mbo cja c'e templo, cjanu o pjongü a tji texe c'o nte c'o pje nde ma pö, 'ñe c'o pje nde ma tõmü nu. Xo o tunbü c'o o̱ mexa c'o mi pötü o merio, 'ñe c'o o̱ silla c'o mi pö o mbaro. ");
INSERT INTO mazNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y dya mi jëzi cjó pje ro ndunü a mbo cja c'e templo. ");
INSERT INTO mazNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","O xöpü c'ua c'o nte, o xipjiji: ―Ya t'opjü a cjava: “Nu ín nzungö ngue ngumü c'ua ja ra dyötü Mizhocjimi yo nte yo cãrã texe cja ne xoñijõmü”, eñe o̱ jña Mizhocjimi. Nu'tsc'eji na cjapcütjoji nu ín nzungö nza cja 'ma ri ngue o̱ ngumü o mbẽ'ẽ c'ua ja tsjõjõji, embeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","C'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi o dyäräji c'o mi mama e Jesús; nguec'ua mi jodüji ja rvá mbö't'üji angueze. Anguezeji me mi sũji na ngueje texe c'o nte me mi mäjä ma dyäräji c'o jña c'o mi mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nuc'ua c'ü nzhä'ä o mbedye e Jesús 'ñe c'o o̱ discípulo cja c'e jñiñi. ");
INSERT INTO mazNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nuc'ua 'ma o cjogüji c'ü na jyas'ü o jñandaji c'e higo; ya vi dyot'ü na jo texe. ");
INSERT INTO mazNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","O mbeñe c'ua e Pedro 'ma ot'ü o nuji c'e higo; o mama c'ua o xipji e Jesús: ―Xöpüte, jñanda ne higo nu i̱ xipji c'ü dya cja ro nguis'i, ya o dyot'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","O ndünrü c'ua e Jesús o xipjiji: ―Ni jyodü rí jñunt'ü in mü'büji ra dya'c'üji Mizhocjimi c'ua ja nzi gui dyötüji. ");
INSERT INTO mazNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na cjuana rí xi'ts'igöji, 'ma rí jñunt'ü in mü'bügueji c'ü ra zädä c'ü i̱ṉ mangueji, y 'ma dya rí yembeñeji, ra sö rí xipjiji ne t'eje nu: “C'ueñe c'ua, ma so'o cja ne ndeje”, rí 'ñembeji. Ra tsja c'ua, c'ua ja gui mangueji. ");
INSERT INTO mazNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nguec'ua rí xi'ts'igöji, texe c'o pje nde rí dyötüji Mizhocjimi, rí jñunt'ü in mü'bügueji c'ü ya o dya'c'üji Mizhocjimi c'ü i̱ dyötüji. Nuc'ua ra zädä a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","'Ma i̱ṉ ötüji Mizhocjimi, ni jyodü rí perdonaoji 'ma cjó pje o tsja'c'eji. Ngue c'ua c'ü nin Tataji c'ü bübü a jens'e xo ra perdonaots'üji in nzhubügueji. ");
INSERT INTO mazNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero 'ma dya rí perdonaogueji c'ü cjó pje cja'c'üji, dya xo ra perdonaots'üji in nzhubüji 'ma, c'ü nin Tataji c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","O zät'äji c'ua a Jerusalén. 'Ma mi nzhodü e Jesús a mbo c'e templo, o ẽjẽ c'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi 'ñe c'o tita, o säjäji cja o̱ jmi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","O dyönüji: ―Nu'tsc'e rí xitscöjme pje pjë'tsc'e nguec'ua i̱ṉ cjague yo. ¿Cjó ngue c'ü o 'ñempc'e rí tsjague yo? ");
INSERT INTO mazNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","O ndünrü c'ua e Jesús o xipjiji: ―Xo rá önnc'ügöji 'naja t'önü. 'Ma rí xitscöji c'ü rá önnc'üji, xo rá xi'tsc'öji 'ma c'ü pje pjëtscö nguec'ua rí cjagö yo. ");
INSERT INTO mazNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Cjó o 'ñeme e Juan mi jichi yo nte cja ndeje? ¿Cjo ngueje Mizhocjimi c'ü o 'ñeme, o ngueje yo nte? Xitscöji xã, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Anguezeji mi pötü ma mamaji c'ua: ―'Ma rá mamaji ngueje Mizhocjimi c'ü o 'ñeme, ra xitscöji: “¿Jenga dya i̱ 'ñejmegueji 'ma c'ü mi xi'ts'iji e Juan?”, ra 'ñenzgöji. ");
INSERT INTO mazNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y 'ma rá mamaji ngueje yo nte c'o o 'ñeme e Juan, dya xo ra sö, eñeji ma mantsjëji. Na ngueje mi sũji yo nte pje c'o ro tsjapüji. Na ngueje yo nte mi ejmeji na cjuana mi profeta e Juan. ");
INSERT INTO mazNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","O ndünrü c'ua anguezeji o xipjiji e Jesús: ―Dya rí pãrãgöjme cjó 'ñeme e Juan, eñeji. Xo o ndünrü c'ua e Jesús o xipjiji: ―Dya xo rá xi'tsc'öji pje pjëtscö nguec'ua rí cjagö yo. ");
INSERT INTO mazNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nuc'ua e Jesús cjanu o zopjü c'o nte, o xipjiji 'na ejemplo: ―Mi bübü 'na bëzo c'ü mi tjë 'na juajma. O ngant'a o uva cja c'ü o̱ juajma, cjanu o ngot'ü c'ua. Cjanu o dyö'bü nu ja ro yödüji c'o uva. Cjanu o ndä's'ä c'ua 'naja ts'ingumü nu ja ro mimi c'ü ro mbörü cja c'e juajma. Cjanu o unü c'ua media c'o ro mbëpi c'o uva. Cjanu o ma c'ua na jẽ. ");
INSERT INTO mazNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nuc'ua 'ma ya mi ngue ro jogü c'o uva, cjanu o tsja c'e lamu o ndäjä 'naja o̱ mbëpji o ma'a nu ja mi pëpiji c'o uva, ngue c'ua ro unüji c'o uva c'o mi toca. ");
INSERT INTO mazNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nuc'ua c'o mi pëpi c'o uva o zürüji c'e mbëpji c'ü cja vi säjä. O mbäräji c'e mbëpji; cjanu o pjongüji. Dya pje unüji. ");
INSERT INTO mazNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nuc'ua c'e lamu o ndäjä c'ua c'ü 'naja o̱ mbëpji. 'Ma o zät'ä nu ja mi pëpiji c'o uva, o s'onbüji o̱ ñi'i; me co tsjapüji na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nuc'ua c'e lamu cjanu o ndäjä c'ua c'ü 'naja o̱ mbëpji. Nuc'ü, o mbö't'üji c'ü. C'e lamu xe o ndäjä na puncjü c'o dyaja o̱ mbëpji. Pero c'o mi pëpi c'o uva, nde o tsjapüji na s'o. Dyaja c'o o mbäräji; dyaja c'o o mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Nu c'e lamu, xe mi büntjo 'naja c'ü xe ro ndäjä. Mi ngueje nu t'i'i c'ü me mi s'iya. O ndäjä c'ua c'e t'i'i. O mama c'e lamu: “Nu nu ín ch'igö, ra dyätäji nu.” ");
INSERT INTO mazNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero 'ma o zät'ä c'e t'i, c'o mi pëpi c'o uva o pötva mamaji: “Nujnu, ngueje nu ra zopcüji ne juajma ra tsjapü o̱ tsjaja. Mö rá pö't'üji ngue c'ua rá cjapcöji ín tsjacjöji ne juajma”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nuc'ua o zürüji c'e t'i. O mbö't'üji. Cjanu o pjongüji o̱ cuerpo cja c'e juajma. ");
INSERT INTO mazNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Xe sido o ña e Jesús o xipjiji: ―¿Cjo i̱ṉ pãrãgueji pje ra tsja dya c'e lamu? ¿Pje ra tsjapü c'o pëpi c'o uva? C'ü ra tsja, ra ẽ mbö't'üji. Nuc'ua cja rron unü o media c'o 'ñaja nte ra mbëpi c'o uva. ");
INSERT INTO mazNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Cjo dya i̱ xörügueji c'o ya t'opjü? Je mama a cjava c'o: Nu c'e ndojo c'ü dya ne c'o mi jäbä c'e ngumü, ngue c'ü ot'ü ya jñumüji cja squina c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ngueje Mizhocjimi c'ü ín Jmugöji c'ü o tsja a cjanu. Nguec'ua me rí cjijñiji jenga va tsja a cjanu, eñe o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nuc'ua mi jodüji ja rvá zürüji e Jesús. Na ngueje 'ma o mama e Jesús c'e ejemplo, o mbãrãji c'ü mi nguetsjë anguezeji vi jyëtsiji c'o mi pëpi c'o uva. Pero dya zürüji na ngueje me mi sũji c'o nte. O jyëziji c'ua, o möji. ");
INSERT INTO mazNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nuc'ua o ndäjäji c'ua cja e Jesús, ja nzi o fariseo 'ñe c'o político c'o mi tjünt'ü a xütjü e Herodes. Ro ma tsjapüji t'önü e Jesús. Ro dyäräji c'ua, xama pje c'o ro mama angueze, ngue c'ua ro sö ro ngöt'üji cja c'o pje mi pjëzhi. ");
INSERT INTO mazNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","O zät'äji cja e Jesús o xipjiji: ―Xöpüte, rí pãrãgöjme c'ü na cjuana c'ü i̱ṉ mangue. I̱ṉ xöpügue c'ü na cjuana ja ga cja o̱ 'ñiji Mizhocjimi. Dya cjó i̱ṉ sũgue rí zopjü, na ngueje dya i̱ṉ cjapque ngüenda zö pje ri pjëzhi 'na nte. Nguec'ua rí xitsijme pje i̱ṉ cjijñigue, ¿cjo na jo rá cjõt'üji o contribución c'ü örü e rey César o maxque jiyö?, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero e Jesús ya xmi pãtpã c'ü ma s'o c'o mi mbeñeji. Nguec'ua o xipjiji: ―¿Jenga chaque i̱ṉ önngüji? Jñüncüji 'na merio ngue c'ua rá nu'u. ");
INSERT INTO mazNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","O ma jünpüji c'ua 'naja merio. Nuc'ua e Jesús o xipjiji: ―¿Cjó o̱ ñi nu cuat'ü ne merio 'ñe cjó o̱ tjũ nu juns'ü? O ndünrüji c'ua o mamaji: ―Ngueje e César. ");
INSERT INTO mazNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","O ndünrü c'ua e Jesús o xipjiji: ―C'ü toca e César, rí unüji e César. C'ü toca Mizhocjimi, rí unüji Mizhocjimi, eñe e Jesús. Me co nguijñiji c'ua c'ü vi ndünrü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","C'o saduceo mi mamaji c'ü dya ra sö ra te yo añima. O säjä c'ua ja nzi anguezeji cja e Jesús o dyönüji: ");
INSERT INTO mazNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Xöpüte, e Moisés o dyopjü cja ín leygöji, 'ma cjó c'o ra ndũ, 'ma dya be 'ñejui t'i c'ü nu su, nu'ma, c'ü nu su ra chjüntüvi 'ma c'ü 'naja o̱ cjuarma c'e bëzo c'ü ya ndũ. Nuc'ua c'e bëzo c'ü vi ndũ, je ngue o̱ tjũ c'ü ra jñusp'üji c'e t'i c'ü ot'ü ra jmus'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mi bübü yencho bëzo c'o mi cjuarma. 'Naja anguezeji o chjüntü pero o ndũ, dya 'ñejui t'i c'ü nu su. ");
INSERT INTO mazNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nuc'ua c'ü na yeje o̱ cjuarma xo chjüntüvi c'e ndixũ. Xo ndũtjo, dya 'ñejui t'i. Je xo va cjatjonu c'ü na jñi. ");
INSERT INTO mazNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nde va cjatjoji c'ua nza yenchoji. O chjüntüji c'e ndixũ nza texeji. Y o ndũji, dya 'ñeji t'i. Cjanu o ndũ c'ua c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nguec'ua rí önnc'üjme, 'ma ra te c'o añima, ¿cjó ngue c'ü ra tsjapü nu su nza yenchoji? Na ngueje nza yenchoji nde o tsjapüji o̱ suji, eñe c'o saduceo. ");
INSERT INTO mazNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","O ndünrü c'ua e Jesús o xipjiji: ―I̱ṉ jyopüji na ngueje, dya i̱ṉ unnc'eji ngüenda pje ne ra mama o̱ jña Mizhocjimi; dya xo i̱ṉ pãrãgueji ja ga cja c'ü me na zëzhi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yo nte chjüntüji. Xo 'ñe c'o o̱ t'iji, chjüntpüji. Pero 'ma ra te'e c'o añima, dya cja ra chjüntüji a cjanu. Na ngueje ri chjëntjoji nza cja c'o o̱ anxe Mizhocjimi c'o cãrã a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Exi 'mãrãtjo cja o̱ jña Mizhocjimi c'o o dyopjü e Moisés, c'ü ra te c'o añima. ¿Cjo dya i̱ xörügueji c'e pasaje nu ja mama c'ü mi tjë c'e bidyi? O dyopjü e Moisés ja va zopjü Mizhocjimi. O mama a cjava Mizhocjimi: “Nguezgö o̱ Mizhocjimi e Abraham 'ñe e Isaac 'ñe e Jacob.” ");
INSERT INTO mazNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mizhocjimi dya ngue o̱ Mizhocjimi c'o añima, ngue o̱ Mizhocjimi c'o bübütjo. Nguec'ua exi 'ñetsetjo, zö ya ndũ e Abraham 'ñe e Isaac 'ñe e Jacob, pero bübütjoji y ra tetjoji. Nu'tsc'eji me i̱ṉ jyopüji, dya i̱ṉ cjijñiji na jo, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","O säjä c'ua 'naja c'o mi xöpü o̱ ley Mizhocjimi o dyärä 'ma mi söji o jña'a, y o mbãrã vi ndünrü na jo e Jesús. O chëzhi c'ua cja o̱ jmi e Jesús, o dyönü: ―¿Ja ngue c'ü xenda ni muvi c'o o̱ ley Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","O ndünrü c'ua e Jesús o xipji: ―C'ü xenda ni muvi c'o o̱ ley Mizhocjimi je mama a cjava: “Dyäräji, nu'tsc'eji i̱ṉ menzumüji a Israel. Mizhocjimi c'ü ngueje ín Jmugöji, 'natjo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nguec'ua rí ñegueji Mizhocjimi co texe in mü'büji, 'ñe co texe in aljmaji, 'ñe co texe in pjeñeji, 'ñe co texe c'ü na zë'ts'iji.” Nujnu nguejnu xenda ni muvi yo o̱ ley Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","C'ü na yeje o̱ ley Mizhocjimi, chjëntjovi nu cja ró xi'ts'iji. Je mama a cjava: “Rí s'iyaji yo nin minteji, c'ua ja nzi gui s'iyatsjëgueji”, eñe Mizhocjimi. Ojtjo xe 'naja o̱ ley Mizhocjimi c'ü xenda ni muvi nza cja yo. ");
INSERT INTO mazNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nuc'ua o mama c'e bëzo c'ü mi xöpü o̱ ley Mizhocjimi: ―Xöpüte, na cjuana c'ü i̱ṉ mangue. 'Natjo Mizhocjimi. Dya bübü xe 'naja c'ü ri Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","C'ü rá neji Mizhocjimi co texe ín mü'büji, 'ñe co texe ín pjeñeji, 'ñe co texe ín aljmaji, 'ñe co texe c'ü na zëtsiji, y rá s'iyaji ín minteji c'ua ja nzi rgá s'iyatsjëji, ngue c'o xenda ni muvi. Xenda ni muvi que na ngueje texe c'o animal c'o rá pö't'üji cja rron tjü'tp'üji Mizhocjimi, 'ñe c'o pje nde rá unüji. ");
INSERT INTO mazNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nuc'ua 'ma o dyärä e Jesús vi ndünrü na jo c'e bëzo, o xipji c'ua: ―Dya nda bë'ts'i c'ü ra tsja'c'ü o̱ t'its'ü Mizhocjimi c'ü manda texe. Nuc'ua dya cjó cja rezga pje xe ro dyönü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","E Jesús ma xöpü c'o nte cja c'e templo o xipjiji: ―C'o xöpü o̱ ley Mizhocjimi mamaji e Cristo ri mboxbëche cja e David. ");
INSERT INTO mazNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Maco nguetsjë e David o mama a cjava 'ma o 'ñünbü o̱ mü'bü o̱ Espíritu Mizhocjimi: Mizhocjimi o zopjü c'ü ín Jmugö o xipji: “Mimi cja ín jodyëgö. Rí da'c'ü rí mandague hasta 'ma cja rí chõpü yo nuc'ü na ü”, eñe Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","E David o nädä e Cristo o mama: “Ngue ín Jmugö”, eñe. ¿Pje ne ra mama c'ü ri mboxbëche e Cristo cja e David 'ñe c'ü xo ri ngue o̱ Jmu? C'o nte c'o mi ärä, ma puncjüji. Me mi mäjä ma dyäräji c'o mi mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","E Jesús 'ma ma xöpüji o xipjiji: ―Rí pjötpüji ngüenda cja yo xöpü o̱ ley Mizhocjimi. Anguezeji cjapüji na nojoji ga nzhodüji na maja o̱ bituji. Me xo neji cjó ra mbësp'iji t'ecjañumü rgá zenguaji cja o chõjmü. ");
INSERT INTO mazNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","'Ma pöji cja nitsjimi, me juajnuji o lugar c'o na jo ja ra mimiji. Y 'ma cjaji mbaxua, me xo juajnüji o lugar c'o me na jo. ");
INSERT INTO mazNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Anguezeji jünbüji c'o pë's'i c'o ndixũ c'o ya 'nanxũ. Pero me cjapüji na joji; me mezhe ga dyötüji Mizhocjimi. Nguec'ua Mizhocjimi ra tsjapü xenda ra sufridoji que na ngueje 'ma dya ri xöpüteji. ");
INSERT INTO mazNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","'Na nu pa e Jesús o mimi a mbo c'e templo a jmi cja c'e ts'icaja nu ja mi mbeñeji Mizhocjimi. O jñanda c'o nte mi junt'üji o merio cja c'e caja. Na puncjü c'o rico mi junt'üji na puncjü merio. ");
INSERT INTO mazNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Xo o ẽjẽ 'na 'nanxũ c'ü dya pje mi pë's'i, o ẽ jñunt'ü yeje ts'imerio; mi ts'iquëtjo mi muvi c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nuc'ua e Jesús o ma't'ü o̱ discípulo ro chëzhiji cja o̱ jmi, o xipjiji: ―Na cjuana rí xi'ts'iji, nu e 'nanxũ, nu dya pje pë's'i, nu c'ü o jñunt'ü nu, xenda ni muvi a jmi Mizhocjimi, que na ngue c'o o dyüt'ü yo dyaja. ");
INSERT INTO mazNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Na ngueje anguezeji o mbeñeji Mizhocjimi o unüji c'o vi mboncjü. Nu ne ndixũ nu dya pje pë's'i, o unü texe c'o rví ma ndõmü pje ro zi, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nuc'ua 'ma ya mi mbedye e Jesús cja c'e templo, o mama c'ua 'naja c'o o̱ discípulo: ―Xöpüte, jñanda yo ndojo, me na zö yo. Me na jo va dyät'äji ne templo. ");
INSERT INTO mazNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","O ndünrü c'ua e Jesús o xipji: ―Nujyo i̱ṉ jandaji va cja ne templo, ra zädä c'o pa 'ma dya cja ra jyäns'ä yeje ndojo c'o dya ra yät'ä. ");
INSERT INTO mazNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nuc'ua e Jesús o ma cja c'e t'eje c'ü ni chjũ Olivos c'ü tsjinch'ivi a jmi c'e templo; o mimi c'ua nu. Nuc'ua e Pedro 'ñe e Jacobo 'ñe e Juan 'ñe e Andrés o dyönütsjëji e Jesús c'ü dya cjó ro dyärä, o mamaji: ");
INSERT INTO mazNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Xitscöjme jinguã ra zädä yo. ¿Pje ma señal c'ü rá jandajme ngue c'ua rá pãrãjme 'ma ya ri ngue ra zädä yo? ");
INSERT INTO mazNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Cjanu o ndünrü c'ua e Jesús o xipjiji: ―Pjötpüji ngüenda c'ü dya cjó ra dyon'c'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Na ngueje ra ẽjẽ na puncjü c'o ra jñüncügö ín chjũ, ra mamaji ngueje Cristo anguezeji, ngue c'ua ra dyonpüji na puncjü yo nte. ");
INSERT INTO mazNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Rí dyäräji ri cjaji o chũ. Xo ra mbezheji ya ri cjaji o chũ. Dya rí sũgueji, na ngueje ni jyodü ra zädä a cjanu. Pero dya be ra nguins'i ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Na ngueje yo ndajñiñi ra pötü rgá chũji yo nu mindajñiñiji; xo nzitjo c'o jmu ra pötü rgá chũji c'o nu mijmuji. Na puncjü c'ua ja ra mbĩ'ĩ na zëzhi ne xoñijõmü, 'ñe c'ua ja ra zöji o tjijmi. Nujyo nguejyo rguí mbürü ra sufridoji yo. ");
INSERT INTO mazNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Nu'tsc'eji, rí pjötpüji na puncjü ngüenda, na ngueje ra nzhöc'ügueji nu ja ra jñün'c'üji ngüenda. Ra dyëts'iji nu cja c'o nitsjimi. Ra zints'iji cja yo rey 'ñe yo gobernador na ngue c'ü ri ejmezüji y ri nänngäji ín chjũgö. 'Ma ra zints'iji a cjanu cja c'o pje pjëzhi, ra sö rí xipjiji ja cjazgö. ");
INSERT INTO mazNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Texetjo cja ne xoñijõmü ri cãrã c'o ra zopjü yo nte ra xipjiji o̱ jña Mizhocjimi, ra xipjiji ja ga manda. Nu'ma, ngue 'ma ya ra nguins'i ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","'Ma ra zints'iji cja c'o pje pjëzhi, extí jñunt'ü in mü'büji c'ü dya ni jyodü rí tsjijñiji ja rgui chjünrüji, ante c'ü ra jñün'c'üji ngüenda. Na ngueje c'e ndajme c'ü, Mizhocjimi ra dya'c'üji o jña c'ü rí mangueji. Na ngueje dya ngue'tsc'eji rí ñaji; nu c'ü ra ña ngueje o̱ Espíritu Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ra zädä 'ma ri ngue nu c'o ri cjuarma ra nzhöji nu cjuarmaji c'ü ra mbö't'üji; o ri ngue nu tataji 'ñe nu nanaji ra nzhöji nu t'iji c'ü ra mbö't'üji; xo nzitjo c'o t'i ra nzhöji nu tataji 'ñe nu nanaji c'ü ra mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Texe yo nte ra nuc'üji na ü, na ngueje c'ü ri ejmezügöji. Pero 'ma sido rí 'ñejmezüji texe yo pa yo ri bübüji cja ne xoñijõmü, nuc'ua rí bübütjoji co Mizhocjimi a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Rí xörügueji, rí tsjapüji ngüenda yo jña yo rá xi'ts'iji. Nu c'ü me na s'o c'ü cjapü ra s'odü texe, 'ma ya rí jñandaji c'ü je ri bübü cja c'e templo, nuc'ua nu'tsc'eji ri cãrãji a Judea, rí c'ueñe rí möji cja t'eje. ");
INSERT INTO mazNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nu'tsc'eji ri tägäji a xes'e cja in nzungueji, extí c'ueñeji, dya pje rí chunüji c'o ri pë's'iji a mbo cja in nzungueji. ");
INSERT INTO mazNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nu'tsc'eji ri bünc'eji cja juajma, dya rí nzhogueji cja in nzungueji c'ü rí tsanngueji c'ü rí chëji. ");
INSERT INTO mazNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Juejme c'o ri ndunte 'ñe c'o ri jötü o̱ lëlë c'o pa c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dyötüji Mizhocjimi ngue c'ua 'ma rí c'ueñeji, dya ri ngue c'o pa c'o ri järä o së. ");
INSERT INTO mazNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Na ngueje me ra sufridoji na puncjü c'o pa c'o, c'ü nunca sufridoji a cjanu ndeze 'ma o dyät'ä Mizhocjimi ne xoñijõmü. Y dya cja xe ra sufridoji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pero Mizhocjimi ra tsjapü c'ü dya nda ra mezhe c'o pa c'o ra sufridoji, ngue c'ua dya ra chjorü texe c'o nte. Ra tsjapü c'ü dya ra mezhe c'o pa c'o, na ngue ri cãrã o̱ nte Mizhocjimi c'o ya juajnü. ");
INSERT INTO mazNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Nuc'ua 'ma cjó c'o ra xi'ts'iji: “Je bünc'ua e Cristo” o “Je bübü nu e Cristo”, ra 'ñents'eji, dya rí creogueji c'ü xi'tsc'eji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Na ngueje ra ẽjẽ c'o ra tsjapü ri nguejeji e Cristo. Xo ra ẽjẽ c'o ri cjapü profeta, ri cjapü ri ñaji o̱ jña Mizhocjimi, ra 'ñe jíchiji señal yo nte. Y ra tsjaji c'o me na nojo c'o ra jñanda c'o nte. Ra tsjaji a cjanu, ngue c'ua 'na xo ra sö ra dyonpüji c'o ya juajnü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nguec'ua extí xi'ts'iji dya, ante c'ü ra zädä c'o pa c'o; ngue c'ua rí pjötpüji ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Nuc'ua 'ma ra nguarü ra sufridoji c'o pa c'o, ra bëxõmü e jyarü. Y dya ra 'ñetse e zana. ");
INSERT INTO mazNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ra jyäbä yo seje. Y ra 'ñünü nujyo na zëzhi a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nuc'ua ra jñandgagöji nutscö rvá ẽcjö cja Mizhocjimi. Ra jñandgöji rva ẽcjö cja ngõmü, ra jñandgöji c'ü me rrã zëtsi 'ñe me rrã zözü. ");
INSERT INTO mazNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nuc'ua rá täjägö c'o ín anxe c'o cãrã a jens'e ra ẽ jmutüji c'o ró juajnü c'o ri cãrã texe cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Nu'tsc'eji rí unüji ngüenda yo za yo xiji higo. 'Ma ya ra dogü, 'ma ya pjürü peje o̱ xi, i̱ṉ pãrãgueji ngue 'ma ya ra paja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Je xo rga cjatjonu, 'ma rí jñandaji c'ü ya ra zädä yo rí xi'tsc'öji, rí pãrãgueji 'ma c'ü ya ra nguins'i ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na cjuana rí xi'tsc'öji, c'o ri cãrã c'o pa c'o, dya ra ndũ texe c'o, hasta 'ma cja ra zädä texe yo rí xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ra nguarü e jens'e 'ñe ne xoñijõmü, pero nín jñagö nunca ra nguarü nu. ");
INSERT INTO mazNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Dya cjó pãrã pje ma pa, ni pje ma ndajme 'ma ra zädä c'o, ni xo ri pãrã c'o o̱ anxe Mizhocjimi, ni xo ri pãrãgö nutscö o̱ T'izgö Mizhocjimi. Nguextjo mi Tatagö c'ü pãrã. ");
INSERT INTO mazNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Pjötpüji ngüenda; chepquegöji; sido rí dyötüji Mizhocjimi, na ngueje dya i̱ṉ pãrãgueji jinguã ra zädä c'e pa'a c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Rí chjëntcjöbe nza cja 'na bëzo c'ü ri ngue o̱ cjaja 'na ngumü c'ü ro ma na jẽ. O zojnü c'o o̱ mbëpji, o xipjiji c'o bëpji c'o ro tsjaji nzi 'najaji. C'e mböngoxtji o xipji c'ü ro mbörü, dya ro ĩjĩ. ");
INSERT INTO mazNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nguec'ua rí xi'ts'iji rí chepquegöji na ngueje, dya i̱ṉ pãrãji ja hora rá ẽcjö na yeje. Dya i̱ṉ pãrãji cjo ya ri nzhä, o cjo ya ri ndexõmü, o cjo ri ngue 'ma huë o chare, o cjo ya rguí jyas'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Rí chepquegöji na ngueje 'nandga ẽcjö, 'na rá ẽ tö'c'üji rrũ ĩjĩtjoji. ");
INSERT INTO mazNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nujyo rí xi'ts'iji, rí xipjigö texe, sido rí chepquegöji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ya mi bëzhtjo yepa ro zädä c'e mbaxua c'ü ni chjũ Pascua, 'ma mi siji o tjõmëch'i c'o dya mi bäns'ä. C'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi mi jodüji ja rvá zürüji e Jesús c'ü dya cjó ro mbãrã, ngue c'ua ro mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mi mamaji: ―Dya ra jogü rá sürüji cja ne mbaxua; 'na ra huëñi yo nte ra tsja o̱ dyëji, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","'Ma mi bübü e Jesús a Betania nu cja o̱ ngumü e Simón c'ü mi sö lepra, o säjä c'ua 'na ndixũ nu ja mi bübü e Jesús, ma tũ 'na botia ndojo c'ü mi po'o c'o me ma jo ma jyärä. Me mi muvi na puncjü merio c'ü. O mbärä c'e botia, cjanu o xisp'i o̱ ñi e Jesús 'ma ya ma jũ cja mexa. ");
INSERT INTO mazNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","C'o mi cãrã nu, bübü c'o o üdü. O pötva mamaji: ―¿Jenga o tsja a cjanu? O nda pjödü ne perfume nu me na jo ga jyärä. ");
INSERT INTO mazNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mi sö ro bö'ö nu, ro cjogü jñi mil mbëxo nu. C'o merio c'o, ro sö ro ch'unü yo dya pje pë's'i, eñe c'o. Mi ünmbüji c'e ndixũ, mi huënch'iji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","O mama c'ua e Jesús o xipjiji: ―Jyëziji. ¿Jenga na huënch'iji ne ndixũ nu? Me na zö nu o tsjacü nu. ");
INSERT INTO mazNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nu'tsc'eji, xe rí mintcjeji nujyo dya pje pë's'i, nguec'ua 'ma rí ñegueji, ra sö rí pjös'üji. Pero nutscö ra zädä 'ma dya cja rá bünc'ö a ndetsc'eji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ne ndixũ nu, o tsja nu c'ü o sö o tsja. Ya xisquigö ín cuerpo nujyo na jo ga jyärä, ngue nu ya na segurao c'ü rguí dyögüzügöji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na cjuana rí xi'tsc'öji, texe cja ne xoñijõmü c'ua ja ra zopjüji yo nte ra xipjiji ja ga cjazgö, nde ra nädäji nu o tsja ne ndixũ nu, ngue c'ua ra mbeñeji nu o tsjacü, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","E Judas Iscariote c'ü mi ngueje 'naja c'o doce o̱ discípulo e Jesús, o ma cja c'o ndamböcjimi o ma xipjiji c'ü ro nzhö e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nuc'ua c'o ndamböcjimi me co mäjäji 'ma o dyäräji c'ü ro tsja e Judas. Anguezeji o mamaji c'ua c'ü ro ngõ't'üji e Judas. Angueze o jyodü c'ü ja rvá tsjapü ngue c'ua ro nzhö'ö e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ya vi zädä c'ü ot'ü pa c'e mbaxua 'ma mi siji o tjõmëch'i c'o dya mi bäns'ä. Ngueje c'e pa 'ma mi jyodü ro mbö't'üji 'na ts'imë c'ü rví pjongüji c'e mbaxua. C'o o̱ discípulo e Jesús o xipjiji: ―¿Ja ngue c'ua i̱ṉ ne rá ma ät'äjme o jñõnü c'ü rí sigue rgui sũpü ne mbaxua? ");
INSERT INTO mazNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nuc'ua e Jesús o ndäjä yeje c'o o̱ discípulo, o xipjivi: ―Mëvi cja c'e jñiñi. 'Ma rí sät'ävi nu, rí chjëji 'na bëzo c'ü ri tunü 'na xäjnä ndeje. Rí chjünt'üvi a xütjü c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nu ja ra cjogü angueze rí xipjivi c'e bëzo c'ü menzumü nu: “C'ü rvá ẽcjöbe, mama c'e xöpüte, ¿ja bübü c'e cuarto nu ja ra mimi co c'o o̱ discípulo ra ziji c'ü rguí zũpüji ne mbaxua?” Je rga cjanu rgui xipjivi c'e menzumü. ");
INSERT INTO mazNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nuc'ua angueze ra jí'ts'ivi 'na jyäxcumü c'ü na nojo c'ü ya bübü texe c'o ni jyodü. Ngueje nu rí dyät'ävi o jñõnü c'ü rá siji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Anguezevi o mëvi c'ua cja c'e jñiñi, o chöt'üvi c'ua ja nzi va xipjivi. O dyät'ävi c'ua o jñõnü c'o ro ziji rvá zũpüji c'e mbaxua. ");
INSERT INTO mazNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nuc'ua c'ü nzhä o möji e Jesús co c'o doce o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","O mimiji cja mexa. 'Ma ndänt'ä ma siji o xëdyi, e Jesús o xipjiji: ―Na cjuana rí xi'ts'igöji, bübü 'najats'ügueji nu va rrã siji o xëdyi c'ü ra nzhögügö cja o̱ dyë c'o ra mbötcü, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Anguezeji 'ma o dyäräji a cjanu, me go ndumüji c'ua. O mbürü o dyönüji e Jesús nzi 'naja anguezeji: ―¿Cjó je ngueje c'ü, cjo nguetscö? ");
INSERT INTO mazNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","O ndünrü c'ua e Jesús o xipjiji: ―Ngueje 'najats'ügueji i̱ṉ doceji c'ü je tü'bü o xëdyi co nuzgö cja ne mojmü nu rrã sigöji, ngue c'ü ra nzhögügö c'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nutscö rvá ẽcjö cja Mizhocjimi, ra mbötcüji c'ua ja nzi ga t'opjü. Pero juejme ne bëzo nu ra nzhögügö. Xenda rvá jo c'ü dya ro jmus'ü ne bëzo nu; me ra sufrido na puncjü nu. ");
INSERT INTO mazNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","'Ma ndänt'ä ma siji o xëdyi, o jñü 'naja tjõmëch'i e Jesús, o unü na pöjö Mizhocjimi. Cjanu o xënmbi c'ua c'o o̱ discípulo, o xipjiji: ―Jñü'üji ne tjõmëch'i nu rrã xëñc'iji, rí si'iji. Nujnu ngue ín cuerpogö nu. ");
INSERT INTO mazNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Cjanu o ndës'i c'ua c'e vaso. O unü na pöjö Mizhocjimi, cjanu o unü c'o o̱ discípulo. O ziji c'ua texeji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","O mama e Jesús o xipjiji: ―Nujnu ngue ín tsjigö nu. Na ngue c'ü rga pjödügö ín tsji rá tũgö, Mizhocjimi ra tsja dya, c'ua ja nzi va mama ra tsja; ra perdonao dya o̱ nzhubü na puncjü o nte'e. ");
INSERT INTO mazNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rí xi'tsc'öji, ndeze dya, dya cja xe rá sigö o̱ ndeje o uva hasta 'ma cja ra zädä c'ü rá mandagö, c'ua ja nzi va mama Mizhocjimi. Cja rá sigö 'ma c'o cja dadyo, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","'Ma o nguarü o tõjõji 'na himno, o mbedyeji o möji cja c'e t'eje c'ü ni chjũ Olivos. ");
INSERT INTO mazNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","E Jesús o xipjiji c'ua: ―Texets'ügueji nde rí xõgüji ne xõmü dya, na ngue c'ü ra tsjacügöji dya. Na ngueje ya t'opjü a cjava: “Nuzgö rá pö't'ügö c'e mbörü. Nuc'ua c'o o̱ ndënchjürü ra mböt'ü c'o”, eñe c'ü t'opjü. ");
INSERT INTO mazNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero 'ma ya rá tegö a nde cja c'o añima, ot'ü rá magö a ma a Galilea, ngue c'ua 'ma rí sätc'eji nu, ya rva bünc'ö nu. ");
INSERT INTO mazNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","O ndünrü c'ua e Pedro o xipji: ―Zö texe ra jyëtsc'igueji, pero nuzgö dya rá jëtsc'igö, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","E Jesús o ndünrü c'ua o xipji: ―Na cjuana rí xi'tsc'ö, dya be ri huë'ë na yeje o chare ne xõmü dya, 'ma ya na jñi rgui tsädä c'ü dya i̱ṉ pãcãgö. ");
INSERT INTO mazNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Xenda o mama na zëzhi c'ua e Pedro: ―Jiyö. Zö rá tũgö co nu'tsc'e, pero dya pje rá cädägö c'ü rgá pã'c'ö, eñe c'ü. Xo nde va mantjo c'ua texe c'o discípulo. ");
INSERT INTO mazNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","O möji c'ua nu ja ni chjũ Getsemaní. Nuc'ua e Jesús o xipji c'o o̱ discípulo: ―Mimiji va; rá ma ötügö Mizhocjimi, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nuc'ua e Jesús o zidyi e Pedro 'ñe e Jacobo 'ñe e Juan. O mbürü o ndumü c'ua e Jesús, y me mi cjijñi na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nuc'ua o xipjiji: ―Me ndumü ín mü'bügö, rí sö ra mbötcügö c'ü rgá sentiogö. Chepqueji va, dya rí ĩji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Xe ma c'ua xe ts'iquë a ma xojñi, o ndüne a jõmü, o dyötü Mizhocjimi, 'ma ro sö, ro cjogütjo c'ü dya ro zädä c'ü ro tsjapüji c'e hora. ");
INSERT INTO mazNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","O mama: ―Mi Tatats'ügö. Sö rí tsjague texe. Tsjapü ra cjogü c'ü dya ra zädä c'ü rá sufridogö. Pero dya rí tsjague c'ua ja nzi rgá negö; tsjague c'ua ja nzi gui ñegue, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","O nzhogü c'ua e Jesús nu ja mi cãrã c'o jñi o̱ discípulo; o chöt'ü ya nde vi ĩjĩtjo c'o. E Jesús o xipji c'ua e Pedro: ―Nu'tsc'e Simón, ¿cjo i̱ṉ ĩcje? ¿Cjo dya mi sö ri chepque 'na hora c'ü dya rvi ĩcje? ");
INSERT INTO mazNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Cjanu o xipjiji texeji: ―Dya rí ĩjĩji. Dyötqueji Mizhocjimi ngue c'ua dya rí dyätäji c'ü dya jo. Cja in mü'büji, na cjuana i̱ṉ ne rí tsjaji c'ua ja nzi ga ne Mizhocjimi; pero in cuerpoji ya mbo o̱ cuë yo. ");
INSERT INTO mazNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nuc'ua o ma na yeje e Jesús; o ma dyötü Mizhocjimi. O mama c'o jña c'o vi mama 'ma ot'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","O nzhogütjo na yeje; o chöt'ü ya nzho ma ĩjĩtjoji na ngueje me mi tägä o t'ĩjĩ anguezeji. Dya mi pãrãji ja rvá ndünrüji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","O nzhogü c'ua c'ü na jñi, o xipjiji: ―¿Cjo ya i̱ṉ ĩcjeji 'ñe ya i̱ṉ söyaji? Ya na jo dya. Ya zädä ne ndajme. Nutscö rvá ẽcjö cja Mizhocjimi, ya ra nzhögüji cja dyë c'o nte c'o cja c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ya rí ñangaji dya. Ya va säjä nu ra nzhögügö. Mö rá chjëji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","'Ma xe ma ña e Jesús, o säjä e Judas c'ü mi ngue 'naja c'o doce discípulo. Ma dyoji na puncjü nte c'o vi ndäjä c'o ndamböcjimi, 'ñe c'o mi xöpü o̱ ley Mizhocjimi, 'ñe c'o tita, ma jünji tratjëdyi 'ñe ngarrote. ");
INSERT INTO mazNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","E Judas c'ü ro nzhö e Jesús, ya vi xipji a cjava c'o nte c'o mi pöji: ―Nu c'ü rá tjünegö, ngue c'ü i̱ṉ jodügueji c'ü. Nguec'ua rí pënch'iji na jo c'ü, c'ü dya ra c'ueñe, empji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nuc'ua e Judas 'ma o säjä, exco chëzhi a jmi e Jesús, o xipji: ―Nu'tsc'e ín xöpütets'ügö. Jo ni ndüne c'ua a jmi. ");
INSERT INTO mazNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nuc'ua c'o nte exco pënch'iji c'ua e Jesús ngue c'ua ro zidyiji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nuc'ua 'naja c'o mi dyoji e Jesús o ngübü c'ü o̱ tratjëdyi, o jñüpcü o̱ ngõ 'naja c'o o̱ mbëpji c'ü mi mero ndamböcjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","E Jesús o xipjiji c'ua: ―I̱ pedyeji cja c'in jñiñiji va ẽ sücöji nza cja 'ma ri nguezgö 'na mbẽ, va jünji in chjëdyiji 'ñe in ngarroteji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pamü mi cãrãgöji cja c'e templo mi xö'c'üji, maco dya mi pënzhguigöji 'ma. Pero ya va sädä yo, ngue c'ua ra zädä c'ü o dyopjü c'o profeta cja o̱ jña Mizhocjimi, embeji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nuc'ua texe c'o discípulo o c'ueñeji o zogüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero mi bübü 'naja t'i c'ü mi tjünt'ü a xütjü e Jesús. Nguetjo 'na manta mi tëjë c'e t'i. C'o nte o pënch'iji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero c'e t'i o mbägä c'ü o̱ manta. O cjuañi, o matjo manguerga. ");
INSERT INTO mazNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","C'o nte o zidyiji e Jesús nu ja mi bübü c'ü mi mero ndamböcjimi. Ya vi jmurü texe c'o ndamböcjimi 'ñe c'o tita 'ñe c'o mi xöpü o̱ ley Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","'Ma ya mi pöji, e Pedro mi bëpjatjo na jẽ, hasta 'ma o zät'ä nu cja c'ü o̱ tji c'ü mi mero ndamböcjimi. O cjogü c'ua e Pedro a mbo, o ma mimi nu ja mi cãrã c'o mbëpji. Ma pa't'ü cja sivi e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","C'o ndamböcjimi 'ñe c'o dyaja c'o ya vi jmurü ro jñünpüji ngüenda e Jesús, mi jodüji o testigo c'o ro mama vi tsja na s'o e Jesús, ngue c'ua ro sö ro mbö't'üji. Pero dya mi tö'tp'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma puncjü c'o mi mama vi tsja na s'o e Jesús, pero dya ma cjuana. Dya mimi yeje testigo c'o ro mama 'natjo o̱ jñavi. ");
INSERT INTO mazNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","O böbü c'ua o testigo c'o dya ma cjuana c'o o mama a cjava: ");
INSERT INTO mazNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nutscöjme ró äräjme ne Jesús o mama: “Rá tunbügö nu ne templo nu o dyät'ä yo nte. Nuc'ua jñipatjo rá jäbä c'ü 'naja c'ü dya ra jyäbä yo nte”, o 'ñeñe. ");
INSERT INTO mazNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Zo mi mamaji a cjanu, pero dya mi 'natjo o̱ jñavi. ");
INSERT INTO mazNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","O böbü c'ua c'ü mi mero ndamböcjimi a nde nu ja mi cãrã c'o nte, o dyönü e Jesús: ―¿Cjo dya pje rí chjünrügue? ¿Pje i̱ṉ mangue co nujyo jña yo na xi'tsc'eji? ");
INSERT INTO mazNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero e Jesús, dya pje ndünrü. Nuc'ua c'ü mi mero ndamböcjimi o dyönü na yeje o xipji: ―¿Cjo ngue'tsc'e e Cristo c'ü ngue o̱ T'i Mizhocjimi c'ü me na jo? ");
INSERT INTO mazNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","O ndünrü c'ua e Jesús o xipji: ―Jãgã, nguezgö. Nutscö rvá ẽcjö cja Mizhocjimi, ra zädä 'ma rí jñandgöji 'ma rá mimigö cja o̱ jodyë Mizhocjimi c'ü me na zëzhi. Rí jñandgöji rva ẽcjö cja ngõmü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","O üdü c'ua c'ü mi mero ndamböcjimi, o ts'üdü c'o o̱ bitu c'o mi je'e c'ü, o mama: ―¿Pje xe ni jyongöji o testigo? ");
INSERT INTO mazNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Cja i̱ dyäräji o zadü Mizhocjimi nu. ¿Pje i̱ṉ mangueji? Texeji mi mamaji mi jyodü ro bö't'ü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nuc'ua mi bübü c'o o zosp'ü a jmi e Jesús. O ngo'tp'üji o̱ ndö. Cjanu o ya'büji. Cjanu o xipjiji: ―Rí xitscöjme cjó ngue c'ü na yapc'ü dya. Nu c'o policía xo o mbë'chp'iji a jmi. ");
INSERT INTO mazNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","E Pedro mi büntjo nu cja c'e tji. O ẽjẽ c'ua 'naja ndixũ c'ü mi pëpi c'ü mi mero ndamböcjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nu c'e ndixũ 'ma o jñanda e Pedro c'ü ma pa't'ü cja sivi, o nguinch'i. Cjanu o xipji: ―Nu'tsc'e, xo mi dyocjevi e Jesús nu menzumü a Nazaret. ");
INSERT INTO mazNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","O ngädätjo c'ua e Pedro o mama: ―Dya rí pãrãgö c'ü. Dya xo rí pãrãgö pje pjëzhi c'ü i̱ṉ mangue. O mbedye c'ua a ma tji cja c'e ngoxtji. Jo ni huë c'ua 'na chare. ");
INSERT INTO mazNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nuc'ua c'e ndixũ c'ü mi mbëpite o jñanda na yeje e Pedro, o xipji c'ua c'ü na yeje c'o mi cãrã nu: ―Ne bëzo nu, ngue 'naja o̱ dyoji e Jesús, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","E Pedro o ngädätjo na yeje. Dya mezhe c'ua, c'o mi cãrã nu, o xipjiji na yeje e Pedro: ―Na cjuana xo ngue'tsc'e 'naja o̱ dyoji nu, na ngueje i̱ṉ menzumü a Galilea; c'ua ja gui ña, exi 'mã'tc'ãtjo. ");
INSERT INTO mazNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nuc'ua e Pedro o mbürü o ña, o mama c'ü ro zübü Mizhocjimi 'ma dya ma cjuana c'ü mi mama. O mama: ―C'ua ga mbãrã Mizhocjimi, dya rí pãrãgö ne bëzo nu i̱ṉ mangueji. ");
INSERT INTO mazNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jo ni huë c'ua na yeje 'na chare. O mbeñe c'ua e Pedro c'o jña c'o vi mama e Jesús vi xipji: “'Ma dya be ri huë na yeje 'na chare, ya na jñi rgui mamague c'ü dya i̱ṉ pãcãgö”, vi 'ñeñe. Me go huë c'ua e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nuc'ua c'ü xõrü, c'o ndamböcjimi o jmurüji co c'o tita 'ñe c'o mi xöpü o̱ ley Mizhocjimi 'ñe c'o dyaja c'o ro jñü ngüenda. Mi pötma dyü't'üji. O jyü'tp'üji o̱ dyë e Jesús, cjanu o zidyiji o ma nzhötüji e Pilato. ");
INSERT INTO mazNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","O mama c'ua e Pilato o dyönü e Jesús: ―¿Cjo i̱ṉ reygue cja yo menzumü a Israel? O ndünrü c'ua e Jesús o xipji: ―Jãgã, nguetscö c'ua ja vi mangue. ");
INSERT INTO mazNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","C'o ndamböcjimi me mi ñaji ma xiji e Pilato c'ü vi tsja e Jesús na puncjü c'o ma s'o. ");
INSERT INTO mazNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nuc'ua e Pilato o dyönü na yeje o xipji e Jesús: ―¿Cjo dya i̱ṉ tjünrü? Maco na puncjü yo pje nde xi'ts'iji. ");
INSERT INTO mazNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero dya ndünrü e Jesús. Nguec'ua dya mi pãrã pje ro nguijñi e Pilato. ");
INSERT INTO mazNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tsjë'ma 'ma mi cjaji c'e mbaxua, c'o nte mi ötüji c'e gobernador ro pjongü libre 'naja bëzo c'ü ma o'o a pjörü. ");
INSERT INTO mazNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","C'o pa c'o, ma o'o a pjörü 'na bëzo c'ü mi chjũ Barrabás, 'ñe c'o o̱ dyoji. Na ngueje vi chũji c'e gobierno, y mi pö't'üji o nte. ");
INSERT INTO mazNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nuc'ua c'o nte o chëzhiji a jmi e Pilato, o dyötüji c'ü ro pjongü libre 'naja bëzo c'ü ma o'o a pjörü c'ua ja nzi ma cja tsjë'ma. ");
INSERT INTO mazNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","O ndünrü c'ua e Pilato o xipjiji: ―¿Cjo i̱ṉ neji rá pjongü libre nu c'ü ngue in reygueji nu'tsc'eji i̱ṉ menzumüji a Israel? ");
INSERT INTO mazNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","O mama a cjanu e Pilato na ngueje o unü ngüenda, c'o ndamböcjimi mi envidiaji e Jesús nguec'ua je va nzhöji c'ua angueze. ");
INSERT INTO mazNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","C'o ndamböcjimi o dyü't'üji c'ua c'o nte ro dyörüji e Barrabás c'ü ro pjongüji libre cja pjörü. ");
INSERT INTO mazNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","O dyönü c'ua na yeje e Pilato: ―¿Pje rá cjapcö 'ma ne bëzo nu i̱ṉ mangueji ngue in reygueji? ");
INSERT INTO mazNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Anguezeji o mapjüji na yeje o mamaji: ―Chät'ä cja ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nuc'ua e Pilato o mama: ―¿Pje na mbë c'o na s'o c'ü o tsja nu? Pero anguezeji xenda mi mapjüji mi mamaji: ―Chät'ä cja ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","E Pilato mi ne ro tsjapü ro mäjä c'o nte; nguec'ua va pjongü c'ua e Barrabás. Cjanu o manda c'ua o ndas'üji e Jesús co chirrio. Nuc'ua 'ma ya o nguarü o ndas'üji, cjanu nzhöji ngue c'ua ro ma ndät'äji cja ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nuc'ua c'o xondaro o zidyiji e Jesús o cjogüji a mbo cja o̱ palacio c'e gobernador. O jmutüji c'ua texe c'o tropa. ");
INSERT INTO mazNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cjanu o jyecheji c'ua e Jesús 'na bitu c'ü ma cjipobü. O dyät'äji 'na corona c'ü mi dyavo bidyi, cjanu o jñu'tp'üji a ñi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nuc'ua o mbürü o mapjüji o mamaji: ―Nu'tsc'e o̱ Jmuts'ügue yo menzumü a Israel, sido rí tsjague Rey, mi empji. ");
INSERT INTO mazNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mi ya'p'üji o̱ ñi co 'naja xitji, cja ma zos'üji. O ndüñijõmüji a jmi, mi cjapü mi t'ecjañumü ma zopjüji, me mi mbãtãji. ");
INSERT INTO mazNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","'Ma o nguarü o tsjapüji burla, o ndonsp'üji c'ua c'e bitu c'ü ma cjipobü c'ü vi jyecheji. Cja ndo nu jyecheji c'ua c'o o̱ bitutsjë. O zidyiji c'ua nu ja ro ma ndät'äji cja ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","'Ma ya mi sidyiji e Jesús, o chjëji 'na bëzo c'ü mi menzumü a Cirene c'ü vi 'ñeje cja juajma. Nuc'ü, mi chjũ Simón c'ü; mi ngueje nu tata e Alejandro 'ñe e Rufo. O tsjapüji e Simón o nduns'ü c'e ngronsi c'ü mi tuns'ü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","O zät'äji c'ua, nu ja ni chjũ'ũ Gólgota c'ü ne ra mama: nu t'eje nu ni chjũ T'ejeñinte. ");
INSERT INTO mazNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nuc'ua mi unüji e Jesús ro zi o vino c'ü vi chjanbaji o mirra. Pero e Jesús dya o zi'i. ");
INSERT INTO mazNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","O ndät'äji c'ua cja ngronsi. Cjanu o eñeji cjó ngue c'ü ro ngana nzi 'naja o̱ bitu, cjanu o jyadüji c'o o̱ bitu. ");
INSERT INTO mazNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ya vi zünü nueve c'ü xõrü 'ma o ndät'äji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","O cuatüji a ñi c'e ngronsi c'ü mi t'opjü, ngue c'ua ro 'mãrã pje vi tjünpü ngüenda angueze. Mi t'opjü a cjava: “Nujnu, o̱ Rey yo menzumü a Israel nu.” ");
INSERT INTO mazNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nuc'ua xo ndät'äji nu, yeje mbẽ. 'Naja c'ü o ndät'äji cja o̱ jodyë e Jesús, 'naja c'ü o ndät'äji c'ü 'nanguarü. ");
INSERT INTO mazNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","A cjanu o zädä c'ü t'opjü cja o̱ jña Mizhocjimi c'ü mama a cjava: “Mi pëzhiji mi ngue 'naja yo cja na s'o.” ");
INSERT INTO mazNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nu c'o mi cjogü nu, me mi juant'a a ñi ma zadüji e Jesús, mi xipjiji: ―Nu'tsc'e mi mangue rvi yä't'ä ne templo, y c'ü na jñi nu pa ri cjuatü ri jyäbätjo na yeje. ");
INSERT INTO mazNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Rí 'ñemetsjë dya, dyagü cja ne ngronsi, mi empji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Xo ma cjanu ma mama c'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi. Me mi cjapüji burla e Jesús, mi pötma mamaji: ―Maco mamaji me o mbös'ü na puncjü o nte nu, maco dya sö ra 'ñemetsjë ra dagü cja ne ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","'Ma nguejnu e Cristo nu ra manda a Israel, ra dagü dya cja ne ngronsi, ngue c'ua rá jandaji 'ñe rá ejmegöji 'ma nu. Nuc'ua c'o yeje c'o 'natjo c'ua vi ndät'äji e Jesús, xo mi xipjivi c'o na s'o jña c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nuc'ua 'ma ya vi zünü nisiarü, o bëxõmü c'ua texetjo cja ne xoñijõmü, hasta 'ma cja zünü jñi c'ü nzhä. ");
INSERT INTO mazNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nuc'ua 'ma o zünü jñi c'ü nzhä, o mapjü c'ua na jens'e e Jesús o mama: ―Eloi, Eloi, ¿lama sabactani?, mi eñe. C'e jña ne ra mama: Nu'tsc'e ín Mizhocjimits'ügö, ¿jenga i̱ jyëzguigö? ");
INSERT INTO mazNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","C'o mi cãrã nu, o dyäräji c'o vi mama e Jesús. Bübü anguezeji c'o o mama c'ua: ―Dyäräji, nujnu, ma't'ü e Elías rguí 'ñeje a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Cjanu o cjuañi c'ua 'naja anguezeji, o ma cãjã 'naja esponja. Cjanu ngant'a cja vinagre, cjanu ngãsp'ã cja 'na xitji, mi unüji e Jesús ro züt'ü. O mama c'ua: ―Rá nuxãji cjo ra ẽjẽ e Elías ra ẽ 'ñeme nu. ");
INSERT INTO mazNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nuc'ua e Jesús o mapjü na jens'e, cjanu o ndũ c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y o chödü a nde c'e manta c'ü mi cjot'ü a mbo cja c'e templo nu ja me ma sjũ; exo ndöt'ü c'ü 'na lado a ndü'bü. ");
INSERT INTO mazNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","C'e capitán c'ü mi xojñi cja c'o xondaro, mi böbü a jmi e Jesús. 'Ma o unü ngüenda ja va mapjü e Jesús cjanu o ndũ, o mama c'ua: ―Na cjuana mi ngue o̱ T'i Mizhocjimi nu, eñe. ");
INSERT INTO mazNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Xo mi bübü ja nzi ndixũ c'o mi janda ndeze na jẽ'ẽ. Mi bübü e María Magdalena 'ñe e María c'ü nu nana e Jacobo c'ü mi menor. Nuc'ü, xo mi ngue nu nana e José. Xo mi bübü e Salomé. ");
INSERT INTO mazNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","'Ma mi bübü a Galilea e Jesús, xo mi tjünt'üji o̱ xütjü angueze; mi pëpiji angueze. Xo mi cãrã c'o dyaja ndixũ c'o ma puncjü c'o vi möji e Jesús a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","C'e pa'a c'ü, ngue 'ma mi preparao nu c'o menzumü a Israel, na ngueje c'ü na jyas'ü ri ngue nu pa 'ma söyaji. ");
INSERT INTO mazNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nuc'ua c'ü nzhä'ä o säjä 'na bëzo c'ü mi chjũ José c'ü mi menzumü a Arimatea. Mi ngue 'naja c'o mi pjëzhi na nojo c'o mi jün ngüenda. Nuc'ü, xo mi te'be c'ü ro ẽ manda nu c'ü vi 'ñeme Mizhocjimi. E José dya zũ, o ma cja e Pilato, o ma dyötü c'ü o̱ cuerpo e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","E Pilato dya mi sö ro 'ñejme c'ü ya vi ndũ e Jesús. O zojnü c'ua c'e capitán; o dyönü cjo ma cjuana ya vi ndũ. ");
INSERT INTO mazNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","O ndünrü c'ua c'e capitán o xipji que jãgã ya vi ndũ. Nuc'ua e Pilato o manda ro unüji c'e cuerpo e José. ");
INSERT INTO mazNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nuc'ua e José o ma ndõmü 'na t'öxbitu. Cjanu o ts'üpcü c'ua o̱ cuerpo e Jesús cja c'e ngronsi. Cjanu o mböch'ü c'e bitu. Cjanu o ma ngöt'ü cja 'na cueva c'ü vi dyö't'üji cja 'na dyä c'ü peña. Cjanu o chjen'chp'e c'ua 'na tralaja va ngot'ü. ");
INSERT INTO mazNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E María Magdalena co e María c'ü nu mamá e José o jñandavi nu ja je ngue c'ua vi ngöt'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nuc'ua 'ma ya vi cjogü c'e pa 'ma mi söyaji, o ma c'ua e María Magdalena, 'ñe e María c'ü nu nana e Jacobo, 'ñe e Salomé. O ma ndõmüji o pjindyo c'o ma jo ma yüdü ngue c'ua ro ma ngã's'ãji a xes'e c'e añima. ");
INSERT INTO mazNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nuc'ua c'ü ot'ü pa nu ngo 'ma ya ma jya's'ü, o ma c'o ndixũ cja c'e cueva. O zät'äji 'ma ya vi mbes'e e jyarü. ");
INSERT INTO mazNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mi pötma mamaji: ―¿Cjó ra chjen'chp'e c'e tralaja cja c'e cueva? Dya ra sözgöji. ");
INSERT INTO mazNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero 'ma o jñandaji, o nuji na jo ya vi chjen'chp'eji c'e tralaja c'ü mi c'ot'ü c'e cueva. ");
INSERT INTO mazNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","O nguich'iji c'ua cja c'e cueva; o jñandaji 'naja t'i c'ü mi junrü cja o̱ jodyë. Mi je'e 'naja t'öxbitu c'ü ma maja. Me co zũji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","O mama c'ua c'e t'i, o xipjiji: ―Dya rí sũ'ũji. I̱ṉ jodüji e Jesús c'ü mi menzumü a Nazaret nu c'ü o ndät'äji cja ngronsi. Ya te'etjo c'ü; dya cja bünc'ua c'ü. Rí ñu'uji va ja ngöt'üji. ");
INSERT INTO mazNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Möji, ma xipjiji c'o o̱ discípulo c'ü ra ot'ü angueze ra ma a Galilea, je rí chjëji nu, c'ua ja nzi va mama. Xo rí xipjiji a cjanu e Pedro c'ü o̱ discípulo, eñe c'e t'i. ");
INSERT INTO mazNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nuc'ua c'o ndixũ o c'ueñeji cja c'e cueva na ngueje me mi mbĩ'ĩji 'ñe me mi sũji. Dya cjó xo mi xipjiji na ngueje mi sũji. ");
INSERT INTO mazNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","E Jesús o te'e xõrtjo c'ü ot'ü pa nu ngo. Nu 'ma ot'ü o jizhitsjë e Jesús, ngue e María Magdalena c'ü o jñanda. E Jesús vi pjombgü yencho demonio cja o̱ mü'bü c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","O ma c'ua e María Magdalena, o ma ngös'ü c'o mi dyoji e Jesús. Me mi cjijñiji; me mi huëji. ");
INSERT INTO mazNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","'Ma o dyäräji mi mama e María Magdalena c'ü mi bübü e Jesús y vi jñanda angueze, dya mi ejmeji. ");
INSERT INTO mazNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nuc'ua e Jesús o jizhitsjë na yeje. Ngueje yeje o̱ dyoji c'o o jñanda 'ma mi pëvi cja batjü. Nandyo va jñandavi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","C'o yeje o nzhogüvi o ma ngös'üji c'o dyaja o̱ dyoji. Pero dya o 'ñejmeji. ");
INSERT INTO mazNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nuc'ua e Jesús o jizhitsjë a nde cja c'o once o̱ discípulo; o jñandaji. Ma siji xëdyi 'ma o jñandaji e Jesús. E Jesús o huënch'iji na ngueje dya mi ejmeji, ma me o̱ mü'büji. Dya mi ejmeji nu c'o ya vi jñanda vi te'e e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","O mama c'ua e Jesús o xipjiji: ―Möji texe cja ne xoñijõmü; rí ma zopjüji texe yo nte, rí xipjiji ín jñagö. ");
INSERT INTO mazNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nu c'o ra 'ñejmezügö 'ñe ra ji'iji, ra jogü o̱ mü'bü c'o. Nu c'o dya ra 'ñejmezügö, Mizhocjimi ra tsjapü ra sufridoji. ");
INSERT INTO mazNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nu c'o ra 'ñejmezügö, Mizhocjimi ra unüji c'ü ra tsjaji señal c'ü ra 'ñetse na zëzhiji. Nguec'ua ra nänngäji ín chjũgö rgá pjongüji o demonio. Ra ñaji nandyo jña. ");
INSERT INTO mazNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","'Ma ra ngü's'üji o c'ijmi, dya pje ra s'odüji. Dya xo ra s'odüji 'ma ra ziji o veneno. Ra 'ñe's'e o̱ dyëji cja c'o sö'dyë, ra jogü c'ua c'o. ");
INSERT INTO mazNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nuc'ua e Jesucristo c'ü ín Jmugöji, 'ma o nguarü o ña, Mizhocjimi o zidyi a jens'e. Je ma mimi nu cja o̱ jodyë Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","C'o discípulo o möji, o ma zopjüji texe yo nte. E Jesucristo c'ü ín Jmugöji o mbös'üji o tsjaji o señal c'o me ma nojo; nguec'ua o 'ñetse c'ü na cjuana c'o mi mamaji. Je va cjanu, amén.");
INSERT INTO mazNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Nu'tsc'e Teófilo nin t'ecjañõmü, ya i̱ṉ pãrãgue nu c'o o zädä a ndezgöjme. Bübü c'o mi pöji e Jesucristo ndeze 'ma o mbürü o zopjü c'o nte. O jñandaji c'o mi cja angueze. Anguezeji xo mamaji o̱ jña e Jesucristo ma zocüjme. Nguec'ua bübü c'o ya dyopjü c'ua ja ma cja 'ma mi nzhodü e Jesucristo cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nguec'ua xo ró cjijñigö xo na jo rá opjügö c'ua ja va cja. Na ngue ya ró cjagö na jo t'önü ró pãrãgö na jo ja ma cja ndeze 'ma o mbürü. Ngue c'o rí xi'tsc'ö dya cja ne carta, nu'tsc'e Teófilo nin t'ecjañõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Rí xi'tsc'ö yo, ngue c'ua rí pãrãgue c'ü na cjuana c'o o xi'tsc'eji. ");
INSERT INTO mazNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","O mbürü ne historia 'ma mi rey e Herodes a Judea. Mi bübü 'naja mböcjimi c'ü mi chjũ e Zacarías. 'Ma mi pëpji c'o mböcjimi cja c'e grupo c'ü mi xiji Abías, xo mi pëpji e Zacarías. C'ü nu su, mi mboxbëche cja e Aarón, mi chjũ e Elisabet c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","E Zacarías 'ñe e Elisabet, ma jo a jmi Mizhocjimi nza yejui. Mi nzhodüvi na jo cja o̱ 'ñiji Mizhocjimi, mi ätävi c'o o̱ ley. Dya cjó sö pje ro xipjivi. ");
INSERT INTO mazNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero dya mi 'ñejevi t'i. Na ngue dya mi muxt'i e Elisabet. Ya mi pale e Zacarías, ya xo mi male e Elisabet. ");
INSERT INTO mazNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","O zädä c'e zana c'ü ro mbëpi Mizhocjimi c'o mböcjimi c'o mi xiji Abías. ");
INSERT INTO mazNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","'Na nu pa, o echaji suerte, o toca e Zacarías o cjogü a mbo cja c'ü o̱ templo Mizhocjimi o jyät'ä c'o ma jo ma jyärä nza cja o nguichjünü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","'Ma ma jät'ä e Zacarías c'o ma jo ma jyärä, mi cãrã a tji na puncjü o nte, mi ötüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","'Nango jñetse c'ua 'naja c'o o̱ anxe Mizhocjimi, o jñanda e Zacarías mi böbü c'e anxe cja o̱ jodyë cja c'e mexa nu ja mi jät'ä c'o me ma jo ma jyärä. ");
INSERT INTO mazNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","E Zacarías 'ma mü o jñanda c'e anxe, me go pizhi me go zũ. ");
INSERT INTO mazNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","O mama c'ua c'e anxe o xipji: ―Nu'tsc'e Zacarías, dya rí sũ. Rvá 'ne xi'tsc'ö o dyä'tc'ä Mizhocjimi c'ü i̱ dyötü. E Elisabet c'ü nin sugue ra nduns'ü 'na ts'it'i; rí 'ñecjevi 'na ts'it'i c'ü rí jñusp'üvi o̱ tjũ e Juan. ");
INSERT INTO mazNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Me ra mäjä na puncjü in mü'bügue. Xo 'ñe na puncjü o nte ra mäji 'ma rí 'ñecjevi in ch'igue. ");
INSERT INTO mazNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Na ngue 'ma ra nocü, me rguí muvi a jmi Mizhocjimi. Dya ra zi o vino ne ri 'naja c'o ni tĩji. O̱ Espíritu Mizhocjimi ra 'ñünbü o̱ mü'bü e Juan ndeze 'ma ra nduns'ü nu nana, nguec'ua ra dyätä na jo Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ra zopjü yo nte, ngue c'ua na puncjü yo in menzumügueji a Israel ra jyëziji c'o na s'o, ra nzhogüji a jmi Mizhocjimi c'ü ín Jmugöji. ");
INSERT INTO mazNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","E Juan, ot'ü ra zopjü yo nte; cja ra ẽjẽ c'ua c'ü ín Jmugöji. C'ua ja nzi ma cja c'e profeta Elías, je xo rga cjatjonu e Juan. Ra mbë's'i o̱ poder Mizhocjimi c'ua ja nzi va mbë's'i e Elías. Nguec'ua 'ma ra zopjü yo nte, ra jyëziji c'o na s'o. C'o dya ne ra dyärä, ra nzhogü o̱ mü'büji ra dyäräji. Nguec'ua yo tata 'ñe yo t'i ra ngãrãji na jo. C'e t'i ra zopjü yo nte, ngue c'ua 'ma ra ẽjẽ c'ü ín Jmugöji, ra dyätäji c'ü, eñe c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nuc'ua e Zacarías o xipji c'e anxe: ―¿Ja rga pãrãgö cjo na cjuana ra zädä yo? Na ngue ya rí palegö. Ya xo male c'ü mi sugö, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","O ndünrü c'ua c'e anxe o xipji: ―Nguetscö e Gabriel rí zo'c'ö. Rí bübügö a jmi Mizhocjimi. O xitscö Mizhocjimi ró ẽjẽ ró ẽ zo'c'ü, ró xi'tsc'ö yo me na jo. ");
INSERT INTO mazNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Rá da'c'ü 'na señal c'ü rgui pãrãgue na cjuana c'ü ra zädä yo ró xi'ts'i. Ngue c'ü rí ngonegue dya. Dya ra sö rí ña'a hasta 'ma cja rí 'ñecjevi in ch'i. Rí ngone na ngue dya i̱ creo yo ró xi'ts'i. Texe yo ró xi'ts'i, ra zädä yo, 'ma ra zädä c'o pa, eñe c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","C'o nte mi te'beji ro mbedye e Zacarías. Mi sũji 'na pje c'o vi tsja e Zacarías, na ngue vi mezhe a mbo cja c'e templo. ");
INSERT INTO mazNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nuc'ua e Zacarías 'ma mü o mbedye, dya cja mi sö ro zopjüji. Mi jizhitjo co o̱ dyë, na ngue ya mi ngone. O mbãrã c'ua c'o nte, pje c'o vi jñanda e Zacarías a mbo cja c'e templo. ");
INSERT INTO mazNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","O cjogü c'ua c'o pa c'o mi toca e Zacarías o tsja o̱ bëpji de mböcjimi. Cjanu o ma c'ua o̱ ngumü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nuc'ua 'ma mü o cjogü c'o pa, o ndunte c'ua e Elisabet c'ü nu su. O tsot'ü c'ua tsi'ch'a zana cja nu ngumü, o mama: ");
INSERT INTO mazNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―Mi bëzhgö ín tse cja yo nte, na ngue dya mi muxt'igö. Pero me na jo va s'iyazügö dya Mizhocjimi c'ín Jmugöji, ngue c'ua dya cja rá bëzhgö ín tse. ");
INSERT INTO mazNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","O mezhe c'ua 'ñanto zana, Mizhocjimi o xipji c'e anxe Gabriel o ma cja 'na jñiñi c'ü ni chjũ a Nazaret c'ü tsja a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","O ma zopjü 'naja xunt'i c'ü cja mi xunt'itjo. C'e xunt'i ya mi ñavi 'na bëzo ro chjüntüvi. C'e bëzo, mi chjũ e José c'ü. Mi mboxbëche cja e David. C'e xunt'i, mi chjũ e María. ");
INSERT INTO mazNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","O cjogü c'ua c'e anxe nu ja mi bübü c'e xunt'i, o xipji: ―Cjimi, süngü. Me s'iyats'ü Mizhocjimi, y bübü co nu'tsc'e. Xenda ra intsjimits'ü que na ngue texe yo 'ñaja ndixũ, eñe c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nuc'ua e María 'ma mü o jñanda c'e anxe 'ñe 'ma mü o dyärä c'o jña c'o o mama, go zũ c'ua o̱ mü'bü, dya mi pãrã pje mi ne ro mama c'o jña. ");
INSERT INTO mazNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","O mama c'ua c'e anxe o xipji: ―Nu'tsc'e María, dya rí sũ. Mizhocjimi me s'iyats'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nudya rí ndunte rí mus'ü 'na ts'it'i c'ü rí jñusp'ü o̱ tjũ e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nuc'ü, ra mbëzhi na nojo c'ü, na ngueje ngue o̱ T'i Mizhocjimi c'ü bübü a jens'e. Mizhocjimi c'ü ín Jmugöji ra 'ñeme c'ü nu T'i ra manda c'ua ja mi manda e David c'ü nu mboxpale. ");
INSERT INTO mazNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ra tsja jmu cja yo o̱ mboxbëche e Jacob, ra manda para siempre. ");
INSERT INTO mazNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","O ndünrü c'ua e María o xipji c'e anxe: ―¿Ja rgá sö ra zädä yo? Dya be rí juntabe o bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","O ndünrü c'ua c'e anxe o xipji: ―Ra ẽjẽ o̱ Espíritu Mizhocjimi c'ü bübü a jens'e, ra ẽjẽ co texe o̱ poder, ra 'ñe dya'c'ü rí chuns'ü 'na ts'it'i. Nguec'ua c'e ts'it'i c'ü rí 'ñeje, ngueje o̱ T'i Mizhocjimi. Nuc'ü, dya ra tsja na s'o, eñe c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","O sido o ña c'e anxe o xipji e María: ―Tsjijñi c'ü o tsjapü Mizhocjimi e Elisabet c'ü in prima. Zö ya male, pero ya xo ndunte dya c'ü. Mi xiji c'ü dya mi muxt'i, pero ya zö 'ñanto zana ndeze 'ma mü o ndunte. ");
INSERT INTO mazNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Na ngueje Mizhocjimi sö ra tsja texe, eñe c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","O mama c'ua e María: ―Rí bünc'ö dispuesto ra tsjacö Mizhocjimi c'ua ja nzi gui mangue. Na ngue ín Jmugö c'ü; nutscö ngue o̱ mbëpjizü. Nuc'ua cjanu o ma c'ua c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nuc'ua cjanu o ma c'ua e María o zät'ä cja 'na jñiñi c'ü tsja a Judea, c'ü ma jä'ä cja t'eje. ");
INSERT INTO mazNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nuc'ua 'ma o zät'ä cja o̱ ngumü e Zacarías, o zenguate e María, cjanu o cjogü a mbo. ");
INSERT INTO mazNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","'Ma mü o dyärä e Elisabet mi zenguate e María, c'e ts'it'i c'ü mi tũ e Elisabet o 'ñõmü a mbeme. Nuc'ua o̱ Espíritu Mizhocjimi me co 'ñünbü o̱ mü'bü e Elisabet. ");
INSERT INTO mazNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nguec'ua va mapjü na jens'e, o mama: ―Xenda go intsjimits'ü Mizhocjimi que na ngue texe yo 'ñaja ndixũ. Me xo ra intsjimi c'e ts'it'i c'ü i̱ṉ tũgue. ");
INSERT INTO mazNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Va ẽcje va 'ñe zenguazü, maco ngue o̱ nanats'ügue c'ü ín Jmugö. ¿Ja va zocü Mizhocjimi i̱ 'ñe zenguazügö? ");
INSERT INTO mazNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","'Ma nzi rvá ärägö 'ma mi zenguate, ixco 'ñõmü ín pjeme c'e ts'it'i, na ngue me co mäjä. ");
INSERT INTO mazNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nu'tsc'e i̱ creo c'o o xi'ts'i Mizhocjimi. Ngue c'ü rgui mäjägue. Na ngue ra zädä c'ua ja nzi va mama, eñe e Elisabet. ");
INSERT INTO mazNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","O mama c'ua e María: Me na nojo Mizhocjimi, rí unügö 'na pöjö co texe ín mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Me rí mäpägö Mizhocjimi c'ü ra 'ñevguegö libre cja c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Zö me ni muvi c'ü ín Jmugö, zö dya pje ni muvizügö, pero me go s'iyazgö. Ndeze nudya, texe c'o ra ngãrã c'o cjë c'o va ẽjẽ, ra mamaji o tsjacü Mizhocjimi rá mäcjö. ");
INSERT INTO mazNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Na ngue o tsjacü c'o me na nojo. Angueze sö ra tsja texe; ojtjo xe 'naja c'ü ri chjëntjui c'ü. Me na sjũ, 'ñe me na jo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ndeze 'ma o mbürü o ngãrã yo nte, Mizhocjimi juentse c'o sũ angueze. ");
INSERT INTO mazNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mizhocjimi cja'a yo me na nojo, na ngue me na zëzhi. C'o me cjapü na nojo ga nguijñi o̱ mü'bü, Mizhocjimi cjapü dya ni muvi c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yo manda c'o me cjapü na nojo, Mizhocjimi pjongü c'o, ngue c'ua dya cja pje ra mbëzhiji. C'o dya cjapü na nojo, cjapüji c'ü rguí muvi c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","C'o unü ngüenda bëzhiji na puncjü, ch'unüji c'o na jo, dya cja pje ra bëzhiji. C'o cjijñi dya pje bëzhiji, Mizhocjimi cjapüji ra bëzhiji texe. ");
INSERT INTO mazNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yo nte a Israel yo ma't'ü Mizhocjimi, me pjös'üji yo. Mizhocjimi me juentse yo, na ngue sido mbeñe c'ua ja va mama va xipji e Abraham c'ü ín mboxpalegöji, 'ñe c'o o̱ t'i, 'ñe c'o o̱ bëche ro juentseji, dya ro jyëziji, eñe e María va xipji e Elisabet. ");
INSERT INTO mazNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","O mezhe jñi zana e María mi bübüvi e Elisabet. Nuc'ua cjanu o ma c'ua o̱ ngumü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nuc'ua o zädä c'e pa c'ü ro zö'dyë e Elisabet. O 'ñeje 'na ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","C'o mi chängumüji e Elisabet 'ñe c'o o̱ dyoji 'ma mü o dyäräji Mizhocjimi vi juentse na puncjü e Elisabet vi unü 'na ts'it'i, o mäji c'ua na puncjü co angueze. ");
INSERT INTO mazNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","'Ma o zö chjün, o ẽjẽ c'ua c'o ro circuncidao c'e ts'it'i. Xo ẽjẽ c'o o̱ dyoji e Elisabet. Mi ne ro jñusp'üji e Zacarías c'e ts'it'i, na ngue mi ngueje o̱ tjũ c'ü nu tata. ");
INSERT INTO mazNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","O ndünrü c'ua e Elisabet c'ü nu nana c'e ts'it'i o mama: ―Iyö. Rguí chjũ e Juan. ");
INSERT INTO mazNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","O mama c'ua c'o o̱ dyoji e Elisabet: ―¿Jenga rí jñusp'ü a cjanu? Maco dya cjó bübü c'ü ni chjũ Juan yo ín dyoji, eñe c'o o̱ dyoji e Elisabet. ");
INSERT INTO mazNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Cjanu o tsjaji seña co o̱ dyëji va dyönüji e Zacarías pje ma tjũ mi ne ro jñusp'ü c'ü o̱ ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nuc'ua e Zacarías xo o tsja c'ua seña va dyörü pje rví dyopjü. Cjanu o dyopjü c'ua: “Rguí chjũ e Juan”, eñe va dyopjü. Me co nguijñiji c'ua texeji cjanu o mamaji: ―Pãrã, ¿jenga o jñusp'üvi a cjanu?, mi eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","'Nango ña c'ua e Zacarías o unü 'na pöjö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nuc'ua texe cja c'o jñiñi c'o tsja a Judea c'o järä cja t'eje, me mi sũji me mi mamaji c'o me ma nojo c'o vi zädä. ");
INSERT INTO mazNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","C'o nte c'o mi ärä, mi cjijñiji o̱ mü'büji mi mamaji: ―Pãrã, ¿pje ra mbëzhi c'e ts'it'i?, eñeji. Na ngue mi unüji ngüenda mi bübüvi Mizhocjimi c'e ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","O̱ Espíritu Mizhocjimi o 'ñünbü o̱ mü'bü e Zacarías o ña c'o o unü Mizhocjimi ro mama: ");
INSERT INTO mazNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Rí unügö 'na pöjö Mizhocjimi c'ü ín Jmugöji nutscöji rí menzumüji a Israel. Na ngue o ẽjẽ ra 'ñe mböxcöji nutscöji o̱ ntezgöji, ra 'ñevguegöji libre. ");
INSERT INTO mazNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mizhocjimi o xipji o ẽjẽ 'na c'ü me na zëzhi ra 'ñevguegöji libre. Nuc'ü, je ri mboxbëche cja e David c'ü mi pëpi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ngue c'ü o mama c'o o̱ profeta Mizhocjimi c'o mi cãrã mi jinguã. Na ngue Mizhocjimi o 'ñünbü o̱ mü'büji o zopjüji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","O mamaji c'ü ra salvazüji Mizhocjimi cja o̱ dyë c'o rí üji c'o nugüji na ü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","O mamaji c'ü ra mbeñe Mizhocjimi ra tsja c'ua ja nzi va mama; ra s'iyazüji c'ua ja nzi va s'iya c'o ín mboxpaleji. ");
INSERT INTO mazNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ngue c'e jña c'ü o mamatsjë na cjuana Mizhocjimi va xipji e Abraham c'ü ín mboxpaleji. ");
INSERT INTO mazNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","O mama Mizhocjimi c'ü ra salvazüji cja o̱ dyë c'o nugüji na ü, ngue c'ua dya rá sũji rga ma't'üji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Y ngue c'ua rá cjaji c'ua ja nzi ga ne angueze c'o na jo, texe yo pa yo rí cãrãji cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nu'tsc'e ín ch'itsc'ö, ngue o̱ profetats'ü Mizhocjimi c'ü bübü a jens'e. Rí ot'ügue a xo'ñi cja c'ü ín Jmugöji, ngue c'ua 'ma ra ẽjẽ angueze, ya rguí bübü dispuesto yo nte ra dyätäji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nu'tsc'e rí zopjügue yo nte, ngue c'ua ra mbãrãji ja rgá sö ra salvaji ra perdonaoji c'o na s'o, ngue c'ua ra tsjapüji o̱ nte Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Na ngueje me s'iyazüji Mizhocjimi me juentsqueji. O xipji o ẽjẽ c'ü ixmi bübüvi a jens'e, ra 'ñe dyacüji jya's'ü cja ín mün'c'öji. ");
INSERT INTO mazNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nutscöji rí nteji rí nzhodüji cja bëxõmü. C'o dya ra nzhogü o̱ mü'bü, ra ma sufreji 'ma ra ndũji. Pero nu c'ü ra ẽjẽ, ra dyacüji jya's'ü cja ín mü'büji. Y ra jítscöji c'e 'ñiji ja rgá sö ra mäjä ín mün'c'öji, dya cja pje rá mbeñeji, eñe e Zacarías. ");
INSERT INTO mazNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","C'e ts'it'i c'ü mi chjũ Juan, go nocü c'ua. Xo go nzhodü na jo cja o̱ 'ñiji Mizhocjimi. Mi bübü cja majyadü hasta 'ma cja mü o zädä c'e pa 'ma o mbürü o zopjü c'o nu menzumüji a Israel. ");
INSERT INTO mazNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","C'o pa c'o, e César Augusto mi manda cja c'o país. O manda o tsjaji 'na censo ngue c'ua ro mbãrã ja nzi o nte c'o mi cãrã texe c'o país nu ja mi manda. ");
INSERT INTO mazNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","C'e censo c'ü ot'ü o dyät'äji, o tsjaji 'ma mi gobernador e Cirenio a Siria. ");
INSERT INTO mazNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nguec'ua texe c'o nte mi jyodü ro möji nu ja mi menzumüji, je ro ma jñu's'üji o̱ tjũji. ");
INSERT INTO mazNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Mi bübü 'na bëzo c'ü mi chjũ e José. Mi bübü a Nazaret c'ü tsja a Galilea. Ya mi ñavi ro chjüntüvi e María. Nuc'ua e José o mëvi e María a ma a Belén c'ü tsja a Judea nu ja mi menzumü e David mi jinguã. Je mëvi nu, na ngue e José mi mboxbëche cja e David. O mëvi ro ma jñu's'üvi o̱ tjũvi. 'Ma mü o mëvi, ya mi ndunte e María. ");
INSERT INTO mazNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nuc'ua 'ma mi bübüvi a Belén, o zädä c'e pa 'ma ro zö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","O mus'ü c'ua c'ü nu ts'it'i c'ü ot'ü. Cjanu o mbös'ü o bitu, cjanu o ngöbü c'ua nu ja mi ñõnü o burru 'ñe o nzhünü. Na ngue dya cja mi jyadü cja c'e mesón nu ja mi oxü c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mi bëxtjo cja c'e jñiñi a Belén, mi cãrã o mbörü cja batjü, mi pjörüji c'o o̱ ndënchjürüji 'ma xõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","'Nango zät'ä c'ua 'na o̱ anxe Mizhocjimi nu ja mi cãrã c'o mbörü. Y nu c'ü o̱ jya's'ü Mizhocjimi me go juëns'i nu ja mi cãrãji. Me co pizhiji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nuc'ua c'e anxe o xipji c'o mbörü: ―Dya rí sũji. Dyäräji, rá xi'tsc'öji yo me na jo yo me rgui mäcjeji. Me xo ra mäjä yo nte texe cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na ngue nudya o jmus'ü 'na ts'it'i cja c'e jñiñi nu ja mi menzumü e David. Ngueje e Cristo c'ü ín Jmuji. Nuc'ü, ra 'ñempc'eji libre c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nujnu ngue nu rgui pãrãgueji nu. Rí chöt'üji c'e ts'it'i c'ü ri bös'ü o bitu. Rí chöt'üji ri orü nu ja ñõnü o burru, eñe c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","'Nango 'ñetse c'ua cja c'e anxe na puncjü c'o o̱ anxe Mizhocjimi, mi unüji 'na pöjö Mizhocjimi mi mamaji: ");
INSERT INTO mazNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Rí unüji na puncjü 'na pöjö Mizhocjimi a jens'e c'ü me na nojo. Na ngue me go ne go mbös'ü yo nte, ngue c'ua ra mäjä o̱ mü'büji, dya cja ra mbeñeji c'o na s'o, eñe c'o anxe. ");
INSERT INTO mazNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nuc'ua cjanu o ma c'ua c'o anxe o möji a jens'e nu ja vi 'ñeji. Nuc'ua cjanu o pötü va mama c'ua c'o mbörü: ―Möjö a Belén, rá ma nuji nujyo ya zädä yo o xitsiji c'o o̱ anxe Mizhocjimi, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nuc'ua ixco möji dya c'ua na niji, o ma chöt'üji e María 'ñe e José 'ñe c'e ts'it'i. C'e ts'it'i je mi orü nu ja mi ñõnü o burru 'ñe o nzhünü. ");
INSERT INTO mazNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nuc'ua c'o mbörü, 'ma o jñandaji c'e ts'it'i, o zopjüji texe c'o mi cãrã nu, o xipjiji c'o vi dyäräji pje ro mbëzhi c'e ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","C'o o dyärä, o nguijñiji: “Pãrã, ¿ja rga cja yo?”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero e María o mbë's'i texe c'o jña. Mi sido mi cjijñi o̱ mü'bü pje mi ne ro mama c'o, dya go jyombeñe. ");
INSERT INTO mazNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","O nzhogü c'ua c'o mbörü, mi mamaji me na nojo Mizhocjimi. Y mi unüji 'na pöjö na ngue texe c'o vi dyäräji 'ñe c'o vi jñandaji. Na ngue ya vi zädä c'ua ja nzi va xipji c'e anxe anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","'Ma o zö chjün ngue c'ua ro circuncidaoji c'e ts'it'i, o jñusp'üji o̱ tjũ e Jesús, c'ua ja nzi va mama c'e anxe ante c'ü ro ndunte e María. ");
INSERT INTO mazNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nuc'ua o zäs'ä c'o pa c'o o jogü e María c'ua ja ga mama c'o o̱ ley Mizhocjimi c'o o dyopjü e Moisés. E José e María o mëvi a Jerusalén o zidyivi c'e ts'it'i c'ü mi ngue e Jesús, ngue c'ua ro presentaovi a jmi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","O tsjavi a cjanu, na ngue c'ü o̱ ley Mizhocjimi mama a cjava: “Texe c'o ts'it'i c'o ot'ü rí 'ñecjeji, rí xõcügueji ra mbëpiji Mizhocjimi”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xo o ma unüvi c'o ro mbäsp'äji Mizhocjimi c'ua ja nzi ga mama cja c'ü o̱ ley Mizhocjimi: “Rí unüji yeje vilo Mizhocjimi. O 'ma jiyö, yeje mbaro”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mi bübü 'na bëzo a Jerusalén c'ü mi chjũ e Simeón. Mi cja na jo, y mi sũ Mizhocjimi. Mi te'be c'e pa 'ma ro 'ñeme libre Mizhocjimi c'o nu menzumüji a Israel, ro unüji c'ü rví mäji. Mi ätä o̱ Espíritu Mizhocjimi c'ü me mi 'ñünbü o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","O̱ Espíritu Mizhocjimi ya vi tsjapü ro mbãrã e Simeón c'ü dya ro ndũ hasta 'ma cja ro jñanda nu c'ü vi juajnü Mizhocjimi ro 'ñe salva c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","'Na nu pa, o̱ Espíritu Mizhocjimi o 'ñünbü o̱ mü'bü e Simeón o ma cja c'e templo. Ngue c'e pa 'ma xo ma'a nu e José 'ñe e María o zidyivi c'e ts'it'i o ma presentaovi c'ua ja nzi ma mama c'e ley. ");
INSERT INTO mazNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nguec'ua 'ma o cjogü e José 'ñe e María, o tsja c'ua e Simeón o ndës'i e Jesús, o unü 'na pöjö Mizhocjimi o mama: ");
INSERT INTO mazNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nu'tsc'e mi Jmuts'ügö; nutscö in mbëpjizü. Jyëzgue rá tũgö, rá ma söyagö cja in jmigue. Na ngue ya zädä c'ua ja nzi vi xitsi. ");
INSERT INTO mazNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ya ró jandagö dya, nu i̱ xipji o ẽjẽ ra 'ñe 'ñevguegöjme libre. ");
INSERT INTO mazNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nujnu, ya i̱ mbeñe i̱ juajnü ra salva yo nte texe cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nujnu, ra unü jya's'ü cja o̱ mü'bü yo dya menzumü a Israel ngue c'ua ra mbã'c'ãji. Xo 'ñe yo menzumü a Israel yo vi juajnügue, ra mbãrãji c'ü me na nots'ügue, eñe e Simeón va unü 'na pöjö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","E José 'ñe e María me go nguijñivi c'o vi mama e Simeón ja rvá cja c'e ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Nuc'ua e Simeón cjanu o dyötpüvi Mizhocjimi. Cjanu o xipji e María c'ü nu nana e Jesús: ―Dyärä c'ü rá xi'ts'i. Mizhocjimi o xipji o ẽjẽ ne ts'it'i ngue c'ua 'ma ya ra nocü, ra 'ñetse yo nte ja ga nguijñi o̱ mü'büji. Yo ín menzumügöji a Israel, na puncjü c'o dya ra dyätpä o̱ jña nu, nguec'ua dya ra salvaji. Y xo na puncjü c'o ra dyätpä o̱ jña, nguec'ua ra salvaji. Me ra nu'uji na ü nu. Nguec'ua xo 'ñetsc'e me ra sufre in mü'bügue nza cja 'ma cjó c'o ri tjocüts'ü 'na tjëdyi, eñe e Simeón. ");
INSERT INTO mazNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mi bübü 'na ndixũ c'ü mi 'ñünbü o̱ mü'bü Mizhocjimi ma zopjü c'o nte. Nuc'ü, mi chjũ e Ana. Mi ngue o̱ xunt'i e Fanuel, mi mboxbëche cja e Aser. Angueze ya mi male. Ts'i vi ndũ c'ü nu xĩra, vi mimivi sietetjo cjë. ");
INSERT INTO mazNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Y ndeze 'ma o ndũ c'ü nu xĩra, ya vi mezhe ochenta y cuatro cjë. Mi bübü cja c'e templo, dya mi c'ueñe nu. Mi ötü Mizhocjimi zö xõmü zö ndempa. Y mi mbempje. ");
INSERT INTO mazNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","'Ma xe mi bübü nu e José 'ñe e María 'ñe e Jesús, o ẽjẽ c'ua e Ana o unü 'na pöjö Mizhocjimi. Nuc'ua o mbürü e Ana o xipji c'o nte pje ro mbëzhi c'e ts'it'i. Na ngue mi cãrã a Jerusalén c'o mi te'be ro ẽjẽ 'naja c'ü ro 'ñeme libre anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nuc'ua e José 'ñe e María, 'ma ya vi tsjavi texe c'ua ja nzi ga mama c'ü o̱ ley Mizhocjimi, cjanu o nzhogü o mëvi a Nazaret c'ü mi ngue o̱ jñiñivi c'ü tsja a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","C'e ts'it'i o nocü mi te na zëzhi. Y mi cjijñi na jo o̱ ñi, y mi pãrã na jo Mizhocjimi. Mizhocjimi mi bübü co angueze. ");
INSERT INTO mazNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tsjë'ma tsjë'ma mi pjongüji a Jerusalén c'e mbaxcua c'ü mi chjũ Pascua. Nguec'ua 'ma mi sädä c'e mbaxcua, e José 'ñe e María mi pëvi nu. ");
INSERT INTO mazNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","'Ma ya mi pë's'i e Jesús doce cjë, e José 'ñe e María o zidyivi e Jesús o möji a Jerusalén cja c'e mbaxcua. Na ngue tsjë'ma mi pëvi nu. ");
INSERT INTO mazNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","'Ma mü o cjogü c'e mbaxcua, e José 'ñe e María o mbedyevi a Jerusalén ro möji c'o 'ñaja nte c'o vi 'ñeje a Galilea. Dya mbãrãvi cjo vi nguejme e Jesús a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mi pëzhivi e Jesús ma dyoji c'o nte. Nguec'ua o nzhodüji 'napa cja 'ñiji. Nuc'ua cjanu o jyodüvi e Jesús cja c'o o̱ dyoji, 'ñe cja c'o nu menzumüji c'o mi pãrãji. ");
INSERT INTO mazNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero dya go chöt'üvi. Nguec'ua o nzhogüvi c'ua o mëvi na yeje a Jerusalén o ma jyodüvi. ");
INSERT INTO mazNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nuc'ua 'ma o zö jñipa ndeze 'ma o mbedyevi a Jerusalén, o chöt'üvi e Jesús a mbo cja c'e templo. Ma jũ a nde cja c'o xöpüte c'o mi jizhi o̱ ley Mizhocjimi. E Jesús mi ärä c'o mi mamaji, y mi cjapüji o t'önü c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","C'o xöpüte xo mi cjapüji t'önü e Jesús. O unüji ngüenda e Jesús me mi pë's'i na puncjü o̱ pjeñe, me ma jo va ndünrü. Nguec'ua va nguijñiji c'ua: ―¿Ja ni 'ñeje c'ü pãrã nu? Maco cja ts'it'i nu, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nuc'ua e José 'ñe e María 'ma mü o jñandavi e Jesús ma jũ a nde cja c'o xöpüte, me go nguijñivi. Cjanu o mama c'ua e María: ―Nu'tsc'e ín ch'itsc'ö, ¿jenga i̱ tsjacübe a cjanu? Nin tatague 'ñetscö me rí sufregöbe rgá jonc'ügöbe. ");
INSERT INTO mazNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","O ndünrü c'ua e Jesús o xipjivi: ―Dya ni jyodü rí jyongüvi. ¿Cjo dya i̱ṉ pãrãvi ni jyodü rá bübü cja o̱ ngumü c'ü mi Tata, rá cjagö c'o o̱ bëpji?, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Anguezevi dya mi pãrãvi pje mi ne ro mama c'o jña c'o vi xipjivi. ");
INSERT INTO mazNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nuc'ua e Jesús o mbedye a Jerusalén co e José 'ñe e María, o möji a Nazaret. Na ngue e Jesús mi ätä c'ü o̱ tata 'ñe c'ü o̱ nana. C'o jña c'o vi mama e Jesús, o mbeñe e María cja o̱ mü'bü pje mi ne ro mama. ");
INSERT INTO mazNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","E Jesús o nocü na jo, y mi cjijñi na jo o̱ ñi. Nguec'ua Mizhocjimi mi bübü co angueze, y me mi mäpä c'ü. Xo 'ñe yo nte, me xo mi mäpäji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","O mezhe c'ua ja nzi cjë, mi emperador e Tiberio César. Ya mi quince cjë c'ü mi emperador. Mi gobernador e Poncio Pilato a Judea. E Herodes mi gobernador a Galilea. E Felipe mi gobernador a Iturea 'ñe a Traconite. E Lisanias mi gobernador a Abilinia. ");
INSERT INTO mazNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","E Anás 'ñe e Caifás mi mero ndamböcjimi c'o. C'o pa c'o, e Juan c'ü nu t'i e Zacarías mi bübü cja majyadü. 'Na nu pa, Mizhocjimi o 'ñünbü o̱ mü'bü e Juan o mbürü o zopjü c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nguec'ua mi nzhodü bëxtjo cja c'e ndare a Jordán, mi xipji c'o nte ro nzhogü o̱ mü'büji cja Mizhocjimi ro jyëziji c'o na s'o, 'ñe ro ji'iji. Nu'ma, ro perdonao 'ma Mizhocjimi c'o na s'o c'o mi cjaji. ");
INSERT INTO mazNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mi jinguã c'e profeta Isaías o dyopjü 'na libro. O dyopjü c'ü ro bübü 'na nte cja 'na majyadü c'ü ro mapjü, ro zopjü c'o nte ro xipjiji: “Rí jyëzgueji c'e 'ñiji c'ü na s'o, rí jyëzgueji c'e 'ñiji c'ü mogü. Na ngue ya ngue ra ẽ c'ü ín Jmugöji c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","'Ma ra ẽjẽ 'na c'ü manda, rí parejaogöji o 'ñiji, y rí nderesaoji c'o 'ñiji c'o mogü. Je xo rga cjatsc'eji nu, rí jyëziji c'e 'ñiji c'ü na s'o c'o i̱ṉ tëpiji. ");
INSERT INTO mazNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na ngue ra ẽjẽ nu c'ü o juajnü Mizhocjimi ra salva yo nte texe cja ne xoñijõmü”, ro 'ñeñe c'e nte. Je ga cjanu va mama e Isaías c'ü ro mama c'e nte. Nguec'ua 'ma o mbürü e Juan o zopjü c'o nte, o zädä c'e jña c'ü vi mama e Isaías. ");
INSERT INTO mazNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na puncjü o nte c'o mi pedye cja c'o o̱ jñiñiji mi pöji cja e Juan ngue c'ua ro jiji cja c'e ndare. Nguec'ua o mama e Juan va xipjiji: ―Nza cjatsc'eji o c'ijmi yo sũ ga c'ueñe 'ma tjë o batjü. I̱ṉ sũji ra jñün'c'üji ngüenda Mizhocjimi rí sufregueji, nguec'ua va ẽgueji va 'ñe jigueji. ");
INSERT INTO mazNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pero 'ma na cjuana o nzhogü in mü'büji cja Mizhocjimi, rí tsjaji na jo, ngue c'ua ra jñetse ya nzhogü in mü'büji. I̱ṉ pëzhgueji ra recibidots'üji Mizhocjimi, na ngue o̱ mboxbëchets'üji e Abraham. Pero rí xi'tsc'öji, dya cja rí tsjijñiji c'ü ni jyodü ra recibidots'üji. Na ngue me na zëzhi Mizhocjimi, sö ra tsjapü yo ndojo ra mbëzhi nte c'o ra jñu's'ü e Abraham, xo ra 'ñench'e o̱ mü'büji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nza cjatsc'eji za'a c'o dya jo c'o quis'i, c'o ya juns'ütjo jacha cja o̱ dyü'ü, na ngue ya ra dyocüji. Texe za'a c'ü dya jo c'o quis'i, ya bübü ra dyëziji cja rrũ mboch'üji cja sivi. Je xo rga cjanu rgá tsja'c'üji, nu 'ma dya ra nzhogü in mü'büji cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","C'o nte mi önüji mi mamaji: ―¿Pje ni mbë c'ü ni jyodü rá cjajme 'ma, ngue c'ua dya ra tsjacüjme Mizhocjimi rá ma sufrejme? ");
INSERT INTO mazNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","O ndünrü c'ua e Juan o xipjiji: ―Nu c'ü cãjã yeje pajna, ra unü 'na pajna c'ü dya cãjã. Nu c'ü pë's'i pje ra zi, ra unü c'ü dya pë's'i, eñe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Xo ẽjẽ ja nzi c'o mi cobra o ndüvajma, o ẽji ro 'ñe ji'iji. O xipjiji e Juan: ―Xöpüte, ¿pje ni mbë c'ü ni jyodü rá cjagöjme? ");
INSERT INTO mazNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","O ndünrü c'ua e Juan o xipjiji: ―Rí cobraji ja c'o nzi ga mama c'o ley; dya rí jñu's'üji rgui cobraji. ");
INSERT INTO mazNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Xo o tsja t'önü c'o tropa o mamaji: ―Nuzgöjme, ¿pje xo ni jyodü rá cjagöjme? O ndünrü c'ua e Juan o xipjiji: ―Bübü 'ma i̱ṉ pizhiji yo nte, o i̱ṉ pezheji o bëchjine ngue c'ua ra ch'a'c'üji o merio. Pero dya cja rí tsjaji a cjanu. Rí mäji co c'o in rayaji c'o cjõ'tc'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","C'o nte me mi cjijñiji e Juan, cjo mi ngue Cristo c'ü mi te'beji ro ẽjẽ. ");
INSERT INTO mazNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","O mama c'ua e Juan o xipjiji: ―Bübü o mbëpji c'o o̱ cjaja c'ü nu lamu, xäpcäji o̱ correa cja o̱ mbäcua c'ü nu lamu ga mbös'ü. Nutscö ni pje pjëtscö rá pjösc'ö a cjanu nu c'ü va ẽtjo. Na ngue me na nojo na puncjü angueze; nutscö rí menutjogö que na ngue 'na mbëpji. Nutscö rí jichi co ndeje yo nte. Pero nu c'ü cja va ẽtjo, 'ma rí 'ñench'e in mü'büji angueze, ra dya'c'üji o̱ Espíritu Mizhocjimi c'ü. 'Ma jiyö, ra dya'c'üji rí ma sufreji cja sivi. ");
INSERT INTO mazNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xe go sido go ña e Juan o xipjiji: ―'Na campesino ra jñüs'ü o̱ yelgo, cja rrũ mbitsi na jo o̱ ndëxü. C'o ndëxü ra dyüt'ü cja c'ü o̱ t'ujmü c'o, pero c'o paxa ra ndüt'ü co sivi c'o. Je xo ga cjanu rgá tsja nu c'ü cja va ẽtjo. Ya bübü angueze ra recibido c'o ra nzhogü o̱ mü'bü, pero c'o dya ra nzhogü o̱ mü'bü, ya bübü ra mboch'üji a sivi c'ü dya ra juench'e, eñe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nujyo, ngue yo o mama e Juan va xipji c'o nte ja rva cja e Cristo. Y na puncjü o jña c'o xe go xipjiji. ");
INSERT INTO mazNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","C'e gobernador Herodes vi mimivi e Herodías c'ü nu su e Felipe. E Felipe mi ngue c'ü nu cjuarma e Herodes. Y mi cja c'o na s'o e Herodes. Nguec'ua e Juan va huënch'i e Herodes mi xipji c'ü dya jo c'o mi cja. ");
INSERT INTO mazNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nuc'ua e Herodes go tsja c'ua mas c'o na s'o, go manda o ma pant'aji a pjörü e Juan. ");
INSERT INTO mazNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","'Ma mi jichi e Juan c'o nte cja c'e ndare a Jordán, xo ji'i e Jesús. E Jesús 'ma o nguarü o ji'i, cjanu o dyötü c'ua Mizhocjimi. 'Ma ma ötü Mizhocjimi, go xogü a jens'e c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Y o zöbü o̱ Espíritu Mizhocjimi c'ü mi nza cja 'na mbaro, o ẽjẽ o 'ñe ndägä a xes'e e Jesús. O dyäräji c'ua 'naja c'ü o ña a jens'e o mama: ―Ngue'tsc'e ín Ch'itsc'ö, me rí s'iyats'ü, me rí mä'c'ägö. ");
INSERT INTO mazNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","E Jesús ya mi pë's'i treinta cjë 'ma mü o mbürü o zopjü c'o nte. C'o nte mi mamaji e Jesús mi ngueje nu t'i e José. E José mi t'i cja e Elí. ");
INSERT INTO mazNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","E Elí mi t'i cja e Matat. E Matat mi t'i cja e Leví. E Leví mi t'i cja e Melqui. E Melqui mi t'i cja e Jana. E Jana mi t'i cja e José. ");
INSERT INTO mazNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","E José mi t'i cja e Matatías. E Matatías mi t'i cja e Amós. E Amós mi t'i cja e Nahum. E Nahum mi t'i cja e Esli. E Esli mi t'i cja e Nagai. ");
INSERT INTO mazNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","E Nagai mi t'i cja e Maat. E Maat mi t'i cja e Matatías. E Matatías mi t'i cja e Semei. E Semei mi t'i cja e José. E José mi t'i cja e Judá. ");
INSERT INTO mazNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","E Judá mi t'i cja e Joana. E Joana mi t'i cja e Resa. E Resa mi t'i cja e Zorobabel. E Zorobabel mi t'i cja e Salatiel. E Salatiel mi t'i cja e Neri. ");
INSERT INTO mazNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","E Neri mi t'i cja e Melqui. E Melqui mi t'i cja e Adi. E Adi mi t'i cja e Cosam. E Cosam mi t'i cja e Elmodam. E Elmodam mi t'i cja e Er. ");
INSERT INTO mazNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","E Er mi t'i cja e José. E José mi t'i cja e Eliezer. E Eliezer mi t'i cja e Jorim. E Jorim mi t'i cja e Matat. ");
INSERT INTO mazNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","E Matat mi t'i cja e Leví. E Leví mi t'i cja e Simeón. E Simeón mi t'i cja e Judá. E Judá mi t'i cja e José. E José mi t'i cja e Jonán. E Jonán mi t'i cja e Eliaquim. ");
INSERT INTO mazNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","E Eliaquim mi t'i cja e Melea. E Melea mi t'i cja e Mainán. E Mainán mi t'i cja e Matata. E Matata mi t'i cja e Natán. ");
INSERT INTO mazNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","E Natán mi t'i cja e David. E David mi t'i cja e Isaí. E Isaí mi t'i cja e Obed. E Obed mi t'i cja e Booz. E Booz mi t'i cja e Salmón. E Salmón mi t'i cja e Naasón. ");
INSERT INTO mazNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","E Naasón mi t'i cja e Aminadab. E Aminadab mi t'i cja e Aram. E Aram mi t'i cja e Esrom. E Esrom mi t'i cja e Fares. E Fares mi t'i cja e Judá. ");
INSERT INTO mazNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","E Judá mi t'i cja e Jacob. E Jacob mi t'i cja e Isaac. E Isaac mi t'i cja e Abraham. E Abraham mi t'i cja e Taré. E Taré mi t'i cja e Nacor. ");
INSERT INTO mazNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","E Nacor mi t'i cja e Serug. E Serug mi t'i cja e Ragau. E Ragau mi t'i cja e Peleg. E Peleg mi t'i cja e Heber. E Heber mi t'i cja e Sala. ");
INSERT INTO mazNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","E Sala mi t'i cja e Cainán. E Cainán mi t'i cja e Arfaxad. E Arfaxad mi t'i cja e Sem. E Sem mi t'i cja e Noé. E Noé mi t'i cja e Lamec. ");
INSERT INTO mazNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","E Lamec mi t'i cja e Matusalén. E Matusalén mi t'i cja e Enoc. E Enoc mi t'i cja e Jared. E Jared mi t'i cja e Mahalaleel. E Mahalaleel mi t'i cja e Cainán. ");
INSERT INTO mazNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","E Cainán mi t'i cja e Enós. E Enós mi t'i cja e Set. E Set mi t'i cja e Adán. E Adán mi t'i cja Mizhocjimi na ngue o dyät'ä Mizhocjimi c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","O̱ Espíritu Mizhocjimi me go 'ñünbü o̱ mü'bü e Jesús o mbedye cja c'e ndare a Jordán, o ma cja 'na majyadü nu ja dya cjó mi ndeñe. Na ngue mi ätä o̱ Espíritu Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","O mezhe nu cuarenta pa. Xo mi bübü nu, e Satanás nu c'ü dya jo, mi xipji e Jesús c'ü ro tsja c'o na s'o. C'o cuarenta pa, dya pje zi e Jesús. 'Ma ya vi cjogü c'o pa c'o, o zant'a c'ua e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nuc'ua e Satanás nu c'ü dya jo, o xipji e Jesús: ―Ngue'tsc'e o̱ T'itsc'e Mizhocjimi, nguec'ua rí xipjigue yo ndojo ra mbëzhi o xëdyi rí sigue, eñe c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","O ndünrü c'ua e Jesús o xipji: ―Dya rá ä'tc'ägö c'ü i̱ṉ xitsi. Na ngue je t'opjü o̱ jña Mizhocjimi c'ü dya nguextjo xëdyi rga minc'öjme. C'ü xenda ni jyodü, ngue c'ü rá cjajme texe ja c'o nzi ga mama Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nuc'ua c'ü dya jo o zidyi e Jesús cja 'na t'eje c'ü ma ndã'ã. O mezhe 'na ndajme o jíchi texe yo jñiñi cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nuc'ua c'ü dya jo o xipji e Jesús: ―Nu'tsc'e rá da'c'ü rí mandague texe cja yo jñiñi yo i̱ṉ jandague. Xo rá da'c'ü texe yo me ni muvi yo bübü cja yo jñiñi. Texe yo, ya ch'acügö yo. Ra sö rá unü c'ü rí ne rá unü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nu 'ma rí ndüñijõmü rí matcügö, rí tsjapü in tsjacje texe yo. ");
INSERT INTO mazNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","O ndünrü c'ua e Jesús o xipji: ―Nu'tsc'e Satanás, dya rá ma'tc'ö. Na ngue ya t'opjü o̱ jña Mizhocjimi c'ü rá ndüñijõmüjme rá ma't'üjme Mizhocjimi c'ü ngue ín Jmuji. Y nguextjo angueze rá pëpijme, enzgöjme c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Xo tsja c'ü dya jo o zidyi e Jesús a ma a Jerusalén, o 'ñe's'e c'ua a xes'e cja 'naja c'o torre c'o mi bübü cja c'e templo. O xipji c'ua: ―Ngue'tsc'e o̱ T'itsc'e Mizhocjimi, nguec'ua rí dacügue dya a ma a jõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ni jyodü rí tsjague a cjanu, na ngue ya xo t'opjü o̱ jña Mizhocjimi: Mizhocjimi ra xipji c'o o̱ anxe rguí 'ñeji a jens'e ra 'ñe mböxc'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ra 'ñe penchc'iji ngue c'ua dya ra s'onnc'ü in cua 'ma rí sos'ü cja ndojo, eñe c'ü ya t'opjü. Ngue c'ua rí dacügue ndezgua hasta jõmü, eñe c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Cjanu o ndünrü c'ua e Jesús o xipji: ―Dya rá dacü c'ua ja gui xitscö. Na ngue ya xo t'opjü c'ü dya rá söjme o̱ jña Mizhocjimi c'ü ín Jmugöji, enzgöjme. Nguec'ua dya rá dacü a ma a jõmü para rá nugö cjo ra mböxcö Mizhocjimi, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nuc'ua c'ü dya jo, dya mi pãrã pje xe ro xipji e Jesús para ro tsja c'o na s'o, nguec'ua va c'ueñe ja nzi pa, cja ro nzhogü na yeje pje xe ro 'ñe xipji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nuc'ua e Jesús o nzhogü o ma a Galilea. Mi bübüvi texe c'ü o̱ poder o̱ Espíritu Mizhocjimi. Nguec'ua texe cja c'o jñiñi c'o mi tsja a Galilea, o mbürü o mamaji c'o ma nojo c'o mi cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mi cja e Jesús mi jíchiji cja c'o o̱ nintsjimiji. Texeji mi mamaji: ―Ne bëzo bübüvi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","O ma c'ua e Jesús a Nazaret nu ja mi menzumü. Nuc'ua c'e pa c'ü mi söyaji, o cjogü a mbo cja c'e nintsjimi ja c'o nzi ma cja c'ü o̱ tjũrü. Cjanu o mimi nu. Cjanu o böbü c'ua ro xörü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Cjanu o ch'unü c'ua c'e libro c'ü vi dyopjü e Isaías c'ü mi profeta. Cjanu o xücü c'e libro c'ü mi 'mans'a, o chöt'ü nu ja mi t'opjü a cjava: ");
INSERT INTO mazNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","O̱ Espíritu Mizhocjimi bübü co nutscö, na ngue o juancügö. O juancügö rá zopjü c'o unü ngüenda bëzhiji na puncjü, rá xipjiji jña c'o rguí mäji. O juancügö rá cjapü ra mäjä c'o me nzhumü o̱ mü'bü. O juancügö rá zopjü yo nte yo dya libre, rá xipjiji ja rgá sö ra 'ñemeji libre. C'o ndëzhö, rá cjapü ra jñandaji. C'o me sufre, rá emeji libre. ");
INSERT INTO mazNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","O juancügö rá xipji yo nte c'ü ya zädä c'o pa c'o o juajnü Mizhocjimi ra salvaji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cjanu o mbans'a c'ua c'e libro, cjanu o unü c'ü mi pëpji cja nintsjimi. Cjanu o mimi c'ua ro jíchi c'o nte. Texe c'o mi cãrã cja c'e nintsjimi me mi cjinch'iji angueze, mi te'beji pje pjëzhi c'o ro mama. ");
INSERT INTO mazNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nuc'ua cjanu o ña e Jesús o xipjiji: ―Nu o̱ jña Mizhocjimi nu cja ró xörügö, ya zädä dya a ndetsc'eji nu, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","C'o nte, me co nguijñiji y me go mamaji: ―Me na jo yo jña yo mama nu, pero ¿ja ga mbãrã nu? Maco ngue nu t'i e José c'ü mi ngue ín menzumügöji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","O mama e Jesús o xipjiji: ―I̱ṉ pãrãji c'e jña c'ü rí mangöji: “Nu'tsc'e médico, rí dyät'ätsjë ante c'ü rí dyät'ä c'o 'ñaja.” Pe ngue c'ü i̱ṉ cjijñiji dya, cja in mü'büji. Pe xo i̱ṉ ne rí xitscöji a cjava: “Ró äräjme i̱ tsjague c'o me na nojo a Capernaum, maco dya i̱ṉ cjague yo cja ín jñiñigöji”, rí 'ñenzgöji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","O sido o ña e Jesús o mama: ―Dyäräji na jo c'ü rá xi'tsc'öji, c'o na cjuana. Yo nte, dya respetaoji 'na profeta 'ma ngue nu menzumütsjëji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dyäräji na jo c'ü xo rá xi'tsc'öji. Ya i̱ṉ pãrãji ja ma cja mi jinguã 'ma mi bübü e Elías. O mezhe jñi cjë nde c'ü dya go 'ñeje o dyebe, nguec'ua mi bübü 'na tjijmi texe cja c'o jñiñi. C'o pa c'o, mi cãrã va a Israel na puncjü o ndixũ c'o ya vi ndũ nu xĩra. ");
INSERT INTO mazNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero dya ngue anguezeji c'o o xipji Mizhocjimi e Elías ro 'ñe mbös'ü. O xipji o ma a Sarepta c'ü bëxtjo järä a Sidón, o ma mbös'ü 'na ndixũ nu c'ü vi ndũ nu xĩra, maco dya mi menzumü a Israel. ");
INSERT INTO mazNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","C'o cjë c'o mi bübü e Elías, mi cãrã va a Israel na puncjü c'o mi sö c'e ngueme c'ü xiji o lepra. Pero dya cjó jogü ne ri 'naja anguezeji. Nguextjo e Naamán c'ü mi menzumü a Siria c'ü o jogü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nuc'ua c'o mi cãrã cja c'e nintsjimi, 'ma mü o dyäräji c'o jña c'o, me co sjëyaji c'ua na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Go böbüji c'ua, cjanu o pjongüji e Jesús cja c'ü o̱ jñiñiji, o zidyiji cja c'e dyä'ä nu ja mi jäs'ä c'e jñiñi. O zidyiji ro ma pa'maji a jõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero e Jesús o cjogütjo a nde anguezeji, o ma c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nuc'ua e Jesús o zöbü o ma c'ua a Capernaum c'ü mi ngue 'na jñiñi a Galilea. Chjüma chjüma c'o pa c'o mi söyaji, mi jíchi c'o nte cja c'e nintsjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","C'o nte me mi sũji mi cjijñiji: ―Nunca rí äräji a cjanu. Je ni 'ñeje cja Mizhocjimi c'o jña c'o xitsiji nu, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Cja c'e nintsjimi, mi bübü 'na bëzo c'ü vi zürü 'naja o̱ s'ondajma e Satanás nu c'ü dya jo, c'ü o tsjapü o mapjü c'ua na jens'e c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","O mama: ―Nu'tsc'e Jesús i̱ṉ menzumü a Nazaret, ¿pje i̱ṉ pë'sc'ü rí ñu co nuzgöjme? ¿Cjo vi 'ñeje rí tsjacü rá ma sufregöjme? Nutscö rí pã'c'ã. Ngue'tsc'e o̱ T'itsc'e Mizhocjimi, dya bübüts'ü c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","E Jesús o huënch'i c'ua c'ü o̱ s'ondajma c'ü dya jo o xipji: ―Tso't'ü in te. Pedye cja ne bëzo. Nuc'ua c'ü o̱ s'ondajma c'ü dya jo o tsjapü o nügü c'e bëzo a nde c'o nte c'o mi cãrã. O mbedye c'ua c'e s'ondajma cja c'e bëzo y dya pje tsjapü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Me co nguijñi c'ua c'o nte, o mamaji: ―¿Pje pjëzhi c'ü pë's'i ne bëzo c'ü me na nojo? Manda yo o̱ s'ondajma c'ü dya jo nza cja c'ü ri pë's'i o poder. Xipjiji ra mbedyeji, cja na mbedyeji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nguec'ua texe cja c'o jñiñi c'o tsja a Galilea, me mi mamaji c'o ma nojo c'o mi cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nuc'ua e Jesús o böbü o mbedye cja c'e nintsjimi. Cjanu o ma c'ua o zät'ä cja nu ngumü e Simón. C'ü nu to'o e Simón, mi sö pa'a. O xipjiji c'ua e Jesús ro jocü. ");
INSERT INTO mazNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nuc'ua e Jesús o ẽjẽ nu ja mi orü c'e ndixũ. Cjanu o huënch'i c'ua c'e pa'a. O c'ueñe c'ua c'e pa'a. O nanga c'ua na zëzhi c'e ndixũ, cjanu o dyät'ä o jñõnü cjanu o ziji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","'Ma ya ma quibi e jyarü, ma ẽjẽ c'o nte ma siji c'o o̱ dyoji c'o mi sö pje nde ma ngueme, ma sinpiji e Jesús. Nuc'ua e Jesús mi ẽ's'ẽ o̱ dyë nzi 'naja c'o mi sö'dyë, y mi jogüji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na puncjü c'o mi sö'dyë c'o o mbedye o̱ s'ondajma c'ü dya jo. Nzi ma mbedye, nzi ma mamaji: ―Ngue'tsc'e o̱ T'its'ü Mizhocjimi, eñe c'o s'ondajma. E Jesús mi huënch'iji, dya mi jëzi ra ñaji, na ngue mi pãrãji e Jesús mi ngue e Cristo. ");
INSERT INTO mazNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nuc'ua 'ma mü o jyas'ü, o mbedye e Jesús o ma cja 'na majyadü nu ja dya cjó mi ndeñe. Nuc'ua c'o nte mi jodüji e Jesús. 'Ma mü o chöt'üji, mi süjmüji ngue c'ua dya ro xõgü co anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","O mama c'ua e Jesús o xipjiji: ―Xo ni jyodü rá ma zopjü c'o nte c'o cãrã c'o nan'ño jñiñi, rá xipjiji ni jyodü ra dyätäji Mizhocjimi, na ngueje ngue c'ü manda. Ngue c'ü vi juancügö Mizhocjimi rá cjagö, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","O ma c'ua cja c'o 'ñaja jñiñi c'o mi tsja a Galilea, mi zopjüji cja c'o o̱ nintsjimiji. ");
INSERT INTO mazNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","'Na nu pa, e Jesús mi bübü cja squina c'e zapjü c'ü ni chjũ Genesaret. O ẽjẽ c'ua na puncjü o nte, me mi chütüji ngue c'ua ro dyäräji o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","E Jesús o jñanda c'ua yeje bü'ü c'o ma jä'ä cja squina c'e zapjü. C'o mbëjmõ ya vi mbes'eji cja c'o bü, mi pe'ch'eji c'o o̱ rreji. ");
INSERT INTO mazNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","E Jesús o dat'ü c'ua cja 'naja c'o bü c'ü mi ngue o̱ cjaja e Simón. Cjanu o xipji c'ua e Simón xe ro ndütü c'e bü a ma cja c'e ndeje. O mimi c'ua cja c'e bü, o jíchi c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nuc'ua 'ma mü o nguarü o ña, o xipji e Simón: ―Mague cja c'e ndeje nu ja xenda na jẽ'ẽ. Rí pät'äji c'o in rreji ngue c'ua rí sürüji o jmõ. ");
INSERT INTO mazNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","O ndünrü c'ua e Simón o xipji: ―Xöpüte, 'naxõmü ró pëpjijme, dya ró sürüjme. Pero rá pät'ägö ne rre ja c'o nzi gui xitsi, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","O tsjaji c'ua ja va xiji. O zürüji c'ua na puncjü o jmõ, nguec'ua ya ma xüt'ü c'e rre. ");
INSERT INTO mazNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nuc'ua o juãjpjã o dyëji c'o o̱ dyoji c'o ma cãjã cja c'ü 'naja bü, ngue c'ua ro ẽji ro 'ñe mbös'üji. O ẽjẽji c'ua, o nichiji nza yeje c'o bü, ya mi ne ro nguibi c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","E Simón Pedro 'ma mü o jñanda c'o jmõ, o ndüñijõmü a jmi e Jesús, o xipji: ―Nu'tsc'e ín Jmuts'ügö, rí sũ rgá bübü in jmigue. Na ngue me na s'ozgö, rí tũ ín nzhubü, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Me mi sũ e Simón Pedro na ngue ma puncjü c'o jmõ c'o vi zürüji. Xo mi sũ c'o mi dyoji e Pedro cja c'e bü. ");
INSERT INTO mazNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Xo mi sũ e Jacobo 'ñeje e Juan c'o mi ngue o̱ t'i e Zebedeo. Mi ngue o̱ dyoji e Simón Pedro. E Jesús o xipji c'ua e Simón: ―Dya rí sũ; chenngue dya co nutscö. Nu'tsc'e mi mbëjmõgue, mi tennc'e o jmõ. Pero nudya rá jí'ts'i rí zopjü yo nte, ngue c'ua ra dyä'tc'äji ra ndennc'eji, xo ra creozüji. ");
INSERT INTO mazNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nuc'ua e Simón Pedro 'ñe c'o o̱ dyoji cjanu o pjons'üji a squina c'e bü. O zogüji texe nu, o möji e Jesús, ngue c'ua ro dyätpäji o̱ jña. ");
INSERT INTO mazNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","'Na nu pa, e Jesús mi bübü cja 'na jñiñi nu ja xo mi bübü 'na bëzo c'ü me mi sö o lepra. C'e bëzo 'ma o jñanda e Jesús, o ẽjẽ o 'ñe ndüñijõmü a jmi, o dyötü ro jocü, o xipji: ―Nu'tsc'e ín Jmuts'ügö, nu 'ma i̱ṉ ne'e, sö rí jocüzü ne lepra, eñe c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","E Jesús o c'uana c'ua o̱ dyë o ndörü, o xipji: ―Rí negö ra jogüts'ügue, eñe. Jo ni c'ueñe c'ua c'e lepra. ");
INSERT INTO mazNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","E Jesús o xipji c'ua c'e bëzo: ―Dya cjó rí ma xipjigue ja va jogüts'ü. Nguextjo c'e mböcjimi rí ma jíchitsjë c'ü ya jogüts'ü. Cja rrĩ unügue c'ua, ja c'o nzi va manda e Moisés. Nuc'ua ra mbãrã yo nte c'ü ya jogüts'ü, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Zö vi xipji e Jesús c'e bëzo c'ü dya cjó ro xipji, pero xenda go mamaji c'o mi cja e Jesús. Nguec'ua o ẽjẽ na puncjü o nte ro dyäräji e Jesús, y ngue c'ua e Jesús ro jocü c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nguec'ua e Jesús mi xõgü mi pa cja c'e majyadü nu ja dya cjó mi ndeñe, mi ötü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","'Na nu pa e Jesús mi xöpü c'o nte. Xo mi cãrã nu, ja nzi c'o fariseo 'ñe ja nzi c'o mi xöpü o̱ ley Mizhocjimi. Vi 'ñeji texe cja c'o jñiñi c'o mi tsja a Galilea 'ñe c'o mi tsja a Judea. Xo mi cãrã c'o vi 'ñeje a Jerusalén. C'ü o̱ poder Mizhocjimi mi bübüvi co e Jesús ro jocü c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","O ẽjẽ c'ua ja nzi bëzo c'o ma tuns'ü 'na bëzo cja 'na pjinguã. C'e bëzo, dya mi sö ro 'ñõmü. Mi ne ro tsjocüji nu ja ma bübü e Jesús, ngue c'ua ro ngöbüji a jmi ro jocü. ");
INSERT INTO mazNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero dya sö ja rvá tsjocüji, na ngue me mi ndüji nu cja c'e ngumü. O ndes'eji c'ua a xes'e cja c'e ngumü. O xo's'üji c'ua c'o mi t'üs'ü, cjanu o sjö'büji c'e bëzo a jmi e Jesús a nde cja c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nguec'ua o unü ngüenda e Jesús c'ü mi junt'ü o̱ mü'büji c'ü ro tsja angueze ro jocü c'e bëzo. Nguec'ua o mama c'ua e Jesús o xipji c'e bëzo: ―Nu'tsc'e sẽ, rá perdonaots'ü dya in nzhubü, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nuc'ua c'o xöpüte 'ñe c'o fariseo o nguijñiji: “¿Pje pjëzhi ne bëzo nu mama perdonao o nzhubü? Chjëntjovi c'ü ro zadü Mizhocjimi nu. Maco dya cjó sö ra perdonao o nzhubü; nguextjo Mizhocjimi.” ");
INSERT INTO mazNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mi pãxtjo e Jesús c'o mi cjijñi anguezeji, nguec'ua o xipjiji c'ua: ―¿Jenga i̱ṉ cjijñiji a cjanu in mü'büji? ");
INSERT INTO mazNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ró xipji ne bëzo: “Rá perdonaots'ü dya in nzhubü”, ró embe, pero dya cjó sö ra mbãrã cjo ya ma o̱ nzhubü. Pero 'ma rá xipji ne bëzo: “Rí ñanga rí nzhodü”, rá embe; nu 'ma ra nanga c'ua ne bëzo ra nzhodü, nu'ma, ixtí pãrãgueji 'ma c'ü dya rí on'c'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nutscö rvá ẽjẽ cja Mizhocjimi, ya ch'acö poder cja ne xoñijõmü rá perdonaots'üji c'o na s'o c'o i̱ṉ cjaji. Unnc'eji dya ngüenda ngue c'ua rí pãrãji c'ü rí pë'sc'ö c'e poder, embeji. Cjanu o zopjü c'ua c'e bëzo c'ü dya mi sö ro 'ñõmü, o xipji: ―Rí ñanga, chunsc'e nu in pjinguã nu i̱ṉ os'ü, ma'a in nzumü, embeji c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","O nanga c'ua c'e bëzo c'ü dya mi sö ro 'ñõmü. Texeji o jñandaji 'ma mü o nanga c'e bëzo. Nuc'ua c'e bëzo o nduns'ü c'ü o̱ pjinguã c'ü mi os'ü, cjanu o ma o̱ ngumü, me mi unü 'na pöjö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","C'o nte, me go pizhiji go mamaji: ―Me na nojo Mizhocjimi. Nudya ró jandaji yo me na nojo. ¿Cjó ro nguijñi c'ü ri pë's'i poder a cjanu 'na nte? ");
INSERT INTO mazNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","O mbedye c'ua nu e Jesús, o jñanda 'naja bëzo c'ü mi chjũ e Leví c'ü mi cobra o contribución. Mi junrü nu ja mi cobraji o contribución. E Jesús o xipji c'ua: ―Chenngue co nutscö rí dyätcä ín jña. ");
INSERT INTO mazNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nuc'ua e Leví o zogü texe c'e bëpji c'ü mi cja, o böbü o mëvi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","E Leví o manda o dyät'äji o jñõnü cja nu ngumü, o mbita e Jesús. Xo ma'a nu, na puncjü c'o mi cobra o contribución, o ma ziji o xëdyi e Jesús 'ñe e Leví. ");
INSERT INTO mazNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","C'o xöpüte 'ñe c'o fariseo mi so'büji ma xipjiji c'o o̱ discípulo e Jesús: ―¿Jenga 'natjo c'ua i̱ṉ sigueji o xëdyi yo cobra o contribución yo me cja c'o na s'o? ");
INSERT INTO mazNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","O ndünrü c'ua e Jesús o xipjiji: ―Nu c'ü dya sö'dyë, dya ni jyodü o médico. C'o ni jyodü o médico, ngueje c'o sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Je xo ga cjatjonu, dya ngue c'o cjapü cja na jo c'ü rvá 'ñe xipji ra nzhogü o̱ mü'büji cja Mizhocjimi; ngue c'o pãrã tũ o̱ nzhubü. ");
INSERT INTO mazNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","O xipjiji c'ua e Jesús: ―C'o o̱ discípulo e Juan me mbempjeji y me ötüji Mizhocjimi. Je xo ga cjatjonu c'o o̱ discípulo c'o fariseo. Maco yo in discípulogue siji o xëdyi 'ma mbempje c'o 'ñaja. ");
INSERT INTO mazNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","O ndünrü c'ua e Jesús o xipjiji 'na jña, ngue c'ua ro mbãrãji jenga dya mi mbempje c'o o̱ discípulo. O xipjiji: ―'Ma ra chjüntü 'na sẽ'ẽ, 'ma dya be cjuarü c'e chjüntü, dya sö rí tsjapüji c'o o̱ dyoji ra nzhumüji. Na ngueje xe ri bübütjo c'e sẽ a nde anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero ra zädä c'o pa 'ma ra zinbiji c'e sẽ. Nuc'ua cja ra mbempjeji rgá nzhumüji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","O sido o ña e Jesús o xipjiji c'ü 'na ejemplo: ―'Ma cjó c'o cãjã 'na zëbitu c'ü ya xüt'ü, dya ra xü't'ü 'na bitu c'ü nuevo cja rrũ mbä't'ä cja c'e zëbitu. Na ngue 'ma rga cjanu, ra s'odü 'ma c'ü cja dadyo. Y c'e ts'ipëraso c'ü vi xü't'ü cja c'ü cja dadyo, dya xo ra chjënjui c'e zëbitu. ");
INSERT INTO mazNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yo nte, dya xich'iji o õt'apjü cja zëcuëro. Na ngue ro xüt'ü c'o zëcuëro, ro pjödü c'e t'apjü. Y dya cja ro jogü c'ua c'o zëcuëro. ");
INSERT INTO mazNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ni jyodü ra xich'iji o õt'apjü cja cuëro c'o cja nuevo, ngue c'ua dya ra s'odü o cuëro ra pjödü c'e t'apjü. O mama a cjanu e Jesús ngue c'ua ro unü ngüenda c'o nte 'ma ro dyätpäji o̱ jña, pero 'ma ro sido ro tsjaji c'o tjũrü c'o mi cjaji, ro s'odü o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Xo mama e Jesús, 'ma cjó c'o me sũpü c'o o̱ tjũrü c'o ín mboxatitaji, nu 'ma ra dyärä ja ga cja o̱ 'ñiji angueze, nu'ma, 'na ra mama c'e nte: “Dya rí negö, na ngue xenda na jo ne 'ñiji nu ya rí pagö.” ");
INSERT INTO mazNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","'Na c'o pa c'o mi söya c'o mi menzumü a Israel, e Jesús 'ñe c'o o̱ discípulo mi cjogüji nu ja mi cja o ndëxü. C'o discípulo mi tücüji o ñirëxü, mi tjõ't'ü co o̱ dyëji, cja ma zaji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mi cãrã ja nzi c'o fariseo c'o o xipji c'o discípulo: ―¿Jenga i̱ṉ tücüji o ñirëxü? Maco mama c'ü o̱ ley Mizhocjimi c'ü dya sö rá cjaji a cjanu yo pa yo rí söyaji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji ya i̱ xörügueji nu c'ü o tsja e David 'ñe c'o mi dyoji, 'ma ya mi sant'aji; maco dya i̱ṉ so'büji angueze. ");
INSERT INTO mazNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","O cjogü e David cja o̱ ngumü Mizhocjimi nu ja ma sjũ. Cjanu o jñü c'ua c'o tjõmëch'i c'o mi jũsp'üji Mizhocjimi nu. Nuc'ua e David 'ñe c'o mi dyoji o ziji c'o tjõmëch'i. Maco mama c'e ley c'ü dya cjó mi sö ro zi c'o; mi nguextjo mböcjimi c'o mi sö ro zi c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","O sido o ña e Jesús o xipjiji: ―Nutscö rvá ẽcjö cja Mizhocjimi, sö rá mangö ja rgui sũpüji yo pa yo rí söyaji, embeji c'o xöpüte 'ñe c'o fariseo. ");
INSERT INTO mazNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nuc'ua c'ü xe 'na nu pa c'ü mi söyaji, o cjogü e Jesús a mbo cja c'e nintsjimi. Cjanu o jíchi c'o nte. Mi bübü nu 'na bëzo c'ü mi dyot'ü o̱ jodyë. ");
INSERT INTO mazNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","C'o xöpüte 'ñe c'o fariseo me mi jandaji e Jesús, mi nuji cjo ro jocü o nte c'e pa c'ü mi söyaji. Mi jodüji ja rvá ngöt'üji e Jesús cja c'o pje mi pjëzhi. ");
INSERT INTO mazNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","E Jesús ixmi pãrã c'o na s'o c'o mi mbeñe anguezeji. O xipji c'ua c'e bëzo c'ü mi dyot'ü o̱ dyë: ―Böbügue, rgui 'ñeje a nde, eñe. Cjanu o böbü c'ua c'e bëzo o ma a nde. ");
INSERT INTO mazNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nuc'ua e Jesús o xipji c'o xöpüte 'ñe c'o fariseo: ―Rá cja'c'üji 'na t'önü. ¿Ja ngue c'ü mama c'ü ín leygöji rá cjaji yo pa yo rí söyaji? ¿Cjo mama rá cjaji c'o na jo o rá cjaji c'o na s'o? ¿Cjo mama rá pjös'üji yo nín minteji o rá pö't'üji?, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nuc'ua e Jesús o nguinch'i na jo texe c'o nte c'o mi cãrã a jmi. Cjanu o xipji c'e bëzo: ―C'uana in dyë, eñe. Cjanu o c'uana c'ua o̱ dyë, y ixco jogü c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero c'o xöpüte 'ñe c'o fariseo me go sjëyaji, mi pötma mamaji ja rvá sö pje ro tsjapüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","C'o pa c'o, o ma e Jesús cja t'eje. 'Naxõmü va dyötü Mizhocjimi nu. ");
INSERT INTO mazNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nuc'ua 'ma mü o jyas'ü, o ma't'ü c'o o̱ discípulo. Cjanu o xõcü doce anguezeji c'o xo jñusp'ü o̱ tjũ apóstole. ");
INSERT INTO mazNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","O juajnü e Simón c'ü xo jñusp'ü e Pedro. Xo juajnü e Andrés c'ü nu cjuarma e Simón. Xo juajnü e Jacobo 'ñe e Juan 'ñe e Felipe 'ñe e Bartolomé. ");
INSERT INTO mazNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Xo juajnü e Mateo 'ñe e Tomás 'ñe e Jacobo c'ü mi t'i cja e Alfeo. Xo juajnü e Simón c'ü mi revolucionario. ");
INSERT INTO mazNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Xo juajnü e Judas c'ü nu cjuarma e Jacobo. Xo juajnü e Judas Iscariote, nu c'ü ro mbö e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","E Jesús 'ñe c'o o̱ discípulo o zöbüji c'ua cja c'e t'eje, o zät'äji cja 'na batjü o böbüji nu. Mi cãrã nu na puncjü o nte c'o mi dyoji e Jesús c'o mi ätpä o̱ jña. Xo mi cãrã na puncjü c'o 'ñaja nte. Vi 'ñeji a Judea 'ñe a Jerusalén. Je xo vi 'ñeji texe a squina c'e mar a ma a Tiro 'ñe a Sidón. Vi 'ñeji ro 'ñe dyäräji e Jesús. Xo vi 'ñeji ngue c'ua e Jesús ro jocü c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nuc'ua e Jesús o jocüji hasta c'o vi zürü c'o o̱ s'ondajma e Satanás nu c'ü dya jo, xo jocü c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Texe c'o nte mi jodü ja rvá ndörüji e Jesús, na ngue mi pë's'i o̱ poder mi jocü c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nuc'ua e Jesús o jñanda c'o nte c'o mi dyoji c'o mi ätpä o̱ jña, o xipjiji: ―Nu'tsc'eji zö i̱ṉ pöbreji, pero 'ma i̱ṉ jodügueji Mizhocjimi, ngue c'ü rgui mäcjeji. Na ngue ya ngue in Jmugueji dya Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Zö i̱ṉ sant'aji dya, pero ngue c'ü rgui mäcjeji. Na ngue Mizhocjimi ra dya'c'üji c'o me nda na jo, dya pje ra bë'ts'iji. ’Zö me i̱ṉ nzhumüji dya, pero ngue c'ü rgui mäcjeji. Na ngue Mizhocjimi ra tsja'c'ü me rí mäcjeji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’I̱ṉ ätcäji ín jñagö nutscö rvá ẽjẽ cja Mizhocjimi. Nguec'ua bübü 'ma ra nuc'üji na ü yo in menzumügueji, ra pjongüts'üji a nde anguezeji ra xi'ts'iji c'o me na s'o rgá zanc'eji. Zö ra tsja'c'üji a cjanu, pero ngue yo rgui mäcjeji yo. ");
INSERT INTO mazNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","C'o pa 'ma ra tsja'c'eji ga cjanu, me rí mäcjeji na puncjü. Na ngue Mizhocjimi a jens'e ra ngõ'tc'üji na jo. C'o in mboxpalegueji xo tsjaji a cjanu o tsjapüji o sufre c'o profeta c'o mi cãrã mi jinguã. ");
INSERT INTO mazNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’'Ma i̱ṉ ricoji, nu 'ma i̱ṉ mäpäji c'o i̱ṉ pë's'iji, nu'ma, juentsc'eji 'ma, na ngue ra tsja'c'üji Mizhocjimi rí sufreji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’'Ma i̱ṉ pëzhgueji c'ü dya pje bë'ts'iji, juentsc'eji. Na ngue ra tsja'c'üji rí sant'aji. ’'Ma me i̱ṉ mäjä gui minc'eji dya, 'ma dya i̱ṉ mäpqueji Mizhocjimi, juentsc'eji. Na ngue ra tsja'c'üji me rí nzhumüji me rí huëgueji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Juentsc'eji na ngue c'ü ra tsja'c'üji Mizhocjimi, nu 'ma ra mama texe yo nte c'ü na jots'üji. Je xo va cjanu va tsja c'o in mboxpalegueji, o mamaji c'ü me ma jo c'o profeta c'o dya ma cjuana. ");
INSERT INTO mazNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Nu'tsc'eji i̱ṉ äräji, rí xi'ts'iji rí s'iyagueji c'o i̱ṉ üji, rí tsjaji na jontets'üji cja c'o nuc'üji na ü. ");
INSERT INTO mazNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Rí ma'tp'üji Mizhocjimi c'o sanc'üji. Xo rí dyötpüji Mizhocjimi c'o jün'sc'üji o bëchjine. ");
INSERT INTO mazNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","'Ma cjó c'o ra yapc'ü in jmiji cja in jodyëji, xo rí jyëziji ra yapc'üji c'ü 'na lado. 'Ma cjó c'o ra ngannc'aji c'ü i̱ṉ tëjëji, xo rí jyëziji ra ngannc'aji c'ü i̱ṉ jeji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","'Ma cjó c'o pje ra dyö'tc'üji, unüji c'ü ni jyodü c'o. 'Ma cjó c'o pje ra jñünnc'üji 'ma ngue in tsjacjeji, dya cja rí dyötüji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","C'ua ja nzi gui ñegueji c'ü ra s'iyats'üji yo nte, je xo rgui s'iyagueji a cjanu anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’'Ma nguextjo c'o s'iyats'üji c'o i̱ṉ s'iyaji, ¿ja bübü c'o na jo c'o i̱ṉ cjagueji 'ma? Maco c'o cja na s'o, xo s'iyaji c'o s'iya anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nu'tsc'eji, 'ma nguextjo c'o pjöxc'üji c'o i̱ṉ pjös'üji, ¿ja bübü c'o na jo c'o i̱ṉ cjagueji 'ma? Maco c'o cja na s'o, xo pjös'üji c'o pjös'ü anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nu 'ma nguextjo c'o pe'sc'eji c'o i̱ṉ pesp'eji, ¿ja bübü c'o na jo c'o i̱ṉ cjagueji 'ma? Maco c'o cja na s'o, pötca pesp'eji 'ma pje c'o ni jyodü c'o o̱ dyoji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Rí s'iyagueji c'o i̱ṉ üji, rí tsjaji na jontets'üji y rí pesp'eji. Dya rí pëtsaji c'ü pje ra nzhocüts'üji. 'Ma rí tsjaji a cjanu, ra ngõ'tc'üji na jo 'ma Mizhocjimi c'ü bübü a jens'e. Y ra jñetse ngue o̱ t'its'üji 'ma angueze. Na ngue me na jo angueze, me pjös'ü texe yo nte, zö cãrã c'o na s'o c'o dya unü 'na pöjö. ");
INSERT INTO mazNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Rí juentsqueji yo nte c'ua ja nzi ga juen'tsc'eji Mizhocjimi c'ü ín Tataji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Dya cjó rí so'büji. 'Ma jiyö, ra jñün'c'eji ngüenda Mizhocjimi. Dya cjó rí xipjiji: “Na s'ots'ügue”, rí 'ñembeji. 'Ma jiyö, xo ra mama Mizhocjimi: “Na s'ots'ügueji”, ra 'ñents'eji. Nguextjo Mizhocjimi ra mama ja ngue c'ü na jo y ja ngue c'ü na s'o. Rí perdonaogueji yo nin minteji; Mizhocjimi ra perdonaots'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","'Ma cjó c'o pje ni jyodü, rí unügueji. Mizhocjimi ra dya'c'eji c'ua texe c'o ni jyodüts'üji, hasta ra mboncjütjo. Ra dya'c'üji c'ua ja nzi gui unnc'eji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","O sido o ña e Jesús o xipjiji: ―¿Ja gui tsjijñiji? ¿Cjo sö 'naja ngorö ra jíchi o 'ñiji c'ü 'na ngorö? Dya sö. Na ngue ra zo'ovi cja t'ore nza yejui. ");
INSERT INTO mazNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","'Na c'ü cja xötpü, dya xo'ñi cja c'ü nu xöpüte. Cja ra xötpü na jo. Nu'ma, ya ri nza cja c'ü nu xöpüte 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","’¿Jenga i̱ṉ so'büji yo nin minteji? Maco c'o na s'o c'o cja'a yo nin minteji, pe ts'iquë nza cja 'na ngümpaxa c'ü ri o'o o̱ ndö 'na nte, pero c'o na s'o c'o i̱ṉ cjagueji, na nojo nza cja 'na dyaxü. ¿Jenga dya i̱ṉ unnc'eji ngüenda c'o na s'o c'o i̱ṉ cjagueji? ¿Pje ma jmi i̱ṉ pë'sc'eji c'ü i̱ṉ xiqueji yo nin minteji: “Jyëzguijme rá cjü'pc'öjme ne ngümpaxa nu o'o nin chögue”, i̱ṉ embeji? Maco dya ixi cjübügueji c'o dyaxü c'o o'o in chögueji. Nu'tsc'eji i̱ṉ cjapqueji na jots'üji, pero dya cjuana. C'ü rí tsjagueji, ot'ü rí tsjünc'eji c'o dyaxü c'o o'o in chögueji, ngue c'ua ra sö rí jñandaji na jo rí tsjü'p'üji c'e ngümpaxa c'ü o'o a nzhö c'ü nin minteji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","O sido o ña e Jesús o xipjiji: ―'Na za'a, 'ma dya quis'i o fruta, dya sö ra mamaji na jo c'ü. Pero 'ma quis'i o fruta, dya sö ra mamaji na s'o c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nzi 'naja za'a 'mãrã co c'o quis'i. Dya quitsiji o higo cja o bidyi; dya xo quitsiji o uva cja o pëdyi. ");
INSERT INTO mazNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Je xo ga cjatjonu, 'na nte c'ü na jo, mama o jña c'o na jo, na ngue bübü o̱ mü'bü c'o na jo. 'Na nte c'ü na s'o, mama c'o na s'o, na ngue bübü o̱ mü'bü c'o na s'o. C'o bübü o̱ mü'bü 'na nte, ngue c'o ra mbedye o̱ ne. ");
INSERT INTO mazNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Jenga i̱ṉ xitsiji: “Nu'tsc'e Señor, ín Jmuts'ügöjme”, i̱ṉ enzgöji? Maco dya i̱ṉ cjaji c'ua ja nzi rgá xi'ts'iji. ");
INSERT INTO mazNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","C'o ra ẽjẽzügö, 'ma ra dyätcäji ín jña 'ñe 'ma ra tsjaji c'o rí mangö, rá xi'ts'iji cjó chjëntjui c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Chjëntjui nza cja 'na bëzo c'ü ro jyäbä na jo 'na ngumü. Ro dyö'bü na jẽ, cja rrũ ngü'p'ü c'ua c'e cimiento co peña. Nuc'ua 'ma ro c'os'ü c'e ndare, ro pjat'ü na zëzhi cja c'e ngumü. Pero dya ro tunbü, na ngue vi tjäbä co peña. ");
INSERT INTO mazNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero yo o dyärä yo ró xi'ts'iji, 'ma dya ra tsjaji yo, chjëntjui 'na bëzo c'ü ro jyäbä 'na ngumü c'ü dya ro ngü'p'ü o cimiento, ro 'ñe's'etjo a xes'e cja e jõmü. Nuc'ua c'e ndare ro pjat'ü na zëzhi cja c'e ngumü, cja rrũ tunbü c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","E Jesús 'ma mü o nguarü o zopjü c'o nte, cjanu o ma c'ua cja 'naja jñiñi c'ü mi chjũ a Capernaum. ");
INSERT INTO mazNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Cja c'e jñiñi mi bübü nu 'naja bëzo c'ü mi manda c'o tropa romano. Mi 'ñeje 'na mbëpji c'ü mi s'iya, c'ü mi sö'dyë, ya mi ngue ro ndũ. ");
INSERT INTO mazNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nuc'ua c'ü mi manda c'o tropa, o dyärä c'o mi cja e Jesús mi jocü c'o mi sö'dyë. O tsja c'ua c'e bëzo o zopjü ja nzi c'o pje mi pjëzhi cja c'o menzumü a Israel, o xipjiji: ―Möji, ma dyötüji favor e Jesús rí xipjiji ra ẽjẽ ra 'ñe jocü nu ín mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","C'o pje mi pjëzhi o möji c'ua cja e Jesús, o ma xipjiji: ―Rvá 'ne ö'tc'üjme favor. Sö'dyë c'ü o̱ mbëpji c'e bëzo c'ü manda cja c'o tropa; va pen'c'e 'na jña c'e bëzo rí mague, rí ma tsjapü ra ndis'i c'ü o̱ mbëpji. Na jo rí mague. ");
INSERT INTO mazNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Na ngue zö dya ín menzumügöji c'e bëzo, pero s'iyazügöji nutscöji rí menzumüji a Israel. Nutscöjme o jyäpcäjme ín nintsjimijme, embeji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","O ndünrü c'ua e Jesús o xipjiji: ―Mö. Cjanu o möji c'ua. 'Ma ya mi ngue ro zät'äji cja c'ü o̱ ngumü c'e bëzo c'ü mi manda c'o tropa, cjanu o tsja c'e bëzo o xipji ja nzi c'o o̱ dyoji: ―Möji ma chjünrüji e Jesús. Cjanu o möji c'ua. 'Ma mü o chjëji e Jesús 'ñe c'o pje mi pjëzhi, o xipjiji c'ua e Jesús c'ua ja nzi va mama c'e bëzo: ―Rvá 'ñe tjün'c'üjme rá xi'ts'ijme c'ü mama c'e bëzo c'ü manda c'o tropa. Nuc'ü, mama a cjava: “Perdonaozü ró ö'tc'ü favor ri mague ín nzumügö, pero dya ni jyodü. Nu'tsc'e me na jotsc'e, nuzgö rí tũgö ín nzhubü. Nguec'ua dya rí tsjogü cja ín nzumü. ");
INSERT INTO mazNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nguec'ua dya rvá ma nu ja mi bünc'e ro ö'tc'ü ri ma tsjapü ra ndis'i c'ü ín mbëpjigö. Pero 'ma rí mamague c'ü ra jogü c'ü ín mbëpji, rí pãrãgö ra jogü 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nza cjazgö, o ch'acügö rí manda cja c'o tropa. 'Ma rí xipjigö 'na tropa ra ma'a ra ma tsja 'na bëpji, jo rrũ ma c'ua. 'Ma rí xipji c'ü 'na tropa ra ẽjẽ, ra ẽjẽ c'ua. Y 'ma rí xipji c'ü ín mbëpji ra tsja 'na bëpji, ra tsja c'ua. Nguec'ua rí pãrãgö 'ma rí mamague c'ü ra jogü c'ü ín mbëpji, ra jogü 'ma”, eñe c'e bëzo va penpe 'na jña e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","E Jesús 'ma mü o dyärä c'e jña c'ü vi pejñe c'e bëzo, me co mäjä na ngue c'e bëzo mi junt'ü o̱ mü'bü c'ü ro tsja e Jesús ro jocü c'e mbëpji. Cjanu o ñezhe c'ua e Jesús o xipji c'o nte c'o mi pöji: ―Dyäräji na jo c'ü rá xi'ts'iji. Nutscöji rí menzumüji a Israel rí ma't'üji Mizhocjimi, pero dya cjó rí töt'ügö yo ín menzumüji c'ü ri ench'e o̱ mü'bü Mizhocjimi c'ua ja nzi ga tsja c'e bëzo c'ü junt'ü o̱ mü'bü c'ü rá cjapü ra ndis'i c'ü o̱ mbëpji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","C'o vi ma ndünrü e Jesús, cjanu o nzhogüji c'ua cja o̱ ngumü c'e bëzo, o 'ñe chöt'üji c'ü ya vi ndis'i c'e mbëpji c'ü mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","'Na nu pa, o mbedye e Jesús nu ja mi bübü, ro ma cja 'naja jñiñi c'ü mi chjũ'ũ a Naín. Mi pöji angueze na puncjü c'o o̱ discípulo 'ñe na puncjü c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","'Ma ya mi ngue ro zät'äji cja o̱ ngoxtji c'e jñiñi a Naín, o jñandaji c'ua ma pedye o nte ma tuns'üji 'na añima ro ma dyögüji. Mi nguextjo c'e t'i c'ü mi 'ñeje c'ü nu nana. Ya vi ndũ c'ü nu xĩra c'e ndixũ. Mi pöji c'e ndixũ na puncjü c'o o̱ menzumüji. ");
INSERT INTO mazNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nuc'ua e Jesús c'ü ín Jmugöji, 'ma mü o jñanda me mi huë c'e ndixũ, me go sentio o xipji c'ua: ―Dya rí huë, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Cjanu o ẽjẽ c'ua e Jesús a jmi cja c'e caja, cjanu o 'ñe's'e o̱ dyë. C'e caja, dya mi cjo'bü. C'o mi tuns'ü c'e caja o böbüji. Cjanu o mama c'ua e Jesús o xipji c'e añima: ―Nu'tsc'e sẽ, rí xi'tsc'ö rí ñanga. ");
INSERT INTO mazNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Go nanga go mimi c'ua c'e t'i c'ü mi añima, y cjanu o ña c'ua. O mama c'ua e Jesús o xipji c'e ndixũ: ―Bübü dya va nin ch'igue, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","C'o nte, me go pizhiji c'ua texeji o mamaji: ―Me na nojo Mizhocjimi. Ya ndo bübüzgöji 'na profeta nu me na nojo. Nujnu, o 'ñeme Mizhocjimi ra mböxcüji nutscöji o̱ ntezgöji, eñe c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Me mi näntji c'ua e Jesús texe a Judea, na ngue vi tsjapü o te c'e t'i c'ü vi ndũ, o bübütjo na yeje. Xo mi näntji e Jesús texe cja c'o jñiñi c'o mi chäjtjoji. ");
INSERT INTO mazNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nuc'ua c'o o̱ discípulo e Juan o möji, o ma xipjiji e Juan c'o mi cja e Jesús. Nuc'ua e Juan o juajnü yeje c'o discípulo c'o vi säjä. ");
INSERT INTO mazNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Cjanu o xipjivi: ―Mëvi cja e Jesús, rí ma dyönüvi a cjava: “¿Cjo ngue'tsc'e c'ü rí te'bejme ra ẽjẽ, o rá te'bejme c'ü 'naja”, rí 'ñembevi c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nuc'ua cjanu o ma c'ua c'o bëzo o zät'ävi cja e Jesús, cjanu o xipjivi: ―C'ü rvá ẽgöbe; e Juan c'ü mi jichi yo nte cja c'e ndare a Jordán o xitsibe ro 'ñe önnc'übe, ¿cjo ngue'tsc'e c'ü rí te'bejme, o rá te'bejme c'ü 'naja? ");
INSERT INTO mazNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","C'e ndajme 'ma mi bübü nu c'o o̱ discípulo e Juan, e Jesús mi jocü na puncjü o nte c'o me mi sufre o ngueme. Xo mi cãrã nu na puncjü o nte c'o vi zürü o̱ s'ondajma e Satanás c'ü dya jo. E Jesús o tsjapü o mbedye c'o s'ondajma c'o. Y na puncjü c'o mi ndëzhö, o jocü e Jesús ngue c'ua va jñanda c'o mi ndëzhö. ");
INSERT INTO mazNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nuc'ua e Jesús cjanu o xipji c'o yeje o̱ discípulo e Juan: ―Nzhogü rí mëvi cja e Juan, rí ma xipjivi nu yo i̱ jñandavi ró cjagö. Xo rí xipjivi yo i̱ dyärävi ró xipjigö yo nte. Xipjivi ya janda yo mi ndëzhö, 'ñe yo mi me'dye ya nzhodüji na jo. Xipjivi e Juan, yo mi sö o lepra c'ü vi pëgaji, ya jogü yo. Xipjivi, yo mi ngogõ, ya äräji dya. Y bübü c'o ya vi ndũ y go tetjoji, ya bübütjoji dya. Xipjivi e Juan c'ü rí zopjügö yo pöbre rí xipjiji ja rgá jogü o̱ mü'büji cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Xipjivi, 'ma cjó c'o ra sido ra 'ñejmezü y dya ra yembeñe c'ü rguí xõgü co nutscö, ngue c'ü rguí mäjä c'o, eñe e Jesús va xipji c'o o̱ discípulo e Juan. ");
INSERT INTO mazNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","O ma c'ua c'o o̱ discípulo e Juan. Nuc'ua e Jesús o zopjü c'o nte o xipjiji ja ma cja e Juan, o dyönüji: ―'Ma i̱ möcjeji a ma cja c'e majyadü i̱ ma ñuji e Juan, pe mi cjijñiji rvi chöt'üji 'na bëzo c'ü ri pötpü o̱ jña, nza cja ga pötü o̱ lugar 'na xitji 'ma juant'ü e ndajma. ");
INSERT INTO mazNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pe mi cjijñigueji rvi chöt'üji 'na bëzo c'ü ri je'e bitu c'o me ni muvi. Tsjijñiji; c'o je'e bitu c'o me ni muvi, ngue c'o rey 'ñe c'o cãrã cja o̱ palacio. ");
INSERT INTO mazNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","'Ma i̱ ma ñuji e Juan, pe mi cjijñiji rvi chöt'üji 'naja profeta. Jã, rí mangö ngue 'na profeta e Juan. Pero xenda ni muvi o̱ bëpji angueze que na ngue c'o 'ñaja profeta. ");
INSERT INTO mazNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Je t'opjü o̱ jña Mizhocjimi ja ga cja e Juan c'ü mama a cjava: Dyärä, ró juajnügö 'na bëzo ra zopjü yo nte ra xipjiji ín jñagö. Ra ot'ü in xo'ñigue ngue c'ua 'ma rí mague, ya rguí bübü dispuesto yo nte ra recibidots'üji, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Rí xi'tsc'öji, cja yo nte, dya cjó ch'unü 'na bëpji c'ü rrĩ muvi nza cja c'ü o unü Mizhocjimi e Juan. Zö me ma nojo c'e bëpji c'ü mi pë's'i e Juan, 'ñe me ma zö, pero xenda na zö 'ma cjó c'o ra tsjapü Mizhocjimi o̱ nte, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","C'o nte 'ma mü o dyäräji c'e jña c'ü vi mama e Jesús, o unüji ' na pöjö Mizhocjimi. Xo 'ñe c'o mi cobra o contribución. Na ngue vi möji cja e Juan, vi ma ji'iji y vi nzhogü o̱ mü'büji cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero c'o fariseo 'ñe c'o mi xöpü c'o ley, iyö c'o. Vi tsjapüji c'ü dya mi muvi c'e bëpji c'ü vi ch'unü e Juan, dya go ma jiji. Maco Mizhocjimi vi mbeñe ro perdonao texe c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","O mama c'ua e Jesús: ―Rá xi'tsc'öji ja ga cja yo nte yo cjë yo rí cãrãji dya, c'o dya dyätä e Juan ni ri nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Anguezeji chjëntjui nza cja yo ts'it'i yo junrü cja chõjmü yo eñe cjaji o mbaxua, ma't'üji o̱ dyoji mamaji: “Ró pjë'pc'ijme o flauta, pero nu'tsc'eji dya i̱ nemeji”, embeji yo nu dyoji. O 'ma jiyö, eñeji cjaji como que ya vi ndũ 'na nte, eñe pa ögüji c'e añima, xipjiji nu mit'iji: “Me ró nzhumüjme rvá xörüjme, pero nu'tsc'eji, dya i̱ huëgueji”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","C'ua ja nzi ga cja yo ts'it'i, je xo ga cjatjonu yo nte yo cãrã yo cjë dya. 'Ma o mbürü e Juan o mbëpi Mizhocjimi, o xõgü, dya cjó go zivi o xëdyi c'ü rví mäjä. Nguec'ua yo nte mamaji: “E Juan pë's'i 'naja o̱ s'ondajma c'ü dya jo”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nuc'ua nutscö rvá ẽcjö cja Mizhocjimi, rí mäjä rgá sigöji o xëdyi. Nguec'ua ga mama c'o nte c'o dya ne ra dyärä o̱ jña Mizhocjimi: “Chjã, 'naja bëzo nu me ñõnü, y me si o vinu. Me xo joji yo cobra o contribución, 'ñe yo 'ñaja yo xiji na s'o”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero rí xi'tsc'öji, c'o ätä Mizhocjimi unüji na jo ngüenda Mizhocjimi me cjijñi na jo o̱ ñi, me pãrã na jo c'ü cja'a; nguec'ua nde nan'ño bëpji va dyacöbe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","'Na nu pa, 'naja c'o fariseo o mbita e Jesús ro ma o̱ ngumü ro ziji o xëdyi. O ma c'ua e Jesús o zät'ä cja o̱ ngumü c'e bëzo, o cjogü a mbo cjanu o ziji o xëdyi c'e bëzo c'ü vi mbita. ");
INSERT INTO mazNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Cja c'e jñiñi mi bübü ' na ndixũ c'ü mi cja na puncjü c'o na s'o. O mbãrã c'ua c'e ndixũ c'ü mi bübü e Jesús cja o̱ ngumü c'e bëzo mi siji o xëdyi. Cjanu o ẽjẽ c'ua c'e ndixũ cja o̱ ngumü c'e bëzo, ma tũ'ũ 'na ts'ibotia de ndojo c'ü mi po'o o aceite c'o ma jo ma jyärä. ");
INSERT INTO mazNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Cjanu o ẽ ndüñijõmü cja o̱ ngua e Jesús. Me mi huë c'e ndixũ, me co mbögü o̱ nguizhö va mbe'chp'e o̱ ngua e Jesús. Nuc'ua co c'o o̱ ñixte, cjanu o ndintspi o̱ ngua, y me co zü'tp'ü o̱ ngua. Cjanu o ndũ c'ua c'e aceite c'ü vi tũ, o ngosp'ü o̱ ngua. ");
INSERT INTO mazNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","C'e fariseo c'ü vi mbita e Jesús, 'ma mü o jñanda c'o mi cja c'e ndixũ, cjanu o nguijñitsjë c'ua: “Ne bëzo, 'ma na cjuana ri profeta nu, ro mbãrã 'ma cjó ngue ne ndixũ nu na tjörü. Ro mbãrã pje ma ndixũ nu, ro mbãrã c'ü me cja na s'o nu.” ");
INSERT INTO mazNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","O mama c'ua e Jesús o xipji c'e fariseo: ―Simón, bübü 'na jña c'ü rí ne rá xi'ts'i. O ndünrü c'ua c'e bëzo: ―Xitsigö, xöpüte. ");
INSERT INTO mazNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","O mama c'ua e Jesús: ―Mi bübü yeje bëzo c'o mi tũ ngüenda mi tunpüji 'na bëzo. C'ü 'naja mi tũ cuatro mil o mbëxo; c'ü 'naja mi tũ cuatro ciento. ");
INSERT INTO mazNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dya mi jünvi pje rví ngõt'üvi. Nguec'ua c'e bëzo o perdonaovi nza yejui. ¿Ja gui tsjijñi yo yeje bëzo yo o perdonaoji? ¿Ja va ngue c'ü xenda ra gradecido ra ne'e c'e bëzo c'ü ya perdonaovi? ");
INSERT INTO mazNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","O ndünrü c'ua e Simón o xipji: ―Pe ngue c'e bëzo c'ü xenda mi tũ na puncjü o merio, xenda ra gradecido c'e bëzo c'ü vi perdonao texe c'o mi tunpü. E Jesús o xipji c'ua: ―Na cjuana c'ua ja vi tsjijñi. ");
INSERT INTO mazNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nuc'ua e Jesús o jñanda c'e ndixũ, cjanu o xipji c'ua e Simón: ―¿Cjo i̱ unü na jo ngüenda c'ü o tsja ne ndixũ? Ró säcjö cja in nzumügue, nu'tsc'e, dya i̱ dyacö ndeje c'ü ro pe'ch'e ín cua, c'ua ja nzi ga cja ín chjũrügöji. Pero ne ndixũ o mbechque ín cua co o̱ nguizhö, cjanu o ndintsqui ín cua co o̱ ñixte. ");
INSERT INTO mazNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nu'tsc'e, dya i̱ sütcü ín jmi; pero ne ndixũ, me sütcü ín cua. ");
INSERT INTO mazNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nu'tsc'e, dya pje i̱ xisqui ín ñi; pero ne ndixũ o ngoscü ín cua o aceite yo na jo ga jyärä. ");
INSERT INTO mazNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","C'ü vi tsja a cjanu ne ndixũ, ixi 'ñetse c'ü o unü ngüenda c'ü tũ na puncjü o̱ nzhubü y ya nzhogü o̱ mü'bü. Nguec'ua Mizhocjimi ra perdonao c'o na puncjü o tsja c'o na s'o. Pero 'ma cjó c'o dya ra unü ngüenda cjo ri tũ o̱ nzhubü, 'ma dya ra unü ngüenda c'ü ni jyodü ra perdonao Mizhocjimi c'ü, nu'ma, dya xo ra neze 'ma c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nuc'ua e Jesús o xipji c'e ndixũ: ―Rí perdonaots'ü c'o na s'o c'o i̱ tsja, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","C'o nte c'o ma siji o xëdyi e Jesús 'ñe e Simón, mi pötma mamaji: ―¿Cjó ngue ne bëzo nu? A poco sö ra perdonaozgöji c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nuc'ua e Jesús o xipji c'ua c'e ndixũ: ―Ya jogü in mü'bügue, na ngue i̱ 'ñench'ezü in mü'bü, i̱ creo c'ü ro perdonaots'ü Mizhocjimi. Ma dya, dya cja rí mbeñe c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","C'o pa c'o, e Jesús mi sät'ä cja texe c'o jñiñi 'ñe c'o ts'ijñiñi. Mi zopjü c'o nte mi xipjiji ja rvá jogü o̱ mü'büji, ngue c'ua Mizhocjimi ro tsjapüji o̱ nte anguezeji. Mi pöji e Jesús c'o doce o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Xo mi pöji e Jesús ja nzi ndixũ c'o vi zürü c'o o̱ s'ondajma e Satanás c'ü dya jo, 'ñe c'o mi sö'dyë. Mi pöji e Jesús na ngue angueze vi pjongü c'o s'ondajma, y vi jocü c'o mi sö'dyë. C'ü 'na ndixũ mi chjũ e María c'ü mi menzumü a Magdala. Nu c'e ndixũ, vi zürü siete c'o o̱ s'ondajma c'ü dya jo, pero vi pjongü e Jesús c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","C'ü 'na ndixũ mi chjũ e Juana. C'e ndixũ, mi ngue o̱ su e Chuza c'ü mi ngue o̱ ngapta e Herodes, mi manda cja c'o o̱ mbëpji. C'ü 'naja ndixũ, mi chjũ e Susana. Xo mi pöji e Jesús c'o 'ñaja ndixũ c'o ma puncjü. Mi pjös'üji e Jesús co c'o o̱ merioji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mi pedye na puncjü o nte cja o̱ jñiñiji, mi pöji e Jesús. 'Na nu pa 'ma ya ma cãji na puncjüji, e Jesús o zopjü c'o nte o xipjiji 'na ejemplo, o mama a cjava: ");
INSERT INTO mazNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―'Na mbonzhëxü o mbedye o ma mbodü o ndëxü. Nuc'ua 'ma ya ma podü, bübü o ts'indëxü c'o o zobütjo cja 'ñiji nu ja mi cjogü o nte. O ẽjẽ c'ua c'o s'ü o 'ñe jñüs'üji c'o ts'indëxü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bübü o ts'indëxü c'o je xo zobütjo nu ja c'o dya ma pizhi e jõmü. Nuc'ua 'ma mü o mbes'e, o dyot'ü c'o ndëxü na ngue mi ojtjo o c'ajõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bübü o ts'indëxü c'o o zobütjo nu ja mi bodü o̱ ndö o bidyi. 'Natjo c'ua va mbes'eji. Ts'i vi nocü c'o bidyi, nguec'ua va mbö't'ütjo c'o ts'indëxü, dya jyëzi ro nocü na nojo. ");
INSERT INTO mazNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bübü o ts'indëxü c'o o zobü c'ua ja ma jo o jõmü. 'Ma ya mü o nocüji, o jogüji na jo o unüji 'naja ciento ts'indëxü nzi 'na mata. 'Ma mü o nguarü o xipjiji a cjanu yo, go ña c'ua na jens'e e Jesús o mama: ―Nu'tsc'eji bübü in tsõgueji, rí dyäräji na jo yo jña yo rí xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nuc'ua c'o o̱ discípulo e Jesús cjanu o dyönüji e Jesús o mamaji: ―¿Pje ne ra mama yo jña yo i̱ xitsijme? ");
INSERT INTO mazNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji o dya'c'üji Mizhocjimi rí pãrãji c'ü dya mi pãrã c'o nte 'ma ot'ü; o dya'c'üji rí pãrãji ja ga manda Mizhocjimi. Yo 'ñaja nte, rí xipjigö o ejemplo yo, ngue c'ua zö ra jñandaji y ra dyäräji, pero dya ra mbãrãji pje pjëzhi c'ü ne ra mama c'o jña. ");
INSERT INTO mazNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’C'e ejemplo c'ü ró xi'ts'iji, je a cjava. C'o ndëxü c'o ró xi'tsc'öji, ngue c'o ró jyë'tsc'öji o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","C'o ndëxü c'o o zobütjo cja 'ñiji, ró jyë'tsc'öji c'o ärä o̱ jña Mizhocjimi. Nuc'ua va ẽjẽ e Satanas c'ü dya jo, va 'ñe jünbü c'o jña cja o̱ mü'büji. Nguec'ua, dya ra 'ñench'e o̱ mü'büji Mizhocjimi. Nguec'ua, dya ra ndintspiji o̱ mü'büji c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","C'o ndëxü c'o o zobütjo nu ja c'o dya ma pizhi o jõmü, ró jyë'tsc'öji c'o me mäjä ga dyärä o̱ jña Mizhocjimi, y me mäjä ga creoji. Pero nujyo, dya jëzitsjë ra zi'ch'i na jo o̱ mü'büji c'o jña. Nguec'ua 'ma va ẽjẽ c'o ra sufreji, dya sido creoji Mizhocjimi, xõgüji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nu c'o ndëxü c'o o zobütjo nu ja mi bodü o̱ ndö o bidyi, rá jyë'tsc'öji c'o ärä o̱ jña Mizhocjimi, nuc'ua me mbeñeji c'o o̱ bëpjiji, 'ñe me jodüji ja rgá ndõji na puncjü o t'opjü, 'ñe me mäpäji yo bübü cja ne xoñijõmü ga tsjaji c'o netsjëji. Nguec'ua, dya cjaji ja nzi ga ne Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","C'o ndëxü c'o o zobü c'ua ja ma jo jõmü, ró jyë'tsc'öji c'o ärä o̱ jña Mizhocjimi c'o creo co texe o̱ mü'bü. Zö pje c'o ra sufreji pero sido nzhodüji cja o̱ 'ñiji Mizhocjimi. Nguec'ua chjëntjui nza cja c'o ndëxü c'o ra jogü na jo. ");
INSERT INTO mazNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’'Ma tjütüji 'naja sivi, dya co'büji co 'naja s'äbä. Dya xo emeji a mbo cja ngama. Je ẽ's'ẽji nu ja na ts'ijens'e, ngue c'ua ra sö ra jñanda c'o ri cjogü a mbo cja ngumü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Je xo ga cjatjonu ín jñagö. Zö rí xi'tsc'ötsjëji dya yo ín jñagö, pero ni jyodü rí xipcjeji yo nte. Zö dya pãrãji, pero ni jyodü ra mbãrãji ngue c'ua ra bübü o̱ jya's'ü Mizhocjimi cja o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Pjötpüji na puncjü ngüenda rí dyäräji na jo yo jña yo rí xi'tsc'öji. 'Ma rí unnc'eji ngüenda yo jña, 'ñe 'ma rí 'ñench'e in mü'bügueji yo, nu'ma, mas rí tendiogueji 'ma yo. Zö i̱ṉ cjijñiji c'ü ya i̱ jñüs'üji 'na jña, pero 'ma dya rí unüji ngüenda, ra jñünnc'üji 'ma c'ü ts'inguilëjë c'ü ya i̱ṉ pãrãji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'Na nu pa, o ẽjẽ c'ü nu nana e Jesús, 'ñe c'o nu cjuarma, ro säji nu ja mi bübü e Jesús. Pero dya mi sö ro cjogüji nu ja ma bübü, na ngue me ma puncjü o nte c'o ma cã nu. ");
INSERT INTO mazNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","O mama c'ua c'o nte o xipjiji e Jesús: ―Nin nana 'ñe c'o nin cjuarma cãrãji a tji; ne anguezeji rí ñaji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","O ndünrü e Jesús o xipji c'ua c'o nte: ―C'o rí cjapcö mi nanagö 'ñe mi cjuarma, ngueje c'o ärä o̱ jña Mizhocjimi c'o cja ja c'o nzi ga mama. ");
INSERT INTO mazNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","'Na nu pa, o dat'ü e Jesús cja 'naja bü co c'o o̱ discípulo. O mama c'ua e Jesús o xipjiji: ―Mö rá pes'eji nu 'nanguarü a manu cja ne trazapjü, eñe. Cjanu o möji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","'Ma ya mi möji, o zürü c'ua t'ĩjĩ e Jesús. Jo ni ẽjẽ c'ua 'na trandajma c'ü me mi vü cja c'e zapjü. Ya ma pjürü ma po'o o ndeje cja c'e bü c'ü mi pjö's'ü o ndajma; mi bübü peligro c'ü ro nguibiji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","O ẽjẽ c'ua c'o discípulo a jmi e Jesús, o zopjüji o xipjiji: ―Rí ñanga, xöpüte, ya rá quibiji. O zö c'ua e Jesús o nanga c'ua. Cjanu o huënch'i c'ua c'e ndajma, 'ñe c'o ndeje c'o me mi pjö's'ü. Ixco söya c'ua c'e ndajma, 'ñe c'o ndeje, dya cja mi pjö's'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","O mama c'ua e Jesús o xipji c'o discípulo: ―¿Jenga dya mi creozüji c'ü ro pjö'c'öji?, eñe. C'o discípulo me mi sũji mi pötma mamaji: ―¿Mbãrã, pje pjëzhi e Jesús? Maco manda ra böbü e ndajma 'ñe yo ndeje, y nujyo, ätäji nu. Nunca rí jandaji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","O zät'äji c'ua cja c'e país c'ü ni chjũ a Gadara c'ü bübü a 'nanguarü a Galilea cja c'e trazapjü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","'Ma ya vi mbes'e e Jesús cja c'e bü, o ẽjẽ c'ua 'naja bëzo c'ü je vi peje cja c'e jñiñi a Gadara, o 'ñe chjëvi e Jesús. Nu c'e bëzo, ya vi mezhe vi zürü o̱ s'ondajma e Satanás c'ü dya jo. Dya cja mi je'e o bitu. Dya cja xo mi bübü cja ngumü; je mi bübü cja panteón cja campo santo. ");
INSERT INTO mazNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","'Ma mü o jñanda c'e bëzo e Jesús, o mapjü c'ua na jens'e, cjanu o ndüñijõmü cja jmi e Jesús, cjanu o mama na jens'e: ―Nu'tsc'e Jesús, o̱ T'its'ü Mizhocjimi, ¿pje pë'sc'ü rí ñugue co nutscö? Rí ö'tc'ügö, dya rí tsjacü rá ma sufregö. ");
INSERT INTO mazNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","O mama a cjanu na ngue e Jesús mi manda c'ü o̱ s'ondajma c'ü dya jo ro mbedye cja c'e bëzo. C'ü o̱ s'ondajma c'ü dya jo, ya vi mezhe vi zürü c'e bëzo. C'o nte mi tjün't'üji co cadena c'e bëzo, mi tjün'tp'üji o̱ dyë 'ñe o̱ ngua, ngue c'ua dya ro nzhodü libre. Pero mi c'üdütjo c'o mi ndün't'üji. Y c'ü o̱ s'ondajma c'ü dya jo mi cjapü c'e bëzo ra nzhodü cja majyadü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","E Jesús o dyönü c'e bëzo: ―¿Pje ni chjũtsc'e? Cjanu o ndünrü c'ua c'e bëzo: ―Ni chjũzü Legión, eñe. C'e jña legión ne ra mama: “Na puncjü.” Mi chjũ a cjanu c'e bëzo, na ngue na puncjü o s'ondajma c'o vi cjogü a mbo cja o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","C'o s'ondajma mi ötüji na puncjü e Jesús c'ü dya ro manda ro möji nu ja c'o va 'nün't'ü c'o nu mis'ondajmaji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma cã na puncjü o cuchi cja c'e t'eje ma ñõnüji. Nuc'ua c'o o̱ s'ondajma c'ü dya jo, o dyötüji e Jesús ro unü sjëtsi anguezeji ro ma nguich'iji cja o̱ mü'bü c'o cuchi. O unüji c'ua sjëtsi. ");
INSERT INTO mazNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nuc'ua c'o s'ondajma o mbedyeji cja o̱ mü'bü c'e bëzo, cjanu o ma nguich'iji cja o̱ mü'bü c'o cuchi. Nuc'ua c'o cuchi cjanu o zöbüji texeji cja c'e dyä'ä, o ma zo'oji cja c'e trazapjü o nguibiji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nuc'ua c'o mi pjörü o cuchi, 'ma mü o jñandaji, o c'ueñeji c'ua na zëzhi o ma mamaji cja c'e jñiñi, 'ñe texe cja c'o lugar nu ja c'o mi cãrã o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nuc'ua c'o nte o mbedyeji c'ua, o ma nuji c'o vi tsja e Jesús. O zät'äji c'ua ja mi bübü e Jesús, o chöt'üji nu c'e bëzo c'ü vi mbedye c'o o̱ s'ondajma c'ü dya jo, mi junrü cja o̱ ngua e Jesús, ya mi je'e o bitu, ya mi tjümbeñe. O zũji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","O ña c'ua c'o nte c'o vi jñanda, o xipjiji c'o ma säjä ja va tsja e Jesús va pjongü c'o s'ondajma c'o mi bübü o̱ mü'bü c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nuc'ua c'o mi menzumü cja c'e país a Gadara, me mi sũji mi xipjiji e Jesús: ―Rí ö'tc'üjme favor rí pedye cja nín jñiñigöjme. O dat'ü c'ua e Jesús cja c'e bü, ngue c'ua ro nzhogü nu ja vi 'ñeje. ");
INSERT INTO mazNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nuc'ua c'e bëzo c'ü vi mbedye c'o s'ondajma, mi ötü c'ü ro möji e Jesús 'ñe c'o o̱ discípulo. Pero e Jesús o xipji: ");
INSERT INTO mazNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Nzhogü, ma in nzumü. Rí mama c'ü ja va mböxc'ü Mizhocjimi, embeji c'e bëzo. Nuc'ua cjanu o ma c'ua c'e bëzo, o ma mama texe cja c'e jñiñi ja va cja va pjongü e Jesús c'o s'ondajma c'o vi zürü c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nuc'ua 'ma mü o nzhogü na yeje e Jesús nu ja vi 'ñeje, texe c'o nte o recibidoji na ngue mi te'beji angueze. ");
INSERT INTO mazNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","O ẽjẽ c'ua 'naja bëzo c'ü mi chjũ e Jairo. Nuc'ü, mi xo'ñi cja 'na nintsjimi nu ja mi pa c'o mi menzumü a Israel mi pa ma't'üji Mizhocjimi. O ndüñijõmü a jmi e Jesús mi xipji ro mëvi cja o̱ ngumü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Na ngue mi 'ñeje 'natjo o̱ xunt'i c'ü mi ëdyi doce cjë'ë. Nuc'ü, ya ma tũ'ũ. 'Ma ya mi ma e Jesús, me ma puncjü o nte c'o mi pöji, dya mi sö ro ma na niji. ");
INSERT INTO mazNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Cja c'o nte c'o mi pöji e Jesús, xo mi pa 'na ndixũ c'ü ya vi mezhe doce cjë c'ü mi dagü o cji. Ya vi ndeze texe o̱ merio c'o mi jün, 'ma mi pa cja o médico. Pero dya cjó mi sö ro jocü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nuc'ua c'e ndixũ cjanu o ẽjẽ a xütjü e Jesús, cjanu o ndönbü cja squina c'ü o̱ bitu c'ü mi tëjë. Ixco böbü c'ua c'o mi xot'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nuc'ua e Jesús cjanu o mama: ―¿Cjó ngue c'ü o ndöcügö? Cjanu o ngädätjoji texeji. Nuc'ua e Pedro 'ñe c'o 'ñaja discípulo cjanu o xipjiji e Jesús: ―Nu'tsc'e xöpüte, i̱ṉ önügue cjó ngue c'ü o ndö'c'ügue. Ngue yo nte yo me s'ixc'igue. ");
INSERT INTO mazNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","O ndünrü c'ua e Jesús o mama: ―Rí pãrãgö bübü c'ü o ndöcügö. Na ngue nutscö ró pãrã o mbedyezü c'ü na zëzhi, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","O unü c'ua ngüenda c'e ndixũ c'ü mi pãrã e Jesús c'ü vi ndönbü o̱ bitu. Nguec'ua o ẽjẽ cja e Jesús, me mi mbi'i. Cjanu o ndüñijõmü a jmi, cjanu o xipji c'ua c'ü mi ngue angueze vi ndönbü o̱ bitu ngue c'ua ro ndis'i c'e ngueme c'ü mi sö. Y o xipji nzi va ndönbü nzi va ndis'i. O dyärä texe c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","O ndünrü c'ua e Jesús o xipji c'e ndixũ: ―Nu'tsc'e süngü, o ndixc'i na ngue i̱ creozü c'ü ro jocüts'ü. Mizhocjimi rí mëvi; dya cja ra mbeñe in mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","'Ma xe ma ña e Jesús, o säjä c'ua 'naja c'ü vi 'ñeje cja o̱ ngumü c'e bëzo c'ü mi xo'ñi cja c'e nintsjimi, o 'ñe xipji c'e bëzo: ―C'ü rvá ẽcjö, c'ü in xunt'i ya ndũ c'ü. Dya cja pje ni jyodü rí xipji ne xöpüte xe ra ẽjẽ nu. ");
INSERT INTO mazNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","'Ma mü o dyärä e Jesús, cjanu o xipji c'e bëzo c'ü mi xo'ñi: ―Dya rí sũ'ũ. Ixtí jñunt'ü in mü'bü c'ü rá cjapcö ra tetjo in xunt'i ra bübütjo na yeje. ");
INSERT INTO mazNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","'Ma mü o zät'äji cja o̱ ngumü c'e bëzo, dya jyëzi e Jesús cjó ro cjogü; nguextjo e Pedro 'ñe e Jacobo 'ñe e Juan, 'ñe c'ü nu tata c'e xunt'i, 'ñe c'ü nu nana. ");
INSERT INTO mazNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","C'o nte c'o ma cã nu, mi huëji texeji y me mi mapjü ma huëpiji c'e añima. O mama c'ua e Jesús o xipjiji: ―Dya rí huëji. Dya tũ'ũ ne xunt'i, ĩtjo dya nu. ");
INSERT INTO mazNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nuc'ua c'o nte o tjezhetjoji va tsjapüji burla e Jesús. Na ngue mi pãrãji c'ü ya vi ndũ c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nuc'ua e Jesús o pënchp'i o̱ dyë c'e xunt'i, o ma't'ü na jens'e o xipji: ―Rí ñanga, xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Cjanu o te c'ua c'e xunt'i o bübütjo na yeje; ixco nanga c'ua c'ü. Nuc'ua e Jesús o xipjiji ro unüji pje ro zi c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","C'ü nu tata c'e xunt'i 'ñe c'ü nu nana me go pizhivi, dya mi pãrã pje ro nguijñivi. Nuc'ua e Jesús o xipjivi c'ua c'ü dya cjó ro xipjivi c'ü vi tsjapü o te c'e xunt'i. ");
INSERT INTO mazNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","E Jesús o ma't'ü c'o doce o̱ discípulo ro ẽji cja o̱ jmi. Cjanu o unüji poder ngue c'ua ro sö ro pjongüji texe yo o̱ s'ondajma e Satanás c'ü dya jo, 'ñe ro jocüji c'o mi sö c'o pje nde ma ngueme. ");
INSERT INTO mazNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","O xipjiji ro ma zopjüji c'o nte ro xipjiji c'ü ngue Mizhocjimi c'ü manda, nguec'ua mi jyodü anguezeji ro dyätäji c'ü. Xo xipjiji ro ma jocüji c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","O xipjiji: ―Dya pje rí jñünüji c'o pje rguí jyodüts'üji cja 'ñiji. Dya pje rí jñünüji c'ü rgui chäji. Dya xo rí tsanaji mape c'ü pje rgui tsant'aji o pje rgui jñunt'üji. Dya xo rí jñünüji pje rí siji ni ri ngue o merio. Dya xo rí tsanaji o bitu c'ü rgui pötüji. ");
INSERT INTO mazNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Cja ngumü c'ua ja rí sät'äji, je rí oxüji nu hasta 'ma cja rí ñe rí pedyeji; dya rí pötqueji ngumü rgui oxqueji. ");
INSERT INTO mazNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","'Ma rí sätc'eji cja 'na jñiñi, 'ma dya cjó ra recibidots'üji, rí pedyegueji 'ma nu. 'Ma rí pedyegueji, rí jyä'bäji o jõmü c'o ya rguí jyäs'ä in mbäcuaji, ngue c'ua ra unü ngüenda c'o menzumü nu, c'ü vi tsjaji na s'o, dya recibidots'üji, eñe e Jesús va xipji c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Go mbedye go ma c'ua c'o apóstole, mi nzhodüji texe cja c'o jñiñi mi zopjüji c'o nte mi xipjiji ja rvá jogü o̱ mü'büji cja o̱ jmi Mizhocjimi. Texe c'ua ja mi sät'äji, mi jocüji c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","E Herodes c'ü mi manda cja c'e país a Galilea, o dyärä texe c'o na nojo c'o mi cja e Jesús. Dya mi pãrã pje ro nguijñi, na ngue bübü c'o mi mama: “E Juan ya tetjo, ya bübütjo na yeje. Ngue c'ü cja yo me na nojo”, eñe c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bübü c'o mi mama: “C'ü cja yo me na nojo, ngueje c'e profeta Elías c'ü ya ẽjẽ.” Bübü c'o mi mama: “Ya te'e c'ü 'naja c'o profeta c'o mi cãrã mi jinguã, ya bübütjo na yeje.” ");
INSERT INTO mazNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","O mama e Herodes: ―E Juan, maco ró mandagö o jñüpcüji o̱ ñi. Pero, ¿cjó ri ngue c'ü cja c'o me na nojo c'o rí ärägö? Nuc'ua e Herodes me mi jodü ja rvá jñanda e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","O nzhogü c'ua c'o discípulo c'o xo mi xiji apóstole, o xipjiji e Jesús c'o bëpji c'o vi tsjaji. Nuc'ua e Jesús o zidyi c'o apóstole o möji nu ja dya mi cãrã o nte, bëxtjo cja c'e jñiñi c'ü mi chjũ a Betsaida. ");
INSERT INTO mazNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero c'o nte go mbãrãji nu ja ro zät'ä e Jesús 'ñe c'o o̱ discípulo, nguec'ua xo möji nu. E Jesús o recibido c'o nte, o xipjiji c'ü ngue Mizhocjimi c'ü manda, nguec'ua mi jyodü anguezeji ro dyätäji c'ü. Y o jocü c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nuc'ua 'ma ya o nzhä'ä, o ẽjẽ c'o doce discípulo cja jmi e Jesús, o xipjiji: ―Xipji yo nte ra möji cja yo jñiñi yo bëxtjo, 'ñe texe cja c'o lugar nu ja cãrã o nte, ngue c'ua ra chöt'üji pje ra ziji, y ra oxüji. Na ngue rí cãrãji va cja 'naja majyadü. ");
INSERT INTO mazNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","O ndünrü c'ua e Jesús o xipjiji: ―Nu'tsc'eji rí unügueji c'ü pje ra ziji. Anguezeji o ndünrüji o mamaji: ―Dya rí jünjme c'ü ra zi yo; nguextjo tsi'ch'a tjõmëch'i cja na yeje jmõ. ¿Cjo i̱ṉ ne rá ma tõmüjme c'ü ra zi yo nte yo me na puncjü?, embeji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mi tsi'ch'a mil c'o bëzo. O mama c'ua e Jesús o xipji c'o o̱ discípulo: ―Xipjiji ra xõgüji nde ri cincuenta rga mimiji. ");
INSERT INTO mazNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cjanu o tsja c'ua c'o discípulo ja c'o nzi va manda e Jesús, o xipjiji ro mimi texe c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nuc'ua e Jesús o jñü c'o tsi'ch'a tjõmëch'i 'ñe c'o yeje jmõ. Cjanu o nä's'ä c'ua a jens'e va unü 'na pöjö Mizhocjimi. Cjanu o më'ch'i c'ua c'o tjõmëch'i 'ñe c'o jmõ. Cjanu o unü c'o o̱ discípulo ngue c'ua ro unüji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","O ziji texeji o nijmiji na jo. Nuc'ua cjanu o nguis'itjoji c'ua c'o ya nde mi ts'ipëraso c'o o mboncjütjo, y go nizhitjo doce bos'i. ");
INSERT INTO mazNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","'Na nu pa, e Jesús mi cãrãtsjëji co c'o o̱ discípulo, mi ötü Mizhocjimi. 'Ma mü o nguarü o dyötü Mizhocjimi, cjanu o dyönü c'o discípulo: ―¿Pje mama yo nte cjó nguetscö? ");
INSERT INTO mazNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","O ndünrü c'ua anguezeji: ―Bübü c'o mama ngue'tsc'e e Juan c'ü mi jichi yo nte co ndeje. Bübü c'o mama ngue'tsc'e e Elías. Bübü c'o mama o te 'naja c'o 'ñaja profeta c'o mi cãrã mi jinguã; mamaji ngue'tsc'e c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","O mama c'ua e Jesús o dyönüji: ―Nu'tsc'eji, ¿pje xo i̱ṉ mangueji? ¿Cjó nguetscö? O ndünrü c'ua e Pedro o xipji: ―Ngue'tsc'e e Cristo o 'ñempc'e Mizhocjimi rí mandague. ");
INSERT INTO mazNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","O mama c'ua e Jesús o xipji c'o discípulo: ―Pjötpüji na puncjü ngüenda c'ü dya cjó be rí xipcjeji c'ü nguetscö e Cristo. ");
INSERT INTO mazNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Zö rvá ẽcjö cja Mizhocjimi, pero ni jyodü me rá sufregö na puncjü. Ra jñüncü ngüenda yo tita c'o pje pjëzhi, 'ñe yo ndamböcjimi, 'ñe yo xöpü o̱ ley Mizhocjimi, ra mamaji c'ü na s'o c'ü rí cjagö. Y ra mbötcügöji. Nuc'ua 'ma ra cjogü jñipa, rá tetcjö rá bübütjo na yeje, eñe e Jesús va xipji c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","O mama e Jesús o xipji texe c'o nte: ―'Ma cjó c'o ne ra ndenngue co nuzgö, ni jyodü c'ü dya cja ra tsja c'o netsjë angueze. Y pama ra bübü dispuesto ra sufre o ra ndũ. Y ra sido ra dyätcä ín jña. ");
INSERT INTO mazNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","C'o dya bübü dispuesto ra sufre na ngue c'ü dya ne ra ndũji, dya ra chöt'üji c'ü rguí bübüji. Pero c'o bübü dispuesto ra bö't'ü na ngue c'ü ni dyätcäji ín jña, ra chöt'üji c'ü rguí bünji. ");
INSERT INTO mazNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nu 'ma ro tsja 'na nte ro tsjapü o̱ cjaja texe yo bübü va cja ne xoñijõmü, pero 'ma dya ro dyätcä ín jña, ¿pje ro dyeje 'ma? Na ngue ro jyëzi Mizhocjimi c'e nte. ");
INSERT INTO mazNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nutscö rvá ẽcjö cja Mizhocjimi. Rí xi'tsc'öji rá ẽcjö na yeje; me rrã zö c'ua ja rva ẽcjö, c'ua ja ga cja me na zö c'ü mi Tatagö, 'ñe c'o o̱ anxe. 'Ma cjó c'o ra zũ, y ra mama: “Dya rí pãrãgö e Jesús, dya xo rí ätpägö o̱ jña”, ra 'ñeñe; nu'ma, xo rá mangö c'ü dya rí pãrãgö c'o, 'ma rá ẽcjö na yeje. ");
INSERT INTO mazNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Rí dyäräji na jo yo rá xi'tsc'öji. Bübü va ja nzi yo dya ra ndũ'ũ hasta 'ma ra nuji ja ga cja 'ma rá mandagö, nutscö o 'ñempquegö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","'Ma ya vi cjogü 'nanzo c'ü vi mama e Jesús c'o jña c'o, o zidyi e Pedro 'ñe e Juan 'ñe e Jacobo, o nguins'iji cja 'na t'eje, ngue c'ua e Jesús ro ma dyötü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","'Ma ma ötü Mizhocjimi, o pötü c'ua ja ma jñetse o̱ jmi. Xo pötü c'ua ja ma jñetse o̱ bitu; me ma t'öxü me mi juëns'i. ");
INSERT INTO mazNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jo ni jñetse c'ua yeje bëzo c'o mi ngue e Moisés 'ñe e Elías, vi 'ñejui a jens'e mi ñaji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Anguezevi me mi juëns'ivi. Mi mamavi ja rvá cja c'ü ya mi ngue ro zädä; mi mamavi c'ü ja rvá mbö't'üji e Jesús a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","E Pedro 'ñe e Juan 'ñe e Jacobo me ma ẽjẽ o̱ t'ĩjĩji, pero dya go ĩji. Nguec'ua o jñandaji me mi juëns'i e Jesús ma zö. Xo jñandaji nza yeje bëzo c'o mi böbüji co e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nuc'ua 'ma ya mi ma e Moisés 'ñe e Elías, jo ni ña c'ua e Pedro o xipji e Jesús: ―Xöpüte, na jo rí cãrãgöjme va co nu'tsc'e 'ñe e Moisés 'ñe e Elías. Rá ät'äjme jñi ts'ingumü de dyëza. 'Naja c'ü rá ä'tc'öjme, 'naja c'ü rá ä'tp'ägöjme e Moisés, 'naja c'ü rá ä'tp'ägöjme e Elías, eñe. Dya mi pãrã pje ro mama e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","'Ma ndänt'ä ma ña e Pedro, o säjä c'ua 'na ngõmü o 'ñe ngobü anguezeji. 'Ma mü o ngobüji c'e ngõmü, o zũji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","O dyäräji c'ua 'na jña cja c'e ngõmü c'ü mi mama a cjava: ―Nujnu ngue ín Ch'igö nu me rí ne'e. Dyätäji angueze, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","'Ma ya vi nguarü c'e jña, c'o discípulo o jñandaji c'ü nguextjo e Jesús c'ü mi bübü. C'o pa c'o, dya cjó xipjiji c'o vi jñandaji. ");
INSERT INTO mazNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nuc'ua c'ü na ye nu pa, cjanu o zöbüji c'ua cja c'e t'eje. O ẽjẽ c'ua na puncjü o nte o 'ñe ndünrüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nuc'ua 'naja bëzo c'ü ma dyoji c'o nte, o mapjü o xipji e Jesús: ―Xöpüte, rí ö'tc'ö rí 'ñe ñutcü nu ín ch'i. Na ngueje nguextjo nu rí 'ñeje nu. ");
INSERT INTO mazNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","'Naja yo o̱ s'ondajma c'ü dya jo, nu ndajmetjo ga zürü nín ch'igö, cjapü ra mapjü. Me xo cjapü ra mbi'ch'i hasta 'ma ra pjont'ü o pjügü. Xo cjapü ra nügü hasta ya me ni c'anga. Mezhe ga mbö't'ü, dya ne ra jyëzi. ");
INSERT INTO mazNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ró xipji c'o in discípulogue ro pjongüji c'e s'ondajma; dya sö ro pjongüji, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","O ndünrü c'ua e Jesús o xipjiji texeji: ―Nu'tsc'eji i̱ṉ cãrãji yo cjë dya, ya s'odü in mü'büji. ¿Jenga dya i̱ṉ creozüji rá pjöxc'üji rí tsjaji c'o na nojo? Maco ya mezhe rí cãrãgöji, ya mezhe rí pë'sc'ö paciencia co nu'tsc'eji. Cjanu o xipji c'e bëzo: ―Siji ga 'ñecjua nin ch'igue. ");
INSERT INTO mazNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","'Ma ya ma siji c'e t'i, nuc'ua c'ü o̱ s'ondajma c'ü dya jo o tsjapü o nügü c'e t'i, ixco mbö't'ü. Nuc'ua e Jesús cjanu o huënch'i c'ua c'e s'ondajma, o xipji ro mbedye cja c'e t'i; ixco ndis'i c'ua c'e t'i. Nuc'ua e Jesús cjanu o xipji c'e bëzo: ―Bübü dya c'ua nin ch'igue; ya jogü nu. ");
INSERT INTO mazNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Texe c'o o jñanda, o unüji ngüenda c'ü me na zëzhi Mizhocjimi, ngue c'ua va jocü e Jesús c'e t'i. Y mi cjijñiji mi mamaji: ―Nunca rí jandaji a cjanu, eñeji. 'Ma mi cjijñi c'o nte c'ü vi tsja e Jesús, o ña c'ua e Jesús o xipji c'o o̱ discípulo: ");
INSERT INTO mazNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Nu'tsc'eji, dyäräji na jo yo rá xi'tsc'öji. Nutscö rvá ẽcjö cja Mizhocjimi, pero ra nzhögügöji cja yo nte ra mbötcüji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Anguezeji, dya mi pãrãji pje mi ne ro mama c'o jña c'o; dya jyëziji ro mbãrãji c'o. Mi sũji ro dyönüji ja ma cja c'o jña. ");
INSERT INTO mazNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nuc'ua c'o discípulo o mbürü o ñatsjëji, cjó mi ngue anguezeji c'ü xenda ro mbëzhi na nojo. ");
INSERT INTO mazNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","E Jesús mi pãrã c'o mi cjijñiji cja o̱ mü'büji. O ma't'ü c'ua 'naja ts'it'i ro ẽjẽ a jmi. ");
INSERT INTO mazNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Cjanu o xipjiji c'ua: ―'Ma cjó c'o ra recibido ne ts'it'i y ra mbös'üji nu, nguetscö recibidozü c'o. Na ngue je ga cjanu rgá negö. 'Ma cjó c'o ra recibidozügö, xo recibido Mizhocjimi c'ü o xitsigö ró ẽgö cja ne xoñijõmü. Zö ra mbë'ts'iji na nojo, zö dya pje ra mbë'ts'iji, pero 'ma rí pjös'üji c'o pje ni jyodü, rrã nots'üji cja ín jmigö 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","O ndünrü c'ua e Juan o xipji e Jesús: ―Nu'tsc'e xöpüte, ró jandajme 'na bëzo c'ü mi nännc'ägue in chjũ ma pjongü yo o̱ s'ondajma c'ü dya jo. Ró xipjijme c'ü dya cja ro tsja a cjanu, na ngue dya rí dyocjöji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","O ndünrü c'ua e Jesús o xipji: ―Dya rí ts'a's'üji c'ü. 'Na nte zö dya rí dyocjöji c'ü, pero 'ma dya nugüji na ü, nu'ma, bübü co nutscöji ' ma c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nuc'ua c'o pa, ya mi ngue ro zädä 'ma ro zidyiji e Jesús a jens'e. Zö mi pãrã e Jesús c'ü me ro sufre a Jerusalén, pero sido mi nzhodü para ro zät'ä nu. ");
INSERT INTO mazNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nuc'ua cjanu o xipji c'o ro ot'ü ro ma. Anguezevi o mëvi c'ua o zät'ävi cja 'na jñiñi c'ü tsja a Samaria, o jyodüvi nu ja ro oxüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero c'o mi menzumü nu, dya ne ro recibidoji e Jesús. Na ngue o unüji ngüenda c'ü je mi ma e Jesús a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nuc'ua e Jacobo 'ñe e Juan c'o mi discípulo, 'ma mü o dyärävi c'ü dya ro recibidoji e Jesús, cjanu o ma xipjivi e Jesús: ―Nu'tsc'e ín Jmuts'ügöjme, mi jinguã o mama e Elías c'ü ro jyäbä o sivi a jens'e ro castigao c'o mi cja na s'o. ¿Cjo i̱ṉ ne rá cjabe a cjanu rá mamabe ra jyäbä o sivi, ra chjorü c'o nte na ngue dya recibidots'üji?, eñevi. ");
INSERT INTO mazNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nuc'ua e Jesús o jñanda na jo anguezevi, cjanu o huënch'ivi o mama: ―I̱ṉ pëzhguevi c'ü na jo c'ü cja i̱ manguevi. Pero ixtí xi'tsc'övi, dya ngue Mizhocjimi c'ü o 'ñünnc'ü in mü'büvi i̱ manguevi a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","C'ü rvá ẽcjö cja Mizhocjimi, ró ẽcjö cja ne xoñijõmü, dya ngue c'ü rá chjotü yo nte; ngueje c'ü rá salva yo, eñe. Nuc'ua, dya oxüji cja c'e jñiñi, o möji c'ua c'ü 'na jñiñi. ");
INSERT INTO mazNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","'Ma ya mi pöji cja 'ñiji, o ẽjẽ c'ua 'na nte cja o̱ jmi e Jesús o xipji: ―Nu'tsc'e ín Jmuts'ügö, rá tennc'e co nu'tsc'e rá më c'ua ja rí mague. ");
INSERT INTO mazNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Cjanu o ndünrü c'ua e Jesús o xipji: ―Ante c'ü rá më, ixtí tsjijñi c'ü rá xi'tsc'ö. Yo min'ño pë's'i o̱ tjocü ja obüji, y yo s'ü pë's'iji o̱ t'oxüji. Pero nutscö, zö rvá ẽcjö cja Mizhocjimi, pero dya rí pë'sc'ö ja rá oxü, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Xe go ña c'ua e Jesús o xipji c'ü 'na nte: ―Chjä'dä rá mö. O ndünrü c'ua o xipji e Jesús: ―Nu'tsc'e ín Jmuts'ügö, dyacü sjëtsi ot'ü rá ma'a, rá ma ögü mi tatagö, cja rrũ mëgövi. ");
INSERT INTO mazNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","E Jesús o xipji c'ua: ―Yo nte, chjëntjui c'ü ya ndũji, na ngue dya creozüji. Jyëzgue anguezeji ra dyögüji c'o nín mi añimaji. Nu'tsc'e rí chenngue co nutscö rá jí'ts'i rí zopjügue yo nte, rí xipjiji ni jyodü ra dyätäji Mizhocjimi, na ngue angueze ngue c'ü manda, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Cjanu o ña c'ua c'ü 'naja o xipji e Jesús: ―Nu'tsc'e ín Jmuts'ügö, rá mëgövi; nguextjo c'ü rí jyëzgui ot'ü rá ma ẽzhẽ c'o cãrã ín nzungö. ");
INSERT INTO mazNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","O ndünrü c'ua e Jesús o xipji: ―'Ma cjó c'o übü o tjäjä, dya ñezhe ra jñanda a xütjü. 'Ma jiyö, ra s'odü 'ma c'e tjäjä. Je xo ga cjatjonu, 'ma cjó c'o ra ndenngue co nuzgö, ni jyodü ra sido ín 'ñijigö co texe o̱ mü'bü; dya me ra mbeñe c'o bëpji c'o vi zogü, ne ri ngue c'o o̱ dyoji. 'Ma jiyö, dya ra sö Mizhocjimi ra tsjapü o̱ nte 'ma c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'Na nu pa, e Jesús c'ín Jmugöji o juajnü c'o xe 'ñaja nte c'o ro mbëpi angueze; o zäs'äji setenta. Cjanu o xipji c'ua nde yeje rvá möji; ro möji c'o jñiñi nu ja ro ma angueze, ro ma zopjüji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ante c'ü ro möji, e Jesús o xipji c'ua c'o o̱ discípulo va jyëtspi o ndëxü c'o nte: ―C'o ndëxü me na puncjü c'o, pero c'o ndagrëxü, ts'ëtjo c'o. Nguec'ua rí dyötüji Mizhocjimi c'ü o̱ cjaja c'o ndëxü, ra juajnü c'o xe 'ñaja mbëpji ra ẽji ra 'ñe pëpjiji cja ne ndagrëxü. ");
INSERT INTO mazNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Möji, ma zopjüji yo nte. Pero pjötpüji ngüenda, na ngue i̱ṉ chjëntcjeji nza cja o ndënchjürü a nde cja o min'ño. ");
INSERT INTO mazNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Dya rí tsanaji o mape c'ü pje rí jñunt'üji o c'ü pje rí tsant'aji. Dya xo rí tsidyiji c'o rí chin'ch'iji. Dya ra mezhe rgui zenguategueji cja 'ñiji. ");
INSERT INTO mazNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cja c'e ngumü c'ua ja rí sät'äji nzi 'naja jñiñi, xipjiji c'o ri cãrã c'e ngumü: “Mizhocjimi ne ra mböxc'üji”, rí 'ñembeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nu 'ma cjó c'o ri bübü nu c'ü ri te'be nu c'ü ra 'ñe 'ñeme libre c'o nte, ix na cjuana ra tsja Mizhocjimi ra salvaji c'ua ja nzi vi zenguagueji. 'Ma dya ra dyä'tc'äji, iyö 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","C'ü ot'ü ngumü nu ja ra recibidots'üji, je rí oxügueji nu hasta 'ma cja rí ñe rí pedyeji; dya rí pötüji o ngumü. C'o ra dya'c'üji rí sigueji, rí siji c'o; dya rí tsegueji. Na ngue c'o o̱ mbëpji Mizhocjimi ni jyodü ra ch'unü c'ü ra zi'iji. ");
INSERT INTO mazNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Texe jñiñi c'ua ja rí sät'äji, rí siji c'o ra ch'a'c'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Rí jocüji c'o ri sö'dyë nu. Y rí xipjiji: “Ya ngue ra mandats'üji c'ü o 'ñeme Mizhocjimi”, rí 'ñembeji. ");
INSERT INTO mazNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'Ma ja c'o rí sät'äji cja 'naja jñiñi, 'ma dya ra recibidots'üji, rí böbüji cja 'ñiji cja rrĩ xipjiji c'o nte: ");
INSERT INTO mazNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ne xijõmü cja in jñiñigueji nu o jyäs'ä ín cuabe, rá tjintsibe dya, ngue c'ua rí pãrãji c'ü i̱ tsjaji na s'o, dya i̱ recibidozübe. Dyäräji na jo c'ü rí xi'ts'ibe. Zö dya i̱ recibidozübe, pero ya ngue ra manda c'ü o 'ñeme Mizhocjimi”, rí 'ñembeji. ");
INSERT INTO mazNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","O sido o ña e Jesús o xipji c'o o̱ discípulo: ―Rí xi'tsc 'öji, c'o jñiñi c'o dya ra recibidots'üji, me ra sufreji c'e pa 'ma ra jñü ngüenda Mizhocjimi. Xenda ra sufreji que na ngue c'ü ra sufre c'o mi menzumü a Sodoma, zö me ma s'o c'o o tsjaji. ");
INSERT INTO mazNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Juejme yo menzumü a Corazín 'ñe yo menzumü a Betsaida, na ngue Mizhocjimi ra tsjapü me ra sufre yo. Nu cja yo yeje jñiñi, ró cjagö na puncjü c'o me na nojo, pero dya go jyëziji c'o na s'o c'ü ro nzhogü o̱ mü'büji cja Mizhocjimi. Nu 'ma ri ngue a ma a Tiro 'ñeje a ma a Sidón c'ü ro cjagö a cjanu, ya rví mezhe c'ü ro nzhogü o̱ mü'bü cja Mizhocjimi c'o mi menzumü nu, zö ma s'oji. Ya rví jyeji c'o na ãrã, y ya rví minji cja bozivi c'ü ro jizhiji c'ü ya nzhogü o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nguec'ua rí xi'tsc'öji, 'ma ra jñü ngüenda Mizhocjimi, xenda ra jñus'ü c'ü ra sufre yo menzumü a Corazín 'ñe yo menzumü a Betsaida, que na ngue c'ü ra sufre c'o mi menzumü a Tiro 'ñe a Sidón. ");
INSERT INTO mazNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yo menzumü a Capernaum, cjapüji c'ü me na joji, cjijñiji c'ü ra zät'äji a jens'e. Pero Mizhocjimi ra tsjapü ra ma sufreji a linfiernu. ");
INSERT INTO mazNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’'Ma cjó c'o ra dyä'tc'ägueji, nguetscö ra dyätcägö c'o. 'Ma cjó c'o dya ra dyä'tc'ägueji, nguetscö, dya ne ra dyätcägö c'o. 'Ma cjó c'o dya ra dyätcägö, dya xo ra dyätä Mizhocjimi c'ü o 'ñembgue, eñe e Jesús va xipji c'o setenta c'o vi juajnü. Cjanu o mbedye c'ua c'o setenta o möji o ma zopjüji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","'Ma mü o nzhogü c'o setenta, me mi mäji. O xipjiji e Jesús: ―Dya nguextjo yo nte yo o dyätcäjme, xo 'ñe o̱ s'ondajma e Satanás c'ü dya jo. Ró nännc'äjme in chjũgue rvá xipjijme ro mbedyeji cja o̱ mü'bü c'o nte; go mbedyeji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","O ndünrü c'ua e Jesús o xipjiji: ―Ró jandagö e Satanás c'ü dya jo, ixco ndögü a jens'e go säjä a jõmü, chjëntjui nza cja 'ma go pjäjnä o rayo va tögü 'na sivi. ");
INSERT INTO mazNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ró da'c'üji poder rí yödüji o c'ijmi 'ñeje o alacrán. Ró da'c'üji poder rí chõpüji e Satanás c'ü rí üji. Nguec'ua, dya ra sö pje ra tsja'c'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","I̱ṉ mäcjeji na ngue o dyä'tc'äji c'o o̱ s'ondajma c'ü dya jo. Pero nujyo, dya ngue yo rgui mäcjeji yo. C'ü rgui mäcjeji, ngue c'ü ya juns'ü in chjũgueji a jens'e na ngue ya ngue o̱ ntetsc'eji dya Mizhocjimi, eñe e Jesús va xipji c'o setenta. ");
INSERT INTO mazNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nuc'ua o̱ Espíritu Mizhocjimi o 'ñünbü o̱ mü'bü e Jesús, o tsjapü me go mäjä na puncjü, o dyötü 'na pöjö Mizhocjimi o xipji: ―Mi Tatats'ügö i̱ṉ mandague a jens'e 'ñe cja ne xoñijõmü. Yo jña yo, dya i̱ unü ro mbãrã c'o cjapü me pãrã. I̱ unügue o mbãrã yo nza cja o ts'it'i yo unü ngüenda c'ü dya pãrãji. Nguec'ua rí da'c'ü 'na pöjö. Na jo, na ngue je ga cjanu vi ñegue, mi Tatats'ügö. ");
INSERT INTO mazNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Cjanu o mama c'ua e Jesús: ―Dya cjó pãrã cjó nguetscö; nguextjo mi Tatagö pãcãgö. Dya cjó xo pãrã mi Tatagö; nguextjozügö o̱ T'izü, rí pãrãgö c'ü. Y nutscö rí jíchi c'o rí ne rá jíchi c'ua ja ga cja mi Tata, ngue c'ua xo ra mbãrã c'o. Je ga cjanu va dyacö mi Tata rí cjagö; o dyacö texe o poder. ");
INSERT INTO mazNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nuc'ua e Jesús cjanu o xipjitsjë c'o discípulo: ―Mizhocjimi o dya'c'üji i̱ṉ jandaji yo rí cjagö. Ngue nu rgui mäcjeji nu. ");
INSERT INTO mazNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Rí xi'tsc'öji, na puncjü c'o profeta c'o mi cãrã mi jinguã 'ñe c'o mi manda a Israel, c'o mi ne ro jñanda yo i̱ṉ jandaji y ro dyäräji yo i̱ṉ äräji. Pero dya jñandaji yo, dya xo dyäräji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","O böbü c'ua 'na c'ü me mi pãrã o̱ ley Mizhocjimi, o dyönü e Jesús ngue c'ua ro mbãrã pje pjëzhi c'ü ro mama. O xipji: ―Nu'tsc'e xöpüte, ¿pje ni mbë c'ü rá cjagö ngue c'ua ra dyacü Mizhocjimi c'ü rá bübütjo co angueze para siempre?, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","O ndünrü c'ua e Jesús o xipji c'ua: ―¿Pje ni mbë c'ü t'opjü cja o̱ ley Mizhocjimi c'ü i̱ṉ xörü? ");
INSERT INTO mazNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","O ndünrü c'ua c'e bëzo o xipji: ―Je mama a cjava o̱ ley Mizhocjimi: “Rí ñeji Mizhocjimi co texe in mü'büji, 'ñe co texe in aljmaji, 'ñe co texe in fuerzaji, 'ñe co texe in pjeñeji. Y rí s'iyaji yo nin minteji ja c'o nzi gui s'iyatsjëgueji.” ");
INSERT INTO mazNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","O ndünrü c'ua e Jesús o xipji: ―Na jo c'ua ja vi chjünrü. Tsjague yo, ngue c'ua rí bübütjogue. ");
INSERT INTO mazNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","C'e bëzo, dya mi ne ro bëzhi o tse. Nguec'ua va dyönü: ―¿Cjó ngue c'ü ni jyodü rá s'iyagö? ");
INSERT INTO mazNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","O ndünrü c'ua e Jesús o xipji: ―Mi bübü 'na bëzo c'ü mi menzumü a Jerusalén; o mbedye nu o zöbü a Jericó. Nuc'ua cjanu o ẽjẽ c'ua o mbẽ'ẽ o pënch'iji c'e bëzo, o ts'osp'üji c'ua c'o o̱ bitu o mbäräji. Cjanu o möji c'ua, o mbëztjoji nu c'e bëzo; ya mi ngue ro ndũ. ");
INSERT INTO mazNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Xo ma sjöbü 'na mböcjimi cja c'e 'ñiji. 'Ma mü o zät'ä nu ja mi 'mana c'e bëzo c'ü vi pënch'i o mbẽ, o jñanda pero o ngös'ütjo cja c'e 'ñiji. ");
INSERT INTO mazNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Xo ma sjöbü 'na levita. 'Ma ya mi ngue ro zät'ä nu ja mi 'mana c'e bëzo, jo nu jñanda, xo go ngös'ütjo c'ua c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Xo ma sjöbü 'naja c'ü mi menzumü a Samaria c'ü mi chägä 'na burru. Zö mi nan'ño menzumü pero 'ma mü o zät'ä, o ndäcä o juentse c'ua c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nuc'ua cjanu o ndũ c'ua o aceite 'ñe o vinu, cjanu o xisp'i c'e bëzo nu ja vi s'odü. Cjanu o jyü'tp'ü c'ua o manta. Nuc'ua cjanu o 'ñe's'e c'ua cja o̱ burru, cjanu o zidyi cja 'naja mesón c'ua ja mi oxü c'o nte. O mbörütjo c'ua nu. ");
INSERT INTO mazNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nuc'ua c'ü jyas'ü, o jñümü c'ua yeje merio, cjanu o unü c'ua c'ü mi ngue o̱ cjaja c'e mesón, o xipji: “Pjörü ne bëzo nu. Nu c'o xe rí gasto, 'ma rá nzhogü, rá cjõ'tc'ü”, eñe c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","O sido o ña e Jesús o xipji c'e bëzo c'ü mi pãrã o̱ ley Mizhocjimi: ―¿Pje i̱ṉ cjijñigue? ¿Cjó ngue nza jñi, c'ü o s'iya c'e bëzo c'ü vi pënch'i o mbẽ? ");
INSERT INTO mazNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","O ndünrü c'ua c'ü mi pãrã o̱ ley Mizhocjimi, o xipji e Jesús: ―Nu c'ü o s'iya, ngue c'ü o juentse o mbös'ü. Nuc'ua e Jesús o xipji: ―Mague, y xo rí tsjague a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","E Jesús mi pöji c'o o̱ discípulo. O zät'äji c'ua cja 'na jñiñi. Mi bübü nu 'naja ndixũ c'ü o mbitaji e Jesús ro ma cja o̱ ngumü. C'e ndixũ mi chjũ e Marta. ");
INSERT INTO mazNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","E Marta mi 'ñeje 'naja o̱ cjũjuë c'ü mi chjũ e María. E María mi junrü cja o̱ ngua e Jesús, mi ätpä o̱ jña. ");
INSERT INTO mazNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero e Marta me ma jñünt'ü c'o ma cja'a, ma ät'ä o jñõnü. Nuc'ua o ma xipji e Jesús: ―Nu'tsc'e ín Jmuts'ügö, ¿cjo dya i̱ṉ cjapü nguënda nu mi tsjĩjuë? O jyëzguitsjë rá ät'ätsjëgö texe o jñõnü. Xipjigue ra mböxcü. ");
INSERT INTO mazNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","O ndünrü c'ua e Jesús o xipji: ―Marta, ¿jenga i̱ṉ mangue a cjanu? Me i̱ṉ jñünt'ügue c'o na cjague. ");
INSERT INTO mazNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","C'ü xenda ni muvi rí tsjague, ngue c'ü na cja dya e María ätcä ín jñagö. Nguec'ua na jo ra sido ra mimi ra dyätcägö ín jña. ");
INSERT INTO mazNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","'Na nu pa, e Jesús mi ötü Mizhocjimi. Nu 'ma o nguarü, o mama c'ua 'naja c'o o̱ discípulo o xipji: ―Nu'tsc'e ín Jmuts'ügöjme, e Juan mi jíchi c'o o̱ discípulo ja rvá dyötüji Mizhocjimi. Nu'tsc'e, xo rí jítscöjme ja rga ötcöjme Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","O ndünrü c'ua e Jesús o xipjiji: ―'Ma rí dyötqueji Mizhocjimi, rí xipjiji a cjava: Mi Tatats'ügöjme, je i̱ṉ bübü a jens'e, rí pjöxcüjme nutscöjme rí cãrãjme cja ne xoñijõmü, ngue c'ua rá sũc'üjme ja c'o nzi ga zũc'ü c'o cãrã a jens'e. Xo rí pjöxcüjme ngue c'ua dya ra mezhe ra zädä c'ü rá ä'tc'öjme ja c'o nzi ga dyä'tc'ä c'o cãrã a jens'e. Na ngue ngue'tsc'e i̱ṉ mandague. Xo rí ö'tc'öjme rá cjajme c'ua ja nzi gui ñegue. ");
INSERT INTO mazNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dyacöjme dya o xëdyi c'o rá sigöjme ne pa dya. ");
INSERT INTO mazNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Perdonaozügöjme c'o na s'o c'o rí cjajme. Na ngue rí perdonaogöjme 'ma cjó c'o pje cjacüjme. Dya rí jyëzgue ra ndõcöjme c'ü dya jo. Pjöxcüjme ngue c'ua dya rá cjajme c'o na s'o. Je rga cjanu rgui dyötüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","O sido o ña c'ua e Jesús o xipjiji: ―'Ma va säjä 'naja c'ü i̱ṉ jogueji c'ü ndexõmü va 'ñe zenguats'üji, 'ma ojtjo pje rí unngueji c'ü ra zi c'ü, nuc'ua i̱ṉ pöcjeji cja 'naja in dyocjeji i̱ṉ pa xipjiji: “Nu'tsc'e rí jogövi, rvá ne ö'tc'ü 'na favor rí pesque jñi tjõmëch'i, na ngue cja säjä cja ín nzungö 'naja c'ü rí jogöbe, c'ü vi 'ñeje na jẽ. Ojtjo pje rá unügö c'ü ra zi”, i̱ṉ embeji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ra ndünrü c'ü bübü a mbo: “¿Jenga va 'ñe molestaozü? Ya ró tranca na jo ne ngoxtji. Ya rrũ ĩgöjme yo ín ch'igö cja pjinguã. Dya sö rá nanga rá da'c'ü c'ü i̱ṉ pesque”, ra 'ñents'eji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Zö ra xi'ts'iji a cjanu, pero sido i̱ṉ ötüji. Zö ngue in dyocjeji c'ü, pero dya ra dya'c'üji. Pero rí mangö ra dya' c'üji 'ma rí sido rí dyötüji favor. Na ngue ra xicha ra pe'sc'eji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nguec'ua rí xi'tsc'öji, sido rí dyötqueji Mizhocjimi ra dya'c'üji. Sido rí ma't'üji Mizhocjimi ra dyä'tc'eji c'ü i̱ṉ ötüji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Na ngue texe c'o ra dyörü, ra ch'unü c'o. Y texe c'o ra jyodü, ra chöt'ü c'o. Y texe c'o ra mapjü, ra dyätäji c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Nu'tsc'eji i̱ṉ 'ñecjeji in ch'igueji, 'ma ra ẽjẽ cja in jmiji in ch'igueji ra dyö'tc'üji 'na tjõmëch'i, ¿cjo rí unügueji 'na ndojo? Iyö, dya sö. O 'ma ra dyö'tc'üji 'na jmõ, ¿cjo rí unügueji 'na c'ijmi? Iyö, dya xo sö. ");
INSERT INTO mazNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O 'ma ra dyö'tc'üji 'na blanquillo, ¿cjo rí unügueji 'na alacrán? Iyö. ");
INSERT INTO mazNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Maco i̱ṉ nteji i̱ṉ cjaji c'o na s'o, pero i̱ṉ pjëchi rí unüji c'o na jo yo in ch'igueji. Nguec'ua ixtí jñunt'ü in mü'büji, mi Tataji c'ü bübü a jens'e ra dya'c'üji o̱ Espíritu c'ü ra ẽ bübü a mbo in mü'büji 'ma rí dyötqueji; 'ñe texe c'o ni jyodüts'üji, eñe e Jesús va xipji c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","E Jesús o chjëji 'na bëzo c'ü vi zürü o̱ s'ondajma c'ü dya jo. C'e s'ondajma mi cjapü ra ngone c'e bëzo. Nuc'ua e Jesús cjanu o pjongü c'ua c'e s'ondajma cja c'e bëzo. 'Ma mü o mbedye c'e s'ondajma, ixco ña c'ua c'e bëzo. Nguec'ua c'o nte me co nguijñiji cjanu o mamaji: ―Nunca rí jandaji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Anguezeji bübü c'o mi mama: ―C'ü unü o̱ poder ne bëzo ra pjongü o̱ s'ondajma c'ü dya jo, nguetsjë e Beelzebú c'ü dya jo, c'ü manda cja c'o s' ondajma, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bübü c'o o mama: ―'Ma vi 'ñecje cja Mizhocjimi, rí tsjague 'na señal c'ü me na nojo c'ü rá jandagöjme. ");
INSERT INTO mazNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","E Jesús mi pãrã c'o mi cjijñiji; nguec'ua va xipjiji c'ua: ―Cja 'na ndajñiñi c'ü ra chũtsjëji, ra chjorü 'ma c'o ri cãrã nu. Texe o ndajñiñi 'ñe texe o ngumü, 'ma ra pötca chũtsjë c'o ri cãrã nu, ra chjorüji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Xo 'ñetjo e Satanás 'ma ro pjongü c'o o̱ s'ondajmatsjë, ¿ja rvá sö xe ro manda 'ma c'ü? ");
INSERT INTO mazNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Jenga i̱ṉ xitscöji ngue e Beelzebú c'ü dya jo c'ü o dyacö ne poder nu rgá pjongü yo o̱ s'ondajma? Maco c'o in dyocjeji xo pjongüji yo. Ixi 'ñetsetjo c'ü i̱ṉ cjijñiji na s'o. ");
INSERT INTO mazNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Rí xi'tsc'öji o dyacü Mizhocjimi o̱ poder, nguec'ua rgá pjongö yo. Nguec'ua rí jñunt'ü in mü'büji c'ü na cjuana ya säjä a ndetsc'eji nu c'ü o 'ñeme Mizhocjimi ra manda. ");
INSERT INTO mazNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’'Naja bëzo c'ü na zëzhi, 'ma jün o̱ arjma c'o na jo, nu'ma, pjörü na jo o̱ ngumü. A cjanu, dya cjó sö cjó ra 'ñe põnbü c'o pë's'i. ");
INSERT INTO mazNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero 'ma ra ẽjẽ 'naja c'ü xenda na zëzhi, ra ndõpü c'ü ngue o̱ cjaja c'e ngumü, ra jñünbü c'o o̱ arjma c'o mi confiao ro mbös'ü. Y ra ndunbü c'o ri pë's'i cja c'e ngumü ra jyanbü c'ua c'o o̱ dyoji. Je xo ga cjanu, nutscö xenda na zëtscö que na ngue e Satanás c'ü dya jo; nguec'ua sözgö rá pjongü dya c'o o̱ s'ondajma. ");
INSERT INTO mazNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’C'o dya tenngue co nuzgö, chjëntjui c'ü ri nugü na ü c'o. C'o dya ra xipji yo nte ra creozüji, chjëntjui c'ü ri c'a's'üji yo nte ngue c'ua dya xo ra creozüji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’'Na s'ondajma 'ma ra mbedye cja 'na nte, ra nzhodü c'ua ja na dyodü, ra jyodü c'ua ja ra söya pero dya ra chöt'ü. Nguec'ua ra mama c'e s'ondajma: “Rá nzhogü rá magö nu ja mi bünc'ö, nu ja ró pedyegö”, ra 'ñeñe. ");
INSERT INTO mazNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nuc'ua 'ma ra zät'ä nu, ra chöt'ü c'ü rguí baxü y ya xo rguí jocüji na jo, pero dya cjó ri bübü. ");
INSERT INTO mazNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nuc'ua ra ma c'ua c'e s'ondajma xe ra ma siji xe siete c'o nu mis'ondajmaji c'o xenda na s'o que na ngue angueze; ra 'ñe cjogüji cja o̱ mü'bü c'e bëzo, ra mimiji nu. Nuc'ua xenda ra sufre c'e nte c'ü, que na ngue 'ma ot'ü. Na ngue xenda ra manda c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","'Ma mi mama e Jesús c'o jña, o mapjü c'ua 'na ndixũ c'ü mi bübü a nde c'o nte, o xipji e Jesús: ―Me na jo va unü Mizhocjimi c'ü in nanague; o unü o muxc'ügue 'ñe o jö'tc'ü. Mizhocjimi ra intsjimi na puncjü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","O ndünrü c'ua e Jesús o xipji c'ua: ―C'o ra intsjimi Mizhocjimi, ngueje c'o ra dyärä o̱ jña Mizhocjimi 'ñe ra tsjaji ja c'o nzi ga mama. ");
INSERT INTO mazNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nuc'ua 'ma xe ma jmurü c'o nte nu ja mi bübü e Jesús, o xipjiji c'ua: ―Yo nte yo cãrã yo cjë dya, na s'oji. Nguec'ua ga dyörüji c'ü pje ra jñandaji, ngue c'ua ra mbãrãji pje pjëtscö. Pero dya ra ch'unüji c'ü ra jñandaji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","'Ma mü o ma e Jonás a Nínive o ma zopjü c'o nte, o creo c'o nte na ngue e Jonás vi mbedye cja o̱ ne c'e trajmõ nu ja ya vi dyo'o jñipa. Je xo rga cjazgö nu. Na ngue c'o ra tsjacüji 'ñe c'o rá cjagö, na puncjü yo nte yo cãrã yo cjë dya, ra 'ñejmezüji ra unüji ngüenda c'ü rvá ẽcjö cja Mizhocjimi. Pero dya rá cjagö señal c'ü ra jñanda yo nte ja c'o nzi ga dyörüji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","C'e pa 'ma ra jñü ngüenda Mizhocjimi, ra bübü nu c'e ndixũ c'ü mi manda a ma a Sur, xo 'ñejyo nte yo cãrã yo cjë dya. Nu c'e ndixũ vi ẽjẽ ndeze nu ja tjorü ne xoñijõmü, o'ñe dyärä c'o mi mama e Salomón na ngue mi pë's'i na puncjü o̱ pjeñe. Pero nu'tsc'eji i̱ṉ cãrãji yo cjë dya, dya i̱ṉ ne rí dyäräji; maco zo'c'üji dya nu 'naja nu xenda pë's'i o̱ pjeñe que na ngue e Salomón. Nguec'ua ra jñün'c'üji ngüenda rí sufreji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","C'e pa 'ma ra jñü ngüenda Mizhocjimi, ra bübü nu c'o mi cãrã a Nínive, xo 'ñejyo nte yo cãrã yo cjë dya. E Jonás o ma a Nínive o ma zopjü c'o mi menzumü nu; nguec'ua va jyëziji c'o na s'o o nzhogüji cja Mizhocjimi. Pero nu'tsc'eji i̱ṉ cãrãji yo cjë dya, dya nzhogü in mü'büji, maco zo'c'üji dya nu 'naja nu xenda pjëzhi na nojo que na ngue e Jonás. Nguec'ua ra jñün'c'üji ngüenda Mizhocjimi rí sufreji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’'Ma tjütüji 'na sivi, dya emeji nu ja tsjõtü. Dya xo co'büji co 'na caja. Je ẽ's'ẽji nu ja na ts'ijens'e, ngue c'ua ra sö ra jñanda c'o ri cjogü a mbo cja ngumü. ");
INSERT INTO mazNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","C'ü rgá jandagöji, ngue ín chöji. 'Ma na jo ín chöji, rí jandaji na jo e jya's'ü. Pero 'ma s'odü ín chöji, chjëntjui c'ü ri bübüji cja bëxõmü 'ma. Je xo ga cjatsc'eji nu. 'Ma na jo in mü'büji, dya tsot'ü in chöji. Nguec'ua i̱ṉ unüji na jo ngüenda c'ü rvá ẽcjö cja Mizhocjimi. Pero 'ma na s'o in mü'büji, iyö 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nguec'ua rí xi'tsc'öji rí pjötpügueji ngüenda rí jyëziji c'ü ra zi'ch'i in mü'bügueji o̱ jya's'ü Mizhocjimi. 'Ma jiyö, ra bübüts'üji o bëxõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pero 'ma rí unnc'eji ngüenda c'o jña c'o rí xi'tsc'öji, 'ma rí jyëziji c'ü ra zi'ch'i in mün'c'eji o̱ jya's'ü Mizhocjimi, ra bübüts'üji na puncjü o jya's'ü 'ma. A cjanu rí pãrãgueji na jo 'ma, cjó nguetscö, 'ñe rí pãrãgueji ja rgui minc'eji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nuc'ua 'ma mü o nguarü e Jesús o ña c'o jña, o ẽjẽ c'ua 'naja c'o fariseo o 'ñe xipji e Jesús ro mëvi nu ngumü ro ma ziji o xëdyi. O mëvi c'ua. 'Ma o zät'ävi cja c'e ngumü o cjogüvi a mbo, o mimi e Jesús cja mexa. ");
INSERT INTO mazNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nuc'ua c'e fariseo o jñanda c'ü dya go xindyë e Jesús ante c'ü ro zi o xëdyi. Nguec'ua va nguijñitsjë c'ua: “¿Jenga dya go xindyë nu, maco je ga cjanu ín chjũrügöjme?” ");
INSERT INTO mazNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","O mama c'ua e Jesús c'ín Jmugöji: ―Bübü o nte c'o pe'ch'e a xes'e o mojmü 'ñe o xalo, pero dya xibi na jo a mbo. Nguec'ua na s'o a mbo c'o mojmü 'ñe c'o xalo. Je xo ga cjatsc'eji nu nu'tsc'eji i̱ṉ fariseoji. I̱ṉ xindyëji i̱ṉ tjintsiji c'ü ni xes'ets'üji pero bübü a mbo in mü'büji c'o na s'o; me i̱ṉ jodü ja rgui tsjapü in tsjacjeji c'o pë's'i yo nin minteji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nu'tsc'eji, dya i̱ṉ unnc'eji ngüenda ja ga cja. O ngambgagöji Mizhocjimi. Ne angueze c'ü dya nguextjo c'ü ni xes'ets'üji c'ü ra 'nin'tsc'iji; ne c'ü xo ra 'nin'tsc'iji in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Rí dyötüji Mizhocjimi ra ndin'tsc'iji in mü'büji. Nu'ma, dya cja cjó pje rí jñünbüji. Y rí unüji co texe in mü'büji c'o pje ni jyodü. Nuc'ua rrã jo c'ü ni xes'ets'üji, xo 'ñe a mbo in mü'bügueji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Nu'tsc'eji i̱ṉ fariseoji, i̱ṉ mbeñeji Mizhocjimi i̱ṉ unüji o xits'ajna 'ñe o lota 'ñe c'o 'ñaja pjin'ño c'o cja'a cja in juajmaji. Na jo rí tsjaji a cjanu, dya rí jyëziji. Pero juentsc'eji, ra castigaots'üji Mizhocjimi. Na ngue dya i̱ṉ cjaji ja c'o nzi ga ne Mizhocjimi, y dya i̱ṉ neji angueze co texe in mü'büji. Nujyo, ngueje yo xenda mi jyodü rvi tsjagueji yo. ");
INSERT INTO mazNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Nu'tsc'eji i̱ṉ fariseoji, juentsc'eji ra castigaots'üji Mizhocjimi. Na ngue 'ma i̱ṉ pöcjeji cja nintsjimi, me i̱ṉ juajnüji o lugar c'o xenda na jo nu ja rí mimiji. Me xo i̱ṉ neji c'ü ra mbë'sc'iji t'ecjañõmü rgá zenguats'üji cja chõjmü. ");
INSERT INTO mazNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’'Ma dya jä'p'äji o panteón a xes'e nu ja t'ögü o añima, yo nte nzhodüji a xes'e na ngue dya pãrãji cjo je t'ögü nu 'na añima. Nguec'ua mamaji contaminaoji. Je xo ga cjatsc'eji nu, nu'tsc'eji i̱ṉ xöpüteji 'ñetsc'eji i̱ṉ fariseoji. I̱ṉ cjapüji na jots'üji; nguec'ua yo nte nzhodüji co nu'tsc'eji. Pero dya pãrãji c'ü bübü in mün'c'eji c'o na s'o. Nguec'ua xo ra s'odü o̱ mü'büji. Nguec'ua juentsc'eji ra castigaots'üji Mizhocjimi, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","O ndünrü c'ua 'naja c'o me mi pãrã o̱ ley Mizhocjimi, o xipji e Jesús: ―Xöpüte, c'ü vi xipjigue yo fariseo, xo 'ñezgöjme xo i̱ huënzhguigöjme. ");
INSERT INTO mazNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","E Jesús o mama c'ua o xipji c'e bëzo: ―Nu'tsc'eji i̱ṉ pãrãji o̱ ley Mizhocjimi, juentsc'eji xo ra castigaots'üji Mizhocjimi. Na ngue i̱ṉ xipjiji yo nte c'o ley c'o na s'ëzhi c'o dya sö ra cumpleji. Chjëntjui c'ü ri ätc'eji o trapöjö c'o ri tũtüji, c'o me na jyü rgá nduns'üji. Pero dya i̱ṉ ne rí pasp'üji ne ri 'naja in ñidyëgueji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Juentsc'eji ra castigaots'üji Mizhocjimi. I̱ṉ jä'p'äji o panteón c'ua ja t'ögü c'o profeta. Ngueje c'o in mboxpalegueji c'o o mbö't'ü c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","C'o in mboxpalegueji o mbö't'üji c'o profeta; nu'tsc'eji i̱ṉ jä'p'äji o panteón c'ua ja t'ögü c'o profeta. A cjanu, ixi 'ñetse c'ü i̱ṉ mäji c'o vi tsja c'o in mboxpaleji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Mizhocjimi ix mi pãrã c'ü ro zädä a cjanu; nguec'ua va mama: “Rá juajnügö o profeta 'ñe o apóstole ra zopjüji c'o nte. Bübü c'o ra mbö't'üji; bübü c'o ra nu'uji na ü, ra tsjapüji ra sufreji.” ");
INSERT INTO mazNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ndeze 'ma o jyas'ü ne xoñijõmü, ya mbö't'üji na puncjü o profeta. C'ü ot'ü o mbö't'üji, mi ngue e Abel. C'ü bëpja o mbö't'üji, ngue e Zacarías c'ü o mbö't'üji a tji cja c'e lugar c'ü na sjũ, nu ja chäjui c'e arta nu ja päsp'äji o animale Mizhocjimi. Nu'tsc'eji i̱ṉ cãrãji yo cjë dya, i̱ṉ cjijñiji ja c'o nzi ma nguijñi c'o in mboxpalegueji. Nguec'ua ra jñün'c'eji ngüenda Mizhocjimi c'ü xo ngue in s'ocügueji c'ü vi mbö't'üji ndeze e Abel hasta e Zacarías. Nu'tsc'eji i̱ṉ cãrãji yo cjë dya, ngue'tsc'eji rí tsjõt'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Mama o̱ ley Mizhocjimi ra ẽjẽ 'naja c'ü ra 'ñe salvats'üji. Zö i̱ṉ pãrãgueji na jo o̱ ley, pero dya i̱ṉ unüji ngüenda c'ü nguetscö ró ẽjẽ. C'o cja ni unütjo ts'ë ngüenda cjó nguetscö, nan'ño gui xipjiji c'o. Nguec'ua, dya xo pãrãji ja rgá sö ra salvaji. Juentsc'eji, ra castigaots'üji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","'Ma o nguarü e Jesús o mama c'o jña, nuc'ua c'o xöpüte 'ñe c'o fariseo me go sjëyaji o dyönüji na puncjü o t'önü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Me mi te'beji pje ro mama e Jesús, nza cja yo nte 'ma te'beji 'na animale ra zürüji. Mi te'beji, xa'ma pje c'o ro mama e Jesús nguec'ua ro sö ro ngöt'üji cja c'o mero mi pjëzhi na nojo. ");
INSERT INTO mazNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ma jmurü na puncjü o nte cja jmi e Jesús; dya 'mãrã ja nzi mil mi cãrã. Mi pötma chütüji. Nuc'ua o mbürü e Jesús o xipji c'o o̱ discípulo: ―Pjötpügueji na puncjü ngüenda c'ü dya rí tsjaji nza cja yo fariseo. Anguezeji cjapüji na joji, pero bübü o̱ mü'büji c'o na s'o, chjëntjui nza cja o cjüjnü 'ma ya ixqui 'ma chjanbaji o cjüjnü c'o dya ixqui. ");
INSERT INTO mazNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yo fariseo, zö cädäji c'o na s'o c'o cjaji 'ñe c'o cjijñiji, pero ra zädä 'ma ra jñetse c'o. Y zö cjaji para dya cjó ra mbãrã, pero ra zädä 'ma ra mbãrãji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","C'o jña c'o i̱ṉ ñatsjëji cja in nzumüji, ra zädä c'ü ra mbãrã texe yo cãrã cja in jñiñiji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Nu'tsc'eji rí dyocjöji, dyäräji c'ü rá xi'tsc'öji. Dya rí sũgueji yo nte. Zö ra mbö'tc'üji in cuerpoji, pero dya xe sö pje xe ra tsja'c'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Rá xi'tsc'öji dya, cjó ngue c'ü rí sũgueji. Sũgueji Mizhocjimi c'ü sö ra mbö'tc'üji c'ü xo sö ra pantc'aji a linfiernu. Jã, ngue c'ü rí xi'tsc'öji rí sũgueji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Yo ts'ins'ü, maco ni muvitjo yeje centavo por tsi'ch'a, pero Mizhocjimi pjörü yo. ");
INSERT INTO mazNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xo 'ñe in ñixtegueji, zö dya ni muvi yo, pero Mizhocjimi pãrã ja nzi sö'ö yo. Mizhocjimi pjörü yo ts'ins'ü; xo ra mbö'c'ügueji. Na ngue xenda ni muvits'ügueji a jmi que na puncjü o ts'ins'ü. Nguec'ua dya rí sũgueji pje ra tsja'c'üji yo nte. ");
INSERT INTO mazNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Rí xi'tsc'öji, nu c'ü ejmezü c'ü ra xipji yo nte c'ü rvá ẽcjö cja Mizhocjimi, nutscö rá xipji c'o o̱ anxe Mizhocjimi c'ü ngue ín ntegö c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero 'ma cjó c'o ra xipji yo nte c'ü dya ejmezü 'ñe dya pãcãgö, nu'ma, rá xipjigö c'o o̱ anxe Mizhocjimi c'ü dya xo rí pãrãgö c'e nte c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’'Ma cjó c'o dya ra unü ngüenda c'ü rvá ẽcjö cja Mizhocjimi; zö ra zangüji, pero ra sö ra perdonaoji c'o. 'Ma cjó c'o ra 'ñünbü o̱ mü'bü o̱ Espíritu Mizhocjimi nguec'ua ra mbãrã c'e nte pje pjëtscö, pero 'ma dya ra 'ñejmezü, chjëntjui c'ü ro zadü o̱ Espíritu Mizhocjimi. Nu'ma, dya ra perdonaoji 'ma c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Nu'tsc'eji i̱ṉ tenngueji co nutscö, ra zints'iji cja nintsjimi ra jñün'c'üji ngüenda c'o pje pjëzhi nu. O ra zints'iji cja o juesi, o c'o xenda pjëzhi na nojo. Pero dya rí tsjijñiji ja rgui chjünrüji, 'ñe pje rí mangueji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Na ngue o̱ Espíritu Mizhocjimi ra mböxc'üji c'e ndajme c'ü, ra jí'ts'iji c'ü rguí jyodü rí mamaji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","O ña c'ua 'naja c'o nte o xipji e Jesús: ―Xipjigue nín cjuarma rá jyadübe c'o o zogü c'ü mi tatagöbe. ");
INSERT INTO mazNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","O ndünrü c'ua e Jesús o xipji: ―Nu'tsc'e i̱ṉ cjijñi c'o na s'o. Dya 'ñembguegö Mizhocjimi rá cjagö juesi rá jyan'c'üvi c'o o zogü nin tatavi. ");
INSERT INTO mazNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","O sido o ña e Jesús o xipji texe c'o nte: ―Pjötpügueji na puncjü ngüenda c'ü dya rí jyodüji ja rgui pë's'iji na puncjü o merio. Dya xo rí jyodüji ja rgui chjëji na puncjü o juajma, ni xo ri ngue o animale rí tsãji na puncjü. Zö ri pë's'i 'na nte na puncjü, pero dya ngue c'ü na cjuana rguí mäjä o̱ mü'bü c'e nte. ");
INSERT INTO mazNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Cjanu o xipjiji 'na ejemplo c'o nte, o mama: ―Mi bübü 'na bëzo c'ü mi pë's'i na puncjü. C'o o̱ juajma o unü na puncjü o ndëxü. ");
INSERT INTO mazNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nguec'ua va mamatsjë c'ua: “¿Pje xe rá cjagö? Na ngue ojtjo ja xe rá üt'ü yo ndëxü, na ngue ya nizhi cja yo ín ch'ujmü.” ");
INSERT INTO mazNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","O mama c'ua: “C'ü rá cja'a, rá mandagö ra yätcäji yo ín ch'ujmü, cja rrũ jyäpcäji c'o xenda rrã nojo. Nguec'ua je rá üt'ügö texe nu c'o ín nzhëxü 'ñe texe c'o rí pë'sc'ö. ");
INSERT INTO mazNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Rí pë'sc'ö na puncjü dya; ra mezhe na puncjü o cjë. Rá söyagö dya. Rá mägö dya, rga sigö o xëdyi, y pje c'o nde rá sigö”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","O mama c'ua Mizhocjimi o xipji c'e bëzo: “Nu'tsc'e i̱ṉ cjijñigue na s'o. Ixtí chũgue dya ne xõmü. Me i̱ jyodü ja vi pë'sc'e na puncjü, pero dya ra sö rí chunügue yo”, eñe Mizhocjimi va xipji c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","O sido o ña e Jesús o xipji c'o nte: ―C'ua ja va tsjapü Mizhocjimi c'e bëzo, je xo rga cjanu rgá tsjapü texe c'o ra jyodü ja rgá mbë's'i na puncjü, y dya ra jyodüji Mizhocjimi para ra ch'unüji c'ü na cjuana ni muvi. ");
INSERT INTO mazNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","E Jesús o xipji c'ua c'o o̱ discípulo: ―Nguec'ua rí xi'tsc'öji, dya rí tsjijñiji ja rgui chöt'üji c'ü rí siji. Dya xo rí tsjijñigueji c'ü pje rí jyeji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mizhocjimi o ngampc'aji va. Nadya, ¿cjo dya xo ra dya'c'üji c'ü rí siji, 'ñe c'ü rí jyegueji? ");
INSERT INTO mazNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tsjijñiji yo s'ü. Dya podüji o ndëxü, dya xo tagüji, dya pje xo üt'üji cja t'ujmü. Maco Mizhocjimi 'huiñi yo. Nu'tsc'eji, xenda ni muvits'ügueji que na ngue yo s'ü. Nguec'ua, ¿cjo dya xo ra 'huintsc'eji Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Dya cjó bübütsc'eji c'ü sö ra chäcä 'naja nde metro c'ü xe rrã ndã. ");
INSERT INTO mazNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Maco dya sö rí chäcäji 'na nde metro c'ü xe rrã ndãts'üji, ¿jenga i̱ṉ cjijñiji ja rgui chöt'üji c'ü pje rí sigueji 'ñe c'ü pje rí jyeji? ");
INSERT INTO mazNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Unüji ngüenda ja ga te yo lirio. Dya pëpjiji, dya xo jench'eji o tjüjmü para ra dyät'äji o̱ bituji. Pero me na zö yo. E Salomón mi pjëzhi na nojo, mi je o̱ bitu c'o me ma zö. Pero xenda na zö yo lirio. ");
INSERT INTO mazNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yo pjin'ño cja'a cja juajma, pero ra xõrü münü ra ngant'aji cja hornu ra ndüt'üji yo; maco Mizhocjimi unü c'ü na zö o̱ ndäjnä yo. Natsc'eji, ¿cjo dya xo ra dya'c'üji Mizhocjimi c'ü rí jyegueji? Nguec'ua, ¿jenga dya i̱ṉ junt'ü in mü'büji c'ü ra dya'c'üji Mizhocjimi c'o ni jyodüts'üji? ");
INSERT INTO mazNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nguec'ua, dya me rí tsjijñiji ja rgui chöt'üji c'ü pje rí siji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Na ngue yo dya pãrã Mizhocjimi ngueje yo me jodü ga cjanu yo. Pero nu'tsc'eji i̱ṉ 'ñecjeji c'ü nin Tataji c'ü bübü a jens'e c'ü pãrã c'ü nde ni jyodüts'üji texe yo. ");
INSERT INTO mazNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nu'tsc'eji ot'ü rí jyodüji ja rgui tsjaji ja c'o nzi ga mandats'üji Mizhocjimi, na ngue in Jmugueji c'ü. Nu 'ma rí tsjaji a cjanu, texe yo, nde ra dya'c'üji yo. ");
INSERT INTO mazNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’I̱ṉ chjëntcjeji nza cja o ndënchjürü. Y ja nzitjots'üji. Pero dya rí sũgueji. Na ngue c'ü ín Tatagöji ne ra dya'c'üji c'ü rgui bübütjoji co angueze nu ja manda, na ngue o̱ ntets'üji dya. ");
INSERT INTO mazNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pöji c'o i̱ṉ pë's'iji 'ñe rí unüji c'o pje ni jyodü. 'Ma rí pë's'itjogueji in merioji, 'na ra ẽ o mbẽ ra 'ñe põnnc'üji. O 'ma jiyö, ra s'odü c'o. Pero 'ma rí unügueji c'o pje ni jyodü, rí pë'sc'eji 'ma a jens'e c'o na cjuana ni muvi c'o dya ra s'odü. Nujnu, dya sät'ä o mbẽ ra põnnc'üji c'o. Dya xo bübü o dyoxü ra tsjapü ra dya c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nu 'ma rí pë's'igueji na puncjü cja ne xoñijõmü, je rgui mäcjeji 'ma c'o ri pë's'iji cja ne xoñijõmü. Pero 'ma ra bë'sc'iji na puncjü a jens'e, je rgui mäcjeji 'ma c'o ri pë's'iji a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","’'Ma ra ma 'na bëzo cja chjüntü, c'o o̱ mbëpji ra nde'beji hasta 'ma cja ra nzhogü. Ra xa'maji na jo, y ra ndütüji o sivi. Ra nde'beji ngue c'ua 'ma ra nzhogü c'ü nu lamuji ra ma't'ü cja ngoxtji, jo rrũ xopcüji ra cjogü c'ua a mbo. Je xo rgui tsjagueji a cjanu rí chepqueji, na ngue rá ẽcjö na yeje. ");
INSERT INTO mazNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","'Ma ra nzhogü c'e lamu, 'ma ra chöt'ü rrã te'betjo c'o mbëpji, ra tsja c'e lamu ra mäpä c'o mbëpji. Na cjuana c'ü rí xi'tsc'öji, c'e lamu ra xipji c'o mbëpji ra mimiji cja mexa. Nuc'ua ra ts'o's'ü c'ü mi tëjë ra 'huiñi c'o mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Zö ya rguí ndexõmü 'ma ra säjä c'e lamu, o zö ya rguí 'ñetsajõmü, pero ni jyodü c'o mbëpji ra nde'beji, dya ra ĩji. 'Ma ra 'ñe chöt'ü c'e lamu c'ü rrã te'betjo c'o mbëpji, ra tsja c'e lamu me ra mäpä c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","'Na bëzo c'ü ri xo'tp'üji o̱ ngumü, nu 'ma ro mbãrã pje ma ndajme c'ü ro ẽjẽ c'e mbẽ, dya ro ĩjĩ, ro nde'betjo, dya ro jyëzi ro xo'tp'ü c'ü nu ngumü. ");
INSERT INTO mazNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Je xo rga cjatsc'eji nu rí pjötpüji ngüenda, na ngue nutscö rá ẽcjö na yeje cja Mizhocjimi c'e ndajme c'ü dya ri tepcöji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nuc'ua e Pedro o xipji e Jesús: ―Nu'tsc'e ín Jmuts'ügöjme. C'o jña c'o cja i̱ mangue, ¿cjo nguetscöjme i̱ xitscöjme c'o, o ngue texe yo nte? ");
INSERT INTO mazNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","O ndünrü c'ua e Jesús c'ín Jmugöji: ―Para rí pãrãgueji, rá xi'tsc'öji 'na ejemplo. 'Na lamu 'ñeje 'na mbëpji c'ü manda cja c'o nu mimbëpjiji. 'Ma cjacjuana c'e mbëpji, 'ñe 'ma pãrã ra pëpji na jo, ra tsja c'e lamu ra xipji c'e mbëpji ra 'huinbi c'o nu mimbëpjiji 'ma nzi ga zant'aji. Ra ma c'ua c'e lamu. ");
INSERT INTO mazNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nuc'ua 'ma ra nzhogü c'e lamu, 'ma ra 'ñe chöt'ü c'e mbëpji rrã cja'a c'o vi xipji, me ra mäpä 'ma c'e mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na cjuana c'ü rí xi'tsc'öji, c'e lamu ra unü c'e mbëpji c'ü ra mbötpü texe c'o ri pë's'i c'e lamu. ");
INSERT INTO mazNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Pero 'ma ri s'ombëpji c'e mbëpji, 'ñe ra mamatsjë: “C'ín lamugö ra mezhtjo c'ü”, ra 'ñeñe, 'ñe 'ma ra yabü c'o nu mimbëpjiji zö bëzo zö ndixũ, 'ñe me ra zi o xëdyi 'ñe ra zi c'o rguí tĩ, nuc'ua, ra ẽjẽ c'ü o̱ lamu c'e pa c'ü dya ri te'be, 'ñe c'e ndajme c'ü dya ri pãrã. Nuc'ua c'e lamu ra manda ra jyüt'üji na puncjü co chirrio c'e mbëpji, cja rrũ pant'aji c'ua ja rva cã c'o vi tsja na s'o. ");
INSERT INTO mazNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’C'o mbëpji c'o pãrã c'o ne c'o nu lamu, pero 'ma dya cjaji c'o, ni xo ri te'beji ra nzhogü c'o nu lamu, ra jyüt'üji na puncjü 'ma c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bübü o mbëpji c'o dya nda pëpji na jo, na ngue dya nda pãrãji pje pjëzhi c'ü ne c'o nu lamu. Anguezeji merecido xo ra jyüt'üji co chirrio. Pero dya nda ra jyüt'üji, na ngue dya nda pãrãji c'o ne c'o nu lamu. Nu c'o ch'unü ra mbãrã c'o ne Mizhocjimi ra tsjaji, ni jyodü ra tsjaji c'o. Nu c'o xenda ch'unü ra mbãrã, ngue c'o ni jyodü xenda ra tsjaji. 'Ma jiyö, xenda ra castigaoji 'ma c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Na ngue c'ü rvá ẽcjö cja ne xoñijõmü, ra zädä 'ma ra bübü o chũ cja ne xoñijõmü. Rí negö c'ü ya ri sädä. ");
INSERT INTO mazNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero ni jyodü ot'ü rá sufregö na puncjü. Me rí cjijñigö; me rí negö c'ü ya rva sufregö. ");
INSERT INTO mazNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","I̱ṉ pëzhgueji rvá ẽcjö cja ne xoñijõmü ngue c'ua dya cja ra chũ yo nte. Pero dya ngue c'ü rvá ẽcjö c'ü. Na ngue c'ü rvá ẽcjö, ra bübü o chũ cja yo nte. ");
INSERT INTO mazNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ndeze nudya, ra bübü o chũ. Cja 'na ngumü c'ü ri cãrã tsi'ch'a o nte, jñi c'o ra nu'u na ü c'o yeje, na ngue c'ü ri ätcävi ín jña. O 'ma jiyö, yeje c'o ra nu'u na ü c'o jñi. ");
INSERT INTO mazNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","'Na bëzo ra nu'u na ü c'ü nu t'i; o c'e t'i ra nu'u na ü c'ü nu tata. 'Na ndixũ ra nu'u na ü c'ü o̱ xunt'i; o c'e xunt'i ra nu'u na ü c'ü nu nana. 'Na ndixũ ra nu'u na ü c'ü nu cjö'ö; o c'e cjö'ö ra nu'u na ü c'ü nu cö'ö. ");
INSERT INTO mazNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","E Jesús o sido o ña, o xipji c'ua c'o discípulo 'ñe c'o 'ñaja nte: ―'Ma i̱ṉ jandaji 'na trangõmü va cjins'i, ix i̱ṉ mangueji c'ua: “Ra 'ñeje o dyebe”, i̱ṉ eñeji. Y ra 'ñeje. ");
INSERT INTO mazNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","'Ma i̱ṉ unüji ngüenda vü'ü c'e ndajma c'ü je ni 'ñeje a ma a Sur, i̱ṉ mamaji c'ü me rrã pa. Y me rrã pa. ");
INSERT INTO mazNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","I̱ṉ unüji ngüenda ja ga 'ñetse a jens'e ngue c'ua i̱ṉ pãrãji ja ga cja yo jopa 'ñe yo ra 'ñeje o dyebe. Maco ya i̱ dyäräji na puncjü c'o rvi pãrãgueji c'ü rvá ẽcjö cja Mizhocjimi, ¿jenga dya i̱ṉ ejmezüji? ");
INSERT INTO mazNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Nguec'ua rí önnc'üji, ¿jenga dya i̱ṉ cjaji ja c'o nzi ga ne Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","'Na nte c'ü pje vi tsjapü c'ü 'na nte, 'ma ra zidyiji cja juesi, 'ma cja ri pëtjovi cja 'ñiji, na jo ra zopjü c'e nte c'ü pje vi tsjapü, ra ñavi ja rgá reglavi. 'Ma jiyö, ra zidyiji cja c'e juesi. Nuc'ua c'e juesi ra nzhö'ö cja c'e mböpjörü. Y c'e mböpjörü ra pant'a a pjörü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Dya ra mbedye nu, hasta 'ma cja ra ngõt'ü texe c'o tũ. Je xo rga cjatsc'eji nu, 'ma dya rí dyötüji Mizhocjimi ra perdonaots'üji c'o na s'o c'o i̱ṉ tunpüji, nu'ma, ra castigaots'üji 'ma c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mi cãrã nu c'o cja vi säjä. Nuc'ua cjanu o ñaji c'ua o xipjiji e Jesús ja va bö't'ü ja nzi nte c'o mi menzumü a Galilea. Nuc'o, vi möji cja c'e templo o ma unüji c'o o̱ animaleji ro mbäsp'äji Mizhocjimi. Nuc'ua e Pilato o manda c'o o̱ tropa o ma mbö't'üji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","O ndünrü c'ua e Jesús o xipjiji: ―C'o nte c'o o mbö't'üji, i̱ṉ pëzhgueji c'ü xenda mi cja c'o na s'o c'o, que na ngue c'o 'ñaja o̱ menzumüji, nguec'ua va mbö't'üji c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pero rí xi'tsc'öji, dya je ga cjanu. Xo 'ñetsc'eji xo rí chũgueji, 'ma dya rí jyëziji c'o na s'o, 'ma dya ra nzhogü in mü'büji cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","I̱ṉ mbeñeji ja va tunü c'e torre c'ü xiji Siloé. O ndibi c'o nte, o ndũji dieciochoji. I̱ṉ pëzhgueji c'ü xenda mi cja c'o na s'o c'o, que na ngue c'o 'ñaja c'o cãrã a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pero rí xi'tsc'öji, dya je ga cjanu. Xo 'ñetsc'eji xo rí chũgueji 'ma dya rí jyëziji c'o na s'o, 'ma dya ra nzhogü in mü'büji cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","O sido o ña e Jesús o xipjiji 'na ejemplo, o mama: ―Mi bübü 'na bëzo c'ü mi pë's'i 'na huerta c'ü mi cja o uva. Nujnu, xo vi 'ñench'e nu 'na fruta c'ü ni chjũ higo. 'Na nu pa, o ẽjẽ c'e bëzo cja c'e huerta ro ẽ nu'u cjo mi quis'i o higo. Pero dya pje chöt'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nuc'ua cjanu o xipji c'ü o̱ mbëpji c'ü mi pjörü c'o uva: “Ya sö jñi cjë c'ü rvá ẽ nu'u ne higo cjo quis'i, pero dya pje rí töt'ü. Ixtí dyëch'i. 'Ma jiyö, bëzhitjo tiempo ja 'ne'e.” ");
INSERT INTO mazNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nuc'ua o ndünrü c'e mbëpji o mama: “Nu'tsc'e ín lamuts'ügö, rí ö'tc'ügö xe rí jyëzi ne cjë dya nu, ndezc'e rá tsõtpügö e jõmü y xo rá jä'tp'ä o lama. ");
INSERT INTO mazNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nu 'ma ra nguis'i, dya rá ëch'iji 'ma. Nu 'ma jiyö, rá ëch'igö ja nzi gui xitsi.” ");
INSERT INTO mazNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","'Na nu pa c'ü mi söyaji, o ma e Jesús cja 'na nintsjimi. O ma xöpü c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mi bübü nu 'na ndixũ c'ü mi sö'dyë. Ya vi mezhe dieciocho cjë vi zürü 'naja o̱ s'ondajma e Satanás c'ü dya jo, mi cjapü ra zö'dyë mi mocü ma nzhodü. Dya mi sö ro xos'ü o̱ xütjü ro böbü derecho. ");
INSERT INTO mazNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","E Jesús 'ma mü o jñanda c'e ndixũ o ma't'ü o xipji: ―Chjä'dä a 'ñecjua. Cjanu o xipji: ―Süngü, ra c'ueñe dya c'ü i̱ṉ sögue na ü, embe. ");
INSERT INTO mazNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Cjanu o 'ñe's'e o̱ dyë cja c'e ndixũ. Nuc'ua c'e ndixũ cjanu o xos'ü o̱ xütjü o böbü derecho. Cjanu o unü 'na pöjö Mizhocjimi o mama: ―Me na jo Mizhocjimi o tsjacü o ndixqui. ");
INSERT INTO mazNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","C'ü mi xo'ñi cja c'e nintsjimi, dya go ne a cjanu. Na ngue mi xabaro 'ma mü o jocü e Jesús c'e ndixũ; mi ngue c'e pa 'ma mi söyaji. Go üdü c'e bëzo o xipji c'o nte: ―I̱ṉ pãrãji 'ñanto pa nu ngo c'ü ni jyodü rá pëpjiji. Ngue c'o pa c'o na jo rí 'ñeji ngue c'ua ra ndixc'i in nzemeji. Dya rí 'ñecjeji dya, na ngue ngueje ne pa nu rí söyaji, embeji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","O ndünrü c'ua e Jesús c'ín Jmugöji o xipji c'e bëzo, 'ñe c'o mi dyoji: ―¿Jenga i̱ṉ mangueji na s'o c'o rí cjagö rí jocü c'o sö'dyë ne pa 'ma rí söyagöji? Maco nu'tsc'eji i̱ṉ xäpcägueji c'o in nzhünüji 'ma xabaro, 'ñe c'o in burruji, cja rrĩ ma unüji o ndeje. ");
INSERT INTO mazNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nujne ndixũ nu, je mboxbëche cja e Abraham. Ya vi zürü c'ü dya jo, chjëntjui c'ü ro ndün't'ü o tjüjmü para dya ro nzhodü libre. Ya vi mezhe dieciocho cjë. Maco i̱ṉ xäpcägueji in animaleji, na ne ndixũ, ¿cjo dya xo mi jyodü ro emegö libre nu? ");
INSERT INTO mazNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","C'o mi nu'u na ü e Jesús, 'ma mü o dyäräji c'o jña, o bëzhi o tseji c'ua, dya sö pje xe ro mamaji. Pero c'o 'ñaja nte, me go mäji na ngue c'o me ma nojo c'o mi cja e Jesús, 'ñe c'o me ma zö. ");
INSERT INTO mazNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Xe go ña e Jesús o xipjiji: ―Rá xi'tsc'öji 'na jña ngue c'ua rí pãrãji ja ga manda Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","C'ü ni manda Mizhocjimi, chjëntjui nza cja 'naja ndömortasa c'ü o jñü 'na bëzo, cjanu o ma ndujmü cja o̱ juajma. Nuc'ü, o mbes'e o nocü, o chjënjui 'naja za'a c'ü na ndã. O ẽjẽ c'ua o s'ü o 'ñe dyät'ä o̱ t'oxüji nu. ");
INSERT INTO mazNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Xo mama c'ua na yeje e Jesús: ―Rá xi'tsc'öji c'ü 'na jña ngue c'ua rí pãrãji ja ga manda Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","C'ü ni manda Mizhocjimi, chjëntji nza cja o ixcjüjnü c'ü o jñü 'naja ndixũ o huanba jñi vola o jocjüjnü, hasta 'ma o ixqui texe c'e cjüjnü. ");
INSERT INTO mazNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","E Jesús sido mi mbeñe c'ü mi jyodü ro ma a Jerusalén. Pero mi sät'ä nzi 'na jñiñi, mi xöpü c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","'Na nte o dyönü e Jesús: ―Nu'tsc'e xöpüte, ¿cjo ja nzitjo c'o ra zät'ä nu ja bübü Mizhocjimi? Nuc'ua e Jesús o ndünrü o xipji c'o nte: ");
INSERT INTO mazNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Me rí jyodüji rí sät'äji nu ja manda Mizhocjimi. Na ngue c'ü rgui sätc'eji nu, na s'ëzhi, chjëntjui c'ü ri cjogü 'na nte cja 'na ngoxtji c'ü me s'is'i. Rí xi'tsc'öji, na puncjü c'o ra jyodü ja rgá cjogüji, pero dya ra sö ra cjogüji. ");
INSERT INTO mazNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nu c'ü o̱ cjaja c'e ngumü, ra zädä 'ma ra ngot'ü c'e ngoxtji. 'Ma cja rí sät'äji 'ma ya rguí cjot'ü c'e ngoxtji, dya cja ra xocüts'üji. Zö rí bönc'eji nu cja c'e ngoxtji rí püt'üji rí mamaji: “Nu'tsc'e ín Jmuts'ügöjme, xocüzüme”, rí 'ñembeji, pero dya ra xocüts'üji. C'ü ra tsja ra xi'ts'iji: “Dya rí pã'c'öji, dya ngue ín ntetsc'öji”, ra 'ñents'eji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nuc'ua rí xipcjeji: “Maco nutscöjme ró sigöji o xëdyi, 'ñe 'ma mi jizhigue cja c'o 'ñiji cja c'o ín jñiñigöjme, xo ma bünc'öjme nu, mi äräjme.” ");
INSERT INTO mazNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ra ndünrü c'ua angueze ra xi'ts'iji: “Ya ró xi'tsc'öji c'ü dya rí pã'c'öji. Nu'tsc'eji i̱ tsjaji c'o na s'o. C'ueñeji cja ín jmigö i̱ṉ texeji.” ");
INSERT INTO mazNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nuc'ua me rí huëgueji y me ra nguünxt'ü in s'ibi rgui sufreji. Na ngue ri jandagueji e Abraham, 'ñe e Isaac 'ñe e Jacob 'ñe texe c'o profeta ri cãrãji co Mizhocjimi nu ja ri manda, pero nu'tsc'eji dya ra xocüts'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ra ẽjẽ na puncjü o nte, ra 'ñe ngãrãji nu ja ri manda Mizhocjimi, me ra mäji cja o̱ jmi. Rguí 'ñeji nu ja ni mbes'e e jyarü 'ñe nu ja ni nguibi. Xo rguí 'ñeji a ma a norte 'ñe a ma a sur. ");
INSERT INTO mazNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","C'o cjapü cja na jo nguec'ua pëzhiji ra zät'äji nu ja manda Mizhocjimi, dya ra zät'ä c'o. C'o unü ngüenda c'ü dya ni muviji a jmi Mizhocjimi, ra zät'ä c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","C'e pa c'ü, o ẽjẽ ja nzi o fariseo o 'ñe xipjiji e Jesús: ―Pedye va rí mague. Na ngue ne ra mbö'tc'ü e Herodes c'ü manda va. ");
INSERT INTO mazNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","O ndünrü c'ua e Jesús o xipjiji: ―Zö pë's'i na puncjü o̱ pjeñe e Herodes c'ü ne ra mbötcügö c'ü, pero möji ma xipjiji c'ü ni jyodü rá pjongü o̱ s'ondajma e Satanás c'ü dya jo, Rá jocü c'o sö'dyë. Xipjigueji c'ü rá cjagö yo, hasta 'ma cja rá cjuatügö ne bëpji. ");
INSERT INTO mazNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Zö ne ra mbötcügö c'ü, pero rá sido rá cjagö ne bëpji hasta 'ma rá cjuatügö. Na ngue je ngueje a Jerusalén nu ja pö't'üji texe c'o ña o̱ jña Mizhocjimi; dya ngue va. Nu'tsc'eji rí xiqueji a cjanu e Herodes. ");
INSERT INTO mazNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O sido o ña e Jesús o mama: ―Nu'tsc'eji i̱ṉ menzumüji a Jerusalén, i̱ṉ pö't'üji c'o profeta 'ñe i̱ṉ pjat'üji o ndojo c'o juajnü Mizhocjimi ra zo'c'üji. Ró juen'tsc'öji na puncjü. Mi negö ro jmu'tc'üji c'ua ja nzi ga tsja'na ngöñi juis'i c'o o̱ ts'ingöñi a mbo cja o̱ juaja, pero dya xo i̱ ñeji ri dyätcäji ín jña. ");
INSERT INTO mazNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dyäräji c'ü rá xi'tsc'öji. Xe järätjo a Jerusalén nu nin jñiñigueji, pero ya jyëtsc'iji dya Mizhocjimi. Rí xi'tsc'öji, ndeze ne ndajme dya, dya cja xe rí jñandgöji va hasta 'ma cja rí mamaji: “Me na jo nu va ẽjẽ nu o 'ñeme Mizhocjimi ra manda”, rí 'ñeñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","O ẽjẽ 'na nu xabaro, e Jesús o ma cja o̱ ngumü 'naja c'o fariseo c'ü mi xo'ñi cja 'naja nintsjimi, o ma ziji o xëdyi. C'o ma cã'ã nu, me mi jandaji e Jesús me mi äräji xa'ma ro mama o jña c'o dya mi jyodü. ");
INSERT INTO mazNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nu a jmi e Jesús, mi bübü 'na bëzo c'ü mi sö'dyë, mi pjänt'ä texe o̱ cuerpo. ");
INSERT INTO mazNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nuc'ua e Jesús o xipji c'o fariseo 'ñe c'o mi pãrã o̱ ley Mizhocjimi: ―¿Pje mama o̱ ley Mizhocjimi? ¿Cjo na jo rá jocüji yo sö'dyë 'ma xabaro? Maco ngue nu pa nu rí söyaji. ");
INSERT INTO mazNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Anguezeji dya ndünrüji. Nuc'ua e Jesús o 'ñe's'e c'ua o̱ dyë c'e bëzo c'ü mi pjänt'ä, o jocü cjanu o xipji: ―Ma dya in nzumü, embe. ");
INSERT INTO mazNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cjanu o xipji c'o fariseo: ―'Ma ri 'ñegueji 'na burru o 'na ts'inzhünü, nu 'ma ro zo'o cja 'na pozo, ro zo'o c'ü xabaro c'ü ngue 'ma rí söyaji, ¿cjo dya ri ma tsjünc'eji c'ü? ");
INSERT INTO mazNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Anguezeji dya mi pãrãji ja rvá ndünrüji. ");
INSERT INTO mazNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","E Jesús o jñanda c'o nte c'o vi mbitaji ro ziji o xëdyi, me mi juajnüji c'o xenda na jo nu ja ro mimiji. Nguec'ua va mama e Jesús o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―'Ma cjó c'o ra mbitats'üji rí möji cja chjüntü, dya rí ma mimiji nu ja xenda na jo. 'Na ra ẽjẽ 'naja c'ü vi mbitaji c'ü xenda ri pjëzhi na nojo que rá ngue'tsc'eji. ");
INSERT INTO mazNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nuc'ua ra ẽjẽ nu c'ü o mbitats'üji ra 'ñe xi'ts'iji: “Chjench'e xe rí mimi a ma c'ua. Na ngue nu ja i̱ṉ junrügue, ra mimi ne bëzo”, ra 'ñents'eji. Nuc'ua ix 'na tsetjo rgui ma minc'eji cja squina. ");
INSERT INTO mazNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","C'ü rí tsjagueji 'ma ra mbitats'üji, rí minc'eji a squina, ngue c'ua 'ma ra säjä in jmigueji nu c'ü o mbitats'üji, xa'ma ra xi'ts'iji: “Nu'tsc'e rí jogövi na jo, je rgui 'ñe cjuã rí mimi nu ja xe na jo”, ra 'ñents'eji. Nuc'ua c'o rrũ jũ'ũ cja mexa, ra unüji ngüenda c'ü me nets'eji c'ü o mbitats'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","C'ü ra tsjapütsjë na nojo, ra tsjapüji c'ü dya pje rguí muvi. C'ü ra unü ngüenda c'ü dya ni muvi, ra tsjapüji c'ü rguí muvi a jmi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","O sido o ña e Jesús o xipji c'e bëzo c'ü vi mbita: ―'Ma i̱ṉ ät'ägue 'na jñõnü, i̱ṉ mbita c'o i̱ṉ negue, 'ñe c'o in cjuarma, 'ñe c'o 'ñaja in dyocjeji, 'ñe c'o bëxtjo i̱ṉ cãrãgueji c'o jün o t'opjü. Nuc'o, nguextjo c'o i̱ṉ mbitague c'o. Rí xi'tsc'ö c'ü dya cja rí tsjague a cjanu. Na ngue anguezeji xo ra mbitats'üji rí mague rí ma siji o xëdyi cja o̱ ngumüji. A cjanu, ra ngõ'tc'ütjoji c'ü vi mbitague anguezeji, pero dya ra ngõ'tc'ü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","C'ü rí tsjague 'ma rí dyät'ä 'na jñõnü, xo rí mbitague c'o pöbre c'o dya pje pë's'i, c'o ch'odyë 'ñe c'o me'dye 'ñe c'o ngorö. ");
INSERT INTO mazNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'Ma rí tsjague a cjanu, me rí mäjägue 'ma. Na ngue dya ra sö ra ngõ'tc'üji ra mbitats'üji c'ua ja nzi vi mbitague anguezeji. Nguec'ua 'ma ra bübütjo na yeje c'o vi tsja na jo, xo rí tegue ra ngõ'tc'ü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","'Naja c'o mi junrü cja mexa, 'ma mü o dyärä c'o vi mama e Jesús, o xipji: ―Me ra mäjä c'o ra mbita Mizhocjimi ra ma ziji o xëdyi nu ja manda angueze. ");
INSERT INTO mazNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","O ndünrü c'ua e Jesús o xipji: ―Mi bübü 'na bëzo c'ü ro tsja 'na mbaxua ro dyät'ä o jñõnü. Na puncjü o nte c'o o mbita. ");
INSERT INTO mazNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nuc'ua 'ma o zädä c'e hora 'ma ro ziji o xëdyi, c'e bëzo o xipji c'ü o̱ mbëpji: “Mague cja c'o ró mbita, ma xipjiji ra ẽji dya, na ngue ya jogü texe”, eñe c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nuc'ua texeji o mbürü o mamaji ro perdonaoji na ngue dya mi sö ro möji. Nu ja ot'ü o zät'ä c'e mbëpji, o xipjiji a cjava: “Perdonaozü, dya sö rá ma sigö o xëdyi. Cja ró tõmügö 'na juajma; ni jyodü rá ma nu'u.” ");
INSERT INTO mazNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","C'ü 'naja o mama: “Perdonaozü, dya sö rá ma sigö o xëdyi. Cja ró tõmügö tsi'ch'a yonda o nzhünü; ni jyodü rá ma nugö cjo na jo ga pëpji c'o.” ");
INSERT INTO mazNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","C'ü 'naja o mama: “Cja ró chjüntü, nguec'ua dya ra sö rá ma sigö o xëdyi.” ");
INSERT INTO mazNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Cjanu o nzhogütjo c'ua c'e mbëpji o ma xipji c'ü nu lamu c'o vi mama c'o vi mbita. Nuc'ua c'e lamu go sjëya c'ua o xipji c'ua c'ü o̱ mbëpji: “Mague dya cja yo 'ñiji. Ja c'o rí chjëji c'o pöbre, rí sigue c'o. Rí sigue c'o ch'odyë 'ñe c'o me'dye 'ñe c'o ngorö”, eñe. O ma c'ua c'e mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nuc'ua 'ma mü o nzhogü, o mama: “Nu'tsc'e ín lamuts'ügö, ró cjagö ja c'o nzi vi xitsi ró ma sigö o nte. Pero xe jyadütjo cja nin nzungue.” ");
INSERT INTO mazNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","O ndünrü c'ua c'e lamu o xipji c'ü o̱ mbëpji: “Pedyegue cja ne jñiñi, rí mague texe c'ua ja bübü o 'ñiji ja c'o cjogü o nte, rí sido rí xiqueji ra ẽji, ngue c'ua ra ndüji cja ín nzungö. ");
INSERT INTO mazNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Rí xi'tsc'ö, nu c'o ot'ü ró mbitagö ro ẽjẽ, nuc'o, dya ra zi yo jñõnü yo ró ät'ägö ne ri 'naja c'o”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na puncjü o nte c'o mi pöji e Jesús. 'Na nu pa 'ma mi pöji cja 'ñiji, e Jesús o ñezhe c'ua o xipji c'o nte: ");
INSERT INTO mazNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―'Ma cjó c'o ne ra ndenngue co nuzgö, ni jyodü xenda ra nezegö que na ngue c'ü nu tata 'ñe c'ü nu nana. Ni jyodu xenda ra nezegö que na ngue c'ü nu su 'ñe c'o o̱ t'i. Ni jyodü xenda ra nezegö que na ngue c'o nu cjuarma 'ñe c'o nu cjũ. 'Ma jiyö, dya ra sö ra ndenngue co nuzgö. Ra tsja ja c'o nzi rgá negö; dya cja ra tsja ja c'o nzi ga netsjë. ");
INSERT INTO mazNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'Ma cjó c'o ne ra ndenngue co nuzgö, ni jyodü ra bübü dispuesto ra sufreji o ra ndũji. 'Ma jiyö, dya ra sö ra ndenngue co nuzgö. ");
INSERT INTO mazNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","'Ma cjó c'o ne ra jyäbä 'na ngumü, ni jyodü ot'ü ra tsja ngüenda, cjo ra zäs'ä c'ü rguí cjuatü c'e ngumü. ");
INSERT INTO mazNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","'Ma jiyö, 'ma ya rguí ngü'p'ü c'e cimiento, pero 'ma dya ri säs'ä c'ü rguí cjuatü c'e ngumü, texe c'o vi jñanda c'e bëzo mi jäbä o̱ ngumü, ra ndenbeji rgá tsjapüji burla. ");
INSERT INTO mazNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ra mamaji: “Ne bëzo o mbürü o jyäbä 'na ngumü, pero dya zäs'ä c'ü rví cjuatü”, ra 'ñeñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Xo rí tsjijñigueji ja ga cja ga tsja yo rey. 'Na rey c'ü ë'ë diez mil c'o o̱ tropa, dya ixta ma chũvi c'ü 'na rey c'ü va ẽjẽ va ë'ë veinte mil c'o o̱ tropa. Ot'ü ra nguijñi cjo ra sö ra ndõpü c'o va ẽjẽ. ");
INSERT INTO mazNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Ma ra unü ngüenda c'ü dya ra sö, ra ndäjä c'ua c'o ra ma ndünrü c'e rey 'ñe c'o o̱ tropa 'ma xe na jẽ va ẽtjoji, ra ma reglaji para dya ra chũji. ");
INSERT INTO mazNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Je xo ga cjatsc'eji nu. Ante c'ü rí chenngueji co nuzgö, ni jyodü rí tsjijñiji na jo cjo sö rí sidoji. 'Ma dya i̱ṉ bübüji dispuesto rí sogüji texe c'o i̱ṉ pë's'iji, dya ra sö rí chenngueji co nuzgö 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","O sido o ña e Jesús o mama: ―Na jo o õ'õ. Pero 'ma ra bëzhi c'ü na õxü, ¿ja xe rgá sö xe ra õxcü? ");
INSERT INTO mazNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Zö ra huanbaji o lama cja rrũ jyä'tp'äji cja jõmü, pero dya cja rguí muvi. Nguec'ua ra mbozüji. Nu'tsc'eji i̱ṉ äräji yo jña, rí tsjapüji na puncjü ngüenda yo. ");
INSERT INTO mazNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ma ẽjẽ cja e Jesús c'o mi cobra o contribución 'ñe c'o 'ñaja c'o mi näntji mi cja c'o na s'o. Ma ẽji ro ẽ dyäräji c'o mi mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nguec'ua c'o mi xöpü o̱ ley Mizhocjimi 'ñe c'o fariseo, mi tsjojneji ma zo'büji e Jesús mi mamaji: ―Ne bëzo nu, me ne yo cja na s'o ra dyoji co angueze. Y me siji o xëdyi yo. ");
INSERT INTO mazNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","O mama c'ua e Jesús o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―'Ma ri tsãgueji 'na cien o ndënchjürü, 'ma ri bëzhi 'naja, ri sogueji cja batjü c'o noventa y nueve, cja rrĩ möji c'ua ri ma jyodüji c'e ndënchjürü c'ü ri bëzhi. Ri jyodüji hasta 'ma cja ri chöt'üji, zö ri 'natjo ndënchjürü. ");
INSERT INTO mazNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nuc'ua 'ma ri chöt'üji, me ri mäcjeji c'ua na puncjü, ri tsö's'üji in jyögueji. ");
INSERT INTO mazNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nuc'ua 'ma ri säcjeji in nzumüji, ri ma xipjiji c'o in dyocjeji 'ñe c'o bëxtjo i̱ṉ cãrãji: “Rí mbitats'ü rí ma cja ín nzumü rá mäji. Na ngue ya ró töt'ü c'ü ín nzhënchjürü c'ü rvá bëzhi”, ri 'ñeñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Rí xi'tsc'öji, je xo ga cjatjonu 'ma ra nzhogü o̱ mü'bü 'na nte c'ü vi tsja c'o na s'o, me ra mäji a jens'e. Xenda ra mäpäji c'e nte que rá ngue c'o noventa y nueve nte c'o cjapü cja na jo y dya unüji ngüenda c'ü ni jyodü ra nzhogü o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’'Na ndixũ c'ü ri jün diez merio de plata, 'ma ro bëzhi 'naja, ro ndütü 'na sivi ro jyodü c'e merio. Ro paxü na jo cja c'e ngumü ro jyodü hasta 'ma cja ro chöt'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nuc'ua 'ma ro chöt'ü, ro xipji c'o o̱ dyoji 'ñe c'o bëxtjo ri cãrãji: “Rí mbitats'ü rí mague cja ín nzumü rá mäji. Na ngue ya ró töt'ü c'e merio c'ü rvá bëzhigö”, ro 'ñeñe. ");
INSERT INTO mazNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Rí xi'tsc'öji, je xo ga cjatjonu 'ma ra nzhogü o̱ mü'bü 'na nte c'ü vi tsja c'o na s'o, me ra mäjä Mizhocjimi 'ñe c'o o̱ anxe c'o cãrã a jmi. ");
INSERT INTO mazNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Xo mama c'ua: ―'Naja bëzo mi 'ñeje yeje t'i. ");
INSERT INTO mazNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nu c'e t'i c'ü mi sëbi o ma cja c'ü nu tata, o ma xipji: “Mi tatats'ügö, dyacö c'ü tocazü yo i̱ṉ pë'sc'e”, embe. Nuc'ua c'e bëzo o jyadü c'ua c'o mi pë's'i o unü nza yeje c'o o̱ t'i. ");
INSERT INTO mazNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Dya mezhe c'ua pa, c'e t'i c'ü mi sëbi o jmutü texe c'o mi pë's'i, cjanu o ma c'ua o zät'ä cja 'na país c'ü ma jẽ. Nuc'ua o ndeze nu texe o̱ merio va tsja c'o na s'o; dya mbörütsjë ja rvá mimi. ");
INSERT INTO mazNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nuc'ua 'ma mü o ndeze texe o̱ merio, o ẽjẽ c'ua 'naja tjijmi cja c'e país. Nuc'ua c'e t'i mi ojtjo pje ro zi. ");
INSERT INTO mazNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Cjanu o ma c'ua cja 'naja bëzo cja c'e país, o ma xipji: “¿Cjo dya i̱ṉ pë's'i o bëpji rí dyacö?”, eñe. C'e bëzo, dya mi ne ro unü o bëpji, pero c'e t'i sido mi örü. Nguec'ua c'e bëzo, zö dya mi ne, pero o unü o bëpji, o ndäjä cja c'ü o̱ hacienda ro ma ts'as'ü o cuchi. ");
INSERT INTO mazNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","C'e t'i, dya mi nijmi c'ü mi ch'unü ro zi. Nguec'ua me mi ne c'ü xo ro ch'unü c'o mi si c'o cuchi, ngue c'ua ro nijmi. Pero dya cjó mi unü. ");
INSERT INTO mazNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","O nzhogü o̱ mü'bü c'ua c'o na s'o c'o vi tsja, o mama: “Mi tatagö tsãjã na puncjü o mbëpji. Anguezeji poncjütjo c'ü siji; nutscö rí sufregö va o tjijmi. ");
INSERT INTO mazNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ixtá magö dya cja mi tata, rá ma xipji: Mi tatats'ügö, 'ma ró xõgö co nu'tsc'e, ró cja'c'ö c'o na s'o, 'ñe cja o̱ jmi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Dya ga jozgö c'ü xe rí xitsi in ch'izügö. Tsjacü rá cjagö 'naja in mbëpjizügö, rá embe.” ");
INSERT INTO mazNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ixco ma c'ua cja c'ü nu tata. ’'Ma xe ma jẽtjo ma ẽjẽ c'e t'i, c'e bëzo o jñanda c'ü o̱ t'i. O juentse c'ua, o cjuan'di o ma ndünrü. Cjanu o ndaja, me go zü'tp'ü o̱ jmi. ");
INSERT INTO mazNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nuc'ua c'e t'i o xipji: “Mi tatats'ügö, 'ma ró xõgö co nu'tsc'e, ró cja'c'ö c'o na s'o, 'ñe cja o̱ jmi Mizhocjimi. Dya ga jozgö c'ü xe rí xitsi in ch'izügö.” ");
INSERT INTO mazNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nuc'ua c'e bëzo o xipji c'o o̱ mbëpji: “Ma tsãji c'e bitu c'e xenda na jo, rí jyecheji nu ín ch'igö. Rí jñu'tp'üji 'na anilio cja o̱ dyë. Rí chin'chp'iji o dyatsi a ngua. ");
INSERT INTO mazNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ma siji c'e ts'inzhünü c'ü na pi, pö't'üji rá saji rá cjaji 'na mbaxua. ");
INSERT INTO mazNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Dya mi pãrãgö ja vi ma'a nu ín ch'igö. Mi pëzhgö 'na ya vi ndũ. Pero ya nzhogütjo, bübü dya”, eñe c'e bëzo va xipji c'o o̱ mbëpji. O mbürü o tsjaji c'ua c'e mbaxua. ");
INSERT INTO mazNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’C'e t'i c'ü mi nzhasẽ ma bübütjo cja juajma. Nuc'ua 'ma mü o nzhogü, 'ma ya mi ngue ro säjä cja c'e ngumü, o dyärä mi pjë'biji o bizhi 'ñe mi nemeji. ");
INSERT INTO mazNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","O ma't'ü c'ua 'naja c'o mbëpji, cjanu o dyönü pje pjëzhi c'o mi cjaji. ");
INSERT INTO mazNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","O ndünrü c'ua c'e mbëpji o xipji: “Ngue nin cjuarma c'ü ya nzhogü. O säjä na jo, dya pje tsja. Nguec'ua o manda nin tatague o mbö't'üji c'e ts'inzhünü c'ü ma pi.” ");
INSERT INTO mazNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Cjanu o üdü c'ua c'ü mi nzhasẽ, dya mi ne ro cjogü a mbo. O mbedye c'ua c'ü nu tata o xipji ro cjogü. ");
INSERT INTO mazNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","O ndünrü c'ua c'e t'i o xipji c'ü nu tata: “Dyärä rá xi'ts'i. Nutscö na puncjü o cjë'ë c'o ya ró pë'pc'i na zëzhi nza cja 'ma ri nguetscö in mbëpjigue. Nu c'ü i̱ṉ mandazü, nde rí cjagö texe. Pero dya nunca i̱ṉ dacügö 'na animale c'ü rga mägöjme c'o rí pãcöjme. Ni ri 'naja ts'ichivo ri dacügö. ");
INSERT INTO mazNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero 'ma o säjä dya nu in ch'igue nu na s'o, i̱ manda o mbö'tp'üji c'e ts'inzhünü c'ü ma pi; maco o nde'tsc'e in meriogue ma dyoji c'o ndixũ c'o na s'o, c'o nde ga dyonpütjo o bëzo.” ");
INSERT INTO mazNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","O ndünrü c'ua c'e bëzo o xipji c'ü nu t'i: “Nu'tsc'e ín ch'itsc'ö, rí bübütjogövi. Texe c'o ín tsjagö, ngue in tsjague. ");
INSERT INTO mazNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dya mi pãrãgö ja vi ma'a nu nin cjuarma; mi pëzhgö 'na ya vi ndũ. Pero ya nzhogütjo, bübü dya. Nguec'ua rá cjaji na jo mbaxua rá mäji.” ");
INSERT INTO mazNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","E Jesús xo xipji c'o o̱ discípulo: ―Mi bübü 'na bëzo c'ü mi rico c'ü mi 'ñeje 'na mbëpji c'ü mi pjötpü texe c'o mi pë's'i c'ü nu lamu. C'e mbëpji mi s'onbü c'o mi pë's'i c'ü o̱ lamu. Nguec'ua mi bübü c'o o ma cja c'e lamu o ma cösteji. ");
INSERT INTO mazNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nuc'ua c'e lamu o zojnü c'ü o̱ mbëpji. 'Ma mü o ẽjẽ c'e mbëpji, o mama c'ua c'e lamu o xipji: “¿Jenga vi tsjacügö a cjanu yo rí ärägö? Mague ma chjënquigö c'o xiscõmü c'o juns'ü ja nzi o merio c'ü tuncügö yo nte. Nuc'ua, dya cja xe rí pëpquigö”, eñe c'e lamu va xipji c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nuc'ua c'e mbëpji cjanu o ma c'ua o mamatsjë c'ua: “Nu c'ü ín lamugö ya ra pjongüzü c'ü dya cja rá pëpigö c'ü. ¿Ja rga cjazgö dya? Dya zëtsi rá cjagö bëpji c'o na jyü, y dya sö rá örü pje rá sigö, na ngue rí tsegö. ");
INSERT INTO mazNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ya ró mbeñegö dya c'ü rá cjagö, ngue c'ua 'ma ra zädä c'ü dya cja rá pëpigö c'ín lamugö, ra recibidozü yo nte cja o̱ ngumüji”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Cjanu o zojnü c'ua texe c'o mi tunpü o merio c'ü nu lamu, cjanu o ñatsjëvi c'ua nzi 'naji. O mama c'e bëzo va dyönü c'ü ot'ü o säjä: “¿Ja nzi i̱ṉ tunpügue c'ü ín lamugö?” ");
INSERT INTO mazNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","O mama c'ua c'e nte: “Rí tunpü 'na ciento barri o aceite.” O mama c'ua c'e mbëpji: “Bübü dya c'ua nin vale rí xü't'ü. Ixtí dyät'ä c'ü 'na vale rí jñu's'ütjo cincuenta, cja rrĩ jñu's'ü in chjũgue.” ");
INSERT INTO mazNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nuc'ua cja ndo nu ẽjẽ c'ua c'ü ndo 'naja. Cjanu o mama c'e mbëpji o xipji: “¿Ja nzi i̱ṉ tũgue?” Angueze o mama: “Rí tunpü 'na ciento mape o ndëxü.” O mama c'ua c'e mbëpji: “Bübü dya c'ua nin vale rí xü't'ü. Ixtí dyät'ä c'ü 'na vale rí jñu's'ütjo ochenta”, eñe. Je ga cjanu va tsja c'e mbëpji o jñu's'ütjo menu c'o mi tũ c'o nte. Cjanu o ma c'ua cja c'ü nu lamu o ndënbi c'o xiscõmü c'o mi ngue c'o vale c'o cja vi dyät'ä. ");
INSERT INTO mazNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","O mezhe ts'ë, nuc'ua c'e lamu cja mbãrã c'o na s'o c'o vi tsja c'e mbëpji, cjanu o mama: “¿Ja va ndõcügö c'e s'ombëpji? Me pë's'i na puncjü o̱ pjeñe”, eñe. C'ua ja nzi va tsja c'e mbëpji, je xo ga cjatjonu c'o nte c'o dya pãrã Mizhocjimi, me pë's'iji na puncjü o̱ pjeñe ja ga tsjaji na jonteji cja yo nu minteji, que na ngue yo nte c'o bübü o̱ mü'bü o̱ jya's'ü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","O sido o ña e Jesús o xipjiji: ―Yo nte cjaji na s'o co o̱ merioji; nu'tsc'eji rí tsjaji na jontets'üji co in merioji. Rí unüji yo nte c'o pje ni jyodü; rí gastoji in merioji ja c'o nzi ga ne Mizhocjimi. Nguec'ua 'ma rí chũji, 'ma rí sät'äji a jens'e, Mizhocjimi me ra mä'c'äji ra xi'ts'iji na jo vi tsjagueji. ");
INSERT INTO mazNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’C'o ra tsja c'o na jo co o̱ merioji, xo ra tsjaji na jo c'o o̱ bëpji Mizhocjimi c'o nda ni muvi que na ngue o merio. Pero c'o dya ra tsja c'o na jo co o̱ merioji, dya xo ra tsjaji na jo c'o o̱ bëpji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Zö cja c'o na s'o yo nte co o̱ merioji, pero nu'tsc'eji ni jyodü rí tsjaji rrã jontets'üji. 'Ma dya rí tsjaji na jo co in merioji, dya xo ra dya'c'üji o̱ bëpji Mizhocjimi c'ü nda ni muvi. ");
INSERT INTO mazNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'Ma dya rí tsjaji na jo co o merio c'ü tjeze, ¿ja rgá sö ra dya'c'üji Mizhocjimi c'o dya ra tjeze rí tsjapüji in tsjacjeji? ");
INSERT INTO mazNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’'Ma cjó c'o ra mbëpi yeje lamu, dya ra sö ra dyätävi nza yejui. Na ngueje c'ü 'naja ri nu'uji na ü, ra tsja c'e mbëpji; c'ü 'naja ri ne. O 'ma jiyö, 'naja c'ü ri ätä; 'naja c'ü ri cjapü dya rguí muvi. Je xo ga cjatsc'eji nu, 'ma rí jyodüji ja rgui pë's'iji na puncjü cja ne xoñijõmü, nu'ma, dya rí pëpqueji 'ma Mizhocjimi co texe in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","C'o fariseo c'o mi cãrã nu, 'ma mü o dyärä c'o jña c'o mi mama e Jesús, o tsjaji c'ua burla. Na ngue anguezeji me mi neji o merio. ");
INSERT INTO mazNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","O mama c'ua e Jesús o xipjiji: ―Nu'tsc'eji i̱ṉ cjapüji me na jots'üji cja yo nte, pero Mizhocjimi pã'tc'ã in mü'büji. C'o i̱ṉ cjaji c'o mama yo nte na jo, Mizhocjimi mama na s'o c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Texe c'o o̱ jña Mizhocjimi c'o xiji ley 'ñe profeta, mamaji c'ü ro ẽjẽ c'e pa 'ma ro manda Mizhocjimi. Pero 'ma o mbürü e Juan o zopjü yo nte, ya ma sädä c'e pa. Ndeze c'o pa c'o, hasta nudya, bübü c'o zopjü yo nte, xipjiji c'ü ya ẽjẽ c'ü o 'ñeme Mizhocjimi ra manda. Nguec'ua bübü o nte c'o me jodü ja rgá ndeñeji angueze. ");
INSERT INTO mazNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Zö ra manda dya, nu c'ü o 'ñeme Mizhocjimi, pero xo na cjuana texe c'o mama o̱ ley Mizhocjimi. Zö ra nguins'i e jens'e 'ñe ne xoñijõmü, pero dya ra cjogü o̱ ley Mizhocjimi. C'o mama o̱ ley Mizhocjimi na s'o c'o i̱ṉ cjaji, ix na cjuana na s'o c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’'Ma cjó c'o ra mbëzi nu su, cja rrũ chjüntüvi c'ü xe 'na ndixũ, nu'ma, cja c'o na s'o chjëntjui 'ma ri tsãjã o ndixũ. Y c'e bëzo c'ü ra chjüntüvi c'e ndixũ c'ü vi bëzi, xo cja na s'o c'ü chjëntjui c'ü ri tsãjã o ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","O sido o ña e Jesús o xipjiji: ―Mi bübü 'naja bëzo c'ü mi rico. Mi je'e o bitu c'o me ma jo, nza cja o bitu c'o je'e o rey. Pama me mi mäji c'o o̱ dyoji mi cjaji o mbaxua. ");
INSERT INTO mazNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Cja ngoxtji c'ü o̱ ngumü c'e bëzo, vi 'ñemeji 'na bëzo c'ü mi pöbre c'ü mi dya o̱ ts'ingue texe cja o̱ cuerpo. Nuc'ü, mi chjũ e Lázaro. ");
INSERT INTO mazNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mi sant'a na puncjü. Nguec'ua me mi ne xa'ma ro ch'unü pje ro zi'i, zö ri nguextjo c'o mëxëdyi 'ñe c'o jñõnü c'o mi jäbä a jõmü cja c'ü o̱ mexa c'e bëzo c'ü mi rico. C'o dyo, mi jösp'üji cja o̱ cuerpo c'ü mi s'odü. ");
INSERT INTO mazNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","O ẽ 'na nu pa, o ndũ c'e bëzo c'ü mi pöbre. Nuc'ua c'o o̱ anxe Mizhocjimi o zidyiji a jens'e nu ja bübü e Abraham. 'Ma mü o ndũ c'e bëzo c'ü mi rico, o dyögüji na jo. ");
INSERT INTO mazNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nuc'ua 'ma me mi sufre a linfiernu c'e bëzo, o nä's'ä o jñanda e Abraham mi bübü a jens'e. Xo jñanda mi bübü nu e Lázaro a jmi e Abraham. ");
INSERT INTO mazNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","O mapjü c'ua na jens'e o mama: “Nu'tsc'e Abraham, mi mboxpalets'ügö, juentsquegö. Xipji e Lázaro ra ẽjẽ ra 'ñe popjü o̱ ñidyë cja ndeje ra jötcü ín ts'ijñi. Na ngueje rrã sufregö na puncjü cja ne sivi.” ");
INSERT INTO mazNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","O ndünrü c'ua e Abraham o xipji: “Nu'tsc'e ín mboxbëchets'ügö, mbeñegue. 'Ma mi bübügue a xoñijõmü, mi pë's'igue texe c'o mi negue y me mi mäpägue c'o; maco e Lázaro mi bëzhi pje ro zi 'ñe pje ro jye. Pero nudya, mäjä, dya cja sufre dya. Nu'tsc'e i̱ṉ sufregue c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dya nguextjo nu; xo bübü 'na cöt'ü c'ü na jẽ a ndetsc'e 'ñezgöbe. Nguec'ua yo cãrã a 'ñecjua, dya sö ra mbes'e a ma c'ua ja i̱ṉ bünc'eji. Ni xo ri ngueje c'o cãrã a ma c'ua, dya sö ra mbes'eji a 'ñecjua.” ");
INSERT INTO mazNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Cjanu o mama c'ua c'ü mi rico: “Mi mboxpalets'ügö, rí ö'tc'ü na puncjü rí xipji e Lázaro ra ma cja o̱ ngumü mi tata. ");
INSERT INTO mazNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Na ngueje rí 'ñeje tsi'ch'a ín cjuarma. Rí chäjä e Lázaro ra ma zopjü c'o mi cjuarma, ra xipjiji ra nzhogü o̱ mü'büji cja Mizhocjimi. Xa'ma dya ra ẽjẽ anguezeji va ja rí sufregö.” ");
INSERT INTO mazNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","O ndünrü c'ua e Abraham o xipji: “Anguezeji tjëji c'ü o dyopjü e Moisés 'ñe c'o o dyopjü c'o profeta. 'Ma ra dyätäji c'o, dya ra zät'äji nu ja na bünc'e.” ");
INSERT INTO mazNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","O ndünrü c'ua c'ü mi rico o mama: “Iyö, dya ra tsjapüji ngüenda c'o. Pero 'ma cjó c'o ra te'e yo ya ndũ ra ma'a nu ja cãrã c'o ín cjuarma, ra nzhogü o̱ mü'büji 'ma.” ");
INSERT INTO mazNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","O ndünrü c'ua e Abraham o xipji: “Nu 'ma dya cjapüji ngüenda c'o o dyopjü e Moisés 'ñe c'o o dyopjü c'o profeta, dya xo ra creoji zö ra tetjo 'naja yo ya ndũ.” ");
INSERT INTO mazNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","O sido o ña e Jesús o xipji c'o discípulo: ―Siempre bübü o nte c'o cjapü ra tsja c'o na s'o yo nu minteji. Juejme c'o cjapü a cjanu yo nu minteji; Mizhocjimi ra tsjapü me ra sufreji. ");
INSERT INTO mazNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Xenda rvá jo 'ma ro 'nutpü 'na travacjüjnü o̱ dyizi c'e nte c'ü, cja rrũ pant'aji cja trazapjü nu ja na jẽ'ẽ, que na ngueje c'ü ro tsjapü ro tsja na s'o a cjanu 'naja c'o dya pje pjëzhi c'o ejmezü. ");
INSERT INTO mazNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nguec'ua rí pjötpüji ngüenda. ’'Ma pje ra tsja'c'üji yo nin cjuarmaji, rí zopjüji. Y 'ma ra nzhogü o̱ mü'büji, rí perdonaogueji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Zö siete vez nu pa c'ü pje ra tsja'c'üji 'ñe siete vez ra 'ñe xi'ts'iji: “Perdonaozügö, ró cja'c'ügö c'o na s'o”, ra 'ñents'eji, pero ni jyodü rí perdonaogueji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nuc'ua c'o apóstole o xipjiji e Jesús: ―Nu'tsc'e ín Jmuts'ügöjme, pjöxcüjme xenda rá creojme Mizhocjimi ngue c'ua rá perdonaojme c'ua ja nzi gui xitsijme. ");
INSERT INTO mazNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","E Jesús c'ín Jmugöji o xipjiji c'ua: ―Zö ts'ëtjo gui 'ñejmeji Mizhocjimi, pero 'ma rí jñunt'ü in mü'büji c'ü ra dyä'tc'äji Mizhocjimi c'ü rí dyötqueji, ra sö rí xipjiji ne za'a nu 'ne nu: “Ts'üs'ü va, ma 'ne'e cja ne trazapjü”, rí 'ñembeji. Ra tsja c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","O sido o ña e Jesús o xipjiji: ―Tsjijñiji ja ga tsja 'na bëzo c'ü 'ñeje o̱ mbëpji. Ra ma c'e mbëpji ra ma huajma, o ra ma ts'as'ü o nzhünü. 'Ma ra nzhogü c'e mbëpji, dya ra mama c'e lamu: “Ixtí tsjogü rí sigue o xëdyi”, ra 'ñeñe, iyö. ");
INSERT INTO mazNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","C'ü ra mama: “Ma dyät'ä c'ü rá sigö ne nzhä. Nuc'ua rí xa'ma rí sirvezü c'ü rá sigö hasta 'ma cja rá cjuarü rá si. Cja rí sigue o xëdyi”, ra 'ñeñe. ");
INSERT INTO mazNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Zö ra tsja c'e mbëpji ja c'o nzi va xipji, pero c'e lamu, dya ra unü 'na pöjö c'e mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Je xo rga cjatsc'eji nu. Zö rí tsjaji texe c'o ra xi'ts'iji Mizhocjimi, pero dya rí mangueji c'ü ni jyodü ra ngõ'tc'üji c'ü. Na ngue c'o rí tsjaji ngue c'o ni jyodü rí tsjaji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","E Jesús 'ma mi ma a Jerusalén, mi nzhodü cja c'e 'ñiji nu ja mi chäjui a Samaria 'ñe a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","'Ma ya ma sät'ä cja 'naja ts'ijñiñi, o chjëji dyëch'a bëzo c'o mi sö 'na ngueme c'ü ni chjũ lepra. Pero dya chëzhiji cja o̱ jmi, o böbütjoji na jẽ. ");
INSERT INTO mazNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Cjanu o mapjüji c'ua o mamaji: ―Jesús i̱ṉ xöpütegue, juentsquegöjme. ");
INSERT INTO mazNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nuc'ua e Jesús 'ma mü o jñanda c'o bëzo, o xipjiji c'o: ―Möji cja c'o mböcjimi ra nu'c'üji c'ü ya jogüts'üji dya, embeji c'o. O möji c'ua. 'Ma ya mi möji, ixco ndis'iji na jo c'e ngueme. ");
INSERT INTO mazNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nuc'ua 'naja anguezeji, 'ma mü o nu'u c'ü ya vi jogü, o nzhogü o mapjü c'ua na jens'e va unü 'na pöjö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Cjanu o ndüne a jõmü cja o̱ ngua e Jesús, o unü 'na pöjö. C'e bëzo mi menzumü a Samaria c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","O mama c'ua e Jesús: ―Maco nza dyëch'a c'o mi sö c'e ngueme ró jocü, ¿jenga dya nzhogü c'o nueve ro ẽ unüji 'na pöjö Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nguextjo ne bëzo nu dya ín menzumügöji nu o nzhogü o ẽ unü 'na pöjö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Cjanu o xipji c'ua c'e bëzo: ―Böbü rí mague. Ya jogüts'ü na ngue i̱ creozügö. ");
INSERT INTO mazNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nuc'ua c'o fariseo o dyönüji e Jesús: ―¿Jinguã ra mbürü ra manda nu c'ü o 'ñeme Mizhocjimi? O ndünrü c'ua e Jesús o xipjiji: ―Zö cjó c'o me ra jñanda c'o señal, pero dya ra sö ra mbãrãji jinguã ra mbürü Mizhocjimi ra manda. ");
INSERT INTO mazNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Zö ra mamaji: “Je bübü a 'ñecjua nu c'ü o 'ñeme Mizhocjimi ra manda”, ra 'ñeñeji, zö ra mamaji: “Je bübü a manu nu”, pero dya rrũ cjuana. Na ngue ya manda Mizhocjimi a ndetsc'eji. ");
INSERT INTO mazNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","O sido o ña e Jesús o xipji c'o o̱ discípulo: ―Nutscö rvá ẽcjö cja Mizhocjimi y rá ẽcjö na yeje. Pero ante que rá ẽcjö, ra zädä o pa 'ma me rí sufregueji. Nguec'ua me rí ñeji rá ẽcjö rá cãrãgöji va, zö ri 'natjo pa c'ü ri neji rí söyagueji c'ü dya rí sufregueji. Pero dya be ri sädä. ");
INSERT INTO mazNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ri bübü o xöpüte c'o dya cjuana ra xi'ts'iji: “Chjä'dä co nuzgöjme, na ngue bübü a 'ñecjua c'ü o 'ñeme Mizhocjimi ra manda.” O ra xi'ts'iji: “Je bübü a manu c'ü”, ra 'ñents'eji. Dya rí cheñeji anguezeji, dya rí creoji c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","'Ma go juë's'i e dyebe, ixi 'ñetse texetjo. Je xo rga cjatjonu 'ma rá ẽcjö na yeje, ra jñandgagöji texe cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero ot'ü ni jyodü rá sufregö na puncjü. Na ngue yo nte yo ín menzumügöji, dya ra 'ñejmezüji. ");
INSERT INTO mazNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","C'ua ja nzi ma cja c'o cjë 'ma mi bübü e Noé, je xo rga cjatjonu 'ma rá ẽcjö na yeje cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","C'o cjë 'ma mi bübü e Noé, 'ma dya be mi ẽjẽ c'e tradyebe, mi ñõnüji 'ñe pje nde mi si'iji. Mi chjüntüji, xo mi chjüntpüji hasta 'ma cja zädä c'e pa 'ma mü o cjogü e Noé a mbo cja c'e bü. Dya creoji cjo ro 'ñeje c'e tradyebe hasta 'ma cja 'ñeje, go chjorüji c'ua texeji. ");
INSERT INTO mazNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","C'ua ja xo nzi ma cja c'o cjë 'ma mi bübü e Lot, je xo rga cjatjonu 'ma rá ẽcjö na yeje. Mi siji o xëdyi. Y pje c'o nde mi pa tõmüji y pje c'o nde mi pöji. Mi podüji o ndëxü. Mi jäbäji o̱ ngumüji. ");
INSERT INTO mazNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero c'e pa 'ma mü o mbedye e Lot a Sodoma, o jyäbä o sivi a jens'e, 'ñe o asufre; o chjotüji texeji. ");
INSERT INTO mazNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Je xo rga cjanu c'e pa 'ma rá ẽcjö na yeje, 'ma ra jñandgöji texeji cjó nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’C'e pa c'ü, c'o ri bübü cja azotea a xes'e cja c'o o̱ ngumüji, dya ra dagüji pje c'o ra ma pjongüji a mbo. C'o ri bübü cja juajma, dya ra nzhogüji cja o̱ ngumüji. ");
INSERT INTO mazNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rí mbeñegueji ja va tsjapüji c'ü o̱ su e Lot. ");
INSERT INTO mazNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nu c'o dya ra ndenngue co nuzgö, c'o ra tsjatsjë c'o netsjëji rgá mäpäji yo bübü cja ne xoñijõmü, dya ra bübü co Mizhocjimi c'o. Nu c'o ra ndenngue co nuzgö, zö ra mbö't'üji c'o, pero ra ma ngãrãji co Mizhocjimi c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’'Ma ri xõmü 'ma rá ẽcjö, ri bübü yeje c'o 'natjo c'ua ri orüvi. 'Naja c'ü rá sidyi, 'naja c'ü rá sogü. ");
INSERT INTO mazNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","O 'ma ri ndempa 'ma rá ẽcjö, yeje ndixũ c'o rrã cüjnüvi. 'Naja c'ü rá sidyi, 'naja c'ü rá sogü. ");
INSERT INTO mazNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yeje c'o ri bübü cja juajma. 'Naja c'ü rá sidyi, 'naja c'ü rá sogü. ");
INSERT INTO mazNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","O ndünrü c'ua c'o apóstole o mamaji: ―Nu'tsc'e ín Jmuts'ügöjme, ¿ja ngue c'ua rí tsjague a cjanu? O ndünrü c'ua e Jesús o xipjiji: ―Nu ja 'mana 'na animale c'ü ya ni ndũ c'ü ya na xĩ, je nguejnu jmurü o ndopare nu. Je xo ga cjatjonu, nu ja cja'a yo nte c'o me na s'o c'o rá cjapü ra sufre, je ngue nu rá xõcügö a cjanu yo. ");
INSERT INTO mazNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nuc'ua e Jesús o mama 'na jña, ngue c'ua ro unüji ngüenda mi jyodü ro sido ro dyötüji Mizhocjimi, dya ro tõgü o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","O xipjiji: ―Cja 'naja jñiñi mi bübü 'na juesi c'ü dya mi sũ Mizhocjimi, dya xo mi respetao yo nte. ");
INSERT INTO mazNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nu cja c'e jñiñi xo mi bübü 'na ndixũ c'ü vi ndũ nu xĩra. Mi pa cja c'e juesi mi pa xipji: “Rvá ẽjẽ rvá 'ne xi'ts'i 'na nte c'ü o ndënngui ín juajma. Rí zojnügue rí castigao”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","O mezhe ja nzi pa, c'e juesi dya mi cjapü ngüenda c'e ndixũ c'ü mi ötü. Xe go mezhtjo, cjanu o mamatsjë: “Dya rí sũgö Mizhocjimi, ne xo ri ngue yo nte. Pero ne ndixũ, me xichazü na ngue sido va ẽjẽ. Rá cjagö ja c'o nzi ga dyötcü, ngue c'ua dya cja ra ẽjẽ ra ẽ molestaozü”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","O mama e Jesús c'ü ín Jmugöji: ―Tsjijñiji na jo c'ü o mama c'e juesi. ");
INSERT INTO mazNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Zö ma s'o c'e juesi, pero o mbös'ü c'e ndixũ. Nguec'ua rí xi'tsc'öji, c'o o̱ nte Mizhocjimi, 'ma ra dyötüji Mizhocjimi xõmü ndempa, Mizhocjimi ra mbös'ü c'o. Zö bübü 'ma ra mezhe, pero ra zädä 'ma ra dyätä c'o o̱ nte ja c'o nzi ga dyötüji. ");
INSERT INTO mazNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Rí xi'tsc'öji, 'ma ra zädä c'e pa, ixta mbös'ü c'o o̱ nte. Nutscö 'ma rá ẽcjö na yeje cja Mizhocjimi rá 'ñe manda, ja nzitjo nte c'o ri bübü c'o ri tepquegö 'ñe ri ejmezü, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Ma cã'ã nu ja nzi c'o mi cjapü me na joji, 'ñe mi cjapüji menu c'o 'ñaja nte. Nguec'ua e Jesús o mama 'na ejemplo o xipjiji: ―O nguins'i yeje bëzo a ma cja c'e templo, ro ma dyötüvi Mizhocjimi. C'ü 'naja mi fariseo. C'ü 'naja mi cobra o contribución. ");
INSERT INTO mazNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","C'e fariseo o böbütjo mi cjapü na nojo cja jmi Mizhocjimi o mama: “Mizhocjimi, rí da'c'ü 'na pöjö na ngueje dya nza cjazgö c'o 'ñaja nte. Na mbẽji, na s'o cjaji, tsãji o ndixũ. Dya xo nza cjazgö ne bëzo nu cobra o contribución. ");
INSERT INTO mazNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yendgá mbempje nu ngo. Y rí da'c'ü ín diezmo texe c'o rí tõgö”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nu c'ü mi cobra o contribución mi jyadüvi na jẽ; dya mi ne ro nä's'ä a jens'e. Mi ya'bü o̱ tijmi mi mama: “Mizhocjimi, me na s'o c'o rí cjagö; rí tũgö na puncjü ín nzhubü. Rí ö'tc'ü rí juentsque rí perdonaozü”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nuc'ua o nzhogüvi o mëvi o̱ ngumüvi. Rí xi'tsc'öji, Mizhocjimi o perdonao c'e nte c'ü mi cobra o contribución. Pero c'e fariseo, dya perdonaoji c'ü. C'ü ra tsjapütsjë na nojo, ra tsjapüji c'ü dya pje rguí muvi. C'ü ra unü ngüenda c'ü dya ni muvi, ra tsjapüji c'ü rguí muvi a jmi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ma ẽjẽ c'o nte ma siji c'o o̱ ts'it'iji cja o̱ jmi e Jesús, ngue c'ua e Jesús ro 'ñe's'e o̱ dyë anguezeji ro dyötpüji Mizhocjimi. Nuc'ua c'o discípulo 'ma mü o jñandaji c'o, o huënch'iji c'ua c'o ma siji c'o ts'it'i. ");
INSERT INTO mazNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero e Jesús o xipji c'o nte, na jo ro siji c'o ts'it'i. Cjanu o xipji c'o o̱ discípulo: ―Jyëziji yo ts'it'i ra ẽji cja ín jmigö; dya rí ts'asp'üji. Na ngue c'o va ẽjẽ co nuzgö nza cja yo ts'it'i, ngueje c'o cjapü Mizhocjimi o̱ Jmu. ");
INSERT INTO mazNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Dyäräji na jo c'ü na cjuana c'ü rá xi'tsc'öji. 'Ma cjó c'o dya ra ẽjẽ co nuzgö c'ua ja nzi ga 'ñeje yo ts'it'i, dya ra sö ra tsjapüji Mizhocjimi o̱ Jmuji, eñe e Jesús va xipji c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","O mama c'ua 'naja c'ü mi xo'ñi cja 'na nintsjimi o xipji: ―Nu'tsc'e xöpüte, me na jots'ügue. ¿Pje ni mbë c'ü rá cjagö ngue c'ua ra ch'acü c'ü rga bübütjo co Mizhocjimi para siempre? ");
INSERT INTO mazNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","E Jesús o xipji: ―¿Pje ni xitsi na jozü? Dya cjó bübü c'ü na jo; nguextjo Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","I̱ṉ pãrãgue c'o o̱ mandamiento Mizhocjimi c'o o dya'c'üji: “Dya rí pö't'üteji. Dya rí tsãji o ndixũ. Dya pje rí põnüji. Dya rí pezheji o bëchjine. Rí respetaoji nin tataji 'ñe nin nanaji.” Xo 'ñe c'o 'ñaja mandamiento, xo i̱ṉ pãrãgue c'o, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","O ndünrü c'ua c'e bëzo: ―Texe yo, ya nde ró cjagö yo ndeze 'ma mi ts'iquëgö. ");
INSERT INTO mazNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nuc'ua e Jesús 'ma mü o dyärä c'o, o xipji: ―Xe bëzhtjo 'naja c'ü rí tsjague. Ma pögue texe c'o i̱ṉ pë's'i, rí unü c'o dya pje pë's'i. A cjanu rí pë's'igue a jens'e c'o me ni muvi. Cja rrĩ chenngue co nuzgö rá më. ");
INSERT INTO mazNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nuc'ua 'ma mü o dyärä c'e bëzo c'o o mama e Jesús, me co ndumü c'ua, na ngue mi pë's'i na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","E Jesús 'ma mü o jñanda me go ndumü c'e bëzo cjanu o mama c'ua: ―Nu c'o pë's'i na puncjü, me na s'ëzhi para ra unü o̱ mü'büji Mizhocjimi ra tsjapüji o̱ Jmuji. ");
INSERT INTO mazNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","'Naja camello, dya sö ra cjogü cja o̱ xãgö 'na dyepjadü. Pero rí xi'tsc'öji, xenda sö ra cjogü a cjanu 'na camello, que na ngue 'na nte c'ü pë's'i na puncjü ra unü o̱ mü'bü Mizhocjimi ngue c'ua Mizhocjimi ra tsjapü o̱ nte. ");
INSERT INTO mazNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","C'o mi ärä, o mamaji: ―'Ma ga cjanu, ¿ja rgá sö cjó ra salva 'ma? ");
INSERT INTO mazNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","O ndünrü c'ua e Jesús o mama: ―C'ü dya sö yo nte ra tsja, Mizhocjimi sö ra tsja. ");
INSERT INTO mazNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nuc'ua e Pedro o mama: ―Nutscöjme ró sogüjme texe c'o mi pë's'ijme ró tennc'öjme co nu'tsc'e. ");
INSERT INTO mazNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","O ndünrü c'ua e Jesús o xipjiji: ―Dyäräji na jo c'ü na cjuana c'ü rá xi'tsc'öji. Cãrã c'o ra unü o̱ mü'bü Mizhocjimi ra tsjapüji o̱ Jmuji. Nguec'ua ra zogü o̱ ngumüji, o nu tataji 'ñe nu nanaji, o nu cjuarmaji, o nu cjũji, o nu suji, o nu t'iji, ngue c'ua ra tsjaji c'ua ja nzi ga ne Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","C'o ra tsja a cjanu, ra ch'unüji c'ü rrã puncjü que na ngue c'ü mi pë's'iji 'ma ot'ü. Y 'ma ya rguí nguins'i ne jens'e 'ñe ne xoñijõmü, ra bübütjoji co Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","'Na nu pa e Jesús o xõcü c'o doce o̱ discípulo, o ñatsjëji o xipjiji: ―Ya rrã mö a ma a Jerusalén. Ra zädä texe c'o o dyopjü c'o profeta c'ü rá sufregö nutscö rvá ẽjẽ cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ra nzhögügöji cja o̱ dyë c'o dya menzumü a Israel, me ra tsjacüji burla ra zoxcüji. Y pje c'o me nde ra tsjacüji. ");
INSERT INTO mazNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ra mbäräzüji ra mbötcüji. Nuc'ua c'ü na jñi nu pa, rá tetcjö rá bübütjo na yeje, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","C'o doce discípulo, dya mbãrãji c'o jña. Dya mi unüji ngüenda c'ü ja rvá zädä c'ü ro sufre e Jesús. Dya be mi ch'unü ro mbãrãji. ");
INSERT INTO mazNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","E Jesús 'ma ya mi ngue ro zät'äji a Jericó c'o o̱ discípulo, nu cja c'e 'ñiji mi junrü 'na bëzo c'ü mi ngorö. Mi örü o merio. ");
INSERT INTO mazNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","'Ma mü o dyärä mi cjogü na puncjü o nte, o tsja t'önü pje mi cja c'o nte c'o mi cjogü. ");
INSERT INTO mazNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","O xipjiji: ―Cjogü e Jesús nu menzumü a Nazaret, embeji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nuc'ua c'e bëzo o ña c'ua na jens'e o mama: ―Nu'tsc'e Jesús o̱ mboxbëchets'ü e David, juentsquegö. ");
INSERT INTO mazNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","C'o nte c'o mi ot'ü a xo'ñi o huënch'iji c'ua c'e bëzo o xipjiji c'ü ro ngo't'ü o̱ ne. Pero nuc'ü, xenda go mapjü na jens'e: ―Nu'tsc'e o̱ mboxbëchets'ü e David, juentsquegö. ");
INSERT INTO mazNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nuc'ua e Jesús o böbü c'ua o mama: ―Siji ga 'ñecjua ne bëzo. Nuc'ua 'ma mü o zät'ä, o dyönü e Jesús o xipji c'e bëzo: ");
INSERT INTO mazNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Pje i̱ṉ ne rá cja'c'ü? O ndünrü c'e bëzo o mama: ―Nu'tsc'e ín Jmuts'ügö, rí ne c'ü rí xocüzü ín chö rá janda. ");
INSERT INTO mazNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","E Jesús o xipji c'ua: ―Jñandague. Ró jocüts'ü na ngue i̱ creozü. ");
INSERT INTO mazNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jo ni zätä c'ua o̱ ndö o jñanda. Cjanu o möji c'ua e Jesús. Y o unü 'na pöjö Mizhocjimi. C'o nte 'ma mü o jñandaji o jogü c'e bëzo, o mamaji: ―Me na jo Mizhocjimi, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E Jesús 'ñe c'o mi pöji, o zät'äji a Jericó o cjogüji cja c'e jñiñi. ");
INSERT INTO mazNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mi bübü nu 'na bëzo c'ü mi chjũ Zaqueo c'ü mi jefe cja c'o mi cobra o contribución. Nuc'ü, mi rico c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","E Zaqueo, 'ma mü o dyärä o cjogü e Jesús cja c'e jñiñi, mi jodü ja rvá jñanda. Pero dya mi sö, na ngue mi pöji e Jesús na puncjü o nte, 'ñe dya ma ndã e Zaqueo. ");
INSERT INTO mazNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nuc'ua o ot'ü a xo'ñi o ma ndes'e cja 'na za'a c'ü mi chjũ sicómoro. O ndes'e nu, ngue c'ua ro jñanda e Jesús. Na ngue je ro cjogü nu e Jesús 'ñe c'o mi pöji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nuc'ua 'ma mü o cjogü e Jesús a ngua c'e za'a, o nä's'ä c'ua o xipji: ―Zaqueo, dyagü na zëzhi. Na ngue rá oxü cja in nzungue dya, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nuc'ua e Zaqueo ixco dagü c'ua. Me co mäjä va mëvi e Jesús cja ngumü. ");
INSERT INTO mazNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","C'o nte 'ma mü o jñandaji c'o, me mi tsjojne ma zo'büji e Jesús mi mamaji c'ü vi ma oxü e Jesús cja ngumü 'na bëzo c'ü ma s'o. ");
INSERT INTO mazNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'Ma mi cãrãji cja c'e ngumü, o böbü e Zaqueo o xipji e Jesús c'ü ín Jmugöji: ―Nu'tsc'e ín Jmuts'ügö, bübü c'ü ni jyodü rá xi'tsc'ö. C'o rí pë's'i, rá unügö nde, yo dya pje pë's'i. 'Ma ró cjopcö rvá cobra, rá nzhopcö xe 'na nziyo c'ü ró cjopcö. ");
INSERT INTO mazNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","O mama c'ua e Jesús: ―Nudya o jogü o̱ mü'bü ne bëzo 'ñe yo cãrã o̱ ngumü. Ixna cjuana mboxbëche dya nu, cja e Abraham. ");
INSERT INTO mazNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","C'ü rvá ẽcjö cja Mizhocjimi, ngue c'ü rá jodü c'o cja na s'o, ngue c'ua rá emeji libre cja c'o na s'o. 'Ma jiyö, ra bëzhiji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","C'o nte xe mi cjijñiji c'o jña c'o vi xipjiji e Zaqueo. Mi unüji ts'ë ngüenda e Jesús mi ngueje c'ü vi 'ñeme Mizhocjimi ro 'ñe manda. Na ngue c'ü ya mi ngue ro zät'äji a Jerusalén, mi pëzhiji c'ü ya mi ngue ro manda e Jesús. Nguec'ua e Jesús xe go ña o xipjiji 'na jña c'ü rví unüji o ngüenda c'ü dya be ro manda. ");
INSERT INTO mazNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","O mama: ―'Naja rey mi 'ñeje 'na t'i. C'e t'i ya mi ngue ro ma cja 'na país c'ü ma jẽ, je ro ch'unü nu c'e poder c'ü ro manda. Jo rrũ nzhogü ro ẽ manda. ");
INSERT INTO mazNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ante c'ü ro ma, o ma't'ü diez c'o o̱ mbëpji, cjanu o unüji 'na merio c'ü me ni muvi nzi 'naji. Cjanu o xipjiji: “Rí pëpjiji co yo merio, ngue c'ua 'ma rá nzhogö, ya rguí ndõjõ”, embeji c'o mbëpji. Cjanu o ma c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","C'o o̱ menzumü c'e t'i, mi nuji na ü c'ü. Nguec'ua va ndäji c'o xo ro ma'a nu ja ro ma c'e t'i, ro mamaji: “Dya rí negöjme ra mandazüjme nu”, ro 'ñeñe c'o ro ma zogü 'na jña. ");
INSERT INTO mazNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero o ch'unü poder c'e t'i ro manda. Nuc'ua 'ma mü o nzhogü, o manda o zojnüji c'ua c'o mbëpji c'o vi unü o merio, ngue c'ua ro mbãrã ja nzi vi ndõ nzi 'na c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","O ẽjẽ c'ua 'naja mbëpji o mama: “Nu'tsc'e ín Jmuts'ügö, i̱ socüzü 'na merio c'ü me mi muvi. Xo va ẽcjuã yo xe 'na dyëch'a merio yo ró tõcjö”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Angueze o xipji: “Me na jo ga mbëpjits'ü. I̱ tsjacjuana i̱ tsjague na jo c'o ts'ëtjo c'o ró socüts'ügö. Nudya rá da'c'ü rí mandague cja dyëch'a jñiñi”, eñe c'e t'i c'ü ya mi rey. ");
INSERT INTO mazNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","O ẽjẽ c'ü 'naja mbëpji o mama: “Nu'tsc'e ín Jmuts'ügö, i̱ socüzü 'na merio c'ü me mi muvi. Nudya xo va ẽcjuã yo xe 'na tsi'ch'a merio yo ró tõgö”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","O ndünrü c'ua c'e rey o xipji: “Nu'tsc'e rá da'c'ü rí mandague tsi'ch'a jñiñi.” ");
INSERT INTO mazNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","O ẽjẽ c'ua c'ü 'naja mbëpji o mama: “Nu'tsc'e ín Jmuts'ügö, bübü c'ua nu in merio. Ró pös'ü cja 'na ts'imbayo ró pë's'i na jo. ");
INSERT INTO mazNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ró sũgö ró mama, zö rá pëpcjö na zëzhi, pero pje ra dyeje c'o, ró eñegö. Na ngue nu'tsc'e i̱ṉ dacüjme o bëpji c'o na jyü. Zö rí pë'pc'ijme, ngue'tsc'e i̱ṉ cjapü in tsjacje yo rí tõgöjme. Zö nguetscöjme rí podüjme c'o in nzhëxügue 'ñe rí cjajme texe, ngue in ch'ujmügue nu ja üt'üji c'o ndëxü”, eñe c'e mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","O ndünrü c'ua c'e rey o xipji: “Na s'o ga mbëpjits'ügue. Na ngue c'o i̱ṉ mangue, ixi 'ñetsetjo c'ü na s'o ga mbëpjits'ügue. Nu'tsc'e i̱ṉ pãrãgue c'ü rí da'c'öji o bëpji c'o na jyü, 'ñe rí cjapü ín tsjacjö c'o i̱ṉ pëpjigueji, 'ñe je ngue ín ch'ujmügö nu ja üt'üji c'o ndëxü c'o i̱ṉ podügueji cja ín juancjö. ");
INSERT INTO mazNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Maco i̱ṉ pãrãgue yo, ¿jenga dya i̱ mague cja banco ri ma sogü nu, nu ín meriogö? 'Ma rva cjanu, 'ma ro ẽcjö, ro dyacöji ne merio, 'ñe c'o ya rví ndõjõ nu”, embe. ");
INSERT INTO mazNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","O sido o ña c'e rey o xipji c'o mi cãrã nu: “Jñünbüji ne merio ne bëzo, unüji nu o ndõjõ 'na dyëch'a merio.” ");
INSERT INTO mazNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Anguezeji o xipjiji: “Nu'tsc'e ín Jmuts'ügöjme, maco ya jün dyëch'a merio.” ");
INSERT INTO mazNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","O mama c'ua c'e rey: “Rí xi'tsc'öji, c'o ch'unü pje rguí pëpjiji, 'ma ra ndõji, xe ra ch'unü 'ma c'o. Pero 'ma dya ra pëpjiji c'o vi ch'unüji ra ndõji, nu'ma, ra jñünbüji 'ma c'o vi ch'unüji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","C'o nte c'o nugü na ü, c'o dya go ne c'ü ro mandagö anguezeji, ma siji a 'ñecjua c'o, rí pö't'üji cja ín jmigö c'o”, eñe c'e rey. ");
INSERT INTO mazNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nuc'ua e Jesús 'ma mü o nguarü o mama c'o jña, go sido go ndëpi c'e 'ñiji c'ü mi ma a Jerusalén, mi pöji co c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","'Ma ya mi ngue ro zät'äji a Betfagé 'ñeje a Betania cja c'e t'eje c'ü ni chjũ Olivos, o ma't'ü c'ua yeje c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Cjanu o xipjivi: ―Mëvi cja ne jñiñi nu bübü a ma a xo'ñi. 'Ma rí sät'ävi nu, rí chöt'üvi 'na ts'iburru c'ü 'nünt'ü, nu c'ü dya cjó be chägä. Rí xäpcävi, cja rrĩ sijivi. ");
INSERT INTO mazNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Ma cjó c'o ra dyönnc'üvi: “¿Jenga i̱ṉ xäpcävi ne burru?”, ra 'ñents'evi, nu'ma, rí xipjivi a cjava: “Ngue c'ü ín Jmugöji c'ü ni jyodü”, rí 'ñembevi c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","O ma c'ua c'o yeje o ma chöt'üvi ja c'o nzi va mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","'Ma ma xäpcävi c'e ts'iburru, cjanu o mama c'ua c'o mi ngue o̱ cjaja c'e ts'iburru o xipjivi: ―¿Jenga i̱ṉ xäpcävi ne ts'iburru? ");
INSERT INTO mazNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Anguezevi o mamavi: ―Ngueje c'ü ín Jmugöji c'ü ni jyodü. ");
INSERT INTO mazNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nuc'ua 'ma mü o nguarü o xäpcävi, cjanu o sinpivi c'ua e Jesús. Cjanu o ts'o's'üvi c'o mi tëjëvi, cjanu o ngãsp'ãvi c'e ts'iburru. Cjanu o 'ñes'evi c'ua e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nu ja mi pa e Jesús, c'o nte xo mi c'o's'üji c'o mi tëji, cja ma xĩ'p'ĩji cja c'e 'ñiji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","'Ma ya mi ngue ro zät'äji cja c'e t'eje c'ü ni chjũ Olivos, nza texe c'o nte c'o mi pöji e Jesús o mäji o mapjüji c'ua na jens'e o mamaji: ―Me na jo Mizhocjimi, me na nojo yo o dyacöji ró jandaji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Me na jo nu va ẽjẽ nu o 'ñeme Mizhocjimi ra manda. Ya dyacöji Mizhocjimi c'ü rá pötca mäpäji angueze, dya pje rá mbeñeji; me na nojo Mizhocjimi, eñe c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nuc'ua c'o ja nzi fariseo c'o mi dyoji c'o nte, o mamaji o xipjiji e Jesús: ―Xöpüte, huënch'i yo nte yo i̱ṉ pöcjeji, xipji ra ngo't'ü o̱ neji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","O ndünrü c'ua e Jesús o xipjiji: ―Rí xi'tsc'öji, 'ma dya ra mapjü yo, ra mapjü yo ndojo. ");
INSERT INTO mazNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nuc'ua 'ma ya mi ngue ro zät'äji, 'ma mü o jñanda e Jesús c'e jñiñi a Jerusalén, o huë'ë na ngue ja ma cja c'o mi menzumü nu. ");
INSERT INTO mazNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","O mama: ―Quera ri unnc'eji ngüenda c'o mi xi'tsc'öji. Nu'ma, ri salvagueji 'ma. Pero ya tsot'ü in chögueji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ngue c'ua ra zädä c'o pa 'ma ra ẽjẽ c'o nuc'üji na ü ra 'ñe dyö'büji o sanja ra mundoji c'e jõmü, ra ngãrãji texe lado cja in jñiñigueji. Nguec'ua dya ra sö rí pedyeji, dya xo ra sö cjó ra cjogü ra 'ñe mböxc'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ra yä'tc'äji nin jñiñigueji; dya ra nguejme ne ri 'na ndojo a xes'e cja c'ü nín mindojovi. Y ra mbö'tc'üji. Na ngue dya i̱ tsjapüji ngüenda nu nu o 'ñeme Mizhocjimi ro ẽ 'ñempc'eji libre. ");
INSERT INTO mazNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nuc'ua cjanu o cjogü a mbo cja c'e templo. Cjanu o pjongü c'o pje mi pö'ö cja c'e templo, 'ñe c'o pje mi tõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","O xipjiji: ―Ya t'opjü a cjava: “Nín nzungö ngue 'na ngumü c'ua ja ra dyötüji Mizhocjimi”, eñe o̱ jña Mizhocjimi. Nu'tsc'eji na cjapcütjoji nín nzungö nza cja 'ma ri ngue o̱ ngumü o mbẽ'ẽ c'ua ja tsjõji, embeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nuc'ua pama mi pa cja c'e templo mi xöpü c'o nte. C'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi, 'ñe c'o 'ñaja c'o mi pjëzhi na nojo, mi jodü ja rvá mbö't'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Dya mi töt'üji ja rvá tsjapüji, na ngue texe c'o nte me mi mä ma dyäräji c'o jña c'o mi mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","'Na nu pa, e Jesús mi xöpü c'o nte nu cja c'e templo mi xipjiji c'ü mi jyodü ro unü o̱ mü'büji Mizhocjimi na ngue ngueje c'ü manda. O säjä c'ua c'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi 'ñe c'o 'ñaja c'o mi pjëzhi na nojo. ");
INSERT INTO mazNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","O dyönüji e Jesús: ―Nu'tsc'e rí xitscöjme pje pjë'tsc'e c'ü i̱ṉ cjague yo. ¿Cjó ngue c'ü o 'ñempc'e rí tsjague yo? ");
INSERT INTO mazNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","O ndünrü c'ua e Jesús o xipjiji: ―Xo rá önnc'ügöji 'na t'önü c'ü rí xitscöji dya. ");
INSERT INTO mazNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Cjó 'ñeme e Juan ro jichi yo nte? ¿Cjo ngueje Mizhocjimi c'ü o 'ñeme, o ngueje yo nte?, embeji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Anguezeji pötü va mamatsjëji c'ua: ―'Ma rá mamaji ngueje Mizhocjimi c'ü o 'ñeme, ra xitscöji: “¿Jenga dya i̱ creoji 'ma c'ü mi xi'ts'iji e Juan?”, ra 'ñenzgöji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'Ma rá mamaji c'ü ngueje yo nte c'o o 'ñeme, ra pjacüji o ndojo yo nte. Na ngue cjapüji c'ü mi profeta e Juan, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Cjanu o ndünrüji c'ua o mamaji c'ü dya mi pãrãji cjó ngue c'ü vi 'ñeme e Juan. ");
INSERT INTO mazNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nuc'ua e Jesús o mama o xipjiji: ―Dya xo rá xi'tsc'öji pje pjëtscö nguec'ua rí cjagö yo. ");
INSERT INTO mazNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nuc'ua e Jesús cjanu o zopjü c'o nte, o xipjiji 'na ejemplo: ―Bübü 'na bëzo c'ü tjë 'na juajma. O ngant'a o uva cja c'ü o̱ juajma. Cjanu o unü c'ua media c'o ro mbëpi c'o uva. Cjanu o ma c'ua na jẽ; o mezhe c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nuc'ua 'ma ya mi ngue ro jogü c'o uva, cjanu o tsja c'e lamu o ndäjä 'naja o̱ mbëpji o ma'a ja c'o ma cja'a c'o uva, ngue c'ua ro unüji c'o uva c'o mi toca. Nu c'o pëpi c'o uva, o mbäräji na puncjü c'e mbëpji c'ü cja vi säjä, cjanu o pjongüji, dya pje unüji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nuc'ua c'e lamu o ndäjä c'ua c'ü 'naja o̱ mbëpji. 'Ma o zät'ä nu ja pëpiji c'o uva, xo mbäräji c'ü, me go mbãtãji. Cjanu o pjongüji, dya pje unüji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nuc'ua c'e lamu cjanu o ndäjä c'ua c'ü 'naja o̱ mbëpji. Nuc'ü, o xo'tp'üji o̱ cji, cjanu o pjongüji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Nuc'ua c'ü o̱ cjaja c'o uva o mama: “¿Ja rga cjapügö dya? C'ü rá cjagö, rá täjä nu ín ch'igö nu me rí negö. Xa'ma ra respetaoji nu”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","C'o pëpi c'o uva, 'ma mü o jñandaji ma ẽjẽ c'e t'i, o pötü va mamaji c'ua: “Nujnu, ngueje nu ra zopcüji ne huerta ra tsjapü o̱ cjaja. Mö rá pö't'üji ngue c'ua rá cjapcöji ín tsjacjöji ne huerta”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nuc'ua cjanu o ma pjongüji c'e t'i cja c'e huerta, cjanu o mbö't'üji. Ya nguarü ne ejemplo. ¿Cjo i̱ṉ pãrãgueji pje ra tsja dya c'e lamu? ¿Pje ra tsjapü c'o pëpi c'o uva? ");
INSERT INTO mazNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","C'ü ra tsja, ra ẽjẽ ra ẽ mbö't'ü c'o pëpi c'o uva. Nuc'ua cja rrũ unü o media c'o 'ñaja nte ra mbëpi c'o uva. C'o ndamböcjimi 'ñe c'o mi xopü o̱ ley Mizhocjimi 'ñe c'o 'ñaja c'o mi pjëzhi na nojo, 'ma mü o dyäräji, o mamaji: ―Dya ra jyëzi Mizhocjimi ra zädä c'ua ja nzi vi mangue. ");
INSERT INTO mazNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nuc'ua e Jesús o jñandbaji na jo o̱ jmiji, o xipjiji: ―¿Jenga i̱ṉ mangueji c'ü dya ra zädä? Maco xo t'opjü cja o̱ jña Mizhocjimi c'ü mama a cjava: Nu c'e ndojo c'ü dya go ne c'o mi jäbä c'e ngumü, ngue c'ü ot'ü ya jñumüji dya a squina c'ü, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","C'o ra pjeñe cja c'e ndojo, ixta 'huagü na jo c'o. Y 'ma ra ẽjẽ c'e ndojo ra 'ñe zë'bi 'na nte, ixta nzhench'e 'ma c'e nte, embeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","C'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi, mi jodüji ja rvá sö ro zürüji e Jesús. Na ngue 'ma mü o mama e Jesús c'e jña, o mbãrãji c'ü mi nguetsjë anguezeji vi jyëtsiji c'o mi pëpi c'o uva. Pero dya zürüji na ngue mi sũji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","C'ü o tsjaji, o xipjiji ja nzi c'o o̱ dyoji ro ma chëzhiji cja c'o nte c'o mi xöpü e Jesús, ro ma tsjapüji t'önü e Jesús. Xa'ma pje c'o ro mama angueze, ngue c'ua ro sö ro ngöt'üji cja c'e gobernador. Pero ro tsjapüji c'ü mi ne ro mbãrãji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","O mama c'ua anguezeji o xipjiji e Jesús: ―Nu'tsc'e xöpüte, rí pãrãgöjme c'ü i̱ṉ mamague c'o na jo, 'ñe i̱ṉ xöpügue na jo yo nte. I̱ṉ xipji c'ü na cjuana yo nte, zö pjëzhiji zö dya pje pjëzhiji. Xo rí pãrãgöjme c'ü i̱ṉ xöpügue c'ü na cjuana ja ga cja o̱ 'ñiji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Xitscöjme pje mama o̱ ley Mizhocjimi. ¿Cjo na jo rá cjõt'üji o contribución c'ü örü e rey César o jiyö?, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","E Jesús mi pãrã c'o na s'o c'o mi cjijñiji; nguec'ua va xipjiji: ―¿Jenga chaque va 'ñe önngüji? ");
INSERT INTO mazNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Jítsiji 'na merio. O jíchiji c'ua 'na merio. O mama c'ua e Jesús: ―¿Cjó o̱ ñi nu cuat'ü ne merio 'ñe cjó o̱ tjũ nu juns'ü? O ndünrüji c'ua o mamaji: ―Ngueje e César. ");
INSERT INTO mazNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","O ndünrü c'ua e Jesús o xipjiji: ―C'ü toca e César, rí unüji e César. C'ü toca Mizhocjimi, rí unüji Mizhocjimi, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na jo va ndünrü e Jesús, y vi dyärä c'o nte c'o ma puncjü. Nguec'ua c'o ndamböcjimi 'ñe c'o xöpüte, dya sö pje ro chö'tp'üji angueze. O unüji ngüenda c'ü me na jo va ndünrü. O nguijñiji c'ua: ―Nunca rí ärägöji c'ü ri ña a cjanu 'na nte, eñeji. Y dya cja pje dyönüji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","C'e partido c'ü mi xiji saduceo mi mamaji c'ü dya ra sö ra te yo añima. O säjä c'ua ja nzi anguezeji cja e Jesús o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Xöpüte, e Moisés o dyopjü cja ín leygöji, 'ma cjó c'o ra ndũ, 'ma dya be 'ñejui t'i c'ü nu su, nu'ma, c'ü nu su ra chjüntüvi 'ma c'ü 'naja o̱ cjuarma c'e bëzo c'ü ya ndũ. Nuc'ua c'e bëzo c'ü vi ndũ, je ngue o̱ tjũ c'ü ra jñusp'üvi c'e t'i c'ü ot'ü ra jmus'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nuzgöjme, mi bübüzgöjme siete bëzo c'o mi cjuarmaji. 'Naja anguezeji o chjüntü pero o ndũ, dya 'ñejui t'i c'ü nu su. ");
INSERT INTO mazNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nuc'ua c'ü na yeje o̱ cjuarma xo chjüntüvi c'e ndixũ. Xo ndũtjo, dya 'ñejui t'i. ");
INSERT INTO mazNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Je xo va cjatjonu c'ü na jñi, hasta o llega nza sieteji. O chjüntüvi c'e ndixũ nza texeji. Y o ndũji, dya 'ñeji t'i. ");
INSERT INTO mazNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Cjanu o ndũ c'ua c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","'Ma ra te c'o añima ja c'o nzi gui mangue, ¿cjó ngue c'ü ra tsjapü nu su c'e ndixũ? Na ngue nza sieteji nde go tsjapü o̱ suji, eñe c'o saduceo. ");
INSERT INTO mazNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","O ndünrü c'ua e Jesús o xipjiji: ―Yo nte cja ne xoñijõmü chjüntüji. Xo 'ñe c'o o̱ t'iji chjüntpüji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yo nte, dya texeji ra teji ra ma ngãrãji a jens'e; nguextjo c'o ya rguí jogü cja jmi Mizhocjimi. 'Ma ra te c'o, dya ra chjüntüji, dya cjó xo ra chjüntpüji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na ngue dya cja ra ndũji. Nguec'ua ri chjëntjui c'o o̱ anxe Mizhocjimi c'o dya chjüntü ni ri tũ. Y ri chjëntjui nza cja Mizhocjimi, na ngue ya rguí tetjoji ya rguí bübütjoji na yeje. ");
INSERT INTO mazNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ixi 'ñetsetjo cja o̱ jña Mizhocjimi c'o o dyopjü e Moisés, c'ü ra te c'o añima. Ngue cja c'e pasaje nu ja mama c'ü mi tjë c'e bidyi. O dyopjü ja va mama Mizhocjimi. O mama a cjava: “Ngue o̱ Mizhocjimizü e Abraham 'ñe e Isaac 'ñe e Jacob”, eñe Mizhocjimi cja c'o o̱ dyopjü e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mizhocjimi dya ngue o̱ Mizhocjimi c'o añima, ngue o̱ Mizhocjimi c'o bübütjo. Ngue c'ua ixi 'ñetsetjo, zö ya ndũ e Abraham 'ñe e Isaac 'ñe e Jacob, pero bübütjoji y ra tetjoji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nuc'ua ja nzi c'o fariseo o xipjiji c'ua e Jesús: ―Xöpüte, me na jo gui mangue, embeji. ");
INSERT INTO mazNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dya cjó cja rezga pje xe ro dyönü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","O mama c'ua e Jesús o xipjiji: ―C'o xöpü o̱ ley Mizhocjimi mamaji e Cristo ri mboxbëche cja e David. ");
INSERT INTO mazNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Maco nguetsjë e David o dyopjü a cjava cja Salmo: Mizhocjimi o zopjü c'ü ín Jmugö o xipji: “Mimi cja ín jodyëgö. ");
INSERT INTO mazNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Rí da'c'ü rí mandague hasta 'ma cja rí chõpü yo nuc'ü na ü”, eñe Mizhocjimi cja c'o o dyopjü e David. ");
INSERT INTO mazNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","E David o nädä e Cristo o mama: “Ngue ín Jmugö”, eñe. ¿Pje ne ra mama c'ü ri mboxbëche e Cristo cja e David 'ñe c'ü xo ri ngue o̱ Jmu?, eñe e Jesús va xipji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nuc'ua e Jesús o zopjü c'o o̱ discípulo; ma dyärä c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","O xipjiji: ―Rí pjötpüji ngüenda cja yo xöpü o̱ ley Mizhocjimi. Anguezeji cjapüji na noji ga nzhodüji na maja o̱ bituji. Me xo neji cjó ra mbësp'iji t'ecjañõmü rgá zenguaji cja o chõjmü. 'Ma pöji cja nintsjimi, me juajnüji o lugar c'o na jo ja ra mimiji, ngue c'ua yo nte ra jñandaji anguezeji ra mamaji me na joji. Y 'ma go tsjaji o mbaxua, me xo juajnüji o lugar c'o me na jo. ");
INSERT INTO mazNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Anguezeji jünbüji c'o pë's'i yo ndixũ yo ya ndũ nu xĩra. Pero me cjapüji na joji; me mezhe ga dyötüji Mizhocjimi. Na ngue c'ü ni tsjaji c'o na s'o, Mizhocjimi ra tsjapü xenda ra sufreji que na ngue 'ma dya ri xöpüteji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nuc'ua e Jesús o jñanda c'o rico mi junt'ü o̱ merioji cja c'e caja nu ja mi mbeñeji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Xo jñanda o ẽjẽ 'na ndixũ c'ü mi pöbre c'ü ya vi ndũ nu xĩra, o 'ñe jñunt'ü yeje merio c'o dya nda mi muvi. ");
INSERT INTO mazNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","O mama c'ua e Jesús: ―Dyäräji na jo c'ü rá xi'tsc'öji. C'o yeje merio c'o o jñunt'ü ne ndixũ nu pöbre, xenda ni muvi a jmi Mizhocjimi que na ngue c'o o jñunt'ü yo 'ñaja. ");
INSERT INTO mazNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yo rico o mbeñeji Mizhocjimi o unüji c'o vi mboncjü. Nu ne ndixũ o unü texe c'o mi jün c'o rví ma ndõmü c'ü ro zi, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mi bübü ja nzi c'o o mama ja ma cja c'e templo. O mamaji c'ü me ma zö c'o ndojo c'o vi dyät'äji c'ü; me xo ma zö c'o mi dornao c'e templo c'o vi unü c'o nte. O mama c'ua e Jesús: ");
INSERT INTO mazNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Nujyo i̱ṉ jandaji, ra zädä c'o pa 'ma dya cja ra jyäns'ä yeje ndojo c'o dya ra yät'ä. ");
INSERT INTO mazNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","O mamaji c'ua: ―Xöpüte, ¿jinguã ra zädä yo? ¿Pje ma señal c'ü rá jandajme ngue c'ua rá pãrãjme 'ma ya ri ngue ra zädä yo? ");
INSERT INTO mazNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","O ndünrü c'ua e Jesús: ―Pjötpüji ngüenda c'ü dya rí creogueji c'o ra 'ñe dyon'c'üji. Ra ẽjẽ na puncjü c'o ra jñüncügö ín chjũ, ra mamaji ngueje Cristo anguezeji. Y bübü c'o ra mama c'ü ya ra nguins'i e jens'e 'ñe ne xoñijõmü. Dya rí cheñeji anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y rí dyäräji ri cjaji o chũ. Xo ra mbezheji ya ri cjaji o chũ. Dya rí sũgueji, na ngue ni jyodü ra zädä a cjanu. Pero dya be ra nguins'i ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","O sido o ña e Jesús o xipjiji: ―Yo país ra chũji co yo 'ñaja país. C'o rey ra chũji co c'o 'ñaja rey. ");
INSERT INTO mazNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ra mbi na zëzhi ne xoñijõmü. Y na puncjü o jñiñi ja c'o ra sufreji o tjijmi 'ñe na puncjü o jñiñi c'o ra nzhodü o ngueme c'o me na s'ëzhi. Ra jñandaji a jens'e c'o nunca jandaji nguec'ua me ra zũji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ante c'ü ra zädä yo, ra zü'c'üji yo nte ra tsja'c'üji c'ü rí sufregueji. Ra zints'iji cja yo nintsjimi ra jñün'c'üji ngüenda ra pantc'aji a pjörü. Y ra zints'iji cja yo rey 'ñe yo gobernador. Nujyo, ra tsja'c'üji yo, na ngue c'ü ri ejmezüji y ri nänngäji ín chjũgö. ");
INSERT INTO mazNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","'Ma ra zints'iji a cjanu cja c'o pje pjëzhi, ra sö rí xipjiji ja ga cjazgö. ");
INSERT INTO mazNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ixtí jñunt'ü in mü'büji c'ü dya ni jyodü rí tsjijñiji ja rgui chjünrüji, ante c'ü ra jñün'c'üji ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Na ngue nutscö rá da'c'üji o jña c'ü rí mangueji, 'ñe o pjeñe. Nguec'ua c'o nuc'üji na ü, dya ra sö pje ra xi'ts'iji. Dya xo ra sö ra xi'ts'iji: “Dya cjuana c'ü i̱ṉ mangueji”, ra 'ñents'eji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bübü 'ma ri ngue nin tataji 'ñe nin nanaji ra zints'iji cja c'o pje pjëzhi. Bübü 'ma ri ngue nin cjuarmaji o ngue 'na in dyocjeji, o ngue 'na c'ü i̱ṉ jogueji. Bübüts'üji c'o ra mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Texeji ra nuc'üji na ü, na ngue nu'tsc'eji ri ejmezüji y ri nänngäji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero dya ra sö pje ra tsja'c'üji, 'ma dya ra ne Mizhocjimi, ni ri ngue 'naja in ñixteji ra ndö'tc'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Zö ra tsja'c'üji yo, pero 'ma rí sido rí 'ñejmeji Mizhocjimi, rí bübütjogueji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’'Ma rí jñandaji c'ü ya ri cãrã o tropa texe lado a Jerusalén, ngue 'ma rí pãrãgueji 'ma c'ü ya ra zädä ra yä't'äji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","'Ma rí jñandaji a cjanu, nu'tsc'eji ri cãrãji a Judea rí c'ueñe rí möji cja t'eje. Nu'tsc'eji ri cãrãji mero a Jerusalén, rí pedye rí möji. Nu'tsc'eji ri cãrãji cja in juancjeji ri pëpjiji, dya cja rí nzhogüji a Jerusalén; ixtí möji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","C'o pa c'o, yo nte ra sufreji na ngue c'o na s'o c'o vi tsjaji. Ra zädä c'o t'opjü o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Juejme c'o ri ndunte 'ñe c'o ri jötü o lëlë c'o pa c'o. Me ra sufreji va a Judea texeji; Mizhocjimi ra castigao yo nte. ");
INSERT INTO mazNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Cãrã c'o ra mbö't'üji co tjëdyi. Cãrã c'o ra dyëdyiji cja c'o nan'ño país. C'o dya menzumü a Jerusalén, ngueje c'o ra manda nu, hasta 'ma ra zädä c'ü ya mama Mizhocjimi c'ü dya cja ra mandaji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ra jñandaji c'o nunca jandaji, na ngue nan'ño rgá jñetse e jyarü 'ñe e zana 'ñe yo seje. Y cja ne xoñijõmü me ra yu'u na jens'e yo mar rgá pjö's'ü e ndeje. Nguec'ua yo nte, me ra zũji, dya ra mbãrãji pje ra tsjaji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Me ra jyoji na ngue c'ü me ri sũji c'o xe ra zädä. Na ngue yo bübü a jens'e ra pötü c'ü dya ri nza cja 'ma ot'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nuc'ua ra jñandgagöji rva ẽcjö cja ngõmü, ra jñandgöji c'ü me rrã zëtsi 'ñe rrã zözü. ");
INSERT INTO mazNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","'Ma ra mbürü ra zädä yo, me rí mäji rgui chepquegöji. Na ngue dya cja ra mezhe rá 'ñe empc'öji libre c'o ri sufregueji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","O sido o ña e Jesús o xipjiji: ―Tsjijñiji ja ga cja c'e za'a c'ü ni chjũ higo, 'ñe yo pje nde ma za'a. ");
INSERT INTO mazNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","'Ma i̱ṉ jandaji ya peje o̱ xi, i̱ṉ pãrãji ya ra ẽjẽ c'o pa 'ma ra paja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Je xo rga cjatjonu, 'ma rí jñandaji c'ü ya ra zädä yo rí xi'tsc'öji, rí pãrãgueji 'ma c'ü ya rá mandagö nutscö o 'ñevguegö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Dyäräji na jo c'ü rá xi'tsc'öji dya. C'o ri cãrã c'o pa c'o, dya ra ndũ texe c'o, hasta 'ma cja ra zädä texe yo rí xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ra nguarü e jens'e 'ñe ne xoñijõmü, pero nín jñagö nunca ra nguarü nu. ");
INSERT INTO mazNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Pjötpüji na puncjü ngüenda c'ü dya rí mäpäji yo bübü cja ne xoñijõmü, nza cja c'o si o t'apjü cja na tĩji. Dya xo rí mamaji ja rgui chöt'üji pje rí siji 'ñe pje rí jyeji. 'Ma rí tsjaji a cjanu, ra meze in mü'büji. Nguec'ua 'ma ra zädä c'e pa 'ma rá ẽcjö na yeje, dya ri tepqueji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","'Ma ra ẽjẽ c'e pa, ra sufre texe yo cãrã cja ne xoñijõmü c'o dya ri tepque. ");
INSERT INTO mazNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nu'tsc'eji rí chepqueji. Rí sido rí dyötüji Mizhocjimi ra dya'c'üji rí zëzhgueji, ngue c'ua dya rí sufreji c'o ra zädä. Y ngue c'ua 'ma rá ẽcjö na yeje cja Mizhocjimi, 'ma rá jün'c'üji ngüenda, dya pje rá tö'tc'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","'Ma ndempa e Jesús mi xöpü cja c'e templo. 'Ma xõmü mi pedye mi pa oxü cja c'e t'eje c'ü ni chjũ Olivos. ");
INSERT INTO mazNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","'Ma xõrü, ts'i mi 'ñeje c'o nte cja c'e templo, ma ẽ ätpäji o̱ jña. ");
INSERT INTO mazNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ya mi ngue ro zädä c'e mbaxua c'ü mi chjũ Pascua, 'ma mi siji o tjõmëch' i c'o dya mi bäns'ä. ");
INSERT INTO mazNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","C'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi mi ne ixto mbö't'üji e Jesús. Pero mi sũji c'o nte. Nguec'ua me mi jodü ja rvá sö ro mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","C'ü dya jo mi dyojui e Judas Iscariote c'ü mi ngue 'naja c'o doce o̱ discípulo e Jesús. O 'ñünbü o̱ mü'bü e Judas. ");
INSERT INTO mazNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nuc'ua e Judas o dyätä c'ü dya jo, o ma cja c'o ndamböcjimi 'ñe c'o comandante cja c'e templo, o ma ñaji ja rvá tsja e Judas ngue c'ua anguezeji ro sö ro zürüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Anguezeji me co mäji c'ua, o mamaji c'ü ro ngõ't'üji e Judas. ");
INSERT INTO mazNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nuc'ua e Judas o mama c'ü ro tsja ja c'o nzi va xipjiji. Nuc'ua mi jodü ja rvá zidyi anguezeji nu ja c'o ma bübü e Jesús, ngue c'ua ro sö ro zürüji e Jesús 'ma dya ri cãrã c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","O zädä c'ua c'e pa 'ma mi jyodü ro mbö't'üji 'na ts'imë c'ü ro zaji c'ü rví pjongüji c'e mbaxua. Xo ro ziji o tjõmëch'i c'o dya mi bäns'ä. Tsjë'ma mi cjaji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nuc'ua e Jesús o ma't'ü e Pedro 'ñe e Juan o xipjivi: ―Mëvi ma dyät'ävi o jñõnü ngue c'ua rá sũpcöji ne mbaxua. ");
INSERT INTO mazNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","O ndünrü c'ua anguezevi o dyönüvi: ―¿Ja ngue c'ua i̱ṉ ne rá sigöji, ngue c'ua rá ma ät'äbe? ");
INSERT INTO mazNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","O ndünrü c'ua e Jesús o xipjivi: ―Dyärävi c'ü rí xi'ts'ivi. 'Ma rí sät'ävi cja c'e jñiñi, rí chjëji 'na bëzo c'ü ri tunü 'na xäjnä o ndeje. Rí möji angueze, xo rí tsjogüvi cja c'e ngumü nu ja ra cjogü angueze. ");
INSERT INTO mazNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Rí xipjivi c'ua c'e bëzo c'ü menzumü nu: “C'ü rvá ẽcjöbe, mama c'e xöpüte rá ẽ xi'ts'ibe, ¿ja bübü c'e cuarto nu ja ra mimi co c'o o̱ discípulo ra ziji c'ü rguí zũpüji ne mbaxua?” Je rga cjanu rgui xipjivi c'e menzumü. ");
INSERT INTO mazNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nuc'ua angueze ra jí'ts'ivi 'na jyäxcumü c'ü na nojo c'ü ya bübü texe c'o ni jyodü. Ngueje nu rí dyät'ävi o jñõnü nu, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Anguezevi o mëvi c'ua, o ma chöt'üvi c'ua ja nzi va xipjivi. O dyät'ävi c'ua o jñõnü c'o ro ziji rvá zũpüji c'e mbaxua. ");
INSERT INTO mazNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nuc'ua 'ma mü o zädä c'e hora c'ü ro ziji c'e jñõnü, o mimi c'ua e Jesús cja c'e mexa. Xo 'ñe c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","O mama c'ua e Jesús: ―Me rí negö c'ü 'natjo c'ua rá siji c'ü rga sũpcöji ne mbaxua ante c'ü rá sufregö. ");
INSERT INTO mazNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Rí xi'tsc'öji, dya cja rá sigö c'ü rga sũpcö ne mbaxua; ya ra mbötcüji ja c'o nzi ga mbö't'üji o ts'imë c'o ni zũpüji ne mbaxua. Nuc'ua, ngueje nu ja manda Mizhocjimi cja rá sigöji na yeje 'ma. ");
INSERT INTO mazNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","O ndũ c'ua 'na vaso, cjanu o unü 'na pöjö Mizhocjimi. O mama c'ua: ―Chũji nu, rí siji i̱ṉ texeji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Rí xi'tsc'öji, dya cja rá sigö o̱ ndeje o uva hasta 'ma ra zädä c'ü rá mandagö nutscö o 'ñevguegö Mizhocjimi, embeji c'o discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Cjanu o jñü c'ua 'na tjõmëch'i o unü 'na pöjö Mizhocjimi. Cjanu o xënbi c'ua c'o o̱ discípulo, o xipjiji: ―Nujnu ngue ín cuerpogö nu. Co nín cuerpogö, rá päjtc'ägöji c'ü rvi chũji. Nu na cjagueji dya, dya rí jyombeñe rí tsjagueji nu, ngue c'ua rí mbenzgöji, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nuc'ua 'ma ya vi nguarü vi ziji c'e tjõmëch'i, e Jesús xo ndũ c'e vaso. O yepe o unü 'na pöjö ja c'o nzi va jñü c'e tjõmëch'i. Cjanu o xipji c'o o̱ discípulo: ―Nujnu ngue ín tsjigö nu. C'ü rga pjödü ín tsji rá tũgö, ngue c'ü rgui pãrãgueji c'ü ra perdonaots'üji Mizhocjimi ja c'o nzi va mama. ");
INSERT INTO mazNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Tsjijñiji c'ü rá xi'tsc'öji. Nu c'ü ra nzhögügö cja o̱ dyë yo nte ngue c'ua ra mbötcüji, ngueje 'naja yo rrã sigöji o xëdyi. ");
INSERT INTO mazNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","C'ü rvá ẽcjö cja Mizhocjimi, ngue c'ü ra mbötcüji ja c'o nzi va mama Mizhocjimi. Pero juejme ne bëzo nu ra nzhögügö. Ra tsjapü Mizhocjimi me ra sufre nu. ");
INSERT INTO mazNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nuc'ua anguezeji pötü va dyönüji cjó mi ngue anguezeji c'ü ro tsja a cjanu ro nzhö e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","C'e xõmü, c'o discípulo o zöji o jña cjó mi ngue anguezeji c'ü ro tsja xo'ñi. ");
INSERT INTO mazNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nuc'ua o mama e Jesús o xipjiji: ―C'o o̱ rey c'o nte c'o dya ma't'ü Mizhocjimi, me mandaji yo nte. Me xipjiji c'ü pje ra tsja yo nte, maco ne c'o rey c'ü ra xiji me na jonteji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nu'tsc'eji, dya je rga cjatsc'eji nu. Bübüts'üji c'o ra ch'unü ra mbëzhiji na nojo, pero ni jyodü ra pjösteji nza cja 'na t'i c'ü xe sëbi. Zö bübütsc'eji c'o ra mandatsc'eji, pero ni jyodü ra mböxc'üji nza cja 'ma ri ngue 'na mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Ja ngue c'ü mamaji c'ü xenda na nojo? ¿Cjo ngue c'ü mimi cja mexa ga zi o xëdyi, o ngue c'ü sirve o jñõnü? Ngueje c'ü mimi cja mexa. Maco rí pjöstegö a ndetsc'eji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Zö dya ätcägö yo nte, zö me nugüji na ü, pero nu'tsc'eji sido i̱ṉ nzhodüji co nuzgö. ");
INSERT INTO mazNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nguec'ua rí da'c'ü rí mandaji, ja c'o nzi va dyacügö mi Tatagö. ");
INSERT INTO mazNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","'Ma rá mandagö, nu'tsc'eji rí mimiji co nuzgö rá siji o xëdyi. Y rí tsjaji juesi rí jñünpüji ngüenda c'o ín menzumüji a Israel c'o tsja cja c'o doce estado. ");
INSERT INTO mazNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Xo mama c'ua e Jesús c'ín Jmugöji: ―Nu'tsc'e Simón, dyärä na jo c'ü rí xi'tsc'ö. E Satanás c'ü dya jo, o ch'unü sjëtsi ra zöc'üji i̱ṉ texeji. Ne angueze rí xõgueji co nuzgö rí pjöt'üji, nza cja ga mböt'ü o paxa 'ma pitsiji o ndëxü. ");
INSERT INTO mazNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nu'tsc'e Simón, rí pãrãgö ra mezhe 'na ndajme ra ndõ'c'ü c'ü dya jo. Pero ró ö'tc'ü Mizhocjimi c'ü rí sido rí creozügö. 'Ma ra nzhogü in mü'bügue, rí pjös'ü yo nin cjuarma xo ra zëzhiji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","O ndünrü c'ua e Simón Pedro o xipji e Jesús: ―Nu'tsc'e ín Jmuts'ügö, rí bübü dispuesto rá mëgövi, zö ra pantcavi a pjörü. Xo rí bübü dispuesto rá tũgö co nu'tsc'e. ");
INSERT INTO mazNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","E Jesús o xipji: ―Nu'tsc'e Pedro, rí xi'ts'i, ante c'ü ra huë o tare, ya na jñi rgui mamague c'ü dya i̱ṉ pãcãgö. ");
INSERT INTO mazNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","O sido o ña e Jesús o xipji c'o discípulo: ―'Ma i̱ möcjeji i̱ ma zopjüji yo nte, ró xi'tsc'öji c'ü dya i̱ tsanaji o mape, ni xo i̱ jñünüji o merio. Xo ró xi'tsc'öji c'ü dya i̱ tsidyiji c'o ri chin'ch'iji. ¿Cjo pje c'o o bë'ts'iji 'ma? O ndünrü c'ua anguezeji o mamaji: ―Iyö, dya pje bëtsijme. ");
INSERT INTO mazNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","O ndünrü c'ua e Jesús o xipjiji: ―Nudya, c'o cãjãts'üji mape ra ngana c'o. Xo rí jñünüji o merio. Na ngue dya cja ra recibidots'üji nza cja 'ma ot'ü. C'o dya jün o tjëdyi, ra mböji c'ü tëji ra ndõmüji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na ngue rí xi'ts'iji c'ü ni jyodü ra zädä o̱ jña Mizhocjimi c'ü mama a cjava rá sufregö: “Yo nte ra mamaji c'ü me na s'o c'ü”, eñe. Jã, ni jyodü ra zädä texe c'ü ya t'opjü ja rga sufregö. ");
INSERT INTO mazNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","O mama c'ua c'o discípulo: ―Nu'tsc'e ín Jmuts'ügöjme, bübü va yeje tjëdyi. O ndünrü c'ua e Jesús o xipjiji: ―Na jotjo co nujyo. ");
INSERT INTO mazNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Cjanu o mbedye c'ua e Jesús o ma cja c'e t'eje c'ü ni chjũ Olivos, o ma'a ja c'o nzi ma cja o̱ tjũrü. Xo möji co c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","'Ma mü o zät'äji cja c'e t'eje, o mama c'ua e Jesús o xipjiji: ―Dyötüji Mizhocjimi c'ü dya rí dyätäji c'ü dya jo 'ma ra zöc'üji, embeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nuc'ua cjanu o xõgü co anguezeji, o ma c'ua na ts'ijẽ, nza cja 'ma ja c'o sobü 'na ndojo 'ma cjó c'o pana. O ndüñijõmü c'ua va dyötü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","O mama: ―Mi Tatats'ügö. 'Ma rí ñegue, rí ts'a's'ü c'ü dya ra zädä c'ü rá sufregö. Pero dya rí tsjague c'ua ja rgá negö; tsjague c'ua ja nzi gui ñegue, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","O 'ñetse c'ua 'na anxe c'ü vi 'ñeje a jens'e cja Mizhocjimi, o 'ñe tsjapü o zëzhi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Me ma sufre e Jesús. Xe ma ötü Mizhocjimi co texe o̱ mü'bü. O̱ jenzhe, me ma puncjü ma mbibi a jõmü nza cja o cji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nuc'ua 'ma mü o nguarü o dyötü Mizhocjimi, o böbü. Cjanu o ma c'ua nu ja mi bübü c'o o̱ discípulo. O chöt'üji ma ĩji, na ngue c'o mi cjijñiji ro sufre e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","O mama c'ua e Jesús o xipjiji: ―¿Jenga i̱ṉ ĩcjeji? Rí ñangaji rí dyötüji Mizhocjimi, ngue c'ua dya rí dyätäji c'ü dya jo, 'ma ra zöc'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","'Ma xe ma ña e Jesús, o säjä c'ua na puncjü o nte. Mi ot'ü a xo'ñi c'ü mi chjũ e Judas c'ü mi ngueje 'naja c'o doce discípulo. Cjanu o chëzhi c'ua cja e Jesús cjanu o zü'tp'ü o̱ jmi. ");
INSERT INTO mazNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nuc'ua e Jesús o xipji: ―Nu'tsc'e Judas. Rvá ẽcjö cja Mizhocjimi. Maco va ẽ sütcü ín jmi ngue c'ua yo va dyocjeji ra mbãcöji nguetscö e Jesús, ngue c'ua ra zinzgöji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","C'o mi dyoji e Jesús, 'ma mü o jñandaji c'ü ya ro zidyiji e Jesús, o xipjiji c'ua: ―¿Cjo na jo rá ya'büjme co tjëdyi yo? ");
INSERT INTO mazNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Cjanu o tsja c'ua 'na c'o discípulo o ya'bü 'na tjëdyi 'naja c'o o̱ mbëpji c'ü mi mero ndamböcjimi, o jñüpcü o̱ ngõ cja o̱ jodyë. ");
INSERT INTO mazNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","O ndünrü c'ua e Jesús o mama: ―Iyö. Jyëziji ra tsjacüji c'ua ja c'o nzi ga neji, embeji c'o discípulo. Nuc'ua e Jesús o jopcü c'ua c'ü o̱ ngõ c'e mbëpji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nuc'ua e Jesús cjanu o zopjü c'o ndamböcjimi, 'ñe c'o comandante cja c'e templo, 'ñe c'o 'ñaja c'o pje mi pjëzhi c'o vi 'ñe zidyi e Jesús, o xipjiji: ―¿Jenga i̱ṉ cjagueji a cjanu? I̱ pedyeji cja c'in jñiñiji va ẽ sücöji nza cja 'ma ri nguezgö 'na mbẽ, va jünji in chjëdyiji 'ñe in ngarroteji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pama mi bünc'öji co nu'tsc'eji cja c'e templo, maco dya mi sücügöji 'ma. Pero nudya, ngue ne hora nu ya ch'a'c'üji rí tsjacöji yo. Ngue ne hora nu ya ch'unü e Satanás c'ü dya jo, ra tsja ja c'o nzi ga ne. ");
INSERT INTO mazNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nuc'ua anguezeji o pënch'iji e Jesús, cjanu o zidyiji cja o̱ ngumü c'ü mi mero ndamböcjimi. 'Ma ya mi möji, e Pedro mi bëpjatjo na jẽ cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","'Ma mü o zät'äji, o 'ñõrüji c'ua 'na sivi a nde cja c'e tji, o mimiji c'ua o pa't'üji. E Pedro xo mimi co anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","'Na ndixũ c'ü mi mbëpite nu, o jñandaji e Pedro mi junrü cja o̱ jya's'ü c'e sivi. O nguin'chp'i c'ua o̱ jmi, cjanu o mama: ―Nujnu, nde mi dyoji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","O ngädä c'ua e Pedro o mama: ―Dya rí pãrãgö nu. ");
INSERT INTO mazNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Dya mezhe c'ua, c'ü 'naja nte o jñanda mi junrü nu e Pedro, cjanu o xipji: ―Xo ngue'tsc'e 'naja c'o nde mi dyoji e Jesús. O mama c'ua e Pedro: ―Nu'tsc'e bëzo, dya nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","O mezhe c'ua 'na hora, cjanu o mama c'ua c'ü 'naja: ―Na cjuana rí pãrãgö, ne bëzo nu, nde mi dyoji e Jesús. Xo menzumü a Galilea nu. ");
INSERT INTO mazNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","O mama c'ua e Pedro: ―Nu'tsc'e bëzo, dya rí pãrãgö c'ü i̱ṉ mangue. Nuc'ua 'ma mi ña e Pedro, cjanu o huë c'ua 'na tare. ");
INSERT INTO mazNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nuc'ua e Jesús c'ü ín Jmugöji o jñandaji e Pedro. Nuc'ua e Pedro o mbeñe c'o jña c'o vi xipji c'ín Jmugöji: “Ante c'ü ra huë o tare, ya na jñi rgui mamague c'ü dya i̱ṉ pãcãgö”, vi 'ñeñe. ");
INSERT INTO mazNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nuc'ua e Pedro o mbedye a tji, me go huë co texe o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","C'o bëzo c'o mi pjörü e Jesús, me mi cjapüji burla e Jesús, y mi päräji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Cjanu o ngo'tp'üji o̱ ndö co 'na ts'imbayo. Cjanu o ya'büji o̱ jmi, o xipjiji: ―'Ma o 'ñempc'e Mizhocjimi, mamague cjó ngue c'ü o mbäräts'ü, embeji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y pje c'o nde mi xipjiji ma zadüji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nuc'ua 'ma ya mü o jyans'ü, o jmurü c'ua c'o tita c'o pje mi pjëzhi cja c'e jñiñi, 'ñe c'o ndamböcjimi, 'ñe c'o mi xöpü o̱ ley Mizhocjimi. O zidyiji c'ua e Jesús nu ja ro jñünpüji ngüenda. O jñünpüji c'ua ngüenda o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―¿Cjo ngue'tsc'e e Cristo? Xitsijme. O ndünrü c'ua angueze o xipjiji: ―Zö ro xi'ts'iji, pero dya i̱ṉ creozüji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nu 'ma xo ro önnc'ügöji, dya xo ri chjünrügueji. Dya xo ri xäcäzüji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nutscö rvá ẽcjö cja Mizhocjimi, dya ra mezhe rá ma mimi cja o̱ jodyë Mizhocjimi c'ü me na zëzhi. ");
INSERT INTO mazNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Texeji o mamaji c'ua: ―¿Cjo ngue'tsc'e o̱ T'its'ü Mizhocjimi 'ma? O ndünrü c'ua e Jesús o xipjiji: ―Jã, nguezgö c'ua ja vi mangueji. ");
INSERT INTO mazNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Anguezeji o mamaji c'ua: ―¿Pje xe ni jyodü o testigo? Nuzgötsjëji ró äräji c'o o mama. ");
INSERT INTO mazNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Cjanu o böbüji c'ua texeji, cjanu o zidyiji c'ua e Jesús cja e Pilato. ");
INSERT INTO mazNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","O mbürü o xipjiji e Pilato c'ü vi tsja na s'o e Jesús, o mamaji: ―Nu ne bëzo nu, ró tö'tp'üjme mi onpü yo ín menzumügöjme, mi xipjiji c'ü dya cja ra dyätäji c'ü in gobiernogue. Mama c'ü dya rá cjõ't'üjme o contribución e César. Xo mama c'ü nguetsjë angueze e Cristo c'ü te'be yo nte ra manda. ");
INSERT INTO mazNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","O mama c'ua e Pilato o xipji e Jesús: ―¿Cjo i̱ṉ reygue cja yo menzumü a Israel? O ndünrü c'ua e Jesús o xipji: ―Jã, nguetscö c'ua ja vi mangue. ");
INSERT INTO mazNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nuc'ua e Pilato, o xipji c'o ndamböcjimi 'ñe c'o nte: ―Dya pje rí tö'tp'ügö c'o na s'o ne bëzo nu. ");
INSERT INTO mazNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","C'o ndamböcjimi 'ñe c'o nte, sido mi xipjiji e Pilato c'ü vi tsja na s'o e Jesús, o mamaji: ―Nujne bëzo nu, xöpü yo nte texe cja yo ín jñiñigöjme. O mbürü a ma a Galilea. Nuc'ua ma ẽjẽ ma xöpü texe cja yo jñiñi hasta 'ma cja mü o säjä a 'ñeva a Jerusalén, xo xöpü va. Nguec'ua yo nte ne ra tsjaji o chũ, dya cja ra dyätäji in gobiernogue, mi eñeji ma ngöt'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nuc'ua e Pilato 'ma mü o dyärä c'o vi mamaji, cjanu o tsja c'ua t'önü: ―¿Cjo menzumü a Galilea ne bëzo? ");
INSERT INTO mazNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nuc'ua e Pilato, 'ma mü o mbãrã c'ü je mi menzumü e Jesús a Galilea, o manda c'ua ro zidyiji e Jesús cja e rey Herodes c'ü mi bübü a Jerusalén c'o pa c'o. Na ngue ngueje e Herodes c'ü mi manda a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nuc'ua e Herodes, 'ma mü o jñanda e Jesús, me co mäjä na puncjü. Na ngue ya vi mezhe mi ne ro jñanda, na ngue mi ärä c'ü me mi näntji e Jesús. Mi te'be c'ü ro tsja e Jesús o señal c'o me na nojo, ngue c'ua ro jñanda. ");
INSERT INTO mazNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nguec'ua va tsjapü na puncjü t'önü e Jesús. Pero dya go ndünrü. ");
INSERT INTO mazNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Xo mi cãrã nu c'o ndamböcjimi 'ñe c'o mi xöpü o̱ ley Mizhocjimi. Me mi ñaji ma ngöt'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","E Herodes 'ñe c'o o̱ tropa, me mi mbãxtjoji e Jesús mi cjapüji menu. Cjanu o jyecheji c'ua 'na bitu c'ü me mi muvi, c'ü mi nza cja c'o je'e o rey. Nuc'ua cjanu o manda o zidyiji na yeje cja e Pilato. ");
INSERT INTO mazNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","E Pilato 'ñe e Herodes ot'ü mi üvi. Pero c'e pa c'ü, o jovi. ");
INSERT INTO mazNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nuc'ua e Pilato o zojnü texe c'o ndamböcjimi 'ñe c'o 'ñaja c'o mi pjëzhi na nojo 'ñe c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","O xipjiji: ―Nu'tsc'eji i̱ sinquigöji ne bëzo nu, i̱ xitsiji c'ü onpü yo nte ngue c'ua ga ne ra tsjaji revolución. Pero dyäräji na jo c'ü rá xi'tsc'öji. Ró önügö na jo ne bëzo; i̱ dyäräji i̱ṉ texeji. Dya pje ró tö'tp'ügö c'o i̱ṉ mangueji. ");
INSERT INTO mazNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni xo ri ngue e Herodes, dya pje xo chö'tp'ü nu. Nguec'ua va manda i̱ sigueji na yeje a 'ñeva. Dyäräji na jo. Dya pje tsja c'o na s'o ne bëzo, c'o rga pö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pero ante c'ü rá eme libre, rá manda ra jyüt'üji o chirrio, eñe e Pilato. ");
INSERT INTO mazNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tsjë'ma mi cjaji c'e mbaxua c'ü mi chjũ Pascua, y tsjë'ma mi cja c'o nte mi ötüji e Pilato ro 'ñeme libre 'na bëzo c'ü ma o'o a pjörü. Nuc'ua e Pilato mi eme c'ua libre c'e nte. ");
INSERT INTO mazNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","C'o ndamböcjimi 'ñe c'o nte, dya neji c'ü ro 'ñemeji libre e Jesús. Nguec'ua va mapjüji texeji o mamaji: ―Pö't'ü ne bëzo. Rí negöjme rí 'ñeme libre e Barrabás, eñe c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","E Barrabás vi pant'aji a pjörü na ngue vi pjütü 'na chũ a Jerusalén, vi chũji c'e gobierno, y mi pö't'ü o nte. ");
INSERT INTO mazNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","E Pilato ndo zopjütjo na yeje c'o nte, na ngue mi ne ro 'ñeme libre e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero anguezeji o mapjüji c'ua na jens'e o mamaji: ―Chät'äji cja ngronsi, chät'äji cja ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nuc'ua c'ü na jñi, o mama c'ua e Pilato o xipjiji: ―¿Pje ni mbë c'ü o tsja c'ü na s'o? Dya pje rí tö'tp'ügö c'o na s'o c'ü rga pö't'üji. Pero ante c'ü rá eme libre, rá manda ra jyüt'üji o chirrio, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero c'o ndamböcjimi 'ñe c'o nte sido mi mapjüji na jens'e, sido mi mamaji c'ü mi jyodü ro ndät'äji e Jesús cja ngronsi. O ndõji na ngue sido mi mapjüji. ");
INSERT INTO mazNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nguec'ua e Pilato o mama c'ü ro tsja ja c'o nzi ma dyörü anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","O 'ñeme c'ua libre c'e bëzo ja c'o nzi ma dyörüji; maco vi tsja c'o na s'o. C'ü vi pant'aji a pjörü, ngue c'ü vi pjütü 'na chũ 'ñe mi pö't'ü o nte. E Pilato xo manda c'ü ro ndät'äji e Jesús ja c'o nzi ma neji. ");
INSERT INTO mazNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","'Ma ya mi sidyiji e Jesús ro ma ndät'äji cja ngronsi, o pënch'iji 'na bëzo c'ü mi menzumü a Cirene c'ü vi 'ñeje cja juajma. Nuc'ü, mi chjũ Simón c'ü. O tsjapüji e Simón ro nduns'ü c'e ngronsi ro bëpja cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mi bëpja ma möji na puncjü o nte. Na puncjü c'o ndixũ me mi ndumüji ma huëpiji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","E Jesús o jñanda c'o ndixũ o xipjiji: ―Nu'tsc'eji ndixũ i̱ṉ menzumüji a Jerusalén, dyäräji c'ü rá xi'tsc'öji. Dya rí huëji por nutscö; huëtsjëgueji 'ñe rí huëpiji in ch'igueji. ");
INSERT INTO mazNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Na ngue ra zädä c'o pa 'ma me rí sufregueji. Nguec'ua ra mamaji: “Xenda rvá jo 'ma dya ro muxt'i yo ndixũ 'ñe 'ma dya ro ndunteji 'ñe 'ma dya ro jötüji o lëlë”, ra 'ñeñeji. Na ngue ra sufreji na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nuc'ua ra mama c'o nte: “Quera ro yëbi yo t'eje 'ñe yo ts'it'eje ro ndivguiji. Xe na jo que na ngue c'ü rá sufregöji yo na s'ëzhi”, ra 'ñeñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nutscö, zö dya pje ró cjagö, pero rá sufregö na puncjü. Nadya yo menzumü va yo tuns'ü na puncjü o̱ nzhubü, ¿pje ra tsjapüji yo?, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","'Ma mü o zidyiji e Jesús, xo mi sidyiji yeje bëzo c'o xo ro ndät'äji cja ngronsi. Nuc'o, vi tsja na s'o c'o. ");
INSERT INTO mazNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nuc'ua 'ma mü o zät'äji nu ja mi chjũ T'ejeñinte, o ndät'äji cja ngronsi nu, e Jesús 'ñe c'o vi tsja na s'o. 'Naja c'ü o ndät'äji cja ngronsi cja a lado o̱ jodyë e Jesús; 'naja c'ü o ndät'äji c'ü 'nanguarü. ");
INSERT INTO mazNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","O mama c'ua e Jesús: ―Mi Tatats'ü i̱ṉ bübü a jens'e, rí ö'tc'ü rí perdonaogue yo. Na ngue dya pãrãji c'ü cjacü yo, eñe. Nuc'ua c'o tropa o eñeji cjó ngue c'ü ro tsjapü o̱ cjaja c'o o̱ bitu e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","C'o nte mi böbü mi jandaji e Jesús. Anguezeji 'ñe c'o pje mi pjëzhi, me mi cjapüji burla e Jesús mi mamaji: ―Maco mamaji o mbös'ü na puncjü o nte nu, maco dya sö ra 'ñemetsjë ra dagü cja ne ngronsi. Maco mi mama ngueje nu o juajnü Mizhocjimi ra manda, maco dya dagü dya cja ne ngronsi, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","C'o tropa xo mi cjapüji burla e Jesús. Mi chëzhiji cja o̱ jmi e Jesús, mi unüji ro zi o vino c'o dya nda ma jo. ");
INSERT INTO mazNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mi xipjiji: ―Nu 'ma ngue'tsc'e o̱ rey yo menzumü a Israel, ts'ügütsjë dya, dyagü cja ne ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A xes'e cja o̱ ñi c'e ngronsi, mi cuat'ü 'na xiscõmü c'ü mi t'opjü o letra c'e jña griego, 'ñe o latín 'ñe hebreo. Mi t'opjü a cjava: “Nujnu, o̱ Rey yo menzumü a Israel nu.” ");
INSERT INTO mazNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nuc'ua 'naja c'o vi tsja na s'o c'ü xo mi dät'ä nu, o zadü e Jesús o xipji: ―Nu 'ma ngue'tsc'e e Cristo, 'ñemetsjë dya, dyagü cja ne ngronsi. Xo rí 'ñevguegöbe libre. ");
INSERT INTO mazNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","O ndünrü c'ua c'ü 'naja c'ü mi dät'ä nu, o huënch'i o xipji: ―Nu'tsc'e, dya i̱ṉ sũgue Mizhocjimi. ¿Jenga i̱ṉ sadügue ne bëzo? Nujnu, xo na sufre yo rrã sufregövi. ");
INSERT INTO mazNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nutscövi, rí merecidovi rá sufregövi yo, na ngue ró cjavi c'o me na s'o. Pero ne bëzo, dya pje tsja nu. ");
INSERT INTO mazNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","O sido o ña c'ua c'e bëzo o xipji e Jesús: ―Nu'tsc'e ín Jmuts'ügö, rí ö'tc'ü c'ü rí mbenzegö 'ma rí nzhogue na ye rí ẽ mandague, eñe. ");
INSERT INTO mazNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","O ndünrü c'ua e Jesús o xipji: ―Dyärä na jo c'ü rá xi'tsc'ö. Ne pa dya, rí bübügue co nutscö a jens'e nu ja me na zö. ");
INSERT INTO mazNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nuc'ua 'ma mü o zünü jñisiarü, o bëxõmü c'ua texe cja ne xoñijõmü hasta 'ma mü o zünü jñi c'ü nzhä. ");
INSERT INTO mazNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","O bëxõmü e jyarü. Y o chödü a nde c'e manta c'ü mi cjot'ü a mbo cja c'e templo nu ja me ma sjũ. ");
INSERT INTO mazNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nuc'ua e Jesús o mapjü na jens'e o mama: ―Nu'tsc'e mi Tatats'ügö, sinngui dya ín aljma. Nuc'ua 'ma mü o nguarü o mama c'o, cjanu o ndũ c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nuc'ua c'ü mi manda c'o tropa, 'ma mü o jñanda c'o me na nojo, o ma't'ü Mizhocjimi o mama: ―Ne bëzo, na cjuana c'ü dya tsja c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na puncjü o nte c'o vi ma jñanda pje ro tsjapüji e Jesús. 'Ma mü o jñandaji ja va ndũ, o nzhogüji mi ya'büji o tijmiji. Na ngue me mi sũji 'na pje ro zädä. ");
INSERT INTO mazNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","C'o mi dyoji e Jesús, ma böbütjoji na jẽ, xo jñandaji. Xo 'ñe c'o ndixũ c'o mi pöji e Jesús ndeze 'ma mü o mbürü o xöpü c'o nte a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mi bübü 'na bëzo c'ü mi chjũ José. Mi menzumü a Arimatea c'ü mi tsja cja c'e estado de Israel. Ma jonte c'e bëzo, y mi cja ja c'o nzi ga ne Mizhocjimi. Mi ngue 'na c'o mi pjëzhi na nojo c'o mi jün ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Pero dya go ne c'o vi tsja c'o 'ñaja, 'ma mü o mamaji mi jyodü ro mbö't'üji e Jesús. Mi te'be c'ü ro ẽ manda nu c'ü vi 'ñeme Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nuc'ü, o ma c'ua cja e Pilato o ma dyötü c'ü o̱ cuerpo e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cjanu o ma ts'üpcü c'ü o̱ cuerpo cja c'e ngronsi. Cjanu o mböch'ü 'na bitu. Cjanu o ma ngöt'ü cja 'na cueva c'ü vi dyö't'üji cja peña, c'ü dya cjó be mi cöt'üji. ");
INSERT INTO mazNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nu c'e pa c'ü, ngue 'ma mi preparao c'o menzumü a Israel, na ngue c'ü na jyas'ü mi ngue c'e pa 'ma söyaji. Ya mi ngue ro nguibi e jyarü, ya mi ngue ro mbürü c'e xabaro. ");
INSERT INTO mazNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","C'o ndixũ c'o mi pöji e Jesús ndeze 'ma mü o mbürü o xöpü c'o nte a Galilea, xo möji e José. O ma nuji c'e cueva ja ngöt'üji o̱ cuerpo e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cjanu o nzhogüji a Jerusalén, o dyät'äji o perfume 'ñe o ungüento, ngue c'ua ro ma ngosp'üji o̱ cuerpo e Jesús. Nuc'ua c'ü na ye nu pa, 'ma mi söya yo menzumü a Israel, o söya c'ua c'o ndixũ ja c'o nzi ma mama cja c'o o̱ mandamiento Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nuc'ua c'ü ot'ü pa nu ngo'o 'ma ya ma jya's'ü, o ma c'o ndixũ cja c'e cueva, o ndunüji c'o perfume c'o vi dyät'äji. Xo möji c'o 'ñaja ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","'Ma mü o zät'äji cja c'e cueva, o chöt'üji ya vi chjen'chp'eji c'e tralaja c'ü mi c'ot'ü c'e cueva. ");
INSERT INTO mazNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pero 'ma mü o cjogüji a mbo, dya chöt'üji c'ü o̱ cuerpo e Jesús c'ín Jmugöji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Go zũji c'ua, dya mi pãrã pje ro tsjaji. 'Nango jñetse c'ua yeje anxe c'o mi 'ñetse nza cja o bëzo, mi böbüvi o̱ jmiji, me mi juëns'i o̱ bituvi. ");
INSERT INTO mazNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Me go pizhi c'ua c'o ndixũ o ñücüji a jõmü. O mama c'ua c'o anxe o xipjiji: ―¿Jenga i̱ṉ jodüji a nde cja yo añima nu c'ü bübütjo? ");
INSERT INTO mazNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Dya bübü va c'ü; ya tetjo. Mbeñeji na jo c'o o xi'tsc'eji e Jesús 'ma mi bübü a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","O xi'tsc'eji c'ü vi 'ñeje cja Mizhocjimi pero mi jyodü ro nzhöji angueze cja c'o nte c'o cja na s'o, ro ndät'äji cja ngronsi. Nuc'ua c'ü na jñi nu pa, ro tetjo ro bübütjo na yeje, eñe c'o anxe va xipjivi c'o ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","O mbeñe c'ua c'o ndixũ c'o vi mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Cjanu o mbedyeji nu, o möji c'ua nu ja mi cãrã c'o once apóstole 'ñe c'o 'ñaja, o ma xipjiji c'o vi mama c'o anxe. ");
INSERT INTO mazNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","C'o o ma xipji c'o apóstole, mi ngueje e María Magdalena 'ñeje e Juana 'ñe e María c'ü nu nana e Jacobo. Xo mi ngue c'o 'ñaja ndixũ c'o mi dyoji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","C'o apóstole o nguijñiji c'ü mi jyo c'o ndixũ. Nguec'ua dya go creoji c'o o xipjiji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero e Pedro ixco cjuan'di go ma cja c'e cueva. 'Ma mü o zät'ä nu, o dänä o jñanda a mbo. C'ü o jñanda, nguextjo c'e manta c'ü vi mböch'üji o̱ cuerpo e Jesús. Cjanu o ma c'ua, me mi cjijñi pje mi ne ro mama c'o vi jñanda. ");
INSERT INTO mazNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","C'e pa c'ü, yeje anguezeji mi mëvi cja 'na ts'ijñiñi c'ü ni chjũ Emaús. C'e jñiñi mi jyadüvi once kilómetro a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","'Ma mi pëvi, mi pötma mamavi ja va ndät'äji e Jesús cja ngronsi 'ñe ja va ngöt'üji cja cueva. Xo mi mamavi ja ga cja c'o vi mama c'o ndixũ c'ü vi te e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","'Ma mi ñavi 'ñe mi pötma dyönüvi, nuc'ua e Jesús o chëzhi ts'ë c'ua, cjanu o möji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Anguezevi o jñandavi e Jesús, pero dya mbãrãvi c'ü mi ngue e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","O mama c'ua e Jesús o xipjivi: ―¿Pje ni mbë c'o pötqui mamavi gui mëvi, nguec'ua me i̱ṉ ndumüvi?, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","'Naja c'o bëzo mi chjũ e Cleofas. O ndünrü c'ua o xipji e Jesús: ―¿Cjo dya i̱ṉ bübügue va a Jerusalén? Maco texe yo nte pãrãji c'o o zädä va yo pa yo. ");
INSERT INTO mazNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","O ndünrü c'ua e Jesús o dyönüvi: ―¿Pje ni mbë c'o o zädä? O ndünrüvi c'ua o xipjivi: ―Ngueje c'o o tsjapüji e Jesús c'ü mi menzumü a Nazaret. Mizhocjimi o 'ñeme ro zopjü yo nte. Mi cja ja c'o nzi ma ne Mizhocjimi; mi ña na jo o̱ jña Mizhocjimi y mi cja c'o me na nojo. Nguec'ua yo nte me mi näntji c'ü, me mi mamaji c'ü me ma jo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","C'o ndamböcjimi 'ñe c'o 'ñaja ín menzumüji c'o pjëzhi na nojo, o zidyiji e Jesús nu ja jñünpüji ngüenda. Y o mbö't'üji cja ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nutscöjme mi dyocjöjme e Jesús, mi pëzhgöjme mi ngue angueze c'ü vi 'ñeme Mizhocjimi ro salvazüji nutscöji rí menzumüji a Israel, ro 'ñevgueji libre cja c'o nugüji na ü. Pero ya pa jñi pa ndeze 'ma mü o ndũ. ");
INSERT INTO mazNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Mi xõrü, ts'i vi mbedye ja nzi ndixũ c'o ín dyocjöjme o möji cja c'e cueva nu ja ngöt'üji e Jesús. Dya chöt'üji c'ü o̱ cuerpo pero 'ma mü o nzhogüji, o xitsijme c'ü o jñetse yeje anxe c'o o xipjiji c'ü ya te e Jesús ya bübütjo na yeje. Nguec'ua ró sũgöjme ró mamajme: “Xa'ma ya te e Jesús. Pero, ¿pãrã cjo na cjuana?”, ró mamajme a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nguec'ua bübü ja nzi c'o ín dyocjöjme c'o o ma cja c'e cueva o ma nuji. O chöt'üji ja c'o nzi va mama c'o ndixũ, dya cja mi o'o e Jesús a mbo cja c'e cueva. Pero dya jñandaji c'ü. Nguec'ua, ¿pãrã cjo ya tetjo? ");
INSERT INTO mazNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","O ndünrü c'ua e Jesús o xipjivi: ―Nu'tsc'evi, dya i̱ṉ pãrãvi na jo c'o o dyopjü c'o profeta. Dya i̱ jyëzi ro zi'ch'i in mü'büvi c'o jña. Nguec'ua dya i̱ṉ creovi texe c'o o dyopjüji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mi jyodü e Cristo me ro sufre rvá ndũ, cja rrũ ma c'ua a jens'e nu ja ra manda, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nuc'ua e Jesús o xipjivi pje mi ne ro mama c'o o̱ jña Mizhocjimi c'o vi dyopjü e Moisés 'ñe c'o vi dyopjü texe c'o profeta. Nde vi dyopjüji ja rvá cja e Cristo. ");
INSERT INTO mazNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ya mi ngue ro zät'äji cja c'e ts'ijñiñi nu ja mi möji. E Jesús mi cjapü c'ü ro cjogütjo xe ro ma c'ü 'na jñiñi. ");
INSERT INTO mazNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nuc'ua anguezevi o züjmüvi c'ua o xipjivi: ―Oxque co nutscöbe na ngue ya nzhä, dya ra mezhe ra xõmü, eñevi. Nguec'ua o cjogüji a mbo cja c'e ngumü ro oxüji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nuc'ua 'ma ya ma jũji cja mexa, e Jesús o jñü c'ua 'na tjõmëch'i, cjanu o unü 'na pöjö Mizhocjimi, cjanu o xënbivi c'ua. ");
INSERT INTO mazNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nuc'ua ixco xogü o̱ ndövi, cja mbãrãvi c'ua c'ü mi ngue e Jesús c'ü mi ñaji. Nuc'ua 'nangua ojtjo c'ua e Jesús; dya cja jñandavi. ");
INSERT INTO mazNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nuc'ua o pötü va mamavi: ―'Ma ró ñaji e Jesús cja 'ñiji, 'ma o xitsivi pje ne ra mama c'o o̱ jña Mizhocjimi, me go zi'ch'i ín mü'büvi y me ró mäcjövi, eñevi. ");
INSERT INTO mazNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ixco nzhogüvi o mëvi c'ua a Jerusalén. 'Ma mü o zät'ävi, o chöt'üvi ya vi jmurü c'o once apóstole 'ñe c'o mi dyoji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","O mama c'ua anguezeji o xipjiji c'o yeje c'o cja vi säjä: ―Ya tetjo c'ü ín Jmugöji. E Pedro o jñanda c'ü bübütjo c'ü, embeji c'o yeje. ");
INSERT INTO mazNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Anguezevi o mamavi c'ua c'ü vi chjëji e Jesús cja 'ñiji pero dya mi pãrãvi cjo mi ngue c'ü. Cja mbãrãvi 'ma mü o xënbivi c'e tjõmëch'i cjanu o unüvi. ");
INSERT INTO mazNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","'Ma mi mamaji c'o, jo ni 'ñetse c'ua e Jesús a nde anguezeji o zenguaji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nuc'ua anguezeji me go zũji. Mi pëzhiji mi ngue 'na espíritu c'ü mi 'ñetse nza cja 'na nte. ");
INSERT INTO mazNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nuc'ua e Jesús o mama c'ua: ―Dya rí sũji; dya rí tsjijñiji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jñandgaji c'ü nguetscö e Jesús. Chjönngüji ngue c'ua rí pãrãgueji c'ü dya nguezgö 'na espíritu. Na ngue bübü ín ts'ingue 'ñe ín nzho'dyë. ");
INSERT INTO mazNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","'Ma mü o mama a cjanu, cjanu o jíchiji o̱ dyë 'ñe o̱ ngua. ");
INSERT INTO mazNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Anguezeji me co mäji c'ua na puncjü. Pero o nguijñiji: “Pãrã, ¿cjo na cjuana yo rí jandagöji 'ñe yo rí äräji”, eñeji. Nguec'ua dya nda mi creoji cjo vi te e Jesús. O mama c'ua e Jesús: ―¿Cjo bübü pje rá sigö? ");
INSERT INTO mazNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nuc'ua o unüji 'na përaso o jmõ c'ü vi jñaxaji, cja na 'ñe 'na përaso o panal c'ü mi po'o o miel. ");
INSERT INTO mazNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","O jñü c'ua e Jesús c'e jmõ 'ñe c'e panal, cjanu o zi c'ua; anguezeji o jñandaji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","O mama c'ua e Jesús o xipjiji: ―'Ma ot'ü mi bübügö co nu'tsc'eji, ró xi'tsc'öji c'ü mi jyodü ro zädä c'o t'opjü cja c'o ley c'o o dyopjü e Moisés, 'ñe c'o o dyopjü c'o profeta, 'ñe c'o t'opjü cja yo salmo. C'o ró xi'tsc'öji, ngueje yo ya zädä. ");
INSERT INTO mazNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nuc'ua e Jesús o zopjüji, nguec'ua va mbãrãji pje mi ne ro mama c'o mi t'opjü cja o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Cjanu o xipjiji: ―C'ua ja nzi ga t'opjü o̱ jña Mizhocjimi, mi jyodü ro tũgö nuzgö e Cristo, cja rrũ tetcjö c'ü na jñi nu pa. ");
INSERT INTO mazNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Xo ni jyodü ra zopjüji yo nte ra xipjiji ra 'ñench'ezüji o̱ mü'büji ra jyëziji c'o na s'o. A cjanu ra perdonaoji c'o na s'o c'o vi tsjaji. Ot'ü ra zopjüji yo cãrã a Jerusalén, cja rrũ ma zopjüji yo cãrã texe cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ngue'tsc'eji i̱ jñandgueji yo o zädä, ngue'tsc'eji rí zopjüji yo nte. ");
INSERT INTO mazNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Rá täjä o̱ Espíritu Mizhocjimi ra ẽjẽ ra ẽ bübü cja in mü'büji ja c'o nzi va mama Mizhocjimi. Rí che'beji va a Jerusalén hasta 'ma cja ra ẽjẽ a jens'e, ra 'ñe dya'c'üji o̱ poder ja rgui zopjüji yo nte. ");
INSERT INTO mazNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","'Na nu pa, e Jesús o möji c'o apóstole o zät'äji c'ü 'nanguarü a Betania. Nuc'ua e Jesús o c'uã's'ã c'ua o̱ dyë o dyötpü Mizhocjimi c'o o̱ apóstole. ");
INSERT INTO mazNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","'Ma mi ötpüji Mizhocjimi, ixco ma c'ua e Jesús go zidyi Mizhocjimi a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Anguezeji o ndüñijõmüji o ma't'üji c'ua e Jesús. Cjanu o nzhogüji a Jerusalén, me mi mäji. ");
INSERT INTO mazNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Sido mi pöji cja c'e templo mi unüji 'na pöjö Mizhocjimi. Je va cjanu, amén.");
INSERT INTO mazNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mi jinguã 'ma dya be mi ät'ä Mizhocjimi e jens'e 'ñe ne xoñijõmü, ya exmi bübü e Jña'a. E Jña'a ngueje o̱ T'i Mizhocjimi. E Jña'a mi bübüvi Mizhocjimi. Ngueje Mizhocjimi nu e Jña'a. ");
INSERT INTO mazNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nunu, ya exmi bübüvi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Texe yo bübü ngueje e Jña'a o dyät'ä. ");
INSERT INTO mazNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ngue angueze c'ü dacüji c'ü rí bübüji. Ngueje angueze c'e jya's'ü ngue c'ua ra sö rá pãrãji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","C'e Jña je jya's'ü cja e bëxõmü. E bëxõmü, dya sö'ö ra ts'a's'ü e jya's'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mi bübü 'naja bëzo c'ü mi chjũ Juan. Mizhocjimi o juajnü c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","O xipji c'o nte ja ma cja c'e jya's'ü, ngue c'ua ro 'ñench'e o̱ mü'büji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","E Juan dya mi ngueje c'e jya's'ü. C'ü vi juajnü Mizhocjimi c'ü, ngue c'ü ro xipji c'o nte ja ma cja c'e jya's'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","E Jña'a c'ü ngue c'e jya's'ü c'ü na cjuana, ya mi ngue ro mbürü ro pëpji va. Nuc'ü, ngue c'e jya's'ü, ngue c'ua yo nte sö ra mbãrã Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mi bübü cja ne xoñijõmü. Ngueje angueze o dyät'ä ne xoñijõmü. Pero c'o mi cãrã cja ne xoñijõmü, dya o tsjapüji ngüenda que ngueje c'e jya's'ü c'ü na cjuana. ");
INSERT INTO mazNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nuc'ua o mimi cja ne xoñijõmü; o jmus'ü cja c'o menzumü a Israel. Pero anguezeji dya go säjäji, zö mi ngue o̱ menzumüji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero texe c'o o säjä, 'ñe o 'ñench'e o̱ mü'büji; nuc'o, o unüji c'ü nguejeji o̱ t'i Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","C'ü ni tsjacöji o̱ t'izgöji Mizhocjimi, dya ngue c'ü vi muxcüji c'o ín tataji; ngue c'ü je ga ne a cjanu Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","C'e Jña'a c'ü ngue e Jesucristo, o ẽ jmus'ü cja ne xoñijõmü nza cjazgöji rí nteji. O mimi a nde nu ja rí cãrãjme. Ró nugöjme c'ü me na zö angueze. Me na zö na ngueje nguetjo c'ü 'natjo o̱ T'i Mizhocjimi. Nuc'ü, ró unnc'öjme ngüenda c'ü me s'iyazügöji, y na cjuana c'o o mama. ");
INSERT INTO mazNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","E Juan o mama c'o ma cjuana ja ga cja e Jesucristo. O mama na zëzhi: ―Nunu ngueje nu mi xi'ts'igöji nu 'ma ró xi'ts'iji: “Nu c'ü va bëpjazügö ra ot'ü, na ngueje ya exmi bübü 'ma dya be rmí bübügö.” ");
INSERT INTO mazNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","E Jesucristo me s'iyazüji; dacüji texe c'o ni jyodü ín mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mi jinguã e Moisés o unü c'ü o̱ ley Mizhocjimi c'o ín mboxatitagöji. Nudya, ya ẽjẽ e Jesucristo. Nguec'ua rgá pãrãgöji me s'iyazüji Mizhocjimi, y na cjuana c'o ya mama. ");
INSERT INTO mazNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dya cjó janda Mizhocjimi. Pero c'ü 'natjo o̱ T'i Mizhocjimi o jítscöji ja ga cja Mizhocjimi. Angueze pãtpã o̱ mü'bü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","'Na nu pa'a, c'o mi menzumü a Jerusalén o ndäjäji c'o ro ma tsjapü t'önü e Juan. O ndäjäji o mböcjimi 'ñe o Levita o zät'äji cja e Juan, o dyönüji: ―¿Cjó ngue'tsc'e? ");
INSERT INTO mazNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","E Juan exo xipjiji c'ü na cjuana. O mama: ―Nuzgö, dya nguetscö e Cristo. ");
INSERT INTO mazNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","O dyönüji c'ua: ―¿Cjó ngue'tsc'e 'ma? ¿Cjo ngue'tsc'e Elías? O mama: ―Nuzgö, dya nguetscö. Xo o dyönüji: ―¿Cjo ngue'tsc'e c'e profeta c'ü rí te'bejme ra ẽjẽ?, eñeji. O ndünrü e Juan, o mama: ―Jiyö. Dya nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","O xipjiji c'ua: ―Xitscöjme cjó ngue'tsc'e, ngue c'ua rá xipjijme nu c'o o ndäcjäjme. ¿Pje i̱ṉ mamague dya, cjó ngue'tsc'e? ");
INSERT INTO mazNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","O mama c'ua e Juan: ―I̱ṉ pãrãgueji ja va mama c'e profeta Isaías. O mama c'ü ro bübü cja ndajyadü 'na nte c'ü ri mapjü ri xipji yo nte: “Jyëziji c'o 'ñiji c'o na s'o, na ngueje ya ra ẽjẽ c'ín Jmugöji”, ro 'ñeñe. Nguetscö c'e nte c'ü o mama c'e profeta, eñe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ngue c'o fariseo c'o vi ndäjä o mböcjimi 'ñe o Levita cja e Juan. ");
INSERT INTO mazNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","O dyönüji: ―¿Jenga i̱ṉ jichigue co ndeje yo nte 'ma dya ngue'tsc'e e Cristo, 'ma dya xo ngue'tsc'e e Elías, ne ri ngue'tsc'e c'e profeta?, mi eñeji. ");
INSERT INTO mazNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","O ndünrü c'ua e Juan, o mama: ―Nutscö rí jichi yo nte cja ndeje. Bübü a nde nu va i̱ṉ cãrãgueji 'naja nu c'ü dya i̱ṉ pãrãgueji; ");
INSERT INTO mazNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ngueje nu va bëpjazügö. Nutscö dya pje pjëtscö. Nuc'ü, me pjëzhi na nojo. ");
INSERT INTO mazNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nuyo, je o zädä a Betábara, 'naja jñiñi cja c'ü 'nanguarü c'e ndare c'ü ni chjũ Jordán, nu ja je mi jichi yo nte, e Juan. ");
INSERT INTO mazNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","C'ü na yejnu pa'a o jñanda e Juan, ma ẽjẽ e Jesús nu ja mi bübü angueze. O mama c'ua e Juan: ―Jñandaji dya. Va ẽjẽ nu c'ü o 'ñeme Mizhocjimi ra ndunbü o̱ nzhubü yo cãrã cja ne xoñijõmü. Ngueje o̱ Ts'imë Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ngueje nu ró xi'ts'iji nu, va bëpjazügö 'naja bëzo c'ü ra zopjü yo nte. Ya exmi bübü, 'ma dya be rmí bübügö. Ngueje nu xenda pjëzhi que na nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nuzgö dya mi pãrãgö c'ü pje pjëzhi nu. Rvá ẽjẽgö rvá jichite cja ndeje ngue c'ua yo menzumü a Israel ra mbãrãji angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","O sido o ñatjo e Juan, o mama: ―Ró janda o̱ Espíritu Mizhocjimi c'ü ma sjöbü a jens'e nza cja 'na mbaro. Je o ẽ söya a xes'e angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nuzgö, dya mi pãrãgö c'ü pje pjëzhi nu. Pero Mizhocjimi, nu c'ü o juancö ró ẽ jichi cja ndeje yo nte, ya vi xitsi: “Nu c'ü rí jñanda ra zät'ä ín Espíritugö c'ü ra söya a xes'e angueze ngueje c'ü ra ndäjä o̱ Espíritu Mizhocjimi ra bübü cja o̱ mü'büji.” ");
INSERT INTO mazNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ró jandagö o ẽjẽ o̱ Espíritu Mizhocjimi co nu e Jesús, nguec'ua rí xi'ts'iji na cjuana, exi ngueje nu o̱ T'i Mizhocjimi nu. ");
INSERT INTO mazNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","C'ü na yejnu pa'a mi bübütjo nu, e Juan co yeje c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","O jñanda e Juan mi cjogü e Jesús. O mama c'ua: ―Pa nu, o̱ Ts'imë Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","O dyärä c'ua yeje c'o o̱ discípulo e Juan. Ya ndünt'üvi c'ua a xütjü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","O ñezhe c'ua e Jesús. O jñanda mi tjünt'üvi a xütjü. O xipjivi: ―¿Pje i̱ṉ jodüvi? Anguezevi o mamavi: ―Xöpüte, ¿ja je ngue c'ua i̱ṉ bübü?, o 'ñembevi. ");
INSERT INTO mazNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","O mama c'ua e Jesús: ―Xä'dävi ngue c'ua rí jñandavi ja je rí bübü. Ya o möji c'ua. Ya o jñandavi nu ja je mi bübü. C'e pa'a c'ü, o nguejmetjoji nu e Jesús, na ngueje ya mi zünü dyëch'a c'ü xõrü. ");
INSERT INTO mazNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","E Andrés, c'ü nu cjuarma e Simón Pedro mi ngueje 'naja c'o yeje c'o vi dyärä nu c'o o mama e Juan, cja nu o ndünt'üvi a xütjü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","E Andrés o chöt'ü e Simón c'ü nu cjuarma. O xipji: ―Ya ró chjëgöjme nu c'ü o ndäjä Mizhocjimi, eñe. Nuc'ü, ngue c'ü xiji Mesías. ");
INSERT INTO mazNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nuc'ua e Andrés o zidyi e Simón o mëvi c'ua ja mi bübü e Jesús. E Jesús o jñanda c'ua. O xipji: ―Ngue'tsc'e e Simón, nu t'its'ü e Jonás. Rguí chjũtsc'e e Cefas, eñe. Ne jña Cefas ne ra mama Pedro. ");
INSERT INTO mazNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","C'ü na yejnu pa'a o ne c'ua e Jesús o ma a Galilea. O chjëvi e Felipe. O xipji: ―Chjünt'ü ín xütjü. O mëvi c'ua. ");
INSERT INTO mazNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","E Felipe mi menzumü a Betsaida, nu ja mi menzumü e Andrés 'ñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","E Felipe o ma xipji e Natanael: ―E Moisés o dyopjü cja o̱ ley Mizhocjimi c'ü ra ẽjẽ Mesías. Je xo va dyopjü c'o profeta. Ya ró chjëjme dya c'ü. Ngueje e Jesús c'ü menzumü a Nazaret, c'ü o̱ t'i e José. ");
INSERT INTO mazNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","E Natanael o xipji e Felipe: ―¿Cjo sö ra bübü a Nazaret c'ü na jo? O ndünrü c'ua e Felipe: ―Xä'dä rí ñu'u. ");
INSERT INTO mazNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","E Jesús o jñanda ma ẽjẽ e Natanael. O mama c'ua: ―Va ẽ c'ua 'naja yo menzumü a Israel nu na cjuana. Nunu, dya onpüte nu. ");
INSERT INTO mazNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","E Natanael o xipji e Jesús: ―¿Ja cja dya, c'ü ya i̱ṉ pãcãgö? O ndünrü c'ua e Jesús. O xipji: ―'Ma dya be mi zon'c'ü e Felipe, nu 'ma mi bübügue cja ngua c'e higo, ró jantc'a 'ma, y rí pã'tc'ã in mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","O ndünrü e Natanael, o xipji: ―Xöpüte, exi ngue'tsc'e o̱ T'its'ü Mizhocjimi. Nu'tsc'e, ngue'tsc'e i̱ 'ñe ngue c'ua rí mandazüji rí menzumüji a Israel. ");
INSERT INTO mazNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","O ndünrü e Jesús, o xipji: ―I̱ṉ ejmezü dya, na ngueje mi pã'tc'ã in mü'bü 'ma mi bünc'e cja ngua c'e higo. Pero xenda na nojo c'o rí jñanda. ");
INSERT INTO mazNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","’Na cjuana rí xi'ts'iji, rí jñandaji ra xogü a jens'e; 'ñe rí jñandaji c'o anxe Mizhocjimi ra möji a jens'e, ra nzhogüji nu ja rá bünc'ö, nutscö rvá ẽcjö cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","C'ü na jñi nu pa'a o tsjaji 'naja chjüntü a Caná c'ü tsja a Galilea. Je o ma nu c'ü nu mamá e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Xo o zojnüji cja c'e chjüntü e Jesús co c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","O tjezetjo c'ua c'e vino. C'ü nu mamá e Jesús o xipji: ―Ya ndezeji o̱ vinoji. ");
INSERT INTO mazNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","E Jesús o xipji c'ua: ―¿Jenga i̱ṉ xitsigö a cjanu? Dya be sädä c'e hora 'ma ra 'mãrã cjó nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","C'ü nu mamá e Jesús o xipji c'o mi pjöxte: ―Rí tsjaji texe c'ü ra xi'ts'iji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mi järä nu, 'ñanto tras'äbä c'o mi ngueje ndojo c'o mi xich'iji ndeje. Nu c'e ndeje c'o mi po'o nu, mi ngue para ro xindyë c'o mi menzumü a Israel, c'ua nzi va manda o̱ ley anguesji. C'o tras'äbä mi süjü ochenta o 'na ciento litro nzi 'naja. ");
INSERT INTO mazNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","E Jesús o xipji c'o mi pjöxte: ―Nu'ts'c'eji, nichiji ndeje yo tras'äbä. Cjanu o nichiji c'ua. Nde o jaxcüji na jo c'o tras'äbä. ");
INSERT INTO mazNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","E Jesús o xipjiji c'ua: ―Dyö'büji dya, chunbüji c'ü manda cja ne chjüntü. Cjanu o ndunüji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","C'ü mi manda, o zö'ö ts'iquë c'ü e ndeje c'ü vi mbëzhi vino. Dya mi pãrã ja je vi tũji. Pero c'o mböxte mi pãrãji na ngueje vi dyö'büji c'e ndeje. O tsja c'ua c'ü mi manda, o ma't'ü c'ua c'ü e t'i'i c'ü cja vi chjüntü. ");
INSERT INTO mazNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Cjanu o xipji c'ua: ―'Ma cjaji chjüntü, ot'ü xisp'iji vino c'ü na jo'o. Nuc'ua 'ma ya ra nijmiji, cja rrõ xisp'iji c'ü dya nda jo. Nu'tsc'e mi pë's'itjo c'ü xenda na jo vino. Cja na unügue dya. ");
INSERT INTO mazNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nujyo, o tsja'a e Jesús a Caná c'ü tsja a Galilea. Nguejyo o mbürü o jizhi c'ü dya nunca mi janda c'o nte. A cjanu o mbãrãji c'ü me na nojo angueze. C'o o̱ discípulo o 'ñejmeji c'ua angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nu 'ma o nguarü yo, o zöbüji a ma a Capernaum e Jesús 'ñe c'ü nu mamá 'ñe c'o o̱ cjuarma 'ñe c'o o̱ discípulo. Nunu, o mimiji ja nzitjo pa'a. Dya o mezheji. ");
INSERT INTO mazNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ya mi ngue ro zädä c'e mbaxua c'ü ni chjũ Pascua c'ü cja yo menzumü a Israel. Nuc'ua o ma a ma a Jerusalén e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","O chöt'ü c'o mi pö o nzhünü 'ñe o ndënchjürü 'ñe o mbaro cja c'e templo. C'o mi pötü o merio xo nde mi junrü nu c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","E Jesús o dyät'ä c'ua 'naja o chirrio. Cjanu o ndas'üji va pjongüji cja c'e templo texeji co c'o o̱ nzhünüji 'ñe c'o o̱ ndënchjürüji. Cjanu o pjö'tp'ü o̱ merio c'o mi pötü o merio. O tunbüji c'o o̱ mexaji. ");
INSERT INTO mazNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","O xipji c'ua c'o mi pö'ö c'o mbaro: ―Nuyo, pjongüji va yo. Nu'tsc'eji, dya rí tsjapcüji chõjmü nu o̱ ngumü mi Tatagö. ");
INSERT INTO mazNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nuc'ua c'o o̱ discípulo o mbeñeji c'ua c'o ya t'opjü, c'ü mama a cjava: “Na ngueje c'ü me rgá pjörügö in nzungue, me ra nugöji na ü”, eñe va zopjü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nuc'ua c'o menzumü a Israel, o tsjapüji t'önü e Jesús, o xipjiji: ―¿Pje rí jítsijme ngue c'ua rá pãrãjme pje pjë'ts'igue nguec'ua i̱ṉ cjague nu yo i̱ṉ cjague? ");
INSERT INTO mazNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","O ndünrü c'ua e Jesús, o xipjiji: ―Yä't'äji nu e templo nu. Na jñi nu pa'a rá bö'bütjo. ");
INSERT INTO mazNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","O mama c'ua c'o menzumü a Israel: ―O mezhe cuarenta y seis cjë'ë va dyät'äji nu. Nu'tsc'e i̱ṉ mama jñipatjo rí bö'bü. ");
INSERT INTO mazNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero e Jesús je mi mama e templo c'ü je mi nguetsjë angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","'Ma o te'e cja yo añima e Jesús, nuc'ua c'o o̱ discípulo o mbeñeji c'ü vi mama yo. Nuc'ua ya o 'ñejmeji c'ua yo vi t'opjü 'ñe c'e jña'a c'ü vi mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","'Ma mi bübü e Jesús a Jerusalén cja c'e mbaxua c'ü ni chjũ Pascua, na puncjü nte c'o o 'ñejme c'o mi cja e Jesús. 'Ma o jñandaji c'o mi cja angueze c'o nunca mi jandaji, ya o 'ñejmeji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero e Jesús mi pãrã c'ü dya ro ndünt'üji o̱ xütjü. Mi pãrã na ngueje mi pãtpãji o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dya mi jyodü cjó ro xipji ja ma cja c'o nte. Na ngueje angueze nde mi pãrã nu c'o mi cjijñiji. ");
INSERT INTO mazNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mi bübü 'naja c'o fariseo c'ü mi chjũ Nicodemo. Mi jmu'u cja c'o menzumü a Israel. ");
INSERT INTO mazNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nuc'ü, o ẽjẽ 'na nu xõmü cja e Jesús. O xipji: ―Xöpüte, rí pãrãgöjme o juan'c'ü Mizhocjimi rí xöpügue yo nte. Na ngueje 'ma dya ri bübügue co Mizhocjimi, dya ro sö ri tsjague 'ma, nuyo i̱ṉ jizhigue yo nunca mi jandajme. ");
INSERT INTO mazNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","O ndünrü c'ua e Jesús, o xipji: ―Na cjuana c'ü rí xi'ts'i. Nu c'ü dya ra jmus'ü na yeje, dya ra sö ra nu'u c'ü ra manda Mizhocjimi a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","O xipji c'ua e Nicodemo: ―¿Ja rgá sö ra jmus'ü 'naja nte 'ma ya zöya? ¿Cjo ra sö ra cjogü cja o̱ pjeme nu nana ra jmus'ü na yeje? ");
INSERT INTO mazNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","O ndünrü e Jesús: ―Rí xi'ts'igö c'ü na cjuana. Nu c'ü dya ra jmus'ü cja ndeje 'ñe cja o̱ Espíritu Mizhocjimi, dya ra sö ra nu c'ü ra manda Mizhocjimi a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yo nte'e unüji o̱ ts'ingue c'o nu t'iji, nguec'ua xo ga nte c'o t'i. Je xo ga cjatjonu 'ma cjó c'o ra 'ñejme, Mizhocjimi unü c'ü o̱ Espíritu ngue c'ua c'e nte ra tsjapü o̱ t'i 'ma Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dya me rí tsjijñi c'ü ró xi'ts'i, ni jyodü ra jmuxc'ü na yeje. ");
INSERT INTO mazNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","E ndajma ja nde vü'ü. I̱ṉ ärä vü'ü. Pero dya i̱ṉ pãrã ja je ni 'ñeje, ne ja je ni ma'a, na ngueje dya sö rí jñandgue. Je xo ga cjatjonu, dya sö rí jñandgue Mizhocjimi 'ma unü o̱ Espíritu 'na nte ga tsjapü o̱ t'i. ");
INSERT INTO mazNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","O ndünrü c'ua e Nicodemo, o xipji: ―Nuyo, ¿ja rga sö ra ts'a'a yo? ");
INSERT INTO mazNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","O ndünrü e Jesús, o xipji: ―Ngue'tsc'e i̱ṉ xöpüte cja yo ín menzumüji a Israel. ¿Cjo dya i̱ṉ pãrã yo rrã xi'ts'i? ");
INSERT INTO mazNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nuzgö rrã xi'ts'igö c'ü na cjuana. Nu c'o rí pãrãgöjme rí xi'tsc'öjme. Nu c'o ró nujme rí mamajme na cjuana. Pero dya i̱ṉ ejmeji c'o rí xi'tsc'öjme. ");
INSERT INTO mazNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nu 'ma rí xi'ts'iji c'o tsjaja cja ne xoñijõmü, dya i̱ṉ ejmeji. ¿Ja rgui 'ñejmeji 'ma rá xi'ts'iji c'o tsjaja a jens'e? ");
INSERT INTO mazNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Dya cjó nguins'i a jens'e ngue c'ua ra mbãrã ja ga cja Mizhocjimi. Pero bübü c'ü pãrã. Nutscö rvá ẽjẽ a jens'e cja Mizhocjimi nu ja exmi bübügö, nguetscö rí pãrãgö. ");
INSERT INTO mazNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","'Ma ma ẽjẽ c'o c'ijmi ma ẽ saji c'o ín mboxtitagöji cja c'e ndajyadü, e Moisés o dyät'ä 'na c'ijmi de bronce, cjanu o ndün't'ü cja 'na za'a c'ü ma jens'e. Nguec'ua 'ma mi janda c'o nte, dya mi tũji c'o vi za o c'ijmi. Xo rga cjatjonu, xo ni jyodü ra ndüntcüji cja ngronsi, nutscö rvá ẽcjö cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nguec'ua texe c'o ra 'ñench'ezügö cja o̱ mü'bü nde ra bübütjoji, dya ra ndũji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mizhocjimi me s'iya texe yo cãrã cja ne xoñijõmü. Nguec'ua va nzhö c'ü nu T'i c'ü 'natjo para o ndũ va ngõtcü ín nzhubüji; nguec'ua texe c'o ra 'ñench'e o̱ mü'bü angueze, dya ra ndũji, ra bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","C'ü vi ndäjä Mizhocjimi c'ü nu T'i'i cja ne xoñijõmü, dya ngue c'ü ra tsjapü ra ngõt'ü o̱ nzhubü yo cãrã cja ne xoñijõmü. O ndäjä ngue c'ua o ngõ'tp'ü c'o nzhubü c'o tũji. A cjanu, nu c'o ench'e o̱ mü'bü angueze, ra bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nu c'ü ejme c'ü nu T'i Mizhocjimi, dya ra tsjapü Mizhocjimi ra ma sufrido. C'ü dya ejme, o mama Mizhocjimi c'ü ra tsjapü ra ma sufrido. Na ngueje o ndäjä c'ü 'natjo o̱ T'i, pero dya ne c 'e nte ra 'ñejme. ");
INSERT INTO mazNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","E jya's'ü o ẽjẽ cja ne xoñijõmü. Pero yo nte mi neji bëxõmü. Dya neji e jya's'ü na ngueje na s'o cjaji. Nguec'ua ra ma ngõt'üji o̱ nzhubüji. ");
INSERT INTO mazNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Texe c'o cja na s'o me ünmbüji e jya's'ü. Dya xo ne ra säjäji cja e jya's'ü na ngueje 'ma ro säjäji cja e jya's'ü ro tjandbaji 'ma c'o na s'o c'o cjaji. ");
INSERT INTO mazNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nu c'o cja na cjuana, va ẽji cja e jya's'ü ngue c'ua ra tjandbaji c'ü vi tsjaji c'ua ja nzi ga ne Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","'Ma o nguarü yo, o ma c'ua e Jesús co nu c'o o̱ discípulo a ma Judea. O nguejme nu co anguesji. Mi jichite nu. ");
INSERT INTO mazNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","E Juan xo mi jichite a Enón bëxtjo a Salim. Mi jichite nu, na ngueje mi po na puncjü ndeje nu. O ẽjẽ c'o nte'e ma ẽ ji'iji. ");
INSERT INTO mazNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Dya be mi cjot'ü cja pjörü 'ma, e Juan. ");
INSERT INTO mazNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nuc'ua c'o o̱ discípulo e Juan o zöji jña 'naja bëzo c'ü mi menzumü a Judea. O zöji jña c'ua ja ga cja c'ü mi jichite e Jesús, 'ñe c'ü mi jichite e Juan. ");
INSERT INTO mazNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","O möji cja e Juan. O xipjiji: ―Xöpüte, c'e bëzo, nu c'ü mi bübüguevi mbes'e a manu cja c'e ndare a Jordán, nu c'ü i̱ xitsijme cjó ngueje, ya jichi yo nte. Nudya nde pöji texeji nu ja bübü angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","O ndünrü e Juan, o mama: ―Na jo c'ü. Na ngueje Mizhocjimi o unü c'e bëpji nguec'ua ga tsja c'ua. ");
INSERT INTO mazNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nu'tsc'eji i̱ṉ pãrãtsjëji ró mamagö, “Dya nguetscö e Cristo. O däcjätjogö ró ot'ü ró xipji yo nte c'ü va ẽjẽ e Cristo. Cja rron 'ñeje angueze.” ");
INSERT INTO mazNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Rá xi'ts'iji 'na jña. 'Ma cjaji chjüntü, ngue c'ü jovi c'e t'i c'ü ra 'ñe'chp'e a dyë c'e xunt'i. Pero c'ü jovi c'e t'i me mäjä ga dyärä ña'a c'e t'i ga zopjü c'e xunt'i. Je xo ga cjazgö nu, me rí mäcjö na ngueje ya ngue e Jesús c'ü ya zopjü dya yo nte. ");
INSERT INTO mazNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Na ngueje xenda ra mbëzhi na nojo angueze. Dya cja pje ra mbëtscö. ");
INSERT INTO mazNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Nu c'ü vi 'ñeje a jens'e ngue c'ü manda texe. Nutscö je ró tegö cja ne xoñijõmü rí mama c'o tsjaja cja ne xoñijõmü. Nu c'ü exmi bübü a jens'e ngue c'ü manda texe. ");
INSERT INTO mazNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nuc'ü, mama c'o o jñanda a jens'e 'ñe c'o o dyärä. Pero dya cjó ejme c'o mama. ");
INSERT INTO mazNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nu c'ü ejme c'o mama, ya o jñunt'ü o̱ mü'bü c'ü na cjuana c'ü mama Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na ngueje nu c'ü o ndäjä Mizhocjimi, mama o̱ jña Mizhocjimi. Mizhocjimi o unü o̱ Espíritu ra ña o̱ jña. Dya ënmbitjo ga unü o̱ Espíritu. ");
INSERT INTO mazNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mizhocjimi me s'iya c'ü nu T'i'i. O nzhötü texe cja o̱ dyë'ë. ");
INSERT INTO mazNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nu c'ü ench'e o̱ mü'bü e Jesucristo c'ü nu T'i Mizhocjimi, ra bübütjo, dya ra ndũ. Nu c'ü dya ench'e o̱ mü'bü c'ü nu T'i Mizhocjimi, ra ndũ'ũ, dya ra bübü. Mizhocjimi ünmbü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","C'o nte ya mi pjürü mi nädäji e Jesús mi mamaji: ―E Jesús xenda na puncjü o nte c'o xöpü que na ngue c'o mi xöpü e Juan. Y xenda na puncjü o nte c'o jichi co ndeje, mi eñeji. ");
INSERT INTO mazNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Bueno, dya mi ngue e Jesús c'ü mi jichi c'o nte, mi ngue c'o o̱ discípulo. O üdü c'ua c'o fariseo va dyäräji c'ü mi mama c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nguec'ua 'ma o mbãrã a cjanu e Jesús, o mbedye c'ua a Judea co c'o o̱ discípulo, o möji na yeje a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mi jyodü ro cjogü a Samaria ngue c'ua ro zät'ä a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","O zät'äji c'ua cja 'na ndajñiñi c'ü mi tsja a Samaria c'ü mi chjũ Sicar. O̱ juajma e Jacob bëxtjo mi tizhi cja c'e jñiñi. Nu c'e juajma vi zopcü c'ü nu t'i c'ü mi chjũ José. ");
INSERT INTO mazNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mi bübütjo nu o̱ pozo e Jacob. E Jesús ya me vi mbo o̱ cuë ma nzhodü cja 'ñiji. O mimi a jmi cja c'e pozo. Ya mi zünü 'ñanto c'ü nzhä 'ma o zät'äji. ");
INSERT INTO mazNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","O ẽjẽ c'ua 'naja ndixũ c'ü mi menzumü a Samaria. O ẽ ngüs'ü ndeje. Nuc'ua e Jesús o xipji: ―Dyacü ts'iquë ndeje, rá si'i, eñe. ");
INSERT INTO mazNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","C'o o̱ discípulo e Jesús vi möji cja c'e ndajñiñi. O ma ndõmüji c'ü ro ziji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","O mama c'ua c'ü e ndixũ a Samaria, o xipji e Jesús: ―Maco i̱ṉ menzumü a Israel. ¿Jenga i̱ṉ ötcügö ndeje c'ü rí sigue? Nutscö rí ndixũ y rí menzumü a Samaria, eñe. C'o menzumü a Israel, dya ñuji c'o menzumü a Samaria. ");
INSERT INTO mazNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","O ndünrü e Jesús, o xipji: ―Nu 'ma ri pãrãgue c'ü unü Mizhocjimi 'ñe cjó je nguetscö c'ü xi'ts'i, “Dyacü ts'iquë ndeje rá si”, nu'tsc'e ri dyötcü, nuc'ua ro da'c'ügö ndeje c'ü sido rí bübütjo, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","O ndünrü c'ua c'e ndixũ: ―Nu'tsc'e sẽ'ẽ, ojtjo pje rgui tsjüs'ügue. Me na jẽ'ẽ ne pozo. ¿Ja je ngue c'ua peje c'e ndeje c'ü sido rá bübütjo? ");
INSERT INTO mazNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ne pozo nu, o dyacöjme e Jacob c'ü mi mboxtitagöjme. Nuc'ü, mi si'i ne ndeje. Xo 'ñe c'o o̱ t'i, 'ñe c'o o̱ animaleji. Nu'tsc'e, ¿cjo xenda pjë'tsc'e na nojo que na ngueje e Jacob? A poco rí dyacö ndeje c'ü xenda na jo, eñe c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","O ndünrü e Jesús, o xipji: ―C'ü ra zi ne ndeje nu, ra tũretjo. ");
INSERT INTO mazNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nu c'ü ra zi c'e ndeje c'ü rá unügö, dya cja ra ndũre. C'e ndeje c'ü rá unügö, ra bübü cja o̱ mü'bü; ra chjëntjovi nza cja ndeje c'ü peje cja mëjë, nguec'ua sido ra bübütjo c'e nte, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","O ndünrü c'ua c'e ndixũ: ―Nu'tsc'e, sẽ, dyacö c'e ndeje c'ü. Ngue c'ua dya cja rá tũre. Ngue c'ua dya cja xo rá ẽ cjüs'ü a 'ñecjua. ");
INSERT INTO mazNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nuc'ua e Jesús o xipji: ―Ma zojnü nin xĩra. Nuc'ua rí 'ñejevi a 'ñecjua. ");
INSERT INTO mazNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","O ndünrü c'e ndixũ: ―Dya rí 'ñecjö ín xĩra. O xipji c'ua e Jesús: ―I̱ mamague c'ü na cjuana, dya i̱ṉ 'ñecje nin xĩra. ");
INSERT INTO mazNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Na ngueje ya mi 'ñeje tsi'ch'a nin xĩra. Nu c'ü i̱ṉ 'ñeje dya, dya ngueje nin xĩra. I̱ mamague na cjuana yo. ");
INSERT INTO mazNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","O ndünrü c'ua c'e ndixũ, o mama: ―Nutscö, sẽ, rgá cjijñigö ngue'tsc'e 'na profeta. ");
INSERT INTO mazNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nu c'o ín mboxtitajme o ma't'üji Cjimi cja ne t'eje nu. Nu'tsc'eji i̱ṉ menzumügueji a Israel i̱ṉ mamagueji ngueje a Jerusalén nu ja je rá ma't'üji Cjimi, eñe c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","O ndünrü e Jesús, o xipji: ―Dyätcägö yo rá xi'ts'i. Ra zädä yo pa'a nu 'ma dya cja rguí jyodü rí möji cja ne t'eje; dya cja xo rguí jyodü rí möji a Jerusalén ngue c'ua rí ma't'üji ín Tataji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nu'tsc'eji i̱ṉ ma't'ügueji Cjimi, pero dya i̱ṉ pãrãji ja ga cja c'ü. Nutscöjme rí ma't'ügöjme Cjimi, pero rí pãrãjme ja ga cja c'ü. Na ngueje nu c'ü ra jopcü o̱ mü'bü yo nte, je vi 'ñeje cja yo menzumü a Israel. ");
INSERT INTO mazNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ya säjä yo pa, c'ü ni jyodü yo nte ra mbãrãji c'ü na cjuana ja ga cja Mizhocjimi, 'ñe ra ma't'üji co texe o̱ mü'büji. 'Ma ra tsjaji a cjanu, na cjuana rgá ma't'üji 'ma Mizhocjimi. Mizhocjimi ne'e cjó c'o ra ma't'ü a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mizhocjimi ngueje Espíritu, dya sö rá jandaji. Nguec'ua c'o ra ma't'ü Mizhocjimi ni jyodü ra mbãrãji a cjanu, c'ü dya ngue 'na ts'ita c'ü sö ra jñandaji. Pero ra ma't'üji Mizhocjimi co texe o̱ mü'büji, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","O ndünrü c'ua c'e ndixũ: ―Rí pãrãgö ra ẽjẽ e Mesías; 'ma ra ẽjẽ c'ü, ra nda xitsiji texe ja cja, eñe c'e ndixũ. C'e jña Mesías ne ra mama: “Ngue Cristo c'ü o 'ñeme Mizhocjimi ra manda.” ");
INSERT INTO mazNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","O ndünrü c'ua e Jesús: ―Nguetscö e Cristo; rí ñagövi. ");
INSERT INTO mazNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nuc'ua o säjä c'o o̱ discípulo. Me mi cjijñiji c'ua, jenga mi ñavi 'na ndixũ. Pero dya cjó xipji: ―¿Jenga i̱ṉ ñavi ne ndixũ? ¿Pje i̱ṉ önü nu?, ro 'ñeñeji. ");
INSERT INTO mazNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nuc'ua c'e ndixũ o zogütjo c'ü nu xäjnä. O ma c'ua cja c'e ndajñiñi. O ma xipji c'o nte: ");
INSERT INTO mazNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Xä'däji dya. Mö rá ma nuji 'naja bëzo c'ü o xitsi texe c'o ró cjagö. 'Na ri ngueje e Cristo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nuc'ua o mbedyeji cja c'e ndajñiñi. O möji nu ja je mi bübü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","'Ma ndänt'ä ma ñaji c'e ndixũ c'o nte, nuc'ua c'o o̱ discípulo ma xipjiji e Jesús: ―Nu'tsc'e, xöpüte; ni jyodü rí sigue xëdyi. Pero dya o zi'i. ");
INSERT INTO mazNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","E Jesús o xipji c'ua c'o o̱ discípulo: ―Nuzgö rí pë's'igö c'ü rá si'i; nu'tsc'eji dya i̱ṉ pãrãgueji. ");
INSERT INTO mazNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nuc'ua c'o discípulo mi pötma mamaji: ―¿Cjó ngue c'ü ro tunpü c'ü ra zi'i nu? ");
INSERT INTO mazNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","E Jesús o xipjiji c'ua: ―C'e jñõnü c'ü ni zëzhi ín mü'bü, ngue c'ü rí cjagö c'ü ne'e nu c'ü o ndäcjägö, y rá cjuatpügö texe c'ü ne angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Cjo dya i̱ṉ mamagueji xe bëzhi nziyo zana cja ra zädä dagrëxü? Pero rí xi'tsc'öji, jñanchjãji dya, yo nte yo va ẽjẽ ra dyäräji yo ín jñagö, chjëntjoji nza cja o ndëxü c'o ya na jo ra dagü. ");
INSERT INTO mazNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nu c'ü tagü jo mäjä c'ü; na ngueje bübü c'o ra 'ñejmezü. Sido ra bübütjoji; dya ra ndũji. Nguec'ua c'ü tagü 'ñe c'ü podü 'natjo c'ua ra mäjävi. ");
INSERT INTO mazNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Na ngueje na cjuana c'ü je mama a cjava: “'Naja ngue c'ü podü. C'ü 'naja ngue c'ü tagü.” ");
INSERT INTO mazNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ró täc'ägöji rí chagüji nu ja dya i̱ pëpiji. Nandyo c'o o pëpji. Nu'tsc'eji i̱ṉ tagüji c'o o mbodü anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na puncjü c'o mi menzumü cja c'e ndajñiñi c'ü mi tsja a Samaria o 'ñejmeji e Jesús na ngueje c'o vi mama c'e ndixũ. Vi mama c'e ndixũ: “O xitsi texe c'o ró cjagö”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","'Ma o säjä c'o mi menzumü a Samaria nu ja mi bübü e Jesús, c'o nte mi süjmüji ja nzi pa e Jesús. Nguec'ua va nguejme c'ua yepa nu. ");
INSERT INTO mazNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Xenda na puncjü c'o o 'ñejme c'ua na ngueje c'o mi mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","O mama c'ua c'o nte, o xipjiji c'e ndixũ: ―Ya rí pãrãjme na cjuana ne bëzo nu, ngueje nu o ẽjẽ ra 'ñeme libre yo cãrã cja ne xoñijõmü, ngueje e Cristo. Rí ejmegöjme na ngueje c'o i̱ xitscöjme; y ya xo ró ärätsjëjme c'o mama angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","'Ma ya vi mezhe yepa nu, cjanu o mbedye c'ua nu. Cjanu o ma a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Na ngueje ya vi mama e Jesús: “Dya respetaoji 'na profeta cja o̱ jñiñitsjëjë.” ");
INSERT INTO mazNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","'Ma o zät'ä a Galilea e Jesús, c'o mi cãrã nu, me co mäjä va jñandaji. Na ngueje xo vi möji cja c'e mbaxua a Jerusalén c'ü ni chjũ Pascua, vi jñandaji texe c'o vi tsja nu e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","O yepe o ma c'ua e Jesús a Caná c'ü tsja a Galilea. Nujnu, nguejnu vi tsjapü c'ü e ndeje o mbëzhi vino. Nujnu, mi bübü nu, 'naja c'ü mi jmu'u. Nu c'ü nu t'i'i mi sö'dyë. Je mi bübü a Capernaum. ");
INSERT INTO mazNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nu c'e jmu o dyärä je vi mbedye a Judea e Jesús; ya vi zät'ä a Caná c'ü je tsja a Galilea. O ma c'ua nu ja je mi bübü e Jesús. O ma dyötü na puncjü ro zöbü a Capernaum, ro ma jopcü c'ü nu t'i'i na ngueje ya ma tũ'ũ. ");
INSERT INTO mazNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nuc'ua e Jesús o xipji: ―Maco rí xi'tsc'öji cjó je nguetscö, pero i̱ṉ ne rí jñandgueji c'ü rá cjagö c'ü me rrã nojo c'ü rí mangueji: “Nunca rí jandgöji a cjanu”, rí 'ñeñeji. 'Ma jiyö, dya rí 'ñejmezüji. ");
INSERT INTO mazNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","C'e jmu o xipji: ―Nu'tsc'e nin t'ecjañumü, na jo ya rí sjöbü, ngue c'ua xe rí sürü rí jocü ín ch'i. Ya va tũ'ũ. ");
INSERT INTO mazNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","O mama c'ua e Jesús: ―Mague dya. Nu c'ü in ch'i'i, dya ra ndũ'ũ c'ü. Ra bübütjo. Nuc'ua c'e bëzo o 'ñejme c'o jña c'o o xipji e Jesús. O ma c'ua. ");
INSERT INTO mazNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","'Ma ya ma sjöbü angueze, o mbedye c'ua c'o o̱ mbëpji. O ma ndünrüji. O xipjiji: ―Nu c'ü in ch'i'i bübütjo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nuc'ua c'ü nu tata c'e t'i o tsja t'önü ja hora o mbürü o jogü. O xipjiji c'ua: ―A ndä'ä 'ma o zünü siete, o c'ueñe c'e pa'a. ");
INSERT INTO mazNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nuc'ua c'e tata ya o mbãrã mi ngueje c'e hora c'ü vi xipji e Jesús: “In ch'i'i ra bübütjo.” Nuc'ua c'ü o̱ tata c'e t'i o 'ñench'e o̱ mü'bü e Jesucristo cja na 'ñe texe c'o mi cãrã o̱ ngumü. ");
INSERT INTO mazNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","'Ma o mbedye e Jesús a Judea o ma a Galilea o jocü c'e t'i'i, ngue c'ü na yeje c'ü o jizhi e Jesús c'o nunca mi janda c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nuc'ua 'na nu pa mi cja o mbaxua c'o menzumü a Israel. O ma c'ua a Jerusalén e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Cja c'e ngoxtji a Jerusalén nu ja mi cjocüji o ndënchjürü, nujnu, bëxtjo mi bübü 'na t'ore. Cja c'e jña hebreo ni chjũ Betesda c'ü e t'ore. Mi järä tsi'ch'a o porta nu. ");
INSERT INTO mazNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nunu mi orü nu, na puncjü c'o mi sö'dyë. Mi cãrã c'o mi ndëzhö, 'ñe c'o mi me'dye, 'ñe c'o dya mi sö ro 'ñõmü. Mi te'beji ro pjõ's'ü c'e ndeje. ");
INSERT INTO mazNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Na ngueje mi bübü 'ma mi dat'ü 'naja o̱ anxe Mizhocjimi nu ja je mi po c'e ndeje. Me mi ñus'ü c'e ndeje. C'ü ot'ü mi dat'ü cja c'e ndeje 'ma ya ra nguarü ra ñus'ü, mi jogü c'o pje nde ma ngueme c'o mi sö'ö. ");
INSERT INTO mazNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mi bübü nu, 'naja bëzo c'ü ya mi pa'a treinta y ocho cjë'ë c'ü mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","'Ma o jñanda e Jesús mi orü c'e bëzo, o mbãrã ya vi mezhe mi sö'dyë. Nuc'ua e Jesús o dyönü c'ua: ―¿Cjo i̱ṉ ne ra jots'ü? ");
INSERT INTO mazNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","O ndünrü c'ü mi sö'dyë: ―Nu'tsc'e nin t'ecjañumü, nuzgö, ojtjo cjó ra ngöcügö cja ne t'ore 'ma pjõ's'ü ne ndeje. 'Ma cja rí negö rá dat'ü, ya ni ot'ü ni dat'ü 'naja. ");
INSERT INTO mazNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","O ndünrü c'ua e Jesús: ―Nu'tsc'e ñanga dya, xos'ü c'ü i̱ṉ pjĩzhĩ, nzhodü dya. ");
INSERT INTO mazNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nuc'ua exo jogü c'ua c'e bëzo. Ya o nduns'ü c'ua c'ü mi pjĩzhĩ. Nuc'ua ya o nzhodü c'ua c'e bëzo. Nu pa c'ü o nzhodü c'e bëzo ngue c'e sjũpa 'ma mi söyaji. ");
INSERT INTO mazNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nguec'ua c'o pje mi pjëzhi cja c'o nte a Israel o xipjiji c'ü vi jogü: ―Ngue nu pa dya nu rí söyaji. Mama cja o̱ ley Mizhocjimi c'ü o dyopjü e Moisés, dya pje ra sö rí chunü nu i̱ṉ pjĩzhĩ nu pa dya. ");
INSERT INTO mazNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","O ndünrü c'ua c'e bëzo: ―Nguejetsjë c'ü o jocüzü c'ü o xitsitsjëjë: “Xos'ü nu i̱ṉ pjĩzhĩ, rí nzhodü dya.” ");
INSERT INTO mazNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","O dyönüji c'ua: ―¿Cjó ngue c'e bëzo c'ü o xi'ts'i: “Rí xos'ü nu i̱ṉ pjĩzhĩ rí nzhodü?” ");
INSERT INTO mazNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","C'ü ya vi jogü, dya mi pãrã cjó ngue c'ü vi jocü. Na ngueje e Jesús vi xõgü vi cjogü cja c'o nte c'o ma puncjü. ");
INSERT INTO mazNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nu c'e ndajme c'ua, e Jesús o chöt'ü c'e bëzo a mbo cja c'e templo. O xipji: ―Jñanda dya, xã. Ya o jots'ü dya. Dya cja rí tsja dya c'o na s'o. 'Na pje ne ra ts'a'c'ü c'ü xenda rí sufrido. ");
INSERT INTO mazNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","O ma c'ua c'e bëzo. O ma xipji c'o mi pjëzhi cja c'o nte a Israel: ―Ngueje e Jesús c'ü o tsjacö o jozü. ");
INSERT INTO mazNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nguec'ua c'o nte a Israel me mi nuji na ü e Jesús. Mi jodüji ro mbö't'üji na ngueje mi cja'a yo, c'e sjũpa 'ma mi söyaji. ");
INSERT INTO mazNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero o mama e Jesús: ―Mi Tatagö c'ü bübü a jens'e pëpjitjo; 'ñetscö xo rí pëpjitjogö, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nuc'ua c'o mi pjëzhi cja c'o nte a Israel xenda mi jodüji c'ua ro mbö't'üji. Na ngueje e Jesús dya mi sũpü c'e pa'a c'ü söyaji; xo mi mama: “Mizhocjimi nguejmi Tatagö.” A cjanu mi cjapü ra mbãrãji c'ü Mizhocjimi angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nuc'ua e Jesús, o xipjiji: ―Na cjuana c'ü rí xi'tsc'öji. Nuzgö exi ngue o̱ T'izgö Mizhocjimi. Nguec'ua nunca rí cjagö c'ü rí netsjëgö. C'ü rí cja'a, nguextjo c'ü rí janda cja'a Mizhocjimi c'ü mi Tata. Na ngueje c'o cja'a mi Tata xo rí cjagö yo, na ngue o̱ T'izü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mi Tata me s'iyazü. Nguezgö o̱ T'izü angueze. Mi Tata jítsi texe c'o cja'a angueze. Xe ra jítsi c'o xenda na nojo bëpji que na ngueje yo, c'o rá cjagö. Nguec'ua me rí tsjijñigueji. ");
INSERT INTO mazNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mi Tata xos'ü c'o ya ni ndũ'ũ. Unüji c'ü ra bübütjoji. Nuzgö o̱ T'izü Mizhocjimi, xo ga cjatjozügö. Rá unütjo ra bübüji, nu c'o rí ne rá unütjo. ");
INSERT INTO mazNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mi Tata dya cjó ra jñünpü ngüenda. Ya o dyacügö mi Tata rá jünpü ngüenda texe yo nte. ");
INSERT INTO mazNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nguec'ua, ra respetaozgöji c'ua ja nzi ga respetaoji mi Tata. Nu c'ü dya neze, dya xo ne mi Tata c'ü o ndäcjä. ");
INSERT INTO mazNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Yo nte, chjëntjui c'ü ya ni ndũji, na ngueje tũji o̱ nzhubüji. Pero rí xi'tsc'öji c'ü na cjuana, nu c'ü ra dyätcä ín jñagö, 'ñe ra 'ñejme nu c'ü o ndäcjä, exta bübütjo. Nguec'ua dya rá jünpü ngüenda ra ma sufrido. ");
INSERT INTO mazNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na cjuana c'ü rí xi'ts'igöji, yo nte yo ya ni ndũ, ya ngue ra zädä y ya zädä dya, c'ü ra dyäräji ín jña'a, nutscö o̱ T'izü Mizhocjimi. Nu c'o ra dyätcägö, rá unüji c'ü ra bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Na ngue c'ua ja nzi ga cja Mizhocjimi je xo ga cjazgönu, nutscö o̱ T'izü. Exo rí bübütjogö. ");
INSERT INTO mazNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mizhocjimi xo o dyacü rá jünpü ngüenda yo nte. Na ngueje rvá ẽcjö cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Dya cja rí tsjijñiji: “Pero, ¿ja rgá sö ne bëzo ra tsja yo?”, i̱ṉ mangueji a mbo in mün'c'eji. Na ngueje ra ts'a c'o xe rrã nojo, ra ẽjẽ nu pa'a 'ma ra dyätcä ín jñagö texe c'o ya ndũ. ");
INSERT INTO mazNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Texeji ra mbes'eji c'ua ja t'ögüji. Nu c'o o tsja c'ü ne Mizhocjimi, ra ch'unüji c'ü sido ra bübütjoji. Nu c'o dya o tsja c'ü ne Mizhocjimi, ra jñünpüji ngüenda; ra sufridoji, dya ra nguarü. ");
INSERT INTO mazNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Xe ma ña'a e Jesús. O mama: ―Nunca rí cjagö c'ü rí netsjëgö. Nu c'ü xitsi ín Tatagö a jens'e ngue c'ü rí cjagö c'ü. Rí jünpügö ngüenda texe yo cãrã cja ne xoñijõmü. Na jo c'ua nzi rga cjagö rá jünpüji ngüenda, na ngueje dya rí jodügö rá cja c'ü rí netsjë. Nuzgö rí cjagö c'ü ne'e mi Tatagö c'ü o ndäcjä. Nguextjo c'o rí cjagö c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","'Ma ri nguextjozgö ri mama c'ü exi ngue o̱ T'izgö Mizhocjimi, ro sö ri mangueji 'ma, c'ü dya cjuana. ");
INSERT INTO mazNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero rí xi'ts'iji, bübü ne 'naja c'ü mama pje pjëtscö. Rí pãrãgö c'ü na cjuana c'ü mama angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nu'tsc'eji i̱ chäjägueji o mböcjimi 'ñe o levita o ma tsjapüji t'önü e Juan pje pjëtscö. Angueze o xipjiji c'ü na cjuana. ");
INSERT INTO mazNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Zö na cjuana c'ü o mama e Juan, dya nda ni muvi na ngueje nguetjo bëzo. Pero rí mbeñc'eji c'o jña c'o o mama e Juan. Ngue c'ua ra sö rí 'ñejmezüji, rá jocuts'ü in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","'Na sivi ũ's'üji cja 'ñiji. Je xo ma cjatjonu e Juan, mi jí'tsc'eji o̱ 'ñiji Mizhocjimi. Nu'tsc'eji i̱ mäjäji ja nzi pa co c'o vi xi'ts'iji. ");
INSERT INTO mazNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","E Juan o mama pje pjëtsigö; pero bübü c'o xenda ni 'ñetse pje pjëtsigö. Ngue c'o rí cjagö c'o o dyacü mi Tatagö a jens'e. Rá cjuatügö texe nu c'o o dyacü rá cjagö. Nuc'o, ngue c'ü ni 'mãrã c'o, c'ü na cjuana o ndäcjä mi Tata. ");
INSERT INTO mazNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A cjanu, mi Tata c'ü o ndäcjägö mama na cjuana pje pjëtsigö, zö nunca i̱ṉ ätpäji o̱ jña'a 'ñe dya xo xogü in chöji ngue c'ua rí pãrãgueji ja ga cja c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Dya xo i̱ṉ ench'e in mü'büji o̱ jña Mizhocjimi, na ngueje dya i̱ṉ ejmezügöji nutscö o ndäcjä mi Tata. ");
INSERT INTO mazNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","I̱ṉ xörüji na jo cja o̱ jña Mizhocjimi, na ngueje i̱ṉ cjincjeji 'ma rí xörügueji ra ch'a'c'üji c'ü rí bübütjoji. Nguetsjë yo jña'a yo je mama pje pjëtsigö. Nguetscö rí unügö c'ü rí bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero dya pje i̱ṉ neji rí 'ñejmezüji. 'Ma ri 'ñejmezüji ro da'c'eji 'ma c'ü ri bübütjogueji. ");
INSERT INTO mazNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Nuzgö dya pje rí jodütsjëgö c'ü ra mama yo nte na nozgö. ");
INSERT INTO mazNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero nutscö rí pãjtc'ãgöji cja in mü'büji. Rí pãrãgö c'ü dya pje i̱ṉ s'iyaji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi Tata a jens'e o ndäcjä ró ẽcjö ngue c'ua rá cjagö c'ü ne angueze. Pero nu'tsc'eji, dya pje i̱ṉ säcjägöji. 'Ma cjó c'o ra ẽ mama c'ü pjëzhi na nojo, nuc'ü, ngue c'ü rí säjäji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ja rgá sö rí 'ñejmezüji? Dya sö. Na ngueje me i̱ṉ unüji ngüenda c'ü mama yo nin minteji na jotsc'eji. Dya i̱ṉ ne rí unüji ngüenda o̱ jña Mizhocjimi c'ü xi'tsc'eji cjó je ngue c'ü exna cjuana na jo'o. ");
INSERT INTO mazNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Dya rí tsjijñigueji c'ü rá cö'c'öji a jmi ín Tatagö a jens'e. Bübü c'ü na cö'c'eji. Ngueje o̱ ley Mizhocjimi c'ü o dyopjü e Moisés. I̱ṉ cjijñigueji c'ü me na jotsc'eji na ngueje i̱ṉ tjëji c'e ley, pero je ngue c'ü ni 'ñetse c'ü na s'o i̱ṉ cjaji. ");
INSERT INTO mazNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nu 'ma ri 'ñejmegueji yo o dyopjü e Moisés, xo ri 'ñejmezügöji; na ngueje e Moisés o dyopjü cja o̱ jña Mizhocjimi c'ua ja ga cjazgö. ");
INSERT INTO mazNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","'Ma dya i̱ṉ ejmeji yo o dyopjü e Moisés, ¿ja rgui 'ñejmezügöji c'ü rí mangö? ");
INSERT INTO mazNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","'Ma ya o nguarü yo, o ma e Jesús nu 'nanguarü c'e zapjü a Galilea c'ü xo ni chjũ Tiberias. ");
INSERT INTO mazNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Me mi pöji na puncjü o nte'e. Na ngueje mi nuji c'o mi jizhi 'ma mi jocü c'o mi sö'dyë. ");
INSERT INTO mazNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","O ma e Jesús cja 'na t'eje. O mimi nu co nu c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ya mi ngue ro zädätjo c'e mbaxua c'ü ni chjũ Pascua c'ü cja yo nte a Israel. ");
INSERT INTO mazNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","O jñe'ch'e c'ua e Jesús, o jñanda me ma puncjü o nte c'o ma ẽjẽ nu ja mi bübü angueze. O dyönü c'ua e Felipe: ―¿Ja je rá tõmüji c'ü ra zi'i yo? ");
INSERT INTO mazNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mi mama yo, na ngueje ma sö e Felipe, mi cja e Jesús. E Jesús ya mi pãrã c'ü ro tsja'a. ");
INSERT INTO mazNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nuc'ua o ndünrü e Felipe: ―Yeje ciento mbëxo tjõmëch'i, dya ra zöji, zö rá xënji nde ri nde'eji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nuc'ua o ña c'ua 'naja c'o o̱ discípulo c'ü mi ngueje e Andrés c'ü nu cjuarma e Simón Pedro, o xipji e Jesús: ");
INSERT INTO mazNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Bübü va 'naja t'i, nu jün tsi'ch'a tjõmëch'i ndëxü, cja na yeje jmõ'õ. Pero, ¿ja ra zö texeji? Na puncjüji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nuc'ua o mama e Jesús, o xipji c'o o̱ discípulo: ―Nudya, xipjiji ra mimi dya, yo nte'e. Mi cja na puncjü o pjindyo nu ja mi cãrãji. O mimiji c'ua. Po mi tsi'ch'a mil o bëzo. ");
INSERT INTO mazNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nuc'ua o jñü c'o tjõmëch'i e Jesús. Cjanu o unü 'na pöjö Mizhocjimi. Nuc'ua, cjanu o unü c'ua c'o o̱ discípulo. Nuc'ua c'o o̱ discípulo o unüji c'o ya vi mimi. Ya nde unüji c'ua c'o jmõ'õ. O zi'iji. O ziji texe c'o mi neji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","O nijmiji na jo. O xipji c'ua e Jesús c'o o̱ discípulo: ―Tsis'iji yo ya mboncjü, yo nde ndetjo, ngue c 'ua dya pje ra nguejme. ");
INSERT INTO mazNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","O jmutüji c'ua c'o nde mi ndetjo. O nizhi doce cánista nu c'o tsi'ch'a tjõmëch'i ndëxü. Nuc'o, ngue c'o o mboncjü c'o vi ziji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nuc'ua c'o nte 'ma o jñandaji c'o vi tsja'a e Jesús mi mamaji: ―Na cjuana ngueje ne profeta nu ro ẽjẽ cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","O mbãrã e Jesús mi neji ro zidyiji ngue c'ua ro tsjapüji a fuerza ro manda. Nguec'ua va xõgü e Jesús o matsjë na yeje cja 'na t'eje. ");
INSERT INTO mazNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nuc'ua 'ma ya o nzhä'ä, ya o zöbü c'ua c'o o̱ discípulo, o zät'äji cja c'e zapjü. ");
INSERT INTO mazNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Cjanu o dat'üji cja 'naja bü'ü. Je mi möji nu 'nanguarü c'e ndeje a ma Capernaum. Ya vi xõmütjo. E Jesús dya be ma säjä nu ja mi bübü anguesji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Me mi pjõ's'ü c'e ndeje na ngueje mi vü na zëzhi e ndajma. ");
INSERT INTO mazNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","'Ma ya vi möji tsi'ch'a o 'ñanto kilometro o jñandaji e Jesús c'ü mi nzhodü xes'e e ndeje. Ya mi ngue ro zät'ä cja c'e bü'ü. Me co zũji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nuc'ua e Jesús o xipjiji: ―Nguetscö e Jesús. Dya rí sũgueji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nuc'ua anguesji o mäjäji. O xipjiji c'ua e Jesús ro dat'ü cja c'e bü'ü. Exo zät'ä c'ua c'e bü'ü cja c'e jñiñi nu ja je mi möji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Mi cãrã c'o nte c'o vi nguejme 'nanguarü c'e trazapjü nu ja vi unü 'na pöjö Mizhocjimi e Jesús cjanu unüji o tjõmech'i c'o o ziji. Anguezeji vi unüji ngüenda c'ü mi 'natjo bü'ü c'ü mi järä c'e xõmü. Y 'ma vi dat'ü c'o discípulo cja c'e bü'ü, dya dat'ü e Jesús co anguezeji, nguec'ua c'o discípulo vi mötsjëji. Nguec'ua c'ü na yejnu pa c'o nte mi jodüji e Jesús, pero dya o chöt'üji. Dya xo jñandaji c'o o̱ discípulo. Nguec'ua como vi säjä ja nzi bü'ü c'o vi 'ñeje a Tiberias, o tsja c'ua c'o nte o dat'üji cja c'o bü, o möji c'ua a Capernaum o ma jyodüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","'Ma o chöt'üji a Capernaum nu 'nanguarü cja e ndeje o xipjiji: ―Xöpüte, ¿jinguã i̱ säjägue a 'ñecjua? ");
INSERT INTO mazNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","O ndünrü c'ua e Jesús: ―Na cjuana c'ü rí xi'ts'igöji. Ró da'c'eji tjõmëch'i ngue c'ua ri unnc'eji ngüenda c'ü ngue o̱ T'izgö Mizhocjimi, ngue c'ua ri 'ñejmezüji. Pero c'ü va 'ñe jongöji, dya ngue para rí 'ñejmezüji. Ngue c'ü i̱ṉ neji rá da'c'üji na yeje c'o ra nijmi in pjemeji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","C'e jñõnü c'ü rí sigöji, tjezetjo c'ü. Nguec'ua, dya me rí jyonnc'eji c'o. Jyodüji c'e jñõnü c'ü dya ra tjeze, c'ü sido rí bübütjoji. Nutscö rvá ẽcjö cja Mizhocjimi, nguetscö rá da'c'üji c'e jñõnü c'ü sido rí bübütjoji. Mizhocjimi c'ü mi Tatagö ya jizhi c'ü o ndäcjä rá da'c'eji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","O ndünrü c'ua c'o nte o xipjiji e Jesús: ―¿Pje rá cjajme ngue c'ua rá cjajme c'ü ne'e Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","O ndünrü c'ua e Jesús. O xipjiji: ―Nunu, ngueje c'ü ne Mizhocjimi: rí 'ñejmezügöji na ngueje o ndäcjä angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","O xipjiji c'ua: ―¿Pje na mbë c'o rí jítscöjme ngue c'ua rá jandagöjme; ngue c'ua rá ejmets'üjme? ¿Pje na mbëjë c'o rí tsjague? ");
INSERT INTO mazNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","C'o ín mboxtitaji o ziji o maná nu cja ndajyadü, 'ma mi cãrãji nu, co e Moisés. C'ua ja nzi ga t'opjü: “O unüji ro ziji tjõmëch'i c'o vi 'ñeje a jens'e”, eñe. ¿Cjo xo sö rí tsjague a cjanu? ");
INSERT INTO mazNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","O ndünrü c'ua e Jesús, o xipjiji: ―Na cjuana c'ü rí xi'ts'iji. E Moisés dya ngue c'ü o dya'c'üji o tjõmëch'i c'o vi 'ñeje a jens'e; ngue mi Tatagö. C'e tjõmëch'i c'ü o zi c'o ín mboxtitaji, dya ngue c'ü exna cjuana ni muvi. Mi Tatagö je unü c'e tjõmëch'i c'ü exna cjuana ni muvi c'ü vi 'ñeje a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na ngueje o̱ tjõmëch'i Mizhocjimi ngueje c'ü vi 'ñeje a jens'e c'ü unü c'ü ra bübütjo yo cãrã texe cja ne xoñijõmü, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","O xipjiji c'ua: ―Nu'tsc'e nin t'ecjañumü, sido rí dyacöjme ne tjõmëch'i nu. ");
INSERT INTO mazNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","E Jesús o xipjiji: ―Nuzgö, nguetscö e tjõmëch'i c'ü ra dya'c'eji c'ü rgui bübütjogueji. Nu c'ü ra ẽjẽ co nuzgö, dya ra zant'a. Nu c'ü ra 'ñejmezügö, dya ra ndũre. ");
INSERT INTO mazNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ya ró xi'ts'iji, zö xi i̱ jñandgaji ró cjagö c'ü na nojo, pero dya pje i̱ṉ ejmezügöji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Texe nu c'o dacügö mi Tata, ra ẽjẽji co nutscö ra 'ñejmezüji. Nuzgö, dya rá täjägö ra ma c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Rvá ẽjẽgö a jens'e; dya pje ngue c'ü rá cjagö c'ü rá ne'e. Rá cja'a c'ua ja ga ne'e mi Tatagö c'ü o ndäcjä. ");
INSERT INTO mazNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nunu, ngueje c'ü ne'e Mizhocjimi, nu c'ü o ndäcjä; ne'e c'ü dya rá bëzhi ne ri 'naja c'o o dyacü. 'Ma rá ẽcjö na yeje rá xos'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nunu, ngueje c'ü ne'e mi Tata c'ü bübü a jens'e: texe c'o unü ngüenda nguezgö o̱ T'izü Mizhocjimi, y ejmezügöji, ra ch'unü c'ü rguí bübütjoji co Mizhocjimi. 'Ma rá ẽcjö na yeje rá xos'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","C'o pje mi pjëzhi cja c'o nte a Israel mi pötma mamatsjëji na ngueje dya mi ejmeji c'ü vi mama e Jesús: “Nguetscö e tjõmëch'i c'ü vi 'ñeje a jens'e.” ");
INSERT INTO mazNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mi mamaji c'ua: ―Nunu, ¿cjo dya ngueje e Jesús nu o̱ t'i e José? Nu tata 'ñe nu nana rí pãrãgöji. Nunu, ¿jenga mama dya nu: “Rvá ẽjẽ a jens'e”? ");
INSERT INTO mazNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","E Jesús o xipjiji c'ua: ―Dya rí pötqui mamatsjëgueji yo. ");
INSERT INTO mazNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dya cjó sö ra ẽjẽ co nutscö nu 'ma dya ra 'ñünbü o̱ mü'bü mi Tata c'ü bübü a jens'e c'ü o ndäcjä. Nuzgö, 'ma rá ẽcjö na yeje rá xos'ü nu c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ya t'opjü cja o̱ jña Mizhocjimi c'o o dyopjü c'o profeta: “Mizhocjimi ra nda xöpüji.” A cjanu texe c'o ätä mi Tata, 'ñe pãrãji pje pjëzhi c'ü mama, va ẽji co nutscö. ");
INSERT INTO mazNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Zö ätpäji o̱ jña Mizhocjimi, pero dya jandaji ja ga jmi. C'ü o jñanda nguextjozügö rvá ẽjẽgö cja Mizhocjimi. Nguezgö ró janda mi Tata. ");
INSERT INTO mazNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na cjuana c'ü rí xi'ts'igöji, nu c'ü ejmezügö ra ch'unü c'ü rguí bübütjo co Mizhocjimi para siempre. ");
INSERT INTO mazNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nguetscö e tjõmëch'i ngue c'ua rí bübütjogueji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nu c'o nin mboxtitaji o ziji c'e maná nu cja ndajyadü. Pero o ndũ'ũ c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nguetscö nu e tjõmëch'i nu vi 'ñeje a jens'e. Nguec'ua nu c'ü ra zi'i nu, dya ra ndũ'ũ, ra bübütjo. ");
INSERT INTO mazNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Exi rgá büntcjö, nguec'ua sö rá da'c'üji c'ü rí bübütjogueji. Je rvá ẽjẽgö a jens'e. 'Ma cjó c'o ra zi'i nu e tjõmëch'i ra ch'unü c'ü rguí bübütjo. Ne tjõmech'i c'ü rá unügö nu, ngueje ín cuerpogö. Nuzgö rá unügö ngue c'ua ra bübütjo yo cãrã texe cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nuc'ua c'o pje mi pjëzhi cja c'o nte a Israel mi ña, mi ñatsjëji. Mi mamaji: ―¿Ja rgá sö ra dyacöji o̱ cuerpo rá siji? ");
INSERT INTO mazNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","E Jesús o xipjiji: ―Na cjuana c'ü rí xi'tsc'öji. Nutscö rvá ẽcjö cja Mizhocjimi. 'Ma dya rí si'iji ne tjõmëch'i c'ü ngueje ín cuerpogö, 'ñe 'ma dya rí si'iji ín tsjigö, dya rí bübüji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nu c'o ra zi'i e tjõmëch'i c'ü ngueje ín cuerpogö 'ñe ra zi ín tsjigö ra ch'unü c'ü rguí bübütjoji. Nutscö 'ma rá ẽcjö na yeje rá xos'ü nuc'o. ");
INSERT INTO mazNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","C'e jñõnü c'ü na cjuana c'ü rí siji ngue ín cuerpogö c'ü; 'ñe ín tsji'igö. ");
INSERT INTO mazNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nu c'ü ra zi nu e jñõnü c'ü ngueje ín cuerpogö, 'ñe ra zi ín tsjigö ra bübüzügö. Y nutscö je rá bünc'ö cja o̱ mü'bü angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mi Tata c'ü o ndäcjä exi bübütjo c'ü. Nguec'ua exo rgá bübütjogö. Nu c'ü ra zi c'e jñõnü c'ü ngue ín cuerpogö 'ñe ín tsjigö, xo ra bübütjo, na ngueje exi rgá büntcjö. ");
INSERT INTO mazNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nguetscö e tjõmëch'i, rvá ẽjẽgö a jens'e. Dya nza cjazgö c'e maná c'ü o zi ín mboxtitaji. Nuc'o, o ndũ c'o. Pero c'ü ra zi'i nu e tjõmëch'i c'ü nguetscö, dya ra ndũ, ra bübütjo co Mizhocjimi para siempre. ");
INSERT INTO mazNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nu yo jña'a yo, o mama e Jesús 'ma mi bübü a Capernaum 'ma mi xöpü c'o nte cja c'ü o̱ nintsjimiji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na puncjü c'o mi tjünt'ü a xütjü e Jesús, 'ma o dyäräji, o mamaji: ―Me na jyü yo jña'a yo. ¿Cjó ra sö'ö ra dyätä yo? ");
INSERT INTO mazNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","O mbãrãtsjë e Jesús c'o mi mamatsjëji. O xipjiji c'ua: ―¿Cjo i̱ṉ ne rí chjench'eji a xütjü na ngueje ró xi'ts'iji yo jña'a yo? ");
INSERT INTO mazNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Pje rí tsjagueji 'ma, 'ma rí jñandgaji rá magö a jens'e nu ja ot'ü rmí bünc'ö? Nutscö rvá ẽcjö cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ngueje o̱ Espíritu Mizhocjimi c'ü da'c'üji rí bübüji. Dya pje ni muvi e cuerpo. Yo jña'a yo rí xi'ts'igöji je va ẽjẽ cja o̱ Espíritu Mizhocjimi yo. Ngueje yo da'c'üji rí bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero bübüts'ügueji c'o dya pje ejmezügö. E Jesús ya mi pãrã ndeze 'ma ot'ü cjó ngue c'o dya mi ejme. Ya nde mi pãrãtjo cjó ngueje c'ü ro nzhö'ö. ");
INSERT INTO mazNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","O mama c'ua e Jesús: ―Ya ró xi'ts'iji, dya cjó ra sö ra ẽjẽ co nuzgö, 'ma dya ra 'ñünbü o̱ mü'bü mi Tata c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","'Ma o nguarü o mama yo jña'a, na puncjü c'o o chjench'e a xütjü, dya cja o ndünt'üji o̱ xütjü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","O mama c'ua e Jesús o xipji c'o doce discípulo: ―¿Cjo xo i̱ṉ ne rí chjench'eji a xütjü, c'ü dya cja rí chjünt'üji ín xütjügö? ");
INSERT INTO mazNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","O ndünrü c'ua e Simón Pedro: ―Pero ín Jmuts'üjme, ¿cjó rá ma teñegöjme? Na ngueje nguextjots'ügue i̱ṉ xitsijme ja rga sö rá bübütjojme co Mizhocjimi para siempre. ");
INSERT INTO mazNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nutscöjme rí ejmets'ügöjme. Rí pãrãjme ngue'tsc'e e Cristo. Ngue'tsc'e o̱ T'its'ü Mizhocjimi c'ü exi bübütjo. ");
INSERT INTO mazNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","O ndünrü c'ua e Jesús: ―I̱ṉ doceji. ¿Cjo dya ró juan'c'ügöji? 'Najats'ügueji bübü c'ü dya jo cja o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nu c'ü mi mama e Jesús, mi ngueje e Judas Iscariote, c'ü mi ngue o̱ t'i e Simón. Na ngueje nguejnu ro nzhö'ö e Jesús. Mi ngueje 'naja c'o doce discípulo. ");
INSERT INTO mazNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","'Ma o nguarü yo, mi nzhodü e Jesús a Galilea. Dya mi ne ro nzhodü a Judea, na ngueje mi cãrã nu, c'o mi ne ro mbö't'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ya mi ngue ro zädätjo 'na mbaxua c'ü mi cja c'o nte. Mi ät'äji ts'ingumü c'o mi ngueje o dyëza. Mi mimiji cja c'o ts'ingumü 'ma mi cjaji c'e mbaxua. ");
INSERT INTO mazNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","C'o o̱ cjuarma e Jesús o xipjiji c'ua: ―Na jo rí pedyegue va. Mague a Judea ngue c'ua c'o in discípulo c'o cãrã nu, xo ra jñantc'aji yo i̱ṉ cjague yo me na nojo. ");
INSERT INTO mazNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nu c'ü ne'e pje ra tsja'a, ra tsja ngue c'ua ra jñanda yo nte. Nu 'ma i̱ṉ cja'a yo me na nojo, jizhitsjëjë ngue c'ua ra jñanda texe yo nte. ");
INSERT INTO mazNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ne xo ri ngueje c'o o̱ cjuarma, dya xo mi ejmeji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","O mama c'ua e Jesús: ―Dya be va sädä nu 'ma ra mbãrãji cjó nguetscö. Nuzgö dya be sö'ö rá magö. Pero nu'tsc'eji sö rí mötjoji nu hora c'ü i̱ṉ ne rí möji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nu'tsc'eji, dya sö ra nuc'eji na ü yo cãrã cja ne xoñijõmü. Nguetscö je nugüji na ü, na ngueje rí xipjigöji c'ü na cjuana, rí xipjigöji me na s'o cjaji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nu'tsc'eji, möji cja c 'e mbaxua. Nutscö dya be rá magö cja c'e mbaxua, na ngueje dya be va sädä c'ü ne'e Mizhocjimi c'ü ya rá magö. ");
INSERT INTO mazNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nu 'ma o mama yo, xe o nguejmetjo a Galilea. ");
INSERT INTO mazNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nuc'ua o ma cja c'e mbaxua c'o o̱ cjuarma. E Jesús xo ma'a c'ua. Pero nuc'ü, dya cjó o xipji ja va ma. O matsjëjë. ");
INSERT INTO mazNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nu cja c'e mbaxua, c'o pje mi pjëzhi cja c'o nte mi jodüji e Jesús, mi mamaji: ―¿Ja je ri bübüxã c'e Jesús?, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na puncjü nte c'o me mi tsjojne mi mamaji ja cja mi cja e Jesús. Mi cãrã c'o mi mama: “Na jonte c'e bëzo c'ü.” Nu c'o dyaja mi mamaji: “Dya jonte c'ü. Onpü yo nte.” ");
INSERT INTO mazNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","C'o nte mi sũji c'o pje mi pjëzhi. Nguec'ua dya cjó mi mama na jo ja ma cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Cja mi patjo nziyo pa'a c'ü mi cjaji c'e mbaxua. Xe mi bëzhi nziyo pa ro nguarü. O zät'ä c'ua e Jesús cja c'e templo. Ya je nguejnu o xöpü c'ua c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","C'o pje mi pjëzhi mi cjijñiji: “Nunca rí ärägöji a cjanu.” Pero mi mamaji: ―¿Ja ga mbãrã yo? Dya o ma ja ro xörü. ");
INSERT INTO mazNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","O ndünrü c'ua e Jesús: ―Nu yo rrã xöpü yo nte, dya rí mamatsjëjëgö yo. Nu c'ü o ndäcjägö ngue c'ü je o xöcügö c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","'Ma cjó c'o ne ra tsja'a c'ü ne'e Mizhocjimi, ra mbãrã cjo je va ẽjẽ cja Mizhocjimi yo rí xöpügö yo nte, o maxque rí mamatsjëjëgö yo. ");
INSERT INTO mazNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nu c'ü xöpü c'ü mamatsjëjë, jodütsjëjë c'ü ra mama yo nte: “Me na jo 'na xöpüte”, ra 'ñeñeji. Nuzgö rí jodügö c'ü ra mamaji me na jo Mizhocjimi c'ü o ndäcjä. Nuzgö rí mamagö c'ü na cjuana, dya bëchjine. ");
INSERT INTO mazNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Nu'tsc'eji, ¿cjo dya o dya'c'üji c'e ley e Moisés? Pero ne ri 'najats'ügueji dya i̱ṉ cjaji c'ü mama c'e ley. Maco mama c'e ley c'ü dya rá pö't'üteji, ¿jenga i̱ṉ jongügöji rí pötcüji? ");
INSERT INTO mazNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","O ndünrü c'ua c'o nte, o xipjiji: ―Nu'tsc'e, bübü demonio cja in mü'bügue. ¿Cjó ngue c'ü ra jyonc'ü ra mbö'tc'ü? ");
INSERT INTO mazNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","O ndünrü c'ua e Jesús: ―'Natjo c'ü ró cjagö, pero nuc'ua texets'üji me o sjëyats'üji c'ü ró cjagö. ");
INSERT INTO mazNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Cja o̱ ley Mizhocjimi c'ü o dyopjü e Moisés, xi'ts'iji rí meyaji in cuerpoji. C'ü ni tsjaji a cjanu, dya ngue e Moisés c'ü o mbürü; ngueje c'o ín mboxtitaji c'o o mbürü ndeze mi jinguã. Bübü 'ma i̱ṉ meyaji in cuerpoji nu pa c'ü rí söyaji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nu pa c'ü rí söyaji i̱ṉ meyaji o̱ cuerpo 'na bëzo ngue c'ua rí cumpleji o̱ ley Mizhocjimi c'ü o dyopjü e Moisés. ¿Jenga me i̱ṉ ünngügöji c'ü ró jopcügö texe o̱ cuerpo 'na bëzo nu pa c'ü rí söyaji? ");
INSERT INTO mazNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tsjijñiji na jo c'ua ja ga mama o̱ ley e Moisés. Nuzgö, zö ró jocü 'na bëzo c'e pa c'ü rí söyagöji, pero na jo c'ü rvá cjagö. ");
INSERT INTO mazNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ja nzi c'o mi menzumü a Jerusalén o mamaji c'ua: ―Nujnu, ¿cjo dya ngueje nu jodüji ra mbö't'üji? ");
INSERT INTO mazNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Maco, ña'atjo dya nu. Dya pje sũ'ũ nu. Dya cjó pje xipji. Mbãrã, c'o pje pjëzhi, ¿cjo ri cjijñiji c'ü ngueje e Cristo nu? Po jiyö. ");
INSERT INTO mazNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Na ngueje nutscöji rí pãrãgöji na jo ja je menzumü nu. 'Ma ra ẽjẽ e Cristo, nuc'ü, dya cjó ra mbãrã ja rguí 'ñeje. ");
INSERT INTO mazNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","E Jesús o ña'a na jens'e nu cja c'e templo nu ja mi xöpü c'o nte, o xipjiji: ―Nu'tsc'eji, ¿cjo i̱ṉ pãcãji? ¿Cjo i̱ṉ pãrãji na jo ja je rí menzumü? Nuzgö dya ró ẽtsjëjëgö. Na ngueje bübü 'naja c'ü exna cjuana o ndäcjägö, c'ü dya i̱ṉ pãrãgueji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero nuzgö rí pãrãgö c'ü, na ngueje je rvá ẽcjö cja angueze. Ngueje angueze o ndäcjägö ró ẽjẽ a 'ñecjua. ");
INSERT INTO mazNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nuc'ua, mi ne ro zürüji c'ua. Pero dya cjó o pënch'i, na ngueje dya be ne Mizhocjimi ro zürüji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na puncjü c'o nte c'o mi cãrã nu, o 'ñejmeji e Jesús. Mi mamaji: ―Dya cjó sö ra tsja c'o xe rrã nojo. ¿Cjo ri ngueje e Cristo nu? ");
INSERT INTO mazNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","C'o fariseo o dyäräji c'ua c'o mi mama c'o nte. Na ngueje c'o nte mi tsjojne ma ñaji c'o mi cja'a e Jesús. Nuc'ua c'o ndamböcjimi 'ñe c'o fariseo o ndäjäji o policía ro ma, ro ma zürüji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","O mama c'ua e Jesús: ―Xe quejme ja nzi zana c'ü xe rá mimiji. Nuc'ua ra zädä c'e pa 'ma rá ma nu ja bübü c'ü o ndäcjä ró ẽjẽ. ");
INSERT INTO mazNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nuc'ua rí jyongügöji. Dya cja rí chöcügöji. Nu ja rá bübügö, dya sö rí möcjeji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nuc'ua c'o pje mi pjëzhi cja c'o nte a Israel o pötva mamaji: ―Mbãrã, ¿ja je ra ma'a nu? ¿Jenga xitsiji c'ü dya cja rá töt'üji? Mbãrã, ¿cjo je ra ma cja yo ín menzumügöji a Israel c'o pjöt'ü cja yo dyaja nte? Mbãrã, ¿cjo ra ma xöpü c'o dyaja nte'e? ");
INSERT INTO mazNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mbãrã, ¿ja cja'a nu o mama: “Rí jyongüji pero dya rí chöcüji”? Xo o xitsiji: “Nu ja rá bübügö, dya pje ra sö'ö rí sät'äji.” ");
INSERT INTO mazNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","C'e pa c'ü bëpja c'e mbaxua ngue c'ü xenda mi sũpüji. Nuc'ua c'e pa'a c'ü, o böbü e Jesús. O zopjü c'ua c'o nte, o xipjiji: ―'Ma cjó c'o tũre, xä'däji co nutscö. Si'iji c'e ndeje c'ü rá da'c'üji rí siji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nu c'o ra 'ñejmezügö, ra zädä anguezeji c'ua ja nzi ga mama cja o̱ jña Mizhocjimi: A mbo cja o̱ mü'bü ra chjëntjovi nza cja 'na mbereje c'ü peje na puncjü o ndeje. Nguec'ua xo ra zi'i c'o dyaja, ngue c'ua xo ra bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nujyo o mama e Jesús, nguejyo ro tsja o̱ Espíritu Mizhocjimi c'ü ro ch'unü nu c'o ro 'ñejme e Jesús. C'e Espíritu dya be ma ẽjẽ c'ü, na ngueje dya be vi ma e Jesús cja nu Tata c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nuc'ua 'ma o dyäräji yo jña'a yo, mi cãrã c'o o mama: ―Nunu, na cjuana ngueje e profeta nu mi te'beji. ");
INSERT INTO mazNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dyaja c 'o o mama c'ua: ―Ngueje e Cristo nu o ndäjä Mizhocjimi nu. Mi cãrã c'o dyaja c'o o mama: ―Nujnu je menzumü a Galilea. Nguec'ua, ¿ja rgá sö ra tsja e Cristo nu? ");
INSERT INTO mazNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na, ¿cjo dya mama cja yo ya t'opjü: “E Cristo je ri ngueje o̱ mboxbëche e David”? ¿Cjo dya xo mama: “Je ra te'e cja c'e ts'ijñiñi a Belén nu ja mi menzumü e David”? ");
INSERT INTO mazNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nuc'ua a cjanu, o xõgü c'ua c'o nte'e, na ngueje dya mi 'natjo o̱ pjeñeji ma nguijñiji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mi cãrã c'o mi ne ro zürü e Jesús. Pero dya cjó xo o pënch'i angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nuc'ua c'o policía o nzhogü c'ua c'o. O möji cja c'o ndamböcjimi 'ñe cja c'o fariseo. Nuc'ua c'o ndamböcjimi 'ñe c'o fariseo o dyönüji c'ua: ―¿Jenga dya i̱ siji e Jesús? ");
INSERT INTO mazNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","O ndünrü c'ua c'o policía: ―Nunca rí ärjme ra ña 'na bëzo c'ua nzi ga ña'a c'e bëzo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","O ndünrü c'ua c'o fariseo, o xipjiji c'o policía: ―¿Cjo ya xo o dyon'c'ügueji? ");
INSERT INTO mazNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tsjijñiji dya xã. ¿Cjo ya xo bübü o jmu'u 'ñe o fariseo c'o ya o 'ñejme e Jesús? Iyö. ");
INSERT INTO mazNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nu yo nte'e yo, dya pje pãrãji o̱ ley Mizhocjimi. Dya pje sö ra zät'äji a jmi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","E Nicodemo nu c'ü vi ma'a 'na nu xõmü cja e Jesús, mi ngueje 'naja c'o fariseo. O mama angueze: ");
INSERT INTO mazNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Cja ín leygöji, dya sö rá mamaji c'o na s'o vi tsja 'na bëzo c'ü dya be ri äräji c'o mama angueze, y c'ü dya be ri pãrãji ja cja c'ü cja'a. ");
INSERT INTO mazNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","O ndünrü c'ua c'o fariseo, o xipjiji e Nicodemo: ―Nu'tsc'e, Nicodemo, ¿cjo xo i̱ṉ menzumügue a Galilea? Ni jyodü rí ñu'u yo ya t'opjü, ngue c'ua rí ñuxã c'ü dya cjó ra te'e a Galilea c'ü ri ngueje profeta. ");
INSERT INTO mazNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nuc'ua, como ya vi nguarü c'e mbaxua, o ma nzi 'najaji o̱ ngumüji. ");
INSERT INTO mazNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","E Jesús o ma c'ua cja c'e t'eje c'ü ni chjũ Olivos. ");
INSERT INTO mazNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nuc'ua 'ma mi xõrtjo c'ü na yejnu pa, e Jesús o ma na yeje cja c 'e templo. Nuc'ua texe c'o nte'e o chëzhiji a jmi e Jesús. O mimi c'ua e Jesús. Cjanu o xöpü c'ua c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nuc'ua c'o mi xöpü o̱ ley Mizhocjimi 'ñe c'o fariseo o sinpiji c'ua 'naja ndixũ c'ü vi ch'ö'tp'ü bëzo c'ü dya mi ngueje o̱ xĩra. O tsjapüji o mimi a nde'e nu ja mi bübü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","O mamaji c'ua: ―Xöpüte, nu e ndixũ nu, o zürüji. Mi bübüvi 'na bëzo c'ü dya ngueje o̱ xĩra. ");
INSERT INTO mazNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Cja c'e ley c'ü o dyopjü e Moisés o mandazüji rá pjat'üji ndojo yo cja a cjanu. ¿Nu'tsc'e dya, pje rí xitsijme dya? ");
INSERT INTO mazNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nu yo mi xipjiji nguetjo ma söji, ngue c'ua ro sö ro ngöt'üji cja c'o pje mi pjëzhi. Nuc'ua e Jesús o ñücü a jõmü. O dyopjü c'ua a jõmü co o̱ ñidyë. ");
INSERT INTO mazNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nu 'ma sido mi önütjoji, o jñüs'ü o̱ ñi'i. Cjanu o xipjiji c'ua: ―'Ma bübütsc'eji 'naja c'ü dya tũ o̱ nzhubü ngue c'ü ra ot'ü ra pjat'ü ndojo ne ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nuc'ua o ñücütjo na yeje a jõmü e Jesús. O dyopjü a jõmü co o̱ ñidyë. ");
INSERT INTO mazNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","'Ma o dyäräji, o nguijñiji c'ua cja o̱ mü'büji c'ü mi tũji o̱ nzhubüji. Nuc'ua nde 'naja va möji c'ua. Nu c'o xenda mi tita ngue c'o ot'ü o ma c'o. Cjanu o mbedye c'ua c'o cja mi t'i'i. Nuc'ua ya o nguejmetsjë c'ua e Jesús 'ñe c'e ndixũ c'ü mi junrü a jmi. ");
INSERT INTO mazNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nuc'ua cjanu o jñüs'ü c'ua o̱ ñi'i e Jesús. Dya cjó cja o jñanda. Ya mi nguetjo c'e ndixũ c'ü xe mi bübü. O xipji c'ua: ―Nu'tsc'e ndixũ, ¿ja je cãrã dya, nu c'o mi mama i̱ṉ tũgue nzhubü? ¿Cjo dya cjó pja'c'ü ndojo? ");
INSERT INTO mazNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","C'e ndixũ o ndünrü: ―Nu'tsc'e, ín Jmuts'ügö, dya cjó pjacö ndojo. Nuc'ua o xipji e Jesús: ―Ne xo ri nguetscö, dya xo rí xi'ts'i ni jyodü rí chũgue. Ma'a dya. Pero dya cja rí tsja c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","E Jesús o zopjütjo na yeje c'o nte. O xipjiji: ―Nguetscö e jya's'ü cja ne xoñijõmü. Nu c'ü ra ndünt'ü ín xütjügö, dya ra nzhodü cja e bëxõmü. Nuc'ü, ra bübü jya's'ü o̱ mü'bü c'ü ra unü c'ü rguí bübütjo. ");
INSERT INTO mazNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nuc'ua c'o fariseo o xipjiji: ―Nu'tsc'e i̱ṉ mamatsjëgue pje pjë'ts'i. Nu c'o i̱ṉ mamague dya cjuana. ");
INSERT INTO mazNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","O ndünrü c'ua e Jesús, o xipjiji: ―Zö rí mamatsjëgö pje pjëtsi, pero yo rí xi'ts'igöji na cjuana. Na ngueje rí pãrãgö ja je rvá ẽjẽ, 'ñe ja rga ma'a. Nu'tsc'eji, dya i̱ṉ pãrãgueji ja rvá ẽjẽgö. Dya xo i̱ṉ pãrãji ja ngue c'ua rá ma'a. ");
INSERT INTO mazNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nu'tsc'eji c'ua ja nzi gui tsjinncjeji, i̱ṉ jünji ngüenda i̱ṉ mamaji c'ü na s'ozgö. Pero nutscö, c'ü rvá ẽcjö, dya ngue c'ü rá mangö c'ü cja na s'o 'naja, y c'ü cja na jo c'ü 'naja. ");
INSERT INTO mazNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Zö dya ngue c'ü rvá ẽcjö, pero 'ma rí mangö ja ga cja 'na nte ga nguijñi o̱ mü'bü, na cjuana c'ü rí mangö. Na ngueje c'ü rí mangö, dya ngue c'ü rgá cjijñitsjëgö, ngue c'ü cjijñi Mizhocjimi c'ü o ndäcjö c'ü rí bübübe. ");
INSERT INTO mazNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ya xo t'opjü cja in leygueji c'ü je mama a cjava: “Nu c'ü mama yeje nte ngue c'o na cjuana.” ");
INSERT INTO mazNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nuzgö rí mama pje pjëtsi. Nu c'ü mi Tatagö c'ü o ndäcjä, ngue c 'ü xo mama pje pjëtsigö. ");
INSERT INTO mazNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nuc'ua o xipjiji c'ua: ―¿Ja je bübü c'ü nin Tata? O ndünrü c'ua e Jesús, o xipjiji: ―Ni xo ri nguetscö i̱ṉ pãcãji, ni ri ngueje mi Tata i̱ṉ pãrãji. Nu 'ma ri pãcãgöji, ngue 'ma xo ri pãtcãji mi Tata. ");
INSERT INTO mazNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","E Jesús mi xöpü c'o nte cja c'e templo. Je mi mama yo jña'a yo, nu ja mi sogüji o̱ ofrendaji. Dya cjó o zürü e Jesús, na ngueje dya be mi jëzi c'ü nu Tata Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nuc'ua o ndünrü c'ua na yeje e Jesús: ―Nutscö ya rá ma'a. Nu'tsc'eji rí jyongüji. Pero rí chũgueji na ngue c'o in nzhunc'eji c'o i̱ṉ tũgueji. Nguec'ua nu ja je rá magö, nu'tsc'eji, dya ra sö rí sät'äji nu. ");
INSERT INTO mazNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","O mama c'ua c'o pje mi pjëzhi cja c'o nte a Israel: ―Nu e bëzo nu, ¿cjo ra pö't'ütsjëjë? Nguec'ua mama: “Nu ja je rá magö, nu'tsc'eji dya ra sö rí sät'äji.” ");
INSERT INTO mazNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nuc'ua o ndünrü c'ua e Jesús: ―Nu'tsc'eji, i̱ṉ menzumüji a jõmü. Nutscö, je rí menzumügö a jens'e. Nu'tsc'eji, i̱ṉ menzumügueji cja ne xoñijõmü. Nutscö, dya pje rí menzumügö va cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nguec'ua ró xi'ts'iji: “Rí chũgueji na ngue c'o in nzhunc'eji c'o i̱ṉ tũgueji.” Na ngueje 'ma dya rí 'ñejmeji nguezgö extí bübü, c'o nzhubü c'o i̱ṉ tũji ngue c'o je rgui chũji c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","O ndünrü c'ua c'o nte: ―Xitsijme cjó ngue'tsc'e. Nuc'ua e Jesús o xipjiji: ―Ya ró xi'ts'igöji cjó nguezgö. ");
INSERT INTO mazNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na puncjü c'o me rí ne rá zo'c'üji. Me na puncjü c'o i̱ṉ cjaji c'o sö rá mama i̱ṉ tũgueji nzhubü. Pero nu c'ü o ndäcjägö ngue c'ü na cjuana c'ü. C'o ró ätpägö o mama angueze nguejyo je rí zopjü yo cãrã cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","E Jesús mi xipjiji mi nguejnu Tata c'ü vi ndäjä. Pero dya mi pãrã c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","O ndünrü c'ua e Jesús: ―Nutscö rvá ẽcjö cja Mizhocjimi. Nu'tsc'eji rí chäpcöji cja ngronsi. Nu'ma, cja ra zädä 'ma rí unnc'eji ngüenda c'ü nguezgö extí bübü. Dya pje rí cjagö c'ü rí cjatsjë. Ngue yo o xöcü mi Tata, yo rí xi'ts'iji. ");
INSERT INTO mazNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nu c'ü o ndäcjä bübü co nuzgö. Dya pje jyëzguigö c'ü rá bübütsjëgö c'ü, na ngueje sido rí cjagö c'o ne angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","'Ma o mama yo jña'a yo, na puncjü c'o o creo c'o mi mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","O xipji c'ua e Jesús c'o nte a Israel c'o ya vi 'ñejme angueze: ―'Ma sido rí 'ñejmeji yo jña yo rí ña'a, nu'ma, na cjuana i̱ṉ ätcöji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","'Ma rí 'ñejmezügöji yo jña yo rí ña'a, rí pãrãji c'ü na cjuana 'ma. 'Ma rí pãrãji c'ü na cjuana, ra t'empc'eji libre 'ma. ");
INSERT INTO mazNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","O ndüntüji c'ua, o xipjiji: ―Nguetscöjme o̱ mboxbëchejme e Abraham. Dya cjó rí pëpcöjme. ¿Jenga i̱ṉ mamague c'ü ra 'ñempcöjme libre? ");
INSERT INTO mazNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","O ndünrü e Jesús, o mama: ―Na cjuana c'ü rí xi'ts'iji. Texe c'o cja'a c'o na s'o, dya libre c'o. Chjëntjovi nza cja 'na mbëpji c'ü tjünt'ü a xütjü, c'ü dya sö ra xõgü cja nu lamu. ");
INSERT INTO mazNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","C'o tjünt'ü a xütjü o nzhubü, dya ngueje o̱ t'i Mizhocjimi c'o. Angueze ra pjongü nu c'o dya ngueje o̱ t'i. C'o o̱ t'i ra sido ra bübütjoji co Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nu c'ü na cjuana ra 'ñempc'eji libre cja c'o na s'o, nguetscö o̱ T'izü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Rí pãrãgö ngue'tsc'eji o̱ mboxbëchets'üji e Abraham. Pero i̱ṉ ne rí pötcügöji, na ngueje ín jñagö, dya pje i̱ṉ ench'e cja in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Rí ñagö nu c'o ró nugö cja o̱ jmi mi Tatagö c'ü bübü a jens'e. Nu'tsc'eji i̱ṉ cjaji nu c'o i̱ dyäräji cja o̱ jmi nin tataji. ");
INSERT INTO mazNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nuc'ua o ndünrüji, o xipjiji: ―C'ü mi tatagöjme ngueje e Abraham. O ndünrü c'ua e Jesús, o xipjiji: ―'Ma ri ngue'tsc'eji o̱ t'its'üji e Abraham, ri tsjaji c'ü o tsja e Abraham. ");
INSERT INTO mazNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","E Abraham, nuc'ü, o dyätä Mizhocjimi c'ü. Pero nudya i̱ṉ jongüji rí pötcüji. E Abraham dya ro tsja a cjanu. Nutscö rí bëzo ró xi'ts'iji c'o na cjuana nu c'o ró ärägö cja Mizhocjimi. Nguec'ua i̱ṉ ne rí pötcüji. ");
INSERT INTO mazNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nu'tsc'eji i̱ṉ cjaji c'ü cja c'ü nin tatagueji. O xipjiji c'ua: ―Nutscöjme dya o̱ t'izgöjme nandyo bëzo. 'Natjo mi Tata rí sicjöjme. Ngueje Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","E Jesús o xipjiji c'ua: ―'Ma ri ngueje Mizhocjimi nin tatagueji, ri s'iyazügöji 'ma. Na ngueje nguezgö 'natjozügö o̱ T'izü Mizhocjimi. Je ró pecjö cja Mizhocjimi. Dya ró ẽjẽtsjëgö. Ngueje Mizhocjimi je ndäcjö ró ẽjẽ. ");
INSERT INTO mazNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jenga dya i̱ṉ pãrãji ja cja c'ü rí mangö? Dya i̱ṉ pãrãji na ngueje, dya i̱ṉ ne rí dyätcäji ín jña'a. ");
INSERT INTO mazNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nu'tsc'eji, nu c'ü nin tatagueji ngueje c'ü dya jo. I̱ṉ ne rí tsjaji nu c'o ne'e nin tatagueji. Ndeze o mbürü, c'ü dya jo ngue mbö't'üte. Nuc'ü, dya pje mama c'ü na cjuana c'ü. Na ngueje c'ü na cjuana, dya pje bübü o̱ mü'bü. Nu 'ma mama c'o dya cjuana ngueje c'o cjijñitsjë cja o̱ mü'bü c'o mama. Na ngueje c'ü dya jo, na mbëchjine. Nguejnu tata nu c'o xo mama c'ü dya cjuana. ");
INSERT INTO mazNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Dya i̱ṉ ejmezüji na ngueje nutscö rí mama c'o na cjuana. ");
INSERT INTO mazNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Cjo bübütsc'eji 'naja c 'ü sö ra mama rí cjagö c'o na s'o? Nu 'ma rí xi'ts'iji c'ü na cjuana, ¿jenga dya pje i̱ṉ ejmezügöji? ");
INSERT INTO mazNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nu c'o ngueje o̱ t'i'i Mizhocjimi ätpäji o̱ jña'a. Pero nu'tsc'eji, dya ngue'tsc'eji o̱ t'its'üji Mizhocjimi na ngueje dya i̱ṉ ätpägueji c'o o̱ jña. ");
INSERT INTO mazNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","O ndünrü c'ua c'o pje mi pjëzhi cja c'o nte a Israel. Me co üdüji. O xipjiji: ―Rí pãrãjme na jo, bübü demonio cja in mü'bügue. Je i̱ tegue a ma a Samaria, dya i̱ṉ pãrãgue ja cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","O ndünrü c'ua e Jesús, o xipjiji: ―Dya bübü demonio cja ín mü'bügö. C'ü rí mamagö ngue c'ü ne'e mi Tatagö. Nu'tsc'eji c'ü i̱ṉ cjaji, dya pje i̱ṉ ejmezügöji rvá ẽcjö cja mi Tatagö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Dya rí jodügö c'ü rí mangueji na nojozügö; nu c'ü jodü c'ü rí mangueji na nojozügö, ngue mi Tatagö Mizhocjimi. Angueze ra jizhi c'ü na nojozügö. ");
INSERT INTO mazNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na cjuana c'ü rí xi'ts'igöji, nu c'ü sido ra dyätcö yo rí mangö, dya ra ndũ'ũ, ra bübütjo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nuc'ua c'o pje mi pjëzhi cja c'o nte a Israel o xipjiji: ―Nudya, rí pãrãjme na jo dya, bübü demonio in mü'bügue. Ya o ndũ'ũ e Abraham. Ya xo o ndũ'ũ c'o profeta. Maco nu'tsc'e i̱ṉ mama nu c'ü sido ra dyä'tc'ägue, dya ra ndũ'ũ, sido ra bübütjo. ");
INSERT INTO mazNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nu'tsc'e i̱ṉ cjinncje xenda na nojots'ügue que na ngueje mi tatajme e Abraham. Nuc'ü, o ndũ'ũ c'ü. Xo o ndũ'ũ c'o profeta. ¿Cjó ngue c'ü je na cjapütsjëgue? ");
INSERT INTO mazNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","O ndünrü e Jesús, o xipjiji: ―Nu 'ma ri jodütsjëjëgö c'ü ro mama yo nte na nojozügö, dya pje rví muvi 'ma c'o. Mi Tatagö ngue c'ü jodü c'ü ra mamaji a cjanu. Maco i̱ṉ mamagueji que mi Tatagö ngueje in Mizhocjimigueji. ");
INSERT INTO mazNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nu'tsc'eji, dya i̱ṉ pãrãgueji angueze. Pero nutscö rí pãrãgö c'ü. 'Ma ro mama c'ü dya rí pãrãgö Mizhocjimi, ri nguezgö 'na mbëchjine nza cjatsc'eji. Jo rí pãrãgö Mizhocjimi. Rí cjagö c'o mama angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","E Abraham c'ü nin mboxtitaji me co mäjä 'ma o 'ñejme ro jñandga ma ẽcjö. A cjanu o jñandga. O mäjä c'ua. ");
INSERT INTO mazNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","C'o pje mi pjëzhi cja c'o nte a Israel o xipjiji c'ua: ―Dya be xo i̱ṉ nzhodügue ni cincuenta cjë'ë. ¿Ja rvi jñandague e Abraham? ");
INSERT INTO mazNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","E Jesús o xipjiji: ―Na cjuana c'ü rí xi'ts'iji. 'Ma dya be mi bübü e Abraham, ya exmi bübügö. ");
INSERT INTO mazNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nuc'ua o jñüs'üji ndojo c'o ro pjat'üji e Jesús. Pero nuc'ü, o tsjõjõ c'ü. Dya cjó jñanda ja va ma. O mbedye cja c'e templo. O ma'a. ");
INSERT INTO mazNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","'Ma o cjogü e Jesús o jñanda 'naja bëzo c'ü mi ndëzhö. Mi ndëzhö 'ma o jmus'ü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nuc'ua c'o o̱ discípulo o dyönüji e Jesús, o xipjiji: ―Xöpüte, ¿Cjó ngue c'ü o tsja c'o na s'o, nguec'ua va ndëzhö nu? ¿Cjo ngueje ne bëzo nu ndëzhö maxque ngueje c'o o̱ tata? ");
INSERT INTO mazNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","O ndünrü c'ua e Jesús, o xipjiji: ―C'ü vi ndëzhö, dya ngue c'ü vi tsja c'o na s'o nu. Dya xo ngue c 'ü vi tsja c'o na s'o c'o o̱ tata. C'ü vi ndëzhö ngue c'ü rguí 'ñetse c'ü me na nojo c'ü cja'a Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ni jyodü rá cjagö c'o ne'e nu c'ü o ndäcjä, ndeze 'ma xe ndempa. Va ẽjẽ xõmü, 'ma dya cja sö cjó ra pëpji. ");
INSERT INTO mazNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ndeze c'ü xe rá mimigö cja ne xoñijõmü, nguetscö e jya's'ü cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","'Ma o mama a cjanu o zogü a jõmü o̱ c'ijñi, o mbopjü c'ua c'e jõmü. Cjanu o ngans'a c'o mbëõmü. O ngosp'ü c'ua cja o̱ ndö'ö c'e bëzo c'ü mi ndëzhö. ");
INSERT INTO mazNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","E Jesús o xipji c'ua: ―Ma xinzhö cja c 'e t'ore c'ü ni chjũ Siloé, eñe. C'e tjũ'ũ ne ra mama 'naja c'ü däjä. Cjanu o ma'a c'ua c'e bëzo c'ü mi ndëzhö. O ma xinzhö. Nu 'ma o nzhogü c'ua, ya mi janda. ");
INSERT INTO mazNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nuc'ua c'o o̱ mejñiñi 'ñe c'o ya vi jñanda mi ndëzhö mi mamaji: ―¿Cjo dya ngueje nu mi ndëzhö nu ja nde mi junrü nu me mi örü pje ra zi? ");
INSERT INTO mazNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mi cãrã c'o mi mama: ―Ngueje nu. C'o dyaja mi mamaji: ―Dya ngue nu, pero exi nguetjo nu. O ndünrü c'ua c'ü mi ndëzhö, o mama: ―Nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","O xipjiji c'ua: ―¿Ja va xogü dya, c'o in chö'ö? ");
INSERT INTO mazNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","O ndünrü c'ua angueze, o mama: ―C'e bëzo c'ü ni chjũ'ũ Jesús o ngans'a mbëõmü. O ngoscügö ín chö'ö. Cjanu o xitsi c'ua: “Ma a Siloé, ma xinzhö.” Ró ma'a c'ua, ró ma xinzhö. Ya o xogü c'ua yo ín chögö, ya ró janda. ");
INSERT INTO mazNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nuc'ua o xipjiji: ―¿Ja je bübü dya, c'e bëzo c'ü? Angueze o ndünrü: ―Dya rí pãrãgö ja je bübü. ");
INSERT INTO mazNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","O zidyiji nu c'ü mi ndëzhö, o möji cja c'o fariseo. ");
INSERT INTO mazNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","C'e pa 'ma söyaji ngue 'ma o ngans'a e Jesús o mbëõmü c'ü vi xopcü o̱ ndö'ö c'e bëzo c'ü mi ndëzhö. ");
INSERT INTO mazNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nuc'ua o yepe o ña c'ua c'o fariseo, o dyonüji c'e bëzo pje vi ts'apü ngue c'ua va xogü o̱ ndö'ö. Angueze o xipjiji: ―O ngoscügö mbëõmü ín chö'ö. Cjanu ró xinzhö. Nudya ya rí janda dya. ");
INSERT INTO mazNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nuc'ua mi cãrã o fariseo c'o mi mama: ―C'e bëzo c'ü i̱ṉ mangue o jo'c'üts'ü, dya pje vi 'ñeje cja Mizhocjimi c'ü; na ngueje dya pje sũpü nu pa c'ü rí söyaji. Dyaja c'o mi mama: ―C'e bëzo, dya cja'a c'o na s'o. 'Ma ri cja c'o na s'o c'e bëzo, dya ro sö ro tsja'a yo me na nojo yo nunca rí jandaji. Dya mi 'natjo o̱ pjeñeji. ");
INSERT INTO mazNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","O yepe o dyönütjoji c'ü mi ndëzhö: ―¿Pje xo i̱ṉ mangue, pje pjëzhi nu c'ü o xo'c'üts'ü in chö'ö? Angueze c'ua, 'ma o ndünrü o mama: ―Ngueje 'na profeta. ");
INSERT INTO mazNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nu c'o pje mi pjëzhi cja c'o nte a Israel, dya mi ejmeji cjo mi ndëzhö c'e bëzo. Dya mi ejmeji cjo vi xogü c'o o̱ ndö'ö. Cja 'ñejmeji 'ma cja o zojnüji nu tata c'e bëzo c'ü vi xogü o̱ ndö'ö, 'ñe nu nana. ");
INSERT INTO mazNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","O dyönüji, o xipjiji: ―¿Cjo ngueje in ch'iguevi nu, nu nu i̱ṉ manguevi exmi ndëzhö 'ma o jmus'ü? ¿Jenga janda dya 'ma? ");
INSERT INTO mazNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","O ndünrü c'ua c'ü nu tata 'ñe c'ü nu nana, o mamavi: ―Rí pãrãgöbe ngueje ín ch'igöbe nu. 'Ma o jmus'ü nu, exmi ndëzhö nu. ");
INSERT INTO mazNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jenga ya janda dya, dya rí pãrãbe. Dya xo rí pãrãgöbe cjó je o xopcü o̱ ndö'ö nu. Ya jo ndümbeñe angueze. Dyönütsjëji. Ya ra xi'ts'itsjëji. ");
INSERT INTO mazNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","O mama a cjanu c'ü nu tata 'ñe c'ü nu nana na ngueje mi sũvi c'o pje mi pjëzhi cja c'o nte a Israel. Na ngueje ya vi mamaji 'ma cjó c'o ro mama e Jesús ngueje e Cristo, ro pjongüji c'e nte'e cja o̱ nitsjimiji. ");
INSERT INTO mazNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nguec'ua va mama c'ü nu tata c'e bëzo 'ñe c'ü nu nana: “Ya jo ndümbeñe. Dyönüji angueze. Ya ra xi'ts'itsjëji.” ");
INSERT INTO mazNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nuc'ua o yepe o zojnütjoji c'e bëzo c'ü mi ndëzhö, o xipjiji: ―Unü 'na pöjö Mizhocjimi c'ü o xo'c'üts'ü in chö'ö. Nutscöjme rí pãrãjme na jo, c'e bëzo cja'a c'o na s'o c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","O ndünrü c'ua c 'ü mi ndëzhö, o mama: ―Dya rí pãrãgö c'ü, cjo cja c'o na s'o c'ü. Nguextjo nu rí pãrãgö, nutscö dya rmí jandagö. Nudya rí janda dya. ");
INSERT INTO mazNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nuc'ua na yeje o xipjitjoji c'ua: ―Pero, ¿pje o tsja'c'ü? ¿Ja va xo'c'üts'ü in chö'ö? ");
INSERT INTO mazNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","C'ü mi ndëzhö o ndüntüji: ―Ya ró xi'ts'iji, pero dya i̱ dyätcöji. ¿Jenga i̱ṉ ne rí yepe rí dyäräji? Maxque, ¿cjo xo i̱ṉ negueji rí chjünt'üji o̱ xütjü? ");
INSERT INTO mazNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nuc'ua o zadütjoji, o mamaji: ―Nu'tsc'e ngue'tsc'e i̱ṉ tjünt'ü a xütjü e Jesús. Nutscöjme rí tjünt'üjme a xütjü e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nutscöjme rí pãrãgöjme, e Moisés o zopjü c'o nte. O mama c'o jña c'o vi mama Mizhocjimi. Pero c'e bëzo c'ü i̱ṉ mangue o jo'c'üts'ü, dya rí pãrãjme ja je vi 'ñeje c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","O ndünrü c'ua c'e bëzo c'ü mi ndëzhö, o xipjiji: ―Yo i̱ṉ xitsiji, me i̱ṉ cjacüji rá dyäxä. Maco o xocüzügö ín chö'ö c'e bëzo, ¿jenga dya i̱ṉ pãrãji ja je vi 'ñeje c'ü? ");
INSERT INTO mazNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Rí pãrãgöji, zö ra tsja 'na nte ra dyötü Mizhocjimi ra unü poder, pero 'ma cja na s'o c'e nte, Mizhocjimi dya ra dyärä c'ü örü c'e nte. Pero nu c'o ma't'ü Mizhocjimi 'ñe cja'a c'ua ja ga ne'e angueze, nuc'o, Mizhocjimi ra dyätä c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ndeze 'ma o mbürü ne xoñijõmü, cãrã c'o o jmus'ü ndëzhö. Pero dya rí ärägöji c'ü ri bübü 'na bëzo c'ü ri jocü c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nu c'e bëzo, 'ma dya rví 'ñeje cja Mizhocjimi c'ü, dya xo ro sö'ö pje ro tsja'a. ");
INSERT INTO mazNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","O ndüntüji c'ua, o xipjiji: ―Nu'tsc'e i̱ tsja c'o na s'o; exvi chetjovi in nzhunc'e. ¿Jenga i̱ṉ cjinncje ra sö rí xöcügöjme? Cjanu o pjongüji c'ua cja c'e nitsjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","O dyärä e Jesús ya vi pjongüji c'e bëzo. Nguec'ua va jyodü ja je mi nzhodü c'e bëzo. 'Ma o chöt'ü, o xipji: ―¿Cjo i̱ṉ ejmegue o̱ T'i Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","O ndünrü angueze, o mama: ―Nu'tsc'e sẽ'ẽ, xitsigö cjó ngueje o̱ T'i Mizhocjimi; ngue c'ua ra sö rá ejmegö angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","O ndünrü c'ua e Jesús: ―Ya i̱ jñandague angueze. Nguetscö rrã ñavi. ");
INSERT INTO mazNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","O mama c'ua c'e bëzo: ―Nu'tsc'e ín Jmuts'ügö, rí ejmets'ü. Ngue'tsc'e o̱ T'its'ü Mizhocjimi. Cjanu o ndüñijõmü o ma't'ü c'ua. ");
INSERT INTO mazNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","O mama c'ua e Jesús: ―Na ngue c'ü rvá ẽcjö, exi 'ñetsetjo ja ga nguijñi o̱ mü'bü yo nte. C'o unü ngüenda c'ü ni jyodü ra xogü o̱ ndöji ngue c'ua ra bübü o̱ jya's'ü Mizhocjimi cja o̱ mü'büji, ra xogü o̱ ndöji ra mbãrãji Mizhocjimi. Pero c'o cjijñi ya xogü o̱ ndöji, nuc'o, ra ndëzhöji, dya ra mbãrãji c'ü na cjuana. ");
INSERT INTO mazNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","O dyärä ja nzi c'o fariseo c'o mi cãrã bëxtjo nu ja mi bübü e Jesús, o mamaji c'ua: ―A poco i̱ṉ cjijñigue c'ü xo rí ndëzhöjme. ");
INSERT INTO mazNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","O ndünrü c'ua e Jesús: ―'Ma ri unnc'eji ngüenda c'ü ni jyonc'eji o̱ jya's'ü Mizhocjimi, ro perdonaots'üji 'ma c'o na s 'o. Pero i̱ṉ mangueji: “Ya xogü ín chögöjme, rí pãrãjme na jo”, i̱ṉ eñeji. Nguec'ua xe i̱ṉ tũtjoji in nzhunc'eji. ");
INSERT INTO mazNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Na cjuana c 'ü rá xi'ts'igöji. Nu c'ü dya ra cjogü cja o̱ ngoxtji nu ja cot'üji o ndënchjürü, nu c'ü je dacütjo cja ndüngumü, nuc'ü ngueje mbẽ'ẽ c'ü; y xopcü nu ja cjot'ü o ndënchjürü. ");
INSERT INTO mazNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nu c'ü je cjogü cja o̱ ngoxtji nu ja cjot'ü o ndënchjürü ngueje e mbörü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","E mböngoxtji xopcü ngoxtji e mbörü. C'o ndënchjürü ätpäji o̱ jña'a. Nu c'e mbörü nänbä o̱ tjũ'ũ yo o̱ ndënchjürü. Ngueje c'ü pjongü c'ua c'o ndënchjürü ra ma ziji o t'ëbi. ");
INSERT INTO mazNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","'Ma ra mbedye c'o o̱ ndënchjürü, ra ot'ü e mbörü. Cja rron ma c'o o̱ ndënchjürü. C'o ndënchjürü tjünt'üji a xütjü c'e mbörü, na ngueje pãtpãji o̱ jña'a. ");
INSERT INTO mazNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","'Ma ra ẽjẽ 'naja c'ü dya pãrãji, dya ra ndünt'üji a xütjü. Nu c'ü ra tsjaji, ra c'ueñeji; na ngueje dya pãtpãji o̱ jña'a c'o nandyo. ");
INSERT INTO mazNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Nu yo jña'a yo, je zopjü e Jesús o fariseo. Pero anguesji dya o mbãrãji ja cja c'ü mi xipjiji. ");
INSERT INTO mazNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","O ña c'ua na yeje e Jesús, o xipjiji: ―Na cjuana c'ü rá xi'ts'igöji. Nutscö nguetscö e ngoxtji nu ja cjogü yo ndënchjürü. ");
INSERT INTO mazNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Texe c'o va ẽtsc'eji c'o ne c'ü rí chjünt'üji o̱ xütjü, ne ra dyon'c'eji. Ngue o mbẽ'ẽ c'o xopcü nu ja cjot'ü o ndënchjürü. Pero c'o ndënchjürü dya pje ätäji. ");
INSERT INTO mazNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nuzgö nguetscö e ngoxtji nu ja cjogü yo ndënchjürü. Nu c'ü ra 'ñench'ezü o̱ mü'bü, ngue c'ü sö ra cjogü. Nuc'ü, ngue c'ü ra jogü o̱ mü'bü c'ü. Nuc'ü, ra chöt'ü texe c'o ni jyodü o̱ mü'bü. Nguec'ua ra chjëntjovi nza cja 'na ndënchjürü c'ü ra cjogü, ra mbedye, ra chöt'ütjo o t'ëbi c'ü ra zi'i. ");
INSERT INTO mazNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’E mbẽ'ẽ ni 'ñetjo ra ẽ põnü c'o ndënchjürü. Ra mbö't'ü texe c'o. Nutscö rvá ẽjẽgö ngue c'ua ra bübütjoji. Me ra mäpä Mizhocjimi rgá bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Va mama c'ua e Jesús: ―Nuzgö nguetscö 'na mbörü c'ü me na jo; ojtjo c'ü ri nza cjazgö. 'Na mbörü c'ü na jo, bübü dispuesto ra ñana c'o ndënchjürü cja c'o mbẽ'ẽ, zö ra mbö't'üji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero 'ma cjó c'o ts'õ't'ü ra mbörü c'o ndënchjürü, dya ra mbörü na jo c'o, na ngueje dya exi ngue o̱ cjaja c'o ndënchjürü. Nguec'ua 'ma ra jñanda rva ẽjẽ e mindyo, exta zogü c'ua c'o ndënchjürü, ra c'ueñe ra ma. Nguec'ua c'e mindyo ra pënch'i c'o ndënchjürü, nde ra mböt'ü c'ua c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","C'ueñe c'ü mi pjörü na ngueje ts'õ't'ütjo, dya ngueje o̱ cjaja c'o ndënchjürü. Nguec'ua dya cjapü ngüenda pje ra ts'apü c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Xe ma ña'a e Jesús, o mama: ―Nguetscö c'e mbörü c'ü me na jo. Rí pãrãgö c'o ngueje ín nzhënchjürügö. Anguezeji xo pãcãgöji. ");
INSERT INTO mazNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","A cjanu, xo pãcã mi Tata c'ü bübü a jens'e. Nuzgö xo rí pãrãgö mi Tata. Nuzgö rá tũgö ngue c'ua ra bübütjo c'o ín nzhënchjürügö. ");
INSERT INTO mazNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Xo rí tsãjãgö c'o dyaja ndënchjürü c'o dya be tjünt'ü ín xütjügö. Nuc'o, xo ni jyodü xo rá pjörü c'o. Ra dyätcäji ín jñagö, ra ndünt'üji ín xütjü. A cjanu ri 'natjo nu ja ri cãrãji, 'ñe ri 'natjo mbörü, c'ü nguezgö. ");
INSERT INTO mazNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Me s'iyazü mi Tata c'ü bübü a jens'e; na ngueje rá tũgö ngue c'ua rá yepe rá bübütjo. ");
INSERT INTO mazNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Dya cjó ra tsjacü rá tũgö. Nguetscö rrã unütsjëjë rá tũ'ũ. Sö'ö rá unütsjëgö rá tũ'ũ, 'ñe sö'ö rá nanga. Ngueje c'ü vi ndäcjä mi Tatagö c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na ngueje vi mama yo jña'a yo e Jesús, c'o nte o zöji na yeje co jña, dya mi 'natjo pjeñe mi cjijñiji. ");
INSERT INTO mazNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Na puncjü anguesji c'o mi mama: ―Bübü demonio cja o̱ mü'bü ne Jesús. Dya pãrã pje mama. ¿Jenga i̱ṉ ätäji c'ü xi'ts'iji nu? ");
INSERT INTO mazNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dyaja c'o mi mama: ―Ne bëzo nu, 'ma ri bübü c'ü dya jo cja o̱ mü'bü, dya ro mama yo jña yo me na jo. C'ü dya jo, a poco sö'ö ra xopcü o̱ ndö'ö 'na ndëzhö, c'ua ja nzi va tsja ne bëzo. ");
INSERT INTO mazNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","C'o pa'a c'o, c'o nte a Jerusalén o tsjaji 'na mbaxua, mi mbeñeji c'e pa 'ma o dyötüji Mizhocjimi ro nintsjimi na yeje c'e templo. Ma së c'o pa c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","E Jesús je mi nzhodü nu cja c'e templo cja o̱ porta e Salomón. ");
INSERT INTO mazNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nuc'ua c'o pje mi pjëzhi cja c'o nte a Israel, o jmurüji a jmi e Jesús, o xipjiji: ―¿Jenga dya rí xitsijme na jo cjó je ngue'tsc'e? Nu 'ma ngue'tsc'e e Cristo extí xitsijme na jo. ");
INSERT INTO mazNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nuc'ua o ndünrü e Jesús, o xipjiji: ―Ró xi'ts'iji cjó je nguetscö. Nu'tsc'eji dya i̱ṉ ejmezüji. Nuzgö rrã cjagö c'o ne'e mi Tata a jens'e. A cjanu, 'mãrã na jo cjó je nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nu'tsc'eji, dya i̱ṉ ejmezüji na ngueje dya ngue'tsc'eji ín nzhënchjürüts'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","C'o ín nzhënchjürügö ätcäji ín jñagö. Rí pãrãgö c'o. Anguesji tjünt'üji ín xütjügö. ");
INSERT INTO mazNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nu c'o ín nzhënchjürügö rí unügö c'ü sido ra bübütjoji. Nuc'o, dya ra ndũ'ũ c'o. Nuc'o, dya cjó sö cjó ra zipqui cja ín dyëgö. ");
INSERT INTO mazNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mi Tatagö c'ü o dyacügö c'o, ngueje c'ü xenda na nojo texe c'ü. Nguec'ua dya cjó sö cjó ra zinbi cja o̱ dyë'ë mi Tatagö c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nutscö co c'ü mi Tata a jens'e rí 'natjobe, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nuc'ua o jñüs'ü na yeje o ndojo c'o pje mi pjëzhi cja c'o nte a Israel. Ro pjat'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","O ndünrü c'ua e Jesús, o xipjiji: ―Na puncjü c'o na jo c'o ya ró jí'ts'iji. Mi Tata a jens'e ngue c'ü o jítsigö c'o. Texe yo ró cja'a, ¿ja bübü c'ü na s'o c'ü rgui pjacüji? ");
INSERT INTO mazNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","O ndünrü c'ua anguezeji, o mamaji: ―Nu yo na jo i̱ṉ tsjague, dya nguejyo rga pja'c'üjme yo. C'ü rga pja'c'üjme, ngueje c'ü i̱ṉ sadügue Mizhocjimi. Maco xo nguetjots'ügue 'na bëzo; pero i̱ṉ cjapü que nguets'ü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","O ndünrü c'ua e Jesús o xipjiji: ―Mbeñeji ja ga t 'opjü cja in leyji. Je t'opjü nu, c'ü ja va sjipji c'o o juajnü Mizhocjimi jinguã ro pätpäji angueze rvá zopjüji c'o nte. Je t'opjü a cjava: “Ngue'tsc'eji i̱ṉ mizhocjimigueji”, eñe Mizhocjimi. Rí pãrãgöji c'ü je va mama Mizhocjimi, na ngueje na cjuana c'ü t'opjü cja o̱ jña. C'o nte c'o o juajnü Mizhocjimi mi jinguã, o mama Mizhocjimi o xiji mizhocjimi c'o. Nguec'ua, ¿jenga i̱ṉ mamaji rí sadügö Mizhocjimi na ngueje ró xi'ts'iji: “Exi nguejezü o̱ T'izü Mizhocjimi”, maco Mizhocjimi o ndäcjä ró ẽjẽ cja ne xoñijõmü? ");
INSERT INTO mazNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tsjijñiji na jo cjo rí cjagö c'ü ne'e mi Tata; 'ma jiyö, dya rí 'ñejmezüji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero 'ma i̱ṉ jandgaji rí cjagö c'ü ne'e angueze, extí unnc'eji ngüenda 'ma c'ü bübüzügö mi Tata, 'ñe nutscö rí bünc'öbe angueze. Extí unnc'eji ngüenda a cjanu zö dya i̱ṉ ejmezüji c'ü ró xi'tsc'öji exi ngue o̱ T'izü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nuc'ua mi neji na yeje ro zürütjoji. Nuc'ua o mbedyetjo e Jesús cja o̱ dyëji. ");
INSERT INTO mazNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","O ma mbes'e na yeje cja c'e ndare a Jordán nu ja ot'ü mi jichite e Juan. O nguejme c'ua nu. ");
INSERT INTO mazNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na puncjü c'o o zät'ä cja o̱ jmi'i e Jesús, mi mamaji: ―E Juan dya pje o tsja'a c'ü me na nojo c'ü nunca rí jandaji. Pero ma cjuana c'o o mama e Juan ja ga cja ne bëzo, ne Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","A cjanu, na puncjü c'o mi cãrã nu, o 'ñench'e o̱ mü'büji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mi bübü c'ua 'naja bëzo c'ü mi sö'dyë c'ü mi chjũ'ũ e Lázaro. Mi menzumü a Betania, nu ja mi menzumü e María 'ñe e Marta c'ü nu cjũjuë. ");
INSERT INTO mazNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mi ngueje c'e María c'ü je o ngosp'ü o̱ ngua e Jesús c'ü ín Jmugöji c'e perfume c'ü ma jo ma yüdü. Cjanu o ndintspi c'ua o̱ ngua'a co o̱ ñixti. Nu c'ü nu 'ninzhõmü c'ü mi chjũ e Lázaro, ngue c'ü mi sö'dyë c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","C'o o̱ cjũ e Lázaro o mbenpevi c'ua na jña e Jesús, o xipjivi: ―Nu'tsc'e, ín Jmuts'üjme, nu c'ü me i̱ṉ s'iyague, sö'dyë c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","'Ma o dyärä e Jesús o mama: ―Nu c'e ndötc'ijeme c'ü, dya ngue c'ü rguí nzhũ'ũtjo. Na ngueje rá cjagö c'ü rguí unü ngüenda yo nte c 'ü me na zëzhi Mizhocjimi. A cjanu xo ra unüji ngüenda nguezgö o̱ T'izü Mizhocjimi, me xo na zëtscö. ");
INSERT INTO mazNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","E Jesús me mi s'iya e Marta co c'ü nu cjũjuë 'ñe e Lázaro. ");
INSERT INTO mazNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nuc'ua 'ma ya vi dyärä mi sö'dyë e Lázaro, xe o nguejmetjo e Jesús yepa nu ja je mi bübü nu 'nanguarü c'e ndare a Jordán. ");
INSERT INTO mazNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'Ma ya o cjogü c'ua c'o yepa, o xipji c'o o̱ discípulo: ―Möjö a Judea. Rá yepe rá sät'ätjoji nu. ");
INSERT INTO mazNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","C'o o̱ discípulo o xipjiji c'ua: ―Xöpüte, dya be mezhe 'ma mi ne ro pja'c'ü ndojo c'o pje pjëzhi cja c 'o nte a Israel. ¿Cjo rí matjo na yeje a manu? ");
INSERT INTO mazNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","O ndünrü e Jesús, o xipjiji: ―¿Cjo dya cja'a doce hora nu pa'a? Nu c'ü ra nzhodü 'ma ndempa, dya ra pjeñe na ngueje janda e jya's'ü cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nu c'ü ra nzhodü 'ma xõmü ngue c'ü ra pjeñe c'ü, na ngueje dya bübü e jya's'ü c'ü ra jñanda ja ngue c'ua nzhodü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","'Ma o nguarü o mama a cjanu, o mama c'ua: ―Nu c'ü e Lázaro c'ü rí joji ĩjĩtjo. Rá ma'a, rá ma dyö'ö. ");
INSERT INTO mazNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","O mama c'ua c'o o̱ discípulo: ―Nu'tsc'e ín Jmuts'üjme, nu 'ma ĩjĩtjo, ra jogütjo 'ma. ");
INSERT INTO mazNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","C'ü mi mama e Jesús ngue c'ü ya vi ndũ'ũ e Lázaro. Pero c'o o̱ discípulo o nguijñiji mi mama c'ü vi söyatjo vi ĩjĩ. ");
INSERT INTO mazNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nuc'ua e Jesús ya xo xipjiji na jo: ―E Lázaro ya ndũ'ũ c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na jo c'ü dya mi bübügö nu, ante c'ü ro ndũ e Lázaro; ngue c'ua rí 'ñejmezüji dya, 'ma rí jñandaji c'ü rá cjagö. Möjö dya, rá ma nuji. ");
INSERT INTO mazNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","O mama c'ua e Tomás c'ü xo mi chjũ'ũ Cuate, o xipji c'o o̱ midiscípuloji: ―Xo rá möjö ngue c'ua 'natjo c'ua rá ma tũji co e Jesús. O möji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","'Ma o zät'äji, ya o mbãrã c'ua e Jesús ya mi pa nziyo pa'a c'ü ya vi c'öt'ü e Lázaro cja cueva. ");
INSERT INTO mazNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","C'e jñiñi a Betania mi bëxtjo a Jerusalén. Mi jyadütjovi yeje kilometro nde. ");
INSERT INTO mazNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nguec'ua na puncjü c'o mi menzumü a Jerusalén c'o o ma a Betania, o ma jo'tp'üji e Marta 'ñe e María, na ngueje ya vi ndũ e Lázaro c'ü nu 'ninzhõmüvi. ");
INSERT INTO mazNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nuc'ua o dyärä e Marta ma ẽjẽ e Jesús. Nzi va dyärä, nzi va mbedye; o ma ndünrü. E María o nguentjo nu cja ngumü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","E Marta o xipji e Jesús: ―Nu'tsc'e, ín Jmuts'ügö, nu 'ma ri bübügue a 'ñecjua, dya ro ndũ'ũ 'ma c'ü ín 'ninzhõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nudya, xo rí pãrãgö, texe c'o rí dyötü Mizhocjimi, nde ra dya'c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","O ndünrü c'ua e Jesús: ―Ra te'etjo c'ü nin 'ninzhõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","O xipji c'ua e Marta: ―Rí pãrãgö c'e pa'a 'ma ra te'e c'o añima, xo ra te'etjo c'ü mi 'ninzhõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","O xipji c'ua e Jesús: ―Nuzgö nguetscö rá xos'ü c'o ya ndũ, rá cjapü ra te'eji. Rá unügö c'ü rguí bübüji. Nu c'ü ra 'ñejmezügö, zö ra ndũ'ũ, ra te'etjo, ra bübütjo na yeje. ");
INSERT INTO mazNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Texe c'o bübü c'o ejmezügö, dya ra ndũ'ũji. ¿Cjo i̱ṉ ejme yo rrã xi'ts'i? ");
INSERT INTO mazNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nuc'ua e Marta o xipji c'ua: ―Jãgã, ín Jmuts'ügö. Nutscö rí ejmegö ngue'tsc'e e Cristo, o̱ T'its'ü Mizhocjimi. Ngue'tsc'e o mama Mizhocjimi ri 'ñecje cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nuc'ua 'ma o nguarü o mama a cjanu e Marta, o ma c'ua. O ma zojnü e María c'ü nu cjũjuë. O tsjontp'ütjo va ña'a, o xipji: ―E xöpüte va säjä. Zon'c'ü rí ma'a nu. ");
INSERT INTO mazNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","E María nzi va dyärä, nzi va böbü. Nuc'ua o ma'a nu ja je mi bübü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","E Jesús dya be mi sät'ä cja c'e jñiñi. Xe mi bübütjo nu ja je vi chjëvi e Marta. ");
INSERT INTO mazNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nuc'ua c'o nte a Israel c'o mi jo'tp'ü e María nu cja ngumü, o jñandaji o böbü zacü e María. O mbedye a tji'i. Anguezeji o ndünt'üji a xütjü, o mamaji: ―Ni ma cja c'e cueva. Ra ma huë'ë nu. ");
INSERT INTO mazNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nuc'ua o zät'ä e María nu ja je mi bübü e Jesús. 'Ma o jñanda o ndüñijõmü a jmi'i e Jesús. O xipji c'ua: ―Nu'tsc'e, ín Jmuts'ügö, 'ma ri bübügue a 'ñecjua, dya ro ndũ'ũ 'ma c'ü mi 'ninzhõmügö. ");
INSERT INTO mazNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nuc'ua e Jesús o jñanda c'ua e María mi huë'ë; 'ñe c'o nte a Israel c'o mi dyoji e María xo mi huëji. Nuc'ua me co sentio cja o̱ mü'bü. Me mi chana o̱ mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","O dyönü c'ua e Jesús, o mama: ―¿Ja je ngue c'ua i̱ tsöt'üji c'e añima? O xipjiji: ―Nu'tsc'e ín Jmuts'üjme, xä'dä rí ẽ ñu'u. ");
INSERT INTO mazNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nuc'ua o huë'ë e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","O mama c'ua c'o nte a Israel: ―Jñandaji. Nujnu me mi s'iya e Lázaro. ");
INSERT INTO mazNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mi cãrã anguesji c'o o mama: ―Nu e bëzo nu, maco o xopcü o̱ ndö'ö c'ü mi ndëzhö. ¿Cjo dya ro sö ro jocü e Lázaro ngue c'ua dya ro ndũ'ũ? ");
INSERT INTO mazNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nuc'ua e Jesús me co sentio na yeje cja o̱ mü'bü. Cjanu o ma nu ja vi ngöt'üji e Lázaro. Mi c'ot'ü 'na ndojo. ");
INSERT INTO mazNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","O mama c'ua e Jesús: ―Tsjüs'üji ne ndojo. E Marta c'ü nu cjũ e Lázaro c'ü ya vi ndũ, o xipji e Jesús: ―Nu'tsc'e, ín Jmuts'ügö. Maco ya na xĩ'ĩ c'ü. Ya pa nziyo pa ndeze o ndũ. ");
INSERT INTO mazNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","O ndünrü c'ua e Jesús, o xipji: ―Ya ró xi'ts'i, nu 'ma rí 'ñejme, rí jñanda c'ü na zëzhi c'ü cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nuc'ua o ngüs'üji c'ua c'e ndojo nu ja je vi ngöt'üji c'e añima. E Jesús o nä's'ä c'ua a jens'e, o mama: ―Nu'tsc'e mi Tatats'ü, rí da'c'ü na pöjö na ngueje i̱ dyätcä, y rí tsjague c'ua ja nzi rvá ö'tc'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nutscö ya rí pãrãgö sido i̱ṉ ätcä. C'ü cja rvá da'c'ü na pöjö, ngue c'ü ra dyärä yo cãrã a 'ñecjua, ngue c'ua ra 'ñejmeji ngue'tsc'e i̱ chäcjägö. ");
INSERT INTO mazNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","'Ma o nguarü o mama yo jña'a yo, o mapjü na jens'e: ―Nu'tsc'e Lázaro, pedyegue a tji. ");
INSERT INTO mazNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nuc'ua e Lázaro c'ü ya vi ndũ'ũ o mbedye c'ua. Mi 'mans'a o manta. O̱ jmi'i mi bös'ü 'naja bitu. O mama c'ua e Jesús: ―Xäpcäji dya ne manta. Jyëziji ra ma cja o̱ ngumü. ");
INSERT INTO mazNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nuc'ua na puncjü c'o mi menzumü a Jerusalén c'o mi dyoji e María, o 'ñench'e o̱ mü'büji e Jesús. Na ngueje vi jñandaji c'ü vi tsja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nuc'ua mi cãrã anguesji c'o o ma c'ua cja o fariseo. O xipjiji c'o vi tsja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nuc'ua c'o ndamböcjimi 'ñe c'o fariseo o jmurüji c'ua. O pötva mamaji: ―¿Pje rá cjagöji? C'e bëzo Jesús, cja'a na puncjü c'o me na nojo. ");
INSERT INTO mazNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","'Ma rá jëzitjoji ra tsja a cjanu, ra nda 'ñejme angueze texe yo ín menzumügöji ra tsjapüji o̱ jmuji. Nguec'ua c'o menzumü a Roma c'o mandazüji dya, ra 'ñe yätcöji ne templo nu ja rí ma't'üji Cjimi. A cja dya nu rá chorügöji. ");
INSERT INTO mazNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'Naja c'o mi jmurü, mi chjũ e Caifás. Nuc'ü, mi mero ndamböcjimi c'e cjë'ë c'ü. O xipjiji: ―Nu'tsc'eji, dya pje i̱ṉ pãrãgueji. ");
INSERT INTO mazNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Dya i̱ṉ pãrãji c'ü xenda na jo c'ü ri 'natjo bëzo c'ü ra ndũ ngue c'ua dya ra ndũ texe yo nte. ");
INSERT INTO mazNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","C'e Caifás mi mero ndamböcjimi c'e cjë'ë c'ü, nguec'ua Mizhocjimi o tsjapü o mama c'ü ro zäda zö dya mi pãrã e Caifás ja cja c'ü mi mama. O mama ro ndũ'ũ e Jesús ngue c'ua dya ro ndũ c'o mejñiñi. ");
INSERT INTO mazNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Dya nguextjo anguezeji c'o dya ro ndũ. Xo ro ngãrãtjo na puncjü nte texe cja ne xoñijõmü c'o dya ro ndũ na ngueje ro 'ñench'e o̱ mü'büji e Jesús, ro tsjaji o̱ t'i Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ndeze c'e pa c'ü, mi pötma dyü't'ütsjëji ja rvá tsjapüji ro mbö't'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nuc'ua e Jesús dya cja nzhodü c'ü ro jñanda c'o pje mi pjëzhi a Jerusalén. O mbedye cja c'e xoñijõmü a Judea. Je o ma'a cja c'e xoñijõmü c'ü bübü a jmi'i cja c'e ndajyadü. O ma cja 'naja jñiñi c'ü ni chjũ'ũ Efraín. Ya je nguejme nu, co nu c'o o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","C'e mbaxua c'ü cja yo nte a Israel c'ü ni chjũ Pascua ya ma sädätjo. Na puncjü c'o nte o möji a ma Jerusalén 'ma dya be mi sädä c'e mbaxua. Ro 'nintspiji ante c'ü ro mbedye c'e mbaxua. ");
INSERT INTO mazNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nuc'ua mi jodüji c'ua e Jesús. Mi pötma mamaji 'ma mi bübüji cja c'e templo: ―¿Pje i̱ṉ mangueji? ¿Cjo ra rezga ra ẽjẽ e Jesús cja c'e mbaxua?, mi eñeji. ");
INSERT INTO mazNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","C'o ndamböcjimi 'ñe c'o fariseo ya vi mandaji, nu 'ma cjó c'o ro mbãrã ja je mi bübü e Jesús ro ngös'üji anguezji ngue c'ua ro ma zürüji. ");
INSERT INTO mazNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","'Ma xe mi bëzhtjo 'ñanto pa'a ro zädä c'e mbaxua c'ü ni chjũ Pascua, o ma c'ua e Jesús a Betania nu ja je mi bübü e Lázaro c'ü vi ndũ'ũ. Nuc'ü, vi xos'ü cja c'o añima. ");
INSERT INTO mazNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","O dyä'tp'äji nu 'na jñõnü e Jesús. Ngueje e Marta c'ü mi xisp'i. E Lázaro mi ngue 'naja c'o mi junrü co e Jesús cja mexa. ");
INSERT INTO mazNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nuc'ua e María o tũ'ũ nde kilo o ungüento c'ü mi dyavo nardo. Me mi muvi na mizhi. O ngosp'ü c'ua o̱ ngua'a e Jesús. Cjanu o ndintspi co o̱ ñixti. Nu cja c'e ngumü me co jyä'ä c'ü mi yüdü c'e ungüento. ");
INSERT INTO mazNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Xo mi bübü nu, e Judas Iscariote c'ü mi ngue o̱ t'i e Simón. Mi ngue 'naja c'o o̱ discípulo e Jesús. Ngue c'e Judas c'ü ro nzhö'ö e Jesús. O mama e Judas: ");
INSERT INTO mazNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Jenga dya vi bö'ö jñi ciento mbëxo ne ungüento; ro ch'unü c'o dya pje pë's'i? ");
INSERT INTO mazNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","C'ü vi mama a cjanu e Judas, dya ngue c'ü mi juentse c'o dya pje mi pë's'i. Na ngue dya mi juentse c'o. C'ü vi mama yo jña'a yo, ngue c'ü mi mbẽ'ẽ. Mi pjörü c'e cjĩmerio, y mi quibi c'o je mi üt'üji nu. ");
INSERT INTO mazNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nuc'ua e Jesús o mama: ―Jyëzigue. E María o ngoscü ne ungüento; ngue c'ü ra tsjacüji 'ma ya rga tũ'ũ. Pero angueze na mbenze dya. ");
INSERT INTO mazNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sido i̱ṉ bübügueji yo dya pje pë's'i. Pero nutscö, dya sido rá bünc'öji. ");
INSERT INTO mazNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nuc'ua na puncjü o nte c'o mi cãrã a Israel o mbãrãji mi bübü nu e Jesús, nguec'ua va möji nu. Dya mi nguextjo c'ü ro ma nuji e Jesús. Xo mi möji ro ma nuji e Lázaro, c'ü vi xos'ü cja c'o añima. ");
INSERT INTO mazNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nguec'ua c'o ndamböcjimi o dyü't'ütsjëji ngue c'ua xo ro mbö't'üji e Lázaro. ");
INSERT INTO mazNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Na ngueje na puncjü o nte a Israel c'o mi xõgüji co anguezeji mi möji cja e Jesús. Mi ejmeji angueze, na ngueje vi xos'ü e Lázaro. ");
INSERT INTO mazNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","C'ü na yejnu pa'a na puncjü nte'e c'o vi möji cja c'e mbaxua o dyäräji ro ẽjẽ e Jesús a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nuc'ua o ngant'aji o̱ dyë o palma. Cjanu o mbedyeji c'ua, o ma ndünrüji e Jesús. Mi mapjüji, mi mamaji a cjava: ―Aleluya. Me na jo nu va ẽjẽ nu o 'ñeme Mizhocjimi ra mandazüji nutscöji rí menzumüji a Israel. ");
INSERT INTO mazNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","E Jesús o chöt'ü 'naja burru. O chägä c'ua, c'ua ja nzi ga t'opjü cja o̱ jña Mizhocjimi. Mama a cjava c'ü: ");
INSERT INTO mazNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nu'tsc'eji i̱ṉ menzumüji a Sion, dya rí sũji. Jñandaji. Va ẽjẽ cjuã in Jmugueji. Nuc'ü, va chägä 'naja burru c'ü, eñe cja o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","C'o o̱ discípulo e Jesús, dya be mi pãrãji ja ma cja nu yo jña'a yo. Nuc'ua 'ma ya vi ma a jens'e e Jesús, ngue 'ma cja o mbeñeji c'ü ngueje e Jesús c'ü vi t'opjü yo jña yo. Cja nde o mbeñeji c'ua c'ü vi ts'a a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","C'o nte c'o vi jñanda e Jesús 'ma o tsjapü o te'e e Lázaro 'ma o zopjü ro mbedye cja c'e cueva, nuc'o, o xipjiji c'o dyaja. Nguec'ua va mbãrã c'o dyaja, nguec'ua va ma ndünrüji e Jesús ante c'ü ro säjä a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","O pötva mama c'ua c'o fariseo: ―Nu'tsc'eji ya i̱ ñutsjëji, dya sö pje rí tsjaji c'ü rí ts'a's'üji e Jesús. Texe yo nte ya tjünt'üji a xütjü angueze, ya nde möji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Xo mi cãrã ja nzi nte c'o mi ña griego c'o vi ma ma't'ü Mizhocjimi cja c'e mbaxua. ");
INSERT INTO mazNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nuc'ua c'o griego o zät'äji cja e Felipe c'ü mi menzumü a Betsaida c'ü tsja a Galilea. O dyötüji, o xipjiji: ―Nu'tsc'e sẽ'ẽ, nutscöjme rí negöjme rá chjëjme e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","O ma c'ua e Felipe; o ma xipji e Andrés. O mëvi c'ua; o ma xipjivi e Jesús c'ü ya mi cãrã o griego. ");
INSERT INTO mazNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","O ndünrü c'ua e Jesús, o mama: ―Ya va sädä rá tũgö, rá magö a jens'e cja Mizhocjimi nu ja rvá ẽcjö. ");
INSERT INTO mazNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nuzgö, na cjuana c'ü rí xí'ts'iji. 'Naja ndëxü c'ü ya ra zobü a jõmü, 'ma ra nguibi a jõmü, ra mbes'e ra unü na puncjü ndëxü. C'e ndëxü 'ma dya ra nguibi a jõmü, ra nguejme 'natjo ndëxü. ");
INSERT INTO mazNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nu c'ü s'iyatsjëjë o̱ vida, nuc'ü, ra ndũ'ũ c'ü. Nu c'ü dya s'iyatsjëjë o̱ vida nu va cja ne xoñijõmü, nuc'ü, sido ra bübütjo c'ü. Dya ra ndũ'ũ. ");
INSERT INTO mazNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nu c'ü ne ra ndünt'ü ín xütjügö, ni jyodü sido ra 'ñejme ín jñagö. Nu ja je rá bübügö je xo ra bübü nu. Mi Tatagö a jens'e ra s'iya nu c'ü sido ejme ín jñagö. ");
INSERT INTO mazNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Nudya me sufrido ín mü'bügö. ¿Pje rá mamagö? ¿Cjo rá xipji mi Tata a cjava: “Mi Tatats'ü rí ts'a's'ü ngue c'ua dya rá tũgö”? Jiyö, dya rá xipji a cjanu, na ngueje, ngueje yo rvá ẽjẽ cja ne xoñijõmü. Ró ẽ rá tũgö. ");
INSERT INTO mazNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nguec'ua rí tsjague c'ua ja nzi gui ñegue rá tũgö, ngue c'ua ra mbãrã yo nte c'ü me na nojots'ügue, nu'tsc'e mi Tatats'ü. Nuc'ua o dyäräji 'naja jña a jens'e, o mama: ―Ya ró jíchi yo nte c'ü me na nojozügö. Pero xe rá jíchitjoji c'ü me na nozgö. ");
INSERT INTO mazNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","C'o nte c'o mi cãrã nu, o dyäräji c'e jña c'ü vi 'ñeje a jens'e. O mamaji c'ua c'ü vi yürü. Pero bübü c'o mi mama: ―Ngueje 'naja o̱ anxe Mizhocjimi c'ü o zopjü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","O ndünrü c'ua e Jesús, o xipjiji: ―I̱ dyäräji c'e jña. Dya pje nguetjozügö o zocü. O zo'c'ü i̱ṉ texeji, ngue c'ua rí unnc'eji na puncjü ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Na ngue c'o ya ngue ra tsjacöji, ra 'ñetse c'ü nugü na ü yo nte yo cãrã cja ne xoñijõmü. Nguec'ua Mizhocjimi ra tsjapü ra sufridoji. C'ü dya jo c'ü manda cja ne xoñijõmü, Mizhocjimi ya ra pjongü a tji dya c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","'Ma ra ndäpcäji cja ngronsi, nuc'ua yo nte ra nguijñiji cja o̱ mü'büji. Ra mbãrãji pje pjëtscö. ");
INSERT INTO mazNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mi mama a cjanu yo, ngue c'ua ro mbãrãji ja rvá ndũ'ũ. ");
INSERT INTO mazNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","O ndüntü c'ua c'o nte, o mamaji: ―Nutscöjme ya ró äräjme c'ü mama cja o̱ ley Mizhocjimi c'ü o dyopjü e Moisés. Mama a cjava: “E Cristo, nu c'ü ra ndäjä Mizhocjimi, sido ra bübütjo”, eñe. ¿Jenga i̱ṉ mangue ni jyodü ra däpc'ä cja ngronsi? Maco i̱ṉ mangue vi 'ñegue cja Mizhocjimi. ¿Cjo dya ri ngue'tsc'e 'ma e Cristo? O, ¿ja ga cja c'ü i̱ṉ xitscöjme? ");
INSERT INTO mazNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","E Jesús o ndünrü c'ua: ―Xe ja nzi pa xe rá bübütjogö rí jya's'ü c'ua i̱ṉ cãrãgueji. Jyëziji ra nguich'i jya's'ü cja in mü'büji 'ma xe rí bübütjogö va, ngue c'ua dya rí nzhodügueji cja bëxõmü. Na ngueje 'ma rí nzhodüji cja bëxõmü, dya rí pãrãji ja rí möji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nudya, nutscö rí jya's'ü xe rí bübügö a nde c'ua ja i̱ṉ cãrãgueji. Rí 'ñejmezüji, ngue c'ua ra bübü o̱ jya's'ü Mizhocjimi a mbo cja in mü'büji. Nu yo jña'a yo, o mama e Jesús. Cjanu o ma'a c'ua. Dya cja jñandaji ja vi ma'a. ");
INSERT INTO mazNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E Jesús ya vi tsja na puncjü c'o na nojo cja o̱ jmi anguesji; pero dya mi ejmeji angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","A cjanu o zädä c'o vi mama e Isaías c'ü mi profeta. O mama: Nu'tsc'e, ín Jmuts'ügö. ¿Cjó ngue c'ü ya o 'ñejme nu c'o ró mamaji? ¿Cjó ngue c'ü ya o unü na jo ngüenda c'ü me na zëzhi c'ü ín Jmugöji? Dya cjó 'ñejme. Dya cjó ne ro jñanda, eñe c'e profeta. ");
INSERT INTO mazNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nguec'ua dya cjó sö cjó ro 'ñench'e o̱ mü'bü Mizhocjimi. Xo o mama a cjava e Isaías: ");
INSERT INTO mazNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Mizhocjimi o tsjapü o ndëzhöji. Xo o tsjapü o meze o̱ mü'büji, nguec'ua dya o 'ñejmeji. 'Ma ro unüji na jo ngüenda, 'ma ro 'ñejmeji cja o̱ mü'büji, nu'ma, ro nzhogü o̱ mü'büji, nuc'ua ro mama 'ma Mizhocjimi: “Nutscö rá jopcüji o̱ mü'büji.” ");
INSERT INTO mazNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nu yo jña'a yo, o mama e Isaías na ngueje o jñanda c'ü me na nojo e Cristo. O mama c'ua ja rva cja e Cristo. ");
INSERT INTO mazNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na puncjü c'o pje mi pjëzhi mi ejmeji e Jesús. Pero dya mi ne ro mamaji cjo mi ejmeji. Ngue c'o fariseo c'o mi sũji. Mi sũ anguesji ro pjongüji cja o̱ nintsjimiji. ");
INSERT INTO mazNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Xenda mi sũji c'o mama c'o bëzo que na ngueje c'o mama Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nuc'ua e Jesús o ña na jens'e, o mama: ―Nu c'ü ench'ezügö cja o̱ mü'bü, xo ench'e cja o̱ mü'bü nu c'ü o ndäcjägö. ");
INSERT INTO mazNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nu c'ü jandgagö, 'ñe unü ngüenda cjó je nguetscö, xo unü ngüenda ja ga cja c 'ü o ndäcjägö. ");
INSERT INTO mazNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ró ẽjẽ cja ne xoñijõmü; nguetscö e jya's'ü. Texe c'o ench'ezügö cja o̱ mü'büji, dya ra nzhodüji cja bëxõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","'Ma cjó c'o ra dyärä yo jña yo rí mangö, pero 'ma dya ätcä, dya nguezgö rá mama c'ü ni jyodü ra ma sufrido c'ü. Na ngueje c'ü rvá ẽcjö cja ne xoñijõmü, dya ngue c'ü rá cjapü ra ma sufrido yo cãrã; ngue c'ü rá salvaji. ");
INSERT INTO mazNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nu c'o dya ejmezü y dya xo ätcä yo rí mama, bübü c'ü ra jñünpü nguarü c'ü. Na ngueje 'ma rá ẽcjö na yeje, yo jña yo ró mangö ngueje c'ü rguí tjünpü nguarü c'o vi tsja na s'o c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na ngueje nutscö, dya ró mamatsjëgö yo jña'a yo. Mi Tata a jens'e c'ü o ndäcjä ngueje c'ü o mandazü ró xi'ts'iji yo jña'a yo, xo xitsi ja rvá zo'c'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Rí pãrãgö yo jña'a yo o ndäcjä mi Tata ró ẽ mama ngueje yo jña yo cjapü sido ra bübütjo yo nte. Rí mangö yo jña yo xitsi mi Tatagö. ");
INSERT INTO mazNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","'Ma xe mi bëzhitjo ro zädä c'e mbaxua c'ü xiji Pascua, ya mi pãrã e Jesús ya vi zädä c'ü ro ndũ; ro mbedye cja ne xoñijõmü. Je ro ma cja nu Tata c'ü bübü a jens'e. Me mi s'iya c'o mi cãrã cja ne xoñijõmü c'o mi ench'e o̱ mü'bü angueze. Y o tsja c'ua c'ü ni 'ñetse me mi s'iyaji na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","E Jesús 'ñe c'o o̱ discípulo ma siji xëdyi. E Judas Iscariote c'ü mi nguejnu t'i e Simón, ya vi dyätä c'ü dya jo ro nzhö e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ya mi pãrã e Jesús, c'ü nu Tata a jens'e ya vi unü texe poder ngue c'ua ro manda. E Jesús mi pãrã je vi 'ñeje cja Mizhocjimi, y ro nzhogü cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","O böbü c'ua e Jesús nu ja ma siji o xëdyi, o ngãcã o̱ bitu c'ü mi tëjë. Cjanu o ngãjã c'ua 'naja bitu c'ü o mbä'bä. ");
INSERT INTO mazNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Cjanu o xich'i c'ua ndeje 'naja ts'i ndamojmü c'ü mi xindyëji. Cjanu o mbürü o mbe'chp'e o̱ ngua'a c'o o̱ discípulo. Mi tjintspi c'ua co nu c'ü o̱ bitu c'ü mi pä'bä. ");
INSERT INTO mazNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cjanu o böbü a jmi e Simón Pedro. E Pedro o xipji: ―Nu'tsc'e, ín Jmuts'ügö. ¿Jenga rí pechquegö ín cua'a? ");
INSERT INTO mazNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","O ndünrü e Jesús, o xipji: ―Nu yo rrã cjagö, dya i̱ṉ pãrãgue dya. Cja rí pãrã después nu yo rrã cjagö. ");
INSERT INTO mazNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","O ndünrü c'ua e Pedro: ―Dya pje rá jë'tsc'i rí pechquegö ín cua'a. O ndünrü c'ua e Jesús, o xipji: ―Nu 'ma dya rí jyëtsqui rá pe'chc'e, dya pje rí jogövi. ");
INSERT INTO mazNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","O mama c'ua e Simón Pedro: ―Nu'tsc'e, ín Jmuts'ügö. Dya nguextjo ín cua c'ü rí pechque. Xo rí pechque ín dyë'ë 'ñe ín jmi'i. ");
INSERT INTO mazNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","O mama c'ua e Jesús: ―Nu c'o ya xaja, ya nguetjo o̱ nguaji c'ü xe ra be'chp'eji, ngue c'ua ra nda chjĩzĩ texe. Nu'tsc'eji ya chjĩzĩts'üji na jo, pero dya chjĩzĩts'üji i̱ṉ texeji. ");
INSERT INTO mazNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","E Jesús ya mi pãrã cjó ngue c'ü ro nzhö'ö, nguec'ua o mama a cjanu: “Dya chjĩzĩts'üji i̱ṉ texeji.” ");
INSERT INTO mazNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nuc'ua 'ma o nguarü o mbe'chp'e o̱ nguaji, cjanu o ngans'a c'ua o̱ bitu, o ndëjë. O mimitjo c'ua na yeje cja mexa. Cjanu o dyönüji c'ua, o xipjiji: ―¿Cjo i̱ṉ pãrãji yo cja ró cja'c'üji? ");
INSERT INTO mazNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nu'tsc'eji i̱ṉ xitsiji que nguezgö in xöpütezüji, nguezgö in Jmuzüji. Na jo c'ü i̱ṉ mamaji, na ngueje na cjuana. ");
INSERT INTO mazNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nuzgö in xöpütezüji, in Jmuzüji, ró pe'chc'egö in cuaji. Nguec'ua, nu'tsc'eji xo ni jyodü rí pötqui pe'ch'e in cuaji. ");
INSERT INTO mazNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nuzgö c'ua ja nzi rvá cja'c'üji, nu'tsc'eji, xo ni jyodü rí pötqui tsjagueji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na cjuana c'ü rí xi'ts'iji, 'naja mbëpji, dya xenda na nojo que na ngueje o̱ lamu. Ne xo ri ngueje c'ü o däjä, dya xenda na nojo que na ngueje nu c'ü o ndäjä. ");
INSERT INTO mazNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nu 'ma i̱ṉ pãrãji yo, me rí mäjäji 'ma rí tsjaji. ");
INSERT INTO mazNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Rí pãrãgö ja ga cjatsc'eji nu'tsc'eji ró juan'c'üji. Rí pãrãgö bübütsc'eji 'naja c'ü ra tsja c'ua ja nzi ga t'opjü c'ü mama a cjava: “Maco mi dyocjöbe c'e bëzo y ma sigöbe o xëdyi, pero ra nzhögü c'ü.” Dya i̱ṉ texeji rí tsjaji yo. ");
INSERT INTO mazNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Rí xi'ts'iji yo, 'ma dya be va sädä ngue c'ua 'ma ra zädä yo, rí 'ñejmeji, nu c'ü ya ró xi'ts'iji, rvá ẽcjö cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na cjuana c'ü rí xi'ts'iji, nu 'ma rá täc'öji rí zopjüji yo nte, nu c'ü ra säc'eji nguetscö säcjö 'ma c'ü. Nu 'ma ra säcjö c'ü, xo säjä 'ma c'ü o ndäcjägö. ");
INSERT INTO mazNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","'Ma o nguarü o mama a cjanu e Jesús, me go nguijñi go sufrido o̱ mü'bü c'ua. O xipjiji na jo: ―Na cjuana c'ü rí xi'ts'iji, nu'tsc'eji bübütsc'eji 'naja c'ü ra nzhögü. ");
INSERT INTO mazNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nuc'ua c'o o̱ discípulo mi pötma jñandaji. Dya mi pãrãji cjó ngue c'ü je vi mama. ");
INSERT INTO mazNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","'Naja c'o o̱ discípulo 'natjo c'ua mi junrüvi e Jesús. E Jesús me mi s'iya c'e discípulo. ");
INSERT INTO mazNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","E Simón Pedro o tsjapü seña c'e discípulo ngue c'ua ro tsja t'önü cjó je ngue c'ü mi xipji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nuc'ua c'e discípulo c'ü 'natjo c'ua mi junrüvi e Jesús o dyönü: ―Nu'tsc'e, ín Jmuts'ügö, ¿cjó ngue c'ü ra nzhöc'ügue? ");
INSERT INTO mazNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","O ndünrü c'ua e Jesús, o xipji: ―Nu c'ü rá unü ne xëdyi nu rá tü'bü cja ne jñõnü ngue c'ü ra nzhögü c'ü. Cjanu o ndü'bü c'ua, cjanu o unü e Judas Iscariote c'ü nu t'i e Simón. ");
INSERT INTO mazNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nuc'ua e Judas, 'ma o jñü'ü c'e xëdyi, o nguich'i c'ua c'ü dya jo cja o̱ mü'bü. E Jesús o xipji c'ua: ―Nu c'o rí tsjague, ya extí ma'a rí ma tsjague c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nu c'o dyaja c'o mi junrü cja mexa, dya pje mbãrãji jenga mi xipji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","E Judas mi tũ'ũ c'e cjĩmerio. Mi cãrã c'o discípulo c'o mi cjijñi e Jesús mi xipji e Judas ro ma ndõmü c'o mi jyodü cja c'e mbaxua. Mi cãrã c'o mi cjijñi mi xipji e Jesús c'ü ro ma unü merio c'o dya pje mi pë's'i. ");
INSERT INTO mazNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nuc'ua e Judas 'ma o jñü'ü c'e xëdyi, exo mbedye c'ua. Ya mi xõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nuc'ua 'ma o mbedye e Judas, o mama c'ua e Jesús: ―Nutscö rvá ẽcjö cja Mizhocjimi, rá cjagö dya nu c'ü rvá ẽjẽ rá cja'a. A cjanu ra 'ñetse c'ü me na nojozügö. A cjanu xo ra 'ñetse c'ü me na nojo Mizhocjimi c'ü ngueje mi Tatagö. ");
INSERT INTO mazNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","C'ü rá cjagö, ya zädä rá cjagö. Nguec'ua ra 'ñetse c'ü me na nojo Mizhocjimi. Nuc'ua Mizhocjimi ra tsjapü ra 'ñetse c'ü me na nojozü, nutscö rvá ẽcjö cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nu'tsc'eji ín ch'itsc'öji, ya 'natjo ndajme xe rá bübü co nu'tsc'eji. Rí jyongügöji. C'ua ja nzi rvá xipji c'o pje pjëzhi cja c'o nte a Israel, a cjanu xo rí xi'ts'igöji dya. Nu ja je rá magö, nu'tsc'eji, dya ra sö rá möcjöji dya. ");
INSERT INTO mazNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Rí xi'tsc'öji 'na jña nu cja dadyo. Nguejnu rí tsjaji nu. Rí pötqui s'iyaji. C'ua ja nzi rvá s'iyats'ügöji, je xo rgui s'iyagueji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'Ma rí pötqui s'iyaji, a cjanu ra mbãrã texe yo nte ngue'tsc'eji ín discípulots'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","E Simón Pedro o xipji e Jesús: ―Nu'tsc'e ín Jmuts'ügö. ¿Ja je rí mague? O ndünrü c'ua e Jesús, o xipji: ―Nu ja je rá magö, dya pje ra sö rá möcjöji dya. Cja ne rí sät'ägueji después nu ja je rá sätc'ö. ");
INSERT INTO mazNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","O ndünrü c'ua e Pedro: ―Nu'tsc'e, ín Jmuts'ügö, ¿jenga dya ra sö rá mëgovi dya? Nutscö rá nzhötsjëjë ngue c'ua ra mbötcüji c'ü dya ra mbö'tc'ügueji. ");
INSERT INTO mazNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","O ndünrü e Jesús, o xipji: ―Nu'tsc'e Pedro, i̱ṉ mangue rí nzhötsjë ra bö'tc'ü ngue c'ua dya ra bötcügö. Pero na cjuana c'ü rí xi'ts'igö, 'ma rí dyärä ra huë'ë o chare, ya rí pa na jñi rgui tsänngä c'ü i̱ṉ pãcãgö. ");
INSERT INTO mazNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Xe ma ña'a e Jesús, o mama: ―Dya me ra triste in mü'büji. Rí 'ñench'e in mü'büji Mizhocjimi. Xo rí 'ñench'ezügö cja in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A jens'e nu ja bübü mi Tatagö, nunu, me järä na puncjü ja rá bübügöji. Nuzgö ya rá magö a manu, rá ma xã'mã nu ja rí bübügueji. Nu 'ma dya ri järä na puncjü o ngumü nu ja rí bübügueji, dya ro xi'ts'iji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nuzgö na cjuana rá magö, rá ma xã'mãgö nu ja je rí bübügueji. Pero rá ẽtcjö na yeje. Rá sints'iji ngue c'ua nu ja je rá magö, nu'tsc'eji xo rí ma bübügueji nu. ");
INSERT INTO mazNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nu'tsc'eji ya i̱ṉ pãrãji nu ja je rá magö. Xo i̱ṉ pãrãji c'e 'ñiji c'ü je sät'ä nu. ");
INSERT INTO mazNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nuc'ua e Tomás o xipji: ―Nu'tsc'e, ín Jmuts'üjme, dya rí pãrãgöjme nu ja je rí mague. ¿Ja rgá sö rá pãrãgöjme c'e 'ñiji c'ü je sät'ä nu? ");
INSERT INTO mazNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","O ndünrü c'ua e Jesús, o mama: ―Nuzgö nguetscö e 'ñiji. Nguetscö rí jí'ts'iji c'ü na cjuana ja ga cja Mizhocjimi. Nguetscö rí da'c'üji c'ü sido rí bübütjoji. 'Ma cjó c'o ra 'ñench'ezü cja o̱ mü'bü, ra zät'ä a jens'e 'ma nu ja bübü mi Tatagö. 'Ma jiyö, dya ra sö ra zät'ä. ");
INSERT INTO mazNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nu 'ma ya ri pãcãgöji, ya xo ri pãrãji mi Tata. Nudya, ya i̱ pãrãji mi Tata, ya i̱ jñandaji dya angueze. ");
INSERT INTO mazNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","E Felipe o xipji c'ua: ―Nu'tsc'e, ín Jmuts'üjme, jítsigöjme c'ü nin Tata. Nguextjo c'ü rí negöjme c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","E Jesús o xipji c'ua: ―Nu'tsc'e Felipe, ya mezhe rí bübügöji. ¿Cjo dya be i̱ṉ pãrã cjó je nguetscö? Nu c'ü ya o jñandga, ya xo jñanda mi Tatagö c'ü ngueje Mizhocjimi. ¿Jenga i̱ṉ mamague: “Jítsijme c'ü nin Tata”? ");
INSERT INTO mazNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Cjo dya i̱ṉ ejmegue je rí bübügö cja mi Tata, y mi Tata je bübüzügö? Yo jña'a yo rí xi'ts'igöji, dya pje rí mamatsjëgö yo. Ngueje mi Tata c'ü je bübüzügö c'ü xitsi rá cja yo rí cjagö. ");
INSERT INTO mazNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ya ró xi'ts'iji rí bübügöbe mi Tata, je xo bübüzügö mi Tata. 'Ma dya sö rí jñunt'ü in mü'büji c'ü ró xi'ts'itjoji, 'ñejmeji na ngueje yo na nojo yo rí cjagö. ");
INSERT INTO mazNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nuzgö, na cjuana c'ü rí xi'ts'iji, nu c'ü ra 'ñejmezügö, xo ra tsja c'ua ja nzi rgá cjagö. Nuzgö ya ngue rá magö cja mi Tata. Nuc'ua nu c'ü ra 'ñejmezügö rá unü c'ü ra tsja c'ü xenda na nojo que na ngue yo rí cjagö. ");
INSERT INTO mazNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","'Ma rí jyodü rí tsjaji c'ua ja nzi rgá negö, ra sö rí dyötüji mi Tata a jens'e. Nuc'ua rá da'c'üji c'ua ja nzi gui dyötüji c'ü. A cjanu ra 'ñetse c'ü me na nojo mi Tatagö c'ü ngueje Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","'Ma pje rí dyörüji na ngueje i̱ṉ ejmezü, nutscö rá cja'a. ");
INSERT INTO mazNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Nu 'ma i̱ṉ s'iyazüji, rí tsjaji yo rí mandats'ügöji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nutscö rá ötügö mi Tata a jens'e. Angueze ra ndäjä ne 'naja ra ẽ bübü co nu'tsc'eji c'ü ra 'ñe mböxc'üji. Sido ra bübüts'ügueji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nu c'ü ra dya'c'üji Mizhocjimi ngueje o̱ Espíritu c'ü ra jí'ts'iji ja ga cja Mizhocjimi. Nu c'o cãrã cja ne xoñijõmü c'o dya ench'ezü cja o̱ mü'büji, o̱ Espíritu Mizhocjimi dya sö ra bübüji, na ngueje dya pãrãji angueze, ni xo pãrãji ja ga pëpji c'ü. Pero nu'tsc'eji i̱ṉ pãrãgueji na ngueje bübü co nu'tsc'eji. Xo ra bübü cja in mü'bügueji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nuzgö dya rá sogüts'üji nza cja 'na jyoya. Nuzgö rá yepe rá nzhogütjogö rá ẽjẽ va ja i̱ṉ cãrãgueji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dya cja ra mezhe c'ü xe ra jñandga yo cãrã cja ne xoñijõmü. Pero nu'tsc'eji rí jñandgaji. Sido rá bübütjogö, nguec'ua nu'tsc'eji xo sido rí bübütjogueji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nu'tsc'eji, 'ma ra zädä c'e pa'a c'ü ra ẽjẽ o̱ Espíritu Mizhocjimi, rí pãrãji je rí bünc'öbe mi Tata. Xo rí pãrãji i̱ṉ bünc'eji co nutscö, 'ñe nutscö rí bünc'ö cja in mü'bügueji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nu c'ü pãrã yo rí mandagö, c'ü xo ra tsja'a yo rí mandagö, ngueje c'ü s'iyazü c'ü. Mi Tatagö xo ra s'iya nu c'ü s'iyazü. Nuc'ü, xo rá s'iyagö c'ü. Nuc'ü, xo rá cjapü ra mbãcã na jo'o. ");
INSERT INTO mazNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","O ndünrü c'ua e Judas c'ü dya mi ngueje e Judas Iscariote, o mama: ―Nu'tsc'e, ín Jmuts'ügöjme. ¿Ja rgá sö'ö rí tsjacüjme rá pã'c'ãjme c'ü dya ra mbã'c'ã yo cãrã cja ne xoñijõmü? ");
INSERT INTO mazNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","O ndünrü c'ua e Jesús, o xipji: ―Nu c'o s'iyazügö ra tsja'a yo rí mama. Nuc'ua ra tsja mi Tatagö xo ra s'iyaji anguezeji. Nuc'ua nutscöbe rá ẽ bübügöbe cja o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nu c'o dya s'iyazü, dya xo cja'a yo rí mama. C'o jña'a c'o rí mangö, dya pje rí mamatsjëgö yo. Mi Tatagö c'ü o ndäcjägö, xitsi rá mama yo jña'a yo. ");
INSERT INTO mazNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Nu yo jña'a yo, rí xi'ts'iji dya yo, nudya xe rí bübü cja in jmiji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mizhocjimi c'ü ngueje mi Tatagö ra ndäjä nu c'ü ra 'ñe mböxc'üji c'ü ngueje o̱ Espíritu angueze. Nuc'ü, ra pätcägö c'ü. Ra xö'c'üji texe, ra mbeñc'eji texe c'o ró xi'ts'igöji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Yo nte 'ma zenguaji yo nín minteji, xipjiji ra söyaji. Pero c'o o̱ mü'büji sido sũ'ũ, dya söya. Nutscö, söya ín mü'bügö, rá cjapü ra söya in mü'bügueji. Nuzgö ya rá magö. Pero dya rí sũ'ũji, ra söya in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ya me sũ in mü'bügueji na ngueje ya i̱ dyäräji c'ü ró xi'ts'iji ya rá magö. Rá nzhogü rá ẽtcjö c'ua ja ri cãrãgueji. Nu 'ma xenda ri s'iyazüji, me ri mäcjeji 'ma, na ngueje rá ma cja mi Tata a jens'e. Na ngueje mi Tatagö xenda na nojo que na nguezgö. ");
INSERT INTO mazNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ya ró xi'ts'iji dya, nudya dya be sädä. Ngue c'ua 'ma ra zädä, sido rí 'ñejmezüji. ");
INSERT INTO mazNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Dya cja xe rá ñaji na puncjü, na ngueje va ẽjẽ c'o nte c'o pëpi c'ü dya jo. C'ü dya jo manda cja o̱ mü'bü yo cãrã cja ne xoñijõmü. Pero dya sö ra manda cja ín mü'bügö. ");
INSERT INTO mazNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero ni jyodü ra mbãrã yo cãrã cja ne xoñijõmü, nuzgö me rí s'iyagö mi Tata. Nguec'ua rí cjagö c'o mandazü mi Tata. Böbüji. Rá pedyeji va. ");
INSERT INTO mazNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","O mama e Jesús: ―Na cjuana nguetscö e za'a c'ü me na jo. Mi Tatagö a jens'e ngue c'ü pjörü c'e za'a c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Texe o dyëza c'ü bübüzügö c'o dya quis'i, ra dyëch'iji. Texe dyëza c'o quis'i, ra dyodüji ngue c'ua xenda ra nguis'i na puncjü. ");
INSERT INTO mazNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nu'tsc'eji ya i̱ 'ñejmeji c'o jña'a c'o ya ró xi'ts'iji, nguec'ua ya jogü in mü'büji dya. ");
INSERT INTO mazNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sido rí 'ñejmezügöji, nuc'ua nutscö sido rá bübü cja in mü'büji. Chjëntjovi nza cja 'naja dyëza, 'ma dya ra bübü cja c'e za'a, dya ra nguis'i. Xo rga cjatjots'ügueji nu, nu 'ma dya sido rí 'ñejmezügöji, dya xo sö rí tsjaji nu c'ü rí negö. ");
INSERT INTO mazNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Nutscö nguetscö e za'a. Nu'tsc'eji ngue'tsc'eji o dyë'ë. Nu c'ü sido ra 'ñejmezügö, nutscö sido rá bübügö cja o̱ mü'bü c'ü. Nuc'ü, ra sö ra tsja nu c'ü rí negö. Nu'tsc'eji, dya ra sö pje rí tsjaji c'ü rí negö, 'ma dya rí 'ñejmezügöji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nu c'ü dya sido ra 'ñejmezügö chjëntjovi nza cja 'na dyëza c'ü dya jo, c'ü panatjoji, cja na dyot'ü c'ua, cja na jñüs'üji c'ua, cja na ngöt'üji a sivi, ra ndë'ë. ");
INSERT INTO mazNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Nu 'ma sido rí 'ñejmezügöji, nu 'ma sido ra bübü ín jñagö cja in mü'bügueji, nuc'ua dyörüji c'ü rí ñe'eji. A cjanu ra dya'c'üji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nu 'ma rí tsjaji c'ü rí negö, ra 'ñetse 'ma c'ü ri ngue'tsc'eji ín discípulots'ügöji. A cjanu ra 'ñetse 'ma, c'ü me na nojo mi Tatagö. ");
INSERT INTO mazNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","C'ua ja va s'iyazügö mi Tata a jens'e, je xo rvá s'iyats'ügöji. Sido rí tsjaji c'ü rí negö na ngueje rí s'iyats'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mi Tatagö a jens'e me sido s'iyazügö c'ü, na ngueje rí cjagö c'o mandazü angueze. A cjanu sido rá s'iyats'üji 'ma rí tsjaji c'o rí mandats'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ró xi'ts'iji nu yo jña'a yo, ngue c'ua ra mäjä in mü'büji c'ua nzi rgá mäjägö. A cjanu, na cjuana me rí mäcjeji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ngueje nu rí mandats'üji nu, rí pötqui s'iyaji c'ua ja nzi rvá s'iyats'ügöji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nu c'ü xenda s'iyate ngue c'ü ra unütsjëjë c'ü ra bö't'ü c'ü; ngue c'ua dya ra bö't'ü c'ü jovi. ");
INSERT INTO mazNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nu'tsc'eji ngue'tsc'eji rí jogöji, nu 'ma rí tsjaji yo rí mandats'ügöji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Dya cja rá xi'ts'iji c'ü ri ngue'tsc'eji ín mbëpjits'ügöji, na ngueje 'naja mbëpji dya pãrã c'o cja'a o̱ lamu. Rí xi'ts'iji dya, c'ü ngue'tsc'eji rí joji dya, na ngueje texe c'o ró ärägö cja mi Tata a jens'e, ya ró xi'ts'iji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nu'tsc'eji dya i̱ juancügöji. Nuzgö nguetscö ró juan'c'ügöji. Ró empc'egöji ngue c'ua sido rí tsjaji c'ua ja nzi rgá negö, rí ma zopjüji yo nte ngue c'ua sido ra 'ñejmezüji anguezeji. Nuc'ua texe c'o rí dyötüji mi Tata a jens'e na ngueje i̱ṉ ejmezüji, angueze ra dya'c'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nutscö rí mandats'üji rí pötqui s'iyagueji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’'Ma ra nuc'üji na ü yo cãrã cja ne xoñijõmü c'o dya ejmezü, dya me rí tsjijñiji. Rí mbeñegueji nutscö ot'ü o nugöji na ü 'ma dya be mi nuc'eji na ü. ");
INSERT INTO mazNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nu 'ma ri tsjaji c'ü cja yo cãrã cja ne xoñijõmü c'o dya ejmezü, nu'ma, ro s'iyats'ügueji 'ma yo. Pero nu'tsc'eji ya i̱ 'ñejmezügöji na ngueje ró juan'c'ügöji. A cjanu, dya pje i̱ṉ cjaji c'ua ja nzi ga tsja c'o dya ejmezü, nguec'ua nuc'ügueji na ü. ");
INSERT INTO mazNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mbeñeji c'e jña'a c'ü ró xi'ts'iji: “'Naja mbëpji dya xenda na nojo que na ngueje o̱ lamu.” Nu 'ma ya nugöji na ü, me träcjäji, xo 'ñetsc'eji xo ra nugöji na ü, ra ndräc'äji. 'Ma o dyätcägöji c'o ró xipjiji, xo ra dyä'tc'ägueji c'o rí xipjiji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ra tsja'c'üji a cjanu, na ngueje i̱ṉ ejmezügöji. Dya pãrãji nu c'ü o ndäcjä ró ẽcjö cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Nudya tũji o̱ nzhubüji dya, na ngueje 'ma ró ẽ zopjügöji ín jñagö, dya 'ñejmezüji. ");
INSERT INTO mazNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nu c'ü nugügö na ü, xo nu'u na ü c'ü mi Tatagö a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ró cjagö c'o me na nojo a jmi anguezeji c'ü dya sö cjó ro tsja. Nguec'ua va unüji ngüenda c'ü o ndäcjä mi Tatagö. Pero dya 'ñejmezüji. Nguec'ua, dya nguextjozgö nugöji na ü, xo nuji na ü c'ü mi Tatagö. Nguec'ua me tũji o̱ nzhubüji dya. ");
INSERT INTO mazNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","A cjanu, va sädä nu c'ü t'opjü cja o̱ leyji c'ü o unü Mizhocjimi anguezeji. Je mama a cjava: “O nugüji na ü, dya pje rmí cjagö”, eñe cja c'e ley. ");
INSERT INTO mazNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Xe mi ña e Jesús, o mama: ―Nuc'ua 'ma ra ẽjẽ nu c'ü ra 'ñe mböxc'üji, ngue c'ü ra mama c'ü ja ga cjazgö c'ü. Nuzgö nguetscö rá täjä ndeze cja mi Tatagö a jens'e nu c'ü ra 'ñe mböxc'üji. Ngueje o̱ Espíritu Mizhocjimi c'ü ra jí'ts'iji c'ü na cjuana. ");
INSERT INTO mazNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nu'tsc'eji xo rí mamaji ja ga cjazgö, na ngueje rí dyocjöji ndeze 'ma ot'ü 'ma ró zopjü yo nte. ");
INSERT INTO mazNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Nuzgö rí xi'ts'iji yo jña'a yo, ngue c'ua dya rí chjench'eji a xütjü. ");
INSERT INTO mazNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yo nte a Israel ra pjongüts'üji cja o̱ nintsjimiji. Ra zädä 'ma ra nguijñiji c'ü ri ne Mizhocjimi ra tsja anguezeji ra mbö'tc'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ra tsjaji a cjanu na ngueje dya pãrãji mi Tata, ne xo ri nguetscö pãcãji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ya ró xi'ts'iji yo, ngue c'ua 'ma ra zädä c'e pa, rí mbeñeji ya rvá xi'ts'igöji yo. ’Cja rrã xi'ts'iji dya yo jña, na ngueje cja ni jyonc'eji rí pãrãgueji dya. ");
INSERT INTO mazNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nudya, rá ma'a nu ja je bübü c'ü o ndäcjä. Pero nu'tsc'eji, ne ri 'najats'ügueji, dya cjó önngü ja je rá ma. ");
INSERT INTO mazNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Me i̱ṉ cjijñiji na puncjü cja in mü'büji na ngueje ró xi'ts'iji yo. ");
INSERT INTO mazNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Rí xi'ts'igöji c'ü na cjuana. Nuzgö ni jyodü rá magö, na ngueje 'ma dya rá magö, dya ra ẽjẽts'ügueji nu c'ü ra'ñe mböxc'üji. Nu 'ma rá magö, rá täjä c'ü ra 'ñe mböxc'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nu 'ma ra ẽjẽ c'ü, ra tsjapü yo cãrã cja ne xoñijõmü ra mbãrãji c'ü tũji o̱ nzhubüji. Xo ra tsjapü ra mbãrãji nguextjozgö me na jozgö, nguextjozgö sö rá jocüji. Ya xo ra tsjapü ra mbãrãji ngue Mizhocjimi c'ü ra jñünpü ngüenda anguezeji ra ma sufridoji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nu c'ü ra 'ñe mböxc'üji, ra tsjapü ra mbãrãji c'ü tũji o̱ nzhubüji na ngueje dya ench'ezügö cja o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ra tsjapü ra mbãrãji me na jozgö, nguextjozgö sö rá jocüji. Na ngueje 'ma ya rga tũgö, rá tetjogö. Nuc'ua rá magö cja mi Tata. Dya cja xe rí jñandgaji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nu c'ü ra 'ñe mböxc'üji, ra tsjapü ra mbãrãji, Mizhocjimi manda y ra tsjapü ra ma sufrido nu c'o dya ätä angueze. Na ngueje Mizhocjimi ya ri jizhi c'ü ra ma sufrido c'ü dya jo c'ü manda cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Xe rí pë's'itjogö na puncjü c'o rá xi'ts'iji. Pero dya be sö rí tendioji ja ga cja nu c'o ro xi'ts'iji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nu 'ma ra ẽjẽ o̱ Espíritu Mizhocjimi, nuc'ü, ra jí'ts'iji texe c'o na cjuana. Nuc'ü, dya pje ra ñatsjëjë. Ra mama texe c'o ra dyärä c'o mama Mizhocjimi. Nuc'ü, ra 'ñe ngöxc'üji c'o cja ra zädä. ");
INSERT INTO mazNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Angueze ra jí'ts'iji c'ü me na nozgö, na ngueje ra mböxc'üji rí tendioji na jo ja ga cja c'o ín jñagö c'o ya ró xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Texe c'ua ja ga cja mi Tatagö, nuzgö xo ga cjazgö nu. Nguec'ua ró mama: “O̱ Espíritu Mizhocjimi ra mböxc'üji rí tendioji na jo ja ga cja c'o ín jñagö c'o ya ró xi'tsc'öji.” ");
INSERT INTO mazNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Dya cja ra mezhe c'ü xe rí jñandgagöji. Nuc'ua, dya ra mezhe rí jñandgatjoji na yeje. ");
INSERT INTO mazNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nuc'ua c'o o̱ discípulo bübü c'o o pötva mama: ―¿Ja ga cja yo xitsiji: “Dya cja ra mezhe xe rí jñandgaji, nuc'ua, dya ra mezhe rí jñandgatjoji na yeje”? ¿Jenga nde mama: “Dya rí jñandgaji na ngueje rá magö cja mi Tata”? ");
INSERT INTO mazNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mi mamaji c'ua: ―Pãrã, ¿ja ga cja yo mama: “Dya cja ra mezhe”? Nuzgöji, dya rí pãrãgöji ja ga cja c'ü mama. ");
INSERT INTO mazNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","O mbãrã e Jesús, mi ne ro dyönüji, nguec'ua o xipjiji c'ua: ―I̱ṉ pötqui dyönütsjëji pje ne ra mama c'ü ró xi'ts'iji c'ü dya cja ra mezhe xe rí jñandgaji, nuc'ua, dya ra mezhe rí jñandgatjoji na yeje. ");
INSERT INTO mazNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nuzgö na cjuana c'ü rí xi'ts'iji, nu'tsc'eji me rí huë'ëji, me rí tristegueji rí mbenzeji. Pero yo cãrã cja ne xoñijõmü c'o dya ejmezügö, nuyo, me ra mäjä yo. Nu'tsc'eji me rí tsjijñiji cja in mü'büji. Pero nu c'ü me rgui tristeji, exi ngue c'ü rgui mäcjeji después. ");
INSERT INTO mazNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","'Naja ndixũ, nu 'ma mus'ü o̱ t'i, me sufrido na ü'ü. Nuc'ua 'ma ya mus'ü c'ü nu ts'it'i, dya cja mbeñe c'ü na ü'ü. Ya mäjätjo na ngueje c'ü ya vi mus'ü 'naja ts'it'i cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nu'tsc'eji, je xo ga cjatsc'eji dya nu. Me i̱ṉ sufridoji c'ü me i̱ṉ cjijñiji cja in mü'büji. Pero rá chjëtjoji na yeje. Nuc'ua me ra mäjätjo na yeje in mü'büji. Dya cjó ra sö ra jñücüts'ügueji c'ü me rí mäjäji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Nu pa'a c'ü rá chjëtjoji na yeje, dya pje rí dyönngüji 'ma. Ya ri pãrãji ja ga cja c'ü rí xi'ts'iji dya. Na ngueje i̱ṉ ejmezüji, sö rí dyötüji mi Tata a jens'e. Nuc'ua ra dya'c'üji c'ua ja nzi gui dyötüji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dya be i̱ṉ nänngäji ín chjũgö c'ü pje ni dyötüji mi Tatagö. Dyötüji dya. Texe nde ra dya'c'üji, ngue c'ua me ra mäjä in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Nu yo ró xi'ts'iji, dya be sö rí tendioji na jo ja ga cja yo. Ra zädä 'ma ya rá xi'ts'iji na jo ja ga cja mi Tata. ");
INSERT INTO mazNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dya rí xi'ts'iji nguetscö rá ö'tc'üji mi Tata. C'e pa'a c'ü, rí dyötütsjëji mi Tata, rí ñänngäji ín chjũgö. ");
INSERT INTO mazNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Na ngueje nguetsjë mi Tata c'ü s'iyats'üji, na ngueje nu'tsc'eji me i̱ṉ s'iyazüji. I̱ 'ñejmeji c'ü je rvá ẽcjö cja mi Tata c'ü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Je rvá ẽcjö cja mi Tata a jens'e. Ró ẽcjö cja ne xoñijõmü. Ya ngue rá pedye cja ne xoñijõmü. Rá nzhogü, rá ma cja mi Tata. ");
INSERT INTO mazNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","C'o o̱ discípulo o xipjiji c'ua: ―Nudya, 'ñetse na jo, yo jña yo i̱ṉ mangue. Ya ró tendiojme ja ga cja c'o i̱ṉ xitsijme. ");
INSERT INTO mazNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nudya ya rí pãrãgöjme c'ü nde i̱ṉ pãrãgue texe. I̱ṉ pãtcöjme ín mü'büjme, nguec'ua dya ni jyodü rá cja'c'üjme t'önü. Nguec'ua ya rí ejmejme je i̱ pedyegue cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","O ndünrü c'ua e Jesús, o xipjiji: ―Nudya, ¿Cjo ya i̱ṉ ejmezüji dya, 'ma? ");
INSERT INTO mazNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ya ngue ra zädä c'e hora, na cjuana ya o zädä, c'ü rí pjötc'eji i̱ṉ texeji. Nde 'naja rgui möcjeji cja in nzungueji. Nuc'ua ya rí sogüzütsjëji. Pero nutscö, dya rí bübütsjëgö. Nuzgö rí bünc'öbe mi Tata c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nu yo jña'a yo, rí xi'ts'iji yo, ngue c'ua mas rí 'ñejmezüji, a cjanu rá da'c'üji ra söya in mü'bügueji. Cja ne xoñijõmü me rí sufridogueji. Pero, dya rí sũji na ngueje ró tõpügö nu c'ü manda yo cãrã cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nuc'ua 'ma o nguarü e Jesús o mama yo jña'a yo, o nä's'ä c'ua a jens'e, o mama: ―Nu'tsc'e mi Tatats'ü, ya zädä c'e hora 'ma rá tũgö. Tsjapü ra mbãrã yo nte cjó je nguetscö. Rí tsjapü ra mbãrãji nguetscö in Ch'izgö me na nozgö. A cjanu, ngue c'ua xo ra mbã'c'ãji me na notsc'e, nu'tsc'e mi Tatats'ügö a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nu'tsc'e mi Tatats'ü, ya i̱ dyacö rá mandagö texe yo nte cja ne xoñijõmü. Nu c'o ench'ezügö cja o̱ mü'bü, rá unügö c'ü sido ra bübütjoji. ");
INSERT INTO mazNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sido ra bübütjoji na ngueje pã'c'ãji, nu'tsc'e nguetjots'ügue i̱ṉ Mizhocjimigue c'ü na cjuana. Sido ra bübütjoji na ngueje xo pãcãji, nutscö e Jesucristo i̱ chäcjägö cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Nutscö ró jíchi yo nte yo cãrã cja ne xoñijõmü c'ü me na nots'ügue, na ngueje ró cja texe c'o i̱ xitsi. ");
INSERT INTO mazNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nudya, mi Tatats'ü, rí tsjague ngue c'ua rá bübügö na yeje co nu'tsc'e nu ja me na nojots'ügue. Rí tsja ngue c'ua rá bübügövi c'ua ja nzi rmá bübügövi 'ma dya be mi t'ät'ä ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Nu c'o cãrã cja ne xoñijõmü yo i̱ dyacü, ngue'tsc'e je i̱ 'ñünbü o̱ mü'büji, ngue c'ua o 'ñench'ezü cja o̱ mü'büji. Nujyo, ró jíchiji ja ga cjats'ügue, mi Tatats'ü. Anguesji sido cjaji nu c'o i̱ṉ mangue. ");
INSERT INTO mazNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Texe c'o ró cjagö, 'ñe c'o ró mangö, ngue'tsc'e i̱ xitscö ró cjagö, ngue'tsc'e i̱ xitscö ró ñagö. ");
INSERT INTO mazNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Na ngueje ya ró xipjiji c'o jña'a c'o i̱ xitsi ro xipjiji. Anguesji o 'ñejmeji c'o ró xipjiji. Ya xo pãrãji cja o̱ mü'büji c'ü na cjuana je rvá ẽcjö cja in dyë'ë. Ya xo 'ñejmeji, ngue'tsc'e i̱ chäcjä cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Nu'tsc'e mi Tatats'ü, nutscö rí ö'tc'ügö yo o 'ñejmets'ü in jñague. Dya rí ö'tc'ügö yo cãrã cja ne xoñijõmü yo dya ejme. C'o rí ö'tc'ügö ngueje c'o i̱ dyacü na ngueje ngue'tsc'e je i̱ṉ 'ñeje dya yo. ");
INSERT INTO mazNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Texe yo ín ntegö ngueje in ntegue. Texe yo in ntegue ngueje ín ntegö. Anguezeji pãcãji exi ngue in Ch'izügö. ");
INSERT INTO mazNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Nutscö je rá magö nu ja je i̱ṉ bünc'e, nu'tsc'e mi Tatats'ü. Dya cja rá bübügö va cja ne xoñijõmü. Pero nu yo i̱ dyacü, nuyo, cãrãji cja ne xoñijõmü. Mi Tatats'ü, nu'tsc'e me na jots'ü, rí ö'tc'ü rí tsjapü nu yo i̱ dyacü, ra mbã'c'ãji c'ü xo ngue'tsc'e nu Tatats'üji. A cjanu rí pjörüji. Nguec'ua ra 'natjoji c'ua ja xo nzi ga cjazgövi, rí 'natjogövi, mi Tatats'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nutscö xe rí bübügö co anguesji, rí pjorügöji, na ngueje me na zë'ts'igue, i̱ dyacügö ja rgá pjörüji. Nguec'ua ne ri 'naja anguesji cjó ró bëzhigö. Nguextjo 'natjo c'ü o dyo'o o̱ mü'bü c'ü dya jo. O bëzhi c'ü, c'ua ja nzi ga mama cja in jñague. ");
INSERT INTO mazNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Mi Tatats'ügö, ya rá magö c'ua ja je i̱ṉ bünc'e. Rrã mangö yo jña'a yo, nudya xe rí bünc'ö cja ne xoñijõmü, ngue c'ua nu yo i̱ dyacö, na cjuana ra mäjäji c'ua ja nzi rgá mäjägö. ");
INSERT INTO mazNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nu yo i̱ dyacü, ró xipjigöji ín jñagö. Yo cãrã cja ne xoñijõmü c'o dya ejme, me nuji na ü nu yo ejme ín jñagö. Na ngueje c'ua ja nzi ga cjazgö c'ü dya rí tsja va cja ne xoñijõmü, je xo ga cjatjonu yo ejme ín jñagö. ");
INSERT INTO mazNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Dya rí ö'tc'ü c'ü rí sidyiji c'ü dya cja ra ngãrãji cja ne xoñijõmü. Rrã ö'tc'ü rí pjörüji nu va cja ne xoñijõmü nu ja manda c'ü dya jo. ");
INSERT INTO mazNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na ngueje dya menzumüji va cja ne xoñijõmü. C'ua ja nzi ga cjazgö, dya rí menzumü va cja ne xoñijõmü, je xo ga cjatjonu anguesji. ");
INSERT INTO mazNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Anguezeji o 'ñejmeji in jñague, nguec'ua nu'tsc'e rí xõcüji ra tsjaji c'ua ja nzi gui ñegue. Ngue in jñague jíchiji c'ü i̱ṉ negue. ");
INSERT INTO mazNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","I̱ chäcjä, ró ẽ zopjü yo cãrã cja ne xoñijõmü ró xipjiji yo in jñague. C'ua ja nzi vi chäcjägö cja ne xoñijõmü, ró juajnü anguesji ra zopjüji yo nte yo cãrã cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Rá cjagö c'ua ja nzi gui ñegue rá tũgö. Ngue c'ua anguezeji xo ra tsjaji c'ua ja nzi gui ñegue. ");
INSERT INTO mazNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Dya nguextjo yo i̱ dyacü rí ö'tc'ü yo. Xo rí ö'tc'ü c'o cja ra 'ñejmezügö na ngueje c'o ín jñagö c'o ra mama yo i̱ dyacü. ");
INSERT INTO mazNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rí ö'tc'ü, texeji nde ra 'natjoji, c'ua ja nzi ga cjatsc'e mi Tatats'ü, i̱ṉ bübüzügö, nutscö rí bübüts'ügö. Rí ö'tc'ügö, texe yo xo ra 'natjoji co nutscövi. Rí ö'tc'ü a cjanu ngue c'ua yo cãrã cja ne xoñijõmü ra 'ñejmezüji c'ü ngue'tsc'e i̱ chäcjägö. ");
INSERT INTO mazNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nu'tsc'e mi Tatats'ü, c'ua ja nzi rgá 'natjovi, xo ró unü anguezeji c'ü ri 'natjoji anguesji co nutscövi. Nguec'ua ri 'natjoji anguesji c'ua ja nzi rgá 'natjovi. ");
INSERT INTO mazNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na ngueje ri bübü cja o̱ mü'bü anguesji. Y nu'tsc'e mi Tatats'ü, ri bübüzügö. Nguec'ua anguesji na cjuana ra 'natjoji. A cjanu yo cãrã cja ne xoñijõmü ra mbãrãji ngue'tsc'e i̱ chäcjägö. Xo ra mbãrãji ngue'tsc'e mi Tatats'ü i̱ṉ s'iyague anguesji, c'ua ja xo gui s'iyazügö. ");
INSERT INTO mazNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Nu'tsc'e mi Tatats'ügö, nu yo i̱ dyacü, rí negö c'ü xo ra bübüji nu ja je rá magö. Nguec'ua ra jñandaji c'ü me ma zö'ö rmá bübügö co nu'tsc'e 'ma dya be mi t'ät'ä ne xoñijõmü. Ra jñandaji c'ü ja gui s'iyazügö ndeze 'ma dya be mi t'ät'ä ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nu'tsc'e, mi Tatats'ü, me i̱ṉ cjague me na jo. Yo cãrã cja ne xoñijõmü, dya pã'c'ãji. Pero nutscö rí pã'c'ã. Nu yo i̱ dyacü xo pãrãji ngue'tsc'e i̱ chäcjä. ");
INSERT INTO mazNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ya ró unüji o mbã'c'ãji, nu'tsc'e mi Tatats'ü. Sido rá unüji yo, ra mbã'c'ãji. Nguec'ua, c'ua ja gui s'iyazü, ra mbãrãji cja o̱ mü'büji c'ü xo i̱ṉ s'iyague anguesji. Xo rá bübügö cja o̱ mü'bü anguesji. ");
INSERT INTO mazNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","'Ma o nguarü o mama yo jña'a yo e Jesús, nuc'ua o möji c'ua co o̱ discípulo. O mbes'eji cja c'e 'ñinzhe c'ü ni chjũ Cedrón, o zät'äji nu ja je mi bübü 'naja huerta. Nuc'ua e Jesús co c'o o̱ discípulo o cjogüji a mbo cja c'e huerta. ");
INSERT INTO mazNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nu c'ü e Judas c'ü ro nzhö'ö e Jesús, xo mi pãrã nu cja c'e huerta. Na ngueje e Jesús 'ñe c'o o̱ discípulo sido mi pöji nu. ");
INSERT INTO mazNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","E Judas o dyëdyi c'ua c'o xondaro. Xo dyëdyi c'o policía c'o mi pëpi c'o ndamböcjimi 'ñe c'o fariseo. Nuc'ua o möji cja c'e huerta. Ma tũji o lámpara 'ñe o tizhi c'o mi tjë'ë. Nde ma jünji c'o rví tsjaji o chũ. ");
INSERT INTO mazNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","E Jesús ya mi pãrã texe c'o ro tsjapüji c'ü. O ma chjëji c'ua, o dyönüji: ―¿Cjó ngue c'ü i̱ṉ jodügueji? ");
INSERT INTO mazNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","O ndünrü c'ua c'o nte c'o ma ë'ë e Judas, o xipjiji: ―Rí jodügöjme e Jesús c'ü menzumü a Nazaret. E Jesús o xipjiji: ―Nutscö nguetscö e Jesús. Xo mi bübü co anguesji e Judas, nu c'ü ro nzhö'ö e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nzi va mama e Jesús: “Nguetscö”, nuc'ua o ndã't'ãtsjëji na zëzhi o̱ xütjütsjëji, o nügüji. ");
INSERT INTO mazNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","E Jesús o yepe o dyönüji c'ua: ―¿Cjó ngue c'ü i̱ṉ jodügueji? Anguesji o mamaji: ―Rí jodügöjme e Jesús c'ü menzumü a Nazaret. ");
INSERT INTO mazNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nuc'ua o yepe o ndünrü c'ua e Jesús, o xipjiji: ―Ya ró xi'ts'iji que nguetscö. Nu 'ma nguetscö i̱ṉ jongüji, jyëtsquiji yo ín discípulogö ra möji. ");
INSERT INTO mazNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A cjanu o zädä c'o jña'a c'o ya vi mama e Jesús. O mama: “Nu c'o i̱ dyacü, dya pje ró bëzhigö ne ri 'naja c'o.” ");
INSERT INTO mazNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","E Simón Pedro mi jün 'na tjëdyi. O ngübü c'ua c'e tjëdyi cja o̱ xipjadü. Cjanu o ya'bü c'ua c'ü nu mbëpji c'ü mi mero ndamböcjimi. O dyopcü c'ü nu ngõ'õ cja o̱ jodyë. Nu c'e mbëpji mi chjũ'ũ Malco. ");
INSERT INTO mazNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nuc'ua e Jesús o xipji e Pedro: ―Tsöt'ü c'ü in chjëdyi cja o̱ xipjadü. Dya rí ts'axcügö c'ü rá cjagö c'ü ne mi Tatagö c'ü bübü a jens'e. ");
INSERT INTO mazNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nuc'ua c'o xondaro 'ñe c'ü mi manda cja c'o xondaro 'ñe c'o policía c'o mi menzumü a Israel, o zürüji e Jesús. Ya nde jyü'tp'üji c'ua o̱ dyë'ë. ");
INSERT INTO mazNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nuc'ua ot'ü o zidyiji e Jesús cja nu ndã e Caifás c'ü mi chjũ Anás. C'e cjë'ë c'ü, mi mero ndamböcjimi e Caifás. ");
INSERT INTO mazNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mi ngueje e Caifás c'ü vi xipji c'o pje mi pjëzhi a Israel c'ü mi jyodü ro ndũ'ũ 'naja bëzo ngue c'ua dya ro ndũ texe c'o mejñiñi. ");
INSERT INTO mazNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","E Simón Pedro mi tjünt'ü a xütjü e Jesús. Xo 'ñe 'naja o̱ discípulo xo mi tjünxtjo a xütjü. Nu c'ü mi mero ndamböcjimi mi pãrã c'e discípulo c'ü. O cjogü c'ua c'e discípulo co e Jesús nu ja ma bübü c'ü mi mero ndamböcjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nu c'e Pedro o nguejmetjo a tji'i cja c'e ngoxtji. O mbedye c'ua c'ü 'naja discípulo c'ü mi pãrã c'e ndamböcjimi. O ma zopjü c'e ndixũ c'ü mi mböngoxtji. O jyëziji c'ua o cjogü a mbo c'e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nuc'ua c'e ndixũ c'ü mi mböngoxtji, o xipji e Pedro: ―¿Cjo dya xo ngue'tsc'e 'naja o̱ discípulo ne bëzo nu? O xipji c'ua angueze: ―Nutscö, dya nguetscö o̱ discípulozgö nu. ");
INSERT INTO mazNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nuc'ua c'o mbëpji 'ñe c'o policía nde mi böbüji nu. Vi 'ñõrüji chjeme na ngueje ma së'ë. Ma pa't'üji. Anguesji nde mi dyoji e Pedro ma pa't'üji cja sivi. ");
INSERT INTO mazNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nuc'ua c'e ndamböcjimi o dyönü e Jesús, cjó mi ngue c 'o mi tjünt'ü a xütjü angueze. Xo o dyönü pje nza cja c'ü mi xöpüji. ");
INSERT INTO mazNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","O ndünrü c'ua e Jesús, o xipji: ―Nutscö ró zopjü na puncjü o nte cja ne xoñijõmü. Nutscö sido ró xöpüte cja yo nitsjimi va a Israel. Xo nde ró xöpüte cja c'e templo nu ja je jmurü na puncjü ín menzumügöji. Dya pje ró mamagö c'ü dya cjó ro dyärä. ");
INSERT INTO mazNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jenga i̱ṉ önngügö dya yo? Dyönüji c'o ya o dyärä, pje ni mbë c'ü ró xipjiji. Nuc'o, pãrã na jo c'o ró mangö c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","'Ma o mama a cjanu e Jesús, 'naja c'o policía c'ü mi bübü nu, o chötü 'naja mbädyë e Jesús. O xipji: ―¿Cjo je rga cjanu rgui chjüntügue ne ndamböcjimi? ");
INSERT INTO mazNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","O ndüntü c'ua e Jesús, o xipji: ―Nu 'ma ró tjüntügö na s'o, mamague pje pjëzhi c'ü na s'o c'ü ró xipji. 'Ma ró tjüntügö c'ü na cjuana, ¿jenga i̱ pjëchqui ín jmigö? ");
INSERT INTO mazNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nuc'ua e Anás cjanu o ndäjä e Jesús nu cja e Caifás c'ü xo mi mero ndamböcjimi. Xe mi tjüt'ütjo o̱ dyë e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Xe mi böntjo e Simón Pedro, ma pa't'ütjo a sivi. O ña c'ua c'o xo mi cãrã nu, o dyönüji e Pedro: ―¿Cjo dya xo ngue'tsc'e o̱ discípulots'ü e Jesús? E Simón Pedro o ngädä, o mama: ―Nuzgö, dya pje nguetscö 'naja o̱ discípulo. ");
INSERT INTO mazNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","C'ü mi mero ndamböcjimi mi 'ñeje 'na o̱ mbëpji c'ü mi ngue o̱ dyojui c'e bëzo c'ü vi dyogü o̱ ngõ'õ c'ü vi dyopcü e Pedro. O ña c'ua c 'e mbëpji o xipji e Pedro: ―Xo ró jantc'agö cja c'e huerta, nde mi dyocjevi e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nuc'ua o ngädätjo na jñi'i e Pedro. Nuc'ua jo ni huë'ë c'ua c'o chare. ");
INSERT INTO mazNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nuc'ua o mbedyeji c'ua cja o̱ ngumü e Caifás, o zidyiji e Jesús cja o̱ palacio c'e gobernador. Xõxtjo o zät'äji. Nu c'o pje mi pjëzhi a Israel dya o cjogüji nu cja c'e palacio. Na ngueje mi sũji 'na ro contaminaoji. C'ua ja nzi ga mama o̱ ley anguesji, 'na ro contaminaoji, dya ro sö ro zi'iji c'ü ch'unü cja c'e mbaxua c'ü ni chjũ Pascua. ");
INSERT INTO mazNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nuc'ua o mbedye e Pilato nu ja je mi cãrã anguesji. O xipjiji: ―¿Pje vi sicjeji va ne bëzo nu? ");
INSERT INTO mazNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","O ndünrüji c'ua, o xipjiji: ―Nu 'ma dya ro tsja c'o na s'o nu, dya xo ro ẽ nzhö'c'üjme. ");
INSERT INTO mazNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","O ndünrü c'ua e Pilato: ―Sidyigueji ngue c'ua rí jñünpüji ngüenda c'ua ja nzi ga manda in leygueji. C'o pje mi pjëzhi cja c'o nte a Israel o ndünrüji c'ua: ―Dya i̱ṉ jëzguigöjme cjó rá pö't'ügöjme. ");
INSERT INTO mazNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A cjanu o zädä c'o vi mama e Jesús ja cja rvá ndũ'ũ. ");
INSERT INTO mazNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nuc'ua e Pilato o cjogü na yeje a ma a mbo'o nu cja c'e palacio. Nuc'ua o ma't'ü c'ua e Jesús, o xipji: ―¿Cjo ngue'tsc'e o̱ jmuts'ü yo nte a Israel? ");
INSERT INTO mazNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","O ndüntü c'ua e Jesús, o xipji: ―¿Cjo i̱ṉ ejmetsjëgue yo, maxque bübü c'ü o xi'ts'i cjó je nguetscö? ");
INSERT INTO mazNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","O ndünrü c'ua e Pilato: ―A poco i̱ṉ cjinncje xo rí menzumügö a Israel. Nguetsjë c'o ndamböcjimi 'ñe c'o dyaja in menzumütsjëgueji c'o o ẽ nzhöc'üji va ja rí bünc'ö. Nguec'ua rí önnc'ü pje i̱ tsjague. ");
INSERT INTO mazNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","O ndünrü e Jesús, o xipji: ―Nutscö, dya nza cjazgö c'o dyaja jmu'u c'o manda cja ne xoñijõmü. 'Ma rva cjanu, nuc'ua nu c'o tjünt'ü ín xütjügö ro ñangagö c'o. Nguec'ua dya ro nzhögüji cja yo ín menzumügöjme va a Israel. Nguec'ua rí xi'ts'i, dya nza cjazgö c'o dyaja jmu'u c'o manda cja ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","O ndünrü c'ua e Pilato: ―¿Cjo ngue'tsc'e 'naja c'ü manda 'ma? O ndünrü c'ua e Jesús: ―I̱ṉ mamague c'ü rí mandagö. Ngueje c'ü je rvá te'egö c'ü. Nguec'ua rvá ẽjẽ cja ne xoñijõmü ngue c'ua rá mama c'o na cjuana. Texe yo nte c'o ätä c'ü na cjuana pãrãji cjó je nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","O dyönü c'ua e Pilato: ―¿Pje ni mbëjë c'ü na cjuana? 'Ma o mama yo, o mbedye na yeje a tji e Pilato nu ja mi cãrã c'o nte a Israel. O xipjiji: ―Dya pje rí tö'tp'ü c'ü na s'o c'ü ro tsja c'e bëzo c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nu'tsc'eji i̱ṉ menzumüji a Israel i̱ṉ pë's'iji 'na tjũrü c'ü i̱ṉ cjaji 'ma pedye ne mbaxua nu ni chjũ Pascua. I̱ṉ ötcöji rá pjongü libre 'naja c'ü na o'o a pjörü. ¿Cjo i̱ṉ ne rá pjongü libre e Jesús c'ü in jmugueji? ");
INSERT INTO mazNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nuc'ua o mapjüji na yeje texeji, o mamaji: ―Nuc'ü, dya rí pjongü c'ü. Pjongü e Barrabás. Nu c'ü e Barrabás mi ngueje 'naja mbẽ'ẽ mi pö't'üte c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nuc'ua e Pilato o manda c'o xondaro o ndas'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nuc'ua c'o xondaro o mbeji 'naja corona c'ü mi dyavo bidyi. Nuc'ua cjanu o jñusp'üji cja o̱ ñi e Jesús. Cjanu o jyecheji c'ua 'naja bitu c'ü ma cjipobü. ");
INSERT INTO mazNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Cjanu o chëzhiji a jmi go mbë'chp'iji c'ua o̱ jmi, o xipjiji: ―Nu'tsc'e i̱ṉ jmu'u cja yo nte a Israel, sido rí tsjague jmu'u. Nuc'ua ya o chötüji c'ua c'o mbädyë. ");
INSERT INTO mazNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nuc'ua e Pilato o mbedye na yeje a tji. O xipji c'o nte a Israel c'o mi cãrã nu: ―Jñandaji. Rvá siñc'iji a tji e Jesús, ngue c'ua rí pãrãji dya pje ró tö'tp'ügö c'ü pje ro tsja'a c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nuc'ua o mbedye c'ua a tji e Jesús. Mi juns'ü c'e corona c'ü mi dyavo bidyi. Nde mi je c'e bitu c'ü ma cjipobü. E Pilato o xipji c'ua c'o nte a Israel: ―Jñandaji dya. Ya bübü va ne bëzo. ");
INSERT INTO mazNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","C'o ndamböcjimi 'ñe c'o policía 'ma o jñandaji e Jesús, exo mapjüji c'ua, o mamaji: ―Chät'ä cja ngronsi nu, chät'ä cja ngronsi nu. O ndünrü c'ua e Pilato: ―Nu'tsc'eji, sidyigueji, rí ma chät'äji. Nuzgö dya pje rí tö'tp'ügö c'ü na s'o c'ü ro tsja'a. ");
INSERT INTO mazNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","O ndünrüji c'ua: ―Nutscöjme rí pë'sc'öjme ín leyjme. C'ua ja nzi ga mandazügöjme c'e ley, ni jyodü ra ndũ ne bëzo, na ngueje o tsjapütsjë c'ü ngue o̱ T'i Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nuc'ua 'ma o dyärä yo jña'a yo, xenda o zũ'ũ c'ua e Pilato. ");
INSERT INTO mazNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nuc'ua o cjogütjo c'ua na yeje a mbo cja c 'e palacio. O xipji c'ua e Jesús: ―¿Ja je i̱ṉ menzumügue? E Jesús, dya pje o ndünrü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nuc'ua e Pilato o xipji: ―¿Jenga dya i̱ṉ tjüntcü yo rí zo'c'ü? ¿Cjo dya i̱ṉ pãrã pje pjëtscö? Sö rá empc'e libre. Xo sö rá nzhöc'ü c'ü ra ndät'äts'üji cja ngronsi. ");
INSERT INTO mazNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","O ndünrü c'ua e Jesús: ―Dya pje ro sö pje ri tsjacü 'ma dya ro dya'c'ü sjëtsi Mizhocjimi c'ü bübü a jens'e. Nguec'ua nu c'ü o ẽ nzhögü cja in dyëgue, ngue c'ü xenda na nojo o̱ nzhubü c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ndeze c'e ndajme c'ua, e Pilato mi ne ro 'ñeme libre e Jesús. Pero c'o nte a Israel mi mapjüji, mi mamaji: ―'Ma rí 'ñeme libre c'e bëzo, dya pje i̱ṉ joguevi 'ma e César c'ü mero jmu cja ne xoñijõmü. Na ngueje 'ma cjó c'o xe ra tsjapü jmu nza cja ga tsja c'e bëzo, nu'ma, chũvi e César 'ma. ");
INSERT INTO mazNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nuc'ua e Pilato, 'ma o dyärä yo jña'a yo, o zidyitjo na yeje a ma a tji e Jesús. E Pilato o ma mimi c'ua, nu ja je mi jünpü ngüenda c'o nte. Cja jña hebreo mi chjũ Gabata c'e lugar, c'ü ne ra mama nu ja vi mbäbäji cemento. ");
INSERT INTO mazNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","C'e pa'a c'ü, mi ngue 'ma mi preparaoji ngue c'ua c'ü na jyas'ü ro tsjaji c'e ndambaxua c'ü ni chjũ Pascua. Ya vi zünü 'ñanto c'ü xõrü. Nuc'ua e Pilato o xipji c'o nte a Israel: ―Jñandaji. Bübü va, nu in jmugueji, nu mandats'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Anguesji o mapjüji: ―Sidyi ne bëzo nu, ma chät'ä cja ngronsi. E Pilato o xipjiji c'ua: ―Nu nin jmugueji, ¿cjo i̱ṉ neji rá tät'ä cja ngronsi? O ndünrü c'ua c'o ndamböcjimi, o mamaji: ―Nu c'ü ín jmujme nguetjo e César. ");
INSERT INTO mazNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nuc'ua e Pilato o nzhö e Jesús ngue c'ua ro dät'ä cja ngronsi. Cjanu o zidyiji c'ua e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nuc'ua o nduns'ütsjë c'ua c'ü nu ngronsi. O mbedye, o ma nu ja je mi chjũ'ũ ñinte. Cja jña hebreo mi chjũ'ũ Gólgota. ");
INSERT INTO mazNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nunu ngue nu ja je ndät'äji cja ngronsi nu. O ndät'äji angueze, cja ne yeje bëzo c'o xo ndät'äji, 'naja cja o̱ jodyë, c'ü 'naja cja o̱ squierda. E Jesús, mi bübü a nde'e c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","E Pilato o dyopjü c'ua 'naja xiscõma c'ü ro ma cuatüji c'ua cja o̱ ngronsi e Jesús. C'ü mi t'opjü mi mama a cjava: “Nunu ngueje e Jesús, nu je menzumü a Nazaret. Ngueje o̱ Jmu'u yo nte a Israel.” ");
INSERT INTO mazNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Na puncjü c'o nte a Israel c'o o xörü nu mi cuat'ü cja o̱ ngronsi e Jesús, na ngueje nu ja vi dät'ä e Jesús mi bëxtjo cja c'e jñiñi. C'o jña'a c'o, mi t'opjü cja jña hebreo 'ñe cja griego 'ñe cja latín. ");
INSERT INTO mazNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","C'o ndamböcjimi cja c'o nte a Israel o ma xipjiji c'ua e Pilato: ―Dya ri dyopjü a cjava: “Ngueje o̱ Jmu'u yo nte a Israel.” Ri dyopjü a cjava: “Mi cjapütsjë ne bëzo mi ngueje o̱ Jmu'u yo nte a Israel.” ");
INSERT INTO mazNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","O ndünrü c'ua e Pilato: ―Nuzgö, nu c'o ya ró opjügö, dya rá pötügö. ");
INSERT INTO mazNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nuc'ua c'o xondaro 'ma ya o nguarü o ndät'äji e Jesús, o nganbaji c'ua c'o o̱ bitu. C'o nziyo xondaro nde 'naja o̱ bitu va ngana c'o. Nde o nganbaji c'ü mi tëjë. C'ü mi tëjë mi 'na ma cjatjo va be'e texe, dya mi ch'äcä. ");
INSERT INTO mazNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","O pötva mamatsjë anguesji: ―Nu nu mi tëjë, dya rá xü't'üji nu. Nu c'ü rá cjaji, rá eñeji cjó ra ndõjõ ra tsjapü o̱ cjaja. A cjanu o zädä c'ü je t'opjü c'ü mama a cjava: “Ra nganngöji ín bitugö, ra jyadüji nde 'naja rgá nganaji. Y nu c'ü rí tëjëgö, ra eñeji cjó ra ndõjõ ra ngana c'ü”, eñe. Nuyo, o tsja a cjanu c'o xondaro. ");
INSERT INTO mazNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mi cãrã a jmi cja o̱ ngronsi e Jesús, c'ü nu nana cja na 'ñe c'ü nu cjũjuë c'ü nu nana. Xo mi bübü nu e María c'ü nu su e Cleofas, 'ñe e María Magdalena. ");
INSERT INTO mazNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","E Jesús o jñanda c'ua c'ü nu nana c'ü mi bübü nu, 'ñe c'ü nu discípulo c'ü mi s'iya, nde mi böbüvi nu. Nuc'ua o xipji c'ua c'ü nu nana: ―Jñanda dya, mamá, nunu ín discípulogö, nu nde i̱ṉ böbüvi, ya ngueje in ch'igue dya nu. ");
INSERT INTO mazNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nuc'ua e Jesús o xipji c'ü nu discípulo: ―Jñanda, nu mi mamágö, ya ngueje nin mamágue dya nu. Ndeze c'e hora c'ü, c'ü nu nana e Jesús o tsjapü nu nana c'e discípulo. Nuc'ua c'e discípulo, 'ma o ma o̱ ngumü, o zidyi c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nu 'ma ya o nguarü yo, ya mi pãrã e Jesús ya vi nguarü texe. Nuc'ua o mama c'ua: ―Me rí tũre dya. A cja dya nu o zädä c'ü mi t'opjü. ");
INSERT INTO mazNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mi järä nu, 'naja s'äbä c'ü mi nizhi o vinagre. Nuc'ua o popjüji 'naja esponja cja c'e vinagre. Cjanu o mbans'aji cja 'naja maza c'ü ni chjũ'ũ hisopo. Nuc'ua o c'uãsp'ãji c'e maza o zät'ä cja o̱ ne'e e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nuc'ua e Jesús, 'ma ya o popjüji o̱ ne co c'e vinagre, o mama c'ua: ―Ya o nguarü texe. Nuc'ua ya ñücü c'ua, ngueje 'ma ya o ndũ'ũ. ");
INSERT INTO mazNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nuc'ua c'o nte a Israel ya mi preparaoji, na ngue c'ü na jyas'ü mi ngueje c'e ndambaxua c'ü ni chjũ Pascua. Nuc'ua o dyötüji e Pilato ro 'huapcüji o̱ ngua'a c'o añima c'o vi dät'ä cja ngronsi, ro ts'ücüji ngue c'ua dya ro bübüji nu cja ngronsi nu pa c'ü mi söya c'o nte. Na ngueje me mi sũpüji c'e pa. ");
INSERT INTO mazNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","O ma c'ua c'o xondaro, o ma 'huapcüji o̱ ngua c'o yeje c'o nde vi dät'ä 'ma o dät'ä e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nuc'ua 'ma o zät'äji cja e Jesús, o nu'uji c'ua, ya vi ndũ'ũ. Nuc'ua dya cja o 'huapcüji o̱ ngua'a. ");
INSERT INTO mazNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nuc'ua 'naja c'o xondaro o chjopcü o̱ ximãtjã e Jesús co 'naja lanza. Nuc'ua ya o mbedye c'ua o cji'i 'ñe o ndeje. ");
INSERT INTO mazNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Bübü 'na bëzo c'ü o jñanda texe yo o tsjapüji e Jesús, nguec'ua ga xi'tsc'eji yo. Angueze pãrã na cjuana yo mama. C'ü ni xi'tsc'eji yo, ngue c'ü xo rgui 'ñejmegueji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","O ts'a'a yo ngue c'ua ro zädä c'o mi t'opjü c'o mama a cjava: “Angueze, dya pje ra 'huapcüji ne ri 'naja o̱ ndo'dyë.” ");
INSERT INTO mazNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Xo t'opjü c'ü mama a cjava: “Nu c'ü o chjocüji lanza, nuc'ü, ra jñandaji c'ü.” ");
INSERT INTO mazNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mi bübü 'na bëzo c'ü mi menzumü a Arimatea c'ü mi chjũ José. Nuc'ü, xo mi ejme e Jesús, pero dya cjó ngös'ü na ngueje mi sũ'ũ c'o dyaja c'o pje mi pjëzhi cja c'o nte a Israel. C'e bëzo c'ü, o ma dyötü e Pilato ro unü sjëtsi ro ma ts'ücü c'e añima c'ü mi ngueje e Jesús. Nuc'ua e Pilato o unü sjëtsi. ");
INSERT INTO mazNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nuc'ua xo o ẽjẽ c'ua e Nicodemo, nu c'ü vi ma'a c'ü xõmü cja e Jesús. Mi tũ'ũ o pjindyo c'o mi chjũ mirra 'ñe c'o mi chjũ áloes c'o vi huana. Nu c'o pjindyo c'o, o zö treinta kilo c'ü na jyü'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","O ndunüvi c'ua c'e añima. O ngos'üvi c'o mirra 'ñe c'o áloes. Cjanu o mbös'üvi manta. Nuc'o, je mi cjavi a cjanu, na ngueje c'o nte a Israel je ga dyögüji a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Cja c'e lugar c'ü, nu ja je vi dät'ä e Jesús, mi bübü 'naja huerta. Nu cja c'e huerta mi bübü 'naja cueva nu ja ro ngöt'üji o añima. Dya cjó be mi cöt'üji nu. ");
INSERT INTO mazNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ya mi ngue ro mbürü c'e pa 'ma söya c'o menzumü a Israel. Nguec'ua je ngöt'üvi e Jesús cja c'e cueva, na ngueje mi bëxtjo nu ja vi ndät'äji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","C'ü ot'ü pa nu ngo'o, e María Magdalena o ma cja c'e cueva. Xe mi xõmütjo 'ma o ma. O jñanda c'e ndojo c'ü mi c'o't'ü, dya cja mi c'o't'ü cja c'e cueva. ");
INSERT INTO mazNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nuc'ua cjanu o ma c'ua na niji. O ma nu ja mi bübü e Simón Pedro 'ñe c'ü 'naja discípulo. Nu c'e discípulo c'ü, me mi s'iyaji c'ü, mi cja e Jesús. E María o xipjivi: ―C'ü ín Jmu'uji, ya o ndunüji c'ü. Dya pje rí pãrãjme ja je o ngöt'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","O ma c'ua e Pedro co c'ü 'naja discípulo. Je mëvi nu cja c'e cueva nu ja je vi c'öt'ü e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","O mëvi na niji nza yejevi. Nu c'ü 'naja discípulo ngue c'ü xenda o ma na niji c'ü. Nuc'ü, ot'ü o zät'ä nu cja c'e cueva c'ü. ");
INSERT INTO mazNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nuc'ua o nguĩ'ch'ĩ c'ua c'e discípulo cja c'e cueva. O jñanda c'ua c'o bitu c'o ya mi bädätjo. Nu c'e discípulo, dya o nguich'i cja c'e cueva. ");
INSERT INTO mazNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","O säjä c'ua e Simón Pedro c'ü ma tjünt'ü a xütjü. Ngue c'ü ya je nguich'i cja cueva c'ü. O nu'u c'o bitu c'o vi mbös'üji ya mi bädätjo c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","C'e bitu c'ü mi bös'ü o̱ ñi'i e Jesús, dya chjana c'o mi tëjë c'ü. Mi bädä aparte c'ü. Mi ch'o't'ü na jo. ");
INSERT INTO mazNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nuc'ua ya xo o nguich'i c'ua c'ü 'naja discípulo c'ü ot'ü vi zät'ä cja c'e cueva. O 'ñejme c'ua e Jesús ya vi te'e. ");
INSERT INTO mazNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Dya be mi pãrãvi ja cja c'ü mama yo ya vi t'opjü c'ü mama c'ü mi jyodü ro te'etjo e Jesús nu ja vi c'öt'ü cja c'o añima. ");
INSERT INTO mazNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nuc'ua c'o discípulo o nzhogütjovi. O mëvi cja o̱ ngumüvi. ");
INSERT INTO mazNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nu c'e María mi böbütjo a tji'i. Me mi huë'ë c'ü. O nguĩ'ch'ĩ c'ua cja c'e cueva. ");
INSERT INTO mazNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nuc'ua o jñanda c'ua yeje o̱ anxe Mizhocjimi c'o mi je na t'öxü. Je mi junrüvi nu ja je vi c'öt'ü e Jesús. 'Naja je mi junrü nu ja vi jñusp'üji o̱ ñi'i. C'ü 'naja je mi junrü cja o̱ ngua'a. ");
INSERT INTO mazNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nuc'ua c'o anxe o dyönüvi e María: ―¿Jenga i̱ṉ huë'ëgue? O ndünrü c'ua e María: ―Rí huë'ëgö na ngueje ya o ndunngügöji c'ü ín Jmu'ugö. Dya rí pãrã dya, ja je ma ngöt'üji. ");
INSERT INTO mazNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","'Ma o nguarü o mama yo jña'a yo, e María o ñezhe a ma a xütjü. Ya o jñanda c'ua 'naja c'ü mi böbü cja o̱ xütjü. E María dya pje mbãrã c'ü, cjo mi ngueje e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nuc'ua e Jesús o xipji c'ua: ―¿Jenga i̱ṉ huë'ëgue? ¿Cjó ngueje c'ü i̱ṉ jodügue? E María mi cjijñi mi ngueje c'ü mi pjörü c'e huerta. Nuc'ua e María o xipji: ―Sẽ'ẽ, nu 'ma i̱ chunügue ín Jmugö, xitsigö ja je i̱ ma sogü, nguec'ua rá magö nu, rá tunü. ");
INSERT INTO mazNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","E Jesús o zopjü c'ua, o mama: ―Nu'tsc'e María. O ñezhe c'ua e María. O ña cja jña hebreo, o xipji: ―Nu'tsc'e ngue'tsc'e ín xöpütets'ügö. ");
INSERT INTO mazNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","E Jesús o xipji: ―Dya rí pënzhguigö, na ngueje dya be rí pagö cja mi Tata c'ü bübü a jens'e. Nu c'ü rí tsja, ma cja yo mi cjuarma. Xipjiji, nuzgö ya rá magö cja mi Tatagö a jens'e. Nuc'ü, xo ngueje nin Tatagueji. Angueze ngueje ín Mizhocjimigö. Xo ngueje in Mizhocjimigueji. ");
INSERT INTO mazNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","O ma'a c'ua e María Magdalena, o ma ngös'ü c'ua c'o discípulo, o xipjiji: ―Nuzgö ya ró chjëgöbe nu c'ü ín Jmugöji. O xipjiji c'ua c'o jña'a c'o vi mama e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ya mi nzhä'ä c'ü ot'ü pa nu ngo'o. Mi cjot'ü c'e ngoxtji nu ja 'natjo c'ua mi cãrã c'o o̱ discípulo e Jesús. Vi ngot'üji na jo c'e ngoxtji na ngueje mi sũji c'o nu menzumüji a Israel. O ẽjẽ c'ua e Jesús, o ẽ böbü a nde anguesji. O ẽ zenguaji, o xipjiji: ―Cjimi i̱ṉ texeji ín cjuarmats'üji. Ra söya in mü'büji, dya cja rí sũgueji. ");
INSERT INTO mazNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","'Ma o xipjiji a cjanu, ya o jíchiji o̱ dyë'ë 'ñe c'ü nu ximãtjã. Me co mäjä c'ua c'o o̱ discípulo 'ma o jñandaji nu c'ü nu Jmu'uji. ");
INSERT INTO mazNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","E Jesús o xipjitjoji c'ua na yeje: ―Ra söya in mü'büji, dya cja rí sũgueji. C'ua ja nzi va ndäcjö mi Tatagö c'ü bübü a jens'e, xo rgá täc'ägöji rí ma zopjüji yo nte. ");
INSERT INTO mazNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","'Ma o nguarü o mama yo jña'a yo, o̱ juipji e Jesús. O xipjiji: ―Ra bübü cja in mü'büji o̱ Espíritu Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nuc'ua, nu c'o rí perdonaogueji o̱ nzhubüji, ya perdonaoji c'ua c'o. Nu c'o dya rí perdonaogueji o̱ nzhubüji, dya perdonaoji c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nu 'ma o ẽjẽ e Jesús, dya mi bübü co anguesji e Tomás c'ü xo mi chjũ Gemelo. Nuc'ü, xo mi ngueje 'naja c'o doce discípulo. ");
INSERT INTO mazNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nguec'ua c'o dyaja discípulo 'ma o chjëji e Tomás, o xipjiji c'ua: ―Nu'tsc'e, Tomás, nuzgöjme ró jandajme ín Jmugöji. E Tomás o xipjiji: ―Nuzgö dya pje rí ejmegö. Cja rá ejmegö 'ma rá nu'tp'ü o̱ dyë'ë c'ua ja je o ndä'p'äji 'ñe 'ma rá c'uã't'ã ín nidyë c'ua ja je o chjopcüji o clavo, y 'ma rá c'uã't'ã ín dyë'ë cja o̱ ximãtjã nu ja je o chjopcüji. Ngue 'ma cja rá ejme 'ma. ");
INSERT INTO mazNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nu 'ma o zö chjün'ü, ma cã'ã na yeje a mbo cja c'e ngumü c'o discípulo. E Tomás xo nde mi bübüji. Mi cjot'ütjo na jo c'o ngoxtji. Nuc'ua o ẽjẽ c'ua e Jesús. O ẽ böbü a nde anguesji. Nuc'ua o yepe o mamatjo c'ua: ―Cjimi i̱ṉ texeji, ín cjuarmats'üji. Ra söya in mü'büji, dya cja rí sũgueji. ");
INSERT INTO mazNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","E Jesús o xipji c'ua e Tomás: ―C'uã't'ã in ñidyë dya va. Jñandga ín dyëgö. C'uãnã in dyë, c'uã't'ã cja ín ximãtjãgö. Dya rí tsjijñi cjo dya nguetscö. C'ü rí tsja, 'ñejmegue que nguetscö. ");
INSERT INTO mazNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nuc'ua o ndünrü c'ua e Tomás, o xipji: ―Jãgã. Ngue'tsc'e ín Jmuts'ügö. Ngue'tsc'e ín Mizhocjimits'ügö. ");
INSERT INTO mazNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","E Jesús o xipji c'ua: ―Nu'tsc'e Tomás, i̱ 'ñench'ezü cja in mü'bügue na ngueje ya i̱ ñutcü ín dyë'ë. Nu c'o dya nutcügö ín dyë'ë, pero ra 'ñench'ezü cja o̱ mü'büji, me ra mäjä c'o, eñe e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Xe ma puncjü c'o ma nojo c'o o tsja'a e Jesús cja o̱ jmi c'o o̱ discípulo. Pero nuc'o, dya pje t'opjü cja nu e libro c'o. ");
INSERT INTO mazNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nu c'o ya t'opjü dya va, t'opjü ngue c'ua rí 'ñejmeji e Jesús ngueje e Cristo c'ü o̱ T'i Mizhocjimi. A cjanu, nu 'ma rí 'ñench'eji in mü'büji e Cristo, angueze ra dya'c'üji c'ü sido rí bübütjoji co Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dya cja mezhe c'ua, o matjo na yeje e Jesús nu ja mi cãrã c'o o̱ discípulo cja c'e trazapjü a Tiberias, ngue c'ua xe ro unüji ngüenda c'ü vi te'etjo. Rá xi'tsc'öji ja va ts'a. ");
INSERT INTO mazNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","'Natjo c'ua mi cãrãji e Simón Pedro 'ñe e Tomás c'ü xo mi chjũ'ũ Gemelo 'ñe e Natanael c'ü mi menzumü a Caná c'ü tsja a Galilea, 'ñe c'o yeje o̱ t'i e Zebedeo, cja na xe yeje c'o o̱ discípulo e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","E Simón Pedro o xipjiji: ―Nuzgö rá ma pagö o jmõ'õ. O ndünrü c'ua c'o dyaja discípulo: ―Xo 'ñezgöjme, xo rá möjö. Nuc'ua o möji c'ua. O dat'üji cja 'naja bü'ü. C'e xõmü c'ü, dya pje o zürüji. ");
INSERT INTO mazNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nu 'ma ya mi ngue ro jyas'ü, e Jesús ya mi böbü cja ñünü cja c'e ndeje. C'o discípulo dya mi pãrãji cjo mi ngueje e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nuc'ua e Jesús o xipjiji: ―Nu'tsc'eji ín ch'itsc'öji, ¿cjo ya i̱ sürügueji 'na jmõ c'ü rí sagueji? O ndünrüji, o mamaji: ―Jiyö. Ojtjo dya pje rí sürügöjme. ");
INSERT INTO mazNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","E Jesús o xipjiji c'ua: ―Pät'äji dya c'e red a ma cja in jodyëji cja e bü'ü, ngue c'ua rí chöt'üji. Nuc'ua o mbät'äji c'ua. Nuc'ua, dya cja mi sö ro ngüs'üji na ngueje me ma puncjü c'o jmõ'õ c'o vi ngãjãji. ");
INSERT INTO mazNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nuc'ua c'ü o̱ discípulo e Jesús c'ü me mi s'iya o xipji e Pedro: ―Nunu ngueje ín Jmuji nu. 'Ma o dyärä e Simón Pedro mi ngueje o̱ Jmuji, o jye o̱ bitu c'ü vi ndons'ü. Cjanu o dat'ü c'ua cja ndeje. ");
INSERT INTO mazNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nu c'e bü'ü mi jyadüvi cien metro ro zät'ä a ñünü c'e zapjü. C'o dyaja discípulo ma ẽjẽji cja c'e bü'ü, ma cjüt'üji c'e red c'ü me mi nizhi o jmõ'õ. ");
INSERT INTO mazNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","'Ma o zät'äji a ñünü cja c'e zapjü o jñandaji o chjeme c'o ya ma tjë'ë. Mi juns'ü c'ua o jmõ'õ. Xo ma jä'ä o xëdyi. ");
INSERT INTO mazNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","E Jesús o xipjiji c'ua: ―Ma jñüji dya, ja nzi jmõ'õ c'o i̱ sürüji. ");
INSERT INTO mazNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","E Simón Pedro o ndes'e c'ua cja c'e bü'ü. O ma tũ'ũ c'e red. Cjanu o jyät'ä a ndeje, cjanu o ngüt'ü va ma cja ñünü c'e zapjü. C'e red ma nizhi o jmõ'õ c'o nde ma nojo. Ma qui'i 'naja ciento cincuenta y tres o jmõ'õ. Zö xi ma puncjüji, dya pje o xüt'ü c'e red. ");
INSERT INTO mazNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","O mama c'ua e Jesús, o xipji c'o discípulo: ―Xä'däji dya. Rí siji o xëdyi. C'o discípulo dya mi rezga ro dyönüji cjó mi ngueje. Anguezeji ya mi pãrãji mi ngueje o̱ Jmuji. ");
INSERT INTO mazNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nuc'ua e Jesús o jñü'ü c'ua c'o xëdyi. Cjanu o unüji. Ya nde unüji c'ua c'o jmõ'õ. ");
INSERT INTO mazNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nunu, ya ma jñi'i ma chjëji e Jesús ndeze vi te'e cja c'o añima. ");
INSERT INTO mazNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nuc'ua 'ma o nguarü o ziji o xëdyi, e Jesús o xipji e Simón Pedro: ―Nu'tsc'e, Simón, o̱ t'its'ü e Jonás, ¿cjo xenda i̱ṉ s'iyazügö que na ngueje yo? E Pedro o xipji c'ua: ―Jãgã. Nu'tsc'e ín Jmuts'ügö, i̱ṉ pãrãgue rí nets'egö. O ndünrü c'ua e Jesús: ―'Huiñi c'o ín ts'imëgö. ");
INSERT INTO mazNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","E Jesús o xipji c'ua na yeje: ―Simón, nu'tsc'e o̱ t'its'ü e Jonás, ¿cjo i̱ṉ s'iyazü? O ndünrü c'ua e Pedro: ―Jãgã. Nu'tsc'e ín Jmuts'ügö, i̱ṉ pãrãgue rí nets'egö. O xipji c'ua e Jesús: ―Pjörü c'o ín nzhënchjürügö. ");
INSERT INTO mazNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","E Jesús o xipji c'ua na jñi'i: ―Nu'tsc'e Simón, o̱ t'its'ü e Jonás, ¿cjo i̱ṉ neze? O nguijñi c'ua e Pedro na ngueje e Jesús vi xipji c'ü na jñi'i: “¿Cjo i̱ṉ neze?” O ndünrü c'ua, o xipji: ―Nu'tsc'e, ín Jmuts'ügö, i̱ṉ pãrãgue texe. I̱ṉ pãrãgue rí netsc'ö na puncjü. O xipji c'ua e Jesús: ―Pjörü c'o ín nzhënchjürügö. ");
INSERT INTO mazNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na cjuana c'ü rí xi'ts'i. Nu'tsc'e, Pedro, ndeze 'ma cja mi t'igue, mi cjague c'ü mi cjĩ in ñigue, y mi pague c'ua ja mi negue. Nu 'ma ya rí titague, rí chjüdügue in dyë'ë, y ra zints'iji nu ja dya rí ñegue rí ma'a. ");
INSERT INTO mazNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E Jesús o xipji e Pedro yo jña'a yo, ngue c'ua ro mbãrã ja rvá ndũ'ũ na ngueje sido ro 'ñejme Mizhocjimi. Xo o xipji c'ua: ―Nudya, chjünt'ü ín xütjügö dya. ");
INSERT INTO mazNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","O ñezhe e Pedro. O jñanda c'e discípulo c'ü mi junrüvi e Jesús 'ma o ziji o xëdyi ante c'ü ro bö't'ü e Jesús. Ngue c'ü vi mama: “Nu'tsc'e, ín Jmuts'ü, ¿cjó je ngue c'ü ra nzhöc'ügue?” C'e discípulo ma tjünt'ü a xütjü e Pedro 'ñe e Jesús. E Jesús me mi s'iya c'e discípulo. ");
INSERT INTO mazNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","E Pedro 'ma o jñanda c'e discípulo, o xipji c'ua e Jesús: ―Nu'tsc'e, ín Jmuts'ügö, ne bëzo nu, ¿pje ra tsjapüji c'ü ra sufrido nu? ");
INSERT INTO mazNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","O ndünrü c'ua e Jesús: ―Nu'tsc'e, Pedro, 'ma rá negö xe ra bübü nu hasta cja ne rá ẽcjö na yeje, ¿pje mportats'ügue? C'ü ni jyodü rí tsjague, sido rí chjüntc'e ín xütjügö. ");
INSERT INTO mazNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nguec'ua c'o cjuarma nde mi mamaji c'ü dya ro ndũ'ũ c'e discípulo. Pero e Jesús dya vi xipji c'ü dya ro ndũ'ũ. C'ü vi xipji je ngueje a cjava: “'Ma rá negö xe ra bübü angueze cja rá ẽcjö na yeje, nu'tsc'e, ¿pje mportats'ügue?” ");
INSERT INTO mazNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nu c'e discípulo nguejnu na xi'tsc'eji nu c'o o ts'a'a. Nguejnu na opjü yo jña'a yo. Rí pãrãgöjme nu c'ü xi'tsc'eji c'e discípulo, na cjuana yo. ");
INSERT INTO mazNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Xe bübütjo c'o dyaja c'o me na puncjü c'o o tsja'a e Jesús. Nu 'ma ro t'opjü texe c'o, rí cjinncjö, dya xo ro chjënfi cja ne xoñijõmü c'o libro c'o ro t'opjü. Na cjuana texe yo rí xi'tsc'öji, amén.");
INSERT INTO mazNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Nu'tsc'e Teófilo, ya ró pen'c'e 'na carta. Ró xi'tsc'ö ja ga cja c'o o tsja e Jesús hasta 'ma o ma a jens'e, 'ma o zidyi Mizhocjimi. Ró xi'tsc'ö c'o o tsja, 'ñe c'o jña c'o o jíchi va zopjü c'o nte. Ante c'ü ro zidyiji a jens'e e Jesús, o zopjü c'o bëzo c'o vi juajnü c'o mi apóstole. O xipjiji c'ü ro ẽjẽ o̱ Espíritu Mizhocjimi; nguec'ua mi jyodü ro sidoji c'e bëpji c'ü mi cja e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","O ndũ e Jesucristo cja ngronsi, cjanu o tetjo c'ua o bübütjo na yeje. Nuc'ua, ante c'ü ro zidyiji a jens'e, xe go mezhe cuarenta pa c'ü xe mi bübütjo cja ne xoñijõmü. Na puncjü vez va jñetse nu ja mi cãrã c'o apóstole, o jizhi c'ü ya vi te'e. Anguezeji o jñandaji c'ü na cjuana vi te. E Jesús o zopjü c'o apóstole o xipjiji c'ü ja rvá manda angueze. Na ngue ngue c'ü vi 'ñeme Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","'Na nu pa mi cãrãji e Jesús c'o o̱ apóstole. Nuc'ua e Jesús o zopjü c'o apóstole o xipjiji: ―Dyäräji na jo c'ü rá xi'tsc'öji. Dya rí pedyeji va a Jerusalén. Rí che'beji ra ch'a'c'üji nu c'ü o mama Mizhocjimi c'ü ya ró xi'tsc'öji. ");
INSERT INTO mazNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ró xi'tsc'öji e Juan mi jichi yo nte co ndeje. Pero dya cja ra mezhe o pa, ra ẽjẽ o̱ Espíritu Mizhocjimi ra ẽ bübü cja in mü'bügueji, embeji c'o apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","'Ma mi cãrãji e Jesús c'o o̱ apóstole, o mama c'ua c'o apóstole o dyönüji e Jesús: ―Nu'tsc'e ín Jmuts'ügöjme, nutscöjme rí menzumüjme a Israel. 'Ma ot'ü, mi 'ñegöjme ín reygöjme c'o ín menzumügöjme. ¿Cjo ya ngue rí mandague rí tsjague ín reygöjme, ngue c'ua dya cja ra mandazüjme c'o 'ñaja nte? ");
INSERT INTO mazNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","O ndünrü c'ua e Jesús o xipjiji: ―C'ü mama Mizhocjimi mi Tata ra zädä, nguextjo angueze ra mama jinguã ra zädä, 'ñe ja rga cja c'o pa c'o. Nu'tsc'eji, dya ngue'tsc'eji tocats'üji rí pãrãji yo. ");
INSERT INTO mazNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","C'ü tocats'üji rí pãrãji, ngueje c'ü ra ẽts'üji o̱ Espíritu Mizhocjimi ra ẽ bübü cja in mü'büji ra dya'c'üji poder. Nguec'ua rí zopjügueji yo nte yo tsja va a Jerusalén rí xipjiji c'o ya i̱ jñandaji ró cjagö, 'ñe c'o i̱dyäräji ró xi'tsc'öji. Xo rí möji a Judea rí ma zopjüji c'o nte c'o cãrã nu. Xo 'ñe a ma a Samaria, 'ñe texe cja ne xoñijõmü, eñe e Jesús va xipji c'o o̱ apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","'Ma o nguarü e Jesús o mama c'o jña c'o, o jñanda c'o apóstole o nguins'i a jens'e e Jesús; o zidyi Mizhocjimi. O cjogü c'ua cja 'na ngõmü; dya cja jñandaji c'ua c'ü. ");
INSERT INTO mazNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","'Ma xe mi jandaji a jens'e, 'nango jñetse c'ua yeje anxe c'o mi nza cja o bëzo. Mi je'evi o bitu c'o me ma t'öxü. Mi böbüvi cja o̱ jmi c'o apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","O xipjiji c'ua c'o apóstole: ―Nu'tsc'eji i̱ṉ menzumüji a Galilea, ¿jenga i̱ṉ jandaji a jens'e? Mizhocjimi ya zidyi a jens'e e Jesús. Ja c'o nzi vi jñandagueji va ma a jens'e, je xo rga cjatjonu 'ma ra ẽjẽ na yeje, eñe c'o yeje anxe. ");
INSERT INTO mazNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","C'o apóstole mi cãrãji cja c'e t'eje c'ü ni chjũ Olivo. O mbedyeji nu, o möji a Jerusalén nu ja vi 'ñeji e Jesús. C'e t'eje mi bëxtjo a Jerusalén; mi jyadütjovi 'na kilómetro. Nguextjo c'ü mi mama c'o ley c'ü mi sö ro nzhodüji c'e pa 'ma mi söyaji. ");
INSERT INTO mazNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","C'o apóstole mi chjũ e Pedro, 'ñe e Jacobo 'ñe e Juan 'ñe e Andrés 'ñe e Felipe' ñe e Tomás' ñe e Bartolomé 'ñe e Mateo 'ñe e Jacobo c'ü mi t'i cja e Alfeo. Xo mi chjũ e Simón c'ü mi revolucionario, 'ñe e Judas c'ü mi cjuarmavi e Jacobo. 'Ma mü o zät'äji a Jerusalén, o cjogüji cja c'e ngumü nu ja mi oxüji cjanu o ndes'eji o cjogüji cja c'e cuarto c'ü mi jäs'ä a xes'e. ");
INSERT INTO mazNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mi 'natjo o̱ pjeñeji ma dyötüji Mizhocjimi. Xo mi bübü nu c'o o̱ cjuarma e Jesús, 'ñe c'ü nu nana c'ü mi ngue e María, 'ñe c'o 'ñaja ndixũ. Xo mi ötüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nu cja c'e jyäxcumü, mi cãrã 'na ciento viente cjuarma. C'o pa 'ma mi cãrãji nu, o böbü e Pedro a nde cja c'o cjuarma, cjanu o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nu'tsc'eji mi cjuarmats'ügöji. Mi jinguã o̱ Espíritu Mizhocjimi o 'ñünbü o̱ mü'bü e David o dyopjü ja rva cja nu c'ü ro mbös'ü c'o nte ro zürüji e Jesús. E Judas o jizhi ja mi cãrãgöji e Jesús, nguec'ua va zidyiji e Jesús cja c'o pje mi pjëzhi. Nguec'ua o zädä c'ü o̱ jña Mizhocjimi ja c'o nzi va mama e David. ");
INSERT INTO mazNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mi dyocjöji e Judas. E Jesús xo vi 'ñeme e Judas c'ü ro tsja c'e bëpji c'ü rá cjaji, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","E Judas o ngõ't'üji para o tsja na s'o, o zidyi c'o nte c'o o ma zürü e Jesús. Nuc'ua cjanu o ma chjüns'ütsjë; o ndögü a jõmü o mböt'ü texe c'o o̱ xẽpjo. Co c'e merio c'ü vi ngõ't'üji e Judas, o ndõmüji 'na juajma. ");
INSERT INTO mazNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","C'o mi menzumü a Jerusalén, 'ma mü o mbãrãji c'o vi tsja e Judas, o jñusp'üji c'ua c'e juajma mi chjũ Acéldama cja o̱ jña anguezeji. C'e tjũ Acéldama ne ra mama Cjijuajma c'ü. ");
INSERT INTO mazNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","O sido o ña e Pedro o mama: ―Je t'opjü a cjava cja Salmos: Dya cja cjó ri bübü cja o̱ ngumü; dya cja cjó ri nzheñe nu, eñe. Xo mama cja Salmos: C'e bëpji c'ü o ch'unü ra tsja, ra tsja c'ü 'naja, eñe o̱ jña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Nguec'ua c'ü ro pëpji e Judas, rá juajnüji c'ü ra pëpji. Bübü va o bëzo c'o mi dyocjöji co e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Mi dyocjöji co e Jesús ndeze c'o pa 'ma mi jichi e Juan c'o nte, hasta 'ma o zidyiji a jens'e e Jesús. 'Naja yo, xo ni jyodü ra tsja apóstole co nutscöji, rá xipjiji yo nte c'ü o te e Jesús, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nguec'ua c'o mi cãrã nu, o mamaji c'ü mi bübü yeje c'o dya mi apóstole c'o mi dyoji e Jesús ndeze 'ma mi jichi e Juan c'o nte, hasta 'ma o zidyiji a jens'e e Jesús. Nuc'o, mi chjũ e José Barsabás 'ñe e Matías. E José Barsabás xo mi xiji Justo. ");
INSERT INTO mazNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nuc'ua o dyötüji Mizhocjimi o mamaji: ―Mizhocjimi ín Jmuts'ügöjme, i̱ṉ pãtcãgöjme ín mü'büjme nutscöjme rí ntegöjme. Rí ö'tc'öjme c'ü rí jítscöjme yo yeje cjuarma, ja ngue c'ü ya i̱ juajnügue. ");
INSERT INTO mazNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nguec'ua ra tsja apóstole ra tsja c'e bëpji c'ü ro tsja e Judas. Na ngue e Judas o xõgü co nuzgöjme, o tsja c'o na s'o. Nguec'ua va ma sufre, eñeji va dyötüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nuc'ua cjanu o echaji suerte; o toca e Matías. Nguec'ua o zötjo c'o doce apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","O zädä c'ua c'o pa 'ma mi pjongüji c'e mbaxua c'ü mi chjũ Pentecostés. C'o apóstole 'ñe c'o 'ñaja c'o mi ench'e o̱ mü'bü e Jesucristo, 'natjo c'ua mi cãrãji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","'Nango dyäräji c'ü vi 'ñeje a jens'e c'ü me mi yürü nza cja 'ma vü na zëzhi o ndajma. Me go yürü c'ua na jens'e a mbo cja c'e ngumü nu ja ma jũji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","'Nango jñandaji c'ua o c'ijñi c'o mi 'ñetse nza cja o sivi. Nuc'o, o mböt'ü o 'ñe toca nzi 'naji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nuc'ua o̱ Espíritu Mizhocjimi o cjogü a mbo o̱ mü'bü texeji, me go 'ñünbü o̱ mü'büji. Nguec'ua o mbürü o ñaji c'ua nan'ño idioma, ja c'o nzi va unü o̱ Espíritu Mizhocjimi o ñaji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mi cãrã a Jerusalén c'o mi ätä Mizhocjimi c'o mi ngue o̱ dyoji c'o menzumü cja c'e país a Israel, pero vi jmus'üji cja c'o 'ñaja país. ");
INSERT INTO mazNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Anguezeji 'ma mü o dyäräji, o möji c'ua nu ja mi cãrã c'o apóstole 'ñe c'o 'ñaja cjuarma. Dya mi pãrã pje ro nguijñiji, na ngue mi äräji mi ñaji o jña c'o mi ña anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Me co zũji c'ua, me co mamaji: ―Nujyo na ña'a, ¿cjo dya menzumüji a Galilea? ");
INSERT INTO mazNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Maco ña ín jñagöji yo, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nu c'o vi ẽ dyärä c'o mi ña c'o cjuarma, mi cãrã c'o vi jmus'ü cja c'e país c'ü mi chjũ a Partia. Xo mi cãrã c'o vi jmus'ü a Media 'ñe a Elam. Xo mi cãrã c'o vi jmus'ü a Mesopotamia. Xo mi cãrã c'o vi jmus'ü a Judea. Xo mi cãrã c'o vi jmus'ü a Capadocia 'ñe a Ponto 'ñe a Asia. ");
INSERT INTO mazNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","C'o o ẽ dyärä c'o mi ña c'o cjuarma, xo mi cãrã c'o vi jmus'ü a Frigia 'ñe a Panfilia. Xo mi cãrã c'o vi jmus'ü a Egipto 'ñe a Cirene 'ñe cja c'o 'ñaja país a Cirene a manu. Xo mi cãrã c'o vi 'ñeje a Roma. C'o vi 'ñeje a Roma, bübü c'o mi ngue o̱ dyoji c'o menzumü cja c'e país a Israel; bübü c'o dya mi ngue o̱ dyoji c'o menzumü a Israel, pero mi ma't'üji Mizhocjimi ja c'o nzi ma ma't'ü Mizhocjimi c'o menzumü a Israel. ");
INSERT INTO mazNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","C'o o ẽ dyärä c'o mi ña c'o cjuarma, xo mi cãrã c'o vi jmus'ü a Creta 'ñe a Arabia. Texe c'o o ẽ dyärä, pötü va mamaji: ―Rí ärägöji ña yo bëzo yo ín jñagöji nzi 'nazgöji. Mamaji c'o me na nojo c'o o tsja Mizhocjimi, mi eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Anguezeji mi sũji, dya mi pãrã pje ro nguijñiji. Mi pötü ma mamaji: ―¿Pje ne ra mama c'ü ñaji a cjanu yo ín jñagöji?, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bübü c'o me mi tjenbe ma tsjapü burla c'o cjuarma, mi mamaji: ―Nujyo, ya tĩ yo. ");
INSERT INTO mazNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nuc'ua o böbü c'o doce apóstole. Cjanu o ña c'ua na jens'e e Pedro o zopjü c'o nte c'o vi 'ñe dyärä, o xipjiji: ―Nu'tsc'eji i̱ṉ cãrãji a Jerusalén, dyäräji c'ü rá xi'tsc'öji zö i̱ṉ menzumüji va a Judea o jiyö. Rí unnc'eji na jo ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bübüts'üji c'o pëzhi rí tĩgöjme, pero dya ga cjanu. Maco xõxtjo, cja zünü a las nueve. ");
INSERT INTO mazNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","C'ü rgá ñagöjme nan'ño idioma, ya zädä c'ü o mama e Joel c'ü mi profeta. O mama a cjava: ");
INSERT INTO mazNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","O mama Mizhocjimi: C'o cjë c'o ya rguí ma ra nguins'i e jens'e 'ñe ne xoñijõmü, rá täjä ín Espíritu ra ma bübü cja o̱ mü'bü yo nte yo cãrã texe cja ne xoñijõmü. Me ra 'ñünbü o̱ mü'büji. Nguec'ua c'o sẽ ra mamaji ín jñagö; 'ñe c'o süngü. C'o sẽ 'ñe c'o tata ra nguinch'iji o t'ĩjĩ ra mbãrãji c'o ra zädä. ");
INSERT INTO mazNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","C'o pa c'o, rá unü ín Espíritu c'o bëzo 'ñe c'o ndixũ c'o pëpquigö. Ra 'ñünbü o̱ mü'büji ra zopjüji yo nte ra xipjiji ín jñagö. ");
INSERT INTO mazNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Rá jizhigö a jens'e o señal c'o me rrã nojo, c'o me rguí zũ yo nte. Xo 'ñe cja ne xoñijõmü. Ra jñandaji o cji, 'ñe o sivi, 'ñe o bipji c'ü ri nza cja o trangõmü. ");
INSERT INTO mazNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ra bëxõmü e jyarü. E zana ri jñetse nza cja o cji. Nujyo, rá jizhgö yo. Nuc'ua ra ẽjẽ c'in Jmugueji ra 'ñe manda. Me rrã sjũ c'e pa c'ü. ");
INSERT INTO mazNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nu c'o ra dyötü Mizhocjimi co texe o̱ mü'bü, ra perdonaoji 'ma c'o na s'o, mama a cjanu o̱ jña Mizhocjimi ja c'o nzi va dyopjü e Joel c'ü mi profeta. ");
INSERT INTO mazNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","O sido o ña e Pedro o mama: ―Nu'tsc'eji ín menzumüts'ügöji a Israel, dyäräji na jo c'ü rá xi'tsc'öji. Rá xi'tsc'öji ja ga cja e Jesús c'ü mi menzumü a Nazaret. Mizhocjimi o unü poder e Jesús; nguec'ua va tsja c'o me na nojo a ndetsc'eji c'o nunca mi jandagueji. Nuc'o, ngue c'o rvi pãrãgueji c'ü vi 'ñeje e Jesús cja Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero i̱ dyötüji c'o dya ín menzumügöji o ndät'äji cja ngronsi c'ü, maco dya tjëji o̱ ley Mizhocjimi. Nguec'ua i̱ṉ pë's'i in s'ocügueji chjëntjui c'ü ri pö't'ügueji. Mizhocjimi ya mi pãrã c'o ri tsjapüji e Jesús. Na ngue ndeze mi jinguã o mama c'ü ro ẽjẽ e Jesús ro ẽ ndũ. Nguec'ua o jyëzi i̱ tsjaji a cjanu c'o na s'o. ");
INSERT INTO mazNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Zö o mbö't'üji e Jesús, pero Mizhocjimi o tsjapü o te, o bübütjo na yeje. Dya sö ro nguejme cja c'e cueva nu ja vi ngöt'üji. Na ngue me na zëzhi e Jesús que na ngue e muerte. ");
INSERT INTO mazNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mi jinguã o mama e David c'ü ja rvá te e Jesús. O mama: Rí pãrãgö Mizhocjimi bübü co nuzgö, dya jëzguigö. Nuc'ü, bübü cja ín jodyëgö pjöxcügö; dya ni jyodü pje rá sũgö. ");
INSERT INTO mazNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nguec'ua me mäjä ín mü'bü, y me rí unü 'na pöjö Mizhocjimi. Zö rá tũgö, pero rí pãrãgö c'ü rá tetjo. ");
INSERT INTO mazNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","'Ma rá tũgö, rí pãrãgö c'ü dya rí jyëzi ín aljmagö ra ma nu ja cãrã c'o 'ñaja aljma. Dya xo rí jyëzi ra dya'a ín cuerpogö. Na ngue in Ch'izügö. ");
INSERT INTO mazNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","I̱ jítscö ja rgá sö rá bübütjo co nu'tsc'e para siempre. Me rá mäcjö cja in jmigue, eñe e David. ");
INSERT INTO mazNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","O sido o ña e Pedro o mama: ―Nu'tsc'eji ín menzumüts'ügöji, ixtá xi'tsc'öji ja ga cja, c'ü dya ngue e David c'ü ro zädä texe yo jña. E David c'ü ín mboxatitagöji o ndũ, cjanu o dyögüji c'ua c'ü. Zö ya mezhe, pero rí texeji rí pãrãgöji ja dyögüji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","E David mi profeta mi mama c'o jña c'o o xipji Mizhocjimi ro mama. Mizhocjimi o mamatsjë na cjuana o xipji e David ja rva cja e Cristo c'ü o mama Mizhocjimi ra 'ñevgueji libre. O xipji c'ü ri mboxbëche e Cristo cja e David; 'ñe c'ü ro manda ja c'o nzi ma manda e David. ");
INSERT INTO mazNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ante c'ü ro ẽjẽ e Cristo, o mama e David c'ü ro tetjo e Cristo. O mama c'ü dya ro ma o̱ aljma nu ja cãrã c'o 'ñaja aljma; dya xo ro dya'a o̱ cuerpo. ");
INSERT INTO mazNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nutscöjme ró jandajme; nguec'ua rí xi'tsc'öjme Mizhocjimi o tsjapü o te e Jesús 'ma ya vi ndũ. ");
INSERT INTO mazNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Cjanu o zidyi a jens'e o unü c'ü o mimi cja o̱ jodyë Mizhocjimi nu ja mandavi dya. Nuc'ua Mizhocjimi o tsja ja c'o nzi va mama, o unü poder e Jesús o ndäjä o̱ Espíritu Mizhocjimi o ẽjẽ cja ne xoñijõmü. Ngueje o̱ Espíritu Mizhocjimi c'ü cja'a yo i̱ṉ jandagueji 'ñe yo i̱ṉ äräji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","O mama e David: Mizhocjimi o zopjü c'ín Jmugö o xipji: “Mimi cja ín jodyëgö. ");
INSERT INTO mazNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Rí da'c'ü rí mandague hasta 'ma cja rí chõpü yo nuc'ü na ü”, eñe e David. I̱ṉ pãrãgueji, dya zidyiji e David a jens'e cja o̱ jodyë Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Nu'tsc'eji ín menzumüts'ügöji a Israel, ixtí jñunt'ü in mün'c'eji ngueje e Jesús c'ü o 'ñeme Mizhocjimi. Ngueje e Jesús c'ü ra 'ñevgueji libre rá cjapüji ín Jmugöji. Maco i̱ dyörüji o ndät'äji cja ngronsi, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","C'o nte c'o mi cãrã nu, 'ma mü o dyäräji c'o jña, o zi'ch'i o̱ mü'büji, o unüji ngüenda c'ü vi tsjaji c'o na s'o. Cjanu o xipjiji e Pedro 'ñe c'o 'ñaja apóstole: ―Nu'tsc'eji ín menzumüts'ügöjme, ró cjagöjme c'o na s'o. ¿Pje rá cjagöjme dya? ");
INSERT INTO mazNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","O ndünrü c'ua e Pedro o xipjiji: ―C'ü rí tsjaji; jyëziji c'o na s'o, ra nzhogü in mü'büji cja Mizhocjimi. Y rí jigueji. A cjanu rí jizhigueji c'ü rí dyätäji dya e Jesucristo. Nu 'ma rí tsjaji a cjanu, ra perdonaots'üji 'ma Mizhocjimi. Xo ra dya'c'üji o̱ Espíritu ra bübü cja in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","O mama Mizhocjimi c'ü ín Jmugöji, c'ü ra dya'c'üji o̱ Espíritu 'ma ra nzhogü in mü'büji. Ra dya'c'üji, 'ñe c'o in ch'igueji. Xo ra unü o̱ Espíritu c'o nte c'o cãrã na jẽ. Ra unü o̱ Espíritu texe c'o ra tsjapü o̱ nte, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Xe na puncjü o jña c'o o mama e Pedro va zopjü c'o nte. Mi zopjüji co texe o̱ mü'bü mi xipjiji: ―Nu'tsc'eji i̱ṉ cãrãji yo cjë dya, na s'o i̱ṉ cjaji. Jyëziji c'o na s'o, ra nzhogü in mü'büji. Nguec'ua ra jogü in mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nu c'o o dyätpä o̱ jña e Pedro, o jiji. O zö como 'na jñi mil o nte c'o o 'ñench'e o̱ mü'bü e Jesucristo, o ndeñeji co c'o ya mi creo. ");
INSERT INTO mazNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sido mi äräji c'o jña c'o mi mama c'o apóstole. Me mi mäji ma ngãrãji. 'Natjo c'ua mi siji c'ü mi mbeñeji ja va ndũ e Jesús. Sido mi ötüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","O̱ Espíritu Mizhocjimi o unü poder c'o apóstole mi cjaji c'o me na nojo. Nguec'ua c'o nte o unüji ngüenda c'ü na cjuana c'o mi mama c'o apóstole. Y me mi sũji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nu c'o o 'ñench'e o̱ mü'bü e Jesucristo mi pötü ma s'iyaji. C'o pje mi pë's'i, dya mi ne ro jñütsjëji, mi pjös'üji c'o pje mi jyodü. ");
INSERT INTO mazNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","'Ma cjó pje mi jyodü, mi pa 'na cjuarma mi pa pö 'na juajma o 'na ngumü, o pje c'o mi pa pö. Cja rrũ unü c'ua c'o dya pje mi pë's'i. ");
INSERT INTO mazNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pama mi jmurüji cja c'e templo. Cja o̱ ngumüji mi pötü ma mbitaji mi siji o xëdyi ma mbeñeji ja va ndũ e Jesucristo. Y me mi mäji, dya pje mi mbeñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mi unüji na puncjü 'na pöjö Mizhocjimi. C'o nte, mi nuji na jo c'o mi creo e Jesucristo. Pama Mizhocjimi o jopcü o̱ mü'bü na puncjü o nte. Nguec'ua pama mi jmurüji mas c'o ya vi creo. ");
INSERT INTO mazNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","'Na nu pa e Pedro o mëvi e Juan cja c'e templo, o ma dyötüvi Mizhocjimi nu. Ya vi zünü jñi'i c'ü nzhä; mi ngue 'naja hora c'o mi pa ötüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","'Ma ya mi mëvi, ma tũji 'na bëzo c'ü dya mi sö ro nzhodü. Nuc'ü, je ma cjanu ndeze 'ma o jmus'ü. Nguec'ua pama mi pa emeji c'e bëzo cja 'na o̱ ngoxtji c'e templo, ngue c'ua ro dyötü o merio c'o mi cjogü nu. C'e ngoxtji nu ja mi emeji, ni chjũ Na Zö. ");
INSERT INTO mazNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","C'e bëzo o jñanda e Pedro 'ñe e Juan c'ü ya mi ngue ro cjogüvi cja c'e templo. Cjanu o dyötü o merio anguezevi. ");
INSERT INTO mazNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nuc'ua e Pedro o jñanda na jo c'e bëzo; xo 'ñe e Juan. O mama c'ua e Pedro o xipji: ―Jñandgagöbe, eñe. ");
INSERT INTO mazNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nuc'ua c'e bëzo o jñanda na jo anguezevi, mi te'be pje ro ch'unü. ");
INSERT INTO mazNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","O mama c'ua e Pedro o xipji: ―Dya rí jüngö pje rá da'c'ü; dya rí jüngö plata ni oro. Pero rí xi'tsc'ö ra mböxc'ü e Jesús c'ü mi menzumü a Nazaret. Nuc'ü, ngue c'ü o ndäjä Mizhocjimi ra 'ñevgueji libre. Nguec'ua rí böbügue rí nzhodü, embeji c'e bëzo c'ü dya mi sö ro nzhodü. ");
INSERT INTO mazNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nuc'ua e Pedro cjanu o pënchp'i c'ua o̱ jodyë c'e bëzo, cjanu o bö'bü. Ixco jogü c'ua o̱ ngua 'ñe o̱ bola, o zëzhi. ");
INSERT INTO mazNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nuc'ua ixco böbü c'ua o nzhodü. Cjanu o cjogü c'ua cja c'e templo co e Pedro 'ñe e Juan, mi nzhodü y mi dacü. Mi mama c'ü me na jo Mizhocjimi, mi unü 'na pöjö. ");
INSERT INTO mazNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","C'o nte c'o ma cã'ã cja c'e templo, o jñandaji mi nzhodü c'e bëzo 'ñe mi unü 'na pöjö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mi pãrãji ngueje c'e bëzo c'ü mi junrü cja o̱ ngoxtji c'e templo c'ü ni chjũ Na Zö, mi örü o merio. Me go zũji c'ua, dya mi parã pje ro nguijñiji. Na ngueje ya vi jogü c'e bëzo, ya mi nzhodü. ");
INSERT INTO mazNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Cja c'e templo, bübü 'na porta c'ü ni chjũ o̱ Portal e Salomón. Je mi bübü nu e Pedro 'ñe e Juan. C'e bëzo c'ü vi jogü o̱ ngua, sido mi dyoji co anguezevi. C'o nte o möji c'ua na niji nu ja mi bübü c'e bëzo 'ñe e Pedro 'ñe e Juan. Me mi sũji, na ngue vi jogü c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","E Pedro 'ma mü o jñanda ya vi mundo c'o nte, cjanu o xipjiji c'ua: ―Nu'tsc'eji ín menzumütsc'öji a Israel, ¿jenga me i̱ṉ sũji me i̱ṉ jandgagöbe? I̱ṉ pëzhgueji c'ü me na jozgöbe 'ñe me na zëzhi ín jñagöbe, nguec'ua rvá jocübe ne bëzo. Pero iyö. ");
INSERT INTO mazNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","C'ü o jocü, ngue o̱ T'i Mizhocjimi c'ü mi ma't'ü e Abraham 'ñe e Isaac 'ñe e Jacob c'o mi ngue ín mboxatitagöji. Nudya Mizhocjimi ya unü poder e Jesús c'ü o̱ T'i ngue c'ua ra manda. Nu'tsc'eji i̱ sidyiji e Jesús cja jmi e Pilato ngue c'ua ro jñünpüji ngüenda. Mi ne e Pilato ro 'ñeme libre e Jesús, pero dya i̱ ñegueji. ");
INSERT INTO mazNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Maco e Jesús dya tsja c'o na s'o, pero dya i̱ ñeji ro 'ñemeji libre c'ü. Maco ngue c'e bëzo c'ü mi pö't'üte c'ü i̱ dyötüji e Pilato o 'ñeme libre. ");
INSERT INTO mazNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","I̱ dyötüji e Pilato o mbö't'üji e Jesús, maco ngueje c'ü o ngambgagöji va c'ü o dyacüji c'ü rgá bübütjoji. O mbö't'üji e Jesús, pero Mizhocjimi o tsjapü o te'e o bübütjo na yeje. Nutscöjme ró jandajme; nguec'ua rí xi'tsc'öjme o te. ");
INSERT INTO mazNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ngue o̱ poder e Jesús c'ü o tsjapü o zëzhi o̱ ngua ne bëzo, na ngue o 'ñench'e o̱ mü'bü e Jesús, o creo c'ü ro jogü. Nujnu, i̱ṉ pãrãgueji c'ü dya mi sö ro nzhodü. Pero i̱ṉ jandaji ya jogü dya. O 'ñench'e o̱ mü'bü e Jesús; nguec'ua o jogü ja c'o nzi gui jñandaji, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","O sido o ña e Pedro o mama: ―Nu'tsc'eji ín menzumüts'ügöji, rí pãrãgö c'ü dya mi pãrãgueji cjo ngueje c'ü vi 'ñeme Mizhocjimi ra manda. Xo 'ñe c'o mböcjimi 'ñe c'o 'ñaja c'o pje pjëzhi, dya xo mi pãrãji. ");
INSERT INTO mazNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","O zädä ja c'o nzi va mama Mizhocjimi. Mi jinguã Mizhocjimi o 'ñünbü o̱ mü'bü texe c'o o̱ profeta o mamaji c'ü ro sufre nu c'ü vi 'ñeme Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ixtí unnc'eji ngüenda c'ü i̱ tsjaji c'o na s'o. Nzhogüji cja Mizhocjimi rí dyötüji ra perdonaots'üji. 'Ma rí tsjaji a cjanu, ra perdonaots'üji 'ma. Nuc'ua Mizhocjimi ra dya'c'üji me rí mäcjeji, dya pje rí mbeñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Xo ra ndäjä e Jesús ra ẽjẽ na yeje. Na ngue ngueje c'ü o 'ñeme Mizhocjimi ra manda. ");
INSERT INTO mazNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero sido ra bübü e Jesús a jens'e hasta 'ma cja ra zädä c'o o mama Mizhocjimi. Mizhocjimi o 'ñünbü o̱ mü'bü c'o o̱ profeta o mamaji ra zädä 'ma ra jogü texe, ja c'o nzi ma cja 'ma cja vi dyät'ä Mizhocjimi e jens'e 'ñe ne xoñijõmü. ");
INSERT INTO mazNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","O mama e Moisés: “Mizhocjimi c'ín Jmugöji o 'ñempquegö rí mamagö o̱ jña. Je xo rga cjatjonu, ra 'ñeme c'ü 'na c'o ín menzumügöji xo ra mama o̱ jña. Texe c'o ra xi'ts'iji c'ü, rí dyätäji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","'Ma cjó c'o dya ra dyätpä o̱ jña, ra pjongüji cja c'o o̱ nte, ra mbö't'üji.” Nuyo, ngue yo o mama e Moisés, eñe e Pedro va xipji c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","O sido o ña e Pedro o mama: ―E Samuel mi ngue c'e profeta c'ü ot'ü o mama yo ya zädä yo cjë dya. Xo mama a cjanu c'o 'ñaja profeta. ");
INSERT INTO mazNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mizhocjimi o xipji a cjava e Abraham: “Na ngue c'ü ra tsja c'ü in mboxbëchegue, rá intsjimigö yo nte yo cãrã texe cja ne xoñijõmü”, eñe Mizhocjimi va xipji e Abraham. C'o ín mboxatitagöji mi te'beji ro zädä c'ü vi mama Mizhocjimi. Nutscöji o̱ mboxbëchezüji anguezeji, nguezgöji ne ra intsjimizüji dya Mizhocjimi ja c'o nzi va xipji e Abraham, 'ñe ja c'o nzi va mama c'o profeta. ");
INSERT INTO mazNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mizhocjimi o 'ñeme e Jesús. Nutscöji rí menzumüji a Israel, nguetscöji ot'ü o ẽ zocüji, ngue c'ua rá jëziji c'o na s'o, ra nzhogü ín mü'büji cja Mizhocjimi. A cjanu ra intsjimizüji. Nguec'ua rí xi'tsc'öji ni jyodü rí dyätpäji dya o̱ jña e Jesucristo, ra nzhogü in mü'büji cja Mizhocjimi, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","'Ma mi ña e Pedro 'ñe e Juan ma zopjüvi c'o nte, o ẽjẽ c'ua c'o mböcjimi, 'ñe c'e comandante cja c'e templo, 'ñe c'o saduceo. ");
INSERT INTO mazNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Me mi sjëyaji na ngue e Pedro 'ñe e Juan mi jíchivi c'o nte, mi xipjiji c'ü vi te e Jesús nguec'ua ra zädä 'ma ra te'e texe yo ya ndũ. ");
INSERT INTO mazNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Cjanu o zidyiji c'ua e Pedro 'ñe e Juan o ma pant'aji a pjörü. Je ro dyovi nu hasta c'ü na ye nu pa, na ngue ya vi nzhä. ");
INSERT INTO mazNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Na puncjü c'o o dyärä 'ma mi ña e Pedro, o 'ñench'e o̱ mü'büji e Jesucristo. Nguec'ua o zö como 'na tsi'ch'a mil o bëzo c'o ya mi creo. ");
INSERT INTO mazNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nuc'ua c'ü na ye nu pa, o zojnüji c'ua c'o pje mi pjëzhi cja c'o menzumü a Israel, 'ñe c'o tita, 'ñe c'o mi xöpü o̱ ley Mizhocjimi, o jmurüji a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Xo mi bübü nu e Anás c'ü mi mero ndamböcjimi, 'ñe e Caifás, 'ñe e Juan 'ñe e Alejandro, 'ñe c'o 'ñaja o̱ dyoji e Anás 'ñe e Caifás. ");
INSERT INTO mazNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","O mandaji c'ua o ma siji e Pedro 'ñe e Juan. 'Ma mü o säjui, cjanu o xipjiji ro böbüvi a nde. Cjanu o dyönüji c'ua: ―¿Cjó dya'c'üvi poder i̱ jocüvi ne bëzo? ¿Cjó o̱ tjũ i̱ ñänbäguevi? ");
INSERT INTO mazNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nuc'ua o̱ Espíritu Mizhocjimi me go 'ñünbü o̱ mü'bü e Pedro o ndünrü: ―Nu'tsc'eji i̱ṉ mandaji cja yo nte, 'ñetsc'eji i̱ṉ titaji. ");
INSERT INTO mazNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ró cjagöbe c'o na jo, ró pjös'übe ne bëzo nu dya mi sö ro nzhodü. Maco nu'tsc'eji i̱ṉ cjacübe t'önü ja rvá jocügöbe nu. ");
INSERT INTO mazNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ixtí unnc'eji ngüenda i̱ṉ texeji, 'ñe texe yo ín menzumüji a Israel, ngueje e Jesús c'ü mi menzumü a Nazaret nu c'ü o jocü ne bëzo, nguec'ua böbü dya cja in jmigueji. E Jesús ngue e Cristo c'ü o mama Mizhocjimi ra 'ñevgueji libre. Nu'tsc'eji i̱ dyörüji o ndät'äji cja ngronsi. Pero 'ma ya vi ndũ, o tsjapü Mizhocjimi o te'e o bübütjo na yeje. ");
INSERT INTO mazNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","I̱ṉ pãrãji c'ü mama o̱ jña Mizhocjimi: “Nu c'e piedra c'ü dya go ne c'o mi jäbä o ngumü, ngue c'ü ot'ü ya jñumüji cja squina dya c'ü”, eñe c'e jña. Ya zädä c'e jña. Nu'tsc'eji, dya i̱ ñeji e Jesucristo. Pero Mizhocjimi ya 'ñeme ra manda. ");
INSERT INTO mazNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ojtjo xe 'naja c'ü ra jocüzü ín mü'büji c'o na s'o; nguextjo e Jesucristo. Dya cjó xe ra ndäjä Mizhocjimi ra ẽ salvazüji; nguextjo e Jesús, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","C'o mi jün ngüenda o nguijñiji c'ua: ―¿Ja ni 'ñeje c'ü ni ñavi a cjanu? Dya sũvi, dya xo tsejevi, mi eñeji. O mamaji a cjanu, na ngue mi pãrãji c'ü dya xötpüvi cja yo ley, y dya pje xo mi pjëzhivi. Cjanu o mbeñeji c'ua: ―Mi dyoji e Jesús; ngue c'ü o jíchi yo, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dya mi sö pje ro xipjiji e Pedro 'ñe e Juan. Na ngue o jñandaji mi böbü nu c'e bëzo c'ü ya vi jogü. ");
INSERT INTO mazNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nguec'ua o xipjiji e Pedro 'ñe e Juan ro mbedyevi a tji. 'Ma mü o mbedyevi a tji, nuc'ua cjanu o ñaji ja rvá tsjapüji. ");
INSERT INTO mazNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","O mamaji: ―¿Ja rga cjapüji? Texe yo cãrã va a Jerusalén ya pãrãji c'ü o tsjavi c'ü me na nojo, o jocüvi ne bëzo. Dya sö rá cädägöji. ");
INSERT INTO mazNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Para dya cja xe ra mbãrã yo ín menzumügöji a Israel, ni jyodü rá xipjiji yo ye bëzo pje c'o rá cjapüji 'ma sido ra nänmbävi o̱ tjũ e Jesús rgá zopjüvi yo nte. ");
INSERT INTO mazNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nuc'ua cjanu o ma't'üji e Pedro 'ñe e Juan. Anguezevi o cjogüvi c'ua na yeje nu ja mi jünji ngüenda. Nuc'ua c'o mi jün ngüenda, cjanu o xipjiji e Pedro 'ñe e Juan: ―Dya cja rí xipjivi yo nte ja ga cja e Jesús. 'Ma xe rí ñänmbävi o̱ tjũ, jo rí ñuvi 'ma, embeji e Pedro 'ñe e Juan. ");
INSERT INTO mazNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","O ndünrü c'ua e Pedro 'ñe e Juan o xipjiji: ―Tsjijñiji. ¿Cjo na jo a jmi Mizhocjimi ot'ü rá ä'tc'ägöbe que na ngue Mizhocjimi? ");
INSERT INTO mazNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","C'o ró jandabe 'ñe c'o ró äräbe, ni jyodü rá xipjibe yo nte c'o. ");
INSERT INTO mazNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nuc'ua c'o mi jün ngüenda o menasaoji na yeje e Pedro 'ñe e Juan, cjanu o 'ñemeji libre. Dya mi sö pje ro tsjapüji, na ngue mi sũji c'o nte. Na ngue c'o nte me mi ma't'üji Mizhocjimi mi mamaji c'ü me na nojo, na ngue vi jogü c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","C'e bëzo ya mi pë's'i mas de cuarenta cjë. ");
INSERT INTO mazNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","E Pedro 'ñe e Juan, 'ma mü o 'ñemeji libre, cjanu o mëvi c'ua nu ja ma cã c'o o̱ dyoji; o ma xipjiji texe c'o vi mama c'o ndamböcjimi 'ñe c'o tita c'o pje mi pjëzhi. ");
INSERT INTO mazNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","'Ma mü o dyäräji, me go ma't'üji c'ua Mizhocjimi texeji o mamaji: ―Mizhocjimi ín Jmuts'ügöjme, me na zë'ts'igue sö rí tsjague texe. Ngue'tsc'e i̱ dyät'ä e jens'e 'ñe ne xoñijõmü, 'ñe yo mar, 'ñe texe yo bübü 'ñe yo cja'a. ");
INSERT INTO mazNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","I̱ chäjä in Espíritu o ẽ 'ñünbü o̱ mü'bü e David c'ü mi ngue ín mboxatitagöjme c'ü mi pë'pc'igue. Nguec'ua o mama a cjava: C'o 'ñaja nte me üdü ga tsjaji o mbecuë. Yo nte yo ín menzumügöji me cjijñiji c'ü pje ra tsjaji, pero dya sö. ");
INSERT INTO mazNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yo rey cja ne xoñijõmü 'ñe c'o 'ñaja c'o pje pjëzhi o jmurüji, mi nuji na ü Mizhocjimi 'ñe c'ü vi 'ñeme Mizhocjimi ro manda, eñe in jñague c'ü o mama e David. ");
INSERT INTO mazNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","O sido o dyötüji Mizhocjimi o mamaji: ―Na cjuana o zädä ne jña nu o mama e David; o zädä cja ne ndajñiñi. Yo ín menzumügöjme va a Israel 'ñe c'o 'ñaja nte mi 'natjo o̱ pjeñeji va mamaji c'ü ro mbö't'üji e Jesús c'ü ngue in Ch'igue. Maco dya pje vi tsja. E rey Herodes 'ñe e gobernador Poncio Pilato o jyëzivi o mbö't'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nu c'ü o tsjaji, ngue c'ü ya vi mangue ro zädä. I̱ tsjapü o zädä. ");
INSERT INTO mazNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mizhocjimi ín Jmuts'ügöjme. C'o o jñünpü ngüenda yo ín cjuarmagöjme, o mamaji c'ü pje ra tsjacüjme 'ma sido rá zopjüjme yo nte. Nguec'ua rí ö'tc'öjme rí dyacöjme c'ü dya rá sũjme, sido rá mamajme in jñague. Na ngue in mbëpjizüjme. ");
INSERT INTO mazNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Xo rí ö'tc'öjme rí pjöxcüjme. Nguec'ua 'ma rá nänmbäjme o̱ tjũ e Jesús c'in Ch'igue c'ü me i̱ṉ mäpägue, nu'tsc'e rí jocü c'o sö'dyë y rí tsja c'o 'ñaja c'o me na nojo. Nguec'ua yo nte ra unüji ngüenda c'ü na cjuana c'ü rí xipjijme, eñeji va dyötüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","'Ma mü o nguarü o dyötüji Mizhocjimi, o mbi c'ua na zëzhi nu ja ma cãji. O̱ Espíritu Mizhocjimi me go 'ñünbü o̱ mü'büji texeji. Nguec'ua 'ma mü o xipjiji o̱ jña Mizhocjimi c'o nte, sido mi zopjüji, dya mi sũji. ");
INSERT INTO mazNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","C'o mi creo e Jesús, mi 'natjo o̱ mü'büji 'ñe o̱ pjeñeji; mi pötü ma s'iyaji. C'o pje mi pë's'i, dya cjó mama: “Ngue ín tsjacjö nu”, ro 'ñeñeji. Na ngue c'o mi pë's'iji mi cjapüji nde mi ngue o̱ cjaji. ");
INSERT INTO mazNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","C'o apóstole sido mi zopjüji c'o nte mi xipjiji c'ü vi te e Jesús. O ch'unüji ja va zopjüji; nguec'ua c'o jña o zi'ch'i o̱ mü'bü c'o nte. Mizhocjimi o mbös'ü texeji. ");
INSERT INTO mazNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","C'o mi creo e Jesús, dya cjó cja mi bëzhi. Na ngue 'ma cjó c'o pje mi jyodü, mi pa 'na cjuarma mi pa pö 'na juajma o 'na ngumü. ");
INSERT INTO mazNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Cja rrũ jün c'o merio ra ẽ unü c'o apóstole. Nuc'ua c'o apóstole ra unüji c'ua c'o pje mi jyodü. ");
INSERT INTO mazNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mi bübü 'na cjuarma c'ü mi chjũ e José c'ü mi mboxbëche cja e Leví. Nuc'ü, je mi menzumü a Chipre. C'o apóstole xo jñusp'üji Bernabé c'e cjuarma. C'e tjũ Bernabé ne ra mama: Nu c'ü cjacüji rá mäji. ");
INSERT INTO mazNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","C'e cjuarma o mbö 'na juajma, cjanu o jün c'o merio o unü c'o apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","C'ü 'naja cjuarma mi chjũ e Ananías. Mi chjũ e Safira c'ü nu su. O mbövi 'na juajma. ");
INSERT INTO mazNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Cjanu o ma c'ua e Ananías o ma unü c'o merio c'o apóstole. Dya unü texe, ndetjo c'o o unü. Pero o tsjapü c'ü vi unü texe. C'ü nu su, mi pãrã c'ü ro tsja a cjanu e Ananías c'ü dya ro unü texe. ");
INSERT INTO mazNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","'Ma mü o unüji c'o merio c'o apóstole, o mama e Pedro o xipji e Ananías: ―Nu'tsc'e Ananías, ¿jenga i̱ dyätägue e Satanás c'ü dya jo 'ma o 'ñünnc'ü in mü'bügue? C'o merio c'o o ngõ'tc'üji c'e juajma c'ü i̱ pöguevi, i̱ jñügue 'na parte pero i̱ tsjapü i̱ jñügue texe. Chjëntjui c'ü ri xique 'na bëchjine o̱ Espíritu Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'Ma dya be mi pöguevi c'e juajma, mi ngue in tsjacjevi; mi sö ri tsjapüvi ja c'o nzi mi ñeguevi. Nuc'ua 'ma vi pöguevi, mi sö ri gastovi c'o merio ja c'o nzi mi ñeguevi. Na ngue mi ngue in tsjacjevi. Nguec'ua, ¿jenga i̱ tsjijñivi in mü'büvi yo na s'o yo i̱ tsjaguevi? Mi cjapque nguextjozgöjme mi xitscöjme c'o dya cjuana. Pero ngue o̱ Espíritu Mizhocjimi c'ü i̱ xipjigue c'o, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nuc'ua e Ananías 'ma mü o dyärä yo jña yo, cjanu o nügü o ndũ. Texe c'o o dyärä c'o jña c'o vi xipjiji e Ananías, me go zũji c'ua. ");
INSERT INTO mazNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","O ẽjẽ c'ua ja nzi o sẽ o ẽ mböch'üji o manta c'e añima. Cjanu o ndunüji c'ua o ma dyögüji. ");
INSERT INTO mazNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","O mezhe c'ua jñi hora, o cjogü c'ua c'ü o̱ su e Ananías; dya mi pãrã cjo vi ndũ c'ü nu xĩra. ");
INSERT INTO mazNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","O mama c'ua e Pedro o xipji c'e ndixũ: ―Yo merio yo o jün e Ananías, ¿cjo nguextjo yo o ngõ'tc'üji c'e juajma c'ü i̱ pöguevi? O ndünrü c'ua c'e ndixũ: ―Jã, nguextjo yo. ");
INSERT INTO mazNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","O ndünrü c'ua e Pedro o xipji: ―¿Jenga i̱ ñaguevi c'ü nin xĩra i̱ tsjijñiguevi a cjanu yo na s'o? ¿Cjo i̱ pëzhguevi c'ü dya ro castigaots'üvi o̱ Espíritu Mizhocjimi? Rí ärägö ya va säjä nu c'o o ndunü c'ü nin xĩra o ma dyögüji. Xo ra ndunnc'üji in cuerpogue, embeji c'e ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ixco nügü c'ua c'e ndixũ cja o̱ ngua e Pedro, o ndũ. 'Ma mü o cjogü c'o sẽ, o jñandaji ya vi ndũ. O ndunüji c'ua c'e ndixũ o ma dyögüji 'na lado nu ja vi dyögüji c'ü nu xĩra. ");
INSERT INTO mazNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Me go zũ c'ua texe c'o mi creo e Jesucristo; 'ñe texe c'o o mbãrã ja va ndũ e Ananías 'ñe e Safira. ");
INSERT INTO mazNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mizhocjimi o unü o̱ poder c'o apóstole o tsjaji na puncjü c'o na nojo c'o nunca mi janda c'o nte. C'o cjuarma mi jmurüji cja c'e porta c'ü ni chjũ o̱ Portal e Salomón. ");
INSERT INTO mazNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","C'o dya mi creo, mi sũji ro ndeñeji c'o cjuarma. Pero c'o 'ñaja me mi mamaji c'ü me ma jonte c'o cjuarma. ");
INSERT INTO mazNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na puncjü o nte c'o xo 'ñench'e o̱ mü'bü e Jesucristo c'ín Jmugöji; o bëzo 'ñe o ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nguec'ua mi pjongüji c'o mi sö'dyë, mi cö's'üji o ngama 'ñe o pjinguã, mi pa cöbüji cja 'ñiji. Nguec'ua 'ma ro cjogü e Pedro, xa'ma ro ndöt'ü c'ü o̱ xõrü cja c'o mi sö'dyë ro jogüji. ");
INSERT INTO mazNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na puncjü o nte c'o vi 'ñeje cja c'o jñiñi c'o mi bëxtjo a Jerusalén, o siji c'o mi sö'dyë 'ñe c'o vi zürü o̱ s'ondajma c'ü dya jo. Nde go jogüji. ");
INSERT INTO mazNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","C'ü mi mero ndamböcjimi 'ñe c'o saduceo c'o mi dyoji, me mi sjëyaji. Na ngue na puncjü o nte c'o mi teñe c'o apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nguec'ua o zürüji c'o apóstole, cjanu o pant'aji a pjörü nu ja ma cãjã texe c'o mi cja na s'o. ");
INSERT INTO mazNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nuc'ua c'e xõmü, o ẽjẽ c'ua 'na o̱ anxe Mizhocjimi o ẽ xocü c'o ngoxtji cja c'e pjörü, o 'ñeme libre c'o apóstole. Cjanu o xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Möji cja ne templo, böbüji nu ja ra jñantc'aji yo nte. Nuc'ua rí xipjiji yo jña yo mama ja rgá sö ra salvaji ra bübüji co Mizhocjimi, embeji c'o. ");
INSERT INTO mazNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","O tsjaji ja c'o nzi va xipjiji. C'ü na jyas'ü o möji cja c'e templo o ma jíchiji c'o nte. C'ü mi mero ndamböcjimi 'ñe c'o mi dyoji o ẽji nu ja mi jünji ngüenda. Cjanu o zojnüji c'ua c'o pje mi pjëzhi cja c'o menzumü a Israel o jmurüji ngue c'ua ro jñünpüji ngüenda c'o apóstole. Cjanu o mandaji c'o mbëpji ro möji cja c'e pjörü ro ma siji c'o apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","'Ma mü o zät'ä c'o mbëpji cja c'e pjörü, dya cja chöt'üji c'o apóstole. Cjanu o nzhogüji o ẽ xipjiji: ");
INSERT INTO mazNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Ró ma tötc'öjme cjot'ütjo na jo c'o ngoxtji. Y c'o guardia cja c'e pjörü, böbüji pjörüji. Pero 'ma ró xocüjme c'o ngoxtji ró cjogüjme a mbo, dya cja ró töt'üjme c'o bëzo c'o ro ma sigöjme, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","C'ü mi mero ndamböcjimi 'ñe c'o 'ñaja ndamböcjimi 'ñe c'ü mi comandante cja c'e templo, 'ma mü o dyäräji yo jña, dya mi pãrã pje ro nguijñiji. O mamaji: ―Pãrã, ¿pje me ra tsja c'o bëzo c'o ró pant'aji a pjörü? ");
INSERT INTO mazNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nuc'ua o säjä c'ua 'naja c'ü o ẽ xipjiji: ―C'o bëzo c'o i̱ pant'aji a pjörü, böbüji cja ne templo jíchiji yo nte, embeji. ");
INSERT INTO mazNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nuc'ua c'e comandante 'ñe c'o mbëpji o möji cja c'e templo o ma siji c'o apóstole, pero dya pje tsjapüji. Na ngue mi sũji c'o nte, 'na ro pjat'üji o ndojo. ");
INSERT INTO mazNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","'Ma mü o siji c'o apóstole, o xipjiji ro böbüji a nde nu ja ro jñünpüji ngüenda. Nuc'ua c'ü mi mero ndamböcjimi cjanu o tsjapü t'önü c'o apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","O xipjiji: ―¿Jenga sido i̱ṉ jíchiji yo nte? Maco ró xi'tsc'öjme c'ü dya cja ri ñänbäji o̱ tjũ e Jesús. Nudya, texe va a Jerusalén pãrãji c'o i̱ṉ mamaji. I̱ṉ neji c'ü ra nguijñi yo nte c'ü ngue ín s'ocüjme o mbö't'üji e Jesús. ");
INSERT INTO mazNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","O ndünrü c'ua e Pedro 'ñe c'o 'ñaja apóstole o mamaji: ―Xenda ni jyodü rá ätcöjme Mizhocjimi que na ngue'tsc'eji rá ä'tc'öjme. Na ngue i̱ṉ ntetjogueji nza cjazgöjme. ");
INSERT INTO mazNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","I̱ dyörüji c'ü ro ndät'äji e Jesús cja ngronsi, nza cja 'ma ro tsja c'o na s'o. Nguec'ua i̱ṉ pë's'i in s'ocügueji chjëntjui c'ü ri pö't'ügueji c'ü. Pero Mizhocjimi c'ü mi ma't'ü c'o ín mboxatitagöji, o tsjapü o te. ");
INSERT INTO mazNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","O zidyi a jens'e e Jesús nu ja mimi dya cja o̱ jodyë. O unü c'ü ra tsja ín Jmugöji 'ñe c'ü ra salvazüji nutscöji rí menzumügöji a Israel. Nguec'ua 'ma cjó c'o ra nzhogü o̱ mü'bü, ra perdonao 'ma Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Rí xi'tsc'öjme yo, na ngue ró jandajme y ró äräjme. Xo 'ñe o̱ Espíritu Mizhocjimi jizhi c'ü na cjuana c'ü rí mamajme. Mizhocjimi unü o̱ Espíritu texe c'o ätpä o̱ jña, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","C'o mi jün ngüenda, 'ma mü o dyäräji c'o jña c'o mi mama e Pedro, me co üdüji c'ua na puncjü, mi ne ro mbö't'üji c'o apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Cja c'o mi jün ngüenda, mi bübü 'na fariseo c'ü mi chjũ e Gamaliel. Mi xöpü o̱ ley Mizhocjimi; me mi näntji cja c'o nte. E Gamaliel o böbü, o manda ro pjongüji a tji c'o apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Cjanu o ñatsjëji c'o 'ñaja c'o mi jün ngüenda o xipjiji: ―Nu'tsc'eji rí menzumügöji a Israel. Tsjijñiji na jo c'ü rí tsjapüji yo bëzo. ");
INSERT INTO mazNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mbeñegueji c'o pa 'ma mi bübü c'e bëzo c'ü mi chjũ e Teudas. Nuc'ü, mi cjapü mi manda. Na puncjü o bëzo c'o mi teñe angueze, mi sö 'na nziyo cientoji. Pero o mbö't'üji c'e bëzo, y o mböt'ü texe c'o mi dyoji. O bëzhi c'ü mi ne ro tsja. ");
INSERT INTO mazNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nuc'ua c'o pa 'ma mü o tsjaji o censo, na puncjü o nte c'o mi teñe e Judas c'ü mi menzumü a Galilea. Pero o ndũ, y c'o mi dyoji xo mböt'ü c'o. ");
INSERT INTO mazNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nguec'ua rí xi'tsc'öji, jyëziji yo bëzo, dya rí pö't'üji. Na ngue 'ma nguetsjë anguezeji cjijñiji c'o jña c'o mamaji, 'ñe 'ma ngue o̱ podertsjëji c'ü ni tsjaji yo me na nojo, dya ra mezhe ra chjorü 'ma. ");
INSERT INTO mazNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero 'ma ngueje Mizhocjimi c'ü unü o̱ poder yo bëzo, dya ra sö rí ts'a's'üji. 'Ma rí ts'a's'üji, chjëntjui c'ü i̱ṉ c'a's'üji Mizhocjimi, eñe e Gamaliel. ");
INSERT INTO mazNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","C'o 'ñaja cjanu o mamaji: ―Na jo ja c'o nzi vi mangue. Dya rá pö't'üjme, eñeji. Cjanu o xipjiji c'o apóstole ro cjogüji na yeje. O mbäräji c'ua, cjanu o xipjiji c'ü dya cja ro xipjiji o̱ jña e Jesús c'o nte. Cjanu o 'ñemeji libre. ");
INSERT INTO mazNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","C'o apóstole cjanu o mbedyeji, me mi mäji. O mamaji: ―Zö o bëchqui ín tseji va mbäräzüji, pero rí mäcjöji. Na ngue Mizhocjimi o dyacüji rí sufregöji por e Jesús, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Sido mi pöji cja c'e templo mi jíchiji c'o nte, mi mamaji e Jesús ngue c'ü o 'ñeme Mizhocjimi ra manda. Xo mi xöpüji cja o̱ ngumü c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pama mi creo na puncjü o nte e Jesucristo. Nuc'ua 'ma ya ma puncjü c'o mi creo, c'o cjuarma c'o mi ña griego o reclamaoji o mamaji: ―Yo ndixũ yo ín dyocjöjme yo ya ndũ o̱ xĩra, dya nda ch'unüji pje ra ziji. Xenda ch'unü yo ndixũ yo ña hebreo, embeji c'o apóstole. ");
INSERT INTO mazNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nuc'ua c'o apóstole o ñaji cjanu o zojnüji texe c'o mi ätpä o̱ jña Mizhocjimi. 'Ma mü o jmurüji, cjanu o xipjiji c'ua: ―Nutscöjme rí xipjijme o̱ jña Mizhocjimi yo nte. Dya ra jogü rá jëzijme ne bëpji para rá nu'ujme cjo pë's'i pje ra zi texe yo cjuarma. ");
INSERT INTO mazNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nguec'ua rí xi'tsc'öjme cjuarma, rí juajnügueji siete cjuarma, rá unüji c'e bëpji ra unüji c'ü ra zi c'o cjuarma c'o pje ni jyodü. Rí juajnüji c'o me näntji cjaji na jo, 'ñe ätäji o̱ Espíritu Mizhocjimi, 'ñe pë's'iji na jo o̱ pjeñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nutscöjme rí apóstolejme sido rá ötcöjme Mizhocjimi, y sido rá xipjijme o̱ jña Mizhocjimi yo nte, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Texe c'o mi cãrã nu, o nguejmeji conforme c'o jña c'o vi mama c'o apóstole. Cjanu o juajnüji c'ua e Esteban c'ü mi creo co texe o̱ mü'bü, y mi ätä o̱ Espíritu Mizhocjimi. Xo juajnüji e Felipe 'ñe e Prócoro 'ñe e Nicanor 'ñe e Timón 'ñe e Parmenas 'ñe e Nicolás. E Nicolás mi menzumü a Antioquía, pero ante c'ü ro creo e Jesucristo, mi creo Mizhocjimi ja c'o nzi ga creo yo menzumü a Israel. ");
INSERT INTO mazNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","'Ma mü o nguarü o juajnüji c'o siete cjuarma, o xipjiji ro böbüji cja o̱ jmi c'o apóstole. Nuc'ua c'o apóstole cjanu o 'ñe's'e o̱ dyëji va dyötpüji Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nuc'ua mas mi mamaji o̱ jña Mizhocjimi. Nguec'ua me na puncjü o nte a Jerusalén c'o o 'ñench'e o̱ mü'bü e Jesucristo. Na puncjü o mböcjimi c'o xo dyätpä o̱ jña Mizhocjimi xo 'ñench'e o̱ mü'büji e Jesucristo. ");
INSERT INTO mazNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mizhocjimi o mbös'ü e Esteban 'ñe o unü poder. Nguec'ua o tsja c'o me na nojo c'o nunca mi janda c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mi bübü 'na nintsjimi c'ü mi chjũ o̱ Nintsjimi c'o nte c'o ya 'ñemeji libre. C'o mi pa nu, mi bübü ja nzi anguezeji c'o o zöji o jña e Esteban. Mi menzumüji a ma a Cirene 'ñe a ma a Alejandria 'ñe a ma a Cilicia 'ñe a ma cja c'e país a Asia. ");
INSERT INTO mazNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","O̱ Espíritu Mizhocjimi o mbös'ü e Esteban o unü o pjeñe ja rvá ñaji c'o. Nguec'ua anguezeji, dya cja sö pje ro mamaji. ");
INSERT INTO mazNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nuc'ua cjanu o dyü't'üji c'ua ja nzi o bëzo. Nguec'ua ja c'o nde mi mamaji: ―Ró äräjme e Esteban o zadü e Moisés 'ñe Mizhocjimi, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nguec'ua c'o tita c'o mi manda, 'ñe c'o mi xöpü o̱ ley Mizhocjimi, 'ñe c'o 'ñaja nte, me co üdüji c'ua na puncjü. Nuc'ua c'o nte c'o vi zöji o jña e Esteban, ixco cjuan'diji go möji nu ja mi bübü e Esteban o ma pënch'iji. Cjanu o zidyiji nu ja ro jñünpüji ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Cjanu o 'ñemeji c'ua o testigo c'o ro mama o bëchjine. O mamaji a cjava: ―Ne bëzo nu, sido sadü ne templo nu me na sjũ. Xo sadü o̱ ley Mizhocjimi c'ü o dyopjü e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ró äräjme o mama c'ü ra ẽjẽ e Jesús c'ü mi menzumü a Nazaret ra ẽ yä't'ä ne templo. Ra xitsiji nan'ño rga cjaji c'o dya nza cja c'o o mama e Moisés, eñe c'o mi mama o bëchjine. ");
INSERT INTO mazNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","O̱ jmi e Esteban me mi juëns'i nza cja o̱ jmi 'na o̱ anxe Mizhocjimi. Nguec'ua texe c'o mi jün ngüenda, me go jñandbaji o̱ jmi c'ü mi juëns'i. ");
INSERT INTO mazNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nuc'ua c'ü mi mero ndamböcjimi o dyönü e Esteban o mama: ―¿Cjo na cjuana c'ü mama yo? ");
INSERT INTO mazNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","O ndünrü c'ua e Esteban o xipji c'o mi jün ngüenda 'ñe c'o 'ñaja nte: ―Nu'tsc'eji ín menzumütsc'öji, dyäräji c'ü rá xi'tsc'öji. Mizhocjimi a jens'e o zopjü e Abraham c'ín mboxatitagöji 'ma mi bübü a Mesopotamia. Dya be mi pa a Harán. ");
INSERT INTO mazNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","O xipji: “Pedyegue cja in jñiñi rí sogü yo in dyocjeji, rí mague nu ja rá jí'tsc'ö”, embeji e Abraham. ");
INSERT INTO mazNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","O mbedye c'ua e Abraham a Caldea c'ü tsja a Mesopotamia, o ma mimi a Harán. 'Ma mü o ndũ c'ü nu tata e Abraham, Mizhocjimi o xipji e Abraham o ẽjẽ nu va ja rí cãrãji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dya ch'unü e Abraham ne ri 'na juajma c'ü ro tsjapü o̱ cjaja. Pero o mama Mizhocjimi c'ü ro zädä 'ma ro unü e Abraham texe ne país ro tsjapü o̱ cjaja. Xo mama c'ü ro tsjapü o̱ cjaja c'o o̱ mboxbëche c'o ro tsãjã. Zö dya mi 'ñeje e Abraham o̱ t'i, pero Mizhocjimi o mama a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xo mama Mizhocjimi: “C'o in mboxbëchegue ra ma mimiji cja c'ü 'na país. Ra mezhe cuatro ciento cjë, nuc'ua c'o menzumü nu, ra tsjapüji me ra sufre c'o in mboxbëche, ra tsjapüji ra mbëpiji anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero rá castigao c'e nación c'ü ra mbëpiji. Nuc'ua ra mbedye libre c'o in mboxbëchegue, ra ẽji a 'ñeva ra ẽ matcügöji”, eñe Mizhocjimi va xipji e Abraham. ");
INSERT INTO mazNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","O sido o ña e Esteban o mama: ―Mizhocjimi o xipji e Abraham ro circuncidaoji c'ü o̱ t'i 'ñe c'o o̱ bëche. Ngue c'ü rví mbeñeji c'ü vi mama Mizhocjimi ro unü anguezeji. 'Ma mü o jmusp'ü 'na t'i e Abraham, o jñusp'ü o̱ tjũ e Isaac. Nuc'ua cjanu o circuncidao 'ma o zö chjün. Je xo va cjanu e Isaac o circuncidao c'ü o̱ t'i c'ü mi ngue e Jacob. Y e Jacob o circuncidao c'o doce o̱ t'i c'o mi ngue ín mboxatitagöji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’C'o once ín mboxatitagöji me mi sjëyaji na ngue c'ü o̱ tataji xenda mi s'iya e José que na ngue anguezeji. Nguec'ua o mböji e José, o mböpüji c'o mi pa a Egipto o zidyiji nu e José. Pero Mizhocjimi mi bübü co e José, o 'ñeme libre nu ja mi sufre. ");
INSERT INTO mazNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","O unü na puncjü o̱ pjeñe; nguec'ua e Faraón c'ü mi rey a Egipto me go ne'e e José, o 'ñeme o tsja gobernador texe a Egipto. Xo unü o manda texe cja c'o o̱ mbëpji e Faraón c'o mi cãrã cja o̱ palacio. ");
INSERT INTO mazNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’O ẽjẽ c'ua 'na tjijmi texe a Egipto, 'ñe texe a 'ñeva nu ja mi xiji Canaán c'o pa c'o. Me mi sufre c'o nte. C'o ín mboxatitagöji mi ojtjo pje ro ziji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nuc'ua e Jacob o dyärä mi pöji o ndëxü a Egipto. Nguec'ua o ndäjä c'o o̱ t'i c'o mi ngue ín mboxatitagöji o möji a Egipto. ");
INSERT INTO mazNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nuc'ua 'ma mü o möji na yeje a Egipto, e José o xipjitsjë anguezeji: “Nutscö nguetscö e José in cjuarmazüji”, eñe. Nuc'ua e José cjanu o jíchi anguezeji a jmi e Faraón. Nguec'ua va mbãrã e Faraón anguezeji mi ngue o̱ cjuarma e José. ");
INSERT INTO mazNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nuc'ua e José o mbenpe 'na jña e Jacob c'ü mi ngue o̱ tata, o xipji ro möji a Egipto texe c'o o̱ t'i 'ñe c'o o̱ bëche. Mi söji como 'na setenta y cincoji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","16","O möji c'ua. Nujnu, je nguejnu o ma ndũ e Jacob. Nuc'ua o tũji o̱ cuerpo a 'ñe a Siquem, o ẽ ngöt'üji cja c'e cueva c'ü vi ndõmü e Abraham. Vi ngõ't'ü ja nzi merio de plata c'o o̱ t'i e Hamor c'o mi menzumü a Siquem c'o mi ngue o̱ cjaja c'e cueva. Je xo ngue a Egipto o ndũ c'o o̱ t'i e Jacob c'o mi ngue ín mboxatitagöji. Xo tũji c'o o̱ cuerpoji a 'ñe a Siquem, xo ngöt'üji cja c'e cueva. ");
INSERT INTO mazNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’'Ma ya mi ngue ro zädä c'o vi xipji Mizhocjimi e Abraham, me co ngãrã na puncjü c'o ín mboxatitagöji c'o mi cãrã a Egipto. Me ma puncjüji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nuc'ua o mimi c'ua rey 'na bëzo a Egipto c'ü dya mi pãrã c'o vi tsja e José. ");
INSERT INTO mazNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","C'e rey o tsjapüji na s'o c'o ín mboxatitagöji, mi xipjiji ra ma mbëziji c'o o̱ ts'it'iji 'ma cja mi mus'ütjoji. A cjanu, dya nda rvá puncjüji 'ma. ");
INSERT INTO mazNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","C'o pa c'o, o jmus'ü e Moisés c'ü me ma zö a jmi Mizhocjimi. O mezhe jñi zana, c'ü o̱ tata 'ñe c'ü o̱ nana o mbörüvi e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nuc'ua cjanu o pjongüvi c'ua cja o̱ ngumüvi. Nuc'ua c'ü o̱ xunt'i c'e rey a Egipto o chöt'ü, o mbörü nza cja 'ma ri ngue o̱ t'i. ");
INSERT INTO mazNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","O jíchiji e Moisés texe c'o mi pãrã c'o mi menzumü a Egipto. Nguec'ua mi pjëchi ra ña'a na jo, y mi pjëchi ja rvá tsja na jo 'na bëpji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’'Ma ya mi ëdyi cuarenta cjë e Moisés, o nguijñi o̱ mü'bü na jo ro ma nu'u pje mi cja c'o ín menzumüji a Israel c'o mi esclavo a Egipto. Na ngue mi ngue o̱ dyoji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","O jñanda c'ua 'na c'o mi menzumü a Egipto mi pärä 'na c'o mi menzumü a Israel. Nuc'ua e Moisés cjanu o ma ñana c'ü mi menzumü a Israel, o mbö't'ü c'ü mi menzumü a Egipto na ngue mi pärä c'e Israelita. ");
INSERT INTO mazNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","O nguijñi e Moisés: “Yo ín menzumügöjme ra unüji ngüenda c'ü o 'ñempquegö Mizhocjimi rá emeji libre”, eñe. Je ga cjanu va nguijñi e Moisés c'ü ro unü ngüenda c'o ín mboxatitagöji. Pero dya unüji ngüenda. ");
INSERT INTO mazNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","C'ü na ye nu pa, e Moisés o jñanda mi chũ yeje c'o ín mboxatitaji. E Moisés mi jo'tp'üvi o xipjivi: “Nu'tsc'evi, ¿jenga i̱ṉ pötqui chũguevi? Maco in dyocjevi”, eñe e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nuc'ua c'ü mi jonbü o chũ c'ü 'na o̱ dyoji, o ndütüji e Moisés cjanu o xipji c'ua: “Nu'tsc'e, ¿pje pë'sc'ü rí ñu co nuzgöbe? Dya cjó 'ñempc'e rí tsja juesi rí mandazübe. ");
INSERT INTO mazNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Cjo i̱ṉ ne rí pötcügö ja c'o nzi vi pö't'ügue c'e Egipcio a ndä'ä?”, embeji e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nuc'ua e Moisés 'ma mü o dyärä c'o mi mama c'e bëzo, o unü c'ua ngüenda c'ü ya mi pãrãji c'ü vi tsja. Nguec'ua o c'ueñe o ma c'ua a ma a Madián nu ja dya cjó mi pãrã. Je chjüntü nu. C'ü nu su o musp'ü yeje o̱ t'i. ");
INSERT INTO mazNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’O mezhe c'ua cuarenta cjë, e Moisés mi bübü cja 'na majyadü; mi bëxtjo cja 'na t'eje c'ü ni chjũ a Sinaí. O jñetse c'ua 'na o̱ anxe Mizhocjimi cja 'na zarza c'ü mi tjë. ");
INSERT INTO mazNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","E Moisés 'ma o jñanda, me co nguijñi, dya mi pãrã pje mi pjëzhi. 'Ma mü o chëzhi ro nu'u, o dyärä c'ua o ña Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","O xipji e Moisés: “Nutscö o̱ Mizhocjimizügö e Abraham 'ñe e Isaac 'ñe e Jacob c'o mi ngue in mboxatitague”, eñe Mizhocjimi. Me go mbi c'ua e Moisés, dya cja rezga xe ro nu'u. ");
INSERT INTO mazNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","O mama c'ua Mizhocjimi: “Ts'o't'ü c'o i̱ṉ tin'ch'i. Na ngue me na sjũ nu ja i̱ṉ böbü. ");
INSERT INTO mazNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","C'o in menzumügue ngue ín ntegö c'o. Rí janda me cjapüji ra sufreji a Egipto. Xo rí ärä me quejaji. Nguec'ua rvá ẽgö a jens'e rá emeji libre. Nudya rí xi'tsc'ö rí mague a ma a Egipto. A cjanu rá emeji libre”, embeji e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","O sido o ña e Esteban o mama: ―Mizhocjimi o ndäjä e Moisés o nzhogü a ma a Egipto. Maco c'o ín mboxatitagöji vi xipjiji: “Nu'tsc'e, ¿pje pë'sc'ü rí ñu co nuzgöjme? Dya cjó 'ñempc'e rí tsja juesi rí mandazüjme”, embeji c'ü. Mizhocjimi o unü e Moisés mi manda cja c'o ín mboxatitagöji o 'ñemeji libre. C'e anxe c'ü vi jñetse cja c'e bidyi o mbös'ü e Moisés. ");
INSERT INTO mazNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","E Moisés o tsja o señal c'o me na nojo a Egipto, 'ñe cja c'e ndeje c'ü ni chjũ Mar Rojo. Nguec'ua va pjongü libre a Egipto c'o ín mboxatitagöji. C'o cuarenta cjë c'o mi cãrãji cja c'e majyadü, e Moisés mi manda anguezeji y mi cja c'o me ma nojo. ");
INSERT INTO mazNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","E Moisés o xipji c'o nu menzumüji a Israel c'o mi ngue ín mboxatitaji: “Mizhocjimi ra 'ñeme 'na c'o ín menzumügöji ra mama o̱ jña, ja c'o nzi va 'ñempquegö”, eñe. ");
INSERT INTO mazNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","E Moisés mi bübü cja c'e majyadü co c'o ín mboxatitaji c'o vi juajnü Mizhocjimi. Mi cãrãji cja o̱ ngua c'e t'eje c'ü ni chjũ a Sinaí. 'Na o̱ anxe Mizhocjimi o zopjü e Moisés o xipji c'o o̱ mandamiento Mizhocjimi c'o ro dyätä c'o nte. Nuc'ua e Moisés o xipji c'o ín mboxatitagöji. 'Ma ro dyätäji c'o ley, ro bübütjoji co Mizhocjimi para siempre. ");
INSERT INTO mazNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero c'o ín mboxatitaji, dya go ne go dyätäji e Moisés. Dya neji ro manda e Moisés anguezeji. Me mi mbeñeji a Egipto nu ja vi mbedyeji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nguec'ua 'ma mü o mezhe e Moisés a xes'e cja c'e t'eje, c'o ín mboxatitagöji o xipjiji e Aarón: “Rí dyätcäjme 'na ts'ita c'ü ri nza cja 'na ts'inzhünü c'ü rá ma'tc'öjme, c'ü ra zinzijme na jo cja 'ñiji. Na ngue e Moisés c'ü o pjongüzüjme a Egipto, dya rí pãrãgöjme pje tsja”, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nguec'ua cjanu o dyät'äji c'ü mi nza cja 'na ts'inzhünü. Cjanu o mbö't'üji o animale c'o o mbäsp'äji a jmi. Me go mäpäji c'e ts'inzhünü, maco vi dyät'ätjoji co o̱ dyëtsjëji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nguec'ua Mizhocjimi o jyëzi anguezeji. Nguec'ua anguezeji o mbürü o ma't'üji e jyarü 'ñe e zana 'ñe yo seje. Nguec'ua va dyopjü a cjava c'o profeta: Nu'tsc'eji i̱ṉ menzumüji a Israel, 'ma mi cãrãji c'o cuarenta cjë cja majyadü, 'ma mi pö't'ügueji o animale cja rrĩ pä's'äji, ¿cjo nguetscö mi matcügöji? Iyö. ");
INSERT INTO mazNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","C'ü mi ma't'ügueji, ngue e Moloc 'ñe e Renfán. I̱ dyät'äji c'e ts'ingumü nu ja mi tägä e ts'ita Moloc. Xo i̱ dyät'äji e ts'ita Renfán c'ü mi nza cja 'na seje. Nuc'o, mi tunügueji ja c'o mi pöcjeji. Nguec'ua rá pjongüts'üji rí pjöt'ügueji a Babilonia a manu, eñe c'o profeta. ");
INSERT INTO mazNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","O sido o ña e Esteban o mama: ―Mizhocjimi o xipji e Moisés ro dyät'ä 'na ngumü de xipjadü nu ja ro bübü Mizhocjimi a nde cja c'o ín mboxatitaji cja c'e majyadü. O mama: “Rí dyät'ä c'ü ri nza cja c'ü ya ró jí'ts'i i̱ jñanda”, embe. ");
INSERT INTO mazNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","'Ma mü o ndũ e Moisés, e Josué o tsja xo'ñi mi manda cja c'o o̱ t'i c'o ín mboxatitaji c'o vi mbedye a Egipto. 'Ma mü o säji cja ne país, ya mi cãrã c'o 'ñaja nte. Pero Mizhocjimi o pjongü c'o. Nguec'ua c'o ín mboxatitagöji o tsjapüji o̱ cjaji ne país. 'Ma mü o säji, ma tũji c'e ngumü de xipjadü. Mi bübü c'e ngumü de xipjadü hasta c'o pa 'ma mi rey e David. ");
INSERT INTO mazNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Mizhocjimi me mi ne e David. Nguec'ua e David o dyötü sjëtsi Mizhocjimi ro dyä'tp'ä 'na ngumü. Na ngue e Jacob c'ü nu mboxpale xo mi ma't'ü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ngue o̱ t'i e David c'ü mi chjũ e Salomón c'ü o dyä'tp'ä 'na templo Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero Mizhocjimi dya ni jyodü o templo nu ja ra mimi. Na ngue yo templo rí ä'tc'öji co ín dyëji. Dyäräji c'ü o mama 'na o̱ profeta Mizhocjimi: ");
INSERT INTO mazNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","E jens'e ngue nu ja rí bübü rí manda. Ne xoñijõmü ngue nu ja rí e'me ín cua. Nguec'ua dya sö rá mimigö cja 'na templo c'ü rí dyät'äji. ¿Ja rgá sö rá mimigö nu? ");
INSERT INTO mazNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Maco ró ät'ägö texe yo bübü 'ñe texe yo cja'a, eñe Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","O sido o ña e Esteban o xipji c'o mi jün ngüenda: ―Nu'tsc'eji, dya i̱ṉ ne rí dyäräji. Ya meze in mü'büji, ya tsot'ü in tsõji. Zö 'ñünnc'ü in mü'büji o̱ Espíritu Mizhocjimi, pero i̱ṉ cjaji ja c'o nzi gui ñetsjëji. I̱ṉ chjëntcjeji nza cja c'o ín mboxatitagöji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Anguezeji o mbö't'üji texe c'o profeta. Mi mama c'o profeta c'ü ro ẽjẽ 'naja c'ü me na jo a jmi Mizhocjimi. Pero c'o ín mboxatitaji o mbö't'üji c'o. Nu c'ü o ẽjẽ, i̱ sidyiji cja c'o pje pjëzhi o mbö't'üji; chjëntjui c'ü ri pö't'ügueji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","C'o o̱ anxe Mizhocjimi o ẽ unüji e Moisés c'ü o̱ ley Mizhocjimi. I̱ṉ tjëgueji c'e ley, pero dya i̱ṉ ätäji, eñe e Esteban. ");
INSERT INTO mazNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","C'o mi jün ngüenda, 'ma mü o dyärä yo jña yo vi mama e Esteban, me go üdüji me mi nguünxt'ü a zibiji. ");
INSERT INTO mazNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero e Esteban dya go zũ; o̱ Espíritu Mizhocjimi sido mi 'ñünbü o̱ mü'bü. O nä's'ä a jens'e o jñanda nu ja bübü Mizhocjimi me mi juëns'i. Xo jñanda e Jesús mi böbü cja o̱ jodyë Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Cjanu o mama: ―Dyäräji. Rí jandagö ya xogü a jens'e. Rí janda nu vi 'ñeje cja Mizhocjimi, böbü cja o̱ jodyë Mizhocjimi, eñe. ");
INSERT INTO mazNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Anguezeji o ngo't'ü o ngõji co o̱ dyëji, o mapjüji c'ua na jens'e va ma pënch'iji e Esteban. ");
INSERT INTO mazNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Cjanu o pjongüji cja c'e ndajñiñi, cjanu o pjat'üji c'ua o ndojo. Ngue c'o testigo c'o vi xosp'ü o bëchjine e Esteban c'o ot'ü o pjat'ü o ndojo. Ante c'ü ro pjat'üji c'ü, o ts'o's'üji c'o mabitu c'o mi jeji, cjanu o unüji 'na sẽ c'ü mi chjũ e Saulo ro mbörü c'o. ");
INSERT INTO mazNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","'Ma mi pjat'üji o ndojo e Esteban, o dyötü c'ua Mizhocjimi o mama: ―Jesús ín Jmuts'ügö, sinngui dya ín aljma, eñe. ");
INSERT INTO mazNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Cjanu o ndüñijõmü o mapjü na jens'e o mama: ―Nu'tsc'e ín Jmuts'ügö, na s'o yo na cjacöji. Pero rí ö'tc'ügö rí perdonaogueji yo. Nuc'ua 'ma mü o nguarü o mama a cjanu, cjanu o ndũ c'ua. ");
INSERT INTO mazNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","E Saulo me mi mäjä na ngue vi mbö't'üji e Esteban. C'e pa c'ü, o mbürü o tsjapüji o sufre c'o mi creo e Jesucristo c'o mi cãrã a Jerusalén. Nguec'ua o mböt'üji o möji cja na puncjü o jñiñi a Judea 'ñe a Samaria. Nguextjo c'o apóstole c'o dya c'ueñe; o nguejmetjoji a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","'Ma mü o ndũ e Esteban, mi bübü c'o mi sũ Mizhocjimi o ma dyögüji me mi huëpiji. ");
INSERT INTO mazNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","E Saulo me mi nu'u na ü c'o mi creo e Jesús. O cjogü cja c'o ngumü nu ja mi cãrã c'o cjuarma, o pjongüji cjanu o ma pant'aji a pjörü, zö mi bëzo zö mi ndixũ. ");
INSERT INTO mazNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","C'o cjuarma c'o vi mbedye a Jerusalén, mi mamaji o̱ jña e Jesucristo texe nu ja c'o mi sät'äji, mi xipjiji c'o 'ñaja nte. ");
INSERT INTO mazNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","E Felipe o ma a Samaria o ma xipjiji: ―C'ü o mama Mizhocjimi ra ẽ 'ñevguegöji libre, ya ẽjẽ. Ngueje e Jesús, eñe. ");
INSERT INTO mazNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na puncjü o nte c'o o dyärä c'o jña c'o o mama e Felipe. Xo jñandaji c'o me na nojo c'o o tsja. Nguec'ua na puncjü c'o o creo o̱ jña e Jesucristo. ");
INSERT INTO mazNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na puncjü o nte c'o vi zürü o̱ s'ondajma e Satanás c'ü dya jo. E Felipe mi xipji c'o s'ondajma ro mbedye; mi pedye c'ua c'o s'ondajma mi mapjüji na jens'e. Mi cãrã na puncjü a Samaria c'o dya mi sö ro 'ñõmü. Xo na puncjü c'o mi me'dye. O jogü c'o. ");
INSERT INTO mazNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nguec'ua me mi mäji cja c'e jñiñi. ");
INSERT INTO mazNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","A Samaria mi bübü 'na bëzo c'ü mi chjũ e Simón. Ante c'ü ro ma nu e Felipe, mi sëro e Simón mi cja c'o me na nojo c'o nunca mi janda c'o nte. Mi cjapü me ma nojo. ");
INSERT INTO mazNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Texe c'o mi cãrã nu, me mi ätpäji o̱ jña, ndeze c'o dya pje mi pjëzhi hasta c'o mi pjëzhi na nojo. Mi mamaji: ―Nujnu ngue nu vi 'ñeje cja Mizhocjimi nu mero na zëzhi, mi eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","C'o nte me mi ätpäji o̱ jña e Simón. Na ngue ya vi mezhe mi cja c'o me na nojo c'o nunca mi jandaji. ");
INSERT INTO mazNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero 'ma mü o zät'ä a Samaria e Felipe, o xipjiji c'o nte: ―Rí xi'tsc'öji 'na jña c'ü rgui mäcjeji. E Jesucristo ngue c'ü o 'ñeme Mizhocjimi ra manda. Ngue c'ü rí dyätäji, embeji. Nguec'ua na puncjü o bëzo 'ñe o ndixũ c'o o dyätpä o̱ jña, cjanu o jiji. ");
INSERT INTO mazNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Xo 'ñe e Simón o creo. Nuc'ua 'ma ya vi ji'i, mi teñe e Felipe. O jñanda mi cja e Felipe o señal c'o me na nojo. Nguec'ua dya mi pãrã e Simón pje ro nguijñi, na ngue nunca mi janda a cjanu. ");
INSERT INTO mazNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","C'o apóstole c'o mi cãrã a Jerusalén, o dyäräji c'ü ya mi ätpäji o̱ jña Mizhocjimi a Samaria. Nguec'ua o ndäji e Pedro 'ñe e Juan o mëvi a Samaria. ");
INSERT INTO mazNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","O mëvi ngue c'ua ro dyötpüvi Mizhocjimi c'o mi creo, ngue c'ua ro ch'unüji o̱ Espíritu Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Na ngue dya be mi jizhi o̱ Espíritu Mizhocjimi cjo mi ngue o̱ nte Mizhocjimi c'o mi menzumü a Samaria. Ya vi jiji, pero nguextjo o̱ tjũ e Jesús c'ín Jmugöji c'ü o nänbäji 'ma o jichiji. ");
INSERT INTO mazNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nuc'ua e Pedro 'ñe e Juan o 'ñe's'e o̱ dyëvi c'o mi creo. O ẽ c'ua o̱ Espíritu Mizhocjimi o ẽ bübü cja o̱ mü'büji. ");
INSERT INTO mazNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","E Simón o jñanda e Pedro 'ñe e Juan o 'ñe's'e o̱ dyëvi c'o cjuarma. O jñanda ja ma cja 'ma o ẽjẽ o̱ Espíritu Mizhocjimi. Nguec'ua o xipji e Pedro 'ñe e Juan: ―Dyacövi ne poder rá cjõ'tc'üvi o merio. Nguec'ua 'ma cjó c'o rá ẽ's'ẽ ín dyëgö, ra ẽjẽ o̱ Espíritu Mizhocjimi ra ẽ bübü o̱ mü'büji, eñe. ");
INSERT INTO mazNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","O ndünrü c'ua e Pedro o xipji: ―Ra ma a linfiernu in meriogue. Xo 'ñetsc'e, 'ma dya ra nzhogü in mü'bü. Na ngue i̱ṉ pëzhgue ri chõmü c'ü unü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Dya rí pë's'igue parte cja o̱ jña e Jesucristo, na ngue dya jo in mü'bü a jmi Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Jyëzi nu na s'o nu i̱ṉ cjijñi, rí dyötü Mizhocjimi. Xa'ma ra perdonaots'ü. ");
INSERT INTO mazNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Rí unnc'ö ngüenda c'ü me na s'o in mü'bügue. Xe i̱ṉ bübütjo cja o̱ dyë e Satanás c'ü dya jo c'ü dya ne ra jyëtsc'i, eñe e Pedro va xipji e Simón. ");
INSERT INTO mazNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","O ndünrü c'ua e Simón o mama: ―Dyötcügö Mizhocjimi ngue c'ua dya rá sufregö yo i̱ xitsi, embeji e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","E Pedro 'ñe e Juan o xipjivi o̱ jña Mizhocjimi c'o nte, o mamavi c'o vi jñandavi 'ñe c'o vi dyärävi. Nuc'ua cjanu o mbedyevi nu, ro mëvi a Jerusalén. 'Ma mü o cjogüvi na puncjü o jñiñi c'o tsja a Samaria, o xipjivi o̱ jña e Jesucristo c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","O ẽjẽ 'na o̱ anxe Mizhocjimi nu ja mi bübü e Felipe, o ẽ xipji: ―Ixtí mague a ma a sur, rí chëpi c'e 'ñiji c'ü pedye a Jerusalén c'ü ni ma a Gaza, embe. C'e 'ñiji cjogü cja 'na majyadü. ");
INSERT INTO mazNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ixco ma c'ua e Felipe. Cja c'e 'ñiji mi pa 'na bëzo c'ü mi menzumü a Etiopía. Mi tägä cja 'na carro c'ü mi cjüt'ü o pjadü. Mi pjëzhi na nojo, mi pjötpü texe c'o mi pë's'i e Candace c'ü mi reina a Etiopía. C'e bëzo ya vi 'ñeje a Jerusalén nu ja vi ma ma't'ü Mizhocjimi. 'Ma mü o jñanda e Felipe c'e bëzo, ya ma nzhogü ro ma cja o̱ país a Etiopía. Mi xörü o̱ jña Mizhocjimi c'ü vi dyopjü e Isaías c'ü mi profeta. ");
INSERT INTO mazNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nuc'ua o̱ Espíritu Mizhocjimi o xipji e Felipe: ―Chëzhi cja ne carro. ");
INSERT INTO mazNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","'Ma mü o chëzhi e Felipe, o dyärä mi xörü c'e bëzo c'o vi dyopjü e Isaías. O mama c'ua e Felipe o dyönü: ―¿Cjo i̱ṉ pãrãgue pje ne ra mama yo i̱ṉ xörügue? ");
INSERT INTO mazNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","O ndünrü c'ua c'e bëzo o mama: ―¿Ja rgá sö rá pãrãgö, 'ma dya cjó ra jítsigö? Ches'e rá min'hui, embe. ");
INSERT INTO mazNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","C'ü o̱ jña Mizhocjimi c'ü mi xörü, je mi t'opjü nu c'ü mama a cjava: Ra zidyiji c'e nte ja c'o nzi ga zidyiji o ndënchjürü, ra mbö't'üji. Ja c'o nzi ga cja o ndënchjürü 'ma ãxãji, dya nzama o̱ neji; je xo rga cjatjonu c'e nte 'ma ra tsjapüji c'o na s'o, dya pje ra mama. ");
INSERT INTO mazNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ra tsjapüji burla c'e nte ra jñünpüji ngüenda ra tsjapüji ra sufre, zö dya pje vi tsja. ¿Ja rgá sö ra 'ñeje o̱ t'i cja ne xoñijõmü? Na ngue ra mbö't'üji c'ü, eñe o̱ jña Mizhocjimi c'ü o dyopjü e Isaías. ");
INSERT INTO mazNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","O mama c'ua c'e bëzo o xipji e Felipe: ―Tsjacü favor rí xitsi cjó ngue c'ü ra sufre a cjanu. ¿Cjo ngueje c'e profeta c'ü o dyopjü ne jña, o ngue c'ü nan'ño?, eñe. ");
INSERT INTO mazNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nuc'ua e Felipe o xipji c'e bëzo pje mi ne ro mama c'e jña c'ü mi xörü, o xipji ja va mbö't'üji e Jesús; o xipji ngueje e Jesús c'ü ra salvazüji. ");
INSERT INTO mazNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ya mi cjogüvi nu ja mi po'o o ndeje. O mama c'ua c'e bëzo: ―Po'o va o ndeje. ¿Cjo ra sö rá jigö? ");
INSERT INTO mazNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","O ndünrü c'ua e Felipe o xipji: ―Jenga jiyö. Sö, 'ma i̱ṉ creo co texe in mü'bü. O ndünrü c'ua c'e bëzo: ―Rí creogö e Jesucristo ngue o̱ T'i Mizhocjimi, eñe c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Cjanu o manda o bö'büji c'e carro. Nuc'ua e Felipe 'ñe c'e bëzo o dagüvi cja c'e carro, cjanu o dat'üvi cja c'e ndeje. O tsja c'ua e Felipe o jichi c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cjanu o mbes'evi cja c'e ndeje. Nuc'ua o̱ Espíritu Mizhocjimi 'nango zidyi e Felipe. Nguec'ua c'e bëzo dya cja jñanda. Pero sido mi pa cja c'e 'ñiji, me mi mäjä. ");
INSERT INTO mazNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nuc'ua e Felipe mi bübü a Azoto. O mbedye a Azoto mi sät'ä nzi 'na jñiñi mi xipji c'o nte ja ga cja e Jesucristo, hasta o zät'ä a Cesarea. ");
INSERT INTO mazNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","E Saulo me mi nu'u na ü c'o mi ench'e o̱ mü'bü e Jesucristo c'ín Jmugöji, sido mi mama: ―Rá pö't'ügö texe c'o, eñe. Nguec'ua o ma c'ua cja c'ü mi mero ndamböcjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","O ma xipji: ―Rí ö'tc'ügö rí dyopjügue o carta c'o rá tjëdyi a ma a Damasco, rá jizhi cja c'o nintsjimi. Rí jñu's'ü c'ü ya i̱ dyacügö sjëtsi nguec'ua 'ma cjó c'o rá töt'ügö a Damasco c'o sido o̱ 'ñiji e Jesús, rá tjün't'ü co cadena rá siji a 'ñeva a Jerusalén, zö ri bëzo zö ri ndixũ, eñe e Saulo. O tsja c'ua c'e ndamböcjimi ja c'o nzi va xipji e Saulo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","O ma c'ua e Saulo. 'Ma ya mi ngue ro zät'ä a Damasco, 'nango ẽjẽ c'ua a jens'e 'na jya's'ü c'ü me mi juëns'i c'ü o pjat'ü nu ja ma ẽjẽ e Saulo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Cjanu o ndögü c'ua e Saulo c'ü mi chägä, cjanu o dyärä c'ü mi mama a cjava: ―Nu'tsc'e Saulo, ¿jenga i̱ṉ cjapü ra sufre yo creozgö? Chjëntjui c'ü ri nguetscö c'ü ri cjacö rá sufre. ");
INSERT INTO mazNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","O ndünrü c'ua e Saulo o mama: ―¿Cjó ngue'tsc'e, nu'tsc'e nin t'ecjañõmü? O ndünrü c'ua c'ü ín Jmugöji o xipji e Saulo: ―Nguetscö e Jesús. I̱ṉ cjapü ra sufre yo creozgö. I̱ṉ chjëntjui nza cja 'na nzhünü c'ü dya ne ra dyärä, c'ü me pjech'e c'e maza c'ü ni chjocüji, nguec'ua ga s'odü. Je xo ga cjatsc'e nu, 'ma dya rí dyätcägö ín jña, mas ra s'odü in mü'bü. ");
INSERT INTO mazNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Me go zũ c'ua e Saulo me go mbi, cjanu o mama: ―Nu'tsc'e ín Jmuts'ügö, ¿pje i̱ṉ ne rá cjagö? O ndünrü c'ua e Jesús c'ín Jmugöji: ―Ixtí mague dya, rí sät'ä cja c'e ndajñiñi a Damasco; nujnu, ra xi'ts'iji c'ü rí tsja, embeji e Saulo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","C'o bëzo c'o mi pöji e Saulo, me go pizhiji, dya mi sö ro ñaji. O dyäräji c'ü mi ña pero dya jñandaji. ");
INSERT INTO mazNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nuc'ua e Saulo o nanga nu ja mi 'mana. Nuc'ua 'ma mü o xocü o̱ ndö, dya cja mi janda. Nguec'ua o pënchp'iji o̱ dyë, cjanu o ngüjnüji o zidyiji a ma a Damasco. ");
INSERT INTO mazNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","'Ma mi bübü a Damasco, o zö jñi pa c'ü dya mi janda. Dya zi o jñõnü, ne ri ndeje. ");
INSERT INTO mazNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A Damasco mi bübü 'na bëzo c'ü mi chjũ e Ananías, mi ench'e o̱ mü'bü e Jesucristo. Mizhocjimi o zopjü a t'ĩjĩ e Ananías o xipji: ―Nu'tsc'e Ananías. O ndünrü c'ua e Ananías: ―Mizhocjimi ín Jmuts'ügö, xitsigö pje i̱ṉ ne rá cjagö. ");
INSERT INTO mazNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","O mama c'ua Mizhocjimi o xipji: ―Ixtí mague cja c'e calle c'ü ni chjũ Derecho. 'Ma rí sät'ä cja o̱ ngumü e Judas, rí tsja t'önü cjo bübü nu 'na bëzo c'ü ni chjũ e Saulo c'ü o jmus'ü a Tarso. Nudya na ötcügö. ");
INSERT INTO mazNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ró unügö o nguinch'i 'na t'ĩjĩ o jñantc'a nu'tsc'e Ananías, i̱ tsjogü cja c 'e ngumü nu ja bübü, cja ni 'ñe's'e in dyëgue. Nguec'ua o jogü o̱ ndö, o sö o jñanda na yeje. Je ga cjanu ró unügö o nguinch'i e Saulo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","O ndünrü c 'ua e Ananías o mama: ―Mizhocjimi ín Jmuts'ügö, na puncjü o cjuarma c'o o xitsi ja ga cja e Saulo. O tsjapü me go sufre c'o in ntegue c'o cãrã a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nudya, cja säjä va, tjë 'na carta c'ü o dyopjü c'o ndamböcjimi. C'ü mama c'e carta, e Saulo pë's'i sjëtsi ra zücüjme rí texejme nutscöjme rí ma'tc'öjme, ra pantcajme a pjörü. ");
INSERT INTO mazNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","O ndünrü c'ua Mizhocjimi o xipji e Ananías: ―Mague. Ya ró juajnügö e Saulo ra zopjü c'o in menzumügueji a Israel 'ñe c'o dya menzumü a Israel, 'ñe c'o o̱ reyji. Nguec'ua ra mbãcãji ja ga cjazgö. ");
INSERT INTO mazNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Rá xipji e Saulo c'ü ra sufre na puncjü, na ngue ra xipji ín jñagö yo nte, eñe Mizhocjimi va xipji e Ananías. ");
INSERT INTO mazNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","O ma c'ua e Ananías o zät'ä cja c'e ngumü nu ja mi bübü e Saulo. O cjogü a mbo, cjanu o 'ñe's'e c'ua o̱ dyë e Saulo, cjanu o xipji: ―Nu'tsc'e Saulo, mi cjuarmats'ügö. E Jesús c'ín Jmugöji o jñetse, i̱ jñanda 'ma ma ẽcje cja 'ñiji. O ndäcjö ró ẽjẽ, ngue c'ua ra jogü in chö rí jñanda na yeje, 'ñe ngue c'ua ra ẽjẽ o̱ Espíritu Mizhocjimi ra ẽ bübü in mü'bü, eñe e Ananías. ");
INSERT INTO mazNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ixco ndögü c'ua cja o̱ ndö e Saulo c'o mi nza cja o ts'ixisquë. Nuc'ua ya jñanda c'ua na jo. Nuc'ua cjanu o ji'i; ngue e Ananías o jichi. ");
INSERT INTO mazNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Cjanu o zi o xëdyi; nguec'ua o zëzhi. Nuc'ua e Saulo, o mimiji ja nzi pa a Damasco co c'o mi ench'e o̱ mü'bü e Jesucristo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nuc'ua mi pa cja c'o nintsjimi mi pa zopjü c'o nte, mi xipjiji e Jesús ngue o̱ T'i Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","C'o o dyärä mi ña e Saulo, me mi cjijñi mi mamaji: ―Nujnu ngue nu mi cjapü me ra sufre c'o creo e Jesús c'o cãrã a Jerusalén. C'ü vi 'ñeje a 'ñeva ngue c'ü ro zürü yo creo, ro ndün't'üji co cadena cja rrũ zidyiji cja c 'o ndamböcjimi. Maco nudya, ya xipji o̱ jña e Jesús yo nte, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pama Mizhocjimi xenda mi pjös'ü e Saulo ja ma zopjü c'o o̱ menzumüji a Israel c'o mi cãrã a Damasco. O mbenbeji c'o vi dyopjü c'o profeta ja rva cja c'ü vi 'ñeme Mizhocjimi ro manda. A cjanu o jizhi c'ü ngueje e Jesús c'ü vi 'ñeme Mizhocjimi. Nguec'ua anguezeji, dya sö pje ro mamaji. ");
INSERT INTO mazNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","O mezhe c'ua, c'o mi menzumü a Israel c'o mi cãrã a Damasco o ñatsjëji o mamaji ja rvá mbö't'üji e Saulo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","O mbãrã e Saulo c'ü mi ne ro mbö't'üji. Xõmü ndempa mi pjörüji cja o̱ ngoxtji c'e jñiñi, ngue c'ua 'ma ro mbedye e Saulo, ro mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","'Na nu xõmü, c'o mi ejme e Jesucristo, o mbös'üji e Saulo o mbedye libre cja c'e jñiñi. O xipjiji e Saulo o dyo'o cja 'na bos'i. Cjanu o sjö'büji cja c'e varda c'ü mi c'ot'ü cja c'e jñiñi. ");
INSERT INTO mazNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","'Ma mü o zät'ä e Saulo a Jerusalén, mi ne ro ndeñe c'o mi cãrã nu c'o mi creo e Jesucristo. Pero texeji mi sũji e Saulo, dya mi creoji c'ü ya mi ätpä o̱ jña e Jesucristo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","'Na cjuarma c'ü mi chjũ e Bernabé o recibido e Saulo. Cjanu o zidyi cja c'o apóstole o xipjiji: ―'Ma mi pa cja 'ñiji e Saulo, o jñetse c'ín Jmugöji; e Saulo o jñanda. C'ín Jmugöji o zopjü nu. Y 'ma mi bübü a Damasco, o xipji c'o nte ja ga cja e Jesús, dya zũ, eñe e Bernabé. ");
INSERT INTO mazNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nguec'ua o recibidoji c'ua e Saulo texe ja c'o mi jmurü c'o cjuarma a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mi zopjü c'o nte mi xipjiji ja ga cja e Jesús c'ín Jmugöji, y dya mi sũ. 'Ma mi zopjü c'o o̱ menzumüji a Israel c'o mi ña griego, me mi söji o jña. Anguezeji o ñatsjëji o mamaji ja rvá mbö't'üji c'ü. ");
INSERT INTO mazNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","'Ma mü o mbãrã c'o cjuarma, o möji e Saulo a ma a Cesarea. Cjanu o xipjiji: ―Ra sö rí sät'ägue na jo dya a Tarso, embeji e Saulo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nuc'ua c'o cjuarma c'o mi cãrã cja c'e estado de Judea, dya cja mi nuji na ü c'o, dya cja pje mi cjapüji. Xo 'ñe c'o mi cãrã cja c'e estado de Galilea 'ñe cja c'e estado de Samaria. Y xenda mi pãrãji ja ga cja e Jesucristo. Mi sũji Mizhocjimi mi ätäji. O̱ Espíritu Mizhocjimi mi pjös'ü anguezeji. Nguec'ua xe na puncjü c'o o creo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","E Pedro mi pa texe nu ja mi cãrã o cjuarma. 'Na nu pa, o ma a Lida o ma zengua c'o mi ench'e o̱ mü'bü e Jesucristo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mi bübü nu 'na bëzo c'ü mi chjũ e Eneas. Ya vi mezhe ocho cjë ma o'o cja ngama, dya mi sö ro 'ñõmü. E Pedro o jñanda c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Cjanu o xipji: ―Eneas, e Jesucristo ra jocüts'ü. Rí ñanga rí xã'ma in nzama, embe. Nuc'ua cjanu o nanga c'ua. ");
INSERT INTO mazNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","C'o mi cãrã a Lida 'ñe c'o mi cãrã a Sarón, o jñandaji ya vi jogü c'e bëzo. O jyëziji c'ua c'o mi creoji, o creoji e Jesucristo. ");
INSERT INTO mazNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Cja c'e jñiñi a Jope, mi bübü 'na ndixũ c'ü mi chjũ e Tabita c'ü mi ench'e o̱ mü'bü e Jesucristo. Cja c'e idioma griego mi chjũ e Dorcas. C'e ndixũ mi unü o merio c'o dya pje mi pë's'i; me ma jonte mi pjös'ü texe c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","C'o pa c'o, o zürü 'na ngueme o ndũ. O xatüji o̱ cuerpo, cjanu o ngöbüji cja 'na jyäxcumü. ");
INSERT INTO mazNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","A Jope mi bëxtjo a Lida. C'o cjuarma a Jope o dyäräji e Pedro mi bübü a Lida. Nguec'ua o ndäji ye cjuarma c'o o ma xipji e Pedro: ―Rvá ẽ ö'tc'öbe favor ixtá mö a Jope, eñevi. ");
INSERT INTO mazNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nuc'ua e Pedro o möji c'ua anguezevi. 'Ma mü o zät'äji, cjanu o zidyiji e Pedro cja c'e jyäxcumü. Ma cã nu na puncjü o ndixũ c'o ya vi ndũ nu xĩra. O ma böbüji cja o̱ jmi e Pedro, me mi huëpiji e Dorcas. O jíchiji e Pedro c'o pajna 'ñe c'o 'ñaja bitu c'o vi ndä'bä e Dorcas 'ma xe mi bübü. ");
INSERT INTO mazNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","E Pedro o xipji texe c'o ndixũ ro mbedyeji. Nuc'ua cjanu o ndüñijõmü o dyötü Mizhocjimi. Cjanu o jñanda c'e ndixũ c'ü vi ndũ, o xipji: ―Nu'tsc'e Tabita, ñanga. Nuc'ua c'e ndixũ o xocü c'ua o̱ ndö o jñanda e Pedro. Cjanu o nanga o mimi c'ua. ");
INSERT INTO mazNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nuc'ua e Pedro o pënchp'i o̱ dyë c'e ndixũ o bö'bü. Cjanu o ma't'ü c'ua c'o ndixũ 'ñe c'o 'ñaja c'o o̱ nte Mizhocjimi, o jíchiji c'ü ya vi te e Tabita ya mi bübütjo na yeje. ");
INSERT INTO mazNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Texe c'o mi cãrã a Jope o dyäräji e Pedro vi tsjapü o te c'e ndixũ. Nguec'ua na puncjü c'o o 'ñench'e o̱ mü'bü e Jesucristo c'ín Jmugöji. ");
INSERT INTO mazNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nuc'ua e Pedro o mezhe na puncjü o pa va mimi a Jope. Mi oxü cja o̱ ngumü 'na bëzo c'ü xo mi chjũ e Simón c'ü mi corti o̱ xipjadü o animale. ");
INSERT INTO mazNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","A Cesarea mi bübü 'na bëzo c'ü mi chjũ e Cornelio. Mi manda cja 'na cien o tropa c'o mi xiji Tropa Italiana. ");
INSERT INTO mazNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Zö dya mi menzumü a Israel e Cornelio, pero mi sũ 'ñe mi ma't'ü Mizhocjimi. Xo 'ñe texe c'o mi cãrã o̱ ngumü. Mi unü o merio c'o dya pje mi pë's'i. Pama mi ötü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","'Na nu pa 'ma ya vi zünü jñi c'ü nzhä, Mizhocjimi o unü e Cornelio o jñanda 'na anxe, nza cja 'ma ro nguinch'i 'na t'ĩjĩ. O cjogü nu ja mi bübü o xipji: ―Nu'tsc'e Cornelio, eñe c'e anxe. ");
INSERT INTO mazNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Me go zũ e Cornelio me go jñanda c'e anxe. Cjanu o xipji: ―¿Pje pjëzhi, nu'tsc'e nin t'ecjañõmü? O ndünrü c'ua c'e anxe o mama: ―Rvá ẽ xi'ts'igö Mizhocjimi mä'c'ägue. Na ngue i̱ṉ ötügue c'ü, 'ñe i̱ṉ unü o merio yo dya pje pë's'i. ");
INSERT INTO mazNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nudya rí chäjä o bëzo c'o ra ma a Jope ra ma siji 'na bëzo c'ü ni chjũ e Simón Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nuc'ü, je oxü cja o̱ ngumü 'na bëzo c'ü xo ni chjũ e Simón c'ü corti o̱ xipjadü o animale. C'e ngumü järä a squina cja nezapjü. Ra xi'ts'i e Simón Pedro pje ni jyodü rí tsjague, eñe c'e anxe va xipji e Cornelio. ");
INSERT INTO mazNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","O ma c'ua c'e anxe c'ü mi ñavi e Cornelio. Nuc'ua e Cornelio o ma't'ü c'ua yeje c'o o̱ mbëpji, ' ñeje 'na c'o tropa c'ü mi teñe angueze, c'ü xo mi sũ Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","O xipjiji texe c'o vi mama c'e anxe, cjanu o ndäji c'ua o möji a Jope. ");
INSERT INTO mazNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","C'ü na ye nu pa 'ma ya vi zünü jñisiarü, mi pöji cja 'ñiji ya mi ngue ro zät'äji a Jope. E Pedro o ndes'e a xes'e cja sotea cja c'e ngumü nu ja mi oxü, o dyötü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nuc'ua cjanu o zant'a, mi ne o xëdyi. 'Ma ma ät'äji o jñõnü, mi sö e Pedro nza cja c'ü dya cja mi bübü cja c'e sotea, mi sö nza cja 'ma ro nguinch'i 'na t'ĩjĩ. ");
INSERT INTO mazNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","O jñanda ya vi xogü a jens'e. Cjanu o jñanda nza cja 'na manta c'ü me na nojo c'ü vi 'ñeje a jens'e o säjä a jõmü. O jñetse nza cja c'ü cjó c'o mi pënch'i nza nziyo squina. ");
INSERT INTO mazNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Cja c'e manta mi cã'ã o c'ijmi 'ñe o s'ü, 'ñe c'o pje nde ma animale c'o bübü nziyo o̱ ngua. ");
INSERT INTO mazNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nuc'ua e Pedro o dyärä 'na jña c'ü vi 'ñeje a jens'e c'ü o mama: ―Nu'tsc'e Pedro, böbü rí pö't'ügue 'na yo animale rí sa. ");
INSERT INTO mazNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","O ndünrü c'ua e Pedro o mama: ―Iyö, ín Jmuts'ügö, dya ra sö. Nunca rí sagö o ts'ingue c'o na s'o c'o mama in leygue c'ü dya rá sagöjme, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","O ndünrü c'ua c'ü mi zopjü e Pedro, o mama: ―Dya rí mangue na s'o nu c'ü ya ró tjintscö, eñe Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jñi vez va xipjiji a cjanu e Pedro. Y jñi vez va ndünrü a cjanu. Nuc'ua c'e manta cjanu o nguins'i c'ua a jens'e nu ja vi 'ñeje. ");
INSERT INTO mazNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","E Pedro me mi cjijñi o̱ mü'bü pje mi ne ro mama c'o vi jñanda. Jo nu säjä c'ua cja c'e ngoxtji c'o bëzo c'o vi 'ñeje cja e Cornelio. Na ngue ya vi tsjaji t'önü ja mi bübü o̱ ngumü e Simón. ");
INSERT INTO mazNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","O zenguateji c'ua, cjanu o tsjaji t'önü cjo mi bübü nu 'na bëzo c'ü mi chjũ e Simón Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","'Ma mi cjijñi e Pedro pje mi ne ro mama c'o vi jñanda, o ña c'ua o̱ Espíritu Mizhocjimi o xipji: ―Cja säjä jñi bëzo c'o va ẽ jonc'ü. ");
INSERT INTO mazNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dyagü cja ne sotea rí möji co anguezeji. Dya rí yembeñe; nutscö ró täcjö o ẽjẽ c'o, embeji e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","O dagü c'ua e Pedro nu ja c'o ma böbü c'o bëzo c'o vi 'ñeje cja e Cornelio, cjanu o xipjiji: ―Nguetscö i̱ṉ jongüji. ¿Pje vi 'ñecjeji?, embeji. ");
INSERT INTO mazNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Anguezeji o mamaji: ―O ndäcjöjme 'na bëzo c'ü ni chjũ e Cornelio c'ü manda o tropa. Nuc'ü, sũ Mizhocjimi y cja ja c'o nzi ga ne Mizhocjimi c'o na jo. Texe yo in menzumügueji a Israel mamaji c'ü cja na jo c'e bëzo. Mizhocjimi o ndäjä 'na o̱ anxe o ma zopjü e Cornelio. O xipji c'ü ro ndäcjöjme rá ẽ sints'ijme rá mö o̱ ngumü, ngue c'ua rí zopjügue. Angueze ra dyärä c'o rí xipjigue, eñe c'o bëzo va xipjiji e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nuc'ua e Pedro o xipji c'o bëzo o cjogüji cja c'e ngumü o ziji o xëdyi. Y o oxüji. Nuc'ua c'ü na jyas'ü, e Pedro o möji c'o bëzo. Xo möji ja nzi c'o cjuarma c'o mi cãrã a Jope. ");
INSERT INTO mazNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","C'ü na jñi nu pa, o zät'äji a Cesarea. E Cornelio ya ma te'be anguezeji; ya vi mbita c'o o̱ dyoji 'ñe c'o mi pãrãji. Nuc'o, ya ma cãji nu. ");
INSERT INTO mazNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","'Ma mü o zät'ä e Pedro 'ñe c'o mi pöji cja o̱ ngumü e Cornelio, o mbedye c'ua e Cornelio o recibido e Pedro. O ndüñijõmü cja o̱ jmi, nza cja 'ma ro ma't'ü Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nuc'ua e Pedro o pënchp'i o̱ dyë o bö'bü. O xipji: ―Böbü. Dya pje pjëtscö, xo rí ntetjogö nza cjatsc'e. ");
INSERT INTO mazNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","O cjogüvi c'ua mi ñavi. E Pedro o jñanda ya vi jmurü na puncjü o nte. ");
INSERT INTO mazNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Cjanu o xipjiji: ―I̱ṉ pãrãgueji nutscöjme rí menzumüjme a Israel, dya sö rá dyocjöji nu'tsc'eji dya i̱ṉ menzumüji a Israel, ni rá cjogüjme cja in nzungueji rá ñaji. 'Ma jiyö, 'na ra pëgazüjme c'o na s'o. Pero o jítscö Mizhocjimi c'ü dya cja rá mangö cjó na s'o. ");
INSERT INTO mazNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nguec'ua 'ma mü o ma xitsi yo bëzo ro ẽcjöjme yo, dya ró mangö: “Iyö”, ro 'ñeñe. Nu'tsc'e Cornelio, xitscö pje vi chäjä o ma sizgö yo, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","O mama c'ua e Cornelio: ―Ya sö nziyo pa, mi ötügö Mizhocjimi y mi mbempje. Ya vi zünü jñi c'ü nzhä. O ẽ c'ua 'na bëzo o ẽ böbü ín jmigö. Mi je'e o bitu c'o me mi juëns'i. ");
INSERT INTO mazNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","O xitsi: “Nu'tsc'e Cornelio, Mizhocjimi o dyä'tc'ä c'o i̱ṉ ötü. Angueze pãrã c'ü i̱ṉ cja, i̱ṉ unü o merio yo dya pje pë's'i”, enze. ");
INSERT INTO mazNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Xo xitsi: “Rí chäjä o bëzo c'o ra ma a Jope ra ma siji 'na bëzo c'ü ni chjũ e Simón Pedro. Nuc'ü, je oxü cja o̱ ngumü 'na bëzo c'ü xo ni chjũ e Simón, c'ü corti o̱ xipjadü o animale. C'e ngumü järä a squina cja nezapjü”, enzgö c'e bëzo c'ü ró janda. ");
INSERT INTO mazNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nguec'ua ixtó täjä yo o ma sits'i. Pöcjü i̱ 'ñeje. Rí cãrãjme a jmi Mizhocjimi rí texejme, rí ne rá äräjme c'o o jí'ts'i rí xitscöjme. ");
INSERT INTO mazNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nuc'ua e Pedro o zopjü c'o nte o xipjiji: ―Dyäräji na jo. Nudya, rí pãrãgö Mizhocjimi dya juajnü cjó ra s'iya; ix na cjuana s'iya texe yo nte. ");
INSERT INTO mazNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Zö ja menzumü 'na nte, pero 'ma ra zũ Mizhocjimi 'ñe ra tsja ja c'o nzi ga ne Mizhocjimi c'o na jo, nu'ma, ra mäpä Mizhocjimi 'ma c'o. ");
INSERT INTO mazNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mizhocjimi o ndäjä e Jesucristo o ẽ zocüjme nutscöjme rí menzumüjme a Israel. O xitscöjme ja rgá sö ra mäjä ín mü'büji rí texeji, dya pje rá mbeñeji. Na ngue e Jesucristo ngue ín Jmugöji zö ja nde rí menzumüji. ");
INSERT INTO mazNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","I̱ṉ pãrãgueji e Juan mi zopjü c'o nte mi jichiji co ndeje. Nuc'ua e Jesús c'ü mi menzumü a Nazaret, mi nzhodü a Galilea mi zopjü c'o nte. Xo 'ñe a Judea. ");
INSERT INTO mazNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mizhocjimi o 'ñeme e Jesús o zopjü c'o nte. O̱ Espíritu Mizhocjimi c'ü mi bübüvi, o unü o̱ poder. Nguec'ua mi pjös'ü c'o nte, y mi jocü c'o vi zürü o̱ s'ondajma e Satanás c'ü dya jo. Na ngue Mizhocjimi mi bübü co angueze. ");
INSERT INTO mazNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nutscöjme rí apóstolejme ró jandajme c'o o tsja e Jesús a Jerusalén, 'ñe texe yo ja cãrã c'o ín menzumügöjme a Israel. Nuc'ua o ndät'äji e Jesús cja ngronsi va mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero c'ü na jñi nu pa, Mizhocjimi o tsjapü o te. Cjanu o jizhi c'ü ya vi tetjo. ");
INSERT INTO mazNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pero dya texe yo nte o jñanda 'ma mü o te. Nguetscöjme ró jandajme. Na ngue o juancüjme Mizhocjimi rá xipjijme yo nte. 'Ma ya vi te e Jesús, ró sigöjme o xëdyi angueze. ");
INSERT INTO mazNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","O xitscöjme e Jesús rá zopjüjme yo nte, rá xipjijme c'ü ngueje angueze c'ü o 'ñeme Mizhocjimi ra jñünpü ngüenda c'o ya rguí ndũ 'ñe c'o xe ri cãrã. ");
INSERT INTO mazNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Texe c'o profeta o mamaji ja ga cja e Jesús. O mamaji 'ma cjó c'o ra 'ñench'e o̱ mü'bü c'ü, ra perdonaoji 'ma c'o na s'o c'o vi tsjaji, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","'Ma xe mi ña e Pedro, 'nango ẽjẽ c'ua a jens'e o̱ Espíritu Mizhocjimi o ẽ bübü cja o̱ mü'bü c'o mi ärä c'o jña. ");
INSERT INTO mazNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","C'o vi ẽji e Pedro cja o̱ ngumü e Cornelio, ya mi creoji e Jesucristo. Anguezeji xo mi menzumüji a Israel. Nguec'ua 'ma o ẽjẽ o̱ Espíritu Mizhocjimi, me go nguijñiji cjanu o mamaji: ―¿Cjó ro mama ro unü o̱ Espíritu Mizhocjimi yo dya menzumü a Israel?, eñeji. ");
INSERT INTO mazNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","O mbãrãji c'ü vi 'ñeje o̱ Espíritu Mizhocjimi, na ngue o dyäräji c'o nte mi ñaji nan'ño idioma; xo mi mamaji c'ü me na nojo Mizhocjimi 'ñe me na jo. O mama c'ua e Pedro o xipji c'o o̱ menzumüji: ");
INSERT INTO mazNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","―Na jo ra ji'i yo; dya sö rá c'a's'üji. Na ngue Mizhocjimi o unü o̱ Espíritu anguezeji, ja c'o nzi va dyacöji, eñe. ");
INSERT INTO mazNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nuc'ua e Pedro o xipji c'o nte c'o dya mi menzumü a Israel ro jiji, na ngue xo 'ñench'e o̱ mü'büji e Jesús c'ü ín Jmugöji. Nuc'ua anguezeji o xipjiji e Pedro c'ü ro mimi ja nzi pa co anguezeji. ");
INSERT INTO mazNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","C'o apóstole c'o mi cãrã a Judea 'ñe c'o 'ñaja cjuarma, o mbãrãji c'ü vi creo o̱ jña Mizhocjimi c'o dya mi menzumü a Israel. ");
INSERT INTO mazNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cãrã a Jerusalén c'o mama ni jyodü rá circuncidaoji. 'Ma mü o nzhogü e Pedro a Jerusalén, anguezeji o huënch'iji c'ua e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","O xipjiji: ―¿Jenga i̱ tsjogü o̱ ngumü c'o dya ín menzumüji i̱ siji o xëdyi? Maco dya circuncidao c'o, embeji e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","O ndünrü c'ua e Pedro o xipjiji texe ja va cja. O mama: ");
INSERT INTO mazNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Mi bübügö cja c'e jñiñi a Jope. 'Na nu pa mi ötügö Mizhocjimi. Nuc'ua ró sö nza cja c'ü dya cja mi bübü, nza cja 'ma ro cjinch'i 'na t'ĩjĩ. Ró janda c'ü mi nza cja 'na manta c'ü ma nojo. O jñetse nza cja c'ü cjó c'o mi pënch'i nza nziyo squina. Vi 'ñeje a jens'e o säjä a jõmü cja ín jmigö. ");
INSERT INTO mazNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","'Ma ró janda na jo cja c'e manta, ró janda o c'ijmi 'ñe o s'ü 'ñe o animale c'o na sate, 'ñe c'o 'ñaja animale c'o bübü nziyo o̱ ngua. ");
INSERT INTO mazNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nuc'ua ró ärägö 'na jña c'ü o mama: “Nu'tsc'e Pedro, böbü rí pö't'ügue 'na yo animale rí sa”, enzgö c'e jña. ");
INSERT INTO mazNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nuc'ua ró tjünrügö ró xipji: “Iyö, ín Jmuts'ügö, dya ra sö. Nunca rí sagö o ts'ingue c'o na s'o c'o mama in leygue c'ü dya rá sagöjme”, rí embegö. ");
INSERT INTO mazNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nuc'ua c'e jña c'ü vi 'ñeje a jens'e, o xitsi c'ua na yeje: “Dya rí mangue na s'o c'ü ya ró tjintscö”, enzgö Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jñi vez va xitscö a cjanu. Y jñi vez rvá tjünrü a cjanu. Nuc'ua c'e manta cjanu o nguins'i c'ua a jens'e nu ja vi 'ñeje. ");
INSERT INTO mazNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nuc'ua jo nu zät'ä c'ua jñi bëzo cja c'e ngumü nu ja mi bünc'ö. Vi 'ñeji a Cesarea o ẽ zinzgöji. ");
INSERT INTO mazNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","O xitsi o̱ Espíritu Mizhocjimi ro möjme c'o bëzo, dya ro yembeñe. Xo 'ñe yo 'ñanto cjuarma, xo ró möcjöjme yo. 'Ma ró sät'äjme, ró cjogüjme cja o̱ ngumü c'e bëzo c'ü vi ndäjä c'o o ma a Jope o ma sizgö. ");
INSERT INTO mazNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nuc'ua c'e bëzo o xitscöjme c'ü vi jñanda 'na anxe cja o̱ ngumü. C'e anxe o zopjü o xipji: “Rí chäjä c'o ra ma a Jope ra ma siji e Simón Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ra xi'ts'i ja rgui salvague, 'ñe texe yo cãrã in nzungue”, eñe c'e anxe va xipji c'e bëzo. ");
INSERT INTO mazNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","'Ma ró zopjügö c'o mi cãrã c'e ngumü, 'nango ẽjẽ c'ua o̱ Espíritu Mizhocjimi o ẽ bübü cja o̱ mü'büji, ja c'o nzi va ẽjẽ cja ín mü'bügöji 'ma ot'ü 'ma mi cãrãgöji va. ");
INSERT INTO mazNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ró mbeñe c'ua c'e jña c'ü vi mama e Jesús c'ín Jmugöji. O mama: “E Juan mi jichi yo nte co ndeje. Pero ra zädä 'ma ra ẽjẽ o̱ Espíritu Mizhocjimi ra ẽ bübü cja in mü'büji”, eñe e Jesucristo. ");
INSERT INTO mazNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","O sido o ña e Pedro o mama: ―Mizhocjimi o unüji o̱ Espíritu anguezeji 'ma o 'ñench'e o̱ mü'büji e Jesucristo c'ín Jmugöji, ja c'o nzi va dyacöji 'ma ró ench'e ín mü'bügöji c'ü. ¿Cjó nguetscö c'ü dya ro ätägö Mizhocjimi c'ü dya ro cjogü cja o̱ ngumü c'e bëzo?, eñe e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","C'o nte c'o vi huënch'i e Pedro, 'ma mü o dyärä c'o mi mama, go juemeji. Cjanu o mamaji: ―Me na jo Mizhocjimi. Xo unü c'o dya menzumü a Israel ra dyäräji o̱ jña. Nguec'ua 'ma ra jyëziji c'o na s'o ra nzhogü o̱ mü'büji, ra bübütjoji co Mizhocjimi. ");
INSERT INTO mazNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","'Ma mü o pjat'üji o ndojo e Esteban, o mbürü o tsjapüji o sufre c'o mi creo e Jesucristo. Nguec'ua o c'ueñeji o möji cja c'o 'ñaja jñiñi. Bübü c'o o ma hasta cja c'e país a Fenicia, 'ñe c'e país a Chipre, 'ñe c'e jñiñi a Antioquía. Mi xipjiji o̱ jña e Jesucristo c'o nu menzumüji c'o mi cãrã nu. Pero c'o dya mi menzumü a Israel, dya mi xipjiji c'o. ");
INSERT INTO mazNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mi cãrã a Antioquía c'o vi 'ñeje a Chipre 'ñe a Cirene. 'Ma mü o säji nu, o mbürü o zopjüji c'o mi ña griego c'o dya mi menzumü a Israel, o xipjiji o̱ jña e Jesucristo c'ín Jmugöji. ");
INSERT INTO mazNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mizhocjimi o mbös'ü anguezeji o zopjüji na jo c'o nte. Nguec'ua c'o dya mi menzumü a Israel, na puncjü c'o o jyëzi c'o mi creoji, o 'ñench'e o̱ mü'büji e Jesucristo c'ín Jmugöji. ");
INSERT INTO mazNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","C'o cjuarma c'o mi cãrã a Jerusalén, o mbãrãji c'ü vi creo c'o dya mi menzumü a Israel. Nguec'ua o ndäji e Bernabé o ma a Antioquía. ");
INSERT INTO mazNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","'Ma mü o zät'ä, me go mäjä. Na ngue o unü ngüenda Mizhocjimi vi intsjimi na puncjü c'o nte. Nuc'ua cjanu o xipjiji sido ro 'ñejmeji co texe o̱ mü'büji e Jesucristo c'ü ín Jmugöji. ");
INSERT INTO mazNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ma jonte e Bernabé. Mi cja ja c'o nzi ma 'ñünbü o̱ mü'bü o̱ Espíritu Mizhocjimi. Y mi creo e Jesucristo co texe o̱ mü'bü. Nguec'ua 'ma mü o zopjü c'o nte, na puncjü c'o o 'ñench'e o̱ mü'bü e Jesucristo c'ín Jmugöji. ");
INSERT INTO mazNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nuc'ua e Bernabé o mbedye a Antioquía cjanu o ma c'ua a Tarso o ma jyodü e Saulo. ");
INSERT INTO mazNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","'Ma o chöt'ü, o siji a Antioquía. O mezhevi 'na cjë nu, mi zopjüvi c'o cjuarma y mi jíchivi o̱ 'ñiji e Cristo na puncjü o nte. Je ngue a Antioquía c'ü o mbürü o xiji cristiano c'o mi ench'e o̱ mü'bü e Jesucristo. ");
INSERT INTO mazNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","'Ma mi bübü a Antioquía e Bernabé 'ñe e Saulo, o ẽjẽ ja nzi c'o mi profeta c'o vi 'ñeje a Jerusalén. ");
INSERT INTO mazNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","'Na c'o profeta mi chjũ e Agabo. O̱ Espíritu Mizhocjimi o 'ñünbü o̱ mü'bü. Nguec'ua o böbü nu ja mi jmurü c'o cjuarma, o mama c'ü ro ẽjẽ 'na tjijmi ro sufreji texe cja c'o país. O zädä c'e jña 'ma mi manda e Claudio. ");
INSERT INTO mazNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nguec'ua c'o cjuarma c'o mi cãrã a Antioquía o ñaji o mamaji c'ü ro mbenpeji o merio c'o cjuarma c'o mi cãrã a Judea. C'ü ro sö nzi 'naja, ro mbös'üji c'o. ");
INSERT INTO mazNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nuc'ua 'ma o jmutüji c'o merio, cjanu o ndäji c'ua e Bernabé 'ñe e Saulo o jñünüvi c'o merio o ma zopcüvi c'o mi pastor cja c'o cjuarma a Judea. ");
INSERT INTO mazNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","C'o pa c'o, mi rey e Herodes. O manda o ma zürüji ja nzi c'o mi ma't'ü e Jesucristo, o tsjapü o sufreji. ");
INSERT INTO mazNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","O manda o mbö't'üji co tjëdyi e Jacobo c'ü mi ngue o̱ cjuarma e Juan. ");
INSERT INTO mazNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nguec'ua me co mäjä c'o mi menzumü a Israel c'o dya mi creo e Jesucristo. O unü ngüenda e Herodes c'ü me mi mäji; nguec'ua xo manda o ma zürüji e Pedro. Mi ngue c'o pa 'ma mi siji o tjõmëch'i c'o dya mi bäns'ä. ");
INSERT INTO mazNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","'Ma o zürüji e Pedro, o manda e Herodes o pant'aji a pjörü. O manda c'ua dieciseis o tropa ro mbörüji e Pedro; ro pëpji nziyo tropa, cja rrũ cambiaji c'ua. O nguijñi e Herodes, 'ma ro nguarü c'e mbaxua c'ü ni chjũ Pascua, ro jñünpü ngüenda e Pedro cja jmi c'o nte, cja rrũ manda ro mbö't'üji. ");
INSERT INTO mazNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nguec'ua mi pjörüji na jo e Pedro. Pero c'o cjuarma c'o mi cãrã a Jerusalén sido mi ötü Mizhocjimi co texe o̱ mü'büji, c'ü ro mbös'ü na puncjü e Pedro. ");
INSERT INTO mazNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","'Na nu xõmü 'ma ma bübü e Pedro a pjörü, mi 'nün't'ü o cadena nzi 'na o̱ dyë. Y cada lado mi bübü 'na tropa c'ü xo mi tjün't'ü o̱ dyë c'o cadena. Ma ĩjĩ e Pedro. Xo mi bübü yeje tropa c'o mi pjörü cja o̱ ngoxtji c'e pjörü. C'ü na jyas'ü, e Herodes ro jñünpü ngüenda e Pedro cja jmi c'o nte. ");
INSERT INTO mazNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","C'e xõmü 'nango jñetse 'na o̱ anxe Mizhocjimi. Y me go jya's'ü cja c'e cuarto. C'e anxe o 'ñünmbü o̱ ximatjü e Pedro ngue c'ua o zö. Nuc'ua c'e anxe cjanu o xipji: ―Ixtí ñanga, embeji e Pedro. Nuc'ua c'o cadena c'o mi 'nün't'ü o̱ dyë, o ndögü c'ua. ");
INSERT INTO mazNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nuc'ua c'e anxe cjanu o xipji e Pedro: ―Nzünt'ü in mbünt'ü, chin'ch'i in mbäcua. O tsja c'ua e Pedro ja c'o nzi va mama c'e anxe. Nuc'ua c'e anxe cjanu o xipji: ―Chëjë in bitu cja rrĩ 'ñeje. Rá ot'ügö, rí bëpjague. ");
INSERT INTO mazNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","O mbedye c'ua e Pedro mi bëpja cja c'e anxe. Dya mi pãrã cjo ix na cjuana mi pedye cja c'e pjörü. Mi sö nza cja 'ma ro nguinch'i 'na t'ĩjĩ. ");
INSERT INTO mazNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","O cjogüvi yeje ngoxtji nu ja xo mi pjörü o tropa. Cjanu o zät'ävi cja c'e ngoxtji de t'ëzi c'ü mi mbedyeji a tji. C'e ngoxtji o xogütsjë c'ua. O mbedyevi c'ua o caminaovi 'na ca