﻿USE sofia;
DROP TABLE IF EXISTS sofia.mavNT_vpl;
CREATE TABLE mavNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mavNT_vpl WRITE;
INSERT INTO mavNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Uito ti IESUI potmu'e Mateu. Mi'i uimiwan me atimo­herep yne Aipo­typot Iesui etiat ui'akasa hap ko'i uimikuap hap ko'i are. Mesuwe sa'awy'i­wuaria ati'atu­set­pehik teran AIPOTYPOT IESUI e'ase'i'in set ko'i katu­pono IESUI ti aha'ase'i pot Aparãu Saipepiat Sese aikotã sa'awy'i TUPANA to'e aha'ase'i koro Aparãu me — Meiũran ti aru Emiariru kawiat Eiã'ỹi topyhu'at Wuat'i Ywania Porekuat Koro e Tupana sa'awy'i. I'ewyte Aipo­rekuat Iesui ti aipo­rekuat pot Tawi Saipepiat Sese topyhu'at aikotã sa'awy'i Tupana to'e — Meiũran ti aru Eiã'ỹi kaipywiat ra'yn topyhu'at Uimi­po'oro Wuat'i Porekuat Eporekuat no e Tupana morekuat Tawi pe Aipo­typot IESUI piat. ");
INSERT INTO mavNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Pyno ati'atu­set­pehik teran mesuwe Aheha­kyera'at hat IESUI e'ase'i'in set ko'i. Sa'awy'i ti APARÃU imoherep tosai­pepiat ISAKI. Mi'i hawyi ISAKI imoherep tosai­pepiat IAKO. Mi'i hawyi IAKO imoherep tosai­pepiat IUTA iywyt'in nywo. ");
INSERT INTO mavNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Mi'i hawyi IUTA imoherep tosai­pepiat PERE iywyt Seru wywo tehary'i Tamãu kaipyi. Mi'i hawyi PERE kaipyi tuwe­mo­herep ESEHŨ. Mi'i hawyi ESEHŨ imo­herep ARÃU. ");
INSERT INTO mavNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Mi'i hawyi ARÃU imo­herep AMINÃTAPI. Mi'i hawyi AMINÃTAPI kaipyi tuwe­mo­herep NASŨ. Mi'i hawyi NASŨ imo­herep SARUMÃU. ");
INSERT INTO mavNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Mi'i hawyi SARUMÃU kaipyi tuwe­mo­herep PUASI tehary'i Hapi kaipyi. Mi'i hawyi PUASI imoherep OPETI tehary'i Huti kaipyi. Mi'i hawyi OPETI kaipyi tuwe­mo­herep IESE. ");
INSERT INTO mavNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Mi'i hawyi IESE imo­herep aipo­rekuat sa'awy'i­wuanuat TAWI. Mi'i hawyi morekuat koro TAWI kaipyi tuwe­mo­herep morekuat SARUMÃU tomima'at tomi'auka Uria ehary'i kaipyi. ");
INSERT INTO mavNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Mi'i hawyi SARUMÃU kaipyi tuwe­mo­herep morekuat HUPUÃU. Mi'i hawyi HUPUÃU imoherep morekuat APIA. Mi'i hawyi APIA kaipyi tewe­mo­herep morekuat ASA. ");
INSERT INTO mavNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Mi'i hawyi ASA imo­herep morekuat IOSAWA. Mi'i hawyi IOSAWA imo­herep morekuat IURÃU. Mi'i hawyi IURÃU imo­herep morekuat USIA. ");
INSERT INTO mavNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Mi'i hawyi USIA imo­herep morekuat IUTÃU. Mi'i hawyi IUTÃU imoherep morekuat AKASI. Mi'i hawyi AKASI kaipyi tuwe­mo­herep morekuat ESEKIA. ");
INSERT INTO mavNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Mi'i hawyi ESEKIA kaipyi tuwe­mo­herep morekuat MANASI. Mi'i hawyi MANASI imo­herep morekuat AMAŨ. Mi'i hawyi AMAŨ kaipyi tuwe­mo­herep morekuat IUSIA. ");
INSERT INTO mavNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Mi'i hawyi IUSIA kaipyi tuwe­mo­herep morekuat IEKUNIA iywyt'in nywo. Morekuat IEKUNIA toĩne'en turan surara'in yi Papi­runia kaipyi tõ'ẽ tõ'ẽ kahato ai'ywania sa'awy'i­wuaria moma hamo. Mi'i hawyi i'atue­su­rara'in teropo'ok kahato i'atueyi pyi yi Papi­runia kape ta'atue­ropat hamo. Mi'i hawyi watu­kupte'en mot'i yi Papi­runia pe. Mi'i tote watu­we­potpap at ka'ap yi Papi­runia ywania emiit'in no watu­we­potpap yt kat sa'up mo i yi wato Papi­runia pe watu­we­potpap itote ahewa­nĩ­kaptia miky'esat ewy. ");
INSERT INTO mavNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mi'i hawyi yi wato Papi­runia pe mekewat aha'ase'i morekuat IEKUNIA kaipyi tuwe­mo­herep SARATIEU. Mi'i hawyi SARATIEU imo­herep SURUPAPEU. ");
INSERT INTO mavNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Mi'i hawyi SURUPAPEU kaipyi tuwe­mo­herep APIUTI. Mi'i hawyi APIUTI imoherep ERIAKĨ. Mi'i hawyi ERIAKĨ imo­herep ASU. ");
INSERT INTO mavNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Mi'i hawyi ASU imo­herep SATOKI. Mi'i hawyi SATOKI kaipyi tuwe­mo­herep AKĨ. Mi'i hawyi AKĨ imo­herep ERIUTI. ");
INSERT INTO mavNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Mi'i hawyi ERIUTI kaipyi tuwe­mo­herep EREASA. Mi'i hawyi EREASA imo­herep MATÃ. Mi'i hawyi MATÃ imo­herep IAKO. ");
INSERT INTO mavNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Mi'i hawyi IAKO imo­herep IUSE. IUSE ti mana MARIA e'aito wanuat toĩne'en. Mi'i hawyi mana MARIA kaipyi tuwe­mo­herep IESUI mekewat TUPANA MIPO'ORO WUAT'I YWANIA POREKUAT NUAT E HAP HET RAKAT. ");
INSERT INTO mavNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sa'awy'iwuat aha'ase'i pot APARÃU e'at kaipyi morekuat TAWI e'at kape 14 ok tuwe­mo­herep miit'in AIKA'IWAT IESUI e'yianmiaria ha'ase'i'in nuat. Mi'i hawyi morekuat TAWI e'at kaipyi yi Papi­runia pe wato­pyhu'at hap e'at kape 14 ok tuwe­mo­herep miit'in AIKA'IWAT IESUI e'yianmiaria ha'ase'i'in nuat. ");
INSERT INTO mavNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mi'i hawyi IESUI AIPOTYPOT ywã'ĩ hap etiat ahenoi teran sa'awy'i. Mesuwat miwan nug hat sese ti Mateu. Pyno tawa Nasare pe wẽtup ok IUSE e hap het rakat tikyi'at teran tehary'i wo yt karãpiat i ihainia wywo ieĩne'en hat mana MARIA e hap het rakat. Ma'ato mi'i yt to'opytyk i te turan imẽpyt a rakano topyhu'at mana MARIA ma'ato yt ihainia kaipyi i ma'ato TUPANA PÃ'ÃU kaipyi hupi'a. ");
INSERT INTO mavNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mi'i hawyi iky'esat hat IUSE tikuap ta'yn hupi'a MARIA hap hawyi tuwa­nẽtup ko'i ko'i kahato — Uima'at rasig Maria e. Wẽtup ok ihainia hupi'a nug hat pote yt naku i atat Maria uhehary'i wo katu­pono wuat'i wywo waire rakat Maria e tuwa­nẽtup hawe. Pyno waku atipo'oro mana Maria wẽtup hy kape mig'i wo e Iuse tuwa­nẽtup hawe katu­pono waku rakat Iuse pote yt toiky'esat i miit'in tikuap hupi'a hap katu­pono Iuteu ywania ti'auka yt he'aito i pytkai hupi'a rakaria pote. — Pyno waku atipo'oro Maria wẽtup tawa kape mig'i wo e tuwa­nẽtup hawe. Mi'i tã atunug mote aru miit'in yt ti'auka i Maria nu wo e tuwa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ma'ato aikotã waku Maria po'oro wẽtup hy kapiat hap kape tuwa­nẽtup turan Tupana tipo'oro ra'yn tehay enoi hat Iuse kape atipy kaipyi. Mi'i hawyi to'e imu'etu — Iuse morekuat Tawi emiariru emiariru e yt erewa­nẽtup ko'i ko'i tei'o Maria ehary'i wuat upi'a hap ete e katu­pono hupi'a yt ihainia kaipywiat minug i e. Waku etat ehary'i wo hupi'a ra'yn pytkai Maria katu­pono yt toi'aparap hin i pytkai hupi'a ra'yn toĩne'en mesup e. Ta'i Tupana Pã'ãu Wakuat kaipyi toĩne'en imẽpyt e. ");
INSERT INTO mavNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Pyno meiũran ti aru mana Maria timo­herep ihainia hit wakuat sese rakat e. Mi'i ti Tupana Mipo'oro tomohey haria minug sa'ag popywiat hep hanuat e. Mi'i pote waku ehet'ok o Maria Mẽpyt IESUI e katu­pono Iuteu pusu puo IESUI ti WO'OEHAKYERA'AT HAT i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pywo pe ti tuwe­mo­herep ti aru Maria Mẽpyt aikotã sa'awy'i­wuaria Tupana ehay moherep haria te'ero'e hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Mio tã e ti Tupana sa'awy'i miit'in me. — Meiũran ti aru wẽtup ok hary­poria wakuat rakat pytkai yt karãpe i he'aito pytkai imẽpyt'a rakano ti aru topyhu'at yt uwe piat topytyk pytkai i e. Meiũran ti aru imẽpyt ihainia ti aru tuwe­mo­herep hawyi Tupana AIPY'ASETPIAT rakat eset i'atu'e Tope e yianmiat Tupana ehay enoi hat Isaia tomiwan 7.14 pe e. — Mi'i hap ewywuat toĩne'en mesup ehary'i wuat mana Maria ete e atipy kaipywiat sut hat Iuse pe. ");
INSERT INTO mavNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mi'i hawyi Iuse tuwe­hymut ra'yn hawyi tutunug na'yn Tupana potpo'oro piat tonãpin hap ewy. Tatat ra'yn Maria tehary'i wo ma'ato yt topytyk i. ");
INSERT INTO mavNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Meiũran ti Maria Imẽpyt ra'yn hawyi to'opytyk. Imẽpyt hawyi Iuse tum na'yn Imẽpyt pe het IESUI e hap het rakat WO'OEHAKYERA'AT e topusu puo. ");
INSERT INTO mavNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aipo­typot Iesui ti tuwe­mo­herep ta'yn mesuwe mekewat tawa hit Perẽ yi Iuteu pe karãpeĩ Eroti toĩne'en morekuat no itotiat turan. Mi'i hap e'at pe waikiru etiat wemu'e haria tõ'ẽ tõ'ẽ ta'atue'yi Urienti kaipyi aikope pyi at tuwẽtem hap kaipyi. ");
INSERT INTO mavNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mi'i hawyi put'ok'i'atu'e tawa wato Ieru­sarẽi note hawyi — Aikope som hirakat Aipo­rekuat pakup nuat toĩne'en i'atu'e itotiaria pe. Aikope som tuwe­mo­herep Ei'ywania Iuteu ywania Potypot pakup ywã'ĩ hap i'atu'e. Katu­pono ha'awyte ra'yn uruta'a­kasa at wẽtem hap kaipyi hewai­kiru i'ywã'ĩ hap enoi hap uruta'a­kasa urue'yi tote i'atu'e. Mi'i pote mesup Aipo­rekuat Koro pakup mõtypot hamo urutõ'ẽ meikowo hewai­kiru upi urutõ'ẽ meikowo i'atu'e waikiru etiat wemu'e haria iwe'eg kahato rakaria tawa wato Ieru­sarẽi miaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","I'atu'e hap morekuat Eroti tikuap hawyi token'ẽ kahato i'ewyte tawa Ieru­sarẽi miaria. Katu­pono te'eru­wa­nẽtup ko'i ko'i kahato Iuteu ywania Potypot ywã'ĩ hap etiat waikiru etiat wemu'e haria ta'atuẽtup hawyi. Kat pote mi'i tã e morekuat Eroti katu­pono waku uito yn morekuat koro wo mesuwat yi tote e. ");
INSERT INTO mavNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mi'i pote morekuat Eroti ti'atu­kaykay tuwe­wawi Tupana ehay miwan etiat kuap sese haria i'ewyte pa'i kororia toi'atu­kaykay hawyi apo'e i'atuepe — Mehĩ'in e aikope so tuwe­mo­herep irane Tupana Mipo'oro Wuat'i Porekuat Koro wuat sese e. Kat etawa pe kat etawa pe i'ywã'ĩ e. ");
INSERT INTO mavNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","— Ta'i tawa hit Perẽ me aru tuwe­mo­herep Mi'i Miit i'atu'e katu­pono sa'awy'i Tupana ehay moherep hat mio tã e miwan me yianmete i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","— Ta'i ahetawa kurin moity'i ewei'e tawa Perẽ miaria yi Iuta ywaniaria e. Ma'ato yt eiwe­mõti tei'o ehetawa kurin mupi katu­pono ti aru meiũran etawa hit Perẽ po'og po'og miit'in mikuap mo topyhu'at yi Iuta ywaniaria yne tawa ko'i kai katu­pono ehetawa hit Perẽ me tuwe­mo­herep irane Isareu ywania Potypot Koro sese e ti sa'awy'i Tupana ehay moherep hat Mikeia tomiwan me 5.2 pe i'atu'e morekuat Eroti pe. ");
INSERT INTO mavNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tuwat i ra'yn inãpin haria hawyi morekuat Eroti ti'atu­kaykay i ra'yn at wẽtem hap kaipywiat õ'ẽ haria waikiru etiat wemu'e haria apoto'e mig'i wo i'atuepiat hamo toi'atu­kaykay i ra'yn — Karãpeĩ ewei'akasa sa'awy'i mekewat waikiru e i'atuepe. Karãpeĩ tuwe­mo­herep sa'awy'i ehowawi mekewat waikiru e. ");
INSERT INTO mavNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mi'i hawyi ta'atu­mo­herep morekuat Eroti pe yne i'atu'e hap. Waikiru wemo­herep hap e'at morekuat Eroti tikuap hawyi to'e waikiru etiat wemu'e haria pe — Waku eweiwat tawa hit Perẽ kape uhyt'i'in e. Mi'i tote o apo'ewei'e kahato Hirakat ete aikope aikope tuwe­mo­herep e. Mi'i hawyi eweipuẽti hawyi waku ewehenoi uhepe aikope toĩne'en Mi'i hat ete e. Pywo ti atikuap teran aikope toĩne'en Hirakat. Areto mono imõtypot hamo ipoityro hamo e so i'atuepe morekuat Eroti. ");
INSERT INTO mavNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mi'i hawyi waikiru kuap haria tuwat morekuat Eroti yaty­pepyi Hirakat kat hamo. Te'eru­wẽtem morekuat yat koro pyi hawyi te'era'a­kasa i ra'yn mu'ap upi mekewat waikiru sa'awy'iwuat at wẽtem hap kaipywiat. Mi'i hawyi ti toto i ra'yn waikiru i'atue'yianme te'en te'en Hirakat ieĩne'en hap kape ra'yn toto. Mi'i hawyi waikiru upi tuwat tawa wato Ieru­sarẽi pyi tawa hit Perẽ kape. Put'ok'e waikiru itote hawyi topyhu'at Hirakat ieĩne'en hap apy tote. ");
INSERT INTO mavNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Te'era'a­kasa ra'yn mekewat waikiru mimo­herep hawyi i'atu­wepit kahato ra'yn waikiru kapiat te'era'a­kasa haria. Te'eru­wehum kahato waikiru kapiat ta'akasa hawyi. ");
INSERT INTO mavNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mi'i hawyi waikiru topyhu'at hirakat ieĩne'en hap apy tote ra'yn hawyi tuwehyt'ok i'yat pe hawyi te'era'a­kasa ra'yn Hirakat kape toty Maria wywo. Mi'i hawyi te'eru­we­pỹ'ã­tutuk ta'yn mekewat Hirakat mõtypot hamo. — Waku ta'atu'e hawyi ta'atu­mie­reto ko'i ta'atu'apok ta'yn hawyi imehit rakat Uru kawiat ta'atuium ne'en ne'i Hirakat pe iky'e hap. Mi'i hawyi ta'atuium ikamhig se rakat miwuk wo iky'e hap. Mi'i hawyi mohag hy Mira e hap ta'atuium Hirakat mõtypot haype. ");
INSERT INTO mavNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mi'i hawyi i'atu­mu'etu ti Tupana ti'atu­nãpin — Yt ewei'aipok tei'o morekuat Eroti puo henoi topiat hamo e seha'at haria õ'ẽ haria pe at wẽtem hap kaipy­wiaria pe to'e. Mi'i pote te'era'aipok ta'atue'yi kape wẽtup mu'ap upi. Yt ta'atu­henoi hin i ra'yn morekuat Eroti pe aikope Hirakat toĩne'en hap. ");
INSERT INTO mavNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mi'i hawyi Tupana mipo'oro atipy kaipywiat tuwe­mo­herep Iuse mu'etu hawyi to'e — Epoĩ'ãm no Iuse e. Etioto ro Hirakat wẽtup yi kape pya meiũpepyi mekewat yi Esitu kape ity wywo e. Eweipopy ro e katu­pono ti aru morekuat Eroti tikat ra'yn wyti aru Hirakat i'auka hamo ne'i e. Mi'i pote waku yi Esitu pe eweikupte'en mig'i wo e. Waku yne meikowo hawyi ti aru woro­nãpin ra'yn karãpe i era'aipok i meikowo te hap ahenoi pakup'i aru epe e atipy kaipywiat Iuse mu'etu to'e. ");
INSERT INTO mavNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mi'i hawyi Iuse ipoĩ'ãm na'yn wãtym muo hawyi meremo ra'yn Hirakat Iesui ity wywo tote­ropo'ok. Te'ero­popy ra'yn yi Esitu kape wãtym muo mig'i wo. ");
INSERT INTO mavNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mi'i hawyi morekuat Eroti ku'uro hap kape itote tukupte'en yi Esitu tote aikotã sa'awy'i Tupana to'e miwan me hap ewy — Meiũran ti aru Uha'yru atikaykay ti aru yi Esitu kaipyi e sa'awy'i wuat miwan me Oseia 11.1 pe. ");
INSERT INTO mavNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma'ato morekuat Eroti tikuap ta'yn seha'at haria ipuẽti haria yt topuo i ra'yn i'atu'aipok hawyi ipy'ahak sese ra'yn topyhu'at — Yt naku i pãi e. Yt tõ'ẽ i ra'yn uipuo henoi uhepiat hamo waikiru kuap haria uimi­ky'esat ewy pãi e. Yt ta'atu­henoi hin i aikope mekewat Hirakat ieĩne'en hap e topy'ahak popuo. Mi'i hawyi morekuat Eroti ti'atu­po'oro kahato tesu­rara'in sem na'yn tawa hit Perẽi kape yne itotiaria hira­karia ipa'iat hit ko'i atu'uka hamo typy anu pyi i'ywã'ĩ rakaria atu'uka yne hamo Perẽi miaria i'ewyte hira­karia ipa'iat yt pya hin i Perẽi kai gupte'en haria typy anu pyi yi kape toi'atu'uka kary katu­pono typy anu ra'yn waikiru etiat wemu'e haria te'era'a­kasa waikiru kape. Mi'i hap ewy te toiky'esat hira­karia atu'uka hap typy anu i'ywã'ĩ rakaria pyi. ");
INSERT INTO mavNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Toi'atu'uka yne itote aikotã Tupana ehay moherep hat Ieremia mienoi tomiwan miat sa'awy'i sese hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","— Tawa Perẽi pyi ti aru mekewat yi Hama pyi ti aru atikuap kahato ti aru i'atu­wo'okak'i kahato hap i'atuehay pirik kahato hap e. Ta'atu­saty'u kahato itote to'opytit'i kahato e. Mana Hakeu ywania tawa hit Perẽi miaria te'eruwak kahato ta'atu­mẽpyt'in ky'e hap upi. Te'eruwak at ka'ap hap atikuap uimu'etu e. Yt uwe i imoperup'i kuap katu­pono topap yne yne imẽpyt'in itote pote e ti Tupana ehay enoi hat Ieremia miwan pe 31.15 pe yianmete Perẽi miat e hira­karia atu'uka hamuat hap etiat. ");
INSERT INTO mavNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mi'i hawyi yi Esitu pe Iuse'in tukupte'en mot'i itote. Meiũran morekuat Eroti iku'uro hawyi Tupana tipo'oro temiit i ra'yn atipy kaipyi Iuse kape. Mi'i hawyi tuwe­mo­herep i ra'yn Iuse mu'etu te yi Esitu piat heĩne'en turan. ");
INSERT INTO mavNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","— Epoĩ'ãm no Iuse e. Etioto ro Hirakat ity wywo hawyi ewei'aipok i ro ehe'yi kape i Isareu ywania e'yi kape katu­pono ti koitywy Hirakat Iesui auka teran hat morekuat Eroti iku'uro ra'yn e atipy kaipywiat sut hat Iuse mu'etu. ");
INSERT INTO mavNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mi'i hawyi Iuse ipoĩ'ãm hawyi — To'iro wata'aipok ahetawa kape e ra'yn Hirakat pe ity pe. Mi'i hawyi te'era'aipok ta'atue'yi Isareu kape. ");
INSERT INTO mavNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Put'okta'atu'e itote hawyi Iuse tikuap ta'yn morekuat Eroti sa'yru sa'ag Akeirau e hap het rakat topyhu'at to'ywot saipe pot heiam note aikope sa'awy'iwuat to'ywot ti'atu'uka hira­karia turanuat hap tote. Mi'i pote Iuse token'ẽ tuwe'yatnug itotiat hamo. Mi'i hawyi mio tã e Tupana imu'etu Iuse pe — Yt ereĩne'en nei'o meiũpe yi Iuteu pe e Tupana Iuse mu'etu to'e. Mi'i pote tuwat i ra'yn tetawa sa'awy'iwuat kape mekewat yi Karireia kape. ");
INSERT INTO mavNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mi'i hawyi tuwat tawa Nasare kape hawyi itote Iesui tuwe­motag aikotã Tupana miky'esat ewy katu­pono to'e yianmete tehay enoi hat wẽ pyi — Meiũran ti aru tawa Nasare piat ieĩne'en hat ati'airo Wuat'i Porekuat no e Tupana sa'awy'i miwan me e hap ewy Iesui toĩne'en Tawa Nasare pe. ");
INSERT INTO mavNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pyno Iesui toĩne'en ne totag hap tawa Nasare pe turan mekewat wo'oset'ok hat Iuwãu toto ra'yn yahig kape. ");
INSERT INTO mavNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mi'i tote tohenoi kahato ra'yn tewawiat õ'ẽ haria pe — Ewei'atoiat ro yne eiminug yt naku i hap ko'i e katu­pono ti yt pya i ra'yn Tupana tipo'oro meikowo Tomi'airo Aipo­rekuat Koro sese wuanuat e Iuwãu tewawiat õ'ẽ haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sa'awy'iwuat sese ti Tupana ehay moherep hat Isaia henoi Iuwãu etiat yianmete. Mio tã e — Meiũran ti aru toĩne'en yahig wato tote eimu'e haty wuat hat sese e Isaia mekewat wo'oset'ok hat Iuwãu etiat. — Mio tã e aru mekewat yahig notiat ieĩne'en hat e — Ewehe­katup o katu­pono tut wyti aru Mekewat Tupana Mi'airo Wuat'i Porekuat nuat e. Aheha­kyera'at hanuat tut irane ahowawi e aru. Mi'i tupono eweimo­hãpyk to Tupana kape e aru mi'i miit. Eiminug yt naku i hap ko'i ewei'atoiat ro e aru. Waku yne hawyi ti aru Tupana tipo'oro ra'yn Mi'i Miit ehowawi e. Mi'i tupono eweimo­hãpyk o Tupana kape eiminug yt naku i hap ko'i. Yne ewei'atoiat hawyi tut irane ahowawi e aru yahig wato totiat aimu'e haty wuat hat e sa'awy'i Isaia tomiwan me 40.3 pe mekewat Iuwãu ieĩne'en hap etiat yianmete e tohenoi. ");
INSERT INTO mavNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mi'i e hap ewy put'ok'e aimu'e hat Iuwãu yahig note tesokpe i'atuhũ wato Kameru sap kawiat wywo. I'ewyte iwe'ok kytyt hap i'atuhũ pe kawiat. Mi'i hawyi imi'u ti pohit ko'i i'ewyte awi'a hy mi'i tutu'u itote. ");
INSERT INTO mavNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mi'i hawyi tawa wato Ieru­sarẽi miaria tuwat tuwat ahet'ok hat Iuwãu kape ihay kuap hamo. I'ewyte yi wato Iuteu ywania etawa piaria tuwat tuwat Iuwãu kape. I'ewyte wuat'i tawa hit upiaria Iũtãu hy popy etiaria gupte'en haria tuwat tuwat Iuwãu kape ihay kuap hamo tuwat ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","— Uito yt naku i nug hat ta'atu'e Tupana piat hamo tuwat. Mi'i tã ta'atu­henoi hawyi Iuwãu ti'atuset'ok ta'yn Iũtãu hy pe. ");
INSERT INTO mavNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","I'ewyte wo'omu'e haria meimuẽ wuaria Tupana mohey haria akag ko'i tuwat Iuwãu ewawi te'eru­weset'ok hamo. Irania'in — Aiku'uro hawyi watoĩne'en ne hap e haria. Irania'in — Aiku'uro hawyi yt kat i aheĩne'en pakup i hap e haria wy tuwat te'eru­weset'ok hamo wo'omu'e haria. Ma'ato mio tã e Iuwãu i'atuepe — Yt naku i woro­ho'oset'ok eipe e Iuwãu katu­pono eipe yt naku i nug haria wo te eweikupte'en e. Eipe ti moi ko'i ewywuat re haiwot rakaria e. Miit auka haria wo wyti eweikupte'en ne eipe e. Mi'i pote kan hamo eweĩ'ẽ meikowo eiweset'ok hamo yt naku i nug haria wo i te eweikupte'en ne turan e. Ta'i Tupana apiheg haria wo eweipyhu'at eipe. ");
INSERT INTO mavNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pyno ewei'atoiat ro yne eiminug sa'ag ko'i are. Mi'i hawyi waku nug haria wo eweikupte'en wuat'i akasa hamo. Mi'i hawyi waku woro­ho'oset'ok eipe e. Aikotã aimikoi wakuat hap aimo­wepit kahato hap ewy eweikupte'en no e. Eweipyhu'at ro Tupana mowepit haria wo eiminug waku hap wywo e. I'ewyte eweikupte'en no miit'in mowepit haria wo eiminug wakuap hap kaipywiat no e. Mio tã hap ewy ewetunug hawyi waku woro­ho'oset'ok eipe e Iuwãu wo'omu'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yt naku i ewei'e eiwa­nẽtup hawe — Yt karãpe i Tupana uru'apiheg kuap katu­pono urue'ase'i'in Aparãu emiariru'in sese ti uruto. Ta'i uruto ti Iuteu ywania pote Tupana yt uru'apiheg kuap i hap yt ewei'e i ran o eiwa­nẽtup hawe katu­pono mio tã ei'e hap kaipyi Tupana tikuap ta'yn yt eiwe'eg i kahato hap ko'i katu­pono ahewaku hap yt tut i aha'ase'i'in kaipyi i yt ai'ywot'in kaipyi i wyti yt aity'in kaipyi i wyti ahewaku hap e. Ta'i Tupana tiky'esat pote tutunug kuap Aparãu emiariru piit ko'i meimuẽ wat nu ko'i kawiat. Yt niatpo hin i mio tã Tupana minug toiky'esat pote e Iuwãu wo'omu'e haria akag ko'i meimuẽ wuaria Iuteuria — Uruto po'og irania'in kai e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Eiwe'eg wo o katu­pono mio Tupana toĩne'en waku pe ra'yn te'ywyhap wywo yt haat i rakaria yp pugha hamo hap ewy toĩne'en e. — Yt naku i eipe pote yt kan hamo i e. Mi'i pote aria mi'u wo yn waku eipe e Tupana e. Aria mi'u wo eweikupte'en aikotã torania aria'yp yt haat kahato i rakat miterek sok wuk wat ewy topyhu'at hap ewy eweikupte'en mesup e Iuwãu wo'omu'e haria pe. Mi'i hap ewywuat eipe katu­pono yt kat i eikai wakuap pote pãi e. ");
INSERT INTO mavNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Uito woro­ho'oset'ok y'y wo — Urutoiat yne ra'yn uruminug sa'ag yt nakuat i hap ko'i ei'e pote woro­ho'oset'ok. Ma'ato yt naku i nug haria wo te eweikupte'en pote yt karãpe i aru woro­ho'oset'ok eipe pãi e Iuwãu wo'omu'e haria akag ko'i pe. Mi'i hawyi Iuwãu to'e torania õ'ẽ haria pe — Uimi­mu'eria e meiũran ti aru tut wẽtup ok Miit ahowawi Aimu'e kahato hat e. Ta'i Mi'i Miit ri uhaipepiat wen ma'ato Mi'i Miit ri po'og po'og wakuat uikawiat hat are. Ta'i Mi'i Miit ri po'og po'og uikawiat wakuat are e. Uiat uhewaku hap ti yt put'ok'e hin i hemiit ipysei hamo ipy sokpe pag hamo are. Uito ti woro­ho'oset'ok kuap y'y wo yn ma'ato uhaipepiat ti aru po'og na'yn inug uikai katu­pono Mi'i Miit ti aru eipyt'atnug kuap Tupana Pã'ãu Wakuat no hat e. Woro­ho'oset'ok kuap y'y wo uito ma'ato Mi'i Miit ehet'ok kuap Tupana Pã'ãu wo e. Mi'i Miit ri po'og uikai wakuat e. Y'y wo yn na'yn uito woro­ho'osei ma'ato Mi'i Miit ti aru imoma kuap yne yt naku i hap eipy'a pyi eiwa­nẽtup hawyi aikotã aria tiwuk kuap kat sa'ag ko'i rakat yt nakuat i ko'i hap ewy e. Pywo ti Mi'i Miit ti aru ehet'ok kuap kahato Tupana Pã'ãu wo e Iuwãu Iesui etiat. ");
INSERT INTO mavNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aikotã hã'ỹi watotok hawyi wati'a­po­pesap uhu hawyi hã'ỹi yn na'yn topyhu'at. Aikotã watopag hã'ỹi heiam me ma'ato i'ape yt kat hamo i ra'yn topyhu'at hawyi ahe'aria nug hamo yn waku i'ape. Mi'i hap ewy ti aru uhaipepiat Tupana Mipo'oro tikuap uwe tomohey haria uwe yt hap e. Ta'i toikuap ti aru towa­nuaria aikotã watikuap aimitok hã'ỹi wakuat hap ewy e. Towa­nuaria pe mio tã e aru — Ta'i uimohey haria ti eipe pote woro­ho'oset'ok e aru tomohey haria pe ma'ato irania'in tehay pun ne'i haria pe ti aru to'e — Aria mi'u wuat ko'i wyti eipe e aru tehay pun haria pe. Aikotã mi'apo­pesap uhu ko'i ewy ra'yn eipe e aru uhaipepiat sut hat e Iuwãu Iesui piat pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mi'i hawyi wẽtup e'at pe Iesui toto Iũtãu hy kape te'yi Karireia kaipyi Iuwãu piat toset'ok hamo toto. ");
INSERT INTO mavNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma'ato put'ok'e itote hawyi Iuwãu to'e Iesui pe — Uika'iwat e eriot apo eset'ok uhetiat hamo e. Pyno yt naku i uito woroset'ok Uipo­typot ne'i En tupono. En ni po'og uikai e. Mi'i tupono ti po'og ni En waku uhet'ok En Ui'ywot e. ");
INSERT INTO mavNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mi'i hawyi Iesui to'e ma'ato Iuwãu me — Waku uhet'ok en mehĩ e katu­pono ti mi'i tã hap ti Tupana miky'esat ewy eminug uhet'ok epiat hap e. Mio tã e pote — Pyno woroset'ok Ui'akag e'e hap ewy e Iuwãu Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mi'i hawyi toset'ok rokirẽ Iesui tuwẽtem y'y pyi turan Iuwãu teha'at atipy kape hawyi oken'ypy ewywuat atipy piat ta'akasa. Mi'i hawyi Tupana Pã'ãu ut hamuat hap pykasu ut hap ewy ta'akasa ra'yn. Mi'i ti ta'apyk ta'yn Iesui apy tote. ");
INSERT INTO mavNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mi'i turan toikuap sehay atipy kaipyi — Meiẽ ti Uha'yru sese uimiky'e kahato ti meiũ e. Uimo­wepit kahato hat Mi'i e Tupana Iesui etiat. Iuwãu tikuap Iesui set'ok hap tote sehay atipy kaipyi. Iesui weset'ok hap etiat ahenoi mesuwe uimiwan me Uito Mateu. ");
INSERT INTO mavNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mi'i hawyi Tupana Pã'ãu tioto Iesui yahig wato kape aikope yt uwe i ieĩne'en hap kape. Mi'i hawyi itote ahiag hã'ãg kahato Iesui 40 e'at turan tomi­ky'esat nug hamo toiky'esat. ");
INSERT INTO mavNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Itote Iesui toĩne'en wẽtup ewaty. Yt kat i hin i tutu'u at ka'ap yahig wato tote. Itote yt kat i tutu'u at ka'ap wẽtup ewaty turan. Ta'i 40 e'at pe tuwe­mosy'at yn itote. 40 e'at hawyi hesy'at kahato toĩne'en itote mekewat yahig koro tote. ");
INSERT INTO mavNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mi'i hap ete iperup kahato sy'at pono. Mi'i turan put'ok'e ahiag itote hã'ãg sese hamo. Mi'i hawyi to'e Iesui pe — Mehĩ e pywo Tupana Sa'yru sese En mote etunug no emi'u wo man meikowat nu ko'i kawiat e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mi'i hawyi Iesui to'e ahiag me — Ma'ato yt atunug neran i rat e'e hap ewy e katu­pono sa'awy'i Tupana to'e — Mi'u hap kape yn miit'in te'eru­wa­nẽtup pote yt karãpe i ta'atu­puẽti ta'atuieĩne'en wuat'i e'at piat hamuat e katu­pono uhehay nug yne hap kaipyi yn ni miit'in tipuẽti kuap toieĩne'en hap sese e Tupana sa'awy'i miwan me e Iesui ahiag me. ");
INSERT INTO mavNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mi'i hawyi ahiag tioto Iesui tawa wato Ieru­sarẽi kape ra'yn hawyi totopag Iesui mekewat Tupana mõtypot yat koro po'og ywaiti kahato rakat tote. Mekewat sa'awy'iwuat Teute­ru­numiu 8.5 miwan miat ewy to'e ahiag me. ");
INSERT INTO mavNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mi'i hawyi ahiag to'e tope — Mehĩ e pywo ti Tupana Sa'yru sese En mote e'okhyt'at ro meiũpepyi yi kape katu­pono sa'awy'i ti Tupana to'e — Atipo'oro uhemiit atipy kaipyi epowyro hamuat e. Era'at hawyi yt ere'ahyk hin i yi tote meimuẽ wuat nu ko'i ete hamo e Tupana sa'awy'i miwan me Mehĩ e ahiag Iesui pe. Tawi wepy miwan 9.11 e hap ewy to'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma'ato Iesui tiwesat — Pywo mio tã e Tupana wen ma'ato i'ewyte wẽtup we to'e miwan me — Wãi yt uhã'ãg nei'o sio woro­po­wyro ipoity'i rakat nug hap ete sio yt e katu­pono yt woro­po­wyro kuap i ti sa'ag nug hap ete e Tupana i'ewyte miwan me e ahiag me. Mi'i sehay Teute­ru­numiu 6.16 pe tohenoi ahiag me. ");
INSERT INTO mavNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mi'i hawyi ahiag tioto Iesui yity'ok ywaiti rakat kape ra'yn. Mi'i hawyi itote pyi ahiag timo­herep tope wuat'i ywania mesuwat yi totiat. Mesuwat mytyp yne toimo­herep tope i'atue­tawa wato kahato ko'i ta'atu­po­re­kuaria ta'atu­we­painug hap ko'i ta'atuekat kahato hap ta'atu­kahu hap ko'i toimo­herep yne yne Iesui pe aikotã aikotã iwato hap ok tã. ");
INSERT INTO mavNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mi'i hawyi to'e — Mehĩ e pywo ti rat woronug En wuat'i ywania Porekuat no i'ewyte i'atuekat ko'i i'atue­tawa wato ko'i atum yne yne epe uimõ­typot En mote erepỹ'ã­tutuk uhowawiat pote e ahiag Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma'ato Iesui tiwesat — Mutoro meiũpepyi ahiag pya ui'yaty­pepyi e katu­pono sa'awy'i mio tã e ti Tupana miwan me — Uito yn waku eimi­mõ­typot no katu­pono Uito yn areĩne'en Tupana wo wẽtup yn e. Mi'i hawyi yt uwe i Tupana wo toĩne'en e Tupana sa'awy'i miwan me e. Mi'i pote — Mutoro ahiag pya uikai e Iesui ahiag me. Mi'i sehay Teute­ru­numiu 6.13 toĩne'en. ");
INSERT INTO mavNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mi'i hawyi ahiag toto ra'yn Iesui yaty­pepyi. Mi'i pytkai Tupana mipo'o­roria tõ'ẽ ra'yn atipy kaipyi Iesui powyro hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mi'i hawyi Iesui ta'aipok i ra'yn aikope miit'in tukupte'en hap kape mekewat yity'ok totepyi. Mi'i tote toikuap ta'yn Iuwãu wo'oset'ok hat more­kuaria tipyhik ta'yn wo'opyhik hawe. Toikuap hawyi toto ra'yn itote pyi tomotag hap kape tawa Nasare kape yi Karireia kape i ra'yn toto. ");
INSERT INTO mavNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Put'okto'e itote hawyi toto tomotag hap tawa Nasare pyi tawa Kawana'ũ e hap kape yi Karireia ihyemyi'a kawianuat tawa ko'i kape toto yi Sãpurũ piaria kape yi Natari piaria kape toto. ");
INSERT INTO mavNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mi'i hawyi tawa Kawana'ũ tote Iesui toĩne'en yi Karireia pe i'atumu'e hamo aikotã sa'awy'i miwan me to'e hap ewy ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Aikotã sa'awy'i Tupana ehay moherep hat Isaia to'e hap ewy — Ta'i yi Sẽpurũ piaria yi Natari piaria yi Karireia hyemyi'a ẽpe etiaria Iũtãu hy ẽpe piaria wẽtup ywania. Mi'iria ti uhehay yt ta'atukuap i pote tukupte'en kahato i'atu­minug sa'ag ko'i. Mi'i pote i'ypyryp wiat gupte'en haria ewy mi'iria. Iku'uro rakaria ewy yn tukupte'en mi'iria. ");
INSERT INTO mavNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ma'ato meiũran ti aru atipo'oro ra'yn Uha'yru i'atue­wawi i'atumu'e hamo. Uhehay wuat i'atumu'e hamo hawyi ti aru ta'atu'atoiat ra'yn ta'atu­minug sa'ag hap ko'i. Mi'i hawyi ta'atuieĩne'en hap sese ta'atu­puẽti ra'yn e. Ta'i atipo'oro irane Uha'yru ariãty ewywuat sese i'atuieĩne'en hap moẽtyhot hamuat. Mi'i hawyi uhehay kuap haria wo te'ero­pyhu'at wẽtup ywania pytkai e Isaia sa'awy'i miwan me 9.1 pe Iesui ut hamuat tohenoi. ");
INSERT INTO mavNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mi'i hawyi toto ra'yn Iesui yi Karireia piaria mu'e hamo — Eiwe­morem no yt nakuap i nug hap ko'i kaipyi e. Mi'i hawyi eweiwe­morem no Tupana kape katu­pono yt pya hin i Tupana topyhu'at Miit'in Porekuat no sese ra'yn e Iesui yi Karireia piaria pe. Mi'i hawyi Iesui ti'atumu'e kahato yne y'y hit i upiaria yi wato Karireia piaria. ");
INSERT INTO mavNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wẽtup e'at pe hawyi Iesui hewyry mekewat yi Karireia hyemyi'a ẽpe upi yi kyt upi. Mi'i hap tote Iesui teha'at typy ok kape mekewat mehĩ Simãu wẽtup het Peteru e hap i'ewyte iywyt Ãtere e hap kape teha'at. Mi'iria tukupte'en ta'atue'yara pe ihyemyi'a wato tote aikope ta'atue­suki wato wo haria i'atue­hapap kahato pira pytyk suki wato wat rakaria kape. ");
INSERT INTO mavNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mi'i hawyi Iesui iwẽpap'i i'atue­wawi — Uiwyria'in e to'iro uhupi e. Ahenoi mono miit'in pytyk Tupana wanuat hap aikotã pira ko'i pytyk ehepiat hap ewywuat re hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mi'i hawyi ta'atu'atoiat ra'yn ta'atue­suki wato itote hawyi meremo tuwat Iesui upi. ");
INSERT INTO mavNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tuwat porap'i i ra'yn hawyi yi kyt upi Iesui teha'at Sepeteu sa'yru'in kape mehĩ Tiaku i'ewyte iywyt Iuwãu kape wesuki wato mog yara piat haria kape. Mi'i hawyi i'ewyte Iesui iwẽpap'i i'atue­wawi — To'iro uhupi mehĩ'in e. ");
INSERT INTO mavNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mi'i hawyi tuwat meremo hupi. Ta'atu'atoiat ra'yn ta'atue­suki pira pytyk hap ta'atue'yara pe hawyi ta'atu­henoi ta'atu'ywot sese hawyi tuwat ra'yn Iesui upi miit'in mu'e hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Mi'i hawyi Iesui toto i itote pyi yi wato Karireia piaria mu'e hamo i ra'yn. Toi'atumu'e kahato sehay wakuat no wuat'i Tupana mõtypot yat pe toi'atumu'e. I'ewyte i'ahu rakaria toi'atu­moe­hãite kahato aikotã aikotã i'atu'ahu hap ok tã toi'atu­moe­hãite torania itote. ");
INSERT INTO mavNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mi'i hawyi miit'in yi Karireia piaria yi Siria piaria tikuap ta'yn Iesui misepap sese ko'i. Mi'i hawyi tõ'ẽ tõ'ẽ pya wuaria. Ta'atuerut kahato i'ahu rakaria torania hawyi Iesui ti'atu­moe­hãite kahato i'atu­tara heg nakaria mã'ãu sa'ag ko'i mimoeso'ok ko'i ipo kĩ'ã rakaria ipy kĩ'ã rakaria iku'uro ku'uro rakaria ta'atuerut howawi hawyi toi'atu­moe­hãite yne ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mi'i hawyi miit'in sem tuwat tuwat hupi aikopuo aikopuo hewyry hap upi yi Karireia kaipy­wiaria tawa wato Ieru­sarẽi kaipy­wiaria mekewat Iũtãu hy sakpuaria mekewat 10 etawa ko'i kaipy­wiaria tuwat hupi. I'ewyte yi Iuteu kaipy­wiaria tuwat tuwat Iesui upi miit'in typy'i kahato rakaria are uito Mateu. ");
INSERT INTO mavNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mi'i hawyi miit'in sem te'eru­wa'a­tunug Iesui kape. Mi'i hawyi teha'at i'atue­wawi hawyi ipot'am na'yn yity'ok tote hawyi ta'apyk itote yity'ok apypeke. Mi'i tote ipotmu'eria te'eru­wa'a­tunug i'apy­pueri wo. ");
INSERT INTO mavNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mi'i hawyi Iesui ti'atumu'e uwe uwe mesu­wa­rote Tupana mipoi­tyro wuat ko'i tohenoi. ");
INSERT INTO mavNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mio tã to'e — Uheka­tu­wyria uwe uwe Tupana pe to'e — Worokuap po'og neran wyti uito katu­pono ti yt worokuap hin i te yt uimi­ky'esat ok tã i te worokuap e topy'a pe mio tã e haria pe Tupana to'e — Pyno uimi­poi­tyro sese ko'i eipe katu­pono woro­ho'onug wyti aru eipe wuat'i ywania pore­kuaria wo mesu­wa­rote aikotã Uito areĩne'en Morekuat no atipy pe hap ewy e Tupana mio tã e haria pe e Iesui itotiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mi'i hawyi Iesui to'e i — Uiwyria'in e uwe uwe tuwak topy'a pe irania'in satek pote ho'opot pote mi'i haria pe ti Tupana to'e — Woro­ho'o­mo­wepit kahato eipe katu­pono karãpe ehehaky'e'i hap put'ok'e ehete mi'i hap atu'u yne uipy'a pe wy aikotã irania'in ehaky'e'i hap ewetu'u yne hap ewy e Tupana mi'iria pe e. Uhegyi'at hap ok tã wyti aru eweikupte'en e. Woro­ho'o'og­hytsat wyti aru eipe e Tupana mio tã e haria pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mi'i hawyi Iesui to'e i — Uipot­mu'eria e uwe uwe pywo pe to'e topy'a pe perup'i popuo — Pywo pe ti uito po'og yi kai irania'in kai e hap yt tuwe­mo­wato hap wywo i mio tã e haria pe Tupana to'e — Pywo pe ti uimi­poi­tyro sese eipe katu­pono mesuwat mytyp tote more­kuaria wo wyti aru woro­ho'onug eipe e. Mesuwat mytyp tote topyhu'at irane eipo pe e Tupana paa'e haria pe e Iesui yity'ok totiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mi'i hawyi to'e i — Uhupiaria e uwe uwe to'e Tupana pe — Areĩne'en neran hãpyk kahato e'ewy mi'i haria pe Tupana to'e — Uimi­poi­tyro ko'i kahato wyti aru eweikupte'en ui'ewywuat waku sese hamo woro­ho'onug eipe katu­pono eimi­ky'esat ewy woro­ho'o­mo­hãpyk eipe Ui'ewy e Tupana mio tã e haria pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mi'i hawyi po'og Iesui henoi — Uhaipe­piaria e uwe uwe ihaky'e'i rakaria powyro haria mi'i haria pe Tupana to'e — Pywo ti rat woro­ho'o­poi­tyro kahato aru eipe e. Uhegyi'at kahato hap topyhu'at aru ehete aikotã eiminug ewy e Tupana ihaky'e'i rakaria powyro haria pe e Iesui ta'apy­pueri haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mi'i hawyi to'e i — Uimohey haria e uwe uwe topy'a pe tuwa­nẽtup hawe wakuat kape yn tuwa­nẽtup mi'i haria pe Tupana to'e — Pywo pe ti woro­ho'o­mo­wepit kahato aru eipe katu­pono uhowawiat akasa haria ewy eweikupte'en e Tupana ipy'a kahu rakaria iwanẽtup kahu rakaria pe e Iesui yity'ok totiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mi'i hawyi po'og Iesui henoi itotiaria pe — Uhemiit'in e uwe uwe wo'owese hap yn nug haria pe Tupana to'e — Pywo pe uimi­poi­tyro ko'i eipe katu­pono uha'yru'in uhaki'yt'in sese wo e wyti aru mi'iria pe wuat'i ehamo Tupana wo'owese hat yn nug haria pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mi'i hawyi Iesui to'e i — Uhupiaria e uwe uwe wakuap nug motiat miit'in wo'okyry'i hamo topyhu'at mi'i haria pe ti Tupana to'e — Pywo pe ti woro­ho'o­mo­wepit kahato katu­pono atum aru ehepe uhetama atipy piat e Tupana. Pywo pe ti woro­ho'o­mo­wepit kahato eipe katu­pono aikope Uito areĩne'en Morekuat no hap tote eheiam sese wo topyhu'at irane e Tupana wakuaria pe miit'in misaty'i saty'i ko'i pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","I'ewyte uwe uwe uhemiit'in sese wo miit'in mikyry'i hamo te'ero­pyhu'at miit'in misaty'i saty'i wo miit'in mimo­weuka'i mi'i uhemiit'in pote mi'i hat pe — Pywo pe ti woro­mo­wepit po'og ni wuat'i kai e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","— Ta'i mi'i tã hap ewy ta'atunug sa'awy'i­wuaria uhehay moherep haria ete e Tupana. Mi'i tupono i'atuehay sa'ag yt pywo pe i ehete uhemiit'in eipe pote eiwe­wepit ro eiwe­wehum no sa'ag ta'atunug ehetiat pytkai katu­pono meiũran ti aru Tupana mimõ­typot kahato haria wo eweikupte'en atipy pe are e. Ta'i atipy pe — Woro­mõ­typot kahato eipe e Tupana aru uimohey haria potiat miit'in mikyry'i hap ko'i wo eipe pote e Iesui. Uhehay mohey hat eipe pote i'atuehay sa'ag yt pywo pe i ehete pote eweimo­wepit ro eweiwehum no Tupana kape are katu­pono eha'up muat wyti iwato kahato toĩne'en atipy pe e Iesui. Sa'awy'i te pyi mesup te Tupana ehay moherep haria miit'in mikyry'i hap ko'i wo tukupte'en e. Mesup te i'ewyte miit'in yt i'atu­wese hin i ehete Tupana ehay moherep haria eipe pote are e. Uimohey haria yt paa'ewei'e hin i miit'in yt i'atu­wese i ehete turan are e. Po'og po'og eiwehum no Tupana kape po'og sa'awy'iwuat kai are e. Waku mi'i tã ewei'e — Waku kahato En Tupana katu­pono koitywy yt emohey haria i uimo­weuka'i kahato hap kaipyi atikuap ta'yn uito ti ehay moherep hat sese areĩne'en hap atikuap mesup waku ewei'e ro Tupana pe ehehay wepit hap wywo e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Pywo ti rat uhemiit'in sese wo eipe pote uimo­herep haria eweikupte'en miit'in mu'e haria are e. Pywo pe uhehay kuap haria wo eipe pote uhehay moherep haria eweikupte'en miit'in py'asetpe are e. I'atuieĩne'en hap mowaku hanuaria ewy eweikupte'en are e. Ta'i ukyt ewywuat eipe aikotã mi'u mosẽ'ẽ hap ewywuaria wo eipe e. Mi'i hap ewy ti eweipyhu'at eipe miit'in py'asetpe e. Ma'ato karãpe ukyt yt hẽ'ẽ rakat i topyhu'at yt uwe i imosẽ'ẽ kuap mekewat e. Waku mipun wuano hawyi miit'in mi'akit akit no topyhu'at e. Yt naku i eweikupte'en ukyt nop takat ewy e. Pyno o hẽ'ẽ rakaria wo eweikupte'en e Iesui temiit'in me yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Uimohey haria e eipe ti ariãty ewy ra'yn eweikupte'en mu'ap Tupana kapiat moherep miit'in miat hanuaria eipe aikotã ariãty wãtym muo mu'ap moẽtyhot haria ewywuaria eipe e. Ta'i aikotã yity'ok totiat tawa e'ariãty hẽtyhot kahato yi hot kape. Yt tuwemig kuap i mekewat yi hot piat tawa wãtym muat e. Aikope pyi aikope pyi heremo wãtym muo ariãty hẽtyhot pya kahato yity'ok totepyi pote e yt tuwemig kuap i mekewat tawa wãtym muo e. Mi'i hap ewy ariãty ewy kahato eipe miit'in py'asetpe uhemiit'in eipe pote uhehay moherep haria eipe pote e. Eiminug wakuap kaipyi miit'in eikuap meremo uimohey haria eipe hap ariãty ewywuat mu'ap Tupana kapiat moherep miit'in miat hanuaria eipe pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mi'i hap ewy ti eipe ariãty ewy eweikupte'en e. Wãtym mote miit'in topag ariãty ywaiti heiam sese pe ma'ato yt uwe i ariãty ipag neran yrysakag ywyt'okpype i e. Yt naku i ti mi'i tã watunug ma'ato waku heiam me yn waku aiũpe getap moẽtyhot hamo watopag waku. Mi'i hawyi ti yne ra'yn getap wiaria waku puo hewyry e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pyno ti ariãty hẽtyhot kahato hap ewy uimohey haria miit'in pu'ap Tupana kapiat moẽtyhot hamo eweikupte'en e. Atiky'esat yne eiminug wakuap ko'i heremo wuat'i akasa hamo i'ewyte Ai'ywot Tupana atipy piat mõtypot hamuat atiky'esat e Iesui temiit'in me yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Uiwyria'in yt eiwa­nẽtup tei'o ariot mesuwat yi kape Tupana ehay Musei mimo­herep moma hamuat hap kape e. I'ewyte yt eiwa­nẽtup tei'o ariot mesuwat yi kape mekewat sa'awy'i­wuaria Tupana ehay enoi haria miwan monik hamuat hap kape katu­pono nimo te Tupana ehay moherep haria i'atuehay kahato yianmete uheĩne'en hap etiat ta'atu­henoi kahato are e. Kat i'atu'e kat i'atu'e hap ta'atu­mo­herep uhetiano hap e. I'atu'e hap uhetiano yne nug hamo ariot meikowo uiwyria'in e. Mi'i pote yt atimoma hin i sa'awy'i­wuaria Tupana ehay moherep haria Musei ewywuat katu­pono mi'iria uhetiat ta'atu­henoi kahato uhut hap owakai te e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Katu­pono aikotã mesuwat yi at waty waikiru ko'i tukupte'en mot'i mi'iria i'ewyte Tupana ehay moherep haria nimuaria miwan ko'i te tukupte'en mot'i ma'ato po'og mot'i katu­pono wuat'i e'at piat Tupana ehay toĩne'en e. Pyno ti iwan hit ko'i Tupana ehay miwan etiat ko'i itig hap ko'i iwan hit hap ko'i Tupana ehay Musei miwan Tupana ehay moherep haria miwan topyhu'at aru wuat'i e'at pe. Yt karãpe i Tupana ehay miwan miat ikahuro aru e. Miwan miat yne Tupana e hap topyhu'at wuat'i e'at pe e. Yt sehay wẽtup i miwan miat ikahuro e Tupana. Pyno ti yt uwe i ipyhyp kuap Tupana e hap ko'i — Atunug aru e hap ko'i ta'i Tupana tunug kahato yne yne to'e hap ewywuat are e. — Atunug aru e miwan me pote tutunug aru to'e hap ewy e. Pywo tutunug aru to'e hap ewy are e. Pywo ti rat waikiru ko'i at ewaty yi ikahuro ma'ato Tupana ehay miwan miat torania topyhu'at aru wuat'i e'at pe e Iesui itotiaria pe miit'in sem me. ");
INSERT INTO mavNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mi'i tupono waku watunug yne kahato Tupana piat ainãpin hap ko'i miwan miat kurin kat iwato'in nakat are e katu­pono uwe uwe mekewat Tupana miky'esat miwan miat yt tutunug neran i Tupana piat ainãpin hap i'e hap yt tutunug i hawyi tohenoi henoi irania'in me — Yt naku i watunug Tupana piat ainãpin hap miwan miat ko'i ewy e hat ti aru yt uwe mimõ­typot no i ra'yn topyhu'at atipy pe e. Mi'i hat wyti aru miit'in mimohit sese wo topyhu'at atipy pe e. Ma'ato uwe uwe mekewat Tupana miky'esat ewy inug i'e hap miwan miat ewywuat mi'i hat tohenoi kahato irania'in me — Ta'i waku kahato watunug torania ainãpin Tupana piat hap ko'i miwan miat e hat wyti aru Tupana etama atipy piat pe po'og topyhu'at Tupana mimõ­typot no e Iesui yity'ok totiaria ta'apy­pueri haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Uipot­mu'eria e pywo pe ti eiwe'eg wo o ai'ywania wo'omu'e koro haria minug yt nakuat i hap ewywuat pupi e. Eiwe'eg wo o Tupana mõtypot yat piaria akag ko'i minug sa'ag ewywuat pupi e. I'ewyte eiwe'eg wo o Tupana ehay miwan saipepiat nug haria minug sa'ag ewywuat pupi e katu­pono yt po'og i eiwat i'atukai ehewaku hap pote ti aru yt karãpe i eiwehyt'ok aikope Tupana Morekuat no topyhu'at hap tote e topot­mu'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Uiwyria'in e nimuat ainãpin haria ti Tupana ehay moherep haria hãpyk kahato aimu'e Tupana e hap ta'atuwan ma'ato ta'atuwan pytkai yt ta'atunug neran i. Mio tã e Tupana piat hap — Yt eti'auka tei'o miit e. Eti'auka miit pote waku surara po pe ereĩne'en ekuap hamo e. Pywo pe waku miit'in mi'auka wo ereĩne'en e Tupana sa'awy'i miwan me. Ma'ato eimu'e haria — Yt kan hamo i watunug Tupana piat mio tã e hap i'atu'e sa'ag e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Uimohey haria koitywy po'og woro­ho'o­nãpin mi'i e hap ete e. Uwe uwe ipy'ahak at ka'ap topy'a pe wẽtup ok miit ete mi'i hat wyti miit auka hat ewywuano ra'yn topyhu'at e Tupana towa­nẽtup hawe e. I'ewyte uwe uwe to'e wẽtup ok pe topy'a pe — Yt kan hamo i en uiwa­nẽtup hawe e at ka'ap mi'i e hat pe — Woro'a­piheg aru e Tupana mi'i hat pe e. Ma'ato uwe uwe ipy'ahak sese wẽtup ok ete at ka'ap hawyi to'e — Motoro aria koro kape wuat'i pe yt kan hamo i en e topy'a pe at ka'ap mi'i e hat pe ti Tupana to'e — Woro'a­piheg aru aria koro wo e katu­pono mi'i e hat ewywuat wo'opot'auka hat sese wo ra'yn toĩne'en Tupana wanẽtup hawe e Iesui. Yt naku i aipy'a pe miit auka hat wato­pyhu'at Tupana ehamo are. Mi'i tã eweikupte'en mote Tupana mi'apiheg wo eweikupte'en e Iesui temiit'in me yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mi'i hawyi Iesui to'e i i'atuepe. — Karãpe etum neran Tupana pe emiium imõtypot hap ma'ato toĩne'en wẽtup ok miit ewanĩkap epy'ahak hap pote waku yt etum i emiium Tupana pe ma'ato waku etoiat ro emiium muat mekewat yparakai tote hawyi ereto ro ewanĩkap kape ti etunug ewy wo i ra'yn hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Mi'i hawyi — Uiwy ere atiky'esat kahato waure wo ereĩne'en uhepiat emõpy'ahak hap kai ere o e. Eiwo'o­wese hap toĩne'en i ra'yn iwywo hawyi waku era'aipok emiium muat sat hamo hawyi etum imiky'esat ewy. Waku pe ereĩne'en hawyi eiwo'o­wese hap etipuẽti i ra'yn hawyi o e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mi'i hawyi Iesui to'e i yity'ok totiaria pe — Uiwyria'in e karãpe wẽtup ok ewanĩkap tut surara'in wywo epyhik hamo morekuat wo'opyhik hawe pyno ewe'eg wo o mi'i hap e'at pe are e. Waku mu'ap upi etunug ni ipy'ahak takat ewy ok wo e. Waku meremo etunug mekewat ewanĩkap ewy ok wo i ra'yn mu'ap tote e ma'ato yt etimo­wese i yianmete pote yt naku i topyhu'at aru eete e katu­pono ewanĩkap aru eium morekuat pe yt naku i nug hat en sio waku rakat e hamo. — Yt naku i en e morekuat pote epag surara'in akag po pe ra'yn epyhik wo'opyhik hawiat wuat'i e'at pe hamo ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","— Uimohey hat en mote ewe'eg wo o karãpe ewanĩkap ereto wo'opyhik hap kapiat turan e. Etikat kahato iwese hap mu'ap upi e. Yt pote wo'opyhik hawe ereĩne'en mot'i itote. Yt uwe i ikuap karania ewaty karania anu ereĩne'en epyhik hawe e. Mi'i hawyi ti epore­nõtem hap sa'up niatpo kahato ra'yn iwato kahato ra'yn toĩne'en e. Pyno ti po'og waku mu'ap upi ehã'ãg kahato ewy inug hamo ereto hat ewanĩkap e. Etunug o ewanĩkap merep ewy ok wo i ra'yn are ehepe uipot­po'o­roria e Iesui temiit'in me yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","— Uipot­mu'eria e watikuap ta'yn aikotã sa'awy'iwuat Tupana ehay enoi hat Musei to'e — Yt erepehik tei'o wẽtup wary ete wẽtup e'aito ete e. Ewary wywo yn o ewaire e'aito wywo yn o ewaire e hap e. Pywo kahato ainãpin Musei e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Musei e hap mohag hat ri uito. Musei e hap ete woro­ho'o­nãpin eipe — Yt naku i kahato eraha'at kahato hary­poria kape ihainia kape erepehik teran hap wywo mekewat hary­poria wywo mekewat ihainia wywo epy'a pe ewanẽtup hawe. Mi'i tã etunug mote yt naku i kahato rakat no ereĩne'en Tupana wanẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pyno eha wo eraha'at hary­poria kape ihainia kape mi'i hawyi ewanẽtup hawe ere'e — Arepehik teran mekewat hary­poria ete mekewat ihainia ete ere ewanẽtup hawe pote etihep o eha mehĩ'in mana'in katu­pono pywo ti rat eha ti e'aparap hap nug hap topyhu'at are e. Mi'i pote waku etihep eha hawyi etipun pya ekai are e. Pywo ti rat waku po'og kokawiat ihasik takano ereke atipy pe ma'ato typy kawiat eha wywo ereto aria kape are e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","I'ewyte epo kokawiat wo etima'at teran wẽtup ok hary­poria wẽtup ok ihainia sewaire hamo mi'i pote waku etitek epo kokawiat mi'i hawyi etipun mi'i pya ra'yn ekai are katu­pono po'og waku mesuwe ereĩne'en ipo tut rakat ipy tut rakat ihasik takat wo ereĩne'en mesuwe sio torania epo wywo eha wywo epy wywo ereke aria koro pe are aikope miit'in ho'opot kahato mi'i hap kape are e ti Iesui. Po'og waku ereke Tupana etama pe wẽtup epo wywo yn typy epo wywo ereke aria pe ho'opot hamo e Iesui miit'in sem me yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mi'i hawyi po'og Iesui to'e ta'apy­pueri haria pe — Pywo pe ti mehĩ'in mana'in sa'awy'i ti mio tã i'atu'e nagnia — Etoiat teran ehary'i e'aito mi'i pote waku etunug iwan me morekuat wywo e miwan me hawyi waku eiwo'o'atoiat i'atu'e sa'awy'i aha'ase'i'in mio tã i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma'ato Uito ti yt mio tã are'e hin i woro­ho'omu'e e ma'ato Uito ti mio tã are — Yt karamuo tei'o ehary'i etoiat e'aito etoiat are ra'yn woro­ho'omu'e e. Ma'ato etoiat ehary'i e'aito mi'i pote ti aru yt naku i kahato etunug Tupana wanẽtup hawe are ra'yn katu­pono etoiat ehary'i e'aito mi'i hawyi ti meiũran wẽtup ok wywo i ra'yn e'aito ehary'i. Mi'i hawyi ti typy e'aito ehary'i rakano ra'yn ereĩne'en Tupana wanẽtup hawe e. Pyno yt naku i ti mi'i tã are e Iesui. I'ewyte are'e mesuwe ma'ato ehary'i e'aito hewaire hewaire toĩne'en irania'in wywo rakano mote waku etoiat ehary'i e'aito are ma'ato mi'i e hap ete yn mesuwe are. Pyno Uito yt sa'awy'iwuat nagnia yt e hap ewy hin i woro­ho'omu'e. Mi'iria ti eimu'e — Waku etoiat ehary'i waku etoiat e'aito morekuat ehay miwan miat upi yt etiky'esat i po'og i pote i'atu'e sa'ag. Ma'ato Uito ti uiweupi ra'yn uhehay. Pyno yt karãpe i tei'o etoiat ehary'i e'aito are ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Watikuap ta'yn aikotã sa'awy'i nagnia ainãpin kahato — Etunug no mi'i tã aru — Atunug e'e hap Tupana set upi ewy i'atu'e hap. Pyno waku wato'e miit'in ehamo — Yt atunug aru i mio tã ui'e hap mi'i pote ti aru waku ra'yn Tupana uhaty'i haty'i waku wato'e wuat'i ehamo i'atu'e aha'ase'i'in ahepe miwan me. ");
INSERT INTO mavNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma'ato Uito ti yt nagnia sa'awy'i­wuaria e hap yt ewy i ra'yn ahenoi ehepe e. Uito ti atiky'esat etunug yne e'e hap ewywuat. Waku ti watunug ai'e hap are e. Pywo pe yn ihay rakat. ");
INSERT INTO mavNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","— Atunug aru wato'e pote waku watunug ai'e hap ok tã e Iesui. Pyno yt naku i watu­we­pehik ai'e hap ete nagnia aimu'e hap ewy — Yt atunug aru i pote waku mesuwat mytyp ui'apiheg. Yt naku i watu­we­pehik ai'e hap ete — Atunug aru ai'e hap ete are. — Pyno waku ra'yn aru uimikoi ko'i uiko piat topap yne yt atunug aru i ui'e hap ewy ai'e hap yt naku i wato'e are katu­pono mesuwat mytyp ti Tupana pu'ap hap are katu­pono mesuwat aiko ko'i i'ewyte ahe'yi mesuwe yt aiwat hin i are. Ta'i Tupana wat ko'i wyti are e. Pyno yt naku i ti aheso hap wati­pehik Tupana set upi are — Yt atunug i pote waku tawa wato Ieru­sarẽi piaria ui'apiheg yt ere'e tei'o katu­pono tawa wato Ieru­sarẽi ti yt aiwat i Tupana wuanuat i'ewyte mekewat Tupana Mipo'oro Wuat'i Porekuat Porekuat nuat etawa ti Ieru­sarẽi topyhu'at pãi are e Iesui tuwepe. ");
INSERT INTO mavNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","— Ma'ato aheso pote aru waku ui'asap kytsig nakat topyhu'at yt etipehik tei'o — Atunug aru ai'e hap ete katu­pono yt uwe i ti inug kuap ai'asap ikytsig hap tuwa­nẽtup hawe are e. Yt uwe i inug kuap tuwa­nẽtup hawe to'apyig hap are. ");
INSERT INTO mavNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pyno waku atunug aru ai'e hap yn mi'i hawyi waku watunug ai'e hap ok tã are e Iesui. Ma'ato yt watunug neran i pote — Atunug aru yt wato'e i waku e. Mi'i pote ti aru pywuat sehay yn tuwẽtem aiwẽ pyi are katu­pono pywuat sese sehay yn atiky'esat uipot­mu'eria wẽ kaipyi are e. Ma'ato yt pywo piat i — Atunug aru ewei'e mi'i pote ti aru ta'i ahiag ehay upiat myhu'at haria wo eweipyhu'at are e Iesui topot­mu'eria pe yity'ok totiaria to'apy­pueri haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ta'i watikuap kahato ti aikotã sa'awy'i nagnia ainãpin hap e. Mio tã i'atu'e miwan me — Karãpe wẽtup ok eha apok e'ahyk hawe mi'i pote waku era'apyk etiha'apok eha apok sa'up mo e. I'ewyte karãpe wẽtup ok eiãi pik ahyk hawe mi'i pote i'ewyte era'apyk etihãipik mi'i hat i'atu'e sa'awy'i nagnia ahepe ainãpin hap e. Ma'ato Uito yt mi'i tã are hin i ra'yn woro­ho'o­nãpin e. Pyno karãpe wẽtup ok ai'ahyk mi'i pote waku yt watu­wepyk hin i are e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","I'ewyte ewanĩkap eete tunug sa'ag mi'i hat i'ewyte wy yt erepyk tei'o are ti Uito woro­ho'omu'e yt sa'awy'iwuat nagnia yt wo'omu'e hap ewy i ra'yn e. I'ewyte epo sese kawiano wẽtup ok eowa pe ete e'ahyk mi'i pote yt erepyk tei'o ma'ato mio tã ere'e ro e'ahyk hat pe — Pyno waku kokai i ro uipo ran kai i'ewyte waku ui'ahyk mehĩ mana waku wato'e e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Uito ti yt woro­nãpin hin i irania'in ewy. Mio tã yn are'e — Yt etipoepyk tei'o are aikotã aikotã sa'ag nug etiat hat are. Karãpe ewanĩkap ewa pe tek mi'i pote o kokai ere'e na'yn are. Karãpe ewanĩkap epohari teran ekat ete mi'i hawyi yt epy'ahak tei'o ewanĩkap ete are e. Mi'i hawyi waku ekat imiky'esat ewy etum po'og imiky'esat kai are e. Ewanĩkap tiky'esat e'yni pote etum. Esokpe toiky'esat pote etum. Ekamisa toiky'esat pote etum. Ma'ato waku po'og na'yn imiky'esat kai etum are. Toihep ekamisa hawyi waku i'ewyte esirara etum uimohey hap moherep hamo e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","I'ewyte karãpe ewanĩkap to'e — Etioto ro uhekare'en e my'ahaktu e mi'i hawyi waku perup'i puo — Ta'i mehĩ mana emiky'esat ewy atunug waku wato'e perup'i puo. Mi'i hawyi waku imiky'esat sakpuat ewetunug uimohey hap moherep ewanĩ­kaptia iky'e hap moherep hamo e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","— Karãpe wẽtup ok hẽtup ekare'en kat ko'i kat ko'i mi'i pote waku etum imiky'esat ewy are uimohey epiat hat moherep hamo are e. I'ewyte karãpe wẽtup ok tipuru ekat ko'i pote waku etipuru ekat tope uimohey epiat hap moherep hamo iky'e hap moherep hamo are'e e Iesui temiit'in me yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mi'i hawyi Iesui to'e i itotiaria pe — Mio tã e miwan me sa'awy'i­wuaria ainãpin hanuaria — Waku ti aiwyria'in sese yn wati'a­tuky'e kahato i'atu'e ma'ato ti waku ahewa­nĩ­kaptia ete haiwot takat ewy ipy'ahak takat ewy watoĩne'en i'atu'e sa'awy'iwuat ainãpin haria. ");
INSERT INTO mavNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma'ato Uito wẽtup sehay wo woro­nãpin yt i'atu'e hap ewy i. Uito ti mio tã are woro­ho'o­nãpin e. Pyno ewei'atuky'e ro ewanĩ­kaptia are. Pyno waku ahaty'i haty'i haria upi wahẽtup Tupana pe — Eti'atu­poi­tyro o uhaty'i haty'i haria Papai waku wato'e are'e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mi'i tã watunug mote aru Ai'ywot atipy piat sa'yru'in saki'yt'in no wato­pyhu'at kahato katu­pono ti Ai'ywot atipy piat ti'atuky'e kahato tewa­nĩ­kaptia are e. Ta'i toimo­herep kahato i'atuky'e hap katu­pono toipo'oro i'aman at i'atu­mikoi moehãite hamo e. Ta'i toi'atu­poi­tyro yt toky'e hin i haria are. Ta'i Ai'ywot atipy piat ti'atuky'e kahato tewa­nĩ­kaptia torania e. Yt nakuat i nug haria ko kape toipo'oro i'aman at toky'e haria mikoi ko'i poityro hamo ma'ato i'ewyte yt toky'e haria i mikoi ko'i kape toipo'oro wy i'aman at i'atuky'e hap moherep hamo are e. Pyno to'o'ewy'ewy toi'atuky'e towyria'in tewa­nĩ­kaptia are e. Mi'i tã ewy ti Tupana toĩne'en e. Pyno waku Tupana ewy watunug. Ewetunug wakuap yne miit'in me Ai'ywot atipy piat minug ewy waku watunug are e. Mi'i tã watunug mote ti aru irania'in te'eraha'at ahepiat miit'in yne ky'e hap kape hawyi ti aru te'eru­wa­nẽtup hawyi — Ta'i Tupana sa'yru'in Tupana saki'yt'in mote ti meke tã ta'atuky'e miit'in i'atu'e wyti aru e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Katu­pono ti mesu­wa­ro­tiaria yt Tupana mohey haria i tiky'e ta'atuky'e haria sese yn e. Ma'ato yt ta'atuky'e i haria ti yt ta'atuky'e i ra'yn e. Ma'ato mi'iria ewywuat eiky'e haria yn na'yn ewei'atuky'e miit'in mote ti aru mesu­wa­ro­tiaria ewy eweipyhu'at are e. Aiky'e haria yn wati­po­wyro pote yt Ai'ywot atipy piat yt ewy hin i wato­pyhu'at are e. Iwese rakaria wo watoĩne'en ahepiat iwese haria kape yn mote yt kat i ha'up wati­puẽti aru Ai'ywot atipy piat kaipyi are e. Ta'i marak'aria ti'atuky'e kuap ta'atuky'e haria ma'ato atiky'esat ewei'atuky'e kahato yt eiky'e hin i haria are. ");
INSERT INTO mavNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","I'ewyte ti waku wati'a­tu­wesat wuat'i miit'in are e. Yt naku i wati'a­tu­wesat aiwyria'in yn are katu­pono ti yne ti mesuwat yi tote ta'atu­wyria'in wesat kuap are. I'ewyte yt Tupana mohey haria i iwesat kuap ta'atu­wyria'in are. Pyno waku ti yne wati'a­tuky'e are e. — Pyno ereke uhyt mana mimi wato'e aiky'e haria pe yn mote mesu­wa­ro­tiaria ewywuat watoĩne'en katu­pono mi'iria ti ta'atu­wyria'in ta'atuky'e haria sese pe yn — Ereke ro era'apyk mehĩ mana aimi'u ra'yn i'atu'e ma'ato yt ta'atu­wesat i ta'atue­wa­nĩ­kaptia are. Ma'ato mi'i tã aito pote i'atu'e­wywuat wato­pyhu'at mesuwe yi tote irania'in yt Tupana mohey haria i ewywuat e. Yt naku i rat mi'i tã aito pote are e. ");
INSERT INTO mavNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pyno waku wato­pyhu'at hãpyk kahato rakaria wo aikotã Ai'ywot atipy piat waku rakat ewy waku watunug are e. Ai'ywot atipy piat Aiky'e kahato hano toĩne'en are e. Iwese kahato iperup'i kahato tewa­nĩ­kaptia ete towyria'in ete are e. Pyno waku Tupana ewywuat kahato wato­pyhu'at mesu­wa­ro­tiaria ky'e hap upi are e. Pyno toran na'yn mesup einãpin hap e Iesui ahepe tomohey haria pe mekewat yity'ok tote miit'in sem toi'atumu'e hap tote. ");
INSERT INTO mavNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Pyno ti mi'i hawyi po'og Iesui to'e miit'in sem me yity'ok tote — Uiwyria'in e pyno yt naku i kahato watu­we­mõ­typot Tupana potpap watunug turan e. Yt naku i kahato miit'in ehamo miit'in miat aimõ­typot hamo wewo'i watunug Tupana potpap turan e. Pyno waku ti Tupana potpap watunug imõtypot hamo yn e. Pyno waku Tupana mõtypot hap yn aiwa­nẽtup hawe watunug imiky'esat ewy. Ma'ato aimõ­typot miit'in kaipywiat hap yn watikat pote yt kat i aimõ­typot hap sese wati­puẽti Ai'ywot atipy piat kaipywiat e. Pyno waku miit'in wati'a­tu­po­wyro kat ko'i kat ko'i hap ete ma'ato aiwa­nẽtup hawe yt aimõ­typot hamo i e. Waku Ai'ywot atipy piat mõtypot hamo aiwa­nẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mi'i pote karãpe hatek takat put'ok'e ahowawi mi'i pote waku wati­po­wyro kahato ma'ato yt miit'in miat aimõ­typot hamo i waku wati­po­wyro e. Ma'ato Yt naku i aiwa­nẽtup hawe — Atipo­wyro mi'i miit wuat'i ehamo uimõ­typot kahato miit'in mesuwe hamo pãi yt naku i wato'e e. Yt naku i ahehay aiwa­nẽtup hawe aremo­wato wuat'i ehamo uiminug waku ko'i wo e. Yt naku i aito typy wanẽtup haria ewy watoĩne'en e. Kat pote mi'iria ti Tupana mõtypot yat pe tuwehyt'ok kahato Tupana mõtypot haria ewy te'eru­wa'a­tunug ma'ato yt pywo piat i katu­pono — Uimõ­typot mono ta'atu'e hap yn ta'atu­wa­nẽtup hawe e. Mi'iria ti to'owatka'i ti Tupana mõtypot hamuat tuwak hamo — To'iro to'iro Tupana mõtypot hamo i'atu'e i'atuehay ma'ato yt pywo pe i katu­pono i'atupy'a pe — Uruto ti po'og eikai Tupana mohey haria i'atu'e ta'atu­wa­nẽtup hawe yt kat i Tupana mõtypot sese hap i'atukai e. Ta'i mi'iria wyti getap upi upi oken upi upi Tupana mõtypot hap ta'atunug te'eru­wepe te'eru­wa­nẽtup hawe — Uruto po'og urumõ­typot urumohey ta'atu'e haype e. Mi'iria ti te'eru­wa­nẽtup hawe ti typy wanẽtup haria e. I'ewyte ti miit'in ehamo oken upi getap upi ti ta'atu'a­tumu'e Tupana ehay miit'in me haty wo ma'ato miit'in ehamo — Waku uimõ­typot miit'in ta'atu'e haype e. Pyno pywo pe ti are'e mi'i hap ewy ewetunug mote wyti aru yt kat i ti aru Tupana kaipywiat eimõ­typot hamuat e. Miit'in mimõ­typot ko'i yn eweikupte'en mesuwe wen ma'ato yt karãpe i aru Tupana mimõ­typot wo eweikupte'en e Iesui miit'in sem me yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mi'i hawyi po'og Iesui to'e itotiaria pe — Uiwyria'in waku kahato wati­po­wyro ihaky'e'i rakaria Tupana ehamo ikuap hamo e. Karãpe satek poria wati'a­tu­po­wyro waku watum i'atu­po­wyro hap mig'i wo are yt uwe i mikuap mo i ahepiat e. Waku Tupana kape yn aheha imõtypot hamuat. Waku ti yt wahenoi i aimiium mekewat ahepiat miit'in powyro hap wuat'i pe aiwe­mõ­typot hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Waku ti Tupana kapiat aiwa­tetup hap wywo yn wati'a­tu­po­wyro miit'in e. Yt naku i wahenoi henoi irania'in me kat kat hap watunug Tupana mõtypot hamuat e. Waku ti Tupana kapiat aiwa­nẽtup wywo yn wati­po­wyro ihaky'e'i rakaria e. Ai'ywot atipy piat ta'akasa kahato yne aiminug mig'i wuat ko'i e. Mi'i pote waku Tupana ehamo wati'a­tu­po­wyro irania'in e. Waku Tupana tuwehum ahepe hap yn watikat e. Waku aheha Tupana kape yn watunug waku irania'in powyro hap turan e. Waku wati'a­tu­po­wyro miit'in Tupana ehamo Tupana mõtypot hamo e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","— Uiwyria'in ahehay Tupana kapiat ahehay ikahu rakat irania'in ehamo aiwe­mõ­typot hamo uito po'og Tupana kapiat uhehay ikahu rakat e kuap takat eikai ai'e hap aiwa­nẽtup hawe yt naku i ahehay e. Yt naku i typy ahẽgu wywo ahehay Tupana kape miit'in miat aimõ­typot hamo aiwe­mõ­typot hamo e. Pywo ti rat irania'in mesuwat yi totiaria i'atuehay kahato Tupana mõtypot hawe miit'in me i'atuehay se Tupana kape ma'ato yt pywo pe i i'atuehay e. Aikope aikope miit'in te'eru­wa'a­tunug hap tote i'atuehay pot'i kahato Tupana kape — Waku uimõ­typot miit'in ta'atu'e haype. Pyno eiwe'eg wo o miit'in miat eimõ­typot hap pupi are katu­pono miit'in miat ne'i eimõ­typot hap eweiky'esat pote mi'i yn topyhu'at eha'up mo e. Mi'i hap kape eiwe­wa­nẽtup pote yt kat i i Tupana kaipywiat Tupana wehum ehetiat hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pyno waku karãpe ahehay teran Tupana wywo pote waku wateke aikope aikope miitin yt uwe i ikuap ehamo i waku ahehay Tupana kape mig'i wo yt heremo pyi i ahehay Ai'ywot yn ikuap ahehay e. Mi'i hawyi Tupana tikuap ahehay mig'i wuat aipy'a pe pote Tupana tuwehum kahato ahowawi hawyi tutum ahepe aimiẽtup e. Ta'i mig'i wo wahẽtup wen ma'ato meiũran tutum na'yn aimiẽtup hawyi heremo kahato topyhu'at Tupana miium ko'i wuat'i ehamo e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Uiwyria'in karãpe miit'in py'asetpiat ahehay Tupana kapiat turan yt naku i wato'e aipy'a pe — Uhehay se Tupana kapiat pote mono miit'in mimõ­typot no ra'yn areĩne'en yt naku i wato'e e. Mi'i tã wato'e aiwa­nẽtup hawe pote typy ihay rakat ewy wato­pyhu'at e. Yt naku i typy ihay rakaria wo watoĩne'en katu­pono mi'iria Tupana kapiat ta'atuehay turan i'atuehay ywop kahato miit'in miat ta'atuehay ikahu kahato rakat hap kuap hamo i'atuehay. Yt naku i mi'iria ewy wato­pyhu'at Tupana wanẽtup hawe e. Ta'i tukupte'en miit'in mesu­wa­ro­tiaria ihay su'at at ka'ap haria i'atuehay kahato Tupana kape wẽtup sehay ahut ewy ta'atu­wẽpap kahato e. Yt atiky'esat i uimohey haria ahut ko'i ewywuat i'atu­misu'at su'at ko'i e. Waku aipy'a pyi ahehay Tupana wywo e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Waku ahehay Tupana wywo wen ma'ato ti yt naku i hupi te i hupi te i wahu'at wahu'at sehay Tupana kape are katu­pono mio tã ehehay Tupana wywo pote irania'in yt uimohey i haria ewywuat eweikupte'en e. Pywo pe ti Ai'ywot atipy piat tikuap kahato aimiẽtup tewawiat wahẽtup hap e'yianmete toikuap ta'yn kat ko'i kat ko'i aimiẽtup ko'i toikuap. Toikuap sakpo aimi­ky'esat sese ko'i katu­pono hewaure ka'a kahato ahehay kape aiwa­nẽtup hap yt wahẽtup i te pytkai e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Uimohey haria woro­ho'omu'e teran aikotã ahehay Tupana wywo hap ahenoi teran e Iesui. Waku pyno wato'e ");
INSERT INTO mavNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Uru'ywot atipy piat uruiky'e kahato En e. Tupana pywo pe ti ikahu kahato eset Tupana. Eset ri po'og ikahu torania kai uruipuẽti e. Papai uruiky'esat kahato ereĩne'en wuat'i miit'in Akag Koro wo mesuwat yi tote miit'in py'asetpe aikotã ereĩne'en Wuat'i Potypot no atipy pe hap ewy hap uruiky'esat e. Papai uruiky'esat kahato torania miit'in emiky'esat ewywuat nug hanuaria wo tukupte'en aikotã atipy piaria tunug emiky'esat yn hap ko'i ewywuat hap uruiky'esat kahato mesuwe e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tupana urupoi o mesup e'at pe urumi'u wo urue'u'i wo e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tupana waure wo ereĩne'en ema'at hap ko'i kai aikotã uruto urutu­kupte'en waure wo uruma'at hap ko'i kai e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tupana uru'ykesat o pya kahato ahiag uruiã'ãg yt naku i nug hap kaipyi katu­pono urui'atoiat teran torania uruminug sa'ag hap ko'i e. Tupana En ni Wuat'i Potypot nuat wuat'i e'at pe e. Tupana En ni po'og esaika wuat'i kai e. Tupana En ni po'og po'og wuat'i mimõ­typot no wuat'i kai W A K U Pyno waku aipy'a pyi ahehay Tupana wywo. Yt naku i watu­wesu'at'i su'at'i ui'e hap ahut ewy e Iesui ahepe mekewat yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","— Pyno uiwyria'in po'og ahenoi teran miit'in miat aima'at hap waure wo hap etiat. Karãpeĩ eipe waure wo eweikupte'en eima'at irania'in miat hap ko'i kai mi'i hap ewy te Ai'ywot atipy piat waure wo ehepiat toma'at hap ko'i kai topyhu'at atipy pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma'ato karãpe ewei'e — Yt karãpe i waure wo areĩne'en uhyt'i minug sa'ag ete mimi mana minug uima'at hap ko'i kai ewei'e pote i'ewyte yt karãpe i Ai'ywot atipy piat waure wo toĩne'en eiminug sa'ag ko'i hap kai e Iesui temiit'in me yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Uiwyria'in karãpe mesuwe yt kat i watu'u ahehay Tupana wywo hap yn watunug neran mi'i hap e'at pe waku mig'i wo Tupana ehamo haype watu­we­mosy'at Tupana yn ikuap hamo e. Yt naku i wahenoi henoi irania'in me aiwe­mosy'at hap Tupana kapiat hap e. Ma'ato waku watu­we­mosy'at mig'i wo Tupana yn ikuap aiwe­mosy'at hap tewawiat ahehay teran hap e'at pe e. Yt naku i wati­mo­herep aiwe­mosy'at hap irania'in me aheha arot'i hamo ahowa arot'i hamo yt naku i wati­mo­herep — Aremosy'at kahato mesup katu­pono uhehay teran Tupana wywo at ka'ap ai'e hap. Yt naku i wati­mo­herep ahowa ete ahehay ete aiwe­mosy'at hap Tupana kapiat hap e. Ma'ato watunug mote typy ihay rakaria ewywuaria watu­kupte'en katu­pono mi'i haria timo­herep teran ta'atu­we­mosy'at hap wuat'i miit'in me. Te'eru­we­mõ­typot hap ta'atukat kahato ta'atu­we­mosy'at hap ko'i ma'ato yt naku i watu­we­mo­herep ahehay arot'i hamo ahowa arot'i hamo aiwe­mosy'at Tupana kapiat hap e. Yt naku i typy ihay rakaria ewy wato­pyhu'at e katu­pono typy ihay rakaria timo­herep teran ta'atu­we­mosy'at hap upi miit'in me ikuap hamo te'eru­we­mõ­typot hamo e. — Ta'i en waku kahato Tupana kapiat wemosy'at hat i'atu'e hap ky'ewi ta'atukat haype. Typy ihay rakaria tikat kahato miit'in wehum ta'atuetiat hap e. Miit'in wehum ta'atuetiat hap ta'atu­puẽti kahato mesuwe wen ma'ato mi'i hap yn topyhu'at i'atusa'up mo katu­pono yt kat i Tupana wehum i'atuetiat hap topyhu'at wuat'i e'at pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mi'i tupono ti po'og waku watu­we­mo­kahu yn Tupana kapiat aiwe­mosy'at hap e'at pe e. Waku watu­weo­wasei hawyi watu­we'apin hawyi watu­we­painug aikotã watunug wuat'i e'at pe hap ewy hawyi waku watu­we­mosy'at Tupana ehamo Tupana yn ikuap hamo e. Mi'i hap ewy ti waku aiwe­mosy'at Tupana kapiat hap watunug yt uwe i mikuap mo e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mi'i tã watunug mote ti yt uwe i ikuap aiwe­mosy'at Tupana kapiat hap yt heremuat i rakat e. Ai'ywot Tupana yn ikuap katu­pono ti Ai'ywot yne mig'i wuat minug ko'i ikuap yne e. Mi'i tupono ti mig'i wuat aiwe­mosy'at hap toikuap miit'in yt uwe i ikuap pytkai i. Mi'i hawyi Tupana tuwehum ahete hawyi tutum ahepe aimiẽtup sa'up ahepe wuat'i ehamo e Iesui ta'apy­pueri haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Uimohey haria yt naku i mesuwat yi tote yn ahekare'en e. Yt naku i ahekat mo wato hap kape yn watu­we­wa­nẽtup at ka'ap e. Mesu­wa­rotiat yn ahekare'en mote meiũran aru yt kat i topyhu'at atipy pe e katu­pono mesu­wa­rotiat ahekat yn tukupte'en mote meiũran tuwei­motyk yne ahekat katu­pono ahekat mesu­wa­rotiat yt tukupte'en mot'i hin i e. Uiwyria'in mesu­wa­rotiat yn ahekat pote meiũran sero'ok'e haria wano topyhu'at ahekat sio nupi'a mi'u wo ikahu rakat topyhu'at sio i'ytyk mi'u wo topyhu'at ahekare'en ko'i ikahu kahato sa'awy'i pytkai. Mesuwe yn wati'a­tunug ahekat pote yt kat i topyhu'at irane aru atipy pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Uipot­mu'eria pywo ti po'og waku wati'a­tunug ahekat atipy pe katu­pono iheg me kahato toĩne'en itote wuat'i e'at pe e. Itote ti yt kat i ahekat wuat'i e'at piat u kuap haria are'e yt kat i nupi'a itote. Sero'ok'e haria yt uwe i itote e. Yt kat i i'ytyk hap atipy pe e. Mi'i pote waku watum ahekat Tupana pe mesu­wepyi aimiium ko'i upi e. Mi'i hawyi toĩne'en itote. Put'okwato'e itote hawyi ti aru tutum yne aimi­po'oro ahekat e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ahekare'en watopag yne atipy pe Tupana po pe pote ti aiwa­nẽtup hap sese i'ewyte toĩne'en at ka'ap Tupana kape atipy kape e. Ma'ato mesu­wa­rote yn ahekat wati'a­tunug pote i'ewyte aiwa­nẽtup hap mesu­wa­rote yn topyhu'at at ka'ap e Iesui tomi­mu'eria pe mekewat yity'ok totiaria pe miit'in typy'i rakaria ehamo. ");
INSERT INTO mavNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","— Uheka­tu­wyria e aheha wo yn ni wata'a­kasa kuap e. Mi'i tupono ti waku aheha­pytig kahato e. Aheha ihãite pote ti waku yne heremo yne mu'ap upi katu­pono ihot'ok puat hewyry rakaria ewywuaria wo watu­kupte'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma'ato yt aheha­pytig i pote ti yt heremo kahato i kat ko'i kat ko'i ai'akasa hap ko'i yt heremo kahato i e. Mi'i e hap ewy ti yt eweimohey i pote aikotã i'ypyryp sese puo ehewyry hap ewy eweipyhu'at eiwa­nẽtup hawe e. Pywo ti rat eheha mimohey hap yt kat i Tupana akasa hap pote i'ypyryp sese puo ti rat eweikupte'en yt ihapytig i rakat ewy eiko­hye­wyry atipy kape yt Tupana mohey hap i eheha piat pote e Iesui itotiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","— Uhemiit'in pywo ti rat yt naku i kahato watunug typy ok ahetu­pana e. Yt naku i typy ok aika'iwat no are katu­pono typy ok aipo'oro motpap nug hamuat pote yt to'o'ewy hin i aipo'oro e. Mi'i hap ewy yt naku i typy ahetu­pana e. Ahete aika'iwat typy ok toĩne'en hawyi yt naku i kahato e. Pywo ti wẽtup ok yn aika'iwat pote mi'i hat watiky'e kahato. Ma'ato typy ok toĩne'en wẽtup ok watiky'e po'og hawyi wẽtup ok yt watiky'e hin i sio wẽtup ok miky'esat ewy watunug neran pote wẽtup ok miky'esat ewy yt watunug neran hin i e. Mi'i hawyi ai'akag'aia hap yn ahete typy ai'akag hawyi e. Yt naku i kahato typy aipo'oro hano e. Mi'i hap ewy kahato yt naku i kahato typy ahetu­pana hawyi e. Yt naku i watunug ahekat ne'i ahetu­pana wo e. Yt naku i kahato ahekare'en sok hap ky'ewi sese hap kape yn aipotpap hap. Ahekat ky'ewi yn toĩne'en aikai pote mi'i hawyi yt karãpe i Tupana sese watikuap e. Ahekat toĩne'en Tupana wo aheĩne'en turan mi'i pote yt karãpe i Tupana sese topyhu'at Ahetu­pana wo Aipo­typot no e. Yt wato­mohey kuap i typy ok ahetu­pana wo e. Mi'i tupono waku Tupana yn Aipo­typot Koro wo topyhu'at e. Mi'i hawyi waku Tupana miky'esat yn waku watunug e Iesui ahepe yity'ok toto. ");
INSERT INTO mavNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mi'i tupono yt naku i watu­wa­nẽtup ko'i ko'i — Aikope pyi aru aikope pyi aru aimi'u ahe'u'i ahesokpe ahesapo hy. Aikope pyi aru aikope pyi aru aheĩne'en hap ai'e hap kape yn yt naku i aiwa­nẽtup ko'i ko'i at ka'ap hap are katu­pono ti aiwepit hap sese aheĩne'en hap sese yt tut i aimi'u wato hap kaipyi e. Ta'i aiwepit hap sese yt tut i ahe'u'i kahato hap kaipyi ahesokpe kahu kahato hap kaipyi e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","— Pyno ti rat waku wateha'at weitaria ewawi i'atu­wepit hap kape katu­pono weitaria ti te'eru­wepy kahato katu­pono i'atu­wepit at ka'ap kahato yt karãpe i — Uiku'uro aru yt kat i uimi'u pote yt i'atu'e i. Waku atikoi hawyi atipirik kahato uimi'u pãi an yt pote uiku'uro uhesy'at hap upi yt i'atu'e i pytkai te'eru­wehum Tupana kape e. Yt kat i i'atue'u'i ahyt sok i'atue'y­pa­rakai tote i'atu'yat koro ko'i pe pytkai i'atu­wepit at ka'ap e. Te'eru­wehum kahato weitaria ko'i katu­pono Ai'ywot atipy piat ti'atupoi kahato torania weitaria wuat'i e'at pe toi'atue­ropat kahato weitaria e. Uiwyria'in e aito ti po'og po'og Tupana wanẽtup hawe weitaria kai are mi'i tupono kahu ahowawi po'og po'og Ai'ywot atipy piat tuwa­nẽtup weitaria ewawiat hap kai e. Ta'i po'og aito weitaria ko'i kai e. Mi'i pote waku wato­mohey Tupana ai'atupoi wuat'i e'at piat hap e. Waku wato­mohey weitaria ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yt naku i ti watu­wa­nẽtup ko'i ko'i hap — Uiku'uro apuru sio apuru yt ai'e hap kape katu­pono mi'i yt aimoieĩne'en mot'i kuap i watu­wa­nẽtup at ka'ap — Uiku'uro apuru sio apuru yt ai'e hap kape pytkai e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yt naku i ti paawato'e — Aikope aikope som ahesokpe wati­puẽti aru ai'e hap kape yn watu­we­wa­nẽtup ko'i ko'i e. Po'og ni waku watu­wa­nẽtup ipohyt ko'i kape aikotã te'eru­we­painug hap ko'i kape e. Mohyt yt te'eru­wa­nẽtup ko'i ko'i hin i — Aikope pyi aru uhesokpe e hap kape yt i'atu'e hin i e. I'ewyte ipohyt yt tuwe­sokpe pi'ig hin i at ka'ap te'eru­we­painug hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pywo pe ti are'e ehepe sa'awy'i aha'ase'i mesu­wa­rote aipo­rekuat pot Sarumãu esokpe ti kahuria kahato imehit kawiat Uru kawiat. Ikahu sese hesokpe are ma'ato morekuat Sarumãu yt put'ok'e hin i ti mesu­wa­rotiat ipohyt ko'i ikahu hap ete e. Ta'i po'og ikahu ipohyt mesu­wa­ro­tiaria mekewat morekuat Sarumãu esokpe wakuat sese kai e. Pyno yt kan hamo i ahesokpe kape yn watu­wa­nẽtup ko'i ko'i e. Waku po'og wato­mohey Tupana piat aipainug hamuat hap waku wato­mohey e. Ta'i Tupana aipainug kuap kahato hat e. Tupana ti wuat'i painug kuap hat e. Eweha'at ro pohyt ikahu kahato rakaria ko'i kape katu­pono mi'iria yne Tupana mipainug ko'i tukupte'en e. Ta'i ga'apy ko'i pohyt tutunug ikahuria yne Tupana ti'atu­painug yne e. Mi'i hap ewy Tupana aipainug kuap katu­pono aito po'og waku Tupana wanẽtup hawe ipohyt ko'i kai e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ga'apy Tupana mipainug toĩne'en mesup e. Koitywy ga'apy ikahu sese toĩne'en ma'ato mũki'ite igag na'yn hawyi ahemyp okpy sa'aria wo iku'uro hawyi igag hawyi e. Ta'i Tupana ti'atu­painug kahato ga'apy ko'i are ma'ato meiũran igag hawyi ahe'aria wo topyhu'at e. Pyno Tupana ti'atu­painug kuap yne wuat'i i'anam ko'i e. Mi'i hap ewy ti waku Tupana wato­mohey aipainug kuap hat e. Kat hamo ten ahesokpe kape yn watu­wa­nẽtup at ka'ap yt Tupana mohey i ra'yn hap wywo e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pyno yt naku i yt watu­we­mo­po­hepap i yt ahesokpe i yt ahesapo i hap ete yt aimi'u i hap ete e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Katu­pono mi'u kat hap kape sokpe kat hap kape yn te'eru­wa­nẽtup at ka'ap yt Tupana mohey haria i ra'yn e. Yt karãpe i Tupana kape i'atu­wa­nẽtup haype e. Pyno yt naku i mi'iria ewywuaria wato­pyhu'at are katu­pono ti Ai'ywot atipy piat ti'atukuap kahato yne yne kat ko'i kat ko'i aipo pe yt kat i aimi­ky'esat ko'i kape tuwe­wa­nẽtup kahato aika­wiano aipo­wyro hamo haype e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Waku po'og ti watu­we­wa­nẽtup aipy'a pe at ka'ap aikotã aru aikotã aru waku po'og atunug Tupana Uipo­rekuat no hap kape e. Waku po'og ni watu­wa­nẽtup — Aikotã aru aikotã aru waku aterut miit'in Tupana kape Ta'atu­po­rekuat no ai'e hap kape po'og waku watu­wa­nẽtup at ka'ap aipy'a pe e Iesui. Pyno ti waku po'og watu­wa­nẽtup — Aikotã aru Tupana miky'esat ewy atunug pãi ai'e hap kape yn e. Mi'i tã ai'e hap kape aiwa­nẽtup pote ti Tupana tum aru ti ahepe mekewat wẽtup kat ko'i kat ko'i aimi­ky'esat ko'i mesu­wa­rotiat e. Tupana miky'esat kape po'og watu­wa­nẽtup pote mi'i hap kaipyi aimi­ky'esat ko'i tut Tupana kaipyi e. ");
INSERT INTO mavNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","I'ewyte yt naku i watu­wa­nẽtup mesup niatpo mũki'ite wat aipotpap hap ko'i kape yt naku i watu­we­wa­nẽtup at ka'ap e. Ma'ato mesuwat e'at piat niatpo hap kape yn waku watu­we­wa­nẽtup e. Pyno yt naku i mũki'ite wuat niatpo rakat watopag mesup e'at pe e. Mi'i tã watunug mote ti topyhu'at aimo'akag'aia hap e Iesui topotmu'e haria pe yity'ok tote. Mi'i hawyi uito ahenoi mesuwe uimiwan me uito Mateu ");
INSERT INTO mavNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mi'i hawyi po'og to'e Iesui temiit'in me yity'ok tote — I'ewyte ti e yt naku i wato'e aiwa­nẽtup hawe wẽtup ok pe — Yt kan hamo i en Tupana wanẽtup hawe yt naku i wato'e e. Mio tã wato'e sa'ag miit'in aipy'a pe pote ai'e hap ewy Tupana i'ewyte — Yt naku i en e aru ahepe mekewat e'at aru karãpe uwe waku sese uwe yt naku i sese to'e hap e'at pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pyno aikotã watu­wa­nẽtup sa'ag miit'in ete aipy'a pe — Yt naku i rakat mi'i miit wato'e pote mi'i ai'e hap ewy kahato aru te'eru­wa­nẽtup sa'ag ahete ta'atupy'a pe e. Yt iwese rakaria i aito pote i'ewyte yt iwese rakaria i ai'ewy miit'in tukupte'en ahowawi e. Yt ahegyi'at i pote i'ewyte ai'ewy irania'in tukupte'en ahowawi e. I'ewyte — Mi'i miit yt kan hamo i wato'e wẽtup ok pe aipy'a pe mi'i ai'e hap ewy te ti to'e aru ahepe mekewat ai'e hap ewy mekewat aimohit e. I'ewyte — Yt naku i en wato'e wẽtup ok miit pe aiwa­nẽtup hawe mi'i pote i'ewyte ti Tupana — Yt naku i en e aru ahepe ai'e hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yt naku i ti watikat irania'in piat i'aparap hap ko'i yn e. Yt naku i wati­mohit irania'in ahehay wo aipy'a pe e. Ma'ato watikat aiwa­nẽtup hawe irania'in mi'aparap pote wato­pyhu'at aikotã yt ihapytig i rakat ewy aikotã — Meiẽwat eha pe ti toĩ wyti hu hit wato'e hap ewy ma'ato ti yt watikuap i aiwat aheha piat aria'yp pik iwato ewy toĩne'en e. Uiwyria'in kat poteĩ ewy ok eha pe etikat yt nakuat i hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kat poteĩ — Uhyt mana ere atihep teran nyti mekewat eha piat hu hit ere'e irania'in me hap ewy ma'ato yt etikuap kahato i ewy eha piat aria'yp wato toĩne'en ne eha pe. Mi'i hap ewy ereĩne'en irania'in i'aparap hap eti'atukat pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ma'ato mi'i tã ere'e pote yt hãpyk hin i ewanẽtup e. Mi'i pote ti typy ihay rakat ewy ereĩne'en e. Pyno waku ewat eha piat ri waku etihep aria'yp tek iwato rakat ewywuat eminug sa'ag ko'i hawyi ti aru pywuat ihapytig sese rakano sese ra'yn ereĩne'en e. Eiminug yt naku i ko'i ewetotiat yne pote ti ihapytig rakat ewy i ereĩne'en aru e. Ehapytig nakat ewy ereĩne'en hawyi waku etihep kuap ta'yn ewy ok eha piat hu hit ewywuat iminug sa'ag hit ko'i etihep kuap are yt pote yt aru e Iesui yity'ok totiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mi'i hawyi to'e i — Uimohey haria woro­ho'o­nãpin neran mesup ahewa­nĩ­kaptia ete e. Tukupte'en mesu­wa­rote miit'in Tupana ehay ete haiwot kahato rakaria e. Waku aiwe'eg wo o mi'iria pupi katu­pono aikotã awahuru ko'i ti'atu'uka teran ne'i aihũria ewy kahato mi'iria tukupte'en e. Pywo ti rat mesup ta'yn Tupana wanĩ­kaptia ko'i ai'auka teran katu­pono Tupana ehay moherep haria aito pote e. Ta'i aikotã hamaut ko'i ti'atu'akit reran ne'i aimikoi. Mi'i hap ewywuat kahato Tupana wanĩ­kaptia ai'akit reran ne'i e. Waku wahenoi wuat'i miit'in me Tupana ehay wakuat no are wen ma'ato waku aiwe'eg kahato wo o wahenoi mi'iria pe turan katu­pono ahewa­nĩ­kaptia mi'iria tukupte'en aikotã awahuru ewywuaria tukupte'en aihũria u haria ewy ahewa­nĩ­kaptia tukupte'en aipy'a­setpe e. Aikotã hamaut aikope hap ewywuaria ahewa­nĩ­kaptia tukupte'en aipy'a­setpe e. Mi'i pote waku aiwe'eg kahato wo o wahenoi mi'iria pe haype are aikotã yt naku i wati'a­tupoi awahu­ruria Tupana mõtypot yat mi'u wakuat ewywuat yt naku i hap ewy e. Ta'i awahu­ruria te'erenuk aimiium ete hawyi te'eru­we­morem ahowawi ahekatu'u hamo awahu­ruria e. Waku aiwe'eg kahato hap wywo wahenoi turan ai'auka teran ahewa­nĩ­kaptia e. Yt naku i ahewahi ikahu rakat wati­mo­herep hamaut uato ko'i haiwot rakaria ga'apy piaria pe katu­pono te'era'a­kasa hawyi ta'atu'akit akit ne'i hawyi yt kat hamo i ra'yn topyhu'at sa'awy'i ahewahi ikahu rakat. Mi'i hawyi ahowawi ai'akit hamo tõ'ẽ haiwot rakaria e. Mi'i hap ewy kahato waku aiwe'eg kahato wo o wahenoi Tupana ehay ahewa­nĩ­kaptia pe e Iesui yity'ok totiaria pe i'ewyte ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mi'i hawyi po'og tohenoi — Uiwy ok ko'i uheinyt'in ko'i karãpe wahẽtup kahato Tupana kape aimi­ky'esat ko'i mi'i hawyi tutum ahepe yne yne aimiẽtup ko'i ma'ato tomi­ky'esat ewy e. Mi'i tupono waku watikat kahato aikope aikope toĩne'en imiium aimiẽtup ko'i e. Watikat kahato aimiẽtup Tupana piat ko'i pote ti aru wati'a­tu­puẽti Tupana mipo'oro ko'i e. watikat aimiẽtup ko'i pote ti aru wati­puẽti imipo'oro ko'i e. Ma'ato yt wati­puẽti i pote waku wahẽtup — Tupana wato'e ta'atu­pyhyp kahato urumiẽtup ewawiat hap emipo'oro waku wato'e. Eho'o'okenhyp'ok to mu'ap hawyi waku mesuwe toĩne'en waku wato'e Tupana pe. Mi'i pote ti toho'o'okenhyp'ok hawyi wati­puẽti aru aimiẽtup Tupana piat ok tã e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pywo pe ti hẽtup kahato haria wo watu­kupte'en pote Tupana miium porera'at haria wato­pyhu'at aru e. I'ewyte Tupana miium kat kahato haria aito pote wuat'i imiium puẽti haria wato­pyhu'at mesuwe e. I'ewyte — Ere'okenhyp'ok to Tupana e haria aito pote mu'ap puẽti haria wato­pyhu'at e Iesui itotiaria pe i'ewyte ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Uhemiit'in karãpe aimẽpyt hẽtup ahepe u'i pote watum u'i tope e. Yt watum i aimẽpyt pe yi kyt ne'i — Atiky'esat kahato u'i mamai papai e pote watum na'yn aha'yru ahaki'yt u'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","I'ewyte — Papai mamai atiky'esat pira pu'i epo piat e pote meremo watimõ'ẽ e. Yt uwe i moi ne'i hum tosa'yru tosaki'yt pe hesy'at pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mesu­wa­rotiat miit'in ti yt naku i nug haria wo tukupte'en wen ma'ato ti ta'atukuap wyti ta'atu­mẽpyt'in miat wakuap ium hamuat e. Ai'ywot atipy piat ti po'og po'og wakuat wuat'i mesu­wa­rotiat miit'in kai e. Mi'i tupono miit'in miẽtup wakuat tutum kuap kahato ti e. Wakuat aimiẽtup tepiat ko'i Ai'ywot Wakuat Atipy piat ti'atuium kahato ahape e Iesui yity'ok totiaria pe i'ewyte ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sa'awy'iwuat Tupana ehay moherep haria piat ainãpin hap i'ewyte aha'ase'i Musei ainãpin hap wẽtup uhehay pe yn teke are e — Aikotã wati­ky'esat irania'in minug wakuap ahepe mi'i hap ewy waku watunug i'atuepe e Iesui temiit'in me yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Pyno ti waku ti etikat kahato mekewat mu'ap ypy kurin kat atipy kapiat are katu­pono mekewat aria kapiat mu'ap ypy wyti heremo yne e Iesui. Ta'i mekewat aria kapiat mu'ap tote ti miit'in yne ikohye­wyry kahato pote mekewat mu'ap ihot kahato e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma'ato mekewat atipy kapiat mu'ap ypy ti yt heremo i e. Eweikat kahato pote yn eweipuẽti are katu­pono mekewat mu'ap kurin kat upi ti niatpo kahato ehewyry e. Ma'ato mekewat upiat eipe pote ti put'ok'ewei'e wuat'i e'at piat eheĩne'en hap tote e. Katu­pono mekewat mu'ap yt hot i kahato pote ti yt typy'i hin i miit hewyry e Iesui yity'ok totiaria pe ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mi'i hawyi to'e Iesui itotiaria pe — Uimi­mu'eria e ewe'eg wo o mekewat Tupana ehay moherep yt pywuat piat i haria wywo e. — Uruimohey kahato Tupana i'atu'e pytkai yt Tupana ehay ewy i ta'atu­mo­herep — Uruto ti Tupana hũria ei'ewywuat i'atu'e pytkai eiwe'eg wo o i'atuehay pupi yt uiat ewywuat i pupi e. Ta'i eima'at reran haype uimohey ehepiat hap moma teran haype i aikotã awahuru tu'u teran aihũria hap ewywuaria ti mi'iria tukupte'en eipy'a­setpe eimu'e hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","I'atu­minug sa'ag ete ti aru mi'iria eweikuap e. Aikotã mekewat ahiag ẽpo yt hum i ti he rakat ahepe mi'u hap ewy mi'iria tukupte'en e. I'ewyte yt karãpe i wati­puẽti mekewat hu ẽpo ete he rakat ywa ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pyno karãpeĩ aimikoi upi'a i'atue­hãite kahato hawyi meiũran i'atusat kahato hawyi hewo ra'yn i'ywa he kahato rakaria e. Ma'ato yt wenug i hat aimikoi haat sa'ag kahato yt he i i'ywa hap ewy e. Mi'i hap ewy kahato Tupana ehay wẽtup aimu'e haria tukupte'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ma'ato mekewat wenug kahato haat wyti yt karãmuo i haat sa'ag nakat ne'i e. Haat kahato yn topyhu'at e. Ma'ato yt ihãite i rakaria ywa ti yt mi'u wo hin i ra'yn topyhu'at. Mi'i ti yt watu'u kuap i ra'yn i'ywa haat sa'ag nakat ne'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pyno mi'i meiũran — Yt kat hamo i ra'yn meiẽwat i'ywa yt hẽ'ẽ kahato i rakat meiẽpe wato'e. Pyno waku ahe'aria wo ra'yn mi'i yp yt aipoi i pote wato'e hawyi wati'y­pytek yt naku i rakat e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ta'i watikuap kahato ti mikoi ypia i'ywa he hap upi sio wakuat ypia sio yt naku i rakat ypia hap watikuap kahato aito e. Mi'i hap ewy kahato te ti watikuap pywo piat Tupana ehay enoi haria sio aima'at haria ta'atu­minug wakuap upi sio ta'atu­minug yt naku i hap upi wati'a­tukuap mi'iria e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Katu­pono ti i'atu kahato miit'in uhehay su'at kahato haria — Uika'iwat kahato En Uika'iwat kahato En i'atu'e uhepiat haria ma'ato yt pywo piat haria i mio tã i'atu'e ehepe aru ehekat ky'ewi eima'at haype e. Pywo ti mi'iria yt karãpe hin i te'eru­wehyt'ok aikope Tupana toĩne'en Morekuat no hap tote aru are katu­pono ti itote Ui'ywot miky'esat nug haria yn wyti te'eru­wehyt'ok e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ta'i mekewat wehyt'ok hap e'at pe ti aru typy'i itote — Ihot'ok Uika'iwat waku kahato En i'atu'e. Uika'iwat kahato En i'atu'e haria itote tukupte'en ma'ato yt uimikuap ko'i i yt Ui'ywot miky'esat nug haria pytkai mio tã i'atu'e — Ta'i uruto ti eset moherep kahato miit'in miat haria ti i'atu'e. Miit'in mu'e kahato haria urutu­kupte'en itote i'atu'e ti aru wehyt'ok hap e'at pe. — Uruka'iwat eset no ti mã'ãu sa'ag ko'i uru'atu­sopo kahato miit'in pywiat haria ti uruto i'atu'e ti aru wy. Ta'i i'ewyte karania wo i wyti urutunug wakuap yt uwe misepap ewywuat i wuat'i ehamo miit'in mowa­nẽtup kahato hamo itote urutu­kupte'en turan i'atu'e ti aru wy uhepe. Mi'i tupono ti waku Uruka'iwat urutu­wehyt'ok atipy pe i'atu'e aru. Waku ahewaku hap upi wato­pyhu'at atipy pe aikope Tupana toĩne'en Wuat'i Akag wo hap tote i'atu'e ti aru uhepe at. Uruto waku pote waku watu­wehyt'ok atipy pe i'atu'e aru uhepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma'ato ti aru mi'iria pe are'e — U pãi uhyt mana yt karãpe hin i ti woro­ho'okuap eipe are'e ti aru i'atuepe. Eweiwat ro meiũpepyi pya ui'yaty­pepyi are ti aru mi'iria pe katu­pono yt nakuat i nug haria ti eipe are ti aru yt uikuap i sese haria pe e Iesui irane mekewat wehyt'ok e'at hap etiat. ");
INSERT INTO mavNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Uiwyria'in pywo ti rat uwe uwe ikuap ui'e hap hawyi topyhu'at ui'e hap nug hat mi'i Tupana mimowe'eg kahato rakano topyhu'at e Iesui. Pywo ti rat uwe uwe uhehay nug hat mi'i hat topyhu'at aru aikotã iwe'eg kahato getap nug kuap kahato hat ewy wyti aru toĩne'en aikotã — Are pãi are an pyno sig waku atunug ui'yat meiũpe yi heg kahato tote e hat ewy toĩne'en aikotã — Yt naku i yẽpeke are'yatnug ywyku'i pe e hat ewy toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ta'i toĩne'en wy yẽpeke we'yatnug haria ywyku'i upiaria ma'ato karãpe put'ok'e i'aman ipopit kahato hawyi ti aru ywytu uato at ka'ap hawyi ihy wato meremo hawyi yẽpekiat yi kyt rotiat we'yatnug hat yat pe teke ra'yn y'y yẽpekiat getap we e. Mi'i turan wasere wato i ra'yn hawyi y'y ihyeput haty wo ra'yn hawyi meremo meiẽwat getap toihep. Mi'i hawyi yt kat i ra'yn topyhu'at itotiat e. Ma'ato mekewat yi heg notiat we'yatnug hat yat yt toihep hin i e katu­pono mekewat yi nu ewy iheg kahato rakat rotiat i'yat pote e katu­pono tuwa­nẽtup mo kahato tutunug getap pote e. Mi'i hat ewy ti te'ero­pyhu'at uhepiat ta'atu­nãpin hap nug haria e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ma'ato uwe uwe uhehay ta'atukuap hawyi — Ta'i yt atunug neran hin i uito pãi an e haria ti aru tukupte'en yt we'eg haria wo i e. Aikotã yt tuwe'eg wo hin i tuwe'yatnug yi kyt pe hat ewy. — Waku ra'yn ui'yat atunug yẽpeke e hat ewy yi og notiat e hat ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aikotã i'aman kahato hawyi ihy wato meremo ra'yn y'y hawyi teke ra'yn i'yat pe toine'en y'y ẽpe ete pote. Mi'i pote meremo y'y tipugha kahato mekewat yat hawyi wasere teke kahato i'yat pe hawyi toi'ypyhep i'yat e. Ta'at ra'yn hawyi i'aporok'e ra'yn hawyi yt ikahu hin i ra'yn i'yat e. Mi'i hap ewy ti yt uimohey i haria te'ero­pyhu'at uhepiat ta'atu­nãpin hap yt nug i haria e Iesui miit'in sem me yity'ok totiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mio tã e pote itotiaria te'eru­wa­nẽtup kahato hawyi te'ero'e to'ope — Ta'i yt uwe i po'og meiẽwat Miit kawiat ainãpin kuap kahato hat i'atu'e Iesui piat pe katu­pono yt irania'in Tupana ehay wani wani e haria piat yt aimu'e hap yt ewy hin i tig Mi'i Miit aimu'e i'atu'e katu­pono irania'in ti aimu'e kat i'atu'e kat i'atu'e irania'in aimu'e hap ewy yn aimu'e i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ma'ato Iesui ti tuweupi ra'yn aimu'e Morekuat Koro ewy i'atu'e. Pywo ti rat Iesui aimu'e aikotã Tupana wẽ ewy ihay i'atu'e to'ope yity'ok totiaria Iesui mienoi kuap haria. ");
INSERT INTO mavNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mi'i hawyi Iesui ipot'apyk i ra'yn yity'ok totepyi topot­mu'eria sem wywo. ");
INSERT INTO mavNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mi'i turan wẽtup ok Iesui owa kape tut hepihi pihi rakat. Mi'i ti tuwe­pỹ'ã­tutuk Iesui mõtypot hamo to'e hamo — Uhyt atiky'esat kahato uimoe­hãite epiat hap e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mi'i hawyi tuwe­ponug hepihi pihi rakat piit ete hawyi — Ta'i atiky'esat kahato ehãite hap e. Pyno woro­moe­hãite ra'yn mehĩ e hawyi meremo hepihi pihi tuwetyk yne ra'yn tokã'ã meremo ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mi'i hawyi Iesui to'e tomi­moe­hãite pe — Ereto ro pa'i ko'i kape hawyi etimo­herep to i'atuepe emoehãite epihi pihi mokã'ã hap e. Yt ehenoi henoi tei'o mu'ap upiaria pe emoehãite hap uhepiat ma'ato ereto hãpyk o pa'i ko'i kape hawyi — Pywo i'atu'e hawyi waku etum ehũ i'atumi'u wo are aikotã sa'awy'i aha'ase'i Musei aimu'e hap ewy e. Mi'i hap kaipyi ti aru yne itotiaria ikuap pywuat uhepiat emoehãite hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mi'i hawyi Iesui teke tawa Kawana'ũ me i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Mi'i turan put'ok'e surara akag sese tapy'yia Humanu ywania. Mi'i hawyi to'e Iesui pe — Uipo­wyro o uhyt e katu­pono uhemiit sese i'ahu kahato toĩne'en e. Mio ra'yn topyhu'at kahato te'yni pe ui'yat pe e. Yt naku i sakpo tuete Mehĩ e. Uhemiit uiwy ho'opot kahato Uhyt e. Ta'i yt tuwe­mokup kuap i ra'yn Uhyt e. Mi'i pote ti imoehãite hap atiky'esat kahato ekaipyi Mehĩ e. ");
INSERT INTO mavNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mi'i hawyi — Pyno areto eupi hawyi atimoe­hãite emiit itote e Iesui surara akag me. Mi'i hawyi surara akag to'e Iesui pe ");
INSERT INTO mavNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","— Yt naku i ereto ui'yat kape Uhyt kat pote uiat uhewaku hap yt put'ok'e i ui'yat piat ereke hamo Uhyt e. Waku po'og meiũpepyi yn etimoe­hãite uhemiit ehay wo e. ");
INSERT INTO mavNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Katu­pono uito areĩne'en surara'in sem po'oro hat e. Ta'i uiat uhemiit sem kahato tukupte'en e. Ta'i i'ewyte ui'akag ko'i tukupte'en more­kuaria ko'i e. Atunug kuap kahato i'atu­mi­ky'esat wy e. I'ewyte atipo'oro kuap kahato mesu­wa­ro­tiaria uhemiit'in sem e. Ta'i surara'in me are'e — Eweiwat ro kuepuo are pote meremo tuwat kuepuo ui'e hap ewy e. I'ewyte irania'in me are'e pote — Eweĩ'ẽ ro meikowo uhowawi are pote meremo tõ'ẽ uhowawi uhepiat ta'atu­po'oro hap ok tã e. I'ewyte ti uhemiit'in sese ui'yat piat pe are pote — Etunug no mi'i tã ui'e pote ta'atunug na'yn meremo uhepiat topo'oro hap ok tã e. Mi'i hap ewy En meiũpepyi ehay wo — Ehãite ro ere ui'yat piat uhemiit i'ahu kahato rakat pe pote taren meremo ihãite ra'yn itote e'e hap ewy ehay po'oro hap ok tã e mekewat Humanu ywania esurara akag Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mi'i to'e hawyi Iesui tikuap surara akag koro ehay hawyi tuwa­nẽtup kahato ihay kape hawyi toikuap kahato tomohey hap e. Mi'i hawyi tuwe­morem hawyi to'e toupiaria pe — Uhyt'i'in mana'in e aito ti Iuteuria aito ma'ato mesuwat meiũwat surara akag wẽtup ywania toĩne'en e. Eiperia uimohey ma'ato mesuwat Humanu ywania po'og po'og ti uimohey hat toĩne'en ai'ywania Isareu ywania kai e. Mi'i ti yt ai'ywania hin i wen e Humanu ywania ti mi'i wen ma'ato mi'i pytkai ti po'og uimohey ai'ywania kai e. ");
INSERT INTO mavNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mi'i pote eiwe'eg wo o ui'ywania uimohey hap wywo are katu­pono yt uimohey i ehepiat pote meiũran ti aru irania'in ywania mimohey kahato wo arepyhu'at mesuwe e. Pywo pe ti rat meiũran aru karãpe Tupana toĩne'en Wuat'i Porekuat no mi'i hap kape tõ'ẽ tõ'ẽ kahato irania'in ywania aikope pyi aikope pyi e. Mi'i hawyi ti aru mi'iria te'era'apyk aikope Tupana toĩne'en Morekuat eypa­rakai kawiano aikope ienuk hap tote e. Aikope aha'ase'i koro Aparãu apyk hap kawiano aikope aha'ase'i pot Isaki apyk hap kawiano aikope ai'ywania 12 ywania aha'ase'i Iako apyk hap kawiano ra'yn te'era'apyk wẽtup ywania uimohey rakaria e. Ta'i eiwe'eg wo o katu­pono ui'ywania eipe pytkai yt uimohey haria i kahato eipe pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mi'i pote ewe'eg wo o ui'ywania e katu­pono yt uimohey i haria wo eweikupte'en Tupana mipun ko'i ewywuaria eweikupte'en aru aikope i'ypyryp sese hap tote aikope kak'ewei'e kak'ewei'e hap tote aikope kyry'et kyry'et'ewei'e haty pono hap tote eipugha eipe uimohey sese hap pun haria eipe hawyi e. Ma'ato meiũwat surara ywania ewywuaria tukupte'en kahato aru atipy pe uimohey sese haria wo tukupte'en mote wẽtup ywania pytkai e. Mi'i pote ewe'eg wo o ui'ywania e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mi'i hawyi Iesui to'e i mekewat Humanu ywania surara akag me — Mehĩ e uimohey kahato hat en e. Pyno mio waku kahato era'aipok i ro e'yat kape katu­pono emiit i'ahu rakat ihãite i ra'yn topyhu'at mio ra'yn epiat uimohey hap ewy mehĩ e. Mio tã e hawyi toto surara akag to'yat kape hawyi toipuẽti itote temiit waku kahato ra'yn ihãite kahato ra'yn kat e Iesui yianmete tepiat hap ewy kahato ra'yn temiit toipuẽti to'yat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Irokirẽ Iesui toto topotmu'e Peteru yat kape. Itote Iesui tipuẽti Peteru sakitu i'ahu kahato te'yni pe ipiit sakup kahato. ");
INSERT INTO mavNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mi'i hawyi toto ra'yn Peteru sakitu kape hawyi tuwe­ponug hakitu po ete hawyi meremo i'ahu hap ipiit sakup hap tokosap ta'yn. Mi'i hawyi ipoĩ'ãm na'yn ipotpap ta'yn i'atumi'u nug hap ete. ");
INSERT INTO mavNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mekewat ewãtym muo ta'atue­ropo'ok kahato i'ahu rakaria ahiag ipiit piat rakaria Iesui kape. Mi'i hawyi mi'iria kaipyi toi'atu­sopo kahato ra'yn ahiagnia wẽtup yn tehay wo i'ewyte toi'atu­moe­hãite ra'yn i'ahu rakaria torania ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mi'i hawyi toi'atu­moe­hãite kahato itotiaria aikotã sa'awy'iwuat Tupana ehay moherep hat Isaia to'e hap ewy — Ai'ahu hap ti aru toimoe­hãinte topiit ahyk hap mo e. Aipo kĩ'ã hap aipy kĩ'ã hap toimog yne yne ra'yn e. Ahaty'i haty'i hap totioto yne aru pya aikai e sa'awy'i Isaia miwan 53.4 pe e hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mi'i tã Iesui ti'atu­moe­hãite kahato pote tõ'ẽ tõ'ẽ kahato miit'in po'og po'og Iesui emig hamo. Mi'i pote meremo to'e topot­mu'eria pe — To'iro meremo ihyemyi'a sakpo uheka­tu­wyria katu­pono ui'akit kuap ne'i i'ahu rakaria. I'atu­moe­hãite hap ta'atu­ky'esat kahato pote uhemig neran haria i'ahu kahato rakaria sem ui'akit irane e. ");
INSERT INTO mavNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mi'i hawyi meremo tuwehyt'ok yara piat turan put'ok'e yẽpeke wẽtup ok miit Musei e hap miwan kuap kahato hat. Mi'i hawyi tuwẽ­powat Iesui kape — Wo'omu'e hat e uipap kahato eupi emiit no e. Areto teran aikopuo aikopuo ewyry hap upi e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma'ato Iesui tiwesat — Pyno ereto teran uhupi pote waku ma'ato sa'awy'i erewa­nẽtup kahato katu­pono yt kat hin i ti ui'yat mesu­wa­rotiat toĩne'en e. Ereto uhupi pote yt kat i i getap sese ewano ewyry hap tote pãi e. Ta'i awahuru ko'i ti te'eroket ta'atuka'a puo i'ewyte weitaria te'eroket ta'atusok pe ma'ato uiat yt kat i ui'yat uiket hap sese pãi e. Miit'in Eyke'et Uito wen ma'ato yt i'yat rakat ewy i areĩne'en mesuwe uhewyry miit'in mu'e hamo turan e Iesui — Areĩne'en neran emiit no e hat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mi'i turan wẽtup ok ipotmu'e to'e Iesui pe — Pywo ti rat areto teran eupi Uika'iwat e ma'ato ui'ywot yatype te areĩne'en neran. Ui'ywot iku'uro hawyi isyp hawyi areto teran eupi e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma'ato Iesui tiwesat — To'iro uhupi uipotmu'e wo e katu­pono tukupte'en nat yt Tupana yt mohey i haria itote e'ywot syp hanuaria uhyt e. Ereto uhupi e Iesui tope. ");
INSERT INTO mavNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mi'i hawyi ipotmu'eria te'eru­wehyt'ok ta'yn yara pe Iesui upi hawyi tuwat ra'yn ihyemyi'a wato sakpo. ");
INSERT INTO mavNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tuwat turan wasere wato tut. Mi'i hawyi ihywẽ'okmoĩ okmoĩ wato'in kahato hap yara pe teke teke kahato ma'ato mi'i pytkai Iesui toket ne'i yara pe. ");
INSERT INTO mavNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mi'i pote ipotmu'eria tokoka'at ihymut hamo — Uhyt wata'apy'at hamuat ra'yn Uhyt i'atu'e haty wo. Erehymut ro urueha­kyera'at ro En i'atu'e haty wo katu­pono watopap hamuat Uhyt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mi'i hawyi Iesui tuwe­hymut hawyi — Kat poteĩ eweiken'ẽ e Iesui. Yt uimohey i te apo eipe e. Mio tã e hawyi ipoĩ'ãm na'yn hawyi to'e haty wo ywytu uato pe — Wãi ne epo'inik to y'y epo'inik to ywytu e hawyi meremo y'y ihy nik ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mi'i hawyi mehit'i'atu'e kahato Iesui minug kape ipotmu'eria. Mi'i hawyi hemiit'in te'eru­wa­nẽtup kahato hawyi — Kat kawiat kahu meiũ Miit i'atu'e to'ope Iesui piat. — Uweĩ meiũ Miit katu­ponoĩ ywytu y'y toimo­perup'i kuap kahato tomi­ky'esat ewy i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesui timo­perup'i ywytu uato hawyi meremo put'ok'i'atu'e mekewat ihyemyi'a koro sakpo mekewat tawa Karata e hap tote wo'osyp hap wã tote. Tuwẽtem yara pyi hawyi mi'i tote ahiag emiit tut Iesui ewa kape wẽtup ok towy wywo mekewat mũ'ẽ ka'a kaipyi tõ'ẽ ipy'ahak kahato rakaria. Itotiaria tawa Karata piaria gupte'en haria te'eroken'ẽ kahato meimuẽ wuat ahiagnia pupi hewyry rakaria pupi. Mi'i pote yt karãpe i tuwat mekewat wo'osyp hap kapiat mu'ap upi. ");
INSERT INTO mavNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ma'ato Iesui put'ok'e itote hawyi meimuẽwat ahiagnia ko'i te'eroken'ẽ kahato Iesui pupi. Mi'i haype to'okak'i kahato haype ta'atuemiit wẽ pyi kak'i'atu'e — Kat hamo eriot uruewawi Tupana Sa'yru i'atu'e. Yt put'ok'e i te ti uruepiat ho'opot hamuat uru'apiheg hap e'at yt put'ok'e i te i'atu'e meiẽwat miit wẽ pyi. ");
INSERT INTO mavNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","I'ewyte itote tukupte'en hamaut asuwai ko'i sem te'erenuk hap tote. ");
INSERT INTO mavNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mi'i pote mi'i ko'i ahiagnia hẽtup kahato Iesui pe — Yt naku i i'atu'e uruhep ta'yn ti meiũwat miit pyi mi'i pote ti urutu­wehyt'ok teran meimuẽwat hamaut asuwai ko'i pe ra'yn i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mi'i pote Iesui to'e — Eweiwat ro pyno meremo e pote meremo tuwenõ'ẽ hawyi tuwehyt'ok hamaut asuwai ko'i pe. Mi'i pote hamaut asuwai ko'i i'atueso'ok kahato ra'yn ahiagnia wehyt'ok hawyi. Mi'i pote hewo hewo ihyemyi'a wato pe yity'ok pyi hawyi ikohyeput'i ikohyeput'i hawyi te'ereã­py­hyka ãpy­hyka y'y pe hawyi topap yne hamaut asuwai ko'i mekewat ihyemyi'a koro y'y wato pe. ");
INSERT INTO mavNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mi'i pote hamaut asuwai apykok haria ikohyeput ra'yn tawa kape ta'atu­henoi yne mi'i tã hap ko'i tawa piaria pe aikotã Iesui ti'atu­sopo yne ahiagnia hap ko'i ta'atu­henoi. Aikotã ahiagnia ti'atu­moma ra'yn hamaut asuwai ko'i yne hap ta'atu­henoi kahato yne tawa piaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mi'i hawyi itotiaria tuwat ra'yn te'eraha'at hamo. Mi'i hawyi mi'iria te'ero'e haty wo Iesui pe — Mehĩ ereto ro meiũpepyi wẽtup tawa kape Uhyt Mimi ta'atu­hẽtup haty wo te'eroken'ẽ haype. Yt ta'atu­ky'esat i Iesui pote toto ra'yn itote pyi are uito Mateu mesuwe uimiwan me. ");
INSERT INTO mavNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yi Karata piaria yt iky'esat i Iesui ta'atue­tawa piat pote teke i ra'yn yara pe hawyi ta'aipok i ra'yn temiit'in nywo ta'atue'yara puo ta'atu­sai­pepe ihyemyi'a koro sakpo i ra'yn ta'atue­tawa pakup Kawana'ũ kape i ra'yn te'era'aipok. ");
INSERT INTO mavNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Put'ok'i'atu'e ta'atue­tawa pe hawyi itotiaria tuerut Iesui kape wẽtup ok miit ipiit iheg nakat yni pe. Mi'i hawyi toikuap ta'yn topiat tomohey haria hap hawyi to'e ipy'a heg nakat pe — Eremo­wepit ro uha'yru katu­pono mesup ti atimo­hãpyk yne ra'yn ti emi'aparap ko'i Tupana piat e. Mio wyti waure wo toĩne'en na'yn eminug sa'ag ko'i yne hap kai e. Ati'atu­mo­weityk yne ra'yn eminug sa'ag ko'i wyti e Iesui ipiit heg nakat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mi'i to'e Iesui turan ti tukupte'en wy itote Musei wo'onãpin hap kaipywiat wo'omu'e haria. Yt naku i kahato Iesui to'e mi'i tã — Ati'atu­mo­weityk eminug sa'ag ko'i e hap ewy i'atu'e yt naku i mio tã wato'e i'atu'e katu­pono watikuap ta'yn Tupana yn ni aheha­kyera'at kuap watunug yt naku i hawyi i'atu'e. Mi'i pote yt naku i Mi'i Miit meketã e hap e hamo i'atu'e te'eru­wa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma'ato mio tã i'atu­wa­nẽtup hap meremo Iesui tikuap ta'yn towa­nẽtup hap kaipyi hawyi to'e i'atuepe — Koitywy atimo­weityk yne emi'aparap Tupana piat are'e i'ahu rakat pe pote eiwa­nẽtup sa'ag apo uhowawi uhyt'i'in e. — Yt uwe i mio tã e hap inug kuap ewei'e eiwa­nẽtup hawe. — Tupana yn ni mio tã e hap inug kuap ewei'e ti. — Yt naku i mio tã ere'e pãi ewei'e ti uhete eiwa­nẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Emi'aparap atimo­weityk are'e tope pote — Yt naku i En ewei'e uhepe eipy'a pe ma'ato uhesaika kahato miit'in minug sa'ag moma hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ta'i Miit'in Eyke'et kahato areĩne'en are wen ma'ato yt uimohey hin i te eipe e. Ta'i Tupana tum yne ra'yn tesaika hap wuat'i miit'in minug sa'ag mohãpyk hamo e. Atiky'esat kahato eweikuap uhesaika hap miit'in ehakyera'at hap e. Mi'i hap moherep hamo are'e yt hewyry kuap i rakat pe ipiit heg nakat pe — Epoĩ'ãm no uiwy hawyi meremo eti'okpoi ro e'yni hawyi ewyry ro e'yat kape ui'e hap ewy e Iesui yt hewyry kuap hin i rakat pe tesaika hap wuat'i miit'in minug sa'ag moma hap moherep hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mi'i to'e hawyi meremo ipy kĩ'ã rakat ipiit kĩ'ã rakat ihãite ra'yn hawyi meremo ipoĩ'ãm hawyi toto ra'yn to'yat kape wuat'i ehamo Iesui e hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mi'i pote itotiaria te'eraha'at kahato hawyi i'atu­wepit kahato ra'yn — Urutu­wehum kahato ewawi Tupana i'atu'e itotiaria. Waku kahato En Tupana katu­pono mesup ta'yn uruehamo etum na'yn esaika hap ewywuat meiũwat Miit Iesui pe i'atu'e irania'in itotiaria. ");
INSERT INTO mavNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mi'i hawyi ti Iesui toto ra'yn tetawa pakup Kawana'ũ pyi. Mi'i hawyi mu'ap upi teha'at uhowawi. Uito ti Mateu apyk pe sa'awy'i areĩne'en itote tawa Kawana'ũ kapiat mu'ap py'asetpe mekewat pyhyp hamuat surara'in wywo morekuat piat ha'up sat wuat'i miit'in mu'ap sa'up sat hanuat areĩne'en itote. Mi'i hawyi Iesui put'ok'e itote. Mi'i hawyi Iesui teha'at kahato uhowawi hawyi to'e uhepe — Mateu e atiky'esat kahato en uhemiit no e. Ereto ro uhupi mehĩ uhemiit no e uhepe. Mio tã to'e uhepe hawyi meremo uipoĩ'ãm na'yn hawyi areto ra'yn hupi. ");
INSERT INTO mavNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mi'i hawyi ti atioto ra'yn Iesui ui'yat tote kape imoenuk ui'yat piat hamo. Mi'i hap ti typy'i kahato yt naku i rakaria wuat'i pu'ap pyhyp haria uiwyria'in tõ'ẽ tõ'ẽ kahato ui'yat kape te'erenuk hamo uimi­kaykay ko'i. Mi'iria ti te'erenuk itote Iesui wywo i'ewyte Iesui potmu'eria wywo to'otokpe tokpe yt naku i rakaria wywo uruwywo. ");
INSERT INTO mavNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mi'i hawyi ai'ywania eko nug yne haria te'eraha'at kahato Iesui kape hawyi te'ero'e to'ope — Yt kan hamo i Mi'i Miit Iesui katu­pono tenuk kahato yt naku i rakaria wywo yt aheko etiat mienoi yt ewywuat i i'atu'e. Mi'i hawyi te'ero'e Iesui emiit'in me — Kat pote som yt nakuaria i wywo emu'e hat Iesui tenuk kahato yt aheko ewy i i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ma'ato apo'i'atu'e temiit'in miat hap Iesui tikuap hawyi toi'atu­wesat — Pyno eweikuap teran apo kat pote arenuk teran yt nakuaria i py'asetpe yt eweimu'e hap yt ewy i e. Pyno ahenoi ehepe. Ta'i aikotã mohag nug haria i'ahu rakaria py'asetpe toĩne'en i'atu­moe­hãite hamo mi'i hap ewy kahato areĩne'en yt naku i nug haria py'asetpe Tupana moherep i'atuepiat hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wo'omu'e haria e eweikuap kahato yne aheko hit Iuteu ywania wãi'e hap ko'i ma'ato Tupana e hap koro sese ko'i waku eweimu'e ro e. Waku eweimu'e Tupana ehay moherep haria sa'awy'i­wuaria miwan ete aikotã Tupana to'e hap sese — Pywo ti rat yt atimorem kuap i eipe uhowawi — Uito po'og waku torania kai e haria ewei'e pote e Tupana sa'awy'i ehepiat e Iesui. — Yt atimo­hãpyk kuap i — Waku kahato ra'yn uito e haria e Tupana sa'awy'i ehepiat e. Mi'iria yt atikaykay kuap i uhemiit no e Tupana. Ma'ato irania'in — Tupana piat ati'aparap kahato uito e haria paa'e haria ati'atu­kaykay kuap kahato uhowawi i'atue­ha­kyera'at hamo e Tupana sa'awy'i miwan me yt naku i nug haria etiat e Iesui — Uruto po'og e haria pe. Mi'i hawyi to'e i i'atuepe — Pyno waku eiwemu'e i'ewyte mekewat Tupana e hap sa'awy'iwuat — Ati'atue­ha­kyera'at kuap uhepiat — Urueha­kyera'at ro e haria paa'e haria e. Ma'ato irania'in — Tupana mieha­kyera'at yn uruto urutu­kupte'en e haria yt ati'atue­ha­kyera'at kuap i e Tupana sa'awy'i e. — Uruto waku sese nug kahato e haria uruto po'og e haria yt ati'atue­ha­kyera'at kuap i e Tupana sa'awy'i miwan me e. Mi'i e hap Tupana wat kape waku eweiwa­nẽtup kahato e Iesui mekewat Iuteuria wo'omu'e haria pe to'ywania seko moherep haria pe ui'yat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iesui mio tã to'e turan put'ok'i'atu'e Iesui kape mekewat wo'oset'ok hat Iuwãu potmu'eria ko'i. Mi'i hawyi apo'i'atu'e Iesui pe — Mehĩ i'atu'e irania'in wo'omu'e haria aheko moherep haria te'ere­we­mosy'at kahato Tupana mõtypot hamo i'atu'e. I'ewyte uruto Iuwãu potmu'eria mi'iria ewy kahato urutu­we­mosy'at Tupana mõtypot hamo i'atu'e. Ta'i urutu­we­mosy'at kahato uruto Tupana mõtypot hamo ma'ato ewat epotmu'eria yt te'ere­we­mosy'at hin i uruto ewy i'atu'e. Kat pote mi'i tã eupiaria i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mi'i hawyi Iesui ti'atu­wesat — Eweikuap kat pote pyno ahenoi ehepe. Pywo pe ti rat yt uwe i mesuwat yi tote tuwe­mosy'at wo'omo­wepit ienuk koro hap e'at pe turan mekewat wo'okyi'at hap e'at ienuk koro hap e'at pe yt uwe i tuwe­mosy'at teran i i'atu­mo­wepit hap e'at pote e. Mi'i ui'e hap ewy kahato uhemiit'in tukupte'en mesup areĩne'en i'atu­py'a­setpe pote e Iesui. Ta'i i'atu­wepit kahato mesup katu­pono areĩne'en i'atu­py'a­setpe aikotã uhehary'i kyi'at hap e'at piat ienuk koro hap nug hat ewy areĩne'en mesuwe i'atu­py'a­setpe aikotã uhemiit mowepit kahato hat ewy areĩne'en mesup aikotã iwary rakat ewywuat e. Mi'i pote te'erenuk kahato aikotã ienuk hap iwary pakup takat mõtypot hap ienuk hap ewy e. Mi'i pote te'erenuk kahato at ka'ap e. I'atu­wepit kahato areĩne'en i'atu­py'a­setpe pote mesuwe pote e. Ma'ato pywo ti rat meiũran ti aru uhewa­nĩ­kaptia uhereto saity ete pya uimi­mo­wepit ko'i kai e. Uhereto hap e'at pe ti aru yt kat hin i ta'atu'u teran aru uhemiit yt uwe i uito hawyi e. Ta'i yt i'atu­wepit hin i aru mekewat e'at turan katu­pono irania'in yt uimohey haria i ui'auka aru e. Mi'i hap e'at pe uhemiit sese te'ere­mosy'at kahato uipot­mu'eria e Iesui wo'oset'ok hat Iuwãu potmu'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mi'i hawyi to'e Iesui — Ui'ywania ahenoi teran ehepe aikotã uhehay pakup uheko pakup yt eheko pot'i yt ewywuat hin i hap ete e. I'ewyte ti uhehay ipakup i yt ai'ywania wãi'e hap ewy hin i e. Ta'i uhehay pakup ti topyhu'at aikotã ahesokpe pakup turan hap ewy kahato uhehay pakup e. Ui'ywania karãpe ahesokpe pot'i hiot'e rakat mi'i hawyi yt watomog neran i ra'yn sokpe ipakup mo are katu­pono watomog ahesokpe pot'i ahesokpe pakup wo pote mi'i hawyi karãpe wati­koho aimimog hap tote hawyi tuweityk ta'yn ahesokpe pakup mimog hawyi toihiot ra'yn ahesokpe pot'i e. Mi'i hawyi ahesokpe pot'i hiot'e iwato po'og na'yn sa'awy'iwuat kai topyhu'at e. Yt naku i e. Mi'i pote waku watomog ahesokpe pot'i sokpe pot'i kawiat wywo yn. Yt naku i watomog sokpe pot'i sokpe pakup'i wo e. Mi'i hap ewy kahato tig yt naku i watomog aheko pot'i uheko pakup'i wo are katu­pono yt to'osat hin i uhehay pakup'i sehay pot'i upi hap ewy kahato ui'ywania e. ");
INSERT INTO mavNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","I'ewyte ti uhehay pakup'i topyhu'at kahato aikotã sapo hy pakup ewy yt nem hin i te turan e. Ta'i ahetama pe ywa pakup hy ti waku watopag heiam i'ape pakup we yn watopag katu­pono ti i'ape pakup yn wyti iporok kuap hat i'ape pakup pote e. I'ape pakup we watopag pote waku i'ywa pakup hy watopag heiam me iporok kuap hamo e. Mi'i hawyi meiũran mahy wo topyhu'at e. Mi'i hap ewy watunug ahetama pe e. Yt naku i wen ma'ato watopag i'ywa hy pakup mekewat heiam i'ape pot'i kawiat pe ipe teneg nakat kawiat pe are katu­pono yt put'ok'e kuap i yt iporot kuap i pote e. Ma'ato watopag Uwa hy pakup Uwa hy eĩam teneg me pote yt naku i sese topyhu'at aru katu­pono mahy we'amut hawyi i'ape teneg me hawyi i'ape teneg i'apok'e e. Mi'i pote i'apok'e kahato heiam teneg e. Mi'i hawyi mekewat mahy Uwa hy wakuat yne yi tote tuwepun ne'i e. I'ewyte heiam i'ape teneg kawiat yt kan hamo i topyhu'at i'apok'e hawyi e. Yt kat pe kuap i ra'yn waheiam nug i'apok'e hawyi e. Yt kat i ahesapo hy i'ewyte ti yt kat i heiam e. Pywo ti rat mi'i ewy kahato uhehay pakup'i topyhu'at e aikotã kat kat ywa hy ipakup takat ewywuat topyhu'at mesuwe e. Ta'i uhehay pakup'i yt toĩne'en kuap i ahehay pot'i puo e. Yt wato­mohey kuap i wẽtup sehay yt uiat ewywuat i e. Wato­mohey teran mote aiwepyi sehay pot'i pote hawyi yt naku i topyhu'at aikotã ahesapo hy eiam teneg nakat pok'e hap ewywuat toĩne'en e. Uhehay pakup'i yt to'osat i ahehay pot'i wywo e. Yt to'o'ewy i pote yt naku i to'opuo tukupte'en e. Eweipag uhehay pakup'i wo'omu'e haria sehay pot'i puo pote meiũran yt naku i sese topyhu'at itote e. Ma'ato ehã'ãg mote uhehay pakup sehay pot'i puo wẽtup sehay nug hamo pote yt kat i sehay pywuat topyhu'at aru katu­pono uhehay pakup yt sat'e i kahato wẽtup sehay wywo tu'uka kahato e. Waku uhehay pakup watopag heiam pakup we e. Yt pote tu'uka to'ope hawyi sehay sa'ag ewywuat topyhu'at e Iesui sehay pot'i moherep haria pe mekewat uiat ui'yat pe. Uito Mateu. ");
INSERT INTO mavNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mio tã e Iesui turan wẽtup ok Iuteuria akag put'ok'e hawyi tuwe­pỹ'ã­tutuk Iesui mõtypot hamo hawyi to'e — Yt naku i uhete Mehĩ e. Mesup ta'yn uhaki'yt sese uimiky'e kahato iku'uro sese ra'yn ipyhu tek'e ra'yn Mehĩ e. Ma'ato ereto uhupi hawyi ereponug ipiit ete hawyi uhaki'yt tuwẽtem i ra'yn gu'uro pyi hap atikuap Uhyt e haty wo Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mi'i hawyi — Pyno areto e Iesui hawyi toto ra'yn mekewat tu'isa upi ui'yat pyi. Mi'i hawyi ipotmu'eria tuwat hupi wy. I'ewyte typy'i kahato mu'ap upiaria seha'at reran howawiat hanuaria tuwat ahupi. Toĩne'en wy aipy'a­setpe wẽtup hary­poria. ");
INSERT INTO mavNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mi'i hary­poria ti i'ahu kahato. Huu wato kahato rakat toĩne'en. 12 anu ra'yn toho'opot at ka'ap mekewat tosuu wato hap. Mi'i hawyi toto Iesui upi tehãite Iesui esokpe mig hamo toto hap toiky'esat. ");
INSERT INTO mavNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","— Are an e atemig Iesui esokpe uipo wo mi'i hawyi waku i mono uhete e hary­poria tuwepe. Uimoe­hãite hap topyhu'at i ra'yn mono e huu wato rakat tuwa­nẽtup hawe toto hupiat haype. ");
INSERT INTO mavNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mi'i hawyi totemig na'yn hesokpe ete. Mi'i hawyi meremo temig hap Iesui tikuap topy'a pe hawyi tuwe­morem meremo uwe temig hat kat hamo. Toipuẽti temig hat hawyi to'e — Waku ra'yn mana eremo­wepit ro katu­pono uimohey hap epiat hap ti emoehãite hap topyhu'at e. Mi'i hawyi mekewat hary­poria tikuap meremo topiit piat huu wato tek'e hap. Tohãite hap toikuap ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesui timoe­hãite mekewat hary­poria hawyi toto i mu'ap upi mekewat tu'isa wywo ra'yn. Mi'i hawyi put'ok'i'atu'e hawyi tuwehyt'ok tu'isa yat pe. Mi'i hawyi Iesui ta'akasa ra'yn itote pĩ'ã iku'uro potiat wo'okak'i haria ahyt tukupte'en itote i'ewyte akuara piat wepy haria pĩ'ã iku'uro potiat wepy haria tukupte'en tu'isa yat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Mi'i hawyi Iesui to'e itotiaria pe — Eweiwat ro meiũpepyi eipe yne e katu­pono yt iku'uro i wyti tu'isa saki'yt are ma'ato toket ne'i rat e. Mio tã e hawyi to'okyry'i sa'ag kahato Iesui ete. ");
INSERT INTO mavNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mi'i hawyi Iesui ti'atu­sopo mi'iria torania tu'isa yat pyi. Toipo­renõ'ẽ ra'yn miit'in wo'okak'i haria hawyi toto ra'yn tu'isa upi haki'yt iku'uro rakat e'okipy kape. Mi'i hawyi pĩ'ã ok puk toimopoĩ'ãm ipo ete. Totat ipo hawyi pĩ'ã tuwe­hymut toku'uro sese hap pyi hawyi meremo ipoĩ'ãm na'yn ihãite i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Karãpe irania'in tikuap ta'yn haki'yt tuwẽtem sese gu'uro pywiat hap hawyi ta'atu­henoi henoi kahato wuat'i miit'in me Iesui minug wakuat yt uwe minug kuap ewywuat i. Mi'i hawyi yne tawa hit puo yne tawa wato puo meremo ra'yn miit'in yne tikuap iminug wakuap etiat. — Toimoieĩne'en kuap i'ok puk takaria i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mi'i hawyi Iesui toto ra'yn mekewat tu'isa etawa pyi hawyi mu'ap upi typy ok yt ihapytig i sese rakaria tuwat hupi. Mi'i hawyi ta'atu­wẽ­powat kahato Iesui kape — Morekuat Koro Tawi saipepiat i'atu'e yt urueha­pytig hin i pote urumoe­hãite ro uruky'e hap ok tã i'atu'e haty wo Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mi'i hawyi Iesui teke wẽtup yat pe ra'yn hawyi ti meimuẽ­wuaria yt ihapytig i rakaria i'ewyte tuwehyt'ok iwywuat pe. Mi'i hawyi apo'e Iesui i'atuepe — Eweimohey apo uhepiat eimoe­hãite kuap hap e. — Ta'i Mehĩ i'atu'e uruimohey kahato epiat urumoe­hãite kuap hap ehepap kahato hap i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mi'i hawyi totemig i'atueha ko'i hawyi to'e — Pyno uimohey hap ok tã na'yn wyti topyhu'at eheha ete e. ");
INSERT INTO mavNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mi'i hawyi meremo i'atue­ha­pytig na'yn hawyi mehit i'atu'e kahato ra'yn. Mi'i hawyi Iesui i'atu­nãpin — Uhyt'i'in yt uwe pe tei'o ewehenoi uiminug eimoe­ha­pytig hap e haty wo tomi­moe­hãite ko'i pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma'ato yt tutunug i Iesui miky'esat ewy hawyi tuwat hawyi wuat'i puo — Iesui ti wuat'i sepap hat i'atu'e. Pywo ti rat urumoe­ha­pytig kahato hat Iesui i'atu'e wuat'i miit'in me — Yt eweihenoi tei'o e Iesui pytkai ta'atu­mo­herep. Mi'i pote miit'in wuat'i etawa piat — To'iro Iesui kape imisepap ko'i akasa hamo i'atu'e katu­pono Mi'i Miit Iesui yt uwe misepap ewywuat nug hat i i'atu'e. Pywo ti rat wakuap sese nug hat yt miit minug ewywuat i tutunug itote i'atu'e. To'iro pyno wateha'at hamo i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mi'i hawyi Iesui toto ra'yn mekewat getap wyi topot­mu'eria wywo. Mi'i hawyi mu'ap upi ta'atuerut wẽtup ok miit yt ihay kuap hin i rakat ahiag ipiit piat rakat pote. ");
INSERT INTO mavNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mi'i hawyi Iesui tisopo ra'yn mekewat mã'ãu sa'ag hawyi ihay i ra'yn. Sa'awy'i yt ihay kuap takat i waku pe iwẽ piat. Mi'i hawyi itotiaria te'ere­wa­nẽtup kahato — Ta'i yt karãpe i ti wata'a­kasa meketã ewywuat ai'ywania Isareu ywania etama pe i'atu'e katu­pono Iesui ti'atu­sytpok kuap sese ahiagnia miit'in piit pyi i'atu'e. Waku kahato Mi'i Miit i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma'ato irania'in Iuteuria wãi'e hap seko sehay moherep haria te'ero'e to'ope — Iesui ahiagnia akag koro esaika hamo ti toi'atu­sopo ahiagnia i'atu'e miit'in me itote. Ahiagnia porekuat ehay pyi tohytpok ahiag ko'i i'atu'e sa'ag Iesui ete. ");
INSERT INTO mavNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mi'i hawyi Iesui toto wuat'i tawa kape wuat'i hy totiaria mu'e hamo tehay wawiat hamo. I'ewyte wuat'i Tupana mõtypot yat pe teke ra'yn i'atumu'e hamo. Toi'atumu'e kahato tehay wakuat no — Ewei'atoiat ro yne eiminug sa'ag hap ko'i Tupana kape morem hamuat are katu­pono yt pya hin i Tupana topyhu'at Aipo­typot no hap e'at pe e. I'ewyte toi'atu­moe­hãite kahato torania i'ahu rakaria aikotã aikotã ahu hap ewywuat toi'atu­moe­hãite torania tewyry hap upi. ");
INSERT INTO mavNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ta'i miit'in sem tõ'ẽ tõ'ẽ Iesui ewawi. Mi'iria kape teha'at kahato tepiat i'atuky'e kahato hap mywo — Are pãi e ati'atue­ha­kyera'at teran kahato wuat'i mi'iria e katu­pono mi'iria ti piku piku ko'i ho'owasat rakaria ewywuaria gupte'en haria uiwa­nẽtup hawe e. Ahaty'u kahato uipy'a pe mi'iria ekyi uhowawi are katu­pono aihũria yt i'atu'a­pykok hat i ewywuaria ti mi'iria tukupte'en uiwa­nẽtup hawe uipy'a pe e. Ta'i meimuẽ puaria ti aikotã aihũria iku'uro ku'uro rakaria ewy tukupte'en yt uwe i ta'atupoi hat pote e. Pywo pe uipy'a pe i'atu­haky'e'i kahato hap yn uhete katu­pono yt uwe i te i'atumu'e hat i'atu kahato rakaria pytkai e Iesui topot­mu'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","— Uipot­mu'eria miit'in typy'i kahato wyti yt wati'a­tumu'e i te mesuwat yi totiaria mi'iria i'ewyte waku aimi­mu'eria wo torania e. Uimohey haria e aimikoi haat kahato ra'yn i'ok kahato ra'yn hap ewywuaria tukupte'en yt aimimu'e i te ko'i e. Yt typy hin i i'atumu'e hanuaria tukupte'en e. Ta'i aikotã aimikoi haria yt put'ok'i'atu'e hin i aimi'u yne terek hamo hap ewy kahato miit'in mu'e haria yt put'ok'i'atu'e i te ti wuat'i mu'e uhehay wo mesu­wa­ro­tiaria e Iesui topot­mu'eria pe i'ewyte ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mi'i pote uiwyria'in ehẽtup to haty wo mekewat mikoi wato Ka'iwat ewywuat pe — Tupana ewei'e — Etipo'oro ro ehay moherep haria wuat'i ywania mu'e hamo ewei'e ro Ai'ywot Tupana kape e. — Aikotã uruipo'oro motpap nug haria ahyt uruko wato kape urumikoi wato terek hamuat hap ewywuat ro eti'atu­po'oro emiit'in sem ehay moherep wuat'i ywania pe waku ewei'e o Tupana pe e Iesui topot­mu'eria pe i'ewyte ahepe. Iesui enoi hap ewy atiwan mesuwe uito Mateu. ");
INSERT INTO mavNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mi'i hawyi Iesui ti'atu­kaykay temiit'in 12 ok takaria tuwe­wawi. Mi'i hawyi Iesui tum i'atuepe tesaika hap ahiagnia sytpok hamuat wuat'i miit'in piit pywiat. Mi'i hawyi tutum i'atuepe tesaika hap wuat'i i'ahu rakat moehãite hamuat. Toimõ'ẽ kahato tesaika hap temiit'in 12 ok takaria pe tomi­sepap ok tã nug hamo miit'in mu'e hamo i'ahu rakaria moehãite hamo ahiag sytpok hamo hap tutum temiit 12 ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sa'awy'i tutum tesaika hap tomi­sepap nug hamo topotmu'e Simãu me tomiset'ok PETERU mekewat Nu e hawe rakat pe. Mi'i hawyi ÃTERE pe tutum tesaika hap mekewat Peteru ywyt pe tomi­sepap nug hamo. Mi'i hawyi topotmu'e TIAKU pe i'ewyte iywyt IUWÃU me uhyt Sepeteu sa'yru'in me tutum tesaika hap tomi­sepap nug hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mi'i hawyi topotmu'e WIRIPI pe tutum tesaika hap tomi­sepap ok tã nug hamo. Mi'i hawyi temiit PATORUMEU pe tutum tesaika hap wuat'i nug hamo. Mi'i hawyi tomi'airo TUME pe tutum tesaika hap wakuap nug hamo. Mi'i hawyi uhepe mu'ap pyhyp hat pe MATEU pe tutum tesaika hap tomi­sepap wakuat nug hamo. Mi'i hawyi tomi­po'oro TIAKU pe mehĩ Auweu sa'yru pe tutum tesaika hap towat ewywuat. Mi'i hawyi i'ewyte tomi'airo TATEU pe tutum tesaika hap tomi­sepap wakuap nug hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Mi'i hawyi mekewat surara pe tetama apykok hat SIMÃU me tutum tesaika hap tomi­sepap ewywuat nug hamuat. Mi'i hawyi mekewat IUTA pe mekewat uhyt Ikarioti sa'yru pe Iesui tum tesaika hap mekewat Iuta toma'at hanuat ne'i wen ma'ato to'auka hamuat topyhu'at. ");
INSERT INTO mavNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Toimõ'ẽ sese tesaika hap ahiagnia sopo hamo miit'in moehãite hamo hawyi toi'atu­po'oro topot­mu'eria tehay moherep hamo wuat'i tawa kape wuat'i miit'in me — Uipot­mu'eria e eipe ti uimi'ai­roria 12 ok takaria e. Koitywy woro­ho'o­po'oro ra'yn eipe uhehay wakuat moherep hamo ai'ywania Iuteu ywania kape e. Mesup atiky'esat eweimu'e ai'ywania yn e. Yt atiky'esat i te eweiwat irania'in ywania kape e. Ai'ywania kape yn waku mesup wati'a­tumu'e e. Irania'in pusu kuap haria kape yt eweiwat i mesup uhehay moherep hamo e. Yt naku i mesup eweiwat meimuẽwat yi Samaria ywania mu'e hamo e. Yt eiwehyt'ok tei'o i'atue­tawa pe i'atumu'e hamo mesup e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pyno ai'ywania tukupte'en aikotã aihũria ho'owasat rakaria ewywuaria e. Mi'i pote waku ai'ywania Iuteu ywania wati'a­tumu'e sa'awy'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Put'ok'ewei'e hawyi mio tã ewei'e ro itotiaria pe — Pywo ti aru tut irane Tupana Mipo'oro Aipo­rekuat nuat mehĩ'in mana'in ewei'e o itotiaria pe e Iesui tomi­po'o­roria pe tuwetiat ihay. ");
INSERT INTO mavNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mi'i hawyi waku aimẽpuo aimẽpuo eiko­hye­wyry hap upi i'ahu rakaria o ewei'atu­moe­hãite uhesaika hap wo e. I'ewyte iku'uro rakaria ewei'atu­moieĩne'en o uhesaika wo e. I'ewyte hepihi pihi rakaria o ewei'atu­mokã'ã uhesaika hap wo e. I'atupã'ãu sa'ag ko'i ahiagnia ewei'atu­sopo yne i'atupiit piat ko'i uhesaika hap wo e. Ta'atusa'up nug neran ta'atu­moe­hãite hap ete pote o wãi'ewei'e o i'atuepe e katu­pono ti yt ha'up ete i ti atum na'yn uhesaika hap miit'in moehãite hamuat. Pyno mi'i hap ewy ti yt kat sa'up i ete ewei'atu­moe­hãite miit'in uimiium ehepiat yt kat sa'up i hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Waku ti yt kat i hin i sa'up ewetioto eiwywo are yt i'ape rakat i wyti yt i'yhop takat i wyti. Yt kat i mig'i wo ewetioto eheti­neiru e. Uiwyria'in yt atiky'esat i sẽtup'i sẽtup'i e haria wo eweikupte'en eimi­mu'eria py'asetpe e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Waku yt kat i mu'ap sa'up i'ewyte eimi'u mu'ap upiat yt kat i ewetioto e. Waku wẽtup yn ehesokpe eipiit piat are i'ewyte wẽtup yn epy sokpe eipy piat yn waku ewetioto e. I'ewyte ehekare'en ko'i yt naku i ewetioto e. Eimi­po­wy­roria eipoi teran mote waku i'atu­wywo ewehenuk are katu­pono sa'awy'i Tupana to'e miwan ahepe — Ewetum no sa'up eipotpap nug haria pe e Tupana miwan me. ");
INSERT INTO mavNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mi'i pote put'ok'ewei'e wẽtup tawa pe i'atumu'e hamuat hawyi waku itote eweikat iwese rakaria eimimu'e kuap teran haria. Mi'i hawyi waku eweikupte'en i'atu'yat pe aikope aikope — Uhyt mimi waku uru'yat pe eweikupte'en e haria yat pe e. Mi'i tote waku eweikupte'en e. Yt eiwo'osat i tei'o getap upi getap upi meiẽwat tawa piat ko'i upi e. Waku sa'awy'i­tewuat eweikupte'en no — Uru'yat pe uhyt mimi waku meiũpe eweikupte'en e haria yat e. Mi'i tote eweikupte'en mekewat tawa piaria ewei'atumu'e turan e. Mi'i e hat yat pe yn eweikupte'en itote turan e. Pyno ewei'atumu'e yne mekewat tawa piaria hawyi waku eweinõ'ẽ mekewat i'yat pyi hawyi waku eweiwat wẽtup tawa kape e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mi'i hawyi wẽtup yat pe eiwehyt'ok hawyi waku ewehẽtup Tupana pe — Tupana ewei'e eti'atu­mo­wepit kahato yne ro mesuwat yat piaria ewei'e eiwehyt'ok mekewat yat pe turan e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mekewat yat piaria i'atu­wese kahato ehepiat ta'atumu'e hap ete pote ti aru Tupana ti'atu­mo­wepit kahato mekewat yat piaria eimiẽtup Tupana piat hap ewy ra'yn e. Ma'ato yt i'atu­wese i pote Tupana yt tum i i'atu­mo­wepit hap ei'e hap ewy. Ma'ato yt i'atu­wese i pote i'atu­wepit hap eimiẽtup Tupana kaipywiat ta'aipok meremo ehowawi e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma'ato wẽtup tawa piaria torania yt ta'atu­wa­nẽtup teran i ehehay uhepiat kape pote waku eweiwat i ra'yn meiẽwat yt iwese rakat tawa pyi. Mi'i hawyi i'atue­hamo waku mekewat tawa okipy sawiu eweipikpik'ok eipy etiat itotiaria uimohey hap pun haria hap moherep hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Katu­pono Tupana tikuap ta'yn mi'iria uimohey hap pun haria hawyi yt iwẽpohep hin i i'atu'a­piheg haty wuat hap ete e. Karãpe Tupana tut wakuaria yt nakuaria i to'e hamuat hap e'at pe mi'iria pe ti aru po'og po'og haty wo to'e — Yt nakuaria i sese eipe e aru Tupana uhetiat eimienoi pun haria pe. Ta'i yt ipohep hin i ti aru i'atu'a­piheg haty wuat hap ete are aikotã sa'awy'i hap ewy. Sa'awy'i te ti Tupana timoma kahato mekewat tawa Sutuma piaria i'ewyte tawa Kumura piaria toi'atuwuk kahato aria wo i'atu­minug sa'ag hap upi e. Ta'i toi'atu'a­piheg kahato ti meimuẽwat tawa piaria aria wo e ma'ato mekewat tawa uhehay pun haria ti aru po'og po'og toi'atu'a­piheg wuat'i etawa puaria kai are po'og tawa Sutuma tawa Kumura wuk hap ko'i kai aru uimi­po'o­roria ehay pun haria pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Uipot­po'oria eiwe'eg wo o karãpe ewei'atumu'e wẽtup tawa yt uhehay kuap i te haria katu­pono ti aikotã aihũria awahuru ko'i py'asetpe tukupte'en hap ewy ti aru eweikupte'en eipe e. Uiwyria'in woro­ho'o­po'oro miit'in mu'e hamo ma'ato o eiwe'eg wo katu­pono ipoity kahato ti itote uimohey hap pun haria haiwot rakaria awy'ato ko'i ewywuaria e. Eiwe'eg wo o uihũria ewei'atumu'e uhetiat turan. Waku pe iperup'i rakaria wo eweikupte'en ewei'atumu'e uhetiat turan aikotã pykasu tuwe'eg wo kahato toĩne'en hap ewy. I'ewyte aikotã mio yt iky'esat hin i to'auka hap ewy o eweikupte'en itote e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Eiwe'eg wo o katu­pono tukupte'en ti aru itote eipyhyp teran haria e. Morekuat pupiat eipag neran nakaria surara pupiat eipag neran haria ei'apiheg ei'ahyk ahyk hanuaria e. Ai'ywania mu'e Tupana ehay wuat hap yat pe ti aru e ehaty'i haty'i ti aru eipetek petek popuo ti aru e. Mi'i pote eweikupte'en i'atu­py'a­setpe aikotã pykasu ko'i moi ko'i we'eg hap ewywuaria eweikupte'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Meiũran ti aru ahewa­nĩ­kaptia ehereto ta'atu­po­re­kuaria kape uhemiit'in eipe pote. Mi'i hawyi ta'atu­ky'esat kahato eipag ta'atu­po­re­kuaria po pe ei'apiheg apiheg hap ei'ahyk ahyk hamo e. Itote ti aru apo'i'atu'e eiwehay aparap teran haype apo'i'atu'e ma'ato waku ewei'atumu'e mi'iria uhehay wakuat wo yn na'yn ai'ywania akag ko'i i'ewyte irania'in ywania akag ko'i uhehay kuap hamo e. Eweikupte'en aru itote uhetiat sehay moherep more­kuaria piat hamo. Mi'i pote o uiwẽ wywo o eweikupte'en itote e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Karãpe ahewa­nĩ­kaptia ehereto more­kuaria kape turan o yt eiwe­wa­nẽtup ko'i ko'i tei'o — Kat ui'e hap kat ui'e hap ko'i kape kat are aru atiwesat morekuat pãi yt ewei'e tei'o eiwa­nẽtup hawe katu­pono ti aru mekewat e'at pe Tupana hum na'yn eiwa­nẽtup hawe ehepiat i'atu­wesat hamuat kat ewei'e kat ewei'e waku ewei'atu­wesat hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Katu­pono ti aru mekewat e'at pe yt eiwat sehay hin i tuwẽtem eiwẽ pyi are ma'ato Ai'ywot atipy piat Pã'ãu kaipyi ti aru tuwẽtem eiwẽ pyi ehehay e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","I'ewyte ti aru mekewat e'at pe eheyke'et'in eheywyt'in eheinyt'in ti aru ehewa­nĩ­kaptia wo ti tukupte'en uhehay moherep haria eipe pote e. Mi'i hawyi ti aru ta'atukat kahato aikotã miat ei'atu'uka hamuat e. Ei'ywot eity eha'yru'in ehaki'yt'in ti aru ei'auka hamuat hap kat haria wo tukupte'en e'yat piaria e. Mi'i hawyi ti aru eimẽpyt'in i'ewyte ehewa­nĩ­kaptia wo sese ra'yn te'ero­pyhu'at wuat'i miit'in aru uhemiit'in no ra'yn eipe pote e. Eity'in ei'ywot'in i'ewyte ei'auka teran haria wo tukupte'en katu­pono yt eweipun i uimohey hap pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yt naku i kahato eipe i'atu'e aru ehete wuat'i miit'in uimohey haria eipe pote. Ma'ato uwe uwe uimohey te ta'atue­wa­nĩ­kaptia py'asetpe pytkai uimie­ha­kyera'at nuaria sese wo te'ero­pyhu'at e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Uipot­po'o­roria karãpe wẽtup tawa piaria eimohan ei'atu'uka hamo mi'i hap e'at pe eweikat ro wẽtup tawa hawyi ewei'atumu'e mi'iria e. Waku yne tawa pe wahenoi yne e. Uheywyt'in uheinyt'in waku wahenoi yne ai'ywania tawa ko'i piaria e. Wahenoi yne ywania kahu hawyi ta'atukuap mesuwat uhehay wakuat eiwẽ pyi hawyi ti aru waku ra'yn ara'aipok atipy kaipyi ehowawi i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Pyno ti aimu'e haria sese tukupte'en aimi­mõ­typot nuaria e. Ta'i aika'i­wuaria aimi­mõ­typot nuaria wo tukupte'en mi'iria ti po'og aikai wato'e e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pywo pe pywo pe uimohit pote i'ewyte ti aru eimohit e. Mekewat e'at aru karãpe eimohit kahato mesu­wa­rotiat uimohey haria eipe pote waku eiwa­tetup kahato uimohit hap kape hawyi mio tã ewei'e eiwa­nẽtup hawe — Pywo pe ti Aimu'e hat Iesui ewy watoĩne'en mesup miit'in mikyry'i hamo waku ewei'e. Uha'yru'in uhaki'yt'in mesu­wa­ro­tiaria uhet'ok sa'ag — Ahiag koro i'atu'e sa'ag uhepe. Pyno aikotã ehet'ok sa'ag kat som te'ero'e hap ewy aru ehete uimẽtpyt'in pote. Pyno ehepe — Ta'i ahiag koro mẽpyt'in sese ko'i eipe i'atu'e sa'ag aru ehete e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ma'ato yt eweiken'ẽ tei'o i'atumu'e uhehay wuat hamo i'atu­mi­kyry'i ehetiat pytkai are katu­pono Tupana tikuap kahato i'atu­mi­kyry'i hap yt pywo i rakat. Mi'i hawyi ti aru toimo­herep wuat'i miit'in me ehewaku kahato hap i'ewyte i'atu­heso hap. Mi'i pote yt eweiken'ẽ tei'o i'atumu'e uhetiat hamo i'atu­mi­kyry'i ehetiat pytkai are ehepe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kat are kat are ehewaure ka'a pe mi'i e hamo yn na'yn o ewei'atumu'e itote ehewa­nĩ­kaptia eima'at reran turan e. Kat e hap som eweikuap yt uwe mikuap mo i ehewaure ka'a pe uhehay mi'i hap o eweimo­herep i'atumu'e hamuat meimuẽ­waria py'asetpe turan e. Eweikuap uhehay i'ypyryp we eweikupte'en turan ehenoi ro mi'i i'atuepe ihot'ok puo e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yt eweiken'ẽ tei'o uhehay moherep hamo ei'atu'uka teran haria pupi katu­pono mi'iria ti yt aimoma kuap i e. Aipiit yn ta'atu'auka kuap ma'ato aheĩne'en hap sese wuat'i e'at piat aipã'ãu aheha piat wuat'i e'at piat aipy'a piat wuat'i e'at piat aimoieĩne'en hap yt ta'atu­moma kuap hin i e. Mi'i pote yt eweiken'ẽ i mi'iria ei'auka pupi. Yt kat hamo i watoken'ẽ katu­pono yt ta'atu­po'oro kuap i miit'in ta'atu­ku'uro wuat'i e'at pe hap kape e. Pywo pe ti Tupana yn eipo'oro kuap eipiit i'ewyte eipã'ãu po'oro kuap aria wato kape aikope eipiit i'ewyte eipã'ãu sese iku'uro at ka'ap wuat'i e'at pe hap kape e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ahetama puo ti weita hit ko'i watikyi'at aimi'u wo e. Yt ha'up woity hin i watikyi'at weita hit e. Ta'i wẽtup ape hit po'og yi kai sa'up mo yn watikyi'at kuap ta'yn typy weita hit e. Yt ha'up woity hin i pãi weita hit ma'ato pywo pe ti Ai'ywot atipy piat haty'u kahato topy'a pe wẽtup weita iku'uro e. Pywo pe ti toikuap kahato aikope aikope wuat'i weita koi tukupte'en hap toikuap e. Wẽtup weita hit iku'uro hap toikuap topy'a pe katu­pono toi'atuky'e kahato haype re. Mi'i hap ewy te ti ma'ato po'og po'og toikuap aiku'uro hap katu­pono po'og aiky'e torania kai e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ta'i aikuap kahato ti Tupana e. Ai'asap ti torania toimo­rania yne yne ai'asap toikuap karania ai'asap hap toikuap kahato. ");
INSERT INTO mavNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mi'i tupono o yt eweiken'ẽ tei'o miit'in miat ei'auka hap pupi katu­pono eika­wiano hat toĩne'en Tupana e. Ta'i iwanẽtup hawe eweikupte'en po'og po'og weitaria kai e. Tupana tiky'e kahato weitaria ma'ato tuwa­nẽtup hawe eipe po'og po'og weitaria kai e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Pywo pe ti uwe uwe to'e uhetiat irania'in py'asetpe — Atomohey kahato ti Iesui ti rat e. Mi'i Miit ri Uheha­kyera'at hat i'ewyte Uika'iwat koro e irania'in me mi'i e hat piat Uito i'ewyte wy are'e — Meiẽ miit ri Uimohey kahato hat Papai are'e wy Ui'ywot atipy piat pe mio tã e hat etiat e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma'ato uwe uwe — Yt atomohey i Mi'i Miit katu­pono yt Uika'iwat i ti Mi'i e uhepiat pe irania'in me mi'i hat pe Uito i'ewyte — Yt uimohey hat i ti mi'i are yt uhemiit i ti mi'i miit are wy Ui'ywot atipy piat pe mio tã e hat etiat e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yt eweiwa­nẽtup tei'o ariot mesu­wa­rotiat miit'in wuat'i puat wo'owese hap nug hamo aiwa­nẽtup hawe e katu­pono yt wo'owese hap ewy hin i atunug mesuwat yi tote katu­pono ti aru irania'in wyti aru i'atu­py'ahak kahato ahete uimohey haria eipe pote. Ta'i kyse'yp wywo ai'auka hamuat hap ewy katu­pono Tupana emiit'in aito pote e. Mi'i hawyi yt kat i wo'owese hap ewy topyhu'at mesu­wa­rotiat uimohey haria ete wuat'i miit'in i'atu­py'ahak hawyi kyse'yp wywo aikat ai'auka hamo e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Katu­pono ti aru meiũran eha'yru'in ehu'uka wyti aru uimohey haria eipe pote. I'ewyte ti aru meiũran ehaki'yt'in aru ehu'uka uimohey ehepiat hap upi e. I'ewyte ti aru eimẽpyt'in ehary'i'in i'atu­py'ahak kahato ehete uimohey haria eipe pote. Mi'i hawyi ti aru esa'yru ehary'i tu'uka tosa­kitu wywo uimohey hap upi. ");
INSERT INTO mavNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ei'yat piaria yt uimohey haria i i'ewyte i'atu­py'ahak aru ehete po'og torania kawiat po'og nakat e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mi'i pote uwe uwe toty to'ywot ky'e po'og uikai mi'i hawyi ui'atoiat katu­pono toiky'e po'og to'ywania po'og uikai mi'i haria ewaku hap ti yt put'ok'e i uhemiit nuat hamo e. I'ewyte uwe uwe tomẽpyt tosa'yru tosaki'yt ky'e po'og uiky'e hap kai mi'i hat ewaku hap yt put'ok'e i uhemiit'in nuat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mi'i hawyi ui'auka pytkai yt atoiat hin i imohey hap e haria yn ni waku uhemiit nuat hamo e. I'ewyte uwe uwe uhewaku hap ewywuat nug hat yn ni waku uhemiit nuat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma'ato uwe uwe — Ta'i atunug aru uimi­ky'esat ko'i yn mi'i pote waku pe kahato areĩne'en e hat wyti aru yt iwepit hin i topyhu'at tutunug yne tomi­ky'esat ko'i pytkai. Ma'ato uwe uwe uimi­ky'esat yn nug hat ti aru topyhu'at iwepit hat sese e. Toipuẽti mesuwe wy topy'a piat tomo­wepit hap tutunug yne uimi­ky'esat ko'i hawyi e. Uimi­ky'esat nug haria yn wyti ieĩne'en kahato mesu­wa­rotiat hanuat wepit hap sese puẽti hamuat e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Pywo ti uwe uwe — Ereke ro mehĩ mana e ehepe uhemiit'in eipe pote mi'i hat wyti uhepiat — Ereke ro Uhyt Mimi e hat ewy ra'yn topyhu'at e Iesui. I'ewyte uwe uwe — Ereke ro e uhepe mi'i hat Uipo'oro hat Tupana piat — Ereke ro e hat ewy ra'yn topyhu'at e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pywo ti uwe uwe Tupana mipo'oro tehay henoi hamuat pe tuwese popuat — Ereke ro Tupana mipo'oro e hat pote Tupana tum hamuat ha'up aikotã tomi­po'oro piat tutum hap ewy te tutum aru e. I'ewyte uwe uwe — Ereke ro mehĩ mana e mekewat waku rakat pe tuwese hap wywo mi'i hat pe ti Tupana tum aru mekewat waku rakat waku nug hat piat sa'up ok tã e. ");
INSERT INTO mavNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","I'ewyte yt eweiwaure tei'o uhemiit'in miit'in emiit'in ihaky'e'i rakaria powyro hap etiat katu­pono uwe uwe hum y'y ra'ak wẽtup ekui'a yn uhemiit pe po'og yt uwe i miky'e i rakat pe i'atuky'e hap wywo mi'i hat pe ti aru atum ha'up e Iesui temiit'in 12 ok takaria pe. Iesui mienoi hap ewy atiwan mesuwe uito Mateu. ");
INSERT INTO mavNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mi'i hawyi Iesui to'e temiit'in me — Pyno waku ra'yn eweikuap ta'yn einãpin hap aikotã aikotã atiky'esat ewei'atumu'e irania'in miit'in uhehay ete hap e. Pyno to'iro meiũpepyi aiweran hap kaipyi aikowo aikowo tawa hit ko'i upi i'atumu'e hamo e 12 ok takaria pe. Mi'i hawyi tuwat ra'yn yt pya wuaria i kape. ");
INSERT INTO mavNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mi'i hawyi ti mekewat wo'oset'ok hat Iuwãu tikuap ta'yn aikotã aikotã Iesui minug ipotpap hap ko'i topyhik pyi. Mi'i hawyi ti toi'atu­po'oro ra'yn temiit'in Iesui kape apo'i'atu'e hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mi'i hawyi toipo'oro temiit'in tehay wywo apo'i'atu'e hamo. — Urumu'e hat i'atu'e sa'awy'i ahet'ok hat Iuwãu tikuap teran En apo Tupana Mipo'oro Urueha­kyera'at hanuat ra'yn apo sio uruhe­katup te wẽtup ok imipo'oro e hap toikuap teran i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mi'i hawyi Iesui ti'atu­wesat — Ewei'aipok to Iuwãu kape hawyi waku ewehenoi ro tope aikotã aikotã eimikuap uhehay wakuap ko'i tope i'ewyte uiminug ko'i aikotã aikotã ei'akasa hap ko'i ewehenoi ro tope e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mi'i hawyi ewehenoi ro tope aikotã yt hekat i rakaria ati'atumu'e Tupana ehay hap ewehenoi ro tope. ");
INSERT INTO mavNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mi'i hawyi i'ewyte wẽtup uhehay se eweitioto ro aiwy Iuwãu kape mio tã ewei'e tope — Uwe uwe uimohey pot'i kahato tepiat ho'opot pytkai mi'i hat ti aru uimo­wepit sese hanuat topyhu'at ewei'e ro Iuwãu me e Iesui Iuwãu potpo'o­roria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mi'i hawyi te'era'aipok i ra'yn Iuwãu potmu'eria. Mi'i hawyi Iesui ti'atumu'e itotiaria miit'in sem wo'oset'ok hat Iuwãu etiat — Sa'awy'i eweiwat kahato yahig kape aimu'e hat Iuwãu kapiat ei'akasa hamo e. Mi'i hawyi ti itote eweipuẽti ti Tupana ehay moherep kahato hat sese eimikat ewywuat kahato e. Iuwãu ti iheg miat kahato Tupana mohey hat yt kowo'i kowo'i wanẽtup hat yt akuara yp wasere potiat kowo'i kowo'i hap ewywuat hin i ti eweipuẽti Iuwãu itote e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Irania'in miit'in esokpe kahuria yt hap ewy hin i ti Iuwãu topyhu'at katu­pono ti hesokpe kahu rakaria more­kuaria yat pe yn ni tukupte'en sokpe kahuria puo ma'ato mi'iria yt Iuwãu ewywuat hin i katu­pono yahig notiat hesokpe i'anam nakat puo Iuwãu toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pyno kan hamo eweiwat Iuwãu kapiat ei'akasa hamo mekewat yahig kape sa'awy'i. Ta'i Tupana ehay moherep hat ehay kuap hamo eweiwat waket'ok hat Iuwãu a'akasa hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta'i sa'awy'i mio tã e Tupana Tosa'yru pe miwan me — Uha'yru e meiũran ti aru woro­po'oro miit'in kape ma'ato ti atiky'esat sa'awy'i wẽtup ok ti toto e'yianme hap atiky'esat. Mi'i ti eto hap etiat enoi hamuat atipo'oro e Ui'ywot sa'awy'i uhepe Iuwãu etiat. ");
INSERT INTO mavNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mi'i hawyi mekewat e'at pe put'ok'e mesuwe Tupana e hap ewy are. Mi'i hawyi ahet'ok kahato y'y wuat hat put'ok'e ra'yn are. Waku kahato Iuwãu are. Po'og wakuat wuat'i sa'awy'iwuat Tupana ehay moherep haria kawiat hat are wen ma'ato ti aru meiũran tukupte'en Tupana ehay moherep haria ahyt mesuwat yi totiaria uimohey haria yn po'og waku rakaria Iuwãu kai are. Pyno pywo pe ti koran ti uwe uwe uimohey hano toĩne'en uhemiit no uimi­ky'esat nug hano mi'i hat po'og po'og iwato Tupana wanẽtup hawe mekewat Iuwãu kai are. Ta'i yne uimohey haria aru po'og Tupana mimõ­typot wo tukupte'en atipy pe ahet'ok hat Iuwãu kai are. Pywo ti rat yt iwato hin i uhemiit mesuwe uimohey haria py'asetpiat pytkai meiũran atipy pe hawyi po'og Tupana mimõ­typot no topyhu'at ahet'ok hat Iuwãu kai are e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ha'awyte i'ewyte mesup te i'atu kahato — Atiky'esat Tupana Uipo­rekuat no e haria wen ma'ato irania'in haiwot rakaria ti'atu­pyhyp teran Tupana Aipo­rekuat nuat hap are. Sa'awy'i Iuwãu mienoi ta'atu­pyhyp teran i'ewyte koitywy uimienoi ta'atu­pyhyp teran ma'ato mi'i pytkai yt aipyhyp kuap i katu­pono tuwehyt'ok kahato miit'in uhowawi wãi'i'atu'e pytkai. Ta'i tõ'ẽ kahato uhowawi miit'in sem Tupana nug ta'atu­po­rekuat no teran haria yt uwe i i'atu­pyhyp kuap i are e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yt uruto yn i uruhenoi mi'i hap ko'i katu­pono sa'awy'i­wuaria Tupana ehay enoi haria ti torania henoi — Meiũran aru Tupana tipo'oro Aipo­rekuat nuat ahowawi e hap ko'i ete ti ta'atu­henoi. I'ewyte mekewat Musei miwan me yne ihay mi'i hap ko'i ete sa'awy'i te mesup te Iuwãu aimu'e hap e'at pe te woro­ho'omu'e hap e'at pe are e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","I'ewyte mekewat sa'awy'iwuat Tupana ehay moherep hat Eria ti Iuwãu ewywuat kahato toĩne'en are. Sa'awy'iwuat Tupana ehay enoi haria ti — Ta'aipok wyti aru Eria ahowawi Tupana Mipo'oro Aipo­rekuat nuat ut hap moherep hamo. Aheha­kyera'at hat yianmete tut aru Eria i'atu'e miwan me are. Pywo ti rat Iuwãu etiat ta'atu­henoi are. Eria i'atu'e pytkai ma'ato Iuwãu etiat ta'atu­henoi yianmete are. Pyno mi'i e hap eweimohey kuap wote eweimohey ro are katu­pono Eria ewywuat kahato Iuwãu are e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pyno waku mio wuat sehay teke ehewaure ka'a pe are. Ehewaure toĩne'en pote waku eweiwa­nẽtup uhehay kape are e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mi'i ahenoi teran ehepe aikotã tukupte'en miit'in mesu­wa­ro­tiaria uhehay pun haria yt uimohey haria i are. Ta'i mi'i haria ti hira­karia wo'okyry haria ewywuaria tukupte'en wema­hara haria ewy mi'iria tukupte'en yt ipap i rakaria ewy are. — To'iro watu­we­ma­hara i'atu'e irania'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","To'iro ahehairu i'atu'e haria ewy. To'iro akuara piat wepy hawe ahehairu aikotã se'aito hap e'at piat wepit hap ewy ahehairu i'atu'e to'ope irania'in hira­karia pe ma'ato — Yt urupap i i'atu'e are. Mi'i hawyi irania'in hira­karia to'iro wo'osyp hap kape. Itote watunug akuara piat wepy hap aikotã wo'osyp hap e'at piat aiwak hap ewy i'atu'e irania'in hira­karia to'ope ma'ato — Yt atunug neran i i'atu'e are. Pyno mi'i haria ewy uimienoi pun haria mesu­wa­ro­tiaria tukupte'en are e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ta'i sa'awy'i ti Iuwãu put'ok'e mesuwe mesu­wa­ro­tiaria mu'e hamo. Mi'i hawyi tuwe­mosy'at kahato i'ewyte yt kat i imahy Uwa kawiat tutu'u. Mi'i hap pytkai — Ahiag wyti epiit pe I'atu'e Iuwãu me. ");
INSERT INTO mavNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mi'i hap ewy te Uito Eheyke'et Eikywyt put'ok'are mesuwe eimu'e hamo are. Mi'i hawyi ati'atumu'e kahato uiwepit popuo kahato are yt Iuwãu ewywuat hin i katu­pono Uito atu'u yne yne mi'u ko'i i'ewyte aremahy'u yt Iuwãu ewy hin i areĩne'en. Uheko wẽtup takat yt uimohey haria i py'asetpe ma'ato mi'i pytkai — Ta'i ienuk kahato rakat mahy u yn hat mi'i i'atu'e uhepiat yt uimohey haria i. Ta'i mu'ap pyhyp hap sa'up sat haria ahewa­nĩ­kaptia yt nakuaria i wy ok sese ne'i ti Mi'i Miit i'atu'e uhetiat are. Are pãi pyno ti uhehay pun haria mi'iria aikotã meimuẽ wuaria hira­karia te'eru­we­ma­hara hap e'at piat ewywuaria kahato uimienoi pun haria are. Iuwãu Uito ti yt uruwo'o'ewy hin i urueko ko'i ete ma'ato ti Tupana we'eg hap yn tuwẽtem uruwẽ pyi. Mi'i tupono we'eg haria tuwat kahato uruehay upi ma'ato irania'in ni uruehay pun haria ne'i te'ero­pyhu'at. Yt i'atuwe'eg hin i uruehay pun haria aikotã hira­karia yt urupap i e haria ewywuaria tukupte'en mesu­wa­ro­tiaria yt uimohey i haria e. Mi'iria — Yt urupopap hin i uruto e haria mi'iria. Yt kan hamo i ta'atupun Tupana ehay wakuat te'en ne'i uruwẽ piat are. Mi'i ewywuat mesu­wa­ro­tiaria yt uimohey i haria are e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mi'i pote Iesui tuwẽ­powat tehay pirik wo — Tawa Karireia piaria woro­ho'o­saty'i saty'i eipe katu­pono uhehay pun haria sese eipe. Aikopiat aikopiat uhewyry eimu'e hamuat uimi­sepap ko'i Tupana esaika wuat hap ko'i yt miit'in minug kuap i ko'i ati'atu­mo­herep kahato ehepe. Atunug kahato ra'yn ti eipy'a­setpe uhehay wakuap pywuat hap moherep hamuat wen ma'ato ewei'akasa yne mi'i ko'i pytkai uhehay pun haria wo eweikupte'en eipe. Yt naku i are. Yt uwe minug kuap ewywuat i ra'yn atunug ehehamo ma'ato ti yt ewei'atoiat teran hin i te eiminug sa'ag ko'i pãi are e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Tupana misaty'i saty'i ko'i wuano eweipyhu'at are tawa Korasĩ piaria tawa Pesaita piaria are. Meiũran wyti aru eweiwak kahato are katu­pono ho'opot kahato hanuaria eweikupte'en are. Wakuap sese hap ko'i ra'yn atunug ehehamo miit'in moehãite hap miit'in ky'e hap ma'ato mi'i pytkai yt eiwe­morem neran hin i Tupana kape eiminug sa'ag ko'i kaipyi are. — Sa'awy'i Tupana tiwuk ta'yn meimuẽ wuat tawa Tiru piaria tawa Sitãu miaria ewei'e yt naku i nug haria mi'iria pote ewei'e eiwo'ope ma'ato eipe ti po'og yt nakuat i tawa Tiru piaria tawa Sitãu miaria kai are katu­pono Uito areĩne'en mi'i tote mekewat e'at pe hawyi mi'i turan ti uiminug hap ko'i atomo­herep itotiaria pe pote uimohey haria ra'yn mi'iria te'ero­pyhu'at mesup are. Sa'awy'i te'eraha'at kuap uiminug wakuat ko'i kape hawyi meremo te'eru­we­morem Tupana kape are. Sa'awy'i­wuaria te'eraha'at pote meremo ta'atupag sokpe i'anam nakat hawyi te'era'apyk ta'yn ywytup tote i'atu­minug sa'ag atoiat hap moherep hamo ta'atueko ewy. Ma'ato atimo­herep ehetawa piaria pe iwato kahato hap uimohey hamuat wen ma'ato mi'i pytkai uimohey hap pun haria eweikupte'en are. Are pãi mi'i pote ti rat po'og yt naku i nug haria eweikupte'en tawa Tiru piaria kai tawa Sitãu puaria kai are e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Karãpe Tupana piat miit'in apiheg hap e'at put'ok'e ra'yn turan mi'i hap e'at pe ti aru po'og Tupana mi'apiheg ko'i wo eweipyhu'at tawa Korasĩ piaria tawa Sitãu ywania kai are e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","I'ewyte eipe tawa Kawana'ũ piaria — Wuat'i miit'in urukuap kahato haria ewei'e uruto iwato'in nakaria pote. Ta'i atipy piaria ewy uruwato pote ewei'e ma'ato yt hin i are. Eipe yt karãpe i put'ok'ewei'e atipy pe ma'ato Tupana mipugha wuat wyti eipe aria wato pe ti aru yt nakuaria i eipe pote. Sa'awy'i ti Tupana tiwuk ta'yn tawa Sitãu piaria yt nakuaria i pote. Pywo ti rat Uito areĩne'en itote mekewat e'at pe turan eiwa'a­kasa hap ko'i moherep hamo itotiaria pe mesup ta'yn uimohey haria wo tukupte'en katu­pono atimo­herep ta'yn uiminug wakuap sese hap ko'i sa'awy'i­wuaria tawa Sitãu piaria pe pote meremo ta'atu'atoiat ra'yn ta'atu­minug sa'ag hap ko'i are. Eipe ti ewei'akasa yne hawyi yt ewei'atoiat hin i eiminug sa'ag hap ko'i. Mi'i pote aria wato pe Tupana eipugha irane are katu­pono yt uimohey hin i eipe iwato kahato ra'yn atunug uimi­sepap eipy'a­setpe pytkai are. Nimo ti Tupana tiwuk ta'yn tawa Sutuma piaria yt naku i apiheg hap are ma'ato ti eipe po'og yt nakuaria i mi'iria kai are. Ta'i woro­ho'omu'e kahato ra'yn eipe ma'ato ti yt uimohey hin i are. Mi'i hap ok tã atunug sa'awy'i tawa Sutuma tawa Tiru pe pote itotiaria tukupte'en na'yn paa'e haria ta'atu­minug sa'ag ko'i etiat haria are. ");
INSERT INTO mavNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Karãpe ti aru Tupana wo'o'apiheg hap e'at put'ok'e ra'yn mi'i hap e'at pe ti aru po'og eipe Tupana mi'apiheg wuanuaria wo eweikupte'en mekewat tawa Sutuma piaria kai mekewat tawa Tiru piaria kai are e Iesui tehay pun haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mi'i hawyi Iesui to'e To'ywot pe Tupana pe — Ui'ywot e arehum kahato ra'yn ewawi Tupana. Yne atipy piaria ko'i Porekuat En i'ewyte mesu­wa­rotiat yi totiat Porekuat En are. Ta'i wuat'i Porekuat no ereĩne'en e. Waku kahato En Tupana katu­pono hira­karia ewywuaria — Yt uruikuap kahato i te En i'atu'e uhepe uimohey sese haria mi'iria e. Ma'ato irania'in — Uruikuap ta'yn po'og torania kai e haria. Uruto yn iwe'eg nakaria e haria pe yt atimo­herep hin i uwe uipo'oro hat e. Yt ta'atukuap hin i uwe hap En Ui'ywot Uipo'oro hat. Yt karãpe i mi'iria uimohey haria wo tukupte'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ta'i paa'e haria pe — Yt uruikuap kahato i te e haria pe etomo­herep ta'yn ti Uipo'oro hat ma'ato irania'in me — Uruto yn iwe'eg nakaria e haria pe yt etomo­herep teran i yt ekuap teran i yt emienoi ky'esat i haria pe are. Mi'iria ti yt karãpe i uhemiit no te'ero­pyhu'at e Iesui To'ywot pe. ");
INSERT INTO mavNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mi'i hawyi to'e i itotiaria pe — Mio Ui'ywot tum na'yn ni uhepe yne yne towanuat are. Uiwyria'in yt uwe i mesu­wa­ro­tiaria uikuap sese haria e. Ma'ato Ui'ywot yn ni uikuap sese hat. I'ewyte yt uwe i mesuwat yi totiaria Ui'ywot kuap sese haria e. Ma'ato Uito atikuap kahato Ui'ywot e. Ta'i Uito yn ikuap sese hat arepyhu'at are e Iesui itotiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mehĩ'in mana'in woro­ho'oky'e kahato torania eiperia pote eweĩ'ẽ ro uhowawi wuat'i miit'in e. Uwe uwe hatek takaria eweĩ'ẽ ro uhowawi e. Uwe uwe ho'opot hanuaria eweĩ'ẽ ro uhowawi e. Pywo pe ti uwe uwe tõ'ẽ uhowawi mi'i haria pe atum uiwepit hap ok tã e. Eweho'opot hap atu'u yne e. Ei'arot hap i'ewyte ahupit mekewat yt eimi­hupit kuap i hap e. Eiwe­mohy hap atum ehepe eweĩ'ẽ uhowawi pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uiwyria'in uheropat haria eweikupte'en pote po'og waku eweipuẽti mesuwat yi tote e. Pywo pe ti uwe uwe toto uhupi mi'i hat waku pe topyhu'at katu­pono uipotpap po'og waku torania kai e. Pywo uhe'yry­sakag ni yt ipotyi hin i yt sa'awy'iwuat yt ewywuat hin i e. Pyno eweĩ'ẽ ro uhowawi yne yne ehero hap wywo hawyi yt woro­ho'o­saty'i saty'i hin i ra'yn katu­pono uiwa­nẽtup hawe paa'e haria kahato eweipyhu'at e. Ehehaky'e'i hap atu'u kahato uipy'a pe e. I'ewyte uiperup'i kahato pote meremo eweipuẽti uikaipyi uimohey ehepiat hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Uimiium eipotpap hamuat yt ipotyi hin nakat i sa'awy'iwuat ewy i katu­pono eipotpap uhowawi pote woro­ho'o­po­wyro kahato hupit hap ete are e Iesui wuat'i miit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mi'i hawyi wẽtup e'at pe Iesui toto topot­mu'eria wywo awati ypia sakpo mekewat yt motpap i hap e'at pe. Mi'i hap tote hemiit'in ho'opik ta'yn awati ta'atuesy'at hap monik hamuat. ");
INSERT INTO mavNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma'ato irania'in mekewat seko wuat wo'omu'e haria pote te'eraha'at kahato hawyi wãi'i'atu'e Iesui pe — Wãi'ere ro emiit'in me Uhyt i'atu'e katu­pono yt aheko ewy i ta'atu­ho'opik awati yt aipotpap i hap e'at pe i'atu'e. Yt naku i Mehĩ mi'i tã watunug mesuwat e'at pe. Yt naku i awati wati­pirik katu­pono Tupana mõtypot hap e'at ti koity'i e'at i'atu'e seko moherep haria Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mi'i pote ma'ato Iesui — U pãi e yt karãpe i apo mekewat miwan miat eweimo­wẽpap are aikotã sa'awy'i aipo­rekuat Tawi tesy'at kahato tesu­rara'in wywo hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aikotã teke Tupana mõtypot yat pe hawyi mekewat Tupana mõtypot yat piat man ne'i ra'yn toimõ'ẽ tesu­rara'in me hawyi ta'atu'u ra'yn yt aheko yt ewy hin i mi'i morekuat Tawi tunug itote hap e. Ta'i pa'iria mi'u wuat ko'i yn waku rakat toimõ'ẽ tesu­rara'in me. Mi'i tã ti aipo­typot sa'awy'iwuat Tawi tunug e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yt karãpe i apo eiwemu'e mekewat Tupana ehay enoi hat Musei miwan ete aikotã yne Tupana mõtypot hap e'at pe pa'iria i'atu­potpap at ka'ap ne'i Tupana mõtypot yat apykok hap ete miit'in powyro hap ete ma'ato yt uwe i wãi'e i'atuepe. Ta'i pa'iria mi'iria wen ma'ato te'eru­we­potpap at yt aipotpap i hap e'at pe Tupana mõtypot hap yat apykok hamo pytkai yt uwe i wãi'e pa'iria pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mi'i hap ewy wyti urupotpap mesup pãi e. Pywo pe ti wẽtup ok toĩne'en na'yn eipy'a­setpe po'og po'og Tupana mõtypot hap topyhu'at mekewat to'yat nu kawiat kai e tuwepe seko moherep haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kat pote ti eweikat kahato uruepiat aparap hap aheko ehay upi yt kat i urutunug sa'ag pytkai e. Yt naku i eipy'a pe eweikat at ka'ap irania'in miat i'aparap hap ko'i katu­pono nimo te ti mio tã e Tupana ahepe — Pywo pe ti yt uimo­wepit hin i ti eheko eiminug ko'i e. Yt uimo­wepit hin i ti eihũria wuk hap ko'i mekewat eimiium uimõ­typot hamuat hap ko'i are katu­pono uimo­wepit hap sese ti sehaky'e'i haria irania'in hatek takaria ihaky'e'i hap uimo­wepit sese hap e Tupana. Uimo­wepit sese hap ti eiwe­wy'inug irania'in yt miky'e i ko'i wo hap e. Mi'i ti uimo­wepit sese hap e. Atiky'esat ehehaky'e'i hap uimo­wepit hap e Tupana sa'awy'i miwan me e Iesui wãi'e haria pe. Mi'i e hap ewetunug hawyi yt urumohit teran i katu­pono eweikuap ta'yn yt kat i urutunug sa'ag e Iesui wãi'e yn hap nug haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yt naku i ehemiit'in Uhyt ewei'e katu­pono ta'atu­ho'opik awati Tupana mõtypot e'at piat pote ewei'e ma'ato Uito waku kahato uhemiit'in are. I'ewyte meiũran aru karãpe kat som waku kat som yt naku i miit'in minug ahenoi Tupana pe mi'i hap e'at pe waku kahato mi'iria are Tupana pe. Tupana ui'airo Miit'in Eyke'et sese wo wuat'i e'at piano e. I'ewyte wuat'i e'at Ka'iwat wo uinug. Mi'i pote Tupana mõtypot e'at Ka'iwat areĩne'en i'ewyte. Mi'i pote kat som waku watunug kat som yt naku i watunug Tupana mõtypot hap e'at pe e hano i'ewyte Tupana uinug e Iesui wãi wãi'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mio tã to'e hawyi Iesui toto towyria'in upi awati ypia sakpo ra'yn. Mi'i totepyi toto hawyi teke ra'yn Tupana ehay enoi hawe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mi'i pe toĩne'en ipo kĩ'ã rakat i'atu­wywuat pe. Mi'i hawyi irania'in itotiaria ima'at reran Iesui haype — Waku apo watu­we­potpap mesuwat e'at pe miit'in moehãite hap ete sio yt i'atu'e tope katu­pono ta'atukat yt naku i e hap haype. ");
INSERT INTO mavNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mi'i hawyi toi'atu­wesat — Waku apo mesup e'at pe watiõtem aihũ yi ka'a pyi i'okhyt'at rakat sio yt e. Ta'i aihũ Uweuria ta'at yi ka'a pe Tupana mõtypot hap e'at pe pote ti meremo watihep aihũ e. Atikuap ti Tupana mõtypot hap e'at ewetiõtem eihũ yi ka'a piat at hat e. Tupana mõtypot hap e'at piat at hat yi ka'a piat meremo eweihep yt eweipotpap i hap e'at pe yt eweiky'esat iku'uro hap pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mehĩ'in mana'in are kat som po'og Tupana wanẽtup hawe sio aihũria sio aito e. Ta'i watikuap ti aito po'og po'og Tupana miky'e aihũ ko'i kai e. Mi'i pote waku wati'a­tu­moe­hãite miit Tupana mõtypot hap e'at pe e Iesui toma'at reran haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mi'i hawyi to'e ra'yn ipo kĩ'ã rakat pe — Uiwy e etitorok to e'yke uhowawi e. Mi'i hawyi meremo toitorok topo kĩ'ã hap wuat'i ehamo hawyi waku pe ra'yn topyhu'at kokawiat ewy te ihãite ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mi'i tã Iesui tunug Tupana mõtypot hap e'at yt ta'atueko ewy i pote seko etiat wo'omu'e haria tuwat itote pyi hawyi ta'atukat kahato aikotã waku Iesui auka hamuat. ");
INSERT INTO mavNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesui tikuap ta'yn to'auka hamuat ta'atukat hap hawyi toto pya i'atue'ya­ty­pepyi wẽtup hy kape toto. Typy'i kahato tuwat Iesui upi. I'ewyte i'ahu rakaria tuwat upi. Mi'i pote mu'ap upi toi'atu­moe­hãite kahato miit'in i'ahu rakaria. ");
INSERT INTO mavNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Toi'atu­moe­hãite torania hawyi to'e tomi­moe­hãite ko'i pe. — Yt ewehenoi henoi tei'o irania'in me eimoe­hãite uhepiat hap ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Toi'atu­moe­hãite kahato i'ahu rakaria aikotã sa'awy'i Tupana ehay enoi hat Isaia to'e hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Mio tã e Tupana — Meiũran ti aru atipo'oro Uhemiit sese ehowawi e. Pywo pe ti Uheropat kahato hat topyhu'at e. Uimiky'e kahato ti Mi'i Miit e. Uimo­wepit sese hat ti Uimi­po'oro e. Eweheha'at ro uimi­ky'esat nug hat kape e katu­pono Mi'i Miit ri Uipã'ãu eiam sese wo topyhu'at e. Mi'i Miit wyti aru imoherep uhepe uwe waku uwe yt hap e. Atimohey kahato Mi'i Miit katu­pono uiwa­nẽtup hap ewy yn tuwa­nẽtup e. Mi'i pote ihay upi ati'atue­ha­kyera'at reran wuat'i ywania yi totiaria. I'ewyte iwẽ pyi ati'atu'a­piheg irania'in yt imohey i haria wuat'i ywania yi totiaria e. Mi'i hawyi uwe uwe topyhu'at uimi'a­piheg wuaria wo uwe uimie­ha­kyera'at wuaria wo hap moherep hanuat Mi'i e. Mi'i Miit po wo ati'atu­po­hari ahiag po pyi imimoe­haky'e'i ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pywo pe Uimi­po'oro wyti aru perup'i puo kahato miit'in mu'e e. Yt tuwe­mo­wato hin i tehay wo miit'in me. Ma'ato ti topo­te­ha­kyera'at kahato e. Yt topot'uka hin i tehay wo miit'in ete. Yt ihay pirik hin i rakat paa'e kahato rakat topyhu'at e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Miit'in yt uwe miky'eria i ky'e hat uhemiit e. I'ahu kahato rakaria hatek takaria ihaky'e'i rakaria aikotã akuara pok'e rakat watomog hawyi tuwepy ihay se i ra'yn hap ewy kahato toi'atumog miit'in yt tuwehum kuap i po'og nakaria ete. I'ewyte yt iwẽ po hep hin i uhehay hãpyk takat moherep hap ete e. Mi'i Miit ti'atu'akit aru wuat'i miit'in ma'at haria e. Mi'i hawyi miit'in pyhyp haria toi'atu­moma yne e Tupana. ");
INSERT INTO mavNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Meiũran ti aru Mi'i Miit yn ni miit'in miekatup mo topyhu'at mesuwat yi tote e. Ta'i Mi'i Uimi­po'oro topyhu'at aru wuat'i ywania mimohey wo e Tupana yianmete Iesui etiat Isaia miwan me tohenoi. ");
INSERT INTO mavNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mi'i hawyi itotiaria terut Iesui kape ahiag ipiit piat rakat. Mi'i miit i'ewyte yt ihapytig i i'ewyte yt ihay kuap i. Yt toikuap i sehay katu­pono yt hewaure i rakat toĩne'en. Yt naku i kahato tuete. Mi'i hawyi meremo Iesui timo­ha­pytig. I'ewyte toimoehay i ra'yn mekewat miit. Mi'i hawyi ihay kuap i ra'yn ihapytig i ra'yn hewaure ka'a i ra'yn ipiit toikuap yne i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mi'i hawyi miit'in sem itotiaria te'eraha'at kahato imoehãite hat kape hawyi te'ero'e to'ope — Iesui apo Tupana Mipo'oro Aipo­rekuat nuat mekewat sa'awy'iwuat aipo­typot Tawi saipepiat apo'i'atu'e to'ope. Ta'i morekuat Tawi ewywuat kahato ha'yru sese pote i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mi'i e hap i'atu'a­kagnia tikuap ta'yn hawyi — Wãi nei'o i'atu'e. Mi'i Miit yt Tupana Mipo'oro hin i i'atu'e. Ahiag mipo'oro Mi'i i'atu'e. Ahiagnia porekuat saipepiat Iesui i'atu'e. Mekewat ahiagnia akag Peusepu saipepiat i'atu'e. Mi'i pote ahiagnia toi'atu­sytpok kuap katu­pono ti sa'awy'i ti ahiag tum ni tesaika hap tope. Mi'i pote toi'atu­po­rera'at kuap kahato mã'ãu sa'ag ko'i i'atu'e te'eru­wa­nẽtup hawe Iesui etiat. ");
INSERT INTO mavNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma'ato i'atu­wa­nẽtup sa'ag hap Iesui tikuap ta'yn topy'a pe hawyi to'e i'atuepe — Pywo pe ti are'e ehepe ahiag koro yt ti'atu­sopo teran hin i ti topã'ãu sa'ag ko'i miit'in myi pãi katu­pono ahiag koro yt tu'uka teran hin i temiit'in ahiagnia ete are katu­pono to'ope to'ope tu'uka ahiag hawyi meiũran te'eru­we­moma ra'yn. Aikotã aikotã wẽtup setawa piaria to'o'auka to'o'auka hawyi meiũran yt uwe kuap i tukupte'en hap ewy ahiag mipo'o­roria e. Aikotã to'o'auka to'o'auka wẽtup getap wiaria to'ywot toty tomẽpyt'in nywo to'o'auka hap ewy meiũran to'o'atoiat ra'yn hawyi yt uwe i ra'yn itote tukupte'en hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mi'i hap ewy kahato ti aru ahiag topyhu'at toi'atu­sopo topã'ãu ko'i temiit'in myi hawyi ti aru yt uwe i tukupte'en imipo'o­roria e. Atikuap kahato ra'yn eiwa­nẽtup hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ahiagnia morekuat ehay pyi toi'atu­sopo mã'ãu sa'ag miit'in myi ewei'e uhepe hap ma'ato yt mi'i tã hin i e. Eipe i'ewyte ewei'atumu'e kahato ti eipotmu'e mã'ãu sa'ag ko'i sytpok hap ete eipe ma'ato koitywy ati'atu­sopo kahato ahiagnia eimi­ky'esat ewy ma'ato wãi'ewei'e uhepe e. Kat poteĩ — Ahiagnia porekuat Peusepu ehay pyi ti toi'atu­sopo mã'ãu sa'ag ewei'e uhetiat e. Yt eiwe'eg hin i eipe e Iesui wo'omu'e haria akagnia pe seko moherep haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Eweikuap teran apo aikope pyi tut uhesaika hap ahiagnia sopo hamuat hap e. Pyno ahenoi aikope pyi uhesaika hap tut hap e. Ta'i Tupana Pã'ãu esaika hamo yn ti ati'atu­sopo mã'ãu sa'ag ko'i miit'in kaipyi e. Tutum yne ra'yn tesaika hap uhepe meimuẽwuat ko'i pore­nõtem hamuat e. Mi'i tupono ti koitywy Tupana topyhu'at ra'yn miit'in Porekuat no mesuwat yi tote katu­pono miit'in pore­kuaria ahiagnia urui'atu­po­re­nõtem mesup pote are katu­pono ati'atu'akit ne'i ra'yn ahiag i'ewyte ahiagnia pãi e Iesui wãi'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yt uwe i mesuwe teke kuap ipy'ahak takat yat pe hekare'en etiat ipohari hamo are ma'ato toipo'i po'i haity wo hawyi teke kuap hesaika rakat yat pe hekare'en etiat ipohari hamo e. Mi'i hap ewy kahato ti atunug ahiag porekuat ete Uito e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mehĩ'in eiwe'eg wo o uihoiro hap pupi are katu­pono uwe uwe yt uhemiit i topyhu'at mi'i hat yt uika­wiano i topyhu'at e. I'ewyte uwe uwe yt ikaykay i miit'in uhowawi mi'i haria tukupte'en uhowawiat miit'in pyhyp hanuaria wo e. Eiwe'eg wo o uipun iũte'en hap pupi ui'ywania e. Yt pote Tupana ewanĩ­kaptia wo aru eweikupte'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Eiwe'eg wo o Tupana Pã'ãu pun ehepiat hap pupi e. Pywo pe ti Tupana timo­hãpyk kuap kahato yne yne wyti ehehay sa'ag ko'i eiminug sa'ag ko'i toi'atu­mo­weityk kuap torania are ma'ato wẽtup ehehay sa'ag ni yt karãpe i toimo­hãpyk kuap i Tupana e. Karãpe Tupana Pã'ãu pywuat sese kaipyi ihay ehepe turan uhetiat eheha­kyera'at hat mi'i hawyi — Eso kahato ewei'e Tupana Pã'ãu me mi'i e hap wyti aru yt karãpe i Tupana timo­hãpyk kuap e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","I'ewyte kat ewei'e kat ewei'e sa'ag uimo­weuka'i hap Eheyke'et ete Eikywyt ete uhete mi'i hap ko'i sa'ag ti Tupana timo­hãpyk kuap te ma'ato uwe uwe Tupana Pã'ãu pywuat sese rakat ehay pe — Eso kahato rat e mi'i hat wyti aru yt karãmuo i ra'yn Tupana timo­hãpyk kuap wuat'i e'at piat ra'yn e Iesui — Ahiag ehay pyi eti'atu­sopo ahiagnia e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Pywo pe ti aimikoi ypia yt ihãite i hawyi yt tuweium kuap i ahepe e. Ta'i aimikoi yt haat rakat i yt karãmuo i hum kuap tosaat ahepe mekewat aimikoi saat he kahato rakat pote watikuap ta'yn yt naku i rakat. Ma'ato tuweium kahato ahepe aimikoi ywa ko'i pote wakuat kahato yp hap watikuap e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mi'i hap ewy kahato ti eipe seko enoi haria ypia yt ipiit i rakat ewy yt haat i rakat ewy yt hewo i rakat ewy eipe e. Yt kat i ei'e hap he rakat toĩne'en eikai­pywiat are katu­pono ti eiwẽ pyi ti sehay haiug nakat miit'in mosaty'i saty'i hamuat sehay sa'ag yn tuwẽtem na'yn eiwa­nẽtup saiwot hap kaipyi. Yt naku i kahato aikotã moi wo'o'auka hat wanẽtup hap ewy ti eiwa­nẽtup hap pãi e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mi'i hap ewy kahato eipe aikotã ahekare'en i'apyp takat ewy eipe e. Karãpe miit'in terut ahowawi ikahu kahato rakat ta'atuium mi'i hawyi — Waku aito watum aimiium ikahu kahato rakat wy wato'e. Ma'ato yt naku i watum ahekat pot'i yt ikahu rakat i irania'in miium waku ha'up mo wato'e e. Mi'i tã watunug pote yt hegyi'at i rakaria i watoĩne'en wato'e aiwo'ope e. Mi'i hap ewy waku e hap tuwa­nẽtup hawe wyti waku e hap ete wanẽtup hat ti toĩne'en na'yn ma'ato uwe uwe i'atunug tuwepe sehay sa'ag tuwa­nẽtup hawe mi'i hat wyti yt naku i rakat nuat ti toĩne'en na'yn e. Pyno ti waku wati'a­tunug ahekat waku rakaria ewy aiwa­nẽtup hawe e. Mi'i hawyi wahenoi kuap irania'in me ahekat aiwa­nẽtup hap wakuat ko'i e wo'omu'e haria akagnia pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Eiwe'eg wo o ehehay ko'i ko'i Tupana Pã'ãu etiat uhetiat uhemiit'in etiat hap pupi are wyti ehepe katu­pono karãpe Tupana tut urumo­weuka'i haria apiheg hamo mi'i hap e'at pe — Kan hamo ten mi'i tã ewei'e eimi­kyry'i wo uhete uhemiit'in ete e aru ehepe e. Mi'i hawyi kat ewei'e aru Tupana pe ei'apiheg hap e'at pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","— Ta'i yt nakuaria i kahato eipe e Tupana ehepe tut turan. Ehehay sa'ag uhete wyti i'ewyte uimohey haria ete i'ewyte wy Tupana Pã'ãu wakuat ete pote yt naku i ewetunug e. Pywo ti ehehay sa'ag hap ete Tupana to'e aru — Woro­ho'okuap kahato pote mesup uimi'a­piheg nuaria wo eweipyhu'at eipe katu­pono Uha'yru ete eiwe­kyry'i kahato eipe e aru ehepe ma'ato irania'in me — Wakuaria kahato eipe katu­pono yi tote eweikupte'en turan ei'e hap kaipyi atikuap Uha'yru mõtypot haria wo eweikupte'en e aru Tupana uimohey haria pe e. — Woro­ho'okuap imohey haria eipe ehehay kaipyi eweikupte'en yi tote turan e aru Tupana uimõ­typot haria pe e Iesui yt to'oksat'i i haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mi'i hawyi itotiaria wãi'e hap enoi haria te'ero'e Iesui pe — Etomo­herep to uruepe esaika hap atipy kaipywiat merep'e hap ewy yt miit'in mikuap i hap ko'i ewy i'atu'e. Mi'i tã etunug mote ti aru meremo ra'yn uruimohey En Tupana Mipo'oro ma'ato yt pote yt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","— U pãi e Iesui yt atunug neran i wyti iwato hap merep hap ewy miit'in uimohey hamuat are katu­pono yt naku i nug haria yt timohey kuap i ti mi'i pote — Tupana i'atu'e eremo­herep uhepe uimo'a­kasa iwato rakat kape atipy kaipyi mi'i hawyi woro­mohey En i'atu'e. Mi'iria wyti yt Tupana mohey i haria pote ra'yn mio tã i'atu'e. Ta'atu­ky'esat Tupana iã'ãkap ko'i ta'atu­mi­mohey ko'i wo heremo pote. Yt nakuaria i ra'yn nyti mi'i tã iky'esat e. Mesup ti eweiky'esat atunug iwato rakat uipo wo ehepiat kuap hamo ma'ato yt atunug neran hin i ehehay pyi e. Meiũran ti aru ma'ato atunug wẽtup iwato rakat uimohey ehepiat hamo. Iwato'in nakat atunug aru miit'in mowa­nẽtup kahato hamuat katu­pono mekewat e'at pe ti aru Uito Eheyke'et Eikywyt ti toĩne'en i hamuat tosyp hawyi mye'ym e'at yn toĩne'en tosyp hawe hawyi tuwẽtem i ra'yn gu'uro pyi e. Mi'i yn ni iwato sese rakat atimo­herep ei'akasa hamo uimohey hamo ehepiat e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Aikotã mekewat sa'awy'iwuat Tupana ehay moherep hat Iuna toĩne'en pira wato ymyẽ pe mye'ym e'at mye'ym ewãtym mi'i hawyi tuwẽtem i ra'yn pira wato ymyẽ pyi. Mi'i hap ewy kahato ti aru arepyhu'at Uito yi pe hawyi arẽtem i ra'yn uisyp hawyi ase'i Iuna toĩne'en i hap ewy e. Mi'i yn atunug iwato hap aremo­herep ehepe Tupana Mipo'oro sese Uito hap mohey hamuat. Ma'ato mi'i yn ni aru atimo­herep ehepe yt miit'in minug kuap ko'i i uimohey hamuat ma'ato arẽtem gu'uro pyi pytkai yt uimohey i aru eipe hap atikuap ta'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pyno toĩne'en koitywy wẽtup ok Iuna ewywuat eipy'a­setpe ewei'akasa hamo ma'ato ti Mi'i Miit ti po'og Tupana ehay moherep hat Iuna kawiat hat ma'ato yt uimohey i eipe e. Sa'awy'i te ti tawa wato Niniwe kape toto Iuna hawyi toimo­herep Tupana ehay i'atuepe. Mi'i hawyi paa'i'atu'e. Te'eru­we­morem kahato Tupana kape yt naku i nug hap kaipyi mekewat Iuna mienoi upi are ma'ato mesup ti wẽtup ok po'og Tupana ehay moherep hat aha'ase'i Iuna kawiat rakat toĩne'en eimu'e hat koro ehehamo ma'ato ahenoi henoi Tupana ehay ehepe pytkai yt eiwe­morem neran hin i eiminug sa'ag hap kaipyi Tupana kape e. Pyno eipe po'og yt nakuaria i mekewat tawa Niniwe piaria kai hamuat e. Karãpe Tupana tut uwe tomi'a­piheg wuaria enoi hamo mi'i hap e'at pe ti aru tawa Niniwe piaria pe — Waku rakaria eipe e aru Tupana i'atuepe. Ma'ato ehepe ti aru — Yt nakuaria i eipe katu­pono po'og po'og Iuna kawiat toĩne'en eipy'a­setpiat eimu'e hat Uimi­po'oro ma'ato uimi­po'oro ehay pun haria ne'i ti eipe e aru ehepe e Iesui wo'omu'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sa'awy'i morekuat wato hary­poria kawiat tut pya pyi at wẽtem hap moran kaipyi tut aipo­typot sa'awy'iwuat we'eg hap kuap hamo tut e. Ma'ato koitywy ti wẽtup ok ti toĩne'en eipy'a­setpe po'og we'eg morekuat Sarumãu kawiat hat ma'ato iwe'eg hap pun haria ti eipe e Iesui tuweete. Mi'i pote ti aru — Yt naku i kahato eipe e aru Tuana ehepe katu­pono Uimi­po'oro po'og we'eg nakat ehay pun haria eipe e mi'i pote woro­ho'o'a­piheg kahato eipe e aru ehepe mekewat ei'apiheg hap e'at pe e Iesui tehay pun haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mi'i hawyi po'og Iesui tohenoi ahiag ko'i etiat. Eiwe'eg wo o mã'ãu sa'ag mupi e katu­pono karãpe wẽtup mã'ãu sa'ag tuwẽtem wẽtup ok miit piit pyi mi'i hawyi kowo'i kowo'i hewyry kahato aikope aikope yahig upi aikope aikope ga'apy pe teiam kat hamo tuwe­mohy teran haype ma'ato yt toipuẽti i teiam itote hawyi ti aru tuwa­nẽtup i ra'yn tosaipe toĩne'en sa'awy'iwuat hap kape i e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mi'i hawyi ti ta'aipok teiam mot'i kape i ra'yn. Mi'i hawyi ti yt uwe i toipuẽti teiam mot'i pe hawyi waku te teiam mo topainug me toipuẽti hawyi toĩne'en i ra'yn temiit sa'awy'iwuat ahiag ipiit piat rakat e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mi'i hawyi — Pãi e waku kahato uheiam mo te i ra'yn mesuwat uhemiit e. Mi'i hawyi — To'iro ahiagnia e watu­wehyt'ok meiẽwuat miit pe uheiam mot'i pe e 7 ok takaria towyria'in me ahiagnia pe po'og sa'ag tokawiat mã'ãu ko'i pe. Mi'i hawyi ti tuwehyt'ok ta'yn mi'i miit pe hawyi po'og yt naku i rakano mekewat ipiit piat rakat sa'awy'iwuat kai. Sa'awy'i yt naku i tuwete ahiag ipiit pe toĩne'en mote. Ma'ato ahiag ta'aipok 7 wo hawyi po'og yt naku i mekewat miit ete sa'awy'iwuat kai e. Mi'i hap ewy ti aru eweipyhu'at eipe yt kat i Tupana Pã'ãu eweipag eipiit pe pote katu­pono mã'ãu sa'ag toto hawyi ta'aipok towyria'in wywo hawyi eipuẽti eipe waku pe te eiwe­painug turan waku te ei'yat toipuẽti ewehy­wytip we toipuẽti eipe. Mi'i hawyi mã'ãu sa'ag ko'i tuwehyt'ok eipiit pe yt uwe i itote pote. Mi'i hawyi ahiag sem eiam eweikupte'en yt uimohey i pote. Yt uwe i Tupana Pã'ãu eipiit piat pote meiũran po'og sa'ag na'yn eweikupte'en sa'awy'iwuat kai e Iesui itotiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mio tã e Iesui turan ity iywyt'in nywo yt pya i aikope toĩne'en hap kai hawyi te'eru­wẽ­powat — Uruehay teran ewywo Uimẽpyt Urueyke'et i'atu'e. Eriot ro uruewawi oken kape i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mi'i hawyi toto wẽtup ok henoi hamo — Iuẽ ety eywyt'in ekaykay Mehĩ e. I'atuehay teran ewywo Uhyt e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mi'i pote Iesui to'e — U pãi are uwe uity uwe'in uheywyt'in uwe'in uheinyt'in e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eweha'at ro uipot­mu'eria meiũpiaria kape are katu­pono uwe uwe uhehay nug haria mi'iria tukupte'en ni uity'in no uheywyt'in no uheinyt'in no e. ");
INSERT INTO mavNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Katu­pono ti uwe uwe Ui'ywot atipy piat miky'esat nug haria yn ni tukupte'en uity'in uheywyt'in uheinyt'in tukupte'en uiwa­nẽtup hawe e Iesui itotiaria pe iwanẽtup haria pe. Mi'i hap etiat atikuap kahato pote ahenoi mesuwe uimiwan me uito Mateu. ");
INSERT INTO mavNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mi'i hawyi mekewat getap wyi Iesui tuwẽtem na'yn hawyi toto i ra'yn yi Karireia hyemyi'a wato kape. Mi'i tote ta'apyk yi kyt rote yẽpeke. ");
INSERT INTO mavNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mi'i hawyi miit'in sem kahato tõ'ẽ tõ'ẽ howawi. Mi'i pote teke ra'yn yara wato pe itote pywiat yẽpe upiaria mu'e hamo. Typy'i kahato rakaria toi'atumu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Toi'atumu'e kat ko'i kat ko'i ete hã'ãkap wuo. — Sa'awy'i so wẽtup ok toto toko kape hã'ỹi sytpok hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mi'i hawyi so toko tote put'okto'e hawyi tohytpok hã'ỹi wakuaria so tohytpok toko pe e. Mi'i so ta'at yi wakuat rote e ma'ato go py'asetpuo mu'ap ẽpe upi hewo hewo irania'in hã'ỹi ko'i so. Mi'i ko'i so weitaria tu'u yne ne'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Irania'in ni yi perup nu totiat ko'i tote hewo hewo e. Mi'i totiat so hẽtyt wen e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma'ato meiũran at hakup hawyi ti iku'uro kat pote yt toto kuap i hapo yi piit kape nu totiat ne'i pote e. Mi'i pote meiũran itag na'yn hawyi meremo iku'uro e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma'ato irania'in hã'ỹi ni hewo hewo te'en te'en i'anam me e. Mi'i ti i'ewyte hẽtyt wen ma'ato i'anam mywo to'o'ewy wewuat'i pote meiũran i'anam tohik ne'i ra'yn yt tuwenug i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma'ato irania'in hã'ỹi yi wakuat rote go sese tote hewo hewo rakaria wyti i'atue­hãite kahato te'eru­wenug kahato e. Ta'i wẽtup yp kaipyi 100 iã'ỹi toipuẽti. Mi'i hawyi wẽtup yp kaipyi 70 iã'ỹi toipuẽti. Mi'i hawyi wẽtup yp kaipyi 30 iã'ỹi hap ewy yi wakuat rakat rotiat hewo rakat hã'ỹi ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mi'i tupono are'e ehepe ehewaure ka'a pote eweiwa­nẽtup kat ui'e kat ui'e hap kape uhehay iã'ãkap wuat kape eiwa­nẽtup o e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mi'i hawyi Iesui potmu'eria tõ'ẽ howawi — Uhyt i'atu'e kat hamoĩ sehay hã'ãkap wuat eti'atumu'e irania'in i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","— Ta'i yt uimohey i haria ti ati'atumu'e hã'ãkap wuo yt heremo i ma'ato ehepe uimohey haria ti sehay wo herep wuo woro­ho'omu'e aikotã aru Tupana topyhu'at Miit'in Porekuat no mesuwe atipy piat ewy hap ete e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Katu­pono uwe uwe uhehay ikuap teran mi'i hat pe ti aru po'og topyhu'at uhehay e. Ta'i uhehay ahyt kuap teran hat topyhu'at uhehay kuap sese hat e. Ma'ato irania'in yt uhehay kuap teran i haria ti aru yt kat i i ikuap aru uimienoi ko'i e. Uhehay kurin ta'atukuap ta'atusu'at hawyi tuwat hawyi meremo ta'atu­waure i ra'yn uhehay mi'i haria. Uhehay yt teke sese i i'atu­wa­nẽtup hawe pote e. Te'eru­we­wa­nẽtup ran haria ewy mi'iria. Ta'atu­wa­nẽtup hawe yt ta'atunug neran i uhehay pote yt teke sese i i'atu­wa­nẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mi'iria te'eraha'at uhowawi wen ma'ato yt uikuap wytkai i e. I'ewyte uhehay teke i'atu­waure pe wen ma'ato yt ta'atukuap i kahato ta'atu­wa­nẽtup hawe kat are kat are sese hap yi sa'ag ewywuaria mi'iria pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aikotã sa'awy'i Tupana ehay enoi hat Isaia to'e miwan me hap ewy — Teke kahato uhehay i'atue­waure ka'a pe wen ma'ato yt put'ok'e i i'atu­wa­nẽtup hawe e Tupana Isaia miwan me 6.9 pe. I'ewyte uiminug wakuat ko'i kape te'eraha'at kahato ra'yn wen ma'ato yt ta'atukuap i uwe Uito hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Katu­pono sehay pywuat Tupana piat yt he hin i i'atu'e te'eru­wa­nẽtup hawe ta'atupy'a pe. — Uruikuap ta'yn emienoi i'atu'e uhepe wen ma'ato yt ta'atunug i te. — Yt urumu'e po'og mekewat ete i'atu'e katu­pono uruikuap ta'yn yne urumu'e hap i'atu'e yt ta'atukuap hin i te pytkai. Yt ta'atukuap teran i pote mi'i tã i'atu'e at ka'ap e Tupana katu­pono ta'atusu'at su'at i teran uhehay ta'atuwẽ puo ma'ato te'eru­wa­nẽtup hawe wẽtup sehay kape ra'yn te'eru­wa­nẽtup e. Yt ui'e hap hin i i'atu­wa­nẽtup hawe. Yt naku i kahato rat mi'iria wanẽtup hap atipuẽti pãi e Tupana. Ta'i te'eraha'at ri uhehay kape miwan kape wen ma'ato ti te'eru­wa­nẽtup wẽtup kape ne'i e. Ma'ato pywo ta'atukuap teran uhehay pote ta'atukuap kuap e. I'ewyte pywo te'eraha'at teran mote ti te'era'a­kasa ra'yn e. Mi'i hawyi heremo yne i'atu­wa­nẽtup hawe uikuap hap topyhu'at e. Mi'i hawyi ti te'era'aipok uhowawi ta'atu­minug sa'ag hawyi paa'i'atu'e uhowawi hawyi uimohey haria wo te'ero­pyhu'at e. Uimi­moe­haĩ­teria wo ra'yn hawyi tukupte'en uimie­ha­kye­ra'aria wo ra'yn tukupte'en hawyi uhehay ta'atu­ky'esat ra'yn hawyi e Tupana sa'awy'i Isaia henoi e Iesui. — Pywo pe ti Isaia e hap ewy kahato tukupte'en yt uimohey i haria e. Mi'i pote ati'atumu'e mi'iria hã'ãkap wuo yt ta'atukuap teran i pote e. Ma'ato eipe uiwyria'in uimohey haria sese ati'atumu'e teran uhehay sese eweikuap teran haria pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mi'i tupono Tupana mimo­wepit ko'i wo eweikupte'en po'og torania miit'in kai katu­pono ui'akasa hap sese ko'i eipe i'ewyte uhehay sese kuap haria eipe e. Mi'i pote Tupana mipoi­tyro ko'i wo eweikupte'en kahato eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Uipot­mu'eria pywo pe ti sa'awy'i­wuaria Tupana ehay moherep haria ti te'era'a­kasa teran kahato ei'akasa hap ko'i kape e. I'atupap kahato uhowawi te'era'a­kasa hamo. Sa'awy'i­wuaria aikotã aru uhut hap moherep haria te'era'a­kasa ma'ato ta'atu­mu'etu wuat ewy te'era'a­kasa sa'awy'i­tewuat wakuaria te'era'a­kasa teran. I'ewyte ta'atukuap teran kahato uiwẽ piat eimikuap ko'i are ma'ato ti yt ta'atukuap kuap i ta'atukat pytkai e. Mi'i pote eheha ehewaure Tupana mipoi­tyro ko'i sese tukupte'en mesuwe e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Uiwyria'in mio ahenoi ra'yn wyti ehepe kat are kat are hã'ỹi iã'ãkap wuat hap ko'i are katu­pono atiky'esat eweikuap uimienoi mikoi yp etiat sehay iã'ãkap wuat hap e Iesui topot­mu'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mekewat hã'ỹi sytpok hat wyti Tupana ehay sytpok hat ewy e. Mi'i hawyi mekewat go pu'ap ẽpe upiaria ti wẽtup ok wẽtup ok uhehay kapiat wanẽtup hat ewy e. Mi'iria ti ikuap sa'ag ne'i e. Mi'i pote mi'iria kaipyi ahiag tihep te'en te'en ne'i i'atupy'a pyi Tupana ehay e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","I'ewyte ti mekewat hã'ỹi nu totiat yi hit rotiat ti wẽtup ok ti wẽtup ok ti wanẽtup teran hat ewywuat ne'i e. Mi'i hawyi meremo waku kahato toipuẽti uhehay wen e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma'ato yt teke i iwanẽtup hawe sese meimuẽwuat uimienoi ko'i yt i'atu­sapo wo i pote e. Mi'i turan ti irania'in ti'atu­saty'i saty'i ra'yn Tupana ehay mohey i'atuepiat hap. Mi'i pote ta'atu'atoiat ra'yn Tupana ehay e. Sa'awy'i te ti ta'atu­mohey kahato wen ma'ato mi'i turan ti irania'in to'okyry'i ra'yn mote te'eru­we­mõti ra'yn uimohey hap pupi e. Mi'i hawyi typy ehay ete te'eru­wa­nẽtup at ka'ap. Mi'i hawyi Tupana ehay kape yt te'eru­wa­nẽtup i ra'yn hawyi kat aru kat aru atunug kat aru atunug e hap kape yn na'yn te'eru­wa­nẽtup at ka'ap. Mi'i hawyi Tupana ehay kape yt te'eru­wa­nẽtup kuap i. I'ewyte — Uhekat iwato kahato hawyi uimo­wepit hap sese toĩne'en aru i'atu'e e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mi'i hawyi ta'atukat hap ky'ewi yn tukupte'en i'atu­wa­nẽtup hawe at ka'ap hawyi Tupana ehay yt tuwenug kuap i i'atupy'a pe. Hu ypia tohik ne'i ra'yn hap ewy topyhu'at i'atupy'a pe. I'anam kahato ga'apy piat ewy itote pote yt tuwenug hin i. Mi'i hap ewywuaria ti typy ehay ky'e kahato haria aimikoi i'anam miat ewywuat e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma'ato mekewat yi wakuat rotiat ti wẽtup ok wẽtup ok hewaure kahato rakat ewy. Mi'i hat sat'e kahato ka'a wanẽtup hawe. Mi'i hawyi Tupana ehay toikuap kahato topy'a pe hawyi tutunug kahato ra'yn Tupana e hap ewy e. Mi'i ti yi wakuat rotiat at hat hã'ỹi ihãite kahato rakat ewywuat e. Mi'i ti wẽtup ok 100 wẽtup ok 60 wẽtup ok 30 iã'ỹi ewywuat ra'yn e Iesui topot­mu'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Koitywy ahenoi teran ehepe wẽtup i uhehay aikotã Tupana topyhu'at miit'in Porekuat no mesu­wa­rotiat. Aikotã toĩne'en Morekuat atipy pe hap ewywuat e Iesui. Mio tã are'e Sa'awy'i so wẽtup ok toto toko kape hã'ỹi ko'i koi hamo hawyi toikoi at iã'ỹi waku aimi'u man wuat rakat iã'ỹi toikoi at itote e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ta'i man wuat waku rakat iã'ỹi tohytpok kahato ra'yn itote yi perup we. Waku pe itote hawyi ta'aipok i ra'yn to'yat kape e. Ma'ato wãtym muo iket kai wẽtup ok hewa­nĩkap toto iko kape imikoi py'asetpuat wẽtup kawiat iã'ỹi yt mi'u i rakat iã'ỹi koi man wuat waku rakat iã'ỹi ewywuat wen ma'ato nop takat toikoi ka'ap tewa­nĩkap ko moma hamo mikoi mo'anam hamo toikoi hã'ỹi ran man wuat ewywuat mikoi ka'iwat ket kai toikoi e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mi'i hawyi meiũran hẽtyt to'opype ra'yn man wuat waku rakat ypia to'opype ra'yn iã'ỹi ran ko'i wywo e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mi'i hawyi meiũran go ka'iwat ko eropat haria tuwat iko kape imikoi waku sio yt hap kuap hamo tuwat i'yat kaipyi. Te'era'a­kasa hawyi aikotã imikoi ypia pe to'opype ra'yn yt nakuat i iã'ỹi rakaria wywo iã'ỹi yt mi'u i rakat ta'atukuap hawyi te'era'aipok go ka'iwat kape henoi hamuat — Uruka'iwat i'atu'e sa'awy'i kue etikoi iã'ỹi wakuat yn eko pe i'atu'e. Pywo pote aikope pyi saĩke hẽtyt yt mi'i i yn i ra'yn i'atu'e. Uwe saĩke ikoi eko pe yt waku rakat iã'ỹi i i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","— Ta'i ahewa­nĩ­kaptia mikoi ra'yn ti som e toi'atu­wesat. — Pyno waku wati­puruk ta'yn emikoi py'asetpiat ko'i ahewa­nĩ­kaptia mikoi i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ma'ato — Yt eweipuruk tei'o e katu­pono eweipuruk pote ti ten mekewat uimikoi wakuat rakat ko'i ẽtyt turan ne'i ra'yn eweipuruk i'ewyte to'opype pype pote e. Waku ra'yn aru to'opype te'ere­motag e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pyno waku toywyt pe te'ere­motag e. Mi'i hawyi iterek hap e'at pe ra'yn aru ipotpap takaria pe are'e — Eweiterek to mekewat wanĩkap mikoi sa'ag yt man yt naku i mi'u rakat nug hap iã'ỹi ewywuat nop takat mi'i hawyi ewei'apeman kytyt sok hawyi eweiwuk to aria pe e. Mi'i tã ewetunug hawyi waku eweterut ro uimikoi sese torania meikowo ui'yat wato kape hawyi waku mesuwe e mikoi ka'iwat koro temiit'in me e Iesui. — Mi'i ui'e hap ewy kahato Tupana topyhu'at Morekuat nuat mesuwat yi tote aikotã toĩne'en Morekuat no atipy pe hap ewy e Iesui hyemyi'a ẽpe piaria pe miit'in sem me. ");
INSERT INTO mavNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mi'i hawyi wẽtup hã'ãkap i ra'yn Iesui tunug yi kyt upiaria mu'e hamo. — Pyno ahenoi teran ehepe wẽtup sehay aikotã Tupana toĩne'en aru mesuwe Morekuat no aikotã atipy pe hap ewy e. Ahetama pe toĩne'en mutata ypia aimikoi aimi'u apopyt kahato mi'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma'ato watikoi iã'ỹi kurin kat hawyi hẽtyt hawyi meremo tuwe­motag hawyi i'yp po'og iwato irania'in aimikoi ko'i kai ma'ato hã'ỹi kurin kahato torania irania'in aimikoi iã'ỹi ko'i kai topyhu'at e. Tuwe­koran mowato kahato ra'yn e. Ikoran wato hawyi weitaria tõ'ẽ tõ'ẽ kahato te'eru­wesok nug ikoran miat upiat hamo e. Mi'i hap ewy ti aru Tupana topyhu'at Miit'in Porekuat no mesuwe aikotã atipy piat hap ewy e Iesui yara pyi yẽpe etiaria kape. ");
INSERT INTO mavNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pyno ahenoi i wẽtup uhehay ehepe aikotã aru Tupana topyhu'at Morekuat no mesuwe miit'in py'asetpe hap etiat i ra'yn e. Karãpe hary­poria'in tunug u'i ta'atu'apõi mekewat kurin kat mani pyre ipuk wywo mi'i hawyi tuwe­mo­wato ra'yn mani puk ipyre wywo hawyi. Sa'awy'i kurin kat tuwe­mo­wato ra'yn ipuk toi'apõi ipyre wywo hawyi. Mi'i hap ewy kahato Tupana topyhu'at Morekuat no mesuwat yi tote aikotã toĩne'en atipy pe hap ewy e Iesui hyemyi'a Karireia upiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sehay iã'ãkap wuo yn toi'atumu'e miit'in sem ko'i itote yt heremo i hap ewy toi'atumu'e teran typy'i rakaria. ");
INSERT INTO mavNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Toi'atumu'e hã'ãkap aikotã sa'awy'i­wuaria Tupana ehay moherep haria mienoi hap ewy — Meiũran ti aru areto miit'in mu'e hã'ãkap wuat hamo e. Mi'i hap e'at pe ti aru uiwẽ pyi tuwẽtem hã'ãkap wuo yn yt uwe mikuap i te sehay pakup po'og ikahu rakat po'og hãpyk takat. Mi'i ti irania'in yt ikuap i te yt uwe mikuap i te e. Ta'i yi nug hawyi te yt uwe ikuap takano i ati'atumu'e miit'in hã'ãkap wuo e Tupana sa'awy'iwuat Tupana ehay moherep hat Tawi wepy hawe 78.2 pe. ");
INSERT INTO mavNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mi'i hawyi Iesui to'e itotiaria pe — Toran na'yn ui'e hap eimu'e hap e. Ewei'aipok to ehetawa ko'i kape e. Mi'i hawyi toto ra'yn ihyemyi'a totepyi wẽtup getap kape temiit'in nywo yn na'yn 12 ok takaria wywo. Mi'i hawyi put'okta'atu'e hawyi hemiit'in te'ero'e — Urumu'e hat i'atu'e yt uruikuap hin i ti emienoi hã'ãkap wuat i'atu'e. Ehenoi ro mi'i emienoi hã'ãkap wuat uruepe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mi'i pote toi'atu­wesat — Mekewat iã'ỹi wakuat koi hano ewy ti Uito Eheyke'et e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mekewat go ewy ti wuat'i ywania uhehay kapiat wanẽtup haria mesuwat yi wato totiaria e. Mekewat hã'ỹi wakuat man nug hamuat ewy ti Tupana mipo'oro ko'i wuat'i tama kapiaria ko'i uimohey haria — Waku watunug Tupana Aipo­typot no e haria are ma'ato mekewat hã'ỹi yt nakuat i yt mi'u hã'ỹi rakat i ahiag ehay moherep haria mekewat ahiag sa'yru'in saki'yt'in e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mekewat wanĩkap iã'ỹi wẽtup koi hat ti ahiag e. Mekewat iã'ỹi terek haria ti atipy kaipy­wiaria Tupana eropat haria atipy piaria e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ikahuro hap e'at pe ati'atu­po'oro atipy piaria yt uimohey i te haria miit'in atunug hamo ati'atu'a­piheg hamo. Aikotã wanĩkap mikoi ta'atu­sokwuk hap ewy atunug aru ahiag ehay mohey haria ete e. Mi'i tã ti aru aikotã iã'ỹi terek hap e'at piat ewy aru topyhu'at mekewat ikahuro hap e'at turan e. Iã'ỹi terek haria meimuẽwuat atipy kaipy­wiaria ewy te'ero­pyhu'at are ta'atu­po­rera'at ahiag mẽpyt'in wuat'i ywania etawa piaria e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Uito ti Eheyke'et Eikywyt no areĩne'en mi'i tupono ti aru mekewat e'at pe ati'atu­po'oro atipy piaria yt naku i nug haria atunug yne hamo e. Pywo ti mekewat yi kahuro hap e'at pe — Ewete­ropo'ok to uhowawi wuat'i sa'ag nug haria ahiag upiaria are aru e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ewei'atunug no uhemiit'in ma'at haria are ti aru. Mi'i hawyi ewehytmoi ro mi'iria aria wato haiwot rakat pe are aru mesuwat yi kahuro turan. Mi'i hawyi ti aru to'okak'i kahato ti aru i'ewyte ti aru kyry'et kyry'et'i'atu'e haty kahato ta'atuetiat pote e. Aria sakup kahato pote kynkyn'i'atu'e ahiag mikoi ko'i ewywuaria e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma'ato meimuẽwuat Tupana miky'esat nug haria pe ti aru — Eipe ti uimo­wepit haria wo eweikupte'en are aru. Eipe ti uimi­mõ­typot nuaria mesup are ti aru. Eipe ti iwato'in nakaria wo Tupana etama piaria are ti aru. Eiminug wakuap ko'i Tupana mõtypot hap ko'i Tupana mowepit hap topyhu'at wuat'i e'at pe. Aikotã ihot'ok hap aimo­wepit hap ewy eweikupte'en aru are Tupana miky'esat nug haria pe. Uiwyria'in ehewaure ka'a pote eipotpap to uhehay kuap hap ete e Iesui topot­mu'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Pyno wẽtup i ahenoi sehay iã'ãkap ehepe are aikotã Tupana topyhu'at Morekuat no mesu­wa­rote aikotã toĩne'en atipy pe hap ewywuat e Iesui. Wẽtup ok so ipotpap wẽtup ok ko ete turan tepu­rure wo toipuẽti yi pe miit'in miãuka imehit kahato rakat. Hekat sok toipuẽti yi ywyt'okpype tepu­rure wo ipotpap turan e. Mi'i hawyi so — Pãi e ta'i atiky'esat kahato rat meiũwat uiano e topy'a pe. Mi'i hawyi so tohyp i yi piat tomi­puẽti hawyi toto ra'yn mekewat yi ka'iwat kape to'e hamo — Atikyi'at reran eko mehĩ e. Atum ni aru emiky'esat ok tã ha'up epe pãi e. Mi'i hawyi toikuap karania upi hawyi iwepit kahato hap wywo toto to'yat kape yne towanuat weneru hamo. Toiwe­neru toko to'yat tekare'en ko'i kat ko'i kat ko'i tomie­reko ko'i toiwe­neru yne yne ra'yn hawyi mi'i sa'up mo toikyi'at mekewat yi aikope toipuẽti yi pe mekewat hekat e. Mi'i hap ewy ti Tupana ti'atukyi'at aru mesu­wa­ro­tiaria temiit'in no hawyi yi Porekuat no i ra'yn topyhu'at e Iesui sehay iã'ãkap wuo. ");
INSERT INTO mavNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Uiwyria'in e wẽtup uhehay hã'ãkap i ra'yn ahenoi teran ehepe aikotã aru Tupana topyhu'at Morekuat no mytyp tote aikotã atipy piat hap ewy e Iesui temiit'in me. Sa'awy'i so wẽtup ok karaiwa toto wahi ko'i kyi'at hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mi'i hawyi so wahi wẽtup po'og ikahu sese rakat torania kai toipuẽti itote ikahu kahato rakat. — Meikowat wahi nu sa'up iwato kahato rakat kawiat e tuwa­nẽtup hawe. Imehit kahato rakat pãi e. Po'og po'og hekat rakaria wuat kai torania irania'in kai mi'i wahi ikahu e. Yt wẽtup i po'og hekat rakat wuat atipuẽti uito mesuwat wahi kahu hap ok tã e so. Mi'i hawyi so toiky'esat kahato topy'a pe hawyi so toiwe­neru yne tomie­reko to'yat te'yi tomikoi hawyi mi'i sa'up mo toikyi'at ra'yn mekewat wahi towanuat e. Pywo pe ti mi'i kyi'at hap ewy kahato Tupana tikyi'at aru wuat'i ywania towanuat hawyi topyhu'at Ka'iwat no aikotã toĩne'en atipy pe hap ewy e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mi'i hawyi — Uipot­mu'eria pyno wẽtup sehay iã'ãkap i atimo­herep ehepe aikotã Tupana topyhu'at miit'in Porekuat no hap e Iesui. Sa'awy'i so toto wẽtup ok pira pytyk hamo ihyemyi'a wato kape tesuki wato totioto. Mi'i hawyi so toipun na'yn tesuki wato y'y wato pe pira pytyk hamo e. Mi'i hawyi hesuki howapy kahato pira ko'i wo aikotã aikotã hap ko'i tukupte'en hesuki wato pe so e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mi'i hawyi totekyi yẽpe kape hawyi yi kyt rote ti ta'apyk hawyi toi'airo ra'yn meimuẽwuat pira wakuat ko'i hawyi toipat'ok pira ko'i waku aimi'u wo rakaria toi'atu­hytmoi te'yara pe ma'ato yt naku i rakaria toipugha ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mio wuat uimienoi ewy ti aru topyhu'at mesuwe torania ra'yn hap e'at pe Tupana ti'atu­po'oro temiit'in atipy piaria wakuaria eropo'ok hamo i'ewyte yt nakuaria i eropo'ok hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mi'i hawyi ti aru yt nakuaria i ta'atu­pugha ra'yn ti aria haiwot rakat ieĩne'en hawe e. Mi'i pe ti aru yt naku i nug haria to'okak'i kahato haty pono aria pe i'ewyte to'okyry'et i kahato haty pono kynkyn'i'atu'e aru e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mi'i hawyi Iesui to'e temiit'in me — Eweikuap apo mio wuat uhehay hã'ãkap wuat e. Mi'i pote — Ta'i Urumu'e hat uruikuap som i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","— Pywo eweikuap hawyi waku eweimõ'ẽ uhehay eimikuap irania'in me are katu­pono uwe uwe ikuap sa'awy'iwuat Tupana ehay hap i'ewyte ikuap te uhehay pakup i hã'ãkap wuat hap ko'i aikotã Tupana topyhu'at Miit'in Porekuat nuat hap etiat mi'i hat ti aru topyhu'at wuat'i sepap hanuat sehay wuat wo'omu'e hanuat topyhu'at e. Ta'i mi'i hat ti aru topyhu'at morekuat hekat rakat iwe'eg kahato hat ewywuat topyhu'at aikotã kare'en pakup mywo kare'en mot'i wywo toiwe­neru kuap hat ewy topyhu'at e Iesui topot­mu'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesui henoi yne ra'yn mekewat hã'ãkap wuat tehay hawyi ta'aipok i ra'yn tomotag hap tawa Nasare kape. ");
INSERT INTO mavNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Put'okto'e itote hawyi teke i ra'yn Tupana mõtypot hap getap we i ra'yn itotiaria mu'e hamo. Mi'i hawyi itotiaria te'eru­wa­nẽtup kahato ta'atumu'e hap kape hawyi — Koitywy ti tuwe'eg kahato ra'yn aimi­motag i'atu'e to'ope. Aikope saĩke toipuẽti tuwe'eg hap i'atu'e katu­pono koitywy toimo­herep kuap kahato topo wo yt miit'in misepap hin i ko'i ra'yn i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ma'ato watikuap ta'yn sakpo Mi'i Miit aimi­motag i'atu'e. Ta'i mekewat pan'i pan'i'e hat sa'yru mekewat mana Maria mẽpyt i'atu'e. Ta'i watikuap kahato iywyt'in mehĩ Tiaku uhyt Iuse mehĩ Simãu uhyt Iuta i'atu'e. Ta'i i'atueyke'et sese Mi'i Miit i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","I'ewyte inyt'in ni tukupte'en meiũpe i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pyno aikope pyi som pyno iwe'eg kahato hap tut i'atu'e to'ope. Uwe saĩke imu'e iwe'eg hap ete i'atu'e sa'ag ta'atu­mohit reran haype. Mi'i pote — Ta'i yt uimohey hin i eipe uimotag haria e Iesui. Irania'in tama puaria ti ma'ato uimõ­typot kahato are ma'ato eipe yt ra'yn e. Ma'ato irania'in te'ero'e — En ni Tupana Mipo'oro tehay enoi hanuat i'atu'e irania'in tawa piaria ma'ato eipe uimotag haria sese ui'yat piaria sese uiwyria'in sese uhetawa sese puaria yt uimõ­typot hin i haria eweikupte'en e. Mi'i e hap ewy kahato uimi­po'o­roria uhehay moherep haria ma'ato ta'atu'y­wania sese ta'atu­motag haria yt timohey hin i uimi­po'o­roria e Tupana sa'awy'i miwan me. Mi'i hap ewy kahato topyhu'at mesuwe ahetama pe pãi e. Yt naku i mi'i tã mehĩ'in mana'in e. ");
INSERT INTO mavNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mi'i hawyi Iesui yt tunug kuap i tewaku hap miit'in yt minug kuap i ko'i ewy itote tawa Nasare pe katu­pono imotag haria yt imohey i kahato haria wo tukupte'en mote. Ta'i mi'i tã hap ewy itote. Mi'i hawyi uito Mateu atiwan mesuwe. ");
INSERT INTO mavNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mi'i hawyi ti yi Karireia piat morekuat Eroti tikuap ta'yn Iesui aikotã iminug wakuap etiat. ");
INSERT INTO mavNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mi'i hawyi Morekuat Eroti to'e tu'isaria pe — Koitywy toĩne'en uhetama pe wẽtup ok wuat'i nug kuap hat Iesui e hap het rakat e. Uwe sese Mi'i Miit hap atikuap ta'yn e. Ta'i mekewat uimi'a­kagtek wo'oset'ok hat Iuwãu wyti tuwẽtem gu'uro pyi e. Ta'i tuwẽtem gu'uro pywiat hawyi ti mio tutunug yt uwe misepap kuap takat i ra'yn e Eroti morekuat yi Karireia piat tu'isaria pe Iesui etiat. ");
INSERT INTO mavNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mio tã e katu­pono sa'awy'i mekewat morekuat Eroti ti'atu­po'oro tesu­rara'in Iuwãu pyhyp hamo. Mi'i hawyi ta'atupo'i po'i hawyi ti ta'atupag wo'opyhik hawe. Mi'i tã ti Eroti tunug sa'awy'i Iuwãu ete. ");
INSERT INTO mavNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Toipyhik Iuwãu wo'opyhik hawe sa'awy'i katu­pono iwary sa'ag Erotia ipy'ahak kahato Iuwãu ete. — Wãi'e yt naku i kahato ewaire waire e pote. Yt naku i e'aito morekuat Eroti wywo katu­pono Eroti eyke'et Wiripi wywo ereĩne'en sa'awy'i e'aito wo e Iuwãu morekuat Eroti wary sa'ag mana Erotia pe pote. Mi'i to'e pote mana Eotia ipy'ahak Iuwãu ete. Mi'i pote haiwot topyhu'at hawyi toipyhyp teran ahet'ok hat Iuwãu wo'opyhik hawe — Tupana yt tiky'esat i etipo­hari eywyt Wiripi ehary'i ete e pote. ");
INSERT INTO mavNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","— Pyno waku ati'auka teran Iuwãu ma'ato yt ati'auka kuap i katu­pono typy'i kahato ra'yn Iuwãu mohey haria e. Ta'i Tupana mipo'oro aimu'e hamuat Iuwãu e haria ahyt Iuteuria tukupte'en mesuwe e. Aikotã me aru waku Iuwãu auka hap atipuẽti e tuwa­nẽtup hawe morekuat Eroti. ");
INSERT INTO mavNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mi'i hawyi wẽtup e'at pe morekuat Eroti tunug to'ywã'ĩ hap kapiat watetup hap. Mi'i pote tutunug ienuk wato hap tomõ­typot haypiat. Mi'i hap e'at pe morekuat Eroti tikaykay tehary'i wuat Erotia mẽpyt ihairu hamo. Mi'i ti makuptia ihairu miit'in typy'i ehamo. Ikahu mekewat pĩ'ã pote morekuat iwepit kahato teha'at hawyi. ");
INSERT INTO mavNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mi'i hawyi morekuat Eroti to'e pĩ'ã pe — Ehairu ikahu kahato pĩ'ã e mi'i pote e'e hap ewy atunug teran emiky'esat ok tã emiẽtup atum neran e pĩ'ã pe. ");
INSERT INTO mavNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mi'i hawyi pi'a to'e morekuat pe — Apuete e. Mi'i hawyi toto toty kape — Kat som waku ahẽtup morekuat pe to'e hamo. Mi'i hawyi — Pyno waku ehẽtup wo'oset'ok hat Iuwãu akag kui'a pe e ity Wiripi saki'yt pe. ");
INSERT INTO mavNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mio tã e hap morekuat tikuap hawyi tuwa­nẽtup ko'i ko'i ne'i ra'yn. Ma'ato — Atum aru emiẽtup ok tã e ra'yn sa'awy'i pĩ'ã pe torania towyria'in ehamo pote — Pyno atunug ui'e hap ewy emiky'esat ewy pãi e yn pĩ'ã pe. ");
INSERT INTO mavNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mi'i hawyi ti toipo'oro ra'yn tesu­rara'in wo'opyhik hap kape Iuwãu akag tek hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mi'i hawyi ta'atuerut warupy hit pe Iuwãu akag hawyi ta'atuium na'yn mekewat pĩ'ã makuptia ihairu rakat pe. Mi'i hawyi ti tutum na'yn Iuwãu akag toty pe. ");
INSERT INTO mavNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mi'i hawyi Iuwãu potmu'eria tikuap ta'yn ta'atumu'e hat Iuwãu ut'yp tek hap hawyi tõ'ẽ ra'yn hyp hamo. Ta'atusyp hawyi ti tuwat ra'yn Iesui kape henoi hamo ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mi'i hawyi Iesui tikuap ta'yn Iuwãu auka hap hawyi toto ra'yn yara puo mekewat hyemyi'a wato sakpo aikope yt uwe i hap kape tuweran. Mi'i hawyi miit'in tikuap ta'yn Iesui aikowuat toto hap hawyi tuwat tuwat typy'i ra'yn ta'atue­tawa pyi aikowuat ito hap kape yi upi. ");
INSERT INTO mavNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mi'i hawyi Iesui put'ok'e ra'yn yẽpe ete yara puo hawyi ta'akasa miit'in typy'i kahato takat haria. Mi'i hawyi toi'atuky'e ne'i ra'yn mi'iria hawyi toi'atu­moe­hãite yne i'ahu rakaria i'atue­haky'e'i kahato iha'at turan pote. Mi'i hawyi toi'atu­moe­hãite at itote. ");
INSERT INTO mavNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Meiũran wãtym i ra'yn turan put'ok'i'atu'e ra'yn hemiit'in Iesui ete. Mi'i hawyi — Wãtym na'yn mesuwe ra'yn mote eti'atu­po'oro ro i'atue­tawa ko'i kape miit'in i'atu'e katu­pono wyti yt naku i yahig note watoĩne'en katu­pono yt kat i aimi'u meiũpe Mehĩ i'atu'e. Mi'i hawyi waku eti'atu­po'oro ro hesyat rakaria tawa hit ko'i upi getap ko'i kape aikowo aikowo te'eru­wemi'u kyi'at hamo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma'ato Iesui — Yt rat pãi e. Yt ati'atu­po'oro teran hin i rat e. Ewei'atupoi ro hesy'at rakaria e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","— Ma'ato Mehĩ i'atu'e aikotã aru pyno urui'atupoi mi'iria katu­pono aimi'u yt iwato hin i 5 man typy pira yn toĩne'en aimi'u wuat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mi'i hawyi — Pyno eweterut ro mi'i mi'u hit ko'i uhowawi e. ");
INSERT INTO mavNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mi'i hawyi to'e miit'in sem me — Ewei'apyk to mopep hyp we e. Mi'i hawyi mekewat typy pira 5 man totat topo pe hawyi teha'at atipy kape hawyi to'e — Waku kahato En Tupana are. Urutu­wehum kahato emiium ete e. Mi'i hawyi mekewat 5 man toipat'ok kahato hawyi toimõ'ẽ topot­mu'eria pe hawyi mi'iria imõ'ẽ ra'yn miit'in sem me. ");
INSERT INTO mavNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mi'i hawyi te'erenuk kahato ra'yn miit'in sem hawyi i'atu'ok kahato ra'yn hawyi hemiit'in ti'atunug i'atumi'u ieĩpyt 12 e'yry­sakag ne te topyhu'at i'atumi'u so'o ko'i. ");
INSERT INTO mavNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Toi'atumo'ok kahato 5000 rakaria ihainia'in i'ewyte i'atu kahato te hary­poria'in i'ewyte i'atu­mẽpyt'in. Yt ta'atukuap i yt ta'atu­mo­rania i hary­poria'in i'ewyte i'atu­mẽpyt'in yt ta'atukuap i karania tukupte'en itote ihainia'in ko'i yn ta'atu­mo­rania pote. ");
INSERT INTO mavNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mi'i hawyi to'e i Iesui towyria'in me — Eiwehyt'ok to ehe'yara pe hawyi eweiwat ro ihyemyi'a wato sakpo e. Uito aru ati'atu­po'oro miit'in sok i'atue­tawa ko'i kape hawyi areto ehowawi ehupi mehĩ'in e temiit'in me. Mi'i hawyi tuwat ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tuwat yne ra'yn hawyi ipot'am na'yn yity'ok kape. Mi'i tote tuweran hawyi ihay ra'yn Tupana wywo. Pyno wãtym'i ra'yn hawyi tehay kahu ra'yn hawyi tuweran toĩne'en yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mi'i totepyi heremo yne y'y emyi'a. Mi'i hawyi teha'at temiit'in kape ihyemyi'a py'asetpiat ikupte'en turan. Wasere poity'i temiit'in e'yara yowa etiat kape. Mi'i pote yt tuwat kuap i iha'at turan ihy wato kahato ra'yn itote ywytu haty wo kahato pote. ");
INSERT INTO mavNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mi'i pote waipaka ehay hap owakai toto ra'yn Iesui temiit'in kape yowa tote hewyry i'atue'yara kape y'y puo. ");
INSERT INTO mavNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mi'i hawyi hemiit'in te'era'a­kasa Iesui ut hap kape y'y wato totiat hewyry turan. Mi'i hawyi i'atu­wuwu kahato ra'yn hawyi i'atuehay haty wo — En apo miit ehag y'y totiat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma'ato Iesui to'e — Uipot­mu'eria yt eweiken'ẽ tei'o uipupi katu­pono Uito rat mesuwe areĩne'en e. Pyno eiwepit ro e. ");
INSERT INTO mavNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mi'i pote Peteru iwẽpap'i — Uruka'iwat e pyno En pote uikaykay iro ewewawi uhewyry teran ewawi yowa tote e. ");
INSERT INTO mavNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","— Eriot ro e Iesui hawyi Peteru tuwẽtem na'yn yara pyi hawyi toto ra'yn y'y owa upi Iesui kape. ");
INSERT INTO mavNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma'ato hewyry y'y owa upi turan teha'at ywytu kahato kape ywytu uato poity'i kape. Teha'at hawyi — Uheha­kyera'at ro En Uika'iwat e iwẽpap'i. ");
INSERT INTO mavNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mi'i hawyi meremo Iesui tokosap howawi hawyi totat ipo ete hawyi to'e — Kat poteĩ yt uimohey i Peteru e. Kat pote kahu uimohey ran yn en e. ");
INSERT INTO mavNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mi'i hawyi tuwehyt'ok yara pe hawyi ywytu meremo ipohep hawyi inik kahato ra'yn itote. ");
INSERT INTO mavNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mi'i hawyi 12 ok takaria yara piaria timõ­typot kahato ra'yn Iesui — En ni Tupana Sa'yru sese i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mi'i hawyi tuwat ra'yn ihyemyi'a sakpo hawyi mekewat tawa Kene­sare e hap wã tote tuwehik. ");
INSERT INTO mavNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mi'i hawyi itotiaria ikuap ta'yn meremo Iesui put'ok'e hap. Mi'i hawyi meremo ta'atukuap Iesui uwe hap. Mi'i hawyi ta'atue­ropo'ok i'ahu rakaria kopepyi kopepyi howawi. ");
INSERT INTO mavNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mi'i hawyi ta'atu­hẽtup ta'atu­mierut ko'i i'ahu rakaria moehãite hap hesokpe emig hamo. Mi'i hawyi wuat'i i'ahu rakaria Iesui ti'atu­moe­hãite yne tesokpe emig haria are uito Mateu. ");
INSERT INTO mavNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mi'i turan itote Tupana ehay miwan miat wan pakup i haria i'ewyte Tupana ehay enoi haria tõ'ẽ tõ'ẽ tawa wato Ieru­sarẽi kaipyi apota'atu'e Iesui piat hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","— Kat poteĩ emiit'in yt te'eru­we­posei posei i yt aha'ase'i'in eko yt ewy i i'atu'e. Kat pote yt naku i aipo­pitpit wywo watenuk i'atu'e õ'ẽ haria Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mi'i hawyi Iesui apo'e i'atuepe — Kat pote eipe ti Tupana eko yt ewetunug hin i e. Pywo pe ti Tupana ehay atoiat haria eipe katu­pono eimienoi ko'i yn ewetunug e. Kat pote Tupana eko yt ewetunug hin i e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sa'awy'i Tupana to'e tomiwan me — Eweimõ­typot ro ei'ywot eity e. Karãpe wẽtup ok tunug saty'i saty'i at to'ywot ete toty ete waku mi'auka wo mekewat miit topyhu'at e sa'awy'i­tewuat miwan me e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma'ato ti yt mio tã hin i ewei'atumu'e miit'in e. Karãpe yt watimõ'ẽ neran i aity kape ai'ywot kape mi'i pote ti waku — Papai Mamai yt kat i hin i eipo­hapnug hap topyhu'at katu­pono Tupana kape atum yne ra'yn eipo­hapnug hap wato'e ewei'atumu'e sa'ag miit'in e Iesui nagnia ehay enoi haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mi'i pote ti mesup aimẽpyt'in yt ti'atu­mõ­typot hin i ta'atu'ywot ta'atuty. Yt kat i i i'atu­mimõ'ẽ e. Mi'i hawyi i'atu­po­hapnug hap topyhu'at eipo pe e. Yt naku i kahato katu­pono mesup ti Tupana e hap ta'atu'atoiat kahato ra'yn hawyi eiwat eimienoi sa'ag ne'i ra'yn ta'atu­mohey e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ta'i mi'i pote eipe typy ehay rakaria ra'yn e Iesui. Nimo te ti ase'i Isaia henoi tomiwan me ");
INSERT INTO mavNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","— Eipe ti ehehay wo uimõ­typot ma'ato ti eiwa­nẽtup hawe ti pya kahato uikai e Tupana tomiwan me Esekieu 33.31 pe. ");
INSERT INTO mavNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yt kat hamo ti ehehay se uimõ­typot hap ete katu­pono uhehay atoiat haria eipe hawyi eimienoi sa'ag ko'i yn ewehenoi eipot­mu'eria pe e. — Urumienoi ti Tupana ewei'e ma'ato eheso kahato e ti Tupana ehepiat pe Isaia miwan me 29.13 pe e Iesui apo'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mi'i hawyi itotiaria typy'i rakaria pe Iesui to'e — Eweĩ'ẽ ro uhowawi e. Woro­ho'omu'e teran eipe e. Waku eweiwa­nẽtup to ui'e hap kape ikuap hamo inug hamo e. Waku ehewaure ka'a kahato uhepiat einãpin hap kape e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Uiwyria'in yt eweiwa­nẽtup tei'o eipy'a pe — Waku areĩne'en Tupana wanẽtup hawe. Mi'u hãpyk urueko ewy wakuat yn atu'u yt ewei'e tei'o eipy'a pe katu­pono aheko mi'u ete yt aimo­hãpyk kuap i Tupana wanẽtup hawe e. Uimi­mu'eria pywo pe ti Tupana teha'at kahato eipy'a piat eiwa­nẽtup hap kape. Eimi­ky'esat hap kape teha'at kahato. Mi'i hawyi ei'e hap kaipyi eikuap sio eipe waku sio yt hap yt naku i eipe hap e. Mi'u yt eimohun kuap i eiwa­nẽtup hawe are ma'ato eiwẽ pywiat ehehay eimohun kuap hap tuwẽtem eiwẽ pyi e Iesui to'ywania Iuteu ywania pe. ");
INSERT INTO mavNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mio tã to'e hawyi ipotmu'eria sese tõ'ẽ meremo Iesui kape henoi hamo — Mehĩ i'atu'e Tupana ai'airo temiit no aheko mi'u u hap etiat e haria i'atu­py'ahak kahato eete. Urumu'e hat ewe'eg wo o i'atu'e katu­pono yt naku i e'e hap iatu'e irania'in wo'omu'e haria to'ope katu­pono — Tupana miky'esat ewy mi'u u haria yn waku pe tukupte'en Tupana wanẽtup hawe i'atu'e mi'iria. Aheko mi'u ete aipu'ap Tupana kape i'atu'e wo'omu'e haria ipotmu'eria henoi Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mi'i pote Iesui to'e — Pyno mi'iria mienoi ko'i yt Tupana mienoi ewy hin i e. Karãpe watikoi aiko hawyi wahe­katup kahato hẽtyt hap e. Hẽtyt hawyi aimo­wepit kahato hap aimikoi e. Ma'ato i'anam ne'i hẽtyt hap yt aimo­wepit kuap i yt aimikoi hin i pote meremo wati­puruk. Mi'i hap ewy irania'in wo'omu'e haria mimu'e ko'i yt Ai'ywot Tupana e hap ewy hin i ma'ato i'anam aiko piat ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Uipot­mu'eria eiwa­nẽtup ko'i ko'i i'atu­wesat hap kape e. I'atu'e hap miit'in mu'e hap yt kan hamo i katu­pono yt ta'atukuap i mu'ap Tupana kape e. Ta'i mi'iria tukupte'en yt ihapytig i rakaria ewy — Mesuwe mu'ap Tupana kape i'atu'e irania'in me yt ta'atukuap i mu'ap pytkai. Aikotã yt ihapytig i rakaria to'o'ykesat hap ewy tukupte'en mi'iria. Meiũran to'oykesat ereto yi hot pe hawyi i'atuewo yi ka'a pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mi'i hawyi Peteru to'e Iesui pe — Uimu'e hat yt uruikuap hin i te e'e hap mi'u ete e. Urumu'e i ro kat e'e hap sese etiat e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mi'i hawyi Iesui ti'atu­wesat — Uiwyria'in yt eweikuap i te ui'e hap eipe e. Ta'i irania'in mesu­wa­ro­tiaria ewywuaria te eipe katu­pono mi'iria yt uikuap i te haria e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yt eweikuap i te apo aikotã mi'u watohon hawyi aiymyẽ pe toto hawyi teke aime'en me hawyi ahepai'a hawyi toto i ra'yn aipiit pyi hap. Yt eweikuap i te apo aikotã mi'u yt teke kuap i aiwa­nẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma'ato ai'e aiwa­nẽtup hawiat meiũran tuwẽtem aiwẽ pyi ahehay wo ra'yn aiwa­nẽtup hap ok tã e. Pywo ti rat ei'e hap eipy'a piat eima'at hap topyhu'at katu­pono tuwẽtem eiwẽ pyi hawyi torania tikuap ta'yn eiwa­nẽtup hap e. Pywo pe ti ei'e hap eipy'a pywiat eimohun hap topyhu'at e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ta'i eiwe'eg wo o eipy'a piat eiwa­nẽtup hap e hap pupi are katu­pono mesu­wa­ro­tiaria te'eru­wa­nẽtup at ka'ap aikotã aikotã yt naku i nug hap kape — Waku ati'auka mekewat uhewa­nĩkap i'atu'e ta'atupy'a pe. Waku mi'i uhewaire wo i'atu'e ta'atupy'a pe. Waku atoiat uhe'aito uhehary'i hawyi wẽtup atat i'atu'e ta'atupy'a pe. Waku atero'ok mekewat uianuat i'atu'e ta'atupy'a pe. Waku atima'at mi'i miit uhehay yt pywo i rakano i'atu'e ta'atupy'a pe. ");
INSERT INTO mavNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mi'i ei'e hap ko'i eipy'a pywiat eima'at hap ko'i tukupte'en katu­pono ewei'e eipy'a pe hawyi meremo ewetunug ei'e hap ewy. Ei'e hap upi eweiwat hawyi yt naku i nug haria eweikupte'en e. — Mi'u watu'u aipo­pitpit hap wywo pote meremo yt naku i nug haria wo wato­pyhu'at i'atu'e irania'in wo'omu'e haria ma'ato yt pytkai i e. Aipo­pitpit hap yt teke kuap i aiwa­nẽtup hawe e. Aipo­pitpit hap yt ainug hin i sa'ag nug haria Tupana wanẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mi'i hawyi Iesui toto ra'yn tetama pyi wẽtup tama piat tawa kape toto mekewat y'y wato sese yẽpe kape topot­mu'eria wywo. Put'okta'atu'e tawa Tiru pe hawyi tuwat tawa Sitãu kape. ");
INSERT INTO mavNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mi'i turan wẽtup hary­poria mekewat y'y wato ẽpe totiat ieĩne'en hat tut Iesui ewawi hawyi tuwẽ­powat Iesui kape — Uika'iwat ase'i Tawi emiariru En e. Pyno uipo­wyro hap atiky'esat katu­pono uhehaky'e'i kahato Mimi e. Uiky'e hap kaipyi uipo­wyro ro e. Eriot ro uhupi uimẽpyt hary­poria moehãite hamo e. Uimẽpyt hary­poria kawiat ahiag tisaty'i saty'i kahato e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma'ato Iesui yt tiwesat hin i tuwe­wawi wẽpowat i rakat. Ma'ato hary­poria yt ipohep hin i tohẽtup po'og ne'i. Mi'i hawyi ipotmu'eria te'ero'e Iesui pe — Uhyt i'atu'e etipo'oro ro mekewat hary­poria pya meiũpepyi i'atu'e katu­pono aimo­sero kahato ihay pirik hap aimo­py'ahak kahato i'atu'e. Waku etipo'oro pya aikai i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mi'i hawyi Iesui tiwesat — Mana Uito ariot yt e'ywania kape hin i e ma'ato uru'ywania sese mu'e hamo yn ariot mesup e. Ta'i ui'ywania tukupte'en aikotã aihũria ga'apy piat ho'owasat rakaria ewywuaria tukupte'en haria uru'ywania Isareu ywania e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mi'i hawyi ma'ato hary­poria put'ok'e howawi hawyi toimõ­typot kahato ra'yn Iesui hawyi to'e tope — Uipo­wyro En Mimi e. Wakuat kahato En Tawi emiariru En. Uipo­wyro ro Uika'iwat e. Etisopo ro ahiag uimẽpyt pyi e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mi'i pote Iesui tiwesat — Mana e yt naku i urumẽpyt'in wakuaria mi'u wakuat urutum awareria pe e. Mi'i hap ewy yt naku i wẽtup ywania powyro hamo areto mesup wẽtup ywania kape e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma'ato hary­poria to'e Iesui pe — Pywo pe ti an Mimi e'e hap ma'ato kat ko'i kat ko'i ta'at yparakai kaipyi mi'u ku'i ieĩpyt eimẽpyt'in te'erenuk turan topyhu'at awareria mi'u wo Mimi e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mio tã e hawyi Iesui tiwesat — Mana uimohey hap epiat hap iwato kahato. Mi'i tupono emiky'esat ewy atunug na'yn e Iesui hary­poria pe. Iesui mio tã to'e hawyi hary­poria mẽpyt waku ra'yn. Iesui ehay wẽtem iwẽ pywiat turan hary­poria piat tomohey hap kaipyi ihãite ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mi'i hawyi toto tawa Tiru pyi tawa Sitãu myi hawyi toto ra'yn mekewat ihyemui'a Karireia hyẽpe upi tewyry hamo. Mi'i hawyi yity'ok upi put'ok'e hawyi ipot'am hawyi ta'apyk itote. ");
INSERT INTO mavNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tuwat Iesui upi typy'i rakaria. Mi'iria terut kahato i'ahu rakaria Iesui ewawi. Tõ'ẽ ipy kĩ'ã rakaria yt ihapytig i rakaria yt hewaure ka'a i rakaria i yt ihay i rakaria yt hewyry kuap i rakaria. Ipo tut i i'ewyte ipy tut i rakaria tõ'ẽ howawi. I'ewyte tõ'ẽ aikotã aikotã ahu wywuaria tõ'ẽ Iesui ewawi ta'atu­moe­hãite hap puẽti hamo. Ta'atupag i'ahu rakaria Iesui yatype hawyi toi'atu­moe­hãite torania ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Irania'in itotiaria teha'at haria te'eru­wa­nẽtup kahato Iesui kape katu­pono yt hewaure i rakaria toi'atue­waure hot'ok ta'yn yt ihay kuap i rakaria toi'atu­moehay kuap ta'yn yt ihapytig i rakaria toi'atu­moe­ha­pytig na'yn I'ewyte ipiit yt ikahu i rakaria toi'atu­moe­kahu. Mi'i hawyi ta'atu­mõ­typot kahato Tupana — Uru'ywania Isareu eTupana i'atu'e waku kahato En i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mi'i hawyi Iesui ti'atu­kaykay tuwe­wawi topot­mu'eria — Uiwyria'in e i'atu­haky'e'i kahato katu­pono mye'ym e'at ra'yn tukupte'en meiũpe uhehay kuap hamo miit'in sem e. Mi'i hawyi ta'atumi'u ta'atu'u yne ra'yn e. Mi'i pote koitywy yt naku i ati'atu­po'oro i'atue­tawa ko'i kape katu­pono ti pya kahato pyi tõ'ẽ mi'iria e. Ta'i tuwat hawyi ti ren te'eropap ne'i ra'yn yahig note sy'at pono e. Mi'i pote waku sa'awy'i wati'a­tupoi mi'iria e. I'atu'ok ta'yn hawyi waku te'era'aipok yahig wato sakpo ta'atue­tawa ko'i kape e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma'ato — Mehĩ i'atu'e typy'i kahato ti hesy'at rakaria mesuwe i'atu'e. Aikope pyi aru pyno wati­puẽti i'atumi'u wuat meiũpe yahig wato pe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","— Yt kat i i apo aheman mesuwe e Iesui. Mi'i hawyi — Yt rat i'atu'e kurin kahato aimi'u pãi i'atu'e. Aheman 7 yn topyhu'at i'ewyte ahepira hit typy yn topyhu'at Mehĩ i'atu'e. Mio tã i'atu'e pytkai Iesui to'e miit'in sem me ");
INSERT INTO mavNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","— Pyno ewei'apyk to yi upi e. ");
INSERT INTO mavNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mi'i hawyi totat 7 man typy pira topo pe hawyi to'e to'ywot pe — Arehum ewawi Tupana. Waku kahato emiium e. Mi'i hawyi toi'atupat'ok hawyi tutum na'yn temiit'in me. Mi'i hawyi ipotmu'eria imõ'ẽ ra'yn typy'i rakaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mi'i hawyi te'erenuk kahato ra'yn hawyi i'atu'ok kahato ra'yn. Mi'i hawyi hemiit'in ti'atunug i'atumi'u ieĩpyt hawyi 7 e'yry­sakag ne howapy te topyhu'at man pikpik ko'i pira pu'i ko'i. ");
INSERT INTO mavNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Te'erenuk haria 4000 ihainia tukupte'en itote i'ewyte hary­poria'in i'atu­mẽpyt'in typy'i kahato yt i'atu­mi­mo­rania i ko'i te'erenuk wy. ");
INSERT INTO mavNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Waku hawyi Iesui ti'atu­po'oro ra'yn i'atue­tawa ko'i kape. Mi'i hawyi teke ra'yn yara pe hawyi toto i ra'yn ihyemyi'a sakpo mekewat yi Matara e hap kape. Mi'i hap ti ara'akasa yne sa'awy'i uito Mateu. Mi'i hawyi mesuwat uimiwan atunug. ");
INSERT INTO mavNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mi'i hawyi itote wo'omu'e haria put'ok'i'atu'e Iesui iã'ãg hamo. Ta'atu­ky'esat i'aparap topiat hap haype. — Urumu'e hat i'atu'e etomo­herep to esaika hap atipy kaipywiat yt uwe minug kuap i rakat ok tã i'atu'e. Mi'i etunug hawyi mono meremo uruimohey Tupana Mipo'oro En hap i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mi'i hawyi Iesui to'e i'atuepe — At min'e hap kape ewei'akasa hawyi — Pyno mũki'ite at kahu kahato irane ewei'e katu­pono at min'e turan atipy piat ihup kahato pote watikuap ewei'e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","I'ewyte at wẽtem hap kape eweha'at hawyi — Pyno meiũ i'aman aru ewei'e katu­pono at wẽtem hap ete hun moity i'ewyte ipy'ahak hap ewywuat topyhu'at atipy pe pote watikuap ewei'e. Ta'i i'aman aru hap yt i'aman i aru hap eweikuap kahato at mimo­herep hap ete ma'ato Tupana Mipo'oro wemo­herep hap ko'i yt eweikuap hin i eipe e. Atunug kahato ra'yn eipy'a­setpe Tupana miky'esat uipo'oro hap ko'i uwe Uito hap moherep hap ko'i ma'ato mi'i ewei'akasa yne hawyi ti yt uikuap i hin te eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yt naku i kahato mesu­wa­ro­tiaria tukupte'en katu­pono yt Tupana mohey i haria kahato eipe e. — Etimo­herep to esaika hap atipy kaipywiat iwato'in nakat merep'e hap ewy hawyi emohey haria wo urutu­kupte'en ewei'e sa'ag uhepe e. Ma'ato yt atunug i aru iwato'in nakat ehepe ei'akasa hamuat uimohey ehepiat hamuat e. Ma'ato ti aru wẽtup iwato'in nakat ei'akasa hamo ehepiat uimohey hap yn atunug e. Ta'i meiũran ti aru arẽtem ni aru gu'uro pyi aikotã mekewat sa'awy'iwuat Tupana ehay moherep hat Iuna tuwẽtem mekewat pira wato rakat wẽ pyi mye'ym e'at hawyi hap ewy ti aru arẽtem gu'uro pyi e. Mi'i iwato rakat yn atunug aru uwe Uito hap moherep ehepiat hamo e. Mi'i hawyi ti Iesui toto wo'omu'e haria yaty­pepyi i'ewyte Tupana ehay iwan miat wan pakup i haria kaipyi. ");
INSERT INTO mavNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mi'i hawyi tuwat ra'yn temiit'in nywo ihyemyi'a wato sakpuat yara puo ma'ato hemiit'in tiwaure ta'atumi'u man. ");
INSERT INTO mavNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mi'i hawyi mu'ap upi toi'atu­nãpin na'yn temiit'in — Eiwe'eg wo o nagnia eko enoi haria wat ti mani ok pyre mopuk ewywuat pupi e nagnia ehay enoi haria Tupana ehay miwan miat wan pakup i haria wat e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mio tã e pote te'ero'e to'ope — Kat pote aheman wyti yt iwato i pote ti mio tã e. Aheman aimi'u wo wati­waure pote ti mio tã to'e i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma'ato Iesui tikuap i'atuehay to'opiat tuwa­nẽtup hawe hawyi to'e — Yt kat i aheman ewei'e apo eiwo'ope e. Pyno yt uimohey kuap i te eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yt eweikuap i te apo uhesaika hap man nug hamuat hap e. Eweiwaure ra'yn apo aikotã ga'atpo 5 man wo ati'atupoi 5000 ihainia hap e. Eweiwaure ra'yn apo karania e'yry­sakag ne topyhu'at mi'i mi'u ieĩpyt hap itotiat e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","I'ewyte mi'i hawyi ati'atupoi sa'awy'i 7 man wo 4000 ihainia. Mi'i hap apo karania e'yry­sakag ne topyhu'at i'atumi'u ieĩpyt itotiat e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mi'i tupono mesup ti uhehay wyti aikotã nagnia ehay enoi haria i'ewyte wani wani e haria tukupte'en mani puk ewy hap ete ti uhehay e. Ta'i yt eimi­waure aheman yt ete i ti uhehay e. Pyno eiwe'eg wo o eiwa­nẽtup hap man puk hap pupi mekewat sehay wẽtup nagnia mienoi hap pupi e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","— Ta'i mio ti uruikuap ta'yn ehay Uhyt yt aheman ete i ehay hap ma'ato iã'ãkap wuo urumu'e wẽtup seko enoi hap pupi mekewat Tupana mõtypot yat piaria akag ko'i Tupana ehay miwan miat wan pakup haria wo'omu'e hap pupi ehay hap i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mi'i hawyi Iesui toto tawa Sesaria kape wuat'i tawa hit upi toto morekuat Wiripi e'yi upi toto. Mi'i hawyi mu'ap upi tuwat hap tote Iesui apo'e temiit'in me — Uiwyria'in e uwe som pyno irania'in me Uito eheyke'et apo'e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","— Ta'i irania'in ni mekewat wo'oset'ok hat Iuwãu raso i'atu'e ti epe. Ma'ato irania'in ti ta'i mekewat sa'awy'iwuat Tupana ehay moherep hat Eria raso Ieremia raso i'atu'e epe. Ma'ato irania'in wẽtup ok sa'awy'iwuat Tupana ehay moherep hat ti ta'aipok i gu'uro pyi i'atu'e ti epe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","— Ma'ato apo uwe Uito ehepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mi'i hawyi Peteru tiwesat — En ni Tupana Mipo'oro Miit'in Ehakyera'at hanuat En e. En ni Tupana Sa'yru wuat'i e'at piat ieĩne'en hat Sa'yru ti En e Peteru. ");
INSERT INTO mavNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","— Hãpyk kahato ti en uiwesat Simãu Iuwãu sa'yru e. Pywo ti uiwesat en. Yt uwe miit'in mikuap ewy i uiwesat en e. Ta'i yt uwe i ti mio tã emu'e mesuwe ma'ato Ui'ywot atipy piat wyti henoi epe uwe Uito hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Uimohey hat sese ti en e. Uimohey iheg miat hat en Peteru aikotã ai'yat nu kawiat iheg kahato hap ewy ti uimohey hap e. Mi'i hawyi ti aru en ewywuaria uimohey kahato haria wo yne ati'atunug aikotã wati'a­tunug nu ai'yat nug hamuat hap ewy. Uimohey haria en ewywuaria wo ati'atunug ui'yat Tupana mõtypot hamuaria e. Yt uwe i wyti aru imoma kuap uimohey haria katu­pono po'og hesaika gu'uro kawiat rakat atunug mi'iria e. Wanĩ­kaptia ti'atu'uka atu'uka pytkai tukupte'en ne uimohey haria mesuwe katu­pono yt ta'atu­moma kuap e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Koitywy woronug en oken'ypy apykok hat ewywuat e. — Ereke ro aikope Tupana toĩne'en Morekuat no ere'e miit'in me pote tuwehyt'ok aru ma'ato irania'in me yt eiwehyt'ok tei'o ere'e pote yt tuwehyt'ok i aru e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mi'i hawyi toi'atu­nãpin — Uiwyria'in e yt ewehenoi tei'o mesup te irania'in me eimikuap Uito Tupana Mipo'oro Wuat'i Miit'in Porekuat nuat hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mekewat e'at pyi Iesui ti'atumu'e topot­mu'eria aikotã aru toieĩne'en mesu­wa­rote irane hap etiat tohenoi — Uipot­mu'eria e koitywy ahenoi teran ehepe heremo kahato aikotã aru ta'atunug mesuwe uhepe hap e. Areto ra'yn aru Ieru­sarẽi kape uipo'oro hap ewy areto. Mi'i tote ti aru nagnia pa'i kororia i'ewyte seko enoi haria uhaty'i haty'i kahato itote aho'opot kahato aru e. Ui'auka ra'yn aru itote ma'ato mye'ym e'at yn wyti aru uipiit topyhu'at ui'asyp hawe e. Mi'i hawyi ti aru arẽtem i gu'uro pyi hawyi areĩne'en ne i ra'yn Uito e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mio tã e pote Peteru tikaykay Iesui tuwe­wawi wãito'e hamo — Mehĩ yt karãpe i ti mi'i tã hap ta'atunug kuap eete pãi e. Pyno ti yt karãpe i ti aru e'auka hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma'ato Iesui tuwe­morem na'yn Peteru saty'i saty'i hamo — Motoro ahiag e Peteru pe. Uipyhyp teran en Tupana miky'esat nug hap ete Satanai e. Uinãpin sa'ag ne'i yt Tupana piat yt uinãpin hap ewy hin i ma'ato ti miit'in wanẽtup hap kaipyi ne'i ti uinãpin en e Peteru pe. ");
INSERT INTO mavNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mi'i hawyi yne temiit'in me to'e — Uipot­mu'eria uhemiit no sese wo erepyhu'at teran pote etiwaure o yne emiky'esat nug hap ko'i e. — Ui'auka pote waku ui'auka ma'ato yt atoiat hin i aru imohey hap ewei'e o e. — Yt atoiat hin i Uika'iwat uiku'uro hap kape ewei'e o e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","— Uimi­ky'esat nug hap yn aru atunug ewei'e pote eheĩne'en hap sese mesuwat yi tote pun haria wo eweipyhu'at ma'ato uwe uwe — Uika'iwat miky'esat yn atunug neran ewei'e pote eheĩne'en hap sese puẽti hanuaria eweipyhu'at mesuwat yi tote i'ewyte atipy pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kan hamo ten eweipotpap at ka'ap wuat'i e'at pe yne yne mesu­wa­rote yi wato hap ok tã eweikyi'at hamo yt eweikupte'en i sese mesuwe hamuat pytkai i e. Kan hamo eweipun yne eheĩne'en hap eimi­ky'esat nug hap ete hawyi aikotã i aru ewei'aipok i emotag hap e'at kape. Eweipun na'yn eheĩne'en hap sese yne hawyi aikotã aru eweikyi'at i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Meiũran ti aru ara'aipok te ra'yn meikowo Uito Eheyke'et Eikywyt. Ariot re ti ra'yn Ui'ywot mimõ­typot nuat ariot pãi hemiit'in atipy piaria py'asetpiat ariot e. Mi'i e'at pe ti aru atum ha'up uimi­ky'esat nug haria pe ikahu kahato aikotã i'atu­minug wakuap ok tã wyti aru atum ha'up iwato rakat e. Ma'ato irania'in me ti aru i'atu­minug sa'ag ok tã ne wyti aru atum ha'up i'atuepe yt nakuap i ok tã e. Yt eweiwaure tei'o mio wuat uhehay pãi e. ");
INSERT INTO mavNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pywo pe ti areĩne'en ti aru Morekuat no mesuwe e. Mi'i hawyi i'ewyte tukupte'en eipy'a­setpe wẽtup ok wẽtup ok Eheyke'et Morekuat nuat hap kapiat akasa haria ti aru eipy'a­setpe tukupte'en wy e. Pyno ti aru mi'iria te'era'a­kasa ta'atu­ku'uro hap e'yianmete e Iesui temiit'in me. Mio tã e. Mi'i hawyi uito Mateu atiwan mi'i hap etiat mesuwe. ");
INSERT INTO mavNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mi'i rokirẽ 6 e'at tokosap rokire totioto temiit Peteru Tiaku iywyt Iuwãu wywo yity'ok ywaiti kahato rakat kape aikope yt uwe i tukupte'en hap kape. ");
INSERT INTO mavNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mi'i hap tote te'eraha'at Iesui kape turan yt sa'awy'i­tewuat ewy i ra'yn toĩne'en katu­pono howa ti imehit kahato at mehit hap ewy i'ewyte hesokpe ikytsig kahato imehit hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mi'i hawyi ipotmu'eria mye'ym ok takaria te'era'a­kasa Iesui yatype typy ok mekewat Musei hawyi Eria meke­waria sa'awy'iwuat Tupana ehay moherep haria kape te'era'a­kasa. Mi'iria ti to'oehay Iesui wywo. ");
INSERT INTO mavNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mi'i hawyi Peteru tuwẽ­powat ra'yn — Urumu'e hat e waku kahato meiũpe watoĩne'en pãi e. Etiky'esat pote meremo atunug ehe'og mye'ym wẽtup ewano wẽtup Musei wano wẽtup Eria wano e haty wo. ");
INSERT INTO mavNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mio tã e turan put'ok'e ra'yn ywyhig imehit rakat i'atuete ywai kaipyi. Mi'i hawyi ywyhig og kaipyi sehay ta'atukuap — Uha'yru sese ti toĩne'en eipy'a­setpe uimiky'e kahato Mi'i e. Mi'i tupono eweiwa­nẽtup kahato ro ihay imienoi kape e Tupana. ");
INSERT INTO mavNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mi'i pote ywyhig mywiat sehay pupi ipotmu'eria hewo ra'yn yi tote ta'atuewa puo. ");
INSERT INTO mavNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mi'i hawyi Iesui teha'at i'atue­wawi hawyi toi'atuemig hawyi to'e — Wãi eweiken'ẽ tei'o e i'atuemig haype. Eipoĩ'ãm no e. Yt eweiken'ẽ te e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mi'i hawyi te'eraha'at yi totepyi hawyi Iesui yn na'yn heremo. Te'era'a­kasa Iesui yn na'yn. Mi'i yn toĩne'en ne itote. ");
INSERT INTO mavNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mi'i hawyi i'atu­pot'apyk i ra'yn yi hot kape yity'ok totepyi. Mi'i turan Iesui to'e mye'ym ok takaria pe — Yt ewehenoi tei'o irania'in me ei'akasa uhowawiat yity'ok totiat aikotã areĩne'en hap e. Uito Eheyke'et tuwẽtem i ra'yn gu'uro pyi hawyi ti waku ewehenoi mi'i tã hap irania'in me e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mi'i hawyi apo'i'atu'e tope — Kat poteĩ irania'in Musei ehay wuat aimu'e haria te'ero'e — Sa'awy'iwuat Tupana ehay enoi hat ti Eria ti ta'aipok i ra'yn Tupana Mipo'oro Miit'in Ehakyera'at hat ut hap moherep hamo tut i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mi'i hawyi toi'atu­wesat — Ta'i pywo kahato ti mio tã i'atu'e hap ewy ti e. Katu­pono Eria ti tut ra'yn yianme Tupana Mipo'oro ut hamuat enoi hamo i'atu'e hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pywo pe ti Eria put'ok'e e hap ti tokosap ta'yn uiwyria'in e. Ta'i ta'aipok kahu ra'yn ma'ato miit'in yt tikuap i ut hap hawyi to'okyry'i sa'ag kahato mi'i ete. Ta'atu­mi­kyry'i sa'ag hap ne'i e. Mi'i mikyry'i hap ewy te ti aru ta'atunug sa'ag uhete Eheyke'et ete e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ta'i uruikuap ta'yn koitywy kat e'e hap i'atu'e. Ta'i mekewat wo'oset'ok hat Iuwãu sa'awy'iwuat Tupana ehay moherep hat ti Eria ewywuat kahato ti ere'e hawe ti i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mi'i hawyi Iesui ta'aipok i ra'yn Peteru Iuwãu Tiaku wywo miit'in typy'i rakaria kape. Mi'i hawyi wẽtup ok ihainia put'ok'e Iesui ewawi hawyi tuwe­pỹ'ã­tutuk haype to'e ");
INSERT INTO mavNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","— Uhyt e eraha'at uha'yru kape iky'e hap mywo ro katu­pono yt naku i kahato ahiag uha'yru ete e. Toku'uro ku'uro hawyi ti aria pe y'y pe tuereto ta'at e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Sa'awy'i ti aterut epotmu'eria kape ma'ato ti mi'iria ti yt imoehãite kuap i e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mi'i hawyi Iesui to'e topot­mu'eria pe — Yt Tupana mohey haria hin i ti eipe pãi. Mi'i pote ti ewei'aparap kahato eipe e. Karãmuo ti aru put'ok'e uhepiat eimu'e hap Tupana mohey sese hap e. Woro­ho'omu'e ti imohey hamuat ete wen ma'ato ti yt eweimohey kuap hin i te e. Aikotã aru pyno ewei'atu­moe­hãite kuap miit'in areto ra'yn pytkai yt kat i ra'yn uimohey hap eikai hawyi e. Pyno eterut ro esa'yru e Iesui wepỹ'ã­tutuk hat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mi'i hawyi tohaty'i haty'i ahiag tehay wo — Erẽtem no ahiag kurum piit pyi e hawyi meremo ihapy hot'ok i ra'yn ahiag ipiit piat rakat. Meremo waku ra'yn tuete. ");
INSERT INTO mavNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mi'i hawyi waku hawyi ipotmu'eria te'eru­weran tuwat howawi — Kat pote som uruto yt uruihep kuap i ahiag kurum piit pyi i'atu'e ta'atumu'e hat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iesui henoi ra'yn — Tupana mohey hap eiwanuat yt iwato i te yt itag i te eweimohey Tupana pote yt eweimoe­hãite kuap i te eipe e. Tupana mohey hap eiwat itag pote iwato pote yne yne ewetunug kuap e. Aikotã aimikoi Mutara iã'ỹi ti yt iwato hin i wen ma'ato itag hawyi i'yp wato e. Mi'i hap ewy ti Tupana mohey hap ehepiat hap eikawiat kurin kaipyi itag hawyi yne ra'yn ewetunug kuap imohey hap wywo ewehẽtup wote e. Mesuwat yity'ok wato pe — Motoro mesu­wepyi ewei'e imohey hap wywo pote ta'i toto ra'yn eimiẽtup ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ta'i uhyt'i'in ewehẽtup Tupana pe haty wo ahiag hep hamuat ehesy'at hap wywo mi'i hawyi tuwẽtem ahiag ma'ato yt pote yt e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mi'i hawyi hemiit'in yi Karireia piaria te'eru­wa'a­tunug yne ra'yn Iesui kape. Mi'i hawyi to'e i'atuepe — Uiwyria'in e mi'i hawyi irane Uito ti wanĩ­kaptia po pe areĩne'en Uito e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta'i ta'atu'auka sese hamuat ti Eheyke'et Eikywyt hawyi ta'atusyp ipiit iku'uro hawyi ma'ato mye'ym e'at hawyi Tupana uihep i ra'yn gu'uro pyi Uito e. Ta'atukuap ihay hawyi i'atu'arot kahato ra'yn iwyria'in. ");
INSERT INTO mavNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mi'i hawyi Iesui toto temiit'in nywo tawa Kawana'ũ kape. Mi'i tote put'ok'e wẽtup ok Tupana mõtypot yat apykok hap sa'up sat hamo tut. Mi'i hawyi apo'e Peteru pe — Eika'iwat tum apo Tupana mõtypot yat apykok hap sa'up e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","— Ta'i tutum som e Peteru hawyi teke getap we apoto'e hamo ma'ato apo'e hap e'yianmete Iesui to'e — Simãu e mesuwat yi totiaria more­kuaria wyti miit'in kaipywiat ha'up sat kahato haria e. Uwe kaipyi som ta'atu­ky'esat ha'up sat hap are sio i'atu­mẽpyt'in kaipyi are sio irania'in kaipyi e. Kat som mi'i tã erewa­nẽtup e Simãu me. ");
INSERT INTO mavNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ta'i ta'atu­mẽpyt'in kaipyi ti yt kat i ta'atuhep e ma'ato irania'in kaipyi iwato kahato ta'atu­po­rera'at e Simãu hawyi Iesui to'e — Simãu e Ui'ywot yat apykok hap sa'up ta'atusat teran uikaipyi e. ");
INSERT INTO mavNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ta'i atum wyti aru e yt kat i uiwe­te­weru hap pytkai Ha'yru Uito pote ma'ato atum katu­pono yt atiky'esat i wyti yt hegyi'at i rakat i'atu'e uhepe e. Pyno waku watum i'atu­miẽtup e Simãu me. Mi'i pote ti etioto ro pina ihyemyi'a wato kape hawyi etekyi pira ro e. Mi'i tote ti aru etipuẽti pira e. Mi'i hawyi ti aru emiekyi sa'awy'iwuat wẽ pe etipuẽti ha'up muat i'ape rakat e. Mi'i i'ape rakat ti aru put'ok'e ra'yn Tupana mõtypot hap apykok hap sa'up mo aiwanuat e. Pyno etekyi pira hawyi etum i'ape iwẽ piat mekewat sa'up nug hamo e Iesui Peteru pe. Mio tã hap ewy to'e Peteru pe sa'awy'i. Mi'i hawyi uito Mateu uimiwan atunug mi'i etiat. ");
INSERT INTO mavNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mekewat e'at Iesui potmu'eria put'ok'i'atu'e Iesui ete apota'atu'e hamo — Uhyt i'atu'e uwe aru mekewat Tupana topyhu'at Morekuat no mesuwat yi tote turan mekewat e'at pe apuru uwe uwe topyhu'at urupy'a­setpe po'og miit'in akag no irania'in kai i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mi'i hawyi Iesui tikaykay hirakat kurin kat tuwe­wawi hawyi hirakat pe to'e — Eremo'y'am no meiũpe uhemiit'in py'asetpe e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Mi'i hawyi to'e temiit'in me — Miit'in akag wo eweikupte'en neran mote eweikupte'en meiũwat hirakat ewywuat e. Hira­karia waku kahato e. — Uito po'og yt to'e i hap ewywuaria waku ewei'e e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ewei'atoiat ro — Uito po'og irania'in kai ei'e hap ko'i hawyi — Irania'in po'og uikai ewei'e eiwa­nẽtup hawe hirakat ewy e. Mio tã e haria ewywuaria yn miit'in akag wo tukupte'en aru karãpe Tupana toĩne'en Wuat'i Potypot Koro wo i mesuwat yi wato hap ok tã hap e'at turan e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","I'ewyte uwe uwe uhetiano wẽtup ok mesuwat hirakat ewywuat pe to'e — Ta'i waku ereĩne'en ui'yat pe pĩ'ã kurum e hat topyhu'at mi'i e hat ewywuat uhepe to'e — Ta'i waku ereĩne'en ui'yat pe Uhyt Mimi e hat topyhu'at e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pyno eiwe'eg wo o uimohey haria piat uimohey hap moma hap pupi e. Katu­pono uwe uwe hirakat ma'at hat topyhu'at mi'i hat yt naku i sese rakano topyhu'at Tupana wanẽtup hawe pãi e. Uwe uwe uimohey hap hira­karia wanẽtup hawiat ihep mi'i hat ti Tupana mi'apiheg sese wuanuat topyhu'at e. Ta'i mi'i hat ti sakpo yt naku i hawe topyhu'at irane aikotã ihyemyi'a wato pe nu wato saity nug ete watoĩne'en hap ewy topyhu'at yt naku i pe aru uimohey haria hirakat ewywuat ma'at haria e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tukupte'en aru uimohey haria ma'at haria uimohey hap hep kuap haria e. Po'og po'og Tupana mi'atu'a­piheg ko'i wo aru mi'iria te'ero­pyhu'at wuat'i irania'in ko'i kai e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mi'i pote epo epy einug yt naku i pe pote wãi'ewei'e o eiminug yt naku i hap ete e. Ta'i po'og waku eweitek eipo eipy katu­pono po'og waku ipo ipy tut rakano eweikupte'en mesu­wa­rote te sio meiũran eweipyhu'at eipiit ikahu rakat wywo wuat'i e'at pe aria pe eheho'opot hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","I'ewyte wãi'ewei'e eiwa'a­kasa sa'ag neran hap ete. Ta'i po'og waku eweihep eheha hawyi eweipun no pya eikai katu­pono po'og waku eheha i'apak'e wywo yn ehewyry mesu­wa­rote sio typy kawiat eheha wywo eweikupte'en wuat'i e'at piat aria ieĩne'en hat ho'opot hawe ne'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mi'i pote eiwe'eg wo o hira­karia ewywuat haria etiat eipy'ahak hap pupi katu­pono tukupte'en kahato atipy pe Tupana esurara'in ko'i hira­karia apykok haria tukupte'en yt pya hin i Ui'ywot atipy piat kai e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mi'i pote eiwe'eg wo o hira­karia ewywuat uimohey haria ma'at hap pupi. Katu­pono ho'owasat rakaria ehakyera'at hamo ariot e. Ta'i Uito ti ariot Eheyke'et miit'in ho'owasat rakaria puẽti hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Karãpeĩ aihũria 100 rakat tukupte'en ai'yatype hawyi ma'ato wẽtup ok aihũ ho'owasat ra'yn mi'i hawyi watikat kahato meremo ho'owasat rakat. Mi'i hawyi 99 rakaria i'atumi'u ete hawyi aihũ ho'owasat rakat kat hamo watuwat e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mi'i hawyi meiũran wati­puẽti i ra'yn aihũ hawyi — Pãi waku wato'e aimo­wepit kahato katu­pono ho'owasat rakat wati­puẽti i ra'yn pote. I'ewyte meimuẽwat 99 rakaria aimo­wepit kahato haria te ma'ato ho'owasat rakat puẽti hap po'og aimo­wepit e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mi'i hap ewy te ti Ai'ywot atipy piat yt tiky'esat hin i wẽtup hirakat ho'owasat hap e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Uiwyria'in e karãpe wẽtup ok uimohey hat ti'aparap eete aikotã aikotã tutunug ema'at hap mi'i hawyi o ereto howawi iweran hawyi ehenoi ro tope aikotã toi'aparap epiat hap e. Ma'ato waku iweran turan ehenoi tope e. Yt naku i irania'in ikuap ehay itote e. Mi'i hawyi — Pywo pe ti woro­ho'o'a­parap ta'yn e pote epe hawyi — Pyno waure wo areĩne'en uima'at hap kai ere'e ro tope e. Mi'i hawyi eiwo'o­wese hap yn na'yn toĩne'en eiwo'ope e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma'ato yt tuwa­nẽtup teran i ehay kape pote etioto ro typy ok sio mye'ym ok uimohey haria etioto ewywo ihay kuap hamo sio pywo sio yt kuap hamo e. Katu­pono sa'awy'i mio tã e Tupana — Yt naku i ti etimohey meremo wẽtup ok heso hap wẽtup ok miit ete yt etikuap i te pywo sio yt e hap pytkai e. Ma'ato to'o'ewy kahato ta'atu­henoi typy miit sio mye'ym miit wẽtup ok miit ete mi'i pote waku etimohey i'atuehay apo apo'ere hawyi e sa'awy'i miwan me e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma'ato yt tuwa­nẽtup teran i eiwo'omye'ym ok takat piat tonãpin hap kape pote ewehenoi ro uimohey haria sok pe e. Ma'ato uimohey haria sok piano inãpin hap kape yt tuwa­nẽtup teran i hawyi waku ewei'e tope — Koitywy yt urumi­mohey ewywuat i pote wẽtup ywania ewywuat ereĩne'en. Meimuẽwat mu'ap pyhyp haria ewywuat ra'yn ereĩne'en uruwa­nẽtup hawe waku ewei'e tope e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Karãpe — Waku mi'i tã watunug ewei'e eiwo'ope sio yt naku i mekewat watunug ewei'e eiwo'ope mi'i pote ei'e hap ewy Ui'ywot atipy piat to'e aru e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Wẽtup uhehay ahenoi teran ehepe are. Karãpe mesuwat yi tote typy ok uimohey haria hẽtup to'o'ewy Ui'ywot atipy piat pe kat e kat e hap mi'i hawyi tutum aru i'atu­miẽtup ok tã to'o'ewy'ewy i'atu­miẽtup tutum e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pywo pe ti are'e aikope aikope uimohey haria typy ok sio mye'ym ok te'eru­wa'a­tunug uimõ­typot hamo mi'i hap tote ti aru Uito i'ewyte areĩne'en i'atu­py'a­setpe e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Urumu'e hat e Peteru karãpe wẽtup ok emohey hat uima'at hawyi waure wo areĩne'en. Ma'ato mi'i hawyi uima'at i ra'yn mi'i pote karania wo waku atimo­hãpyk uima'at i hat sio 7 wo sio yt e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yt rat po'og po'og 7 wo hap kape ma'ato 490 wo hap kape etimo­hãpyk wẽtup ok piat ema'at hap ko'i upi e. Ta'i waure wo watoĩne'en at ka'ap e Iesui Peteru apo'e hawyi. ");
INSERT INTO mavNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Pyno ahenoi teran ehepe hã'ãkap wuo aikotã Tupana topyhu'at miit'in Porekuat no mesuwe i'ewyte atipy pe hap ewy e. Sa'awy'i so wẽtup morekuat ti'atu­kaykay tuwe­wawi temiit'in. Toi'atukuap teran karan karan i'atu­we­te­weru hap haype. ");
INSERT INTO mavNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wẽtup ok wete­weru hap ti iwato kahato aikotã aipotpap aheĩne'en hap ok tã kapiat sa'up ewy iwato kahato aikotã yt watum kuap i hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mi'i hawyi so yt toha'up nug kuap i ra'yn e. Mi'i pote morekuat to'e haty wo tesu­rara akag me. Etiwe­neru ro mesuwat wete­weru hat ihary'i wywo imẽpyt'in wywo yne hekat ko'i wywo hawyi eterut ro mekewat sa'up hawyi etum no uhepe iwete­weru hap sa'up nug hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ma'ato mi'i hawyi meremo wete­weru hat tuwe­pỹ'ã­tutuk morekuat ewa kape hawyi to'e — Atum yne wyti aru uiwe­te­weru hap epe uika'iwat e ehekatup porap'i pote atum wyti aru e haty wo. ");
INSERT INTO mavNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mi'i hawyi sig morekuat tiky'e kahato temiit hawyi — Pyno atiwaure ra'yn ewete­weru uhepiat hap e. Koitywy yt kat i po'og na'yn ewete­weru hap uikai e. Katu­pono atihep yne ra'yn e wete­weru hap uimiwan myi e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mi'i hawyi wete­weru hat toto ra'yn morekuat yaty­pepyi hawyi wẽtup ok temiit toipuẽti yt iwato hin i wete­weru hap wywo wẽtup e'at kapiat ipotpap hap ok tã yn iwete­weru hap e. Mi'i hawyi ma'ato totat ra'yn topo wo hut'yp ete hawyi to'e haty wo — Etum no ewete­weru hap uhepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mi'i hawyi hemiit yi tote tuwe­pỹ'ã­tutuk hawyi to'e — Mehĩ e ehekatup porap'i o hawyi atat aru yne uiwe­te­weru hap hawyi atum yne aru epe mehĩ e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","— Yt rat e woro­po'oro en mesup epyhik hap kape e ewete­weru hap upi e. Mi'i hawyi so tutum na'yn temiit surara'in me ipyhik hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mi'i pote irania'in morekuat emiit'in i'atu­py'ahak kahato tukupte'en hawyi — Yt naku i kahato tutunug temiit ete i'atu'e. Mi'i hawyi so tuwat ra'yn morekuat kape henoi hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mi'i hawyi morekuat tikuap ta'yn hawyi toikaykay mekewat sa'awy'iwuat wete­weru wato kahato hat tuwe­wawi hawyi to'e — Yt naku i kahato ti en katu­pono sa'awy'i atiwaure yne ewete­weru hap iwato rakat ehẽtup uhepiat hap upi e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Sa'awy'i ehaky'e'i uhepiat hap upi waure wo areĩne'en ewete­weru hap iwato kahato pytkai. Ma'ato mi'i hawyi en yt waure wo hin i ereĩne'en epiat wete­weru hin hat kai e. Waku ti waure wo ereĩne'en ewete­weru kurin kat etiat hat ete aikotã uito waure wo areĩne'en ewete­weru wato kahato hap ete hap ewy e temiit sa'ag kahato sa'awy'iwuat rakat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yt karãmuo i ra'yn uima'at epiat hap atimonik uipy'a pe e. Uimõ­py'ahak kahato yt waure wo i ereĩne'en irania'in miat ema'at hap etiat pote e. Mi'i hawyi ereĩne'en irane morekuat pyhik hawe mekewat ewete­weru uhepiat hap mohãpyk hamuat e. Waku itote erepotpap at ewete­weru hap sa'up ete e. waku ereĩne'en itote at ka'ap iheg me morekuat esurara'in sem po pe e ika'iwat temiit sa'ag me yt waure wo i toĩne'en irania'in miat toma'at hap etiat pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mi'i hawyi mio tã e ti ahepe Iesui wy. Yt naku i yt waure wo i eweikupte'en irania'in miat wete­weru hap kai e. Mi'i tã eweikupte'en hawyi Ui'ywot atipy piat mi'apiheg ko'i wo eweipyhu'at are yt waure wo i miit'in miat eima'at hap ete haria wo eweikupte'en mote e Iesui ahepe temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Toi'atumu'e kahu hawyi toto i ra'yn Iesui tetama Karireia pyi mekewat Iũtãu hy sakpo yi Iuteu kape toto. ");
INSERT INTO mavNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mi'i hawyi miit'in typy'i kahato tuwat hupi i'ewyte i'ahu rakaria. Mi'i haria ti Iesui ti'atu­moe­hãite kahato i'ahu rakaria itote. ");
INSERT INTO mavNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mi'i turan tõ'ẽ howawi nagnia ehay enoi haria ta'atuehay piat Iesui ti'aparap hap ta'atu­ky'esat haype. Mi'i hawyi ta'atuiã'ãg hap te'ero'e Iesui pe — Mehĩ urunãpin En sio waku apo uruwary wywo uruto'o'atoiat urumi­ky'esat ewy sio yt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","— U pãi e yt karãpe i apo nimuat sese miwan ete eiwemu'e apo'are aikotã mi'i pe sa'awy'i sese to'e — Ainug hap ihainia hawyi hary­poria wẽtup yn tutunug hap ete e. Wẽtup ipa'iat wẽtup iwary'i yn ni tutunug e miwan me. ");
INSERT INTO mavNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mi'i tupono tehary'i hawyi ihainia toiat to'ywot toty e hawyi toĩne'en tehary'i wywo yn. Mi'i hawyi toĩne'en tehary'i wywo hawyi wẽtup miit ewy yn na'yn topyhu'at wẽtup ihainia wẽtup hary­poria typy miit pytkai e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","To'okyi'at hawyi wẽtup miit yn na'yn ihainia hary­poria pytkai e. Katu­pono Tupana tunug mi'iria wẽtup miit ewywuat e. Mi'i tupono yt naku i ti Tupana mipehik watitek e Iesui nagnia ehay enoi haria pe ");
INSERT INTO mavNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mi'i pote apo'i'atu'e — Kat poteĩ pyno Musei to'e ahepe sa'awy'i — Yt eiwo'o­wese i ehary'i wywuat hawyi ti ewetunug no iwan me aikotã ehary'i wywuat yt eiwo'o­wese i hap hawyi waku eiwo'o'atoiat e Musei i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","— Ta'i yt eiwo'oky'e kuap i pote mio tã e Musei ehepe toĩne'en turan ma'ato sa'awy'i sese ti ipa'iat iwary'i nug hap e'at pe yt kat hin i wo'o'atoiat hap toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pywo pe ti uwe uwe he'aito kahato rakat atoiat hawyi toĩne'en wẽtup ok wywo mi'i miit ti'aparap kahato ra'yn Tupana wanẽtup hawe e Iesui Tupana ehay enoi haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mi'i pote ipotmu'eria — Urumu'e hat i'atu'e pyno yt karãpe i waku uruto'o'atoiat uruehary'i pote po'og waku yt iwary rakanuat i urutu­kupte'en sio yt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","— Ma'ato tukupte'en iwary kahato rakaria i'ewyte tukupte'en yt iwary rakanuat i mesuwat yi tote e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tukupte'en wyti ihainia'in yt iwary rakat nuat i katu­pono ta'atu­hire pyi te ta'atu'ywã'ĩ pyi te yt i'atu'yp i rakaria e. I'ewyte ti tukupte'en wyti miit'in minug misa'ahep takat ewywuat ko'i e. I'ewyte yt yne i ma'ato tukupte'en tuereto — Uito yt atiky'esat i uiwary katu­pono po'og waku yt iwary rakanuat i areĩne'en Tupana potpap nug hamuat e haria e. Yt yne i wen ma'ato ho'okup mio tã e haria e. Mi'i tã ewei'e eiwa­nẽtup hawe pote waku mi'i tã eweikupte'en Tupana potpap nug hamo ma'ato yt pote yt e Iesui ipotmu'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mi'i hawyi miit'in te'eropo'ok teran hira­karia Iesui kape — Mehĩ i'atu'e ereponug no urumẽpyt'in ete hawyi ehẽtup to Tupana pe urumẽpyt'in poityro hap i'atu'e. Mi'i hawyi ma'ato ipotmu'eria ti'atu­pyhyp kahato hira­karia howawi — Wãi'i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","— Yt ewei'atu­pyhyp tei'o hira­karia uhowawi pãi e Iesui ipotmu'eria pe. Tupana tiky'esat kahato temiit'in no hira­karia e. Tero tõ'ẽ uhowawi e. Katu­pono karãpe Tupana topyhu'at Morekuat no mesuwe mi'i hap e'at pe hira­karia ewywuat yn wakuat nuaria toi'airo temiit'in akag ko'i wo e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mi'i hawyi tuwe­ponug hira­karia ete hawyi toi'atue­waku yne ra'yn topo wo hawyi tuwat i ra'yn Iesui'in itote pyi. ");
INSERT INTO mavNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mi'i turan wẽtup ok kurum put'ok'e hawyi to'e Iesui pe — Wo'omu'e hat waku sese ti En e. Uimu'e ro aikotã aikotã atipuẽti uheĩne'en wuat'i e'at piat hap sa'up e. Mi'i pote ariot ewawi uimu'e hamuat e katu­pono wakuat sese ti En Uhyt e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","— Tupana yn ni wakuat sese kurum e Iesui wuat'i e'at piat heĩne'en hap ky'esat hat pe. Uito ti wakuat sese ere'e apo uhepiat e. Pyno etunug no yne Tupana miky'esat miwan miat ko'i hawyi waku pe ereĩne'en e Iesui kurum me. ");
INSERT INTO mavNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","— Pyno etimo­herep to uhepe Uhyt kat imiky'esat ko'i waku atunug e. — Ta'i yt erepot'auka tei'o are yt ewary wary tei'o are yt sero'ok'ere tei'o are yt etoma'at tei'o wẽtup ehay wo e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Etomõ­typot ro e'ywot ety e eti'atuky'e ro irania'in aikotã eweiky'e hap ok tã hap ewy e. Etunug mi'i tã mote waku pe ereĩne'en e Iesui kurum me. ");
INSERT INTO mavNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","— Ma'ato Uhyt e uihire pyi te ti rat mio tã e'e hap miwan miat atunug yne e. Kat e hap pyno mi'i hawyi waku atunug uheĩne'en wuat'i e'at piat hamuat puẽti hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","— Ta'i wẽtup mo etunug hawyi hekat rakat sese wo ereĩne'en aru atipy pe atum kurum e. Pyno etum yne ekare'en ahyt yne hatek takaria pe hawyi era'aipok uhowawi ereto uhupi uhemiit no hamo kurum e Iesui wuat'i e'at piat ky'esat hat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mio tã e hap toikuap hawyi ti tohaty'u ra'yn topy'a pe hawyi toto ra'yn katu­pono yt toimõ'ẽ teran i tekare'en sok yt hekat i rakaria pe haype. ");
INSERT INTO mavNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mi'i hawyi Iesui to'e topot­mu'eria pe — Are pãi niatpo sese ti rat wekare'en ky'e haria tuwehyt'ok atipy pe aikope Tupana toĩne'en Morekuat no hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Pywo ti niatpo kahato aikotã aihũ iwato rakat Kameru teke teran awi ehapo ka'a puo hap ewy niatpo hap ewy e. Mi'i hap ewy ti ma'ato po'og po'og niatpo hekat rakaria te'eru­wehyt'ok Tupana etama pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mio tã e hawyi ipotmu'eria te'eru­wa­nẽtup kahato — Pyno niatpo kahato Tupana etama pe uruwehyt'ok uruekat pote i'atu'e. Niatpo kahato urueha­kyera'at hap Mehĩ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mi'i pote teha'at kahato topot­mu'eria kape hawyi to'e — Yt uwe i tuwe­ha­kyera'at kuap e. Tupana yn ni miit'in ehakyera'at kuap hat e. Katu­pono mi'i yn nyti po'og hat toĩne'en e. Tupana tunug kuap yne yne. Yt kat i hin i ti niatpo tutunug towa­nẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mi'i hawyi Peteru to'e — Urumu'e hat e sa'awy'i uru'atoiat yne ra'yn uruekat eupiat urutuwat hamo e. Pyno kat aru ha'up etum uruepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mi'i pote Iesui tiwesat — Karãpe yi ipakup turan karãpe Uito Eheyke'et ara'apyk Morekuat e'amyap tote wuat'i miit'in miat uimõ­typot hamo mi'i turan ti aru pywo eweikupte'en ui'yatype 12 morekuat e'amyap tote uiwywo e ai'ywania Isareu ywania tok puo wẽtup ywania wẽtup ywania morekuat no eweikupte'en aru uwe yt naku i uwe waku hap e hamo eweikupte'en aru e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pywo ti rat uwe uwe uhehay upi uhupiat toto haype i'atoiat to'yat towywyt'in tokywyt'in toinyt'in tosaki'yt'in to'ywot'in toty'in tomẽpyt'in toko ko'i tomikoi uimi­ky'esat nug hamo mi'i hat ti aru po'og ipuẽti meimuẽwat tomi'atoiat ko'i kai sa'awy'iwuat kai. Po'og po'og ipuẽti meimuẽwat tomi'atoiat ko'i kai. Tomi'atoiat wẽtup kaipyi toipuẽti 100 na'yn mesuwe i'ewyte ti aru toipuẽti wuat'i e'at piat toĩne'en hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","I'ewyte ti aru mesup te wuat'i uimohey haria — Uito po'og e haria uimohey haria po'og kurin nakaria wo te'ero­pyhu'at atipy pe ma'ato uhemiit wuat'i miit'in eropat haria wo mesup we mi'i haria miit'in akag wo tukupte'en aru atipy pe e Iesui Peteru'in temiit'in me. Uito Mateu uimiwan mesuwe ");
INSERT INTO mavNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Mi'i hawyi Iesui to'e temiit'in me — Koitywy wẽtup hã'ãkap ahenoi teran ehepe aikotã Tupana topyhu'at wuat'i miit'in Porekuat no mesuwe aikotã toĩne'en atipy pe hap ewy e. Sa'awy'i so toto wẽtup ok hekat rakat hunete to'yat pyi teropat haria kaykay hamo motpap nug hamuat hamo toko piat Uwa ypia etiat i'atu­potpap hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","— Eipotpap at pote ti atum wẽtup e'at sa'up ehepe e. Mi'i pote — Hẽ i'atu'e. Mi'i hawyi toi'atu­po'oro tomikoi ypia kape. ");
INSERT INTO mavNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Meiũran mikoi ka'iwat ihot'ok po'og hawyi toto aikope miit'in tikyi'at wuat'i hap kape. Mi'i turan itote toi'atu­puẽti yt kat nug i haria motpap ekatup haria. ");
INSERT INTO mavNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mi'iria pe to'e — Eweiwat ro uiko kape hawyi meiũran aru atum ha'up wakuat ehepe e. — Ta'i i'atu'e hawyi tuwat ra'yn iko kape. ");
INSERT INTO mavNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Atpo­sake rokirẽ i'ewyte toi'atu­puẽti po'og miit'in mu'ap upi hawyi i'ewyte toi'atu­po'oro toko kape i'atu­potpap hamo waku i'atu'e pote. ");
INSERT INTO mavNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mi'i hawyi porap wãtym i turan po'og toi'atu­puẽti toto hap upi yt ipotpap i rakaria. Mi'i hawyi mi'iria pe — Kat poteĩ yt eipotpap hin i e yt kat i apo eiminug motpap e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","— Yt uwe i rat urupo'oro motpap nug hamo i'atu'e tope. — Pyno moro­ho'o­po'oro eipe uheUwa ypia kape e. Mi'i rẽ ti aru atum ha'up wakuat ehepe e. Mio tã e hawyi tuwat imikoi ypia kape. ");
INSERT INTO mavNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mi'i hawyi wãtym na'yn hawyi ipotpap takaria toi'atunug tuwe­wawi i'atu­potpap sa'up nug hamo. Mi'i hawyi temiit akag pe to'e — Pyno koitywy waku etum i'atu­potpap sa'up e. Sa'awy'i etum wat'ymuat ipotpap takaria pe mi'i rokirẽ etum sa'up ipotpap at rakaria pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mi'i hawyi toikaykay tuwe­wawi wat'ymuat ipotpap takaria. I'atu­potpap aparap yn wen ma'ato tutum wẽtup e'at sa'up i'atuepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Meiũran put'ok'i'atu'e sa'awy'i­tewuat i'atu­mi­po'oro yne hune pywiat rẽ wuat'i ipotpap takaria. Mi'iria te'eru­wa­nẽtup te'eru­wepe — Ahepe ti aru po'og tutum katu­pono aito po'og aipotpap aipotpap at pote i'atu'e. Ma'ato tutum sa'up aikotã aikotã irania'in me tutum hap ok tã ne ne'i. Yt uwe pe i po'og iwato tutum ma'ato wẽtup e'at sa'up kapiat tutum wuat'i pe. ");
INSERT INTO mavNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mi'i pote ipotpap at rakaria i'atuehay sa'ag ne'i ra'yn mekewat Uwa ypia ka'iwat wakuat ete sa'up tutum ta'atuepiat hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","— Meimuẽ­waria pe etum uruwat sa'up ok tã ne kurin kahato i'atu­potpap pytkai i'atu'e. Uruto kue at at hakup kahato mesuwe urupotpap i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mi'i pote go ka'iwat to'e mio tã e haria pe — Uiwyria'in yt kat i ti atunug sa'ag ehepe e. Yt ati'aparap hin i ti ehepe. Katu­pono sa'awy'i mio tã are — Atum aru ehepe wẽtup e'at sa'up e. Mi'i hap ewy ti atum na'yn ehepe. ");
INSERT INTO mavNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eipo pe ra'yn ehe'at sa'up e waku ra'yn e. Koitywy ti waku ra'yn ewei'aipok ei'yat kape. Katu­pono ehe'at sa'up toĩne'en eipo pe ui'e hap ewy atum e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ipotpap kurin nakaria pe atum ha'up i'ewyte ipotpap at rakaria pe atum ha'up to'o'ewy uimi­ky'esat ewy atum. Waku uhekat wywo atunug uimi­ky'esat ewy uhegyi'at hap ok tã e. Kat poteĩ yt eiwese i uiminug uhegyi'at hap ete e ipotpap at rakaria pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mi'i hap ewy ti aru Tupana tum ni aru temiit'in me sa'up wat'ymuaria pe tutum yianmiaria pe i'ewyte te. Ma'ato yianmiaria pe tutum wat'ymo hap ewy e Iesui hã'ãkap muo temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mi'i hawyi Iesui toto i ra'yn tawa wato Ieru­sarẽi kape mu'ap wato upi. Tuwat turan toi'atu­kaykay topot­mu'eria mu'ap ẽpe kape miit'in tok pyi i'atumu'e hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","I'atu­weran turan hawyi to'e — Eiwa­nẽtup to uhehay kape e. Koitywy areto ra'yn tawa Ieru­sarẽi kape mehĩ'in e. Put'okwato'e itote hawyi ti aru Eheyke'et ta'atupag pa'i kororia wãi'e hap enoi haria po pe ra'yn ui'auka hamo ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mi'i hawyi ti aru uhum wẽtup ywaniaria wanĩ­kaptia po pe i'atu­mi­kyry'i uhetiat hamo ui'ahyk ahyk hamo e. Mi'i hawyi ui'auka ti aru itotiaria aria'yp posak ete e. Mi'i hawyi uiku'uro sese itote ti aru e. Mye'ym e'at uisyp hawe uipiit topyhu'at. Ma'ato mi'i hawyi ti aru areĩne'en ne i ra'yn gu'uro pyi ma'ato e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mi'i turan put'ok'e wẽtup hary­poria Sepeteu ehary'i typy ok imẽpyt'in nywo Iesui ewawi. Pyno meke­waria tomẽpyt'in Iesui potmu'eria sese mi'iria. Pyno mana tuwe­pỹ'ã­tutuk hawyi to'e — Mimi e ahẽtup teran wyti epe uimi­ky'esat kahato e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Karãpe Morekuat no erepyhu'at turan atiky'esat uimẽpyt'in epo sese kai epo ran kai hap atiky'esat kahato e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mi'i pote — Mana e yt etikuap i kahato kat som emiẽtup uhepe e. Mi'i hawyi to'e imẽpyt'in me Iuwãu Tiaku pe — Are pãi eiwe'y'u irane uhekui'a pyi sapo hy wo uhatek e. Eiwe'y'u kuap apo i'ewyte uhekui'a pyi sapo hy wo e. — Ta'i urute'y'u kuap Uruka'iwat i'atu'e. Urutuwe'y'u kuap ekui'a pyi i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mi'i hawyi — Pywo ti uhemiit'in eiwe'y'u aru uhekui'a pyi sapo hy e. Uhatek hap ewywuat ewehã'ãg aru e. Ma'ato more­kuaria ewy uipo sese kai uiporan kai hamuat yt atum kuap i ehepe. Katu­pono Tupana yn ikuap uwe ui'yatypiat apyk hanuaria e. Tutum aru tomi'ai­roria pe tomi­ky'esat ewy e Iesui Iuwãu Tiaku pe. ");
INSERT INTO mavNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mio tã ta'atuẽtup pote irania'in hemiit'in i'atu­py'ahak typy ok ta'atu­wyria'in ete hawyi tu'uka ta'atuehay wo. ");
INSERT INTO mavNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mi'i turan Iesui ti'atu­kaykay i ra'yn tuwe­wawi — Uiwyria'in e mesu­wa­rote more­kuaria te'eru­wemiit'in po'oro po'oro kahato haty wo e. Toi'atu­saty'i saty'i kahato i'atu'e e. — Uruto ti po'og iwato'in nakaria wuat'i kai i'atu'e kahato e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ma'ato yt atiky'esat i kahato eipe mesu­wa­rotiat more­kuaria ewywuaria eweikupte'en eiwo'ope e. Mi'i pote uwe uwe topyhu'at teran uhemiit'in akag wo mi'i hat waku tuwenug semiit yne miit'in eropat hano topyhu'at e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Uimohey haria wuat'i powyro kahato haria yn ni waku uhemiit'in akag wo tukupte'en Tupana wanẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Uito Eheyke'et wuat'i miit'in eropat hat kahato areĩne'en wuat'i miit'in powyro hat areĩne'en e. Uito Eipo­rekuat koro areĩne'en wen ma'ato yt irania'in more­kuaria ewywuat i wyti Uito e. Wuat'i eropat hamo ariot i'ewyte atum irane uheĩne'en hap sa'up miit'in kyi'at Tupana wanuat hamo e Iesui topot­mu'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mi'i hawyi tuwat ra'yn tawa Ieriko pyi. Mi'i turan miit'in sem kahato tuwat itote pyi Iesui upi. ");
INSERT INTO mavNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tuwat aparap i mekewat tawa pyi turan typy ok yt ihapytig i rakaria mu'ap ẽpe upi apyk pe tukupte'en. Mi'iria tikuap ta'yn Iesui ut hap hawyi te'eru­wẽ­powat Iesui kape — Eraha'at ro uruewawi Mehĩ uruky'e hap wywo i'atu'e. Uruehaky'e'i mẽti uruto Mehĩ i'atu'e. Urupo­wyro En Uhyt i'atu'e. Ta'i morekuat Tawi saipepiat ti En i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mio tã i'atu'e pote meimẽ­puaria — Wãi ehehay pirik poity'i i'atu'e. Eiwẽ­pohep to i'atu'e ma'ato yt i'atu­wẽ­pohep hin i. Po'og ne'i te'eru­wẽ­powat — Urueha­kyera'at En Uruka'iwat Tawi Sa'yru En i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mi'i hawyi Iesui topyhu'at itote hawyi tuwẽ­powat — Eweĩ'ẽ ro meikowo uhowawi uhyt'i'in e. Mio tã e pote tokoka'at ra'yn howawi hawyi to'e — Kat aru atunug eimi­ky'esat ehepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mi'i hawyi ta'atu­wesat — Uru'akasa pakup'i hap nug hap ti uruiky'esat etunug Mehĩ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mi'i hawyi Iesui ti'atuky'e kahato hawyi tuwe­ponug na'yn i'atueha ete hawyi meremo i'atue­ha­pytig te'era'a­kasa pakup'i i ra'yn. Mi'i hawyi tuwat ra'yn Iesui upi mu'ap upi heremo yne i'atueha ete pote waku kahato i'atu'e. Mi'i tã Iesui tunug sa'awy'i. Mi'i hawyi uito Mateu atiwan mesuwe. ");
INSERT INTO mavNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mi'i hap totepyi Iesui toto i ra'yn tawa wato Ieru­sarẽi kape towyria'in nywo. Put'okta'atu'e ra'yn tawa Pewake tote hawyi tuwat mekewat yity'ok kape Uriweira yp mikoi ypia e hap kape. Itote pyi Iesui tipo'oro typy ok temiit tawa hit kape. ");
INSERT INTO mavNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","— Uhyt'i'in e eweiwat ro mekewat tawa hit kape ai'akasa hap kape e. Put'ok'ewei'e itote turan ti aru eweipuẽti i'atuhũ Iumenta to'asaity nug me tomẽpyt wywo e. Mi'iria o ewei'asai­typok hawyi ewete­ropo'ok ra'yn uhowawi e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma'ato — Kan hamo ewetioto uruhũ i'atu'e pote o — Ta'i Aika'iwat wyti ipuru porap'i eihũ ko'i ewei'e o mi'i pote meremo — Hẽto pyno eweitioto ro i'atu'e aru ehepe e. Mi'i hap ewy yne ti aru eweipuẽti itote e Iesui typy ok takaria tomi­po'o­roria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sa'awy'iwuat Tupana ehay enoi hat mio tã e tomiwan me Iesui etiat ");
INSERT INTO mavNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","— Tut wyti aru Aipo­typot sese aihũ Iumenta tote ahowawi ewei'e ro tawa Ieru­sarẽi miaria pe e. Yt morekuat ewy hin i tut ma'ato aihũ Iumenta mẽpyt hit tote e ti aikotã sa'awy'i­tewuat miwan me Isaia 62.11 pe Iesui etiat tohenoi. ");
INSERT INTO mavNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mi'i hawyi tuwat ra'yn ipotmu'eria typy ok hawyi aikotã tohenoi hap ewy ta'atunug. ");
INSERT INTO mavNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mi'i hawyi ta'atuerut ra'yn i'atuhũ Iumenta imẽpyt wywo Iesui kape. Mi'i hawyi ta'atue­sokpe ko'i ta'atu­po­rokpun Iumenta ok tote hawyi Iesui ta'am na'yn apyk pe i'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mi'i hawyi irania'in miit'in typy'i rakaria tipy­sapnug ta'atue­sokpe ko'i wo mu'ap tote. Irania'in iporokpun mu'ap upi aria'yp iãgã ko'i imõtypot hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mi'i hawyi typy'i rakaria wat'ymo i'ewyte yianmiaria i'atu­wepit kahato — Ereke ro ereke ro morekuat Tawi saipepiat i'atu'e ta'atuehay pirik wo. Waku kahato En atipy kaipywiat i'atu'e. Ta'i Tupana mimõ­typot kahato En i'atu'e. Katu­pono Tupana mõtypot hat En pote i'atu'e. Waku sese waku sese Tupana i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mi'i hawyi put'ok'e Iesui tawa wato Ieru­sarẽi me hawyi itotiaria irania'in ikohyeput kohyeput'i kowo'i kowo'i — Uwe som Mi'i Miit i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","— Ta'i Mi'i Miit ti mekewat Tupana ehay moherep hat yi Karireia tawa Nasare kaipywiat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mi'i hawyi Iesui teke ra'yn Tupana mõtypot yat koro pe hawyi toi'atu­sopo kahato kat ko'i kat ko'i weneru itotiaria hawyi toi'atu­pugha kahato mesa ko'i. Toi'atu'ã­pe'okpun yne tineiru pat'ok pat'ok hap mesa ko'i. I'ewyte pykasu weneru haria amyap ko'i toi'atuã­pe'okpun i'atue­py­kasu ko'i wywo ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mi'i waku hawyi Iesui to'e haty wo i'atuepe — Mio tã to'e Tupana sa'awy'i miwan me — Ui'yat wyti meiũ e. Mi'i ti atiky'esat wuat'i ywania ehay uhowawiat at hamuat e ti Tupana miwan me e. Ma'ato mesup ti Tupana mõtypot yat koro topyhu'at sero'oke haria yat koro wo ne'i rat e. Yt naku i nug haria kahato eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Toi'atu­sopo Tupana mõtypot yat pyi hawyi yt ihapytig i rakaria yt ipoĩ'ãm kuap i rakaria tõ'ẽ tõ'ẽ howawi hawyi toi'atu­moe­hãite ra'yn ihaky'e'i rakaria itote. ");
INSERT INTO mavNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mi'i pote pa'i kororia Wãi'e hap enoi haria te'eraha'at kahato iminug wakuap kape. I'ewyte ta'atukuap hira­karia piat — Waku kahato En morekuat Tawi saipepiat kahato En i'atu'e hap. Mi'i pote i'atu­saiwot kahato ra'yn pa'i koro ko'i ");
INSERT INTO mavNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","— Yt etikuap i apo hira­karia kat i'atu'e kat i'atu'e ewawiat hap i'atu'e Iesui pe. Yt naku i hira­karia emõtypot morekuat ewy i'atu'e. Mi'i hawyi toi'atu­wesat — Ta'i atikuap kahato hira­karia ehay uhepiat ko'i e. Yt eweimu'e i te apo Tupana miwan me sa'awy'iwuat ete aikotã to'e — Hira­karia hit ko'i yn uimõ­typot kuap haria sese e Tupana mõtypot hap ete e. Ta'i mi sym haria hira­karia yn uimõ­typot kuap po'og irania'in torania kai e Tupana sa'awy'i. Mi'i pote yt kat hamo i wãi'are i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mio tã to'e hawyi toto ra'yn tawa Ieru­sarẽi myi tawa hit Petania kape. Mi'i hawyi toket itote. ");
INSERT INTO mavNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Itote pyi mũki'ite hunete ta'aipok i ra'yn tawa wato Ieru­sarẽi kape i ra'yn. Mi'i turan mu'ap upi Iesui hesy'at kahato ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mi'i turan ta'akasa Wiku yp mu'ap ẽpe upi hawyi toto haat ky'ewi ma'ato i'yhop yn toipuẽti hesy'at kahato turan. Mi'i pote to'e Wiku yp we — Yt naku i rat en e. Pyno koitywy ti aru yt sake i ra'yn esaat e. Mio tã e hap hawyi meremo i'yp gag na'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mi'i hap kape ipotmu'eria te'eraha'at hawyi iku'uro ra'yn pote. Mi'i hawyi te'ero'e — Urumu'e hat i'atu'e aikotã emisaty'i saty'i iku'uro ra'yn i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","— Uiwyria'in e eweimohey ro Tupana haty wo yt kat i eweimohey sa'ag ne'i wywo mi'i tã uiminug ewywuat ewetunug kuap hamo e. Ma'ato po'og iwato uiminug kai ewetunug kuap e. Ta'i uwe uwe meiũwat yity'ok pe to'e — Ereto ro meiũpepyi y'y wato kape hawyi min'ere ro y'y pe ewei'e Tupana mohey hap yn nywo mi'i pote ti aru toto ra'yn meremo ei'e hap ewy imohey hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mi'i tupono kat ere ehẽtup Tupana kape imohey sese hap wywo mi'i e'e hap ewy kahato ti aru topyhu'at e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mi'i hawyi put'ok'e i ra'yn Iesui Tupana mõtypot hap yat koro pe hawyi toi'atumu'e i ra'yn. Mi'i turan tõ'ẽ tõ'ẽ pa'i akag ko'i Iuteu ywania akag ko'i apo'i'atu'e hamo — Uwe epo'oro ga'atpuat weneru weneru i haria sopo hamuat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","— Pyno apo'are ehepe ewehenoi mono mi'i pote Uito i'ewyte ahenoi uwe uipo'oro hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Uweĩ pyno Iuwãu po'oro hat wo'oset'ok hamuat hat sio Tupana ipo'oro sio miit'in ipo'oro haria e. Mi'i pote te'eru­wa­nẽtup to'o'ewawi — Ta'i Tupana mipo'oro Iuwãu ai'e pote aru kat poteĩ pyno yt eweimohey i e aru ahepe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma'ato miit'in mipo'oro ti Iuwãu ai'e pote ti aru miit'in i'atu­py'ahak kahato ahete katu­pono irania'in Iuwãu ti Tupana mipo'oro e haria tukupte'en i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mi'i hawyi — U pãi Uhyt yt uruikuap i sese wyti uwe mipo'oro Iuwãu i'atu'e. — Pyno yt uiwesat i pote Uito i'ewyte yt woro­ho'o­wesat kuap i ehepe uwe ehay pyi meikotã atunug hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mi'i hawyi waku eweiwa­nẽtup o uimienoi kape e. Sa'awy'i so wẽtup ok miit typy ok ha'yru rakat toĩne'en. Mi'i hawyi wẽtup e'at pe so to'e tosa'yru yianme — Uha'yru e atiky'esat wyti koitywy epotpap uimikoi ypia pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma'ato so — Yt uipopap i rat papai e. Ma'ato meiũran tuwa­nẽtup hawyi paa'e to'ywot ehay pun hap ete. Mi'i pote yt uipotpap i rat to'e pytkai toto ra'yn to'ywot mikoi ypia kape. ");
INSERT INTO mavNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mi'i hawyi so iywyt pe — Uha'yru e atiky'esat wyti koitywy epotpap uimikoi ypia pe e. Mi'i hawyi — Ta'i papai areto meremo e ma'ato yt toto hin i mio tã to'e pytkai e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mi'i pote apo'are ehepe uwe uwe som pyno to'ywot miky'esat nug hat sio wat'yp sio yian e Iesui Tupana mõtypot yat piaria akag ko'i pe. Mi'i hawyi ta'atu­wesat — Ta'i yian yn inug to'ywot miky'esat i'atu'e. — Pywo ti rat mi'i tã ti rat e Iesui. Eipe ti mekewat sa'yru wat'yp ewy kahato eipe — Urutuwat emiky'esat nug hamo Papai ewei'e Tupana pe ma'ato yt. Mi'i hawyi irania'in hary­poria yt iwe'eg i sese rakaria i'ewyte ahewa­nĩ­kaptia emiit'in aipo­hari haria — Yt urutuwat i Papai emiky'esat nug hamo i'atu'e Tupana pe. Ma'ato te'eru­wa­nẽtup hawyi paa'i'atu'e hawyi meiũran Tupana ehay pun hap ete. Mi'i rẽ koitywy tuwehyt'ok kahato Tupana etama pe eheiam me e Iesui pa'i akag ko'i pe miit'in to'ywania akag ko'i pe. ");
INSERT INTO mavNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ahet'ok Iuwãu put'okto'e hawyi aimu'e kahato Tupana kapiat mu'ap upi e. Mi'i hawyi ti yt nakuaria i — Pywo i'atu'e ra'yn hawyi tuwat kahato Tupana kape e. Ma'ato eiperia ti yt eweiwat hin i Tupana kape Iuwãu miat enoi hap upi e. Ma'ato irania'in meimuẽwat hary­poria'in yt iwe'eg i rakaria paa'i'atu'e i'ewyte mekewat ahewa­nĩ­kaptia sa'up porera'at haria paa'i'atu'e. Mi'i haria ko'i ewei'akasa yne ra'yn pytkai yt paa'ewei'e hin i eipy'a pe. Katu­pono mekewat sa'yru wat'yp ewywuat eweikupte'en eipe yt eweihay pywo hin i eipe Ei'ywot ehay e Iesui pa'i koro akag ko'i pe. ");
INSERT INTO mavNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mi'i hawyi — Pyno wẽtup sehay ahenoi ehepe hã'ãkap wuat e pa'i kororia pe to'ywania akag ko'i pe. Sa'awy'i so toĩne'en wẽtup ok miit yi wato ka'iwat e. Mi'i hawyi so ihay ra'yn Uwa ypia nug hap ete e. Mi'i hawyi so toikoi hawyi toipyhyp yne ra'yn hero'ok haria pupi hawyi tutunug nu ka'a Uwa tok hamo Uwa hy sapo nug hamo e. Mi'i hawyi so i'ypia py'asetpe so surara yat ywaiti rakat tutunug surara teha'at mikoi ero'ok haria wãi'e hamo. Mi'i so iwato kahato i'ypia e. Hãpyk yne hawyi so toipuru to'ywania pe Uwa ypia i'apykok kuap haria pe hawyi so toto ra'yn i'ypia wato ka'iwat wẽtup setama kape ra'yn toto ma'ato teuwa ypia waku hap e'at pe toiky'esat toha'up nug e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mi'i pote heuwa ypia saat hap e'at put'ok'e ra'yn hawyi toi'atu­po'oro temiit'in tomikoi ypia apykok haria kape tomikoi sa'up pat'ok sat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma'ato so i'apykok haria yt ho'oium neran hin i ra'yn. Ipuruk haria yt ho'oium i ra'yn ta'atu­mipo'ok ko'i e. Mi'i hawyi so ta'atu­pytyk ne'i imipo'o­roria hawyi wẽtup ok ti ta'atu'ahyk ahyk ne'i wẽtup ok ta'atu'auka wẽtup ok kape ti nu wo mak mak'i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mi'i hawyi po'og toi'atu­po'oro temiit sa'up sat hamo ma'ato so i'ewyte ta'atunug i'atuete e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","— Pyno koitywy atipo'oro uha'yru sese e. Uha'yru sese tupono ti aru ta'atu­mõ­typot rat pãi e so tuwa­nẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mi'i hawyi so put'ok'e ra'yn wat'ymuat hawyi yi wato imipuru apykok haria te'eraha'at howawi hawyi te'ero'e to'ope — Meiẽ ra'yn ti tut ra'yn yi ka'iwat saipepiat i'atu'e. Pyno waku wati'auka meiẽwat ha'yru mi'i hawyi meiũran iku'uro ra'yn i'ywot hawyi aipo pe ra'yn imikoi ypia i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mio tã i'atu'e turan put'ok'e ha'yru hawyi ta'atu­pytyk hawyi ta'atu­pugha i'ywot e'yi ekuekai hawyi ta'atu'auka ra'yn ha'yru imipo'oro e Iesui tuwepiat pa'i koro akag ko'i pe. ");
INSERT INTO mavNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pyno apo'are ehepe aikotã aru ika'iwat tunug meimuẽwat tosa'yru auka haria ete ta'aipok i ra'yn tomikoi ypia kape hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mi'i pote pa'i kororia tiwesat — Ta'i tut hawyi ti aru toi'atu'uka kahato ti aru meimuẽwat yt naku i nug haria i'atu'e. Ta'i mi'i hawyi ti rat wẽtup ywania pe haat hap e'at piat ha'up ium kuap haria pe aru tutum i te'yi tomikoi ypia i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","— Ta'i pywo kahato ti uiwesat. Ehepiat e hap ewy ti aru topyhu'at ehete are aikotã sa'awy'i Tupana to'e hap ewy — Nu po'og waku rakat ui'yat nug hamuat ta'atu­pugha ra'yn — Yt naku i ta'atu'e haype. Mi'i pote Mi'i Nu i'atu­mi­pugha wo ti aru aha'awynug ui'yat po'og ikahu sese rakat e Tupana. Yt karãmuo i apo eiwemu'e mi'i e hap miwan me Isaia 28.16 pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mi'i e hap ewy kahato ti aru topyhu'at mesuwe katu­pono Tupana tihep ta'yn eipo pyi tetama atipy piat ewywuat. Mi'i hawyi ti aru tutum wẽtup ywania pe ra'yn tomikoi ypia sa'up ium kuap haria pe i ra'yn tutum e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Uwe uwe ta'at ti mekewat Nu miit'in mipun ete mi'iria ti aru wepik pik sese haria wo te'ero­pyhu'at. Ma'ato uwe uwe mekewat Nu tote ta'at hap aru mesuwat Nu mi'i haria ti aru iku'i ku'i wo te'ero­pyhu'at e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mio tã e pote pa'i kororia — Yt naku i ihay i'atu'e. Katu­pono ahete aimohit hamo mio hã'ãkap tohenoi i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mi'i pote ta'atu­pyhyp teran Iesui wen ma'ato typy'i kahato miit'in Iesui apypueri wo tukupte'en pote te'eroken'ẽ ne'i ipyhyp hamo — Iesui ti Tupana ehay moherep hat sese toĩne'en i'atu'e i'apy­pueri haria pote te'eroken'ẽ mi'iria mõpy'ahak hap pupi. Uito Mateu atunug uimiwan mesuwe are. ");
INSERT INTO mavNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mi'i hawyi wẽtup hã'ãkap wuo Iesui ti'atumu'e itotiaria — Pyno ti ran ahenoi teran ehepe aikotã Tupana aikaykay temiit no hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Pyno wẽtup e'at pe so wẽtup ok morekuat koro to'e te'eropat haria pe — Atunug neran ienuk hap iwato kahato uha'yru mõtypot hamo katu­pono uha'yru ihary'i hap e'at put'ok'e ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pyno woro­ho'o­po'oro uhetama kape itotiaria tu'isa'in nãpin hamo i'ewyte ti hekat rakaria atukaykay hamo uha'yru sese ehary'i hap e'at pe mõtypot hamo e. Mi'i hamo atunug neran ienuk iwato hap haype e temiit me. Tohenoi hawyi tuwat ra'yn hemiit'in i'atu­nãpin hamo. Ma'ato so imikaykay ko'i yt tuwat teran i. ");
INSERT INTO mavNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mi'i pote so irania'in te'eropat haria toi'atu­po'oro i'atu­nãpin hamo. Waku yne ra'yn wyti aimi'u ewei'e ro i'atuepe. Ikahu kahato ti ienuk hap tutunug ewei'e o e. Uihũria wewato ahup ko'i ikap takaria iwyp ta'yn imẽpyt hin ni ikã'ã ko'i wo ra'yn ewei'e o e. Mi'i pote meremo soke eweiwat ewei'e o i'atuepe katu­pono waku ra'yn ahenuk hamo ewei'e o e. Uha'yru ehary'i hap nug turanuat imõtypot hap ti put'ok'e ra'yn ewei'e ro i'atuepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mio tã e hawyi tuwat ma'ato i'ewyte yt urutuwat kuap i i'atu'e ne'i. Irania'in to'okyry'i ne'i imipo'o­roria ete. Irania'in ta'atu­potpap nug hamo tuwat. Wẽtup ok toto toko kape wẽtup ok kyi'at to'e hamo ne'i toto. ");
INSERT INTO mavNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma'ato irania'in tawa piaria to'okyry'i imipo'o­roria ete. Wẽtup ok wẽtup ok ta'atu'auka ra'yn imipo'oro. ");
INSERT INTO mavNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mi'i hap morekuat koro tikuap hawyi ipy'ahak ta'yn. Mi'i hawyi toi'atu­po'oro tesu­rara'in ahyt topot­po'o­roria etiat mikyry'i haria atu'uka hamo. Mi'i hawyi surara'in tiwuk ta'yn i'atue­tawa e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mi'i hawyi to'e ti tomi'a­tu­po'o­roria pe — Ta'i waku ra'yn ti aimi'u e ma'ato sa'awy'i­wuaria uimi'a­tu­kaykay ko'i yt nakuaria i e. I'atue­waku hap ti yt put'ok'e i uha'yru wywuat te'erenuk hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mi'i tupono eweiwat yne tawa hit ko'i upi e. Mi'iria o ewei'atu­kaykay yne meikowo uha'yru wary hap e'at kape e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mi'i hawyi tuwat yne mu'ap upiat tawa hit ko'i kape wuat'i miit'in i'atu­kaykay hamo. Ta'atu­kaykay wakuaria i'ewyte yt nakuaria i ko'i. Howapy kahato morekuat ienuk hap eiam getap koro miit'in wo yt to'o'ewy ewywuaria i wo. Put'ok'i'atu'e turan morekuat ekamisa ewywuat tomosat pe yne imiium yne õ'ẽ haria pianuat ko'i. Mi'i hawyi to'o'ewy'ewy ikahuria tukupte'en i'atu­painug hap to'o'ewy'ewy ikahuria i'atue­ka­misa ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Meiũran morekuat koro tut i'atu­wywo hawyi toipuẽti wẽtup ok i'atu­py'a­setpe — Uito yt atiky'esat i morekuat esokpe ewywuat e hano katu­pono uiat waku po'og e hat. ");
INSERT INTO mavNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mi'i pote morekuat to'e mi'i e hat pe — Mehĩ kat poteĩ yt etiky'esat i uimiium sokpe pakup ikahu rakat e. Mi'i pote yt toiwesat kuap i tuwe­mõti haype yt kat e kuap i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mi'i hawyi morekuat ti'atu­kaykay tesu­rara'in — Eweipopo'i ro meiẽwat miit uhesokpe pun hat ipo ete ipy ete e. Mi'i hawyi ewetioto ro meiũpepyi hawyi eweipun no i'ypyryp wato hawe e aikope kyry'et kyry'et'i'atu'e hap kape ta'atuwak popuat hap kape e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mi'i hap ewy ti Tupana eikaykay temiit no. Toi'atu­kaykay miit'in wuat'i ywania kawiat Tosa'yru mõtypot hap kapiat hap ewy ma'ato sa'awy'i­wuaria imikaykay ko'i ui'ywania yt tuwat teran i mote irania'in ywania ko'i tokoka'at e Iesui to'ywania pe Iuteuria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mi'i hawyi wo'omu'e haria yt i'atu­wese i Iesui ete — Tupana ti'atu­kaykay wyti aru irania'in ywania e Iesui pote. Mi'i hawyi tuwat ra'yn Iesui yaty­pepyi hawyi te'eru­wa'a­tunug i'atu'akag koro ko'i Iesui ma'at hap etiat to'oehay hamo. Mi'i hawyi ta'atuehay ehay kat ehay wo kat ehay wo waku Iesui ehay aparap ta'atu'auka teran haype. ");
INSERT INTO mavNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mi'i hawyi ta'atu­po'oro ta'atuemiit'in morekuat Eroti emiit'in wywo Iesui ma'at teran haype. Mi'i hawyi te'ero'e — Urumu'e hat ta'i uruikuap ta'yn wyti ehay hãpyk hap i'atu'e. Ta'i eti'atumu'e hãpyk kahato ti miit'in Tupana miky'esat ewy i'atu'e. I'ewyte ti yt ereken'ẽ hin i miit'in mupi i'atu'e. I'ewyte uruikuap ti aikotã miit'in eti'atu­mõ­typot to'o'ewy'ewy i'atu'e iwato'in nakaria i'ewyte kurin nakaria i'atu'e hap uruikuap ta'yn uruto i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mi'i tupono etomo­herep to ewanẽtup hap uruepe sio waku apo i'atu­po­rekuat Sesa pe waha'upnug i'atu'e sio yt tomi­ky'esat ewy imiẽtup ahepiat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma'ato mio tã i'atu'e i'atuehay hap Iesui tikuap tuwa­nẽtup hawe toma'at hamuat hap etiat toikuap. Mi'i hawyi toi'atu­wesat — Typy ihay rakaria sese ti eipe katu­pono uima'at reran ne'i are uhã'ãg neran haype hap atikuap ta'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pyno eweimo­herep to uhepe i'ape rakat i'atue­ti­neiru e. Ta'atuium hawyi Iesui to'e ");
INSERT INTO mavNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","— Uwe iã'ãkap meiũ i'ape tote toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mi'i pote — Ta'i morekuat wato Sesa iã'ãkap i'atu'e. — Pyno iwat hã'ãkap wywuat pywuat tupono tope ro ewetum are ma'ato Tupana wanuat waku ewetum no Tupana pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mio tã ihay ta'atukuap ta'yn hawyi i'atu­perup kahato ra'yn te'eru­wa­nẽtup kahato iwe'eg hap ete. Mi'i hawyi tuwat ima'at reran haria. ");
INSERT INTO mavNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mi'i hawyi meimuẽ­waria miit'in iku'uro hawyi yt te'eru­we­hymut hin i e haria te'ero'e Iesui pe ");
INSERT INTO mavNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","— Urumu'e hat sa'awy'i Musei to'e uruepe — Karãpe eiwy'ok eheyke'et iku'uro yt imẽpyt i te turan mi'i pote waku hehiwu iywyt po pe i ra'yn topyhu'at iku'uro rakat mẽpyt nug hamo e Musei sa'awy'i i'atu'e. Mio tã e tupono ti uruhenoi teran epe wẽtup sehay uhyt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pyno sa'awy'i so ihainia so ha'yru'in sok 7 ok takaria. Mi'iria so i'atueyke'et ihary'i ra'yn ma'ato so yt tomẽpyt i te turan iku'uro ra'yn i'atueyke'et. ");
INSERT INTO mavNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mi'i hawyi so iywyt wywo i ra'yn imi'atoiat hehiwu i'atu'e. Mi'i so i'ewyte iku'uro ra'yn yt tomẽpyt i te turan. Mi'i tã me so wẽtup i wẽtup i wywo toĩne'en sake so topap yne. ");
INSERT INTO mavNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mi'i hawyi yt uwe i imẽpyt rokirẽ iku'uro ra'yn hary­poria i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mi'i tupono karãpe tuwenõ'ẽ gu'uro pyi hawyi apuru uwe wary wo meiẽ hary­poria i'atu'e 7 ok he'aito rakat ieĩne'en hat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pyno eipe ewei'aparap kahato e Iesui i'atuepe. Yt eweikuap i Tupana ehay miwan miat pote e. Katu­pono yt eweikuap hin i Tupana hesaika hap yne nug kuap hamuat. ");
INSERT INTO mavNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pywo pe ti watu­wẽtem gu'uro pyi hawyi yt kat i ra'yn ahehary'i hamuat itote. Ma'ato ti watoĩne'en aikotã atipy pe yt iwary i rakaria ewy i ra'yn watu­kupte'en irane e. Mi'iria ti yt karãmuo i i'atu­hary'i e. Katu­pono Tupana emiit'in atipy piat ewywuat tukupte'en yt ihainia kaipywiat i yt hary­poria kaipywiat i ra'yn e. Mi'iria ti tuweu­piaria ra'yn e. Mi'i Iesui to'e miit'in iku'uro hawyi yt te'eru­we­hymut hin i ra'yn e haria pe ");
INSERT INTO mavNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","— Pyno ahenoi ehepe aikotã miit'in gu'uro pywiat wẽtem hap e. Yt karãmuo i apo eiwemu'e Tupana ehay miwan ete aikotã sa'awy'i Tupana to'e ");
INSERT INTO mavNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","— Uito ti Aparãu eTupana Isaki eTupana. Uito ti Iako eTupana e. Mi'i tupono pywo pe are'e ehepe Aparãu Isaki Iako tukupte'en ne e. Katu­pono Tupana ti yt map haria eTupana i. Ta'i ihãite rakaria eTupana yn e. Mi'i tupono mi'iria topap wen ma'ato i'atuieĩne'en pakup i hamuat toĩne'en na'yn e Iesui Tupana ehay miwan miat wan pakup i haria pe yt kat i ra'yn ti aiku'uro hawyi aheĩne'en hap e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mio tã e pote meimuẽwat miit'in typy'i rakaria te'eru­wa­nẽtup hawyi i'atu­perup ta'yn. — Pyno yt uwe i wyti aimu'e meiũwat ewywuat aimu'e po'og i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mi'i hawyi pa'i akag koro ko'i tikuap ta'yn aikotã wani wani haria ehay akit Iesui piat hamuat ta'atukuap hawyi te'eru­wa'a­tunug — Aikotã som watunug meimẽwat miit ete ihay moma hamo i'atu'e te'eru­wa'a­tunug mi'i hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","I'ewyte i'atu­py'a­setpe toĩne'en wẽtup ok wo'onãpin kuap hat apo apoto'e Iesui piat hamo. Iesui wehay aparap hap ky'ewi. ");
INSERT INTO mavNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Wẽtup ok — Wo'omu'e hat e kat e hap kat e hap som po'og iwato Tupana ainãpin hap wuat'i kai apo'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","— Pyno ahenoi po'og hesaika rakat piat ainãpin hap e. Tomiwan kaipywiat hap ahenoi po'og hesaika rakat — Waku watiky'e kahato Aika'iwat Tupana yne aipy'a pe yne aiwa­nẽtup hawe yne aiwe'eg hawe e miwan me. ");
INSERT INTO mavNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mi'i ti po'og iwato Tupana wo'onãpin hap torania kai e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma'ato wẽtup wo'onãpin hap porap i'ewywuat are mio tã e — Eweiky'e ro irania'in. Waku wati'a­tuky'e kahato irania'in aikotã aiweky'e hap ewy e miwan me. ");
INSERT INTO mavNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Meimuẽwat typy rakat kaipyi ti watikuap yne ra'yn wo'onãpin hap. Mi'i hap watunug mi'i pote ti yne sa'awy'iwuat Tupana ehay enoi haria wo'onãpin hap ewy ra'yn watunug e Iesui wo'onãpin hat kuap hat pe mekewat wo'omu'e hat py'asetpiat. ");
INSERT INTO mavNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mi'i pote Iesui apo'e irania'in wa'atunug haria pe wo'omu'e haria pe ");
INSERT INTO mavNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","— Atikuap teran ti aikotã eweiwa­nẽtup mekewat Tupana Mipo'oro Aipo­rekuat hap etiat e. Mi'i tupono uiwesat ro eipe uwe Sa'yru Mi'i e. Mi'i hawyi te'ero'e — Ta'i morekuat Tawi sa'yru i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mi'i hawyi Iesui to'e — Ma'ato ti sa'awy'i morekuat Tawi ti to'e — Uhetu­pana to'e Uika'iwat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","— Era'apyk o meiũpe uipo sese kai e ti. Ta'i meiũran ti aru epy ywyt'okpype yne atunug ewanĩ­kaptia e ti Tupana e morekuat Tawi Tupana Pã'ãu kaipyi wepy 110.1 pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Morekuat Tawi sa'yru Tupana Mipo'oro Aipo­rekuat nuat ewei'e apo'are ma'ato yt mio tã e ti morekuat Tawi. — Uipo­rekuat Tupana Mipo'oro e ti pãi. ");
INSERT INTO mavNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mio tã e pote yt ta'atu­wesat kuap i ra'yn. Mio tã e ra'yn hawyi yt uwe kuap i ra'yn ta'atu­so'o­po'oro kuap i ima'at hamo. I'atu­wẽ­pohep yne ra'yn Iesui iã'ãg i iã'ãg i hap ete. Katu­pono yt kat i i'atu'e kuap i ra'yn ima'at reran haria are uito Mateu uimiwan me. ");
INSERT INTO mavNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mi'i hawyi Iesui to'e miit'in sem ko'i pe tomi'a­tu­mu'eria pe ");
INSERT INTO mavNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","— Uiwyria'in meimuẽwat Tupana ehay miwan miat kuap haria wo'omu'e haria te te'ero­pyhu'at Musei saipe­piaria wo aimu'e Musei ehay wuat haria. Mi'iria ti ainãpin kahato Musei wo'onãpin hap ko'i ete. ");
INSERT INTO mavNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mi'i tupono waku watunug o kat e kat e i'atu'e ainãpin hap Musei kaipywiat hap ewy e. Ma'ato o yt i'atueko ewy ne'i tei'o eweikupte'en e. Katu­pono i'atuwẽ pywiat mienoi ti hãpyk takat ma'ato i'atueko ti i'atupiit etiat ti yt hãpyk hin i e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Katu­pono yrysakag ipotyi rakat ai'okpe tote hap ewy ta'atunug ma'ato ti aito yt wahupit kuap i ipotyi poity'i ai'akit hap ewy ne'i e. Ta'atupag wahupit hamo ma'ato mi'iria yt aipo­wyro hin i hupit hamo. Yt ta'atuiã'ãg ne wy hupit hap yt wẽtup puĩ'ã wo te wy aipo­wyro. Yt kat i hin i wyti aheha­kyera'at hap i'atuepe e Iesui itotiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ta'i mi'iria ti ikat miit'in upi wuat'i piat — En wyti waku kahato uhyt e hap ta'atu­ky'esat kahato. Miit'in ehamo yn wakuap nug hap ta'atu­mo­herep ta'atu­mõ­typot hamuat hap. Ta'atue­sokpe i'ywop takat kaipyi — Uito po'og i'atu'e urumohey mono i'atu'e haype. Mi'iria ti ikytyt Tupana ehay ta'atue­watu'e ete i'ewyte ta'atupo poran kai ete iwato'in nakat — Ewei'akasa ro uhowawi uito Tupana ehay kuap hat uito e hamo. I'ewyte ti ta'atuesai'a wato ẽpe ete ta'atuwan yne Tupana wo'onãpin hap — Uito po'og eikai Tupana kuap haria ta'atu'e hap. ");
INSERT INTO mavNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mi'iria ti iky'esat ienuk turan te'era'apyk po'og ta'atu'e hawe irania'in kai morekuat e'amyap ewywuat upi hap. I'ewyte Tupana mõtypot hawe aikotã morekuat eiam ewy ta'atu­ky'esat po'og irania'in kai enoi hamo hap yn ta'atu­ky'esat. ");
INSERT INTO mavNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mi'i hawyi ta'atue­wyry turan — Ihot'ok urumu'e hat koro i'atu'e irania'in hap ta'atu­ky'esat miit'in kaipyi. — Hẽ aimu'e sese hat tut ra'yn e hap ta'atu­ky'esat. ");
INSERT INTO mavNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mi'i pote yt ewetunug nei'o mi'i tã hap i'atu'ewy e Iesui temiit'in me. Katu­pono — Meiẽ aimu'e hat sese yt ewei'e tei'o eiwo'ope ne'i uiwyria'in. Katu­pono wẽtup ok yn ni toĩne'en eimu'e hat sese. Mi'i ti Uito ra'yn are. Waku eweipyhu'at eipe eiwo'o­wyria'in wo yn na'yn katu­pono wẽtup ywania yn aito. ");
INSERT INTO mavNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Katu­pono wẽtup yn Ai'ywot waku ewei'e eiwo'ope. Mi'i ti ahetu­pana sese ewei'e o. Mi'i pote yt naku i ewei'e eimu'e hat pe — En uru'ywot sese yt ewei'e tei'o. ");
INSERT INTO mavNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pyno yt naku i wẽtup ok pe — En Tupana ewei'e uimohey haria eipe pote. Katu­pono Uito yn Eipo­rekuat sese areĩne'en. ");
INSERT INTO mavNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pyno uwe uwe toĩne'en eipy'a­setpe wo'opo­wyro hat po'og po'og eipo­wyro irania'in kai mi'i hat wy ti — Aipo­rekuat sese ewywuat ewei'e o e. Katu­pono po'og aheropat mi'i ewei'e e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma'ato — Uito po'og eikai e hat ti aru Tupana mimohit hat topyhu'at. Irania'in ma'at wẽtup ok tuwe­mohit hat ti aru iwato rakat topyhu'at Tupana mimo­wato wo. ");
INSERT INTO mavNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mi'i hawyi Iesui to'e wo'omu'e haria pe — Ta'i heso rakaria ti eipe typy hẽku rakaria ti eipe are e Tupana ehay kuap ran haria pe. Yt eweiky'esat i ti miit'in tuwat aikope Tupana toĩne'en Morekuat no hap kape e. Ta'i ewei'atu­pyhyp kahato ti miit'in ipap Tupana etawa kapiat rakaria e. I'ewyte ti eipe yt eweiwat teran hin i. Mi'i pote ti irania'in yt tuwat i ei'ewy e. Yt naku i kahato. Yt nakuaria i eipe are. ");
INSERT INTO mavNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","— Ta'i Tupana ehay moherep haria akag ko'i uruto ewei'e eimi­mu'eria ko'i pe. Ta'i uruto yn Tupana e hap yne nug haria ewei'e wen ma'ato pywo ti rat are ehepe Tupana mi'apiheg sese ko'i eipe haria po'og po'og torania kai e. Katu­pono typy hẽku rakaria akag ko'i eipe e. Karãpeĩ ehehay Tupana kape miit'in ehamo ehay se kahato wen ma'ato yt pywo pe i. Ta'i yt Tupana kape hin i ehehay ma'ato eheso hap ewy ehehay e. Miit'in ehamo eipe po'og po'og Tupana emiit no torania kai ma'ato Tupana ehamo po'og yt nakuaria i torania kawiat eweikupte'en e. Katu­pono eimi­mu'eria nãpin hap waku wen ma'ato yt ewetunug hin i ei'e hap eimi­nãpin ewywuat e. Mi'i pote po'og po'og aria mi'u wo eweikupte'en aru torania kawiat e. Are pãi Tupana mõtypot e'at turan Tupana ehay ewei'atumu'e miit'in me ma'ato wãtym i turan hiwu ko'i ma'at'i ma'at'i haria wo eweikupte'en sa'ag e. Ta'i hiwu yat ero'ok haria akag ko'i eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ta'i Tupana mi'apihag wuat'i e'at piaria ti eipe katu­pono typy hẽku rakaria wo'omu'e haria mienoi kuap haria heso rakaria eipe pote e. Yt eweiwat hin i eimienoi upi e. Ta'i eiko­hye­wyry kahato ti miit'in mu'e hamo. Ysakpo yi upi yne mu'ap upi eweikat kahato wẽtup miit wẽtup miit ehay upiat myhu'at hat wyti e. Eweipuẽti hawyi ei'ewy ra'yn ewetunug. Mi'i hawyi ma'ato topyhu'at po'og po'og na'yn sa'ag yianote wuat yt ehehay kuap i te turanuat kai e. Po'og po'og sa'awy'iwuat kai aria kape topyhu'at. Yt naku i kahato e Iesui typy sehay upi enoi haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Uruikuap atipy kapiat mu'ap ewei'e ti eipe wen ma'ato ti yt ihapytig i rakaria ewywuat eipe. Yt eweikuap hin i mu'ap e. — Uruikuap kahato mu'ap Tupana kapiat ewei'e eipot­mu'eria pe yt eweikuap hin i pytkai e. Aikotã yt ihapytig i rakaria yt tikuap hin i mu'ap aikope aikope hap ewy. Karãpeĩ wẽtup ok to'e ehepe — Pywo ti atunug aru ui'e hap ewy to'e hawyi — Eso rat ewei'e tope hawyi — Yt rat yt uheso i rat to'e hawyi — Pyno eso pote waku mio tã ere'e uruwepe — Yt atunug i aru ui'e hap pote waku yne uhekat atum ehowawi Tupana mõtypot yat ekat no waku ere'e miit'in me ta'atukat ky'ewi e Iesui Tupana mõtypot yat apykok haria pe. Eweimohit kahato yt hekat rakaria i'atu­powat'yp Tupana mõtypot yat piat pohari hamo e Iesui Tupana mõtypot yat hekat rakat imehit hap apykok haria pe. Eipy'a pe mio tã e haria eweipyhu'at mekewat mehit rakat mesuwe po'og waku topyhu'at Tupana mõtypot hap kai ewei'e eipy'a pe. Yt naku i kahato ewei'e e. Yt eiwe'eg hin i eipe. Katu­pono Tupana mõtypot yat po'og po'og wo Tupana wanẽtup hawe mekewat mehit rakat pen hap kai e. — Yt uheso i rat ewei'e uruehamo i'ewyte wuat'i miit'in ehamo waku ewei'e eimi­mu'eria pe. — Uheso pote waku uhekat yne iheg me mesuwe Tupana mõtypot yat piat uimi­moheg ko'i uipoi hamuat aru ui'ahu hawyi uhekat sese uhehiwu uimẽpyt'in poi hamuat uiku'uro hawyi waku mi'i uhekat topyhu'at pa'i ko'i wuanuat uheso pote waku ewei'e ro wuat'i miit'in ehamo ewei'e eimi­mu'eria pe i'atuekat yne i'atu­powat'yp i'atu'yi yne hap ky'ewi e. — Waku uipo pyi uhewat'yp eweihep yne yt atunug aru ui'e hap atunug aru e hap ewy hawyi waku ewei'e yne eimima'at ko'i pe e Iesui. Pywo pe are'e ehepe Tupana ehamo yn waku wato'e miit'in me — Atunug aru ui'e hap ewywuat e hap e. Pywo ti rat Tupana ehamo po'og waku wato'e aipy'a pyi atunug aru ai'e hap yt kat i aheso hap wywo e Iesui miit'in powat'yp ekat yne u teran haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yt eiwe'eg hin i ei'e hap upi kat e hap kat e hap ete. Katu­pono Tupana mohey hap po'og po'og Tupana wanẽtup hawe to'yat piat yne ahekat imehit rakat kai. ");
INSERT INTO mavNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","I'ewyte mio tã ewei'e eimi­mu'eria pe — Karãpe wẽtup ok to'e ahepe — Atunug aru ui'e hap ewy mi'i pote waku wato'e tope — Pywo pote — Atunug aru e hap etunug no wuat'i miit'in ehamo Tupana mõtypot yat pe eimiium iwato hap wywo. Mi'i hawyi meremo wuat'i miit'in tikuap ta'yn pywo ewei'e hap — Atunug aru e hap ewei'e eimi­mu'eria pe e. Pyno yt naku i katu­pono po'og waku wato'e — Ui'e hap ewy atunug aru aipy'a pyi ahehay pywo kahato hap wywo Tupana ehamo po'og waku wato'e yt kat hin i aheso hap wywo e Iesui wo'omu'e haria miit'in ekat ky'esat haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yt eheha­pytig hin i rakaria ewy kahato eipe Tupana wanẽtup hawe e Iesui wo'omu'e haria itotiaria pe. Kat som po'og waku watunug hap yt heremo hin i ti ehepe. Miit'in miium Tupana piat kape yn eheha ma'ato Tupana piat mõtypot hap kape yt kat i eheha e. Kat som po'og waku Tupana wanẽtup hawe tomõ­typot hap sio aimiium topiat e. Ta'i tomõ­typot hap po'og waku aimiium kai e. Aimiium Tupana ky'e hap upi yn Tupana mowepit hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mi'i pote karãpe wato'e Tupana pe — Pywo ti aru atunug ui'e hap mi'i pote atum epe uimiium mesuwe eiam yparakai tote mi'i e hap ti waku tutunug e. Ma'ato uwe uwe to'e Tupana pe — Mesuwat uimiium wywo atimoheg neran uhehay uimiium ko'i wato hap ewy mi'i e hap yt he i Tupana wanẽtup hawe. Katu­pono toiky'esat aimiium toky'e hap moherep hamuat hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","I'ewyte karãpe wato'e wuat'i ehamo — Atunug aru ui'e hap ewy pãi an mi'i pote mesuwe Tupana mõtypot yat ehamo are'e hap ewy atunug aru e hap atimoheg uhehay wato'e pote yt iwe'eg i rakat ewy watoĩne'en e. Katu­pono Tupana mõtypot yat yt ahehay kuap i rakat ma'ato Tupana sese ahehay kuap kahato rakat toĩne'en sio aheso ahehay wo sio yt hap toikuap tomõ­typot hap yat pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pywo ti rat karãpeĩ wato'e wuat'i ehamo — Pywo ti rat atunug aru ui'e hap ewy mi'i pote mesup wuat'i atipy piaria ehamo — Atunug aru pãi an are'e mi'i wato'e pote yt aiwe'eg i rakat ewy watoĩne'en. Katu­pono po'og waku aipy'a pyi ahehay pywuat wato'e pywo pe — Atunug aru ui'e hap hawyi waku watunug ma'ato yt watunug i aru e hap watikuap aipy'a pe mi'i pote po'og waku wato'e — Yt atunug i po'og waku — Atunug aru wato'e yt pywo pe i haype e. Katu­pono Tupana tikuap kahato aipy'a piat sio pywo wato'e sio yt e hap. Tupana ti wuat'i atipy piaria nug hat mi'i pote po'og waku ihamo watunug ahehay pywo kahato rakat e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ta'i eipe ti wo'omu'e haria wani wani'e haria Tupana kuasa haria typy hẽku rakaria ti eipe. — Ta'i watum kahato ti wuat'i Tupana kape e haria ti eipe. Eimi'u mosẽ'ẽ hap ko'i wyti eweipat'ok kahato Tupana wanuat i'ewyte ti muse i'ewyte ti eimi'u apopyt ti Tupana wanuat e. I'ewyte ti eipe mekewat eimiium kaipywiat kape ti eiwa­nẽtup kahato at ka'ap e. Mi'i hap ti waku wen ma'ato mi'i tã pote mekewat po'og iwato rakat aimu'e hap kai eweiwaure kahato e. I'ewyte mi'i pote aikotã aru eiminug ko'i Tupana tomo­herep waku hap sio yt naku i hap ei'e hap ti eweiwaure ra'yn e. I'ewyte aikotã Tupana iwese yt nakuaria i ete hap eweiwaure ra'yn e. Mi'i pote Tupana mohey hap kape yt eiwa­nẽtup hin i e. Eweiwaure yne ra'yn — Atunug aru ei'e Tupana piat hap ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ma'ato ti irania'in wo'onãpin hap kurin kat kape po'og ne'i eiwa­nẽtup e. Mi'i ti waku wen ma'ato ti waku yt eweiwaure i mekewat po'og wuat iwato rakat aimu'e hap ko'i e. Ta'i — Atomo­herep teran mu'ap ewei'e ma'ato ti yt eheha­pytig pytkai i e. I'ewyte aikotã mekewat win hin teke ehesapo hy pe mi'i hawyi eweihep meremo — Yt watohon kuap i ewei'e. Ma'ato mekewat aihũ iwato'in nakat kameru ewẽ pe teke hawyi meremo mi'i ewetohon e. Mi'i hap ewy ti eipe. Kurin kat ko'i kape yn eiwa­nẽtup kowo'i kowo'i. Ma'ato aimu'e hap iwato'in rakat kape po'og Tupana wanẽtup hawe yt eweiwa­nẽtup hin i e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Eipe ti yt nakuaria i kahato eipe iwan miat Tupana ehay enoi haria wo'omu'e haria e. Katu­pono yt ewetunug i ti miit'in nãpin ehepiat hap eiwẽ piat e. I'ewyte aikotã kui'a eweikoho iwa pe ma'ato hã'ũmpype ipitpit hap sese. Eweipyi pyi kahato yne kui'a ko'i yne kat ko'i kat ko'i eiam ma'ato hã'ũmpype ipitpit kahato e. Mi'i hap ewy ti eiwa­nẽtup hawe. I'ewyte eipe eiwa pe waku kahato wy. Mi'i hap ewy ti eiwa pe eipainug hap waku kahato ma'ato ehã'ũmpype ti yt nakuap i yn topyhu'at e. — Atima'at irania'in ei'e hap ti eipitpit hamo e. Atiky'esat uiano irania'in ekat ei'e hap ti eimohun hap e. Yt eweiwãi kuap i ti eheko sa'ag ete eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pyno yt eheha­pytig hin i e. Miit'in teha'at ehowawi hawyi ikahu rakaria ewy eweipyhu'at wen ma'ato eipy'a piat ipitpit kahato ra'yn topyhu'at. Ta'i kui'a hã'ũmpype ipitpit hap ewy topyhu'at ehowa ikahu wen. Waku sa'awy'i eipy'a eweikoho yt naku i nug hap ko'i moweityk hamo e. Mi'i hawyi eiminug hap ko'i i'ewyte waku ra'yn topyhu'at e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ahetama puo miit'in tipen wo'osyp hap ikytsig nakano ma'ato hã'ũmpype ti nem na'yn e. Iku'uro rakaria kag yn topyhu'at hã'ũmpype. Ipitpit kahato hap yn topyhu'at itote e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mi'i hap ewy ti eipe eiwa pe eika­huria kahato wakuaria ewy e. Ikahuria kahato mi'iria i'atu'e ehetiat pe e. Ma'ato ehã'ũmpype wyti typy ehay topyhu'at e. — Yt atunug neran i Tupana ehay e hap yn topyhu'at eikai e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ta'i ho'opot haria wo eweikupte'en aru e Iesui wãi'e haria pe wo'omu'e haria pe. I'ewyte ti sa'awy'i­wuaria wo'osyp hap ti ikahu kahato ewetunug Tupana ehay moherep sa'awy'iwuat haria wakuaria wo'osyp hap eweipen kahato ipainug hap imokahu hap. ");
INSERT INTO mavNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ta'i sa'awy'i­te­wuaria nagnia ai'ywania mi'atu'uka ko'i ti mi'iria ewei'e ti e. Ma'ato ti aito koran mi'iria tukupte'en pote — Yt wati'a­tu'uka i ra'yn ewei'e ti e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","— Ta'i ui'ywot'in mi'atu'uka ti mi'iria ma'ato uruto ti yt ra'yn ewei'e eiwo'ope. Mio tã ei'e hap kaipyi uruikuap eipe. Mi'i ei'e hap mipo'o­roria sa'awy'i­wuaria auka haria sa'yru'in ne eipe hap katu­pono — Uru'ywot'in atu'uka haria ei'e hap kaipyi uruikuap. ");
INSERT INTO mavNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pyno ti waku ra'yn eiwe­motag aikotã ei'ywot'in minug sa'ag ko'i ewy e. Katu­pono Tupana mipo'o­roria sa'awy'i­wuaria atu'uka haria saipe­piaria sese te eipe. ");
INSERT INTO mavNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Moi satek mẽpyt'in ewywuaria ti eipe eweikupte'en ti e. Mi'i tupono ti eipe torania aria mi'u wo eweipyhu'at. Yt sake i wyti aru eiwenõ'ẽ kuap e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","— Meiũran aru ati'atu­po'oro ehowawi uhehay moherep haria we'eg haria Tupana ehay kuap haria. Ma'ato ti ipat'ok ti aru ewei'atu'uka ne'i e. Ipat'ok ti aria'yp posak ete ewei'auka e. Ipat'ok ti aru ewei'ahyk ahyk Ehetu­pana mõtypot hawe e. Ipat'ok ti aru ewei'atu­mohan mohan tawa ko'i kape i'atu'uka teran haype e miwan me. ");
INSERT INTO mavNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ta'i sa'awy'iwuat Tupana mi'atu­po'o­roria suu ti topyhu'at kahato ei'ywot'in po ete. Mi'i pote mesup eipe i'ewyte eweikupte'en aikotã sa'awy'ite Kaĩ'in ti'auka toywyt Apeu hap ewy e. Yne sa'awy'iwuat Tupana mi'atu­po'o­roria atu'uka haria te ti eipe e. Sa'awy'iwuat Tupana ehay enoi hat Sakaria mekewat Parakia sa'yru ewei'auka Tupana mõtypot koro wywuat aihũ wuk hawe ewei'auka torania ewei'auka eiperia. Pywo ti torania mi'iria suu topyhu'at eipo ete te e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mi'i pote Tupana mi'apiheg wuaria eweipyhu'at ei'ywot'in apiheg hap ahyt topyhu'at ehepe. ");
INSERT INTO mavNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ieru­sarẽi miaria Tupana mipo'o­roria atu'uka haria kahato ti eipe e. Ati'atu­po'oro kahato ti uhemiit'in eimu'e hamo ma'ato ti yne mi'iria ewei'atu'uka nu wo e Iesui. Mi'i rẽ Uito ti ra'yn meiũ i'atu­saipe kai areĩne'en Uito eipy'a­setpe i ra'yn. Aikotã waipaka ty tomẽpyt'in atukaykay tepiat i'atuky'e haype hap ewy ti Uito woro­ho'o­kaykay e. Eweĩ'ẽ ro uimẽpyt'in are'e ma'ato yt eweikoka'at reran i wyti uhowawi. Uipo­pesap ywyt'okpype ro eweikupte'en are ma'ato yt eweĩ'ẽ teran i e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mi'i tupono ti aru ei'yat ikahu rakat ko'i pyi eiwenõ'ẽ. Yt uwe i topyhu'at aru itote e. ");
INSERT INTO mavNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mio Uito i'ewyte arẽtem na'yn eipy'a­setpyi Ieru­sarẽi miaria. Mi'i hawyi ti aru yt karãmuo i ra'yn ewei'akasa uhowawi. Yt uwe i ra'yn — Ereke ro e haria uhepiat pote. Areĩne'en mot'i eikai ma'ato meiũran — Era'aipok i ro ereke mono ewei'e pote waku kahato ti En Tupana Mipo'oro sese ti En ewei'e uhepe pote ti aru ariot i ma'ato ehowawi i ra'yn e Iesui wo'omu'e haria pe. Uito Mateu atiwan yne mesuwe are. ");
INSERT INTO mavNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesui tuwẽtem Tupana mõtypot yat pyi hawyi ipotmu'eria tõ'ẽ howawi te'ero'e hamo — Mehĩ uruimo­herep teran meiẽwat Tupana mõtypot yat nu kawiat iwato rakat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","— Ta'i iwato kahato ti nu kawiat to'otote tote rakat iwato'in nakaria e Iesui. Ma'ato ti are'e ehepe pywo pe ti meiũran ti aru to'otiat to'otiat rakaria yt wẽtup i topyhu'at e. Meiũran ti aru wanĩ­kaptia hytpok yne nu wato ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mi'i hawyi toto Uriweira ypia eyity'ok kape. Mi'i itote ta'apyk hawyi ipotmu'eria tõ'ẽ howawi 12 ok takaria. Mi'i hawyi apo'i'atu'e Iesui pe — Karãpe aru ta'atu­pugha meiẽwat Tupana mõtypot yat i'atu'e. Karãmuo aru put'ok'e e'aipok mesuwat yi kapiat hap e'at i'atu'e. Karãpe aru yi kahuro hap put'ok'e i'atu'e. Kat ko'i kat ko'i aru tuwe­mo­herep mesuwe put'ok'e hap e'yianmete i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","— Pyno eiwe'eg wo o uiwyria'in katu­pono tõ'ẽ tõ'ẽ kahato ti aru eima'at reran haria e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Uhet ero'ok hap kaipyi ti aru mio tã i'atu'e — Uito ti Tupana mipo'oro eipo­rekuat nuat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","He'at ete i ti aru aikotã aikotã ne'i eweikuap wuat'i kaipyi wo'o'auka hap wu'uka hap ti aru eweikuap yne tama kaipyi e. Pyno mekewat sehay eweikuap hawyi o yt eiwa­nẽtup tei'o gyt'ei'e hamuat hap kape ne'i e. Katu­pono pywo ti aru put'ok'e he'at mi'i tã hamuat hap e. Ta'i mi'i hap ti eipy'a­setpe eweikuap yne hamo e. Ma'ato ti aru yt he'at ete i te wyti e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mi'i turan ti aru wẽtup ok wẽtup ok more­kuaria emiit'in ti aru tu'uka tu'uka to'ope to'ope yi wato hap ok tã e. Mekewat e'at pe ti aru yt kat i hin i mi'u topyhu'at mesu­wa­rote e. I'ewyte ti aru yi tyry'e kahato mekewat e'at pe aikope aikope wẽtup tawa pe wẽtup tawa pe tyry'e e. Mi'i hawyi ti aru tõ'ẽ tõ'ẽ kahato wẽki'a sari nupi'a ape'i ko'i aiko u hamuat. Mi'i hawyi yt kat i mi'u topyhu'at e. Mi'i hawyi topap kahato miit'in sy'at pyno. ");
INSERT INTO mavNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mi'i hap ko'i ti aru pyno ha'awynug hap ta'yn wyti mi'i tã ta'atunug ta'yn e. Ma'ato ti yt ho'opot hap sese i te e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mi'i hawyi ti aru eima'at haria ehum na'yn ho'opot hamuat hawe ei'auka hamuat kape e. Mekewat e'at pe ti aru yne i'atu­py'ahak ehete. Yt i'atu­wese o ehete are katu­pono eipe uimohey haria pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ta'i mekewat e'at pe ti aru ipoity'i kahato sa'awy'iwuat uimohey haria ma'ato ti aru wemõti uipupiat haria e. Mi'i hawyi ti aru eiwo'o'atoiat atoiat wyti aru. Mekewat e'at pe eweikupte'en eiwo'ope are ma'ato ti yt yne i ti aru ma'ato e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mi'i hawyi ti aru wẽtup ok tuwe­mo­wato — Uito ti meiũ Tupana mipo'oro tehay enoi hanuat e ti aru aikowo aikowo tuwe­mo­wato ma'ato ti aru yt pywo pe ti aru e. I'atu kahato ti aru mio tã e haria e. I'ewyte ipotmu'eria ti aru i'atu kahato e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mi'i hawyi po'og na'yn yt naku i nug hap ko'i topyhu'at mesu­wa­rotiat. Mi'i tupono irania'in uimohey haria sa'awy'i uiky'e haria wo'owese haria wyti aru ira'ak takaria iperup takaria te'ero­pyhu'at. Yt ta'atu­ky'esat i po'og uiky'e hap kai. Katu­pono sa'ag nug hap yn ta'atu­ky'esat irane e. Mi'i hawyi ti aru yt uiky'e i i'ewyte yt irania'in ky'e i haria te'ero­pyhu'at e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma'ato uwe yt ipun i uiky'e hap at ka'ap mekewat e'at kape mi'i haria ti aru te'ero­pyhu'at uimie­ha­kyera'at ko'i wuat e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mekewat e'at pe ti aru uhehay wakuat aikotã Tupana topyhu'at Morekuat no wuat'i miit'in muo yi wato hap ok tã tuwe­mo­herep eimi­mu'eria pe. Mi'i hap kaipyi ti aru yne ywania tikuap ta'yn uhetiat e. Mi'i hap ko'i toran na'yn hawyi ti aru he'at sese ra'yn put'ok'e e. Mi'i ti aru ikahuro hap e'at sese ra'yn e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Aikotã sa'awy'iwuat Tupana ehay moherep hat Tanieu e hap ewy put'ok'e ra'yn mio tã e hap — Meiũran ti aru tuwe­mopoĩ'ãm Tupana mõtypot yat wato pe po'og yt nakuat i wuat'i kawiat rakat — Uito ti Tupana to'e hat e. Eweikuap to kat som Tupana ihay mesuwat iwan me e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mekewat yt nakuat i sese wemopoĩ'ãm hat ewei'akasa ra'yn hawyi o eiko­hyeput ra'yn yi Iuteu pyi yity'ok ko'i kape e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Eihyha ra'yn o. Yt ewei'aipok i ra'yn o ei'yat kape ehekare'en sat hamo. Yt pya i ei'yat kai eweikupte'en wen ma'ato o yt era'aipok i ra'yn ei'yat kape. Eiko­hyeput yity'ok ko'i kape yn na'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ta'i eipotpap eiko etiat ko'i turanuat pote o yt ewei'aipok i ra'yn ei'yat kape ehesokpe pag hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ta'i mekewat e'at pe ti aru niatpo kahato imẽpyt rakat ete hupi'a rakat ete e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pyno o ewehẽtup Tupana pe — Yt etipo'oro tei'o uruepiat ho'opot hap e'at i'aman mot e'at pe waku ewehẽtup. I'ewyte yt etipo'oro tei'o uruepiat ho'opot hap e'at emõtypot hap e'at pe katu­pono yt uruko­hyeput kuap i mekewat e'at ewei'e o Tupana pe. ");
INSERT INTO mavNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mi'i hawyi ti aru po'og po'og topyhu'at ho'opot hap wuat'i e'at piat kai e. Ta'i mekewat e'at pe ti aru po'og satek hap e'at Tupana piat yi nug sa'awy'ite hap ok tã mesup ahe'at kape e. Ma'ato mekewat ho'opot hap e'at tokosap ta'yn hawyi ti aru yt kat i ira'yn i'ok tã nakat ho'opot hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pyno mekewat e'at pe ti aru iwato kahato hamuat ho'opot hap topyhu'at e. Mi'i hap ti aru Tupana timõ­pytu'u e. Ma'ato yt toimõ­pytu'u i mekewat pote ti topap yne miit'in e. Mi'i tupono ti tomiky'e tomi'ai­roria etiano yn toimõ­pytu'u e. Yt toiky'esat i tomohey haria topap hap haype e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ma'ato mekewat e'at tokosap ta'yn hawyi ti aru te'ero'e irania'in ehepe — Meiẽ put'ok'e ra'yn Tupana mipo'oro aipo­rekuat nuat i'atu'e ti aru ma'ato o yt ewei'atu­mohey tei'o eima'at hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta'i — Eheso i rat ewei'e yn o are katu­pono Tupana mipo'oro eipo­rekuat nuat ra'yn uruto e haria ti aru te'eru­we­mo­herep e. I'ewyte — Tupana mipo'oro tehay enoi hamuat ko'i ti uruto ti i'atu'e yt pywo pe i e. Mi'iria ti aru ta'atu­mi­sepap iwato kahato inug wy miit'in miat ta'atuehay mohey hamuat e. Meremo ti aru iwato kahato atipy kaipywiat ewy e. Ma'ato mi'iria miit'in ma'at hamuat haria e. I'ewyte ti Tupana mi'airoria imohey sese haria ma'at reran haype e. Ma'ato ti aru porap ta'atuma'at ma'ato yt e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pyno eiwe'eg wo o mi'iria pupi katu­pono ahenoi ra'yn yianmete ra'yn i'atuetiat e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mio tã i'atu'e ti aru — Yahig kape iuẽpe ra'yn ti tuwe­mo­herep Tupana mipo'oro aipo­rekuat nuat i'atu'e ti aru ehepe pote yt eweiwat rei'o mi'iria eima'at teran haria upi are'e. — Ta'i toĩne'en ni iheg me pote eweiwat hawyi ti aru uruimo­herep ehowawi i'atu'e ti mi'iria e. — Pãi an yt uruho'o­mohey hin i ti ewei'e o are e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Katu­pono Uito Eheyke'et sese ti aru ariot turan wuat'i miit'in ui'akasa hamuat ariot e. Mi'i ti aru aikotã merep'e hap ewy aremo­herep wuat'i puo e. Pyno aikotã wãtym muo merep'e hap ewy yn tuwe­mo­herep Eheyke'et e. Mi'i ti aru heremo yne at wẽtem hap totepyi yne at min'e hap kape e. Ta'i mi'i hap ewy ti aru ara'aipok e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Aikotã i'okpuk kape Urupu ko'i tõ'ẽ tõ'ẽ hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mi'i hawyi mekewat e'at tokosap ta'yn ho'opot hap hawyi ti aru at i'ypyryp ta'yn i'ewyte waty i'ypyryp ta'yn i'ewyte ti aru waikiru hewo hewo teiam myi e. I'ewyte atipy ti aru mi'i turan yt iheg i ra'yn huruk'e ra'yn e. Mi'i hap e'at turan ti aru tuwe­mo­herep ta'yn Uito Eheyke'et atipy kaipyi wuat'i te'era'a­kasa hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mi'i hawyi yne ywania miit'in to'okak'i katu­pono Eheyke'et ut hap e'at pe ti heremo ywyhig muo meremo tut e. Yne ti aru te'era'a­kasa mi'i tesaika wuat hut hap kape e. Tomõ­typot hawiat hut hap e'at kape meremo tut e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mi'i hawyi ti aru temiit'in atipy piaria toi'atu­po'oro huhu'i'atu'e hamo e. Mi'i hawyi ti ta'atu'a­tunug tuwe­wawi tomi'ai­roria e. Ta'atu'a­tunug ni aru aikope pyi aikope pyi wasere tut hap kaipyi at wẽtem hap kaipyi at min'e hap kaipyi yne yne kaipyi ta'atu'a­tunug imi'airoria howawi yi sasat hap kaipyi aikope aikope miit'in tukupte'en hap kaipyi. ");
INSERT INTO mavNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Pyno eweikuap ta'yn Wiku yp ete. Wiku i'yhop kyt hap kaipyi eweikuap ta'yn merep hamuat ra'yn haat hap e'at yt pya hin i ra'yn hap. ");
INSERT INTO mavNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mi'i hap ewy ti aru karãpe ewei'akasa yne ra'yn ui'e hap ko'i hawyi eweikuap ta'yn yt pya i ra'yn oken'ypy kapiat uhut hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mekewat e'at piat ieĩne'en haria te'era'a­kasa yne wyti aru ui'e hap ewy. Ta'atuieĩne'en ne turanuat yt ta'atu­ku'uro i te turanuat tote te'era'a­kasa. ");
INSERT INTO mavNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pyno waikiru at yi tuweityk yne ma'ato uiat uimienoi uhehay yt sake i tuweityk e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yt uwe i ti uhut hap kuap uhut hap e'at kat ewãtym uhut hap kuap hat yt uwe i pãi e. Ta'i Uito yt atikuap i wy. Yi totiaria atipy piaria i'ewyte yt uwe i ti ikuap e. Ma'ato wẽtup yn ikuap hat pãi. Ui'ywot atipy piat yn ikuap karãpe aru ara'aipok meikowo hap e'at e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sa'awy'i te aha'ase'i Nu'e e'at pe hap ewywuat tukupte'en aru miit'in uhut hap e'at pe turan e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mi'i hap e'at pe iwato kahato ienuk hap itote. Wuat'i ta'atu'u sapo mi'u to'okyi'at kyi'at itote e. Mi'i pytkai Nu'e teke ra'yn yara wato tominug me. ");
INSERT INTO mavNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Iheg nakat pe hawyi meremo i'aman kahato ra'yn sa'awy'iwuat yt ewywuat i ra'yn. Ta'i mi'i ti yi ãpymin hamuat ra'yn i'aman wato. Mi'i hawyi yt kat i yi heremo rakat. Y'y yn na'yn topyhu'at yi tote hawyi topap topap kahato yne yi totiaria katu­pono yt ta'atu­mohey hin i ma'ato Nu'e'in yt topap i. Ta'i mekewat turanuat ewy te irane ti Eheyke'et ut hap e'at turan e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mi'i turan ti aru typy ok Tupana tipuẽti ta'atuko tote. Mi'iria ti aru wẽtup ok totioto hawyi wẽtup ok topyhu'at aru e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","I'ewyte ti aru hary­poria'in typy ok mani pe wat haria mi'iria toi'atu­puẽti. Mi'iria ti aru wẽtup ok totioto ma'ato wẽtup ok tuweran topyhu'at aru pãi e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mi'i tupono o eiwe'eg wo o katu­pono yt eweikuap i kat e'at put'ok'e Eheyke'et hap e. Seha'at uhut hap kapiat hap ewy o eweikupte'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pyno eweikuap o uhã'ãkap e. Sa'awy'i so toĩne'en hekat rakat to'yat ikahu rakat pe ma'ato meiũran wãtym muo put'ok'e sero'ok'e hat hawyi totero'ok yne hekare'en iket kai e. Ma'ato toikuap hut hap pote yt toket i e. Mi'i hap ewy ti are'e ehepe. ");
INSERT INTO mavNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mi'i tupono o eiwe'eg wo o uhut hap kape e. Katu­pono ti sero'ok'e hat ewy ti aru Eheyke'et tut e. Yt uwe mikuap mo i put'ok'e Eheyke'et aikotã sero'ok'e hanuat ewy put'ok'e hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Uwe uwe som pyno topyhu'at uhemiit sese meiũpiat ipotpap pot'i rakat iwe'eg kahato hat. Pyno uwe ewywuat mi'i ahenoi teran. Mi'i ti toka'iwat aipok i hap ekatup hat — Tut ti aru uika'iwat e yn hat ewy — Mi'i pote waku ati'atupoi wuat'i e'at pe hemiit'in mi'u wo e. Waku i'atue­hãite yn put'ok'e turan e. I'ewyte waku pe yn i'yat hut turan toka'iwat ut hap e'at ekatup hat e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mi'i tã nug hat wyti aru iwepit kahato toka'iwat put'ok'e turan katu­pono wakuap nug turan ika'iwat tipuẽti tut turan. ");
INSERT INTO mavNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mi'i hat pe ti aru — Pyno woronug en yne uhekare'en ko'i apykok hamo e inug hat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma'ato irania'in wyti aru — Ta'i yt tut i ra'yn i'atu'e. Mi'i turan ti aru put'ok'e e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mi'i haype ti aru ta'atu'ahyk ahyk ne'i ta'atu­ka'iwat emiit'in ko'i. Mi'i haype ti aru mi'i tã e haria te'eru­wemo'ok kahato hemiit'in mi'u wo mahy wo iwat hemiit'in hesy'at turan. ");
INSERT INTO mavNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mi'iria ti aru yt i'atuwe'eg wuat turan hin i put'ok'e e. ");
INSERT INTO mavNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mi'i hat ete put'ok'e hawyi haiwot kahato. Mi'i hawyi ti aru tutum surara'in me — Eweiku'iku'i ro meimẽwat yt we'eg i kahato hat e ti aru put'okto'e hawyi. Mi'i hawyi ti aru typy ihay rakaria eiam me ra'yn tohytmoi aikope miit'in te'eruwak kyry'et kyry'et'i'atu'e ta'atuiãi ete hap kape ra'yn aru toi'atu­hytmoi e Iesui. Mi'i tã hap ewy Iesui tohenoi sa'awy'i. Mi'i hawyi Uito Mateu atiwan mesuwe uimikuap ok tã. ");
INSERT INTO mavNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mi'i hawyi po'og Iesui henoi aikotã Tupana topyhu'at aru Aipo­rekuat nuat. — Mi'i hap ewy ti aru topyhu'at e Iesui aikotã ahetama puo hary­poria'in 10 ok yt se'aito i te rakaria tuwat ta'atue'a­riãty wywo wãtym muo ta'atuwy'ok e'aito wuat erut hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ipat'ok 5 ok takaria hepap takaria katu­pono mi'iria i'atue'a­riãty ipyt'at kahato rakaria tuwat e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ma'ato irania'in 5 ok takaria e'ariãty ti yt ipyt'at rakaria i e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ta'i ipat'ok iwe'eg nakaria i'atue'a­riãty heiam howapy ta'atuerut ma'ato irania'in yt. Mi'i turan i'atuwy'ok he'aito wuat yt tut i te. Mi'i pote ti ta'atu­he­katup ta'yn wãtym ka'ap kape ta'atu­he­katup ta'atuwy'ok e'aito wuat. ");
INSERT INTO mavNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Heniatpo poity'i ra'yn mote i'atuket'at ra'yn. Mi'i hawyi i'atuket ahy ahy ra'yn mu'ap ẽpe upi mekewat wãtym hake turanuat hekatup haria yne yt hut i te pote. ");
INSERT INTO mavNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mi'i turan wãtym hake turan miit'in te'eru­watka ta'atuehay pirik wo — Meipe ra'yn tut i'atu'e. Eweiwat ro he'aito wuat kape ehe'ariãty wywo ipu'ap moherep hamo i'atu'e. Mi'i hawyi eweterut ro ihary'i wuat kape i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mi'i pote ti te'ere­hymut i'atupoĩ'ãm 10 ok takaria he'aito wuat ekatup haria. Mi'i hawyi ta'atunug hãpyk kahato yne ta'atue'a­riãty iun ko'i. ");
INSERT INTO mavNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma'ato irania'in — Eweho'o­puru uruepe ehe'ariãty hy i'atu'e kat pote uruket kai sio hasep urue'ariãty hy kahuro pote i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","U an yt ra'yn i'atu'e ma'ato uruho'oium urue'ariãty uruwat hy pote uruwat mu'ap upiat hamo yt put'ok'e i ra'yn i'atu'e. Eweiwat ro ihy weneru haria kape mi'i hawyi eweikyi'at ro eiwano ehe'ariãty hy wo i'atu'e 5 ok takaria ẽtup haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mi'i hawyi tuwat ra'yn ariãty hy kyi'at hamo ma'ato mi'i pytkai ti irania'in tuwat ra'yn he'aito wywuat kape. Mi'i hawyi tuwehyt'ok ta'yn wo'okyi'at hap yat kape. Mi'i hawyi he'aito wuat he'okenhyp ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mi'i hawyi wãtym mot'i pe ra'yn put'ok'i'atu'e irania'in 5 ok takaria ariãty hy so'okyi'at hamuat aipok haria. Mi'i hawyi te'eru­wẽ­powat — Mimi mimi eho'okenhyp'ok to e'yat uruepe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma'ato — Yt woro­ho'okuap i eipe mana'in e i'atue'a­riãty hy yt put'ok'e i rakaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pyno mi'i hap ewy o eiwe'eg wo o eweikupte'en uhut hap ekatup haype. Katu­pono yt eweikuap i Eheyke'et ut hamuat kat e'at pe sio wãtym i sio atpo­sake sio wãtym hake e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mi'i hawyi wẽtup sehay iã'ãkap i ra'yn tohenoi. — Sa'awy'i so wẽtup ok miit toto teran pya wuat setama kape e. Ma'ato toto hap owakai toi'atu­kaykay tuwe­wawi yne temiit'in. Mi'i hawyi toi'atu­puru porap'i teti­neiru i'ewyte te tekat ko'i toho'oium i'atuepe toto hamuat haype. ");
INSERT INTO mavNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wẽtup ok pe tutum iheg nakaria Uru kawiat hekat kahato 5 saka howapy ra'yn tutum sa'awy'iwuat pe. Mi'i hawyi wẽtup ok pe ti tutum typy esaka Uru wywuat hap ko'i tutum. Wẽtup ok pe ti tutum wẽtup saka yn aikotã i'atuepiat hepap hap ok tã tutum tekat i'atuepe. Toiky'esat kahato po'og i'atuepiat imowato teti­neiru hap toiky'esat. Mi'i hawyi wẽtup tama kape ra'yn toto e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mi'i hawyi mekewat 5 saka wywuat myhu'at hat ti ipotpap kahato ra'yn aikotã aikotã tuwe'eg hap ewy tutunug. Mi'i ti toimo­wato kahato toka'iwat etineiru i'ok tã ne toiwy'inug. Mi'i hawyi 10 saka ra'yn topyhu'at. ");
INSERT INTO mavNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mi'i hawyi i'ewyte wẽtup ok typy saka rakat kaipyi toipuẽti 4 saka i'ok tã ne toimo­wato. ");
INSERT INTO mavNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma'ato mekewat wẽtup esaka wywuat ti yt toto i topotpap hamo yt toimo­wato i toka'iwat miium ma'ato toi'asyp yi pe. Tote­rowyi ne'i miit'in mupi. ");
INSERT INTO mavNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mi'i turan i'atu­ka'iwat ti toto pot'i tewyry hamo. Ma'ato meiũran hawyi tut i ra'yn. Tewyry hap kaipyi put'okto'e hawyi temiit'in mye'ym ok takaria toi'atu­kaykay i ra'yn tuwe­wawi mekewat teti­neiru wywuat gupte'en haria. ");
INSERT INTO mavNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sa'awy'iwuat 5 saka sat hat ri put'ok'e hawyi to'e — Uhyt e po'og na'yn ti mekewat emiium 5 saka rakat kaipyi atipuẽti 10 ra'yn nyti uika'iwat e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","— Pyno waku kahato en. Ehepap kahato ti e. Yt uima'at hin i e. Pyno en wakuat kahato. Mi'i tupono meiũran ti aru po'og uhekare'en apykok hamo ra'yn woro­po­rokpun e. Mi'i tupono koitywy uhekare'en epo pe e. Katu­pono mio po'og na'yn woro­mohey en e. Pyno koitywy to'iro watunug emowepit hap. Katu­pono koitywy uheka­tuwy wo kahato ra'yn en e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mi'i hawyi wẽtup ok i typy saka rakat wywuat myhu'at hat put'ok'e hawyi to'e — Uika'iwat e sa'awy'i ti etum typy saka etineiru uhepe e. Pyno koitywy ti ma'ato po'og na'yn emiium typy saka rakat kaipyi katu­pono ti 4 saka ra'yn ti toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mi'i hat pe ika'iwat to'e — Pyno waku kahato en e. Pyno en motpap kahato rakat en e. Yt uima'at hin hat i e. Katu­pono uimi'atoiat epo piat etimo­wato kahato ra'yn. Pyno po'og na'yn typy saka kai iwato e. Mi'i tupono waku woronug en uhekare'en apykok hano ra'yn e. Koitywy to'iro watu­wehyt'ok aiwo'o­mo­wepit hamo. Katu­pono koitywy ti uheka­tuwy kahato wo ra'yn en e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mi'i hawyi wẽtup saka wywuat myhu'at hat i ra'yn put'ok'e. Mi'i hawyi to'e — Uika'iwat ta'i niatpo poity'i ti atipuẽti ewawiat uipotpap hap e. Katu­pono worokuap kahato en yt hegyi'at rakat i aikotã yt ewat i emikoi terek hat ewy ereĩne'en. ");
INSERT INTO mavNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pyno ti worokuap kahato ra'yn en e. Pyno ti areken'ẽ kahato ra'yn epupi e. Mi'i pote mekewat etineiru wẽtup esaka rakat ati'asyp yi pe sero'ok'e hat pupi e. Pyno ti ga'atpo ti atihep ta'yn etineiru uhyt e. Koitywy atum i epe emiium uhepiat hap ok tã. ");
INSERT INTO mavNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mi'i hawyi ipy'ahak ika'iwat mi'i hawyi to'e haty wo — Eperup kahato rat motpap pupi e. Ereken'ẽ kahato yt uhegyi'at i hap uheti­neiru mowato hamuat pupi e. — Mikoi terek hat hap niatpo poity'i e hat ne'i en ere uhepe. Uimikoi puruk hat ne'i en ere uhepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kat poteĩ uheti­neiru yt etipuru i irania'in me iwy'inug hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mi'i hawyi irania'in temiit'in me — Pyno eweihep to mekewat yt we'eg i hat po pyi imisyp hawyi ewetum no mekewat 10 saka puẽti hat pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mi'i hap ewy ti aru Tupana tikuap topotpap nug haria sese e Iesui. Uwe uwe Tupana miium imowato mi'i hat ti aru topyhu'at Tupana ekat mõ'ẽ kahato rakat no. Hekat rakano ewy tapyhu'at katu­pono mi'i hat pe Tupana tum kuap po'og po'og tomi­mohey po pe. Ma'ato irania'in mekewat imiium yt mowato i haria po pyi ti aru tomiium toi'atu­po­hari yne. Mi'i hawyi yt kat i topyhu'at mio tã haria po pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Waku pyno mekewat uimiium syp hat yt we'eg i hat etipugha ro i'ypyryp kape ui'yat pyi. Aikope i'atu­wo'okak'i hap kape aikope ta'atuiãi ete kyry'et kyry'et'i'atu'e hap kape e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Meiũran ti aru put'ok'are Uito Eheyke'et Morekuat koro wuat mesuwat yi tote wo'omõ­typot kahato hawe wuat'i e'at piat kahato rakat hẽtyhot kahato hawe. Atipy piaria torania wakuaria wywo ariot e. Mi'i hawyi ti aru ara'apyk morekuat eiam note ra'yn e. Uheiam note wuat'i puat uimõ­typot hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mi'i hawyi ti aru mi'i eiam kape ati'atu­kaykay ra'yn uhowawi torania ywania. Mi'iria ti aru aikotã aihũria to'opype pype areĩne'en hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mi'i hawyi ti aru ati'airo ra'yn uiwaria sese ko'i kokai uipo sese kawiano ra'yn katu­pono mi'iria wakuaria ra'yn e. Ma'ato mekewat yt nakuaria i ti aru kowo uipo ran kai ra'yn ati'atunug e. Mi'i hawyi ti aru uipo ran kai aikotã hũria Kapi­ritu ko'i ewy tukupte'en ma'ato uipo sese kai ti aru meimuẽwat Uweuria ko'i ewywuat ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mi'i hawyi itote uipo sese kawiat pe are'e — Eweĩ'ẽ ro meikowo Ui'ywot mi'atuky'e ko'i e. Atum neran ti Tupana etama ehepe e. Katu­pono yi nug hawyi te ti mekewat atum teran kahato ehepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Katu­pono sa'awy'i uhesy'at kahato turan ti ewetum eimi'u uhepe e. I'ewyte are'y'utui kahato turan ewetum uhepe y'y uiwe'y'u hamo e. I'ewyte yt uikuap pytkai i ti — Ereke ro ereĩne'en mesuwe Uhyt Mimi ewei'e uhepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","I'ewyte yt uhesokpe hin turan i kue eweho'oium uhepe ehesokpe e. I'ewyte kue ui'ahu turan uipo­wyro eipe e. I'ewyte kue uipyhik piat areĩne'en turan eipe ehehay uiwywuat eweĩ'ẽ uhowawi e. Ta'i mio tã are ti aru uipo sese ko'i kawiat pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mio tã are'e pote uipo sese kawiaria te'ero'e — Karãpeĩ esy'at turan uruipuẽti hawyi uruipoi En i'atu'e ti aru. Karãpeĩ ere'y'u teran turan uruipuẽti hawyi uruho'oium epe Uhyt Mimi i'atu'e irane. ");
INSERT INTO mavNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","— Karãpeĩ ereke o uruto'e epe yt ekuap i pytkai sio yt hesokpe i rakano ereĩne'en turan uruho'oium sokpe epe i'atu'e uhepe. ");
INSERT INTO mavNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","I'ewyte urutuwat wo'opyhik hap kape turan wepyhik haria wywo ehay hamo i'atu­po­wyro hamo yt uruta'a­kasa hin i En i'atu'e irane uhepe uipo sese kawiaria. ");
INSERT INTO mavNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mi'i hawyi Uito i'atuPo­rekuat ti'atu­wesat — Yt uhepe i ma'ato uhemiit'in ihaky'e'i rakaria yt iwy rakaria i powyro haria ti eipe. Ma'ato i'ewyte uipo­wyro haria eipe yt eweikuap i pytkai are aru i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ma'ato irania'in uipo ran kawiaria pe ti aru are'e — Eweiwat ro ui'yaty­pepyi Tupana mi'uhu ko'i wyti eipe. Eiwehyt'ok to aikope aria yt hasep i rakat pe Tupana minug ho'opot hamuat hap kape ahiag toĩne'en hap kape. Aikope atipy piaria haiwot rakaria tukupte'en hap kape are ti aru uipo ran kawiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Katu­pono sa'awy'i areĩne'en eipy'a­setpiat turan uhesy'at kahato hap wywo areine'en ma'ato yt uipoi hin i eipe eimi'u wo e. Uiwe'y'utui kahato turan eipe yt uimõ'ẽ y'y hin i uhepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","I'ewyte yt uwe piat i uikuap turan — Ereke ro Mimi Uhyt yt ewei'e hin i uhepe. I'ewyte areĩne'en eitokpe yt uhesokpe hin wywo i. Mi'i turan yt ewetum hin i uhepe sokpe. Ui'ahu turan uipyhik piat turan yt eweĩ'ẽ hin i uimo­wepit hamo uipo­wyro hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mi'i hawyi ti aru pyno apo'i'atu'e mi'iria uhepe — Karãpeĩ mi'i tã Mimi Uhyt i'atu'e. Karãpeĩ ereĩne'en uruwywo yt i'yat rakano i yt esokpe rakano i i'ahu rakano epyhik pe ereĩne'en rakano. Karãpeĩ yt kat i i uruipome'eg epe apo'i'atu'e aru uhepe. ");
INSERT INTO mavNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mi'i hawyi ti aru ati'atu­wesat — Ta'i ha'awyte ti uimohey haria yt i'atu'yat i eipy'a­setpiat turan wyti i'ewyte i'atu­pyhik piat turan i'atu­we'y'utui turan i'atuesy'at turan i'atu'ahu turan ha'awyte yt ewei'atu­po­wyro hin i mi'iria uimohey haria ihaky'e'i rakaria e. Mi'i hap e'at pe ti i'ewyte yt uipo­wyro hin i are aru uipo ran kawiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mio tã are hawyi ti mi'iria tuwehyt'ok ta'yn ho'opot at ka'ap hap kape. Irania'in waku nug uhepiat haria uhemiit pome'eg haria tuwehyt'ok aru wuat'i e'at piat ieĩne'en hap sese kape e Iesui ahepe topot­mu'eria pe Uriweira ypia yity'ok tote. Mi'i hawyi Uito Mateu atiwan mesuwe are. ");
INSERT INTO mavNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesui ti'atumu'e yne ra'yn hawyi to'e topot­mu'eria pe ");
INSERT INTO mavNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","— Mũki'ite e'ihot'ok hawyi ai'ywa­niaria tuwat ra'yn yne ienuk hap nug hamo mekewat ahewa­nĩ­kaptia sa'awy'iwuat Esitu'in miaria po pywiat ho'opot hap kaipywiat ahenõ'ẽ hap kapiat watetup hap e'at ta'atunug irane hamo tuwat itote e. Pyno to'iro uhowawi e katu­pono Eheyke'et auka hamuat e'at put'ok'e ra'yn e. Uhewa­nĩ­kaptia po pe ui'auka aria'yp posak etiat hamuat e'at put'ok'e ra'yn e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mi'i turan pa'i ko'i te'eru­wa'a­tunug na'yn. Wẽtup ok pa'i po'og iwato rakat Ka'iwa e hap hat rakat yat pe te'eru­wa'a­tunug. Pyno yne yne tõ'ẽ tõ'ẽ pa'i kororia irania'in wywo. ");
INSERT INTO mavNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mi'i hap tote to'oehay to'ope to'ope aikotã Iesui waku ta'atu­pytyk hawyi ta'atu'auka yt uwe mikuap mo i ti e hap ete to'oehay to'oehay. ");
INSERT INTO mavNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yt naku i o som wato­pytyk ahenuk koro hap e'at pe i'atu'e. Yt naku i o som sehamo wato­pytyk i'atu'e katu­pono mi'i pote wo'o'auka hap ne'i topyhu'at miit'in sem e hap tote i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mi'i hawyi Iesui put'ok'e tawa Petania pe temiit'in nywo. Mi'i hawyi tuwehyt'ok Simãu yat pe sa'awy'i­tewuat hepihi pihi rakat yat pe. ");
INSERT INTO mavNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Itotiat i'atuenuk turan wẽtup ok hary­poria tut mohag hy ikap takat hekat rakat mohag hy wywo. Heiam nu Arapatu kawiat wywo ikahu kahato rakat i'ewyte ihy ikamhig se kahato rakat wywo. Mi'i hawyi put'okto'e hawyi toi'okpun yne Iesui asap ete henuk turan. ");
INSERT INTO mavNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mi'i tã hary­poria tunug pote hemiit'in yt i'atu­wese i hary­poria minug hap ete. Yt kan hamo i toi'okpun i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Waku po'og mi'i wati­we­neru hawyi watum ha'up yt hekat i rakaria pe i'atu'e. Yt kat hamo hin i wyti saĩke toi'okpun howoity rakat saĩke i'atu'e. Waku ti saĩke wati­we­neru mi'i hawyi ha'up iwato'in nakat watum yt hekat i rakaria pe i'atu'e to'ope hemiit'in. ");
INSERT INTO mavNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mio tã i'atu'e hap Iesui tikuap hawyi to'e i'atuepe — Yt eipy'ahak tei'o mana ete katu­pono wakuap ti uhepe tutunug e. Mi'i tupono eiwẽ­pohep to mi'i hap ete e. Katu­pono ti ikahu kahato ti iminug atipuẽti e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Katu­pono yt hekat i rakaria i ti aru tukupte'en wuat'i e'at pe mesuwat yi tote eiwywo eimi­po­wyro ko'i wuat ma'ato Uito aru yt mot'i areĩne'en eipy'a­setpe e temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aikotã ai'ywania tikã'ã iku'uro rakat mohag ikap takat wywo hap ewy ti meiũwat hary­poria tunug uhete uiku'uro hap e'yianmete e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mi'i tupono are'e pywo ti aru meiũran wuat'i yi wato hap ok tã aikotã hary­poria minug waku uhetiat hap ta'atu­henoi henoi e. Wuat'i ywania ti aru ikuap wakuap uhetiat iminug hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mi'i hawyi wẽtup hemiit 12 ok hap Iuta Ikarioti sa'yru toto ra'yn pa'i kororia kape. ");
INSERT INTO mavNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Mi'i hawyi — Kat aru Iesui puẽti hap sa'up ewetum uhepe ahenoi ehepiat ipytyk hap pote e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mi'i hawyi Iuta pe ta'atuium 30 ape Iesui enoi hap sa'up mo. Mi'i hawyi Iuta tuwa­nẽtup aikotã waku tutunug ima'at hamuat hap ete. Toikat kahato aikotã miat ipytyk hamuat. ");
INSERT INTO mavNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mi'i turan howakai te wuat man teneg u hap ete irania'in hemiit'in apo'i'atu'e — Aikope som waku watunug meiũ aheman teneg u hap i'atu'e. Aikope aru watenuk i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mi'i hawyi Iesui to'e — Pyno eweiwat ro tawa wato kape e. Put'ok'ei'e hawyi ti aru eweipuẽti wẽtup ok miit itote e. Mi'i pe ewehenoi — Uruka'iwat e'at ti put'ok'e ra'yn ti ewei'e ran o e. Uiku'uro hamuat e'at yt pya hin i ra'yn wyti e ti Aika'iwat ewei'e o e. Mi'i pote ti tenuk teran temiit'in nywo e'yat pe ewei'e o mekewat man u hamo getap ka'iwat pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mi'i hawyi tuwat ra'yn Iesui ehay wywo tuwat hawyi aikotã Iesui mienoi ewy yne ra'yn ta'atu­puẽti. Mi'i hawyi ta'atu­po­rokpun itote ienuk hap imiky'esat ewy ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mi'i hawyi wãtym i turan toto ra'yn Iesui temiit'in kape i'atu­wywo tenuk hamo. Mi'i hawyi te'era'apyk itote mekewat mesa ypyke. ");
INSERT INTO mavNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mi'i hawyi i'atuenuk turan Iesui to'e — Pywo pe ti are'e wẽtup ok ti meiũpe aiwywuat ui'auka kary hanuat hat e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mio tã e pote ipotmu'eria te'eru­wa­nẽtup kahato hawyi i'atunik kahato ra'yn haty kahato i'atuete mio tã e hap ihay. Mi'i hawyi apo'i'atu'e — Uito apo'e wẽtup ok i uito apo'e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mi'i hawyi Iesui to'e — Ta'i mekewat uiwywuat man puka mi'u moi miat hat wyti aru ui'auka kary hat e irania'in me Iuta etiat. ");
INSERT INTO mavNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ta'i tohenoi yne sa'awy'i miwan me aikotã Eheyke'et auka hamuat etiat hap e. Ma'ato ti mekewat uima'at hat Tupana ti'uhu kahato ti aru e. Ta'i Eheyke'et wyti miit'in mi'auka wo ra'yn topyhu'at aikotã sa'awy'iwuat e hap ewy. Ma'ato ima'at hat ti po'og yt naku i pe topyhu'at hamuat aru e. Ta'i po'og waku iku'uro toty ymyẽpe te uima'at rẽ e. Po'og waku yt karãpe i ra'yn toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mi'i hawyi tokosap ta'yn Iuta irania'in saipepe to'e hamo — Uito apo ema'at hanuat hat uiKa'iwat e. Mi'i hawyi Iesui tiwesat — Ta'i e'e hap ewy mehĩ e Iesui Iuta pe apo'e hawyi. ");
INSERT INTO mavNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mi'i hawyi Iesui tat man hawyi waku e Tupana pe hawyi toipikpik ta'yn. Mi'i hawyi tutum temiit'in me hawyi to'e — Ewetat ro mesuwat man mehĩ'in e. Eweitu'u ro mi'i ti uipiit e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mi'i hawyi totat ihy kui'a piat. Mi'i hawyi waku e Tupana pe. Mi'i hawyi toimõ'ẽ temiit'in me hawyi to'e i'atuepe — Eiwe'y'u ro e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mi'i ti uhuu at hap miit'in wehik Tupana etiat hamuat yn i'atu­minug sa'ag miwaure Tupana piat hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi'i hawyi ti aru yt karãmuat i ra'yn aresa­pohy'u eiwywo mesuwe ma'ato meiũran aru karãpe Ui'ywot topyhu'at Morekuat nuat mi'i turan aresa­pohy'u eiwywo i ra'yn aru e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mi'i hawyi Te'eru­wepy hawyi tuwat ra'yn Uriweira ypia e'yity'ok kape. ");
INSERT INTO mavNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mi'i hawyi put'ok'i'atu'e itote hawyi to'e Iesui i'atuepe — Ta'i mesuwat ewãtym ni aru ui'atoiat yne eipe. Eiwesytpok aikowo aikowo aikotã miwan miat to'e hap ewy — Ati'ahyk hawyi iku'uro I'atu­ka'iwat hawyi ihũria tuwe­sytpok yne e hap ewy tuwat tuwat kowo'i kowo'i ihũria e miwan me. Mio tã e hap ewy ti aru mesup ewãtym ui'atoiat yne ra'yn eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma'ato areĩne'en i ra'yn gu'uro pyi hawyi ti aru woro­ho'o­puẽti i te ra'yn yi Karireia pe e. Ehe'yianmete areto. Mi'i hawyi ti itote ra'yn wato'o­puẽti aru e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mi'i pote Peteru to'e — Uito aru yt karãmuo hin i aremõti epupi e wen. Yt karãmuo hin i aru woro'atoiat En e Peteru. ");
INSERT INTO mavNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mi'i pote Iesui to'e — U pãi mesuwat ewãtym ti aru — Yt atikuap i ra'yn Iesui ere ra'yn mye'ym muat waipaka ehay e'yianmete — Yt atikuap i wyti uito ere ti aru. ");
INSERT INTO mavNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","— Ta'i yt hin i aru ma'ato ui'auka ti aru ewywo uito irania'in ma'ato ti aru yt woro'atoiat hin i aru e Peteru. I'ewyte irania'in hemiit'in Peteru ehay ewy te te'ero'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mi'i hawyi put'okta'atu'e mikoi ypia Kese­mani e hap tote. Mi'i hawyi to'e topot­mu'eria pe — Ewei'apyk to meiũpe. Mi'i hawyi ti Uito kuepuo areĩne'en uhehay Tupana wywo turan e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mi'i hawyi totioto Peteru i'ewyte typy ok Sepeteu sa'yru'in totioto yt pya i irania'in kai. Itote hawyi tohaty u kahato topy'a pe. Tuwa­nẽtup ho'opot hap kape yn. ");
INSERT INTO mavNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Itote iwanẽtup hap yt he hin i ra'yn. Itote i'arot yn toĩne'en. Mi'i hawyi to'e topot­mu'eria pe mye'ym ok takaria pe — Ta'i ahaty'u hap porap ui'auka e. Paa'ui'e hap wyti e. Mi'i tupono ewehẽtup are Tupana pe uipo­wyro hamuat hap e. Pyno uheka­tuwy wo ro eweikupte'en meiũpe e. Yt eweiket rei'o. Eweheha'at ro e Iesui mye'ym ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mi'i hawyi toto porap'i hawyi porog'e yi tote to'owapuo hawyi to'e — Ui'ywot e etat meikowat kui'a uipo pyi are ma'ato — Etu'u ro ere pote atu'u emiky'esat ewy e Iesui To'ywot pe. ");
INSERT INTO mavNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mi'i hawyi ta'aipok i ra'yn temiit'in mye'ym ok takaria kape. Mi'i hawyi toi'atu­puẽti i'atuket turan ne'i ra'yn. Mi'i hawyi to'e Peteru pe — Yt ehẽtup kuap i apo wẽtup eura i wyti uhupi e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ewe'eg wo o. Ehẽtup o Tupana kape — Urumoe­saika kahato uruiã'ãg hap pupi Uruka'iwat atoiat hap pupi ewei'e ro Tupana pe e. Ta'i atikuap ti eweiky'esat kahato Tupana miky'esat nug hap ma'ato ti yt put'ok'e i ehesaika hap inug hamo e Iesui topot­mu'eria mye'ym ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mi'i hawyi ta'aipok To'ywot kapiat tehay hamo hawyi to'e — Ui'ywot yt etihep kuap i pya uikai meikowat kui'a uipo pyi ho'opot hap e mi'i pote waku atu'u emiky'esat ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mi'i hawyi ta'aipok i ra'yn temiit'in kape. Mi'i turan te'eroket i ra'yn. Yt mehit'i'atu'e kuap i sese yt te'eroket teran i pytkai. ");
INSERT INTO mavNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mi'i hawyi ta'aipok i ra'yn mye'ym mo ra'yn tehay Tupana kapiat hamo. Mi'i hawyi i'ewyte te tohẽtup. ");
INSERT INTO mavNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mi'i hawyi ta'aipok i temiit'in kape. Mi'i turan iwyria'in te'eroket i ra'yn. Mi'i hawyi to'e — Uiwyria'in pyno eweiket re apo'are. Put'ok'e ra'yn ti koitywy uima'at hat. Eheyke'et ti koitywy yt nakuaria i po pe ra'yn topyhu'at. ");
INSERT INTO mavNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ei'ãpe'ok'am no katu­pono ti uima'at hat ti tut ra'yn e temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mio tã e turan Iuta put'ok'e ra'yn. Tõ'ẽ tõ'ẽ Iuta upi typy'i kahato aria'yp ãkun wywo kyse'yp ko'i wywo Iesui kape ipak pak hamo. Pa'i kororia nagnia akag ko'i tõ'ẽ tõ'ẽ Iuta wywo. ");
INSERT INTO mavNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Katu­pono sa'awy'i ti Iuta ti'atumu'e mu'e surara'in yianmete — Put'ok'ui'e hawyi ti aru Iesui ra'yn ati'ãpysig e i'atuepe. Mi'i turan o eweto­pytyk ta'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mi'i hawyi put'okto'e hawyi tokosap Iesui kape hawyi to'e — Wãtym Uimu'e hat e. Mi'i hawyi ti toi'ãpysig na'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mi'i pote Iesui — Kat hamoĩ eriot uiwy e. Mi'i pote hupiat õ'ẽ haria topytyk ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mi'i pote wẽtup ok ipotmu'e i'yatypiat hat tekyse'yp towope pyi totekyi hawyi wẽtup ok pa'i emiit toi'ahape hep ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mi'i pote Iesui to'e — Etopag i ro ekyse'yp ewope pe mehĩ e temiit Peteru pe. Katu­pono uwe uwe tuwepyk mi'i hat wyti miit'in mipoepyk wo hawyi iku'uro rakano topyhu'at e. Uwe uwe ti'auka miit mi'i miit miit'in mi'auka wo aru tapyhu'at. ");
INSERT INTO mavNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Katu­pono atiky'esat pote ti yt niatpo hin i ahẽtup Ui'ywot kape atipy kaipyi uipo­wyro hamuat. Meremo tõ'ẽ uipo­wyro hamo po'og typy'i kahato wuat sakpuaria surara'in sem e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Katu­pono sa'awy'ite ui'auka hamuat yn ta'atu­henoi miwan me. Mi'i pote yt ahẽtup kuap i atipy kape uipo­wyro hamuaria surara'in sem e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mi'i hawyi Iesui to'e õ'ẽ haria pe — Kat hamoĩ eweĩ'ẽ uhowawi kyse'yp ko'i wywo aria'yp ãkun ko'i wywo. Pyno sero'ok'e hat apo Uito. Mi'i pote apo eweĩ'ẽ uhowawi. Sa'awy'i te kue areĩne'en wuat'i e'at pe Tupana mõtypot yat pe eimu'e haype ma'ato kue eipe yt kat ewei'e hin i. Yt uipytyk i eipe pãi e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma'ato apo koitywy eweikuap pyno katu­pono uipyhik ta'yn eipe mesup e. Pyno ahenoi ehepe. Ta'i sa'awy'i­te­wuaria Tupana ehay enoi haria henoi henoi meikotã hamuat hap yn. Mi'i hawyi aru i'atu'e ta'atu­miwan me mi'i hap ewy ra'yn meiũ e. Mi'i hawyi ti ipotmu'eria ikohyeput Iesui yaty­pepyi ta'atu'atoiat yne. ");
INSERT INTO mavNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mi'i hawyi ipytyk haria tioto ra'yn Iesui pa'i koro sese Ka'iwa e hap yat kape ra'yn. Aikope tukupte'en iwan miat Tupana ehay enoi haria kape nagnia ehay enoi haria te'eru­wa'a­tunug hap kape. ");
INSERT INTO mavNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Meiũran Peteru toto ma'ato pya i'atukai yt heremo i ma'ato. Mi'i hawyi put'ok'e mekewat pa'i wato yat ete hawyi tokosap i'yat pyhyp hap surara e'oken'ypy kape. Mi'i hawyi ta'apyk itote pa'i kororia emiit'in ywytpe. Ta'akasa teran aikotã ta'atunug Iesui ete hap kape. ");
INSERT INTO mavNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mi'i hawyi itote pa'i kororia tikat kahato sehay sa'ag yne kaipyi nagnia wo'onãpin haria ko'i wywo. Kat pote yt pywo pe hin i ta'atu­kuasa sa'ag i'auka hamuat. ");
INSERT INTO mavNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma'ato yt aikotã hin i ta'atu­puẽti sehay sa'ag Iesui etiat. Katu­pono ta'atu­henoi yt to'o'ewy'ewy i. Mi'i pote yt to'osat'i i'atu­wa­nẽtup hap ko'i. Mi'i turan ni ma'ato put'ok'i'atu'e typy ok henoi hanuaria hawyi te'ero'e ");
INSERT INTO mavNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","— Ta'i meiẽwat Miit wyti ihay uruehamo — Atipugha ti aru meiẽwat Tupana mõtypot yat e ti i'atu'e. Mi'i hawyi — Mye'ym e'at pe yn atimopoĩ'ãm i e i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mio tã i'atu'e pote pa'i koro ipoĩ'ãm na'yn hawyi to'e Iesui pe — Yt eti'atu­wesat i apo mio tã i'atu'e pytkai e. Eti'atu­wesat ro e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma'ato yt kat e hin i. Mi'i hawyi pa'i koro to'e i — Ehenoi ro Tupana kaipywiat En hap Miit'in Porekuat nuat eut hap sio apo yt Mi'i i En e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mi'i hawyi to'e Iesui pa'i koro pe — Ta'i mehĩ mio tã e'e hap ewy ti mehĩ e. Ta'i meiũran ti aru ewei'akasa miit'in Eyke'et Tupana po sese kai mekewat po'og hesaika rakat po sese kai apyk pe tut atipy kaipyi ywyhig me ewei'akasa ti aru. Ta'i mi'i hap ti aru ewei'akasa e Iesui pa'i koro pe. ");
INSERT INTO mavNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mio tã e pote pa'i koro tuwe­ka­misa wato hiot hawyi to'e i — Ta'i heso kahato ti Tupana ete tuwe­pehik pehik topy'ahak haype. Pyno koitywy watikuap kahato sese ra'yn heso hap. Ta'i tuwe­kuasa kahato ra'yn ti tehay wo. Ahehamo kahato ra'yn tuwema'at sese ra'yn. Pyno watikuap ta'yn koitywy. Toran na'yn ahehay e pa'i koro irania'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mio tã to'e hawyi apo'e irania'in me — Pyno aikotã wato'e aru koitywy meiũwat Miit ete e. Mi'i hawyi ta'atu­wesat — Ta'i mio tã e hat auka potiat ne'i waku i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mi'i hawyi kuitu'i'atu'e Iesui owa ete. Ta'atu'ahyk ta'atupo'ok. Irania'in howa­petek ta'atu­popep mo. ");
INSERT INTO mavNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","— Pyno koitywy pywuat Tupana Mipo'oro En pote ehenoi ro uwe uwe piat ewapetek haria set ko'i i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mi'i turan Peteru ta'apyk mekewat getap e'oki­pyke. Mi'i hawyi wẽtup ok makuptia pa'i koro eropat hat put'ok'e Peteru ete — An e worokuap kahato en. Iesui emiit en yi Karireia piat en e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mi'i pote Peteru tiwesat — U yt uito i rat e. Yt atikuap i ehay e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mi'i hawyi Peteru toto mekewat oken'ypy wato kawianuat og kape ra'yn. Tokosap mekewat hary­poria hit yaty­pepyi. Mi'i hawyi itote wẽtup ok i ra'yn i'atue­ropat hat re hary­poria kawiat to'e towyria'in me — Atikuap ti uito meiẽwat. Mekewat tawa Nasare piat turanuat Iesui wywuat ieĩne'en hat wyti e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mi'i hawyi Peteru to'e itotiaria pe — Yt rat e yt atikuap i ti uito Mi'i Miit e. pywo ti yt uheso i rat. Tupana tikuap kahato yt uheso i hap e Peteru. ");
INSERT INTO mavNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mi'i hawyi irania'in tokoka'at Peteru kape mi'i hawyi te'ero'e — Ta'i uruikuap ti en. En ni wyti wẽtup ok Iesui potmu'e ti rat katu­pono yi Karireia piaria ehay ewy ra'yn ehay i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mio tã i'atu'e pote toiwesat sa'ag ne'i ra'yn — Yt atikuap i ti uito Mi'i Miit tupono. Yt atikuap i kahato rat Mi'i Miit. Uheso pote aru waku ra'yn Tupana ui'apiheg e. Ma'ato yt uheso i rat e turan waipaka ihay ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mi'i pote so hot'ok'e ra'yn Iesui ehay kape — Waipaka ehay e'yianmete ti aru — Yt atikuap i wyti Mi'i Miit ere ra'yn uhepiat pe mye'ym mo e Iesui hap kape iwatetup ta'yn. Mi'i hawyi tuwepik ta'yn itote pyi tuwak kahato ra'yn Peteru tominug sa'ag hap upi. Mi'i tã sa'awy'iwuat hap etiat atikuap. Mi'i hawyi atunug uimiwan mesuwe are uito Mateu. ");
INSERT INTO mavNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mi'i hawyi hunete te'eru­wa'a­tunug pa'i kororia nagnia ko'i wywo aikotã waku Iesui ta'atu'auka hap kat hamo torania tapy'yiaria akagnia ko'i wywo. ");
INSERT INTO mavNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mi'i hawyi ta'atupo'i po'i ra'yn Iesui haity wo. Mi'i hawyi ta'atue­reto ra'yn wanĩ­kaptia porekuat Piratu e hap kape. Mi'i turan Iuta tut ra'yn Iesui ma'at hat topo piat ha'up wywo. ");
INSERT INTO mavNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mi'i hawyi tuwa­nẽtup hawyi Iuta to'e pa'i kororia pe — Ahaty'u uipy'a pe ra'yn uiminug sa'ag Uika'iwat etiat hap pãi e i'atuepe. Ewetat ro mesuwat sa'up sa'ag uipo pyi e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ta'i ati'aparap kahato ti uito. Atum Uika'iwat ehepe pote yt kat upiat hin i i'aparap hat i atiwe­neru ehepe e. Mi'i hawyi ta'atu­wesat Iuta — Pyno koitywy yt urutu­wa­nẽtup teran hin i ra'yn ti eminug kape i'atu'e. Eminug sa'ag epe topyhu'at uhyt i'atu'e. Kat etunug ti aru ewanuat ra'yn uhyt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mi'i hawyi Iuta tipo­rokpun na'yn mekewat sa'up 30 ape rakat Tupana mõtypot yat koro pe. Mi'i hawyi totoiat ha'up itote hawyi toto tuwe'auka hamo. Mi'i hawyi haity wywo tuwe'ut'yp kytyp ywaiti hawyi iku'uro. ");
INSERT INTO mavNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mi'i hawyi pa'i kororia te'ero'e — Aikotã som mesuwat miit suu sa'up ete watunug i'atu'e. Yt naku i watopag mi'i Tupana mõtypot yat piat heiam me i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Te'eru­wa­nẽtup hawyi te'ero'e — Pyno waku ti watikyi'at mekewat kamũti wuat mipuruk puruk yi ka'a. Mi'i hawyi waku itote watisyp iku'uro rakaria yt uwe mikuap i ko'i i'atu'e. Mi'i hawyi ta'atukyi'at mekewat 30 ape rakat sa'up mo. ");
INSERT INTO mavNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mi'i hawyi mi'i yi ta'atu­setnug — Mi'auka suu sa'up muat mikyi'at i'atu'e. Pyno mesup te mi'i set topyhu'at itote. ");
INSERT INTO mavNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pyno aikotã Tupana ehay enoi sa'awy'iwuat Ieremia to'e hap ewy — Meiũran ti aru ipiit sa'up ta'atukat karania upi i'auka hap sa'up ta'atukat hawyi 30 ape waku i'atu'e ti aru e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mi'i sa'up mo ti aru ta'atukyi'at kamũti wuat mihephep yi ka'a e Ieremia sa'awy'i miwan me hap etiat tohenoi. ");
INSERT INTO mavNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mi'i hawyi Iesui put'ok'e morekuat yat pe hawyi morekuat tikaykay tuwe­wawi apoto'e hamo — En apo Iuteuria ywania Porekuat sio yt e. Mi'i pote Iesui to'e — Mio wat ehay ewy uhyt e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mi'i hawyi morekuat pe te'ero'e pa'i kororia nagnia'in — Meiũ Miit yt naku i kahato rakat i'atu'e. Ma'ato Iesui yt i'atu­wesat hin i mio wuat i'atueso tepiat pytkai. ");
INSERT INTO mavNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mi'i hawyi morekuat to'e Iesui pe — Mio tã i'atu'e ti epe Uhyt ewanĩ­kaptia e. Yt naku i i'atu'e ti epiat pe Uhyt e. Kat ere kahu i ro pote eti'atu­wesat mio tã e epiat haria e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma'ato Iesui ipo'inik ne'i. Yt kat e hin i toi'atu­wesat mio tã e haria. Mi'i hawyi morekuat tuwa­nẽtup kahato kat pote yt toi'atu­wesat i hap kape. Kat pote som — Yt atunug hin i mi'i tã yt e hin i pãi e morekuat tuwa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pyno yne anu pe mekewat ienuk wato hap turan morekuat tipo­re­nõtem wẽtup ok wo'opyhik hawyi miit'in mowepit hamo ta'atu­mi­ky'esat ewy. ");
INSERT INTO mavNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mekewat e'at pe toĩne'en wo'opyhik hawe po'og yt nakuat i rakat Parapa e hap. ");
INSERT INTO mavNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mi'i hawyi morekuat ti'atu­kaykay miit'in hawyi to'e — Waku mesuwat anu atipo­renõ'ẽ wẽtup ok aimi­pyhik e. Uweĩ eweiky'esat e apo'e. Pyno waku apo atipo­re­nõtem mekewat Iesui sio ei'e hap eimiset'ok wuat'i po'og yt nakuat i Parapa e hap e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mi'i hawyi Piratu tikuap i'atu­we­moe­ha'y­wywi hap tuwa­nẽtup hawe Iuteuria akag yt tiky'esat i miit'in tuwat Iesui kape hap. ");
INSERT INTO mavNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mi'i hawyi Piratu ta'apyk te'amyap tote aikope more­kuaria to'e hap miit'in wakuat sio yt hap kuap hap tote. Mi'i turan ihary'i tuwehay po'oro te'aito kape — Yt etunug sa'ag nei'o mekewat Iesui e hap het rakat ete to'e hap. Ahaty'u kahato uimu'etu wuat mi'i hap e. Pyno uhe'aito epohep to merep Mi'i Miit ete e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mi'i hawyi pa'i kororia nagnia'in te'ero'e miit'in me — Pyno waku wati­putsit Parapa mi'i hawyi waku wati'auka Iesui ewei'e ro morekuat pe i'atu'e miit'in py'asetpe. — Mio tã ewei'e ro morekuat pe i'atu'e. Mi'i hawyi i'atuehay upi tuwat Piratu kape — Waku etiputsit Parapa hawyi waku eti'auka Iesui te'ero'e hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mi'i hawyi morekuat Piratu to'e i'atuepe — Pyno ewehenoi ro uwe waku atiputsit wo'opyhik hawiat e. Mi'i hawyi — Waku Parapa i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mi'i hawyi to'e i — Aikotã are aru atunug mekewat Eipo­rekuat nuat Tupana Mipo'oro ete e. Mio tã e pote — Erehay po'oro ro i'auka aria'yp posak etiat hamo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mio tã i'atu'e pote — Kat hamo kat iminug sa'ag po'ypyi ten ati'auka e morekuat. Mi'i hawyi ta'atuehay pirik wo — Erehay po'oro ro epiat i'auka aria'yp posak etiat hap i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mi'i hawyi Piratu tuwa­nẽtup hawe to'e — Tu'uka irane apo pãi e. Mi'i hawyi morekuat to'e temiit'in me — Eweherut y'y e uiwe­posei miit'in ehamuat hamo e. Ta'atu­herut hawyi tuwe­posei wuat'i miit'in ehamo. Tuwe­posei haype to'e — Areposei meiũ uipo meiũwat Miit wakuap auka hap suu yt atiky'esat i uipo ete pote e. Yt uito i i'auka hat to'e haype. ");
INSERT INTO mavNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mi'i hawyi te'ero'e — Yt eete i ti aru uhyt i'atu'e uruete urumẽpyt'in ete aru i'atu'e. Ta'i Iesui auka hap ti aru uruete uhyt i'atu'e. Uruete aha'yru'in ete uhyt i'atu'e Iuteuria. ");
INSERT INTO mavNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mi'i hawyi Parapa toiputsit wo'opyhik hawyi tutum i'atuepe. Mi'i hawyi toipo'oro tesu­rara'in Iesui pak pak hamo. Ta'atupak pak hawyi morekuat toiat ra'yn Iesui tesu­rara'in po pe i'auka hamo aria'yp posak etiat i'auka hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mi'i hawyi hesu­rara'in tioto morekuat koro yat pe. Mi'i hawyi ta'atu­kaykay yne morekuat esurara'in temiit'in sese Iesui kape. ");
INSERT INTO mavNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mi'i hawyi Iesui esokpe ta'atuhep yne hawyi morekuat esokpe wato ihup takat ipiit pe ta'atupag. ");
INSERT INTO mavNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mi'i hawyi ta'atupi'ig morekuat e'amãtap ewywuat morekuat painug hap ewy hehu rakat he'amãtap mo ma'ato ta'atu­mi­kyry'i hap ne'i mi'i tã ta'atunug. Ta'atupag Iesui akag me haty rakat. I'ewyte wy ta'atupag aria'yp ipo pe. Mi'i hawyi te'eru­we­pỹ'ã­tutuk ta'atu­mi­kyry'i haype. — Ereĩne'en mot'i ro mesuwat yi tote Urupo­rekuat no i'atu'e Iuteuria Porekuat no i'atu'e ta'atuehay mikyry'i haype. ");
INSERT INTO mavNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kuitu kuitu'i'atu'e Iesui ete. Mi'i hawyi ipo piat aria'yp ta'atusat hawyi ta'atu'ahyk ahyk mi'i wo i'akag ete. ");
INSERT INTO mavNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ta'atu­mi­kyry'i kahu ra'yn hawyi ta'atuhep i ra'yn ta'atu­mipag morekuat esokpe ihup takat. Mi'i hawyi ta'atupag iwat hesokpe sese i ra'yn. Mi'i hawyi itote pyi ta'atue­roto i'auka hamuat kape ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mi'i turan wẽtup ok miit ta'atu­puẽti mu'ap tote tawa Sireniu kaipywiat. Wẽtup ok Simãu e hap het rakat. Mi'i pe te'ero'e — Ehereto meiũwat Miit e'aria'yp posak i'atu'e tope. ");
INSERT INTO mavNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mi'i hawyi put'okta'atu'e yity'ok tote Iesui wywo yity'ok Miit Akag Kag ewywuat i'atu'e hap het rakat kape ta'atu'e­roto ma'ato i'atu­pusu puat Koukota e hap het rakat kape. ");
INSERT INTO mavNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mi'i hawyi itote ta'atuium sapo hy puo mohag haty monik hamuat hap nop takat. Toterep hawyi toikuap hawyi yt tutu'u i po'og neran. ");
INSERT INTO mavNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mi'i hawyi ta'atuhep hesokpe ko'i ipiit pyi. Mi'i hawyi ta'atu'ateg ipo ete ipy ete aria'yp posak ete. Hesokpe ta'atumõ'ẽ neran pote te'eru­we­ma­hara aikotã waku hesokpe ta'atumõ'ẽ hamuat hap. Aikotã sa'awy'ite Tupana ehay enoi haria henoi mi'i tã — Meiũran ti aru uhesokpe ta'atupat'ok pat'ok. Mi'i hawyi ti aru te'eru­we­ma­hara uwe topyhu'at uheka­misa wato wywuat hamuat kat hamo hap ete ti aru te'eru­we­ma­hara e sa'awy'i Tupana e hap ewy ta'atunug. ");
INSERT INTO mavNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mi'i hawyi apyk pyi surara'in yt ta'atu­ky'esat i irania'in ne'i ihep haype. Mi'i pote surara'in i'apykok kahato te'eraha'at kahato. ");
INSERT INTO mavNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mi'i hawyi ta'atu­miwan ta'atu­pehik Iesui apy tote aikotã yt nakuap i ko'i tutunug hap enoi hap — Meiũ ti Iesui Aipo­rekuat koro. Meiũ ti Iesui Iuteuria Porekuat koro e hap. ");
INSERT INTO mavNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mi'i hawyi i'ewyte ta'atu­pehik i'atu'aria'yp posak ete typy ok sero'ok'e haria wẽtup ok ipo ran kai wẽtup ok ipo sese kai tukupte'en ta'atu­pehik. ");
INSERT INTO mavNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mi'i hawyi hepiok haria i'atuehay mikyry'i kahato tokoka'at no. ");
INSERT INTO mavNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","— Ereha­kyera'at ro ereha­kyera'at ro meiẽpe pyi i'atu'e. — Tupana mõtypot yat atomoma hawyi atunug mye'ym e'at yn e hat meiẽ i'atu'e. Pywuat Tupana Sa'yru sese pote ti aru era'apyk to meiẽpe pyi ewewi aria'yp posak pyi i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","I'ewyte pa'i kororia nagnia'in ehay enoi haria te'eru­we­moko'i moko'i howawi. ");
INSERT INTO mavNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","— Irania'in ti toi'atue­ha­kyera'at kuap i'atu'e ma'ato tuwewi ti yt tuwe­ha­kyera'at kuap hin i i'atu'e. Ma'ato irania'in te'ero'e — Pywuat e'apyk aria'yp posak tote­pywiat pote ti ran meremo pywo rasig Isareu ywaniaria Porekuat nuat wato'e i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ta'i heso kahato ti — Tupana atimohey e ma'ato pywo imohey hat pote tut Tupana aria'yp posak pywiat ieha­kyera'at hamo i'atu'e ta'atuehay mikyry'i haype. ");
INSERT INTO mavNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","I'ewyte mipehik iywyt piat sero'ok'e haria te'ero'e ta'atuehay mikyry'i hap te wy. ");
INSERT INTO mavNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mi'i hawyi atpo­sake pyi i'ypyryp hap put'ok'e wãtym i kape. ");
INSERT INTO mavNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mi'i hawyi i'ypyryp we Iesui tuwatka haty wo wãtym i turan — Uhetu­pana Uhetu­pana kat poteĩ ui'atoiat En e. Ma'ato tuwat topusu puo — Erai erai irama sapa­tania e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mio tã e pote meimẽ­puaria te'ero'e — Meiẽ ti Eria sa'awy'iwuat Tupana ehay enoi hat ra'yn toikaykay topo­wyro hamo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mi'i hawyi aria'yp hit ẽpo ete ta'atupo'i amũkiusu'ap ewywuat hawyi ta'atu­puka ihy haiug nakat pe mi'i hawyi tutum turan waĩ'i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Waku wahe­katup mio apuru tut Eria ipowyro hamo sio yt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mi'i hawyi Iesui kak'e toku'uro haype hawyi ipyhu tek'e ra'yn hawyi iku'uro sese ra'yn. Tutum na'yn toieĩne'en hap. ");
INSERT INTO mavNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mi'i hawyi Tupana mõtypot yat e'okenhyp sokpe kawiat hiot'e ra'yn ywaiti pyi yi kape. I'ewyte wy yi ti huruk'e itote. I'ewyte wy nu wuat itotiat i'apok'e ra'yn nu. ");
INSERT INTO mavNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","I'ewyte wo'osyp hap i'ahot'e ra'yn yi tyry'e pote Iesui iku'uro turan. Mi'i hawyi tukupte'en i ra'yn gu'uro pywiat sa'awy'iwuat Tupana ehay moherep haria. ");
INSERT INTO mavNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mi'i hawyi mi'iria Iesui ewy tukupte'en i ra'yn gu'uro pywiat hawyi tuwat tuwat Tupana etawa Ieru­sarẽi kape te'eru­mo­herep itotiaria miit'in kapiat hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma'ato sa'awy'i Iesui ku'uro hap tote surara'in ta'atu'akag wywo i'apykok miit'in mupi hamo. Te'era'a­kasa yne aikotã aikotã iku'uro hap kape yi tyry'e hap kape. Mi'i hawyi te'eroken'ẽ kahato hawyi te'ero'e — Ta'i meiũ ti Tupana Sa'yru sese ti i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mi'i turan tukupte'en hary­poria'in iwywuat hewyry rakaria iku'uro hap kapiat akasa haria pya pywiat seha'at haria. Mi'iria ti sa'awy'i tõ'ẽ Iesui upi yi Karireia kaipyi Iesui powyro hewyry te turanuat mi'iria. ");
INSERT INTO mavNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Itote toĩne'en mekewat yi Mata­rena kaipywiat Maria e hap het rakat. I'ewyte wẽtup ok Maria Sepeteu sa'yru'in ty toĩne'en i'atu­wywo. ");
INSERT INTO mavNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mi'i turan mekewat at min'e turan mekewat Iesui potmu'e hekat rakat put'ok'e Iuse mekewat tawa Arimateia kaipywiat tut. Mi'i hawyi itote morekuat Piratu kape toto to'e hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","— Ati'asyp irane ra'yn ti Iesui piit e Piratu pe. Pyno etum no uhepe e. Mi'i pote Piratu temiit'in surara'in me to'e — Ewetum soke ro meiẽwat ipiit meiũwat miit pe e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mi'i hawyi toto howawi hawyi toihep ta'yn meiẽwat aria'yp posak ete pyi Iesui piit hawyi toipo'i po'i sokpe pakup ikytsig nakano ipiit. ");
INSERT INTO mavNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mi'i hawyi totopag ipiit mekewat towat wo'osyp hap nu ka'a pe ipakup takat pe. Mi'i hawyi meiẽwat nu wato toi'ãpe'okpun i'apyhik hamo. Mi'i hawyi waku yne ra'yn iheg me ra'yn hawyi toto ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mi'i hap ti Maria'in te'era'a­kasa yne katu­pono mi'iria te'era'apyk yt pya i ipũ'ã kai. ");
INSERT INTO mavNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mi'i hawyi Seita­weira e'at pe e'ihot'ok pe te'eru­we'a­tunug pa'i kororia wo'omu'e haria morekuat Piratu wywo. Mi'i hawyi te'ero'e morekuat pe ");
INSERT INTO mavNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","— Mekewat ga'atpuat urumi'auka heso rakat toĩne'en ne turan mio tã e — Mye'ym e'at areĩne'en gu'uro pe hawyi ti aru areĩne'en i ra'yn e hat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mi'i hap uruikuap hawyi uruhenoi kahato teran epe i'atu'e. Pyno waku etimoheg kahato mekewat i'asyp hap tote surara'in wywo i'atu'e mye'ym e'at kape surara'in ti'apykok waku i'atu'e. Ma'ato yt kat i i'apykok haria pote meiũran wãtym muo tõ'ẽ ipotmu'eria hereto hamo ta'atu'e haype. Mi'i pote iwẽtem na'yn hawyi te'ero'e miit'in me — Meiẽ neke tuwẽtem na'yn gu'uro pyi i'atu'e. Ma'ato mi'i tã ra'yn ta'atunug hawyi ti rẽ po'og heso hap topyhu'at ahepe sa'awy'i wat heso hap kai i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","— Pyno uimiium sa'awy'iwuat surara'in ko'i waku eti'atu­po'oro mekewat misyp apykok hamo e. Waku eweimoheg eimi­ky'esat ok tã e Piratu pa'i kororia pe. ");
INSERT INTO mavNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mi'i hawyi ta'atu'o­kenhyp iheg nakat nu wo mekewat yi mi'apokik wo ta'atu­pyhyp. Mi'i hawyi morekuat tunug toiã'ãkap mekewat yi mi'apokik ete. Mi'i hawyi to'e miwan me itote — Yt eweipikpik tei'o meiũwat e ma'ato eweipikpik pote ei'auka hap topyhu'at e. Mi'i hawyi i'ewyte surara ko'i toimõ­pyhu'at at ka'ap Iesui piit ero'ok haria pupi are uito Mateu. ");
INSERT INTO mavNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mi'i hawyi Sapatu e'at tokosap hawyi mũki'ite mytu'u e'at pe hunete ihot'ok pe turan tuwat Maria'in Iesui syp hap kapiat te'eraha'at hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mi'i hawyi put'ok'i'atu'e turan yi huruk'e kahato katu­pono Tupana mipo'oro atipy kaipywiat ra'yn put'ok'e nu wato kawiat he'okenhyp'ok hamo. Toimorem mekewat he'okenhyp hap hawyi ta'apyk he'okenhyp hap tote nu wato tote. ");
INSERT INTO mavNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Imehit kahato hẽtyhot kahato aikotã merep'e hap ewy. Hesokpe ti ikytsig kahato nukara kytsig hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mi'i pote surara'in itotiaria te'eroken'ẽ kahato ipupi to'otyry'i kahato ipupi gen'ẽ pono. Mi'i hawyi hewo yi upi map haria ewy surara ko'i. ");
INSERT INTO mavNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mi'i pote to'e Tupana mipo'oro Maria'in me — Yt eweiken'ẽ tei'o e. Woro­ho'okuap eipe Iesui piit kat haria aria'yp posak etiat mi'auka kat haria ti eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ma'ato yt uwe i ra'yn meiũpe topũ'ẽ pe e. Tuwẽtem na'yn gu'uro pyi Iesui aikotã yianmete tohenoi. Mi'i hap ewy ra'yn ti toĩne'en i ra'yn pãi e. Mi'i pote eweĩ'ẽ ro meikowo ipũ'ẽ kape eweha'at hamo pyno ta'atusyp Aika'iwat sa'awy'i hap kape e atipy kaipywiat sut hat mana'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mi'i hawyi tokoka'at hawyi te'eraha'at ra'yn. Mi'i hawyi to'e i i'atuepe — Koitywy eweiwat ro meremo ipotmu'eria piat henoi hamo. Iwẽtem i ra'yn gu'uro pywiat hap enoi i'atuepiat hamo. I'ewyte ewehenoi i'atuepe toto ra'yn tetama Karireia kape aikotã sa'awy'i to'e hap ewy — Areĩne'en i ra'yn hawyi ti aru areto yi Karireia kape i ra'yn. Mi'i tote ti aru wato'o­puẽti i ra'yn eiwywo to'e hap ewy ewei'e ro ipotmu'eria pe e atipy kaipywiat Tupana mipo'oro mana'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mio tã e hawyi tuwat ra'yn meremo Maria'in. Ikohyeput ra'yn te'eroken'ẽ popuo ma'ato i'ewyte ta'atu­wepit kahato wywo tuwat meremo ipotmu'eria piat henoi hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mi'i turan i'atu­ko­hyeput nuat iwat turan meremo Iesui ti'atu­puẽti mu'ap tote — Mana'in ariot i ra'yn e. — Mimi i'atu'e hawyi i'atu­porok'at ipy ete imõtypot hap wywo. ");
INSERT INTO mavNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","— Mana'in yt eweiken'ẽ tei'o e ma'ato eweiwat ro uiwyria'in eikywyt'in me henoi hamo — Waku ewei'aipok to ahe'yi Karireia kape i ra'yn ui'e hap ewy ewehenoi ro uhemiit'in me. Mi'i hawyi tuwat i ikohyeput i ra'yn ta'atu­henoi hamo. ");
INSERT INTO mavNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mi'i turan surara'in ikohyeput ra'yn tawa wato Ieru­sarẽi kape. Mi'i hawyi ta'atu­henoi ra'yn yne yne itote ta'atue­ro­kosap hap aikotã aikotã hap pa'i kororia pe. ");
INSERT INTO mavNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mi'i hawyi te'eru­wa'a­tunug na'yn pa'i kororia nagnia wo'onãpin haria wywo aikotã wato'e aru watunug ta'atu'e hamo. Mi'i hawyi surara'in me te'ero'e — Yt ewehenoi tei'o irania'in me mi'i tã hap. Ma'ato wẽtup sehay ewehenoi pote watum sa'up iwato'in nakat ehepe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Waku mio tã ewei'e wen — Wãtym muo urutoket turan ipotmu'eria tero'ok ne'i Iesui piit ewei'e ro irania'in me pote sa'up iwato watum ehepe i'atu'e nagnia surara'in me. ");
INSERT INTO mavNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma'ato morekuat tikuap hawyi ipy'ahak eiket hap ete pote ti aru watum aru ha'up iwato tope imoperup'i hamuat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mi'i hawyi waku i'atu'e surara'in hawyi ha'up ta'atusat ra'yn. Mi'i hawyi ti ta'atuma'at ra'yn miit'in — Ta'i ipotmu'eria tero'ok ti Iesui piit uruket kai i'atu'e torania pe mi'i tã i'atu'e. Mio tã e hap ti mesup te topyhu'at koran te mio tã i'atu'e Iuteuria to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mi'i hawyi ti ipotmu'eria 11 ok takaria tuwat ra'yn yi Karireia kape mekewat sa'awy'iwuat yity'ok kape aikope sa'awy'i Iesui to'e — Meiũran ti aru waku eweĩ'ẽ i mesuwe uiwẽtem i ra'yn gu'uro pywiat hawyi e hap kape. ");
INSERT INTO mavNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mi'i hawyi put'okta'atu'e itote i ra'yn hawyi te'era'a­kasa i ra'yn Ta'atu­ka'iwat Iesui kape. Mi'i hawyi te'eru­wehum kahato ta'atu­mõ­typot kahato Iesui. Ta'atu­mohey kahato ma'ato wẽtup ok wẽtup ok imohey ran. ");
INSERT INTO mavNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mi'i hawyi Iesui tut i'atue­wawi hawyi i'atu­py'a­setpe toĩne'en heremo kahato. Mi'i hawyi to'e itotiaria pe — Koitywy Tupana uinug Wuat'i Miit'in Porekuat koro wo e. I'ewyte atipy piaria Porekuat koro wuat e. Koitywy Ui'ywot tum yne ra'yn tesaika hap yne uhepe e. ");
INSERT INTO mavNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mi'i pote koitywy woro­ho'o­po'oro eipe wuat'i ywania mu'e hamo e. Mi'i pote koitywy atimõ'ẽ ra'yn ehepe uhesaika hap uhemiit'in pakup nug uhepiat hamo e. Ewei'atumu'e ro mi'iria ui'e yne hap nug hamuat i'ewyte ewei'atuset'ok uimohey pakup i haria Ui'ywot set upi uhet upi Tupana Pã'ãu set upi ewei'atuset'ok e. ");
INSERT INTO mavNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","I'ewyte atiky'esat uhehay ehehay wo topyhu'at einãpin uhepiat hap ok tã e. Mi'i hawyi eimi­mu'eria uimohey haria atiky'esat uhehay nug haria wo te'ero­pyhu'at e. Atiky'esat mi'iria uhepiat ta'atu­nãpin hap nug haria wo tukupte'en at ka'ap takaria hap atiky'esat e. Mi'i tupono eweiwat ro irania'in ywania yne mu'e hamuat turan ti aru yt eiweran hin i eweiwat katu­pono Uito ti aru areto eiwywo aikope aikope eweiwat hap upi areto wy. Eipo­wyro hano areto wuat'i e'at pe ikahuro hap put'ok'e hap kape. Areĩne'en eiwywo wuat'i e'at pe e Iesui ahepe temiit'in me. Toran na'yn uimiwan Uito ti Iesui eropat hat sese mekewat 12 ok takat Mateu.");
INSERT INTO mavNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mesup mienoi wakuat Aipo­typot Iesui etiat Tupana Sa'yru etiat aikotã sa'a­wy'i te Tupana to'e Tosa­'yru pe — Uha'yru e woro­po­'oro aru En miit'in ehakye­ra'at hamo e ma'ato sa'a­wy'i atipo­'oro teran wẽtup ok eut hap enoi hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Miit'in ekatup hawyi woro­po­'oro En i'atue­wawi i'atue­ha­kye­ra'at hamo e Tupana miwan me Marakia 3.1 pe. ");
INSERT INTO mavNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ma'ato sa'a­wy'i mekewat wẽtup ok eut hap henoi miit'in me — Tut irane wyti Tupana Mipo­'oro Miit'in Porekuat nuat e hat e. Mio tã wyti aru to'e epiat Uha'yru e. — Eweihy­wytip ipu'ap e aru eipy'a piat eiwa­nẽtup hawe. Mi'i hawyi toĩne'en mu'ap ewy ra'yn Tupana Mipo­'oro ehay mohey hamo e aru Uha'yru e Tupana. Ekatup hawyi woro­po­'oro En miit'in kape Uha'yru e. Waku hawyi ti aru ekatup ta'yn miit'in turan ti aru waku En ereto e Tupana Tosa­'yru pe. E'yianmiat uimi­po­'oro wyti aru henoi henoi haty wo miit'in me — Tut irane ti Miit'in Porekuat nuat e. Mi'i hawyi eweitoiat ro eiminug sa'ag ko'i eiwa­nẽtup sa'ag hap ko'i hawyi mu'ap ewy ra'yn toĩne'en Tupana Mipo­'oro Eheha­kye­ra'at hanuat mohey pote e'yianmiat henoi e Tupana Tosa­'yru pe. Waku hawyi ti aru ekatup ta'yn miit'in mi'i turan ti aru waku ereto En e Tupana Tosa­'yru pe sa'a­wy'i. Mi'i hawyi Tupana ehay moherep hat Isaia iwan Tupana e ihay Tosa­'yru piat hap Isaia 40.3 pe. ");
INSERT INTO mavNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mi'i turan ni Iuwãu tut ra'yn mekewat wo'o­set'ok hat Tupana to'e hap ewy. Mi'i hawyi yahig note tohenoi henoi kahato miit'in me — Eweiwaure ro eiminug yt naku i hap ko'i e. Mi'i hawyi ewei'aipok to Tupana ewawi e. Waku hawyi woro­ho­'o­set'ok e Iuwãu miit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mi'i hawyi miit'in tawa Ieru­sarẽi kaipy­wiaria yi Iuteu kaipy­wiaria tõ'ẽ tõ'ẽ yahig kape Iuwãu mienoi kuap hamo. Mi'i hawyi ti õ'ẽ haria henoi ra'yn wuat'i aikotã ta'a­tunug yt naku i hap ko'i to'ope. Waku hawyi Iuwãu ti'a­tu­set'ok Iũtãu hy pe. ");
INSERT INTO mavNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Mi'i hap Iuwãu esokpe ti ihũ Kameru sap kawiat. Imi'u wyti pohit i'ewyte awi'a hy imi'u wo. Iwe'ok kytyt hap ti mi'at pe kawiat. ");
INSERT INTO mavNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mi'i hawyi ti tohenoi henoi miit'in me — Meiũran ti aru tut wẽtup ok po'og po'og wakuat uikawiat rakat e. Uiat uhewaku hap yt put'ok'e i ipysei hamo ipy sokpe saity pok hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","— Uito ti woro­ho­'o­set'ok y'y wo ma'ato mi'i ti aru Tupana Pã'ãu wakuat no ra'yn ehet'ok e Iuwãu miit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mi'i hawyi wẽtup e'at pe tut ra'yn Iesui tawa Nasare kaipyi tomotag hap tama Karireia kaipyi Iuwãu kape toset'ok Iũtãu hy piat hamo tut. ");
INSERT INTO mavNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mi'i hawyi Iesui tuwẽtem y'y pyi hawyi teha'at ra'yn atipy kape. Mi'i hawyi ta'a­kasa ra'yn oken'ypy ewy ra'yn. Mi'i totepyi tut ra'yn Tupana Pã'ãu hawyi put'ok'e ra'yn pykasu ewywuat Iesui ete. ");
INSERT INTO mavNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mi'i hawyi sehay tut Iesui pe atipy kaipyi — Ta'i uimi­ky'e kahato En Uha'yru e. Mi'i tupono arehum kahato ete e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mi'i hawyi meremo Tupana Pã'ãu to'e Iesui pe — Ereto ro yahig koro kape mesu­wepyi Iũtãu hy sakpo Uha'yru e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mi'i hawyi toto Iesui Iuwãu pyi i'ewyte Iũtãu hy kaipyi yahig koro kape. Mi'i hawyi itote tuweran toĩne'en mi'at ko'i py'a­setpe 40 e'at toĩne'en itote. Mi'i turan ahiag hã'ãg kahato Iesui. Toiky­'esat Iesui tunug yt naku i hap ko'i. Mi'i hawyi Tupana mipo­'o­roria atipy kaipy­wiaria tõ'ẽ tõ'ẽ Iesui moesaika hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wẽtup e'at pe miit'in tipyhik wo'o­set'ok hat Iuwãu. Mi'i hawyi Iesui toto i ra'yn yi Karireia kape Tupana ehay wakuat enoi enoi hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mi'i hawyi to'e — Koitywy ti porap put'ok'e ra'yn Tupana Morekuat nuat ieĩne'en hamuat. Mi'i tupono eweitoiat ro eiminug yt naku i hap ko'i hawyi eweimohey ro Tupana ehay wakuat e Iesui tetama piaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wẽtup e'at pe so hewyry Iesui yi Karireia hyemyi'a e'yi kyt upi. Mi'i turan ta'a­kasa pira pytyk haria kape uhyt Simãu iywyt Ãtere kape. Mi'i turan kowo'i kowo'i suki wato wo ta'a­tukat pira y'y pe. ");
INSERT INTO mavNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mi'i hawyi Iesui ti'a­tu­kaykay ra'yn — To'iro uhupi uhyt'i'in e. Mesup te ti pira pytyk haria wo eipe ma'ato meiũran ti aru ahenoi miit'in pytyk Tupana wanuat hap ehepe e Iesui Simãu i'ewyte Ãtere pe. ");
INSERT INTO mavNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mio tã e Iesui hawyi meremo ta'a­tu­'atoiat ta'a­tue­suki wato hawyi tuwat ra'yn Iesui upi. ");
INSERT INTO mavNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mi'i hawyi Iesui toto porap'i ywyku'i upi. Mi'i turan ta'a­kasa i Sepeteu sa'y­ru'in kape Tiaku Iuwãu kape wesuki wato mog yara piat haria kape. ");
INSERT INTO mavNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mi'i hawyi toi'a­tu­kaykay meremo mi'iria hawyi tuwat ra'yn hupi yara pyi ta'a­tu­'ywot wywuatpyi. Mi'i hawyi Sepeteu topy­hu'at temiit'in wywo yara pe. ");
INSERT INTO mavNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mi'i hawyi toto i ra'yn Iesui temiit'in wywo tawa Kawa­na'ũ kape. Tupana mõtypot hap e'at pe hawyi Iesui teke Tupana mõtypot yat pe itotiaria mu'e hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mi'i hawyi te'e­ru­we­wa­nẽtup kahato hawyi te'e­ro'e to'ope — Kat poteĩ Iesui aimu'e yt miwan enoi haria ewy i ra'yn i'atu'e. Mi'i ti morekuat ewy ra'yn wen i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mi'i turan wo'o­mu'e hawe wẽtup ok toĩne'en ahiag ipiit piat rakat. Mi'i so to'e — Ta'i uruikuap ti En e. En ni mekewat Iesui tawa Nasare kaipywiat. En ni Tupana Sa'yru wakuat e tehay pirik wo. ");
INSERT INTO mavNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kat ere teran kahu uruete i'atu'e. Urutu­'uka hamo apo eriot i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mi'i pote Iesui wãi'e haty wo — Epo'inik to ahiag e. Erẽtem no meiẽwat miit piit pyi e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mi'i pote meiẽwat miit ahiag tihuruk tuwẽtem tehay pirik wuat haype. ");
INSERT INTO mavNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mi'i pote irania'in te'e­ru­wa­nẽtup kahato hawyi apo'i­'a­tu'e to'ope — Uweĩ meiẽ wo'o­mu'e hat i'atu'e. Yt wata­'a­kasa i meiẽwat ewywuat tehay esaika wuat ahiag sopo hat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mi'i hawyi wuat'i pe ra'yn ta'a­tu­henoi henoi Iesui etiat hawyi irania'in yi Karireia piaria ikuap ta'yn Iesui piat wakuap nug hap etiat. ");
INSERT INTO mavNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mi'i hawyi ti Iesui tuwẽtem na'yn Tupana mõtypot yat pyi. Mi'i hawyi toto i ra'yn towy­ria'in Iuwãu Tiaku wywo temiit'in Ãtere Simãu yat kape. ");
INSERT INTO mavNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mi'i hawyi Simãu sakitu i'ahu rakat yni pe ta'a­tu­puẽti. Mi'i hawyi ti mekewat i'ahu hap ta'a­tu­henoi Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mi'i hawyi toto ra'yn howawi. Put'ok­to'e hawyi toipo­pytyk ta'yn hawyi — Epoĩ'ãm no e hawyi i'ãpe­'ok'am na'yn waku ra'yn. Mi'i hawyi i'ahu kosap iwy Simãu sakitu. Tehãite meremo hawyi tote­ropat ra'yn Iesui'in. ");
INSERT INTO mavNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mi'i hawyi at min'e turan ta'a­tuerut Iesui kape wuat'i i'ahu rakaria wuat'i ahiag ipiit piat rakaria tawa wato Kawa­na'ũ kaipy­wiaria. ");
INSERT INTO mavNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mi'i hawyi ti yne tawa piaria te'e­ru­wa­'a­tunug oken'y­pyke. Mi'i hawyi ti toi'a­tu­moe­hãite kahato i'ahu rakaria. ");
INSERT INTO mavNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","I'ewyte ahiagnia toi'a­tu­sopo kahato miit'in piit pyi. Mi'i hawyi to'e i ahiagnia pe — Eipo­'inik to ahiagnia e. Yt ewehenoi tei'o uikuap ehepiat hap e i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ihot'ok kai i toto ra'yn Iesui tuweran yahig kape. Mi'i hap tote to'oehay Tupana wywo. ");
INSERT INTO mavNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Meiũran ti Simãu'in tuwat hupi ikat hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ta'a­tu­puẽti hawyi te'e­ro'e tope — Urumu'e hat i'atu'e mio ti ekat haria typy'i kahato Mehĩ i'atu'e. Pyno to'iro i wata­'aipok ekat haria kape i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma'ato toi'a­tu­wesat — To'iro irania'in tawa kape e. Wuat'i tawa pe ahenoi teran e. Yt wẽtup tawa pe yn i ahenoi teran e. Wuat'i piat henoi hamo ariot mesuwat yi kape e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mi'i hawyi toto i ra'yn Iesui yi Karireia piat Tupana mõtypot yat piaria enoi hamo ahiagnia sopo hamo miit'in kaipyi toto. ");
INSERT INTO mavNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wẽtup e'at pe Iesui ewyry hap tote hepihi pihi rakat tut Iesui kape. Mi'i hawyi tuwe­pỹ­'ã­tutuk haype to'e — Uhyt e uimoe­hãite teran mote uimoe­hãite o e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mi'i hawyi Iesui tiky'e hawyi tuwe­ponug hawyi to'e — Ta'i woro­ky'e kahato woro­moe­hãite teran uhyt e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mio tã e hawyi meremo ra'yn ipiit kahu ra'yn tuweityk ta'yn hepihi. ");
INSERT INTO mavNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mi'i hawyi Iesui tinãpin haty wo — Pyno uhyt waku ra'yn epe etiat e. Mi'i pote are'e epe ereto ro pa'i ko'i kape hawyi epiit kahu hap etomo­herep to i'atuepe e. Mi'i hawyi ti aru ta'a­tukuap ta'yn emoehãite hap e. Ma'ato irania'in me o yt etomo­herep tei'o emoehãite hap mu'ap upiaria pe e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Katu­pono etomo­herep sa'a­wy'i pa'iria piat hap atiky­'esat e. Waku ehenoi i'atuepe aikotã aha'a­se'i Musei nimo ainãpin hap ewy ehenoi o emoehãite kuap miit'in miat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma'ato yt Iesui miky­'esat ewy i tohenoi Iesui piat tomoe­hãite hap yne pe. Mi'i pote ti Iesui yt teke kuap i tawa pe katu­pono ti typy'i kahato akasa teran haria tõ'ẽ tõ'ẽ howawi wuat'i kaipyi. Mi'i pote yahig note toĩne'en yt teke kuap i tawa pe pote. ");
INSERT INTO mavNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Meiũran Iesui ta'aipok i ra'yn tawa Kawa­na'ũ kape. Put'ok­to'e itotiat hawyi teke wẽtup netap we. Toĩne'en porap'i itotiat hap hawyi miit'in tikuap ta'yn aikope Iesui ieĩne'en hap. ");
INSERT INTO mavNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mi'i hawyi meremo tõ'ẽ tõ'ẽ i ra'yn howawi typy'i kahato ra'yn hawyi irania'in miit'in sem oken upi ne'i ra'yn yn tukup­te'en. Mi'i hawyi Iesui ti'a­tu­mu'e Tupana ehay wo õ'ẽ tewawiat haria. ");
INSERT INTO mavNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mi'i turan ta'a­tuerut Iesui kape yt ipoĩ'ãm kuap i rakat yni pe 4 ok herut haria. Ma'ato yt tuwe­hyt'ok kuap i Iesui ewawi sese kat pote typy'i poity'i netap wiat pote. ");
INSERT INTO mavNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mi'i pote te'e­ra'am na'yn netap ok tote hawyi ta'a­tu­'ahot ra'yn netap ok Iesui apy tote. Mi'i hawyi i'okhot'e hawuo ta'a­tu­mo­'apyk yt hewyry kuap i rakat yni pe. ");
INSERT INTO mavNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mi'i hawyi ta'a­kasa yne hawyi Iesui tikuap ta'yn tomohey i'atuepiat hap ko'i. Mi'i hawyi to'e i'ahu rakat pe — Koitywy ti yt naku i eminug sa'ag ko'i Tupana tihep yne ra'yn epy'a piat uiwy e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mi'i pote apyk puaria miwan enoi haria te'e­ru­wa­nẽtup hawe te'e­ro'e — Kat pote mio tã e Iesui i'atu'e te'e­ru­wa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Tupana yn ni yt nakuaria i aiminug hep kuap hat i'atu'e. Yt naku i mio tã e Iesui i'atu'e te'e­ru­wa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma'ato meremo Iesui tikuap topy'a pe i'atu­wa­nẽtup hap. Mi'i hawyi Iesui to'e i'atuepe — Kat poteĩ yt eweiky­'esat i ui'e i'ahu rakat piat hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kat are'e som pyno po'og yt niatpo i yt hewyry kuap i rakat pe sio apo koitywy ti yt nakuap i eminug atihep ta'yn are'e sio erepoĩ'ãm no hawyi eti'ok­po'i ro e'yni hawyi ereto ro e'yat kape are'e. Kat som pyno po'og yt niatpo i are'e yt ipoĩ'ãm kuap i rakat pe e Iesui miwan enoi haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mi'i hawyi to'e i — Ta'i Miit'in Yke'et ti yt nakuap i hep kuap hat wuat'i yt naku i hep kuap hat wyti Uito e. Mi'i tupono atimo­herep mesup ehepe uhesaika hap yt nakuap i hep hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Mi'i hawyi Iesui to'e i yt hewyry kuap i rakat pe — Epoĩ'ãm no hawyi eti'ok­po'i ro e'yni hawyi ereto ro e'yat kape e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mi'i hawyi meremo ra'yn i'ahu rakat ipoĩ'ãm hawyi toi'ok­po'i te'yni hawyi toto ra'yn wuat'i ehamo. Mi'i hawyi te'e­ra­ha'at kahato hawyi te'e­ru­wehum kahato Tupana ete. Mi'i hawyi te'e­ro'e to'ope — Aito yt karãpe i wata­'a­kasa meikotã i'atu'e ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mi'i hawyi toto ra'yn Iesui tawa pyi yi Karireia hyemyi'a hy ẽpe kape. Mi'i hawyi yi kyt upi tõ'ẽ tõ'ẽ miit'in typy'i kahato howawi. Mi'i hawyi tohenoi henoi i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mi'i hawyi tewyry hap tote Iesui ta'a­kasa uhyt Irewi mekewat Auweu sa'yru apykpe ipotpap netap wiat rakat. Mi'i ipotpap mu'ap pyhyp hap ete. Wuat'i mu'ap kare'en ko'i toipyhyp. Toipo­re­ra'at sa'up to'y­wania kaipyi wanĩ­kaptia porekuat pe. Mi'i hawyi Iesui tuwẽ­powat howawi — To'iro uiwywo Irewi e. Mi'i hawyi ipoĩ'ãm na'yn hawyi toto Iesui upi. ");
INSERT INTO mavNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wẽtup e'at pe Iesui toto Irewi yat kape topot­mu­'eria wywo te'e­renuk hamo. Mi'i hap tote typy'i kahato Irewi wyria'in te'e­ru­wa­'a­tunug ienuk hap tote. I'ewyte Iesui wywo tukup­te'en yt nakuaria i sa'up pore­ra'at haria te'e­renuk hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mi'i hawyi irania'in nagnia ehay enoi haria te'e­ra­ha'at ienuk hap kape i'ewyte miwan enoi haria te'e­ra­ha'at. Mi'i hawyi apo'i­'a­tu'e Iesui potmu­'eria pe — Kat poteĩ eimu'e hat yt nakuaria i iwywo sa'up pore­ra'at haria wywo tenuk i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mi'i e hap Iesui tikuap hawyi toi'a­tu­wesat — Uhyt'i'in yt eweikuap i apo aikotã ihãite rakaria yt tikat hin i mohag nug hat ma'ato irania'in i'ahu rakaria ti ikat kahato e. Mi'i hap ewy ti koitywy ariot yt nakuaria i era'aipok Tupana kapiat hamo e. Ma'ato — Uruto po'og waku e haria yt atera­'aipok kuap i Tupana kape e katu­pono yt uikat hin i — Uruto po'og i'atu'e pote. ");
INSERT INTO mavNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mi'i hawyi mekewat i'atu­we­mo­sy'at hap e'at pe miit'in te'e­ro'e Iesui pe — Wo'o­set'ok hat Iuwãu potmu­'eria koitywy te'e­ru­we­mo­sy'at kahato ra'yn i'atu'e. I'ewyte ti nagnia ehay enoi haria te'e­ru­we­mo­sy'at kahato ra'yn i'atu'e. Ma'ato ewat epotmu­'eria yt te'e­ru­we­mo­sy'at hin i i'atu'e. Kat poteĩ mi'i tã epotmu­'eria i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mi'i hawyi Iesui ti'a­tu­wesat — Katu­pono uipot­mu­'eria i'atu­wepit kahato aikotã ienuk hap e'at piat se'aito hap e'at piat ienuk hap ewy uipot­mu­'eria tukup­te'en e. Ienuk hap e'at pe yt uwe i tuwe­mo­sy'at i'atu­wepit hap e'at pote e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma'ato karãpe irania'in tioto se'aito pya to'o­'ya­ty­pepyi mi'i hawyi te'e­ru­we­mo­sy'at e Iesui wemo­sy'at haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","— I'ewyte ti wẽtup sehay ahenoi teran ehepe e. Ahesokpe pot'i i'ewyte hiot'e pote yt naku i watomog sokpe pakup wo ne'i e. Katu­pono ti ahepiat imog hap tuwe­'atuk hawyi toihiot ne'i ra'yn ahesokpe pot'i e. Mi'i hawyi ahesokpe hiot'e rakat topy­hu'at po'og na'yn sa'ag e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","I'ewyte ahetama pe watopag Uwa hy heiam i'ape pakup we e. Ma'ato heiam i'ape pot'i pe iteneg moity'i pote yt naku i mi'i tã katu­pono ti henãpuk hawyi heiam i'ape teneg hawyi pok'e i ra'yn e. Pok'e hawyi yt kat i Uwa hy i'ewyte yt kat i heiam pok'e hawyi. Ma'ato i'ape pakup wote yt pok'e i torok'e pote. Mi'i ewywuat yt naku i uhehay pakup eweipag sehay pot'i puo e Iesui nagnia ehay enoi haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mi'i hawyi yt i'atu­potpap i hap e'at pe Iesui tokosap ta'yn go sakpo awati ypia wywuat sakpo. Mi'i hawyi iwyria'in ho'opik ta'yn awati toko­ka'at no. ");
INSERT INTO mavNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mi'i hawyi ma'ato irania'in nagnia ehay enoi haria te'e­ra­ha'at kahato i'atu­potpap hap kape. Mi'i hawyi tõ'ẽ meremo hawyi wãita­'a­tu'e Iesui piat hamo — Yt naku i ti ta'a­tu­ho­'opik awati yt aipotpap i hap e'at pe. Yt naku i ti mi'i tã i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ma'ato Iesui ti'a­tu­wesat — U pãi yt eweikuap i apo miwan me aikotã sa'a­wy'i Tupana miky'e morekuat Tawi teke Tupana mõtypot hawe tesy'at wywuat hawyi toimõ'ẽ mekewat Tupana mõtypot haria eman tesu­ra­ra'in me hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mi'i hawyi tutu'u tesu­ra­ra'in nywo pa'i wato mi'u wuat ne'i. Mi'i aikotã aipo­rekuat sa'a­wy­'iwuat Tawi tunug mekewat pa'i Apiata ieĩne'en hap e'at pe turan e. Mi'i tã hat pytkai — Waku kahato aipo­typot sa'a­wy­'iwuat Tawi ewei'e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","— Uhyt'i'in sa'a­wy'i Tupana tunug tomõ­typot hap e'at hawyi tutum miit'in me i'atu­mo­wepit hamo tomohey hamuat e. Mi'i pote mio he'at toĩne'en miit'in po pe aimo­wepit hamo e. Ma'ato yt naku i Tupana mõtypot e'at ne'i topy­hu'at ai'akag wo wãi'e hano e. Kat pote Tupana tum ahepe te'at aimo­wepit hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tutum na'yn miit'in me te'at are mi'i pote Uito areĩne'en Tupana e'at Ka'iwat no i'ewyte areĩne'en Wuat'i Miit'in Yke'et no e Iesui nagnia wãi'e hap enoi haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mi'i hawyi Tupana mõtypot hap e'at pe Iesui teke i Tupana ehay enoi hawe. Mi'i hawyi itotiaria wywo toĩne'en ipo kĩ'ã rakat. ");
INSERT INTO mavNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mi'i hawyi te'e­ru­wa­nẽtup — Iesui timoe­hãite apo ipo kĩ'ã rakat yt aipotpap i hap e'at pe. Mi'i hap ti yt naku i i'atu­wa­nẽtup hawe. Mi'i hawyi te'e­ra­ha'at kahato Iesui kape ikuasa te hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mi'i hawyi Iesui tikaykay tuwe­wawi ipo kag mot'i rakat — Uhyt'i eriot ro meikowo e. Epoĩ'ãm no meiũpe miit'in py'a­setpe e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mi'i hawyi to'e Iesui irania'in me — Koran wyti Tupana mõtypot hap e'at e. Mi'i pote apo'are ehepe waku som mesuwat e'at pe wakuap watunug sio apo yt naku i e. Waku apo mesup e'at pe watunug miit'in ky'e hap sio miit'in atu'uka hap watunug e. Mi'i hawyi ma'ato yt ta'a­tu­wesat i ra'yn Iesui. I'atunik ne'i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mi'i pote Iesui ipy'ahak hawyi iha'at kahato i'atue­wawi i'atu­py'a heg nakaria kape yt ta'a­tu­ky'e i ipo kĩ'ã rakat pote. Mi'i hawyi to'e i ipo kĩ'ã rakat pe — Erepo­torok to uhyt e. Mi'i hawyi toitorok ta'yn hawyi ipo kokawiat ewy ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mi'i hawyi nagnia ehay enoi haria tuwat ra'yn Iesui kaipyi. Mi'i hawyi tuwat ra'yn morekuat Eroti esura­ra'in kape. Mi'i hawyi mi'iria wywo ta'a­tukat aikotã waku Iesui auka hamuat hap. ");
INSERT INTO mavNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Mi'i hawyi Iesui toto ra'yn topot­mu­'eria wywo tawa Karireia hyemyi'a kape. Mi'i hap upi typy'i kahato miit'in tuwat hupi tawa Karireia kaipy­wiaria tawa Iuteu kaipy­wiaria ");
INSERT INTO mavNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tawa Ieru­sarẽi kaipy­wiaria yi Itumeia kaipy­wiaria Iũtãu hy sakpuaria tuwat hupi i'ewyte mekewat tawa ko'i pya pywiat Tiru kaipy­wiaria tawa Sitãu kaipy­wiaria tuwat tuwat Iesui upi. ");
INSERT INTO mavNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Karãpe Iesui minug wakuap ta'a­tukuap ta'yn hawyi te'e­ru­wa­'a­tunug howawi wuat'i kaipy­wiaria. ");
INSERT INTO mavNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mi'i hawyi itote i'ahu rakaria typy'i kahato Iesui ti'a­tu­moe­hãite. Mi'i pote te'e­ru­wa­'a­tunug kahato howawi hemig hamo. Mi'i pote Iesui to'e towy­ria'in me — Eweterut ro yara uhowawi e. Katu­pono meiũpe uhemig neran haria typy'i kahato e. Ta'i ui'akit kuap ne'i ra'yn ti uhemig neran haria e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mi'i hawyi ahiag ipiit piat rakaria hewo yi tote. I'ewyte ahiagnia kak'i­'a­tu'e. Iesui kapiat te'e­ra­ha'at hawyi — Tupana Sa'yru ti En i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mi'i pote Iesui wãi'e ahiagnia pe — Eipo­'inik to e. Yt ewehenoi tei'o eimikuap uwe Uito hap e Iesui ahiagnia pe. ");
INSERT INTO mavNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mi'i hap totepyi Iesui ta'am na'yn yity'ok tote. Mi'i totepyi toi'a­tu­kaykay tuwe­wawi tomi­'ai­roria 12 miit. Mi'i hawyi toko­ka'at howawi hawyi to'e topot­mu­'eria pe ");
INSERT INTO mavNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","— Uimi­'ai­roria eipe uiwywuat wuat'i e'at piat ieĩne'en haria eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Uimi­po­'o­roria ahiag sopo hanuaria ti eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sa'a­wy'i toikaykay tuwe­wawi Simãu. Mi'i hawyi tutum het pakup Simãu me PETERU Nu e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Mi'i hawyi toikaykay TIAKU Sepeteu sa'yru tuwe­wawi hawyi toikaykay Tiaku ywyt IUWÃU tuwe­wowi. Mi'i hawyi mi'iria pe Iesui tum i'atuset pakup Ipuehay rakaria e ma'ato Iesui pusu puo Puanesei e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Mi'i hawyi toi'a­tu­kaykay tuwe­wawi temiit'in ÃTERE WIRIPI PATORUMEU. Mi'i hawyi toikaykay MATEU TUME tuwe­wawi. I'ewyte TIAKU Auweu sa'yru hawyi TATEU hawyi SIMÃU SERATI torania toi'a­tu­kaykay. ");
INSERT INTO mavNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Torania toikaykay IUTA Ikarioti sa'yru. Mi'i ti meiũran ima'at hano topy­hu'at. ");
INSERT INTO mavNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mi'i hawyi Iesui ta'aipok i ra'yn yity'ok kaipyi netap kape towy­ria'in nywo. Mi'i hawyi miit'in te'e­ru­wa­'a­tunug kahato i ra'yn howawi typy'i kahato. ");
INSERT INTO mavNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mi'i pote yt aikotã kuap i te'e­renuk. Mi'i hap ti iywyt'in tikuap ta'yn hawyi te'e­ro'e to'ope — Meiẽ Aheyke'et Iesui wyti heso'ok ta'yn yt tenuk i pote i'atu'e to'ope. Mi'i hawyi tuwat ra'yn Ta'a­tuy­ke'et Iesui enõtem hamo. Waku watioto i ai'yat kape kat pote ti heso'ok ta'yn i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","I'ewyte miwan enoi haria Ieru­sarẽi kaipy­wiaria to'oehay to'ope — Ta'i watikuap ta'yn Iesui hepap ahiagnia pore­nõtem miit'in mywiat hap i'atu'e. Ta'i ahiagnia porekuat aipusu puo Peusepu toĩne'en Iesui piit pe pote toi'a­tu­po­'oro kuap ahiagnia sa'ag i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mi'i pote Iesui ti'a­tu­kaykay miit'in tuwe­wawi hawyi to'e i'atuepe — Uiwy­ria'in e ahenoi teran ehepe uhehay iã'ãkap wuo e. Are pãi kat hamo ten ahiag tuwe­sopo are e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yt aikotã kuap i wyti ren e. Katu­pono yt karãpe i tuwe­sopo kuap miit piit pyi ahiag e. Katu­pono karãpe wẽtup setama pe miit'in tu'uka tu'uka to'ope meiũran ti mekewat setama pe yt uwe i ra'yn topy­hu'at e. Kat pote to'o­'atoiat yne yne e yt kat i wo'o­wese hap itote pote e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","I'ewyte ti karãpe miit'in wẽtup yat pe tu'uka tu'uka to'ope meiũran ti yt uwe i ra'yn topy­hu'at mekewat yat pe to'o­'a­tu­'uka pote e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mi'i hap ewy kahato karãpe ahiag tuwe­'uka tuwete meiũran tuwe­moma hap yn topy­hu'at e. I'ewyte sero­'ok'e hat yt teke kuap i surara hesaika rakat yat pe heka­re'en ero'ok hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ma'ato sa'a­wy'i toipo'i po'i hesaika rakat mi'i hawyi ti tote­ro'ok kuap heka­re'en e. Mi'i pote ti rat toipo­hari kuap ahiag e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Pywo ti are'e ehepe yne ehehay yt nakuap i ko'i Tupana timo­hãpyk kuap ma'ato ehehay yt nakuat i Tupana Pã'ãu kapiat ti ihay uhepiat turan Tupana yt timo­hãpyk kuap i — Mi'i Miit Uha'yru sese e Tupana Pã'ãu ehepe turan — Eso kahato ewei'e tope hawyi Tupana yt tomo­hãpyk kuap i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mi'i e hat ti Tupana mi'a­piheg hano topy­hu'at wuat'i e'at pe. Katu­pono Tupana yt timo­hãpyk kuap i — Yt uimohey teran i e hat. Tupana Pã'ãu wakuat etiat — Eso kahato to'e hawyi ihay uhetiat turan. Mi'i e hat wuat'i e'at piat Tupana mi'a­piheg hanuat topy­hu'at e Iesui tomohey hap pun haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesui to'e mio tã e katu­pono Iesui ete sa'a­wy'i te'e­ro'e — Ahiag pã'ãu toĩne'en Iesui piit pe i'atu'e pote. ");
INSERT INTO mavNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mi'i turan put'ok­'i­'a­tu'e Iesui ywyt'in inyt'in ity wywo Ta'a­tuy­ke'et ereto tawa Nasare kapiat hamo. Mi'i hawyi typy'i kahato Iesui apypueri wo pote ity'in yt teke kuap i Iesui ewawi. Mi'i pote sehay ta'a­tu­po­'oro Iesui kaykay hamo oken kape ipotmu­'eria py'a­setpyi. ");
INSERT INTO mavNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mi'i hawyi Iesui apypueri haria henoi tope — Urumu'e hat ety eywyt'in einyt'in ekaykay oken kape i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mi'i hawyi Iesui ti'a­tu­wesat — U e uweĩ uity e uweĩ uheywyt'in e uweĩ uheinyt'in e. ");
INSERT INTO mavNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mi'i hawyi teha'at ta'a­py­pueri haria kape tomohey haria kape hawyi to'e ");
INSERT INTO mavNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","— Meiũpe ti uity uheywyt'in uheinyt'in e. Katu­pono Tupana ehay pe pywo e haria wyti uheywyt'in uheinyt'in uity'in e. Ui'ywot miky­'esat nug haria eipe pote Uheywyt'in uheinyt'in uity'in wo eweipy­hu'at e Iesui ta'a­py­pueri haria pe i'ewyte ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mi'i hawyi Iesui toto i ra'yn yi Karireia hyemyi'a e'yikyt'ok upi miit'in atumu'e hamo. Mi'i hap tote typy'i rakaria te'e­ru­wa­'a­tunug howawi. Mi'i hawyi Iesui teke yara pe. Mi'i hawyi ta'apyk yara pe yowa tote­pywiat miit'in atumu'e hamo. Mi'i pytkai miit'in yi kyt upi tukup­te'en. ");
INSERT INTO mavNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mi'i hawyi tohenoi henoi sehay iã'ãkap wuo i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","— Eweiwa­nẽtup o e. Wẽtup e'at pe so hã'ỹi sytpok hat toto toko kape hã'ỹi sytpok hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Put'ok­to'e ra'yn go totiat hawyi tohytpok ta'yn hã'ỹi te'yi go pe ma'ato yt yne i hã'ỹi hewo go sese tote. Irania'in so hã'ỹi hewo go pu'ap upi. Mi'i ko'i ti weitaria tu'u ne'i e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma'ato irania'in hã'ỹi ti hewo yi hit nu totiat rote. ");
INSERT INTO mavNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mi'i ti meremo hẽtyt ma'ato meiũran at hakup hawyi ti iku'uro ra'yn itotiat hapo yt toto kuap i yi piit kapiat pote e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mi'i hawyi so irania'in hã'ỹi hewo tuereto i'anam me e. Mi'i ko'i so hẽtyt wen ma'ato i'anam wywo to'o­'ewy ne'i. Mi'i pote meiũran i'anam tohik ne'i ra'yn hawyi yt tuwenug i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma'ato irania'in hã'ỹi yi wakuat rote go sese tote hewo e. Mi'iria ti hẽtyt meremo hawyi ihãite kahato hawyi haat kahato e. Mi'i ko'i kaipyi toimo­rania haat karan karan iã'ỹi hawyi toipuẽti 30 iã'ỹi. Wẽtup sat kaipyi toipuẽti 60 ra'yn. Wẽtup kaipyi 100 ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Uhyt'i'in Mana'in ehewaure ka'a pote eweikuap to kat som are'e teran eimu'e hap uhehay iã'ãkap wuo hap e Iesui yẽpe upiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tuwat porap i ra'yn yne miit'in hawyi iwyria'in 12 ok takaria apo'i­'a­tu'e Iesui pe — Urumu'e hat kat ete som mesuwat hã'ỹi hã'ãkap wuo urumu'e i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mi'i hawyi Iesui ti'a­tu­wesat — Ta'i uiwy­ria'in ahenoi teran ehepe wuat'i mikuap yt heremo i aikotã Tupana topy­hu'at irane Miit'in Porekuat no hap etiat e. Ma'ato irania'in me pya aikawiat haria pe yt uimohey teran i haria pe ahenoi teran sehay iã'ãkap wuo e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mi'i tupono uhehamo ma'ato yt ta'a­tukuap i kat are'e sese hap mi'iria e. Te'e­ra­'a­kasa yne ma'ato yt heremo i rakat e. Mi'i pote yt karãpe i te'e­ra­'aipok Tupana kape ta'a­tu­minug yt nakuap i pyi ta'a­tu­mo­hãpyk Tupana piat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Koitywy kat poteĩ yt eweikuap i mesuwat mikoi iã'ãkap sehay e. Aikotã aru pyno eweikuap irania'in uimienoi iã'ãkap ewywuaria e topot­mu­'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pyno ahenoi ehepe eweikuap sese hamo e. Mekewat iã'ỹi sytpok hat ti Tupana ehay enoi moherep hat ewy e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mi'i hawyi mekewat go pu'ap ẽpe upiat ti wẽtup ok wẽtup ok wanẽtup haria ewy e. Mi'iria tote hawyi Tupana ehay hewo mikoi hã'ỹi ewy ma'ato ta'a­tukuap sa'ag hawyi meremo ahiag tihep te'en te'en i'atu­py'a pyi Tupana ehay e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","I'ewyte ti mekewat iã'ỹi hin nu totiat ti wẽtup ok wẽtup ok wanẽtup hat ewy e. Ta'a­tu­wa­nẽtup hawyi meremo waku kahato ta'a­tu­puẽti e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma'ato yt i'atu­sopo i pote yt toĩne'en mot'i e. Meiũran irania'in miat ta'a­tu­sa­ty'i saty'i Tupana ehay mohey i'atu'e piat pote mi'i hawyi meremo ta'a­tu­'atoiat Tupana ehay e. Sa'a­wy'i i'atu­wepit kahato ma'ato irania'in to'o­ky­ry'i e i hawyi meremo ta'a­tu­waure ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","I'ewyte ti mekewat hu ypia piat ewy toĩne'en e. Mi'iria ta'a­tu­wa­nẽtup Tupana ehay kape. ");
INSERT INTO mavNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ma'ato meiũran hawyi te'e­ru­wa­nẽtup ta'a­tu­potpap iwato hap kape ta'a­tue­ka­re'en iwato hap kape. Ta'a­tu­mi­ky­'esat wuat'i hap kape yn te'e­ru­wa­nẽtup. ");
INSERT INTO mavNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mi'i pote Tupana ehay yt tuwenug i e. Ma'ato mekewat yi wakuat upiat ti wẽtup ok wẽtup ok wanẽtup haria ewy e. Sa'a­wy'i ta'a­tu­wa­nẽtup Tupana ehay kapiat hawyi ta'a­tu­ky­'esat kahato. Mi'iria tuwenug na'yn e. Ta'i wẽtup ok 30 hap ewy wẽtup ok 60 hap ewy hawyi wẽtup ok 100 hap ewy ra'yn Tupana ehay tuwenug kahato ra'yn i'atuieĩ­ne'en hap tote e Iesui topot­mu­'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mi'i hawyi Iesui henoi wẽtup iã'ãkap sehay teka­tu­wy­ria'in me — Wãtym mote wyti miit'in topag ariãty ywaiti heiam note ta'a­tupag hẽtyhot hamo e. Ma'ato yt uwe i ariãty ipag neran yrysakag ywyt'ok­pype e. Ta'i yt uwe i tuwe­'a­riã­typag neran yparakai ywyt'ok­pype e. Yt naku i mi'i tã. Iwat heiam me yn waku ariãty e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Katu­pono meiũran imierewyi tuwe­mo­herep e i'ewyte huwy piat meiũran heremo e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ehewaure ka'a pote eweikuap to uiwy­ria'in e Iesui tomohey haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Eweiwa­nẽtup to sehay kape e. Imõ'ẽ haria wyti aru po'og hereko e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Meiũran po'og na'yn Tupana tum ehepe e. Ma'ato yt eweimõ'ẽ Tupana miium pote mekewat kurin kat toihep yne eipo pyi. Tupana piat einãpin hap eweimu'e irania'in me pote po'og tehay tutum ehepe e. Ma'ato yt eweimu'e irania'in me i Tupana piat einãpin hap ko'i pote ti aru toihep yne i ra'yn to'e hap eipy'a pyi eimikuap hit e. Mi'i hawyi po'og yt kat i sa'a­wy­'iwuat kai topy­hu'at eiwa­nẽtup hawe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","— Ta'i mi'i tã ti Tupana topy­hu'at irane Miit'in Porekuat no aikotã hã'ỹi koi hat ewy ti aru e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sa'a­wy'i toikoi hawyi tuwewi hẽtyt ra'yn ma'ato ikoi hat toĩne'en to'yat pe mi'i turan hẽtyt e. Mi'i hawyi itag na'yn mi'i hawyi haat ra'yn ma'ato ikoi hat yt uwe i itote pytkai i'ewyte yt ta'a­kasa hin i aikotã itag hap kape pytkai e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ta'i mekewat at esaika hap upi mekewat iã'ỹi tuwe­moe­hãite tuwepyi e. Mekewat go koi hat toket turan hewyry turan hẽtyt ra'yn tuwe­motag na'yn haat ra'yn. Mi'i hawyi iko nug hat toto ra'yn ta'a­kasa hamo hawyi — Waku kahato e uimi'u ra'yn e yt uipotpap i pytkai tuwenug pãi e tuwepe e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Waku yne hawyi toiterek kyse'yp wo e. Mi'i uhehay iã'ãkap ewy kahato Tupana tuwenug Morekuat no mesuwat yi tote e Iesui topot­mu­'eria pe apo'i­'a­tu'e hap wesat hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mi'i hawyi Iesui henoi po'og na'yn wẽtup iã'ãkap sehay towy­ria'in me — Are pãi aikotã Tupana topy­hu'at Miit'in Porekuat no. Mi'i hap ete ahenoi teran ehepe sehay iã'ãkap wuo e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ta'i aimikoi iã'ỹi kurin kat Mutata iã'ỹi ewy ti. Eweikoi yi pe hawyi hẽtyt hawyi meremo topy­hu'at itag i'yp e. Ywaiti ra'yn hawyi weitaria te'e­ru­we­soknug na'yn haga tote i'yhop og me. ");
INSERT INTO mavNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Aikotã aimikoi yt kat iã'ỹi ok tã rakat i po'og kurin kat wen ma'ato meremo i'yp uato ra'yn e. Mi'i hap ewy ti Tupana topy­hu'at irane Miit'in Porekuat no e Iesui i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Miit'in me Iesui henoi henoi kahato sehay hã'ãkap wuo yn tohenoi yt i'atu­mikuap wuo i. ");
INSERT INTO mavNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma'ato tuweran hawyi topot­mu­'eria sese pe tohenoi sese kat e kat e tohenoi hã'ãkap wuo hap. ");
INSERT INTO mavNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","At min'e turan Iesui to'e — To'iro ysakpo uhyt'i'in mesuwat yara puo e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mi'i hawyi ta'a­tu­hok­'iwat ra'yn yẽpeke typy'i rakaria. Mi'i hawyi ma'ato ipat'ok irania'in tuwat hupi hewat­'ymo yara ko'i puo. ");
INSERT INTO mavNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mi'i turan Iesui toket ne'i yara etu'a pe to'akag pysop tote. Iket kai ti ihyemyi'a wato py'a­setpiat turan ywytu kahato ra'yn ywytu uato kahato ra'yn. Mi'i hawyi y'y teke teke ra'yn i'atue­'yara pe. ");
INSERT INTO mavNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mi'i hawyi hemiit'in to'o­kak'i te'e­ra­'a­py'at irane ihy wato ta'a­tue­'yara piat pote. Mi'i hawyi meremo te'e­ru­wẽ­powat ta'a­tuehay pirik wo Iesui kape — Urumu'e hat erehymut ro i'atu'e. Yt uruky'e i apo En i'atu'e. Urutopap hamuat ra'yn wyti i'atu'e minwa­to'e Uhyt i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mi'i hawyi Iesui ipoĩ'ãm na'yn hawyi to'e ywytu uato pe ihy esaika rakat pe — Epo'inik to y'y e epohep to wasere wato e. Mi'i hawyi meremo wasere ipohep hawyi y'y i'ewyte ipo'inik ta'yn. Mi'i hawyi ihy nik kahato ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mi'i hawyi to'e towy­ria'in me — Uhyt'i'in e kat poteĩ eweiken'ẽ uimohey haria eipe pytkai e. ");
INSERT INTO mavNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mi'i hawyi te'e­ro­ken'ẽ po'og ne'i hawyi apo'i­'a­tu'e to'ope — Yt uwe i mesuwat yi tote Mi'i Miit Iesui ewywuat i'atu'e. Ta'i ywytu y'y tunug kahato Aimu'e hat Iesui mipo­'oro ewy i'atu'e. Uwe pyno Iesui i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mi'i hawyi Iesui hakpo temiit'in wywo yi Karireia hyemyi'a. Mi'i hawyi put'ok­'i­'a­tu'e yi Kata­renu wã tote te'e­ru­wehik ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mi'i hawyi Iesui tuwẽtem yara pyi yi kape. Mi'i hawyi meremo ahiagnia ipiit piat rakat wẽtup ok teput tuerut Iesui kapiat ta'a­kasa hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mi'i so nimo ra'yn toĩne'en wo'osyp hawe yt uwe i ipyhik kuap. ");
INSERT INTO mavNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ha'a­wyte ra'yn karania wo ne'i ra'yn ta'a­tu­pyhik wo'o­pyhik hawe wen ma'ato so toipirik ne'i topyhik hap ko'i. Ta'i kurenti wo ta'a­tu­pyhik ma'ato toitektek ne'i. Mi'i hawyi yt uwe i imope­rup'i hamo topy­hu'at. ");
INSERT INTO mavNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mi'i tã ti mekewat ahiagnia ipiit piat rakat wãtym muo ihot'ok puo miit syp hawe yity'ok tote toĩne'en. Kak'e kak'e yity'ok upi tuwe­witwit nu ko'i wo hawyi haty kahato ra'yn tuwete. ");
INSERT INTO mavNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mi'i turan so ta'a­kasa Iesui kape pya pyi hawyi so teput tuerut ra'yn. Mi'i hawyi put'ok'e Iesui ete hawyi tuwe­pỹ­'ã­tutuk howa kape. ");
INSERT INTO mavNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Mi'i hawyi Iesui pe to'e tehay pirik wo — Kat som etunug neran uhete Iesui Tupana Sa'yru e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mi'i hawyi Iesui to'e ahiagnia pe — Eiwe­nõ'ẽ ro meiũwat miit piit pyi e. Mio tã hawyi toiwesat — Yt urusa­ty'i saty'i tei'o En i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mi'i hawyi Iesui to'e mekewat miit piit piat ahiagnia pe — Kat eĩ pyno ehet e Iesui ahiagnia pe. ");
INSERT INTO mavNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mio tã e hawyi ta'a­tu­wesat — Isem e uruwat uruset Uhyt i'atu'e katu­pono uruty­py'i kahato uruto pote. Pyno yt urupo­'oro tei'o pya meiũpe pyi Uhyt i'atu'e mekewat miit ahiag ipiit piat rakat wẽ pyi. ");
INSERT INTO mavNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mi'i turan hamaut ko'i typy'i rakaria tukup­te'en mekewat yity'ok tote te'e­renuk hap tote. ");
INSERT INTO mavNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mi'i hawyi ahiagnia hẽtup Iesui pe — Meimuẽwat hamaut asuwai ko'i kape ro urupo­'oro i'atu'e. Mi'iria pe mono urutu­we­hyt'ok i'atu'e ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mi'i hawyi Iesui to'e — Eweiwat ro pono e. Mio tã e hawyi tuwe­nõ'ẽ ra'yn ahiagnia mekewat miit piit pyi hawyi tuwe­hyt'ok ta'yn hamaut asuwai ko'i 2000 rakaria piit pe ra'yn tuwe­hyt'ok. Mi'i hawyi hamaut ko'i ikohye­put'i kohye­put'i yity'ok totepyi hawyi tuwe­hyt'ok y'y pe hawyi topap yne ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mi'i hawyi hamaut sem apykok haria ikohyeput ra'yn yi Kata­renu etawa ko'i upi go ko'i upi irania'in miat henoi hamo. Mi'i hawyi so tuwat yne miit'in Iesui kapiat te'e­ra­'a­kasa hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mi'i hawyi te'e­ra­'a­kasa mekewat miit Iesui yatype apyk pe ra'yn waku i ra'yn tuwe­painug me ra'yn toĩne'en yt kat i ra'yn ahiagnia ipiit pe. ");
INSERT INTO mavNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mi'i hawyi ti te'e­ro­ken'ẽ Iesui pupi. Mi'i hawyi ti mekewat õ'ẽ haria pe akasa haria henoi yne ra'yn aikotã aikotã mekewat ahiag ipiit piat rakat etiat hamaut asuwai ko'i topap yne hap etiat. ");
INSERT INTO mavNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mi'i hawyi ta'a­tu­hẽtup hẽtup i Iesui pe — Uhyt Mimi i'atu'e motoro meiũwat uruetama pyi i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mi'i hawyi Iesui teke yara pe turan mekewat sa'a­wy­'iwuat ahiagnia ipiit piat rakat imimoe­hãite tuwẽ­powat Iesui kape — Uipap kahato eupi Mehĩ e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma'ato Iesui tiwesat — Yt wyti waku po'og ni era'aipok i ra'yn e'yat kape hawyi ehenoi henoi mesu­wa­ro­tiaria pe aikotã Uito Eka'iwat pakup eky'e hap aikotã enug waku hap ewyria'in miat hap ti atiky­'esat uha'yru e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mi'i hawyi ti toto ra'yn Iesui yaty­pepyi. Mi'i hawyi wuat'i 10 tawa puaria piat henoi henoi aikotã wakuap Iesui tunug tetiat hap. Mi'i hawyi ikuap haria te'e­ru­wa­nẽtup kahato — Waku kahato Iesui i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mi'i hawyi Iesui toto i ra'yn temiit'in nywo yara puo yi Karireia hyemyi'a wato sakpo. Mi'i hawyi put'ok­'i­'a­tu'e hawyi miit'in tõ'ẽ tõ'ẽ howawi. ");
INSERT INTO mavNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mi'i hawyi miit'in sem ra'yn tukup­te'en yẽpeke. Mi'i hawyi Tupana mõtypot yat ka'iwat wẽtup ok Tupana mõtypot yat akag uhyt Iairu tut Iesui kape. Mi'i hawyi tuwe­pỹ­'ã­tutuk Iesui ewa kape. ");
INSERT INTO mavNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mi'i hawyi tohẽtup Iesui pe haty wo — Mehĩ e uhaki'yt hin iku'uro irane Uhyt e. Pyno to'iro meremo imoehãite hamo e. Ereponug itote hawyi mono ihãite hawyi uhaki'yt yt iku'uro i e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mi'i hawyi toto Iesui Iairu upi. Ma'ato mekewat typy'i rakaria tuwat yne hupi. Mi'i hawyi mu'ap upi ta'a­tu­py­huhik ne'i Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","MI'i hawyi Iesui toto Tupana mõtypot yat akag uhyt Iairu upi miit'in sem tuwat hupi. Mi'i turan ti wẽtup ok hary­poria huu wato rakat toĩne'en i'atu­wywo. Mi'i wyti nimo kahato ra'yn i'ahu. Mi'i wyti 12 anu ra'yn toho­'opot mekewat to'ahu hap. ");
INSERT INTO mavNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mi'i so hewyry mohag nug haria upi. Tutum yne ra'yn teka­re'en mohag nug haria pe. Ma'ato yt naku i po'og po'og ne'i tuwete. ");
INSERT INTO mavNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mi'i turan Iesui etiat toikuap ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mi'i hawyi tuwa­nẽtup ta'yn — Pyno mesup aru areto ra'yn Mimi Iesui upi hesokpe emig hamo e. Mi'i atunug mote mono waku ra'yn uhete e. Mi'i hawyi ti toto ra'yn miit'in typy'i tok puo Iesui ewat'ymo. Mi'i hawyi totemig na'yn hesokpe ete. ");
INSERT INTO mavNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mi'i hawyi meremo waku tuwete hawyi mekewat hary­poria tikuap ta'yn tehãite hap. Toikuap tetiat yt tosuu wato i ra'yn hap. ");
INSERT INTO mavNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mi'i hawyi ma'ato meremo tuwewi Iesui tikuap tesaika wẽtem topiit pywiat miit'in moehãite hamuat hap ko'i. Mi'i pote tuwe­morem na'yn hawyi apo'e topy­huhik haria pe — Uwe kahu uhesokpe emig e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mio tã e pote ipotmu­'eria te'e­ro'e — Urumu'e hat meiũpe ti miit'in sem me watu­kup­te'en typy'i poity'i emig haria i'atu'e. Kat poteĩ — Uwe uhesokpe emig ere i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma'ato Iesui teha'at yne i'atuewa pe. Toikat temig hat uwe hap. Mi'i pote mekewat hary­poria token'ẽ kahato katu­pono toikuap ta'yn tomoe­hãite hap. ");
INSERT INTO mavNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mi'i hawyi tut i ra'yn hawyi tuwe­pỹ­'ã­tutuk howa kape tyry­to'e wywo hawyi tohenoi ra'yn Iesui piat tomoe­hãite hap. ");
INSERT INTO mavNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mi'i hawyi Iesui to'e — Uheinyt ewat uimohey hap emoehãite ra'yn e. Mi'i hawyi ti aru ehãite ra'yn e. Mi'i tupono ewepit ro era'aipok i ro e'yat kape e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mi'i turan Tupana mõtypot yat akag uhyt Iairu emiit'in tõ'ẽ ra'yn i'yat kaipyi. Mi'i hawyi ta'a­tu­henoi Iairu pe — Uruka­'iwat i'atu'e yt naku i kahato ra'yn. Yt kat hamo i ra'yn wyti Wo'o­mu'e hat etiky­'esat katu­pono ti esaki'yt wyti iku'uro sese ra'yn i'atu'e i'ywot Iairu pe. ");
INSERT INTO mavNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma'ato Iesui tikuap hawyi to'e i'ywot pe — Yt ereken'ẽ tei'o e. Uimohey yn no en e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mi'i hawyi typy'i rakaria irania'in Iesui yt tiky­'esat i tuwat yne hap. Temiit'in yn Peteru Tiaku iywyt Iuwãu wywo yn toiky­'esat tuwat hap. ");
INSERT INTO mavNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mi'i hawyi tuwat ra'yn Iairu yat kape. Mi'i hawyi put'ok­'i­'a­tu'e tu'isa yat pe turan miit'in typy'i poity'i ta'a­tu­puẽti wak haria. ");
INSERT INTO mavNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Te'e­ruwak ihay pirik kahato pĩ'ã hin iku'uro pote. Mi'i turan Iesui teke netap we hawyi to'e wak haria pe — Kat poteĩ eweiwak e. Kat poteĩ ehehay pirik e. Yt iku'uro i ti pĩ'ã ma'ato toket ne'i ti e. Mio tã e pote wak haria to'o­ky­ry'i Iesui ete. Mi'i pote wak haria Iesui ti'a­tu­sopo ra'yn i'yat pyi. ");
INSERT INTO mavNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mi'i hawyi toko­ka'at ity i'ywot Iuwãu Tiaku Peteru wywo yn na'yn iku'uro rakat kape. ");
INSERT INTO mavNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mi'i hawyi Iesui ti'y­kesat hawyi to'e iku'uro rakat pe — Pĩ'ã hin epoĩ'ãm no e. ");
INSERT INTO mavNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma'ato towat topusu puo — Tarita kumi e. Mi'i hawyi meremo pĩ'ã hin 12 anu rakat ipoĩ'ãm na'yn hewyry i ra'yn. Mi'i pote te'e­ra­ha'at kahato te'e­ru­wa­nẽtup kahato ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mi'i hawyi Iesui ti'a­tu­nãpin — Pyno ewetopoi ro eimẽpyt e. Ma'ato o yt ewehenoi tei'o pĩ'ã hin ieĩne'en i hap irania'in me e i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mi'i hawyi Iesui toto i ra'yn uhyt Iairu etawa kaipyi towy­ria'in wywo tomotag hap tawa hit Nasare kape. ");
INSERT INTO mavNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mi'i hawyi Tupana mõtypot hap e'at pe Iesui henoi henoi tetawa Nasare piaria pe Tupana mõtypot yat pe. Mi'i hawyi itotiaria te'e­ru­wa­nẽtup kahato. Mi'i hawyi te'e­ro'e to'ope — Yt sa'a­wy­'iwuat meiũpiat pan'i pan'i e hat i apo meiẽ i'atu'e. Yt mana Maria mẽpyt i apo Mi'i Miit i'atu'e. Yt Tiaku Iuse Iuta Simãu eyke'et i apo Mi'i Miit Iesui i'atu'e. I'ewyte iwat yt Iesui einyt'in i apo tukup­te'en meiũpe i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Uwe som pyno mekewat we'eg hap henoi Iesui pe i'atu'e. Hawytepyi ipatpap mesuwe tawa Nasare pe wuat'i aria'yp kawiat hap nug hanuat i'atu'e. Katu­pono som pono tohepap kahato wuat'i wakuap nug hanuat i'atu'e ra'yn. Uwe som mesuwat tesaika hap henoi tope Tupana ewywuat nug hamo i'atu'e to'ope. Mi'i hawyi yt ta'a­tu­mohey hin i Iesui haype. Mi'i pote Iesui yt timoherep kuap i wakuap Tupana mimoherep yt uwe tunug kuap i hap i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kurin Kurin tutunug tesaika wo tawa Nasare pe. Wẽtup ok wẽtup ok yn toimoe­hãite topo wo i'ahu rakaria. ");
INSERT INTO mavNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma'ato yt tomohey i haria pe yt tutunug kuap i aikotã aikotã e hap ko'i. Yt tomohey i haria kape tuwa­nẽtup kahato — Kat pote yt uimohey i uimotag haria e tuwepe. ");
INSERT INTO mavNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mi'i pote to'e i'atuepe — Irania'in setama puaria wyti imohey kahato Tupana ehay moherep hat e. Ma'ato iwat hetama puaria ti yt imohey i e. Iwat i'ywania sese ti i'ewyte yt imohey i e. I'yat piaria i'ewyte yt imohey i e Iesui tetawa Nasare piaria pe tomotag hanuaria pe yt tomohey i haria pe. Mio tã e hawyi toto ra'yn tomotag hap tawa Nasare pyi irania'in tawa hit ko'i kape henoi henoi ipuat hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mi'i turan Iesui tikaykay temiit'in tuwe­wawi. Mi'i hawyi tutum na'yn tesaika hap ahiag sopo hamuat towy­ria'in me 12 ok takaria pe. Mi'i hawyi toi'a­tu­nãpin — Uipot­mu­'eria e koitywy woro­ho­'o­po­'oro wuat'i tawa piaria mu'e hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Typy ok tuereto woro­ho­'o­po­'oro e. Pyno waku ti ewetioto eheka­re'en kurin kurin mu'ap upianuat e. Esokpe epiit etiat yn etioto e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Waku epy sokpe epy etiat yn etioto are. Epo'yha wẽtup waku e. Waku yt kat i eimi'u mu'ap upianuat ewetioto e. Waku yt kat i ehesokpe eiam e. Waku yt kat i mu'ap sa'up ape ewetioto e. Waku sokpe eipiit piat yn ewetioto are. ");
INSERT INTO mavNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mi'i hawyi put'ok­'e­wei'e wẽtup tawa pe hawyi waku wuat'i e'at pe ti wẽtup getap we yn ewehenuk i'ewyte eweiket e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma'ato tawa piaria yt i'atu­wese i ehete yt te'e­ru­wa­nẽtup teran i eimienoi uhetiat kape mi'i pote eweiwat i ra'yn i'atue­tawa pyi e. Eiwe­nõ'ẽ hamo waku meiẽwat tawa sawiu eipy etiat ko'i eiwe­py­pit­pit'ok kahato i'atue­hamo e. Mi'i tã ewetunug hawyi ti aru ta'a­tukuap ta'yn Tupana etiat yt ta'a­tu­wese i hap e Iesui topot­po­'o­roria 12 ok takaria pe. Mi'i hawyi tuwat ra'yn typy ok tuereto tawa ko'i upi Iesui yaty­pepyi ihay enoi hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Put'ok­ta­'a­tu'e hawyi mio tã i'atu'e miit'in me — Koitywy ewei'atoiat ro yt nakuap i eiminug ko'i hawyi ewei'aipok to Tupana etiat kuap hamo i'atu'e miit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mi'i hawyi i'ewyte ahiag ko'i ta'a­tu­'a­tu­sopo miit'in piit pyi. I'ewyte ikap takat wo ta'a­tupen i'ahu rakaria akag hawyi i'atue­hãite ra'yn. Miit'in te'e­ru­we­wa­nẽtup kahato uwe Iesui e hap ete. ");
INSERT INTO mavNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mi'i hawyi yne ra'yn ikuap Iesui etiat ipotmu­'eria 12 ok takaria wẽ pyi. Mi'i hawyi mio tã hap morekuat Eroti tikuap hawyi to'e tuwa­nẽtup hawe — Iuwãu ta'aipok ta'yn gu'uro pyi e. Iesui wyti wo'o­set'ok hat Iuwãu toĩne'en i ra'yn gu'uro pyi e. Mi'i tupono ti tote­reko hesaika hap e morekuat Eroti Iesui etiat. ");
INSERT INTO mavNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mi'i hawyi wẽtup ok wẽtup ok to'e — Iesui wyti Tupana ehay moherep nimuat hat i'atu'e. Ma'ato irania'in — Ta'i Tupana ehay moherep hat sa'a­wy­'iwuat Eria wyti Iesui i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma'ato morekuat Eroti to'e tuwe­wa­nẽtup hawe — Are pãi atikuap wyti uwe sese hap e. Ta'i Iuwãu uimi­'akag tek wyti e tuwe­wa­nẽtup. Ta'i toĩne'en i ra'yn gu'uro pyi e tuwa­nẽtup hawe morekuat Eroti Iesui etiat. ");
INSERT INTO mavNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mio tã to'e katu­pono sa'a­wy'i morekuat Eroti toywyt Wiripi ehary'i wywo mana Erotia e hap het rakat wywo toĩne'en. ");
INSERT INTO mavNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mi'i pote sa'a­wy'i te ahet'ok hat Iuwãu to'e morekuat pe — Wãi'e yt naku i ti ereĩne'en eywyt ehary'i wywo ne'i e tope. Mio tã e pote morekuat ti'a­tu­po­'oro tesu­ra­ra'in Iuwãu sat hamo ipo'i po'i hamo. Mi'i hawyi iheg me ta'a­tupag. ");
INSERT INTO mavNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mi'i hawyi morekuat ehary'i pakup Erotia yt iwese hin i Iuwãu ete. Toi'auka teran ma'ato yt toi'auka kuap i katu­pono Iuwãu pupi he'aito token'ẽ kahato. ");
INSERT INTO mavNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Morekuat Eroti tikuap ta'yn Iuwãu wakuat kahato hap. Mi'i hawyi toika­wiano Iuwãu katu­pono morekuat tikuap teran Iuwãu ehay aikotã kahato hap. Toikuap hawyi ikenmu'e kahato tuwete. ");
INSERT INTO mavNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mi'i hawyi wẽtup e'at pe morekuat Eroti ywã'ĩ hap kapiat wa'a­tunug hap e'at pe tõ'ẽ tõ'ẽ hesu­ra­ra'in akagnia te'e­renuk hamo. Te'e­ru­wa­'a­tunug tu'i­saria yne yi Karireia kaipy­wiaria tõ'ẽ tõ'ẽ. ");
INSERT INTO mavNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mi'i hawyi i'atu­wa­'a­tunug hawe teke ihary'i hit Erotia mẽpyt ikahu rakat tehairu tuweran hamo. Mi'i hawyi tehairu waku ra'yn hawyi morekuat Eroti iwepit kahato ienuk haria wywo. Mi'i hawyi to'e pĩ'ã makuptia pe — Ehairu hap ikahu kahato pĩ'ã e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pyno ehẽtup to kat som etiky­'esat e. Mi'i hawyi kat emiẽtup atum epe ehẽtup pote e. Ta'i etiky­'esat pote uhe'yi ipat'ok atum epe pĩ'ã e morekuat ihairu rakat pe. ");
INSERT INTO mavNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mi'i hawyi pĩ'ã toto toty kape ihay kuap hamo hawyi to'e — Mamai e kat som waku ahẽtup morekuat pe e. Mi'i pote ity to'e e — U an e pyno ehẽtup to miit'in set'ok hat Iuwãu akag. Mi'i som yn waku e mana Erotia pĩ'ã pe. ");
INSERT INTO mavNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mi'i hawyi pĩ'ã ta'aipok meremo ra'yn morekuat piat henoi hamo. Put'ok­to'e hawyi pĩ'ã to'e — Pyno mesup uito atiky­'esat warupy hit piat Iuwãu akag e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mio tã e pote morekuat iperup ta'yn yt iwepit hin i ra'yn. Yt toi'auka teran i Iuwãu haype ma'ato sa'a­wy'i mio tã e pĩ'ã piat hap iwywuat ienuk haria tikuap ta'yn kat e hap. ");
INSERT INTO mavNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mi'i pote toipo­'oro ra'yn wẽtup ok surara Iuwãu auka hamo. Mi'i hawyi toto ra'yn wo'o­pyhik hap kape i'auka hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mi'i hawyi toterut warupy hit pe imiẽtup Iuwãu akag hawyi tutum na'yn pĩ'ã pe. ");
INSERT INTO mavNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mi'i hawyi pĩ'ã hum na'yn toty pe. Mi'i hawyi Iuwãu potmu­'eria tikuap ta'yn i'auka hap hawyi tõ'ẽ ra'yn hyp nu ka'a piat hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mi'i hawyi imipo­'o­roria 12 ok takaria te'e­ra­'aipok i ra'yn Iesui ewawi wo'o­pot­mu'e haria wuat'i tawa kaipyi. Mi'i hawyi ta'a­tu­henoi henoi Iesui pe aikotã ta'a­tu­minug ko'i i'ewyte ta'a­tu­mienoi wuat'i tawa puat ko'i. ");
INSERT INTO mavNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mi'i hawyi typy'i kahato õ'ẽ õ'ẽ haria tukup­te'en itote mi'i pote yt te'e­renuk kuap i ra'yn typy'i poity'i pote. Mi'i pote Iesui to'e topot­mu­'eria pe — To'iro wato aiweran aikope yt uwe i miit'in hap kape aiwe­mohy hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mi'i hawyi typy'i rakaria kaipyi Iesui toto ra'yn temiit'in wywo yara puo ihyemyi'a sakpo. ");
INSERT INTO mavNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma'ato irania'in tikuap ta'yn iwat hap hawyi yi upi wuat'i kaipyi miit'in te'e­ru­wa­'a­tunug aikowo Iesui toto hap kape. ");
INSERT INTO mavNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mi'i hawyi Iesui tuwehik hawyi tuwẽtem yara pyi. Mi'i turan yahig note yẽpeke toi'a­tu­puẽti miit'in typy'i kahato yt tuweran hin i. Mi'i hawyi ma'ato toi'a­tu­ky'e kahato katu­pono toi'a­tu­puẽti aikotã hũria Uweuria ko'i ewy aikotã yt ika'iwat rakaria i ewy toi'a­tu­puẽti. Mi'i hawyi Iesui ti'a­tu­mu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wãtym irane ra'yn hawyi Iesui potmu­'eria tõ'ẽ Iesui kape te'e­ro'e hamo — Wãtym irane ra'yn wyti Uhyt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yahig note ne'i ti watu­kup­te'en mi'i pote eti'a­tu­po­'oro i ro hesy'at rakaria i'atue­tawa ko'i kape i'atu'e. Waku netap ko'i kape tuwat mi'u kyi'at hamo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma'ato Iesui ti'a­tu­wesat — Yt rat waku ewei'a­tupoi hesy'at rakaria e. Mi'i hawyi ta'a­tu­wesat — Aikotã etiky­'esat Mehĩ miit'in sem poi hap i'atu'e. Etiky­'esat man iwato wati­kyi'at miit'in mi'u wo i'atu'e. Katu­pono 200 e'at motpap sa'up yn put'ok'e i'atupoi hap sa'up mo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mi'i hawyi Iesui to'e temiit'in me — Karania a pyno aheman e. Ewei'a­kasa ro pyno e. Ta'a­tukuap hawyi ta'a­tu­henoi — 5 man typy pira yn Uhyt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mi'i hawyi Iesui to'e temiit'in me — Ewei'apyk to mopep hyp tote ewei'e ro miit'in me e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mi'i hawyi te'e­ra­'apyk ta'yn kowo 50 ok kowo 50 ok kowo 100 ok kowo 100 ok. 5000 rakaria yne mopep hyp tote. ");
INSERT INTO mavNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Waku hawyi Iesui tat 5 man typy pira hit topo pe hawyi iha'at ywaipe hawyi to'e — Waku kahato En Tupana e. Urupoi kahato hat En e. Mi'i hawyi toipat'ok kahato mekewat 5 a man 2 pira hit rakat towy­ria'in me. Mi'i hawyi mi'iria imõ'ẽ irania'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Toi'a­tu­mi­'u­mo­wato kahato ra'yn. Mi'i hawyi ti te'e­renuk kahato ra'yn hawyi i'atu'ok kahato ra'yn tukup­te'en. ");
INSERT INTO mavNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mi'i hawyi i'atu­mi'u ieĩpyt topy­hu'at re 12 eyry­sakag ne. ");
INSERT INTO mavNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mekewat e'at pe Iesui ti'a­tupoi 5000 ihainia 5 man wo yt miit minug kuap ewy hin i tutunug kuap Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Te'e­renuk waku hawyi Iesui ti'a­tu­po­'oro ra'yn temiit'in ihyemyi'a sakpo tawa Petsaita kape. Mi'i hawyi irania'in tomipoi ko'i i'ewyte toi'a­tu­po­'oro i'atue­tawa ko'i kape. ");
INSERT INTO mavNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Toi'a­tu­sopo yne yne hawyi Iesui toto ra'yn yity'ok kape. Mi'i hap tote tuweran na'yn hawyi ihay Tupana wywo. ");
INSERT INTO mavNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wãtym irane hawyi teha'at ihyemyi'a kape towy­ria'in kape. Mi'i turan wasere kahato i'atuewa kapiat pote yt i'atu­hyha i iwyria'in iha'at turan. ");
INSERT INTO mavNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mi'i pote waipaka ehay hap owakai Iesui toto ra'yn temiit'in ewat'ymo yowa tote. ");
INSERT INTO mavNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma'ato te'e­ra­'a­kasa Iesui kapiat hawyi to'o­kak'i — Kat kahu meke i'atu'e. Miit ehog keĩ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mi'i hawyi i'atu­wuwu kahato ra'yn. Mi'i hawyi Iesui to'e — Uiwy­ria'in Uito rat yt eweiken'ẽ tei'o e. ");
INSERT INTO mavNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mio tã to'e hawyi Iesui teke ra'yn yara pe temiit'in wywuat pe ra'yn. Teke hawyi meremo ywytu ipohep ta'yn. Mi'i pote te'e­ru­wa­nẽtup aikotã aikotã Iesui hewyry yowa tote hap kape. ");
INSERT INTO mavNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Katu­pono sa'a­wy'i te'e­ra­'a­kasa Iesui minug ko'i 5 man etiat ma'ato yt ta'a­tukuap i uwe sese Iesui hap i'atu­py'a heg mote yt ta'a­tu­mohey kuap i. ");
INSERT INTO mavNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mi'i hawyi put'ok­'i­'a­tu'e tama Kene­sare wã tote i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te'e­ru­wehik yẽpeke hawyi tuwẽtem na'yn yara pyi. Mi'i hawyi meremo yi Kene­sare piaria tikuap Iesui mi'i pote yni puo ta'a­tue­ro­po'ok i'ahu rakaria kope pyi kope pyi ra'yn howawi. ");
INSERT INTO mavNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mi'i hawyi ta'a­tu­hẽtup i'atu­moe­hãite hamuat hesokpe emig hamo. Mi'i hawyi tewyry hap upi toi'a­tu­moe­hãite kahato i'ahu rakaria i'atu­mierut ko'i. Mi'i turan yne mu'ap upi tukup­te'en i'ahu rakaria Iesui esokpe emig neran haria. ");
INSERT INTO mavNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tawa wato pu'ap upiaria tawa hit pu'ap upiaria go pu'ap upiaria tawa e'oken upiaria i'atue­tama pu'ap upiaria yne yne Iesui ti'a­tu­moe­hãite i'ahu rakaria tesokpe emig haria. I'ahu rakaria ta'a­tuerut kahato Iesui ewawi hawyi Iesui hewyry hap upi ta'a­tuemig hesokpe yne mu'ap upi hawyi yne yne temig haria toi'a­tu­moe­hãite tomohey hap ok tã. ");
INSERT INTO mavNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wẽtup e'at pe te'e­ru­wa­'a­tunug kahato Iesui kape nagnia ehay enoi haria i'ewyte miwan enoi haria tawa wato Ieru­sarẽi kaipy­wiaria wywo. ");
INSERT INTO mavNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mi'i hawyi ta'a­tuenuk hap tote te'e­ra­'a­kasa Iesui ekatu­wy­ria'in yt te'e­ru­we­posei i nagnia mienoi yt ewy i. ");
INSERT INTO mavNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mi'i hawyi te'e­ra­ha'at kahato katu­pono yne Iuteu ywania te'e­ru­we­posei yne te'e­renuk hamo. Kare'en kyi'at haria te'e­ruwei yne. ");
INSERT INTO mavNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Yt te'e­ruwei i pote yt te'e­renuk kuap i. Ta'i niatpo kahato ti i'atu­we­pokuap hap. Katu­pono yne ta'a­tupyi wuat'i y'y eiam ko'i mi'u eiam ko'i wuat'i ta'a­tupyi te'e­renuk hamo. Aikotã nagnia inug sa'a­wy'i hap ewy ta'a­tunug. ");
INSERT INTO mavNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mi'i hap yn ta'a­tunug. Ma'ato irania'in Iesui mohey haria yt te'e­ru­we­pokuap i mi'i tã. Mi'i pote nagnia ehay enoi haria miwan enoi haria apo'i­'a­tu'e Iesui pe — Wo'o­mu'e hat kat poteĩ emimu­'eria yt te'e­ru­we­posei posei i urumu'e haria ewy i i'atu'e. Kat poteĩ yt ta'a­tunug i ainãpin sa'a­wy­'iwuat hap ko'i i'atu'e. Katu­pono ti aipo pitpit hap wywo yt naku i watu'u aimi'u yt naku i i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mi'i pote Iesui ti'a­tu­wesat — Nimo te ti ase'i Isaia henoi tomiwan me ehetiat typy ihay rakat etiat. Mio tã e Isaia — Mi'i tã haria Tupana mõtypot ta'a­tuwẽ pywiat haria yn mi'iria ma'ato yt ta'a­tu­py'a pyi i ta'a­tu­mõ­typot Tupana e Isaia 29.13 pe. ");
INSERT INTO mavNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ta'i mi'iria ti Tupana mõtypot sa'ag ne'i katu­pono yt ta'a­tu­henoi Tupana ehay sese i ma'ato miit'in kaipywiat sehay yn ta'a­tu­henoi e ti Isaia henoi ehetiat e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mi'i hawyi po'og to'e — Ta'i Tupana ehay atoiat haria ti eipe katu­pono nagnia ehay yn ni topy­hu'at eipy'a pe i'ewyte ewehenoi miit'in e hap ko'i ma'ato Tupana e hap meremo eweiwaure are e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ta'i apuete ewei'e ti Tupana miky­'esat ko'i nug hawe hawyi eimi­ky­'esat yn ewetunug at ka'ap. Tupana ehay aikotã waku watunug e hap pun haria eipe wen ma'ato ei'e hap aikotã waku watunug e hap ewetunug kahato. ");
INSERT INTO mavNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nimo te ti Tupana tinãpin tehay moherep hat Musei — Waku ti eimẽ­pyt'in eimõ­typot hanuaria wo tukup­te'en are e. Waku ta'a­tuty ta'a­tu­'ywot ky'e kahato haria wo te'e­ro­py­hu'at e. Ma'ato yt kat i ta'a­tu­ty'in ta'a­tu­'y­wot'in mõtypot hap i'atuete pote ta'a­tu­sa­ty'i saty'i ta'a­tu­ty'in ta'a­tu­'y­wot'in. Waku mi'iria miit'in ti'a­tu­sa­ty'i saty'i nu wo ta'a­tu­ku­'uro hap kape e Tupana sa'a­wy'i Musei pe mekewat Esutu 20.12 piat pe. ");
INSERT INTO mavNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma'ato eipe wẽtup sehay moherep haria e Iesui pa'iria pe nagnia pe. Yt mio tã ewei'e hin i katu­pono mio tã ewei'e — Waku Tupana pe yn eweium eipo hap nug hap ko'i ewei'e sa'ag aha'y­ru'in muo ahaki­'yt'in muo. Waku Tupana yn wati­mõ­typot yt kan hamo i wati­mõ­typot ai'y­wot'in ewei'e sa'ag. Waku watum aity ai'ywot sa'up Tupana pa'i pe ewei'e sa'ag e. Waku watum sa'up aipo hap nug hap ko'i ahepa'i pe uruepe Tupana wanuat ewei'e sa'ag yn eimu'e haria pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yt naku i ti eimienoi katu­pono koitywy yt kat i ra'yn miit'in po hap nug hap ta'a­tu­'ywot ta'a­tuty piat hap e. Yt ta'a­tu­mõ'ẽ hin i ta'a­tu­ty'in ta'a­tu­'y­wot'in me mesup e. Yt naku i are katu­pono mesup yt ta'a­tu­mõ­typot hin i ta'a­tu­ty'in ta'a­tu­'y­wot'in eimienoi sa'ag nagnia ehay upi pyi e. Mi'i pote mesup ta'a­tu­'y­wot'in me — Papai Mamai i'atu'e yt kat i ti koitywy topy­hu'at uikaipyi eipo­wyro hamuat hap i'atu'e katu­pono uimiium ehepiat eipo­wyro hamo atum yne ra'yn Tupana mõtypot yat piaria akag ko'i pe i'atu'e sa'ag eimienoi upi ma'ato yt Tupana e hap ewy hin i ei'e hap ko'i are. ");
INSERT INTO mavNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ta'i mi'i hap ko'i ewywuat ti rat sa'ag ne'i ewehenoi miit'in me ma'ato Tupana e hap yt eweimo­herep hin i yt naku i rat eipe are. Katu­pono Tupana ehay etiat eipohep takaria eipe. Mi'i pytkai — Uruehay ti Tupana ehay toĩne'en ewei'e sa'ag ne'i. Mi'i hap kaipyi ti Irania'in Tupana ehay sese yt ikuap hin i are e Iesui Iuteu ywania mu'e haria pe wẽtup miwan enoi haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mi'i hawyi Iesui ti'a­tu­kaykay tuwe­wawi irania'in miit'in miat henoi hamo — Koitywy are'e teran ehepe aikope pyi som yt nakuap i tut e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Pywo ti yt eimi'u kaipyi i ti i'ewyte yt eiposei eipysei hap eiwe­painug hap kaipyi i ti tut i'aparap ehepiat hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ma'ato miit'in minug yt nakuap i ti tuwẽtem i'atu­py'a pyi i'atu­wa­nẽtup sa'ag hap kaipyi e. Pyno ehewaure ka'a pote eiwa­nẽtup to mio wat ui'e hap kape e Iesui i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mi'i hawyi Iesui toto temiit'in wywo miit'in typy'i rakaria py'a­setpyi hawyi teke wẽtup netap we. Mi'i hawyi meiũran hemiit'in apo'i­'a­tu'e Iesui pe — Kat ereĩ i'atuepe sehay hã'ãkap wuo ehenoi Mehĩ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mi'i hawyi Iesui ti'a­tu­wesat — Are pãi yt eweikuap i apo uhehay e. Irania'in ewy te ti apo eipe e. Pyno ahenoi i ehepe e. Yt miit'in mi'u kaipyi i ti tuwenug yt naku i hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pywo pe ti mi'u yt teke i aiwa­nẽtup hawe aipy'a piat ma'ato aimẽ'ẽn me yn teke kuap e. Mi'i hawyi tuwẽtem hawyi toto i ra'yn aipiit pyi e Iesui. Mio tã tupono ti waku yne mi'u aimi'u wo e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mi'i hawyi Iesui to'e — Uiwy­ria'in miit'in minug yt nakuat i tuwẽtem i'atu­py'a pyi ti e. Pywo pe ti miit'in py'a pyi tuwetẽm wanẽtup yt nakuat i hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tuwepyi tutunug yt nakuap i e. Wuat'i hary­po­ria'in nywo e hat sero­'ok'e hat miit auka hat wẽtup ok ti se'aito wywo uito e hat wẽtup ok ti seha­ry'i wywo uito e hat miit'in py'a pyi tuwẽtem ");
INSERT INTO mavNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","I'ewyte uiwano yn irania'in ekare'en e hat ati'a­tu­mo­weu­ka'i uito irania'in e hat atima'at sehay wo wẽtup ok e hat uito ti po'og uiwaku irania'in kai e hat ti Tupana ehay etiat weky­ry'i hat yt iwe'eg i rakat tuwepyi ta'a­tuehay ta'a­tu­py'a pywiat ta'a­tunug yt naku i e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pyno uiwy­ria'in eweikuap ta'yn som miit py'a pyi tuwẽtem wanẽtup hap yt naku i hap. Mi'i wo ti yt naku i tuwenug tuwe­mohun e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mi'i hawyi Iesui toto pya kahato tetama pyi wẽtup ywania etama kape i ra'yn wẽtup setama pya wuat kape. Mi'i hap tote put'ok'e ra'yn i'atue­tama Tiru piat hawyi iheg me ra'yn toĩne'en. Katu­pono yt toiky­'esat i miit'in miat tokuap hap. Ma'ato yt aikotã me kuap i tuwemig. ");
INSERT INTO mavNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mi'i hawyi wẽtup ok hary­poria tikuap Iesui etiat hawyi toikat ra'yn Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kat pote tomẽpyt piit piat ahiag putsit hamo toikat Iesui. Mi'i hary­poria so yt Iesui ywania i ra'yn. Wẽtup setama pywiat mekewat yi Siru­we­nisia pywiat. Mi'i ti wẽtup ta'yn ipusu Kereku ehay puo ra'yn ihay. Mi'i hawyi toipuẽti Iesui hawyi tuwe­pỹ­'ã­tutuk howa kape hawyi to'e — Mimi e etihep o ten ahiag uimẽpyt piit piat e haty wo. ");
INSERT INTO mavNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mi'i hawyi Iesui tiwesat — Apuete mana e sa'a­wy'i ti atipoi teran ui'y­wania e katu­pono yt naku i hira­karia mi'u wo urutopoi awareria ne'i e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mi'i hawyi to'e Iesui pe hary­poria — Are an mi'i tã ti Mimi e ma'ato ti i'ewyte aware hit ko'i tu'u mi'u ku'i hewo rakat e'ywania mẽpyt'in tenuk turan e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mio tã e pote Iesui tiwesat — Hẽ ti waku kahato mana uiwesat en e. Pyno era'aipok i ro emẽpyt kape katu­pono koitywy ti yt kat i ra'yn ahiag emẽpyt piit pe are'e hap ewy e. Atisopo ra'yn wyti ahiag emẽpyt piit pyi mana e. Pyno koitywy waku ra'yn tuwete e. Yt kat i ra'yn som pyno ahiag emẽpyt piit pe mana e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mi'i hawyi ity ta'aipok ta'yn tomẽpyt kape. Put'ok'e to'yat pe hawyi toipuẽti ra'yn tomẽpyt yni pe waku pe i ra'yn. Tokosap ta'yn heso'ok hap. Mi'i hawyi ti ity tikuap ta'yn tomẽpyt piit pywiat ahiag wẽtem hap. ");
INSERT INTO mavNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mi'i hawyi toto Iesui tawa Tiru pyi yi Sitãu sakpo ra'yn. Mi'i hawyi ta'aipok i ra'yn hẽpype tetama sese kape i ra'yn. Mi'i hap upi toi'a­tu­mu'e tetama Karireia hyemyi'a piaria 10 tawa ko'i. ");
INSERT INTO mavNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mi'i hap tote ta'a­tuerut ra'yn Iesui kape wẽtup ok hewaure rakat yt ihay hãpyk kuap i rakat. Mi'i hawyi ta'a­tu­hẽtup Iesui pe imoehãite topo wuat hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mi'i hawyi Iesui tioto hewaure rakat miit'in tok pyi hawyi totemig na'yn hewaure ka'a ko'i hawyi kuitu'e ra'yn hawyi tohẽku pen tẽty hy wo. ");
INSERT INTO mavNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mi'i hawyi Iesui iha'at atipy kape hawyi kynkyn'e — Etimoe­waure ka'a i ro meiũwat miit Tupana e. Ma'ato towat topusu puo Iesui to'e tope — Ewata e. ");
INSERT INTO mavNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mi'i hawyi meremo hewaure ka'a i ra'yn ihay kuap wuat'i ewy ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mi'i hawyi Iesui wãi'e irania'in me haty wo — Yt ewehenoi tei'o uhepiat imoehãite hap irania'in me e wen ma'ato ta'a­tu­henoi henoi ra'yn wuat'i puo ra'yn yt Iesui miky­'esat ewy hin i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mi'i hawyi ta'a­tukuap wuat'i puo ra'yn Iesui piat hewaure rakat moehãite hap hawyi te'e­ro'e to'ope — Waku kahato Iesui tunug i'atu'e. Hewaure rakaria wyti tutunug hewaure ka'a ko'i wo ra'yn i'atu'e. Yt ihay kuap i rakaria tutunug ihay kuap i ko'i wo ra'yn i'atu'e. Mi'i hawyi tuwat tuwat Iesui kape pya pyi. ");
INSERT INTO mavNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mi'i hawyi te'e­ru­wa­'a­tunug Iesui kape miit'in sok. Mi'i hawyi mye'ym e'at Iesui ti'a­tu­mu'e at ka'ap. ");
INSERT INTO mavNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Mi'i hawyi temiit'in me to'e ra'yn — Uimi­mu­'eria meiũpiaria ti mye'ym e'at pe ra'yn mye'ym wãtym na'yn uhupi hupi uhehay kuap hamo e. Mi'i pote ti yt kat i ra'yn topy­hu'at i'atu­mi'u wuat e. Mi'i pote i'atue­ha­ky­'e'i kahato uhepe mi'iria pãi e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Koitywy ti yt naku i ra'yn te'e­ra­'aipok ta'a­tue­tawa ko'i kape katu­pono pya kahato ra'yn i'atue­tawa ko'i tukup­te'en e. Ta'i te'e­ropap ne'i ra'yn ni ren mu'ap upi yahig koro sakpo tuwat turan sy'at pono e. Yt naku i ra'yn ati'a­tu­po­re­ra­'aipok yt kat i i'atu­mi'u wywo i e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mi'i hawyi hemiit'in te'e­ro'e Iesui pe — Pywo mehĩ ma'ato aikotã waku wati­'a­tupoi mesuwe yahig wato tote i'atu'e. Yt kat i meiũpe man i'atupoi hamo i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mi'i hawyi apo'e Iesui — Karania a kahu pyno man aiwat e. Mio tã e pote — Ta'i 7 man yn Uhyt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","— Pyno ewei'apyk to yi upi e Iesui torania miit'in me. Mi'i hawyi Iesui waku e Tupana pe — Uru'ywot atipy piat urutu­wehum ewawi urupoi hap upi e hawyi toipikpik kahato ra'yn mekewat 7 rakat man hawyi toimõ'ẽ kahato temiit'in me. Mi'i hawyi hemiit'in irania'in me imõ'ẽ ra'yn wy. ");
INSERT INTO mavNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mi'i hawyi i'ewyte pira hit ko'i totat hawyi waku e Tupana pe hawyi toipat'ok kahato hawyi tutum temiit'in me hawyi — Eweimõ'ẽ o irania'in me e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mi'i hawyi te'e­renuk kahato ra'yn hawyi i'atu'ok ta'yn 4000 miit. ");
INSERT INTO mavNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mi'i hawyi hemiit'in ti'a­tunug i'atu­mi'u ieĩpyt 7 e'yry­sakag ne topy­hu'at. Waku hawyi Iesui ti'a­tu­po­'oro ra'yn i'atue­tawa pya rakat ko'i kape. ");
INSERT INTO mavNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mi'i hawyi toto i ra'yn Iesui yara puo tama Tauma­nuta kape temiit'in wywo. ");
INSERT INTO mavNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Put'ok­'i­'a­tu'e hawyi nagnia ehay enoi haria hã'ãg Iesui ta'a­tuehay wo — Heno pyno etomo­herep esaika hap atipy kaipywiat iwato rakat i'atu'e. Mi'i etunug mote ti aru uruikuap ta'yn Tupana Mipo­'oro En hap i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mio tã i'atu'e pote Iesui haty'u kahato topy'a pe hawyi hen'ẽ poity'i hawyi to'e mio tã e haria pe — Kat poteĩ mesu­wiaria tiky­'esat kahato atimo­herep yt miit'in misepap ko'i ewywuat i uimohey hamo e. — Ta'i esaika hap etimo­herep uruepe hawyi uruimohey En i'atu'e. Mio tã e haria pe ti yt atomo­herep teran i uhesaika hap mio tã e haria pe e Iesui yt imohey i haria tewa­nĩ­kaptia pe. ");
INSERT INTO mavNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mi'i hawyi tohok­'iwat hawyi toto i ra'yn temiit'in wywo ihyemyi'a sakpo i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma'ato hemiit'in tiwaure ta'a­tu­mi'u man. Mi'i pote ta'a­tukat man yara pe mu'ap upi ma'ato wẽtup man yn ta'a­tu­puẽti. ");
INSERT INTO mavNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mi'i hawyi Iesui ti'a­tu­nãpin — Eiwe'eg wo o nagnia ehay enoi haria mani puk hap ewywuaria pupi e. I'ewyte morekuat Eroti mani puk hap ewywuat pupi e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mi'i hawyi te'e­ro'e to'ope — Kat poteĩ mio tã e ahepe sio aheman yt iwato i pote i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mi'i hawyi Iesui tikuap hawyi to'e i'atuepe — Kat pote aheman yt iwato i ewei'e eiwo­'ope e. Yt eweikuap hin i te iwato kahato atunug man ga'atpo pytkai apo e. Eipy'a heg kahato te apo e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yt eheha pytig i te apo e. Yt ehewaure ka'a i te apo e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Eweiwaure ra'yn apo aikotã sa'a­wy'i miit'in ati'a­tupoi 7 man wo yn 4000 rakaria hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mi'i kaipyi apo pyno karania e'yry­sakag ne topy­hu'at mi'u ieĩpyt e Iesui temiit'in me. — Ta'i 7 e'yry­sakag ne ti howapy topy­hu'at Uhyt i'atu'e. Mi'i hawyi Iesui to'e — I'ewyte ti sa'a­wy­'iwuat 5 man wo ati'a­tupoi 5000 rakaria. Mi'i kaipyi apo karania e'yry­sakag ne topy­hu'at mi'u ieĩpyt mekewat e'at piat wy e. — Ta'i 12 e'yry­sakag ne i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mi'i hawyi Iesui to'e — Yt eweikuap i apo te aikotã atimo­wato kuap man hap pyno kat — Aheman yt iwato i ewei'e. Wẽtup man a yn toĩne'en aimi'u wo ewei'e e. Yt uimohey i te apo eipe e Iesui temiit'in me katu­pono po'og kurin ipo pe toĩne'en pote po'og iwato tutunug kuap. ");
INSERT INTO mavNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mi'i hawyi put'ok­'i­'a­tu'e ysakpo tawa Petsaita pe. Mi'i turan so ta'a­tuerut Iesui ewawi yt iha pytig i rakat — Etimoe­hãite epo wo meiũwat yt iha pytig i rakat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mi'i hawyi Iesui ti'y­kesat ereto ra'yn yt iha pytig i rakat tawa pyi. Mi'i hap tote iha pe kuitu'e ra'yn hawyi totemig topo wo. ");
INSERT INTO mavNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mi'i hawyi apo'e — Waku ra'yn apo eha uhyt e. Mi'i hawyi teha'at hawyi toiwesat — Hẽ porap waku Uhyt e ma'ato meimuẽwat miit'in hewyry rakaria wyti aria'yp ko'i ewy ne'i e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mi'i hawyi Iesui temig i topũ'ĩa wo iha hawyi waku ra'yn yne ta'a­kasa ra'yn. Mi'i hawyi Iesui to'e tope — Pyno waku ra'yn eete koitywy uhyt e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Era'aipok to e'yat kape wẽtup mu'ap upi e. Yt erokosap tei'o wẽtup tawa puo emoehãite hap enoi hamo e Iesui tomi­moe­ha­pytig me. ");
INSERT INTO mavNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mi'i hawyi Iesui ipot'am towy­ria'in wywo yi Sesareia piat tawa Wiripi kape tawa ko'i upi toto temiit wywo. Mi'i hawyi mu'ap upi Iesui apo'e towy­ria'in me — Uwe som pono Uito irania'in wanẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Apo'e hawyi ta'a­tu­wesat — U pãi Tupana ehay moherep hat nimuat hat raso wo'o­set'ok hat Iuwãu raso Eria raso i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mi'i hawyi to'e — Ma'ato apo uwe Uito eiwa­nẽtup hawe e. Mi'i pote mekewat Nu e hap het rakat mekewat Peteru tiwesat — Wo'oe­ha­kye­ra'at hat Tupana Mipo­'oro Urupo­rekuat nuat rat En Uhyt e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mi'i hawyi Iesui ti'a­tu­nãpin — Yt ewehenoi tei'o koitywy uikuap ehepiat hap irania'in me e temiit'in sese pe. ");
INSERT INTO mavNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pywo ti Uito Wuat'i Miit'in Eyke'et wen ma'ato mi'i pytkai nagnia yt uiky­'esat hin haria i e. Ta'i pa'i kororia miwan enoi haria i'ewyte uhehay pun haria ne'i e. Pywo ti Uito Eheyke'et ta'a­tu­'auka irane e. Aho'opot kahato ui'auka hap turan ma'ato ui'auka sa'ag hawyi uiku­'uro sese hawyi mye'ym e'at yn uisyp hawe areĩne'en hawyi Tupana uihep gu'uro po pyi Eheyke'et e Iesui towy­ria'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mio tã e pote Peteru tikaykay Iesui tuwe­wawi wãito'e hamo — Uhyt e yt naku i ti ehenoi e'auka hamuat hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma'ato Iesui tuwe­morem topot­mu­'eria kape Peteru saty'i saty'i hamo hawyi to'e Peteru pe — Erepik to ahiag e. Uinãpin sa'ag ne'i yt Tupana uinãpin hap ewy i ra'yn ma'ato miit'in wo'o­nãpin hap ewy ne'i ra'yn uinãpin en e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mi'i hawyi Iesui ti'a­tu­kaykay tuwe­wawi irania'in mu'ap upiaria i'atu­mu'e hamo — Pywo ti rat eweiwat teran uhupiat pote eweitoiat ro eimi­ky­'esat ko'i yt Tupana miky­'esat ko'i hawyi eweiwat ro uhupi ehe'a­ria'yp posak wywo e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Uwe uwe iku'uro uhehay wakuat enoi hap upi pote uiky'e haria wo topy­hu'at e. Mi'i haria ti aru wuat'i e'at piat ieĩne'en hap sese puẽti hanuaria e. Ma'ato irania'in mesuwat rotiat ieĩne'en hap yn ky'esat haria ti aru ieĩne'en hap sese pun hanuaria wo ho'o­wasat rakaria ne'i tukup­te'en e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kat hamo ten eweikyi'at yne yne mesuwat yi totiat eheĩne'en hap sese sa'up mo e. ");
INSERT INTO mavNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma'ato mesu­wa­rotiat kyi'at hap kape yn eiwa­nẽtup at ka'ap hawyi aru aikotã eweikyi'at kuap wuat'i e'at piat ikahu sese rakat eheka­re'en Tupana wuat hap e. Mi'i hawyi eheĩne'en wuat'i e'at piat hap ko'i eimipun no topy­hu'at e. Mi'i hawyi uhehay wakuat kuap hap yt teke kuap i eiwa­nẽtup hawe e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mesu­wa­rotiat miit'in wyti yt uimohey i kahato haria mesu­wiaria e. Ta'i ta'a­tu­mi­ky­'esat ko'i yn ta'a­tunug neran e. Mi'i pote uwe uwe uhehay pupi tuwe­mõti yt uimohey haria i py'a­setpe mi'i haria pupi ti aru Uito i'ewyte aremõti wy mekewat e'at pe karãpe Uito Eheyke'et no ariot i ra'yn Morekuat no atipy piaria wywo Tupana wat hẽtyhot rakat pe imehit rakat piat turan. Mi'i hap e'at pe ti aru Uito Eheyke'et aremõti uipupiat wemõti haria pupi e Iesui mu'ap upiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wẽtup e'at pe Iesui to'e temiit'in me — Meiũran ti aru Tupana uimo­herep sese ehepe Uito Miit'in Porekuat nuat sese areĩne'en hap e. Ma'ato wẽtup ok wẽtup ok yn eipe meiũpe akasa uhowawiat haria eweipy­hu'at e. Ta'i eipe ti eiwa­'a­kasa ra'yn uhewaku hap ko'i e eiku­'uro hap e'yianmete are e. Yt yne i eipe ma'ato wẽtup ok wẽtup ok ti aru mi'i hap kapiat akasa hanuaria eweikup­te'en aru e Iesui Iuwãu Tiaku Peteru piat. ");
INSERT INTO mavNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mi'i hawyi 6 e'at itote toĩne'en hawyi Iesui toto i ra'yn yity'ok ywaiti kahato rakat kape towy­ria'in nywo mye'ym ok takaria wywo yn Peteru Tiaku Iuwãu wywo. Mi'i hawyi itote Iesui timo­herep ta'yn aikotã toĩne'en hap sese. ");
INSERT INTO mavNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mi'i turan Iesui esokpe imehit kahato ikytsig kahato po'og ikytsig mesu­wa­rotiat ko'i kai e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mi'i hawyi hemiit'in te'e­ra­'a­kasa typy ok Tupana ehay moherep haria sa'a­wy­'i­wuaria iwywo. Wẽtup ok Eria wẽtup ok Musei te'e­ra­'a­kasa. Mi'iria ti to'oehay Iesui wywo. ");
INSERT INTO mavNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mi'i hawyi Peteru to'e — Urumu'e hat e ta'i waku kahato meiũpe watoĩ­ne'en e. Etiky­'esat apuru urutunug ehe'og mye'ym e wẽtup ewano wẽtup Musei wano wẽtup Eria wano e Peteru Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma'ato ipoity'i tuete pono mio tã e ne'i. Ta'i token'ẽ pote. Yne ra'yn te'e­ro­ken'ẽ. ");
INSERT INTO mavNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mi'i hawyi ywyhig me ywaiti pyi sehay tut ra'yn — Uha'yru Uimi­ky'e kahato ti eipy­'a­setpe toĩne'en e. Mi'i tupono eweiwa­nẽtup to ihay kape are e Tupana ywaiti pyi. ");
INSERT INTO mavNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mio tã e hawyi Iesui yn na'yn heremo temiit'in yatype. ");
INSERT INTO mavNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mi'i hap totepyi tuwat popuo Iesui to'e towy­ria'in me mye'ym ok takaria pe — Yt ewehenoi tei'o aikotã Eimu'e hat ewei'a­kasa mesup yity'ok totiat hap irania'in me e. Ma'ato karãpe Uito Eheyke'et arẽtem gu'uro pyi hawyi ti aru waku ra'yn ewehenoi Eimu'e hat ewei'a­kasa mesup hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mi'i pote irania'in me yt ta'a­tu­henoi teran i. Ma'ato mio tã e Iesui pote te'e­ru­wa­nẽtup kahato — Kat pote mio tã e — Ara'aipok gu'uro pyi e i'atu'e te'e­re­wa­nẽtup hawyi. ");
INSERT INTO mavNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mi'i hawyi yity'ok tote­pywiat tuwat hap upi te'e­ro'e Iesui pe — Kat poteĩ sa'a­wy­'iwuat miwan enoi haria te'e­ro'e ahepe miwan me — Ta'i Tupana tipo­'oro ti aru wuat'i ehakye­ra'at hanuat ma'ato toipo­'oro aru Mi'i Miit e'yianme mekewat sa'a­wy­'iwuat tehay moherep hat Eria toipo­'oro Temiit ut hap moherep hamuat i'atu'e ahepe. Mio tã i'atu'e pote Iesui tiwesat — Ta'i Eria ti tut hamuat yianme uipu'ap mohãpyk hamo e. Ta'i tohenoi kahato Eria etiat miwan me. To'e hap ewy ti ra'yn e. I'ewyte ti tohenoi kahato Eheyke'et ku'uro hamuat hap etiat miwan me e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I'ewyte tohenoi kahato aikotã ho'opot hamuat hap etiat aikotã i'atu­mi­ky­ry'i tuetiat hamuat etiat hap ko'i tohenoi miwan me wy e. Mi'i hap ewy ti tohenoi Eria ut hamuat hap etiat e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pywo ti Eria ti put'ok'e ra'yn ha'a­wyte ra'yn e hap ewy e. Ta'i Uimo­herep ta'yn miit'in me mi'i miit Tupana ehay moherep hat sa'a­wy­'iwuat Eria ewywuat e Iuwãu piat. Pywuat sese ti i'atu­mi­ky­ry'i kahato mi'i ete. Ta'a­tu­'auka ra'yn wyti aikotã sa'a­wy­'iwuat henoi hap ewy ti ra'yn e Iesui towy­ria'in mye'ym ok takaria pe mu'ap upi yity'ok totepyi. ");
INSERT INTO mavNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mi'i turan myhu'at haria irania'in hemiit'in tihep teran wẽtup ok kurum piit pyi ahiag pã'ãu ma'ato yt ta'a­tuhep kuap i. Mi'i pote itotiaria miwan enoi haria to'o­ky­ry'i kahato i'atuete. Mi'i turan Iesui put'ok'e i ra'yn i'atuete mye'ym ok takaria wywo. ");
INSERT INTO mavNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hemiit'in te'e­ra­'a­kasa Iesui kape hawyi pun'i­'a­tu'e howa kape irania'in typy'i rakaria wywo i'atu­wepit kahato ra'yn. Mi'i hawyi te'e­ru­wẽ­powat — Haika'at Uhyt haika'at Mimi i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mi'i hawyi Iesui put'ok'e ra'yn i'atuete mye'ym ok takaria wywo hawyi Iesui apo'e i'atuepe — Kat eiwei'eĩ eiwo­'ope uhyt'i'in mana'in e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mi'i hawyi wẽtup ok typy'i tok pyi to'e — Wo'o­mu'e hat ga'atpo aterut uha'yru ahiag ipiit piat rakat ewawi wen ma'ato En yt uwe i e. Yt naku i kahato ahiag uha'yru ete Uhyt e. Ahiag teke hawyi yt ihay kuap i tuereto e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ta'i ta'at yi tote hawyi ti tuwe­'okhyt morem morem tuereto iwẽ enãpuk tyry'e kyry­'et­ky­ry'et e. Mi'i haype iku'uro porap i tuereto e hap. Yt naku i Uhyt e. Sa'a­wy'i epotmu­'eria pe ahẽtup ahiag putsithep hamuat hap wen ma'ato yt ta'a­tuhep kuap i e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mi'i hawyi Iesui to'e — Ta'i yt uimohey i haria miit'in mesuwat yi totiaria pote e. Karania e'at ti aru areĩne'en eiwywo eimu'e uimohey mono ui'e haype e. Karãmuo put'ok'e uimohey ehepiat hap woro­ho­'o­mu'e mot'i pytkai yt Tupano mohey i rakaria wo eweikup­te'en ne e. Pyno eterut ro meikowo uhowawi esa'yru ahiag ipiit piat rakat e Iesui ahiag ipiit piat rakat ywot pe. ");
INSERT INTO mavNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mi'i hawyi meremo ta'a­tuerut ra'yn howawi. Mi'i hawyi ta'a­kasa ra'yn Iesui ewa kape hawyi ahiag tipun hirakat yi tote hawyi toi'okhyt morem morem hawyi iwẽ enãpuk ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mi'i pote Iesui to'e i'ywot pe — Karãmuo kahu sa'a­wy'i meiko tã emẽpyt ete uhyt e. — Ta'i ihire pyi te mekewat ahiag toĩne'en ipiit pe Mehĩ e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aria pe kawiat re i ahiag tipun tuereto i'auka hamo e. Mi'i tusake ti y'y pe toi'auka teran tuereto i'auka hamo e. Yt naku i kahato mi'i tã uha'yru etiat hap uhete Uhyt e. Urueha­kye­ra'at ro En Uhyt e. Eithep kuap pote etihep to ahiag Uhyt e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mi'i hawyi Iesui tiwesat — Etihep kuap pote ere'e apo uhepe e. Kat pote mio tã ere. Yt uimohey i apo en. E'e hap kaipyi ti yt uimohey i kahato hap atikuap. Tupana mohey haria pe ti yt kat i niatpo e Iesui mio tã e pote. ");
INSERT INTO mavNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mi'i hawyi hirakat ywot to'e haty wo — Ta'i atimohey Tupana Uhyt ma'ato yt kahato i e. Pyno uipo­wyro po'og uhepiat Tupana mohey hamuat e tuwak popuo. ");
INSERT INTO mavNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mi'i turan typy'i ra'yn tõ'ẽ pote Iesui haty'i haty'i tehay wo ahiag — Erẽtem no ahiag sa'ag meiũwat hirakat piit pyi e. Yt naku i kahato en e. Miit'in pusu mõto hat en e. Miit'in ewaure ka'a pyhyp hat en e Iesui ahiag me. Yt karãmuo i ra'yn o era'aipok hirakat kape e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mi'i hawyi ahiag tuwẽtem na'yn kakto'e kakto'e popuo hawyi toihuruk huruk kurum tuwẽtem hawe. Mi'i hawyi kurum ta'at yi tote iku'uro rakat ewy ra'yn. Mi'i pote raso — Iku'uro ra'yn wyti i'atu'e ra'yn irania'in. ");
INSERT INTO mavNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma'ato Iesui timo­poĩ'ãm na'yn topo wo hawyi ipoĩ'ãm waku i ra'yn tuete. ");
INSERT INTO mavNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mi'i hawyi toto i ra'yn Iesui wẽtup getap kape towy­ria'in nywo. Mi'i tote apo'i­'a­tu'e Iesui pe — Uhyt kat pote som yt uruihep kuap i mekewat ahiag uruto i'atu'e ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mi'i hawyi toi'a­tu­wesat — Ta'i uhyt'i'in mesuwat ewywuat ahiag niatpo kahato tuwẽtem e. Tupana yn na'yn ti mekewat ewywuat ihep kuap e. Ewehẽtup Tupana pe haty wo eiwe­mo­sy'at hap wywo ahiag hep hamuat mi'i pote yn ni tuwẽtem ma'ato iũte'en ewehẽtup pote yt karãpe i eweimõto kuap meremo mekewat ahiag ewywuat e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mi'i hap totepyi toto Iesui towy­ria'in wywo yi Karireia sakpo i ra'yn. Ma'ato yt tuwenoi i toto hamo irania'in me katu­pono temiit'in mu'e hamo ne'i tuweran toto. ");
INSERT INTO mavNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mi'i hawyi mu'ap upi toi'a­tu­mu'e mu'e kahato ra'yn towy­ria'in — Meiũran ti aru Uito Eheyke'et ta'a­tu­pyhik hawyi ui'auka ra'yn e. Mi'i hawyi ti aru ta'a­tusyp wo'o­pyhyp hawe e. Mi'i hawyi ti aru ta'a­tusyp hawyi mye'ym e'at yn iku'uro mekepe e. Mi'i hawyi ti aru ma'ato areĩne'en i ra'yn gu'uro pyi Uito Eheyke'et e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma'ato mio tã e hap iwyria'in yt tikuap i ma'ato apo yt i'atu'e i katu­pono te'e­ro­ken'ẽ haype apo'i­'a­tu'e hap pupi. ");
INSERT INTO mavNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mi'i hawyi put'ok'e Iesui temiit'in wywo getap we hawyi apo'e temiit'in me — Mehĩ'in e kat ewei'eĩ eiwo­'ope ehehay mu'ap upi e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma'ato yt ta'a­tu­wesat teran i katu­pono to'oehay moweu­ka'i ne'i — Uito ti wakuat no po'og eikai i'atu'e to'ope wen. ");
INSERT INTO mavNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mi'i hawyi ta'apyk ta'yn Iesui hawyi toi'a­tu­kaykay temiit'in 12 ok takaria hawyi tohenoi i'atuepe — Po'og nakano ereĩne'en neran mote ereĩne'en no wuat'i miit eropat hano wuat'i miit'in miat motpap nug hano. Mi'i hawyi po'og ereĩne'en Tupana wanẽtup hawe e Iesui temiit'in me i'ewyte ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mi'i hawyi hirakat toipo­rokpun i'atu­py­'a­setpe hawyi toi'a­hi­'y­pysat hawyi to'e towy­ria'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","— Uwe uwe ti aru uhetiano wẽtup ok hirakat ky'e meikowat ewy e mi'i hat wyti uiky'e hano topy­hu'at e. I'ewyte uwe uwe uiky'e hat toĩne'en mi'i hat ti aru yt Uito yn i uiky'e ma'ato Uipo­'oro hat Tupana ky'e hano topy­hu'at wy e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mi'i hawyi iwy ok Iuwãu to'e — Wo'o­mu'e hat ga'atpo uruta­'a­kasa wẽtup ok ahiag sopo eset wuat hat e. Mi'i hawyi wãi'u­ru­to'e katu­pono yt aiwywuat hewyry rakat i pote e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mi'i hawyi Iesui tiwesat — Yt naku i wãiwa­to'e wẽtup ok pe uhet wuat ahiag sopo hat e katu­pono atiky­'esat mi'i ewywuat nug hap. Kat pote uhet wuat ahiag sopo haria yt te'e­ru­we­ky­ry'i kuap i uhet esaika hap ete e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mi'i pote uwe uwe uhehay etiat uhet etiat yt ipy'ahak i rakat mi'i hat aiwywuat hewyry rakat ewy toĩne'en e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ta'i uwe uwe ehepe hum y'y wẽtup ekui'a yn uhemiit'in eipe pote mi'i hat ti aru haipepiat ipuẽti ha'up Tupana piat e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Uiwy­ria'in e ta'i yt naku i kahato wato­py­hu'at ihy pya pe nu wato aipiit ete saitynug wo katu­pono mi'i hap ewy hawyi aiku­'uro hap yn topy­hu'at. Mekewat nu ipotyi rakat aipiit ete pote yt wato'am kuap i ihy pya pyi hawyi. Ma'ato po'og yt naku i mi'i hap kai topy­hu'at aru hira­karia uimohey haria ma'at haria e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ma'ato eipo wo eweima'at hirakat pote waku eweitek eipo e. Katu­pono po'og waku eiwe­hyt'ok Tupana etawa pe wẽtup eipo wywo yn ma'ato typy eipo wywo eiwe­hyt'ok aria pe ne'i e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ta'i yt naku i ti eiwe­hyt'ok hamuat aikope aria yt hasep i hawe aikope ut yt topap i hawe e. I'ewyte eipy wo eweima'at hirakat wẽtup mu'ap upi mi'i ti waku eweitek eipy e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Katu­pono po'og waku eiwe­hyt'ok Tupana etawa pe wẽtup eipy wywo yn ma'ato typy eipy wywo eiwe­hyt'ok aria pe ne'i e. Mi'i pote karãpe eipy ehewyry yt naku i nug hamuat po'og waku eweitek eipy eweiwat yt naku i nug hamuat kai are e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ta'i yt naku i ti eweikup­te'en hamuat aikope aria yt hasep i hawe aikope ut yt topap i hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","I'ewyte eweima'at hirakat eheha wo mi'i eheha waku eweihep o are'e e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Po'og waku wẽtup eheha wywo yn eiwe­hyt'ok aikope Tupana toĩne'en Morekuat no hawe. I'ewyte typy eheha wywo eiwe­hyt'ok aikope ut yt topap i rakat hap tote e Iesui tomohey haria hira­karia ma'at haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mi'i hawyi Iesui to'e temiit'in me — Ta'i aria waku kahato aimi'u mokã'ã hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","I'ewyte waku kahato ukyt yne mosẽ'ẽ hamo ma'ato ukyt yt hẽ'ẽ i rakanuat pote yt uwe i iky'esat e. Uhyt'i'in mi'i hap ewy o eweikup­te'en aria ewy ukyt hẽ'ẽ rakat ewy wuat'i mosẽ'ẽ hamo e. Hẽ'ẽ kahato rakaria ewy o eweikup­te'en eiwo­'ope e. Yt eiwu­'uka tei'o eiwo­'ope e Iesui temiit'in me e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mi'i hawyi Iesui toto i ra'yn yi Iuteu kape. Mi'i hawyi toto Iũtãu hy sakpo. Mi'i hap tote te'e­ru­wa­'a­tunug typy'i kahato howa kape. Mi'i hawyi tohenoi henoi i'atuepe tomi­ky­'esat ewy Tupana ehay. ");
INSERT INTO mavNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mi'i turan nagnia ehay enoi haria tõ'ẽ howa kape ima'at teran haype apo'i­'a­tu'e — Uhyt urunãpin En sio waku apo urueha­ry'i wywo uruto­'o­'atoiat wẽtup ok wywuat i ra'yn hamo i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mi'i hawyi Iesui ti'a­tu­wesat — Kat eĩ pono nimuat aha'a­se'i Musei ainãpin mi'i hap yt eweikuap i apo'e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mi'i hawyi ta'a­tu­wesat — Nimo Musei to'e — Eiwo­'o­'atoiat teran pote ewetunug miwan popera tote yt eiwo­'o­wese i hap morekuat ehamo mi'i hawyi ti waku eiwo­'o­'atoiat e Musei sa'a­wy'i i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma'ato Iesui ti'a­tu­wesat — Eweikuap kat pote Musei einãpin mio tã e. Pyno ahenoi ehepe. Ta'i yt eiwo­'o­ky'e kuap i ti eipy'a heg mote. Mi'i pote ti Musei mio tã e miwan me e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma'ato sa'a­wy'i sese ti yt mi'i tã hin i katu­pono sa'a­wy'i te ti Tupana tunug miit ipa'iat iwary'i e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mi'i tupono waku ihainia ti'atoiat to'ywot toty hawyi teha­ry'i wywo toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mi'i hawyi ihainia teha­ry'i wywo wẽtup piit ieĩne'en hap ewy ra'yn topy­hu'at e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mi'i tupono yt eweitek tei'o Tupana mipo'i wo'o­kyi'at hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Getap wiat hawyi iwyria'in apo'i­'a­tu'e Iesui pe — Kat to'e hawe som mio tã i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mi'i hawyi toi'a­tu­wesat — Uwe uwe teha­ry'i atoiat mi'i hawyi toĩne'en wẽtup ok wywo i ra'yn mi'i hat ti yt naku i inug teha­ry'i sa'a­wy'i pe Tupana wanẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","I'ewyte ti uwe te'aito atoiat mi'i hawyi toĩne'en wẽtup ok wywo i ra'yn mi'i hat ti yt naku i inug te'aito sa'a­wy'i pe Tupana wanẽtup hawe e. Mi'i tã ti yt naku i kahato ewetunug uimohey haria eipe pote e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mi'i hawyi miit'in te'e­ro­po'ok teran hira­karia Iesui ewawi i'atue­waku topo wuat hamo. Ma'ato ipotmu­'eria ti'a­tu­pyhyp hira­karia howawi waĩ'i­'a­tu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mi'i pote ipy'ahak Iesui temiit'in ete hawyi to'e — Tero tõ'ẽ uhowawi hira­karia e. Yt eweipyhyp tei'o uhowawi hira­karia pãi e. Katu­pono karãpe Tupana topy­hu'at Wuat'i Ywania Miit'in Porekuat no mi'i hap e'at pe hemiit'in imohey haria hira­karia ewy ra'yn tukup­te'en hetama pe. ");
INSERT INTO mavNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pywo pe ti eweiwat teran aikope Tupana toĩne'en Morekuat no hap kape pote aikotã hira­karia tiky­'esat tuwe­hyt'ok ta'a­tuty ta'at­'ywot kapiat hap ewy o eweiky­'esat eiwe­hyt'ok hap ma'ato yt pote ti aru yt eiwe­hyt'ok hin i atipy pe e Iesui topot­mu­'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mi'i hawyi hira­karia toi'a­tu­'ok­hytsat hawyi topo wo toi'a­tue­waku. ");
INSERT INTO mavNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mi'i hap totepyi Iesui toto ra'yn. Mi'i turan wẽtup ok hekat rakat pun'e Iesui owawi mu'ap upi. Put'ok­to'e hawyi tuwe­pỹ­'ã­tutuk howa kape. Mi'i hawyi to'e — Wo'o­mu'e hat waku kahato En e. Mi'i pote uimu'e katu­pono atiky­'esat wyti areĩne'en wuat'i e'at piat hap e ma'ato yt atikuap i kahato kat som atunug waku ha'up mo e. En ni wakuat kahato e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mi'i hawyi Iesui to'e mekewat miit pe — Tupana yn ni wakuat e. Uito wakuat ere'e apo. Uito Tupana ewanẽtup hawe apo e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mi'i hawyi Iesui to'e tope — Etikuap apo Tupana wo'o­nãpin hap ko'i yt erepot­'auka tei'o e hap yt wẽtup ok wywo tei'o ehary'i e'aito e hap yt sero­'ok­'ere tei'o e hap yt eso tei'o e hap yt erepot­ma'at tei'o e hap etimõ­typot e'ywot ety e hap etikuap apo'e. Ta'i mio tã e hap etikuap e Iesui kurum iwasu hekat rakat pe. ");
INSERT INTO mavNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mi'i hawyi kurum iwasu tiwesat — Ta'i uihire pyi te ti yt ati'a­parap i mio tã e hap ete e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mi'i hawyi Iesui teha'at howawi iky'e kahato hap wywo hawyi to'e — Mehĩ wẽtup mo etunug hawyi waku ereĩne'en ne'en Tupana wywo e. Pyno motoro e'yat kape hawyi etimõ'ẽ yne ekare'en yt hekat i rakaria pe hawyi era'aipok uhowawi ereto uhupi hamo e. Mi'i pote ti aru ekare'en sese etipuẽti Tupana etama pe e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mio tã e Iesui pote paa'e ne'i ra'yn hawyi toto Iesui kaipyi yt iwepit i ra'yn katu­pono iwat heka­re'en iwato kahato pote yt toimõ'ẽ teran i. ");
INSERT INTO mavNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mi'i hawyi Iesui teha'at temiit'in kape hawyi to'e — Are pãi niatpo kahato ti rat weka­re'en ky'e haria tuwe­hyt'ok aikope Tupana toĩne'en Morekuat no hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mi'i hawyi hemiit'in te'e­ru­we­wa­nẽtup kahato ihay kape mi'i hawyi Iesui to'e i — Ta'i niatpo kahato ti rat weka­re'en mohey hat teke aikope Tupana Morekuat no toĩne'en hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ta'i niatpo kahato aikotã aihũ iwato rakat Kameru teke awi ehapo ka'a puo hap ewy e. Mi'i hap ewy ma'ato ti po'og niatpo tuwe­hyt'ok Tupana etama pe weka­re'en mohey haria e temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mi'i hawyi hemiit'in gyt'i­'a­tu'e i ra'yn hawyi te'e­ro'e to'ope — Pyno yt uwe i hekat rakat pono teke kuap atipy pe i'atu'e. Mi'i hawyi apo'i­'a­tu'e Iesui pe — Yt uwe i aru pono hekat rakaria Tupana mi'a­tue­ha­kye­ra'at rakaria i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mio tã i'atu'e pote Iesui teha'at i'atue­wawi hawyi to'e — Pywo ti rat yt uwe i tuwee­ha­kye­ra'at kuap tuwewi. Tupana yn ti'a­tue­ha­kye­ra'at kuap miit'in e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mi'i hawyi Peteru to'e ra'yn — Urumu'e hat sa'a­wy'i te ti uru'atoiat yne meimuẽwuat ko'i uruekat eupiat urutuwat hamo e Peteru Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mi'i hawyi Iesui to'e — Atikuap eimi­'atoiat yne hap e. Ta'i pywo ti rat are'e ehepe uwe uwe uhehay moherep wẽtup ywania pe toto uiky'e haype hawyi i'atoiat to'yat towy­ria'in toty to'ywot tomẽ­pyt'in tomikoi ko'i mi'i hat po'og toipuẽti sa'a­wy­'iwuat wakuat tomi­'atoiat hap ko'i kai e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Mi'i hawyi toipuẽti mesu­wa­rotiat ko'i kai po'og po'og na'yn sa'a­wy­'iwuat kai aikotã 100 hap ewy aru toipuẽti to'yat ko'i towy­ria'in toty'in tomẽ­pyt'in tomikoi ko'i sa'a­wy­'iwuat wẽtup takat tomi­'atoiat kai 100 hap ewy aru toi'a­tu­puẽti e. I'ewyte ti aru eweipuẽti miit'in miky­ry'i hap uhehay upi uhupi eweiwat pote e. I'ewyte mesu­wa­rotiat toku­'uro hap saipepiat toipuẽti hamuat toieĩne'en hap yt sakewuat ikahuro rakat i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mekewat e'at pe ti aru ipoity kahato sa'a­wy­'iwuat mesu­wa­ro­tiaria iwato rakaria te'e­ro­py­hu'at kurin rakaria wo yt miit'in mimõ­typot ko'i i wo e. Ma'ato sa'a­wy­'iwuat kurin nakaria paa'e haria ti aru te'e­ro­py­hu'at po'og iwato rakaria wo po'og mimõ­typot ko'i wo wuat'i miit'in kai atipy pe e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mi'i hawyi Iesui ipot'am towy­ria'in e'yianme tawa wato Ieru­sarẽi kape. Mi'i hawyi te'e­ro­ken'ẽ kahato ipotmu­'eria i'ewyte i'atu­wuwu kahato katu­pono — Ta'i itote tukup­te'en ai'auka teran haria i'atu'e to'ope. Mi'i pote toi'a­tu­kaykay tuwe­wawi temiit'in hawyi tohenoi i'atuepe aikotã aikotã tawa wato Ieru­sarẽi miaria tunug tuwetiat hamuat. ");
INSERT INTO mavNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","— Wato hamuat wyti tawa Ieru­sarẽi kape e. Put'ok­wa­to'e itote hawyi ti aru Uito Eheyke'et pa'i kororia miwan enoi haria uipag na'yn sura­ra'in po pe ra'yn e. Mi'i hawyi mi'iria ti aru uipo­'oro ra'yn ui'auka hamuat kape e hawyi ti aru irania'in ywania po pe uipag ui'auka hamo e. Mi'i hawyi te'e­rehay miky­ry'i kahato uhete. ");
INSERT INTO mavNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","I'ewyte kuitu­'i­'a­tu'e uhete e. Mi'i hawyi ti aru uipokpok ta'yn hawyi ti aru ui'auka ra'yn wen ma'ato ti aru mye'ym e'at yn areĩne'en gu'uro pe hawyi ti aru areĩne'en i ra'yn Uito Eheyke'et e Iesui mu'ap upi tawa Ieru­sarẽi kapiat tuwat hap upi. ");
INSERT INTO mavNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mi'i hawyi hemiit'in Iuwãu Tiaku Sepeteu sa'y­ru'in tuwat Iesui kape hawyi ta'a­tu­hẽtup tope — Urumu'e hat etum uruepe kat urumi­ky­'esat ok tã i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mi'i hawyi to'e — Pyno kat som eweiky­'esat atum ehepe e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mi'i hawyi ta'a­tu­wesat — Pyno karãpe eropy­hu'at Wuat'i Miit'in Porekuat no mi'i turan ni aru uruiky­'esat uruta­'apyk po'og e'yatype etu'i­saria wo emimõ­typot ko'i irania'in kai i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma'ato Iesui ti'a­tu­wesat — U yt eweikuap i kahato kat som ewehẽtup uhepe hap e. Pyno uhekui'a pyi apo eiwe­'y­'ukuap e. Uhatek hap apo ewehã'ãg kuap e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mi'i hawyi ta'a­tu­wesat — Ta'i uruhepap kahato i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mi'i hawyi Iesui to'e — Pywo eiwe­'y'u aru ti uhekui'a pyi i'ewyte ewehã'ãg irane uhatek hap e ma'ato eimiẽtup uhepiat ti yt atum kuap i ehepe katu­pono Tupana ti'airo yn na'yn ui'ya­typiat apyk hanuaria e Iesui Tiaku Iuwãu pe. ");
INSERT INTO mavNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mio tã i'atu'e ta'a­tu­hẽtup Iesui piat pote irania'in hemiit'in i'atu­py­'ahak Iuwãu Tiaku ete. ");
INSERT INTO mavNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mi'i hawyi Iesui ti'a­tu­kaykay i ra'yn tuwe­wawi hawyi to'e i'atuepe — Uheka­tu­wyria e eweikuap apo aikotã mesu­wa­rotiat more­kuaria te'e­ru­we­mo­wato kahato hap e. Ta'i ta'a­tu­po­'oro kahato ti ta'a­tue­miit'in sehay pirik wo e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma'ato mesu­wa­ro­tiaria epore­kuaria ewy yt atiky­'esat hin i eweikup­te'en e. Ma'ato uwe wemo­wato teran hat wuat'i powyro hano atiky­'esat e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Uwe topy­hu'at ei'akag wo teran mi'i hat waku topy­hu'at ehemiit no Eheyke'et ewy e. Katu­pono Uito Eheyke'et ariot mesuwat yi kape miit'in eropat hamo e. Ma'ato yt miit'in miat uheropat hamo i ariot mesuwe e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ta'i miit'in hep yt nakuap i pywiat hamo ariot ehowawi e. Ta'i uheĩne'en hap atum irane wuat'i miit'in kyi'at Tupana wanuat sa'up mo atum uhuu e Iesui topot­mu­'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mi'i hawyi Iesui put'ok'e i tawa Ieriko pe temiit'in nywo. Mi'i hawyi tuwe­nõ'ẽ mekewat tawa pyi miit'in tok puo. Mi'i hawyi tawa ekuekai mu'ap tote toĩne'en mehĩ Patimeu apyk pe. Mi'i ti yt iha pytig i. Wuat'i kaipywiat kat ẽtup hat toĩne'en. Mi'i ti Timeu sa'yru. ");
INSERT INTO mavNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mi'i hawyi toikuap ta'yn Iesui tawa Nasare piat ut hap hawyi tohẽtup haty wo Iesui pe — Morekuat Tawi Sa'yru uheha­kye­ra'at En e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma'ato so irania'in — Wãi'i­'a­tu'e ehay pirik kahato. Epo'inik to i'atu'e. Ma'ato po'og ne'i haty wo iwẽpap'i tuwatka watka — Morekuat Tawi Sa'yru uheha­kye­ra'at En e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mi'i hawyi Iesui topy­hu'at hawyi to'e — Eweikaykay ro meikowo yt iha pytig i rakat e i'atuepe. Mi'i hawyi te'e­ro'e Patimeu pe — Iesui ekaykay ra'yn koitywy uhyt mimi i'atu'e. Pyno epoĩ'ãm no ereto ro ewepit ro i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Toikuap hawyi topysop toipun hawyi ipoĩ'ãm peso'e hawyi toto ra'yn Iesui kape. ");
INSERT INTO mavNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mi'i hawyi apo'e Iesui tope — Pyno kat aru emiky­'esat atunug epe e. Mi'i hawyi toiwesat — Wo'o­mu'e hat uheha pakup i nug hap atiky­'esat e. ");
INSERT INTO mavNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mi'i hawyi Iesui to'e tope — Pyno koitywy waku ra'yn eha ete katu­pono uimohey hap emoehãite ra'yn e. Mi'i hawyi meremo waku ra'yn tuete ta'a­kasa i ra'yn. Mi'i hawyi Patimeu toto mu'ap upi Iesui upi sa'a­wy­'iwuat yt iha pytig i rakat. ");
INSERT INTO mavNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mi'i hawyi Iesui toto i ra'yn tawa wato Ieru­sarẽi kape towy­ria'in wywo. Put'ok­to'e mekewat yity'ok Uriweira ypia yity'ok hap het rakat tote hawyi te'e­ra'am hawyi te'e­ro­py­hu'at mekewat yity'ok tote. Yt pya hin i ra'yn tawa wato Ieru­sarẽi kai tawa Pewake kai tawa Petania kai tukup­te'en itote. ");
INSERT INTO mavNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Mi'i totepyi toi'a­tu­po­'oro typy ok temiit tawa Ieru­sarẽi kape — Eweiwat ro mekewat tawa kape hawyi put'ok­'e­wei'e hawyi aru ewei'a­kasa aru wẽtup i'atuhũ Iumentu mẽpyt ta'a­saity piat eweipuẽti aru e. Mekewat i'atuhũ Iumentu mẽpyt pakup takat toĩne'en katu­pono yt uwe i hewyry itotiat rakat te toĩne'en i'atuhũ e. Pyno mi'i hawyi o waku ewei'a­sai­typok hawyi o eweterut ra'yn i'atuhũ uhowawi katu­pono uhewyry teran mekewat Iumentu mẽpyt rote areto tawa wato Ieru­sarẽi kape teran e Iesui typy ok temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mi'i hawyi to'e i tomi­po­'oro ko'i pe — Ta'a­tukuap teran aru — Kat hamoĩ ewetioto uruhũ i'atu'e hawyi waku ewei'e aru — Aika­'iwat wyti ipuru porap'i eihũ uhyt'i'in waku ewei'e o ika'i­waria pe e Iesui typy ok tomi­po­'o­roria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mi'i hawyi tuwat ra'yn hawyi mi'i Iesui e hap ewy ra'yn ta'a­tu­puẽti itote i'atuhũ Iumentu ta'a­saity pe mu'ap tote oken note. ");
INSERT INTO mavNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mi'i hawyi ta'a­tu­'a­sai­typok pote itotiaria apo'i­'a­tu'e — Kat hamoĩ ewetioto uruhũ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mi'i hawyi ta'a­tu­wesat — Aika­'iwat Iesui wyti ipuru meremo i'atu'e. Mi'i hawyi so — Pyno waku i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mi'i hawyi ti tuwat ra'yn i'atuhũ wywo Iesui kape. Put'ok­'i­'a­tu'e hawyi ta'a­tu­po­rokpun i'ok tote ta'a­tue­sokpe ko'i i'atuhũ tote. Mi'i hawyi Iesui ta'am na'yn apyk pe mekewat Iumentu pakup ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mi'i hawyi irania'in iporokpun ta'a­tue­sokpe yi upi. Ta'a­tu­terek i'yhop ko'i haga ko'i ga'a­koran ko'i hawyi ta'a­tu­po­rokpun howa kai ipu'ap mokahu hamo more­kuaria pu'ap ewy. ");
INSERT INTO mavNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mi'i hawyi yianmiaria wat'y­muaria te'e­rehum ta'a­tuehay wepit wywo — Ta'i waku kahato ti Tupana i'atu'e. Meiũwat Miit ti Tupana Mimõ­typot i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Meiũwat Miit ri Tupana Mipo­'oro Aipo­rekuat nuat aikotã morekuat Tawi ewywanuat i'atu'e. To'iro Tupana Mipo­'oro Morekuat Tawi Saipepiat sese mõtypot hamo i'atu'e mekewat mu'ap upiaria sem tuwat tuwat Iesui upi tawa wato Ieru­sarẽi kape turan. ");
INSERT INTO mavNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Put'ok'e tawa wato Ieru­sarẽi me hawyi Iesui teke Tupana mõtypot hawe. Mi'i hawyi teha'at yne hawyi toto i tawa wato Ieru­sarẽi myi wãtym neran moity'i pote toto mekewat tawa hit Petania kape temiit'in 12 ok takaria wywo. ");
INSERT INTO mavNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","He'i­hot'ok pe tawa Petania kaipyi ta'aipok i ra'yn Ieru­sarẽi kape. Mi'i hap tote mu'ap upi Iesui hesy'at kahato ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mi'i hawyi ta'a­kasa Wiku yp kape pya wuat kape i'yhop kahuria rakat kape. Mi'i hawyi toto haat ky'ewi ma'ato yt kat i haat toipuẽti. I'yhop yn toipuẽti hesy'at turan. Yt haat rakat i. ");
INSERT INTO mavNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mi'i hawyi Iesui to'e Wiku yp we hawyi — Are pãi e pyno mi'i hawyi wyti aru yt sake i ra'yn esaat e. Yt uwe i ra'yn ti aru esaat'u e tesy'at hap wywo te. Mio tã e hap hemiit'in tikuap. ");
INSERT INTO mavNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mi'i hawyi Iesui toto temiit'in wywo i ra'yn Ieru­sarẽi kape. Put'ok­ta­'a­tu'e hawyi tuwe­hyt'ok i ra'yn Tupana mõtypot yat wato pe. Mi'i turan kare'en kyi'at haria wene­ru'i wene­ru'i e haria tukup­te'en itote typy'i kahato toipuẽti. Mi'i hawyi Iesui ti'a­tu­po­re­nõtem i ra'yn mi'iria Tupana mõtypot yat wato hawyi. Mi'i hawyi Iesui i'atue­ti­neiru pat'ok pat'ok hap mesa yparakai ko'i tohytpok yne. Mi'i hawyi pykasu weneru haria e'amyap ko'i tohytpok yne. Toi'a­tu­sopo yne i'atukat weneru haria. ");
INSERT INTO mavNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mi'i hawyi herut haria toi'a­tu­pyhyp ta'yn yt toiky­'esat i ra'yn Tupana mõtypot yat wato e'okipy sakpo toko­ka'at. ");
INSERT INTO mavNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mi'i hawyi mi'i haria toi'a­tu­nãpin haty wo — Yt eweikuap i apo aikotã Tupana to'e Isaia miwan me — Ui'yat rat ri atiky­'esat wuat'i ywania ehay uhowawiat hamuat e. Ma'ato ti Tupana mõtypot yat ewetunug sero­'ok'e haria yat no ne'i are e. Yt naku i kahato ewetunug are e Iesui Tupana mõtypot yat piaria kare'en weneru haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mi'i tã na'yn tutnug mote miwan enoi haria pa'i akagnia tikat kahato ra'yn aikotã miat i'auka hamuat ma'ato te'e­ro­ken'ẽ Iesui pupi kat pote typy'i poity'i ihay upiaria pote. ");
INSERT INTO mavNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mi'i hawyi wãtym'i irane hawyi toto Iesui tawa Ieru­sarẽi myi temiit'in wywo. ");
INSERT INTO mavNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mi'i hawyi he'i­hot'ok pe hunete Iesui toto i ra'yn towy­ria'in nywo Ieru­sarẽi kape. Mi'i hawyi mu'ap upi iwyria'in te'e­ra­ha'at i mekewat Wiku yp kape. Mi'i turan i'yp gag na'yn hapo wywo ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mi'i hawyi ti Peteru to'e — Urumu'e hat mekewat Wiku yp iku'uro ra'yn emisa­ty'i saty'i e. ");
INSERT INTO mavNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mi'i hawyi Iesui ti'a­tu­nãpin — Ta'i eweimohey ro Tupana haty wo e. ");
INSERT INTO mavNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pywo pe ti are'e ehepe uwe uwe meiũwat yity'ok wato rakat ewywuat pe to'e — Ereto ro meiũpepyi y'y wato kape hawyi min'ere ro y'y wato pe imohey hap wywo yn mi'i pote ti aru topopy ra'yn meremo yity'ok y'y wato kape hawyi min'e imohey hap ok tã are e. ");
INSERT INTO mavNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mi'i tupono ti karãpeĩ eimi­ky­'esat ehẽtup Tupana pe imohey hap wywo ewei'e ro eipy'a pe — Tut aru tut aru pãi tut aru an uimiẽtup ewywuat ewei'e ro eipy'a pe e. Katu­pono imohey hap wywo ehẽtup Tupana pe pote eimiẽtup ewy tutunug ehepiat tomohey hap ok tã tutunug. Mi'i pote ti meremo aru eipo pe ra'yn eimi­ky­'esat toĩne'en Tupana miium emiẽtup hap ok tã. ");
INSERT INTO mavNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pyno Tupana kapiat ehehay hamo eweimo­hãpyk to eipy'a piat yt eiwo­'o­wese i hap ko'i mi'i pote ti aru Ei'ywot atipy piat timo­hãpyk yne eiminug yt nakuap i ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ma'ato yt waure wo i eweikup­te'en mote ti aru Ei'ywot atipy piat i'ewyte yt waure wo i toĩne'en eiminug sa'ag ko'i ete e Iesui temiit'in me Wiku yp gag na'yn hap tote apo'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mi'i hawyi put'ok'e i ra'yn Iesui tawa wato Ieru­sarẽi me. Mi'i hawyi Tupana mõtypot hap yat puo hewyry. Mi'i hawyi pa'i akag ko'i seko miwan enoi haria i'ewyte nagnia tipuẽti Iesui itote. ");
INSERT INTO mavNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mi'i hawyi apo'i­'a­tu'e Iesui pe ");
INSERT INTO mavNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","— Uweĩ epo'oro ga'atpo meketã nug hamo Tupana mõtypot yat pyi uruemiit'in sopo hamo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mi'i hawyi Iesui ti'a­tu­wesat — Pyno ahenoi aru ehepe wen ma'ato sa'a­wy'i ewehenoi uhepe uwe ipo'oro Iuwãu wo'o­set'ok hamo sio Tupana sio miit'in e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mi'i hawyi ta'a­tukat Iesui wesat hamuat hap. Mi'i hawyi te'e­ru­wa­nẽtup — Kat wato'e som waku wati­wesat i'atu'e. Sio Tupana ti Iuwãu po'oro hat wato'e pote ti ren — Kat poteĩ pyno yt eweimohey i Iuwãu e aru ahepe. ");
INSERT INTO mavNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma'ato miit'in mipo­'oro ti Iuwãu wato'e pote aru i'atu­py­'ahak ahete irania'in katu­pono irania'in Iuwãu mohey haria tukup­te'en i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mi'i hawyi ta'a­tu­wesat Iesui — Uhyt yt uruikuap i sese uwe ehay pyi Iuwãu topot­set'ok i'atu'e. Mi'i pote Iesui ti'a­tu­wesat — Yt uiwesat i pote mi'i hawyi yt ahenoi i ehepe uwe ehay pyi ati'a­tu­sopo wene­ru'i wene­ru­'i'e haria pya Tupana mõtypot yat pyi hap e Iesui pa'i akag ko'i miwan enoi haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mi'i hawyi Iesui henoi hã'ãkap wuo i'atuepe sehay — Wẽtup e'at pe so wẽtup ok miit tuwa­nẽtup Uwa ypia nug tepiat hap ete e. Mi'i hawyi toikoi hawyi toi'a­tu­pyhyp kurara wato pe hawyi tutunug nu ka'a wato Uwa hy sat hamuat e. Mi'i hawyi so i'ypia py'a­setpe tuwe­py­typnug ywaiti rakat surara eiam Uwa u haria pupi Uwa ero'ok haria pupi e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hãpyk yne hawyi ipotpap takaria po pe ra'yn toipuru. Mi'i hawyi so toto ra'yn tewyry hamo e. Meiũran haat hap e'at pe so toipo­'oro wẽtup ok temiit Uwa po'ok hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mi'i hawyi put'ok'e ipotpo­'oro imikoi ypia pe ma'ato yt i'atu­wese i ra'yn imipo­'oro ete. Yt ta'atuium neran i ra'yn ta'a­tu­mi­po'ok e. Mi'i hawyi ta'a­tu­pytyk hawyi ta'a­tu­pokpok kahato ra'yn. Mi'i hawyi ta'a­tu­po­re­ra­'aipok yt kat nywo i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mi'i hawyi wẽtup ok temiit i ra'yn ika'iwat tipo­'oro ma'ato i'ewyte mi'i ipotpap takaria ti'ahyk ahyk i'akag ete e. Mi'i hawyi i'atu­mi­ky­ry'i wo ne'i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mi'i hawyi wẽtup ok temiit i ra'yn toipo­'oro. Mi'i ti ta'a­tu­'auka ra'yn e. Mi'i hawyi irania'in i ra'yn toi'a­tu­po­'oro ma'ato i'ewyte te ta'a­tunug irania'in ta'a­tu­'ahyk ahyk irania'in ta'a­tu­'a­tu­'uka ne'i ra'yn e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mi'i hawyi Ha'yru yn na'yn topy­hu'at Imiky'e kahato. Mi'i ti ma'ato toipo­'oro — Ta'i Uha'yru sese tupono ti aru ta'a­tu­mõ­typot kahato ra'yn Mi'i Miit rat pãi e so tuwa­nẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ma'ato ti yt hin i. Mi'i hawyi te'e­ro'e to'ope — To'iro wati­'auka I'ypia Ka'iwat Sa'yru i'atu'e. Katu­pono ti aru meiũran Mi'i ra'yn Ika'iwat Pakup mo i'atu'e. Wati­'auka hawyi mono aipo pe yne ra'yn topy­hu'at mesuwat mikoi ypia i'atu'e ne'i to'ope e Iesui tuwepiat. ");
INSERT INTO mavNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mi'i hawyi ta'a­tu­'auka ra'yn Ha'yru hawyi ta'a­tu­pugha ipiit mikoi i'ypia kaipyi e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mi'i hawyi Iesui to'e — Kat aru mi'i hawyi mikoi ypia Ka'iwat tunug Tosa­'yru auka haria ete e. Ta'i tut hawyi ti aru toi'a­tu­'uka mi'iria hawyi ti aru wẽtup ywania po pe i ra'yn toipuru te'yi e Iesui nagnia pe to'auka teran haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mi'i hawyi Iesui to'e i'atuepe — Yt karãmuo i apo eiwe­mu'e miwan me aikotã Tupana to'e sa'a­wy­'iwuat hap ete — Meiũran aru Wẽtup ok Uimi­'airo i'apy­'yha ewywuat netap nug haria yt tiky­'esat i uimõ­typot yat nug hamo e Iesui. Ma'ato mi'i ti aru topy­hu'at netap akywyt yp mo ipo'og hesaika irania'in kai e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mi'i wyti Aipo­typot minug ikahu kahato rakat atipuẽti e. Mi'i wyti aru akywyt yp mo aha'a­wynug uimõ­typot yat sese ui'yat nug haria yt tiky­'esat i pytkai e ti miwan me e morekuat Tawi miwan 118.22 pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mio tã e pote hewa­nĩ­kaptia te'e­ru­wa­nẽtup kahato hawyi te'e­ro'e — Ahete ti mio ihay yt wati­ky­'esat i Iesui pote i'atu'e. Mi'i pote ta'a­tu­pytyk teran Iesui ma'ato typy'i poity'i iwyria'in pote te'e­ro­ken'ẽ hawyi tuwat Iesui yaty­pepyi. ");
INSERT INTO mavNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mi'i hawyi meiũran morekuat Eroti emiit ta'a­tu­po­'oro Iesui kape nagnia ehay enoi haria Iesui ehay aparap ta'a­tuehay wuat hamo tuwat. ");
INSERT INTO mavNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mi'i hawyi apo'i­'a­tu'e — Wo'o­mu'e hat i'atu'e ta'i uruikuap En. Pywo ti ehenoi hãpyk yn Tupana kapiat pu'ap wuat'i miit'in me katu­pono yt uwe pupi i ereken'ẽ i'atu'e. Wẽtup ehay yn ehenoi wuat'i miit'in i'atu'e. Mi'i tupono urunãpin En. Waku apo aheti­neiru wati­pat'ok morekuat wato Sesa pe sio yt i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma'ato Iesui tikuap toiã'ãg ne'i hap morekuat mõpy­'ahak hap. Mi'i hawyi toi'a­tu­wesat — Kat poteĩ mio tã ewei'e sio apo uhã'ãg hap e. Eweterut ro uhepe tineiru i'ape rakat ara'a­kasa mono pyno e Iesui apo'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mi'i hawyi ta'a­tu­'erut ra'yn hawyi Iesui apo'e i'atuepe — Uwe iã'ãkap kahu pyno meiũ tineiru ete toset wywo e. Mi'i hawyi ta'a­tu­wesat — Ta'i morekuat wato Sesa iã'ãkap ti i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mi'i hawyi Iesui to'e — Pyno waku watum morekuat wato pe towanuat ko'i sa'up e. Ma'ato Tupana wanuat ko'i sa'up waku watum Tupana pe e. Mi'i hawyi mio tã e Iesui pote te'e­ro'e to'ope — Pywo ti rat ihay hãpyk kahato Iesui wyti i'atu'e. Ta'i tuwe'eg kahato ti ihay i'atu'e to'ope Iesui ewanĩ­kaptia. ");
INSERT INTO mavNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wẽtup e'at pe hawyi tõ'ẽ Iesui kape wo'o­mu'e haria. Mi'iria so miit'in mu'e aiku­'uro hawyi ti yt kat i ra'yn aheĩne'en pakup i hap e haria. Mi'iria so apo'i­'a­tu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","— Wo'o­mu'e hat nimo te Musei miwan ainãpin hap mio tã e — Karãpe eheyke'et iku'uro ma'ato yt kat i imẽpyt mi'i pote waku hehiwu iywyt ehary'i wo iku'uro rakat mẽpyt nug hamo e ti Musei mienoi nimuat Mekewat Musei miwan miat Teute­ru­numiu 25.5 pe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mi'i hawyi wẽtup e'at pe so iywyt sem nakaria toĩne'en. Mi'i hawyi so i'atuy­ke'et tipuẽti teha­ry'i ma'ato meiũran so iku'uro yt imẽpyt i te turan i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mi'i hawyi so iywyt wywo i ra'yn hehiwu toĩne'en i'atu'e. Mi'i i'ewyte yt imẽpyt i te turan so iku'uro ra'yn i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Meiũran 7 ok takat topap yne ta'a­tue­hiwu yatype ma'ato yt wẽtup ok i imẽpyt topy­hu'at i'atu'e Iesui pe. Mi'i hawyi so iku'uro ra'yn i'atue­hiwu i'atu'e aiku­'uro hawyi yt kat i aheine'en hap e haria Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mi'i hawyi apo'i­'a­tu'e Iesui pe — Atipy pe hawyi mekewat hiwu uwe te'aito wywo toĩne'en kat pote 7 he'aito toĩne'en mesuwe pote. Mi'i hawyi apuru uwe wary wo mekewat hary­poria katu­pono 7 ok he'aito i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mi'i hawyi Iesui ti'a­tu­wesat — Ta'i ewei'a­parap kahato wyti katu­pono yt eweiwa­nẽtup hãpyk hin i wyti uhyt'i'in e katu­pono Tupana mienoi yt eweikuap i kahato i'ewyte Tupana esaika hap yt eweikuap i kahato e i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Karãpeĩ tuwe­nõ'ẽ gu'uro pyi miit'in mi'i hawyi ti aikotã Tupana emiit'in atipy piaria ewy te'e­ro­py­hu'at. Ma'ato yt he'aito rakaria i yt iwary rakaria wo i ra'yn tukup­te'en itote e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mi'i hawyi Iesui to'e — Eipe ti aiku­'uro hawyi ti yt kat i ra'yn aheĩne'en pakup i hap e haria e. Pyno ahenoi teran wẽtup sehay ehepe gu'uro pywiat aheĩne'en pakup i hap e. Yt karãmuo i apo eiwe­mu'e Musei miwan ete aikotã aria'yp wuk'e hat kaipyi to'e Tupana Musei pe — Uito ti Aparãu eTupana Isaki eTupana Iako eTupana Uito e Tupana Musei pe sa'a­wy'i e Esutu 3.6 pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mi'i tupono are'e ehepe Tupana ti yt map haria eTupana i ti. Ta'i uhyt'i'in Tupana ti ieĩne'en haria eTupana yn hap watikuap e. Mi'i pote Aparãu Isaki Iako yt karãpiat i iku'uro raka­nuaria ma'ato wuat'i e'at piat ieĩne'en hanuaria mi'iria e Iesui yt kat i aheĩne'en hap aiku­'uro hawyi e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mi'i turan wẽtup ok miwan enoi hat tikuap yne Iesui wesat waku hap ko'i pote apo'e Iesui pe — Uhyt e kat e hap som ewanẽtup hawe irania'in kai po'og iwato Tupana wo'o­nãpin hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mi'i hawyi Iesui tiwesat — Pyno ahenoi po'og iwato rakat epe e. Mio tã e ti miwan me tohenoi Isareu ywania pe — Wẽtup Tupana yn ni toĩne'en e Aipo­typot no e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tupana ro eweiky'e kahato yne yne eipy'a pe yne yne eiwa­nẽtup hawe yne yne eiwe'eg hawe e ti e Musei tomiwan Teute­ru­mumia 6.5 pe e Iesui tope. ");
INSERT INTO mavNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mi'i hawyi wẽtup wo'o­nãpin hap toĩne'en porap i'ewywuat — Eti'a­tu­ky'e miit'in irania'in aikotã aikotã eweky'e hap ewy e Musei tomiwan Irewi­tiku 19.18 pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yt kat i ti wẽtup po'og iwato wo'o­nãpin hap mesuwat kawiat rakat e Iesui tiwesat. ");
INSERT INTO mavNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mi'i hawyi mekewat miwan enoi hat Iesui pe to'e — Ta'i waku ti wati­ky'e Tupana yne yne aipy'a pe aiwa­nẽtup hawe aiwe'eg hawe e i'ewyte irania'in waku wati­'a­tu­ky'e aiwe­ky'e hap ewy e. Pywo pe ti mi'i po'og waku watunug ikamhig se wuk hamuat sio aihũ aimiium Tupana piat kai. Ta'i po'og waku wati­ky'e Tupana aipy'a pyi e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mi'i hawyi Iesui tipuẽti iwesat hamuat ikahu rakat sehay. Mi'i hawyi Iesui to'e tope — Ta'i porap yn na'yn ni en Tupana emiit no e Iesui miwan enoi hat pe. Mi'i hawyi yt ta'a­tu­hã'ãg po'og i Iesui ehay aparap ta'a­tuehay wuat hamo katu­pono iwesat hap pupi te'e­re­mõti ra'yn iwesat hap waku yne yne pote. ");
INSERT INTO mavNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mi'i hawyi to'e Iesui Tupana mõtypot yat piaria pe — Kat poteĩ einãpin haria mio tã i'atu'e ehepe — Wẽtup ok morekuat Tawi emiariru aru topy­hu'at Wuat'i Miit'in Porekuat no i'atu'e ehepe e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ma'ato nimo te Tupana Pã'ãu mikuap morekuat Tawi to'e — Tupana ti to'e Uhetu­pana pe — Era'apyk to uipo sese kai e. Mi'i hawyi ti aru ati'a­tu­'akit torania e'akit reran haria e. Mi'i hawyi ti aru yt kat i'atu'e i ra'yn ewanĩ­kaptia aru katu­pono atunik yne ra'yn e wyti Tupana uhepe e morekuat Tawi e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","— Kat poteĩ pyno Tawi emiariru yn topy­hu'at Wuat'i Porekuat no ewei'e ma'ato Tawi to'e — Tupana ti to'e Uhetu­pana pe e e Iesui. Mi'i hawyi mio tã e Iesui pote ti Tupana mõtypot hawiaria — Ta'i ihay se kahato ti Iesui i'atu'e ra'yn to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mi'i hawyi Iesui to'e — Eiwe'eg wo o einãpin haria ran mupi e. Katu­pono sokpe kahuria puo teran ikohye­wyry miit'in ko'i upi e. Mi'i hawyi ta'a­tu­ky­'esat miit'in wẽpowat kahuria i'atu­'e­ka­re'en kyi'at hap upi e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","I'ewyte Tupana mõtypot hawe ienuk turan ta'atueiam nug po'og waku irania'in kawiat hap ta'a­tu­ky­'esat e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mi'i hawyi hiwuria ta'a­tu­ma'at ta'a­tu'yat ko'i kape ta'a­tue­ro'ok hamo e. Yt nakuaria i mi'iria pote meiũran aru po'og mi'iria Tupana ti'a­tu­mo­so­'opot irania'in kai e. Eiwe'eg wo o Tupana mõtypot yat piaria nãpin haria yt pywo i rakaria pupi e Iesui itotiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesui henoi kahu ra'yn hawyi ta'apyk towy­ria'in nywo Tupana piat miium eiam yatype. Mi'i hawyi miit'in terut terut ta'a­tumiium Tupana pianuat ko'i. Mi'i hap kape Iesui iha'at. Mi'i turan hekat rakaria miium iwato ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mi'i turan wẽtup ok hiwu yt hekat i rakat i'atu­py­'a­setpe hum tomiium kurin typy ape hit rakat yn tutum. ");
INSERT INTO mavNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mi'i hawyi Iesui teha'at kahato hawyi teka­tu­wyria toi'a­tu­kaykay hawyi to'e i'atuepe — Eweha'at ro mekewat hary­poria hiwu kape e. Pywo pe ti are'e ehepe mekewat hiwu yt hekat i rakat miium po'og iwato Tupana pe hekat rakaria wat kai e. ");
INSERT INTO mavNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Katu­pono hekat rakaria wyti hum Tupana pe ta'a­tue­ti­neiru eĩpyt yn ma'ato mekewat hiwu tuwe­mi­'u­kyi'at hamuat tutum yne yne Tupana pe e Iesui towy­ria'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mi'i hawyi Iesui toto meiẽwat Tupana mõtypot yat koro pyi. Mi'i hawyi wẽtup ok ipotmu'e tuwẽ­powat Iesui kape — Wo'o­mu'e hat e eraha'at ro meikowo e ikahu kahato rasig Tupana mõtypot hap yat nu wato kawiat e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mi'i pote Iesui tiwesat — Ta'i iwato kahato nu kawiat ikahu kahato e era'a­kasa ro e. Ma'ato meiũran ti aru yt wẽtup i ra'yn nu wato wo'o­totiat totiat rakat topy­hu'at e. Meiũran ti aru sura­ra'in ti'a­tu­'a­po­rok'e yne nu wato wuat Tupana mõtypot yat yt kat i topy­hu'at meiũpe e Iesui topot­mu'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mi'i hawyi tuwat ra'yn Uriweira ypia yity'ok kape ra'yn. Mi'i hawyi te'e­ra­'apyk yity'ok apypeke ra'yn. Itote pyi heremo yne Tupana mõtypot yat nu wato kawiat ko'i. Mi'i hawyi ipotpo­'o­roria Peteru Iuwãu Tiaku Ãtere ta'a­tu­weran hawyi apo'i­'a­tu'e Iesui pe — Urumu'e hat karãmuo aru meiẽwat Tupana mõtypot yat i'atu­'a­po­rok'e i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","I'ewyte aikotã aikotã aru uruta­'a­kasa yian Tupana mõtypot hap yat aporok'e hamo i'atu'e. Mi'i hap uruikuap teran mesup yianmete i'atu'e. Mi'i hawyi ti aru karãpe hut hamuat hap uruikuap ta'yn i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mi'i hawyi Iesui ti'a­tu­wesat — Uiwy­ria'in eiwe'eg wo o katu­pono meiũran tut aru uhet ero'ok haria — Meiũ ra'yn Uito Iesui i'atu'e miit'in ma'at reran haype e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Uito ti Tupana Mipo­'oro Miit'in Porekuat nuat ra'yn i'atu'e ti aru miit'in me yt pywo pe i te'e­ro­pot­ma'at ne'i ti aru wẽtup mu'ap upi e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mi'i hap upi ti aru toĩ wu'uka hap ko'i wuat'i setama puo i'ewyte ehetama puo irania'in etama puo wyti aru yne kaipyi wu'uka hap sehay eweikuap ma'ato o yt gyt'e­wei'e tei'o katu­pono ti aru yt ikahuro hap i te e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","I'ewyte ti aru wẽtup ywania wẽtup ywania wywo ti aru to'o­'a­tu­'uka atu'uka i'ewyte ti aru wẽtup setama wẽtup setama wywo to'o­'a­tu­'uka atu'uka yne mesuwat yi wato hap ok tã e. Mi'i hap ewy ti aru aikope aikope yi huruk huruk'e. Mi'i hawyi ti aru miit'in topap kahato yt kat i hin i mi'u pote e. Ma'ato meiũran ti aru po'og po'og haty wo rakat tut e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Eiwa­nẽtup kahato o katu­pono wyti aru ehum wanĩ­kaptia po pe ra'yn eipe tu'i­saria po pe ra'yn eipe e. Mi'i hawyi ei'ahyk ahyk wyti aru Tupana mõtypot hawe e. Mi'i hawyi ti aru i'atu­po­rekuat po pe i'atue­tu­'isa po pe ra'yn eipe ehum uhetiat enoi i'atuepiat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mesuwat uhehay wakuap wyti aru wuat'i miit'in me yi wato ok tã tuwe­mo­herep ikahuro hap sese owakai te e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mi'i hawyi karãpe eipyhik ehehay kuap hamo mi'i pote o yt eweiken'ẽ tei'o mi'i hap e'at pe are — Kat som pono aru waku are'e atiwesat pãi an yt ewei'e tei'o eipy'a pe katu­pono ti aru mekewat e'at pe Tupana Pã'ãu ti aru eiwẽ pyi henoi e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mi'i hawyi ti aru to'o­kuasa to'o­'auka toyke'et toywyt toinyt toty to'ywot tomẽ­pyt'in nywo yne yne wywo to'ope to'ope to'o­kuasa to'o­'auka wyti aru e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Katu­pono ti uimohey haria ti eipe mi'i pote ti aru wuat'i i'atu­py­'ahak ehete e. Ma'ato uwe uwe ta'a­tu­sa­ty'i saty'i pytkai yt uiwaure i wuat'i e'at pe mi'i hat ti aru Tupana mieha­kye­ra'at topy­hu'at wuat'i e'at pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Iwan miat wo'o­mu'e hat uito ti Maku. Mesuwe atiwan uimiwan me Iesui e hap. Eweikuap to kat e som Iesui to'e meiũpe hap. Mio tã e Iesui — Ui'y­wania sa'awy'i Tupana ehay moherep hat ase'i Tanieu tiwan kahato ahaig mipo'oro wuat'i porekuat ran hap etiat. Mi'i pote are'e ehepe karãpe ti aru ewei'a­kasa mekewat miit po'og po'og yt nakuat i rakat ahiag sa'yru — UIto ti Tupana e hat yt teiam me i Tupana mõtypot yat wato pe wuat'i miit'in porekuat no hawyi o eiko­hyeput haty wo ra'yn mekewat miit uhet ere'ok sa'ag nakat pyi yity'ok ko'i kape hawyi eiwemig no yi ka'a ko'i pe mi'i hat pupi ahiag mote are'e e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Eihyha wo ro eweinõ'ẽ. Yt ewei'aipok tei'o i ra'yn o ei'yat kape eheka­re'en sat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Eipotpap turanuat put'ok'e pote o eiko­hyeput tawa Ieru­sarẽi myi o yity'ok kape yn na'yn. Yt ewei'aipok i ra'yn o ehesokpe pag hamo ei'yat kape e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mekewat e'at wyti aru yt naku i kahato mĩ u haria ete hupi'a rakaria ete e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ewehẽtup to Tupana pe — Yt etipo­'oro tei'o mekewat ho'opot hap e'at sese i'aman mot pe ewei'e ro e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mekewat e'at ti aru po'og satek hap e'at wuat'i e'at kai Tupana piat yi nug hawyi te mesup te ahe'at kape yt irania'in e'at piat ewy i ra'yn po'og na'yn yt naku i e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ta'i miit'in topap topap kahato mekewat e'at pe e. Mi'i tupono ti aru Tupana titek ta'yn mi'i hap e'at — Yt atiky­'esat po'og ho'opot hap e aru tomi­'ai­roria etiano e. Yt pote miit'in topap yne mesuwat yi totiaria e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mi'i hawyi ti aru miit'in te'e­ro'e ehepe — Ta'i miit'in Porekuat Aipo­typot Tupana Mipo­'oro wyti put'ok'e ra'yn i'atu'e ti aru. To'iro ewei'a­kasa pyno i'atu'e ti aru ehepe. Ma'ato ti aru yt eweimohey tei'o — Eheso ewei'e ro i'atuepe e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Katu­pono ti aru i'atu kahato — Uito Tupana Mipo­'oro Eipo­rekuat nuat e haria ewywuat sa'ag ko'i te'e­ru­we­mo­herep mesuwat yi totiat kape e. Tupana ehay henoi sa'ag haria ne'i yt pywo pe i ma'ato te'e­ru­we­mõ­typot hanuaria e. Mi'iria ti aru aikotã aikotã imoherep ta'a­tue­saika hap iwato rakat i'atu­minug ko'i ti aru yt miit minug kuap i ewy ta'a­tunug Tupana mi'ai­roria sese ma'at reran haype e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ta'i yianmete ra'yn ni ahenoi ehepe yne mi'i ho'opot hap e'at aikotã aru hap etiat e. Mi'i tupono eimitum o ra'yn eweikup­te'en e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mi'i hawyi mekewat ho'opot hap e'at tokosap hawyi ti aru yt hẽtyhot i sese i ra'yn at i'ewyte waty i'ypyryp ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","I'ewyte ti aru waikiru ko'i ta'atueiam myi hewo hewo hawyi ti aru huruk huruk'e atipy e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mi'i hawyi ti aru ariot i ra'yn Uito Eheyke'et Wuat'i Miit'in Yke'et Sese wo. Uhesaika kahato hawe ariot mesuwat yi kape uimõ­typot kahato hawe ariot aru e. Te'e­ra­'a­kasa kahato hamuat uhut hap ywyhig me wuat'i miit'in e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mi'i hawyi ti aru atipo­'oro Tupana potpo­'o­roria atipy piaria yne mesu­wa­rotiat uimi­'ai­roria uimohey haria atunug uhowawiat hamo mesuwat yi sasat kaipyi ta'a­tu­'a­tunug uhowawi e. At min'e hap kaipyi at wẽtem hap kaipyi at posak hap kaipyi yne kaipyi ta'a­tu­'a­tunug aru uhemiit'in sese e Iesui i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mi'i hawyi Iesui to'e i temiit'in me — Pyno mesup ahenoi teran wẽtup sehay iã'ãkap ehepe e — Wiku yp i'yhop kyt ra'yn hawyi eweikuap ta'yn meremo i'aman mot ut hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","I'ewyte ti aru karãpe ta'a­tunug mesuwat uimienoi ewywuat mi'i hawyi ti aru eweikuap ta'yn meremo Uito Eheyke'et ut hamuat hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pywo pe ti ta'a­tunug ni aru yne mesuwat uimienoi ewy mi'i hawyi ti aru mesu­wa­ro­tiaria uimohey haria ahaipe­piaria wo ra'yn tukup­te'en yne aheĩne'en hawe e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ta'i at waikiru yi ti aru ikahuro yne ma'ato uimienoi ko'i yne yt sake i ikahuro e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yt uwe i mesu­wa­ro­tiaria ikuap karãmuo mekewat uhut hap e'at put'ok'e hap e. Yt atipy piaria i wyti ikuap yt Ha'yru i wyti ikuap. Ma'ato Ui'ywot atipy piat yn wyti ikuap e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mi'i tupono eiwa­tetup we o eweikup­te'en katu­pono yt uwe i ikuap karãpe mekewat e'at put'ok'e hap e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mi'i hap ewy uhut hap e'at piat e. Mi'i uhehay iã'ãkap ewy — Wẽtup e'at pe so wẽtup ok netap ka'iwat koro toto tewyry hamo e. Mi'i hawyi temiit'in sem toi'a­tu­kaykay tohenoi aikotã i'atu­potpap nuat ko'i mesuwiat tosaipe kawianuat turanuat hap ko'i henoi i'atuepiat hamo e. Mi'i hawyi to'e oken'ypy wato apykok hat pe — Ewatetup we o ereĩne'en karãmuo ui'aipok hap kape e. Put'ok­'are hawyi woro­kaykay hawyi waku ero'o­ken­hyp'ok uhowawi e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mi'i hawyi toto netap ka'iwat e. I'ewyte Uimohey haria eiwa­tetup we o eweikup­te'en katu­pono yt eweikuap hin i karãmuo Uito Ei'yat Ka'iwat put'ok'e aru hap sio hunete sio wãtym hake turan sio waipaka ehay turan yt uwe ikuap i kat e'at kat ewãtym ara'aipok i hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yt naku i eiket at Tupana motpap nug hap kai aru put'ok­'are i mi'i hap e'at pe e. Ta'i yt naku i eiwe­mõti hap put'ok'e Eika­'iwat ut turan e. ");
INSERT INTO mavNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Meremo ti tut hamuat mi'i pote kat are'e ti ehepe are'e yne uhemiit'in me wuat'i uimohey aru haria pe ewatetup we o e Iesui ahepe mekewat mikoi Uriweira ypia e'yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Typy e'at man teneg u hap e'at ko'i owakai te pa'i akag ko'i miwan enoi haria wywo te'e­ru­wa­'a­tunug tawa wato Ieru­sarẽi kape sa'a­wyiwuat Iuteu ywania ehakye­ra'at hap ta'a­tue­wa­nĩ­kaptia Esitu'in po pyi e'at kapiat watetup hamo te'e­ru­wa­'a­tunug kahato itote. Mi'i hawyi te'e­ro'e to'ope — Aikotã som pyno waku wati­pyhik hawyi wati­'auka Iesui yt uwe mikuap mo i i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yt naku i wati­pyhik aheman teneg u hap e'at ko'i pe katu­pono wu'uka hap ne'i ra'yn topy­hu'at miit'in me i'atu kahato Iesui mohey haria pote i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mi'i turan toĩne'en Iesui hepihi pihi rakat Simãu yat pe tawa Petania pe. Mi'i hawyi te'e­renuk turan wẽtup ok hary­poria tut Iesui owawi mohag hy Natu kawiat okpun Iesui esap ete hamo. Ha'up woity kahato rakat toterut. Mi'i hawyi toi'okpik heiam hekat rakat nu Arapatu kawiat hawyi toi'okpun Iesui esap ete. ");
INSERT INTO mavNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mi'i pote irania'in ienuk haria i'atu­py­'ahak kahato hary­poria ete hawyi te'e­ro'e to'ope — Ta'i ha'up woity kahato ti mekewat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yt naku i ti mohag hy moma yne hat hary­poria i'atu'e. Waku po'og ti toiwe­neru hawyi ti ha'up iwato yt hekat i rakaria pe toimõ'ẽ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma'ato Iesui to'e — Kat poteĩ eweha­ty'i haty'i mesup hary­poria tero tutunug wakuap uhepe e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yt hekat i rakaria ti aru tukup­te'en wuat'i e'at pe eiwywo e. Karãpe ewetunug waku teran mi'iria pe mi'i pote waku eweimõ'ẽ ehekat mi'iria pe wuat'i e'at pe wen ma'ato Uito yt areĩne'en mot'i i eiwywo ewetunug waku uhepiat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ta'i mesuwat hary­poria ti'okpun howakai te ra'yn uipiit ete mohag hy uhyp hap e'yianmete e. Mi'i ti inug waku uhepe tomikuap ok tã e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mi'i pote pywo pe ti rat are'e ehepe aikope aikope ti aru mesuwat yi wato hap ok tã miit'in henoi Tupana ehay wakuat mi'i hap i'ewyte te ti aru mesuwat hary­poria minug wakuap uhepiat hap ta'a­tu­henoi wuat'i ywania pe yt waure­'i­'a­tu'e i hamo e Iesui i'atuepe — Yt naku i tutunug mekewat hary­poria e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mi'i hawyi sura­ra'in tikat kahato Iesui i'auka hamo ma'ato yt ta'a­tu­puẽti i. Mi'i hawyi wẽtup ok hemiit 12 ok hap toto pa'i wato ko'i kape Iesui enoi i'atupo piat hamo. Mi'i hawyi put'ok'e hawyi Iuta henoi. Mi'i pote i'atu­wepit kahato pa'iria akag ko'i — Ta'i urutum epe ha'up Iesui puẽti hamo i'atu'e tope. ");
INSERT INTO mavNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mi'i hawyi Iuta tikat at ka'ap aikotã waku sura­ra'in po piat hum hamuat hap. ");
INSERT INTO mavNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mi'i hawyi mekewat man teneg u hap e'at put'ok'e hawyi mekewat i'atuhũ Kuteiru mẽpyt auka hap e'at put'ok'e ra'yn hawyi hemiit'in apo'i­'a­tu'e Iesui pe — Aikopeĩ etiky­'esat koity urutunug aheman teneg u hap e'at mesuwat ewãtym Mehĩ i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mi'i hawyi Iesui tipo­'oro typy ok temiit tawa Ieru­sarẽi kape ma'ato sa'a­wy'i toi'a­tu­nãpin aikotã som waku ta'a­tunug hap. Mio tã e typy ok pe — Pyno eweiwat ro eipe tawa kape e. Put'ok­'e­wei'e hawyi te ti aru eweipuẽti wẽtup ok ihainia kamũti piat y'y so'osat hat e. Mi'i ti aru tut ehowawi teka­mũti wywo e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mi'i upi o eweiwat hawyi ti aru teke wẽtup ok yat pe e. Mi'i hawyi o ewehenoi uhehay mekewat netap ka'iwat pe — Aiũwat okipy keĩ waku wo'o­mu'e hat temiit'in nywo teman teneg u wãtym muo mesup ewei'e o netap ka'iwat pe e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","— Mi'i pote ti aru netap ka'iwat tomo­herep ehepe okipy wato ywaiti rakat waku yne rakat ra'yn e. Mi'i pe o eweipo­rokpun yparakai mesa tote aimi'u ko'i e Iesui temiit typy ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mi'i hawyi tuwat ra'yn tawa kape. Mi'i hawyi ti aikotã aikotã Iesui henoi i'atuepe sa'a­wy'i hap ewy yne ra'yn ta'a­tu­puẽti. Mi'i hawyi put'ok­ta­'a­tu'e hawyi ta'a­tu­po­rokpun yparakai tote ta'a­tu­mi'u ko'i. ");
INSERT INTO mavNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mi'i hawyi ti wãtym i turan ni tut ra'yn Iesui temiit'in 12 ok takaria wywo. ");
INSERT INTO mavNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mi'i hawyi ta'a­tuenuk hap tote Iesui to'e temiit'in me — Pywo pe ti are'e wẽtup ok ti aipy­'a­setpe ahenuk tuwy uhenoi aru wanĩ­kaptia sura­ra'in po piat ui'auka hanuat e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mio tã e pote ti hemiit'in haty'u kahato ta'a­tu­py'a pe hawyi wẽtup ok tuereto apo'e Ta'a­tu­mu'e hat pe — Urumu'e hat uito apo ema'at hat apo'i­'a­tu'e tuereto. ");
INSERT INTO mavNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mi'i hawyi Iesui ti'a­tu­wesat — Eipe 12 ok hap wyti mekewat mĩkau u piat uiwywuat man pag hat kui'a piat wyti Eheyke'et ma'at hat toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ta'i Uito Eheyke'et wyti iku'uro irane aikotã sa'a­wy'i Tupana ehay enoi haria henoi hap ewy ti ra'yn e Iesui. Ma'ato ti aru yt naku i yn na'yn Eheyke'et ma'at hat topy­hu'at wuat'i e'at pe e. Ta'i waku po'og uima'at hat yt karãpe i sa'a­wy'i i'ywã'ĩ hap e'at piat toĩne'en e Iesui temiit Iuta piat. ");
INSERT INTO mavNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mi'i hawyi te'e­renuk hamo Iesui tat wẽtup a man hawyi waku e Tupana pe hawyi toipikpik hawyi toimõ'ẽ temiit'in me. Mi'i hawyi to'e i'atuepe — Ewetu'u ro man pikpik e. Mi'i ti uipiit e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mi'i hawyi ihy kui'a piat totat hawyi waku e Tupana pe hawyi toimõ'ẽ i'atuepe. Mi'i hawyi yne te'e­re­'y'u ihy wo. ");
INSERT INTO mavNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mi'i hawyi to'e Iesui — Mi'i ti uhuu at hap miit'in wo'o­wehik Tupana wywuat hamuat hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Pywo ti are'e ehepe mi'i hawyi ti aru yt are'y'u i ra'yn sapo hy mesuwe eiwywo ma'ato karãpe Tupana toĩne'en Morekuat no mi'i hap e'at pe ti aru watu­we­'y'u i ra'yn e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mi'i hawyi te'e­ru­wepy Tupana pe hawyi tuwat Uriweira yp e'yity'ok kape i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mi'i hawyi Iesui to'e towy­ria'in me — Eiwe­sytpok yne ti aru ui'ya­ty­pepyi mesup ewãtym e. Ta'i ui'atoiat yne eipe aikotã iwan me sa'a­wy'i tohenoi hap ewy ti aru — Ta'a­tu­ka­'iwat auka hawyi ihũ ko'i tuwe­sytpok yne e miwan me e Iesui towy­ria'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mi'i hawyi to'e — Ma'ato uimoieĩ­ne'en i hap hawyi ti aru areto ehe'yian me uimotag hap Karireia kape e. Mi'i hap tote ti aru wato­'o­puẽti i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mi'i hawyi Peteru to'e Iesui pe — Irania'in e'atoiat yne mesup ewãtym mote uito yt woro­'atoiat hin i e Peteru Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma'ato Iesui — Pywo pe ti mesup ewãtym na'yn ni aru waipaka ehay typuot hap owakai ti aru — Yt atikuap i Iesui ere'e irane irania'in me mye'ym mo e Iesui Peteru pe. ");
INSERT INTO mavNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mi'i hawyi tehay pirik wo Peteru wẽtup het Nu to'e — Yt nyti yt nyti e. Ui'auka irania'in ewywo pytkai yt woro­'atoiat i En e Peteru Iesui pe. I'ewyte irania'in hemiit'in Peteru ehay ewyte i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mi'i hawyi toto Iesui towy­ria'in nywo mikoi ypia ikahu rakat Kese­mani e hap kape. Mi'i hawyi to'e towy­ria'in me — Ewei'apyk to meiũpe uhehay Tupana wywuat turan e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mi'i hawyi totioto Peteru Tiaku Iuwãu tuwe­wywo hap tote. ");
INSERT INTO mavNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Toha­ty'u tuwa­nẽtup kahato hawyi to'e i'atuepe — Uiwy­ria'in Uito ti ahaty'u kahato ra'yn uipy'a pe e. Ta'i ipoity'i kahato ti uhete e. Yt uipy'a wasu i hap porap ui'auka e. Ewehe­ha'at ro wanĩ­kaptia pupi e Iesui hemiit'in mye'ym ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mi'i hawyi toto porap i hawyi parag'e towa puo tehay Tupana kapiat hamo. Mi'i hawyi to'e — Ui'ywot e etiky­'esat pote etihep o meiko­ranmuo uikaipyi e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ui'ywot wuat'i nug kuap hat En mi'i tupono etat teran uipo pyi meikowat kui'a mi'i pote etat ma'ato yt pote yt e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mi'i tã to'e kahu hawyi ta'aipok ta'yn towy­ria'in kape. Mi'i hawyi ta'a­kasa towy­ria'in kape mi'i turan ti te'e­roket ne'i ra'yn iwyria'in. Mi'i hawyi to'e Peteru pe — Uhyt Simãu ereket apo'e. Yt eraha'at porap'i apo uheka­wiano e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yt eweiket ne'i tei'o ma'ato ewehẽtup o Tupana pe koran ni yt ahiag eihã'ãg hawyi ewetunug yt naku i hap e. Ta'i ewetunug neran ni Tupana miky­'esat ewy eipy'a pe ehesaika kahato wen ma'ato ti eipiit wyti iperup kahato hap ewy toĩne'en e Iesui Pete­ru'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mi'i hawyi toto i ra'yn Iesui Tupana wywo tehay hamo — Papai e etiky­'esat pote etihep o uipo pyi meikowat kui'a ma'ato yt pote yt e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tehay kahu hawyi ta'aipok i ra'yn towy­ria'in kape. Mi'i turan ni te'e­roket i typy wo ra'yn yt mehit­'i­'a­tu'e kuap i ra'yn. Mi'i hawyi yt kat i'atu'e kuap i ra'yn te'e­ru­we­mõti i ra'yn haype. ");
INSERT INTO mavNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mi'i hawyi toto hawyi kat e sa'a­wy'i ihay mi'i e hap ewy te ihay hawyi ta'aipok hawyi toi'a­tu­puẽti i ra'yn i'atuket kai mye'ym mo. Mi'i hawyi to'e i'atuepe — Eweiket i ra'yn apo'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pyno toran na'yn e. Koran na'yn ni yt nakuaria i po pe Uito Eheyke'et topy­hu'at e. Put'ok'e ra'yn uiku­'uro hap e'at e. Eweipoĩ'ãm no eweha'at ro meikowo ti uima'at hat tut ra'yn ui'auka haria wywo e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mio tã e turan wẽtup ok hemiit Iuta 12 ok hap tut. Mi'i wywo typy'i kahato ra'yn sura­ra'in tõ'ẽ tõ'ẽ Iesui pyhik hanuaria. Irania'in aria'yp ãkun ko'i wywo irania'in kyse'yp wywo tõ'ẽ tõ'ẽ. Pa'i koro miwan enoi haria nagnia mipo­'o­roria tõ'ẽ tõ'ẽ hemiit Iuta upi. ");
INSERT INTO mavNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sa'a­wy'i ma'ato Iuta henoi sura­ra'in me — Aiũwat uimi­'ã­pysin o eweto­pytyk to e katu­pono ti aru Iesui ra'yn Mi'i Miit e. Mi'i ti aru ewei'a­pykok kahato o hawyi ewetioto o e Iuta sa'a­wy'i sura­ra'in me. ");
INSERT INTO mavNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mi'i hawyi put'ok­to'e hawyi Iuta tokosap Iesui kape meremo hawyi — Uimu'e hat to'e hawyi toi'ã­pysin na'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mi'i hawyi sura­ra'in topytyk ta'yn Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mi'i pote wẽtup ok Iesui emiit i'yatypiat iherep ta'yn towape pyi kyse'yp hawyi toi'a­ha­pehep ta'yn pa'i akag emiit. ");
INSERT INTO mavNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mi'i hawyi topyhik teran haria pe to'e Iesui — Sero­'ok'e hat Uito mi'i pote apo eweĩ'ẽ uipyhik hamo kyse'yp ko'i wywo aria'yp ãkun ko'i wywo e. Ha'a­wyte areĩne'en at eiwywo Tupana mõtypot yat pe wuat'i e'at pe eimu'e hamo ma'ato mekewat e'at pe yt uipytyk hin i eipe e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ma'ato mesup ti aikotã nimo tohenoi yianme miwan me uhetiat hap ewy ti ra'yn uipytyk eipe e topyhik haria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mi'i hawyi iwyria'in yne ti'atoiat ra'yn Iesui. Te'e­ru­we­sytpok yne ipytyk pote. ");
INSERT INTO mavNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mi'i hawyi ma'ato wẽtup kurum wasu toto Iesui upi tuwe­suwy puo yn. ");
INSERT INTO mavNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mi'i hap tote ta'a­tu­pytyk ta'yn mi'i kurum wasu hesokpe ete ma'ato totoiat tuwe­suwy hap i'atupo pe hawyi topopy kahato ra'yn yt kat i topiit piat sokpe wywo i teput. ");
INSERT INTO mavNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mi'i hawyi ta'a­tue­reto Iesui pa'i akag koro kape. Mi'i hawyi yne nagnia pa'i wato ko'i miwan enoi haria te'e­ru­wa­'a­tunug na'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mi'i hap kape toto Iesui upi Peteru ma'ato yt heremo i. Mi'i hawyi tokosap Iesui upi pa'i wato e'oken­'ypy kape. Mi'i hawyi ta'apyk sura­ra'in py'a­setpe aria kupyke tuwe­mõpe hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mi'i hawyi pa'i wato emiit'in tu'i­saria wywo ta'a­tukat Iesui kuasa te haria i'auka hamo — Ara'a­kasa Iesui yt naku i nug hap kape e haria ma'ato yt ta'a­tu­puẽti i. ");
INSERT INTO mavNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mi'i pote heso rakaria yn na'yn henoi ikuasa hap itote ma'ato yt i'ewy i ra'yn ta'a­tu­henoi sa'ag. ");
INSERT INTO mavNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mi'i hawyi ikuasa haria wẽtup ok wẽtup ok i'atu­poĩ'ãm ta'a­tuehay hamo — Ta'i ha'a­wyte Iesui to'e — Atipugha aru meiũpiat Tupana mõtypot yat miit'in minug ko'i e ti i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Mi'i hawyi wẽtup Tupana mõtypot yat atunug mye'ym e'at pe yn e. Mi'i hawyi Tupana yat atunug yt mo wuat i minug na'yn e ti Iesui i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma'ato yne i'atu'e hap ko'i yt to'o­'ewy i ta'a­tu­henoi. Mi'i hawyi ipoĩ'ãm na'yn pa'i akag koro apoto'e Iesui piat hamo — Ta'a­tu­henoi kahato eminug yt naku i hap ko'i ma'ato yt kat ere'e i e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Eti'a­tu­wesat ro pywo apo ta'a­tu­henoi sio yt e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma'ato ipo'inik ne'i ra'yn Iesui yt kat e i hawyi pa'i akag i ra'yn apo'e tope — En apo Tupana Mipo­'oro Miit'in Porekuat nuat sio yt e. En apo Tupana Wakuat Sese rakat Sa'yru e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mi'i hawyi ti Iesui tiwesat — Ta'i Uito Mi'i Miit e'e hap ewy e. Meiũran ti aru ewei'a­kasa Uito Miit'in Yke'et Tupana hesaika po'og nakat po sese kai apyk pe e. Ta'i ewei'a­kasa ti aru uhut turan atipy kaipyi ywyhig kytsig me e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mio tã e Iesui pote pa'i akag koro totat tesokpe hawyi toihiot ra'yn topy­'ahak hap Iesui ete moherep hamo irania'in me — Heso kahato Iesui e pa'i akag koro. Ihay sa'ag kahato Tupana ete — Ta'i Uito Tupana Mipo­'oro Wuat'i Ywania ehakye­ra'at hamo e hap yt naku i kahato. Pyno yt wati­ky­'esat i po'og miit'in ehay Iesui etiat meiũpe katu­pono iwẽ pyi yne ahehamo yt naku i mio tã sa'ag ihay e. Pyno aikotã ewetunug neran mesuwat Miit heso rakat ete e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mi'i hawyi irania'in tiwesat — Ta'i mio tã e hat auka potiat ne'i yn waku i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mi'i hawyi irania'in kuitu­'i­'a­tu'e Iesui ete hawyi irania'in ihahik i'ahyk ahyk hamo hawyi te'e­ro'e — Etikuap yne pote uwe mio e'ahyk ahyk apo'i­'a­tu'e Iesui pe. I'ewyte sura­ra'in howa petek tuereto Iesui piit ete. ");
INSERT INTO mavNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mi'i turan Peteru toĩne'en oken note aria kupyke tuwe­mõpe turan ni wẽtup pa'i koro emiit hary­poria tut. ");
INSERT INTO mavNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mi'i ta'a­kasa Peteru kape aria kupyke hawyi teha'at hawyi to'e — Are an worokuap en tawa Nasare piat Iesui emiit keĩ en e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma'ato Peteru to'e — U pãi yt atikuap i kat ere'e mana e. Mi'i hawyi Peteru toto kurara e'oken­'ypy wato kape. Ikosap turan wẽtup waipaka ihay. ");
INSERT INTO mavNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Meiũran tut i ra'yn turan mekewat hary­poria pa'i wato eropat hat hawyi i'ewyte to'e Peteru yaty­piaria pe — Meiũ ti Iesui emiit e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma'ato Peteru i'ewyte — Yt uito i rat e. Meiũran i'yaty­piaria i'ewyte te'e­ro'e — En nat wẽtup ok hemiit katu­pono tama Karireia kaipywiat en i'atu'e. Epusu Karireia pusu ewy kahato pote uruikuap en i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma'ato Peteru tiwesat — Yt uheso i ti. Uheso pote waku ra'yn Tupana uhaty'i haty'i e. Pywo rat yt atikuap i Mi'i Miit Iesui ti rat e Peteru. ");
INSERT INTO mavNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mio tã e hawyi ihay i ra'yn mekewat waipaka. Mi'i pote Peteru iwatetup Iesui ehay sa'a­wy­'iwuat kape — Waipaka ehay typuot hap owakai te — Yt atikuap i Mi'i Miit ere'e aru uhepiat mye'ym mo irania'in me e Iesui Peteru pe sa'a­wy'i. Mi'i Iesui e hap kape iwatetup Peteru teso hap kape hawyi tuwak kahato haty wo tuwe­mõti kahato haype. ");
INSERT INTO mavNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mi'i hawyi hunete at wẽtem hawyi meremo te'e­ru­wa­'a­tunug pa'i wato ko'i nagnia miwan enoi haria yne yne irania'in wo'o­nãpin sa'ag haria wywo i ra'yn te'e­ru­wa­'a­tunug. Mi'i hawyi to'ope to'oehay aikotã aikotã waku Iesui ete ta'a­tunug hap ko'i ete. Mi'i hawyi ta'a­tu­po'i po'i hawyi ta'a­tue­roto hawyi ta'atuium morekuat Piratu kape. ");
INSERT INTO mavNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mi'i hawyi morekuat apo apo'e Iesui pe — En apo Iuteu ywania Porekuat e. Mi'i hawyi Iesui tiwesat — Uito Iuteu Ywania Porekuat ere'e apo e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mi'i hawyi pa'i wato ko'i tikuasa kahato ra'yn Iesui. ");
INSERT INTO mavNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mi'i hawyi morekuat Piratu apo'e i Iesui pe — Ekuasa kahato mi'iria Uhyt e. Yt kat ere'e i apo eti'a­tu­wesat e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma'ato yt kat e i po'og Iesui tiwesat. Mi'i pote morekuat tuwa­nẽtup kahato — Kat poteĩ yt uiwesat i e tuwa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yne 12 ewaty e'at pe ienuk hap e'at pe morekuat tipo­re­nõtem wẽtup ok wo'o­pyhik hap wyi miit'in miky­'esat ewy. ");
INSERT INTO mavNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mekewat ewaty pe toĩne'en morekuat wo'o­pyhik hawe wẽtup ok yt naku i rakat Parapa e hap. Mi'i ti morekuat tipyhik sa'a­wy'i katu­pono wo'o­hoiro hap tote toi'auka wẽtup ok miit. ");
INSERT INTO mavNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mi'i hawyi te'e­ru­wa­'a­tunug morekuat kape miit'in kahato hawyi ta'a­tu­hẽtup — Morekuat etipo­re­nõtem i ro emipyhik wẽtup ok i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mi'i hawyi Piratu tiwesat — Eweiky­'esat apo pyno atipo­re­nõtem ei'y­wania Porekuat Iesui hap e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mio tã e Piratu i'atuepe pa'i akag ko'i moweu­ka'i hamo katu­pono Piratu tikuap pa'i ko'i Iesui auka teran i'atu­py­'ahak kahato tuete miit'in miat iky'e pote i'atu­ha­'y­wywi pote. ");
INSERT INTO mavNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mi'i hawyi pa'i akag ko'i te'e­ro'e ta'a­tue­miit'in me — Yt etipo­re­nõtem nei'o Mi'i Miit Iesui ma'ato etipo­re­nõtem emipyhik Parapa ewei'e ro morekuat Piratu pe i'atu'e ta'a­tu­mi­mu­'eria ko'i pe. ");
INSERT INTO mavNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mi'i hawyi Piratu to'e — Kat aru pyno atunug Ei'y­wania Porekuat ete e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mi'i hawyi ta'a­tu­wesat ta'a­tuehay pirik wo — Ewei'auka ro ewei'auka ro aria'yp posak ete i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mi'i pote Piratu apo'e — Kat poteĩ kat som tutunug yt naku i e. Mi'i hawyi te'e­ro'e i po'og haty wo — Ewei'auka ro aria'yp posak ete i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mi'i hawyi mi'iria mowepit hamo morekuat Piratu tipo­re­nõtem Parapa wo'o­pyhyp hawyi. Mi'i hawyi toipo­'oro Iesui ipokpok hamo hawyi tutum tesu­ra­ra'in me aria'yp posak etiat ipehik hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mi'i hawyi sura­ra'in tioto Iesui aikope morekuat mipyhik haria saty'i saty'i hamuat hap kape. Mi'i tote hawyi hereto haria ti'a­tu­kaykay irania'in sura­ra'in ko'i Iesui moweu­ka'i hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mi'i hawyi ta'a­tupag Iesui ipiit pe sokpe hup'i morekuat ewy. Mi'i hawyi ta'a­tu­pi'ig morekuat e'amãtap ma'ato hu kawiat ne'i ma'ato. Mi'i hawyi ta'a­tupag i'akag me ta'a­tu­mi­ky­ry'i hap. ");
INSERT INTO mavNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mi'i hawyi te'e­ru­wẽ­powat ta'a­tu­mi­ky­ry'i hap — Wakuat wakuat En Urupo­rekuat i'atu'e sa'ag imohit hap ne'i ma'ato. ");
INSERT INTO mavNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mi'i hawyi te'e­ro­poityk pina wy'yp ko'i wo i'akag ete hawyi kuitu­'i­'a­tu'e tuwete hawyi te'e­ru­we­pỹ­'ã­tutuk ta'a­tu­mõ­typot yt pywo pe i hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ta'a­tu­mi­ky­ry'i kahu hawyi ta'a­tuhep i ra'yn ta'a­tu­mipag sokpe hup'i morekuat ewy hap hawyi ta'a­tupag iwat hesokpe sese i ra'yn. Mi'i hap totepyi ta'a­tue­reto aria'yp posak etiat i'auka hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mi'i hawyi mu'ap upi tut Simãu yi Sireneu kaipywiat mekewat Aresã­tere ywot Huwu ywot tut toko kaipyi. Mi'i hawyi tokosap hawyi sura­ra'in te'e­ro'e tope — Etipo­wyro ro Iesui he'a­ria'yp posak ereto hap ete i'atu'e mekewat Simãu me. ");
INSERT INTO mavNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mi'i hawyi ta'a­tue­roto Iesui I'akag Kag e hap e'yity'ok kape ma'ato Iesui pusu puo Koukuta e hap kape. ");
INSERT INTO mavNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Put'ok­ta­'a­tu'e hawyi ta'atuium neran Iesui pe mohag Mira e hap Winu hy puo haty monik hamo ma'ato yt tutu'u i. ");
INSERT INTO mavNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mi'i hawyi ta'a­tuhep i ra'yn hesokpe hawyi te'e­ru­we­mo­hara ra'yn aikotã waku hesokpe ta'a­tu­pat'ok pat'ok hamo to'ope. ");
INSERT INTO mavNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mi'i hawyi ihot'ok po'og na'yn ta'a­tu­pehik ta'yn aria'yp posak ete. ");
INSERT INTO mavNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mi'i hawyi toĩne'en miwan kat pote Iesui auka hap enoi hap aria'yp posak tote. Mi'i ti henoi miit'in me — Mi'i Miit Iuteu Ywania Porekuat e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","I'ewyte typy ok iwywo ta'a­tu­pehik i'atue­'a­ria'yp posak ete sero­'ok'e haria miit'in atu'uka haria ipo ran kai ipo sese kai aikotã nimo ta'a­tu­henoi miwan me. ");
INSERT INTO mavNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","— Yt nakuaria i py'a­setpiat iku'uro pote Mi'i Miit i'ewyte yt naku i te'e­ru­wa­nẽtup hawe e Tupana ehay moherep hat Isaia tomiwan 53.12 pe. ");
INSERT INTO mavNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mi'i hawyi gosap haria te'e­ru­we­mõ­ko'i mõko'i howawi ta'a­tuehay miky­ry'i tuwete — Meiẽ Tupana mõtypot yat okhytpun hat hawyi mye'ym e'at piat yn inug pakup i hat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","— Ereha­kye­ra'at ro i'atu'e. Era'apyk to e'aria'yp posak pyi i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","I'ewyte pa'i watoria miwan enoi haria to'o­ky­ry'i tuete — Ta'i irania'in ni toi'a­tue­ha­kye­ra'at kuap ma'ato tuwewi ti yt tuwe­ha­kye­ra'at kuap hin i i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mi'i hawyi te'e­ro'e miky­ry'i hap wywo Iesui pe — Pyno En ni Tupana Mipo­'oro Aipo­rekuat no pote waku era'apyk to aria'yp posak kaipyi i'atu'e. Ta'i e'apyk hap aria'yp posak pyi uruta­'a­kasa pote ti aru uruimohey ra'yn En yt pote yt i'atu'e Iesui pe imoweu­ka'i haype. Mi'i hawyi i'yaty­piaria mipehik ko'i te'e­ro'e yt naku i tope irania'in ehay ewy. ");
INSERT INTO mavNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Atpo­sake hawyi at min'e hap kape i'ypyryp kahato wãtym ewy ra'yn yne mesuwat yi tote topy­hu'at. ");
INSERT INTO mavNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mye'ym ura hawyi Iesui iwẽpap'i tehay pirik wo — Uhetu­pana Uhetu­pana kat pote ui'atoiat En e. Ma'ato topusu puo to'e — Erui Erui irama sapa­tani apo'e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mi'i hawyi seha'at haria te'e­ro'e — Meiẽ toikaykay sa'a­wy­'iwuat ase'i Eria topo­wyro hamuat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mi'i hawyi wẽtup ok teput amũkiusu ap ewywuat kape hawyi toipo'i pina wy'yp ãpo ete hawyi toipuk'a ihy haiũg nakat pe. Mi'i hawyi tutum Iesui pe ihy sym hamo. Mi'i hawyi to'e irania'in me — Apuete to'iro wate­ha'at sio Eria tut imo'apyk aria'yp posak pywiat hamo sio yt e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mi'i hawyi Iesui kak'e haty wo hawyi ipyhu tek'e ra'yn iku'uro sese ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mi'i hawyi Tupana mõtypot yat wato e'okenhyp wato sokpe i'anam kawiat miit'in pyhyp Tupana kapiat hap hiot'e ra'yn atipy kaipyi oken'ypy yi kape. ");
INSERT INTO mavNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mi'i hawyi surara akag Iesui owakaipyi ta'a­kasa yne aikotã Iesui iku'uro hap hawyi to'e — Pywo rasig Meiẽ Ihainia ti Tupana Sa'yru sese e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mi'i hawyi hary­poria tawa Ieru­sarẽi kaipy­wiaria te'e­ra­'a­kasa pya pyi Iesui auka hap kape. Mi'i haria py'a­setpe tukup­te'en mana Sarume mana Maria yi Mata­rena kaipywiat hawyi mana Maria Tiaku hit ty Iuse ty. ");
INSERT INTO mavNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mi'iria sa'a­wy'i Iesui ieĩne'en tama Karireia piat turan tuwat Iesui upi heropat hamo. Yt mi'iria yn i ma'ato i'atu hary­poria tõ'ẽ Iesui upi Ieru­sarẽi kape. Mi'i pote tukup­te'en itote mekewat e'at pe i'auka hamuat turan. ");
INSERT INTO mavNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tupana mõtypot hap e'at owakai te waku puo yne ra'yn ta'a­tunug neran motpap ko'i Iuteu ywania. ");
INSERT INTO mavNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mi'i pote wãtym'i turan pote Iuse tawa Arimateia kaipywiat ti'asyp teran na'yn Iesui piit meremo at min'e hap yianmete. — Iuse ti Iuteu ywania atunãpin hat akag waku sese rakat i'atu'e. Mi'i ti hekatup kahato karãmuo Morekuat no Tupana tut hap e'at. Mi'i ti toto morekuat Piratu kape Iesui piit ẽtup hamo hyp hamo. Morekuat pupi yt token'ẽ hin i. ");
INSERT INTO mavNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mi'i hawyi morekuat Piratu tuwa­nẽtup — Iku'uro ra'yn koitypuo yt pãi e tuwa­nẽtup hawe. Mi'i pote toikaykay tesu­rara akag hawyi apo'e tope — Iku'uro ra'yn apo Iesui sio yt e. ");
INSERT INTO mavNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mi'i hawyi toiwesat — Ta'i iku'uro sese ra'yn e. Mi'i pote morekuat tum na'yn Iuse pe ipiit. ");
INSERT INTO mavNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mi'i hawyi Iuse toto sokpe kyt'i kype kyi'at hamo. Mi'i hawyi toimo­'apyk Iesui piit aria'yp posak pyi. Mi'i hawyi tohuwy ipiit mekewat sokpe kype kyt'i wo. Mi'i hawyi totopag ipiit wo'osyp pakup we tominug sa'a­wy'i nu ka'a pe. Mi'i hawyi toho­'o­kenhyp ta'yn nu wato wo ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mana Maria yi Mata­rena piat mana Maria Iuse ty te'e­ra­'a­kasa yne Iesui syp hap aikopiat hyp hap. ");
INSERT INTO mavNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tupana mõtypot hap e'at kosap hawyi mana Maria yi Mata­rena kaipywiat mana Sarume hawyi mana Maria Tiaku ty tikyi'at mohag hy ikamhig se rakat Iesui piit pen hamo. ");
INSERT INTO mavNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mi'i hawyi hunete mytu'u e'at pe at wẽtem turan tuwat ra'yn Iesui syp hap kape. ");
INSERT INTO mavNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mi'i turan mu'ap upi te'e­ro'e to'ope — Uwe aru ho'o­'o­ken­hyp'ok ahepe i'atu'e. Nu wato ipotyi pote Iesui syp hap oken'ypy ete pote aikotã me aru watipen Iesui piit mohag hy wo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma'ato te'e­ra­ha'at turan te'o­ken­hyp'ok pe ra'yn toĩne'en ika'a. ");
INSERT INTO mavNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mi'i hawyi tuwe­hyt'ok nu ka'a pe. Mi'i hawyi mo sese kai apyk pe te'e­ra­'a­kasa kurum iwasu ewywuat atipy kaipywiat ieĩne'en hat sokpe kyt'i i'ywop takat piat. Mi'i hawyi i'atu­perup ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mi'i hawyi to'e i'atuepe — Yt gyt'e­wei'e tei'o e. Atikuap kat pe eweĩ'ẽ. Iesui tawa Nasare piat kape eweĩ'ẽ e. Aria'yp posak etiat mi'auka kape eweĩ'ẽ meikowo e. Yt uwe i ra'yn Iesui meiũpe hyp hawe e. Katu­pono toĩne'en i ra'yn gu'uro pyi e. Ewei'a­kasa ro aikope ipag hap kape are e. ");
INSERT INTO mavNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mi'i pote ewei'aipok i ro iwyria'in miat henoi hamo i'ewyte Peteru kape hawyi ewehenoi Iesui ehay i'atuepe — Areto ti aru ahetama Karireia kape ehe'yianme e hap e. Mi'i tote ra'yn aru wato­'o­puẽti i kat are'e sa'a­wy'i e hap ewy e. Mi'i e hap ewehenoi ro e atipy piat hary­poria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mi'i hawyi hary­po­ria'in ikohyeput kahato Iesui potmu­'eria 11 ok takaria enoi hamo. Yt uwe pe i ta'a­tu­henoi mu'ap upi te'e­ro­ken'ẽ haype. ");
INSERT INTO mavNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mi'i hawyi mekewat mytu'u e'at pe Iesui wẽtem gu'uro pywiat hap e'at pe hunete Iesui tuwe­mo­herep Maria tawa Mata­rena piat kape tomiahiag sopo 7 ok takat pot'i kape. ");
INSERT INTO mavNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mi'i hawyi Maria ta'aipok iwyria'in kape henoi hamo. Mi'i hawyi paa'i­'a­tu'e te'e­ruwak toi'a­tu­puẽti. ");
INSERT INTO mavNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mi'i hawyi to'e i'atuepe — Ta'aipok i ra'yn ni Iesui gu'uro pyi Mimi'in e. Ara'a­kasa i ra'yn an uito e i'atuepe. Ma'ato mio tã e hap iwyria'in yt timohey i. ");
INSERT INTO mavNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mi'i hawyi typy ok hemiit tuwat wẽtup tawa kape. Mi'i hawyi mu'ap tote Iesui tuwe­mo­herep i'atue­wawi ma'ato yt ta'a­tukuap i sa'a­wy'i. ");
INSERT INTO mavNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ta'a­tukuap Iesui hawyi te'e­ra­'aipok irania'in miat henoi hamo. Ma'ato ta'a­tu­henoi hawyi i'ewyte yt ta'a­tu­mohey hin i. ");
INSERT INTO mavNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mi'i hawyi 11 ok takaria kape Iesui tuwe­mo­herep i'atuenuk turan. Mi'i hawyi toi'a­tu­sa­ty'i saty'i tehay wo — Kat poteĩ yt eweimohey i uheĩne'en pakup i hap kapiat akasa haria e. Eipy'a heg kahato rat e i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mi'i hawyi to'e i — Uiwy­ria'in eweiwat ro yne mesuwat yi totiaria wuat'i ywania uhehay wakuat enoi hamo e. ");
INSERT INTO mavNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Uwe uwe uimohey haria weset'ok haria ti aru uimie­ha­kye­ra'at nuaria te'e­ro­py­hu'at e Iesui. Ma'ato yt uimohey i haria ti aru wo'o­'a­piheg haria tukup­te'en wuat'i e'at pe e. ");
INSERT INTO mavNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mi'i hawyi uimohey haria tomo­herep miit'in me wakuap kahato. Mi'i tã ta'a­tunug ahiag ko'i miit'in miat ta'a­tu­sopo uhesaika wo. Musu pakup ko'i ta'a­tu­su'at. ");
INSERT INTO mavNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mi'i hawyi moi ok akit hanuaria tukup­te'en. Moi pytyk pytkai yt haty i uimohey haria ete e. I'ewyte gu'uro hy u pytkai yt haty i i'atuete e. Ta'i i'ahu rakaria ete te'e­ru­we­ponug hawyi waku ra'yn i'atuete e. Mi'i tã ti aru uimohey haria timo­herep miit'in me e Iesui topot­mu­'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mio tã e Aika­'iwat Iesui hawyi Tupana tioto Iesui atipy kape. Mi'i hawyi ta'apyk Tupana po sese kai tomi­mõ­typot po'og eiam note ra'yn ta'apyk ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mi'i hawyi hemiit'in tuwat ra'yn Iesui ehay enoi hamo wuat'i ywania mesuwat yi totiaria enoi hamuat. I'ewyte ti I'atu­ka­'iwat Pã'ãu ipotpap kahato i'atu­wywo tesaika wo wakuap nug hamo miit'in miat tomohey hamo. Toran na'yn uimiwan Uito ti Maku");
INSERT INTO mavNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mesup mienoi wakuat ti Aipo­typot Iesui etiat. Uito ti ewy Iruka. Mesuwat uimiwan atipo­'oro ewawi uiwy Teowiru. Mesup ti atipo­'oro ewawi uimiwan Aimi­mohey Iesui etiat aikotã sa'a­wy'i toĩne'en Aipy­'a­setpiat hat enoi hamuat atipo­'oro uimiwan ewawi mehĩ Teowiru. Mi'i e hap typy'i rakaria tiwan na'yn aikotã saĩke tokosap Tupana Mipo­'oro Iesui ehat aipy­'a­setpiat toĩne'en turanuat hap ko'i. Mi'i hap ko'i ti ta'a­tuwan na'yn. Mi'i e hap ti wẽtup ok wẽtup ok tiwan na'yn ta'a­tupo wo. Mi'iria miwan toĩne'en uipo pe hawyi — Pyno waku i'atu­miwan kaipyi atiwan yne sehay Iesui etiat wẽtup yn uimiwan me are'e uipy'a pe hawyi mesup ewawi mehĩ Teowiru atipo­'oro ra'yn yne urumikuap wẽtup yn miwan me are. ");
INSERT INTO mavNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mi'i pote irania'in miwan Iesui etiat aremu'e kahato hawyi atikuap kahato Iesui minug ko'i i'ewyte Iesui e hap ko'i. Mi'i hawyi are'e — Pyno waku atiwan yne Iesui etiat wẽtup yn uimiwan me are. Pyno waku Iesui wywo hewyry rakaria wẽ pyi yn atiwan yne Iesui ete i'atu­mi­'a­kasa ko'i sese are. Waku atiwan yne Iesui e hap i'atu­mikuap ko'i are. Waku Iesui wywo hewyry rakaria yn uimu'e are'e uiwepe are. Waku Iesui kuap haria miwan kaipyi yn atiwan uimiwan are. Mi'i hawyi waku atipo­'oro uimiwan Iesui ky'e haria pe are. ");
INSERT INTO mavNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pyno ti uito i'ewyte atikuap yne yne aikotã aikotã Iesui etiat hap sa'a­wy­'i­wuaria iwywo hewyry rakaria mienoi ko'i. Mi'i hawyi atiwan mesuwat uimiwan i'atu­miwan ko'i ewat'ymo. Pyno waku. ");
INSERT INTO mavNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mi'i uimiwan Iesui etiat mesup atipo­'oro ra'yn ewawi uiwy sese Teowiru are. Pyno sa'a­wy'i ahenoi teran aikotã Iesui ywã'ĩ hap etiat aikotã sa'a­wy'i tuwe­mo­herep hap etiat. ");
INSERT INTO mavNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sa'a­wy'i ti Iesui ywania etama puo toĩne'en wẽtup ok Pa'i Sakaria e hap het rakat. Mi'i miit Pa'i koro wo turan hap e'at pe Iesui ywã'ĩ hap e'at put'ok'e. Pyno waku sa'a­wy'i uimiwan me ahenoi epe kurin pa'i Sakaria e hap ete. Pa'i Sakaria sa'a­wy'i pa'i koro wo toĩne'en Tupana mõtypot yat koro pe. I'ywot ti Pa'i koro Api'a e hap het rakat. Mi'i saipepiat ipotpap takat Pa'i Sakaria toĩne'en. Mi'i tupono pa'i Api'a emiariru ko'i tukup­te'en pa'i ko'i wo tawa wato Ieru­sarẽi me ma'ato haipepiat sese ti pa'i Sakaria toĩne'en. Mi'i pote Pa'i koro wo toĩne'en tawa wato Ieru­sarẽi me. Ma'ato Pa'i Sakaria yt ha'yru rakat i katu­pono ihary'i Isapeu yt karãpe i imẽpyt rakat toĩne'en. Pyno pa'i koro Sakaria e'ase'i koro sese Arãu toĩne'en mekewat Musei yket'et. Mi'i pote Sakaria pa'i koro sese toĩne'en. Sakaria ipotpap kahato pa'i wo ma'ato yt iwepit sese i katu­pono yt kat i tosai­pepiat nuat pote. I'ewyte mana Isapeu yt iwepit i. Ta'a­tu­ky­'esat kahato ta'a­tu­mẽpyt hap. Sakaria toĩne'en pa'i koro wo Eroti toĩne'en morekuat no turan. ");
INSERT INTO mavNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pa'i Saka­ria'in waku kahato rakaria wo tukup­te'en Tupana wanẽtup hawe. Ta'i Tupana miky­'esat yn nug haria yn mi'iria. Pa'i tunug kahato wuat'i e'at pe Tupana mienoi ewy. ");
INSERT INTO mavNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mekewat e'at pe turan ma'ato pa'i Sakaria saipe­pianuat yt kat i katu­pono i'atu­poro kahato ra'yn. I'ewyte heha­ry'i mana Isapeu pyhu'at hap tokosap woity'i ra'yn. Mana Isapeu ti topakup wyi te yt karãpe i imẽpyt. ");
INSERT INTO mavNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wẽtup e'at pe pa'i koro Sakaria toĩne'en Tupana mõtypot yat koro pe Tupana miky­'esat nug hamo to'ywot Api'a potpap ewy te tutunug. ");
INSERT INTO mavNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","To'y­wot'in Api'a'in potpap ewy te toĩne'en ipotpap kat pote to'ywot Api'a'in saipepiat sese toĩne'en. Pa'i Api'a'in mi'airo Sakaria pote i'atueko ewy te tutunug itote. Mi'i pote pa'i Sakaria teke Tupana eiam sese pe Tupana mõtypot hamuat ikamhig se rakat wuk hap yparakai tote. Mi'i tote toiwuk ikamhig se rakat Tupana mõtypot hamuat hap. ");
INSERT INTO mavNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mi'i wuk totiat turan okeny­pyke õ'ẽ haria typy'i kahato Tupana kapiat ihay raka­nuaria tukup­te'en. ");
INSERT INTO mavNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mi'i hawyi Tupana mõtypot yat e'oki­pyke atipy kaipywiat sut hat tuwe­mo­herep ta'yn pa'i Sakaria kape. Mekewat mohag wuk hamo ran kawiat rote tuwe­mo­herep. ");
INSERT INTO mavNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ma'ato pa'i Sakaria mekewat wemo­herep hat pupi token'ẽ kahato ne'i ta'a­kasa hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mi'i pote atipy kaipywiat sut hat to'e pa'i Sakaria pe — Yt ereken'ẽ tei'o e katu­pono Tupana miium epiat sa'a­wy­'iwuat emiẽtup ta'yn emẽpyt ky'esat hap ta'yn e. Mi'i hawyi ehary'i ti imẽpyt irane ra'yn e. Esa'yru irane ra'yn wyti Tupana miium epiat e. Mi'i set wyti Iuwãu e hamuat waku ehet'ok iwemo­herep hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mi'i hawyi esa'yru wemo­herep hap e'at pe wyti aru ewepit kahato ra'yn e. I'ewyte ti aru yne irania'in i'atu­wepit kurum hit wemo­herep hap ete hap e'at pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mi'i ti aru Tupana wywuat myhu'at hanuat e. Esa'yru tuwe­mo­herep hawyi meremo howapy ra'yn Tupana Pã'ãu Wakuano e. Ta'i yne e'at pe toĩne'en hap ok tã howapy Tupana Pã'ãu Wakuano e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Itag hawyi ti aru esa'yru ti'a­tu­morem wyti aru e'ase'i Isareu ywania Tupana kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Esa'yru ti aru topy­hu'at Tupana ehay moherep hat akag wo e. Aikotã sa'a­wy­'iwuat mekewat Tupana ehay moherep hat Eria e hap het rakat ewywuat topy­hu'at esa'yru itag hawyi e. Aikotã Eria sa'a­wy'i hesaika kahato Tupana ehay enoi hap ete topy­hu'at mi'i hap ewy te aru esa'yru Iuwãu ete topy­hu'at e. Ta'i esa'yru ti aru miit'in sem mu'e hat koro wo topy­hu'at e. Ipotmu­'eria sem ni aru te'e­ro­py­hu'at wo'o­ky'e hanuaria e. Ta'i wo'o­wese hap sese toterut irane e'ase'i Isareu ywania kape e. Ta'i toi'a­tu­morem kahato ti aru miit'in Tupana kape tehay wo tomienoi wo e. Mi'i hap e'at pe ti aru esa'yru Iuwãu terut wo'o­wese hap sese e'ywania kape e. Mi'i piat ta'a­tu­mu'e hap kaipyi ti aru nagnia'in tukup­te'en wo'o­ky'e haria wo e. Mi'i hawyi hira­karia ti'a­tu­ky'e kahato ta'a­tu­'y­wot'in ta'a­tu­ty'in esa'yru piat ta'a­tu­mẽ­pyt'in mu'e hap kaipyi e. I'ewyte e'ywot'in ti'a­tu­ky'e kahato ta'a­tu­mẽ­pyt'in esa'yru piat ta'a­tu­'y­wot'in mu'e hap kaipyi e. Ta'i ta'a­tu­mu'e hap kaipyi wo'o­wese haria wo yn tukup­te'en i'yat piaria e. Mi'i hawyi ti aru Tupana yt miky­'esat i nug haria esa'yru ti'a­tu­mu'e hap kaipyi Tupana miky­'esat nug haria wo ra'yn tukup­te'en e. Waku puo i ra'yn tukup­te'en Tupana miky­'esat ewy ipotmu­'eria tunug turan ti aru tut esa'yru Mimo­herep mekewat Tupana Mipo­'oro Wuat'i Miit'in Porekuat Nuat e. Mekewat e'at pe meimuẽwat esa'yru mimu­'eria ko'i Tupana Mipo­'oro ekatup hanuaria wo ra'yn tukup­te'en. Mi'i ta'a­tue­katup turan ni aru put'ok'e I'atue­ha­kye­ra'at Hat sese esa'yru Mimo­herep e ti atipy kaipywiat sut hat pa'i koro Sakaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mi'i to'e pote pa'i Sakaria tiwesat sa'ag atipy kaipywiat ehay pe — U pãi e aikotã apuru e'e hap atikuap sio pywo sio yt e. Kat som iwato kahato etomo­herep epo wo ehay sio pywuat sio yt moherep hamo e. Pywo e'e hap pote pywo are aru ma'ato yt pote yt e. Katu­pono uiporo kahato ra'yn i'ewyte uheha­ry'i mẽpyt hap e'at tokosap kahato ra'yn uhyt e. Iporo sese ra'yn uheha­ry'i mehĩ e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mio tã to'e Sakaria pote atipy kaipywiat Tupana e hap erut hat tiwesat haty wo — Uito ti atipy kaipywiat Tupana ehay erut hat koro e. Tupana ti uipo­'oro tehay enoi epiat hamo e. Uhet sese ti Kapireu e. Tupana e hap ewywuat yn moherep hat uito pãi e. Tupana yt karãpe i heso rakat are e. Uito areĩne'en Tupana wywuat sese hat e. Yne ti uhehay uimi­mo­herep epiat Tupana ehay esa'yru wanuat etiat pywo sese topy­hu'at aru katu­pono Tupana to'e mio tã uhepe pote e. Mi'i pote ti aru put'ok'e yne i'e hap ewy emowepit hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Uhyt e kat pote som yt etimohey i Tupana e hap uimierut e. Yt naku i kahato e. Yt etimohey i Tupana e hap pote ti yt ehay kuap i aru uhyt e. I'ewyte ti aru ewaure ka'a pe yt teke kuap i sehay katu­pono Tupana ehay uimierut pytkai yt uimohey i pote e. Ma'ato eimẽpyt put'ok'e ui'e hap ewy era'a­kasa ra'yn esa'yru hawyi ewaure ka'a i ra'yn i'ewyte ehay kuap i ra'yn mehĩ e atipy kaipywiat sut hat pa'i koro Sakaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mi'i turan oken'y­pyke gupte'en haria hekatup kahato pa'i Sakaria wẽtem hap. Mi'i pytkai yt tut i pot'i kahato hawyi te'e­ru­wa­nẽtup to'ope — Katu­ponoĩ koitywy heniatpo kahato toĩne'en mot'i Tupana mõtypot yat pe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mi'i hawyi pa'i Sakaria tuwẽtem hawyi put'ok'e oken'y­py­kiaria ete. Mi'i hawyi tohenoi teran to'e hap wen ma'ato yt ihay kuap i ra'yn. Yt ihay kuap i pote oken'y­py­kiaria te'e­ro'e to'ope — Pyno tomu­'etu wuat ewy ra'yn Tupana e'oki­pyke toĩne'en turan pote yt ihay kuap i i'atu'e te'e­ru­wa­nẽtup hawe. Mi'i hawyi Sakaria topo wo yn na'yn tohenoi teran tehay oken'y­py­kiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mi'i hawyi Tupana yat pe tuwe­potpap kahu hawyi pa'i Sakaria toto i ra'yn to'yat kape. ");
INSERT INTO mavNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Put'ok'e i ra'yn pa'i Sakaria to'yat piat hawyi ti toĩne'en teha­ry'i wywo hawyi ihary'i hupi'a ra'yn Tupana e hap ewy. Mi'i hawyi iheg me toĩne'en 5 ewaty. ");
INSERT INTO mavNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mi'i turan mana Isapeu to'e — Waku kahato Tupana tunug uhepe e. Uiky'e kahato ra'yn Uhetu­pana e. Sa'a­wy'i aremõti kahato yt uimẽpyt i pote ma'ato mesup uhupi'a ra'yn toĩne'en mote yt aremõti kuap i ra'yn e. Sa'a­wy'i irania'in uimohit kahato yt uimẽpyt i pote e. Ma'ato uimẽpyt Tupana miium toĩne'en hawyi yt kat i i'atu'e kuap i aru e. Mi'i pote yt aremõti hin i katu­pono Tupana uiky'e kahato hawyi tutum na'yn uhepe uimẽpyt ra'yn to'e hap ewy e. Waku kahato Tupana e mana Isapeu. ");
INSERT INTO mavNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wẽtup e'at pe hawyi mana Isapeu 6 ewaty hupi'a toĩne'en turan Tupana tipo­'oro i ra'yn sa'a­wy­'iwuat atipy kaipywiat sut hat akag Kapireu wẽtup tama kape i ra'yn mekewat yi Karireia popykiat tawa hit Nasare kape i ra'yn toipo­'oro. ");
INSERT INTO mavNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Itote wẽtup ok pe pĩ'ã makuptia Maria e hap het rakat kape tuwe­mo­herep atipy kaipywiat Kapireu. Pĩ'ã Maria ti yt he'aito rakat i te i'ewyte yt hewaire i te rakat toĩne'en. Toiky­'esat kahato ma'ato te'aito wo wẽtup ok Iuse e hap het rakat mekewat morekuat Tawi emiariru emiariru toiky­'esat. Mi'i tohe­katup turan atipy kaipywiat Kapireu tuwe­mo­herep tope. ");
INSERT INTO mavNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mi'i hawyi to'e tope — Mana Maria e eremo­wepit ro e katu­pono koitywy ti Tupana mipoi­tyro sese wo ereĩne'en e. Katu­pono tutum neran epe emẽpyt ihainia Wuat'i Miit'in Porekuat Nuat e. Mi'i pote ti aru po'og Tupana mipoi­tyro wo ereĩne'en torania hary­poria kai katu­pono Wuat'i Miit'in Potypot ty wo ereĩne'en aru pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mi'i hawyi Mana Maria teha'at kahato atipy kaipywiat kape hawyi tuwa­nẽtup kahato tewawiat sehay kape hawyi — Kat to'e hamuat ewy ran uhepe an e tuwa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mi'i hawyi Kapireu to'e tope — Maria yt ereken'ẽ tei'o e katu­pono Tupana tuwehum kahato ewawi e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pyno emẽpyt irane wyti mana e. Emẽpyt ihainia ti tuwe­mo­herep irane Tupana miium epiat e. Wakuat kahato e'iunmỹ'ã piat Emẽpyt mana e. Emẽpyt tuwe­mo­herep hawyi waku ehet'ok Mi'i — Iesui ere'e e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mi'i hawyi En ni Tupana Po'og Torania Kawiat Sa'yru i'atu'e aru miit'in Emẽpyt Iesui pe e. I'ewyte — En ni Wuat'i Ywania Porekuat no i'atu'e Emẽpyt pe mana e. Emẽpyt ihainia pe Tupana tum aru Morekuat Tawi eiam e. Morekuat Tawi saipe­piano ti aru topy­hu'at Emẽpyt e atipy kaipywiat Kapireu Maria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mi'i hawyi ti aru e'ase'i pot Iako emiari­ru'in sem Porekuat no ra'yn Emẽpyt Iesui topy­hu'at wuat'i e'at pe e. Yt karãpe i aru Emẽpyt piat Wuat'i Porekuat no hap ikahuro e atipy kaipywiat sut hat Maria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mi'i hawyi Maria apo'e — Aikotã aru uhupi'a mimi katu­pono yt kat i te uhe'aito e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mi'i hawyi Tupana mipo­'oro Kapireu tiwesat ra'yn — Ta'i Tupana Pã'ãu tut ewawi e. Mi'i hawyi Ipã'ãu esaika howa eupi'a aru toĩne'en e. Mi'i pote Emẽpyt topy­hu'at ri Tupana Koro Sese Sa'yru e atipy pywiat Maria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","I'ewyte wyti e'api'i pa'i Sakaria ehary'i Isapeu e hap het rakat hupi'a ra'yn wy. Iporo sese rakat pytkai toupi'a wywo toĩne'en mesup to'yat pe e. Pywo pe wyti imẽpyt tuwe­mo­herep irane ra'yn e'api'i pot piat wy e. Sa'a­wy'i yt imẽpyt kahato rakat i e'api'i e. I'ewyte mesup ipo'oro sese rakano toĩne'en. Ma'ato mi'i hap pytkai toupi'a wywo toĩne'en mesup to'yat pe e. Pywo pe wyti imẽpyt tuwe­mo­herep irane ra'yn e'api'i pot piat e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta'i hesaika kahato Ahetu­pana e. Ta'i Tupana ti wuat'i nug kuap hat e. Yt kat i wyti niatpo Tupana wanẽtup hawe katu­pono tutunug kuap yne yne ko'i e. Yt watunug kuap i pytkai Tupana inug kuap e Kapireu mana Maria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mi'i hawyi pĩ'ã Maria to'e Kapireu pe — Uito ti Tupana eropat hano areĩne'en e. Pyno waku atung to'e hap ewy e. Waku Tupana tum uhepe to'e hap ewy e Maria Kapireu pe. Mio tã e kahu hawyi Kapireu ta'aipok ta'yn atipy kape Mana Maria pyi. ");
INSERT INTO mavNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mi'i hawyi Maria tuwe­'a­ru­mary hawyi meremo toto te'a­pi'i Isapeu yat kape. Wẽtup yi mekewat yi Iuta e hap kape yity'ok hit puat mu'ap upi toto. Pya kahato toto. ");
INSERT INTO mavNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mi'i hawyi put'ok­to'e mana Maria pa'i Sakaria yat pe hawyi teke hawyi — Ihot'ok e te'a­pi'i mana Isapeu pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","— Ihot'ok e hawyi mana Isapeu mẽpyt'a huruk'e i'ymyẽ pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mi'i hawyi mana Isapeu howapy ra'yn Tupana Pã'ãu wo hawyi to'e mana Maria pe tehay pirik wo — Waku pe kahato Tupana tunug mesup katu­pono Tupana po'og hegyi'at epe irania'in mana'in kai e. Mesup ta'yn Tupana Sa'yru Sese toĩne'en e'ymyẽ pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tupana Mipo­'oro Aheha­kye­ra'at Hanuat ty wo ra'yn ereĩne'en mesup e. Mi'i pote ti uimo­wepit kahato E'iunmỹ'ã Piat e. Ereke hin waku ereĩne'en uru'yat pe e. En ne po'og uikai katu­pono Tupana Mipo­'oro Aipo­rekuat nuat ty wo ereĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Koitywy — Ihot'ok ere'e uhepe turan uimẽpyt tuwe­mũkup uhe'ymyẽ pe iwepit haype e. Katu­pono uimẽpyt uhunmỹ'ã piat tikuap ta'yn Emẽpyt Eiunmỹ'ã piat toĩne'en Topo­rekuat Koro wuat hap e. Mi'i pote tuwe­mũkup uipiit pe tuwehum kahato haype e mana Isapeu Mana Maria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sa'a­wy'i etomohey kahato Tupana e hap pote mesup waku pe kahato ereĩne'en e. Tupana e hap upi eupi'a ra'yn toĩne'en mesup e. Mi'i pote mesup Tupana mimo­wepit kahato wo ereĩne'en e he'a­pi'i Isapeu pĩ'ã Maria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mi'i hawyi mana Maria tuwehum kahato Tupana ete hawyi to'e — Woro­mõ­typot kahato uipy'a pyi Tupana e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Uheha­kye­ra'at kahato hat En Tupana e. Uimo­wepit kahato hat En e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tupana miha­ky­'e'i kahato rakano. Miit emiit no areĩne'en pytkai uiky'e kahato En an e. Sa'a­wy'i ereha'at uhowawi uiky'e hap wywo e. Yt miit'in miky'e i uito pytkai uiky'e En e. Are an uito wuat'i miit eropat hanuat yn areĩne'en pytkai ui'airo e. Uito ti po'og yi kapiat nakano areĩne'en wuat'i miit emiit kai pytkai uiky'e kahato En e. Mi'i hawyi ui'airo Esa'yru eiam mo Urueha­kye­ra'at hat ty wo e. Ta'i uhewaku hap upi yt ui'airo i ma'ato uiky'e hap upi ui'airo e. Ta'i mi'i pote ti aru — Waku kahato En Tupana i'atu'e ewawi wuat'i ywania Uheha­kye­ra'at hat En mote. ");
INSERT INTO mavNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Esaika kahato En Tupana e Maria. Waku sese En Tupana are katu­pono egyi'at hap kaipyi wakuap sese etunug uhete e. Mi'i hawyi uimẽpyt hap kaipyi wuat'i miit'in te'e­ro'e aru — Waku kahato Tupana i'atu'e epe e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pywo pe ti yne mesu­wa­rotiat gupte'en haria emõtypot haria wo tukup­te'en aru katu­pono Esa'yru mieha­kye­ra­'aria tukup­te'en aru pote e. sa'a­wy­'i­te­wuaria kora­nuaria i'ewyte meiũra­nuaria gupte'en haria yt wemo­herep i te haria ky'e kahato hano ereĩne'en mote e Maria Tupana pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yt uwe i po'og hesaika rakat ekai Tupana e. Waku kahato En po'og po'og torania kai e. Ma'ato irania'in mesu­wa­ro­tiaria — Uruto po'og torania kai e haria mohit sese hanuat ereĩne'en Tupana e. Mi'i hawyi ti aru i'atu­minug sa'ag hap ko'i eti'a­tu­moma yne ra'yn e. I'ewyte i'atu­wa­nẽtup sa'ag hap eti'a­tu­mo­weityk yne ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I'ewyte wemo­wato haria etipuruk kahato i'atu­we­mo­wato hap kaipyi ma'ato mi'i pytkai miit emiit ko'i paa'e haria ewywuaria eti'a­tu­mo­wato kahato morekuat no mesuwe e mana Maria Tupana pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Are an Hegyi'at kahato rakano ereĩne'en hesy'at rakaria pe ihaky­'e'i rakaria pe. Mi'i hawyi mi'u wakuano eti'a­tupoi kahato mi'iria e ma'ato irania'in — Uruto po'og hekat rakaria e haria eti'a­tunug hesy'at kahato rakaria wo e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Waku sese rakat En Tupana are katu­pono yt etiwaure hin e'e hap — Atunug aru e hap etunug yne e'e hap ok tã e. Sa'a­wy­'iwuat urue'a­se'i pot Isareu pe mio tã ere'e — Esaipepiat kawiano wyti aru ati'a­tue­ha­kye­ra'at wuat'i ywania ere hap ewy etunug mesup e. Mesup ta'yn e'e hap ewy eti'a­tu­po­wyro kahato uru'y­wania e'e hap urue'a­se'i pot Isareu piat ewy e urue'a­se'i emiariru emiariru uruto pote. Waku kahato En katu­pono e'e hap urue'a­se'i piat hap ewywuat mesup ta'yn etunug aikotã sa'a­wy'i e'e hap ewy — Atipo­'oro aru emiari­ru'in me I'atue­ha­kye­ra'at hanuat e'e hap ewy etunug na'yn mesup katu­pono etipo­'oro koran uruewawi Urueha­kye­ra'at hat e'e hap sa'a­wy­'iwuat ewy ehay uruky'e wywuat hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aikotã urue'a­se­'i'in me — Atunug aru ui'e hap ewy etunug na'yn mesup aikotã sa'a­wy'i urue'a­se'i koro Aparãu me ere'e hap ewy — Ati'a­tu­poi­tyro aru torania Wẽtup Esaipepiat po wo e. Wẽtup Emiariru upi Eiã'ỹi upi aru ati'a­tu­mo­waku kahato imohey haria wuat'i ywania mesuwat yi totiaria e Tupana sa'a­wy'i urue'a­se'i Aparãu me e. Pyno waku kahato En Tupana katu­pono e'e hap ewy ra'yn put'ok'e mesup e. Are an Aparãu Emiariru Koro toĩne'en na'yn mesup uhunmỹ'ã pe e mana Maria Tupana pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mi'i hawyi mana Maria topy­hu'at mye'ym ewaty te'a­pi'i Isapeu yat pe. Mi'i hawyi te'aipok i ra'yn to'yat kape tawa Nasare kape. ");
INSERT INTO mavNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wẽtup e'at hawyi mana Isapeu mẽpyt hap e'at put'ok'e ra'yn hawyi imẽpyt ra'yn ihainia tuwe­mo­herep ta'yn Tupana miium topiat to'e hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mi'i hawyi iwyria'in sese ko'i i'ewyte heka­tu­wy­ria'in tikuap ta'yn Tupana miium wakuat mana Isapeu piat hawyi te'e­ru­wehum kahato Tupana kape. ");
INSERT INTO mavNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mi'i hawyi mana Isapeu emẽpyt 8 e'at ra'yn hawyi tuwat tuwat ra'yn iwyria'in mana Isapeu yat kape hawyi — Pyno waku wati­kaykay pa'i meikowo emẽpyt emusin sokpe ãpy tek hamuat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","— Mi'i watunug hawyi waku watum het emẽpyt pe aheko ewy i'atu'e. Waku wahet'ok emẽpyt Sakaria e'aito set mõtypot hamo i'atu'e ma'ato mana Isapeu — Yt an e. Waku watum tope het Iuwãu e i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mi'i hawyi te'e­ro'e mana Isapeu pe — Ahetama puo waku wahet'ok aimẽ­pyt'in aha'y­ru'in ai'y­wot'in set ewywuat sio aha'a­se­'i'in set ewywuat i'atu'e. Kat pote pyno — Uimẽpyt set ti waku Iuwãu ere'e uruepe i'atu'e. Ma'ato e'aito pa'i Sakaria e'ase­'i'in set Iuwãu e hap het rakat yt uwe i i'atu'e mana Isapeu pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mi'i pote ta'a­tupo wo ta'a­tu­hẽtup pa'i Sakaria pe yt hewaure i pote — Kat som waku wahet'ok esa'yru uhyt i'atu'e hap kuap hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma'ato pa'i Sakaria yt ihay kuap i. Mi'i hawyi pa'i Sakaria hẽtup miwan hug hap hawyi — Waku wahet'ok uha'yru Iuwãu e tomiwan me. Mi'i hawyi te'e­ru­wa­nẽtup kahato to'e miwan miat hap ete. — Aikotã toikuap ahehay mesuwe i'atu'e katu­pono yt toikuap i ahehay tewaure pote i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma'ato mi'i hawyi pa'i Sakaria tiwan het hawyi meremo ihay kuap i ra'yn itote hewaure ka'a i ra'yn. Mi'i hawyi toimõ­typot kahato ra'yn Tupana tehay wo sa'a­wy'i yt ihay kuap i rakat pa'i Sakaria. ");
INSERT INTO mavNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mi'i pote Sakaria yat piaria heka­tu­wy­ria'in te'e­re­wa­nẽtup kahato ha'yru Iuwãu wemo­herep hap kape. Mi'i hawyi tuwat ra'yn tawa piaria ko'i kape Iuwãu wemo­herep hap enoi hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Meiũran irania'in yne tama Iuteu piaria ikuap ta'yn Sakaria sa'yru Iuwãu wemo­herep hap etiat hawyi te'e­ro'e to'ope — Kan no aru pa'i Sakaria sa'yru topy­hu'at i'atu'e. Uwe ewy aru mekewat Iuwãu topy­hu'at i'atu'e to'ope tawa piaria. Mi'i hawyi Iuwãu Tupana mipoi­tyro kahato wo topy­hu'at itote. Mi'i hawyi Tupana toĩne'en kahato Iuwãu kai hawyi waku pe kahato toĩne'en ipiit ete iwanẽtup hap ete. ");
INSERT INTO mavNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mi'i hawyi pa'i Sakaria ihay kahato itote Tupana Pã'ãu kaipyi tohenoi kahato yianmete tosa­'yru Iuwãu etiat Tupana e hap ewy tohenoi. ");
INSERT INTO mavNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Mi'i ko'i tohenoi henoi yian note wuat sehay yne tosa­'yru pakup etiat aikotã aru hamuat ihay i'ewyte Aipo­typot Iesui etiat aikotã aru hamuat ihay yt iwemo­herep i te pytkai. ");
INSERT INTO mavNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mio tã to'e Pa'i Sakaria — Ta'i esaika kahato Tupana urueha­kye­ra'at hamo. Ta'i esaika hap po'og hĩpo po ehã'ãpe esaika hap kai uruewa­nĩ­kaptia moma hamo e. Ta'i morekuat Tawi saipepiat sese ti Emipo­'oro tuwe­mo­herep irane e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aikotã ere'e sa'a­wy'i te morekuat Tawi pe hap ewy — Meiũran wyti aru atum epe Emiariru Emiariru Kawiat Wẽtup ok Esaipepiat Wuat'i Miit'in ekyi Ehowawi Hanuat e hap ewy put'ok'e mesup ta'yn uruewawi e. Aikotã sa'a­wy­'i­tewuat ehay moherep haria pe ere'e hap ewy ra'yn mesup ta'yn etunug na'yn e. Aikotã ha'a­wy­te­pyite mesuwuat kape mi'i e'e hap ewywuat yne yne mesup etunug ra'yn uruky'e haype e pa'i Sakaria Tupana pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mio tã ere'e sa'a­wy'i uruepe ehay moherep haria wẽ pyi — Pywo ti aru meiũran atipo­'oro Uhemiit sese ehewa­nĩ­kaptia po pywiat eipuruk hamo ere'e. Mi'i hawyi e'e hap ewywuat etunug mesup e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","— Yt atiwaure hin i ti sa'a­wy­'iwuat ui'e hap atunug aru ui'e hap ere'e. Uiwese hap wyti aru atimo­herep yne ra'yn ui'e hap ewy ere'e urue'yian miaria pe e. — Uhegyi'at hap uiwese hap atimo­herep wuat'i miit'in me aru ere'e sa'a­wy'i e. Mi'i e'e hap ewy koitywy etunug na'yn uruepe e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I'ewyte sa'a­wy­'i­tewuat urue'a­se'i pot koro Aparãu miat e'e hap ewywuat re etunug na'yn aikotã ere'e sa'a­wy'i — Atunug irane e'e hap ewy etunug na'yn mesuwat e'at pe e. Yt etiwaure hin i e'e hap Tupana e. Aikotã ere'e urue'a­se'i pot Aparãu me — Ati'a­tu­moe­hãite aru wuat'i ywania mesuwat yi totiaria Esaipepiat po wo e'e hap ewy etunug na'yn mesup e. Wẽtup ok Emiariru emiariru minug kaipyi ti aru ati'a­tu­poi­tyro wuat'i imohey haria ere'e hap ewy etunug na'yn mesup e pa'i Sakaria Tupana pe itote wuat'i miit'in ehamo. ");
INSERT INTO mavNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Mi'i hawyi pa'i Sakaria to'e ra'yn ta'a­py­pueri haria pe — Uiwy­ria'in e Tupana tiky­'esat kahato ahewa­nĩ­kaptia po pywiat ahenõtem hap e. Toiky­'esat kahato aheropat tepiat hap yn e. Yt toiky­'esat hin i wato­ken'ẽ ahewa­nĩ­kaptia pupiat hap e. Mi'i pote aipo­re­nõtem neran ahewa­nĩ­kaptia po pyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mi'i hawyi Tupana ainug neran hãpyk kahato rakaria wo aikotã tewaku hap ewy hap toiky­'esat e. Toiky­'esat yne e'at pe waku hap ewy watu­kup­te'en hap e pa'i Sakaria itotiaria pe tosa­'yru Iuwãu ywã'ĩ hap e'at pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mi'i hawyi pa'i Sakaria to'e tosa­'yru Iuwãu me — Uha'yru e meiũran ni aru ereĩne'en Tupana kapiat mu'ap moherep hano e. Mi'i hap e'at pe mio tã ere'e miit'in sem me — Tut irane tut irane Tupana ahowawi Aipo­rekuat nuat ere'e aru e. Mi'i hawyi miit'in emienoi kape te'e­ru­wa­nẽtup kahato hap turan aru put'ok'e Emimo­herep e pa'i Sakaria tosa­'yru Iuwãu me Aheha­kye­ra'at hat Iesui etiat. Mi'i hawyi to'e i Iuwãu me — Pywo ti rat ehenoi henoi aru ai'y­wania pe aikotã waku ta'a­tu­puẽti ta'a­tue­ha­kye­ra'at hap Tupana piat hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Uha'yru Iuwãu e ai'y­wania timohey e'e hap Emimo­herep hawyi ti aru waku pe kahato tukup­te'en are katu­pono ta'a­tu­mohey ehay hawyi Tupana waure wo toĩne'en aru ta'a­tu­minug sa'ag ko'i kai e. Mi'i hap ko'i ti aru ehenoi henoi ai'y­wania pe Tupana Mipo­'oro ut hap etiat yianmete e pa'i Sakaria tosa­'yru Iuwãu me. Mi'i hap e'at pe ti aru ehenoi aikotã waku ta'a­tu­puẽti ta'a­tue­ha­kye­ra'at Tupana piat hamuat hap e. Katu­pono ta'a­tu­mohey Emimo­herep hawyi Tupana waure wo toĩne'en i'atu­minug sa'ag ko'i kai e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ta'i Tupana yt ti'a­tu­po­petek teran hin i miit'in e. Tehay wo toi'a­tu­ky'e kahato miit'in e. Ta'i miit'in ho'o­wasat hap haty kahato tuete e. Mi'i hap kaipyi toipo­'oro Temiit sese Aheha­kye­ra'at hanuat e. Ta'i atipy kaipyi toipo­'oro ahekyi tuwe­wawiat hanuat e. Toiky­'esat wuat'i miit'in mesuwat yi totiaria tuwe­wawiat hap uha'yru e. Aikotã at ta'am hawyi toimoẽ­tyhot yne i'ypyryp hap mi'i hap ewy toimoẽ­tyhot teran tehay wo wuat'i ywania e. ");
INSERT INTO mavNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Uha'yru Iuwãu e mesu­wa­ro­tiaria ti yt ihapytig hin i rakaria ewy kahato tukup­te'en aikotã i'ypyryp we ga'apy puat ho'o­wasat rakaria ewy miit'in tukup­te'en e. Aikotã miit'in misyp we tukup­te'en i'ypyryp we hap ewy mesu­wa­ro­tiaria tukup­te'en yt te'e­ra­'a­kasa kuap i Tupana kape pote e. Aikotã ho'o­wasat kahato rakaria ga'apy piaria yt ikuap i mu'ap ta'a­tu'yat kapiat hap ewy kahato miit'in mesu­wa­ro­tiaria tukup­te'en e. Yt ta'a­tu­puẽti hin i ta'a­tu­mo­wepit Tupana piat hap e. Ma'ato hẽtyhot hap put'ok'e hawyi ta'a­tukuap meremo mu'ap i ra'yn hawyi waku pe i ra'yn tukup­te'en e. Mi'i ui'e hap Emimo­herep Tupana Mipo­'oro aimoẽ­tyhot hamuat toĩne'en aru e. Uha'yru Iuwãu e mio tã ere'e aru emimu­'eria pe — Tut irane tut irane Aimoẽ­tyhot Kahato Hanuat hawyi waku pe aru watoĩ­ne'en ere'e ti aru e pa'i Sakaria tosa­'yru Iuwãu hire pe. ");
INSERT INTO mavNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mi'i hawyi ha'yru Iuwãu hit tuwe­motag itote pa'i Sakaria mana Isapeu yatype. Mi'i tote ipiit hesaika kahato toĩne'en ihãite kahato. Itote tuwe­moe­saika kahato Tupana kuap hap ete. Mi'i hawyi Tupana Pã'ãu Wakuat imu'e kahato itote. Iuwãu kurum iwasu turan hawyi toto ra'yn yahig wato sese kape. Mi'i tote tuwe­mu'e kahato Tupana e hap kuap hamo. Mekewat yahig koro tote Tupana mikuap ok tã tuwe­mu'e kahato katu­pono toiky­'esat tuwe­moe­saika kahato aikotã aru toimo­herep to'y­wania pe Tupana e hap ko'i hap ete. ");
INSERT INTO mavNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sa'a­wy'i toĩne'en mesuwat yi tote wẽtup ok morekuat akag kahato more­kuaria porekuat koro Sesa Aukutu e hap het rakat. Mi'i turan toiky­'esat kahato temiit'in yne yne atumo­rania hap. Mi'i hawyi toi'a­tu­po­'oro kahato tesu­ra­ra'in sem tomiwan wywo yne tetama ko'i kape temiit'in atuset pehik yne hamo — Atiky­'esat kahato yne yne uhemiit'in set ko'i miwan me e. Waku i'atuset ko'i ewei'a­tu­pehik yne are katu­pono ati'a­tu­mo­rania teran torania uhemiit'in sem ko'i uhetama wato piaria e ok tã katu­pono toiky­'esat yne miit'in kaipyi tekat ko'i i'atu­sa­'upsat hamuat. Mi'i hawyi toi'a­tu­po­'oro ra'yn tomiwan ko'i yne tetu­'i­saria pe tosu­ra­ra'in sem po pe. ");
INSERT INTO mavNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mi'i hap ewy ta'a­tunug mesuwat yi tote Tu'isa wato Sireniu e hap het rakat toĩne'en morekuat koro wuat mekewat yi wato Siria pe turan. ");
INSERT INTO mavNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mi'i hawyi mõtypot Sesa Aukutu etama puaria tuwat ra'yn ta'a­tue­tawa sese ko'i kape. Ta'a­tue­'a­se­'i'in etawa ko'i kape tuwat ta'a­tuset pehik hamo sa'up ium hamo morekuat koro Sesa Aukutu e hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mi'i e hap upi i'ewyte toto mehĩ Iuse yi Karireia popykiat tetawa Nasare kaipyi yi upi tawa hit Perẽi kape te'a­se'i morekuat Tawi ywã'ĩ hap kape mekewat yi Iuteu piat tawa hit Perẽi kape toto tuwe­set­pehik hamo. Toto tawa Perẽi kape katu­pono mehĩ Iuse ti toĩne'en mekewat sa'a­wy­'iwuat morekuat Tawi emiariru emiariru pote. Mi'i pote toto te'a­se'i Tawi etawa kape. ");
INSERT INTO mavNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I'ewyte mana Maria toto mehĩ Iuse upi toupi'a wato kahato wywo toto. Ma'ato yt Iuse wat toupi'a wywo i toto ma'ato Tupana Pã'ãu Wakuat upi'a wywo toto. Yt pya hin i ra'yn put'ok­ta­'a­tu'e hamuat tawa hit Perẽi tote turan imẽpyt haty kahato ra'yn mana Maria. ");
INSERT INTO mavNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mi'i hawyi itote Tawa hit Perẽi me tukup­te'en hawyi put'ok'e he'at ra'yn hewãtym na'yn hawyi imẽpyt tuwe­mo­herep hap e'at put'ok'e meremo itote hawyi meremo ta'a­tukat kahato itote ta'a­tuket hap wen ma'ato yt aikope kuap i katu­pono yt uwe i Perẽi miaria — Waku eiwe­hyt'ok uru'yat pe e haria itote katu­pono i'atu kahato miit'in õ'ẽ haria itote pote. ");
INSERT INTO mavNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mi'i pote ta'a­tukat kahato ta'atueiam hawyi yt ta'a­tu­puẽti hawyi tuwe­hyt'ok wewato ahup yat pe hawyi mekewat hũria yat pe te'e­roket. Mi'i hawyi mekewat wãtym muo tuwe­mo­herep ta'yn Maria Mẽpyt sa'a­wy­'iwuat ihainia ra'yn. Tuwe­mo­herep hawyi sokpe wo tohuwy kahato ra'yn ta'a­tueko ewy ipiit mohãpyk sese nug hamo. Mi'i hawyi tawa hit Perẽi me te'e­ru­we­mo­sy'at ra'yn wẽtup ewaty. ");
INSERT INTO mavNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mekewat ewãtym muo Iesui tuwe­mo­herep turan tukup­te'en itote yt pya hin i tawa Perẽi kai yahig note ta'a­tuhũ Uweuria apykok haria. Mi'i tote te'e­roket ta'a­tu­hũria py'a­setpe katu­pono ta'a­tu­'a­pykok teran ta'a­tu­hũria awyato pupi. ");
INSERT INTO mavNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mi'i tote ti atipy kaipywiat sut hat tuwe­mo­herep wehũria apykok haria kape. Mi'i ti Tupana ẽtyhot hap wywo tuwe­mo­herep hawyi yne i'atuete hẽtyhot kahato. Mi'i pote Uweira ko'i apykok haria te'e­ro­ken'ẽ kahato hẽtyhot put'ok'e ta'a­tuetiat pote. ");
INSERT INTO mavNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mi'i hawyi atipy kaipywiat sut hat to'e wehũria apykok haria pe — Yt eweiken'ẽ tei'o uipupi e i'atuepe. Katu­pono wakuat sehay ahenoi teran ehepe eimo­wepit kahato hamo e. Ta'i yt ehepe yn i uhehay wakuat ma'ato wuat'i ywania mesuwat yi totiaria mowepit hap ahenoi e. ");
INSERT INTO mavNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Waku kahato Tupana tunug mesup ehepe katu­pono mesuwat ewãtym Tupana tum Temiit sese Wuat'i Miit'in Ehakye­ra'at hanuat tuwe­mo­herep ta'yn e. Pywo ti rat tuwe­mo­herep ta'yn mesup ta'yn itote eha'a­se'i morekuat Tawi tawa Perẽi me Tupana Mipo­'oro Wuat'i Ywania Ehakye­ra'at Hanuat e. Mi'i sehay wakuat enoi hamuat Tupana uipo­'oro ehowawi e. ");
INSERT INTO mavNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pyno ahenoi teran ehepe aikotã waku eweipuẽti imẽpyt e hamuat hap. Pyno waku eweiwat tawa Perẽi kape hawyi waku eweikat eihũria yat mekewat eihũria poi hap. Mi'i tote wyti aru eweipuẽti ui'e hap ewywuat e i'atuepe. Mi'i tote sokpe wo tosuwy pe ra'yn ti aru eweipuẽti Tupana Sa'yru e. Ta'i eihũria mi'u upip tote toket itote ui'e hap ewy e. Mi'i ui'e hap ewy eweipuẽti hawyi ti aru eweikuap ta'yn pywo kahato ui'e hap e mekewat atipy kaipywiat sut hat wehũria apykok haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mi'i to'e turan atipy kaipy­wiaria sem itote te'e­ru­we­mo­herep wy mekewat yahig note. Mi'i hawyi mekewat sa'a­wy­'iwuat wemo­herep hat wywo tukup­te'en Tupana mõtypot hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","— Wakuat wakuat wakuat En Tupana i'atu'e. Ywaiti Piat Ieĩne'en Hat Sese En i'atu'e. Uruimõ­typot kahato En katu­pono mesup ta'yn Miit'in Mowepit Hat Sese etum na'yn yi totiaria pe i'atu'e. Pyno Miit'in Wo'o­wese Hap Nug Hat topy­hu'at ra'yn mesuwat mytyp tote i'atu'e. Waku kahato katu­pono mesup ta'yn aru wo'o­ky'e haria wo tukup­te'en miit'in emohey haria i'atu'e. Emiky'e kahato ko'i miit'in mote i'atu'e Tupana emiit'in atipy kaipy­wiaria typy'i rakaria yahig note Tupana mõtypot hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mi'i hawyi atipy kaipy­wiaria te'e­ra­'aipok i ra'yn atipy kape hawyi hũria apykok haria te'e­ro'e to'ope — To'iro tawa hit Perẽi kape Tupana mienoi kapiat akasa hamo i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mio tã ta'a­tu'e hawyi meremo tuwat ra'yn tawa Perẽi kape. Put'ok­ta­'a­tu'e itote hawyi ta'a­tukat kahato atipy piaria mienoi upi hirakat. Mi'i hawyi ta'a­tu­puẽti ra'yn Hirakat hũria yat pe hũria poi hap upip tote. I'ewyte uhyt Iuse mana Maria ta'a­tu­puẽti itote. ");
INSERT INTO mavNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te'e­ra­'a­kasa hawyi ta'a­tu­henoi ra'yn uhyt Iuse pe mana Maria pe atipy kaipywiat sut hat ehay yne Iesui etiat ta'a­tu­henoi. ");
INSERT INTO mavNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mi'i hawyi tuwat hawyi mu'ap upi ta'a­tu­henoi yne irania'in me tawa hit Perẽi miaria pe. Mi'i hawyi irania'in te'e­ru­wa­nẽtup kahato Uweria ko'i apykok haria mienoi kape. ");
INSERT INTO mavNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mi'i hawyi mana Maria tereko yne tomẽpyt wemo­herep hap etiat topy'a pe. Mi'i hawyi yne e'at pe tuwa­nẽtup kahato atipy piaria ehay tomẽpyt etiat hap kape. ");
INSERT INTO mavNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mi'i hawyi Uweuria apykok haria te'e­ra­'aipok i ra'yn ta'a­tu­hũria ko'i kape. Te'e­ra­'aipok turan te'e­ru­wehum kahato ra'yn Tupana kape — Wakuat kahato En i'atu'e katu­pono atipy kaipywiat sut hat mienoi ewywuat ra'yn uruta­'a­kasa i'atu'e Tupana pe. ");
INSERT INTO mavNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mi'i hawyi 8 e'at ra'yn toĩne'en hawyi Hirakat ta'a­tue­murui sokpe ãpy tek hawyi ta'a­tu­set'ok ta'yn — IESUI eset i'atu'e aikotã sa'a­wy­'iwuat atipy kaipywiat sut hat Kapireu mienoi mana Maria yt upi'a i te turan hap ewy ra'yn ta'a­tu­set'ok Imẽpyt — Iesui het i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mi'i hawyi Iuse'in te'e­ru­we­mo­sy'at wẽtup ewaty hap kahu hawyi tuwat ra'yn tawa wato Ieru­serẽi kape Tupana mõtypot yat wato kape. Mi'i tote ta'a­tu­henoi Iesui Tupana pe — Uruikuap ta'yn ewanuat kahato Mesuwat Hirakat toĩne'en wuat'i e'at pe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mi'i hawyi ta'atuium Iesui Tupana pe itote aikotã sa'a­wy'i Tupana mienoi ase'i Musei miwan me e hap ewy — Waku etum esa'yru sa'a­wy­'iwuat Uhepe e hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mi'i hawyi ta'a­tu­henoi Iesui Tupana kape hawyi ta'atuium Tupana pe typy pykasu hit ko'i pa'i pe. Pa'i ti'a­tu­'auka pykasu hawyi toi'a­tuwuk itote Tupana mõtypot hamo aikotã Tupana to'e ase'i Musei miwan me sa'a­wy'i hap ewy — Waku etum typy pykasu hit sio typy pykasu wato uhepe uimõ­typot hamo esa'yru sa'a­wy­'iwuat tuwe­mo­herep hawyi e hap ewy ta'a­tunug itote. ");
INSERT INTO mavNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Toĩne'en Ieru­sarẽi me wẽtup ok pa'i koro Simeãu e hap het rakat. Simeãu ni waku rakat toĩne'en Tupana mõtypot kahato hat mi'i. Mi'i i'ewyte hekatup kahato Isareu ywania Ehakye­ra'at Hat Isareu Ywania powyro hanuat katu­pono Simeãu kai toĩne'en kahato Tupana Pã'ãu. ");
INSERT INTO mavNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tupana Pã'ãu henoi ra'yn tope — Eku'uro hap owakai te ti aru era'a­kasa Uimi­po­'oro Ehakye­ra'at Hanuat e Tupana Pã'ãu Simeãu me. ");
INSERT INTO mavNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Meiũran hawyi wẽtup e'at pe Tupana henoi i ra'yn Simeãu me — Ereto ro koran uimõ­typot yat kape e. Mi'i hawyi toto ra'yn Tupana Pã'ãu mienoi ewy. Pa'i Simeãu toto turan put'ok­'i­'a­tu'e Iuse'in Tupana mõtypot yat ete. Mi'i hawyi tuwe­hyt'ok ta'a­tueko ewywuat nug hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Mi'i hawyi Simeãu i'ewyte teke itote hawyi totat ra'yn Iesui hit Maria po pyi hawyi tuwehum kahato Tupana kape. ");
INSERT INTO mavNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Mi'i hawyi to'e — Woro­mõ­typot kahato En Tupana katu­pono uheha wo ara'a­kasa ra'yn Emipo­'oro Wuat'i Ywania Ehakye­ra'at Hanuat kape ara'a­kasa ra'yn e Tupana pe Iesui hit piat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Uimo­wepit kahato Tupana katu­pono e'e hap ewy etunug na'yn mesup uiku­'uro hap e'yianmete e. ");
INSERT INTO mavNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","— Pyno waku ra'yn uiku­'uro hap mesup uimo­wepit hap wywo katu­pono mio atikuap ta'yn Emipo­'oro Uheha­kye­ra'at Hat toĩne'en mote e pa'i Simeãu Tupana pe. ");
INSERT INTO mavNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mi'i hawyi pa'i Simeãu to'e Maria pe — Mesuwat uipo piat Emẽpyt wyti aru topy­hu'at Wuat'i Ywania Piat Tupana Moherep Hano e. Aikotã ariãty timo­herep mu'ap ahepe wãtym muo hap ewy wyti aru Emẽpyt timo­herep mu'ap Tupana kapiat e. Ta'i Emẽpyt topy­hu'at Wuat'i Miit'in Pu'ap Tupana kapiat hat e. Emẽpyt Iesui wyti aru topy­hu'at Uru'y­wania Mimõ­typot kahato wo e pa'i Simeãu Iesui ty pe. ");
INSERT INTO mavNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mio tã to'e hawyi mehĩ Iuse mana Maria te'e­ru­wa­nẽtup kahato pa'i Simeãu ehay kape. ");
INSERT INTO mavNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Mi'i hawyi Simeãu ti'a­tu­poi­tyro Iuse'in hawyi to'e mana Maria pe — Emẽpyt wyti aru Ai'y­wania Ehakye­ra'at Hano topy­hu'at ma'ato irania'in ai'y­wania yt timohey i Emẽpyt itag hawyi pote te'e­ru­we­ma'at kahato yt ta'a­tu­mohey i hawyi e. Mi'i hawyi Tupana mi'a­piheg wanuaria tukup­te'en e. Ma'ato irania'in ai'y­wania imohey kahato haria Tupana mimõ­typot kahato wanuaria tukup­te'en wuat'i e'at pe e. Mi'iria Tupana mimo­wepit kahato ko'iria tukup­te'en wuat'i e'at pe e pa'i Simeãu Iesui piat Maria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ta'i sa'ag kahato aru ta'a­tunug Emẽpyt ete itag hawyi e. Mi'i pote haty kahato topy­hu'at aru epy'a pe aikotã kyse aipy'a piat haty hap ewy topy­hu'at eete emẽpyt ta'a­tu­'auka hawyi e pa'i Simeãu Iesui ty pe. ");
INSERT INTO mavNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mi'i hawyi toĩne'en wy itote Tupana mõtypot yat pe wẽtup ok hiwu mana Ana e hap het rakat. Mi'i ti uhyt Wanueu saki'yt toĩne'en i'ewyte ase'i Ase ywania toĩne'en. Hiwu Ana tuwe­mo­sy'at kahato tuereto tehay teran Tupana wywuat turan. ");
INSERT INTO mavNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Hiwu Ana ti Tupana ehay moherep hat kahato toĩne'en. Mi'i ti waku kahato rakat toĩne'en Tupana wanẽtup hawe. Tupana eropat kahato rakat toĩne'en itote. At ka'ap toimõ­typot kahato Tupana tehay wo. Waku pe toĩne'en mi'i hap ete. Ihay kahato Tupana wywo at ka'ap. Ihay Tupana wywo turan yt tenuk hin i hawyi yt tuwẽtem hin i Tupana mõtypot yat pyi. He'aito iku'uro hawyi toto Tupana mõtypot yat kape hawyi toĩne'en mot'i itote at ka'ap hap ewy 84 anu toĩne'en itote he'aito iku'uro hawyi. Hiwu pot 84 anu turan hiwu i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mi'i turan Mana Ana put'ok'e pa'i Simeãu henoi Iesui piat mana Maria pe turan. Mi'i hawyi mana Ana ta'a­kasa imẽpyt Iesui kapiat hawyi tuwehum kahato wy Tupana kape — Waku kahato En Tupana e. Mesup ta'yn ara'a­kasa Emipo­'oro Urueha­kye­ra'at nuat e. Mi'i hawyi yne itotiaria Tupana yat piaria pe tohenoi Iesui etiat torania Tupana Mipo­'oro ekatup haria pe — Put'ok'e ra'yn wyti Aheha­kye­ra'at Hanuat sese uiwy­ria'in e. Tupana Mipo­'oro Aipo­rekuat nuat sese wyti put'ok'e ra'yn e mana Ana Iesui piat. Mi'i hawyi toto wuat'i piat henoi hamo tawa wato Ieru­sarẽi miaria Tupana Mipo­'oro ekatup haria piat henoi hamo. Mi'i hawyi tohenoi hirakat Iesui etiat — Put'ok'e ra'yn wyti Aheha­kye­ra'at hanuat sese uiwy­ria'in e hiwu Ana. ");
INSERT INTO mavNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mi'i hawyi Iuse'in tunug na'yn yne Tupana mienoi ewy hawyi te'e­ra­'aipok i ra'yn tawa wato Ieru­sarẽi kaipyi yi Karireia popykiat tawa hit Nasare kape tuwat sa'a­wy­'iwuat ta'a­tuieĩ­ne'en hap kape. ");
INSERT INTO mavNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mi'i tote Iesui tuwe­motag kahato tawa Nasare pe. Ihay kahato Tupana wywo itote. Tupana Pã'ãu wo tuwe­mo­we'eg kahato hawyi hesaika kahato rakano toĩne'en ipiit ete i'ewyte iwe'eg hap ete Tupana ehay ete. Yne e'at pe po'og po'og itag sa'a­wy­'iwuat kai. Mi'i hawyi Tupana tipoi­tyro sese Iesui iwemotag turan. ");
INSERT INTO mavNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mi'i hawyi wẽtup e'at pe tuwat ra'yn Iuse'in tawa wato Ieru­sarẽi kape man teneg u hamo. Te'e­ru­wa­'a­tunug itote ta'a­tue­'a­se­'i'in ehakye­ra'at ta'a­tue­wa­nĩ­kaptia po piat yi Esitu'in ywania po pywiat hap e'at kapiat te'e­ru­wa­nẽtup hay piat kape. ");
INSERT INTO mavNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mi'i hawyi kurum iwasu Iesui 12 anu ra'yn hawyi toto wy Iuse upi toty wywo tawa wato Ieru­sarẽi kape te'e­ru­wa­'a­tunug yne anu hap kape. Itote tukup­te'en 7 e'at. ");
INSERT INTO mavNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mi'i hawyi te'e­ru­wa­'a­tunug hap tokosap hawyi tuwat ra'yn Iuse'in ta'a­tu'yat kape ma'ato Iesui yt toto i tawa Ieru­sarẽi myi toty'in upi. Sa'a­wy'i yt ta'a­tukuap hin i Iesui topy­hu'at hap. ");
INSERT INTO mavNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ma'ato yt te'e­ra­'a­kasa i hawyi ta'a­tu­wy­ria'in tok pe rasom Iesui i'atu'e — Towy­ria'in upi tut wat'ymo i'atu'e to'ope wen ma'ato wãtym hawyi ta'a­tukat Kurum Iwasu Iesui iwyria'in upi ma'ato yt ta'a­tu­puẽti i. ");
INSERT INTO mavNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mi'i hawyi te'e­ra­'aipok i ra'yn tawa wato Ieru­sarẽi kape Iesui kat hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mye'ym e'at ta'a­tukat Iesui itote hawyi ta'a­tu­puẽti Tupana mõtypot yat pe. Isareu ywania wo'o­nãpin haria akag tok pe ta'a­tu­puẽti kurum iwasu Iesui. Mi'i tote Iesui tuwa­nẽtup kahato wo'o­nãpin haria akag ko'i ehay kape hawyi apo apo'e wo'o­nãpin haria akagnia kape. Mye'ym e'at turan ihay se kahato mi'iria kape. ");
INSERT INTO mavNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mi'i pote itotiaria wo'o­mu'e akag kororia te'e­ru­wa­nẽtup kahato Kurum Iwasu Iesui piat ta'a­tu­wesat kuap kahato hap kape. Mi'i hawyi te'e­ro'e to'ope — Ta'i iwe'eg kahato rasig Iesui i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iuse'in ipuẽti Tupana mõtypot yat pe wo'o­nãpin haria py'a­setpe hawyi te'e­ru­wa­nẽtup kahato hawyi ity Maria to'e tope — Kat poteĩ meiũpe erepy­hu'at uimẽpyt e. Paa'u­ru­to'e kahato ekat haype kowo'i kowo'i uruikat en tawa wato pe e. Haty kahato uruwa­nẽtup hawe yt uruipuẽti i En hawyi e Iesui pe ity. ");
INSERT INTO mavNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mi'i hawyi Iesui tiwesat — Kat pote uikat kowo'i kowo'i e. Kat pote yt uikat i mesuwe Tupana mõtypot yat pe yn e. Yt eweikuap i apo aikotã areĩne'en neran Ui'ywot sese yat pe ipotpap nug hap ete e Iuse pe Maria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma'ato yt ta'a­tukuap hin i Iesui e hap. ");
INSERT INTO mavNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mi'i hawyi Iesui ta'aipok i ra'yn to'ywot hit mana Maria wywo tawa Nasare kape i'atu­mi­ky­'esat ewywuat nug hamo. Mi'i hawyi ity yt waure'e hin i ra'yn Iesui e hap tawa Ieru­sarẽi miat hap. Tuwa­nẽtup kahato ihay kape — Kat pote yt uikat i Ui'ywot Sese yat upi Iesui e hap kape at ka'ap tuwa­nẽtup. ");
INSERT INTO mavNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mi'i hawyi tawa hit Nasare pe Iesui topy­hu'at mot'i. Tuwe­motag itote yne ete. Mi'i hawyi itote tuwe­piit­moe­saika hawyi tuwe­motag kahato po'og po'og yne e'at hap ewy. Iwe'eg kahato yne e'at pe po'og po'og totag hap ewy'ewy iwe'eg. Mi'i hap ewy miit'in mowepit hap ete tuwe­motag i'ewyte Tupana kuap hap ete tuwe­motag. Mi'i hap upi Tupana tuwehum kahato Iesui ete. ");
INSERT INTO mavNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pyno sa'a­wy'i mekewat morekuat Sesa toĩne'en morekuat koro hap e'at pe turan Tupana ihay ra'yn pa'i Sakaria sa'yru Iuwãu kape yahig wato sese tote. Mi'i hawyi Tupana tiwyro kahato Iuwãu wanẽtup hawe ihay. Mi'i turan morekuat Tiperiu Sesa e hap 15 anu toĩne'en morekuat koro wo yi wato Humanu ywania torania potypot no toĩne'en. Mi'i pote wẽtup e'at pe morekuat Sesa ti'a­tu­kaykay tuwe­wawi tetu­'i­saria hawyi toi'a­tu­mo­wato mi'iria. Mi'i hawyi to'e tu'isa Pũsiu Piratu pe — Waku ereĩne'en Iuteu ywania morekuat no yi Iuteu pe uhyt e. Mi'i hawyi to'e tu'isa Eroti pe — Waku ereĩne'en yi Karireia piaria porekuat no uhyt e. Mi'i hawyi i'ewyte toikaykay toywyt sese Wiripi tuwe­wawi hawyi to'e tope — Waku ereĩne'en yi Itureia piaria porekuat no mekewat Iuteu ywania irania'in kawiat porekuat no e. Ma'ato waku aru po'og atum yi epe uheywyt en tupono e. Waku wy yi wato Tacunite atum epe i'ewyte yi wato Irisania atum epe wy i'ewyte yi wato Apirene atum epe uheywyt Wiripi en mote e. Mi'i hap e'at pe Tupana ihay sa'a­wy'i Pa'i Sakaria sa'yru Iuwãu wywo mekewat yahig koro note. ");
INSERT INTO mavNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","I'ewyte mekewat e'at pe Iuteu ywania ti'a­tu­'airo typy pa'i ta'a­tue­pa'i koro wuat. Wẽtup pa'i Anai e hap wẽtup ok pa'i Ka'iwa e hap. Mi'i hawyi mi'iria ta'a­tunug pa'i koro wo Tupana mõtypot yat pe. Mi'i hap e'at pe Tupana ihay sa'a­wy­'iwuat ahet'ok hat Iuwãu wywo. ");
INSERT INTO mavNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pyno mi'iria tukup­te'en miit'in akag wuat turan Tupana ihay kahato pa'i Sakaria sa'yru Iuwãu yahig notiat ieĩne'en hat pe — Iuwãu e woro­'airo en uhehay enoi miit'in miat hamo e. Mi'i hawyi Iuwãu toto Tupana ehay moherep hamo Tupana e hap ewy. Mi'i hawyi ikohye­wyry kahato mekewat Iũtãu hy ẽpe upi. Mi'i hap upi ẽpe upiaria toi'a­tu­mu'e kahato Tupana ehay wo. Mio tã e — Ewei'aipok to Tupana kape e. Waku hawyi woro­ho­'o­set'ok eipe e. Ta'i eweitoiat ro eminug sa'ag ko'i hawyi Tupana waure wo toĩne'en eiminug sa'ag ko'i kai e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Aikotã sa'a­wy­'i­tewuat Tupana ehay moherep hat Isaia timo­herep yne ahet'ok hat Iuwãu etiat tomiwan me hap ewy. Mio tã to'e — Tut wyti aru wẽtup ok tehay pirik wuat henoi henoi miit'in miat yahig notiat hat e Iuwãu etiat tomiwan me. Mi'i miit wyti aru mio tã e wuat'i tomi­mu­'eria pe — Eiwa­nẽtup hawiat mu'ap yt hãpyk i rakat ewy toĩne'en ipori'ok kahato rakat ewy e aru e. — Ma'ato mi'i kaipyi ewei'aipok to Tupana kape eiwa­nẽtup hap mohãpyk hamo hawyi mu'ap hãpyk hap ewy Tupana einug e aru mekewat Tupana mipo­'oro e. — Eweikup­te'en no Tupana wanẽtup hawe hãpyk takat hawyi eiwa­nẽtup hap mu'ap ikahu rakat ewy ra'yn topy­hu'at aru e aru Tupana mipo­'oro e Tupana Isaia miwan me. ");
INSERT INTO mavNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mio tã e Tupana sa'a­wy'i — Uimi­po­'oro Miit'in Ehakye­ra'at ut hap moherep hat wyti aru atipo­'oro e. Mi'i miit wyti aru mu'ap nug hat ewy topy­hu'at e Tupana miwan miat ahet'ok hat Iuwãu ete. Ta'i mi'i miit wyti aru mu'ap nug hat ewy topy­hu'at e. Mu'ap sa'ag ko'i mokahu hamuat tutunug e. Mu'ap i'anam kahato hyri kawiat toihy­wytip yne e. Mu'ap yity'ok ete ipoity rakat toimo­hãpyk e. Mi'i hawyi mu'ap sa'ag ko'i yi hot pe itym nakat toimo­kahu kahato e. Mi'i hawyi hãpyk yne mu'ap hawyi atipo­'oro Uhemiit Ho'o­wasat Rakaria Puẽti Hat e. Mi'i hawyi Uimi­po­'oro Uhemiit Sese mu'ap mohot hat toimo­herep kahato miit'in me tehay pirik wo — Tut irane tut irane Tupana Mipo­'oro Aheha­kye­ra'at hat e aru. Eiwe­mo­hãhyk to ipu'ap hawyi wyti aru tut ahepe e aru Uhemiit ut hap moherep hat e Tupana sa'a­wy'i. ");
INSERT INTO mavNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mi'i hawyi ti Uimi­po­'oro Wuat'i Ywania Ehakye­ra'at Hat akasa haria i'atu kahato tukup­te'en aru mesuwat yi wato hap ok tã e Tupana Isaia miwan 40.3 pe Tosa­'yru Iesui etiat. ");
INSERT INTO mavNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pyno Isaia e hap ewy kahato Iuwãu ti'a­tu­mu'e miit'in itote Iũtãu hy ẽpe upiaria. Mi'i hawyi tõ'ẽ kahato miit'in tuwe­wawi. Mi'i hawyi typy'i kahato miit'in put'ok­'i­'a­tu'e Iuwãu ete ta'a­tu­set'ok hap ky'esat haria. Mi'iria pe Iuwãu to'e — Moi mẽpyt ewywuat eipe e. Yt nakuaria i eipe e. Tupana piat ei'a­piheg hap yt eweiky­'esat i pote ewei'õ'ẽ Tupana kape imohey hamo hawyi woro­ho­'o­set'ok e. Ta'i Tupana piat ehet'ok hap eweiky­'esat pote eiwe­morem no Tupana kape e Iuwãu. ");
INSERT INTO mavNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","— Waku eiminug sa'ag ko'i hap ewei'a­tu­'atoiat yne yne e. Mi'i tã ewetunug hawyi irania'in ikuap ta'yn Tupana kapiat ei'aipok hap e. Ma'ato — Waku kahato uruto yt ewei'e tei'o e. — Uruto ti ase'i Aparãu emiariru ko'i pote wakuaria urutu­kup­te'en Tupana wanẽtup hawe yt ewei'e tei'o e. Ta'i aha'a­se'i minug wakuap ko'i yt put'ok'e i ahowawi aimo­waku Tupana wanẽtup hawe e. Ta'i aiwaku hap yt tut i ai'y­wã'ĩ hap kaipyi e. Ta'i Aparãu ewaku hap yt aheha­kye­ra'at kuap hin i e. Ta'i eipiit aha'a­se'i Aparãu piit ewywuat kahato toĩne'en ma'ato eiminug sa'ag ko'i yt Aparãu ewywuat hin i e. Ta'i Tupana tiky­'esat pote tutunug kuap mesuwat nu ko'i kawiat aipiit ko'i ewywuat e. Toiky­'esat pote Aparãu emiariru piit ko'i tutunug kuap mesuwat yi kawiat e. Ma'ato wakuaria imohey haria Aparãu ewywuaria yn waku Tupana wanẽtup hawe e Iuwãu. ");
INSERT INTO mavNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","— Eiwe'eg wo o e katu­pono Tupana mikoi ypia yt haat i rakat ewywuat eweikup­te'en. Aikotã aimikoi yt aipoi i hap ewywuat eipe. Pywo pe ti mesup ta'yn ehapo ete toĩne'en Tupana piat ei'a­piheg hap. Ywyhap ewywuat toĩne'en Tupana po pe eikai aikotã aimikoi yp yt haat i rakat ewywuat watitek ywyhap wo hap ewy eweikup­te'en mesup e. Pyno eiwe'eg wo o katu­pono ywyhap ewywuat toĩne'en Tupana po pe ehete aikotã aria'yp ko'i yt haat i rakaria ypugha hamo hat ewy toĩne'en eikai. Aikotã wati­'y­pugha hawyi wati­'a­tu­sokwuk ahe'aria wo mi'i hap ewy Tupana tunug ehepe sa'ag ewetunug mote e Iuwãu õ'ẽ haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mi'i hawyi yahig kapiat howawiat õ'ẽ haria apo'i­'a­tu'e Iuwãu me — Yt naku i rat urutuwat aria wato kape i'atu'e. Yt naku i Tupana uru'a­piheg ko'i uruto­py­hu'at wuat'i e'at pe i'atu'e. Mi'i pote aikotã aru waku urutunug Tupana ehamo paa'u­ru­to'e hamo i'atu'e Iuwãu me. ");
INSERT INTO mavNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mi'i hawyi Iuwãu ti'a­tu­wesat — Pyno ehesokpe typy pote eweho'oium no yt hesokpe i rakaria pe e. I'ewyte eimi'u toĩ mote ewei'a­tu­moenuk to hesy'at rakaria e Iuwãu paa'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","I'ewyte wo'o­pyhyp haria tukup­te'en itote weset'ok teran hanuaria. Mi'iria i'atu­potpap Iuteuria ewanĩ­kaptia Humanu ywania eporekuat sa'up sat hamo. Mi'iria wyti wuat'i kaipyi ta'a­tu­po­rekuat wuanuat ha'up pore­ra'at haria. Ma'ato po'og iwato ta'a­tusat ta'a­tu­po­rekuat miẽtup ko'i kai. Mi'i hawyi ipat'ok — Uruwano ra'yn i'atu'e haria. I'ewyte mi'iria apo'i­'a­tu'e Iuwãu me — Urumu'e hat aikotã aru waku urutunug Tupana mowepit hamo i'atu'e katu­pono Tupana piat uru'a­piheg hap yt uruiky­'esat i pote i'atu'e Iuwãu me. ");
INSERT INTO mavNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mi'i hawyi Iuwãu ti'a­tu­wesat more­kuaria sa'up sat haria pe — Yt ewei'a­tu­ma'at rei'o miit'in e. Eipo­rekuat miẽtup ok tã yn ewetat ro e Iuwãu mu'ap pyhyp haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mi'i hawyi i'ewyte sura­ra'in weset'ok teran haria apo'i­'a­tu'e Iuwãu me — Mi'i hawyi uruto apuru aikotã urutunug Tupana mowepit hamo i'atu'e. Mi'i hawyi Iuwãu ti'a­tu­wesat — Yt ewepo­hari tei'o irania'in ekat eipy­'ahak popuo ne'i e. Yt eheso i tei'o miit'in minug ko'i ete e. — Waku rakat mi'i miit ewei'e ro waku rakat pe e. — Yt naku i rakat mi'i miit ewei'e ro yt naku i rakat pe e. Yt eheso i tei'o miit'in etiat eipo­rekuat pe e. Mi'i hawyi yt naku i ewei'e eipo­rekuat pe — Uhepiat uipotpap hap sa'up emiium yt iwato i yt ewei'e tei'o e Iuwãu sura­ra'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mi'i hawyi miit'in hekatup kahato Tupana Mipo­'oro Ta'a­tu­po­rekuat nuat. Mi'i pote te'e­ru­wa­nẽtup kahato Iuwãu kape — Pywo apo Iuwãu ni Tupana Mipo­'oro Aipo­rekuat nuat put'ok'e sio yt i'atu'e te'e­ru­wa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma'ato Iuwãu to'e i'atuepe — Uito ti yt Tupana Mipo­'oro Wuat'i Ywania Ehakye­ra'at hanuat i e. Ta'i uito y'y wuat wo'o­set'ok hat ne'i ma'ato Mi'i Miit wẽtup ok wyti aru po'og wakuat uikawiat ra'yn e. Uhewaku hap uiat yt put'ok'e hin i heropat hanuat e. Uhewaku hap yt put'ok'e i Tupana Mi'airo Wuat'i Miit'in Porekuat nuat py sokpe saity pok hamo e. Uito y'y wuat yn wo'o­set'ok hat ma'ato Tupana Mipo­'oro Koro ti aru topot­set'ok miit'in Tupana Pã'ãu wo ra'yn e. Ma'ato yt eweimohey i Imipo­'oro pote ehaty'i haty'i hap yn topy­hu'at Tupana kaipywiat e. Ta'i yt eweimohey i Tupana Mipo­'oro pote aria wo ehet'ok hap haty hap ewywuat tutunug e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mi'i Miit panene ewy ihay put'ok­to'e hawyi aikotã wati­'a­tu­'yky arui iã'ỹi sese puẽti hamuat hap ewy ti aru toi'yky miit'in wakuaria puẽti hamo e. Mi'i hawyi toi'a­tukat kahato temiit'in wakuaria aikotã watikat panene pe arui iã'ỹi wakuat hap ewy e. Tomohey haria toi'a­tukat watikat iã'ỹi wakuat ewy i'ewyte tomohey ran haria toi'a­tukat iã'ỹi ape ewy e. Wasere upi toikat panene pyi hap ewy toi'a­tu­pat'ok tomohey haria sese i'ewyte tomohey ran haria e. Yt nakuaria i ti aru i'ape ko'i ewywuaria mipugha wuat aria yt hasep i rakat pe mi'iria ti aru toi'a­tu­pugha aria wuat'i e'at piat pe e Iuwãu õ'ẽ haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Wakuat sehay iã'ãkap wuo Iuwãu ti'a­tu­nãpin Iũtãu hy ẽpe etiaria miit'in mowe'eg hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","I'ewyte morekuat Eroti minug yt naku i hap ko'i toimo­herep yne. — Ta'i morekuat Eroti tero'ok toywyt morekuat Wiripi ehary'i hawyi totioto ra'yn to'yat kape teha­ry'i e. Yt naku i kahato mi'i tã watunug mote e Iuwãu miit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mi'i tã e Iuwãu morekuat ete pote morekuat Eroti tipyhik ta'yn ahet'ok hat Iuwãu wo'o­pyhik hawe. Toipyhyp Iuwãu hawyi — Yt naku i kahato morekuat Eroti i'atu'e miit'in. Iwato kahato morekuat Eroti minug sa'ag ko'i watikuap mesup i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pyno Iuwãu topyhik hap owakai te Iuwãu ti'a­tu­set'ok kahato miit'in. I'ewyte wẽtup e'at pe Iesui tut ra'yn howawi toset'ok hamo. Toset'ok hawyi Iesui Tupana kape ihay. Mi'i turan oken'ypy ewy tuwe­mo­herep atipy kaipyi. ");
INSERT INTO mavNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Mi'i hawyi atipy kaipyi Tupana Pã'ãu tut ra'yn pykasu ewy. Mi'i hawyi ta'apyk Iesui apy tote. Mi'i hawyi atipy kaipyi sehay put'ok'e Iesui etiat — Uha'yru Sese En e. Uimo­wepit kahato hat En Uha'yru En mote e. Arehum kahato epe Uha'yru Sese e Tupana Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Toset'ok hawyi Iesui ha'a­wynug na'yn topotpap hap 30 anu tuwe­motag hap ete. Mi'i hawyi Iesui ha'a­wynug To'ywot Tupana piat topo­'oro hap ko'i. Mi'i pote imimu­'eria miit'in te'e­ro'e — Ta'i watikuap ta'yn Iesui i'atu'e. Meiẽ ti ahetawa Nasare piat pani­pa­ni'e hat Iuse sa'yru i'atu'e. Iesui ywot Iuse mimotag hat topy­hu'at i'atu'e. Uito ti mesuwat miwan nug hat IRUKA. Pyno mesuwe ahenoi teran ehepe Iesui e'ase­'i'in sa'a­wy­'i­te­wuaria. Pyno Iesui ywot hit ewywuat IUSE Imotag hap topy­hu'at. Pyno Iesui e'ase'i Iuse ywot ERI e hap toĩne'en miwan me i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mi'i hawyi Iesui e'ase'i Eri ywot MATATI e hap toĩne'en. Mi'i hawyi Matati ywot IREWI toĩne'en i'atu'e. Mi'i hawyi Irewi ywot MEUKI e hap. Mi'i pytkai Meuki ywot IANAI i'atu'e. Ianai e hap ywot IUSE POT i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Pyno Iuse pot ywot MATATIA i'atu'e. Mi'i hawyi Matatia ywot AMO i'atu'e. Mi'i hawyi Amo ywot NAŨ i'atu'e. Pyno Naũ ywot ESIRI i'atu'e. Esiri ywot NAKAI i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mi'i hawyi Nakai ywot MAATE i'atu'e. Maate ywot MATATIA i'atu'e. Matatia ywot SEMEI i'atu'e. Semei ywot IUSEKI i'atu'e. Iuseki ywot IOTA i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Iota ywot IUANA i'atu'e. Iuana ywot IRESA i'atu'e. Iresa ywot SURUPAPEU i'a­tu'e. Suru­papeu ywot SARATIEU i'atu'e. Saratieu ywot NERI i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mi'i hawyi Neri ywot MEUKI i'atu'e Meuki ywot ATI i'atu'e. Ati ywot KUSÃ i'atu'e. Kusã ywot EUMUTÃ i'atu'e. Eumutã ywot ET i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Mi'i hawyi Et ywot IUSUE i'atu'e. Iusue ywot ERIESE i'atu'e. Eriese ywot IURĨ i'atu'e. Iurĩ ywot MATATE i'atu'e. Matate ywot IREWI i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Irewi ywot SIMEÃU i'atu'e. Simeãu ywot IUTA POT i'atu'e. Mi'i hawyi Iuta pot ywot IUSE i'atu'e. Iuse ywot IUNA i'atu'e. Iuna ywot ERIAKĨ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriakĩ ywot MEREA i'atu'e. Merea ywot MENA i'atu'e. Mena ywot MATATA i'atu'e. Matata ywot NATÃ i'atu'e. Mi'i hawyi Natã ywot aha'a­se'i Morekuat TAWI i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Mi'i uimiwan kaipyi watikuap ta'yn AIPOTYPOT IESUI Morekuat Tawi Emiariru Emiariru hap. Mi'i hawyi Morekuat Tawi ywot IESE i'atu'e. Iese ywot IUPETE i'atu'e. Iupete ywot PUASI i'atu'e. Puasi ywot SAMŨ i'atu'e. Samũ ywot NAASŨ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Mi'i hawyi Naasũ ywot AMINATAPE i'atu'e. Amina­tape ywot ATIMĨ i'atu'e. Atimĩ ywot ARANI i'atu'e. Arani ywot IRŨ i'atu'e. Irũ ywot WARE i'atu'e. Mi'i hawyi Ware ywot ase'i pot IUTA i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ase'i pot Iuta ywot IAKO i'atu'e. Iako ywot ISAKI i'atu'e. Isaki ywot aha'a­se'i koro APARÃU i'atu'e. Mi'i uimiwan kaipyi watikuap AIPOTYPOT IESUI aha'a­se'i koro Aparãu Emiariru Emiariru hap. Mi'i hawyi aha'a­se'i Aparãu ywot TARE i'atu'e. Tare ywot NAKU i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Mi'i hawyi Naku ywot SERUKI i'atu'e. Seruki ywot IRAKÃU i'atu'e. Irakãu ywot WAREKI i'atu'e. Wareki ywot EPET sa'yru. Mi'i hawyi Epet ywot SARE i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Mi'i hawyi Sare ywot KAINÃ i'atu'e. Kainã ywot AWASATE i'atu'e. Awasate ywot SẼ i'atu'e. Sẽ ywot wuat'i e'ase'i pot NU'E i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nu'e ywot IRAMEKI i'atu'e. Irameki ywot METUSARA mekewat ieĩne'en mot'i kahato hat i'atu'e. Mi'i hawyi Metu­sara ywot INOKI i'atu'e. Inoki yt iku'uro i katu­pono Tupana tioto atipy kape mi'i miit. Mi'i hawyi Inoki ywot IARETE i'atu'e. Iarete ywot MAREREU i'atu'e. Mi'i hawyi Merereu ywot KAINÃ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainã ywot ENU i'atu'e. Enu ywot SETE i'atu'e. Sete ywot ÃTÃU i'atu'e. Ãtãu ni Tupana minug mekewat miit sa'a­wy­'iwuat miit'in e'ase'i pot. Mesuwat miwan nug hat ti Iesui ehay moherep hat IRUKA. Pyno mesuwat uimiwan kaipyi watikuap yne ra'yn AHEHAKYERA'AT HAT IESUI e'ase'i e'ase'i pot Ãtãu emiariru emiariru emiariru hap ko'i Ãtãu kaipyi Iesui kape set ko'i watikuap yne ra'yn IESUI e'ase'i set ko'i. IESUI ywot sese ma'ato TUPANA. Waku ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Toset'ok hap kahu hawyi Iesui toto tuweran na'yn miit'in kaipyi mekewat Iũtãu hy pyi. Tupana Pã'ãu yn na'yn Iesui piit pe. Ta'i yne Tupana Pã'ãu topy­hu'at kahato ipiit pe. Mi'i pote tutunug Tupana miky­'esat ko'i torania i'e hap ewy yn tutunug. Mi'i hawyi mu'ap upi Tupana Pã'ãu to'e tope — Uha'yru e atiky­'esat ereto yahig wato kape aikope yt uwe i miit'in toĩne'en hap kape e. Mi'i hawyi Iesui toto Tupana Pã'ãu miky­'esat ewy. Mi'i hawyi ahiag akag sese toto Iesui ma'at hamo. Toiky­'esat Iesui temiit no. Toiky­'esat Iesui tomi­ky­'esat nug hanuat. ");
INSERT INTO mavNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ta'i 40 e'at 40 ewãtym Iesui toĩne'en mekewat yahig wato tote. Yt kat i mi'u tutu'u. Itote yt tenuk i 40 e'at 40 wãtym. Mi'i hawyi hesy'at sakpo'e tuete itote. Mi'i hawyi yt hesaika i yt kat i mi'u tutu'u hawyi sese yt hesaika i. ");
INSERT INTO mavNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hesy'at kahato sese itote. Mi'i turan ahiag akag toto Iesui iã'ãg hamo. Toiky­'esat Iesui tunug hã'ãg hap. Toiky­'esat Iesui tomi­ky­'esat nug hat. Mi'i hawyi toto Iesui kape hawyi to'e tope — Pywuat Tupana Sa'yru En mote etomo­herep to uhepe esaika hap wuat'i nug kuap hap e. Etunug no emi'u wo man mesuwat nu kawiat Mehĩ e. ");
INSERT INTO mavNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma'ato Iesui tiwesat — Yt atunug i rat e'e hap ewy ahiag e katu­pono sa'a­wy'i sese mio tã e Tupana Musei miwan Teute­ru­mumiu 8.3 pe — Yt naku i mi'u mesu­wa­rotiat yn eweikat at ka'ap eipiit mo'ok hamo e. Yt naku i mi'u kape yn eiwe­wa­nẽtup e. Mi'u kape yn eiwe­wa­nẽtup wote yt karãpe i eweikat eheĩne'en hap sese wuat'i e'at piat e Tupana Musei miwan me Teute­ru­numiu 8.3 pe e Iesui ahiag me. ");
INSERT INTO mavNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mi'i hawyi ahiag tioto Iesui yity'ok ywaiti kahato rakat kape hawyi itote pyi meremo toimo­herep Iesui kape more­kuaria etama mesuwat yi totiaria torania wuat'i etama i'atuekat ikahu rakat toimo­herep yne Iesui kape tomu­'etu hap ewy. Mi'i hawyi mi'i tote to'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","— Eraha'at ro mesu­wa­rotiat ikahu kahato rakat ko'i kape Mehĩ katu­pono mesuwat yi totiat atum yne teran epe uhemiit no ereĩne'en mote e. Ta'i yne miit atum teran epe mesuwat ewa'a­kasa hap ko'i katu­pono uiat yne mesuwat yi tote torania e. Atum kuap yne mesu­wa­rotiat ekat wo epe uimi­ky­'esat ewywuat etunug yne hawyi e. Uimõ­typot hap etunug hawyi mesuwat ko'i iwato hap ok tã atum yne torania epe e. Mi'i hawyi wuat'i Miit'in Porekuat no ereĩne'en mesuwat yi wato ok tã e. Mi'i hawyi wuat'i ywania tukup­te'en ewano i'ewyte emõtypot haria mi'iria te'e­ro­py­hu'at e ahiag Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","To'iro uhupi e. Ta'i uiat ko'i tukup­te'en meimuẽ­waria yi totiat yne e. Mi'i pote uimõ­typot En hawyi erepỹ­'ã­tutuk uhowawi mi'i pote aru atum yne ra'yn mesuwat yi totiaria epe Uhyt e ahiag Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma'ato Iesui tiwesat — Yt rat ahiag yt naku i arepỹ­'ã­tutuk ewawi katu­pono yt naku i woronug uhetu­pana wo ne'i katu­pono mio tã e Tupana Musei miwan me — Waku uhowawi yn eiwe­pỹ­'ã­tutuk e hawyi waku Uito yn eTupana wo areĩne'en e. Yt uwe i toĩne'en mi'i rẽ e Tupana nimo­pywiat Teute­ru­numiu 6.13 miwan me. Yt naku i pãi are'e — en tupana wo ahiag katu­pono Tupana yn Tupana wo topy­hu'at uimi­mõ­typot nuat Tupana yn aheropat hat e miwan me e Iesui ahiag me. ");
INSERT INTO mavNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mi'i hawyi ahiag tioto Iesui Ieru­sarẽi kape yity'ok totiat Tupana mõtypot yat koro ywaiti rakat tote toipag Iesui. Itote Tupana mõtypot yat piaria sem tukup­te'en mekewat okipy wato tote. Mi'i hawyi ahiag to'e Iesui pe — Pywo Tupana Sa'yru En mote e'oghyt'at ro meiũpepyi wuat'i miit'in ehamo hawyi waku erepopy hawyi wuat'i miit'in tikuap En Tupana Sa'yru sese hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Waku e'oghyt'at meiũpepyi yi kape i'atue­hamo katu­pono sa'a­wy'i Tupana to'e morekuat Tawi wepy 91.11 pe — Uhemiit ta'at pote yt iku'uro i katu­pono meremo atipo­'oro wẽtup ok atipy kaipyi ta'at rakat okhyt'at hamo hawyi yt iku'uro hin i e ti ahepe nimo te miwan me Mehĩ e ahiag Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mi'i hawyi — Pyno ehã'ãg no katu­pono atipy kaipy­wiaria meremo epytyk hawyi yt era'at i hamo e. Pyno erepopy ro mesu­wepyi wuat'i miit'in ehamo yi kape hawyi meremo ta'a­tukuap esaika hap e. Mi'i ehã'ãg hawyi yt erepik hin i yi tote e miwan me e ahiag Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma'ato Iesui tiwesat — Motoro ahiag pya kahato uikai yt atiky­'esat hin i e'e hap ewy atunug yt naku i ahã'ãg Tupana sio uiku­'uro sio yt hap ete katu­pono mio tã e i'ewyte Tupana miwan me — Yt naku i eiwe­kaipyi ewei'e — Yt uiwe'eg i pytkai uiminug sa'ag ete eweipehik uipo­wyro aru Tupana ei'e hap e. Yt naku i — Uipo­wyro aru ipoity'i pytkai ewei'e uhepe e Tupana miwan me e. Yt naku i uhã'ãg e Tupana sio eku'uro sio yt hap ete e Tupana ahepe nimo te Musei miwan Teute­ru­numiu 6.16 pe e Iesui ahiag me. ");
INSERT INTO mavNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mi'i hawyi ahiag ipohep ta'yn Iesui iã'ãg kahato hap ete pyi. Yt toima'at kuap i yt nakuap i nug hap ete ma'ato toto porap'i hap ewy ne'i katu­pono tut i tut i tereto karania wo Iesui iã'ãg iã'ãg hamo ma'ato Iesui po'og hesaika ahiag kai. ");
INSERT INTO mavNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mi'i hawyi Iesui ta'aipok i ra'yn tomotag hap kape yi Karireia kape. Tupana Pã'ãu piat tomoe­saika topyt­'atnug na'yn hap wywo ta'aipok. Mi'i hawyi waku kahato toimo­herep itote wuat'i miit'in mikuap kahato wo Iesui tuwe­motag hap itote hawyi ta'a­tu­henoi kahato to'ope to'ope — Iesui minug ko'i waku kahato yt uwe i minug ko'i ewy i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mi'i hawyi tewyry hap upi yne Tupana mõtypot yat ko'i pe teke miit'in atumu'e hamo. Toi'a­tu­mu'e hawyi waku kahato i'atu'e imienoi ko'i pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mi'i hawyi Tupana mõtypot hap e'at pe Iesui teke Tupana mõtypot hawe teko ewy Tupana mõtypot hamo. Mi'i hawyi Iesui ipoĩ'ãm na'yn miit'in py'a­setpe Tupana ehay moherep miwan miat hamo teko sa'a­wy­'iwuat ewy tomotag eko ewywuat. ");
INSERT INTO mavNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mi'i hawyi ta'atuium na'yn sa'a­wy­'i­tewuat Isaia miwan tope imimo­wẽpap hamo katu­pono sa'a­wy'i tetawa Nasare pe toimo­wẽpap Tupana ehay i'atuepe aikotã sa'a­wy'i kurum iwasu Iesui turan tomotag hap turan toimo­herep Tupana ehay miwan miat hap ewy. Mi'i hawyi totat Tupana ehay miwan miat hawyi toikat ra'yn miwan me aikowuat tomi­ky­'esat ewywuat. Mi'i hawyi toipuẽti ra'yn sehay tuwetiat hawyi toimo­wẽpap tomi­puẽti Tupana ehay tomo­herep hat Isaia e hap miwan miat hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","— Uiwy­ria'in e mesuwe mio tã e miwan me — Tupana Pã'ãu Wakuat toĩne'en kahato uhepe e. Ta'i Tupana ui'airo ra'yn tehay wakuat moherep hamo e. Ta'i Tupana ui'airo satek takaria ehakye­ra'at hamo yt hekat i rakaria mu'e yt kat sa'up i hamuat e. Yt kat etiat kuap i haria mowe'eg hamo ui'airo Tupana e. Mesup ta'yn Tupana uipo­'oro wanĩ­kaptia mipyhik piat ko'i pore­nõtem ta'a­tu­pyhik hap kaipywiat hamo e. I'ewyte ti yt iha pytig i rakaria moha­pytig hamo uipo­'oro e. Ta'i Tupana uipo­'oro ra'yn miit'in yt uwe miky'e i ko'i ky'e sese hamo e. Ta'i Tupana mio tã e uhepe — Atiky­'esat eti'a­tu­po­re­nõtem miit'in yne i'atu­wa­nĩ­kaptia po pywiat hamo e mesuwe miwan me e. ");
INSERT INTO mavNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tupana emiit'in ehakye­ra'at hap e'at enoi hamuat uipo­'oro e. Ta'i Tupana ihay mesuwe Isaia miwan me yianmete uhetiat e Iesui itotiaria Tupana mõtypot yat piaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mio tã e Iesui timo­wẽpap kahu hawyi tutum i ra'yn mekewat Isaia miwan Tupana mõtypot yat piat eropat hat pe. Mi'i hawyi Iesui ta'apyk ta'yn hawyi itote i'atu­mu'e hamo. Mi'i hawyi itotiaria te'e­ra­ha'at kahato howawi kat e aru ihay e hap kuap hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mi'i hawyi Iesui henoi i'atuepe — Mesuwat e'at mesuwat miwan uimi­mo­wẽpap sa'a­wy­'iwuat Isaia mienoi yianme uhetiat toha­'a­wynug na'yn ehehamo ra'yn topy­hu'at ra'yn e Iesui tomotag haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mi'i hawyi itotiaria — Waku kahato ihay i'atu'e. Ihay se kahato hap watikuap i'atu'e. Ma'ato kat pote iwe'eg kahato ra'yn i'atu'e. Uwe som imu'e iwe'eg hap ete katu­pono watikuap kahato Iesui ywot sese Iuse i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ta'i i'ywot Iuse pan'i­pan­'i'e hat i'atu'e. Pyno uwe imu'e iwe'eg hamo i'atu'e. Mi'i hawyi Iesui to'e tomotag haria pe — Ta'i eweikuap teran uwe piat uimu'e hap e. Ta'i ewehenoi teran sehay pot'i kaipyi mekewat sehay miky­ry'i hap kaipyi — Paini i'ahu rakat eremoe­hãite ro uruehamo aikotã irania'in eti'a­tu­moe­hãite hap ewy ewei'e teran uhepe uimo­weu­ka'i hamo. — Eti'a­tu­moe­hãite kahato miit'in tawa Kawa­na'ũ piaria i'atu'e pyno waku mesuwe emotag hawe tawa Nasare pe i'ewyte eti'a­tu­moe­hãite urutoria ewei'e teran uhepe yt kat i uimohey hap eikai pytkai e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mi'i hawyi — Etimo­herep uruepe esaika hap wuat'i nug hamuat hawyi uruimohei En kurum ewei'e pote woro­ho­'o­wesat — Yt uimõ­typot hin i yt uimohey hin i eipe mesuwe uimotag hap etawa pe are'e. Pywo ti rat Tupana ehay moherep hat Uito pytkai uimotag hap totiaria yt uimohey hin i e. Aikotã to'e miwan me — Uimotag haria yt uimohey hin i e ma'ato irania'in kape atipo­'oro uhehay moherep hat pote ta'a­tu­mohey kahato ma'ato imotag hap tote yt hin i e hap ewy kahato eiperia mesup eweipy­hu'at e. Ma'ato atipo­'oro ui'e hap moherep hat wẽtup ywania kape pote itotiaria i'atue­waure ka'a kahato e. Ma'ato ta'aipok ta'yn tuwe­motag hap kape hap totiaria yt uwe i iky'esat e. Ma'ato irania'in tawa ko'i kape — Ereke Mehĩ i'atu'e — Ereke Mimi i'atu'e e Tupana miwan me e Iesui tehay pun haria pe. Mi'i hap ewy kahato mesuwe e Iesui tomotag haria pe. Yt uwe i mesuwe uimohey haria e Iesui tawa Nasare piaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pyno ahenoi teran po'og uimohey hap pun hap ete e Iesui. Nimo sese te i'atu kahato hiwu ko'i tukup­te'en ai'y­wania Isareu ywania tukup­te'en mesuwe sa'a­wy'i ahe'yi tote e. Mi'i hawyi Tupana tipo­'oro temiit Eria e hap i'atue­wawi e. Mi'i hawyi Eria to'e i'atuepe — Mio tã e Tupana ehepe — Yt kat i hin i i'aman aru eimikoi ete hawyi yt kat i aru eimi'u e. Topap yne eimikoi yt kat i i'aman hawyi e. Mye'ym anu kape ti yt kat i i'aman e Tupana aha'a­se­'i'in me sa'a­wy'i Tupana mipo­'oro Eria wẽ pyi ma'ato yt ta'a­tu­mohey hin i. Ma'ato to'e hap ewy put'ok'e. Mi'i hawyi 6 ewaty yt kat i i'aman mote i'atu­mikoi ko'i topap yne hawyi i'atu­sy'at kahato mesuwat yi wato hap ok tã. ");
INSERT INTO mavNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mi'i hawyi Tupana tipo­'oro i tehay moherep hat Eria wẽtup ywania kape mekewat yi Sareta ywania etawa kape. Mi'i hawyi put'ok'e itote tawa hit Sitãu note uru'y­wania ewanĩ­kaptia etawa tote e. Mi'i hawyi itote hiwu wẽtup ywania yat pe toĩne'en porap Eria. Mekewat hiwu Tupana tipoi­tyro kahato e. Ma'ato Eria motag haria aha'a­se­'i'in yt timohey i Eria pote Tupana yt tipo­'oro hin i temiit Eria aha'a­se­'i'in hiwu ko'i kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","I'ewyte sa'a­wy­'iwuat Tupana ehay moherep hat Eriseu toĩne'en Tupana e hap moherep hat pywo sese hat mesuwe ahetawa pe e. Mi'i e'at pe tukup­te'en kahato itotiaria hepihi pihi rakaria heĩne'en turan ma'ato mi'iria Tupana mipo­'oro Eriseu yt ti'a­tu­moe­hãite kuap i kat pote yt ta'a­tu­mohey i pote e. Mi'i hap e'at pe wẽtup surara akag put'ok'e pya pyi Eriseu kape. Wẽtup ywania kaipyi tut. Wẽtup yi kaipyi tut mekewat hepihi pihi rakat Namã e hap het rakat e. Mekewat yi Siria kaipyi e. Mi'i hawyi toikat Tupana ehay moherep hat Eriseu tomoe­hãite hamuat hap ky'ewi. Mi'i ti Eriseu timoe­hãite meremo ra'yn Tupana esaika wo tomohey hap upi e. Yt ai'y­wania hin pytkai i toimoe­hãite e. Ma'ato ai'y­wania itote i'ahu rakaria ahyt tukup­te'en hepihi pihi rakaria e. Ma'ato mi'iria yt toi'a­tu­moe­hãite hin i katu­pono yt uwe i ahetama piaria imohey pote e Iesui tuwe­motag hap totiaria pe yt tomohey i haria pe. Mi'i hap ewy te Uito areĩne'en mesup eipy­'a­setpe e. Irania'in ywania po'og uimohey eikai e Iesui tomotag hanuaria pe mekewat tawa Nasare piaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mi'i hawyi Iesui ehay kuap kuap haria Tupana mõtypot yat piaria i'atu­py­'ahak kahato ra'yn Iesui ete — Irania'in ywania po'og eikai Tupana mohey hap ete e Iesui hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mi'i hawyi — To'iro wati­'auka Iesui i'atu'e. To'iro watipun Iesui yity'ok pyi yihot pe i'auka hamo i'atu'e. Mi'i hawyi ta'a­tu­hã'ãg i'auka hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma'ato put'ok­ta­'a­tu'e yity'ok tote Iesui auka hamo i'okpun hamo ra'yn turan Iesui tuwe­morem i'atueowa kape hawyi yt heremo hin i topy­hu'at. Mi'i hawyi — Aikope toto Iesui i'atu'e. Yt watikuap i ra'yn aikowo toto hap i'atu'e katu­pono i'atu­py­'a­setpuo tokosap. ");
INSERT INTO mavNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mi'i hawyi Iesui toto wẽtup tawa kape ra'yn tawa Nasare tuwe­motag hap totepyi. Mi'i hawyi Iesui ta'aipok ta'yn yi Karireia popyke tawa hit Kawa­na'ũ kape. Itote Tupana mõtypot hap e'at turan teke Tupana mõtypot yat pe itotiaria mu'e hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Itotiat Tupana yat piaria te'e­ru­wa­nẽtup kahato aikotã aikotã Iesui mienoi ko'i kape. — Iesui yt irania'in aimu'e haria ewy hin i i'atu'e katu­pono Morekuat Koro ewy aimu'e i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mi'i turan toĩne'en Tupana yat pe wẽtup ok miit ahiag ipiit piat rakat. Mi'i hawyi ahiagnia ta'a­tuehay pirik wo te'e­ro'e Iesui pe mekewat miit wẽ pyi. ");
INSERT INTO mavNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","— Kat hamo som eriot uruewawi Iesui i'atu'e. Kan etiky­'esat urukaipyi i'atu'e. Ta'i uruikuap ta'yn uru'auka hamo eriot i'atu'e. Pywo ti rat uruikuap En. En ni Iesui tawa Nasare kaipywiat sut hat wakuat i'atu'e. En ni Tupana Mipo­'oro ahiag akit hamuat i'atu'e haty wo. ");
INSERT INTO mavNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mi'i hawyi Iesui wãi'e ahiagnia pe — Eipo­'inik to ahiag e. Erẽtem no meiẽwat miit piit pyi ahiag e. Mi'i hawyi ahiag tipun temiit i'atu­py­'a­setpe tuwẽtem ipiit hawe. Mi'i hawyi sa'a­wy­'iwuat miit ahiag ipiit piat rakat waku ra'yn ahiag ipun pytkai yt kat i haty ipiit ete. ");
INSERT INTO mavNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mi'i hawyi Iesui minug wakuat kape te'e­re­wa­nẽtup kahato hawyi te'e­ro'e to'ope — Aikotã som toi'a­tu­sopo kuap ahiagnia i'atu'e. Po'og ahiag kai Mi'i Miit hesaika i'atu'e. Yt aimu'e haria ewy hin i tutunug kuap. Toipo­'oro pote ahiag tuwẽtem meremo ihay pyi. Pywo pe ti po'og paini kai Iesui i'atu'e. Ta'i Tupana Mipo­'oro Aipo­rekuat nuat hesaika hap ewywuat nug hat toi'a­tu­po­re­nõtem ahiagnia meiũwat miit piit pyi i'atu'e. Tehay wo yn toi'a­tu­sopo kuap ahiagnia i'atu'e wanẽtup haria. ");
INSERT INTO mavNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mi'i hap ewy tutunug mote wuat'i puaria ikuap yne Iesui minug wakuap ko'i ahiag sopo tehay wuat hap. ");
INSERT INTO mavNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mi'i hawyi Iesui tuwẽtem Tupana yat pyi hawyi toto ra'yn topot­mu'e Nu Simãu Peteru yat kape. Mi'i tote Peteru sakitu i'ahu rakat toĩne'en. Ipiit hakup kahato. Mi'i hawyi ta'a­tu­hẽtup ta'yn Iesui pe — Etimoe­hãite o meiũwat uruwy Peteru sakitu i'ahu rakat Mehĩ i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mi'i hawyi Iesui toto ra'yn Simãu sakitu ewawi. Mi'i hawyi wãi'e i'ahu hawe hawyi tokosap meremo ipiit sakup hap. Mi'i hawyi waku ra'yn. Tehãite meremo hawyi iãpe­'ok'am getap wiat topotpap hamo õ'ẽ haria eropat hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mi'i hawyi at min'e hawyi ta'a­tuerut kahato ta'a­tu­wy­ria'in i'ahu rakaria Iesui ewawi. Mi'i hawyi Iesui tuwe­ponug i'ahu rakaria ete hawyi toi'a­tu­moe­hãite yne. Tuwe­ponug hawyi waku yne ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","I'ewyte Iesui ti'a­tu­po­'oro yne ahiagnia miit'in piit pyi. Tuwe­nõ'ẽ turan i'atuehay pirik kahato — Ta'i En ni Tupana Sa'yru Iesui i'atu'e. Ma'ato Iesui wãi'e i'atuepe. Yt toiky­'esat i tomo­herep hap katu­pono ahiag tikuap Iesui Tupana Sa'yru hap. Mi'i pote — Wãi'e i'atuepe eipo­'inik to yt ewehenoi tei'o uwe Uito hap eweikuap hap ok tã e Iesui ahiagnia pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ihot'ok kai i toto Iesui tuweran tawa Kawa­na'ũ pyi yt uwe i miit toĩne'en hap kape Tupana wywuat tehay kahato hamo. Mi'i hawyi miit'in tikat kahato Iesui. Ta'a­tu­puẽti hawyi — Ereĩne'en no uruwywo uruetawa pe Mehĩ i'atu'e. Eto hawyi yt uruiky­'esat hin i katu­pono i'atu kahato miit'in ekat haria i'atu'e miit'in sem Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma'ato Iesui ti'a­tu­wesat — Uiwy­ria'in ahenoi teran wuat'i tawa pe aikotã aikotã Tupana topy­hu'at Wuat'i Miit'in Porekuat no hap etiat e. Mi'i nug hamo Tupana uipo­'oro e. Mi'i tupono atunug neran uipo­'oro hap e. — Atiky­'esat yne ywania mu'e hap Tupana e hap ewy uipo­'oro pote Wuat'i mu'e hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mi'i pote toto ra'yn tawa Kawa­na'ũ pyi yne y'y hit i upi yne yi Iuteu puo wuat'i miit'in mu'e hamo. Yne Tupana mõtypot yat ko'i kape toto. Mi'i hawyi teke yne Tupana mõtypot yat ko'i pe tohenoi Tupana toĩne'en Miit'in Porekuat hap. ");
INSERT INTO mavNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mi'i hawyi wẽtup e'at pe Iesui yi Kene­sare hyemyi'a hyẽpeke toĩne'en. Mi'i tote te'e­ru­wa­'a­tunug kahato miit'in typy'i rakaria Iesui ewawi Tupana ehay kapiat wanẽtup hanuaria. ");
INSERT INTO mavNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Itote turan typy e'yara yẽpe piat ko'i pe Iesui ta'a­kasa pira pytyk haria kape. Ma'ato ika'i­waria yt uwe i yara ko'i pe katu­pono te'e­ru­we­suki wato koho hamo tuwe­nõ'ẽ ta'a­tue­'yara pyi ihyemyi'a hyẽpeke kape pira pytyk haria. ");
INSERT INTO mavNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mi'i hawyi typy'i kahato tomi­mu­'eria pote Iesui teke ra'yn wẽtup yara pe hawyi to'e yara ka'iwat Simãu Peteru pe — Mehĩ atipuru porap e'yara katu­pono mi'i totepyi ati'a­tu­mu'e teran miit'in sem ihyemyi'a hyẽpeke piaria hamo e Iesui Simãu me. Mi'i hawyi Iesui e hap ewy meremo Simãu tunug. Mi'i hawyi Iesui ta'apyk yara pe hawyi toi'a­tu­mu'e ra'yn miit'in mekewat yẽpe­ke­to­tiaria yara pyi. ");
INSERT INTO mavNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mi'i hawyi tehay kahu ra'yn hawyi to'e ra'yn Simãu me — Ereto i ro ihy pya kape e. Mi'i totepyi ewyria'in wywo waku eweipytyk pira ko'i waku ewetopag ehesuki y'y pe pira pytyk hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma'ato Simãu to'e — Uruka­'iwat e uruikat kahato ra'yn ka'ap mo pira suki wato wo wen ma'ato rat yt kat i hin i pira uruipytyk yt wẽtup i uruipytyk uruesuki wo e. Ma'ato etiky­'esat pote urutunug neran e'e hap ewy mi'i hawyi waku e'e hap ewy urutopag uruesuki y'y pe Mehĩ e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mi'i hawyi ta'a­tupag y'y pe ta'a­tue­suki wato hawyi ipyt'at kahato ra'yn pira wo. Mi'i hawyi pira sem ko'i tihiot i'atue­suki wato. ");
INSERT INTO mavNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mi'i pote ta'a­tu­kaykay ra'yn ta'a­tu­wy­ria'in wẽtup yara piaria ta'a­tu­po­wyro hamo. Mi'i hawyi ta'a­tu­hytmoi ta'a­tue­'yara ko'i pe pira sem hawyi porap te'e­ra­'a­py'at pira i'atu kahato pote. ");
INSERT INTO mavNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mi'i hawyi Simãu Peteru ta'a­kasa Iesui minug wakuat kapiat hawyi toikuap ta'yn Iesui minug yt uwe i minug kuap hap ok tã hawyi tuwe­pỹ­'ã­tutuk Iesui eowa kape to'e hamo — Mehĩ e ereto o pya kahato uikai kat pote yt nakuat i kahato rakat uito e tuwenoi ra'yn Iesui pe. — Ta'i uiat uhewaku hap ti yt put'ok'e hin i emiit no areĩne'en hamo e. Mesup worokuap En wuat'i nug kuap hat ereĩne'en hap e. Mi'i pote Wuat'i Ka'iwat no ereĩne'en e. Mi'i pote aremõti uiminug sa'ag ko'i ete e. Mi'i pote yt naku i areĩne'en emiit no e Peteru Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mi'i hawyi Simãu tuwa­nẽtup kahato pira sem kape i'ewyte yne iwywuat wat haria yara piaria te'e­ru­wa­nẽtup kahato i'atu kahato pira ta'a­tu­pytyk pote. ");
INSERT INTO mavNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","I'ewyte Simãu ekatu­wyria seseria he'yara piaria ipowyro haria mehĩ Tiaku mehĩ Iuwãu mekewat uhyt Sepeteu sa'y­ru'in te'e­ru­wa­nẽtup kahato wy pira pytyk kahato hap kape. I'ewyte Simãu teha'at kahato hawyi Iesui to'e — Yt erewa­nẽtup tei'o po'og mi'i hap kape Simãu e katu­pono wyti aru mesuwat hawyi miit'in atupytyk Tupana wanuat hamo ra'yn ereĩne'en ni aru aikotã mesuwat pira pytyk suki wuat hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mi'i hawyi te'e­ru­wehik ta'yn ihyemyi'a hyẽpeke hawyi ta'a­tu­'atoiat ta'a­tu­potpap hap pira pytyk hap Iesui upiat tuwat hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iesui toĩn'en wẽtup tawa pe turan tut ra'yn wẽtup ok miit hepihi pihi kahato rakat Iesui ewawi. Ipe ete hepihi yn yne ipiit ete. Mi'i ti tuwe­wahik yi tote porog me Iesui yatype hẽtup hamo — Mehĩ e uimoe­hãite teran mote atiky­'esat kahato uimo­waku hap. ");
INSERT INTO mavNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mi'i hawyi Iesui tuwe­ponug ipiit pe hawyi to'e — Ta'i woro­moe­hãite teran uhyt e. Mio tã e hawyi meremo ipe pakup we toĩne'en. Yt wẽtup hepihi pihi i toĩne'en ipiit ete tokã'ã ra'yn hepihi pihi hap ko'i. ");
INSERT INTO mavNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ipiit waku hawyi Iesui haty wo ra'yn to'e tope — Uhyt yt ehenoi tei'o irania'in me uhepiat emoehãite hap mesup ma'ato ereto ro meremo pa'i kape epiit kahu hap etiat moherep hamo aheko ewy e. I'ewyte etum no pa'i pe Tupana piat emoehãite hap sa'up aikotã sa'a­wy­'iwuat Musei aimu'e hap ewywuat e. Mi'i etunug hawyi pa'iria tikuap ta'yn epe moehãite hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mi'i hawyi irania'in po'og ikuap Iesui etiat hawyi tõ'ẽ tõ'ẽ miit'in typy'i kahato Iesui ehay kapiat te'e­ru­wa­nẽtup hamo. I'ewyte i'ahu rakaria ko'i tõ'ẽ ta'a­tu­moe­hãite Iesui piat kat hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mi'i pote Iesui toto tuereto yt uwe i miit hap kape Tupana wywuat tehay hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wẽtup e'at pe Iesui piat miit'in atumu'e hap tote tukup­te'en nagnia ehay enoi haria i'ewyte miwan enoi haria apyk puo tukup­te'en yi Karireia kaipy­wiaria yi Iuteu kaipy­wiaria tawa wato Ieru­sarẽi kaipy­wiaria tõ'ẽ mi'iria Iesui mienoi kuap hamo. Mekewat e'at pe toĩ kahato Iesui kai Tupana esaika hap i'ahu rakaria moehãite hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mi'i turan tõ'ẽ ihainia'in ko'i wẽtup ok yt ipoĩ'ãm kuap i rakat yni pe aria'yp ete he'yni pe ta'a­tuerut Iesui ewawi. Mi'i tote miit sem kahato puo ta'a­tue­ro­kosap i'ahu rakat Iesui kape. ");
INSERT INTO mavNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ma'ato yt aikopuo kuap i ta'a­tue­ro­kosap Iesui kape. Mi'i hawyi miit'in tok puo yt ta'a­tue­reke kuap i pote te'e­ra'am na'yn getap ok tote hawyi ta'a­tu­'oghot ra'yn mare itote ywaiti Iesui apy tote. Mi'i hawuo ta'a­tu­mo­'apyk Iesui yatype yt hewyry kuap i rakat. Miit'in tok puo Iesui ywytpe ta'a­tu­mo­'apyk. ");
INSERT INTO mavNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mi'i hawyi Iesui tikuap ta'yn i'atuepiat tomohey hap hawyi to'e yt ipoĩ'ãm kuap i rakat pe — Uiwy e koitywy o waure wo ra'yn eminug sa'ag ko'i kai areĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mi'i hawyi itotiaria nagnia ehay enoi haria i'ewyte miwan enoi haria te'e­ro'e te'e­ru­wa­nẽtup hawe — Heiẽ yt naku i Iesui ihay sa'ag kahato Tupana ete i'atu'e katu­pono Tupana yn ni iwaure kuap aiminug yt naku i hap ko'i i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ma'ato i'atu­wa­nẽtup hap ko'i Iesui tikuap yne ra'yn tuwa­nẽtup hawe. Mi'i pote to'e wanẽtup haria pe — Kat pote mio tã ewei'e eiwa­nẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ta'i — Waure wo ra'yn ni eminug sa'ag ko'i kai areĩne'en mesup are'e ra'yn mesuwat miit pe e. Yt niatpo hin i — Waure wo are'e miit'in me e. Ma'ato po'og niatpo wato'e yt hewyry kuap i rakat pe — Epoĩ'ãm no hawyi ewyry ro wato'e niatpo kahato e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mi'i pote pono atimo­herep ehepe uhesaika hap miit'in mi'a­parap ko'i moweityk hamo e. Ta'i Uito ti Miit'in Eyke'et mi'i pote ti uhesaika hap put'ok'e wuat'i miit'in minug yt naku i hap ko'i moma hamuat e. Mi'i uhesaika hap moherep hamuat mesup uhehay wo atimoe­hãite meiũwat yt hewyry kuap i rakat yne ehehamo e. Mi'i hawyi eweikuap ta'yn uhehay wuat atihep kuap wy eiminug sa'ag ko'i hap e itotiaria pe. Mi'i hawyi to'e yt ipoĩ'ãm kuap i rakat pe — Epoĩ'ãm no mehĩ hawyi eti'ok­po'i ro e'yni hawyi ereto ro e'yat kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mio tã e hawyi meremo sa'a­wy­'iwuat i'ahu rakat ipoĩ'ãm hawyi toi'ok­po'i te'yni hawyi toto ra'yn to'yat kape tuwehum kahato Tupana kape toto turan. ");
INSERT INTO mavNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Itotiaria te'e­ru­wa­nẽtup Iesui minug etiat hawyi te'e­ru­wehum kahato Tupana kape ma'ato te'e­ro­ken'ẽ hap wywo te'e­ro'e — Iesui yt uwe i ewy i'atu'e. Aikotã pyno tutunug wakuap mi'i hap ewy i'atu'e. Meiũwat ewywuat yt miit'in minug kuap ewy hin i i'atu'e. Yt karãpe i mi'i ewywuat kape wata­'a­kasa meikotã nug hap kape i'atu'e to'ope. Mi'i pote te'e­ro­ken'ẽ kahato Iesui pupi. ");
INSERT INTO mavNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mi'i hawyi toto i ra'yn Iesui mekewat tomi­moe­hãite yat pyi hawyi mu'ap upi teha'at kahato wẽtup miit kape. Ta'a­kasa wẽtup ok yt uwe miky­'esat i rakat kat pote mu'ap pyhyp hano toĩne'en sura­ra'in wanĩ­kaptia powyro rakat pote. More­kuaria wanĩ­kaptia wywo toi'a­tu­pyhyp yne mu'ap ko'i. Itote pyi toi'a­tu­ky­'esat wuat'i miit'in kaipyi mu'ap sa'up. Iwato kahato toi'a­tu­po­re­ra'at Iuteuria ewanĩ­kaptia porekuat wano. Mi'i hawyi ipat'ok towanuat totat sa'ag. Mi'i hawyi iha'at kahato Iesui howawi mehĩ Mateu Irewi e hap het rakat kape. Mi'i hawyi toto howawi hawyi to'e — Woro­ky­'esat en uhemiit no e. Pyno to'iro uhupi e Iesui Mateu pe. ");
INSERT INTO mavNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Toikaykay hawyi meremo ipoĩ'ãm Iesui upiat toto hamo. Mi'i hawyi toi'a­tu­'atoiat yne yne tomisat ko'i sa'up iwato rakat yparakai tomi­'a­pykok tote. Yt toiky­'esat i po'og katu­pono toto teran Iesui upi pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mi'i hawyi Irewi Mateu toto ra'yn Iesui upi hemiit no. Mi'i hawyi Iesui mekewat Mateu Irewi tioto to'yat kape imoenuk hamo. Put'ok­to'e to'yat pe hawyi ienuk hap tutunug Iesui etiat tuwehum haype. Mi'i hawyi toi'a­tu­kaykay towy­ria'in to'e­wywuat sa'up pore­ra'at haria toi'a­tu­kaykay irania'in wywo. Mi'i hawyi yt naku i kahato rakaria py'a­setpe Iesui toĩne'en. ");
INSERT INTO mavNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mi'i hawyi nagnia ehay enoi haria i'ewyte miwan etiat wãi'e hap moherep haria te'e­ra­ha'at Iesui ienuk hap kape hawyi mi'iria i'atu­py­'ahak Iesui ete i'ewyte Iesui potmu­'eria ete. Mi'i pote te'e­ro'e — Kat poteĩ Eika­'iwat yt nakuaria i sa'up pore­ra'at haria wywo tenuk hamuat toto i'atu'e. Yt naku i yt nakuaria i wywo watenuk e miwan me i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ma'ato Iesui ti'a­tu­wesat — Uhyt'i'in e yt eweikuap i apo aikotã ihãite rakaria yt ikat hin i mohag nug hat ta'a­tu­moe­hãite hamo e. Ma'ato irania'in i'ahu rakaria ihãite pik'e rakaria ikat kahato mohag nug hat ta'a­tu­mo­hãite pakup i hat ta'a­tu­mo­pakup i hat e. Uito areĩne'en mohag nug hat ewy. Mesu­wa­ro­tiaria ehakye­ra'at hamo Tupana uipo­'oro miit'in yt naku i nug haria moehãite hamo uipo­'oro e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","— Uito ti yt ariot i wakuaria mowaku pakup i hamo katu­pono — Uruto po'og waku tora­nia'in kai i'atu'e. Mi'i e haria yt uikat i — Uruto waku kahato Tupana wanẽtup hawe i'atu'e haria ewy e. Mi'i pote yt ati'a­tue­ha­kye­ra'at kuap i mi'iria ma'ato irania'in — Yt nakuaria i uruto e haria tikuap kahato ra'yn yt i'atue­waku i hap pote mi'iria ati'a­tue­ra­'aipok kuap Tupana kape e. Mi'iria mu'e hamo ariot e. Ma'ato — Uruto waku e haria yt ati'a­tue­ha­kye­ra'at kuap i e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mi'i hawyi mekewat — Uruto po'og e haria te'e­ro'e Iesui pe — Uhyt i'atu'e ahet'ok hat Iuwãu potmu­'eria i'ewyte nagnia ehay enoi haria te'e­ru­we­mo­sy'at kahato ta'a­tuehay Tupana kapiat moesaika hamo i'atu'e. Ma'ato ewat epotmu­'eria te'e­ru­wenuk yn i'atu'e. Yt te'e­ru­we­mo­sy'at hin i ta'a­tuehay Tupana kapiat moesaika hamo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mio tã te'e­ro'e hawyi Iesui ti'a­tu­wesat — Pyno ahenoi teran hã'ãkap wuo uhehay e. Karãpe toĩne'en ienuk wato hap e'at aiwo­'o­mo­wepit hap e'at turan he'aito pakup takat e'at mõtypot hap turan ihary'i pakup takat e'at mõtypot hap turan mekewat e'at pe yt uwe i tuwe­mo­sy'at teran i'atu­wepit teran hap yn te'e­renuk hap yn wo'o­kyi'at hap e'at piat pote se'aito hap e'at piat pote e. Ta'i i'atu­wepit kahato te'e­renuk turan e. Mi'i hap ewy kahato areĩne'en mekewat Se'aito Pakup ewy e. Uhemiit'in wywo areĩne'en turan i'atu­wepit kahato aikotã wo'o­kyi'at hap e'at piaria ewy are e. Pyno se'aito hap e'at pe i'atu­wy­ria'in i'atu­wepit kahato te'e­renuk turan e. Se'aito wywo tukup­te'en turan yt te'e­ru­we­mo­sy'at teran hin i e. Yt i'atu­'arot hin i tukup­te'en aikotã wo'o­kyi'at hap turanuat ienuk hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","— Ma'ato meiũran ti aru Uito irania'in tioto ui'auka hamo mi'i hap e'at turan aikotã se'aito pya ta'a­tue­reto to'yat totepyi hap ewy irane areĩne'en e. Mi'i hap e'at pe ti aru i'atu­'arot sese hap topy­hu'at i'atuepe. Yt te'e­renuk hin i katu­pono i'atue­hat'at kahato uiky­'ewi haype e. Aikotã watihep se'aito ipakup te turan hap ewy hawyi iwary pakup i'arot toĩne'en hap ewy aru tukup­te'en ta'a­tu­'arot hap wywo e. Mi'i hap e'at pe yn te'e­ru­we­mo­sy'at kahato ra'yn e Iesui — Kat pote yt eremo­sy'at i uruto ewy e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mi'i hawyi wẽtup sehay iã'ãkap i Iesui henoi seko pot'i enoi haria pe. — Uiwy­ria'in mana'in eweikuap aikotã yt naku i watomog ahesokpe pot'i sokpe kype pakup wo e. Mi'i tã yt ikahu hin i watunug katu­pono wato­pi'ig sokpe pot'i hiot'e hap sokpe pakup wo hap yt ikahu hin i topy­hu'at e. Mi'i wati­koho hawyi sokpe pakup tihiot ne'i ra'yn totekyi kahato pote sokpe pot'i e. Mi'i hawyi sokpe pot'i hiot'e rakat po'og hiot'e sa'a­wy­'iwuat kai e. Ta'i mi'i ewy kahato ti uhehay wakuat pakup toĩne'en e. Ta'i yt watopag kuap i uhehay pakup sehay pot'i tote katu­pono yt to'o­'ewy hin i e. Ma'ato to'opuo to'opuo wahenoi uhehay sehay pot'i puo pote po'og topy­hu'at yt naku i e. Aikotã ahesokpe pot'i hiot'e sese hap ewy topy­hu'at e. I'ape pot'i hawyi iteneg kahato ra'yn e Iesui — Kat pote yt etunug yne i urueko ewy e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mi'i hawyi Iesui to'e miit'in akag ko'i yt tomohey i haria pe — Pyno wẽtup sehay iã'ãkap ahenoi i ehepe e. Uiwy­ria'in e yt naku i wato­mohey typy sehay yt to'o­'ewy i pytkai e. Yt naku i to'opuo to'opuo eweipag uhehay pywo sehay rakat sehay yt pywo rakat i wywo e. Pywo ti rat ahetama puo watopag Uwa ywa hy heiam pakup we yn e. Ta'i aheka­mũti i'ape pakup kawiat pe yn watopag e. Mi'i hawyi mekewat Uwa ywa hy tuwe­mõpuk itote e. Mi'i i'ape pakup we waku yt ipe teneg i pote e. Ta'i i'ape yt gag i te pote torok'e te'en te'en ne'i Uwa ywa hy pakup henãpuk ne'i hawyi e. Ma'ato ahetama puo watopag Uwa hy pakup yt ihyenãpuk i te turan heiam pot'i pe pote i'ape teneg nakat heiam me mi'i mye'ym e'at hawyi ihyenãpuk ta'yn turan ipe heiam teneg nakat ipot'i rakat yt torok'e i hawyi yt naku i katu­pono heiam pok'e hawyi Uwa hy yt kat i ra'yn toto yne yi tote e. Mi'i hawyi yt kat i topy­hu'at Uwa hy toto yne ra'yn mote e. I'ewyte heiam mot'i hiot'e wy hawyi yt naku i pe toĩne'en. ");
INSERT INTO mavNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mi'i pote ahetama puo watopag Uwa hy i'ape yt igag i te rakat pe e. Mi'i hawyi toĩne'en mot'i itote ahesapo wuat waku rakat e. Mi'i tã ti watunug ahetama puo mana'in uhyt'i'in e. Mi'i ui'e hap ewy kahato ti uhehay he kahato rakat ipakup e. Mi'i pote waku watopag ipakup we e. Yt teke kahato i sehay pot'i pe e Iesui typy sehay upiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma'ato eipe — Po'og waku iporo rakat ewei'e hawyi yt eweiky­'esat i uhehay pakup e. Eipe eweikup­te'en mahy u haria ewy e. Mi'i u haria tiky­'esat kahato sapo hy pot'i ahetama pe te'e­ru­we­mo­pẽ'ã hamo e. — Watikuap ihy nem hap u hap i'atu'e. Mi'i po'og waku uruwa­nẽtup hawe i'atu'e. Yt kan hamo i sapo hy pakup uruwa­nẽtup hawe i'atu'e. Imopẽ'ã teran nakaria mio tã i'atu'e. Mi'i haria ewy kahato eweikup­te'en uhehay pakup yt ky'esat i pote — Yt kan hamo i ehay pakup ewei'e pote katu­pono urumikuap iporo rakat po'og he ewei'e e. Mi'i pote yt karãpe i eiwe­hekuap ipakup takat e. — Ipot'i rakat po'og waku ewei'e yn e Iesui tehay pun haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mi'i hawyi yt i'atu­potpap i hap e'at pe Iesui awati ypia puo tokosap towy­ria'in nywo. Mi'i hap tote iwyria'in ho'opik ta'yn awati ta'a­tu­ko­ka'at no hawyi ta'a­tu'u ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mi'i pote nagnia ehay enoi haria te'e­ro'e i'atuepe — Kat poteĩ eweho­'opik awati yt aipotpap i hap e'at pe i'atu'e. Mi'i tã ti yt naku i aiwo­'o­nãpin hawe i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mi'i tã ti i'atu'e pote Iesui to'e — Yt eweikuap i aikotã sa'a­wy­'ite morekuat Tawi tunug tesy'at hawyi e. I'ewyte towy­wuaria tesu­ra­ra'in i'atue­sy'at hawyi hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Teke Tupana mõtypot hawe hawyi tutu'u mekewat man wakuat Tupana kapiat pa'i mi'u wuat yn mekewat man yt naku i miit re'en ne'i mi'u wo e miwan me wen ma'ato morekuat Tawi i'u hesy'at kahato hawyi. I'ewyte toimõ'ẽ mekewat man tesu­ra­ra'in me. Ma'ato miwan me waku pa'i mi'u wuat yn wo rakat man tutu'u tesu­ra­ra'in wywo. Yt naku i irania'in mi'u e miwan me wen. ");
INSERT INTO mavNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pyno Tupana tipo­'oro ra'yn ehowawi Wuat'i Miit'in Yke'et e hap het rakat e. Mi'i Miit toĩne'en Tupana Mipo­'oro Wuat'i Miit'in Akag wo e. Mi'i pote waku ahenoi ehepe uheywyt'in uheinyt'in kat som waku watunug kat som yt naku i watunug Tupana mõtypot hap e'at pe e Iesui tuwepiat. ");
INSERT INTO mavNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mi'i hawyi wẽtup yt motpap i hap e'at piat turan teke ra'yn Iesui Tupana mõtypot hawe miit'in atumu'e hamo. Mi'i hap tote wẽtup ok ipo sese kawiat ipo kag mot'i rakat toĩne'en. ");
INSERT INTO mavNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mi'i hawyi Miit'in mu'e haria itotiaria wãi'e hap miwan miat moherep haria te'e­ro'e to'ope — Waku wate­ha'at kahato Iesui kape sio ipotpap mesup yt aipotpap i hap e'at pe sio yt sio toimoe­hãite mekewat ipo kĩ'ã rakat sio yt i'atu'e to'ope. Ipotpap Iesui pote waku wato'e wuat'i ehamo — Yt naku i rakat meiẽ Iesui wato'e i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma'ato toma'at teran hap i'atu­wa­nẽtup hawiat Iesui tikuap ta'yn tuwe­kaipyi hawyi toikaykay ra'yn ipo kĩ'ã rakat tuwe­wawi wuat'i ehamo hawyi to'e — Uhyt eriot ro meikowo waku meiũpe y'am me ereĩne'en wuat'i miit'in py'a­setpe wuat'i miit'in ehamo e ipo kĩ'ã rakat pe. Ipoĩ'ãm na'yn hawyi hewyry miit'in py'a­setpuo. ");
INSERT INTO mavNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mi'i hawyi Iesui apo'e irania'in me — Kat som to'e miwan me Tupana mõtypot hap e'at ete e. Aikotã watunug mesuwat e'at pe sio wakuap watunug sio yt nakuap i watunug sio miit'in ky'e hap sio miit'in auka hap kat som to'e miwan me hap watunug e mi'i hap ete apo'e itotiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mi'i hawyi yt ta'a­tu­wesat kuap i. Mi'i hawyi Iesui teha'at kahato itotiaria ewawi mot'i hawyi to'e ipo kĩ'ã rakat pe — Uiwy e erepo­torok to meikowo e. Mi'i hawyi ipo kĩ'ã rakat tuwe­po­torok ta'yn hawyi waku ra'yn ipo. ");
INSERT INTO mavNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mi'i pote wãi'e hap enoi haria i'atu­py­'ahak kahato ra'yn Iesui ete. Mi'i hawyi te'e­ro'e to'ope — Aikotã aru wati­'akit wati­mohit mesuwat Iesui i'atu'e ta'a­tu­py­'ahak popuo. ");
INSERT INTO mavNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mi'i hawyi Iesui toto yity'ok kape Tupana wywuat to'oehay hamo. Mi'i hawyi wãtym ka'ap ihay Tupana wywo yity'ok tote. ");
INSERT INTO mavNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ihot'ok hawyi toi'a­tu­kaykay ra'yn temiit'in sem tuwe­wawi. Mi'iria kaipyi 12 ok takaria toi'a­tu­'airo topot­po­'o­roria 12 ok takaria wo. ");
INSERT INTO mavNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sa'a­wy'i Simãu toi'airo topot­po­'oro wo tehay moherep hamo. Mi'i hawyi het tutum pakup i PETERU e Simãu me het pakup ta'yn. Mi'i hawyi Peteru ywyt ÃTERE toi'airo tomi­po­'oro wo tehay moherep hamo. Mi'i hawyi TIAKU toi'airo temiit sese wo tehay moherep hamo. Mi'i hawyi IUWÃU toi'airo tomiit sese wo tehay moherep hamo. Mi'i hawyi WIRIPI toikaykay tuwe­wawi temiit sese wo tehay moherep hamo. Mi'i hawyi PATURUMEU toi'airo topot­mu'e sese wo tehay moherep hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mi'i hawyi MATEU toi'aro topot­mu'e sese wo tehay moherep hamo. Mi'i hawyi TUME toi'airo tomi­po­'oro sese wo tehay moherep hamo. Mi'i hawyi wẽtup ok TIAKU mekewat Auweu sa'yru toi'airo tomi­po­'oro wo tehay moherep hamo. I'ewyte wẽtup ok SIMÃU toi'airo topot­po­'oro wo tehay moherep hamo. Mekewat sa'a­wy­'iwuat surara powyro hat tetama piaria wanĩ­kaptia sytpok hamo rakat — Uhetama Kana'a po'og wakuat torania kai e hat. ");
INSERT INTO mavNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Mi'i hawyi IUTA mekewat Tiaku sa'yru toi'airo temiit sese wo tehay moherep hamo. Mi'i hawyi wẽtup IUTA toi'airo temiit no tehay moherep hamo mekewat Ikarioti sa'yru. Mi'i miit yt naku i ma'ato Iesui ma'at hanuat ne'i topy­hu'at. Mi'i hawyi toran na'yn 12 ok takaria tehay moherep hanuaria wo toi'a­tu­'airo. ");
INSERT INTO mavNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesui ti'a­tu­'airo 12 ok takaria temiit'in topot­po­'o­roria wo miit'in mu'e hamuat hawyi ipot'apyk yity'ok kaipyi yi hot kape tomi­'ai­roria wywo. Mi'i hawyi yt put'ok­to'e yi hot piat i te turan irania'in ipotmu­'eria sem tipuẽti Iesui mekewat yahig note. Mi'i hawyi mekewat yahig wato tote tukup­te'en Iesui kat haria aiko­pepyi aiko­pepyi tõ'ẽ. I'atu kahato miit'in itote toipuẽti yi Iuteu kaipy­wiaria tawa wato Ieru­sarẽi kaipy­wiaria i'ewyte y'y wato yẽpe etiat tawa Tiru kaipy­wiaria tawa Sitãu kaipy­wiaria toi'a­tu­puẽti itote. ");
INSERT INTO mavNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","I'atu kahato miit'in itote Iesui ekatup haria. Tõ'ẽ tõ'ẽ Iesui ehay kapiat te'e­ru­wa­nẽtup teran haype. I'ewyte i'ahu rakaria ta'a­tue­hãite hap ky'ewi haria tõ'ẽ kahato Iesui kape. I'ewyte tõ'ẽ kahato ahiag ipiit piat rakaria. Mi'i haria ahiag i'atu­mo­so­'opot ko'i ma'ato Iesui ti'a­tu­sopo yne ahiag i'atupiit pyi. ");
INSERT INTO mavNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mi'i hawyi yne Itotiaria te'e­ru­wehik teran Iesui ete katu­pono ta'a­tu­ky­'esat ta'a­tu­moe­hãite hap Iesui piat katu­pono Iesui hesaika kahato Tupana esaika hamo miit'in moehãite hamo. Mi'i pote ta'a­tu­ky­'esat kahato Iesui emig ta'a­tupo wuat hap yne i'ahu rakaria. Ta'a­tuemig hawyi meremo i'atue­hãite hap topy­hu'at. ");
INSERT INTO mavNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mi'i hawyi Iesui teha'at topot­mu­'eria kape hawyi toi'a­tu­ky'e kahato hawyi to'e — Tupana mipoi­tyro ko'i eipe uimohey haria yt hekat rakaria i eipe pytkai more­kuaria Tupana etama pe eweikup­te'en wuat'i e'at pe e. — Uheka­tu­wyria uwe uwe Tupana pe to'e — Yt uimi­ky­'esat ok tã i te worokuap e topy'a pe mio tã e haria pe Tupana to'e — Pyno uimi­poi­tyro sese ko'i eipe katu­pono woro­ho­'onug wyti aru eipe wuat'i ywania pore­kuaria wo mesu­wa­rote aikotã Uito areĩne'en Morekuat no atipy pe hap ewy e Tupana tepiat — Worokuap teran e haria uimohey haria. ");
INSERT INTO mavNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mi'i hawyi Iesui teha'at topot­mu­'eria kape hawyi toi'a­tu­ky'e kahato hawyi to'e — Tupana mipoi­tyro ko'i eipe uimohey haria hesy'at rakaria eweikup­te'en pytkai katu­pono uwe uwe to'e Tupana pe — Uhesy'at kahato ekuap hap ky'ewi aikotã hesy'at kahato rakaria tikat mi'u yn hap ewy — Worokat kahato En Tupana e haria pe — Aikotã ienuk kahato haria iwepit kahato haria ewy woro­ho­'onug eiperia i'ok kahato rakaria ewy e Tupana tokuap teran haria pe e. Mi'i hawyi Iesui teha'at topot­mu­'eria kape hawyi toi'a­tu­ky'e kahato hawyi to'e — Tupana mipoi­tyro ko'i eipe uimohey haria e. koitywy eweiwak eipy'a pe ma'ato mi'i hawyi Tupana mimo­wepit kahato rakaria eweikup­te'en wuat'i e'at pe e. Ta'i uwe uwe tuwak topy'a pe irania'in satek pote ho'opot pote mi'i haria pe ti Tupana to'e — Woro­ho­'o­mo­wepit kahato eipe katu­pono karãpe eheha­ky­'e'i hap put'ok'e ehete mi'i hap atu'u yne uipy'a pe wy aikotã irania'in ehaky­'e'i hap ewetu'u yne hap ewy e Tupana mi'iria pe e Iesui topot­mu­'eria pe ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mi'i hawyi Iesui teha'at topot­mu­'eria kape hawyi toi'a­tu­ky'e kahato hawyi to'e — Tupana mipoi­tyro ko'i eipe uimohey haria miit'in miky­ry'i eweikup­te'en mesuwe pytkai e. Uwe uwe wakuap nug motiat miit'in wo'o­ky­ry'i hamo topy­hu'at mi'i haria pe ti Tupana to'e — Pywo pe ti woro­ho­'o­mo­wepit kahato katu­pono atum aru ehepe uhetama atipy piat e Tupana. Pywo pe ti woro­ho­'o­mo­wepit kahato eipe katu­pono aikope Uito areĩne'en Morekuat no hap tote hekat kahato rakaria wo eweikup­te'en wuat'i e'at pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mi'i hawyi Iesui teha'at topot­mu­'eria kape hawyi toi'a­tu­ky'e kahato hawyi to'e — Uwe uwe uhemiit sese wo miit'in miky­ry'i hamo te'e­ro­py­hu'at miit'in misa­ty'i saty'i wo miit'in mimo­weu­ka'i mi'i uhemiit pote mi'i hat pe — Pywo pe ti woro­mo­wepit po'og ni wuat'i kai e Iesui temiit'in me. — Ta'i mi'i tã hap ewy ta'a­tunug sa'a­wy­'i­wuaria uhehay moherep haria ete e Tupana. Mi'i tupono i'atuehay sa'ag yt pywo pe i ehete uhemiit'in eipe pote eiwe­mo­wepit ro eiwe­wehum hawyi waku peso­'e­wei'e iwepit sese rakat peso'e hap ewy katu­pono meiũran ti aru Tupana mimõ­typot kahato haria wo eweikup­te'en atipy pe are e. Ta'i atipy pe — Woro­mõ­typot kahato eipe e Tupana aru uimohey haria potiat miit'in miky­ry'i hap ko'i wo eipe pote e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mi'i hawyi Iesui teha'at yt tomohey haria i pe hawyi to'e tuwak popuo — Ho'o­wasat kahato rakaria eiperia katu­pono — Uruekat kahato hap kaipyi urumo­wepit hap toĩne'en e haria eipe e. Yt naku i pe eiwa­nẽtup hap katu­pono eweikat at ka'ap ewepit hap eheka­re'en sok mesu­wa­rote hap kaipyi e. Ta'i mesu­wa­rotiat ewepit kahato hap yn eweikat e. Pyno emiky­'esat ewy toĩne'en eipo pe aru hap ok tã ma'ato Tupana piat eimo­wepit hap yt eweikat hin i e. Pywo ti rat eimi­puẽti ok tã mesu­wa­rote yn toĩne'en irane eha'up mo ma'ato atipy piat eha'up yt kat i hin i irane eweipuẽti aru e mesu­wa­rotiat yn hekat rakaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mi'i hawyi Iesui teha'at yt tomohey haria i pe hawyi to'e tuwak popuo — Ho'o­wasat kahato rakaria ewy eweikup­te'en mesu­wa­rotiat mi'u yn ewei'a­tukat pote e. — Uru'ok kahato mi'u wo ewei'e eiwo­'ope ma'ato yt ehesy'at hin i eipy'a pe Tupana kuap hap ky'ewi e. — Uru'ok kahato uruto ewei'e ma'ato meiũran aru ehesy'at kahato ra'yn wuat'i e'at pe e. Koitywy eiwepit kahato mesuwe wen ma'ato mi'i irẽ aru paa'e­wei'e ehesy'at sese wuat'i e'at pe hap kaipyi e. Yt naku i kahato aru topy­hu'at ehepe e. Eweiwak kahato wuat'i e'at pe ei'a­rot'i kahato hap aru put'ok'e e Iesui mesu­wa­rotiat mi'u yn kat haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mi'i hawyi Iesui teha'at yt tomohey haria i pe hawyi to'e tuwak popuo — Yt naku i pe aru eweikup­te'en wuat'i e'at pe e. — Uruto po'og irania'in kai ewei'e yn eipy'a pe pote e. Eweikat kahato miit'in kaipyi — Waku po'og en i'atu'e hap. Eiwe­mõ­typot hap yn eweikat irania'in kaipyi e. Mi'i pote ti aru ihaky­'e'i kahato rakaria ewy eweikup­te'en wuat'i e'at pe yt kat i Tupana mõtypot hap eikai pote e. Sa'a­wy­'iwuat Tupana ehay yt pywo rakat i moherep haria heso rakaria ko'i ewy kahato eweikup­te'en are e. Ta'i sa'a­wy'i mi'iria pe — Waku kahato eipe po'og torania kai i'atu'e wen ma'ato — Yt nakuaria i kahato ti eipe e Tupana sa'a­wy'i mi'iria pe e Iesui. Mi'iria ewy kahato aru to'e ehepe are e Iesui — Uruto po'og irania'in kai e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mi'i hawyi Iesui to'e tomohey haria pe. — Uha'y­ru'in uhaki­'yt'in e eiwa­nẽtup to mesup uimienoi koro kape e. Eiwe­waure ka'a kahato ro mesuwat uimienoi koro kape e katu­pono atiky­'esat kahato ewetunug kahato mesuwat ui'e hap — Waku wati­'a­tu­ky'e yne yne ahewa­nĩ­kaptia ko'i e. Waku pe yn waku watu­kup­te'en yt nakuap i nug ahetiat haria wywo e. Waku watunug waku yn yt aiky'e i haria pe e. Waku wati­'a­tu­ky'e kahato yn na'yn yt aiky'e i haria e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Uimohey haria e waku wati­'a­tue­waku yn na'yn ai'a­tu­sa­ty'i saty'i haria e. Mi'i hawyi waku aimo­so­'opot haria upi wahẽtup Tupana kape yn na'yn — Eti'a­tue­ha­kye­ra'at o uruewa­nĩ­kaptia yt aipo­wyro hin i haria waku wato'e Tupana pe e. I'ewyte waku wahẽtup kahato Tupana kaipyi aimo­weu­ka'i haria upi i'atu­poi­tynug ahiag pupiat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Waku wati­'a­tu­ky'e aima'at haria yt naku i watu­'uka aiwu­'uka teran haria wywo e. Karãpeĩ ahewa­nĩkap ahowa­petek hawyi waku wato'e tope — Waku kokai i ro uhowa­petek uhyt mana waku wato'e ahowa­petek hat pe e. Karãpe ahewa­nĩkap aipo­hari ahe'yni ete waku watum ahesokpe ko'i tope ahewa­nĩkap ky'e hap moherep hamo are e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","I'ewyte karãpe wẽtup ok hẽtup kat ahekat kat ahekat ahepe mi'i hat pe waku watum imiky­'esat ewy e. I'ewyte karãpe ahewa­nĩ­kaptia ahero'ok ahekat ko'i mi'i hawyi yt naku i — Eterut i ro emiero'ok uhyt mana wato'e. Yt naku i aipo­hari ahekat etiat hat kaipyi wate­ra­'aipok e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Uimohey haria waku watunug wakuap torania miit'in muo e. Ta'i uiwy­ria'in aikotã irania'in tunug waku hap ehepe aimi­ky­'esat ewy mi'i hap ewy o waku watunug waku hap irania'in me e. Ta'i aikotã wati­ky­'esat irania'in miat wakuap nug ahepiat hap ok tã waku watunug mi'i waku hap ewy i'atuepe e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Uiwy­ria'in e mesu­wa­ro­tiaria tiky'e ta'a­tu­ky'e haria yn ma'ato are'e ehepe wẽtup sehay — Waku wati­'a­tu­ky'e yne miit'in sio aiky'e haria sio yt aiky'e i haria e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma'ato aiky'e haria yn wati­'a­tu­ky'e pote watu­kup­te'en yt Tupana mohey i haria mesu­wa­ro­tiaria ewywuat haria ewy kahato watu­kup­te'en katu­pono mi'iria ti'a­tu­ky'e ta'a­tu­ky'e haria yn e. Mi'i haria mesu­wa­ro­tiaria ewy wato­py­hu'at iro yt po'og i mi'iria kai ahewaku hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","— Ta'i mesu­wa­ro­tiaria yt Tupana mohey haria i timõ'ẽ kahato ta'a­tuekat ta'a­tu­ky'e haria kape yn e. Yt Tupana mohey hin i haria pytkai ta'a­tu­ky'e kahato ta'a­tu­ky'e haria — Etipuru ekat uhyt mana mimi ta'a­tu­ky'e hat to'e pote meremo ta'a­tu­puru ta'a­tukat irania'in miẽtup hap katu­pono te'e­ru­wa­nẽtup — Pyno meũran aru uimõ'ẽ uimi­puru saipepiat po'og toterut i'atu'e te'e­ru­wa­nẽtup hawe. Pyno uimohey haria eipe pote yt atiky­'esat i eweimõ'ẽ irania'in miat turan eweipuru turan mi'iria wanẽtup hap ewywuat eiwa­nẽtup hap wywo e. Atiky­'esat mio tã wato'e aipy'a pe ahekat puru hap ete — Ta'aipok pote waku ma'ato yt ta'aipok i uimi­puru uimi­mõ'ẽ pote i'ewyte waku uhepe waku wato'e kahato aipy'a pe yt kat i ahekat ky'ewi hap wywo e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pyno waku kahato wati­mõ'ẽ ahekat ma'ato yt naku i wati­mõ'ẽ ahekat mesu­wa­ro­tiaria yt Tupana mohey i haria mimõ'ẽ hap ewy e. Waku wati­puru ahekat wuat'i miit'in me yt kat yt naku i aiwa­nẽtup hap wywo i e. Waku wati­puru ahekat wuat'i miit pe ta'a­tu­puru reran mote e. Yt naku i apowa­to'e — Eweterut apuru uimi­puru sio yt yt naku i wato'e. Waku wati­mõ'ẽ aikotã Tupana timõ'ẽ hap ewy are e. Ta'i aiky'e hap wywo yn toi'a­tu­mõ'ẽ ahowawi aiky'e hap wywo. I'aman tutum kahato wuat'i miit'in me i'atuko ko'i moehãite hap sio waku nug haria kape sio yt naku i nug haria kape sio tomohey hap upi sio yt tomohey i hap upi tutum i'aman i'atuko ko'i moehãite hap e. Ta'i Tupana ti'a­tu­ky'e tewa­nĩ­kaptia torania hawyi tutum at i'atuko moehãite hamo yt kat sa'up i wuat'i pe e. Pyno waku Ai'ywot Tupana ewywuat waku wati­mõ'ẽ ahekat are e. Ta'i waku watunug Tupana minug ewy e. Ta'i ahegyi'at kahato hap kaipyi wati­mõ'ẽ pote meiũran yt ta'a­tuerut i aimi­puru i'atuepiat saipepiat ma'ato Tupana yt tiwaure hin i aima'at hap mi'i hawyi ahekat saipepiat hum ahepe aimi­puru. ");
INSERT INTO mavNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Uipot­mu­'eria eipe pote mio tã are'e ehepe — Ewei'a­tu­ky'e ro yne yne ehewa­nĩ­kaptia are e. Waku yn no ewetunug ehewa­nĩ­kaptia pe hãpyk takat yn i'atu­ky'e hap upi e. Ehekat ko'i kape yt eiwa­nẽtup at ka'ap tei'o — Kat ko'i kat ko'i aru uimi­puru saipepiat uhekat ta'atuium yt ewei'e tei'o eipy'a pe e. Yt eiwa­nẽtup tei'o eimi­puru porap hap kape are. Mi'i tã eweipuẽti eimi­puru saipepiat Tupana kaipyi po'og po'og eimi­puru kupitu kai e. Mi'i tã ui'e hap ewy ewetunug pote ti aru Tupana sa'y­ru'in Tupana saki­'yt'in eipe i'atu'e mi'iria ehepiat pe e. — Tupana mẽpyt'in eipe i'atu'e ehepiat pe e. Ta'i Ai'ywot atipy piat minug ewywuat nug haria eipe i'atu'e ehepiat katu­pono Tupana iwese kahato yt iwese kahato i rakaria ete hap ewy waku aito iwese kahato rakaria wo wato­py­hu'at wuat'i miit'in ete are e. Tupana tuwe­mo­sa­ty'i kahato topy'a pe tewa­nĩ­kaptia satek hap e'at pe e. Waku watu­we­mo­sa­ty'i ahewa­nĩkap satek hap e'at pe e. Waku wati­'a­tu­po­wyro mi'iria hatek hap upi e. Pyno waku Ai'ywot Koro miit'in ky'e hat ewy watoĩ­ne'en wuat'i miit'in ky'e hap wywo sio wakuaria sio miit yt nakuaria i are e. Wakuat yn ewetunug o wuat'i miit'in me Ai'ywot Koro minug hap ewywuat e Iesui uruepe ahepe topot­mu­'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mi'i hawyi po'og Iesui to'e ahepe — Uiwy­ria'in yt naku i wati­'a­tu­mohit miit'in — Mekewat miit yt kan hamo i yt naku i wato'e irania'in me are e. Yt naku i wato'e aiwa­nẽtup hawe — Uito po'og mi'i miit kai e. I'ewyte karãpe miit'in inug sa'ag ahetiat hawyi yt naku i wahenoi irania'in me iminug sa'ag ahetiat e. Miit'in minug sa'ag ahetiat wahenoi irania'in me wẽtup ok minug sa'ag ko'i pote ti aru Tupana i'ewyte henoi eiwat eiminug yt naku i hap ko'i wuat'i miit'in ehamo aru e. Ma'ato waku waure wo watoĩ­ne'en irania'in miat aima'at hap kai. Mi'i hap ete eweikup­te'en waure wo pote Tupana i'ewyte eiminug yt naku i hap ko'i kai waure wo toĩne'en are e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Waku hegyi'at kahato rakaria wo watu­kup­te'en uheka­tu­wyria are. Wati­mõ'ẽ ahekat irania'in me pote ti aru i'ewyte Tupana timõ'ẽ kahato tekat ahowawi aikotã ahegyi'at hap ok tã tutum ahepe ma'ato ahegyi'at hap wywo watum kurin kurin irania'in me pote mi'i hap ok tã ne aru Tupana tum ahepe e. Ma'ato ahegyi'at hap iwato kahato watum mote Tupana i'ewyte hum iwato kahato ahepe e. I'ewyte aimiium kurin yt ahegyi'at i pote i'ewyte Tupana tum kurin ahepe ahegyi'at hap ok tã aru tutum ahowawi e. Waho'oium kurin pote Tupana ho'oium kurin ahowawi e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mi'i hawyi po'og Iesui henoi hã'ãkap wuo — Ta'i e ahetama puo yt ihapytig i rakaria ikat kahato ta'a­tu­po­re­reko hat e. Mi'i hawyi wẽtup ok tuereto yt ipuẽti i topo­re­reko hanuat hawyi to'o­'e­wywuat toipuẽti topo­re­reko hamo yt ihapytig i rakat re e. Mi'i hawyi hewo yi hot pe to'o­'ewy e. Mi'i hap ewy ti aimu'e haria yt Tupana kuap i rakaria pote aimu'e hap Tupana moherep hap yt heremo hin i katu­pono yt iha i rakaria ewy tukup­te'en. — Mi'i ti mu'ap Tupana kape i'atu'e pytkai yt mu'ap hin i. Mi'i pote i'atu­mi­mu­'eria i'ewyte ho'o­wasat rakaria ewy e. Yt toikuap i kahato mu'ap hawyi yt toimo­herep kuap i topot­mu­'eria pe yt ihapytig i rakaria ewywuaria pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ma'ato eiwe­mu'e kahato Eimu'e Hat mienoi ete uhehay ete hawyi Eimu'e Hat mikuap hap ok tã ewehenoi kuap are e. Ma'ato wo'o­mu'e hat yt ihapytig i rakat ewywuat pote i'ewyte wo'o­mu'e haria yt ihapytig i rakaria ewywuaria tukup­te'en ta'a­tu­mu'e kahato pytkai. Mi'i hawyi ta'a­tu­mu'e hat ewy hewo yi hot pe to'o­'ewy e. Pyno areĩne'en Eimu'e Haria Akag wo e Iesui. Atiky­'esat kahato yne eiperia ewetunug torania ui'e hap ok tã e. Ui'e hap ewy ewetunug pote Uito ewywuat eweikup­te'en miit'in mu'e hamo e. Yt naku i ewei'e eipy'a pe — Atikuap po'og Uimu'e hat Iesui kai mi'i pote waku wẽtup sehay ahenoi irania'in me uiwa­nẽtup hap ewy yt uimu'e hap sehay ewy yt naku i ewei'e. Uipot­mu­'eria sese eipe pote uimi­mu'e hap ewy kahato aru ewei'a­tu­mu'e e. Mi'i hawyi hãpyk sese uipo­'o­roria wo miit'in mu'e hamo eweikup­te'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Tukup­te'en irania'in uimi­mu­'eria te'e­ra­ha'at kahato irania'in kape sio ta'a­tu­'a­parap sio yt hap kuap hamo e. I'atueha irania'in kape yn yt naku i kat hamo e. Yt te'e­ra­ha'at hin i ta'a­tu­minug ta'a­tuwat kape sio waku sio yt ta'a­tu­minug kuap hamo e. Mi'iria ta'a­tu­mohey teran irania'in yt naku i nug hap etiat haype e. Yt karãpe i paa'i­'a­tu'e ta'a­tu­minug sa'ag hap ko'i ete e. Yt eweikup­te'en nei'o mi'iria ewy e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","— Uito po'og irania'in kai e haria ewy eweikup­te'en mote yt ihapytig i rakaria ewy te eweikup­te'en katu­pono — Hehu iwato'in nakat eheha pe hap ewy toĩne'en aikotã hu yp toĩne'en eheha pe hap ewy e. — Atihep teran mekewat eha piat hu hit ewei'e ma'ato yt etunug kuap i kat pote hu yp ewywuat toĩne'en eha pe pote e. Pyno waku etihep hu yp eha pyi hawyi pote etihep kuap kurin nakat hu irania'in eha pyi e. Mi'i hap ewy eweikup­te'en eweikat irania'in minug sa'ag mote e. Waku ewei'e eipy'a pe — Atoiat teran uiminug sa'ag e. Ma'ato yt naku i ewei'e — Uito waku ma'ato irania'in yt naku i nug haria wo yt ewei'e tei'o e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mi'i hawyi Iesui to'e ahepe — Pyno uiwy­ria'in ahenoi teran ehepe wẽtup uhehay iã'ãkap e. Pyno aito wato­py­hu'at kat kat yp ewywuat watoĩ­ne'en iywa he rakat yp ewy e. Ta'i ai'ywa he rakat ewywuat aito pote iwese kahato rakaria ewy watoĩ­ne'en e. Ma'ato ai'ywa nop takat pote yt kan hamo watoĩ­ne'en miit'in ekyi Tupana kape are. Yt karãpe i ywa nop takat watikoi are. Ta'i watu'u he kahato rakat hawyi — Waku mesuwat iã'ỹi aimikoi wo wato'e e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pyno watikuap mikoi yp waku sio yt naku i hap i'ywa he sio nop hap ete. — He pote he yt pote yt wato'e. Ma'ato he nakat kape wata­'aipok aimi'u wuat hep hamo. Ma'ato nop takat kape yt karãpe i wata­'aipok aimi'u wuat hep hamo e. Ihep hawyi watu'u hap ky'ewi ma'ato nop takat pote yt karãpe i wata­'aipok i'u hamo e. Mi'i hap ewy kahato aiminug waku hap irania'in me te'e­ra­'aipok ahowawi aiwese hap upi ma'ato yt naku i nug hap ahehay pote yt te'e­ra­'aipok hin i ahowawi Tupana ehay kuap hamo e Iesui ahepe. Pyno watikuap mikoi yp waku sio yt naku i hap i'ywa he sio nop hap ete. I'ewyte Yt karãpe i wati­puẽti Wiku yp ywa he rakat ewywuat hu yp ete ne'i e. Ta'i ahetama Wiku yp ywa he rakat wati­puẽti Wiku yp ete yn e. Yt karãpe i wati­puẽti hu yp kape Wiku ywa he rakat e. Mi'i hap ewy yt karãpe i yt he i rakat kape watuwat Tupana ehay he rakat kat hamo are e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pyno uiwy­ria'in aito waku rakaria watu­kup­te'en mote mekewat Wiku yp he rakat ewy watu­kup­te'en e. Hewo hewo waku mug hap yn mote waku kahato rakat no watoĩ­ne'en. Iwese kahato rakaria wo watu­kup­te'en e. Pyno waku hap kape yn watu­wa­nẽtup aipy'a pe mi'i hawyi ahehay kaipyi tuwẽtem waku rakat yn e. Ma'ato yt naku i watu­wa­nẽtup pote yt naku i hap tuwẽtem ahehay kaipyi e. Pyno aiwa­nẽtup hap aipy'a piat toĩne'en ahekat hap ewy e. Waku rakat aiwa­nẽtup hap pote toĩne'en waku rakat ewy aheĩne'en hap e. Ma'ato yt pote yt naku i nug hano watoĩ­ne'en e Iesui ahepe. Pyno aiwa­nẽtup hap ahesokpe eiam ewy toĩne'en e. Pyno ahesokpe waku rakat watopag aheuru pe pote pyno waku rakat ahesokpe watihep kuap itotepyi are. Ma'ato yt naku i rakat ahesokpe watopag ahesokpe eiam me pote miit'in mipun ewywuat watihep aheuru pyi are e. Mi'i hap ewy kahato aipy'a pe watopag waku e hap pote waku e hap ewywuat tuwẽtem aru aiwẽ pyi e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Uipot­mu­'eria kat pote som ewei'e uhepe — Urumu'e hat ekag koro En Mehĩ Urumu'e hat akag koro Mimi ewei'e uhepe at ka'ap ma'ato mi'i pytkai yt ewetunug hin i yne yne uhepiat einãpin hap ko'i e. Uruka­'iwat sese En ewei'e hawyi yt uimi­ky­'esat ewy hin i ewetunug pytkai e. Yt naku i eimi­ky­'esat ko'i yn ewetunug hawyi uimi­ky­'esat pun haria eweikup­te'en are e ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pyno uwe uwe tut uhowawi mi'i hawyi uhehay toikuap tonãpin hap ko'i toikuap mi'i hawyi tutunug yne tonãpin hap uhepiat ok tã ewy mi'i hat topy­hu'at aikotã getap nug hat ikahu waku kahato rakat nug hat ewy are e. ");
INSERT INTO mavNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ta'i uipot­mu­'eria ewetunug uhepiat einãpin hap ewy pote eweikup­te'en aru iwe'eg kahato rakaria ewywuat aikotã getap iheg nakat nug hat ewy eweikup­te'en e. Ta'i sa'a­wy'i toikat kuru­su'yp iheg nakat to'yat eãkukag wo e. Mi'i hawyi toi'a­tutuk iãkukag yi pya pe hap ewy e. Mi'i yat toĩne'en iheg nakat kahato ikahu kahato hap ewy. I'yat iminug aikotã ai'yat yi heg note ewy iheg hap ewy. Mi'i turan ywytu uato kahato put'ok'e wen ma'ato tominug to'yat iheg kahato rakat yt ta'at hin i hawyi ywytu uato yt timoma kuap i katu­pono yi heg nakat tote yi pan me toĩne'en kahato pote yt ta'at hin i ywytu uato hap e'at pe e. Mi'i hap ewy kahato uimienoi ko'i nug haria tukup­te'en e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma'ato uwe uwe tuwa­nẽtup uhehay kape tonãpin hap kape porap'i mi'i hawyi tuwa­nẽtup tuwepe — Yt atunug neran i Iesui piat uinãpin hap e mi'i e hat wanẽtup hat aikotã getap nug yt iheg miat i rakat ewy aikotã aria'yp nupi'a misekuap kahato wuat ne'i getap nug hat ewy. I'ewyte yt ika'a pya pe i toipan hat ewy e. Mi'i turan put'ok'e ywytu uato hawyi ywytu uato ti'y­pyhep hap ewy e. Mi'i hawyi i'yat yt kat i ta'at ra'yn hawyi e. Mi'i hap ewy topy­hu'at uhepiat tonãpin hap uhehay upi yt topy­hu'at i rakat e Iesui ahepe mekewat yity'ok totepyi. ");
INSERT INTO mavNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tohenoi yne ra'yn hawyi toto ra'yn Iesui tawa Kawa­na'ũ Kape. ");
INSERT INTO mavNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mi'i turan toĩne'en itote wẽtup ok sura­ra'in sem akag koro eropat hat. Mi'i miit surara akag koro miky'e kahato. Mi'i miit waku rakat i'ahu kahato. Iku'uro irane poity'i hap ewy. ");
INSERT INTO mavNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mi'i turan surara sem akag tikuap Iesui ieĩne'en hap tetawa Kawa­na'ũ piat. Mi'i hawyi toipo­'oro sehay meremo Iesui kape Iuteu ywania akagnia upi — Uheropat hat uimi­ky'e kahato iku'uro irane Uhyt mi'i pote meremo eriot uhowawi uheropat hat moehãite hamo e tohẽtup toipo­'oro tehay. ");
INSERT INTO mavNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mi'i hawyi nagnia put'ok­'i­'a­tu'e Iesui ete hawyi te'e­ro'e tope — Uhyt waku eriot urupo­'oro hat surara sem akag eropat hat moehãite hamo i'atu'e. I'ahu kahato hawyi epiat imoehãite hap surara akag tiky­'esat kahato i'atu'e. I'ewyte uruto wy uruiky­'esat etimoe­hãite surara akag emiit katu­pono ai'y­wania powyro kahato hat mekewat surara akag i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ta'i mi'i surara akag ni ai'y­wania Iuteu ywania powyro kahato hat i'atu'e. Mi'i ti wẽtup ywania kaipywiat pytkai aiky'e kahato i'atu'e. Ga'atpo tutum sa'up iwato kahato Ahetu­pana mõtypot yat nug hamo i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mi'i Iesui tikuap hawyi toto ra'yn nagnia wywo surara akag yat kape hemiit i'ahu rakat kape. Ma'ato tuwat turan surara koro yat kape turan surara koro tipo­'oro sehay Iesui ewawi towy­ria'in upi — Yt ereke tei'o ui'yat pe katu­pono uhewaku hap yt put'ok'e i ereke uhowawiat hamo katu­pono En ni po'og po'og Morekuat no uikai e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mesup atipo­'oro uhemiit ewawi uhehay moherep epiat hamo katu­pono yt areto kuap i ewawi uhewaku hap yt put'ok'e i uhehay ewawi hamo Mehĩ e. En po'og uikai pote e. Pyno waku ehay etipo­'oro uhemiit kape — Woro­moe­hãinte ere o itote hawyi uhemiit mesuwe emimoe­hãite meremo topy­hu'at hap atimohey ra'yn e surara koro tuwehay po'oro Iesui kape. ");
INSERT INTO mavNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Uito ti areĩne'en surara akag wo e. Ta'i En ni uito ewy e. Ati'a­tu­po­'oro kuap kahato uhesu­rara sem ko'i aikope aikope uimi­ky­'esat ewy e. I'ewyte ui'akag ko'i more­kuaria po'og uikai uipo­'oro hap atikuap ta'yn e. I'ewyte 100 ok surara tukup­te'en uhemiit no mesuwe ui'yat pe e. Pyno wẽtup ok surara pe uhemiit pe — Ereto ro tu'uka hamo are hawyi meremo toto ui'e hap nug hamo e. Eriot i ro are'e pote meremo te tut uhowawi e. Etunug no are'e uheropat hat uhesu­rara pe hawyi meremo tutunug uimi­ky­'esat ewy e surara akag Iesui pe tehay po'oro. Pyno atikuap ta'yn En uito ewy ereĩne'en Uru'akag wo hap e. Pyno erehay­po­'oro meikowo e'e hap hawyi meremo uheropat hat uimi­ky'e i'ahu kahato rakat waku ra'yn topy­hu'at e'e hap ok tã e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesui tikuap Surara akag ehay hawyi tuwa­nẽtup kahato ihay kape hawyi to'e tewat­'y­muaria õ'ẽ haria pe — Ta'i eiperia ui'y­wania ko'i Isareu ywania eweikup­te'en e. Eiperia eweikup­te'en na'yn uimohey kahato haria wen ma'ato ti mesup te ti yt atipuẽti i eipy­'a­setpe miit'in uimohey haria mesuwat surara akag piat uimohey hap ewywuat ko'i e. Yt ai'y­wania i wen ma'ato uimohey kahato e Iesui to'y­wania pe tewat­'y­muaria õ'ẽ haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mi'i hawyi sura­ra'in akag ehay erut haria te'e­ra­'aipok i ra'yn surara akag yat kape. Put'ok­ta­'a­tu'e turan mekewat surara koro eropat hat imiky'e ihãite kahato ra'yn hap ta'a­tu­puẽti. ");
INSERT INTO mavNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mi'i hawyi Iesui toto ra'yn tawa Naĩ kape topot­mu­'eria wywo. I'ewyte miit'in typy'i kahato rakaria tuwat hupi. ");
INSERT INTO mavNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yt pya hin i tawa Naĩ pyhyp hap e'oken­'ypy wato kai turan toipuẽti wo'osyp hanuaria mu'ap upi wẽtup ok ihainia iku'uro rakat ta'a­tue­roto tawa pyi hyp hamo. Iku'uro rakat ty toĩne'en itote wẽtup ok takat imẽpyt iku'uro rakat wywo. Ity ti hiwu toĩne'en. Imẽpyt wẽtup yn nakat iku'uro pote yt kat i ra'yn ipowyro hamuat. Mekewat hiwu yatype tukup­te'en typy'i kahato tawa kaipy­wiaria iku'uro rakat hyp hanuaria. Iku'uro rakat ty upi tuwat mu'ap upi. ");
INSERT INTO mavNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mi'i hawyi Iesui teha'at ity kape hiwu ra'yn hap kape hawyi toto­mo­haty kahato topy'a pe hawyi toiky'e kahato hawyi to'e hiwu kape — Mana e yt erewak tei'o e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mio tã e Iesui hawyi toto ra'yn iku'uro rakat ewawi hawyi tuwe­ponug iku'uro rakat eiam note hereto turan. Mi'i hawyi meremo hereto haria te'e­ro­py­hu'at mu'ap tote. Mi'i hawyi to'e ra'yn iku'uro rakat pe — Kurum e'ãpe­'ok'am no e Iesui i'okpuk kape. ");
INSERT INTO mavNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mi'i hawyi iku'uro rakat tuwẽtem gu'uro pyi hawyi tuwe­'ã­pe­'ok'am hawyi ihay i ra'yn. Mi'i hawyi Iesui tioto ra'yn ity kape mekewat hiwu kape. Ihãite i ra'yn tuwẽtem na'yn toku­'uro sese hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mi'i pote miit'in itotiaria te'e­ru­wa­nẽtup kahato hawyi i'atu­wepit kahato. Mi'i hawyi te'e­ru­wehum kahato Tupana kape — Waku kahato En Tupana i'atu'e i'atuehay wo. Mi'i turan te'e­ro'e — Wakuat kahato En Tupana wakuat kahato En Tupana. Mesup ta'yn Ehay Moherep Hat toĩne'en mesuwe urupy­'a­setpe i'atu'e. Put'ok'e Emiit Urueha­kye­ra'at Hanuat i'atu'e Iesui piat Tupana kape mekewat iku'uro rakat Iesui timoieĩ­ne'en i ra'yn hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mi'i hawyi ta'a­tu­henoi kahato Iesui minug yt uwe i mesu­wa­ro­tiaria minug kuap ewywuat i'atu'e wuat'i tawa pe hawyi yne yi Iuteu piaria tikuap ta'yn — Iesui minug iwato hap. I'ewyte irania'in tawa puaria yi Iuteu hyẽpe upiaria ikuap yne ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mi'i hawyi ahet'ok hat Iuwãu potmu­'eria henoi ra'yn Iuwãu me Iesui minug wakuap yt uwe i mesu­wa­ro­tiaria minug kuap ewywuat ko'i etiat. ");
INSERT INTO mavNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mi'i hawyi Iuwãu tikuap hawyi toikaykay typy ok topot­mu­'eria tuwe­wawi topyhik hap kape hawyi to'e — Uhyt'i'in eweiwat ro Iesui kape apo'e­wei'e hamo e. Mio tã ewei'e o tope uhehay ewehenoi — En apo Urumie­katup Tupana Mipo­'oro Urueha­kye­ra'at Hanuat ra'yn sio apo waku wẽtup ok uruhe­katup ewei'e o Iesui pe e Iuwãu topot­po­'o­roria typy ok pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mi'i hawyi Iuwãu mipo­'oro ko'i tuwat ra'yn Iesui kape. Put'ok­ta­'a­tu'e Iesui ete hawyi apo'i­'a­tu'e — Wo'o­mu'e hat i'atu'e Iuwãu wo'o­set'ok hat wyti urupo­'oro ewawi i'atu'e. Ahet'ok hat tikuap teran epiat towesat hap — En apo urumie­katup Tupana Mipo­'oro Wuat'i Porekuat nuat sio apo wẽtup ok te uruhe­katup urueha­kye­ra'at hamo i'atu'e Iuwãu potpo­'o­roria Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mi'i hawyi put'ok­'i­'a­tu'e Iuwãu potpo­'o­roria turan Iesui ti'a­tu­moe­hãite kahato i'ahu rakaria. Wuat'i i'atu­'ahu rakaria toi'a­tu­moe­hãite. Mi'i hawyi Iuwãu mipo­'o­roria teha'at kahato Iesui minug wakuap hap ko'i kape. Ahiag ipiit piat rakaria toi'a­tu­sopo kahato. Yt iha pytig i rakaria toi'a­tu­moe­ha­pytig na'yn put'ok­'i­'a­tu'e turan. ");
INSERT INTO mavNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mi'i tutunug turan Iesui to'e apo'e haria pe — Pyno ewei'aipok i ro Iuwãu kape hawyi ewehenoi ro yne aikotã aikotã ei'a­kasa hap ko'i yne eimikuap ko'i ewehenoi tope e i'atuepe. Yt ihapytig i rakaria ti toi'a­tu­moe­ha­pytig na'yn ewei'e ro Iuwãu me e. Mi'i hawyi yt hewyry kuap i rakaria toi'a­tu­moe­wyry ta'yn ewei'e ro e. I'ewyte hepihi pihi rakaria toi'a­tu­mo­kã'ã ra'yn i'atue­pihi ewei'e ro e. Hewaure rakaria i'atue­waure hot'ok'e ra'yn ewei'e ro ahet'ok hat Iuwãu me e. I'ewyte ti iku'uro sese rakaria toi'a­tu­mo­hymut i ra'yn i'atu­ku­'uro sese hawyi ewei'e ro e. Mi'i hawyi yt hekat i rakaria toi'a­tu­mu'e kahato ra'yn Tupana ehay wakuano yt ha'up ete i ewei'e ro aiwy Iuwãu me e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mi'i hawyi wẽtup uhehay ewei'e ro Iuwãu me — Pywo ti rat waku kahato tukup­te'en uimohey kahato rakaria uhepiat pywo yn e haria — Woro­mohey uiku­'uro hap kape e haria i'atu­wepit kahato tukup­te'en ma'ato irania'in tuwe­mõti kahato uipupi yt naku i pe tukup­te'en ewei'e o aimu'e hat sa'a­wy­'iwuat Iuwãu me e Iesui apo'e haria pe Iuwãu potpo­'o­roria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mi'i hawyi Iuwãu potmu­'eria tuwat ta'a­tu­pot­po­'oro hat kape Iesui miwesat moherep hamo Iuwãu kape. Mi'i hawyi Iesui ti'a­tu­mu'e kahato itotiaria yne ta'a­tu­het'ok hat Iuwãu etiat — Sa'a­wy'i te kat hamo kahu eweiwat yahig kape e. Ta'i aimu'e hat wakuat Iuwãu ehay wakuat kuap hamo watuwat sa'a­wy'i yahig kape e Iesui. Ta'i Iuwãu aimu'e kahato Tupana ehay sese wo e. Upip wasera upi ta'at turan kowo'i kowo'i tuwat yt hãpyk hin i ta'at e. Aimu'e hat Iuwãu yt upip wasera upi ewywuat hin i e. Hãpyk kahato aimu'e e. Upip wasera upi yt tikuap i aikotã waku hawyi kowo'i kowo'i toto e. Ma'ato Iuwãu yt mi'i hap ewywuat hin i e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pyno apo kat som yahig note ewei'a­kasa sa'a­wy'i. Kat kapiat ei'a­kasa hamo som eweiwat Iuwãu ewawi e. Miit esokpe ikahuria rakat ewywuat kapiat apo ewei'a­kasa hamo eweiwat yahig kape sa'a­wy'i. Yt hesokpe ikahuria rakat hin i Iuwãu e. Ta'i hekat kahato rakaria esokpe ikahu kahato ma'ato Iuwãu esokpe aihũ Kameru sap kawiat. Hekat rakaria yt tukup­te'en i yahig note ma'ato more­kuaria yat pe yn tukup­te'en ikahuria puaria ma'ato Iuwãu yt mi'iria ewywuat hin i toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","— Pyno sa'a­wy'i kat som eweikat mekewat yahig note. Kan hamo ten eweiwat mekewat yahig at hakup hap kape sa'a­wy'i e. Ta'i Tupana ehay enoi hat koro akasa hamo eweiwat yahig kape sa'a­wy'i are. Pywo ti rat Tupana Mipo­'oro ut hap moherep hat kape eweiwat e. Mi'i hawyi eimikat eweipuẽti itote e. Iuwãu ni po'og wuat'i Tupana ehay moherep haria kai are. Tupana ehay moherep hat koro ahet'ok hat are e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta'i waku kahato ahet'ok hat Iuwãu e Iesui. Sa'a­wy'i sese Tupana ehay enoi hat pot Isaia henoi kahato Iuwãu etiat e'yianmete tomiwan me. Uiwy­ria'in e mio tã to'e Tupana sa'a­wy'i sese Tosa­'yru pe. — Uha'yru e sa'a­wy'i e'yianme wẽtup ok miit atipo­'oro teran e'ut hap moherep hamuat wuat'i miit'in miat hamo e Tosa­'yru pe e. Mi'i hat yahig note aru toi'a­tu­mu'e kahato Uha'yru e'ut hap mohãpyk hanuat atipo­'oro e Tupana Isaia miwan me sa'a­wy'i Iuwãu etiat. Pyno mi'i ti Isaia e hap ewy eweipuẽti ra'yn yahig note e. Ta'i Tupana Sa'yru ut hap moherep e'yianmiat hat henoi tehay wuat hat ti eweipuẽti ra'yn ahet'ok hat Iuwãu e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","— Pyno are'e teran aikotã are'e sa'a­wy'i ehepe hap ewy e Iesui. Mio tã are'e sa'a­wy'i — Mesup yt uwe i miit'in muo mesu­wa­rotiat po'og Iuwãu kai. Iuwãu po'og po'og yne hary­poria mẽpyt kai e. Iuwãu po'og torania sa'a­wy­'iwuat Tupana ehay moherep haria kai e. Ma'ato pywo ti rat aikope aikope toĩne'en wẽtup uipot­po­'oro uhehay moherep hat mi'i miit ti po'og po'og Iuwãu kai toĩne'en Tupana wanẽtup hawe e. Ta'i ahet'ok hat Iuwãu wakuat kahato wen ma'ato yne Tupana miky­'esat nug haria uhehay moherep haria po'og ahet'ok hat Iuwãu kai e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sa'a­wy'i tuwat ra'yn miit'in Iuwãu kape Iuwãu ehay kapiat te'e­ru­wa­nẽtup hamo e. Wo'o­pyhyp haria miit'in ma'at haria ko'i tuwat e. Imienoi ta'a­tukuap hawyi — Pywo i'atu'e. Hãpyk kahato Tupana i'atu'e. Mi'i hawyi te'e­ra­'aipok ta'yn Tupana kape imiky­'esat nug hamo e. Mi'i hawyi ta'a­tuẽtup ta'yn Iuwãu miat ta'a­tu­set'ok hap katu­pono — Tupana mohey haria urutoria e hap moherep hamo miit'in ehamo. ");
INSERT INTO mavNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma'ato irania'in nagnia ehay enoi haria i'ewyte miwan enoi haria yt Iuwãu mohey hin i e Iesui. Mi'iria ti yt inug neran i Tupana miky­'esat ewy e. Mi'i pote yt ta'a­tu­ky­'esat i Iuwãu piat ta'a­tu­set'ok hap e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Are pãi yt naku i mi'iria katu­pono — Uruto po'og waku wuat'i miit'in kai i'atu'e ta'a­tu­py'a pe. Uruto po'og Iuwãu kai i'atu'e hawyi Iuwãu mimo­herep uhepiat sehay ta'a­tupun ne'i e Iesui Tupana mohey haria mu'e haria akag ko'i piat. ");
INSERT INTO mavNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pyno mesu­wa­ro­tiaria — Uruto po'og e haria yt uimohey i teran tukup­te'en aikotã hira­karia iha'y­wywi rakaria ewywuaria are e. Aikotã hira­karia te'e­ro'e to'ope — To'iro waku watu­wepy aiwo­'o­mo­wepit hamo i'atu'e to'o­ma­hara hap mywo ma'ato irania'in hira­karia — Yt naku i aiwo­'o­mo­wepit hap mesup i'atu'e. Yt urutuwat teran i aiwo­'o­ma­hara hap kape watu­wepy hap kape i'atu'e irania'in hira­karia pe e. Yt urutunug neran i wepy hap aiwepit hap upi i'atu'e. — Pyno waku aiwo­'o­hayka hap watunug miit'in syp haria ewywuat aiwo­'o­mi­ky­ry'i hap i'atu'e irania'in hira­karia pe wen ma'ato — Yt uruiky­'esat i aiwak hap ne'i aiwo­'o­mi­kyry hap ne'i i'atu'e to'ope to'ope hira­karia mi'i hap ewy kahato eweikup­te'en — Uruto po'og tora­nia'in kai e haria pe e Iesui. Yt ta'a­tu­ky­'esat i uimienoi i'ewyte yt ta'a­tu­ky­'esat i ahet'ok hat Iuwãu mienoi. Kat ko'i kat ko'i are'e hawyi — Yt uruimohey ehay i'atu'e uhepe. I'ewyte kat ko'i kat kat ko'i ahet'ok Iuwãu henoi — Yt uruimohey i ehay i'atu'e wy e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pyno eipe ti irania'in hira­karia ewywuaria eweipy­hu'at katu­pono sa'a­wy'i Iuwãu miit'in set'ok hat tuwe­mo­sy'at at ka'ap kahato eimi­ky­'esat ewy tutunug yne e. Mi'u i'ewyte yt tutu'u i tuwe­mo­sy'at Tupana wywo ihay hamuat eimi­ky­'esat ewy tutunug e. I'ewyte mahy mekewat Uwa hy pot'i kawiat yt tutu'u i. Ta'i Iuwãu eimi­ky­'esat ewy tenuk wen mi'i pytkai eiperia — Ahiag ipiit piat rakat Iuwãu ewei'e wuat'i miit'in me e. Yt naku i mio tã ei'e hap e Iesui tomohit haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mi'i hawyi i'ewyte uimohit kahato eipe ehehay wo katu­pono atu'u yne mi'u i'ewyte Uwa hy atu'u e Iesui. — Yt naku En ewei'e uhepe. — Ta'i erenuk kahato yne mi'u ete ewei'e uhepe. I'ewyte En ni mahy u hat mekewat uwa hy pot'i u kahato hat ewei'e uhepe e. — En ni yt naku i katu­pono imopẽ'ã rakat ereĩne'en i'ewyte wuat'i mi'u u hat ereĩne'en yt uruto ewy i ewei'e sa'ag uhepe e Iesui tewa­nĩ­kaptia pe. Eiperia ti Iuwãu ehay wakuat pun haria i'ewyte uhehay wakuat kahato pun haria uruehay Tupana mipo­'oro sese wen. Yt naku i kahato ewetunug e Iesui to'y­wania pe — Uruto po'og ekai e haria pe. — En ni yt naku i ewei'e uhepe. En ni yt eremo­sy'at hin i hawyi erenuk yn at ka'ap imopẽ'ã rakat ewy rat ewei'e uhepe e. Ta'i En ni urupyhyp haria uruewa­nĩ­kaptia esura­ra'in ky'e hat ewei'e uhepe e. I'ewyte yne yt nakuaria i wy'ok wo ereĩne'en ewei'e uhepe e. Mi'i pote yt kat hamo i En ewei'e uhepe. Pywo pe ti yt uimohey haria uhehay pun haria eweikup­te'en katu­pono aikotã hira­karia i'atu­wo­'o­ky­ry'i hap potiat ewy eweipy­hu'at e Iesui tewa­nĩ­kaptia pe. Yt eweikuap i kat som eweiky­'esat. Iuwãu mienoi yt eweiky­'esat i pote i'ewyte uimienoi kape yt eweiwa­nẽtup hin i e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Irania'in uimohey haria pe — Yt naku i nug haria eipe ewei'e ma'ato mi'i pytkai mi'iria Tupana ehay kapiat wanẽtup kahato haria. Eipe urumohit haria eweikup­te'en e. Eweha'at ro uimohey haria sese kape hawyi meremo eweikuap aru Tupana mienoi ky'esat kahato rakaria mi'iria tukup­te'en hap ma'ato eipe yt eweiky­'est hin i e. Eimienoi wãi'e hap ko'i ky'esat haria yn eipe are e Iesui to'y­wania yt tomohey hin i haria pe mekewat wãi'e hap moherep haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mi'i hawyi wẽtup ok nagnia wãi'e hap moherep hat to'e Iesui pe — Uhyt to'iro uhupi e. Waku watuwat ui'yat kape enuk hamo e. Mi'i hawyi Iesui toto ra'yn i'yat kape tenuk hamo mekewat — Uruto po'og waku e haria sem wywo tenuk ta'yn hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mi'i hawyi toĩne'en itote mekewat tawa pe wẽtup ok hary­poria yt iwe'eg i rakat wuat'i ihainia'in wywo ieĩne'en hat. Mi'i toikuap ta'yn Iesui toĩne'en hap hawyi toto ra'yn nagnia wãi'e hap moherep hat yat kape. Mohag hy ikamhig se rakat heiam nu Arapatu kawiat ikahu rakat wywo sa'up iwato kahato rakat wywo toto. ");
INSERT INTO mavNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Put'ok­to'e nagnia ehay wãi'e hap moherep hat yat pe hawyi toipuẽti Iesui porog me tupe tote tenuk yparakai yt itypore i rakat ete i'atueko ewy tenuk hamo. Mi'i hawyi mekewat hary­poria yt iwe'eg i rakat toto Iesui kape hawyi tuwe­pỹ­'ã­tutuk ipy yatypiat kape. Mi'i hawyi tuwak ta'yn haty kahato topy'a pe pote paa'e kahato tominug sa'ag ko'i po'ypyi. Mi'i hawyi hom'e teha hy Iesui py ok pe ete hawyi toitip ta'yn ta'asap mo teha hy ipy okpe ete. Mi'i hawyi toi'ã­pysig ipy hawyi mekewat nu wakuat mohag hy eiam toi'okpik hawyi mekewat mohag hy hekat rakat toi'okpun yne Iesui py okpe ete. Mi'i hawyi toitip ta'yn ta'asap mo mohag hy imõtypot haype iky'e kahato hap moherep hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mi'i hawyi mekewat getap ka'iwat wãi'e hap kuap hat ta'a­kasa hary­poria yt iwe'eg i rakat Iesui py ete hawyi mio tã to'e tuwepe tuwa­nẽtup hawe — Are pãi Iesui yt Tupana Mipo­'oro Tehay Moherep hat hin i e katu­pono yt toikuap i ra'yn meiẽ hary­poria hewaire hewaire kahato rakat e tuwepe tuwa­nẽtup hawe yt naku i e. Iesui Tupana Wanẽtup Kuap hat pote meremo toikuap mana yt kan hamo i rakat toĩne'en topysei hat hawyi toipo­'oro pya topiit pyi e. Ta'i yt naku i Iesui tunug itote katu­pono uruto Iuteu ywania Tupana wãi'e hap kuap haria hawyi yt uruiky­'esat hin i hary­poria yt iwe'eg i rakat uruehamo e tuwepe tuwa­nẽtup hawe mekewat pa'i Simãu. ");
INSERT INTO mavNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mi'i hawyi Iesui tikuap ta'yn tuwepe mekewat miit tuwa­nẽtup hap hawyi to'e tope — Pa'i Simãu e ahenoi teran wẽtup sehay epe e. Mi'i hawyi toiwesat — Waku Uhyt waku uimu'e e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mi'i hawyi Iesui to'e pa'i Simãu me sehay iã'ãkap wuo. Mio tã e — Sa'a­wy'i so wẽtup ok toĩne'en wete­weru hat. Iwato kahato sa'up toipuru morekuat po pyi iwato kahato aikotã topotpap wuat'i e'at kapiat ha'up takat ewy. Mi'i hawyi wẽtup ok i'ewyte ipuru morekuat po pyi kurin aikotã topotpap wẽtup ewaty kapiat yn ha'up takat ewy. ");
INSERT INTO mavNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mi'i hawyi so wete­weru haria yt ha'up nug kuap i ta'a­tu­we­te­weru hap morekuat pe katu­pono yt kat i ta'a­tu­we­te­weru hap sa'up wote. Mi'i pote ti mekewat morekuat tineiru puru hat to'e tepiat wete­weru iwato kahato hat pe — Pyno waure wo areĩne'en mekewat emipuru iwato rakat kai e so. — Mi'i hawyi to'e tepiat wete­weru yt ha'up wato i rakat pe wẽtup ewaty kapiat yn ha'up takat pe — Pyno waku mehĩ atiwaure ra'yn uhepiat ewete­weru hap kurin kat mehĩ e tope wy e morekuat e Iesui sehay iã'ãkap puo. Mi'i hawyi Iesui apo'e pa'i pe — Simãu e aiũwat som po'og morekuat ky'e tuwe­te­weru hap kawiat waure'e hat e. Sio mekewat tuwe­te­weru iwato rakat waure hap sio mekewat wete­weru kurin kat waure hap e Iesui Simãu me. ");
INSERT INTO mavNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mi'i hawyi Simãu tiwesat — Pyno arewa­nẽtup wete­weru wato hat po'og iky'e katu­pono iwat iwete­weru hap po'og iwato rakat toiwaure wẽtup ok kai pote e Simãu. Mi'i hawyi — Pywo kahato uhyt e Iesui Simãu me. ");
INSERT INTO mavNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mi'i hawyi Iesui tuwe­morem hary­poria topy yatypiat kape hawyi to'e pa'i Simãu me — Eraha'at ro mesuwat uipy yatpiat hary­poria kape uiky'e kahato hat kape katu­pono Tupana waure wo iwete­weru uato hap kai e ma'ato en meiũwat hary­poria yt ewy hin i ereĩne'en uhyt e. Mi'i ti uiky'e hap moherep kahato hat toĩne'en e ma'ato en areke e'yat pe wen ma'ato yt kat i y'y eiam ewy etum uhepe uipysei hamo ma'ato meiũwat hary­poria tehahy wo uipysei hawyi ta'asap mo uipy toimogag e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma'ato yt ui'ã­pysig hin i en areke e'yat piat turan aheko ewy e. Ma'ato hary­poria ti tut hawyi uipy ãpysig e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","— Ta'i put'ok'e miit ai'yat pe hawyi wat'a­tu­'ã­pysig hawyi watopag mohag hy yt ha'up woity i rakano õ'ẽ haria asap ete aheko ewy e. Pyno en ni Simãu yt etipag hin i ui'asap mohag kap mo areke e'yat pe pytkai wen ma'ato mesuwat hary­poria uipysei hap ewy ha'up woity rakano mohag hy ikamhig se rakano uipypen hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pywo pe ti meiũwat hary­poria uipy etiat pe — Yt we'eg hat hin i ere'e epy'a pe imohit hamo e. Iminug sa'ag iwato kahato ere'e mana pe e. — Ta'i wete­weru wato kahato hat ewy toĩne'en Tupana pe ere'e mana pe ma'ato koitywy iminug sa'ag ko'i Tupana tiwaure yne ra'yn e. Ta'i waure wo ra'yn iminug kai uiky'e kahato hat topy­hu'at pote e. Ma'ato wẽtup ok wete­weru yt iwato i hat minug sa'ag kurin nakat pote waure wo yt iwato i pote e. En ni mi'i hat ewy e. Mi'i pote uiky'e hap epiat yt iwato i e. Mi'i pote Tupana kyẽ hap epiat kurin topy­hu'at e Iesui Simãu me. Pyno en ereĩne'en aikotã uhehay iã'ãkap ewy aikotã mekewat wete­weru kurin kat hap ewy ereĩne'en uhehay iã'ãkap hap ewy e. Ma'ato meiũwat ui'ya­typiat hary­poria minug sa'ag wete­weru uato kahato hap etiat uhehay iã'ãkap ewy e. Mi'i hap ewy pote uiky'e kahato hat toĩne'en e. Ma'ato en ni yt uiky'e mi'i hary­poria ewy i e pa'i Simãu me. — Uiwe­te­weru hap epiat yt iwato hin i e hat ewy ere'e Tupana pe pote are e. ");
INSERT INTO mavNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mi'i hawyi Iesui to'e topysei hat pe mekewat hary­poria pe — Koitywy waku ereĩne'en Tupana wanẽtup hawe waku ra'yn mana e. Waure wo Tupana toĩne'en eminug sa'ag ko'i kai sa'a­wy­'iwuat yt naku i sese nug hat en rokirẽ e Iesui hary­poria pe sa'a­wy'i yt iwe'eg i rakat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mio tã e Iesui hawyi ienuk haria te'e­ro'e to'ope — Yt naku i mio tã wato'e katu­pono Tupana yn ni ihep kuap aiminug sa'ag ko'i i'atu'e. Pyno mio tã e Iesui yt naku i kahato wato'e i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ma'ato Iesui to'e hary­poria pe — Waku ra'yn mana ewepit ro katu­pono uimohey ra'yn en mote waku pe ra'yn ereĩne'en koitywy Tupana wanẽtup hawe e. Waku era'aipok e'yat kape ewepit kahato hap wywo katu­pono koitywy Tupana mieha­kye­ra'at ereĩne'en e Iesui mekewat hary­poria topysei hat sa'a­wy­'iwuat 7 ok ahiagnia ipiit piat rakat mana Maria tawa Mata­rena piat e hap het rakat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mi'i hawyi Iesui toto yne tawa ko'i upi temiit'in 12 ok takaria wywo sehay wakuat enoi hamo. Aikotã Tupana topy­hu'at irane Wuat'i Ywania Porekuat no hap tomohey hawyi hap moherep hamo ra'yn yne tawa hit yne tawa wato'in ko'i upi. ");
INSERT INTO mavNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Temiit'in sem ko'i wywo tuwat i'ewyte hary­po­ria'in tuwat hupi mi'u nug hamo. Wẽtup ok hary­poria Maria tawa Mata­rena piat e hap het rakat sa'a­wy­'iwuat 7 ok ahiagnia ipiit piat rakat Iesui tisopo ra'yn nakat. ");
INSERT INTO mavNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Mi'i hawyi Iuana mekewat Kusa ehary'i toto hupi hemiit'in eropat hamo. He'aito ti mekewat Kusa morekuat Eroti yat pe toĩne'en. Yne motpap hap ko'i morekuat yat piat toĩne'en Kusa po pe. I'ewyte yne morekuat ekat topy­hu'at Iuana e'aito po pe. Mi'i hawyi mana Susana i'ewyte irania'in hary­poria Iesui potpo­'o­roria powyro haria te'e­ro­py­hu'at. Iesui potmu'e ko'i 70 ok takaria poi haria. Mi'i hawyi ta'a­tuekat kaipyi ta'a­tu­kyi'at kat ko'i kat ko'i Iesui powyro hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mi'i hawyi yne tawa kaipy­wiaria aiko­pepyi aiko­pepyi te'e­ru­wa­'a­tunug Iesui ewawi. ");
INSERT INTO mavNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mi'i hawyi mi'iria sem me Iesui henoi hã'ãkap wuo — Wẽtup e'at pe so hã'ỹi sytpok hat toto toko kape hã'ỹi sytpok hamo ma'ato yt yne i hewo go sese tote e. Irania'in hã'ỹi go pu'ap upi hewo e. Mi'i ti miit'in ikohye­wyry iko pu'ap tote hawyi ta'a­tu­'akit akit ne'i ra'yn hã'ỹi hawyi weitaria tu'u yne hã'ỹi ko'i hewo rakat mu'ap upiat e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Irania'in hã'ỹi nu upi yi heg upi hewo e. Wẽtup tuereto hẽtyt ma'ato meiũran iku'uro yt kat i y'y yi kaipyi hã'ỹi nu totiat ne'i pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Irania'in hã'ỹi i'anam me hu ypia pe hewo e. Mi'iria hẽtyt wen ma'ato i'anam wywo to'o­'ewy ne'i pote meiũran i'anam tohik ne'i ra'yn hawyi yt tuwenug i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Irania'in yi wakuat upi hewo hewo heko go tote e. Mi'iria ti i'atue­hãite kahato hawyi wẽtup sat kaipyi 100 iã'ỹi tuwe­mo­herep e. Pyno ehewaure ka'a pote ewehẽtup kahato o mesuwat uhehay iã'ãkap puat uimienoi e Iesui miit'in sem me. ");
INSERT INTO mavNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mi'i hawyi ipotmu­'eria apo'i­'a­tu'e Iesui pe — Pyno kat e hap som ehenoi teran iã'ãkap wuo hã'ỹi koi hap ete i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mi'i hawyi Iesui ti'a­tu­wesat — Ta'i uiwy­ria'in ahenoi teran ehepe wuat'i mikuap yt heremo i rakat i aikotã Tupana topy­hu'at irane Wuat'i Miit'in Porekuat no hap etiat e. Ma'ato irania'in me miit'in sem me hã'ãkap wuo ahenoi teran yt uikuap teran i haria mi'iria pote e. Te'e­ra­'a­kasa wen uipiit kape ma'ato uhehay kape yt hot'ok'e i i'atuete. Ta'a­tu­ky­'esat ta'a­tue­hãite hap ta'a­tupoi hap wen ma'ato Tupana ehay yt ta'a­tukuap teran hin i pytkai e temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","— Pyno koitywy ahenoi i ehepe mesuwat iã'ỹi iã'ãkap etiat eweikuap sese hamo. Pyno uhehay iã'ãkap we Tupana ehay topy­hu'at mekewat iã'ỹi ewy e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mekewat mikoi iã'ỹi go pu'ap upiat ti hewo rakat iã'ỹi wẽtup ok wẽtup ok wanẽtup hat ewywuat e. Te'e­ru­wa­nẽtup ma'ato meremo ahiag put'ok'e i'atu­wa­nẽtup hap ete hawyi Tupana ehay mikoi iã'ỹi ewywuat toihep ta'yn i'atue­waure pyi. Yt toiky­'esat i ta'a­tukuap hawyi uimohey hap katu­pono ta'a­tu­mohey hawyi Tupana piat uimienoi hap ta'a­tue­ha­kye­ra'at hamuat ta'a­tukuap ta'yn e. Mi'i ahiag yt tiky­'esat i e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mi'i hawyi ti nu totiat hewo rakat ewywuat wẽtup ok wẽtup ok wanẽtup hat ewy e. Te'e­ru­wa­nẽtup hawyi waku kahato ta'a­tu­puẽti uimienoi e. Pywo kahato i'atu'e ma'ato mi'iria iã'ỹi yt hapo rakaria i ewywuaria ko'i tukup­te'en e. Mi'i pote yt toĩne'en mot'i i uhehay mohey hap ete e. Meiũran irania'in ti'a­tu­ky­ry'i i'atuepiat uimohey hap ete hawyi meremo ta'a­tu­waure ra'yn Tupana ehay uiwẽ pywiat e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","I'ewyte ti mekewat iã'ỹi i'anam miat hu ypia puat hewo rakat wẽtup ok wẽtup ok wanẽtup hat ewywuat e. Mi'iria te'e­ru­wa­nẽtup kahato uhehay wakuat kapiat hawyi ta'a­tu­mohey ran na'yn. Sa'a­wy'i inug neran Tupana miky­'esat ewywuat wen ma'ato ta'a­tu­potpap iwato hap kape ta'a­tue­ka­re'en iwato hap kape ta'a­tu­mi­ky­'esat wuat'i hap kape te'e­ru­wa­nẽtup yn hawyi sa'a­wy­'iwuat ta'a­tusat hap ewywuat uhehay toĩ wen ma'ato yt karãpe i waku sese ihãite hap ewy toĩne'en i'atu­py'a pe ma'ato i'akyt haria ewywuaria wo te'e­ro­py­hu'at yt haat i hap ewy i'atu­wa­nẽtup hap at ka'ap i'atu­monik poity'i ne'i ra'yn Tupana e hap uimienoi e. Mi'i hawyi ta'a­tu­mohey ran kahato hawyi waure wo te'e­ro­py­hu'at Tupana e hap ko'i kai e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma'ato mekewat hã'ỹi yi wakuat upiat hewo rakaria wẽtup ok wẽtup ok wanẽtup hat ewywuat e. Mi'iria ti i'atu­py'a piat yi wakuat ewywuat pote te'e­ru­wa­nẽtup at ka'ap Tupana ehay kapiat hawyi yt ta'a­tu­waure hin i. Ta'a­tu­hytmõi ta'a­tu­py'a pe Tupana ehay hawyi ta'a­tunug na'yn Tupana miky­'esat ewy e. Mi'i pote mikoi haat kahato rakat ewywuat te'e­ro­py­hu'at te'e­ru­wenug kahato rakat ewy e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mi'i hawyi wẽtup iã'ãkap wuo Iesui henoi towy­ria'in me — Getap we wãtym hawyi yt uwe i ariãty hẽtyhot hap ipag neran kamũti pe mig'i wo e. I'ewyte yt ta'a­tupag i yni ywyt'ok­pype ne'i ma'ato ywaiti pe waku pe heiam note yn ta'a­tu­hupit teran e. Mi'i hawyi wehyt'ok haria meremo ta'a­tukuap hẽtyhot hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mi'i hap ewy kahato uimohey hap topy­hu'at e Iesui. Ta'i uimohey sese pote meiũran aru heremo yne miit'in me ehepiat topy­hu'at hap uimohey hap aikotã ariãty ywaiti piat ewy e. Niatpo kahato uimohey hap mig'i wo hap are aikotã ariãty wãtym muat mig'i wo hap ewy e. Miit'in py'a pe uimohey hap toĩne'en mote meiũran hot'ok'e kahato itote hawyi heremo kahato e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pyno eweiwa­nẽtup to uimienoi kape uhyt'i'in mana'in e Iesui. Eweiwa­nẽtup haty wo hawyi ta'i ehewaure kahato uhehay kape mot'i hawyi meremo aru eweikuap uimienoi mikoi saat kahato rakat ewy eweikup­te'en hawyi Tupana mienoi hẽtyhot kahato rakat powyro hamuat miit'in hap ewy eweikup­te'en e. I'ewyte po'og na'yn sa'a­wy­'iwuat kai eimikuap ko'i hap ahenoi ehepe. Ma'ato yt haty wo i pote waure wo eweikup­te'en uimienoi nug hap kai pote yt kat wywo i aru eweipy­hu'at e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mi'i turan Iesui ty put'ok'e Iesui ywyt'in wywo. Mi'i hawyi Iesui ewawi ta'a­tu­ky­'esat ma'ato yt tuwe­hyt'ok kuap i ipotmu­'eria i'atu kahato sakpo getap we Iesui yatype pote Maria yt teke kuap i tomẽpyt kape. Mi'i pote Maria tikaykay Tomẽpyt tuwe­wawi ipotmu­'eria py'a­setpyi. ");
INSERT INTO mavNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mi'i pote wẽtup ok to'e Iesui pe — Uhyt iuẽ ety put'ok'e oken'y­pyke hawyi eywyt'in nywo i'atuehay teran so ewywo e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mi'i hawyi Iesui to'e tomohey haria pe topot­mu­'eria pe — Uity sese ewywuaria eweikup­te'en eipe meiũpe e. Eipe ti uheywyt'in sese uheinyt'in sese ewywuat e. Pyno eipe meiũpe eweikup­te'en uimi­ky'e ko'i aikotã uity uheywyt'in uheinyt'in ko'i ewy katu­pono uwe uwe tuwa­nẽtup kahato uhehay kape uimienoi Tupana ehay kape hawyi tutunug uhehay ewy hawyi mi'i haria ti uity'in uheywyt'in uheinyt'in tukup­te'en uiwa­nẽtup hawe uipy'a pe e Iesui ahepe tomohey haria pe tomi­ky­'esat nug haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wẽtup e'at pe Iesui to'e temiit'in me — To'iro yara puo hyemyi'a wato sakpo e. Mi'i hawyi toto ra'yn yara wato kape hawyi teke temiit'in wywo. Tuwe­hyt'ok hawyi to'e temiit'in me — To'iro uhyt'i'in ysakpo watuwat e. Mi'i hawyi tuwat ra'yn ysakpo. ");
INSERT INTO mavNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Y'y py'a­setpiat turan Iesui toket kahato. Mi'i turan ywytu kahato put'ok'e y'y ete hyemyi'a wato py'a­setpiat ikupte'en turan. Mi'i hawyi ipoity'i kahato yara ete katu­pono y'y teke teke ra'yn i'atue­'yara pe — Yt naku i i'atu'e minwa­to'e hamuat i'atu'e ta'yn. Pãi i'atu'e to'ope ipoity'i kahato i'atu'e to'ope to'ope haty wo. ");
INSERT INTO mavNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mi'i hawyi te'e­ru­wẽ­powat Iesui kape — Uruka­'iwat Uruka­'iwat erehymut ro i'atu'e te'e­re­wẽ­powat. — Wato­'o­py'at irane ra'yn i'atu'e. — Y'y teke teke kahato ahe'yara pe i'atu'e. Ai'auka irane y'y i'atu'e. Mi'i hawyi Iesui tuwe­hymut hawyi — Wãi nei'o ywytu are e ywytu uato pe. — Epo'inik to y'y e ihy wato pe hawyi ipo'inik ta'yn y'y wato i'ewyte ywytu uato ipohep ta'yn. Ta'i meremo ipo'inik ta'yn Iesui ehay upi iwẽpowat hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mi'i hawyi apo'e haty wo topot­mu­'eria pe — Uiwy­ria'in kat pote som yt uimohey kahato i e. Mi'i hawyi po'og te'e­ru­wa­nẽtup iminug ete hawyi te'e­ro'e to'ope — Uwe som pyno Meiũ Miit Iesui katu­pono yt miit ewy i tutunug kuap i'atu'e to'ope. Tupana ewy toimo­po­'inik kuap y'y wato ywytu uato hap tehay wo i'atu'e — Kat kawiat som pyno Iesui i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mi'i hawyi meremo yi Kera­senu e'y sakpuat put'ok­'i­'a­tu'e hawyi tawa Kata­renu yẽpeke te'e­ru­wehik ta'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tuwẽtem yara wato pyi hawyi put'ok'e howawi wẽtup ok ahiagnia sem ipiit piat rakat. Tawa Kata­renu piat ieĩne'en hat mi'i ti yt toĩne'en kuap i towy­ria'in wywo tetawa pe katu­pono ipy'ahak kahato heso'ok sese ahiagnia tuete ipiit pe pote. Mi'i pote toĩne'en at ka'ap wo'osyp hawe yt tesokpe pe i. ");
INSERT INTO mavNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Teha'at Iesui kape hawyi tehay pirik wo tuwe­wahik yi totiat hawyi iwẽpap'i tehay pirik wo — Worokuap En Tupana Ywaitiat Ieĩne'en hat Sa'yru En e. Kat aru etunug uhete e haty wo Iesui pe. Uhyt wãi urusa­ty'i saty'i tei'o e ahiagnia miit piit pyi. ");
INSERT INTO mavNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mio tã i'atu'e katu­pono Iesui ti'a­tu­sopo teran mekewat miit piit pyi ahiagnia pote. Sa'a­wy'i ahiagnia topytyk tuereto mekewat miit ipiit ete hawyi heso'ok sese hap tuete topy­hu'at. Irania'in ipo'i po'i teran ahiagnia ipiit piat rakat haity iheg nakat wo ipo ete ipy ete ma'ato ahiagnia tuete hawyi toiterek tuereto haity iheg nakat hawyi ahiag tioto yahig kape. ");
INSERT INTO mavNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mi'i tote Iesui to'e — Kat eĩ eset e tope. Mi'i hawyi — Isem uhet katu­pono sa'a­wy'i ahiag ko'i typy'i rakaria tuwe­hyt'ok uipiit pe pote hawyi miit'in uhet'ok Isem e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mi'i hawyi ahiag ko'i te'e­ro'e Iesui pe ta'a­tuemiit piit pyi — Uhyt i'atu'e yt urupo­'oro tei'o aria wato kape wuat'i e'at piat uruho­'opot hamo uruta'at ta'at hamo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma'ato tukup­te'en itote hamaut ko'i pote — Pyno meimuẽwat hamaut ko'i piit pe urutu­we­hyt'ok teran i'atu'e Iesui pe. Mio tã i'atu'e hawyi Iesui — Eiwe­hyt'ok to hamaut ko'i pe ei'e hap ewy e ahiagnia pe. ");
INSERT INTO mavNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mi'i hawyi tuwe­nõ'ẽ ra'yn mekewat miit heso'ok rakat piit pyi hamaut ko'i kapiat tuwe­hyt'ok hamo. Mi'i hawyi hamaut ko'i ra'yn ikohyeput i kohyeput i yity'ok totepyi y'y wato kape hawyi hewo hewo ra'yn y'y wato pe topap yne ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mi'i hawyi hamaut apykok haria te'e­ra­'a­kasa hawyi meremo tuwat henoi hamo tawa ko'i kape. I'ewyte mu'ap upiat gupte'en haria pe ta'a­tu­henoi — Tapap ta'yn yne aihũ hamaut ko'i i'atu'e y'y wato pe uhyt'i'in mana'in i'atu'e yne miit'in me. Mekewat ahiag ko'i ipiit piat rakat waku ra'yn i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pyno i'atuepiat henoi hawyi tõ'ẽ kahato Iesui kape. Put'ok­'i­'a­tu'e turan mekewat sa'a­wy­'iwuat ahiag ipiit piat rakat waku ra'yn ta'a­tu­puẽti. Sokpe pe ra'yn toĩne'en Iesui yatype. Te'e­ra­'a­kasa hawyi õ'ẽ haria te'e­ru­wa­nẽtup kahato. ");
INSERT INTO mavNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mi'i hawyi sa'a­wy­'iwuat akasa haria henoi yne aikotã aikotã Iesui timoe­hãite hap etiat õ'ẽ haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mi'i tupono mekewat tawa Kata­renu kaipy­wiaria gyt'i­'a­tu'e Iesui pupi hawyi — Mehĩ ereto ro meiũpepyi i'atu'e Iesui pe. Yt uruiky­'esat i meiũpe ereĩne'en po'og i'atu'e. Mi'i pote Iesui teke i ra'yn yara pe hawyi ta'aipok y'y wato sakpo. ");
INSERT INTO mavNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Teke turan sa'a­wy­'iwuat ahiag ipiit piat rakat — Uika­'iwat areto teran eupi katu­pono areĩne'en epotmu'e wato wo teran e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ma'ato Iesui — Yt uhyt waku po'og era'aipok e'yat kape tawa ko'i kape ipuo mono eremo­herep aikotã Tupana emoehãite hap ehenoi ewyria'in me hamo e. Mi'i hawyi Iesui henoi hawyi toto ra'yn wuat'i ipiat henoi hamo tetawa piaria pe toto. Mi'i tote yne tawa piaria pe aikotã Iesui tunug tetiat hap tohenoi kahato. ");
INSERT INTO mavNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mi'i hawyi Iesui tokosap i ra'yn ysakpo. Mi'i tote miit'in typy'i rakaria toi'a­tu­puẽti put'ok­to'e turan. I'atu­wepit kahato katu­pono ta'a­tu­he­katup Iesui ut hap. ");
INSERT INTO mavNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mi'i turan tut Iesui ewawi wẽtup ok Tupana mõtypot yat piaria akag Iairu e hap het rakat. Mi'i hawyi Iesui owa kape tuwe­pỹ­'ã­tutuk hawyi tuwe­wahik yi kape hawyi to'e Iesui pe — Mehĩ eriot ro uhupi ui'yat kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","— Mehĩ e uhaki'yt makuptia rakat 12 anu rakat iku'uro teran moity'i ra'yn e. Mio tã e hawyi Iesui — To'iro pyno Iairu pe. Iesui toto turan yne itotiaria miit'in sem tuwat hupi. Miit'in tohik kahato tuwat kahato hupi pote. ");
INSERT INTO mavNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Toĩne'en i'atutok pe wẽtup ok hary­poria huu wato rakat 12 anu ra'yn toho­'opot. Toipun yne ra'yn tekat ko'i paini ko'i upi mohag nug haria ko'i upi tomoe­hãite hap ky'ewi wen ma'ato yt toipuẽti hin i tehãite hap. ");
INSERT INTO mavNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mi'i ti put'ok'e Iesui ape kai hesokpe emig neran haype. Mi'i hawyi totemig hesokpe hawyi meremo huu iponik ta'yn ihãite ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mi'i hawyi tesokpe emig hawyi Iesui apo'e — Uwe keĩ uhemig hat meikope e. Ma'ato õ'ẽ haria — Yt uruto i i'atu'e torania. Mi'i hawyi Peteru to'e Iesui pe — Uika­'iwat miit'in typy'i rakaria to'oran me meiũ watu­kup­te'en e. I'atu kahato emig emig haria mesuwe e. Kat poteĩ — Uweĩ uhemig hat meikope ere'e e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma'ato Iesui to'e — Peteru e uhemig hat sese uimohey kahato hat toĩne'en meikope atikuap ta'yn. Uhesaika hap tuwẽtem uhemig hap kape uipiit pyi hap ete e. Mi'i uimi­moe­hãite topy­hu'at atikuap e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Toikuap ta'yn hawyi hemig hat tyry­to'e popuo tut howawi. Mi'i hawyi tuwe­pỹ­'ã­tutuk Iesui ewawi. Mio tã e — Mimi mesup ta'yn mig'i wo woromig uimoe­hãite hap ky'ewi e. Woromig hawyi meremo epiat uimoe­hãite hap atipuẽti e Iesui pe wuat'i ehamo. Mi'i hawyi itotiaria Iesui upiaria ikuap ta'yn huu wato rakat tomoe­hãite ra'yn hap. ");
INSERT INTO mavNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mi'i hawyi Iesui to'e tomi­moe­hãite hat pe — Uhaki'yt pyno waku ra'yn en e. Uimohey hap kaipyi emoehãite hap topy­hu'at koitywy etipuẽti ra'yn e. Waku pyno era'aipok i ra'yn e'yat kape ewepit hap wywo e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mi'i turan Iesui piat henoi imoehãite hap turan put'ok'e wẽtup ok Iairu yat kaipyi. Mi'i to'e Iairu piat henoi hamo. — Uhyt e iku'uro sese ra'yn wyti esaki'yt e. Pyno yt kan hamo i wahenoi po'og Aimu'e hat Iesui pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Katu­pono yt kat i aiku­'uro hawyi aheĩne'en i hap e Iairu yat kaipywiat sut hat. Mi'i hap Iesui tikuap hawyi to'e Iairu pe — Yt gyt'ere tei'o esaki'yt iku'uro hap pupi ma'ato etimohey yn na'yn Tupana hawyi waku pe esaki'yt e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mi'i hawyi Iesui put'ok'e Iairu yat ete hawyi Iesui to'e miit'in sem me — Yt atiky­'esat i miit'in typy'i poity'i iku'uro rakat yatype e. Waku Peteru Iuwãu Tiaku i'ewyte i'ywot ity yn atiky­'esat iku'uro yatype e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Teke hawyi toipuẽti itote miit'in wak haria haki'yt iku'uro pote te'e­ruwak ta'a­tueko ewy sa'up ete. Mi'iria pe Iesui to'e — Yt eweiwak tei'o e eipo­'inik to e. Yt iku'uro i rat e. Toket ne'i wyti e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mi'i pote wak haria to'o­ky­ry'i ne'i Iesui ehay ete — Pywo ti rat iku'uro sese haki'yt i'atu'e. Era'a­kasa ro i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iesui teke ra'yn iku'uro rakat kape iwywuat pe hawyi toipo­pytyk ta'yn hawyi tuwẽ­powat — Ere'ã­pe­'ok'am no pĩ'ã makuptia e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mi'i hawyi tuwẽ­powat haki'yt yt ipyhu i ra'yn nakat. Mi'i hawyi tuwẽtem gu'uro pyi hawyi tuwe­'ã­pe­'ok'am i ra'yn. Mi'i hawyi Iesui to'e ity pe — Mana etopoi ro emẽpyt e. ");
INSERT INTO mavNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","I'ywot'in te'e­ru­wehum kahato Iesui ete ma'ato mi'i hawyi Iesui to'e — Yt ewehenoi tei'o aikotã uiminug esaki'yt etiat ko'i irania'in me aikotã atomoieĩ­ne'en esaki'yt atiõtem gu'uro pyi hap ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesui tuwẽtem Iairu yat pyi hawyi toi'a­tu­kaykay tuwe­wawi temiit'in sese 12 ok takaria. Mi'i hawyi to'e temiit'in sese pe — Uiwy­ria'in Mesup atum na'yn ehepe uhesaika hap ahiag sopo hamuat e. I'ewyte atum na'yn ehepe uhesaika hap i'ahu rakaria moehãite hamuat katu­pono mesup woro­ho­'o­po­'oro teran wuat'i tawa ko'i puat wuat'i miit'in mu'e uhehay wakuat nuat e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mi'i hawyi toi'a­tu­po­'oro temiit'in miit'in mu'e hamo aikotã waku miit'in tunug Tupana Ta'a­tu­po­typot Koro wo mesuwat yi tote hap enoi hamo. I'ewyte i'ahu rakaria moehãite hamo toi'a­tu­po­'oro. ");
INSERT INTO mavNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","— Uipot­po­'oro ko'i eipe e. Uhehay moherep hanuaria e. Mi'i pote atiky­'esat ewei'a­tu­mu'e miit'in uimi­ky­'esat ewy e. Pyno woro­ho­'o­mu'e aikotã atiky­'esat eweiwat hap owakai te e. Yt kat i tei'o eweitioto ehekat ko'i e. Eipo­'yha ti sero'ok ehat pupiat wyti aru yt ewetioto i e. Yt eheku­riwu i wyti yt eimi'u ko'i i wyti i yt eheti­neiru i wyti yt typy ehesokpe i wyti ewetioto tei'o e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Put'ok­'e­wei'e wẽtup tawa pe hawyi eiky­'esat hat wẽtup ok to'yat pe pote eweikup­te'en o itote e. Waku wẽtup yat pe yn eweikup­te'en eimi­mu­'eria etawa pe e. Yt eiko­hye­wyry kohye­wyry tei'o irania'in yat ko'i upi mi'u kat hamo eimi­mu­'eria etawa ok tã e. Waku wẽtup ok e'yat pe — Ereĩne'en mesuwe mehĩ e haria e'yat pe yn o eweiket eipoi hap ok tã are e. Wẽtup getap we yn eweikup­te'en uhehay sytpok hamuat eweiwat eimi­mu­'eria etawa pe turan e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma'ato mekewat tawa piaria yt uwe i i'atu­wese pote eweiwat i ra'yn o i'atue­tawa pyi e. Ma'ato eiwat hap owakai te o tawa sawiu eipy etiat eiwei­pit­pit'ok kahato — Tupana ehay pun haria eipe hap enoi i'atuepiat hamo e Iesui topot­po­'o­roria 12 ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mi'i hawyi tohenoi yne aikotã waku miit'in mu'e hawyi tuwat ra'yn Iesui e'yianme yne tawa ko'i upi. Mi'i hawyi ta'a­tu­henoi wuat'i tawa pe sehay wakuat Iesui etiat hawyi i'ahu rakaria tawa piaria ta'a­tu­moe­hãite kahato. ");
INSERT INTO mavNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mi'i hawyi tama Karireia piat morekuat Eroti tikuap ta'yn aikotã Iesui minug ko'i etiat hawyi tuwa­nẽtup kahato — Atikuap som uwe sese Iesui pãi e. Atikuap ti mekewat uimi­'auka Iuwãu wo'o­set'ok hat ra'yn tuwe­hymut i e tuwepe Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ta'i Iesui wyti Iuwãu uimi­'auka tuwe­hymut i ra'yn gu'uro pyi sio tuwe­hymut gu'uro pyi mekewat sa'a­wy­'iwuat Tupana ehay moherep hat Eria sio yt e tuwa­nẽtup Iesui etiat sio yt mi'i miit i sio wẽtup ok Tupana ehay moherep hat tuwe­hymut i ra'yn e morekuat Eroti topy'a pe Iesui etiat. Mi'i pote morekuat Eroti tuwa­nẽtup kowo'i kowo'i. ");
INSERT INTO mavNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","— Pyno ui'a­kag'aia Iuwãu pãi e. Tuwẽtem gu'uro pyi e ma'ato Mi'i Iesui e hap het rakat uwe sese yt atikuap i pote e. Irania'in mienoi uhepiat pywo sio yt atikuap i e. Uwe kahato som atikuap teran mesup e. Mi'i hawyi morekuat Eroti teha'at teran kahato Iesui ewawi. Toiky­'esat kahato Iesui kapiat ta'a­kasa hap. Toiky­'esat ta'a­kasa Iesui minug yt miit'in eminug kuap i iwato rakat haype. ");
INSERT INTO mavNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mi'i hawyi Iesui potpo­'o­roria te'e­ra­'aipok i ra'yn tawa ko'i kaipyi ihay moherep haria. Mi'i hawyi ta'a­tu­henoi aikotã aikotã ipu'ap muat upi ta'a­tu­minug hap ko'i ta'a­tue­wyry hap upi ta'a­tu­henoi henoi yne yne Iesui pe. Ta'a­tu­henoi yne ra'yn hawyi Iesui te'e­re­po'ok i ra'yn temiit'in wẽtup tawa kape tawa Pesaita kape ta'a­tu­weran temiit'in nywo hap toiky­'esat. ");
INSERT INTO mavNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma'ato miit'in typy'i rakaria tikuap hawyi aikope Iesui toto hap kape tuwat hewat­'ymo. Iesui tiky­'esat kahato tuweran pytkai iwese kahato toĩne'en õ'ẽ haria ete. — Waku uhyt'i'in mana'in e õ'ẽ haria pe. Eiwe­hyt'ok to e i'atuepe. Mi'i hawyi mi'iria toi'a­tu­mu'e kahato aikotã waku watunug Tupana Aipo­rekuat no hap ete. I'ewyte i'ahu rakaria toi'a­tu­moe­hãite kahato itote. ");
INSERT INTO mavNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mi'i hawyi porap wãtym i kape hemiit'in 12 ok takaria te'e­ro'e Iesui pe — Urumu'e hat eti'a­tu­po­'oro i ro miit'in sem tawa ko'i upi getap ko'i kape mi'u kyi'at hamo i'atuket hamo katu­pono yahig wato pe watu­kup­te'en mesuwe ne'i pote yt kat i getap i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mio tã i'atu'e hawyi Iesui to'e — Ewei'a­tupoi ro hesy'at rakaria mio e ti temiit'in me. Mi'i hawyi — Mehĩ kurin kahato aimi'u mesuwe i'atu'e. Ta'i aimi'u 5 man typy pira yn wuat'i poi hamo i'atu'e. Sio apo etiky­'esat urutuwat tawa kape mi'u kyi'at po'og iwato hamo typy'i rakaria moenuk hamo i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tukup­te'en itote miit'in sem kahato aikotã 5000 ihainia'in i'ewyte hary­po­ria'in hira­ka­ria'in tukup­te'en itote hesy'at rakaria ma'ato yt ta'a­tu­mo­rania yne i. Mi'i hawyi Iesui to'e ra'yn — Pyno ewei'apyk to yi upi kowo 50 kowo 50 ewei'e ro wa'a­tunug haria pe e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mi'i hawyi ta'a­tunug na'yn i'e hap ewy hawyi apyk puo tukup­te'en. ");
INSERT INTO mavNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mi'i hawyi Iesui tat ra'yn man a hit rakat typy pira hawyi teha'at atipy kape — Waku kahato emiium uruepiat urumi'u wuat Tupana e. Waku to'e Tupana pe hawyi tutum na'yn mekewat man 5 a hit typy pira temiit'in me itotiaria moenuk hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mi'i hawyi tuwe­mo­wato kahato itotiaria erenuk hap. Mi'i hawyi i'atu'ok ta'yn hawyi mi'u ieĩpyt 12 yrysakag me topy­hu'at. Wẽ sakpo i'atu­mi'u ieĩpyt topy­hu'at re. ");
INSERT INTO mavNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wẽtup e'at hawyi meiũran Iesui tuweran toĩne'en temiit'in nywo Tupana kapiat tehay hamo. Mi'i hawyi apo'e temiit'in me — Uwe som uito irania'in wanẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mi'i hawyi ta'a­tu­wesat — En ni wo'o­set'ok hat Iuwãu tuwẽtem gu'uro pywiat hat i'atu'e irania'in epiat pe Uhyt i'atu'e. En ni erẽtem sa'a­wy­'iwuat Tupana ehay moherep hat Eria e hap i'atu'e irania'in epiat pe Uhyt i'atu'e. Yt Eria i pote wẽtup ok sa'a­wy­'i­tewuat Tupana ehay enoi hat tuwe­hymut i ra'yn gu'uro pyi i'atu'e irania'in etiat Uhyt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mi'i hawyi apo'e i ra'yn temiit'in me — Ma'ato ehepe apo uwe Uito eiwa­nẽtup hawe e. Uwe sese som Uito ehepe e temiit'in me. Mi'i hawyi Peteru tiwesat — En ni Tupana Mipo­'oro Urueha­kye­ra'at hanuat rat Mehĩ e. En ni Wuat'i Miit'in Porekuat Hanuat Uhyt e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mio tã e hawyi Iesui ti'a­tu­nãpin haty wo temiit'in — Pyno uiwy­ria'in e uikuap ehepiat hap yt ewehenoi tei'o irania'in me e temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yt ewehenoi tei'o irania'in me Peteru to'e uhepiat hap ewy katu­pono uhehay pun hanuaria irania'in tukup­te'en mote e. Pywo ti aru aho'opot kahato aru e. Uito ti Wuat'i Miit'in Yke'et i'ewyte Wuat'i Miit'in Kywyt pytkai yt uimohey hin i e. Pywo ti rat aho'opot hap put'ok'e irane e. Yt uiky'e hin i mesu­wa­ro­tiaria nagnia i'ewyte pa'i watoria yt uiky­'esat hin i ta'a­tu­po­rekuat no hap e ta'a­tue­ha­kye­ra'at hap e. I'ewyte Tupana ehay miwan etiat henoi haria yt uiky­'esat hin i e. Ui'auka teran haype Uito Ta'a­tuey­ke'et Ta'a­tu­kywyt pytkai e. Uiku­'uro ma'ato mi'i hawyi ti aru ara'aipok i ra'yn gu'uro pyi hawyi areĩne'en ne e. Pywo mye'ym e'at uisyp uiku­'uro hawe areĩne'en hawyi e Iesui tuwetiat tohenoi temiit'in 12 ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mi'i hawyi irania'in itotiaria kape Iesui henoi — Eweiwat teran uhupi uipot­mu­'eria wo pote eweitoiat ro yne eimi­ky­'esat ko'i yt uimi­ky­'esat i ewywuat ko'i e. Mi'i hawyi haty wo o — Atunug neran Tupana miky­'esat ewywuat ei'e hap wywo eweiwat ro uhupi e. Ta'i eho'opot hap eweipuẽti irane eweiwat uhupi hawyi e. Yt eimi­ky­'esat ewy i ewetunug ma'ato Tupana minug neran hap ewywuat wywo o eweiwat e. I'ewyte irania'in yt eiky­'esat i haria i'atu­py­'ahak hamuat ehete e. Ehaty'i haty'i aru uhupiat eweiwat hawyi e. Ui'auka irane aria'yp posak ete e. Pyno waku eipe ui'ewy eweikup­te'en e. — Ui'auka pote ui'auka ma'ato yt atoiat hin i Uika­'iwat mohey hap ewei'e o eweikup­te'en neran uipot­mu­'eria wo pote e. Waku ahe'a­ria'yp posak etiat ewywuat ra'yn wywo aho'opot hap upi aiku­'uro hap kape watuwat wẽtup sok yn aito hawyi e. Uhemiit sese yt ui'atoiat i miit'in pupi e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Uwe uwe iku'uro uipotpap we uhehay wakuat enoi hamo mi'iria wyti aru ta'a­tuieĩ­ne'en hap sese puẽti wuat'i e'at pe mesuwe i'ewyte atipy pe e. Ma'ato irania'in ta'a­tuieĩ­ne'en hap mesu­wa­rotiat kape yn wanẽtup haria ta'a­tuieĩ­ne'en hap sese pun haria howasat rakaria te'e­ro­py­hu'at e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pyno torania mesu­wa­rotiat kare'en eipo pe hawyi hekat rakaria eipe mesuwe ma'ato mi'i pytkai yt kat i ha'up eweipuẽti eheĩne'en sese wuat'i e'at piat sa'up mo e. Mi'i hap yt kat i topy­hu'at eipo pe katu­pono eweipun na'yn eheĩne'en sese mesuwuat uimi­ky­'esat nug hap hawyi eimi­ky­'esat nug hap mesuwe yn ewetunug pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Uwe uwe mesu­wa­ro­tiaria uipupi tuwe­mõti uhehay pupi tuwe­mõti mi'i hawyi i'ewyte Uito aremõti wy mi'i haria pupi e. Ta'i mekewat e'at aru karãpeĩ Uito Eheyke'et Eikywyt ariot atipy kaipyi uhẽtyhot hap puo Ui'ywot esaika hap puo hap e'at mi'iria pupi aremõti e. Ta'i mekewat ikahu sese hawuo ariot atipy piaria wywo uhesaika kahato hap wywo e. Mi'i hap e'at pe turan aremõti aru wemõti uipupiat haria pupi e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yt eweiwaure tei'o mio wuat ui'e hap e. Pywo ti rat tukup­te'en meiũpe Tupana topy­hu'at Morekuat nuat hap kapiat akasa haria e. Aikotã Tupana topy­hu'at Morekuat hap kape te'e­ra­'a­kasa irane ta'a­tu­ku­'uro hap owakai e Iesui itotiaria pe temiit'in Peteru Iuwãu Tiaku piat pe mio tã e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mi'i hawyi 7 e'at hawyi Iesui tioto ra'yn topot­mu­'eria sese Peteru Iuwãu Tiaku tuwe­wywo yity'ok kape. Mi'i tote ihay To'ywot Tupana wywo. ");
INSERT INTO mavNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mi'i turan Iesui owa yt sa'a­wy­'iwuat ewy hin i hẽtyhot kahato i'ewyte hesokpe imehit kahato ikytsig kahato. ");
INSERT INTO mavNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mi'i hawyi meremo te'e­ru­we­mo­herep iwywo typy ok sa'a­wy­'iwuat Tupana ehay moherep haria atipy kaipyi. Wẽtup ok ase'i Musei wẽtup ok ase'i Eria. ");
INSERT INTO mavNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mi'iria atipy piat hẽtyhot hap ewywuat puo te'e­ru­we­mo­herep. Mi'i hawyi Musei Eria i'atuehay kahato Iesui wywo aikotã Iesui tunug irane Tupana miky­'esat etiat aikotã iku'uro irane Tawa Ieru­sarẽi me hap. Iku'uro hap aika­wiano hap ete e hap ete i'atuehay. ");
INSERT INTO mavNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mi'i turan Peteru Iuwãu Tiaku te'e­roket kahato itote ma'ato te'e­ru­we­hymut hawyi te'e­ra­'a­kasa ra'yn Iesui ẽtyhot hap. I'ewyte i'yaty­piaria sa'a­wy­'i­wuaria Tupana ehay moherep haria ase'i Musei ase'i Eria te'e­ra­'a­kasa ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mi'i hawyi Musei Eria Iesui yaty­pepyi tuwat turan Peteru to'e Iesui pe — Waku meiũpe wato­py­hu'at wuat'i e'at pe Mehĩ e. Pyno waku urutunug mesuwe wẽtup yat ase'i Musei mõtypot hamo wẽtup yat ase'i Eria mõtypot hamo hawyi wẽtup yat emõtypot hamo urutunug mesuwat yity'ok tote e Peteru Iesui pe ma'ato yt tepiat yt ikuap i popuo mio tã to'e katu­pono token'ẽ haype. ");
INSERT INTO mavNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mio tã e turan ywyhig put'ok'e Peteru Iuwãu Tiaku ete. Mi'i hawyi te'e­ro­ken'ẽ kahato. ");
INSERT INTO mavNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mi'i hawyi Tupana ehay ta'a­tukuap ta'yn ywyhig kaipyi — Mekepe eipy­'a­setpe ti Wẽtup ok Miit toĩne'en. Mi'i ti Uha'yru Uimi­'airo Wuat'i Miit'in Ehakye­ra'at hanuat e. Pyno eiwa­nẽtup to Uha'yru mienoi kape e Iesui piat pe I'ywot Tupana ehay put'ok'e atipy kaipyi. ");
INSERT INTO mavNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mio tã e hawyi Iesui tuweran toĩne'en Musei Eria te'e­ra­'aipok atipy kape hawyi. Mi'i hawyi Peteru Tiaku Iuwãu yt henoi hin i irania'in me ta'a­tu­'a­kasa hap ko'i ma'ato meiũran ta'a­tu­henoi ra'yn ta'a­tu­mikuap ko'i Iesui tehymut ra'yn gu'uro pywiat hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","E'ihot'ok pe hawyi Iesui topot­mu­'eria wywo ipot'apyk yity'ok kaipyi yi hot kape. Mi'i turan put'ok­'i­'a­tu'e typy'i rakaria Iesui ete. ");
INSERT INTO mavNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mi'i hawyi wẽtup ok miit'in tok piat tikaykay ra'yn Iesui — Urumu'e hat eraha'at ro uha'yru wẽtup yn nakat kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ma'ato ahiag teke uha'yru piit pe hawyi tehay pirik wo ihay sa'ag hawyi ahiag tihuruk kahato uha'yru Uhyt e. Yt naku i kahato tuete hawyi iwẽnãpuk sa'ag kahato uimẽpyt e. Mi'i hawyi toha­ty'i haty'i hawyi iperup kahato toĩne'en mot'i tuete hawyi tuwẽtem porap i tuereto uimẽpyt piit pyi e. Mi'i hawyi meremo teke i ra'yn ipiit pe tuereto i'ahyk ahyk hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Emiit'in me ahiag hep hap ahẽtup wen ma'ato yt ta'a­tuhep kuap i e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mi'i hawyi Iesui to'e itotiaria pe — Are pãi eipe ti yt Tupana mohey hin i haria i'ewyte eiwa­nẽtup hap yt hãpyk hin i Tupana kape e. Areĩne'en mot'i ra'yn eiwywo eimu'e hamo wen ma'ato yt uimohey kahato i e. Mi'i hawyi to'e ahiag ipiit piat rakat e'ywot pe — Pyno eterut ro esa'yru uhowawi e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mi'i hawyi kurum tut Iesui ewawi turan ahiag tipun i yi tote hawyi toihuruk huruk kahato i'ewyte iwẽnãpuk. Ma'ato mi'i turan Iesui — Wãi'e ahiag me hawyi tuwẽtem hawyi ihãite. Waku hawyi Iesui tum ha'yru i'ywot pe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mi'i hawyi itotiaria te'e­ru­wa­nẽtup Tupana esaika hap iwato kahato Iesui mimo­herep hap kape. ");
INSERT INTO mavNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Te'e­re­wa­nẽtup turan Iesui minug ko'i etiat turan Iesui henoi topot­mu­'eria pe — Yt eweiwaure tei'o mesuwat uimienoi e. Pywo ti rat Miit'in Eheyke'et kahato areĩne'en pytkai miit'in mima'at aru arepy­hu'at hawyi ui'auka teran haria po pe uhenoi. ");
INSERT INTO mavNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma'ato yt ta'a­tukuap hin i kat to'e hawe mio tã e ma'ato hemiit'in apo yt i'atu'e teran i te'e­ro­ken'ẽ haype. ");
INSERT INTO mavNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mi'i hawyi Iesui potmu­'eria tu'uka to'ope ta'a­tuehay wo uwe kahu po'og tu'isa wo toĩne'en hap ete. Mi'i hawyi — Uito po'og eikai yn i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mi'i hawyi Iesui tikuap ta'yn i'atu­wa­nẽtup hap hawyi toterut hirakat i'atue­wawi tuwe­wywo. ");
INSERT INTO mavNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mi'i hawyi to'e temiit'in me — Uwe uwe toĩne'en neran uhemiit'in akag wo waku mi'i miit topy­hu'at hira­karia powyro hat wo mẽpyt'in ky'e hat wo po'og torania kai e. Uwe uwe ti'a­tu­ky'e kahato hira­karia Uito ewy mi'i hat po'og uhemiit koro toĩne'en irania'in kai Tupana wanẽtup hawe e. Mi'i pote eweha'at ro meiũwat hirakat kape uwe uwe meiũwat hirakat ewywuat ky'e hat i'ewyte uiky'e hat sese e. Meiũwat hirakat ewywuat ky'e hat uiky'e hat toĩne'en mi'i hawyi mi'i hat waku ei'akag wo e. Pywo ti rat uwe uwe uiky'e hat toĩne'en mi'i hat piat Tupana to'e — Uiky'e kahato hat en e hira­karia ky'e hap upi e. Mi'i hat ti ei'akag wo toĩne'en Tupana wanẽtup hawe e. Pywo ti rat uwe uwe to'e hirakat yt i'ywot i yt ity i rakat pe — Ereke o ui'yat pe uimẽpyt no e hat pe — En po'og uhemiit e aru Tupana e Iesui. Meiũwat hirakat ewywuat ky'e kahato hat uimi­'airo ei'akag wo toĩne'en e. Uwe to'e hira­karia pe — To'iro watenuk hit e mi'i hat i'ewyte uhepe — To'iro watenuk e hat ewy toĩne'en e Iesui. Mi'i hat uiky'e hat i'ewyte uwe uwe uiky'e hat Ui'ywot Atipy piat ky'e hat toĩne'en e. Meiũwat hirakat ky'e hat ewywuat eipe pote uiky'e hat i'ewyte toĩne'en i'ewyte Uipo­'oro hat Tupana ky'e hano toĩne'en e. Uwe hirakat powyro hano toĩne'en mi'i ti po'og waku eimu'e hat akag e. Ta'i yt wemo­wato i hat po'og irania'in kai ei'akag wo e Tupana e Iesui ahepe temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mi'i hawyi Iuwãu to'e Iesui pe. — Uruka­'iwat ga'atpo uruta­'a­kasa ra'yn wẽtup ok ahiag ko'i sopo hat e. Eset wo toi'a­tu­sopo kahato ahiag wen yt hewyry hin i ahupi hat. Mi'i pote — Wãi'u­ru­to'e tope katu­pono yt karãmuo i uruwywo hewyry rakat i pote e. Ta'i yt karãpe i mekewat miit eti'airo uruehamo emiit no pote — Yt naku i etunug Iesui motpap mesuwe yt uruwywo i ereto pote uruto'e tope e. Mi'i hawyi — Ma'ato uito ti eipe ewywuat kahato katu­pono uito i'ewyte Iesui mohey hat areĩne'en e uruepe. Mi'i hawyi — Wãi'u­ru­to'e i tope katu­pono toi'a­tu­sopo kahato ahiag itote ehay wo ma'ato yt hewyry i uruupi uruto'e tope i'atu'e Iesui pe topot­po­'o­roria. ");
INSERT INTO mavNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma'ato Iesui tiwesat topot­po­'oro Iuwãu me i'ewyte irania'in topot­mu­'eria pe — Yt naku i wãi'e­wei'e wẽtup uhemiit yt hewyry i eiwywuat rakat pe e katu­pono ti aru tukup­te'en kahato uhemiit'in yt eimikuap ko'i i e. Mi'iria ti aru ma'ato howapy kahato uhesaika hap wywo eiperia ewywuat e. Mi'iria uimohey kahato haria tukup­te'en eiperia ewywuat uimohey kahato rakaria yt karãpe i eiwywo hewyry rakaria pytkai e. Mi'iria ti yt karãpe i uimohit ta'a­tuehay wuat haria katu­pono uhet wywo ta'a­tu­sopo ahiag e. Mi'i pote ti yt naku i irania'in uhemiit'in me — Wãi nei'o ewei'e yt eiwywuat hewyry rakaria i pytkai are e. Pyno po'og waku — Hẽ to uhyt mana ewei'e yne uhemiit'in waku nug haria pe e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesui aipok hap atipy kapiat hamuat yt pya hin i mi'i pote Ieru­sarẽi kape yn toto teran to'auka aheka­wiano hap kape toto teran. ");
INSERT INTO mavNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Toto Ieru­sarẽi kapiat tokosap mo teran tawa Samaria kape. Mi'i pote sa'a­wy'i toi'a­tu­po­'oro temiit'in te'yianme tawa kape ta'a­tuket hamuat heiam kat hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma'ato toto tawa wato Ieru­sarẽi kapiat tokosap mo. Mi'i pote tawa Samaria piaria sakpo toto teran. Mi'i pote toi'a­tu­po­'oro temiit'in te'yianme tawa Samaria kape i'atu­mi'u kat hamo i'atuket hap kat hamo. Ma'ato tawa Samaria piaria yt tiky­'esat i katu­pono ta'a­tukuap ta'yn ta'a­tue­wa­nĩ­kaptia tawa Ieru­sarẽi piara kapiat tokosap mo toto Iesui hap. Ta'i Iuteu ywania Iesui pote yt ta'a­tu­ky­'esat i Iesui ut hap. Katu­pono tawa Samaria piaria gupte'en haria yt iky'esat hin i Iuteuria ko'i. ");
INSERT INTO mavNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tiaku Iuwãu mi'i tawa piaria e hap ta'a­tukuap hawyi apo'i­'a­tu'e Iesui pe — Uruka­'iwat waku apo aria uruikaykay atipy kaipyi yt eky'esat i haria tawa Samaria yawnia u hamo i'atu'e. Pyno waku eti'a­tu­moma yne mi'iria aria atipy kaipywiat wo i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mi'i hawyi Iesui tuwe­morem wãito'e hamo — Yt rat yt eiwe'eg hin i e. Yt ariot i wyti miit'in auka hamo Uito e. Yt naku i eweikaykay aria atipy kaipyi miit auka hamo e. Miit'in ehakye­ra'at hamo ariot e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mi'i hawyi tuwat i ra'yn wẽtup tawa kape wẽtup mu'ap upi yi Samaria sakpo. ");
INSERT INTO mavNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mu'ap upi put'ok'e Iesui ewawi wẽtup ok tehay hamo — Mehĩ areto teran kahato eupi aikowo aikowo ewyry hap upi e. Uipap eupi emiit no areĩne'en neran e. Ehay moherep wuat'i ywania piat hamo atiky­'esat uito e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mi'i hawyi Iesui tiwesat — Pyno ereto teran pote waku sa'a­wy'i eto hap owakai etikuap niatpo kahato ereto uhupi hap e. Yt kat hin i ui'yat toĩne'en mesu­wa­rotiat e Iesui. Uito Miit'in Yke'et areĩne'en wen ma'ato yt kat i uhekat uimi'u mesuwe e. Ereto teran uhupi pote yi tote yn watoket yt kat i ai'yat pote e. Ta'i mesu­wa­rotiat awahuru ko'i tukup­te'en ta'a­tu­ka'a puo ma'ato Uito yt kat i uiket hap e. I'ewyte weitaria ta'a­tusok ko'i puat te'e­roket ma'ato Uito Wuat'i Miit'in Porekuat pytkai areket yahig me mu'ap upi yt kat i ui'yat i pote. Yt kat i uhekat mesu­wa­rote are'e epe e. Niatpo kahato uhemiit no hap waku miit'in tikuap tuwat uhupi teran haria e. Yt naku i eweiwat uhupi hawyi ui'atoiat niatpo kahato hap upi are e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mi'i hawyi Iesui tuwẽ­powat wẽtup ok kape — To'iro uhupi mehĩ e. Mi'i hawyi toiwesat Iesui — U pãi wen ma'ato sa'a­wy'i waku atipoi ui'ywot iku'uro hap kape mi'i hawyi isyp rokirẽ waku meremo areto eupi e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma'ato Iesui to'e — Etipo­'oro iku'uro rakaria iku'uro rakat syp hamo uhyt e. Tukup­te'en ni iku'uro rakaria ewywuaria Tupana kape yt ihay i haria yt kuap i haria waku mi'iria po pe etoiat sa'up e'ywot poi e'ywot syp hamo uhyt e. Mi'i hawyi meremo ereto uhupi miit'in mu'e aikotã waku ta'a­tunug Tupana ta'a­tu­po­rekuat nuat enoi hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mi'i hawyi wẽtup ok to'e Iesui pe — Ta'i areto teran eupi pãi Uhyt e ma'ato sa'a­wy'i ahẽtup teran ui'ywot uity pe sio waku sio yt hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mi'i pote Iesui to'e — Yt naku i wateput hap upi wate­ha'at at ka'ap ahewat­'ymo hap kape katu­pono mi'i tã watunug pote meremo wata'at e. Mi'i hap ewy kahato uwe uwe toto uhupi uhehay moherep hamo hawyi tewat­'ymo hap kape teha'at kahato hawyi toiky­'esat tomi­'atoiat ko'i hawyi ta'aipok i ra'yn sa'a­wy­'iwuat hap kape mi'i miit yt naku i topy'a pe uhemiit no. Mi'i miit yt naku i uhemiit no Tupana ehay moherep hamo aikotã waku watunug Tupana Aipo­typot no e hap moherep hamo e Iesui — Areto teran eupi wen e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wẽtup e'at Iesui Aika­'iwat ti'a­tu­'airo po'og 70 ok takaria topot­mu­'eria wo. Mi'iria typy ok tuereto toi'a­tu­po­'oro aikowo aikowo toto irane hap tawa kape te'yianme tawa ko'i upiat miit'in atumu'e yian notiat hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Toi'a­tu­'airo topot­po­'o­roria hawyi toi'a­tu­nãpin i'atuwat hap eyianmete aitotã waku ta'a­tunug ipuo hap ete mio tã e — Woro­ho­'o­'airo eipe miit'in sem atumu'e hanuaria wo e. Miit'in haat rakaria ewywuaria Tupana wanuat nug hamuat e. Aikotã awati ewy kahato mi'iria tukup­te'en waku pe hamo e. Waku eweipuruk aimi'u wo e katupono awati sem ewywuat itote miit'in sem e. Yt eweipuruk kuap i hap ewy i'atu kahato awati ewy e. mi'i pote waku eiperia typy'i kahato ipuruk hamo e. Waku ewehẽtup ipuruk hamo Mikoi Ka'iwat Tupana pe — Etipo­'oro o meremo urupo­wyro hanuaria haat ko'i puruk hamuat ewei'e Ipuruk Hat Ka'iwat pe e. Waku wahẽtup Tupana pe aipo­wyro hap are. Mi'i hawyi temiit 70 ok takaria toi'a­tu­po­'oro tehay moherep hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","— Pyno eweiwat ro e ma'ato eiwe'eg wo o eimi­mu­'eria pupi are katu­pono irania'in itote ai'auka teran haype ne'i e. Ta'i woro­ho­'o­po­'oro ehewa­nĩ­kaptia py'a­setpiat eikup­te'en hamo aikotã aihũria tukup­te'en awahuru sem py'a­setpe hap ewy aru eweikup­te'en itote aikotã awyato ai'u teran haria ewywuaria itote tukup­te'en uhetiat ewei'a­tu­mu'e turan e topot­po­'o­roria 70 ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Eiwat hap upi yt eweitioto tei'o ehekat ko'i i'ewyte mekewat sa'up eiam me yt kat i sa'up eweitioto o e. I'ewyte ehesokpe eiam yt eweitioto tei'o e. Wẽtup yn eipy piat eipy sokpe mi'i waku eretopag e. Mi'i hawyi yt eweikup­te'en mot'i i mu'ap upi irania'in wehay miky­ry'i hamo e. Ma'ato eweiwat ro hãpyk mekewat tawa ko'i kape eipo­'oro hap ko'i nug hamo i'atu­mu'e hamo are ehepe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kat etawa kat etawa pe put'ok­'e­wei'e hawyi o wẽtup getap we yn eiwe­hyt'ok hawyi waku ewehẽtup Tupana pe — Eti'a­tue­ha­kye­ra'at kahato ro meiũwat getap wiaria hawyi eti'a­tu­moe­hãite yne miit'in meiũwat getap wiaria o ewei'e itote e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mi'i hawyi getap wiaria eimienoi ko'i Tupana mipoi­tyro ko'i tukup­te'en ei'e hap ewy e. Ta'a­tukuap teran ehay pote meremo ta'a­tukuap e. I'atu­wese ehete pote ei'e hap — Tupana eti'a­tue­ha­kye­ra'at meiũwat yat piaria o ei'e hap sa'a­wy'i eimiẽtup ewy Tupana tunug na'yn ei'e hap ewy wen ma'ato mekewat yat piaria yt i'atu­wese i uhehay kuap hamo pote hawyi wu'uka teran haype pote eimiẽtup — Tupana eti'a­tu­poi­tyro meiũwat yat piaria ei'e hap Tupana yt tum i ta'a­tu­mo­wepit hap eimiẽtup sa'a­wy­'iwuat ewy e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","— Mi'i hawyi wẽtup getap we yn eweikup­te'en eiky­'esat haria piat pe e. Eiwe­hyt'ok hawyi itote yn o eweikup­te'en e. Kat som ta'atuium ehepe eimi'u wo mi'i ti waku ewetu'u e. Yt eweiwe­mõti tei'o i'atumium ete yt kat sa'up i katu­pono eipe ti i'atu­mu'e haria pote eipoi eipotpap sa'up mo e. Ma'ato yt naku i eheha­mane'i yne getap ko'i upi sẽtup sẽtup eharia ewy e. Sa'a­wy­'iwuat eiwe­hyt'ok hawe yn eweikup­te'en hawyi itote yn eweinuk e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tawa piaria waku kahato eweipuẽti e haria pote ehu'u ro kat ko'i kat ko'i ta'a­tu­mierut eimi'u wuat. ");
INSERT INTO mavNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mi'i tote yne i'ahu rakaria waku eweimoe­hãite e. Waku kotã ewei'e itotiaria pe — Tupana topy­hu'at meiũ Porekuat no hap yt pya hin i eikai ewei'e iwese etawa piaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma'ato tawa piaria yt i'atu­wese i ehete pote waku eiwe­nõ'ẽ i'atue­tawa pyi hawyi mu'ap upi itote pyi eiwe­pit­pit'ok i'atue­tawa sawiu eipy etiat hep hamo hawyi ewei'e wuat'i tawa piaria ehamo — Pyno mehĩ'in mana'in Tupana ehay pun haria eipe ewei'e i'atuepe e. Pyno yt uruiky­'esat i ra'yn ehetawa sawiu urupy ete ewei'e o i'atue­wawi. Tupana ehay pun haria ra'yn eipe ewei'e itotiaria pe e. Mi'i hap ewetunug hawyi meiũwat tawa piaria tikuap ta'yn uimohey hap pun haria ne'i mi'iria i'ewyte Tupana tikuap ta'yn uimohey hap pun haria hap e Iesui topot­po­'o­roria pe 70 ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Mio tã waku ewei'e itote — Pyno urumienoi Tupana Mipo­'oro Aheha­kye­ra'at hat etiat sehay yt eweiky­'esat i hawyi ehetawa sawiu urupy etiat yt uruiky­'esat i hawyi uruipit­pit'ok ewei'e o e. Mi'i tã urutunug ei'a­piheg irane hap enoi hamuat hap ewei'e o e. Koitywy Tupana ti'a­tu­'a­piheg aru yt eweiky­'esat i urumienoi pote ewei'e o e. Tupana topy­hu'at Miit'in Porekuat nuat hap yt pya hin i eikai toĩne'en ma'ato yt eweiky­'esat i pote ei'a­piheg hap yn topy­hu'at irane ewei'e o yt uiky­'esat i haria pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mi'i hawyi Iesui to'e wuat'i tawa ko'i puaria towa­nĩn­kaptia pe yt tomohey i haria pe — Arewak uipy'a pe ei'a­piheg hap ete e. Pywo ti rat are'e ehepe Tupana mi'a­piheg ko'i eweikup­te'en aru e. Karãpe put'ok'e aru mekewat uhe'at hawyi are'e Tupana pe uwe waku rakaria uwe yt naku i rakaria hap e'at pe ti aru ahenoi Tupana pe mio tã — Eipe ti uipot­po­'o­roria yt ky'esat i haria pote yt naku i pe eweikup­te'en po'og sa'a­wy­'i­tewuat tawa Sutuma piaria kai sa'a­wy­'iwuat uimiwuk kai are'e. Mi'iria yt naku i kahato rakaria ati'a­tu­moma ra'yn aria wo atipy kaipywiat no ma'ato eipe po'og yt naku i wo eweipy­hu'at tawa Sutuma piaria kai uhehay enoi haria yt eweiky­'esat i pote are aru ehehay uhetiat pun haria pe e Iesui topot­mu­'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mi'i hawyi po'og tohenoi tawa ko'i puaria yt tomohey haria i etiat — Ahenoi wyti Iuteuria kaipy­wiaria tawa Kurasĩ miaria gupte'en haria i'ewyte tawa Pesaita piaria apiheg hap etiat e. Yt naku i pe te'e­ro­py­hu'at irane e. Arewak uipy'a pe ei'a­piheg hap ete e. Te'e­ra­'a­kasa uiminug wakuap ko'i kape yt irania'in ewywuat i ma'ato mi'i pytkai yt uimohey teran hin i. Uito iwato kahato rakat hap upi i'atue­hamuat atunug kahato pytkai yt miit minug ewywuat i atunug ma'ato uimohit ne'i e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nimo kahato tawa Tiru piaria tawa Sĩtau piaria Tupana ti'a­tu­moma e. Tawa Sĩtau piaria tawa Tiru piaria topap yne itote e miwan me e. Mi'iria yt naku i sese rakaria tukup­te'en hap watikuap. Pywo ra'yn i'atu­minug sa'ag ko'i po'og iwato toĩne'en wuat'i sa'a­wy­'i­wuaria kai wen ma'ato uimohey pun hap mesu­wa­ro­tiaria tawa Kurasĩ piaria tawa Pesaita piaria po'og yt naku i nug haria Tawa Sĩtau tawa Tiru piaria yt naku i nug hap kai katu­pono uimohey hap pun haria mi'iria pote e. Ta'i ati'a­tu­mu'e kahato mi'iria Tupana ehay wakuat wo ma'ato yt uimohey i haria hap yn topy­hu'at yt kat i uimohey hap e. Are pãi arewak uipy'a pe ei'a­piheg hap Tupana piat hap aru hap pupi. Yt naku i kahato hawuo topy­hu'at aru tawa Kurasĩ tawa Pesaita piaria e. Sa'a­wy'i tawa Sĩtau piaria tawa Tiru piaria yt te'e­ra­'a­kasa hin i uiminug wakuat nug hap ko'i kape ma'ato te'e­ra­'a­kasa pote tawa Kurasĩ tawa Pisaita piaria ewy meremo te'e­ru­we­morem Tupana kape hap atikuap. Te'e­ra­'a­kasa hawyi meremo sokpe i'anam nakat ewywuat ta'a­tupag ta'a­tuepiit ete haty nug hamo paata­'a­tu'e Tupana kapiat hap moherep hamo are e. Mi'i hawyi yi tote te'e­ra­'apyk hawyi ywytup ko'i ta'a­tu­'akag me ta'a­tupag ta'a­tueko ewy ta'a­tu­minug sa'ag atoiat hap moherep hamo e. Ma'ato eipe ti tawa Kurasĩ piaria tawa Pesaita piaria yt naku i pe eweipy­hu'at po'og tawa Tiru piaria kai tawa Sĩtau piaria kai aru are katu­pono ewei'a­kasa uiminug wakuap ko'i i'ewyte uhehay Tupana etiat yn hap wen ma'ato yt ewei'a­tu­'atoiat teran hin i eiminug sa'ag hap ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mi'i hawyi Iesui — Arewak uipy'a pe ei'a­piheg hap Tupana piat hap pupi tawa Kawa­na'ũ piaria e. — Ta'i uruto po'og na'yn tora­nia'in kai uruto­py­hu'at e haria eipe wen ma'ato eiwe­ma'at ne'i mio tã ewei'e katu­pono ti aru eiku­'uro hap topy­hu'at irane hawyi yt uwe i te'e­ro­py­hu'at ehetawa pe aru eikuap haria tukup­te'en mesuwat yi tote katu­pono eipe yt uimohey i haria pote are e Iesui tawa Kawa­na'ũ piaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mi'i hawyi to'e i ra'yn topot­po­'o­roria pe — Uwe eimienoi kapiat wanẽtup hat wyti aru i'ewyte uimienoi kapiat wanẽtup hanuat. Yt eiky­'esat i hat ti aru i'ewyte yt Uito i wyti uiky­'esat hat ra'yn e. Yt uiky­'esat hat i pote i'ewyte yt Uipo­'oro Hat Tupana ky'esat hat i e 70 ok takaria pe i'atu­po­'oro haype. ");
INSERT INTO mavNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mi'i hawyi 70 ok takaria Iesui ti'a­tu­po­'oro ra'yn tawa ko'i upiat tehay henoi hamo. Mi'i hawyi 70 ok takaria tuwat hawyi i'atu­ko­hye­wyry hap tawa ko'i upi miit'in mu'e hamo hawyi te'e­ra­'aipok i ra'yn Iesui kape i'atu­wepit kahato. Mi'i hawyi te'e­ro'e — Uruka­'iwat i'atu'e pywo wyti ahiag tuwat ra'yn esaika wuat urui'a­tu­sopo hawyi i'atu'e. Eset nywo urui'a­tu­sopo kuap kahato ahiagnia i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mi'i hawyi Iesui to'e i ra'yn 70 ok takaria pe — Ta'i uimiium uhesaika hap po'og ahiag kai e. Sa'a­wy'i ahiag atipy pe toĩne'en Tupana yatype hemiit no wen ma'ato tuwe­mo­wato teran po'og Tupana kai hawyi Tupana tipun ahiag atipy kaipyi yi kape e. Mi'i hap Uito ara'a­kasa ahiag Tupana ti'ok­hytpun turan. Merep merep'e hap put'ok'e hap ewy ta'at atipy kaipyi yi kape ahiag e. I'ewyte eweiwat turan ara'a­kasa i ta'at i ra'yn ahiag hap ara'a­kasa uhehay ewei'a­tu­mu'e miit'in wuat'i tawa ko'i upi turan e Iesui topot­po­'o­roria 70 ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mi'i pote uimiium uhesaika hap ehepiat po'og hesaika ahewa­nĩkap sese ahiag kai. I'ewyte eiko­hye­wyry hap upi miit'in mu'e uhehay wo turan moi ok yt hesaika i ehete i'ewyte sapot yt haty kuap i eipiit ete e. Pywo pe ti yt kat i eipyhyp kuap eipe uhehay ehewyry hap upi uhehay moherep hamuat turan e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ga'atpo ra'yn atum ehepe uhesaika hap wuat'i nug kuap hamo e. Mi'i pote waku kahato ahesaika ewei'e eipy'a pe. Waku kahato ahesaika hap ahiag sopo hamo ewei'e eipy'a pe e. Mi'i pote eiwepit kahato mesup e. Pyno waku eiwe­mo­wepit uhesaika hap toĩne'en eipiit ete wuat'i nug hamo wen ma'ato po'og po'og waku ewei'e eipy'a pe — Uimo­wepit hap sese ti toĩne'en mesup katu­pono Tupana uheha­kye­ra'at ra'yn wuat'i e'at pe uimo­wepit hap sese po'og waku ewei'e eipy'a pe e. — Ta'i uhet sese toĩne'en miwan me atipy pe Tupana mieha­kye­ra'at areĩne'en pote uiwepit kahato mesup po'og uhesaika ahiag sopo miit'in moehãite hap kai po'og waku ewei'e eipy'a e. Mi'i Tupana piat eheha­kye­ra'at wuat'i e'at piat hap are waku katu­pono ehet ko'i toĩne'en atipy pe miwan me uwe Tupana mieha­kye­ra'at ko'i sese e hap miwan note e. Mi'i hap po'og waku toĩne'en wuat'i kai eimo­wepit hap e Iesui temiit'in me ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mi'i hawyi Tupana Pã'ãu timo­wepit ra'yn Iesui hawyi to'e — Papai waku kahato ti En e. Atipy piat Morekuat nuat i'ewyte mesu­wa­rotiat Morekuat nuat. Waku kahato en Papai katu­pono emikuap ko'i yt heremo i rakat ko'i yt etimo­herep hin i — Uruikuap yne po'og torania kai ra'yn e haria pe ma'ato — Yt uruikuap i kahato te e haria pe hira­karia ewywuaria pe etimo­herep ta'yn ekuap hap uimi­mo­herep hap ko'i uhehay wakuat emiky­'esat ewy e Iesui To'ywot pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mi'i hawyi Iesui to'e temiit'in me — Tupana tum na'yn uhepe towanuat ko'i apykok hamo tesaika hap e. Ta'i Ui'ywot yn ni uikuap hat sese e. Ui'ywot yn nyti Uito Tosa­'yru kuap hat sese e. I'ewyte Uito yn nyti Ui'ywot kuap hat e. Ha'yru yn nyti To'ywot kuap hat sese e. Ma'ato uwe uwe pe atimo­herep teran Ui'ywot kuap hamuat mi'iria ti aru Ui'ywot kuap haria te'e­ro­py­hu'at e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pyno uiwy­ria'in e i'atu kahato sa'a­wy­'i­wuaria Tupana ehay moherep haria te'e­ra­ha'at teran kahato uhowawi rakaria ma'ato yt te'e­ra­ha'at kuap i yt uhe'at i te pote e ma'ato eiperia ti eweha'at ra'yn uikuap haria sese ra'yn eipe. Mi'i pote ti are'e ehepe eheha ko'i yt uwe wuat ewy i tukup­te'en eheha wuat ewa'a­kasa uhowawiat haria eipe pote e. Eipe po'og Tupana mipoi­tyro ko'i torania kai are e Iesui topot­po­'o­roria 12 ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Katu­pono sa'a­wy­'i­te­wuaria Tupana ehay enoi haria i'ewyte porekuat nuaria ko'i hekatup kahato mesuwat e'at piat e. Te'e­ra­'a­kasa teran ei'a­kasa hap ko'i kape ma'ato mesuwat e'at pe yt put'ok'e i te i'atu­kup­te'en hap e'at pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mi'i hawyi wẽtup ok miwan enoi hat apo'e Iesui pe — Urumu'e hat e aikotã som waku uheĩne'en hap sese puẽti hamo atunug e yt pywo pe i ma'ato toima'at reran haype ne'i apo'e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mi'i hawyi Iesui tiwesat — Etikuap apo aikotã Musei mienoi ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","— Ta'i atikuap e. — Etiky'e o Tupana yn epy'a pe e. Etiky'e yne ewanẽtup hawe. Etiky'e Tupana yne ewe'eg hawe e. I'ewyte eti'a­tu­ky'e irania'in yne ro eweky'e hap ewy e tomiwan me e miwan enoi hat Iesui apo'e hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","— Pywo kahato uiwesat en uhyt e Iesui. Mi'i ko'i etunug hawyi eieĩne'en hap sese etipuẽti ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mekewat miwan enoi hat — Uito po'og waku irania'in kai e hat toĩne'en pote yt toi'a­tu­ky'e hin i irania'in. Mi'i pote to'e Iesui pe — Uwe pyno waku atiky'e irania'in e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mi'i hawyi Iesui henoi sehay iã'ãkap tope uwe waku wati­ky'e hap enoi hamuat — Sa'a­wy'i so wẽtup ok Iuteu ywania kaipywiat toto ra'yn tawa Ieru­sarẽi kaipyi tawa Ieriko kape. Mi'i hawyi mu'ap upi tuwe­mo­herep sero'ok takaria. Mi'iria mu'ap upiat hat esokpe ta'a­tuhep yne hawyi ta'a­tu­'ahyk ahyk ne'i e. Porap ta'a­tu­'auka e i'ahyk ahyk hawe e. Mi'i hawyi ta'a­tu­'atoiat mu'ap tote e. I'ewyte ta'a­tue­roto yne heka­re'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ta'a­tu­'atoiat hawyi pa'i Iuteu kaipywiat toto ipuo e. Mi'i ta'a­kasa hawyi tokosap ne'i mi'ahyk ahyk ywytpuo e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mi'i hawyi Irewi ywania kaipywiat hat Tupana yat piat motpap nug hat tut e. Mi'i ti i'ewyte ipuẽti mekewat i'atu­mi­'ahyk ahyk ma'ato pa'i ewywuat kahato pote yt ta'a­kasa teran i iku'uro rakat hawyi tokosap ne'i i'ywytpuo e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mi'i hawyi meiũran put'ok'e wẽtup ywania mekewat yi Samaria kaipywiat e. Yt ai'y­wania Iuteuria ywania miky'e hin i Samaria ywania ma'ato mi'i pytkai mekewat yi Samaria kaipywiat teha'at kahato mekewat mi'ahyk ahyk kape hawyi toiky'e kahato topy'a pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mi'i hawyi tuwe­po­hagnug mohag ikap takano i'ewyte mahy ewy wuano hawyi sokpe wo ra'yn toipo'i po'i. Tepiat ipohag nug waku hawyi mekewat yi Samaria kaipywiat hupit ra'yn tohũ ok tote mi'i hawyi getap kapiat totioto hamo. Miit'in ket howare pe hawyi heka­tuwy wo toĩne'en wãtym muo ka'ap i'apykok hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","E'ihot'ok pe hawyi yi Samaria kaipywiat tum na'yn sa'up iwato kahato rakat getap ka'iwat pe mekewat sero'ok mi'ahyk ahyk poi hamo hawyi typy i'ape nu Uru kawiat tutum ha'up iwato kahato rakat hawyi tohenoi getap ka'iwat pe — Etiky'e ro meiũwat i'ahu rakat e. Mi'i hawyi ariot hawyi po'og atum epe iky'e hap sa'up mo e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tohenoi hawyi Iesui apo'e ra'yn Tupana ehay miwan miat enoi hat pe — Uwe kahu meiẽwat sero'ok takaria mi'ahyk ahyk ky'e hat e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mi'i hawyi miwan enoi hat tiwesat — Mekewat yi Samaria kaipywiat iwese rakat iky'e kahato hat e. Mi'i ti toto mi'ahyk ahyk kape ipohag nug hamo e. Mi'i hawyi Iesui to'e — Pyno ereto ro i'ewywuat nug hamo ewanĩ­kaptia ky'e hamo e mekewat — Uwe waku wati­ky'e irania'in apo'e hat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mi'i hawyi Iesui temiit'in wywo put'ok­'i­'a­tu'e wẽtup tawa pe. Mi'i tote hary­poria Mata ehap het rakat — Eiwe­hyt'ok o ui'yat pe Mimi e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mi'i hawyi te'e­ru­we­hyt'ok hawyi mana Mata kypy'yt Maria toĩne'en Iesui yatype imienoi kapiat tuwa­nẽtup hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma'ato mana Mata ipotpap yn mi'u toi'a­tu­'anug kahato Iesui moenuk hamo. Ikypy'yt yt ipowyro i hawyi ipy'ahak ta'yn toky­py'yt ete hawyi to'e — Uipo­rekuat e uiky­py'yt Maria wyti yt uipo­wyro hin i e Iesui pe. Uiweran kahato uipotpap an e. Pyno etipo­'oro o uiky­py'yt Maria uipo­wyro hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mi'i hawyi Iesui tiwesat — Uiwy Mata uiwy Mata e eminug ko'i kape yn erewa­nẽtup kahato e. ");
INSERT INTO mavNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Waku wen ma'ato toĩne'en po'og waku hap uimi'u nug hap kai katu­pono Uito uiwy­wuaria uhehay kapiat wanẽtup haria waku wy uiwa­nẽtup hawe e. Uhehay kuap hap mana Maria ti'airo ra'yn e. Mi'i hawyi yt uwe i tihep kuap imiky­'esat uiwywuat hap e. Pywo kahato uikuap hap mana Maria piat wyti aru yt uwe i ihep kuap ui'ya­type tuwe­mu'e hap e Iesui mana Mata pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wẽtup e'at pe Iesui toto tehay teran Tupana wywuat hamo. Mi'i hawyi ihay kahato To'ywot wywo hawyi wẽtup ok ipotmu'e hẽtup Iesui pe — Urupo­rekuat urumu'e ro En Tupana kapiat Tupana wywuat uruehay hamuat hap ete e. Aikotã ahet'ok hat Iuwãu ti'a­tu­mu'e topot­mu­'eria hap ewy e katu­pono uruiky­'esat En ewywuat uruehay Tupana wywuat hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mio tã tohẽtup hawyi Iesui henoi ra'yn — Pyno Uimohey haria yt atiky­'esat i ehehay Tupana kape ewehu­'at'i hu'at'i eiwẽ­pap'i wẽpap'i ahut ewy hap yt atiky­'esat i e. Atiky­'esat ti ehehay eipy'a pyi Tupana wywo hap e. Mi'i e hap eipy'a piat waku ewei'e ma'ato emiky­'esat ewy hap ehehay ewy hap atiky­'esat e. Sa'a­wy'i waku wato'e — Uru'ywot Atipy piat waku kahato En waku wato'e. Uruimõ­typot kahato En waku wato'e e. Uruiky­'esat emõtypot hap mesuwat yi tote wuat'i miit'in py'a­setpiat eset mowato hap uruiky­'esat kahato waku wato'e. Tupana ereĩne'en no mesuwat yi toto Wuat'i Miit'in Potypot no mi'i hap uruiky­'esat. Uruiky­'esat kahato mesu­wa­ro­tiaria wuat'i ywania tunug emiky­'esat ewywuat hap aikotã atipy piaria tunug emiky­'esat hap ok tã hap uruiky­'esat waku wato'e e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tupana mesuwat e'at uruihẽtup epe urue'u'i mesu­wa­rotiat urumi'u hap uruhẽtup epe waku wato'e e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Urui'a­parap kahato ewawi Tupana mi'i pote uruhẽtup kahato ewawi waure wo ereĩne'en uruminug sa'ag ko'i ete hap waku ewei'e e. Tukup­te'en kahato uruma'at haria uruetiat i'aparap haria. Mi'i hap sa'ag ko'i ete waure wo teran urutu­kup­te'en haype aikotã En ereĩne'en waure wo eetiat uru'a­parap hap ko'i kai hap ewy katu­pono waure wo En ereĩne'en uruwe­te­weru epiat hap kai pote En ewywuat urutup­te'en neran waku ewei'e Tupana pe e. Mesuwat e'at pe i'atu kahato uruiã'ãg ahiag ehay wo yt naku i nug hamo mi'i pote urupo­re­roto uruiã'ãg hap sakpuo urukosap hamo katu­pono yt urutunug po'og teran i yt naku i nug hap waku ewei'e Tupana pe e Iesui topot­mu­'eria pe. Uiwy­ria'in waku mi'i e hap ok tã ewehẽtup turan Tupana kape ehehay Tupana wywo e ma'ato eipy'a pyi ehehay eimi­ky­'esat ewy yn waku. Yt atiky­'esat i ewehu­'at'i hu'at'i mesuwat uhehay e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mi'i hawyi Iesui to'e ahepe — Ai'ywot Tupana tum aru aimiẽtup ok tã ahepe e. Yt naku i aipohep Tupana piat aimiẽtup hap ko'i ete are e. Waku wahẽtup hẽtup i Tupana pe tutum ahepe hap kape e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ta'i mi'i hap ewy waku wahẽtup aikotã karãmuo put'ok'e ai'yat pe aiwy wãtym turan hesy'at kahato hap wywo hap ewy waku watipoi ma'ato aimi'u yt kat i pote waku watuwat aheka­tuwy yat kape hawyi waku wahẽtup aheka­tuwy yat piaria õ'ẽ haria poi hamo e. — Uhyt mana wato'e uruwy­ria'in tõ'ẽ iuẽpe uru'yat pe hawyi yt kat i urue'u'i turan i. Uruiky­'esat etipuru porap'i eikaipyi u'i uiwy­ria'in poi hamo hesy'at kahato pote waku mio tã wato'e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","— Ma'ato wãtym hake turan pote aiwesat to'yat pyi. — Watoket uhyt mana yt ehẽtup i ra'yn o u'i meikoran katu­pono wãtym na'yn katu­pono are'o­kenhyp ta'yn wyti urutoket ra'yn wyti e. Ta'i te'e­roket yne ra'yn wyti uimẽt­pyt'in ui'yat piaria. Pyno meiũpe urue'yni ko'i poity'i pote yt areto kuap i ra'yn ewawi emiẽtup ium epiat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma'ato mi'i hawyi — Eherut ro uhyt mana katu­pono uruwy mu'ap upiat put'ok'e rokirẽ hesy'at kahato wato'e i wato'e i kahato hawyi i'ãpe­'ok'am hawyi u'i tutum ahepe yt toket kuap i hawyi wahẽtup mot'i hawyi mi'i tu sake ti aru tut ahowawi u'i ium hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Pyno Tupana kape waku ahehay mi'i uhã'ãkap ok tã ahehay turan ahẽtup hẽtup kahato mekewat u'i ky'esat hap ewy ui'e hap ewy e. Mi'i pote ti aru tutum ahepe watikat kahato Tupana kape pote wati­puẽti aru e. Teg teg wato'e Tupana e'oken­'ypy ete hawyi aru to'o­kenhyp to'o­ken­'ypy hawyi aru tutum kahato aimiẽtup ewy wyti aru ahowawi e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta'i wahẽtup hẽtup mot'i hawyi Tupana tum aru ahepe are e. Watikat turan Tupana miium turan yt naku i aipohep aimiẽtup ete pyi mi'i pote wati­puẽti irane aimiẽtup ipo pyi e. Waku Uhyt Uhyt Uhyt Mimi Mimi Mimi wato'e pot'i hawyi to'o­ken­hyp'ok hap ewy wyti aru are e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Uipot­mu­'eria Tupana hegyi'at kahato pote tutum teran kahato aimi­hẽtup ahepe pãi are e. Ta'i karãpe aimẽ­pyt'in hẽtup u'i pira ahepe ta'a­tu­he­sy'at hawyi mi'i pote watum i'atu­miẽtup ko'i ahepiat i'atu­ky'e aimẽ­pyt'in mote e. Yt karãpe i yi ne'i watum yi aimẽ­pyt'in me u'i ẽtup ahepiat hawyi e. I'ewyte pira kã'ã ta'a­tu­hẽtup ahepe pote watum pira e. Yt karãpe i watum i'atuepe moi ne'i katu­pono wati­'a­tu­ky'e kahato aimẽ­pyt'in ko'i pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pyno aimẽ­pyt'in waipaka upi'a ta'a­tu­hẽtup pote hupi'a watum e. Yt karãpe i ti watum aimẽpyt pe sapot hupi'a tohẽtup hawyi are ma'ato toĩ pote i'atu­miẽtup ewywuat watum aha'y­ru'in me ahaki­'yt'in me e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ei'y­wot'in eity'in ni eipoi kahato eimiẽtup ko'i ewywuat. Yt naku i nug haria eity'in ei'y­wot'in pytkai waku yn ta'a­tunug neran ehepe eiky'e haype e. Pyno Ai'ywot atipy piat Tupana ti yt karãpe i sa'ag nug hat e. Waku Kahato rakat toĩne'en Ai'ywot Tupana e. Mi'i tupono ti aimiẽtup kat ko'i tomi­ky­'esat ewy yn aimiẽtup tutum. Wahẽtup Ipã'ãu Wakuat miky­'esat ewywuat pote tutum e. Mesu­wa­ro­tiaria yt nakuaria i pytkai hum kuap wakuap yn. Ta'a­tu­mõ'ẽ kahato mi'u wakuat ko'i ta'a­tu­mẽ­pyt'in me. Mi'i hap ewy ti po'og Ai'ywot atipy piat timõ'ẽ kahato po'og po'og ahepuo wahẽtup kahato hawyi aito imẽpyt'in mote e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pyno wẽtup e'at pe Iesui ipotpap kahato miit'in moehãite hap ete. Mi'i hawyi itote toĩne'en yt ihay kuap i rakat ahiag topiit piat pote rakat. Mi'i ti Iesui tisopo ra'yn hawyi ihay kuap i ra'yn. Mi'i pote irania'in itotiaria te'e­ru­wehum kahato Tupana ete. ");
INSERT INTO mavNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma'ato irania'in te'e­ro'e sa'ag Iesui ete itote — Ta'i ahiagnia akag esaika hamo mekewat ahiag potypot Peusepu aipusu puat hesaika hamo wyti Iesui ti'a­tu­sopo meiũwat miit piit piat ahiag i'atu'e sa'ag Iesui mohit hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Irania'in itote — Uhyt Mimi i'atu'e etunug no emisepap yt miit'in minug kuap i hap ewywuat iwato rakat atipy kaipywiat Tupana kaipyi hap uruiky­'esat i'atu'e. Yt miit'in minug kuap i iwato rakat merep hap ewy etunug paini ewywuat mi'i hawyi meremo — En Uruetu­pana uruto'e i'atu'e sa'ag hã'ãg hap ne'i. ");
INSERT INTO mavNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma'ato Iesui tikuap i'atu­wa­nẽtup hap sa'ag hawyi to'e — Wẽtup tama piaria tu'uka tu'uka kahato to'ope to'ope hawyi meiũran ti aru meiẽwat tama wo'o­ky'e hap esaika hap yt kat i ra'yn topy­hu'at itote e. I'ewyte getap wiaria tu'uka tu'uka to'ope to'ope hawyi meiũran yt kat i wo'o­wese hap topy­hu'at itote hawyi yt i'atu­potpap kuap i kat nug kat nug hap ete yt to'o­wesat i hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pyno — Ahiag koro Peusepu esaika hamo eti'a­tu­sopo ahiagnia ewei'e ti uhepe ma'ato ahiag akag emiit'in ko'i tu'uka tu'uka to'ope to'ope pote yt kat i to'o­wesat hap toĩne'en itote hawyi to'o­moma hap yn topy­hu'at itote irane e. Yt karãpe i ti tu'uka ahiag akag temiit'in ahiagnia wywo e. Ahiag akag yt to'o­sopo teran hin i ahiagnia wyti miit'in piit pyi ma'ato to'o­po­wyro to'o­ka­wiano hap yn ta'a­tu­ky­'esat e. Pyno yt eiwe'eg hin i are e. Kat pote som — En ahiag akag koro esaika hamo wyti eti'a­tu­sopo ahiagnia ewei'e katu­pono pywo ti rat ahiag koro yt ti'a­tu­sopo teran i temiit ahiagnia miit'in piit ko'i pyi uiminug ewy are e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pyno koitywy apo'e­wei'e eiwo­'ope — Kat esaika hamo som toi'a­tu­sopo ahiagnia e hap ete ewei'e uhepiat. Pyno ahenoi ehepe uwe esaika hamo ati'a­tu­sopo sopo ahiag ko'i sem hap miit'in piit pywiat hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pyno pywo ti rat Tupana esaika hamo ti rat ati'a­tu­sopo ahiagnia e. Ta'i Tupana po wo ati'a­tu­sopo ahiagnia are e. Tupana puĩ'ã wo ati'a­tu­pugha ahiagnia miit'in piit pyi are e Iesui. Mi'i pote ti Tupana topy­hu'at mesuwe Morekuat no i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Pyno ahiag ni yt toĩne'en kuap i po'og morekuat no miit'in piit pe katu­pono karãpeĩ uhesaika hap topy­hu'at surara akag koro hesaika kahato rakat ewywuat ahiagnia esaika hap moma kahato hano ti areĩne'en Tupana esaika hap ti toĩne'en uhehay wo. ");
INSERT INTO mavNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mi'i pote karãpe wẽtup ok surara koro toĩne'en to'yat pe tesu­rara sem wywo to'yat apykok haype mi'i hawyi yt uwe i heka­re'en sero'ok kuap surara akag wo toĩne'en itote pote i'ewyte tesu­ra­ra'in sem tukup­te'en itote pote hesaika hap pupi sero'ok ko'i te'e­ro­ken'ẽ kahato are e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Pywo pe ti uwe uwe yt uhupiat i hat uhewa­nĩ­kaptia wo te'e­ro­py­hu'at e. Yt uipo­wyro i miit'in atuekyi uhowawiat hamo pote miit'in sytpok uhowapyiat haria wo tukup­te'en are e. Ta'a­tu­sytpok ne'i uimohey hap kaipyi i'atuehay miky­ry'i uhetiat hap wywo pote yt uika­wiano hin i tukup­te'en are e. Mi'i hat ewywuat ereĩne'en pote uimohey haria sytpok haria wo eweikup­te'en uhewa­nĩ­kaptia sese wo eweikup­te'en are e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mi'i hawyi Iesui to'e ihay miky­ry'i tetiat haria pe — Eiperia aikotã ahiag ipiit piat rakat ewy eweikup­te'en e. Mi'i hawyi meiũran tuwẽtem na'yn mekewat ahiag mekewat miit piit pyi tuwepyi haype hawyi waku ra'yn toĩne'en hap ewy hawyi hewyry kahato yahig note teiam miit'in piit pakup kat hamo e. Ma'ato yt toipuẽti i tomi­ky­'esat ewywuat hawyi to'e tuwepe — Pyno ara'aipok irane sa'a­wy­'iwuat uheiam kape uimi­'atoiat miit piit kape e tuwepe hawyi mekewat miit piit sa'a­wy­'iwuat kape toto hawyi teke i ra'yn tomi­ky­'esat ewy e. Mi'i hap ewywuat eiperia e tehay pun haria pe. Mesup waku pe eweikup­te'en wen ma'ato meiũran ti ahiag hewyry kahato hawyi to'e tuwepe — Pyno ara'aipok i mesup sa'a­wy­'iwuat uheiam kape mi'i hawyi areke i mekewat sa'a­wy­'iwuat miit piit pe aikope areĩne'en sa'a­wy­'iwuat hap kape e tuwepe ahiag e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mi'i hawyi tut i ra'yn miit sa'a­wy­'i­tewuat toĩne'en hap kape. Mi'i turan toipuẽti i ipiit waku pe tuwe­painug turan ikahu toipuẽti yt kat i heso'ok hap toĩne'en itote. Pyno waku kahato toipuẽti mekewat miit aikotã ai'yat wahy­wytip rokire hap ewy toĩne'en mi'i miit piit aikotã ai'yat topen pakup i turan ikytsig kahato hap ewy e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mi'i hawyi ahiag sa'ag to'e towy­ria'in ahiagnia pe — To'iro watu­we­hyt'ok meiũwat miit piit pe e 7 ok takaria pe towy­ria'in ahiagnia sa'ag ko'i pe. Mi'i hawyi tuwe­hyt'ok ahiagnia 8 ok takaria e. Sa'a­wy'i wẽtup yn toĩne'en itote mekewat miit piit pe mi'i hawyi po'og po'og na'yn tukup­te'en kahato itote e. Mi'i hawyi mi'iria tukup­te'en at ka'ap mekewat miit piit pe. Mi'i pote po'og yt naku i sa'a­wy­'iwuat kai po'og heso'ok sa'a­wy­'iwuat kai toĩne'en hap ewy kahato mekewat miit e. Mi'i uhehay ewy kahato eiperia uhehay pun hanuaria e katu­pono yt uimohey teran i eipe yt kat i ahiag eipiit piat hawyi ati'a­tu­sytpok yne ahiagnia eipiit pyi hawyi e. Ma'ato yt uimohey i pote te'e­ra­'aipok i po'og na'yn ehowawi e Iesui tehay pun haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mio tã to'e hawyi wẽtup ok hary­poria miit'in tok pyi to'e Iesui pe tehay pirik hap — Mimi e uiwa­nẽtup hawe waku kahato ety Maria toĩne'en e katu­pono ety wo toĩne'en epoi temi wuat hat pote emotãg hat pote e. Emoherep topiit pywiat hat pote waku kahato ety e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mio tã e hawyi Iesui tiwesat tope — Mana waku uity wen ma'ato po'og waku Tupana wanẽtup hawe uimienoi kapiat wanẽtup kahato haria po'og Tupana mipoi­tyro ko'i mi'iria tukup­te'en uipiit moherep hat uity kai e Iesui ahepiat pe tomohey haria piat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mi'i hawyi miit'in sem te'e­ru­wa­'a­tunug po'og typy'i kahato Iesui ewawi wanẽtup hanuaria. Mi'i hawyi to'e i'atuepe — Are pãi e eipe eweikup­te'en mesu­wa­rotiat miit'in ehay yt uimohey reran i haria eipe Iuteu ywania uimotag haria pytkai e. Uikat kahato haria wo eipe ma'ato eipoi hamuat eimoe­hãite hamuat hap yn eweikat uikai wen ma'ato yt uikat hin i uhehay kuap hamuat are e. Eweiky­'esat kahato ti ewei'a­kasa uiminug Tupana misepap ko'i kape miit'in moehãite hap ko'i kape kat ko'i kat ko'i hap yt uwe minug kuap i ewywuat uiminug ko'i kape e. Eiperia seha'at sese hanuat õ'ẽ haria ne'i eipe e. Mi'i pote ti rat pãi yt atomo­herep teran i eimi­ky­'esat ko'i eweha'at hamo katu­pono yt uimohey teran i haype eweha'at teran yn pote e. Mi'i pote wẽtup yn aru uimi­sepap iwato aru atimo­herep ehepe yt uwe i te inug nakat katu­pono uiku­'uro sese hawyi areĩne'en pakup i hap yn ti aru atomo­herep ehepe aikotã aikotã sa'a­wy­'iwuat Tupana ehay moherep hat Iona e hap het rakat ewy aru areĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sa'a­wy­'iwuat Tupana ehay moherep hat Iona Tupana tipo­'oro tawa Niniwe kape yt naku i rakaria kape wẽtup ywania kape. Pyno apo'are — Kat pote Iona Pira wato hunmỹ'ã pe mye'ym e'at pe toĩne'en hap ete e. Pira wato hunmỹ'ã pe toĩne'en mye'ym e'at. Mi'i hawyi pira te'en ne'i yi Niniwe pe hawyi Iona tuwẽtem na'yn. Mi'i hap tawa Niniwe piaria tikuap ta'yn hawyi ta'a­tukuap pywo Iona ti Tupana mipo­'oro hap. Mye'ym e'at pe iku'uro pira hunmỹ'ã hawyi tuwẽtem e. Mi'i hap ewy aru atunug e. Uito ti Miit'in Yke'et Sese e Iesui mi'i hawyi arẽtem gu'uro pyi i ra'yn hawyi aremo­herep i aru ehowawi Iona ewy e. Mye'ym e'at hap ete uiku­'uro hawe yi hunmỹ'ã pe uisyp hawe arepy­hu'at mye'ym e'at hawyi arẽtem gu'uro pyi hawyi eweikuap aru pywo Uito Tupana Mipo­'oro Miit'in Ehakye­ra'at Hanuat hap are e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sa'a­wy'i sese wẽtup ywania porekuat hary­poria kawiat tut pya pyi at wẽtem hap moran kai tut morekuat pot Sarumãu we'eg hap kapiat tuwa­nẽtup hamo ihay se kuap hamo tut e. Meiũran ti aru karãpeĩ Tupana henoi uwe waku uwe yt naku i e hap e'at piat turan toĩne'en itote sa'a­wy­'iwuat morekuat hary­poria kawiat eiminug yt naku i hap enoi hanuat e katu­pono sa'a­wy'i pya pyi tut morekuat Sarumãu kapiat iwe'eg hap kapiat tuwa­nẽtup hamo ma'ato koitywy Uito areĩne'en eipy­'a­setpe po'og uiwe'eg ase'i morekuat Sarumãu kai ma'ato uhehay kape yt eweiwa­nẽtup teran hin i ra'yn eipe e. Mi'i pote mekewat wẽtup ywania po'og waku Tupana wanẽtup hawe eikai e. Mi'i pote mekewat e'at pe aru — Kat pote yt eweimohey i Tupana Mipo­'oro Sarumãu Saipepiat e aru ehepe mekewat morekuat hary­poria kawiat yi Sapa piat eiwe­mõti hamo e Iesui tehay pun haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","I'ewyte meiũran ti aru mekewat Tupana uwe waku uwe yt naku i e hap enoi hamuat hap e'at pe ti aru tawa Niniwe piaria henoi — Eipe yt nakuaria i i'atu'e ehepiat katu­pono sa'a­wy'i mi'iria te'e­ru­wa­nẽtup Tupana ehay enoi hat Iona mienoi kapiat hawyi te'e­ra­'aipok kahato Tupana kape. Ma'ato eiperia yt ewei'aipok hin i Tupana kape Uito ti rat po'og Iona kai pytkai e. Ta'i eipy­'a­setpe areĩne'en wen ma'ato uimienoi kape yt eweiwa­nẽtup hin i e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mi'i hawyi po'og Iesui henoi — Yt uwe i mig'i wo hytmoi ariãty hot hap e. Yt ta'a­tupag hin i kamũti ka'a pe ma'ato ipytyp sese pe yn ta'a­tupag ariãty hot hamo e. Mi'i hawyi wehyt'ok haria te'e­ra­'a­kasa ra'yn hawyi teha'at kuap heremo hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yne heremo aheha pytig pote. Ihot'ok hawyi aheha ko'i wo wata­'a­kasa kuap yne ra'yn e. Mi'i pote eheha ko'i ariãty ewywuat eipiit piat moẽtyhot hamo e. Waku aheha ko'i pote waku kahato heremo kahato yne yne ma'ato yt aheha pytig i yt kat i heremo ahepe. Wati­ky­'esat mu'ap kuap hamo ma'ato aho'o­wasat hap ewy watoĩ­ne'en at toĩne'en pytkai are e. Eipy'a piat uimohey hap hawyi eheha wakuat ewywuat toĩne'en hawyi heremo kahato mu'ap Tupana kapiat hap ma'ato yt naku i ky'esat haria eipe pote ariãty yt nakuat i ewywuat eipy'a pe toĩne'en. Mi'i pote sa'ag hap yn eweikat are e. Mi'i hawyi eipiit puo i'ypyryp we sese topy­hu'at e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yt naku i hap nug neran haria eipe pote yt eheha pytig i rakaria ewywuat eweikup­te'en e. Mi'i pote i'ypyryp wiat gupte'en haria ewy eweikup­te'en kahato eipe hawyi eipiit puo eheĩne'en hap yt naku i pe topy­hu'at e. Mi'i pote Tupana kuap hap yt kat i eipy'a pe yt uimohey i eipe pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Waku hap yn eweiky­'esat pote eheha ko'i ariãty wakuat ewywuat topy­hu'at e. Mi'i hawyi yt kat i i'ypyryp hap eipiit pe. Eheĩne'en hap ete hẽtyhot hap yn ehete e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesui piat ta'a­tu­nãpin kahu turan put'ok'e Musei miwan enoi hat hawyi to'e — To'iro ui'yat kape watenuk hamo e. Mi'i hawyi Iesui toto ra'yn hupi i'yat kape. Put'ok­'i­'a­tu'e hawyi ta'apyk yparakai ypyke ma'ato yt tuwe­posei i tenuk hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mi'i pote Musei miwan enoi hat tuwa­nẽtup — Kat pote som yt tuwe­posei i Iesui aheko ewy e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mi'i hawyi Iesui to'e — Tupana miky­'esat ko'i toĩ yne miwan me wen mi'i hap ko'i eweiwaure hawyi wẽtup sehay ehenoi e. Eipe ti eheko wẽtup enoi kahato haria e. Eheko upi eiwe­piitsei sei kahato eiwe­posei kahato eikoho koho kahato hawyi — Waku kahato aito mesup Tupana wanẽtup hawe ewei'e eipy'a pe e. Ma'ato yt mi'i tã hin i are e. Eiperia ahekui'a ko'i ipitpit kahato hap ewywuat are e. Aikotã eiwe­kui­'a­koho kahato i'okpe ete ma'ato ehekui'a py'a yt eiwepyi hin i mi'i pote mi'u nem ipy'a pe toĩne'en hap ewy e. Eipo pe ete waku kahato yt ipitpit hin i ma'ato eiwa­nẽtup hawe ipitpit hap ewy toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","— Yt we'eg i kahato rakaria ti rat eipe e. — Pyno Tupana aipiit nug hat pote waku aipiit sei hap watunug at ka'ap imowepit hamo ewei'e eiwo­'ope e. Ma'ato pywo pe are'e ehepe aiwa­nẽtup hap aipy'a piat nug hat Tupana toĩne'en wy are e. Mi'i pote waku aipy'a piat aiwa­nẽtup hap sei hap watunug at ka'ap wy imowepit hamo are e. Ma'ato eipy'a ipitpit hap ywytip hap eweiwaure kahato ra'yn e. Eiwa­nẽtup hap eipy'a ko'i ipitpit kahato eiminug sa'ag ko'i wo e. Yt eiwe'eg hin i ti rat katu­pono eipiit painug hap yn ewetunug ma'ato eiwa­nẽtup hap eipy'a piat painug hap yt kat i Tupana wanẽtup hawe are e. Eipiit ko'i ikahu kahato yt ipitpit hin i wen ma'ato eipy'a ko'i yt ikahu hin i eiminug sa'ag ko'i wo e. Eipitpit kahato eiwa­nẽtup sa'ag ko'i wo e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ta'i eiwepyi kahato ehekui'a ko'i ok pe ete ma'ato yt eiwepyi hin i kat som nem toĩne'en ehekui'a ko'i pe hap e. Waku po'og aiwa­nẽtup hawe — Pyno waku ati'a­tu­mõ'ẽ uimi'u uheka­re'en yt hekat i rakaria pe hatek takaria pe mi'i hawyi Tupana mowepit hat areĩne'en e hap kape po'og waku watu­wa­nẽtup at ka'ap — Uiposei sio yt e hap kape yn watu­wa­nẽtup hap kai are e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mi'i hawyi po'og Iesui to'e — Urutunug uruposei hap pote po'og waku urutoria eikai e haria eipe e Iesui tewa­nĩ­kaptia pe mi'i pote eipe ti rat yt naku i po'og Tupana wanẽtup hawe e. — Ta'i wẽtup hyt u'i 10 hyt u'i kaipyi atum Tupana pe pote po'og waku uito irania'in kai ewei'e ne'i ma'ato Tupana — Yt naku i kahato eipe e. Eipe eimi'u apopyt hit kaipyi eweiho'oium Tupana pe hawyi — Waku po'og tora­nia'in kai urutu­kup­te'en ewei'e eiwo­'ope ne'i wen ma'ato Tupana ky'e hap ete i'ewyte miit'in ky'e hap ete waure wo kahato eweikup­te'en e. Waku watum Tupana aimiium wẽtup hyt 10 hyt ahe'u'i hap kaipyi ma'ato po'og waku watum aipiit yne Tope waku po'og wati­'a­tu­ky'e miit'in e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","— Ta'i eipe ti irania'in miat eimõ­typot hap yn eweiky­'esat haria eipe ma'ato Tupana piat eimõ­typot hap yt eweiky­'esat hin i haria eipe e. Tupana eimõ­typot hap yt eweikat hin i hawyi e. Tupana mõtypot yat pe ei'apyk hap po'og wakuat irania'in kawiat hap eweiky­'esat e. I'ewyte yne tawa pe mu'ap upi ehekat kyi'at hap tote miit'in wẽpowat kahato hap eimõ­typot hamuat hap yn eweikat at ka'ap ma'ato Tupana piat eimõ­typot hap yt eiwekat hin i e. Yt naku i are mesu­wa­ro­tiaria kaipywiat yn eimõ­typot hap toĩne'en hawyi yt kat i Tupana kaipywiat eimõ­typot hap toĩne'en e Iesui wo'o­mu'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aiko­hye­wyry tuereto wo'osyp hap tote turan yt watikuap hin i aikope aikope iku'uro rakaria toĩne'en yi pe aimisyp ko'i sa'a­wy'i katu­pono yt heremo i te itote e. Mi'i hap ewy kahato eiperia e. Ta'i eipe ti wo'osyp hawiat hap gupte'en haria yt heremo i rakat ewywuat are e. Ta'i miit'in te'e­ru­wa­nẽtup eimienoi kape ma'ato ehehay kaipyi yt ta'a­tukuap hin i Tupana hawyi i'atu­mohun hap yn topy­hu'at eimienoi kaipyi e. Eimienoi iku'uro rakat nem nakat ewy e wẽtup sehay moherep haria pe yt Tupana e hap ewywuat moherep haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pyno itote toĩne'en wẽtup ok miit uwe waku uwe yt naku i e morekuat piat hat. Mi'i hawyi to'e Iesui pe — Are pãi etimohit kahato urumu'e haria akag ko'i i'atu­minug sa'ag hap ete Uhyt e. Pyno kat som ere'e teran uruepe sio uruto waku sio yt sio uruto irania'in aimu'e haria akag ko'i ewy ewanẽtup hawe sio yt katu­pono uruto po'og morekuat ehay kuap haria tora­nia'in kai sio miit ti'a­parap morekuat ete sio yt e haria uruto pote e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mi'i pote Iesui tiwesat — Yt uheso i uhyt e. Eweikuap kahato miwan eiperia e. Kat som waku miit'in tunug kat som yt naku i hap e. Mi'i hawyi uruikuap po'og irania'in kai ewei'e. Mi'i hawyi miit'in airo haria eweikup­te'en miwan moherep hap kaipywiat haria wo eweikup­te'en e. — Wãi wãi'e­wei'e hap yn miit'in kape — Yt etunug nei'o ewei'e hap yn mi'i pote waku nug haria yt tunug kuap i wakuap katu­pono waku nug haria pyhyp haria eweikup­te'en morekuat e hap kaipyi e. Yt uheso hin i mehĩ eiperia ti eweikup­te'en aikotã ipotyi rakat ewy eiwo­'o­'apyk miit'in okpe tote haria ewy hawyi yt ta'a­tu­hupit kuap i ti ehehay ipotyi rakat are e. Eweipo­rokpun yt hekat i rakaria okpe tote morekuat ehay ipotyi rakat hawyi — Ewetunug o morekuat e hap ewy ewei'e ma'ato yt pote surara po pe uruipag eipe ehaty'i haty'i hamo ewei'e e. Morekuat ehay nug hap ete yt eweipo­wyro hin i hatek takaria e. I'ewyte yt ewetunug hin i ti morekuat piat einãpin hap ko'i eimi­mo­herep hap ko'i e hap ewywuat e. Mi'i pote typy ihay rakaria ewy eweikup­te'en are e. Pyno ti eimienoi aikotã aikotã ipotyi kahato rakat ewy — Ewetunug no ewetunug no ewei'e hap yn uruepiat ei'a­tu­nãpin hap ewy ewetunug o ewei'e ma'ato ti i'ewyte eipe yt ewetunug hin i ei'e hap ewy irania'in miat ei'e hap ewywuat e mi'i pote ti Tupana wanẽtup hawe yt nakuaria i sese eipe e. Mi'i pytkai yt eiwe­mõti hin i eha'a­se'i minug sa'ag ko'i ete katu­pono eha'a­se'in ko'i tukup­te'en ei'e­wy­wuaria ko'i e. Sa'a­wy­'i­wuaria ei'y­wot'in ti'a­tu­'uka kahato Tupana mipo­'oro ko'i e. Ta'a­tu­moma teran kahato Tupana ehay moherep haria ko'i e. Mi'i hap ewy te ti eiperia eweikup­te'en aha'a­se­'i'in sa'a­wy­'i­wuaria ewy te eweikup­te'en Tupana ehay moherep haria auka haria eperia are e Iesui more­kuaria wãi'e hap moherep haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yt nakuaria i kahato eipe. Yt eiwe­mõti hin i eha'a­se­'i'in minug ko'i ete. Sa'a­wy'i ta'a­tu­'a­tu­'uka kahato Tupana ehay enoi haria Tupana mipo­'o­roria ko'i e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mi'i hawyi eipe ewei'a­tu­mo­kahu eha'a­se­'i'in mi'a­tu­'uka syp hap ko'i e Tupana mipo­'oro tehay moherep hamuat syp hap ko'i. Mesup ti ewei'a­tu­mõ­typot kahato eha'a­se­'i'in mi'a­tu­'uka ko'i wo'osyp hawiat i'atu'kag ko'i katu­pono eiwe­mõti kahato eipy'a pe eha'a­se­'i'in minug sa'ag ko'i ma'ato ei'y­wot'in ewy te eweikup­te'en katu­pono mesup te ti ewei'a­tu­'uka teran Uito i'ewyte yne Tupana mipo­'oro ko'i are e. Yt nakuaria i sese ti eipe — Uruto po'og torania kai ei'e pytkai e. ");
INSERT INTO mavNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ta'i aikotã aikotã tohenoi sa'a­wy'i miwan me ehetiat hap ewy mesup ewetunug e. Mio tã e ti sa'a­wy'i Tupana — Uhemiit'in irania'in ta'a­tu­'auka e. Irania'in ti ta'a­tu­sa­ty'i saty'i yne irania'in ta'a­tu­mohit mohit e Tupana ti miwan me ehepiat pe e Iesui to'auka teran haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pyno ti koitywy ehepiat Tupana ihay mekewat miwan me sa'a­wy'i — Ta'i koitywy ei'y­wot'in mi'auka uimi­po­'oro ko'i suu ko'i yne yne eipo ete te topy­hu'at e. Ehepe yt heremo i ma'ato uheha pe ti tuwekuap uhemiit suu yn ni eipo ete e. I'ewyte ti mesup te ti eweikup­te'en uimi­po­'oro atu'uka rakaria e. Ta'i ei'y­wot'in ewywuaria eipe eweikup­te'en e. Ha'a­wynug hap tote­pyi­wiaria te wẽtup ywania yn mesup te eweikup­te'en. Yt uheso hin i uhyt'i'in. Tupana mi'a­piheg kahato ko'i aru eweikup­te'en wuat'i e'at pe e. Katu­pono eha'a­se'i'in minug upi ewetunug ne e. I'atu­sai­pe­piaria sese te ti eweikup­te'en e Iesui to'auka teran haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Sa'a­wy'i sese ti aha'a­se'i pot Atãu sa'yru Apeu eha'a­se'i Kãi ti'auka toywyt Tupana mohey sese hat Apeu. Toipun kahato toywyt suu yi tote. Mi'i hap ewy te Tupana mipo­'oro ko'i ewei'a­tu­'uka e Iesui to'auka teran haria pe. Sa'a­wy'i Tupana mipo­'oro ase'i Sakaria ei'y­wot'in mi'auka wo toĩne'en. Ipotpap kahato Tupana mõtypot hap etiat. Tupana mõtypot hap yat etiat turan toiwuk yne miit'in miium Tupana kapiat hawyi tuwẽtem Tupana ehamo turan ei'y­wot'in ti'auka ra'yn Tupana mõtypot yat pe e. Ta'i sa'a­wy­'iwuat Tupana mohey hat Apeu ta'a­tu­'auka i'ewyte Tupana mipo­'oro Sakaria ta'a­tu­'auka wy i'ewyte irania'in Tupana mipo­'oro ko'i ta'a­tu­'a­tu­'uka kahato ei'y­wot'in mi'auka ko'i tukup­te'en e. Pyno mesup te ti eiperia ei'y­wot'in ewywuat eweikup­te'en ne e Iesui to'auka haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yt naku i wo kahato eipe miwan moherep haria ete are e. Eipe ti rat oken'ypy pyhyp haria ewywuaria Tupana mienoi ko'i ete are e. Eweikuap kahato Tupana ehay Musei mimo­herep po'og torania kai. Irania'in tikuap teran Tupana etiat ma'ato yt ewehenoi hin i irania'in me e. Tupana kuap teran haria mesuwe tukup­te'en ma'ato yt eweho­'o­ken­hyp'ok hin i iky'esat haria pe. Ta'i mu'ap Tupana kapiat eweikuap wen ma'ato yt eweiwat i mi'i upi i'ewyte yt ewehenoi hin i irania'in me e. yt ewehenoi hin i mu'ap Tupana kuap hamo i'ewyte yt eiwe­hyt'ok hin i wy mekewat oken'ypy puo hawyi seke teran haria pysokpun haria eweikup­te'en e Iesui — Uwe waku mi'a­piheg wo uwe'in yt e haria morekuat piat haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mio tã Iesui to'e hawyi i'atu­py­'ahak sese Iesui ete nagnia ehay enoi haria i'ewyte miwan enoi haria i'atu­py­'ahak kahato mio tã e pote. Mi'i hawyi apo apo'i­'a­tu'e kahato at Iesui pe kat ehay kat ehay pirik kahato itote Iesui ete tu'uka teran haype. Ta'a­tu­ky­'esat sehay Iesui kaipyi iwema'at hap i'auka hamuat hap ta'a­tu­mõ­py­'ahak teran Iesui hap ma'ato yt toi'a­parap hin i towesat hap ete. ");
INSERT INTO mavNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mi'i hawyi yt ta'a­tu­waure hin i ta'a­tu­py­'ahak Iesui ete. I'aparap hap ta'a­tu­ky­'esat haype ta'a­tukat kahato. Ta'a­tu­ma'at hap yn ta'a­tu­ky­'esat. Mi'i pote mig'i wo teran Iesui ta'a­tusat i'ypyryp wyi aikotã wamiri ewy tukup­te'en Iesui pytyp teran hap ete i'aparap hap ta'a­tukat kahato ihay kaipyi ma'ato ti yt ta'a­tu­puẽti i hawyi ta'a­tu­henoi teran sura­ra'in miat i'auka Iesui i'aparap hap ta'a­tukat hawyi ma'ato yt ta'a­tunug kuap i katu­pono Iesui waku yn ihay waku yn tutunug mote. ");
INSERT INTO mavNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mi'i hawyi miit'in sem kahato te'e­ru­wa­'a­tunug Iesui ewawi ta'a­tu­moe­hãite hap ta'a­tu­ky­'esat kahato. Mi'i pote to'o­pykit pykit ne'i i'atu kahato hemig neran haria. Mi'i hawyi Iesui to'e temiit'in me — Eiwe'eg wo'o Tupana ehay ran enoi haria pupi e. Mi'iria typy sehay enoi haria e. — Uruto po'og urikuap Tupana ehay torania kai i'atu'e. Mi'i hawyi — Waku kahato eipe i'atu'e ta'a­tu­pot­mu­'eria pe ma'ato — Yt nakuaria i eipe e Tupana i'atue­mi­mu­'eria pe pytkai e. Ta'a­tu­su'at kahato Tupana wenãpin miwan miat wen ma'ato yt ta'a­tunug hin i aikotã Tupana to'e hap ewy. — Waku kahato uruto i'atu'e miit'in me hawyi — Pywo ti rat waku kahato eipe e irania'in mi'iria pe ma'ato — Yt naku i kahato eipe e i Tupana mi'iria pe katu­pono Tupana piat ainãpin hap ta'a­tu­su'at kahato pytkai yt naku i kahato ta'a­tunug mig'i wo. Sehay ikahu kahato rakano ta'a­tu­henoi wen ma'ato i'atu­minug ko'i yt naku i kahato e. Typy hẽku rakaria ewywuaria mi'iria yt ewetunug nei'o mi'iria ewywuat are. Ta'i manĩ puk ko'i ewywuat ne'i mi'i haria are e. Manĩ kurin kat ipyp takat watopag manĩ pakup we hawyi toimo­'okpuk ne'i ipakup takat e. Pyno eipe ti yt eiwe'eg i pote i'atu­minug sa'ag ko'i timo­wato ne'i aru yt naku i nug ehepiat hamo e. Pyno waku eiwe'eg wo i'atu­minug ko'i ewywuat nug hap pupi are e katu­pono mi'iria ti manĩ puk ewy meiũran ti eipe ei'e­wyte eweikup­te'en mi'iria ewy e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","I'ewyte yne huwy piat ewywuat i'atu­minug ko'i mig'i wo i'atu­mi­'a­pyhik ko'i meiũran aru Tupana ti'a­tu­mo­herep wuat'i ehamo e. Meiũran ti aru heremo kahato i'atu­minug sa'ag mig'i wo topy­hu'at wuat'i mikuap mo are e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kat ewei'e som i'ypyryp we meiũran ti aru Tupana timo­herep wuat'i miit'in ehamo sio waku sio yt hap are e. Aikotã wati­mo­herep ahehay ywaiti hap totepyi aheypa­rakai ywaiti hap kaipyi hap ewy toimo­herep aru wuat'i miit'in minug sa'ag wuat'i miit'in minug wakuap tehay wo wuat'i miit'in ehamo wuat'i miit'in ikuap hamuat e. Aikotã more­kuaria mipo­'oro sehay ewywuat Tupana timo­herep wuat'i ehamo i'atu­minug sa'ag sio i'atminug wakuap e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Uiwy­ria'in miit'in miat ei'auka hap pupi yt eweiken'ẽ tei'o katu­pono eipiit auka hawyi yt kat i ra'yn po'og ta'a­tunug kuap ehete ei'auka hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma'ato Tupana pupi waku eweiken'ẽ kahato katu­pono Mi'i ti eipiit toi'auka kuap i'ewyte toipugha kuap eipe aria koro pe aikope eho'opot hap toĩne'en wuat'i e'at hawe e. Mi'i pote waku Tupana pupi eweimõ­typot kahato po'og po'og miit'in kai e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ma'ato Tupana aiky'e kahato e Iesui. Pywo kahato toi'a­tu­ky'e wuat'i miit'in. Miit'in yt uwe i miky'e ko'i toiky'e kahato e. Ta'i miit'in ky'e kahato hat Ui'ywot e. Po'og aiky'e irania'in aiky'e haria kai. Ta'i ahetama pe wati­we­neru ra'yn weitaria hit ko'i ha'up yt iwato hin i ha'up typy ape kurin nakaria put'ok'e 5 weita hit kyi'at hamo wato'e mesuwe yt ha'up kahato rakat i miit'in wanẽtup hawe weita hit aimi'u apopyt wato'e. Yt kan hamo i weitaria miit'in i'atu'e ma'ato Tupana py'a pe waku kahato yne tominug ko'i e. Ta'i toi'a­tu­ky'e kahato weitaria ko'i e. Yt toiwaure hin i weitaria apykok hamo e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yt eweiken'ẽ tei'o uiwy­ria'in katu­pono eipe ti po'og kahato weitaria kai eiky'e Tupana e. Pyno aikuap kahato Tupana aiky'e haype are e. Ta'i toikuap yne ahetiat e. Ta'i toi'a­tukuap kahato yne ahepiat. Aipiit yne ete toikuap. Karania karania ai'asap ko'i etiat toikuap yne. Wẽtup ai'asap ta'at yi tote hawyi toikuap are. Mi'i hap ewy aikuap Tupana e. Mi'i pote yt naku i wato­ken'ẽ miit'in pupi sio ai'auka sio yt hap pupi katu­pono ai'a­pykok kahato Ai'ywot atipy piat e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Pywo are'e ehepe uwe uwe yt token'ẽ i uimohey hap moherep hamo ahewa­nĩ­kaptia ehamo ai'auka teran haria pe mi'i e hat piat — Uhemiit kahato mi'i miit are'e kahato atipy pe Ui'ywot pe e. Mi'i miit piat yt aremõti hin i e. Uito areĩene'en Eheyke'et Koro i'ewyte Eikywyt Koro wuat'i e'at pe uimohey hap eweimo­herep miit'in me — Ui'auka pote ui'auka ma'ato yt aremõti hin i Uimi­mohey moherep hamo e hat pe — Aimohey hat sese mekewat miit are Ui'ywot sese atipy piat pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma'ato — Yt atimohey i ewei'e irania'in me uhepiat — Ui'auka aru atimo­herep Uheyke'et Wato Uikywyt Wato i'atuepe hawyi ui'auka hap pypi areken'ẽ ewei'e hawyi i'ewyte Uito ahenoi Ui'ywot Atipy piat i'ewyte yne Tupana yatypiat ieĩne'en haria itotiaria pe mio tã e hat etiat — Yt Uimohey kahato hat i mi'i miit are'e aru itotiaria pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pyno ehehay sa'ag uhetiat Eheyke'et Koro etiat Eikywyt Koro etiat i'ewyte sa'ag ewetunug uhete mi'i pe ehẽtup Tupana pe paa'e­wei'e hap wywo pote Tupana tiwaure kuap eiminug sa'ag ko'i uhetiat hap wen ma'ato wẽtup ei'e sa'ag hap Tupana yt tiwaure kuap i are. Karãpe Tupana Pã'ãu to'e ehepe — Eweimohey ro Uha'yru mi'i hawyi ewei'e Tupana Pã'ãu Wakuat pe — Eso ewei'e motoro yt atiky­'esat i e'e hap katu­pono ahiag mẽpyt ri Emimo­herep Iesui ewei'e sa'ag eipy'a pe Tupana Pã'ãu Wakuat pe pote Tupana yt karãpe i waure wo ei'e hap sa'ag eipy'a piat Topã'ãu miat ei'e hap etiat are e Iesui tuwepiat. Pyno eiwe'eg wo'o — Eso ei'e Tupana Pã'ãu miat eimu'e turanuat uhepiat hap pupi katu­pono pywuat sehay yn tohenoi uhetiat e Iesui — En ni ahiag mẽpyt e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Uipot­mu­'eria meiũran ti aru ehero­po'ok te'e­ru­wa­'a­tunug hap kape Tupana mõtypot yat kape ta'a­tu­'a­kagnia py'a­setpiat — Mi'iria yt naku i kahato rakaria ta'a­tu'e hamo eima'at sehay wuat ei'auka hamo eheroto surara kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mi'i turan eheroto turan — Kat are'e aru ati'a­tu­wesat yt ewei'e i tei'o eipy'a pe eiwa­nẽtup hawe are katu­pono aikowat wakuat wyti aru i'atu­wesat hamuat Tupana Pã'ãu henoi ehepe aru itote ihay aru to'e hap ok tã ma'ato eiwẽ pyi ihay e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mi'i hawyi wẽtup ok miit'in tok pyi to'e Iesui pe — Urumu'e hat e ui'ywot wyti iku'uro ra'yn ma'ato ui'ywot ekare'en yt kat i tutum uhepe ma'ato uheyke'et pe tutum yne hawyi mesup uheyke'et yt ho'oium neran hin i uhepe ui'ywot powat'yp pãi — Uiano uiano are'e pytkai yt toipat'ok hin i e. Mi'i pote atiky­'esat kahato ehay ro — Eho'o­pat'ok to e'ywot ekat eywyt pe ere o uheyke'et pe e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mi'i hawyi Iesui tiwesat — Are pãi Uito wyti yt atimõ'ẽ teran i ei'ywot ekare'en ko'i ehepe uhyt e. Yt ariot i mesuwat yi kape irania'in ekat mõ'ẽ hamo e. Pywo ti rat ewe'eg wo o eheyke'et ekat ky'ewi hap pupi are'e epe uhyt e. Tupana yt uipo­'oro i mesuwe e'ywot ekare'en mõ'ẽ hamo pãi e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mio tã to'e hawyi tohenoi yne itotiaria pe — Eiwe'eg wo o meimuẽwat eheka­re'en iwato kahato ky'e kahato hap pupi e. Uhekat kahato teran eweiky­'esat ma'ato eheĩne'en hap sese yt eweikat hin i hawyi yt eweipuẽti i wyti aru ehekat wuat'i e'at piat hap e. Mesu­wa­rotiat eheka­re'en iwato kahato hap kaipyi yt eweipuẽti hin i eipy'a piat eimo­wepit hap sese hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mi'i hawyi hã'ãkap wuat tohenoi ahekat ky'ewi hap etiat. Mio tã to'e Iesui — Sa'a­wy'i so toĩne'en wẽtup ok iko iwato kahato rakat i'atu'e. Mi'i hawyi so toi'a­tukoi kahato yne te'yi koro tote hawyi so tuwenug kahato ra'yn manĩ itote i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mi'i hawyi so tutunug kahato u'i hawyi i'atu kahato u'i hyt ahyt ko'i sem tutunug at ka'ap hawyi — Aikotã som waku atunug aru e katu­pono Uhe'u'i hyt ahyt kahato ra'yn e so topy'a pe. Ui'yat ko'i yne yt put'ok'e hin i uhe'u'i hyt ahyt ereko hamo e so. Pyno aikotã aru atunug aru e topy'a pe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mi'i hawyi to'e tuwepe — Pyno atikuap ta'yn aikotã waku uhe'u'i hyt ahyt sem atimoheg wuat'i e'at pe e. Pyno waku atunug kahato uhe'u'i hyt yat koro ko'i hawyi waku uheypa­rakai sem itote atunug uhe'u'i hyt ahyt sem ko'i ereko hamo e so tuwepe. Pyno waku ati'a­tu­pugha uhe'u'i yat pot ko'i hawyi po'og iwato ikahu rakaria ati'a­tunug kahato uhe'u'i hyt ahyt sem ereke hamo e so. ");
INSERT INTO mavNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mi'i hawyi ti aru uimo­wepit hap toĩne'en wuat'i e'at pe katu­pono yt karãpe i aru yt uimi'u i hap toĩne'en uikai e so tuwepe topy'a pe tuwa­nẽtup hawe e. Ta'i waku ra'yn waku ra'yn wuat'i e'at pe e. Uhe'u'i iwato sese sakpo ra'yn mesup waku pe ra'yn aru areĩne'en pãi e so. Ui'ok hap yn aru toĩne'en e. Mi'i pote uheĩne'en hap waku pe areĩne'en u'i hyt ahyt sem pote e so topy'a pe tuwehum kahato tuwe­wawi haype. Mesup ta'yn yne uimi­ky­'esat ok tã wuat'i e'at pe atikyi'at kuap e so u'i sa'up mo e so. Pyno waku uipohep ta'yn wyti aru uipotpap hap ko'i ete pyi hawyi uiwepit hap yn na'yn atikat hawyi arenuk at ka'ap uimie­reko iwato kahato e. Karania e'at kapiat ne'i mi'i ra'yn uheka­re'en e so topy'a pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mi'i hawyi Tupana to'e tope atipy kaipyi — Yt ewe'eg i kahato rasig e katu­pono mesup ewãtym wyti eku'uro hap toĩne'en are e u'i wo hekat rakat pe. Mi'i hawyi apuru uwe po pe ekare'en ko'i sem topy­hu'at e Tupana tekat iwato mohey hat pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mio tã e hã'ãkap wuo tohenoi hawyi to'e itotiaria pe tomi­mu­'eria pe — Mi'i ewywuat te'e­ro­py­hu'at mesu­wa­ro­tiaria ta'a­tue­ka­re'en etiat yn wehum haria e. Mi'iria yt hekat rakaria i Tupana wanẽtup hawe e. Te'e­ru­wa­nẽtup kahato ta'a­tue­ka­re'en ete hawyi i'atu­wa­nẽtup hawe yt put'ok'e i Tupana kapiat te'e­ru­wa­nẽtup hamo e Iesui itotiaria wa'a­tunug sok haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mi'i hawyi Iesui henoi i ra'yn topot­mu­'eria pe — Uiwy­ria'in e yt naku i watu­wa­nẽtup yn aimi'u mesu­wa­rotiat kape e. Yt naku i aipiit piat ehesokpe ko'i kape yn watu­wa­nẽtup e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Katu­pono aheĩne'en hap wuat'i e'at piat aimo­wepit hap wuat'i e'at piat yt tut i aimi'u iwato kahato hap kaipyi i'ewyte aipainug hap kaipyi aimo­wepit hap yt tut i e. Aiwepit sese hap yt tut i ahesokpe aipainug hap kaipyi are e. Ta'i aimi'u sese ahesokpe sese ti tut Tupana miium kaipyi are. Mi'i ti po'og waku watikat aimi'u ko'i kai ahesokpe ko'i kai are e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Eiwe­ha'at ro weitaria ko'i kape e. Yt te'e­ru­we­mi'u koi kuap i wen ma'ato Tupana ti'a­tupoi kahato weitaria ko'i are e. I'ewyte yt kat i u'i hyt ko'i ta'a­tue­reko aito ewy ma'ato Tupana ti'a­tupoi kahato weitaria ko'i yne e'at pe ta'a­tu­he­wyry hap upi e. Pyno aito ti po'og po'og Tupana mi'a­tu­ky'e ko'i torania weitaria ko'i kai are mi'i pote aipoi kuap Tupana aikotã toipoi weitaria ko'i ewy e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ta'i pywo ti yt aity­pore i pote yt kan hamo i watu­wa­nẽtup ko'i ko'i katu­pono watu­wa­nẽtup ko'i ko'i haty wo pytkai aipiit moty­pore hap yt kat i toĩne'en e. I'ewyte — Pyno areĩne'en mot'i kahato mesuwat yi tote e hap kape watu­wa­nẽtup at ka'ap aimo­ken'ẽ hap wywo pytkai aiku­'uro hap e'at tut aru hawyi yt watoĩ­ne'en kuap i wẽtup e'at po'og watu­wa­nẽtup ko'i ko'i ahesaika hap wywo pytkai e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pyno aipiit moty­pore hap yt watunug kuap i aiwa­nẽtup ko'i ko'i hawuo hap ewy yt kan hamo i aiwa­nẽtup ko'i ko'i — Are pãi are an yt kat i uimi'u hawyi uiku­'uro uhesy'at hap upi pãi an aiwa­nẽtup aimo­ken'ẽ hap upi hap yt kan hamo i katu­pono yt aiwa­nẽtup ko'i ko'i hap kaipyi ti aimi'u ko'i toĩne'en e. Yt naku i paa'wa­to'e — Yt kat i uhesokpe hawyi uhatek hap sese toĩne'en hawyi uiku­'uro aru yt kat i uhesokpe hawyi e hap upi yt naku i watu­wa­nẽtup sa'ag aimogyt hap ewy e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Uimohey haria e eiwe­ha'at ro ga'apy pohyt ko'i kape katu­pono tuwe­painug kahato ga'apy ko'i ikahu kahato sese e. Ta'i ga'apy yahig kape eiwe­ha'at ro katu­pono tuwe­painug kahato i hupi itote ipohyt ko'i wo ikahuria kahato rakaria mi'iria e. Ikahu kahato po'og po'og ikahu sa'ay­'iwuat ieĩne'en hat morekuat koro pot Sarumãu hekat rakat esokpe kahuria kahato rakat kai. Po'og po'og ikahu ga'apy piat pohyt ko'i morekuat Sarumãu esokpe ko'i kai e. Ga'apy piat pohyt ko'i yt wepotpap haria i i'ewyte yt te'e­ru­we­sokpe pi'ig kuap i haria tukup­te'en ma'ato i'atu­we­painug hap Tupana minug po'og ikahu ahesokpe kai are e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wuat'i e'at pe ga'apy piat ko'i Tupana minug sokpe puo e. Ga'apy watitek hawyi mũki­'ite ipohyt pap ta'yn aiko watunug hawyi e. Mi'i hawyi igag hawyi ahe'aria wo i'yp ko'i watunug e. Uimohey haria kat pote yt eweimohey i Tupana tikuap kahato ahesokpe nug hap aipainug hap e. Yt eweikuap i te apo aikotã aito po'og Tupana miky'e ko'i ga'apy pohyt ko'i kai hap e. Pywo kahato Tupana tum kuap ahepe ahesokpe e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mi'i tupono yt naku i watu­wa­nẽtup ko'i ko'i yt kat i Tupana mohey hap wywo — Yt kat i uimi'u pote uiku­'uro irane mũki­'ite aiwa­nẽtup aimo­ken'ẽ hap upi e. Yt naku i — Uhatek hawyi kat som aru atu'u rat kat som uimẽpyt mi'u wo aikope pyi aru uhesokpe e hap kape yn yt naku i watu­wa­nẽtup ko'i ko'i haty kahato aipy'a pe hap wywo yt kat i Tupana kapiat imohey hap wywo are e. Aikope pyi aru ahesapo hy pãi an yt naku i hawyi yt naku i aru e hap aimo­ken'ẽ hap wywo yt naku i watu­wa­nẽtup at ka'ap aimo­ken'ẽ hap ewywuat ko'i hap upi e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta'i yt Tupana mohey haria i mekewat ko'i ko'i kape yn te'e­ru­wa­nẽtup at ka'ap te'e­ro­ken'ẽ hap wywo yt kat i Tupana mohey hap wywo ma'ato aito — Pywo pe wyti Tupana ti aimoieĩ­ne'en kahato kuap hat waku wato'e e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ta'i Tupana ti'a­tukuap kahato ahesy'at yt ahesokpe i hap e. Ta'i mesu­wa­rotiat irania'in ywania Yt Tupana kuap i haria ta'a­tu'ok hap ta'a­tu­sokpe hap ta'a­tu'yatnug hap kape yn te'e­ru­wa­nẽtup at ka'ap ma'ato yt atiky­'esat i eipe mi'iria ewy eweikup­te'en aikotã yt Tupana mohey i haria ewy e. Yt atiky­'esat eipe mi'iria ewy eweikup­te'en uiwy­ria'in ma'ato atiky­'esat eweikat kahato aikotã pote waku miit'in mu'e Tupana etiat hamuat hap kape e. Mi'i hap kape yn po'og waku watu­wa­nẽtup at ka'ap hap atiky­'esat e. Mi'i hap ti watunug mote wati­puẽti kahato irania'in aimi­ky­'esat ko'i Tupana po pyi mekewat ai'ok hap ai'yat ko'i ahesokpe hap ko'i wy e. Mi'i hawyi waku eweiwa­nẽtup aikotã Tupana topy­hu'at Wuat'i Ywania Porekuat nuat hap kape are e. Mi'i hap eweikat po'og mesu­wa­rotiat ko'i kai hawyi put'ok'e aru ehepe eipoi­tyro hap mesu­wa­rotiat hap ko'i eimoieĩ­ne'en hap ko'i eimi'u ei'yat eisapo hy ehe'yni eimikoi ehesokpe ko'i hawyi Tupana mipoi­tyro ko'i eweikup­te'en ipo pyi are e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mi'i hawyi Iesui to'e tomohey haria pe — Uihũria ko'i ewywuat no eipe are e. Yt typy'i kahato i eipe ma'ato yt eweiken'ẽ tei'o katu­pono Tupana einug neran more­kuaria wo karãpe Tupana topy­hu'at Wuat'i Miit'in Morekuat nuat hap e'at pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Waku wati­we­neru aheka­re'en mi'i hawyi waku aheka­re'en sa'up kaipywiat waku waho'oium ahekat yt hekat i rakaria pe hatek takaria pe are e. Mi'i watunug hawyi aheka­re'en sese iwato kahato toĩne'en atipy pe wuat'i e'at pe e. Mi'i tote ahekat sese mohag hap toĩne'en aheiam yt karãpe i ipot'i rakat are e. Yt karãpe i ikahuro ahekat itote e. I'ewyte sero'ok eharia yt tuwe­hyt'ok kuap i itote yt uwe i itote aipo­hari rakaria are e. I'ewyte aheka­re'en u haria ko'i ape'i ko'i sari ko'i nupi'a ko'i wẽki'a ahekat u haria yt uwe i itote atipy pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aheka­re'en atipy pe pote i'ewyte eiwa­nẽtup hap aipy'a piat i'ewyte tukup­te'en itote ma'ato eheka­re'en mesu­wa­rotiat yn tukup­te'en pote i'ewyte eiky'e hap eiwa­nẽtup hap eipy'a piat toĩne'en wy mesu­wa­rotiat ko'i ete yn e. Watu­we­ha'at kahato aimi­ky'e ko'i ky'ewi hap kape are e. Pywo kahato aikope ahekat toĩne'en hap kape aiwe­wa­nẽtup hap i'ewyte toĩne'en kahato are e. Aimi­ky'e kape yn aheha toĩne'en aiwa­nẽtup hawe are e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Mi'i hawyi wẽtup sehay Iesui henoi ahepe itote. Mio tã e — Waku wo'oe­ropat haria ewywuat wato­py­hu'at e. Mesu­wa­ro­tiaria tiky­'esat kahato ta'a­tue­ropat hap waku kahato rakat e. Waku Tupana eropat kahato haria watoĩ­ne'en are e. Ta'i ahetama pe karãpe more­kuaria tuwat ta'a­tue­tawa pyi ta'a­tu­'atoiat ta'a­tu'yat pe surara akag i'atu'yat piaria apykok hamo. — Ewe'eg wo o ui'yat apykok hap ete e tesu­rara akag me. Ara'aipok hawyi sa'up iwato atum epe mehĩ e more­kuaria ta'a­tu'yat piaria apykok haria pe. Mi'i hawyi tuwat wẽtup tama kape hawyi waku yne hawyi te'e­ra­'aipok ta'a­tu'yat kape ta'a­tu­mẽ­pyt'in kape. Mi'i hawyi waku itote yne ta'a­tu'yat piaria i'atu­wepit itote hawyi more­kuaria timõ­typot kahato ta'a­tu'yat piaria apykok haria. — Waku kahato ti rat en uhyt mana e to'yat apykok haria pe e. Pyno waku watu­kup­te'en Tupana yat piaria apykok hat ewy e. Waku surara akag ewywuat aheropat Aipo­typot Tupana e. Aikotã ipotpap takaria ariãty wywo wãtym muat ipotpap yat piaria poi hamo mohag ium hamo aria nug hamo haria ewywuat waku wahe­ropat Tupana mẽpyt'in e. Waku wate­ropat wãtym muo rakaria ewy haty pytkai yt watoket pytkai i waku wahe­ropat kahato Ai'akag emiit'in ta'a­tu­ky'e hap wywo are e. Aikotã hesaika rakat ipiit sakup wywo rakat ewy waku watu­we­potpap Tupana mẽpyt'in eropat hap upi e. Aikotã aheropat haria wãtym muo ta'a­tupag ariãty ai'yat pe mi'i hawyi yne heremo itote mi'i hap ewywuat waku watu­we­potpap e. Waku ahe'a­riãty imehit rakat ewy yt kat i i'ytyk hap mi'i ete hap ewy watu­we­potpap Tupana mẽpyt'in ky'e hap yn ahete e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ta'i ahetama puo more­kuaria eropat haria hekatup kahato morekuat ut hap at ka'ap ta'a­tu­he­katup katu­pono put'ok'e morekuat turan meremo ta'a­tu­ho­'o­'o­kenhyp teran haype e. Mi'i hawyi at ka'ap ta'a­tu­he­katup ta'a­tu­mo­rekuat ut hap e. Mi'i hawyi morekuat put'ok'e to'o­ken­'y­pyke hawyi meremo ta'a­tu­ho­'o­'o­ken­hyp'ok teran hawyi ta'a­tu­pysei aheko ewy waku hap ewy hawyi ta'a­tupoi hawyi ta'a­tu­mõ­typot kahato ta'a­tu­ky'e ta'a­tu­po­rekuat ta'a­tu­potpap hap ete e. Mi'i haria ewywuat waku watu­kup­te'en are e katu­pono tut irane Tupana akotã morekuat tut ho'o­kyi'at hap ienuk wato hap e'at kape hap ewy e. Mi'i hawyi wo'o­kyi'at hap enuk hap kapiat hut turan — Ariot ra'yn ewei'o­ken­hyp'ok to e haty wo to'yat koro ete hawyi meremo heropat haria tuwat hawyi — Ereke ereke Urupo­typot i'atu'e hawyi teke e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Heropat haria yt te'e­roket hin i te'e­ro­py­hu'at ta'a­tu­ka­'iwat put'ok'e turan i'atu­wepit kahato yt te'e­roket i ma'ato ta'a­tukat ka'ap sio tut sio yt Ai'akag i'atu'e hap ete e. Mi'i hawyi put'ok'e hawyi i'atu­ka­'iwat koro piit ete ta'a­tue­sok­pepag hawyi — Era'apyk o mehĩ mimi i'atu'e ta'a­tu­'akag sese pote e. Ma'ato karãpe teropat haria yt naku i rakaria ket kai ne'i put'ok'e morekuat pote te'e­ru­we­mõti kahato. Mi'i hawyi oken'ypy ete ihay ta'a­tukuap ta'a­tuket turanuat pote te'e­ru­we­mõti kahato ma'ato heropat hap etiat ta'a­tu­potpap turanuat pote te'e­ru­wehum kahato ta'a­tue­tu­'isa ut hap ete e. Mi'i hap ewy waku watu­we­potpap e. Mi'i turan Aipo­typot put'ok'e pote yt mesu­wa­rotiat morekuat minug ewy hin i tutunug Tupana are e. — Uheropat ro uheropat ro i'atu'e haty wo mesu­wa­ro­tiaria more­kuaria e. Ma'ato Ai'akag Tupana put'ok'e hawyi — Woro­ho­'o­ky'e kahato e yn ahepe hawyi aheropat hat ewy topy­hu'at itote hawyi toihep tesokpe ikahu kahato rakat morekuat nuat esokpe mi'i te pag'e topiit etewuat eropat hat esokpe ewywuat mi'i hawyi to'e aru ahepe — Sa'a­wy'i uheropat kahato haria waku kahato rakaria eipe e ahepe. Mi'i pote koitywy areĩne'en eheropat hat eipotpap nug hat ewy areĩne'en e aru ahepe hawyi — Era'apyk to uheypa­rakai ete hawyi woro­ho­'opoi yne ehenuk hap koro ikahu kahato e aru Ahetu­'isa Koro Tupana ahepe. — Ta'i waku kahato eipe katu­pono yt eiket turanuat i put'ok­'are pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pyno waku wato­py­hu'at iwe'eg kahato rakaria ewy watu­we­potpap Aika­'iwat potpap nug hap ete uhyt'i'in mana'in e Iesui katu­pono yt eweikuap hin i karãmuo put'ok'e Ai'akag Koro hap sio ihot'ok puo sio wãtym'i sio wãtym hake sio atpo­sake turan hap yt eweikuap hin i e. Pyno waku pe kahato watoĩ­ne'en put'ok'e Ai'ywot Tupana yt watoket i te turan hap e Iesui temiit'in me ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pyno waku wate­ropat kahato katu­pono yt pya hin i put'ok'e hamuat Wuat'i Potypot Nuat hap. Mi'i tupono waku wate­ropat kahato aikotã — Put'ok'e irane Ahetu­'isa e haria ewy. Waku wati­'a­ry­mary yne put'ok'e turan hap atiky­'esat e haria ewy katu­pono karãpe Aika­'iwat aipok hap kat e'at pe turan kat e'at pe turan hap yt watikuap hin i pote e. Ta'i tut wyti aru aikotã sero­'ok'e hap tut hap ewy yt uwe i ikuap hap ewy e. Mesu­wa­rote yt watikuap hin i karãpe put'ok'e sero­'ok'e hat katu­pono mig'i wo sero­'ok'e haria tõ'ẽ hap ewy. mi'i tupono waku aiwe'eg wo kahato sero­'ok'e hat hap pupi hap ewy katu­pono tuwe­hyt'ok ai'yat pe yt iheg i rakat pe meremo ahero'ok hamo aheka­re'en ko'i pohari hamo. Ma'ato aiwe'eg wuat pote yt ahero'ok kuap i mi'i hap ewy kahato. Waku watu­kup­te'en sura­ra'in ewywuat haria te'e­ra­ha'at at ka'ap takaria ewy mi'i pote karãpe Eika­'iwat put'ok'e aru hawyi meremo eweikuap uhut hap mekewat sura­ra'in ewywuat uhekatup pote are e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Uito areĩne'en Wuat'i Miit'in Eyke'et wo Wuat'i Miit'in Kywyt wo mi'i pote ariot i te aru mesuwat yi kape are. Ma'ato mekewat uhut hap e'at pe yt uwe mikuap mo i ariot are. Mekewat uhut hap e'at yt i'atu hin i uhekatup haria tukup­te'en e. Mekewat e'at pe — Yt tut i ira'yn po'og Aika­'iwat i'atu'e haria ahyt tukup­te'en are. — Yt tut i po'og mesuwat yi kape Aika­'iwat e haria tukup­te'en hap e'at pe aru ariot aikotã sero­'ok'e hat ut hap ewy e Iesui ahepe tomohey haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mi'i e hap tohenoi hawyi ipotmu'e Peteru apo'e Iesui pe — Uruka­'iwat e mekewat sehay iã'ãkap ehay uwe pe ehenoi e sio uruto epotmu­'eria piat mu'e hano sio yne miit'in mesuwat yi totiaria mu'e hamo ehenoi e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yt uruhe­katup i apuru eut hap kape sio irania'in yt emohey i haria kape mio tã ere e Peteru Iesui pe. Mi'i hawyi Iesui tiwesat — Pyno ahenoi uwe pe ahenoi mekewat uhehay iã'ãkap. Karãpe mekewat morekuat toto turan tesu­rara akag po pe iwe'eg kahato rakat po pe totoiat torania to'yat­piaria sem i'ewyte tomẽ­pyt'in hawyi — Eti'a­tu­'a­pykok o ui'yat piaria areto hap turan e tope. I'ewyte eti'a­tu­po­'oro miit'in mesuwe i'atupoi hamo i'atu­'a­pykok kahato hamo e tesu­rara akag me e. Mi'i surara akag ni uimohey haria apykok haria ewywuat kahato are'e uhehay iã'ãkap upi e. Mi'i pote ewe'eg wo uimohey haria apykok hap pupi are ehepe e. Ta'i uheropat haria sese pe mio tã are einãpin hamuat katu­pono atiky­'esat kahato eiperia aikotã morekuat eropat haria powyro kahato sese rakaria ewy hap atiky­'esat areto turan e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Atiky­'esat kahato uhemiit apykok haria powyro kahato rakaria aikotã morekuat eropat haria hãpyk sese rakaria ewy hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mi'i tã ewywuat eweikup­te'en turan ariot pote woro­ho­'onug eipe more­kuaria wo uhetama pakup we. Uhekat yne yne eiwano topy­hu'at e. Pywo pe miit'in ky'e hap upi ewei'a­pykok uimohey haria pote — Pyno waku kahato en wuat'i uhemiit akag wo hap atiky­'esat are'e aru e. — Atikuap ta'yn uimohey haria poi hãpyk kahato hap kaipyi uimohey haria ky'e hap kaipyi woro­ho­'okuap eipe waku kahato rakaria wo eweikup­te'en uheropat haria akag wo ko'i are'e aru uimi­ky­'esat ewy uimohey haria powyro kahato rakaria pe e. Mi'iria ewywuat Tupana mimõ­typot sese ko'i tukup­te'en aru wuat'i e'at pe uhut hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma'ato irania'in uheropat haria ma'at haria yt iwe'eg nakaria i mi'i haria pupi aremõti kahato uhut hap e'at pe e. Katu­pono — Aika­'iwat yt tut irane i ra'yn mi'i tupono waku yt naku i watu­wenug e haria e hamo ta'a­tu­ma'at uimohey haria. — Ta'i yt tut i som katu­pono toĩne'en mot'i itote iatu'e uhut hap ete. Pyno waku watu'u mahy aimo­pẽ'ã hamo yn waku i'atu'e sa'ag. Waku wati­'a­tu­'ahyk irania'in heropat haria i'atu'e. Waku watu­'uka hemiit'in ete uhyt'i'in mana'in ko'i ete i'atu'e aru. Waku mahy ete watu­wenuk i'atu'e katu­pono yt tut hamuat i ra'yn mesup wote toĩne'en mot'i itote. Waku aimo­pẽ'ã yn hap wywo waku watoĩ­ne'en i'atu'e ti aru uheropat haria akag ko'i yt iwe'eg i sese rakaria e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yt ta'a­tu­mohey hin i aru Ta'a­tu­ka­'iwat put'ok'e hamuat hap ma'ato mio tã ta'a­tu'e turan sese put'ok­'are i ra'yn are e. Karãpe put'ok­'are hawyi mekewat uhemiit'in ma'at haria ati'a­tu­'a­piheg apiheg kahato itote e. Mi'i hawyi — Yt naku i kahato eipe are'e aru i'atuepe hawyi — Motoro pya pya uikai hawyi eweikup­te'en aikope yt uimohey haria i tukup­te'en hap tote are'e aru uimohey apykok haria pe uimohey haria ma'at haria pe. Mi'i hawyi ati'a­tu'okpok kyse wo hawyi ati'a­tu­mo­ku'i i'atupiit ko'i uimohey haria apykok haria sa'ag nakaria e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pywo pe are'e heropat hat ikuap kahato kat ko'i kat ko'i Toka­'iwat Tupana miky­'esat ko'i wen ma'ato yt tutunug i pote mi'i hat wyti Ika'iwat tipokpok kahato aru ta'aipok hawyi are e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma'ato uheropat hat yt ikuap i kahato kat som Toka­'iwat miky­'esat hawyi mi'i hap yt inug i mi'i hat i'ewyte Ika'iwat ti'pokpok aru ma'ato yt kahato i aikotã toipokpok teropat hat ikuap kahato pytkai yt tutunug i Toka­'iwat miky­'esat hap ewy katu­pono yt tuwepyi i toi'a­parap e. Ma'ato waku watu­kup­te'en heropat waku rakaria yne Aika­'iwat miky­'esat ko'i aimikuap ok tã nug haria e. Mi'i hap ewy Aika­'iwat tiky­'esat kahato e. Pyno karãpe wẽtup ok pe ika'iwat tum iwato kahato teropat hap mi'i hat kaipyi ti toiky­'esat iwato hap po'og mi'i teropat hat pote e. Pyno po'og po'og Tupana timo­herep ahepe tomi­ky­'esat watunug hap ko'i tomi­'ai­roria aito pote. Pyno waku watunug tomi­ky­'esat tomi­mo­herep ahepe aimohey haype pote. Waku watunug imiky­'esat hap ok tã tomo­wepit hap e. Ma'ato yt watunug i to'e ahepe hap ewy pote po'og wati­'a­parap irania'in kai katu­pono watikuap imiky­'esat pytkai yt watunug i hawyi pote are e. Watunug imiky­'esat hawyi tuwehum kahato ahowawi hawyi po'og toimo­herep ahepe tomi­ky­'esat ko'i ma'ato yt pote yt aimohey kuap i e Iesui temiit'in me ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mi'i hawyi Iesui to'e ahepe — Pyno ahenoi teran ehepe uhetiat e. Uito ti aria ewywuat yt naku i nug hap yne mesuwat yi tote wuk hamo e. Aikotã aria wy Uito aikotã watiwuk aiko hap ewy wẽtup aria aipo piat hap kaipyi watiwuk yne e. Sa'a­wy'i yt iwato hin i aria itote ma'ato watopag aria itote hawyi tutu'u yne. Iwato kahato aria itote hawyi wuk wuk'e itote hawyi ikahu hawyi yt kat i moi yt kat i i'anam yt kat i sa'ag tutu'u kahato hawyi waku pe amikoi ko'i hamo e. Uito ti mekewat aria ewywuat areĩne'en mesuwat yi tote wuat'i sa'ag miit'in wanẽtup hawe wuk hamo e. Aria ewywuat ti Uito ma'ato uiko yt atiwuk i te ma'ato atiwuk teran haype e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Katu­pono aho'opot hap aria'yp posak etiat yt i te wen ma'ato mi'i kape arewa­nẽtup kahato e. Sa'a­wy'i ahet'ok hat Iuwãu uhet'ok ta'yn y'y wo ma'ato wẽtup ok uhet'ok hap toĩne'en ne mi'i ti aria ewywuat uimo­so­'opot hap sese are. ");
INSERT INTO mavNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Uimohey haria yt naku i aru topy­hu'at ahete pãi e. Pywo ti rat yt ariot i mesu­wa­rotiat kape wo'o­wese hap erut hamo ma'ato ariot hawyi wo'o­tu­'uka kahato hap yn sehay topy­hu'at e. Uhehay pun haria ti'a­tu­'a­tu­'uka teran haype uhehay mohey haria ete e. — Yt pywo pe ihay i'atu'e yn uhehay ete eimi­mo­herep ete hawyi yt i'atu­wese kahato ehete uhehay moherep haria eipe pote e. Pyno yt eweiwa­nẽtup tei'o eipy'a pe meiũran aru yne mesu­wa­rote wo'o­wese haria tukup­te'en hap kape e. Yt eiwa­nẽtup tei'o miit'in i'atu­wese kahato hap uhehay kape eipy'a pe are e. Yt karãpe i aru yne miit wo'o­wese haria tukup­te'en katu­pono po'og i'atu­py­'ahak aru uhehay moherep haria ete ahewa­nĩ­kaptia are e. Aikotã surara sese tipat'ok kuap miit piit kyse'yp wo hap ewy mi'i hap ewy uhehay ti'a­tu­pat'ok miit'in wẽtup kai uimohey haria hawyi wẽtup kai yt uimohey haria i e. Pyno miit'in wo'o­pat'ok hat ewy areĩne'en e. Wẽtup kai uhehay upiaria tukup­te'en hawyi wẽtup kai yt i'atupap i uhehay upiaria e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mi'i hawyi ti aru 5 ok wẽtup yat piaria gupte'en haria meiũran aru yt to'o­wese hin i to'o­pat'ok uimohey hawyi are e. Mi'i hawyi to'o­pat'ok pat'ok haria wo tukup­te'en wẽtup yat pe e. Uimohey haria iwese kahato pytkai irania'in mekewat yat piaria yt i'atu­wese hin i itote wẽtup ywania pytkai e. Typy ok mye'ym ok ete sio mye'ym ok typy ok ete uimohey haria ete ipat'ok hawyi — Wãi'ia­tu'e irania'in uimohey haria mohit hamo aru e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mi'i turan miit'in tu'uka teran ehete uimohey haria eipe hawyi e. Ta'i ei'y­wot'in yt i'atu­wese hin i ehete uimohey haria eipe hawyi e. Eha'y­ru'in ehaki­'yt'in i'ewyte yt i'atu­wese hin i ehete uimohey eipe hawyi eimẽ­pyt'in pytkai are e. I'ewyte eity ipy'ahak ehete topy­hu'at uimohey hawyi eipe tomẽ­pyt'in eipe pytkai e. I'ewyte eimẽ­pyt'in yt i'atu­wese i ehepe uimohey hawyi ta'a­tu­ty'in ta'a­tu­'y­wot'in eipe pytkai are e. Ehaki­tu'in i'ewyte yt i'atu­wese i ehete ta'a­tu­mi­mo­ha­py'ap ko'i pytkai eipe e. Mi'i hawyi getap ka'iwat yt iwese hin i tosa­'yru ete tosa­ki'yt ete tosa­'yru tosa­ki'yt uimohey hano ra'yn mote e. Ta'i ariot pote miit'in to'o­pat'ok kahato wyti aru uimohey haria ete yt i'atu­wese hin i irania'in mesu­wa­ro­tiaria eipe eiwese kahato pytkai e. Yt kat i aru wo'o­wese hap sese mesuwe aru are e Iesui ahepe tomohey haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mi'i hawyi po'og Iesui tohenoi miit'in sem itotiaria pe — Uheka­tu­wy­ria'in e mesu­wa­ro­tiaria tikuap kahato i'aman ut irane hap te'e­ra­ha'at at hun kape — Meiẽ i'aman hamuat i'atu'e. At wẽtem hap kaipyi i'aman tut i'atu'e mi'i hawyi i'atu'e hap ewy i'aman tut kahato. — Meiũpe ywyhig at ẽtyhot hap aũka hap ko'i mi'i pote i'aman irane i'atu'e ahetama pe hawyi i'atu'e hap ewy i'aman na'yn tut e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ta'i kahato atipy ihyryp'i kahato hap mi'i pote mesu­wiaria iũe e'at hakup irane mesup i'atu'e hawyi i'atu'e hap ewy put'ok'e e'at kahu hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mesu­wa­ro­tiaria tikuap kahato i'aman ut hap sio yt hap te'e­ra­ha'at atipy kape hawyi ta'a­tukuap ma'ato mesu­wa­ro­tiaria ta'a­tuieĩ­ne'en wuat'i e'at piat hap kape yt te'e­ru­wa­nẽtup teran hin i e. Ta'i mi'iria tikuap aikotã aru i'aman sio at waku hap ma'ato uwe Uito hap yt ta'a­tukuap hin i. Ta'a­tukuap uhehay ko'i kape ta'a­tu­wa­nẽtup pytkai yt uikuap i te uwe sese Uito e. Te'e­ra­'a­kasa kahato uiminug yt miit'in eminug kuap i iwato rakat ko'i kape pytkai yt uikuap i te uwe Uito e hap kape yt te'e­ru­wa­nẽtup teren hin i te'e­ra­ha'at kahato uhowawi yt uimohey i te rakaria mesu­wa­ro­tiaria e. Yt ihapytig i rakaria Tupana kape yt kat i i'atueha rakaria ewywuaria pote e Iesui miit'in sem itotiaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mi'i hawyi po'og to'e Iesui itotiaria pe — Kat poteĩ yt eiwa­nẽtup teran i uwe Uito sese e hap kape e. Kat pote yt eiwa­nẽtup sio Uito waku sio yt hap kape e. Eiwo­'okuap uwe waku uwe yt hap kape meremo eiwo­'okuap yne eiwo­'o­mohey hap ete uwe waku uwe yt naku i wato­mohey ma'ato uhetiat uimohey hap kape yt eiwe­wa­nẽtup teran hin i wuat'i atunug waku ehehamo pytkai are. ");
INSERT INTO mavNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Uimohey haria wẽtup sehay ahenoi teran ehepe — Karãpe ehewa­nĩ­kaptia aheroto sura­ra'in po pe Morekuat kape ai'auka hamo ai'pyhik hamo waku watikat kahato aiwe­nõ'ẽ i aiwa­nĩ­kaptia popywiat hamuat are e. Mi'i hap e'at pe ai'auka teran pote waku watoĩ­ne'en iwe'eg kahato rakano i'atu­py­'a­setpe mi'i hawyi mu'ap upi waku watikat kahato mu'ap aiwe­to­popy ahewa­nĩ­kaptia po pywiat hap are. Yt naku i watuwat morekuat koro kape ai'auka teran haria upi katu­pono itote meremo ahum morekuat koro pe hawyi morekuat — Yt naku i en e hawyi ahum tesu­ra­ra'in akag pe hawyi surara akag aipag iheg me kat aiwo­'o­pyhik hawe e. ");
INSERT INTO mavNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mi'i hawyi wo'o­pyhik hawe watu­kup­te'en at ka'ap hawyi aikotã aru watu­we­nõ'ẽ mekewat wo'o­pyhik hap sa'ag myi e. Ta'i itote yt uwe i tuwẽtem kuap i e. Mi'i tote waho­'opot kahato mekewat sa'up iwato ium hamo hawyi ai'yat toiwe­neru aiko ko'i aimikoi ko'i aimẽ­pyt'in ko'i totat temiit'in nuat aheha­ry'i totat towanuat ahemiit'in torania toipo­'oro topotpap nug hamo hawyi ahekat ko'i toi'a­tu­we­neru yne sa'up sat hamo. Mi'i hawyi yne aiwanuat morekuat nuat hawyi watu­we­nõ'ẽ aipyhik hap kaipywiat hawyi — Waku ra'yn motoro pya mesu­wepyi e ahepe sio meremo woro­'auka en aru e ahepe. Mi'i tupono waku po'og ahewa­nĩ­kaptia meremo watunug aiwy­ria'in sese wo mu'ap upi eheroto sura­ra'in miat morekuat kape turan are e Iesui temiit'in me ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Iesui ti'a­tu­mu'e itotiaria turan irania'in itotiaria te'e­ro'e Iesui pe — Mehĩ i'atu'e wanĩ­kaptia mipo­'oro aipo­rekuat nuat mekewat Piratu e hap het rakat yt naku i kahato tutunug katu­pono ga'atpo ti ahetama Kari­reira piaria morekuat Piratu timoma kahato i'atu'e. Morekuat totat ahemiit'in hawyi toiwuk Tupana mõtypot yat pe i'atu'e. Mi'i hawyi totopag mekewat i'atusuu at hap Tupana mõtypot yat piat yparakai tote mekewat aihũria suu wuk hap eypa­rakai tote aihũ watum hawyi watiwuk Tupana mõtypot hamuat hap tote i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mi'i hawyi Iesui to'e i'atuepe — Pyno uruto po'og morekuat Piratu mi'a­tu­'uka ko'i kai ewei'e. Yt karãpe i urutunug sa'ag imi'a­tu­'uka ko'i minug ewywuat ewei'e. Mi'i pote Tupana mi'a­piheg ko'i wuaria tukup­te'en mi'iria ai'y­wania ewei'e eiwo­'ope e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma'ato pywo pe ti are'e ehepe eiperia ti wy i'ewyte yt nakuaria i kahato eweikup­te'en are. Ga'atpo ei'y­wa­niaria morekuat Piratu ti'a­tu­'uka kahato yi Kari­reira piaria. Yt naku hin i ti ipap hap ewei'e. Yt ikahu hin i i'atu­ku­'uro hap ewei'e e. Mi'i hap ewy ti aru eweipap yt uimohey i eipe pote e. Ma'ato wuat'i e'at pe ti aru ho'opot hap eiwanuat topy­hu'at eiwano e. Ma'ato yt paa'e­wei'e i yt uimohey i hap ete pote yt naku i pe wuat'i e'at pe eweikup­te'en po'og yt naku i morekuat Piratu mi'auka ko'i ho'opot hap kai are. ");
INSERT INTO mavNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ta'i sa'a­wy'i sese 18 surara topap yne ta'a­tu'yat nu kawiat ywaiti rakat ta'at i'atuepiit ete hawyi yt naku i ewei'e. Mi'i hawyi sura­ra'in gupte'en haria topap yne nu yat ta'at i'atuete hawyi. I'atu­ku­'uro hap yt ikahu hin i ewei'e. Mi'i pote ewei'e eiwo­'ope — Eweikuap kat pote mekewat 18 surara topap nu mi'a­tu­'uka ko'i ewei'e. Ta'i sura­ra'in yt naku i nug kahato haria pote ti Tupana ti'a­tu­'a­piheg sese mi'iria ewei'e eiwo­'ope. Ta'i po'og tawa Ieru­sarẽi miaria kai yt naku i nug haria mi'iria pote Tupana ti'a­tu­moma yne ewei'e eiwo­'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma'ato pywo pe are'e ehepe meiũran ti aru eipe po'og eweipap mi'iria kai po'og yt naku i are'e. Eiku­'uro hap po'og yt ikahu i mi'iria ku'uro hap kai. Katu­pono wuat'i e'at piat eiku­'uro hap topy­hu'at yt ikahu hin i. Ma'ato paa'e­wei'e yt uimohey i hap ete hawyi mi'i hawyi uimohey haria wo eweikup­te'en hawyi waku puo eweikup­te'en wuat'i e'at pe e Iesui tomohey hap pun haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mi'i hawyi Iesui henoi hã'ãkap wo i'atuepe. — Wẽtup ok so toto tomikoi ypia wato hap kape e. Sa'a­wy'i warana ypia py'a­setpe Wiku yp toĩne'en itote hawyi toto mekewat tomikoi Wiku yp kape hawyi toho­'okat Wiku saat toho­'ohep hamo. Ma'ato put'ok­to'e hawyi so ma'ato i'yhop yn toĩne'en itote ihãite kahato. Ma'ato yt kat i haat ipoi hamo. Yt wẽtup i haat toipuẽti tomi'u wo. ");
INSERT INTO mavNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mi'i hawyi toikaykay tuwe­wawi teropat hat tomikoi ypia apykok hat — Uhyt e ga'atpuat ga'atpuat e'at ariot sa'a­wy'i meiũwat yp kape uipoi hap kat hamo ma'ato yt kat i atipuẽti te e so. Mi'i hawyi ga'atpo e'at i'ewyte haat hap e'at ra'yn turan ariot i ma'ato i'ewyte i'yhop yn ne atipuẽti yt uipoi hin i uhesy'at hawyi. Koran ariot i hawyi he'at ra'yn ma'ato ara'a­kasa hawyi yt uipoi hin i hat mesuwat uimikoi Wiku yp e. Pyno uhyt eti'yppun no meiũwat yp ywyhop mo e. Kat pote uhe'yi u hat toĩne'en ma'ato yt uipoi hat i e. Mi'i hawyi waku wẽtup i watikoi mesuwat yi aikope toĩne'en mesup Wiku yp hap tote e. ");
INSERT INTO mavNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mio tã e pote — Yt uhyt e mikoi ypia apykok hat. Yt rat uika­'iwat yt naku i rat wati­'yppun e. Waku watum yi hun kahato tope 12 ewaty pe te sio haat hamuat sio yt ti ra'yn hap kuap hamo e. Mi'i hawyi waku watipoi kahato aimipun ko'i wo e. Waku ahywytip kahato i'anam ko'i mi'i hawyi weita iun a'ẽpo ko'i waku wati­puruk kahato haga etiat e. Mi'i hawyi arewa­nẽtup irokirẽ wat 12 ewaty hawyi haat aru ma'ato yt haat pote waku wati­pugha e. ");
INSERT INTO mavNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pyno 12 ewaty hawyi waku mehĩ era'aipok eraha'at sio wakuat sio yt hap kuap hamo e. Ma'ato mi'i turan yt haat i te ra'yn pote waku eti'yppun uhyt e. Mi'i mikoi Wiku yp ewy kahato ti eweikup­te'en eipe e Iesui. Wẽtup 12 ewaty hawyi ete sio haat rakat ewy sio yt hap ewy eweikup­te'en. Ma'ato yt i te ti pote Tupana mi'yppun wo eweikup­te'en e Iesui to'y­wania pe yt tomohey i te haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mi'i hawyi Iesui toĩne'en i ra'yn wẽtup Tupana mõtypot yat pe i ra'yn miit'in mu'e hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mi'i tote toĩne'en wẽtup ok hary­poria ahiag ipiit piat rakat itote. I'ahu kahato 18 anu ra'yn. Toho­'opot kahato katu­pono ahiag mimo­'ahu toĩne'en. I'ok tũ'ã kahato hap wywo toho­'opot ahiag minug. ");
INSERT INTO mavNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesui teha'at mi'i hary­poria kape hawyi toikaykay tuwe­wawi. Mi'i hawyi to'e tope — Mana atipok ta'yn epo'i po'i hap ahiag minug e. Pyno mana e e'ahu hap epo'i po'i hap ewy kahato. Pyno mi'i hap ewywuat epo'i po'i hap atiporop ta'yn e. ");
INSERT INTO mavNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mi'i hawyi tuwe­ponug hawyi i'ok tũ'ã hap meremo tokosap ta'yn. Waku hawyi hary­poria to'e tehay wepit kahato hap wywo — Waku kahato En Tupana e. ");
INSERT INTO mavNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma'ato Tupana mõtypot yat apykok hat ipy'ahak kahato Iesui ete katu­pono Iesui timo­hãite mekewat hary­poria yt topotpap i hap e'at pe pote. Mi'i pote to'e tomi­mu­'eria pe — Toĩne'en wyti 6 e'at aipotpap nug hamuat e. Pyno waku 6 e'at aiwe­potpap hap turan watikat aimoe­hãite hap ma'ato mesup e'at pe yt naku i kahato watikat amoehãite hap e. Mi'i hawyi Iesui tiwesat — Mehĩ e yt ewe'eg hin i aikotã typy ehay rakat ewy ereĩne'en katu­pono etipotpap kahato tuereto mesuwat e'at pe ehũ wewato ahup ta'at yi ka'a pe pote meremo etiõtem hap atikuap e. ");
INSERT INTO mavNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mi'i hawyi Iesui tiwesat — Typy hẽku rakat ne'i wyti en e. Yne e'at pe ewete­re­po'ok ewetioto eihũria i'atu­moe­'y'u hap kape. Yne e'at pe ewete­re­po'ok y'y kape eihũria e Iesui Tupana mõtypot yat apykok hat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pyno mesuwat hary­poria aha'a­se'i Aparãu emiariru toĩne'en wen ma'ato 18 anu turan ahiag mipo'i wo toĩne'en aikotã ehũ saity ete hap ewy are. Kat poteĩ pyno yt eweiky­'esat i Aparãu emiariru moehãite hap e. Kat poteĩ — Wãi'ere mesuwat mana erepo'ok hap ete yt naku i yt aipotpap i hap e'at pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mio tã e Iesui hawyi wanĩ­kaptia paa'i­'a­tu'e. Ma'ato irania'in itotiaria te'e­ru­wehum kahato Tupana pe Iesui minug wakuap ko'i ete. ");
INSERT INTO mavNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mi'i hawyi po'og Iesui henoi teran iã'ãkap wuo ma'ato sa'a­wy'i apo'e i'atuepe — Aikotã som Tupana topy­hu'at Miit'in Porekuat no hap ete apo'e. ");
INSERT INTO mavNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","— Pyno ahetama pe toĩne'en iã'ỹi kurin kahato rakat aimi'u mosẽ'ẽ hap Mutata iã'ỹi wato'e. Mi'i ti kurin kahato wen ma'ato wẽtup ok tikoi toko pe hawyi hẽtyt hawyi meiũran i'yp ywaiti kahato ra'yn aria'yp sese ewy wo ra'yn toĩne'en. Mi'i hawyi i'yp haĩkupy pe weitaria te'e­ru­we­soknug na'yn i'yhop ko'i og muo. Mi'i hap ewy ti Tupana topy­hu'at Morekuat no mesuwat yi tote Mutata iã'ỹi mikoi hap ewy e Iesui tomi­mu­'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mi'i hawyi Iesui apo'e i ra'yn — Aikotã wyti aru so Tupana topy­hu'at Miit'in porekuat no e hawyi sehay iã'ãkap wuo toi'a­tu­mu'e i ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","— Pyno uhyt'i'in aikotã u'i nug hap ewy kahato ti aru Tupana topy­hu'at Morekuat no mesu­wa­ro­tiaria pe e. Aikotã watopag manĩ puk ipyre kape. Mi'i hawyi wati­'a­pokik manĩ puk ipyre wywo. Mi'i hawyi wati­'ahik hawyi watoiat hawyi meiũran i'apo­perup hawyi wati­karay mi'i hawyi aimi'u wo ra'yn he kahato ra'yn. Mi'i hap ewy ti aru Tupana teke aipy'a pe tehay wo e. Kurin nakat ewy i'apopyt ewy ihay pytkai hawyi ihay tuwe­mo­wato aiwa­nẽtup hawe hawyi meiũran u'i he hap ewy wato­py­hu'at e Iesui itote mu'ap upi tawa wato Ieru­sarẽi kape toto turan. ");
INSERT INTO mavNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mi'i hawyi Iesui ti'a­tu­mu'e kahato yne tawa hit piaria Tupana ehay wo. Mi'i hawyi tawa wato Ieru­sarẽi kapiat epu'ap upiaria toi'a­tu­mu'e kahato Tupana ehay wo. ");
INSERT INTO mavNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mi'i hawyi mu'ap upi wẽtup ok apo'e Iesui pe — Urupo­rekuat e karania apuru pyno te'e­ro­py­hu'at Tupana mieha­kye­ra'at ko'i wo atipy pe e sio apuru typy'i kahato miit sio apuru yt typy'i i apo'e Iesui pe. Mi'i hawyi Iesui tiwesat. ");
INSERT INTO mavNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Waku ewei'e eipy'a pe — Uito areke teran pãi areke teran an mekewat oken'ypy yt iwato i rakat ewywuat pe areha­kye­ra'at hap puẽti hamo waku ewei'e at ka'ap eipy'a pe are. Yt naku i — Waku mũki­'ite areke ewei'e hap ewy ewei'e are. Katu­pono meiũran ti aru i'atu kahato tuwe­hyt'ok teran atipy pe aikope Tupana toĩne'en Morekuat no hap kape wen ma'ato mi'iria yt tuwe­hyt'ok kuap i katu­pono wehyt'ok hap mot'i poity'i rakaria — Mũki­'ite waku areke sa'a­wy'i i'atu'e pote e haria pote e. Yt kat i typy oken'ypy atipy kape. Eweikat ro mekewat wẽtup yn oken'ypy Ui'ywot kape hap e Iesui tuwepiat. ");
INSERT INTO mavNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mi'i hap e'at pe aru — Ere'o­ken­hyp'ok to Mimi ere'o­ken­hyp'ok to Uhyt i'atu'e mot'i kahato uhowawi wen — U pãi yt woro­ho­'okuap kahato i eipe aikope pyi eweiõ'ẽ are'e i'atuepe aru. Ui'yat ri iheg me ra'yn are'e aru. Iheg me sese ra'yn ni oken'ypy are'e aru — Ere'o­ken­hyp'ok o ewei'e mot'i uhepe hawyi e. Waku mesup ereke uhyt'i'in mana'in are e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mi'i tote aru oken'ypke te'e­rewak kahato. — Sa'a­wy'i urutenuk kahato ewywo Mimi. Urutu­we­sa­po'u kahato kue ewywo Mehĩ i'atu'e uhepe. Ehay ete ti urutu­we­mu'e kahato wuat'i puo mu'ap upi i'atu'e aru uhepe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mi'i hawyi ati'a­tu­wesat — Pywo pe ti rat are'e ehepe sa'a­wy'i yt uimohey i pote yt woro­ho­'okuap hin i eipe are'e aru. Yt atikuap hin i aikope pywiat eweiõ'ẽ hap are'e aru. Eweiwat ro ui'ya­ty­pepyi pãi katu­pono yt nakuap i nug haria ti eipe are'e aru yt tuwe­hyt'ok i haria pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mi'i hawyi te'e­ruwak popuo te'e­ra­'aipok haty turanuat hap ewy i'atu­wa­nẽtup hawe i'atu­py'a pe kyry'et kyry'et ta'atuiãi ete haty kahato i'atupiit ete pote. Katu­pono sa'a­wy'i Aparãu yt pya hin i i'atukai toĩne'en meiẽwat getap we toĩne'en. I'ewyte Isaki i'ewyte Iako i'ewyte sa'a­wy­'i­wuaria Tupana ehay moherep tukup­te'en kahato itote Tupana yat pe ienuk hap ikahu kahato hap tote. Mi'i haria ewy aru eweikup­te'en mekewat wo'o­kak'i haria ewy yt eiwe­hyt'ok teran i mesup yn mote. Meiũran aru Tupana oken'ypy sakpo eweikup­te'en ho'opot hap tote yn. Yt eweikup­te'en hin i aru uiwywo atipy pe are — Mũki­'ite waku wato­mohey ewei'e mesup pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma'ato tuwe­hyt'ok kahato irania'in ywania. Mi'i haria ti tuwe­hyt'ok aikope Tupana toĩne'en Morekuat no hap tote yt ai'y­wania sese hin i pytkai. Tõ'ẽ tõ'ẽ kahato aikope pyi at tuwẽtem hap kaipyi aikope at min'e hap kape hawyi at posak kaipyi tõ'ẽ Tupana wywuat tukup­te'en hamo. Mi'i hawyi mi'iria paa'e haria pe — Eiwe­hyt'ok to are'e mi'iria pe ma'ato ehepe ti aru — Eiwe­hyt'ok to yt are hin i e. Uhehamo eweikup­te'en mesup uhehay sio waku sio yt hap kape ehewaure toĩne'en pytkai mekewat e'at wyti aru — Yt woro­ho­'okuap i eipe are'e aru Tupana ehamo ehepiat yt uimohey i haria te eipe pote e Iesui yt tomohey i te haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ui'y­wania e eipe ti Tupana ehay kuap yianmiat haria eweikup­te'en ma'ato o irania'in ywania ehewot­'yptia rakaria wyti aru tuwe­hyt'ok ehe'yianme atipy pe wẽtup ywania pytkai katu­pono uimohey haria tukup­te'en mi'iria aru are ma'ato eipe uhepiat sehay yianmiat kape eweikuap kahato pytkai yt eiwe­hyt'ok teran i mesup oken'y­pyke atipy kape e. Mi'i pote irania'in tuwe­hyt'ok kakato aru ma'ato eipe yt eweiky­'esat i pote i'atu­wat­'ymo eiwe­hyt'ok aru are e Iesui to'y­wania Iuteuria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mi'i hawyi Tupana ehay enoi haria put'ok­'i­'a­tu'e Iesui yatype te'e­ro'e hamo — Erẽtem no meremo meiũpepyi i'atu'e katu­pono morekuat Eroti wyti e'auka teran moity'i ra'yn Uhyt i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mi'i hawyi Iesui ti'a­tu­wesat — Morekuat Eroti ti awahuru ewywuat uiwa­nẽtup hawe katu­pono wo'o­'auka teran hat mi'i miit are'e. Mi'i hawyi eweiwat ro Eroti kape hawyi ehenoi ui'e hap tope — Uito ti meiũ ahiagnia atusopo kahato hat ra'yn i'ewyte ati'a­tu­moe­hãite kahato i'ahu rakaria mũki­'ite ti aru i'ewyte atunug atunug wakuat uipot­moe­hãite hap ko'i uhewyry hap upi e. Mi'i hawyi mũki­'ite e'ihot'ok hawyi ti aru waku yne ra'yn uiminug ko'i mi'i hawyi waku yne hawyi areto e. ");
INSERT INTO mavNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mesup e'at pe uipotpap teran miit'in moehãite hap ete hawyi mũki­'ite i'ewyte uipotpap teran hawyi mũki­'ite e'ihot'ok hawyi toran na'yn uipotpap hap mesuwe katu­pono ui'auka hap e'at aru put'ok'e ra'yn are. Ma'ato mesup e'at pe waku te arepotpap waku uhewyry mesuwe i'ewyte mũki­'ite waku ti wy. Ma'ato e'ihot'ok toran na'yn uipotpap hap toran na'yn. Katu­pono ui'auka hap e'at yt pya hin i ra'yn waku ewei'e mekewat Eroti pe awahuru ewywuat pe. Mi'i hawyi i'ewyte wẽtup ewehenoi tope — Yne sa'a­wy­'iwuat Tupana ehay moherep haria topap kahato tawa Ieru­sarẽi me i'ewyte Uito Tupana Mipo­'oro Tehay Moherep Hanuat yt naku i pyno wẽtup tawa pe ui'auka hap e. I'ewtye Uito atiky­'esat sa'a­wy­'iwuat Tupana mipo­'oro ko'i atu'uka hap tote te uiku­'uro hap uhyt ewei'e o miowat ui'e hap ewehenoi mekewat awahuru pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Mi'i hawyi Iesui tuwak to'y­wania ky'ewi tomohey hap pun haria pote. — Tawa Ieru­sarẽi miaria e yt eweiwe'eg hin i eiperia katu­pono Tupana mipo­'o­roria auka haria eipe e. Ihay moherep haria ewei'a­tu­'uka ha'a­wyte nu ko'i wo e. Ewei'a­tu­'akit kahato i ti Tupana mipo­'oro ko'i e. Mi'i hap ewy Uito wy woro­ho­'o­ky'e eipe pytkai — Eweiõ'ẽ ro eweiõ'ẽ ro uhowawi are yn pytkai akotã waipaka ty ti'a­tu­kaykay tomẽ­pyt'in ko'i hap ewy woro­ho­'o­kaykay kahato eipe — Eweiõ'ẽ ro eweiõ'ẽ ro uhowawi are kahato waipaka wary'i imẽpyt rakat ewy ma'ato ti — Yt yt yt ewei'e uhepe piku piku ko'i ewy. Uipo­pesap ywyt'ok­pype are waipaka ewy ma'ato — Yt rat ewei'e uhepe e Iesui tawa wato Ieru­sarẽi piaria pe tuwak turan. ");
INSERT INTO mavNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Are pãi mi'i hawyi ti aru eiweran eweipy­hu'at areto hawyi. Yt ewei'a­kasa hin i uhowawi aru ma'ato meiũran ti aru esaipe­piaria ai'y­wania Iuteuria — Waku kahato Tupana Mipo­'oro Sese Aheha­kye­ra'at hat i'atu'e aru uhetiat pe hawyi mi'i hap e'at pe aru ara'aipok ehowawi i ra'yn e Iesui tuwak hawuo. Ma'ato mesup yt uimohey hin i eipe pote eweikup­te'en aru aikotã ai'yat ikahu rakat yt uwe i miit wywo rakat ewy i'anam kahato ga'apy mihik pe tawa Ieru­sarẽi toĩne'en mot'i are. Mi'i hawyi ei'yat mesuwe yt kat i eipe yt uwe i hawyi are. Ma'ato meiũran ti aru — Mi'i Miit waku kahato Aipo­rekuat no ewei'e uhepiat hawyi mekewat e'at pe irania'in ewy waku puo eweikup­te'en Tupana ywania wo i ra'yn ma'ato mesup te yt e Iesui to'y­wania pe yt tomohey teran i te haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mi'i hawyi yt i'atu­potpap i hap e'at pe put'ok'e itote Tupana mõtypot yat pyi wẽtup getap kape Iesui toto Tupana mõtypot yat piaria apykok hat yat kape toto. Itote i'atu kahato nagnia ehay enoi haria. Itote Iesui ta'apyk tenuk i'atu­'akag wywo hamo. Mi'i hap kape te'e­ra­ha'at kahato Iesui kape. Ta'a­tu­ky­'esat kahato Iesui ti'a­parap hap sio Iesui ipotpap yt i'atu­potpap i hap e'at miit'in moehãite hap ete sio yt i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Katu­pono itote ti toĩne'en ihainia i'ahu kahato rakat ipiit puk takat. Mi'i pote te'e­ra­ha'at kahato sio apuru Iesui timoe­hãite sio yt aipotpap i hap e'at pe ta'a­tue­ro­mõ­pusu teran haype. ");
INSERT INTO mavNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mi'i hap Iesui tikuap tuwe­kaipyi mi'i hawyi to'e — Eiperia ti eweikuap kahato wãi'e hap ko'i yt naku i mesup e'at pe mio tã watunug hap ko'i. Ta'i ahe'a­se'i Musei wãi'e hap ko'i kuap kahato haria eipe pote apo'are teran ehepe — Waku apo miit'in moehãite hap watunug Tupana mõtypot e'at pe sio yt e. Uiwesat ro e Iesui wo'o­mu'e haria akag me. ");
INSERT INTO mavNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma'ato yt ta'a­tu­wesat teran i katu­pono i'atu­py­'ahak Iesui ete. Mi'i hawyi Iesui tipo­pytyk ipiit puk takat ipo ete. Mi'i hawyi tuwe­ponug ipiit puk takat ete pote meremo ipiit ihãite i ra'yn topy­hu'at. Mi'i hawyi ipohep ipiit ete pyi — Pyno waku ra'yn eete mehĩ e. Waku ereto i ro e'yat kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Toto hawyi Iesui tuwe­morem itotiaria ewawi — Eiperia eipotpap kahato yt motpap i hap e'at pe e. Woro­ho­'okuap eipe. Eihũ wewato ahup ta'at yi ka'a pe y'y pe hap enõtem hap ete eipotpap mi'i hap e'at pe pywo are sio yt. Ta'i pywo ti are e mi'i tã ti ewetunug yt naku i aipotpap e hap e'at pe. Mi'i pytkai kan hamo uimohit teran mesuwat e'at piat miit moehãite hap upi e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mi'i hawyi yt ta'a­tu­wesat kuap i kahato Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mi'i hawyi toi'a­tu­mu'e i tehay iã'ãkap wo Iesui katu­pono toikuap itotiaria te'e­ru­we­mo­wato hap pote. Ta'a­tu­ky­'esat morekuat e'ypa­rakai totiat ta'a­tu­'apyk ienuk hap e'at turan — Uito po'og torania kai ta'a­tu'e hap moherep teran haype i'ewyte ta'a­tue­sokpe ikahu kahato hap ete ta'a­tu­'apyk hap tote. Morekuat e'okipy tote te'e­renuk teran. Yt te'e­renuk teran i irania'in miit'in emiit wywo. ");
INSERT INTO mavNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Mi'iria pe Iesui to'e — Uhyt'i'in mana'in karãpeĩ more­kuaria eikaykay ienuk hap kape turan o yt eiwo­'o­'apyk tei'o iwato'in nakaria e'amyap tote eiwe­mo­wato haype hap e. Pyno po'og waku paa'e haria wo yn itote eweikup­te'en. Ma'ato ewei'apyk more­kuaria ewy turanuat put'ok'e wẽtup ok po'og iwato rakat eikawiat hat. ");
INSERT INTO mavNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mi'i hawyi aru ienuk hap ka'iwat to'e aru ehepe — Apuete uhyt mana etum no e'amyap meiũwat uiwy pe e aru. Mi'i hawyi era'apyk kuepe e aru. Mi'i pote aru eiwe­mõti hap kahato topy­hu'at ehete e. Mi'i hawyi ienuk hap e'at pe eremõti kahato yi tote apyk pe era'apyk hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mi'i pote woro­ho­'o­nãpin teran uhyt'i'in mana'in. Karãpe aikaykay ienuk hap kape turan waku wata­'apyk yt uwe mikuap i yatype. Mi'i pote aru ienuk ka'iwat tut ahowawi hawyi — Po'og waku morekuat amyap tote ro era'apyk mana uhyt e aru ahepe. Mi'i hawyi aiwe­mõ­typot hap itote topy­hu'at. I'ewyte aru itotiaria aikuap ta'yn more­kuaria mimõ­typot no watoĩ­ne'en hap are. ");
INSERT INTO mavNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Katu­pono mio tã e ehowawi AheTupana — Wemo­wato haria mohit hano areĩne'en e. Ma'ato wemohit haria mõtypot hano areĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mi'i hawyi tuwe­morem hawyi Iesui to'e i ienuk ka'i­waria pe — Uhyt'i'in mana'in e karãpe ienuk hap iwato rakat watunug teran yt naku i wati­'a­tu­kaykay ienuk hap kape aika­tu­wyria aiwy­ria'in iwato'in nakaria are. Po'og waku watu­wẽka ienuk kape yt uwe mikuap i ko'i hesy'at rakaria hatek takaria katu­pono mi'i haria yt aikaykay kuap i aru ta'a­tuenuk hap kape yt hekat rakaria i pote. Ma'ato aiwy­ria'in hekat rakaria yn wati­'a­tu­kaykay pote meiũran i'ewyte aikaykay ta'a­tuenuk wato hap kape. Yt naku i — Waku atikaykay uiwy­ria'in hekat rakaria ui'yat kape ienuk hamo katu­pono ati'a­tupoi hawyi i'ewyte wyti aru uikaykay i'atu'yat kape i'atu­mi'u u hamo yt naku i wato'e aiwa­nẽtup hawe wati­'a­tu­kaykay miit'in ehenuk hap kape turan. ");
INSERT INTO mavNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Po'og waku wato'e aiwa­nẽtup hawe — Waku po'og ati'a­tu­kaykay ui'yat kape tenuk hamo hatek sese rakaria ipiit sa'ag nakaria ipy sa'ag nakaria po'og waku wato'e. Waku yt ihapytig i rakaria yt miit'in miky'e ko'i i ati'a­tu­kaykay ui'yat kape ienuk hamo po'og waku wato'e are. ");
INSERT INTO mavNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pyno mi'i tã watunug hawyi Tupana meremo tikuap ahegyi'at hap hawyi wy ti aru meremo aru Tupana aikaykay tomi­mõ­typot ko'i wo wato­py­hu'at aipoi hamo toenuk wato hap kape e. Katu­pono hatek takaria ky'e haria wo watoĩ­ne'en Tupana ewywuat pote. Mi'i hawyi eweinõ'ẽ eiku­'uro hap pyi mi'i hawyi aru ta'aipok kahato ehowawi mekewat mi'u eimiium hap satek takaria piat enuk wato nug hap sa'up Tupana po pyi atipy pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mi'i hawyi wẽtup ok miit itote ihay kahato Iesui kape tenuk hap yparakai totepyi — Ikahu kahato tig ehay e. Urumu'e kahato En. Pywo aru meiũran meimuẽwat ienuk haria i'atu­wepit kahato Tupana yparakai henuk hap tote e. Ta'i Tupana put'ok'e Morekuat no hap e'at pe ienuk hap aimo­wepit kahato hap aru toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mi'i hawyi Iesui tiwesat — Pywo ti rat mehĩ wen ma'ato ti mesup ta'yn Tupana ti'a­tu­kaykay tenuk wato hap kape ma'ato mi'i pytkai miit'in yt tuwat teran i e. Pyno ahenoi ehepe mi'i iã'ãkap wuo. Wẽtup e'at pe so hekat kahato rakat ti'a­tu­kaykay kahato tominug ienuk hap iwato kahato rakat kape. Katu­pono Mi'i Miit miit'in Potypot nuat ieĩne'en hat. ");
INSERT INTO mavNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mi'i hawyi tuwehay po'oro kahato miit'in typy'i rakaria kape — Eweiõ'ẽ ro eweiõ'ẽ ro waku ra'yn aimi'u ikã'ã ra'yn iwato kahato rakat waku ra'yn eweiõ'ẽ mesuwe katu­pono yparakai tote ra'yn aimi'u wuat aimo­wepit hap e. I'ewyte ahesapo hy waku ra'yn wy e. U'i he kahato rakat toĩne'en e. Pyno eweiõ'ẽ ro e. Waku ra'yn eweiõ'ẽ ro uiwy­ria'in e. Pyno waku ewei'e ro irania'in me uiwy­ria'in me e te'e­ropat haria tehay enoi haria pe e. Mi'i hawyi tuwat. — Aimi'u ra'yn i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ma'ato — Apu i ete i'atu'e. Yt naku i te mesup areto e. Etikuap kat pote yt uipo­hepap i te mesup katu­pono atipuẽti ra'yn mesup yi wakuat uiweko nug hamuat e. Katu­pono mesup ta'yn ti areto hamuat mekewat yi hun kapiat ui'a­kasa uiweko nug hamuat hap kape e. Mi'i tote ti ikahu kahato. Pyno waku ere'e morekuat pe — Yt areto kuap enuk hap ikahu rakat kape e morekuat potpo­'oro pe. ");
INSERT INTO mavNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mi'i hawyi wẽtup ok pe i — To'iro morekuat enuk hap kape mehĩ e. Waku ra'yn e. Ikahu kahato tig itote e. Mi'i pote — Waku mehĩ e wen ma'ato ti mesup te yt areto kuap i e yt uipo­hepap i te mesup. Etikuap kat pote. Na'atpo atikyi'at 5 wewato ahup mi'i pote mesup areto ui'a­kasa hamo waku sio uimi­kyi'at ko'i sio yt hap kuap hamo. Sio i'atue­saika uhe'yara ekyi yi totiat hamo sio yt. Mi'i hap ko'i ete ti yt uipo­hepap i e. Pyno mi'i pote ere'e o morekuat pe — Areto teran wen waku kahato hap kape ma'ato yt areto kuap i. Pyno waure wo o morekuat toĩne'en uikai mehĩ e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mi'i hawyi wẽtup ok morekuat wy ok yat pe teke hawyi — Aim'u ra'yn mehĩ e. Ikahu kahato tig morekuat yat pe e. Iwato kahato tig ahenuk hap e. Pyno to'iro mehĩ e. Mi'i hawyi toiwesat — Pyno waku areto teran ni ma'ato ti yt uipo­hepap i te koitywy morekuat enuk hap kape e. Etikuap kat pote e. Ga'atpo atipuẽti uheha­ry'i ikahu rakat mi'i pote areĩne'en mesup iwywo e. Pyno waku ere'e morekuat pe — Waure wo soke ereĩne'en ere morekuat pe kat pote ti yt uipo­hepap i te. Mesup uheha­ry'i mowepit hap ete areĩne'en e. Mi'i hap ete areĩne'en mesup e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mi'i hawyi heropat haria te'e­ra­'aipok i ra'yn morekuat kape — Yt tõ'ẽ i wyti ewyria'in uhyt te'e­ro'e hamo. Mi'i hawyi toikuap yne ra'yn i'atu'e hap — Yt uipo­hepap i te mesup e haria yn aimi­kaykay ko'i i'atu'e hawyi morekuat ipy'ahak kahato i'atuete hawyi to'e tomi­po­'o­roria pe — Pyno eweiwat i ro wuat'i mu'ap wato upi wuat'i mu'ap hit ko'i upi. Mi'i hap upi ewei'a­tu­kaykay wuat'i haky­'e'i rakaria hatek takaria uhenuk hap kape e. Waku ewei'a­tu­kaykay yne tawa wato piaria yt hekat rakaria i yt ipy kahato rakaria i yt ipo kahato rakaria i yt ihapytig i rakaria yt hewyry kuap i rakaria ipiit sa'ag sa'ag nakaria yt uwe miky'e i ko'i mi'iria meikowo henuk hap kape ewei'a­tu­kaykay ro e morekuat teropat haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mi'i hawyi tuwat hawyi ta'a­tu­'a­tu­kaykay yne miit'in yt iwato'in nakaria i yt uwe miky'e i ko'i morekuat enuk wato hap kape. Mi'iria tõ'ẽ tõ'ẽ kahato howawi. Mi'i hap kaipyi te'e­ra­'aipok i ra'yn ihay moherep haria morekuat kape. — Urutunug na'yn ni emiky­'esat ewy mehĩ i'atu'e. Mi'i hawyi tõ'ẽ emikaykay ko'i i'atu'e. Typy'i kahato ti wen enuk hap tote tukup­te'en mesup ma'ato mi'i pytkai emi'u iwato kahato pote yt ta'a­tu'u kuap i yne i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mi'i pote morekuat to'e — Are pãi e pyno waku eweiwat i ro yne y'y hit i ko'i upiat gupte'en haria kape e. Yne tawa hit tawa hit ko'i kape ga'apy piaria kape e. Mi'iria eti'a­tu­kaykay meikowo hamo e. Katu­pono ti atiky­'esat ui'yat pyt'at nug yne miit'in miat hap e. Atiky­'esat nyti hik'e miit'in no ui'yat hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sa'a­wy­'i­wuaria uimi­kaykay ko'iria uimõ­py­'ahak kahato uiwy­ria'in sese mi'iria ui'y­wania pytkai yt tõ'ẽ i. Pywo pe ti rat are'e pyno yt karãpe i aru mi'iria te'e­renuk uimi'u wakuat rakat ete. Yt ta'a­tukuap i aru he hap. Yt wẽtup ok i ra'yn ti teke kuap irane uhenuk hawe uimi­kaykay sa'a­wy­'i­wuaria ko'i e morekuat topot­po­'o­roria tehay enoi haria pe. Mi'i hap ewy ti miit'in tukup­te'en mesup e Iesui. Tupana ti'a­tu­kaykay kahato koran te tenuk wato kahato hap kape e Iesui yt tehay mohey i haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mi'i hawyi Iesui toto i ra'yn hawyi typy'i rakaria miit'in tuwat tuwat ra'yn hupi. Mi'i hawyi tuwe­sai­pe'ok toupiat õ'ẽ haria mu'e hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Eweipy­hu'at teran uipot­po­'o­roria uhemiit sese wo mi'i pote woro­ho­'o­ky­'esat kahato. Mi'i pote ahenoi aikotã aikotã eweikup­te'en uhemiit sese wo hap uimi­ky­'esat ewywuat nug hap e. Uhupi ereto hap etiky­'esat pote eweitoiat yne eimi­ky­'esat e. Mi'i hawyi po'og uiky'e eiwat e'ywot kai ety kai ehary'i kai ehe'aito kai eimẽ­pyt'in kai eheyke'et kai eheywyt kai ehesa­ki'yt kai eiky­py'yt kai eheinyt kai i'ewyte eiwe­ky'e hap kai uiky'e uimi­ky­'esat nug hap po'og eimi­ky­'esat ko'i nug hap kai. Mi'i hawyi ewei'e — Uiku­'uro pote uiku­'uro ma'ato areto eupi ewei'e uhepe mi'i hawyi mi'i hap yn waku uhemiit no. ");
INSERT INTO mavNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma'ato eweiken'ẽ eiku­'uro hap pupi pote mi'i pote aria'yp posak ete eiku­'uro hap ui'ewy e hap yt eweiky­'esat i. Mi'i hawyi yt eweiwat kuap i uhupi uhemiit'in sese wo uipot­po­'o­roria wo e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pyno ahenoi hã'ãkap wo aikotã waku hap. Pyno so wẽtup ok surara akag tunug neran ywaiti rakat to'yat. Tu'uka teran itote pywiat hap mory'a wywuat hap. Mi'i hawyi tutunug hap e'yianme ti ipotpap kahato miwan ete karania upi mi'i hap nug hamuat hap ete karania e'at temiit'in poi hamuat hap ete karania upi nu wato kyi'at hap ete karania upi ha'up nug hap ete sio tekat put'ok'e inug hamo sio yt hap kuap hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mi'i hawyi tuwepe to'e — Pyno uiwe'eg wo mesuwat nug hap ete e. Yt naku i atunug wẽtup ipat'ok yn e. Waku atunug yne e. Ma'ato aha'a­wynug hap yn mote mi'i hawyi uhekat yt put'ok'e i ra'yn hawyi miit'in miky­ry'i areĩne'en aru e. Pyno yt atiky­'esat i mi'i tã pote waku atikuap sa'a­wy'i sio uhekat put'ok'e ui'yat ywaiti nug hamo e tuwepe. ");
INSERT INTO mavNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Pyno waku atunug yne kahato mi'i pote yn miit'in mimõ­typot no areĩne'en kuap e. Katu­pono atimo­waku yne kahato ma'ato yt pote ten to'o­ky­ry'i kahato uiminug ipat'ok hap ete e. Pyno mi'i iã'ãkap ewy kahato eweikup­te'en uhemiit no teran eweikup­te'en mote. Waku eweiwekuap ti sio pyt'ok­'e­wei'e inug hamo hap ete sio yt hap kuap hamo. Mi'i hawyi waku eweiwat uhupi e Iesui itotiaria pe — Urutuwat teran ehupi e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pyno wẽtup iã'ãkap i ahenoi ehepe e. Pyno sa'a­wy'i so wẽtup tawa porekuat to'e tuwepe — Pyno atimoma teran irania'in ywania uhewa­nĩ­kaptia uhesu­ra­ra'in wywo e tuwepe tuwa­nẽtup so e Iesui. Mi'i hawyi ma'ato yt atikuap i uhesu­ra­ra'in imoma hamo sio put'ok'e sio yt e so. Katu­pono uhesu­ra­ra'in sok 10000 surara yn ma'ato uhesu­ra­ra'in kai ma'ato uhewa­nĩ­kat­ptia esura­ra'in 20000 hap ewy tukup­te'en e. Mi'i hawyi morekuat ti'a­tu­kaykay tuwe­wawi tonãpin hat surara akag iwe'eg kahato rakat — Waku apo watuwat uhesu­ra­ra'in nywo uhewa­nĩ­kaptia moma hamo e sio apo yt e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Katu­pono ti uhewa­nĩ­kaptia tõ'ẽ kahato ahetawa moma hamo 20000 sura­ra'in wywo ma'ato aiwat ahesu­ra­ra'in 10000 surara yn tukup­te'en e. Mi'i pote atikuap teran waku watuwat sio yt hap e. Ma'ato yt naku i ewei'e pote woro­ho­'o­po­'oro eipe uhehay wywo i'atue­wawi i'atu­po­re­kuaria kape e. Mi'i hawyi waku watum ahekat aiwo­'o­wese hap nug hamuat e so mekewat morekat tesu­rara akag me e Iesui tehay iã'ãkap hawe itotiat — Urutuwat teran ehupi e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pyno mesuwat uhehay iã'ãkap wuo ahenoi teran ehepe aikotã waku eweiwat uhupi hap uhemiit'in sese wanuat hap. Pyno waku mi'i hap ewy he'yian­mete eiwe­wa­nẽtup niatpo kahato eito uhupiat hap ete e. Katu­pono pywo ti uwe uwe uhupi toto uwe uwe toto teran uhupi waku mi'i hat tuwa­nẽtup kahato — Atunug aru uika­'iwat miky­'esat ewy yn e. Pyno mi'i hawyi uiat uimi­ky­'esat atiwaure yne uiminug neran hap ko'i hawyi waku ewei'e eweiwat teran uipot­po­'o­roria waku ma'ato yt mio tã ewei'e i eiwat teran uhupiat hap ete pote yt karãpe i waku eweikup­te'en uhemiit no uipotpap nug hamo e Iesui areto teran ehupi e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mi'i hawyi Iesui to'e temiit'in me — Ewetum no ehewaure ka'a uhepe uiwy­ria'in e katu­pono uhehay pywo kahato pe are'e ehepe e. Yt uheso i rat eiperia aikotã ukyt ewy eweikup­te'en uipot­po­'o­roria sese eweikup­te'en hawyi e. Ukyt waku kahato aimi'u apopyt no. Mi'i hawyi hẽ'ẽ kahato waku kahato aimi'u mosẽ'ẽ hamo ukyt waku kahato e. Ma'ato toĩne'en ukyt yt he rakat i mesu­wa­rote uhemiit yt kan hamo i ewywuat katu­pono ukyt nop takat ewywuano tukup­te'en hawyi yt hẽ'ẽ hin i pote yt he i hap ewywuat hawyi yt kat hamo i e. ");
INSERT INTO mavNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ukyt yt hẽ'ẽ i rakat ti yt kat hamo i e. Yt naku i wy aimikoi ete katu­pono aimikoi auka hap topy­hu'at e. Pyno ukyt nop takat yt kat hamo i mi'i pote miit'in mipugha mu'ap tote ahetama pe hawyi miit'in mi'akit akit no toĩne'en mu'ap tote e. Mi'i hap ewy uhemiit yt he kahato rakat i ewy e. Pyno eiwa­nẽtup o uhehay mio wuat kape uiwy­ria'in e. Ehewaure ka'a apypok kahato uhehay kape e Iesui toupiat wat haria pe mu'ap upi. ");
INSERT INTO mavNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wẽtup e'at pe put'ok­'i­'a­tu'e kahato Iesui ete yt nakuaria i sese ko'i. Ta'a­tukuap teran ihay haype. Irania'in tukup­te'en itote sero­'ok'e haria ewywuat katu­pono mi'iria mu'ap pyhyp haria. Mi'iria ti wuat'i kaipyi ta'a­tu­ky­'esat sa'up ikoka'at hap hawyi. Mi'i sa'up ta'atuium more­kuaria pe Iuteu ywania ewanĩ­kaptia pe ma'ato yt ta'atuium i yne sa'up katu­pono sa'up po'og more­kuaria miky­'esat hap ok tã ta'a­tusat miit'in kaipyi hawyi ta'a­tu­pat'ok hawyi sa'up iwato ta'a­tu­te­ro'ok ta'a­tue­wanuat. Mi'i pote yt uwe miky­'esat i ko'i mi'iria tukup­te'en. ");
INSERT INTO mavNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mi'iria Iesui ti'a­tu­mu'e kahato Tupana ete. Mi'i hawyi Tupana mõtypot yat akag ko'i put'ok­'i­'a­tu'e itote hawyi te'e­ro'e — Kat poteĩ Iesui ihay yt nakuaria i wywo i'atu'e. Yt naku i ti mi'i tã watunug i'atu'e. I'ewyte Tupana ehay wan haria put'ok­'i­'a­tu'e itote wy. Mi'i hawyi ta'a­tu­mohit kahato Iesui — Kat poteĩ Iesui tenuk yt nakuat i sese wywo i'atu'e. Yt Tupana miky­'esat ewy i Iesui tunug i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mi'i hawyi Iesui tuwe­morem Tupana mõtypot yat apykok haria akag ko'i kape hawyi to'e i'atuepe — Uhyt'i'in e woro­ho­'o­mu'e teran sehay hã'ãkap wuo kat poteĩ Tupana ti'a­tu­ky'e kahato yt nakuaria i hap ete. ");
INSERT INTO mavNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Pyno so wẽtup ok toĩne'en tohũ 100 Uweuria rakat apykok hat e. Mi'i hat so wẽtup e'at pe toi'a­tu­mo­rania kahato tohũria hawyi toipuẽti 99 yn tohũria itote hawyi to'e — Are pãi wẽtup uihũ sig ho'o­wasat pãi e. Mi'i hawyi so aikotã som atipuẽti aru uihũ howasat rakat ehakye­ra'at hamo e. Mi'i hawyi so tohok­'iwat 99 rakat i'atuenuk hap tote. Mi'i rokirẽ toto tohũ ho'o­wasat rakat kat hamo. Mi'i hawyi so ho'o­wasat rakat kat hap ete yt ipohep hin i e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mi'i tusoke ti toipuẽti ra'yn tohũ ho'o­wasat hap tote. Mi'i hawyi totat hawyi tohupit hawyi toterut i ra'yn to'yat kape e. Mi'i hat so mi'i hawyi iwepit kahato tohũ wẽtup ok takat puẽti hap ete wẽtup yn ho'o­wasat rakat puẽti hap ete 99 ihũria yt ho'o­wasat rakaria i pytkai e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mi'i hawyi put'ok­to'e to'yat piat hawyi towy­ria'in toi'a­tu­kaykay tuwe­wawi tuwepit haypiat i'atupoi hamo hawyi to'e i'atuepe — Koitywy uiwepit hap e'at pe katu­pono uihũ ho'o­wasat rakat atipuẽti i ra'yn e. Pyno to'iro watenuk to'iro wate­sa­po'u pyno waku aiwepit mi'i hap ete e teka­tu­wyria pe e Iesui henoi hã'ãkap wuo itote. ");
INSERT INTO mavNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mi'i hawyi tomohey haria pe Iesui to'e — Ta'i karãpe aihũ wati­puẽti ho'o­wasat rakat aimo­wepit kahato hap toĩne'en e. Mi'i hap ewy kahato ti Tupana toĩne'en wẽtup ok miit ho'o­wasat rakat toipuẽti hawyi tuwe­mo­wepit kahato e. Pyno toiky­'esat kahato ti yt nakuaria i aipok tewawiat hap e. Toiky­'esat kahato miit'in waure wo toĩne'en neran ta'a­tu­minug sa'ag ko'i hap etiat hap e. Karãpe ho'o­wasat rakat wẽtup ok toipuẽti hawyi atipy piaria i'atu­wepit kahato Tupana wywo e. Ienuk hap iwato kahato ta'a­tunug hap ewy e. Mekewat sa'a­wy­'iwuat po'og yt nakuat i wemorem na'yn Tupana ewawiat hap imowepit kahato e. I'ewyte tukup­te'en 99 rakaria ewywuaria mi'iria ti — Uruto wakuaria e haria ewywuaria tukup­te'en — Yt karãpe i uruto ho'o­wasat rakaria wo e haria. Uruto hãpyk sese rakaria i'atu'e. Mi'i hap ewywuaria tukup­te'en 99 rakaria ewy uhehay iã'ãkap hawuo e. Tupana ti'a­tu­ky­'esat kahato yne tohũria ma'ato wẽtup ok ho'o­wasat ra'yn hawyi toikat kahato mi'i hat e. Yt waure hin i ho'o­wasat hap ete e. Mi'i hat puẽti hap hawyi po'og iwepit irania'in kai e Iesui — Kat pote pãi eti'a­tu­mu'e yt nakuat i rakaria ehay uhyt e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Mi'i hawyi wẽtup i ahenoi teran hã'ãkap wuo e Iesui. Ahetama pe ti ihainia'in tum hary­po­ria'in me — Woro­ky­'esat en uheha­ry'i wo pote atum epe mesuwat wahi 10 a imehit rakat Uru kawiat atum na'yn ha'up ekyi'at hamuat e hap moherep hamo hap ewy ta'a­tunug ahetama pe e. Mi'i hap ewywuat wẽtup a ta'at hewahi pyi hawyi toikat kahato hary­poria ahetama piat hawyi wãtym'i turan mote meremo te'aria uhu mi'i hawyi toikat to'yat pe. Yt toipuẽti i hawyi tohy­wytip to'yat hawyi yi perup we toikat kahato mekewat i'a mehit rakat at hat te'aito wuat miium tesa'up wote howoity kahato rakat wahi i'a mehit rakat e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mi'i hawyi toipuẽti ra'yn hawyi hary­poria iwepit kahato torania i ra'yn 10 a rakat hawyi e. Mi'i hawyi toi'a­tu­kaykay ra'yn towy­ria'in hary­po­ria'in tuwe­wawi mi'iria pe — To'iro watenuk wate­sa­po'u e katu­pono mesup e'at uiwepit hap sese toĩne'en katu­pono sa'a­wy­'iwuat uhe'aito miium uheha­ry'i wuat e hap 10 a rakat wẽtup atipun nakat atipuẽti hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mi'i hawyi to'e i itotiaria — Uruto po'og e haria pe. — Ta'i yt uheso hin i ti uhyt'i'in mana'in e. Aikotã hary­poria tipuẽti tewahi tomipun hawyi tuwehum iwepit kahato hap ewy ti Tupana ho'o­wasat rakat aipok towawiat hap ete tuwehum kahato e. Toi'a­tu­kaykay atipy piaria hawyi — To'iro aiwepit e katu­pono wẽtup ok miit ta'aipok uhowawi ho'o­wasat rakat itote e yt naku i sese nug haria mi'iria pytkai e. Mi'i hap ewy ti areĩne'en yt nakuaria i mu'e hamo yt eimi­ky­'esat ewy i pytkai e. Katu­pono Tupana tiky­'esat mi'iria aipok tuwe­wawiat hap pote e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mi'i hawyi Iesui to'e — Pyno wẽtup iã'ãkap i ahenoi Tupana tiky­'esat kahato yt naku i nug haria aipok hap tuwe­wawiat hap ete. Sa'a­wy'i so wẽtup ok ihainia typy ok ha'yru rakat toĩne'en. Mi'i i'atu­'ywot waku kahato rakat. ");
INSERT INTO mavNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mi'i hat so wẽtup ok ha'yru wat'yp'i to'e to'ywot pe — Papai yt atiky­'esat i epowat'yp eku'uro turan hawyi e ma'ato mesup ta'yn atiky­'esat e. Pyno etipat'ok o kat ko'i kat ko'i uhepe epowat'yp uiat e katu­pono uhewyry teran wyti Papai e. Mi'i pote toimõ'ẽ ra'yn tekat ko'i toku­'uro hap owakai e. Mi'i hawyi so wẽtup e'at hawyi — Pyno areto ra'yn Papai e so. ");
INSERT INTO mavNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mi'i hawyi to'ywot miium tohytmoi yne to'yara wato pe hawyi toto e. Iwato kahato totioto to'ywot ekat hawyi toto pya wẽtup tawa kape wẽtup y'y kape e. Mi'i hap tote toiwe­neru kat ko'i kat ko'i hawyi toikyi'at mahy ko'i hawyi tema­hy'u hary­po­ria'in toi'a­tu­kaykay kahato tuwe­wawi. Hairu hap yn tutunug at ka'ap itote to'ywot ekare'en sa'up mo tenuk kahato itote e. Towy­ria'in kyi'at hamo toipugha kahato to'ywot ekat yt tuwe'eg hin i haype toipugha topiit miky­'esat yt naku i nug hap upi e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mi'i hap tote tehairu at ka'ap pote to'ywot miium iwato rakat tekat toimo­weityk yne e. Mi'i hap e'at pe ti sy'at kahato hap ta'yn put'ok'e tuete hawyi yt kat i ra'yn mi'u kyi'at hamuat ha'up ipo pe e. Mi'i turan yt i'aman hin i yne mekewat tawa ko ete yi wato hap ok tã e. Mi'i hawyi i'atu­mikoi yt tuwenug kuap i hawyi yne yne i'atue­sy'at e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mi'i hawyi tesy'at sese ra'yn hawyi toho­'okat topoi hanuat. Toiky­'esat topotpap hap mi'u hit sa'up mo. Mi'i hawyi wẽtup ok yat kape toto mi'i hat pe to'e — Arepotpap teran eupi uhyt e. Mi'i hawyi — Pyno waku uhehamaut asuwai ko'i eti'a­tupoi at at e tope. Mi'i hawyi toto hamaut asuwai ko'i apykok hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mi'i tote hamaut asuwai py'a­setpiat toĩne'en turan hesy'at sese hap put'ok'e tuete hawyi ti to'e tuwepe — Pyno waku ahu'u hamaut asuwai mi'u ape kumana ape e. Mio tã tuwa­nẽtup hawe put'ok'e hamaut asuwai ka'iwat hawyi to'e — Yt etu'u tei'o ma'ato uihũria mi'u e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mi'i hawyi hesy'at sese hap tuete hawyi ti tuwe­wa­nẽtup kahato topy'a pe — Yt uiwe'eg hin i pãi e katu­pono areĩne'en hesy'at sese ma'ato yne ui'ywot eropat haria te'e­renuk at ka'ap kahato ui'ywot yat pe yne e'at pe mi'u pu'i sakpo'e tukup­te'en itote e. Mi'i hawyi ikap takaria wo ui'ywot eropat haria tukup­te'en ma'ato uito uikag mot'i rakat areĩne'en. U'i he rakat hẽ'ẽ rakat ete te'e­renuk at ka'ap ma'ato atu'u teran hamaut mi'u kumana ape ma'ato — Yt etu'u tei'o uhehamaut mi'i i'atu'e uhepe. Yt naku pe i areĩne'en mesuwe e tuwepe. ");
INSERT INTO mavNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pyno yt uiwe'eg hin i areĩne'en meiũpe pãi e. Pyno waku ara'aipok i ui'ywot yat kape hawyi — Papai are'e aru tope woro­ma'at kahato en uiminug sa'ag wo i'ewyte ti Tupana ma'at hano areĩne'en are aru tope e. Katu­pono ti ihamo ti atunug yt naku i hap are aru ui'ywot pe ui'aipok hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Pyno Papai uhewaku hap yt put'ok'e i te ra'yn esa'yru wat uheĩne'en hamo are aru Papai pe e. Mi'i tupono waku eropat hano ra'yn uinug Papai are aru e. Pyno mi'i hawyi — Uha'yru yt ere'e tei'o po'og uhepe ma'ato uheropat hat en ere'e ro aru uhepe papai are'e aru e topy'a pe tuwa­nẽtup hamaut asuwai py'a­setpiat toĩne'en hap e'at pe. ");
INSERT INTO mavNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mi'i hawyi ti paa'e sese ra'yn itote tuwak popuo hawyi topoĩ'ãm hawyi meremo toto ra'yn to'ywot kape. Mi'i turan i'ywot ta'a­kasa pya howawi mu'ap upiat hut turan. Mi'i pote i'ywot haty'u kahato topy'a pe tosa­'yru toiky­'esat kahato topy'a pe hawyi so i'ywot pun'e howa kape hawyi iporok'at tosa­'yru ete hawyi toi'ã­pysig tosa­'yru e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mi'i pote ha'yru to'e to'ywot pe — Papai yt uiwe'eg hin i e. Ekat atipun yne ra'yn uiminug sa'ag hap ete e. Yt naku i sese atunug Tupana ehamo wẽtup hy tote e. mi'i pote i'ewyte epe yt naku i atunug e. Mi'i pote yt put'ok­'are i ra'yn emẽpyt wuat uheĩne'en hamo ui'ywot e. Pyno koitywy waku areĩne'en eropat hano yn na'yn e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ma'ato ti i'ywot to'e — Yt nyti yt nyti uha'yru wo kahato ereĩne'en ne e. Mi'i hawyi kaykay'e teropat haria tehay pirik wo — Merep to eweterut ro uha'yru esokpe wuat ikahu rakat hawyi ewetopag ipiit pe. Mi'i hawyi i'ewyte ipy sokpe eweterut ro e. I'ewyte eterut ro muĩ'ãpiat hekat rakat hawyi ewetopag ipuĩ'ã pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mi'i hawyi to'e i tomi'u nug haria pe — Eweterut ro wẽtup wewato ahup mẽpyt aimi'u wo ikap takat e. Mi'i hawyi ewei'auka hawyi ewetey hawyi waku watenuk kahato e. Mi'i hawyi waku aiwepit hap sese watunug meiũpe e teropat haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Uha'yru sa'a­wy'i ho'o­wasat rakat toĩne'en iku'uro rakat ewy ma'ato mesup uimi­puẽti toĩne'en i. Sa'a­wy'i pya pyi aikai toĩne'en ma'ato ti mesup mi'i kaipyi tuwẽtem na'yn gu'uro pyi hap ewy toĩne'en e. Sa'a­wy'i ti ho'o­wasat kahato rakat ewy uha'yru toĩne'en ma'ato ti mesup uipuẽti i ra'yn e. Mi'i hap uimo­wepit kahato. Mi'i pote waku mesup aiwepit kahato hap watunug ahenuk hap iwato e. Mi'i hawyi ti te'e­renuk kahato ra'yn itote ha'yru mõtypot hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mi'i turan ti iyke'et put'ok'e toko pyi temiit'in nywo ta'aipok topotpap hap toko kaipyi hawyi yt pya hin i turan i'yat kai turan toikuap pypy'e hap toywyt ho'o­wasat sa'a­wy­'iwuat rakat mõtypot hap ienuk hap toikuap. ");
INSERT INTO mavNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Toikuap toywyt mõtypot hap to'ywot piat hawyi ti ipy'ahak kahato hawyi yt teke teran hin i ienuk hawe. Mi'i hawyi toi'a­tu­kaykay to'ywot emiit'in tuwe­wawi apoto'e hamo — Kat poteĩ i'atu­wepit meikope e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mi'i hawyi ta'a­tu­wesat — Mehĩ mimi i'atu'e eywyt mesup tut i'atu'e. Yt iku'uro hin i ti yt ai'ywot wanẽtup hap ewy hin i. Mi'i pote ai'ywot iwepit kahato hawyi mesup ai'ywot tiky­'esat mesup aiwo­'o­mo­wepit hap i'atu'e. Waku kahato ra'yn hap upi ti ei'ywot ti'auka tohũ mẽpyt ikap takat aimi'u aiwepit haypiat wuat i'atu'e. Ikã'ã ra'yn mimi uhyt i'atu'e pyno ereke ro mehĩ i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Toywyt yt naku i nug hat aipok hap toikuap hawyi po'og ipy'ahak iyke'et hawyi yt teke teran hin i ra'yn to'ywot yat pe. Mi'i hap toikuap hawyi i'ywot toto ra'yn howawi to'yat pyi ikaykay hamo — Ereke ro uha'yru e. Waku aimo­wepit yne aito mesup uha'yru e. Katu­pono eywyt ho'o­wasat rakat wyti wati­puẽti i ra'yn mesup e tosa­'yru yianme. ");
INSERT INTO mavNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma'ato — Yt rat Papai e. Yt karãpe i ti uimo­wepit hamo eti'auka ehũ ikap takat e. Arepotpap at at ka'ap ka'ap eimi­ky­'esat nug hap etiat pytkai ma'ato ti yt karãpe i uiat uimõ­typot hap etunug Papai e. Emiky­'esat ewy kahato atunug pytkai ma'ato ti yt waipaka i te wyti uiwy­ria'in wywuat uimo­wepit haypiat mi'u wo eti'auka e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma'ato ti mekewat uheywyt ekare'en sem pun hat esa'yru aipok hap pote ienuk wato hap etunug imõtypot hamuat etunug yt karãpe i emiky­'esat tutunug epiat pytkai e. Yt naku i mi'i hap Papai e. Ekat sa'up kaipyi ti hary­po­ria'in yt iwe'eg i rakaria toi'a­tu­kyi'at kahato e. Mi'i rokirẽ ta'aipok hawyi aihũ po'og he rakat eti'auka ma'ato imowepit hamo po'og he waipaka kawiat rakat eti'auka imowepit hamo wewato ahup ikap takat eti'auka imowepit hamo. Yt naku i Papai e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mi'i hawyi to'e i'ywot tosa­'yru yianmiat pe — Uha'yru e yt mio tã ere'e tei'o e. Atikuap ewat ewaku hap mi'i pote ti uipo­wat'yp epo pe yne ui'yat uihũria uiko ko'i ui'yat ko'i torania meimuẽwat epo puo toĩne'en uipo­wat'yp e. Atikuap ereĩne'en uiwywo wuat'i e'at pe hap e. Uhekat ko'i yne emiky­'esat ok tã toĩne'en ewano uipo­wat'yp e. ");
INSERT INTO mavNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mi'i pytkai ti mesup yt naku i ereĩne'en ipy'ahak eywyt ete are. Ereke ro uha'yru waku watu­mo­wepit mesuwat wãtym ka'ap katu­pono eywyt sa'a­wy'i iku'uro rakat ewy toĩne'en aiwa­nẽtup hawe ma'ato meiũ tut i ra'yn sa'a­wy'i ho'o­wasat kahato ma'ato mesup ti aipuẽti ra'yn e iyke'et pe tosa­'yru po'og nag nakat pe. Pyno ti ui'e hap ewy kahato ti e Iesui itotiaria pe. Katu­pono Tupana tuwe­mo­wepit kahato karãpe yt naku i nug haria ti'atoiat ra'yn ta'a­tu­minug yt naku i hap ko'i hawyi te'e­ra­'aipok Ta'a­tu­'ywot Tupana kape mekewat ha'yru ho'o­wasat rakat ewy e Iesui — Uruto po'og irania'in kai e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mi'i hawyi Iesui henoi hã'ãkap wuo topot­mu­'eria pe wuat'i nagnia ehay enoi haria py'a­setpe. — Sa'a­wy­'iwuat ieĩne'en hat so hekat kahato rakat toĩne'en i'atu'e so e. Mi'i hawyi so toikat kahato topotpap nug hap akag wuat hawyi to'e — Pyno waku ereĩne'en ui'e hap nug hap akag wo e. Atiky­'esat etimo­wato uheka­re'en e so. Waku etipo­re­ra'at yne uhepiat wete­weru haria kaipyi uhekat e. Mi'i hawyi ti ipotpap ta'yn hekat rakat ekare'en mowato hap ete. Ma'ato so wẽtup e'at pe tõ'ẽ kahato miit'in hekat rakat kape — Esaipepiat ti epotpap nug hat ti yt naku i sese yt hãpyk i sese ta'a­tu'e hamo e. Toi'a­tu­mona toi'a­tue­ro'ok atuero'ok ti ekare'en i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mio tã i'atu'e hap tepiat hawyi toikaykay temiit teka­re'en apykok hat tuwe­wawi apoto'e hamo — Uhyt e irania'in uhemiit'in henoi kahato ti uhepe eminug uima'at hap ko'i etiat e ma'ato yt atikuap i sio pywo sio yt e. Mi'i pote etimo­herep aikotã aikotã eminug epopera piat hap ko'i uhyt e. Atiky­'esat yne mesup miwan miat yne e ma'ato waku pytkai pote waku ma'ato pywo pote yt kan hamo i ereĩne'en po'og uipotpap nug hamuat e. Yt woro­ky­'esat po'og i en uhemiit akag wo e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","— Pyno waku etimo­herep emiwan yne aikotã hãpyk uinug hap. Mi'i hawyi toto toka­'iwat to'akag ma'at hat mi'i hawyi to'e tuwepe — Are pãi aikotã aru atunug e katu­pono toikuap aru uimiwan ko'i kaipyi toma'at uhepiat hap e. Mi'i hawyi aru yt kat i ra'yn uipotpap hamuat toĩne'en hawyi uheha­ky­'e'i aru arepy­hu'at e. Mesup te waku ma'ato meiũran yt naku i e. Uhesaika hap yt put'ok'e i te uiweko nug hamo e i'ewyte yt areĩne'en neran sẽtup sẽtup e hano e tuwepe tuwa­nẽtup hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aikotã aru atunug pãi e tuwepe. Pyno atikuap koitywy waku mesup ta'yn atunug uiwy­ria'in wo kahato uiwy­ria'in uika­'iwat piat uika­'iwat ewete­weru haria e. Pyno waku ati'a­tu­kaykay mi'i haria uhowawi hawyi waku atipat'ok i'atu­we­te­weru hap e i'atu­mo­wepit hamo e. Katu­pono areĩne'en ne mesup uika­'iwat emiit no te e. Katu­pono mũki­'ite uika­'iwat yt uiky­'esat i po'og na'yn e. Mi'i hawyi ma'ato waku uika­'iwat hekat rakat piat wete­weru haria yat pe areĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mi'i hawyi ika'iwat hekat rakat piat wete­weru haria toi'a­tu­kaykay tuwe­wawi. Mi'i hawyi to'e wẽtup ok pe — Karania upi kẽi ewete­weru uika­'iwat piat hap mehĩ e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","— Ta'i iwato kahato tig uhyt e aikotã 100 kamũti howapy kahato hap ewy Uriweira kap muat rakat ewy uhyt e. Mi'i hawyi toiwesat — Pyno ti waku wati­pat'ok hawyi waku 50 kamũti ikap yn uhyt e. Mio tã e pote wete­weru hat iwepit kahato tuwehum kahato. Mi'i hawyi miwan miat toiwan 50 yn iwete­weru hap e. Mi'i hawyi ta'a­tuset pehik mekewat miwan me hawyi toto. ");
INSERT INTO mavNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mi'i hawyi wẽtup ok i toikaykay wete­weru hat — Karania upi kẽi uika­'iwat piat ewete­weru hap uhyt e. — Ta'i iwato kahato e. 100 hyt u'i kapiat hap ewy uhyt e. Mi'i hawyi hekat rakat emiit akag tiwesat — Pyno waku wati­pat'ok ewete­weru hap hawyi waku etum 50 hyt yn e. Mio tã e pote wete­weru hat iwepit tuwehum kahato. Mi'i hawyi mekewat miwan me ta'a­tupag iwete­weru hap pakup 50 hyt kapiat yn iwete­weru hap mesup e hap. Mi'i te weset pehik i'atu'e. Mi'i tã ti tutunug at at toka­'iwat hekat rakat ma'at hat hemiit. ");
INSERT INTO mavNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mi'i hawyi wẽtup ewaty hap ete ika'iwat tikaykay tuwe­wawi hawyi toka­'iwat to'e temiit akag me — Are pãi pyno koitywy yne uiwe­te­weru haria ewyria'in no tukup­te'en uima'at kahato hap upi ewyria'in sem etunug hawyi e. Pyno erewy­'inug kahato uheka­re'en kaipyi e. Yt ikahu hin i eminug uhepiat hap atikuap ta'yn e. Pyno worokuap ta'yn ewe'eg kahato sa'ag nug hap etiat hap e so e Iesui sehay iã'ãkap wuo topot­mu­'eria pe. Mi'i hawyi to'e i Iesui i'atuepe — Ta'i uhyt'i'in mana'in mesu­wa­ro­tiaria i'atu­we'eg kahato sa'ag nug kahato hap ete sa'ag nug hap kuap kahato hap ete. Ma'ato Tupana mohey haria yt i'atu­we'eg hin i Tupana potpap nug kahato hap ete e. Ma'ato mesu­wa­ro­tiaria po'og i'atukai te'e­ru­we'eg e. I'ypy­rypwiat ikohye­wyry rakaria ewy mesu­wa­ro­tiaria sa'ag nug hap yn ta'a­tukuap kahato e. Mi'i haria ewy woro­ho­'o­ky­'esat eipe ma'ato wakuap nug hap kuap hap ete i'ewyte hẽtyhot puat wakuap nug hap ete e. Waku pyno eiwe­mo­we'eg kahato Tupana miky­'esat minug kuap hap ete e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Katu­pono mesu­wa­ro­tiaria miit'in tikat kahato to'o­po­wyro wo'o­ma'at hap etiat hap ta'a­tu­ka­'iwat hekat rakat ma'at hap kaipyi ta'a­tunug ta'a­tu­wy­ria'in mesu­wa­rote e. Uiwy­ria'in waku atiky­'esat kahato ewetunug uhekat kaipyi Tupana wyria'in wuat ko'i e. Mi'i hawyi mi'iria tukup­te'en wuat'i e'at pe atipy pe e. Waku wati­'a­tuekyi kahato miit'in hekat kaipyi miit'in Tupana wano e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Pyno uiwy­ria'in waku watunug yne aiwe'eg hap ok tã Tupana miky­'esat yne ete sio motpap wato nug hap kaipyi sio kurin motpap hap nug hap kaipyi waku wati­mõ­typot kahato Tupana aiminug ko'i hap ete e. Karãpe aheso hap kurin mi'i pote i'ewyte aheso hap iwato hap watunug kuap pote Tupana yt aimohey kuap i pywo sehay nug hamo e. Ma'ato hãpyk kahato aiminug kurin yn mytkai mi'i pote meiũran iwato rakat nug hamo Tupana aimohey kahato e. Ma'ato yt hãpyk i kurin kat aiminug kaipyi pote i'ewyte yt aimohey hin i iwato rakat nug hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Uiwy­ria'in eiwe'eg wo o ehekat mõ'ẽ hap ete. Waku hãpyk kahato eweimõ'ẽ Tupana miium ehepiat ko'i e. Ehegyi'at hãpyk kahato hap kaipyi ti aru Tupana eikuap hãpyk sio yt sio ehekat iwato sio kurin hap e. Ma'ato hãpyk kahato ehekat mõ'ẽ hap ta'a­kasa toikuap hawyi meiũran po'og tekat toimõ'ẽ kahato ehowawi eimohey hap toikuap hawyi eimohey hap upi e Iesui. Yt kat i i toma'at hap toikuap eikai hawyi po'og tutum ehepe teka­re'en hawyi i'ewyte wuat'i e'at piat kare'en tutum ehepe wy e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Uiwy­ria'in eiwe'eg wo o irania'in ekat eipo piat hawyi e. Yt eti'a­tu­ma'at rei'o i'atu­mi­puru ta'a­tuekat ete e. Ma'ato miit'in ekat etima'at epo pe toĩne'en mote meiũran yt kat i Tupana tum tekat ehepe yt eimohey i pote e. Mi'i hawyi yt karãpe i hekat rakano eweikup­te'en yt karãpe i Tupana mipoi­tyro wo eweikup­te'en e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Uiwy­ria'in eiwe'eg wo o eheka­re'en ko'i wywo eweikup­te'en e. Pyno wẽtup sehay i ahenoi teran ehepe e. Yt naku i kahato typy eika­'iwat e. Niatpo kahato ti pyno typy ok aika­'iwat pote e. Typy aika­'iwat hap kaipyi wẽtup aika­'iwat no wẽtup ahewa­nĩkap mo wẽtup aiwy ok sese wẽtup ahewa­nĩkap sese topy­hu'at e. Katu­pono yt watunug kuap i typy ok miky­'esat i ko'i e. Wẽtup ok aipo­'oro — Etunug no mi'i pytkai wẽtup ok — Yt e. Yt wate­ropat kuap i typy ok ahetu­'isa ko'i aipo­'oro haria e. Mi'i hap ewy kahato yt watunug kuap i typy Ahetu­pana wo e. Yt naku i watunug ahekat ne'i ahetu­pana wo katu­pono mi'i watunug hawyi ti Tupana sese yt watunug kuap i Ahetu­pana wo ahekat mowato hap kape yn aiwa­nẽtup hap hawyi e. Mi'i hawyi Tupana yt aipo­'oro kuap i towat nug hamo ma'ato ahekat ky'esat hap kape yn aipo­'oro. Mi'i tã ne'i pote ti typy ahetu­pana rakano watoĩ­ne'en. ");
INSERT INTO mavNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mio tã e pote itotiaria weka­re'en ky'e haria tero­mõ­pusu kahato Iesui Tupana ehay Musei mienoi kaipywiat enoi haria — Yt ewe'eg hin i ti Mehĩ i'atu'e. Waku kahato ti ahekat iwato i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mi'i pote Iesui ti'a­tu­wesat — Miit'in seha'at turan ti wakuaria sese eipe eweikup­te'en e. Yne eiminug ko'i ewetunug eimõ­typot hamuat hap miit'in ehamo e. Yt karãpe i ewetunug Tupana mõtypot hap eipy'a pe e. Eiwa­nẽtup hap ti Tupana tikuap kahato e. Toikuap kahato ti eipy'a piat eiwe­mõ­typot hap yn nug neran hap eiwa­nẽtup hap e. Mi'i hap upi mesu­wa­ro­tiaria te'e­ru­wehum kahato ehete e. Ma'ato Tupana eha'at turan ti yt naku i sese nug haria kahato eipe e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Koitywy irania'in tiky­'esat kahato tuwe­hyt'ok Tupana etama piat hap e. Ta'a­tu­ky­'esat kahato Tupana ta'a­tu­po­rekuat no hap e. Mi'i haria pyhyp haria kahato ti eipe e. Ewei'a­tu­mu'e kahato Musei miwan i'ewyte Tupana ehay enoi haria miwan kaipyi i'ewyte koran wuat het'ok hat Iuwãu ut hap kape mi'iria ma'ato wẽtup sehay yn henoi Tupana ut Wuat'i Porekuat nuat hap ete yn i'atuehay e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yne yne ti topy­hu'at aru i'atu'e hap ewy e. Yne i'atu­miwan hit ko'i aikotã aikotã aru hap ko'i topy­hu'at yne e. Yt wẽtup i i'atu­miwan kaipyi i'atueso hap — Tut ti aru tut ti aru i'atu'e hap yne e. Pyno yt karãpe i mi'i hap i'atu­miwan ikahuro aru e. Niatpo kahato ti aru i'atu­miwan hit tuwe­moma po'og niatpo at ikahuro hap kai e. Po'og niatpo waikiru ko'i yne ikahuro hap kai e. Katu­pono mi'i i'atu­miwan hit toĩne'en wuat'i e'at pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sa'a­wy'i Musei to'e ainãpin hamuat — Yt etoiat tei'o ehary'i e. Etoiat hawyi yt naku i wẽtup ok etat e. Ma'ato wẽtup ok i etat hawyi yt naku i nug hano ereĩne'en e. Aikotã hewaire hewaire rakano ewy ereĩne'en Tupana wanẽtup hawe e. Yt eimi­ky­'esat ewy hin i einãpin hap ehepe e. Yt etat rei'o hary­poria sa'a­wy­'iwuat he'aito mi'atoiat e. Ma'ato etat pote hewaire hewaire rakat ereĩne'en Tupana wanẽtup hawe e Musei sa'a­wy'i ahepe. Mi'i e hap miwan yt eweiky­'esat hin i ma'ato toĩne'en ne wuat'i e'at pe eweiky­'esat sio yt e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mi'i hawyi wẽtup sehay Iesui henoi i'atuepe. — Toĩne'en hekat rakat e. Mi'i hesokpe ikahu kahato e. Wuat'i e'at pe yne imiky­'esat ko'i toĩne'en e. Ienuk hap tutunug kahato e. Yne miit'in itotiaria ikuap mi'i hap ete e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Toĩne'en wy itote wẽtup ok yt hekat i rakat i'ahu kahato rakat hepihi pihi rakat Irasaru e hap het rakat e. Mi'i ti wuat'i e'at pe iwyria'in terut hawyi ta'a­tu­'atoiat hekat rakat e'oken­'y­pyke kat ẽtup ẽtup hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mipun mi'u ieĩpyt ko'i so'oẽtup hamo hekat rakat mi'u iwato kahato mipun kaipyi ma'ato yt toho'oium i yt hegyi'at hin i hekat rakat pote. Mi'i tusake sy'at pono iku'uro ra'yn. Mi'i hawyi ti toto ra'yn atipy kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Meiũran Irasaru iku'uro ra'yn hawyi atipy piaria tioto wakuaria ienuk ieĩne'en hap kape ha'a­se'i Aparãu e'yatypiat heĩne'en hamo e. Mi'i hawyi hekat rakat iku'uro hawyi ta'a­tusyp ta'yn e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma'ato aria kape toto ho'opot hap aria wato pe toĩne'en e. Mi'i hawyi ho'opot hap kaipyi hekat rakat teha'at ywaipe hawyi ta'a­kasa ra'yn Irasaru ase'i Aparãu e'yatype ra'yn toĩne'en. ");
INSERT INTO mavNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mi'i hawyi tuwẽ­powat — Ase'i e etipo­'oro ro meikowo uhowawi Irasaru y'y wywo e. Waku topuĩ'ã etiat y'y wo uhẽku pen e. Aho'opot kahato ra'yn mesup uito aria pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yt kat i i y'y uiwe­'y'u hamo e. Mio tã e pote Aparãu tiwesat — Uha'yru e etiwaure ra'yn apo eieĩne'en ne turan aikotã ereĩne'en sa'a­wy'i hap waku kahato yne emiky­'esat ko'i wywo ma'ato Irasaru ieĩne'en yi totiat turan ho'opot hap yn toĩne'en tuete ihaky­'e'i e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pyno meiũ wyti waku pe ra'yn toĩne'en Irasaru ma'ato en wyti ho'opot hawe yn meiẽ ereĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yt uwe i mesu­wiaria tokosap kuap ewawi i'ewyte yt uwe i ewywuaria tokosap kuap uruewawi e. Katu­pono toĩne'en yi hot iwato rakat yt kat i wyti meiũpepyi mu'ap ho'opot hap kape e Aparãu hekat rakat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mi'i hawyi hekat rakat to'e i ra'yn Aparãu me — Pyno etipo­'oro ro Irasaru ui'ywot yat kape uheywyt'in 5 ok takaria piat henoi hamo e. Katu­pono yt atiky­'esat i ra'yn wyti mi'iria tõ'ẽ meiũpe uhepiat ho'opot hap kape uiwy­ria'in e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma'ato Aparãu tiwesat — Uha'yru e tukup­te'en kahato eywyt'in nãpin hanuaria itote. Waku te'e­ru­wa­nẽtup Musei potnãpin hap ko'i kape i'ewyte Tupana ehay enoi haria mienoi kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mi'i hawyi hekat rakat — Yt rat e ma'ato wẽtup ok wẽtem gu'uro pywiat hat henoi i'atuepe pote taren yt tõ'ẽ i meiũpe uhepiat ho'opot hap kape ta'a­tuepiat ho'opot hamuat hap kape hawyi te'e­ru­we­morem Tupana kape ta'a­tu­minug sa'ag kaipyi pote e. Meremo ta'a­tu­minug sa'ag ta'a­tu­'atoiat hawyi Tupana ta'a­tu­mohey mi'i hawyi yt tõ'ẽ kuap i mesuwe ta'a­tuepiat ho'opot hamuat hap kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mi'i hawyi Aparãu to'e i ra'yn — Pyno yt atipo­'oro Irasaru i'atue­wawi katu­pono yt te'e­ru­wa­nẽtup i Musei mienoi kape yt te'e­ru­wa­nẽtup i Tupana ehay moherep haria kape pyno ti i'ewyte yt gu'uro kaipywiat wẽtem hat Irasaru toto henoi hamo pote i wyti teran te'e­ru­wa­nẽtup e Aparãu aria piat ieĩne'en hat pe e Iesui hekat rakat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Wẽtup e'at pe hawyi Iesui to'e temiit'in me — Mesu­wa­rotiat eikup­te'en turan wyti aru ehã'ãg haria sem put'ok­'i­'a­tu'e ehete hawyi ta'a­tu­ky­'esat aru ehepiat uimohey hap hep hamuat yt naku i nug hamo e. Yt waku pe hin i aru mi'iria tukup­te'en aru katu­pono po'og Tupana mi'a­piheg ko'i wo tukup­te'en wuat'i e'at pe aru are e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yt waku pe hin i mi'iria tukup­te'en aru aikotã wuat'i e'at piat y'y wato pe nu wato ete saity ete min'i­'a­tu'e yt ahen'i­'a­tu'e kuap i hap ewy ta'a­tu­ho­'opot aru eima'at reran haria uimohey hap ehepiat hep teran haria e. Mi'i hap ewy kahato ti uhemiit'in hira­karia iã'ãg iã'ãg i haria ete e. Tupana mi'a­piheg ko'i aru tukup­te'en aikotã y'y wato piat ahaity ete nu wato ãpe'ok etiat Mi'i hap ewy kahato ti hira­karia ma'at sa'ag nug hamuat haria ete Tupana mi'a­piheg ko'i aru tukup­te'en wuat'i e'at pe ho'opot kahato rakaria wo te'e­ro­py­hu'at. Yt naku i sese eweihep uimohey hap hirakat py'a pyi are. ");
INSERT INTO mavNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ewe'eg wo eima'at reran haria pupi e. Karãpe wẽtup ok ahã'ãg yt naku i nug hamo mi'i hawyi — Yt naku i mio tã watunug mehĩ mana waku wato'e aima'at reran hat are ma'ato — Yt uiwepyi i mehĩ mana to'e ahepe — Pyno waure wo areĩne'en uima'at hap kai mehĩ mana waku wato'e tope. ");
INSERT INTO mavNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yt naku i ipy'ahak aima'at haria etiat rakaria wo wato­py­hu'at e. Waku wati­'a­tu­wesat aima'at haria pytkai e. Waku he'i­hot'ok he'i­hot'ok pe i — Yt uiwepyi i e — Yt uiwepyi i e 7 wo to'e i to'e i ahepe pote waku — Uito waure wo areĩne'en wato'e i wato'e i 7 wo are. ");
INSERT INTO mavNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mi'i hawyi 12 ok takaria ipotmu­'eria tõ'ẽ Iesui ewawi hawyi te'e­ro'e Iesui pe — Uruka­'iwat uruimohey kahato po'og neran Tupana wuat'i nug hamo ete. Pyno etimo­wato o uruepiat imohey hap i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mi'i tã i'atu'e pote Iesui ti'a­tu­wesat — Uiwy­ria'in wato­mohey Tupana pote tutunug yne aimiẽtup e. Yt uheso hin i eimi­mohey yt iwato hin i pytkai ehã'ãg no imohey hawyi tutum eimi­mohey ok tã e. Ga'apy pe ti toĩne'en aria'yp koro ko'i po'og torania kai ma'ato iã'ỹi kurin kahato hap ok tã yt heremo hin i hap ewy wasere upi topopy rakaria iã'ỹi tuwe­mo­herep mekewat aria'yp koro ko'i e. Waku mi'i iã'ỹi ewy eweimohey Tupana. Aimi­mohey watikoi hawyi iwato topy­hu'at aru kurin kahato sa'a­wy'i pytkai katu­pono Tupana ti aimiẽtup nug hat pote e. Tupana mohey hap wywo ewei'e Wasere yp pe — Motoro ga'apy pyi hawyi erekoi ro ihyemui'a wato tote wato'e hawyi Tupana mohey hap wywo pote meremo tutunug ai'e hap ewy e. Mi'i hawyi Wasere yp toto meremo hawyi ihyemui'a wato py'a­setpe tuwekoi itote hap ewy eweimohey Tupana hawyi are. Ta'i yt aiminug kuap i ko'i Tupana tunug kuap meremo e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mi'i hawyi wẽtup sehay i tohenoi — Karãpe wata­'aipok i ai'yat kape ahesy'at kahato hap wywo hawyi meremo wato'e aheropat haria pe — Arewei hawyi meremo uipoi ro hawyi meremo uhe'yni ãti ro. Arenuk kahuro hawyi waku areket uhero pote wato'e aheropat haria ai'yat piaria ahetama pe more­kuaria watoĩ­ne'en pote. Yt karãpe i wato'e aheropat hat pe — Mesup atunug eimi'u hawyi waku erewei hawyi woro­ho­'opoi yt wato'e i aheropat haria pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mio tã wato'e — Ewetunug no uimi'u hawyi arenuk teran wato'e aheropat haria pe. — Aresa­po­hy'u hawyi areket hawyi waku wato'e ahetama pe more­kuaria aito pote. Uheropat hap kahu hawyi waku eweinuk eweiket wato'e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yt karãpe i more­kuaria koro ko'i te'e­ro'e ta'a­tue­ropat haria pe — Eiperia po'og uikai uheropat kahato haria eiperia pote yt i'atu'e i katu­pono morekuat ekat kaipyi tukup­te'en mote. Ta'i morekuat mi'u kaipyi te'e­renuk te'e­ro­sa­po'u. Morekuat sokpe kaipyi te'e­ru­we­painug. Ta'i morekuat sa'up ete i'atu­potpap pote — Waku kahato eipe yt i'atu'e i more­kuaria ta'a­tu­potpap nug haria pe ahetama pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pyno waku kahato wato­py­hu'at Tupana eropat kahato haria wo are. Waku Tupana miky­'esat ewywuat yn watunug are. Waku watu­we­potpap kahato imiky'sat nug hap ete aikotã morekuat eropat haria akag ko'i ewy. Yt naku i wato'e Tupana pe — Yt ewese hin i kat pote yt karãpe i uheropat yt karãpe i uimi­ky­'esat ewy etunug i'ewyte yt karãpe i uipoi yt naku i wato'e Tupana pe. Po'og waku wato'e Tupana pe — Arehum ewawi pote eropat hano areĩne'en waku wato'e Tupana pe. — Atunug neran po'og hãpyk emiky­'esat ko'i katu­pono yt naku i te areĩne'en emiky­'esat nug hap ete waku wato'e Tupana pe e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mi'i hawyi Iesui toto hãpyk kahato yi Karireia yi Samaria sakpo tawa wato Ieru­sarẽi kape. ");
INSERT INTO mavNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mi'i hawyi mu'ap upi Iesui toto wẽtup tawa hit kapiat turan 10 ok takaria hepihi pihi rakaria tõ'ẽ howawi. Ta'a­tu­'ahu pote yt tukup­te'en kuap i irania'in wywo. ");
INSERT INTO mavNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","I'atupe nem mote pya Iesui kai te'e­ro­py­hu'at hawyi te'e­ro­wẽ­powat haty wo — Uru'akag eraha'at ro uruewawi hawyi urueha­kye­ra'at i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mi'i hawyi Iesui ta'a­kasa i'atue­wawiat hawyi toikuap i'atuehay hawyi to'e i'atuepe — Eweiwat ro pa'i ko'i kape eipiit moherep i'atuepiat hamo ehehãite hap moherep hamo e i'atuepe. Tohenoi hawyi hepihi pihi rakaria tuwat ra'yn pa'i ko'i kape yt ta'a­tue­hãite hin mywo i te tuwat ma'ato mu'ap upiat tuwat hap tote i'atue­hãite ra'yn ta'a­tue­he­pihi kã'ã ra'yn i'atupe kahuria ra'yn. ");
INSERT INTO mavNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mi'i hawyi wẽtup ok ta'aipok Iesui kape hawyi to'e tehay pirik wo — Waku kahato Tupana pe katu­pono mesup ta'yn uimoe­hãite i ra'yn e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Put'ok­to'e Iesui ete hawyi porog myi ihay — Waku kahato uhete etunug Uika­'iwat e. Uimoe­hãite ra'yn En e Iesui pe. Mi'i miit aipok hat yt Iesui ywania kaipywiat hat i ma'ato yi Samaria ywania kaipywiat sut hat. Samaria ywania yt ta'a­tu­ky'e hin i Iesui ywania pytkai meiũwat Iesui mimoe­hãite tuwe­pỹ­'ã­tutuk — Waku kahato En e hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mi'i hawyi mekewat Iesui mimoe­hãite yi Samaria kaipy­wiaria Iesui py ywytpe hawyi Iesui to'e tope — Pyno 10 ok takaria ati'a­tu­moe­hãite mesup ma'ato en yn era'aipok uhowawi epihi kã'ã moherep hamo — Waku e hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","— Aikope pyno irania'in 9 ok takaria uimi­moe­hãite ko'i aikope tuwat mi'iria kat poteĩ yt tõ'ẽ i uhowawi — Waku ta'a­tu'e uhepiat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mi'i hawyi to'e — Waku era'aipok e'yat kape mehĩ e. Mesup waku pe ereĩne'en i ra'yn katu­pono uimohey hawyi emoehãite hap toĩne'en mesup e Iesui tomi­mo­hãite pe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mi'i hawyi tõ'ẽ miit'in Iesui ma'at reran hanuaria meimuẽwat Tupana ehay miwan etiat kuap kahato rakaria. Mi'i hawyi — Mehĩ i'atu'e uruikuap teran ehay i'atu'e. Karãpe aru put'ok'e mesuwat yi tote Tupana Aipo­rekuat nuat hap i'atu'e. Aikope aru pyno tuwe­mo­herep Aipo­typot no Tuapana i'atu'e. Mi'i hawyi Iesui ti'a­tu­wesat — Pywo ti rat yt heremo i hap ewy Tupana topy­hu'at yi Porekuat no tuwe­mo­herep mesu­wa­ro­tiaria pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yt uwe i ikuap are e. Yt naku i ewei'e — Meiẽ Tupana toĩne'en aipo­rekuat nuat. Yt naku i ewei'e — Ewei'a­kasa ro iuẽpe toĩne'en na'yn Tupana aipo­rekuat nuat yt naku i mio tã ewei'e katu­pono yt heremo i tuwe­mohep Eipo­rekuat nuat e i'atuepe. Ta'i eipy­'a­setpe yt heremo i hap ewy tuwe­mo­herep Tupana Eipo­rekuat nuat mesup ma'ato yt heremo hin i ehepe e tuwepe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mi'i hawyi Iesui to'e topot­mu­'eria pe tomohey haria pe — Uiwy­ria'in e mesup ta'yn Tupana toĩne'en Eipo­rekuat nuat eipy­'a­setpe e. Mesup ta'yn Eheyke'et toĩne'en eiwywo heremo kahato hap ewy ma'ato yt mot'i i areĩne'en eiwywo e. Areto hawyi ti aru ehehat'at kahato — Waku kahato sa'a­wy'i karãpe Aheyke'et Aikywyt toĩne'en aiwywo hap ewei'e aru uhepiat e. Waku kahato nimuat Aiwy toĩne'en aiwywo hap e'at ewei'e aru uhepiat e. Ehehat'at kahato mekewat e'at hawyi — Wati­ky­'esat kahato wẽtup e'at po'og Aheyke'et wywo Aikywyt wywo i ra'yn hap wati­ky­'esat ewei'e aru uhepiat pe eiwo­'ope ma'ato mi'i hawyi ti aru yt uipuẽti hin eipe hawyi uhehat'at kahato are e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mi'i hap e'at pe aru irania'in te'e­ro'e ehepe eima'at hamo — Pywo ti rat ta'aipok ta'yn Aheyke'et Aikywyt kuepe ra'yn toĩne'en i ra'yn i'atueso ehepe. — Pyno to'iro Aheyke'et Aikywyt ewawi i'atu'e aru ehepe irania'in eima'at hamo ma'ato yt eweiwat rei'o mi'iria upi uikat hamo katu­pono yt pywo pe i mio tã i'atu'e ehepe ma'ato eima'at hamo mio tã i'atu'e ehepe aru e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Katu­pono Uito Miit'in Eyke'et ut hap e'at pe turan merep e hap ewy ariot atipy kaipyi are e. Heremo sese hap ewy ariot atipy kaipyi are e. Wuat'i mikuap ewy uhẽtyhot kahato puo ariot Wuat'i Miit'in Potypot no ariot aru atipy kaipyi e Iesui tomohey haria sese pe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma'ato koitywy mesu­wa­ro­tiaria yt uimohey haria i tukup­te'en e. Pywo ti rat koran te ti mesu­wa­ro­tiaria irania'in Eheyke'et Eikywyt pun haria te'e­ro­py­hu'at are e. Yt ta'a­tu­ky­'esat hin i uimohey hap pãi e. Aho'opot kahato irane ta'a­tu­mi­ky­ry'i hap upi e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Pyno areto hawyi ara'aipok i mesuwe i ra'yn e. Sa'a­wy'i sese te mekewat i'aman at ka'ap 40 e'at piat hap turanuat mekewat aha'a­se'i pot Nu'e toĩne'en hap e'at piat turanuat yt uwe i aha'a­se'i pot Nu'e mohey hat toĩne'en e. Mi'i hap ewy kahato ti aru miit'in tukup­te'en wyti aru Eheyke'et ut hap e'at pe wyti aru are e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nu'e ieĩne'en hap e'at turan te'e­renuk hap ko'i kape yn ta'a­tu­wa­nẽtup mesuwat yi tote are e. Mahy u hap kape yn te'e­ru­we­wa­nẽtup at ka'ap e. Ta'i i'atu­wary wary kahato itote e. Wo'o­waire waire hap kape yn ta'a­tu­wa­nẽtup e. Yt te'e­ru­wa­nẽtup hin i mekewat Tupana ehay Nu'e mimo­herep kape i'aman koro tut irane e hap kape yt te'e­ru­wa­nẽtup teran hin i sa'a­wy'i e. Mi'i hawyi Nu'e teke ra'yn mekewat yara wato sese pe to'yat piaria wywo hawyi i'aman koro kahato ra'yn Tupana e hap ewy ra'yn hawyi y'y wato ta'am kahato yi tote hawyi y'y koro hap ewy yn toĩne'en yi tote hawyi yt imohey i haria y'y koro ti'a­tu­'a­tu­'uka kahato torania mesuwat yi totiaria e miwan me e. Mi'iria ewywuat aru tukup­te'en miit'in uhut hap e'at pe e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ta'i sa'a­wy'i sese Tupana to'e ase'i Iro pe — Eiwe­nõ'ẽ ro tawa wato Sutuma pyi katu­pono ati'a­tuwuk tawa Sutuma piaria i'atu­minug sa'ag upi e. Mekewat e'at pe Iro tuwẽtem turan mi'i hap e'at pe Tupana tiwuk ta'yn itotiaria e miwan me e. Mekewat e'at pe te'e­renuk at ka'ap hap ko'i kape yn te'e­ru­wa­nẽtup e. I'atu'yat nug hap kape yn te'e­ru­wa­nẽtup e. Ta'a­tueko nug hap kape yn ta'a­tu­wa­nẽtup e. Te'e­ru­we­sapo mahy u hap ko'i kape yn te'e­ru­wa­'a­tunug e. Wene­ru'i wene­ru'i hap ete wo'o­waire waire hap kape yn ta'a­tu­wa­nẽtup hawyi Iro tuwẽtem na'yn mekewat tawa pyi to'yat piaria hupi hawyi aria ra'yn hewo hewo itote atipy kaipyi hawyi yt te'e­ru­wa­nẽtup teran i Tupana e hap kapiaria wuk hamo e miwan me e. Mi'i hap ewy kahato ti aru mesu­wa­ro­tiaria tukup­te'en aru ara'aipok hap e'at pe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma'ato mekewat e'at pe karãpe Iro'in tuwẽtem na'yn tawa sa'ag Sutuma pyi hawyi aria hewo hewo ra'yn atipy kaipyi nukara ewywuat ko'i Tupana minug. Mi'i haria tawa Sutuma piaria Tupana ehay pun haria aria mi'u wo yn tukup­te'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mi'i hap ewy kahato ti aru miit'in tukup­te'en Eheyke'et ut hap e'at pe hamuat turan acre e. Yt uwe i Tupana ehay kape te'e­ru­wa­nẽtup mekewat e'at pe e. Ta'a­tu­minug ko'i kape yn te'e­ru­wa­nẽtup e. Uhut hap kape yt te'e­ru­wa­nẽtup hin i mekewat e'at pe hawyi ariot e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mekewat uhut hap e'at pe eweinõ'ẽ ro tawa Ieru­sarẽi myi meremo are e. Ehe'yni toĩne'en ei'yat pe pote yt ewei'aipok i eheka­re'en ko'i sat hamo are e. Meremo eweinõ'ẽ ro tawa Ieru­sarẽi myi are e. Eiko totiat eweikup­te'en mote uhut turan mote yt ewei'aipok tei'o ei'yat kape ehekat sat hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ase'i Iro ehary'i ta'aipok teran tawa Sutuma kape hawyi teha'at tawa Sutuma kape ta'aipok teran haype hawyi nu ukyt kawiat mana Iro ehary'i topy­hu'at itote e. Pyno yt ewei'aipok tei'o tawa Ieru­sarẽi kape Iro ehary'i ewy are katu­pono tuwe­nõ'ẽ tawa Sutuma pyi turan Tupana to'e Iro'in me — Yt eweiwe­ha'at tei'o tawa kape eweiwe­nõ'ẽ hawyi e ma'ato Iro ehary'i teha'at i ra'yn tosaipe hawyi ipiit nu ykyt kawiat topy­hu'at iha'at turan hawyi e. Toiky'e kahato toieĩne'en hap Sutuma totiat pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pyno eheĩne'en hap mesu­wa­rotiat eweiky'e kahato ewei'a­pykok kahato pote yt put'ok­'e­wei'e i eheĩne'en hap eheha­kye­ra'at wuat'i e'at piat hamo are e. Ma'ato yt eweiky'e kahato i eheĩne'en hap mesu­wa­rotiat pote ma'ato Tupana miky­'esat ewywuat hap upiat eweiwa­nẽtup hawyi pywo pe ti eweipuẽti wyti aru eheĩne'en hap sese eheha­kye­ra'at hap hamuat e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mekewat wãtym me Eheyke'et Eikywyt ut hap e'at pe turan tukup­te'en aru typy ok te'e­roket ne'i wyti aru getap wiat to'o­kipy pe e. Mi'i hawyi wẽtup ok yt uwe i ra'yn Tupana tioto hawyi ma'ato wẽtup yt uimohey hat i pote Tupana toiat ra'yn itote e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mekewat e'at pe turan uhut hap e'at typy hary­poria wemi­'utok haria tukup­te'en irane hawyi wẽtup hary­poria yt uwe i wyti aru Tupana tioto hawyi ma'ato wẽtup ok totoiat ra'yn itote yt uimohey hat i pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","I'ewyte wyti aru typy ihainia ta'a­tuko tote tukup­te'en wẽtup ok wyti aru yt uwe i ra'yn Tupana tioto hawyi ma'ato wẽtup ok totoiat itote mekewat e'at pe e. Yt uimohey hat i wyti aru totoiat e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mi'i hawyi iwyria'in apo'i­'a­tu'e Iesui pe — Urupo­rekuat i'atu'e aikope aikope aru eriot eut hap e'at pe i'atu'e. Mi'i hawyi toi'a­tu­wesat — Pyno mekewat uhut hap e'at pe put'ok'e hawyi meremo eweikuap uhut hap are. Ta'i karãpe wat'a­kasa Uruwu ko'i te'e­re­popy hawyi meremo watikuap i'okpuk takat toĩne'en itote i'atu­mi'u wo te'e­ru­wa­'a­tunug kahato itote pote e. Ta'i yt niatpo hin i watikuap aikope toĩne'en hap. Mi'i hap ewywuat yt niatpo hin i eweikuap aikope ariot hap e Iesui topot­mu­'eria pe ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mi'i hawyi po'og Iesui henoi tehay iã'ãkap wuo — Uiwy­ria'in e waku ahehay kahato Tupana kape e. Waku yt aipohep hin i ma'ato wahẽtup hẽtup hap pyi e. Tupana yt tum i aimiẽtup hawyi waku wahẽtup i e. Yt naku i ahehay yi kape yt hum i ahepe hawyi e. Pyno ahenoi teran uhehay hã'ãkap wuo aikotã waku wahenoi Tupana kapiat wahẽtup aimi­ky­'esat ko'i hap etiat e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Pyno sa'a­wy'i so wẽtup tawa piat toĩne'en morekuat esurara akag koro i'atu'e. Mi'i miit topy­hu'at morekuat mu'e hat uwe waku uwe yt naku i e hanuat i'atu'e e. Mi'i miit ma'ato ti yt Tupana mohey hin i hat i'ewyte yt toi'a­tu­ky'e hin i miit'in i'atu'e so e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","I'ewyte hiwu toĩne'en wy mekewat tawa tote i'atu'e. Mi'i ti toto mekewat surara akag kape katu­pono toiky­'esat topo­wyro hap. Mi'i hawyi topo­wyro hap tohẽtup mekewat surara akag me — Uipo­wyro ro e katu­pono tukup­te'en kahato miit'in yt i'atu­wese rakaria uima'at kahato rakaria e tope. Pyno wãi'ere ro uhewa­nĩ­kaptia pe mimi e so. Mi'i hawyi eweimo­hãpyk o i'atu­minug sa'ag uhetiat hap e morekuat emiit akag me. ");
INSERT INTO mavNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","— Ma'ato so mekewat morekuat surara akag yt ipowyro teran hin i haype mekewat hiwu i'atu'e. Mi'i pote yt toiwesat i tohẽtup hawyi i'atu'e so. Mi'i hawyi yne e'at pe yne wãtym me toto i hẽtup hẽtup kahato hamo ma'ato yt kat i tutum ipowyro hap i'atu'e so. Mi'i hawyi wẽtup e'at pe — Are pãi e tuwepe mekewat surara akag hawyi so — Yt areken'ẽ i Tupana pupi e. I'ewyte irania'in mupi yt areken'ẽ hin i ma'ato mesuwat hiwu pupi areken'ẽ kahato katu­pono yt areket kuap i mekewat hiwu tut at ka'ap hẽtup hẽtup hamo pote e. Yt naku i uhete pote atum pãi imiky­'esat ewy hawyi yt tut i uhowawi e tuwepe i'atu'e so e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ta'i uimo­sero mosero kahato rat mekewat hary­poria hiwu tehay wo e so. Mi'i pote atipo­wyro hawyi yt tut i e so tuwepe. Wuat'i e'at pe tut wuat'i wãtym me tut pote atum imiky­'esat ewy hawyi yt tut i e so e Iesui tehay iã'ãkap wuo. ");
INSERT INTO mavNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","— Pyno eiwe­wa­nẽtup to mekewat hiwu miẽtup uhehay iã'ãkap kape e. eiwe­wa­nẽtup to mekewat surara akag ehay kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","— Pywo ti rat Tupana yt mekewat surara akag sa'ag ewy hin i katu­pono Tupana tiky'e kahato temiit'in yne hawyi tutunug neran yne aimiẽtup towawiat hap are e. Pywo ti rat toiky­'esat kahato ahẽtup hẽtup kahato hap sio ihot'ok puo sio wãtym muo hap e. Ta'i waku wahẽtup tope at ka'ap yt aipohep hin hẽtup hẽtup hap etepyi e. Ta'i meremo Tupana timo­hãpyk aru irania'in minug sa'ag ahetiat ko'i wahẽtup hawyi e temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta'i areĩne'en Eheyke'et Uito mi'i pote uhut hap e'at turan ati'a­tu­'a­piheg kahato irania'in minug sa'ag uimohey haria etiat e. Ta'i uimohey sese haria ihay kahato rakaria Tupana mohey hawuo are e. Mi'i ewywuat Ui'ywot mohey haria ati'a­tukat kahato e. Uhut hap e'at pe mi'iria ewywuat ati'a­tukat kahato sio toĩ sio yt hap e. Are pãi yt atikuap i te sio tukup­te'en aru Tupana wywo ihay rakaria uimohey sese haria mekewat uhut hap e'at pe hap yt atikuap i te e Iesui temiit'in me ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mi'i hawyi wẽtup sehay iã'ãkap wuo Iesui henoi miit'in me katu­pono tukup­te'en itote — Uruto po'og wakuaria torania kai e haria yt irania'in atuky'e hin i haria. ");
INSERT INTO mavNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Mi'i haria pe Iesui henoi — Sa'a­wy'i so typy ihainia'in tuwat ra'yn Tupana mõtypot hap yat kape ta'a­tuehay Tupana wywuat hamo e. Wẽtup ok Tupana ehay moherep hat mi'i — Po'og uito irania'in kai e tuwepe hat e. Mi'i hawyi so wẽtup ok yt naku i kahato rakat katu­pono ipotpap ahewa­nĩ­kaptia porekuat emiit no aheka­re'en pore­ra'at hamuat wuat'i mu'ap upi hanuat mi'i e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mi'i hawyi so mekewat — Uito waku kahato rakat e hat put'ok'e Tupana mõtypot hawe hawyi teke aikope pa'i yn teke hawe pya kahato pyi irania'in yt naku i nug haria kai hawyi ihay se hap ewy Tupana kape — Waku sese kahato atunug e so uito po'og waku irania'in kai e so tuwepe tuwa­nẽtup hawe e. Arehum ewawi uiwaku hap upi e so. Uito yt irania'in ewy hin i i'atu­minug sa'ag hap ete e so. Uito waku kahato nug hat yn e so. Are pãi e uito ti yt miit'in ma'at hat ewy hin i e. Uito yt areĩne'en i wuat'i hary­poria wywo ehat i e. Waku kahato uito pãi e so. Tupana e so toĩne'en mesuwe e'yat pe wẽtup ok miit yt naku i sese nug hat e so. Mi'i miit ahewa­nĩ­kaptia esura­ra'in powyro hat hawyi aheka­re'en toipo­re­ra'at ahewa­nĩ­kaptia porekuat ekat no e so. Yt karãpe i ati'a­parap mi'i miit ewywuat e so tuwepe Tupana mõtypot yat pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ta'i waku kahato atunug yne ete e. Pywo ti rat typy e'at 7 e'at turan yt kat i hin i atu'u mi'u emõtypot hamuat haype e so. Waku kahato atunug katu­pono uhegyi'at kahato katu­pono uiko kaipyi uhekat kaipyi atimõ'ẽ 10 kaipyi wẽtup aterut ewawi Tupana hawyi 9 yn atioto ui'yat kape e. Iwato kahato ati'a­tu­mõ'ẽ uihũria kaipyi wẽtup 10 kaipyi atum e so Tupana pe e ma'ato mi'i tã to'e Tupana pe wuat'i miit'in tikuap tehay hamuat hap toiky­'esat e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mi'i hawyi mekewat yt naku i nug hat mekewat wanĩ­kaptia powyro hat wuat'i ekare'en pyhyp hat pya kahato irania'in waku nug haria kai toĩne'en oken'ypy ete. Yt teha'at hin i atipy kape Tupana ewawi tehay hamo ma'ato yi kape yn tehe'at hawyi tuwe­'ahyk ahyk tuwe­mõti Tupana wywo tehay hamuat haype. — Yt ui'a­piheg nei'o uiminug sa'ag upi e. Atikuap ta'yn uito yt naku i kahato rakano areĩne'en wen ma'ato uheha­kye­ra'at En hap atiky­'esat e Tupana pe paato'e haype e so e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Pywo pe are'e ehepe mekewat paa'e tominug sa'ag ko'i ete mekewat — Atoiat teran uiminug yt naku i e hat yn ta'aipok to'yat kape waku pe Tupana wanẽtup hawe are katu­pono Tupana tiwaure yne iminug sa'ag ko'i pote ma'ato mekewat — Uito po'og po'og irania'in kai e hat ete Tupana yt tiwaure kuap i iminug yt naku i ko'i hap kai katu­pono — Uito yt atunug i yt naku i e hat toĩne'en mote e. Mi'i hat ewywuat kahato eweikup­te'en katu­pono — Uruto po'og waku torania kai e haria eweikup­te'en e Iesui tewa­nĩ­kaptia pe itotiaria pe. Pywo ti rat are'e ehepe uwe uwe tuwe­mo­wato topy'a pe tuwa­nẽtup hawe — Uito po'og waku irania'in kai e hap wywo mi'i hat wy ti aru Tupana mimohit kahato rakano topy­hu'at wuat'i e'at pe wen uwe uwe paa'e topy'a pe tuwa­nẽtup hawe tominug sa'ag hawyi — Uheha­kye­ra'at Tupana pe to'e hat mi'i hat toĩne'en Tupana mimõ­typot no toĩne'en wuat'i e'at pe are e Iesui wuat'i miit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mi'i hawyi wẽtup e'at pe miit'in terut ta'a­tu­mẽ­pyt'in Iesui ewawi katu­pono ta'a­tu­ky­'esat kahato ta'a­tu­mẽ­pyt'in poityro hap Iesui po kaipywiat hap. Ta'a­tu­ky­'esat i'atue­waku Iesui piat hap. Mi'i hawyi tõ'ẽ howawi wen ma'ato Iesui emiit'in wãi'i­'a­tu'e hira­karia erut haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma'ato Iesui ihay pirik temiit'in me — Kat poteĩ ewei'a­tu­pyhyp hira­karia uhowawi haria e. Wãi nei'o are e katu­pono ati'a­tu­ky­'esat kahato hira­karia uhowawiat hap e. Yt ewei'a­tu­pyhyp tei'o hira­karia i'atuepap uhowawiat hap upi are e topy­'ahak hap wywo temiit'in me. Yt ewei'a­tu­pyhyp tei'o hira­karia katu­pono hira­karia timohey kahato Tupana are e. Ta'i hira­karia tuwe­hyt'ok teran kahato Tupana etama pe e. Tupana mohey kahato haria kahato ti hira­karia mi'i pote ti aru mi'iria ewywuat rakaria yn wyti aru tukup­te'en Tupana etama pe e. Mesuwe karãpe Tupana topy­hu'at Wuat'i Miit'in Porekuat no hap e'at pe turan mi'iria pe — Atum aru uhetama sese ehepe e. Atum aru mesuwat yi yne hira­karia ewywuat uimohey haria pe e Tupana e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","— Pywo pe ti eweiwat teran aikope Tupana toĩne'en morekuat no hap kape pote hira­karia tiky­'esat tuwe­hyt'ok hap ewy o eweiwat o are e. Ma'ato yt pote yt eweiwat kuap i e. Eweiwat ro Tupana mohey kahato hawuo hira­karia imohey kahato haria ewywuat pote ti aru put'ok­'e­wei'e aikope Tupana toĩne'en hap tote e Iesui topot­mu­'eria pe ta'a­tu­pyhyp hira­karia howawi turan. ");
INSERT INTO mavNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mi'i hawyi wẽtup ok Iuteuria ywania akag hekat kahato rakat apo'e Iesui pe — Uimu'e hat e waku kahato En e. Pyno uimu'e ro kat som waku atunug uheĩne'en wuat'i e'at piat hap kyi'at hamo e. Atiky­'esat kahato areĩne'en Tupana wywo wuat'i e'at pe e. Pyno kat som waku atunug mi'i hap puẽti hamo apo'e Iesui pe. — Waku sese kahato en e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mi'i hawyi Iesui to'e — Kat poteĩ — Waku sese kahato En ere'e uhepiat pe e. Tupana yn ni waku sese hap watikuap e. Uito apo areĩne'en Tupana wo ewanẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pyno etikuap apo Tupana piat ainãpin hap ko'i e. Etikuap aikotã Tupana ainãpin Musei miwan miat apo. Mio tã e — Yt naku i wẽtup ok wywo wẽtup ok wywo ehary'i e'aito e miwan me e. Yt naku i eti'auka miit e miwan me e. Yt naku i sero­'ok­'ere e miwan me e. yt naku i eso e. Etimõ­typot ro e'ywot ety e miwan me e. Mio tã e hap ko'i etikuap apo'e mekewat hekat rakat pe mekewat miit akag me. ");
INSERT INTO mavNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mi'i hawyi toiwesat — Ta'i ati'a­tukuap yne mekewat Tupana piat ainãpin hap ko'i mehĩ e. Ta'i uihire pyi te ti atunug yne yne mio tã e hap ko'i e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mi'i hawyi Iesui to'e tope — Waku mehĩ wen ma'ato wẽtup mo yt etunug i te e. Mi'i hap etunug hawyi waku pe ereĩne'en Tupana wanẽtup hawe e. Pyno ereto ro e'yat kape hawyi ekat iwato kahato hap eti'a­tu­mõ'ẽ yne yt hekat i rakaria pe miit'in haky­'e'i rakaria pe satek takaria pe e. Eti'a­tu­mõ'ẽ yne hawyi waku era'aipok uhowawi uhemiit no uhupiat eto hamo e Iesui mekewat miit'in akag me mekewat hekat kahato rakat pe. Mio tã etunug pote etipuẽti ekare'en sese wuat'i e'at piat mesuwe karãpe Tupana toĩne'en mesuwe wuat'i porekuat nuat hap e'at pe e Iesui mekewat hekat kahato rakat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma'ato mio tã e Iesui hawyi mekewat miit yi kape yn teha'at hawyi paa'e kahato katu­pono iwat heka­re'en iwato kahato hap toi'a­tu­ky'e kahato pote yt toimõ'ẽ teran i tekat sem hatek takaria pe yt hekat i rakaria pe pote. ");
INSERT INTO mavNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mi'i hawyi Iesui teha'at kahato mekewat hekat ky'e kahato hat ewawi hawyi toikuap ta'yn paa'e kahato hap hawyi toiky'e kahato hawyi to'e itotiaria pe — Are pãi e niatpo kahato ti rat weka­re'en ky'e kahato haria tuwe­hyt'ok aikope Tupana toĩne'en Morekuat no hawe are e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ta'i niatpo kahato yt hegyi'at i rakat teke atipy pe e. Niatpo kahato wateke atipy pe ahekat iwato wywo e. Niatpo kahato aikotã aihũ iwato kahato rakat mekewat Kameru e hap het rakat teke awi ehapo ka'a puo ma'ato sakpo niatpo sese ewy wekat iwato kahato ky'e kahato rakaria teke atipy pe e. Niatpo aihũ Kameru iwato kahato rakat teke awi ehapo sakpo po'og po'og niatpo tuwe­hyt'ok Tupana etama pe — Uhekat ti uhetu­pana wo toĩne'en e hat e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mio tã to'e hawyi wanẽtup haria itotiaria te'e­ro'e tope — Pyno yt uwe i teke kuap atipy pe hekat rakat i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma'ato Iesui to'e — Pywo miit'in yt uwe i teke kuap atipy pe e. Tupana yn tieha­kye­ra'at kuap miit'in e. Pywo pe ti rat miit'in yt tikyi'at kuap i ereke hap atipy pe e. Ma'ato Tupana yn miit'in ehakye­ra'at kuap e. Yt kat i niatpo Tupana wanẽtup hawe e. Miit'in yt minug kuap ko'i i yt niatpo hin i Tupana pe e. Tupana tieha­kye­ra'at kuap miit'in hekat rakaria pytkai e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mi'i hawyi Peteru to'e — Urumu'e hat uruto ti urui'atoiat ra'yn uru'yat ko'i urue'yara uruekat uruepotpap uruko eupiat tuwat hamo ehay moherep hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","— Pywo kahato ti e'e hap Peteru e. Woro­ho­'okuap kahato eipe e. Atikuap aikotã sa'a­wy'i eweitoiat yne uhupiat tuwat hamo hap e. Waku kahato ti rat eipe e. Pywo ti rat uwe uwe eipe ewy uiky'e po'og po'og to'yat kai toty kai teha­ry'i kai toywyt'in kai tomẽ­pyt'in kai topotpap kai hawyi toto uhehay Tupana piat Aipo­rekuat nuat e hap moherep hamo mi'i hat eipe ewywuaria wyti aru waku pe tukup­te'en wuat'i e'at pe atipy pe e Iesui Peteru pe ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Kat ko'i kat ko'i eweitoiat uhehay sytpok hamo wuat'i ywania enoi hamuat mi'i ko'i eimi­'atoiat ko'i atum aru ehowawi i ra'yn mesuwe ma'ato po'og po'og atum eimi­'atoiat sa'a­wy­'iwuat ko'i kai e. Ta'i eimi­'atoiat ko'i saipepiat uimiium ko'i po'og po'og iwato po'og ikahu atum ehepe eweiwat uhupi hawyi i'ewyte eheĩne'en hap Tupana wywo wuat'i e'at piat hap ikahu kahato hap atum ehepe e Iesui ahepe topot­po­'o­roria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Mi'i hawyi temiit'in Iesui tere­po'ok miit'in typy'i rakaria tokpyi enoi tepiat hamo. — Uheka­tu­wyria watuwat mesup tawa wato Ieru­sarẽi kape e. Itote ti aru ui'auka irane aikotã sa'a­wy­'i­tewuat Tupana ehay moherep haria miwan miat e hap ewywuat wyti ta'a­tunug sa'ag yne uhete Eheyke'et ete e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Itote ahewa­nĩ­kaptia ywania esura­ra'in po pe ra'yn uipag ui'auka hamo itote irane e Iesui. Yt naku i ta'a­tunug uhete e. Mi'iria te'e­ru­weu­ka'i kahato uhete ta'a­tu­mi­ky­ry'i uhete hawyi kuitu kuitu­'i­'a­tu'e uipiit ete uimohit haype irane itote e. Uito Wuat'i Miit'in Eyke'et pytkai uipun aru itote are e. Yt uimõ­typot hin i itote e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Uipak pak kahato itote hawyi aru ui'auka sa'ag ne'i aru ma'ato mi'i pytkai mye'ym e'at hawyi arẽtem aru uiku­'uro sese hap pyi e. Gu'uro pyi ara'aipok ehowawi i ra'yn. Ui'asyp pytkai arẽtem i ra'yn aru ui'asyp hap kaipyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tuwetiat tohenoi ma'ato hemiit'in yt ikuap hin i imienoi ko'i yt hot'ok'e i pote yt ta'a­tukuap kuap i i'e hap pote. ");
INSERT INTO mavNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mi'i hawyi Iesui toto temiit'in wywo tawa wato Ieru­sarẽi kape. Mi'i hawyi put'ok­'ia­tu'e tawa Ieriko ete. Mi'i tote toĩne'en apyk pe mu'ap ẽpeke ete yt iha pytig i rakat mu'ap tote. Itote pyi tohẽtup kahato miit'in miium ko'i teko ewy. ");
INSERT INTO mavNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Miit'in typy'i rakaria õ'ẽ hap toikuap hawyi tohẽtup ta'yn — Kat hamo som miit'in typy'i rakaria tõ'ẽ e apo'e mu'ap upiaria pe yt iha pytig i hat. ");
INSERT INTO mavNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mi'i hawyi ta'a­tu­wesat — Ta'i Mekewat Miit tawa Nasare kaipywiat wyti tut meikowo mekewat Iesui e hap het rakat i'atu'e ta'a­tu­henoi yt iha rakat i pe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mi'i hawyi mekewat yt iha rakat i tikuap hawyi tuwẽ­powat Iesui kape tehay pirik wo — Uipo­wyro ro uipo­wyro ro Morekuat Tawi Emiariru uheha­kye­ra'at ro En e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma'ato irania'in mu'ap upiaria — Wãi nei'o i'atu'e. Yt naku i ehay pirik hap i'atu'e. Epo'inik to i'atu'e wen ma'ato po'og ne'i tuwẽ­powat haty wo kahato hamo — Morekuat Tawi Emiariru uheha­kye­ra'at En e. ");
INSERT INTO mavNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mi'i hawyi Iesui topy­hu'at itote mu'ap tote hawyi to'e — Eweterut ro uhowawi iwẽpap'i kahato hat e mu'ap upiaria pe. Mi'i hawyi ta'a­tuerut mekewat sẽtup'e hat. ");
INSERT INTO mavNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Put'ok'e Iesui yatype hawyi apo'e Iesui — Kat e hap etiky­'esat uipo pyi mehĩ apo'e tope. Mio tã e pote — Mehĩ e uimoe­ha­pytig i hap epiat hap atiky­'esat kahato pãi e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","— Pyno waku ra'yn emiky­'esat ewy atunug e Iesui. Pyno waku ra'yn ereĩne'en e. Mesup ta'yn atum epe emiẽtup ewywuat e. Era'a­kasa ro are katu­pono uimohey kahato hap emoehãite hap topy­hu'at e Iesui yt iha i rakat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mio tã to'e Iesui hawyi meremo iha i ra'yn meremo waku i ra'yn iha ete ihapytig hap waku hap wywo toĩne'en kahato. Ta'a­kasa kuap i ra'yn hawyi — Waku kahato En Tupana waku kahato En katu­pono waku i ra'yn uheha e itote tehay se kahato hap ewy tuwehum kahato Tupana kape. Mi'i hawyi mu'ap upi toto ra'yn Iesui upi tawa Ieriko kape iwepit kahato hap wywo toto — Waku kahato En waku kahato En yn to'e Tupana pe itote. I'ewyte irania'in Iesui minug wakuat kapiat akasa haria te'e­ru­wehum yn kahato Tupana ete itote mu'ap upi Iesui toto tawa Ieriko kape turan. ");
INSERT INTO mavNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mi'i hawyi Iesui teke ra'yn tawa Ieriko pe. Mi'i hawyi tawa Ieriko sakpo toto mekewat tawa pu'ap upi tuwat. ");
INSERT INTO mavNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mi'i tawa pe toĩne'en hekat kahato rakat Sakeu e hap het rakat itotiat. Mi'i miit ri yt naku i kahato rakat toĩne'en irania'in wanẽtup hawe katu­pono ipotpap Iuteu ywnia wanĩ­kaptia esura­ra'in powyro to'y­wania ekare'en pyhyp hamo. Toikat kahato miit'in kaipyi i'atuekat pat'ok hap wanĩ­kaptia porekuat sa'up mo. Wanĩ­kaptia porekuat powyro kahato rakano toĩne'en mote tuwe­mo­wato kahato teka­re'en ete tawa Ieriko tote. ");
INSERT INTO mavNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mi'i hawyi Sakeu ta'a­kasa teran kahato Iesui kape ma'ato yt itypore i sese rakat pote yt ta'a­kasa kuap i miit'in tok piat sakpo Iesui kape. ");
INSERT INTO mavNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mi'i pote pun'e irania'in e'yianme wẽtup aria'yp mu'ap upiat kape hawyi meremo ta'am haga tote ywaipe pyi teha'at kahato Iesui ewawi ta'a­kasa teran haype. ");
INSERT INTO mavNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Put'ok'e Iesui aria'yp ypyke hawyi teha'at kahato ywaiti hawyi to'e — Uhyt Sakeu e era'apyk to uhowawi uhyt e. Mesuwat e'at pe at areĩne'en neran ewywo e'yat pe mehĩ e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mi'i hawyi meremo ta'apyk hawyi iwepit hap wywo — Hẽ to uhyt e. Waku kahato ereĩne'en ui'yat pe e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ma'ato irania'in tikuap Sakeu yat kapiat Iesui to hap hawyi te'e­ro'e to'ope — Yt naku i Iesui i'atu'e katu­pono ahewa­nĩkap yat kape toto i'atu'e to'ope yt nakuat i kahato rakat yat kape Iesui toto ra'yn yt Tupana miky­'esat ewy i tutunug i'atu'e ta'a­tu­py­'ahak hap wywo. ");
INSERT INTO mavNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mi'i hawyi Iesui toto mekewat mu'ap pyhyp hat upi mekewat Sakeu e hap het rakat upi i'yat kape. Put'ok­'i­'a­tu'e itote hawyi te'e­renuk hap upi mekewat Sakeu to'e Iesui pe — Uhyt e ipat'ok uhekat yne ti rat atimõ'ẽ mesup yt hekat i rakaria pe e. Pywo ti rat miit'in ekare'en pyhyp hap ko'i miit'in ma'at hap ko'i atum mesup i'atuepe e katu­pono atimo­hãpyk teran yne uiminug sa'ag ko'i uhero'ok hap ko'i atipo­re­ra­'aipok teran mesup uimisat ko'i yne mu'ap upiaria po pyi miit'in ekat ko'i e. Wẽtup ok hyt u'i atat uimi­po­hari po'og atum 4 hyt u'i atipo­re­ra­'aipok tuwe­wawi atum e. Atupo­hari hap ko'i yt naku i hap ewy atum yne i ra'yn uimi­ma'at ko'i pe e. Mekewat wẽtup hap ete uimi­po­hari ko'i ete atipo­re­ra­'aipok 4 hap ewywuat ipakup takat ko'i uimi­ma'at ko'i pe e. Pyno ati'a­tu­'atoiat teran uiminug sa'ag yne hawyi waku yn atunug neran mi'i hawyi e Iesui pe Sakeu. ");
INSERT INTO mavNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mi'i hawyi Iesui to'e irania'in me tawa Ieriko piaria pe — Uruto po'og waku irania'in kai e haria eipe e. Mesup ta'yn Tupana mieha­kye­ra'at no topy­hu'at Mehĩ Sakeu e. Mesup ta'yn ti rat Aha'a­se'i Aparãu emiariru sese toĩne'en mehĩ Sakeu katu­pono mesup ta'yn mehĩ Sakeu waku pe toĩne'en Tupana wanẽtup hawe e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mesup ta'yn Tupana mieha­kye­ra'at no topy­hu'at i'ewyte yne i'yat piaria waku pe toĩne'en e. Mi'i hawyi to'e mehĩ Sakeu pe — Pyno waku pe ra'yn mehĩ e mesup ta'yn Tupana mieha­kye­ra'at ereĩne'en wuat'i e'at pe e Iesui mehĩ Sakeu pe. Pywo ti Uito Eheyke'et ariot mesuwat mytyp kape ho'o­wasat rakaria kat hamo ariot e. Ta'i ho'o­wasat rakaria ehakye­ra'at hamo ariot miit'in kat hamo e. Ma'ato — Uruto po'og irania'in kai e haria yt atimo­waku kuap i katu­pono — Uruto waku ra'yn i'atu'e. Mi'i pote yt naku i rakaria wywo uhewyry i'atu­mu'e Tupana kuap hamo e Iesui tawa Ieriko piaria pe — Uruto po'og irania'in kai e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mi'i hawyi miit'in tuwat tuwat tawa wato Ieru­sarẽi kape. Mi'i hawyi i'atuehay kahato mu'ap upi — Pywo ti rat Tupana Mipo­'oro Aipo­rekuat nuat tut irane ahewa­nĩ­kaptia akit hamo hawyi waku pe watu­kup­te'en i ra'yn aikotã sa'a­wy­'iwuat hap e'at piat hap ewy i'atu'e to'ope mu'ap upi. ");
INSERT INTO mavNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mi'i hawyi yt pya i tawa wato Ieru­sarẽi kai turan Iesui ti'a­tu­mu'e mu'ap upiaria tehay iã'ãkap wuo — Sa'a­wy'i so wẽtup tu'isa waku rakat hekat kahato rakat wuat'i etama piaria mikuap toto ra'yn tetawa kaipyi morekuat koro kape. — Atiky­'esat wuat'i tu'i­saria akag wo uinug uruetama pe e hap wywo toto e so. ");
INSERT INTO mavNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma'ato toto morekuat koro kapiat hap owakai toi'a­tu­kaykay ra'yn toeropat haria akag ko'i 10 ok takaria tuwe­wawi hawyi so — Areto ra'yn Morekuat koro kape hawyi atiky­'esat ui'airo temiit akag wo mesuwat ahetama piaria wuat'i tu'i­saria akag wo e so. Pyno areto turan atiky­'esat uhekat eipo pe areto turan imowato hamo e so. Pyno atimõ'ẽ uhekat eipo pe hawyi waku areto ma'ato Morekuat koro uinug wuat'i tu'i­saria akag wo ahetama piat hawyi tutum uhepe tomiwan uimo­wato hap hawyi meremo ara'aipok mesuwe hawyi atiky­'esat uimiium ehepiat mowato kahato hap e so temiit 10 ok takaria pe. Mi'i hawyi wẽtup ok pe tuereto tutum nu mehit kahato rakat tekat kahato hap hawyi — Pyno areto ra'yn mesup e. Mi'i hawyi areĩne'en morekuat koro yat pe mekewat tama koro pe hawyi mi'i turan ewei'a­tu­mo­wato kahato o uhekat mesuwe e so. Mi'i hawyi iwato toimõ'ẽ i'atuepe nu mehit rakat hawyi toto tetawa pyi. ");
INSERT INTO mavNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Toto ra'yn tetama pyi turan hawyi so itotiaria tu'i­saria te'e­ru­wa­'a­tunug hawyi so meremo tuwat morekuat koro kape wẽtup mu'ap upi po'og meremo tuwat at ka'ap hap ewy. Mi'i hawyi so put'ok­'i­'a­tu'e mekewat tu'isa yianmete hawyi so — Morekuat i'atu'e tut wyti aru wẽtup ok miit uruetama pyi yne mikuap takat i'atu'e. Mi'i miit tiky­'esat kahato uruetu­'isa akag wo uruetama pe wen ma'ato yt uruiky­'esat i rat meiẽwat miit uruetu­'i­saria akag wo i'atu'e so. Yt naku i eti'airo mi'i miit wuat'i tu'i­saria akag wo uruetama pe i'atu'e so. ");
INSERT INTO mavNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pyno mekewat wuat'i miit'in miky­'esat hekat rakat etama puat gupte'en haria yt tiky'e hin i mekewat tu'isa e. Ma'ato mekewat morekuat eporekuat koro rakat tiky'e kahato hawyi — Woronug na'yn en uhemiit'in sem mesuwat yi totiaria porekuat no e tope. Mi'i hawyi ta'aipok ta'yn tetama kape morekuat koro mi'airo wo wuat'i miit'in porekuat no. Mi'i hawyi so itote hawyi toi'a­tu­kaykay ra'yn tuwe­wawi temiit 10 ok takaria teropat haria aikotã i'atu­potpap hap moherep hamo aikotã tomiium sa'awyi ta'a­tu­mo­wato hap kuap hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mi'i hawyi sa'a­wyiwuat put'ok'e hawyi to'e morekuat pakup we — Sa'awyi wẽtup eiam howapy nu mehit rakat hekat kahato rakat etum uhepe e. Koitywy 10 eiam howapy nu mehit rakat hekat kahato hap ewy aterut ewawi Uika­'iwat e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mi'i hawyi mekewat Tu'isa Wato pakup iwepit kahato hawyi toiwesat — Waku kahato etunug uhekat wywo areto hap turan e. Uhemiit kahato en uhyt e so. Waku rakat rasig en e. Pyno ewe'eg kahato uhekat wywo pote mesup woronug en uhemiit koro wo 10 uhetawa pe e temiit wakuat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mi'i hawyi wẽtup ok teke henoi hamo — Pyno sa'a­wy'i etoiat uipo pe wẽtup eiam nu mehit rakat hekat rakat e. Koitywy 5 eiam howapy atum epe uika­'iwat e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mi'i hawyi morekuat to'e mekewat temiit pe — Waku pyno etunug mehĩ e. Yt uima'at hin i pote mesup atum epe 5 tawa ko'i i'atu­po­'oro epiat hamo e. Waku ereĩne'en itote i'atue­tu­'isa akag wo e morekuat pakup temiit wakuat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mi'i hawyi wẽtup i teke towat etiat enoi hamo — Heno uika­'iwat meiũ ti emiium ok tã e. Sa'a­wyiwuat emiium ewywuat atum epe e. Uhesokpe ikahu rakat pe ati'a­pykok kahato mesuwat emiium hekat rakat e. Koitywy toĩne'en ne yne mesuwat sokpe pe emiium iwato hap ok tã. ");
INSERT INTO mavNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Pywo areken'ẽ epupi pote waku pe kahato atunug iheg me mekewat nu imehit kahato ko'i e. Ati'a­pykok kahato katu­pono worokuap kahato en uhyt e. Atikuap wy ewe'eg kahato hap kaipyi yt ewat i pytkai eti'a­tu­po­re­ra'at ekat ko'i e. I'ewyte yt emikoi i pytkai eho'ohep kuap irania'in ko ko'i hap atikuap e. Ta'i uruikuap kahato en aikotã ereĩne'en iwe'eg kahato epotpap nug hap ete ekat mowato hap ete e. Mi'i pote emiium atisyp yi pe hawyi mesup atum yne i ra'yn epe e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mi'i hawyi ika'iwat to'e tope topy­'ahak popuo — Uhemiit sa'ag kahato wo ereĩne'en pãi are e. Yt naku i kahato etunug uhekat wywo e. Uipy­'ahak hap etikuap pytkai uhekat yt eti'a­tu­mo­wato hin i e. Yt uiat i pytkai atipo­re­ra'at ere'e uhepe. I'ewyte yt uimikoi pytkai i aho'ohep ta'yn ere'e uhepe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Pyno ereken'ẽ uipupi hawyi kat pote kahu uhekat kahato hap yt etimo­wato i en wẽtup ok potpap nug hap kai e. Kat pote yt etipuru i wẽtup ok pe uhekat mowato hamo e temiit iperup takat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mi'i hawyi morekuat pakup to'e tesu­ra­ra'in me — Eweitat ro meiũwat uhekat uhemiit yt iwe'eg i rakat po pyi hawyi ewetum no ipo piat uimiium uhemiit wakuat pe hekat po'og mowato hamo e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mi'i hawyi hesu­ra­ra'in te'e­ro'e morekuat pakup we — Uruka­'iwat i'atu'e iwato kahato ra'yn ipo pe toĩne'en 10 eiam howapy ra'yn toĩne'en na'yn ipo pe kat pote pyno etum mo'og tope i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mi'i hawyi morekuat pakup to'e tesu­ra­ra'in me — Pywo pe ti uhekat mowato hat pe po'og po'og atum aru sa'a­wy­'iwuat kai e. Ma'ato yt iwe'eg i rakat pe uhekat mohit hat pe mio tã are — Sa'a­wy­'iwuat iwato kahato atum epe ma'ato mesup yt kat i po'og atum epe e. Mi'i hawyi mekewat kurin epo piat ewanuat tuweityk ta'yn hawyi yt kat i topy­hu'at epo pe aru e morekuat pakup temiit yt iwe'eg i rakat pe tekat tomiium yt imowato i hat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mi'i hawyi meimuẽwat sa'a­wy­'i­wuaria morekuat pakup wanĩ­kaptia — Yt uruiky­'esat i mi'i miit urupo­rekuat nuat e haria toi'a­tu­po­'oro tesu­ra­ra'in here­po'ok tewawiat hamo. Ta'a­tuerut hawyi mio tã e i'atuepe — Pyno sa'aw'i yt uiky­'esat hin i uito eipo­rekuat no e. Mi'i hawyi ehehay sa'ag kahato uhetiat hap atikuap ta'yn e. Yt naku i kahato eipe uiwa­nẽtup hawe e. Mi'i hawyi to'e tesu­ra­ra'in me — Meremo meiũpe ra'yn uhowakai te ewei'a­tu­'uka ro mi'iria e so mekewat morekuat pakup itote e Iesui tehay iã'ãkap wuo. Tuwepiat ihay tehay pun haria pe — Yt naku i Iesui Aika­'iwat no e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mio tã e tohenoi hawyi Iesui toto i ra'yn mu'ap upi mekewat tawa wato Ieru­sarẽi kape temiit'in sem e'yianmete toto. ");
INSERT INTO mavNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Put'ok'e mekewat mikoi ypia pe mekewat Uriweira ypia ko'i e'yity'ok totiat mekewat yi yt pya i tawa hit Pewake kai tawa hit Petania kai hawyi Iesui henoi typy ok temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Mio tã to'e — Eweiwat ro meiẽwat tawa hit kape hawyi put'ok­'e­wei'e itote hawyi eiwe­hyt'ok tawa hit pe turan aru i'atuhũ hit Iumenta mẽpyt eweipuẽti itote e. Mi'i i'atuhũ atiky­'esat mesuwe katu­pono i'ok pe tote uhewyry teran tawa wato Ieru­sarẽi kape e. Ma'ato yt uwe i te hewyry mekewat i'atuhũ hit okpe tote are e. Pyno ewei'a­sai­typok i'atuhũ hawyi meikowo eweterut uhowawi uihũ wo e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Itotiaria tikuap teran aru kan hamo i'atuhũ asaity eweipok e pote waku ewei'a­tu­wesat mi'iria — Ta'i Aika­'iwat Iesui tiky­'esat wyti eihũ waku ewei'e apo'e haria pe e Iesui temiit'in typy ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tuwat ra'yn meimuẽwat tawa hit kape hawyi Iesui to'e hap ewywuat kahato ta'a­tu­puẽti put'ok­ta­'a­tu'e itote hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","I'atuhũ ta'a­tu­'a­sai­typok turan put'ok­'i­'a­tu'e mekewat hũ ka'i­waria hawyi — Kan hamoĩ uruhũ ewei'a­sai­typok hamuat apota­'a­tu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mi'i hawyi Iesui emiit'in i'atu­wesat — Aika­'iwat Iesui tiky­'esat kahato ti eihũ i'atu'e Iesui mipo­'o­roria. ");
INSERT INTO mavNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mi'i hawyi — Pyno waku eweitioto ro i'atu'e. Mi'i hawyi ta'a­tu­'e­roto Iumentu hit Iesui kape. Puk'ok­'i­'a­tu'e Iesui kape hawyi ta'a­tu­po­rokpun na'yn ta'a­tue­sokpe ko'i mekewat hũ okpe tote hawyi ta'a­tu­mo­'apyk ta'yn Iesui ihũ hit okpe tote. ");
INSERT INTO mavNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mi'i hawyi mu'ap upiaria tipo­rokpun ta'a­tue­sokpe mu'ap tote Iesui to hap owakai ipu'ap ikahu rakat nug hamo morekuat ewywuat mu'ap nug hamo imõtypot haype ta'a­tunug. ");
INSERT INTO mavNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mi'i hawyi Iesui ipot'apyk mekewat yity'ok Uriweira ypia piat kaipyi tawa wato Ieru­sarẽi kape hawyi toto mekewat mu'ap miit'in minug upi toto tohũ hit tote apyk pe ipot'apyk. ");
INSERT INTO mavNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Yt pya hin i tawa wato Ieru­sarẽi kai turan typy'i rakaria hupiaria sem — Waku kahato En Tupana i'atu'e. Waku kahato Emi'airo Urupo­rekuat nuat i'atu'e ta'a­tuehay pirik wo. Meiũwat Miit timo­herep kahato Tupana esaika hap yt uwe mesu­wa­rotiat minug ewy i tutunug uruehamo i'atu'e kahato itote. En Tupana Mipo­'oro sese i'atu'e katu­pono uruta­'a­kasa ra'yn eminug ko'i Emipo­'oro mimo­herep ko'i i'atu'e i'atu­wepit kahato haype. Mi'i pote urutu­wehum kahato ewawi Tupana i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mi'i ta'a­tunug kahato itote hawyi wo'o­mu'e haria itotiaria te'e­ro'e Iesui pe — Wo'o­mu'e hat i'atu'e eti'a­tu­mo­po­'inik to epotmu­'eria i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mi'i hawyi Iesui ti'a­tu­wesat — Pyno mi'iria i'atu­po­'inik uimõ­typot hap ete pote meremo aru mesuwat nu ko'i mu'ap upiat te'e­ru­wẽ­powat uimõ­typot hap — Tut ri tut ri Tupana Mipo­'oro Wuat'i Ywania Ehakye­ra'at Hanuat i'atu'e aru nu ko'i are e Iesui tewa­nĩ­kaptia pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mi'i hawyi porap put'ok'e Ieru­sarẽi me hawyi Iesui teha'at tawa wato kape hawyi tuwak popuo to'e — Ieru­sarẽi miaria Ieru­sarẽi miaria ariot ra'yn ma'ato yt uikuap i eiperia e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mesup ta'yn aterut teran ehowawi wuat'i e'at piat eimo­wepit hap wen ma'ato yt heremo i pote yt eweikat i uimierut e tuwak popuo. Ta'i Tupana uipo­'oro eheha­kye­ra'at hamo hawyi eiwo­'o­wese hap wywo eweikup­te'en e ma'ato yt eweiky­'esat i pote mi'i hawyi uimienoi eiwo­'o­wese hap etiat yt heremo i ra'yn toĩne'en e. Mig'i wo ra'yn toĩne'en yt eweiky­'esat i hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Uimohey hap pun haria eipe pote ti aru ehewa­nĩ­kaptia esura­ra'in sem tõ'ẽ tõ'ẽ kahato irane eimoma hamo are e. Put'ok­ta­'a­tu'e ehetawa wato ete hawyi yne mu'ap ta'a­tu­pyhyp ehetawa kapiat e. Mi'i hawyi eimi'u yt kat i toĩne'en aru e. Mi'i hawyi yt eiwe­nõ'ẽ kuap i ehetawa pyi. ");
INSERT INTO mavNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","— Mi'i hawyi ehetawa wato pe tuwe­hyt'ok kahato ehewa­nĩ­kaptia sura­ra'in sem wẽtup ywania eiwu­'uka hamuat eimoma yne hamuat aru e. Ta'a­tu­'a­tu­'uka torania ehetawa piaria mekewat e'at pe aru e. I'ewyte ehetawa piaria topap topap yne e. Ei'yat ko'i ta'a­tu­puruk yne wyti aru e. Yt wẽtup i nu ehetawa piat tukup­te'en aru ei'yat nug hap katu­pono itote ta'a­tu­pugha yi kape yne ei'yat ko'i e. Hewo hewo yne nu wato ko'i yi kape aru are e. Pywo ti rat eimoma hap yn topy­hu'at aru e. Tupana mi'a­piheg ko'i eweipy­hu'at aru kat pote Tupana Mipo­'oro Eheha­kye­ra'at hanuat mohey hap pun haria eipe pote e Iesui tuwak popuo ma'ato eipe ti yt eweikuap i Tupana heĩne'en eipy­'a­setpiat hap e tuwak popuo tetawa Ieru­sarẽi piaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mi'i hawyi Iesui teke ra'yn tawa Ieru­sarẽi me hawyi Tupana mõtypot yat koro pe teke hawyi toi'a­tu­sopo kahato kare'en weneru wene­ru'i haria itote. ");
INSERT INTO mavNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Mi'i hawyi to'e wuat'i weneru haria pe — Wãi nei'o e yt ewetunug ne Tupana mõtypot yat kat weneru kat weneru hap netap e. Sa'a­wy'i mio tã e Tupana tehay moherep haria miwan me — Ui'yat yi tote atiky­'esat wuat'i ywania uhowawiat uiwywuat i'atuehay hamuat hap atiky­'esat ui'yat e Tupana sa'a­wy'i Isaia miwan 56.7 pe. Ma'ato eipe ti sero­'ok'e haria yat no ewetunug na'yn e Iesui wuat'i kat weneru haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mi'i hawyi mekewat e'at ko'i turan wuat'i e'at pe turan Iesui ti'a­tu­mu'e miit'in Tupana mõtypot yat koro piaria. Ma'ato pa'i akagnia miwan enoi haria i'ewyte tawa piaria akagnia i'auka teran kahato haype itote. ");
INSERT INTO mavNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mi'i hawyi hewa­nĩ­kaptia ti'a­tukat kahato aikotã waku Iesui auka hap ma'ato yne itotiaria i'atupap kahato Iesui ehay upi pote yt ta'a­tu­puẽti i mu'ap i'auka hamuat. ");
INSERT INTO mavNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wẽtup e'at pe Iesui toĩne'en Tupana mõtypot yat pe turan toi'a­tu­mu'e kahato itotiaria tehay wakuat Tupana etiat. Mi'i turan put'ok­'i­'a­tu'e howawi pa'i akag ko'i miwan ehay enoi haria wywo i'ewyte nagnia akag ko'i wywo. ");
INSERT INTO mavNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mi'i hawyi apo'i­'a­tu'e Iesui pe — kat pote ti rat eti'a­tu­sytpok miit'in ga'atpo Tupana mõtypot yat pyi i'atu'e. Yt naku i mi'i tã etunug yt uruehay upi i i'atu'e. Pyno uwe kahu epo'oro hat mi'i tã nug hamuat i'atu'e sio more­kuaria sio ewepyi mi'i sa'ag hap etunug i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mi'i hawyi Iesui ti'a­tu­wesat — Pyno ahenoi aru ehepe uwe uipo­'oro Tupana mõtypot yat apykok hamo ma'ato sa'a­wy'i atiky­'esat uiwesat hap ehepiat e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Pyno uiwesat ro — Uwe sese ahet'ok hat Iuwãu po'oro hat apo toĩne'en sio Tupana tipo­'oro Iuwãu sio miit'in tipo­'oro ahet'ok hap nug hamo apo'are e. Uiwesat ro mi'i hawyi woro­ho­'o­wesat wy uwe uipo­'oro Tupana mõtypot yat hywytip hamo e tewa­nĩ­kaptia pe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mi'i hawyi te'e­ro'e to'ope — Aikotã som waku wati­wesat Iesui katu­pono i'atu kahato mesuwe ahet'ok hat Iuwãu mõtypot kahato rakaria i'atu'e to'ope. Pyno — Tupana ipo'oro hat wato'e pote apo'e irane ahepe Iesui — Kat poteĩ pyno yt eweimohey i te urumi­mohey Iuwãu to'e aru ahepe i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma'ato — Tuwepyi tuwe­po­'oro Iuwãu wato'e mesuwe pote mesuwat irania'in sem Iuwãu ky'e haria meremo ai'auka wyti aru ta'a­tu­py­'ahak popuo i'atu'e. Katu­pono mi'iria — Tupana ehay moherep hat koro Iuwãu i'atu'e katu­pono ta'a­tu­mohey kahato te imienoi i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mio tã i'atu'e to'ope hawyi ta'a­tu­wesat ra'yn Iesui apo'e hap — Yt uruikuap i kahato te uwe sese Iuwãu po'oro hat i'atu'e. Uwe ehay pyi Iuwãu tut miit'in set'ok hamo hap yt uruikuap kahato i te i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mi'i hawyi Iesui ti'a­tu­wesat — Are pãi kat pote yt uiwesat i e. Pyno yt uiwesat i pote uito eipe ewywuat yt woro­ho­'o­wesat i rat uwe hay upi ati'a­tu­sytpok mesu­wepyi Tupana mõtypot yat piat yt naku i nug haria e Iesui pa'i kororia pe miwan ehay moherep haria pe nagnia akagnia pe. Mi'i hawyi yt kat i to'e i'atuepe Tupana Mipo­'oro Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mi'i hawyi hã'ãkap wuo Iesui henoi Tupana mõtypot yat koro piaria pe tewa­nĩ­kaptia pe — Wẽtup e'at pe so wẽtup yi wato ka'iwat warana koi hat ti'a­tukoi kahato tewa­rana ypia koro yi wato hap ok tã toikoi. Waku ra'yn hawyi so toipuru tewa­rana ypia to'y­wania pe hawyi to'e — Waku eti'a­tu­'a­pykok uhe'yi e hawyi eweium no uhepe sa'up wuat'i ewaty pe warana eweiwe­neru hawyi e warana ypia ka'iwat hawyi toto ra'yn pya wẽtup tama kape hawyi toĩne'en mot'i itote e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Meiũran mekewat warana ypia haat ra'yn hawyi mekewat warana ypia ka'iwat tipo­'oro temiit pya pyi mekewat warana ypia apykok haria pe towanuat warana sat hamo ho'ohep hap kaipyi. Ma'ato hemiit'in warana ypia apykok haria yt i'atu­wese hin i hawyi yt ho'oium i haype hawyi imipo­'o­roria pe ta'a­tuehay sa'ag hawyi ta'a­tu­pokpok hawyi ta'a­tu­po­'oro i ra'yn yt kat i hin i i'atupo pe wywo e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mi'i hawyi warana ypia ka'iwat wẽtup ok i ra'yn toipo­'oro ra'yn towa­rana ypia piat ipotpap takaria kape warana ko'i towanuat sa'up sat hamo i'atu­mi­po­'ok­su'at hamo ma'ato i'ewyte yt kat i ta'a­tu­ha­'upium tope ma'ato yt i'atu­wese hin i imipo­'oro ete hawyi ta'a­tu­pokpok imipo­'o­roria sa'a­wy­'i­wuaria ewy hawyi ta'a­tu­po­re­ra­'aipok yt kat i wywo i e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mi'i hawyi wẽtup ok temiit warana ypia ka'iwat tipo­'oro i ra'yn ma'ato mi'i miit mi'i hare ta'a­tu­'ahyk ahyk hawyi ta'a­tupun na'yn warana ypia pyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mi'i hawyi warana ypia ka'iwat tuwa­nẽtup — Aikotã waku atunug uimi­po­'o­roria pun haria ete e tuwepe hawyi to'e tuwepe — Pyno atikuap ta'yn aikotã waku atunug e tuwepe ta'i Uha'yru sese uimi­ky'e kahato atipo­'oro hawyi ti aru ta'a­tu­mõ­typot mi'i miit uimi­po­'oro katu­pono Uha'yru sese mi'i uimi­po­'oro pote e tuwa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mi'i hawyi toipo­'oro ra'yn wen ma'ato tewa­rana ypia apykok haria te'e­ra­'a­kasa hawyi te'e­ro'e to'ope — To'iro waku wati­'auka mesuwat yi warana ypia koro ka'iwat sa'yru i'atu'e to'ope. Ta'i pãi wati­'auka ha'yru hawyi ti aru ha'yru ywot iku'uro hawyi yt kat i ipowat'yp hawyi mesuwat yi yne aiwanuat tukup­te'en hawyi hekat rakaria wo watoĩ­ne'en i'atu'e sa'ag. Pyno to'iro warana ypia koro ka'iwat pakup auka hamo hawyi iku'uro hawyi yne i'ywot ekat sem topy­hu'at aipo pe ra'yn i'atu'e te'e­ro'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mi'i hawyi ta'a­tusat ha'yru hawyi ta'a­tu­pugha sa'ag ipiit i'ywot mikoi ypia pyi hawyi itote ta'a­tu­'auka sa'ag ne'i ha'yru e Iesui hã'ãkap wuo tuwepiat ihay tewa­nĩ­kaptia pe. Mi'i hawyi Iesui apo'e i'atuepe — Uiwesat ro kat pyno aru kat pyno aru ha'yru ywot tunug aru tomikoi ypia apykok haria sa'ag ete e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mi'i hawyi yt iwesat i. Mi'i pote Iesui to'e to'auka teran haria pe — Pyno ahenoi ehepe kat som tutunug mekewat Morekuat akag tosa­'yru auka haria ete e ta'i meremo tut tesu­ra­ra'in sem wywo hawyi toi'a­tu­'uka kahato Tosa­'yru auka haria hawyi tutum aru tewa­rana ypia e'yi wato wẽtup ywania po pe ra'yn hawyi toipag te'yi wato tomikoi warana ypia koro wẽtup ywania po pe i'apykok hamo e Iesui to'y­wania pe tehay pun haria pe. Mi'i hawyi itotiaria tikuap Iesui ehay iã'ãkap hawyi — Yt naku i kahato ehay ai'y­wania ete Uhyt i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mi'i hawyi Iesui teha'at tewa­nĩ­kaptia ewawi hawyi to'e — Pyno topy­hu'at aru ui'e hap ewy aikotã Tupana to'e sa'a­wy'i tehay miwan miat puo ewy e. Mio tã to'e — Waku ewetunug uimõ­typot yat Mesuwat Nu ikahu rakat iheg nakat kawiat e Tupana tomi­'ai­roria pe to'yat nug haria pe wen ma'ato — Yt naku i kahato Mi'i Nu Tupana Mi'airo i'atu'e hawyi inug haria yt tiky­'esat i ma'ato — Mi'i Nu po'og hesaika tora­nia'in kai po'og ikahu uimõ­typot yat nug hamo e Tupana tomiwan me e Iesui tuwepiat. ma'ato mi'i pytkai eweipugha Tupana Mi'airo e Iesui tomohey hap pun haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Uwe uwe yt tiky­'esat i Mekewat Nu Tupana Mõtypot Yat Nug Hamuat mi'i miit ri yt iwe'eg hin i topy­hu'at e katu­pono mi'i hawyi Mekewat Nu Wato toipun turan to'akit hap tokag pik hap topy­hu'at e miwan me e. I'ewyte uwe uwe tipun Mekewat Nu hawyi ta'aipok tuwe­wawi hawyi mekewat miit Mekewat Nu miku'i wo topy­hu'at e. Ta'i e Mekewat Nu Koro tote eiwe­ta'at hawyi eipiit pok'e itote hawyi Mekewat Nu Koro mimo­ku'i wo eweikup­te'en aru wuat'i e'at pe e Iesui to'auka kat haria pe tuwepiat tehay iã'ãkap hawuo. ");
INSERT INTO mavNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mio tã to'e hawyi pa'i akag ko'i i'ewyte nagnia ehay enoi haria te'e­ro'e to'ope — Yt naku i Iesui ehay ahete i'atu'e to'ope. Pywo pe ti ahetiat tohenoi mekewat hã'ãkap wuo i'atu'e. Mi'i pote ta'a­tu­pytyk teran Iesui i'auka hamo ma'ato miit'in pupi te'e­ro­ken'ẽ i. Katu­pono irania'in Iesui mimu­'eria — Waku kahato aimu'e Iesui i'atu'e to'ope mi'i tupono yt ta'a­tu­pytyk kuap i. Watat Iesui hawyi ipotmu­'eria ai'auka rakaria wo tukup­te'en i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ta'a­tukat kahato Iesui pytyk hamo wãtym muat hap yt heremo i hawuo. Ta'a­tu­ha'up nug ihainia'in me yt nakuaria i pe Iesui ma'at haria ta'a­tuehay wo. Mi'iria wakuaria ewywuaria tõ'ẽ ta'a­tuehay wuat Iesui ma'at hamo. I'atu­po­'oro haria ta'a­tupag neran Iesui ta'a­tu­po­rekuat nuat po pe i'auka hamo. Iesui ihay sa'ag hap morekuat ete hap ta'a­tukat hawyi. ");
INSERT INTO mavNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Put'ok­'i­'a­tu'e hawyi ta'a­tu­ma'at reran ta'a­tuehay wo — Wo'o­mu'e hat koro i'atu'e hãpyk kahato emienoi miit'in me uruwa­nẽtup hawe i'atu'e. Uruikuap aikotã Tupana miky­'esat yn ewy etunug miit'in me i'atu'e. I'ewyte pywo pe yn uruwesat hap uruikuap i'atu'e. Ta'i yt ereken'ẽ hin i rasig miit'in pupi Tupana ehay etimo­herep wuat'i miit'in me turan i'atu'e Iesui pe. Ta'i uruikuap aikotã waku kahato ereĩne'en wuat'i miit'in ky'e hap ete sio more­kuaria sio aheropat haria i'atu'e. Uruikuap aikotã miit emiit powyro hano ereĩne'en i'ewyte miit akag ko'i powyro hano ereĩne'en wy i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pyno ehenoi uruepe sio waku watum sa'up aipo­rekuat uruewa­nĩ­kaptia pe mekewat wẽtup ywania Humanu ywania porekuat wato Sesa e hap het rakat pe sio yt i'atu'e. Waku watum morekuat Sesa pe imiẽtup ewy sio yt apo'i­'a­tu'e Iesui pe ima'at hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mi'i hawyi meremo Iesui toma'at hap toikuap tuwepe hawyi to'e i'atuepe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Eweterut ro uhowawi mekewat sa'up wẽtup e'at piat aipotpap sa'up mekewat wẽtup imehit rakat kawiat e. Mi'i hawyi ta'atuium i'ape rakat Iesui pe hawyi apo'e i'atuepe — Pyno uwe miit akag iã'ãkap mesuwe miwan me uwe set toĩne'en meiũ sa'up i'ape tote e. Mi'i pote — Ta'i mekewat morekuat koro Sesa e hap iã'ãkap mekewat Sesa set itote toĩne'en miwan me i'atu'e ta'a­tu­wesat. ");
INSERT INTO mavNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pyno morekuat wato Sesa set toĩne'en itote pote Sesa wanuat toĩne'en are e. Mi'i pote morekuat Sesa wanuat tohẽtup i'ape ko'i pote ewetum no tope morekuat Sesa sa'up are e. I'ewyte Tupana miẽtup hap ok tã sa'up ewywuat ewetum no Tupana wanuat Tupana pe are e Iesui toma'at reran e haria pe apo'e haria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mi'i hawyi te'e­ru­we­mõti kahato Iesui pupi yt ta'a­tu­ma'at kuap i haype katu­pono Iesui po'og po'og iwe'eg nakat toma'at reran haria kai pote. Mi'i hawyi i'atu­pohep ta'yn miit'in sem ehamo Iesui apo'i­'a­tu'e hap. Mi'i hawyi yt kat i'atu'e kuap i itote miit'in ehamo ma'ato te'e­ru­wa­nẽtup kahato Iesui piat ta'a­tu­wesat hap kape. ");
INSERT INTO mavNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mi'i hawyi tõ'ẽ Iesui ewawi Tupana ehay miwan miat miit'in mu'e haria akag ko'i Satu­seuria e hap ko'i. Mi'iria ti — Aiku­'uro hawyi yt kat i ra'yn aheĩne'en pakup i hap e haria. ");
INSERT INTO mavNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tõ'ẽ hawyi apo'i­'a­tu'e Iesui pe — Wo'o­mu'e hat ahe'a­se'i Musei miwan me mio tã to'e ahepe — Eyke'et iku'uro hawyi ma'ato yt kat i te mẽpyt rakat pote waku iyke'et i hehiwu he'aito wo toĩne'en iywyt sa'yru nug hamo haki'yt nug hamo iku'uro yt kat i haipe­piaria pote e ti aha'a­se'i Musei tomiwan me i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","— Pyno sa'a­wy'i so tukup­te'en so 6 ywyt'in ta'a­tuy­ke'et etawa pe. I'atuy­ke'et toĩne'en teha­ry'i wywo hawyi iku'uro yt kat hin i ha'yru haki'yt te turan iku'uro so. ");
INSERT INTO mavNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mi'i hawyi so iywyt po'og wuat yian nakat wywo ra'yn hehiwu ma'ato iywyt iku'uro wy yt kat i imẽpyt i te turan. ");
INSERT INTO mavNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mi'i hawyi so wẽtup ok iywyt wywo ra'yn hehiwu toĩne'en ma'ato i'ewyte yt imẽpyt i te turan iku'uro so. Mio tã hap ewy 6 ok takaria iywyt'in hehiwu wywo toĩne'en tuereto hawyi yne so topap hawyi ta'a­tue­hiwu yt kat i imẽpyt rakano te so. ");
INSERT INTO mavNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mi'i hawyi so i'ewyte i'atue­hiwu iku'uro i'atu'e yt imẽpyt i te turan iku'uro so i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pyno uruikuap teran karãpeĩ tukup­te'en yne miit'in gu'uro pyi hawyi apuru uwe wary wo aru mekewat hiwu i'atu'e katu­pono 7 ok he'aito apo'i­'a­tu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mi'i hawyi Iesui ti'a­tu­wesat — Pywo pe ti mesu­wa­ro­tiaria wo'o­kyi'at hap ta'a­tunug ihainia'in hary­po­ria'in aikotã aikotã aheko ewy wen ma'ato atipy pe yt mi'i tã hin i e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ta'i miit'in tuwẽtem gu'uro pyi hawyi atipy piaria ewywuaria tukup­te'en wuat'i e'at pe yt kat i wo'o­kyi'at hap itote yt ta'a­tunug i wo'o­kyi'at hap itote are e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Katu­pono atipy piaria ewywuaria wo te'e­ro­py­hu'at mi'iria tuwe­nõ'ẽ gu'uro pyi hawyi yt i'atu­ku­'uro i wuat'i e'at pe tukup­te'en Tupana mẽpyt'in sese wo are e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","I'ewyte aha'a­se'i Musei miwan kaipyi wati­mu'e hawyi watikuap aheĩne'en pakup i hap watu­wẽtem gu'uro pyi hap watikuap katu­pono mio tã to'e Musei tomiwan me — Ta'i mekewat aria'yp wuk'e hap kaipyi Tupana to'e uhepe — Uito ti ewat e'ase'i Aparãu eTupana e. Uito ti e'ase'i Isaki eTupana e uhepe. I'ewyte Uito ti ewat e'ase'i Iako eTupana e uhepe aria'yp wuk'e hap kaipyi e Musei tomiwan me mekewat e'at ihay Tupana wywo hap e'at pe turan e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mi'i tupono aha'a­se'i Musei miwan kaipyi watikuap aha'a­se'i Aparãu Isaki Ioko toĩne'en ne ta'a­tu­ku­'uro pytkai katu­pono Ahetu­pana ieĩne'en haria eTupana wo toĩne'en are. Yt naku i map haria eTupana Ahetu­pana toĩne'en wato'e e. Ta'i ieĩne'en haria eTupana katu­pono Musei mio tã e — Tupana ti gupte'en haria aha'a­se'i Aparãu Isaki Ioko eTupana toĩne'en Aparãu Isaki Ioko iku'uro rakaria tukup­te'en pytkai Musei toĩne'en mesuwat yi tote turan pytkai mio tã e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mi'i hawyi wẽtup ok miwan ehay enoi hat itote to'e Iesui pe — Wo'o­mu'e hat waku kahato uruwesat hap e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mi'i hawyi yt apo'i­'a­tu'e kuap i po'og na'yn Iesui pe miwan kuap kahato rakaria. Mi'i hawyi i'atu­ponik ta'yn — Are pãi i'atu'e ta'a­tu­wa­nẽtup hawe iwesat kuap kahato Iesui pote yt wati­'a­parap kuap i Mi'i ahehay wo i'atu'e. Ta'i Mi'i Miit po'og iwe'eg aikai i'atu'e Iesui piat ta'a­tu­wa­nẽtup hawe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mi'i hawyi Iesui to'e i Musei miwan kuap kahato rakaria pe yt apoto'e hap wesat kuap i rakaria pe — Wo'o­mu'e haria e kat pote ri rat ewei'e eimu'e haria pe — Tupana Mipo­'oro Aipo­rekuat nuat ri morekuat Tawi emiariru emiariru kaipywiat tuwe­mo­herep ewei'e ahepe e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Katu­pono sa'a­wy'i sese aha'a­se'i pot morekuat Tawi to'e tomiwan me towepy hawe — Uipo­typot koro Tupana to'e Uipo­typot koro Tupana pe — Era'apyk o Uimi­mõ­typot no mesuwe uipo sese kai e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Waku ereĩne'en mesuwe uikai hawyi ti aru atunug ewanĩ­kaptia yne epy ywyt'ok­pype e TUPANA UIKA'IWAT pe e aha'a­se'i morekuat Tawi towepy hawe e. ");
INSERT INTO mavNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pyno Tupana Mipo­'oro Aika­'iwat nuat toĩne'en pãi Tawi KA'IWAT KORO wo e. Kat pote pyno ewei'e — Morekuat Tawi emiariru emiariru topy­hu'at aru Tupana Mipo­'oro Aika­'iwat Koro wo yt Tawi e hap ewywuat e Iesui tuwepiat e yt tomohey i haria pe Iesui morekuat Tawi ka'iwat pote mio tã. ");
INSERT INTO mavNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mi'i hawyi itotiaria te'e­ru­wa­nẽtup kahato Iesui e hap kape turan Iesui to'e temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Uheka­tu­wyria e eiwe'eg wo o miit'in ehamo miit'in mikuap mo watunug waku aiwe­mõ­typot hamo aiwe­mo­wato hamo yt Tupana mõtypot hap ky'esat hap wywo are e. Katu­pono yt naku i wato­py­hu'at typy ehay moherep haria ewy are e. Mi'iria ti — Waku po'og uruto irania'in kai i'atu'e ta'a­tu­wa­nẽtup hawe e. — Waku po'og uruto eimu'e haria akag wo ewei'e uruepe i'atu'e ahepe. Mi'iria ta'a­tu­mõ­typot hap miit'in miat yn ta'a­tu­ky­'esat ta'a­tu­minug waku hap kaipyi miit'in ehamo miit'in mikuap mo. Yne waku hap ta'a­tunug wen ma'ato Tupana mõtypot hap kape yt te'e­ru­we­wa­nẽtup hin i e. More­kuaria wywo yn te'e­ra­'apyk teran haype Tupana mõtypot yat hawe ienuk hap iwato rakat hap tote — Eiwe­ha'at ro uruewawi e hap yn toĩne'en i'atu­py'a pe. Yt naku i mi'iria ewywuat watoĩ­ne'en e Iesui temiit'in me ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mi'iria i'atu­wẽpap se kahato Tupana kape ma'ato yt pywo pe i e. I'atuehay i'ywop kahato ta'a­tunug Tupana kape miit'in ehamo miit'in mikuap mo — Uruto Tupana kuap kahato haria e hamo irania'in me ma'ato yt Tupana kape hin i i'atuehay are e. Yt eweimohey tei'o mi'iria katu­pono yt pywo pe i i'atuehay se ma'ato ahekat ky'ewi Tupana mohey haria tukup­te'en are e. Ta'i i'atuehay at Tupana kape miit'in ehamo miit'in mikuap mo. I'ywop kahato ta'a­tunug ta'a­tuehay Tupana kape wuat'i miit'in ehamo ma'ato yt pywo pe i e. Eiwe'eg wo o pyno mekewat typy sehay nug haria pupi are e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mi'i hawyi Iesui teha'at miit'in kape i'atumiium Tupana kapiat hap kape teha'at kahato hawyi ta'a­kasa ra'yn hekat rakaria miium hap kape. Iwato kahato ta'a­tupag heiam me Tupana mõtypot hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","I'ewyte ta'a­kasa wẽtup ok hiwu yt hekat rakat i itote hap kape ta'a­kasa. Mi'i hawyi hiwu tum na'yn tomiium kurin sese hap ewy tutum katu­pono typy kurin kat ape yn totopag mekewat yparakai tote Tupana kapiat imiium heiam ika'a pe totopag hap kape ta'a­kasa Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mi'i hiwu kape teha'at hawyi Iesui to'e temit'in me — Eiwe­ha'at ro mekewat hiwu kape mekewat yt hekat i kahato rakat kape katu­pono mekewat hiwu tum iwato kahato Tupana pe e. Po'og po'og tutum Tupana pe irania'in hekat rakaria miium hap kai are pãi e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Katu­pono irania'in hekat rakaria ta'a­tue­ka­re'en sem kaipyi heĩpyt hit yn ta'atuium Tupana pe ma'ato mekewat hiwu tum na'yn Tupana pe tomi'u yne sa'up are tutum na'yn yne tomoieĩ­ne'en sese hamuat sa'up Tupana pe mesup e. Mi'i pote are'e ehepe mekewat hiwu miium po'og Tupana mowepit hap topy­hu'at torania hekat rakaria miium kai katu­pono tutum yne yne tope pote are e Iesui topot­mu­'eria pe ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mi'i hawyi Iesui potmu­'eria te'e­ra­ha'at kahato Tupana mõtypot yat ikahu kahato hap etiat hawyi te'e­ro'e to'ope — Pãi i'atu'e ikahu kahato mesuwat Tupana mõtypot yat i'atu'e to'ope. Iwato kahato tig mesu­wa­rotiat nu koro ko'i Tupana mõtypot yat i'atu­minug i'atu'e. Waku kahato mesuwe i'atu'e. Eiwe­ha'at ro mekewat miit'in miium ko'i Tupana kapiat hap kape i'atu'e to'ope. Ta'i ta'a­tu­mo­kahu kahato Tupana mõtypot hap yat mesuwe i'atu'e to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Mio tã i'atu'e hawyi Iesui to'e i'atuepe — Uhemiit'in e eiwe­ha'at ro meiũwat nu koro ko'i kape e. Ta'i mesu­wa­rotiat nu koro ko'i ikahu kahato pytkai iwato kahato pytkai hewo hewo wyti aru hawyi yt kat i aru wẽtup nu koro topy­hu'at mekewat e'at pe to'o­tote tote rakat are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mi'i hawyi heka­tu­wyria apo'i­'a­tu'e Iesui pe — Urumu'e hat i'atu'e karãpe aru pãi mesuwat nu koro ko'i hewo hewo hap topy­hu'at i'atu'e. Aikotã aru pyno uruikuap mekewat e'at put'ok'e hap i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mi'i hawyi Iesui ti'a­tu­wesat topot­po­'o­roria pe — Eiwe'eg wo o are katu­pono wyti aru uhet wywo uhet ero'ok haria put'ok­'i­'a­tu'e ehepe eima'at hamo are. — Uito Iesui ti rat i'atu'e wyti aru. Uito ti ariot ra'yn eipo­rekuat koro wuat i'atu'e aru. Tupana mipo­'oro uito wuat'i miit'in porekuat nuat i'atu'e aru õ'ẽ haria. — Ara'aipok ta'yn mana'in uhyt'i'in i'atu'e aru ehepe wen ma'ato yt eweiwa­nẽtup tei'o i'atueso rakaria kape are katu­pono eima'at hamo tõ'ẽ are. Yt pywo piat rakaria i mi'iria pote e. Ehekat ky'ewi eipiit ky'ewi tõ'ẽ aru — Uito Tupana mipo­'oro sese e haria e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","— Ta'i mekewat e'at pe wyti aru wu'uka hap ko'i kahato eweikuap yne mesu­wa­rotiat wu'uka hap etiat eweikuap aru e. Mi'i hawyi yt kat hin i wo'o­wese hap mesu­wa­rote hap ewywuat eweipuẽti aru are e. Yt ikahu hin i hap ewy miit'in to'o­'a­tu­'uka atu'uka kahato wyti aru hap kape eiwa­'a­kasa pytkai yt eweiken'ẽ mi'i pupi katu­pono po'og po'og sa'ag mi'i e'at kai turan put'ok'e mekewat ho'opot ho'opot hap e'at koro are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mi'i hawyi wo'o­'a­tu­'uka atu'uka sakpo hap e'at wyti aru put'ok'e are e. Mi'i hawyi more­kuaria koro ko'i to'o­moma teran aru hawyi to'o­'a­tu­'uka atu'uka irania'in ywania epore­kuaria ko'i wywo e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","— I'ewyte wyti aru mekewat e'at yt naku i hap koro owakai mesuwat yi aipytyp huruk huruk'e kahato tyry'e tyry'e hap ewy hawyi yt kat hin i miit'in mi'u mesuwat yi tote toĩne'en are e. Mi'i hawyi wuat'i etama piaria hesy'at kahato rakaria wo tukup­te'en e. Mi'i hawyi miit'in saty'i saty'i hap yt ikahu hin i hap ewy te'e­ru­we­mo­herep aru mesu­wa­rote e Iesui. Ta'i yt naku i hap yn wyti aru miit'in ete ta'a­tu­puẽti are e. I'ewyte atipy wyti aru yt aimikuap ewy hin i topy­hu'at aru katu­pono ipoity kahato ui'e hap ewywuat hap kape ewei'a­kasa aru e. Ta'i atipy kaipyi ywaiti pyi hewo hewo kahato miit'in ete yt naku i hap ewywuat yt karãpe i ewei'a­kasa hap ewywuat e. Mi'i hap ko'i kape eiwe­ha'at turan waku eiwa­tetup mesuwat uimienoi kape e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma'ato mekewat e'at pe wyti aru mesu­wa­ro­tiaria yt uimohey haria eipytyk kahato wyti aru ehaty'i haty'i hamo are e Iesui. Ta'i Tupana mõtypot hap yat kape eheroto eipe hawyi — Yt nakuaria i kahato mi'iria i'atu'e ehepiat uipot­po­'o­roria eipe pote are e. Mi'i hawyi wyti aru ta'a­tu­pyhik kahato eipe are e. Morekuat koro ko'i tu'i­saria ei'auka teran haria tukup­te'en uhemiit eipe pote are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","— Ma'ato eheroto haria pe i'ewyte more­kuaria pe waku ehenoi uhehay wakuat i'atuepe eweikup­te'en i'atu­py­'a­setpe turan mekewat e'at. Ereĩne'en sura­ra'in po pe pytkai waku ewehenoi ewanĩ­kaptia pe sehay wakuat uhetiat e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","— Yt eweiwa­nẽtup tei'o sa'a­wy'i — Kat som waku aru are'e ui'auka teran haria pe i'atu­wesat hap ete are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Katu­pono mekewat e'at sa'ag me aru uito ti aru areĩne'en eiwywo kahato hawyi atopag eiwẽ pe uhehay i'atu­wesat hamuat are e. Ta'i aikotã waku kahato hap ahenoi ehepe e. Mi'i hawyi ehewa­nĩ­kaptia yt ta'a­tu­mohit kuap i ei'e hap hawyi paa'i­'a­tu'e uhehay wakuat eiwẽ pywiat pupi are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pywo ti rat meiũran aru ei'y­wot'in eity'in yt uimohey i haria yt i'atu­wese hin i ehete uhehay upiaria eipe pote i'ewyte eheka­tu­wyria sese wyti aru eima'at hanuaria te'e­ro­py­hu'at uiky'e haria sese eipe pote are e. Mi'i hap e'at pe eika­tu­wyria sese ti'a­tu­kaykay sura­ra'in sem ei'auka hamo are e. Mi'i hawyi ta'a­tu­ho­'o­'a­tu­'uka kahato uhehay moherep haria mekewat e'at pe are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yt uwe i eiky­'esat haria tukup­te'en mekewat e'at pe uikai eweikup­te'en eipe pote are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","I'atu­py­'ahak kahato ehete uhemiit'in eipe pote are e. Ma'ato eimo­sa­ty'i saty'i pytkai wyti aru yt uwe i eihep kuap Tupana po pyi are e. Ehehay pywo sese uhetiat yt ta'a­tu­'akit kuap i are e. Ta'i yt wẽtup e hap ta'a­tu­moma kuap mekewat e'at pe uimi­'a­pykok ko'i eiperia pote e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Uimohey ro haty wo po'og mekewat e'at pe are yt naku i kahato ahete pytkai are e. Yt eweipun nei'o uimohey hap miit'in ei'a­tu­'uka hap e'at pe are e. Waku uika­wiano eweikup­te'en ne wuat'i e'at pe e. Yt ui'atoiat i pote waku pe eweikup­te'en wuat'i e'at pe are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","— Mekewat e'at pe karãpeĩ tukup­te'en sura­ra'in sem ahewa­nĩ­kaptia yt pya i ahetawa wato Ieru­sarẽi kaipywiat hawyi karãpe tuwe­hyt'ok teran ahetawa pe ai'a­tu­'uka hamo mi'i hap e'at pe meremo eweikuap ta'yn yt pya hin i ahetawa wato Ieru­sarẽi moma sese hap e'at hap eweikuap are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tawa wato Ierusarẽi toĩne'en yi Iuteu py'a­setpe pote waku eiko­hyeput kahato pya kahato yi Iuteu kaipyi are e. Waku eiko­hyeput yity'ok ko'i kape eiwemig hamo are e. Ma'ato tawa Ieru­sarẽi miaria eipe pote meremo eiwe­nõ'ẽ ro pya pya tawa wato Ieru­sarẽi kaipyi hawyi meremo eiko­hyeput pya pya tawa pyi e. Mu'ap upi Ieru­sarẽi kapiat eweikup­te'en mote yt ewei'aipok tei'o tawa Ieru­sarẽi kape are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Katu­pono miit'in apiheg hap koro hap e'at sese topy­hu'at mekewat e'at pe aru are e. Ta'i sa'a­wy­'iwuat Tupana miwan ewywuat sa'ag hap ewywuat topy­hu'at aru mekewat e'at sa'ag hap e'at pe are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mekewat e'at turan yt naku i kahato topy­hu'at aru hupi'a rakaria ete mana'in mẽpyt sat haria wywo ete are e. Katu­pono ho'opot hap yn topy­hu'at itote are e. Tupana piat miit'in apiheg hap put'ok'e ra'yn yne yi Iuteu piaria ete are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mi'i hawyi wẽtup ywania ti'a­tu­'uka kahato yne Iuteu ywania kyse'yp mo ta'a­tu­'a­tu­'uka kahato are e. Irania'in ta'a­tue­roto ta'a­tue­tama kape ta'a­tu­potpap nug hamo hawyi irania'in ta'a­tu­pyhik ta'a­tu­wo­'o­pyhik hawe are e. Ta'i irania'in wẽtup ywania kaipy­wiaria ko'i ti'a­tu­moma irane Ieru­sarẽi miaria ma'ato mi'i hawyi wẽtup e'at pe aru Tupana — Wãi'e mi'iria pe toran na'yn e aru hawyi ta'a­tu­pohep ta'yn ai'y­wania moma hap hawyi ta'a­tu­'atoiat tawa Ieru­sarẽi are e. Mi'i hawyi yt ta'a­tue­wyry kuap i po'og tawa Ieru­sarẽi me are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","At waty waikiru ko'i i'ewyte tohenoi wyti aru uhut hap e'at ta'a­tu­henoi are. Yt pya i ra'yn toran na'yn e hap e'at pe put'ok'e hap ta'a­tu­henoi aru are. At waty waikiru ko'i yt tukup­te'en i ta'atueiam me are e. Ta'i yt sa'a­wy­'iwuat ewy hin i at waty waikiru tukup­te'en are e. Mekewat e'at pe kowo i kowo i ta'a­tue­wyry mekewat e'at pe are. Ta'i mesuwat yi tote ywytu uato hap ewy kahato y'y tote yi tote po'og po'og sa'a­wy­'iwuat kai are e. Mi'i hawyi wasere sa'ag hap ewy toĩne'en e. Mi'i hawyi y'y wato hap wasere upiat ai'yat ypik hap pupi miit'in te'e­ro­ken'ẽ kahato pote i'atu­'a­kag'aia hawuo te'e­re­wa­nẽtup kahato at ka'ap hawyi — Yt naku i kahato mesuwe i'atu'e aru to'ope are e. Pywo pe ti yne hyemyi'a wato ko'i ete y'y ihyesaika kahato hap ewy topy­hu'at mekewat e'at pe aru e Iesui temiit'in me itote. ");
INSERT INTO mavNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","— Mi'i hawyi at waikiru waty kohye­wyry hap kapiat mesu­wa­ro­tiaria te'e­ra­'a­kasa hawyi gyt'i­'a­tu'e aru e. I'atu­perup i'atu­wuwu gen'ẽ pono e. Atipy piat i'atueiam ko'i huruk'e hawyi yt te'e­ro­py­hu'at kuap i sa'a­wy­'i­tewuat ewy e. Mi'i hawyi — Watopap yne irane aito i'atu'e to'ope te'e­ro­ken'ẽ haype are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","— Mi'i hawyi tut ra'yn Uito Eheyke'et Eikywyt ywyhig muo uhesaika hawuo uimõ­typot hawe put'ok­'are ra'yn e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","— Pyno uimienoi hap ewy put'ok'e hawyi yt eweiken'ẽ tei'o ma'ato eiwepit ro katu­pono yt pya hin i eheha­kye­ra'at hap hamuat e'at toĩne'en are e Iesui ahepe temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mi'i hawyi hã'ãkap wuo tohenoi i ra'yn. Mio tã e Iesui — Pyno eweikuap ta'yn aikotã ahetama pe aria'yp ko'i haat kahato ta'a­tue'at put'ok'e hawyi e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ahetama pe Wiku yp i'yhop kyt ewei'a­kasa hawyi i'aman mot e'at yt pya hin i wato'e mesuwe ahetama pe e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mi'i hap ewy karãpe ewei'a­kasa yne yne uimienoi ko'i ewy wyti aru tokosap yne hap — Waku ewei'e eipy'a pe tut irane Tupana Mi'airo Wuat'i Miit'in Porekuat nuat hap e'at waku ewei'e are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Pywo ti rat tut aru wuat'i ui'e hap ok tã ko'i are e. Mũki­'ite e'ihot'ok wyti aru uimohey haria mesuwat yi totiaria te'e­ra­ha'at aru yne ui'e hap kape hawyi te'e­ro'e to'ope aru — Aimu'e hat to'e hap ok tã topy­hu'at ra'yn mesuwat yi tote aikotã to'e hap ewy i'atu'e aru e. Yt uheso i tut wyti aru yne uimi­mo­herep ui'e hap ko'i ok tã e. Uimohey haria tukup­te'en aru mesuwat yi tote karãpe put'ok'e yne uimi­mo­herep aikotã aru ui'e hap ko'i e. Aimi­mu­'eria ehaipe­piaria uimohey haria yt karãpe i ikahuro mesuwat yi tote ma'ato te'e­ra­ha'at aru uimi­mo­herep uhehay aikotã aru hap akasa hamuat e Iesui tomohey sese haria pe ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ta'i atipy ko'i waty at waikiru ko'i te'e­ru­weityk kahato aru yne yne i'ewyte mesuwat yi rotiat yne yne yt kat i aru toĩne'en katu­pono tuweityk aru yne yne ma'ato uimienoi ko'i yt karãpe i ikahuro aru are ma'ato toĩne'en wuat'i e'at pe uhehay e Iesui ahepe. ");
INSERT INTO mavNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","— Eiwe'eg wo o eiwa­nẽtup hawe are yt naku i kahato mesu­wa­rotiat eimi'u kape esapo hy u hap kape yn eweiwa­nẽtup are e. yt naku i ehenuk iwato kahato hap kape yn eiwe­mahy u hap kape yn eipy'a pe toĩne'en mekewat e'at put'ok'e turan are e. Yt naku i eiminug ko'i hap kape mesu­wa­rotiat kape yn eiwe­wa­nẽtup are. Mi'i wanẽtup hap ewy ereĩne'en mote karãpe mekewat e'at put'ok'e hawyi eiwe­mogyt mogyt ne'i aru Tupana pupi are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","— Ta'i wuat'i miit'in mesu­wa­ro­tiaria te'e­ra­'a­kasa hamuat mekewat e'at pe hut turan ma'ato yt hekatup i haria pote mi'iria pyhik hap ewywuat put'ok'e irane e. Aikotã pay yt tikuap i mory'a toĩne'en mu'ap tote to'auka hamuat hap ewy kahato put'ok'e mekewat e'at yt naku i rakat yt Tupana mohey i te haria ete are e. ");
INSERT INTO mavNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pyno ewehẽtup to Tupana piat eimoe­saika hap ei'a­pykok hamuat mekewat ho'opot hap e'at put'ok'e ehete pote are e. Waku miat iwe'eg rakat ewy eweikup­te'en are e. Waku ewehẽtup o Tupana pe — Yt atoiat teran i uhepiat emohey hap waku ewei'e tope are. Mi'i hawyi put'ok­'e­wei'e wyti aru mekewat eho'opot hap e'at hawyi waku — Uipo­wyro ro mesuwat e'at sakpo areto hamuat ewei'e ro Tupana pe are e Iesui ahepe itote. ");
INSERT INTO mavNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mi'i hawyi wuat'i e'at pe Iesui ti'a­tu­mu'e kahato miit'in sem Tupana mõtypot yat koro pe. ");
INSERT INTO mavNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hunete wuat'i miit'in te'e­ru­wa­'a­tunug itote Tupana mõtypot yat koro pe Iesui mienoi kapiat te'e­ro­wa­nẽtup hamo. Ma'ato wãtym'i hawyi toto i ra'yn Iesui mekewat Uriweira ypia yity'ok kape. Mi'i tote toĩne'en wãtym muo ẽtup hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pyno wẽtup e'at pe put'ok'e mekewat man teneg u hap e'at karãpe Iuteuria te'e­ru­wa­'a­tunug kahato ta'a­tue­tawa koro Ieru­sarẽi kape man teneg u hamo — Mi'i man aimi'u sa'a­wy­'iwat ewywuat kahato ewy watoĩ­ne'en ahewa­nĩ­kaptia po pe turan e hap kuekatu hamo te'e­ru­wa­'a­tunug. ");
INSERT INTO mavNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mi'i hawyi itote pa'i kororia i'ewyte wãi'e hap enoi haria tikat kahato aikotã waku mig'i wo Iesui auka hamo hap ta'a­tukat tawa Ieru­sarẽi me wen ma'ato yt ta'a­tu­puẽti i katu­pono Iesui ky'e haria sem mupi te'e­ro­ken'ẽ kahato itote. ");
INSERT INTO mavNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mi'i turan ahiag teke ra'yn Iesui potmu'e Iuta e hap piit pe mekewat Ikarioti sa'yru piit pe teke mekewat Iesui potmu'e wẽtup ok 12 ok takat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ahiag teke hawyi Iuta piit pe hawyi toto ra'yn pa'i wato kororia kape i'ewyte sura­ra'in akag ko'i kape Tupana mõtypot yat apykok haria kape hawyi ihay kahato mi'iria wywo aikotã waku Iesui pytyk hamuat kat hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Toi'a­tu­mo­wepit pa'i wato ko'i i'ewyte surara akag ko'i imienoi sa'ag wo hawyi ta'a­tu­ha'up nug neran sa'up iwato Iuta pe Iesui ma'at hap pe sa'up mo. ");
INSERT INTO mavNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ha'up totat hawyi toto ra'yn hawyi toikat kahato aikotã karãpeĩ waku Iesui moherep hamo i'auka teran haria po piat hum hamo irania'in yt mikuap mo i hap toikat. ");
INSERT INTO mavNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mi'i hawyi put'ok'e ra'yn mekewat man teneg u hap e'at tawa wato Ieru­sarẽi me. Mi'i turan Iesui ywania Iuteuria ywania i'auka ta'a­tuhũ Kuteiru mẽpyt i'atu­minug sa'ag sa'up mo Tupana mowepit hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mekewat man teneg u hap e'at owokai Iesui tipo­'oro typy ok temiit Peteru Iuwãu tawa Ieru­sarẽi kape to'e henoi hamo hawyi — Eweiwat ro tawa kape ienuk wato hap nug hamo. ");
INSERT INTO mavNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mi'i hawyi apo'i­'a­tu'e — Mehĩ aikope som waku watunug aimi'u itote i'atu'e Iesui pe. ");
INSERT INTO mavNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mi'i tupono toi'a­tu­wesat — Eweiwat tawa wato Ieru­sarẽi kape hawyi meremo itote eweipuẽti aru ihainia kamũti piat y'y sat hat itote are e. Mi'i hawyi hewat­'ymo eweiwat ro hawyi teke ra'yn wẽtup getap we. ");
INSERT INTO mavNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mi'i hawyi waku ewei'e ro getap ka'iwat pe — Urupo­'oro hat Iesui tuwehay po'oro ewawi uhyt katu­pono toikuap teran — Aiũwat mekewat okipy wato waku rakat Uito uhemiit'in wywo man teneg u hamuat ewei'e ro getap ka'iwat pe. ");
INSERT INTO mavNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mi'i ewei'e mekewat getap ka'iwat pe hawyi toimo­herep aru ehepe wẽtup okipy iwato rakat ywaiti rakat piat are e. Mi'i pe tukup­te'en yne aimi­ky­'esat mekewat ienuk hap nug hamuat aru are e. Waku mi'i okipy koro tote ewetunug aimi'u are e. ");
INSERT INTO mavNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mi'i hawyi tuwat Peteru Iuwãu Iesui mienoi ewy hawyi ta'a­tu­puẽti yne ra'yn Iesui e hap ewy hawyi itote ienuk hap iwato rakat ta'a­tunug itote Iesui miky­'esat ewy. ");
INSERT INTO mavNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mi'i hawyi wãtym'i turan hawyi Iesui toto wy mekewat okipy ywaiti kape hawyi put'ok'e itote hawyi Iesui ta'apyk ta'yn yparakai koro ete temiit 12 ok takaria wywo. ");
INSERT INTO mavNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mi'i hawyi to'e i'atuepe — Waku kahato mesuwe watenuk e. Ahekatup kahato ra'yn mesuwat ienuk hap u hamuat eiwywo uhepiat ho'opot hap owakai e. ");
INSERT INTO mavNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Uiwy­ria'in e areto irane eikai hawyi yt arenuk i ira'yn ienuk hap man teneg u hap mesuwat yi tote i ra'yn are e. Ma'ato meiũran karãpe Tupana topy­hu'at Wuat'i Miit'in Porekuat Koro wanuat hap e'at pe hawyi atu'u i ra'yn eiwywo e Iesui. Ta'i wuat'i miit'in tikuap ta'yn hawyi Tupana topy­hu'at Wuat'i Miit'in Porekuat no hawyi ahu'u i ra'yn man teneg ienuk hap eiwywo e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mi'i tã to'e hawyi totat ra'yn mekewat kui'a piat sapo hy hawyi — Waku e Tupana pe. Mi'i hawyi tutum mekewat kui'a torania temiit'in me hawyi to'e i'atuepe — Waku eweimõ'ẽ ro mesuwat kui'a piat sapo hy eiwo­'ope e. ");
INSERT INTO mavNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","— Pywo pe ti Uito are'y'u meiũ hawyi yt are'y'u i sapo hy eiwywo i ra'yn ma'ato mekewat e'at karãpe Tupana toĩne'en Wuat'i Miit'in Porekuat nuat e'at put'ok'e hawyi are'y'u i ra'yn mesuwat ewywuat sapo hy eiwywo i ra'yn e temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mi'i hawyi man teneg totat hawyi waku e Tupana pe hawyi toipik topo wo hawyi tutum na'yn topot­mu­'eria pe hawyi to'e — Mesuwat man uimipik uipiit ewy kahato toĩne'en katu­pono uipiit miit'in tipik kahato ui'auka turan e. Mi'i pote uipiit iã'ãkap kahato meikowat man e. Ta'i meikowat man ni uipiit e. Mi'i hap ewy topy­hu'at uipiit irane ui'auka turan e. Katu­pono uiku­'uro irane wuat'i miit'in kawiano e. Mi'i pote waku man u hat uiku­'uro hap kuekatu hap ewetunug aru e. ");
INSERT INTO mavNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Te'e­renuk kahu hawyi sapo hy kui'a piat totat hawyi — Meikowat sapo hy uhuu ewywuat e. Ta'i uhuu at hap topy­hu'at aru mohag wo miit'in Tupana wywo wo'o­wese hap nug hamuat e. Uhuu ta'at yne irane miit'in ehakye­ra'at hamuat e. ");
INSERT INTO mavNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mi'i hawyi Iesui to'e — Ma'ato eiwe'eg wo o katu­pono wẽtup ok aipy­'a­setpiat mesuwat yparakai ete apyk piat uima'at hanuat toĩne'en na'yn e. Katu­pono ui'au­ka­kare sa'ag ne'i mi'i miit toĩne'en e. ");
INSERT INTO mavNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta'i Uito ti Wuat'i Ywania Yke'et pote uiku­'uro irane miit'in yne kawiano Tupana miky­'esat ewywuat ma'ato yt naku i kahato topy­hu'at aru uima'at hat ete katu­pono Tupana mi'a­piheg sese mi'i miit topy­hu'at e Iesui temiit Iuta piat. ");
INSERT INTO mavNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mio tã to'e hawyi hemiit'in apo'i­'a­tu'e to'ope to'ope — Uweĩ aiwywo Aika­'iwat ma'at hanuat i'atu'e. ");
INSERT INTO mavNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mi'i hawyi Iesui potmu­'eria 12 ok takaria tu'uka to'ope yparakai ete to'oehay wo — Uito ti po'og Iesui potmu'e eikai torania kai i'atu'e sa'ag to'ope. ");
INSERT INTO mavNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mi'i hawyi Iesui to'e temiit'in me — Uiwy­ria'in e ahewa­nĩ­kaptia ywania pore­kuaria mio tã i'atu'e — Woro­ho­'o­ky'e kahato i'atu'e ahepe ma'ato i'atueso ne'i katu­pono marak'a ko'i ne'i mi'iria tupono e. Yt kat i aiky'e hap wywo aipo­'oro ta'a­tu­potpap nug hamo e. Pyno yt naku i mi'iria ewywuat ko'i eiperia are e. Yt atiky­'esat i e temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ma'ato eipe ti yt mi'iria ewywuat no i eweikup­te'en e. Atiky­'esat kahato eiperia iwese kahato rakaria wo e. — En ni po'og uikai e haria wo atiky­'esat eipe e. — Waku uito ewat'ymo areto uhyt mana e haria wo atiky­'esat eipe e. — Woro­po­wyro teran e haria wo atiky­'esat eipe e. — Waku uipo­'oro uhyt mana e haria wo atiky­'esat eipe e. Atiky­'esat eweipy­hu'at irania'in powyro hanuaria e. Mi'i haria wo eweipy­hu'at pote mi'i hawyi po'og po'og irania'in kai Tupana wanẽtup hawe eweipy­hu'at e. I'ewyte miit akag wuat eipe pote heropat haria ewywuaria waku eweipy­hu'at eimiit'in powyro hanuaria hap atiky­'esat e Iesui temiit'in me tomohey haria yne pe. ");
INSERT INTO mavNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mesu­wa­ro­tiaria aipo­re­kuaria te'e­ru­wepyk hawyi ta'a­tu­kaykay ta'a­tue­ropat haria hawyi — Uipoi ro mesuwe meremo i'atu'e. Mi'i hawyi heropat haria meremo ta'a­tuerut morekuat kape imi'u ipupi te'e­ro­ken'ẽ hawyi. Ma'ato Uito yt mi'iria ewy hin i are. Yt atiky­'esat eiperia more­kuaria ewy ma'ato waku po'og miit'in poi hanuaria wo ewy hap atiky­'esat aikotã uito woro­ho­'opoi hap atiky­'esat eiperia katu­pono areĩne'en mesuwe miit'in eropat hano are miit'in poi hano areĩne'en e Iesui temiit'in me. ");
INSERT INTO mavNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mesu­wa­rote aho'opot kahato miit'in miky­ry'i wo hap upi ahenoi mi'iria pe turan wen ma'ato eipe yt ui'atoiat hin i uhã'ãg turan e. Waku kahato eiperia e Iesui topo­mu­'eria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sa'a­wy'i Ui'ywot Tupana tum uhepe wuat'i ywania uhemiit no. Koitywy Ui'ywot ewy atunug eiperia more­kuaria wo ui'e­wy­wuaria e. Ta'i Ui'ywot uinug na'yn Morekuat no mesu­wa­rote e. Mi'i hawyi eipe ti i'ewyte woro­ho­'onug more­kuaria wo ui'ewy e Iesui. ");
INSERT INTO mavNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Pywo pe ti are'e ehepe aikope aikope areĩne'en morekuat no hap tote wyti aru uimi'u nug hap tote uiwywo ewei'apyk aru e. Ta'i more­kuaria wo uiwywo eweikup­te'en e. Ta'i uiwywo ewei'apyk uimi'u u hamo uhesapo hy u hamo itote uimõ­typot sese hap e'at e. I'ewyte ei'apyk hap ko'i sese iwato rakat tote ewei'apyk more­kuaria kororia wo 12 ai'y­wania Isareu ywania more­kuaria wo eweikup­te'en aru itote are e. Mi'i hawyi ta'a­tuerut ehowawi ai'y­wania uwe waku uwe yt naku i ewei'e hamo e Iesui temiit'in me 12 ok takaria pe. ");
INSERT INTO mavNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mi'i hawyi Iesui to'e Peteru pe — Simãu Simãu e mesup wãtym muo ahiag ehã'ãg kahato e. Ta'i ahiag 