﻿USE sofia;
DROP TABLE IF EXISTS sofia.marc_vpl;
CREATE TABLE marc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES marc_vpl WRITE;
INSERT INTO marc_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","परमेश्वराने प्रथम आकाश व पृथ्वी निर्माण केली. ");
INSERT INTO marc_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","आता पृथ्वी निराकार आणि रिकामी होती, खोलवर अंधार पसरला होता आणि परमेश्वराचा आत्मा पाण्यावर पाखर घालीत होता. ");
INSERT INTO marc_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","नंतर परमेश्वराने म्हटले: “प्रकाश होवो” आणि प्रकाश झाला. ");
INSERT INTO marc_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","परमेश्वराने पाहिले की, प्रकाश चांगला आहे आणि त्यांनी अंधारापासून प्रकाश वेगळा केला. ");
INSERT INTO marc_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","परमेश्वराने प्रकाशाला “दिवस” आणि अंधाराला “रात्र” असे नाव दिले आणि संध्याकाळ झाली व सकाळ झाली; हा पहिला दिवस. ");
INSERT INTO marc_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","पुन्हा परमेश्वराने म्हटले, “जलाशयाच्या मध्यभागी अंतराळ होवो आणि ते जलापासून जलांची विभागणी करो.” ");
INSERT INTO marc_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","परमेश्वराने अंतराळ निर्माण केले व अंतराळाच्या वरचे जल आणि खालचे जल अशी विभागणी केली आणि तसे घडून आले. ");
INSERT INTO marc_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमेश्वराने अंतराळास “आकाश” असे नाव दिले आणि संध्याकाळ झाली व सकाळ झाली; हा दुसरा दिवस. ");
INSERT INTO marc_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","नंतर परमेश्वराने म्हटले: “अंतराळाखालील जले एकत्र येवो व कोरडी जमीन दृष्टीस पडो” आणि तसे घडून आले. ");
INSERT INTO marc_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेश्वराने कोरड्या जमिनीस “भूमी” व जलांच्या संचयास “सागर” अशी नावे दिली. परमेश्वराने पाहिले की, हे चांगले आहे. ");
INSERT INTO marc_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","मग परमेश्वराने म्हटले, “भूमीतून वनस्पतीचा उपज होवो: निरनिराळी रोपे व झाडे, फळे देणारी व त्या फळातच स्वजातीचे बीज असणार्‍या फळझाडांचा भूमीतून उपज होवो” आणि तसे घडून आले. ");
INSERT INTO marc_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","भूमीने वनस्पतीचा उपज केला: फळे देणारी व त्या फळातच स्वजातीचे बीज असणारी फळझाडे भूमीने उपजविली. परमेश्वराने पाहिले की हे चांगले आहे. ");
INSERT INTO marc_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","आणि संध्याकाळ झाली व सकाळ झाली; हा तिसरा दिवस. ");
INSERT INTO marc_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","त्यानंतर परमेश्वराने म्हटले: “दिवस आणि रात्र वेगळी करण्यासाठी आकाशात ज्योती होवोत व त्या ॠतू, दिवस आणि वर्षे दाखविणारी चिन्हे होवोत. ");
INSERT INTO marc_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","पृथ्वीला प्रकाश देण्यासाठी त्या ज्योती आकाशमंडळात दीप होवोत” आणि तसे घडून आले. ");
INSERT INTO marc_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","परमेश्वराने दोन मोठ्या ज्योती निर्माण केल्या—दिवसावर प्रभुत्व चालविण्यासाठी प्रखर आणि रात्रीवर प्रभुत्व चालविण्यासाठी सौम्य प्रकाश. त्यांनी तारेही निर्माण केले. ");
INSERT INTO marc_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","परमेश्वराने त्या ज्योती पृथ्वीवर प्रकाश पाडण्यासाठी आकाशमंडळात ठेवल्या, ");
INSERT INTO marc_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","दिवसावर व रात्रीवर प्रभुत्व चालविण्यासाठी आणि प्रकाश व अंधार वेगळे करण्यासाठी या ज्योती त्यांनी निर्माण केल्या. परमेश्वराने पाहिले की हे चांगले आहे. ");
INSERT INTO marc_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","आणि संध्याकाळ झाली व सकाळ झाली; हा चौथा दिवस. ");
INSERT INTO marc_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","आणि परमेश्वराने म्हटले, “जलांमध्ये विपुल प्रमाणात जीवजंतू उत्पन्न होवोत आणि पक्षी पृथ्वीवर आकाशमंडळात विहार करोत.” ");
INSERT INTO marc_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","सागरांमधील महाकाय प्राणी, तसेच जलांमध्ये संचार करणारे व सर्व जातीचे प्राणी त्यांनी उत्पन्न केले. तसेच पंख असलेले सर्व जातीचे पक्षीही त्यांनी उत्पन्न केले. परमेश्वराने पाहिले की हे चांगले आहे. ");
INSERT INTO marc_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमेश्वराने त्यांना आशीर्वाद दिला आणि ते म्हणाले, “फलद्रूप व्हा, बहुगुणित व्हा, समुद्रातील जले भरून टाका आणि पृथ्वीवर पक्ष्यांची वृद्धी होवो.” ");
INSERT INTO marc_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","आणि संध्याकाळ झाली व सकाळ झाली; हा पाचवा दिवस. ");
INSERT INTO marc_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","मग परमेश्वराने म्हटले, “प्रत्येक जातीच्या जिवंत प्राण्याची निर्मिती होवो: गुरे, जमिनीवरील सरपटणारे प्राणी, वनपशू यांच्या सर्व जाती पृथ्वीवर अस्तित्वात येवोत” आणि तसे घडून आले. ");
INSERT INTO marc_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","परमेश्वराने वन्यप्राणी, पाळीव जनावरे, जमिनीवर सरपटत जाणारे सर्व प्राणी, त्यांच्या जाती प्रमाणे त्यांनी निर्माण केले आणि परमेश्वराने पाहिले की ते चांगले आहे. ");
INSERT INTO marc_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","मग परमेश्वराने म्हटले: “आपल्यासारखी, आपल्या प्रतिरूपाची मानवजात आपण निर्माण करू या. समुद्रातील मासे आणि आकाशातील पक्षी, गुरे, सर्व वनपशू आणि जमिनीवर सरपटणार्‍या प्रत्येक प्राण्यांवर त्यांनी सत्ता चालवावी.” ");
INSERT INTO marc_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","याप्रमाणे परमेश्वराने आपल्या प्रतिरूपाची मानवजात निर्माण केली. त्यांनी आपल्या प्रतिरूपातच त्यांना निर्माण केले. पुरुष व स्त्री असे त्यांनी निर्माण केले. ");
INSERT INTO marc_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","मग परमेश्वराने त्यांना आशीर्वाद दिला आणि ते त्यांना म्हणाले, “फलद्रूप व्हा, बहुगुणित व्हा आणि पृथ्वी व्यापून टाका; ती आपल्या सत्तेखाली आणा. समुद्रातील मासे, आकाशातील पक्षी आणि पृथ्वीवर संचार करणार्‍या प्रत्येक सजीव प्राण्यावर अधिकार गाजवा.” ");
INSERT INTO marc_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","मग परमेश्वर म्हणाले, “पाहा, भूतलावर बीज देणारी प्रत्येक वनस्पती आणि फळांमध्येच वृक्ष निर्माण करणारे बीज असलेले प्रत्येक फळझाड मी तुम्हाला दिले आहे. ती तुमचे अन्न होतील. ");
INSERT INTO marc_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","त्याप्रमाणे पृथ्वीतलावरील सर्व पशू, आकाशातील प्रत्येक पक्षी, तसेच जमिनीवर सरपटत जाणारा, जीवनाचा श्वास असलेला प्रत्येक प्राणी—यांना अन्न म्हणून मी हिरवी वनस्पती देत आहे” आणि तसे घडून आले. ");
INSERT INTO marc_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","परमेश्वराने आपण निर्माण केलेली प्रत्येक गोष्ट पाहिली आणि ती अतिशय चांगली होती आणि संध्याकाळ झाली व सकाळ झाली; हा सहावा दिवस. ");
INSERT INTO marc_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","अशा रीतीने आकाश, पृथ्वी व त्यातील सर्वांची निर्मिती पूर्ण झाली. ");
INSERT INTO marc_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","परमेश्वराने सातव्या दिवसापर्यंत त्यांचे काम संपविले, म्हणून सातव्या दिवशी त्यांच्या सर्व कामापासून त्यांनी विश्रांती घेतली. ");
INSERT INTO marc_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","सातव्या दिवसाला आशीर्वाद देऊन परमेश्वराने तो पवित्र केला; कारण निर्मितीचे संपूर्ण कार्य संपवून त्यांनी सातव्या दिवशी विश्रांती घेतली. ");
INSERT INTO marc_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","याहवेह परमेश्वराने आकाश व पृथ्वी निर्माण केली, त्याचा हा वृतांत आहे: जेव्हा याहवेह परमेश्वराने पृथ्वी व आकाशाची निर्मिती केली. ");
INSERT INTO marc_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","जमिनीवर अद्याप वनस्पती उगवली नव्हती, कारण याहवेह परमेश्वराने अजून पाऊस पाडला नव्हता आणि जमिनीची मशागत करण्यासाठी कोणी मनुष्य नव्हता. ");
INSERT INTO marc_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","मात्र जमिनीवरून धुके वर जात असे आणि त्याने जमिनीच्या सर्व पृष्ठभागाचे सिंचन होत असे. ");
INSERT INTO marc_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","मग याहवेह परमेश्वराने जमिनीवरील धूळ घेऊन तिचा मनुष्य घडविला व त्याच्या नाकपुड्यांत त्यांनी जीवन देणारा श्वास फुंकला; तेव्हा मनुष्य सजीव प्राणी झाला. ");
INSERT INTO marc_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","नंतर याहवेह परमेश्वराने पूर्वेकडे, एदेनमध्ये एक बाग लावली आणि त्या बागेत आपण घडविलेल्या मनुष्याला ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","याहवेह परमेश्वराने सर्व प्रकारची झाडे जमिनीतून उगवली—डोळ्यांना आनंद देणारे व खाण्यास उत्तम असलेले जीवनवृक्ष आणि बर्‍यावाईटाचे ज्ञान करून देणारा वृक्ष हे देखील बागेच्या मध्यभागी लावले. ");
INSERT INTO marc_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","बागेला पाणी देण्यासाठी एदेनात एक नदी उगम पावली व वाहू लागली आणि ती विभागून तिच्या चार नद्या झाल्या ");
INSERT INTO marc_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहिल्या नदीचे नाव पीशोन असून ती सोने असलेल्या हवीला प्रदेशाला वेढा घालून वाहते. ");
INSERT INTO marc_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","त्या प्रदेशातील सोने उत्तम प्रतीचे असून तिथे मोती व गोमेद रत्नेही सापडतात. ");
INSERT INTO marc_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दुसर्‍या नदीचे नाव गीहोन असून ती कूशच्या सर्व प्रदेशाभोवती वाहत जाते. ");
INSERT INTO marc_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","तिसर्‍या नदीचे नाव हिद्दकेल असून ती अश्शूरच्या पूर्वेस वाहत जाते; आणि चौथ्या नदीचे नाव फरात असे आहे. ");
INSERT INTO marc_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","याहवेह परमेश्वराने मनुष्याला एदेन बागेत नेऊन तिची मशागत व राखण करण्यास ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","याहवेह परमेश्वराने मनुष्याला आज्ञा केली, “बागेतील वाटेल त्या झाडाचे फळ तू खुशाल खा; ");
INSERT INTO marc_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","परंतु बऱ्यावाईटाचे ज्ञान करून देणार्‍या वृक्षाचे फळ मात्र तू खाऊ नकोस, कारण ज्या दिवशी तू ते फळ खाशील त्या दिवशी तू निश्चित मरशील.” ");
INSERT INTO marc_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","याहवेह परमेश्वर म्हणाले, “मनुष्याने एकटे असावे हे बरे नाही; मी त्याच्यासाठी एक योग्य मदतनीस निर्माण करेन.” ");
INSERT INTO marc_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","याहवेह परमेश्वराने भूमीपासून प्रत्येक जातीचे वन्यपशू, आकाशातील सर्व पक्षी निर्माण केले. त्यांना मानव कोणती नावे देतो हे पाहण्याकरिता त्याच्याकडे आणले; आणि त्याने जी नावे दिली तीच त्यांची नावे पडली. ");
INSERT INTO marc_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","याप्रकारे मानवाने सर्व पाळीव प्राण्यांना, आकाशातील पक्ष्यांना आणि जमिनीवरील सर्व पशूंना नावे दिली. परंतु आदामाला योग्य असा मदतनीस त्यांच्यामध्ये नव्हता. ");
INSERT INTO marc_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","नंतर याहवेह परमेश्वराने मानवाला गाढ निद्रा आणली आणि तो झोपेत असताना याहवेह परमेश्वराने त्याची एक फासळी काढली आणि ती जागा त्यांनी मांसाने भरून काढली. ");
INSERT INTO marc_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","याहवेह परमेश्वराने मानवाची जी फासळी काढली, त्याची त्यांनी एक स्त्री निर्माण केली आणि तिला त्यांनी मानवाकडे आणले. ");
INSERT INTO marc_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","तेव्हा मानव म्हणाला, “ही माझ्या हाडाचे हाड आणि मांसाचे मांस आहे; हिला नारी असे म्हणतील, कारण ती नरापासून बनविली आहे.” ");
INSERT INTO marc_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","या कारणासाठी पुरुष आपल्या आईवडिलांना सोडून आपल्या पत्नीशी जडून राहील आणि ती एकदेह होतील. ");
INSERT INTO marc_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","आदाम आणि त्याची पत्नी हे दोघेही नग्न होती, परंतु त्यांना लज्जा वाटत नव्हती. ");
INSERT INTO marc_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","आता याहवेह परमेश्वराने निर्माण केलेल्या सर्व वन्यप्राण्यांमध्ये सर्प सर्वात धूर्त होता. त्याने स्त्रीला म्हटले, “बागेतील कोणत्याही झाडाचे फळ तुम्ही खाऊ नये असे परमेश्वराने खरोखरच म्हटले आहे काय?” ");
INSERT INTO marc_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","स्त्री सर्पाला म्हणाली, “आम्हाला बागेतील झाडांची फळे खाण्याची मुभा आहे. ");
INSERT INTO marc_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","पण परमेश्वर म्हणाले, ‘बागेच्या मध्यभागी असलेल्या झाडाचे फळ खाऊ नका आणि त्याला स्पर्शही करू नका, असे केल्यास तू मरशील.’ ” ");
INSERT INTO marc_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","पण सर्प त्या स्त्रीला म्हणाला, “तुम्ही निश्चितच मरणार नाही, ");
INSERT INTO marc_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","कारण परमेश्वराला हे माहीत आहे की ज्या दिवशी ते फळ तुम्ही खाल, त्या दिवशी तुमचे डोळे उघडतील आणि चांगले व वाईट यातील फरक तुम्हाला समजेल आणि तुम्ही परमेश्वरासारखे व्हाल.” ");
INSERT INTO marc_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","जेव्हा स्त्रीने पाहिले की खाण्यास योग्य, दिसण्यास सुंदर आणि सुज्ञ करणारे ते झाड आहे, तेव्हा तिने त्याच्या फळातील काही तोडून घेतले आणि खाल्ले आणि आपला पती, जो तिच्यासोबत होता, त्यालाही दिले आणि त्याने ते खाल्ले. ");
INSERT INTO marc_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","पण मग त्यांचे डोळे उघडले आणि आपण नग्न असल्याचे त्यांना समजले; नंतर त्यांनी स्वतःसाठी अंजिराच्या पानांची कटिवेष्टने केली. ");
INSERT INTO marc_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","सायंकाळी याहवेह परमेश्वर बागेतून फिरत असल्याचा आवाज त्यांनी ऐकला आणि आदाम व त्याची पत्नी, याहवेह परमेश्वरापासून बागेतील झाडामागे लपली. ");
INSERT INTO marc_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","परंतु याहवेह परमेश्वराने आदामाला हाक मारून म्हटले, “तू कुठे आहेस?” ");
INSERT INTO marc_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","आदाम म्हणाला, “बागेत मी तुमचा आवाज ऐकला आणि मला भीती वाटली, कारण मी नग्न होतो; त्यामुळे लपून बसलो.” ");
INSERT INTO marc_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","याहवेह म्हणाले, “तू नग्न आहेस हे तुला कोणी सांगितले? ज्या झाडाचे फळ खाऊ नकोस, अशी मी तुला आज्ञा केली होती, त्या झाडाचे फळ तू खाल्लेस काय?” ");
INSERT INTO marc_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","त्यावर आदाम म्हणाला, “जी स्त्री तुम्ही माझ्या सोबतीला दिली; तिने मला त्या झाडाची फळे दिली आणि मी ती खाल्ली.” ");
INSERT INTO marc_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","तेव्हा याहवेह परमेश्वर त्या स्त्रीला म्हणाले, “तू हे काय केलेस?” त्यावर ती स्त्री म्हणाली, “सर्पाने मला भुरळ पाडली आणि मी ते फळ खाल्ले.” ");
INSERT INTO marc_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","याहवेह परमेश्वर सर्पाला म्हणाले, “कारण तू हे केलेस म्हणून, “तू सर्व पाळीव प्राण्यांहून, आणि सर्व वन्यपशूहून अधिक शापित आहेस! तू तुझ्या पोटावर सरपटशील आणि तुझ्या आयुष्याचे सर्व दिवस माती खाशील. ");
INSERT INTO marc_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","तू आणि स्त्री, तुझी संतती आणि तिची संतती यामध्ये मी शत्रुत्व निर्माण करेन; तिचे संतान तुझे मस्तक चिरडेल आणि तू त्याची टाच फोडशील.” ");
INSERT INTO marc_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","नंतर परमेश्वर स्त्रीला म्हणाले, “तुझ्या प्रसूतिकाळात मी तुझे क्लेश अत्यंत वाढवेन; वेदनांनी तू तुझ्या संतानास जन्म देशील, तुझ्या पतीकडे तुझी ओढ राहील, आणि तो तुजवर सत्ता गाजवील.” ");
INSERT INTO marc_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","नंतर ते आदामाला म्हणाले, “तू तुझ्या पत्नीचे ऐकलेस आणि ज्या झाडाचे फळ तू खाऊ नकोस, अशी मी तुला आज्ञा केली होती, ते खाल्लेस म्हणून आता, “तुझ्यामुळे भूमी शापित झाली आहे; तू तुझ्या आयुष्याचे सर्व दिवस अत्यंत क्लेशमय कष्ट करून तिचा उपज खाशील. ");
INSERT INTO marc_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","भूमी तुझ्यासाठी काटे आणि कुसळे उगवील, आणि तू शेतातील पीक खाशील. ");
INSERT INTO marc_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ज्यामधून तू घडविला गेलास त्या मातीत परत जाऊन मिळेपर्यंत तू घाम गाळून अन्न खाशील, कारण तू माती आहेस आणि तू मातीतच परत जाऊन मिळशील.” ");
INSERT INTO marc_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदामाने आपल्या पत्नीचे नाव हव्वा असे ठेवले, कारण ती सर्व सजिवांची माता होती. ");
INSERT INTO marc_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","याहवेह परमेश्वराने आदामासाठी आणि त्याच्या पत्नीसाठी चर्मवस्त्रे केली आणि त्यांना ती घातली. ");
INSERT INTO marc_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","नंतर याहवेह परमेश्वर म्हणाले, “पाहा, मानव आपल्यापैकी एक आणि आपल्यासारखा झाला आहे; तो बरे आणि वाईट यातील फरक समजू लागला आहे. परंतु आता जीवनवृक्षाचे फळ त्याच्या हाती लागून त्याने ते तोडून खाऊ नये, कारण मग तो सदासर्वकाळ जिवंत राहील.” ");
INSERT INTO marc_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","म्हणून याहवेह परमेश्वराने मनुष्याला ज्या भूमीतून निर्माण केले होते तिची मशागत करण्यासाठी त्या एदेन बागेतून घालवून दिले. ");
INSERT INTO marc_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","अशा रीतीने त्यांनी मनुष्याला एदेन बागेच्या बाहेर घालवून दिले आणि जीवनवृक्षाकडे कोणीही जाऊ नये यासाठी एदेन बागेच्या पूर्वेस करूबीम आणि प्रत्येक दिशेकडे फिरणारी एक ज्वालामय तलवार ठेवली. ");
INSERT INTO marc_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","मग आदामाने आपली पत्नी हव्वा हिच्याशी प्रीती संबंध केला, तेव्हा ती गर्भवती झाली आणि तिने काईन नावाच्या मुलाला जन्म दिला. ती म्हणाली, “याहवेहच्या साहाय्याने मी एका पुरुषाला प्राप्त केले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","नंतर तिने त्याचा भाऊ हाबेलास जन्म दिला. हाबेल मेंढपाळ होता आणि काईन शेतीकाम करीत होता. ");
INSERT INTO marc_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","हंगामाचे वेळी काईनाने याहवेहला दान देण्यासाठी आपल्या जमिनीतील काही उत्पन्न आणले. ");
INSERT INTO marc_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","हाबेलानेही आपल्या मेंढरातील प्रथम जन्मलेली धष्टपुष्ट मेंढरे आणून परमेश्वराला अर्पण केली. याहवेहने हाबेलाच्या अर्पणास प्रीतीने ग्रहण केले, ");
INSERT INTO marc_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","पण काईनाच्या अर्पणास प्रीतीने ग्रहण केले नाही, म्हणून त्याला खूप राग आला आणि त्याचा चेहरा उतरला. ");
INSERT INTO marc_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","याहवेहने काईनला विचारले, “तू का संतापलास? तुझ्या चेहर्‍यावर निराशा का दिसते? ");
INSERT INTO marc_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","तू योग्य ते केलेस तर तुझाही स्वीकार केला जाणार नाही काय? पण तू योग्य ते करण्याचे नाकारशील तर सावध राहा, तुझा सर्वनाश करावा म्हणून पाप तुझ्या दारावर हल्ला करण्यास टपून बसले आहे; पण त्यावर तू विजय मिळव.” ");
INSERT INTO marc_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","एके दिवशी काईन आपला भाऊ हाबेलास म्हणाला, “चल, आपण शेतात जाऊ.” त्याप्रमाणे शेतात गेल्यावर काईनाने आपल्या भावावर हल्ला करून त्याचा वध केला. ");
INSERT INTO marc_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","मग याहवेहने काईनाला विचारले, “तुझा भाऊ हाबेल कुठे आहे?” “मला माहीत नाही.” त्याने प्रत्युत्तर दिले. “मी काय माझ्या भावाचा राखणदार आहे?” ");
INSERT INTO marc_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","याहवेह त्याला म्हणाले, “तू हे काय केलेस? आता ऐक, तुझ्या भावाचे रक्त मला जमिनीतून हाक मारीत आहे. ");
INSERT INTO marc_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ज्या भूमीने तुझ्या भावाचे रक्त स्वीकारण्यास आपले मुख उघडले आहे, त्या भूमीतून तुला हद्दपार करण्यात आले आहे आणि तू शापित आहेस. ");
INSERT INTO marc_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","त्या भूमीवर तू कष्ट केलेस तरी ती तुला उपज देणार नाही. तू बेचैन असा पृथ्वीवर भटकशील.” ");
INSERT INTO marc_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","काईन याहवेहला म्हणाला, “मला मिळालेली शिक्षा माझ्या सहनशक्तीच्या पलीकडे आहे. ");
INSERT INTO marc_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","कारण तुम्ही मला माझ्या शेतातून हद्दपार केले आहे आणि तुमच्या सानिध्यापासून दूर केले आहे; मी पृथ्वीवर बेचैन असा भटकणारा होईन, जो कोणी मला पाहील, तो मला ठार करेल.” ");
INSERT INTO marc_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","यावर याहवेहने त्याला उत्तर दिले, “असे होणार नाही, जर कोणी काईनाचा जीव घेईल, तर त्याला मी तुला दिलेल्या शिक्षेपेक्षा सातपट शिक्षा देईन” आणि मग त्याचा वध कोणीही करू नये, असा इशारा देणारी एक खूण याहवेहने काईनावर केली. ");
INSERT INTO marc_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","मग काईन याहवेहच्या समक्षतेतून निघून गेला आणि एदेन बागेच्या पूर्वेस असलेल्या नोद नावाच्या देशात वस्ती करून राहिला. ");
INSERT INTO marc_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","पुढे काईनाने त्याच्या पत्नीशी वैवाहिक प्रीती संबंधात प्रवेश केला आणि ती गर्भवती झाली. तिने हनोख नावाच्या पुत्राला जन्म दिला. त्यावेळी काईन एक नगर बांधत होता, त्याने आपल्या पुत्राचे, हनोख हे नाव त्या नगराला दिले. ");
INSERT INTO marc_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोखपासून ईराद झाला आणि ईराद हा महूयाएलचा पिता, महूयाएल हा मथुशाएलचा पिता, मथुशाएल हा लामेखाचा पिता होता. ");
INSERT INTO marc_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लामेखाने आदाह व सिल्ला या दोन स्त्रियांशी लग्न केले. ");
INSERT INTO marc_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदाह हिला याबाल नावाचा पुत्र झाला. तो गुरे पाळणार्‍या व तंबू ठोकून राहणार्‍या लोकांचा मूळ पुरुष झाला. ");
INSERT INTO marc_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","त्याच्या भावाचे नाव युबाल असे होते. तो पहिला संगीतकार असून वीणा व बासरी ही वाद्ये वाजविणार्‍यांचा मूळ पुरुष झाला. ");
INSERT INTO marc_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","लामेखाची दुसरी स्त्री सिल्ला हिला तुबल-काईन झाला. तो कास्य व लोखंड यांची हत्यारे बनविणार्‍यांचा मूळ पुरुष झाला. तुबल—काईनास नामाह नावाची बहीण होती. ");
INSERT INTO marc_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","एके दिवशी लामेख आपल्या पत्नींना म्हणाला, आदाह व सिल्ला माझे ऐका, “लामेखाच्या पत्नींनो, माझे बोलणे ऐका. एका तरुणाने माझ्यावर हल्ला करून मला जखमी केले. पण त्या तरुणाला मी ठार मारले आहे. ");
INSERT INTO marc_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","जर काईनाबद्दल सातपट तर लामेखाबद्दल सत्याहत्तरपट सूड घेतला जाईल.” ");
INSERT INTO marc_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदामाने हव्वेशी पुन्हा प्रीती संबंध केला आणि हव्वेने पुत्राला जन्म दिला. तिने त्याचे नाव शेथ असे ठेवले, कारण ती म्हणाली, “काईनाने ठार केलेल्या हाबेल या माझ्या पुत्राच्या जागी परमेश्वराने मला दुसरा पुत्र दिला आहे.” ");
INSERT INTO marc_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेथ मोठा झाल्यावर त्यालाही एक पुत्र झाला, त्याचे नाव अनोश असे ठेवले. त्याच्या हयातीत लोकांनी याहवेहच्या नावाने आराधना करण्यास प्रारंभ केला. ");
INSERT INTO marc_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ही आदामाची लिखित वंशावळी आहे. जेव्हा परमेश्वराने मानवजातीला निर्माण केले, त्यांनी त्याला आपल्या प्रतिरूपात घडविले. ");
INSERT INTO marc_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","परमेश्वराने त्यांना पुरुष व स्त्री असे निर्माण केले. त्यांनी त्यांना आशीर्वाद दिला आणि त्यांना “मानवजात” असे नाव दिले. ");
INSERT INTO marc_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","आदाम 130 वर्षाचा झाला तेव्हा त्याला त्याच्या स्वतःच्या प्रतिरूपात, त्याच्या स्वतःच्या प्रतिमेत एक मुलगा झाला; त्याने त्याचे नाव शेथ ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","शेथच्या जन्मानंतर आदाम आणखी आठशे वर्षे जगला. याकाळात त्याला आणखी पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","आदाम एकंदर 930 वर्षे जगला आणि नंतर त्याचा मृत्यू झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","शेथ 105 वर्षाचा झाला, तेव्हा त्याला अनोश झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","अनोशचा पिता झाल्यावर शेथ 807 वर्षे जगला आणि त्याला आणखी पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","शेथ एकंदर 912 वर्षे जगला आणि नंतर त्याचा मृत्यू झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","अनोश नव्वद वर्षाचा झाला तेव्हा त्याला केनान झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनानचा पिता झाल्यावर अनोश 815 वर्षे जगला आणि त्याला आणखी पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","अनोश एकंदर 905 वर्षे जगला आणि नंतर त्याचा मृत्यू झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","केनान सत्तर वर्षाचा झाला तेव्हा तो महलालेलाचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महलालेलाचा पिता झाल्यावर केनान 840 वर्षे जगला आणि त्याला आणखी पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","केनान एकंदर 910 वर्षे जगला आणि नंतर त्याचा मृत्यू झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","महलालेल 65 वर्षाचा झाला तेव्हा तो यारेदाचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","यारेदाचा पिता झाल्यावर महलालेल 830 वर्षे जगला आणि त्याला आणखी पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","महलालेल एकंदर 895 वर्षे जगला आणि नंतर त्याचा मृत्यू झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","यारेद 162 वर्षाचा झाला तेव्हा तो हनोखाचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोखाचा पिता झाल्यावर यारेद 800 वर्षे जगला आणि त्याला आणखी पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","यारेद एकंदर 962 वर्षे जगला आणि नंतर त्याचा मृत्यू झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","हनोख 65 वर्षाचा झाला तेव्हा तो मथुशेलहाचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मथुशेलहाचा पिता झाल्यावर हनोख परमेश्वरासोबत विश्वासूपणे 300 वर्षे चालला आणि त्याला आणखी पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","हनोख एकंदर 365 वर्षे जगला. ");
INSERT INTO marc_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोख परमेश्वरासोबत विश्वासूपणे चालत असताना तो अदृश्य झाला, कारण परमेश्वराने त्याला नेले. ");
INSERT INTO marc_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","मथुशेलह 187 वर्षाचा झाला तेव्हा तो लामेखाचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लामेखाचा पिता झाल्यानंतर मथुशेलह 782 वर्षे जगला आणि त्याला आणखी पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","मथुशेलह एकंदर 969 वर्षे जगला आणि नंतर त्याचा मृत्यू झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","लामेख 182 वर्षांचा झाल्यावर त्याला पुत्र झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","त्याने त्याचे नाव नोआह असे ठेवले, कारण तो म्हणाला, “शाप दिलेली भूमी कसण्याच्या अवघड कामापासून याहवेह आम्हाला विसावा देतील.” ");
INSERT INTO marc_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नोआहच्या जन्मानंतर लामेख 595 वर्षे जगला आणि त्याला आणखी पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","लामेख एकंदर 777 वर्षे जगला आणि नंतर त्याचा मृत्यू झाला. ");
INSERT INTO marc_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नोआह 500 वर्षाचा झाला तेव्हा तो शेम, हाम व याफेथ यांचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","पृथ्वीवर मानवाची संख्या खूप वाढू लागली आणि त्यांना कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","परमेश्वराच्या पुत्रांनी बघितले की मानवाच्या कन्या सुंदर आहेत; आणि आपल्या आवडीप्रमाणे त्यांनी त्यांच्याशी विवाह केला. ");
INSERT INTO marc_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","तेव्हा याहवेह म्हणाले, “माझा आत्मा मानवासोबत वादविवाद करीत राहणार नाही, कारण ते दैहिक आहेत आणि त्यांचा जीवनकाल एकशेवीस वर्षे असेल.” ");
INSERT INTO marc_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","त्या दिवसात—आणि नंतरच्या काळातही—महाबलाढ्य मानव पृथ्वीवर वास करीत होते, जेव्हा परमेश्वराच्या पुत्रांनी मानवकन्यांशी विवाह केला, त्यांना संतती झाली. तेच जुन्या काळातील समर्थ आणि प्रसिद्ध मानव झाले. ");
INSERT INTO marc_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","पृथ्वीवर मानवामध्ये दुष्टाई खूप वाढलेली आहे आणि त्यांचे विचार आणि कल्पना या सतत दुष्टाईच्याच असतात हे याहवेहने पाहिले. ");
INSERT INTO marc_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","आपण मनुष्य निर्माण केल्याचा याहवेहला पश्चात्ताप झाला आणि त्यांच्या हृदयाला अतोनात वेदना झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","म्हणून याहवेह म्हणाले, “मी निर्माण केलेल्या मानवजातीला पृथ्वीतलावरून नष्ट करेन—त्यांच्यासह पशू, सरपटणारे प्राणी, आकाशातील पक्षी यांनाही नष्ट करेन—कारण त्यांना निर्माण केल्याचा मला पश्चात्ताप होत आहे.” ");
INSERT INTO marc_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","परंतु नोआहवर याहवेहची कृपादृष्टी झाली. ");
INSERT INTO marc_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नोआह आणि त्याच्या कुटुंबाचा वृतांत असा. नोआह आपल्या काळाच्या पिढीत एक नीतिमान आणि निर्दोष मनुष्य होता आणि तो परमेश्वरासोबत विश्वासूपणे चालला. ");
INSERT INTO marc_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नोआहला शेम, हाम व याफेथ हे तीन पुत्र झाले. ");
INSERT INTO marc_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","परमेश्वराच्या दृष्टीने पृथ्वी पापाने भ्रष्ट झालेली आणि हिंसाचाराने पूर्णपणे भरलेली होती. ");
INSERT INTO marc_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","जग किती पातकी झाले आहे आणि समस्त मानवजात किती भ्रष्ट झाली आहे हे परमेश्वराने पाहिले. ");
INSERT INTO marc_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","तेव्हा परमेश्वर नोआहला म्हणाले, “मी सर्व मनुष्यांचा नाश करेन, कारण त्यांच्यामुळे पृथ्वी हिंसाचाराने भरून गेली आहे. मी निश्चितपणे त्यांचा आणि पृथ्वीचा नाश करणार आहे. ");
INSERT INTO marc_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","तू आपल्याकरिता गोफेर लाकडाचे एक तारू तयार कर; त्यात कोठड्या बनव आणि त्याला आतून व बाहेरून डांबर लाव. ");
INSERT INTO marc_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ते अशा प्रकारे तयार कर: तारू तीनशे हात लांब, पन्नास हात रुंद आणि तीस हात उंच असावे. ");
INSERT INTO marc_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","त्याकरिता छत तयार कर, तारवाला वरच्या बाजूला एक खिडकी कर. ही खिडकी छतापासून खाली सभोवती एक हात उंच असावी. तसेच तारवाला वरचा, मधला आणि खालचा असे तीन मजले बांध आणि तारवाच्या एका बाजूला दार कर. ");
INSERT INTO marc_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","मी पृथ्वी महापुराने भरून टाकणार आहे आणि आकाशाखाली ज्यामध्ये जीवनाचा श्वास आहे, अशा प्रत्येक सजीव प्राण्याचा मी नाश करणार आहे. पृथ्वीवर जे काही आहे त्याचा नाश होईल. ");
INSERT INTO marc_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","परंतु मी तुझ्यासोबत करार स्थापित करेन—तू आणि तुझे पुत्र आणि तुझी पत्नी व तुझ्या पुत्रांच्या पत्नी हे तारवात प्रवेश करतील. ");
INSERT INTO marc_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","तू प्रत्येक जातीचे दोन-दोन पशू, एक नर व एक मादी, अशा जोड्या जिवंत राखण्यासाठी आपल्याबरोबर तारवात घेऊन ये. ");
INSERT INTO marc_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","प्रत्येक प्रकारचे पक्षी, प्रत्येक प्रकारचे प्राणी आणि जमिनीवर सरपटणारे प्रत्येकी दोन-दोन प्राणी जिवंत राहण्यासाठी तुझ्याकडे येतील. ");
INSERT INTO marc_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","आणि खावयाचे सर्वप्रकारचे अन्न घे आणि ते स्वतःसाठी आणि त्यांच्यासाठी साठवून ठेव.” ");
INSERT INTO marc_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","परमेश्वराने आज्ञा दिल्याप्रमाणेच नोआहने सर्वकाही केले. ");
INSERT INTO marc_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","याहवेह नोआहला म्हणाले, “तू आणि तुझे पूर्ण कुटुंब तारवात जा, कारण या पिढीत तूच नीतिमान असल्याचे मला आढळले आहे. ");
INSERT INTO marc_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","तुझ्याबरोबर शुद्ध अशा प्राण्यांच्या प्रत्येक जातीच्या नर व मादी अशा सात जोड्या आणि अशुद्ध प्राण्यांच्या प्रत्येक जातीची नर व मादी अशी एकच जोडी ने, ");
INSERT INTO marc_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","आणि प्रत्येक जातीच्या पक्ष्याच्या नरमादीच्या सात जोड्या, म्हणजे पृथ्वीवर त्यांचे विविध प्रकार जिवंत राहतील. ");
INSERT INTO marc_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","आजपासून बरोबर सात दिवसानंतर मी पृथ्वीवर चाळीस दिवस आणि चाळीस रात्र पाऊस पाडेन आणि मी निर्माण केलेल्या सर्व जिवंत प्राण्यांना पृथ्वीवरून नष्ट करून टाकेन.” ");
INSERT INTO marc_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","याहवेहने दिलेल्या आज्ञेप्रमाणे नोआहने सर्वकाही केले. ");
INSERT INTO marc_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","जलप्रलय आला, तेव्हा नोआह सहाशे वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","जलप्रलयापासून वाचण्यासाठी नोआह आणि त्याचे पुत्र आणि त्याची पत्नी, व पुत्रांच्या पत्नी यांनी तारवात प्रवेश केला. ");
INSERT INTO marc_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","तारवात त्याच्याबरोबर शुद्ध आणि अशुद्ध पशू, पक्षी व सरपटणारे प्राणी होते. ");
INSERT INTO marc_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","परमेश्वराने नोआहला आज्ञा दिल्याप्रमाणे ते सर्व प्राणी नर व मादी अशा जोडीने तारवात आले. ");
INSERT INTO marc_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","आणि सात दिवसानंतर पृथ्वीवर जलप्रलय आला. ");
INSERT INTO marc_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नोआहच्या आयुष्याच्या सहाशेव्या वर्षात, दुसर्‍या महिन्याच्या सतराव्या दिवशी—त्याच दिवशी पृथ्वीच्या पोटातील सर्व झर्‍यातील पाणीही उफाळून वर आले आणि आकाशाची दारे उघडली. ");
INSERT INTO marc_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","आणि पृथ्वीवर आकाशातून चाळीस दिवस आणि चाळीस रात्र पाऊस पडला. ");
INSERT INTO marc_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","त्याच दिवशी नोआह आणि त्याचे पुत्र शेम, हाम व याफेथ, त्यांच्यासोबत त्याची पत्नी आणि त्याच्या मुलांच्या पत्नी तारवात गेले. ");
INSERT INTO marc_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","त्यांच्याबरोबर प्रत्येक वन्यजातीचे प्राणी, सर्वप्रकारचे पाळीव पशू, जमिनीवर सरपटणारे प्राणी आणि प्रत्येक जातीचे, पंख असलेले सर्व पक्षी तारवात गेले. ");
INSERT INTO marc_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ज्यांच्यामध्ये जीवनाचा श्वास आहे, अशा प्रत्येक जातीच्या प्राण्यांची एकएक जोडी नोआहकडे आली आणि त्यांनी नोआहसोबत तारूत प्रवेश केला. ");
INSERT INTO marc_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","नर व मादी असे ते परमेश्वराच्या आज्ञेप्रमाणे जोडीजोडीने आले. मग याहवेहने त्यांना आत ठेवून तारवाचे दार बंद केले. ");
INSERT INTO marc_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","जलप्रलय चाळीस दिवस चालू होता. यामुळे सर्व पृथ्वी पाण्याने व्यापून गेली आणि तारू पृथ्वीच्यावर पाण्यात तरंगू लागले. ");
INSERT INTO marc_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","पाणी जमिनीवर वाढू लागले आणि तारू पाण्याच्या पृष्ठभागावर तरंगू लागले. ");
INSERT INTO marc_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","शेवटी पाणी इतके वाढले की, आकाशाखाली असलेले सर्व उंच पर्वतदेखील बुडून गेले. ");
INSERT INTO marc_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","पाणी वाढले आणि पर्वतांना पंधरा हातापेक्षा जास्त खोलीपर्यंत झाकले. ");
INSERT INTO marc_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","पृथ्वीवर जिवंत असलेले सर्व प्राणी नष्ट झाले—त्यात आकाशातील पक्षी, पाळीव जनावरे, वन्यपशू, सरपटणारे प्राणी आणि अखिल मानवजात या सर्वांचा समावेश होता. ");
INSERT INTO marc_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","कोरड्या जमिनीवर राहणारा, श्वास घेणारा प्रत्येक प्राणी मरण पावला. ");
INSERT INTO marc_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","पृथ्वीवर असलेल्या प्रत्येक सजिवांचा नाश झाला; मानव आणि प्राणी आणि सरपटणारे प्राणी आणि पक्षी पृथ्वीवरून नाहीसे झाले. फक्त नोआह आणि त्याच्यासोबत तारवात असलेलेच वाचले. ");
INSERT INTO marc_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","पृथ्वी पाण्याच्या पुराखाली दीडशे दिवस राहिली. ");
INSERT INTO marc_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","परमेश्वराने नोआह आणि तारवातील सर्व पाळीव व वन्यप्राण्यांचे स्मरण केले. त्यांनी पृथ्वीवरून वाहण्यासाठी वारा पाठविला आणि पुराचे पाणी ओसरू लागले. ");
INSERT INTO marc_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","पृथ्वीतलातील पाण्याचे झरे उफाळण्याचे थांबले आणि आकाशातील जलप्रलयाची दारे बंद झाली, आकाशातून पडणारा पाऊसही थांबला. ");
INSERT INTO marc_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","पृथ्वीवरून पाणी सतत कमी होत गेले. दीडशे दिवस उलटल्यानंतर पाणी ओसरले. ");
INSERT INTO marc_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","आणि सातव्या महिन्याच्या सतराव्या दिवशी तारू अरारात पर्वतावर स्थिरावले. ");
INSERT INTO marc_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","पाणी ओसरू लागले व दहाव्या महिन्यापर्यंत पाणी सतत ओसरत होते आणि दहाव्या महिन्याच्या पहिल्या दिवशी पर्वतांची शिखरे दिसू लागली. ");
INSERT INTO marc_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","आणखी चाळीस दिवसानंतर नोआहने तारवात बनविलेली खिडकी उघडली ");
INSERT INTO marc_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","आणि त्याने एक कावळा बाहेर सोडला. तो पृथ्वीवरील सर्व पाणी ओसरेपर्यंत तारवातून येणे जाणे करीत होता. ");
INSERT INTO marc_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","दरम्यान नोआहने एका कबुतराला, पृथ्वीवरील पाणी ओसरले की नाही हे पाहण्यासाठी बाहेर सोडले. ");
INSERT INTO marc_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","परंतु ते कबुतर त्याच्याकडे परत आले, कारण अजूनही पाणी पृथ्वीवर बरेच वर असल्यामुळे त्याला उतरावयाला कुठेही जागा मिळाली नाही. म्हणून नोआहने आपला हात बाहेर काढून कबुतराला परत तारवात घेतले. ");
INSERT INTO marc_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","आणखी सात दिवस थांबून नोआहने तारवातून ते कबुतर पुन्हा बाहेर सोडले. ");
INSERT INTO marc_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","संध्याकाळी कबुतर जेव्हा त्याच्याकडे परत आले, तेव्हा त्याच्या चोचीत एक ताजे जैतुनाचे पान होते! मग नोआहला समजले की पृथ्वीवरून पाणी ओसरले आहे. ");
INSERT INTO marc_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","मग आणखी सात दिवस थांबून त्याने ते कबुतर पुन्हा बाहेर सोडले, परंतु यावेळी ते परत आले नाही. ");
INSERT INTO marc_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नोआहच्या सहाशे एकाव्या वर्षी, पहिल्या वर्षाच्या, पहिल्या महिन्याच्या पहिल्या दिवशी, पृथ्वीवरील पाणी वाळले. मग नोआहने तारवाचे दार उघडून बाहेर पाहिले, तेव्हा पृथ्वी कोरडी झाल्याचे त्याला दिसून आले. ");
INSERT INTO marc_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दुसर्‍या महिन्याच्या सत्ताविसाव्या दिवसापर्यंत पृथ्वी पूर्णपणे कोरडी झाली. ");
INSERT INTO marc_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","मग परमेश्वराने नोआहला सांगितले, ");
INSERT INTO marc_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“तू आणि तुझी पत्नी, तुझे पुत्र व त्यांच्या पत्नी असे सर्वांनी तारवाच्या बाहेर यावे. ");
INSERT INTO marc_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","प्रत्येक प्रकारचा सजीव प्राणी—पक्षी, पशू, सरपटणारे सर्व प्राणी—यांनाही बाहेर आणावे, म्हणजे त्यांची भरभराट होईल आणि ते फलद्रूप होऊन पृथ्वीवर बहुगुणित होतील.” ");
INSERT INTO marc_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","मग नोआह, त्याचे पुत्र व त्याची पत्नी आणि पुत्रांच्या पत्नी हे तारूच्या बाहेर आले. ");
INSERT INTO marc_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","यांच्याबरोबर पशू, सरपटणारे प्राणी व पक्षी—भूमीवर वावरणारे सर्वप्रकारचे प्राणी तारवातून उतरले. ");
INSERT INTO marc_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","मग नोआहने याहवेहसाठी एक वेदी बांधली आणि त्याने शुद्ध पक्ष्यांतून काही आणि शुद्ध पशूतून काही घेतले आणि त्यांचे वेदीवर होमार्पण केले. ");
INSERT INTO marc_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","तेव्हा याहवेह अर्पणाच्या सुगंधाने संतुष्ट झाले आणि आपल्या अंतःकरणात म्हणाले: “जरी लहानपणापासून मानवी हृदयाची प्रत्येक प्रवृत्ती वाईट आहे तरी मी मनुष्यामुळे जमिनीला पुन्हा कधी शाप देणार नाही आणि जसा मी केला आहे, तसा सर्व जिवंत प्राण्यांचा नाश यापुढे कधीही करणार नाही. ");
INSERT INTO marc_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“पृथ्वी अस्तित्वात आहे, तोपर्यंत वसंतॠतू व हंगामाचा काळ, थंडी व उष्णता, हिवाळा व उन्हाळा, दिवस व रात्र ही व्हावयाची थांबणार नाहीत.” ");
INSERT INTO marc_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","परमेश्वराने नोआहला व त्याच्या पुत्रांना आशीर्वाद देऊन सांगितले, “फलद्रूप व्हा, बहुगुणित व्हा आणि पृथ्वी व्यापून टाका. ");
INSERT INTO marc_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","पृथ्वीवरील प्रत्येक प्राणी आणि आकाशातील प्रत्येक पक्षी, जमिनीवर सरपटणारे प्रत्येक प्राणी आणि समुद्रातील सर्व मासे यांना तुमचे भय व दहशत वाटेल, कारण मी त्यांना तुमच्या ताब्यात दिले आहे; ");
INSERT INTO marc_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","जे काही सजीव आहे आणि पृथ्वीवर वावरते ते तुमचे अन्न असेल. धान्य व वनस्पती याबरोबरच आता ते सर्व मी तुमच्या स्वाधीन करतो. ");
INSERT INTO marc_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“परंतु ज्या मांसामध्ये जीवनदायी रक्त आहे, असे मांस तू खाऊ नकोस ");
INSERT INTO marc_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","आणि मी तुझ्या जीवनदायी रक्ताचा जाब निश्चितच मागेन. जो कोणी एखाद्या मनुष्याचा वध करेल, त्या प्रत्येक पशूकडून मी जीवनाचा जाब घेणार. प्रत्येक मनुष्याकडून दुसर्‍या मनुष्याच्या वधाचा मी जाब घेणार. ");
INSERT INTO marc_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“जो कोणी मनुष्याचे रक्त वाहील, मनुष्याद्वारेच त्याचा रक्तपात करण्यात येईल; कारण परमेश्वराने आपल्या प्रतिरूपात मानवाला निर्माण केले आहे. ");
INSERT INTO marc_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","तुम्ही तर फलद्रूप व्हा, बहुगुणित व्हा आणि पृथ्वी व्यापून टाका आणि तिच्यावर संपन्न व्हा.” ");
INSERT INTO marc_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","मग परमेश्वर नोआहला व त्याच्या पुत्रांना म्हणाले: ");
INSERT INTO marc_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“आता मी तुझ्याशी व तुझ्या वंशजांशी करार स्थापित करतो. ");
INSERT INTO marc_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","तुम्ही तुमच्याबरोबर तारवातून आणलेल्या—पक्षी, गुरे आणि वन्यपशू—अशा सर्वप्रकारच्या सजीव प्राण्यांशी करार करतो. ");
INSERT INTO marc_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","यापुढे सर्व सजिवांचा जलप्रलयाद्वारे मी कधीही नाश करणार नाही; पृथ्वीचा नाश करण्याकरिता मी दुसरा जलप्रलय केव्हाही पाठविणार नाही, असा मी तुझ्याशी करार करतो.” ");
INSERT INTO marc_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","आणि परमेश्वर म्हणाले, “माझ्या आणि तुझ्यामध्ये व तुमच्याबरोबर जे सर्व जिवंत आहेत त्यांच्यामध्ये सर्वकाळाच्या पिढ्यांपर्यंत जो करार मी करतो त्याची खूण हीच आहे: ");
INSERT INTO marc_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","पृथ्वी व माझ्यामध्ये केलेल्या कराराचे चिन्ह म्हणून माझे मेघधनुष्य मी मेघात ठेवले आहे ");
INSERT INTO marc_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ज्यावेळी मी पृथ्वीवर मेघ आणेन, त्यावेळी हे धनुष्य मेघांत प्रगट होईल. ");
INSERT INTO marc_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","आणि पृथ्वीवर पुन्हा जलप्रलय येणार नाही आणि सर्व प्राणिमात्रांचा नाश होणार नाही, तुमच्याशी आणि प्रत्येक प्राण्याशी केलेल्या या कराराची मला आठवण होईल. ");
INSERT INTO marc_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","जेव्हा मी ते धनुष्य मेघांमध्ये पाहीन, तेव्हा परमेश्वर आणि पृथ्वीवरील प्रत्येक प्राणिमात्राशी केलेल्या सार्वकालिक कराराची मला आठवण होईल.” ");
INSERT INTO marc_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","परमेश्वर नोआहस म्हणाले, “पृथ्वीवरील सर्व सजीव व माझ्याबरोबर स्थापित झालेल्या कराराचे हे चिन्ह असेल.” ");
INSERT INTO marc_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नोआहबरोबर तारूमधून बाहेर आलेल्या पुत्रांची नावे शेम, हाम व याफेथ ही होती. (हाम हा कनानाचा पिता होता.) ");
INSERT INTO marc_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","हे नोआहचे तीन पुत्र होते आणि यांच्याद्वारे पृथ्वीवर मानवजात पसरली. ");
INSERT INTO marc_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नोआह शेतकरी झाला व त्याने एक द्राक्षमळा लावला. ");
INSERT INTO marc_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","एके दिवशी तो द्राक्षारस प्याला आणि द्राक्षारसाने धुंद होऊन आपल्या तंबूत उघडानागडा पडला. ");
INSERT INTO marc_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","कनानचा पिता हाम याने आपल्या पित्याची नग्नता पाहिली आणि बाहेर जाऊन त्याने ही गोष्ट आपल्या दोन्ही भावांना सांगितली. ");
INSERT INTO marc_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","हे ऐकून शेम व याफेथ यांनी एक झगा घेतला; आपल्या खांद्यांपर्यंत तो उंच धरून ते आपल्या पित्याची नग्नता झाकली जावी म्हणून उलट्या पावली चालत जाऊन, विरुद्ध दिशेला पाहत त्यांनी तो झगा त्याच्या अंगावर टाकला. ");
INSERT INTO marc_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","नोआह नशेतून शुद्धीवर आला आणि आपला धाकट्या पुत्राने काय केले हे त्याला समजले, ");
INSERT INTO marc_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","तो म्हणाला, “कनान शापित असो! तो आपल्या भावांच्या गुलामातील सर्वात कनिष्ठ गुलाम होवो.” ");
INSERT INTO marc_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","मग नोआह असेही म्हणाला, “शेमचे परमेश्वर याहवेह यांची स्तुती असो! कनान शेमचा गुलाम होवो. ");
INSERT INTO marc_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्वर याफेथच्या प्रदेशाचा विस्तार करोत; याफेथ शेमच्या तंबूत राहो, आणि कनान त्याचाही गुलाम होवो.” ");
INSERT INTO marc_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","जलप्रलयानंतर नोआह साडेतीनशे वर्षे जगला. ");
INSERT INTO marc_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","950 वर्षाचा होऊन नोआह मृत्यू पावला. ");
INSERT INTO marc_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नोआहचे पुत्र शेम, हाम व याफेथ यांची वंशावळ अशी: त्यांना जलप्रलयानंतर पुत्र झाले. ");
INSERT INTO marc_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","याफेथाचे पुत्र: गोमेर, मागोग, मादय, यावान, तूबाल, मेशेख व तीरास. ");
INSERT INTO marc_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेरचे पुत्र: आष्कनाज, रीपाथ व तोगर्माह. ");
INSERT INTO marc_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावानाचे पुत्र: एलिशाह, तार्शीश, कित्तीम व दोदानीम. ");
INSERT INTO marc_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","या वंशांचे लोक निरनिराळ्या देशांत समुद्र किनार्‍याजवळील वस्ती करणारी राष्ट्रे बनली. प्रत्येक भाषेनुसार, कुळानुसार ते राष्ट्रांमध्ये पसरले. ");
INSERT INTO marc_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हामाचे पुत्र: कूश, इजिप्त, पूट व कनान. ");
INSERT INTO marc_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूशाचे पुत्र: सबा, हवीला, साब्ता, रामाह व साब्तेका. रामाहचे पुत्र: शबा व ददान. ");
INSERT INTO marc_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूशचा पुत्र निम्रोद होता, जो पृथ्वीवरील एक वीर व्यक्ती झाला. ");
INSERT INTO marc_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","तो याहवेहसमोर एक बलवान शिकारी होता; “याहवेहसमोर निम्रोदासारखा पराक्रमी शिकारी.” असा उल्लेख करण्याची प्रथा पडली होती. ");
INSERT INTO marc_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","शिनार प्रांतातील बाबिलोन, एरक, अक्काद व कालनेह ही त्याच्या राज्यातील प्रमुख शहरे होती. ");
INSERT INTO marc_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","शिनारपासून त्याने आपल्या राज्याचा विस्तार अश्शूरपर्यंत केला. त्याने निनवेह, रेहोबोथ ईर व कालह ");
INSERT INTO marc_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","व रेसन शहर, जे निनवेह व कालह यांच्या दरम्यान होते, ते वसविले. रेसन हे त्याच्या राज्यातील एक प्रमुख शहर होते. ");
INSERT INTO marc_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","इजिप्तचे पुत्र: लूदीम, अनामीम, लहाबीम, नाप्तुहीम, ");
INSERT INTO marc_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पात्रुसीम, कास्लूहीम (ज्यापासून पलिष्टी लोक आले) आणि कफतोरीम. ");
INSERT INTO marc_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान यांचा पिता होता: प्रथमपुत्र सीदोन आणि हेथ, ");
INSERT INTO marc_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, अमोरी, गिर्गाशी, ");
INSERT INTO marc_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, आर्की, सीनी ");
INSERT INTO marc_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वादी, समारी व हमाथी. (नंतर कनानी वंशज विखुरले ");
INSERT INTO marc_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","आणि सीदोनापासून गरारपासून गाझाच्या पट्ट्‍यातील, सदोम, गमोरा, अदमाह व लेशाजवळील सबोईम येथवर कनानाची सीमा पसरली.) ");
INSERT INTO marc_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","वंश, भाषा, प्रदेश आणि राष्ट्रांनुसार हे हामाचे गोत्र आहेत. ");
INSERT INTO marc_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","याफेथचा धाकटा भाऊ शेम यालाही पुत्र झाले, शेम एबरच्या सर्व संतानांचा पूर्वज होता. ");
INSERT INTO marc_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेमचे पुत्र: एलाम, अश्शूर, अर्पक्षद, लूद व अराम. ");
INSERT INTO marc_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अरामाचे पुत्र: ऊस, हूल, गेतेर व मेशेख. ");
INSERT INTO marc_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पक्षद हा शेलाहचा पिता झाला व शेलाह एबरचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबरला दोन पुत्र झाले: एकाचे नाव पेलेग ठेवले, कारण याच्या हयातीत पृथ्वीची विभागणी झाली; त्याच्या भावाचे नाव योक्तान होते. ");
INSERT INTO marc_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","योक्तानचे पुत्र: अलमोदाद, शेलेफ, हसर्मावेथ, येरह, ");
INSERT INTO marc_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोराम, ऊजाल, दिक्लाह, ");
INSERT INTO marc_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शबा, ");
INSERT INTO marc_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओफीर, हवीला व योबाब. हे सर्व योक्तानचे पुत्र होते. ");
INSERT INTO marc_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(ते मेशापासून सफार या पूर्वेकडील डोंगरापर्यंतच्या भागात राहत होते.) ");
INSERT INTO marc_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","कुळे, भाषा, देश आणि राष्ट्रे अशाप्रकारे गोत्रानुसार विभागणी केलेले शेमचे हे वंशज होते. ");
INSERT INTO marc_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","वर दिलेल्या यादीत नमूद केलेले सर्व लोक नोआहच्या अनेक पिढ्यांतील गोत्र होते. त्यांनी निरनिराळ्या राष्ट्रांत वस्ती केली. ही सर्व राष्ट्रे जलप्रलयानंतर पसरली. ");
INSERT INTO marc_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","त्याकाळी पृथ्वीवरील सर्व मानवांची एकच भाषा आणि एकच बोली होती. ");
INSERT INTO marc_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","पुढे ते पूर्वेकडे जात असता, त्या लोकांना शिनार प्रांतात एक मैदान लागले आणि त्यांनी तिथे वस्ती केली. ");
INSERT INTO marc_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ते एकमेकास म्हणाले, “चला आपण विटा तयार करून त्याला पक्क्या भाजू या.” त्याप्रमाणे त्यांनी दगडाऐवजी विटा तयार केल्या आणि चुना म्हणून डांबर वापरले. ");
INSERT INTO marc_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","मग ते म्हणाले, “आपण स्वतःसाठी एक मोठे शहर आणि आकाशाला भिडणारा अतिउंच बुरूज बांधू म्हणजे आपण प्रसिद्ध होऊ; नाहीतर पृथ्वीतलावर आपली पांगापांग होईल.” ");
INSERT INTO marc_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","परंतु जेव्हा मानव बांधत असलेले शहर आणि बुरूज पाहण्यास याहवेह खाली आले, ");
INSERT INTO marc_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","तेव्हा याहवेह म्हणाले, “हे सर्व एक असून त्यांची भाषा ही एकच आहे, जर ही योजना साध्य झाली तर मानवांना असाध्य असे काहीही राहणार नाही. ");
INSERT INTO marc_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","चला, आपण खाली जाऊ आणि त्यांच्या भाषेत वेगवेगळ्या भाषांची सरमिसळ करू, म्हणजे त्यांना एकमेकांचे बोलणे समजणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","अशा रीतीने याहवेहने सर्व पृथ्वीभर मानवांची पांगापांग केली आणि त्यांचे शहर बांधण्याचे काम थांबले. ");
INSERT INTO marc_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","म्हणून त्या शहराला बाबिलोन म्हणतात, कारण याहवेहने मानवांना गोंधळात पाडून अनेक भाषा दिल्या आणि सर्व पृथ्वीभर त्यांची पांगापांग केली. ");
INSERT INTO marc_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेमाची वंशावळी: अर्पक्षद याचा जन्म जलप्रलयानंतर दोन वर्षांनी झाला, त्यावेळी शेम 100 वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अर्पक्षदाचा पिता झाल्यानंतर शेम आणखी 500 वर्षे जगला आणि त्याला इतरही पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","अर्पक्षद 35 वर्षांचा असताना तो शेलाहचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","शेलाहच्या जन्मानंतर अर्पक्षद आणखी 403 वर्षे जगला. त्या काळात त्याला इतरही पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","जेव्हा शेलाह 30 वर्षांचा झाला तेव्हा तो एबरचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","आणि एबरचा पिता झाल्यावर शेलाह आणखी 403 वर्षे जगला आणि त्याला इतरही पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","एबरचा पुत्र पेलेग जन्मला तेव्हा एबर 34 वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","पेलेग जन्मल्यानंतर एबर 430 वर्षे जगला आणि त्याला इतरही पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","पेलेगचा पुत्र रऊ जन्मला तेव्हा पेलेग 30 वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","रऊच्या जन्मानंतर पेलेग आणखी 209 वर्षे जगला आणि त्याला इतरही पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","रऊचा पुत्र सरूग जन्मला तेव्हा रऊ 32 वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","सरूगच्या जन्मानंतर रऊ आणखी 207 वर्षे जगला आणि त्याला इतरही पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","सरूगचा पुत्र नाहोर जन्मला तेव्हा तो 30 वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","नाहोरच्या जन्मानंतर सरूग आणखी 200 वर्षे जगला, आणि त्याला इतरही पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","नाहोर 29 वर्षांचा होता तेव्हा त्याला तेरह झाला. ");
INSERT INTO marc_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","तेरहचा पिता झाल्यावर नाहोर पुढे आणखी 119 वर्षे जगला आणि त्याला इतरही पुत्र व कन्या झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तेरह 70 वर्षांचा होईपर्यंत त्याला अब्राम, नाहोर व हारान हे तीन पुत्र झाले. ");
INSERT INTO marc_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरहाच्या वंशजाचा तपशील: तेरहास अब्राम, नाहोर व हारान हे पुत्र होते. हारानाला लोट नावाचा पुत्र झाला. ");
INSERT INTO marc_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","पण हारान त्याच्या पिता तेरह जिवंत असताना, आपल्या जन्मस्थानी, खाल्डियनांच्या ऊर गावी मरण पावला. ");
INSERT INTO marc_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम व नाहोर यांनी विवाह केले. अब्रामाच्या पत्नीचे नाव साराय होते व नाहोराच्या पत्नीचे नाव मिल्का होते; मिल्का ही हारानाची कन्या होती आणि हारान हा मिल्का व इस्काह यांचा पिता होता. ");
INSERT INTO marc_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारायला मूलबाळ नव्हते कारण ती वांझ होती. ");
INSERT INTO marc_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","मग आपला पुत्र अब्राम, आपला नातू म्हणजे हारानाचा पुत्र लोट आणि आपली सून साराय, यांना बरोबर घेऊन कनान देशात जाण्यासाठी तेरहाने खाल्डियनांचे ऊर गाव सोडले; पण कनान देशात जाण्याऐवजी ते हारान शहरीच स्थायिक झाले. ");
INSERT INTO marc_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरहाचे वय 205 वर्षांचे होऊन, हारान येथे तो मरण पावला. ");
INSERT INTO marc_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","याहवेहने अब्रामाला सांगितले होते, “तू आपला देश, आपले लोक व आपल्या पित्याचे घर सोड आणि मी दाखवेन त्या देशात जा. ");
INSERT INTO marc_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“मी तुला एक मोठे राष्ट्र करेन, मी तुला आशीर्वाद देईन; आणि तुझे नाव महान करेन आणि तू एक आशीर्वाद असा होशील. ");
INSERT INTO marc_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","जे तुला आशीर्वाद देतील, त्यांना मी आशीर्वाद देईन, आणि जे तुला शाप देतील, त्यांना मी शाप देईन; आणि तुझ्याद्वारे पृथ्वीवरील सर्व कुळे आशीर्वादित होतील.” ");
INSERT INTO marc_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","याहवेहने सूचना केल्याप्रमाणे अब्राम निघाला; आणि लोटही त्याच्याबरोबर गेला. अब्राम हारान येथून निघाला त्यावेळी तो पंचाहत्तर वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्राम आपल्याबरोबर आपली पत्नी साराय, त्याचा पुतण्या लोट, तसेच आपली धनदौलत म्हणजे हारानात मिळालेली गुरे व लोक घेऊन निघाला आणि कनान देशात पोहोचला. ");
INSERT INTO marc_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम त्या प्रदेशातून प्रवास करीत शेखेम येथील मोरेहच्या मोठ्या एला वृक्षापर्यंत गेला. त्यावेळी कनानी लोक या देशात राहत होते. ");
INSERT INTO marc_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","मग याहवेहने अब्रामाला दर्शन देऊन म्हटले, “हा देश मी तुझ्या संतानाला देणार आहे.” तेव्हा जे अब्रामाला प्रकट झाले त्या याहवेहसाठी त्याने एक वेदी बांधली. ");
INSERT INTO marc_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","तिथून तो बेथेलाच्या पूर्वेकडे डोंगराकडे गेला आणि जिथे पश्चिमेकडे बेथेल व पूर्वेकडे आय हे शहर होते, तिथे त्याने आपला तळ दिला. तिथेच त्याने याहवेहसाठी एक वेदी बांधली आणि याहवेहच्या नावाने उपासना केली. ");
INSERT INTO marc_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","मग अब्राम निघाला आणि दक्षिणेच्या दिशेने चालू लागला. ");
INSERT INTO marc_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","त्यावेळी त्या देशात मोठा दुष्काळ पडला होता म्हणून अब्राम इजिप्तमध्ये राहण्यास गेला, कारण दुष्काळ फारच भयंकर होता. ");
INSERT INTO marc_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","परंतु इजिप्तच्या सीमेवर आल्यानंतर तो आपली पत्नी साराय हिला म्हणाला, “तू फार सुंदर आहेस, ");
INSERT INTO marc_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","आणि इजिप्तचे लोक तुला पाहतील व म्हणतील, ‘ही याची पत्नी आहे.’ मग ते मला मारून टाकतील आणि तुला जगू देतील. ");
INSERT INTO marc_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","तू माझी बहीण आहेस असे सांग, म्हणजे तुझ्यामुळे मला ते चांगले वागवतील आणि तुझ्यामुळे माझा जीव वाचेल.” ");
INSERT INTO marc_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","अब्राम इजिप्तमध्ये आला तेव्हा इजिप्तच्या लोकांनी पाहिले की साराय ही अतिशय सुंदर स्त्री आहे. ");
INSERT INTO marc_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","जेव्हा फारोह राजाच्या सरदारांनी तिला पाहिले तेव्हा त्यांनी फारोहजवळ तिची प्रशंसा केली; आणि तिला राजवाड्यात नेण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","मग फारोहने तिच्यामुळे अब्रामाला मेंढरे, बैल, गाढवे, उंट तसेच गुलाम स्त्री व पुरुष अशा पुष्कळ देणग्या दिल्या. ");
INSERT INTO marc_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","परंतु याहवेहने अब्रामाची पत्नी साराय तिथे असल्यामुळे फारोहच्या घरावर भयंकर पीडा पाठविली. ");
INSERT INTO marc_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","तेव्हा फारोहने अब्रामाला बोलाविले आणि म्हटले, “तू माझ्याशी हे काय केले आहेस? ती तुझी पत्नी आहे हे तू मला आधी का सांगितले नाहीस? ");
INSERT INTO marc_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‘ती माझी बहीण आहे,’ असे तू का सांगितलेस? म्हणूनच तिला माझी पत्नी करण्यास मी तयार झालो होतो. ही तुझी पत्नी घे आणि येथून निघून जा!” ");
INSERT INTO marc_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","आणि फारोहने आपल्या अधिकार्‍यांना आदेश देऊन अब्रामाची पत्नी, कुटुंबीय मंडळी व मालमत्ता यासह त्याची देशाबाहेर रवानगी केली. ");
INSERT INTO marc_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","अशा रीतीने अब्रामाने आपली पत्नी, सर्व संपत्ती आणि लोटाला घेऊन इजिप्त देश सोडला आणि ते नेगेव, म्हणजे दक्षिण, येथे पोहोचले. ");
INSERT INTO marc_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम जनावरांचे मोठे कळप, सोने व चांदी यांनी खूप श्रीमंत झाला होता. ");
INSERT INTO marc_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","नंतर ते नेगेवहून बेथेलच्या रोखाने उत्तरेकडे गेले. बेथेल व आय यांच्यामध्ये त्यांनी पूर्वी तळ दिला होता ");
INSERT INTO marc_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","व वेदी बांधली होती, तिथे पोहोचल्यावर अब्रामाने पुन्हा एकदा याहवेहची उपासना केली. ");
INSERT INTO marc_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","आता लोट, जो अब्रामासह फिरत होता, त्याच्याजवळही मेंढरे, गुरे आणि डेरे होते. ");
INSERT INTO marc_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","परंतु ते एकत्र राहत असताना ती जमीन त्यांना पुरेशी होऊ शकत नव्हती, कारण त्यांची संपत्ती इतकी मोठी होती की ते एकत्र राहू शकत नव्हते. ");
INSERT INTO marc_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","कनानी व परिज्जी हे लोक देखील तिथे राहत होते. अब्राम व लोट यांच्या गुराख्यामध्ये भांडणे होऊ लागली. ");
INSERT INTO marc_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","तेव्हा अब्राम लोटाला म्हणाला, “तुझ्यामध्ये व माझ्यामध्ये, किंवा माझे गुराखी व तुझे गुराखी यांच्यात भांडणे नसावी. कारण आपण जवळचे भाऊबंद आहोत. ");
INSERT INTO marc_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","तुझ्यापुढे संपूर्ण देश नाही काय? आपण विभक्त होऊ या. जर तू डावीकडे गेला तर मी उजवीकडे जाईन आणि जर तू उजवीकडे गेला तर मी डावीकडे जाईन.” ");
INSERT INTO marc_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","तेव्हा लोटाने आपली नजर सभोवार फिरविली आणि यार्देन नदीकडील सोअरकडे पाहिले की भरपूर पाणी असलेले, याहवेहच्या बागेसारखे आणि इजिप्त देशासारखे ठिकाण होते. (ही घटना याहवेहने सदोम आणि गमोराचा नाश करण्याआधीची आहे.) ");
INSERT INTO marc_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","मग लोटाने यार्देनेची सगळी तळवट निवडली आणि तो पूर्वेकडे निघाला. अशा रीतीने लोट व अब्राम विभक्त झाले. ");
INSERT INTO marc_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनान देशात राहिला आणि लोटाने यार्देनेच्या पूर्वतीरावरील तळवटीतील शहरांमध्ये मुक्काम करीत सदोम शहरापाशी तळ दिला. ");
INSERT INTO marc_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोम शहरातील लोक दुष्ट होते आणि याहवेहच्या विरुद्ध महापातक करणारे होते. ");
INSERT INTO marc_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","लोट अब्रामापासून विभक्त झाल्यानंतर याहवेह अब्रामाला म्हणाले, “तू जिथे आहेस तिथून उत्तर, नेगेव दक्षिण आणि पूर्व, पश्चिम अशी चहूकडे आपली नजर टाक. ");
INSERT INTO marc_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","जो सर्व देश तू पाहतोस तो मी तुला आणि तुझ्या वंशजांना देईन. ");
INSERT INTO marc_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","मी तुझी संतती पृथ्वीवरील धुळीच्या कणांइतकी करेन, जर कोणाला धुळीच्या कणांची गणती करता आली, तर तुझ्या संततीचीही गणना होईल. ");
INSERT INTO marc_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","आणि मी जो देश तुला देणार आहे, त्याच्या लांबी व रुंदीपर्यंत चालत जा.” ");
INSERT INTO marc_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","मग अब्रामाने हेब्रोनजवळ असलेल्या मम्रेच्या महान एलावृक्षाजवळ जाऊन तळ दिला आणि तिथे त्याने याहवेहसाठी एक वेदी बांधली. ");
INSERT INTO marc_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","त्या काळात जेव्हा शिनारचा राजा अम्राफेल, एल्लासाराचा राजा अर्योक, एलामाचा राजा केदोरलाओमेर व गोयीमाचा राजा तिदाल यांनी, ");
INSERT INTO marc_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","सदोमाचा राजा बेरा, गमोराचा राजा बिर्शा, अदमाहचा राजा शिनाब, सबोईमाचा राजा शमेबर आणि बेलाचा म्हणजे सोअराचा राजा यांच्याशी युद्ध केले. ");
INSERT INTO marc_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","दुसर्‍या गटाचे सर्व राजे सिद्दिमाच्या म्हणजे (मृत समुद्राच्या खोर्‍यात) एकत्र जमले. ");
INSERT INTO marc_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","बारा वर्षापर्यंत ते केदोरलाओमेर या राजाची सेवा करणारी प्रजा होते, परंतु तेराव्या वर्षी त्यांनी त्याच्याविरुद्ध बंड पुकारले. ");
INSERT INTO marc_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","चौदाव्या वर्षी, केदोरलाओमेर व त्याचे मित्रराजे यांनी अष्टरोथ-कर्णईम येथील रेफाईम लोकांचा व हाम येथील जूजीम लोकांच्या टोळीचा व शावेह किर्याथाईम येथे एमी लोकांचा पराभव केला ");
INSERT INTO marc_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","आणि होरी लोकांच्या टोळीला सेईर डोंगरात मार देऊन रानाच्या हद्दीवर असलेल्या एल-पारान येथपर्यंत पिटाळून लावले. ");
INSERT INTO marc_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","पुढे ज्याला कादेश असे नाव मिळाले, त्या एन मिशपात (अर्थात् कादेश) आणि अमालेकी लोकांचा, संपूर्ण प्रदेश व हससोन-तामार येथे राहणार्‍या अमोरी यांचाही त्यांनी पराभव केला. ");
INSERT INTO marc_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","पण आता सदोमाचा राजा, गमोराचा राजा, अदमाहचा राजा, सबोईमचा राजा आणि बेला म्हणजे सोअराचा राजा यांनी सिद्दीमच्या खोर्‍यात हल्ला करण्याची तयारी केली. ");
INSERT INTO marc_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ते एलामाचा राजा केदोरलाओमेर, गोयीमाचा राजा तिदाल, शिनाराचा राजा अम्राफेल आणि एल्लासाराचा राजा अर्योक यांच्याविरुद्ध लढले. ते पाच राजे विरुद्ध चार राजे असे लढले. ");
INSERT INTO marc_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीमच्या खोर्‍यात डांबराच्या अनेक खाणी होत्या. सदोम आणि गमोरा येथील राजांच्या सैन्याने पळ काढला, तेव्हा काहीजण त्या खाणीत पडले, पण बाकीचे सैन्य डोंगरावर पळून गेले. ");
INSERT INTO marc_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","चार राजांनी सदोम आणि गमोरा येथील मालमत्ता व अन्नसामुग्री लुटली आणि ते निघून गेले. ");
INSERT INTO marc_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","सदोम येथे राहणारा अब्रामाचा पुतण्या लोट यालाही त्याच्या मालकीच्या सर्व वस्तूंसह ते घेऊन गेले. ");
INSERT INTO marc_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","या लढाईत वाचलेला एक मनुष्य इब्री अब्रामाकडे पळून आला व त्याने ही बातमी त्याला सांगितली. त्यावेळी अब्राम, अमोरी मम्रे याच्या एला राईत तळ देऊन राहिला होता. अष्कोल व आनेर हे दोघे मम्रेचे भाऊ होते व त्यांनी अब्रामासोबत करार केला होता. ");
INSERT INTO marc_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","लोटाला कैद करून नेल्याचे अब्रामाला समजल्याबरोबर त्याने आपल्या कुटुंबात जन्मलेल्या तीनशेअठरा प्रशिक्षित पुरुषांना बरोबर घेतले आणि घरी परतणार्‍या विजयी सैन्याचा थेट दानपर्यंत पाठलाग केला. ");
INSERT INTO marc_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","रात्रीच्या वेळी अब्रामाने युद्ध करण्यासाठी आपले सैन्य विभागले आणि त्याने या सैन्यावर यशस्वी हल्ला केला आणि त्याच्यापुढून पळून जाणार्‍या सैन्याचा त्याने दिमिष्काच्या उत्तरेकडे असलेल्या होबाह या शहरापर्यंत पाठलाग केला. ");
INSERT INTO marc_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","त्याने सर्व मालमत्ता तसेच आपला पुतण्या लोट, याची मालमत्ता, स्त्रिया आणि कैद करून पळविलेले लोटचे इतर लोकही परत मिळविले. ");
INSERT INTO marc_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","केदोरलाओमेर व त्याचे मित्र असलेल्या इतर राजांचा पराभव करून अब्राम परत चालला असताना सदोमचा राजा शावेहच्या खोर्‍यात (या खोर्‍यास पुढे राजांचे खोरे असे नाव पडले) त्याला भेटावयास आला. ");
INSERT INTO marc_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","शालेमचा राजा मलकीसदेक जो परात्पर परमेश्वराचा याजक होता, तो अब्रामाला भाकर व द्राक्षारस घेऊन आला. ");
INSERT INTO marc_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","आणि त्याने अब्रामाला आशीर्वाद देऊन म्हटले, “आकाश व पृथ्वी यांचा निर्माणकर्ते परात्पर परमेश्वराद्वारे अब्राम आशीर्वादित असो. ");
INSERT INTO marc_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ज्या सर्वसमर्थ परमेश्वराने तुझे शत्रू तुझ्या हाती दिले ते परमेश्वर धन्यवादित असो.” मग अब्रामाने मलकीसदेकाला सर्वांचा दहावा भाग दिला. ");
INSERT INTO marc_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","सदोमच्या राजाने अब्रामाला म्हटले, “लोक मला द्या आणि मालमत्ता तुम्ही ठेवा.” ");
INSERT INTO marc_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","यावर अब्रामाने सदोमाच्या राजाला उत्तर दिले, “आकाश व पृथ्वी यांना निर्माण करणारा परात्पर याहवेह परमेश्वर यांना मी हात उंच करून वचन दिले आहे, ");
INSERT INTO marc_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","‘मी अब्रामाला श्रीमंत बनविले आहे,’ असे तुला कधीही म्हणता येऊ नये म्हणून मी तुझ्यापासून सुतळीचा एक दोरा किंवा जोड्याचा बंदही घेणार नाही. ");
INSERT INTO marc_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","माझ्या या तरुण माणसांनी जेवढे अन्न खाल्ले आहे तेवढ्यांचाच मी स्वीकार करेन, मात्र माझे मित्र आनेर, अष्कोल आणि मम्रे यांना त्यांचा वाटा मिळो.” ");
INSERT INTO marc_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","या गोष्टीं घडल्यानंतर अब्रामाला दृष्टान्तात याहवेहकडून हा संदेश मिळाला: “अब्रामा, भिऊ नको; मीच तुझी ढाल, तुझे अत्यंत महान प्रतिफळ आहे.” ");
INSERT INTO marc_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","यावर अब्राम म्हणाला, “हे सार्वभौम याहवेह, तुम्ही मला काय देऊ शकणार, मला पुत्र नसल्यामुळे माझ्या सर्व मालमत्तेचा वारस तर दिमिष्काचा एलिएजर होईल ना?” ");
INSERT INTO marc_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अब्रामाने असेही म्हटले, “तुम्ही मला पुत्र दिलेला नाही; म्हणून माझा सेवकच माझा वारस होईल.” ");
INSERT INTO marc_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तेव्हा त्याच्याकडे याहवेहचे वचन आले, “तुझ्या मालमत्तेचा वारसदार हा मनुष्य होणार नाही, परंतु तुझे मांस व तुझे रक्त असलेला तुझा पुत्र तुझा वारस होईल.” ");
INSERT INTO marc_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","मग त्यांनी त्याला बाहेर आणले आणि म्हटले, “वर आकाशात पाहा आणि तुला मोजता आले तर आकाशातील तारे मोज.” नंतर ते त्याला म्हणाले, “त्याचप्रमाणे तुझी संततीही होईल.” ");
INSERT INTO marc_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अब्रामाने याहवेहवर विश्वास ठेवला आणि ते त्याला नीतिमत्व असे गणण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","त्यांनी त्याला सांगितले, “मी याहवेह आहे. मी ही भूमी कायमची वतन करून देण्यासाठी तुला खास्द्यांच्या ऊर या शहरातून येथे आणले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","पण अब्रामाने विचारले, “सार्वभौम याहवेह, मला हे वतन मिळेल ते मी कसे समजू?” ");
INSERT INTO marc_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","मग याहवेह त्याला म्हणाले, “तू तीन वर्षांची एक कालवड, तीन वर्षांची एक शेळी, तीन वर्षांचा एक एडका, तसेच एक होला आणि पारव्याचे एक पिल्लू घेऊन ये.” ");
INSERT INTO marc_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","अब्रामाने हे सर्व आणले आणि त्या प्राण्यांचा वध करून ते त्याने मधोमध कापले; व त्यांचे दोन्ही भाग समोरासमोर ठेवले; पण पक्षी मात्र विभागले नाही. ");
INSERT INTO marc_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","त्या प्राण्यांच्या मृतशरीरांवर गिधाडांनी झडप घातली, तेव्हा अब्रामाने गिधाडांना हुसकावून लावले. ");
INSERT INTO marc_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","सूर्यास्ताच्या वेळी अब्रामाला गाढ निद्रा लागली आणि त्याच्यावर दाट आणि भयानक गडद अंधार पडला. ");
INSERT INTO marc_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","मग याहवेहने अब्रामाला म्हटले, “हे निश्चितपणे जाणून घे की, तुझे वंशज, जो देश त्यांचा स्वतःचा नाही अशा देशात परके गुलाम म्हणून राहतील व त्यांना चारशे वर्षे बंदिस्त करून अन्यायाने वागविले जाईल. ");
INSERT INTO marc_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","परंतु ज्या राष्ट्रात त्यांनी गुलाम म्हणून सेवा केली त्याला मी शिक्षा करेन. त्यानंतर तुझे वंशज त्या देशातून पुष्कळ धन घेऊन बाहेर पडतील. ");
INSERT INTO marc_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","पण तू चांगला म्हातारा होऊन मरण पावशील व शांतीने तुझ्या पूर्वजांबरोबर पुरला जाशील. ");
INSERT INTO marc_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","चार पिढ्यानंतर तुझे वंशज या भूमीत परत येतील, कारण अमोर्‍यांचा अपराध अजून पूर्ण झालेला नाही.” ");
INSERT INTO marc_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","नंतर सूर्य मावळला आणि अंधार पडला तेव्हा अब्रामाने त्या प्राण्यांच्या मृतशरीराच्या दोन ढिगांमधून धुमसते अग्निपात्र आणि पेटलेली मशाल जाताना पाहिली. ");
INSERT INTO marc_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","त्या दिवशी याहवेहने अब्रामाशी करार केला; त्यांनी म्हटले, “मी तुझ्या वंशजांना इजिप्त देशाच्या नदीपासून फरात नदीपर्यंतचा जो सर्व प्रदेश— ");
INSERT INTO marc_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","केनी, कनिज्जी, कदमोनी, ");
INSERT INTO marc_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हिथी, परिज्जी, रेफाईम, ");
INSERT INTO marc_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","अमोरी, कनानी, गिर्गाशी व यबूसी या लोकांचा देश देत आहे.” ");
INSERT INTO marc_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्रामाला साराय आपली पत्नी हिच्यापासून मूलबाळ नव्हते. पण सारायला हागार नावाची इजिप्तची एक दासी होती; ");
INSERT INTO marc_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","सारायने अब्रामाला म्हटले, “याहवेहने मला मूलबाळ दिले नाही, म्हणून तू माझ्या दासीचा स्वीकार कर; म्हणजे तिच्यापासून माझी मुले होतील.” आणि अब्रामाने तिचा शब्द मानला. ");
INSERT INTO marc_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","अब्राम कनान देशात राहून दहा वर्षे झाली होती. अब्रामाची पत्नी साराय हिने आपली इजिप्तची दासी हागार हिला अब्रामाची पत्नी होण्यासाठी त्याच्याकडे सोपविले. ");
INSERT INTO marc_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","तो हागारसोबत निजला आणि ती गर्भवती झाली. जेव्हा तिला आपण गर्भवती झाल्याचे लक्षात आले, तेव्हा ती तिच्या मालकिणीचा तिरस्कार करू लागली. ");
INSERT INTO marc_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","मग साराय अब्रामाला म्हणाली, “माझ्याशी होत असलेल्या अन्यायास तुम्ही जबाबदार आहात. वास्तविक, मी तिला तुमच्या हातात दिले आणि आता जेव्हा तिला कळले की ती गर्भवती आहे, ती मला तुच्छ मानू लागली आहे. याहवेह माझ्या व तुमच्यामध्ये न्याय करो.” ");
INSERT INTO marc_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","यावर अब्रामाने सारायला उत्तर दिले, “तुझ्या दासीवर तुझा पूर्ण अधिकार आहे. तुला जे योग्य वाटेल ते तिच्याशी कर.” तेव्हा सारायने हागारची छळणूक केली; आणि हागार तिच्यापासून पळून गेली. ");
INSERT INTO marc_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","शूर गावाच्या वाटेवर रानातील एका झर्‍याजवळ ती याहवेहच्या एका दूताला आढळली. ");
INSERT INTO marc_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","तो तिला म्हणाला, “अगे हागारे, सारायची दासी, तू कुठून आलीस आणि कुठे चाललीस?” हागारेने उत्तर दिले, “मी माझी मालकीण साराय हिच्यापासून पळून जात आहे.” ");
INSERT INTO marc_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","तेव्हा याहवेहचा दूत तिला म्हणाला, “तू तुझ्या मालकिणीकडे परत जा आणि तिच्या अधीनतेत राहा.” ");
INSERT INTO marc_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","दूत पुढे म्हणाला, “मी तुझा वंश इतका वाढवेन की त्यांची मोजणी करता येणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","याहवेहच्या दूताने तिला आणखी म्हटले, “आता तू गर्भवती आहेस आणि तुला एक पुत्र होईल. तू त्याचे नाव इश्माएल असे ठेव, कारण याहवेहने तुझे दुःख ऐकले आहे. ");
INSERT INTO marc_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","तो रानगाढवासारखा एक मनुष्य होईल; त्याचा हात प्रत्येकाच्या विरुद्ध असेल व प्रत्येकाचा हात त्याच्याविरुद्ध होईल; आणि तो आपल्या सर्व भाऊबंदांमध्ये शत्रुतापूर्ण वातावरणात वस्ती करून राहील.” ");
INSERT INTO marc_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","तिच्याशी बोलणार्‍या याहवेहला तिने हे नाव दिले: “मला पाहणारे परमेश्वर तुम्हीच आहात,” कारण ती म्हणाली, “जे मला पाहात आहेत, त्यांना मी आता पाहिले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","म्हणूनच त्या विहिरीला बएर-लहाई-रोई असे नाव पडले. जी कादेश व बेरेद यांच्या दरम्यान आहे. ");
INSERT INTO marc_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","मग अब्रामाला हागारेपासून एक पुत्र झाला आणि तिच्यापासून झालेल्या पुत्राचे नाव अब्रामाने इश्माएल असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","हागारेला अब्रामापासून इश्माएल झाला त्यावेळी अब्राम शहाऐंशी वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","अब्राम नव्याण्णव वर्षांचा झाला तेव्हा याहवेहने त्याला दर्शन देऊन म्हटले, “मी सर्वसमर्थ परमेश्वर आहे. माझ्यापुढे विश्वासयोग्य आणि निर्दोष राहा. ");
INSERT INTO marc_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","मग मी माझ्या व तुझ्यामध्ये एक करार करेन आणि तुला बहुगुणित करेन.” ");
INSERT INTO marc_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","अब्रामाने भूमीपर्यंत लवून नमस्कार केला आणि परमेश्वर त्याला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“मी तुझ्याशी हा करार करतो: तू अनेक राष्ट्रांचा पिता होशील. ");
INSERT INTO marc_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","आता येथून पुढे तुझे नाव अब्राम असे राहणार नाही, तर ते अब्राहाम असे होईल. कारण मी तुला अनेक राष्ट्रांचा पिता केले आहे. ");
INSERT INTO marc_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","मी तुला फलद्रूप करेन; मी तुझ्यापासून राष्ट्रे उदयास आणेल आणि तुझ्या संततीमधून राजे उत्पन्न होतील. ");
INSERT INTO marc_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","तुझ्या व तुझ्या येणार्‍या पिढीबरोबर मी असा शाश्वत करार स्थापित करेन की, तुझा व तुझ्यानंतर तुझ्या संतानांचा मी परमेश्वर होईन. ");
INSERT INTO marc_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ज्या देशात आज तू परका आहेस, तो संपूर्ण कनान देश मी तुला आणि तुझ्यानंतर तुझ्या वंशजांना कायमचे वतन म्हणून देईन; आणि मी त्यांचा परमेश्वर होईन.” ");
INSERT INTO marc_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","मग परमेश्वराने अब्राहामाला सांगितले, “माझ्याशी केलेल्या कराराचे तू आणि तुझ्या येणार्‍या वंशजांनी पिढ्यान् पिढ्या पर्यंत पालन करावे. ");
INSERT INTO marc_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","तू आणि तुझ्या वंशजांशी हा माझा करार म्हणजे: तुमच्यातील प्रत्येक पुरुषाची तुम्ही सुंता केली पाहिजे. ");
INSERT INTO marc_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ही सुंता, तुझ्या आणि माझ्यामध्ये केलेल्या कराराचे चिन्ह होईल. ");
INSERT INTO marc_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","पुत्र जन्मल्यानंतर आठव्या दिवशी त्याची सुंता केली पाहिजे. सुंतेची ही अट तू पैसे देऊन विकत घेतलेल्या परदेशीय गुलामांना आणि तुझ्या घराण्यात जन्मलेल्या प्रत्येकाला, जी तुझी संतती नाही त्यांनाही लागू आहे. ");
INSERT INTO marc_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","तुझ्या घराण्यात जन्मलेल्या किंवा तू पैसे देऊन विकत घेतलेल्या प्रत्येक पुरुषाची सुंता केली जावो. तुझ्या शरीराशी केलेला हा करार सदासर्वकाळचा आहे. ");
INSERT INTO marc_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","सुंता न केलेल्या प्रत्येक पुरुषाला त्या समाजातून बेदखल करण्यात येईल कारण त्याने माझा करार मोडला आहे.” ");
INSERT INTO marc_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","मग परमेश्वराने अब्राहामालाही म्हटले, “तुझी पत्नी साराय हिचे नाव आता साराय राहणार नाही, तर तिचे नाव साराह असे होईल. ");
INSERT INTO marc_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","मी तिला आशीर्वाद देईन आणि तिच्यापासून तुला निश्चितच एक पुत्र देईन. मी तिला आशीर्वादित करेन आणि तिला अनेक राष्ट्रांची माता करेन; तिच्यातून लोकांचे राजे उत्पन्न होतील.” ");
INSERT INTO marc_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","अब्राहामाने लवून नमस्कार केला; आणि तो हसला व स्वतःशी म्हणाला, “शंभर वर्षांच्या माणसालाही मुले होतील का? नव्वद वर्षांच्या साराहच्या पोटी बाळ जन्माला येऊ शकेल काय?” ");
INSERT INTO marc_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","तेव्हा अब्राहामाने परमेश्वराला म्हटले, “केवळ इश्माएल तुमच्या आशीर्वादाखाली राहिला तरी पुरे!” ");
INSERT INTO marc_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","परमेश्वराने उत्तर दिले, “होय, परंतु तुझी पत्नी साराह हिच्यापासून तुला एक पुत्र होईल आणि तू त्याचे नाव इसहाक असे ठेवावेस. मी त्याच्याबरोबर आणि त्याच्यानंतर त्याच्या वंशजांबरोबरही अनंतकाळचा करार स्थापित करेन. ");
INSERT INTO marc_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","इश्माएलाविषयी मी तुझी विनंती ऐकली आहे: मी त्याला निश्चितच आशीर्वाद देईन; त्याला फलद्रूप करेन व बहुगुणित करेन. तो बारा शासकांचा पिता होईल व मी त्याला एक महान राष्ट्र बनवेन. ");
INSERT INTO marc_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","पण माझा करार मी इसहाकाबरोबर स्थापित करेन. ज्याला पुढील वर्षी याच सुमारास साराह तुझ्यासाठी प्रसवेल.” ");
INSERT INTO marc_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","जेव्हा त्याने अब्राहामाशी बोलणे संपविले तेव्हा परमेश्वर अंतर्धान पावले. ");
INSERT INTO marc_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","त्याच दिवशी अब्राहामाने आपला पुत्र इश्माएल आणि आपल्या घरात जन्मलेले किंवा पैसे देऊन विकत घेतलेले सर्व पुरुष यांची परमेश्वराने सांगितल्याप्रमाणे सुंता केली. ");
INSERT INTO marc_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","अब्राहामाची सुंता झाली त्यावेळी तो नव्याण्णव वर्षांचा होता, ");
INSERT INTO marc_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","आणि त्याचा पुत्र इश्माएल तेरा वर्षांचा होता जेव्हा त्याची सुंता झाली. ");
INSERT INTO marc_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहाम व त्याचा पुत्र इश्माएल या दोघांचीही सुंता एकाच दिवशी झाली. ");
INSERT INTO marc_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","अब्राहामाच्या घरातील सर्व पुरुष, त्याच्या घरात जन्मलेले व पैसे देऊन परदेशी व्यक्तीकडून खरेदी केली गुलाम यांचीही त्याच्याबरोबर सुंता झाली. ");
INSERT INTO marc_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","अब्राहाम मम्रेच्या महान एलावृक्षाजवळ राहत असताना, मध्यान्हाच्या उन्हात आपल्या तंबूच्या दारापुढे बसला होता, तेव्हा याहवेहने त्याला दर्शन दिले. ");
INSERT INTO marc_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","अब्राहामाने आपली नजर वर करून पाहिले की तीन पुरुष जवळपास उभे आहेत, तो घाईने आपल्या तंबूच्या दाराकडून त्यांना भेटण्यास गेला व त्यांना भूमीपर्यंत लवून नमन केले. ");
INSERT INTO marc_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","तो त्यांना म्हणाला, “माझ्या स्वामी, माझ्यावर आपली कृपा झाली असल्यास, माझ्या घरी न येता पुढे जाऊ नका. ");
INSERT INTO marc_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","मी थोडे पाणी आणतो आणि तुम्ही आपले पाय धुऊन या झाडाखाली विसावा घ्या. ");
INSERT INTO marc_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","तुम्हाला ताजेपणा यावा म्हणून थोडे अन्नही आणतो मग तुम्ही पुढील प्रवासास निघा; तुम्ही तुमच्या या सेवकाकडे आला आहात.” “ठीक आहे. तू म्हणतोस त्याप्रमाणे कर.” त्यांनी उत्तर दिले. ");
INSERT INTO marc_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","मग अब्राहाम धावत आपल्या तंबूत येऊन साराहला म्हणाला, “लवकर तीन सिआ सपीठ घेऊन ते मळ आणि भाकरी कर.” ");
INSERT INTO marc_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","नंतर अब्राहाम आपल्या गुरांच्या कळपाकडे गेला, त्यातील एक कोवळे व उत्तम वासरू त्याने निवडले आणि ते लवकर बनवावे म्हणून एका नोकराकडे दिले. ");
INSERT INTO marc_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","मग त्याने दूध, दही आणि वासराचे मांस घेतले, जे त्याने बनविले होते आणि ते त्यांच्यासमोर ठेवले; आणि ते जेवत असता तो त्यांच्याजवळ झाडाखाली उभा राहिला. ");
INSERT INTO marc_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","त्यांनी विचारले, “तुझी पत्नी, साराह कुठे आहे?” अब्राहामाने उत्तर दिले, “ती तंबूत आहे.” ");
INSERT INTO marc_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","मग त्यापैकी एकजण म्हणाला, “पुढील वर्षी मी तुझ्याकडे निश्चित वेळेत परत येईन, तेव्हा तुझी पत्नी साराहला एक पुत्र होईल.” त्याच्यामागे, तंबूच्या दारातून साराह हे ऐकत होती. ");
INSERT INTO marc_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","आता अब्राहाम व साराह दोघेही खूप वृद्ध झाली होती. साराहला मुले होण्याचा काळ केव्हाच निघून गेला होता; ");
INSERT INTO marc_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","म्हणून साराह स्वतःशीच हसली व विचार करू लागली, “मी झिजून गेले आहे आणि माझा स्वामीही वृद्ध असताना, आता मला हा आनंद मिळेल काय?” ");
INSERT INTO marc_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","तेवढ्यात याहवेहने अब्राहामाला विचारले, “ ‘माझ्यासारख्या वृद्धेला खरेच मूल होईल काय?’ असे म्हणत साराह का हसली? ");
INSERT INTO marc_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","याहवेहला कोणतीही गोष्ट असाध्य आहे काय? मी सांगितल्याप्रमाणे पुढील वर्षी निश्चित वेळेत परत येईल आणि साराहला एक पुत्र होईल.” ");
INSERT INTO marc_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","साराह घाबरली, म्हणून ती खोटे बोलत म्हणाली, “मी हसले नाही.” परंतु ते म्हणाले, “होय, तू हसलीस.” ");
INSERT INTO marc_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","जेव्हा ते पुरुष पुढील प्रवासास जाण्यास उठले आणि त्यांनी खाली सदोमाच्या दिशेने पाहिले. अब्राहाम त्यांना निरोप देण्यासाठी त्यांच्याबरोबर थोडी वाट चालून गेला. ");
INSERT INTO marc_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","मग याहवेह म्हणाले, “अब्राहामापासून मी माझा संकल्प गुप्त ठेवावा काय? ");
INSERT INTO marc_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","कारण खात्रीने अब्राहाम एक महान व बलाढ्य राष्ट्र होईल आणि त्याच्याद्वारे पृथ्वीवरील सर्व राष्ट्रे आशीर्वादित होतील. ");
INSERT INTO marc_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","कारण मी त्याला निवडले आहे अशासाठी की त्याने त्याच्यानंतर त्याच्या लेकरांना व त्याच्या घराण्याला याहवेहच्या मार्गात जे योग्य व न्यायी आहे, त्यात चालवावे, त्यामुळे अब्राहामाला दिलेले अभिवचन याहवेह पूर्ण करतील.” ");
INSERT INTO marc_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","मग याहवेहने म्हटले, “सदोम आणि गमोरा विरुद्ध आक्रोश खूप वाढला आहे आणि त्यांचे पाप गंभीर आहे. ");
INSERT INTO marc_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","मी खाली जाऊन बघेन, मग त्यांनी जे केले आहे ते माझ्यापर्यंत पोहोचलेल्या आक्रोशाएवढे वाईट आहे की नाही हे मला समजेल.” ");
INSERT INTO marc_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","त्याच्याबरोबर असलेले पुरुष सदोमाच्या दिशेने गेले, पण अब्राहाम याहवेहपुढे उभा राहिला. ");
INSERT INTO marc_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","अब्राहाम त्यांच्याजवळ गेला आणि विचारले: “तुम्ही दुष्टांबरोबर नीतिमानांचा सुद्धा नाश करणार काय? ");
INSERT INTO marc_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","जर त्या शहरात पन्नास नीतिमान लोक आढळले तरी त्यांचा तुम्ही नाश करणार आणि त्यात असलेल्या नीतिमान लोकांसाठी तुम्ही त्यांची गय करणार नाही काय? ");
INSERT INTO marc_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ही गोष्ट तुमच्यापासून दूर असो—की तुम्ही दुष्टांच्या बरोबर नीतिमान लोकांनाही मारून टाकावे, नीतिमान आणि दुष्टांना सारखेच लेखावे हे तुमच्यापासून दूर असो! सर्व पृथ्वीचे न्यायाधीश, जे योग्य ते करणार नाहीत का?” ");
INSERT INTO marc_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","याहवेहने उत्तर दिले, “त्या सदोम शहरात मला जर पन्नास नीतिमान लोक आढळले, तर त्यांच्यासाठी मी त्या सर्व शहराची गय करेन.” ");
INSERT INTO marc_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","मग अब्राहाम पुन्हा म्हणाला, “मी धूळ आणि राख असून, मी प्रभूशी बोलण्याचे धैर्य केले आहे, ");
INSERT INTO marc_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","जर नीतिमानांची संख्या पाच कमी पन्नास असली तर काय? पाच लोक कमी आहेत म्हणून तुम्ही त्या संपूर्ण शहराचा नाश करणार काय?” याहवेहने उत्तर दिले “मला तिथे पंचेचाळीस भेटले, तरी मी त्याचा नाश करणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","अब्राहाम पुन्हा याहवेहला म्हणाला, “तिथे फक्त चाळीस असले तर काय?” याहवेहने उत्तर दिले, “त्या चाळिसांसाठी, मी नाश करणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","मग तो म्हणाला, “प्रभूला राग येऊ नये, पण मला बोलू द्यावे. फक्त तीसच मिळाले तर?” याहवेहने उत्तर दिले, “तिथे तीस सापडले, तरी मी नाश करणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","मग अब्राहाम म्हणाला, “मी प्रभूशी बोलण्याचे खूप धैर्य केले आहे, तिथे जर वीसच नीतिमान लोक असले तर?” त्यांनी म्हटले, “त्या विसांसाठी मी त्यांचा नाश करणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","मग तो म्हणाला, “प्रभूला राग न येवो, पण मला एकदाच बोलू द्यावे. तिथे फक्त दहाच सापडले तर?” याहवेहने उत्तर दिले, “त्या दहांच्यासाठी मी त्याचा नाश करणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","जेव्हा याहवेहने अब्राहामाशी आपले बोलणे संपविले, ते निघून गेले आणि अब्राहाम घरी परतला. ");
INSERT INTO marc_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","त्याच संध्याकाळी ते दोन दूत सदोमास पोहोचले. लोट नगराच्या वेशीत बसला होता. त्यांना पाहिल्याबरोबर त्यांना भेटण्यासाठी तो उठून उभा राहिला आणि आपले डोके भूमीकडे लववून त्याने दंडवत घातले. ");
INSERT INTO marc_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","लोट त्यांना म्हणाला, “स्वामींनो, कृपा करून आज रात्री तुम्ही आपल्या सेवकाच्या घरी या. आपण आपले पाय धुवावे आणि रात्री इथे मुक्काम करावा, मग पहाटे तुमच्या पुढील प्रवासास निघा.” ते म्हणाले, “नको, आम्ही चौकातच रात्र घालवू.” ");
INSERT INTO marc_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","पण लोटाने फारच आग्रह केल्यामुळे ते त्याच्याबरोबर त्याच्या घरात गेले. त्याने त्यांच्यासाठी बेखमीर भाकरीचे भोजन तयार केले, आणि ते जेवले. ");
INSERT INTO marc_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ते झोपण्याच्या आधी, सदोम शहराच्या प्रत्येक भागातील सर्व पुरुषांनी—तरुणांपासून वृद्धांपर्यंत—लोटाच्या घराला वेढा घातला. ");
INSERT INTO marc_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","लोटाला ते ओरडून म्हणाले, “जे पुरुष तुझ्याकडे आज रात्री आले ते कुठे आहेत? त्यांना आमच्याकडे बाहेर आण म्हणजे आम्ही त्यांच्याशी समागम करू.” ");
INSERT INTO marc_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","लोट त्यांच्याबरोबर बोलण्यास बाहेर गेला आणि आपल्यामागे दार लावून घेतले. ");
INSERT INTO marc_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“आणि म्हणाला, नाही माझ्या मित्रांनो, असे भयंकर दुष्कर्म करू नका. ");
INSERT INTO marc_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","पाहा, मला दोन कन्या आहेत ज्या अजून कुमारिका आहेत. त्यांना मी तुमच्या स्वाधीन करतो; त्यांच्याशी तुम्हाला पाहिजे तसे वागा, पण या दोन माणसांच्या वाटेला जाऊ नका, कारण ते माझ्या आश्रयाला आले आहेत.” ");
INSERT INTO marc_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“आमच्या मार्गातून दूर जा,” ते म्हणाले. “हा मनुष्य इथे परदेशी म्हणून आला होता आणि आता त्याला न्यायाधीशाची भूमिका करावयाची आहे! आम्ही तुम्हाला त्याच्यापेक्षा वाईट वागवू.” ते लोटावर दबाव टाकत राहिले आणि दार तोडण्यासाठी पुढे गेले. ");
INSERT INTO marc_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","पण आतील त्या पुरुषांनी लोटाला घरात ओढून घेतले आणि दार बंद केले. ");
INSERT INTO marc_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","मग तरुण आणि वृद्ध पुरुष जे घराच्या दरवाजात होते, त्यांना त्यांनी अंधत्वाचा असा फटका दिला की त्यांना दरवाजा सापडेना. ");
INSERT INTO marc_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ते दोन पुरुष लोटाला म्हणाले, “या ठिकाणी तुझे जावई, मुले किंवा मुली किंवा अजून कोणी या शहरात जे तुझे आपले असे आहे काय? त्यांना येथून बाहेर काढ, ");
INSERT INTO marc_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","कारण आम्ही या शहराचा नाश करणार आहोत. याहवेहपर्यंत या लोकांविरुद्ध आलेला आक्रोश इतका मोठा आहे की त्यांनी आम्हाला त्याचा नाश करण्यासाठी पाठविले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","तेव्हा लोट आपल्या जावयांकडे गेला, जे त्याच्या मुलींशी विवाह करण्यास वचनबद्ध होते. तो म्हणाला, “घाई करा आणि या ठिकाणातून बाहेर चला, कारण याहवेह या शहराचा नाश करणार आहेत!” पण त्याच्या जावयांना वाटले की, तो विनोद करीत आहे. ");
INSERT INTO marc_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","पहाट होताच, दूत लोटाला आग्रह करीत म्हणाले, “त्वरा कर! तुझी पत्नी व तुझ्या दोन कन्या ज्या इथे आहेत त्यांना घेऊन नीघ, नाहीतर या नगराचा नाश होत असताना तुझाही नाश होईल.” ");
INSERT INTO marc_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","पण लोट आढेवेढे घेऊ लागला, तेव्हा दूतांनी त्याचा, त्याच्या पत्नीचा आणि त्याच्या दोन्ही कन्यांचे हात धरून त्यांना नगराबाहेर एका सुरक्षित ठिकाणी आणून सोडले, कारण त्या कुटुंबावर याहवेहची कृपा होती. ");
INSERT INTO marc_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","दूतांनी त्यांना ताकीद दिली, “आता जीव घेऊन पळा! पाठीमागे अजिबात वळून पाहू नका, सपाट भूमीवर रेंगाळत राहू नका! थेट डोंगरावर जा, नाहीतर तुम्हीही त्याच्या आवाक्यात याल!” ");
INSERT INTO marc_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","यावर लोट विनवणी करीत म्हणाला, “स्वामींनो, कृपा करून असे करू नका! ");
INSERT INTO marc_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","तुम्ही तुमच्या सेवकाशी इतके दयाळूपणाने वागला आहात व तुम्ही माझा जीव वाचविला आहे. परंतु मला डोंगरावर पाठवू नका; तिथे कदाचित माझ्यावर काही अरिष्ट येईल आणि मी मरेन. ");
INSERT INTO marc_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","पाहा, तिथे जवळच एक गाव आहे आणि ते लहानही आहे. तिथे पळून जाण्याची परवानगी द्या—हे अगदी लहानसे आहे, नाही का? म्हणजे माझा जीव वाचेल.” ");
INSERT INTO marc_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","तो त्याला म्हणाला, “ठीक आहे, मी तुझी विनंती मान्य करतो; तू म्हणतोस त्या गावाचा मी नाश करणार नाही. ");
INSERT INTO marc_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","पण त्वरा कर आणि तिथे जा, कारण तू तिथे पोहोचेपर्यंत मला काहीच हालचाल करता येत नाही.” (त्या वेळेपासून त्या गावाचे नाव सोअर नगरी असे पडले.) ");
INSERT INTO marc_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","सूर्योदयाच्या सुमारास लोट सोअर गावात जाऊन पोहोचला. ");
INSERT INTO marc_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","मग याहवेहने सदोम आणि गमोरा या नगरांवर स्वर्गातून—याहवेहकडूनच—ज्वलंत गंधकाचा वर्षाव केला; ");
INSERT INTO marc_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","आणि त्या दोन नगरांबरोबर आसपासची इतर गावे, तसेच सर्व वनस्पतीचा संपूर्ण नाश केला. ");
INSERT INTO marc_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","परंतु लोटाच्या पत्नीने मागे वळून पाहिले, ती मिठाचा खांब झाली. ");
INSERT INTO marc_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","दुसर्‍या दिवशी अब्राहाम पहाटेच उठला आणि ज्या ठिकाणी तो याहवेहसमोर उभा राहिला होता त्या ठिकाणी आला. ");
INSERT INTO marc_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","त्याने मैदानापलीकडे असलेल्या सदोम आणि गमोरा याकडे नजर टाकली, भट्टीतून निघाल्यासारखे धुरांचे लोटच्या लोट त्या नगरातून उसळून वर येत आहेत, असे त्याला दिसले. ");
INSERT INTO marc_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","मग जेव्हा परमेश्वराने त्या नगरांचा नाश केला, त्यांना अब्राहामाची आठवण आली आणि त्यांनी ज्या नगरास मृत्यूने विळखा घातला होता त्या लोट राहात असलेल्या नगरातून त्याला सोडविले. ");
INSERT INTO marc_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","पुढे लोटाने सोअरमधील लोकांच्या भीतीमुळे ते गाव सोडले व तो आपल्या दोन मुलींना घेऊन डोंगरातील एक गुहेमध्ये जाऊन राहिला. ");
INSERT INTO marc_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","एके दिवशी थोरली मुलगी धाकट्या बहिणीला म्हणाली, “आपले वडील म्हातारे झाले आहेत आणि आजूबाजूला एकही पुरुष नाही की जो आपल्याला मूल देईल—जशी पृथ्वीवरील प्रथा आहे. ");
INSERT INTO marc_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","तेव्हा चल, आपण त्यांना खूप द्राक्षमद्य पाजू आणि मग त्यांच्याबरोबर शय्या करू म्हणजे आपला वंश आपल्या वडिलांद्वारे कायम राहील.” ");
INSERT INTO marc_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","त्या रात्री त्यांनी लोटाला भरपूर मद्य पाजले. मग थोरली आत गेली आणि तिने आपल्या वडिलांबरोबर शय्या केली; ती केव्हा निजली व केव्हा उठली याचे त्याला भानच नव्हते! ");
INSERT INTO marc_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","दुसर्‍या दिवशी सकाळी थोरली मुलगी आपल्या धाकट्या बहिणीस म्हणाली, “काल रात्री मी आपल्या वडिलांबरोबर शय्या केली, आज रात्रीही आपण त्यांना भरपूर मद्य पाजू आणि मग तू त्यांच्याशी शय्या कर म्हणजे अशा रीतीने आपला वंश आपल्या वडिलांद्वारे पुढे चालेल.” ");
INSERT INTO marc_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","त्याप्रमाणे त्या रात्री त्यांनी आपल्या वडिलांना पुन्हा भरपूर मद्य पाजले. मग धाकटी मुलगी आत गेली आणि त्याच्यासोबत शय्या केली. ती केव्हा निजली व केव्हा उठली याचे त्याला भानच नव्हते! ");
INSERT INTO marc_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","अशा रीतीने लोटाच्या दोन्ही मुली आपल्या वडिलांपासून गर्भवती झाल्या. ");
INSERT INTO marc_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","थोरल्या मुलीला पुत्र झाला, तिने त्याचे नाव मोआब असे ठेवले व तो मोआबी राष्ट्राचा मूळ पुरुष झाला. ");
INSERT INTO marc_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","धाकट्या मुलीलासुद्धा पुत्र झाला आणि तिने त्याचे नाव बेनअम्मी असे ठेवले, तो अम्मोनी राष्ट्राचा मूळ पुरुष झाला. ");
INSERT INTO marc_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","आता अब्राहाम तिथून दक्षिणेस नेगेव प्रांताकडे गेला आणि त्याने कादेश आणि शूर यांच्या दरम्यान वस्ती केली. काही काळासाठी तो गरार नगरात राहिला, ");
INSERT INTO marc_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","साराह आपली बहीण असल्याचे अब्राहामाने सांगितले, तेव्हा गरारचा राजा अबीमेलेख याने माणसे पाठवून सारेला आपल्याकडे आणले. ");
INSERT INTO marc_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","पण एका रात्री परमेश्वर स्वप्नात अबीमेलेखकडे आले आणि त्याला म्हणाले, “आता तुझा अंत झाल्यासारखाच आहे, कारण जी स्त्री तू आणली आहेस, ती विवाहित आहे.” ");
INSERT INTO marc_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","पण अबीमेलेखाने तिला अद्याप स्पर्श केला नव्हता, म्हणून तो म्हणाला, “प्रभू, तुम्ही एक निरपराधी राष्ट्राचा अंत कराल काय? ");
INSERT INTO marc_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","खुद्द अब्राहामानेच मला सांगितले नव्हते का की ती माझी बहीण आहे? आणि तिनेही सांगितले नव्हते का तो माझा भाऊ आहे? मी हे शुद्ध हृदयाने आणि शुद्ध हातांनी केले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","परमेश्वराने त्याला स्वप्नात म्हणाले, “होय, ते मला माहीत आहे; ते तू शुद्ध हृदयाने केले आहे आणि म्हणूनच मी तुला पाप करण्यापासून रोखून धरले आणि तिला स्पर्शही करू दिला नाही. ");
INSERT INTO marc_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","आता तू तिला आपल्या पतीकडे परत पाठवून दे. तिचा पती माझा संदेष्टा आहे. तो तुझ्यासाठी प्रार्थना करेल, म्हणजे तू जिवंत राहशील; पण जर तू तिला परत पाठविले नाहीस, तर तू आणि तुझे सर्व लोक खात्रीने मरतील.” ");
INSERT INTO marc_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","दुसर्‍या दिवशी सकाळीच अबीमेलेखाने आपल्या सर्व अधिकार्‍यांना बोलाविले आणि काय घडले हे त्याने सांगितले, तेव्हा सर्व लोक फार घाबरले. ");
INSERT INTO marc_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","मग अबीमेलेखाने अब्राहामास बोलावून विचारणा केली, “हे तू आमच्याशी काय केलेस? मी असे काय अपराध केले की, मला तुझ्याकडून अशी वागणूक मिळावी आणि त्यामुळे माझ्यावर आणि माझ्या राज्यावर घोर पातक आणले? जे कृत्य कधीही करू नये ते तू माझ्याशी केले आहेस.” ");
INSERT INTO marc_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","मग अबीमेलेखाने अब्राहामास विचारले, “तू हे असे करण्याचे काय कारण आहे?” ");
INSERT INTO marc_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहाम म्हणाला, “मी मनात विचार केला, ‘या शहरात कोणीही परमेश्वराला भीत नाही आणि माझ्या पत्नीमुळे ते माझा वध करतील.’ ");
INSERT INTO marc_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","असे असूनही, ती माझी बहीण आहे, माझ्या वडिलांची मुलगी आहे, परंतु माझ्या आईची मुलगी नाही; आणि ती माझी पत्नी झाली. ");
INSERT INTO marc_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","परमेश्वराने माझ्या वडिलांचे घर सोडून मला प्रवासास पाठविले, तेव्हा मी तिला म्हटले की, ‘जिथेही आपण जाऊ तिथे मी तुझा भाऊ आहे असे सांगून तू माझ्यावरील तुझी प्रीती मला दाखव.’ ” ");
INSERT INTO marc_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","मग अबीमेलेखाने अब्राहामाला मेंढरे, बैल आणि स्त्री व पुरुष गुलाम दिले आणि त्याची पत्नी साराहदेखील त्याला परत केली. ");
INSERT INTO marc_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","आणि अबीमेलेख म्हणाला, “माझा देश तुमच्यासमोर आहे. तुम्हाला आवडेल तिथे राहा.” ");
INSERT INTO marc_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","मग साराहला तो म्हणाला, “तुझ्या भावाला मी चांदीचे एक हजार शेकेल देत आहे. मी तुझ्यावर केलेल्या गुन्ह्याबद्दल तुझ्याबरोबरच्या लोकांसमोर ही भरपाई आहे; तू पूर्णपणे निर्दोष आहे.” ");
INSERT INTO marc_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","यानंतर अब्राहामाने परमेश्वराजवळ प्रार्थना केली आणि परमेश्वराने अबीमेलेख राजा, राणी व त्याच्या दासी यांना आरोग्य दिले आणि त्यांना परत मुले होऊ लागली. ");
INSERT INTO marc_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","कारण अब्राहामाची पत्नी साराह हिच्यामुळे याहवेहनी अबीमेलेखाच्या घराण्यातील सर्व स्त्रियांची गर्भधारणा बंद केली होती. ");
INSERT INTO marc_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","यानंतर याहवेहने आपल्या म्हणण्याप्रमाणे साराहवर अनुग्रह केला आणि तिला दिलेले वचन पूर्ण केले. ");
INSERT INTO marc_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","साराह गर्भवती झाली आणि परमेश्वराने नियुक्त केलेल्या वेळी अब्राहामाला त्याच्या वृद्धापकाळात तिच्यापासून एक पुत्र झाला. ");
INSERT INTO marc_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहामाने साराहपासून जन्मलेल्या पुत्राचे नाव इसहाक असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","इसहाक जन्मल्यानंतर आठ दिवसांनी, परमेश्वराच्या आज्ञेप्रमाणे, अब्राहामाने त्याची सुंता केली. ");
INSERT INTO marc_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","जेव्हा इसहाकाचा जन्म झाला, त्यावेळी अब्राहाम शंभर वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","साराह म्हणाली, “परमेश्वराने मला हसविले आहे आणि जे याबद्दल ऐकतील, ते माझ्याबरोबर आनंद करतील.” ");
INSERT INTO marc_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","आणि ती अजून म्हणाली, “अब्राहामाला कोणी सांगितले असते काय की साराह तिच्या बाळाला स्तनपान करेल? तरीही मी अब्राहामाला त्याच्या म्हातारपणी एक अपत्य दिले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ते बाळ वाढू लागले आणि ज्या दिवशी इसहाकाचे दूध तोडण्यात आले, त्या दिवशी अब्राहामाने एक मोठी मेजवानी दिली. ");
INSERT INTO marc_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","परंतु अब्राहामाला इजिप्त देशाची स्त्री हागार, हिच्यापासून झालेला पुत्र, इसहाकाला चिडवीत असताना साराहने पाहिले. ");
INSERT INTO marc_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","तेव्हा ती अब्राहामाला म्हणाली, “दासी व तिचा पुत्र यांना घालवून द्या; कारण त्या स्त्रीचा पुत्र कधीही माझा पुत्र इसहाक याच्याबरोबर वारसा वाटून घेणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ही बाब अब्राहामाला खूप त्रास देत होती कारण ती त्याच्या मुलाची होती. ");
INSERT INTO marc_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","तरी परमेश्वराने अब्राहामाला सांगितले, “तुझी स्त्री गुलाम आणि तिचा पुत्र यांच्यामुळे तू मनस्ताप करून घेऊ नकोस. साराहच्या म्हणण्याप्रमाणे कर, कारण इसहाकाद्वारेच तुझी संतती वाढेल. ");
INSERT INTO marc_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","त्या दासीपुत्रापासूनही मी एक राष्ट्र निर्माण करेन, कारण तोही तुझा पुत्र आहे.” ");
INSERT INTO marc_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","दुसर्‍या दिवशी अब्राहाम सकाळीच उठला, त्याने प्रवासासाठी भोजन आणि पाण्याची कातडी पिशवी हागारेला दिली. ती तिच्या खांद्यावर अडकवून मुलासह तिची रवानगी केली. ती तिथून निघाली व बेअर-शेबाच्या अरण्यात भटकू लागली. ");
INSERT INTO marc_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","जवळचे पाणी संपल्यावर तिने आपल्या पुत्राला एका झुडूपाखाली ठेवले, ");
INSERT INTO marc_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","आणि ती त्याच्यापासून सुमारे बाणाच्या टप्प्याइतकी दूर जाऊन बसली, “माझ्या बाळाचा मृत्यू मला पाहावयाला नको आहे,” असे म्हणून ती हुंदके देऊन रडू लागली. ");
INSERT INTO marc_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","मग परमेश्वराने त्या मुलाच्या रडणे ऐकले आणि परमेश्वराचा दूत आकाशातून हागारेला हाक मारून म्हणाला, “हागारे, तुला काय झाले आहे? भिऊ नकोस; कारण परमेश्वराने मुलाचे रडणे ऐकले आहे. ");
INSERT INTO marc_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ऊठ, त्याला उचलून घे, कारण मी त्याच्यापासून एक मोठे राष्ट्र निर्माण करेन.” ");
INSERT INTO marc_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","मग परमेश्वराने तिचे डोळे उघडले आणि तिला एक पाण्याची विहीर दिसली. तेव्हा तिने आपली पाण्याची मसक भरून घेतली आणि त्या मुलाला पाणी पाजले. ");
INSERT INTO marc_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","परमेश्वर त्या मुलासोबत होते. तो पारानच्या रानात लहानाचा मोठा होऊन एक तरबेज तिरंदाज झाला; ");
INSERT INTO marc_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","पुढे तो पारानच्या रानात राहत असताना त्याच्या आईने त्याचा इजिप्त देशातील एका मुलीसह विवाह करून दिला. ");
INSERT INTO marc_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","याच सुमारास अबीमेलेख राजा व त्याचा सेनापती पीकोल. हे अब्राहामाकडे आले, ते त्याला म्हणाले, “तू जे काही करतोस त्यात परमेश्वर तुला साहाय्य करतात. ");
INSERT INTO marc_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","तर परमेश्वराच्या नावाने तू मला असे वचन दे की, तू माझ्याशी, माझ्या मुलांशी किंवा वंशजांशी कपटनीतीने वागणार नाहीस. ज्याप्रमाणे मी तुझ्याशी मित्रत्वाने वागलो आहे, त्याप्रमाणेच तूही माझ्या देशाशी मित्रत्वानेच वागशील.” ");
INSERT INTO marc_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहाम म्हणाला, “ठीक आहे, मी तुला शपथ देतो.” ");
INSERT INTO marc_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","“पण तुझ्या सेवकांनी माझ्या नोकरांपासून जबरदस्तीने एक विहीर हिरावून घेतली आहे त्याचे काय?” अब्राहामाने अबीमेलेखकडे तक्रार केली. ");
INSERT INTO marc_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","“हे तर मी पहिल्यांदाच ऐकत आहे,” अबीमेलेख राजाने उद्गार काढले, “आणि याला कोण जबाबदार आहे याची मला काहीच कल्पना नाही. हे तू मला आधी का सांगितले नाहीस?” ");
INSERT INTO marc_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","मग अब्राहामाने मेंढरे आणि बैल घेतले आणि अबीमेलेखाला दिले आणि त्या दोघांनी करार केला. ");
INSERT INTO marc_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","पण अब्राहामाने सात मेंढ्या बाजूला काढून ठेवल्या, ");
INSERT INTO marc_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","तेव्हा अबीमेलेखाने अब्राहामाला विचारले, “तू असे का करीत आहेस? त्या मेंढ्या बाजूला का काढीत आहेस?” ");
INSERT INTO marc_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","यावर अब्राहामाने उत्तर दिले, “ही विहीर मीच खोदली आहे, याचे जाहीर प्रमाण म्हणून या मेंढ्या मी तुला देणगीदाखल देत आहे.” ");
INSERT INTO marc_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","म्हणून त्या वेळेपासून त्या विहिरीचे नाव बेअर-शेबा पडले. कारण दोघांनी त्याच ठिकाणी शपथ घेऊन करार केला होता. ");
INSERT INTO marc_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","बेअर-शेबा येथे करार केल्यानंतर अबीमेलेख आणि त्याचा सेनापती पीकोल पलिष्ट्यांच्या देशात परतले. ");
INSERT INTO marc_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहामाने बेअर-शेबा येथे टमरिस्क म्हणजे एशेल नावाचे झाड लावले आणि सनातन परमेश्वर याहवेहची आराधना केली. ");
INSERT INTO marc_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","आणि अब्राहाम पलिष्ट्यांच्या देशात दीर्घकाल राहिला. ");
INSERT INTO marc_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","काही वेळेनंतर परमेश्वराने अब्राहामाची परीक्षा घेतली. परमेश्वराने त्यास म्हटले, “अब्राहामा!” “हा, मी इथे आहे,” तो उत्तरला. ");
INSERT INTO marc_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","मग परमेश्वर म्हणाले, “तुझा पुत्र, ज्याच्यावर तू प्रीती करतोस तो तुझा एकुलता एक पुत्र इसहाकाला बरोबर घे आणि मोरिया प्रदेशात जा आणि त्या ठिकाणी मी तुला जो डोंगर दाखवेन त्या डोंगरावर त्याचे होमार्पण कर.” ");
INSERT INTO marc_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","अब्राहामाने दुसर्‍या दिवशी पहाटेस उठून गाढवावर खोगीर लादले आणि आपला पुत्र इसहाक व दोन सेवकांना व होमार्पणासाठी पुरेशी लाकडे बरोबर घेऊन तो परमेश्वराने सांगितलेल्या ठिकाणी जावयास निघाला. ");
INSERT INTO marc_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तिसर्‍या दिवशी अब्राहामाने आपली दृष्टी वर करून ते ठिकाण दुरून पाहिले. ");
INSERT INTO marc_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","तेव्हा अब्राहाम सेवकांना म्हणाला, “तुम्ही येथे गाढवाजवळ थांबा, मी आणि माझा पुत्र पलीकडे जातो. परमेश्वराची उपासना करून तुमच्याकडे परत येतो.” ");
INSERT INTO marc_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","अब्राहामाने होमार्पणासाठी घेतलेले लाकूड इसहाकाच्या खांद्यावर ठेवले आणि स्वतः सुरा व विस्तव घेतला. जसे ते चालत पुढे गेले, ");
INSERT INTO marc_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाकाने अब्राहामाला विचारले, “बाबा?” “काय माझ्या मुला?” अब्राहामाने उत्तर दिले. “आपण लाकडे व विस्तव घेतले,” इसहाक म्हणाला, “पण होमार्पणासाठी कोकरू कुठे आहे?” ");
INSERT INTO marc_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहामाने उत्तर दिले, “परमेश्वर होमार्पणासाठी कोकरू पुरवतील, माझ्या मुला.” आणि ते दोघे एकत्र पुढे गेले. ");
INSERT INTO marc_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","परमेश्वराने ज्या ठिकाणी जाण्यास सांगितले होते त्या जागी आल्यावर अब्राहामाने एक वेदी बांधली आणि त्यावर त्याने लाकडे रचून ठेवली. त्याने आपला पुत्र इसहाकाला बांधले आणि वेदीवरील लाकडांवर ठेवले; ");
INSERT INTO marc_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","मग अब्राहामाने आपल्या मुलाचा बळी देण्याकरिता आपल्या हातातील सुरा उंचाविला. ");
INSERT INTO marc_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","त्याच क्षणाला याहवेहचा दूत स्वर्गातून ओरडून म्हणाला, “अब्राहामा, अब्राहामा!” “हा मी इथे आहे,” तो उत्तरला. ");
INSERT INTO marc_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“मुलावर आपला हात उगारू नको.” तो म्हणाला, “त्याला काहीही करू नकोस. तुला परमेश्वराचे भय आहे हे मला समजले आहे, कारण तुझा पुत्र, एकुलता एक पुत्र मला अर्पिण्याचे तू नाकारले नाहीस.” ");
INSERT INTO marc_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","अब्राहामाची नजर झुडूपात शिंगे अडकलेल्या एका एडक्याकडे गेली. त्याने तो एडका धरला आणि आपल्या पुत्राच्या जागी त्याने त्या एडक्याचा होमार्पण म्हणून बळी दिला. ");
INSERT INTO marc_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","म्हणून अब्राहामाने त्या जागेचे नाव “याहवेह यिरेह” आजपर्यंत “याहवेहच्या डोंगरावर पुरवठा केला जाईल,” असे बोलले जाते. ");
INSERT INTO marc_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","नंतर याहवेहच्या दूताने अब्राहामाला स्वर्गातून दुसर्‍यांदा हाक मारली. ");
INSERT INTO marc_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ते म्हणाले, “मी याहवेह, स्वतःचीच शपथ घेऊन तुला सांगतो की, कारण तू हे केलेस आणि स्वतःच्या पुत्राला, एकुलत्या एक पुत्राला अर्पण करण्यास तू नाकारले नाहीस, ");
INSERT INTO marc_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","म्हणून मी तुला निश्चितच आशीर्वादित करेन आणि वृद्धिंगत करून तुझी संतती आकाशातील तार्‍यांइतकी आणि समुद्रतीरावरील वाळू इतकी करेन. तुझी संतती आपल्या सर्व शत्रूंची शहरे हस्तगत करेल, ");
INSERT INTO marc_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","आणि तू माझ्या आज्ञा पाळल्या आहेस, म्हणून पृथ्वीवरील सर्व राष्ट्रे तुझ्या वंशजापासून आशीर्वादित होतील.” ");
INSERT INTO marc_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","यानंतर अब्राहाम आपल्या सेवकांकडे परत आला आणि ते सर्वजण बेअर-शेबा येथे आपल्या घरी परतले आणि अब्राहाम बेअर-शेबा येथे राहिला. ");
INSERT INTO marc_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","काही वेळेनंतर अब्राहामाला सांगण्यात आले, “त्याचा भाऊ नाहोर याची पत्नी मिल्का हिलाही मुले झाली आहेत: ");
INSERT INTO marc_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ऊस हा त्याचा प्रथमपुत्र, त्याचा भाऊ बूज व कमुवेल (अरामचा पिता) ");
INSERT INTO marc_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","आणि केसद, हजो, पिलदाश, यिदलाप व बेथुएल.” ");
INSERT INTO marc_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बेथुएल रिबेकाहचा पिता झाला. ");
INSERT INTO marc_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नाहोराची उपपत्नी रेऊमा हिलाही पुत्र झाले: तेबाह, गहाम, तहश व माकाह. ");
INSERT INTO marc_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","साराह एकशे सत्तावीस वर्षे जगली. ");
INSERT INTO marc_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","साराह ही कनान देशातील किर्याथ-अर्बा (म्हणजे हेब्रोन) येथे मरण पावली. अब्राहाम तिच्यासाठी शोक व विलाप करण्यास गेला. ");
INSERT INTO marc_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","आणि साराहच्या मृतदेहाजवळ उभे राहून अब्राहाम हेथीच्या लोकांना म्हणाला, ");
INSERT INTO marc_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“या देशात मी एक परकीय व अनोळखी आहे. कृपया मला माझ्या मृतास पुरण्याकरिता जमिनीचा एक भाग विकत द्या.” ");
INSERT INTO marc_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हेथी लोकांनी अब्राहामाला उत्तर दिले, ");
INSERT INTO marc_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“महाराज, आमचे ऐका. आमच्यामध्ये आपण एक पराक्रमी राजपुत्र आहात. तुम्ही आपल्या मृतांसाठी स्वतःच कबर निवडून त्यांना मूठमाती द्या. आपली खाजगी कबर तुम्हाला देण्यास आमच्यातील कोणीही नकार देणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","हे ऐकून अब्राहामाने त्या हेथी लोकांसमोर लवून मुजरा केला आणि तो म्हणाला, ");
INSERT INTO marc_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“मी आपल्या मयतास पुरावे अशी तुमची इच्छा असेल तर माझे ऐका, जोहराचा पुत्र एफ्रोन, ");
INSERT INTO marc_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","याला त्याच्या शेताच्या टोकाला असलेली मकपेला नावाची गुहा मला विकत देण्यास माझ्यावतीने विनंती करा. तिची पूर्ण किंमत मी देईन आणि ती माझ्या कुटुंबीयांसाठी स्मशानभूमी होईल.” ");
INSERT INTO marc_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एफ्रोन हेथी हा हेथी लोकांसह बसलेला होता, त्या नगरचौकात असलेल्या सर्व हेथी लोकांसमक्ष तो अब्राहामाला म्हणाला, ");
INSERT INTO marc_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“नाही, महाराज, माझे ऐका; ती गुहा आणि ते शेत मी तुम्हाला देईन, माझ्या लोकांच्या देखत मी तुम्हाला ती देत आहे. तिथे तुम्ही तुमच्या मृतास मूठमाती द्या.” ");
INSERT INTO marc_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","अब्राहामाने त्या देशातील लोकांना पुन्हा लवून मुजरा केला ");
INSERT INTO marc_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","आणि त्या देशाच्या लोकांसमक्ष तो एफ्रोनास म्हणाला, “माझे ऐका, मला ती जागा तुझ्याकडून विकत घेऊ दे; त्या शेताची सर्व किंमत मी तुला देईन. मग मी माझ्या मृताला तिथे मूठमाती देईन.” ");
INSERT INTO marc_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","हे ऐकून एफ्रोन अब्राहामाला म्हणाला, ");
INSERT INTO marc_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“महाराज, त्या जागेची किंमत केवळ चांदीची चारशे शेकेल आहे; पण तुमच्या आणि माझ्यामध्ये त्याचे काय? तिथे आपल्या मृताला मूठमाती द्या.” ");
INSERT INTO marc_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","तेव्हा अब्राहामाने कबूल केल्याप्रमाणे एफ्रोनाने हेथी लोकांच्या समक्ष सांगितलेली किंमत, म्हणजे चारशे शेकेल चांदी, त्या काळातील व्यापार्‍यांच्या परिमाणानुसार अब्राहामाने त्याला दिली. ");
INSERT INTO marc_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","अशाप्रकारे मम्रेजवळील मकपेला येथे असलेले एफ्रोनाचे शेत आणि शेताच्या शेवटच्या टोकाला असलेली गुहा आणि त्याच्या चतुःसीमातील प्रत्येक झाड अब्राहामाने विकत घेण्याचा करार केला. ");
INSERT INTO marc_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","हा करार शहराच्या वेशीसमोर सर्व हेथी लोकांच्या समक्ष झाला, ते सर्व अब्राहामाच्या कायमच्या मालकीचे झाले. ");
INSERT INTO marc_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","त्यानंतर अब्राहामाने आपली पत्नी साराह हिला कनान देशात मम्रे (म्हणजे हेब्रोन) जवळ असलेल्या मकपेलाच्या शेतातील गुहेत पुरले. ");
INSERT INTO marc_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","याप्रमाणे, हेथी लोकांनी स्मशानभूमी म्हणून शेत व त्यातील गुहा अब्राहामाच्या मालकीची झाल्याचा करार केला. ");
INSERT INTO marc_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहाम आता खूप वृद्ध झाला होता. याहवेहने त्याला सर्व बाबतीत आशीर्वादित केले होते. ");
INSERT INTO marc_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहाम आपल्या घरादाराचा कारभार पाहणार्‍या सर्वात जुन्या सेवकाला म्हणाला, “तू आपला हात माझ्या मांडीखाली ठेव. ");
INSERT INTO marc_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","स्वर्ग व पृथ्वीचे परमेश्वर याहवेह यांच्या नावाने मला वचन दे की, माझ्या मुलाचा मी राहत असलेल्या स्थानिक कनानी मुलीबरोबर विवाह करून देणार नाहीस, ");
INSERT INTO marc_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","याऐवजी तू माझ्या मायदेशात माझ्या नातेवाईकांकडे जाशील आणि माझा पुत्र इसहाकासाठी एक वधू शोधून आणशील.” ");
INSERT INTO marc_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","सेवकाने अब्राहामाला विचारले, “पण समजा, आपले घर सोडून इतक्या दूर येण्यास ती स्त्री तयार नसेल तर मी इसहाकाला जो देश तुम्ही सोडून आला त्या देशात घेऊन जावे काय?” ");
INSERT INTO marc_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","“माझ्या मुलाला तिकडे कधीही नेऊ नको,” अब्राहाम त्याला म्हणाला. ");
INSERT INTO marc_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“कारण याहवेह जे स्वर्गाचे परमेश्वर आहेत, त्यांनी माझ्या पित्याच्या घरातून व माझ्या जन्मभूमीतून काढून मला आणि माझ्या मुलाबाळांना हा देश देण्याचे वचन दिले आहे, तेच परमेश्वर तुझ्यापुढे आपला दूत पाठवतील आणि माझ्या मुलासाठी योग्य वधू तुला मिळेल. ");
INSERT INTO marc_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","पण स्त्री येथे येण्यास तयार झाली नाही, तर तू आपल्या वचनातून मुक्त होशील. फक्त माझ्या मुलाला तिकडे नेऊ नकोस.” ");
INSERT INTO marc_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","तेव्हा सेवकाने त्याचा धनी अब्राहामाच्या मांडीखाली हात ठेऊन ही बाब शपथपूर्वक मान्य केली. ");
INSERT INTO marc_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","मग त्या सेवकाने अब्राहामाचे दहा उंट घेऊन, आपल्या धन्याच्या मालमत्तेतील उत्तमोत्तम वस्तू निवडून त्या सर्व उंटांवर लादल्या. मग तो प्रवास करीत अराम-नहराईम मधील नाहोराच्या नगरास गेला. ");
INSERT INTO marc_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","तिथे नगराच्या बाहेर त्याने विहिरीजवळ उंटांना बसविले; ती संध्याकाळची वेळ होती. स्त्रिया विहिरीतून पाणी नेण्यासाठी तिथे येत होत्या. ");
INSERT INTO marc_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","त्यावेळी त्या सेवकाने प्रार्थना केली, “हे याहवेह, माझ्या धन्याच्या परमेश्वरा, माझा धनी अब्राहाम याच्यावर दया करा आणि ज्या उद्देशाने मी हा प्रवास केला तो सफल करा. ");
INSERT INTO marc_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","पाहा, मी येथे विहिरीजवळ उभा आहे व पाणी नेण्याकरिता नगरातील कन्या येत आहेत. ");
INSERT INTO marc_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","माझी तुम्हाला अशी विनंती आहे की, त्या तरुणींपैकी एकीला ‘तुझी पाण्याची घागर वाकवून मला प्यायला पाणी दे’ असा ज्यावेळी मी म्हणेन त्यावेळी, ‘होय निश्चितच, मी तुझ्या उंटांनाही पाणी पाजते’ असे जी म्हणेल तीच इसहाकासाठी तुम्ही निवडलेली वधू आहे, यावरून मला समजेल की तुम्ही माझ्या धन्याला कृपा दाखविली आहे.” ");
INSERT INTO marc_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","त्याची प्रार्थना समाप्त होण्यापूर्वी रिबेकाह खांद्यावर घागर घेऊन तिथे आली. ती नाहोर आणि मिल्का यांचा पुत्र बेथुएल याची कन्या होती. नाहोर हा अब्राहामाचा भाऊ होता. ");
INSERT INTO marc_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ती अतिशय देखणी असून कुमारिका होती; आतापर्यंत कोणत्याही पुरुषाने तिला स्पर्श केला नव्हता. तिने खाली जाऊन विहिरीच्या पाण्याने घागर भरली आणि ती वर आली. ");
INSERT INTO marc_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","अब्राहामाचा सेवक तिच्याकडे धावत गेला आणि तो तिला म्हणाला, “कृपया मला तुझ्या घागरीतील थोडे पाणी दे.” ");
INSERT INTO marc_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“प्या, माझ्या स्वामी,” असे म्हणून तिने लगेच आपली घागर वाकवून त्याला प्यायला पाणी दिले. ");
INSERT INTO marc_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","त्यास पुरेसे पाणी पाजल्यानंतर ती त्याला म्हणाली, “मी तुमच्या उंटांसाठीही त्यांना पुरेल इतके पाणी काढते.” ");
INSERT INTO marc_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","तिने आपल्या घागरीतील पाणी कुंडात ओतले आणि ती पुन्हा पाणी काढण्याकरिता विहिरीकडे धावत गेली आणि त्याच्या सर्व उंटांना पुरेल इतके पाणी तिने काढले. ");
INSERT INTO marc_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ती पाणी काढीत असताना, तो सेवक एक शब्दही न बोलता, तिचे बारकाईने निरीक्षण करीत होता की याहवेहने त्याचा प्रवास सफल केला की नाही. ");
INSERT INTO marc_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","शेवटी उंटांचे पाणी पिणे संपल्यावर, त्याने तिला एक बेका वजनाची सोन्याची नथ आणि दहा शेकेल वजनाच्या दोन सोन्याच्या बांगड्या दिल्या. ");
INSERT INTO marc_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","नंतर त्याने तिला विचारले, “तू कोणाची कन्या आहेस? कृपया मला सांग की रात्री मुक्काम करण्यासाठी आम्हाला तुझ्या वडिलांच्या घरी जागा मिळू शकेल काय?” ");
INSERT INTO marc_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","तिने उत्तर दिले, “मी नाहोर व मिल्का, यांचा पुत्र बेथुएल यांची कन्या आहे.” ");
INSERT INTO marc_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","आणि ती पुढे हे म्हणाली, “आमच्या घरी रात्री मुक्काम करण्यासाठी खोली आणि उंटांसाठीही भरपूर गवत व चारा आहे.” ");
INSERT INTO marc_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तेव्हा त्या मनुष्याने आपले डोके लवविले आणि याहवेहची आराधना केली. ");
INSERT INTO marc_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","तो म्हणाला, “माझा धनी अब्राहामाचे परमेश्वर याहवेहची स्तुती असो, माझ्या धन्याबरोबर तुम्ही इतक्या प्रेमाने आणि विश्वासूपणाने वागता म्हणून मी तुमचे आभार मानतो. माझ्या धन्याच्या नातेवाईकांच्या कुटुंबात तुम्ही मला सरळ घेऊन आला म्हणूनही मी तुमचे आभार मानतो.” ");
INSERT INTO marc_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तेव्हा ती मुलगी आपल्या आईच्या कुटुंबातील लोकांना ही बातमी सांगण्यासाठी धावतच घरी गेली. ");
INSERT INTO marc_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","रिबेकाहला एक भाऊ होता, त्याचे नाव लाबान होते. तो धावतच त्या मनुष्याला भेटण्यासाठी विहिरीकडे गेला; ");
INSERT INTO marc_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","त्याने तिची नथ व तिच्या हातातील बांगड्या पाहिल्या आणि रिबेकाहच्या तोंडची हकिकत ऐकली, तेव्हा तो विहिरीकडे गेला आणि पाहिले की तो मनुष्य अद्यापही आपल्या उंटांपाशी विहिरीजवळच उभा आहे. ");
INSERT INTO marc_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","त्याने म्हटले, “या, तुम्ही जे याहवेहद्वारे आशीर्वादित आहात, बाहेर का उभे आहात? तुम्हाला राहण्यास खोली आणि उंटांकरिता मी जागा तयार केली आहे.” ");
INSERT INTO marc_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","मग तो मनुष्य त्यांच्या घरी गेला. उंटांवरून सामान उतरून त्यांना गवत आणि खाण्याकरिता चाराही देण्यात आला. त्यास व त्याच्या बरोबरीच्या लोकांस पाय धुण्याकरिता त्याने पाणीही दिले. ");
INSERT INTO marc_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","यानंतर भोजन वाढण्यात आले; परंतु तो म्हणाला, “मला जे काही सांगायचे ते सांगेपर्यंत मी भोजन करणार नाही.” लाबान म्हणाला, “ठीक आहे, आम्हाला सांग.” ");
INSERT INTO marc_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","तेव्हा तो म्हणाला, “मी अब्राहामाचा सेवक आहे. ");
INSERT INTO marc_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","याहवेहने माझ्या धन्याला फार आशीर्वाद दिले आहेत आणि तो थोर पुरुष झाला आहे. त्यांनी त्याला मेंढरांचे कळप, गुरांची खिल्लारे, सोने चांदी, पुष्कळ दास आणि दासी, उंट आणि गाढवे दिली आहेत. ");
INSERT INTO marc_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","माझ्या धन्याला त्याची पत्नी साराह हिच्यापासून वृद्धापकाळात एक पुत्र झाला. माझ्या धन्याने त्याचे सर्वस्व त्याला दिले आहे. ");
INSERT INTO marc_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","त्या पुत्रासाठी, मी जिथे राहत आहे तेथील स्थानिक कनानी मुलींमधून पत्नी निवडू नये, असे वचन माझ्या धन्याने माझ्यापासून घेतले आहे. ");
INSERT INTO marc_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","माझ्या वडिलांच्या कुटुंबात जावे आणि माझ्या स्वतःच्या घराण्यातील लोकांकडे जाऊन माझ्या मुलासाठी येथील मुलगी निवडून मी आणावी, असे त्याने मला बजावले आहे. ");
INSERT INTO marc_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“मग मी माझ्या धन्यास विचारले, ती मुलगी माझ्याबरोबर परत आली नाही तर? ");
INSERT INTO marc_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“यावर त्याने उत्तर दिले, ‘ती खात्रीने येईल, कारण ज्या याहवेहच्या समक्षतेत मी चालतो ते त्यांचा दूत तुझ्याबरोबर पाठवतील आणि तुझी यात्रा सिद्धीस नेतील. माझ्या नातेवाईकांकडे जाऊन माझ्या वडिलाच्या घराण्यातील एक मुलगी शोधून आण. ");
INSERT INTO marc_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","याप्रमाणे करण्यास तू वचनबद्ध आहेस. जेव्हा तू माझ्या घराण्याकडे जाशील आणि त्यांनी मुलगी पाठविण्याचे नाकारले, तर तू तुझ्या शपथेतून मुक्त होशील.’ ");
INSERT INTO marc_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“आज मी विहिरीजवळ आलो तेव्हा मी अशी प्रार्थना केली की, माझा धनी अब्राहामाचे परमेश्वर याहवेह, कृपया माझी यात्रा तुम्ही यशस्वी करा. ");
INSERT INTO marc_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","पाहा, मी येथे या विहिरीजवळ उभा असताना पाणी भरण्यास आलेल्या एखाद्या मुलीला म्हणेन, ‘तुझ्या घागरीतील थोडे पाणी मला प्यावयास दे,’ ");
INSERT INTO marc_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","आणि यावर ती मला म्हणेल, ‘अवश्य महाराज, आणि मी तुम्हाला आणि तुमच्या उंटांनाही पाणी पाजीन,’ तीच मुलगी माझ्या धन्याच्या पुत्राची पत्नी होण्यासाठी याहवेहने निवडलेली आहे असे होऊ द्या. ");
INSERT INTO marc_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“माझ्या मनातल्या मनात माझे हे बोलणे संपले नाही तोच रिबेकाह आपल्या खांद्यावर घागर घेऊन पाणी भरण्यास आली आणि तिने विहिरीत उतरून पाणी भरले. मग मी तिला म्हणालो, ‘मला थोडे पाणी प्यावयाला दे.’ ");
INSERT INTO marc_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“मला पाणी पिता यावे म्हणून तिने आपल्या खांद्यावरील घागर झटकन खाली उतरविली आणि ती मला म्हणाली, ‘अवश्य महाराज, मी तुम्हाला आणि तुमच्या उंटांनाही पाणी पाजते.’ मग मी प्यालो आणि तिने उंटांनाही पाणी पाजले. ");
INSERT INTO marc_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“मी तिला विचारले, ‘तू कोणाची मुलगी आहेस?’ “ती म्हणाली, ‘मी नाहोराचे पुत्र बेथुएलाची, ज्यांची माता मिल्का आहे, त्यांची कन्या आहे.’ “हे ऐकून मी तिच्या नाकात नथ आणि हातात पाटल्या घातल्या. ");
INSERT INTO marc_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","माझ्या धन्याच्या भावाची नात शोधून काढण्यास मला योग्य मार्गदर्शन केल्याबद्दल मी माझे मस्तक लवविले आणि माझा धनी अब्राहामाचे परमेश्वर याहवेहचे मी स्तवन केले. ");
INSERT INTO marc_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","तर आता माझ्या धन्यावर दया आणि विश्वासूपणा दाखवून जे योग्य ते करण्याची तुमची तयारी आहे की नाही हे मला नक्की सांगा, म्हणजे पुढे काय करावयाचे ते मला ठरविता येईल.” ");
INSERT INTO marc_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","यावर लाबान आणि बेथुएल यांनी उत्तर दिले, “हे याहवेहकडूनच आहे; हे अगदी उघड आहे. तेव्हा आम्ही तुम्हास बरे किंवा वाईट कसे काय बोलावे? ");
INSERT INTO marc_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ही रिबेकाह तुमच्यापुढे आहे, तिला घेऊन जा. याहवेह परमेश्वराने मार्गदर्शन केल्याप्रमाणे तिला तुमच्या धन्याच्या पुत्राची पत्नी होऊ द्या.” ");
INSERT INTO marc_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","जेव्हा अब्राहामाच्या सेवकाने हे ऐकले, त्याने याहवेहपुढे गुडघे टेकले. ");
INSERT INTO marc_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","मग त्या सेवकाने रिबेकाहला सोने आणि चांदीचे दागिने आणि कपडे दिले; तसेच त्याने तिच्या आईसाठी आणि भावासाठीही पुष्कळ मौल्यवान वस्तू दिल्या. ");
INSERT INTO marc_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","यानंतर त्यांनी संध्याकाळचे भोजन केले आणि तो सेवक व त्याच्या बरोबरच्या माणसांनी खाणेपिणे करून रात्री तिथेच मुक्काम केला. दुसर्‍या दिवशी सकाळी उठल्यानंतर तो म्हणाला, “माझ्या धन्याकडे परत जाण्यास मला निरोप द्या.” ");
INSERT INTO marc_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","परंतु तिची आई व भाऊही म्हणाला, “मुलीने आमच्याजवळ कमीतकमी दहा दिवस राहावे अशी आमची इच्छा आहे; नंतर तुम्ही जावे.” ");
INSERT INTO marc_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","पण विनंती करीत तो म्हणाला, “कृपा करून माझ्या परतण्यात अडथळा आणू नका. कारण याहवेहने माझी यात्रा यशस्वी केली आहे; मला माझ्या मार्गावर पाठवा म्हणजे मी माझ्या धन्याकडे परत जाईन.” ");
INSERT INTO marc_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","तेव्हा ते म्हणाले, “आम्ही मुलीला बोलावून विचारतो” ");
INSERT INTO marc_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","त्याप्रमाणे त्यांनी रिबेकाहला बोलावून विचारले, “तू या मनुष्यासोबत जाशील का?” तिने उत्तर दिले, “होय, मी जाईन.” ");
INSERT INTO marc_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","तेव्हा त्यांनी तिला निरोप दिला. म्हणून त्यांनी आपली बहीण रिबेकाह हिला, तिची दाई, अब्राहामाचा सेवक व त्याची माणसे यांच्यासह तिची रवानगी केली. ");
INSERT INTO marc_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","एकमेकांपासून दूर होण्यापूर्वी त्यांनी रिबेकाहला आशीर्वाद दिला: “आमच्या भगिनी, तू लक्षावधींची माता हो; तुझी संतती त्यांच्या शत्रूंच्या शहरांचा ताबा घेवोत.” ");
INSERT INTO marc_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","नंतर रिबेकाह व तिच्या दासी तयार होऊन उंटावर आरूढ झाल्या आणि त्या मनुष्याबरोबर गेल्या, त्या सेवकाने रिबेकाहला घेतले आणि निघाला. ");
INSERT INTO marc_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","दरम्यानच्या काळात इसहाक नेगेव-दक्षिण-प्रांतातील आपल्या घरून बएर-लहाई-रोई येथे आला होता. ");
INSERT INTO marc_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","एके दिवशी संध्याकाळी तो मनन करीत शेतातून फिरावयास निघाला असताना, त्याने नजर वर करून पाहिले, तो त्याला काही उंट येताना दिसले. ");
INSERT INTO marc_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबेकाहने दृष्टी वर करून इसहाकाला पाहिले, तेव्हा ती उंटावरून खाली उतरली ");
INSERT INTO marc_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","आणि सेवकाला विचारले, “शेतातून आपल्याला भेटावयास येत असलेला तो पुरुष कोण आहे?” “ते माझे स्वामी आहेत.” सेवकाने उत्तर दिले. तेव्हा तिने आपले मुख बुरख्याने झाकून घेतले. ");
INSERT INTO marc_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","आपण काय काय केले याचा सर्व वृतांत सेवकाने इसहाकाला सांगितला. ");
INSERT INTO marc_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","मग इसहाकाने रिबेकाहला आपली आई साराहच्या तंबूमध्ये आणले. त्याने रिबेकाहशी विवाह केला आणि ती त्याची पत्नी झाली. त्याचे तिच्यावर प्रेम बसले; आणि आपल्या आईच्या मृत्यूनंतर तिच्यामुळे त्याला सांत्वन मिळाले. ");
INSERT INTO marc_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहामाने दुसरी पत्नी केली होती, तिचे नाव केटूराह होते. ");
INSERT INTO marc_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","तिच्यापासून त्याला जिम्रान, योक्षान, मदान, मिद्यान, इश्बाक व शूआह पुत्र झाले. ");
INSERT INTO marc_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान हा शबा आणि ददान यांचा पिता; अश्शूरी, लटूशी आणि लऊमी हे ददानाचे गोत्र होते. ");
INSERT INTO marc_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","एफाह, एफेर, हनोख, अबीदा आणि एल्दाह हे मिद्यानाचे पुत्र होते. हे सर्व केटूराहचे वंशज होते. ");
INSERT INTO marc_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","अब्राहामाने आपली सर्व मालमत्ता इसहाकाच्या नावावर केली. ");
INSERT INTO marc_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","परंतु अब्राहाम जिवंत असताना त्याने आपल्या दासीपुत्रांनाही देणग्या दिल्या आणि त्याने त्यांना इसहाकापासून दूर, पूर्वेकडे पाठवून दिले. ");
INSERT INTO marc_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहाम एकशे पंचाहत्तर वर्षे जगला. ");
INSERT INTO marc_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","मग अब्राहामाने अखेरचा श्वास घेतला आणि एका वृद्धावस्थेत, परिपूर्ण वयाचा होऊन मरण पावला; आणि मग तो त्याच्या लोकांना जाऊन मिळाला. ");
INSERT INTO marc_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","त्याची मुले इसहाक आणि इश्माएल यांनी त्याला मम्रेजवळील मकपेलाच्या गुहेत, जोहर हिथीचा मुलगा एफ्रोनच्या शेतात पुरले, ");
INSERT INTO marc_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","हे अब्राहामाने हेथच्या लोकांकडून विकत घेतलेले शेत. तिथे अब्राहामाला त्याची पत्नी साराहजवळ मूठमाती देण्यात आली. ");
INSERT INTO marc_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहामाच्या मृत्यूनंतर परमेश्वराने इसहाकाला आशीर्वाद दिला, जो नंतर बएर-लहाई-रोई या ठिकाणी राहवयास गेला. ");
INSERT INTO marc_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ही अब्राहामाचा पुत्र इश्माएलची वंशावळ आहे, जो साराहची इजिप्तमधील दासी हागारेपासून जन्मला. ");
INSERT INTO marc_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ही इश्माएलाच्या पुत्रांची त्यांच्या जन्मानुसार यादी: इश्माएलाचा प्रथमपुत्र नबायोथ, नंतर केदार, अदबील, मिबसाम, ");
INSERT INTO marc_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दूमाह, मस्सा, ");
INSERT INTO marc_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश आणि केदमाह. ");
INSERT INTO marc_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","हे इश्माएलाचे पुत्र होते आणि त्यांच्या गावांवरून आणि छावण्यांनुसार हे बारा वंशाचे प्रधान झाले. ");
INSERT INTO marc_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्माएल एकशे सदतीस वर्षे जगला. त्याने आपला शेवटचा श्वास घेतला आणि मरण पावला आणि तो आपल्या पूर्वजास जाऊन मिळाला. ");
INSERT INTO marc_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","त्याचे वंशज हवीलापासून शूर देशापर्यंत वस्ती करून राहिले. हा देश इजिप्त देशाच्या सीमेवर अश्शूरच्या बाजूला आहे. ते एकमेकांशी वैराभावाने राहत होते. ");
INSERT INTO marc_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहामाचा मुलगा इसहाक याची वंशावळ अशी आहे: अब्राहाम हा इसहाकाचा पिता झाला, ");
INSERT INTO marc_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","जेव्हा इसहाकाने रिबेकाहशी विवाह केला तेव्हा तो चाळीस वर्षांचा होता. रिबेकाह पद्दन-अराम येथील अरामी बेथुएलाची कन्या आणि लाबानाची बहीण होती. ");
INSERT INTO marc_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाकाने याहवेहची प्रार्थना करून रिबेकाहला मूल देण्याची विनंती केली, कारण तिला मूल नव्हते. याहवेहने त्याची विनवणी ऐकली आणि त्याची पत्नी रिबेकाह गर्भवती झाली. ");
INSERT INTO marc_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","तिच्या उदरात मुले एकमेकांशी भांडू लागली. तेव्हा ती म्हणाली, “मला हे काय होत आहे?” आणि याबाबत तिने याहवेहकडे विचारणा केली. ");
INSERT INTO marc_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","याहवेहने तिला सांगितले, “तुझ्या उदरात दोन राष्ट्रे आहेत, तुझ्या उदरातील हे दोन वंश वेगळे होतील; एकजण दुसर्‍यापेक्षा बलवान होईल, मोठा लहान्याची सेवा करेल.” ");
INSERT INTO marc_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","तिचे दिवस भरून प्रसूतिसमय आला तेव्हा पाहा, तिला जुळे पुत्र झाले. ");
INSERT INTO marc_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","पहिल्यांदा जन्मलेला तांबूस रंगाच्या केसांनी इतका व्यापलेला होता की, त्याने केसांचा झगाच घातला आहे असे वाटत होते; म्हणून त्यांनी त्याचे नाव एसाव असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","मग जुळ्यातील दुसरा पुत्र जन्मला. त्याचा हात एसावाच्या टाचेवर होता म्हणून त्यांनी त्याचे नाव याकोब असे ठेवले. जेव्हा रिबेकाहने यांना जन्म दिला, तेव्हा इसहाक साठ वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","हळूहळू ती मुले वाढली. एसाव एक तरबेज शिकारी झाला, खुल्या मैदानातील फिरणारा मनुष्य होता, पण याकोब तसा शांत स्वभावाचा असून त्याला तंबूतच राहण्यास आवडे. ");
INSERT INTO marc_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाकास वन्यप्राण्यांचे मांस खाण्याची आवड होती, एसाव त्याचा आवडता होता, तर याकोब रिबेकाहचा आवडता होता. ");
INSERT INTO marc_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एकदा याकोब वरण शिजवित असताना एसाव शिकारीहून खूप थकूनभागून आला. ");
INSERT INTO marc_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","तो याकोबाला म्हणाला, “लवकर, मला तो तांबडा पदार्थ घेऊ दे! मला भयंकर भूक लागली आहे!” (म्हणूनच त्याला एदोम असेही म्हणतात.) ");
INSERT INTO marc_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकोबाने उत्तर दिले, “प्रथम तुझा ज्येष्ठत्वाचा हक्क मला दे.” ");
INSERT INTO marc_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव म्हणाला, “एखादा मनुष्य भुकेने मरत असताना त्याला त्याच्या ज्येष्ठत्वाच्या हक्काचा काय उपयोग?” ");
INSERT INTO marc_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","परंतु याकोब म्हणाला, “आधी शपथ घे.” म्हणून त्याने शपथ घेतली आणि आपला ज्येष्ठ पुत्रत्वाचा हक्क याकोबाला मोबदला म्हणून दिला. ");
INSERT INTO marc_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तेव्हा याकोबाने एसावाला भाकर व मसुरीच्या डाळीचे वरण दिले; एसावाने ते खाल्ले आणि निघून गेला. अशा रीतीने एसावाने आपला ज्येष्ठत्वाचा हक्क तुच्छ मानला. ");
INSERT INTO marc_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","त्या देशात दुष्काळ पडला—अब्राहामाच्या काळात पडला त्या खेरीज हा दुसरा दुष्काळ होता—म्हणून इसहाक गरार या शहरात पलिष्ट्यांचा राजा अबीमेलेख याजकडे गेला. ");
INSERT INTO marc_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","याहवेहने तिथे इसहाकाला दर्शन देऊन म्हटले, “खाली इजिप्त देशात जाऊ नकोस; मी तुला सांगतो त्या देशात राहा. ");
INSERT INTO marc_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","या प्रांतात काही काळ राहा आणि मी तुझ्यासह असेन व तुला आशीर्वादित करेन. तुझा पिता अब्राहाम याला मी दिलेले वचन पूर्ण करण्यासाठी हा सर्व प्रदेश तुला आणि तुझ्या वंशजाला देईन. ");
INSERT INTO marc_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","मी तुझ्या वंशजांची संख्या असंख्य तार्‍यांसारखी करेन. मी हा सर्व प्रदेश तुझ्या वंशजांना देईन आणि पृथ्वीवरील सर्व राष्ट्रे तुझ्या संततीद्वारे आशीर्वादित होतील. ");
INSERT INTO marc_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","कारण अब्राहामाने माझे आज्ञापालन केले आणि मी सांगितलेला प्रत्येक नियम, विधी व प्रत्येक सूचनेचे पालन केले.” ");
INSERT INTO marc_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","म्हणून इसहाक गरारातच राहिला. ");
INSERT INTO marc_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","जेव्हा तेथील लोकांनी त्याला त्याच्या पत्नीबद्दल विचारले, तेव्हा तो म्हणाला, “ती माझी बहीण आहे.” कारण “ती माझी पत्नी आहे” असे सांगण्याची त्याला भीती वाटली; त्याने विचार केला, “या ठिकाणचे लोक रिबेकाहमुळे कदाचित मला मारून टाकतील, कारण ती फार सुंदर आहे.” ");
INSERT INTO marc_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","तो तिथे बराच काळ राहिल्यानंतर एके दिवशी पलिष्ट्यांचा राजा अबीमेलेख याने खिडकीतून बाहेर पाहिले की तो इसहाक आपली पत्नी रिबेकाह हिच्याशी प्रेम करीत आहे. ");
INSERT INTO marc_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","अबीमेलेखाने इसहाकाला बोलाविणे पाठविले आणि त्याला म्हणाला, “निश्चितच ही तुझी पत्नी आहे, ‘तर ती माझी बहीण आहे’ असे तू का सांगितलेस?” इसहाकाने उत्तर दिले, “तिच्यामुळे माझा कोणी वध करेल अशी मला भीती वाटली.” ");
INSERT INTO marc_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेखाने उद्गार काढले, “तू आमच्यासोबत असे का केले? माझ्या लोकांपैकी कोणीही तिच्यासोबत निजला असता आणि तू आमच्यावर दोष आणला असतास.” ");
INSERT INTO marc_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","यानंतर अबीमेलेखाने जाहीर फर्मान काढले: “या मनुष्याला किंवा याच्या पत्नीला कोणी त्रास दिल्यास त्याला मृत्यूची शिक्षा दिली जाईल.” ");
INSERT INTO marc_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाकाने त्या देशात धान्य पेरले व त्याच वर्षी त्याला शंभरपट पीक मिळाले, कारण याहवेहने इसहाकाला आशीर्वादित केले. ");
INSERT INTO marc_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","तो श्रीमंत होत गेला आणि त्याचे धन असे वाढत गेले की पुढे तो खूप धनाढ्य झाला. ");
INSERT INTO marc_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","त्याच्याकडे इतके मेंढ्या, गुरे आणि नोकर होते की पलिष्ट्यांनी त्याचा हेवा केला. ");
INSERT INTO marc_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","म्हणून ज्या विहिरी त्याचा पिता अब्राहाम याच्या नोकरांनी खणल्या होत्या त्या सर्व पलिष्ट्यांनी मातीने बुजवून टाकल्या. ");
INSERT INTO marc_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","तेव्हा अबीमेलेखाने इसहाकाला म्हटले, “तू आमच्यापासून दूर निघून जा; तू आमच्यापेक्षा अधिक शक्तिशाली झाला आहेस.” ");
INSERT INTO marc_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","तेव्हा इसहाकाने ते ठिकाण सोडले आणि गरारच्या खोर्‍यात तळ देऊन राहू लागला. ");
INSERT INTO marc_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","इसहाकाने आपला पिता अब्राहाम याने खणलेल्या आणि अब्राहामाच्या मृत्यूनंतर पलिष्टी लोकांनी बुजवून टाकलेल्या सर्व विहिरी पुन्हा खणल्या. अब्राहामाने विहिरीना जी नावे दिली होती तीच नावे त्याने पुनः दिली. ");
INSERT INTO marc_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","इसहाकाच्या नोकरांनी खोर्‍यात एक नवी विहीर खणली आणि तिथे त्यांना गोड पाण्याचा एक झरा सापडला. ");
INSERT INTO marc_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","मग गरारचे गुराखी इसहाकाच्या गुराख्यांशी भांडले आणि म्हणाले, “हे पाणी आमचे आहे!” म्हणून त्याने विहिरीला एसेक असे नाव दिले; कारण त्यांचे त्याच्याशी भांडण झाले. ");
INSERT INTO marc_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","मग त्यांनी दुसरी एक विहीर खणली; पण तिच्यावरूनही पुन्हा भांडणे झाली, म्हणून तिचे नाव सितनाह असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","यानंतर इसहाकाने आणखी एक विहीर खणली, पण त्यावेळी कोणाशीही भांडण झाले नाही. म्हणून त्याने त्या विहिरीचे नाव रेहोबोथ असे ठेवले. तो म्हणाला, “आता तरी याहवेहने आम्हाला जागा दिली आहे. आता आमची या देशात भरभराट होईल.” ");
INSERT INTO marc_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","पुढे इसहाक तिथून बेअर-शेबाला गेला; ");
INSERT INTO marc_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","त्याच रात्री याहवेहने त्याला दर्शन देऊन म्हटले, “मी तुझा पिता अब्राहामाचा परमेश्वर आहे; भिऊ नकोस, कारण मी तुझ्याबरोबर आहे; मी आपला सेवक अब्राहाम याच्यासाठी तुला आशीर्वादित करेन आणि तुझा वंश वाढवेन.” ");
INSERT INTO marc_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","मग इसहाकाने तिथे एक वेदी बांधली आणि याहवेहची उपासना केली. त्याने तिथे वस्ती केली आणि तिथे त्यांच्या नोकरांनी एक विहीर खणली. ");
INSERT INTO marc_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","एके दिवशी त्याला भेटण्यासाठी गरारहून अबीमेलेख, त्याचा सल्लागार अहुज्जाथ आणि त्याचा सेनापती पीकोल हे आले. ");
INSERT INTO marc_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","“तुम्ही येथे का आला?” इसहाकाने त्यांना विचारले, “कारण तुम्ही मला द्वेषाने वागवून हाकलून दिले होते.” ");
INSERT INTO marc_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","यावर ते म्हणाले, “आम्हाला हे स्पष्टपणे दिसत आहे की, याहवेह तुला आशीर्वादित करीत आहेत; तुझ्याशी—तुझ्या आणि आमच्यामध्ये एक करार करावा असे आम्हाला वाटले. म्हणून आम्हाला तुमच्याबरोबर करार करू द्यावा. ");
INSERT INTO marc_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","आम्ही जसा तुला कसलाही उपद्रव दिला नाही, तसा तू आम्हाला कसलाही उपद्रव देणार नाहीस, असे वचन दे. उलट आम्ही तुझे भलेच केले आणि तुला शांतीने जाऊ दिले; आणि आता तू याहवेहद्वारे आशीर्वादित झाला आहे.” ");
INSERT INTO marc_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","इसहाकाने त्यांच्यासाठी एक मोठी मेजवानी दिली आणि त्यांनी खाणेपिणे केले. ");
INSERT INTO marc_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","पहाटेस उठल्याबरोबर त्यांनी एकमेकांशी करार केला. नंतर इसहाकाने त्यांना निरोप दिला व ते शांतीने परतले. ");
INSERT INTO marc_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","त्या दिवशी इसहाकाचे नोकर त्याच्याकडे येऊन त्याला सांगू लागले. “आम्ही खणीत असलेल्या विहिरीला पाणी लागले आहे!” ");
INSERT INTO marc_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","त्याने तिला शिबाह म्हटले, आणि आजपर्यंत या नगराचे नाव बेअर-शेबा असे आहे. ");
INSERT INTO marc_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","एसावाने त्याच्या चाळिसाव्या वर्षी यहूदीथ नावाच्या बवरी हिथीच्या मुलीसोबत आणि एलोन हिथी याची कन्या बासमाथ हिच्याबरोबरही विवाह केला. ");
INSERT INTO marc_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","त्या इसहाक आणि रिबेकाहसाठी दुःखाचे स्रोत होत्या. ");
INSERT INTO marc_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","इसहाक वृद्ध झाला, त्याची दृष्टी मंद होऊन त्याला दिसेनासे झाले, तेव्हा एके दिवशी त्याने आपला ज्येष्ठपुत्र एसाव याला हाक मारली व म्हटले, “माझ्या मुला.” “बाबा, काय आज्ञा,” तो उत्तरला. ");
INSERT INTO marc_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","तेव्हा इसहाक त्याला म्हणाला, “मी आता वृद्ध झालो आहे, आणि माझ्या मृत्यूचा दिवस मला माहीत नाही. ");
INSERT INTO marc_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","तर तुझे शस्त्र घेऊन ये—धनुष्य व बाण घे—आणि खुल्या मैदानात जाऊन एखाद्या वनपशूची शिकार करून आण. ");
INSERT INTO marc_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","मग माझ्या आवडीचे रुचकर भोजन तयार कर आणि मला खाण्यासाठी ते इकडे घेऊ ये, म्हणजे मरण्यापूर्वी मी माझा आशीर्वाद तुला देईन.” ");
INSERT INTO marc_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","इसहाक आपला पुत्र एसावसोबत बोलत आहे हे रिबेकाह ऐकत होती. एसाव रानात शिकार करून मांस आणण्यास गेला, ");
INSERT INTO marc_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","रिबेकाहने आपला पुत्र याकोब याला बोलाविले आणि ती त्याला म्हणाली “हे बघ, तुझे वडील तुझा भाऊ एसावाला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","एखाद्या वनपशूची शिकार करून आण, मग माझ्या आवडीचे रुचकर भोजन तयार कर, म्हणजे मरण्यापूर्वी याहवेहच्या सानिध्यात जो आशीर्वाद आहे, तो मी तुला देईन, हे सांगताना मी ऐकले.” ");
INSERT INTO marc_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ती म्हणाली, “आता माझ्या मुला, नीट लक्ष देऊन ऐक व मी सांगते तसेच कर: ");
INSERT INTO marc_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","बाहेर कळपात जा आणि दोन चांगली करडे घेऊ ये. मी त्या करडांचे तुझ्या वडिलांच्या आवडीप्रमाणे रुचकर भोजन तयार करेन, ");
INSERT INTO marc_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","मग ते तू आपल्या वडिलांकडे घेऊन जा. म्हणजे मृत्यूपूर्वी ते तुला आशीर्वाद देतील.” ");
INSERT INTO marc_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकोब त्याची आई रिबेकाहला म्हणाला, “पण माझा भाऊ एसाव तर केसाळ आहे आणि माझी कातडी अगदी केसरहित आहे. ");
INSERT INTO marc_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","वडिलांनी मला चाचपून पाहिले तर? त्यांना वाटेल मी त्यांना फसवीत आहे आणि मग आशीर्वादाऐवजी मी स्वतःवर शाप ओढवून घेईन.” ");
INSERT INTO marc_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","तेव्हा रिबेकाह म्हणाली, “माझ्या बाळा, ते शाप माझ्यावर पडोत. मी सांगते त्याप्रमाणे तू कर, बाहेर जा आणि करडे घेऊन ये.” ");
INSERT INTO marc_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","तेव्हा याकोबाने करडे कापून, स्वच्छ करून आपल्या आईकडे आणली, आणि तिने त्याच्या वडिलांना आवडणारे रुचकर भोजन तयार केले. ");
INSERT INTO marc_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","मग रिबेकाहने घरात असलेले एसावाचे उत्तम कपडे घेतले आणि आपला धाकटा मुलगा याकोबाला ते घालण्यास सांगितले. ");
INSERT INTO marc_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","तिने त्याचा हात आणि मानेवरचा गुळगुळीत भाग करडांच्या कातड्याने झाकला. ");
INSERT INTO marc_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","नंतर तिने रुचकर भोजन व भाकर आपला मुलगा याकोबाजवळ दिली. ");
INSERT INTO marc_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","आपल्या वडिलाजवळ जाऊन याकोब म्हणाला, “बाबा.” तो म्हणाला, “काय माझ्या बाळा? तू कोण आहेस?” ");
INSERT INTO marc_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","तेव्हा याकोबाने उत्तर दिले, “मी एसाव, तुमचा ज्येष्ठपुत्र आहे. तुम्ही सांगितल्याप्रमाणे मी केले आहे. कृपया उठून बसा आणि तुमच्यासाठी शिकार करून आणलेले भोजन खा, म्हणजे तुम्ही मला तुमचे आशीर्वाद द्या.” ");
INSERT INTO marc_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","त्यावर इसहाक म्हणाला, “माझ्या मुला, इतक्या लवकर तुला शिकार कशी मिळाली?” तेव्हा तो म्हणाला, “तुमचे परमेश्वर याहवेह यांनी मला यश दिले.” ");
INSERT INTO marc_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","मग इसहाक याकोबास म्हणाला, “माझ्या मुला, जरा माझ्याजवळ ये. तू खरोखरच एसाव आहेस की नाही ते मला चाचपून पाहू दे.” ");
INSERT INTO marc_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","तेव्हा याकोब आपला पिता इसहाकाजवळ गेला व त्यांनी त्याला चाचपून म्हटले, “वाणी तर याकोबाची आहे, पण हात एसावाचे आहेत.” ");
INSERT INTO marc_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","त्याने त्याला ओळखले नाही, कारण त्याचे हात एसावाच्या हातांसारखे केसाळ होते. तो याकोबाला आशीर्वाद देण्यासाठी तयार झाला, ");
INSERT INTO marc_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","त्याने विचारले, “तू खरोखर माझा पुत्र एसावच आहेस काय?” तो म्हणाला “होय, मीच आहे.” ");
INSERT INTO marc_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","मग इसहाक त्यास म्हणाला, “त्या शिकारीचे भोजन इकडे आण. मी ते खाईन आणि माझे आशीर्वाद तुला देईन.” तेव्हा याकोबाने जेवणाचे ताट आणले, तो जेवला आणि मग द्राक्षारस त्याच्याकडे आणले, तेही तो प्याला. ");
INSERT INTO marc_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","मग इसहाक त्याला म्हणाला, “माझ्या मुला इकडे ये आणि माझे चुंबन घे.” ");
INSERT INTO marc_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","तो आपल्या पित्याजवळ गेला आणि त्याने त्याचे चुंबन घेतले. जेव्हा इसहाकाला त्याच्या वस्त्रांचा वास आला, तेव्हा त्याला आशीर्वाद देत तो म्हणाला, “अहा, माझ्या पुत्राचा सुगंध, जसा याहवेहने आशीर्वादित केलेल्या शेताचा. ");
INSERT INTO marc_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेश्वर तुला आकाशातील दव आणि पृथ्वीची समृद्धी देतील, भरपूर धान्य आणि नवीन द्राक्षारस देतील. ");
INSERT INTO marc_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","राष्ट्रे तुझी सेवा करोत, आणि लोक तुझ्यापुढे नमोत. तू तुझ्या भाऊबंदाचा धनी हो. तुझ्या आईची मुले तुझ्यापुढे लवून तुला मुजरा करोत. जे तुला शाप देतात ते सर्व शापित होवोत, आणि जे तुला आशीर्वाद देतात ते सर्व आशीर्वादित होवोत.” ");
INSERT INTO marc_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","इसहाकाने त्याला आशीर्वाद देण्याचे पूर्ण केले आणि याकोब आपल्या वडिलांच्या उपस्थितीतून पडतो न पडतो तोच एसाव शिकारीहून परतला ");
INSERT INTO marc_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","त्यानेही आपल्या पित्यासाठी रुचकर भोजन तयार केले आणि त्याच्याकडे ते घेऊन आला व म्हणाला, “बाबा, हे पाहा मी शिकार घेऊन आलो आहे. उठून बसा आणि हे खा म्हणजे मला तुम्ही तुमचे आशीर्वाद देऊ शकाल.” ");
INSERT INTO marc_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","हे ऐकून त्याचा पिता इसहाक त्यास म्हणाला, “तू कोण आहेस?” त्याने उत्तर दिले, “मी एसाव तुमचा ज्येष्ठपुत्र आहे.” ");
INSERT INTO marc_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","त्याचवेळी इसहाकाच्या शरीराला भयंकर कंप सुटला आणि तो म्हणाला, “तर मग आताच शिकार घेऊन माझ्याकडे आला होता तो कोण होता? तू येण्यापूर्वी मी तर ते खाल्ले आणि माझे आशीर्वादही त्याला दिले. होय, त्याला ते आशीर्वाद आता मिळणारच.” ");
INSERT INTO marc_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","जेव्हा एसावाने आपल्या पित्याचे हे शब्द ऐकले, तेव्हा तो अतिदुःखाने हंबरडा फोडून आपल्या पित्यास म्हणाला, “बाबा, बाबा, मलाही आशीर्वाद द्या.” ");
INSERT INTO marc_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","परंतु तो म्हणाला, “तुझा भाऊ कपटाने आला होता आणि तुझे आशीर्वाद तो घेऊन गेला.” ");
INSERT INTO marc_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","यावर एसावाने म्हटले, “त्याचे नाव याकोब योग्यच नाही काय? त्याने दुसर्‍यांदा मला फसविले आहे. त्याने माझा जन्मसिध्द हक्क घेतला आणि आता माझा आशीर्वादही चोरला आहे.” नंतर त्याने विचारले, “माझ्यासाठी तुम्ही एकही आशीर्वाद राखून ठेवला नाही काय?” ");
INSERT INTO marc_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","परंतु इसहाकाने एसावास उत्तर दिले, “मी त्याला तुझा धनी आणि तुझ्या सर्व नातेवाईकांना त्याचे नोकर करून ठेवले आहे. मी त्याला भरपूर धान्य आणि द्राक्षारस यांची हमी दिली आहे. आता देण्याचे काय शिल्लक राहिले आहे, माझ्या मुला?” ");
INSERT INTO marc_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसाव आपल्या वडिलांना म्हणाला, “तुमच्याकडे एकच आशीर्वाद आहे काय? अहो बाबा, मलाही आशीर्वाद द्या!” मग एसाव मोठ्याने रडू लागला. ");
INSERT INTO marc_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","त्याचे वडील इसहाक त्याला उत्तर देत म्हणाले, “तुझे वास्तव्य सुपीक प्रदेशापासून दूर आकाशातील दहिवर पडते तिथून दूर असेल. ");
INSERT INTO marc_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तलवारीच्या जोरावर तू जगशील तू आपल्या भावाची सेवा करशील, परंतु जेव्हा अस्वस्थ होशील, तेव्हा तुझ्यावर असलेले त्याचे जू तू तुझ्यावरून झुगारून देशील.” ");
INSERT INTO marc_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","एसाव याकोबाचा त्याच्या पित्याने आशीर्वाद दिल्यामुळे द्वेष करू लागला. तो स्वतःशीच म्हणाला, “माझ्या वडिलांसाठी शोक करण्याचे दिवस जवळ आले आहे; मग मी माझा भाऊ याकोबाचा वध करेन.” ");
INSERT INTO marc_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","परंतु एसावाचा बेत कोणीतरी रिबेकाहच्या कानावर घातला. रिबेकाहने याकोबाला बोलाविले आणि त्याला सांगितले, “एसावाने तुझा जीव घेऊन, सूड घेण्याची धमकी दिली आहे. ");
INSERT INTO marc_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","तर आता माझ्या मुला, मी म्हणते तसे कर आणि माझा भाऊ लाबानकडे हारानला पळून जा. ");
INSERT INTO marc_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","तुझ्या भावाचा राग शमेपर्यंत काही काळ तिथेच राहा. ");
INSERT INTO marc_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","तू जे काही केलेस याचा त्याला विसर पडेपर्यंत तू तिथेच राहा. मग मी तुला बोलाविणे पाठवेन. एकाच दिवशी मी तुम्हा दोघांनाही का मुकावे?” ");
INSERT INTO marc_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","नंतर रिबेकाह इसहाकास म्हणाली, “या हेथी मुलींमुळे माझा जीव मला नकोसा झाला आहे. याकोबानेही त्यांच्यापैकीच एकीशी लग्न केले तर माझ्या जगण्याचा काही उपयोग नसेल.” ");
INSERT INTO marc_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","तेव्हा इसहाकाने याकोबाला बोलावून आशीर्वाद दिला आणि नंतर त्याला आज्ञा दिली, “कनानी मुलीशी तू लग्न करू नकोस. ");
INSERT INTO marc_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","तू त्वरित पद्दन-अराम येथे तुझा आईचा पिता बेथुएल याच्या घरी जा, आणि तुझ्या आईचा भाऊ लाबान याच्या मुलींपैकी पत्नी कर. ");
INSERT INTO marc_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वसमर्थ परमेश्वर तुला आशीर्वाद देवो. तुला पुष्कळ संतती देवो आणि तुझ्यापासून अनेक वंशाचे एक मोठे राष्ट्र निर्माण करो. ");
INSERT INTO marc_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","अब्राहामाला जे आशीर्वाद परमेश्वराने दिले, ते तुझ्या वंशजाला लाभोत, ज्या भूमीवर तू आता परदेशी म्हणून राहत आहेस, ती भूमी तुझ्या मालकीची होवो, कारण परमेश्वराने ती अब्राहामाला दिलेली आहे.” ");
INSERT INTO marc_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","अशा रीतीने इसहाकाने याकोबाला पद्दन-अराम येथे अरामी बेथुएलाचा पुत्र आणि याकोब व एसाव यांची आई रिबेकाहचा भाऊ, लाबान याच्याकडे पाठविले. ");
INSERT INTO marc_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","एसावाला समजले की इसहाकाने याकोबाला आशीर्वाद देऊन पद्दन-अराम येथे पत्नी करण्यासाठी पाठविले आहे, आणि जेव्हा त्याने त्याला आशीर्वाद दिला, तेव्हा त्याला आज्ञा दिली की तू कनानी मुलीशी विवाह करू नको, ");
INSERT INTO marc_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","आणि याकोब आपल्या पित्याची व आईची आज्ञा पाळून पद्दन-अराम येथे गेला. ");
INSERT INTO marc_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","तेव्हा एसावाला समजले की, त्याचे वडील इसहाकाला कनानी मुली अजिबात आवडत नाहीत. ");
INSERT INTO marc_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","म्हणून एसाव अब्राहामाचा पुत्र इश्माएलच्या घरी गेला आणि तिथे त्याने त्याची कन्या, नबायोथाची बहीण माहलथशी विवाह केला आणि माहलथ त्याच्या पूर्वीच्या पत्नींमध्ये सामील झाली. ");
INSERT INTO marc_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकोब बेअर-शेबा सोडून हारानास जाण्यास निघाला. ");
INSERT INTO marc_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","त्या रात्री सूर्य मावळल्यावर तो मुक्कामास एके ठिकाणी थांबला असताना, त्याने एक धोंडा उशासाठी घेतला आणि तो त्या ठिकाणी झोपी गेला. ");
INSERT INTO marc_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","तेव्हा त्याला एक स्वप्न पडले. त्यात त्याने पृथ्वीवर उभी केलेली व तिचे वरचे टोक स्वर्गाला टेकलेले आहे अशी एक शिडी पाहिली. परमेश्वराचे दूत त्या शिडीवरून वर जाताना व खाली उतरतांना त्याने पाहिले. ");
INSERT INTO marc_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","शिडीच्या वरच्या टोकाला याहवेह उभे राहून त्यास म्हणाले, “मी याहवेह, तुझा पिता अब्राहाम व इसहाक यांचा परमेश्वर आहे. ज्या भूमीवर तू झोपला आहेस ती मी तुला आणि तुझ्या वंशजांना देईन. ");
INSERT INTO marc_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तुझे गोत्र धुळीच्या कणांइतके वाढतील. ते नेगेव पासून पूर्वेपर्यंत आणि उत्तरेपासून दक्षिणेपर्यंत विस्तार करतील. तुझ्या व तुझ्या संततीच्या द्वारे पृथ्वीवरील सर्व लोक आशीर्वादित होतील. ");
INSERT INTO marc_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","पाहा, मी तुझ्याबरोबर आहे आणि ज्या ठिकाणी तू जाशील, त्या सर्व ठिकाणी मी तुझे संरक्षण करेन आणि याच भूमीवर तुला सुखरुपपणे परत आणेन. तुला दिलेले अभिवचन पूर्ण होईपर्यंत मी तुझ्याबरोबर सतत राहीन.” ");
INSERT INTO marc_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","मग याकोब झोपेतून जागा झाला, त्याने विचार केला, “निश्चितच याहवेहची उपस्थिती या ठिकाणी आहे, पण मला हे माहीत नव्हते. ");
INSERT INTO marc_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","तो भयभीत झाला आणि म्हणाला, हे किती अद्भुत स्थळ आहे! हे परमेश्वराच्या भवनाशिवाय दुसरे काहीही असू शकत नाही; हे स्वर्गाचे द्वार आहे.” ");
INSERT INTO marc_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","दुसर्‍या दिवशी याकोब अगदी पहाटेस उठला आणि जो धोंडा त्याने उशाशी घेतला होता, तो त्याने स्तंभ म्हणून उभा केला आणि त्यावर जैतुनाचे तेल ओतले. ");
INSERT INTO marc_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","त्याने त्या जागेचे नाव बेथेल असे ठेवले, जरी त्या नगराचे नाव लूज असे होते. ");
INSERT INTO marc_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","नंतर याकोबाने नवस केला, “जर परमेश्वर माझ्यासोबत असतील, या प्रवासात माझे रक्षण करतील, मला अन्नपाणी, वस्त्र देतील, ");
INSERT INTO marc_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","व मला आपल्या पित्याच्या घरी सुखरुपपणे परत आणतील, तर याहवेह माझे परमेश्वर होतील ");
INSERT INTO marc_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","आणि हा जो धोंडा मी स्तंभ म्हणून उभा केला आहे ते परमेश्वराचे भवन होईल आणि जे सर्वकाही ते मला देतील, त्यातील प्रत्येकाचा दशांश मी त्यांना अर्पण करेन.” ");
INSERT INTO marc_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","प्रवास करीत याकोब पूर्वेकडील लोकांच्या प्रदेशात आला. ");
INSERT INTO marc_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","त्याला समोरच्या मैदानात मेंढरांचे तीन कळप, एका विहिरीजवळ पाणी पिण्यासाठी बसलेले दिसले, परंतु एका मोठ्या दगडाने विहिरीचे तोंड झाकून ठेवलेले होते. ");
INSERT INTO marc_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","सर्व कळप विहिरीजवळ जमल्यानंतर मेंढपाळ तो दगड लोटत असत आणि सर्व कळपांना पाणी पाजून मग तो दगड विहिरीच्या तोंडावर पुन्हा ठेवीत असत. ");
INSERT INTO marc_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकोब मेंढपाळांकडे गेला, आणि त्याने त्यांना विचारले, “माझ्या भावांनो, तुम्ही कुठून आहात?” ते म्हणाले, “आम्ही हारानाहून आलो आहोत.” ");
INSERT INTO marc_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","तेव्हा त्याने त्यांना विचारले, “नाहोराचा नातू लाबान याला तुम्ही ओळखता काय?” “हो, आम्ही ओळखतो,” त्यांनी उत्तर दिले. ");
INSERT INTO marc_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","यावर याकोबाने त्यांना विचारले, “ते बरे आहेत काय?” “तो बरा आहे, ती पाहा, त्याची कन्या राहेल मेंढरांचा कळप घेऊन इकडेच येत आहे.” ते म्हणाले. ");
INSERT INTO marc_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","याकोबाने म्हटले, “पाहा सूर्य अजून मावळला नाही; कळपांना एकत्र करण्याची अजून वेळ झालेली नाही. त्यांना पाणी पाजून पुन्हा चरावयास घेऊन जा.” ");
INSERT INTO marc_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","आम्ही तसे करू शकत नाही, त्यांनी उत्तर दिले, “सगळे कळप येथे जमल्यानंतर आम्ही विहिरीवरील दगड बाजूला काढतो आणि कळपांना पाणी पाजतो.” ");
INSERT INTO marc_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","त्यांचे संभाषण चालू असताना राहेल आपल्या पित्याची मेंढरे घेऊन तिथे आली, कारण ती मेंढपाळ होती. ");
INSERT INTO marc_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","जेव्हा याकोबाने त्याचा मामा लाबानची मुलगी राहेल आणि लाबानाची मेंढरे पाहिली, तेव्हा त्याने विहिरीच्या तोंडावरील दगड बाजूला केला आणि आपल्या मामाच्या मेंढरांना पाणी पाजले. ");
INSERT INTO marc_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","नंतर याकोबाने राहेलचे चुंबन घेतले आणि तो मोठ्याने रडू लागला. ");
INSERT INTO marc_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","याकोबाने राहेलला सांगितले की तो तिच्या पित्याच्या नात्यातील आहे आणि रिबेकाह हिचा मुलगा आहे. तेव्हा राहेल धावतच गेली आणि आपल्या पित्याला ही बातमी सांगितली. ");
INSERT INTO marc_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","लाबानाला आपल्या बहिणीचा मुलगा याकोबाची बातमी कळताच तो त्याला लगबगीने भेटावयाला आला. त्याने त्याला मिठी मारली आणि त्याचे चुंबन घेतले आणि त्याला आपल्या घरी आणले आणि तिथे याकोबाने त्याला सर्व गोष्टी सांगितल्या. ");
INSERT INTO marc_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","तेव्हा लाबान त्याला म्हणाला, “तू माझे स्वतःचे मांस व रक्त आहेस.” याकोबाला तिथे राहून सुमारे एक महिना झाल्यानंतर, ");
INSERT INTO marc_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","लाबान त्याला म्हणाला, “आपण एकमेकांचे नातेवाईक असलो तरी त्यामुळे तू माझ्यासाठी फुकट काम करावे हे योग्य नाही. तू वेतन म्हणून काय घेशील?” ");
INSERT INTO marc_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबानाला दोन कन्या होत्या. वडील कन्येचे नाव लेआ व धाकटीचे नाव राहेल. ");
INSERT INTO marc_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लेआचे डोळे निस्तेज होते पण राहेल बांधेसूद व दिसायला सुंदर होती. ");
INSERT INTO marc_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकोबाचे राहेलवर प्रेम बसले होते, म्हणून तो म्हणाला, “मला तुमची धाकटी मुलगी राहेल पत्नी म्हणून द्याल, तर मी तुमच्यासाठी सात वर्षे काम करेन.” ");
INSERT INTO marc_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबान म्हणाला, “परकीय मनुष्याला तिला देण्यापेक्षा ती तुला देणेच उत्तम आहे. माझ्यासोबत इथे राहा.” ");
INSERT INTO marc_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","याप्रमाणे याकोबाने राहेलकरिता पुढील सात वर्षे काम केले. परंतु त्याचे तिच्यावर इतके प्रेम होते की, ही वर्षे त्याला काही दिवसांप्रमाणे भासली. ");
INSERT INTO marc_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","तेव्हा याकोब लाबानाला म्हणाला, “माझी पत्नी मला द्या. माझी मुदत संपली आहे, आता मला तिचा स्वीकार करता येईल.” ");
INSERT INTO marc_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","तेव्हा लाबानाने वस्तीतील सर्व लोकांना बोलाविले आणि मेजवानी दिली. ");
INSERT INTO marc_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","परंतु संध्याकाळी लाबानाने आपली कन्या लेआला याकोबाकडे पाठविले आणि याकोबाने तिच्याबरोबर रात्र घालविली. ");
INSERT INTO marc_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","आणि लाबानाने आपली दासी जिल्पा, त्याची कन्या लेआ हिला दासी म्हणून दिली. ");
INSERT INTO marc_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","पण याकोब सकाळी उठून पाहतो, तर ती लेआ होती! याकोब लाबानाला म्हणाला, “हे तुम्ही काय केले? मी राहेलसाठी सात वर्षे काम केले आणि तुम्ही माझी अशी फसवणूक का केली?” ");
INSERT INTO marc_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबानाने उत्तर दिले, “मोठ्या बहिणीचे लग्न झाल्याशिवाय धाकट्या बहिणीचे लग्न करून देण्याची आमच्यात प्रथा नाही. ");
INSERT INTO marc_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","लग्नाचा सप्ताह पूर्ण होऊ दे, मग माझ्यासाठी आणखी सात वर्षे काम करण्याचे तू वचन देत असशील तर राहेलही तुला मिळेल.” ");
INSERT INTO marc_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","याकोबाने त्याप्रमाणे केले. त्याने लेआसोबत संपूर्ण एक आठवडा घालविला, मग लाबानाने त्याला त्याची कन्या राहेल ही पत्नी म्हणून दिली. ");
INSERT INTO marc_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबानाने आपली दासी बिल्हा, त्याची कन्या राहेलला दासी म्हणून दिली. ");
INSERT INTO marc_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","मग याकोबाने राहेलचाही पत्नी म्हणून स्वीकार केला. तो तिच्यावर लेआपेक्षा अधिक प्रेम करी आणि तिच्यासाठी आणखी सात वर्षे तिथे राहून त्याने काम केले. ");
INSERT INTO marc_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","याकोब लेआला कमी प्रीती करीत आहे, म्हणून याहवेहने तिला गर्भधारणा करण्याचे सामर्थ्य दिले, पण राहेल वांझच राहिली. ");
INSERT INTO marc_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लेआ गर्भवती झाली व तिला एक पुत्र झाला आणि तिने त्याचे नाव रऊबेन असे ठेवले. कारण लेआ म्हणाली, “याहवेहने माझे दुःख पाहिले आहे. आता माझे पती माझ्यावर प्रेम करतील.” ");
INSERT INTO marc_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","लवकरच ती पुन्हा गर्भवती झाली आणि तिला दुसरा पुत्र झाला. तिने त्याचे नाव शिमओन असे ठेवले, कारण ती म्हणाली, “याहवेहने माझे ऐकले आहे, मी नावडती आहे म्हणून त्यांनी मला आणखी एक पुत्र दिला.” ");
INSERT INTO marc_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","मग ती पुन्हा गर्भवती झाली आणि तिला पुत्र झाला; आणि ती म्हणाली, “यावेळी माझे पती माझ्याशी पुन्हा जोडले जातील, कारण मी त्यांना तीन पुत्र दिले.” म्हणून त्याचे नाव लेवी असे ठेवण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ती पुन्हा एकदा गर्भवती झाली आणि तिला आणखी एक पुत्र झाला तिने त्याचे नाव यहूदाह असे ठेवले, कारण ती म्हणाली, “आता मी याहवेहची स्तुती करेन.” यानंतर तिला मूल होण्याचे थांबले. ");
INSERT INTO marc_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","राहेलने पाहिले की याकोबाला तिच्यापासून मूल होत नाही, तेव्हा ती आपल्या बहिणीचा मत्सर करू लागली. “मला मूल द्या, नाहीतर मी मरून जाईन,” ती याकोबास म्हणाली. ");
INSERT INTO marc_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","त्यामुळे याकोब संतापून राहेलला म्हणाला, “मी काय परमेश्वराच्या ठिकाणी आहे, ज्यांनी तुला मूल होण्यापासून रोखले आहे?” ");
INSERT INTO marc_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","मग ती म्हणाली, “तुम्ही माझी दासी बिल्हा हिचा स्वीकार करा. जेणेकरून ती माझ्यासाठी मुलांना जन्म देईल आणि मीही तिच्याद्वारे कुटुंब तयार करू शकेन.” ");
INSERT INTO marc_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","याप्रमाणे तिने आपली दासी बिल्हा, त्याला पत्नी म्हणून दिली, आणि याकोबाने तिचा स्वीकार केला, ");
INSERT INTO marc_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","आणि बिल्हा गर्भवती झाली व याकोबाच्या पुत्राला जन्म दिला, ");
INSERT INTO marc_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","राहेलने त्याचे नाव दान असे ठेवले, कारण ती म्हणाली, “परमेश्वराने मला न्याय दिला आहे; त्यांनी माझी विनंती मान्य केली आणि मला एक पुत्र दिला आहे.” ");
INSERT INTO marc_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेलची दासी बिल्हा ही पुन्हा गर्भवती झाली आणि तिने याकोबाच्या अजून एका पुत्राला जन्म दिला. ");
INSERT INTO marc_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","राहेलने त्याचे नाव नफताली असे ठेवले. कारण ती म्हणाली, “मी माझ्या बहिणीशी जोरदार संघर्ष करून विजयी झाले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","आपण पुन्हा गर्भवती होत नाही, हे लक्षात घेऊन लेआने आपली दासी जिल्पा याकोबाला पत्नी म्हणून दिली. ");
INSERT INTO marc_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","याकोबापासून लेआची दासी जिल्पाने एका पुत्राला जन्म दिला. ");
INSERT INTO marc_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","लेआ म्हणाली, “हा किती आशीर्वाद आहे!” म्हणून तिने त्याचे नाव गाद असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","लेआची दासी जिल्पाला याकोबापासून दुसरा पुत्र झाला. ");
INSERT INTO marc_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","लेआने त्याचे नाव आशेर ठेवले. कारण ती म्हणाली. “मी किती आनंदी आहे! स्त्रिया मला धन्य म्हणतील.” ");
INSERT INTO marc_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गव्हाच्या हंगामात रऊबेन शेतात काम करताना एके दिवशी त्याला पुत्रदात्रीची फळे सापडली. त्याने ती आपली आई लेआ हिला नेऊन दिली. तेव्हा राहेलने लेआजवळ विनंती केली, “तुझ्या मुलाने पुत्रदात्रीची फळे आणली आहेत, त्यातील काही मला दे.” ");
INSERT INTO marc_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","पण लेआ तिला म्हणाली, “माझा पती घेतलास तेवढे पुरे झाले नाही काय? आता माझ्या मुलाची पुत्रदात्रीची फळे देखील तू घेशील काय?” राहेल म्हणाली, “ठीक आहे. तुझ्या पुत्रदात्रीच्या फळांच्या मोबदल्यात, याकोब आज रात्री तुझ्याकडे येईल.” ");
INSERT INTO marc_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","जेव्हा संध्याकाळी याकोब शेतातून आला, लेआ त्याला भेटण्यासाठी बाहेर गेली. ती म्हणाली, “आज तुम्ही माझ्याबरोबर निजावे, कारण माझ्या मुलाची पुत्रदात्रीची फळे देऊन मी तुम्हाला त्या मोबदल्यात घेतले आहे.” त्याप्रमाणे त्या रात्री तो तिच्यासोबत निजला. ");
INSERT INTO marc_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","परमेश्वराने लेआचे ऐकले आणि ती पुन्हा गर्भवती होऊन तिने याकोबाच्या पाचव्या पुत्राला जन्म दिला. ");
INSERT INTO marc_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","तिने त्याचे नाव इस्साखार असे ठेवले. कारण लेआ म्हणाली, “माझ्या पतीला मी माझी दासी दिल्यामुळे परमेश्वराने मला हे प्रतिफळ म्हणून दिले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","नंतर लेआ याकोबापासून पुन्हा गर्भवती झाली आणि तिला सहावा पुत्र झाला. ");
INSERT INTO marc_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","तिने त्याचे नाव जबुलून असे ठेवले. कारण लेआ म्हणाली, “परमेश्वराने माझ्या पतीसाठी मला चांगल्या देणग्या दिल्या आहेत. कारण मी त्याच्या सहा पुत्रांना जन्म दिला आहे, आता ते मला माझा आदर करतील.” ");
INSERT INTO marc_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","काही वेळेनंतर तिने एका कन्येला जन्म दिला आणि तिचे नाव दीना असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","तेव्हा परमेश्वराला राहेलची आठवण झाली; त्यांनी तिचे ऐकले आणि तिला गर्भधारण करण्यास सक्षम केले. ");
INSERT INTO marc_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ती गर्भवती झाली आणि तिने एका पुत्राला जन्म दिला ती म्हणाली, “परमेश्वराने माझा काळिमा दूर केला आहे.” ");
INSERT INTO marc_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","तिने त्याचे नाव योसेफ असे ठेवले, आणि म्हणाली, “याहवेहने मला आणखी एक पुत्र द्यावा.” ");
INSERT INTO marc_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","राहेलने योसेफास जन्म दिल्यानंतर याकोब लाबानास म्हणाला, “माझी रवानगी करा म्हणजे मी माझ्या देशाला जाईन. ");
INSERT INTO marc_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","माझ्या स्त्रिया व मुले यासह मला जाऊ द्या. त्यांच्यासाठी मी तुमची किती सेवा केली आहे, हे तुम्हाला ठाऊक आहे.” ");
INSERT INTO marc_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","पण लाबान त्याला म्हणाला, “माझ्यावर तुझी कृपादृष्टी असेल तर कृपया थांब. तुझ्यामुळे याहवेहने मला आशीर्वाद दिला आहे हे मला भविष्यकथनाने कळले आहे. ");
INSERT INTO marc_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","तुला किती वेतन हवे ते मला सांग म्हणजे मी तुला तेवढे देईन.” ");
INSERT INTO marc_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकोब त्याला म्हणाला, “मी तुमची चाकरी कशी केली आणि तुमची गुरे माझ्या देखरेखीखाली कशी राहिली हे तुम्हाला माहीत आहे. ");
INSERT INTO marc_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","मी येण्यापूर्वी तुमच्याकडे जे होते ते खूप वाढले आहे आणि मी जिथे होतो तिथे याहवेहने तुम्हाला आशीर्वाद दिला आहे. पण माझ्या स्वतःच्या कुटुंबीयांकडे मी केव्हा लक्ष देणार?” ");
INSERT INTO marc_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","“मी तुला काय देऊ?” त्याने विचारले. “मला काहीही देऊ नका,” याकोबने उत्तर दिले. “पण जर तुम्ही माझ्यासाठी हे केले तर मी तुमच्या कळपांचे पालन करेन आणि त्यांचा सांभाळ करेन: ");
INSERT INTO marc_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","आज मला तुमचे सर्व कळप बघून घेऊ द्या म्हणजे मी त्यातून डाग व ठिपके असलेली मेंढरे व बोकडे आणि गडद रंगाची मेंढरे वेगळी करेन व तेच माझे वेतन होईल. ");
INSERT INTO marc_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","आणि जेव्हा तुम्ही मला दिलेले वेतन तपासाल तेव्हा भविष्यात माझा प्रामाणिकपणा माझ्यासाठी साक्ष देईल. म्हणजे माझ्या कळपात तुम्हाला एखादा डाग व ठिपके नसलेला बोकड किंवा मेंढा आढळला, तर मी तो तुमच्या कळपातून चोरून घेतला आहे, हे तुम्हाला समजेल.” ");
INSERT INTO marc_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबान म्हणाला, “ठीक आहे, तू म्हणतोस तसे होऊ दे.” ");
INSERT INTO marc_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","त्याच दिवशी लाबान आपल्या कळपात गेला आणि त्याने पट्टेदार आणि ठिपके असलेली बोकडे व डाग आणि ठिपके असलेल्या शेळ्या (ज्यांच्यावर पांढरा डाग होता) आणि गडद रंगांची मेंढरे वेगळी करून आपल्या पुत्रांच्या स्वाधीन केली. ");
INSERT INTO marc_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","नंतर त्याने त्यांच्यामध्ये आणि याकोबामध्ये तीन दिवसांच्या यात्रेचे अंतर ठेवले आणि याकोब लाबानाचे उर्वरित कळप राखू लागला. ");
INSERT INTO marc_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","मग याकोबाने चिनार, बदाम व अर्मोन वृक्षांच्या कोवळ्या फांद्या घेतल्या व त्यांची पांढरी अंतर्साल दिसेपर्यंत त्या सोलल्या. ");
INSERT INTO marc_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","त्या काठ्या त्याने कळपाच्या पाणी पिण्याच्या पन्हाळ्यात ठेवल्या, जेणेकरून जेव्हा ते पाणी पिण्याकरिता येतील तेव्हा ते थेट कळपांसमोर असतील. ");
INSERT INTO marc_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","त्या काठ्यांच्या समोर शेळ्यामेंढ्या फळत तेव्हा त्यांना पट्टेदार किंवा डाग असलेली किंवा ठिपकेदार करडे होत. ");
INSERT INTO marc_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","मग याकोबाने तरुण कळप बाजूला केला, परंतु लाबानाच्या कळपामधील पट्टेदार आणि गडद रंगाच्या मेंढ्यांकडे कळपांची तोंडे केली. अशा प्रकारे त्याने स्वतःसाठी वेगळे कळप बनविले आणि त्यांना लाबानाच्या प्राण्यांबरोबर ठेवले नाही. ");
INSERT INTO marc_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","जेव्हा तो मेंढरांशी आपल्या कळपातील धष्टपुष्ट माद्यांचा संबंध घडवून आणत असे, त्यावेळी सोललेल्या काठ्या याकोब त्यांच्यापुढे ठेवी. ");
INSERT INTO marc_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","पण जेव्हा दुबळ्या मेंढ्या फळत तेव्हा त्या काठ्या तो त्यांच्यापुढे ठेवीत नसे. त्यामुळे दुबळी मेंढरे लाबानाची व धष्टपुष्ट मेंढरे याकोबाची होत. ");
INSERT INTO marc_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","याचा परिणाम असा झाला की, याकोब खूप श्रीमंत झाला आणि पुष्कळ शेरडे, मेंढरे, दास, दासी, उंट आणि गाढवे त्याच्या मालकीची झाली. ");
INSERT INTO marc_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","याकोबाने लाबानाच्या पुत्रांचे म्हणणे ऐकले, “आमच्या वडिलांचे जे सर्वकाही होते ते याकोबाने घेतले आहे आणि ही सर्व संपत्ती त्याला जी मिळाली आहे ती आमच्या वडिलांची होती.” ");
INSERT INTO marc_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","आणि याकोबाला दिसून आले की लाबानची त्याच्याबद्दलची वृत्ती आता पूर्वीसारखी राहिली नाही. ");
INSERT INTO marc_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","तेव्हा याहवेह याकोबाशी बोलले आणि म्हणाले, “तू आता आपल्या वडिलांच्या व नातलगांच्या देशात परत जा आणि मी तुझ्याबरोबर असेन.” ");
INSERT INTO marc_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","तेव्हा याकोबाने राहेल व लेआ यांना ज्या शेतात तो कळप राखीत होता तिथे बोलावून घेतले. ");
INSERT INTO marc_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","तो त्यांना म्हणाला, “मी पाहतो की तुमच्या वडिलांची वृत्ती माझ्याशी पूर्वीसारखी राहिलेली नाही, पण माझ्या वडिलांचे परमेश्वर माझ्याबरोबर आहेत. ");
INSERT INTO marc_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","मी तुमच्या वडिलांची आपल्या सर्व शक्तिनिशी सेवा केली हे तुम्हाला माहीत आहे; ");
INSERT INTO marc_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","तरीपण तुमच्या वडिलांनी माझ्या वेतनाबाबत केलेला करार दहा वेळा बदलून मला फसविले आहे, तरी परमेश्वराने त्यांना माझे काही वाईट करू दिले नाही. ");
INSERT INTO marc_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","कारण ज्यावेळी त्यांनी म्हटले की, डाग असलेल्या शेळ्यामेंढ्या तुझ्या, त्यावेळी सर्व कळपांना डाग असलेली करडे होत. जेव्हा ते आपले मन बदलून म्हणत, पट्टेदार शेळ्यामेंढ्या तुझ्या, तेव्हा त्यांना सर्व पट्टेदार करडे होत. ");
INSERT INTO marc_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","अशा रीतीने तुमच्या वडिलांच्या शेळ्यामेंढ्या त्यांच्यापासून काढून परमेश्वराने ती मला दिली आहेत. ");
INSERT INTO marc_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“कळप फळावयाच्या ॠतूत मला स्वप्नात दिसले की, कळप फळविणारे बोकड पट्टेदार, डाग असलेले व ठिपकेदार आहेत. ");
INSERT INTO marc_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","मग स्वप्नामध्ये परमेश्वराच्या दूताने मला बोलावून म्हटले, ‘याकोबा,’ मी उत्तर दिले, ‘हा मी इथे आहे.’ ");
INSERT INTO marc_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","आणि त्यांनी मला सांगितले, ‘तुझी नजर वर कर आणि पाहा की, फळविणारे बोकड पट्टेदार, डाग असलेले व ठिपकेदार आहेत. कारण लाबानाने तुझ्याशी कसा व्यवहार केला हे सर्व मी पाहिले आहे. ");
INSERT INTO marc_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","मीच तुला बेथेलमध्ये भेटलेला परमेश्वर आहे. त्या ठिकाणी तू स्तंभाला तैलाभ्यंग करून शपथ वाहिली होती. आता तू हा देश सोडून आपल्या मायदेशी परत जा.’ ” ");
INSERT INTO marc_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","तेव्हा राहेल आणि लेआ यांनी उत्तर दिले, “आता आमच्या वडिलांच्या संपत्तीत आमचा काही वाटा राहिला आहे काय? ");
INSERT INTO marc_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ते आम्हाला परकियांसारखी वागणूक देत नाहीत काय? त्यांनी आम्हाला केवळ विकलेच नाही, तर आमच्याबद्दल मिळालेला सर्व मोबदला वापरून संपविला आहे. ");
INSERT INTO marc_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","आमच्या वडिलांकडून परमेश्वराने हे धन काढून घेतले आहे, ते निश्चितच आमचे आणि आमच्या मुलाबाळांचे धन आहे. म्हणून परमेश्वराने तुम्हाला सांगितले आहे तसे करा.” ");
INSERT INTO marc_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","मग याकोबाने आपल्या पत्नी व मुलांना उंटांवर बसविले ");
INSERT INTO marc_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","आणि त्याने आपल्यापुढे कळप हाकीत, पद्दन-अराम येथे मिळालेली सर्व मालमत्ता घेऊन त्याचे वडील इसहाक याचा देश कनान इथे जाण्यास निघाला. ");
INSERT INTO marc_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","जेव्हा लाबान आपल्या मेंढरांची लोकर कातरण्यास गेला असताना, राहेलने आपल्या वडिलांच्या कुलदैवतांच्या मूर्ती चोरल्या. ");
INSERT INTO marc_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","याकोब अरामी लाबानाला काहीही न सांगता त्याला फसवून पळाला. ");
INSERT INTO marc_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","अशा रीतीने आपली सर्व चीजवस्तू घेऊन, फरात नदी ओलांडून ते सर्वजण गिलआद डोंगराळ प्रदेशाच्या वाटेला लागले. ");
INSERT INTO marc_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","याकोब पळून गेला आहे, हे लाबानाला तिसर्‍या दिवशी सांगण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","तेव्हा आपले नातलग बरोबर घेऊन त्याने त्यांचा पाठलाग केला आणि त्यांना सातव्या दिवशी गिलआद डोंगरावर गाठले. ");
INSERT INTO marc_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","पण रात्रीच्या स्वप्नात परमेश्वर अरामी लाबानकडे आले आणि म्हणाले, “सावध राहा, तू याकोबाला चांगले किंवा वाईट असे काहीही म्हणू नकोस.” ");
INSERT INTO marc_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","लाबानाने याकोबास गाठले तेव्हा याकोब गिलआद डोंगरमाथ्यावर तळ देऊन राहिला होता. मध्यंतरीच्या काळात लाबानानेदेखील आपला तळ डोंगराच्या पायथ्याशी दिला. ");
INSERT INTO marc_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","लाबानाने याकोबाला विचारले, “हे तू काय केलेस? तू मला फसविले आणि माझ्या मुली युद्धबंदिसारख्या पळवून नेत आहेस? ");
INSERT INTO marc_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","असे गुप्तपणे पळून तू मला का फसविले? तू मला का सांगितले नाही, जेणेकरून झांज व वीणेचे गायन-वादन करून समारंभाने आनंदाने निरोप देण्याची मला संधी मिळाली असती? ");
INSERT INTO marc_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","माझ्या नातवंडाचा निरोप घेण्यापूर्वी, तू मला त्यांची चुंबने देखील घेऊ दिली नाहीस. ही मूर्खपणाची वागणूक आहे. ");
INSERT INTO marc_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","मी तुझे नुकसान करू शकलो असतो, पण तुझ्या पूर्वजांचे परमेश्वर काल रात्री मला म्हणाले, ‘सावध राहा, तू याकोबला चांगले किंवा वाईट असे काहीही म्हणू नकोस.’ ");
INSERT INTO marc_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","आता तुला जावेसे वाटते कारण तुझ्या नातलगांमध्ये परतण्याची तुला आतुरता आहे. पण तू माझी कुलदैवते का चोरलीस?” ");
INSERT INTO marc_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकोबाने लाबानास उत्तर दिले, “मला भीती वाटत होती की तुम्ही आपल्या मुली माझ्यापासून बळजबरीने काढून घ्याल. ");
INSERT INTO marc_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","पण ज्याच्याकडून तुम्हाला तुमची कुलदैवते मिळतील, तो जिवंत राहणार नाही. आपल्या नातेवाईकांच्या उपस्थितीत, माझ्याबरोबर येथे तुमचे काही आहे की नाही ते स्वतःच पाहा; आणि असल्यास, ते घ्या.” राहेलने त्या मूर्ती चोरल्या होत्या हे याकोबाला माहीत नव्हते. ");
INSERT INTO marc_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","लाबान याकोबाच्या तंबूमध्ये गेला. लेआच्या तंबूमध्ये आणि मग दोन दासींच्या तंबूंमध्ये गेला, पण त्याला काही सापडले नाही. नंतर तो लेआच्या तंबूमधून निघून राहेलच्या तंबूमध्ये गेला. ");
INSERT INTO marc_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","आता राहेलने त्या कुलदैवतांच्या मूर्ती चोरून आपल्या उंटाच्या खोगिरामध्ये लपवून ठेवल्या होत्या आणि ती त्या खोगिरावर बसली होती. लाबानाने तिच्या तंबूमध्ये कसून शोध केला तरी त्याला त्या सापडल्या नाहीत. ");
INSERT INTO marc_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राहेल त्याला म्हणाली, “बाबा मी तुमच्यापुढे उभी राहू शकत नाही कारण मी ॠतुमती आहे.” अशाप्रकारे त्याने शोध केला, परंतु त्याला कुलदैवतांच्या मूर्ती आढळल्या नाही. ");
INSERT INTO marc_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तेव्हा याकोबाला लाबानाचा खूप संताप आला. त्याने रागाने विचारणा केली, “माझा काय अपराध आहे? मी कोणता गुन्हा केला आहे, की तुम्ही माझा पाठलाग करीत आहात? ");
INSERT INTO marc_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","माझ्या सर्व सामानाची झडती घेतलीत. आता मी तुमचे जे काही चोरले असेल, ते तुमच्या आणि माझ्या लोकांच्या पुढे ठेवा. त्यांनाच ते पाहू द्या आणि ते कोणाचे आहे हे ठरवू द्या. ");
INSERT INTO marc_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“वीस वर्षे मी तुमच्याबरोबर राहिलो. त्या काळात तुमच्या मेंढ्या व शेळ्या यांचा कधीही गर्भपात झाला नाही किंवा मी तुमच्या कळपातील एकाही एडक्याला खाल्ले नाही. ");
INSERT INTO marc_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","मी तुमच्याकडे वनपशूंनी फाडलेले प्राणी आणले नाहीत; मी स्वतः नुकसान सहन केले आणि दिवसा किंवा रात्री जे काही चोरीला गेले त्याबद्दल तुम्ही माझ्याकडून भरून घेतले. ");
INSERT INTO marc_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","माझी परिस्थिती अशी होती: दिवसभर उन्हाचा आणि रात्री थंडीच्या कहराचा त्रास होत असे आणि झोप माझ्या डोळ्यावरून उडून जात असे. ");
INSERT INTO marc_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","अशा स्थितीत मी वीस वर्षे काढली. चौदा वर्षे तुमच्या दोन मुली मिळविण्याकरिता आणि सहा वर्षे कळप मिळविण्याकरिता आणि तेवढ्या काळात तुम्ही दहा वेळेस माझ्या वेतनात फेरबदल केला. ");
INSERT INTO marc_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","जर माझे पिता इसहाकाचे परमेश्वर, अब्राहामाचे परमेश्वर आणि इसहाकास ज्यांचे भय वाटते, ते माझ्यासह नसते, तर तुम्ही मला रिकामी हाताने पाठवून दिले असते. पण परमेश्वराने माझे परिश्रम व माझ्या हातांनी केलेले कष्ट पाहिले आणि म्हणूनच त्यांनी तुम्हाला काल रात्री दर्शन देऊन धमकाविले.” ");
INSERT INTO marc_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","यावर लाबानाने याकोबास उत्तर दिले, “या स्त्रिया माझ्या मुली आहेत; ही मुलेबाळेही माझी आहेत; हे कळप व तुझे जे आहे ते सर्व माझेच आहे. तेव्हा माझ्या कन्या व त्यांची संतती यांचे मी आता करू? ");
INSERT INTO marc_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","तर चल, आपण दोघे म्हणजे तू आणि मी शांतीचा करार करू आणि तो तुझ्या माझ्यामध्ये साक्ष होवो.” ");
INSERT INTO marc_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","तेव्हा याकोबाने स्तंभ म्हणून एक धोंडा उभा केला; ");
INSERT INTO marc_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","आणि याकोबाने आपल्या नातेवाईकांना म्हटले, “काही दगड गोळा करा.” त्यांनी त्यांची रास केली, मग त्या सर्वांनी दगडाच्या राशी जवळ बसून एकत्र भोजन केले. ");
INSERT INTO marc_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","मग त्या राशीला लाबानाच्या भाषेत यगर-सहदूथा आणि याकोबाच्या भाषेत गलेद असे नाव दिले. ");
INSERT INTO marc_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान म्हणाला, “आपल्या दोघांपैकी कोणीही एकमेकांविरुद्ध अतिक्रमण केले, तर ही दगडांची रास त्याला साक्षी राहील.” याकारणास्तव या जागेला गलेद म्हणतात. ");
INSERT INTO marc_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","यावरून तिला मिस्पाह असेही नाव देण्यात आले; कारण लाबान म्हणाला, “आपण एकमेकांपासून दूर जाऊ तेव्हा आपण आपला करार पाळू, याहवेह आपल्यावर लक्ष ठेवो.” ");
INSERT INTO marc_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","तू माझ्या मुलींना निर्दयतेने वागविलेस किंवा अन्य स्त्रिया केल्यास, “जरी आपल्यासोबत कोणीही नसेल, तरीपण परमेश्वर तुझ्यात व माझ्यात साक्षी आहेत.” ");
INSERT INTO marc_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","लाबान आणखी याकोबास म्हणाला, “ही रास आणि हा स्तंभ तुझ्या व माझ्या दरम्यान ठेवला आहे. ");
INSERT INTO marc_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","हे ओलांडून मी तुझ्यावर हल्ला करणार नाही किंवा तू देखील ही रास व हा स्तंभ ओलांडून माझ्यावर हल्ला करणार नाही. ही रास व स्तंभ याची साक्ष आहे. ");
INSERT INTO marc_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहामाचे परमेश्वर आणि नाहोराचे परमेश्वर आणि त्याच्या पित्याचे परमेश्वर, आमच्यामध्ये न्याय करोत.” मग याकोबाने त्याचे वडील इसहाकाला ज्यांचे भय होते त्यांच्या नावाने शपथ घेतली. ");
INSERT INTO marc_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","नंतर याकोबाने डोंगराच्या माथ्यावर परमेश्वराला एक अर्पण वाहिले. त्याने आपल्या सर्व नातलगांना मेजवानीस बोलाविले आणि त्यांनी भोजन करून ती सर्व रात्र त्या डोंगरावर घालविली. ");
INSERT INTO marc_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","लाबान दुसर्‍या दिवशी सकाळीच उठला व त्याने आपल्या कन्यांची व नातवंडांची चुंबने घेतली, त्यांना आशीर्वाद दिला आणि मग तो घरी परत गेला. ");
INSERT INTO marc_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकोब आपल्या वाटेने जात असता परमेश्वराचा दूत त्यास भेटले. ");
INSERT INTO marc_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","जेव्हा याकोबाने त्यांना पाहिले, तो म्हणाला, “या ठिकाणी परमेश्वराचे सैन्यतळ आहे!” म्हणून त्याने त्या ठिकाणाचे नाव महनाईम असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकोबाने आता एदोम प्रांतातील सेईर प्रदेशात राहणारा आपला भाऊ एसाव, याच्याकडे आपले दूत पाठविले; ");
INSERT INTO marc_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","आणि त्याने दूतांना आज्ञा दिली की, तुम्ही माझा धनी एसाव याला जाऊन सांगा: “तुमचा सेवक याकोब म्हणतो, मी आतापर्यंत आपले मामा लाबान यांच्याकडे राहत होतो. ");
INSERT INTO marc_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","आता मी गुरे, गाढवे, मेंढरे, पुष्कळ स्त्रीपुरुष चाकर यांचा धनी झालो आहे. मी हा निरोप तुमच्याकडे पाठवित आहे कि तुमची कृपादृष्टी माझ्यावर होऊ द्यावी.” ");
INSERT INTO marc_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","निरोप्यांनी परत येऊन याकोबास सांगितले की, “आपला भाऊ एसाव चारशे लोक बरोबर घेऊन तुम्हाला भेटण्यासाठी येत आहे.” ");
INSERT INTO marc_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","हे ऐकताच याकोबाने भीतीने व व्याकूळ होऊन आपले कुटुंबीय, गुरे, शेरडेमेंढरे आणि उंट यांची दोन गटांमध्ये विभागणी केली. ");
INSERT INTO marc_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","त्याने विचार केला, “एसावाने एका गटावर हल्ला केला तर दुसर्‍या गटाला कदाचित निसटून जाता येईल.” ");
INSERT INTO marc_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","मग याकोबाने प्रार्थना केली, “हे याहवेह, माझे पिता अब्राहाम, आणि माझे पिता इसहाक यांच्या परमेश्वरा, तुम्ही मला माझ्या देशात आणि नातलगात परत येण्यास सांगितले व मला समृद्ध करण्याचे वचन दिले आहे. ");
INSERT INTO marc_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तुम्ही मला वचन दिल्याप्रमाणे जी वात्सल्य आणि विश्वसनीयता वारंवार दाखविलीस तिला वास्तविक मी पात्र नाही; मी यार्देनेच्या पलीकडे गेलो तेव्हा माझ्याजवळ एका काठीशिवाय दुसरे काहीही नव्हते आणि आता माझे दोन गट झाले आहेत. ");
INSERT INTO marc_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","तुम्ही माझी विनंती ऐकून, माझा भाऊ एसावच्या हातून मला वाचवा, मला त्याची भीती वाटते की तो येऊन मला आणि त्यांच्या आईसह मुलांनाही मारून टाकेल. ");
INSERT INTO marc_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","परंतु तुम्ही मला समृद्ध करण्याचे आणि माझे वंशज समुद्रातील वाळूप्रमाणे अगणित करण्याचे वचन दिले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","त्या रात्री याकोब तिथेच राहिला आणि आपल्याजवळ होते त्यातून त्याने आपला भाऊ एसाव याच्यासाठी एक भेट तयार केली: ");
INSERT INTO marc_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","त्यासाठी त्याने दोनशे शेळ्या, वीस बोकड, दोनशे मेंढ्या व वीस एडके, ");
INSERT INTO marc_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","तीस दुभत्या मादी उंट व त्यांची बछडी, चाळीस गाई, दहा बैल, वीस गाढवी, दहा शिंगरे, एवढी जनावरे बाजूला काढली. ");
INSERT INTO marc_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","प्रत्येक जातीच्या जनावरांचे वेगवेगळे कळप करून त्यांना नोकरांकडे सुपूर्द करून सूचना दिली, “माझ्यापुढे चला आणि प्रत्येक कळपामध्ये काही अंतर ठेवा.” ");
INSERT INTO marc_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","पहिला कळप नेणार्‍या नोकराला त्याने सांगितले: “जेव्हा माझा भाऊ एसाव तुम्हाला भेटेल आणि त्याने विचारले, ‘तुम्ही कोणाचे चाकर आहात, तुम्ही कुठे चालला आहात, ही जनावरे जी तुझ्यापुढे आहे ती कोणाची आहेत?’ ");
INSERT INTO marc_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","त्याला उत्तर द्या, ‘ही जनावरे तुमचा सेवक याकोब याची आहेत. ही त्याने आपला धनी एसावच्या भेटीदाखल पाठविली आहेत. तो स्वतः आमच्या पाठोपाठ येत आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","याकोबाने दुसर्‍या, तिसर्‍या आणि इतर कळप हाकणार्‍याला सूचना दिली: “एसाव जेव्हा तुम्हाला भेटेल तेव्हा तुम्हीही हाच निरोप दिला पाहिजे. ");
INSERT INTO marc_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","हे निश्चित बोला, ‘आपला दास याकोब आमच्या मागून येत आहे.’ ” कारण त्याने विचार केला, “मी एसावाला समोरासमोर भेटण्यापूर्वी त्याला भेटी देऊन संतुष्ट करेन; मग तो जेव्हा मला भेटेल, तेव्हा तो माझा स्वीकार करेल.” ");
INSERT INTO marc_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","म्हणूनच आपल्यापुढे भेटी पाठवली आणि याकोबाने ती रात्र तळावरच घालविली. ");
INSERT INTO marc_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","परंतु त्या रात्रीच याकोब उठला आणि त्याने त्याच्या दोन्ही पत्नी व उपपत्नी आणि अकरा मुले यांना जागे केले आणि यार्देन नदीच्या किनार्‍याने त्यांना यब्बोक नदीच्या उताराने पार नेले ");
INSERT INTO marc_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","त्याने त्यांना नदीच्या पलीकडे पाठविल्यावर त्याची सर्व संपत्तीही त्यांच्या पाठोपाठ पलीकडे पाठविली. ");
INSERT INTO marc_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","तिथे याकोब एकटाच होता. त्याचवेळी कोणा पुरुषाने सूर्योदय होईपर्यंत त्याच्याशी झोंबी केली. ");
INSERT INTO marc_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","याकोबावर जय मिळणे शक्य नाही, असे पाहून त्या पुरुषाने याकोबाच्या जांघेवर प्रहार केला आणि तो सांधा त्याने उखडून टाकला. ");
INSERT INTO marc_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","मग तो याकोबाला म्हणाला, “मला आता जाऊ दे, कारण पहाट होत आहे.” पण याकोब म्हणाला, “तू मला आशीर्वाद दिल्यावाचून मी तुला जाऊ देणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","मग त्याने याकोबास विचारले, “तुझे नाव काय आहे?” तेव्हा त्याने उत्तर दिले, “याकोब.” ");
INSERT INTO marc_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","यावर तो मनुष्य म्हणाला, “आता तुझे नाव याकोब राहणार नाही, तर ‘इस्राएल’ असे पडेल; कारण तू परमेश्वराशी व मनुष्याशीही संघर्ष करून यशस्वी झाला.” ");
INSERT INTO marc_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","मग याकोबाने त्याला विचारले, “कृपया आपले नाव मला सांगा.” तेव्हा तो म्हणाला, “तू मला माझे नाव का विचारतोस?” मग त्याने याकोबाला आशीर्वाद दिला. ");
INSERT INTO marc_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","मग याकोबाने त्या ठिकाणाचे नाव पनीएल असे ठेवले, कारण तो म्हणाला, “मी परमेश्वराचे मुख पाहिले आणि तरीही मी जिवंत राहिलो.” ");
INSERT INTO marc_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","जेव्हा याकोब पेनुएल मधून निघाला त्यावेळी सूर्य उगवला होता आणि त्याच्या जांघेचा सांधा उखडल्यामुळे तो लंगडत होता. ");
INSERT INTO marc_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","याच कारणास्तव इस्राएलचे लोक अजूनही जनावरांच्या जांघेतील धोंडशिरा खात नाहीत, कारण त्याने याकोबाच्या जांघेच्या स्नायुला स्पर्श केला होता. ");
INSERT INTO marc_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","नंतर दूर अंतरावरून एसाव आपल्या चारशे माणसांबरोबर येत आहे असे याकोबाने पाहिले, तेव्हा त्याने लेआ व राहेल व दोघी दासी यांच्याजवळ मुले वाटून दिली. ");
INSERT INTO marc_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","सर्वात पुढे त्याने आपल्या दासी आणि त्यांची मुले; त्यांच्यामागे लेआ व तिची मुले आणि त्यांच्यानंतर राहेल व योसेफ अशा रीतीने त्यांना ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","तो स्वतः सर्वांच्या पुढे चालला आणि आपल्या भावाजवळ जाऊन पोहोचेपर्यंत त्याने त्याला भूमीपर्यंत लवून सात वेळा मुजरा केला. ");
INSERT INTO marc_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","एसाव हा याकोबास भेटण्यास धावत आला; त्याने त्याला आलिंगन दिले; त्याला कवेत घेऊन त्याचे चुंबन घेतले आणि ते दोघे रडले. ");
INSERT INTO marc_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","एसावाने दृष्टी वर करून त्या स्त्रिया व मुलांकडे पाहिले तेव्हा त्याने विचारले, “तुजबरोबर हे लोक कोण आहेत?” याकोब म्हणाला, “परमेश्वराने कृपा करून तुमच्या दासाला दिलेली ही माझी मुले आहेत.” ");
INSERT INTO marc_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","तेव्हा याकोबाच्या दासी आणि त्यांची मुले पुढे आली आणि त्यांनीही त्याला लवून नमस्कार केला. ");
INSERT INTO marc_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","त्यानंतर लेआ व तिची मुले आली, शेवटी राहेल आणि योसेफ पुढे आली. त्यांनीही त्याला लवून नमस्कार केला. ");
INSERT INTO marc_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसावाने विचारले, “जी गुरे व कळप मला भेटले त्याचा उद्देश काय आहे?” याकोब म्हणाला, “माझ्या धन्या, तुझ्या दृष्टीत मी कृपा पावावे म्हणून.” ");
INSERT INTO marc_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","यावर एसाव म्हणाला, “भाऊ, माझ्याजवळ भरपूर आहे; तुझे आहे ते तुलाच राहू दे.” ");
INSERT INTO marc_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","“नाही, नाही!” याकोब म्हणाला, “जर तुमची माझ्यावर कृपा झाली असल्यास या भेटींचा तुम्ही स्वीकार करा. कारण तुम्ही आता मला स्वीकारले आहे म्हणून तुमचे मुख बघून परमेश्वराचे मुख बघितल्यासारखे वाटते. ");
INSERT INTO marc_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","माझ्या देणग्यांचा कृपया स्वीकार करा, कारण परमेश्वराने माझ्यावर दया केली आहे आणि त्यांनी मला सर्वकाही भरपूर दिले आहे.” याकोबाने फारच आग्रह केल्यामुळे एसावाने शेवटी त्या भेटींचा स्वीकार केला. ");
INSERT INTO marc_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","मग एसाव त्याला म्हणाला, “चला, आता आपण वाटेस लागून पुढे जाऊ या. मी तुझ्यासोबत चालतो.” ");
INSERT INTO marc_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","पण याकोब त्यास म्हणाला, “काही मुले फार लहान आहेत हे माझ्या स्वामीला दिसतच आहे आणि दूध पाजणार्‍या शेळ्या, मेंढ्या व गाई यांचेही मला पाहिले पाहिजे. त्यांना मी दिवसभर असेच हाकीत नेले तर ती जनावरे मरून जातील. ");
INSERT INTO marc_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","म्हणून मी माझ्या स्वामींना विनंती करतो की, आपण आपल्या सेवकापुढे जावे. आम्ही त्यांच्यामागे त्यांना चालवेल तसे हळूहळू चालत येऊन सेईर येथे तुम्हाला भेटू.” ");
INSERT INTO marc_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","मग एसाव म्हणाला, “माझी काही माणसे तुमच्याबरोबर ठेवू द्या.” “पण हे का करावे?” याकोब म्हणाला, “माझ्या स्वामींची कृपादृष्टी मजवर असली म्हणजे पुरे.” ");
INSERT INTO marc_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","तेव्हा एसाव त्याच दिवशी सेईरला परत जाण्यास निघाला. ");
INSERT INTO marc_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","दरम्यान याकोब सुक्कोथ येथे गेला. तिथे त्याने स्वतःसाठी तंबू आणि आपल्या गुरांसाठी निवारा बांधला. म्हणूनच त्या ठिकाणाला सुक्कोथ असे नाव पडले. ");
INSERT INTO marc_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","यानंतर याकोब पद्दन-अरामचा प्रवास पूर्ण करून कनान देशातील शेखेम नावाच्या शहरात सुखरुपपणे पोहोचला आणि शहराच्या बाहेर त्याने आपला तळ दिला. ");
INSERT INTO marc_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","जिथे त्याने तळ दिला होता तेथील जमिनीचा काही भाग त्याने शेखेमचा पिता हमोर याच्याकडून शंभर चांदीची नाणी देऊन विकत घेतला. ");
INSERT INTO marc_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","मग तिथे त्याने एक वेदी बांधून तिचे नाव त्याने एल एलोहे इस्राएल असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","एके दिवशी याकोबापासून झालेली लेआची कन्या दीना त्या देशातील मुलींना भेटावयास गेली. ");
INSERT INTO marc_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","तेव्हा त्या देशाचा अधिपती हमोर नावाचा हिव्वी याचा पुत्र शेखेम, याने तिला पाहिले, तेव्हा तो तिला घेऊन गेला आणि तिच्यावर बलात्कार करून त्याने तिला भ्रष्ट केले. ");
INSERT INTO marc_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","याकोबाची मुलगी दीना हिच्यावर त्याचे हृदय आकर्षित झाले; त्याने त्या तरुण स्त्रीवर प्रेम केले आणि तो कोमलतेने तिच्याशी बोलला. ");
INSERT INTO marc_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","मग शेखेमने आपले वडील हमोर यांना म्हणाला, “ही मुलगी मला पत्नी करून द्या.” ");
INSERT INTO marc_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","आपली कन्या दीना हिला शेखेमने भ्रष्ट केले आहे हे याकोबाने ऐकले त्यावेळी त्याचे पुत्र रानात गुरांबरोबर होते; म्हणून ते घरी परत येईपर्यंत त्याने त्याबाबत काहीही केले नाही. ");
INSERT INTO marc_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","मग जेव्हा शेखेमचा बाप हमोर याकोबाकडे आपल्या मुलाच्या विवाहासंबंधी बोलणी करावयास आला. ");
INSERT INTO marc_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","तेवढ्यात याकोबाचे पुत्रही रानातून घरी आले. शेखेमने इस्राएलात अशी भयानक गोष्ट करून याकोबाच्या कन्येला भ्रष्ट केल्याचे वृत ऐकून त्यांना मोठा धक्का बसला आणि ते संतप्त झाले कारण ही अपमानजनक गोष्ट घडणे अत्यंत घृणास्पद होते. ");
INSERT INTO marc_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","हमोर त्यांना म्हणाला, “माझा मुलगा शेखेम याचे हृदय तुमच्या मुलीकडे आकर्षित झाले आहे, म्हणून तिला त्याची पत्नी म्हणून द्या. ");
INSERT INTO marc_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","आमच्याशी सोयरीक करा; आम्हाला तुमच्या मुली द्या आणि आमच्या मुली तुमच्यासाठी घ्या. ");
INSERT INTO marc_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","आमच्याबरोबर राहा; हा देश तुमच्यासमोर मोकळा आहे, त्यात राहा आणि व्यापार करा आणि मालमत्ता प्राप्त करा.” ");
INSERT INTO marc_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","मग शेखेम, दीनाचे वडील व भाऊ यांना उद्देशून म्हणाला, “माझ्यावर एवढी कृपादृष्टी करा, तुम्ही जे मागाल ते मी देईन. ");
INSERT INTO marc_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","तुम्ही वधूबद्दल वाटेल तितका हुंडा आणि भेट मागा, मी ती तुम्हाला देईन, पण ती मुलगी मला पत्नी म्हणून द्या.” ");
INSERT INTO marc_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","आपली बहीण दीना हिला शेखेमने भ्रष्ट केले म्हणून याकोबाच्या पुत्रांनी शेखेम आणि त्याचा पिता हमोर यांच्याशी मनात कपट धरून बोलणी केली. ");
INSERT INTO marc_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ते म्हणाले, “आमची बहीण शेखेमाला देणे आम्हाला जमणार नाही, कारण तुमची सुंता झालेली नाही. अशा बेसुंती मनुष्याबरोबर विवाह केल्यास आमचा अपमान होईल. ");
INSERT INTO marc_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","आता आपण एक करार करू: जर तुमच्या देशातील प्रत्येक पुरुष आपली सुंता करून घेईल, ");
INSERT INTO marc_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","तर तुमच्या मुली आम्ही करू व आमच्या मुली तुम्हाला देऊ व आम्ही तुमच्यामध्ये स्थायिक होऊ आणि तुमच्याबरोबर एक लोक होऊ. ");
INSERT INTO marc_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","जर तुम्ही सुंता करण्यास तयार होणार नाही तर आम्ही तिला आमच्याबरोबर घेऊन आमची वाट धरू.” ");
INSERT INTO marc_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","त्यांचा प्रस्ताव हमोर आणि त्याचा मुलगा शेखेम यांना चांगला वाटला. ");
INSERT INTO marc_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","तो तरुण, जो त्याच्या वडिलांच्या घराण्यात सर्वात आदरणीय होता, त्याने जे सांगितले ते करण्यात वेळ घालविला नाही, कारण याकोबाच्या मुलीवर त्याचे खूप मन बसले होते. ");
INSERT INTO marc_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","म्हणून हमोर आणि शेखेम यांनी त्या शहरातील वेशीकडे जाऊन लोकांपुढे सुंतेची ही सूचना मांडली. ");
INSERT INTO marc_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","ते म्हणाले, “हे लोक आपले मित्र आहेत. त्यांना आपण आपल्यात राहण्याचे आमंत्रण देऊ आणि व्यापार करण्यास परवानगी देऊ; कारण आपला देश त्यांनाही पुरेल इतका मोठा असून त्यांना येथे सहज राहता येईल आणि त्यांच्या मुली आपण स्त्रिया करून घेऊ आणि आपण आपल्या मुली त्यांना देऊ. ");
INSERT INTO marc_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","परंतु ते लोक आपल्यात राहून राष्ट्राशी एकरूप होण्यास एकाच अटीवर तयार आहेत. ती अट म्हणजे आपल्यातील प्रत्येक पुरुषाने त्यांच्याप्रमाणेच स्वतःची सुंता करून घेतली पाहिजे. ");
INSERT INTO marc_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","तेव्हा त्यांची ही अट आपण मान्य करू या, म्हणजे ते आपल्यामध्ये वस्ती करतील. आपण हे केले तर त्यांची शेरडेमेंढरे, गुरे व मालमत्ता ते सर्व आपले होणार नाही का?” ");
INSERT INTO marc_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","हमोर आणि शेखेम यांच्या या गोष्टीला सर्व पुरुषांनी मान्यता दिली. ते त्या नगराच्या वेशीबाहेर आले आणि त्या सर्वांची सुंता करण्यात आली. ");
INSERT INTO marc_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","परंतु तीन दिवसानंतर, त्यांच्या जखमांमुळे ते वेदनेत असताना, याकोबाच्या पुत्रांपैकी दीनाचे दोन भाऊ शिमओन व लेवी, यांनी आपल्या हाती तलवारी घेतल्या, ते बेसावध असलेल्या शहरात शिरले आणि त्यांनी तेथील प्रत्येक पुरुषाची कत्तल केली. ");
INSERT INTO marc_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","हमोर आणि शेखेम यांचीही त्यांनी तलवारीने कत्तल केली. त्यांनी दीनाची शेखेमाच्या घरातून सुटका केली आणि तिला घेऊन ते परत आले. ");
INSERT INTO marc_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","यानंतर याकोबाचे सर्व पुत्र शहरात गेले आणि त्यांनी ते संपूर्ण शहर लुटले, जिथे त्यांच्या बहिणीला भ्रष्ट केले होते. ");
INSERT INTO marc_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","त्यांनी त्यांचे कळप, गुरे, गाढवे आणि त्यांच्या नगरात व शेतात असलेले सर्वकाही त्यांनी नेले. ");
INSERT INTO marc_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","तसेच त्यांच्या घरातील सर्व संपत्ती आणि त्यांच्या सर्व स्त्रिया व लेकरे, त्यांना जे काही घरात सापडले ते सर्व त्यांनी लुटले. ");
INSERT INTO marc_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","तेव्हा याकोब, शिमओन व लेवी यांना म्हणाला, “या भूमीतील सर्व कनानी व परिज्जी लोकांना माझी किळस येईल असे वर्तन तुम्ही केले आहे. आपण अगदी थोडके आहोत; ते आपल्यावर चालून येतील आणि आपल्याला चिरडून टाकतील व आपण सर्वजण मारले जाऊ.” ");
INSERT INTO marc_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","यावर त्यांनी प्रत्युत्तर केले, “त्याने आमच्या बहिणीशी एखाद्या वेश्येप्रमाणे व्यवहार करावा काय?” ");
INSERT INTO marc_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","मग परमेश्वराने याकोबाला म्हटले, “ऊठ आणि बेथेलला जाऊन तिथेच स्थायिक हो. तुझा भाऊ एसाव, याच्यापासून तू पळून जात असता, ज्या परमेश्वराने तुला दर्शन दिले होते, तिथे त्याच परमेश्वरासाठी एक वेदी बांध.” ");
INSERT INTO marc_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","म्हणून याकोब आपल्या सर्व कुटुंबीयांना व बरोबरच्या सर्वांना म्हणाला, “तुम्ही बरोबर आणलेल्या परक्या दैवतांचा नाश करा, शुद्ध व्हा, आपली वस्त्रे बदला. ");
INSERT INTO marc_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","चला आपण आता वर बेथेलला जाऊ या. ज्या परमेश्वराने माझ्या संकटसमयी माझ्या प्रार्थनेचे उत्तर दिले आणि मी जिथे कुठे गेलो तिथे माझ्याबरोबर राहिले, त्या परमेश्वरासाठी मी तिथे एक वेदी बांधणार आहे.” ");
INSERT INTO marc_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","तेव्हा त्या सर्वांनी आपल्याकडील इतर दैवताच्या मूर्ती व कर्णफुले याकोबाला दिली व त्याने ती शेखेमजवळ असलेल्या एका एला वृक्षाखाली पुरून टाकली. ");
INSERT INTO marc_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","मग ते पुन्हा पुढे निघाले आणि त्यांच्याभोवती असलेल्या सर्व नगरांवर परमेश्वराचे भय पडले, त्यामुळे त्यांनी याकोबाचा पाठलाग केला नाही. ");
INSERT INTO marc_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","शेवटी याकोब आणि त्याच्यासोबतचे सर्व लोक कनान देशातील लूज (याला बेथेल असेही नाव होते) येथे येऊन पोहोचले. ");
INSERT INTO marc_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","त्या ठिकाणी याकोबाने एक वेदी उभारली व त्या वेदीचे नाव त्याने एल बेथेल असे ठेवले; कारण तो एसावापासून पळून जात असता परमेश्वराने येथेच त्याला दर्शन दिले होते. ");
INSERT INTO marc_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","यानंतर लवकरच रिबेकाहची वृद्ध दाई दबोरा, ही मरण पावली आणि बेथेलच्या खोर्‍यात एका एला वृक्षाखाली तिला मूठमाती देण्यात आली. तेव्हापासून त्या वृक्षाला अल्लोन-बकूथ असे नाव पडले. ");
INSERT INTO marc_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","याकोब पद्दन-अराम वरून बेथेल येथे आला तेव्हा परमेश्वराने त्याला पुन्हा एकदा दर्शन देऊन आशीर्वाद दिला. ");
INSERT INTO marc_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","परमेश्वर त्याला म्हणाले, “तुझे नाव याकोब आहे, पण आता येथून पुढे, तुला याकोब म्हणजे ‘ठक’ असे म्हणणार नाहीत, तर इस्राएल असे म्हणतील.” याप्रकारे त्याला इस्राएल हे नाव देण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","परमेश्वर त्याला म्हणाले, “मी सर्वसमर्थ परमेश्वर आहे; फलद्रूप हो आणि तुझी संख्या अनेक पटीने वाढो. तुझे एक मोठे राष्ट्र निर्माण व्हावे म्हणून मी तुझी वृद्धी करेन. पुष्कळ राजे तुझ्या वंशजातून उदय पावतील. ");
INSERT INTO marc_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","अब्राहाम व इसहाक यांना जो देश मी दिला तो मी तुला व तुझ्यानंतर तुझ्या वंशजांना देईन.” ");
INSERT INTO marc_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ज्या ठिकाणी परमेश्वराने त्याच्याशी बोलणे केले, त्या ठिकाणाहून परमेश्वर वर निघून गेले. ");
INSERT INTO marc_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","नंतर याकोबाने ज्या ठिकाणी परमेश्वराने त्याच्याशी बोलणे केले, त्या ठिकाणी एक पाषाणस्तंभ उभा केला आणि त्यावर परमेश्वराला पेयार्पण ओतले आणि त्या स्तंभावर तैलाभ्यंग केला. ");
INSERT INTO marc_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ज्या स्थानी परमेश्वर त्याच्याशी बोलले होते. त्या स्थानाचे नाव याकोबाने बेथेल असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","मग ते बेथेलमधून पुढे निघाले. तरी एफ्राथाहपासून काही अंतरावर असतानाच राहेलला प्रसूती वेदना सुरू झाल्या व तिला अतिशय कष्ट झाले. ");
INSERT INTO marc_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","अतिशय त्रासदायक प्रसूती होताना सुईण तिला म्हणाली, “भिऊ नकोस; कारण तुला आणखी एक पुत्र झाला आहे.” ");
INSERT INTO marc_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","तिने अखेरचा श्वास घेतला—कारण ती मृतवत झाली होती—तिने तिच्या मुलाचे नाव बेन-ओनी ठेवले पण त्याच्या वडिलांनी त्याचे नाव बिन्यामीन ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","अशाप्रकारे राहेल मरण पावली आणि एफ्राथच्या (म्हणजे बेथलेहेमकडे) जाणार्‍या वाटेवर तिला मूठमाती देण्यात आली. ");
INSERT INTO marc_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","मग याकोबाने तिच्या कबरेवर एक दगडी स्मारक उभारले, ते स्मारक आजही राहेलच्या कबरेचे खूण म्हणून तिथे उभे आहे. ");
INSERT INTO marc_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","मग इस्राएल पुढे प्रवास करीत निघाला आणि त्याने एदेरच्या बुरुजापलीकडे आपला तळ दिला. ");
INSERT INTO marc_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","तो त्या प्रदेशात राहत असताना रऊबेन हा आपल्या पित्याची उपपत्नी बिल्हा हिच्याजवळ जाऊन निजला, हे वृत्त इस्राएलला सांगण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","लेआचे पुत्र: याकोबाचा ज्येष्ठपुत्र रऊबेन, मग शिमओन, लेवी, यहूदाह, इस्साखार व जबुलून. ");
INSERT INTO marc_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राहेलचे पुत्र: योसेफ व बिन्यामीन हे होते. ");
INSERT INTO marc_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेलची दासी बिल्हा हिचे पुत्र: दान व नफताली हे होते. ");
INSERT INTO marc_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","लेआची दासी जिल्पा हिचे पुत्र: गाद व आशेर हे होते. ");
INSERT INTO marc_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","अशा रीतीने शेवटी याकोब किर्याथ-अर्बा म्हणजे हेब्रोन येथील मम्रे या ठिकाणी आपला पिता इसहाक याच्याकडे येऊन पोहोचला. याच ठिकाणी अब्राहामही राहिला होता. ");
INSERT INTO marc_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक एकशेऐंशी वर्षे जगला. ");
INSERT INTO marc_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","तो परिपक्व वयाचा वयोवृद्ध होऊन मरण पावला आणि त्याचे पुत्र एसाव व याकोब यांनी त्याला मूठमाती दिली. ");
INSERT INTO marc_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव म्हणजे एदोम याची वंशावळ ही: ");
INSERT INTO marc_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसावाने कनान देशातील स्थानिक मुलींशी विवाह केले होते: एलोन हिथी याची कन्या आदाह, अनाहची कन्या व सिबोन हिव्वी याची नात ओहोलीबामाह ");
INSERT INTO marc_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","आणि इश्माएलाची कन्या व नबायोथाची बहीण बासमाथ. ");
INSERT INTO marc_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","एसावापासून आदाहला एलीफाज नावाचा पुत्र झाला, बासमाथला रऊएल नावाचा पुत्र झाला. ");
INSERT INTO marc_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","एसावापासून ओहोलीबामाहला यऊश, यालाम व कोरह या नावांचे पुत्र झाले. एसावाला हे सर्व पुत्र कनान देशात झाले. ");
INSERT INTO marc_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","मग एसाव आपल्या स्त्रिया, मुलेबाळे, आपल्या घरची सर्व नोकरमंडळी, आपली गुरे व इतर जनावरे आणि कनान देशात त्याने मिळविलेली धनसंपत्ती घेऊन याकोबापासून दूर निघून तिथे वस्ती करून राहिला. ");
INSERT INTO marc_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","कारण त्या दोघांकडे इतकी अधिक धनसंपत्ती होती की त्यांच्या गुरांना पुरतील इतकी कुरणे तिथे नव्हती. ");
INSERT INTO marc_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","म्हणून एसावाने सेईरच्या (जे एदोम आहे) डोंगराळ प्रदेशात वस्ती केली. ");
INSERT INTO marc_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेईरच्या डोंगराळ प्रदेशातील एदोमी लोकांचा मूळ पुरुष एसावच्या वंशजांची नावे अशी. ");
INSERT INTO marc_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसावाच्या पुत्रांची नावे: एसावची पत्नी आदाहपासून झालेला पुत्र एलीफाज आणि एसावची पत्नी बासमाथ हिच्यापासून झालेला रऊएल. ");
INSERT INTO marc_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलीफाजचे पुत्र: तेमान, ओमर, सेपो, गाताम व केनाज होते. ");
INSERT INTO marc_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसावाचा पुत्र एलीफाजला तिम्ना नावाची उपपत्नी होती जिच्यापासून त्याला अमालेक हा पुत्र झाला. ही एसावची पत्नी आदाह हिची नातवंडे होती. ");
INSERT INTO marc_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रऊएलाचे पुत्र: नहाथ, जेरह, शम्माह व मिज्जा. ही एसावाची पत्नी बासमाथ हिची नातवंडे होती. ");
INSERT INTO marc_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","एसावाला ओहोलीबामाह नावाची आणखी एक पत्नी होती. ती अनाहची कन्या असून सिबोनाची नात होती. ओहोलीबामाहच्या पोटी एसावाला, यऊश, यालाम व कोरह हे पुत्र झाले. ");
INSERT INTO marc_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसावाची नातवंडे त्यांच्या नावांनी ओळखल्या जाणार्‍या कुळांचे प्रमुख झाले: एसावाचा प्रथमपुत्र एलीफाजचे पुत्र: त्यांची नावे ही: तेमान, ओमर, सेपो, केनाज, ");
INSERT INTO marc_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम व अमालेक. हे सर्व एदोमातील एलीफाजचे प्रमुख वंशज होते; ते आदाहचे पौत्र होते. ");
INSERT INTO marc_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसावाचा पुत्र रऊएलचे वंशज: नहाथ, जेरह, शम्माह व मिज्जा. ही कुळे एदोम देशात रऊएलापासून झाले; एसाव व त्याची पत्नी बासमाथची ही नातवंडे. ");
INSERT INTO marc_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसावाला त्याची पत्नी ओहोलीबामाह हिच्याकडून: यऊश, यालाम व कोरह हे पुत्र झाले. हे पुढारी एसावाला, अनाह याची कन्या ओहोलीबामाह हिच्यापासून झाले. ");
INSERT INTO marc_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","हे एसावाचे (अर्थात् एदोमाचे) पुत्र, जे त्यांच्या कुळाचे पुढारी होते. ");
INSERT INTO marc_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","एदोम देशातील रहिवासी, सेईर होरी याच्या पुत्रांची नावे ही: लोटान, शोबाल, सिबोन, अनाह, ");
INSERT INTO marc_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दिशोन, एसर व दीशान. हे एदोम देशातील सेईराचे पुत्र होरी वंशातील कुळांचे सरदार झाले. ");
INSERT INTO marc_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोटानाचे पुत्र: होरी व होमाम. तिम्ना लोटानाची बहीण होती. ");
INSERT INTO marc_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबालाचे पुत्र: अलवान, मानहथ, एबाल, शेफो व ओनाम. ");
INSERT INTO marc_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोनाचे पुत्र: अय्याह व अनाह. (आपल्या पित्याची गाढवे ओसाड प्रदेशात चारीत असताना ज्याने गरम पाण्याचे झरे शोधून काढले तोच हा अनाह होय.) ");
INSERT INTO marc_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अनाहचा पुत्र: दिशोन असून त्याची कन्या ओहोलीबामाह ही होती. ");
INSERT INTO marc_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दिशोनाचे पुत्र: हेमदान, एश्बान, इथरान व करान. ");
INSERT INTO marc_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसराचे पुत्र: बिल्हान, जावान व आकान. ");
INSERT INTO marc_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दिशोनाचे पुत्र: ऊस व अरान. ");
INSERT INTO marc_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरी लोकांमधून प्रमुख झालेल्यांची नावे ही: लोटान, शोबाल, सिबोन, अना, ");
INSERT INTO marc_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दिशोन, एसर व दीशान. ");
INSERT INTO marc_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","इस्राएली लोकांवर कोणत्याही राजाने राज्य करण्यापूर्वी एदोम देशावर ज्या राजांनी राज्य केले ते: ");
INSERT INTO marc_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बौराचा पुत्र बेला एदोमचा राजा झाला. त्याच्या शहराला दिन्हाबाह हे नाव दिले होते. ");
INSERT INTO marc_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला मृत्यू पावल्यावर बस्रा येथला जेरहाचा पुत्र योबाब हा त्याच्या जागी राजा झाला. ");
INSERT INTO marc_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब मरण पावल्यावर तेमानी देशातील हुशाम त्याच्या जागी राजा झाला. ");
INSERT INTO marc_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","हुशाम मेल्यावर बदादाचा पुत्र हदाद त्याच्या जागी राजा झाला. यानेच मोआब मैदानात मिद्यानांना पराभूत केले; त्या नगराचे नाव अवीत होते. ");
INSERT INTO marc_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदाद मेल्यावर मास्रेका येथील सामलाह त्याच्या जागी राजा झाला. ");
INSERT INTO marc_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","सामलाह मेल्यावर फरात नदीच्या तीरावरील रेहोबोथ नावाच्या शहरातील शौल त्याच्या जागी राजा झाला. ");
INSERT INTO marc_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शौलाच्या मृत्यूनंतर अकबोराचा पुत्र बआल-हानान त्याच्या जागी राजा झाला. ");
INSERT INTO marc_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अकबोराचा पुत्र बआल-हानान हा मेल्यावर हदाद त्याच्या जागी राजा झाला. त्याच्या नगराचे नाव पाऊ होते, आणि त्याच्या पत्नीचे नाव महेटाबेल असून ती मेजाहाबाची कन्या मात्रेद हिची कन्या होती. ");
INSERT INTO marc_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एसाव हा एदोम वंशातील प्रमुखांचा मूळ पुरुष होता: तिम्ना, आल्वा, यतेथ, ");
INSERT INTO marc_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामाह, एलाह, पीनोन, ");
INSERT INTO marc_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","केनाज, तेमान, मिब्सार, ");
INSERT INTO marc_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्दीएल व ईराम. ");
INSERT INTO marc_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","कनान देशात ज्या ठिकाणी आपला पिता वस्ती करून राहिला होता, त्या ठिकाणी याकोब जाऊन स्थायिक झाला. ");
INSERT INTO marc_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकोबाच्या कुटुंबाचा वृतांत असा आहे: योसेफ सतरा वर्षांचा तरुण असताना आपल्या भावांबरोबर, त्याच्या वडिलांच्या पत्नी बिल्हा व जिल्पा यांच्या पुत्रांबरोबर कळप चारीत असे, तेव्हा योसेफाने, त्यांच्या दुर्वर्तनाबद्दल तक्रारी वडिलांकडे आणल्या. ");
INSERT INTO marc_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","इस्राएल योसेफावर आपल्या इतर मुलांपेक्षा अधिक प्रीती करीत असे, कारण त्याला तो म्हातारपणी झाला होता; म्हणून याकोबाने त्याच्यासाठी एक आकर्षक रंगाचा अंगरखा तयार केला. ");
INSERT INTO marc_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","जेव्हा त्याच्या भावांनी पाहिले की त्यांचे वडील त्यांच्यापेक्षा योसेफावर अधिक प्रीती करतात, तेव्हा ते योसेफाचा द्वेष करू लागले आणि त्याच्याशी सलोख्याचा एकही शब्द बोलू शकत नव्हते. ");
INSERT INTO marc_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","एके रात्री योसेफाला एक स्वप्न पडले आणि त्याने ते आपल्या भावांना सांगितले. ते ऐकून तर ते त्याचा अधिकच द्वेष करू लागले. ");
INSERT INTO marc_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","योसेफ आपल्या भावांना म्हणाला, “माझे स्वप्न ऐका: ");
INSERT INTO marc_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","आपण शेतात पेंढ्या बांधत होतो, तेवढ्यात माझी पेंढी उठून उभी राहिली आणि तुमच्या सर्वांच्या पेंढ्या माझ्या पेंढीभोवती गोळा होऊन उभ्या राहिल्या व त्यांनी माझ्या पेंढीला नमन केले.” ");
INSERT INTO marc_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","तेव्हा त्याच्या भावांनी त्याची हेटाळणी करून त्याला म्हटले. “काय! तू आमचा राजा होणार? तू आम्हावर सत्ता चालविणार?” आणि त्याच्या स्वप्नामुळे व त्याने त्याचे कथन केल्यामुळे ते त्याचा अधिक द्वेष करू लागले. ");
INSERT INTO marc_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","पुढे त्याला आणखी एक स्वप्न पडले. तो त्यांना म्हणाला, “पाहा, मला आणखी एक स्वप्न पडले. सूर्य, चंद्र आणि अकरा तारे यांनी मला खाली लवून नमन केले.” ");
INSERT INTO marc_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","त्याने आपले स्वप्न आपल्या भावांबरोबर आपल्या वडिलांनाही सांगितले, तेव्हा त्याच्या वडिलांनी त्याला धमकावून विचारले, “हे काय बोलतोस? मी, तुझी आई आणि तुझे भाऊ तुझ्याकडे येऊन तुला भूमीपर्यंत लवून नमन करणार आहोत काय?” ");
INSERT INTO marc_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","या कारणामुळे त्याच्या भावांचा द्वेष अधिक तीव्र झाला; परंतु त्याच्या वडिलांनी ही बाब आपल्या मनात ठेवली. ");
INSERT INTO marc_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","योसेफाचे भाऊ आपल्या वडिलांची मेंढरे शेखेम येथे चारावयास घेऊन गेले होते. ");
INSERT INTO marc_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","इस्राएलने योसेफाला म्हटले, “तुझे भाऊ शेखेम येथे मेंढरे चारावयास गेले आहेत; मी तुला त्यांच्याकडे पाठवित आहे.” योसेफ म्हणाला, “ठीक आहे.” ");
INSERT INTO marc_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","याकोबाने योसेफास म्हटले, “तू शेखेमला जा आणि तुझ्या भावांचे सर्वकाही ठीक आहे का व कळपांची स्थिती कशी आहे, हे पाहून मला येऊन सांग.” नंतर याकोबाने त्याला हेब्रोन खोर्‍यातून पाठवले. आणि तो शेखेमास पोहोचला. ");
INSERT INTO marc_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","तो शेतातून फिरत असता त्याला एका मनुष्याने पाहिले आणि त्याने योसेफाला विचारले, “तू काय शोधीत आहेस?” ");
INSERT INTO marc_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","योसेफाने उत्तर दिले, “मी माझ्या भावांना शोधीत आहे. ते कुठे कळप चारीत आहे, हे मला सांगाल का?” ");
INSERT INTO marc_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","तेव्हा तो मनुष्य म्हणाला, “होय, पण आता ते येथे नाहीत, ‘आपण दोथानला जाऊ’ तुझ्या भावांना असे बोलताना मी ऐकले.” तेव्हा योसेफ भावांच्या मागे दोथानला गेला आणि ते त्याला तिथे आढळले. ");
INSERT INTO marc_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","त्याच्या भावांनी त्याला दुरून येताना पाहिले आणि तो पोहोचण्या आधी त्याला जिवे मारण्याचा कट रचला. ");
INSERT INTO marc_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ते एकमेकांना म्हणाले, “अरे हा स्वप्नदर्शी येत आहे. ");
INSERT INTO marc_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","चला आपण याला ठार करू. त्याला एखाद्या विहिरीत फेकून देऊ आणि आपल्या वडिलांना सांगू की त्याला हिंस्र पशूने खाऊन टाकले आहे; मग त्याच्या स्वप्नांचे काय होते ते आपण पाहू.” ");
INSERT INTO marc_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","जेव्हा रऊबेनने हे ऐकले तेव्हा त्याने योसेफाचा जीव वाचविण्याचा प्रयत्न केला; तो म्हणाला, “आपण त्याला जिवे मारणार नाही; ");
INSERT INTO marc_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","आपण रक्तपात करणार नाही; तर आपण त्याला या रानातल्या विहिरीत फेकून देऊ; परंतु त्याला हात लावू नका.” रऊबेनने असा बेत केला होता की नंतर योसेफाला विहिरीतून काढावे आणि आपल्या वडिलांकडे परत पाठवून द्यावे. ");
INSERT INTO marc_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","योसेफ त्यांच्याजवळ आला तेव्हा त्यांनी त्याचा झगा—जो गडद रंगाचा, सुशोभित होता—ओढून काढला, ");
INSERT INTO marc_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","आणि त्याला एका कोरड्या विहिरीत फेकून दिले, ती विहीर रिकामी होती, तिच्यात पाणी नव्हते. ");
INSERT INTO marc_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","मग ते भोजन करण्यास बसले असता त्यांना दूर अंतरावरून उंटांचा एक काफिला त्यांच्याकडे येताना दिसला. ते इश्माएली व्यापारी असून गिलआदहून इजिप्तला डिंक, मसाले व गंधरस घेऊन चालले होते. ");
INSERT INTO marc_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","तेव्हा यहूदाह आपल्या भावांना म्हणाला, “आपल्या भावाला मारून त्याचा रक्तपात झाकून आपल्याला काय फायदा? ");
INSERT INTO marc_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","चला आपण योसेफाला इश्माएली लोकांना विकून टाकू या, त्याला हात लावू नका, तो आपला भाऊच आहे, आपल्याच रक्तमांसाचा आहे.” त्या सर्व भावांना त्याचे म्हणणे पटले. ");
INSERT INTO marc_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","मिद्यानी व्यापार्‍यांचा काफिला म्हणजे इश्माएली लोक जवळ आले, तेव्हा त्यांनी योसेफाला त्या विहिरीतून बाहेर काढले आणि वीस शेकेल चांदी घेऊन भावांनी योसेफाला विकून टाकले; आणि व्यापार्‍यांनी योसेफाला आपल्याबरोबर इजिप्त देशाला नेले. ");
INSERT INTO marc_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","जेव्हा रऊबेन त्या विहिरीजवळ परत आला आणि योसेफ विहिरीत नाही हे पाहून त्याने आपली वस्त्रे फाडली. ");
INSERT INTO marc_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","तो रडत आपल्या भावांना म्हणाला, “मुलगा विहिरीत नाही; आता मी कुठे जाऊ?” ");
INSERT INTO marc_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","मग त्यांनी योसेफाचा झगा घेतला, एक बोकड मारला आणि त्याच्या रक्तात तो झगा बुडवला. ");
INSERT INTO marc_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","तो झगा त्यांनी आपल्या वडिलांकडे आणून म्हटले, “हा झगा आम्हास सापडला आहे; हा तुमच्या मुलाचा झगा आहे की नाही ते पाहा!” ");
INSERT INTO marc_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","त्याने तो झगा ओळखला आणि म्हणाला, “होय, हा माझ्या मुलाचाच झगा आहे; त्याला वनपशूने खाऊन टाकले असावे. योसेफाचे त्याने फाडून तुकडे केले आहे यात शंका नाही.” ");
INSERT INTO marc_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","यानंतर याकोबाने आपली वस्त्रे फाडली आणि गोणपाट नेसून त्याने मुलासाठी पुष्कळ दिवस शोक केला. ");
INSERT INTO marc_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","त्याचे सर्व पुत्र आणि कन्या आले आणि त्याचे सांत्वन करण्याचा प्रयत्न केला, पण त्याचा काही उपयोग झाला नाही. तो म्हणत असे, “मी पुत्र शोकानेच मरेन आणि अधोलोकी आपल्या मुलाकडे जाईन.” अशा रीतीने तो त्याच्यासाठी दुःखाने रडत असे. ");
INSERT INTO marc_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","दरम्यान, मिद्यानी लोकांनी योसेफाला इजिप्तमधील पोटीफर, फारोहच्या सरदारांपैकी एका सुरक्षादलाच्या प्रमुखास विकले. ");
INSERT INTO marc_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","याच सुमारास यहूदाह आपल्या भावांना सोडून अदुल्लाम येथे आला आणि हीरा नावाच्या एका मनुष्याबरोबर राहू लागला. ");
INSERT INTO marc_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","तिथे शूवा नावाच्या एका कनानी मनुष्याची कन्या यहूदाहच्या दृष्टीस पडली आणि तिच्याशी विवाह करून त्याने तिचा स्वीकार केला; ");
INSERT INTO marc_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ती गर्भवती झाली, तिला पुत्र झाला. त्याचे नाव एर ठेवण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ती पुन्हा गर्भवती झाली, तिला पुत्र झाला, त्याचे नाव ओनान ठेवण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","तिने आणखी एका पुत्राला जन्म दिला व त्याचे नाव शेलाह ठेवले, ते कजीब येथे राहत असताना तिने त्याला जन्म दिला. ");
INSERT INTO marc_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदाहने आपला ज्येष्ठपुत्र एर याचा विवाह तामार नावाच्या एका स्त्रीशी करून दिला. ");
INSERT INTO marc_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","परंतु यहूदाहचा ज्येष्ठपुत्र एर, याहवेहच्या नजरेत एक दुष्ट मनुष्य होता म्हणून याहवेहने त्याला ठार मारले. ");
INSERT INTO marc_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","तेव्हा यहूदाह ओनान यास म्हणाला, “तू तिचा दीर असल्याची जबाबदारी पूर्ण करण्यासाठी तामारेशी विवाह केला पाहिजे, म्हणजे तुझ्यापासून तिला तुझ्या भावाचे संतान होतील.” ");
INSERT INTO marc_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ओनानला हे ठाऊक होते की संतती झाली तर ती आपली होणार नाही म्हणून ज्यावेळी तो तिच्याशी समागम करी, त्यावेळी तो आपले वीर्य जमिनीवर पाडी, यासाठी की त्याच्यापासून भावाला संतती होऊ नये. ");
INSERT INTO marc_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","हे त्याचे कृत्य याहवेहच्या दृष्टीने एक फार मोठे पाप होते; म्हणून याहवेहने त्यालाही मारून टाकले. ");
INSERT INTO marc_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","यहूदाह आपली सून तामारला म्हणाला, “माझा पुत्र शेलाहचे विवाहाचे वय होईपर्यंत तू तुझ्या वडिलांच्या घरात विधवा म्हणून राहा.” यहूदाहला भीती वाटत होती की हा मुलगाही आपल्या भावांप्रमाणे मरेल. मग तामार तिच्या वडिलांच्या घरी गेली. ");
INSERT INTO marc_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","कालांतराने यहूदाहची पत्नी जी शूवाची मुलगी होती ती मरण पावली. शोक करण्याचे दिवस संपल्यावर यहूदाह, आपला मित्र अदुल्लाम येथील हीरा, याच्याबरोबर आपल्या मेंढरांची लोकर कातरणार्‍यांकडे तिम्ना येथे गेला. ");
INSERT INTO marc_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","“तुझा सासरा तिम्ना येथे मेंढरांची लोकर कातरण्यासाठी गेला आहे,” असे कोणीतरी तामारेला सांगितले. ");
INSERT INTO marc_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तिने आपले वैधव्यदशेत वापरण्याचे कपडे बाजूला ठेवून दिले आणि आपल्याला कोणी ओळखू नये म्हणून तिने अंगावर बुरखा घेतला. मग तिम्नाच्या वाटेवर असलेल्या एनाईम गावाच्या प्रवेशद्वाराजवळ ती जाऊन बसली. कारण तिने पाहिले की, शेलाह आता मोठा झाला असला तरी तिला त्याची पत्नी म्हणून दिले गेले नाही. ");
INSERT INTO marc_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","तिथून जाताना यहूदाहने तिला पाहिले आणि तिच्या तोंडावर बुरखा असल्यामुळे त्याला वाटले की ती एक वेश्या आहे, ");
INSERT INTO marc_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","म्हणून तो तिच्याजवळ जाऊन थांबला आणि त्याने तिला म्हटले, “तुझ्याशी रत होण्याची माझी इच्छा आहे.” अर्थात् ती आपली सून आहे, हे त्याला माहीत नव्हते. यावर तिने विचारले, “याबद्दल तुम्ही मला काय द्याल?” ");
INSERT INTO marc_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","त्याने म्हटले, “मी तुला माझ्या कळपातून एक कोवळी शेळी पाठवून देईन.” तेव्हा तिने विचारले, “ती पाठवेपर्यंत तुम्ही माझ्याकडे कोणते तारण ठेवणार आहात?” ");
INSERT INTO marc_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“तुला काय तारण हवे आहे?” त्याने तिला विचारले. तिने उत्तर दिले, “तुमची मुद्रिका, गोफ आणि हातातील काठी.” याप्रमाणे त्याने या वस्तू तिला दिल्या आणि तिने त्याला आपल्याशी रत होऊ दिले, परिणामी ती गर्भवती झाली. ");
INSERT INTO marc_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","यानंतर तिने वैधव्यदशेतील आपले कपडे पुन्हा धारण केले. ");
INSERT INTO marc_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","यहूदाहने आपला अदुल्लामी मित्र हीरा, याला तिच्याकडे कोवळी शेळी घेऊन जाण्यास आणि तिला दिलेल्या गहाण वस्तू परत आणण्यात सांगितले; पण हीराला ती सापडली नाही. ");
INSERT INTO marc_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","म्हणून त्याने एनाईम गावातील काही लोकांना विचारले, “गावाच्या प्रवेशद्वाराजवळील रस्त्यावर बसलेली देवदासी कुठे राहते?” “आमच्या गावात तर कोणी देवदासी राहत नाही,” त्यांनी त्याला उत्तर दिले. ");
INSERT INTO marc_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","तेव्हा तो यहूदाहकडे परत गेला आणि त्याने त्याला सांगितले, “मला ती कुठेच सापडली नाही, तसेच तेथील लोकांनी सांगितले की आमच्या गावात कोणी देवदासी राहत नाही.” ");
INSERT INTO marc_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","यावर यहूदाह म्हणाला, “मग त्या वस्तू तिच्याकडेच राहू दे. नाहीतर तेथील लोकांसाठी आपण उपहासाचा विषय होऊ. मी तर तुझ्यामार्फत तिच्यासाठी ही कोवळी शेळी पाठविली होती, पण ती तुला आढळली नाही.” ");
INSERT INTO marc_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","सुमारे तीन महिन्यानंतर, “तुझी सून तामार ही वेश्याकर्मामुळे गर्भवती झाली आहे,” अशी बातमी यहूदाहच्या कानावर गेली. यहूदाह म्हणाला, “तिला बाहेर काढा आणि जाळून टाका!” ");
INSERT INTO marc_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","त्याप्रमाणे ते तिला जाळून टाकण्यासाठी बाहेर घेऊन जात असताना तिने आपल्या सासर्‍याला निरोप पाठविला, “ही मुद्रिका, हा गोफ आणि ही काठी ज्याची आहे, त्याच्यापासून मला गर्भ राहिलेला आहे. तुम्ही या वस्तू ओळखता काय?” ");
INSERT INTO marc_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदाहने त्या वस्तूंना ओळखले आणि म्हटले, “माझ्यापेक्षा ती अधिक नीतिमान आहे, कारण माझा पुत्र शेलाह तिला पती म्हणून दिला नाही.” यानंतर त्याने कधीही तिच्याशी शरीरसंबंध ठेवला नाही. ");
INSERT INTO marc_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","योग्य वेळी तामारेचे दिवस भरले आणि तिला जुळे पुत्र झाले. ");
INSERT INTO marc_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","त्यांचा जन्म होत असताना, एका मुलाने प्रथम हात बाहेर काढला, त्याच्या मनगटावर सुइणीने शेंदरी रंगाचा दोरा बांधला व ती म्हणाली, “हा प्रथम जन्माला आला.” ");
INSERT INTO marc_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","परंतु त्याने त्याचा हात मागे ओढून घेतला आणि त्याचा भाऊ बाहेर आला, ती म्हणाली, “तर अशाप्रकारे तू वाट काढली!” आणि त्याचे नाव पेरेस ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","यानंतर लवकरच मनगटावर शेंदरी दोरा असलेले मूल जन्मले आणि त्याचे नावे जेरह असे ठेवण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","इकडे योसेफाला इजिप्तमध्ये आणले. फारोह अंमलदार व अंगरक्षकांचा प्रमुख पोटीफराने इश्माएली लोकांपासून योसेफास विकत घेतले. ");
INSERT INTO marc_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","याहवेह योसेफाबरोबर होते, म्हणून तो सफल व्यक्ती बनला आणि तो इजिप्तच्या धन्याच्या घरी राहत असे. ");
INSERT INTO marc_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","पोटीफराने पाहिले की याहवेह योसेफाबरोबर आहेत आणि जे काही तो करतो त्यामध्ये याहवेह त्याला यश देतात, ");
INSERT INTO marc_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","त्यामुळे साहजिकच योसेफ त्याचा आवडता झाला व त्याचा व्यक्तिगत सेवक बनला. लवकरच पोटीफराच्या घराची व्यवस्था व त्याचे सर्व व्यवहार त्याच्या ताब्यात देण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","जेव्हापासून त्याने योसेफाला त्याच्या घरावर, व त्याचे जे काहीही होते त्या सर्वांवर अधिकारी म्हणून नेमले, तेव्हापासून योसेफामुळे याहवेहने त्या इजिप्तच्या धन्याला आशीर्वादित केले; पोटीफराचे जे काही होते, त्याचे कुटुंब व शेती यावर याहवेहचा आशीर्वाद होता. ");
INSERT INTO marc_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","म्हणून पोटीफराने आपले सर्वकाही योसेफाला सोपवून दिले. आपण काय खावे यापलीकडे त्याने कशाचीच काळजी केली नाही. योसेफ हा बांधेसूद व देखणा होता. ");
INSERT INTO marc_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","काही वेळेनंतर योसेफ पोटीफराच्या पत्नीच्या डोळ्यात भरला व ती त्याला म्हणाली, “माझ्याशी समागम कर!” ");
INSERT INTO marc_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","योसेफाने तिला नाकारले. तो तिला म्हणाला. “हे पाहा, मी कारभारी असताना माझे धनी या घरातील कोणत्याही गोष्टीची काळजी करीत नाही, त्यांच्या मालकीचे सर्वकाही त्यांनी माझ्या हाती सोपविले आहे. ");
INSERT INTO marc_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","या घरामधे मला सर्वांपेक्षा अधिक अधिकार आहेत. तुम्ही त्यांची पत्नी आहात, तुम्हाला वगळून इतर प्रत्येक गोष्ट त्यांनी माझ्या हाती दिली आहे. तेव्हा असे दुष्कर्म मला कसे करता येईल? ते परमेश्वराविरुद्ध एक घोर पातक ठरेल.” ");
INSERT INTO marc_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ती दिवसेंदिवस योसेफाला आग्रह करीत असली तरी त्याने तिच्यासोबत निजण्यास किंवा तिच्या सहवासात असण्याचे नाकारले. ");
INSERT INTO marc_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एके दिवशी असे घडून आले की, तो कामानिमित्त घराच्या आत आला असताना, घरात दुसरे कोणतेही सेवक नव्हते; ");
INSERT INTO marc_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","तिने त्याच्या झग्याला पकडले आणि म्हणाली, “माझ्याबरोबर नीज!” पण त्याने त्याचा झगा तिच्या हातातच सोडला आणि घराबाहेर पळाला. ");
INSERT INTO marc_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","त्याचा झगा आपल्याच हातात आहे आणि तो पळून गेला आहे हे तिच्या लक्षात आले, ");
INSERT INTO marc_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","तेव्हा तिने घरातील सेवकांना बोलाविले. ती म्हणाली, “आमच्या घराचा उपमर्द करण्यासाठीच हा इब्री गुलाम घरात आणला आहे! त्याने माझ्यासोबत निजण्याचा प्रयत्न केला, पण मी किंचाळले. ");
INSERT INTO marc_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","जसे त्याने माझे किंचाळणे ऐकले तसे तो स्वतःचा झगा माझ्याजवळ टाकून घराबाहेर पळून गेला.” ");
INSERT INTO marc_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","तिने तिचा धनी घरी येईपर्यंत तो झगा आपल्याजवळच ठेवला. ");
INSERT INTO marc_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","नंतर तिने त्याला आपली कथा सांगितली: “जो इब्री गुलाम तुम्ही इकडे आणला आहे, त्याने माझ्यावर बळजबरी करण्याचा प्रयत्न केला. ");
INSERT INTO marc_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","पण जसे मी मदतीसाठी किंचाळले, त्याचा झगा माझ्याजवळ टाकून घराबाहेर पळून गेला.” ");
INSERT INTO marc_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“तुमचा गुलाम माझ्याशी असा वागला.” असे म्हणून पत्नीने सांगितलेला वृतांत ऐकताच त्याचा धनी रागाने बेभान झाला. ");
INSERT INTO marc_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","योसेफाच्या धन्याने त्याला धरले आणि राजाच्या कैद्यांना ज्या तुरुंगात ठेवीत, तिथे त्याने योसेफाला ठेवले, परंतु जेव्हा योसेफ तुरुंगात होता, ");
INSERT INTO marc_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","याहवेह योसेफाबरोबर होते आणि तुरुंगाच्या अधिकार्‍याची कृपादृष्टी त्याच्यावर बसेल असे त्यांनी केले. ");
INSERT INTO marc_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","तुरुंगाच्या अधिकार्‍याने तुरुंगाचा सर्व कारभार योसेफाच्या हाती दिला आणि सर्व कैदीही योसेफाच्या ताब्यात दिले. ");
INSERT INTO marc_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","त्यानंतर तुरुंगाच्या अधिकार्‍याला कसलीच काळजी उरली नाही, कारण याहवेह योसेफाबरोबर होते आणि तो जे काही करत असे त्यामध्ये ते त्याला यश देत. ");
INSERT INTO marc_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","काही काळानंतर असे झाले की, इजिप्तच्या राजाचा रोटी भाजणारा व प्यालेबरदार यांनी त्यांच्या धन्याच्या, म्हणजे इजिप्तच्या राजाविरुद्ध अपराध केला. ");
INSERT INTO marc_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","फारोह आपला रोटी भाजणारा प्रमुख व प्यालेबरदारचा प्रमुख या दोन्ही सरदारांवर रागावला ");
INSERT INTO marc_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","आणि त्याने त्या दोघांना सुरक्षादलाचा प्रमुख, याच्या वाड्यात म्हणजे जिथे योसेफ होता, त्याच वाड्यातील तुरुंगात टाकले. ");
INSERT INTO marc_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","तुरुंगाच्या अधिकार्‍याने योसेफाला त्यांच्याकडे लक्ष देण्यास सांगितले आणि त्याने त्यांची देखरेख केली, काही काळ ते तुरुंगात राहिल्यानंतर, ");
INSERT INTO marc_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","एके रात्री दोघांनाही—इजिप्तच्या राजाचा रोटी भाजणारा व प्यालेबरदार, ज्यांना तुरुंगात टाकण्यात आले होते—स्वप्ने पडली आणि प्रत्येकाच्या स्वप्नाचा विशिष्ट अर्थ होता. ");
INSERT INTO marc_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","दुसर्‍या दिवशी सकाळी जेव्हा योसेफ त्यांना भेटला, तेव्हा ते दोघेही खिन्न असल्याचे त्याच्या लक्षात आले. ");
INSERT INTO marc_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","योसेफाने त्याच्यासोबत त्याच्या धन्याच्या वाड्यात तुरुंगात असलेल्या त्या फारोहच्या अधिकार्‍यांना विचारले, “आज तुम्ही इतके खिन्न का आहात?” ");
INSERT INTO marc_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","त्यांनी उत्तर दिले, “काल रात्री आम्हा दोघांनाही स्वप्न पडले, पण आम्हाला त्यांचा अर्थ सांगणारा येथे कोणीच नाही.” यावर योसेफ म्हणाला, “स्वप्नांचा उलगडा करून सांगणे हे परमेश्वराकडूनच असते ना? स्वप्नात तुम्ही काय पाहिले ते सांगा.” ");
INSERT INTO marc_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","मुख्य प्यालेबरदारने आपले स्वप्न योसेफाला सांगितले. तो म्हणाला, “स्वप्नात मी एक द्राक्षवेल पाहिली. ");
INSERT INTO marc_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","तिला तीन फांद्या होत्या. त्यांना कळ्या व फुले आली आणि लवकरच त्याला पिकलेल्या द्राक्षांचे घोसही लागले. ");
INSERT INTO marc_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","माझ्या हातात फारोहचा प्याला होता, त्यात ती द्राक्षे पिळून मी रस काढला आणि तो प्याला फारोह राजाला प्यावयास दिला.” ");
INSERT INTO marc_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","तेव्हा योसेफ म्हणाला, “या स्वप्नाचा अर्थ असा: तीन फांद्या म्हणजे तीन दिवस. ");
INSERT INTO marc_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","या तीन दिवसात फारोह तुला तुरुंगातून सोडून देईल आणि तू स्वतः परत राजाच्या हाती प्याला देशील, जसा तू आधी प्यालेबरदार म्हणून देत होता. ");
INSERT INTO marc_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","पण जेव्हा तुझ्याबरोबर सर्वकाही ठीक होईल, तेव्हा माझी आठवण ठेव आणि माझ्यावर कृपा दाखव, फारोहजवळ माझा उल्लेख कर आणि मला या तुरुंगातून बाहेर काढ. ");
INSERT INTO marc_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","कारण मला इब्री लोकांच्या देशातून येथे पळवून आणण्यात आले आणि अंधारकोठडीची शिक्षा मला मिळावी, असे मी काही केले नाही.” ");
INSERT INTO marc_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","त्याच्या स्वप्नाचे उत्तर चांगले निघाले आहे हे पाहून, रोटी भाजणारा प्रमुख योसेफाला म्हणाला, “मला देखील एक स्वप्न पडले आहे: मला माझ्या डोक्यावर रोट्यांच्या तीन टोपल्या दिसल्या. ");
INSERT INTO marc_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","सर्वात वरच्या टोपलीमध्ये फारोहसाठी भटारखान्यातील सर्वप्रकारचे उत्कृष्ट प्रतीचे खाद्यपदार्थ होते; परंतु पक्षी येऊन माझ्या डोक्यावरील टोपलीतून ते पदार्थ खाऊ लागले.” ");
INSERT INTO marc_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","योसेफाने अर्थ सांगताना म्हटले, “या तीन टोपल्या म्हणजे तीन दिवस होत. ");
INSERT INTO marc_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","आजपासून तीन दिवसांनी फारोह तुझा शिरच्छेद करेल व तुझा मृतदेह सुळावर ठेवेल आणि पक्षी येऊन तुझे मांस टोचून खातील.” ");
INSERT INTO marc_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","आता तिसर्‍या दिवशी फारोहचा वाढदिवस होता आणि त्याने आपल्या सर्व सरदारांसाठी मेजवानी दिली. त्याने आपल्या सरदारांसमोर मुख्य प्यालेबरदार आणि प्रमुख रोटी भाजणारा यांचे मस्तक उंचावले: ");
INSERT INTO marc_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","यावेळी त्याने मुख्य प्यालेबरदारला त्याच्या कामावर पुन्हा नेमले, तो फारोहच्या हाती पुन्हा प्याला देऊ लागला— ");
INSERT INTO marc_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","परंतु प्रमुख रोटी भाजणार्‍याला योसेफाने भाकीत केल्याप्रमाणे सुळावर चढविण्याची शिक्षा दिली. ");
INSERT INTO marc_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","मुख्य प्यालेबरदाराला योसेफाचे स्मरण राहिले नाही; त्याला तो विसरला. ");
INSERT INTO marc_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","दोन वर्षे पूर्ण झाल्यानंतर, एके रात्री फारोहला स्वप्न पडले. तो नाईल नदीच्या काठावर उभा होता. ");
INSERT INTO marc_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","तेवढ्यात एकाएकी नाईल नदीतून चांगल्या धष्टपुष्ट दिसणार्‍या सात गाई वर आल्या आणि लव्हाळ्यात चरू लागल्या. ");
INSERT INTO marc_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","नंतर नाईलमधून दुसर्‍या सात गाई आल्या; त्या अगदी कुरूप व दुबळ्या होत्या आणि नदीकाठी असलेल्या गाईंच्या शेजारी येऊन उभ्या राहिल्या. ");
INSERT INTO marc_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","मग त्या सात दुबळ्या गाईंनी त्या धष्टपुष्ट गाईंना खाऊन टाकले. यावर फारोहची झोपमोड झाली. ");
INSERT INTO marc_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","यानंतर तो पुन्हा झोपी गेला आणि त्याला पुन्हा दुसरे स्वप्न पडले: एकाच ताटाला टपोर्‍या दाण्यांची भरदार सात कणसे त्याने पाहिली. ");
INSERT INTO marc_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","मग आणखी सात कणसे उगवली, पण ही वाळून गेलेली आणि पूर्वेच्या वार्‍याने कोमेजून गेलेली होती. ");
INSERT INTO marc_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","या सात अशक्त कणसांनी टपोर्‍या दाण्यांची ती भरदार कणसे गिळून टाकली. नंतर फारोह जागा झाला आणि हे सर्व स्वप्न होते हे त्याला समजले. ");
INSERT INTO marc_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","दुसर्‍या दिवशी सकाळी, स्वप्नांचा विचार करता फारोह चिंताक्रांत झाला. मग त्याने इजिप्तमधील सर्व ज्योतिष्यांना व ज्ञानी पुरुषांना बोलाविले आणि त्यांना आपले स्वप्न सांगितले. परंतु त्यापैकी एकालाही त्या स्वप्नाचा अर्थ काय असेल हे सांगता येईना. ");
INSERT INTO marc_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","मुख्य प्यालेबरदार फारोहला म्हणाला, “आज मला माझ्या चुकीची आठवण होत आहे. ");
INSERT INTO marc_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","काही काळापूर्वी फारोह माझ्यावर आणि प्रमुख रोटी भाजणार्‍यावर रागावून त्यांनी आम्हाला सुरक्षादलाच्या अधिकार्‍याच्या घरातील बंदिवासात ठेवले होते. ");
INSERT INTO marc_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","त्यावेळी प्रमुख रोटी भाजणार्‍याला आणि मला एकाच रात्री स्वप्ने पडली, दोन्ही स्वप्नांचा अर्थ वेगळा होता. ");
INSERT INTO marc_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","त्या ठिकाणी एक इब्री तरुण होता; तो सुरक्षादलाच्या अधिकार्‍याचा गुलाम होता. त्याला आम्ही आमची स्वप्ने सांगितली आणि त्याने आम्हाला आमच्या स्वप्नांचा अर्थ सांगितला, त्याने प्रत्येकाच्या स्वप्नानुसार त्याच्या अर्थ सांगितला. ");
INSERT INTO marc_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","आणि त्याने सांगितल्याप्रमाणे प्रत्येक गोष्ट घडली: प्यालेबरदाराच्या जागी माझी पुन्हा नेमणूक झाली आणि प्रमुख रोटी भाजणार्‍याला फाशी देण्यात आली.” ");
INSERT INTO marc_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","तेव्हा फारोहने योसेफाला बोलाविणे पाठविले. योसेफाला लगेच तुरुंगाच्या कोठडीतून बाहेर आणण्यात आले आणि योसेफ मुंडण करून व कपडे बदलून फारोहपुढे दाखल झाला. ");
INSERT INTO marc_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फारोह योसेफास म्हणाला, “मला एक स्वप्न पडले, पण येथे असलेल्या कोणाही मनुष्याला त्याचा अर्थ काय असेल हे सांगता येत नाही. पण मी असे ऐकले आहे की तू स्वप्न ऐकताच, तुला स्वप्नांचा अर्थ सांगता येतो.” ");
INSERT INTO marc_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","योसेफाने उत्तर दिले, “मला स्वतःच्या बुद्धीने स्वप्नांचा अर्थ सांगता येत नाही, परंतु परमेश्वर फारोहला हितकारक उत्तर देतील.” ");
INSERT INTO marc_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","तेव्हा फारोहने योसेफाला सांगितले, “मी स्वप्नात नाईल नदीच्या काठावर उभा होतो; ");
INSERT INTO marc_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","तेवढ्यात एकाएकी नाईल नदीतून चांगल्या धष्टपुष्ट दिसणार्‍या सात गाई वर आल्या आणि लव्हाळ्यात चरू लागल्या. ");
INSERT INTO marc_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","नंतर दुसर्‍या सात गाई वर आल्या; त्या अगदी कुरूप व दुबळ्या होत्या. सर्व इजिप्त देशात अशा अशक्त गाई मी कधीही पाहिल्या नाहीत. ");
INSERT INTO marc_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","या कुरूप व दुबळ्या गाईंनी त्या पहिल्या सात धष्टपुष्ट गाईंना खाऊन टाकले. ");
INSERT INTO marc_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","असे असूनही त्यांनी त्या सात धष्टपुष्ट गाई कशा खाल्ल्या हे समजू शकले नाही; पण धष्टपुष्ट गाईंना खाऊन टाकल्यानंतरही त्या अशक्त गाई अशक्तच राहिल्या आणि मग मी जागा झालो. ");
INSERT INTO marc_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“मग मला परत स्वप्नात, एकाच ताटाला टपोर्‍या दाण्यांची भरदार सात कणसे दिसली. ");
INSERT INTO marc_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","मग त्याच ताटातून सात वाळलेली आणि पूर्वेच्या वार्‍याने कोमेजून गेलेली कणसे निघाली. ");
INSERT INTO marc_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","या अशक्त कणसांनी ती भरदार कणसे गिळून टाकली. मी हे सर्व माझ्या ज्योतिष्यांना सांगितले, परंतु त्यातील एकालाही स्वप्नांचा अर्थ सांगता आला नाही.” ");
INSERT INTO marc_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","स्वप्ने ऐकून योसेफ फारोहला म्हणाला, “फारोहला पडलेल्या या दोन्हीही स्वप्नांचा अर्थ एकच आहे. परमेश्वर काय करणार आहेत, हे त्यांनी तुम्हाला प्रगट केले आहे. ");
INSERT INTO marc_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","या दोन्हीचा अर्थ एकच आहे, सात लठ्ठ गाई म्हणजे सात वर्षांचा काळ आणि सात भरदार कणसे यांचाही अर्थ पुढील सात वर्षांचा काळ; जो अतिशय समृद्धीचा असेल. ");
INSERT INTO marc_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","त्या सात अशक्त गाई म्हणजे या सात वर्षानंतर येणारी सात वर्षे आणि पूर्वेच्या वार्‍याने कोमेजून गेलेली सात सुकलेली कणसे दुष्काळाची सात वर्षे दर्शवितात. ");
INSERT INTO marc_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“मी फारोहला जे सांगितले आहे ते असे असेल: परमेश्वर लवकरच काय करणार आहेत, हे त्यांनी तुम्हाला प्रकट केले आहे. ");
INSERT INTO marc_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","पुढील सात वर्षांचा काळ संपूर्ण इजिप्त देशासाठी अतिशय समृद्धीचा काळ असेल. ");
INSERT INTO marc_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","पण त्यानंतरच्या सात वर्षांच्या काळात इजिप्त देशामध्ये इतका मोठा दुष्काळ पडेल की, आधीच्या सात वर्षांतील सर्व समृद्धी आणि भरभराट विसरली जाईल. दुष्काळ देशाचा विध्वंस करेल. ");
INSERT INTO marc_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","तो इतका भयानक असेल की, आधीच्या समृद्धीची वर्षे आठवणार देखील नाहीत. ");
INSERT INTO marc_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","आता हे स्वप्न फारोहला दोन स्वरुपात पडले, याचा अर्थ असा की परमेश्वराने दुष्काळाची बाब निश्चित केली आहे आणि परमेश्वर त्याप्रमाणे लवकरच घडवून आणतील. ");
INSERT INTO marc_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“म्हणून आता फारोहने एक सुज्ञ आणि शहाणा मनुष्य शोधला पाहिजे आणि त्याला इजिप्त देशावर अधिकारी केले पाहिजे. ");
INSERT INTO marc_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","फारोह राजाने इजिप्त देशावर अधिकार्‍यांची नेमणूक करून सात वर्षांच्या समृद्धीच्या काळात सर्व वरकड धान्याचा पाचवा भाग गोळा करावा. ");
INSERT INTO marc_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","समृद्धीच्या वर्षात अन्नसामुग्री एकत्र करून सर्व शहरात फारोहच्या अधिकारातील धान्य कोठारात साठविण्याचे व्यवस्थापन करावे. ");
INSERT INTO marc_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ही सर्व अन्नसामुग्री राखीव म्हणून संपूर्ण देशाकरिता साठवून ठेवल्यास नंतर दुष्काळाची सात वर्षे इजिप्त देशावर आली म्हणजे खाण्यासाठी पुरेसे अन्नधान्य राहील, म्हणजे दुष्काळाने देशाचा नाश होणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","तेव्हा फारोह व त्याच्या अधिकार्‍यांना ही योजना योग्य वाटली. ");
INSERT INTO marc_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","फारोहने त्यांना विचारले, “परमेश्वराच्या आत्म्याने भरलेला या माणसासारखा दुसरा कोणी सापडेल का?” ");
INSERT INTO marc_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","मग फारोह योसेफाला म्हणाला, “ज्याअर्थी परमेश्वराने तुला या स्वप्नांचा अर्थ प्रगट केला आहे, त्याअर्थी देशामध्ये तुझ्यासारखा चतुर आणि सुज्ञ मनुष्य कोणीच नाही. ");
INSERT INTO marc_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","म्हणून तू माझ्या महालाचा अधिकारी होशील आणि माझे सर्व लोक तुझ्या अधीन होतील. केवळ सिंहासनासाठीच मी तुझ्यापेक्षा मोठा असेन.” ");
INSERT INTO marc_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","मग फारोह योसेफाला म्हणाला, “पाहा, मी तुला संपूर्ण इजिप्त देशाचा प्रमुख केले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","फारोहने आपली स्वतःची राजमुद्रा योसेफाच्या बोटात घातली. त्याला रेशमी तागाची वस्त्रे घातली आणि त्याच्या गळ्यात सोन्याची साखळी घातली. ");
INSERT INTO marc_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","फारोहने योसेफाला आपल्या खालोखालच्या पदाचा रथही दिला आणि योसेफ जिकडे जाई तिकडे ललकारी उठे, “गुडघे टेका.” अशाप्रकारे फारोहने योसेफाला संपूर्ण इजिप्त देशाचा प्रमुख केले. ");
INSERT INTO marc_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","फारोहने योसेफास म्हटले, “मी इजिप्त देशाचा राजा फारोह आहे, पण संपूर्ण इजिप्त देशभर तुझ्या परवानगीशिवाय कोणीही त्याचा हात किंवा पाय उचलणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फारोहने त्याला सापनाथ-पानेह हे नाव दिले, आणि त्याला ओन येथील पोटीफेरा याजकाची कन्या आसनथ ही पत्नी करून दिली. योसेफ संपूर्ण इजिप्त देशभर फिरला. ");
INSERT INTO marc_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","योसेफाने फारोह राजाच्या सेवेत प्रवेश केला, तेव्हा तो तीस वर्षाचा होता. नंतर राजधानी सोडून तो इजिप्त देशभर प्रवास करू लागला. ");
INSERT INTO marc_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","पुढील समृद्धीच्या सात वर्षात देशात चहूकडे भरघोस पीक आले. ");
INSERT INTO marc_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","या समृद्धीच्या सात वर्षांच्या काळात योसेफाने इजिप्तमध्ये प्रत्येक शहराच्या भोवताली असलेल्या शेतात जे अन्नधान्य पिकले ते सर्व त्याने त्या भागाच्या जवळ असलेल्या शहरात साठवून ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","योसेफाने समुद्राच्या वाळूप्रमाणे धान्याचा मोठा साठा केला; ते इतके होते की त्याने नोंदी ठेवणे बंद केले, कारण ते मोजण्यापलीकडे होते. ");
INSERT INTO marc_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","याकाळात, दुष्काळाची वर्षे येण्यापूर्वी योसेफाला ओन येथील याजक पोटीफेराची कन्या आसनथ हिच्या पोटी दोन पुत्र झाले. ");
INSERT INTO marc_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","योसेफाने त्याच्या ज्येष्ठ पुत्राचे नाव मनश्शेह असे ठेवले आणि तो म्हणाला, परमेश्वराने माझ्या सर्व यातना आणि आपल्या वडिलांच्या घराला मुकण्याचे दुःख, यांचा विसर पाडला आहे. ");
INSERT INTO marc_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","त्याच्या दुसर्‍या पुत्राचे नाव एफ्राईम असे ठेवले आले. कारण योसेफ म्हणाला, “परमेश्वराने माझ्या यातनेच्या या देशामध्ये मला फलद्रूप केले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","इजिप्त देशातील समृद्धीची सात वर्षे संपत आली. ");
INSERT INTO marc_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","मग योसेफाने भाकीत केल्याप्रमाणे दुष्काळाची सात वर्षे सुरू झाली. इजिप्त देशाच्या सभोवती असलेल्या सर्व देशांमध्ये सुद्धा दुष्काळ पडला; परंतु इजिप्तमध्ये अन्न होते. ");
INSERT INTO marc_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","इजिप्ती लोकांची उपासमार होऊ लागली, तेव्हा लोक फारोहजवळ अन्न मागू लागले आणि फारोहने त्यांना योसेफाकडे पाठविले व त्यांना सांगितले, “योसेफ सांगेल त्याप्रमाणे करा.” ");
INSERT INTO marc_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","तेव्हा आता सर्व देशभर दुष्काळ पसरला असताना योसेफाने धान्याची कोठारे उघडली आणि तो इजिप्त देशाच्या लोकांना धान्य विकू लागला, कारण इजिप्तचा दुष्काळ अत्यंत भयानक होता. ");
INSERT INTO marc_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","जगभर दुष्काळ पडल्यामुळे संपूर्ण जगातील लोक इजिप्तमध्ये येऊन योसेफाकडून धान्य विकत घेऊ लागले. ");
INSERT INTO marc_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","इजिप्त देशामध्ये धान्य मिळते, हे जेव्हा याकोबाच्या कानी गेले, तेव्हा तो आपल्या पुत्रांना म्हणाला, “एकमेकांच्या तोंडाकडे नुसते पाहत का उभे राहिलात?” ");
INSERT INTO marc_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","मग त्याने पुढे म्हटले, “इजिप्तमध्ये धान्य मिळत आहे, असे मी ऐकले आहे. तुम्ही तिथे जा आणि आपल्यासाठी थोडे धान्य विकत घेऊन या, म्हणजे आपण जगू, मरणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","मग योसेफाचे दहा भाऊ, धान्य विकत घेण्यासाठी इजिप्तमध्ये गेले. ");
INSERT INTO marc_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","परंतु याकोबाने योसेफाचा भाऊ बिन्यामीन याला, त्यांच्याबरोबर पाठविले नाही, कारण त्याला काही अपाय होईल अशी त्याला भीती वाटत होती. ");
INSERT INTO marc_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","अशा रीतीने इस्राएलचे पुत्र इतर लोकांबरोबर इजिप्तमध्ये धान्य खरेदीसाठी आले, कारण दुष्काळ कनान देशातही पडला होता. ");
INSERT INTO marc_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","योसेफ हा इजिप्त देशाचा अधिकारी असल्यामुळे तो सर्व लोकांना धान्यविक्री करीत असे. जेव्हा त्याचे भाऊ तिथे आले, त्यांनी त्याच्यापुढे जमिनीपर्यंत लवून त्याला मुजरा केला. ");
INSERT INTO marc_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","योसेफाने त्यांना बघताच ओळखले तरी अपरिचितासारखे वागून दरडावून विचारले, “तुम्ही कुठून आला आहात?” त्यांनी त्याला उत्तर दिले, “कनान देशाहून आम्ही धान्य विकत घेण्यासाठी आलो आहोत.” ");
INSERT INTO marc_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","योसेफाने तर त्याच्या भावांना ओळखले, पण त्या भावांनी त्याला ओळखले नाही. ");
INSERT INTO marc_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","यावेळी योसेफाला आपल्याला पूर्वी पडलेल्या स्वप्नांची आठवण झाली, आणि त्यांना म्हणाला, “तुम्ही हेर आहात! आणि आमचा देश कुठे असुरक्षित आहे हे पाहण्यासाठी आला आहात.” ");
INSERT INTO marc_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ते म्हणाले, “नाही, नाही महाराज, आपले सेवक फक्त धान्य खरेदीसाठी आले आहेत. ");
INSERT INTO marc_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","आम्ही भाऊ एकाच पित्याचे पुत्र आहोत, तुमचे सेवक प्रामाणिक पुरुष आहेत, आम्ही हेर नाही.” ");
INSERT INTO marc_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“नाही,” तो त्यांना म्हणाला, “आमचा देश कुठे असुरक्षित आहे हे पाहण्यासाठीच तुम्ही आला आहात.” ");
INSERT INTO marc_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","परंतु ते म्हणाले, “महाराज, आपले हे सेवक बारा भाऊ आहेत; एकाच पित्याचे पुत्र आहोत, जे कनान देशात आहेत; आमचा धाकटा भाऊ आमच्या पित्यासोबत आहे आणि आमचा एक भाऊ आता जीवित नाही.” ");
INSERT INTO marc_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","योसेफ म्हणाला, “म्हणूनच मी म्हणतो: तुम्ही हेर आहात! ");
INSERT INTO marc_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","आणि अशा प्रकारे तुम्हाला पडताळून पाहू: फारोहच्या जिवाची शपथ, तुमचा धाकटा भाऊ इकडे येईपर्यंत तुम्हाला येथून जाता येणार नाही. ");
INSERT INTO marc_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","तुमच्यापैकी एकाला भावास आणण्यास पाठवा; तोपर्यंत बाकीच्यांना तुरुंगात ठेवण्यात येईल, म्हणजे तुम्ही सत्य बोललात ते कळून येईल. जर नाही तर फारोहची शपथ तुम्ही हेर आहात!” ");
INSERT INTO marc_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","आणि त्याने त्या सर्वांना तीन दिवस तुरुंगात ठेवले. ");
INSERT INTO marc_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तिसर्‍या दिवशी योसेफ त्यांना म्हणाला, “जर जीवित राहवयाचे असेल तर तुम्ही हे करा, कारण मी परमेश्वराचे भय धरणारा आहे. ");
INSERT INTO marc_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","तुम्ही प्रामाणिक लोक आहात तर तुमच्या एका भावाला तुरुंगात राहू द्या, बाकीच्यांना कुटुंबीयांची उपासमार निवारण्यासाठी धान्य घेऊन जाऊ द्या. ");
INSERT INTO marc_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","परंतु तुम्ही तुमच्या धाकट्या भावाला माझ्याकडे घेऊन या. अशा रीतीने तुमचे शब्द खरे होतील आणि तुमचा मृत्यू टळेल.” मग त्यांनी तेच केले. ");
INSERT INTO marc_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ते एकमेकांना म्हणाले, “आम्ही आमच्या भावाविषयी दोषी आहोत. जेव्हा त्याने आपल्या जिवाची विनवणी केली तेव्हा तो किती व्यथित होता हे आम्ही पाहिले, पण आम्ही ऐकले नाही; त्यामुळेच हे संकट आमच्यावर आले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रऊबेन म्हणाला, “त्या मुलाविरुद्ध असे पाप करू नका, हे मी तुम्हाला सांगत नव्हतो का? पण तुम्ही माझे ऐकले नाही! आम्हाला त्याच्या रक्तपाताचा हिशोब द्यावा लागेल.” ");
INSERT INTO marc_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","योसेफाला आपले बोलणे समजत असेल असे त्यांना वाटले नाही, कारण तो दुभाषी वापरत होता. ");
INSERT INTO marc_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","तो तिथून बाहेर पडला व रडू लागला, थोड्या वेळाने तो परत आला आणि त्याने शिमओनाची निवड करून त्याला त्यांच्या डोळ्यांसमक्ष बांधून घेतले. ");
INSERT INTO marc_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","नंतर योसेफाने आपल्या नोकरांना त्यांची पोती धान्याने भरण्यास सांगितले; पण त्याचवेळी त्याने प्रत्येक भावाने दिलेले पैसे ज्याच्या त्याच्या पोत्यात ठेवून द्यावे अशी सूचना दिली. त्याने आपल्या भावांना प्रवासासाठी अन्नसामुग्री देण्याचा आदेश दिला. ");
INSERT INTO marc_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","शेवटी त्यांनी धान्याची पोती गाढवांवर लादली आणि ते घरी जाण्यास निघाले. ");
INSERT INTO marc_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","परंतु ते रात्रीच्या मुक्कामासाठी थांबले असताना त्यांच्यापैकी एकाने गाढवांना देण्यासाठी थोडे धान्य काढले. धान्य काढीत असताना आपले पैसे पोत्याच्या तोंडाशी असलेले त्याला दिसले. ");
INSERT INTO marc_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","तो आपल्या भावांना म्हणाला, “अरे हे काय? माझे पैसे माझ्या पोत्यातच आहेत!” ते सर्वजण भयभीत झाले. भयाने थरथर कापत ते एकमेकास म्हणाले, “परमेश्वराने आपल्याशी हे काय केले?” ");
INSERT INTO marc_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","कनान देशात ते आपले पिता याकोबाकडे आले आणि इजिप्तमध्ये जे काही घडले त्याची सर्व हकिकत त्यांनी त्याला सांगितली. ");
INSERT INTO marc_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ते म्हणाले, “त्या देशाचा अधिकारी आमच्याशी अत्यंत कठोरतेने बोलला, त्याने आम्हाला हेर असल्यासारखे वागविले.” ");
INSERT INTO marc_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","आम्ही त्याला म्हटले, “आम्ही हेर नाहीत; आम्ही प्रामाणिक माणसे आहोत. ");
INSERT INTO marc_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","आम्ही बारा भाऊ असून एकाच पित्याचे पुत्र आहोत. आमचा एक भाऊ मरण पावला आहे, आणि धाकटा भाऊ कनान देशामध्ये आमच्याच पित्याजवळ राहिला आहे.” ");
INSERT INTO marc_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","तेव्हा त्या देशाचा अधिपती आम्हाला म्हणाला, “तुमच्या म्हणण्याप्रमाणे तुम्ही प्रामाणिक माणसे आहात की नाही, याची खात्री करून घेण्यासाठी मी असे ठरविले आहे: तुमच्यापैकी एका भावाला येथे तुरुंगात ठेवावे; बाकीच्यांनी तुमच्या कुटुंबीयांसाठी धान्य घेऊन घरी जावे. ");
INSERT INTO marc_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","पण तुमच्या धाकट्या भावाला माझ्याकडे घेऊन या; मगच तुम्ही हेर नाहीत, तर प्रामाणिक माणसे आहात हे मला समजेल. तर मी तुमचा भाऊ तुम्हाला परत देईन व तुम्ही या देशात व्यापार करू शकाल.” ");
INSERT INTO marc_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","त्यांनी त्यांची धान्याची पोती रिकामी केली तो, प्रत्येकाच्या पोत्याच्या तोंडाशी त्यांनी दिलेले पैसे होते असे त्यांना दिसून आले! भयाने त्यांचा व त्यांच्या वडिलांचाही थरकाप उडाला. ");
INSERT INTO marc_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","मग याकोब त्यांना म्हणाला, “तुम्ही माझ्या मुलांना हिरावून घेतले आहे. योसेफ राहिला नाही, शिमओन गेला; आता तुम्ही बिन्यामीनालाही नेणार; सर्वकाही माझ्या विरुद्धच घडत आहे.” ");
INSERT INTO marc_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","तेव्हा रऊबेन आपल्या वडिलांस म्हणाला, “मी बिन्यामीनाला तुमच्याकडे परत आणले नाही तर तुम्ही माझ्या दोन मुलांना मारून टाका; बिन्यामीनाला माझ्या हवाली करा, मी त्याला परत तुमच्याकडे आणेन.” ");
INSERT INTO marc_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","पण याकोबाने उत्तर दिले, “माझा मुलगा तुमच्याबरोबर तिथे जाणार नाही; त्याचा भाऊ योसेफ मरण पावला आणि आता तो एकटाच राहिला आहे; त्याला काही कमीजास्त झाले तर या म्हातारपणात दुःखाने माझा प्राण जाईल!” ");
INSERT INTO marc_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","परंतु देशात दुष्काळ तीव्र होता. ");
INSERT INTO marc_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","इजिप्तमधून त्यांनी आणलेले धान्य संपले तेव्हा त्यांचे वडील त्यांना म्हणाले, “इजिप्तमध्ये पुनः जाऊन आपल्यासाठी थोडे धान्य विकत आणा.” ");
INSERT INTO marc_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","तेव्हा यहूदाह त्यास म्हणाला, “त्या मनुष्याने आम्हाला चेतावणी दिली होती की, ‘तुमच्या भावास सोबत आणल्याशिवाय तुम्ही माझे मुख पाहणार नाही.’ ");
INSERT INTO marc_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","जर तुम्ही आमच्या भावाला आमच्याबरोबर पाठवाल तरच आम्ही जाऊन धान्य विकत घेऊ. ");
INSERT INTO marc_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","जर तुम्ही त्याला पाठवित नसाल तर आम्ही जाणार नाही, कारण त्या मनुष्याने आम्हाला म्हटले, ‘जर तुम्ही तुमच्या भावास सोबत आणले नाही तर तुम्ही माझे मुख पाहणार नाही.’ ” ");
INSERT INTO marc_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","इस्राएल म्हणाला, “तुम्हाला आणखी एक भाऊ आहे असे तुम्ही त्याला सांगून माझ्यावर हे अनर्थ का आणले?” ");
INSERT INTO marc_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","यावर ते म्हणाले, “पण त्या मनुष्याने आपल्याबद्दल आणि आपल्या कुटुंबाची खोल चौकशी केली. त्याने आम्हाला विचारले, ‘तुमचे वडील अजून जिवंत आहेत काय? तुम्हाला आणखी एखादा भाऊ आहे काय?’ आम्ही सहजपणे त्याच्या प्रश्नांची उत्तरे दिली. ‘तुमच्या भावाला घेऊन या’ असे तो म्हणेल, असे आम्हाला कसे ठाऊक असणार?” ");
INSERT INTO marc_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","तेव्हा यहूदाह आपला पिता इस्राएलला म्हणाला, “मुलाला माझ्याबरोबर पाठवा, आम्ही लगेच जाऊ, म्हणजे तुम्ही, आम्ही व आमची मुले जगणार आणि मरणार नाही. ");
INSERT INTO marc_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","त्याच्या सुरक्षिततेची हमी मी घेतो. जर मी त्याला परत आणले नाही व तुमच्या स्वाधीन केले नाही, तर त्याचा दोष माझ्या माथ्यावर कायमचा राहील. ");
INSERT INTO marc_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","जर आम्ही उशीर केला नसता तर इतक्या दिवसात आम्ही तिकडे दोनदा जाऊन आलो असतो.” ");
INSERT INTO marc_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","नंतर त्यांचे वडील इस्राएल त्यांना म्हणाले, “जर असेच असेल तर मग हे करा: या देशात उत्पादन होणारे सर्वोत्तम पदार्थ—थोडे औषधी बलसान, थोडे मध, मसाले, गंधरस, पिस्ते व बदाम आपल्या गोण्यात घ्या आणि या वस्तू त्या मनुष्याला देणगी म्हणून घेऊन जा. ");
INSERT INTO marc_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","दुप्पट चांदी सोबत घेऊन जा म्हणजे तुमच्या पोत्याच्या तोंडाशी असलेला चांदीचा पैसाही तुम्हाला परत करता येईल. कदाचित काही तरी चूक झाली असेल. ");
INSERT INTO marc_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","तुमच्या भावाला बरोबर घेऊन त्या मनुष्याकडे लगेच जा. ");
INSERT INTO marc_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","त्या माणसापुढे, सर्वसमर्थ परमेश्वराने तुमच्यावर कृपा करावी म्हणजे तो दुसर्‍या भावाला आणि बिन्यामीनालाही तुमच्यासोबत परत पाठवेल. पण जर मी माझ्या पुत्रांना मुकलो तर मुकलो.” ");
INSERT INTO marc_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","मग त्यांनी भेट व दुप्पट चांदी आणि बिन्यामीनाला सोबत घेतले आणि खाली इजिप्तला गेले आणि योसेफापुढे उपस्थित झाले. ");
INSERT INTO marc_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","बिन्यामीन त्यांच्याबरोबर आहे हे योसेफाने पाहिले, तेव्हा तो आपल्या घराच्या कारभार्‍याला म्हणाला, “या माणसांना माझ्या घरी घेऊन जा, पशू मार आणि भोजन तयार कर; ते दुपारी माझ्याबरोबर भोजन करतील.” ");
INSERT INTO marc_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","त्या मनुष्याने योसेफाच्या सांगितल्याप्रमाणे केले आणि त्याने माणसांना योसेफाच्या घरी नेले. ");
INSERT INTO marc_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","त्यांना योसेफाच्या घरी नेल्यावर त्यांची भीतीने गाळण उडाली. त्यांनी विचार केला आणि म्हणाले, “पहिल्यांदा आपल्या पोत्यात जी चांदी टाकण्यात आली होती त्यासाठी आपल्याला इथे आणण्यात आले आहे. आपल्यावर हल्ला करून आपल्यावर विजय मिळवून आपल्याला गुलाम करावे व आपल्या गाढवांना हस्तगत करावे असा त्याचा बेत असावा.” ");
INSERT INTO marc_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","घराच्या दाराशी आल्यानंतर ते योसेफाच्या घरकारभार्‍याकडे गेले; ");
INSERT INTO marc_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","आणि त्याला म्हणाले, “महाराज, पहिल्या फेरीत आम्ही इथे धान्य खरेदीसाठी आलो होतो. ");
INSERT INTO marc_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","तेव्हा परत घरी जाताना आम्ही रात्री जिथे थांबलो आणि आमची पोती उघडली तेव्हा आम्हा प्रत्येकाचा पोत्यात त्याची चांदी—अचूक वजनाची—पोत्याच्या तोंडाशी सापडली. आम्ही ती परत देण्यासाठी बरोबर आणली आहे. ");
INSERT INTO marc_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","या रकमेबरोबरच धान्य विकत घेण्यासाठी आम्ही वेगळी चांदी आणली आहे. आमच्या पोत्यांमध्ये आमची चांदी कोणी ठेवली हे आम्हाला माहीत नाही.” ");
INSERT INTO marc_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“ते सर्व ठीक आहे,” तो म्हणाला, “घाबरू नका. तुमचा परमेश्वर, तुमच्या पित्याचा परमेश्वर यांनीच तुमच्या पोत्यात ते धन दिले आहे; तुमची चांदी मला मिळाली आहे.” मग त्याने शिमओनाला बाहेर काढून त्यांच्याकडे आणले. ");
INSERT INTO marc_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","नंतर घरकारभार्‍याने त्यांना योसेफाच्या घरात नेले, त्यांचे पाय धुण्यासाठी पाणी दिले आणि त्यांच्या गाढवांना चाराही दिला. ");
INSERT INTO marc_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","योसेफ दुपारी येणार त्यावेळी त्याला देण्यासाठी त्यांनी आपली भेट तयार करून ठेवली, कारण त्यांना तिथेच भोजन करावयाचे आहे असे सांगण्यात आले होते. ");
INSERT INTO marc_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","योसेफ घरी आला तेव्हा त्यांनी त्याला जमिनीपर्यंत लवून मुजरा केला आणि त्याला देणग्या दिल्या ज्या त्यांनी घरात आणल्या होत्या. ");
INSERT INTO marc_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","त्याने त्यांना अभिवादन केले, मग त्याने विचारले, “त्या वृद्ध माणसाविषयी तुम्ही बोलला, ते तुमचे वडील कसे आहेत? ते अजून जिवंत आहेत काय?” ");
INSERT INTO marc_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“होय” ते म्हणाले, “तुमचा सेवक, आमचे वडील जिवंत असून सुखरुप आहेत,” आणि त्यांनी त्याला पुन्हा लवून मुजरा केला. ");
INSERT INTO marc_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","त्याने आपली नजर वर करून आपल्या आईचा मुलगा, आपला सख्खा भाऊ, बिन्यामीनाकडे पाहून त्याने विचारले, “हाच का तुमचा धाकटा भाऊ, याच्याचविषयी तुम्ही मला सांगत होता ना?” आणि तो म्हणाला, “माझ्या मुला, परमेश्वर तुजवर कृपा करो.” ");
INSERT INTO marc_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","नंतर योसेफ घाईघाईने बाहेर जाऊन रडण्यासाठी जागा शोधत होता, कारण आपल्या भावाबद्दलच्या प्रेमाने त्याचा ऊर भरून आला होता, तो आपल्या स्वतःच्या खोलीत जाऊन रडला. ");
INSERT INTO marc_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","मग तो आपले तोंड धुऊन बाहेर आला आणि स्वतःवर ताबा ठेवून म्हणाला, “भोजन वाढा.” ");
INSERT INTO marc_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","योसेफ एकटाच जेवला; आणि त्याच्या भावांना वेगळ्या पंक्तीत बसविले; त्याचप्रमाणे इजिप्त लोकांचीही वेगळीच पंगत होती, कारण इजिप्तचे लोक इब्री लोकांना तुच्छ लेखीत आणि त्यांच्या पंक्तीला बसून कधीही भोजन करीत नसत. ");
INSERT INTO marc_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","प्रत्येकाने कुठे बसावे हे त्याने सांगितले आणि त्यांना ज्येष्ठापासून कनिष्ठापर्यंत त्यांच्या वयाप्रमाणे बसविले, यावर फार आश्चर्यचकित होऊन ते एकमेकांकडे पाहू लागले. ");
INSERT INTO marc_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","योसेफ, जी पक्वान्ने खात होता, तीच पक्वान्ने त्यांनाही वाढण्यात आली. पण बिन्यामीनाला इतर भावांपेक्षा पाचपट अधिक वाढण्यात आले. ते सर्व त्याच्यासोबत भरपूर जेवले व मनमुरादपणे पिऊन तृप्त झाले. ");
INSERT INTO marc_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","आता योसेफाने आपल्या घरकारभार्‍यास आदेश दिला: “माणसांच्या पोत्यात त्यांना वाहून नेण्याइतके अन्न भरावे आणि प्रत्येक माणसाच्या पोत्याच्या तोंडाशी त्यांची चांदी ठेवावी. ");
INSERT INTO marc_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","याखेरीज धाकट्याच्या पोत्यामध्ये धान्याच्या पैशाबरोबरच माझा चांदीचा प्यालाही ठेवा.” असे सांगितले आणि घरकारभार्‍याने योसेफाच्या आदेशाप्रमाणे केले. ");
INSERT INTO marc_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","पहाट होताच त्या माणसांना त्यांच्या गाढवांसोबत मार्गस्थ करण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","पण ते शहराच्या बाहेर पडतात न पडतात तोच योसेफ त्याच्या कारभार्‍यास म्हणाला, “त्यांचा पाठलाग करा आणि त्यांना थांबवून विचारा, ‘तुम्ही चांगल्याची फेड वाईटाने का केली? ");
INSERT INTO marc_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","हाच तो चांदीचा प्याला नाही का जो माझे स्वामी स्वतः पिण्याकरिता वापरतात आणि ज्याच्यामधून ते शकुनही पाहत असतात? हे तुमचे कृत्य किती वाईट आहे!’ ” ");
INSERT INTO marc_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","त्याप्रमाणे त्याने त्यांना गाठले आणि सांगितल्याप्रमाणे तो त्यांना बोलला. ");
INSERT INTO marc_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","पण ते त्याला म्हणाले, “महाराज असे का बोलतात? तुमच्या सेवकांपासून असे काही करणे दूरच असो! ");
INSERT INTO marc_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","मागीलवेळी आमच्या पोत्यांच्या तोंडाशी असलेला पैसा आम्ही कनानहून परत आणला नाही काय? तर आता तुमच्या धन्याच्या घरून चांदी किंवा सोने चोरण्याची आम्हाला काय गरज होती? ");
INSERT INTO marc_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","आमच्यापैकी कोणाच्याही जवळ जर तो प्याला सापडला तर त्याला मृत्यू येवो; आणि आम्ही सर्वजण तुझ्या धन्याचे गुलाम होऊ.” ");
INSERT INTO marc_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","त्या मनुष्याने उत्तर दिले, “ठीक आहे, तुम्ही जे म्हणता त्याप्रमाणे होईल; परंतु ज्याच्याजवळ तो प्याला सापडेल तोच माझ्या धन्याचा गुलाम होईल; बाकीचे दोषापासून मुक्त होतील.” ");
INSERT INTO marc_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","आपल्या पोती त्यांनी लगबगीने खाली जमिनीवर ठेऊन ती उघडली; ");
INSERT INTO marc_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","त्या कारभार्‍याने वडील भावापासून आरंभ करून धाकट्या भावाच्या पोत्यापर्यंत शोध केला; आणि तो प्याला बिन्यामीनच्या पोत्यामध्ये सापडला. ");
INSERT INTO marc_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","हताश होऊन त्यांनी आपले कपडे फाडले, आपल्या गाढवांवर पोती लादली आणि ते पुन्हा शहरात परतले. ");
INSERT INTO marc_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","यहूदाह आणि त्याचे भाऊ आले, त्यावेळी योसेफ घरीच होता आणि त्यांनी त्याच्यापुढे लोटांगण घातले. ");
INSERT INTO marc_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","योसेफाने विचारले, “तुम्ही हे काय केले? माझ्यासारखा मनुष्य शकुन पाहून या गोष्टी जाणून घेऊ शकतो हे तुम्हाला माहिती नव्हते का?” ");
INSERT INTO marc_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदाहने उत्तर दिले, “आमच्या स्वामीपुढे आम्ही काय बोलावे? आमची निर्दोषता आम्ही कशी सिद्ध करावी? परमेश्वराने तुमच्या दासांचे अपराध उघडे केले आहे. महाराज, आम्ही सर्वजण आणि ज्याच्या पोत्यात प्याला सापडला तो देखील तुमचे गुलाम आहोत.” ");
INSERT INTO marc_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","योसेफ म्हणाला, “अशी गोष्ट माझ्याकडून कधीही न होवो! ज्या मनुष्याकडे माझा प्याला मिळाला, तोच माझा गुलाम होईल बाकीचे तुम्ही तुमच्या वडिलांकडे शांतीने परत जा.” ");
INSERT INTO marc_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","तेव्हा यहूदाह पुढे सरसावून म्हणाला, “महाराज, तुमच्या सेवकाला क्षमा करा, मला एक शब्द बोलू द्या, क्षणभर माझे ऐकून घ्या. कृपया, आपल्या सेवकावर रागावू नका, कारण तुम्ही प्रत्यक्ष फारोहसमान आहात. ");
INSERT INTO marc_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","महाराज, तुमच्या सेवकांना तुम्ही विचारले होते की, तुम्हाला वडील आहेत का? तुम्हाला आणखी एखादा भाऊ आहे का? ");
INSERT INTO marc_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","आणि आम्ही आमच्या प्रभूला उत्तर दिले की, ‘आम्हाला वृद्ध वडील आहेत आणि अशा वृद्धापकाळातच त्यांना एक पुत्र झाला. त्याचा भाऊ मरण पावला आहे आणि त्याच्या आईला झालेल्या पुत्रांपैकी तो एकटाच उरलेला आहे आणि त्याचे वडील त्याच्यावर खूप प्रीती करतात.’ ");
INSERT INTO marc_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“तेव्हा तुम्ही तुमच्या सेवकांना म्हणाले, ‘त्याला माझ्याकडे घेऊन या, म्हणजे मी त्याला पाहू शकेन.’ ");
INSERT INTO marc_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","आणि आम्ही आमच्या महाराजास म्हणालो, ‘तो मुलगा आपल्या वडिलांना सोडू शकत नाही; जर त्याने वडिलांना सोडले तर त्याचे वडील मरतील.’ ");
INSERT INTO marc_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","पण तुम्ही आपल्या सेवकांना सांगितले की, ‘जर तुमचा धाकटा भाऊ तुमच्यासोबत आला नाही तर तुम्ही माझे मुख पाहू शकणार नाही.’ ");
INSERT INTO marc_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","जेव्हा आम्ही परत तुमचा सेवक आमच्या पित्याकडे जाऊन पोहोचलो, आम्ही त्यांना महाराज काय म्हणाले ते सांगितले. ");
INSERT INTO marc_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“आमच्या वडिलांनी म्हटले, ‘परत जा आणि थोडे धान्य विकत घेऊन या.’ ");
INSERT INTO marc_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","परंतु आम्ही म्हणालो, ‘आम्ही खाली जाऊ शकत नाही, जर आमचा धाकटा भाऊ आमच्याबरोबर असला तरच आम्ही जाणार. आमचा धाकटा भाऊ आमच्याबरोबर असल्याशिवाय आम्ही त्या मनुष्याचे मुख पाहू शकणार नाही.’ ");
INSERT INTO marc_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“मग तुमचे सेवक, आमचे वडील आम्हाला म्हणाले, ‘माझ्या पत्नीने माझ्या दोन पुत्रांना जन्म दिला. ");
INSERT INTO marc_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","त्यापैकी एक माझ्यापासून दूर गेला तेव्हा मी म्हणालो, “त्याला एखाद्या श्वापदाने फाडून त्याचे तुकडे केले असावेत,” त्यानंतर मी त्याला पहिले नाही. ");
INSERT INTO marc_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","जर यालाही तुम्ही माझ्यापासून घेऊन जाल आणि त्याच्यावरही संकट आले तर तुम्ही माझ्या पिकलेल्या केसाला दुःखाने कबरेत लोटण्यास कारणीभूत व्हाल.’ ");
INSERT INTO marc_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“आमच्या वडिलांचा जीव मुलाच्या जिवाशी इतका निगडीत आहे की, आता जेव्हा मी तुमचा सेवक, आम्ही या मुलाशिवाय परतलो, ");
INSERT INTO marc_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","आणि मुलगा आमच्याबरोबर नाही असे जर त्यांनी पाहिले तर ते प्राण सोडतील आणि त्यांच्या पिकलेल्या केसांना दुःखात व कबरेत लोटण्यास आम्ही कारणीभूत होऊ. ");
INSERT INTO marc_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","तुमच्या सेवकाने आमच्या वडिलांना अभिवचन दिले आहे की, मुलाची मी काळजी घेईन. मी त्यांना सांगितले की, ‘मी जर त्याला परत आणले नाही तर त्याचा दोष माझ्या जीवनात सदैव माझ्या माथ्यावर राहील!’ ");
INSERT INTO marc_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“म्हणून महाराज, कृपा करा आणि त्या मुलाऐवजी मलाच येथे तुमचा गुलाम म्हणून राहू द्या आणि मुलाला त्याच्या भावांबरोबर परत जाऊ द्या. ");
INSERT INTO marc_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","कारण मुलगा माझ्याबरोबर नसला तर मी माझ्या वडिलांकडे कसे जाऊ शकतो? माझ्या वडिलांना होणारे दुःख मला पाहवणार नाही.” ");
INSERT INTO marc_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","आता मात्र आपल्या सेवकांसमोर योसेफाचा भावनावेग अनावर झाला आणि तो मोठ्याने ओरडला, “सगळ्यांनी माझ्या समक्षतेतून बाहेर जावे!” योसेफाने तिथे कोणी नसताना स्वतःला आपल्या भावांसमोर प्रगट केले. ");
INSERT INTO marc_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","मग तो इतक्या मोठमोठ्याने रडू लागला की, ते इजिप्तच्या लोकांनी ऐकले आणि फारोहच्या घराण्यातील लोकांनीही ते ऐकले. ");
INSERT INTO marc_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","तेव्हा योसेफ आपल्या भावांना म्हणाला, “मी योसेफ आहे! माझे वडील अद्याप जिवंत आहेत काय?” परंतु त्याचे भाऊ इतके घाबरले होते की त्यांच्या मुखातून एकही शब्द बाहेर पडेना. ");
INSERT INTO marc_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","तेव्हा योसेफाने आपल्या भावांना म्हटले, “माझ्याजवळ या!” ते जवळ आल्यावर तो त्यांना म्हणाला, “ज्या भावाला विकून तुम्ही इजिप्त देशात पाठवून दिले होते, तो मी तुमचा भाऊ योसेफ आहे! ");
INSERT INTO marc_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","तुम्ही मला अशा रीतीने वागविले म्हणून वाईट वाटून घेऊ नका व त्रागा करून घेऊ नका, कारण तुमचे जीव वाचविण्याकरिता परमेश्वरानेच मला तुमच्यापुढे इकडे पाठविले. ");
INSERT INTO marc_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","दुष्काळ पडून आता दोनच वर्षे झाली आणि अद्यापही पाच वर्षे आहेत. त्या काळात नांगरणी व कापणी अजिबात होणार नाही. ");
INSERT INTO marc_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","परंतु पृथ्वीवर जे उरले आहेत, त्या तुम्हाला वाचवण्यासाठी आणि मोठ्या मुक्तिद्वारे तुमचे जीवन सुरक्षित करण्यासाठी परमेश्वराने मला तुमच्या आधी इथे पाठवले आहे. ");
INSERT INTO marc_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“म्हणजे आता तुम्ही नव्हे तर खुद्द परमेश्वरानेच मला इकडे पाठविले. त्यांनीच मला फारोहचा सल्लागार, त्याच्या घराण्याचा व्यवस्थापक आणि संपूर्ण इजिप्त देशाचा अधिपती केले आहे. ");
INSERT INTO marc_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","आता त्वरा करा आणि माझ्या वडिलांकडे जाऊन त्यांना सांगा की, तुमचा पुत्र योसेफ असे म्हणतो: ‘परमेश्वराने मला संपूर्ण इजिप्त देशाचा प्रमुख केले आहे, म्हणून आता क्षणाचाही विलंब न लावता माझ्याकडे येथे या. ");
INSERT INTO marc_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","म्हणजे तुम्ही, तुमची मुले व तुमची नातवंडे, गुरे, शेरडेमेंढरे आणि जे सर्वकाही तुमचे आहे, त्यासह तुम्हाला येथे गोशेन प्रांतात राहता येईल. ");
INSERT INTO marc_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","मी तुमची या ठिकाणी काळजी घेईन, कारण आपल्यापुढे दुष्काळाची अजून पाच वर्षे आहेत आणि तुम्ही इकडे आला नाही तर, तुम्ही तुमच्या सर्व कुटुंबासह निराधार व्हाल.’ ");
INSERT INTO marc_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“तुम्ही हे स्वतः बघत आहात व माझा भाऊ बिन्यामीनही बघत आहे, की खरोखर मीच तुमच्याशी बोलत आहे. ");
INSERT INTO marc_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","आपल्या वडिलांना इजिप्तमध्ये मला देण्यात आलेला आदर आणि जे सर्वकाही तुम्ही पाहिले ते सांगा आणि त्यांना माझ्याकडे तत्परतेने घेऊन या.” ");
INSERT INTO marc_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","मग आनंदाने रडू येत असतानाच, त्याने बिन्यामीनाला मिठी मारली आणि बिन्यामीनही रडू लागला. ");
INSERT INTO marc_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","मग त्याने आपल्या प्रत्येक भावाला मिठी मारली व त्यांच्यासह रडला आणि नंतर त्याचे भाऊ त्याच्याशी बोलू लागले. ");
INSERT INTO marc_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","योसेफाचे भाऊ आले आहेत ही बातमी फारोहपर्यंत पोहोचली, तेव्हा ती ऐकून फारोहला आणि त्याच्या अधिकार्‍यांना अतिशय आनंद झाला. ");
INSERT INTO marc_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","फारोह योसेफाला म्हणाला, “तुझ्या भावांना सांग, ‘आपली जनावरे लादा आणि झटपट कनान देशातील आपल्या घरी जा, ");
INSERT INTO marc_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","आणि तुमचे वडील व सर्व कुटुंबीय मंडळी यांना इजिप्तमध्येच राहण्यासाठी घेऊन या. त्यांना सांगा, फारोह तुम्हाला इजिप्त देशातील सर्वात सुपीक प्रदेश बहाल करेल म्हणजे या देशातील उत्तम पदार्थ तुम्हाला खावयास मिळतील.’ ");
INSERT INTO marc_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“आणि तुझ्या भावांना असेही सांग, ‘तुमच्या स्त्रिया, मुले आणि तुमचे वडील यांना घेऊन येण्यासाठी इजिप्तमधून गाड्या घेऊन जा. ");
INSERT INTO marc_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","तुमच्या मालमत्तेची काळजी करू नका, कारण इजिप्त देशात जे काही उत्कृष्ट आहे ते तुमचेच होईल.’ ” ");
INSERT INTO marc_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","इस्राएलच्या पुत्रांनी तसेच केले. फारोहच्या आज्ञेप्रमाणे योसेफाने त्यांना सामान आणण्यासाठी गाड्या दिल्या; तसेच प्रवासासाठी अन्नधान्यही दिले. ");
INSERT INTO marc_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","त्याने त्या प्रत्येकाला नवीन पोशाख दिला, परंतु बिन्यामीनाला त्याने पाच नवीन पोशाख आणि तीनशे शेकेल चांदी दिली. ");
INSERT INTO marc_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","त्याने आपल्या वडिलांसाठी इजिप्तमधील सर्वोत्तम वस्तूंनी लादलेली दहा गाढवे पाठवली. प्रवासासाठी धान्य व खाद्यपदार्थ यांनी लादलेल्या दहा गाढवीही रवाना केल्या. ");
INSERT INTO marc_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","अशा रीतीने त्याने त्याच्या भावांची रवानगी केली. त्यांना प्रत्यक्ष निरोप देताना तो त्यांना म्हणाला, “रस्त्याने जाताना भांडू नका!” ");
INSERT INTO marc_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","निरोप घेऊन ते इजिप्तमधून निघाले व कनान देशात आपले वडील याकोब याच्याकडे आले. ");
INSERT INTO marc_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ते त्यांना म्हणाले, “योसेफ अजून जिवंत आहे! तो इजिप्त देशाचा अधिपती झाला आहे.” हे ऐकून याकोब अवाक झाला; त्याचा त्याच्या पुत्रांच्या बातमीवर विश्वास बसेना. ");
INSERT INTO marc_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","परंतु जेव्हा त्यांनी त्याला योसेफाचा निरोप सांगितला आणि योसेफाने पाठविलेल्या धान्याच्या गाड्या त्याने पाहिल्या, तेव्हा त्यांचा पिता याकोब याच्या आत्म्याला नवचैतन्य प्राप्त झाले. ");
INSERT INTO marc_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","आणि इस्राएलने म्हटले, “माझी खात्री झाली आहे! माझा पुत्र योसेफ जिवंत आहे, आता मृत्यूपूर्वी मी स्वतः त्याला जाऊन भेटेन.” ");
INSERT INTO marc_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","अशा रीतीने इस्राएल आपले सर्वस्व घेऊन निघाला आणि बेअर-शेबा येथे पोहोचल्यावर त्याने आपला पिता इसहाक याच्या परमेश्वराला अर्पणे वाहिली. ");
INSERT INTO marc_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","त्या रात्री परमेश्वराने इस्राएलला स्वप्नात दर्शन दिले व त्याला म्हटले, “याकोबा! याकोबा!” याकोब म्हणाला, “काय आज्ञा?” ");
INSERT INTO marc_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","परमेश्वराने म्हटले, “मी परमेश्वर, मी तुझ्या पित्याचा परमेश्वर आहे; खाली इजिप्त देशात जाण्यास भिऊ नको, कारण तिथे मी तुझे एक मोठे राष्ट्र करेन. ");
INSERT INTO marc_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मी स्वतः तुझ्याबरोबर खाली इजिप्तला जाईन, आणि तुला तिथून निश्चितच परत आणेन. योसेफाचे हात तुझे डोळे बंद करतील.” ");
INSERT INTO marc_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","तेव्हा याकोब बेअर-शेबाहून निघाला; त्याला नेण्यासाठी फारोहने पाठविलेल्या गाड्यांमधून इस्राएलाच्या पुत्रांनी, त्याला व आपल्या पत्नींना आणि मुलांबाळांना इजिप्तमध्ये आणले. ");
INSERT INTO marc_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","मग याकोब त्याची सर्व संतती आणि आपली गुरे व कनान देशामध्ये मिळविलेली संपत्ती घेऊन इजिप्तला गेला. ");
INSERT INTO marc_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","याप्रमाणे याकोबाने त्याचे पुत्र, नातवंडे आणि त्याच्या मुली आणि नातवंडांना—त्याची सर्व संतती इजिप्तमध्ये आणली. ");
INSERT INTO marc_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","इजिप्तला गेलेल्या इस्राएलाच्या पुत्रांची (याकोब आणि त्याचे वंशज) ही नावे आहेत: रऊबेन हा याकोबाचा प्रथम जन्मलेला. ");
INSERT INTO marc_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रऊबेनाचे पुत्र: हनोख, पल्लू, हेस्रोन व कर्मी. ");
INSERT INTO marc_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमओनाचे पुत्र: यमुवेल, यामीन, ओहाद, याखीन, जोहर आणि कनानी स्त्रीपासून झालेला मुलगा शौल. ");
INSERT INTO marc_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवीचे पुत्र: गेर्षोन, कोहाथ व मरारी. ");
INSERT INTO marc_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाहचे पुत्र: एर, ओनान, शेलाह, पेरेस व जेरह (परंतु एर आणि ओनान हे कनान देशातच मरण पावले होते). परेसाचे पुत्र: हेस्रोन आणि हामूल. ");
INSERT INTO marc_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साखारचे पुत्र: तोला, पुवाह, योब व शिम्रोन. ");
INSERT INTO marc_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबुलूनाचे पुत्र: सेरेद, एलोन व याहलेल हे होते. ");
INSERT INTO marc_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","म्हणजे याकोब आणि लेआ यांची सर्व संतती मिळून तेहतीस होती. यातच त्यांना पद्दन-अराम येथे झालेली कन्या दीना हिचाही समावेश आहे. ");
INSERT INTO marc_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गादाचे पुत्र: सिफयोन, हग्गी, शूनी, एसबोन, एरी, अरोदी व अरेली. ");
INSERT INTO marc_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेराचे पुत्र: इम्नाह, इश्वा, इश्वी व बरीयाह; त्यांची बहीण सेराह. बरीयाहचे पुत्र: हेबेर व मालकीएल. ");
INSERT INTO marc_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","हे सोळाजण लाबानाने लेआला दासी म्हणून दिलेल्या जिल्पेपासून याकोबाला झाले. ");
INSERT INTO marc_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकोबाची पत्नी राहेल हिचे पुत्र: योसेफ व बिन्यामीन. ");
INSERT INTO marc_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","योसेफाचे पुत्र मनश्शेह व एफ्राईम हे इजिप्तमध्ये ओन नगरचा याजक पोटीफेरा याची कन्या आसनथपासून जन्मले. ");
INSERT INTO marc_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बिन्यामीनचे पुत्र: बेला, बेकेर, आशबेल, गेरा, नामान, एही, रोष, मुप्पीम, हुप्पीम व आर्द हे होते. ");
INSERT INTO marc_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","हे चौदाजण म्हणजे याकोब व राहेल यांची संतती होती. ");
INSERT INTO marc_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दानचा पुत्र: हुशीम. ");
INSERT INTO marc_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नफतालीचे पुत्र: याहसेल, गूनी, येसेर आणि शिल्लेम. ");
INSERT INTO marc_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","लाबानाने आपली कन्या राहेल हिला दासी म्हणून दिलेली स्त्री बिल्हा हिच्यापासून याकोबाला सात पुत्र झाले. ");
INSERT INTO marc_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याप्रमाणे याकोबाच्या पुत्राच्या स्त्रियांच्या व्यतिरिक्त इजिप्तमध्ये गेलेल्या त्याच्या संतानात एकूण सहासष्ट व्यक्ती होत्या. ");
INSERT INTO marc_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","योसेफाला इजिप्तमध्ये झालेल्या दोन पुत्रांचा यामध्ये समावेश केला तर इजिप्तमध्ये आलेल्या याकोबाच्या कुटुंबाचे एकूण सत्तरजण होते. ");
INSERT INTO marc_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","याकोबाने गोशेनला जाण्याचा मार्ग विचारण्याकरिता यहूदाहला त्यांच्या पुढे योसेफाकडे पाठविले. मग जेव्हा ते गोशेन प्रांतात पोहोचले, ");
INSERT INTO marc_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","योसेफाने आपला रथ तयार केला आणि आपला पिता इस्राएल यांना भेटण्याकरिता गोशेन प्रांतात गेला. भेट होताच त्यांनी एकमेकांना मिठी मारली आणि ते बराच वेळ रडले. ");
INSERT INTO marc_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","मग इस्राएल योसेफाला म्हणाला, “आता मला खुशाल मरण येवो, कारण तू जिवंत आहेस हे मी स्वतः पाहिले आहे.” ");
INSERT INTO marc_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","योसेफ आपल्या भावांना आणि पित्याच्या कुटुंबातील सर्वांना म्हणाला, “मी वर जाऊन फारोहला सांगेन की, ‘माझे भाऊ व माझ्या पित्याचे संपूर्ण कुटुंब कनान देशातून मजकडे आले आहेत. ");
INSERT INTO marc_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","मी त्याला सांगेन, हे मेंढपाळ आहेत; त्यांनी त्यांच्याबरोबर आपली शेरडेमेंढरे, गुरे व त्यांचे सर्वस्व आणले आहे.’ ");
INSERT INTO marc_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","म्हणून फारोह जेव्हा तुम्हाला बोलावून विचारेल, ‘तुमचा व्यवसाय काय आहे?’ ");
INSERT INTO marc_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तेव्हा तुम्ही असे उत्तर द्यावे, ‘आमच्या वडीलांप्रमाणे तुझ्या सेवकांनी लहानपणापासून गुरे पाळली आहेत.’ म्हणजे तो तुम्हाला येथेच गोशेन प्रांतात राहू देईल, कारण इजिप्तमध्ये मेंढपाळांना तुच्छ मानले जाते.” ");
INSERT INTO marc_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","योसेफाने जाऊन फारोहला सांगितले, “माझे वडील आणि माझे भाऊ कनान देशातून आपली सर्व गुरे, शेरडेमेंढरे आणि सर्व संपत्ती घेऊन इकडे आले आहेत आणि आता ते गोशेन प्रांतात आहेत.” ");
INSERT INTO marc_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","त्याने आपल्या भावांपैकी पाच जणांना निवडले आणि फारोहपुढे उपस्थित केले. ");
INSERT INTO marc_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फारोहने त्यांना विचारले, “तुमचा व्यवसाय कोणता आहे?” त्यांनी फारोहला उत्तर दिले, “तुमचे सेवक आमच्या पूर्वजांप्रमाणेच मेंढपाळ आहोत.” ");
INSERT INTO marc_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ते फारोहला आणखी म्हणाले, “आम्ही इथे काही काळ राहण्यास आलो आहोत, कारण कनान देशात अतितीव्र दुष्काळ पडला आहे आणि तुमच्या सेवकांच्या गुरांसाठी तिथे चारा नाही. तुम्ही आम्हाला गोशेन प्रांतात राहू द्यावे अशी विनंती आम्ही करीत आहोत.” ");
INSERT INTO marc_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","फारोह योसेफाला म्हणाला, “तुझे वडील व भाऊ तुझ्याकडे आले आहेत, ");
INSERT INTO marc_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","आणि संपूर्ण इजिप्त देश तुझ्यासमोर आहे; या देशातील उत्तम भागात तुझ्या पित्याला आणि भावांना राहण्यास दे. त्यांना गोशेन येथे राहू दे. आणि त्यांच्यापैकी कोणी विशेष क्षमता असणारे असतील तर त्यांच्यावर माझ्याही गुरांची जबाबदारी सोपवून दे.” ");
INSERT INTO marc_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","मग योसेफाने आपला पिता याकोब याला फारोहकडे उपस्थित केले आणि याकोबाने फारोहला आशीर्वाद दिला. ");
INSERT INTO marc_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","फारोहने त्याला विचारले, “तुमचे किती वय आहे?” ");
INSERT INTO marc_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","आणि याकोबाने फारोहला उत्तर दिले, “माझी जीवनयात्रा एकशे तीस वर्षाची आहे. माझी ही वर्षे अत्यंत कष्टाची आणि दुःखाची अशी होती; तरीपण माझ्या पूर्वजांइतके माझे वय अजून झालेले नाही.” ");
INSERT INTO marc_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","नंतर याकोबाने फारोहला आशीर्वाद दिला आणि त्याच्या उपस्थितीतून निघाला. ");
INSERT INTO marc_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","याप्रमाणे योसेफाने आपले वडील आणि भाऊ यांना फारोहच्या आज्ञेप्रमाणे इजिप्तमधील रामसेस नगरामधील सर्वोत्तम जागा वतन म्हणून दिली. ");
INSERT INTO marc_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","योसेफाने आपला पिता, आपले भाऊ आणि आपल्या पित्याच्या कुटुंबातील प्रत्येकाला त्यांच्या मुलाबाळांच्या संख्येनुसार अन्नधान्य पुरविले. ");
INSERT INTO marc_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","मात्र, दुष्काळ उग्र असल्याने संपूर्ण प्रदेशात अन्न नव्हते; दुष्काळामुळे इजिप्त आणि कनान दोन्ही देश कष्टमय झाले. ");
INSERT INTO marc_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","योसेफाने धान्य विकून इजिप्त आणि कनानमधील सर्व पैसा गोळा केला आणि त्याने तो पैसा फारोहच्या महालात आणला. ");
INSERT INTO marc_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","जेव्हा इजिप्त आणि कनानी लोकांजवळचा सर्व पैसा संपला तेव्हा इजिप्तमधील लोक योसेफाकडे आले आणि म्हणाले, “आमचा सर्व पैसा संपला आहे तरी आम्हाला अन्न द्या. आम्ही तुमच्या नजरेसमोर अन्नावाचून मरावे का?” ");
INSERT INTO marc_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","यावर योसेफाने उत्तर दिले, “तुमचे पैसे संपले आहेत, तर मग तुमची गुरे मला द्या आणि त्यांच्या मोबदल्यात मी तुम्हाला अन्नधान्य देतो.” ");
INSERT INTO marc_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","त्याप्रमाणे अन्नधान्यासाठी लोकांनी आपले सर्व घोडे, गुरे, शेरडेमेंढरे आणि गाढवे योसेफाकडे आणली आणि त्याने त्याच्या मोबदल्यात त्यांना वर्षभर पुरेल इतके धान्य दिले. ");
INSERT INTO marc_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ते वर्ष संपल्यावर, पुढच्या वर्षी ते त्याच्याकडे आले आणि म्हणाले, “आम्ही धन्यापासून हे सत्य लपवू शकत नाही की आमचा पैसा संपला आणि आमची गुरे तुमची झाली आहेत आणि आता आमच्याजवळ आमच्या धन्यासाठी फक्त आमची शरीरे व आमच्या जमिनी राहिल्या आहेत. ");
INSERT INTO marc_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","आम्ही तुमच्या नजरेसमोर अन्नावाचून मरावे का? आता आम्हाला आमच्या जमिनीसह विकत घ्या म्हणजे आम्ही फारोहचे गुलाम होऊ. अन्नासाठी आम्ही स्वतःचा विक्रय केला तरच आम्ही जगू आणि जमिनीही मोकळ्या राहणार नाहीत.” ");
INSERT INTO marc_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","याप्रमाणे योसेफाने इजिप्त देशातील सर्व जमीन फारोहसाठी विकत घेतली. दुष्काळ महाभयंकर असल्यामुळे सर्व इजिप्त देशातील लोकांनी त्याला आपआपली शेते विकली आणि इजिप्त देशातील सर्व जमीन फारोहची झाली, ");
INSERT INTO marc_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","तसेच योसेफाने इजिप्त देशातील एका टोकापासून दुसर्‍या टोकापर्यंतच्या शहरातील सर्व लोकांना गुलाम बनविले. ");
INSERT INTO marc_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","याजकांच्या जमिनी मात्र योसेफाने विकत घेतल्या नाहीत, कारण फारोहकडून त्यांना निर्धारित अन्नधान्य पुरविले जात असे आणि त्यामुळे त्यांनी जमिनी विकल्या नाही. ");
INSERT INTO marc_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","मग योसेफ लोकांना म्हणाला, “पाहा, मी फारोहसाठी तुम्हाला तुमच्या जमिनींसह विकत घेतले आहे. आता हे बियाणे घ्या आणि जमिनीत पेरा. ");
INSERT INTO marc_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ज्यावेळी तुम्ही कापणी कराल. त्यावेळी तुमच्या उत्पन्नाचा पाचवा हिस्सा फारोहला द्यावा. राहिलेले चार हिस्से पुढील वर्षाच्या बियाण्यांसाठी आणि तुम्हासाठी, तुमचे कुटुंब व मुलाबाळांच्या खाण्यासाठी ठेवा.” ");
INSERT INTO marc_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","लोक म्हणाले, “तुम्ही आमचे प्राण वाचविले आहेत, आमच्या धन्याच्या दृष्टीत आम्हाला दया प्राप्त होवो; आम्ही फारोहच्या गुलामगिरीत राहू.” ");
INSERT INTO marc_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","म्हणून योसेफाने याजकांच्या मालकीच्या जमिनी शिवाय इतर सर्व जमिनीतील पिकांचा पाचवा हिस्सा फारोहला देण्यात यावा, असा इजिप्त देशभर कायदा केला. हा कायदा आजवर चालू आहे. ");
INSERT INTO marc_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","अशा रीतीने इस्राएली इजिप्तच्या गोशेन प्रांतात राहू लागले, आणि त्यांनी तिथे जमीनजुमला संपादन केला व ते फलद्रूप होऊन संख्येने खूप वाढले. ");
INSERT INTO marc_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","इजिप्त देशात याकोब सतरा वर्षे जगला आणि त्याच्या जीवनाची वर्षे एकशे सत्तेचाळीस होती. ");
INSERT INTO marc_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","इस्राएलाची मृत्युघटका भरत आली त्यावेळी त्याने आपला पुत्र योसेफ याला बोलाविले आणि म्हटले, “जर तुझी माझ्यावर कृपादृष्टी असेल तर माझ्या मांडीखाली हात ठेऊन अशी शपथ घे की तू मला करुणेने व विश्वासाने वागवशील. इजिप्त देशात मला मूठमाती देऊ नकोस, ");
INSERT INTO marc_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","परंतु जेव्हा मी माझ्या पूर्वजांसोबत झोपी जाईन, मला इजिप्तमधून बाहेर ने आणि त्यांना जिथे पुरले आहे, तिथे मला मूठमाती दे.” त्याने म्हटले, “तुम्ही जसे सांगितले आहे तसेच मी करेन.” ");
INSERT INTO marc_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","“मला शपथ दे.” त्याने म्हटले, मग योसेफाने त्याला शपथ दिली आणि मग इस्राएलने आपल्या काठीच्या टोकावर टेकून उपासना केली. ");
INSERT INTO marc_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","काही दिवसानंतर योसेफाला कळविण्यात आले, “तुझे वडील आजारी आहेत.” तेव्हा तो मनश्शेह व एफ्राईम या आपल्या दोन पुत्रांना आपल्यासोबत घेऊन निघाला. ");
INSERT INTO marc_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","जेव्हा याकोबाला सांगण्यात आले, “तुझा पुत्र योसेफ तुझ्याकडे आला आहे,” तेव्हा इस्राएल आपली सर्व शक्ती एकवटून उठून बिछान्यावर बसला. ");
INSERT INTO marc_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","याकोब हा योसेफाला म्हणाला, “सर्वसमर्थ परमेश्वराने मला कनान देशात लूज येथे दर्शन देऊन आशीर्वाद दिला ");
INSERT INTO marc_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","आणि मला म्हणाले, ‘मी तुला फलद्रूप करेन आणि तुझी संख्या वाढवेन. मी तुला लोकांचा समुदाय करेन आणि तुझ्यानंतर हा देश तुझ्या वंशजांना कायमचे वतन म्हणून देईन.’ ");
INSERT INTO marc_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“आता मी इजिप्तमध्ये तुझ्याकडे येण्यापूर्वी तुला इजिप्तमध्ये झालेले दोन पुत्र माझेच गणले जातील; जसे रऊबेन व शिमओन तसेच एफ्राईम व मनश्शेह हेदेखील माझेच आहे. ");
INSERT INTO marc_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","परंतु यानंतर तुला जी मुलेबाळे होतील ती तुझी होतील. त्यांचे वतन त्यांच्या भावांच्या नावाने चालेल. ");
INSERT INTO marc_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","मी पद्दन-अराम येथून परत येत होतो आणि कनान देशात एफ्राथपासून थोड्याच अंतरावर होतो, तेव्हा राहेलच्या मृत्यूचे दुःख माझ्यावर पडले आणि मी तिला एफ्राथ गावाच्या थोड्या अंतरावर पुरले” (म्हणजे बेथलेहेम). ");
INSERT INTO marc_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","जेव्हा इस्राएलने योसेफाच्या पुत्रांना पाहिले, त्याने विचारले, “ही कोण आहेत?” ");
INSERT INTO marc_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","योसेफाने त्याच्या पित्याला म्हटले, “परमेश्वराने मला इथे दिलेले हे माझे पुत्र आहेत.” इस्राएल त्याला म्हणाला, “त्यांना माझ्याजवळ आण आणि म्हणजे मी त्यांना आशीर्वाद देईन.” ");
INSERT INTO marc_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएलाची दृष्टी म्हातारपणामुळे अशक्त झाली होती, त्यामुळे तो नीट पाहू शकत नव्हता, म्हणून योसेफाने त्यांना त्याच्याजवळ आणले आणि त्याच्या पित्याने त्यांचे चुंबन घेतले व त्यांना कवटाळले. ");
INSERT INTO marc_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","इस्राएल योसेफाला म्हणाला, “मी तुला परत पाहीन असे मला कधीच वाटले नव्हते, पण परमेश्वराने मला तुझे पुत्रही पाहू दिलेत.” ");
INSERT INTO marc_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","नंतर योसेफाने त्यांना इस्राएलाच्या मांडीवरून बाजूला केले आणि जमिनीपर्यंत लवून मुजरा केला. ");
INSERT INTO marc_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","मग योसेफाने दोघांना घेतले आणि एफ्राईमला योसेफाच्या उजव्या व इस्राएलाच्या डाव्या हातास आणि मनश्शेहला योसेफाच्या डाव्या आणि इस्राएलाच्या उजव्या हातास असे त्याच्याजवळ नेले. ");
INSERT INTO marc_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","परंतु इस्राएलने त्याचा उजवा हात पुढे केला आणि तो एफ्राईमच्या डोक्यावर ठेवला, जरी तो धाकटा होता आणि हात ओलांडून त्याने आपला डावा हात मनश्शेहच्या डोक्यावर ठेवला, जरी मनश्शेह प्रथम जन्मलेला होता. ");
INSERT INTO marc_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","नंतर त्याने योसेफाला आशीर्वाद देऊन म्हटले, “ज्या परमेश्वरापुढे माझे पूर्वज अब्राहाम आणि इसहाक विश्वासाने चालले, तेच परमेश्वर आजपर्यंत माझ्या जीवनाचे मेंढपाळ राहिले आहे, ");
INSERT INTO marc_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ज्या परमेश्वराच्या दूताने मला सर्व घातपातापासून सुरक्षित ठेवले, ते या मुलांना आशीर्वादित करोत. माझे आणि माझे पूर्वज अब्राहाम आणि इसहाक यांचे नाव या मुलांच्या द्वारे पुढे चालू राहो, त्यांना पुष्कळ मुलेबाळे व गोत्र लाभोत.” ");
INSERT INTO marc_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","त्याच्या पित्याने आपला उजवा हात एफ्राईमाच्या डोक्यावर ठेवलेला पाहून योसेफ नाराज झाला आणि त्याने एफ्राईमच्या डोक्यावरील हात मनश्शेहच्या डोक्यावर ठेवावा म्हणून त्याने त्याच्या पित्याचा हात उचलला. ");
INSERT INTO marc_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","योसेफ त्याला म्हणाला, “नाही बाबा, हा प्रथम जन्मलेला आहे; तुमचा उजवा हात त्याच्या डोक्यावर ठेवा.” ");
INSERT INTO marc_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","परंतु त्याच्या वडिलांनी ते नाकारले आणि ते म्हणाले, “मला माहीत आहे, माझ्या मुला, मला माहीत आहे. त्याचीही कुळे होतील आणि तो देखील महान होईल, परंतु त्याचा धाकटा भाऊ त्याच्याहीपेक्षा थोर होईल आणि त्याचे लोक राष्ट्रांचे समुदाय बनतील.” ");
INSERT INTO marc_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","त्याने त्या दिवशी त्यांना आशीर्वाद दिला आणि म्हणाला, “इस्राएली लोक एकमेकांना आशीर्वाद देताना तुझे नाव घेऊन म्हणोत: ‘एफ्राईम व मनश्शेह यांच्याप्रमाणे परमेश्वर तुझे कल्याण करो.’ ” अशाप्रकारे याकोबाने एफ्राईमाला मनश्शेहपेक्षा श्रेष्ठ ठरविले. ");
INSERT INTO marc_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","नंतर इस्राएल योसेफाला म्हणाला, “आता लवकरच माझा अंत होईल; परंतु परमेश्वर तुझ्याबरोबर राहतील आणि तुला तुझ्या वाडवडीलांच्या देशामध्ये परत नेतील. ");
INSERT INTO marc_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","आणि मी तुझ्या भावांपेक्षा तुला जमिनीचा एक भाग अधिक देतो, तो मी, माझी तलवार आणि माझे धनुष्य यांच्या बळावर, अमोरी लोकांपासून जिंकून घेतला होता.” ");
INSERT INTO marc_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","नंतर याकोबाने आपल्या सर्व मुलांना बोलावून म्हटले: “असे माझ्याभोवती गोळा व्हा, म्हणजे पुढे भविष्यकाळात तुमचे काय होणार आहे ते मी तुम्हाला सांगेन. ");
INSERT INTO marc_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“एकत्र व्हा आणि माझे ऐका, अहो याकोबाच्या पुत्रांनो; तुमचा पिता इस्राएल याचे ऐका. ");
INSERT INTO marc_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“रऊबेना, तू माझा प्रथमपुत्र आहेस, माझे बळ, पौरुषाचे प्रथमफळ असा आहेस. प्रतिष्ठा आणि शक्तीत उत्कृष्ट असा तू आहेस. ");
INSERT INTO marc_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","तू अशांत पाण्यासारखा उग्र आहे, तू अजून उत्कृष्ट होणार नाही, कारण तू तुझ्या वडिलांच्या खाटेवर, माझ्या खाटेवर चढला आणि ते अशुद्ध केले. ");
INSERT INTO marc_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“शिमओन व लेवी हे दोघे भाऊ आहेत, त्यांची तलवार ही अत्याचाराचे साधन आहे. ");
INSERT INTO marc_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","मी त्यांच्या सभेमध्ये जाऊ नये, त्यांच्या मंडळीमध्ये मी सामील होऊ नये, कारण रागाच्या भरात त्यांनी माणसांचा वध केला, आणि वाटेल तसे बैलांची धोंडशीर तोडली. ");
INSERT INTO marc_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","त्यांचा क्रोध शापित असो, आणि त्यांचा संताप, किती क्रूर आहे! मी त्यांची याकोबामध्ये पांगापांग करेन, आणि त्यांना इस्राएलभर पांगवून टाकेन. ");
INSERT INTO marc_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“हे यहूदाह, तुझे भाऊ तुझी प्रशंसा करतील; तुझा हात तुझ्या शत्रूंच्या मानेवर राहील; तुझ्या पित्याचे पुत्र तुला नमन करतील. ");
INSERT INTO marc_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदाह, तू सिंहाचा छावा आहेस. माझ्या मुला, तू तुझ्या शिकारीहून परत येतो. सिंहासारखा दबा धरून बसतो व विसावा घेतो, सिंहिणीप्रमाणे आहेस—त्याला कोण छेडणार? ");
INSERT INTO marc_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदाहपासून राजदंड कधीही वेगळा होणार नाही, किंवा अधिकाराची काठी त्याच्या पायामधून निघून जाणार नाही, ज्याचे जे आहे तो येईपर्यंत, राष्ट्रे त्याची आज्ञा पाळतील. ");
INSERT INTO marc_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","तो आपले गाढव द्राक्षवेलीला, गाढवीचे शिंगरू उत्कृष्ट द्राक्षवेलीला बांधून ठेवणार आहे; आपला झगा द्राक्षारसात, आपली वस्त्रे द्राक्षाच्या रक्तात धुणार आहे. ");
INSERT INTO marc_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","त्याचे नेत्र द्राक्षारसापेक्षा गर्द होतील, त्याचे दात दुधापेक्षाही पांढरे होतील. ");
INSERT INTO marc_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“जबुलून समुद्रकिनारी राहील आणि तो जहाजांचे बंदर होईल. त्याची सीमा सीदोनपर्यंत पसरेल. ");
INSERT INTO marc_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साखार बळकट गाढव आहे. तो मेंढवाड्यांमध्ये दबून बसला आहे. ");
INSERT INTO marc_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","त्याची विश्रांतीची जागा किती रम्य आहे आणि तिकडचा प्रदेश किती आल्हाददायक आहे, हे पाहून तो आपल्या खांद्याला भार वाहण्यासाठी वाकवेल आणि मजुरीचा दास होऊन जाईल. ");
INSERT INTO marc_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“दान आपल्या लोकांना न्यायदान करेल, इस्राएलाच्या एका गोत्राप्रमाणे तो हे करेल. ");
INSERT INTO marc_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान हा रस्त्याच्या कडावरील सर्प बनेल, तो वाटेवरील विषारी सर्प बनेल, जो घोड्याच्या टापांचा चावा घेईल व घोडेस्वार खाली कोसळेल. ");
INSERT INTO marc_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“हे याहवेह, मी तुमच्या तारणाची वाट पाहत आहे. ");
INSERT INTO marc_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“एक लुटारूची टोळी गादवर हल्ला करेल, पण गाद त्यांच्या टाचेवर तडाखा देईल. ");
INSERT INTO marc_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“आशेरला पौष्टिक अन्न मिळेल; आणि तो राजास योग्य अशी मिष्टान्ने पुरवेल. ");
INSERT INTO marc_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“नफताली स्वैर हरिणीप्रमाणे आहे, त्याला सुंदर पाडसे होतील. ");
INSERT INTO marc_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“योसेफ हा फलवंत वेल आहे, पाण्याच्या झर्‍याजवळ लावलेली फलवंत वेल आहे, तिच्या फांद्या भिंतीवर पसरल्या आहेत. ");
INSERT INTO marc_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","कटुतेने तिरंदाजांनी त्याच्यावर हल्ला केला; त्यांनी त्याच्यावर वैराने बाण सोडले. ");
INSERT INTO marc_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","परंतु त्याचे धनुष्य स्थिर राहिले, त्याचे बाहू मजबूत राहिले, याचे कारण याकोबाचे सर्वसमर्थ परमेश्वर, ते मेंढपाळ आणि इस्राएलचे खडक आहेत. ");
INSERT INTO marc_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","कारण तुझ्या पित्याचे परमेश्वर, तुझे सहायक आहेत, कारण सर्वसमर्थ, जे तुला आशीर्वादित करतात, वरून स्वर्गातील आशीर्वाद, खोलातील डोहातून निघणार्‍या झर्‍यातील आशीर्वाद, स्तने आणि गर्भांच्या आशीर्वादांचा वर्षाव करो. ");
INSERT INTO marc_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तुझ्या पित्याचे आशीर्वाद पूर्वजांच्या पर्वतापेक्षा श्रेष्ठ आशीर्वाद आहेत, ते सर्वकालीन पर्वतांच्या संपन्नतेपेक्षा श्रेष्ठ आहेत. हे आशीर्वाद योसेफाच्या मस्तकी, जो आपल्या भावामधील राजपुत्र आहे, त्याच्या मस्तकी येवोत. ");
INSERT INTO marc_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“बिन्यामीन, हा भुकेला लांडगा आहे; तो सकाळच्या प्रहरी शिकार करतो, आणि संध्याकाळी लूट वाटतो.” ");
INSERT INTO marc_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","हे सर्व इस्राएलचे बारा गोत्र आहेत आणि मुलांना आशीर्वाद देण्याकरिता त्यांचा पिता असा बोलला, प्रत्येकाला त्याने यथायोग्य आशीर्वाद दिला. ");
INSERT INTO marc_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","नंतर त्याने आपल्या पुत्रांस या सूचना दिल्या: “आता लवकरच माझा अंत होईल, तेव्हा एफ्रोन हेथीपासून विकत घेतलेल्या गुहेमध्ये माझ्या वाडवडिलांच्या सोबत मला मूठमाती द्या. ");
INSERT INTO marc_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","कनान देशात अब्राहामाने एफ्रोन हेथीपासून विकत घेतलेली स्मशानभूमी मम्रेसमोरील मकपेला नावाच्या शेतातील गुहेमध्ये आहे. ");
INSERT INTO marc_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","तिथेच त्यांनी अब्राहाम आणि त्याची पत्नी साराहला मूठमाती दिली; तिथेच त्यांनी इसहाक आणि त्याची पत्नी रिबेकाहला मूठमाती दिली आणि तिथेच मी लेआला मूठमाती दिली. ");
INSERT INTO marc_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ते शेत आणि ती गुहा हेथीच्या लोकांपासून विकत घेतली होती.” ");
INSERT INTO marc_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","आपल्या पुत्रांसंबंधीची भविष्यवाणी संपविल्यावर याकोबाने आपले पाय बिछान्यावर उचलून घेतले व त्याने अखेरचा श्वास घेऊन प्राण सोडला आणि तो त्याच्या पूर्वजास जाऊन मिळाला. ");
INSERT INTO marc_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","योसेफ आपल्या पित्याल्या आलिंगन देऊन खूप रडला आणि त्याने त्याचे चुंबन घेतले. ");
INSERT INTO marc_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","नंतर योसेफाने वैद्यास त्याचा पिता इस्राएल याच्या मृतदेहात मसाला भरण्याची आज्ञा दिली. मग वैद्यांनी मृतदेहात सुगंधी द्रव्याचा मसाला भरला. ");
INSERT INTO marc_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","मसाला भरण्याच्या क्रियेला चाळीस दिवस लागले, मृतदेहात मसाला भरण्यास इतके दिवस लागत असत. इजिप्तच्या लोकांनी त्याच्यासाठी सत्तर दिवस शोक केला. ");
INSERT INTO marc_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","शोक करण्याचे दिवस संपल्यानंतर योसेफ फारोहच्या राजदरबारी गेला आणि म्हणाला, “जर माझ्यावर तुमची कृपादृष्टी असेल तर तुम्ही माझ्यावतीने फारोहशी बोलावे” अशी त्याने त्यांना विनंती केली. ");
INSERT INTO marc_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“माझ्या वडिलांनी मला शपथ घ्यायला लावली आणि म्हणाले, मी मरणार आहे; कनान देशात मी स्वतःसाठी खोदलेल्या थडग्यात मला मूठमाती दे. आता मला वर जाऊन माझ्या वडिलांना मूठमाती देऊ दे. मग मी परत येईन.” ");
INSERT INTO marc_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फारोहने म्हटले, “तू वर जा आणि शपथ दिल्याप्रमाणे आपल्या वडिलांना मूठमाती दे.” ");
INSERT INTO marc_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","मग योसेफ आपल्या पित्याला पुरण्यास निघाला. फारोहचे सर्व अधिकारी त्याच्याबरोबर होते—त्याचे मान्यवर आणि इजिप्तचे सर्व प्रतिष्ठित— ");
INSERT INTO marc_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","तसेच योसेफाचे पूर्ण कुटुंब म्हणजे त्याचे भाऊ आणि त्यांचे कुटुंब, या सर्वांसह गेला. परंतु त्यांनी त्यांची मुलेबाळे, गुरे, शेरडेमेंढरे गोशेन प्रांतातच मागे ठेवली. ");
INSERT INTO marc_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","अशाप्रकारे योसेफाबरोबर रथ, घोडेस्वार गेले. तो मोठा समुदाय होता. ");
INSERT INTO marc_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","जेव्हा ते यार्देन नदीच्या पश्चिम तीरावर यरीहोजवळ अटाद या ठिकाणी आले; तेव्हा त्यांनी तिथे फार आकांत करून मोठा विलाप केला; योसेफाच्या वडिलांसाठी त्यांनी सात दिवस तिथे शोक केला. ");
INSERT INTO marc_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","जेव्हा तिथे राहणाऱ्या कनानी लोकांनी अटादच्या खळ्यावर शोक करताना पाहिले, यार्देनजवळच्या त्या जागेला आबेल-मिस्राईम असे नाव ठेवले. कारण ते म्हणाले, “इजिप्तच्या लोकांची ही मोठा शोक करण्याची जागा आहे.” ");
INSERT INTO marc_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","इस्राएलने आज्ञा केल्याप्रमाणे त्याच्या पुत्रांनी सर्वकाही केले: ");
INSERT INTO marc_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","त्याचा मृतदेह कनान देशामध्ये आणला आणि अब्राहामाने एफ्रोन हिथी याच्यापासून मम्रेजवळील मकपेला नावाच्या शेतातील गुहेत त्यांनी त्याला मूठमाती दिली. ");
INSERT INTO marc_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","आपल्या वडिलांना मूठमाती दिल्यानंतर, योसेफ आपले भाऊ आणि आपल्या वडिलांच्या मूठमातीसाठी त्याच्याबरोबर गेलेले लोक यासह इजिप्त देशास परत आला. ");
INSERT INTO marc_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","जेव्हा योसेफाच्या भावांनी पाहिले की त्यांचे वडील मरण पावले, ते म्हणाले, “आपण योसेफाला जी वाईट वागणूक दिली होती, त्याची जर त्याने वाईटाने आपल्याला परतफेड केली तर?” ");
INSERT INTO marc_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","म्हणून त्यांनी योसेफाला निरोप पाठविला, “मरण्यापूर्वी तुझ्या वडिलांनी अशी सूचना दिली होती: ");
INSERT INTO marc_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘तुम्हाला हे योसेफाला बोलायचे आहे: आम्ही तुझ्याशी जे अतिदुष्टाईचे वर्तन केले त्याबद्दल आम्ही तुझी क्षमा मागावी.’ त्याप्रमाणे आम्ही तुझ्या पित्याच्या परमेश्वराचे सेवक तुझी क्षमा मागत आहोत.” जेव्हा हा संदेश योसेफाकडे आला, तेव्हा योसेफ रडला. ");
INSERT INTO marc_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","नंतर त्याचे भाऊ त्याच्याकडे आले आणि त्याच्यापुढे पालथे पडून त्याला म्हणाले, “आम्ही तुझे गुलाम आहोत.” ");
INSERT INTO marc_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","पण योसेफ त्यांना म्हणाला, “भीती बाळगू नका. मी काय परमेश्वराच्या ठिकाणी आहे? ");
INSERT INTO marc_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","तुम्ही जे वाईट योजिले होते, त्यातून परमेश्वराने चांगलेच निर्माण केले; कारण आज मला त्याने या पदावर यासाठी आणले की, मला पुष्कळ लोकांचे प्राण वाचविता यावेत. ");
INSERT INTO marc_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","म्हणून तुम्ही घाबरू नका; मी स्वतः तुमचा आणि तुमच्या मुलाबाळांचा पुरवठा करेन.” अशाप्रकारे त्यांच्याशी अतिशय ममतेने बोलून त्याने त्यांचे समाधान केले. ");
INSERT INTO marc_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","योसेफ, इजिप्त देशात आपल्या पित्याच्या संपूर्ण कुटुंबासोबत राहिला. तो एकशे दहा वर्ष जगला ");
INSERT INTO marc_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","आणि योसेफाने त्याचा पुत्र एफ्राईमच्या मुलांची तिसरी पिढी पाहिली. तसेच मनश्शेहचा पुत्र माखीरला जन्मतः त्याच्या मांडीवर ठेवण्यात आले. ");
INSERT INTO marc_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","नंतर योसेफ आपल्या भावांस म्हणाला, “लवकरच माझा अंत होईल, पण खात्रीने परमेश्वर तुमची भेट घेतील आणि तुम्हाला इजिप्त देशाबाहेर अब्राहाम, इसहाक आणि याकोब यांना वचन दिलेल्या देशात घेऊन जातील,” ");
INSERT INTO marc_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","नंतर योसेफाने इस्राएली लोकांना शपथ देऊन म्हटले, “परमेश्वर तुमच्या मदतीला येतील आणि मग तुम्ही निश्चितच माझ्या अस्थी या जागेवरून घेऊन जाल.” ");
INSERT INTO marc_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","अशा रीतीने योसेफ एकशे दहा वर्षांचा होऊन मृत्यू पावला. मग त्याच्या प्रेतात मसाला भरण्यात आला आणि ते एका शवपेटीत घालून इजिप्तमध्ये ठेवण्यात आले.");
INSERT INTO marc_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","याकोबाबरोबर इजिप्तला गेलेल्या इस्राएलचे पुत्र, जे आपल्या कुटुंबासह गेले, त्यांची नावे ही आहेत: ");
INSERT INTO marc_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रऊबेन, शिमओन, लेवी आणि यहूदाह; ");
INSERT INTO marc_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साखार, जबुलून आणि बिन्यामीन; ");
INSERT INTO marc_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान आणि नफताली; गाद व आशेर. ");
INSERT INTO marc_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकोबाचे एकूण सत्तर वंशज होते; योसेफ तर आधीच इजिप्तमध्ये गेला होता. ");
INSERT INTO marc_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","आता योसेफ आणि त्याचे सर्व भाऊ व ती सर्व पिढी मरण पावली. ");
INSERT INTO marc_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","परंतु इस्राएली लोक अत्यंत फलद्रूप झाले; ते बहुगुणित होऊन त्यांना पुष्कळ संतती झाली आणि त्यांची संख्या वाढून, लवकरच ते इतके असंख्य झाले की संपूर्ण देश त्यांनी व्यापून टाकला. ");
INSERT INTO marc_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","नंतर एक नवीन राजा इजिप्तच्या गादीवर आला, त्याच्या दृष्टीने योसेफ कोणीही नव्हता. ");
INSERT INTO marc_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","त्याने आपल्या लोकांना सांगितले, “पाहा, इस्राएली लोक संख्येने आपल्यापेक्षा जास्त आहेत. ");
INSERT INTO marc_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","चला त्यांच्याशी चातुर्याने वागू या, नाहीतर त्यांची संख्या अजून वाढेल, आणि लढाई झाली तर ते आपल्या शत्रूंशी एक होतील आणि देश सोडून जातील.” ");
INSERT INTO marc_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","म्हणून त्यांनी इस्राएली लोकांवर गुलाम मुकादम ठेवले व त्यांच्याकडून जुलमाने फारोहसाठी पीथोम व रामसेस ही भंडारांची नगरे बांधून घेतली. ");
INSERT INTO marc_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","परंतु जेवढा त्यांच्यावर अत्याचार केला गेला, तेवढे ते जास्त बहुगुणित झाले आणि पसरले; म्हणून इजिप्तच्या लोकांना इस्राएली लोकांचे भय वाटू लागले. ");
INSERT INTO marc_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","इजिप्तचे लोक इस्राएली लोकांकडून कठोरपणे कष्ट करून घेऊ लागले. ");
INSERT INTO marc_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","विटा व चुन्यातील कष्टाच्या कामाने त्यांचे जीवन कठीण केले आणि शेतातील प्रत्येक प्रकारच्या कष्टाच्या कामात त्यांच्याशी इजिप्तचे लोक कठोरतेने वागले. ");
INSERT INTO marc_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","इजिप्तच्या राजाने शिफ्राह व पुआह नावाच्या दोन इब्री सुइणींना अशी सूचना दिली की, ");
INSERT INTO marc_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“इब्री स्त्रियांची प्रसूतीच्या तिवईवर मदत करीत असताना जर मुलगा जन्मला तर त्याला मारून टाका, परंतु मुलगी असली तर तिला जगू द्या.” ");
INSERT INTO marc_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","पण त्या सुइणी परमेश्वराचे भय धरणार्‍या होत्या, म्हणून त्यांनी इजिप्तच्या राजाने सांगितल्याप्रमाणे केले नाही; तर मुलांनाही जिवंत राहू दिले. ");
INSERT INTO marc_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तेव्हा इजिप्तच्या राजाने त्या सुइणींना बोलावून विचारले, “तुम्ही असे का केले? तुम्ही मुलांना का जिवंत राहू दिले?” ");
INSERT INTO marc_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","सुइणींनी फारोह राजाला उत्तर दिले, “इब्री स्त्रिया इजिप्तच्या स्त्रियांप्रमाणे नाहीत; त्या सशक्त आहेत आणि आम्ही तिथे पोहचण्या आधीच बाळंत होतात.” ");
INSERT INTO marc_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","म्हणून परमेश्वराने त्या सुइणींना आशीर्वाद दिला आणि इस्राएली लोक बहुगुणित झाले व संख्येने फार अधिक झाले. ");
INSERT INTO marc_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","या सुइणींनी परमेश्वराचे भय धरल्यामुळे परमेश्वराने त्यांची कुटुंबे स्थापित केली. ");
INSERT INTO marc_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","मग फारोहने आपल्या सर्व लोकांना हुकूम दिला, “इब्य्रांना होईल तो प्रत्येक मुलगा नाईल नदीत फेकून द्यावा, परंतु प्रत्येक मुलीला जिवंत राहू द्यावे.” ");
INSERT INTO marc_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी वंशातील एका पुरुषाने लेवी तरुणीशी विवाह केला. ");
INSERT INTO marc_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","आणि ती गरोदर राहिली आणि तिने मुलाला जन्म दिला. त्या बाळाचे रूप पाहून त्याच्या आईने त्याला तीन महिने लपवून ठेवले. ");
INSERT INTO marc_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","पण त्यानंतर त्याला ती लपवू शकत नव्हती, तेव्हा तिने त्याच्यासाठी लव्हाळ्याची एक टोपली घेतली, व तिला डांबर आणि चुन्याचा लेप लावला. मग तिने आपल्या बाळाला त्या टोपलीत ठेवले व ती टोपली तिने नाईल नदीच्या काठी लव्हाळ्यात नेऊन ठेवली. ");
INSERT INTO marc_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","बाळाचे पुढे काय होते हे पाहण्यासाठी त्याची बहीण दुरून त्याच्यावर नजर ठेऊन उभी राहिली. ");
INSERT INTO marc_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","फारोहची कन्या नाईल नदीवर स्नान करण्यासाठी गेली व तिच्या दासी नदीच्या कडेने चालत होत्या. तिने लव्हाळ्याजवळ एक टोपली पाहिली; तेव्हा ती टोपली आणण्यासाठी तिने आपल्या एका दासीला पाठविले. ");
INSERT INTO marc_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","तिने ती टोपली उघडली आणि त्यात एक बाळ रडत असल्याचे तिला दिसून आले. तिला त्याचा कळवळा आला. “हे बालक इब्री आहे,” ती म्हणाली. ");
INSERT INTO marc_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","तेवढ्यात त्या बाळाची बहीण फारोहच्या राजकन्येला म्हणाली, “या बाळाला दूध पाजण्यासाठी एखादी इब्री दाई मी तुमच्यासाठी शोधून आणू का?” ");
INSERT INTO marc_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“होय, जा,” फारोहची कन्या तिला म्हणाली. त्या मुलीने जाऊन बाळाच्या आईला आणले. ");
INSERT INTO marc_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फारोहची कन्या तिला म्हणाली, “या बाळाला घेऊन जा आणि माझ्यासाठी त्याला दूध पाज; याचे वेतन मी तुला देईन.” ती बाई त्या बाळाला आपल्या घरी घेऊन गेली व तिने त्याचे संगोपन केले. ");
INSERT INTO marc_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","पुढे बाळ मोठा झाल्यावर तिने त्याला फारोहच्या कन्येकडे आणले आणि तो तिचा पुत्र झाला. तिने त्याचे नाव मोशे असे ठेवले, कारण ती म्हणाली, “मी त्याला पाण्यातून बाहेर काढले.” ");
INSERT INTO marc_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","मोशे तरुण झाल्यानंतर, एक दिवस तो आपल्या लोकांना भेटायला गेला असताना त्याने त्यांना कष्टाने राबत असताना बघितले. इजिप्तचा एक मनुष्य त्याच्या इब्री बांधवाला मारहाण करीत असल्याचे मोशेने पाहिले. ");
INSERT INTO marc_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","आपल्याला कोणीही पाहत नाही, हे बघून त्याने त्या इजिप्ती मनुष्याला ठार केले आणि त्याला वाळूत लपवून टाकले. ");
INSERT INTO marc_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","दुसर्‍या दिवशी तो बाहेर गेला आणि त्याला दोन इब्री पुरुष मारामारी करताना दिसले. तेव्हा ज्याची चूक होती त्याला तो म्हणाला, “तू आपल्या इब्री सोबत्याला का मारत आहेस?” ");
INSERT INTO marc_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","तो मनुष्य त्याला म्हणाला, “तुला आमच्यावर अधिकारी व न्यायाधीश असे कोणी नेमले? तू इजिप्त देशाच्या मनुष्याला जसे मारून टाकलेस, तसे मलाही मारून टाकायचा तुझा विचार आहे काय?” तेव्हा मोशे घाबरला आणि त्याला वाटले, “मी जे काही केले ते सर्वांना माहीत झाले असणार.” ");
INSERT INTO marc_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","जेव्हा फारोहने हे ऐकले, त्याने मोशेला मारून टाकण्याचा प्रयत्न केला, परंतु मोशे फारोहपासून पळून मिद्यानास राहवयाला गेला, तिथे जाऊन तो एका विहिरीजवळ बसला. ");
INSERT INTO marc_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","तिथे एका मिद्यानी याजकाच्या सात मुली होत्या, त्या आपल्या पित्याच्या कळपाला पाणी पाजण्यासाठी, व कुंडे भरून घेण्यासाठी विहिरीवर आल्या. ");
INSERT INTO marc_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","पण तिथे काही धनगर आले आणि त्यांनी मुलींना तिथून हाकलून लावले. पण मोशे उठला व मुलींच्या मदतीस आला आणि त्यांच्या मेंढरांना पाणी पाजले. ");
INSERT INTO marc_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","जेव्हा मुली आपले वडील रऊएल याकडे परत गेल्या, त्याने त्यांना विचारले, “आज इतक्या लवकर कशा आल्या?” ");
INSERT INTO marc_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","त्यांनी उत्तर दिले, “एका इजिप्ती व्यक्तीने आम्हाला मेंढपाळांपासून सोडविले; त्याने आमच्यासाठी विहिरीतून पाणी सुद्धा काढले आणि मेंढरांना पाजले.” ");
INSERT INTO marc_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","“तो कुठे आहे?” रऊएलाने आपल्या मुलींना विचारले, “त्याला तुम्ही का सोडून आला? काहीतरी खावे म्हणून त्याला आमंत्रण द्या.” ");
INSERT INTO marc_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मोशेने त्या मनुष्यासह राहण्यास स्वीकारले. त्याने आपली मुलगी सिप्पोराह हिला मोशेची पत्नी म्हणून दिली. ");
INSERT INTO marc_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","सिप्पोराने एका मुलाला जन्म दिला आणि मोशेने त्याचे नाव गेर्षोम ठेवले, कारण मोशे म्हणाला, “मी विदेशात एक परदेशी झालो आहे.” ");
INSERT INTO marc_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","बराच काळ लोटल्यानंतर इजिप्तचा राजा मरण पावला. इस्राएली लोक क्लेशाने विव्हळत होते व आपल्या गुलामगिरीत रडून परमेश्वराचा धावा करीत होते; आणि त्यांच्या कष्टप्रद गुलामगिरीतील त्यांचा धावा परमेश्वराकडे पोहोचला. ");
INSERT INTO marc_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","परमेश्वराने त्यांचे रडणे ऐकले आणि अब्राहाम, इसहाक व याकोब यांच्याशी त्यांनी केलेल्या कराराचे त्यांना स्मरण झाले. ");
INSERT INTO marc_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","परमेश्वराने इस्राएली लोकांना पाहिले आणि त्यांना त्यांची आस्था वाटली. ");
INSERT INTO marc_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मोशे आपला सासरा, मिद्यानी याजक इथ्रो याची मेंढरे चारीत होता. तो ती मेंढरे घेऊन रानात, परमेश्वराचा डोंगर होरेबच्या मागच्या बाजूला गेला. ");
INSERT INTO marc_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","तिथे त्याला एका झुडूपात अग्निज्वालेमधून याहवेहचा दूत प्रकट झाला. झुडूप तर पेटले आहे, पण ते जळत नाही असे जेव्हा मोशेने पाहिले, ");
INSERT INTO marc_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","तेव्हा मोशेने विचार केला “ते झुडूप का जळत नाही, हे विचित्र दृश्य मी त्याजवळ जाऊन बघेन.” ");
INSERT INTO marc_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","मोशे ते झुडूप पाहण्यासाठी गेला हे याहवेहने पाहिले, तेव्हा परमेश्वराने त्याला झुडूपातून आवाज दिला, “मोशे, मोशे!” मोशे म्हणाला, “हा मी येथे आहे.” ");
INSERT INTO marc_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","परमेश्वर त्याला म्हणाले, “आणखी जवळ येऊ नकोस. आपली पायतणे काढ, कारण ज्या भूमीवर तू उभा आहेस ती पवित्र भूमी आहे.” ");
INSERT INTO marc_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","मग ते म्हणाले, “मी तुझ्या पूर्वजांचा परमेश्वर आहे, म्हणजे मी अब्राहामाचा परमेश्वर, इसहाकाचा परमेश्वर आणि याकोबाचा परमेश्वर आहे.” तेव्हा मोशेने आपला चेहरा झाकला, कारण परमेश्वराकडे पाहण्यास तो घाबरला. ");
INSERT INTO marc_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","नंतर याहवेहने त्याला सांगितले, “इजिप्त देशातील माझ्या लोकांचे हाल मी बघितले आहे. त्यांच्या मुकादमांच्या त्रासामुळे त्यांचे रडणे मी ऐकले आहे आणि त्यांच्या दुःखाविषयी मला चिंता आहे. ");
INSERT INTO marc_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","त्यांना इजिप्तच्या गुलामगिरीतून सोडवून चांगल्या व विस्तीर्ण देशात, दूध व मध वाहत्या देशात घेऊन जाण्यासाठी मी खाली आलो आहे. त्या देशात कनानी, हिथी, अमोरी, परिज्जी, हिव्वी व यबूसी हे लोक राहतात. ");
INSERT INTO marc_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","आणि आता इस्राएली लोकांचे रडणे माझ्यापर्यंत पोहोचले आहे आणि इजिप्तचे लोक त्यांच्यावर कसा अत्याचार करीत आहेत हे मी पाहिले आहे. ");
INSERT INTO marc_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","तर आता जा, माझ्या इस्राएलच्या लोकांना इजिप्तमधून बाहेर काढून आणावे म्हणून मी तुला फारोहकडे पाठवित आहे.” ");
INSERT INTO marc_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","पण मोशे परमेश्वराला म्हणाला, “मी कोण आहे की मी फारोहकडे जावे आणि इस्राएली लोकांना इजिप्तमधून बाहेर आणावे?” ");
INSERT INTO marc_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","परमेश्वराने म्हटले, “मी तुझ्याबरोबर असेन आणि मी तुला पाठविले आहे याचे चिन्ह हेच असणार: जेव्हा तू इस्राएली लोकांना इजिप्त देशातून बाहेर आणशील, तेव्हा याच डोंगरावर तुम्ही परमेश्वराची उपासना कराल.” ");
INSERT INTO marc_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","परंतु मोशेने परमेश्वराला विचारले, “जर मी इस्राएली लोकांकडे गेलो आणि त्यांना सांगितले, तुमच्या पूर्वजांच्या परमेश्वराने मला पाठविले आहे, तर ते मला विचारतील, त्यांचे नाव काय आहे? तर मी त्यांना काय सांगू?” ");
INSERT INTO marc_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","परमेश्वर मोशेला म्हणाले, “जो मी आहे तो मी आहे. इस्राएली लोकांना सांग: ‘मी आहे’ यांनी मला पाठवले आहे.” ");
INSERT INTO marc_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","परमेश्वर मोशेला आणखी म्हणाले, “इस्राएलास सांग, ‘अब्राहामाचा परमेश्वर, इसहाकाचा परमेश्वर आणि याकोबाचा परमेश्वर या तुमच्या पूर्वजांचा परमेश्वर याहवेहने मला तुमच्याकडे पाठविले आहे.’ “हेच माझे सनातन नाव आहे, आणि सर्व पिढ्यांपर्यंत याच नावाने तुम्ही मला हाक मारणार. ");
INSERT INTO marc_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“जा आणि इस्राएलांच्या सर्व वडीलजनांना एकत्र बोलव आणि त्यांना सांग, तुमचे पूर्वज अब्राहाम, इसहाक व याकोब यांचे परमेश्वर याहवेह हे मला प्रकट झाले आणि म्हणाले, मी तुमच्याकडे लक्ष दिले आहे आणि इजिप्तमध्ये तुमच्याबाबतीत जे काही घडत आहे ते मी पाहिले आहे. ");
INSERT INTO marc_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","आणि इजिप्तमधील तुमच्या या दुःखातून तुम्हाला बाहेर काढून कनानी, हिथी, अमोरी, परिज्जी, हिव्वी व यबूसी लोक राहत असलेल्या दूध व मध वाहत्या देशात तुम्हाला घेऊन जाण्याचे मी वचन दिलेले आहे. ");
INSERT INTO marc_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“इस्राएलचे वडीलजन तुझा शब्द मानतील. मग तू आणि वडीलजन इजिप्तच्या राजाकडे जाऊन त्याला सांगा, याहवेह, इब्रींचे परमेश्वर, यांनी आम्हाला दर्शन देऊन सांगितले आहे की आम्ही तीन दिवसांच्या प्रवासाच्या अंतरावर रानात जाऊन याहवेह आमचे परमेश्वर यास यज्ञ अर्पण करावा म्हणून तू आम्हाला जाऊ दे. ");
INSERT INTO marc_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","पण मला माहीत आहे की, बलवान हाताने दबाव आणल्याशिवाय इजिप्तचा राजा तुम्हाला जाऊ देणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","म्हणून मी आपला हात लांब करेन व माझ्या चमत्कारांनी इजिप्तवर प्रहार करेन. मग शेवटी तो तुम्हाला जाऊ देईल. ");
INSERT INTO marc_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“आणि या लोकांवर इजिप्तच्या लोकांची कृपादृष्टी होईल असे मी करेन म्हणजे तुम्ही रिक्तहस्ते बाहेर पडणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","इजिप्त देशातील स्त्रियांकडून व तुमच्या शेजारणीकडून प्रत्येक इस्राएली स्त्रीने सोन्याचे व चांदीचे दागिने व उत्तमोत्तम वस्त्रे मागून घ्यावीत व तुम्ही ते आपल्या मुलांवर व मुलींवर चढवावे, याप्रकारे तुम्ही इजिप्त देशातील लोकांना लुटाल.” ");
INSERT INTO marc_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","मोशेने उत्तर दिले, “जर त्यांनी माझ्या बोलण्यावर विश्वास ठेवला नाही किंवा माझे ऐकले नाही आणि म्हणाले, ‘याहवेह तुला प्रकट झालेच नाही’ तर मी काय करावे?” ");
INSERT INTO marc_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","याहवेहने त्याला विचारले, “तुझ्या हातात काय आहे?” त्याने उत्तर दिले, “एक काठी!” ");
INSERT INTO marc_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","याहवेह त्याला म्हणाले, “ती जमिनीवर टाक.” मोशेने ती जमिनीवर टाकली आणि तिचा साप झाला आणि मोशे भिऊन त्यापासून दूर पळाला. ");
INSERT INTO marc_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","मग याहवेहने त्याला सांगितले, “हात लांब करून सापाचे शेपूट धर.” तेव्हा मोशेने त्या सापाला धरले आणि तो पुन्हा त्याच्या हातातील काठी झाला. ");
INSERT INTO marc_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","याहवेहने मोशेला सांगितले “हे अशासाठी की याहवेह त्यांच्या पूर्वजांचे परमेश्वर—अब्राहामाचे परमेश्वर, इसहाकाचे परमेश्वर आणि याकोबाचे परमेश्वर—यांचे तुला निश्चितच दर्शन झाले आहे.” ");
INSERT INTO marc_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","मग याहवेह त्याला म्हणाले, “तुझा हात तुझ्या झग्याच्या आत घाल.” मग मोशेने आपला हात आपल्या झग्याच्या आत घातला आणि जेव्हा त्याने हात बाहेर काढला, त्याची कातडी कोडाने भरली; तो हिमासारखा पांढरा झाला होता. ");
INSERT INTO marc_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“आता परत आपला हात झग्याच्या आत घाल,” याहवेह म्हणाले आणि मोशेने परत आपला हात झग्याच्या आत घातला, आणि जेव्हा तो बाहेर काढला, तो पूर्ववत त्याच्या शरीराच्या बाकीच्या कातडीप्रमाणे झाला. ");
INSERT INTO marc_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","तेव्हा याहवेह म्हणाले, “पहिले चिन्ह पाहून जर त्यांनी विश्वास ठेवला नाही, तर दुसरे चिन्ह पाहून कदाचित ते विश्वास ठेवतील. ");
INSERT INTO marc_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","पण या दोन्ही चिन्हांवर त्यांनी विश्वास ठेवला नाही तर तू नाईल नदीचे पाणी घेऊन ते कोरड्या जमिनीवर ओत म्हणजे नदीतून घेतलेल्या पाण्याचे जमिनीवर रक्त होईल.” ");
INSERT INTO marc_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","मोशे याहवेहला म्हणाला, “आपल्या सेवकास क्षमा करावी, प्रभू मी चांगला वक्ता नाही, कधीही नव्हतो आणि आपण माझ्याबरोबर प्रत्यक्ष बोलत होता तेव्हाही नाही. मी मुखदुर्बल व जिभेचा जड आहे.” ");
INSERT INTO marc_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","याहवेह त्याला म्हणाले, “मनुष्यांना मुख कोणी दिले? त्यांना बहिरा किंवा मुका कोण करतो? त्याला कोण दृष्टी देतो? किंवा कोण आंधळे करतो? तो मी याहवेह नाही का? ");
INSERT INTO marc_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","आता जा; मी तुला बोलण्यास मदत करेन आणि काय बोलावे ते तुला शिकवेन.” ");
INSERT INTO marc_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","पण मोशे म्हणाला, “तुमच्या सेवकास क्षमा करावी, प्रभू. कृपा करून दुसर्‍या कोणाला पाठवा.” ");
INSERT INTO marc_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तेव्हा मोशेविरुद्ध याहवेहचा राग भडकला, ते म्हणाले, “लेवी अहरोन, तुझा भाऊ, याच्याविषयी काय? मला ठाऊक आहे की तो चांगले बोलू शकतो. तो तुला भेटावे म्हणून मार्गावर आहे, तुला पाहून त्याला फार आनंद होईल. ");
INSERT INTO marc_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","तू त्याच्याशी बोलून त्याच्या मुखात शब्द घाल; मी तुम्हा दोघांना बोलण्यास मदत करेन, आणि काय करावे हे शिकवेन. ");
INSERT INTO marc_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","तो तुझ्या वतीने लोकांबरोबर बोलेल, जसे तो तुझेच मुख आहे व तू त्याला परमेश्वरासारखा होशील असे मी करेन. ");
INSERT INTO marc_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","परंतु ही काठी आपल्या हातात घे, म्हणजे तिच्यायोगे तुला चिन्हे करता येतील.” ");
INSERT INTO marc_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","मग मोशे आपला सासरा इथ्रोकडे गेला आणि त्याला म्हणाला, “इजिप्त देशात असलेल्या माझ्या स्वकियांकडे परत जाऊन त्यातील कोणी जिवंत आहेत की नाही ते मला पाहू दे.” इथ्रोने उत्तर दिले, “जा. तुझे भले होवो.” ");
INSERT INTO marc_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","मिद्यानात याहवेहने मोशेला म्हटले, “इजिप्त देशास जा, कारण तुला ठार करावयास जे टपलेले होते, ते सर्व आता मरण पावले आहेत.” ");
INSERT INTO marc_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","तेव्हा मोशे आपली पत्नी व मुले यांना गाढवावर बसवून इजिप्तला परतला. त्याने आपल्या हाती परमेश्वराची काठी घेतली. ");
INSERT INTO marc_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","याहवेह मोशेला म्हणाले, “इजिप्त देशात पोहोचल्यावर फारोहसमोर जाऊन, मी जे चमत्कार करण्याचे सामर्थ्य तुला दिले आहे, ते त्याच्यापुढे सादर कर. पण मी फारोहचे हृदय कठीण करेन आणि तो लोकांना जाऊ देणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","मग तू फारोहला सांग, ‘याहवेह असे म्हणतात: इस्राएल माझा ज्येष्ठपुत्र आहे, ");
INSERT INTO marc_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","आणि मी तुला सांगितल्याप्रमाणे, माझ्या पुत्राला माझी आराधना करण्यासाठी तू जाऊ द्यावेस. पण तू त्यांना पाठविण्यास नकार दिला; तर मी तुझा ज्येष्ठपुत्र मारून टाकीन.’ ” ");
INSERT INTO marc_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","मोशे आपल्या मार्गात एके ठिकाणी मुक्कामास असताना, जसे याहवेह त्याला मारणारच असे गाठले. ");
INSERT INTO marc_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","सिप्पोराहने एक धारदार गारेचा तुकडा घेऊन, आपल्या मुलाची अग्रत्वचा कापून त्याची सुंता केली व त्या अग्रत्वचेने तिने मोशेच्या पायांस स्पर्श केला आणि ती त्याला म्हणाली, “खरोखर तुम्ही माझे रक्ताचे वर आहात.” ");
INSERT INTO marc_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","नंतर याहवेहने त्याला सोडले. (“रक्ताचा वर” असे तिने सुंतेच्या बाबतीत म्हटले.) ");
INSERT INTO marc_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","आता याहवेहने अहरोनाला म्हटले, “मोशेला भेटण्यासाठी रानात जा.” तेव्हा अहरोन मोशेला परमेश्वराच्या पर्वतावर भेटला आणि त्याचे चुंबन घेतले. ");
INSERT INTO marc_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","तेव्हा याहवेहने जे काही सांगावयास त्याला पाठविले होते ते सर्व मोशेने अहरोनाला सांगितले आणि जी चिन्हे करावयास सांगितली आहेत, त्याविषयी सुद्धा त्याला सांगितले. ");
INSERT INTO marc_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","मग मोशे व अहरोन यांनी इस्राएलांच्या सर्व वडिलांना एकत्र बोलाविले, ");
INSERT INTO marc_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","आणि याहवेहने मोशेला जे सांगितले होते ते सर्वकाही अहरोनाने त्यांना सांगितले. मोशेने लोकांच्या देखत चिन्हे करून दाखविली. ");
INSERT INTO marc_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","तेव्हा या गोष्‍टीवर त्यांनी विश्वास केला. आणि जेव्हा त्यांनी हे ऐकले की याहवेहने इस्राएली लोकांची भेट घेऊन त्यांचे दुःख पाहिले आहे, तेव्हा सर्वांनी नमन करून उपासना केली. ");
INSERT INTO marc_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","नंतर मोशे व अहरोन फारोहकडे जाऊन त्याला म्हणाले, “याहवेह इस्राएलचे परमेश्वर असे म्हणतात: ‘माझ्या लोकांना जाऊ दे, यासाठी की रानात जाऊन त्यांनी माझा उत्सव साजरा करावा.’ ” ");
INSERT INTO marc_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","यावर फारोह म्हणाला, “हा याहवेह कोण आहे, की मी त्याचे ऐकावे व इस्राएली लोकांना जाऊ द्यावे? मी याहवेहला ओळखत नाही. मी इस्राएलला जाऊ देणार नाही.” ");
INSERT INTO marc_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","तेव्हा ते फारोहला म्हणाले, “इब्री लोकांच्या परमेश्वराने आम्हाला दर्शन दिले. आता आम्ही याहवेह, आमच्या परमेश्वराला यज्ञ करावा म्हणून आम्हाला तीन दिवसांचा प्रवास करून रानात जाऊ दे. नाही तर परमेश्वर आम्हाला पीडांनी किंवा तलवारीने मारून टाकेल.” ");
INSERT INTO marc_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","यावर इजिप्तचा राजा म्हणाला, “अहो मोशे व अहरोन, तुम्ही लोकांना त्यांच्या कामापासून का दूर नेत आहात? आपल्या कामास परत जा!” ");
INSERT INTO marc_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","मग फारोह म्हणाला, “पाहा, देशाच्या लोकांची संख्या पुष्कळपटीने वाढली आहे आणि तुम्ही त्यांच्या कामात अडथळा आणत आहात.” ");
INSERT INTO marc_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","त्याच दिवशी फारोहने इस्राएलावर नेमलेल्या मुकादमांना व अधिकार्‍यांना हुकूम दिला: ");
INSERT INTO marc_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“यापुढे लोकांना विटा तयार करण्यासाठी गवत देऊ नका; आपल्यासाठी गवत त्यांनी स्वतःच गोळा करावे. ");
INSERT INTO marc_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तरीही पूर्वी ते जितक्या विटा तयार करीत होते तितक्या त्यांनी केल्याच पाहिजे; त्यात घट होऊ नये. ते आळशी आहेत; म्हणूनच, ‘आम्हाला रानात जाऊन आमच्या परमेश्वराला यज्ञ करू दे,’ अशी ओरड करीत आहेत. ");
INSERT INTO marc_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","त्यांच्यासाठी काम अजून कठीण करा, म्हणजे ते काम करत राहतील व खोट्या गोष्टींकडे ते लक्ष देणार नाहीत.” ");
INSERT INTO marc_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","तेव्हा मुकादम व पुढारी यांनी इस्राएली लोकांना सांगितले, “फारोहने असे सांगितले आहे की मी तुम्हाला यापुढे गवत देणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","तर जाऊन मिळेल तिथून आपल्यासाठी गवत शोधून आणा, मात्र तुमचे काम मुळीच कमी करण्यात येणार नाही.” ");
INSERT INTO marc_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","तेव्हा लोक गवत गोळा करून आणण्यासाठी इजिप्तभर पांगले. ");
INSERT INTO marc_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","मुकादम त्यांना जोर देऊन म्हणत होते, “गवत असताना जेवढे काम करीत होते तितकेच नेमून दिलेले काम रोज झाले पाहिजे.” ");
INSERT INTO marc_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","फारोहच्या मुकादमांनी इस्राएली गटांवर नेमलेल्या पुढार्‍यांना मार देऊन विचारले, “पूर्वीप्रमाणे, काल व आज तुम्हाला नेमून दिलेले विटा तयार करण्याचे काम तुम्ही का पूर्ण केले नाही?” ");
INSERT INTO marc_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","तेव्हा इस्राएलांचे पुढारी फारोहकडे जाऊन त्याला विनवून म्हणाले, “तुम्ही आपल्या सेवकांशी असे निष्ठुरपणे का वागता? ");
INSERT INTO marc_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","तुमच्या दासांना गवत नाही, तरीही ‘विटा तयार करा!’ असे सांगितले जाते, तुमच्या सेवकांना मारहाण करण्यात येते, परंतु सगळा दोष तुमच्याच लोकांचा आहे.” ");
INSERT INTO marc_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फारोहने उत्तर दिले, “तुम्ही आळशी लोक आहात—आळशी! म्हणून तुम्ही म्हणता, ‘आम्हाला याहवेहपुढे यज्ञ करावयास जाऊ द्यावे.’ ");
INSERT INTO marc_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","आता आपले काम करा. तुम्हाला गवत पुरविले जाणार नाही, तरी नेमल्याप्रमाणेच विटा तयार करून द्याव्या लागतील.” ");
INSERT INTO marc_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“तुम्हाला नेमून दिल्याप्रमाणे रोजचे विटा बनविण्याचे काम कमी केले जाणार नाही,” असे ऐकल्यावर आपण अडचणीत सापडलो आहोत, असे इस्राएली पुढाऱ्यांच्या लक्षात आले. ");
INSERT INTO marc_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","फारोहकडून आल्यावर, अहरोन व मोशे आपल्याशी बोलण्यास वाट पाहत आहेत असे त्यांनी पाहिले, ");
INSERT INTO marc_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ते त्यांना म्हणाले, “याहवेह तुम्हाकडे पाहो व तुमचा न्याय करो! तुम्ही दोघांनी फारोह व त्याच्या अधिकार्‍यांसमोर आम्हाला किळसवाणे असे केले आहे आणि आम्हाला मारून टाकण्यासाठी त्यांच्या हाती तलवार दिली आहे.” ");
INSERT INTO marc_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","मोशे याहवेहकडे जाऊन म्हणाला, “हे प्रभू, या लोकांवर तुम्ही अरिष्ट का आणले? यासाठीच तुम्ही मला पाठवले आहे का? ");
INSERT INTO marc_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","मी तुमच्या नावाने फारोहला बोललो, तेव्हापासून त्याने त्यांच्यावर त्रास आणला आहे आणि तुम्ही आपल्या लोकांना सोडविले नाही.” ");
INSERT INTO marc_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तेव्हा याहवेह मोशेला म्हणाले, “आता मी फारोहला काय करतो, ते तू पाहशील: कारण माझ्या पराक्रमी हातामुळे तो लोकांना जाऊ देईल; कारण माझ्या बलवान हातामुळे तो त्यांना आपल्या देशाबाहेर घालवून देईल.” ");
INSERT INTO marc_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","परमेश्वर मोशेला म्हणाले, मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","मी सर्वसमर्थ परमेश्वर म्हणून अब्राहाम, इसहाक व याकोब यांना प्रकट झालो होतो, परंतु माझ्या याहवेह या नावाने मी स्वतःची त्यांना ओळख करून दिली नव्हती. ");
INSERT INTO marc_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ज्या कनान देशात ते पूर्वी परदेशी म्हणून राहत होते, तो देश मी त्यांना देईन, असा मी त्यांच्याशी करार स्थापित केला. ");
INSERT INTO marc_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","आता इस्राएली लोकांचे इजिप्तच्या दास्यातील विव्हळणे मी ऐकले आणि माझ्या कराराची मला आठवण झाली आहे. ");
INSERT INTO marc_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","म्हणून इस्राएली लोकांना सांग, “मी याहवेह आहे आणि मी तुम्हाला इजिप्तच्या लोकांच्या ओझ्याखालून बाहेर आणेन, त्यांच्या कष्टप्रद गुलामगिरीतून मी तुम्हाला मुक्त करेन आणि माझ्या लांब केलेल्या बाहूने व न्यायाच्या महान कृत्यांनी तुमची सुटका करेन. ");
INSERT INTO marc_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","मी तुम्हाला माझे लोक म्हणून स्वीकारेन आणि मी तुमचा परमेश्वर होईन, मग तुम्हाला कळून येईल की, तुम्हाला इजिप्तच्या ओझ्याखालून सोडविणारा परमेश्वर याहवेह मीच आहे. ");
INSERT INTO marc_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","आणि जो देश अब्राहाम, इसहाक व याकोब यांना देण्यास मी हात उंच करून शपथ वाहिली, त्यात मी तुम्हाला आणेन आणि तो तुम्हाला वतन म्हणून देईन. मीच याहवेह आहे.” ");
INSERT INTO marc_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","तेव्हा मोशेने हे सर्व इस्राएली लोकांना सांगितले, परंतु त्यांची निराशा व कठोर परिश्रम यामुळे त्यांनी त्याचे ऐकले नाही. ");
INSERT INTO marc_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तेव्हा याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“जा, इजिप्तचा राजा फारोह याला सांग की, इस्राएल लोकांस त्याच्या देशातून त्याने जाऊ द्यावे.” ");
INSERT INTO marc_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","परंतु मोशे याहवेहला म्हणाला, “मी बोबड्या ओठांचा आहे म्हणून जर इस्राएल लोकच माझे ऐकत नाहीत, तर फारोह माझे का ऐकेल?” ");
INSERT INTO marc_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","आता याहवेह मोशे व अहरोनाशी इस्राएली लोक व इजिप्तचा राजा फारोह याविषयी बोलले आणि इस्राएली लोकांना इजिप्तमधून बाहेर आणावे याविषयी आज्ञा केली. ");
INSERT INTO marc_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","त्यांच्या कुटुंब प्रमुखांची नावे ही: इस्राएलाचा प्रथमपुत्र रऊबेन याचे पुत्र: हनोख व पल्लू, हेस्रोन व कर्मी. ");
INSERT INTO marc_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमओनाचे पुत्र हे: यमुवेल, यामीन, ओहाद, याखीन, जोहर आणि कनानी स्त्रीचा पुत्र शौल. ");
INSERT INTO marc_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवीच्या पुत्रांची ही क्रमानुसार नावे: गेर्षोन, कोहाथ व मरारी. ");
INSERT INTO marc_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्षोनाच्या पुत्रांची त्यांच्या कुळांनुसार नावे ही: लिब्नी व शिमी. ");
INSERT INTO marc_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कोहाथाच्या पुत्रांची नावे: अम्राम, इसहार, हेब्रोन व उज्जीएल. (कोहाथ एकशे तेहतीस वर्षे जगला.) ");
INSERT INTO marc_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारीच्या पुत्रांची नावे: महली व मूशी. ");
INSERT INTO marc_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्रामाने आपल्या वडिलांची बहीण योखबेद हिच्याबरोबर विवाह केला आणि तिच्यापासून त्याला अहरोन व मोशे हे झाले. ");
INSERT INTO marc_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","इसहाराच्या पुत्रांची नावे: कोरह, नेफेग व जिक्री. ");
INSERT INTO marc_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्जीएलाच्या पुत्रांची नावे: मिशाएल, एलसाफान व सिथ्री. ");
INSERT INTO marc_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","अहरोनाने अम्मीनादाबाची कन्या, नहशोनाची बहीण एलीशेबा हिच्याबरोबर विवाह केला. तिच्यापासून त्याला नादाब व अबीहू, एलअज़ार व इथामार झाले. ");
INSERT INTO marc_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरहाच्या पुत्रांची नावे: अस्सीर, एलकानाह व अबीयासाफ. ");
INSERT INTO marc_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","अहरोनाचा पुत्र एलअज़ार याने पुटिएलाच्या कन्यांपैकी एकीबरोबर विवाह केला, आणि तिच्यापासून त्याला फिनहास झाला. ");
INSERT INTO marc_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ज्या अहरोन व मोशे यांना याहवेहने सांगितले होते, “इजिप्तच्या भूमीतून सर्व इस्राएलच्या लोकांना त्यांच्या तुकडीनुसार बाहेर आणा.” ");
INSERT INTO marc_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","हे तेच मोशे व अहरोन आहेत जे इस्राएल लोकांना इजिप्तमधून बाहेर आणण्यासंबंधी इजिप्तचा राजा फारोहबरोबर बोलले. ");
INSERT INTO marc_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","जेव्हा मोशे इजिप्तमध्ये होता तेव्हा याहवेह त्याच्याशी बोलले, ");
INSERT INTO marc_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","याहवेह मोशेला म्हणाले, “मी याहवेह आहे. जा व मी तुला जे काही सांगतो ते इजिप्तचा राजा फारोह याला सांग.” ");
INSERT INTO marc_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","परंतु मोशे याहवेहला म्हणाला, “कारण मी बोबड्या ओठांचा आहे, फारोह माझे कसे ऐकणार?” ");
INSERT INTO marc_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","मग याहवेह मोशेला म्हणाले, “पाहा, मी तुला फारोहसाठी परमेश्वरासारखे केले आहे आणि तुझा भाऊ अहरोन तुझा संदेष्टा असेल. ");
INSERT INTO marc_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","तुला जे काही मी आज्ञापिणार आहे ते सर्व तू बोलावयचे आणि तुझा भाऊ अहरोन याने इस्राएली लोकांना त्याच्या देशातून जाऊ द्यावे असे फारोहला सांगावयाचे आहे. ");
INSERT INTO marc_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","पण मी फारोहचे हृदय कठीण करेन आणि इजिप्तमध्ये जरी मी माझी चिन्हे व चमत्कार बहुगुणित करेन, ");
INSERT INTO marc_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","तरीही फारोह तुझे ऐकणार नाही. मग मी इजिप्तवर माझा हात उगारेन आणि मोठ्या पराक्रमी कृत्यांच्या न्यायाने मी माझे सैन्य, माझे इस्राएली लोक यांना बाहेर काढेन. ");
INSERT INTO marc_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","आणि जेव्हा मी माझा हात इजिप्तविरुद्ध उगारेन आणि इस्राएलास बाहेर आणेन, तेव्हा इजिप्तच्या लोकांना समजेल की मीच याहवेह आहे.” ");
INSERT INTO marc_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","मग मोशे व अहरोन यांनी याहवेहच्या आज्ञेप्रमाणे केले. ");
INSERT INTO marc_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","जेव्हा ते फारोहपुढे जाऊन बोलले तेव्हा मोशे ऐंशी वर्षांचा व अहरोन त्र्याऐंशी वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","मग याहवेह मोशे व अहरोन यास म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“जेव्हा फारोह तुम्हाला म्हणेल, ‘चमत्कार करून दाखवा,’ तेव्हा अहरोनास सांग, ‘तुझी काठी घे आणि फारोहसमोर खाली टाक,’ आणि तिचा साप होईल.” ");
INSERT INTO marc_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","मग मोशे व अहरोन फारोहकडे गेले व याहवेहने त्यांना सांगितल्याप्रमाणेच केले. अहरोनाने आपली काठी फारोहसमोर व त्याच्या सेवकांसमोर खाली जमिनीवर टाकली आणि तिचा साप झाला. ");
INSERT INTO marc_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तेव्हा फारोहने इजिप्तच्या ज्ञानी व मांत्रिकांना बोलाविले. त्यांनीही आपल्या गुप्त ज्ञानानुसार तसेच केले: ");
INSERT INTO marc_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","प्रत्येकाने आपआपली काठी खाली टाकली आणि त्यांचा साप झाला. पण अहरोनाच्या काठीने त्यांच्या काठ्या गिळून टाकल्या. ");
INSERT INTO marc_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","तरी देखील याहवेहने सांगितल्याप्रमाणे फारोहचे हृदय कठीण झाले आणि त्याने त्यांचे ऐकले नाही. ");
INSERT INTO marc_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तेव्हा याहवेह मोशेला म्हणाले, “फारोहचे हृदय कठीण आहे आणि तो इस्राएली लोकांना जाऊ देण्यास नाकारतो. ");
INSERT INTO marc_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","फारोह सकाळी बाहेर नदीकडे जात असताना त्याच्याकडे जा. नाईल नदीच्या काठावर जाऊन त्याची भेट घे आणि ज्या काठीचा साप झाला होता, ती काठी आपल्या हातात घे. ");
INSERT INTO marc_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","मग त्याला सांग, ‘याहवेह, इब्रींचे परमेश्वर यांनी मला हे सांगण्यासाठी तुझ्याकडे पाठविले आहे: माझ्या लोकांना जाऊ दे, यासाठी की त्यांनी रानात जाऊन माझी उपासना करावी, पण अजूनही तू ऐकले नाहीस. ");
INSERT INTO marc_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","याहवेह असे म्हणतात: यावरून मी याहवेह आहे हे तुला कळेल: माझ्या हातात जी काठी आहे, ती मी नाईल नदीच्या पाण्यावर मारीन, आणि तिचे रक्त होईल. ");
INSERT INTO marc_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","मग नाईल नदीतील मासे मरतील आणि नदीला दुर्गंध सुटेल; इजिप्तचे लोक ते पाणी पिऊ शकणार नाहीत.’ ” ");
INSERT INTO marc_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","मग याहवेह मोशेला म्हणाले, “अहरोनाला सांग, ‘आपली काठी घेऊन, इजिप्तचे पाणी म्हणजेच नद्या, नाले, तलाव व सर्व तळे यावर आपला हात लांब कर; आणि त्याचे रक्त होईल’ इजिप्तमध्ये सर्वत्र, लाकडी भांड्यात व दगडी पात्रात सुद्धा रक्त असेल.” ");
INSERT INTO marc_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","मोशे व अहरोन यांनी याहवेहच्या आज्ञेप्रमाणे केले. अहरोनाने आपल्या हातातील काठी, फारोहच्या व त्याच्या सेवकांच्या समक्ष उंच केली आणि नाईल नदीच्या पाण्यावर मारली आणि नदीतील सर्व पाण्याचे रक्तात रूपांतर झाले. ");
INSERT INTO marc_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नाईल नदीतील सर्व मासे मेले, व त्यामुळे पाण्याला इतकी दुर्गंधी सुटली की इजिप्तच्या लोकांना ते पाणी पीता येईना, इजिप्त देशात सर्वत्र रक्त झाले होते. ");
INSERT INTO marc_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","पण इजिप्तच्या जादूगारांनीही आपल्या गुप्तज्ञानाने पाण्याचे रक्त केले. फारोहचे मन पुन्हा कठीण झाले व याहवेहने सांगितल्याप्रमाणे त्याने मोशे व अहरोन यांचे ऐकले नाही. ");
INSERT INTO marc_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","आणि फारोहने हे मनावर न घेता, तो आपल्या राजवाड्यात परतला. ");
INSERT INTO marc_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","आणि इजिप्तच्या लोकांनी नाईल नदीच्या किनार्‍यावर खणले, कारण नदीचे पाणी ते पिऊ शकत नव्हते. ");
INSERT INTO marc_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","याहवेहने नाईलवर प्रहार करून सात दिवस लोटले. ");
INSERT INTO marc_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","मग याहवेह मोशेला म्हणाले, “फारोहकडे जा आणि त्याला सांग, याहवेह असे म्हणतात, माझ्या लोकांना जाऊ दे, अशासाठी की त्यांनी माझी उपासना करावी. ");
INSERT INTO marc_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","तू जर त्यांना जाऊ देण्याचे नाकारलेस, तर तुझ्या संपूर्ण देशात मी बेडकांची पीडा पाठवेन. ");
INSERT INTO marc_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नाईल नदी बेडकांनी भरून जाईल. ते तुझ्या महालात व तुझ्या शयनगृहात, तुझ्या अंथरुणात येतील, तुझ्या अधिकार्‍यांच्या घरात आणि तुझ्या लोकांवर, तुझ्या भट्ट्या व तुझ्या परातीत ते येतील. ");
INSERT INTO marc_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","बेडूक तुझ्यावर आणि तुझ्या लोकांवर आणि तुझ्या सर्व अधिकार्‍यांवर येतील.” ");
INSERT INTO marc_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","यानंतर याहवेह मोशेला म्हणाले, “अहरोनाला सांग, त्याने त्याच्या हातात काठी घेऊन आपला हात इजिप्तमधील सर्व ओढे, कालव्याच्या व तलावाच्या दिशेला लांब करावा म्हणजे इजिप्त देशाच्या भूमीवर बेडूक येतील.” ");
INSERT INTO marc_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","त्याप्रमाणे अहरोनाने इजिप्तच्या पाण्यावर आपला हात लांब केला आणि संपूर्ण देश बेडकांनी व्यापून गेला. ");
INSERT INTO marc_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","पण जादूगारांनीही आपल्या गुप्तज्ञानाने तसेच केले व इजिप्त देशात बेडूक आणले. ");
INSERT INTO marc_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","मग फारोहने मोशे व अहरोन यांना बोलावून सांगितले, “याहवेहकडे प्रार्थना करा की त्यांनी माझ्यापासून व माझ्या लोकांपासून बेडूक दूर करावेत, मग मी तुझ्या लोकांनी याहवेहला यज्ञ करावा म्हणून त्यांना जाऊ देईन.” ");
INSERT INTO marc_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मोशे फारोहला म्हणाला, “हा सन्मान मी तुला देतो, की मी तुझ्यासाठी, तुझ्या अधिकार्‍यांसाठी व लोकांसाठी विनंती करावी अशी वेळ तू नेमून ठेवावी, म्हणजे तुमच्यातून बेडूक नाहीसे होतील, नाईल नदीतील बेडके मात्र राहतील.” ");
INSERT INTO marc_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फारोह मोशेला म्हणाला, “उद्या.” मोशेने उत्तर दिले, “तुझ्या सांगण्याप्रमाणे होईल, अशासाठी की तू जाणावे की याहवेह आमचे परमेश्वर यासारखे इतर कोणीही नाही. ");
INSERT INTO marc_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","नाईल नदीतील बेडूक सोडून बाकीचे सर्व बेडूक तू, तुझे घर, तुझे सेवक व तुझ्या लोकांपासून निघून जातील.” ");
INSERT INTO marc_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","मग मोशे व अहरोन फारोहला सोडून गेल्यानंतर, जी बेडके याहवेहने फारोहवर आणली होती, त्याविषयी मोशेने याहवेहला विनंती केली. ");
INSERT INTO marc_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","मोशेने मागितल्याप्रमाणे याहवेहने केले; आणि घरातील, अंगणातील व शेतातील सर्व बेडूक मरून गेले. ");
INSERT INTO marc_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","त्यांचे ढीग जमा झाले, व देशात त्यांची दुर्गंधी पसरली. ");
INSERT INTO marc_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","पण सगळे व्यवस्थित झाले असे पाहून फारोहने आपले मन कठीण केले व याहवेहने सांगितल्याप्रमाणे मोशे व अहरोनाचे त्याने ऐकले नाही. ");
INSERT INTO marc_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","मग याहवेह मोशेला म्हणाले, “अहरोनाला सांग, ‘आपली काठी लांब कर व भूमीच्या धुळीवर आपट,’ आणि संपूर्ण इजिप्तभर या धुळीची चिलटे होतील.” ");
INSERT INTO marc_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","त्यांनी तसे केले, आणि जेव्हा अहरोनाने काठी घेऊन आपला हात लांब केला आणि भूमीच्या धुळीवर मारली, तेव्हा मनुष्य व जनावरे यावर चिलटे आली. इजिप्त देशभरातील सगळी धूळ चिलटे अशी झाली. ");
INSERT INTO marc_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","परंतु जेव्हा जादूगारांनी आपल्या गुप्तज्ञानाने तसेच करण्याचा प्रयत्न केला, ते करू शकले नाही. कारण सगळीकडे लोकांवर व जनावरांवर चिलटे आली होती, ");
INSERT INTO marc_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","तेव्हा ते जादूगार फारोहला म्हणाले, “ही परमेश्वराची अंगुली आहे.” पण याहवेहने सांगितल्याप्रमाणे फारोहचे हृदय कठीण होते आणि त्याने त्यांचे ऐकले नाही. ");
INSERT INTO marc_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","यानंतर याहवेह मोशेला म्हणाले, “पहाटे ऊठ व फारोह नदीवर जात असता त्याची भेट घे आणि त्याला सांग याहवेह असे म्हणतात: माझ्या लोकांना जाऊ दे, यासाठी की त्यांनी माझी उपासना करावी. ");
INSERT INTO marc_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","जर तू माझ्या लोकांना जाऊ दिले नाहीस तर मी तुझ्यावर आणि तुझ्या सेवकांवर व तुझ्या लोकांवर व तुमच्या घरांमध्ये गोमाश्यांचे थवे पाठवेन. इजिप्त लोकांची घरे गोमाश्यांनी भरून जातील; व जमीन सुद्धा गोमाश्यांनी झाकली जाईल. ");
INSERT INTO marc_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“पण त्या दिवशी माझे लोक राहतात त्या गोशेन प्रांताशी मी वेगळा वागेन; त्या ठिकाणी मात्र गोमाश्यांचे थवे नसतील, यावरून तुला समजावे की, मी याहवेह या भूमीवर आहे. ");
INSERT INTO marc_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","माझे लोक व तुझे लोक यांच्यामध्ये मी फरक करेन. हे चिन्ह उद्याच घडेल.” ");
INSERT INTO marc_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","आणि याहवेहने तसेच केले. आणि पाहा, फारोहचा राजवाडा, त्याच्या अधिकार्‍यांची घरे व इजिप्तच्या लोकांची सर्व घरे गोमाश्यांच्या दाट थव्यांनी भरून गेली; आणि गोमाश्यांनी देशाची नासाडी केली. ");
INSERT INTO marc_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","मग फारोहने मोशे व अहरोन यांना बोलावून म्हटले, “जा, याच देशात तुमच्या परमेश्वराला यज्ञ करा.” ");
INSERT INTO marc_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","पण मोशे म्हणाला, “तसे करणे बरे नाही. याहवेह आमच्या परमेश्वराला जो यज्ञ आम्ही करतो तो इजिप्तच्या लोकांना किळसवाणा वाटेल. आणि असा यज्ञ ज्याची ते किळस करतात तो जर आम्ही केला, तर ते आम्हाला धोंडमार करणार नाही काय? ");
INSERT INTO marc_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","म्हणून आम्ही तीन दिवसांचा प्रवास करून रानात जाऊन आमचे परमेश्वर याहवेह आज्ञा देईल त्याप्रमाणे आम्ही बळी अर्पण करू.” ");
INSERT INTO marc_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फारोहने म्हटले, “तुमचा परमेश्वर याहवेह यास रानात जाऊन यज्ञ करावा म्हणून मी तुम्हाला जाऊ देतो, परंतु फार दूर जाऊ नका. आता माझ्यासाठी विनंती करा.” ");
INSERT INTO marc_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मोशे त्याला म्हणाला, “मी तुला सोडून गेल्याबरोबर याहवेहकडे तुझ्यासाठी विनंती करेन, आणि उद्या गोमाशा फारोहस व त्याच्या अधिकार्‍यांस व त्याच्या लोकास सोडून जातील. लोकांनी याहवेहला यज्ञ करण्यास जाऊ नये म्हणून फारोहने पुन्हा फसवणूक करू नये याची त्याने दक्षता घ्यावी.” ");
INSERT INTO marc_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","मग मोशे फारोह पुढून निघून गेला व याहवेहकडे विनंती केली, ");
INSERT INTO marc_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","व मोशेने जे याहवेहपाशी मागितले त्याप्रमाणे याहवेहने केले. फारोह, त्याचे सेवक व त्याच्या लोकांपासून गोमाशा निघून गेल्या; एक सुद्धा गोमाशी बाकी राहिली नाही. ");
INSERT INTO marc_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","परंतु यावेळी सुद्धा फारोहने आपले हृदय कठीण केले आणि इस्राएली लोकांना जाऊ दिले नाही. ");
INSERT INTO marc_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","तेव्हा याहवेह मोशेला म्हणाले, “फारोहकडे जा व त्याला सांग, ‘इब्री लोकांचे परमेश्वर याहवेह असे म्हणतात, “माझ्या लोकांना जाऊ दे, अशासाठी की त्यांनी माझी उपासना करावी.” ");
INSERT INTO marc_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","जर तू त्यांना जाण्यास नकार दिला आणि त्यांना धरून ठेवलेस, ");
INSERT INTO marc_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","तर शेतातील तुमची जनावरे—घोडे, गाढवे, उंट व शेळ्यामेंढ्यांचे कळप यांच्यावर याहवेहचा हात भयानक पीडा आणेल. ");
INSERT INTO marc_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","परंतु याहवेह इस्राएलची जनावरे व इजिप्तची जनावरे यात फरक करतील, असा की इस्राएली लोकांची जनावरे मरणार नाहीत.’ ” ");
INSERT INTO marc_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","याहवेहने समय नेमून ठेवला व म्हणाले, “याहवेह हे उद्या देशभर घडवून आणतील.” ");
INSERT INTO marc_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","आणि दुसर्‍या दिवशी याहवेहने तसेच केले: इजिप्त लोकांची सर्व गुरे मरून गेली, परंतु इस्राएल लोकांच्या कळपातील एकही जनावर मेले नाही. ");
INSERT INTO marc_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फारोहने शोध घेतला व जाणून घेतले की इस्राएलातील एकही जनावर मेले नाही, तरीसुद्धा फारोहचे मन बदलले नाही व त्याने इस्राएली लोकांना जाऊ दिले नाही. ");
INSERT INTO marc_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","नंतर याहवेह मोशे व अहरोन यांना म्हणाले, “भट्टीतून मूठभर राख घेऊन मोशेने ती फारोहच्या देखत हवेत उधळावी. ");
INSERT INTO marc_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","व संपूर्ण इजिप्त देशभर तिचा धुरळा होईल व त्यामुळे देशातील प्रत्येक मनुष्य व पशू यांच्यावर गळवे फुटतील.” ");
INSERT INTO marc_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","तेव्हा त्यांनी भट्टीतील राख घेतली व फारोहसमोर उभे राहून मोशेने ती राख हवेत उधळली, तेव्हा मनुष्यांवर व सर्व जनावरांवर गळवे फुटली. ");
INSERT INTO marc_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","मांत्रिक मोशेसमोर उभे राहू शकले नाहीत, कारण त्यांच्याही अंगावर व सर्व इजिप्तच्या लोकांवर गळवे फुटली होती. ");
INSERT INTO marc_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","पण याहवेहने फारोहचे मन कठीण केले व याहवेहने सांगितल्याप्रमाणे फारोहने मोशे व अहरोन यांचे ऐकले नाही. ");
INSERT INTO marc_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","मग याहवेह मोशेला म्हणाले, “अगदी पहाटेच ऊठ, फारोहची भेट घे आणि त्याला सांग, इब्री लोकांचे परमेश्वर याहवेह असे म्हणतात: माझी उपासना करण्यासाठी माझ्या लोकांना जाऊ दे. ");
INSERT INTO marc_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","नाहीतर यावेळी मी तुम्हा सर्वांवर म्हणजेच तू व तुझे अधिकारी व तुझे लोक या सर्वांवर भयानक पीडा पाठवेन, ज्यामुळे तुझी खात्री होईल की, सर्व पृथ्वीवर माझ्यासारखा इतर कोणी नाही. ");
INSERT INTO marc_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","वास्तविक मी आतापर्यंत माझा हात लांब करून तुला व तुझ्या लोकांना अशा पीडेने मारून या पृथ्वीतून तुम्हाला नष्ट केले असते. ");
INSERT INTO marc_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","परंतु मी तुला याच एका उद्देशाने राखून ठेवले की, मी तुला माझे सामर्थ्य दाखवावे आणि माझे नाव अखिल पृथ्वीवर जाहीर व्हावे. ");
INSERT INTO marc_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","तू अजूनही माझ्या लोकांच्या विरोधात राहून त्यांना जाऊ देत नाहीस. ");
INSERT INTO marc_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","म्हणून उद्या याच वेळेला, इजिप्तची स्थापना झाली तेव्हापासून कधी झाला नाही अशा भयानक गारांचा वर्षाव मी करेन. ");
INSERT INTO marc_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","म्हणून आपआपली जनावरे आणि तुमचे जे काही रानात आहे ते आत आश्रयास आणायला सांग, कारण जे मनुष्य व जनावरे आत आली नाहीत, त्या सर्वांवर गारा पडतील व ते मरतील.” ");
INSERT INTO marc_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","फारोहच्या ज्या अधिकार्‍यांना याहवेहच्या शब्दाचे भय वाटले, त्यांनी आपले चाकर व गुरे लगबगीने आत आणली. ");
INSERT INTO marc_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","पण ज्यांनी याहवेहच्या शब्दाकडे दुर्लक्ष केले, त्यांनी आपले दास व पशू यांना रानातच सोडले. ");
INSERT INTO marc_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","मग याहवेहने मोशेला सांगितले, “तू आपला हात आकाशाकडे उंच कर म्हणजे संपूर्ण इजिप्त देशावर—मनुष्य, जनावरे व शेतात जे काही आहे त्यावर—गारा पडतील.” ");
INSERT INTO marc_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","जेव्हा मोशेने आपली काठी आकाशाकडे लांब केली, तेव्हा याहवेहने ढगांच्या गडगडाटांसह गारा पाठविल्या व विजा भूमीवर पडल्या. अशाप्रकारे याहवेहने इजिप्तवर गारांची वृष्टी केली. ");
INSERT INTO marc_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","गारा पडून चहूकडे विजा लखलखत होत्या, इजिप्त देशाची स्थापना झाली तेव्हापासून कधी झाले नाही असे भयंकर वादळ उठले. ");
INSERT INTO marc_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","गारांनी इजिप्त देशाच्या शेतातील सर्वकाही; मनुष्य असो वा जनावरे यांचा नाश केला; शेतात पिकत असलेले पीक व रानातील प्रत्येक झाड नाहीसे केले. ");
INSERT INTO marc_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","फक्त एकच असे ठिकाण होते जिथे गारा पडल्या नाही; तो गोशेन प्रांत, ज्या ठिकाणी इस्राएली लोक राहत होते. ");
INSERT INTO marc_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","मग फारोहने मोशे व अहरोन यांना बोलावून घेतले, व तो त्यांना म्हणाला, “यावेळी मी पाप केले आहे, याहवेह न्यायी आहेत, परंतु मी व माझे लोक चुकलो. ");
INSERT INTO marc_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","याहवेहला विनंती करा, कारण मेघांचा हा गडगडाट व गारा आता असह्य झाले आहे. मी तुम्हाला जाऊ देईन व तुम्हाला इथे राहण्याची गरज नाही.” ");
INSERT INTO marc_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मोशे म्हणाला, “शहराबाहेर जाताच प्रार्थनेत याहवेहकडे मी माझे हात पसरेन. मग गडगडाट थांबेल व गारांचा वर्षावही होणार नाही. यावरून तुला कळेल की, पृथ्वी याहवेहची आहे. ");
INSERT INTO marc_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","पण मला माहीत आहे की, तू व तुझे सेवक अजूनही याहवेह परमेश्वराचे भय बाळगत नाहीत.” ");
INSERT INTO marc_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(आता जवस व सातू या पिकांचा पूर्णपणे नाश झाला होता, कारण सातू कापणीला आला होता व जवसाला फुले आली होती. ");
INSERT INTO marc_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","पण गहू व खपल्याचा गहू यांचा नाश झाला नाही, कारण ते अजून पिकले नव्हते.) ");
INSERT INTO marc_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","मग मोशे फारोहपासून निघून शहराबाहेर गेला व त्याने आपले हात याहवेहकडे पसरले; मेघगर्जना व गारांचा वर्षाव थांबला व संपूर्ण देशावर पडणारा पाऊस बंद झाला. ");
INSERT INTO marc_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","पण फारोहने जेव्हा पाहिले की मेघगर्जना, गारा व पाऊस हे थांबले आहे, त्याने पुन्हा पाप केले: त्याने व त्याच्या सरदारांनी आपले हृदय कठीण केले. ");
INSERT INTO marc_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","याहवेहने मोशेला सांगितल्याप्रमाणे फारोहने इस्राएली लोकांना जाऊ देण्याचे नाकारले, कारण त्याचे हृदय कठीण झाले होते. ");
INSERT INTO marc_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","मग याहवेह मोशेला म्हणाले, “फारोहकडे जा, कारण मी त्याचे व त्याच्या अधिकार्‍यांची मने कठीण केली आहेत, अशासाठी की मी त्यांच्यामध्ये माझे चमत्कार करावे ");
INSERT INTO marc_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","व तुम्हीही आपल्या लेकरांस व नातवंडास मी इजिप्तच्या लोकांशी कसे कठोरपणे वागलो व त्यांच्यामध्ये माझे चमत्कार कसे केले ते सांगावे आणि तुम्हाला समजावे की मी याहवेह आहे.” ");
INSERT INTO marc_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","मग मोशे व अहरोन फारोहकडे गेले व त्याला म्हणाले, “इब्री लोकांचे परमेश्वर याहवेह असे म्हणतात, ‘अजून किती काळ माझ्यासमोर नम्र होण्यास तू नाकारशील? माझ्या लोकांना जाऊ दे, म्हणजे ते माझी उपासना करतील. ");
INSERT INTO marc_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","तू जर त्यांना जाऊ दिले नाहीस, तर उद्या मी तुझ्या संपूर्ण देशावर टोळ आणेन. ");
INSERT INTO marc_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ते तुझी भूमी आच्छादून टाकतील की, जमीन मुळीच दिसणार नाही, शेतात असलेल्या झाडांसह, गारांच्या व पावसाच्या मारातून जे पीक वाचले आहे त्याचा ते नाश करतील, एवढेच नव्हे तर वनात वाढणारी झाडेही ते खाऊन टाकतील. ");
INSERT INTO marc_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ते तुझी घरे व तुझ्या अधिकार्‍यांची व सर्व इजिप्तच्या लोकांची घरे भरून टाकतील; इजिप्तच्या इतिहासात तुझे वडील व तुझे पूर्वज या देशाचे रहिवासी झाले तेव्हापासून आजपर्यंत असे झालेले त्यांनी कधी पाहिले नाही.’ ” मग मोशे वळून फारोहपासून निघून गेला. ");
INSERT INTO marc_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फारोहचे अधिकारी त्याला म्हणाले, “किती काळ हा मनुष्य आम्हाला पाश म्हणून असणार? याहवेह त्यांचा परमेश्वर यांची उपासना करावी म्हणून या लोकांना जाऊ द्या. इजिप्तचा नाश झाला आहे याची तुम्हाला जाणीव नाही काय?” ");
INSERT INTO marc_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","मग मोशे व अहरोन यांना फारोहकडे पुन्हा बोलाविण्यात आले. फारोह त्यांना म्हणाला, “याहवेह तुमचा परमेश्वर याची उपासना करावी म्हणून तुम्ही जा, पण कोण कोण जाणार हे मला सांग.” ");
INSERT INTO marc_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मोशेने उत्तर दिले “आम्ही आमचे तरुण व वृद्ध, आमचे पुत्र व कन्या आणि आमची शेरडेमेंढरे व गुरे या सर्वांसह जाणार. कारण आम्ही सर्वांनीच याहवेहचा सण साजरा करणे आवश्यक आहे.” ");
INSERT INTO marc_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","तेव्हा फारोह त्यांना म्हणाला, “मी तुमच्या मुलाबाळांस व स्त्रियांना जाऊ दिले तर याहवेह तुम्हाबरोबर असो! खचितच तुम्ही दुष्टता योजली आहे. ");
INSERT INTO marc_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","नाही! याहवेहची उपासना करण्यासाठी फक्त पुरुषांनीच जावे, कारण तशीच मागणी तुम्ही करत होता.” मग मोशे व अहरोनास फारोहच्या पुढून हाकलून देण्यात आले. ");
INSERT INTO marc_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","मग याहवेह मोशेला म्हणाले, “तू आपला हात इजिप्त देशावर लांब कर म्हणजे टोळधाड येईल व गारांच्या वर्षावातून वाचलेली वनस्पती जी भूमीवर वाढत आहे त्या सर्वांचा ती नाश करेल.” ");
INSERT INTO marc_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","तेव्हा मोशेने आपली काठी इजिप्त देशावर उगारली, आणि याहवेहने तो संपूर्ण दिवस व ती संपूर्ण रात्र पूर्वेचा वारा देशावर वाहविला. सकाळपर्यंत वार्‍याने टोळ आणले. ");
INSERT INTO marc_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","त्यांनी संपूर्ण इजिप्त देश व्यापून टाकला व ते मोठ्या संख्येने देशाच्या प्रत्येक भागात जाऊन राहिले. इतिहासात अशी भयंकर टोळांची पीडा ना कधी आली होती ना पुढे कधी येणार. ");
INSERT INTO marc_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","कारण टोळांनी जमिनीचा पृष्ठभाग अगदी काळा होईपर्यंत झाकून टाकला व गारातून जे वाचले होते ते सर्वकाही—शेतातील सर्व पीक व झाडावरील प्रत्येक फळ त्यांनी फस्त केले. संपूर्ण इजिप्त देशात ना झाडे ना वनस्पती, काहीही हिरवे असे राहिले नाही. ");
INSERT INTO marc_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","मग फारोहने मोशे व अहरोन यांना त्वरेने बोलावून घेतले आणि म्हटले, “मी तुमच्या याहवेह परमेश्वराविरुद्ध व तुमच्याविरुद्ध पाप केले आहे. ");
INSERT INTO marc_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","परत एकदा माझ्या पापाची मला क्षमा करा आणि तुमच्या याहवेह परमेश्वराने ही पीडा माझ्यापासून दूर करावी म्हणून त्यांच्याकडे विनंती करा.” ");
INSERT INTO marc_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","मग मोशे फारोह पुढून निघून गेला व त्याने याहवेहकडे प्रार्थना केली; ");
INSERT INTO marc_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","आणि याहवेहने पश्चिमेच्या दिशेने वार्‍याची दिशा बदलली व त्या वार्‍याने टोळांना एकवटून तांबड्या समुद्रात टाकले. इजिप्तमध्ये एकही टोळ शिल्लक राहिला नाही. ");
INSERT INTO marc_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","पण याहवेहने फारोहचे हृदय कठीण केले व त्याने इस्राएली लोकांना जाऊ दिले नाही. ");
INSERT INTO marc_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","नंतर याहवेहने मोशेला म्हटले, “तू आपला हात वर आकाशाकडे लांब कर, म्हणजे इजिप्त देशावर अंधार पडेल—इतका अंधार की त्याला लोक चाचपडतील.” ");
INSERT INTO marc_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","तेव्हा मोशेने आपला हात आकाशाकडे लांब केला, आणि तीन दिवसांसाठी निबिड अंधकाराने संपूर्ण इजिप्त देश व्यापून टाकला. ");
INSERT INTO marc_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","कोणी कोणाला पाहू शकत नव्हते व तीन दिवस कोणी आपल्या ठिकाणाहून हलला नाही, परंतु जिथे इस्राएली लोक राहत होते तिथे मात्र प्रकाश होता. ");
INSERT INTO marc_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","तेव्हा फारोहने मोशेला बोलावून घेतले. तो म्हणाला, “जा, आणि याहवेहची उपासना करा. तुमच्या स्त्रिया व लेकरे सुद्धा तुमच्याबरोबर जाऊ शकतात; तुमची जनावरे व शेरडेमेंढरे मात्र सोडून जा.” ");
INSERT INTO marc_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","परंतु मोशे म्हणाला, “याहवेह, आमचा परमेश्वर यास आम्ही यज्ञ व होमबली अर्पण करावे म्हणून जाऊ दे. ");
INSERT INTO marc_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","आमची जनावरे सुद्धा आमच्याबरोबर गेली पाहिजेत; एक खूर देखील आम्ही मागे ठेवणार नाही. आम्हाला त्यांच्यापैकी काहींचा याहवेह आमचे परमेश्वर यांची उपासना करण्यास वापर करावयाचा आहे, आणि त्यात आम्ही काय वापरावे हे आम्ही त्या ठिकाणी पोहोचेपर्यंत आम्हाला समजणार नाही.” ");
INSERT INTO marc_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","पण याहवेहने फारोहचे हृदय कठीण केले, व तो त्यांना जाऊ देण्यास मान्यता देईना. ");
INSERT INTO marc_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","फारोह मोशेला म्हणाला, “माझ्यासमोरून चालता हो! आपले तोंडसुध्दा मला पुन्हा दाखवू नकोस! ज्या दिवशी तू माझे तोंड पाहशील त्या दिवशी तू मरशील.” ");
INSERT INTO marc_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","“तू म्हणालास तसेच होईल,” मोशे म्हणाला. “मी पुन्हा तुझ्यासमोर उभा राहणार नाही.” ");
INSERT INTO marc_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","मग याहवेह मोशेला म्हणाले, “मी फारोह व इजिप्तवर आणखी एक पीडा आणेन. त्यानंतर तो तुम्हाला या ठिकाणाहून जाऊ देईल आणि जेव्हा तो हे करेल तेव्हा तो तुम्हाला अक्षरशः देशातून घालवून देईल. ");
INSERT INTO marc_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","सर्व इस्राएली लोकांना सांग, की स्त्री व पुरुषांनी आपआपल्या शेजार्‍यांकडून चांदीचे व सोन्याचे दागिने मागून घ्यावेत.” ");
INSERT INTO marc_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(आता याहवेहने इजिप्तमधील लोकांची मने इस्राएलांना अनुकूल होतील असे केले, मोशे स्वतः इजिप्तमध्ये फारोहच्या सेवकांच्या व इजिप्तच्या लोकांच्या दृष्टीत फार थोर झाला होता.) ");
INSERT INTO marc_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मग मोशे म्हणाला, “याहवेह असे म्हणतात: ‘मध्यरात्रीच्या सुमारास मी इजिप्तमधून फिरेन. ");
INSERT INTO marc_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","इजिप्त देशातील प्रत्येक प्रथम जन्मलेला पुत्र मरण पावेल, फारोह जो राजासनावर बसतो त्याच्या प्रथम पुत्रापासून त्याच्या जात्यावर दळत बसणार्‍या गुलाम स्त्रीच्या प्रथम पुत्रापर्यंत आणि जनावरातील प्रथम जन्मलेले प्रत्येक वत्स मरेल. ");
INSERT INTO marc_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","संपूर्ण इजिप्त देशभर पूर्वी कधी झाला नाही व पुढे कधी होणार नाही असा आकांत होईल. ");
INSERT INTO marc_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","परंतु इस्राएली व्यक्तीवर किंवा पशूंवर कुत्रेदेखील भुंकणार नाही.’ यावरून मी याहवेह इजिप्त व इस्राएल यांच्यामध्ये कसा भेद करतो, हे तुम्हाला समजेल. ");
INSERT INTO marc_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","तुझे हे सर्व सेवक माझ्याकडे येतील व माझ्या पाया पडून मला म्हणतील, ‘तू व तुझे अनुसरण करणारे सर्व लोक निघून जा!’ त्यानंतर मी निघून जाईन.” मग मोशे रागाने संतापून फारोहसमोरून निघून गेला. ");
INSERT INTO marc_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","याहवेहने मोशेला आधीच सांगितले होते, “इजिप्त देशात मी पुष्कळ चमत्कार करावे म्हणून फारोह तुमचे ऐकण्यास नाकारेल.” ");
INSERT INTO marc_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मोशे व अहरोन यांनी फारोहसमक्ष हे सर्व चमत्कार केले, पण याहवेहने फारोहचे हृदय कठीण केले व त्याने इस्राएली लोकांना देशाबाहेर जाण्यास परवानगी दिली नाही. ");
INSERT INTO marc_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","मग इजिप्तमध्ये याहवेह मोशे व अहरोन यांच्याशी बोलले, ");
INSERT INTO marc_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“हा महिना तुमच्यासाठी पहिला महिना, वर्षाचा पहिला महिना असेल. ");
INSERT INTO marc_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","तू इस्राएलाच्या सर्व समुदायाला जाहीर कर की, या महिन्याच्या दहाव्या दिवशी, प्रत्येकाने आपल्या कुटुंबासाठी एक कोकरू घ्यावे, प्रत्येक घराण्यासाठी एक कोकरू. ");
INSERT INTO marc_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","जर एखादे कुटुंब एका कोकराच्या मानाने लहान असले तर शेजारच्या कुटुंबाबरोबर, त्यांच्यातील लोकांची संख्या लक्षात घेऊन प्रत्येक व्यक्ती किती खाईल यानुसार अंदाज घेऊन, किती कोकरे लागतील हे ठरवावे. ");
INSERT INTO marc_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","एक वर्षाचे निर्दोष नर कोकरू असावे, आणि तुम्ही ते मेंढरांतून अथवा शेळ्यांतून घ्यावे. ");
INSERT INTO marc_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","या महिन्याच्या चौदाव्या दिवसापर्यंत त्यांची काळजी घ्यावी आणि इस्राएली लोकातील सर्वांनी सायंकाळी ते कापावेत. ");
INSERT INTO marc_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ज्या घरांमध्ये ते खातील त्या घराच्या दोन्ही दारपट्ट्यांना व कपाळपट्टीला त्या कोकराचे रक्त घेऊन ते लावावे. ");
INSERT INTO marc_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","त्या रात्री प्रत्येकाने त्या कोकर्‍याचे विस्तवावर भाजलेले मांस, बेखमीर भाकर व कडू भाजी यांच्याबरोबर खावे. ");
INSERT INTO marc_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","मांस कच्चे किंवा पाण्यात उकळून खाऊ नये, तर विस्तवावर भाजून, त्याचे डोके, पाय व आतड्यांसह खावे. ");
INSERT INTO marc_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","त्यातील काहीही सकाळपर्यंत राहू देऊ नये; जर काही सकाळपर्यंत उरले तर ते जाळून टाकावे. ");
INSERT INTO marc_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","तुम्ही ते असे खावे: तुमच्या कंबरा बांधलेल्या, तुमची पायतणे पायात घातलेली व हातात काठी घेऊन ते घाईघाईने खावे. हा याहवेहचा वल्हांडण आहे. ");
INSERT INTO marc_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“कारण त्याच रात्री मी संपूर्ण इजिप्त देशामधून संचार करेन व सर्व मनुष्यांचे व जनावरांचे प्रथमवत्स मारून टाकेन आणि त्यांच्या सर्व दैवतांवर न्याय आणेन; मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","तुम्ही राहत असलेल्या घरांच्या दारांवर असलेले रक्त हे तुमच्याकरिता चिन्ह असेल, जेव्हा मी ते रक्त पाहीन, तेव्हा मी तुम्हाला ओलांडून पुढे जाईन. जेव्हा मी इजिप्तला तडाखा देईन, तेव्हा कोणतीही विनाशी पीडा तुम्हाला स्पर्श करणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“हा दिवस तुम्ही याहवेहचा सण म्हणून पिढ्यान् पिढ्यांपर्यंत सर्वकाळच्या नियमाने पाळावा. ");
INSERT INTO marc_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","सात दिवस तुम्ही खमीर नसलेली भाकर खावी. पहिल्या दिवशी आपल्या घरातून खमीर काढून टाकावे, कारण जे कोणी या सात दिवसात खमीर घातलेल्या वस्तू खाईल, त्याला इस्राएलातून बेदखल करण्यात यावे. ");
INSERT INTO marc_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","पहिल्या दिवशी एक पवित्र सभा भरवावी आणि सातव्या दिवशी दुसरी सभा. या दिवसात प्रत्येकाने खाण्यासाठी अन्न तयार करण्याशिवाय इतर कोणतेही काम करू नये. ");
INSERT INTO marc_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“बेखमीर भाकरीचा सण पाळावा, कारण याच दिवशी मी तुमच्या सैन्यांना इजिप्तमधून बाहेर आणले. पिढ्यान् पिढ्यांपर्यंत सर्वकाळच्या नियमाने तो पाळावा. ");
INSERT INTO marc_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पहिल्या महिन्यात चौदाव्या दिवसाच्या संध्याकाळपासून एकविसाव्या दिवसाच्या संध्याकाळपर्यंत तुम्ही खमीर नसलेली भाकर खावी. ");
INSERT INTO marc_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","या सात दिवसात तुमच्या घरात खमीर सापडू नये. आणि कोणीही, तो परदेशी असो वा देशात जन्मलेला असो, जो खमीर घातलेले पदार्थ खाईल तर त्याला इस्राएलाच्या समाजातून वाळीत टाकले जावे. ");
INSERT INTO marc_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","खमीर घातलेले काहीही खाऊ नये. तुम्ही कुठेही राहत असला तरी तुम्ही बेखमीर भाकरीच खावी.” ");
INSERT INTO marc_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","मग मोशेने इस्राएलातील वडीलजनांना बोलाविले व म्हटले, “तुम्ही लगेच जा व आपआपल्या कुटुंबाप्रमाणे कोकरू निवडून घ्या व वल्हांडणाच्या कोकराचा वध करा. ");
INSERT INTO marc_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","एजोबाची जुडी घेऊन ती पात्रात घेतलेल्या रक्तात बुडवा व त्याने ते रक्त घराच्या दरवाजाच्या बाजूंवर व कपाळपट्टीवर लावा. तुम्हापैकी कोणीही सकाळ होईपर्यंत आपल्या घराबाहेर पडू नये. ");
INSERT INTO marc_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","कारण याहवेह या देशात संचार करतील व इजिप्तवासियांचा संहार करतील. पण ज्या दरवाजाच्या बाजूंवर व कपाळपट्टीवर रक्त दिसेल, याहवेह त्या घराला ओलांडून पुढे जातील व विनाशकाला तुम्हाला मारण्यास तुमच्या घरात येऊ देणार नाहीत. ");
INSERT INTO marc_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“तुमच्यासाठी व तुमच्या वंशजांसाठी हा सर्वकाळचा नियम असावा. ");
INSERT INTO marc_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","वचन दिल्याप्रमाणे जो देश याहवेह तुम्हाला देणार आहेत, त्या देशात तुम्ही जाल, तिथेही हा विधी पाळावा. ");
INSERT INTO marc_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","जेव्हा तुमची लेकरे तुम्हाला विचारतील, ‘या विधीचा अर्थ काय आहे?’ ");
INSERT INTO marc_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तेव्हा त्यांना सांगा, ‘हा याहवेहसाठी वल्हांडणाचा यज्ञ आहे, ज्यांनी इजिप्तच्या लोकांचा संहार करून त्यांचा नाश केला, आणि इस्राएली लोकांची घरे ओलांडून गेले आणि आम्हाला वाचविले.’ ” तेव्हा लोकांनी आपली मस्तके नमवून त्यांना नमन केले व त्यांची आराधना केली. ");
INSERT INTO marc_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","मग याहवेहने मोशे व अहरोन यांना आज्ञा दिल्याप्रमाणे इस्राएली लोकांनी केले. ");
INSERT INTO marc_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","मध्यरात्रीत याहवेहने इजिप्त देशातील प्रथम जन्मलेले सर्व मारून टाकले. सिंहासनावर बसणार्‍या फारोहच्या प्रथम पुत्रापासून तुरुंगात असलेल्या कैद्याच्या प्रथम जन्मलेल्या पुत्रापर्यंत, जनावरांचे प्रथम जन्मलेले वत्स देखील मारून टाकले. ");
INSERT INTO marc_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","तेव्हा फारोह, त्याचे अधिकारी व सर्व इजिप्तचे लोक रात्री जागे झाले आणि इजिप्तमध्ये मोठा आकांत झाला, कारण ज्या घरात मृत्यू झाला नाही, असे एकही घर नव्हते. ");
INSERT INTO marc_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","तेव्हा फारोहने मोशे व अहरोन यांना रात्री बोलावून म्हटले, “उठा! तुम्ही व इस्राएली लोक माझ्या लोकांना सोडून जा! जा, आणि तुम्ही मागितल्याप्रमाणे याहवेहची उपासना करा. ");
INSERT INTO marc_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","तुमची शेरडेमेंढरे आणि गुरे घ्या आणि निघून जा आणि मलाही आशीर्वाद द्या.” ");
INSERT INTO marc_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","इस्राएली लोक देशाबाहेर त्वरेने जावे म्हणून इजिप्तच्या लोकांनी त्यांना विनंती केली. कारण ते म्हणाले, “नाहीतर आम्ही सर्व मरून जाऊ!” ");
INSERT INTO marc_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","मग इस्राएली लोकांनी खमीर घालण्यापूर्वी कणीक परातीसह कापडात बांधून खांद्यावर टाकली. ");
INSERT INTO marc_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","मोशेने सांगितल्याप्रमाणे इस्राएल लोकांनी इजिप्तच्या लोकांकडून चांदीचे व सोन्याचे दागिने व कपडे मागून घेतले. ");
INSERT INTO marc_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","इजिप्तचे लोक इस्राएली लोकांवर कृपादृष्टी करतील असे याहवेहने केले आणि जे काही त्यांनी मागितले ते सर्व त्यांनी त्यांना दिले; अशाप्रकारे त्यांनी इजिप्तच्या लोकांना लुटले. ");
INSERT INTO marc_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","इस्राएल लोकांनी रामसेस पासून ते सुक्कोथ पर्यंत प्रवास केला. स्त्रिया व लेकरे या खेरीज सुमारे सहा लाख पुरुष पायी चालणारे होते. ");
INSERT INTO marc_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","इतर पुष्कळ लोकसुद्धा त्यांच्याबरोबर निघाले होते, त्याचप्रमाणे शेरडेमेंढरांचे कळप व जनावरेही होती. ");
INSERT INTO marc_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","जी कणीक इस्राएल लोकांनी इजिप्तमधून बरोबर आणली होती, त्याच्या त्यांनी भाकरी भाजल्या. ते कणीक बेखमीर होते, कारण जेव्हा त्यांना इजिप्तमधून घालवून दिले, स्वतःसाठी अन्न तयार करावयाला वेळ नव्हता. ");
INSERT INTO marc_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्राएली लोक इजिप्तमध्ये राहिले तो कालावधी चारशेतीस वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","चारशेतिसाव्या वर्षाच्या शेवटच्या दिवशी याहवेहच्या सैन्यांनी इजिप्त देश सोडला. ");
INSERT INTO marc_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ही रात्र याहवेहने इस्राएली लोकांना इजिप्त देशातून बाहेर आणण्यासाठी वेगळी करून ठेवली, ही रात्र इस्राएल लोकांनी पिढ्यान् पिढ्या याहवेहला सन्मान म्हणून पाळावी. ");
INSERT INTO marc_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","नंतर याहवेह मोशे व अहरोन यांना म्हणाले, “वल्हांडणाच्या भोजनाचे हे नियम आहेत: “कोणत्याही विदेशी व्यक्तीने ते खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","पण तू मोल देऊन विकत घेतलेला गुलाम व ज्याची सुंता तू करून घेतली आहे त्याने ते खावे. ");
INSERT INTO marc_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","पण तात्पुरता रहिवासी किंवा मोलकरी यांनी ते खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ते घरातच खावयाचे आहे; त्यातील मांस घराबाहेर घेऊन जाऊ नये. त्यातील एकही हाड मोडू नये. ");
INSERT INTO marc_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","इस्राएलाच्या सर्व समुदायाने हा सण पाळावा. ");
INSERT INTO marc_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“तुमच्याबरोबर राहणार्‍या विदेशी व्यक्तीला याहवेहचा हा वल्हांडणाचा सण पाळावयाचा असेल, तर त्यांच्यातील सर्व पुरुषांनी सुंता करवून घ्यावी; मगच ते या देशात जन्मलेल्याप्रमाणे हा सण पाळू शकतील. कोणत्याही बेसुंती पुरुषाने ते खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","तुमच्यामध्ये असलेले स्वदेशी असो वा तुमच्यामध्ये असलेले विदेशी असो, दोघांनाही एकच नियम असावा.” ");
INSERT INTO marc_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","तेव्हा याहवेहने मोशे व अहरोन यांना सूचना दिल्याप्रमाणे इस्राएली लोकांनी केले. ");
INSERT INTO marc_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","याच दिवशी याहवेहने वंशानुसार इस्राएली लोकांना इजिप्त देशातून बाहेर आणले. ");
INSERT INTO marc_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","याहवेहने मोशेला सांगितले, ");
INSERT INTO marc_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“इस्राएली लोकांचे प्रथम जन्मलेले प्रत्येक नर मला समर्पित कर. उदरातून आलेले इस्राएलातील प्रत्येक प्रथम संतान माझ्या मालकीचे आहे, ते मनुष्याचे असो किंवा पशूंचे.” ");
INSERT INTO marc_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","तेव्हा मोशे लोकांना म्हणाला, हा दिवस स्मरणात ठेवा, याच दिवशी याहवेहने आपल्या पराक्रमी हाताने इजिप्त देशातून, गुलामगिरीतून तुम्हाला बाहेर आणले. खमीर असलेले तुम्ही काहीही खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आज, अवीव महिन्यात तुम्ही निघालात. ");
INSERT INTO marc_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","जेव्हा तुम्हाला कनानी, हिथी, अमोरी, यबूसी आणि हिव्वी यांचा देश, ज्यात दूध व मध वाहतो, ते तुम्हाला देतील अशी तुमच्या पूर्वजांशी शपथ वाहिली, त्यात याहवेह तुम्हाला नेतील; तेव्हा या महिन्यात हा विधी तुम्ही पाळावा. ");
INSERT INTO marc_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिवस तुम्ही बेखमीर भाकर खावी आणि सातव्या दिवशी याहवेहचा उत्सव साजरा करावा. ");
INSERT INTO marc_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","या सात दिवसात बेखमीर भाकर खावी; खमीर असलेले काहीही तुमच्यात आढळू नये किंवा तुमच्या सीमेत कुठेही खमीर दृष्टीस पडू नये. ");
INSERT INTO marc_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","त्या दिवशी आपल्या लेकरांना सांगा, जेव्हा आम्ही इजिप्तमधून बाहेर आलो तेव्हा याहवेहने आमच्यासाठी जे केले, त्याचे चिन्ह म्हणून आम्ही हे करतो. ");
INSERT INTO marc_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","हे तुम्हाला तुमच्या हातावरील खूण व कपाळावर स्मरणचिन्हासारखे असणार. याहवेहचा हा नियम तुमच्या मुखात असावा. कारण याहवेहने आपल्या पराक्रमी हाताने तुम्हाला इजिप्त देशातून बाहेर आणले. ");
INSERT INTO marc_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","दरवर्षी हा सण तुम्ही ठराविक वेळी पाळावा. ");
INSERT INTO marc_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“तुम्हाला व तुमच्या पूर्वजांना दिलेल्या शपथेनुसार याहवेह तुम्हाला कनानी लोकांच्या देशात घेऊन जातील व तो देश तुम्हाला देतील, ");
INSERT INTO marc_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तेव्हा प्रत्येक उदराचे पहिले संतान तुम्ही याहवेहला द्यावे. तुमच्या पशूंचे प्रथम जन्मलेले नर याहवेहचे आहेत. ");
INSERT INTO marc_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","गाढवाच्या प्रथम जन्मलेल्या शिंगरूला कोकरू खंडणी म्हणून भरून सोडव, पण खंडणी भरून ते तू सोडविले नाहीस, तर त्याची मान मोड. मनुष्याच्या प्रत्येक नराला खंडणी भरून सोडव. ");
INSERT INTO marc_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“भविष्यकाळात तुमची मुले तुम्हाला विचारतील, ‘याचा अर्थ काय आहे?’ तेव्हा त्यांना सांगा, ‘याहवेहने आपल्या पराक्रमी हाताने आम्हाला इजिप्तमधून, त्यांच्या गुलामगिरीतून बाहेर आणले. ");
INSERT INTO marc_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","जेव्हा फारोह हट्टाने आम्हाला जाऊ देत नव्हता, तेव्हा याहवेहने संपूर्ण इजिप्त देशातील लोकांचे व जनावरांचे प्रथम जन्मलेले मारून टाकले. म्हणून प्रत्येक उदरातून प्रथम जन्मलेला नर आम्ही याहवेहला समर्पित करतो आणि ते आम्ही खंडणी भरून सोडवितो.’ ");
INSERT INTO marc_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","आणि हे तुमच्या हातावर खूण व कपाळावर चिन्ह असे असावे, की याहवेहने आपल्या बलवान हाताने आम्हाला इजिप्त देशातून बाहेर आणले.” ");
INSERT INTO marc_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","शेवटी फारोहने जेव्हा लोकांस जाऊ दिले, तेव्हा परमेश्वराने त्यांना पलिष्ट्यांच्या देशातून जवळचा मार्ग असूनही तिथून चालविले नाही. कारण परमेश्वर म्हणाले, “जर युद्धाला सामोरे जावे लागले तर त्यांचे मन बदलेल व ते पुन्हा इजिप्तकडे जातील.” ");
INSERT INTO marc_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","म्हणून परमेश्वराने त्यांना तांबड्या समुद्राकडून रानाच्या मार्गाने नेले. इस्राएली लोक लढाईसाठी सज्ज होऊन इजिप्तमधून बाहेर पडले. ");
INSERT INTO marc_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मोशेने योसेफाची हाडे आपल्याबरोबर घेतली. कारण, योसेफाने इस्राएली लोकांकडून शपथ घेतली होती. तो म्हणाला होता, “परमेश्वर खरोखर तुमच्या मदतीला येईल, तेव्हा तुमच्याबरोबर माझी हाडे या ठिकाणातून घेऊन जा.” ");
INSERT INTO marc_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","सुक्कोथ शहर सोडल्यावर त्यांनी वाळवंटाच्या सीमेवर एथाम येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","दिवस व रात्र ते प्रवास करू शकतील, म्हणून दिवसा मेघस्तंभातून त्यांचे मार्गदर्शन करीत व रात्री अग्निस्तंभातून प्रकाश देत याहवेह त्यांच्या पुढे चालले. ");
INSERT INTO marc_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","दिवसाचा मेघस्तंभ व रात्रीचा अग्निस्तंभ यांनी लोकांसमोरून आपले स्थान सोडले नाही. ");
INSERT INTO marc_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएली लोकांस सांग मागे फिरा आणि पी-हाहीरोथ जवळ, मिग्दोल व समुद्र यांच्यामध्ये, समुद्राजवळ तळ द्या, जो थेट बआल-सफोनासमोर आहे. ");
INSERT INTO marc_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","यामुळे फारोहला वाटेल की, इस्राएली लोक देशाभोवती गोंधळून भटकत आहेत, वाळवंटात अडकले आहेत. ");
INSERT INTO marc_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","मी फारोहचे मन कठीण करेन, म्हणजे तो त्यांचा पाठलाग करेल. पण फारोह व त्याच्या सैन्याकडून मी माझे गौरव करून घेईन आणि इजिप्तच्या प्रजेला समजेल की, मी याहवेह आहे.” मग इस्राएली लोकांनी तसे केले. ");
INSERT INTO marc_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","जेव्हा इजिप्तच्या राजाला सांगितले गेले की ते लोक पळून गेले, फारोहने व त्याच्या अधिकार्‍यांनी त्यांच्याविषयी आपले मन बदलले व ते म्हणाले, “आपण हे काय केले? आपण इस्राएली लोकांना जाऊ दिले व त्यांची सेवा गमावली!” ");
INSERT INTO marc_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","मग त्याने ताबडतोब आपला रथ जोडून आपले सैन्य सोबत घेतले. ");
INSERT INTO marc_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","सहाशे सर्वात उत्तम असे रथ व त्याबरोबर इजिप्तचे बाकी सर्व रथ व त्यावरील अधिकारी त्याने घेतले. ");
INSERT INTO marc_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","याहवेहने इजिप्तचा राजा फारोह याचे हृदय कठीण केले म्हणून इस्राएली लोक जे मोठ्या धैर्याने इजिप्तमधून जात होते, त्यांचा त्याने पाठलाग केला. ");
INSERT INTO marc_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","इजिप्तच्या लोकांनी—फारोहचे सर्व घोडे व रथ, घोडेस्वार व सैन्य यांच्यासह—इस्राएली लोकांचा पाठलाग केला आणि बआल-सफोनासमोर असलेल्या पी-हाहीरोथ, जिथे ते तळ देऊन होते तिथे त्यांना गाठले. ");
INSERT INTO marc_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","फारोह जसा जवळ आला, इस्राएली लोकांनी पाहिले की इजिप्तचे सैन्य त्यांच्यावर चालून येत आहे. ते फार घाबरले व मोठ्याने याहवेहकडे आरोळी मारली. ");
INSERT INTO marc_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ते मोशेला म्हणाले, “इजिप्त देशात कबरा नव्हत्या म्हणून तू आम्हाला या रानात मरायला आणले काय? इजिप्तमधून आम्हास बाहेर आणून तू हे काय केले? ");
INSERT INTO marc_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","आम्हाला असेच राहू दे; आम्हाला इजिप्त लोकांची सेवा करू दे, असे आम्ही तुला इजिप्तमध्ये असताना म्हणालो नव्हतो काय? या रानात मरण्याऐवजी इजिप्त लोकांची गुलामी करणे आम्हाला बरे होते!” ");
INSERT INTO marc_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मोशे लोकांना म्हणाला, “घाबरू नका. स्तब्ध राहा व आज याहवेह तुम्हाला अद्भुतरित्या कसे सोडविणार आहे ते पाहा. हे इजिप्तचे लोक जे तुम्हाला आज दिसतात ते पुन्हा दिसणार नाहीत. ");
INSERT INTO marc_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","याहवेह तुमच्यासाठी लढतील; तुम्ही केवळ स्तब्ध राहा.” ");
INSERT INTO marc_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","मग याहवेह मोशेला म्हणाले, “माझ्याकडे का रडतोस? इस्राएली लोकांना पुढे जायला सांग. ");
INSERT INTO marc_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","समुद्रातील पाणी दुभागावे म्हणून तुझ्या हातातील काठी समुद्रावर उगार म्हणजे इस्राएली लोक समुद्रामधून कोरड्या जमिनीवरून जातील. ");
INSERT INTO marc_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","मी इजिप्तच्या लोकांची मने कठीण करेन आणि ते त्यांच्यामागे समुद्राच्या आत येतील. मग फारोह, त्याचे सर्व सैनिक, रथ व घोडेस्वार यांच्याकडून मी माझे गौरव करून घेईन. ");
INSERT INTO marc_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","आणि जेव्हा फारोह, त्याचे रथ व त्याचे घोडेस्वार यांच्याकडून मला गौरव मिळेल, तेव्हा इजिप्तचे लोक जाणतील की मी याहवेह आहे.” ");
INSERT INTO marc_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","मग परमेश्वराचा दूत, जो इस्राएलांपुढे प्रवास करीत होता, तो आता त्यांच्या मागच्या बाजूला गेला. मेघस्तंभ देखील त्यांच्यापुढून निघून त्यांच्यामागे गेला, ");
INSERT INTO marc_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","आणि इजिप्तचे सैन्य व इस्राएली लोक यांच्यामध्ये आला. त्या रात्रभर मेघांनी एका बाजूने प्रकाश तर दुसर्‍या बाजूने अंधकार आणला; म्हणून रात्रभर एक दल दुसर्‍यापर्यंत पोहोचला नाही. ");
INSERT INTO marc_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","मग मोशेने आपला हात समुद्रावर उगारला आणि याहवेहने रात्रभर पूर्वेचा वारा वाहवून समुद्राचे पाणी मागे हटवून ती कोरडी जमीन केली व पाणी दुभागले. ");
INSERT INTO marc_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","तेव्हा इस्राएली लोक, त्यांच्या उजवी व डावीकडे पाण्याची भिंत उभी असताना, समुद्रामधून कोरड्या भूमीवरून चालत गेले. ");
INSERT INTO marc_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","इजिप्तच्या लोकांनी इस्राएली लोकांचा पाठलाग केला आणि फारोहचे घोडे, रथ व स्वार त्यांच्यामागे समुद्राच्या मध्ये गेले. ");
INSERT INTO marc_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","पण पहाटेच्या वेळी अग्निस्तंभामधून व मेघस्तंभामधून याहवेहने इजिप्तच्या सेनेकडे पाहिले आणि त्यांचा गोंधळ उडविला. ");
INSERT INTO marc_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","त्यांच्या रथांची चाके गच्च केली की त्यांना पुढे जाणे कठीण होऊ लागले. तेव्हा इजिप्तची लोक म्हणू लागले, “इस्राएलच्या लोकांपासून आपण दूर जाऊ या! कारण याहवेह त्यांच्यावतीने इजिप्तविरुद्ध लढत आहेत.” ");
INSERT INTO marc_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","मग याहवेह मोशेला म्हणाले, “आपला हात समुद्रावर लांब कर म्हणजे समुद्राचे पाणी पूर्ववत होऊन इजिप्तचे सर्व सैन्य, त्यांचे रथ व घोडेस्वार यांच्यावर येईल.” ");
INSERT INTO marc_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मोशेने आपला हात समुद्रावर लांब केला आणि पहाटेच्या वेळी समुद्र त्याच्या ठिकाणी परत गेला. इजिप्तचे लोक त्याच्याकडे धावत असताना याहवेहने त्यांना समुद्रात बुडवून टाकले. ");
INSERT INTO marc_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","पाणी परत वाहू लागले व फारोहचे सर्व सैन्य, घोडेस्वार व रथ—फारोहचे संपूर्ण सैन्य, ज्यांनी इस्राएली लोकांचा समुद्रामध्ये पाठलाग केला ते पाण्याखाली गेले. त्यांच्यातील एकही जिवंत राहिला नाही. ");
INSERT INTO marc_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","पण इस्राएली लोक कोरड्या जमिनीवरून समुद्र पार करून गेले आणि त्यांच्या उजवीकडे व डावीकडे पाणी भिंतीप्रमाणे उभे राहिले. ");
INSERT INTO marc_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","त्या दिवशी याहवेहने इस्राएलला इजिप्तच्या हातातून सोडविले, इस्राएली लोकांनी इजिप्तचे मेलेले लोक समुद्रकिनार्‍यावर पडलेले पाहिले. ");
INSERT INTO marc_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","जेव्हा इस्राएली लोकांनी इजिप्तच्या लोकांविरुद्ध आलेला याहवेहचा पराक्रमी हात बघितला, त्यावेळी त्यांना याहवेहचे भय वाटले आणि त्यांनी याहवेह व त्यांचा सेवक मोशे यांच्यावर विश्वास ठेवला. ");
INSERT INTO marc_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","नंतर मोशे व इस्राएली लोकांनी याहवेहप्रीत्यर्थ हे गीत गाईले: “मी याहवेहला गीत गाईन, कारण ते अत्युच्च आहेत. घोडे व त्यांचे स्वार त्यांनी समुद्रात फेकले आहेत. ");
INSERT INTO marc_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“याहवेह माझे सामर्थ्य व माझे संरक्षण आहेत; याहवेह माझे तारण झाले आहेत. तेच माझा परमेश्वर आहेत आणि मी त्यांची स्तुती करेन, माझ्या पूर्वजांचे परमेश्वर, मी त्यांचा महिमा वर्णीन. ");
INSERT INTO marc_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","याहवेह योद्धा आहेत; याहवेह त्यांचे नाव आहे. ");
INSERT INTO marc_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","फारोहचे रथ व सैन्य त्यांनी समुद्रात उलथून टाकले. फारोहचे सर्वोत्तम अधिकारी तांबड्या समुद्रात बुडून गेले. ");
INSERT INTO marc_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","खोल पाण्याने त्यांना झाकून टाकले; दगडाप्रमाणे ते खोल तळाशी बुडून गेले. ");
INSERT INTO marc_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे याहवेह, तुमचा उजवा हात, सामर्थ्याने ऐश्वर्यमान आहे. हे याहवेह तुमच्या उजव्या हाताने, शत्रूला हादरून टाकले. ");
INSERT INTO marc_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“तुमच्या ऐश्वर्याच्या महानतेने तुमच्या विरोधकांना तुम्ही खाली पाडले. स्वैर सोडलेल्या तुमच्या क्रोधाने; भुशाप्रमाणे त्यांना भस्म केले. ");
INSERT INTO marc_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तुमच्या नाकपुड्यांच्या श्वासाने जले एकत्र आली. पाण्याचे प्रवाह भिंतीप्रमाणे उभे राहिले; डोहातील पाणी समुद्राच्या मध्यभागी गोळा झाले. ");
INSERT INTO marc_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","शत्रूने फुशारकी मारीत म्हटले, ‘मी पाठलाग करून त्यांच्यावर मात करेन. मी लूट वाटून घेईन; त्यांच्या जिवावर मी तृप्त होईन. मी माझी तलवार उपसेन आणि माझ्या हाताने त्यांचा नाश होईल.’ ");
INSERT INTO marc_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","पण तुम्ही आपला श्वास फुंकला, आणि समुद्राने त्यांना झाकून टाकले. ते शीसाप्रमाणे महाजलात बुडून गेले. ");
INSERT INTO marc_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","सर्व दैवतांमध्ये हे याहवेह तुमच्यासारखे कोण आहे? पवित्रतेत ऐश्वर्यमान; वैभवात अद्वितीय, आश्चर्यकर्मे करणारे, असे तुमच्यासारखे कोण आहे?” ");
INSERT INTO marc_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तुम्ही आपला उजवा हात उगारला, आणि पृथ्वीने तुमच्या शत्रूंना गिळून टाकले. ");
INSERT INTO marc_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","तुम्ही उद्धारलेल्या लोकांना आपल्या प्रेमदयेने चालविणार. आपल्या सामर्थ्याने तुम्ही त्यांना तुमच्या पवित्र निवासस्थानाकडे घेऊन जाणार. ");
INSERT INTO marc_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","राष्ट्रे हे ऐकून थरथर कापतील; पलिष्टी भीतीने ग्रासून जातील. ");
INSERT INTO marc_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोमाचे अधिकारी घाबरून जातील, मोआबाचे पुढारी थरथर कापू लागतील, कनानातील लोक वितळून जातील; ");
INSERT INTO marc_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","तुमच्या बाहूच्या पराक्रमामुळे भीती व दहशत त्यांच्यावर येऊन पडेल. तुमचे लोक पार करेपर्यंत, हे याहवेह, जे लोक तुम्ही खंडून घेतले आहेत, ते पार होईपर्यंत ते दगडाप्रमाणे स्तब्ध राहतील. ");
INSERT INTO marc_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","तुम्ही त्यांना आत, तुमच्या वतनाच्या पर्वतावर आणून रोपणार; तेच ठिकाण याहवेह, जे तुम्ही आपल्या निवासासाठी तयार केले, ते पवित्रस्थान जे, हे प्रभू, तुमच्या हातांनी प्रस्थापित केले. ");
INSERT INTO marc_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","याहवेह सदासर्वकाळ राज्य करतील. ");
INSERT INTO marc_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","जेव्हा फारोहचे घोडे, रथ आणि घोडेस्वार समुद्रामध्ये गेले, तेव्हा याहवेहने समुद्राचे पाणी परत त्यांच्यावर आणले; परंतु इस्राएली लोक समुद्रामधून कोरड्या वाटेवरून चालले. ");
INSERT INTO marc_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तेव्हा अहरोनाची बहीण, मिर्याम संदेष्टी, हिने हातात डफ घेतला आणि सर्व स्त्रिया तिच्यामागे हातात डफ घेऊन नाचू लागल्या. ");
INSERT INTO marc_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","मिर्यामने त्यांच्यासाठी गाईले: “याहवेहप्रीत्यर्थ गीत गा, कारण ते अत्युच्च आहेत. घोडे व त्यांचे स्वार त्यांनी समुद्रात बुडवून टाकले आहेत.” ");
INSERT INTO marc_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","मग मोशेने इस्राएली लोकांस तांबड्या समुद्रापासून पुढे शूर नावाच्या रानात आणले. तीन दिवसांच्या रानातील त्यांच्या प्रवासात त्यांना पाणी मिळाले नाही. ");
INSERT INTO marc_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","मग ते माराह येथे आले, त्याचे पाणी ते पिऊ शकले नाहीत, कारण ते कडू होते. (म्हणूनच त्या ठिकाणाला मारा, म्हणजे कडू असे म्हणतात.) ");
INSERT INTO marc_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","“आम्ही काय प्यावे?” असे म्हणत लोकांनी मोशेविरुद्ध कुरकुर केली. ");
INSERT INTO marc_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","तेव्हा मोशेने याहवेहचा धावा केला आणि याहवेहने त्याला लाकडाचा एक तुकडा दाखविला. त्याने तो पाण्यात टाकला आणि पाणी पिण्यास योग्य झाले. त्या ठिकाणी याहवेहने त्यांना पारखण्यासाठी नियम व सूचना दिल्या. ");
INSERT INTO marc_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ते म्हणाले, “जर तुम्ही याहवेह, तुमच्या परमेश्वराचा शब्द काळजीपूर्वक ऐकाल व त्यांच्या नजरेत जे योग्य ते कराल, जर त्यांच्या आज्ञांकडे लक्ष देऊन त्यांचे सर्व नियम पाळाल, तर मी इजिप्तवर ज्या पीडा आणल्या होत्या, त्या तुमच्यावर आणणार नाही, कारण मी याहवेह, तुम्हाला आरोग्य देणारा आहे.” ");
INSERT INTO marc_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","मग ते एलीम येथे आले. जिथे बारा झरे व सत्तर खजुरीची झाडे होती. त्या पाण्याजवळ त्यांनी तळ दिला. ");
INSERT INTO marc_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","इजिप्त देशातून बाहेर आल्यावर, दुसर्‍या महिन्याच्या पंधराव्या दिवशी इस्राएलचा समुदाय एलीम येथून निघून एलीम व सीनायच्या मध्ये जे सीन रान आहे त्याकडे आला. ");
INSERT INTO marc_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","त्या रानात सर्व इस्राएली लोकांनी मोशे व अहरोन यांच्याविरुद्ध कुरकुर केली. ");
INSERT INTO marc_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","इस्राएली लोक त्यांना म्हणाले, “इजिप्तमध्ये असतानाच याहवेहच्या हाताने आम्ही मेलो असतो तर किती बरे असते! तिथे आम्ही मांसाच्या भांड्याभोवती बसून हवे ते अन्न खाल्ले, पण तू हा सर्व समाज मरावा म्हणून आम्हाला या अरण्यात आणले आहे.” ");
INSERT INTO marc_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","मग याहवेहने मोशेला म्हटले, “मी तुमच्यासाठी स्वर्गातून भाकरीची वृष्टी करेन. लोकांनी दररोज बाहेर जाऊन त्या दिवसासाठी पुरेलसे गोळा करावे. म्हणजे ते माझ्या सूचनेप्रमाणे वागतात की नाहीत याची मला परीक्षा करता येईल. ");
INSERT INTO marc_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","सहाव्या दिवशी ते जे काही आत आणतील ते त्यांनी तयार करावे आणि दररोज ते जेवढे गोळा करतात त्यापेक्षा दुप्पट असावे.” ");
INSERT INTO marc_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","मग मोशे व अहरोन यांनी सर्व इस्राएली लोकांना सांगितले, “संध्याकाळच्या वेळी तुम्हाला समजेल की याहवेहनेच तुम्हाला इजिप्त देशातून बाहेर आणले. ");
INSERT INTO marc_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","आणि सकाळी तुम्ही याहवेहचे गौरव बघाल, कारण तुम्ही याहवेहविरुद्ध केलेली कुरकुर त्यांनी ऐकली आहे. आम्ही कोण आहोत की तुम्ही आमच्याविरुद्ध कुरकुर करावी?” ");
INSERT INTO marc_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","मोशे म्हणाला, “संध्याकाळी जेव्हा याहवेह तुम्हाला मांस आणि सकाळी जी भाकर तुम्हाला पाहिजे ती खायला देतील, कारण त्यांनी त्यांच्याविरुद्ध केलेली तुमची कुरकुर ऐकली आहे. आम्ही कोण आहोत? तुम्ही आमच्याविरुद्ध नाही, तर याहवेहच्या विरुद्ध कुरकुर करीत आहात.” ");
INSERT INTO marc_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","मग मोशे अहरोनाला म्हणाला, “संपूर्ण इस्राएली समुदायाला सांग, ‘याहवेहच्या समोर या, कारण त्यांनी तुमची कुरकुर ऐकली आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","अहरोन सर्व इस्राएली लोकांशी बोलत असताना, त्यांनी रानाकडे पाहिले आणि त्यांना याहवेहचे गौरव ढगात प्रकट होत असलेले दिसले. ");
INSERT INTO marc_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मी इस्राएली लोकांची कुरकुर ऐकली आहे. त्यांना सांग, ‘सायंकाळी तुम्ही मांस खाल, व सकाळी तुम्ही भाकरीने तृप्त व्हाल. मग तुम्हाला समजेल की, मी याहवेह तुमचा परमेश्वर आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","त्या संध्याकाळी लावे पक्षी त्यांच्या वस्तीवर येऊन उतरले व त्यामुळे छावणी व सभोवतालची सर्व जमीन झाकली गेली आणि सकाळी छावणी सभोवती दवबिंदूंचा थर जमला होता. ");
INSERT INTO marc_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","जेव्हा दवबिंदू नाहीसे झाले, तेव्हा रानातील भूमीवर हिमकणांएवढे खवल्यांसारखे बारीक तुकडे पसरलेले दिसू लागले. ");
INSERT INTO marc_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","जेव्हा इस्राएली लोकांनी ते पाहिले, ते एकमेकास म्हणू लागले, “हे काय आहे?” कारण ते काय होते ते त्यांना ठाऊक नव्हते. मोशे त्यांना म्हणाला, “हीच ती भाकर आहे जी याहवेहने तुम्हाला खाण्यासाठी दिली आहे. ");
INSERT INTO marc_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","याहवेहने दिलेली आज्ञा ही: ‘प्रत्येकाने त्यांना लागते तेवढे गोळा करावे. तुमच्या तंबूत असलेल्या प्रत्येक व्यक्तीसाठी एक ओमेर एवढे घ्यावे.’ ” ");
INSERT INTO marc_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इस्राएली लोकांनी जसे त्यांना सांगितले होते तसे केले; काहींनी अधिक तर काहींनी थोडे गोळा केले. ");
INSERT INTO marc_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","आणि जेव्हा त्यांनी ते ओमेरच्या मापाने मोजले, ज्याने खूप गोळा केले, त्याला अधिक झाले नाही आणि ज्याने थोडे गोळा केले त्याला थोडे झाले नाही. प्रत्येकाने त्यांना जितके लागत होते तितकेच गोळा केले होते. ");
INSERT INTO marc_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मग मोशे त्यांना म्हणाला, “यातील काहीही सकाळपर्यंत शिल्लक ठेवू नये,” ");
INSERT INTO marc_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","तरीही काहींनी मोशेच्या शब्दाकडे लक्ष दिले नाही; व त्याचा काही भाग सकाळपर्यंत ठेवला, पण त्यात किडे पडून त्याला दुर्गंधी सुटली होती, तेव्हा मोशे त्यांच्यावर रागावला. ");
INSERT INTO marc_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","मग रोज सकाळी प्रत्येकाला लागते तेवढेच ते गोळा करीत असत आणि जेव्हा सूर्य प्रखर होई, तेव्हा ते वितळून जात असे. ");
INSERT INTO marc_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","आठवड्याच्या सहाव्या दिवशी ते रोजच्यापेक्षा दुप्पट—प्रत्येकी दोन ओमेर अन्न गोळा करीत—आणि सर्व इस्राएली वडीलमंडळींनी येऊन मोशेला याबद्दल हवाला दिला. ");
INSERT INTO marc_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","मोशेने त्यांना सांगितले, “याहवेहची आज्ञा हीच आहे: ‘उद्या विसाव्याचा दिवस, याहवेहचा पवित्र शब्बाथ आहे. तर तुम्हाला जे काही शिजवायचे आहे ते शिजवा व जे उकळावयाचे असेल ते उकळून घ्या. जे उरेल ते सकाळपर्यंत ठेवा.’ ” ");
INSERT INTO marc_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","म्हणून त्यांनी मोशेने आज्ञापिल्याप्रमाणे ते सकाळपर्यंत ठेवले तेव्हा त्याला ना दुर्गंधी आली ना त्यात किडे पडले. ");
INSERT INTO marc_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","मोशे म्हणाला, “आज हे खा, कारण आज याहवेहचा शब्बाथ आहे. म्हणून तुम्हाला आज त्यातील काही जमिनीवर मिळणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","सहा दिवस तुम्ही ते गोळा करावे, पण सातव्या दिवशी शब्बाथ आहे. या दिवशी ते मिळणार नाही.” ");
INSERT INTO marc_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","पण काही लोक सातव्या दिवशी सुद्धा ते गोळा करावयाला बाहेर गेले. पण त्यांना काहीही सापडले नाही. ");
INSERT INTO marc_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","मग याहवेहने मोशेला म्हटले, “किती काळ तुम्ही माझे नियम व माझ्या आज्ञा पाळण्याचे नाकारणार? ");
INSERT INTO marc_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","हे लक्षात घ्या की याहवेहने तुम्हाला हा शब्बाथ दिलेला आहे; म्हणून सहाव्या दिवशी ते तुम्हाला दोन दिवसासाठी भाकर देतात. सातव्या दिवशी प्रत्येकाने ते जिथे आहेत तिथेच थांबावे; कोणीही बाहेर जाऊ नये.” ");
INSERT INTO marc_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","म्हणून लोकांनी सातव्या दिवशी विसावा घेतला. ");
INSERT INTO marc_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएली लोकांनी त्या भाकरीला मान्ना असे नाव दिले. ते धण्याच्या बीजाप्रमाणे पांढरे असून त्याची चव मध घालून केलेल्या पापडीप्रमाणे होती. ");
INSERT INTO marc_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मोशे म्हणाला, “याहवेहने अशी आज्ञा दिली आहे: ‘एक ओमेर मान्ना घेऊन तो येणार्‍या पिढ्यांसाठी ठेवा, की तुम्हाला इजिप्त देशातून बाहेर आणल्यावर रानामध्ये मी तुम्हाला खायला दिलेली भाकरी ते पाहू शकतील.’ ” ");
INSERT INTO marc_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","मोशेने अहरोनाला सांगितले, “एक पात्र घे व त्यात एक ओमेर मान्ना घाल. मग तो पुढे येणार्‍या पिढ्यांसाठी याहवेहसमोर ठेव.” ");
INSERT INTO marc_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","याहवेहने मोशेला आज्ञापिल्याप्रमाणे, अहरोनाने तो मान्ना कराराच्या पाट्यांबरोबर ठेवला, अशासाठी की तो राखून ठेवला जाईल. ");
INSERT INTO marc_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएली लोक स्थायिक असलेल्या भूमीवर येईपर्यंत, त्यांनी चाळीस वर्षे मान्ना खाल्ला; ते कनान देशाच्या सीमेवर पोहोचेपर्यंत त्यांनी मान्ना खाल्ला. ");
INSERT INTO marc_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(एक ओमेर हा एका एफाचा दहावा भाग आहे.) ");
INSERT INTO marc_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","सर्व इस्राएलाचा समाज सीन रानातून निघून, याहवेहच्या आज्ञेनुसार एका ठिकाणाहून दुसरीकडे प्रवास करीत गेले. मग त्यांनी रफीदीम येथे तळ दिला, पण तिथे लोकांना प्यावयास पाणी नव्हते. ");
INSERT INTO marc_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","तेव्हा लोक मोशेशी भांडण करीत म्हणाले, “आम्हाला प्यावयास पाणी दे.” मोशे त्यांना म्हणाला, “तुम्ही माझ्याशी का भांडता? तुम्ही याहवेहची परीक्षा का पाहता?” ");
INSERT INTO marc_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","पण तिथे लोकांना फारच तहान लागली होती आणि ते मोशेविरुद्ध कुरकुर करीत म्हणाले, “आम्ही व आमची मुलेबाळे व पशू तहानेने मरून जावे म्हणून तू आम्हाला इजिप्त देशाबाहेर आणलेस का?” ");
INSERT INTO marc_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","मग मोशेने याहवेहकडे आरोळी मारली, “मी या लोकांचे काय करू? ते तर मला धोंडमार करण्याच्या तयारीत आहेत.” ");
INSERT INTO marc_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","मग याहवेहने मोशेला सांगितले, “लोकांच्या समोर जा. काही इस्राएली वडिलजनांना आपल्याबरोबर घे आणि नाईल नदीवर ज्या काठीने मारले ती आपल्या हाती घे आणि नीघ. ");
INSERT INTO marc_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","होरेबातील खडकाकडे मी तुझ्यापुढे उभा राहीन. त्या खडकाला काठीने मार आणि त्यातून लोकांना प्यावयास पाणी येईल.” मग मोशेने इस्राएलाच्या वडिलांदेखत तसे केले. ");
INSERT INTO marc_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","मोशेने त्या ठिकाणाचे नाव मस्सा व मरीबाह असे ठेवले; कारण इस्राएली लोकांनी भांडण केले आणि याहवेह आमच्यामध्ये आहेत की नाहीत? असे म्हणून याहवेहची परीक्षा घेतली. ");
INSERT INTO marc_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","नंतर अमालेकी आले व त्यांनी इस्राएली लोकांवर रफीदीम येथे हल्ला केला. ");
INSERT INTO marc_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","मोशे यहोशुआला म्हणाला, “आपल्यातून काही माणसे निवड आणि बाहेर जाऊन अमालेक्यांशी युद्ध करा. उद्या मी परमेश्वराची काठी माझ्या हातात घेऊन डोंगराच्या शिखरावर उभा राहीन.” ");
INSERT INTO marc_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","मग मोशेने सांगितल्याप्रमाणे यहोशुआ अमालेकी सैन्याशी लढला आणि मोशे, अहरोन व हूर हे डोंगराच्या शिखरावर गेले. ");
INSERT INTO marc_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","जोपर्यंत मोशे आपले हात वर करीत असे, इस्राएली लोकांचा विजय होत असे, पण जेव्हा ते खाली करी, अमालेक्यांचा विजय होत असे. ");
INSERT INTO marc_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","जेव्हा मोशेचे हात थकून गेले, त्यांनी एक दगड घेतला व मोशे त्यावर बसला. अहरोन एका बाजूने व हूर दुसर्‍या बाजूने असे त्यांनी त्याचे हात वर धरून ठेवले; व सूर्यास्तापर्यंत त्याचे हात स्थिर राहिले. ");
INSERT INTO marc_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","आणि यहोशुआने अमालेकी सैन्याला तलवारीने ठार केले. ");
INSERT INTO marc_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","मग याहवेह मोशेला म्हणाले, “या घटनेची आठवण रहावी म्हणून तू ती ग्रंथात लिहून ठेव आणि ते यहोशुआच्या कानी पडेल याची खात्री कर, कारण मी पृथ्वीवरून अमालेकांचा संपूर्णपणे नाश करणार.” ");
INSERT INTO marc_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","मोशेने त्या ठिकाणी एक वेदी बांधली व त्या ठिकाणाचे नाव याहवेह निस्सी असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","तो म्हणाला, “कारण याहवेहच्या राजासनाविरुद्ध हात उगारले गेले, म्हणून याहवेह पिढ्यान् पिढ्या पर्यंत अमालेक्यांशी युद्ध करतील.” ");
INSERT INTO marc_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","आता परमेश्वराने मोशे व त्यांच्या इस्राएली लोकांसाठी काय केले आणि याहवेहने इस्राएली लोकांना कशाप्रकारे इजिप्तमधून बाहेर आणले, याविषयी सर्वकाही मिद्यानी याजक व मोशेचा सासरा इथ्रो याने ऐकले. ");
INSERT INTO marc_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","मोशेने आपली पत्नी सिप्पोराहला व त्याच्या दोन मुलांना आपला सासरा इथ्रो याच्याकडे सोडले होते, ");
INSERT INTO marc_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","मोशेच्या एका मुलाचे नाव गेर्षोम असे होते; कारण मोशे म्हणाला, “मी परक्या देशात विदेशी झालो आहे.” ");
INSERT INTO marc_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","दुसर्‍या मुलाचे नाव एलिएजर असे ठेवले होते. कारण मोशे म्हणाला, “माझ्या वडिलांचे परमेश्वर माझे साहाय्य झाले; व त्यांनी मला फारोहच्या तलवारीपासून सोडविले.” ");
INSERT INTO marc_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","इथ्रो, मोशेचा सासरा, मोशेची पत्नी व मुलांसोबत, परमेश्वराच्या डोंगराजवळ रानात जिथे त्यांनी तळ दिला होता तिथे आला. ");
INSERT INTO marc_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","इथ्रोने मोशेला निरोप पाठविला, “मी तुझा सासरा इथ्रो, तुझी पत्नी व दोन मुले घेऊन तुझ्याकडे येत आहे.” ");
INSERT INTO marc_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","तेव्हा मोशे त्याच्या सासर्‍याला भेटायला बाहेर आला आणि नमन करून त्याचे चुंबन घेतले. ते एकमेकांना अभिवादन करून तंबूत गेले. ");
INSERT INTO marc_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","मोशेने आपल्या सासर्‍याला सर्वकाही सांगितले जे इस्राएली लोकांसाठी याहवेहने फारोह व इजिप्तच्या लोकांबरोबर केले आणि वाटेत ज्या अडचणी त्यांना आल्या आणि कशाप्रकारे याहवेहने त्यांची सुटका केली. ");
INSERT INTO marc_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","इजिप्तच्या लोकांच्या हातातून इस्राएलची सुटका करण्यासाठी याहवेहने जी चांगली कृत्ये केली, ती ऐकून इथ्रोला फार आनंद झाला. ");
INSERT INTO marc_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","इथ्रो म्हणाला, “याहवेहचे नाव धन्यवादित असो, ज्यांनी तुला इजिप्त व फारोहच्या तावडीतून सोडविले आणि ज्यांनी लोकांना इजिप्तच्या लोकांच्या हातातून सोडविले. ");
INSERT INTO marc_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","आता मला समजले की, याहवेह सर्व दैवतांपेक्षा श्रेष्ठ आहे, कारण ज्यांनी इस्राएली लोकांना क्रूरतेने वागविले होते त्यांचा त्यांनी नाश केला आहे.” ");
INSERT INTO marc_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","मग मोशेचा सासरा इथ्रोने परमेश्वरासाठी होमार्पण व इतर अर्पणे आणली आणि अहरोन व इस्राएली लोकांचे सर्व वडील मोशेच्या सासर्‍याबरोबर भोजन करावयास परमेश्वराच्या समक्षतेत आले. ");
INSERT INTO marc_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","दुसर्‍या दिवशी मोशे इस्राएली लोकांचा न्याय करावयाला त्याच्या आसनावर बसला आणि लोक सकाळपासून संध्याकाळपर्यंत त्याच्याभोवती उभे राहिले. ");
INSERT INTO marc_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","जेव्हा मोशे लोकांसाठी जे सर्व करीत होता ते त्याच्या सासर्‍याने पाहिले, तो म्हणाला, “हे तू लोकांसाठी काय करीत आहेस? तू एकटाच न्यायाधीश म्हणून का बसतोस व ते सर्व लोक दिवसभर तुझ्याभोवती उभे असतात?” ");
INSERT INTO marc_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मोशे त्याला म्हणाला, “कारण लोक परमेश्वराची इच्छा जाणावी म्हणून माझ्याकडे येतात. ");
INSERT INTO marc_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","जेव्हा त्यांच्यात वाद होतात, ते माझ्याकडे आणतात आणि मी त्यांचा निर्णय करतो आणि त्यांना परमेश्वराचे विधी व नियम याबद्दल सांगतो.” ");
INSERT INTO marc_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मोशेच्या सासर्‍याने उत्तर दिले, “तू जे करतोस ते बरोबर नाही. ");
INSERT INTO marc_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","तू व हे लोक जे तुझ्याकडे येतात, सर्वजण थकून जाल. हे काम तुझ्यासाठी खूप जड आहे; तू एकट्यानेच ते करणे तुला जमणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","तर आता तू माझे ऐक आणि मी तुला सल्ला देतो आणि परमेश्वर तुझ्याबरोबर असो. तू परमेश्वरासमोर या लोकांचा प्रतिनिधी म्हणून राहा आणि त्यांचे वाद परमेश्वरासमोर आण. ");
INSERT INTO marc_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","परमेश्वराचे विधी व नियम त्यांना शिकव आणि ज्या मार्गाने त्यांनी चालावे आणि त्यांचे वर्तन कसे असावे हे त्यांना दाखव. ");
INSERT INTO marc_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","पण या सर्व लोकांमधून सक्षम असे लोक—जे परमेश्वराचे भय बाळगणारे, विश्वसनीय, व अन्यायाच्या लाभाचा द्वेष करणारे असतील—ते निवडून घे; त्यांची हजारांवर, शंभरांवर, पन्नासांवर आणि दहांवर अधिकारी म्हणून नेमणूक कर. ");
INSERT INTO marc_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","त्यांनी सर्व समयी लोकांचे न्यायाधीश म्हणून असावे, परंतु प्रत्येक अवघड वाद तुझ्याकडे आणावा; आणि सोपे वाद त्यांच्या अधिकार्‍यांनी सोडवावेत. त्यामुळे तुझे ओझे हलके होईल, कारण ते तुझ्याबरोबर तुझा भार वाहतील. ");
INSERT INTO marc_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","जर तू असे केले आणि परमेश्वराने तुला आज्ञा केली, तर तुला सोपे जाईल आणि हे लोकसुद्धा समाधानी होऊन घरी जातील.” ");
INSERT INTO marc_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","मोशेने आपल्या सासर्‍याचे ऐकून सर्वकाही त्याने सांगितल्याप्रमाणे केले. ");
INSERT INTO marc_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","मोशेने संपूर्ण इस्राएलातून सक्षम अशी माणसे निवडली व त्यांना हजारांवर, शंभरांवर, पन्नासांवर व दहांवर प्रमुख व अधिकारी म्हणून नेमले. ");
INSERT INTO marc_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","त्यांनी सर्व समयी लोकांचे न्यायाधीश म्हणून सेवा केली. अवघड वाद त्यांनी मोशेकडे आणले, परंतु साधेसरळ वाद त्यांनीच सोडविले. ");
INSERT INTO marc_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","मग मोशेने आपल्या सासर्‍याचा निरोप घेतला आणि इथ्रो त्याच्या देशास परत निघून गेला. ");
INSERT INTO marc_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्राएली लोक इजिप्त देशातून बाहेर आल्यावर तिसर्‍या महिन्याच्या पहिल्या दिवशी; याच दिवशी ते सीनायच्या रानात आले. ");
INSERT INTO marc_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","रफीदीम येथून निघाल्यावर, त्यांनी सीनायच्या रानात प्रवेश केला आणि इस्राएल त्या ठिकाणी रानात पर्वतापुढे तळ देऊन राहिले. ");
INSERT INTO marc_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","नंतर मोशे परमेश्वराकडे गेला आणि याहवेहने पर्वतावरून त्याला आवाज देऊन म्हटले, “याकोबाच्या वंशजांना, म्हणजेच इस्राएली लोकांना तू हे सांगावे: ");
INSERT INTO marc_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘मी इजिप्तच्या लोकांचे काय केले आणि तुम्हाला गरुडाच्या पंखावर माझ्याकडे कसे वाहून आणले, ते तुम्ही स्वतःच पाहिले आहे. ");
INSERT INTO marc_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","आता जर तुम्ही पूर्णपणे माझे आज्ञापालन केले आणि माझा करार पाळला, तर सर्व राष्ट्रात तुम्ही माझे मोलवान धन व्हाल. जरी सर्व पृथ्वी माझी आहे, ");
INSERT INTO marc_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","तरी तुम्हीच मला याजकीय राज्य; पवित्र राष्ट्र असे व्हाल.’ तू इस्राएली लोकांना सांगावयाच्या याच गोष्टी आहेत.” ");
INSERT INTO marc_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","तेव्हा मोशेने इस्राएली पुढार्‍यांना बोलावून ज्यागोष्टी याहवेहने सांगाव्या म्हणून आज्ञापिल्या होत्या, त्या त्यांना सांगितल्या. ");
INSERT INTO marc_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","तेव्हा सर्व लोक एकत्र प्रतिसाद देत म्हणाले, “जे काही याहवेहने सांगितले, ते सर्व आम्ही करू.” मग मोशेने जाऊन लोकांचे म्हणणे याहवेहला कळविले. ");
INSERT INTO marc_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","मग याहवेहने मोशेला म्हटले, “मी घनदाट मेघातून तुझ्याकडे येईन, अशासाठी की मी तुझ्याशी बोलत असताना लोक ऐकतील आणि तुझ्यावर विश्वास ठेवतील.” मग मोशेने लोक काय म्हणाले ते याहवेहला सांगितले. ");
INSERT INTO marc_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","आणि याहवेह मोशेला म्हणाले, “लोकांकडे जा आणि त्यांना आज व उद्या पवित्र कर. त्यांनी आपले कपडे स्वच्छ धुवावे, ");
INSERT INTO marc_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","आणि तिसर्‍या दिवशी तयार असावे, कारण त्या दिवशी याहवेह सर्व लोकांसमक्ष सीनाय पर्वतावर उतरून येतील. ");
INSERT INTO marc_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","लोकांसाठी पर्वताच्या सभोवती सीमारेषा आख आणि त्यांना सांग, ‘कोणीही पर्वताकडे जाऊ नये किंवा त्याच्या पायथ्यालाही कोणी स्पर्श करणार नाही, याची काळजी घ्यावी. जे कोणी पर्वताला हात लावतील त्यांना मारून टाकावे.’ ");
INSERT INTO marc_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","त्यांना मरेपर्यंत धोंडमार करावी किंवा धनुष्यबाणाने मारावे; कोणीही त्यांना स्पर्श करू नये. ते मनुष्य असो वा प्राणी, त्यांना जिवंत राहू देऊ नये. जेव्हा एडक्याच्या शिंगाचा दीर्घ नाद कानी पडेल तेव्हाच त्यांनी पर्वताजवळ यावे.” ");
INSERT INTO marc_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","मग मोशे पर्वतावरून खाली उतरून लोकांकडे गेला, त्याने त्यांना शुद्ध केले व लोकांनी आपले कपडे धुतले. ");
INSERT INTO marc_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","मग तो लोकांना म्हणाला, “तिसर्‍या दिवसासाठी आपली तयारी करा, लैंगिक संभोगापासून दूर राहा.” ");
INSERT INTO marc_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तिसर्‍या दिवसाच्या सकाळी ढगांचा गडगडाट होऊन विजा चमकू लागल्या व पर्वतावर दाट ढग जमा झाले आणि तुतारीचा फार मोठा नाद झाला. छावणीतील सर्वजण भीतीने कापू लागले. ");
INSERT INTO marc_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","मग मोशेने लोकांना परमेश्वराला भेटण्यासाठी छावणीच्या बाहेर आणले आणि ते पर्वताच्या पायथ्याशी उभे राहिले. ");
INSERT INTO marc_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","सीनाय पर्वत धुराने झाकून गेला होता, कारण याहवेह अग्निरुपात पर्वतावर उतरले होते. भट्टीतून निघावा तसा धूर उठला होता आणि सगळा पर्वत जोरात थरथरत होता. ");
INSERT INTO marc_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","कर्ण्याचा आवाज जसा मोठा होत गेला, तसा मोशे बोलत होता आणि परमेश्वर त्याला उत्तर देत होते. ");
INSERT INTO marc_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","याहवेह सीनाय पर्वतावर उतरले व मोशेला पर्वतावर बोलाविले. मग मोशे वर गेला, ");
INSERT INTO marc_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","आणि याहवेह मोशेला म्हणाले. “खाली जा व लोकांना सांग की याहवेहला पाहण्यासाठी त्यांनी सीमा ओलांडू नये आणि पुष्कळांचा नाश होऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","याहवेहची सेवा करावयास जे याजक जवळ येतात त्यांनी सुद्धा स्वतःला पवित्र करावे, नाहीतर याहवेह त्यांच्याविरुद्ध भडकतील.” ");
INSERT INTO marc_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","तेव्हा मोशे याहवेहला म्हणाला, “लोक सीनाय पर्वताजवळ येऊ शकत नाहीत, कारण तुम्ही स्वतःच आम्हाला ताकीद दिली आहे, ‘पर्वताभोवती सीमा आखून आम्ही त्याला पवित्र ठेवावे.’ ” ");
INSERT INTO marc_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","याहवेहने उत्तर दिले, “खाली जा आणि अहरोनाला तुझ्याबरोबर घेऊन ये. परंतु याजकांनी व लोकांनी याहवेहकडे सीमा ओलांडून येऊ नये, नाहीतर याहवेह त्यांच्याविरुद्ध भडकतील.” ");
INSERT INTO marc_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","मग मोशे खाली लोकांकडे गेला व त्यांना हे सर्व सांगितले. ");
INSERT INTO marc_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","आणि परमेश्वर ही सर्व वचने बोलले: ");
INSERT INTO marc_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ज्याने तुम्हाला इजिप्त देशातून व दास्यातून बाहेर आणले, तो मीच याहवेह, तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“माझ्यासमोर तुम्हाला इतर कोणतेही देव नसावेत.” ");
INSERT INTO marc_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","तुम्ही स्वतःसाठी वर आकाशातील, पृथ्वीवरील व पृथ्वीच्या खाली जलातील कशाचीही प्रतिमा करू नका. ");
INSERT INTO marc_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","तुम्ही त्यांना नमन करू नये किंवा त्यांची उपासना करू नये; कारण मी, याहवेह तुमचा परमेश्वर, ईर्ष्यावान परमेश्वर आहे. जे माझा द्वेष करतात त्यांच्या लेकरांना तिसर्‍या व चौथ्या पिढीपर्यंत त्यांच्या आईवडिलांच्या पापांचे शासन करतो. ");
INSERT INTO marc_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","परंतु जे माझ्यावर प्रीती करतात आणि माझ्या आज्ञा पाळतात अशांच्या हजारो पिढ्यांपर्यंत प्रीती करतो. ");
INSERT INTO marc_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","याहवेह तुमच्या परमेश्वराचे नाव तुम्ही व्यर्थ घेऊ नका, कारण जे त्यांचे नाव व्यर्थ घेतात, त्यांना याहवेह शिक्षा दिल्यावाचून राहणार नाहीत. ");
INSERT INTO marc_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","शब्बाथ दिवस पवित्रपणे पाळून त्याची आठवण ठेवा. ");
INSERT INTO marc_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","सहा दिवस तुम्ही परिश्रम करावेत आणि आपली सर्व कामे करावी. ");
INSERT INTO marc_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","परंतु सातवा दिवस याहवेह तुमचे परमेश्वर यांचा शब्बाथ आहे. त्या दिवशी तुम्ही कोणतेही काम करू नये, तुम्ही किंवा तुमचा पुत्र किंवा कन्या, तुमचा दास किंवा दासी, तुमचे पशू किंवा तुमच्या नगरात राहणारा परदेशी यांनी देखील कोणतेही काम करू नये. ");
INSERT INTO marc_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","कारण सहा दिवसात याहवेहने आकाश व पृथ्वी, सागर आणि त्यातील सर्वकाही निर्माण केले, परंतु सातव्या दिवशी त्यांनी विश्रांती घेतली, म्हणून याहवेहने शब्बाथ दिवस आशीर्वादित करून तो पवित्र केला. ");
INSERT INTO marc_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","आपल्या वडिलांचा व आपल्या आईचा सन्मान करा, म्हणजे जो देश याहवेह तुमचे परमेश्वर तुम्हाला देत आहे, त्यात तुम्ही दीर्घकाळ राहाल. ");
INSERT INTO marc_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","तुम्ही खून करू नका. ");
INSERT INTO marc_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","तुम्ही व्यभिचार करू नका. ");
INSERT INTO marc_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","तुम्ही चोरी करू नका. ");
INSERT INTO marc_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","तुमच्या शेजार्‍याविरुद्ध खोटी साक्ष देऊ नका. ");
INSERT INTO marc_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","तुमच्या शेजार्‍याच्या घराचा लोभ धरू नका. तुमच्या शेजार्‍याच्या पत्नीची अभिलाषा धरू नका किंवा त्याच्या दासाचा किंवा दासीचा, किंवा त्याच्या बैलाचा किंवा त्याच्या गाढवाचा, किंवा त्याच्या मालकीचे जे काही असेल त्या कशाचाही लोभ धरू नका. ");
INSERT INTO marc_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","जेव्हा लोकांनी विजा पाहिल्या आणि गडगडाट व तुतारीचा आवाज ऐकला आणि धुराने भरलेला पर्वत पाहिला, ते भीतीने कंपित झाले व दूर उभे राहिले ");
INSERT INTO marc_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","आणि ते मोशेला म्हणाले, “तुम्ही स्वतः आमच्याशी बोला आणि आम्ही ऐकू. पण परमेश्वराला मात्र आमच्याशी बोलू देऊ नका, नाहीतर आम्ही मरून जाऊ.” ");
INSERT INTO marc_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मोशे लोकांना म्हणाला, “घाबरू नका. तुमची परीक्षा पाहावी म्हणून परमेश्वर आले आहेत, अशासाठी की परमेश्वराचे भय तुम्हाला पापापासून दूर ठेवण्याकरिता तुमच्याबरोबर असावे.” ");
INSERT INTO marc_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","परमेश्वर होते तिथे मोशे दाट अंधकारात गेला असताना, लोक दूर अंतरावर उभे राहिले. ");
INSERT INTO marc_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","मग याहवेह मोशेला म्हणाले, “इस्राएली लोकांस हे सांग: ‘मी तुमच्याशी स्वर्गातून बोललो हे तुम्ही स्वतः पाहिले आहे: ");
INSERT INTO marc_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","माझ्या खेरीज इतर कोणतेही देव बनवू नका; तुमच्यासाठी चांदीच्या किंवा सोन्याच्या मूर्त्या बनवू नका. ");
INSERT INTO marc_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘माझ्यासाठी मातीची वेदी तयार करा व त्यावर तुमची मेंढरे, बोकडे व तुमचे गुरे चढवून आपली होमार्पणे व शांत्यर्पणे ही अर्पण करा. जिथे कुठे माझ्या नावाचे गौरव व्हावा असे मी ठरवेन, तिथे मी तुमच्याजवळ येऊन तुम्हाला आशीर्वाद देईन. ");
INSERT INTO marc_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","तुम्ही माझ्यासाठी जर दगडाची वेदी बांधली, तर त्यासाठी घडविलेले दगड वापरू नयेत. त्यावर कोणतेही हत्यार वापरले तर तुम्ही त्यास विटाळून टाकाल. ");
INSERT INTO marc_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","आपली नग्नता उघडी पडू नये म्हणून माझ्या वेदीवर पायर्‍या चढून जाऊ नका.’ ");
INSERT INTO marc_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“तू त्यांच्यासमोर मांडावयाचे नियम हे आहेत: ");
INSERT INTO marc_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“तुम्ही जर एखादा इब्री गुलाम विकत घेतला, तर त्याने तुमची सहा वर्षे सेवा करावी. परंतु सातव्या वर्षी तो काहीही भरपाई न घेता स्वतंत्र होईल. ");
INSERT INTO marc_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","जर तो एकटाच आला, तर तो एकटाच स्वतंत्र जाईल; परंतु तो आपल्या पत्नीसोबत आला तर तीसुद्धा त्याच्याबरोबर जाईल. ");
INSERT INTO marc_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","जर गुलाम असताना त्याच्या मालकाने त्याचे लग्न करून दिले आणि त्याला मुले व मुली झाले, तर ती स्त्री व तिची लेकरे त्या मालकाच्या हक्काची राहतील आणि तो मनुष्य एकटाच स्वतंत्र केला जाईल. ");
INSERT INTO marc_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“पण जर तो गुलाम जाहीर करतो की, मी माझ्या मालकावर, माझ्या पत्नीवर व माझ्या लेकरांवर प्रीती करतो आणि तुम्हाला सोडून जाण्याची माझी इच्छा नाही, ");
INSERT INTO marc_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","तर त्याच्या मालकाने त्याला न्यायाधीशांसमोर आणावे. मग त्याने त्याला दरवाजाकडे किंवा दरवाजाच्या चौकटीजवळ आणावे व आरीने त्याचा कान टोचावा. यानंतर तो त्याचा जीवनभर गुलाम म्हणून राहील. ");
INSERT INTO marc_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“एखाद्या मनुष्याने आपली मुलगी गुलाम म्हणून विकली, तर पुरुष केले जातात त्याप्रमाणे ती स्वतंत्र केली जाणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ज्याने तिला आपल्यासाठी निवडून घेतले होते, त्या आपल्या मालकाला जर ती संतुष्ट करीत नाही, तर त्याने तिची खंडणी भरून तिला जाऊ द्यावे; तिला परक्याला विकण्याचा त्याला अधिकार नाही, कारण त्याने तिचा विश्वास तोडला आहे. ");
INSERT INTO marc_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","पण आपल्या मुलासाठी जर तो तिची निवड करतो, तर त्याने आपल्या मुलीचे हक्क तिला द्यावे. ");
INSERT INTO marc_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","जर तो दुसर्‍या स्त्रीशी विवाह करतो, तर त्याने पहिल्या पत्नीला अन्न, वस्त्र, आणि वैवाहिक हक्क यापासून वंचित ठेऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","जर तो या तीन गोष्टी तिला पुरवित नाही तर ती पैसे न देताच मोकळी जाऊ शकते. ");
INSERT INTO marc_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“जर कोणी एखाद्यावर प्राणघातक हल्ला केला तर त्याला मृत्युदंड द्यावा. ");
INSERT INTO marc_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","जरी ते मुद्दाम केलेले नाही, पण परमेश्वरानेच ते घडवून आणले, तर मी नेमलेल्या ठिकाणी त्यांनी पळून जावे. ");
INSERT INTO marc_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","पण कोणी जर कपटाने एखाद्याचा वध केला, तर त्याला माझ्या वेदीकडे नेऊन मृत्युदंड द्यावा. ");
INSERT INTO marc_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“जे कोणी आपला पिता किंवा आईला जिवे मारतात त्यांना जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“जो कोणी एखाद्याचे अपहरण करतो त्याला जिवे मारावे, पीडित व्यक्ती त्याच्या ताब्यात असो किंवा कोणाला विकलेली असो. ");
INSERT INTO marc_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“जो कोणी आपल्या आई किंवा वडिलास शाप देईल त्यास जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“जर लोक आपसात भांडत असताना एकाने दुसर्‍याला दगडाने किंवा बुक्कीने मारले आणि पीडित व्यक्ती मेली नाही, परंतु आपले अंथरूण धरून राहिली, ");
INSERT INTO marc_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","आणि जर उठून काठीच्या आधाराने बाहेर चालू शकेल तर ज्याने मारले तो दंडास पात्र नसून निर्दोष असेल; मात्र दोषी व्यक्तीने इजा झालेल्या व्यक्तीला नुकसान भरपाई व तो व्यक्ती बरा होईपर्यंत सर्व खर्च द्यावा. ");
INSERT INTO marc_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“जो कोणी आपल्या गुलाम स्त्री किंवा पुरुषाला काठीने मारेल व त्यामुळे गुलाम मरण पावला, तर त्या धन्याला शिक्षा व्हावी. ");
INSERT INTO marc_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","पण जर गुलाम एक किंवा दोन दिवसात बरा झाला तर त्यांना पैशाची शिक्षा होणार नाही, कारण गुलाम त्यांच्या मालकीचा आहे. ");
INSERT INTO marc_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“कोणी मारामारी करीत असताना एखाद्या गरोदर स्त्रीला धक्का लागला व त्यामुळे तिचा गर्भपात झाला, पण तिला गंभीर इजा झाली नाही, तर तिचा पती मागेल व न्यायाधीश मान्य करेल तितकी रक्कम अपराध्याने द्यावी. ");
INSERT INTO marc_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","परंतु इजा जर गंभीर आहे, तर तुम्ही जिवाबद्दल जीव, ");
INSERT INTO marc_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","डोळ्याबद्दल डोळा, दाताबद्दल दात, हाताबद्दल हात, पायाबद्दल पाय, ");
INSERT INTO marc_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","चटक्याबद्दल चटका, जखमेबद्दल जखम किंवा इजेबद्दल इजा द्यावी. ");
INSERT INTO marc_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“एखाद्या धन्याने आपल्या गुलाम स्त्री किंवा पुरुषाच्या डोळ्यांवर मारून तो फोडला तर डोळ्याची भरपाई म्हणून त्याने त्यांना स्वतंत्र करावे. ");
INSERT INTO marc_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","एखादा धनी जो आपल्या गुलाम पुरुष किंवा स्त्रीचा दात पाडतो, तर दाताची भरपाई म्हणून त्याने त्यांना स्वतंत्र करावे. ");
INSERT INTO marc_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“एखाद्या बैलाने एखाद्या पुरुष किंवा स्त्रीस हुंदडून जिवे मारले, तर त्या बैलास धोंडमार करून ठार मारावे व त्याचे मांस खाऊ नये. परंतु बैलाचा मालक निर्दोष असून जबाबदार असणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","पण बैल मारका आहे याबद्दल त्याच्या मालकाला सूचना देऊनही त्याने त्या बैलाला बांधून ठेवले नाही व तो एखाद्या पुरुषाला किंवा स्त्रीला मारून टाकतो, तर त्या बैलाला धोंडमार करावी व त्याच्या मालकास सुद्धा जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","परंतु जर त्याच्याकडून खंडणी मागितली असेल, तर जेवढी रक्कम मागितली ती देऊन तो मालक आपला जीव वाचवू शकतो. ");
INSERT INTO marc_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","एखाद्याच्या पुत्राला किंवा कन्येला बैलाने हुंदडून मारले, तरी हाच नियम लागू व्हावा. ");
INSERT INTO marc_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","पण बैलाने जर एखाद्या स्त्री किंवा पुरुष गुलामाला हुंदडून मारले, तर त्या गुलामाच्या मालकाला बैलाच्या मालकाने तीस चांदीची नाणी द्यावीत व बैलाला धोंडमार करावी. ");
INSERT INTO marc_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“जर कोणी एखादा खड्डा उघडला किंवा खणला व तो झाकला नाही आणि त्यात बैल किंवा गाढव पडले, ");
INSERT INTO marc_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","तर ज्याने तो खड्डा उघडला त्याने जनावराच्या मालकाला त्याची किंमत मोजून द्यावी व त्याबदल्यात ते मेलेले जनावर घ्यावे. ");
INSERT INTO marc_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“जर कोणाच्या बैलाने दुसर्‍याच्या बैलाला हुंदडून मारले, तर त्या दोघांनी जिवंत असलेला बैल विकून आलेली रक्कम व मेलेला बैल यांचा सारखा वाटा करून घ्यावा. ");
INSERT INTO marc_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","पण आपला बैल मारका आहे हे त्या बैलाच्या मालकाला माहिती असूनही, त्याने त्या बैलाला बांधले नाही, तर त्याच्या धन्याने जनावराबद्दल भरपाई करावी व मेलेले जनावर घ्यावे. ");
INSERT INTO marc_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“जर एखाद्याने बैल किंवा मेंढरू चोरले व ते कापले किंवा विकले तर त्याने एका बैलाबद्दल पाच बैल व एका मेंढराबद्दल चार मेंढरे परत करावीत. ");
INSERT INTO marc_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“एखादा चोर घरफोडी करताना सापडला व त्याला मारत असताना तो मेला, तर मारणारा रक्तदोषी राहणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","पण ते जर सूर्योदय झाल्यावर घडले, तर मारणारा रक्तदोषी ठरेल. “ज्याने चोरी केली त्याने खचितच भरपाई करून द्यावी, पण त्याच्याकडे काहीही नसले, तर त्याला चोरीची भरपाई म्हणून विकून टाकावे. ");
INSERT INTO marc_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","त्याने चोरलेले बैल, गाढव किंवा मेंढरू त्याच्याजवळ जिवंत सापडले; तर त्याने त्याची दुपटीने भरपाई करावी. ");
INSERT INTO marc_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“जर कोणी व्यक्ती आपली जनावरे दुसर्‍याच्या शेतात किंवा द्राक्षमळ्यात चरण्यासाठी मोकळी सोडतो, तर त्याने आपल्या स्वतःच्या शेतातील व द्राक्षमळ्यातील सर्वोत्तम पीक देऊन भरपाई करावी. ");
INSERT INTO marc_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“कोणी जर विस्तव पेटविले आणि चुकून तो काट्यांच्या झुडूपात पसरून दुसर्‍याच्या धान्याची कोठारे किंवा उभे पीक किंवा संपूर्ण शेत जळून जाते, तर ज्याने विस्तव पेटविले त्याने नुकसान भरपाई करून द्यावी. ");
INSERT INTO marc_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“जर कोणी चांदी किंवा सामान सुरक्षित राहावे म्हणून आपल्या शेजार्‍याकडे ठेवले आणि त्याची चोरी झाली, जर चोराला पकडले तर त्या चोराने त्या सामानाची दुप्पट भरपाई करून द्यावी. ");
INSERT INTO marc_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","पण जर चोर सापडला नाही तर घरमालकाने न्यायाधीशासमोर हजर व्हावे आणि शेजार्‍याच्या सामानावर त्याने हात टाकला नाही हे सिद्ध करावे. ");
INSERT INTO marc_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","एखादे बैल, गाढव, मेंढरू, वस्त्र किंवा एखादी हरवलेली वस्तू असे काहीही असो, ज्याबद्दल कोणी कलहाने बेकायदेशीरपणे म्हणतो की, ‘हे माझे आहे,’ तर त्या दोघांचाही वाद न्यायाधीशासमोर आणावा. ज्या कोणाला न्यायाधीश दोषी ठरवेल त्याने दुसर्‍याला दुपटीने परत करावे. ");
INSERT INTO marc_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“जर कोणी आपले गाढव, बैल, मेंढरू किंवा कोणतेही जनावर आपल्या शेजार्‍याकडे सुरक्षित राहावे म्हणून ठेवले आणि ते मेले किंवा त्याला काही इजा झाली किंवा त्याच्यावर नजर नसताना त्याला कोणी घेऊन गेले, ");
INSERT INTO marc_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","तर शेजार्‍याने दुसर्‍याच्या जनावरावर हात टाकला नाही हे सिद्ध करण्यासाठी त्याने याहवेहसमोर शपथ घ्यावी. मालकाला यावर विश्वास ठेवावा लागणार आणि त्यासाठी कोणतीही रक्कम भरून द्यायची गरज नाही. ");
INSERT INTO marc_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","पण ते जनावर जर शेजार्‍याकडून चोरीला गेले, तर त्याने मालकाला भरपाई करून द्यावे. ");
INSERT INTO marc_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","जर एखाद्या जंगली श्वापदाने ते जनावर फाडून टाकले, तर त्या शेजार्‍याने त्या जनावराचे पार्श्वशरीर पुरावा म्हणून समोर आणावे आणि त्या फाडलेल्या जनावराची फेड करून देऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“जर कोणी आपल्या शेजार्‍याकडून जनावर उसने घेतो व जनावराचा मालक तिथे नसताना ते जनावर जखमी झाले किंवा मेले, तर त्याने त्याची भरपाई त्याला द्यावी. ");
INSERT INTO marc_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","पण मालक जनावराबरोबर असला, तर भाडेकरूने त्याची भरपाई करू नये. जर त्याने ते भाड्याने घेतले असेल, तर त्याचे नुकसान भाड्यातच आलेले असते. ");
INSERT INTO marc_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“जर एखादा मनुष्य मागणी न झालेल्या कुमारीला भुलवितो आणि तिचा विनयभंग करतो, तर त्याने वधूकिंमत द्यावी आणि ती त्याची पत्नी होईल. ");
INSERT INTO marc_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","पण जर तिच्या वडिलांनी ती त्याला देण्यास नाकारले, तरीही त्याने कुमारिकेची वधूकिंमत द्यावी. ");
INSERT INTO marc_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“चेटकिणीला मुळीच जिवंत राहू देऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“पशुशी लैंगिक संबंध करणार्‍याला अवश्य जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“याहवेह परमेश्वराशिवाय इतर दैवतांना अर्पणे करणार्‍यांचा नाश करून टाकावा. ");
INSERT INTO marc_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“परदेशी व्यक्तीशी गैरवर्तणूक किंवा त्याला जाच करू नका, कारण तुम्हीही इजिप्त देशात परदेशी होता. ");
INSERT INTO marc_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“विधवा किंवा अनाथाचा गैरफायदा घेऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","तुम्ही जर तसे केले आणि त्यांनी माझा धावा केला, तर मी खचितच त्यांचे रडणे ऐकेन. ");
INSERT INTO marc_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","मग माझा क्रोध पेटेल आणि मी तुम्हाला तलवारीने मारून टाकीन; आणि तुमची पत्नी विधवा व तुमची लेकरे अनाथ होतील. ");
INSERT INTO marc_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“तुमच्यामध्ये असलेल्या माझ्या गरजवंत लोकांना जर तुम्ही उसने पैसे दिले, तर त्यांच्याशी सावकारी व्यवहार करू नका; व व्याज लावू नका. ");
INSERT INTO marc_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","तुम्ही आपल्या शेजार्‍याचे पांघरूण मागून घेतले, तर सूर्यास्तापूर्वी ते परत करा, ");
INSERT INTO marc_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","कारण तुमच्या शेजार्‍याजवळ पांघरावयाला तेवढेच असेल, तर ते रात्री काय घेऊन झोपतील? आणि जेव्हा ते माझ्याकडे धावा करतील, तेव्हा मी त्यांचे ऐकेन, कारण मी दयाळू आहे. ");
INSERT INTO marc_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“तुम्ही परमेश्वराची निंदा करू नये किंवा तुमच्या लोकांच्या पुढार्‍यांपैकी कोणाला शाप देऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“आपल्या धान्यातून किंवा आपल्या फळातून द्यावयाचे दान देण्यास विलंब करू नये. “आपला प्रथम जन्मलेला पुत्र तुम्ही मला समर्पण करावा. ");
INSERT INTO marc_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","बैल व मेंढे यांच्याविषयी सुद्धा असेच करावे. त्यांना सात दिवस त्यांच्या आईजवळ राहू द्यावे, परंतु आठव्या दिवशी ते मला द्यावे. ");
INSERT INTO marc_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“तुम्ही माझे पवित्र लोक असावे. यास्तव हिंस्र श्वापदाने मारून टाकलेल्या प्राण्याचे मांस खाऊ नये; ते तुम्ही कुत्र्यांना घालावे. ");
INSERT INTO marc_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“तुम्ही खोट्या अफवा पसरवू नयेत. अन्यायाने साक्षीदार होऊन दोषी व्यक्तीला मदत करू नये. ");
INSERT INTO marc_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“दुष्कृत्य करण्याकरिता जमावाला अनुसरू नका आणि त्या जमावाशी एक होऊन न्यायवादात आपली साक्ष फिरवू नका, ");
INSERT INTO marc_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","आणि गरिबाच्या न्यायवादात तो दोषी असता, त्यावर दया दाखवू नये. ");
INSERT INTO marc_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“तुमच्या वैर्‍याचा बैल किंवा गाढव भटकलेला असा तुमच्या नजरेस पडला, तर ते तुम्ही अवश्य माघारी आणून परत करावे. ");
INSERT INTO marc_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","जे तुमचा द्वेष करतात त्यांचे गाढव ओझ्याखाली पडलेले तुम्हाला दिसले, ते तसेच सोडू नये; त्यांना अवश्य मदत करावी. ");
INSERT INTO marc_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“तुमच्यातील गरिबांच्या न्यायवादात त्यांचा न्याय नाकारला जाऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","खोट्या आरोपांपासून स्वतःला दूर ठेवावे आणि निरपराधी किंवा प्रामाणिक व्यक्तीला मरणदंड देऊ नये, कारण मी दोषी व्यक्तीला सोडणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“तुम्ही लाच घेऊ नये, कारण लाच डोळस व्यक्तीस आंधळे करते व निरपराध्याचे शब्द विपरीत करते. ");
INSERT INTO marc_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“परदेशी व्यक्तीस जाचू नका; परदेशी असणे काय आहे हे तुम्ही समजता, कारण तुम्हीही इजिप्त देशात परदेशी होता. ");
INSERT INTO marc_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“सहा वर्षे आपल्या भूमीत तुम्ही पेरणी करावी आणि पीक गोळा करावे, ");
INSERT INTO marc_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","परंतु सातव्या वर्षी जमीन नांगरू नये आणि न वापरता तशीच पडीक राहू द्यावी. मग तुमच्यातील गरीब लोकांना त्यातील अन्न मिळेल आणि त्यातूनही उरलेले वनपशू खातील. तुमचे द्राक्षमळे व जैतुनाच्या बागांविषयी सुद्धा असेच करावे. ");
INSERT INTO marc_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“सहा दिवस आपले काम करावे, पण सातव्या दिवशी काम करू नये, अशासाठी की तुमच्या बैलांना व गाढवांना विसावा मिळावा, तसेच तुमच्या घरात जन्मलेले गुलाम आणि तुमच्यामध्ये राहणारा परदेशी सुद्धा ताजेतवाने होऊ शकेल. ");
INSERT INTO marc_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“जे काही मी तुम्हाला सांगितले आहे ते काळजीपूर्वक पाळावे. इतर दैवतांचा धावा करू नये; तुमच्या मुखांनी त्यांचे नावही घेऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“वर्षातून तीन वेळा तुम्ही माझ्यासाठी सण पाळावेत. ");
INSERT INTO marc_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“बेखमीर भाकरीचा सण पाळावा; मी तुम्हाला आज्ञापिल्याप्रमाणे, सात दिवस बेखमीर भाकर खा. अवीव महिन्यात नेमलेल्या वेळेत असे करावे, कारण त्या महिन्यात तुम्ही इजिप्त देशातून बाहेर आला. “माझ्यासमोर कोणीही रिकाम्या हाताने येऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“जेव्हा तुम्ही तुमच्या शेतात पेरलेल्या पिकाचा हंगाम करता, तेव्हा त्याच्या प्रथमफळाने हंगामाचा सण पाळावा. “वर्षाच्या शेवटी आपल्या शेतातून तुम्ही हंगाम गोळा करता, तेव्हा संग्रहाचा सण पाळावा. ");
INSERT INTO marc_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“वर्षातून तीन वेळा तुमच्या सर्व पुरुषांनी सार्वभौम याहवेह यांच्यासमोर हजर व्हावे. ");
INSERT INTO marc_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“अर्पणातील रक्त खमिराबरोबर मला अर्पण करू नये. “मला अर्पण केलेल्या यज्ञपशूंची चरबी सकाळपर्यंत राहू देऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“तुमच्या भूमीच्या प्रथम उत्पन्नातील सर्वोत्तम भाग तुमचे परमेश्वर याहवेह यांच्या भवनात आणावा. “करडू त्याच्या आईच्या दुधात शिजवू नये. ");
INSERT INTO marc_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“पाहा, मार्गात तुझे रक्षण करावे व जो देश मी तुमच्यासाठी तयार करून ठेवला आहे, त्यात तुम्हाला घेऊन यावे म्हणून तुमच्यापुढे मी एक दूत पाठवित आहे. ");
INSERT INTO marc_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","त्याच्यापुढे सावध असा आणि तो जे काही सांगेल ते ऐका. त्याच्याविरुद्ध बंड करू नका; तो तुझ्या अपराधांची क्षमा करणार नाही, कारण माझे नाव त्याच्यामध्ये आहे. ");
INSERT INTO marc_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","जर तुम्ही काळजीपूर्वक त्याचे ऐकाल आणि मी जे सांगतो ते कराल, तर मी तुमच्या शत्रूंचा शत्रू होईन आणि जे तुमचा विरोध करतात, त्यांचा मी विरोधक होईन. ");
INSERT INTO marc_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","माझा दूत तुमच्यापुढे जाईल आणि तुम्हाला अमोरी, हिथी, परिज्जी, कनानी, हिव्वी व यबूसी यांच्या देशात पोहचवेल आणि मी त्या सर्वांचा नाश करेन. ");
INSERT INTO marc_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","त्यांच्या दैवतांना नमन करू नये किंवा त्यांची उपासना करू नये किंवा त्यांच्या चालीरीतींचे अनुसरण करू नये. तुम्ही त्या मोडून टाकाव्यात आणि त्यांच्या पवित्र दगडांचा चुरा करावा. ");
INSERT INTO marc_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तुमचे परमेश्वर याहवेह यांची सेवा करा, म्हणजे तुमच्या अन्नावर व पाण्यावर त्यांचा आशीर्वाद राहील. तुमच्यातून मी आजार नाहीसे करेन, ");
INSERT INTO marc_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","तुमच्या देशात कोणाचा गर्भपात होणार नाही, ना कोणी वांझ राहणार. तुमचा जीवनकाळ मी पूर्ण करेन. ");
INSERT INTO marc_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“तुम्ही जो देश जिंकून घ्याल त्यात मी आपले भय पाठवेन व त्यात गोंधळ निर्माण करेन. तुमचे शत्रू पाठ दाखवून पळ काढतील असे मी करेन. ");
INSERT INTO marc_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","हिव्वी, कनानी, हिथी या लोकांनी तुमच्या मार्गातून बाजूला व्हावे म्हणून मी तुमच्यापुढे गांधीलमाशा पाठवेन. ");
INSERT INTO marc_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","पण एका वर्षातच मी त्यांना घालवून देणार नाही, कारण देश ओसाड होईल आणि वनपशू तुमच्यासाठी पुष्कळ होतील. ");
INSERT INTO marc_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","तुमची संख्या वाढून तुम्ही त्या देशाचा ताबा घेईपर्यंत थोडेथोडे असे मी त्यांना तुमच्यापुढून घालवून देईन. ");
INSERT INTO marc_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“तांबड्या समुद्रापासून पलिष्ट्यांच्या समुद्रापर्यंत व वाळवंटापासून फरात नदीपर्यंत मी तुमची सीमा स्थापित करेन. त्या देशात राहणारे लोक मी तुमच्या हाती देईन आणि तुम्ही त्यांना आपल्या पुढून घालवून टाकाल. ");
INSERT INTO marc_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","त्यांच्याशी किंवा त्यांच्या दैवतांशी करार करू नये. ");
INSERT INTO marc_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","त्यांना तुमच्या देशात राहू देऊ नये, नाहीतर ते तुम्हाला माझ्याविरुद्ध पाप करण्यास प्रवृत्त करतील, कारण त्यांच्या दैवतांची उपासना करणे तुमच्यासाठी खचितच पाश असे होईल.” ");
INSERT INTO marc_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","मग याहवेहने मोशेला म्हटले, “तू आणि अहरोन, नादाब आणि अबीहू व इस्राएलींचे सत्तर वडील याहवेहकडे वर या. तुम्ही दुरूनच उपासना करावी, ");
INSERT INTO marc_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","परंतु मोशेने एकटेच याहवेहजवळ यावे; इतरांनी जवळ येऊ नये. लोकांनी त्यांच्याबरोबर वर येऊ नये.” ");
INSERT INTO marc_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मग मोशेने जाऊन याहवेहचे शब्द व नियम लोकांना सांगितले, त्यांनी एका आवाजात प्रतिसाद देत म्हटले, “याहवेहने जे सर्वकाही सांगितले त्याप्रमाणे आम्ही करू.” ");
INSERT INTO marc_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","मग याहवेहने मोशेला जे काही सांगितले होते ते सर्व त्याने लिहून ठेवले. दुसर्‍या दिवशी अगदी सकाळी मोशेने उठून पर्वताच्या पायथ्याशी एक वेदी बांधली व इस्राएलाच्या बारा गोत्रानुसार बारा खांब उभे केले. ");
INSERT INTO marc_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","मग त्याने इस्राएलचे तरुण पुरुष पाठविले व त्यांनी याहवेहला होमार्पणे व गोर्‍हे अर्पून शांत्यर्पण केले. ");
INSERT INTO marc_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मोशेने त्यातील अर्धे रक्त वाटीत घेतले व अर्धे वेदीवर शिंपडले. ");
INSERT INTO marc_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","मग मोशेने कराराचा ग्रंथ घेऊन लोकांपुढे वाचला. त्यांनी प्रतिसाद दिला, “याहवेहने सांगितले ते सर्वकाही आम्ही करू; आम्ही आज्ञापालन करू.” ");
INSERT INTO marc_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","मग मोशेने रक्त घेतले, लोकांवर शिंपडले आणि म्हणाला, “हे कराराचे रक्त आहे, जो याहवेहने त्यांच्या वचनानुसार तुमच्याबरोबर केला आहे.” ");
INSERT INTO marc_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","मग मोशे व अहरोन, नादाब व अबीहू व इस्राएलचे सत्तर वडील वर गेले. ");
INSERT INTO marc_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","आणि त्यांनी इस्राएलाच्या परमेश्वराला पाहिले. त्यांच्या पायाखाली नीलकांत पाषाणाच्या चिरेबंदी कामासारखे अगदी निरभ्र आकाशासारखे होते. ");
INSERT INTO marc_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","परंतु त्या इस्राएलाच्या वडिलांविरुद्ध परमेश्वराने आपला हात उगारला नाही; त्यांनी परमेश्वराला पाहिले आणि त्यांनी खाणेपिणे केले. ");
INSERT INTO marc_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","मग याहवेह मोशेला म्हणाले, “तू पर्वतावर माझ्याकडे ये आणि येथेच राहा आणि लोकांसाठी सूचना म्हणून नियम आणि आज्ञा ज्या मी दगडी पाट्यांवर लिहिल्या आहेत त्या मी तुला देईन.” ");
INSERT INTO marc_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","मग मोशे व त्याचा मदतनीस यहोशुआ उठले आणि मोशे पर्वतावर परमेश्वराकडे गेला. ");
INSERT INTO marc_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","तो वडीलजनांना म्हणाला, “आम्ही तुमच्याकडे परत येईपर्यंत येथेच थांबा, जर कोणाचा काही वाद असला तर त्यांनी अहरोन आणि हूर तुमच्याबरोबर आहेत, त्यांच्याकडे जावे.” ");
INSERT INTO marc_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","जेव्हा मोशे पर्वतावर गेला, मेघांनी पर्वत झाकून गेले, ");
INSERT INTO marc_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","आणि याहवेहचे वैभव सीनाय पर्वतावर येऊन राहिले. सहा दिवस मेघांनी सीनाय पर्वत झाकलेला होता आणि सातव्या दिवशी परमेश्वराने मेघांतून मोशेला आवाज दिला. ");
INSERT INTO marc_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्राएली लोकांना पर्वतावरील याहवेहचे वैभव भस्म करणार्‍या अग्नीप्रमाणे दिसले. ");
INSERT INTO marc_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","मग मोशेने मेघांमधून पर्वतावर प्रवेश केला आणि तो तिथे चाळीस दिवस व चाळीस रात्री राहिला. ");
INSERT INTO marc_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्राएली लोकांना सांग की, त्यांनी मला अर्पण आणावे. ज्यांना मनापासून देण्याची इच्छा आहे त्यांच्याकडून ते तू माझ्यावतीने स्वीकारावे. ");
INSERT INTO marc_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“त्यांच्यापासून तू जी अर्पणे स्वीकारावी ती ही आहेत: “सोने, चांदी आणि कास्य; ");
INSERT INTO marc_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","निळ्या, जांभळ्या व किरमिजी रंगाचे सूत आणि रेशमी ताग, बोकडाचे केस; ");
INSERT INTO marc_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","लाल रंगाने रंगविलेली मेंढ्याची कातडी व टिकाऊ चर्म; बाभळीचे लाकूड; ");
INSERT INTO marc_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","दिव्यासाठी जैतुनाचे तेल; अभिषेकाचे तेल व सुगंधी धूप यासाठी सुवासिक मसाले; ");
INSERT INTO marc_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","एफोदाच्या ऊरस्त्राणावर चढविण्यासाठी गोमेद खडे व इतर रत्ने. ");
INSERT INTO marc_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“मग मी त्यांच्यामध्ये वस्ती करावी, म्हणून त्यांनी माझ्यासाठी एक पवित्रस्थान बनवावे. ");
INSERT INTO marc_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","हा निवासमंडप आणि त्याची रचना मी दाखवेन त्याप्रमाणेच असावी. ");
INSERT INTO marc_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“त्यांनी बाभळीच्या लाकडाचा एक कोश तयार करावा—अडीच हात लांब व दीड हात रुंद, दीड हात उंच. ");
INSERT INTO marc_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","त्याला आतून व बाहेरून शुद्ध सोन्याचे आवरण द्यावे व त्याच्याभोवती सोन्याचा काठ करावा. ");
INSERT INTO marc_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","त्यासाठी सोन्याच्या चार कड्या बनवून कोशाच्या चार पायांना, दोन कड्या एका बाजूला व दोन कड्या दुसर्‍या बाजूला अशा त्या बसवाव्यात. ");
INSERT INTO marc_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","मग बाभळीच्या लाकडाचे दांडे बनवून त्यांना सोन्याचे आवरण द्यावे. ");
INSERT INTO marc_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","कोश वाहून नेण्यासाठी ते दांडे दोन्ही बाजूंच्या कड्यात घालाव्या. ");
INSERT INTO marc_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","या दांड्या कोशाच्या कड्यातच असाव्यात; त्या काढू नये. ");
INSERT INTO marc_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","मग कराराच्या नियमाच्या पाट्या ज्या मी तुला देणार, त्या तू कोशाच्या आत ठेवाव्यात. ");
INSERT INTO marc_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“प्रायश्चिताचे झाकण शुद्ध सोन्याचे बनवावे—ते अडीच हात लांब व दीड हात रुंद असावे. ");
INSERT INTO marc_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","मग झाकणाच्या टोकांना घडवून घेतलेल्या सोन्याचे दोन करूब करून ठेवावेत. ");
INSERT INTO marc_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एका बाजूस एक करूब आणि दुसर्‍या बाजूस दुसरे करूब असावे; ते करूब झाकणास दोन्ही बाजूंनी अखंड जोडून घ्यावे. ");
INSERT INTO marc_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","या करुबांची पंखे वरच्या बाजूने पसरून प्रायश्चिताच्या झाकणावर आच्छादले जावे. करुबाचे मुख समोरासमोर असून, त्यांची दृष्टी प्रायश्चिताच्या झाकणाकडे असावी. ");
INSERT INTO marc_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","हे प्रायश्चिताचे झाकण कोशाच्या वर ठेवावे आणि कराराच्या नियमाच्या पाट्या ज्या मी तुला देणार त्या कोशाच्या आत ठेवाव्यात. ");
INSERT INTO marc_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","तिथे, प्रायश्चिताच्या झाकणावर दोन करूब जे कोशावर ठेवलेले आहेत, त्यांच्यामध्ये मी तुला भेटेन आणि इस्राएल लोकांसाठी द्यावयाच्या सर्व आज्ञा मी तुला देईन. ");
INSERT INTO marc_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“बाभळीच्या लाकडाचा एक मेज बनवा; जो दोन हात लांब, एक हात रुंद व दीड हात उंच असावा. ");
INSERT INTO marc_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","त्याला शुद्ध सोन्याचे आवरण द्यावे आणि त्याभोवती सोन्याचा काठ करावा. ");
INSERT INTO marc_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","मेजाच्या सभोवती चार बोटे रुंदीएवढी पट्टी बनवून त्यावर सोन्याचा काठ करावा. ");
INSERT INTO marc_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","मेजाकरिता सोन्याच्या चार कड्या कराव्‍यात आणि त्या चार पायांच्या चार कोपर्‍यांवर लावाव्या. ");
INSERT INTO marc_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","मेज वाहून नेण्याच्या दांड्या धरण्यासाठी कड्या पट्टीच्या जवळ असाव्यात. ");
INSERT INTO marc_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","दांडे बाभळीच्या लाकडाचे असावेत, त्यांना सोन्याचे आवरण द्यावे आणि मेज वाहून नेण्यासाठी त्यांचा उपयोग करावा. ");
INSERT INTO marc_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","आणि अर्पणे ओतण्याकरिता मेजावरील ताटे, पात्रे, तसेच त्याचे कलश व वाट्या हे शुद्ध सोन्याचे असावे. ");
INSERT INTO marc_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","त्या मेजावर माझ्यासमोर समक्षतेची भाकर नेहमी ठेवलेली असावी. ");
INSERT INTO marc_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“शुद्ध सोन्याचा एक दीपस्तंभ बनवा. त्याची बैठक, त्याचा दांडा घडून कराव्या आणि त्याच्या फुलाच्या आकाराची फुलपात्रे, त्याच्यावरील कळ्या व फुले ही सर्व त्याबरोबर अखंड असावीत. ");
INSERT INTO marc_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","दीपस्तंभाच्या बाजूंनी सहा फांद्या निघाव्या; तीन एका बाजूला व तीन दुसर्‍या बाजूला. ");
INSERT INTO marc_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","एका फांदीवर बदामाच्या फुलांप्रमाणे कळ्या आणि फुले असलेल्या तीन वाट्या, पुढच्या फांदीवर तीन वाट्या आणि दीपस्तंभापासून पसरलेल्या सर्व सहा फांद्यांसाठी समान असावे. ");
INSERT INTO marc_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","आणि दीपस्तंभावर वाटीच्या आकाराची चार बदामाची फुले त्याच्या कळ्या व फुले बनवावे. ");
INSERT INTO marc_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","दीपस्तंभाच्या बाजूने निघालेल्या पहिल्या दोन फांद्यांच्या खालच्या बाजूस एक कळी असावी, दुसरी कळी दुसर्‍या दोन फांद्यांच्या खालच्या बाजूस, आणि तिसरी कळी तिसर्‍या फांदीच्या जोडीखाली असावी; सर्व मिळून सहा फांद्या असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","या सर्व कळ्या व फांद्या शुद्ध सोन्याच्या असून दीपस्तंभाला घडीव शुद्ध सोन्याच्या एकाच अखंड तुकड्यापासून असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“मग त्याचे सात दिवे तयार करून ते दीपस्तंभावर असे ठेवावे की त्यांचा प्रकाश त्यांच्यासमोर पडेल. ");
INSERT INTO marc_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","त्यांच्या वातीचे चिमटे व ते ठेवण्याची तबके शुद्ध सोन्याची असावी. ");
INSERT INTO marc_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","दीपस्तंभ व इतर उपकरणांसाठी एक तालांत शुद्ध सोन्याचा उपयोग करावा. ");
INSERT INTO marc_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","मी तुला पर्वतावर दाखविलेल्या नमुन्याप्रमाणेच ते सर्व काळजीपूर्वकपणे बनवावे.” ");
INSERT INTO marc_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“निळ्या, जांभळ्या व किरमिजी रंगांच्या तागाच्या व रेशमी तागाच्या दहा पडद्यांनी निवासमंडप तयार करावा, त्यावर कुशल कारागिरांकडून करूब विणून घ्यावे. ");
INSERT INTO marc_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","सर्व पडद्यांची लांबी अठ्ठावीस हात व रुंदी चार हात असावी. ");
INSERT INTO marc_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पाच पडदे एकमेकांना जोडलेले असावेत व इतर पाच पडद्यांचेही तसेच करावे. ");
INSERT INTO marc_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","जोडलेल्या पडद्यापैकी शेवटच्या पडद्यांच्या किनारीवर निळ्या रंगाच्या कापडाचे फासे बनवावे आणि दुसर्‍या पडद्यांच्या शेवटच्या पडद्यालाही तसेच करावे. ");
INSERT INTO marc_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","एका पडद्याच्या किनारीला पन्नास फासे व दुसर्‍या पडद्याच्या किनारीपर्यंत पन्नास फासे करावे, हे फासे समोरासमोर असावेत. ");
INSERT INTO marc_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","मग सोन्याचे पन्नास आकडे तयार करावेत आणि त्याचा उपयोग पडद्यांना एकत्र जोडण्यासाठी करावा की निवासमंडप अखंड होईल. ");
INSERT INTO marc_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“निवासमंडपावर आच्छादन करण्यासाठी बोकडाच्या केसाचे पडदे तयार करावेत; ते अकरा पडदे असावेत. ");
INSERT INTO marc_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","सर्व अकरा पडदे एकाच मापाचे, म्हणजे लांबी तीस हात व रुंदी चार हात. असावी. ");
INSERT INTO marc_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","पाच पडदे एकत्र व इतर सहा पडदे एकत्र असे जोडावेत. सहावा पडदा मंडपाच्या पुढील बाजूस दुमडावा. ");
INSERT INTO marc_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","जोडलेल्या पडद्यांपैकी शेवटच्या पडद्याच्या किनारीवर शेवटपर्यंत पन्नास फासे करून तो एकजोड करावा आणि दुसर्‍या पडद्यापैकी किनारीवर देखील पन्नास फासे करून एकजोड करावा. ");
INSERT INTO marc_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","मग कास्याचे पन्नास आकडे करावेत आणि ते फासात घालून असे जोडावे की तंबू एकजोड होईल. ");
INSERT INTO marc_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","तंबूच्या पडद्याचा उरलेला भाग, म्हणजे जो अर्धा पडदा उरतो, तो निवासमंडपाच्या मागच्या बाजूस टांगलेला असू द्यावा. ");
INSERT INTO marc_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","तंबूचे पडदे दोन्ही बाजूंनी एकएक हात अधिक लांब असावे; उरलेला पडदा निवासमंडपाला झाकेल असा लोंबत ठेवावा. ");
INSERT INTO marc_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","तंबूसाठी तांबडा रंग दिलेल्या मेंढ्याच्या कातड्याचे आच्छादन करावे आणि त्यावर टिकाऊ चर्माचे आच्छादन करावे. ");
INSERT INTO marc_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“निवासमंडपासाठी बाभळीच्या लाकडाच्या उभ्या फळ्या तयार कराव्‍यात. ");
INSERT INTO marc_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","प्रत्येक फळी दहा हात लांब व दीड हात रुंद असावी. ");
INSERT INTO marc_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","एक फळी दुसर्‍या फळीला जोडण्यासाठी त्यांच्या समोरासमोर दोन कुसे असावी. निवासमंडपाच्या प्रत्येक फळीला अशाप्रकारे कुसे बनवावी. ");
INSERT INTO marc_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","निवासमंडपाच्या दक्षिणेस वीस फळ्या बसवाव्यात. ");
INSERT INTO marc_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","आणि त्या फळ्यांखाली ठेवण्यासाठी चांदीच्या चाळीस बैठका कराव्‍यात—प्रत्येक फळीसाठी दोन बैठका, प्रत्येक कुसाखाली एक. ");
INSERT INTO marc_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","निवासमंडपाच्या दुसर्‍या बाजूला, म्हणजे उत्तरेला वीस फळ्या बनवाव्या ");
INSERT INTO marc_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","आणि प्रत्येक फळीखाली दोन अशा चांदीच्या चाळीस बैठका कराव्या. ");
INSERT INTO marc_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","निवासमंडपाच्या शेवटच्या बाजूसाठी, म्हणजे पश्चिम बाजूस सहा फळ्या तयार कराव्या, ");
INSERT INTO marc_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","आणि निवासमंडपाच्या मागच्या बाजूच्या कोपर्‍यांसाठी दोन फळ्या तयार कराव्या. ");
INSERT INTO marc_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","या दोन कोपर्‍यातील फळ्या खालपासून वरपर्यंत दुहेरी जोडीने एकाच कडीत जोडाव्यात; दोन्ही कोपर्‍यांच्या फळ्या एकसारख्याच असाव्यात. ");
INSERT INTO marc_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","एका फळीखाली दोन; अशा प्रकारे एकूण आठ फळ्या आणि चांदीच्या सोळा बैठका असतील. ");
INSERT INTO marc_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“बाभळीच्या लाकडाचे अडसर तयार करा: निवासमंडपाच्या एका बाजूच्या फळ्यांसाठी पाच अडसर असावे, ");
INSERT INTO marc_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","निवासमंडपाच्या दुसर्‍या बाजूला पाच आणि पश्चिमेच्या बाजूच्या म्हणजेच शेवटच्या बाजूच्या फळ्यांसाठी पाच अडसर असावे. ");
INSERT INTO marc_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","मध्यभागी लावण्याचे अडसर फळ्यांच्या मधून एका टोकापासून दुसर्‍या टोकापर्यंत पोहोचतील असे असावे. ");
INSERT INTO marc_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","फळ्यांना सोन्याचे आवरण लावावे आणि आडव्या खांबांना अडकविण्यासाठी सोन्याच्या कड्या बनवाव्या. आडव्या खांबांना सुद्धा सोन्याचे आवरण द्यावे. ");
INSERT INTO marc_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“मी तुला पर्वतावर दाखविल्याप्रमाणे नमुन्याप्रमाणे निवासमंडप तयार करावा. ");
INSERT INTO marc_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“निळ्या, जांभळ्या व किरमिजी रंगांच्या कातलेल्या रेशमी तागाचा पडदा करून त्यावर कुशल कारागिरांकडून करूब विणून घ्यावेत. ");
INSERT INTO marc_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","हा पडदा, बाभळीच्या लाकडाचे बनविलेले सोन्याचे आवरण देऊन चांदीच्या बैठकावर उभ्या असलेल्या चार खांबावर चार सोन्याच्या बैठकावर टांगावा. ");
INSERT INTO marc_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","पडदा आकड्यांवर टांगावा आणि कराराचा कोश पडद्यामागे ठेवावा. हा पडदा पवित्रस्थान व परमपवित्रस्थानाची साक्ष वेगळी करेल. ");
INSERT INTO marc_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","प्रायश्चिताचे झाकण परमपवित्रस्थानात कराराच्या कोशावर ठेवावे. ");
INSERT INTO marc_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","निवासमंडपाच्या पडद्याच्या बाहेर उत्तर दिशेला मेज ठेवावा आणि त्यासमोर दक्षिण दिशेला दीपस्तंभ ठेवावा. ");
INSERT INTO marc_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“निवासमंडपाच्या प्रवेशद्वारासाठी निळ्या, जांभळ्या व किरमिजी रंगांच्या रेशमी तागाचा नक्षीदार पडदा बनवावा. ");
INSERT INTO marc_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","या पडद्यासाठी सोन्याचे आकडे आणि सोन्याचे आवरण दिलेले बाभळीच्या लाकडाचे पाच खांब तयार करावेत आणि त्यांच्यासाठी कास्याच्या पाच बैठका तयार कराव्‍यात.” ");
INSERT INTO marc_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“बाभळीच्या लाकडाची वेदी तयार करावी, ती तीन हात उंच, पाच हात लांब व पाच हात रुंद असून ती चौकोनी असावी. ");
INSERT INTO marc_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","तिच्या चार कोपर्‍यांना प्रत्येकी एक शिंग बनवावे, शिंगे व वेदी अखंड असावी. वेदीला कास्याचे आवरण द्यावे. ");
INSERT INTO marc_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","वेदीवरील सर्व पात्रे, म्हणजेच राख उचलून नेण्याची भांडे, फावडे, शिंपडण्याचे भांडे, मांसाचे काटे आणि अग्निपात्रे कास्याचे असावीत. ");
INSERT INTO marc_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","तिच्यासाठी कास्याची जाळी तयार करावी आणि जाळीच्या चारही बाजूला कास्याच्या चार कड्या तयार कराव्या. ");
INSERT INTO marc_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","वेदीच्या काठाखाली ती अशाप्रकारे ठेवावी की ती वेदीच्या अर्ध्या उंचीपर्यंत यावी. ");
INSERT INTO marc_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","वेदीसाठी बाभळीच्या लाकडाचे दांडे तयार करून त्यांना कास्याचे आवरण द्यावे. ");
INSERT INTO marc_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","दांडे कड्यात असे घालावेत की, वेदी वाहून नेताना ते तिच्या दोन बाजूंनी असतील. ");
INSERT INTO marc_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","फळ्या लावून वेदी आतून पोकळ बनवावी. ती तुला पर्वतावर दाखविल्याप्रमाणेच बनवावी.” ");
INSERT INTO marc_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“निवासमंडपासाठी अंगण बनवावे. त्याची दक्षिणेकडील बाजू शंभर हात लांब असावी व त्यास कातलेल्या रेशमी तागाचे पडदे असावेत, ");
INSERT INTO marc_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","आणि वीस खांब व वीस कास्याच्या बैठका बनवाव्या, खांबावर चांदीच्या कड्या व पट्ट्या असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","उत्तरेकडील बाजू सुद्धा शंभर हात लांब असून तिलाही पडदे आणि वीस खांब व कास्याच्या वीस बैठका बनवाव्या, खांबाच्या कड्या व पट्ट्या चांदीच्या असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“अंगणाच्या पश्चिमेकडील बाजू पन्नास हात रुंदीची असावी व त्यासाठी पडदे, व दहा खांब व दहा बैठका असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","सूर्योदयाकडील पूर्वेकडील अंगण सुद्धा पन्नास हात रुंद असावे. ");
INSERT INTO marc_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","प्रवेशद्वाराच्या एका बाजूस पंधरा हात लांबीचा पडदा आणि तीन खांब व तीन बैठका असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","आणि दुसर्‍या बाजूला पंधरा हात लांबीचे पडदे, तीन खांब व तीन बैठका असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“अंगणाच्या प्रवेशद्वारासाठी, निळ्या जांभळ्या व किरमिजी रंगाच्या सुताचे व रेशमी तागाचा, वीस हात लांबीचा पडदा असावा; त्यावर भरतकाम केलेले असावे; त्यात चार खांब व चार बैठका असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","अंगणाच्या सभोवती असलेल्या सर्व खांबांना चांदीच्या पट्ट्या, कड्या व कास्याच्या बैठकी असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","अंगणाची लांबी शंभर हात, रुंदी पन्नास हात असावी व त्यास कातलेल्या रेशमी तागाचे पाच हात उंचीचे पडदे आणि कास्याच्या बैठकी असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","निवासमंडपातील सेवेसाठी लागणारी सर्व पात्रे व उपकरणे, त्यांच्या मेखा व अंगणाच्या सर्व मेखा कास्याच्या असाव्यात.” ");
INSERT INTO marc_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“इस्राएली लोकांना आज्ञा दे की दिवे अखंड पेटत राहावे म्हणून त्यांनी कुटून काढलेले जैतुनाचे शुद्ध तेल तुझ्याकडे आणावे. ");
INSERT INTO marc_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","सभामंडपातील जे पडदे कराराच्या कोशाला झाकतात त्याच्याबाहेर, अहरोन आणि त्याच्या पुत्रांनी याहवेहसमोर संध्याकाळपासून सकाळपर्यंत दिवे पेटत ठेवावे. इस्राएलात हा विधी पिढ्यान् पिढ्या असावा.” ");
INSERT INTO marc_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“तुझा भाऊ अहरोन व त्याचे पुत्र, नादाब, अबीहू, एलअज़ार व इथामार यांनी याजक म्हणून माझी सेवा करावी, यासाठी त्यांना इस्राएली लोकांमधून तुझ्याकडे आणावे. ");
INSERT INTO marc_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","अहरोन तुझा भाऊ याला सन्मान आणि गौरव मिळावा म्हणून त्याच्यासाठी पवित्र वस्त्रे तयार करावी. ");
INSERT INTO marc_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ज्यांना अशा बाबतीत मी ज्ञान दिले आहे, त्या सर्व कुशल कारागिरांना सांग की अहरोनाच्या पवित्रीकरणासाठी त्यांनी वस्त्रे बनवावी, यासाठी की त्याने याजक म्हणून माझी सेवा करावी. ");
INSERT INTO marc_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","त्यांनी जी वस्त्रे बनवावी ती ही: ऊरपट, एफोद, एक झगा, भरतकाम केलेला अंगरखा, फेटा व कमरबंद. त्यांनी ही पवित्र वस्त्रे तुझा भाऊ अहरोन व त्याच्या पुत्रांसाठी बनवावी, यासाठी की याजक म्हणून त्यांनी माझी सेवा करावी. ");
INSERT INTO marc_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","त्यांनी सोन्याचा आणि निळ्या, जांभळ्या व किरमिजी रंगांच्या सुताचा व रेशमी तागाचा वापर करावा. ");
INSERT INTO marc_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“एफोद सोन्याचा, निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा आणि बारीक कातलेल्या रेशमी तागाचा, कुशल कारागिराच्या हातांनी बनवा. ");
INSERT INTO marc_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","त्याच्या दोन कोपर्‍यांना दोन खांदेपट्ट्या जोडलेल्या असाव्या, म्हणजे ते बांधता येईल. ");
INSERT INTO marc_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","कुशलतेने विणलेला कमरबंद त्याच्यासारखाच असावा; एफोदाशी अखंड असा तो सोन्याचा, निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा व कातलेल्या रेशमी तागाचा असावा. ");
INSERT INTO marc_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“दोन गोमेद रत्ने घेऊन त्यावर इस्राएलाच्या पुत्रांची नावे कोरून घ्यावीत. ");
INSERT INTO marc_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","एका रत्नावर सहा व दुसर्‍यावर सहा अशी त्यांच्या जन्माच्या क्रमानुसार ती असावी. ");
INSERT INTO marc_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","मोलवान रत्ने कोरणारे मुद्रेची कोरणी करतात त्याप्रमाणे तू त्या दोन रत्नांवर इस्राएलांच्या पुत्रांची नावे कोरून घ्यावी व ती दोन्ही रत्ने सोन्याच्या जाळीदार साच्यात बसवावी. ");
INSERT INTO marc_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","आणि ते एफोदाच्या दोन खांदेपट्ट्यांवर इस्राएलच्या पुत्रांचे स्मारक म्हणून रत्ने लावावी. याहवेहसमोर स्मारक म्हणून अहरोनाने ही नावे आपल्या खांद्यांवर वागवावी. ");
INSERT INTO marc_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","सोन्याचे खाचे बनव ");
INSERT INTO marc_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","आणि पीळ घातलेल्या दोरीसारख्या शुद्ध सोन्याच्या दोन साखळ्या तयार करून खांदेपट्ट्यांवरील आकड्यात अडकवाव्या.” ");
INSERT INTO marc_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“मग निर्णय घेण्यासाठी कुशल कारागिरांकडून ऊरपट तयार करून घ्यावा. एफोदाप्रमाणे सोन्याची जर असलेला, निळ्या, जांभळ्या व किरमिजी रंगांचे सूत व कातलेल्या रेशमी तागाचा असावा. ");
INSERT INTO marc_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","तो चौकोनी असून दुहेरी दुमडलेला असावा व त्याची लांबी एक वीत व रुंदी एक वीत असावा. ");
INSERT INTO marc_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","मग त्यात चार रांगेत मोलवान रत्ने लावावी. पहिल्या रांगेत लाल, पुष्कराज व माणिक ही रत्ने असावी; ");
INSERT INTO marc_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दुसर्‍या रांगेत पाचू, नीलमणी व हिरे असावे; ");
INSERT INTO marc_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तिसर्‍या रांगेत तृणमणी, सूर्यकांत व पद्मराग ही असावीत; ");
INSERT INTO marc_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","चौथ्या रांगेत लसणा, गोमेद व यास्फे असावीत. ही सर्व रत्ने सोन्याच्या कोंदणात बसवावीत. ");
INSERT INTO marc_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","इस्राएलाच्या पुत्रातील प्रत्येकाच्या नावाने एक अशी बारा रत्ने असावीत, प्रत्येक रत्नावर इस्राएलाच्या बारापैकी एका गोत्राचे नाव मुद्रेप्रमाणे कोरले जावे. ");
INSERT INTO marc_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ऊरपटासाठी पीळ घातलेल्या दोरीप्रमाणे शुद्ध सोन्याच्या साखळ्या कराव्या. ");
INSERT INTO marc_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ऊरपटाच्या दोन्ही टोकास लावण्यासाठी सोन्याच्या दोन कड्या बनवाव्या. ");
INSERT INTO marc_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","त्या सोन्याच्या दोन साखळ्या ऊरपटाच्या टोकाला असलेल्या कड्यांमध्ये घालाव्या, ");
INSERT INTO marc_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","आणि साखळीची दुसरी दोन टोके साच्यात घालून एफोदाच्या समोरील बाजूने त्याच्या खांदेपट्टीला जोडून घ्याव्या. ");
INSERT INTO marc_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","सोन्याच्या दोन कड्या तयार कर व त्या ऊरपटाच्या दुसर्‍या दोन कोपर्‍यांना म्हणजे एफोदा जवळील आतील बाजूच्या काठाला जोडाव्या. ");
INSERT INTO marc_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","सोन्याच्या आणखी दोन कड्या करून त्या त्या एफोदाच्या खांदेपट्टीच्या खालच्या बाजूने समोरून, एफोदाच्या कमरबंदाच्या अगदी वर असलेल्या काठाला जोडाव्या. ");
INSERT INTO marc_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ऊरपटाच्या कड्या एफोदाच्या कड्यांना निळ्या दोरीने, कमरबंदाला जोडतील अशा बांधाव्या, म्हणजे ऊरपट एफोदावरून सरकणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“अहरोन जेव्हा पवित्रस्थानात जाईल, तेव्हा इस्राएलच्या पुत्रांची नावे असलेला निर्णयाचा ऊरपट एक नित्य स्मरण म्हणून आपल्या हृदयावर याहवेहसमोर घेऊन जाईल. ");
INSERT INTO marc_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","जेव्हा तो याहवेहच्या उपस्थितीत जाईल, तेव्हा अहरोनाने उरीम व थुम्मीम सुद्धा ऊरपटात, आपल्या हृदयावर ठेवून जावे. अशाप्रकारे अहरोनाने नित्यनेमाने इस्राएली लोकांसाठी निर्णय घेणार्‍या वस्तू आपल्या हृदयावर वाहत याहवेहसमोर यावे.” ");
INSERT INTO marc_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“एफोदाचा झगा संपूर्ण निळ्या कापडाने बनवावा. ");
INSERT INTO marc_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","डोके जाईल असे त्याला मधोमध उघडे ठेवावे. तो फाटू नये म्हणून त्याच्या तोंडाला गळपट्टीप्रमाणे विणलेला गोट असावा. ");
INSERT INTO marc_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","त्या झग्याच्या खालच्या घेर्‍यावर निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताची डाळिंबे व त्यामध्ये सोन्याच्या घंट्या बनवाव्या. ");
INSERT INTO marc_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","सोन्याच्या घंट्या व डाळिंबे एक सोडून एक असे आळीपाळीने झग्याच्या घेराला लावावे. ");
INSERT INTO marc_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","अहरोनाने तो झगा सेवा करीत असताना घालावा. जेव्हा तो याहवेहसमोर पवित्रस्थानात जातो व बाहेर येतो त्यावेळी घंट्यांचा आवाज ऐकू येईल, म्हणजे तो मरणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“शुद्ध सोन्याची एक पाटी तयार करावी आणि तिच्यावर मुद्रा कोरावी तशी ही अक्षरे कोरावीत: याहवेहसाठी पवित्र. ");
INSERT INTO marc_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","आणि ती जोडता यावी म्हणून ती फेट्याला निळ्या दोरीने बांध. ");
INSERT INTO marc_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ती पाटी अहरोनाच्या फेट्यासमोर कपाळावर राहील आणि तो इस्राएलांच्या पवित्र भेटीसंबंधीचे दोष वाहील, त्यांच्या कोणत्याही भेटी असो. ती पाटी नित्य अहरोनाच्या कपाळावर असावी, अशासाठी की लोकांच्या भेटी याहवेहला मान्य होतील.” ");
INSERT INTO marc_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“तलम तागाचा झगा विणून घ्यावा आणि रेशमी तागाचा फेटा तयार करावा. कमरबंद भरतकाम केलेला असावा. ");
INSERT INTO marc_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","अहरोनाच्या पुत्रांचा मान व आदर राखला जावा, म्हणून त्यांच्यासाठी झगे, कमरबंद व टोप्या बनवाव्या. ");
INSERT INTO marc_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","तुझा भाऊ अहरोन व त्याचे पुत्र यांच्या अंगावर ही वस्त्रे घातल्यावर, त्यांचा अभिषेक आणि समर्पण कर. त्यांनी याजक म्हणून माझी सेवा करावी म्हणून त्यांना पवित्र कर. ");
INSERT INTO marc_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“शरीराला झाकावे म्हणून तागाच्या कापडाचे, कंबरेपासून मांडीपर्यंत पोहोचेल अशी अंतर्वस्त्रे तयार करावी. ");
INSERT INTO marc_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","अहरोन व त्याचे पुत्र ज्यावेळी सभामंडपात येतील किंवा सेवेसाठी वेदीकडे पवित्रस्थानात जातील, त्यावेळी त्यांनी ती वस्त्रे घालावी, म्हणजे ते दोषी ठरून मरणार नाहीत. “अहरोन व त्याच्या वंशजांसाठी हा सर्वकाळचा नियम असावा.” ");
INSERT INTO marc_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“त्यांनी याजक या नात्याने माझी सेवा करावी म्हणून त्यांना पवित्र करण्यासाठी असेच करावे: एक निर्दोष गोर्‍हा व दोन मेंढे घ्यावेत. ");
INSERT INTO marc_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","आणि उत्तम गव्हाच्या पिठाच्या दोन बेखमीर गोल भाकरी कराव्या, त्या बेखमीर भाकरी आणि जैतुनाचे तेल मिसळून केलेल्या असाव्यात आणि बेखमीर पिठाच्या व जैतुनाचे तेल लावलेल्या पातळ भाकरी कराव्या. ");
INSERT INTO marc_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","त्यांना एका टोपलीत घालून, गोर्‍हा आणि दोन मेंढ्यांबरोबर सादर कराव्या. ");
INSERT INTO marc_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","मग अहरोन व त्याच्या पुत्रांना सभामंडपाच्या प्रवेशद्वाराशी आणून त्यांना पाण्याने धुवावे; ");
INSERT INTO marc_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","वस्त्रे घ्या आणि अहरोनास अंगरखा व त्याबरोबर एफोदाचा झगा, एफोद, ऊरपट हे परिधान करावे. त्यावर कुशलतेने विणलेल्या कमरपट्ट्याने एफोद बांधावा; ");
INSERT INTO marc_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","त्याच्या डोक्यावर फेटा घालावा व त्यास पवित्र मुद्रा जोडून घ्यावी. ");
INSERT INTO marc_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","मग अभिषेकाचे तेल घे व त्याच्या डोक्यावर ओतून त्याला अभिषेक करावा. ");
INSERT INTO marc_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","त्याच्या पुत्रांनाही झगे घालावे. ");
INSERT INTO marc_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","त्यांना फेटे बांधावे. मग अहरोनास व त्याच्या पुत्रांना कमरपट्टे बांधावे. याप्रमाणे याजकत्व कायमचे त्यांचेच असणार. “मग तू अहरोन व त्याच्या मुलांना अभिषेक करावा. ");
INSERT INTO marc_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“मग सभामंडपाच्या समोर गोर्‍हा आणावा व त्याच्या डोक्यावर अहरोन व त्याच्या पुत्रांनी आपले हात ठेवावेत. ");
INSERT INTO marc_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","सभामंडपाच्या प्रवेशद्वारात, याहवेहच्या समक्षतेत तो गोर्‍हा वधावा. ");
INSERT INTO marc_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","गोर्‍ह्याचे थोडे रक्त घेऊन ते तू आपल्या बोटांनी वेदीच्या शिंगांवर लावावे व शिल्लक राहिलेले रक्त वेदीच्या पायथ्याशी ओतावे. ");
INSERT INTO marc_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","मग त्याच्या आतड्यांवरील सर्व चरबी, काळजावरील लांब पाळ आणि त्यांच्या चरबीसह दोन्ही गुरदे घेऊन ती वेदीवर जाळावी. ");
INSERT INTO marc_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","परंतु गोर्‍ह्याचे मांस व त्याची विष्ठा व त्याची आतडी छावणीबाहेर नेऊन जाळून टाकाव्या. ते पापार्पण आहे. ");
INSERT INTO marc_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“मग त्यातील एक मेंढा घ्यावा व अहरोन व त्याच्या पुत्रांनी त्याच्या डोक्यावर आपले हात ठेवावे. ");
INSERT INTO marc_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","मेंढ्याचा वध करावा व त्याचे रक्त वेदीभोवती शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","मेंढा कापून तुकडे करावेत आणि त्याचे आतील अवयव व पाय धुऊन त्याचे तुकडे व डोके इतर भागांबरोबर ठेवावे. ");
INSERT INTO marc_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","मग संपूर्ण मेंढ्याचे वेदीवर होम कर. तो याहवेहसाठी होमार्पण आहे, ते सुवासिक असे, याहवेहसाठी सादर केलेले अन्नार्पण आहे. ");
INSERT INTO marc_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“मग दुसरा मेंढा घ्यावा व अहरोन व त्याच्या पुत्रांनी त्याच्या डोक्यावर आपले हात ठेवावेत. ");
INSERT INTO marc_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","मेंढ्याचा वध करून, त्याचे थोडे रक्त घेऊन अहरोन व त्याच्या पुत्रांच्या उजव्या कानाच्या पाळीला, उजव्या हाताच्या अंगठ्यांना, व उजव्या पायाच्या अंगठ्यांना लावावे, मग रक्त वेदीच्या सभोवती शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","आणि वेदीवरील काही रक्त व अभिषेकाचे तेल घे व ते अहरोन व त्याच्या वस्त्रांवर व त्याचे पुत्र व त्यांच्या वस्त्रांवर शिंपडावे. मग तो व त्याचे पुत्र आणि त्यांची वस्त्रे पवित्र होतील. ");
INSERT INTO marc_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“मग त्या मेंढ्याची चरबी, त्याचे जाड शेपूट, त्याच्या आतड्यांवरील चरबी, काळजाची लांब पाळ, दोन्ही गुरदे व त्यावरील चरबी व उजवी मांडी घ्यावी; हा समर्पणाचा मेंढा आहे. ");
INSERT INTO marc_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","बेखमीर भाकरीची टोपली, जी याहवेहसमोर आहे, त्यातून एक गोल भाकर घे, जैतुनाच्या तेलात मळलेली एक जाड भाकर आणि एक पातळ भाकर घे. ");
INSERT INTO marc_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","हे सर्व अहरोन व त्याच्या पुत्रांच्या हातांवर ठेवावे आणि त्यांनी ते याहवेहसमोर हेलावणीचे अर्पण घेऊन त्याची ओवाळणी करावी. ");
INSERT INTO marc_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","मग ते त्यांच्या हातातून घेऊन होमार्पणाबरोबर वेदीवर जाळावे, याहवेहला सुवास म्हणून अर्पिलेले अन्नार्पण असे सादर करावे. ");
INSERT INTO marc_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","मग अहरोनाच्या समर्पणाकरिता मेंढ्याच्या उराचा भाग घेऊन त्याला ओवाळणीचे अर्पण घेऊन याहवेहसमोर त्याची ओवाळणी कर आणि तो तुझा वाटा राहील. ");
INSERT INTO marc_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“समर्पणाच्या मेंढ्याचे ते भाग म्हणजेच, त्याचे ऊर ज्याची ओवाळणी केली होते व मांडीचा भाग जो सादर केला होता तो अहरोन आणि त्याच्या पुत्रांच्या मालकीचे आहे, ते भाग पवित्र कर. ");
INSERT INTO marc_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","हा नेहमीच इस्राएली लोकांकडून अहरोन व त्याच्या पुत्रांसाठी शाश्वत हिस्सा असावा. हे इस्राएली लोकांकडून शांत्यर्पणातून याहवेहस दिलेली वर्गणी असावी. ");
INSERT INTO marc_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“अहरोनाची पवित्र वस्त्रे त्याच्यानंतर त्याच्या वंशजांची व्हावीत अशासाठी की त्यामध्ये त्यांचा अभिषेक व समर्पण व्हावे. ");
INSERT INTO marc_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","त्याचा पुत्र जो याजक म्हणून त्याचा वारस होईल आणि सभामंडपात सेवा करण्यासाठी पवित्रस्थानात येईल त्याने ती वस्त्रे सात दिवस अंगात घालावी. ");
INSERT INTO marc_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“समर्पणासाठी असलेला मेंढा घेऊन पवित्र जागी त्याचे मांस शिजवावे. ");
INSERT INTO marc_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","मग अहरोन व त्याच्या पुत्रांनी सभामंडपाच्या प्रवेशद्वारात ते मेंढ्याचे मांस टोपलीतील समर्पित भाकरीसह खावी. ");
INSERT INTO marc_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","त्यांचे समर्पण आणि पवित्रीकरण करण्यासाठी प्रायश्चित्त केलेले अर्पण त्यांनी खावे. परंतु कोणी परक्याने ते खाऊ नये, कारण ते पवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","आणि समर्पणाच्या मेंढ्याचे मांस व भाकरीतील काही सकाळपर्यंत उरले तर ते जाळून टाकावे. ते खाऊ नये, कारण ते पवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“मी तुला आज्ञा दिल्याप्रमाणे अहरोन व त्याच्या पुत्रांसाठी तू करावे, त्यांच्या समर्पणास सात दिवस घ्यावे. ");
INSERT INTO marc_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","पापार्पण म्हणून दररोज तू एक गोर्‍हा प्रायश्चित्तासाठी अर्पण करावा. वेदीसाठी प्रायश्चित्त करून ती शुद्ध करावी व ती पवित्र करण्यासाठी तिला अभिषेक करावा. ");
INSERT INTO marc_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात दिवस वेदीसाठी प्रायश्चित करून ती पवित्र करावी. मग वेदी परमपवित्र होईल व ज्या कशाचा वेदीला स्पर्श होईल ते पवित्र होईल. ");
INSERT INTO marc_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“दररोज तू वेदीवर जे अर्पण करावयाचे आहे ते हे: एक वर्षाची दोन कोकरे. ");
INSERT INTO marc_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एक कोकरू सकाळी व दुसरे संध्याकाळी अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","पहिल्या कोकराबरोबर कुटून काढलेल्या जैतुनाच्या एक पाव हीन तेलात मळलेल्या पिठाचा एक एफाचा दहावा भाग आणि पेयार्पण म्हणून एक पाव हीन द्राक्षारस अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","संध्याकाळी दुसरे कोकरू सकाळच्या अर्पणाप्रमाणे धान्यार्पण व पेयार्पण यासहित अर्पण करावे. हे अन्नार्पण याहवेहसाठी सुवासिक अर्पण आहे. ");
INSERT INTO marc_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“हे होमार्पण येणार्‍या पिढ्यान् पिढ्या पर्यंत, याहवेहसाठी सभामंडपाच्या प्रवेशद्वारात नित्य करावे. तिथे मी तुला भेटेन व तुझ्याशी बोलेन. ");
INSERT INTO marc_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","तिथे मी इस्राएली लोकांना देखील भेटेन आणि ते ठिकाण माझ्या तेजाने पवित्र होईल. ");
INSERT INTO marc_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“तर मी सभामंडप व वेदी पवित्र करेन आणि अहरोन व त्याचे पुत्र यांना याजक म्हणून माझी सेवा करावी यासाठी पवित्र करेन. ");
INSERT INTO marc_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","मग मी इस्राएली लोकात राहीन आणि त्यांचा परमेश्वर होईन. ");
INSERT INTO marc_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","त्यांना समजेल की, ज्याने त्यांना इजिप्त देशातून बाहेर आणले तो मी याहवेह त्यांचा परमेश्वर आहे, यासाठी की, मी त्यांच्यामध्ये वस्ती करावी. मी याहवेह त्यांचा परमेश्वर आहे.” ");
INSERT INTO marc_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“धूप जाळण्यासाठी बाभळीच्या लाकडाची एक वेदी तयार करावी. ");
INSERT INTO marc_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ती चौरस असावी आणि तिची लांबी एक हात, रुंदी एक हात व उंची दोन हात असावी. तिची शिंगे तिच्याशी अखंड असावी. ");
INSERT INTO marc_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","तिचा वरचा भाग, तिच्या सर्व बाजू व शिंगे यांना शुद्ध सोन्याचे आवरण द्यावे व त्याभोवती सोन्याचा काठ करावा. ");
INSERT INTO marc_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","वेदीच्या खालच्या काठाला सोन्याच्या दोन कड्या कराव्या; वेदी वाहून नेण्यासाठी दांडे घालता येतील अशा समोरासमोर प्रत्येक बाजूला दोन कड्या असाव्या. ");
INSERT INTO marc_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","दांडे बाभळीच्या लाकडाचे करून त्याला सोन्याचे आवरण द्यावे. ");
INSERT INTO marc_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","कराराच्या कोशासमोर लावलेल्या पडद्याच्या बाहेरच्या बाजूस, प्रायश्चिताचे झाकण जे कराराच्या नियमाच्या पाटींवर आहे; तिथे वेदी ठेवावी; तिथेच मी तुला भेटत जाईन. ");
INSERT INTO marc_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“रोज सकाळी जेव्हा अहरोन दिव्याची तयारी करेल, त्यावेळी त्याने वेदीवर सुगंधी धूप जाळावा. ");
INSERT INTO marc_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","पुन्हा सायंकाळी दिवे लावायला तो येईल तेव्हा त्याने धूप जाळावा म्हणजे याहवेहसमोर नित्याने येणार्‍या पिढ्यांपर्यंत धूप जळत असावा. ");
INSERT INTO marc_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","या वेदीवर इतर कोणताही धूप, होमार्पण, अन्नार्पण किंवा पेयार्पण करू नये. ");
INSERT INTO marc_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","अहरोनाने वर्षातून एकदा वेदीच्या शिंगांवर प्रायश्चित करावे. हे वार्षिक प्रायश्चित येणार्‍या पिढ्यांपर्यंत पापार्पणाच्या रक्ताने करावे. हे याहवेहसाठी परमपवित्र आहे.” ");
INSERT INTO marc_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“तू इस्राएली लोकांना मोजण्यासाठी त्यांची जनगणना करशील, तेव्हा प्रत्येकाने आपली मोजणी झाल्यावर आपल्या जिवासाठी याहवेहस खंडणी द्यावी, म्हणजे तू त्यांची मोजणी करीत असताना त्यांच्यावर कोणतीही पीडा येणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","प्रत्येकजण ज्यांची मोजणी होईल, त्यांनी पवित्रस्थानाच्या शेकेलानुसार अर्धा शेकेल द्यावा, ज्याचे मोल वीस गेरे आहे. हा अर्धा शेकेल याहवेहसाठी अर्पण आहे. ");
INSERT INTO marc_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","जे वीस वर्षांचे व त्याहून अधिक वयाचे आहेत त्या सर्वांनी याहवेहसाठी हे अर्पण द्यावे. ");
INSERT INTO marc_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","जेव्हा आपल्या जिवासाठी खंडणी म्हणून तुम्ही याहवेहस अर्पण देता, तेव्हा श्रीमंताने अर्ध्या शेकेलापेक्षा अधिक देऊ नये व गरिबानेही कमी देऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","इस्राएली लोकांकडून प्रायश्चिताचा पैसा घेऊन तो सभामंडपाच्या सेवेकरिता लावावा. तुमच्या जिवासाठी केलेले प्रायश्चित इस्राएली लोकांसाठी याहवेहसमोर स्मारक म्हणून राहील.” ");
INSERT INTO marc_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“तू कास्याचे गंगाळ व त्याची कास्याची बैठक तयार करावी. ते सभामंडप व वेदीच्या मध्ये ठेवून त्यात पाणी भरावे ");
INSERT INTO marc_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","अहरोन व त्याच्या पुत्रांनी त्यातील पाण्याने आपले हात व पाय धुवावे. ");
INSERT INTO marc_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","जेव्हा ते सभामंडपात प्रवेश करतात, तेव्हा प्रत्येक वेळी त्यांनी आपले हात व पाय पाण्याने धुवावे म्हणजे ते मरणार नाहीत आणि जेव्हा ते याहवेहला अन्नार्पण करण्याची सेवा करण्यासाठी वेदीजवळ जातात, ");
INSERT INTO marc_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","त्यांनी आपले हात व पाय धुवावे म्हणजे ते मरणार नाहीत. हा नियम अहरोन व त्याच्या येणार्‍या वंशाच्या प्रत्येक पिढीसाठी असावा.” ");
INSERT INTO marc_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“पवित्रस्थानाच्या शेकेलानुसार हे उत्तम मसाले घे: पाचशे शेकेल गंधरस, त्याच्या अर्धे म्हणजे दोनशे पन्नास शेकेल सुगंधी दालचिनी, दोनशे पन्नास शेकेल सुगंधी वेखंड, ");
INSERT INTO marc_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","पाचशे शेकेल गोलाकार दालचिनी, सर्व पवित्रस्थानाच्या शेकेलानुसार, व एक हीन भरून जैतुनाचे तेल. ");
INSERT INTO marc_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","यातून पवित्र अभिषेकाचे तेल, सुगंधी द्रव्ये तयार करणार्‍याच्या कुशलतेप्रमाणे तयार करावे. ते पवित्र अभिषेकाचे तेल असेल. ");
INSERT INTO marc_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","त्या तेलाचा उपयोग सभामंडप, कराराच्या नियमाचा कोश, ");
INSERT INTO marc_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","मेज व त्याचे सामान, दीपस्तंभ व त्याची उपकरणे, धूपवेदी, ");
INSERT INTO marc_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","होमार्पणाची वेदी, तिची सर्व पात्रे, बैठकासह गंगाळ यांचा अभिषेक करण्यासाठी करावा. ");
INSERT INTO marc_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ते तू पवित्र करावे म्हणजे ते परमपवित्र होतील आणि ज्याला त्यांचा स्पर्श होईल ते पवित्र होईल. ");
INSERT INTO marc_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“याजक म्हणून माझी सेवा करावी म्हणून अहरोन व त्याच्या पुत्रांना अभिषेक करून त्यांना पवित्र कर. ");
INSERT INTO marc_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","इस्राएली लोकांना सांग, ‘येणार्‍या पिढ्यांपर्यंत हे माझे पवित्र अभिषेकाचे तेल असावे. ");
INSERT INTO marc_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","इतर कोणत्याही मनुष्याच्या शरीरावर ते ओतू नये आणि या मिश्रणाचा वापर करून दुसरे तेल बनवू नये. ते पवित्र आहे आणि तुम्ही त्याला पवित्र मानावे. ");
INSERT INTO marc_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जे कोणी याप्रकारे तेल तयार करेल आणि याजका व्यतिरिक्त इतर कोणाला लावेल, ते आपल्या लोकांतून काढून टाकले जातील.’ ” ");
INSERT INTO marc_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","मग याहवेह मोशेला म्हणाले, “गंधरस, जटामांसी व गंधाबिरुजा व शुद्ध ऊद हे सुगंधी मसाले घे, हे सर्व समान प्रमाणात असावे, ");
INSERT INTO marc_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","सुगंधी द्रव्ये तयार करणार्‍याच्या कुशलतेप्रमाणे सुगंधी धूप बनव. तो मीठ घातलेला, शुद्ध आणि पवित्र असावा. ");
INSERT INTO marc_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","त्यातील काही कुटून त्याची बारीक भुकटी करावी व ती सभामंडपातील कराराच्या नियमाच्या कोशापुढे ठेवावी, जिथे मी तुला भेटत जाईन. ती तुमच्यासाठी परमपवित्र असावी. ");
INSERT INTO marc_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","या मिश्रणाचा वापर करून स्वतःसाठी धूप तयार करू नये; याहवेहसाठी तो पवित्र मानला जावा. ");
INSERT INTO marc_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","त्या सुगंधाचा आनंद घेण्यासाठी जो कोणी याप्रकारचा धूप बनवेल, त्याला आपल्या लोकांतून काढून टाकले जावे.” ");
INSERT INTO marc_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“पाहा, मी यहूदाहच्या गोत्रातील, हूराचा पुत्र उरी याचा पुत्र बसालेल याला निवडले आहे. ");
INSERT INTO marc_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","व मी त्याला परमेश्वराचा आत्मा, ज्ञान, समज, बुद्धी आणि सर्वप्रकारच्या कुशलतेने भरले आहे— ");
INSERT INTO marc_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","सोने, चांदी आणि कास्याचे कलाकौशल्य करण्यासाठी; ");
INSERT INTO marc_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","आणि पाषाण फोडून रत्ने घडवावी, लाकडाचे काम आणि सर्वप्रकारचे कलात्मक कारागिरीचे काम करण्यासाठी. ");
INSERT INTO marc_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","त्याचप्रमाणे, त्याला मदत करण्यासाठी दान गोत्रातील अहीसामाक याचा पुत्र ओहोलियाब याला मी नेमले आहे. ");
INSERT INTO marc_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“जसे सभामंडप, कराराच्या नियमाचा कोश व त्यावरील प्रायश्चिताचे झाकण, आणि तंबूचे इतर सर्व साहित्य: ");
INSERT INTO marc_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","मेज व त्यावरील सर्व सामान, शुद्ध सोन्याचा दीपस्तंभ व त्याची सर्व उपकरणे, व धूपवेदी, ");
INSERT INTO marc_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","होमार्पणाची वेदी व तिची सर्व पात्रे, गंगाळ व त्याची बैठक. ");
INSERT INTO marc_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","तसेच विणलेली वस्त्रे, अहरोन याजकासाठी पवित्र वस्त्रे, व याजक म्हणून सेवा करतात तेव्हा त्याच्या पुत्रांसाठी वस्त्रे, ");
INSERT INTO marc_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अभिषेकाचे तेल व पवित्रस्थानासाठी सुगंधी धूप. ");
INSERT INTO marc_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“इस्राएली लोकांना सांग, ‘तुम्ही माझे शब्बाथ अवश्य पाळावेत. येणार्‍या पिढ्यांपर्यंत हे माझ्या व तुमच्यामध्ये चिन्ह राहील, यासाठी की तुम्ही जाणावे की जो तुम्हाला पवित्र करतो, तो मीच याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘शब्बाथ दिवस पाळावा, कारण तो तुम्हासाठी पवित्र आहे; जो कोणी तो अपवित्र करेल त्याला जिवे मारावे; जे कोणी त्या दिवशी काम करतील, त्यांना त्यांच्या लोकांतून काढून टाकले जावे. ");
INSERT INTO marc_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","सहा दिवस काम करावे, परंतु सातवा दिवस हा विसाव्याचा शब्बाथ आणि याहवेहसाठी पवित्र आहे; शब्बाथ दिवशी जो काम करेल त्याला जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इस्राएली लोकांनी निरंतरचा करार म्हणून पिढ्यान् पिढ्या शब्बाथ पाळावा. ");
INSERT INTO marc_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","तो माझ्यामध्ये व इस्राएली लोकांमध्ये सदासर्वकाळचे चिन्ह असेल, कारण याहवेहने सहा दिवसात आकाश व पृथ्वी निर्माण केली आणि सातव्या दिवशी त्यांनी स्वस्थ राहून विसावा घेतला.’ ” ");
INSERT INTO marc_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","जेव्हा याहवेहने सीनाय पर्वतावर मोशेबरोबर आपले बोलणे संपविले, तेव्हा त्यांनी मोशेला कराराच्या नियमाच्या दोन दगडी पाट्या दिल्या, ज्या परमेश्वराच्या बोटाने कोरलेल्या होत्या. ");
INSERT INTO marc_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","मोशेला पर्वतावरून खाली येण्यास उशीर होत आहे असे लोकांनी पाहिले, तेव्हा ते अहरोना सभोवती गोळा झाले व म्हणाले, “ये, आमच्यापुढे जातील अशी दैवते आमच्यासाठी बनव. हा मनुष्य ज्याने आम्हाला इजिप्तच्या बाहेर आणले, त्या मोशेचे काय झाले हे आम्हाला माहीत नाही.” ");
INSERT INTO marc_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","अहरोनाने त्यांना उत्तर दिले, “तुमच्या स्त्रिया, तुमचे पुत्र व तुमच्या कन्यांनी घातलेले कानातील सोन्याचे डूल काढून, ते माझ्याकडे आणा.” ");
INSERT INTO marc_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","म्हणून सर्व लोकांनी ते कानातील सोन्याचे डूल काढून ते अहरोनाकडे आणले. ");
INSERT INTO marc_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","लोकांनी जे अहरोनाच्या हातात दिले, ते घेऊन त्याने हत्याराने कोरून, वासराची ओतीव मूर्ती बनविली. मग ते म्हणाले, “हे इस्राएला, ही तुमचे दैवते आहेत, ज्यांनी तुम्हाला इजिप्तमधून बाहेर आणले.” ");
INSERT INTO marc_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","अहरोनाने जेव्हा हे पाहिले, तेव्हा त्याने त्या वासरासमोर एक वेदी बांधली व जाहीर केले, “उद्या याहवेहसाठी एक उत्सव करावयाचा आहे.” ");
INSERT INTO marc_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","म्हणून दुसर्‍या दिवशी लोक लवकर उठले आणि होमार्पणाचा यज्ञ केला व शांत्यर्पणे आणले. त्यानंतर त्यांनी बसून खाणेपिणे केले व उठून चैनबाजीची मजा घेऊ लागले. ");
INSERT INTO marc_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","मग याहवेह मोशेला म्हणाले, “खाली जा, कारण तुझे लोक, ज्यांना तू इजिप्तमधून बाहेर आणलेस, ते भ्रष्ट झाले आहेत. ");
INSERT INTO marc_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","मी त्यांना दिलेल्या आज्ञांपासून ते फार लवकरच फिरले आहेत आणि आपल्यासाठी वासराची ओतीव मूर्ती तयार केली आहे. त्यांनी त्याच्यासमोर नमन केले आहे आणि यज्ञ करून म्हटले आहे, ‘हे इस्राएला, ही तुमची दैवते आहेत, ज्यांनी तुम्हाला इजिप्तमधून बाहेर काढले आहे!’ ” ");
INSERT INTO marc_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","याहवेह मोशेला पुन्हा म्हणाले, “मी या लोकांना पाहिले आहे, ते ताठ मानेचे लोक आहेत. ");
INSERT INTO marc_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","तर आता माझ्या आड येऊ नकोस. माझा राग मी त्यांच्याविरुद्ध भडकवीन आणि मी त्यांचा नाश करेन. मग मी तुला एक मोठे राष्ट्र बनवीन.” ");
INSERT INTO marc_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","पण याहवेह त्याचे परमेश्वर यांची कृपादृष्टी व्हावी म्हणून विनंती करत मोशे म्हणाला, “याहवेह, तुमचे लोक ज्यांना तुम्ही महान सामर्थ्याने आणि बलवान हाताने इजिप्तमधून बाहेर आणले, त्यांच्याविरुद्ध तुमचा राग का पेटावा? ");
INSERT INTO marc_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","इजिप्तच्या लोकांनी असे का म्हणावे की, याहवेहने त्यांना डोंगरात मारून टाकावे व या पृथ्वीतून नाहीसे करावे अशा दुष्ट हेतूने बाहेर काढले? आपल्या तीव्र कोपापासून माघार घ्या; सौम्य व्हा आणि आपल्या लोकांवर आपत्ती आणू नका. ");
INSERT INTO marc_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","आपले सेवक अब्राहाम, इसहाक व इस्राएल यांची आठवण करा, ज्यांच्याशी आपण स्वतःच्या नावाने शपथ घेतलीः ‘मी तुझे वंशज आकाशातील तार्‍यांइतके करेन, आणि त्यांना अभिवचन दिल्याप्रमाणे हा सर्व देश मी त्यांच्या वंशजांना देईन, आणि तो सदासर्वकाळासाठी त्यांचे वतन राहील.’ ” ");
INSERT INTO marc_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तेव्हा याहवेहने त्याविषयी अनुताप केला व जी विपत्ती आपल्या लोकांवर आणण्याचे म्हटले होते ती आणली नाही. ");
INSERT INTO marc_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","मग मोशे आपल्या हातात कराराच्या नियमाच्या दोन पाट्या घेऊन पर्वतावरून खाली उतरला. त्या पाट्यांवर दोन्ही बाजूंनी, मागे व पुढे लेख कोरलेले होते. ");
INSERT INTO marc_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","त्या पाट्या परमेश्वराची कृती होती; तो लेख परमेश्वराची लेखणी होती, जी पाट्यांवर कोरलेली होती. ");
INSERT INTO marc_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","जेव्हा यहोशुआने लोकांचा ओरडण्याचा आवाज ऐकला, तो मोशेला म्हणाला, “छावणीत युद्धाचा आवाज आहे.” ");
INSERT INTO marc_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मोशेने उत्तर दिले: “हा आवाज विजयाचा नाही, तो आवाज पराजयाचाही नाही; मला गाण्याचा आवाज ऐकू येत आहे.” ");
INSERT INTO marc_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","जेव्हा मोशे छावणीजवळ आला आणि वासरू व नृत्य पाहिले, तेव्हा त्याचा राग पेटला आणि आपल्या हातातील पाट्या फेकून, डोंगराच्या पायथ्याशी फोडून त्यांचा चुराडा केला. ");
INSERT INTO marc_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","आणि त्याने ते वासरू घेतले जे लोकांनी घडविले होते व ते अग्नीत जाळून टाकले; मग त्याने त्याची कुटून बारीक पूड केली, ती पाण्यात विरघळून इस्राएलच्या लोकांना प्यायला दिली. ");
INSERT INTO marc_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","मग मोशे अहरोनाला म्हणाला, “या लोकांनी तुला काय केले, म्हणून तू त्यांना एवढ्या मोठ्या पापात आणले?” ");
INSERT INTO marc_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","अहरोन म्हणाला, “माझ्या स्वामी, क्रोधित होऊ नको, तुला माहीत आहे की हे लोक कसे दुष्टतेकडे प्रवृत्त होतात. ");
INSERT INTO marc_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ते मला म्हणाले, ‘आमच्यापुढे जातील अशी दैवते आमच्यासाठी बनव. हा मनुष्य ज्याने आम्हाला इजिप्तच्या बाहेर आणले, त्या मोशेचे काय झाले हे आम्हाला माहीत नाही.’ ");
INSERT INTO marc_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","म्हणून मी त्यांना म्हणालो, ‘ज्यांच्याकडे सोन्याचे दागिने आहेत ते त्यांनी काढावे.’ मग त्यांनी ते सोने मला दिले, आणि मी ते अग्नीत टाकले, आणि त्यातून हे वासरू बाहेर आले.” ");
INSERT INTO marc_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मोशेने पाहिले की, लोक मोकाट सुटले आहेत आणि त्यांच्या शत्रूंसमोर एक चेष्टेचे कारण बनावे असे अहरोनाने त्यांना मोकळे सोडले आहे. ");
INSERT INTO marc_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","म्हणून मोशे छावणीच्या प्रवेशद्वाराजवळ उभा राहिला व म्हणाला, “जे कोणी याहवेहच्या पक्षाचे आहे, त्यांनी माझ्याकडे यावे.” तेव्हा लेवीचे सर्व लोक त्याच्याकडे आले. ");
INSERT INTO marc_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","मग मोशे त्यांना म्हणाला, “याहवेह इस्राएलांचे परमेश्वर असे म्हणतात: ‘प्रत्येकाने आपली तलवार कंबरेस बांधावी. छावणीतून एका टोकापासून दुसर्‍या टोकापर्यंत फिरत, प्रत्येकाने आपला भाऊ आणि मित्र व शेजारी यांना जिवे मारून टाकावे.’ ” ");
INSERT INTO marc_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","मोशेने आज्ञापिल्याप्रमाणे लेवीच्या लोकांनी केले आणि त्या दिवशी अंदाजे तीन हजार लोक मरण पावले. ");
INSERT INTO marc_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","तेव्हा मोशे म्हणाला, “आज तुम्ही याहवेहसाठी वेगळे केले गेले आहात आणि याहवेहने आज तुम्हाला आशीर्वाद दिला आहे, कारण तुम्ही आपले पुत्र, भाऊ यांच्याविरुद्ध गेलात.” ");
INSERT INTO marc_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","मग दुसर्‍या दिवशी मोशे लोकांना म्हणाला, “तुम्ही मोठे पाप केले आहे, पण आता मी वर याहवेहकडे जाईन; कदाचित मी तुमच्या पापासाठी प्रायश्चित करू शकेन.” ");
INSERT INTO marc_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","मग मोशे याहवेहकडे परत गेला आणि म्हणाला, “अरेरे, या लोकांनी केवढे मोठे पाप केले आहे! त्यांनी आपल्या स्वतःसाठी सोन्याचे दैवत केले आहेत. ");
INSERT INTO marc_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","परंतु आता कृपा करून त्यांच्या पापांची क्षमा करा—नाहीतर जे पुस्तक तुम्ही लिहिले आहे, त्यातून माझे नाव मिटवून टाका.” ");
INSERT INTO marc_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","तेव्हा याहवेहने मोशेला उत्तर दिले, “ज्यांनी माझ्याविरुद्ध पाप केले आहे, त्यांचीच नावे मी माझ्या पुस्तकातून मिटवून टाकीन. ");
INSERT INTO marc_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","आता जा आणि ज्या ठिकाणाविषयी मी बोललो त्याकडे लोकांना चालव आणि माझा दूत तुमच्यापुढे जाईल. तथापि, जेव्हा शिक्षा करण्याची वेळ येईल, तेव्हा मी त्यांना त्यांच्या पापाची शिक्षा देईन.” ");
INSERT INTO marc_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","अहरोनाने केलेल्या वासराशी लोकांनी जे केले होते त्यासाठी याहवेहने त्यांच्यावर पीडा आणून त्यांना शासन केले. ");
INSERT INTO marc_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","नंतर याहवेह मोशेला म्हणाले, “तू आणि ज्या लोकांना तू इजिप्तमधून बाहेर आणले त्यांना घेऊन या ठिकाणातून नीघ आणि मी अब्राहाम, इसहाक आणि याकोब यांना शपथ घेऊन अभिवचन दिले, ‘हा देश मी तुझ्या वंशजांना देईन’ त्या देशाकडे घेऊन जा. ");
INSERT INTO marc_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","मी तुमच्यापुढे एक दूत पाठवून कनानी, अमोरी, हिथी, परिज्जी, हिव्वी आणि यबूसी या लोकांना बाहेर हाकलून देईन. ");
INSERT INTO marc_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","दूध व मध वाहत असलेल्या देशाकडे जा. परंतु मी तुमच्याबरोबर येणार नाही, कारण तुम्ही ताठ मानेचे लोक आहात आणि कदाचित वाटेत मी तुमचा नाश करेन.” ");
INSERT INTO marc_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","जेव्हा लोकांनी हे निराशाजनक शब्द ऐकले, तेव्हा ते शोक करू लागले आणि कोणीही कोणत्याही प्रकारचे दागिने घातले नाही. ");
INSERT INTO marc_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","कारण याहवेहने मोशेला सांगितले होते, “इस्राएलच्या लोकांना सांग, तुम्ही ताठ मानेचे लोक आहात. मी एक क्षणभरही तुमच्याबरोबर गेलो तर कदाचित मी तुमचा नाश करेन. आता तुमचे दागिने काढा आणि तुमचे काय करावे हे मी ठरवेन.” ");
INSERT INTO marc_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","म्हणून इस्राएल लोकांनी होरेब पर्वताजवळ आपले दागिने काढून टाकले. ");
INSERT INTO marc_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","आता छावणीबाहेर थोड्या दूर अंतरावर मोशे एक तंबू उभारीत असे, त्याला तो “सभामंडप असे म्हणे.” ज्याला याहवेहशी बोलायचे असेल तो छावणीबाहेर असलेल्या त्या सभामंडपाकडे जात असे. ");
INSERT INTO marc_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","आणि जेव्हा मोशे बाहेर मंडपाकडे जाई, तेव्हा सर्व लोक आपआपल्या तंबूच्या दाराशी उठून उभे राहून मोशे मंडपामध्ये जाईपर्यंत त्याला पाहत असत. ");
INSERT INTO marc_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","आणि जेव्हा मोशे मंडपामध्ये प्रवेश करी, तेव्हा याहवेह मोशेशी बोलेपर्यंत, मेघस्तंभ खाली उतरून मंडपाच्या दाराशी थांबत असे. ");
INSERT INTO marc_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","जेव्हा लोक मेघस्तंभ मंडपाच्या दाराशी थांबलेला पाहत, ते सर्व आपआपल्या तंबूच्या दाराशी उभे राहून उपासना करीत असत. ");
INSERT INTO marc_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","जसा एखादा व्यक्ती आपल्या मित्राशी बोलतो तसे याहवेह मोशेशी समोरासमोर बोलत असत. मग मोशे छावणीकडे परत जात असे, परंतु त्याचा तरुण सहकारी, नूनाचा पुत्र यहोशुआ हा मंडप सोडून जात नसे. ");
INSERT INTO marc_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मग मोशे याहवेहशी बोलला, “तुम्ही मला सांगत आला, ‘या लोकांना चालव,’ परंतु माझ्याबरोबर तुम्ही कोणाला पाठविणार हे तुम्ही मला सांगितले नाही. तुम्ही म्हणाला, ‘मी तुला नावाने ओळखतो आणि तू माझ्या दृष्टीने कृपा पावला आहेस.’ ");
INSERT INTO marc_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","जर तुम्ही माझ्यावर संतुष्ट असाल, तर मला तुमचे मार्ग शिकवा, यासाठी की मी तुम्हाला जाणून तुमच्या दृष्टीत कृपा पावावी. हे स्मरणात असू द्या की हे राष्ट्र तुमचे लोक आहेत.” ");
INSERT INTO marc_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","यावर याहवेहने उत्तर दिले, “माझी समक्षता तुझ्याबरोबर जाईल आणि मी तुला विसावा देईन.” ");
INSERT INTO marc_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","मग मोशे याहवेहला म्हणाला, “जर तुमची समक्षता आमच्याबरोबर गेली नाही, तर आम्हाला येथून पुढे पाठवू नका. ");
INSERT INTO marc_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","तुम्ही आम्हाबरोबर आला नाही, तर माझ्यावर आणि आपल्या लोकांवर तुमची कृपादृष्टी झाली आहे की नाही हे कसे कळणार? मी व तुमचे लोक पृथ्वीवरील इतर सर्व लोकांपासून वेगळे आहोत हे कसे समजणार?” ");
INSERT INTO marc_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","यावर याहवेहने मोशेला म्हटले, “जी गोष्ट तू माझ्याकडे मागितली आहे तीच मी करेन, कारण तुझ्यावर मी संतुष्ट आहे आणि मी तुला नावाने ओळखतो.” ");
INSERT INTO marc_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","तेव्हा मोशेने विनंती केली, “आता मला तुमचे गौरव दाखवा.” ");
INSERT INTO marc_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","आणि याहवेह म्हणाले, “मी माझे सर्व चांगुलपण तुझ्यापुढून चालवेन आणि याहवेह म्हणून माझ्या नावाची घोषणा मी तुझ्यासमक्ष करेन. ज्याच्यावर मला कृपा करावयाची त्याच्यावर मी कृपा करेन आणि ज्याच्यावर मला दया करावयाची त्याच्यावर मी दया करेन.” ");
INSERT INTO marc_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","याहवेह म्हणाले, “पण तू माझा चेहरा पाहू शकणार नाहीस, कारण मला पाहिल्यानंतर कोणीही मनुष्य जगत नाही.” ");
INSERT INTO marc_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","मग याहवेह म्हणाले, “माझ्याजवळ एक जागा आहे, जिथे एका खडकावर तू उभा राहा. ");
INSERT INTO marc_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","माझे गौरव जवळून जात असता, मी तुला खडकाच्या कपारीत ठेवेन आणि मी पार होईपर्यंत मी तुला माझ्या हाताने झाकीन. ");
INSERT INTO marc_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","मग मी माझा हात काढून घेईन आणि तू माझी पाठ पाहशील; पण माझा चेहरा तुला दिसणार नाही.” ");
INSERT INTO marc_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","मग याहवेह मोशेला म्हणाले, “पहिल्या पाट्यांसारख्याच दोन दगडी पाट्या तू घडव, मग तू फोडून टाकलेल्या पहिल्या पाट्यांवर जी वचने होते ते मी त्यावर लिहेन. ");
INSERT INTO marc_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","तू सकाळी तयार राहा आणि मग सीनाय पर्वतावर ये. तिथे डोंगरमाथ्यावर माझ्यासमोर स्वतःला सादर कर. ");
INSERT INTO marc_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तुझ्याबरोबर कोणीही येऊ नये किंवा डोंगरावर कुठेही इतर कोणी दृष्टीस पडू नये; गुरे आणि शेरडेमेंढरे यांनी सुद्धा डोंगरासमोर चरू नये.” ");
INSERT INTO marc_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","मग मोशेने पहिल्यासारख्या दोन दगडी पाट्या घडवून घेतल्या आणि त्या दोन दगडी पाट्या आपल्या हातात घेऊन याहवेहने आज्ञा दिल्याप्रमाणे मोठ्या पहाटे सीनाय पर्वतावर गेला. ");
INSERT INTO marc_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","मग याहवेह ढगामध्ये खाली उतरले आणि तिथे मोशेसमोर उभे राहिले. तिथे त्यांनी याहवेह या आपल्या नावाची घोषणा केली. ");
INSERT INTO marc_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","आणि याहवेह मोशे समोरून जाताना घोषणा केली, “याहवेह, याहवेह, दयाळू व कृपाळू परमेश्वर, मंदक्रोध, प्रीती व विश्वासूपण यात उदंड, ");
INSERT INTO marc_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हजारांवर प्रीती करणारे, दुष्टता, अपराध व पाप यांची क्षमा करणारे; तरीही याहवेह दोषीला निर्दोष असे सोडत नाहीत; तर आईवडिलांच्या पापाचे शासन त्यांच्या संततीवर, व त्यांच्या संततीच्या तिसर्‍या व चौथ्या पिढीपर्यंत देणारे आहे.” ");
INSERT INTO marc_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","तेव्हा मोशेने भूमीस लवून उपासना केली. ");
INSERT INTO marc_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","तो म्हणाला, “हे प्रभू, तुमच्या दृष्टीने मी जर कृपा पावलो असलो, तर प्रभूने आमच्याबरोबर जावे. जरी हे लोक ताठ मानेचे आहेत, तरी आमच्या दुष्टाईची व आमच्या पापाची क्षमा करून आपले वतन म्हणून आमचा स्वीकार करा.” ");
INSERT INTO marc_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","तेव्हा याहवेहने उत्तर दिले: “मी तुझ्याशी एक करार करीत आहे. तुझ्या लोकांसमोर मी असे चमत्कार करेन की जे संपूर्ण पृथ्वीवर कोणत्याही राष्ट्रात करण्यात आले नाहीत. ज्या लोकांमध्ये तू राहतो ते पाहतील की मी, याहवेहने तुझ्यासाठी केलेली कृत्ये किती भयावह आहेत. ");
INSERT INTO marc_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","मी तुला आज जे आज्ञापितो ते तू पाळावे. मी तुमच्यापुढून अमोरी, कनानी, हिथी, परिज्जी, हिव्वी आणि यबूसी यांना घालवून देईन. ");
INSERT INTO marc_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ज्या देशात तुम्ही जात आहात त्यात राहत असलेल्या लोकांशी करार करू नये याविषयी सावध असा, नाहीतर ते तुमच्यासाठी पाश असे होतील. ");
INSERT INTO marc_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","त्यांच्या वेद्या मोडून टाका, त्यांच्या पवित्र पाषाणांचा चुरा करा आणि अशेराचे स्तंभ तोडून टाका. ");
INSERT INTO marc_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","इतर कोणत्याही दैवतांची उपासना करू नका, कारण याहवेह, ज्यांचे नाव ईर्ष्यावान आहे, ते ईर्ष्यावान परमेश्वर आहेत. ");
INSERT INTO marc_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“त्या देशात राहत असलेल्या लोकांशी करार करू नये याविषयी सावध असा; कारण ते जेव्हा त्यांच्या दैवतांशी व्यभिचार करतात आणि त्यांना यज्ञ करतात, ते तुम्हाला आमंत्रित करतील आणि तुम्ही त्यांच्या यज्ञार्पणातील अन्न खाल. ");
INSERT INTO marc_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","आणि जेव्हा तुम्ही त्यांच्यातील काही कन्या तुमच्या पुत्रांसाठी पत्नी म्हणून निवडाल आणि त्या कन्या त्यांच्या दैवतांशी व्यभिचार करतील, त्या तुमच्या मुलांनाही तसेच करण्यासाठी प्रवृत्त करतील. ");
INSERT INTO marc_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“तुम्ही आपल्यासाठी कोणतीही मूर्ती करू नका. ");
INSERT INTO marc_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“बेखमीर भाकरीचा सण पाळा. मी तुम्हाला आज्ञापिल्याप्रमाणे, सात दिवस बेखमीर भाकर खा. अबीब महिन्यात नेमीत वेळी ते करावे, कारण त्या महिन्यात तुम्ही इजिप्तमधून बाहेर निघाला होता. ");
INSERT INTO marc_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“प्रत्येक उदरातील प्रथम जन्मलेला, तुमच्या गुरातील सर्व प्रथम जन्मलेले नर, मग ते खिल्लारातील असो किंवा मेंढरांतील असो माझे आहेत. ");
INSERT INTO marc_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गाढवाचे प्रथमवत्स कोकरू देऊन खंडणी भरून सोडवून घ्यावा, परंतु तो जर तुम्ही खंडणी भरून सोडविला नाही तर, त्याची मान मोडावी. तुमच्या सर्व प्रथम पुत्रांना खंडणी भरून सोडवावे. “कोणीही माझ्यासमोर रिकाम्या हाताने येऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“सहा दिवस तुम्ही काम करावे, परंतु सातव्या दिवशी तुम्ही विसावा घ्यावा; नांगरणीच्या व कापणीच्या हंगामात सुद्धा तुम्ही विसावा घ्यावा. ");
INSERT INTO marc_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“गव्हाच्या कापणीच्या वेळी प्रथम पिकाने सप्ताहाचा उत्सव साजरा करावा आणि वर्षाच्या शेवटी हंगामाचा सण पाळावा. ");
INSERT INTO marc_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","वर्षातून तीन वेळा तुमच्या सर्व पुरुषांनी सार्वभौम याहवेह, इस्राएलचे परमेश्वर यांच्यासमोर हजर व्हावे. ");
INSERT INTO marc_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","मी सर्व राष्ट्रांना तुमच्यापुढून घालवून टाकीन आणि तुमची सीमा वाढवेन आणि जेव्हा तुम्ही याहवेह तुमचे परमेश्वर यांच्यासमोर हजर होण्यासाठी जाल, त्यावेळी इतर कोणीही तुमच्या देशाचा लोभ धरणार नाही. ");
INSERT INTO marc_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“अर्पणातील रक्त खमिराबरोबर मला अर्पण करू नये. आणि वल्हांडण सणाच्या यज्ञातील काहीही सकाळपर्यंत राहू देऊ नये. ");
INSERT INTO marc_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“तुमच्या भूमीच्या प्रथम उत्पन्नातील सर्वोत्तम भाग तुमचे परमेश्वर याहवेह यांच्या भवनात आणावा. “करडू त्याच्या आईच्या दुधात शिजवू नये.” ");
INSERT INTO marc_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","मग याहवेह मोशेला म्हणाले, “हे शब्द लिही, कारण या शब्दांनुसार मी तुझ्याशी व इस्राएलाशी करार केला आहे.” ");
INSERT INTO marc_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मोशे त्या ठिकाणी भाकरी न खाता किंवा पाणी न पिता चाळीस दिवस व चाळीस रात्र याहवेहबरोबर राहिला आणि त्याने पाट्यांवर कराराचे शब्द, म्हणजेच दहा आज्ञा लिहिल्या. ");
INSERT INTO marc_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","जेव्हा मोशे आपल्या हातात कराराच्या नियमाच्या दोन दगडी पाट्या घेऊन सीनाय पर्वतावरून खाली उतरून आला, तेव्हा याहवेहबरोबर बोलल्यामुळे त्याचा चेहरा तेजस्वी झाला होता, हे त्याच्या लक्षात आले नाही. ");
INSERT INTO marc_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","जेव्हा अहरोन व सर्व इस्राएल लोकांनी मोशेला पाहिले, त्याचा चेहरा तेजस्वी होता आणि ते त्याच्याजवळ येण्यास घाबरत होते. ");
INSERT INTO marc_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","पण मोशेने त्यांना बोलाविले; म्हणून अहरोन व समुदायाचे वडीलजन परत त्याच्याजवळ गेले व तो त्यांच्याबरोबर बोलला. ");
INSERT INTO marc_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","यानंतर सर्व इस्राएली लोक त्याच्याजवळ आले आणि मोशेने त्यांना त्या सर्व आज्ञा दिल्या, ज्या याहवेहने सीनाय पर्वतावर त्याला दिल्या होत्या. ");
INSERT INTO marc_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","मोशेने लोकांशी आपले संभाषण संपविले व आपल्या चेहर्‍यावर पडदा घातला. ");
INSERT INTO marc_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","पण जेव्हा मोशे याहवेहबरोबर बोलण्यासाठी त्यांच्या समक्षतेत जात असे, बाहेर जाईपर्यंत तो पडदा काढत असे. जेव्हा तो बाहेर येई व त्याला जे काही आज्ञापिले गेले आहे ते तो इस्राएली लोकांना सांगत असे, ");
INSERT INTO marc_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्राएली लोकांनी पाहिले की मोशेचा चेहरा तेजस्वी होता. मग मोशे याहवेहबरोबर बोलावयास जाईपर्यंत आपल्या चेहर्‍यावर पडदा परत घालत असे. ");
INSERT INTO marc_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मग मोशेने इस्राएली लोकांच्या संपूर्ण समुदायाला बोलाविले व त्यांना म्हटले, “ज्यागोष्टी तुम्ही कराव्या अशी याहवेहनी आज्ञा दिली आहे, त्या या आहेत: ");
INSERT INTO marc_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","सहा दिवस तुम्ही काम करावे, परंतु सातवा दिवस तुमचा पवित्र दिवस असेल, हा याहवेहप्रीत्यर्थ शब्बाथ विसाव्याचा दिवस असावा. जो कोणी या दिवशी काम करेल, त्याला जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","शब्बाथ दिवशी तुमच्या कोणत्याही घरामध्ये विस्तव पेटवू नये.” ");
INSERT INTO marc_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मोशे सर्व इस्राएल समुदायाला म्हणाला, “याहवेहने जे आज्ञापिले आहे ते हे: ");
INSERT INTO marc_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","तुमच्याजवळ जे काही आहे, त्यातून याहवेहसाठी अर्पण घ्या. ज्या कोणास याहवेहसाठी अर्पण आणावे अशी इच्छा आहे, त्यांनी हे अर्पण आणावे: “सोने चांदी आणि कास्य, ");
INSERT INTO marc_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","निळ्या, जांभळ्या व किरमिजी रंगाचे सूत आणि रेशमी ताग; बोकडाचे केस; ");
INSERT INTO marc_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","लाल रंगाने रंगविलेली मेंढ्याची कातडी व टिकाऊ चर्म; बाभळीचे लाकूड; ");
INSERT INTO marc_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","दिव्यासाठी जैतुनाचे तेल; अभिषेकाचे तेल व सुगंधी धूप यासाठी सुवासिक मसाले; ");
INSERT INTO marc_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","एफोदाच्या ऊरस्त्राणावर चढविण्यासाठी गोमेद खडे व इतर रत्ने. ");
INSERT INTO marc_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“तुमच्यामध्ये जे सर्व कुशल कारागीर आहेत, त्यांनी येऊन जे सर्वकाही याहवेहने आज्ञापिले आहे ते तयार करावे: ");
INSERT INTO marc_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“निवासमंडप, त्याचा तंबू आणि त्याचे आच्छादन, आकडे, फळ्या, अडसर, खांब व बैठका; ");
INSERT INTO marc_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","कोश व त्याचे दांडे आणि प्रायश्चिताचे झाकण व त्याचा पडदा; ");
INSERT INTO marc_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","मेज व त्याचे दांडे आणि त्याचे सर्व सामान आणि समक्षतेची भाकर; ");
INSERT INTO marc_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","प्रकाशासाठी दीपस्तंभ व त्याची सर्व उपकरणे, दिवे आणि प्रकाशासाठी तेल; ");
INSERT INTO marc_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धूपवेदी व तिचे दांडे, अभिषेकाचे तेल व सुगंधी धूप; निवासमंडपाच्या प्रवेशद्वारासाठी पडदा; ");
INSERT INTO marc_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होमार्पणाची वेदी, तिची कास्याची जाळी, तिचे दांडे व तिचे सर्व साहित्य; कास्याचे गंगाळ व त्याची बैठक; ");
INSERT INTO marc_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","अंगणाचे पडदे, त्यांच्या खुंट्या व बैठका आणि अंगणाच्या दाराचा पडदा; ");
INSERT INTO marc_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","निवासमंडप, त्याचे अंगण व त्यांच्या मेखा व त्यांच्या दोर्‍या; ");
INSERT INTO marc_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्रस्थानात सेवा करताना घालावयाची विणलेली वस्त्रे; आणि याजक म्हणून घालावयाची अहरोन याजकासाठी पवित्र वस्त्रे व त्याच्या पुत्रांची वस्त्रे.” ");
INSERT INTO marc_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","मग इस्राएलचा सर्व समुदाय मोशेच्या समक्षतेतून निघून गेला, ");
INSERT INTO marc_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","आणि ज्यांची इच्छा असेल व ज्यांच्या हृदयाला स्फूर्ती मिळाली त्यांनी सभामंडपाच्या कामासाठी व त्याच्या सेवेसाठी आणि पवित्र वस्त्रांची अर्पणे याहवेहसाठी आणली. ");
INSERT INTO marc_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ज्या कोणाला इच्छा झाली, त्या स्त्री आणि पुरुषांनी येऊन सर्वप्रकारचे सोन्याचे दागिने, रत्नखचित पीना, कानातील डूल, अंगठ्या आणि दागिने आणले. त्या सर्वांनी आपले सोने याहवेहसाठी ओवाळणीचे अर्पण म्हणून दिले. ");
INSERT INTO marc_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ज्यांच्याकडे निळे, जांभळे किंवा किरमिजी कापड किंवा रेशमी तागाचे होते किंवा बोकडाचे केस, लाल रंगविलेली मेंढ्याची कातडी किंवा टिकाऊ चर्म होते ते आणले. ");
INSERT INTO marc_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","चांदी किंवा कास्याची अर्पणे आणणार्‍यांनी ती याहवेहसाठी आणली आणि ज्या कोणाकडे बाभळीचे लाकूड होते, ते त्यांनी बांधकामाच्या कोणत्याही भागात उपयोगी पडेल असे म्हणून आणले. ");
INSERT INTO marc_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","प्रत्येक कुशल स्त्रीने निळे, जांभळे आणि किरमिजी सूत व रेशमी ताग जे तिने आपल्या हाताने विणले होते ते आणले. ");
INSERT INTO marc_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","आणि ज्या सर्व स्त्रियांना इच्छा झाली आणि ज्या सूतकताईत कुशल होत्या त्यांनी बोकडाचे केस कातले. ");
INSERT INTO marc_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","पुढार्‍यांनी एफोद व ऊरपट यावर लावण्यासाठी गोमेद व इतर रत्ने आणली. ");
INSERT INTO marc_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","त्याचप्रमाणे त्यांनी दिव्यासाठी आणि अभिषेकासाठी आणि सुवासिक धुपासाठी जैतुनाचे तेल व सुगंधी मसाले आणले. ");
INSERT INTO marc_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","याहवेहने मोशेद्वारे जे काम आज्ञापिले होते त्यासाठी इस्राएली लोकांमधील सर्व इच्छुक पुरुष व स्त्रियांनी याहवेहकरिता स्वखुशीने अर्पणे आणली. ");
INSERT INTO marc_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","मग मोशे इस्राएली लोकांना म्हणाला, “पाहा, याहवेहने यहूदाहच्या गोत्रातील, हूराचा पुत्र, उरी याचा पुत्र बसालेल याला निवडले आहे, ");
INSERT INTO marc_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","आणि याहवेहने त्याला परमेश्वराचा आत्मा, ज्ञान, समज, बुद्धी आणि सर्वप्रकारच्या कुशलतेने भरले आहे— ");
INSERT INTO marc_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","सोने, चांदी आणि कास्याचे कलाकौशल्य करावे, ");
INSERT INTO marc_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","आणि पाषाण फोडून रत्ने घडवावी, लाकडाचे काम आणि सर्वप्रकारचे कलात्मक कारागिरीचे काम करावे. ");
INSERT INTO marc_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","आणि याहवेहने त्याला व दान गोत्रातील अहीसामाक याचा पुत्र ओहोलियाब या दोघांना इतरांनाही शिकविण्याची क्षमता दिली आहे. ");
INSERT INTO marc_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","याहवेहने त्यांना सर्वप्रकारचे कोरीव काम, कारागिरीचे काम, निळ्या, जांभळ्या व किरमिजी रंगाचे सुती व रेशमी तागावर भरतकाम, विणकाम; अशा सर्वप्रकारच्या विणकरांना कारागिरीचे—कौशल्याचे—काम करण्याच्या दानांनी भरले आहे. ");
INSERT INTO marc_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","मग बसालेल, ओहोलियाब आणि सर्व निपुण व्यक्ती, ज्यांना याहवेहने कुशलता व पवित्रस्थानाचे बांधकाम करण्याचे कौशल्य आणि क्षमता दिली आहे, त्यांनी याहवेहने आज्ञापिल्याप्रमाणेच काम करावे.” ");
INSERT INTO marc_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","मग बसालेल व ओहोलियाब व ज्यांना याहवेहने क्षमता दिली होती आणि ज्यांना येऊन काम करण्याची इच्छा होती त्यांना मोशेने बोलाविले. ");
INSERT INTO marc_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","पवित्रस्थानाच्या बांधकामासाठी इस्राएल लोकांनी आणलेली अर्पणे मोशेकडून त्यांनी घेतली. लोक दररोज सकाळी स्वैच्छिक अर्पणे आणत राहिले. ");
INSERT INTO marc_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","मग सर्व कुशल कारागीर जे पवित्रस्थानाचे काम करीत होते, त्यांनी ते पूर्वी करीत असलेले काम सोडले, ");
INSERT INTO marc_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","व मोशेला म्हणाले, “याहवेहने आज्ञापिलेल्या कामासाठी आवश्यक आहे त्यापेक्षा अधिक सामुग्री लोक आणत आहेत.” ");
INSERT INTO marc_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तेव्हा मोशेने आज्ञा दिली आणि सर्व छावणीत कळविण्यात आले: “कोणी पुरुषाने किंवा स्त्रीने पवित्रस्थानासाठी कोणतेही अर्पण करू नये.” अशाप्रकारे अधिक सामुग्री आणण्यापासून लोकांना थांबविण्यात आले, ");
INSERT INTO marc_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","कारण जी सामुग्री त्यांच्याजवळ होती, ती सर्व कामाच्या आवश्यकतेपेक्षा अधिक होती. ");
INSERT INTO marc_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","सर्व कुशल कारागिरांनी निळ्या, जांभळ्या व किरमिजी रंगांच्या तागाच्या व रेशमी तागाच्या दहा पडद्यांनी निवासमंडप तयार केला व त्यावर कुशल कारागिरांकडून करूब विणून घेतले. ");
INSERT INTO marc_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","सर्व पडद्यांची लांबी अठ्ठावीस हात व रुंदी चार हात होती. ");
INSERT INTO marc_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","त्यांनी पाच पडदे एकमेकांना जोडले व इतर पाच पडद्यांचेही तसेच केले. ");
INSERT INTO marc_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","जोडलेल्या पडद्यापैकी शेवटच्या पडद्यांच्या किनारीवर त्यांनी निळ्या रंगाच्या कापडाचे फासे बनविले आणि दुसर्‍या पडद्यांच्या शेवटच्या पडद्यालाही तसेच केले. ");
INSERT INTO marc_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","तसेच त्यांनी एका पडद्याच्या किनारीला पन्नास फासे व दुसर्‍या पडद्याच्या किनारीपर्यंत तसेच पन्नास फासे केले, हे फासे समोरासमोर होते. ");
INSERT INTO marc_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","मग त्यांनी सोन्याचे पन्नास आकडे तयार केले आणि त्याचा उपयोग पडद्याच्या दोन जोड्या एकत्र बांधण्यासाठी केला, यासाठी की निवासमंडप अखंड होईल. ");
INSERT INTO marc_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","निवासमंडपावर आच्छादन करण्यासाठी त्यांनी बोकडाच्या केसाचे पडदे तयार केले; ते अकरा पडदे होते. ");
INSERT INTO marc_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","सर्व अकरा पडदे एकाच मापाचे, म्हणजे लांबी तीस हात व रुंदी चार हात होती. ");
INSERT INTO marc_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","त्यांनी पाच पडदे एकत्र जोडले आणि इतर सहा पडदे एकत्र जोडले. ");
INSERT INTO marc_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","जोडलेल्या पडद्यांपैकी शेवटच्या पडद्याच्या किनारीवर पन्नास फासे करून तो एकजोड केला आणि दुसर्‍या पडद्याच्या किनारीवर देखील पन्नास फासे करून एकजोड केला. ");
INSERT INTO marc_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","मग त्यांनी कास्याचे पन्नास आकडे तयार केले आणि ते फासात घालून तंबू एकजोड केला. ");
INSERT INTO marc_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","मग त्यांनी तंबूसाठी तांबडा रंग दिलेल्या मेंढ्याच्या कातड्याचे आच्छादन केले आणि त्यावर टिकाऊ चर्माचे आच्छादन केले. ");
INSERT INTO marc_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","त्यांनी निवासमंडपासाठी बाभळीच्या लाकडाच्या उभ्या फळ्या तयार केल्या. ");
INSERT INTO marc_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","प्रत्येक फळी दहा हात लांब व दीड हात रुंद होती. ");
INSERT INTO marc_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","एक फळी दुसर्‍या फळीला जोडण्यासाठी त्यांच्या समोरासमोर दोन कुसे केली. निवासमंडपाच्या प्रत्येक फळीला त्यांनी अशाप्रकारे कुसे केली. ");
INSERT INTO marc_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","निवासमंडपाच्या दक्षिणेस त्यांनी वीस फळ्या तयार केल्या ");
INSERT INTO marc_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","आणि त्या फळ्यांखाली ठेवण्यासाठी चांदीच्या चाळीस बैठका केल्या—प्रत्येक फळीसाठी दोन बैठका, प्रत्येक कुसाखाली एक. ");
INSERT INTO marc_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","निवासमंडपाच्या दुसर्‍या बाजूला, म्हणजे उत्तरेला त्यांनी वीस फळ्या तयार केल्या ");
INSERT INTO marc_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","आणि प्रत्येक फळीखाली दोन, अशा चांदीच्या चाळीस बैठका केल्या. ");
INSERT INTO marc_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","निवासमंडपाच्या शेवटच्या बाजूसाठी, म्हणजे पश्चिम बाजूस त्यांनी सहा फळ्या तयार केल्या. ");
INSERT INTO marc_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","आणि निवासमंडपाच्या मागच्या बाजूच्या कोपर्‍यांसाठी त्यांनी दोन फळ्या तयार केल्या. ");
INSERT INTO marc_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","या दोन कोपर्‍यातील फळ्या खालपासून वरपर्यंत दुहेरी असून एकाच कडीत जोडल्या होत्या; दोन्ही कोपर्‍यांच्या फळ्या एकसारख्याच होत्या. ");
INSERT INTO marc_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","एका फळीखाली दोन; अशा प्रकारे एकूण आठ फळ्या आणि चांदीच्या सोळा बैठका होत्या. ");
INSERT INTO marc_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","त्याचप्रमाणे त्यांनी निवासमंडपाच्या एका बाजूच्या फळ्यांसाठी बाभळीच्या लाकडाचे पाच अडसर तयार केले, ");
INSERT INTO marc_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","निवासमंडपाच्या दुसर्‍या बाजूला पाच आणि पश्चिमेच्या बाजूच्या म्हणजेच शेवटच्या बाजूच्या फळ्यांसाठी पाच अडसर होते. ");
INSERT INTO marc_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","मध्यभागी लावण्याचे अडसर फळ्यांच्या मधून एका टोकापासून दुसर्‍या टोकापर्यंत पोहोचतील असे तयार केले. ");
INSERT INTO marc_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","त्यांनी फळ्यांना सोन्याचे आवरण लावले आणि आडव्या खांबांना अडकविण्यासाठी सोन्याच्या कड्या केल्या. त्यांनी आडव्या खांबांना सुद्धा सोन्याचे आवरण दिले. ");
INSERT INTO marc_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","मग त्यांनी निळ्या, जांभळ्या व किरमिजी रंगांच्या तागाच्या व रेशमी तागाचे पडदे बनविले व त्यावर कुशल कारागिरांकडून करूब विणून घेतले. ");
INSERT INTO marc_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","त्यासाठी त्यांनी बाभळीच्या लाकडाचे चार खांब केले व त्यावर सोन्याचे आवरण घातले. त्यासाठी त्यांनी सोन्याच्या कड्या व चांदीच्या चार बैठका बनविल्या. ");
INSERT INTO marc_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","त्यांनी निवासमंडपाच्या प्रवेशद्वारासाठी निळ्या, जांभळ्या व किरमिजी रंगाच्या रेशमी तागाचा नक्षीदार पडदा तयार केला. ");
INSERT INTO marc_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","मग त्यांनी पाच खांब व त्यांच्या कड्या बनविल्या. त्या खांबांचा वरचा भाग व बांधे यांना सोन्याचे आवरण घातले आणि त्यांच्या कास्याच्या पाच बैठका बनविल्या. ");
INSERT INTO marc_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","मग बसालेलाने बाभळीच्या लाकडाचा कोश तयार केला—अडीच हात लांब व दीड हात रुंद, दीड हात उंच होता. ");
INSERT INTO marc_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","त्यावर त्याने आतून व बाहेरून शुद्ध सोन्याचे आवरण घातले आणि त्याच्याभोवती सोन्याचा काठ केला. ");
INSERT INTO marc_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","त्याने त्यासाठी सोन्याच्या चार कड्या केल्या आणि त्याच्या चार पायांना दोन कड्या एका बाजूला व दोन कड्या दुसर्‍या बाजूला लावल्या. ");
INSERT INTO marc_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","मग त्याने बाभळीच्या लाकडाचे दांडे बनवून त्यांना सोन्याचे आवरण घातले. ");
INSERT INTO marc_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","आणि ते दांडे कोश वाहून नेण्यासाठी कोशाच्या दोन्ही बाजूंच्या कड्यात घातले. ");
INSERT INTO marc_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","नंतर त्याने शुद्ध सोन्याचे प्रायश्चिताचे झाकण बनविले; जे अडीच हात लांब व दीड हात रुंद होते. ");
INSERT INTO marc_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","झाकणाच्या टोकांना त्याने घडवून घेतलेल्या सोन्याचे दोन करूब बनविले. ");
INSERT INTO marc_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","एका बाजूस एक करूब आणि दुसर्‍या बाजूस दुसरे करूब बनविले; झाकणास दोन्ही बाजूंनी अखंड जोडून घेतले. ");
INSERT INTO marc_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","या करुबांची पंखे वरच्या बाजूने पसरून प्रायश्चिताच्या झाकणावर आच्छादन करीत होते. करुबांची मुखे समोरासमोर असून त्यांची दृष्टी प्रायश्चिताच्या झाकणाकडे होती. ");
INSERT INTO marc_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","मग त्यांनी बाभळीच्या लाकडाचा एक मेज बनविला; जो दोन हात लांब, एक हात रुंद व दीड हात उंच होता. ");
INSERT INTO marc_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","मग त्यांनी त्याला शुद्ध सोन्याचे आवरण घातले आणि त्याभोवती सोन्याचा काठ बनविला. ");
INSERT INTO marc_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","मग त्यांनी त्याच्याभोवती चार बोटे रुंदीएवढी पट्टी बनवून, त्यावर सोन्याचा काठ तयार केला. ");
INSERT INTO marc_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","मग त्यांनी मेजाकरिता सोन्याच्या चार कड्या तयार करून त्या चार पायांच्या चार कोपर्‍यांवर बसविल्या. ");
INSERT INTO marc_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","मेज वाहून नेण्याच्या दांड्या धरण्यासाठी कड्या पट्टीच्या जवळ लावल्या. ");
INSERT INTO marc_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","मेज वाहून नेण्यासाठी असलेले दांडे बाभळीच्या लाकडाचे बनविले होते व त्यांना सोन्याचे आवरण घातले होते. ");
INSERT INTO marc_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","आणि अर्पणे ओतण्याकरिता मेजावरील उपकरणे म्हणजे ताटे, पात्रे व वाट्या व त्याचे कलश हे त्यांनी शुद्ध सोन्याचे बनविले. ");
INSERT INTO marc_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","मग त्यांनी शुद्ध सोन्याचा दीपस्तंभ बनविला. त्याची बैठक, त्याचा दांडा घडून आणि त्याच्या फुलाच्या आकाराची फुलपात्रे, त्याच्यावरील कळ्या व फुले ही सर्व त्याबरोबर अखंड असा तयार केला. ");
INSERT INTO marc_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","दीपस्तंभाच्या बाजूंनी सहा फांद्या निघाल्या होत्या; तीन एका बाजूला व तीन दुसर्‍या बाजूला. ");
INSERT INTO marc_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","एका फांदीवर बदामाच्या फुलांप्रमाणे कळ्या आणि फुले असलेल्या तीन वाट्या, पुढच्या फांदीवर तीन वाट्या आणि दीपस्तंभापासून पसरलेल्या सर्व सहा फांद्यांसाठी समान असावे. ");
INSERT INTO marc_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","आणि दीपस्तंभावर वाटीच्या आकाराची चार बदामाची फुले व त्याच्या कळ्या व फुले होती. ");
INSERT INTO marc_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","दीपस्तंभाच्या बाजूने निघालेल्या पहिल्या दोन फांद्यांच्या खालच्या बाजूस एक कळी होती, दुसरी कळी दुसर्‍या दोन फांद्यांच्या खालच्या बाजूस आणि तिसरी कळी तिसर्‍या फांदीच्या जोडीखाली होती; सर्व मिळून सहा फांद्या होत्या. ");
INSERT INTO marc_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","या सर्व कळ्या व फांद्या असून दीपस्तंभाला घडीव शुद्ध सोन्याच्या एकाच अखंड तुकड्यापासून घडविल्या होत्या. ");
INSERT INTO marc_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","मग त्यांनी त्याचे सात दिवे बनविले व शुद्ध सोन्याचे वातीचे चिमटे आणि तबके सुद्धा बनविली. ");
INSERT INTO marc_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","त्यांनी दीपस्तंभ व त्याची सर्व उपकरणे एक तालांत शुद्ध सोन्याने तयार केली. ");
INSERT INTO marc_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","मग त्यांनी बाभळीच्या लाकडाची एक वेदी तयार केली. ती चौरस होती. तिची लांबी एक हात, रुंदी एक हात व उंची दोन हात होती व तिची शिंगे तिच्याशी अखंड अशी होती. ");
INSERT INTO marc_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","त्यांनी वेदीचा वरचा भाग, तिच्या सर्व बाजू व शिंगे यांना शुद्ध सोन्याचे आवरण घातले व त्याभोवती सोन्याचा काठ केला. ");
INSERT INTO marc_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","त्यांनी वेदीच्या खालच्या काठाला सोन्याच्या दोन कड्या बनविल्या; वेदी वाहून नेण्यासाठी दांडे घालता येतील अशा समोरासमोर प्रत्येक बाजूला दोन कड्या केल्या. ");
INSERT INTO marc_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","त्यांनी ते दांडे बाभळीच्या लाकडाचे बनविले व त्यांना सोन्याचे आवरण घातले. ");
INSERT INTO marc_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","त्यांनी सुगंधी द्रव्ये तयार करणार्‍याच्या कुशलतेप्रमाणे पवित्र अभिषेकाचे तेल व शुद्ध, सुगंधी धूप बनविले. ");
INSERT INTO marc_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","त्यांनी बाभळीच्या लाकडाची होमार्पणाची वेदी तयार केली. ती तीन हात उंच, पाच हात लांब, पाच हात रुंद असून चौकोनी होती. ");
INSERT INTO marc_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","मग त्यांनी वेदीच्या चार कोपर्‍यांना प्रत्येकी एक शिंग बनविले, शिंगे व वेदी अखंड बनविली व वेदीला कास्याचे आवरण घातले. ");
INSERT INTO marc_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","वेदीची सर्व पात्रे, म्हणजे त्याचे भांडे, फावडे, शिंपडण्याचे भांडे, मांसाचे काटे आणि अग्निपात्रे कास्याचे बनविले. ");
INSERT INTO marc_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","त्यांनी वेदीसाठी कास्याच्या जाळीची चाळण तयार केली, जी वेदीच्या काठाखाली वेदीच्या अर्ध्या उंचीपर्यंत होती. ");
INSERT INTO marc_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","त्यांनी कास्याच्या चाळणीच्या चार कोपर्‍यांना दांडे अडकविण्यासाठी ओतीव कास्याच्या कड्या तयार केल्या. ");
INSERT INTO marc_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","त्यांनी बाभळीच्या लाकडाचे दांडे तयार करून त्यांना कास्याचे आवरण घातले. ");
INSERT INTO marc_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","त्यांनी ते दांडे कड्यात अडकविले, म्हणजे वेदी वाहून नेताना दांडे वेदीच्या दोन बाजूंनी असतील. वेदी लाकडाची असून ती आतून पोकळ बनविली. ");
INSERT INTO marc_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","मग त्यांनी कास्याचे गंगाळ व त्याची बैठक सुद्धा कास्याची बनविली. सभामंडपाच्या दाराशी सेवा करणार्‍या स्त्रियांच्या आरशांचे ते बैठक होते. ");
INSERT INTO marc_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","मग त्यांनी अंगण तयार केले. त्याची दक्षिणेकडील बाजू शंभर हात लांब होती व त्यास कातलेल्या रेशमी तागाचे पडदे होते. ");
INSERT INTO marc_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","आणि वीस खांब व वीस कास्याच्या बैठका होत्या, खांबावर चांदीच्या कड्या व पट्ट्या होत्या. ");
INSERT INTO marc_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","उत्तरेकडील बाजू सुद्धा शंभर हात लांब होती आणि वीस खांब व कास्याच्या वीस बैठका होत्या व खांबाच्या कड्या व पट्ट्या चांदीच्या होत्या. ");
INSERT INTO marc_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","पश्चिमेकडील शेवटची बाजू पन्नास हात रुंदीची होती आणि त्याला पडदे लावलेले होते, त्याला दहा खांब व दहा बैठका असून खांबांना चांदीच्या कड्या व पट्ट्या होत्या. ");
INSERT INTO marc_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","सूर्योदयाकडील पूर्वेकडील बाजू पन्नास हात रुंद होती. ");
INSERT INTO marc_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","प्रवेशद्वाराच्या एका बाजूस पंधरा हात लांबीचा पडदा होता. त्यास तीन खांब व तीन बैठका होत्या, ");
INSERT INTO marc_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","आणि अंगणाच्या प्रवेशद्वाराच्या दुसर्‍या बाजूला पंधरा हात लांबीचे पडदे होते, त्यास तीन खांब व तीन बैठका होत्या. ");
INSERT INTO marc_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","अंगणाच्या सर्व बाजूचे पडदे कातलेल्या रेशमी तागाचे होते. ");
INSERT INTO marc_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","खांबांच्या बैठका कास्याच्या होत्या. खांबाच्या कड्या व पट्ट्या चांदीच्या होत्या आणि त्यांच्या वरच्या भागाला चांदीचे आवरण दिले होते; अशाप्रकारे अंगणाच्या प्रत्येक खांबाला चांदीच्या पट्ट्या होत्या. ");
INSERT INTO marc_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","अंगणाच्या प्रवेशद्वाराचा पडदा निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचे व रेशमी तागाचा होता व त्यावर भरतकाम केले होते. ते अंगणाच्या पडद्यासारखे वीस हात लांब होते आणि पाच हात उंच होते. ");
INSERT INTO marc_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","त्याला चार खांब व कास्याच्या चार बैठका होत्या. त्यांच्या कड्या व पट्ट्या चांदीच्या होत्या आणि त्याच्या वरच्या भागाला चांदीचे आवरण दिले होते. ");
INSERT INTO marc_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","निवासमंडप व अंगणाच्या सभोवती वापरलेल्या सर्व मेखा कास्याच्या होत्या. ");
INSERT INTO marc_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","मोशेच्या आज्ञेनुसार बनविलेले कराराच्या नियमाचे निवासमंडप यासाठी जी सामुग्री वापरली गेली, त्यांची मोजणी, अहरोन याजक याचा पुत्र इथामार याच्या नेतृत्वाखाली लेव्यांच्या द्वारे केली गेली, ती अशी: ");
INSERT INTO marc_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","याहवेहने मोशेला जे सर्व आज्ञापिले होते ते यहूदाह वंशातील हूराचा पुत्र उरी याचा पुत्र बसालेल याने तयार केले; ");
INSERT INTO marc_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","त्याच्याबरोबर दान वंशातील अहीसामाक याचा पुत्र ओहोलियाब होता; हा शिल्पकार व कुशल कारागीर, निळे, जांभळे आणि किरमिजी रंगाचे रेशमी ताग यावर भरतकाम करणारा होता. ");
INSERT INTO marc_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","हेलावणीच्या अर्पणातून पवित्रस्थानाच्या सर्व कामासाठी वापरलेले सोने हे पवित्रस्थानाच्या वजनानुसार एकोणतीस तालांत व सातशे तीस शेकेल असे होते. ");
INSERT INTO marc_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","इस्राएली समुदायातील जनगणना झालेल्या लोकांपासून आलेली चांदी पवित्रस्थानाच्या वजनानुसार शंभर तालांत आणि एक हजार सातशे पंचाहत्तर शेकेल होती. ");
INSERT INTO marc_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","जनगणना झालेले वीस वर्ष व त्याहून अधिक वयाचे सहा लक्ष तीन हजार पाचशे पन्नास पुरुष होते—त्याचा प्रत्येक पुरुषाकरिता एक बेका, म्हणजेच पवित्रस्थानाच्या वजनानुसार अर्धा शेकेल मिळाला होता. ");
INSERT INTO marc_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","शंभर तालांत चांदी पवित्रस्थानाच्या व पडद्याच्या ओतीव बैठका तयार करण्यासाठी वापरली; शंभर बैठकांसाठी शंभर तालांत, प्रत्येकी एका बैठकीसाठी एक तालांत वापरला. ");
INSERT INTO marc_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","खाबांच्या कड्यांसाठी, खांबांच्या वरील भागास आवरण देण्यासाठी व त्यांच्या पट्ट्या बनविण्यासाठी एक हजार सातशे पंचाहत्तर शेकेल वापरण्यात आले. ");
INSERT INTO marc_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","हेलावणीच्या अर्पणात सत्तर तालांत आणि दोन हजार चारशे शेकेल कास्य होते. ");
INSERT INTO marc_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","त्याचा वापर त्यांनी सभामंडपाच्या प्रवेशद्वाराच्या बैठका, कास्याची वेदी व त्याची कास्याची चाळणी व वेदीवरील उपकरणे बनविण्यासाठी केला, ");
INSERT INTO marc_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","निवासमंडपाच्या अंगणाभोवती व त्याच्या प्रवेशद्वारासाठी बैठका आणि निवासमंडपाच्या व अंगणाच्या सभोवती मेखा करण्यासाठी त्याचा वापर केला. ");
INSERT INTO marc_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","पवित्रस्थानातील सेवेसाठी त्यांनी निळे, जांभळे व किरमिजी रंगाच्या सुताची विणलेली वस्त्रे बनविली. याहवेहने मोशेला आज्ञापिल्याप्रमाणे अहरोनासाठी सुद्धा त्यांनी पवित्र वस्त्रे बनविली. ");
INSERT INTO marc_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","मग त्यांनी एफोद सोन्याचा, निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा आणि बारीक कातलेल्या रेशमी तागाचा वापर करून बनविला. ");
INSERT INTO marc_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","त्यांनी सोने ठोकून त्याचे पातळ पत्रे बनविले आणि निळ्या, जांभळ्या आणि किरमिजी रंगाच्या धाग्यात आणि रेशमी ताग कातून—कुशल कारागिराच्या हातांनी बनविले. ");
INSERT INTO marc_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","एफोदासाठी त्यांनी दोन खांदेपट्ट्या बनविल्या, ज्या त्याच्या दोन कोपर्‍यांना बांधता येतील अशा जोडल्या. ");
INSERT INTO marc_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","कुशलतेने विणलेला कमरबंद त्याच्यासारखाच होता; एफोदाशी अखंड असा तो सोन्याचा, निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा व कातलेल्या रेशमी तागाचा, याहवेहने मोशेला आज्ञापिल्याप्रमाणे तो बनविला होता. ");
INSERT INTO marc_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","त्यांनी गोमेद रत्ने सोन्याच्या कोंदणात बसविले आणि त्यावर मुद्रा कोरावी अशी इस्राएलाच्या पुत्रांची नावे कोरली. ");
INSERT INTO marc_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","मग त्यांनी इस्राएलच्या पुत्रांचे स्मारक म्हणून ती रत्ने एफोदाच्या दोन खांदेपट्ट्यांवर लावली, याहवेहने मोशेला आज्ञापिल्याप्रमाणे त्यांनी हे केले. ");
INSERT INTO marc_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","कुशल कारागिरांच्या हस्तकृतीने त्यांनी ऊरपट बनविला. त्यांनी तो एफोदाप्रमाणेः सोन्याच्या जरीचा, निळ्या, जांभळ्या व किरमिजी रंगांचे सूत व कातलेल्या रेशमी तागाचा बनविला. ");
INSERT INTO marc_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","तो चौकोनी असून दुहेरी दुमडलेला होता व त्याची लांबी एक वीत व रुंदी एक वीत होती. ");
INSERT INTO marc_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","मग त्यांनी त्यात चार रांगेत मोलवान रत्ने लावली. पहिल्या रांगेत लाल, पुष्कराज, व माणिक ");
INSERT INTO marc_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दुसर्‍या रांगेत पाचू, नीलमणी व हिरे, ");
INSERT INTO marc_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तिसर्‍या रांगेत तृणमणी, सूर्यकांत व पद्मराग; ");
INSERT INTO marc_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","आणि चौथ्या रांगेत लसणा, गोमेद व यास्फे. त्यांना नक्षीकाम केलेल्या सोन्याच्या कोंदणात लावले होते. ");
INSERT INTO marc_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","इस्राएलाच्या पुत्रातील प्रत्येकाच्या नावाने एक अशी बारा रत्ने होती. प्रत्येक रत्नावर इस्राएलाच्या बारापैकी एका गोत्राचे नाव मुद्रेप्रमाणे कोरले. ");
INSERT INTO marc_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","त्यांनी ऊरपटासाठी पीळ घातलेल्या दोरीप्रमाणे शुद्ध सोन्याच्या साखळ्या तयार केल्या. ");
INSERT INTO marc_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","त्यांनी सोन्याची दोन कोंदणे व सोन्याच्या दोन कड्या बनविल्या, त्या दोन कोंदणांमध्ये घालून ऊरपटाच्या दोन्ही टोकास बसविल्या. ");
INSERT INTO marc_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","त्यांनी त्या सोन्याच्या दोन साखळ्या ऊरपटाच्या टोकाला असलेल्या कड्यांमध्ये बसविल्या, ");
INSERT INTO marc_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","आणि साखळीची दुसरी दोन टोके साच्यात घालून एफोदाच्या समोरील बाजूने त्याच्या खांदेपट्टीला जोडले. ");
INSERT INTO marc_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","त्यांनी सोन्याच्या दोन कड्या तयार केल्या व त्या ऊरपटाच्या दुसर्‍या दोन कोपर्‍यांना म्हणजे एफोदा जवळील आतील बाजूच्या काठाला जोडल्या. ");
INSERT INTO marc_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","मग त्यांनी सोन्याच्या आणखी दोन कड्या बनविल्या व त्या एफोदाच्या खांदेपट्टीच्या खालच्या बाजूने समोरून जोडल्या, एफोदाच्या कमरबंदाच्या अगदी वर असलेल्या काठाला जोडल्या. ");
INSERT INTO marc_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","त्यांनी त्या ऊरपटाच्या कड्या एफोदाच्या कड्यांना निळ्या दोरीने कमरबंदाला अशा बांधाव्या की ऊरपट एफोदावरून सरकणार नाही; हे त्यांनी याहवेहने मोशेला आज्ञापिल्याप्रमाणे केले. ");
INSERT INTO marc_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","त्यांनी एफोदाचा झगा संपूर्ण निळ्या कापडाने बनविला—विणकाम करणार्‍याच्या कामाप्रमाणे विणला. ");
INSERT INTO marc_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","त्याच्या मधोमध चिलखताच्या गळ्याप्रमाणे त्या झग्याचे तोंड होते. तो फाटू नये म्हणून त्याच्या तोंडाला गळपट्टीप्रमाणे गोट होता. ");
INSERT INTO marc_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","त्यांनी त्या झग्याच्या खालच्या घेर्‍यावर निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताची व कातलेल्या सुताची डाळिंबे बनविली. ");
INSERT INTO marc_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","डाळिंबांच्या मध्ये झग्याच्या घेरावर शुद्ध सोन्याच्या घंट्या बनवून लावल्या. ");
INSERT INTO marc_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","याहवेहने मोशेला आज्ञापिल्याप्रमाणे सेवा करण्यासाठी घालावयाच्या झग्याच्या घेराच्या काठावर घंट्या व डाळिंबे एक सोडून एक असे आळीपाळीने लावले. ");
INSERT INTO marc_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","यानंतर त्यांनी अहरोन व त्याचे पुत्र यांच्यासाठी रेशमी तागाचे विणलेले अंगरखे तयार केले. ");
INSERT INTO marc_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","आणि रेशमी तागाचा फेटा व रेशमी तागाची टोपी आणि रेशमी तागाची अंतर्वस्त्रे केली. ");
INSERT INTO marc_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","कातलेल्या रेशमी तागाचा आणि निळ्या, जांभळ्या व किरमिजी रंगाचे भरतकाम केलेला कमरबंद होता; जसे याहवेहने मोशेला आज्ञापिले होते. ");
INSERT INTO marc_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","त्यांनी शुद्ध सोन्याची पवित्र मुद्रेची पाटी बनविली आणि तिच्यावर मुद्रा कोरावी तसे हे कोरले: याहवेहसाठी पवित्र. ");
INSERT INTO marc_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ती जोडता यावी म्हणून त्यांनी ती निळ्या फेट्याला दोरीने बांधली, जसे याहवेहने मोशेला आज्ञापिले होते. ");
INSERT INTO marc_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","याप्रकारे निवासमंडप व सभामंडप यांचे काम समाप्त झाले. इस्राएली लोकांनी जे काही याहवेहने मोशेला आज्ञापिले होते त्याप्रमाणेच केले. ");
INSERT INTO marc_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","मग त्यांनी निवासमंडप मोशेकडे आणला: तंबू व त्याचे सर्व सामान, त्याचे आकडे, फळ्या, अडसर, खांब व बैठका; ");
INSERT INTO marc_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","मेंढ्याच्या लाल रंगवलेल्या कातड्यांचे आच्छादन आणि इतर प्रकारचे टिकाऊ चर्म, झाकण व त्याचा पडदा; ");
INSERT INTO marc_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","कराराच्या नियमाचा कोश, त्याचे दांडे आणि प्रायश्चिताचे झाकण; ");
INSERT INTO marc_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","मेज व त्याचे सर्व सामान आणि समक्षतेची भाकर; ");
INSERT INTO marc_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","शुद्ध सोन्याचे दीपस्तंभ व त्याच्या दिव्यांची रांग व त्याची सर्व उपकरणे आणि प्रकाशासाठी जैतुनाचे तेल; ");
INSERT INTO marc_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सोन्याची धूपवेदी, अभिषेकाचे तेल, सुगंधी धूप व तंबूच्या प्रवेशद्वारासाठी पडदा; ");
INSERT INTO marc_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","कास्याची वेदी व तिची कास्याची जाळी, तिचे दांडे व तिचे सर्व साहित्य; गंगाळ व त्याची बैठक; ");
INSERT INTO marc_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","अंगणाचे पडदे, खुंट्या व त्यांच्या बैठका आणि अंगणाच्या प्रवेशद्वारासाठी पडदे; दोर्‍या व अंगणासाठी तंबूच्या मेखा; निवासमंडप व सभामंडपा साठी लागणारे सर्व साहित्य; ");
INSERT INTO marc_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","पवित्रस्थानात सेवा करताना घालावयाची विणलेली वस्त्रे आणि याजक म्हणून घालावयाची अहरोन याजकासाठी पवित्र वस्त्रे व त्याच्या पुत्रांची वस्त्रे. ");
INSERT INTO marc_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","याहवेहने मोशेला आज्ञापिल्याप्रमाणेच इस्राएल लोकांनी सर्व कामे केली होती. ");
INSERT INTO marc_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मोशेने कामाचे परीक्षण केले व पाहिले की त्यांनी याहवेहने आज्ञापिल्याप्रमाणेच केले होते. म्हणून मोशेने त्यांना आशीर्वाद दिला. ");
INSERT INTO marc_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","मग याहवेह मोशेला म्हणाले: ");
INSERT INTO marc_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पहिल्या महिन्याच्या पहिल्या दिवशी निवासमंडप, सभामंडप उभा करावा. ");
INSERT INTO marc_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","त्यामध्ये कराराच्या नियमाचा कोश ठेवावा आणि कोश पडद्याने झाकावा. ");
INSERT INTO marc_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","मेज आत आणून त्यावरचे सामान व्यवस्थित लावावे. मग दीपस्तंभ आत आणावा व त्याचे दिवे लावावे. ");
INSERT INTO marc_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","कराराच्या नियमाच्या कोशापुढे सोन्याची धूपवेदी ठेवावी आणि निवासमंडपाच्या प्रवेशद्वाराचा पडदा लावावा. ");
INSERT INTO marc_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“निवासमंडपाच्या प्रवेशद्वारापुढे, सभामंडपापुढे होमार्पणाची वेदी ठेवावी. ");
INSERT INTO marc_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","सभामंडप व वेदी यांच्यामध्ये गंगाळ ठेवून त्यात पाणी भरावे. ");
INSERT INTO marc_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","त्याभोवती अंगण करावे आणि त्या अंगणाच्या प्रवेशद्वारास पडदा लावावा. ");
INSERT INTO marc_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“अभिषेकाचे तेल घेऊन निवासमंडप व त्यातील प्रत्येक वस्तूवर अभिषेक करावा, ते व त्यातील सर्व सामान वेगळे करावे म्हणजे ते पवित्र होईल. ");
INSERT INTO marc_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","मग होमार्पणाची वेदी व तिची सर्व पात्रे यांचा अभिषेक करावा; वेदीला पवित्र करावे म्हणजे ती वेदी परमपवित्र होईल. ");
INSERT INTO marc_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","मग गंगाळ व त्याच्या बैठकीस अभिषेक कर व ते समर्पित कर. ");
INSERT INTO marc_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“अहरोन व त्याचे पुत्र यांना सभामंडपाच्या प्रवेशद्वाराशी आणावे व त्यांना पाण्याने धुवावे. ");
INSERT INTO marc_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","मग अहरोनाला पवित्र वस्त्रे घालावीत. त्याने याजक म्हणून माझी सेवा करावी, यासाठी त्याला अभिषेक करून पवित्र करावे. ");
INSERT INTO marc_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","त्याच्या पुत्रांना आणून त्यांना झगे घालावे. ");
INSERT INTO marc_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","जसा त्यांच्या पित्याला अभिषेक केला, तसाच त्यांनाही अभिषेक करावा, म्हणजे याजक म्हणून ते माझी सेवा करतील. त्यांचा हा याजकपणाचा अभिषेक पिढ्यान् पिढ्या चालू राहील.” ");
INSERT INTO marc_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","जसे याहवेहने आज्ञापिले होते, मोशेने सर्वकाही तसेच केले. ");
INSERT INTO marc_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","दुसर्‍या वर्षाच्या पहिल्या महिन्याच्या पहिल्या दिवशी निवासमंडपाची उभारणी करण्यात आली. ");
INSERT INTO marc_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","जेव्हा मोशेने निवासमंडपाची उभारणी केली, त्याने बैठका जागेवर लावल्या, फळ्या उभ्या केल्या, त्यात अडसर टाकले व खांब उभे केले. ");
INSERT INTO marc_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","मग मोशेने निवासमंडपावरून तंबू पसरला आणि तंबूवर आच्छादन टाकले, जसे याहवेहने त्याला आज्ञापिले होते. ");
INSERT INTO marc_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","मग त्याने कराराच्या नियमाच्या पाट्या घेतल्या व त्या कोशामध्ये ठेवल्या, कोशाचे दांडे जोडले व त्यावर प्रायश्चिताचे झाकण लावले. ");
INSERT INTO marc_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","मग मोशेने कोश निवासमंडपात आणला आणि पडदे अडकविले आणि याहवेहने त्याला आज्ञापिल्याप्रमाणे कराराच्या नियमाचा कोश झाकून घेतला. ");
INSERT INTO marc_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","मोशेने सभामंडपामध्ये, निवासमंडपाच्या उत्तर दिशेला पडद्याच्या बाहेर मेज ठेवला ");
INSERT INTO marc_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","व मोशेने त्यावर याहवेहसमोर भाकर ठेवली, जसे याहवेहने त्याला आज्ञापिले होते. ");
INSERT INTO marc_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","त्याने सभामंडपामध्ये मेजासमोर, निवासमंडपाच्या दक्षिण दिशेला दीपस्तंभ ठेवला ");
INSERT INTO marc_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","आणि याहवेहने मोशेला आज्ञापिल्याप्रमाणे याहवेहसमोर दिवे लावले. ");
INSERT INTO marc_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","मग मोशेने सभामंडपात, पडद्याच्या समोर सोन्याची वेदी ठेवली ");
INSERT INTO marc_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","व याहवेहने मोशेला आज्ञापिल्याप्रमाणे वेदीवर सुगंधी धूप जाळला. ");
INSERT INTO marc_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","मग त्याने निवासमंडपाच्या प्रवेशद्वाराला पडदे लावले. ");
INSERT INTO marc_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","मग मोशेने निवासमंडपाच्या, सभामंडपाच्या प्रवेशद्वाराजवळ होमार्पणाची वेदी ठेवली व त्यावर होमार्पण व अन्नार्पण केले, जसे याहवेहने त्याला आज्ञापिले होते. ");
INSERT INTO marc_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","नंतर मोशेने सभामंडप व वेदी यांच्यामध्ये गंगाळ ठेवले व धुण्यासाठी त्यात पाणी भरून ठेवले, ");
INSERT INTO marc_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","आणि मोशे आणि अहरोन व अहरोनाचे पुत्र यांनी आपले हात व पाय धुण्यासाठी त्या पाण्याचा वापर केला. ");
INSERT INTO marc_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","जेव्हा ते सभामंडपात प्रवेश करीत किंवा वेदीजवळ जात, तेव्हा ते आपले हात व पाय धूत असत, जसे याहवेहने मोशेला आज्ञापिले होते. ");
INSERT INTO marc_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","मग मोशेने निवासमंडप व वेदी यांच्याभोवती अंगण केले आणि अंगणाच्या प्रवेशद्वारात पडदे लावले. अशाप्रकारे मोशेने सर्व काम पूर्ण केले. ");
INSERT INTO marc_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","मग मेघाने सभामंडप झाकले आणि याहवेहच्या तेजाने निवासमंडप भरून गेला. ");
INSERT INTO marc_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","मोशे सभामंडपात प्रवेश करू शकत नव्हता कारण त्यावर मेघ होता आणि याहवेहच्या तेजाने निवासमंडप भरून गेला होता. ");
INSERT INTO marc_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","इस्राएली लोकांच्या सर्व प्रवासात, जेव्हा निवासमंडपावरून मेघ वर जाई तेव्हा ते पुढची वाटचाल करीत असत; ");
INSERT INTO marc_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","पण मेघ वर गेला नाही, तर तो वर जाईल त्या दिवसापर्यंत ते पुढे जात नसत. ");
INSERT INTO marc_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","त्यांच्या संपूर्ण प्रवासात निवासमंडपावर दिवसा याहवेहचा मेघ, तर रात्री त्या मेघात अग्नी, असे इस्राएलने पाहिले.");
INSERT INTO marc_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","याहवेहनी मोशेला बोलाविले आणि सभामंडपातून त्याच्याशी बोलणे केले. ते म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“इस्राएली लोकांशी बोल आणि त्यांना सांग: ‘जेव्हा तुमच्यामधील कोणी याहवेहसाठी अर्पण आणतील, तेव्हा तुमच्या गुरांमधील किंवा कळपातील प्राण्यांचे अर्पण आणावे. ");
INSERT INTO marc_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘जर हे होमार्पण गुरांमधून करावयाचे असेल, तर निर्दोष असलेला नरगोर्‍हा तुम्ही अर्पण करावा. तुम्ही ते सभामंडपाच्या प्रवेशद्वाराजवळ आणावे, म्हणजे ते याहवेहद्वारे मान्य केले जाईल. ");
INSERT INTO marc_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","तुम्ही तुमचे हात त्या होमार्पणाच्या मस्तकावर ठेवावे आणि प्रायश्चित्त म्हणून तुमच्याऐवजी ते तुमच्यासाठी स्वीकारले जाईल. ");
INSERT INTO marc_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","तुम्ही याहवेहसमोर त्या गोर्‍ह्याचा वध करावा आणि नंतर अहरोनाचे जे पुत्र याजक आहेत, ते त्याचे रक्त आणतील आणि सभामंडपाच्या प्रवेशद्वाराजवळ असलेल्या वेदीभोवती शिंपडतील. ");
INSERT INTO marc_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","तुम्ही यज्ञपशूची कातडी काढावी आणि पशूचे कापून तुकडे करावे. ");
INSERT INTO marc_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","अहरोनाचे जे पुत्र याजक आहेत, त्यांनी वेदीवर अग्नी ठेवावा आणि अग्नीवर लाकडांची रचना करावी. ");
INSERT INTO marc_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","नंतर अहरोनाचे पुत्र जे याजक आहेत त्यांनी वेदीवर जळत असलेल्या लाकडांवर त्या पशूचे तुकडे, शिर व चरबी यासह व्यवस्थित रचून ठेवावी. ");
INSERT INTO marc_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","पाय व आतडी पाण्याने धुऊन याजकाने त्या सगळ्यांचे वेदीवर होम करावे. हे होमार्पण आहे, हे अन्नार्पण आहे. याहवेहला प्रसन्न करणारा सुगंध आहे. ");
INSERT INTO marc_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘जर हे होमार्पण कळपातून आणलेले, मेंढी किंवा शेळी असेल तर तुम्ही दोष नसलेल्या नराचे अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","तुम्ही याहवेहसमोर वेदीच्या उत्तर दिशेला त्या प्राण्याचा वध करावा आणि अहरोनाचे पुत्र जे याजक आहेत त्यांनी त्याचे रक्त वेदीभोवती शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","मग त्या पशूचे कापून तुकडे करावेत आणि याजकाने शिर व चरबी यासह ते तुकडे वेदीवरील लाकडांवर ठेवावे. ");
INSERT INTO marc_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","त्याची आतडी आणि पाय तुम्ही पाण्याने धुऊन घ्यावीत आणि याजकाने हे सर्व घेऊन यावे आणि त्यांचा वेदीवर होम करावा. हे होमार्पण आहे, हे अन्नार्पण आहे, हा याहवेहला प्रसन्न करणारा सुगंध आहे. ");
INSERT INTO marc_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘जर याहवेहसाठी पक्ष्यांचे होमार्पण म्हणून अर्पण असेल तर त्याने पारवा किंवा कबुतराची पिल्ले अर्पण करावी. ");
INSERT INTO marc_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","याजकाने तो पक्षी वेदीजवळ आणावा, त्याचे मुंडके मुरगळून काढावे आणि त्याचे वेदीवर होम करावे; त्याचे रक्त वेदीच्या बाजूला वाहू द्यावे. ");
INSERT INTO marc_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","त्याने त्या पक्ष्याची चुनाळ व पिसे काढून वेदीच्या पूर्वेस राख टाकावयाच्या जागी फेकून द्यावी. ");
INSERT INTO marc_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","तो त्याला पंखांच्या मधोमध फाडेल, त्याचे पूर्णपणे तुकडे करणार नाही आणि नंतर याजक त्याचे वेदीवरील जळत्या लाकडांवर होमार्पण करेल. हे होमार्पण आहे, हे अन्नार्पण आहे, हा याहवेहला प्रसन्न करणारा सुगंध आहे. ");
INSERT INTO marc_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘जेव्हा कोणी याहवेहला धान्यार्पण आणत असेल, तर त्यांची अर्पणे उत्तम पिठाची असावीत. त्यांनी त्यावर जैतुनाचे तेल ओतावे व त्यावर धूप ठेवावा. ");
INSERT INTO marc_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","आणि अहरोनाचे पुत्र जे याजक आहेत त्यांच्याकडे ते आणावे. याजक मूठभर पीठ आणि तेल घेतील, त्याचबरोबर सर्व धूप स्मरणाचा भाग म्हणून वेदीवर एकत्र जाळतील, हे अन्नार्पण, हा याहवेहला प्रसन्न करणारा सुगंध आहे. ");
INSERT INTO marc_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","अन्नार्पणातून राहिलेले धान्य अहरोन आणि त्याच्या पुत्रांचे असावे; याहवेहला दिलेल्या अन्नार्पणाचा हा परमपवित्र भाग आहे. ");
INSERT INTO marc_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘जर तुम्ही भट्टीत भाजलेले अन्नार्पण आणता, तर ते उत्तम पिठाचे असावे: बेखमीर जाड भाकरी आणि जैतुनाच्या तेलात मळलेल्या किंवा पातळ बेखमीर भाकरी आणि वर जैतुनाचे तेल लावलेले असे असावे. ");
INSERT INTO marc_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","जर तुमचे अन्नार्पण तव्यावर भाजलेले असेल तर ते उत्तम पिठापासून तयार केलेले तेलात मिसळलेले आणि बेखमीर असे असावे. ");
INSERT INTO marc_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","तिचा भुगा करावा आणि त्यावर तेल ओतावे; हे धान्यार्पण आहे. ");
INSERT INTO marc_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","जर तुमचे धान्यार्पण भांड्यात शिजविलेले असेल, तर ते उत्तम पिठाचे आणि थोडेसे जैतुनाचे तेल वापरून तयार केलेले असावे. ");
INSERT INTO marc_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","याहवेहला अर्पण करण्याचे अशा प्रकारच्या वस्तूंनी बनविलेले धान्यार्पण तुम्ही याजकास आणून द्यावे व त्याने ते वेदीवर ठेवावे. ");
INSERT INTO marc_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","स्मरणभाग म्हणून याजक ते अन्नार्पणातून काढून ठेवेल आणि याहवेहला प्रसन्न करणारे सुवासिक अन्नार्पण म्हणून वेदीवर त्याचे हवन करेल. ");
INSERT INTO marc_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अन्नार्पणातून राहिलेले धान्य अहरोन आणि त्याच्या पुत्रांचे असावे; याहवेहला दिलेल्या अन्नार्पणाचा हा परमपवित्र भाग आहे. ");
INSERT INTO marc_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘याहवेहसाठी आणले जाणारे प्रत्येक अन्नार्पण हे खमीर न घालता तयार करावे, तुम्ही याहवेहसाठी आणलेल्या अन्नार्पणात खमीर किंवा मध जाळू नये. ");
INSERT INTO marc_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तुम्ही त्यांना प्रथमफळाचे अर्पण म्हणून याहवेहकडे आणू शकता, परंतु ते वेदीवर प्रसन्न करणारे सुवासिक अर्पण म्हणून करू नये. ");
INSERT INTO marc_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","प्रत्येक अर्पण मीठ घालून रुचकर करावे, कारण तुमच्या परमेश्वराबरोबर झालेल्या कराराचे मीठ तुमच्या अन्नार्पणात असलेच पाहिजे. ");
INSERT INTO marc_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘जर तुम्ही याहवेहसाठी प्रथम पिकाचे धान्यार्पण आणले, तर नवीन कणसाला चिरडून भाजलेल्या दाण्याचे अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","त्यावर जैतुनाचे तेल व धूप ठेवावे; ते धान्यार्पण आहे. ");
INSERT INTO marc_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","याजकाने त्या चिरडलेल्या धान्याचा आणि तेलाचा स्मरणभाग, सर्व धूपांबरोबर एकत्र जाळावा, याहवेहसाठी अर्पण असे हे एक अन्नार्पण असावे. ");
INSERT INTO marc_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘जर तुमचे अर्पण हे शांत्यर्पण असेल आणि तुम्ही कळपातील नर किंवा मादी प्राण्याचे अर्पण करीत असाल, तुम्ही निर्दोष असा प्राणी याहवेहसमोर आणावा. ");
INSERT INTO marc_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","तुम्ही तुमचा हात त्या अर्पणाच्या डोक्यावर ठेवावा आणि सभामंडपाच्या प्रवेशद्वारात त्याचा वध करावा. नंतर अहरोनाचे पुत्र जे याजक आहेत, त्यांनी वेदीच्या भोवती त्याचे रक्त शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","शांत्यर्पणातून तुम्ही याहवेहसाठी अन्नार्पण आणावे: अंतर्गत अवयव आणि त्यांना जोडून असलेली सर्व चरबी, ");
INSERT INTO marc_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","कंबरेजवळ असलेल्या चरबीसह दोन्ही गुरदे, काळजाला जोडलेले भाग जे तुम्ही गुरद्यासह काढून टाकाल. ");
INSERT INTO marc_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","नंतर अहरोनाच्या पुत्रांनी जळत्या लाकडावर असलेल्या होमार्पणावरील वेदीवर त्याचे हवन करावे. हे अन्नार्पण आहे, हा याहवेहला प्रसन्न करणारा सुगंध आहे. ");
INSERT INTO marc_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘परंतु शांत्यर्पणाचे अर्पण म्हणून शेरडामेंढरांतील नर किंवा मादी यांचे याहवेहला अर्पण करावयाचे असेल तर तो पशू निर्दोष असावा. ");
INSERT INTO marc_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","जर तुम्ही कोकर्‍याचे अर्पण करीत असाल तर तुम्ही ते याहवेहसमोर आणावे, ");
INSERT INTO marc_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","तुमचा हात त्याच्या डोक्यावर ठेवावा आणि सभामंडपाच्या प्रवेशद्वाराजवळ त्याचा वध करावा. नंतर अहरोनाचे पुत्र त्याचे रक्त अर्पण म्हणून वेदीच्या भोवती शिंपडतील. ");
INSERT INTO marc_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","शांत्यर्पणातून जे अन्नार्पण तुम्ही याहवेहसाठी आणावयाचे ते हे: त्याची चरबी, पाठीच्या हाडाजवळून कापलेली संपूर्ण चरबीदार शेपटी, आतील अवयव आणि त्याला जोडून असलेली सर्व चरबी, ");
INSERT INTO marc_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","कंबरेजवळ असलेले चरबीसह दोन्ही गुरदे आणि जो तुम्ही गुरद्यासह काढून टाकाल तो काळजाचा मोठा भाग. ");
INSERT INTO marc_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","याहवेहसाठी अन्नार्पण म्हणून याजक या सर्वाचे वेदीवर हवन करेल. ");
INSERT INTO marc_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘जर तुमचे अर्पण बोकड असेल, तर तुम्ही ते याहवेहसमोर आणावे, ");
INSERT INTO marc_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","तुमचा हात त्याच्या डोक्यावर ठेवावा आणि सभामंडपाच्या प्रवेशद्वाराजवळ त्याचा वध करावा. नंतर अहरोनाचे पुत्र त्याचे रक्त वेदीच्या भोवती शिंपडतील. ");
INSERT INTO marc_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","जे काही अर्पण तुम्ही याहवेहसाठी अन्नार्पण म्हणून आणता ते अशाप्रकारे असावे: आतील अवयव आणि आतड्यांवरील सर्व चरबी, ");
INSERT INTO marc_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","कंबरेजवळ असलेले चरबीसह दोन्ही गुरदे आणि जो तुम्ही गुरद्यासह काढून टाकाल तो काळजाचा मोठा भाग. ");
INSERT INTO marc_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","याजक त्यांचे अन्नार्पण म्हणून वेदीवर हवन करतील, हा याहवेहला प्रसन्न करणारा सुगंध आहे. सर्व चरबी याहवेहसाठी आहे. ");
INSERT INTO marc_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘भावी पिढीसाठी हे विधी सर्वकाळासाठी आहेत, जिथे कुठे तुम्ही राहाल: तुम्ही कोणतीही चरबी किंवा कोणतेही रक्त सेवन करू नये.’ ” ");
INSERT INTO marc_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","याहवेह मोशेला म्हणाले: ");
INSERT INTO marc_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इस्राएली लोकांस सांग की जो कोणी अजाणतेने पाप करून याहवेहच्या नियमानुसार निषिद्ध कृत्ये करत असेल, तर त्याच्यासाठी हे नियम आहेत.” ");
INSERT INTO marc_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","एखाद्या अभिषिक्त याजकाकडून अजाणतेने घडलेल्या पापामुळे लोकांवर दोष आला, तर पापार्पण म्हणून याहवेहला त्याने एक निर्दोष गोर्‍हा अर्पण करावा. ");
INSERT INTO marc_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","त्याने तो गोर्‍हा सभामंडपाच्या दाराशी आणून त्याच्या मस्तकावर आपला हात ठेवावा व याहवेहसमोर त्याचा वध करावा. ");
INSERT INTO marc_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","मग अभिषिक्त याजकाने त्या गोर्‍ह्याचे थोडे रक्त सभामंडपामध्ये नेऊन त्यात आपली बोटे बुडवून ");
INSERT INTO marc_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","याजकाने पवित्रस्थान वेगळे करणार्‍या पडद्यासमोर याहवेहपुढे सात वेळा शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","नंतर याजकाने त्यातील काही रक्त घेऊन याहवेहसमोर सभामंडपातील धूपवेदीच्या शिंगांना लावावे व गोर्‍ह्याचे उरलेले सर्व रक्त त्याने सभामंडपातील दाराशी असलेल्या होमार्पणाच्या वेदीच्या पायथ्याजवळ ओतावे. ");
INSERT INTO marc_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","नंतर पापार्पणाच्या गोर्‍ह्याची सर्व चरबी, म्हणजे आतड्यांवरील चरबी, त्यास लागून असलेली सर्व चरबी, ");
INSERT INTO marc_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","दोन गुरदे व त्यावरील कंबरेजवळची चरबी व काळीज काढून त्यांचे वेदीवर होमार्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","शांत्यर्पणाच्या यज्ञात जसे गोर्‍ह्याचे भाग काढून घेतात तसे ते वेगळे काढून याजकाने त्यांचे होमवेदीवर होम करावे. ");
INSERT INTO marc_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","परंतु त्या गोर्‍ह्याची कातडी आणि त्याचे सर्व मांस तसेच डोके आणि पाय, आतील अवयव आणि आतडी, ");
INSERT INTO marc_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","त्या गोर्‍ह्याचे राहिलेले सर्व भाग, छावणीबाहेरील विधिपूर्वक स्वच्छ केलेल्या ठिकाणी, राख टाकण्याच्या जागेवर नेऊन लाकडांच्या विस्तवावर जाळून टाकावेत. ");
INSERT INTO marc_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","जर संपूर्ण इस्राएली लोकांकडून अजाणतेने पाप घडले, आणि याहवेहनी निषिद्ध केलेल्यापैकी एखादी गोष्ट केली, ते केलेले जरी समुदायाला माहीत नसेल, पण जेव्हा त्यांना त्यांची चूक समजून येईल, ");
INSERT INTO marc_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","आणि त्यांनी केलेले पाप सर्वांना माहीत होईल, तेव्हा त्या समुदायाने पापार्पण म्हणून एक गोर्‍हा आणावा आणि सभामंडपासमोर अर्पण करावा. ");
INSERT INTO marc_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","तिथे इस्राएली समुदायातील पुढार्‍यांनी याहवेहसमोर त्यांचे हात त्या गोर्‍ह्याच्या मस्तकावर ठेवावेत, व याहवेहसमोर त्या गोर्‍ह्याचा वध करावा. ");
INSERT INTO marc_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","नंतर अभिषिक्त याजकाने त्या गोर्‍ह्याचे काही रक्त सभामंडपात घेऊन जावे. ");
INSERT INTO marc_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","याजकाने त्याची बोटे त्यात बुडवून याहवेहसमोर पडद्यापुढे ते सात वेळा शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","त्यातील काही रक्त घेऊन ते याहवेहपुढे सभामंडपातील वेदीच्या शिंगांना लावावे व राहिलेले सर्व रक्त सभामंडपाच्या प्रवेशद्वाराकडे असलेल्या होमार्पणाच्या वेदीच्या पायथ्याशी ओतावे. ");
INSERT INTO marc_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","त्याने त्यावरील सर्व चरबी काढावी आणि तिचे वेदीवर होम करावे. ");
INSERT INTO marc_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","पापार्पणाच्या गोर्‍ह्यासंबंधीच्या विधीप्रमाणेच त्याने या गोर्‍ह्याचेही करावे. अशा प्रकारे याजकाने संपूर्ण समुदायासाठी प्रायश्चित्त करावे, म्हणजे त्यांची क्षमा होईल. ");
INSERT INTO marc_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","नंतर तो गोर्‍हा वस्तीबाहेर काढून, जसा पहिला गोर्‍हा त्याने जाळून टाकला तसाच हा गोर्‍हा जाळून टाकावा. समुदायासाठी हे पापार्पण आहे. ");
INSERT INTO marc_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","जेव्हा एखादा पुढारी अजाणतेने याहवेह, त्याच्या परमेश्वराच्या आज्ञेचा भंग करून पाप करतो व दोषी ठरतो, ");
INSERT INTO marc_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ज्यावेळी त्याला हे पाप कळून येईल तेव्हा त्याने एका निर्दोष बोकडाचे अर्पण आणावे. ");
INSERT INTO marc_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","त्याने त्या बोकडाच्या मस्तकावर आपला हात ठेवावा व होमार्पणाच्या स्थळी त्याचा वध करून तो याहवेहला अर्पावा. हे त्याचे पापार्पण होय. ");
INSERT INTO marc_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","मग याजकाने त्या पापार्पणातील काही रक्त घेऊन आपल्या बोटाने होमार्पणाच्या वेदीच्या शिंगांना ते लावावे व राहिलेले रक्त होमार्पणाच्या वेदीच्या पायथ्याशी ओतून द्यावे. ");
INSERT INTO marc_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","शांत्यर्पणाच्या अर्पणाच्या यज्ञपशूच्या चरबीप्रमाणे या सर्व चरबीचा वेदीवर होम करावा. अशाप्रकारे पुढार्‍याच्या पापाबद्दल, याजक प्रायश्चित करेल आणि त्याची क्षमा होईल. ");
INSERT INTO marc_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","समुदायातील सामान्य मनुष्याने चुकून पाप केले व याहवेहने निषिद्ध केलेले एखादे कृत्य केल्यामुळे ते दोषी ठरले, ");
INSERT INTO marc_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","पण जेव्हा ते त्यांच्या लक्षात येईल, तेव्हा त्यांनी आपल्या पापाबद्दल प्रायश्चिताचे अर्पण म्हणून एक निर्दोष शेळी आणावी. ");
INSERT INTO marc_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","त्या व्यक्तीने त्याचे हात पापार्पणाच्या मस्तकावर ठेवावे आणि होमार्पणाच्या स्थळी तिचा वध करावा. ");
INSERT INTO marc_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","याजकाने आपल्या बोटांनी काही रक्त घेऊन ते होमार्पणाच्या वेदीच्या शिंगांना लावावे व राहिलेले सर्व रक्त त्याने वेदीच्या पायथ्याशी ओतावे. ");
INSERT INTO marc_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","मग सर्व चरबी काढून शांत्यर्पणाच्या यज्ञपशूच्या चरबीप्रमाणे याजकाने तिचा याहवेहसाठी सुवासिक हव्य म्हणून वेदीवर होम करावा. अशाप्रकारे याजकाने त्या व्यक्तीसाठी प्रायश्चित्त करावे म्हणजे त्याची क्षमा होईल. ");
INSERT INTO marc_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","जर कोणी पापार्पणासाठी अर्पण म्हणून एखादे कोकरू घेऊन येतो, तर ती एक निर्दोष मादी असावी. ");
INSERT INTO marc_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","होमार्पणाच्या पशूंचा वध करतात तिथे तिला आणावे, तिच्या मस्तकावर हात ठेवावा आणि पापार्पण म्हणून तिचा वध करावा. ");
INSERT INTO marc_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","“नंतर याजकाने पापार्पणाच्या रक्तातील काही रक्त बोटांनी घेऊन ते होमार्पणाच्या वेदीच्या शिंगांना लावावे, व राहिलेले सर्व रक्त वेदीच्या पायथ्याशी ओतून द्यावे.” ");
INSERT INTO marc_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","शांत्यर्पणाच्या कोकराच्या चरबीचा उपयोग करतात, तसा या चरबीचा उपयोग करावा. याजकाने सर्व चरबी काढून तिचे वेदीवर याहवेहसमोर होम करावे. अशाप्रकारे याजक त्या व्यक्तींसाठी प्रायश्चित करेल, म्हणजे त्यांच्या पापांची क्षमा होईल. ");
INSERT INTO marc_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","जर पाहिलेल्या किंवा माहीत झालेल्या गोष्टींबद्दल साक्ष देण्यासाठी सार्वजनिकरित्या केलेला आरोप जे ऐकतात पण काही बोलत नाहीत, तर ते पाप करतात, त्यांना जबाबदार धरले जाईल. ");
INSERT INTO marc_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","एखादी व्यक्ती अजाणतेने विधिनियमानुसार अशुद्ध ठरविलेल्या वस्तूला म्हणजेच खाण्यास निषिद्ध असलेल्या ग्रामपशूच्या किंवा वनपशूच्या मृत शरीराला, किंवा सरपटणार्‍या अशुद्ध प्राण्याच्या मृत शरीराला स्पर्श करेल, तर ती व्यक्ती अशुद्ध झाली. निषिद्ध असलेल्या मृत शरीराचा स्पर्श झाला, हे त्या व्यक्तीच्या लक्षात आले, तर ती व्यक्ती दोषी आहे. ");
INSERT INTO marc_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","कोणत्याही प्रकारच्या मानवी अशुद्धतेस कोणतीही व्यक्ती अजाणतेने स्पर्श करेल आणि ते अशुद्ध झाले आहेत हे त्यांना समजणार नाही, परंतु नंतर त्यांना त्यांचा दोष समजून आल्यास; ");
INSERT INTO marc_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","किंवा जर कोणता व्यक्ती अविचाराने शपथ घेतो, मग ती शपथ चांगली असो वा वाईट असो, नंतर आपण ती शपथ अज्ञानाने घेतली हे त्याला कळून आले, तेव्हा तो दोषी ठरेल. ");
INSERT INTO marc_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","जर कोणाला याची जाणीव होते की ते यापैकी कोणत्याही बाबतीत दोषी आहेत, तर त्याने जे पातक केले ते पातक कबूल करावे, ");
INSERT INTO marc_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","आणि त्यांनी केलेल्या पापांचा दंड म्हणून कळपातील एक मादी कोकरू किंवा शेळी याहवेहला पापार्पण अशी करावी; आणि याजकाने त्यांच्या पापाबद्दल प्रायश्चित करावे. ");
INSERT INTO marc_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","परंतु एखाद्याला याहवेहला कोकरू देणे शक्य नसेल, तर त्याने आपल्या पापांबद्दल दोषार्पण म्हणून दोन होले किंवा पारव्याची दोन पिल्ले, एक पापार्पणासाठी व एक होमार्पणासाठी आणावी. ");
INSERT INTO marc_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","त्याने ती याजकाकडे आणावी आणि याजकाने प्रथम पापार्पणाचा यज्ञ करावा. त्याने त्या पक्ष्याची मान मुरगळावी, परंतु डोके मानेपासून वेगळे करू नये. ");
INSERT INTO marc_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","नंतर पापार्पणाचे काही रक्त वेदीभोवती शिंपडावे. बाकीचे रक्त वेदीच्या पायथ्याशी ओतावे; हे पापार्पण होय. ");
INSERT INTO marc_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","दुसरा पक्षी त्याने विधिपूर्वक होमार्पण म्हणून अर्पावा. अशाप्रकारे याजकाने त्यांच्यासाठी त्यांच्या पापाचे प्रायश्चित्त करावे, म्हणजे त्यांची क्षमा होईल. ");
INSERT INTO marc_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“जर होले किंवा पारव्याची पिल्ले आणण्याइतकीही त्याची ऐपत नसेल, तर त्याने एफाचा दहावा भाग उत्तम पीठ आणावे. ते पापार्पण असल्यामुळे त्याने ते जैतुनाच्या तेलात मिश्रित करू नये किंवा त्यावर धूपही ठेवू नये. ");
INSERT INTO marc_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","त्याने ते याजकाकडे आणावे आणि याजकाने त्यातील मूठभर पीठ घेऊन संपूर्ण पापार्पणाचे अंशात्मक प्रतीक म्हणून याहवेहला इतर अर्पणांचा होम करतात तसे त्याचे वेदीवर होम करावे. हे त्याच्यावतीने पापार्पण होय. ");
INSERT INTO marc_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","अशारितीने याजकाने त्यांच्या अशा प्रकारच्या कोणत्याही पापांबद्दल प्रायश्चित्त करावे म्हणजे त्यांची क्षमा होईल. अन्नार्पणासंबंधी सांगितल्याप्रमाणे, पापार्पणाचे उरलेले पीठ याजकाचे होईल.” ");
INSERT INTO marc_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","याहवेह मोशेला म्हणाले: ");
INSERT INTO marc_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“याहवेहशी अविश्वासूपणा करून त्यांची कोणतीही पवित्र वस्तू चुकून दूषित करून कोणी पापी ठरला, तर त्याने दोषार्पण म्हणून, तू ठरवशील तितक्या निवासमंडपातील चांदीच्या शेकेलांच्या ठरलेल्या किमतीचा एक निर्दोष मेंढा आणावा. ");
INSERT INTO marc_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","पवित्र वस्तू दूषित करून त्यांनी जे पाप केले त्याची ते भरपाई करतील. त्यांनी भरपाईची रक्कम देऊन वर वीस टक्के अधिक दंड द्यावा. त्यांनी दोषार्पणाचा एक मेंढा याजकाकडे आणावा आणि याजक त्यांच्यासाठी तो मेंढा अर्पून प्रायश्चित्त करेल व त्यांची क्षमा होईल. ");
INSERT INTO marc_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“अजाणतेने याहवेहने निषिद्ध ठरवलेले एखादे कृत्य केल्याचे पाप कोणाकडून घडले, तरी ते दोषी ठरतील आणि त्याकरिता ते जबाबदार असतील. ");
INSERT INTO marc_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","त्यांनी निर्दोष मेंढा याजकाकडे न्यावा, तू ठरवशील तेवढ्या किमतीचा तो असावा, म्हणजे याजक तो मेंढा अर्पून त्यांच्यासाठी प्रायश्चित्त करेल, आणि अजाणतेने घडलेल्या पापाबद्दल त्यांची क्षमा होईल. ");
INSERT INTO marc_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","हे दोषार्पण आहे, याहवेहविरुद्ध चुकीची गोष्ट केल्याने ते दोषी ठरले आहेत.” ");
INSERT INTO marc_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","याहवेह मोशेला म्हणाले: ");
INSERT INTO marc_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“जर कोणी त्याच्या शेजारच्या मनुष्यावर त्याने सोपविलेल्या काही गोष्टीबाबत फसवणूक करून किंवा त्याची काळजी न घेता किंवा काहीतरी चोरी करून किंवा त्यांच्या शेजार्‍याला फसवून याहवेहविरुद्ध विश्वासघात केला असेल, तर तो पाप करतो ");
INSERT INTO marc_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","किंवा जर कोणाला हरवलेली वस्तू सापडली आणि त्याबद्दल ते खोटे बोलतील आणि तिच्याविषयी खोटी शपथ वाहतील किंवा जर लोकांनी केलेल्या अशा पापाबद्दल ते खोटे बोलतील, ");
INSERT INTO marc_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","अशा कोणत्याही प्रकारे जर ते पाप करतील आणि त्यांच्या पापांची त्यांना जाणीव होईल, तेव्हा त्यांनी ती चोरलेली वस्तू किंवा बळजबरीने जे घेतले असेल ते किंवा जे काही त्यांच्यावर सोपविलेले असेल किंवा हरवलेली संपत्ती सापडल्यास ती परत करावी— ");
INSERT INTO marc_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","किंवा अशा कोणत्याही गोष्टीबद्दल त्यांनी खोटी शपथ घेतली असेल तर, ज्या दिवशी दोषार्पण आणतील, त्याच दिवशी त्यांनी त्यांच्या गुन्ह्याबद्दल वीस टक्के अधिक दंड म्हणून त्या वस्तूच्या मालकाला द्यावा. ");
INSERT INTO marc_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","आणि दंड म्हणून त्यांनी याजकाकडे, म्हणजेच याहवेहसाठी, कळपातून एक निर्दोष व योग्य किमतीचा एक मेंढा दोषार्पण म्हणून आणावा. ");
INSERT INTO marc_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","याप्रकारे त्यांच्यासाठी याजक याहवेहसमोर प्रायश्चित करेल आणि ज्या गोष्टींमुळे ते दोषी झाले असतील, त्याबद्दल त्यांना क्षमा केली जाईल.” ");
INSERT INTO marc_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“अहरोन आणि त्याच्या पुत्रांना अशी आज्ञा कर, होमार्पणासाठी पाळावयाचे नियम हे आहेत: होमार्पण रात्रभर वेदीवर ठेवून ते सकाळपर्यंत राहू द्यावे आणि त्या वेदीवरील अग्नी जळत ठेवावा. ");
INSERT INTO marc_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","नंतर याजकाने त्याची तागमिश्रित वस्त्रे, त्याचबरोबर त्याची अंतर्वस्त्रे अंगावर घालावी आणि वेदीवरील अग्नीत भस्म झालेली होमार्पणाची राख काढावी आणि ती वेदीच्या बाजूला ठेवावी. ");
INSERT INTO marc_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","मग त्याने आपली वस्त्रे बदलून, दुसरी वस्त्रे घालावी आणि ती राख छावणीबाहेरील विधिपूर्वक स्वच्छ केलेल्या ठिकाणी न्यावी. ");
INSERT INTO marc_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदीवरील अग्नी सतत पेटलेला ठेवावा, तो विझू देऊ नये. तो पेटलेला ठेवण्यासाठी याजकाने रोज सकाळी वेदीवर लाकडे ठेवावी व त्यावर होमबली रचून शांत्यर्पणाच्या अर्पणाच्या चरबीचे हवन करावे. ");
INSERT INTO marc_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदीवरील अग्नी सतत पेटलेला ठेवावा; तो कधीही विझू देऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“अन्नार्पणासंबंधी नियम आहेत ते हे: अहरोनाच्या पुत्रांनी याहवेहसमोर वेदीपुढे अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","मग याजकांनी सुगंधी मसाले व जैतुनाचे तेल व धूप घ्यावा आणि मळलेला अन्नार्पणातील मूठभर सपीठ घ्यावे व संपूर्ण अर्पणाचा स्मरणभाग म्हणून वेदीवर त्याचे हवन करावे. हा याहवेहला प्रसन्न करणारा सुगंध असेल. ");
INSERT INTO marc_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","उर्वरित भाग अहरोन आणि त्याचे पुत्र खातील, परंतु त्यांनी ते खमीर न घालता पवित्रस्थानात खावे; त्यांनी ते सभामंडपाच्या अंगणात खावे. ");
INSERT INTO marc_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","तो खमिरासह भाजू नये. मला अर्पिलेल्या होमार्पणाचा हा भाग मी माझ्या अर्पणातून याजकांना त्यांचा वाटा म्हणून दिला आहे. दोषार्पण व पापार्पण त्याप्रमाणेच हे देखील परमपवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","अहरोनाच्या संतानांतील फक्त पुरुषांनी ते खावे आणि याहवेहला अर्पिलेला अन्नार्पणाचा हा भाग त्यांच्यासाठी पिढ्यान् पिढ्या कायमचा वाटा राहावा. जे कोणी यास स्पर्श करतील, ते पवित्र गणले जातील.” ");
INSERT INTO marc_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","याहवेह मोशेला हे देखील म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ज्या दिवशी अहरोन व त्याच्या पुत्रांचा याजकीय सेवेसाठी अभिषेक होईल, त्या दिवशी त्यांनी एफाचा दहावा हिस्सा उत्तम सपीठ, अर्धे सकाळी व अर्धे सायंकाळी, अन्नार्पण म्हणून नेमाने याहवेहला अर्पावे. ");
INSERT INTO marc_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ते अन्नार्पण तव्यावर तेलात चांगले परतावे आणि मग याहवेहला अर्पण म्हणून आणावे, कारण हा याहवेहला प्रसन्न करणारा सुगंध असे अर्पण आहे. ");
INSERT INTO marc_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","त्याच्या पुत्रांपैकी जो पुत्र त्याच्या जागी अभिषिक्त याजक म्हणून नियुक्त होईल तो ते तयार करेल. याहवेहचा हा वाटा सर्वकाळचा आहे आणि तो पूर्णपणे जाळून टाकावा. ");
INSERT INTO marc_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","याजकाचे प्रत्येक धान्यार्पण पूर्णपणे जाळून टाकले जाईल; ते खाऊ नये.” ");
INSERT INTO marc_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“अहरोन व त्याच्या पुत्रांना सांग, पापार्पणासंबंधी नियम हे आहेत: ज्या स्थळी होमार्पणाच्या पशूंचा वध करतात त्याच स्थळी या पापार्पणाच्या पशूचाही याहवेहसमोर वध करावा. हे परमपवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ज्या याजकाने हा पापार्पणविधी केला असेल, त्याने सभामंडपाच्या अंगणात पवित्रस्थानात ते खावे. ");
INSERT INTO marc_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जे काही या मांसाला स्पर्श करेल ते पवित्र होईल आणि जर काही रक्त वस्त्रावर उडाले असेल, तर ते तुम्ही पवित्रस्थानी धुवावे. ");
INSERT INTO marc_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ज्या मातीच्या पात्रात मांस शिजविले असेल, ते पात्र फोडून टाकावे पण तांब्याच्या पात्रात शिजविले असेल; तर ते पात्र घासून पाण्याने धुवावे. ");
INSERT INTO marc_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","याजकीय घराण्यातील कोणीही पुरुष ते खाऊ शकतात; ते परमपवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","परंतु कोणतेही पापार्पण, ज्याचे रक्त पवित्रस्थानात प्रायश्चित्त करण्यासाठी सभामंडपात आणले जाते ते खाऊ नये; ते जाळून टाकावे.” ");
INSERT INTO marc_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“दोषार्पण जे परमपवित्र आहे त्यासंबंधी जे नियम आहेत ते हे: ");
INSERT INTO marc_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ज्या स्थळी होमार्पणाचे यज्ञपशू मारले जातात, त्याच निर्धारित स्थळी दोषार्पणाच्या यज्ञपशूचा वध करावा आणि त्याचे रक्त वेदीभोवती शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","मग याजकाने त्याची सर्व चरबी: चरबीदार शेपूट, आतड्यावरील चरबी, ");
INSERT INTO marc_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","कंबरेजवळील चरबीसह दोन्ही गुरदे, काळजाला जोडलेले भाग तुम्ही गुरद्यासह काढून टाकावे. ");
INSERT INTO marc_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","आणि याजकाने या सर्वांचे याहवेहला अन्नार्पण म्हणून वेदीवर हवन करावे. हे दोषार्पण होय. ");
INSERT INTO marc_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","याजकवर्गातील प्रत्येक पुरुषाला हा बली खाण्याचा अधिकार असून त्यांनी तो बली पवित्रस्थानातच बसून खावा; कारण हे परमपवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“पापार्पणासारखेच दोषार्पण आहे; त्या दोघांचे नियम सारखेच आहेत. अर्पिलेला हा बली प्रायश्चित्तविधी करणार्‍या याजकाच्याच अधिकाराचा होईल. ");
INSERT INTO marc_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","जो याजक एखाद्या मनुष्याच्या वतीने होमार्पण करेल, त्या अर्पण पशूच्या कातडीवर त्या याजकाचाच हक्क असेल. ");
INSERT INTO marc_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","भाजलेल्या किंवा शिजविलेल्या किंवा तळलेल्या प्रत्येक अन्नधान्याचे अर्पण, विधी करणार्‍या याजकाचे होईल, ");
INSERT INTO marc_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","अन्नधान्याचे प्रत्येक अर्पण, जैतुनाच्या तेलात मिश्रण केलेली किंवा कोरडी, अहरोनाच्या सर्व पुत्रांच्या सामूहिक मालकीची आहेत.” ");
INSERT INTO marc_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“याहवेहसाठी कोणाला शांत्यर्पणाचा यज्ञ करावयाचा असेल तर त्याचा विधी असा: ");
INSERT INTO marc_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“उपकारस्तुती म्हणून केलेल्या शांत्यर्पणात तेल लावलेल्या बेखमीर जाड भाकरी, बेखमीर व वरून तेल लावलेल्या पातळ पापड्या, नीट मळलेल्या व तेल मिसळलेल्या उत्तम पिठाच्या जाड भाकरी असाव्यात. ");
INSERT INTO marc_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","उपकारस्तुतीच्या या शांत्यर्पणासह खमीर घालून केलेल्या जाड भाकरींचेही अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","या अर्पणातील काही भाग संपूर्ण अर्पणाचे अंशात्मक प्रतीक म्हणून प्रत्येक प्रकारची भाकर वेदीपुढे याहवेहला अर्पण करावी, म्हणजे याजक जो वेदीवर शांत्यर्पणाचे रक्त शिंपडतो त्या याजकाचाच त्यावर हक्क असेल. ");
INSERT INTO marc_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","उपकारस्तुती करिता अर्पिलेल्या शांत्यर्पणातील यज्ञबलीचे मांस अर्पण केल्या दिवशीच खावे; सकाळपर्यंत त्यातील काही शिल्लक ठेऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“परंतु यज्ञबलीचे अर्पण नवसाचे अथवा स्वैच्छिक असेल, तर अर्पणातील भाग त्या दिवशीच खावे, पण उरलेले भाग दुसर्‍या दिवशी खाण्यास हरकत नाही. ");
INSERT INTO marc_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","अर्पणातील काही मांस तिसर्‍या दिवसापर्यंत शिल्लक राहिले असेल तर ते अग्नीत जाळून टाकावे. ");
INSERT INTO marc_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","शांत्यर्पणाच्या मांसापैकी काही मांस तिसर्‍या दिवशी खाल्ले, तर ज्याने ते अर्पण केले असेल त्याला स्वीकारले जाणार नाही. त्याचे त्यांना काहीच श्रेय मिळणार नाही, कारण ते अशुद्ध झाले आहे; त्यापैकी काहीही खाणारा व्यक्ती जबाबदार धरला जाईल. ");
INSERT INTO marc_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘ज्या मांसाचा स्पर्श एखाद्या विधिनियमानुसार अपवित्र वस्तूला झाल्यास ते खाऊ नये; ते जाळून टाकावे. दुसरे मांस जो कोणी विधिपूर्वक शुद्ध आहे, तो ते खाऊ शकतो. ");
INSERT INTO marc_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","परंतु जर कोणी विधिनियमानुसार अशुद्ध असताना शांत्यर्पणातील कोणतेही मांस जे याहवेहचे आहे ते खाईल, तर त्यांना त्यांच्या लोकांमधून काढून टाकावे. ");
INSERT INTO marc_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","जर कोणी विधिनियमांनुसार अशुद्ध वस्तूला स्पर्श करेल—मानवासंबंधीची अशुद्धता किंवा अशुद्ध पशू वा सरपटणार्‍या अशुद्ध पशूला स्पर्श करेल व नंतर याहवेहस अर्पित शांत्यर्पणाचे सेवन करेल, त्याचा लोकातून उच्छेद व्हावा.’ ” ");
INSERT INTO marc_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएली लोकांस सांग: तुम्ही बैलांची, मेंढरांची किंवा शेळ्यांची चरबी खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","मेलेल्या प्राण्याची चरबी किंवा हिंस्त्र श्वापदाने फाडलेल्या प्राण्याची चरबी सापडली तर ती इतर कामासाठी वापरता येईल, परंतु तुम्ही ती खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","याहवेहला केलेल्या होमार्पणातील चरबी जो कोणी खाईल, त्याचा त्यांच्या लोकातून उच्छेद व्हावा. ");
INSERT INTO marc_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","जिथे कुठे तुम्ही राहाल, पशूचे किंवा पक्ष्याच्या रक्ताचे केव्हाही सेवन करू नये. ");
INSERT INTO marc_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","जो कोणी ते खाईल, त्याचा त्यांच्या लोकातून उच्छेद व्हावा.” ");
INSERT INTO marc_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","इस्राएली लोकांस सांग: जो कोणी याहवेहसाठी शांत्यर्पण आणेल, त्याने त्याचा काही भाग याहवेहला अर्पणासाठी वेगळा आणावा. ");
INSERT INTO marc_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","त्याने तो स्वहस्ते याहवेहस अर्पण करावा. चरबी व ऊर यांचे अर्पण आणून वेदीसमोर ओवाळले जाऊन ते याहवेहला ओवाळणीचे अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","मग याजक चरबीचे वेदीवर हवन करेल, पण ऊर अहरोन व त्याच्या पुत्रांचे होईल. ");
INSERT INTO marc_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","तू त्याची उजवी मांडी शांत्यर्पणाचा भाग म्हणून याजकास द्यावी. ");
INSERT INTO marc_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","अहरोनाच्या पुत्रांपैकी जो शांत्यर्पणातील रक्त व चरबी अर्पण करेल, त्याला त्याचा वाटा म्हणून उजवी मांडी देण्यात यावी. ");
INSERT INTO marc_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","कारण ओवाळणीचा ऊर आणि समर्पणाची मांडी ही इस्राएली लोकांतर्फे याजक अहरोन आणि त्याच्या पुत्रांना दिली आहेत. शांत्यर्पणाचा हा भाग त्यांचा सर्वकाळचा वाटा म्हणून देण्यात यावा. ");
INSERT INTO marc_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","होमार्पणातील हा भाग याहवेहची सेवा करण्यासाठी नेमलेल्या सर्व याजकांना, म्हणजेच अहरोन व त्याच्या पुत्रांना दिला पाहिजे. ");
INSERT INTO marc_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","कारण याहवेहनी त्यांचा अभिषेक केला, त्याच दिवशी त्यांनी इस्राएली लोकांना आज्ञा दिली की, त्यांनी हा सर्वकाळचा वाटा त्या वंशाला पिढ्यान् पिढ्या द्यावा. ");
INSERT INTO marc_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","होमार्पण, अन्नार्पण, पापार्पण, दोषार्पण, याजकांच्या अभिषेकाचे अर्पण व शांत्यर्पण यांच्या विधीसंबंधीचे हे नियम आहेत. ");
INSERT INTO marc_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","याहवेहनी हे नियम सीनाय पर्वतावर मोशेला दिले. सीनायच्या रानात इस्राएली लोकांना याहवेहप्रीत्यर्थ कोणती अर्पणे आणावी म्हणून मोशेला हे नियम देण्यात आले. ");
INSERT INTO marc_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“अहरोन आणि त्याच्या पुत्रांना, त्यांची वस्त्रे, अभिषेकाचे तेल, पापार्पणासाठी एक गोर्‍हा, दोन मेंढे आणि टोपलीभर बेखमीर भाकरी घेऊन ये, ");
INSERT INTO marc_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","आणि सर्व लोकांना सभामंडपाच्या प्रवेशद्वाराजवळ एकत्र कर.” ");
INSERT INTO marc_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","याहवेहने आज्ञा दिल्याप्रमाणे मोशेने केले आणि सर्व लोक सभामंडपाच्या प्रवेशद्वाराजवळ एकत्र जमले. ");
INSERT INTO marc_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","तेव्हा मोशेने सर्व लोकांना म्हटले, “याहवेहने जे करण्यास आज्ञा दिली आहे, ते हेच आहे.” ");
INSERT INTO marc_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","नंतर मोशेने अहरोन आणि त्याच्या पुत्रांना पुढे आणले आणि त्यांना पाण्याने आंघोळ घातली. ");
INSERT INTO marc_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","त्याने अहरोनास अंगरखा घातला, कंबरपट्टा कसला, झगा घातला, झग्यावर एफोद घातले, एफोदावर सुशोभित केलेला कमरबंद त्याच्या सभोवती बांधला. ");
INSERT INTO marc_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","नंतर त्याने अहरोनाला ऊरस्त्राण घातले व त्यात उरीम व थुम्मीम ठेवले. ");
INSERT INTO marc_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","नंतर त्याच्या डोक्यावर फेटा बांधला. त्या फेट्याच्या पुढील भागी सोन्याची एक पट्टी म्हणजे पवित्र मुद्रा जोडली, याहवेहने मोशेला आज्ञा दिल्यानुसार त्याने हे केले. ");
INSERT INTO marc_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","मग मोशेने अभिषेकाचे तेल घेऊन, निवासमंडप व त्यातील जे सर्वकाही होते, त्यांना अभिषेक करून ती पवित्र केली. ");
INSERT INTO marc_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","काही तेल त्याने वेदीवर सात वेळा शिंपडले; वेदी आणि त्यावरील सर्व उपकरणे, हात धुण्याचे भांडे व त्याची बैठक पवित्र करण्यासाठी त्याने ते तेल त्यांच्यावरही शिंपडले. ");
INSERT INTO marc_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","मग त्याने अभिषेकाचे थोडे तेल अहरोनाच्या डोक्यावर ओतून त्याला पवित्र केले. ");
INSERT INTO marc_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","मग मोशेने अहरोनाच्या पुत्रांना पुढे आणले, त्यांना झगे घातले, कमरपट्टे कसले व फेटे बांधले, याहवेहने मोशेला आज्ञा दिल्यानुसार त्याने हे केले. ");
INSERT INTO marc_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","मग मोशेने पापार्पणाच्या यज्ञबलीसाठी एक गोर्‍हा आणला आणि अहरोन व त्याच्या पुत्रांनी त्या गोर्‍ह्याच्या डोक्यावर आपले हात ठेवले. ");
INSERT INTO marc_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","मग मोशेने त्या गोर्‍ह्याचा वध केला आणि वेदी पवित्र करण्यासाठी त्या गोर्‍ह्याचे रक्त वेदी व तिची चारही शिंगे यांना आपल्या बोटांनी लावले. शिल्लक राहिलेले रक्त वेदीच्या पायथ्याशी ओतले. अशाप्रकारे वेदीसाठी प्रायश्चित्त करून त्याने वेदी पवित्र केली. ");
INSERT INTO marc_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मोशेने आतड्यांवरील सर्व चरबी, काळजावरील लांब पाळ, दोन्ही गुरदे काढून घेऊन तिचे वेदीवर हवन केले. ");
INSERT INTO marc_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","याहवेहने आज्ञा दिल्याप्रमाणे मोशेने गोर्‍हा, त्याची कातडी, त्याचे मांस आणि आतडी छावणीबाहेर नेऊन जाळून टाकले. ");
INSERT INTO marc_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","नंतर त्याने होमार्पणासाठी एक मेंढा घेतला आणि अहरोन व त्याच्या पुत्रांनी त्याच्या डोक्यावर आपले हात ठेवले. ");
INSERT INTO marc_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","नंतर मोशेने त्याचा वध केला आणि त्या मेंढ्याचे रक्त वेदीभोवती शिंपडले. ");
INSERT INTO marc_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","मग मोशेने तो मेंढा कापून त्याचे तुकडे केले आणि त्या तुकड्यांसह डोके व चरबी यांचा होम केला. ");
INSERT INTO marc_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","त्याची आतडी व खूर पाण्याने धुऊन त्याने संपूर्ण मेंढ्याचे वेदीवर होम केले. हे होमार्पण आहे. ते सुवासिक असे, याहवेहसाठी सादर केलेले अन्नार्पण आहे, जसे याहवेहने मोशेला आज्ञा केली होती. ");
INSERT INTO marc_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","मग मोशेने दुसरा मेंढा, अर्थात् समर्पणाचा मेंढा घेतला व अहरोन व त्याच्या पुत्रांनी मेंढ्याच्या डोक्यावर आपले हात ठेवले. ");
INSERT INTO marc_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","मग मोशेने त्याचा वध केला व त्याचे काही रक्त घेऊन ते अहरोनाच्या उजव्या कानाच्या पाळीला व उजव्या हाताच्या व उजव्या पायाच्या अंगठ्यांना लावले. ");
INSERT INTO marc_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","नंतर मोशेने काही रक्त अहरोनाच्या पुत्रांच्या उजव्या कानाच्या पाळ्यांना व उजव्या हाताच्या आणि उजव्या पायाच्या अंगठ्यांना लावले. उर्वरित सर्व रक्त त्याने वेदीभोवती शिंपडले. ");
INSERT INTO marc_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","मग त्याने सर्व चरबी आणि चरबीदार शेपूट, आतड्यांवरील चरबी, चरबीसह दोन्ही गुरदे, काळजाची लांब पाळ व उजवी मांडी ही घेतली. ");
INSERT INTO marc_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","आणि बेखमीर भाकरीची टोपली, जी याहवेहसमोर होती त्यातून त्याने एक जाड भाकर, जैतुनाच्या तेलात मळलेली एक जाड भाकर आणि एक पातळ भाकर घेतली, आणि त्याने ते सर्व चरबीच्या भागावर आणि उजव्या मांडीवर ठेवले. ");
INSERT INTO marc_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","त्याने हे सर्व अहरोन व त्याच्या पुत्रांच्या हातांवर ठेवले आणि त्यांनी ते याहवेहसमोर हेलावणीचे अर्पण घेऊन त्याची ओवाळणी केली. ");
INSERT INTO marc_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","नंतर मोशेने ते सर्व त्यांच्या हातातून घेतले आणि ते वेदीवर होमार्पणासहित समर्पणाचे अर्पण म्हणून सादर केले, हा याहवेहला सुवास म्हणून अर्पिलेले अन्नार्पण होते. ");
INSERT INTO marc_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","मग मोशेने मेंढ्याच्या उराचा भाग घेतला, हा समर्पणाच्या गोर्‍ह्याचा त्याचा स्वतःचा वाटा होता, तो त्याने ओवाळणीचे अर्पण म्हणून याहवेहसमोर ओवाळले. याहवेहने दिलेल्या आज्ञेप्रमाणे मोशेने हे केले. ");
INSERT INTO marc_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","नंतर मोशेने अभिषेकाचे थोडे तेल व वेदीवरील थोडे रक्त घेऊन अहरोन व त्याच्या वस्त्रावर आणि त्याच्या पुत्रांवर व त्यांच्या वस्त्रांवर शिंपडले. अशारितीने मोशेने अहरोन व त्याचे पुत्र यांना याहवेहच्या सेवेसाठी पवित्र केले. ");
INSERT INTO marc_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","मग मोशे, अहरोन व त्याच्या पुत्रांना म्हणाला, “मी तुम्हाला आज्ञा दिली होती त्याप्रमाणे, सभामंडपाच्या प्रवेशद्वारात मांस शिजवा व ते मांस टोपलीतील समर्पित भाकरीसह खावे. ");
INSERT INTO marc_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","उरलेले मांस व भाकरी मात्र अग्नीत जाळून टाका. ");
INSERT INTO marc_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","मग सात दिवस पूर्ण होईपर्यंत तुम्ही सभामंडपाच्या द्वाराबाहेर जाऊ नका, कारण तुमचा समर्पणविधी सात दिवसाचा आहे. ");
INSERT INTO marc_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","आज जो विधी करण्यात आला तो तुमच्या प्रायश्चित्तासाठी याहवेहने दिलेल्या आज्ञेप्रमाणे करण्यात आला. ");
INSERT INTO marc_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","शिवाय, सात दिवस सभामंडपाच्या प्रवेशद्वाराजवळ रात्रंदिवस राहून, याहवेहने दिलेल्या आज्ञेचे पालन केल्याने तुम्ही मरणार नाही, कारण मला अशी आज्ञा देण्यात आली आहे.” ");
INSERT INTO marc_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","तेव्हा अहरोन आणि त्याच्या पुत्रांनी ते सर्वकाही केले जे करण्याची आज्ञा याहवेहनी मोशेद्वारे त्यांना दिली होती. ");
INSERT INTO marc_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठव्या दिवशी मोशेने अहरोन आणि त्याचे पुत्र व इस्राएलच्या पुढाऱ्यांना बोलाविले. ");
INSERT INTO marc_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","तो अहरोनाला म्हणाला, “तुझ्या पापार्पणासाठी व्यंग नसलेला एक गोर्‍हा व होमार्पणासाठी व्यंग नसलेला एक मेंढा घेऊन याहवेहसमोर अर्पण कर. ");
INSERT INTO marc_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","मग इस्राएली लोकांना सांग: तुम्ही तुमच्या पापार्पणासाठी एक बोकड व होमार्पणासाठी एक गोर्‍हा व एक कोकरू निवडून घ्यावे. ही दोन्ही एका वर्षांची असून व्यंग नसलेली असावीत, ");
INSERT INTO marc_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","आणि याहवेहसमोर शांत्यर्पणाचे बली म्हणून एक गोर्‍हा आणि एक मेंढा व अन्नार्पणासाठी तेल मिसळलेले अन्नबली आणावे. कारण याहवेह आज तुम्हाला दर्शन देणार आहेत.” ");
INSERT INTO marc_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","म्हणून मोशेने दिलेल्या आज्ञेप्रमाणे लोकांनी सभामंडपापुढे सर्वकाही आणले आणि संपूर्ण मंडळी याहवेहसमोर येऊन उभी राहिली. ");
INSERT INTO marc_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","तेव्हा मोशे म्हणाला, “हे करण्याची आज्ञा तुम्हाला याहवेहनी दिली आहे, जेणेकरून याहवेहचे गौरव तुम्हाला प्रकट व्हावे.” ");
INSERT INTO marc_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","मोशेने अहरोनाला सांगितले, “वेदीजवळ ये आणि तुझे पापार्पण आणि तुझे होमार्पण यांचे अर्पण कर आणि स्वतःसाठी आणि लोकांसाठी प्रायश्चित्त कर; लोकांसाठी बलीचे अर्पण कर आणि त्यांच्यासाठी प्रायश्चित्त कर, याहवेहने आज्ञा दिली त्याप्रमाणे ते कर.” ");
INSERT INTO marc_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","तेव्हा अहरोन वेदीजवळ गेला आणि त्याने स्वतःच्या पापासाठी गोर्‍ह्याचा वध केला. ");
INSERT INTO marc_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","मग अहरोनाचे पुत्र त्या गोर्‍ह्याचे रक्त घेऊन त्याच्याकडे आले आणि अहरोनाने आपले बोट रक्तात बुडवून ते वेदीच्या शिंगांना लावले; उर्वरित रक्त त्याने वेदीच्या पायथ्याशी ओतून दिले. ");
INSERT INTO marc_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","याहवेहनी मोशेला आज्ञा दिल्याप्रमाणे अहरोनाने पापार्पणाची चरबी, गुरदे व काळजावरील चरबीचा पडदा यांचा वेदीवर होम केला. ");
INSERT INTO marc_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","कातडे व मांस मात्र त्याने वस्तीबाहेर नेऊन अग्नीत जाळले. ");
INSERT INTO marc_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","मग अहरोनाने स्वतःच्या होमबलीचा वध केला आणि त्या बलीचे रक्त त्याच्या पुत्रांनी त्याला सोपवून दिले व त्याने ते वेदीभोवती शिंपडले. ");
INSERT INTO marc_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","मग त्यांनी त्या होमबलीचे तुकडे केले व ते तुकडे शिरासह अहरोनाकडे दिले आणि अहरोनाने त्या प्रत्येक भागाचा वेदीवर होम केला. ");
INSERT INTO marc_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","त्याने आतडी व पाय धुऊन वेदीवरील होमार्पणासह त्यांचा होम केला. ");
INSERT INTO marc_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","मग लोकांनी आणलेली अर्पणे अहरोनाने अर्पण केली. लोकांसाठी पापार्पण म्हणून आणलेल्या पापबलीच्या बोकडाचा जसा वध केला, तसाच या बोकडाचाही वध केला. ");
INSERT INTO marc_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","नंतर त्याने होमार्पण आणले आणि सूचना दिल्याप्रमाणे त्याचे अर्पण केले. ");
INSERT INTO marc_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","मग त्याने सकाळच्या होमार्पणाबरोबर अन्नार्पणही सादर केले व त्यातील मूठभर धान्य वेदीवर जाळून टाकले. ");
INSERT INTO marc_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","यानंतर अहरोनाने लोकांच्या शांत्यर्पणाच्या गोर्‍ह्याचा आणि मेंढ्यांचा वध केला आणि त्याच्या पुत्रांनी त्याला रक्त सोपविले आणि त्याने ते वेदीच्या सभोवार शिंपडले. ");
INSERT INTO marc_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","परंतु त्याने गोर्‍ह्याची व मेंढ्याची चरबी, म्हणजे चरबीदार शेपूट, आतड्यांवरील चरबी, गुरदे आणि काळजावरील चरबीचा पडदा ");
INSERT INTO marc_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","त्या बलींच्या उरांवर ठेवली, मग अहरोनाने त्या सर्वांचा वेदीवर होम केला. ");
INSERT INTO marc_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","मोशेच्या आज्ञेप्रमाणे अहरोनाने ऊर व उजवी मांडी यांचे याहवेहसमोर ओवाळणीचे अर्पण केले. ");
INSERT INTO marc_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","मग अहरोनाने आपले हात लोकांकडे उभारून त्यांना आशीर्वाद दिला आणि जिथे त्याने पापार्पण, होमार्पण व शांत्यर्पण वाहिले होते तिथून उतरून तो खाली आला. ");
INSERT INTO marc_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","नंतर मोशे व अहरोन सभामंडपात गेले. ते परत बाहेर आले, तेव्हा त्यांनी लोकांना आशीर्वाद दिला आणि याहवेहचे वैभव सर्वांना प्रकट झाले. ");
INSERT INTO marc_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","याहवेहपासून अग्नी येऊन त्याने वेदीवरील होमार्पण व चरबीही भस्म केली. जेव्हा लोकांनी ते पाहिले तेव्हा त्यांनी मोठ्या आवाजाने जयजयकार केला आणि जमिनीवर लोटांगण घातले. ");
INSERT INTO marc_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","अहरोनाचे पुत्र नादाब व अबीहू यांनी आपआपल्या धुपाटण्यात अग्नी भरून, त्यावर धूप ठेवून तो अनाधिकृत अग्नी याहवेहसमोर नेला, जे याहवेहच्या आज्ञेविरुद्ध होते. ");
INSERT INTO marc_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","म्हणून याहवेहकडून अग्नी निघाला आणि त्याने त्यांना भस्म केले आणि ते याहवेहसमोर मरण पावले. ");
INSERT INTO marc_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","तेव्हा मोशे अहरोनास म्हणाला, “याहवेहने जे सांगितले ते असे: “ ‘जे माझ्याजवळ येतात त्यांना मी दाखवेन की मी पवित्र आहे; सर्व लोकांसमक्ष माझे गौरव होईल.’ ” यावर अहरोन शांत राहिला. ");
INSERT INTO marc_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मग मोशेने अहरोनाचा चुलता उज्जीएलाचे पुत्र मिशाएल व एलसाफान यांना बोलावून सांगितले, “तुम्ही इकडे या आणि पवित्र स्थानासमोरील तुमच्या भावांची शरीरे उचलून छावणीबाहेर न्या.” ");
INSERT INTO marc_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","तेव्हा मोशेने आज्ञा केल्याप्रमाणे त्यांनी जाऊन ती उचलली आणि त्यांच्या अंगरख्यांसह ती बाहेर नेली. ");
INSERT INTO marc_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","मग मोशे अहरोन व त्याचे पुत्र एलअज़ार व इथामार यांना म्हणाला, “तुमचे केस न विंचरलेले असे मोकळे सोडू नका व तुमची वस्त्रे कधी फाडू नका, नाहीतर तुम्ही मराल आणि याहवेह तुम्हा सर्व समुदायावर रागावतील. परंतु तुमचे नातेवाईक, सर्व इस्राएली लोक याहवेहनी अग्नीने नाश केलेल्या लोकांबद्दल शोक करतील. ");
INSERT INTO marc_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","सभामंडपाचे प्रवेशद्वार सोडू नका, नाही तर तुम्ही मराल, कारण याहवेहच्या अभिषेकाचे तेल तुम्हावर आहे.” तेव्हा त्यांनी मोशेच्या आज्ञेप्रमाणे केले. ");
INSERT INTO marc_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","मग याहवेहने अहरोनाला आज्ञा दिली, ");
INSERT INTO marc_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“तू सभामंडपात जाशील तेव्हा द्राक्षारस किंवा कोणतेही आंबवलेले पेय पिऊन तिथे जाऊ नकोस, नाहीतर तू मरशील. हा नियम तुझ्या पुत्रांना व त्यांच्या पुत्र पौत्रांना पिढ्यान् पिढ्या लागू आहे, ");
INSERT INTO marc_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","यासाठी की पवित्र व अपवित्र, शुद्ध व अशुद्ध यातील भेद तुला कळेल. ");
INSERT INTO marc_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","आणि याहवेहने मोशेद्वारे दिलेल्या आज्ञांचे शिक्षण इस्राएली लोकांना देणे हे तुमचे कर्तव्य राहील.” ");
INSERT INTO marc_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","अहरोन आणि त्याचे जिवंत राहिलेले पुत्र एलअज़ार आणि इथामारला मोशे म्हणाला, “खमिराशिवाय तयार केलेल्या अन्नार्पणातून उरलेले धान्यार्पण घेऊन याहवेहला अर्पण करा आणि ते तुम्ही वेदीजवळ बसून खावे, कारण ते परमपवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ते तुम्ही पवित्रस्थानी बसून खावे, कारण याहवेहला अर्पण केलेल्या यज्ञपशूचा तो भाग तुमच्यासाठी व तुमच्या मुलांसाठी ठरलेला वाटा आहे; कारण मला तशी आज्ञा देण्यात आली आहे. ");
INSERT INTO marc_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","परंतु अर्पण केलेला ऊर व समर्पित केलेली मांडी मात्र तुम्ही कोणत्याही विधिनियमानुसार शुद्ध केलेल्या जागी बसून खावी. इस्राएली लोकांनी अर्पिलेल्या शांत्यर्पणाचा हा भाग तुमचे पुत्र व कन्या यांच्यासाठी आहे. ");
INSERT INTO marc_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","मग मोशे पुढे म्हणाला, मांडी व ऊर दोन्ही चरबीसह याहवेहसमोर आणावी व ती झोके देऊन परमेश्वराला अर्पण करावी. याहवेहनी आज्ञा दिल्याप्रमाणे हे सर्व भाग सर्वकाळ तुमच्या व तुमच्या मुलांचा वाटा समजावे.” ");
INSERT INTO marc_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","जेव्हा मोशेने पापार्पणाच्या बोकडाचा शोध घेतला, तेव्हा त्याला समजले की तो जाळून टाकण्यात आला आहे. तेव्हा अहरोनाचे बाकी असलेले पुत्र एलअज़ार व इथामार यांच्यावर तो संतापला. ");
INSERT INTO marc_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“तुम्ही पापबली पवित्रस्थानात का खाल्ला नाही? ते परमपवित्र आहे; आणि समुदायाची पापे दूर करण्यासाठी आणि याहवेहसमोर त्यांच्याकरिता प्रायश्चित्त करण्यासाठी याहवेहने ते तुम्हाला दिले आहे. ");
INSERT INTO marc_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","पाहा, त्याचे रक्त पवित्रस्थानात आणले नव्हते, म्हणून माझ्या आज्ञेप्रमाणे तुम्ही तो पवित्रस्थानात खावयाचा होता.” ");
INSERT INTO marc_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","तेव्हा अहरोन मोशेला म्हणाला, “पाहा त्यांनी आजच त्यांचे पापार्पण व होमार्पण परमेश्वराला अर्पण केले, म्हणून मजवर अशा आपत्ती ओढविल्या. तेव्हा आज मी माझ्या दुःखाच्या दिवसात तो पापबली खाल्ला असता, तर ते याहवेहला आवडले असते काय?” ");
INSERT INTO marc_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","हे ऐकल्यावर मोशेचे समाधान झाले. ");
INSERT INTO marc_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","याहवेह मोशे व अहरोन यांना म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएली लोकांना सांग: पृथ्वीवर राहणार्‍या सर्व प्राण्यांपैकी हे प्राणी तुम्ही खाऊ शकता. ");
INSERT INTO marc_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ज्यांचे खूर दुभागलेले आहेत आणि जे प्राणी रवंथ करतात असे कोणतेही प्राणी तुम्ही खाऊ शकता. ");
INSERT INTO marc_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“जे प्राणी फक्त रवंथ करतात किंवा त्यांचे फक्त खूर दुभागलेले आहेत, ते तुम्ही खाऊ नयेत. उंट जरी रवंथ करतात तरी त्यांचे खूर दुभागलेले नसतात; ते तुमच्यासाठी अशुद्ध आहेत. ");
INSERT INTO marc_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","रानससा जरी रवंथ करतो तरी त्याचे खूर दुभागलेले नसतात. तो तुमच्यासाठी अशुद्ध आहे. ");
INSERT INTO marc_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ससा जरी रवंथ करतो, तरी त्याचे खूर दुभागलेले नसतात; तो तुमच्यासाठी अशुद्ध आहे. ");
INSERT INTO marc_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","डुकरे देखील अशुद्ध आहेत; जरी त्यांचे दुभागलेले खूर आहेत, तरी ते रवंथ करीत नाहीत. ");
INSERT INTO marc_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","त्यांचे मांस तुम्ही खाऊ नये किंवा त्यांच्या मृतशरीरांना स्पर्श करू नये; ते तुमच्यासाठी अशुद्ध आहेत. ");
INSERT INTO marc_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“समुद्राच्या आणि नद्यांच्या पाण्यात राहणार्‍या सर्व प्राण्यांपैकी तुम्ही कल्ले आणि खवले असलेले कोणतेही प्राणी खाऊ शकता. ");
INSERT INTO marc_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","पण ज्यांना कल्ले व खवले नाहीत—मग ते समुद्रात राहणारे वा इतर जलचर असोत—असे सर्व मासे तुम्हाला निर्विवाद अशुद्ध असून निषिद्ध आहेत. ");
INSERT INTO marc_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","तुम्ही ते अशुद्ध समजावे व ते खाऊ नयेत किंवा त्यांच्या मृतशरीरांना स्पर्शही करू नये. ");
INSERT INTO marc_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ज्यांना कल्ले व खवले नाहीत असा प्रत्येक जलचर प्राणी तुम्हाला निषिद्ध आहे. ");
INSERT INTO marc_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“जे पक्षी तुम्ही अशुद्ध समजावेत आणि ते तुम्ही खाऊ नयेत कारण ते अशुद्ध आहेत ते हे: गरुड, गिधाड, काळे गिधाड, ");
INSERT INTO marc_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","लाल पतंग, कोणत्याही जातीचे काळे पतंग, ");
INSERT INTO marc_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","कोणत्याही जातीचे कावळे, ");
INSERT INTO marc_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","शिंग असलेले घुबड, किंचाळणारे घुबड, समुद्रपक्षी, सर्व जातीचे बहिरी ससाणे, ");
INSERT INTO marc_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","लहान घुबड, करढोक, मोठे घुबड, ");
INSERT INTO marc_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","पांढरे घुबड, वाळवंटी घुबड, कुरर, ");
INSERT INTO marc_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","करकोचा, कोणत्याही प्रकारचे बगळे, टिटवी आणि वटवाघूळ.” ");
INSERT INTO marc_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","चार पाय असलेले उडणारे कीटक तुम्ही खाऊ नये, ते तुमच्यासाठी अशुद्ध समजले जातात. ");
INSERT INTO marc_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","तरीसुद्धा उडणारे कीटक, जे त्यांच्या चारही पायांवर चालतातः जमिनीवर उड्या मारण्याकरिता ज्यांच्या पायांवर एकजोड असतो, ते तुम्ही खाऊ शकता. ");
INSERT INTO marc_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","उड्या मारीत चालणारे सर्व जातींचे टोळ, नाकतोडे, खरपुडे व गवतेटोळ तुम्ही खावेत. ");
INSERT INTO marc_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","मात्र चार पाय असून जे उडतात ते सर्व कीटक तुम्हाला निषिद्ध आहेत. ");
INSERT INTO marc_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","वर उल्लेखलेल्या प्राण्यांमुळे तुम्ही अशुद्ध व्हाल, जो कोणी त्यांच्या मृतशरीराना स्पर्श करेल तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","जे कोणी त्यांचे मृतदेह उचलतील त्यांनी त्यांची वस्त्रे धुवावीत आणि ते संध्याकाळपर्यंत अशुद्ध राहतील. ");
INSERT INTO marc_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ज्या प्राण्यांचे खूर अर्धवट दुभागलेले आहेत किंवा जे प्राणी रवंथ करीत नाहीत, अशा प्राण्यांच्या मृतशरीरांना तुम्ही स्पर्श केलात, तर तुम्ही अशुद्ध व्हाल. ");
INSERT INTO marc_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","पंजांवर चालणारा प्रत्येक प्राणी खाण्यास तुम्हाला मनाई आहे. अशा प्राण्याच्या मृत शरीराला जो स्पर्श करेल त्याने संध्याकाळपर्यंत अशुद्ध राहावे. ");
INSERT INTO marc_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","जो कोणी त्याचे मृतदेह उचलून नेईल त्याने संध्याकाळपर्यंत अशुची राहावे. तो प्राणी तुम्ही अशुद्ध समजावा. ");
INSERT INTO marc_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","जमिनीवर सरपटणार्‍या प्राण्यांपैकी तुम्ही अशुद्ध समजावे ते हे: मुंगूस, उंदीर, सरडे, ");
INSERT INTO marc_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","घोरपड, घुशी, पाल, मगर, गोगलगाय व गुहिर्‍या सरडा. ");
INSERT INTO marc_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","जमिनीवर सरपटणार्‍यापैकी ही सर्व तुम्हाला निषिद्ध होत; जो कोणी त्यांच्या मृत शरीराला स्पर्श करेल, त्याने संध्याकाळपर्यंत अशुद्ध राहावे. ");
INSERT INTO marc_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","त्यांच्यापैकी कोणी मरून एखाद्या वस्तूवर पडले तर ती वस्तूही अशुद्ध समजावी; काष्ठपात्रे, वस्त्रे, कातडे, गोणपाट किंवा कोणत्याही कामाचे हत्यार असो, ते पाण्यात टाकावे व संध्याकाळपर्यंत अशुद्ध समजावे; नंतर ते शुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","त्यापैकी एखादा प्राणी मातीच्या पात्रात पडला, तर त्या पात्रात जे काही असेल ते अशुद्ध समजावे व ते पात्र फोडून टाकावे. ");
INSERT INTO marc_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","अशाप्रकारे अशुद्ध झालेली वस्तू धुण्यासाठी वापरलेल्या पाण्याचा जर एखाद्या पदार्थाला स्पर्श झाला, तर ते सर्व अशुद्ध समजावे. अशुद्ध भांड्यातील कोणतेही पेय अशुद्ध आहे. ");
INSERT INTO marc_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","अशा प्राण्यांच्या मृत शरीराचा स्पर्श चुलीला किंवा एखाद्या भांड्याला झाला तर ते अशुद्ध होय. अशा अशुद्ध चुलीचा व भांड्याचा नाश करावा. ");
INSERT INTO marc_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","जर एखाद्या प्राण्याचे मृतदेह पाणी असलेल्या एखाद्या झर्‍यात किंवा हौदात पडले, तरी ते पाणी शुद्धच राहते. तरीपण जो त्या मृत शरीराला स्पर्श करेल त्याला अशुद्ध समजावे. ");
INSERT INTO marc_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","जर शेतात पेरण्याच्या बियाण्यांना त्यांच्या मृत शरीराचा स्पर्श झाला तर ते शुद्धच राहते; ");
INSERT INTO marc_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","पण ओल्या बियाण्यावर मृतदेह पडले तर ते बियाणे तुमच्यासाठी अशुद्ध आहेत. ");
INSERT INTO marc_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","तुम्हाला खाण्यास मोकळीक असलेला प्राणी आजारी पडून मेला, तर अशा प्राण्याच्या मृत शरीराला जो कोणी स्पर्श करेल तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","त्याचप्रमाणे जो कोणी त्या प्राण्याचे मांस खाईल किंवा त्याचे मृतदेह वाहून नेईल, त्याने आपली वस्त्रे धुवावीत; तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","जमिनीवर सरपटत जाणारे सर्व प्राणी अशुद्ध आहेत. ते खाऊ नयेत. ");
INSERT INTO marc_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","जे पोटावर सरपटतात, चार पायांवर खुरडत चालतात वा ज्यांना अनेक पाय असतात असे प्राणी तुम्ही खाऊ नयेत, कारण ते अशुद्ध आहेत. ");
INSERT INTO marc_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","झुंडीने राहणाऱ्या अशा कोणत्याही प्राण्यांना स्पर्श करून तुम्ही अशुद्ध होऊ नये. त्यांच्याद्वारे किंवा त्यांच्यामुळे स्वतःला अशुद्ध करू नका. ");
INSERT INTO marc_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","मी याहवेह तुमचा परमेश्वर आहे; म्हणून तुम्ही स्वतःस पवित्र ठेवावे. मी पवित्र आहे, म्हणून तुम्हीही पवित्र राहावे. म्हणून तुम्ही जमिनीवर सरपटणार्‍या कोणत्याही प्राण्याला स्पर्श करून स्वतःस विटाळवून घेऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","मी याहवेह आहे, ज्याने तुम्हाला इजिप्त देशातून बाहेर आणले यासाठी की मी तुमचा परमेश्वर असावा; म्हणून पवित्र व्हा, कारण मी पवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“पशू, पक्षी, प्रत्येक जलचर आणि प्रत्येक प्राणी जे जमिनीवर सरपटणारे आहेत त्यांच्यासंबंधी हे नियम आहेत. ");
INSERT INTO marc_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","शुद्ध व अशुद्ध प्राणी तुम्ही खावे वा खाऊ नये यामधील फरक दाखविण्यासाठी हे नियम आहेत.” ");
INSERT INTO marc_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएली लोकांना सांग: एखादी स्त्री गरोदर राहिली आणि तिला पुत्र झाल्यास, ती आई विधीनियमाप्रमाणे सात दिवस अशुद्ध राहील. मासिक पाळीच्या वेळी जशी ती असते, तशीच ती अशुद्ध समजावी. ");
INSERT INTO marc_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","आठव्या दिवशी तिच्या पुत्राची सुंता करावी. ");
INSERT INTO marc_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","नंतर पुढील तेहतीस दिवस संपेपर्यंत ती बाळंतपणात होणार्‍या आपल्या रक्तस्त्रावाच्या अशुद्धतेपासून शुद्ध होत असताना, तिने कोणत्याही पवित्र वस्तूला स्पर्श करू नये अथवा पवित्रस्थानात जाऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","जर ती कन्येला जन्म देईल, तर ती स्त्री जशी तिच्या मासिक पाळीच्या वेळेस अशुद्ध राहते तशी ती चौदा दिवस अशुद्ध राहील. नंतर रक्तस्त्रावापासून शुद्ध होण्यासाठी तिने सहासष्ट दिवस वाट पाहावी.” ");
INSERT INTO marc_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","हे शुद्ध होण्याचे दिवस संपल्यानंतर तिला पुत्र झालेला असो की कन्या, तिला पुढील नियम लागू आहेत: तिने होमार्पणासाठी एक वर्षाचे कोकरू आणावे व पापार्पणासाठी होला किंवा पारव्याचे पिलू सभामंडपाच्या दाराशी याजकाकडे घेऊन जावे. ");
INSERT INTO marc_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","याजक याहवेहला ते अर्पण करून तिच्यासाठी प्रायश्चित्त करेल म्हणजे बाळंतपणात होणार्‍या रक्तस्त्रावापासून ती विधिपूर्वक शुद्ध होईल. पुत्र किंवा कन्या झालेल्या स्त्री विषयी हा विधिनियम आहे. ");
INSERT INTO marc_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","जर कोकरू आणण्याइतकी तिची ऐपत नसेल, तर तिने एक होमार्पणासाठी व दुसरे पापार्पणासाठी दोन कबुतरे किंवा पारव्याची दोन पिल्ले आणावी. त्याचे अर्पण करून याजक तिच्यासाठी प्रायश्चित्त करेल, म्हणजे ती पुन्हा विधिपूर्वक शुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","याहवेह मोशे व अहरोन यांना म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“जेव्हा एखाद्या मनुष्याच्या त्वचेवर सूज, पुरळ किंवा पुटकुळी आली आणि त्यामुळे त्याची त्वचा पांढरी झाली असली, तो कुष्ठरोगाचा चट्टा असेल, त्याला अहरोन याजकाकडे किंवा याजक असलेले त्याचे पुत्र यापैकी एकाकडे आणावे. ");
INSERT INTO marc_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","याजकाने त्या व्यक्तीच्या त्वचेवरील चट्टा तपासावा आणि चट्ट्यावरील केस पांढरे झाले असतील व तो त्वचेपेक्षा खोल गेलेला असेल, तर हा कुष्ठरोग समजावा; आणि याजकाने त्या व्यक्तीचा तपासणी केल्यावर, त्याला विधिनियमानुसार अशुद्ध म्हणून जाहीर करावे. ");
INSERT INTO marc_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","जर त्वचेवरील चट्टा पांढरा असेल, परंतु तो चट्टा त्वचेपेक्षा खोल गेलेला नसेल व त्यावरील केस पांढरे झाले नसतील, तर याजकाने चट्टा पडलेल्या व्यक्तीला सात दिवस वेगळे ठेवावे. ");
INSERT INTO marc_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","सातव्या दिवशी, याजकाने त्याची तपासणी करावी आणि त्वचेवरील चट्टा अधिक पसरलेला नसेल, तर याजकाने त्याला आणखी सात दिवस वेगळे ठेवावे. ");
INSERT INTO marc_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","सातव्या दिवशी, याजकाने त्याची पुन्हा तपासणी करावी आणि चट्टा बुजत चालला आहे व तो त्वचेवर पसरला नसेल, तर तो शुद्ध झाला आहे, असे याजकाने जाहीर करावे; कारण तो साधारण खवंद होय. त्या मनुष्याने आपले कपडे धुवावेत आणि पूर्ववत शुद्ध व्हावे. ");
INSERT INTO marc_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","परंतु याजकापुढे शुद्ध सिद्ध झाल्यावर, तो चट्टा त्वचेवर पसरू लागला, तर त्या व्यक्तीने स्वतःला पुन्हा याजकासमोर हजर करावे. ");
INSERT INTO marc_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","याजकाने त्या व्यक्तीची तपासणी करावी आणि खवंद त्वचेवर पसरलेला दिसून आल्यास, त्याला अशुद्ध असे जाहीर करावे; तो कुष्ठरोग आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“एखाद्या मनुष्याला कुष्ठरोग झाला असेल, तर त्याला याजकाकडे न्यावे. ");
INSERT INTO marc_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","याजकाने त्याची तपासणी करावी आणि त्वचेवर पांढरी सूज येऊन आणि तेथील केस पांढरे झाले असतील आणि सूजेवर उघडी जखम आढळल्यास, ");
INSERT INTO marc_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","तर हा जुना कुष्ठरोग असून याजकाने त्या व्यक्तीला अशुद्ध म्हणून जाहीर करावे, यापुढे त्याला अधिक तपासणीसाठी वेगळे ठेवू नये; कारण तो अशुद्धच आहे.” ");
INSERT INTO marc_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","जर कुष्ठरोग सर्व त्वचेवर पसरलेला असेल आणि याजक जितके पाहू शकतो तितके म्हणजे डोक्यापासून पायापर्यंत पसरलेला असेल तर, ");
INSERT INTO marc_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","याजकाने त्याची तपासणी करावी आणि ते कोड संपूर्ण शरीरावर पसरलेले असेल तर त्याने त्याला शुद्ध म्हणून जाहीर करावे. कुष्ठरोगापासून बरा झाला आहे, असे जाहीर करावे; कारण तो संपूर्ण शुभ्र झाला आहे, म्हणजेच तो शुद्ध होय. ");
INSERT INTO marc_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","परंतु त्यांच्यावर उघडी जखम आढळल्यास, ते अशुद्ध समजावे. ");
INSERT INTO marc_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","याजकाने त्वचेवरील जखम पाहून त्या व्यक्तीला अशुद्ध जाहीर करावे; त्वचा नसलेले मांस अशुद्ध असून ते कुष्ठरोग आहे; हा गंभीर आजार आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","परंतु उघडी जखम फिरून पांढरी पडली तर त्या कुष्ठरोग्याने याजकाकडे यावे. ");
INSERT INTO marc_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","याजकाने त्यांना तपासावे, जर तो भाग खरोखर पूर्णपणे पांढरा झालेला असेल, तर तो मनुष्य शुद्ध झाला आहे, असे याजकाने जाहीर करावे. ");
INSERT INTO marc_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ज्या माणसाच्या त्वचेवर फोड येऊन पुढे तो फोड बरा झाला ");
INSERT INTO marc_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","व फोडाच्या जागी तांबूस पांढरा चट्टा राहिला, तर त्याने याजकाकडे तपासणीसाठी गेले पाहिजे. ");
INSERT INTO marc_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","याजकाने त्याची तपासणी करावी आणि जर तो चट्टा त्वचेखाली खोलवर गेला असेल आणि त्याच्यावरील केस पांढरे झाले असतील, तर याजकाने त्याला अशुद्ध म्हणून जाहीर करावे; कारण फोडामधून कुष्ठरोग निर्माण झाला आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","पण तपासणीनंतर त्या चट्ट्यामध्ये पांढरे केस नाहीत आणि चट्टा त्वचेत खोल गेला नाही व त्याचा रंग करडा आहे, असे याजकाला दिसून आले असेल, तर याजकाने त्याला सात दिवस वेगळे ठेवावे. ");
INSERT INTO marc_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","त्या कालावधीत तो चट्टा पसरत गेला आहे असे दिसले, तर याजकाने त्यास अशुद्ध ठरवावे; तो गंभीर आजार आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","पण पांढरा चट्टा वाढला नाही किंवा पसरला नाही. तर तो केवळ फोडाचा व्रण आहे; म्हणून याजकाने तो मनुष्य शुद्ध आहे असे जाहीर करावे. ");
INSERT INTO marc_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","एखादा काही कारणाने भाजला व जळालेली जागा लालसर पांढरी किंवा नुसती पांढरी झाली असे दिसून आले, ");
INSERT INTO marc_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","तर याजकाने तो चट्टा अवश्य तपासावा. जर चट्ट्यावरील केस पांढरे झाले असतील, आणि तो त्वचेपेक्षा खोल गेला आहे असे दिसून आले, तर त्या जळालेल्या भागी कुष्ठरोग फुटला असे समजावे; याजकाने त्यास अशुद्ध जाहीर करावे; तो मनुष्य कुष्ठरोगी आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","पण तपासणीनंतर त्या पांढर्‍या चट्ट्यावरील केस पांढरे झालेले नाहीत, आणि पांढरेपणा त्वचेच्या खोलवर गेलेला नाही व तो हळूहळू कमी होत आहे, असे जर याजकाला दिसून आले, तर याजकाने त्याला सात दिवसापर्यंत वेगळे ठेवावे; ");
INSERT INTO marc_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","सातव्या दिवशी याजकाने त्याची तपासणी करावी आणि जर चट्टा त्वचेवर पसरत गेला असेल, तर याजकाने त्यास अशुद्ध म्हणून जाहीर करावे; तो कुष्ठरोग आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","पण पांढरा चट्टा त्वचेवर पांगून परसला नाही आणि तो हळूहळू कमी होत आहे, असे दिसून आले, तर याजकाने त्याला शुद्ध जाहीर करावे; तो जळालेल्या जागेत केवळ व्रण आहे आणि त्याला कुष्ठरोग नाही. ");
INSERT INTO marc_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","एखाद्या पुरुषाच्या किंवा स्त्रीच्या डोक्यावर अथवा हनुवटीवर चट्टा असेल ");
INSERT INTO marc_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","तर याजकाने त्याची तपासणी करावी. चट्टा त्वचेखाली खोलवर आहे असे वाटत असेल आणि चट्ट्यावर पिवळे केस सापडले असतील, तर याजकाने त्यास अशुद्ध असे जाहीर करावे; हा डोक्याचा अथवा हनुवटीचा कुष्ठरोग आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","पण तो चट्टा त्वचेपेक्षा खोल गेलेला नाही आणि त्यामध्ये काळे केस नाहीत, असे याजकाच्या तपासणीत दिसून आले तर याजकाने त्या व्यक्तीला सात दिवस वेगळे ठेवावे. ");
INSERT INTO marc_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातव्या दिवशी याजकाने तपासणी करावी आणि चट्टा जर पसरला नसेल आणि संसर्ग त्वचेमध्ये खोलवर गेला नसेल किंवा पिवळसर केस दिसून येत नसतील, ");
INSERT INTO marc_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","तर व्रणाभोवतीचे केस काढून टाकावे; व्रणावरचे केस मात्र काढू नयेत. मग याजकाने त्या व्यक्तीला आणखी सात दिवस वेगळे ठेवावे. ");
INSERT INTO marc_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","मग याजकाने सातव्या दिवशी तपासणी करावी, आणि व्रण त्वचेवर पसरला नसेल आणि संसर्ग त्वचेखाली खोलवर गेला नसेल, तर याजकाने त्या व्यक्तीला शुद्ध म्हणून जाहीर करावे आणि ती व्यक्ती कपडे धुतल्यानंतर शुद्ध व्हावी. ");
INSERT INTO marc_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","पण तो शुद्ध जाहीर केल्यानंतर तो चट्टा पसरू लागला, ");
INSERT INTO marc_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","तर याजकाने तपासणी करावी आणि चट्ट्याभोवतालचे केस पिवळे होतात की नाही याची वाट न पाहता, ती व्यक्ती अशुद्ध असे जाहीर करावे. ");
INSERT INTO marc_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","पण चट्टा पसरण्याची क्रिया थांबली असून तिच्यावर काळे केस सापडले, तर ती व्यक्ती बरी झाली असून शुद्ध आहे आणि याजकाने त्याला शुद्ध असे जाहीर करावे. ");
INSERT INTO marc_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","एखाद्या पुरुषाच्या किंवा स्त्रीच्या त्वचेवर पांढरे चट्टे असतील, ");
INSERT INTO marc_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","तर याजक तपासणी करेल आणि त्वचेवरील चट्ट्याचा रंग पांढरट असेल, तर इसब हा चर्मरोग झाला आहे, असे जाहीर करेल; ती व्यक्ती शुद्ध आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","कोणा माणसाच्या डोक्यावरील केस गळून टक्कल झाले असेल तर तो शुद्ध आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","जर त्याच्या मस्तकाच्या पुढच्या भागावरील केस गळून पडले असतील, तर ते केवळ साधे टक्कल आहे, तो शुद्ध होय. ");
INSERT INTO marc_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","तरी टक्कलावर तांबूस पांढरा डाग असेल तर तो त्या टक्कल पडलेल्या डोक्यावर किंवा कपाळावर कुष्ठरोग असण्याचा संभव आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","याबाबतीत याजक त्याची तपासणी करेल आणि डोक्याच्या टक्कल पडलेल्या भागावर अंगावरील त्वचेवर कुष्ठरोगासारखा दिसणारा तांबूस पांढरा चट्टा असेल, ");
INSERT INTO marc_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","तर त्या व्यक्तीच्या डोक्यावर पडलेला चट्टा कुष्ठरोगाचा आहे; ती व्यक्ती अशुद्ध आहे; याजकाने त्यास अशुद्ध असे जाहीर करावे. ");
INSERT INTO marc_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","असा कुष्ठरोग झालेल्या व्यक्तीने फाटलेले कपडे घालावेत, त्यांच्या केसात फणी न फिरविता ते तसेच वाढू द्यावेत; त्यांनी तोंडाखालील भाग झाकून घ्यावा आणि अशुद्ध! अशुद्ध! असे ओरडावे. ");
INSERT INTO marc_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जोपर्यंत कुष्ठरोग टिकून आहे, तोपर्यंत तो मनुष्य अशुद्ध असून त्याने छावणीबाहेर एकटे राहावे. ");
INSERT INTO marc_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","एखाद्या लोकरीच्या वा तागमिश्रित सुताच्या वस्त्राला किंवा कापडाच्या ताग्याला रोगाचा संसर्ग झाला आहे, ");
INSERT INTO marc_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","सुताच्या, लोकरीच्या ताण्याने विणलेले वस्त्र वा तागमिश्रित चामड्याला किंवा चामड्याच्या वस्तूला कुष्ठरोग झाला आहे, असा संशय आला ");
INSERT INTO marc_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","आणि जर ते चामड्याच्या, विणलेल्या वस्त्रावर, अथवा चामड्याच्या वस्तूवर हिरवट किंवा तांबूस चट्टा असला, तर तो कुष्ठरोगच आहे, म्हणून तपासणीसाठी ती वस्तू याजकाकडे अवश्य घेऊन जावी. ");
INSERT INTO marc_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","51","याजक ती वस्तू सात दिवसापर्यंत वेगळी ठेवील व सातव्या दिवशी त्या चट्ट्याची पुन्हा तपासणी करेल. तो चट्टा पसरला असेल, तर त्या विणलेल्या किंवा चामड्याच्या वस्त्राला वा वस्तूला संसर्गजन्य कुष्ठरोग झाला आहे असे समजावे; ती वस्तू अशुद्ध होय. ");
INSERT INTO marc_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","तेव्हा याजकाने ती वस्त्रे, ते कापड किंवा ती विणलेली लोकरीची वा चामड्याची वस्तू संसर्गजन्य आहे असे म्हणून अग्नीत जाळून टाकावी. ");
INSERT INTO marc_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","54","पण सातव्या दिवशी ते विणलेले वस्त्र किंवा चामड्याची वस्तू तपासली असता तो चट्टा पसरला नाही, असे याजकाला दिसून आले, तर त्याने कुष्ठरोगाची शंका असलेली वस्तू धुऊन टाकण्याचा आदेश द्यावा व नंतर आणखी सात दिवस ती वेगळी ठेवावी. ");
INSERT INTO marc_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","मग ती वस्तू धुतल्यावर याजकाने तपासावी आणि त्या चट्ट्याचा रंग बदलला नसून तो पसरला नाही. तरी तो अशुद्ध आहे असे समजावे; ती वस्तू जाळून टाकावी कारण तिला आतून, बाहेरून, सगळीकडून कुष्ठरोगाचा संसर्ग पोहोचला आहे असे समजावे. ");
INSERT INTO marc_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","पण धुतल्यानंतर चट्ट्याचा रंग फिकट झाला आहे, असे याजकाला दिसून आले, तर त्याने चट्टा असलेल्या विणलेल्या कापडाच्या वा चामड्याच्या वस्तूचा तेवढाच भाग कापून टाकावा. ");
INSERT INTO marc_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","इतके करूनही जर तो चट्टा या विणलेल्या वस्त्रावर किंवा चामड्याच्या वस्तूवर पुन्हा फुलून निघाला, तर याजकाने ती वस्तू अवश्य जाळून टाकावी, कारण तिला कुष्ठरोग आहे. ");
INSERT INTO marc_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","पण ती विणलेल्या कापडाची किंवा चामड्याची वस्तू धुतल्यानंतर तिच्यावरील चट्टा नाहीसा झाला, तर ती वस्तू पुन्हा एकदा धुवावी, म्हणजे ती शुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","लोकरीच्या व तागमिश्रित सुताच्या विणलेल्या वस्त्राला किंवा कापडाच्या ताग्याला, चामड्याला किंवा चामड्याच्या वस्तूला कुष्ठरोगाचा चट्टा दिसून आला तर ती शुद्ध किंवा अशुद्ध ठरविण्याचे हे नियम आहे. ");
INSERT INTO marc_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","कोणत्याही रोगग्रस्त व्यक्तीला त्यांच्या शुद्धीकरणाच्या विधीसमयी, जेव्हा त्यांना याजकाकडे आणले जाते तेव्हा हे नियम आहेत: ");
INSERT INTO marc_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","याजकाने छावणीबाहेर जाऊन बरे झालेल्या कुष्ठरोग्यांस तपासून पाहावे. जर ते कुष्ठरोगी बरे झाले आहेत असे दिसून आले, ");
INSERT INTO marc_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","याजक आज्ञा करतील की दोन जिवंत शुद्ध पक्षी आणि काही गंधसरूचे लाकूड, किरमिजी रंगाची दोरी आणि एजोब त्या व्यक्तीच्या शुद्धीकरणासाठी आणाव्यात. ");
INSERT INTO marc_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","मग याजकाने आज्ञा करावी की, वाहत्या पाण्यावर धरलेल्या मातीच्या पात्रात त्यापैकी एक पक्षी मारावा; ");
INSERT INTO marc_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","गंधसरूचे लाकूड, किरमिजी रंगाची दोरी व एजोब घेऊन दुसर्‍या जिवंत पक्ष्यासह वाहत्या पाण्यावर मारलेल्या पक्ष्याच्या रक्तात या सर्व वस्तू बुडवाव्यात. ");
INSERT INTO marc_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","मग याजकाने ते रक्त कुष्ठरोगातून मुक्त झालेल्या व्यक्तीवर सात वेळा शिंपडावे व तो शुद्ध झाला आहे, असे जाहीर करून त्या जिवंत पक्ष्याला उघड्या शेतात सोडून द्यावे. ");
INSERT INTO marc_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","मग शुद्ध करण्यात येणार्‍या मनुष्याने आपले कपडे धुवावेत, आपले मुंडण करावे व स्नान करावे; म्हणजे तो विधिनियमानुसार शुद्ध होईल. त्यानंतर त्याने छावणीत राहण्यासाठी परत यावे. तरी सात दिवसापर्यंत त्याने आपल्या तंबूबाहेरच राहावे. ");
INSERT INTO marc_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातव्या दिवशी त्याने आपले डोके, दाढी, भुवया व अंगावरील एकंदर सर्व केस मुंडवावे, आपले कपडे धुवावे व पाण्याने स्नान करावे. मग तो शुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","आठव्या दिवशी त्यांनी दोन निर्दोष कोकरे, एक वर्षांची निर्दोष मेंढी, अन्नार्पणासाठी तेलात मळलेला एक एफाचा एकतृतीयांश भाग सपीठ आणि एक लोगभर तेल घेऊन यावे. ");
INSERT INTO marc_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","मग शुद्ध जाहीर करणार्‍या याजकाने शुद्ध होणार्‍या मनुष्यास सभामंडपाच्या दाराशी याहवेहसमोर उभे करावे. ");
INSERT INTO marc_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","नंतर याजकाने एक कोकरू व एकतृतीयांश लीटर जैतुनाचे तेल दोषार्पण म्हणून वेदीपुढे ओवाळणीचे अर्पण म्हणून याहवेहसमोर ओवाळावे. ");
INSERT INTO marc_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","पवित्रस्थानात ज्या ठिकाणी पापार्पणाच्या व होमार्पणाच्या बलींचा वध करतात, त्या ठिकाणी याजकाने कोकराला ठार मारावे. पापार्पणातील बलीप्रमाणेच या दोषार्पणातील बली याजकाच्या हक्काचा आहे. हे परमपवित्र होय. ");
INSERT INTO marc_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","मग याजकाने या दोषबलीचे काही रक्त घ्यावे आणि शुद्ध होणार्‍या माणसाच्या उजव्या कानाच्या पाळीला, उजव्या हाताच्या व उजव्या पायाच्या अंगठ्याला लावावे. ");
INSERT INTO marc_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","मग याजकाने तेलाचा काही भाग घ्यावा आणि ते आपल्या डाव्या हाताच्या तळहातावर ओतावे, ");
INSERT INTO marc_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","व याजकाने त्यात आपल्या उजव्या हाताची बोटे बुडवून ते याहवेहपुढे सात वेळा शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","यानंतर तळहातावर शिल्लक राहिलेले तेल याजकाने शुद्ध होणार्‍या माणसाच्या उजव्या कानाच्या पाळीला, उजव्या पायाच्या व उजव्या हाताच्या अंगठ्यावरील दोषबलीच्या रक्तावर लावावे. ");
INSERT INTO marc_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","याजकाच्या तळहातावर शिल्लक राहिलेले सर्व तेल शुद्ध ठरविण्याच्या माणसाच्या मस्तकास लावावे. अशाप्रकारे याजकाने त्या माणसासाठी याहवेहपुढे प्रायश्चित्त करावे. ");
INSERT INTO marc_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","नंतर अशुद्धतेपासून शुद्ध झालेल्या माणसासाठी याजकाने पापबली अर्पावा व त्याच्यासाठी प्रायश्चित्ताचा विधी करावा; आणि यानंतर याजकाने होमबलीचा वध करावा, ");
INSERT INTO marc_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","मग याजकाने अन्नार्पणासह, होमबली वेदीवर अर्पावा व त्या माणसासाठी प्रायश्चित्त करावे, म्हणजे तो मनुष्य शुद्ध ठरेल. ");
INSERT INTO marc_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","जर तो गरीब असेल आणि इतके आणण्याची त्याची ऐपत नसेल तर त्याने आपल्या प्रायश्चित्तासाठी ओवाळणीचे एक कोकरू दोषार्पण म्हणून आणावे. अन्नार्पणासाठी जैतुनाच्या तेलात मळलेल्या सपिठाच्या एक एफाचा दहावा भाग आणावा, ");
INSERT INTO marc_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","आणि ऐपतीप्रमाणे त्याने पारव्याची दोन पिल्ले किंवा दोन होले आणावे; त्यातील एक पापबली व दुसरा होमबली म्हणून अर्पण करावा. ");
INSERT INTO marc_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“प्रायश्चित्तविधीसाठी त्याने आपल्या शुद्धीकरणासाठी आठव्या दिवशी ते पक्षी याहवेहसमोर सभामंडपाच्या दाराशी याजकाकडे आणावेत. ");
INSERT INTO marc_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","मग याजकाने दोषार्पणाचे कोकरू व अर्धा लीटर तेल घेऊन वेदीपुढे ओवाळणीचे अर्पण म्हणून याहवेहसाठी ओवाळावे. ");
INSERT INTO marc_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","त्यानंतर दोषार्पणाच्या कोकराचा वध करावा आणि याजकाने त्याचे काही रक्त घेऊन शुद्ध होणार्‍या माणसाच्या उजव्या कानाच्या पाळीला आणि उजव्या हाताच्या व उजव्या पायाच्या अंगठ्याला लावावे. ");
INSERT INTO marc_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","मग याजकाने आपल्या डाव्या तळहातावर तेलातील काही तेल ओतावे, ");
INSERT INTO marc_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","आणि याजकाने आपल्या उजव्या हाताच्या बोटांनी सात वेळा ते याहवेहपुढे शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","मग याजकाने आपल्या तळहातावरील काही तेल घेऊन ते शुद्ध होणार्‍या माणसाच्या उजव्या कानाच्या पाळीला आणि उजव्या हाताच्या व उजव्या पायाच्या अंगठ्याला दोषबलीचे रक्त लावले त्या जागी लावावे. ");
INSERT INTO marc_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","याजकाने त्याच्या तळहातावर उरलेले तेल त्या शुद्ध होणार्‍या माणसाच्या प्रायश्चित्तासाठी याहवेहपुढे त्याच्या डोक्यास लावावे. ");
INSERT INTO marc_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","मग त्या व्यक्तीला परवडेल त्याप्रमाणे त्याने पारव्याच्या किंवा होल्याच्या पिल्लाचे अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","एक पक्ष्याचे पापार्पण म्हणून व दुसर्‍या पक्ष्याचे अन्नार्पणासह होमार्पण म्हणून अर्पणे करावी. अशाप्रकारे याजकाने शुद्ध होणार्‍या माणसासाठी याहवेहपुढे प्रायश्चित्त करावे.” ");
INSERT INTO marc_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","हे नियम सर्वसाधारणपणे शुद्धीकरणासाठी लागणारे अर्पण आणण्याची ऐपत नसलेल्या कुष्ठरोग्यांसाठी आहेत. ");
INSERT INTO marc_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","याहवेह मोशे व अहरोन यांना म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जेव्हा तुम्ही कनान देशात प्रवेश कराल, जो मी तुम्हाला वतन म्हणून दिला आहे, आणि मी तेथील एखाद्या घराला कुष्ठरोगाचा चट्टा देईन, ");
INSERT INTO marc_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","तेव्हा त्या घराच्या मालकाने याजकाकडे येऊन त्याला सांगावे, ‘आमच्या घरात चट्ट्यासारखे काहीतरी दिसत आहे.’ ");
INSERT INTO marc_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","याजकाने घरामध्ये जाऊन चिन्हाचे परीक्षण करण्यापूर्वी, त्याने घर रिकामे करण्याचा आदेश दिला पाहिजे, अन्यथा त्या घरातील सर्व वस्तू अशुद्ध होऊ शकतील. त्यानंतर याजकाने त्या घरात प्रवेश करून त्याची तपासणी करावी. ");
INSERT INTO marc_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","त्याने घराच्या भिंतींची तपासणी करून त्यावरील चट्टा भिंतींपेक्षा खोलवर हिरवट किंवा लालसर आहे, असे याजकाला आढळले, ");
INSERT INTO marc_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","तर याजकाने घराबाहेर दाराजवळ यावे आणि ते घर सात दिवस बंद ठेवावे. ");
INSERT INTO marc_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","मग सातव्या दिवशी याजकाने पुन्हा जाऊन ते घर तपासावे आणि तो चट्टा भिंतीवर पसरला असेल, ");
INSERT INTO marc_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","तर याजकाने चट्टा असलेला भाग काढून तो नगराबाहेर अशुद्ध ठिकाणी फेकून देण्याची आज्ञा द्यावी. ");
INSERT INTO marc_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","नंतर भिंतीचा आतील भाग पूर्णपणे खरवडून त्याची दगड व माती नगराबाहेर अशुद्ध ठिकाणी फेकून देण्याची आज्ञा द्यावी. ");
INSERT INTO marc_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","मग त्या जागी बसविण्यासाठी दुसरे दगड आणावेत व नव्या चुन्याचा गिलावा करावा.” ");
INSERT INTO marc_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","दगड काढल्यावर आणि घर खरवडून नवीन गिलावा केल्यावर तो चट्टा पुन्हा आला, ");
INSERT INTO marc_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","तर याजकाने आत येऊन तो तपासावा, आणि जर चट्टा पसरला आहे असे त्याला दिसून आले, तर तो न निघणारा कुष्ठरोग असून ते घर अशुद्ध झाले आहे. ");
INSERT INTO marc_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","मग ते घर पाडून टाकण्यात यावे व त्या घराचे दगड, चुना, लाकूड नगराबाहेर नेऊन अशुद्ध ठिकाणी फेकून द्यावे. ");
INSERT INTO marc_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","असे घर बंद असता जो कोणी त्या घरात शिरेल, तो संध्याकाळपर्यंत अशुद्ध राहील, ");
INSERT INTO marc_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","जर कोणी अशा घरात झोपेल किंवा जेवेल, तर त्याने आपली वस्त्रे धुवावी. ");
INSERT INTO marc_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","याजकाने आत जाऊन घर पुन्हा तपासावे आणि गिलाव्यावर चट्टे पुनः दिसले नाहीत, तर ते घर शुद्ध झाले असून तेथील कुष्ठरोग नाहीसा झाला आहे असे त्याने जाहीर करावे. ");
INSERT INTO marc_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","मग त्याने दोन पक्षी, गंधसरूचे लाकूड, किरमिजी रंगाची दोरी व एजोब घेऊन शुद्धीकरणाचा विधी करावा. ");
INSERT INTO marc_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","त्याने वाहत्या पाण्याच्या वर मातीचे पात्र धरून त्याच्यात एक पक्षी मारावे, ");
INSERT INTO marc_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","52","व वाहत्या पाण्यावर धरलेल्या मातीच्या पात्रात मारलेल्या पक्ष्याच्या रक्तात, तसेच वाहत्या पाण्यात, गंधसरूचे लाकूड, किरमिजी रंगाची दोरी, एजोब त्याचप्रमाणे दुसरा जिवंत पक्षी बुडवावा, आणि ते रक्त सात वेळा त्या घरावर शिंपडावे. अशाप्रकारे याजक ते घर शुद्ध करेल. ");
INSERT INTO marc_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","मग त्याने तो जिवंत पक्षी शहराबाहेर मोकळ्या जागी सोडून द्यावा. अशाप्रकारे त्याने घराकरिता प्रायश्चित्त करावे म्हणजे ते शुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","सर्व प्रकाराचा कुष्ठरोग, चाई, ");
INSERT INTO marc_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","वस्त्रावरील आणि घरावरील कुष्ठरोग, ");
INSERT INTO marc_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","सूज, खवंद, पांढरा चट्टा या सर्वांसंबंधीचा हा नियम आहे. ");
INSERT INTO marc_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","अशाप्रकारे हा खरोखरच शुद्ध किंवा अशुद्ध आहे हे तुम्हाला समजेल. कुष्ठरोग आणि बुरशी यासाठी हे नियम दिलेले आहेत. ");
INSERT INTO marc_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","याहवेह मोशे व अहरोन यांना म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","इस्राएली लोकांबरोबर बोल आणि त्यांना सांग: जेव्हा कोणाही माणसाच्या शरीरातून स्राव होत असेल, तर अशा प्रकारचा स्त्राव हा अशुद्ध आहे. ");
INSERT INTO marc_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","त्याचे शरीर सतत स्राव बाहेर टाकीत असले किंवा अडवून ठेवीत असले, तरी तो मनुष्य अशुद्ध आहे. या स्रावामुळे तो मनुष्य अशुद्ध होतो: ");
INSERT INTO marc_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","ज्या बिछान्यावर तो झोपेल आणि ज्या बैठकीवर तो बसेल ती अशुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","जे कोणी अशा माणसाच्या अंथरुणाला स्पर्श करतील त्यांनी त्यांची वस्त्रे धुवावीत आणि स्नान करावे आणि संध्याकाळपर्यंत ते अशुद्ध राहतील. ");
INSERT INTO marc_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","स्रावामुळे अशुद्ध झालेला मनुष्य ज्या बैठकीवर बसला असेल त्या बैठकीवर जो कोणी बसेल, तो संध्याकाळपर्यंत अशुद्ध राहील. त्याने आपली वस्त्रे धुवावीत व स्नान करावे. ");
INSERT INTO marc_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","जो कोणी अशा मनुष्याला स्पर्श करेल त्याने स्वतःचे शरीर व वस्त्र पाण्याने स्वच्छ धुवावे, तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ज्या कोणा शुद्ध व्यक्तीवर असा मनुष्य थुंकेल, त्याने स्वतःचे शरीर व वस्त्र पाण्याने स्वच्छ धुवावे, तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ज्या वाहनांचा तो स्त्राव होणारा मनुष्य उपयोग करेल ते वाहन अशुद्ध होय, ");
INSERT INTO marc_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","आणि जो कोणी अशा माणसाच्या अंगाखालील वस्तूला स्पर्श करेल किंवा ती उचलेल त्याने स्वतःचे शरीर व वस्त्र पाण्याने स्वच्छ धुवावे, तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","हात धुतल्याशिवाय स्त्राव होणारा मनुष्य जर कोणाला स्पर्श करेल, तर स्पर्श झालेल्या त्या मनुष्याने अवश्य आपली वस्त्रे धुवावीत आणि पाण्याने स्नान करावे, तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“असा मनुष्य ज्या मातीच्या पात्राला स्पर्श करेल ते अवश्य फोडून टाकावे आणि कोणत्याही लाकडाच्या भांड्याला त्याचा स्पर्श झाल्यास ते पाण्याने धुऊन घ्यावे. ");
INSERT INTO marc_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“स्राव थांबल्यावर त्याने आपली वस्त्रे धुऊन, सात दिवसांच्या शुद्ध होण्याच्या विधीची सुरुवात करावी. त्याने आपली वस्त्रे धुवावी आणि वाहत्या पाण्यात स्नान करून शुद्ध व्हावे. ");
INSERT INTO marc_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठव्या दिवशी त्याने दोन होले किंवा पारव्याची दोन पिल्ले घ्यावीत व सभामंडपाच्या दाराशी याहवेहसमोर येऊन याजकाला ती द्यावीत. ");
INSERT INTO marc_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","याजकाने त्यातील एका पक्ष्याचे पापार्पण व दुसर्‍याचे होमार्पण करावे. अशाप्रकारे याजकाने त्याच्या स्त्रावासाठी याहवेहसमोर प्रायश्चित करावे. ");
INSERT INTO marc_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“जर एखाद्या मनुष्याला वीर्यपात झाला, तर त्याने संपूर्ण शरीर पाण्याने धुवावे, तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ज्या वस्त्रांवर वा चामड्यावर वीर्य लागले असेल, ते अवश्य धुऊन टाकावे व सायंकाळपर्यंत ते अशुद्ध समजावे. ");
INSERT INTO marc_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","जर एखाद्या पुरुषाने स्त्रीशी शारीरिक संबंध ठेवले आणि या प्रक्रियेत त्याचे वीर्यस्खलन झाले, तर दोघांनीही पाण्याने स्नान केले पाहिजे. ते संध्याकाळपर्यंत अशुद्ध राहतील. ");
INSERT INTO marc_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“स्त्री ॠतुमती होते, तेव्हा तिने विधिनियमानुसार सात दिवस अशुद्ध राहावे. त्या काळात जो कोणी तिला स्पर्श करेल, तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“याकाळात ती ज्या अंथरुणावर झोपेल किंवा बैठकीवर बसेल, ती सर्व अशुद्ध होतील ");
INSERT INTO marc_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","जो कोणी तिच्या अंथरुणाला स्पर्श करेल त्या व्यक्तीने आपली वस्त्रे धुवावीत, स्नान करावे व तो सायंकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","जो कोणी तिच्या बैठकीला स्पर्श करेल त्या व्यक्तीने आपली वस्त्रे धुवावीत, स्नान करावे व तो सायंकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","जो कोणी तिच्या अंथरुणाला किंवा बैठकीला स्पर्श करेल तो व्यक्ती सायंकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“याकाळात तिच्याशी शारीरिक संबंध ठेवणारा पुरुष सात दिवस अशुद्ध राहील आणि ज्या बिछान्यावर तो झोपेल तो अशुद्ध समजावा. ");
INSERT INTO marc_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“महिन्यात अनियमित वेळा किंवा मासिक पाळीच्या दिवसानंतरही जर ॠतुस्राव चालू राहिला, तर त्यामुळे मासिक पाळीच्या अशुद्धतेप्रमाणे ती या अशुद्ध स्त्रावात अशुद्धच राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","म्हणजे, नियमित मासिक पाळी चालू असलेल्या ॠतुस्रावाच्या काळात ती ज्या अंथरुणावर झोपेल ते अशुद्ध होईल; आणि ज्या बैठकीवर बसेल ती ही अशुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","जी व्यक्ती तिच्या अंथरुणाला वा बैठकीला स्पर्श करेल ती अशुद्ध होईल. त्या व्यक्तीने आपली वस्त्रे धुवावीत व स्नान करावे आणि तो सायंकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“जेव्हा ती स्त्री तिच्या स्त्रावातून शुद्ध होईल, तेव्हा तिने शुद्ध होण्यासाठी सात दिवस मोजावे, त्यानंतर ती शुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","आठव्या दिवशी तिने दोन होले किंवा पारव्याची दोन पिल्ले सभामंडपाच्या दाराशी याजकाकडे आणावी; ");
INSERT INTO marc_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","याजकाने एकाचे पापार्पण व दुसर्‍याचे होमार्पण म्हणून याहवेहपुढे अर्पून तिच्या स्त्रावाच्या अशुद्धतेकरिता प्रायश्चित्त करावे. ");
INSERT INTO marc_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“अशाप्रकारे इस्राएली लोकांना तू अशुद्धतेपासून दूर ठेवावे. आपल्यावर मरणाचा प्रसंग ओढवू नये म्हणून त्यांनी आपल्या अशुद्धतेमुळे त्यांच्यामध्ये ज्या निवासमंडपात मी राहतो तो अशुद्ध करू नये.” ");
INSERT INTO marc_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","स्राव किंवा वीर्यपात होऊन जो पुरुष अशुद्ध होतो, त्याच्यासाठी हे नियम आहेत. ");
INSERT INTO marc_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","जी स्त्री ॠतुमती होते आणि जो कोणी अशा ॠतुमती असलेल्या स्त्रीशी शारीरिक संबंध ठेवून विधिनियमानुसार अशुद्ध होतो, यासंबंधीचे हे नियम आहेत. ");
INSERT INTO marc_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","अहरोनाचे दोन पुत्र याहवेहच्या समक्षतेत गेल्यामुळे मरण पावल्यानंतर याहवेह मोशेबरोबर बोलले. ");
INSERT INTO marc_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","याहवेह मोशेला म्हणाले, “तुझा भाऊ अहरोन याला सांग की कोश व प्रायश्चिताचे झाकण असलेल्या पडद्यामागील परमपवित्रस्थानात त्याची इच्छा होईल तेव्हा येऊ नये, नाही तर त्याला मरण येईल. कारण दयासनावरील ढगात मी प्रकट होत राहीन. ");
INSERT INTO marc_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“अहरोन पवित्रस्थानात अशाप्रकारे प्रवेश करेल: त्याने पापार्पणासाठी एक गोर्‍हा व होमार्पणासाठी एक मेंढा अवश्य आणावा. ");
INSERT INTO marc_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","त्याने तागाचा पवित्र झगा घातला पाहिजे आणि त्याच्या शरीराभोवती तागाचे अंतर्वस्त्र घालावे; तागाच्या वस्त्राने आपली कंबर कसावी आणि तागाचा फेटा बांधावा. ही पवित्र वस्त्रे आहेत; म्हणून ती अंगावर घालण्यापूर्वी त्याने पाण्याने स्नान करावे. ");
INSERT INTO marc_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","मग इस्राएली समुदायाकडून पापार्पणासाठी दोन बोकडे व होमार्पणासाठी एक मेंढा घ्यावा. ");
INSERT INTO marc_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“अहरोनाने स्वतःच्या पापार्पणाचा गोर्‍हा परमेश्वराला पहिल्याने अर्पण करून स्वतःसाठी व स्वतःच्या कुटुंबासाठी प्रायश्चित्त करावे. ");
INSERT INTO marc_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","मग त्याने सभामंडपाच्या दाराशी याहवेहपुढे ती दोन बोकडे आणावी. ");
INSERT INTO marc_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","दोन बोकडांवर अहरोनाने चिठ्ठ्या टाकाव्या—याहवेहसाठी एक बोकड आणि पाप वाहून नेण्यासाठी दुसरा बोकड. ");
INSERT INTO marc_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","नंतर याहवेहसाठी चिठ्ठी पडलेल्या बोकडाला अहरोनाने घेऊन यावे आणि पापार्पणाचा बळी म्हणून त्याचा यज्ञ करावा. ");
INSERT INTO marc_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","परंतु चिठ्ठी टाकून जो दुसरा बोकड आला तो पाप वाहून नेण्यासाठीचा बोकड जिवंत ठेवून याहवेहसमोर आणावा आणि त्याच्यावर प्रायश्चित्ताचा विधी करून, पाप वाहून नेण्यासाठी तो रानात सोडून द्यावा. ");
INSERT INTO marc_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“अहरोनाने स्वतःसाठी व आपल्या कुटुंबीयांसाठी पापार्पणाच्या गोर्‍ह्याचा वध करून प्रायश्चित्त करावे. ");
INSERT INTO marc_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","याहवेहच्या वेदीसमोरील धुपाटण्यात जळते निखारे भरून घ्यावेत व कुटून बारीक केलेला व दोन मुठीत भरेल एवढा सुगंधी धूप अंतरपटाच्या आत आणावा. ");
INSERT INTO marc_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","तो धूप त्याने याहवेहसमोर निखार्‍यांवर असा टाकावा की, धूपाच्या धुराने दहा आज्ञांच्या दगडी पाट्या ठेवलेला कोश व त्यावरील दयासन व्यापून जाईल; म्हणजे तो मरणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","मग त्याने गोर्‍ह्याचे काही रक्त घेऊन ते आपल्या बोटांनी दयासनाच्या पूर्वेस शिंपडावे आणि काही रक्त दयासनासमोर सात वेळा शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“नंतर त्याने बाहेर जाऊन लोकांसाठी आणलेल्या पापार्पणाच्या बोकडाचा वध करावा; बोकडाचे रक्त अंतरपटाच्या आत घेऊन जावे आणि गोर्‍ह्याचे रक्त त्याने ज्या ठिकाणी शिंपडले, त्याच ठिकाणी म्हणजे दयासनावर व दयासनासमोर ते शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","कारण इस्राएली लोकांची अशुद्धता आणि बंडखोरी, त्यांची पापे कोणतीही असोत, अशाप्रकारे त्याने परमपवित्रस्थानासाठी प्रायश्चित्त करावे. त्याचप्रमाणे त्याने सभामंडपासाठीही असेच करावे, कारण तो त्यांच्यामध्ये उभारला असून त्यांच्या अशुद्धतेने वेढला गेला आहे. ");
INSERT INTO marc_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","अहरोन प्रायश्चित्त करण्यासाठी परमपवित्रस्थानात जाईल, तेव्हापासून तो परत येईपर्यंत, तो स्वतःसाठी, स्वतःच्या कुटुंबीयांसाठी व सर्व इस्राएली लोकांसाठी प्रायश्चित्त करेपर्यंत कोणीही सभामंडपात जाऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“मग त्याने तिथून निघून याहवेहसमोरील वेदीजवळ जाऊन तिच्यासाठी प्रायश्चित्त करावे. त्याने गोर्‍ह्याचे व बोकडाचे रक्त घेऊन ते वेदीच्या चारही बाजूच्या शिंगांना लावावे. ");
INSERT INTO marc_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","काही रक्त घेऊन वेदीवर आपल्या बोटांनी सात वेळा शिंपडावे. अशाप्रकारे इस्राएलांच्या अशुद्धतेपासून वेदी शुद्ध व पवित्र करावी. ");
INSERT INTO marc_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“परमपवित्रस्थान, सभामंडप व वेदी यांच्यासाठी प्रायश्चित्तविधी पूर्ण केल्यानंतर अहरोनाने जिवंत बोकड आणावा. ");
INSERT INTO marc_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","मग अहरोन आपले दोन्ही हात बोकडाच्या डोक्यावर ठेवून इस्राएली लोकांचे सर्व अन्याय, बंडखोरी—त्यांची सर्व पापे—त्या बोकडाच्या मस्तकावर ठेवावी व नेमलेल्या माणसाद्वारे त्या बोकडाला रानात पाठवून द्यावे. ");
INSERT INTO marc_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","जिथे कोणी राहत नाही अशा प्रदेशात तो बोकड लोकांच्या पापाचा भार वाहून नेईल, नंतर त्या मनुष्याने त्या बोकडाला रानात सोडून द्यावे. ");
INSERT INTO marc_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“मग अहरोनाने सभामंडपात पुन्हा यावे व परमपवित्रस्थानात प्रवेश करण्यापूर्वी घातलेली तागमिश्रित वस्त्रे काढावीत आणि तिथेच ठेवावीत. ");
INSERT INTO marc_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","नंतर त्याने पवित्रस्थानी पाण्याने स्नान करावे, आपली नियमित वस्त्रे घालावी. मग त्याने बाहेर यावे व स्वतःसाठी व लोकांसाठी प्रायश्चित्ताचे होमार्पण करावे म्हणून स्वतःसाठी होमार्पण व लोकांसाठीही होमार्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","त्याने पापार्पणासाठी ठेवलेल्या चरबीचा वेदीवर होम करावा. ");
INSERT INTO marc_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“ज्या मनुष्याने पाप वाहून नेण्यासाठी निवडलेला बोकड अरण्यात सोडून दिला, त्याने आपली वस्त्रे धुवावी, पाण्याने स्नान करावे आणि त्यानंतर छावणीत परत यावे. ");
INSERT INTO marc_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","पापार्पणाच्या ज्या गोर्‍ह्याचे व बोकडाचे रक्त अहरोनाने प्रायश्चित्तासाठी पवित्रस्थानात नेले होते, त्यांचे मृतदेह, कातडी व आतडी छावणीबाहेर नेऊन अग्नीने जाळण्यात यावीत.” ");
INSERT INTO marc_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ज्या मनुष्याने ते जाळून टाकले, त्याने आपली वस्त्रे धुवावीत, स्नान करावे; त्यानंतर छावणीत परत यावे. ");
INSERT INTO marc_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","तुम्ही जो नियम सर्वकाळ पाळला पाहिजे तो हा: सातव्या महिन्याच्या दहाव्या दिवशी तुम्ही स्वतःला नाकारले पाहिजे आणि—तुमच्यामध्ये जन्मलेले स्वदेशी किंवा तुमच्यामध्ये राहणारे परदेशी—कोणतेही कार्य करू नये ");
INSERT INTO marc_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","कारण या दिवशी तुम्हाला शुद्ध करण्यासाठी तुमच्यासाठी प्रायश्चित्त केले जाईल, तुम्ही याहवेहसमोर तुमच्या सर्व पापांपासून शुद्ध व्हाल. ");
INSERT INTO marc_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","तुमच्यासाठी हा विसाव्याचा शब्बाथ होय आणि तुम्ही स्वतःला नाकारले पाहिजे; हा कायमचा नियम होय. ");
INSERT INTO marc_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","अभिषिक्त म्हणून आपल्या वडिलांच्या नंतर नियुक्त केलेल्या याजकाने प्रायश्चित्त करावे. त्याने पवित्र तागाची वस्त्रे घालावीत ");
INSERT INTO marc_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","त्याने परमपवित्रस्थान, सभामंडप, वेदी, याजकवर्ग व इस्राएली लोक यांच्यासाठी प्रायश्चित्त करावे. ");
INSERT INTO marc_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“तुझ्यासाठी हा नेहमीचा नियम असेल: इस्राएली लोकांच्या सर्व पापांसाठी वर्षातून एकदा प्रायश्चित्त करावे.” याहवेहने मोशेला दिलेल्या आज्ञेप्रमाणे हे करण्यात आले. ");
INSERT INTO marc_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“अहरोन, त्याचे पुत्र आणि सर्व इस्राएली लोकांसाठी याहवेहने ज्या आज्ञा दिल्या त्या या आहेत: ");
INSERT INTO marc_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","इस्राएलाच्या घराण्यातील कोणत्याही मनुष्याने बैल, कोकरू किंवा शेळी यांचा छावणीत किंवा छावणीबाहेर वध केला, ");
INSERT INTO marc_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","परंतु याहवेहच्या निवासमंडपासमोर आणि तो प्राणी सभामंडपाच्या दाराशी याहवेहला अर्पण करण्याकरिता आणला नाही, तर त्या मनुष्याला रक्तपाताचा दोष लागेल; त्याने रक्त सांडले आहे, म्हणून त्याला आपल्या लोकातून बहिष्कृत करावे. ");
INSERT INTO marc_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","या आज्ञेचा उद्देश असा आहे की, इस्राएली लोक जे उघड्या मैदानात यज्ञपशू मारीत होते, ते त्यांनी सभामंडपाच्या दाराशी याजकाकडे याहवेहपुढे आणावे आणि शांत्यर्पणाचे यज्ञ म्हणून याहवेहला अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","याजकाने सभामंडपाच्या दाराशी असलेल्या याहवेहच्या वेदीवर रक्त शिंपडून याहवेहला सुवास म्हणून त्यांच्या चरबीचा होम करावा. ");
INSERT INTO marc_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","यापुढे ज्यांच्याबरोबर ते स्वतःच व्यभिचार करतात, त्या बोकडाच्या मूर्तींना, त्यांचे कोणतेही अर्पण करू नये. हा नियम त्यांच्यासाठी आणि येणार्‍या पिढ्यांसाठी लागू आहे.” ");
INSERT INTO marc_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","तू त्यांना सांग: इस्राएली किंवा तुमच्यामध्ये राहणारा कोणताही विदेशी यांनी होमार्पण किंवा यज्ञार्पण केले, ");
INSERT INTO marc_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","आणि याहवेहसाठी सभामंडपाच्या दाराशी तो प्राणी अर्पण करण्यास आणला नाही, तर त्याला आपल्या लोकांमधून बहिष्कृत करावे. ");
INSERT INTO marc_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","इस्राएलांच्या घराण्यातील कोणीही किंवा त्यांच्यामध्ये राहणारा कोणताही विदेशी, जो रक्त खातो त्या माणसाविरुद्ध मी माझे मुख फिरवेन आणि मी त्यांना लोकांमधून बहिष्कृत करेन. ");
INSERT INTO marc_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","कारण शरीराचे जीवन रक्तात असते आणि तुमच्या प्रायश्चित्तासाठी मी तुम्हाला वेदीवर शिंपडण्यासाठी ते दिले आहे; रक्तात जीवन असल्यामुळे प्रायश्चित्त होते. ");
INSERT INTO marc_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","म्हणून मी इस्राएली लोकांना सांगितले आहे, “तुमच्यामधील कोणीही किंवा तुमच्यामध्ये राहणारा विदेशी यापैकी कोणीही रक्ताचे सेवन करू नये.” ");
INSERT INTO marc_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘इस्राएली किंवा तुमच्यामध्ये असलेला कोणीही विदेशी शिकारीला गेला असता, त्याने खाण्यास योग्य असलेला पशू किंवा पक्षी यांची शिकार केली, तर त्याचे रक्त जमिनीवरच ओतून मातीने झाकून टाकावे, ");
INSERT INTO marc_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","कारण रक्त हे प्रत्येक प्राण्याचे जीवन आहे. म्हणून इस्राएली लोकांना सांगितले आहे, “तुम्ही कोणत्याही प्राण्याचे रक्त खाऊ नका, कारण प्रत्येक प्राण्याचे जीवन हे त्याचे रक्त आहे; जो कोणी रक्ताचे सेवन करेल त्याला बहिष्कृत केलेच पाहिजे.” ");
INSERT INTO marc_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘जर कोणत्या व्यक्तीने, मग तो देशात जन्मलेला किंवा विदेशी असो, यापैकी जो कोणी मेलेल्या किंवा जंगली जनावराने फाडलेल्या मृत प्राण्याचे मांस खाईल, त्याने आपली वस्त्रे धुवावी व पाण्याने स्नान करावे आणि तो संध्याकाळपर्यंत विधिनियमानुसार अशुद्ध राहील आणि त्यानंतर तो शुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","पण जर त्याने आपली वस्त्रे धुतली नाहीत व स्नान केले नाही, तर तो दोषीच राहील.’ ” ");
INSERT INTO marc_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इस्राएली लोकांबरोबर बोल आणि त्यांना सांग: ‘मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तुम्ही ज्या इजिप्त देशात राहिलात त्यांच्यासारखे वागू नका आणि मी तुम्हाला जिथे नेत आहे, त्या कनान देशाचे लोक जे करतात ते करू नका. त्यांच्या रीतिरिवाजाचे पालन करू नका. ");
INSERT INTO marc_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","तुम्ही माझ्या नियमांचे पालन केलेच पाहिजे आणि काळजीपूर्वक माझ्या आज्ञांप्रमाणे वागले पाहिजे. मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","तुम्ही माझ्या आज्ञा आणि नियमांचे पालन करा, कारण जो व्यक्ती त्यांचे पालन करतो, तो त्यामुळे जिवंत राहील. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘तुमच्यापैकी कोणीही आपल्या जवळच्या नातलगाशी शारीरिक संबंध ठेऊ नये; मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘तुझ्या आईबरोबर शारीरिक संबंध ठेवून वडिलांचा अनादर करू नकोस. ती तुझी आई आहे; तिच्याशी संबंध ठेवू नकोस. ");
INSERT INTO marc_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘तुझ्या वडिलांच्या पत्नीशी शारीरिक संबंध ठेवू नकोस; जे तुझ्या वडिलांचा अपमान करेल. ");
INSERT INTO marc_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘तुझ्या बहिणीशी शारीरिक संबंध तू ठेवू नकोस, तुझ्या वडिलांची कन्या असो किंवा तुझ्या आईची कन्या, मग ती एकाच घरात जन्मली असेल किंवा इतरत्र. ");
INSERT INTO marc_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘तू तुझ्या पुत्राच्या कन्येशी किंवा तुझ्या कन्येच्या कन्येशी शारीरिक संबंध ठेवू नकोस; त्यामुळे तुझा अपमान होईल. ");
INSERT INTO marc_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘तुझ्या पित्याच्या पत्नीच्या कन्येशी शारीरिक संबंध ठेवू नकोस; ती तुझी बहीण आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘तू तुझ्या पित्याच्या बहिणीशी शारीरिक संबंध ठेवू नकोस; ती तुझ्या पित्याची जवळची नातेवाईक आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘तुझ्या मातेच्या बहिणीशी शारीरिक संबंध ठेवू नकोस, कारण ती तुझ्या आईची जवळची नातेवाईक आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘आपल्या पित्याच्या भावाचा त्याच्या पत्नीसोबत शारीरिक संबंध ठेवून त्याचा अपमान करू नका; ती तुझी चुलती आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘तू तुझ्या सूनेशी शारीरिक संबंध ठेवू नकोस. ती तुझ्या पुत्राची पत्नी होय; तिच्यासोबत शारीरिक संबंध ठेवू नकोस. ");
INSERT INTO marc_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘तुझ्या भावाच्या पत्नीशी शारीरिक संबंध ठेऊ नकोस; हा तुझ्या भावाचा अपमान आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘तू एखाद्या स्त्रीसोबत आणि तिच्या कन्येसोबत शारीरिक संबंध ठेऊ नकोस. तिच्या पुत्राच्या किंवा कन्येच्या कन्येशी तू शारीरिक संबंध ठेऊ नकोस, कारण ते तिचे जवळचे नातेवाईक आहेत; आणि असे करणे भयंकर पाप आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘तुझी पत्नी जिवंत असताना तिची वैरीण म्हणून तिच्या बहिणीशी विवाह करू नकोस आणि तिच्याशी शारीरिक संबंध ठेवू नका. ");
INSERT INTO marc_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘स्त्री ॠतुमती असताना तिच्या अशुद्धतेत तिच्यासोबत शारीरिक संबंध ठेवायला जाऊ नको. ");
INSERT INTO marc_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘तू आपल्या शेजार्‍याच्या पत्नीशी शारीरिक संबंध ठेऊ नकोस आणि स्वतःला भ्रष्ट करू नकोस. ");
INSERT INTO marc_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘तू आपल्या संतानांपैकी कोणालाही मोलख दैवतासाठी यज्ञबली म्हणून अर्पण करू नये, कारण असा यज्ञ केल्याने तुझ्या परमेश्वराच्या नावाचा अनादर होतो. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘स्त्रीप्रमाणे पुरुषाने पुरुषाशी शारीरिक संबंध ठेऊ नये. ते ओंगळ कृत्य आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘प्राण्याशी लैंगिक संबंध ठेवू नकोस आणि त्याद्वारे स्वतःला अशुद्ध करू नको. स्त्रीने प्राण्याशी लैंगिक संबंध ठेवण्यासाठी स्वतःला सादर करू नये; ती एक विकृती आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘अशा प्रकारच्या कोणत्याही अमंगळ गोष्टी करून तुम्ही स्वतःला अपवित्र करून घेऊ नये, कारण ज्या राष्ट्रात मी तुम्हाला पाठवित आहे, ती राष्ट्रे या गोष्टींनी भ्रष्ट झाली आहेत. ");
INSERT INTO marc_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","भूमीसुद्धा भ्रष्ट झाली होती; म्हणून तिच्या पापाबद्दल मी तिला शिक्षा केली आहे, भूमीने तेथील रहिवाशांना देशाबाहेर ओकारीसारखे फेकून दिले आहे. ");
INSERT INTO marc_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","म्हणून तुम्ही माझे नियम व विधी पाळा आणि वर उल्लेख केलेल्या कोणत्याही ओंगळ गोष्टी करू नका. हे नियम इस्राएली लोकांना व तुमच्यात राहत असलेल्या विदेशी लोकांनाही लागू आहेत, ");
INSERT INTO marc_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ज्या देशात मी तुम्हाला घेऊन जात आहे, त्या देशातील रहिवाशांनी अशा ओंगळ गोष्टी सतत केल्या म्हणून तो देश भ्रष्ट झाला. ");
INSERT INTO marc_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","जर तुम्ही ही भूमी भ्रष्ट कराल, तर ती तुम्हाला ओकून टाकेल, जसे तुमच्या पूर्वी असलेल्या राष्ट्रांना तिने ओकून टाकले होते. ");
INSERT INTO marc_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘या ओंगळ कृत्यांपैकी एकदेखील कृत्य जो करेल, त्याला या राष्ट्रातून बहिष्कृत केले जाईल. ");
INSERT INTO marc_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","म्हणून तुम्ही जात आहात, तेथील लोकांच्या ओंगळ कृत्यांचे अनुकरण करून तुम्ही स्वतःस भ्रष्ट करून घेऊ नये; मी याहवेह तुमचा परमेश्वर आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“सर्व इस्राएली लोकांस सांग: ‘तुम्ही पवित्र असावे, कारण मी, याहवेह तुमचा परमेश्वर, पवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘तुमच्यातील प्रत्येकाने आपल्या आईवडिलांचा आदर केला पाहिजे आणि माझा शब्बाथ पाळलाच पाहिजे. मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘मूर्तीकडे वळू नका आणि आपल्यासाठी ओतीव देव करू नका. मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘जेव्हा तुम्ही याहवेहला शांत्यर्पणे करता, तेव्हा ती अशा प्रकारे अर्पण करा की तुमच्यावतीने मान्य करण्यात येतील. ");
INSERT INTO marc_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","तुम्ही अर्पिलेला यज्ञपशू त्याच दिवशी किंवा दुसर्‍या दिवशी खावा; पण तिसर्‍या दिवशी उरलेले जाळूनच टाकले पाहिजे. ");
INSERT INTO marc_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","जर कोणी तिसर्‍या दिवशी त्यातील काही खाल्ले तर ते अशुद्ध आहे आणि ते स्वीकारले जाणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","जो कोणी ते खाईल तो दोषी ठरेल, कारण ज्यागोष्टी याहवेहला पवित्र आहेत, त्याला त्यांनी अपवित्र केले आहे. अशा व्यक्तीला त्यांच्या लोकांमधून बहिष्कृत करावे. ");
INSERT INTO marc_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘तुम्ही पिकांची कापणी कराल, तेव्हा शेताच्या कानाकोपर्‍यातील पिकांची कापणी करू नये आणि शेतात हंगामानंतर राहिलेला सरवा गोळा करू नये. ");
INSERT INTO marc_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","तुमच्या द्राक्षमळ्यावर दुसर्‍यांदा जाऊ नका अथवा पडलेली द्राक्षे गोळा करू नका. गोरगरिबांसाठी आणि परदेशीयांसाठी ती तिथेच राहू द्यावी. मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘तुम्ही चोरी करू नये. “ ‘खोटे बोलू नये. “ ‘एकमेकांना फसवू नये. ");
INSERT INTO marc_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘तुम्ही माझ्या नावाने खोटी शपथ वाहू नये आणि तुमच्या परमेश्वराचे नाव अपवित्र करू नये. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘तुम्ही कोणाला फसवू नये किंवा तुमच्या शेजार्‍याला लुबाडू नये. “ ‘मजुरांची मजुरी रात्रभर दिवस उजाडेपर्यंत आपल्याजवळ ठेवू नये. ");
INSERT INTO marc_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘तुम्ही बहिर्‍यांना शाप देऊ नये किंवा आंधळ्याच्या समोर अडखळण ठेवू नये, परंतु तुमच्या परमेश्वराची भीती बाळगावी. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘न्याय देताना अन्याय करू नका; तुम्ही गरिबांमध्ये भेदभाव करू नये, उच्च लोकांच्या आदराचा तुमच्या निर्णयावर परिणाम होऊ नये, तर तुम्ही तुमच्या शेजार्‍याचा योग्य न्याय करावा. ");
INSERT INTO marc_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘तुमच्या लोकांमध्ये निंदा करीत फिरू नये. “ ‘तुमच्या शेजार्‍याचा जीव धोक्यात येईल असे काहीही करू नका. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘तुमच्याबरोबर असलेल्या इस्राएली मनुष्याचा तुमच्या अंतःकरणात द्वेष करू नये. तुमच्या शेजार्‍याला उघडपणे ताकीद द्यावी म्हणजे तुम्ही त्यांच्या पापाचे सहभागी होणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘सूड उगवू नका किंवा तुमच्या लोकांमध्ये कोणाचाही द्वेष करू नका, तर जशी तुम्ही स्वतःवर तशी तुमच्या शेजार्‍यावर प्रीती करावी. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘माझ्या आज्ञा पाळा. “ ‘तुम्ही आपल्या पशूंना भिन्न जातीच्या जनावरांशी संग करू देऊ नये. “ ‘तुमच्या शेतात दोन प्रकारच्या बियांची पेरणी करू नका. “ ‘दोन प्रकारच्या कापडांपासून विणलेली वस्त्रे वापरू नयेत. ");
INSERT INTO marc_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘एखादा मनुष्य एखाद्या गुलाम स्त्रीसोबत झोपेल जी एखाद्या पुरुषाशी वाग्दत्त झाली असेल, परंतु ज्याला खंडणी दिली गेली नाही किंवा तिला स्वातंत्र्य दिले गेले नाही, तर त्याला योग्य शिक्षा झाली पाहिजे. तरीही त्यांना मृत्युदंड दिला जाऊ नये, कारण तिला मुक्त केले गेले नाही. ");
INSERT INTO marc_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","त्या मनुष्याने याहवेहसाठी सभामंडपाच्या दाराशी आपले दोषार्पण म्हणून एक मेंढा आणलाच पाहिजे. ");
INSERT INTO marc_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","त्या मनुष्याने केलेल्या पापाबद्दल याजकाने त्या मेंढ्याद्वारे याहवेहसमोर प्रायश्चित्त करावे, म्हणजे त्याने केलेल्या पापाची त्याला क्षमा होईल. ");
INSERT INTO marc_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘तुम्ही आपल्या देशात प्रवेश कराल व तिथे सर्व प्रकारची फळझाडे लावाल. तेव्हा पहिली तीन वर्षे त्या झाडांची फळे खाऊ नका, कारण ती बेसुंती समजावी व तुम्हाला निषिद्ध आहेत, ");
INSERT INTO marc_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","चौथ्या वर्षी त्याची सर्व फळे पवित्र होतील, याहवेहच्या स्तुतीप्रीत्यर्थ ते द्यावे. ");
INSERT INTO marc_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","परंतु पाचव्या वर्षी ती फळे तुम्ही खावी. अशा प्रकारे तुमचे पीक वाढेल. मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘तुम्ही कोणतेही मांस रक्तासह खाऊ नये. “ ‘तुम्ही जादूटोणा करू नये किंवा शकुन पाहू नये. ");
INSERT INTO marc_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘तुम्ही आपले केस कापतांना बाजूचे केस कापून गोलाकार देऊ नये किंवा आपल्या दाढीचे टोक कापू नये. ");
INSERT INTO marc_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘मृत्यू पावलेल्यासाठी तुम्ही आपल्या शरीरावर जखमा करून घेऊ नये किंवा शरीर गोंदून घेऊ नये. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘तुम्ही आपल्या कन्यांना वेश्याकर्माला लावून त्यांना भ्रष्ट करू नये, नाहीतर देश व्यभिचारी होऊन दुष्टाईने भरून जाईल. ");
INSERT INTO marc_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘तुम्ही माझे शब्बाथ पाळावे आणि माझ्या पवित्र स्थानाविषयी आदर बाळगावा; मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘तुम्ही शकुनविद्या, ज्योतिष किंवा चेटक्यांची सल्लामसलत घेऊन स्वतःला भ्रष्ट करून घेऊ नये; मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘परमेश्वराची भीती बाळगून आपल्यापेक्षा वडील माणसांपुढे उभे राहून त्यांना मान द्या. त्यांना आदर दाखवा, मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘तुम्ही तुमच्या देशात असलेल्या परदेश्यांचा गैरफायदा घेऊ नये. त्यांच्याशी वाईट वागू नये. ");
INSERT INTO marc_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","जे परदेशी तुमच्यामध्ये राहत आहेत ते तुमच्या स्वदेशीय सारखेच आहेत, असे समजून तुम्ही त्यांना वागवावे. जशी स्वतःवर तशी त्यांच्यावर प्रीती करावी, कारण तुम्हीही इजिप्त देशात विदेशी होता. मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘लांबी, वजन किंवा प्रमाण मापण्यात अप्रामाणिक मापे वापरू नका. ");
INSERT INTO marc_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","तोलण्यात खरे तराजू आणि वजन उपयोगात आणावे आणि मापण्यात तुम्ही खरे एफा आणि हीन उपयोगात आणावे; कारण ज्याने तुम्हाला इजिप्त देशातून बाहेर आणले तो याहवेह मी तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘माझे सर्व विधी आणि माझे सर्व नियम याकडे तुम्ही लक्ष द्यावे आणि त्यांचे पालन करावे. मी याहवेह आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इस्राएली लोकांना सांग: इस्राएली लोकांपैकी कोणीही किंवा तुमच्यात राहणाऱ्या कोणत्याही परदेश्याने त्याच्या मुलाचे अर्पण मोलख दैवतासाठी केले, तर समुदायातील सभासदांनी त्याला दगडमार करावा. ");
INSERT INTO marc_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मी स्वतः त्या मनुष्याच्या विरुद्ध माझे मुख फिरवेन व लोकातून त्याच्या उच्छेद करेन; कारण त्याने आपले मूल मोलख दैवताला बळी देऊन व माझे पवित्रस्थान भ्रष्ट करून माझ्या पवित्र नावाचा अपमान केला आहे. ");
INSERT INTO marc_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","पण जर त्या मनुष्याने आपले मूल मोलखला बळी दिले हे माहीत असूनही त्या समुदायाच्या लोकांनी त्याकडे डोळेझाक केली व बळी देणार्‍याला मारून टाकण्याचे नाकारले, ");
INSERT INTO marc_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","मी स्वतः त्याच्याविरुद्ध व त्याच्या घराण्याविरुद्ध मुख फिरवेन आणि मोलखबरोबर व्यभिचार करून त्याचे अनुकरण करणार्‍या सर्वांचा त्यांच्या लोकांतून नाश करेन. ");
INSERT INTO marc_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘शकुनविद्या आणि चेटक्यांची अनुसरण करून स्वतःला वेश्या करण्याचा प्रयत्न करणार्‍यांकडून मी माझे मुख फिरवेन आणि मी त्याचा त्याच्या लोकांमधून उच्छेद करेन. ");
INSERT INTO marc_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘तुम्ही स्वतःस शुद्ध राखून पवित्र राहावे, कारण मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","तुम्ही माझे नियम पाळा आणि त्याचे पालन करा. मी याहवेह आहे, जो तुम्हाला पवित्र करतो. ");
INSERT INTO marc_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘जो कोणी आपल्या वडिलांना किंवा आईला शाप देतो, त्याला अवश्य जिवे मारावे, कारण त्याने स्वतःच्या आईवडिलांना शाप दिला आहे, त्याच्या रक्ताचा दोष त्याच्याच माथी राहील. ");
INSERT INTO marc_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘जर कोणी व्यक्ती दुसर्‍याच्या पत्नीबरोबर व्यभिचार करतो—आपल्या शेजार्‍याच्या पत्नीबरोबर व्यभिचार करतो—त्या व्यभिचारी आणि व्यभिचारिणी दोघांनाही जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘जो व्यक्ती आपल्या पित्याच्या पत्नीशी शारीरिक संबंध ठेवतो, तो आपल्या पित्याचा अपमान करतो. त्या व्यक्तीला व त्या स्त्रीला अवश्य जिवे मारावे; त्यांच्या रक्ताचा दोष त्यांच्याच माथी राहील. ");
INSERT INTO marc_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘एखाद्या व्यक्तीने आपल्या सुनेबरोबर शारीरिक संबंध ठेवले, तर त्या दोघांनाही अवश्य जिवे मारावे; त्यांनी जे केले ते विकृत आहे; त्यांच्या रक्ताचा दोष त्यांच्याच मस्तकी राहील. ");
INSERT INTO marc_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘जर एखादा पुरुष जसे एखाद्या स्त्रीसोबत तसे दुसर्‍या पुरुषाशी शारीरिक संबंध ठेवतो, तर त्या दोघांनीही घृणास्पद कृत्य केले आहे. त्या दोघांनाही अवश्य जिवे मारावे; त्यांच्या रक्ताचा दोष त्यांच्याच मस्तकी राहील. ");
INSERT INTO marc_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘एखाद्या व्यक्तीने एखाद्या स्त्रीबरोबर विवाह करून तिच्या आईबरोबरही विवाह केला, तर ती भयंकर दुष्टता आहे. तुमच्यातील ही दुष्टता निपटून काढण्यासाठी त्या पुरुषाला व त्या दोन्ही स्त्रियांना अग्नीत जाळून टाकावे. ");
INSERT INTO marc_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘एखाद्या व्यक्तीने प्राण्यासोबत शारीरिक संबंध ठेवले, तर त्या व्यक्तीला जिवे मारावे; त्या पशूलाही ठार करावे. ");
INSERT INTO marc_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘जर एखादी स्त्री एखाद्या प्राण्याशी शारीरिक संबंध ठेवण्यासाठी गेली तर ती स्त्री आणि तो प्राणी दोघांनाही मारून टाका. त्या दोघांनाही अवश्य जिवे मारावे; त्यांच्या रक्ताचा दोष त्यांच्याच मस्तकी राहील. ");
INSERT INTO marc_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘एखाद्या व्यक्तीने आपल्या बहिणीबरोबर मग ती त्याच्या पित्याची किंवा आईची कन्या असो, विवाह केला आणि त्यांनी शारीरिक संबंध ठेवले, तर ते अपमानास्पद आहे. त्यांना जाहीरपणे लोकांमधून काढून टाकावे. कारण त्याने आपल्या बहिणीचा अपमान केला आहे आणि त्यासाठी तोच जबाबदार राहील. ");
INSERT INTO marc_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘एखादी स्त्री ॠतुमती असताना तिच्याबरोबर एखाद्या व्यक्तीने शारीरिक संबंध ठेवले, तर त्याने तिच्या प्रवाहाचा स्त्रोत उघड केला आहे आणि तिने देखील ते उघड केले आहे. तर दोघांनाही समुदायामधून बहिष्कृत करावे. ");
INSERT INTO marc_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘आईच्या किंवा वडिलांच्या बहिणीशी शारीरिक संबंध ठेवू नका, कारण त्यामुळे जवळच्या नातेवाईकाचा अपमान होईल; त्यांना आपल्या पापाचा भार वाहावा लागेल. ");
INSERT INTO marc_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘एखाद्या व्यक्तीने आपल्या वडिलांच्या भावाच्या पत्नीसोबत शारीरिक संबंध ठेवले, तर त्याने त्याच्या वडिलांच्या भावाचा अपमान केला आहे. त्यांना जबाबदार धरले जाईल; ते निःसंतान मरतील. ");
INSERT INTO marc_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘एखाद्या व्यक्तीने आपल्या भावाच्या पत्नीसोबत विवाह केला, तर ते अशुद्धपणाचे कृत्य होय; त्याने आपल्या भावाचा अपमान केला आहे. ते निःसंतान राहतील. ");
INSERT INTO marc_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘तुम्ही माझे विधी व नियम पाळले तर मी वस्ती करून राहण्यासाठी ज्या देशात तुम्हाला नेत आहे, ती भूमी तुम्हाला बाहेर ओकून देणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ज्या राष्ट्रांना मी तुमच्यापुढून घालवून देत आहे, त्या राष्ट्रांचे रीतिरिवाज तुम्ही पाळू नयेत, कारण त्यांनी ही दुष्कर्मे केली म्हणून मला त्यांचा तिरस्कार आहे. ");
INSERT INTO marc_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","परंतु मी तुम्हाला म्हणालो, “तुम्ही त्यांच्या देशाचे मालक व्हाल; मी तुम्हाला तो वारसाप्राप्त संपत्ती असे देईन, दुधामधाचे प्रवाह वाहणारा असा तो देश आहे.” तुम्हाला इतर राष्ट्रांपासून वेगळे राखणारा, मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘तुम्हाला शुद्ध आणि अशुद्ध प्राणी, शुद्ध आणि अशुद्ध पक्षी यांच्यात स्पष्ट फरक करावा लागेल; कोणत्याही पशू, पक्षी किंवा जमिनीवर सरपटणार्‍या प्राण्यामुळे स्वतःला अशुद्ध करू नका, ज्यांना मी तुमच्यासाठी अशुद्ध म्हणून वेगळे केले आहे. ");
INSERT INTO marc_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तुम्ही माझ्यासाठी पवित्र असावे, कारण मी याहवेह पवित्र आहे आणि तुम्ही माझे व्हावे म्हणून मी तुम्हाला इतर सर्व राष्ट्रांपासून वेगळे केले आहे. ");
INSERT INTO marc_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘शकुनविद्या वा चेटूक करणारा पुरुष किंवा स्त्री यांना अवश्य जिवे मारावे. त्यांना दगडमार करावा. त्यांच्या रक्ताचा दोष त्यांच्याच मस्तकी राहील.’ ” ");
INSERT INTO marc_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","याहवेह मोशेला म्हणाले, “याजकांना म्हणजे अहरोनाच्या पुत्रांना सांग की: तुमच्या लोकांपैकी कोणाचाही मृत्यू झाल्यावर कोणीही स्वतःला विधिनियमानुसार अशुद्ध करू नये, ");
INSERT INTO marc_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","आपले जवळचे नातलग म्हणजे त्याची आई किंवा वडील, पुत्र किंवा कन्या, त्याचा भाऊ ");
INSERT INTO marc_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","किंवा अविवाहित बहीण, जी त्याच्यावर अवलंबून आहे कारण तिला पती नाही—यांच्यासाठी तो स्वतःला अशुद्ध करू शकतो. ");
INSERT INTO marc_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","याजक लोकांचा प्रमुख असल्यामुळे, त्याच्या विवाहाच्या द्वारे संबंधित लोकांसाठी त्याने स्वतःला अपवित्र करून अशुद्ध करू नये. ");
INSERT INTO marc_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘याजकाने मुंडण करू नये किंवा दाढीची टोके छाटू नयेत किंवा शरीराला जखमा करून घेऊ नयेत. ");
INSERT INTO marc_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","त्यांनी त्यांच्या परमेश्वरासाठी पवित्र राहावे आणि त्यांच्या परमेश्वराच्या नावाला काळिमा लावू नये. ते याहवेहला अन्नार्पण म्हणजे त्यांच्या परमेश्वराचे अन्न अर्पितात, म्हणून त्यांनी पवित्र राहावे. ");
INSERT INTO marc_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘त्यांनी वेश्यावृत्तीने भ्रष्ट झालेल्या किंवा त्यांच्या पतीला घटस्फोट दिलेल्या स्त्रियांबरोबर विवाह करू नये; कारण याजक त्यांच्या परमेश्वरासाठी पवित्र आहेत. ");
INSERT INTO marc_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","त्यांना पवित्र मानावे, कारण ते तुमच्या परमेश्वराला अन्न अर्पण करतात. त्यांना पवित्र समजावे, कारण मी याहवेह पवित्र आहे—मीच आहे जो तुम्हाला पवित्र करतो. ");
INSERT INTO marc_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘एखाद्या याजकाची कन्या वेश्याकर्म करून स्वतःला भ्रष्ट करते तर ती आपल्या पित्याला अशुद्ध करते, म्हणून तिला अग्नीत जाळून टाकावे. ");
INSERT INTO marc_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘प्रमुख याजक, म्हणजे ज्याच्या मस्तकावर अभिषेकाचे तेल ओतण्यात आले आहे व जो याजकीय वस्त्रे घालण्यास पवित्र करण्यात आला आहे, त्याने शोक व्यक्त करण्याकरिता आपले केस मोकळे सोडू नयेत किंवा आपली वस्त्रे फाडू नये. ");
INSERT INTO marc_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ज्या ठिकाणी मृतदेह असेल अशा ठिकाणी त्याने प्रवेश करू नये. मग तो त्याच्या वडिलांचा असो किंवा आईचा, त्याने स्वतःला अशुद्ध करू नये. ");
INSERT INTO marc_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","त्याच्या परमेश्वराचे पवित्रस्थान सोडू नये किंवा ते अपवित्र करू नये, कारण तो त्याच्या परमेश्वराच्या अभिषेकाच्या तेलाद्वारे समर्पित करण्यात आलेला आहे. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘त्याने कुमारिकेबरोबरच विवाह करावा. ");
INSERT INTO marc_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","त्याने विधवा, घटस्फोटित किंवा वेश्यावृत्तीने भ्रष्ट झालेल्या स्त्रीसह विवाह करू नये, परंतु त्याने त्याच्या स्वतःच्याच वंशातील कुमारिकेशी विवाह करावा, ");
INSERT INTO marc_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","त्यामुळे तो त्याच्या लोकांमध्ये त्याचे वंशज अशुद्ध करणार नाही. मी याहवेह आहे, जो त्याला पवित्र करतो.’ ” ");
INSERT INTO marc_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“अहरोनास सांग, ‘पिढ्यान् पिढ्या त्याच्या कुळातील शरीराने अपंग असलेल्या कोणीही अन्नार्पण करण्यासाठी परमेश्वराजवळ येऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","एखादा मनुष्य आंधळा, लंगडा, चपट्या नाकाचा, हातापायांना अधिक बोटे असलेला; ");
INSERT INTO marc_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ज्याचा पाय किंवा हात तुटलेला आहे, ");
INSERT INTO marc_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","कुबडा, ठेंगणा, डोळ्यात कमतरता असलेला, त्वचेचे रोग असलेला व भग्नांड असून ");
INSERT INTO marc_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","तो अहरोन याजकाचा वंशज असला, तरी शारीरिक व्यंग असल्यामुळे त्याने याहवेहला अन्न अर्पिण्यास जाऊ नये; त्याच्यात कमतरता आहे; त्याने त्याच्या परमेश्वराजवळ अन्नार्पण करण्यासाठी जाऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","तरी त्याच्या परमेश्वराचे परमपवित्र अन्न व पवित्र अन्न तो खाऊ शकतो; ");
INSERT INTO marc_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","पण त्याला शारीरिक व्यंग असल्यामुळे त्याने पडद्यामागील परमपवित्रस्थानात किंवा वेदीजवळही जाऊ नये, त्याने तसे केल्यास, माझे पवित्रस्थान भ्रष्ट होईल, कारण त्यांना पवित्र करणारा मीच याहवेह आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","अहरोन, त्याचे पुत्र आणि सर्व इस्राएली लोकांना मोशेने हे सांगितले. ");
INSERT INTO marc_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“अहरोन व त्याच्या पुत्रांना सांग की, इस्राएलच्या लोकांनी आणलेल्या पवित्र अर्पणांचा आदर करावा, म्हणजे ते माझ्या पवित्र नावाला अपवित्र करणार नाही. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“त्यांना सांग: ‘आतापासून पुढे पिढ्यान् पिढ्या जो कोणी विधिनियमानुसार अशुद्ध असताना इस्राएल लोकांनी याहवेहसाठी आणलेल्या पवित्र अर्पणांना स्पर्श करेल, त्याचा माझ्या समक्षतेपासून उच्छेद करावा; मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘जर अहरोनाच्या वंशापैकी कोणास कुष्ठरोग असेल किंवा शरीरातून स्राव होत असेल, तर त्याने शुद्ध होईपर्यंत, पवित्र अर्पणे खाऊ नयेत. प्रेताला स्पर्श केल्यामुळे किंवा वीर्यपात झालेल्या व्यक्तीला स्पर्श केला तर तो देखील अशुद्ध होईल, ");
INSERT INTO marc_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","किंवा जमिनीवर सरपटणार्‍या कोणत्याही अशुद्ध प्राण्याला स्पर्श केल्यामुळे किंवा कोणत्याही प्रकारची अशुद्ध असलेल्या कोणत्याही व्यक्तीला स्पर्श केला तर तो अशुद्ध होईल. ");
INSERT INTO marc_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","अशा कोणालाही त्या व्यक्तीने स्पर्श केला तर तो सायंकाळपर्यंत अशुद्ध राहील आणि पाण्याने स्नान केल्याशिवाय पवित्र अर्पणांतील अन्न खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","सूर्य मावळल्यानंतर तो पुन्हा शुद्ध ठरेल व तेव्हाच त्याने पवित्र अन्न खावे, कारण तेच त्याचे अन्न आहे. ");
INSERT INTO marc_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","मृत पावलेले किंवा जंगली प्राण्याने मारलेल्या जनावराचे मांस त्याने खाऊन अशुद्ध होऊ नये. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘याजकांनी माझी सेवा काळजीपूर्वक करावी, नाहीतर माझी सेवा निंदापूर्वक केल्याने त्यांना दोषी ठरवून मरणदंड भोगावा लागेल. त्यांना पवित्र करणारा मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘याजकाच्या कुटुंबा बाहेरील इतर कोणीही, त्याच्याकडे आलेले पाहुणे किंवा त्याच्याकडे काम करणारे मजूर यांनी पवित्र अर्पणांतील कोणताही पदार्थ खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","पण याजकाने स्वतःच्या पैशाने गुलाम विकत घेतला असेल किंवा जर त्या गुलामांनी याजकाच्या घरात जन्म घेतला असेल, ते त्याचे अन्न खाऊ शकतील. ");
INSERT INTO marc_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","जर याजकाच्या कन्येचा विवाह याजकासोबत झाला नसून, दुसर्‍यासोबत झाला असेल तर तिने पवित्र अर्पणांतील पदार्थ खाऊ नयेत. ");
INSERT INTO marc_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","पण जर याजकाची मुलगी विधवा किंवा पतीने सोडलेली असून तिला पुत्र नसेल आणि ती तरुणपणी पुन्हा आपल्या पित्याच्या घरात येऊन राहत असेल, तर मात्र तिने आपल्या पित्याच्या घरातील अन्न खावे. तथापि, कोणत्याही अनधिकृत व्यक्तीने हे अन्न खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘एखाद्याने चुकून पवित्र अर्पणांतील काही पदार्थ खाल्ले, तर त्याने जितके पदार्थ खाल्ले असतील तितके सर्व आणि पाचव्या हिश्शाइतका पदार्थाचा भाग याजकाला द्यावा. ");
INSERT INTO marc_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","इस्राएली लोकांनी याहवेहला अर्पिलेली पवित्र अर्पणे, याजकाने भ्रष्ट करू नयेत, ");
INSERT INTO marc_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ती पवित्र अर्पणे खाण्यास मनाई न केल्यास पापदंड भरण्याची शिक्षा त्यांच्यावर ते ओढवून घेतील; मी याहवेह आहे, जो त्यांना पवित्र करतो.’ ” ");
INSERT INTO marc_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“अहरोन, त्याचे पुत्र व इस्राएली लोकांना सांग, ‘जर तुमच्यापैकी—इस्राएली लोकांपैकी किंवा इस्राएलात राहणारे विदेशी यापैकी कोणीही—याहवेहला वचनपूर्तीचे किंवा स्वैच्छिक होमार्पण आणले, ");
INSERT INTO marc_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","तर ते तुमच्यावतीने मान्य होण्यासाठी निर्दोष गोर्‍हा, मेंढा किंवा बोकड यांचेच असावे. ");
INSERT INTO marc_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","दोष असलेला कोणताही प्राणी अर्पण करू नये, कारण ते तुमच्यावतीने मान्य केले जाणार नाहीत. ");
INSERT INTO marc_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","याहवेहसाठी कोणी स्वतःच्या गुरांतून किंवा शेरडामेंढरांतून शपथपूर्तीचे किंवा स्वखुशीचे शांत्यर्पण करेल, तर ते मान्य होण्यासाठी ते निर्दोष प्राण्याचेच असावे. ");
INSERT INTO marc_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","याहवेहला आंधळा, हाड तुटलेला, लुळा किंवा अंगावर मस, इसब अथवा खरूज असलेला असा कोणताही प्राणी अर्पण करू नका. यापैकी काहीही वेदीवर याहवेहला हवन म्हणून अर्पण ठेऊ नका. ");
INSERT INTO marc_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","तुम्ही एखाद्या गोर्‍ह्याला किंवा मेंढ्याला, एखादा अवयव जास्त वा कमी असेल, तर तो प्राणी स्वखुशीचे अर्पण म्हणून चालेल, पण शपथपूर्तीचे अर्पण म्हणून तो अर्पण करता येणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ज्या प्राण्याचे अंडकोश ठेचलेले किंवा चिरडलेले किंवा फाटलेले किंवा कापलेले असेल, त्याचे अर्पण याहवेहला कधीही करू नये. तुमच्या स्वतःच्या देशात असे करू नका. ");
INSERT INTO marc_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","आणि तुम्ही अशा प्रकारचे प्राणी परराष्ट्रीयांकडून घेऊ नयेत आणि तुमच्या परमेश्वरासाठी अन्नार्पण करू नये. ते तुमच्यावतीने स्वीकारले जाणार नाहीत, कारण ते विकृत आहेत आणि त्यांच्यात दोष आहेत.’ ” ");
INSERT INTO marc_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“वासरू, कोकरू वा करडू जन्मले असताना ते सात दिवस त्याच्या आईजवळ राहू द्यावे; आठव्या दिवसापासून याहवेहला अन्नार्पण करण्यास योग्य ठरेल. ");
INSERT INTO marc_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","गाई व तिचे वासरू किंवा मेंढी व तिचे करडू यांचा एकाच दिवशी वध करू नये. ");
INSERT INTO marc_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“ज्यावेळी तुम्ही याहवेहला उपकारस्तुतीच्या बलीचा यज्ञ करता तेव्हा अशा प्रकारे करावा की तो तुमच्यावतीने मान्य व्हावा. ");
INSERT INTO marc_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","त्याच दिवशी ते खाऊन टाकावे; त्यातील काहीही सकाळपर्यंत ठेवू नये. मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“तुम्ही माझ्या सर्व आज्ञा पाळाव्यात; मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","माझ्या पवित्र नावाला अपवित्र करू नका, कारण मला इस्राएली लोकांनी पवित्र म्हणून ओळखावे. मी याहवेह आहे, ज्याने तुम्हाला पवित्र केले ");
INSERT INTO marc_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","आणि ज्याने तुमचा परमेश्वर होण्यासाठी तुम्हाला इजिप्तमधून बाहेर आणले. मी याहवेह आहे.” ");
INSERT INTO marc_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएली लोकांबरोबर बोल आणि त्यांना सांग: ‘हे मी नेमून दिलेले सण आहेत, याहवेहचे नेमून दिलेले सण, जे तुम्ही पवित्र मेळावे असे जाहीर करावे. ");
INSERT INTO marc_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘आठवड्यातील सहा दिवस त्यांनी कामकाज करावे, परंतु सातवा दिवस हा शब्बाथ, विश्रांतीचा दिवस आहे. पवित्र मेळाव्याचा दिवस. तुम्ही कोणतेही काम करू नये; तुम्ही कुठेही राहत असाल तरी याहवेहसाठी हा शब्बाथ आहे. ");
INSERT INTO marc_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘याहवेहने नेमून दिलेले हे पवित्र सण आहेत, पवित्र मेळाव्यांची घोषणा तुम्ही त्यांच्या ठरवून दिलेल्या वेळांमध्ये करावी: ");
INSERT INTO marc_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","याहवेहच्या वल्हांडण सणाची सुरुवात पहिल्या महिन्याच्या चौदाव्या दिवसाच्या संध्याकाळपासून होते. ");
INSERT INTO marc_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","त्या महिन्याच्या पंधराव्या दिवशी याहवेहचा बेखमीर भाकरीचा सण सुरू होतो; सात दिवस खमीर नसलेली भाकर खावी. ");
INSERT INTO marc_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","पहिल्या दिवशी एक पवित्र सभा भरवावी व कोणतीही नियमित कामे करू नये. ");
INSERT INTO marc_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","सात दिवस याहवेहसाठी अन्नार्पण द्यावे. सातव्या दिवशी पवित्र सभा भरवावी आणि नियमित कामे करू नये.’ ” ");
INSERT INTO marc_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएली लोकांबरोबर बोल आणि त्यांना सांग: ‘मी जो देश तुम्हाला देणार आहे, जेव्हा तुम्ही तिथे प्रवेश कराल आणि पिकांची कापणी कराल, तेव्हा तुम्ही कापणी केलेल्या पहिल्या धान्याची एक पेंढी याजकाकडे आणावी. ");
INSERT INTO marc_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","त्याने याहवेहसमोर पेंढी ओवाळावी, जेणेकरून ते तुमच्यावतीने मान्य केले जाईल; शब्बाथाच्या दुसर्‍या दिवशी याजकाने ते ओवाळावे. ");
INSERT INTO marc_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","आता ज्या दिवशी तुम्ही पेंढी ओवाळाल, त्याच दिवशी तुम्ही याहवेहला एक वर्षाच्या निर्दोष कोकर्‍याचे होमार्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","त्याच्या धान्यासोबत, जैतुनाच्या तेलात मळलेल्या सपिठाच्या एक एफाचा दहावा भाग जैतुनाच्या तेलात मळून अर्पावा; हा याहवेहला प्रसन्न करणारा सुगंध आहे. त्यासोबत पावशेर हीन द्राक्षारसही याहवेहला अर्पण करावा. ");
INSERT INTO marc_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","तुम्ही आपल्या परमेश्वराला हे सर्व अर्पण आणल्याशिवाय पिकातील कोणताही भाग म्हणजे कोवळी कणसे, त्या धान्याच्या भाकरी किंवा भाजलेले दाणे यापैकी काहीही खाऊ नये. तुम्ही कुठेही राहिले तरी येणार्‍या पिढ्यांसाठी हा कायमचा नियम आहे. ");
INSERT INTO marc_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘शब्बाथाच्या दुसर्‍या दिवशी, तुम्ही ओवाळणीची पेंढी आणाल त्या दिवसापासून पुढे पूर्ण सात आठवडे मोजावे. ");
INSERT INTO marc_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","पन्नासाव्या दिवशी म्हणजे सात शब्बाथ संपल्यानंतर दुसर्‍या दिवशी याहवेहला पुन्हा एकदा नवे अन्नार्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तुम्ही कुठेही राहत असाल तरी अर्पण म्हणून दोन भाकरी आणाव्यात. एका एफाच्या दहा भागातील दोन भाग सपिठाच्या खमीर घालून भाजलेल्या असाव्यात, पहिल्या उत्पन्नातून ओवाळणीचे अर्पण म्हणून याहवेहसाठी असे अर्पण आणावे. ");
INSERT INTO marc_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","या भाकरीबरोबर तुम्ही एक वर्षाची सात निर्दोष नरकोकरे, एक गोर्‍हा व दोन मेंढे अर्पावे, ते पेयार्पण व अन्नार्पणासह याहवेहला एक होमार्पण असतील, याहवेहला प्रसन्न करणारा एक सुगंध होमार्पण. ");
INSERT INTO marc_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","मग याजकाने पापार्पणासाठी एक बोकड व शांत्यर्पणासाठी एक वर्षांचे दोन मेंढे अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","याजक ती प्रथम उपजाची भाकर घेऊन तिला ओवाळणी देईल व दोन मेंढ्यांबरोबर ती याहवेहला अर्पण करेल. हे सर्व याहवेहसाठी पवित्र ठरेल व ते याजकासाठी भाग म्हणून असेल. ");
INSERT INTO marc_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","त्याच दिवशी तुम्ही एक पवित्र सभा भरवा आणि नियमित कामे करू नका. तुम्ही कुठेही राहिले तरी तुमच्या सर्व भावी पिढ्यांसाठी हा कायमचा नियम आहे. ");
INSERT INTO marc_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘तुम्ही आपल्या जमिनीतील पिकांची कापणी कराल, तेव्हा शेताच्या कानाकोपर्‍यातील पिकांची कापणी करू नये किंवा खाली पडलेले धान्य गोळा करू नये. हे गरिबांसाठी व तुम्हामध्ये राहणार्‍या परदेशीयांसाठी ते तसेच राहू द्यावे. मी याहवेह तुमचा परमेश्वर आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएली लोकास सांग: ‘सातव्या महिन्याचा पहिला दिवस तुम्ही शब्बाथ विश्रांतीसाठी ठेवावा, या दिवशी पवित्र मेळावा करून स्मृतिदिन म्हणून कर्णे फुंकावेत. ");
INSERT INTO marc_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","या दिवशी कोणतीही कष्टाची कामे करू नये, परंतु याहवेहला अन्नार्पण म्हणून हवन करावे.’ ” ");
INSERT INTO marc_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","नंतर याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“सातव्या महिन्याचा दहावा दिवस प्रायश्चिताचा दिवस आहे. एक पवित्र मेळावा भरवावा आणि स्वतःचा नकार करावा आणि याहवेहला अन्नार्पण करावे. ");
INSERT INTO marc_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","या दिवशी तुम्ही कोणतेही कामकाज करू नये, कारण हा दिवस याहवेह तुमच्या परमेश्वरापुढे तुम्हाप्रीत्यर्थ प्रायश्चित्त करण्यात येईल. ");
INSERT INTO marc_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","जे कोणी स्वतःचा नकार करणार नाहीत, त्यांचा त्यांच्या लोकांतून समूळ नाश करण्यात येईल. ");
INSERT INTO marc_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","जो कोणी त्या दिवशी कोणतेही काम करेल त्याचा मी त्यांच्या लोकांमधून नाश करेन. ");
INSERT INTO marc_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","कोणीही या दिवशी कोणतेही कामकाज करू नये, तुम्ही कुठेही राहाल, इस्राएलाच्या पिढ्यान् पिढ्यांसाठी हा कायमचा नियम आहे. ");
INSERT INTO marc_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","तो दिवस तुमच्यासाठी शब्बाथ, विश्रांतीचा दिवस आहे आणि तुम्ही स्वतःला नाकारले पाहिजे. महिन्याच्या नवव्या दिवसाच्या संध्याकाळपासून पुढील संध्याकाळपर्यंत तुम्ही तुमचा शब्बाथ पाळावा.” ");
INSERT INTO marc_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएली लोकांना सांग: ‘सातव्या महिन्याच्या पंधराव्या दिवसापासून याहवेहकरिता मंडपाचा सण सात दिवस पाळावा. ");
INSERT INTO marc_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहिला दिवस हा पवित्र मेळावा आहे. कोणतेही नियमित काम या दिवशी करू नये. ");
INSERT INTO marc_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","सात दिवस याहवेहला अन्नार्पण करा आणि आठव्या दिवशी पवित्र मेळावा भरवून याहवेहला अन्नार्पण करा. हा मेळाव्याचा समारोप आहे; कोणतेही नियमित काम करू नका. ");
INSERT INTO marc_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘हे याहवेहने स्थापित केलेले सण आहेत, जे तुम्ही याहवेहला अन्नार्पण करण्यासाठी पवित्र मेळावे घोषित करावे; होमार्पण, धान्यार्पण, शांत्यर्पण व पेयार्पण आवश्यक त्या दिवशी अर्पणे करावी. ");
INSERT INTO marc_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ही अर्पणे याहवेहच्या शब्बाथांच्या व्यतिरिक्त आहेत आणि हे यज्ञ तुम्ही परमेश्वराला अर्पण करता त्या तुमच्या देणग्या आणि नवस फेडावयाची अर्पणे आणि स्वैच्छिक अर्पणे त्या व्यतिरिक्त आहेत.) ");
INSERT INTO marc_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘सातव्या महिन्याच्या पंधराव्या दिवशी, जेव्हा तुम्ही जमिनीचे पीक गोळा कराल, तेव्हा सात दिवस याहवेहपुढे सण पाळावा. पहिला दिवस हा शब्बाथ, विश्रामदिन आणि आठवा दिवसही शब्बाथाचा विश्रामदिन असेल. ");
INSERT INTO marc_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पहिल्या दिवशी तुम्ही दाट पाने असलेल्या झाडांच्या फांद्या—खजुरीच्या झावळ्या, वाळुंजे, आणि भरपूर पाने असलेली इतर झाडांच्या फांद्या—घेऊन याहवेह तुमच्या परमेश्वरापुढे सात दिवस आनंदोत्सव करावा. ");
INSERT INTO marc_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","हा सात दिवसांचा वार्षिक सण तुम्ही याहवेहसाठी प्रत्येक वर्षी पाळावा. हा सर्वकाळचा नियम येणार्‍या पिढ्यांसाठी आहे; सातव्या महिन्यात हा सण साजरा करावा. ");
INSERT INTO marc_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","या सात दिवसात इस्राएली वंशातील सर्वांनी डहाळ्याच्या मंडपात राहावे ");
INSERT INTO marc_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","यासाठी की, तुमच्या भावी पिढीला हे कळावे की, जेव्हा मी इस्राएलच्या घराण्याला इजिप्तमधून बाहेर काढले तेव्हा मी त्यांना मंडपात राहायला लावले. मी याहवेह तुमचा परमेश्वर आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","अशाप्रकारे याहवेहनी नेमून दिलेले हे वार्षिक सण मोशेने इस्राएली लोकांना जाहीर केले. ");
INSERT INTO marc_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएली लोकांना आज्ञा दे की दिवे अखंड पेटत राहावे म्हणून त्यांनी कुटून काढलेले जैतुनाचे शुद्ध तेल तुझ्याकडे आणावे. ");
INSERT INTO marc_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","सभामंडपातील जे पडदे कराराच्या कोशाला झाकतात, त्याच्याबाहेर अहरोनाने संध्याकाळपासून सकाळपर्यंत याहवेहसमोर दिवे सतत पेटत ठेवावेत, हा नियम पिढ्यान् पिढ्या असावा. ");
INSERT INTO marc_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","याहवेहसमोर असलेल्या शुद्ध सोन्याच्या दीपस्तंभावरील दिव्यांची नियमितपणे व्यवस्था करावी. ");
INSERT INTO marc_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“सपीठ घ्यावे आणि त्याच्या बारा भाकरी तयार कराव्या, प्रत्येक भाकरीसाठी दोन दशांश एफा वापरावा. ");
INSERT INTO marc_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","त्यांच्या दोन रांगा आणि प्रत्येक रांगेत सहा भाकरी शुद्ध सोन्याच्या मेजावर मांडून याहवेहसमोर ठेवाव्यात. ");
INSERT INTO marc_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","प्रत्येक रांगेभोवती स्मरणभाग म्हणून शुद्ध धूप टाकावा, याचे प्रतीक म्हणून भाकर आणि अन्नार्पण हे याहवेहसाठी अर्पण करावी. ");
INSERT INTO marc_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ही भाकर याहवेहसमोर नियमितपणे मांडून ठेवावी, शब्बाथानंतर शब्बाथ, इस्राएली लोकांसाठी हा शाश्वत करार आहे. ");
INSERT INTO marc_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","या भाकरी अहरोन व त्याच्या पुत्रांचा वाटा होय, ज्या त्यांनी पवित्रस्थानात बसून खाव्यात; कारण याहवेहला अर्पण केल्या जाणार्‍या यज्ञातील हा परमपवित्र भाग आहे. त्याचा त्यावर कायमचा अधिकार आहे.” ");
INSERT INTO marc_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","एकदा एका इस्राएली स्त्रीचा मुलगा, ज्याचे वडील इजिप्तचे होते, इस्राएली छावणीत गेला. तिथे छावणीत त्याचे आणि एका इस्राएली मनुष्याचे भांडण झाले. ");
INSERT INTO marc_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","इस्राएली स्त्रीच्या मुलाने परमेश्वराच्या नावाची निंदा केली आणि तो शिव्याशाप देऊ लागला; तेव्हा त्याला मोशेकडे आणले. (त्याच्या आईचे नाव शेलोमीथ होते, ती दान वंशातील दिब्रीची कन्या होती.) ");
INSERT INTO marc_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","तेव्हा याहवेहची इच्छा त्यांना स्पष्ट समजून येईपर्यंत त्यांनी त्याला अटकेत ठेवले. ");
INSERT INTO marc_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","मग याहवेहनी मोशेला सांगितले: ");
INSERT INTO marc_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“परमेश्वराच्या नावाची निंदा करणार्‍याला छावणीच्या बाहेर घेऊन जा. ज्यांनी हे बोलताना ऐकले आहे, त्यांनी त्याच्या डोक्यावर आपले हात ठेवावेत आणि संपूर्ण मंडळीने त्याच्यावर दगडमार करावा. ");
INSERT INTO marc_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","इस्राएली लोकांना सांग: ‘जो कोणी आपल्या परमेश्वराला शिव्याशाप देईल त्याने आपल्या पापाची शिक्षा भोगावी; ");
INSERT INTO marc_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","याहवेहच्या नावाची जो कोणी निंदा करेल त्याला निश्चित जिवे मारावे. संपूर्ण मंडळीने त्याच्यावर दगडमार करावा. परदेशीय असो किंवा देशात जन्मलेला, जेव्हा ते परमेश्वराच्या नावाची निंदा करतात त्यांना निश्चित जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘जो कोणी एखाद्या मनुष्याचा जीव घेईल त्याला निश्चित जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","जो कोणी एखाद्या मनुष्याच्या प्राण्याची हत्या करतो, तर त्याने निश्चित त्याची परतफेड करावी—जीवनासाठी जीवन. ");
INSERT INTO marc_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","जो कोणी आपल्या शेजार्‍याला दुखापत करतो, त्याला त्याच प्रकारे दुखापत केली पाहिजे: ");
INSERT INTO marc_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","हाड मोडल्याबद्दल हाड मोडणे, डोळ्याबद्दल डोळा, दाताबद्दल दात. ज्याप्रमाणे त्याने एखाद्या व्यक्तीला दुखापत केली आहे, त्यालाही निश्चित तीच दुखापत झाली पाहिजे. ");
INSERT INTO marc_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","जो कोणी प्राण्याची हत्या करतो, त्याने निश्चित त्याची परतफेड करावी, परंतु जो कोणी मनुष्याची हत्या करतो त्याला जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","परदेशीय किंवा देशात जन्मलेल्यासाठी सारखाच नियम असावा. मी याहवेह तुमचा परमेश्वर आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","मग मोशे इस्राएली लोकांसोबत बोलला आणि त्यांनी त्या निंदा करणार्‍याला छावणीबाहेर नेले आणि त्याच्यावर दगडमार केला. याहवेहने मोशेला आज्ञापिल्यानुसार इस्राएली लोकांनी केले. ");
INSERT INTO marc_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","सीनाय पर्वतावर याहवेहनी मोशेला सांगितले, ");
INSERT INTO marc_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएली लोकांशी बोल आणि त्यांना सांग: ‘मी तुम्हाला देत असलेल्या देशात तुम्ही पोहोचाल, तेव्हा त्या भूमीने याहवेहसाठी शब्बाथ पाळावा. ");
INSERT INTO marc_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","सहा वर्षे तुम्ही आपल्या शेतात पेरणी करावी, द्राक्षमळ्यांची छाटणी करावी आणि त्यांचे पीक जमा करावे. ");
INSERT INTO marc_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","पण सातव्या वर्षी जमिनीला शब्बाथ विश्रांती राहील; जो याहवेहसाठी शब्बाथ आहे. तुम्ही तुमच्या शेतात बी पेरू नका आणि तुमच्या द्राक्षमळ्यांची छाटणी करू नका. ");
INSERT INTO marc_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","आपोआप उगविलेल्या पिकांची कापणी करू नये किंवा छाटणी न झालेल्या द्राक्षवेलीची द्राक्षे गोळा करू नये. कारण जमिनीला हे विश्रांतीचे वर्ष राहील. ");
INSERT INTO marc_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","त्या शब्बाथाच्या वर्षी जमीन जे काही पीक येईल ते सर्वांना म्हणजेच तुम्ही, तुमचे नोकरचाकर, तुमच्याकडे असलेले गुलाम आणि तुमच्यात राहणारा कोणीही परदेशीय यांना खाण्याची मोकळीक आहे. ");
INSERT INTO marc_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","तसेच जनावरे, वनपशू या दोघांनाही तिथे चरावयाची मोकळीक आहे. ");
INSERT INTO marc_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘तुम्ही सात शब्बाथ वर्षे मोजावे; म्हणजेच सात वेळा सात वर्षे; म्हणजे सात शब्बाथ वर्षांचा काळ एकोणपन्नास वर्षे होईल. ");
INSERT INTO marc_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","मग सातव्या महिन्याच्या दहाव्या दिवशी म्हणजे प्रायश्चित्ताच्या दिवशी तुम्ही सर्वत्र कर्णे फुंकावे. प्रायश्चित्ताच्या दिवशी संपूर्ण देशात तुम्ही मोठ्या आवाजाचे कर्णे दीर्घकाल वाजवावे. ");
INSERT INTO marc_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","पन्नासावे वर्ष पवित्र मानावे आणि संपूर्ण देशातील सर्व लोकांना मुक्ततेची घोषणा करावी. तुमच्यासाठी हा महोत्सव असेल; तुमच्यातील प्रत्येकाने तुमच्या कौटुंबिक मालमत्तेकडे आणि तुमच्या स्वतःच्या कुळाकडे परत जावे. ");
INSERT INTO marc_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","पन्नासावे वर्ष हे योबेल वर्ष असेल; आपोआप उगविलेल्या पिकांची कापणी करू नये किंवा छाटणी न झालेल्या द्राक्षवेलीची द्राक्षे गोळा करू नये. ");
INSERT INTO marc_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","कारण हे योबेल वर्ष असेल आणि हे तुमच्याकरिता पवित्र असेल; शेतात आपोआप उगविलेले पीक तुम्ही खावे. ");
INSERT INTO marc_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘या योबेल वर्षी तुम्ही सर्वांनी आपल्या स्वतःच्या वतनात परत जावे. ");
INSERT INTO marc_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘यासाठी की तुम्ही जेव्हा आपल्या लोकांना जमीन विकाल किंवा त्याच्याकडून विकत घ्याल, तेव्हा तुमच्याकडून अन्यायाचा व्यवहार होऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","योबेल वर्षानंतरच्या वर्षांच्या संख्येच्या आधारावर तुम्ही तुमच्या लोकांकडून विकत घ्यावयाची आणि पीक कापणीसाठी किती वर्षे शिल्लक आहेत या आधारावर त्याची तुम्हाला विक्री करावयाची आहे. ");
INSERT INTO marc_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","जर वर्षे अनेक असतील तर जमिनीची किंमत त्या मानाने जास्त असेल, परंतु ही वर्षे थोडी असल्यास तिची किंमत त्या मानाने कमी असेल; कारण खरोखर विक्री जमिनीची होत नाही, तर ती जमीन किती वेळा पिके देऊ शकेल यावर तिची किंमत अवलंबून राहील. ");
INSERT INTO marc_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","एकमेकांचा गैरफायदा घेऊ नका, तर तुमच्या परमेश्वराचे भय बाळगा. मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘माझ्या आज्ञांचे पालन करा आणि माझे विधीचे पालन करण्याची काळजी घ्या, म्हणजे तुम्ही देशात सुरक्षितपणे राहाल. ");
INSERT INTO marc_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","भूमी भरपूर पीक देईल आणि तुम्ही भरपूर खाल आणि सुरक्षित राहाल. ");
INSERT INTO marc_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","तुम्ही असे विचाराल, “जर आम्ही झाडे लावली नाही किंवा आमच्या पिकांची कापणी केली नाही, तर आम्ही सातव्या वर्षी काय खावे?” ");
INSERT INTO marc_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","मी तुम्हाला असे आशीर्वादित करेन की जमीन सहाव्या वर्षी तीन वर्षापर्यंत पर्याप्‍त असे पीक देईल. ");
INSERT INTO marc_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","आठव्या वर्षी जेव्हा तुम्ही बी पेराल, तेव्हा तुम्ही मागच्या वर्षात गोळा केलेले पीक खात राहाल आणि नवव्या वर्षाचे पीक येईपर्यंत तुम्ही ते खाऊ शकाल. ");
INSERT INTO marc_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘तुम्ही जमीन कायमचीच विकू नये. कारण जमीन माझी आहे आणि तुम्ही माझ्या भूमीवर परदेशी आणि परके म्हणून राहत आहात. ");
INSERT INTO marc_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","तुमच्या ताब्यात असलेली संपूर्ण जमीन, तुम्ही त्या जमिनीला सोडविण्याची तरतूद केली पाहिजे. ");
INSERT INTO marc_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘तुमचा इस्राएली सहकारी गरीब झाला आणि त्याने त्यांची काही मालमत्ता विकली, तर त्यांच्या जवळच्या नातलगाने ती खंडणी भरून सोडवून घ्यावी. ");
INSERT INTO marc_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","जर सोडवून घेणारा त्याला कोणी नातलग नसला आणि त्याला स्वतःलाच ती खंडणी भरून सोडवून घेण्याची ऐपत वाढली, ");
INSERT INTO marc_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","तर योबेल वर्षापर्यंत जमीन आणखी किती वर्षे पीक देऊ शकेल हे पाहून त्या प्रमाणात तिची किंमत भरावी. जमिनीच्या सध्याच्या मालकाने तितके पैसे घेऊन तिच्या मूळ मालकाला ती परत करावी. ");
INSERT INTO marc_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","पण मूळ मालक ती सोडवून घ्यावयाला समर्थ नसेल तर योबेल वर्षापर्यंत ती हल्लीच्या मालकाकडेच रहावी. पण योबेल वर्षी ती मूळ मालकाला परत केलीच पाहिजे. ");
INSERT INTO marc_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘एखाद्याने तटबंदीच्या शहरातील आपले घर विकले असेल, तर त्याला एक वर्षाच्या काळात खंडणी भरून ते परत सोडवून घेता येईल. ते सोडविण्याचा हक्क त्याला पूर्ण एक वर्ष राहील. ");
INSERT INTO marc_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","नगर तटबंदीच्या आत असलेले घर जर त्याने ते एक वर्षाच्या आत खंडणी भरून सोडवून घेतले नाही, तर ते नव्या मालकाच्या कायमचेच मालकीचे होईल. योबेल वर्षीही ते त्याच्या मूळ मालकाला परत करावे लागणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","पण गावातील घर म्हणजे ज्या वस्तीला तटबंदी नाही अशा मोकळ्या वस्तीत असलेले घर मात्र केव्हाही खंडणी भरून सोडविता येईल आणि योबेल वर्षी ते घर मालकाला परत केलेच पाहिजे. ");
INSERT INTO marc_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘लेवी वंशातील मनुष्याचे घर तटबंदी असलेल्या शहरात असले तरी ते त्याला केव्हाही खंडणी भरून सोडवून घेता येईल. ");
INSERT INTO marc_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","म्हणून लेव्यांच्या मालकीचे जे काही आहे ते सोडविता येईल, आणि शहरातील त्यांच्या मालमत्तेतून विकले गेलेले घर योबेल वर्षात सोडविले जाईल, कारण लेवींच्या नगरातील घरेही इस्राएलच्या घराण्यात त्यांची मालमत्ता आहे. ");
INSERT INTO marc_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","लेव्यांना त्यांच्या शहराभोवती असलेली कुरणे विकण्यास परवानगी नाही, कारण ती त्यांची कायमचीच मालमत्ता आहे. ");
INSERT INTO marc_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘जर तुमच्या कोणी इस्राएल बंधूला दारिद्र्य आले आणि ते तुमच्यामध्ये स्वतःचे पालनपोषण करू शकत नसतील, तर जसे तुम्ही परदेशी आणि परक्यांना मदत कराल तशी त्यांना करा, जेणेकरून ते तुमच्यामध्ये राहतील. ");
INSERT INTO marc_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","परमेश्वराची भीती बाळगावी आणि तुमच्या बंधूला तुमच्या घरात राहू द्यावे. त्याला उसने म्हणून दिलेल्या पैशावर तुम्ही व्याज घेऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तुम्ही त्यांना व्याजाने पैसे देऊ नयेत किंवा जे खाद्यपदार्थ तुम्ही त्यांना विकाल त्यावर नफा घेऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ज्याने तुम्हाला कनान देश देण्यासाठी आणि तुमचा परमेश्वर होण्यासाठी इजिप्त देशातून बाहेर आणले, तो मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘जर तुमच्यापैकी कोणी इस्राएली गरीब झाला असेल आणि त्याने स्वतःला तुम्हाला विकले असेल, तर तुम्ही त्यांना गुलामासारखे कामे करावयास लावू नये. ");
INSERT INTO marc_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","तर रोजदारीवर ठेवलेल्या नोकराप्रमाणे किंवा तुमच्या आश्रिताप्रमाणे तुम्ही त्याला वागणूक द्यावी आणि योबेल वर्षापर्यंत तो तुमची सेवा करेल. ");
INSERT INTO marc_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","त्यानंतर त्यांना आणि त्यांच्या मुलाबाळांना सोडण्यात येईल आणि ते आपल्या कुटुंबातील पूर्वजांच्या वतनात परत जाऊ शकतील. ");
INSERT INTO marc_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","कारण इस्राएली तर माझे सेवक आहेत, मी त्याला इजिप्त देशातून बाहेर आणले आहे. म्हणून त्याची सर्वसाधारण गुलामाप्रमाणे विक्री केली जाऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","त्यांना जुलमाने वागविले जाऊ नये, परंतु तुमच्या परमेश्वराचे भय बाळगावे. ");
INSERT INTO marc_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘तुमचे पुरुष आणि स्त्री गुलाम तुमच्या सभोवतालच्या राष्ट्रांमधून यावेत; तुम्ही त्यांच्याकडून गुलाम विकत घेऊ शकता. ");
INSERT INTO marc_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","तुम्ही तुमच्यामध्ये राहणारे काही तात्पुरते रहिवासी आणि तुमच्या देशात जन्मलेल्या त्यांच्या कुळातील सदस्यांना देखील विकत घेऊ शकता आणि ते तुमची मालमत्ता बनतील. ");
INSERT INTO marc_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुम्ही ते तुमच्या मुलांना वारसाहक्कात देऊ शकता आणि त्यांना आयुष्यभर गुलाम बनवू शकता, पण तुमच्या इस्राएली बांधवांना अशा प्रकारची कठोर वागणूक तुम्ही देऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘तुमच्यात राहणारा एखादा परदेशी श्रीमंत झाला व इस्राएली वंशातील कोणी आपल्या दारिद्र्यामुळे स्वतःला त्या परदेश्याला वा परदेशी कुटुंबाला विकून टाकले, ");
INSERT INTO marc_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","तर त्याची विक्री झाल्यावरही त्याच्या घराण्यापैकी कोणालाहीः ");
INSERT INTO marc_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","त्याचा चुलता, पुतण्या किंवा त्याच्या जवळचा कोणीही खंडणी भरून त्याला सोडवून घेऊ शकेल, त्याला स्वतःलाच पैसा मिळाला तर खंडणी भरून तो स्वतःची सुटका करून घेऊ शकेल. ");
INSERT INTO marc_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","त्याने स्वतःला विकले त्या वर्षापासून योबेल वर्षापर्यंत जितकी वर्षे राहिली असतील तितकी मोजून याकाळात एका मजुराला जितकी मजुरी द्यावी लागेल तितका पैसा भरून त्याची सुटका करावी. ");
INSERT INTO marc_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","जर त्याला पुष्कळ वर्षे लागत असतील, तर त्यांनी त्यांच्या सुटकेसाठी दिलेल्या किमतीचा मोठा भाग त्यांच्यासाठी द्यावा. ");
INSERT INTO marc_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","जर योबेल वर्षाला थोडीच वर्षे राहिली असतील तर त्यांनी हिशोब करावा आणि त्यांच्या सुटकेसाठी नियमाप्रमाणे किंमत द्यावी. ");
INSERT INTO marc_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","तो दरवर्षी मजुराच्या हिशोबाप्रमाणे त्याच्याबरोबर वागणूक करेल आणि ज्यांच्याकडून सेवा करून घेतात त्यांना कठोर वागणूक देऊ नये. ");
INSERT INTO marc_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘योबेल वर्षापर्यंतही तो मुक्त झाला नसेल, तर तो व त्याची मुलेबाळे योबेल वर्षी मुक्त होतील, ");
INSERT INTO marc_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","कारण इस्राएली लोक माझेच सेवक आहेत; मीच त्यांना इजिप्त देशातून बाहेर आणले; मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘तुम्ही आपणासाठी घडीव मूर्ती किंवा कोरीव मूर्ती किंवा मूर्तिस्तंभ यांची स्थापना करू नये, अथवा आपल्या देशात नतमस्तक होण्यासाठी कोरीव दगड ठेवू नये. मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘तुम्ही माझे शब्बाथ पाळावे आणि माझ्या पवित्र स्थानाविषयी आदर बाळगावा, मी याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘माझ्या विधीनुसार तुम्ही चालाल आणि काळजीपूर्वक माझ्या आज्ञा पाळाल, ");
INSERT INTO marc_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","तर मी हंगामात तुमच्यासाठी पाऊस पाठवेन आणि जमीन पीक देईल आणि झाडे फळ देतील. ");
INSERT INTO marc_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","द्राक्षमळ्याची कापणी होईपर्यंत तुझी मळणी सुरूच राहील आणि द्राक्षांची कापणी पेरणी होईपर्यंत चालू राहील आणि पोटभर अन्न खाऊन तुम्ही तृप्त व्हाल आणि देशात सुरक्षित राहाल. ");
INSERT INTO marc_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘मी तुम्हाला शांती देईन म्हणजे तुम्ही निर्धास्तपणे झोप घ्याल. उपद्रव देणारे पशू मी हाकलून देईन आणि तुमच्या देशावर तलवार चालणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","तुम्ही तुमच्या शत्रूंचा पाठलाग कराल आणि तुमच्यासमोर ते तलवारीने पडतील. ");
INSERT INTO marc_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुम्हातील पाचजण शंभरांचा व शंभर दहा हजारांचा पाठलाग करून सर्व शत्रूंचा पराजय करतील आणि तुमचे शत्रू तलवारीने तुमच्यासमोर पडतील. ");
INSERT INTO marc_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘मी तुमच्यावर कृपादृष्टी करेन, तुम्हाला बहुगुणित करेन व तुमच्याशी केलेला माझा करार दृढ करेन. ");
INSERT INTO marc_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","तुम्ही अजूनही मागील कापणी खात राहाल, तुमच्या शेतात इतके भरपूर पीक येईल की, ते साठविण्यासाठी तुम्हाला जुने धान्य बाहेर काढावे लागेल. ");
INSERT INTO marc_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","मी तुमच्यामध्ये वस्ती करेन व मला तुमचा तिटकारा वाटणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","मी तुमच्यामध्ये चालेन; मी तुमचा परमेश्वर होईन व तुम्ही माझे लोक व्हाल. ");
INSERT INTO marc_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","इजिप्तच्या लोकांचे तुम्ही गुलाम राहू नये म्हणून ज्याने तुम्हाला इजिप्त देशामधून बाहेर आणले; तो मी याहवेह तुमचा परमेश्वर आहे. मी तुमच्या बेड्या तोडून टाकल्या आणि तुम्ही ताठ मानेने चालाल असे मी केले आहे. ");
INSERT INTO marc_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘पण तुम्ही माझे ऐकले नाही आणि या सर्व आज्ञा पाळल्या नाही, ");
INSERT INTO marc_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","आणि माझे विधी तुम्ही स्वीकारले नाही आणि माझे नियम तुच्छ लेखून माझ्या आज्ञा पाळण्यात कसूर केली आणि माझ्या कराराचा भंग केला, ");
INSERT INTO marc_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","तर मी तुमच्यासोबत हे करेन: तुम्हाला एकाएकी भयंकर भीतीने ग्रासून टाकेन, तुम्हाला क्षयरोग होईल व असे भयंकर ज्वर तुम्हाला पछाडतील की त्यामुळे तुमचे नेत्र अंधुक होतील आणि तुमची शक्ती कोमेजून जाईल. तुम्ही केलेली धान्याची पेरणी व्यर्थ जाईल, कारण तुमचे पीक तुमचे शत्रू खाऊन टाकतील. ");
INSERT INTO marc_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","मी तुम्हापासून आपले मुख फिरवेन आणि तुमच्या शत्रूंपुढे तुमचा पराभव होईल. ज्यांचा तुम्ही द्वेष करता तेच तुमच्यावर सत्ता गाजवतील आणि कोणी पाठलाग करीत नसतानाही तुम्ही पळाल. ");
INSERT INTO marc_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘इतके झाल्यानंतरही तुम्ही माझे ऐकले नाही, तर तुमच्या पापांबद्दल मी तुम्हाला सातपट शिक्षा करेन. ");
INSERT INTO marc_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","मी तुमच्या सामर्थ्याचा गर्व नाहीसा करेन आणि तुमचे आकाश लोखंडासारखे व पृथ्वी कास्यासारखी करून टाकेन. ");
INSERT INTO marc_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तुमची मेहनत व्यर्थ गोष्टींमुळे नाश पावेल, कारण तुमची जमीन पिके देणार नाही व तुझ्या देशातील झाडांना फळे येणार नाहीत. ");
INSERT INTO marc_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘इतके झाल्यानंतरही तुम्ही माझ्याविरुद्ध वागाल व माझे ऐकले नाही, तर मी तुमच्या पापांच्या मानाने तुमच्यावर सातपट पीडा आणेन. ");
INSERT INTO marc_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","मी तुमच्यावर जंगली श्वापदे पाठवेन आणि ती तुमच्या लेकरांना उचलून नेतील, गुरांचा नायनाट करतील आणि तुमची संख्या कमी करतील; आणि त्यामुळे तुमचे रस्ते ओसाड होतील. ");
INSERT INTO marc_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘एवढे करून सुद्धा तुमच्यात सुधारणा झाली नाही आणि माझ्याविरुद्ध तुम्ही वागत राहिलात, ");
INSERT INTO marc_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","तर मी तुमच्याविरुद्ध होईन आणि तुमच्या पापाबद्दल सात वेळा तुम्हाला ताडण करेन. ");
INSERT INTO marc_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","माझा करार मोडल्याबद्दल तुमच्यावर तलवार आणेन. तुम्ही आपआपल्या शहरांत एकत्र व्हाल, तेव्हा तिथे मी तुमच्यामध्ये प्राणघातक रोग पाठवेन आणि तुम्हाला तुमच्या शत्रूच्या हाती देण्यात येईल. ");
INSERT INTO marc_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","मी तुमच्या भाकरीचा पुरवठा बंद करेन, तेव्हा दहा स्त्रिया एकाच चुलीवर भाकर भाजू शकतील आणि त्या भाकरीचे वजन करून देतील. तुम्ही खाल परंतु तृप्त होणार नाहीत. ");
INSERT INTO marc_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘एवढे सर्व करूनही तुम्ही माझे ऐकणार नाही आणि माझ्याविरुद्ध वागाल, ");
INSERT INTO marc_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","तर मी क्रोधायमान होऊन तुमच्याविरुद्ध चालेन आणि तुमच्या पातकांबद्दल तुम्हाला सातपट शिक्षा करेन. ");
INSERT INTO marc_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तुम्ही तुमच्या पुत्रांचे व तुमच्या कन्यांचे मांस खाल. ");
INSERT INTO marc_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","तुमच्या उच्च स्थानांचा मी नाश करेन; तुमच्या धूपवेद्या मी मोडून टाकीन; तुमची प्रेते कुजण्यासाठी मी ती मूर्तीच्या समवेतच राहू देईन आणि मी तुमचा तिरस्कार करेन. ");
INSERT INTO marc_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","तसेच मी तुमची शहरे उजाड करेन, तुमची पवित्रस्थाने ओसाड करेन आणि तुमच्या सुगंधी द्रव्यांचा सुवास घेणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","मी देश ओसाड करेन, म्हणजे तुमचे शत्रू जे त्यात राहतील ते त्यामुळे गांगरून जातील. ");
INSERT INTO marc_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","मी तुमची राष्ट्रांमध्ये पांगापांग करेन आणि मी माझी तलवार उगारून तुमच्या पाठीस लागेन. तुमचा देश उजाड होईल आणि तुमच्या शहरांचा नाश होईल. ");
INSERT INTO marc_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","जेव्हा तुम्ही शत्रूंच्या देशात असाल, तुमचा देश उजाड होईल; तेव्हा भूमीला विश्रांती मिळेल व भूमी तिच्या शब्बाथ वर्षांचा संपूर्ण वेळ आनंद करेल. ");
INSERT INTO marc_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","अनेक वर्षे ती उजाड होती, तुम्ही तिथे राहत असताना शब्बाथाच्या काळामध्ये तिला विश्रांती मिळाली नाही म्हणून ती आता विश्रांती घेईल. ");
INSERT INTO marc_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘तुमच्यातील जे उर्वरित राहतील, त्यांच्या शत्रूंच्या देशात मी त्यांची अंतःकरणे इतकी भयभीत करेन, की वार्‍याने उडून जाणार्‍या पानांचा आवाजसुद्धा त्यांना असा पळ काढावयास लावील की जणू एखादा तलवार घेऊन त्यांच्या पाठीशी लागला आहे आणि कोणीही त्यांचा पाठलाग करत नसले तरी ते पडतील. ");
INSERT INTO marc_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","कोणी पाठलाग करीत नसतानाही तलवार पाठीस लागल्याप्रमाणे अडखळून एकमेकांवर पडतील. त्यामुळे तुम्ही तुमच्या शत्रूंसमोर उभे राहू शकणार नाही. ");
INSERT INTO marc_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तुम्ही राष्ट्रांत पांगून नाश पावाल; तुमच्या शत्रूंचा देश तुम्हाला गिळून टाकील. ");
INSERT INTO marc_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","तुमच्यापैकी जे शिल्लक राहतील ते तुमच्या शत्रूंच्या देशात त्यांच्या पापांमुळे नष्ट होतील; आणि ते त्यांच्या पूर्वजांच्या पापांमुळे नष्ट होतील. ");
INSERT INTO marc_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘परंतु जर ते आपल्या पापांची व आपल्या वाडवडिलांच्या पापांची—त्यांच्या अविश्वासूपणाची आणि माझ्याविरुद्ध चालण्याची कबुली देतील, ");
INSERT INTO marc_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ज्यामुळे मी त्यांचा शत्रू झालो व त्यांना शत्रूच्या भूमीत घेऊन गेलो—नंतर जेव्हा त्यांची सुंता न झालेली हट्टी अंतःकरणे नम्र होतील आणि त्यांच्या पापाची शिक्षा ते भोगतील, ");
INSERT INTO marc_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","तेव्हा मी अब्राहाम, इसहाक व याकोब यांच्याबरोबर केलेल्या कराराचे स्मरण करेन आणि त्या भूमीचे स्मरण करेन. ");
INSERT INTO marc_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","कारण ती भूमी ओसाड पडल्यामुळेच शब्बाथांचा आनंद उपभोगू शकत आहे. ते त्यांच्या पापांची परतफेड करतील कारण त्यांनी माझे नियम नाकारले आणि माझ्या विधींचा तिरस्कार केला. ");
INSERT INTO marc_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","त्यांनी इतके केले असतानाही जेव्हा ते शत्रूंच्या देशात असतील, मी त्यांचा नकार करणार नाही किंवा नाश करणार नाही किंवा त्यांच्याशी केलेला करार मोडणार नाही. कारण मी याहवेह त्यांचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","परंतु त्यांचा परमेश्वर होण्याचा, त्यांच्या पूर्वजांबरोबर केलेला करार मी आठवेन. सर्व राष्ट्रे पाहत असताना मी त्यांच्या वाडवडिलांना इजिप्त देशाबाहेर घेऊन आलो होतो. मी याहवेह आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","हे ते नियम, विधी व सूचना आहेत, ज्या याहवेहने आपल्यात व इस्राएली लोकांमध्ये मोशेद्वारे सीनाय पर्वतावर स्थापित केल्या. ");
INSERT INTO marc_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएली लोकांबरोबर बोल आणि त्यांना सांग: ‘जेव्हा एखादा मनुष्य याहवेहला समर्पणाचे विशेष नवस करेल, तेव्हा त्या व्यक्तीचे मूल्य पुढीलप्रमाणे ठरवावे. ");
INSERT INTO marc_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","वीस ते साठ वर्षे वयाच्या पुरुषाचे मूल्य पवित्रस्थानाच्या वजनानुसार चांदीचे पन्नास शेकेल असावे, ");
INSERT INTO marc_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","स्त्रीसाठी तिचे मूल्य चांदीचे तीस शेकेल असावे; ");
INSERT INTO marc_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","पाच ते वीस वर्षे वयोगटातील व्यक्तीसाठी, पुरुषाचे मूल्य वीस शेकेल असावे आणि स्त्रीसाठी दहा शेकेल असावे; ");
INSERT INTO marc_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","एक महिना ते पाच वर्षे वयाच्या पुरुषाला चांदीचे पाच शेकेल आणि स्त्रीसाठी चांदीचे तीन शेकेल असावे; ");
INSERT INTO marc_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","साठ वर्ष आणि अधिक वर्षाच्या पुरुषाचे मूल्य चांदीचे पंधरा शेकेल असावे आणि स्त्रीसाठी दहा चांदीचे शेकेल असावे. ");
INSERT INTO marc_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","फारच गरिबीमुळे नवस फेडण्यासाठी मनुष्याला इतके शेकेल भरणे शक्य नसेल, तर ज्याचे समर्पण होत आहे त्याला याजकापुढे उभे करावे. मग नवस फेडण्यासाठी याजक ठरवेल तितके शेकेल त्याने द्यावे. ");
INSERT INTO marc_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘जर त्याने एखादा पशू याहवेहला अर्पण करण्याचा नवस केला असेल, तर हे अर्पण याहवेहला पवित्र असे होईल. ");
INSERT INTO marc_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","त्यांनी त्याची अदलाबदल करू नये किंवा वाईटाच्या बदल्यात चांगला किंवा चांगल्याच्या बदल्यात वाईट असे करू नये; जर ते एका पशूबद्दल दुसरा पशू अशी अदलाबदल करतील, तर दोन्ही पशू आणि बदललेला पशू पवित्र होतील. ");
INSERT INTO marc_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","जर नवस दिलेला पशू विधिनियमानुसार अशुद्ध असेल—जे याहवेहला अर्पण करण्यास योग्य नाही—तर त्या पशूला याजकाकडे घेऊन यावे. ");
INSERT INTO marc_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","तो त्याचा दर्जा चांगला किंवा वाईट हे ठरवेल. मग याजक त्याचे जे काही मूल्य ठरवेल, तेवढेच त्याचे मूल्य असेल. ");
INSERT INTO marc_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","परंतु जर त्या मालकाला तो पशू सोडवून घ्यावयाचा असेल, तर त्याच्या किमतीचा पाचवा भाग अधिक द्यावा. ");
INSERT INTO marc_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","15","“ ‘जर एखाद्याने याहवेहला आपले घर पवित्र म्हणून समर्पित केले आणि नंतर त्याची इच्छा असेल की, ते सोडवून घ्यावे, तर याजक त्या घराची चांगलीवाईट स्थिती पाहून त्याचे मूल्य ठरवेल, आणि घरमालक याजकाने ठरविलेली किंमत अधिक वीस टक्के भरून ते घर आपल्या ताब्यात घेईल. ");
INSERT INTO marc_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘जर कोणी त्यांच्या वतनाच्या शेताचा काही भाग याहवेहला समर्पित करीत असतील तर त्या शेतामध्ये किती बी पेरले जाऊ शकेल त्याप्रमाणे त्या शेताची किंमत ठरविली जाईल, एक होमेर जव पेरता येईल तेवढ्या भागाचे मूल्य चांदीचे पन्नास शेकेल होतील. ");
INSERT INTO marc_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","जर योबेल वर्षापासून त्याने आपले शेत समर्पित केले तर त्याची ठरविलेली किंमत तितकीच राहील. ");
INSERT INTO marc_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","तरी, त्याने योबेल वर्षानंतर जर आपले शेत अर्पण केले असेल, तर दुसर्‍या योबेल वर्षाला जितकी वर्षे असतील त्या मानाने याजकाने त्या शेताचे मोल कमी करून मूल्य ठरवावे. ");
INSERT INTO marc_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","जर शेत समर्पित करणार्‍याला ते सोडवून घ्यावयाचे असेल तर त्यांनी त्याच्या मूल्यात पाचवा भाग जोडला पाहिजे आणि ते शेत पुन्हा त्यांचे होईल. ");
INSERT INTO marc_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","तथापि, जर त्यांनी ते शेत परत सोडवून न घेता, किंवा त्यांनी ते इतर कोणाला विकले असेल, तर ते कधीही सोडविले जाऊ शकत नाही. ");
INSERT INTO marc_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","जर ते शेत योबेल वर्षी सोडविले जाते तर ते याहवेहसाठी समर्पित पवित्र शेत मानले जाईल; ते याजकाचे वतन होईल. ");
INSERT INTO marc_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘एखाद्याने स्वतःचे वतन नसलेले, पण दुसर्‍याकडून विकत घेतलेले शेत याहवेहला समर्पित केले, जी त्याच्या कुटुंबाची संपत्ती नसेल, ");
INSERT INTO marc_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","तर याजक योबेल वर्षापर्यंतची त्या शेताची किंमत ठरवेल, आणि त्याने त्याच दिवशी याजकाने ठरविलेले मूल्य याहवेहसाठी पवित्र समजून द्यावे. ");
INSERT INTO marc_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","योबेल वर्षी, ज्याच्याकडून शेत विकत घेतले आहे त्या व्यक्तीकडे, म्हणजेच त्या शेताचे खरे वतन असलेल्या व्यक्तीच्या ताब्यात परत जावे. ");
INSERT INTO marc_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","तुम्ही विकता त्या प्रत्येकाचे मूल्य पवित्रस्थानाच्या शेकेलनुसार असावे आणि एक शेकेल म्हणजे वीस गेरा. ");
INSERT INTO marc_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘तथापि, कोणीही प्राण्याचे प्रथम जन्मलेले समर्पित करू शकत नाही, कारण प्रथम जन्मलेले मुळातच याहवेहचे आहेत; बैल असो वा मेंढरे, ते याहवेहचेच आहे. ");
INSERT INTO marc_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","जर ते अशुद्ध पशूंपैकी असेल, तर त्याची ठरवून दिलेले मूल्य द्यावे व त्या शिवाय ठरविलेल्या किमतीचा पाचवा भाग अधिक किंमत भरावी. जर तो पशू सोडवून घेतला जात नसेल, तर तो त्याच्या ठरविलेल्या किमतीत विकता येईल. ");
INSERT INTO marc_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘एखादा मनुष्य आपल्याजवळ असलेले काहीही याहवेहला समर्पित करेल—मग ते एखादी व्यक्ती असो, पशू असो वा वतनाची जमीन असो—ते विकू नये किंवा खंडणी भरून सोडवूनही घेऊ नये; कारण समर्पित ते सर्व याहवेहसाठी परमपवित्र आहे. ");
INSERT INTO marc_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘मरणदंडाची शिक्षा झालेल्या मनुष्याला खंडणी भरून सोडविता येणार नाही. त्याचा अवश्य वध करावा. ");
INSERT INTO marc_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘भूमीचा दशांश, मग ते शेतातील उत्पादन असो किंवा झाडांची फळे, याहवेहचे आहेत; ते याहवेहसाठी पवित्र आहेत. ");
INSERT INTO marc_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ज्या कोणाला त्यांचा कोणताही दशांश भाग सोडावयाचा असेल त्यांनी त्या वस्तूंच्या किमतीचा पाचवा भाग अधिक रक्कम भरावी. ");
INSERT INTO marc_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","गुरे आणि शेरडेमेंढरांचा प्रत्येक दशांश—मेंढपाळाच्या काठीखालून जाणारा प्रत्येक दहावा प्राणी—याहवेहसाठी पवित्र असेल. ");
INSERT INTO marc_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","कोणीही वाईटामधून चांगल्याची निवड करू नये किंवा अदलाबदल करू नये; तशी अदलाबदल केल्यास दोन्हीही प्राणी आणि बदली केलेला पवित्र होतील आणि त्यांना खंडणी भरून सोडवू शकणार नाहीत.’ ” ");
INSERT INTO marc_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","या आज्ञा सीनाय पर्वतावर याहवेहने इस्राएली लोकांसाठी मोशेला दिल्या.");
INSERT INTO marc_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","इस्राएली लोक इजिप्तमधून बाहेर आल्यावर, दुसर्‍या वर्षाच्या दुसर्‍या महिन्याच्या पहिल्या दिवशी सीनाय रानात सभामंडपामध्ये याहवेह मोशेशी बोलले. ते म्हणाले: ");
INSERT INTO marc_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“संपूर्ण इस्राएली समुदायाची त्यांचे कूळ आणि कुटुंब यानुसार, प्रत्येक पुरुषाच्या नावाने एकएक करून जनगणना करा. ");
INSERT INTO marc_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","तू आणि अहरोनाने त्यांच्या विभागानुसार जे वीस वर्षे किंवा त्याहून अधिक वयाच्या आणि सैन्यात सेवा करण्यास सक्षम असलेल्या सर्व इस्राएली पुरुषांची गणना करावी. ");
INSERT INTO marc_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","प्रत्येक कुळा मधून जो मनुष्य कुटुंबप्रमुख आहे त्याने तुला मदत करावी. ");
INSERT INTO marc_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“तुम्हाला मदत करणार्‍या पुरुषांची नावे ही आहेत: “रऊबेन वंशातील शदेयुराचा पुत्र एलीसूर; ");
INSERT INTO marc_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शिमओन वंशातील, सुरीशादैचा पुत्र शेलुमीएल; ");
INSERT INTO marc_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदाह वंशातील अम्मीनादाबाचा पुत्र नहशोन; ");
INSERT INTO marc_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्साखार वंशातील सूवाराचा पुत्र नथानेल; ");
INSERT INTO marc_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जबुलून वंशातील हेलोनाचा पुत्र एलियाब; ");
INSERT INTO marc_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","योसेफाचे पुत्र: एफ्राईम वंशातील अम्मीहूदाचा पुत्र एलीशामा; मनश्शेह वंशातील पदहसूरचा पुत्र गमलीएल; ");
INSERT INTO marc_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बिन्यामीन वंशातील गिदोनाचा पुत्र अबीदान; ");
INSERT INTO marc_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान वंशातील अम्मीशद्दायचा पुत्र अहीएजर; ");
INSERT INTO marc_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेर वंशातील आक्रानाचा पुत्र पगीयेल; ");
INSERT INTO marc_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गाद वंशातील देउएलाचा पुत्र एलीआसाफ; ");
INSERT INTO marc_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नफतालीचा वंशातील एनानाचा पुत्र अहीरा.” ");
INSERT INTO marc_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","हे सर्व वंशांतून निवडलेले पुरुष त्यांच्या पूर्वजांच्या वंशांचे सरदार आहेत. ते इस्राएली गोत्रप्रमुख होते. ");
INSERT INTO marc_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","मोशे आणि अहरोनाने नावे नमूद केलेल्यांना घेतले, ");
INSERT INTO marc_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","आणि दुसर्‍या महिन्याच्या पहिल्या दिवशी सर्व समुदायाला एकत्र बोलाविले. लोकांनी आपआपल्या पूर्वजांची नावे, आपले कूळ व घराणे यानुसार नोंदणी केली आणि वीस वर्षे किंवा त्याहून अधिक वयाच्या पुरुषांच्या नावांची एकामागून एक यादी केली. ");
INSERT INTO marc_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","याहवेहने मोशेला आज्ञा केल्याप्रमाणेच सीनायच्या रानात त्याने त्यांची गणती केली: ");
INSERT INTO marc_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","इस्राएलचा पहिला पुत्र रऊबेनच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे, सैन्यात सेवा करण्यास सक्षम असणाऱ्या सर्व पुरुषांची नावे, त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","रऊबेनाच्या गोत्रांची संख्या 46,500 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","शिमओनाच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष व जे सैन्यात सेवा करण्यास सक्षम होते अशांची नावे त्यांचे कूळ आणि कुटुंबानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","शिमओनाच्या गोत्रांची संख्या 59,300 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गादच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","गाद गोत्रांची संख्या 45,650 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदाहच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","यहूदाहच्या गोत्रांची संख्या 74,600 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्साखारच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इस्साखार गोत्रांची संख्या 54,400. ");
INSERT INTO marc_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","जबुलूनच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","जबुलून गोत्रांची संख्या 57,400. ");
INSERT INTO marc_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","योसेफाच्या पुत्रांमधून: एफ्राईमच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","एफ्राईमच्या गोत्रांची संख्या 40,500. ");
INSERT INTO marc_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","मनश्शेहच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मनश्शेहच्या गोत्रांची संख्या 32,200 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बिन्यामीनच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","बिन्यामीन गोत्रांची संख्या 35,400 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दानच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","दान गोत्रांची संख्या 62,700 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आशेरच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","आशेर गोत्रांची संख्या 41,500 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नफतालीच्या वंशजातून: वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांचे कूळ आणि कुटुंब यानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","नफताली गोत्रांची संख्या 53,400 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मोशे आणि अहरोन आणि इस्राएलच्या प्रत्येक घराण्याच्या बारा पुढार्‍यांनी मोजलेले पुरुष ते हेच. ");
INSERT INTO marc_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","सर्व इस्राएलातील वीस वर्षे किंवा त्याहून अधिक वयाचे सर्व पुरुष जे सैन्यात सेवा करण्यास सक्षम होते, अशांची नावे त्यांच्या कुटुंबानुसार नोंदण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","एकूण संख्या 6,03,550 होती. ");
INSERT INTO marc_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","परंतु लेवी पूर्वजांच्या गोत्रांची गणना मात्र इतरांबरोबर करण्यात आली नाही. ");
INSERT INTO marc_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","याहवेहने मोशेला सांगितले होते: ");
INSERT INTO marc_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“लेवी गोत्राची गणती करू नये किंवा इस्राएलच्या जनगणनेमध्ये त्यांचा समावेश करू नये. ");
INSERT INTO marc_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","परंतु कराराच्या नियमाचा निवासमंडप; त्यातील सामुग्री व त्यासंबंधाचे जे काही आहे त्यावर लेवींची प्रमुख म्हणून नेमणूक कर. त्यांनी निवासमंडप व त्यातील सामुग्री वाहून न्यावी; त्यांनी त्याची काळजी घ्यावी व त्याभोवती आपला डेरा उभारावा. ");
INSERT INTO marc_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ज्यावेळी निवासमंडप पुढे जायचा असेल, त्यावेळी लेव्यांनीच तो खाली काढावा आणि ज्यावेळी निवासमंडप उभारावयाचा असेल त्यावेळी लेव्यांनीच तो उभारावा. इतर कोणी निवासमंडपाच्या जवळ गेल्यास त्याला जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","इस्राएली लोकांनी आपआपल्या दलानुसार, प्रत्येकाने आपआपल्या छावणीत, आपआपल्या झेंड्याखाली आपले डेरे द्यावे. ");
INSERT INTO marc_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","परंतु लेव्यांनी आपले डेरे कराराच्या निवासमंडपाच्या सभोवती उभारावे, म्हणजे इस्राएली समुदायाविरुद्ध माझा क्रोध पेटणार नाही. लेव्यांनी कराराच्या नियमाच्या निवासमंडपाची जबाबदारी घेऊन त्याची काळजी घ्यावी.” ");
INSERT INTO marc_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","याहवेहने मोशेला जसे आज्ञापिले होते, त्याप्रमाणे इस्राएली लोकांनी सर्वकाही केले. ");
INSERT INTO marc_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","याहवेहने मोशे आणि अहरोनाला म्हटले: ");
INSERT INTO marc_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“इस्राएली लोकांनी सभामंडपाच्या सभोवती, त्यापासून थोडे अंतरावर आपआपले डेरे उभारावे, प्रत्येकाने ते आपआपल्या झेंड्याजवळ व आपल्या घराण्याच्या निशाणाजवळ ते उभारावे.” ");
INSERT INTO marc_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","पूर्वेकडे, सूर्योदयाच्या दिशेने: यहूदाहच्या छावणीच्या दलांनी त्यांच्या झेंड्याखाली आपला डेरा द्यावा. यहूदाहच्या लोकांचा पुढारी अम्मीनादाबाचा मुलगा नहशोन असावा. ");
INSERT INTO marc_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","त्यांच्या दलातील लोकांची संख्या 74,600 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","इस्साखारचे गोत्र त्यांच्या शेजारी डेरा देणार. इस्साखारच्या लोकांचा पुढारी सूवाराचा मुलगा नथानेल असावा. ");
INSERT INTO marc_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","त्यांच्या दलातील लोकांची संख्या 54,400 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","त्यानंतर जबुलूनचे गोत्र असणार. हेलोनचा पुत्र एलियाब हा जबुलूनच्या लोकांचा पुढारी आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","त्यांच्या दलातील लोकांची संख्या 57,400 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","यहूदाहच्या छावणीत नेमलेले सर्व पुरुष, त्यांच्या दलानुसार, संख्येने 1,86,400 होते. त्यांनी सर्वप्रथम निघावे. ");
INSERT INTO marc_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","दक्षिणेच्या बाजूस: रऊबेनच्या छावणीच्या दलाने त्यांच्या झेंड्याखाली आपला डेरा द्यावा असावा. रऊबेनच्या लोकांचा पुढारी शेदेऊरचा पुत्र एलीसूर आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","त्यांच्या दलातील लोकांची संख्या 46,500 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","शिमओनचे गोत्र त्यांच्या शेजारी डेरा देईल. शिमओनच्या लोकांचा पुढारी सुरीशादैचा पुत्र शेलुमीएल आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","त्यांच्या दलातील लोकांची संख्या 59,300 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","त्यानंतर गाद गोत्र असेल. गादच्या लोकांचा पुढारी रऊएलाचा पुत्र एलीआसाफ आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","त्यांच्या दलातील लोकांची संख्या 45,650 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","रऊबेनच्या छावणीत नेमलेले सर्व पुरुष, त्यांच्या दलानुसार संख्येने 1,51,450 होते. ते दुसर्‍या रांगेत निघतील. ");
INSERT INTO marc_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","मग सभामंडप व लेव्यांची छावणी सर्व छावण्यांच्या मध्यभागी असणार. ज्या क्रमाने ते डेरा देऊन राहतात त्याच क्रमाने, आपल्या झेंड्याखाली आपआपल्या जागेवर त्यांनी निघावे. ");
INSERT INTO marc_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","पश्चिमेच्या बाजूस: एफ्राईमच्या दलाने आपल्या झेंड्याखाली आपला डेरा द्यावा. एफ्राईमच्या लोकांचा पुढारी अम्मीहूदाचा पुत्र एलीशामा आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","त्यांच्या दलातील लोकांची संख्या 40,500 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","मनश्शेहचे गोत्र त्यांच्यानंतर असेल. मनश्शेहच्या लोकांचा पुढारी पदहसूरचा पुत्र गमलीएल आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","त्यांच्या दलातील लोकांची संख्या 32,200 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","त्यानंतर बिन्यामीनचे गोत्र असणार. बिन्यामीन लोकांचा पुढारी गिदयोनीचा पुत्र अबीदान आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","त्यांच्या दलातील लोकांची संख्या 35,400 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","एफ्राईमच्या छावणीत नेमलेले सर्व पुरुष, त्यांच्या दलानुसार संख्येने 1,08,100 होते. ते तिसर्‍या रांगेत निघतील. ");
INSERT INTO marc_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","उत्तरेच्या बाजूस: दानच्या दलाने आपल्या झेंड्याखाली त्यांचा डेरा द्यावा. दान लोकांचा पुढारी अम्मीशद्दायचा पुत्र अहीएजर आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","त्यांच्या दलातील लोकांची संख्या 62,700 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","आशेर गोत्र त्यांच्या शेजारी डेरा देईल. आशेर लोकांचा पुढारी ओक्रानचा पुत्र पगीयेल आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","त्यांच्या दलातील लोकांची संख्या 41,500 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","नफताली गोत्र त्यांच्या शेजारी असणार. नफताली लोकांचा पुढारी एनानाचा पुत्र अहीरा आहे. ");
INSERT INTO marc_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","त्यांच्या दलातील लोकांची संख्या 53,400 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","दानच्या छावणीत नेमलेले सर्व पुरुष, त्यांच्या दलानुसार संख्येने 1,57,600 होते. त्यांच्या झेंड्याखाली ते सर्वांच्या शेवटी निघतील. ");
INSERT INTO marc_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","आपआपल्या घराण्यानुसार मोजलेले इस्राएली लोक हे आहेत. छावणीतील सर्व पुरुषांची संख्या 6,03,550 होती. ");
INSERT INTO marc_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","याहवेहने मोशेला दिलेल्या आज्ञेप्रमाणे इतर इस्राएल लोकांबरोबर लेव्यांची मोजणी केली नव्हती. ");
INSERT INTO marc_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","अशा रीतीने याहवेहने मोशेला आज्ञापिल्याप्रमाणे इस्राएली लोकांनी प्रत्येक गोष्ट केली, ते असे की, आपआपल्या झेंड्याजवळ ते डेरे देत असत आणि आपले कूळ व घराणे यानुसार पुढे चालत असत. ");
INSERT INTO marc_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","सीनाय डोंगरावर याहवेह मोशेबरोबर बोलले, त्यावेळी अहरोन व मोशे यांची वंशावळी ही होती. ");
INSERT INTO marc_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","अहरोनाच्या पुत्रांची नावे: प्रथम जन्मलेला नादाब, मग अबीहू, एलअज़ार व इथामार. ");
INSERT INTO marc_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","अहरोनाच्या ज्या पुत्रांचा याजक म्हणून अभिषेक करण्यात आला आणि निवासमंडपात सेवा करण्यासाठी समर्पित करण्यात आले, त्यांची ही वरील नावे होती. ");
INSERT INTO marc_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","नादाब व अबीहूनी सीनायच्या रानात अनाधिकृत अग्नी वापरल्यामुळे ते याहवेहसमोर मरण पावले, त्यांना पुत्र नसल्यामुळे एलअज़ार व इथामारनी त्यांचे वडील अहरोनाच्या जीवनकाळात याजक म्हणून सेवा केली. ");
INSERT INTO marc_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवीच्या गोत्राने अहरोन याजकाला मदत करावी म्हणून तू त्यांना त्याच्यासमोर सादर कर. ");
INSERT INTO marc_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","त्यांनी सभामंडपात त्याच्यासाठी आणि संपूर्ण समुदायासाठी निवासमंडपाचे काम करून कर्तव्ये पार पाडावीत. ");
INSERT INTO marc_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","सभामंडपाच्या सर्व सामानाची त्यांनी काळजी घ्यावी, निवासमंडपाचे काम करून इस्राएली लोकांची कर्तव्ये पूर्ण करावी. ");
INSERT INTO marc_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","यास्तव लेव्यांना अहरोन आणि त्याच्या पुत्रांच्या हाती द्यावे; संपूर्ण इस्राएली लोकांमधून ते अहरोनाला पूर्णपणे देण्यात आलेले आहेत. ");
INSERT INTO marc_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","याजकाची सेवा करण्यासाठी अहरोन व त्याच्या पुत्रांची नेमणूक करावी. इतर दुसरे कोणी पवित्रस्थानाच्या जवळ आले, तर त्यास जिवे मारावे.” ");
INSERT INTO marc_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","आणि याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“इस्राएली लोकांतील प्रत्येक स्त्रीच्या पोटी प्रथम जन्मलेल्या पुत्रांच्या ऐवजी मी लेव्यांना घेतले आहे. लेवी लोक माझे आहेत, ");
INSERT INTO marc_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","कारण सर्व प्रथम जन्मलेले माझे आहेत. ज्या दिवशी इजिप्तमध्ये मी सर्व प्रथम जन्मलेले मारून टाकले, त्या दिवशी इस्राएलातील प्रत्येक प्रथम जन्मलेले मी माझ्यासाठी समर्पित करून घेतले, ते मनुष्य असो किंवा पशू, ते माझे आहेत, मीच याहवेह आहे.” ");
INSERT INTO marc_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","याहवेहने पुन्हा मोशेला सीनाय रानात सांगितले, ");
INSERT INTO marc_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“आता तू लेवींची त्यांच्या घराण्यानुसार व कुळानुसार गणती करावी. एक महिन्याच्या व त्यापेक्षा जास्त वयाच्या प्रत्येक पुरुषाची गणती करावी.” ");
INSERT INTO marc_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","याहवेहच्या आज्ञेनुसार मोशेने लेव्यांची गणती केली. ");
INSERT INTO marc_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लेवीच्या पुत्रांची नावे ही: गेर्षोन, कोहाथ आणि मरारी. ");
INSERT INTO marc_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","गेर्षोनाच्या कुळांची नावे ही होती: लिब्नी आणि शिमी. ");
INSERT INTO marc_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कोहाथाची कुळे: अम्राम, इसहार, हेब्रोन आणि उज्जीएल. ");
INSERT INTO marc_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मरारीची कुळे: महली आणि मूशी. ");
INSERT INTO marc_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","लिब्नी व शिमी ही कुळे गेर्षोनापासून होती; ही गेर्षोनी कुळे होती. ");
INSERT INTO marc_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","एक महिना किंवा त्याहून अधिक वयाच्या सर्व पुरुषांची संख्या 7,500 होती. ");
INSERT INTO marc_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेर्षोनी कुळांनी निवासमंडपाच्या मागे पश्चिमेकडे डेरा द्यावा. ");
INSERT INTO marc_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","गेर्षोनी घराण्याचा प्रमुख लाएलचा पुत्र एलीआसाफ होता. ");
INSERT INTO marc_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","सभामंडपात गेर्षोनी लोकांची जबाबदारी ही होती की, त्यांनी निवासमंडप व तंबू, त्याचे आच्छादन, सभामंडपाच्या प्रवेशद्वाराचा पडदा, ");
INSERT INTO marc_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","आणि अंगणाचे पडदे, निवासमंडप आणि वेदीच्या सभोवतालच्या अंगणाच्या प्रवेशद्वाराचा पडदा आणि दोर्‍या व त्याच्या वापराशी संबंधित जे सर्वकाही आहे यांची काळजी घ्यावी. ");
INSERT INTO marc_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","अम्रामी, इसहारी, हेब्रोनी आणि उज्जीएली हे कोहाथी कुळाचे होते; ही कोहाथची कुळे होती. ");
INSERT INTO marc_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","एक महिना किंवा त्याहून अधिक वयाच्या सर्व पुरुषांची संख्या 8,600 होती. पवित्रस्थानाची काळजी घेण्याची जबाबदारी कोहाथी लोकांकडे होती. ");
INSERT INTO marc_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कोहाथी कुळांनी निवासमंडपाच्या दक्षिणेकडे डेरे द्यायचे होते. ");
INSERT INTO marc_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","उज्जीएलचा पुत्र एलीजाफान हा कोहाथी कुळांचा पुढारी होता. ");
INSERT INTO marc_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","कोश, मेज, दीपस्तंभ, वेद्या, पवित्रस्थानाच्या सेवेत वापरली जाणारी उपकरणे, पडदा आणि त्यांच्या वापराशी संबंधित सर्व गोष्टींची काळजी घेण्यास ते जबाबदार होते. ");
INSERT INTO marc_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","अहरोन याजकाचा पुत्र एलअज़ार हा लेवींचा प्रमुख पुढारी होता. पवित्रस्थानाची काळजी घेण्याची जबाबदारी असलेल्यांवर त्याची नेमणूक करण्यात आली होती. ");
INSERT INTO marc_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","महली व मूशी हे कुळे मरारीपासून होते. ही मरारी कुळे होती. ");
INSERT INTO marc_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","एक महिना किंवा त्याहून अधिक वयाच्या सर्व पुरुषांची संख्या सहा हजार दोनशे होती. ");
INSERT INTO marc_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","अबीहाईलाचा पुत्र जूरीएल हा मरारी घराण्यांच्या कुळांचा पुढारी होता. त्यांनी निवासमंडपाच्या उत्तरेला डेरे द्यायचे होते. ");
INSERT INTO marc_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","मरारी लोकांची नेमणूक निवासमंडपाच्या फळ्या, अडसर, खांब, बैठका, त्याची सर्व उपकरणे आणि त्यांच्या वापरा संबंधित सर्व गोष्टींची काळजी घेण्यासाठी, ");
INSERT INTO marc_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","तसेच अंगणाच्या आजूबाजूच्या बैठका, तंबूच्या मेखा आणि दोर्‍या यावर करण्यात आली होती. ");
INSERT INTO marc_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","मोशे आणि अहरोन आणि त्याच्या पुत्रांनी निवासमंडपाच्या पूर्वेला, सूर्योदयाच्या दिशेने, सभामंडपासमोर डेरा द्यायचा होता. इस्राएली लोकांच्या वतीने पवित्रस्थानाची काळजी घेण्याची जबाबदारी त्यांच्याकडे होती. इतर कोणीही पवित्रस्थानाजवळ आले तर त्याला जिवे मारले जावे. ");
INSERT INTO marc_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","याहवेहच्या आज्ञेप्रमाणे मोशे व अहरोन यांनी लेवी लोकांची त्यांच्या कुळानुसार एक महिन्याचे व अधिक वयाचे पुरुष यांची गणती केली, ते एकूण 22,000 होते. ");
INSERT INTO marc_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","मग याहवेह मोशेला म्हणाले, “इस्राएली लोकांतील एक महिन्याच्या व त्याहून अधिक वयाच्या प्रथम जन्मलेल्या सर्व पुरुषांची गणती करून त्यांच्या नावांची यादी करावी. ");
INSERT INTO marc_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","आणि इस्राएली लोकांच्या सर्व प्रथम जन्मलेल्यांच्या ऐवजी लेव्यांना माझ्यासाठी घ्यावे आणि इस्राएली लोकांच्या पशूतील सर्व प्रथम जन्मलेल्या वत्सांऐवजी, लेव्याच्या पशूंना माझ्यासाठी घ्यावे. मीच याहवेह आहे.” ");
INSERT INTO marc_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","याहवेहच्या आज्ञेप्रमाणे मोशेने इस्राएल लोकांच्या प्रथम जन्मलेल्या सर्वांची गणती केली. ");
INSERT INTO marc_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","एक महिना व त्याहून अधिक वयाच्या प्रथम जन्मलेल्या पुरुषांची एकूण संख्या 22,273 होती. ");
INSERT INTO marc_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","याहवेह मोशेला आणखी म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“इस्राएली लोकांच्या सर्व प्रथम जन्मलेल्यांच्या ऐवजी लेवी लोकांना घे आणि त्यांच्या पशूंच्या ऐवजी लेव्यांचे पशू घ्यावे. लेवी लोक माझे असावेत. मीच याहवेह आहे. ");
INSERT INTO marc_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","273 इस्राएली लोकांचे प्रथम जन्मलेले जे लेव्यांपेक्षा अधिक आहेत त्यांची खंडणी भरण्यासाठी, ");
INSERT INTO marc_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","प्रत्येकामागे पवित्रस्थानाच्या शेकेलाप्रमाणे पाच शेकेल घे; म्हणजेच वीस गेरा. ");
INSERT INTO marc_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","आणि इस्राएली लोकांतील जे अधिक होते त्यांच्या खंडणीचे पैसे अहरोन आणि त्याच्या पुत्रांना द्यावे.” ");
INSERT INTO marc_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","मोशेने लेव्यांपेक्षा जे अधिक होते त्यांच्याकडून त्यांच्या खंडणीचे पैसे गोळा केले. ");
INSERT INTO marc_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","इस्राएली लोकांच्या प्रथम जन्मलेल्यांकडून त्याने पवित्रस्थानाच्या शेकेलनुसार 1,365 गोळा केले. ");
INSERT INTO marc_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","याहवेहच्या वचनाप्रमाणे झालेल्या आज्ञेनुसार मोशेने ते खंडणीचे पैसे अहरोन व त्याच्या पुत्रांना दिले. ");
INSERT INTO marc_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","याहवेह मोशेला आणि अहरोनाला म्हणाले: ");
INSERT INTO marc_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“लेवींच्या शाखेतील कोहाथी लोकांची त्यांच्या कुळांनुसार व घराण्यानुसार जनगणना करा. ");
INSERT INTO marc_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","म्हणजे सभामंडपाच्या कामाची सेवा करण्यास जे सर्व तीस ते पन्नास वर्षे वयाचे पुरुष आहेत, त्यांची गणती करावी. ");
INSERT INTO marc_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“सभामंडपातील परमपवित्र वस्तूंची काळजी घेण्याचे काम कोहाथी लोकांचे आहे. ");
INSERT INTO marc_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ज्यावेळी छावणी पुढे चालण्यास निघेल, त्यावेळी अहरोन आणि त्याच्या पुत्रांनी आत जाऊन आडपडदा खाली काढून तो कराराच्या नियमाच्या कोशावर ठेवावा. ");
INSERT INTO marc_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","मग त्यांनी तो पडदा टिकाऊ चर्माने झाकावा व त्यावर निळ्या रंगाचे कापड पसरावे आणि कोशाचे दांडे त्याच्या जागी बसवावे. ");
INSERT INTO marc_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“समक्षतेच्या मेजावर त्यांनी निळ्या रंगाचे कापड पसरावे आणि त्यावर बशा, ताट, वाट्या आणि पेयार्पणासाठी कलश ठेवावे; आणि निरंतरची अर्पणाची भाकर त्यावर असावी. ");
INSERT INTO marc_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","त्यांनी त्यावर किरमिजी रंगाचे एक कापड पसरावे आणि त्यावर टिकाऊ चर्माचे आच्छादन घालावे व मेजाचे दांडे त्यांच्या जागी बसवावेत. ");
INSERT INTO marc_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“यानंतर त्यांनी प्रकाश देणारा दीपस्तंभ व त्यावरील दिवे, वातीचे चिमटे व त्यांची तबके आणि जैतुनाच्या तेलाचे वाटप करण्यासाठी त्याचे सर्व कलश हे सर्व निळ्या कापडाने झाकावे. ");
INSERT INTO marc_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","मग त्यांनी ती सगळी उपकरणे टिकाऊ चर्माच्या आच्छादनात गुंडाळून ते वाहून नेण्याच्या फळीवर ठेवावे. ");
INSERT INTO marc_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“मग त्यांनी सोन्याच्या वेदीवर निळे कापड पसरावे व ते टिकाऊ चर्माने झाकावे आणि वेदीचे दांडे त्यांच्या जागी बसवावेत. ");
INSERT INTO marc_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“पवित्रस्थानाच्या सेवेसाठी वापरात आणली जाणारी सर्व पात्रे निळ्या कापडात गुंडाळावीत व त्यावर टिकाऊ चर्माचे आच्छादन घालावे आणि ती वाहून नेण्याच्या फळीवर ठेवावी. ");
INSERT INTO marc_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“कास्य वेदीवरील सर्व राख काढावी आणि वेदी जांभळ्या रंगाच्या कापडाने झाकावी. ");
INSERT INTO marc_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","मग वेदीच्या सेवेसाठी वापरात येणारी सर्व पात्रे म्हणजे अग्निपात्रे, मांसाचे काटे, फावडी आणि शिंपडण्याचे कटोरे त्यावर ठेवावे. मग त्यावर टिकाऊ चर्माचे आच्छादन घालावे आणि त्याचे दांडे त्यांच्या जागी बसवावेत. ");
INSERT INTO marc_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“नंतर अहरोन आणि त्याच्या पुत्रांनी सर्व पवित्र साहित्य व पवित्र उपकरणे यावर आच्छादन घालण्याचे काम संपविल्यावर, जेव्हा छावणी पुढे जाण्यास सज्ज होईल, त्याचवेळी कोहाथी कुळाने ते वाहून नेण्यास पुढे यावे. परंतु त्यांनी पवित्र वस्तूंना स्पर्श करू नये, नाहीतर ते मरतील. कोहाथी लोकांनी सभामंडपातील वस्तू वाहून न्यावयाच्या आहेत. ");
INSERT INTO marc_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“दिव्याचे तेल, सुगंधी धूप, रोजचे अन्नार्पण व अभिषेकाचे तेल, संपूर्ण निवासमंडप आणि त्यातील सर्व साहित्य, त्याचे पवित्र साहित्य व उपकरणे यांची जबाबदारी अहरोन याजकाचा पुत्र एलअज़ारकडे असावी.” ");
INSERT INTO marc_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","याहवेहने मोशे व अहरोन यांना म्हटले, ");
INSERT INTO marc_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“कोहाथी गोत्राच्या कुळाचा लेव्यांमधून नाश होऊ नये, ");
INSERT INTO marc_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","आणि ते जेव्हा परमपवित्र वस्तूंच्या जवळ येतात तेव्हा त्यांनी मरू नये पण जगावे म्हणून त्यांच्यासाठी असे करावे: अहरोन आणि त्याच्या पुत्रांनी पवित्रस्थानात जावे आणि प्रत्येकाने काय वाहून न्यावे हे त्यांना दाखवावे. ");
INSERT INTO marc_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","परंतु कोहाथी लोकांनी पवित्र वस्तू पाहण्यासाठी एक क्षणभरही आत जाऊ नये. नाहीतर ते मरण पावतील.” ");
INSERT INTO marc_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","गेर्षोनी लोकांची त्यांचे घराणे व कूळ यानुसार जनगणना करावी. ");
INSERT INTO marc_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","म्हणजे सभामंडपाच्या कामाची सेवा करण्यास तीस ते पन्नास वर्षे वयाच्या सर्व पुरुषांची गणती करावी. ");
INSERT INTO marc_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“वाहून नेणे व त्यांची इतर कामे करणे, ही गेर्षोनी कुळांची सेवा आहे: ");
INSERT INTO marc_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","त्यांनी निवासमंडपाचे पडदे, सभामंडप व त्याचे आच्छादन व त्याचे टिकाऊ चर्माचे बाहेरील आच्छादन, सभामंडपाच्या प्रवेशद्वाराचा पडदा वाहून न्यावा. ");
INSERT INTO marc_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","निवासमंडप आणि वेदीच्या सभोवतालच्या अंगणाचे पडदे, अंगणाच्या प्रवेशद्वाराचा पडदा, दोर्‍या आणि मंडपातील सेवा करण्यासाठी वापरलेली सर्व उपकरणे. या संबंधीच्या ज्यागोष्टी करण्याची गरज आहे, त्या गेर्षोनी लोकांनी कराव्‍यात. ");
INSERT INTO marc_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","गेर्षोनी लोकांनी सर्व सेवा, वाहून नेण्यासंबंधी असो किंवा इतर कामे असो, ती अहरोन आणि त्याच्या पुत्रांच्या मार्गदर्शनाखाली पार पाडावी. त्यांनी जे काही वाहून न्यायचे आहे ते त्यांना त्यांची जबाबदारी म्हणून तू नेमून द्यावे. ");
INSERT INTO marc_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","सभामंडपात गेर्षोनी कुळांनी करावयाची सेवा ती हीच आहे. त्यांची कर्तव्ये अहरोन याजकाचा मुलगा इथामार याच्या मार्गदर्शनाखाली असावीत. ");
INSERT INTO marc_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“मरारी लोकांची त्यांचे कूळ व घराणे यानुसार गणती करावी. ");
INSERT INTO marc_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","म्हणजे सभामंडपाच्या कामाची सेवा करण्यास सर्व तीस ते पन्नास वर्षे वयाच्या पुरुषांची गणती करावी. ");
INSERT INTO marc_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","सभामंडपातील त्यांच्या सेवेचा भाग म्हणून, त्यांनी निवासमंडपाच्या फळ्या, त्याची अडसरे, खांब आणि बैठका वाहून न्याव्या, ");
INSERT INTO marc_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","त्याचप्रमाणे सभोवतालच्या अंगणाचे खांब, त्यांच्या बैठका, मेखा, दोर्‍या, त्याची सर्व उपकरणे आणि त्याच्या वापरासंबंधीचे सर्व साहित्य न्यावे. ज्या पुरुषाने जी ठराविक वस्तू वाहून न्यावयाची आहे ती त्याला नेमून द्यावी. ");
INSERT INTO marc_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","अहरोन याजकाचा पुत्र इथामार याच्या मार्गदर्शनाखाली राहून सभामंडपात जी सेवा मरारी कुळांनी करावयाची आहे ती हीच आहे.” ");
INSERT INTO marc_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","मोशे, अहरोन आणि समुदायाच्या पुढार्‍यांनी कोहाथी लोकांची, त्यांचे कूळ व घराणे यानुसार गणती केली. ");
INSERT INTO marc_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","सभामंडपाच्या कामाची सेवा करण्यास जे सर्व तीस ते पन्नास वर्षे वयाचे पुरुष आले होते, ");
INSERT INTO marc_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","त्यांची संख्या कुळांनुसार 2,750 होती. ");
INSERT INTO marc_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","सभामंडपात सेवा करणार्‍या सर्व कोहाथी कुळाची ही एकूण संख्या होती. मोशेद्वारे याहवेहने आज्ञा दिल्यानुसार मोशे आणि अहरोनाने त्यांची गणती केली. ");
INSERT INTO marc_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","गेर्षोनी लोकांची त्यांचे कूळ व घराणे यानुसार गणती केली. ");
INSERT INTO marc_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","सभामंडपाच्या कामाची सेवा करण्यास सर्व तीस ते पन्नास वर्षे वयाचे पुरुष आले होते, ");
INSERT INTO marc_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","त्यांचे कूळ व घराणे यानुसार ते 2,630 होते. ");
INSERT INTO marc_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","सभामंडपात सेवा करणार्‍या सर्व गेर्षोनी कुळाची ही एकूण संख्या होती. मोशेद्वारे याहवेहने आज्ञा दिल्यानुसार मोशे आणि अहरोनाने त्यांची गणती केली. ");
INSERT INTO marc_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","मरारी लोकांची त्यांचे कूळ व घराणे यानुसार गणती केली. ");
INSERT INTO marc_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","सभामंडपाच्या कामाची सेवा करण्यास जे सर्व तीस ते पन्नास वर्षे वयाचे पुरुष आले होते, ");
INSERT INTO marc_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","त्यांच्या कुळानुसार ते 3,200 गणले गेले. ");
INSERT INTO marc_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","सभामंडपात सेवा करणार्‍या सर्व मरारी कुळाची ही एकूण संख्या होती. मोशेद्वारे याहवेहने आज्ञा दिल्यानुसार मोशे आणि अहरोनाने त्यांची गणती केली. ");
INSERT INTO marc_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","मोशे, अहरोन आणि इस्राएलच्या पुढार्‍यांनी सर्व लेवींची, त्यांचे कूळ व घराणे यानुसार गणती केली. ");
INSERT INTO marc_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","सभामंडपाच्या कामाची सेवा करण्यास सर्व तीस ते पन्नास वर्षे वयाचे पुरुष आले होते, ");
INSERT INTO marc_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","त्यांची संख्या 8,580 भरली. ");
INSERT INTO marc_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","याहवेहने मोशेद्वारे आज्ञा दिल्याप्रमाणे प्रत्येकाला आपले काम व त्यांनी काय वाहून न्यावे हे नेमून देण्यात आले. अशाप्रकारे याहवेहने दिलेल्या आज्ञेप्रमाणे प्रत्येकाची गणती करण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","याहवेहने मोशेला म्हटले, ");
INSERT INTO marc_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","इस्राएली लोकांना आज्ञा दे की, ज्यांना चर्मरोग आहे किंवा कोणत्याही प्रकारचा स्राव आहे किंवा जो मृतदेहाच्या विधीमुळे अशुद्ध झाला आहे, त्यांना छावणीबाहेर पाठवून द्यावे. ");
INSERT INTO marc_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","मग ते स्त्री असो किंवा पुरुष; त्यांना बाहेर पाठवावे. ज्या छावणीत मी तुमच्यामध्ये राहतो, ती त्यांच्यामुळे भ्रष्ट होऊ नये, म्हणून त्यांना बाहेर पाठवावे. ");
INSERT INTO marc_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","त्याप्रमाणे इस्राएली लोकांनी केले; त्यांनी त्यांना छावणीबाहेर पाठविले. याहवेहने मोशेला सूचना दिली होती तसेच त्यांनी केले. ");
INSERT INTO marc_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“इस्राएली लोकांस सांग, ‘जेव्हा कोणी पुरुष किंवा स्त्री एखाद्याविरुद्ध कोणताही अपराध करेल, तो याहवेहच्या विरुद्ध विश्वासघात असून तो दोषी आहे. ");
INSERT INTO marc_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","त्यांनी केलेले पाप कबूल करावे. त्यांनी केलेल्या पापाची पूर्ण भरपाई करून द्यावी, त्यात त्याचा पाचवा भाग मिळवून ज्या व्यक्तीविरुद्ध पाप केला आहे त्याला द्यावा. ");
INSERT INTO marc_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","परंतु पापाची भरपाई करण्यासाठी त्या व्यक्तीचा कोणीही जवळचा नातेवाईक नसेल तर ती भरपाई याहवेहची असावी आणि पापासाठी प्रायश्चित करण्याच्या मेंढ्यासह ती याजकाकडे द्यावी. ");
INSERT INTO marc_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","सर्व पवित्र भेटी, ज्या इस्राएली लोक याजकाकडे आणतात त्या याजकाच्या व्हाव्या. ");
INSERT INTO marc_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","पवित्र वस्तू त्यांच्या मालकाच्या आहेत, परंतु ते जे याजकाला देतात, ते याजकाच्या मालकीचे होईल.’ ” ");
INSERT INTO marc_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“इस्राएली लोकांशी बोल आणि त्यांना सांग: जर एखाद्या मनुष्याच्या पत्नीचे वाकडे पाऊल पडले आणि ती त्याच्याशी अविश्वासूपणे वागली, ");
INSERT INTO marc_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","जेणेकरून दुसर्‍या पुरुषाचे तिच्याशी लैंगिक संबंध असले आणि हे तिच्या पतीपासून गुपित असेल आणि तिची अशुद्धता उघडकीस आली नाही (कारण तिच्याविरुद्ध कोणीही साक्षीदार नाही आणि ती त्या कृत्यात पकडली गेली नाही), ");
INSERT INTO marc_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","आणि जर तिच्या पतीला मत्सराची भावना झाली आणि तो आपल्या पत्नीवर संशय घेतो की ती अशुद्ध आहे—किंवा त्याच्या मनात मत्सराची भावना निर्माण झाली आणि ती जरी अशुद्ध नसली तरीही तो संशय घेतो— ");
INSERT INTO marc_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","तर त्याने आपल्या पत्नीला याजकाकडे न्यावे. त्याने तिच्या वतीने सोबत एक एफाचा दहावा भाग जवाचे पीठ आणावे. त्याने त्यावर जैतुनाचे तेल ओतू नये किंवा त्यावर धूप ठेवू नये, कारण हे मत्सरासाठी केलेले अन्नार्पण आहे, अपराधाची आठवण देणारे स्मरणाचे अर्पण आहे. ");
INSERT INTO marc_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘याजकाने त्या स्त्रीला आणावे आणि तिला याहवेहसमोर उभे करावे. ");
INSERT INTO marc_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","मग याजकाने मातीच्या पात्रात पवित्र पाणी घ्यावे आणि निवासमंडपाच्या भूमीवरील थोडी धूळ घेऊन त्या पाण्यात टाकावी. ");
INSERT INTO marc_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","नंतर याजकाने तिला याहवेहपुढे उभे केल्यानंतर, त्याने तिचे केस मोकळे सोडावे आणि तिच्या स्मरणाचे अर्पण, मत्सरासाठी केलेले अन्नार्पण तिच्या हातावर ठेवावे व त्याने शाप आणणारे कडू पाणी आपल्या हाती घ्यावे. ");
INSERT INTO marc_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","मग याजकाने त्या स्त्रीला शपथ घालून म्हणावे, “जर कोणी पुरुषाने तुझ्याशी लैंगिक संबंध ठेवलेले नाहीत आणि तू आपल्या पतीशी विवाहित असताना निर्दोष असून वाकडे पाऊल टाकले नाही, तर या कडू पाण्यापासून मिळणारा शाप तुला अपाय न करो. ");
INSERT INTO marc_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","परंतु जर तू तुझ्या पतीशी विवाहित असतानाही वाकडे पाऊल टाकले आहे आणि आपल्या पती व्यतिरिक्त इतर पुरुषाशी लैंगिक संबंध ठेवून स्वतःला भ्रष्ट केले आहेस— ");
INSERT INTO marc_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","यावेळी याजकाने त्या स्त्रीस शपथ देऊन या शापाखाली आणावे—जेव्हा याहवेह तुझ्या उदराचा गर्भपात करेल आणि तुझे पोट फुगेल, तेव्हा याहवेह तुला तुझ्या लोकांमध्ये शापित करो. ");
INSERT INTO marc_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","शाप देणारे हे पाणी तुझ्या शरीरात जावो, म्हणजे तुझे पोट फुगेल किंवा तुझा गर्भपात होईल.” “ ‘मग त्या स्त्रीने म्हणावे, “आमेन. असेच होवो.” ");
INSERT INTO marc_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘तेव्हा याजकाने हे शापाचे शब्द एका गुंडाळीवर लिहून ते शब्द त्या कडू पाण्यात धुवावे. ");
INSERT INTO marc_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ज्या पाण्यापासून शाप येईल ते कडू पाणी त्याने तिला प्यायला द्यावे आणि हे पाणी जे शाप व कडवट कष्ट आणते ते तिच्यात प्रवेश करेल. ");
INSERT INTO marc_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","याजकाने ते मत्सराचे अन्नार्पण त्या स्त्रीच्या हातातून घ्यावे व याहवेहस ओवाळत ते वेदीकडे आणावे. ");
INSERT INTO marc_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","त्या अन्नार्पणाचे प्रतीक म्हणून याजकाने त्या अर्पणातील मूठभर अन्न घेऊन ते वेदीवर जाळावे; व त्यानंतर त्याने ते पाणी त्या स्त्रीला प्यायला द्यावे. ");
INSERT INTO marc_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","जर ती आपल्या पतीशी अविश्वासू राहून तिने स्वतःला भ्रष्ट केले असेल, तर त्याचा परिणाम असा असेल: जेव्हा तिला ते शाप आणि कडवट कष्ट आणणारे पाणी पाजले जाईल, ते तिच्या शरीरात जाईल, तिचे पोट फुगेल आणि तिचे उदर गर्भपात करेल आणि ती शापित होईल. ");
INSERT INTO marc_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","पण त्या स्त्रीने जर स्वतःला भ्रष्ट केलेले नाही आणि ती शुद्ध असेल, तर ती निर्दोष ठरविली जाईल आणि तिला मुलेबाळे होतील. ");
INSERT INTO marc_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘जेव्हा एखादी स्त्री तिच्या पतीशी विवाहित असतानाही स्वतःला भ्रष्ट करते तेव्हा हा मत्सराचा नियम असावा, ");
INSERT INTO marc_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","किंवा जेव्हा एखाद्या पुरुषाच्या मनात मत्सराची भावना येते, कारण तो आपल्या पत्नीवर संशय घेतो, याजकाने तिला याहवेहसमोर उभे करावे आणि हा संपूर्ण नियम तिला लागू करावा. ");
INSERT INTO marc_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","तिचा पती कोणत्याही अन्यायापासून निर्दोष असेल, परंतु ती स्त्री आपल्या पापाचे परिणाम भोगेल.’ ” ");
INSERT INTO marc_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“इस्राएली लोकांशी बोल व त्यांना सांग: एखादा पुरुष किंवा स्त्री याहवेहला समर्पित नाजीर होण्याचा एक विशेष नवस करू इच्छितात, ");
INSERT INTO marc_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","तर त्या नाजीरांनी द्राक्षारस व इतर आंबलेले पेय वर्ज्य करावे आणि त्यांनी द्राक्षारसाचा शिरका किंवा इतर आंबलेले पेय पिऊ नये. त्यांनी द्राक्षाचा रस पिऊ नये किंवा द्राक्षे किंवा मनुकेही खाऊ नयेत. ");
INSERT INTO marc_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","जोपर्यंत ते नाजीराच्या नवसाखाली असतील, तोपर्यंत त्यांनी द्राक्षवेलीचा कोणताही उपज, साल व बीज सुद्धा खाऊ नये. ");
INSERT INTO marc_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘नाजीरपणाच्या संपूर्ण काळात त्यांच्या डोक्यावर वस्तरा फिरवू नये. त्यांनी याहवेहला समर्पित केलेला नवसाच्या काळ संपेपर्यंत त्यांनी पवित्र असावे; त्यांनी आपले केस लांब वाढू द्यावेत. ");
INSERT INTO marc_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘याहवेहला समर्पित केलेल्या त्यांच्या संपूर्ण कालावधीत, नाजीराने मृतदेहाजवळ जाऊ नये. ");
INSERT INTO marc_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","त्यांचे स्वतःचे वडील किंवा आई किंवा भाऊ किंवा बहीण जरी मरण पावले, तरीही त्यांच्यामुळे त्यांनी स्वतःला विधिपूर्वक अशुद्ध करू नये, कारण परमेश्वराला समर्पित केल्याचे प्रतीक त्यांच्या डोक्यावर आहे. ");
INSERT INTO marc_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","समर्पित केलेल्या त्यांच्या संपूर्ण कालावधीत ते याहवेहसाठी पवित्र आहेत. ");
INSERT INTO marc_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘जर नाजीराच्या समक्षतेत कोणी अचानक मरण पावला, तर त्यांच्या डोक्यावरील केस, समर्पणाचे प्रतीक विटाळले जाते, त्यावेळी सातव्या दिवशी; शुद्धीकरणाच्या दिवशी त्यांनी आपले मुंडण करावे. ");
INSERT INTO marc_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","मग आठव्या दिवशी त्यांनी दोन कबुतरे किंवा पारव्यांची दोन पिल्ले सभामंडपाच्या दाराशी याजकाकडे आणावी. ");
INSERT INTO marc_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","मग नाजीरासाठी याजकाने त्यापैकी एक पापार्पण व दुसरा होमार्पणाचे प्रायश्चित म्हणून अर्पण करावा, कारण मृतदेहाच्या समक्षतेत राहून त्यांनी पाप केले. त्याच दिवशी त्यांनी पुन्हा आपले डोके पवित्र करावे. ");
INSERT INTO marc_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","आणि त्यांनी आपला नाजीरपणाचा काळ याहवेहसाठी पुनर्समर्पित करावा आणि दोषार्पण म्हणून एक वर्षाचा कोकरा आणावा. आधीचे दिवस मोजले जाणार नाही, कारण त्यांच्या समर्पित असलेल्या काळात ते विटाळले गेले. ");
INSERT INTO marc_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘आणि त्यांचा समर्पणाचा काळ संपल्यानंतर नाजीरांसाठी हा नियम असावा. त्यांना सभामंडपाच्या दाराशी आणावे, ");
INSERT INTO marc_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","त्या ठिकाणी त्यांनी याहवेहसाठी ही अर्पणे सादर करावी: होमार्पणासाठी एक वर्षाचा निर्दोष कोकरा व पापार्पणासाठी मेंढी आणावी व शांत्यर्पणाच्या अर्पणासाठी निर्दोष गोर्‍हा आणावा. ");
INSERT INTO marc_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","त्याबरोबर त्यांचे अन्नार्पण व पेयार्पण आणि एक टोपलीभर सपिठाची आणि बेखमीर भाकरी—जैतुनाच्या तेलात मळलेल्या जाड भाकरी व जैतुनाचे तेल लावलेल्या पातळ भाकरी आणाव्या. ");
INSERT INTO marc_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘याजकाने ही अर्पणे याहवेहसमोर सादर करून पापार्पण व होमार्पण करावे. ");
INSERT INTO marc_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","याजकाने बेखमीर भाकरीची टोपली सादर करावी व अन्नार्पण व पेयार्पण याबरोबर याहवेहसाठी शांत्यर्पण म्हणून गोर्‍हाचा यज्ञ करावा. ");
INSERT INTO marc_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘मग नाजीराने आपल्या डोक्यावरील केस जे त्यांच्या समर्पणाचे प्रतीक आहे, ते सभामंडपाच्या दारात मुंडवावे. मग ते केस घेऊन त्यांनी शांत्यर्पणाखाली असलेल्या अग्नीत टाकावे. ");
INSERT INTO marc_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘नाजीराने आपल्या डोक्यावरील केस जे त्यांच्या समर्पणाचे प्रतीक आहे ते मुंडण केल्यानंतर, याजकाने त्यांच्या हातात गोर्‍हाचा उकळलेला खांद्याचा भाग व खमीर न घालता बनविलेल्या दोन्ही, एक जाड व एक पातळ भाकर ठेवावी. ");
INSERT INTO marc_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","नंतर याजकाने ते हेलावणीचे अर्पण म्हणून याहवेहपुढे ओवाळावे; ते पवित्र आहे; त्याचबरोबर ओवाळलेला उराचा भाग आणि सादर केलेला मांडीचा भाग याजकासाठी असावा. यानंतर नाजीर द्राक्षारस पिऊ शकतो. ");
INSERT INTO marc_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘हा नाजीराचा नियम आहे, जे आपल्या समर्पणानुसार याहवेहला अर्पण करण्याचा नवस करतात, त्या खेरीज त्यांना परवडेल त्यानुसार आणावे. नाजीराच्या नियमानुसार केलेले नवस त्यांनी पूर्ण केले पाहिजे.’ ” ");
INSERT INTO marc_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","अहरोन आणि त्याच्या पुत्रांना सांग, “तुम्ही इस्राएली लोकांस आशीर्वाद देतांना असे म्हणावे: ");
INSERT INTO marc_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “याहवेह तुम्हाला आशीर्वाद देवो आणि तुमचे संरक्षण करो; ");
INSERT INTO marc_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","याहवेह आपला मुखप्रकाश तुमच्यावर पाडो आणि तुमच्यावर कृपा करो; ");
INSERT INTO marc_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","याहवेह आपले मुख तुमच्याकडे लावो, आणि तुम्हाला शांती देवो.” ’ ");
INSERT INTO marc_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“अशा रीतीने ते माझे नाव इस्राएली लोकांना ठेवतील आणि मी त्यांना आशीर्वादित करेन.” ");
INSERT INTO marc_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","जेव्हा मोशेने निवासमंडप उभारण्याचे काम संपविले, तेव्हा त्याने निवासमंडप व त्यातील सामानावर अभिषेक केला व ते पवित्र केले. त्याने वेदी व त्याची सर्व पात्रे सुद्धा अभिषिक्त करून ती पवित्र केली. ");
INSERT INTO marc_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","मग इस्राएलचे पुढारी, घराण्यांचे प्रमुख जे त्यांच्या गोत्राचे पुढारी होते, ज्यांची मोजणी करण्यात आली होती, त्यांच्यावर जे देखरेख करणारे होते, त्यांनी अर्पणे आणली. ");
INSERT INTO marc_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","त्यांनी याहवेहपुढे भेटी म्हणून आणले ते हे—आच्छादन असलेल्या सहा गाड्या व बारा बैल; प्रत्येक पुढार्‍यामागे एक बैल आणि दोन पुढार्‍यांमागे एक गाडी. हे सर्व त्यांनी निवासमंडपासमोर सादर केले. ");
INSERT INTO marc_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","याहवेहने मोशेला म्हटले, ");
INSERT INTO marc_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“तू त्यांच्याकडून ते स्वीकार आणि त्यांचा उपयोग सभामंडपाच्या कामासाठी करावा. जसे प्रत्येक व्यक्तीच्या कामास लागेल तसे ते लेव्यांच्या हाती दे.” ");
INSERT INTO marc_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","तेव्हा मोशेने त्या गाड्या आणि ते बैल घेतले व लेव्यांना दिले. ");
INSERT INTO marc_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","गेर्षोन कुळाला त्यांच्या कामाच्या गरजेनुसार त्याने दोन गाड्या व चार बैल दिले. ");
INSERT INTO marc_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","आणि त्याने मरारी कुळाला त्यांच्या कामाच्या गरजेनुसार चार गाड्या व आठ बैल दिले. ते सर्व अहरोन याजकाचा पुत्र इथामार याच्या नेतृत्वाखाली होते. ");
INSERT INTO marc_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","कोहाथी कुळाला मात्र मोशेने काहीही दिले नाही, कारण पवित्र वस्तू आपल्या खांद्यांवर वाहून नेण्याच्या सेवेसाठी ते जबाबदार होते. ");
INSERT INTO marc_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","जेव्हा वेदीचा अभिषेक करण्यात आला, पुढार्‍यांनीही तिच्या समर्पणाची अर्पणे आणली व ती वेदीपुढे सादर केली. ");
INSERT INTO marc_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","कारण याहवेहने मोशेला सांगितले होते, “प्रत्येक दिवशी एका पुढार्‍याने वेदीच्या समर्पणासाठी अर्पणे आणावी.” ");
INSERT INTO marc_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","पहिल्या दिवशी ज्याने अर्पणे आणली तो यहूदाह गोत्रातील अम्मीनादाबाचा पुत्र नहशोन होता. ");
INSERT INTO marc_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र. ");
INSERT INTO marc_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षांचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","दुसर्‍या दिवशी इस्साखार वंशाचा प्रमुख सूवाराचा पुत्र नथानेलाने आपली अर्पणे आणली. ");
INSERT INTO marc_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","तिसर्‍या दिवशी जबुलून वंशाचा प्रमुख, हेलोनाचा पुत्र एलियाबाने आपले अर्पणे आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे. ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","चौथ्या दिवशी रऊबेन वंशाचा प्रमुख शदेयुराचा पुत्र एलीसूराने आपले अर्पण आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","पाचव्या दिवशी शिमओन वंशाचा प्रमुख सुरीशादैचा पुत्र शेलुमीएलाने आपले अर्पण आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","सहाव्या दिवशी, गादच्या लोकांचा पुढारी देउएलाचा पुत्र एलीआसाफाने आपले अर्पण आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","सातव्या दिवशी एफ्राईम वंशाचा प्रमुख अम्मीहूदाचा पुत्र एलीशामाने आपले अर्पण आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","आठव्या दिवशी मनश्शेह वंशाचा प्रमुख पदहसूरचा पुत्र गमलीएल याने आपले अर्पण आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची नर पाच कोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","नवव्या दिवशी बिन्यामीन वंशाचा प्रमुख गिदोनीचा पुत्र अबीदान याने आपले अर्पण आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","दहाव्या दिवशी दान वंशाचा प्रमुख अम्मीशद्दायचा पुत्र अहीएजर याने आपले अर्पण आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","अकराव्या दिवशी आशेर वंशाचा प्रमुख ओक्रानाचा पुत्र पगीयेल याने आपले अर्पण आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","बाराव्या दिवशी नफताली वंशाचा प्रमुख एनानाचा पुत्र अहीराने आपले अर्पण आणले. ");
INSERT INTO marc_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","त्याचे अर्पण हे: पवित्रस्थानाच्या शेकेलानुसार एकशे तीस शेकेल वजनाचे एक चांदीचे ताट आणि सत्तर शेकेल वजनाचे शिंपडण्याचे चांदीचे भांडे, ही दोन्ही अन्नार्पण म्हणून जैतुनाच्या तेलात मळलेल्या सपिठाने भरली होती; ");
INSERT INTO marc_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","दहा शेकेल वजनाचे धूपाने भरलेले एक सोन्याचे धूपपात्र; ");
INSERT INTO marc_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","होमार्पणासाठी एक तरुण बैल, एक गोर्‍हा आणि एक वर्षाचा कोकरा; ");
INSERT INTO marc_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","पापार्पणासाठी एक बोकड; ");
INSERT INTO marc_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","आणि शांत्यर्पणासाठी दोन बैल, पाच गोर्‍हे, पाच बोकडे आणि एक वर्षाची पाच नरकोकरे. ");
INSERT INTO marc_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","जेव्हा वेदीचा अभिषेक झाला तेव्हा इस्राएलच्या पुढार्‍यांकडून तिच्या समर्पणाची अर्पणे ही होती: बारा चांदीची ताटे, बारा शिंपडण्याचे भांडे आणि बारा सोन्याची पात्रे होती. ");
INSERT INTO marc_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","चांदीचे प्रत्येक ताट एकशे तीस शेकेल वजनाचे होते आणि शिंपडण्याचे प्रत्येक भांडे सत्तर शेकेल वजनाचे होते. ते सर्व मिळून, चांदीची भांडी पवित्रस्थानाच्या शेकेलानुसार दोन हजार चारशे शेकेल वजनाची होती. ");
INSERT INTO marc_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","धूपाने भरलेली सोन्याची बारा धूपपात्रे, प्रत्येकी दहा शेकेल वजनाची होती. पवित्रस्थानाच्या शेकेलानुसार ते सोन्याचे पात्र एकशेवीस शेकेल वजनाचे होते. ");
INSERT INTO marc_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","होमार्पण व त्याबरोबर अन्नार्पणासाठी एकूण बारा तरुण बैल, बारा गोर्‍हे, एक वर्षाची बारा नरकोकरे होती. बारा बोकडे पापार्पणांसाठी वापरण्यात आली. ");
INSERT INTO marc_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","शांत्यर्पणासाठी एकूण चोवीस बैल, साठ गोर्‍हे, साठ बोकडे व एक वर्षांची साठ नरकोकरे आणली होती. ");
INSERT INTO marc_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","जेव्हा मोशे याहवेहशी बोलण्यासाठी सभामंडपात गेला, तेव्हा कराराच्या नियमाच्या कोशावर असलेल्या प्रायश्चिताच्या झाकणावरून, दोन करुबांमधून त्याच्याशी बोलत असलेली वाणी त्याने ऐकली. अशाप्रकारे याहवेह त्याच्याशी बोलले. ");
INSERT INTO marc_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“अहरोनाशी बोल व त्याला सांग, जेव्हा तू दिवे लावशील, तेव्हा सातही दिव्यांचा प्रकाश दीपस्तंभाच्या पुढील बाजूस पडावा.” ");
INSERT INTO marc_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","याहवेहने मोशेला आज्ञापिले होते त्याप्रमाणेच अहरोनाने केले; त्याने दीपस्तंभाच्या समोरील बाजूस दिवे लावले. ");
INSERT INTO marc_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","दीपस्तंभ अशाप्रकारे घडविला गेला होता: जसे याहवेहने मोशेला दाखविले होते त्या नमुन्याप्रमाणेच तो त्याच्या बैठकीपासून त्याच्या फुलांपर्यंत सोन्याने घडविला होता. ");
INSERT INTO marc_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“लेव्यांना सर्व इस्राएली लोकांमधून घेऊन त्यांना विधीनुसार शुद्ध कर. ");
INSERT INTO marc_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","त्यांना शुद्ध करण्यासाठी तू असे कर: त्यांच्यावर शुद्धीकरणाचे पाणी शिंपडावे; मग त्यांनी आपल्या संपूर्ण अंगावरून वस्तरा फिरवावा व आपले कपडे धुवावे. अशाप्रकारे ते स्वतःला शुद्ध करतील. ");
INSERT INTO marc_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","मग त्यांनी एक गोर्‍हा घ्यावा व त्याबरोबरचे अन्नार्पण जे जैतुनाच्या तेलात मळलेले सपीठ आणावे; आणि पापार्पणासाठी आणखी एक गोर्‍हा आणावा. ");
INSERT INTO marc_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","लेव्यांना सभामंडपाच्या समोर घेऊन यावे व सर्व इस्राएल समुदायाला एकत्र करावे. ");
INSERT INTO marc_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","लेव्यांना याहवेहपुढे सादर करावे व इस्राएली लोकांनी आपले हात त्यांच्यावर ठेवावेत. ");
INSERT INTO marc_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","अहरोनाने इस्राएली लोकांच्या वतीने हेलावणीचे अर्पण म्हणून लेव्यांना याहवेहसमोर सादर करावे, म्हणजे ते याहवेहची सेवा करण्याकरिता तयार होतील.” ");
INSERT INTO marc_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","मग लेव्यांनी गोर्‍ह्यांच्या डोक्यावर आपले हात ठेवावेत, त्यातील एक गोर्‍हा याहवेहला पापार्पण म्हणून अर्पण करावा आणि दुसरा लेव्यांसाठी प्रायश्चित म्हणून होमार्पण करावा. ");
INSERT INTO marc_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","मग तू लेव्यांना अहरोन आणि त्याच्या पुत्रांसमोर उभे करावे आणि त्यांना हेलावणीचे अर्पण म्हणून याहवेहला सादर करावे. ");
INSERT INTO marc_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","अशाप्रकारे तू लेवी लोकांना माझ्यासाठी इतर इस्राएली लोकांपासून वेगळे करावेस म्हणजे लेवी माझे होतील. ");
INSERT INTO marc_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","तू लेवींना शुद्ध करून हेलावणीचे अर्पण म्हणून मला सादर केल्यानंतर, त्यांनी आपले काम करण्याकरिता सभामंडपात यावे. ");
INSERT INTO marc_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","इस्राएली लोकांमधून ते सर्वस्वी मला समर्पित आहेत. प्रत्येक इस्राएली स्त्रीच्या प्रथम जन्मलेल्या पुरुषाऐवजी, मी त्यांना आपलेसे करून घेतले आहे. ");
INSERT INTO marc_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इस्राएली लोकांतील प्रथम जन्मलेला प्रत्येक नर, तो मनुष्याचा असो किंवा पशूंचा, तो माझा आहे. जेव्हा मी इजिप्तचे सर्व प्रथम जन्मलेले मारून टाकले, तेव्हा मी त्यांना माझ्यासाठी पवित्र केले आहे. ");
INSERT INTO marc_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","आणि मी इस्राएली लोकांतील प्रथम जन्मलेल्यांच्या ऐवजी लेवींना घेतले आहे. ");
INSERT INTO marc_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","मी लेव्यांना सर्व इस्राएली लोकांमधून अहरोन व त्याच्या पुत्रांना भेट म्हणून दिले आहे, यासाठी की इस्राएली लोकांच्या वतीने त्यांनी सभामंडपात सेवा करावी व त्यांच्यासाठी प्रायश्चित करावे, म्हणजे इस्राएली लोक पवित्रस्थानाकडे जातील, तेव्हा कोणतीही पीडा त्यांचा नाश करणार नाही. ");
INSERT INTO marc_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","मोशे, अहरोन आणि सर्व इस्राएली समुदायांनी याहवेहने मोशेला आज्ञापिले होते त्याच प्रकारे लेव्यांना केले. ");
INSERT INTO marc_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लेवी लोकांनी स्वतःला शुद्ध केले आणि आपली वस्त्रे धुतली. मग अहरोनाने त्यांना हेलावणीचे अर्पण म्हणून याहवेहसमोर सादर केले व त्यांच्या शुद्धीकरणासाठी प्रायश्चित्त केले. ");
INSERT INTO marc_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","नंतर लेवी लोक अहरोन व त्याच्या पुत्रांच्या देखरेखीखाली सेवा करण्यासाठी सभामंडपात आले. लेव्यांच्या संबंधी याहवेहने मोशेला आज्ञापिले होते त्याचप्रमाणे त्यांनी केले. ");
INSERT INTO marc_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“लेव्यांच्या संबंधी हा नियम लागू असावा: पंचवीस वर्षे व त्याहून अधिक वय असलेल्या पुरुषांनी सभामंडपामध्ये कार्यरत होण्यासाठी यावे. ");
INSERT INTO marc_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","पन्नासाव्या वर्षी त्यांनी त्यांच्या रोजच्या सेवेतून निवृत्त व्हावे व त्यानंतर काम करू नये. ");
INSERT INTO marc_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","त्यांनी सभामंडपात आपल्या बांधवांना त्यांच्या कार्यात मदत करावी; परंतु त्यांनी स्वतः काम करू नये. याप्रकारे तू लेवी लोकांची कामे नेमून द्यावी.” ");
INSERT INTO marc_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","इजिप्त देशातून निघाल्यानंतर दुसर्‍या वर्षाच्या पहिल्या महिन्यात ते सीनाय रानात असताना याहवेह मोशेशी बोलले. ते म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“इस्राएली लोकांनी नेमलेल्या वेळेस वल्हांडण सण पाळावा. ");
INSERT INTO marc_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","नेमलेल्या वेळेस, म्हणजेच या महिन्याच्या चौदाव्या दिवसाच्या संध्याकाळी, त्यासंबंधी असलेल्या सर्व विधी नियमानुसार तो सण पाळावा.” ");
INSERT INTO marc_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","तेव्हा मोशेने इस्राएली लोकांना वल्हांडणाचा सण पाळावयास सांगितले. ");
INSERT INTO marc_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","त्याप्रमाणे सीनायच्या रानात, पहिल्या महिन्याच्या चौदाव्या दिवसाच्या संध्याकाळी त्यांनी वल्हांडणाचा सण पाळला. जसे याहवेहने मोशेला आज्ञापिले होते त्याचप्रमाणे इस्राएली लोकांनी केले. ");
INSERT INTO marc_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","परंतु त्यांच्यापैकी काही व्यक्ती असे होते ज्यांना वल्हांडण सण पाळता आला नाही, कारण ते विधीनुसार मृत देहामुळे अशुद्ध झाले होते. म्हणून त्याच दिवशी ते मोशे व अहरोनकडे आले. ");
INSERT INTO marc_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","आणि मोशेला म्हणाले, “आम्ही मृत देहामुळे अशुद्ध झालो आहोत, परंतु इस्राएली लोकांबरोबर नेमलेल्या वेळी याहवेहला अर्पण सादर करण्यापासून आम्हाला का वंचित ठेवावे?” ");
INSERT INTO marc_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मोशे त्यांना म्हणाला, “तुमच्याविषयी याहवेह काय आज्ञा देतील ते मी जाणून घेईपर्यंत तुम्ही थांबा.” ");
INSERT INTO marc_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","मग याहवेहने मोशेला म्हटले, ");
INSERT INTO marc_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इस्राएली लोकांना सांग: ‘जर तुमच्यातील किंवा तुमच्या गोत्रातील कोणी मृत देहामुळे अशुद्ध झाला किंवा दूर प्रवासात असला, त्यांनी तरीही याहवेहसाठी वल्हांडण सण पाळावा, ");
INSERT INTO marc_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","परंतु त्यांनी तो दुसर्‍या महिन्याच्या चौदाव्या दिवसाच्या संध्याकाळी पाळावा. त्यांनी बेखमीर भाकर व कडू पाल्याबरोबर वल्हांडणाचे कोकरू खावे. ");
INSERT INTO marc_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","त्यांनी दुसर्‍या दिवसाच्या सकाळपर्यंत त्यातील काहीही शिल्लक ठेवू नये किंवा त्याचे एकही हाड मोडू नये. जेव्हा ते वल्हांडण पाळतात, तेव्हा त्यांनी सर्व नियम पाळावेत. ");
INSERT INTO marc_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","पण जो कोणी विधीनुसार शुद्ध असला आणि प्रवासात नसला, तरीही वल्हांडण पाळीत नाही तर त्यांना आपल्या लोकांतून काढून टाकले जावे, कारण त्यांनी नेमलेल्या वेळेस याहवेहला अर्पण सादर केले नाही. त्यांच्या पापाचा परिणाम त्यांना भोगावा लागेल. ");
INSERT INTO marc_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘तुमच्यामध्ये राहत असणार्‍या परदेशी व्यक्तीनेही विधी नियमानुसार याहवेहचा वल्हांडण पाळावा. परदेशी व स्वदेशी व्यक्तीसाठी सारखाच नियम असावा.’ ” ");
INSERT INTO marc_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ज्या दिवशी निवासमंडप, कराराच्या नियमाचा मंडप उभारण्यात आला, त्या दिवशी मेघाने त्याला झाकून टाकले. संध्याकाळपासून सकाळपर्यंत निवासमंडपावरील मेघ अग्नीसारखे दिसू लागले. ");
INSERT INTO marc_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","आणि ते तसेच चालू राहिले; मेघांनी त्याला झाकले आणि रात्री ते अग्नीसारखे दिसू लागले. ");
INSERT INTO marc_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","जेव्हा मंडपावरून मेघ वर जाई, तेव्हा ते पुढची वाटचाल करीत असत; आणि जेव्हा मेघ थांबत असे, तिथे इस्राएली लोक तळ देत असत. ");
INSERT INTO marc_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","याहवेहच्या आज्ञेनुसार इस्राएली लोक प्रवासास निघत असत आणि याहवेहच्या आज्ञेनुसार ते तळ देत. जोपर्यंत निवासमंडपावर मेघ थांबत असे तोपर्यंत ते तळ देऊन राहत असत. ");
INSERT INTO marc_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","जेव्हा मेघ दीर्घकाळ निवासमंडपावर थांबून राहिला, तेव्हा इस्राएली लोक याहवेहची आज्ञा पाळीत व पुढे जात नसत. ");
INSERT INTO marc_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","कधीकधी मेघ काहीच दिवस निवासमंडपावर थांबत असे, तेव्हा याहवेहच्या आज्ञेनुसार ते तळ देऊन राहत आणि याहवेहच्या आज्ञेनुसार ते पुढे जात. ");
INSERT INTO marc_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","कधीकधी मेघ केवळ संध्याकाळपासून सकाळपर्यंत राहत असे आणि सकाळी जेव्हा तो वरती घेतला जाई, लोक पुढे जात. तो दिवस असो किंवा रात्र, जेव्हा मेघ वरती घेतला जात असे, ते पुढे निघत असत. ");
INSERT INTO marc_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","निवासमंडपावर मेघ दोन दिवस थांबून राहो किंवा एक महिना किंवा एक वर्ष राहो, इस्राएली लोक आपल्या छावणीत राहत आणि पुढे जात नसत; परंतु जेव्हा मेघ वर घेतला जाई, ते पुढे जात. ");
INSERT INTO marc_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","याहवेहच्या आज्ञेनुसार ते तळ देत आणि याहवेहच्या आज्ञेनुसार ते पुढे जात. मोशेद्वारे याहवेहने दिलेल्या आज्ञेचे त्यांनी पालन केले. ");
INSERT INTO marc_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","याहवेह मोशेला म्हणाले: ");
INSERT INTO marc_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“तू घडीव चांदीचे दोन कर्णे घडवून घे आणि समुदायाला एकत्र जमविण्यासाठी आणि छावण्या पुढे प्रवासास निघण्यासाठी त्यांचा उपयोग कर. ");
INSERT INTO marc_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","दोन्ही कर्णे वाजविले म्हणजे सर्व समुदायाने सभामंडपाच्या प्रवेशव्दाराजवळ तुझ्यापुढे एकत्र जमावे. ");
INSERT INTO marc_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","जर एकच कर्णा वाजविला, तर इस्राएली कुलप्रमुखांनी तुझ्यापुढे जमावे. ");
INSERT INTO marc_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","जेव्हा कर्ण्याचा मोठा गजर केला म्हणजे पूर्वेकडे तळ दिलेल्या वंशानी पुढे निघावे. ");
INSERT INTO marc_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","दुसरा गजर केला म्हणजे दक्षिणेकडील वंशानी निघावे. तो गजर पुढे निघण्यासाठी संकेत असा राहील ");
INSERT INTO marc_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","जेव्हा समुदाय जमा करावयाचा असेल तेव्हा कर्णा वाजवा, परंतु पुढे जाण्याच्या संकेताने नव्हे. ");
INSERT INTO marc_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“अहरोनाचे पुत्र जे याजक आहेत त्यांनीच कर्णे वाजवावे. हा तुम्हाला व येणार्‍या तुमच्या पिढ्यांसाठी सर्वकाळचा नियम असावा. ");
INSERT INTO marc_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","जेव्हा तुम्ही तुमच्याच देशात तुमच्यावर जुलूम करणार्‍या तुमच्या शत्रूविरुद्ध युद्ध करण्यास जाता, तेव्हा तुम्ही कर्ण्याचा गजर करा. तेव्हा याहवेह तुमचे परमेश्वर तुमचे स्मरण करतील व तुमच्या शत्रूपासून तुम्हाला सोडविले जाईल. ");
INSERT INTO marc_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","तुमच्या आनंदाच्या प्रसंगी; तुमचे नेमलेले सण व महिन्याच्या आरंभीची मेजवानी, जेव्हा तुम्ही आपली होमार्पणे व शांत्यर्पणे आणता, त्यावेळी सुद्धा तुम्ही कर्णे वाजवा आणि ते याहवेहसमोर तुमच्यासाठी स्मरणार्थ असेल. मीच याहवेह तुमचा परमेश्वर आहे.” ");
INSERT INTO marc_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","दुसर्‍या वर्षाच्या दुसर्‍या महिन्याच्या विसाव्या दिवशी कराराच्या नियमाच्या निवासमंडपावरून मेघ वरती घेतला गेला. ");
INSERT INTO marc_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","तेव्हा इस्राएली लोक सीनायच्या रानातून निघाले आणि पारानाच्या रानात मेघ स्थिर होईपर्यंत एका ठिकाणातून दुसर्‍या ठिकाणी प्रवास करीत राहिले. ");
INSERT INTO marc_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","याहवेहने मोशेद्वारे दिलेल्या आज्ञेनुसार ते पहिल्या प्रवासास निघाले. ");
INSERT INTO marc_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","यहूदाह वंशाच्या छावणीचा दल आपल्या झेंड्याखाली प्रथम निघाला. अम्मीनादाबाचा पुत्र नहशोन त्यांचा सेनापती होता. ");
INSERT INTO marc_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","सूवाराचा पुत्र नथानेल हा इस्साखार वंशाच्या दलावर होता, ");
INSERT INTO marc_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","आणि हेलोनाचा पुत्र एलियाब जबुलून वंशाच्या दलावर होता. ");
INSERT INTO marc_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","मग निवासमंडप खाली उतरविला गेला आणि गेर्षोनी व मरारींनी निवासमंडप वाहून ते पुढे निघाले. ");
INSERT INTO marc_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","त्यानंतर रऊबेन वंशाच्या छावणीचा दल आपल्या झेंड्याखाली पुढे निघाला. शदेयुराचा पुत्र एलीसूर त्यांचा सेनापती होता. ");
INSERT INTO marc_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","सुरीशादैचा पुत्र शेलुमीएल हा शिमओन वंशाच्या दलावर होता. ");
INSERT INTO marc_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","आणि देउएलाचा पुत्र एलीआसाफ हा गाद वंशाच्या दलावर होता. ");
INSERT INTO marc_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","मग पवित्र वस्तू घेऊन कोहाथी लोक निघाले. म्हणजे ते पोहोचण्यापूर्वी निवासमंडप उभारला जावा. ");
INSERT INTO marc_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","एफ्राईम वंशाच्या छावणीचा दल आपल्या झेंड्याखाली पुढे निघाला. अम्मीहूदाचा पुत्र एलीशामा त्यांचा सेनापती होता. ");
INSERT INTO marc_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","पदहसूरचा पुत्र गमलीएल हा मनश्शेह वंशाच्या दलावर होता, ");
INSERT INTO marc_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","आणि गिदोनाचा पुत्र अबीदान हा बिन्यामीन वंशाच्या दलावर होता. ");
INSERT INTO marc_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","शेवटी सर्व तुकड्यांच्या मागून रक्षक म्हणून, दान वंशाच्या छावणीचा दल आपल्या झेंड्याखाली निघाला. अम्मीशद्दायचा पुत्र अहीएजर त्यांच्या दलावर सेनापती होता. ");
INSERT INTO marc_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ओक्रानाचा पुत्र पगीयेल हा आशेर वंशाच्या दलावर होता, ");
INSERT INTO marc_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","आणि एनानाचा पुत्र अहीरा हा नफताली वंशाच्या दलावर होता. ");
INSERT INTO marc_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","पुढे निघताना इस्राएली दलांच्या प्रवासाचा हा क्रम होता. ");
INSERT INTO marc_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","आणि मोशेचा सासरा मिद्यानी रऊएलचा पुत्र होबाबला मोशे म्हणाला, “आम्ही त्या ठिकाणाकडे जात आहोत, ज्याविषयी याहवेहने सांगितले की, ‘मी ते तुम्हाला देईन.’ तू आमच्याबरोबर ये आणि आम्ही तुला चांगली वागणूक देऊ, कारण याहवेहने इस्राएली लोकांना उत्तम गोष्टींविषयी अभिवचन दिले आहे.” ");
INSERT INTO marc_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","तो त्याला म्हणाला, “नाही, मी येणार नाही; मी माझा देश आणि माझ्या लोकांकडे जात आहे.” ");
INSERT INTO marc_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","पण मोशे म्हणाला, “कृपा करून आम्हाला सोडू नकोस. रानात आम्ही कुठे तळ द्यावा याविषयी तुला माहिती आहे, आम्ही तुझ्या नजरेने पाहू. ");
INSERT INTO marc_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","तू जर आमच्याबरोबर आलास, तर याहवेह आम्हाला ज्या चांगल्या गोष्टी देतील, त्यात तुलाही वाटा मिळेल.” ");
INSERT INTO marc_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","मग ते याहवेहचे पर्वत म्हणजेच सीनाय पर्वतापासून निघाले व तीन दिवसांचा प्रवास करीत गेले. याहवेहच्या कराराचा कोश त्यांच्या विसाव्याचे ठिकाण पाहण्यासाठी त्या तीन दिवसांचा प्रवास करीत त्यांच्यापुढे गेला. ");
INSERT INTO marc_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ते छावणीतून निघाले तेव्हा दिवसा याहवेहचा मेघ त्यांच्यावर होता. ");
INSERT INTO marc_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","जेव्हा कोश पुढे जात असे तेव्हा मोशे म्हणे, “हे याहवेह, सक्रिय व्हा! तुमच्या शत्रूंची पांगापांग होवो; तुमचे वैरी तुमच्यापुढून पळून जावोत.” ");
INSERT INTO marc_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","जेव्हा कोश थांबत असे, तो म्हणे, “हे याहवेह, परत या, इस्राएलाच्या हजारो असंख्याकडे पुन्हा या.” ");
INSERT INTO marc_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","मग असे झाले की लोक याहवेहसमोर असताना त्यांच्या कष्टांबद्दल तक्रार करू लागले. जेव्हा याहवेहने ते ऐकले तेव्हा त्यांचा राग भडकला आणि त्यांच्यामध्ये याहवेहचा अग्नी पेटला आणि छावणीच्या बाहेरील काही भाग भस्म झाला. ");
INSERT INTO marc_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","जेव्हा लोकांनी मोशेकडे धावा केला व त्याने याहवेहकडे विनंती केली आणि अग्नी विझला. ");
INSERT INTO marc_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","म्हणून त्या जागेचे नाव तबेरा असे पडले, कारण याहवेहचा अग्नी त्यांच्यामध्ये पेटला होता. ");
INSERT INTO marc_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","नंतर त्यांच्याबरोबर असलेले निम्नस्तरातील मिश्र लोक अन्य भोजनाची लालसा धरू लागले आणि इस्राएली लोकही पुन्हा रडत म्हणू लागले, “आम्हाला खायला मांस असते तर किती बरे! ");
INSERT INTO marc_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","इजिप्त देशात आम्ही फुकट मासे खाल्ले; आणि काकड्या, खरबुजे, कंदभाजी, कांदे आणि लसूण यांची सुद्धा आम्हाला आठवण येते. ");
INSERT INTO marc_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","परंतु आता आमची भूक नाहीशी झाली आहे; कारण या मान्न्याशिवाय आम्हाला दुसरे काहीच दिसत नाही!” ");
INSERT INTO marc_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","मान्ना आकाराने धण्यासारखा असून रंगाने मोत्यासारखा होता. ");
INSERT INTO marc_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","लोक चोहीकडे जाऊन तो गोळा करीत असत आणि मग जात्यात दळीत किंवा उखळात कुटत असत. मग ते भांड्यात शिजवित किंवा त्याच्या भाकरी बनवित असत. त्याची चव जैतुनाच्या तेलात बनलेल्या भाकरीप्रमाणे असे. ");
INSERT INTO marc_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","रात्री जेव्हा छावणीवर दहिवर जमा होत असे तेव्हा मान्ना सुद्धा पडत असे. ");
INSERT INTO marc_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","प्रत्येक घराण्यातील लोक आपआपल्या तंबूच्या दाराशी उभे राहून रडत होते आणि याहवेहचा त्यांच्यावर अतिशय क्रोध आला होता त्यामुळे मोशे अस्वस्थ झाला. ");
INSERT INTO marc_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","मोशेने याहवेहला विचारले, “तुमच्या सेवकावर हे कष्ट तुम्ही का आणले? तुम्ही असंतुष्ट व्हावे असे मी काय केले की तुम्ही या सर्व लोकांचे ओझे माझ्यावर लादावे? ");
INSERT INTO marc_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","मी या सर्व लोकांचे गर्भधारण केले काय? त्यांना मी जन्म दिला काय? आई आपल्या तान्ह्या बाळाला घेते तसे मी यांना माझ्या उराशी घेऊन तुम्ही त्यांच्या पूर्वजांना शपथ घेऊन वचन दिलेल्या देशात मी घेऊन जावे असे तुम्ही मला का सांगता? ");
INSERT INTO marc_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","या सर्व लोकांसाठी मी मांस कुठून आणावे? ते रडत माझ्याजवळ मागतात ‘आम्हाला खायला मांस दे!’ ");
INSERT INTO marc_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","मला एकट्याला या राष्ट्राला घेऊन जाता येत नाही! हे ओझे मला खूप जड आहे. ");
INSERT INTO marc_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","तुम्ही मला असेच वागविणार असाल आणि तुमच्या दृष्टीत मी जर कृपा पावलो असलो तर मला मारून टाका. मी माझाच नाश पाहावा असे होऊ देऊ नये.” ");
INSERT INTO marc_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","याहवेह मोशेला म्हणाले: “इस्राएली लोकांमधील सत्तर वडील ज्यांना तू पुढारी आणि अधिकारी म्हणून ओळखतो, त्यांना माझ्यासमोर आण. त्यांनी सभामंडपात यावे व तुझ्याबरोबर उभे राहावे. ");
INSERT INTO marc_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","मी खाली येऊन तिथे तुझ्याशी बोलेन आणि जो आत्मा तुझ्यावर आहे, त्याचे काही सामर्थ्य मी घेऊन त्यांच्यावर ठेवेन. ते तुझ्याबरोबर लोकांचा भार वाहतील म्हणजे तुला एकट्याला तो वाहावा लागणार नाही. ");
INSERT INTO marc_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“लोकांना सांग: ‘उद्याच्या तयारीकरिता स्वतःला पवित्र करा, कारण उद्या त्यांना मांस खायला मिळेल. “आम्हाला मांस खायला मिळाले तर किती बरे! आम्ही इजिप्तमध्ये चांगले होतो!” हे तुमचे रडणे याहवेहने ऐकले आहे, आता याहवेह तुम्हाला मांस देणार आहेत आणि ते तुम्ही खाल. ");
INSERT INTO marc_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","तुम्ही ते केवळ एक दिवस किंवा दोन दिवस, किंवा पाच दिवस, दहा, किंवा वीस दिवस, ");
INSERT INTO marc_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","परंतु संपूर्ण एक महिना; ते तुमच्या नाकपुड्यातून बाहेर येईपर्यंत आणि ते तुम्हाला नकोसे वाटेपर्यंत ते तुम्ही खाल; कारण तुम्ही याहवेह जे तुमच्यामध्ये राहतात त्यांना नाकारले आहे, त्यांच्यासमोर रडत म्हणाला, “आम्ही इजिप्त का सोडले?” ’ ” ");
INSERT INTO marc_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","पण मोशे म्हणाला, “इथे ज्या लोकांमध्ये मी आहे ते सहा लाख पुरुष पायदळ आहेत आणि तुम्ही म्हणता, ‘मी त्यांना एक महिनाभर मांस खायला देणार!’ ");
INSERT INTO marc_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","गुरे व शेरडेमेंढरे कापली तरी ते त्यांच्यासाठी पुरेसे होईल काय? समुद्रातील सर्व मासे पकडले तरी ते त्यांना पुरतील काय?” ");
INSERT INTO marc_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","याहवेहने मोशेला उत्तर दिले, “याहवेहचा हात इतका आखूड आहे काय? माझे शब्द घडून येतात की नाही हे तू आता पाहशील.” ");
INSERT INTO marc_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","मग मोशे निवासमंडपातून बाहेर आला आणि याहवेह जे काही बोलले ते त्याने लोकांना सांगितले. आणि त्याने सत्तर वडिलांना एकत्र करून तंबूच्या सभोवती उभे केले. ");
INSERT INTO marc_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","मग याहवेह मेघातून खाली उतरले व मोशेशी बोलले आणि याहवेहने मोशेवर असलेल्या आत्म्याचे काही सामर्थ्य घेऊन त्या सत्तर वडिलांवर ठेवले. ज्यावेळी आत्मा त्यांच्यावर स्थिर झाला, त्यावेळी त्यांनी भविष्यवाणी केली—परंतु पुन्हा असे केले नाही. ");
INSERT INTO marc_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","पण दोघे पुरुष ज्यांची नावे एलदाद व मेदाद छावणीतच राहिले होते. वडिलांच्या यादीत त्यांची नावे होती, परंतु ते बाहेर तंबूकडे गेले नाही. तरी त्यांच्यावरही आत्मा उतरला आणि त्यांनी छावणीतच भविष्यवाणी केली. ");
INSERT INTO marc_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","एका तरुण पुरुषाने धावत जाऊन मोशेला सांगितले, “एलदाद व मेदाद छावणीत भविष्यवाणी करीत आहेत.” ");
INSERT INTO marc_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","नूनाचा पुत्र यहोशुआ, जो तारुण्यापासून मोशेचा मदतनीस होता, तो म्हणाला, “मोशे, माझ्या स्वामी, त्यांना थांबवा!” ");
INSERT INTO marc_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","पण मोशे म्हणाला, “माझ्यासाठी तू त्यांचा हेवा करतोस काय? माझी तर इच्छा आहे की, याहवेहचे सर्व लोक संदेष्टे असावेत आणि याहवेहने सर्व लोकांवर आपला आत्मा ठेवावा!” ");
INSERT INTO marc_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","नंतर मोशे व इस्राएलांचे वडीलजन छावणीकडे परतले. ");
INSERT INTO marc_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","मग याहवेहकडून वारा वाहिला आणि समुद्रावरून लावे पक्षी आणले. आणि छावणीच्या सभोवती, एकंदर एकएक दिवसाच्या वाटेपर्यंत सर्व दिशेने सुमारे दोन हात उंचीचा थर पसरला. ");
INSERT INTO marc_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","त्या दिवशी लोकांनी बाहेर जाऊन तो संपूर्ण दिवस आणि रात्र आणि संपूर्ण दुसरा दिवस लावे पक्षी गोळा केले. कोणीही दहा होमेर वजनापेक्षा कमी गोळा केले नाही, मग त्यांनी ते छावणीत सर्वत्र पसरून ठेवले. ");
INSERT INTO marc_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","परंतु ते मांस त्यांच्या मुखातच होते आणि ते खाण्याच्या आधी याहवेहचा क्रोध लोकांविरुद्ध भडकला आणि याहवेहने त्यांना भयंकर पीडेने मारले. ");
INSERT INTO marc_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","म्हणून त्या ठिकाणाचे नाव किब्रोथ-हत्ताव्वा असे पडले, कारण ज्यांनी इतर भोजनाची लालसा धरली त्या लोकांना त्या ठिकाणी पुरले. ");
INSERT INTO marc_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","किब्रोथ-हत्ताव्वा येथून लोकांनी हसेरोथकडे प्रवास केला आणि तिथे राहिले. ");
INSERT INTO marc_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मोशेच्या कूशी पत्नीमुळे मिर्याम आणि अहरोन मोशेच्या विरुद्ध बोलू लागले, कारण त्याने कूशी देशातील एका स्त्रीशी विवाह केला होता. ");
INSERT INTO marc_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","त्यांनी विचारले, “याहवेह मोशेद्वारेच बोलले आहेत काय? याहवेह आमच्याद्वारे सुद्धा बोलले नाहीत काय?” आणि याहवेहने हे ऐकले. ");
INSERT INTO marc_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(मोशे तर अतिशय नम्र मनुष्य होता, भूतलावरील इतर लोकांपेक्षा अधिक नम्र होता.) ");
INSERT INTO marc_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","याहवेह लगेचच मोशे, अहरोन आणि मिर्यामला म्हणाले, “तुम्ही तिघेही सभामंडपाकडे बाहेर या.” तेव्हा ते तिघे बाहेर गेले. ");
INSERT INTO marc_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","मग याहवेह मेघस्तंभातून खाली आले; आणि निवासमंडपाच्या दाराशी उभे राहून अहरोन व मिर्याम यांना बोलाविले. जेव्हा ते पुढे गेले, ");
INSERT INTO marc_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","याहवेह त्यांना म्हणाले, “माझे शब्द ऐका: “जेव्हा तुमच्यामध्ये एखादा संदेष्टा आहे, मी याहवेह, त्यांना दृष्टान्ताद्वारे स्वतःला प्रकट करतो, स्वप्नाद्वारे मी त्यांच्याशी बोलतो. ");
INSERT INTO marc_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","परंतु माझा सेवक मोशे याच्या बाबतीत तसे नाही; तो माझ्या सर्व घराण्यात विश्वासू आहे. ");
INSERT INTO marc_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","मी त्याच्याशी कोड्यात नाही, तर समोरासमोर स्पष्टपणे बोलतो; तो याहवेहचे रूप पाहतो. माझा सेवक मोशे याच्याविरुद्ध बोलण्यास तुम्हाला भीती का वाटली नाही?” ");
INSERT INTO marc_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","मग याहवेहचा क्रोध त्यांच्याविरुद्ध भडकला आणि याहवेह त्यांना सोडून निघून गेले. ");
INSERT INTO marc_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","जेव्हा मंडपावरून मेघ वरती घेतला गेला, तेव्हा मिर्यामची त्वचा रोगाने भरली होती; ती बर्फासारखी पांढरी झाली. अहरोनाने तिच्याकडे वळून बघितले तेव्हा त्याने पाहिले की तिच्या त्वचेवर कोड फुटले होते, ");
INSERT INTO marc_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","तेव्हा तो मोशेला म्हणाला, “माझे स्वामी, मी तुला विनंती करतो, कृपया, आम्ही मूर्खपणाने केलेले पाप आमच्याविरुद्ध मोजू नको. ");
INSERT INTO marc_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","जसे एक तान्हे मृत बाळ आपल्या आईच्या उदरातून जन्माला येताच त्याचे अर्धे शरीर नष्ट झालेले असते, असे तिला राहू देऊ नको.” ");
INSERT INTO marc_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","तेव्हा मोशेने याहवेहचा धावा केला, “हे याहवेह कृपा करून तिला बरे करा!” ");
INSERT INTO marc_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","तेव्हा याहवेहने मोशेला उत्तर दिले, “जर तिचा पिता तिच्या तोंडावर थुंकला असता, तर तिला सात दिवस लाजेने घालवावे लागले असते की नाही? तिला सात दिवस छावणीच्या बाहेर वेगळे राहू दे, त्यानंतर तिला परत आणावे.” ");
INSERT INTO marc_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","मग मिर्यामला सात दिवस छावणीबाहेर वेगळे ठेवण्यात आले आणि तिला पुन्हा छावणीत आणेपर्यंत लोक पुढच्या प्रवासास गेले नाही. ");
INSERT INTO marc_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","यानंतर त्यांनी हसेरोथ सोडले आणि पारान नावाच्या रानात तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“मी जो कनान देश इस्राएली लोकांना देत आहे, तो देश हेरावा म्हणून पूर्वजांच्या प्रत्येक कुळातील एका पुढाऱ्याला पाठव.” ");
INSERT INTO marc_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","म्हणून याहवेहच्या आज्ञेनुसार मोशेने ज्यांना पारानच्या रानातून बाहेर पाठवले, ते सर्व इस्राएली लोकांचे पुढारी होते. ");
INSERT INTO marc_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","त्यांची नावे ही आहेत: रऊबेन गोत्रातील जक्कूरचा पुत्र शम्मुवा; ");
INSERT INTO marc_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","शिमओन गोत्रातील होरीचा पुत्र शाफाट; ");
INSERT INTO marc_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदाह गोत्रातील यफुन्नेहचा पुत्र कालेब; ");
INSERT INTO marc_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्साखार गोत्रातील योसेफाचा पुत्र इगाल; ");
INSERT INTO marc_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एफ्राईमच्या गोत्रातील नूनाचा पुत्र होशा; ");
INSERT INTO marc_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बिन्यामीन गोत्रातील राफूचा पुत्र पालती; ");
INSERT INTO marc_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","जबुलून गोत्रातील सोदीचा पुत्र गाद्दीयेल; ");
INSERT INTO marc_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","मनश्शेहच्या गोत्रातील (योसेफाचे गोत्र) सुसीचा पुत्र गाद्दी; ");
INSERT INTO marc_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दान गोत्रातील गमल्लीचा पुत्र अम्मीएल; ");
INSERT INTO marc_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशेर गोत्रातील मिखाएलचा पुत्र सेथूर; ");
INSERT INTO marc_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नफताली गोत्रातील वोफसीचा पुत्र नाहबी; ");
INSERT INTO marc_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","गाद गोत्रातील माकीचा पुत्र गऊवेल. ");
INSERT INTO marc_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","देश हेरावयाला जे पुरुष मोशेने पाठवले त्यांची ही नावे होती. (मोशेने नूनाचा पुत्र होशाचे नाव बदलून त्याला यहोशुआ हे नाव दिले.) ");
INSERT INTO marc_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","जेव्हा मोशे त्यांना कनान देश हेरायाला पाठवित होता तेव्हा तो म्हणाला, “नेगेव-दक्षिण-मधून वर डोंगराळ प्रदेशात जा. ");
INSERT INTO marc_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","आणि तो देश कसा आहे, तिथे जे लोक राहतात ते बलवान आहेत की दुर्बल आहेत, ते थोडे आहेत की पुष्कळ हे पाहा. ");
INSERT INTO marc_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ते राहतात तो देश कसा आहे? तो चांगला आहे की वाईट आहे? कोणत्या प्रकारच्या नगरांमध्ये त्यांची वस्ती आहे? ते उजाड आहेत की तटबंदीची आहेत? ");
INSERT INTO marc_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","तेथील जमीन कशी आहे? ती सुपीक आहे की नापीक? त्यात झाडे आहेत की नाही? तुम्ही परत येताना त्या देशातील काही फळे तुमच्याबरोबर घेऊन येण्याचा कसोशीने प्रयत्न करा.” (तो प्रथमपक्व द्राक्षाच्या फळांचा हंगाम होता.) ");
INSERT INTO marc_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","मग ते गेले आणि सीन रानापासून हमाथाच्या जवळील रहोबा पर्यंतचा देश त्यांनी हेरला. ");
INSERT INTO marc_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ते वरती नेगेवमधून गेले आणि हेब्रोनात आले, जिथे अहीमान, शेशय आणि तलमय हे अनाकाचे वंशज राहत होते. (हेब्रोन हे इजिप्त देशातील सोअन शहराच्या सात वर्षे आधी बांधले गेले होते.) ");
INSERT INTO marc_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ते जेव्हा अष्कोल खोर्‍याजवळ आले. तिथे त्यांनी एक द्राक्षांचा घड असलेली फांदी कापून घेतली. दोन माणसांनी त्यांच्यामध्ये तो एका काठीवर घालून वाहून नेला. त्याचबरोबर त्यांनी काही डाळिंबे आणि अंजिरेही घेतली. ");
INSERT INTO marc_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","त्या खोर्‍याचे नाव अष्कोल असे ठेवले कारण इस्राएली लोकांनी तिथून द्राक्षाचा घड कापून घेतला होता. ");
INSERT INTO marc_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","देश हेरून चाळीस दिवसानंतर ते परत आले. ");
INSERT INTO marc_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","पारान रानातील कादेश येथे मोशे आणि अहरोन व सर्व इस्राएली लोकांकडे ते परत आले. तिथे त्यांनी त्यांना व सर्व समुदायाला अहवाल दिला व त्या देशाची फळे दाखविली. ");
INSERT INTO marc_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","त्यांनी मोशेला अहवाल दिला तो असा: “जो देश हेरण्यास तुम्ही आम्हाला पाठविले तिथे आम्ही गेलो, त्यात खरोखरच दूध व मध वाहतात! ही पाहा तेथील फळे. ");
INSERT INTO marc_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","परंतु तिथे राहत असलेले लोक बलवान आहेत, त्यांची शहरे तटबंदीची व पुष्कळ मोठी आहेत. आम्ही त्या ठिकाणी अनाकाचे वंशजही पाहिले. ");
INSERT INTO marc_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","नेगेवमध्ये अमालेकी लोक राहतात. डोंगराळ प्रदेशात हिथी, यबूसी आणि अमोरी लोक राहतात. समुद्राच्या किनार्‍यावर आणि यार्देन नदीच्या खोर्‍यात कनानी लोक राहतात.” ");
INSERT INTO marc_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","तेव्हा मोशेसमोर कालेबाने लोकांना शांत केले व म्हणाला, “आपण वर जाऊन तो देश ताब्यात घेतला पाहिजे, कारण आपण खचितच ते करू शकतो.” ");
INSERT INTO marc_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","परंतु जे पुरुष त्याच्याबरोबर वर गेले होते ते म्हणाले, “त्या लोकांवर आपण हल्ला करू शकत नाही; ते आपल्यापेक्षा बलवान आहेत.” ");
INSERT INTO marc_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","आणि जो देश ते हेरण्यास गेले होते त्याबद्दल त्यांनी इस्राएली लोकांमध्ये वाईट अहवाल पसरविला. ते म्हणाले, “जो देश आम्ही हेरला तो देश त्यांच्या रहिवाशांना खाऊन टाकणारा आहे. जे लोक आम्ही पाहिले ते धिप्पाड आहेत. ");
INSERT INTO marc_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","तिथे आम्ही नेफिलीम (अनाकाचे महाबलाढ्य वंशज नेफिलीम पासून आहेत) लोकांना बघितले. आमच्याच दृष्टीत आम्ही नाकतोड्याप्रमाणे होतो आणि त्यांनाही आम्ही तसेच भासलो.” ");
INSERT INTO marc_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","रात्रीच्या वेळी लोकसमुदायाचे सर्व सभासद आपला आवाज उंच करून मोठ्याने रडू लागले. ");
INSERT INTO marc_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","सर्व इस्राएली लोकांनी मोशे व अहरोन यांच्याविरुद्ध कुरकुर केली आणि सर्व समुदाय त्यांना म्हणाला, “आम्ही इजिप्त देशात किंवा या रानातच मेलो असतो तर किती बरे असते! ");
INSERT INTO marc_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","आम्ही तलवारीने पडावे म्हणूनच या देशात याहवेह आम्हाला आणत आहेत काय? आमच्या स्त्रिया आणि लेकरांना गुलाम म्हणून नेण्यात येईल. आम्ही इजिप्तकडे परत जावे हे आमच्यासाठी बरे नाही काय?” ");
INSERT INTO marc_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","आणि ते एकमेकांना म्हणाले, “आपण एखाद्या पुढार्‍याची निवड करू आणि इजिप्त देशास परत जाऊ.” ");
INSERT INTO marc_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","तेव्हा सर्व इस्राएली समुदाय जो तिथे एकत्र जमला होता, त्यांच्यासमोर मोशे आणि अहरोन पालथे पडले. ");
INSERT INTO marc_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","नूनाचा पुत्र यहोशुआ आणि यफुन्नेहचा पुत्र कालेब, जे त्यापैकीच देश हेरून आले होते तेही होते, त्यांनी आपली वस्त्रे फाडली ");
INSERT INTO marc_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","आणि सर्व इस्राएली समुदायाला म्हणाले, “आम्ही ज्या देशातून फिरून आलो तो देश अतिशय चांगला आहे. ");
INSERT INTO marc_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","याहवेह जर आमच्याविषयी संतुष्ट असले तर त्या दूध व मध वाहत्या देशात ते आपल्याला घेऊन जातील आणि तो देश आम्हाला देतील. ");
INSERT INTO marc_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","मात्र याहवेहविरुद्ध बंड करू नका. आणि तेथील लोकांचे भय बाळगू नका, कारण आम्ही त्यांना नष्ट करणार. त्यांचे संरक्षण नाहीसे झाले आहे, परंतु याहवेह आमच्याबरोबर आहेत. त्यांचे भय बाळगू नका.” ");
INSERT INTO marc_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","परंतु सर्व समुदाय त्यांना धोंडमार करण्याविषयी बोलू लागले. तेव्हा सभामंडपावर सर्व इस्राएली लोकांना याहवेहचे तेज प्रकट झाले, ");
INSERT INTO marc_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","याहवेह मोशेला म्हणाले, “हे लोक कुठवर माझा तिरस्कार करणार? त्यांच्यामध्ये मी केलेले सर्व चमत्कार पाहूनही कुठवर माझ्यावर विश्वास ठेवण्यास ते नकार देतील? ");
INSERT INTO marc_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","मी त्यांच्यावर पीडा आणून त्यांचा नाश करेन, परंतु मी तुझ्यापासून त्यांच्याहून मोठे व बलवान राष्ट्र करेन.” ");
INSERT INTO marc_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","मोशे याहवेहला म्हणाला, “मग इजिप्तचे लोक याविषयी ऐकतील! तुम्ही आपल्या सामर्थ्याने या लोकांना त्यांच्यामधून काढून बाहेर आणले आहे. ");
INSERT INTO marc_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","आणि ते त्या देशात राहणार्‍यांना याविषयी सांगतील. त्यांनी तर आधी तुमच्याविषयी ऐकले आहे की, तुम्ही याहवेह या लोकांबरोबर आहात, तुमचा मेघस्तंभ त्यांच्यावर असतो आणि याहवेह तुम्ही त्यांना समोरासमोर दिसता आणि तुम्ही दिवसा मेघस्तंभात व रात्री अग्निस्तंभात त्यांच्यापुढे असता. ");
INSERT INTO marc_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","जर तुम्ही या लोकांपैकी कोणालाही जिवंत न ठेवता मारून टाकले, तर ज्या राष्ट्रांनी तुमच्याविषयी ऐकले आहे ते म्हणतील, ");
INSERT INTO marc_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘याहवेहने या लोकांना शपथ देऊन जो देश देऊ केला होता, त्यात त्यांना नेण्यास याहवेह असमर्थ होते म्हणून त्यांनी लोकांना रानातच मारून टाकले.’ ");
INSERT INTO marc_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“आता प्रभूचे सामर्थ्य तुम्ही घोषित केल्याप्रमाणेच प्रकट होवो: ");
INSERT INTO marc_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘याहवेह मंदक्रोध, अत्यंत प्रीती करणारे, अन्याय व पापाची क्षमा करणारे आहेत. तरीही ते दोषीला निर्दोष सोडत नाहीत; तर तिसर्‍या व चौथ्या पिढीपर्यंत आईवडिलांच्या पापाचे शासन त्यांच्या संततींना देतात.’ ");
INSERT INTO marc_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","आपल्या महान प्रीतीनुसार, जसे इजिप्त सोडले तेव्हापासून आतापर्यंत क्षमा केली, तसेच आताही त्यांच्या पापाची त्यांना क्षमा करावी.” ");
INSERT INTO marc_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","मग याहवेहने उत्तर दिले, “तुझ्या म्हणण्याप्रमाणे मी त्यांना क्षमा केली आहे. ");
INSERT INTO marc_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","परंतु खचितच मी जिवंत आहे आणि खचितच संपूर्ण पृथ्वी याहवेहच्या वैभवाने भरलेली आहे. ");
INSERT INTO marc_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ज्यांनी माझे वैभव आणि मी इजिप्तमध्ये व रानात केलेले चमत्कार पाहिले आहेत आणि तरीही माझा आज्ञाभंग केला व दहा वेळा माझी परीक्षा पाहिली; ");
INSERT INTO marc_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","त्यांच्यातील एकही व्यक्ती, जो देश मी त्यांच्या पूर्वजांना शपथपूर्वक देऊ केला आहे तो पाहणार नाही. ज्यांनी मला तुच्छ लेखले आहे त्यातील कोणीही तो देश पाहणार नाही. ");
INSERT INTO marc_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","परंतु माझा सेवक कालेब याच्यावर वेगळा आत्मा आहे आणि तो संपूर्ण हृदयाने माझे अनुसरण करतो, म्हणून तो ज्या देशात गेला होता तिथे मी त्याला नेईन व त्याचे वंशज त्या देशाचे वतन पावतील. ");
INSERT INTO marc_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","अमालेकी व कनानी लोक खोर्‍यामध्ये राहतात म्हणून, उद्या तुम्ही माघारी फिरा आणि तांबड्या समुद्राच्या वाटेने जा.” ");
INSERT INTO marc_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","याहवेह मोशे व अहरोन यांना म्हणाले: ");
INSERT INTO marc_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“कुठपर्यंत हा दुष्ट समुदाय माझ्याविरुद्ध कुरकुर करीत राहणार? या कुरकुर करणाऱ्या इस्राएली लोकांच्या तक्रारी मी ऐकल्या आहे. ");
INSERT INTO marc_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","म्हणून त्यांना सांगा, याहवेह म्हणतात, खचितच मी जिवंत आहे, जे काही तुम्ही बोलला आहात तेच मी तुम्हास करेन: ");
INSERT INTO marc_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","याच रानात तुम्ही सर्व मरण पावाल—तुमच्यापैकी प्रत्येक जे वीस वर्षे व त्याहून अधिक वयाचे आहेत, ज्यांची जनगणनेमध्ये गणती झाली आणि ज्यांनी माझ्याविरुद्ध कुरकुर केली. ");
INSERT INTO marc_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ज्या देशाविषयी मी हात उंच करून म्हटले की त्यात मी तुम्हाला वसवेन, त्या देशात तुमच्यापैकी यफुन्नेहचा पुत्र कालेब आणि नूनाचा पुत्र यहोशुआ यांच्याशिवाय कोणीही जाणार नाही. ");
INSERT INTO marc_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ज्या तुमच्या लेकरांविषयी तुम्ही म्हणाला होता की, त्या देशात ते लूट असे होतील, त्यात मी त्यांना आणेन, अशासाठी की ज्या देशाचा तुम्ही धिक्कार केला त्याचा त्यांनी आनंद भोगावा. ");
INSERT INTO marc_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","परंतु तुमच्याविषयी तर असे की, तुमचे देह याच रानात पडतील. ");
INSERT INTO marc_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","तुमच्यापैकी अगदी शेवटचा देह या रानात पडेपर्यंत तुमची लेकरे तुमच्या अविश्वासूपणाचे परिणाम भोगत चाळीस वर्षे मेंढपाळ म्हणून राहतील. ");
INSERT INTO marc_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","चाळीस दिवस तुम्ही देश हेरला त्याप्रमाणे प्रत्येक दिवसाला एक वर्ष अशी चाळीस वर्षे तुम्ही आपल्या पापाचे परिणाम भोगाल आणि माझ्या विरोधात जाणे कसे असते हे तुम्ही जाणाल. ");
INSERT INTO marc_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","मी याहवेह हे बोललो आहे आणि जे माझ्या विरोधात एकत्र आले आहेत त्या संपूर्ण दुष्ट समाजाला मी असे निश्चितच करेन. त्यांचा शेवट ते या रानातच पाहतील; ते येथेच मरण पावतील.” ");
INSERT INTO marc_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","म्हणून मोशेने ज्या पुरुषांना देश हेरण्यास पाठवले होते, ज्यांनी माघारी येऊन त्या देशाविषयी वाईट अहवाल पसरविला होता, संपूर्ण समाजाला मोशेविरुद्ध कुरकुर करण्यास भाग पाडले होते— ");
INSERT INTO marc_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","हे पुरुष जे त्या देशाबद्दल वाईट अहवाल पसरविण्यास जबाबदार होते, त्यांच्यावर पीडा आली व ते याहवेहसमोर मरण पावले. ");
INSERT INTO marc_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","देश हेरायला गेलेल्या पुरुषांपैकी फक्त नूनाचा पुत्र यहोशुआ आणि यफुन्नेहचा पुत्र कालेब हे वाचले. ");
INSERT INTO marc_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","जेव्हा मोशेने हे सर्व इस्राएली लोकांना सांगितले, त्यांनी मोठा शोक केला. ");
INSERT INTO marc_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","दुसर्‍या दिवशी पहाटेच ते डोंगराळ प्रदेशाकडे डोंगराच्या शिखराकडे असे म्हणत निघाले, “याहवेहने वचन दिलेल्या देशाकडे वर जाण्यास आम्ही तयार आहोत. खरोखरच आम्ही पाप केले आहे!” ");
INSERT INTO marc_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","परंतु मोशे म्हणाला, “तुम्ही याहवेहचा आज्ञाभंग का करता? यात तुम्हाला यश मिळणार नाही! ");
INSERT INTO marc_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","वर जाऊ नका, कारण याहवेह तुमच्यासोबत नाहीत. तुमचा तुमच्या शत्रूकडून पराभव होईल, ");
INSERT INTO marc_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","कारण अमालेकी व कनानी लोक तिथे तुम्हाला सामोरे येतील. कारण तुम्ही याहवेहपासून मागे फिरला आहात, ते तुमच्याबरोबर नाहीत आणि तुम्ही तलवारीने मरून पडाल.” ");
INSERT INTO marc_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","जरी त्यांनी डोंगराळ प्रदेशाच्या उंच शिखरापर्यंत जाण्याची धिटाई केली, तरी मोशे किंवा याहवेहच्या कराराचा कोश छावणीतून हलले नाहीत. ");
INSERT INTO marc_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","मग त्या डोंगराळ देशात राहणारे अमालेकी व कनानी लोक खाली आले व त्यांनी त्यांच्यावर हल्ला केला आणि होरमाहपर्यंत त्यांना मारत आले. ");
INSERT INTO marc_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इस्राएली लोकांशी बोल व त्यांना सांग: जो देश मी तुम्हाला तुमच्या वस्तीसाठी देत आहे त्यात तुम्ही प्रवेश कराल ");
INSERT INTO marc_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","आणि याहवेहसाठी सुवास म्हणून आपली खिल्लारे व गुरे यातून तुम्ही याहवेहसाठी अन्नार्पण कराल, मग ते होमार्पण किंवा यज्ञ असो, विशेष नवस असो किंवा स्वखुशीचे अर्पण किंवा सणाचे अर्पण असो. ");
INSERT INTO marc_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","अर्पण आणणार्‍याने याहवेहसमोर एक पाव हीन जैतुनाच्या तेलात मळलेल्या बारीक सपिठाचा एका एफाचा दहावा भाग सादर करावा. ");
INSERT INTO marc_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","होमार्पण किंवा यज्ञासाठी एका कोकराबरोबर, पेयार्पण म्हणून एक पाव हीन द्राक्षारस तयार करावा. ");
INSERT INTO marc_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘मेंढ्याबरोबर एक एफाचे दोन भाग बारीक सपीठ, एकतृतीयांश हीन जैतुनाच्या तेलात मळून अन्नार्पण तयार करावे, ");
INSERT INTO marc_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","आणि अन्नार्पण म्हणून एकतृतीयांश हीन द्राक्षारस, हे सर्व याहवेहला सुवास म्हणून अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘जेव्हा तुम्ही होमार्पण किंवा यज्ञ म्हणून, याहवेहला विशेष नवस किंवा शांत्यर्पण म्हणून एक तरुण बैल तयार करता, ");
INSERT INTO marc_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","बैलाबरोबर एफाचे तीन दशांश बारीक सपीठ, अर्धा हीन जैतुनाच्या तेलात मळलेले असे अन्नार्पण आणावे. ");
INSERT INTO marc_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","आणि पेयार्पण म्हणून अर्धा हीन द्राक्षारस आणावा. हे याहवेहसाठी सुवासिक असे अन्नार्पण आहे. ");
INSERT INTO marc_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","प्रत्येक बैल किंवा मेंढा, प्रत्येक कोकरू किंवा तरुण बोकड अशा प्रकारे तयार करावे. ");
INSERT INTO marc_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","जितक्यांदा तुम्ही हे तयार करता, प्रत्येकासाठी असेच करावे. ");
INSERT INTO marc_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘देशाच्या प्रत्येक रहिवासीने याहवेहला सुवासिक अन्नार्पण सादर करताना या गोष्टी अशाच पद्धतीने कराव्या. ");
INSERT INTO marc_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","जेव्हा कोणी परदेशी किंवा तुमच्यामधील कोणीही इतर रहिवासी याहवेहला सुवासिक अन्नार्पण सादर करतात, त्यांनीही तुम्ही ज्याप्रकारे करतात, त्याच पद्धतीने करावे, हे पुढील सर्व पिढ्यांपर्यंत असावे. ");
INSERT INTO marc_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","समुदायाने स्वतःसाठी व तुमच्यामध्ये असलेल्या परदेशीयांसाठी सारखेच नियम पाळावे. येणार्‍या पिढ्यांसाठी हा सर्वकाळचा नियम असावा. तुम्ही व परदेशी याहवेहसमोर सारखेच आहात. ");
INSERT INTO marc_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","तुमच्यासाठी व तुमच्यामध्ये असलेल्या परदेशीयांसाठी एकच नियम व कायदे असावेत.’ ” ");
INSERT INTO marc_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इस्राएली लोकांशी बोल व त्यांना सांग: ज्या देशात मी तुम्हाला घेऊन जात आहे त्यात तुम्ही जेव्हा जाल ");
INSERT INTO marc_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","आणि त्या भूमीचे फळ खाल, तेव्हा त्याचा एक भाग याहवेहसमोर सादर करावा. ");
INSERT INTO marc_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","तुमच्या मळलेल्या पिठाची पहिली भाकर सादर करावी आणि ती खळ्यातील अर्पण म्हणून सादर करावी. ");
INSERT INTO marc_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","तुमच्या मळलेल्या पिठाच्या पहिल्या भागाचे हे अर्पण तुम्ही याहवेहला तुमच्या भावी पिढ्यांपर्यंत करावे. ");
INSERT INTO marc_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘आता जर तुम्ही एक समुदाय म्हणून याहवेहने मोशेला दिलेल्या या आज्ञांपैकी कोणतीही आज्ञा पाळण्यास नकळतपणे अपयशी ठरला— ");
INSERT INTO marc_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ज्या आज्ञा याहवेहने मोशेद्वारे तुम्हाला दिलेल्या आहेत, ज्या दिवशी त्या दिल्या तेव्हापासून भविष्यातही येणार्‍या पिढ्यांसाठी त्या असतील— ");
INSERT INTO marc_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","आणि जर समुदाय जागृत नसताना हे नकळत घडले असेल, तर संपूर्ण समुदायाने एका तरुण गोर्‍ह्याचे याहवेहला सुवासिक होमार्पण करावे आणि त्याबरोबरचे अन्नार्पण व पेयार्पण आणि पापार्पणासाठी एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","याजकाने सर्व इस्राएली समुदायासाठी प्रायश्चित्त करावे, म्हणजे त्यांची क्षमा होईल; कारण त्यांनी मुद्दाम पाप केले नव्हते आणि त्यांनी याहवेहला आपल्या पापाबद्दल अन्नार्पण व पापार्पण सादर केले आहेत. ");
INSERT INTO marc_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","सर्व इस्राएली समुदाय व त्यामध्ये राहणारे परदेश्यांची क्षमा केली जाईल, कारण सर्वांनी जे पाप केले ते नकळत झाले होते. ");
INSERT INTO marc_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘परंतु जर केवळ एकाच व्यक्तीने नकळत पाप केले असेल, तर त्या व्यक्तीने पापार्पणासाठी एक वर्षाची शेळी आणावी. ");
INSERT INTO marc_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ज्या व्यक्तीने नकळत पाप केले आहे त्या व्यक्तीसाठी याजकाने याहवेहसमोर प्रायश्चित्त करावे आणि जेव्हा प्रायश्चित केले जाईल, तेव्हा त्या व्यक्तीला क्षमा करण्यात येईल. ");
INSERT INTO marc_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","जे कोणी नकळत पाप करतील त्यांच्यासाठी हाच एक नियम लागू असावा, ती व्यक्ती जन्मतः इस्राएली असो किंवा तुमच्यामध्ये राहणारा परदेशी असो. ");
INSERT INTO marc_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘परंतु जे कोणीही मुद्दाम पाप करतात, ते स्वदेशी असो किंवा परदेशी, ते याहवेहविषयी दुर्भाषण करतात, त्यांचे इस्राएली लोकांतून उच्छेदन करावे. ");
INSERT INTO marc_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","कारण त्यांनी याहवेहच्या शब्दाला तुच्छ मानले आहे आणि याहवेहच्या आज्ञा मोडल्या आहेत, त्यांचे खचितच उच्छेदन करावे; त्यांचा दोष त्यांच्यावर राहील.’ ” ");
INSERT INTO marc_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","इस्राएली लोक रानात असताना, एक मनुष्य शब्बाथ दिवशी लाकडे गोळा करीत असताना सापडला. ");
INSERT INTO marc_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","तेव्हा ज्यांनी त्याला लाकडे गोळा करताना पकडले, त्यांनी त्याला मोशे, अहरोन व सर्व मंडळीसमोर आणले, ");
INSERT INTO marc_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","आणि त्यांनी त्याला ताब्यात ठेवले, कारण त्याचे काय करावे याविषयी त्यांना काही स्पष्ट माहीत नव्हते. ");
INSERT INTO marc_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","मग याहवेह मोशेला म्हणाले, “त्या मनुष्याने मरावे. सर्व मंडळीने त्याला छावणीबाहेर धोंडमार करावा.” ");
INSERT INTO marc_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","मग मोशेला याहवेहने दिलेल्या आज्ञेप्रमाणे मंडळीने त्याला छावणीबाहेर नेऊन तो मरेपर्यंत धोंडमार केली. ");
INSERT INTO marc_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“इस्राएली लोकांशी बोल व त्यांना सांग: येणार्‍या सर्व पिढ्यांपर्यंत तुम्ही आपल्या वस्त्राच्या काठांना गोंडे लावावे, प्रत्येक गोंड्यावर निळा दोरा असावा. ");
INSERT INTO marc_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ते यासाठी की तुम्ही त्यांच्याकडे पाहावे व याहवेहच्या सर्व आज्ञांचे तुम्हाला स्मरण व्हावे, म्हणजे तुम्ही त्यांचे पालन करावे आणि आपल्या अंतःकरणाच्या व डोळ्यांच्या वासनांच्या मागे लागून व्यभिचार करू नये. ");
INSERT INTO marc_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","मग तुम्हाला माझ्या सर्व आज्ञांचे पालन करण्याची आठवण राहील आणि तुम्ही तुमच्या परमेश्वरासाठी पवित्र राहाल. ");
INSERT INTO marc_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","तुमचा परमेश्वर व्हावे म्हणून ज्याने तुम्हाला इजिप्तमधून बाहेर आणले तो मीच याहवेह आहे. मीच याहवेह तुमचा परमेश्वर आहे.” ");
INSERT INTO marc_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","लेवीचा पुत्र कोहाथ, त्याचा पुत्र इसहार, त्याचा पुत्र कोरह, आणि रऊबेन गोत्रातील काही लोक म्हणजे एलियाबाचे पुत्र दाथान व अबीराम व पेलेथाचा पुत्र ओन हे उन्मत्त झाले ");
INSERT INTO marc_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","आणि मोशेविरुद्ध उठले. त्यांच्याबरोबर समाजाचे सुपरिचित व मंडळीचे नेमलेले पुढारी असे दोनशे पन्नास इस्राएली पुरुष होते. ");
INSERT INTO marc_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ते एकजूट होऊन मोशे व अहरोन यांच्याकडे आले व त्यांना म्हणाले, “तुमचे आता फार झाले आहे! सर्व समुदाय व त्यातील प्रत्येकजण पवित्र आहे आणि याहवेह त्यांच्याबरोबर आहेत. मग तुम्ही स्वतःला याहवेहच्या मंडळीपेक्षा उच्च का मानता?” ");
INSERT INTO marc_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","जेव्हा मोशेने हे ऐकले, तेव्हा तो पालथा पडला. ");
INSERT INTO marc_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","मग तो कोरह आणि त्याच्या अनुयायांना म्हणाला, “सकाळी याहवेह त्यांचे लोक कोण आहेत आणि कोण पवित्र आहेत हे दाखवतील आणि याहवेह त्या व्यक्तीला आपल्याजवळ आणतील. ज्या पुरुषाला याहवेह निवडतील त्याला याहवेह आपल्याजवळ आणतील. ");
INSERT INTO marc_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","तर कोरहा, तू आणि तुझ्या सर्व अनुयायांनी असे करावे: धुपाटणे घ्या ");
INSERT INTO marc_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","आणि उद्या त्यात जळते निखारे व धूप टाकून ती याहवेहपुढे ठेवा. ज्याला याहवेह निवडतील तोच पुरुष पवित्र ठरेल. लेवींच्या वंशजांनो, तुमचे आता फार झाले आहे!” ");
INSERT INTO marc_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","मोशे कोरहाला हे सुद्धा म्हणाला, “लेवीच्या वंशजांनो आता ऐका! ");
INSERT INTO marc_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","तुम्ही याहवेहच्या निवासमंडपाची सेवा करावी, मंडळीपुढे राहून तिची सेवा करावी म्हणून इस्राएली लोकांच्या परमेश्वराने तुम्हाला इस्राएलच्या इतर लोकांमधून वेगळे केले आहे आणि आपल्याजवळ घेतले ते तुम्हाला पुरेसे नाही काय? ");
INSERT INTO marc_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","त्यांनी तुला व तुझ्याच लेवी घराण्यातील भाऊबंदांना आपल्याजवळ घेतले, परंतु तुम्ही आता याजकपद सुद्धा घेऊ इच्छिता. ");
INSERT INTO marc_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","तू व तुझे सर्व अनुयायी असे एकत्र आला ते याहवेहच्या विरोधात आहे. अहरोन कोण आहे की तुम्ही त्याच्या विरोधात कुरकुर करावी?” ");
INSERT INTO marc_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","मग मोशेने एलियाबाचे पुत्र दाथान व अबीराम यांना बोलाविले. परंतु त्यांनी म्हटले, “आम्ही येणार नाही! ");
INSERT INTO marc_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","दूध व मध वाहत असलेल्या देशातून तू आम्हाला या रानात मारण्यास आणले ते पुरे नाही काय? आणि आता तुला आमच्यावर प्रभुत्व करावयाचे आहे! ");
INSERT INTO marc_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","त्या शिवाय, तू आम्हाला दूध व मध वाहणार्‍या देशात आणले नाहीस किंवा आम्हाला शेतीचे व द्राक्षमळ्यांचे वतन दिले नाहीस. या पुरुषांना तू गुलाम समजतोस काय? नाही, आम्ही येणार नाही!” ");
INSERT INTO marc_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","मग मोशे खूप संतापला आणि याहवेहला म्हणाला, “त्यांच्या अर्पणांचा स्वीकार करू नका. त्यांच्या एका गाढवाची देखील मी चोरी केली नाही आणि त्यांच्यातील एकालाही दुखविले नाही.” ");
INSERT INTO marc_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","पुढे मोशे कोरहाला म्हणाला, “उद्या तुला अनुसरणाऱ्या सर्वांना घेऊन तू येथे याहवेहसमोर ये. तू आणि ते व अहरोनही त्यावेळी हजर असेल. ");
INSERT INTO marc_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","प्रत्येकाने असे सर्व मिळून आपआपल्या दोनशे पन्नास धुपाटण्या धुपासह याहवेहसमक्ष घेऊन यावे. अहरोन त्याचे आणि तू तुझे धुपाटणे घेऊन हजर व्हावे.” ");
INSERT INTO marc_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","याप्रमाणे प्रत्येकाने आपले धुपाटणे घेतले, त्यात जळते निखारे व धूप टाकला आणि ते मोशे आणि अहरोन यांच्याबरोबर सभामंडपाच्या प्रवेशद्वाराजवळ येऊन थांबले. ");
INSERT INTO marc_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","जेव्हा कोरहाने त्यांच्याविरुद्ध असून त्याला अनुसरणाऱ्या सर्वांना सभामंडपाच्या प्रवेशद्वाराजवळ जमविले, याहवेहचे वैभव संपूर्ण समुदायासमक्ष प्रगट झाले. ");
INSERT INTO marc_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","याहवेह, मोशे व अहरोन यांना म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“तुम्ही या लोकांच्या समुदायापासून दूर व्हा म्हणजे मी क्षणार्धात त्यांचा नाश करेन.” ");
INSERT INTO marc_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","पण मोशे आणि अहरोन याहवेहपुढे जमिनीवर पालथे पडले व विनंती करून म्हणाले “हे परमेश्वरा, सर्व जीवधार्‍यांना जीवनाचा श्वास प्रदान करणाऱ्या परमेश्वरा, एकाच मनुष्याने पाप केले तरी तुम्ही सर्व लोकांवर रागावणार काय?” ");
INSERT INTO marc_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","नंतर याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“कोरह, दाथान आणि अबीराम यांच्या तंबूपासून सर्व समुदायाला दूर व्हावयाला सांग.” ");
INSERT INTO marc_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","तेव्हा मोशे दाथान व अबीराम यांच्या तंबूकडे धावत गेला. त्याच्यामागे इस्राएली पुढारीही गेले. ");
INSERT INTO marc_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","त्वरा करा, मोशे समुदायाला म्हणाला, “या दुष्ट माणसांच्या तंबूंपासून दूर व्हा. त्यांच्या मालकीच्या कोणत्याही वस्तूला स्पर्श करू नका. नाहीतर त्यांच्या पापामुळे त्यांच्याबरोबर तुमचाही नाश होईल.” ");
INSERT INTO marc_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","मग कोरह, दाथान व अबीराम यांच्या तंबूंपासून ते दूर गेले. दाथान व अबीराम हे आपल्या पत्नी, मुले व तान्ही बाळे यांच्यासह आपआपल्या तंबूंच्या दारांशी येऊन उभे राहिले. ");
INSERT INTO marc_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","त्यावर मोशे म्हणाला, “ज्यागोष्टी मी करतो त्या करण्यास मला याहवेहने पाठविले आहे. हे माझ्या मनाचे विचार नाहीत, हे तुम्हाला यावरून समजेल: ");
INSERT INTO marc_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","जर हे लोक नैसर्गिक कारणाने अपघाताने मरण पावले, तर याहवेहने मला पाठविले नाही. ");
INSERT INTO marc_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","परंतु याहवेहने चमत्कार केला आणि या भूमीने आपले तोंड उघडून या लोकांना त्यांच्या सर्व मालमत्तेसह जिवंतपणे अधोलोकात गिळून टाकले, तर या लोकांनी याहवेहला तुच्छ मानले आहे, हे तुम्हाला समजून येईल.” ");
INSERT INTO marc_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","त्याचे हे बोलणे संपताच, त्या लोकांच्या पायाखालची जमीन एकदम दुभागली ");
INSERT INTO marc_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","आणि कोरह व त्याचे तंबू त्यांची कुटुंबे आणि त्यांच्याजवळ उभे असलेले त्यांचे मित्र व त्यांच्या सर्व मालमत्तेसह पृथ्वीने गिळून टाकले. ");
INSERT INTO marc_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ते जिवंतपणीच अधोलोकात गेले आणि त्यांचा व त्यांच्या मालकीचे जे होते त्यांचा नाश झाला; मग जमीन पूर्ववत झाली, त्यांचा नाश होऊन ते सर्वजण समुदायातून नाहीसे झाले. ");
INSERT INTO marc_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","त्यांच्या आक्रोशामुळे, “पृथ्वी आपल्यालाही गिळून टाकील!” असे म्हणत इस्राएली लोक भीतीने ओरडत पळत सुटले. ");
INSERT INTO marc_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","नंतर याहवेहपासून अग्नी निघाला आणि त्याने धूपाचे अर्पण करणार्‍या त्या दोनशे पन्नास पुरुषांना भस्म केले. ");
INSERT INTO marc_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“अहरोन याजकाचा पुत्र एलअज़ारला अग्नीमधून सर्व धुपाटणी ओढून घेण्यास सांगावे. कारण ती पवित्र असून याहवेहला समर्पित केलेली आहेत. त्याचप्रमाणे त्याने तो जळका धूपही थोड्या अंतरावर विखरून टाकावा. ");
INSERT INTO marc_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ज्या लोकांनी आपला जीव धोक्यात घालून पाप केले होते, त्या लोकांच्या धुपाटण्यांतील हा धूप विखरून टाकावा. नंतर वेदीला आच्छादन म्हणून त्या धुपाटण्याचे रुंद पत्रे तयार करावेत, कारण ती धुपाटणी याहवेहपुढे वापरली असल्यामुळे पवित्र आहेत. वेदीवरील हा पत्रा इस्राएली लोकांना या प्रसंगाचे चिन्ह म्हणून राहील.” ");
INSERT INTO marc_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","त्याप्रमाणे एलअज़ार याजकाने ती दोनशे पन्नास कास्याची धुपाटणी घेतली आणि ती ठोकून वेदीला आच्छादन करण्याकरिता त्यांचा पत्रा तयार केला. ");
INSERT INTO marc_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","कोरह आणि त्याचे सोबत्यांची जी दशा झाली, तशी वेदीपुढे अनाधिकृतपणे धूप जाळणार्‍या म्हणजे अहरोनाचा वंशज नसलेल्या इतर कोणत्याही व्यक्तीची होऊ नये, याची आठवण इस्राएली लोकांना देण्याकरिता ते वेदीवरील आच्छादन होते. याप्रमाणे याहवेहने मोशेला दिलेल्या आज्ञा पाळण्यात आल्या. ");
INSERT INTO marc_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","पण दुसर्‍याच दिवशी सकाळी सर्व इस्राएली लोक मोशे आणि अहरोन यांच्याविरुद्ध पुन्हा कुरकुर करू लागले. ते त्यांना म्हणाले, “तुम्हीच याहवेहच्या लोकांना मारून टाकले.” ");
INSERT INTO marc_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","लवकरच तिथे मोशे व अहरोनाच्या विरुद्ध समुदाय जमला. तेवढ्यात एकाएकी सभामंडपावर मेघ उतरून याहवेहचे गौरव पसरल्याचे त्यांना दिसले. ");
INSERT INTO marc_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","मोशे आणि अहरोन सभामंडपाच्या दाराशी येऊन उभे राहिले; ");
INSERT INTO marc_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","आणि याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“या लोकांपासून दूर व्हा म्हणजे मला त्यांचा क्षणात नाश करता येईल.” आणि ते जमिनीवर पालथे पडले. ");
INSERT INTO marc_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","नंतर मोशे अहरोनाला म्हणाला, “त्वरा कर. एक धुपाटणे घे. वेदीवरील अग्नी त्यावर ठेव. त्यावर धूप टाक आणि लोकांसाठी प्रायश्चित्त कर. कारण याहवेहचा कोप त्यांच्यावर भडकला आहे आणि पीडा सुरू झाली आहे.” ");
INSERT INTO marc_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","मोशेने सांगितल्याप्रमाणे अहरोनाने केले. तो लोकांमध्ये पळत गेला, कारण पीडा त्यांच्यामध्ये सुरू झाली होती. त्याने धूप जाळले आणि लोकांसाठी प्रायश्चित्त केले. ");
INSERT INTO marc_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","मग तो मृतांच्या आणि जिवंतांच्यामध्ये उभा राहिला आणि पीडा थांबली. ");
INSERT INTO marc_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","परंतु त्याअगोदरच 14,700 लोक मरण पावले होते. आदल्याच दिवशी कोरहाबरोबर मेलेल्या लोकांव्यतिरिक्त हे आणखी लोक मरण पावले होते. ");
INSERT INTO marc_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","यानंतर अहरोन मोशेकडे सभामंडपाच्या दाराशी परत आला, कारण पीडा थांबली होती. ");
INSERT INTO marc_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इस्राएली लोकांशी बोल व त्यांच्याकडून त्यांच्या पूर्वजांच्या गोत्रांप्रमाणे प्रत्येक पुढार्‍याकडून एक काठी अशा बारा काठ्या घे. प्रत्येक पुरुषाचे नाव त्याच्या काठीवर लिही. ");
INSERT INTO marc_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","लेवी वंशाच्या काठीवर अहरोनाचे नाव लिही, कारण प्रत्येक पूर्वजांच्या गोत्राच्या पुढार्‍याची एक काठी असावी. ");
INSERT INTO marc_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","सभामंडपात जिथे मी तुझी भेट घेत असतो, तिथे कराराच्या नियमाच्या कोशापुढे त्या काठ्या ठेवाव्या. ");
INSERT INTO marc_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ज्या पुरुषाची मी निवड करेन त्याच्या काठीला अंकुर फुटेल आणि इस्राएली लोक तुमच्याविरुद्ध सातत्याने जी कुरकुर करतात त्यापासून मी स्वतःची सुटका करेन.” ");
INSERT INTO marc_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","म्हणून मोशे इस्राएली लोकांशी बोलला आणि त्यांच्या पुढार्‍यांनी त्याला बारा काठ्या दिल्या, त्यांच्या पूर्वजांच्या गोत्रांप्रमाणे प्रत्येक पुढार्‍याकडून एक काठी आणि त्यांच्यामध्ये एक अहरोनाची काठी होती. ");
INSERT INTO marc_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मोशेने त्या काठ्या कराराच्या नियमाच्या मंडपात याहवेहसमोर ठेवल्या. ");
INSERT INTO marc_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","दुसर्‍या दिवशी मोशे मंडपात गेला आणि अहरोनाची काठी जी लेवी वंशाच्या वतीने ठेवली होती, ती केवळ अंकुरितच नव्हे तर त्याला कळी आली असून तिच्यावर बदाम पिकलेले दिसले. ");
INSERT INTO marc_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","मग मोशेने त्या सर्व काठ्या याहवेहच्या समक्षतेतून इस्राएली लोकांकडे आणल्या. त्यांनी त्या पाहिल्या आणि प्रत्येक पुढार्‍याने आपआपली काठी घेतली. ");
INSERT INTO marc_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","तेव्हा याहवेह मोशेला म्हणाले, “अहरोनाची काठी कराराच्या नियमाच्या कोशापुढे परत ठेव, बंड करणार्‍यांना चिन्ह म्हणून ती तिथे ठेवावी. अशाने माझ्याविरुद्ध करीत असलेल्या त्यांच्या कुरकुरीचा शेवट होईल, म्हणजे ते मरणार नाहीत.” ");
INSERT INTO marc_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","याहवेहने आज्ञा केल्याप्रमाणेच मोशेने केले. ");
INSERT INTO marc_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","इस्राएली लोक मोशेला म्हणाले, “आम्ही मरून जाऊ! आम्ही हरलो आहोत, आम्ही सर्व हरलो आहोत! ");
INSERT INTO marc_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","जो कोणी याहवेहच्या निवास मंडपाजवळ जरी येईल तरी त्याचा नाश होईल. आम्ही सर्व मरणार आहोत का?” ");
INSERT INTO marc_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","याहवेह अहरोनाला म्हणाले, “पवित्रस्थानासंबंधी झालेल्या अन्यायास तू, तुझे पुत्र आणि तुझे घराणे जबाबदार असणार व याजकपणासंबंधीच्या अपराधासही तू व तुझे पुत्र जबाबदार असणार. ");
INSERT INTO marc_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","तू व तुझे पुत्र कराराच्या नियमाच्या कोशापुढे जेव्हा सेवा करतात तेव्हा तुझ्याशी जडून व तुला मदत करण्यासाठी लेवी वंशातील, तुझ्या पूर्वजांच्या गोत्रातील तुझ्या बांधवांना आपल्यासोबत आण. ");
INSERT INTO marc_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ते तुला जबाबदार असणार व त्यांनी मंडपातील सर्व कर्तव्ये पार पाडावीत, परंतु त्यांनी पवित्रस्थानाच्या पात्रांजवळ किंवा वेदीजवळ जाऊ नये. नाहीतर ते व तुम्हीही मृत व्हाल. ");
INSERT INTO marc_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","त्यांनी तुझ्याशी जडून सभामंडपाच्या सेवेसंबंधी—म्हणजेच मंडपातील सर्व कामासंबंधी जबाबदार असावे—आणि जिथे तू असणार तिथे इतर कोणीही जवळ येऊ नये. ");
INSERT INTO marc_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“पवित्रस्थान व वेदीच्या सेवेसंबंधी तू जबाबदार असावे, यासाठी की इस्राएली लोकांवर माझा क्रोध पुन्हा भडकू नये. ");
INSERT INTO marc_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","इस्राएली लोकांतून सभामंडपातील सेवाकार्य करण्यासाठी, याहवेहसाठी समर्पित म्हणून लेवी वंशातील तुझे सोबती तुझ्यासाठी भेट म्हणून निवडले आहेत. ");
INSERT INTO marc_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","परंतु वेदी व आतील पडद्यासंबंधी केवळ तू व तुझ्या पुत्रांनीच याजक म्हणून पवित्रस्थानातील पडद्यामागील आणि वेदीवरील पवित्र सेवा करावी. याजकपणाची सेवा मी तुला भेट म्हणून देत आहे. इतर कोणीही जे पवित्रस्थानाच्या जवळ येतील त्यांना जिवे मारावे.” ");
INSERT INTO marc_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","याहवेह अहरोनाला म्हणाले, मला सादर केलेल्या अर्पणांवर मी स्वतः तुला प्रभारी नेमले आहे; सर्व पवित्र अर्पणे जी इस्राएली लोक मला देतात ती मी तुला व तुझ्या पुत्रांना तुमचा वाटा, तुमचा शाश्वत भाग म्हणून देत आहे. ");
INSERT INTO marc_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","जो अग्नीपासून राखला जातो तो अर्पणातील परमपवित्र भाग तुझा व्हावा. परमपवित्र अर्पणे म्हणून ते माझ्यासाठी जे आणतात त्या सर्वांतून, ती अन्नार्पणे किंवा पापार्पणे किंवा दोषार्पणे असो, तो वाटा तुझा व तुझ्या पुत्रांचा आहे. ");
INSERT INTO marc_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","जसे परमपवित्र वस्तूतील, तसे ते खावे; प्रत्येक पुरुषाने ते खावे, ते तुम्ही पवित्र मानावे. ");
INSERT INTO marc_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","हे देखील तुझे असावे: इस्राएली लोकांच्या हेलावणीच्या अर्पणातील ज्या भेटी बाजूला काढून ठेवल्या जातात, त्या मी तुला व तुझ्या पुत्रांना व तुझ्या कन्यांना तुमचा शाश्वत वाटा म्हणून देतो. तुझ्या घरातील जे कोणी विधीनुसार शुद्ध असतील त्या प्रत्येकाने ते खावे. ");
INSERT INTO marc_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","जैतुनाचे सर्वोत्तम तेल आणि सगळा उत्तम नवा द्राक्षारस आणि धान्याच्या हंगामाचे प्रथमफळ म्हणून याहवेहला लोक देतात ते मी तुला देत आहे. ");
INSERT INTO marc_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","आपल्या भूमीचे सर्व प्रथमफळ लोक याहवेहकडे आणतात ते तुझे होईल. तुझ्या घरातील जे कोणी विधीनुसार शुद्ध आहेत त्या प्रत्येकाने ते खावे. ");
INSERT INTO marc_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","इस्राएलात याहवेहला समर्पित केलेली प्रत्येक वस्तू तुझी होईल. ");
INSERT INTO marc_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","उदरातून जन्मलेले प्रत्येक प्रथम जन्मलेले संतान, जे याहवेहला अर्पिलेले आहेत, मग ते मनुष्याचे असो किंवा जनावरांचे, ते तुझे होतील. परंतु प्रत्येक प्रथम जन्मलेल्या पुत्राला व प्रत्येक अशुद्ध जनावराच्या नर वत्साला तू खंडणी भरून सोडवावे. ");
INSERT INTO marc_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ते एक महिन्याचे झाल्यावर, पवित्रस्थानाच्या शेकेलानुसार ठरवलेली खंडणीची किंमत जी पाच चांदीचे शेकेल, म्हणजेच वीस गेरा भरून त्यांची खंडणी भरावी. ");
INSERT INTO marc_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","गाईचे, मेंढीचे व शेळीचे प्रथमवत्स यांची तू खंडणी भरू नये; ते पवित्र आहे. त्यांचे रक्त वेदीवर शिंपडावे आणि त्यांची चरबी अन्नार्पण म्हणून जाळावी. हा याहवेहला संतोषविणारा सुगंध आहे. ");
INSERT INTO marc_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","जसे ओवाळणीचा छातीचा भाग व उजवी मांडी तुझे आहेत, त्याचप्रमाणे त्यांचे मांस सुद्धा तुझ्या वाट्याचे होईल. ");
INSERT INTO marc_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","इस्राएली लोक याहवेहसाठी जी पवित्र अर्पणे आणतात, त्यातील जे काही बाजूला काढून ठेवले जाते, ते मी तुला आणि तुझ्या पुत्रांना व तुझ्या कन्यांना शाश्वत वाटा म्हणून देत आहे. हा याहवेहसमोर तुझ्यासाठी व तुझ्या संतानांसाठी सर्वकाळचा मिठाच्या करार आहे. ");
INSERT INTO marc_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","याहवेहने अहरोनाला म्हटले, “त्यांच्या देशात तुला वतन असणार नाही किंवा तुला त्यांच्यात कोणताही वाटा असणार नाही; इस्राएलमध्ये मी तुझा वाटा व तुझे वतन आहे.” ");
INSERT INTO marc_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","लेवी वंश सभामंडपाची सेवा करताना जी कामे करतात त्याचा मोबदला म्हणून इस्राएलातून येणारा सर्व दशांश मी त्यांना त्यांचे वतन असे देत आहे. ");
INSERT INTO marc_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","येथून पुढे इस्राएली लोकांनी सभामंडपाजवळ जाऊ नये, नाहीतर त्यांच्या पापाचा परिणाम त्यांना भोगावा लागेल व ते मरतील. ");
INSERT INTO marc_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","लेवी लोक सभामंडपामध्ये सेवा करतील आणि त्याविरोधात केलेल्या अपराधाची जबाबदारी ते स्वतः वाहतील. येणार्‍या पिढ्यांपर्यंत हा सर्वकाळचा नियम असेल. इस्राएलमध्ये त्यांना वतन मिळणार नाही. ");
INSERT INTO marc_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","त्याऐवजी इस्राएली लोक जो दशांश अर्पण म्हणून याहवेहला सादर करतात तो मी लेवींना वतन म्हणून देत आहे. म्हणूनच त्यांच्याबद्दल मी म्हटले: “त्यांना इस्राएलमध्ये वतन नसणार.” ");
INSERT INTO marc_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“लेवी लोकांशी बोल व त्यांना सांग: ‘इस्राएलातून जो दशांश मी तुम्हाला तुमचे वतन म्हणून देतो, जेव्हा तो तुम्हाला मिळतो, त्या दशमांशातील दहावा हिस्सा याहवेहचे अर्पण म्हणून सादर करावा. ");
INSERT INTO marc_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","तुमचे अर्पण खळ्यातील धान्य किंवा द्राक्षकुंडातील रसाप्रमाणे तुमच्यासाठी गणले जाईल. ");
INSERT INTO marc_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","याप्रकारे इस्राएलातून जो दशांश तुम्हाला मिळतो त्यातून तुम्ही सुद्धा आपले अर्पण याहवेहला सादर करावे. या दशमांशातील जो याहवेहचा वाटा तो तुम्ही अहरोन याजकाला द्यावा. ");
INSERT INTO marc_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","तुम्हाला दिलेल्या प्रत्येक वस्तूतील सर्वोत्तम आणि अतिपवित्र भाग याहवेहचा भाग म्हणून तुम्ही सादर करावा.’ ");
INSERT INTO marc_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“लेव्यांना सांग: ‘जेव्हा तुम्ही सर्वोत्तम भाग सादर करतात, ते तुमच्यासाठी खळ्यातील किंवा द्राक्षकुंडातील उत्पन्न गणले जाईल. ");
INSERT INTO marc_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","बाकीच्या अर्पणातून तू व तुझ्या घराण्याने कोणत्याही ठिकाणी खावे, कारण सभामंडपातील तुमच्या सेवेसाठी असलेले ते तुमचे वेतन आहे. ");
INSERT INTO marc_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","सर्वोत्तम भाग सादर केल्यामुळे तुम्ही याबाबतीत दोषी ठरणार नाही; मग तुम्ही इस्राएली लोकांची अर्पणे विटाळविणार नाही व तुम्ही मरणार नाही.’ ” ");
INSERT INTO marc_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","याहवेह मोशे आणि अहरोनला म्हणाले: ");
INSERT INTO marc_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“याहवेहने आज्ञापिलेल्या कराराचा हा एक नियम आहे: इस्राएली लोकांस सांग की, जी अव्यंग किंवा निर्दोष आणि जिच्यावर कधीही जू घातले नाही अशी तांबड्या रंगाची कालवड त्यांनी तुमच्याकडे आणावी. ");
INSERT INTO marc_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ती एलअज़ार याजकाकडे द्यावी; तिला छावणीबाहेर न्यावे व त्याच्यासमोर कालवडीचा वध करावा. ");
INSERT INTO marc_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","त्यानंतर एलअज़ार याजकाने तिचे थोडे रक्त आपल्या बोटावर घ्यावे व सभामंडपाच्या समोरील बाजूस सात वेळा ते शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","एलअज़ार याजकादेखत ती कालवड; तिचे कातडे, मांस, रक्त व आतडे यासह जाळण्यात यावी. ");
INSERT INTO marc_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","याजकाने गंधसरूचे लाकूड, एजोब आणि किरमिजी लोकरीचा दोरा घेऊन त्या जळत्या कालवडीवर टाकावा. ");
INSERT INTO marc_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","त्यानंतर याजकाने आपली वस्त्रे धुवावी व पाण्याने आंघोळ करावी. मग त्याने छावणीत यावे, परंतु विधीनुसार संध्याकाळपर्यंत त्याने अशुद्ध राहावे. ");
INSERT INTO marc_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","जो पुरुष ती कालवड जाळतो त्यानेही आपली वस्त्रे धुवावी व पाण्याने आंघोळ करावी आणि त्यानेही संध्याकाळपर्यंत अशुद्ध राहावे. ");
INSERT INTO marc_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“शुद्ध असलेल्या एका पुरुषाने कालवडीची राख गोळा करावी व छावणीबाहेर विधीनुसार शुद्ध असलेल्या ठिकाणी ठेवावी. ही राख इस्राएली समाजाने शुद्धीकरणाच्या पाण्यामध्ये वापरावी; ते पापक्षालनासाठी आहे. ");
INSERT INTO marc_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","जो मनुष्य कालवडीची राख गोळा करतो त्यानेही आपली वस्त्रे धुवावी व त्यानेही संध्याकाळपर्यंत अशुद्ध राहावे. इस्राएली लोक आणि त्यांच्यामध्ये राहणारे परदेशीय लोक यांच्यासाठी हा सर्वकाळचा नियम असावा. ");
INSERT INTO marc_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“जो कोणी मानवी मृतदेहाला स्पर्श करतो, त्यांनी सात दिवस अशुद्ध राहावे. ");
INSERT INTO marc_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","त्यांनी तिसर्‍या दिवशी व सातव्या दिवशी स्वतःला पाण्याने शुद्ध करावे; मग ते शुद्ध होतील. पण तिसर्‍या दिवशी व सातव्या दिवशी त्यांनी स्वतःला शुद्ध केले नाही, तर ते अशुद्धच असतील. ");
INSERT INTO marc_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","मानवी मृतदेहाला स्पर्श केल्यानंतरही जर त्यांनी स्वतःला शुद्ध केले नाही, तर ते याहवेहचा निवासमंडप विटाळवितात. इस्राएली लोकांमधून त्यांना काढून टाकले जावे. कारण शुद्ध करणारे पाणी त्याच्यावर शिंपडले गेले नाही, ते अशुद्ध आहेत; त्यांचा अशुध्दपणा त्यांच्यावर तसाच राहतो. ");
INSERT INTO marc_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“एखादा मनुष्य जेव्हा तंबूमध्ये मरण पावतो त्यावेळी पाळावयाचा नियम हा: जो कोणी त्या तंबूमध्ये प्रवेश करतो आणि जो कोणी तंबूत आहे त्यांनी सात दिवस अशुद्ध राहावे, ");
INSERT INTO marc_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","आणि दोरीने झाकण न बांधलेले प्रत्येक उघडे पात्र अशुद्ध असावे. ");
INSERT INTO marc_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“जो कोणी मोकळ्या मैदानात तलवारीने मारलेल्या व्यक्तीच्या शवाला स्पर्श करतो किंवा कोणी नैसर्गिकरित्या मरण पावलेल्याला किंवा कोणी मानवी हाडाला किंवा कबरेला स्पर्श करतो, त्याने सात दिवस अशुद्ध राहावे. ");
INSERT INTO marc_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“अशुद्ध व्यक्तीसाठी, जाळलेल्या शुद्धतेच्या अर्पणातून थोडी राख घेऊन ती एका पात्रात घेऊन त्यांच्यावर स्वच्छ पाणी ओतावे. ");
INSERT INTO marc_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","आणि जो मनुष्य विधीनुसार शुद्ध आहे, त्याने एजोबाची फांदी घेऊन ती पाण्यात बुचकळावी व ते तंबू व त्याची पात्रे आणि तिथे उपस्थित असलेल्या लोकांवर शिंपडावे. त्याचप्रमाणे ज्यांनी मानवी हाड किंवा कबर किंवा ज्याचा वध झाला किंवा नैसर्गिकरित्या मरण पावलेल्याला स्पर्श केला त्यांच्यावरही ते पाणी शिंपडावे. ");
INSERT INTO marc_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","जो मनुष्य शुद्ध आहे, त्याने अशुद्ध झालेल्या व्यक्तींवर तिसर्‍या व सातव्या दिवशी हे पाणी शिंपडावे आणि सातव्या दिवशी त्याने त्यांना शुद्ध करावे. ज्यांचे शुद्धीकरण होत आहे त्यांनी आपली वस्त्रे धुवावी व पाण्याने आंघोळ करावी आणि त्या संध्याकाळी ते शुद्ध होतील. ");
INSERT INTO marc_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","पण जे अशुद्ध आहेत आणि स्वतःला शुद्ध करीत नाहीत, त्यांना समाजातून काढून टाकले जावे, कारण त्यांनी याहवेहचे पवित्रस्थान विटाळविले आहे. शुद्धतेचे पाणी त्यांच्यावर शिंपडले गेले नाही आणि ते अशुद्ध आहेत. ");
INSERT INTO marc_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","हा त्यांच्यासाठी कायमचा नियम आहे. “जो मनुष्य शुद्धतेचे पाणी शिंपडतो त्यानेही आपली वस्त्रे धुवावीत आणि जो कोणी शुद्धतेच्या पाण्याला स्पर्श करतो तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO marc_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","अशुद्ध व्यक्ती ज्या वस्तूला स्पर्श करेल ती अशुद्ध होईल आणि जो कोणी त्या वस्तूला स्पर्श करेल त्यानेही संध्याकाळपर्यंत अशुद्ध राहावे.” ");
INSERT INTO marc_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","पहिल्या महिन्यात सर्व इस्राएली लोकांचा समुदाय सीन अरण्यात आला आणि त्यांनी कादेश येथे तळ दिला. तिथे मिर्याम मरण पावली व तिला तिथेच पुरण्यात आले. ");
INSERT INTO marc_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","त्या ठिकाणी समुदायासाठी पाणी नव्हते आणि लोक मोशे आणि अहरोन यांच्याविरुद्ध एकत्र आले. ");
INSERT INTO marc_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","लोक मोशेशी भांडण करीत म्हणाले, “याहवेहसमोर आमचे भाऊबंद जेव्हा मरून पडले, तेव्हाच आम्हीही मेलो असतो तर बरे होते! ");
INSERT INTO marc_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","याहवेहच्या समुदायाला तुम्ही या अरण्यात का आणले, आम्ही व आमच्या जनावरांनी मरावे म्हणून आणले काय? ");
INSERT INTO marc_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","इजिप्त देशाबाहेर या भयंकर ठिकाणी तुम्ही आम्हाला का आणले? या ठिकाणी ना धान्य किंवा अंजीर ना द्राक्षवेल किंवा डाळिंबे आहेत आणि प्यायला पाणीही नाही!” ");
INSERT INTO marc_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","मग मोशे व अहरोन मंडळीपुढून निघून सभामंडपाच्या दाराशी गेले व पालथे पडले आणि याहवेहचे तेज त्यांना प्रकट झाले. ");
INSERT INTO marc_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“आपली काठी घे आणि तू व तुझा भाऊ अहरोन मंडळीला एकत्र करा. त्यांच्यासमोर खडकाशी बोल आणि त्यातून पाणी निघेल. तू त्या खडकातून समुदायासाठी पाणी काढशील म्हणजे ते व त्यांचे कळप पाणी पितील.” ");
INSERT INTO marc_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","मोशेने आपली काठी याहवेहच्या उपस्थितीपुढून घेतली आणि जसे आज्ञापिले त्याप्रमाणेच त्याने केले. ");
INSERT INTO marc_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","मोशे आणि अहरोन यांनी मंडळीला खडकासमोर एकत्र केले व मोशे त्यांना म्हणाला, “अहो, बंडखोरांनो, तुम्ही ऐका, या खडकातून आम्ही तुमच्यासाठी पाणी काढावे काय?” ");
INSERT INTO marc_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","मग मोशेने आपला हात उगारला व आपल्या काठीने खडकावर दोनदा वार केला. तेव्हा पाण्याचा मोठा प्रवाह वाहू लागला व समुदायाने आणि त्यांच्या कळपाने पाणी प्याले. ");
INSERT INTO marc_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","परंतु याहवेह मोशे आणि अहरोन यांना म्हणाले, “कारण इस्राएली लोकांच्या दृष्टीत मी पवित्र असावे इतका सन्मान करण्याइतपत तुम्ही माझ्यावर पुरेसा विश्वास ठेवला नाही, मी जो देश त्यांना देऊ करीत आहे त्यात या समुदायाला तुम्ही आणणार नाही.” ");
INSERT INTO marc_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","हे मरीबाहचे पाणी होते, जिथे इस्राएली लोक याहवेहशी भांडले आणि जिथे याहवेह त्यांच्यामध्ये पवित्र असे सिद्ध केले गेले. ");
INSERT INTO marc_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","मोशेने कादेशमधून एदोमाच्या राजाकडे निरोप्यांच्या द्वारे हा संदेश पाठविला: “तुझा भाऊ इस्राएल असे म्हणतो: आमच्यावर आलेल्या सर्व कष्टांविषयी तुला ठाऊक आहे. ");
INSERT INTO marc_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","आमचे पूर्वज खाली इजिप्तमध्ये गेले आणि पुष्कळ वर्षे आम्ही तिथे राहिलो. इजिप्तच्या लोकांनी आम्हाला व आमच्या पूर्वजांना अयोग्य वागणूक दिली, ");
INSERT INTO marc_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","पण आम्ही जेव्हा याहवेहचा धावा केला, तेव्हा याहवेहने आमचे रडणे ऐकले, त्यांनी एक दूत पाठवून आम्हाला इजिप्त देशातून बाहेर आणले. “आता आम्ही इथे तुझ्या सीमेवरील टोकावर, कादेश नगरात आहोत. ");
INSERT INTO marc_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","कृपा करून आम्हाला तुझ्या देशातून जाऊ दे. आम्ही कोणत्याही शेतातून किंवा द्राक्षमळ्यातून जाणार नाही किंवा कोणत्याही विहिरीचे पाणी पिणार नाही. तुझी सीमा ओलांडून जाईपर्यंत आम्ही राजमार्गावरच प्रवास करू.” ");
INSERT INTO marc_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","पण एदोम म्हणाला: “तुम्ही इथून पार जाऊ शकत नाही; जर तुम्ही प्रयत्न केला, तर आम्ही चाल करून तुमच्यावर तलवारीने हल्ला करू.” ");
INSERT INTO marc_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","इस्राएली लोकांनी उत्तर दिले: “आम्ही महामार्गानेच जाऊ आणि जर आम्ही किंवा आमचे कळप तुमचे पाणी प्यालो, तर आम्ही त्याची किंमत भरू. आम्हाला केवळ पायी जायचे आहे; दुसरे काही नाही.” ");
INSERT INTO marc_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","त्यांनी पुन्हा उत्तर दिले: “तुम्ही जाऊ शकत नाही.” तेव्हा एदोम मोठे व सामर्थ्यवान सैन्य घेऊन त्यांच्याविरुद्ध बाहेर आला. ");
INSERT INTO marc_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","एदोमाने त्यांना हद्दीतून पार जाण्यास मनाई केली त्यामुळे इस्राएली त्यांच्यापासून वळून माघारी गेले. ");
INSERT INTO marc_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","संपूर्ण इस्राएली समुदाय कादेशहून निघून होर पर्वतावर आला. ");
INSERT INTO marc_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","एदोमच्या सीमेवर, होर पर्वतावर याहवेह मोशे व अहरोनला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“अहरोन आपल्या लोकांशी जाऊन मिळेल. इस्राएली लोकांना मी जो देश देत आहे त्यात तो प्रवेश करणार नाही, कारण मरीबाहच्या पाण्याकडे तुम्ही दोघांनी माझ्या आज्ञेविरुद्ध बंड केले. ");
INSERT INTO marc_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","अहरोन व त्याचा पुत्र एलअज़ार यांना घेऊन होर पर्वतावर जा. ");
INSERT INTO marc_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","अहरोनाची वस्त्रे काढून ती त्याचा पुत्र एलअज़ारला घाल, कारण तो त्याच्या लोकांशी जाऊन मिळेल; तो तिथे मरण पावेल.” ");
INSERT INTO marc_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","जसे याहवेहने आज्ञापिले त्यानुसार मोशेने केले: सर्व समुदायादेखत ते होर पर्वतावर गेले. ");
INSERT INTO marc_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मोशेने अहरोनाची वस्त्रे उतरविली आणि एलअज़ारावर चढविली आणि अहरोन त्या डोंगराच्या शिखरावर मरण पावला. नंतर मोशे आणि एलअज़ार डोंगरावरून खाली आले, ");
INSERT INTO marc_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","आणि अहरोन मरण पावला असे जेव्हा समुदायाला समजले, तेव्हा सर्व इस्राएलने तीस दिवस शोक केला. ");
INSERT INTO marc_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","इस्राएली लोक अथारीमच्या वाटेने येत आहेत असे नेगेवमध्ये राहत असलेला कनानी राजा अरादने जेव्हा ऐकले, तेव्हा त्याने इस्राएली लोकांवर हल्ला केला व काहींना कैद केले. ");
INSERT INTO marc_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","तेव्हा इस्राएलने याहवेहपुढे ही शपथ घेतली: “जर तुम्ही या लोकांना आमच्या हाती दिले तर आम्ही त्यांची शहरे पूर्णपणे नाश करू.” ");
INSERT INTO marc_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","याहवेहने इस्राएली लोकांची विनंती ऐकली आणि कनानी लोकांना त्यांच्या हाती दिले. त्यांनी त्यांचा व त्यांच्या नगरांचा पूर्णपणे नाश केला; म्हणून त्या ठिकाणाचे नाव होरमाह असे पडले. ");
INSERT INTO marc_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","नंतर इस्राएली लोक होर पर्वताकडून प्रवास करीत एदोमाला वळसा घालून तांबड्या समुद्राच्या वाटेने प्रवास करीत निघाले; परंतु लोक वाटेतच अधीर झाले; ");
INSERT INTO marc_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ते परमेश्वराविरुद्ध व मोशेविरुद्ध कुरकुर करीत बोलू लागले व म्हणाले, “तुम्ही आम्हाला या रानात मरावे म्हणून इजिप्तमधून का आणले? येथे भाकर नाही! पाणी नाही! आणि हे बेचव अन्न आम्हाला नकोसे झाले आहे.” ");
INSERT INTO marc_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","तेव्हा याहवेहने त्यांच्यामध्ये विषारी साप पाठविले; ते लोकांना चावले आणि पुष्कळ इस्राएली लोक मरण पावले. ");
INSERT INTO marc_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","लोक मोशेकडे आले व म्हणाले, “याहवेहविरुद्ध व तुझ्याविरुद्ध बोलून आम्ही पाप केले आहे. याहवेहने हे साप आमच्यापासून दूर घालवून द्यावे म्हणून प्रार्थना कर.” तेव्हा मोशेने लोकांसाठी प्रार्थना केली. ");
INSERT INTO marc_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","तेव्हा याहवेहने मोशेला म्हटले, “सापाची एक प्रतिमा तयार कर आणि ती एका खांबावर टांग; ज्याला साप चावेल त्या व्यक्तीने खांबावर टांगलेल्या सापाकडे पाहिल्यास तो जगेल.” ");
INSERT INTO marc_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","तेव्हा मोशेने कास्याचा साप तयार केला व तो खांबावर टांगला, तेव्हा ज्या कोणाला साप चावला व त्यांनी त्या कास्याच्या सापाकडे पाहिले म्हणजे ते जगत असत. ");
INSERT INTO marc_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","इस्राएली लोक प्रवास करीत पुढे निघाले आणि ओबोथ येथे तिथे त्यांनी तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","नंतर ते ओबोथहून निघाले व पूर्वेकडे मोआबासमोर ईये-अबारीम रानात त्यांनी तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","तिथून निघून त्यांनी जेरेद खोर्‍यात तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","नंतर तिथून निघून, अमोर्‍यांच्या रानातील सीमेतून निघणाऱ्या आर्णोन नदीजवळ त्यांनी तळ दिला. आर्णोन नदी मोआबाची सीमा आहे, जी मोआब आणि अमोरी यांच्यामध्ये आहे. ");
INSERT INTO marc_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","यावरून याहवेहच्या युद्धाच्या पुस्तकात म्हटले आहे: “…सूफाहतील वाहेब व आर्णोनाचे ओहोळ ");
INSERT INTO marc_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","आणि ओहोळांचा जो ओघ आर येथील वस्तीकडे वाहतो आणि मोआब प्रदेशालगत आहे.” ");
INSERT INTO marc_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","तिथून ते बैर म्हणजे विहीर या ठिकाणाकडे निघाले. ज्या ठिकाणी याहवेह मोशेला म्हणाले होते, “लोकांना बोलव म्हणजे मी त्यांना पाणी देईन.” ");
INSERT INTO marc_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","मग इस्राएलने हे गीत गाईले: “हे विहिरी, उफाळून ये! त्याविषयी गा, ");
INSERT INTO marc_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","जी विहीर राजपुत्रांनी खोदली, की ज्यामध्ये लोकांचे सरदार— आपल्या राजदंड आणि काठीसह बुडले.” मग ते त्या रानातून मत्तानाहला गेले, ");
INSERT INTO marc_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","मत्तानाहहून नाहालीयेल, नाहालीयेलपासून बामोथास, ");
INSERT INTO marc_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","आणि बामोथपासून मोआबामधील खोर्‍यापर्यंत जिथे पिसगाच्या शिखरावर ओसाड जमीन दिसते. ");
INSERT INTO marc_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","इस्राएलने अमोर्‍यांचा राजा सीहोनकडे दूत पाठवून म्हटले: ");
INSERT INTO marc_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“आम्हाला तुझ्या देशामधून जाऊ दे. आम्ही शेताकडे किंवा द्राक्षमळ्याकडे वळणार नाही किंवा विहिरीतील पाणी पिणार नाही. तुमची सीमा पार करेपर्यंत आम्ही केवळ राजमार्गानेच प्रवास करू.” ");
INSERT INTO marc_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","परंतु सीहोन राजाने इस्राएलास त्याच्या सीमेमधून जाण्यास परवानगी दिली नाही. त्याने आपल्या संपूर्ण सैन्याला जमा केले व इस्राएला विरुद्ध बाहेर रानात गेला आणि याहस येथे पोहोचल्यावर तो इस्राएलाशी लढला. ");
INSERT INTO marc_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","परंतु इस्राएलने त्याला तलवारीवर धरले आणि आर्णोन नदीपासून यब्बोक नदीपर्यंत, अम्मोनी लोक राहतात तिथपर्यंत त्यांच्या देशावर कब्जा केला, कारण त्यांची सीमा तटबंदची होती. ");
INSERT INTO marc_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","याप्रकारे इस्राएलने हेशबोन व आसपासच्या नगरांसह अमोर्‍यांची सर्व नगरे ताब्यात घेतली व त्यात वस्ती केली. ");
INSERT INTO marc_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेशबोन हे अमोर्‍यांचा राजा सीहोनचे शहर होते, ज्याने मोआबाच्या पूर्वीच्या राजाशी युद्ध केले होते आणि आर्णोन पर्यंतचा सर्व प्रदेश त्याच्याकडून घेतला होता. ");
INSERT INTO marc_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","म्हणूनच कवी म्हणतात: “हेशबोनला या आणि ते पुन्हा बांधू द्या; सीहोनाच्या शहराची पुनर्स्थापना होऊ द्या. ");
INSERT INTO marc_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“हेशबोनमधून अग्नी निघाला, सीहोनाच्या शहरातून ज्वाला निघाली. त्याने मोआबचे आर या आर्णोनाच्या उंच प्रदेशातील नागरिकांना भस्म केले आहे. ");
INSERT INTO marc_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","हे मोआबा, तुझा धिक्कार असो! कमोशाच्या लोकांनो, तुम्ही नष्ट झाला आहात! त्याने आपल्या मुलांना निर्वासित केले व अमोर्‍यांचा राजा सीहोनच्या हाती आपल्या मुलींना बंदी म्हणून दिले. ");
INSERT INTO marc_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“पण आम्ही त्यांना पराजित केले आहे; दिबोनपर्यंत हेशबोनचे वर्चस्व नष्ट झाले आहे. मेदबापर्यंत पसरलेल्या नोफाहपर्यंत, आम्ही त्यांचा नाश केला आहे.” ");
INSERT INTO marc_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","याप्रमाणे इस्राएली अमोरी लोकांच्या देशात स्थायिक झाले. ");
INSERT INTO marc_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","मोशेने याजेर नगराकडे हेर पाठवल्यानंतर, इस्राएली लोकांनी तेथील आसपासच्या वसाहती हस्तगत केल्या आणि तिथे असलेल्या अमोरी लोकांना बाहेर घालवून दिले. ");
INSERT INTO marc_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","नंतर तिथून वळून ते बाशानाच्या वाटेने वर गेले आणि बाशानचा राजा ओग आणि त्याचे सर्व सैन्य जमवून त्यांच्याशी युद्ध करण्यासाठी एद्रेई येथे गेले. ");
INSERT INTO marc_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","याहवेहने मोशेला म्हटले, “त्याला भिऊ नकोस, कारण मी त्याला व त्याच्या सर्व सैन्याला तुझ्या हाती दिले आहे. अमोर्‍यांचा राजा सीहोन जो हेशबोनात राज्य करीत होता, याचे तू जसे केले तसेच याला कर.” ");
INSERT INTO marc_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","तेव्हा इस्राएली लोकांनी त्याला, त्याची मुले व सर्व सैन्यासह नष्ट करून टाकले, त्यांच्यातील कोणीही वाचला नाही आणि इस्राएली लोकांनी त्याचा देश ताब्यात घेतला. ");
INSERT INTO marc_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","नंतर इस्राएली लोक प्रवास करीत मोआबाच्या मैदानात आले, जे यार्देनच्या पलीकडे यरीहोच्या समोर आहे. ");
INSERT INTO marc_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","इस्राएली लोकांनी अमोरी लोकांचे काय केले हे सर्व सिप्पोरचा पुत्र बालाकाने पाहिले. ");
INSERT INTO marc_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","इस्राएली लोक पुष्कळ आहेत हे पाहून मोआब फार घाबरला. इस्राएलमुळे मोआब हादरून गेला. ");
INSERT INTO marc_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मोआबी लोकांनी मिद्यान्यांच्या वडील लोकांना म्हटले, “जसा बैल शेतातील गवत चाटून फस्त करतो, त्याप्रमाणे हा मोठा जमाव आमच्या सभोवती असलेले सर्वकाही चाटून घेईल.” तेव्हा सिप्पोरचा पुत्र बालाक, जो त्यावेळी मोआबाचा राजा होता, ");
INSERT INTO marc_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","त्याने बौराचा पुत्र बलामला बोलवायला दूत पाठवले. तो त्यावेळी फरात नदीजवळ त्याच्या मातृभूमीत असलेल्या पथोर येथे होता. त्याला बालाक म्हणाला: “इजिप्तमधून काही लोक बाहेर आले आहेत; व त्यांनी पृथ्वी व्यापून टाकली आहे आणि आता माझ्यासमोर वसले आहेत. ");
INSERT INTO marc_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","तर आता ये आणि या लोकांना शाप दे, कारण ते माझ्यासाठी खूप प्रबळ आहेत. मग कदाचित मी त्यांचा पराभव करून त्यांना देशातून हाकलून देऊ शकेन. कारण मला माहीत आहे की ज्या कोणाला तू आशीर्वाद देतोस ते आशीर्वादित होतात आणि ज्या कोणाला तू शाप देतोस ते शापित होतात.” ");
INSERT INTO marc_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","मोआबी व मिद्यानी वडील, शकुन पाहण्यासाठी मोबदला घेऊन निघाले. जेव्हा ते बलामाकडे आले, तेव्हा बालाक जे काही म्हणाला ते त्याला सांगितले. ");
INSERT INTO marc_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","बलाम त्यांना म्हणाला, “आज रात्री येथे मुक्काम करा आणि याहवेह मला जे काही सांगतील ते मी तुम्हाला कळवेन.” म्हणून मोआबी सरदार त्याच्याकडे राहिले. ");
INSERT INTO marc_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","परमेश्वराने बलामाकडे येऊन त्याला विचारले, “तुझ्याबरोबर हे पुरुष कोण आहेत?” ");
INSERT INTO marc_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बलाम परमेश्वराला म्हणाला, “सिप्पोरचा पुत्र बालाक, मोआबाच्या राजाने मला हा संदेश पाठवला आहे: ");
INSERT INTO marc_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘इजिप्तमधून काही लोक बाहेर आले आहेत; व त्यांनी पृथ्वी व्यापून टाकली आहे. तर आता ये आणि माझ्यासाठी त्यांना शाप दे. कदाचित मी त्यांचा पराभव करून त्यांना देशातून हाकलून देऊ शकेल.’ ” ");
INSERT INTO marc_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","परंतु परमेश्वर बलामाला म्हणाले, “त्यांच्याबरोबर जाऊ नकोस. त्या लोकांना तू शाप देऊ नकोस, कारण ते आशीर्वादित लोक आहेत.” ");
INSERT INTO marc_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","सकाळी उठून बलामाने बालाकाच्या सरदारांना सांगितले, “तुमच्या आपल्या देशाला परत जा, कारण मी तुमच्याबरोबर जाण्यास याहवेहने नाकारले आहे.” ");
INSERT INTO marc_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","तेव्हा मोआबी सरदार बालाकाकडे परत गेले व म्हणाले, “बलामाने आमच्याबरोबर येण्यास नाकारले.” ");
INSERT INTO marc_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","नंतर बालाकाने दुसरे सरदार पाठवले, जे पहिल्यापेक्षा अधिक व आणखी प्रतिष्ठित होते. ");
INSERT INTO marc_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ते बलामाकडे आले आणि म्हणाले: सिप्पोरचा पुत्र बालाक असे म्हणतो: “माझ्याकडे येण्यासाठी तुला कोणतीही अडचण असू नये, ");
INSERT INTO marc_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","कारण मी तुला चांगले प्रतिफळ देईन आणि तू जे सांगशील ते करेन. तर आता ये आणि माझ्यासाठी या लोकांना शाप दे.” ");
INSERT INTO marc_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","परंतु बलामाने त्यांना उत्तर दिले, “बालाकाने जरी मला त्याच्या राजवाड्यातील सर्व चांदी आणि सोने दिले, तरीही याहवेह माझ्या परमेश्वराच्या आज्ञेपलीकडे मी काहीही कमी किंवा जास्त करू शकत नाही. ");
INSERT INTO marc_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","तरी आजची रात्र येथे राहा, म्हणजे याहवेह मला अजून काय सांगतात ते मला कळेल.” ");
INSERT INTO marc_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","त्या रात्री परमेश्वर बलामाकडे येऊन म्हणाले, “कारण हे लोक तुला बोलवायला आले आहेत, तू त्यांच्याबरोबर जा, परंतु केवळ मी तुला जे सांगेन तेच कर.” ");
INSERT INTO marc_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","बलाम सकाळी उठला आणि आपल्या गाढवीवर खोगीर घातले आणि मोआबी सरदारांबरोबर निघाला. ");
INSERT INTO marc_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","परंतु तो निघाला त्यावेळी परमेश्वराचा राग पेटला आणि त्याला अडविण्यासाठी याहवेहचा दूत वाटेत उभा राहिला. बलाम आपल्या गाढवीवर स्वार होता व त्याचे दोन सेवक त्याच्याबरोबर होते. ");
INSERT INTO marc_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","जेव्हा याहवेहचा दूत उपसलेली तलवार हातात घेऊन वाटेत उभा आहे असे गाढवीने पाहिले, तेव्हा ती वाटेतून वळून शेतात गेली. बलामाने तिला मारून पुन्हा वाटेवर आणले. ");
INSERT INTO marc_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","नंतर याहवेहचा दूत द्राक्षमळ्यांच्या मधील अरुंद वाटेवर उभा राहिला, त्याच्या दोन्ही बाजूंना भिंती होत्या. ");
INSERT INTO marc_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","जेव्हा गाढवीने याहवेहच्या दूताला पाहिले, ती भिंतीला घसटली व बलामाचा पाय भिंतीशी चेंगरला. म्हणून त्याने गाढवीला पुन्हा मारले. ");
INSERT INTO marc_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","नंतर याहवेहचा दूत पुढे जाऊन जिथे उजवीकडे किंवा डावीकडे वळायला जागा नव्हती अशा अरुंद ठिकाणी उभा राहिला. ");
INSERT INTO marc_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","जेव्हा गाढवीने याहवेहच्या दूताला पाहिले, बलाम तिच्यावर बसलेला असतानाच ती त्याच्यासहच खाली बसली आणि तो रागावला व तिला काठीने मारले. ");
INSERT INTO marc_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","तेव्हा याहवेहने त्या गाढवीचे मुख उघडले, व ती बलामाला म्हणाली, “तू मला तीन वेळा मारावेस असे मी काय केले आहे?” ");
INSERT INTO marc_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बलाम गाढवीला म्हणाला, “तू मला मूर्ख बनविले! माझ्या हातात तलवार असती, तर मी आता तुला मारून टाकले असते.” ");
INSERT INTO marc_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","गाढवीने बलामाला म्हटले, “मी तुझी ती गाढवी नाही काय जिच्यावर तू आजपर्यंत बसत आलास? मी तुझ्याशी कधी अशी वागणूक केली काय?” तो म्हणाला, “नाही.” ");
INSERT INTO marc_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","तेव्हा याहवेहने बलामाचे डोळे उघडले आणि त्याने रस्त्यावर तलवार उपसून उभे असलेल्या याहवेहच्या दूताला पाहिले आणि तो नमन करून पालथा पडला. ");
INSERT INTO marc_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","याहवेहच्या दूताने बलामाला विचारले, “तू तुझ्या गाढवीला असे तीन वेळा का मारलेस? मी तुला अडविण्यास आलो कारण माझ्यासमोर तुझा मार्ग विपरीत आहे. ");
INSERT INTO marc_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","गाढवीने मला पाहिले व तीन वेळा माझ्यापासून ती वळली. ती जर वळली नसती, तर आतापर्यंत मी तुला जिवे मारले असते, परंतु त्या गाढवीला वाचविले असते.” ");
INSERT INTO marc_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","बलाम याहवेहच्या दूताला म्हणाला, “मी पाप केले आहे. मला अडवावे म्हणून तुम्ही वाटेत उभे आहात हे मला समजले नाही. मग आता जर हे तुम्हाला आवडले नाही, तर मी माघारी जाईन.” ");
INSERT INTO marc_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","याहवेहच्या दूताने बलामाला म्हटले, “त्या पुरुषांबरोबर जा, परंतु जे मी तुला सांगेन तेच तू बोलावे.” म्हणून बलाम बालाकाच्या त्या सरदारांबरोबर गेला. ");
INSERT INTO marc_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","बलाम येत आहे, हे जेव्हा बालाकाने ऐकले, तेव्हा तो त्याला भेटण्याकरिता आर्णोनाच्या तीरावर, त्याच्या देशाच्या सीमेवर असलेल्या मोआबाच्या नगराकडे गेला. ");
INSERT INTO marc_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","बालाकाने बलामाला विचारले, “मी तुला तातडीचे बोलाविणे पाठवले नव्हते काय? तू माझ्याकडे का आला नाहीस? तुला बक्षीस देण्यास मी खरोखर समर्थ नाही काय?” ");
INSERT INTO marc_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","बलामाने बालाकाला उत्तर दिले, “पाहा आता मी तुझ्याकडे आलो आहे, परंतु मला वाटेल ते मी बोलू शकत नाही, परमेश्वर माझ्या मुखात जे शब्द घालतील तेच मी बोलेन.” ");
INSERT INTO marc_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","मग बलाम बालाकाबरोबर किर्याथ-हुसोथ येथे गेला. ");
INSERT INTO marc_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","तिथे बालाकाने गुरे व मेंढरे यांचे यज्ञ केले आणि त्यातील काही बलाम व जे सरदार त्याच्याबरोबर होते त्यांना दिले. ");
INSERT INTO marc_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","सकाळी बालाकाने बलामास वर बामोथ-बआल या ठिकाणी नेले आणि तिथून तो इस्राएली लोकांच्या छावणीचा शेवटचा भाग पाहू शकत होता. ");
INSERT INTO marc_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","बलाम बालाकाला म्हणाला, “या ठिकाणी माझ्यासाठी सात वेद्या बांध आणि माझ्यासाठी सात गोर्‍हे व सात मेंढे तयार ठेव.” ");
INSERT INTO marc_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बलामाने सांगितले त्याप्रमाणे बालाकाने केले आणि दोघांनी प्रत्येक वेदीवर गोर्‍हा व मेंढा यांचे अर्पण केले. ");
INSERT INTO marc_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","मग बलाम बालाकाला म्हणाला, “तू या तुझ्या होमार्पणाजवळ थांब आणि मी जरा बाजूला जातो. कदाचित याहवेह मला भेटायला येतील. ते जे काही मला प्रकट करतील ते मी तुला सांगेन.” मग तो एका उंच ओसाड ठिकाणी गेला. ");
INSERT INTO marc_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","परमेश्वर त्याला भेटले आणि बलाम म्हणाला, “मी सात वेद्या बांधून प्रत्येक वेदीवर एक गोर्‍हा आणि एक मेंढा अर्पण केला आहे.” ");
INSERT INTO marc_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","तेव्हा याहवेहने बलामाच्या मुखात शब्द घातले व म्हटले, “जा आणि बालाकाला हे वचन सांग.” ");
INSERT INTO marc_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","म्हणून बलाम परत बालाकाकडे आला. तेव्हा तो त्याच्या मोआबी सरदारांसह होमार्पणाजवळ उभा होता असे त्याने पाहिले. ");
INSERT INTO marc_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","तेव्हा बलामाने आपला संदेश सांगितला: “बालाकाने मला अरामाहून आणले, मोआबाच्या राजाने पूर्वेकडील डोंगरातून मला आणले. तो म्हणाला, ‘ये, माझ्यासाठी याकोबाला शाप दे; ये, इस्राएलाचा धिक्कार कर.’ ");
INSERT INTO marc_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ज्यांना परमेश्वराने शाप दिला नाही, त्यांना मी शाप कसा देऊ? ज्यांचा तिरस्कार याहवेहने केला नाही; त्यांचा तिरस्कार मी कसा करू? ");
INSERT INTO marc_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","खडकाच्या शिखरांवरून मी त्यांना पाहतो, उंच ठिकाणावरून मला ते दिसतात. वेगळे राहत असलेले लोक मी पाहतो राष्ट्रांबरोबर ते स्वतःला गणत नाहीत. ");
INSERT INTO marc_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","याकोबाची धूळ कोण मोजू शकेल, किंवा इस्राएलच्या चौथ्या भागाची तरी मोजणी कोण करणार? मला नीतिमानाचे मरण मरू दे, आणि माझा शेवट त्यांच्याप्रमाणे असो!” ");
INSERT INTO marc_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","बालाक बलामाला म्हणाला, “तू मला हे काय केलेस? माझ्या शत्रूंना शाप देण्यासाठी मी तुला आणले, पण तू तर आशीर्वाद दिल्याशिवाय काही केले नाहीस!” ");
INSERT INTO marc_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","बलामाने म्हटले, “जे शब्द याहवेह माझ्या मुखात घालतील तेच मी बोलू नये काय?” ");
INSERT INTO marc_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","तेव्हा बालाक त्याला म्हणाला, “माझ्याबरोबर दुसर्‍या ठिकाणी चल जिथून तू त्यांना पाहू शकशील; तुला ते सर्व दिसणार नाहीत तर केवळ त्यांच्या छावणीचा शेवटचा भाग मात्र दिसेल. तिथून त्यांना माझ्यासाठी शाप दे.” ");
INSERT INTO marc_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","त्याने बलामाला सोफिमाच्या मैदानाच्या पिसगाच्या डोंगरावर नेले, तिथे त्याने सात वेद्या बांधल्या आणि प्रत्येक वेदीवर एक गोर्‍हा व एक मेंढा अर्पण केला. ");
INSERT INTO marc_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","बलाम बालाकाला म्हणाला, “तू इथे तुझ्या होमार्पणाजवळ थांब, मी तिथे जाऊन याहवेहशी भेट घेतो.” ");
INSERT INTO marc_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","याहवेह बलामाला भेटले व त्याच्या मुखात आपला शब्द घातला व म्हटले, “बालाकाकडे परत जा आणि त्याला हे संदेश दे.” ");
INSERT INTO marc_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","जेव्हा तो परत आला तेव्हा तो आपल्या मोआबी सरदारांबरोबर त्याच्या होमार्पणाजवळ उभा असलेला त्याला दिसला. बालाकाने त्याला विचारले, “याहवेह काय म्हणाले?” ");
INSERT INTO marc_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","नंतर त्याने हा संदेश सांगितला: “बालाका, ऊठ आणि ऐक; सिप्पोरच्या पुत्रा, माझे ऐक. ");
INSERT INTO marc_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमेश्वर मनुष्य नाहीत की त्यांनी लबाडी करावी, ते मानव नाहीत, की त्यांनी आपले मन बदलावे. याहवेह बोलणार आणि त्यानुसार करणार नाहीत काय? त्यांनी अभिवचन दिले आणि ते पूर्ण करणार नाहीत काय? ");
INSERT INTO marc_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","आशीर्वाद देण्याची आज्ञा मला मिळाली आहे; याहवेहने आशीर्वाद दिला आहे आणि मी तो बदलू शकत नाही. ");
INSERT INTO marc_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“याकोबात विपत्ती सापडली नाही, इस्राएलात क्लेश दिसत नाहीत. त्यांचे परमेश्वर याहवेह त्यांच्याबरोबर आहेत; राजाचा जयघोष त्यांच्यामध्ये आहे. ");
INSERT INTO marc_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","परमेश्वराने त्यांना इजिप्तच्या बाहेर आणले. रानबैलासारखे त्यांचे बळ आहे. ");
INSERT INTO marc_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","याकोबाविरुद्ध मंत्रतंत्र नाही, इस्राएलविरुद्ध अपशकुन नाही. याकोबाविषयी व इस्राएलाविषयी असे म्हटले जाईल, परमेश्वराने काय केले आहे ते पाहा! ");
INSERT INTO marc_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","लोक सिंहिणीप्रमाणे उठतात; ते सिंहासारखे उभे राहतात जे त्याची शिकार खाईपर्यंत व वधलेल्यांचे रक्त पिईपर्यंत विसावा घेत नाहीत.” ");
INSERT INTO marc_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","मग बालाक बलामाला म्हणाला, “त्यांना अजिबात शापही देऊ नकोस किंवा आशीर्वादही देऊ नकोस.” ");
INSERT INTO marc_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बलामाने बालाकाला उत्तर दिले, “याहवेह जे सांगतील त्याचप्रमाणे मी केले पाहिजे असे मी तुला सांगितले नव्हते काय?” ");
INSERT INTO marc_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","नंतर बालाक बलामाला म्हणाला, “चल, मी तुला आणखी एका ठिकाणी नेतो. कदाचित त्या ठिकाणाहून तू माझ्यासाठी त्यांना शाप द्यावा हे परमेश्वराला बरे वाटेल.” ");
INSERT INTO marc_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","आणि बालाकाने बलामाला पेओर डोंगराच्या शिखराकडे ओसाड जागेसमोर नेले. ");
INSERT INTO marc_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","बलाम बालाकाला म्हणाला, “माझ्यासाठी येथे सात वेद्या बांध आणि सात गोर्‍हे व सात मेंढे माझ्यासाठी तयार ठेव.” ");
INSERT INTO marc_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बलामाने सांगितल्याप्रमाणे बालाकाने केले आणि प्रत्येक वेदीवर एकएक गोर्‍हा व मेंढा अर्पण केला. ");
INSERT INTO marc_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","आता जेव्हा बलामाने पाहिले की इस्राएलास आशीर्वाद देण्यास याहवेहला बरे वाटले, तेव्हा तो पूर्वीप्रमाणे मंत्रतंत्र करावयाला गेला नाही, तर त्याने रानाकडे आपले तोंड वळविले. ");
INSERT INTO marc_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","जेव्हा बलामाने दृष्टी वर करून पाहिले की इस्राएली लोक आपआपल्या गोत्राप्रमाणे छावणी देऊन राहत होते, परमेश्वराचा आत्मा त्याच्यावर आला ");
INSERT INTO marc_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","आणि त्याने आपला संदेश सांगितला: “बौराचा पुत्र बलामाची भविष्यवाणी, ज्याच्या डोळ्याला स्पष्ट दिसते त्याची भविष्यवाणी, ");
INSERT INTO marc_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","जो याहवेहचा शब्द ऐकतो त्याची भविष्यवाणी, जो सर्वसमर्थाकडून दृष्टान्त पाहतो, जो दंडवत घालतो आणि ज्याचे डोळे उघडले आहेत: ");
INSERT INTO marc_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“हे याकोबा, तुझे तंबू, हे इस्राएला, तुझी राहण्याची ठिकाणे किती सुंदर आहेत! ");
INSERT INTO marc_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“ते खोर्‍याप्रमाणे पसरतात, नदीकिनारी असलेल्या बागेप्रमाणे, याहवेहने रोपलेल्या जटामांसीसारखे, पाण्याजवळच्या गंधसरूंसारखे ते आहेत. ");
INSERT INTO marc_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","त्यांच्या पोहर्‍यातून पाणी वाहेल; त्यांच्या बिजांना भरपूर पाणी मिळेल. “त्यांचा राजा अगाग राजापेक्षा महान असेल; त्यांचे राज्य गौरवित केले जाईल. ");
INSERT INTO marc_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“परमेश्वराने त्यांना इजिप्तमधून बाहेर आणले; रानबैलासारखे त्यांचे बळ आहे. त्यांच्या विरोधात असलेल्या राष्ट्रांचा ते नाश करतात आणि त्यांच्या हाडांचे ते तुकडे करतात; ते आपल्या बाणांनी त्यांना भोसकतात. ");
INSERT INTO marc_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","सिंहाप्रमाणे ते दबा धरून निपचित पडून राहतात, सिंहिणीप्रमाणे ते पडून राहतात—त्यांना उठविण्याचे धाडस कोण करणार? “जे तुम्हाला आशीर्वाद देतात ते आशीर्वादित होतील आणि जे तुम्हाला शाप देतात ते शापित असो!” ");
INSERT INTO marc_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","तेव्हा बलामाविरुद्ध बालाकाचा राग पेटला. त्याने आपले हात एकत्र आपटले व त्याला म्हणाला, “माझ्या शत्रूंना शाप द्यावा म्हणून मी तुला बोलाविले, पण या तीन वेळा तू त्यांना आशीर्वादच दिलास. ");
INSERT INTO marc_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","आता येथून चालता हो! आणि आपल्या घरी जा. मी तुझा मोठा सन्मान करेन असे मी म्हटले होते, परंतु याहवेहने तुला सन्मानापासून वंचित केले आहे.” ");
INSERT INTO marc_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बलामाने बालाकाला उत्तर दिले, “तू ज्या दूतांना माझ्याकडे पाठवले त्यांना मी सांगितले नव्हते काय, ");
INSERT INTO marc_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘बालाकाने जरी मला त्याच्या राजवाड्यातील सर्व चांदी आणि सोने दिले, तरीही मला वाटेल ते मी करू शकत नाही, याहवेहच्या आज्ञेपलीकडे मी काहीही कमी किंवा जास्त करू शकत नाही; आणि याहवेह सांगतील तेच मी बोलणार’? ");
INSERT INTO marc_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","आता मी माझ्या लोकांकडे परत जात आहे, पण ये, हे इस्राएली लोक येणार्‍या दिवसात तुझ्या लोकांचे काय करणार त्याविषयी मी तुला चेतावणी देतो.” ");
INSERT INTO marc_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","मग त्याने हा संदेश दिला: “बौराचा पुत्र बलामाची भविष्यवाणी, ज्याच्या नजरेस स्पष्ट दिसते त्याची भविष्यवाणी, ");
INSERT INTO marc_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","जो परमेश्वराचे शब्द ऐकतो त्याची भविष्यवाणी, ज्याला परात्पराचे ज्ञान आहे, ज्याला सर्वसमर्थाकडून दर्शन घडते, जो दंडवत घालतो आणि ज्याचे डोळे उघडले आहेत: ");
INSERT INTO marc_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“मी त्याला पाहतो, पण आता नाही; मी त्याला न्याहाळतो, पण जवळ नाही. याकोबातून एक तारा उदयास येईल; इस्राएलातून एक राजदंड निघेल. तो मोआबाचे डोके व शेथाच्या सर्व लोकांच्या कवट्या चिरडून टाकेल. ");
INSERT INTO marc_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","एदोम जिंकला जाईल; इस्राएलचा शत्रू सेईर सुद्धा जिंकला जाईल, पण इस्राएल बलवान होईल. ");
INSERT INTO marc_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","याकोबातून एक अधिकारी येईल आणि नगरातील उरलेल्यांचा नाश करेल.” ");
INSERT INTO marc_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","नंतर बलामाने अमालेकाला पाहिले व आपला संदेश दिला: “अमालेक सर्व राष्ट्रांमध्ये प्रथम राष्ट्र होते, परंतु त्यांचा शेवट संपूर्ण विनाशात होईल.” ");
INSERT INTO marc_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","यानंतर त्याने केनी लोकांना पाहिले व आपला संदेश दिला: “तुझे वसतिस्थान सुरक्षित आहे, तुझे घरटे खडकात स्थिर आहे; ");
INSERT INTO marc_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","तरीही हे केनी, जेव्हा अश्शूर तुला कैद करून घेतील तेव्हा तुझा नाश होईल.” ");
INSERT INTO marc_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","त्यानंतर त्याने हा संदेश दिला: “हाय हाय! परमेश्वर हे करीत असताना कोण जगू शकेल? ");
INSERT INTO marc_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","कित्तीमाच्या किनार्‍यावरून जहाजे येतील; ते अश्शूर व एबर यांच्यावर जुलूम करतील, परंतु त्यांचाही नाश होईल.” ");
INSERT INTO marc_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","त्यानंतर बलाम उठून आपल्या घरी परतला व बालाकही आपल्या मार्गाने गेला. ");
INSERT INTO marc_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","इस्राएली लोक शिट्टीम येथे राहत असताना, त्यांचे पुरुष तेथील मोआबी कन्यांशी व्यभिचार करू लागले, ");
INSERT INTO marc_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","त्या कन्यांनी इस्राएली पुरुषांना त्यांच्या दैवतांच्या यज्ञास बोलाविले. लोकांनी त्या यज्ञांचे भोजन खाल्ले आणि त्या दैवतांना नमन केले. ");
INSERT INTO marc_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","अशा प्रकारे इस्राएली लोक बआल-पौराशी जडले आणि याहवेहचा कोप त्यांच्याविरुद्ध भडकला. ");
INSERT INTO marc_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","याहवेहने मोशेला म्हटले, “या लोकांच्या सर्व पुढार्‍यांना घे, त्यांना फासावर टांग व त्यांना दिवसाच्या प्रकाशात याहवेहसमोर उघडे कर, म्हणजे इस्राएलवर पेटलेला याहवेहचा क्रोध शांत होईल.” ");
INSERT INTO marc_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","तेव्हा मोशे इस्राएलच्या न्यायाधीशांनी म्हणाला, “तुम्ही स्वतःला बआल-पौराशी जोडले आहे, तुम्हा प्रत्येकाला जिवे मारावे.” ");
INSERT INTO marc_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","त्यावेळी ते सभामंडपाच्या दारात रडत असताना, एका इस्राएली पुरुषाने मोशे व संपूर्ण इस्राएली मंडळीसमोर एक मिद्यानी स्त्री आणली. ");
INSERT INTO marc_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","जेव्हा अहरोन याजकाचा पुत्र एलअज़ारचा पुत्र फिनहासने हे पाहिले, तेव्हा तो समुदायातून उठला व त्याने आपल्या हाती एक भाला घेतला ");
INSERT INTO marc_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","आणि त्यांच्यामागे तंबूत गेला व त्या दोघांच्या म्हणजेच तो इस्राएली पुरुष व ती स्त्री यांच्या पोटात तो भाला भोसकला, तेव्हा इस्राएलच्या लोकांमधून पीडा थांबली; ");
INSERT INTO marc_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","परंतु त्या पीडेत ज्यांचा मृत्यू झाला त्यांची संख्या चोवीस हजार होती. ");
INSERT INTO marc_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“अहरोन याजकाचा पुत्र एलअज़ारचा पुत्र फिनहासने इस्राएलवरील माझा क्रोध शांत केला आहे. कारण लोकांमधील माझ्या सन्मानाविषयी मी जितका ईर्ष्यावान आहे तितकाच तो सुद्धा होता म्हणून मी माझ्या ईर्षेने त्यांचा नाश केला नाही. ");
INSERT INTO marc_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","म्हणून त्याला सांग मी त्याच्याशी शांतीचा करार करीत आहे. ");
INSERT INTO marc_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","तो व त्याच्या वंशजासाठी हा सर्वकाळच्या याजकपणाचा करार असणार, कारण तो त्याच्या परमेश्वराच्या सन्मानासंबंधी ईर्ष्यावान होता आणि इस्राएली लोकांसाठी त्याने प्रायश्चित केले.” ");
INSERT INTO marc_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","मिद्यानी स्त्रीबरोबर ज्या इस्राएली पुरुषाला जिवे मारण्यात आले, त्याचे नाव जिम्री होते, जो शिमओनी घराण्याचा पुढारी सालूचा पुत्र होता. ");
INSERT INTO marc_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","आणि ज्या मिद्यानी स्त्रीला जिवे मारण्यात आले होते तिचे नाव कजबी होते, जी मिद्यानी घराण्याच्या कुळाचा पुढारी सूरची कन्या होती. ");
INSERT INTO marc_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिद्यानी लोकांना शत्रू समजून त्यांना जिवे मारा. ");
INSERT INTO marc_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","कारण त्यांनी तुम्हाला शत्रू मानले, जेव्हा पेओरच्या घटनेत तुम्हाला फसविण्यासाठी आपली बहीण, मिद्यानी पुढार्‍याची मुलगी कजबी हिचा त्यांनी उपयोग केला व त्या घटनेमुळे पीडा आली, तेव्हा तिला जिवे मारण्यात आले.” ");
INSERT INTO marc_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","पीडेनंतर याहवेहने मोशे व अहरोन याजकाचा पुत्र एलअज़ारला म्हटले, ");
INSERT INTO marc_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“इस्राएली लोकांच्या संपूर्ण समाजाची त्यांच्या घराण्यानुसार—जे सर्व वीस किंवा अधिक वयाचे असून इस्राएलच्या सैन्यात सेवा करण्यास सक्षम आहेत, त्यांची जनगणना कर.” ");
INSERT INTO marc_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","म्हणून मोशे व एलअज़ार याजक मोआबाच्या मैदानात यरीहोजवळ यार्देन नदीच्या काठावर इस्राएली लोकांशी बोलले आणि म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“याहवेहने मोशेला आज्ञापिल्याप्रमाणे जे पुरुष वीस किंवा त्याहून अधिक वयाचे आहेत त्यांची मोजणी करा.” ");
INSERT INTO marc_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","रऊबेन, इस्राएलच्या प्रथम जन्मलेल्या पुत्राचे वंशज हे: हनोखपासून हनोखी कूळ; पल्लूपासून पल्लूवी कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेस्रोनपासून हेस्रोनी कूळ; कर्मीपासून कर्मी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ही रऊबेनची कुळे होती; मोजलेल्यांची संख्या 43,730 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","पल्लूचा पुत्र एलियाब होता, ");
INSERT INTO marc_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","आणि एलियाबाचे पुत्र नेमूएल, दाथान आणि अबीराम होते. तेच दाथान आणि अबीराम जे समाजाचे अधिकारी होते, ज्यांनी मोशे आणि अहरोन विरुद्ध बंड केले आणि जेव्हा त्यांनी याहवेहविरुद्ध बंड केले तेव्हा ते कोरहाच्या अनुयायांपैकी होते. ");
INSERT INTO marc_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ज्यावेळी पृथ्वीने आपले तोंड उघडले आणि कोरह व त्याच्या अनुयायांना गिळून टाकले व त्यांच्यातील दोनशे पन्नास पुरुषांना अग्नीने भस्म करून टाकले. ते लोकांसाठी एक चेतावणीचे चिन्ह होते. ");
INSERT INTO marc_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","तरीही कोरहाचे सर्वच वंशज मेले नाही. ");
INSERT INTO marc_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","शिमओनचे वंशज त्यांच्या कुळानुसार हे होते: नेमूएलपासून नेमूएली कूळ; यामीनपासून यामीनी कूळ; याकीनपासून याखीनी कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","जेरहपासून जेरही कूळ; शाऊलपासून शाऊली कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ही शिमओनी कुळे होती; जे मोजले त्यांची संख्या 22,200 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","गादचे वंशज त्यांच्या कुळानुसार हे होते: जेफोनपासून जेफोनी कूळ; हग्गीपासून हग्गी कूळ; शूनीपासून शूनी कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ओजनीपासून ओजनी कूळ; एरीपासून एरी कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोदपासून अरोदी कूळ; अरेलीपासून अरेली कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ही गादची कुळे होती; जे मोजले त्यांची संख्या 40,500 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","एर आणि ओनान हे यहूदाहचे पुत्र होते, परंतु ते कनान देशात मरण पावले. ");
INSERT INTO marc_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","यहूदाहचे वंशज त्यांच्या कुळानुसार हे होते: शेलाहपासून शेलानी कूळ; पेरेसापासून पेरेसी कूळ; जेरहपासून जेरही कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","पेरेसचे वंशज हे होते: हेस्रोनपासून हेस्रोनी कूळ; हामूलपासून हामूली कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ही यहूदाहची कुळे होती; जे मोजले त्यांची संख्या 76,500 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","इस्साखारचे वंशज त्यांच्या कुळानुसार हे होते: तोलापासून तोलाई कूळ; पुवाहपासून पुनी कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","याशूबपासून याशूबी कूळ; शिम्रोनपासून शिम्रोनी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ही इस्साखारची कुळे होती; जे मोजले त्यांची संख्या 64,300 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","जबुलूनचे वंशज त्यांच्या कुळानुसार हे होते: सेरेदपासून सेरेदी कूळ; एलोनपासून एलोनी कूळ; याहलीलपासून याहलेली कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ही जबुलूनची कुळे होती; जे मोजले त्यांची संख्या 60,500 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","योसेफाचे कूळ त्याचे वंशज मनश्शेह व एफ्राईमचे कूळ हे होते: ");
INSERT INTO marc_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनश्शेहचे वंशज: माखीरपासून माखीरी कूळ (माखीर गिलआदाचा पिता होता); गिलआदापासून गिलआदी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","हे गिलआदाचे वंशज होते: इएजेरपासून इएजेरी कूळ; हेलेकपासून हेलेकी कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","अस्रिएलपासून अस्रिएली कूळ; शेखेमपासून शेखेमी कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","शेमीदापासून शेमीदाई कूळ; हेफेरपासून हेफेरी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(हेफेरचा पुत्र सलाफहादला पुत्र नव्हते; त्याला फक्त कन्या होत्या, त्यांची नावे महलाह, नोआह, होगलाह, मिल्काह आणि तिरजाह होती.) ");
INSERT INTO marc_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ही मनश्शेहची कुळे होती; जे मोजले त्यांची संख्या 52,700 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एफ्राईमचे वंशज त्यांच्या कुळानुसार हे होते: शुथेलहपासून शूथेलाही कूळ; बेकेरपासून बेकेरी कूळ; तहनपासून तहनी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","शुथेलहाचे वंशज हे होते: एरानपासून एरानी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","हे एफ्राईमचे कूळ होते; जे मोजले त्यांची संख्या 32,500 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","बिन्यामीनचे वंशज त्यांच्या कुळानुसार हे होते: बेलापासून बेलाई कूळ; आशबेलपासून अशबेली कूळ; अहीरामपासून अहीरामी कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","शफूफामपासून शूफामी कूळ; हूफामपासून हूफामी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","आर्द आणि नामान यांच्याद्वारे बेलाचे वंशज हे होते: आर्दाचे आर्दी कूळ; नामान द्वारे नामीनी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ही बिन्यामीनची कुळे होती; जे मोजले त्यांची संख्या 45,600 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दानचे वंशज त्यांच्या कुळानुसार हे होते: शूहामपासून शूहामी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ती सर्व शूहामी कुळे होती; आणि जे मोजले त्यांची संख्या 64,400 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेरचे वंशज त्यांच्या कुळानुसार हे होते: इम्नाहपासून इम्नी कूळ; इश्वीपासून इश्वी कूळ; बरीयाहपासून बरीयाह कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","आणि बरीयाहच्या वंशजांपासून: हेबेरपासून हेबेरी कूळ; मालकीएलपासून मालकीएली कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","आशेरला सेराह नावाची कन्या होती. ");
INSERT INTO marc_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ही आशेरची कुळे होती; जे मोजले त्यांची संख्या 53,400 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","नफतालीचे वंशज त्यांच्या कुळानुसार हे होते: याहसेलपासून याहसेली कूळ; गूनीपासून गूनी कूळ; ");
INSERT INTO marc_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेरपासून येसेरी कूळ; शिल्लेमपासून शिल्लेमी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ही नफतालीची कुळे होती; जे मोजले त्यांची संख्या 45,400 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","इस्राएली लोकांची एकूण संख्या 6,01,730 भरली. ");
INSERT INTO marc_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","याहवेहने मोशेला म्हटले, ");
INSERT INTO marc_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“त्यांना नावाच्या संख्येनुसार देश वतन म्हणून द्यावा. ");
INSERT INTO marc_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","मोठ्या गटाला मोठा वारसा द्यावा आणि लहान गटाला लहान वारसा द्या; ज्यांची नावे यादीत आहेत त्यानुसार प्रत्येकाला संख्येनुसार त्यांचा वारसा मिळावा. ");
INSERT INTO marc_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","जमिनीची वाटणी चिठ्ठ्या टाकून होईल याची खात्री करावी. त्यांच्या पूर्वजांच्या गोत्राच्या नावानुसार प्रत्येक गटाला वारसा मिळावा. ");
INSERT INTO marc_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","प्रत्येक वारसा मोठ्या आणि लहान गटांमध्ये चिठ्ठ्याद्वारे वाटप केला जावा.” ");
INSERT INTO marc_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ज्या लेवी लोकांची त्यांच्या कुळानुसार मोजणी झाली ते हे: गेर्षोनापासून गेर्षोनी कूळ; कोहाथापासून कोहाथी कूळ; मरारीपासून मरारी कूळ. ");
INSERT INTO marc_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ही देखील लेवी लोकांची कुळे होती: लिब्नी कूळ, हेब्रोनी कूळ, महली कूळ, मूशी कूळ, कोरही कूळ. कोहाथ हा अम्रामाचा पूर्वज होता; ");
INSERT INTO marc_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अम्रामाच्या पत्नीचे नाव योखबेद होते, ती लेवी वंशातील होती, जी लेवीच्या घराण्यात इजिप्तमध्ये असताना जन्मली होती. अम्रामापासून तिने अहरोन, मोशे व त्यांची बहीण मिर्यामला जन्म दिला. ");
INSERT INTO marc_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","अहरोन नादाब व अबीहू, एलअज़ार व इथामार यांचा पिता होता. ");
INSERT INTO marc_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","परंतु नादाब आणि अबीहूने याहवेहसमोर अनाधिकृत अग्नीद्वारे अर्पण केल्यामुळे ते मरण पावले. ");
INSERT INTO marc_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","एक महिन्यापेक्षा अधिक वयाच्या लेवी पुरुषांची संख्या 23,000 भरली. इस्राएलच्या इतर लोकांमध्ये त्यांची मोजणी झाली नाही, कारण त्यांना त्यांच्यामध्ये वाटा मिळाला नाही. ");
INSERT INTO marc_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मोआबाच्या मैदानात यरीहोजवळ यार्देन नदीतीरी मोशे व एलअज़ार याजकाने वरील इस्राएली लोकांची मोजणी केली. ");
INSERT INTO marc_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","सीनाय रानात मोशे आणि अहरोन याजकाने इस्राएली लोकांची जी मोजणी केली होती, त्यांच्यापैकी एकही या गणतीत नव्हता. ");
INSERT INTO marc_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","कारण याहवेहने त्या इस्राएली लोकांना सांगितले होते की ते खचितच रानात मरतील आणि यफुन्नेहचा मुलगा कालेब आणि नूनाचा मुलगा यहोशुआ यांच्याशिवाय एकही उरले नाही. ");
INSERT INTO marc_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","योसेफाचा पुत्र मनश्शेहच्या कुळातील माखीरचा पुत्र गिलआदचा पुत्र हेफेरचा पुत्र सलाफहादच्या कन्या, ज्यांची नावे महलाह, नोआह, होगलाह, मिल्काह व तिरजाह होती, त्या पुढे आल्या ");
INSERT INTO marc_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","आणि त्या मोशे, एलअज़ार याजक, पुढारी व सर्व मंडळीसमोर सभामंडपाच्या प्रवेशद्वाराशी उभ्या राहिल्या व म्हणाल्या, ");
INSERT INTO marc_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“आमचे पिता रानात मरण पावले. ते कोरहाच्या अनुयायांपैकी नव्हते, ज्यांनी एकत्र येऊन याहवेहविरुद्ध बंड केले, परंतु ते आपल्याच पापामुळे मरण पावले आणि त्यांना पुत्र नव्हते. ");
INSERT INTO marc_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","त्यांना पुत्र नव्हते म्हणून आमच्या पित्याचे नाव त्यांच्या कुळातून का नाहीसे व्हावे? आमच्या पित्याच्या नातेवाईकांबरोबर आम्हालाही वतन द्यावे.” ");
INSERT INTO marc_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","तेव्हा मोशेने त्यांचा वाद याहवेहपुढे आणला, ");
INSERT INTO marc_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","आणि याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सलाफहादाच्या कन्या जे म्हणतात ते बरोबर आहे. तू खचितच त्यांना त्यांच्या पित्याच्या नातेवाईकामध्ये त्यांचा वाटा म्हणून द्यावे आणि त्यांच्या पित्याचे वतन त्यांना दे. ");
INSERT INTO marc_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“इस्राएली लोकांना सांग, एखादा मनुष्य मरण पावला व त्यांच्यामागे त्याला पुत्र नाही, तर त्याचे वतन त्याच्या मुलीला द्यावे. ");
INSERT INTO marc_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","आणि जर त्याला कन्या नसली, तर त्याचे वतन त्याच्या भावांना द्यावे. ");
INSERT INTO marc_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","आणि त्याला भाऊ नसला, तर त्याचे वतन त्याच्या पित्याच्या भावांना द्यावे. ");
INSERT INTO marc_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","जर त्याच्या पित्याला भाऊ नसले, तर त्याचे वतन त्याच्या कुळातील जवळच्या नातेवाईकाला द्यावे, म्हणजे ते त्याचे वतन होईल. याहवेहने मोशेला आज्ञापिल्याप्रमाणे इस्राएली लोकांस हा न्यायाचा नियम असावा.” ");
INSERT INTO marc_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","नंतर याहवेह मोशेला म्हणाले, “या अबारीम डोंगरावर जा आणि जो देश मी इस्राएली लोकांना दिला आहे तो पाहा. ");
INSERT INTO marc_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","तो पाहिल्यानंतर, जसा तुझा भाऊ अहरोन आपल्या लोकांत जाऊन मिळाला, त्याप्रमाणे तू सुद्धा आपल्या लोकांना जाऊन मिळशील. ");
INSERT INTO marc_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","कारण सीन रानात पाण्याजवळ जेव्हा इस्राएली लोकांनी बंड केले, त्यावेळी त्यांच्या नजरेपुढे मला पवित्र म्हणून मानण्यास नाकारून तुम्ही दोघांनी माझ्या आज्ञेचा भंग केला.” (हेच सीन रानातील, कादेश येथील मरीबाहचे पाणी.) ");
INSERT INTO marc_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मोशे याहवेहला म्हणाला, ");
INSERT INTO marc_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“याहवेह परमेश्वर, जे सर्व जीवधार्‍यांना श्वास देतात, त्यांनी या समाजावर कोणा एकाची नेमणूक करावी ");
INSERT INTO marc_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","की त्याने त्यांच्यापुढे बाहेर जावे व आत यावे, जो त्यांना बाहेर नेईल व आत आणेल, जेणेकरून याहवेहचे लोक मेंढपाळ नसलेल्या मेंढरांप्रमाणे होणार नाहीत.” ");
INSERT INTO marc_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","तेव्हा याहवेह मोशेला म्हणाले, “नूनाचा पुत्र यहोशुआ, ज्या पुरुषामध्ये पुढारीपणाचा आत्मा वसतो, त्याला घे व त्याच्यावर आपला हात ठेव. ");
INSERT INTO marc_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","एलअज़ार याजक व संपूर्ण मंडळीसमोर त्याला उभे करून त्यांच्या समक्षतेत त्याची नेमणूक कर. ");
INSERT INTO marc_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","तुझे काही अधिकार त्याला दे म्हणजे सर्व इस्राएली समाज त्याचे आज्ञापालन करतील. ");
INSERT INTO marc_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","त्याने एलअज़ार याजकापुढे उभे राहावे, जो याहवेहसमोर उरीमविषयी विचारेल. त्याच्या आज्ञेनुसार तो व सर्व इस्राएली समाज बाहेर जाईल व त्याच्या आज्ञेनुसार आत येतील.” ");
INSERT INTO marc_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","याहवेहने त्याला आज्ञापिल्याप्रमाणे मोशेने केले. त्याने यहोशुआला एलअज़ार याजक व सर्व समाजापुढे उभे केले. ");
INSERT INTO marc_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","आणि याहवेहने सूचना दिल्याप्रमाणे मोशेने आपले हात यहोशुआवर ठेवून त्याची नेमणूक केली. ");
INSERT INTO marc_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","याहवेहने मोशेला म्हटले, ");
INSERT INTO marc_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“इस्राएली लोकांना ही आज्ञा दे व त्यांना सांग: ‘तुम्ही मला नेमलेल्या वेळी मला आवडेल असे सुवासिक अन्नार्पण मला निश्चितपणे सादर करावे.’ ");
INSERT INTO marc_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","त्यांना सांग: ‘जे अन्नार्पण तुम्ही याहवेहला सादर करावे ते हे: एक वर्षाची दोन निर्दोष कोकरे, जी दररोज नियमितपणे होमार्पण म्हणून अर्पण करावी. ");
INSERT INTO marc_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","एक कोकरू सकाळी व दुसरे संध्याकाळी अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","त्याबरोबर धान्यार्पणासाठी एक एफाचा दहावा भाग बारीक पीठ, कुटून काढलेल्या एक पाव हीन जैतुनाच्या तेलात मळून अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","सीनाय पर्वतावर स्थापित केलेले हे नियमितपणाचे होमार्पण याहवेहला आवडणारे सुवासिक अन्नार्पण आहे. ");
INSERT INTO marc_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","त्याबरोबरचे पेयार्पण, एका कोकर्‍याबरोबर एक पाव आंबवलेले पेय असावे. हे पेयार्पण याहवेहसाठी पवित्रस्थानी ओतावे. ");
INSERT INTO marc_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","दुसरे कोकरू संध्याकाळी अर्पावे, सकाळच्या अर्पणाप्रमाणे धान्यार्पण व पेयार्पण यासहित अर्पण करावे. हे अन्नार्पण याहवेहसाठी सुवासिक अर्पण आहे.’ ” ");
INSERT INTO marc_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“शब्बाथ दिवशी एक वर्षाची दोन निर्दोष कोकरे, व त्याबरोबर पेयार्पण व जैतुनाच्या तेलात मळलेले एका एफाचे दोन दशांश बारीक पीठ धान्यार्पण असे अर्पण करावे. ");
INSERT INTO marc_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","नियमित होमार्पण व त्याचे पेयार्पण याशिवाय प्रत्येक शब्बाथ दिवसाचे हे होमार्पण आहे. ");
INSERT INTO marc_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“प्रत्येक महिन्याच्या पहिल्या दिवशी दोन तरुण गोर्‍हे, एक मेंढा आणि एक वर्षाची सात कोकरे होमार्पण म्हणून याहवेहसाठी अर्पण करावे, हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","प्रत्येक गोर्‍ह्याबरोबर धान्यार्पण म्हणून तेलात मळलेले एका एफाचे तीन दशांश बारीक पीठ; आणि एका मेंढ्याबरोबर धान्यार्पण म्हणून तेलात मळलेले दोन दशांश बारीक पीठ; ");
INSERT INTO marc_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","आणि प्रत्येक कोकर्‍याबरोबर धान्यार्पण म्हणून तेलात मळलेले एक दशांश बारीक पीठ अर्पण करावे. हे होमार्पण सुवासिक अर्पण, अन्नार्पण म्हणून याहवेहसाठी सादर करावे. ");
INSERT INTO marc_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","प्रत्येक गोर्‍ह्याबरोबर अर्धा हीन पेयार्पण; आणि प्रत्येक मेंढ्याबरोबर एकतृतीयांश हीन, व प्रत्येक कोकर्‍याबरोबर एक पाव हीन द्राक्षारस आणावा. वर्षभरातील प्रत्येक पोर्णिमेच्या दिवशी करावयाचे हे मासिक होमार्पण आहे. ");
INSERT INTO marc_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","नियमित होमार्पण व त्याचे पेयार्पण याशिवाय एक बोकड पापार्पण म्हणून याहवेहला सादर करावा. ");
INSERT INTO marc_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘पहिल्या महिन्याच्या चौदाव्या दिवशी तुम्ही याहवेहचा वल्हांडण पाळावा. ");
INSERT INTO marc_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","या महिन्याच्या पंधराव्या दिवशीही सण पाळावा; सात दिवस खमीर न घातलेली भाकर खावी. ");
INSERT INTO marc_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","पहिल्या दिवशी एक पवित्र सभा भरवावी व कोणतेही नियमित कामे करू नये. ");
INSERT INTO marc_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","याहवेहसाठी अन्नार्पण सादर करा, म्हणजेच दोन तरुण गोर्‍हे, एक मेंढा व एक वर्षाची सात कोकरे यांचे होमार्पण करा, हे सर्व निर्दोष असावे. ");
INSERT INTO marc_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","प्रत्येक गोर्‍ह्याबरोबर तेलात मळलेले एका एफाचे तीन दशांश बारीक पीठ व मेंढ्याबरोबर दोन दशांश असे धान्यार्पण करावे. ");
INSERT INTO marc_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","व सात कोकर्‍यातील प्रत्येकासाठी, एफाचा एक दशांश अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","आणि तुमच्यासाठी प्रायश्चित व्हावे म्हणून एक बोकड पापार्पण म्हणून अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ही अर्पणे सकाळच्या नियमित होमार्पणाखेरीज असावीत. ");
INSERT INTO marc_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","अशाप्रकारे सात दिवस दररोज याहवेहसाठी सुवास म्हणून हे अन्नार्पण करावे; नियमित होमार्पण व त्याचे पेयार्पण याबरोबरच ही अर्पणे अर्पावीत. ");
INSERT INTO marc_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","सातव्या दिवशी पवित्र सभा भरवावी आणि नियमित कामे करू नये. ");
INSERT INTO marc_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘प्रथमफळांच्या दिवशी, जेव्हा तुम्ही आठवड्याच्या सणाच्या वेळी याहवेहला नवीन धान्याचे अर्पण करता, तेव्हा पवित्र सभा बोलवा आणि नियमित कामे करू नका. ");
INSERT INTO marc_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","याहवेहला सुवासिक होमार्पण म्हणून दोन तरुण गोर्‍हे, एक मेंढा व एक वर्षाची सात नरकोकरे अर्पण करा. ");
INSERT INTO marc_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","प्रत्येक गोर्‍ह्याबरोबर तेलात मळलेले एका एफाचे तीन दशांश बारीक पीठ यांचे धान्यार्पण करावे; गोर्‍ह्याबरोबर दोन दशांश; ");
INSERT INTO marc_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","आणि सात कोकर्‍यांकरिता प्रत्येकी एक दशांश बारीक पीठ अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","तुमच्यासाठी प्रायश्चित व्हावे म्हणून एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","नियमित होमार्पण व त्याचे धान्यार्पण याबरोबरच ही अर्पणे त्यांच्या पेयार्पणासह अर्पावीत. गुरे निर्दोष असतील याची खात्री करावी. ");
INSERT INTO marc_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘सातव्या महिन्याच्या पहिल्या दिवशी पवित्र सभा भरवा व नियमित कामे करू नये. तो तुमच्यासाठी कर्णे वाजविण्याचा दिवस आहे. ");
INSERT INTO marc_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","याहवेहस आवडणारा सुवास म्हणून एक तरुण गोर्‍हा, एक मेंढा व एक वर्षाची सात कोकरे यांचे होमार्पण करा, हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","गोर्‍ह्याबरोबर जैतुनाच्या तेलात मळलेले एका एफाचे तीन दशांश बारीक पिठाचे धान्यार्पण अर्पावे; व मेंढ्याबरोबर दोन दशांश; ");
INSERT INTO marc_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","आणि सात कोकर्‍यातील प्रत्येकासाठी एफाचा एक दशांश. ");
INSERT INTO marc_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","तुमच्यासाठी प्रायश्चित व्हावे म्हणून पापार्पणाकरिता एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","मासिक व रोजचे होमार्पण व त्यांचे नेमलेले धान्यार्पण व पेयार्पण याबरोबरच ही अर्पणे करावी. ही याहवेहस आवडणारी सुवासिक अन्नार्पणे आहेत. ");
INSERT INTO marc_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘याच सातव्या महिन्याच्या दहाव्या दिवशी एक पवित्र सभा भरवा. तुम्ही स्वसुखाचा त्याग करावा व कोणतेही नियमित काम करू नये. ");
INSERT INTO marc_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","याहवेहला सुवास म्हणून एक तरुण गोर्‍हा, एक मेंढा आणि एक वर्षाची सात कोकरे यांचे होमार्पण सादर करा, ते सर्व निर्दोष असावेत; ");
INSERT INTO marc_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","गोर्‍ह्याकरिता तेलात मळलेले एका एफाचे तीन दशांश बारीक पीठ; आणि मेंढ्याकरिता दोन दशांश असे धान्यार्पण करावे; ");
INSERT INTO marc_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","आणि सात कोकर्‍यातील प्रत्येकी एक दशांश बारीक पीठ अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","प्रायश्चित्ताचे पापार्पण, नियमित होमार्पण व त्याचे धान्यार्पण व त्याचे पेयार्पण, याबरोबरच पापार्पणासाठी एक बोकड अर्पण करावा. ");
INSERT INTO marc_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘सातव्या महिन्याच्या पंधराव्या दिवशी पवित्र सभा बोलवा आणि त्या दिवशी कोणतीही नियमित कामे करू नये. हा सण तुम्ही याहवेहसाठी सात दिवस पाळावा. ");
INSERT INTO marc_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","आणि तुम्ही याहवेहला सुवासिक होमार्पण म्हणून तेरा गोर्‍हे, दोन मेंढे आणि एक वर्षाची चौदा कोकरे अर्पण करावी, हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","या प्रत्येकी तेरा गोर्‍ह्यांबरोबर धान्यार्पण म्हणून तेलात मळलेले एक एफाचे तीन दशांश बारीक पीठ; व दोन मेंढ्यांबरोबर प्रत्येकी दोन दशांश; ");
INSERT INTO marc_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","आणि चौदा कोकर्‍यांबरोबर प्रत्येकी एक दशांश बारीक पीठ अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","नियमित होमार्पण व त्याबरोबरचे धान्यार्पण आणि पेयार्पण याशिवाय पापार्पणासाठी एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘दुसर्‍या दिवशी, बारा तरुण गोर्‍हे, दोन मेंढे आणि एक वर्षाची चौदा कोकरे अर्पण करावे व हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","गोर्‍हे, मेंढे व कोकरे याबरोबर त्यांच्या संख्येनुसार नेमल्याप्रमाणे त्यांचे धान्यार्पण व पेयार्पण अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","नियमित होमार्पण व त्याबरोबरचे धान्यार्पण आणि पेयार्पण याशिवाय पापार्पणासाठी एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘तिसर्‍या दिवशी अकरा गोर्‍हे, दोन मेंढे, व एक वर्षाची चौदा कोकरे अर्पण करावी. हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","गोर्‍हे, मेंढे व कोकरे याबरोबर त्यांच्या संख्येनुसार नेमल्याप्रमाणे त्यांचे धान्यार्पण व पेयार्पण अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","नियमित होमार्पण व त्याबरोबरचे धान्यार्पण आणि पेयार्पण याशिवाय पापार्पणासाठी एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘चौथ्या दिवशी दहा गोर्‍हे, दोन मेंढे, एक वर्षाची चौदा कोकरे अर्पण करावी, हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","गोर्‍हे, मेंढे व कोकरे याबरोबर त्यांच्या संख्येनुसार नेमल्याप्रमाणे त्यांचे धान्यार्पण व पेयार्पण अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","नियमित होमार्पण व त्याबरोबरचे धान्यार्पण आणि पेयार्पण याशिवाय पापार्पणासाठी एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘पाचव्या दिवशी नऊ गोर्‍हे, दोन मेंढे व एक वर्षाची चौदा कोकरे अर्पावी. हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","गोर्‍हे, मेंढे व कोकरे याबरोबर त्यांच्या संख्येनुसार नेमल्याप्रमाणे धान्यार्पण व पेयार्पण अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","नियमित होमार्पण व त्याबरोबरचे धान्यार्पण आणि पेयार्पण याशिवाय पापार्पणासाठी एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘सहाव्या दिवशी आठ गोर्‍हे, दोन मेंढे, एक वर्षाची चौदा कोकरे अर्पावी. हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","गोर्‍हे, मेंढे व कोकरे याबरोबर त्यांच्या संख्येनुसार नेमल्याप्रमाणे धान्यार्पण व पेयार्पण अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","नियमित होमार्पण व त्याबरोबरचे धान्यार्पण आणि पेयार्पण याशिवाय पापार्पणासाठी एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘सातव्या दिवशी सात गोर्‍हे, दोन मेंढे आणि एक वर्षाची चौदा कोकरे अर्पावी. हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","गोर्‍हे, मेंढे व कोकरे याबरोबर त्यांच्या संख्येनुसार नेमल्याप्रमाणे त्यांचे धान्यार्पण व पेयार्पण अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","नियमित होमार्पण व त्याबरोबरचे धान्यार्पण आणि पेयार्पण याशिवाय पापार्पणासाठी एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘आठव्या दिवशी विशेष समारोप सभा बोलवावी व कोणतीही नियमित कामे करू नये. ");
INSERT INTO marc_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","याहवेहसाठी एक गोर्‍हा, एक मेंढा व एक वर्षाची सात कोकरे यांचे सुवासिक अन्नार्पण म्हणजेच होमार्पण अर्पावे. हे सर्व निर्दोष असावेत. ");
INSERT INTO marc_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","गोर्‍हा, मेंढा व कोकरे याबरोबर त्यांच्या संख्येनुसार नेमल्याप्रमाणे धान्यार्पण व पेयार्पण अर्पावे. ");
INSERT INTO marc_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","नियमित होमार्पण व त्याबरोबरचे धान्यार्पण आणि पेयार्पण याशिवाय पापार्पणासाठी एक बोकड अर्पावा. ");
INSERT INTO marc_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘तुमचे नवस व तुमची स्वखुशीची अर्पणे याबरोबरच तुमची होमार्पणे, धान्यार्पणे, पेयार्पणे व शांत्यर्पणे तुमच्या नेमलेल्या सणाच्या वेळी याहवेहस अर्पण करावे.’ ” ");
INSERT INTO marc_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","याहवेहने आज्ञापिल्याप्रमाणे मोशेने सर्वकाही इस्राएली लोकांना सांगितले. ");
INSERT INTO marc_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","मोशे इस्राएली लोकांच्या गोत्रांच्या पुढार्‍यांशी बोलला: “याहवेहने जे आज्ञापिले ते हे: ");
INSERT INTO marc_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","जेव्हा एखादा पुरुष याहवेहला नवस करतो किंवा शपथ घेऊन स्वतःला बांधील करण्याचे वचन देतो, तेव्हा त्याने त्याचा शब्द मोडू नये व बोलल्याप्रमाणे त्याने ते करावे. ");
INSERT INTO marc_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“एखादी स्त्री अजूनही आपल्या पित्याच्या घरात राहून याहवेहस नवस करते किंवा वचन देऊन स्वतःला बांधील करते ");
INSERT INTO marc_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","आणि तिचा नवस किंवा शपथ याविषयी तिच्या पित्याने ऐकले आणि तिला काही बोलला नाही, तर ते वचन तिच्यावर कायम राहील. ");
INSERT INTO marc_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","परंतु ते ऐकून त्याने तिला मना केले तर तिचे नवस व शपथ यापैकी कोणतेही कायम राहणार नाही; कारण तिच्या पित्याने तिला मनाई केली, म्हणून याहवेह तिला क्षमा करतील. ");
INSERT INTO marc_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“तिने नवस केल्यावर किंवा तिच्या ओठांनी अविचाराने शपथ उच्चारली व स्वतःला बांधील केल्यानंतर जर तिने विवाह केला ");
INSERT INTO marc_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","आणि तिच्या पतीने त्याविषयी ऐकले आणि तिला काही बोलला नाही, तर तिचे नवस किंवा शपथ ज्याने तिने स्वतःला बांधील केले ते तिच्यावर कायम राहील. ");
INSERT INTO marc_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","पण त्याविषयी ऐकून जर तिच्या पतीने तिला मनाई केली, तर ज्या नवसाने व शपथेने तिने स्वतःला बांधील करून घेतले आहे, ते तो रद्द करतो व याहवेह तिला क्षमा करतील. ");
INSERT INTO marc_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“विधवा किंवा घटस्फोट झालेली स्त्री शपथेने किंवा नवसाने स्वतःला बांधील करून घेते, तर ते तिच्यावर कायम राहील. ");
INSERT INTO marc_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“आपल्या पतीबरोबर राहून एखादी स्त्री जर नवस करते किंवा स्वतःला बांधील करून शपथ घेते ");
INSERT INTO marc_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","आणि तिचा पती त्याविषयी ऐकून तिला काही बोलत नाही किंवा तिला मनाई करीत नाही, तर ज्या नवसांनी व शपथांनी तिने स्वतःला बांधील करून घेतले आहे ते कायम राहतील. ");
INSERT INTO marc_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","पण त्याविषयी ऐकून जर त्याने ते रद्द केले, तर तिच्या मुखातून आलेले कोणतेही नवस किंवा शपथ कायम राहणार नाहीत. तिच्या पतीने ते रद्द केले आहेत आणि याहवेह तिला क्षमा करतील. ");
INSERT INTO marc_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","तिचा पती तिने केलेला नवस किंवा स्वतःचा त्याग करण्यासाठी घेतलेली शपथ कायम करेल किंवा रद्द करेल. ");
INSERT INTO marc_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","पण रोजच्यारोज जर तिचा पती त्याविषयी तिला काहीही बोलत नाही, तर तिने केलेले सर्व नवस व शपथ ज्यांनी तिने स्वतःला बद्ध करून घेतले आहे ते तो कायम करतो. तो काहीही बोलला नाही म्हणून तिने केलेले नवस तो कायम करतो. ");
INSERT INTO marc_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","पण ते ऐकल्यानंतर काही काळाने जर त्याने ते रद्द केले, तर तिचा दोष त्याला भोगावा लागेल.” ");
INSERT INTO marc_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","पुरुष व त्याची पत्नी, यांच्यामधील नाते व पिता व त्याची तरुण मुलगी जी अजूनही त्याच्या घरात राहते यांच्यामधील नाते याविषयी याहवेहने मोशेला दिलेले नियम ते हे आहेत. ");
INSERT INTO marc_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“इस्राएली लोकांसाठी मिद्यानी लोकांचा सूड घे. त्यानंतर तू तुझ्या लोकांत मिळविला जाशील.” ");
INSERT INTO marc_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","तेव्हा मोशे लोकांना म्हणाला, “मिद्यानी लोकांशी युद्ध करावे म्हणून तुम्ही आपल्यातील काही पुरुषांना सिद्ध करा, म्हणजे ते याहवेहच्या वतीने त्यांचा सूड घेतील. ");
INSERT INTO marc_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","इस्राएलच्या प्रत्येक गोत्रातून एक हजार पुरुषांना युद्धासाठी पाठवा.” ");
INSERT INTO marc_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","तेव्हा युद्धासाठी बारा हजार पुरुष सशस्त्र झाले, प्रत्येक गोत्रातून एक हजार असे इस्राएलच्या कुळातून ते पुरविण्यात आले. ");
INSERT INTO marc_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","एलअज़ार याजकाचा पुत्र फिनहासाने आपल्याबरोबर पवित्रस्थानातील साहित्य व इशारा देण्यासाठी कर्णे घेतले होते, त्याच्यासह मोशेने प्रत्येक गोत्रातील एक हजार पुरुषांना युद्धात पाठवले. ");
INSERT INTO marc_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","याहवेहने मोशेला आज्ञापिल्याप्रमाणे ते मिद्यानी लोकांशी लढले व त्यांनी प्रत्येक पुरुषाला जिवे मारले. ");
INSERT INTO marc_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ज्या लोकांचा त्यांनी वध केला ते मिद्यानांचे पाच राजे म्हणजे एवी, रेकेम, सूर, हूर आणि रेबा हे होते. त्यांनी बौराचा पुत्र बलाम यालाही तलवारीने जिवे मारले. ");
INSERT INTO marc_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इस्राएली लोकांनी मिद्यानी स्त्रिया व लेकरे यांना कैद केले आणि मिद्यानी गुरे व शेरडेमेंढरे व मालमत्ता लूट म्हणून घेतले. ");
INSERT INTO marc_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","मिद्यानी लोक ज्या नगरांमध्ये स्थायिक होते त्यांच्या सर्व छावण्या त्यांनी जाळून टाकल्या. ");
INSERT INTO marc_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","त्यांनी सर्व लोक व जनावरे यासह सर्व लूट व मालमत्ता घेतली, ");
INSERT INTO marc_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","आणि कैदी, लूट, जनावरे यांना मोआबाच्या मैदानात यरीहोजवळ यार्देनेकडील छावणीत मोशे, एलअज़ार याजक आणि इतर इस्राएलच्या मंडळीसमोर आणले. ");
INSERT INTO marc_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","मोशे, एलअज़ार याजक आणि समाजाचे सर्व पुढारी त्यांना भेटण्यास छावणीबाहेर गेले. ");
INSERT INTO marc_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","पण सेनाधिकारी जे हजारांवरचे सरदार व शंभरांवरचे सरदार—जे युद्धावरून परतले त्यांच्यावर मोशे रागावला. ");
INSERT INTO marc_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","मोशेने त्यांना विचारले, “तुम्ही सर्व स्त्रियांना जिवंत राहू दिले काय? ");
INSERT INTO marc_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","त्यांनीच बलामाच्या सल्ल्यानुसार पेओरच्या प्रकरणात इस्राएली लोकांना याहवेहशी अविश्वासूपणा करण्यास भाग पाडले आणि याहवेहच्या लोकांना पीडेने मारले. ");
INSERT INTO marc_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","तर आता सर्व मुलांस जिवे मारा व पुरुषाशी संग ठेवलेल्या प्रत्येक स्त्रीला मारून टाका, ");
INSERT INTO marc_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","परंतु जिचा कधीही पुरुषाशी संग झाला नाही ती प्रत्येक मुलगी तुमच्यासाठी राखून ठेवा. ");
INSERT INTO marc_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“जर कोणी एखाद्याला जिवे मारले किंवा जो जिवे मारला गेला त्याला स्पर्श केला त्यांनी सात दिवस छावणीबाहेर राहावे. तिसर्‍या दिवशी व सातव्या दिवशी तुम्ही स्वतःस व आपल्या बंदिवानांना शुद्ध करावे. ");
INSERT INTO marc_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","चामडे, बोकडाचे केस किंवा लाकूड या सर्व वस्तूंसह प्रत्येक वस्त्र शुद्ध करावे.” ");
INSERT INTO marc_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","यानंतर एलअज़ार याजक युद्धास गेलेल्या सैनिकांना म्हणाला, “याहवेहने मोशेला दिलेल्या नियमानुसार ही आज्ञा आहे: ");
INSERT INTO marc_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","सोने, चांदी, तांबे लोखंड, कथील, शिसे ");
INSERT INTO marc_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","आणि त्या प्रत्येक वस्तू ज्या अग्नीत टिकतात त्या अग्नीत टाकाव्या, मग त्या शुद्ध होतील. परंतु त्या शुद्धीकरणाच्या पाण्यानेही शुद्ध कराव्या. ज्या वस्तू अग्नीत टिकत नाहीत, त्या शुद्धीकरणाच्या पाण्यात घालून काढाव्या. ");
INSERT INTO marc_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","सातव्या दिवशी तुम्ही आपली वस्त्रे धुवावीत म्हणजे तुम्ही शुद्ध व्हाल, मग तुम्ही छावणीत परत यावे.” ");
INSERT INTO marc_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","मग याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“तू आणि एलअज़ार याजक व समाजाच्या कुटुंब प्रमुखांनी कैद केलेले सर्व लोक व जनावरे यांची मोजणी करावी. ");
INSERT INTO marc_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","लुटीचे दोन समान भाग करावेत. एक भाग लढाईवर गेलेल्या सैनिकांना व दुसरा भाग समाजातील इतरांना द्यावा. ");
INSERT INTO marc_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","युद्धास गेलेल्या सैनिकांच्या हिश्श्यातून, मनुष्य असो किंवा गुरे, गाढवे किंवा मेंढरे यापैकी याहवेहसाठी खंडणी म्हणून पाचशेमागे एक याप्रमाणे ते वेगळे कर. ");
INSERT INTO marc_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","त्यांच्या अर्ध्या हिश्श्यातून ते घे व याहवेहचा वाटा म्हणून तो एलअज़ार याजक याला दे. ");
INSERT INTO marc_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","इस्राएली लोकांच्या अर्ध्या हिश्श्यातून माणसे असो किंवा गुरे, गाढवे, मेंढरे किंवा इतर जनावरे यापैकी याहवेहसाठी खंडणी म्हणून पन्नासापैकी एक याप्रमाणे ते वेगळे कर. व लेवी लोक, जे याहवेहच्या निवासमंडपाच्या देखरेखीसाठी जबाबदार आहेत त्यांना द्यावे.” ");
INSERT INTO marc_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","म्हणून याहवेहने मोशेला आज्ञापिल्याप्रमाणे मोशे व एलअज़ार याजकाने केले. ");
INSERT INTO marc_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","युद्धात सैन्याने घेतलेल्या लुटीतून राहिलेली लूट 6,75,000 मेंढरे, ");
INSERT INTO marc_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 गुरे, ");
INSERT INTO marc_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 गाढवे ");
INSERT INTO marc_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","आणि 32,000 स्त्रिया ज्यांनी कधीही पुरुषांबरोबर संग केला नव्हता. ");
INSERT INTO marc_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","युद्धात लढलेल्यांना मिळालेला अर्धा भाग हा होता: 3,37,500 मेंढरे, ");
INSERT INTO marc_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ज्यापैकी याहवेहची खंडणी 675 मेंढरे होती; ");
INSERT INTO marc_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000 गुरे, ज्यापैकी 72 याहवेहची खंडणी होती; ");
INSERT INTO marc_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500 गाढवे, ज्यापैकी याहवेहची खंडणी 61 होती; ");
INSERT INTO marc_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 लोक, ज्यापैकी याहवेहची खंडणी 32 होती. ");
INSERT INTO marc_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","याहवेहने मोशेला आज्ञापिल्याप्रमाणे मोशेने याहवेहचा हिस्सा म्हणून एलअज़ार याजकाला खंडणी दिली. ");
INSERT INTO marc_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","युद्धास गेलेल्या सैनिकांशिवाय इस्राएली लोकांना जो वाटा मोशेने वेगळा केला— ");
INSERT INTO marc_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","इस्राएल समाजाला मिळालेला अर्धा वाटा याप्रमाणे होता—3,37,500 मेंढरे, ");
INSERT INTO marc_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 गुरे, ");
INSERT INTO marc_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 गाढवे ");
INSERT INTO marc_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","आणि 16,000 लोक. ");
INSERT INTO marc_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","याहवेहने मोशेला आज्ञापिल्याप्रमाणे इस्राएली लोकांच्या वाट्यातील पन्नासापैकी एक, लोक आणि जनावरे असे मोशेने निवडून ते लेवी लोकांना दिले, जे याहवेहच्या निवासमंडपाच्या देखरेखीसाठी जबाबदार होते. ");
INSERT INTO marc_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","नंतर सेनेच्या तुकड्यांवर जे अधिकारी होते—जे हजारांचे व शंभरांचे सेनापती होते ते मोशेकडे गेले ");
INSERT INTO marc_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","आणि मोशेला म्हणाले, “तुझ्या सेवकांनी आमच्या हाताखाली असलेल्या सैनिकांची मोजणी केली आणि त्यातून एकही व्यक्ती कमी झालेला नाही. ");
INSERT INTO marc_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","म्हणून आम्ही आम्हाला लुटीतून जे सोन्याचे दागिने मिळाले त्यातून तोडे, कड्या, अंगठ्या, कुंडले व माळा; आमच्यासाठी प्रायश्चिताचे अर्पण म्हणून याहवेहसमोर आणले आहेत.” ");
INSERT INTO marc_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","मोशे व एलअज़ार याजक यांनी ते सोने; घडीव दागिने त्यांच्यापासून स्वीकारले. ");
INSERT INTO marc_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","हजारांचे सरदार व शंभरांचे सरदार यांच्याकडून स्वीकारलेले सोने जे मोशे व एलअज़ार याजकाने याहवेहला भेट म्हणून सादर केले, त्याचे वजन 16,750 शेकेल इतके भरले. ");
INSERT INTO marc_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","प्रत्येक सैनिकाने स्वतःसाठी लूट घेतली होती. ");
INSERT INTO marc_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","मोशे आणि एलअज़ार याजकाने हजारांच्या व शंभरांच्या सरदारांकडून जे सोने स्वीकारले, ते त्यांनी इस्राएली लोकांसाठी याहवेहसमोर स्मारक म्हणून सभामंडपात आणले. ");
INSERT INTO marc_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","रऊबेन गोत्राचे लोक व गाद गोत्राच्या लोकांकडे मोठी खिल्लारे व कळपे होती. त्यांनी पाहिले की याजेर आणि गिलआद हे प्रांत कळपासाठी उत्तम आहेत. ");
INSERT INTO marc_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","म्हणून गाद गोत्राचे व रऊबेन गोत्राचे लोक मोशे, एलअज़ार याजक व समाजाच्या पुढाऱ्यांकडे आले आणि म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“अतारोथ, दिबोन, याजेर, निमराह, हेशबोन, एलिआलेह, सेबाम, नबो व बेओन; ");
INSERT INTO marc_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","हा प्रांत जो याहवेहने इस्राएली लोकांपुढे कब्जा केला आहे, तो गुरांसाठी उत्तम आहे आणि तुझ्या सेवकांजवळ गुरे आहेत.” ");
INSERT INTO marc_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ते म्हणाले, “जर आम्ही तुझ्या दृष्टीत कृपा पावलो असलो तर हा प्रदेश तुझ्या सेवकांना आमचे वतन असा दिला जावा. आम्हाला यार्देनच्या पलीकडे नेऊ नकोस.” ");
INSERT INTO marc_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","मोशे गाद गोत्राच्या व रऊबेन गोत्राच्या लोकांना म्हणाला, “इस्राएलमधील तुमचे इतर भाऊ युद्धाला जातील तेव्हा तुम्ही इथे बसून राहावे काय? ");
INSERT INTO marc_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","याहवेहने जो देश त्यांना देऊ केला आहे, त्यात जाण्यासाठी तुम्ही इस्राएली लोकांना का निराश करता? ");
INSERT INTO marc_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","मी तुमच्या पूर्वजांना कादेश-बरनेआपासून देश हेरायला पाठवले तेव्हाही त्यांनी असेच केले होते. ");
INSERT INTO marc_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","अष्कोलच्या खोर्‍यापर्यंत गेल्यानंतर त्यांनी देश पाहिला व जो देश याहवेहने त्यांना दिला होता त्यात जाण्यापासून त्यांनी इस्राएली लोकांना निराश केले. ");
INSERT INTO marc_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","त्या दिवशी याहवेहचा क्रोध भडकला आणि त्यांनी ही शपथ वाहिली: ");
INSERT INTO marc_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘कारण त्यांनी पूर्ण अंतःकरणाने मला अनुसरले नाही, म्हणून इजिप्तमधून बाहेर येताना ज्यांचे वय वीस वर्षे व त्याहून अधिक होते त्यातील एकही, जो देश मी अब्राहाम, इसहाक व याकोबाला शपथ घेऊन देऊ केला तो पाहणार नाही; ");
INSERT INTO marc_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","कनिज्जी यफुन्नेहचा पुत्र कालेब आणि नूनाचा पुत्र यहोशुआ मात्र तो पाहतील, कारण त्यांनी याहवेहला पूर्ण हृदयाने अनुसरले.’ ");
INSERT INTO marc_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","याहवेहचा क्रोध इस्राएलवर भडकला व ज्या पिढीने याहवेहच्या दृष्टीने दुष्टाई केली होती त्या सर्वांचा नाश होईपर्यंत याहवेहने इस्राएली लोकांना चाळीस वर्षे रानात भटकण्यास लावले. ");
INSERT INTO marc_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“आणि पाहा, पातक्यांच्या पिल्लांनो, इस्राएलावर याहवेहचा राग आणखी वाढविण्यासाठी तुम्ही तुमच्या पित्याच्या जागी उभे राहिला आहात. ");
INSERT INTO marc_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","जर तुम्ही याहवेहच्या मागे चालण्यापासून दूर फिराल, तर याहवेह या इस्राएली लोकांना पुन्हा रानात सोडून देतील व तुम्ही त्यांच्या नाशास कारणीभूत ठराल.” ");
INSERT INTO marc_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","नंतर ते मोशेकडे येऊन त्याला म्हणाले, “येथे आम्ही आमच्या गुरामेंढरांसाठी मेंढवाडे व आमच्या स्त्रिया व लेकरांसाठी नगरे बांधू. ");
INSERT INTO marc_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","परंतु आम्ही स्वतःला युद्धासाठी सशस्त्र करू व इस्राएली लोकांना त्यांच्या ठिकाणी पोहचवेपर्यंत त्यांच्यापुढे जाऊ. तोपर्यंत आमच्या स्त्रिया व लेकरे देशातील रहिवाशांपासून तटबंदीच्या नगरात सुरक्षित राहतील. ");
INSERT INTO marc_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","प्रत्येक इस्राएली व्यक्तीला आपले वतन मिळेपर्यंत आम्ही आमच्या घरी परत जाणार नाही. ");
INSERT INTO marc_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","यार्देन नदीच्या पलीकडे त्यांच्याबरोबर आम्ही कोणतेही वतन घेणार नाही, कारण आमचे वतन आम्हाला यार्देनेच्या पूर्वेस मिळाले आहे.” ");
INSERT INTO marc_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","तेव्हा मोशे त्यांना म्हणाला, “जर तुम्ही हे कराल, म्हणजे जर तुम्ही याहवेहसमोर युद्धासाठी स्वतःला हत्यारबंद कराल ");
INSERT INTO marc_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","आणि याहवेह आपल्या शत्रूंना आपल्यासमोरून घालवून देईपर्यंत तुम्ही सर्व जे हत्यारबंद झालेले आहात, ते याहवेहच्या पुढे यार्देन पार कराल; ");
INSERT INTO marc_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","तर जेव्हा याहवेहपुढे देश ताब्यात घेतला जाईल, तेव्हा तुम्ही परत जा व याहवेहच्या व इस्राएलच्या कर्तव्यातून तुम्ही मुक्त व्हाल आणि हा देश याहवेहसमोर तुमचे वतन होईल. ");
INSERT INTO marc_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“परंतु तुम्ही असे करण्यास चुकला, तर तुम्ही याहवेहविरुद्ध पाप कराल; आणि खचितच तुमचे पाप तुम्हाला शोधणार. ");
INSERT INTO marc_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","तुमच्या स्त्रिया व लेकरांकरिता नगरे व तुमच्या गुरामेंढरांकरिता वाडे बांधा, परंतु तुम्ही वचन दिल्याप्रमाणे करा.” ");
INSERT INTO marc_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","गाद आणि रऊबेन गोत्राच्या लोकांनी मोशेला म्हटले, “आम्ही तुझे सेवक, आमच्या प्रभूच्या आज्ञेप्रमाणे करू. ");
INSERT INTO marc_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","आमची लेकरे, स्त्रिया, आमचे कळप आणि गुरे या ठिकाणी गिलआदाच्या शहरांमध्ये राहतील. ");
INSERT INTO marc_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","पण तुझे सेवक, म्हणजे युद्धासाठी हत्यारबंद झालेला प्रत्येक पुरुष, जसे आमचे प्रभू सांगतात त्याप्रमाणेच युद्धासाठी याहवेहपुढे पार जातील.” ");
INSERT INTO marc_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","नंतर मोशेने एलअज़ार याजकाला व नूनाचा पुत्र यहोशुआ आणि इस्राएली गोत्राच्या कुटुंबप्रमुखांना आज्ञा दिली. ");
INSERT INTO marc_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","मोशे त्यांना म्हणाला, “जर गाद आणि रऊबेन गोत्राचे लोक, त्यांच्यातील प्रत्येक पुरुष जो युद्धासाठी हत्यारबंद झालेला, याहवेहसमोर तुमच्याबरोबर यार्देन पार करतील, जेव्हा तुमच्यापुढे देश ताब्यात घेतला जाईल, तेव्हा तुम्ही गिलआदाचा प्रांत त्यांना त्यांचे वतन म्हणून द्यावा. ");
INSERT INTO marc_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","पण ते जर तुमच्याबरोबर हत्यारबंद होऊन पार गेले नाहीत, तर त्यांनी कनान देशात तुमच्याबरोबर वतन स्वीकारावे.” ");
INSERT INTO marc_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","गाद आणि रऊबेन गोत्राच्या लोकांनी उत्तर दिले, “तुझे सेवक तेच करतील जे याहवेहने सांगितले आहे. ");
INSERT INTO marc_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","आम्ही हत्यारबंद होऊन याहवेहपुढे कनान देशात पार जाऊ, परंतु आमचे वतन यार्देनेच्या अलीकडे असणार.” ");
INSERT INTO marc_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","तेव्हा मोशेने गाद गोत्राचे लोक, रऊबेन गोत्राचे लोक आणि योसेफाचा पुत्र मनश्शेहचे अर्ध्या गोत्रांना अमोर्‍यांचा राजा सीहोनाचे राज्य आणि बाशानचा राजा ओगच्या राज्याचा सर्व प्रदेश, शहरे व चहूकडील नगरे दिली. ");
INSERT INTO marc_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","गाद गोत्राच्या लोकांनी दिबोन, अतारोथ, अरोएर, ");
INSERT INTO marc_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अटरोथ-शोफान, याजेर, योगबेहाह, ");
INSERT INTO marc_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बेथ-निमराह व बेथ-हारान ही सर्व तटबंदीची नगरे बांधली व त्यांच्या कळपासाठी मेंढवाडे सुद्धा बांधले. ");
INSERT INTO marc_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","रऊबेन गोत्राच्या लोकांनी हेशबोन, एलिआलेह, आणि किर्याथाईमची पुनर्बांधणी केली, ");
INSERT INTO marc_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","याशिवाय नबो, बआल-मेओन (यांची नावे बदलली गेली) व सिबमाह हे देखील. ज्या नगरांची त्यांनी पुनर्बांधणी केली त्या नगरांना त्यांनीच नावे दिली. ");
INSERT INTO marc_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","मनश्शेहचा पुत्र माखीरचे वंशज गिलआद प्रांताकडे गेले, त्यावर ताबा करून तिथे असलेल्या अमोरी लोकांना तिथून घालवून दिले. ");
INSERT INTO marc_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","म्हणून मोशेने मनश्शेहचे वंशज माखीरी लोकांना गिलआद प्रांत देऊ केला आणि ते तिथे स्थायिक झाले. ");
INSERT INTO marc_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","मनश्शेहचे वंशज याईरी लोकांनी एका नगराला ताब्यात घेतले व त्याचे नाव हव्वोथ-याईर असे ठेवले. ");
INSERT INTO marc_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","आणि नोबाहने केनाथ आणि त्याच्या परिसरातील वस्त्या ताब्यात घेतल्या व त्याला नोबाह असे आपलेच नाव दिले. ");
INSERT INTO marc_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","मोशे आणि अहरोन यांच्या नेतृत्वाखाली इस्राएली लोक आपल्या तुकडीनुसार इजिप्तमधून बाहेर पडल्यानंतर त्यांच्या प्रवासाचे टप्पे असे होते. ");
INSERT INTO marc_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","याहवेहच्या आज्ञेनुसार मोशेने त्यांच्या प्रवासाच्या टप्प्यांची नोंद केली. टप्प्यानुसार त्यांचा प्रवास असा होता: ");
INSERT INTO marc_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","पहिल्या महिन्याच्या पंधराव्या दिवशी, वल्हांडणाच्या दुसर्‍या दिवशी इस्राएली लोक रामसेस येथून निघाले. सर्व इजिप्ती लोकांदेखत ते मोठ्या धैर्याने चालत बाहेर पडले, ");
INSERT INTO marc_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","त्यावेळी इजिप्तचे लोक आपल्या सर्व प्रथम जन्मलेल्या मुलांना ज्यांना याहवेहने जिवे मारले होते त्यांना दफन करीत होते; कारण याहवेहने त्यांच्या दैवतांवरही न्याय आणला होता. ");
INSERT INTO marc_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","इस्राएली लोकांनी रामसेस सोडले व सुक्कोथ येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","त्यांनी सुक्कोथ सोडले आणि वाळवंटाच्या काठावरील एथाम येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","त्यांनी एथाम सोडले व बआल-सफोनच्या पूर्वेकडे पी-हाहीरोथ कडे वळले आणि मिग्दोलकडे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","त्यांनी पी-हाहीरोथ सोडले व समुद्र पार रानात गेले आणि एथाम रानातील तीन दिवसांचा प्रवास केल्यानंतर माराह येथे त्यांनी तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","त्यांनी माराह सोडले व एलीम येथे गेले, त्या ठिकाणी पाण्याचे बारा झरे व खजुरीची सत्तर झाडे होती. तिथे त्यांनी तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","त्यांनी एलीम सोडले व तांबड्या समुद्राजवळ तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","त्यांनी तांबडा समुद्र सोडून सीनच्या रानात तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","सीनचे रान सोडून त्यांनी दोफकाह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","त्यांनी दोफकाह सोडले व अलूश येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","नंतर त्यांनी अलूश सोडले व रफीदीम येथे तळ दिला. या ठिकाणी लोकांना पिण्यासाठी पाणी नव्हते. ");
INSERT INTO marc_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","रफीदीम सोडल्यावर त्यांनी सीनायच्या रानात तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","मग सीनायच्या रानातून निघून त्यांनी किब्रोथ-हत्ताव्वा येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","नंतर त्यांनी किब्रोथ-हत्ताव्वा सोडले आणि हसेरोथ येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","त्यांनी हसेरोथ सोडले आणि रिथमाह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","मग त्यांनी रिथमाह सोडल्यावर रिम्मोन-पेरेस येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","त्यांनी रिम्मोन-पेरेस सोडले व लिब्नाह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","मग त्यांनी लिब्नाह सोडले व रिस्साह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","त्यांनी रिस्साह सोडले आणि केहेलाथाह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","त्यांनी केहेलाथाह सोडले आणि शेफर पर्वतावर तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","नंतर त्यांनी शेफर पर्वत सोडला आणि हारादाह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","त्यांनी हारादाह सोडले आणि माखेलोथ येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","माखेलोथ सोडल्यावर त्यांनी तहथ येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","तहथ सोडून त्यांनी तेराह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","नंतर त्यांनी तेराह सोडले व मितखाह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","त्यांनी मग मितखाह सोडले व हशमोनाह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","त्यांनी हशमोनाह सोडले आणि मोसेरोथ येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","त्यांनी मोसेरोथ सोडले आणि बेने-याकन येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","त्यांनी बेने-याकन सोडले आणि होर-हग्गीदगाद येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","त्यांनी होर-हग्गीदगाद सोडले आणि याटबाथह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","त्यांनी याटबाथह सोडले आणि आबरोनाह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","नंतर त्यांनी आबरोनाह सोडले आणि एजिओन-गेबेर येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","त्यांनी एजिओन-गेबेर सोडले आणि सीनच्या वाळवंटातील कादेश येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","त्यांनी कादेश सोडले आणि एदोमच्या सीमेवरील होर पर्वतावर तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","याहवेहच्या आज्ञेनुसार अहरोन याजक होर पर्वतावर गेला आणि इस्राएली लोक इजिप्तमधून बाहेर आल्यानंतर चाळिसाव्या वर्षाच्या पाचव्या महिन्याच्या पहिल्या दिवशी तो तिथे मरण पावला. ");
INSERT INTO marc_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","अहरोन होर पर्वतावर मरण पावला तेव्हा तो एकशे तेवीस वर्षांचा होता. ");
INSERT INTO marc_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","कनानी अरादचा राजा कनानाच्या नेगेव येथे राहत होता, त्याने इस्राएली लोक आपल्या देशाकडे येत आहेत असे ऐकले. ");
INSERT INTO marc_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","मग त्यांनी होर डोंगर सोडून जालमोनाह येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","नंतर त्यांनी जालमोनाह सोडले व पूनोन येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","पूनोन सोडल्यानंतर त्यांनी ओबोथ येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","त्यांनी ओबोथ सोडले व मोआबच्या सीमेवरील ईये-अबारीम येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","नंतर ईये-अबारीम सोडून त्यांनी दिबोन-गाद येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","दिबोन-गाद सोडल्यावर त्यांनी आलमोन-दिबलाथाइम येथे तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","त्यांनी आलमोन-दिबलाथाइम सोडले व नबोजवळ अबारीम डोंगराजवळ तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","मग त्यांनी अबारीम डोंगर सोडून मोआबाच्या मैदानात यार्देन नदीजवळ यरीहो समोर तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","तिथे मोआबाच्या मैदानात यार्देनजवळ बेथ-यशिमोथापासून आबेल-शित्तीमपर्यंत तळ दिला. ");
INSERT INTO marc_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","मोआबाच्या मैदानात यार्देनजवळ यरीहोजवळ याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“इस्राएली लोकांशी बोल व त्यांना सांग: ‘यार्देन पार करून तुम्ही जेव्हा कनान देशात जाल, ");
INSERT INTO marc_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","तेव्हा तिथे राहणार्‍या लोकांना तुमच्यापुढून घालवून द्या, त्यांच्या सर्व कोरीव आकृत्या व ओतीव मूर्त्यांचा नाश करा व त्यांची सर्व उच्च स्थाने नष्ट करा. ");
INSERT INTO marc_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","देशाचा ताबा घ्या व त्यात वस्ती करा, कारण तुम्ही त्यात वस्ती करावी म्हणून हा देश मी तुम्हाला दिला आहे. ");
INSERT INTO marc_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","तुमच्या कुळानुसार चिठ्ठ्या टाकून जमीन वाटप करावी. संख्येने मोठ्या असलेल्या गटाला मोठे वतन व लहान गटाला लहान वतन. चिठ्ठीद्वारे जे निघेल ते त्यांचे वतन होईल. तुमच्या पूर्वजांच्या गोत्रानुसार त्याची वाटणी करावी. ");
INSERT INTO marc_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘पण त्या ठिकाणच्या रहिवाशांना तुम्ही जर घालवले नाही, व त्यांना तुम्ही तिथेच राहू दिले, तर ते तुमच्या डोळ्यांना कुसळांसारखे आणि तुमच्या कूशीला काट्यांसारखे होतील. ज्या देशात तुम्ही राहाल त्यामध्ये ते तुम्हाला त्रास देतील. ");
INSERT INTO marc_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","आणि मग जसे मी त्यांचे करण्याचे योजले आहे, तसे तुमचे करेन.’ ” ");
INSERT INTO marc_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“इस्राएली लोकांस आज्ञा देऊन सांग: ‘जो देश तुम्हाला तुमचे वतन म्हणून दिला जाणार आहे त्या कनान देशात जेव्हा तुम्ही प्रवेश कराल तेव्हा त्याच्या सीमा अशाप्रकारे असाव्यात: ");
INSERT INTO marc_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘तुमच्या दक्षिणेचा विभाग सीन रानाच्या काही भागापासून एदोमाच्या सीमेपर्यंत असावा. तुमची दक्षिणेची सीमा मृत समुद्राच्या पूर्वेच्या टोकाकडून असावी, ");
INSERT INTO marc_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","तिथून तुमची सीमा अक्राब्बीमच्या चढावाच्या दक्षिणेस पोचून तिथून ती पुढे सीन पर्यंत जाऊन कादेश-बरनेआच्या दक्षिणेपर्यंत आणि हाजार अद्दारपर्यंत जाऊन आजमोनास पोचावी. ");
INSERT INTO marc_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","आजमोनाहून ती सीमा वळून इजिप्त देशाच्या ओहोळाला जाऊन मिळेल व भूमध्य समुद्राकडे संपेल. ");
INSERT INTO marc_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","तुमची पश्चिमेकडील सीमा भूमध्य समुद्राचा किनारा असेल. ही तुमची पश्चिम सीमा असावी. ");
INSERT INTO marc_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","तुमच्या उत्तरेकडील सीमेसाठी भूमध्य समुद्रापासून होर पर्वतापर्यंत रेखा आखावी. ");
INSERT INTO marc_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","आणि होर पर्वतापासून लेबो हमाथपर्यंत व तिथून ती सीमा जेदादपर्यंत न्यावी. ");
INSERT INTO marc_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","जिफरोनपर्यंत जाऊन तिचा शेवट हाजार-एनान येथे संपेल. ही तुमची उत्तरेकडील सीमा असेल. ");
INSERT INTO marc_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","तुमच्या पूर्वेकडील सीमेसाठी हाजार-एनानपासून शेफम पर्यंत रेखा आखावी. ");
INSERT INTO marc_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","तिथून ती सीमा शेफमपासून खाली रिब्लाह जे एईनच्या पूर्वेकडे आहे तिथपर्यंत जाईल आणि उताराला पुढे पूर्वेच्या बाजूने किन्नेरेथ समुद्रापर्यंत पोहोचेल. ");
INSERT INTO marc_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","नंतर ती सीमा यार्देन नदीच्या कडेने जाऊन मृत समुद्राकडे तिचा शेवट होईल.’ ");
INSERT INTO marc_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","मोशेने इस्राएली लोकांना ही आज्ञा दिली: “हा देश तुम्ही चिठ्ठ्या टाकून वतन म्हणून वाटप करावा. याहवेहने आज्ञा केली आहे की हा देश साडेनऊ गोत्रांना दिला जावा, ");
INSERT INTO marc_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","कारण रऊबेनचे गोत्र, गादचे गोत्र आणि मनश्शेहच्या अर्ध्या गोत्राच्या कुटुंबांना त्यांचे वतन मिळाले आहे. ");
INSERT INTO marc_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","या अडीच गोत्रांना त्यांचे वतन यरीहोजवळ, यार्देनच्या अलीकडे पूर्वेच्या बाजूला मिळाले आहे.” ");
INSERT INTO marc_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ज्या पुरुषांनी देश वतन म्हणून तुम्हाला वाटप करून द्यावा ते हे आहेत: एलअज़ार याजक आणि नूनाचा पुत्र यहोशुआ. ");
INSERT INTO marc_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","आणि देश वाटणीच्या मदतीसाठी प्रत्येक गोत्रातून एक पुढारी नेमावा. ");
INSERT INTO marc_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“ही त्यांची नावे आहेत: “यहूदाहच्या गोत्रातून, यफुन्नेहचा पुत्र कालेब; ");
INSERT INTO marc_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","शिमओनच्या गोत्रातून, अम्मीहूदाचा पुत्र शमुवेल; ");
INSERT INTO marc_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","बिन्यामीनच्या गोत्रातून, किसलोनचा पुत्र एलीदाद; ");
INSERT INTO marc_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","दानच्या गोत्रातून, योगलीचा पुत्र बुक्की हा पुढारी होता. ");
INSERT INTO marc_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","योसेफाचा पुत्र मनश्शेह याच्या गोत्रातून, एफोदचा पुत्र हन्नीऐल हा पुढारी होता. ");
INSERT INTO marc_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","योसेफाचा पुत्र एफ्राईम याच्या गोत्रातून, शिफतनचा पुत्र कमुवेल हा पुढारी होता. ");
INSERT INTO marc_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","जबुलूनच्या गोत्रातून, परनाखचा पुत्र एलीजाफान हा पुढारी होता. ");
INSERT INTO marc_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इस्साखारच्या गोत्रातून, अज्जानचा पुत्र पलतीएल हा पुढारी होता. ");
INSERT INTO marc_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आशेरच्या गोत्रातून, शलोमीचा पुत्र अहिहूद हा पुढारी होता. ");
INSERT INTO marc_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","नफताली गोत्रातून, अम्मीहूदाचा पुत्र पेदेहेल हा पुढारी होता.” ");
INSERT INTO marc_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","इस्राएली लोकांना कनान देशात वतन वाटून देण्यासाठी याहवेहने ज्या पुरुषांना आज्ञा दिली ते हे आहेत. ");
INSERT INTO marc_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","यरीहो समोर मोआबाच्या मैदानात यार्देनजवळ याहवेह मोशेला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“इस्राएली लोकांना आज्ञा दे की त्यांना मिळालेल्या वतनातून लेवी लोकांना राहण्यासाठी त्यांनी नगरे आणि नगराभोवतालची कुरणेही द्यावीत. ");
INSERT INTO marc_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","म्हणजे त्यांना राहण्यासाठी नगरे व त्यांच्या मालकीची असणारी त्यांची गुरे मेंढरे व सर्व इतर जनावरांसाठी कुरणे असावीत. ");
INSERT INTO marc_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“नगराभोवतालची जी कुरणे तुम्ही लेवी लोकांना देणार ती नगराच्या कुसापासून एक हजार हात असावी. ");
INSERT INTO marc_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","नगराबाहेर पूर्वेच्या दिशेने दोन हजार हात, दक्षिणेच्या दिशेने दोन हजार हात, पश्चिमेकडे दोन हजार हात व दोन हजार हात उत्तरेकडे मोजावे आणि नगर मध्यभागी असावे. हाच भाग त्यांच्या नगरांसाठी कुरण म्हणून असावा.” ");
INSERT INTO marc_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“लेवी लोकांना जी शहरे तुम्ही द्याल, त्यापैकी सहा शहरे आश्रयाची शहरे म्हणून असावीत, जर एखाद्या व्यक्तीने कोणाला जिवे मारले तर त्याने त्यात पळून जावे. त्याचबरोबर इतर बेचाळीस नगरे लेवी लोकांना द्यावीत. ");
INSERT INTO marc_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","अशी लेवी लोकांना त्यांच्या कुरणांसह एकंदर अठ्ठेचाळीस नगरे द्यावीत. ");
INSERT INTO marc_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","लेवी लोकांना जी नगरे तुम्ही द्याल ती इस्राएली लोकांच्या प्रत्येक गोत्राला मिळालेल्या वतनाच्या प्रमाणात: म्हणजे ज्यांना पुष्कळ नगरे मिळाली त्यांच्याकडून पुष्कळ, परंतु ज्यांना थोडी नगरे मिळाली त्यांच्याकडून थोडी नगरे घेऊन द्यावीत.” ");
INSERT INTO marc_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","नंतर याहवेह मोशेला म्हणाले: ");
INSERT INTO marc_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“इस्राएली लोकांशी बोल आणि त्यांना सांग: जेव्हा तुम्ही यार्देन पार करून कनानमध्ये जाल, ");
INSERT INTO marc_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","तुमच्यासाठी आश्रयनगरे व्हावी म्हणून तुम्ही काही शहरे निवडून ठेवा, म्हणजे कोणी एखाद्याला चुकून जिवे मारले तर त्याने तिथे पळून जावे. ");
INSERT INTO marc_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","सूड घेणार्‍यापासून आश्रय म्हणून ही नगरे तुमच्यासाठी असावीत, अशासाठी की खुनी असल्याचा दोष असणारा, मंडळीसमोर खटला होण्यापूर्वीच मारला जाऊ नये. ");
INSERT INTO marc_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ही जी सहा नगरे तुम्ही द्याल ती तुमच्यासाठी आश्रयाची नगरे म्हणून असतील. ");
INSERT INTO marc_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","या आश्रयाच्या नगरांपैकी तीन नगरे यार्देनेच्या अलीकडे व तीन कनानमध्ये असावीत. ");
INSERT INTO marc_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ही सहा नगरे इस्राएली लोकांसाठी व त्यांच्यामध्ये रहिवासी असलेल्या परदेशीयांसाठी सुद्धा आश्रयाचे ठिकाण असे असावे, अशासाठी की कोणी एखाद्याला चुकीने जिवे मारले असता त्याने त्या ठिकाणी पळून जावे. ");
INSERT INTO marc_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘जर कोणा व्यक्तीने लोखंडी वस्तूने एखाद्यावर घातक हल्ला केला, तर तो व्यक्ती खुनी आहे; खुनी मनुष्याला अवश्य जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","किंवा कोणी दगड घेऊन एखाद्यावर घातक हल्ला करतो, तो व्यक्ती खुनी आहे; खुनी मनुष्याला अवश्य जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","किंवा कोणी लाकडी वस्तू घेऊन एखाद्यावर घातक हल्ला करतो, तो व्यक्ती खुनी आहे; त्या खुनी मनुष्याला अवश्य जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","रक्ताचा सूड घेणार्‍याने त्या खुनी मनुष्याला जिवे मारावे; जेव्हा सूड घेणार्‍याला खुनी मनुष्य सापडेल; सूड घेणार्‍याने खुनी मनुष्याला जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","जर कोणी एखाद्याला द्वेषभावनेने लोटून दिले किंवा त्याने मरावे अशा हेतूने काही फेकून मारले ");
INSERT INTO marc_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","किंवा जर वैरभावाने एखाद्याला बुक्की मारली व तो मेला, तर त्या व्यक्तीला मारून टाकले जावे; कारण तो खुनी आहे. रक्ताचा सूड घेणारा जेव्हा त्या खुनी व्यक्तीला भेटेल तेव्हा त्याने त्याला अवश्य जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘पण काही शत्रुत्व नसताना अचानक कोणी एखाद्याला ढकलतो किंवा चुकीने त्यांच्यावर एखादी वस्तू फेकतो ");
INSERT INTO marc_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","किंवा न पाहताच त्यांना मारून टाकू शकेल असा जड दगड त्यांच्यावर टाकेल, व तो व्यक्ती जर मेला, परंतु ज्याने मारले तो त्याचा शत्रू नव्हता व त्याने ती हानी मुद्दाम केली नाही, ");
INSERT INTO marc_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","म्हणून मंडळीने या नियमानुसार आरोपी आणि रक्ताचा सूड घेणारा यांच्यात न्याय करावा. ");
INSERT INTO marc_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","खुनाचा आरोप असलेल्या व्यक्तीला मंडळीने रक्ताचा सूड घेणार्‍यापासून वाचवावे व तो ज्या आश्रयाच्या नगराकडे पळून गेला होता त्याकडे त्याला पाठवावे. पवित्र तेलाने अभिषेक झालेल्या मुख्य याजकाचा मृत्यू होईपर्यंत आरोपी मनुष्याने तिथेच राहावे. ");
INSERT INTO marc_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘परंतु आरोपी ज्या आश्रय नगरात पळून गेला आहे त्याच्या सीमेबाहेर गेला ");
INSERT INTO marc_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","आणि रक्ताचा सूड घेणार्‍याला तो शहराच्या बाहेर सापडला आणि रक्ताचा सूड घेणार्‍याने त्याला जिवे मारले तर त्या खुनासाठी तो दोषी ठरणार नाही. ");
INSERT INTO marc_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","कारण आरोपीने त्या आश्रयाच्या नगरात महायाजकाचा मृत्यू होईपर्यंत राहिले पाहिजे; महायाजकाच्या मृत्यूनंतर त्याने आपल्या स्वतःच्या घरी जावे. ");
INSERT INTO marc_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘हे सर्व तुमच्या येणार्‍या पिढ्यांसाठी तुम्ही जिथे वस्ती कराल तिथे तुमच्या न्यायाचे नियम म्हणून असावे. ");
INSERT INTO marc_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘जो कोणी एखाद्याचा खून करतो त्याला केवळ साक्षीदाराच्या साक्षीनुसारच जिवे मारावे. परंतु केवळ एकाच साक्षीच्या आधारावर कोणाला जिवे मारू नये. ");
INSERT INTO marc_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘खुनी व्यक्तीच्या जिवासाठी खंडणी स्वीकारू नये, जो दोषी मरणास पात्र आहे त्याला अवश्य जिवे मारावे. ");
INSERT INTO marc_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘जो आश्रयाच्या नगरात पळून गेला आहे, त्याने महायाजकाच्या मृत्यूच्या आधी आपल्या स्वतःच्या घरी जाऊन राहावे म्हणून त्याच्या जिवासाठी खंडणी स्वीकारू नये. ");
INSERT INTO marc_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘तुम्ही राहत असलेला देश भ्रष्ट करू नका. रक्तपाताने देश भ्रष्ट होतो आणि ज्या देशात रक्तपात होतो त्याच्यासाठी ज्याने रक्तपात केला त्याच्या रक्ताशिवाय प्रायश्चित होऊ शकत नाही. ");
INSERT INTO marc_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ज्या देशात तुम्ही राहता व जिथे मी निवास करतो तो तुम्ही अशुद्ध करू नये, कारण मी याहवेह इस्राएली लोकांमध्ये निवास करतो.’ ” ");
INSERT INTO marc_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","योसेफाच्या वंशाच्या कुळातील, मनश्शेहचा पुत्र माखीरचा पुत्र गिलआदच्या कुटुंबाचे कुलप्रमुख मोशे व पुढारी, म्हणजे इस्राएली कुटुंबाच्या पुढाऱ्यांपुढे येऊन बोलले. ");
INSERT INTO marc_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","ते म्हणाले, “माझ्या प्रभूला याहवेहने आज्ञा दिली की इस्राएली लोकांना हा देश चिठ्ठ्या टाकून वतन म्हणून द्यावा, याहवेहने तुला आज्ञा दिली की आमचा भाऊ सलाफहादचे वतन त्याच्या मुलींना द्यावे. ");
INSERT INTO marc_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","परंतु त्यांनी जर इस्राएलातील इतर गोत्रातील पुरुषांशी लग्न केले, तर त्यांचे वतन आमच्या पूर्वजांच्या वतनातून काढून ज्या गोत्रात त्या लग्न करून जातील त्यांच्यात जोडले जाईल. म्हणजे आम्हाला मिळालेल्या वतनाचा भाग काढून घेतला जाईल. ");
INSERT INTO marc_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","आणि जेव्हा इस्राएल लोकांचे योबेल वर्ष येईल, तेव्हा त्यांचे वतन ज्या गोत्रात ते लग्न करून जातील त्यांच्यात जोडले जाईल आणि त्यांचे वतन आमच्या पूर्वजांच्या गोत्रातून काढून घेतले जाईल.” ");
INSERT INTO marc_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","नंतर याहवेहच्या आज्ञेनुसार मोशेने इस्राएली लोकांना हा हुकूम दिला: “योसेफाच्या गोत्राचे वंशज जे म्हणत आहेत ते बरोबर आहे. ");
INSERT INTO marc_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","सलाफहादच्या कन्यांसंबंधी याहवेह अशी आज्ञा देतात: त्यांना आवडेल त्या व्यक्तीशी त्यांनी विवाह करावा, परंतु आपल्याच पित्याच्या गोत्राच्या कुळात त्यांनी विवाह करावा. ");
INSERT INTO marc_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","इस्राएलचे वतन एका गोत्रातून दुसर्‍या गोत्रात जाऊ नये, तर प्रत्येक इस्राएली व्यक्तीने आपल्या पूर्वजांच्या गोत्राच्या वतनाला जपावे. ");
INSERT INTO marc_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","इस्राएली लोकांतील कोणत्याही गोत्रातील ज्या प्रत्येक मुलीला वतन मिळाले असेल, तिने आपल्या पित्याच्या गोत्राच्या कुळातील एखाद्या व्यक्तीशी विवाह करावा, यासाठी की प्रत्येक इस्राएली व्यक्तीला आपल्या पूर्वजांचे वतन मिळेल. ");
INSERT INTO marc_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","कोणतेही वतन एका गोत्रातून दुसर्‍या गोत्रात जाणार नाही, तर इस्राएली लोकांच्या प्रत्येक गोत्राने आपल्या वतनाला जपावे.” ");
INSERT INTO marc_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","याहवेहने मोशेला दिलेल्या आज्ञेनुसार सलाफहादच्या कन्यांनी केले. ");
INSERT INTO marc_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","सलाफहादच्या कन्या म्हणजे महलाह, तिरजाह, होगलाह, मिल्काह व नोआहने त्यांच्या पित्याच्या चुलत भावांशी विवाह केला. ");
INSERT INTO marc_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","त्यांनी योसेफाचा पुत्र मनश्शेहच्या गोत्राच्या कुळातच विवाह केला व त्यांचे वतन त्यांच्या पित्याच्या गोत्रात व कुळातच राहिले. ");
INSERT INTO marc_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","मोआबाच्या मैदानात यरीहोजवळ यार्देनकडे मोशेद्वारे याहवेहने इस्राएली लोकांसाठी ज्या आज्ञा व नियम लावून दिले ते हेच आहेत.");
INSERT INTO marc_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","इस्राएली लोक यार्देन नदीच्या पूर्वेस असणार्‍या रानातील अराबा नावाच्या दरीमध्ये तळ देऊन राहिले होते, त्यावेळी मोशे जे बोलला त्या सर्व गोष्टीची नोंद या पुस्तकात केलेली आहे. या प्रदेशात सूफ, पारान, तोफेल, लाबान, हसेरोथ व दीजाहाब इत्यादी शहरांचा समावेश होतो. ");
INSERT INTO marc_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(सेईर डोंगरमार्गे होरेब ते कादेश-बरनेआपर्यंतचा प्रवास अकरा दिवसाचा होता.) ");
INSERT INTO marc_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","चाळिसाव्या वर्षाच्या, अकराव्या महिन्याच्या पहिल्या दिवशी, याहवेहने आज्ञा केल्याप्रमाणे मोशेने इस्राएली लोकांना हे सर्व सांगितले. ");
INSERT INTO marc_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","हे मोशेने जाहीर करण्यापूर्वीच अमोर्‍यांचा राजा सीहोनाचा हेशबोन येथे पराभव करण्यात आला होता व एद्रेई जवळील अष्टारोथ येथे बाशानचा राजा ओगचाही पराभव करण्यात आला होता. ");
INSERT INTO marc_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","यार्देनच्या पूर्वेकडील मोआब प्रदेशात मोशे इस्राएली लोकांशी नियमांसंबंधी बोलला. तो म्हणाला: ");
INSERT INTO marc_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","आपल्या याहवेह परमेश्वरांनी चाळीस वर्षांपूर्वी होरेब येथे आपल्याला सांगितले होते, “तुम्ही या पर्वताजवळ खूप दिवस राहिलात; ");
INSERT INTO marc_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","आता तुम्ही येथून जा व अमोर्‍यांचा डोंगराळ प्रदेश, अराबाची दरी, नेगेव, कनान व लबानोन आणि भूमध्य समुद्रकिनार्‍यापासून ते फरात नदीच्या काठापर्यंत पसरलेल्या संपूर्ण प्रदेशात जाऊन वस्ती करा. ");
INSERT INTO marc_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","पाहा, मी हा सर्व प्रदेश तुम्हाला देत आहे. तुम्ही जा व तो प्रदेश हस्तगत करा. कारण याहवेहने तो प्रदेश अब्राहाम, इसहाक व याकोब या तुमच्या पूर्वजास व त्यांच्या वंशजास दिलेला वचनदत्त देश आहे.” ");
INSERT INTO marc_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","त्यावेळी मी तुम्हाला सांगितले होते, “माझ्या शक्तीपलीकडे असलेले मी एकट्यानेच वाहून नेणारे तुमचे मोठे ओझे माझ्यावर पडले आहे. ");
INSERT INTO marc_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","कारण याहवेह तुमच्या परमेश्वराने तुमची संख्या आकाशातील तार्‍यांप्रमाणे अगणित केली आहे, ");
INSERT INTO marc_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","याहवेह तुमच्या पूर्वजांच्या परमेश्वरांनी जे तुम्हाला अभिवचन दिले होते, त्यानुसार तुमची संख्या हजारपटीने वाढवो आणि तुम्हाला आशीर्वाद देवो! ");
INSERT INTO marc_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","तुमच्या समस्या, तुमचे ओझे व तुमची भांडणे माझ्यासारखा एकटा मनुष्य कसा सोडवू शकेल? ");
INSERT INTO marc_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","तेव्हा तुम्हीच प्रत्येक गोत्रांमधून सुज्ञ, समजूतदार व प्रतिष्ठित अशी काही माणसे निवडा, म्हणजे मी त्यांना तुमचे पुढारी नेमीन.” ");
INSERT INTO marc_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","तुम्ही मला उत्तर देऊन म्हणाला, “तुम्ही जे करण्याचा प्रस्ताव दिला ते उत्तम आहे.” ");
INSERT INTO marc_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","म्हणून मी तुमच्या प्रत्येक गोत्रांतून प्रमुख, ज्ञानी आणि आदरणीय पुरुष घेतले आणि त्यांना हजारांवर, शंभरांवर, पन्नासांवर व दहांवर प्रमुख व अधिकारी म्हणून नेमले. ");
INSERT INTO marc_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","आणि त्यावेळी मी तुमच्या न्यायाधीशांना आज्ञा केली, “तुमच्या लोकांचा वाद ऐकून त्यावर न्याय करावा, मग तो दोन इस्राएली लोकांमधील असो किंवा इस्राएली आणि तुमच्यामध्ये राहणारे परदेशी यांच्यातील असो. ");
INSERT INTO marc_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","न्याय करताना पक्षपातीपणा दाखवू नका; लहान व मोठे यांचे म्हणणे समानतेत ऐकून घ्या. कोणालाही घाबरू नका; कारण न्याय हा परमेश्वराकडूनच असतो. ज्या तक्रारी तुम्हाला सोडविण्यास कठीण वाटतील, त्या माझ्याकडे आणा आणि मी ऐकेन.” ");
INSERT INTO marc_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","आणि त्यावेळी मी तुम्हाला जे काही करावयाचे आहे ते सर्व सांगितले होते. ");
INSERT INTO marc_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","नंतर आम्ही होरेब येथून प्रस्थान केले व जो तुम्ही पाहिला होता अशा अफाट आणि भयानक अशा अरण्यातून प्रवास करीत, याहवेह आमच्या परमेश्वराच्या आज्ञेप्रमाणे शेवटी अमोर्‍यांच्या डोंगराळ प्रदेशात पोहोचलो आणि आम्ही कादेश-बरनेआस आलो. ");
INSERT INTO marc_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","तेव्हा मी तुम्हाला सांगितले, “आता तुम्ही अमोर्‍यांच्या डोंगराळ प्रदेशात येऊन पोहोचला आहात, जो याहवेह आमचे परमेश्वर आम्हाला देणार आहेत. ");
INSERT INTO marc_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","पाहा, याहवेह तुमच्या परमेश्वराने हा देश तुम्हाला दिला आहे. तुमच्या पूर्वजांचे देव परमेश्वरांनी सांगितल्याप्रमाणे वर जा आणि तो आपल्या ताब्यात घ्या. घाबरू नका; निराश होऊ नका.” ");
INSERT INTO marc_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","तेव्हा तुम्ही सर्व लोक माझ्याकडे आले आणि म्हणाले, “आधी आपण आपले हेर पाठवू म्हणजे कुठल्या मार्गाने त्या देशात प्रवेश करावा व त्यांची कोणती शहरे लागतील हे शोधून काढणे सोपे होईल.” ");
INSERT INTO marc_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ही गोष्ट मला चांगली वाटली; म्हणून मी प्रत्येक गोत्रातून एक असे बारा हेर निवडले. ");
INSERT INTO marc_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","तिथून निघून ते डोंगराळ प्रदेशात पोहोचले आणि ते अष्कोल दरीपर्यंत आले व त्यांनी त्या प्रदेशाची पाहणी केली. ");
INSERT INTO marc_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","तिथून परत येताना त्यांनी त्या ठिकाणची फळे आपल्याबरोबर आणली व असा अहवाल दिला: “जो देश याहवेह आमचे परमेश्वर आम्हाला देत आहेत तो खरोखरच चांगला आहे.” ");
INSERT INTO marc_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","परंतु तुम्ही वर जाण्यास नाकारले व याहवेह तुमच्या परमेश्वराच्या आज्ञेविरुद्ध बंड केले. ");
INSERT INTO marc_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","आपल्या तंबूत बसून तुम्ही कुरकुर केली आणि म्हटले, “याहवेह आमचा द्वेष करीत आहेत, म्हणून अमोर्‍यांच्या हातून आमचा नाश व्हावा यासाठी त्यांनी आम्हाला इजिप्त देशातून इकडे आणले आहे. ");
INSERT INTO marc_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","आम्ही आता कुठे जावे? आमच्या हेरबंधूंच्या वार्तेमुळे आम्ही भयभीत झालो आहोत. ते म्हणतात की, ‘त्या देशातील लोक आपल्यापेक्षा धिप्पाड आणि बलवान आहेत. त्यांची नगरे खूप मोठी असून नगरतट तर इतके उंच आहेत की ते जणू काही आकाशाला भिडले आहेत. आम्ही तिथे अनाकाचे वंशज देखील पाहिले आहेत.’ ” ");
INSERT INTO marc_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","तेव्हा मी त्यांना म्हणालो, “असे भयभीत होऊ नका, त्यांना घाबरू नका. ");
INSERT INTO marc_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","31","कारण याहवेह तुमचे परमेश्वर तुमच्यापुढे जात आहेत, ते तुमच्यावतीने त्यांच्याशी लढतील, जसे तुमच्या डोळ्यादेखत त्यांनी इजिप्त देशात आणि अरण्यात असताना केले. ज्याप्रमाणे पिता आपल्या मुलांची सर्वतोपरी काळजी घेतो, त्याप्रमाणे याहवेह परमेश्वराने इथे पोहोचेपर्यंत तुमची सतत काळजी घेतली.” ");
INSERT INTO marc_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","पण तरीही तुम्ही याहवेह तुमच्या परमेश्वरावर विश्वास ठेवण्याचे नाकारले. ");
INSERT INTO marc_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ज्यांनी प्रवासात तुमच्यापुढे राहून रात्री अग्नीने आणि दिवसा मेघांनी तुमचे मार्गदर्शन केले, वाटेत विश्रांतीसाठी उत्तमोत्तम जागा निवडल्या, ते रात्री अग्नीने आणि दिवसा मेघांनी तुमचे मार्गदर्शन करीत. ");
INSERT INTO marc_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","तुम्ही जे म्हटले ते याहवेहनी ऐकले आणि ते रागावले व त्यांनी शपथपूर्वक म्हटले: ");
INSERT INTO marc_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“या पिढीतील एकाच्याही दृष्टीस मी त्यांच्या पूर्वजांना वचनदत्त केलेली उत्तम भूमी पडू देणार नाही. ");
INSERT INTO marc_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","परंतु यफुन्नेहचा पुत्र कालेब, जो मला पूर्णपणे अनुसरून चालला, त्याचे पाय ज्या भूमीला लागतील ती भूमी मी त्याच्या वंशजांना देईन, कारण तो याहवेहच्या मागे पूर्ण अंतःकरणाने चालला.” ");
INSERT INTO marc_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","तुमच्यामुळे याहवेह माझ्यावरही रागावले व म्हणाले, “तू या वचनदत्त देशात प्रवेश करणार नाहीस. ");
INSERT INTO marc_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","पण तुझा मदतनीस, नूनाचा पुत्र यहोशुआ प्रवेश करेल. तू त्याला प्रोत्साहन दे, कारण तो या वतनाचा ताबा घेण्यासाठी इस्राएली लोकांचे मार्गदर्शन करेल. ");
INSERT INTO marc_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","जी बालके पारतंत्र्यात जातील असे तुम्ही म्हणता, ज्यांना त्यांचे बरेवाईटही कळत नाही, त्यांना मी तो देश बहाल करेन आणि ते त्याला आपल्या ताब्यात घेतील. ");
INSERT INTO marc_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","परंतु तुम्ही मागे वळून वाळवंटातून तांबड्या समुद्राच्या वाटेने कूच करावे.” ");
INSERT INTO marc_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","तेव्हा लोकांनी कबुली दिली, “आम्ही याहवेहविरुद्ध पाप केले आहे; आम्ही आमच्या वचनदत्त देशात जाऊ व तो मिळविण्यासाठी याहवेह परमेश्वराच्या आज्ञेनुसार आम्ही वर जाऊन लढाई करू.” असे म्हणून त्यांना आपली शस्त्रे सरसावली. त्यांना वाटले की हा सर्व डोंगराळ प्रदेश आपण सहज जिंकून घेऊ. ");
INSERT INTO marc_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","परंतु याहवेह मला म्हणाले, “त्यांना सांग, ‘लढाई करण्यास वर जाऊ नका, कारण मी तुमच्याबरोबर राहणार नाही. तुमचा तुमच्या शत्रूकडून पराभव होईल.’ ” ");
INSERT INTO marc_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","तुम्हाला मी तसे सांगितले, पण तुम्ही माझे ऐकले नाही. उलट पुन्हा याहवेहच्या आज्ञेविरुद्ध बंड केले आणि धिटाई करून त्या डोंगराळ देशात शत्रूवर चाल करून गेले. ");
INSERT INTO marc_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","तिथे डोंगराळ देशात राहणार्‍या अमोर्‍यांनी तुमच्यावर चाल करून मधमाश्यांप्रमाणे सेईरपासून होरमाहपर्यंत तुमचा पाठलाग केला व तुम्हाला मार दिला. ");
INSERT INTO marc_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","यानंतर तुम्ही परत येऊन याहवेहसमोर शोक करू लागलात, परंतु त्यांनी तुमच्या रडण्याकडे लक्ष दिले नाही. ");
INSERT INTO marc_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","म्हणून तुम्ही कादेश येथेच दीर्घकाल राहिला, असे तुम्ही तिथे दिवस घालविले. ");
INSERT INTO marc_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","नंतर आम्ही मागे वळून अरण्यामधून तांबड्या समुद्राकडे निघालो, कारण याहवेहनी मला तशी आज्ञा दिली होती आणि अनेक वर्षे आम्ही सेईर पर्वताच्या सभोवतालच्या प्रदेशात भ्रमण करीत राहिलो. ");
INSERT INTO marc_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","मग याहवेह मला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“तुम्ही या पर्वताच्या सभोवती दीर्घकाल राहिला आहात, तर आता उत्तरेकडे वळा. ");
INSERT INTO marc_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","लोकांना आदेश दे: ‘सेईर येथे राहणार्‍या एसावाच्या वंशजाच्या, म्हणजे त्यांच्या एदोमी भाऊबंदांच्या देशातून ते पुढे जाणार आहेत. तुमची त्यांना भीती वाटेल, म्हणून तुम्ही खबरदारी घ्या. ");
INSERT INTO marc_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","त्यांना लढाईला प्रवृत्त करू नका, कारण त्यांची भूमी मी तुम्हाला देणार नाही, मी तुम्हाला तिथे पाऊल ठेवण्यासही जागा देणार नाही. मी सेईर पर्वताचा मुलूख एसावाला दिला आहे. ");
INSERT INTO marc_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","तुम्ही तिथे जे काही अन्न खाल व पाणी प्याल त्याच्या मोबदल्यात त्यांना चांदी द्या.’ ” ");
INSERT INTO marc_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","याहवेह तुमच्या परमेश्वराने तुमच्या हाताच्या प्रत्येक कार्याला आशीर्वादित केले आहे. या विशाल अरण्यात तुमचे भटकणे त्यांनी पाहिले आहे, चाळीस वर्षे याहवेह तुमचे परमेश्वर तुमच्याबरोबर आहेत व तुम्हाला कशाचेही उणे पडले नाही. ");
INSERT INTO marc_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","म्हणून आम्ही सेईर येथे राहणाऱ्या एसावाच्या वंशातील भाऊबंदांच्या देशाला वळसा घालून दक्षिणेकडे एलाथ व एजिओन-गेबेरकडे जाणारा अराबाचा रस्ता पार करून उत्तरेकडे प्रवास करीत मोआब वाळवंटाकडे निघालो. ");
INSERT INTO marc_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","तेव्हा याहवेह आम्हाला म्हणाले, “मोआबी लोकांना उपद्रव किंवा लढाईसाठी प्रवृत करू नका, कारण मी त्यांच्या देशाचा कोणताही भाग वतन म्हणून तुम्हाला देणार नाही. मी लोटाच्या वंशजांना आर प्रदेश वतन म्हणून दिला आहे.” ");
INSERT INTO marc_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(एमी लोक त्या भागात राहात होते—बलवान व बहुसंख्य आणि अनाकी लोकांसारखे उंच असे होते. ");
INSERT INTO marc_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","एमी व अनाकी या दोन्हीही जमातीस पुष्कळदा रेफाईम असेही म्हणत, पण मोआबी मात्र त्यांना एमीच म्हणत. ");
INSERT INTO marc_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","पूर्वीच्या काळी होरी लोक सेईरमध्ये राहत असत, परंतु एसावाचे वंशज एदोमींनी त्यांना तिथून घालवून दिले व तिथे वस्ती केली. याहवेहने वतन दिलेल्या प्रदेशातून ज्याप्रमाणे इस्राएली लोकांनी तेथील लोकांना घालवून दिले होते त्याचप्रमाणे.) ");
INSERT INTO marc_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","आणि याहवेह म्हणाले, “आता उठा आणि जेरेद ओहोळ पार करून जा.” तेव्हा आम्ही ओहोळ पार केला. ");
INSERT INTO marc_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","पण कादेश-बरनेआहून निघून जेरेद ओहोळ ओलांडून जाण्यास आम्हाला तब्बल अडतीस वर्षे लागली, कारण याहवेहने घेतलेल्या शपथेमुळे लढाऊ पुरुषांची संपूर्ण पिढी छावणीतून नष्ट झाली होती. ");
INSERT INTO marc_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","त्या सर्वांचा नाश होईपर्यंत छावणीतून त्यांचा संहार करावा म्हणून याहवेहचा हात त्यांच्यावर उगारलेला होता. ");
INSERT INTO marc_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","आता जेव्हा या लोकांमधील शेवटचा योद्धा मरण पावला, ");
INSERT INTO marc_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","याहवेह मला म्हणाले, ");
INSERT INTO marc_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“आज तुम्हाला आर येथे मोआबाची सीमा ओलांडून जायचे आहे. ");
INSERT INTO marc_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","जेव्हा तुम्ही अम्मोनी लोकांच्या भूमीत प्रवेश कराल, अम्मोनी लोकांना त्रास देऊ नका, कारण मी त्यांचा कोणताही प्रदेश तुम्हाला देणार नाही, तो सर्व मी लोटाच्या वंशजांना वतनादाखल दिला आहे.” ");
INSERT INTO marc_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(तो देश तिथे राहाणाऱ्या रेफाईम लोकांचा देखील मानला जात होता; परंतु अम्मोनी लोक त्यांना जमजुम्मी म्हणत. ");
INSERT INTO marc_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","त्यांच्या वंशातील लोक धिप्पाड आणि संख्येने पुष्कळ होते. ते अनाकी लोकांइतके उंच होते, परंतु अम्मोनी लोकांपुढून त्यांना याहवेहने घालवून दिले व त्यांच्या नाश केला. त्यांच्या जागी अम्मोन्यांनी त्या देशात वस्ती केली. ");
INSERT INTO marc_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","जेव्हा तिथे राहणार्‍या होरी लोकांना त्यांनी घालवून लावले व त्यांचा नाश केला. त्यांनी त्यांना हुसकावून लावले आणि आजपर्यंत त्यांच्या जागी ते वस्ती करून राहत आहेत, त्याचप्रमाणे सेईर येथे राहाणाऱ्या एसावाच्या वंशजांसाठीही याहवेहने असेच केले. ");
INSERT INTO marc_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","गाझा शहरापर्यंत विखुरलेल्या गावातून वस्ती करून राहिलेल्या अव्वी लोकांवर कफतोरहून आलेल्या कफतोरी लोकांनी हल्ला चढवून त्यांचा संहार केला व त्या ठिकाणी वस्ती केली.) ");
INSERT INTO marc_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“आता उठा आणि आर्णोन नदी ओलांडून जा. पाहा, हेशबोनचा राजा अमोरी सीहोन आणि त्याचा देश मी तुमच्या हाती दिला आहे. तो देश ताब्यात घेण्यास सुरुवात करा व त्याच्याशी युद्ध करा. ");
INSERT INTO marc_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","आजपासून पुढे मी असे करेन की अखिल पृथ्वीतलावरील लोक तुमच्यापुढे भीतीने थरथर कापतील व तुमच्या आगमनाची चाहूल लागताच दहशत घेतील.” ");
INSERT INTO marc_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","नंतर शांततेची बोलणी करण्याकरिता मी केदेमोथच्या रानातून हेशबोनचा राजा सीहोनकडे दूत पाठवून म्हटले, ");
INSERT INTO marc_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“आम्हाला तुझ्या देशामधून जाऊ दे. आम्ही मुख्य रस्त्यावरच राहू; उजवीकडे वा डावीकडे वळणारही नाही. ");
INSERT INTO marc_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","आम्ही वाटेने जात असताना तुमचे अन्न व पाणी तुमच्याकडून चांदीच्या किमतीत विकत घेऊ. तुमच्या देशातून पायी चालत जाण्याची फक्त आम्हाला परवानगी द्या— ");
INSERT INTO marc_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","सेईरमध्ये राहणारे एसावाचे वंशज आणि आरवासी मोआबी यांनी आमच्यासाठी केले—आम्ही यार्देन ओलांडून याहवेह आमचे परमेश्वर आम्हाला देत असलेल्या देशात जाईपर्यंत तुम्ही आमच्यासोबत करा.” ");
INSERT INTO marc_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","परंतु हेशबोनाच्या सीहोन राजाने आम्हाला जाण्यास परवानगी दिली नाही. याहवेह तुमच्या परमेश्वराने त्याला तुमच्या हातात देण्यासाठी त्याचा आत्मा हट्टी आणि त्याचे हृदय कठीण केले होते. ");
INSERT INTO marc_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","मग याहवेह म्हणाले, “सीहोन राजाचा देश तुम्हाला देण्यास मी आता सुरुवात केली आहे. जेव्हा तुम्ही तो देश ताब्यात घ्याल, तेव्हा तो कायमचा तुमच्या मालकीचा होईल.” ");
INSERT INTO marc_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","सीहोन आणि त्याची सर्व सेना आमच्यासोबत युद्ध करण्यास याहस येथे एकत्रित झाली, ");
INSERT INTO marc_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","परंतु याहवेह आमच्या परमेश्वराने त्याला आमच्या अधीन केले, आम्ही त्याला, त्याच्या पुत्रांसह संपूर्ण सेनेला चिरडून टाकले. ");
INSERT INTO marc_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","त्यावेळी आम्ही त्याची सर्व नगरे घेतली. त्यांच्या सर्वांचा नाश केला—पुरुष, स्त्रिया आणि मुले. आम्ही कोणालाही जिवंत सोडले नाही. ");
INSERT INTO marc_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","फक्त त्यांची गुरे जिवंत ठेवली. त्यांची नगरे काबीज करून ती सर्व संपत्ती आम्ही घेतली. ");
INSERT INTO marc_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","आर्णोन खोर्‍याच्या कडेला असलेल्या अरोएर शहरापासून खोर्‍यातील शहरापर्यंत व त्या शहरापासून गिलआदापर्यंत एकही दुर्गम शहर राहिले नाही. याहवेह आमच्या परमेश्वराने हे सर्व आमच्या अधीन करून दिले. ");
INSERT INTO marc_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","मात्र याहवेह आमच्या परमेश्वराच्या आज्ञेनुसार अम्मोनी लोकांच्या प्रदेशापासून आम्ही दूरच राहिलो. तसेच यब्बोक नदी व त्या डोंगराळ प्रदेशात वसलेल्या शहरापासूनही आम्ही दूर राहिलो. ");
INSERT INTO marc_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","मग आम्ही वळलो आणि बाशानाच्या वाटेने वर गेलो आणि बाशानचा राजा ओग आपले सर्व सैन्य जमवून आमच्याशी युद्ध करण्यासाठी एद्रेई येथे आला. ");
INSERT INTO marc_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","याहवेहने मला म्हटले, “त्याला भिऊ नकोस; कारण मी त्याला व त्याच्या सर्व सैन्याला तुझ्या हाती दिले आहे. अमोर्‍यांचा राजा सीहोन जो हेशबोनात राज्य करीत होता त्याचे तू जसे केले तसेच याचे कर.” ");
INSERT INTO marc_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","याप्रमाणे याहवेह आमच्या परमेश्वराने बाशानचा ओग राजा त्याच्या सर्व सैन्यासह आमच्या अधीन झाला. आम्ही त्यांचा असा संहार केला की त्यांच्यातील कोणीही मागे जिवंत राहिला नाही. ");
INSERT INTO marc_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","त्याची सगळी शहरे आम्ही त्यावेळी घेतली होती. अर्गोबचा संपूर्ण प्रदेश आणि बाशानमधील ओगचे राज्य, साठ नगरातील असे एकही शहर राहिले नाही जे आम्ही त्यांच्याकडून घेतले नाही. ");
INSERT INTO marc_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","या सर्व शहरांच्या तटबंदी उंच व दरवाजे लोखंडी गजांचे होते. शिवाय बरीच तटबंदी नसलेली गावेही होती. ");
INSERT INTO marc_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ज्याप्रकारे आपण सीहोन राज्याचा हेशबोन येथे नाश केला, त्याच प्रकारे आपण बाशानच्या राज्यातील संपूर्ण शहरांचा—पुरुष, स्त्रिया व मुले यासहित समूळ नायनाट केला. ");
INSERT INTO marc_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","पण त्यांची सर्व गुरे व शहरातून मिळालेली लूट आपण आपल्यासाठी नेली. ");
INSERT INTO marc_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","म्हणून आपल्या ताब्यात दोन्हीही राजांचे सर्व प्रदेश, म्हणजे यार्देनेच्या पूर्वेकडे आर्णोन खिंडीपर्यंत असलेला हर्मोन पर्वतापर्यंतचा अमोर्‍यांचा सर्व प्रदेश आपल्या ताब्यात आला. ");
INSERT INTO marc_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(सीदोनी लोक हर्मोन पर्वतास सिर्योन असेही म्हणत, पण अमोरी लोक त्याला सनीर म्हणत असत.) ");
INSERT INTO marc_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","आतापर्यंत आपण पठारावरील सर्व शहरे, संपूर्ण गिलआद आणि बाशान, सलेकाह व एद्रेई, ओग या शहरांपर्यंतची सर्व शहरे काबीज केली. ");
INSERT INTO marc_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(रेफाईम लोकांपैकी बाशानचा राजा ओग हा शेवटचा होता. त्याचा पलंग लोखंडाने सजविला होता आणि तो चार हात लांब आणि दोन हात रुंद होता. तो अजूनही अम्मोनी लोकांच्या राब्बाहमध्ये आहे.) ");
INSERT INTO marc_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","त्यावेळी आपण काबीज केलेला प्रदेश मी रऊबेन व गाद यांच्या वंशास दिला. रऊबेन व गादच्या वंशांना मी आर्णोन नदीवरील अरोएरापासून गिलआद पर्वताचा अर्धा भाग त्यातील शहरांसह दिला. ");
INSERT INTO marc_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","गिलआद पर्वताचा उरलेला अर्धा भाग आणि ओग राजाचे पूर्वीचे राज्य म्हणजे अर्गोब विभाग हा मनश्शेहच्या अर्ध्या गोत्रास दिला. (बाशानच्या अर्गोब प्रदेशाला रेफाईमचा देश असेही म्हणत. ");
INSERT INTO marc_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","मनश्शेहच्या वंशातील याईराच्या कुळाने गशूरी व माकाथी लोकांच्या सीमेपर्यंतचा अर्गोबचा संपूर्ण प्रदेश आपल्या ताब्यात घेतला; त्याच्या नावावरून त्या प्रदेशाचे नाव पडले, त्यामुळे आजपर्यंत बाशानाला हव्योथ याईर म्हणतात.) ");
INSERT INTO marc_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","आणि मी गिलआद देश माखीरला दिला. ");
INSERT INTO marc_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","रऊबेन आणि गाद यांना मात्र गिलआद देशातील यब्बोक नदीपासून ते आर्णोन नदीच्या खोर्‍याच्या मध्यापर्यंतचा सर्व भाग मिळाला. गिलआद ही अम्मोन लोकांची सीमा होती. ");
INSERT INTO marc_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","तसेच किन्नेरेथाच्या समुद्रापासून अराबाचा समुद्र (म्हणजे मृत समुद्र) आणि पिसगाच्या उतरणी खालील अराबा व यार्देनेच्या पश्चिमेकडील सर्व प्रदेशही त्यांनाच मिळाला. ");
INSERT INTO marc_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","त्यावेळी मी तुम्हाला आज्ञा दिली: “याहवेह तुमच्या परमेश्वराने हा प्रदेश तुम्हाला वतन म्हणून दिलेला आहे, परंतु तुम्ही त्यात वस्ती करण्यापूर्वी तुमच्या सक्षम योद्ध्यांना शस्त्रे धारण करून यार्देन ओलांडून इतर इस्राएलाच्या पुढे पाठवावे. ");
INSERT INTO marc_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","तुमच्या स्त्रिया, मुले आणि तुमची जनावरे (मला माहीत आहे तुमच्याकडे विपुल गुरे आहेत) यांना मी तुम्हाला दिलेल्या शहरात राहता येईल, ");
INSERT INTO marc_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","यार्देनेच्या पश्चिमेला याहवेह देत असलेल्या देशात तुमचे इस्राएली बांधव वस्ती करेपर्यंत आणि याहवेह तुमच्या परमेश्वराने ज्याप्रमाणे तुम्हाला विसावा दिला आहे, त्याप्रमाणे त्यांनाही विसावा मिळेपर्यंत, तुमच्या बांधवांना मदत करा. त्यानंतर जो प्रदेश मी तुम्हाला दिला आहे येथे तुम्ही आपल्या वतनावर परत यावे.” ");
INSERT INTO marc_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","नंतर मी यहोशुआस म्हणालो: “याहवेह तुझ्या परमेश्वराने सीहोन व ओग या दोन राजांचे काय केले हे तू आपल्या डोळ्याने पाहिले आहेस. तुम्ही जिथे जात आहात तेथील सर्व राज्यांचेही याहवेह असेच करतील. ");
INSERT INTO marc_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","त्यांना तू भिऊ नको; कारण याहवेह तुझे परमेश्वर स्वतः तुझ्यासाठी त्यांच्याशी लढतील.” ");
INSERT INTO marc_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","त्यावेळी मी याहवेहला विनवणी केली: ");
INSERT INTO marc_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“हे सार्वभौम याहवेह, तुमची महानता आणि तुमचा बलवान हात तुमच्या दासाला दाखविण्यास तुम्ही आरंभ केला आहे. स्वर्गात किंवा पृथ्वीवर असे कोणते दैवत आहे की, ज्याला तुमच्यासारखी थोर व महान कृत्ये करता येतील? ");
INSERT INTO marc_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","हे प्रभो, मला जाऊ द्या आणि यार्देनच्या पलीकडील उत्तम जमीन पाहू द्या—तो उत्तम डोंगराळ प्रदेश आणि लबानोन.” ");
INSERT INTO marc_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","पण तुमच्यामुळे याहवेह माझ्यावर रागावले आणि त्यांनी त्या वचनदत्त देशात मला जाऊ दिले नाही. ते मला म्हणाले, “पुरे कर. ही गोष्ट पुन्हा माझ्याजवळ काढू नकोस. ");
INSERT INTO marc_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","पिसगा पर्वताच्या शिखरावर जा आणि तिथून पूर्व, पश्चिम, उत्तर व दक्षिण दिशांना पाहा. तिथून दूरवर तुला तो देश दिसेल, कारण तुला यार्देन ओलांडून जाता येणार नाही. ");
INSERT INTO marc_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","पण तुझ्या जागी यहोशुआची नेमणूक कर. त्याला उत्तेजन दे, धैर्य दे, कारण तोच आपल्या लोकांना पलीकडे घेऊन जाईल आणि जो प्रदेश तुझ्या दृष्टीस पडेल तो त्यांना वतन करून देईल.” ");
INSERT INTO marc_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","म्हणून आम्ही बेथ-पौरातील खोर्‍यातच मुक्काम केला. ");
INSERT INTO marc_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","आता, अहो इस्राएली लोकहो, मी जे विधी व नियम तुम्हाला शिकवणार आहे ते ऐका. त्यांचे पालन करा म्हणजे जिवंत राहाल आणि याहवेह तुमच्या पूर्वजांचे परमेश्वर तुम्हाला देत आहेत, तो देश ताब्यात घ्या. ");
INSERT INTO marc_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","याहवेह तुमच्या परमेश्वराच्या आज्ञा मी तुम्हाला देत आहे त्यांचे तुम्ही फक्त पालन करा, त्यात काही भर घालू नका आणि काही कमी करू नका. ");
INSERT INTO marc_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","बआल—पौर येथे याहवेहने काय केले हे तुम्ही आपल्या डोळ्याने पाहिले आहे. याहवेह तुमच्या परमेश्वराने बआल-पौराच्या मागे चालणार्‍या सर्वांचा नाश केला, ");
INSERT INTO marc_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","पण याहवेह तुमच्या परमेश्वराशी एकनिष्ठ राहिलेले तुम्ही सर्वजण आजही जिवंत आहात. ");
INSERT INTO marc_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","पाहा, मी तुम्हाला याहवेह माझ्या परमेश्वराच्या आज्ञेप्रमाणे दिलेले विधी व नियम यासाठी शिकविले की जो देश तुम्ही ताब्यात घेणार आहात, त्या देशात तुमचा प्रवेश होईल, त्यावेळी ते तुम्ही पाळावे. ");
INSERT INTO marc_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","तुम्ही जर ते पाळले तर तुम्ही सुज्ञ व समंजस आहात अशी तुमची किर्ती होईल. जेव्हा सभोवतालची राष्ट्रे या नियमांविषयी ऐकतील तेव्हा ती म्हणतील, “इस्राएली राष्ट्रातील लोक निश्चितच बुद्धिमान व समंजस आहेत.” ");
INSERT INTO marc_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","याहवेह आपले परमेश्वर जसे आपण त्यांना प्रार्थना करतो तेव्हा ते आपल्या समीप असतात त्याप्रमाणे दुसरे कोणते महान राष्ट्र आहे ज्याचे देव त्यांच्या समीप असतात? ");
INSERT INTO marc_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","आणि एवढे महान राष्ट्र कोणते आहे, ज्याचे विधी आणि नियम या नियमशास्त्रासारखे न्याय्य आहेत, जे मी आज तुमच्यासमोर मांडणार आहे? ");
INSERT INTO marc_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","तुम्ही स्वतःबद्दल जागरूक असणे आणि स्वतःची काळजी घेणे खूप आवश्यक आहे, जेणेकरून तुम्ही स्वतःच्या डोळ्यांनी पाहिलेल्या गोष्टी विसरून जाऊ नये आणि आयुष्यभर त्या तुमच्या स्मरणातून निघून जाऊ नये. तुम्ही ते तुमच्या पुत्रांना आणि त्यांच्यानंतर त्यांच्या पुत्रांना शिकवा. ");
INSERT INTO marc_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ज्या दिवशी तुम्ही होरेब पर्वताजवळ याहवेह तुमच्या परमेश्वरासमोर उभे होता, त्या दिवसाविषयी त्यांना सांगा. त्या दिवशी याहवेहनी मला म्हणाले होते, “माझ्यासमोर सर्व लोकांना माझे शब्द ऐकण्यासाठी एकत्र कर, म्हणजे ते पृथ्वीवर जिवंत असेपर्यंत माझा आदर करतील आणि आपल्या मुलाबाळांना माझे शब्द शिकवतील.” ");
INSERT INTO marc_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","मग तुम्ही जवळ येऊन त्या पर्वताच्या पायथ्याशी जाऊन उभे राहिलात आणि पर्वत अग्नीने पेटला होता, त्याची ज्वाला आकाशापर्यंत पोहोचली होती, सर्वत्र अंधार, ढग आणि घनदाट अंधकार पसरला होता. ");
INSERT INTO marc_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","मग याहवेह तुमच्याशी अग्नीतून बोलले, तुम्ही त्यांचे शब्द ऐकले, परंतु त्यांची आकृती तुम्हाला दिसली नाही; फक्त वाणी ऐकली. ");
INSERT INTO marc_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","त्यांनी आपला करार तुम्हाला घोषित केला, दहा आज्ञा, ज्या पालन करण्याची त्यांनी आज्ञा दिली आणि त्यांनी त्या दोन दगडी पाट्यांवर लिहिल्या. ");
INSERT INTO marc_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","आणि त्यावेळी याहवेहने मला आज्ञा केली की तुम्ही यार्देन ओलांडून जो देश ताब्यात घेणार आहात तिथे तुम्हाला जे विधी व नियम पाळायचे आहेत ते शिकवावे. ");
INSERT INTO marc_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","याकरिता सावधगिरी बाळगा, कारण याहवेह तुमच्याशी होरेब पर्वतावर अग्नीमधून बोलले, त्यावेळी त्यांची काहीही आकृती तुमच्या दृष्टीस पडली नाही; ");
INSERT INTO marc_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","म्हणून कोणत्याही पुरुष अथवा स्त्रीच्या आकाराची कोरीव मूर्ती करून तुम्ही स्वतःला भ्रष्ट करू नये, ");
INSERT INTO marc_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","किंवा पृथ्वीवरील एखाद्या पशूची किंवा आकाशात उडणार्‍या कोणत्याही पक्ष्याची, ");
INSERT INTO marc_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","अथवा जमिनीवर रांगणार्‍या कोणत्याही प्राण्याची किंवा पृथ्वीच्या खाली जलामध्ये असणार्‍या कोणत्याही मत्स्याची तुम्ही प्रतिमा करू नये. ");
INSERT INTO marc_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","जेव्हा तुम्ही वर आकाशाकडे बघाल आणि तुम्हाला सूर्य, चंद्र व तारे—आकाशातील सर्व नक्षत्र—दिसतील, तेव्हा त्यांची उपासना करण्याच्या आणि त्यांना दंडवत घालण्याच्या मोहात पडू नका. याहवेह तुमच्या परमेश्वराने आकाशाखाली असलेल्या पृथ्वीतलावरील इतर राष्ट्रांना ते वाटून दिले आहेत. ");
INSERT INTO marc_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","परंतु याहवेहने तुम्हाला इजिप्तच्या तप्त लोखंडी भट्टीतून यासाठी सोडवून आणले की, तुम्ही त्यांचे खास निवडलेले लोक, त्यांचे वारसदार व्हावे, जसे तुम्ही आज आहात. ");
INSERT INTO marc_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","पण तुमच्यामुळेच याहवेह माझ्यावर रागावले होते. त्यांनी मला शपथपूर्वक सांगितले आणि याहवेह तुमच्या परमेश्वरांनी वतनादाखल दिलेल्या त्या उत्तम देशात यार्देन ओलांडून तुला जाता येणार नाही. ");
INSERT INTO marc_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","तुला याच देशात मरावे लागणार; मी यार्देन पार करू शकणार नाही; परंतु तुम्ही मात्र पार करून तो उत्तम प्रदेश वतन म्हणून ताब्यात घ्याल. ");
INSERT INTO marc_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","तेव्हा सावधगिरी बाळगा, नाहीतर याहवेह तुमच्या परमेश्वराने मनाई केलेल्या वस्तूंची तुम्ही स्वतःसाठी कोरीव प्रतिमा कराल आणि याहवेह तुमच्या परमेश्वराच्या कराराचे तुम्हाला विस्मरण होईल. ");
INSERT INTO marc_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","कारण याहवेह तुमचे परमेश्वर भस्म करणारे अग्नी व ईर्ष्यावान असे परमेश्वर आहेत. ");
INSERT INTO marc_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","तुम्हाला जेव्हा मुले आणि नातवंडे होतील आणि त्या देशात तुम्ही बराच काळ वास्तव्य केल्यावर तुम्ही मूर्तिपूजा करून स्वतःला भ्रष्ट केले, तर याहवेह तुमचे परमेश्वर तुमच्यावर अतिशय कोपायमान होतील, ");
INSERT INTO marc_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","तर मी सांगतो की तुमच्याविरुद्ध स्वर्ग व पृथ्वी ही दोन्हीही साक्षी असतील, मग तुम्ही यार्देन पार करून जो देश ताब्यात घ्याल, त्या देशात तुमचा लवकरच नाश होईल. तुमचे तेथील वास्तव्य अगदी अल्पकाळ असेल व तुमचा संपूर्णपणे नायनाट होईल. ");
INSERT INTO marc_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","याहवेह, तुमची इतर राष्ट्रांमध्ये पांगापांग करतील आणि ज्या राष्ट्रांमध्ये याहवेह तुम्हाला घेऊन जातील त्यांच्यापैकी फक्त काही लोकच मागे उरतील. ");
INSERT INTO marc_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","तिथे तुम्ही लाकूड आणि दगडाच्या मानवनिर्मित दैवतांची सेवा कराल, जे पाहू शकत नाहीत, ऐकू शकत नाहीत, खाऊ शकत नाहीत किंवा वासही घेऊ शकत नाहीत. ");
INSERT INTO marc_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","परंतु तिथे असताना जर तुम्ही याहवेह तुमच्या परमेश्वराचा शोध घ्याल आणि संपूर्ण मनाने व जिवाने त्यांना शोधाल, तर ते तुम्हाला सापडतील. ");
INSERT INTO marc_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","तुमच्यावर यातना व अनेक दुःखाचे प्रसंग येतील, तेव्हा तुम्ही याहवेह तुमच्या परमेश्वराकडे परत याल आणि त्यांचे आज्ञापालन कराल. ");
INSERT INTO marc_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","कारण याहवेह तुमचे परमेश्वर हे कनवाळू आहेत. ते तुम्हाला सोडणार वा टाकणार नाहीत किंवा त्यांनी तुमच्या पूर्वजांशी केलेला शपथपूर्वक करार ते विसरणार नाहीत. ");
INSERT INTO marc_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","परमेश्वराने पृथ्वीवर मानवाला निर्माण केले त्या दिवसापासून आतापर्यंत तुमच्या आधी होऊन गेलेल्या दिवसांना विचारा आणि आकाशाच्या एका टोकापासून दुसर्‍या टोकापर्यंत विचारा की, अशा प्रकारची महान गोष्ट पूर्वी कधी घडली होती का किंवा अशी गोष्ट कुठे घडल्याचे कोणी कधी ऐकले आहे का? ");
INSERT INTO marc_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","अग्नीमधून बोलताना परमेश्वराची वाणी कोणी कधी ऐकली, ज्याप्रकारे तुम्ही ऐकली आणि जिवंत राहिले आहेत काय? ");
INSERT INTO marc_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","कोणत्या दैवताने एका राष्ट्रातून दुसर्‍या राष्ट्राला गुलामगिरीतून बाहेर काढण्याकरिता भयानक पीडा पाठविल्या, चिन्हे, चमत्कार केले, युद्ध व अद्भुत कृत्ये केली, जसे इजिप्त देशातून तुम्हाला बाहेर काढण्यासाठी याहवेह तुमच्या परमेश्वराने पराक्रमी बाहू आणि उगारलेल्या हाताने चमत्कार केले, असे एक तरी उदाहरण इतरत्र तुम्हाला सापडेल का? ");
INSERT INTO marc_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","त्यांनी या गोष्टी अशासाठी केल्या की, याहवेहच परमेश्वर आहेत हे तुम्हाला कळून यावे; त्यांच्यासारखा अन्य कोणीही नाही हे देखील समजावे. ");
INSERT INTO marc_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","तुम्हाला बोध करण्यासाठी स्वर्गातून आज्ञा देण्यास त्यांनी तुम्हाला आपली वाणी ऐकविली, तसेच त्यांचा महान अग्निस्तंभही तुम्हाला या पृथ्वीतलावर दाखविला; आणि तुम्ही त्या अग्नीमधून येणारे त्यांचे शब्दही ऐकले. ");
INSERT INTO marc_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","तुमच्या पूर्वजांवर त्यांची प्रीती होती आणि त्यांनी त्यांच्या वंशजांना आशीर्वाद देण्यासाठी निवडले आणि म्हणूनच त्यांनी तुम्हाला आपल्या उपस्थितीने आणि महान सामर्थ्याने इजिप्त देशामधून बाहेर आणले, ");
INSERT INTO marc_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","त्यांनी तुमच्यापेक्षाही महान आणि सामर्थ्यवान राष्ट्रांना घालवून दिले व त्यांची भूमी तुम्हाला वतनादाखल दिली, ती आजही तशीच आहे. ");
INSERT INTO marc_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","वर स्वर्गात आणि खाली पृथ्वीवर याहवेहच परमेश्वर आहेत, हे आजच स्वीकारा आणि तुमच्या अंतःकरणात ठेवा. त्यांच्याशिवाय दुसरा कोणी नाही. ");
INSERT INTO marc_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","आज जे विधी व आज्ञा मी तुम्हाला सांगणार आहे, यांचे तुम्ही पालन केले, तर तुमचे व तुमच्या वंशजांचे कल्याण होईल आणि याहवेह तुमचे परमेश्वर तुम्हाला देत असलेल्या या देशामध्ये तुम्ही चिरकाल वस्ती कराल. ");
INSERT INTO marc_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","नंतर मोशेने यार्देनेच्या पूर्वेस तीन शहरे नेमली; ");
INSERT INTO marc_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ती यासाठी की, जर कोणी चुकून एखाद्या व्यक्तीची हत्या केली, त्याने पूर्व कल्पना नसताना एखाद्या शेजार्‍याला अनावधानाने मारले तर त्याला सुरक्षिततेसाठी त्या शहरात पळून जाता येईल. तो यापैकी एका शहरात पळून जाऊन आपला जीव वाचवू शकतो. ");
INSERT INTO marc_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ती शहरे ही होती: रऊबेनाच्या वंशजासाठी रानातील पठारावरील बेसेर, गाद वंशजांसाठी गिलआदातील रामोथ आणि मनश्शेहच्या वंशजांसाठी बाशानातले गोलान. ");
INSERT INTO marc_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","मोशेने इस्राएली लोकांना दिलेले नियमशास्त्र हे आहे. ");
INSERT INTO marc_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ज्यावेळी इस्राएली लोकांनी इजिप्त देश सोडला, त्यांना मोशेने या अटी, विधी व नियम दिले ");
INSERT INTO marc_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","आणि तेव्हा ते यार्देनेच्या पूर्वेकडे बेथ-पौर शहराजवळ तळ देऊन राहिलेले होते, हीच भूमी पूर्वी अमोर्‍यांनी आपला राजा सीहोनच्या अधिपत्याखाली व्यापली होती आणि त्याची राजधानी हेशबोन होती; मोशे व इस्राएली लोकांनी इजिप्त देशातून बाहेर आल्यानंतर सीहोन राजा आणि त्याच्या लोकांचा पराभव केला. ");
INSERT INTO marc_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","इस्राएली लोकांनी त्यांची भूमी आणि बाशानचा राजा ओगचीही भूमी जिंकून ताब्यात घेतली. यार्देनेच्या पूर्वेस असणारे हेच दोघे अमोरी राजे होते. ");
INSERT INTO marc_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","आर्णोन नदीच्या खोर्‍याच्या टोकाशी वसलेल्या अरोएर शहरापासून सिर्योन पर्वतापर्यंत, ज्याला हर्मोन पर्वत असेही म्हणतात, ");
INSERT INTO marc_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","आणि तसेच यार्देनच्या पूर्वेस असलेल्या अराबाच्या संपूर्ण प्रदेशापासून पिसगा पर्वताच्या उताराखाली असलेल्या खार्‍या समुद्रापर्यंतचा सर्व भूभाग इस्राएली लोकांनी जिंकून घेतला. ");
INSERT INTO marc_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","मोशेने सर्व इस्राएली लोकांना बोलाविले आणि म्हटले: इस्राएली लोकांनो, ज्या विधी व नियमांची आज मी घोषणा करीत आहे व तुम्हाला ऐकवीत आहे, ते शिका आणि निश्चितपणे त्याचे पालन करा. ");
INSERT INTO marc_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","याहवेह आपल्या परमेश्वराने होरेब पर्वतावर तुमच्याशी एक करार केला होता. ");
INSERT INTO marc_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","याहवेहने हा करार आपल्या पूर्वजांशी नव्हे तर आज येथे जिवंत असलेल्या आपल्या सर्वांशी केला आहे. ");
INSERT INTO marc_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","याहवेह पर्वतावर अग्नीमधून तुमच्याशी समोरासमोर बोलले. ");
INSERT INTO marc_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(त्यावेळी मी तुमच्या आणि याहवेहमध्ये उभा राहिलो आणि तुम्हाला याहवेहच्या वचनाची घोषणा केली, कारण तुम्हाला अग्नीची भीती वाटत असल्यामुळे तुम्ही पर्वतावर चढून त्यांच्यापर्यंत गेला नाही.) आणि ते म्हणाले: ");
INSERT INTO marc_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“ज्याने तुम्हाला इजिप्त देशातून व दास्यातून बाहेर आणले तो मी याहवेह तुमचा परमेश्वर आहे. ");
INSERT INTO marc_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“माझ्यासमोर तुम्हाला इतर कोणतेही देव नसावेत. ");
INSERT INTO marc_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","तुम्ही स्वतःसाठी वर आकाशातील, पृथ्वीवरील व पृथ्वीच्या खाली जलातील कशाचीही प्रतिमा करू नका. ");
INSERT INTO marc_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","तुम्ही त्यांना नमन करू नये किंवा त्यांची उपासना करू नये; कारण मी याहवेह तुमचा परमेश्वर ईर्ष्यावान परमेश्वर आहे. जे माझा द्वेष करतात त्यांच्या लेकरांना तिसर्‍या व चौथ्या पिढीपर्यंत त्यांच्या आईवडिलांच्या पापांचे शासन करतो, ");
INSERT INTO marc_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","परंतु जे माझ्यावर प्रीती करतात आणि माझ्या आज्ञा पाळतात अशांच्या हजारो पिढ्यांपर्यंत प्रीती करतो. ");
INSERT INTO marc_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","याहवेह तुमच्या परमेश्वराचे नाव तुम्ही व्यर्थ घेऊ नका, कारण जे त्यांचे नाव व्यर्थ घेतात, त्यांना याहवेह शिक्षा दिल्यावाचून राहणार नाहीत. ");
INSERT INTO marc_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","याहवेह तुमच्या परमेश्वराच्या आज्ञेनुसार शब्बाथ दिवस पवित्रपणे पाळावा. ");
INSERT INTO marc_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","सहा दिवस तुम्ही परिश्रम करावेत आणि आपली सर्व कामे करावी, ");
INSERT INTO marc_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","परंतु सातवा दिवस याहवेह तुमच्या परमेश्वराचा शब्बाथ आहे. त्या दिवशी तुम्ही कोणतेही काम करू नये. तुम्ही किंवा तुमचा पुत्र किंवा कन्या, तुमचा दास किंवा दासी, तुमचे बैल, गाढव, तुमचे पशू किंवा तुमच्या नगरात राहणारा परदेशी, तुमचा दास आणि दासी यांनी देखील तुमच्यासह त्या दिवशी विश्रांती घ्यावी. ");
INSERT INTO marc_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","तुम्ही इजिप्त देशात गुलाम होता याचे स्मरण करा. याहवेह तुमच्या परमेश्वराच्या सामर्थ्यवान व विस्तारित हातांनी तुम्हाला तिथून बाहेर काढले. यास्तव याहवेह तुमच्या परमेश्वराने शब्बाथ दिवस पाळण्याची आज्ञा केली आहे. ");
INSERT INTO marc_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","याहवेह तुमच्या परमेश्वराने आज्ञा दिल्याप्रमाणे आपल्या वडिलांचा व आपल्या आईचा सन्मान करा, म्हणजे जो देश याहवेह तुमचे परमेश्वर तुम्हाला देत आहे, त्यात तुम्ही दीर्घकाळ राहाल व तुमचे कल्याण होईल. ");
INSERT INTO marc_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","तुम्ही खून करू नका. ");
INSERT INTO marc_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","तुम्ही व्यभिचार करू नका. ");
INSERT INTO marc_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","तुम्ही चोरी करू नका. ");
INSERT INTO marc_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","तुमच्या शेजार्‍याविरुद्ध खोटी साक्ष देऊ नका. ");
INSERT INTO marc_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","तुमच्या शेजार्‍याच्या पत्नीची अभिलाषा धरू नका. त्याच्या घराचा किंवा भूमीचा, त्याच्या दासाचा किंवा दासीचा, त्याच्या बैलाचा किंवा गाढवाचा किंवा शेजार्‍याच्या मालकीच्या कशाचाही लोभ करू नका.” ");
INSERT INTO marc_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","याहवेहने या आज्ञा तुमच्यातील प्रत्येकाला अग्नी, मेघ व निबिड अंधकार यांनी वेष्टिलेल्या पर्वतावरून उंच आवाजात उच्चारून दिल्या; व त्यात अधिक काहीही जोडले नाही. त्यांनी त्या दोन दगडी पाट्यांवर लिहून माझ्याजवळ दिल्या. ");
INSERT INTO marc_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","पण ज्यावेळी तुम्ही अंधारातून येणारा आवाज ऐकला आणि डोंगर माथ्यावरील त्या भयानक ज्वाला पाहिल्या, तेव्हा तुमचे सर्व गोत्रप्रमुख व वडील माझ्याकडे आले. ");
INSERT INTO marc_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","आणि मला म्हणाले, “याहवेह आमच्या परमेश्वराने आज आम्हाला त्यांचे गौरव व थोरवी दाखविली आहे आणि अग्नीमधून येणारा त्यांचा आवाजसुद्धा आम्ही ऐकला. आम्ही आज पाहिले आहे की, परमेश्वर मानवाशी बोलले तरी मानव जिवंत राहणे शक्य आहे. ");
INSERT INTO marc_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","परंतु आम्ही का मरावे? त्या भयानक ज्वाला आम्हाला भस्म करून टाकतील आणि याहवेह आमच्या परमेश्वराची वाणी आम्ही ऐकत राहू, तर खात्रीने मरून जाऊ. ");
INSERT INTO marc_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","कारण जिवंत परमेश्वर अग्नीतून बोलत असताना त्यांची वाणी ऐकून जिवंत राहिला आहे, असा सर्व नश्वर मानवात आमच्याशिवाय कोण आहे? ");
INSERT INTO marc_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","तेव्हा तुम्ही याहवेह आमच्या परमेश्वराजवळ जा आणि ते जे सांगतील ते सर्व ऐका. मग याहवेह आमच्या परमेश्वराने तुम्हाला जे काही सांगितले आहे ते आम्हाला सांगा. आम्ही ऐकू आणि त्याचे पालन करू.” ");
INSERT INTO marc_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","तुम्हाला माझ्याशी बोलताना याहवेहनी ऐकले आणि याहवेह मला म्हणाले, “हे लोक जे काही तुझ्याशी बोलले ते मी ऐकले आहे. त्यांनी जे सर्वकाही बोलले ते चांगले आहे. ");
INSERT INTO marc_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","त्यांचे अंतःकरण मजविषयी नेहमीच असे राहिले आणि माझ्या आज्ञा पाळण्याचे भय त्यांच्याठायी नेहमीच राहिले तर किती बरे होईल! असे झाल्यास त्यांचे व त्यांच्या मुलाबाळांचे सदासर्वकाळ कल्याण होईल! ");
INSERT INTO marc_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“जा आणि त्यांना त्यांच्या तंबूमध्ये परत जाण्यास सांग. ");
INSERT INTO marc_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","पण तू माझ्याबरोबर इथेच थांब, म्हणजे मी तुला माझ्या सर्व आज्ञा, विधी व नियम देईन आणि ते त्यांना शिकव म्हणजे जो देश मी त्यांना वतन म्हणून देणार आहे तिथे त्यांचे पालन करावे.” ");
INSERT INTO marc_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","याहवेह तुमच्या परमेश्वराच्या आज्ञा पाळण्याची तुम्ही खबरदारी घ्या; उजवीकडे किंवा डावीकडे वळू नका. ");
INSERT INTO marc_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","याहवेह तुमच्या परमेश्वराने ज्या मार्गावर चालण्यास आज्ञा केली आहे, त्यावर तुम्ही चला, म्हणजे तुम्ही जिवंत राहाल आणि ज्या देशाचा तुम्ही ताबा घेणार आहात, त्या देशात तुम्ही दीर्घकाल समृद्धीचे जीवन जगू शकाल. ");
INSERT INTO marc_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","यार्देन ओलांडून त्या वचनदत्त देश ताब्यात घ्यायचा आहे, त्या देशात तुम्हाला पाळावयास शिकविण्यासाठी याहवेह तुमच्या परमेश्वराने मला सांगितलेल्या आज्ञा, विधी व नियम हे आहेत, ");
INSERT INTO marc_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","यासाठी की तुम्ही, तुमचे पुत्र, पौत्रे यांनी याहवेह तुमच्या परमेश्वराचे भय बाळगावे. मी तुम्हाला दिलेले सर्व नियम व आज्ञा तुम्ही पाळत राहाल तर तुम्ही दीर्घायुष्याचा आनंद घ्याल. ");
INSERT INTO marc_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","म्हणून इस्राएली लोकहो ऐका आणि काळजीपूर्वक आज्ञा पाळा म्हणजे तुमचे भले होईल आणि याहवेह तुमच्या पूर्वजांच्या परमेश्वरांनी तुम्हाला दिलेल्या वचनाप्रमाणे दूध व मध वाहणार्‍या देशात तुम्ही बहुगुणित व्हाल. ");
INSERT INTO marc_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","हे इस्राएला ऐक: याहवेह आपले परमेश्वर एकच याहवेह आहेत. ");
INSERT INTO marc_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","याहवेह तुमच्या परमेश्वरावर तुमच्या पूर्ण हृदयाने, तुमच्या पूर्ण जिवाने आणि तुमच्या पूर्णशक्तीने प्रीती करा. ");
INSERT INTO marc_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","या ज्या आज्ञा मी आज तुम्हाला देणार आहे, त्या तुमच्या अंतःकरणात सदैव असाव्या. ");
INSERT INTO marc_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","त्या तुमच्या मुलांवर बिंबवा. घरी बसले असताना, वाटेवर चालत असताना, झोपण्याच्या वेळी व झोपेतून उठल्यानंतर त्याबद्दल बोलत राहा. ");
INSERT INTO marc_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","त्या तुम्ही आपल्या हातावर चिन्ह म्हणून बांधून ठेवा आणि आपल्या कपाळपट्टीवर बांधा. ");
INSERT INTO marc_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","त्या तुमच्या घरातील दाराच्या चौकटीवर व तुमच्या फाटकांवर लिहा. ");
INSERT INTO marc_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","जो देश देण्याचे वचन याहवेह तुमच्या परमेश्वराने तुमचे पूर्वज अब्राहाम, इसहाक व याकोबाला दिले होते, त्या देशात जेव्हा ते तुम्हाला घेऊन जातील व जी तुम्ही स्वतः वसविलेली नाहीत—अशी मोठी व सुंदर शहरे तुम्हाला देतील, ");
INSERT INTO marc_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","तुम्ही स्वतः भरले नाहीत अशा सर्व चांगल्या वस्तूंनी भरलेली घरे, तुम्ही स्वतः खोदल्या नाहीत अशा विहिरी आणि तुम्ही स्वतः लावले नाहीत असे द्राक्षमळे व जैतुनाचे वृक्ष—तुम्ही ते सर्व खाल आणि तृप्त व्हाल, ");
INSERT INTO marc_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ज्या याहवेहने तुम्हाला इजिप्त देशातून, दास्यगृहातून बाहेर आणले त्यांना तुम्ही विसरू नये याची खबरदारी घ्या. ");
INSERT INTO marc_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","तुम्ही याहवेह आपल्या परमेश्वराचे भय बाळगावे, फक्त त्यांचीच सेवा करावी आणि त्यांच्याच नावाने शपथ वाहवी. ");
INSERT INTO marc_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","इतर दैवतांच्या, तुमच्या सभोवती असलेल्या राष्ट्रांच्या दैवतांच्या मागे लागू नका; ");
INSERT INTO marc_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","कारण याहवेह तुमचे परमेश्वर, जे तुम्हामध्ये आहेत, ते ईर्ष्यावान परमेश्वर आहेत, यामुळे त्यांचा राग भडकेल व ते तुम्हाला या पृथ्वीवरून नष्ट करून टाकतील. ");
INSERT INTO marc_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","मस्सा येथे पाहिली तशी तुम्ही याहवेह तुमच्या परमेश्वराची परीक्षा पाहू नका. ");
INSERT INTO marc_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","याहवेह तुमच्या परमेश्वराच्या आज्ञा तुम्ही काळजीपूर्वक पाळाव्या आणि त्यांची बोधवचने व नियमांचेही जपून पालन करावे. ");
INSERT INTO marc_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","याहवेहच्या दृष्टीने जे योग्य व चांगले आहे तेच करा, तर तुमचे सर्व बाबतीत कल्याण होईल आणि याहवेहने तुमच्या पूर्वजांना शपथपूर्वक देऊ केलेल्या देशात तुम्ही जाल व तो देश तुम्ही ताब्यात घ्याल. ");
INSERT INTO marc_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","याहवेहने सांगितल्याप्रमाणे तुमच्या सर्व शत्रूंना तुमच्यापुढून घालवून द्या. ");
INSERT INTO marc_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","भविष्यात जेव्हा तुमचा पुत्र तुम्हाला विचारेल, “याहवेह आपल्या परमेश्वराने या आज्ञा, ही बोधवचने, विधी व नियम तुम्हाला दिले आहेत, त्यांचा अर्थ काय?” ");
INSERT INTO marc_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","तेव्हा तुम्ही त्यांना सांगा: “आम्ही इजिप्त देशात फारोहचे गुलाम होतो, परंतु याहवेहने आपल्या पराक्रमी हाताने आम्हाला इजिप्तमधून बाहेर आणले. ");
INSERT INTO marc_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","आमच्या नजरेसमोर याहवेहने इजिप्त देश, फारोह राजा आणि त्याच्या संपूर्ण कुटुंबाविरुद्ध—महान व भयावह—चिन्हे दाखविली व चमत्कार केले. ");
INSERT INTO marc_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","त्यांनी आम्हाला इजिप्तमधून यासाठी बाहेर आणले की, आमच्या पूर्वजांना जो देश देण्याचे त्यांनी शपथपूर्वक वचन दिले होते, त्या देशात आम्हाला आणावे. ");
INSERT INTO marc_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","याहवेहने आम्हाला सर्व नियम पाळण्याची आज्ञा दिली आणि याहवेह आपल्या परमेश्वराचे भय बाळगावे, जेणेकरून आपले निरंतर कल्याण व्हावे आणि स्वतःस जिवंत राखावे, जसे आजवर आहोत. ");
INSERT INTO marc_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","आणि जर आपण याहवेह आपल्या परमेश्वरासमोर दिलेल्या आज्ञेप्रमाणे या सर्व नियमांचे काळजीपूर्वक पालन केले, तर ते आपले नीतिमत्व असेल.” ");
INSERT INTO marc_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","जेव्हा याहवेह तुमचे परमेश्वर तुम्हाला त्या देशात घेऊन जातील, ज्याचा ताबा मिळविण्यासाठी तुम्ही जात आहात आणि तुमच्यापुढून—हिथी, गिर्गाशी, अमोरी, कनानी, परिज्जी, हिव्वी आणि यबूसी या तुमच्यापेक्षा मोठ्या आणि बलाढ्य सात राष्ट्रांना हाकलून देतील— ");
INSERT INTO marc_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","आणि जेव्हा याहवेह तुमचे परमेश्वर त्यांना तुमच्या हाती देतील आणि तुम्ही त्यांचा पराभव कराल, तेव्हा तुम्ही त्यांचा समूळ नायनाट करा. त्यांच्याशी कुठलाही करार करू नका किंवा त्यांना दया दाखवू नका. ");
INSERT INTO marc_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","तुम्ही त्यांच्याशी आंतरविवाह करू नका, तुमच्या कन्या त्यांच्या पुत्रांसाठी देऊ नका किंवा त्यांच्या कन्या तुमच्या पुत्रांसाठी घेऊ नका, ");
INSERT INTO marc_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","कारण ते तुमच्या मुलांना माझे अनुसरण करण्यापासून परावृत्त करून इतर दैवतांची उपासना करण्यासाठी प्रवृत्त करतील आणि याहवेहचा क्रोध तुम्हावर भडकेल आणि ते लगेच तुमचा नाश करतील. ");
INSERT INTO marc_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","तुम्ही त्यांच्या बाबतीत हे करा: त्यांच्या वेद्या मोडून टाका, त्यांच्या पवित्र पाषाणांचा चुरा करा, त्यांचे अशेराचे स्तंभ तोडून टाका आणि त्यांच्या मूर्ती अग्नीत जाळून टाका. ");
INSERT INTO marc_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","कारण तुम्ही याहवेह तुमच्या परमेश्वराचे पवित्रजन आहात. संपूर्ण पृथ्वीवरील सर्व लोकातून याहवेह तुमच्या परमेश्वराने तुम्हाला अशासाठी निवडले आहे की, तुम्ही त्यांचा खूप मोलाचा ठेवा असावा. ");
INSERT INTO marc_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","तुम्ही संख्येने अधिक होता म्हणून याहवेहने तुमची निवड केली नाही व तुमच्यावर प्रीती केली नाही, कारण तुम्ही तर सर्व राष्ट्रांमध्ये संख्येने अतिशय अल्प होता. ");
INSERT INTO marc_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","पण याहवेहची तुमच्यावर प्रीती असल्यामुळे आणि त्यांनी तुमच्या पूर्वजांना दिलेली शपथ पाळावयाची होती, म्हणून त्यांनी तुम्हाला सामर्थ्यशाली हाताने बाहेर काढले आणि इजिप्तचा राजा फारोहच्या दास्यगृहातून तुम्हाला सोडविले. ");
INSERT INTO marc_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","म्हणून हे जाणून घ्या की, याहवेहच तुमचे परमेश्वर आहेत; ते विश्वासू परमेश्वर आहेत, जे त्यांच्यावर प्रीती करतात आणि त्यांच्या आज्ञा पाळतात, अशांच्या हजारो पिढ्यांपर्यंत ते आपल्या प्रीतीचा करार पाळतात. ");
INSERT INTO marc_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","परंतु जे त्यांचा द्वेष करतात, त्यांना ते नष्ट करण्यास संकोच करणार नाहीत; जे त्यांची घृणा करतात, त्यांची ते परतफेड करण्यास विलंब लावणार नाही. ");
INSERT INTO marc_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","यास्तव, मी आज तुम्हाला देत आहे त्या सर्व आज्ञा, विधी व नियम पाळण्याची तुम्ही खबरदारी घ्या. ");
INSERT INTO marc_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","तुम्ही या आज्ञा ऐकून त्या प्रामाणिकपणे पाळल्या, तर याहवेह तुमचे परमेश्वर तुमच्या पूर्वजांन