﻿USE sofia;
DROP TABLE IF EXISTS sofia.mar_vpl;
CREATE TABLE mar_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mar_vpl WRITE;
INSERT INTO mar_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","प्रारंभी देवाने आकाश व पृथ्वी ही निर्माण केली. ");
INSERT INTO mar_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्वी अंदाधुंद व रिकामी होती. जलाशयावर अंधकार होता, देवाचा आत्मा पाण्यावर पाखर घालत होता. ");
INSERT INTO mar_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","देव बोलला, “प्रकाश होवो” आणि प्रकाश झाला. ");
INSERT INTO mar_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","देवाने प्रकाश पाहिला की तो चांगला आहे. देवाने अंधकारापासून प्रकाश वेगळा केला. ");
INSERT INTO mar_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","देवाने प्रकाशाला “दिवस” व अंधकाराला “रात्र” असे नाव दिले. संध्याकाळ झाली व सकाळ झाली, हा पहिला दिवस. ");
INSERT INTO mar_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","देव बोलला, “जलांच्या मध्यभागी अंतराळ होवो व ते जलापासून जलांची विभागणी करो.” ");
INSERT INTO mar_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","देवाने अंतराळ केले आणि अंतराळावरच्या व अंतराळाखालच्या जलांची विभागणी केली व तसे झाले. ");
INSERT INTO mar_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","देवाने अंतराळास आकाश असे म्हटले. संध्याकाळ झाली व सकाळ झाली, हा दुसरा दिवस. ");
INSERT INTO mar_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","नंतर देव बोलला, “आकाशाखालील पाणी एकाजागी एकत्र जमा होवो व कोरडी जमीन दिसून येवो,” आणि तसे झाले. ");
INSERT INTO mar_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","देवाने कोरड्या जमिनीस भूमी आणि एकत्र झालेल्या पाण्याच्या संचयास समुद्र असे म्हटले. त्याने पाहिले की हे चांगले आहे. ");
INSERT INTO mar_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","देव बोलला, “हिरवळ, बीज देणाऱ्या वनस्पती, आणि आपआपल्या जातीप्रमाणे, ज्यात त्याचे बीज आहे अशी फळे देणारी फळझाडे, ही पृथ्वीवर येवोत.” आणि तसेच झाले. ");
INSERT INTO mar_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","पृथ्वीने हिरवळ, आपापल्या जातीचे बीज देणाऱ्या वनस्पती आणि आपापल्या जातीची फळे देणारी व त्या फळातच आपापल्या जातीचे बीज असणारी फळझाडे भूमीने उत्पन्न केली. देवाने पाहिले की हे चांगले आहे. ");
INSERT INTO mar_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","संध्याकाळ झाली व सकाळ झाली, हा तिसरा दिवस. ");
INSERT INTO mar_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","मग देव बोलला, “दिवस व रात्र ही वेगळी करण्यासाठी आकाशात ज्योति होवोत व त्या चिन्हे, ऋतू, दिवस, आणि वर्षे दाखविणाऱ्या होवोत. ");
INSERT INTO mar_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","पृथ्वीला प्रकाश देण्यासाठी आकाशात त्या दीपाप्रमाणे होवोत,” आणि तसे झाले. ");
INSERT INTO mar_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","दिवसावर सत्ता चालविण्यासाठी मोठी ज्योत आणि रात्रीवर सत्ता चालविण्यासाठी लहान ज्योत, अशा दोन मोठ्या ज्योती देवाने निर्माण केल्या. त्याने तारेही निर्माण केले. ");
INSERT INTO mar_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","पृथ्वीवर प्रकाश देण्यासाठी, दिवसावर व रात्रीवर सत्ता चालविण्यासाठी, प्रकाश व अंधकार वेगळे करण्यासाठी देवाने त्यांना अंतराळात ठेवले. देवाने पाहिले की हे चांगले आहे. ");
INSERT INTO mar_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","संध्याकाळ झाली व सकाळ झाली. हा चौथा दिवस. ");
INSERT INTO mar_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","देव बोलला, “जले जीवजंतूनी भरून जावोत, आणि पृथ्वीच्या वर आकाशाच्या अंतराळात पक्षी उडोत.” ");
INSERT INTO mar_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","समुद्रातील फार मोठे जलचर व अनेक प्रकारचे जलप्राणी त्यांच्या त्यांच्या जातींप्रमाणे देवाने उत्पन्न केले. तसेच पंख असलेल्या प्रत्येक पक्षाला त्याच्या जातीप्रमाणे देवाने उत्पन्न केले. देवाने पाहिले की हे चांगले आहे. ");
INSERT INTO mar_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","देवाने त्यांना आशीर्वाद देऊन म्हटले, “फलद्रूप व्हा आणि बहुगुणित व्हा, समुद्रातील पाणी व्यापून टाका. पृथ्वीवर पक्षी बहुगुणित होवोत.” ");
INSERT INTO mar_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","संध्याकाळ झाली व सकाळ झाली हा पाचवा दिवस. ");
INSERT INTO mar_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","देव बोलला, “आपापल्या जातीचे सजीव प्राणी, गुरेढोरे, सरपटणारे प्राणी व वनपशू पृथ्वी उपजवो.” आणि तसे झाले. ");
INSERT INTO mar_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","देवाने पृथ्वीवरील जनावरे, गुरेढोरे, वनपशू, आणि सरपटणारा प्रत्येक जीव त्याच्या त्याच्या जाती प्रमाणे निर्माण केला. देवाने पाहिले की हे चांगले आहे. ");
INSERT INTO mar_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","देव बोलला, “आपण आपल्या प्रतिरूपाचा आपल्या सारखा मनुष्य निर्माण करू. समुद्रातील मासे, आकाशातील पक्षी, सर्व वनपशू, मोठी जनावरे व जमिनीवर सरपटणारे सर्व लहान प्राणी यांच्यावर त्यांना सत्ता चालवू देऊ.” ");
INSERT INTO mar_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","देवाने आपल्या प्रतिरूपाचा मनुष्य निर्माण केला. त्याच्या स्वतःच्या प्रतिरूपाचा असा देवाने तो निर्माण केला. नर व नारी असे त्यांना निर्माण केले. ");
INSERT INTO mar_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","देवाने त्यांना आशीर्वाद दिला, आणि त्यांना म्हटले, “फलद्रूप व्हा, बहुगुणित व्हा आणि पृथ्वी व्यापून टाका. ती आपल्या सत्तेखाली आणा; समुद्रातील मासे, आकाशातील पक्षी आणि पृथ्वीवर फिरणारा प्रत्येक सजीव प्राणी यांवर सत्ता चालवा.” ");
INSERT INTO mar_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","देव म्हणाला, पाहा, सर्व पृथ्वीच्या पृष्ठभागावर असलेली बीज देणारी प्रत्येक वनस्पती आणि ज्यामध्ये बीज देणाऱ्या झाडाचे फळ आहे ते प्रत्येक झाड, ही मी तुम्हास दिली आहेत. ही तुम्हाकरिता अन्न असे होतील. ");
INSERT INTO mar_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","तसेच पृथ्वीवरील प्रत्येक पशू, आकाशातील प्रत्येक पक्षी आणि पृथ्वीच्या पाठीवर ज्यामध्ये जीव आहे त्या प्रत्येक सरपटणाऱ्या प्राण्याकरता अन्न म्हणून मी प्रत्येक हिरवी वनस्पती दिली आहे. आणि सर्व तसे झाले. ");
INSERT INTO mar_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","देवाने आपण जे केले होते ते सर्व पाहिले. पाहा, ते फार चांगले होते. संध्याकाळ झाली व नंतर सकाळ झाली, हा सहावा दिवस. ");
INSERT INTO mar_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","त्यानंतर पृथ्वी, आकाश आणि त्यातील सर्वकाही पूर्ण करून झाले, आणि सर्वकाही जिवंत जिवांनी भरून गेले. ");
INSERT INTO mar_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","देवाने सातव्या दिवशी आपण करीत असलेले काम समाप्त केले, आणि जे त्याने केले होते त्या त्याच्या कामापासून त्याने सातव्या दिवशी विसावा घेतला. ");
INSERT INTO mar_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","देवाने सातव्या दिवसास आशीर्वाद दिला आणि तो पवित्र केला, कारण देवाने त्याचे निर्मितीचे जे सर्व काम केले होते त्या आपल्या कामापासून त्या दिवशी त्याने विसावा घेतला. ");
INSERT INTO mar_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","परमेश्वर देवाने ज्या दिवशी ते निर्माण केले, तेव्हाचा आकाश व पृथ्वीसंबंधीच्या घटनाक्रमाविषयीचा वृत्तान्त हा आहे. ");
INSERT INTO mar_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","शेतातील कोणतेही झुडूप अजून पृथ्वीवर नव्हते, आणि शेतातील कोणतीही वनस्पती अजून उगवली नव्हती, कारण परमेश्वर देवाने अद्याप पृथ्वीवर पाऊस पाडला नव्हता आणि जमिनीची मशागत करण्यास कोणी मनुष्य नव्हता. ");
INSERT INTO mar_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","पण पृथ्वीवरुन धुके वर जात असे व त्याने सर्व जमिनीचा पृष्ठभाग पाण्याने भिजवला जात असे. ");
INSERT INTO mar_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","परमेश्वर देवाने जमिनीतील मातीचा मनुष्य घडवला व त्याच्या नाकपुड्यात जीवनाचा श्वास फुंकला आणि मनुष्य जिवंत प्राणी झाला. ");
INSERT INTO mar_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","परमेश्वर देवाने पूर्वेकडे एदेनात एक बाग लावली आणि त्या बागेत आपण घडविलेल्या मनुष्यास ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","परमेश्वर देवाने दिसण्यास सुंदर आणि खाण्यास चांगले फळ देणारे प्रत्येक झाड जमिनीतून उगवले. त्यामध्ये बागेच्या मध्यभागी असलेले जीवनाचे झाड, आणि बऱ्यावाईटाचे ज्ञान देणारे झाड यांचाही समावेश होता. ");
INSERT INTO mar_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","बागेला पाणी देण्यासाठी एदेनातून एक नदी निघाली. तेथून ती विभागली आणि तिच्या चार नद्या झाल्या. ");
INSERT INTO mar_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहिल्या नदीचे नाव पीशोन. ही संपूर्ण हवीला देशामधून वाहते, तेथे सोने सापडते. ");
INSERT INTO mar_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","त्या देशाचे सोने चांगल्या प्रतीचे असून तेथे मोती व गोमेद रत्नेसुद्धा सापडतात. ");
INSERT INTO mar_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दुसऱ्या नदीचे नाव गीहोन आहे. ही सगळ्या कूश देशामधून वाहते. ");
INSERT INTO mar_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","तिसऱ्या नदीचे नाव टायग्रीस. ही अश्शूर देशाच्या पूर्वेस वाहत जाते. चौथ्या नदीचे नाव फरात असे आहे. ");
INSERT INTO mar_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","परमेश्वर देवाने मनुष्यास एदेन बागेत तिची मशागत करण्यासाठी व बागेची काळजी घेण्यासाठी ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","परमेश्वर देवाने मनुष्यास आज्ञा दिली; तो म्हणाला, “बागेतील कोणत्याही झाडाचे फळ तू खुशाल खात जा; ");
INSERT INTO mar_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","परंतु बऱ्यावाईटाचे ज्ञान करून देणाऱ्या झाडाचे फळ तू खाऊ नये, कारण तू ज्या दिवशी त्या झाडाचे फळ खाशील त्याच दिवशी तू नक्कीच मरशील.” ");
INSERT INTO mar_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","नंतर परमेश्वर देव बोलला, “मनुष्याने एकटे असावे हे बरे नाही; मी त्याच्यासाठी सुसंगत मदतनीस निर्माण करीन.” ");
INSERT INTO mar_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","परमेश्वर देवाने मातीमधून जमिनीवरील सर्व जातीचे प्राणी आणि आकाशातील सर्व जातीचे पक्षी उत्पन्न केले आणि त्यांना मनुष्याकडे नेले आणि मनुष्याने त्या सर्वांना नावे दिली. ");
INSERT INTO mar_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","आदामाने सर्व पाळीव प्राणी, आकाशातील सर्व पक्षी आणि सर्व वनपशू यांना नावे दिली. आदामाने हे सर्व पशू-पक्षी पाहिले परंतु त्यांमध्ये त्यास सुसंगत असा मदतनीस सापडला नाही. ");
INSERT INTO mar_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","तेव्हा परमेश्वर देवाने मनुष्यास गाढ झोप लागू दिली, आणि तो झोपला असता परमेश्वराने मनुष्याच्या शरीरातून एक बरगडी काढली व ती जागा मांसाने बंद केली. ");
INSERT INTO mar_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","परमेश्वर देवाने मनुष्याची बरगडी काढून तिची स्त्री बनवली आणि तिला मनुष्याकडे आणले. ");
INSERT INTO mar_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","तेव्हा मनुष्य म्हणाला, “आता ही मात्र माझ्या हाडातले हाड व माझ्या मांसातले मांस आहे; मी तिला स्त्री म्हणजे नारी असे नाव देतो, कारण ती नरापासून बनवलेली आहे.” ");
INSERT INTO mar_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","म्हणून मनुष्य आपल्या आई वडीलांस सोडून आपल्या पत्नीला जडून राहील आणि ती दोघे एक देह होतील. ");
INSERT INTO mar_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","तेथे मनुष्य व त्याची पत्नी ही दोघेही नग्न होती, परंतु त्यांना कसलीच लाज वाटत नव्हती. ");
INSERT INTO mar_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","परमेश्वर देवाने निर्माण केलेल्या सर्व वनपशूंमध्ये सर्प हा अतिशय धूर्त होता. तो स्त्रीला म्हणाला, “‘बागेतल्या कोणत्याही झाडाचे फळ खाऊ नका’ असे देवाने तुम्हास खरोखरच सांगितले आहे काय?” ");
INSERT INTO mar_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","स्त्रीने सर्पाला उत्तर दिले, “बागेतल्या झाडांची फळे आम्ही खाऊ शकतो. ");
INSERT INTO mar_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","परंतु बागेच्या मधोमध जे झाड आहे, त्याच्या फळाविषयी देवाने म्हटले, ते खाऊ नका. त्या झाडाला स्पर्शही करू नका, नाहीतर तुम्ही मराल.” ");
INSERT INTO mar_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","सर्प त्या स्त्रीला म्हणाला, “तुम्ही खरोखर मरणार नाही. ");
INSERT INTO mar_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","कारण देवास हे माहीत आहे की, जर तुम्ही त्या झाडाचे फळ खाल त्याच दिवशी तुमचे डोळे उघडतील, व तुम्ही देवांसारखे बरेवाईट जाणणारे व्हाल.” ");
INSERT INTO mar_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","आणि स्त्रीने पाहिले की, त्या झाडाचे फळ खाण्यास चांगले व डोळ्यांना आनंद देणारे व शहाणे करण्यासाठी इष्ट आहे, तेव्हा तिने त्याचे काही फळ घेऊन खाल्ले. आणि तिने आपल्याबरोबर आपल्या पतीसही त्या फळातून थोडे दिले व त्याने ते खाल्ले. ");
INSERT INTO mar_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तेव्हा त्या दोघांचे डोळे उघडले व आपण नग्न आहोत असे त्यांना समजले; तेव्हा त्यांनी अंजिराची पाने एकत्र जोडून आपणाला झाकण्यासाठी वस्त्रे तयार केली. ");
INSERT INTO mar_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","दिवसाचा थंड वारा सुटला असता परमेश्वर देव बागेत आला. त्या वेळी त्यांनी त्याचा आवाज ऐकला. आणि परमेश्वर देवाच्या समक्षतेपासून दृष्टीआड व्हावे म्हणून मनुष्य व त्याची पत्नी बागेच्या झाडांमध्ये लपली. ");
INSERT INTO mar_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","तेव्हा परमेश्वर देवाने मनुष्यास हाक मारुन म्हटले, “तू कोठे आहेस?” ");
INSERT INTO mar_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","मनुष्य म्हणाला, “बागेत मी तुझा आवाज ऐकला व मला भीती वाटली, कारण मी नग्न होतो. म्हणून मी लपलो.” ");
INSERT INTO mar_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","परमेश्वर त्यास म्हणाला, “तू नग्न आहेस हे तुला कोणी सांगितले? ज्या झाडाचे फळ तू खाऊ नकोस अशी मी तुला आज्ञा दिली होती त्या झाडाचे फळ तू खाल्लेस काय?” ");
INSERT INTO mar_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","मनुष्य म्हणाला, “तू ही स्त्री माझ्या सोबतीस म्हणून दिलीस, तिने त्या झाडाचे फळ मला दिले आणि म्हणून मी ते खाल्ले.” ");
INSERT INTO mar_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","मग परमेश्वर देव त्या स्त्रीस म्हणाला, “तू हे काय केलेस?” ती स्त्री म्हणाली, “सर्पाने मला फसवले व म्हणून मी ते फळ खाल्ले.” ");
INSERT INTO mar_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","परमेश्वर देव सर्पास म्हणाला, “तू हे केल्यामुळे सर्व गुरेढोरांमध्ये व सर्व वन्यपशूंमध्ये तू शापित आहेस. तू पोटाने सरपटत चालशील आणि आयुष्यभर तू माती खाशील. ");
INSERT INTO mar_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","तुझ्यामध्ये व स्त्रीमध्ये आणि तुझ्या बीजामध्ये व स्त्रीच्या बीजामध्ये मी शत्रूत्व ठेवीन. तो तुझे डोके ठेचील आणि तू त्याची टाच फोडशील.” ");
INSERT INTO mar_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","परमेश्वर देव स्त्रीस म्हणाला, “मुलांना जन्म देते वेळी तुझ्या वेदना मी खूप वाढवीन तरी तुझी ओढ तुझ्या नवऱ्याकडे राहील; आणि तो तुझ्यावर अधिकार चालवील.” ");
INSERT INTO mar_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","नंतर परमेश्वर देव आदामाला म्हणाला, तू तुझ्या पत्नीची वाणी ऐकली आहे आणि ज्या झाडाचे फळ खाऊ नकोस अशी आज्ञा दिलेली होती, त्या झाडाचे फळ तू खाल्ले आहेस. म्हणून तुझ्यामुळे भूमीला शाप आला आहे. तू तिजपासून अन्न मिळवण्यासाठी आपल्या आयुष्याचे सर्व दिवस कष्ट करशील; ");
INSERT INTO mar_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","जमीन तुझ्यासाठी काटे व कुसळे उत्पन्न करील आणि शेतातील वनस्पती तुला खाव्या लागतील. ");
INSERT INTO mar_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","तू माघारी जमिनीमध्ये जाशील तोपर्यंत तू आपल्या निढळाच्या घामाने भाकर खाशील, तू मरणाच्या दिवसापर्यंत अतिशय काम करशील. कारण मातीमधून तू निर्माण झालेला आहेस; आणि मातीमध्ये तू परत जाशील. ");
INSERT INTO mar_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदामाने आपल्या पत्नीचे नाव हव्वा ठेवले, कारण सर्व जिवंत मनुष्यांची ती आई होती. ");
INSERT INTO mar_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","परमेश्वर देवाने आदाम व त्याच्या पत्नीसाठी चामड्यांची वस्त्रे केली; आणि ती त्यांना घातली. ");
INSERT INTO mar_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","परमेश्वर देव म्हणाला, “पाहा, मनुष्य आपल्यातल्या एका सारखा होऊन त्यास बरे व वाईट समजू लागले आहे. तर आता त्यास त्याच्या हातांनी जीवनाच्या झाडावरून ते फळ घेऊन खाऊ देऊ नये, आणि जर का तो ते फळ खाईल तर मग सदासर्वकाळ तो जिवंत राहील.” ");
INSERT INTO mar_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","तेव्हा परमेश्वर देवाने मनुष्यास ज्या जमिनीतून उत्पन्न केले होते तिची मशागत करण्यासाठी एदेन बागेतून बाहेर घालवून दिले. ");
INSERT INTO mar_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","देवाने मनुष्यास बागेतून घालवले, आणि जीवनाच्या झाडाचे रक्षण करण्यासाठी त्याने एदेन बागेच्या पूर्वेकडे करुब ठेवले, आणि सर्व दिशांनी गरगर फिरणारी ज्वालारूप एक तलवार ठेवली. ");
INSERT INTO mar_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","मनुष्याने त्याची पत्नी हव्वा हिच्यासोबत वैवाहिक संबंध केला. ती गर्भवती झाली आणि तिने काइनाला जन्म दिला. तेव्हा ती म्हणाली, परमेश्वराच्या साहाय्याने मला पुरुषसंतान लाभले आहे. ");
INSERT INTO mar_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","त्यानंतर तिने काइनाचा भाऊ हाबेल याला जन्म दिला. आणि हाबेल मेंढपाळ बनला, पण काइन शेतातील कामकरी झाला. ");
INSERT INTO mar_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","काही काळानंतर काइनाने परमेश्वरास शेतामधील फळांतले काही अर्पण आणले. ");
INSERT INTO mar_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","हाबेलानेही आपल्या कळपातील प्रथम जन्मलेल्यांतून, आणि पुष्टातून अर्पण आणले. परमेश्वराने हाबेल आणि त्याचे अर्पण स्विकारले. ");
INSERT INTO mar_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","परंतु त्याने काइन आणि त्याचे अर्पण स्विकारले नाही. यामुळे काइनाला फार राग आला, आणि त्याचे तोंड उतरले. ");
INSERT INTO mar_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","परमेश्वर काइनाला म्हणाला, “तू का रागावलास? तुझा चेहरा का उतरला आहे? ");
INSERT INTO mar_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","तू जर चांगल्या गोष्टी करशील तर, मग तुझाही स्विकार केला जाणार नाही का? परंतु तू जर योग्य ते करणार नाहीस, तर पाप दाराशी टपून बसले आहे आणि त्याची तुझ्यावर ताबा मिळवण्याची इच्छा आहे, परंतु तू त्यावर नियंत्रण केले पाहिजेस.” ");
INSERT INTO mar_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","काइन आपला भाऊ हाबेल याच्याशी बोलला, आणि असे झाले की ते शेतात असता, काइन आपला भाऊ हाबेल ह्याच्या विरूद्ध उठला व त्यास त्याने ठार मारले. ");
INSERT INTO mar_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","परमेश्वर काइनास म्हणाला, “तुझा भाऊ हाबेल कोठे आहे?” काइनाने उत्तर दिले, “मला माहीत नाही; मी माझ्या भावाचा राखणदार आहे काय?” ");
INSERT INTO mar_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","देव म्हणाला, “तू हे काय केलेस? तुझ्या भावाच्या रक्ताची वाणी जमिनीतून शिक्षेसाठी ओरड करत आहे. ");
INSERT INTO mar_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","तर आता तुझ्या हातून तुझ्या भावाचे पडलेले रक्त स्विकारण्यास ज्या जमिनीने आपले तोंड उघडले आहे, तिचा तुला शाप आहे. ");
INSERT INTO mar_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","जेव्हा तू जमिनीची मशागत करशील तेव्हा ती आपले सत्व यापुढे तुला देणार नाही. पृथ्वीवर तू भटकत राहशील व निर्वासित होशील.” ");
INSERT INTO mar_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","काइन परमेश्वरास म्हणाला, “माझी शिक्षा मी सहन करण्यापलीकडे, इतकी मोठी ती आहे. ");
INSERT INTO mar_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","खरोखर, तू मला या माझ्या भूमीवरून हाकलून लावले आहेस, आणि तुझ्या जवळ मला येता येणार नाही. पृथ्वीवर तू मला भटकणारा व निर्वासित केले आणि जर मी कोणाच्या हाती सापडेन तर तो मला ठार मारून टाकेल.” ");
INSERT INTO mar_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","परमेश्वर त्यास म्हणाला, “जर कोणी काइनाला ठार मारील तर त्याचा सातपट सूड घेण्यात येईल.” त्यानंतर, तो कोणाला सापडला तर त्यास कोणी जिवे मारू नये म्हणून, परमेश्वराने काइनावर एक खूण करून ठेवली. ");
INSERT INTO mar_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","काइन परमेश्वरासमोरून निघून गेला आणि एदेनाच्या पूर्वेस नोद प्रदेशात जाऊन राहिला. ");
INSERT INTO mar_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","काइनाने आपल्या पत्नीस जाणिले, ती गर्भवती होऊन तिने हनोखाला जन्म दिला; काइनाने एक नगर बांधले त्याने त्या नगराला आपल्या मुलाचेच हनोख हे नाव दिले. ");
INSERT INTO mar_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोखाला इराद झाला; इरादाला महूयाएल झाला महूयाएलास मथुशाएल झाला; आणि मथुशाएलास लामेख झाला. ");
INSERT INTO mar_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लामेखाने दोन स्त्रिया केल्या. पहिलीचे नाव आदा व दुसरीचे नाव सिल्ला. ");
INSERT INTO mar_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदाने याबालास जन्म दिला; तो तंबूत राहणाऱ्या व गुरेढोरे पाळणाऱ्या लोकांचा मूळपुरुष झाला. ");
INSERT INTO mar_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","आणि त्याच्या भावाचे नाव युबाल होते, तो तंतुवाद्य व वायुवाद्य वाजवणाऱ्या कलावंताचा मूळपुरुष झाला. ");
INSERT INTO mar_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","सिल्ला हिला तुबल-काइन झाला; तो तांब्याची व लोखंडाची कामे करणाऱ्या लोकांचा मूळपुरुष झाला. तुबल काइनास नामा नावाची बहीण होती. ");
INSERT INTO mar_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लामेख आपल्या बायकांना म्हणाला, आदा आणि सिल्ला माझी वाणी ऐका; लामेखाच्या बायकांनो, मी ज्या गोष्टी बोलतो त्याकडे कान लावा; एका मनुष्याने मला जखमी केले, मी त्यास ठार मारले, एका तरुणाने मला मारले म्हणून मी त्यास ठार केले. ");
INSERT INTO mar_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","जर काइनाबद्दल सातपट तर लामेखाबद्दल सत्याहत्तरपट सूड घेतला जाईल. ");
INSERT INTO mar_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदामाने पुन्हा पत्नीस जाणिले आणि तिला पुत्र झाला. त्यांनी त्याचे नाव शेथ असे ठेवले. हव्वा म्हणाली, “देवाने हाबेलाच्या ठिकाणी मला दुसरे संतान दिले आहे, कारण काइनाने त्यास जिवे मारले.” ");
INSERT INTO mar_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेथलाही मुलगा झाला, त्याचे नाव त्याने अनोश ठेवले; त्या काळापासून लोक परमेश्वराच्या नावाने धावा करू लागले. ");
INSERT INTO mar_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदामाच्या वंशावळीची नोंद अशी आहे. देवाने मनुष्य निर्माण केला त्या दिवशी त्याने आपल्या प्रतिरूपाचा म्हणजे आपल्यासारखा तो केला. ");
INSERT INTO mar_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","त्यांना नर व नारी असे उत्पन्न केले. त्यांना आशीर्वाद दिला व त्यांना निर्माण केले त्या वेळी त्यांना आदाम हे नाव दिले. ");
INSERT INTO mar_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","आदाम एकशे तीस वर्षांचा झाल्यावर त्यास त्याच्या प्रतिरूपाचा म्हणजे त्याच्या सारखा दिसणारा मुलगा झाला. त्याने त्याचे नाव शेथ ठेवले; ");
INSERT INTO mar_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","शेथ जन्मल्यानंतर आदाम आठशे वर्षे जगला आणि या काळात त्यास आणखी मुले व मुली झाल्या. ");
INSERT INTO mar_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","अशा रीतीने आदाम एकंदर नऊशें तीस वर्षे जगला; नंतर तो मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","शेथ एकशे पाच वर्षांचा झाल्यावर त्यास अनोश झाला ");
INSERT INTO mar_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","अनोश झाल्यानंतर शेथ आठशेसात वर्षे जगला, त्या काळात त्यास आणखी मुले व मुली झाल्या; ");
INSERT INTO mar_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","शेथ एकंदर नऊशेंबारा वर्षे जगला, मग तो मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","अनोश नव्वद वर्षांचा झाल्यावर त्यास केनान झाला; ");
INSERT INTO mar_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान झाल्यानंतर अनोश आठशेपंधरा वर्षे जगला; त्या काळात त्यास आणखी मुले व मुली झाल्या; ");
INSERT INTO mar_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","अनोश एकंदर नऊशेंपाच वर्षे जगला; त्यानंतर तो मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","केनान सत्तर वर्षांचा झाल्यावर तो महललेलाचा पिता झाला; ");
INSERT INTO mar_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महललेल झाल्यावर केनान आठशेचाळीस वर्षे जगला; त्या काळात त्यास आणखी मुले व मुली झाल्या; ");
INSERT INTO mar_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","केनान एकंदर नऊशेंदहा वर्षे जगला, नंतर तो मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","महललेल पासष्ट वर्षांचा झाल्यावर तो यारेदाचा पिता झाला; ");
INSERT INTO mar_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","यारेद जन्मल्यानंतर महललेल आठशेतीस वर्षे जगला; त्या काळात त्यास आणखी मुले व मुली झाल्या; ");
INSERT INTO mar_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","महललेल एकंदर आठशे पंचाण्णव वर्षे जगला; त्यानंतर तो मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","यारेद एकशे बासष्ट वर्षांचा झाल्यावर तो हनोखाचा पिता झाला; ");
INSERT INTO mar_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोख झाल्यावर यारेद आठशे वर्षे जगला; त्या काळात त्यास आणखी मुले व मुली झाल्या; ");
INSERT INTO mar_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","यारेद एकंदर नऊशें बासष्ट वर्षे जगला; त्यानंतर तो मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","हनोख पासष्ट वर्षांचा झाल्यावर त्यास मथुशलह झाला; ");
INSERT INTO mar_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मथुशलह जन्मल्यावर हनोख तीनशे वर्षे देवाबरोबर चालला. त्या काळात त्यास आणखी मुले व मुली झाल्या; ");
INSERT INTO mar_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","हनोख एकंदर तीनशे पासष्ट वर्षे जगला; ");
INSERT INTO mar_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोख देवाबरोबर चालला, आणि त्यानंतर तो दिसला नाही, कारण देवाने त्यास नेले. ");
INSERT INTO mar_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","मथुशलह एकशेसत्याऐंशी वर्षांचा झाल्यावर लामेखाचा पिता झाला. ");
INSERT INTO mar_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लामेखाच्या जन्मानंतर मथुशलह सातशे ब्याऐंशी वर्षे जगला. त्या काळात त्यास आणखी मुले व मुली झाल्या. ");
INSERT INTO mar_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","मथुशलह एकंदर नऊशें ऐकोणसत्तर वर्षे जगला. त्यानंतर तो मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","लामेख एकशेब्यांऐशी वर्षांचा झाल्यावर तो एका मुलाचा पिता झाला. ");
INSERT INTO mar_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","लामेखाने त्याचे नाव नोहा ठेवून म्हटले, परमेश्वराने भूमी शापित केली आहे तिच्यापासून येणाऱ्या कामात आणि आमच्या हातांच्या श्रमात हाच आम्हांला विसावा देईल. ");
INSERT INTO mar_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नोहा झाल्यावर लामेख पाचशे पंचाण्णव वर्षे जगला; त्या काळात त्यास आणखी मुले व मुली झाल्या. ");
INSERT INTO mar_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","लामेख एकंदर सातशे सत्याहत्तर वर्षे जगला. नंतर तो मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नोहा पाचशे वर्षांचा झाल्यावर त्यास शेम, हाम व याफेथ नावाचे पुत्र झाले. ");
INSERT INTO mar_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","पृथ्वीवरील मनुष्यांची संख्या वाढतच राहिली आणि त्यांना मुली झाल्या, ");
INSERT INTO mar_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","तेव्हा मानवजातीच्या मुली आकर्षक आहेत असे देवपुत्रांनी पाहिले, त्यांच्यापैकी त्यांना ज्या आवडल्या त्या त्यांनी स्त्रिया करून घेतल्या. ");
INSERT INTO mar_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","परमेश्वर म्हणाला, “माझा आत्मा मानवामध्ये सर्वकाळ राहणार नाही, कारण ते देह आहेत. ते एकशें वीस वर्षे जगतील.” ");
INSERT INTO mar_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","त्या दिवसात आणि त्यानंतरही, महाकाय मानव पृथ्वीवर होते. देवाचे पुत्र मनुष्यांच्या मुलीपाशी गेले, आणि त्यांच्याकडून त्यांना मुले झाली, तेव्हा हे घडले. प्राचीन काळचे जे बलवान, नामांकित पुरूष ते हेच. ");
INSERT INTO mar_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","पृथ्वीवर मानवजातीची दुष्टता मोठी आहे, आणि त्यांच्या मनात येणाऱ्या विचारातील प्रत्येक कल्पना केवळ एकसारखी वाईट असते, असे परमेश्वराने पाहिले. ");
INSERT INTO mar_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","म्हणून पृथ्वीवर मनुष्य निर्माण केल्याबद्दल परमेश्वरास वाईट वाटले, आणि तो मनात फार दुःखी झाला. ");
INSERT INTO mar_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","म्हणून परमेश्वर म्हणाला, “मी उत्पन्न केलेल्या मानवास पृथ्वीतलावरून नष्ट करीन; तसेच मनुष्य, पशू, सरपटणारे प्राणी, व आकाशातील पक्षी या सर्वांचा मी नाश करीन, कारण या सर्वांना उत्पन्न केल्याचे मला दुःख होत आहे.” ");
INSERT INTO mar_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","परंतु नोहावर परमेश्वराची कृपादृष्टी झाली. ");
INSERT INTO mar_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","या नोहासंबंधीच्या घटना आहेत; नोहा आपल्या काळच्या लोकांमध्ये नीतिमान आणि निर्दोष मनुष्य होता. नोहा देवाबरोबर चालला ");
INSERT INTO mar_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नोहाला शेम, हाम व याफेथ नावाचे तीन पुत्र होते. ");
INSERT INTO mar_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","देवाच्या समक्षतेत पृथ्वी भ्रष्ट झालेली होती, आणि हिंसाचाराने भरलेली होती. ");
INSERT INTO mar_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","देवाने पृथ्वी पाहिली; आणि पाहा, ती भ्रष्ट होती, कारण पृथ्वीवर सर्व प्राण्यांनी आपला मार्ग भ्रष्ट केला होता. ");
INSERT INTO mar_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","म्हणून देव नोहाला म्हणाला, “मी पाहतो की, सर्व प्राण्यांचा नाश करण्याची वेळ आता आली आहे; कारण त्यांच्यामुळे पृथ्वी अनर्थ हिंसाचाराने भरली आहे. खरोखरच मी पृथ्वीसह त्यांचा नायनाट करीन.” ");
INSERT INTO mar_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","तेव्हा आपणासाठी गोफेर लाकडाचे एक तारू कर; तू त्यामध्ये खोल्या कर आणि त्यास सर्वत्र म्हणजे आतून व बाहेरून डांबर लाव. ");
INSERT INTO mar_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","देव म्हणाला, “तारवाचे मोजमाप मी सांगतो त्याप्रमाणे असावे. ते तीनशे हात लांब, पन्नास हात रुंद, आणि तीस हात उंच असावे. ");
INSERT INTO mar_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","तारवाला छतापासून सुमारे अठरा इंचावर एक खिडकी कर. तारवाच्या एका बाजूस दार ठेव आणि तारवाला खालचा, मधला व वरचा असे तीन मजले कर. ");
INSERT INTO mar_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","आणि ऐक, आकाशाखाली ज्यांच्यामध्ये जीवनाचा श्वास आहे अशा सर्व देहधाऱ्यांचा नाश करण्यासाठी मी पृथ्वीवर जलप्रलय आणीन. पृथ्वीवर जे सर्व आहे ते मरण पावतील. ");
INSERT INTO mar_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","मी तुझ्याबरोबर आपला एक करार स्थापीन. तू, तुझ्यासोबत तुझे पुत्र, तुझी पत्नी आणि तुझ्या सुना यांना घेऊन तारवात जाशील. ");
INSERT INTO mar_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","तसेच पृथ्वीवरील प्रत्येक जातीतील सजीव प्राण्यांपैकी दोन-दोन तुझ्याबरोबर जिवंत ठेवण्यासाठी तुझ्याबरोबर तू तारवात ने; ते नर व मादी असावेत. ");
INSERT INTO mar_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","पक्ष्यांच्या प्रत्येक जातीतून, आणि मोठ्या पशूंच्या प्रत्येक जातीतून आणि भूमीवर रांगणाऱ्या प्राण्यांच्या प्रत्येक जातीतून दोन दोन जिवंत राहण्यासाठी तुझ्याकडे येतील. ");
INSERT INTO mar_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","तसेच खाण्यात येते असे सर्व प्रकारचे अन्न तुझ्याजवळ आणून ते साठवून ठेव. ते तुला व त्यांना खाण्यासाठी होईल.” ");
INSERT INTO mar_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","नोहाने हे सर्व केले. देवाने आज्ञा दिल्याप्रमाणे त्याने सर्वकाही केले. ");
INSERT INTO mar_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","नंतर परमेश्वर नोहाला म्हणाला, “चल, तू आणि तुझ्या कुटुंबातील सर्वांनी तारवात यावे, कारण या पिढीमध्ये तूच मला नीतिमान दिसला आहेस. ");
INSERT INTO mar_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","प्रत्येक शुद्ध जातीच्या प्राण्यांपैकी नर व माद्यांच्या सात सात जोड्या घे, इतर शुद्ध नाहीत त्या प्राण्यापैकी, नर व मादी अशी दोन दोन घे. ");
INSERT INTO mar_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","आणि आकाशातल्या पक्षांच्या नर व मादी अशा सात जोड्या तुझ्याबरोबर तारवात ने. अशाने पृथ्वीवर त्यांचे बीज राहील. ");
INSERT INTO mar_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","आतापासून सात दिवसानी मी पृथ्वीवर चाळीस दिवस व चाळीस रात्र पाऊस पाडीन. मी निर्माण केलेल्या प्रत्येक जिवंत गोष्टींचा मी पृथ्वीवरून नाश करीन.” ");
INSERT INTO mar_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","परमेश्वराने आज्ञा दिल्याप्रमाणे नोहाने सर्वकाही केले. ");
INSERT INTO mar_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","जलप्रलय आला तेव्हा नोहा सहाशे वर्षांचा होता. ");
INSERT INTO mar_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नोहा, त्याची मुले, त्याची पत्नी, आणि त्याच्या मुलांच्या स्त्रिया, हे सर्व जलप्रलयामुळे तारवात गेले. ");
INSERT INTO mar_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","पृथ्वीवरील शुद्ध व अशुद्ध पशुतून, पक्षी आणि जमिनीवर रांगणारे सर्वकाही, ");
INSERT INTO mar_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","देवाने नोहाला सांगितल्याप्रमाणे दोन-दोन नर व मादी असे ते नोहाकडे आले आणि तारवात गेले. ");
INSERT INTO mar_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","मग सात दिवसानंतर पृथ्वीवर पाऊस पडण्यास व जलप्रलय येण्यास सुरुवात झाली. ");
INSERT INTO mar_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नोहाच्या जीवनातील सहाशाव्या वर्षाच्या दुसऱ्या महिन्याच्या सतराव्या दिवशी पृथ्वीतील पाण्याचे सर्व झरे फुटले व पाणी उफाळून वर आले व जमिनीवरुन वाहू लागले. त्याच दिवशी मुसळधार पाऊस पडण्यास सुरुवात झाली. आणि आकाशाच्या खिडक्या उघडल्या. ");
INSERT INTO mar_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","पावसास सुरुवात झाली आणि चाळीस दिवस व चाळीस रात्र पृथ्वीवर पाऊस पडत होता. ");
INSERT INTO mar_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","त्याच दिवशी नोहा आणि त्याची मुले शेम, हाम आणि याफेथ आणि नोहाची पत्नी व त्यांच्या बरोबर त्याच्या मुलांच्या तीन बायकांनीही तारवात प्रवेश केला. ");
INSERT INTO mar_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","त्यांच्याबरोबर प्रत्येक रानटी प्राणी त्याच्या जातीप्रमाणे आणि प्रत्येक पाळीव प्राणी त्याच्या जातीच्या प्रकाराप्रमाणे आणि पृथ्वीवर रांगणारी प्रत्येक गोष्ट तिच्या जातीच्या प्रकाराप्रमाणे, आणि प्रत्येक पक्षी त्याच्या जातीच्या प्रकाराप्रमाणे, प्रत्येक प्रकारचा पंख असलेला प्राणी, यांनी तारवात प्रवेश केला. ");
INSERT INTO mar_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ज्यांच्या शरीरात जीवनाचा श्वास आहे असे सर्व दोन दोन तारवात नोहाकडे आले आणि त्यांनी तारवात प्रवेश केला. ");
INSERT INTO mar_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","देवाने त्यास आज्ञा दिल्याप्रमाणे सर्व प्रकारचे देहधारी प्राणी नर व मादी असे तारवात गेले. मग परमेश्वराने दार बंद केले. ");
INSERT INTO mar_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","मग पृथ्वीवर चाळीस दिवस पूर आला आणि पाणी वाढले आणि तारू जमिनीपासून उचलले गेले. ");
INSERT INTO mar_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","मुसळधार पावसाचा जोर वाढत गेला आणि पृथ्वीवर पाण्याचा जोर खूप वाढत गेला, आणि तारू पाण्यावर तरंगू लागले. ");
INSERT INTO mar_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","पृथ्वीवरील पाणी जोराने उंच आणि उंच वाढत गेले. आकाशाखालील सर्व उंच पर्वत पूर्णपणे त्याखाली झाकून गेले; ");
INSERT INTO mar_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","पाणी पर्वत शिखरावर पंधरा हातापेक्षा अधिक उंच इतके वर चढले. ");
INSERT INTO mar_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","पृथ्वीवरील हालचाल करणारे सर्व जिवंत प्राणी, सर्व पक्षी, गुरेढोरे, वनपशू, थव्याने राहणारे प्राणी, आणि सर्व मानवजात मरून गेले. ");
INSERT INTO mar_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ज्यांच्या नाकपुड्यात जीवनाचा श्वास होता असे, कोरड्या जमिनीवरील सर्वजण मरण पावले. ");
INSERT INTO mar_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","अशा रीतीने देवाने सर्वकाही म्हणजे मानव, पशू, सरपटणारे प्राणी आणि आकाशातील पक्षी अशा सर्व मोठ्या जीवधारी प्राण्यांचा नाश केला. पृथ्वीच्या पाठीवरून त्या सर्वांचा नाश करण्यात आला. केवळ नोहा आणि तारवात त्याच्या सोबत जे होते तेच फक्त वाचले. ");
INSERT INTO mar_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","एकशे पन्नास दिवस पृथ्वीवर पाण्याचा जोर होता. ");
INSERT INTO mar_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","देवाने नोहा, त्याच्यासोबत तारवात असलेले सर्व वन्यप्राणी आणि सर्व गुरेढोरे यांची आठवण केली. देवाने पृथ्वीवर वारा वाहण्यास लावला, आणि पाणी मागे हटण्यास सुरवात झाली. ");
INSERT INTO mar_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","पाण्याचे खोल झरे आणि आकाशाच्या खिडक्या बंद झाल्या, आणि पाऊस पडण्याचा थांबला. ");
INSERT INTO mar_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","पृथ्वीवरून पुराचे पाणी एकसारखे मागे हटत गेले. आणि दीडशे दिवसाच्या अखेरीस पुष्कळ पाणी कमी झाले. ");
INSERT INTO mar_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","सातव्या महिन्याच्या सतराव्या दिवशी तारू अरारात पर्वतावर थांबले. ");
INSERT INTO mar_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","दहाव्या महिन्यापर्यंत पाणी एकसारखे हटत गेले. दहाव्या महिन्याच्या पहिल्या दिवशी पर्वतांचे माथे दिसू लागले. ");
INSERT INTO mar_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","चाळीस दिवसानंतर नोहाने तयार केलेली तारवाची खिडकी उघडली ");
INSERT INTO mar_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","त्याने एक कावळा बाहेर सोडला आणि पृथ्वीवरील पाणी सुकून जाईपर्यंत तो इकडे तिकडे उडत राहिला. ");
INSERT INTO mar_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","नंतर जमिनीच्या वरील भागावरून पाणी मागे हटले आहे की नाही हे पाहण्याकरिता नोहाने एक कबुतर बाहेर सोडले, ");
INSERT INTO mar_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","परंतु कबुतराला पाय टेकण्यास जागा मिळाली नाही आणि ते त्याच्याकडे तारवात परत आले, कारण सर्व पृथ्वी पाण्याने झाकली होती. तेव्हा त्याने हात बाहेर काढून त्यास आपल्याबरोबर तारवात घेतले. ");
INSERT INTO mar_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","तो आणखी सात दिवस थांबला. आणि त्याने पुन्हा कबुतराला तारवाबाहेर सोडले; ");
INSERT INTO mar_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ते कबुतर संध्याकाळी त्याच्याकडे परत आले. आणि पाहा, त्याच्या चोचीत जैतून झाडाचे नुकतेच तोडलेले पान होते. यावरुन पृथ्वीवरील पाणी कमी झाले असल्याचे नोहाला समजले. ");
INSERT INTO mar_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","नोहा आणखी सात दिवस थांबला आणि त्याने कबुतरास पुन्हा बाहेर सोडले. ते परत त्याच्याकडे आले नाही. ");
INSERT INTO mar_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","असे झाले की, सहाशे एकाव्या वर्षाच्या पहिल्या महिन्याचा पहिल्या दिवशी पृथ्वीवरील पाणी सुकून गेले, तेव्हा नोहाने तारवाचे आच्छादन काढून बाहेर पाहिले, तो पाहा, जमिनीचा वरील भाग कोरडा झालेला होता. ");
INSERT INTO mar_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दुसऱ्या महिन्याच्या सत्ताविसाव्या दिवसापर्यंत पृथ्वी कोरडी झाली होती. ");
INSERT INTO mar_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","देव नोहाला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“तू, तुझी पत्नी, तुझी मुले व तुझ्या मुलांच्या स्त्रिया यांना तुझ्याबरोबर घेऊन तारवाच्या बाहेर ये. ");
INSERT INTO mar_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","तुझ्या बरोबर पक्षी, गुरेढोरे आणि पृथ्वीवर रांगणारा प्रत्येक प्राणी यांसह प्रत्येक जिवंत देहधारी प्राणी बाहेर आण. यासाठी की, त्यांची संपूर्ण पृथ्वीभर सर्वत्र असंख्य पट भरभराट व्हावी आणि पृथ्वीवर ते बहुगुणित व्हावेत.” ");
INSERT INTO mar_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","तेव्हा नोहा, त्याची पत्नी, मुले व मुलांच्या स्त्रिया यांच्यासह तारवातून बाहेर आला; ");
INSERT INTO mar_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","त्याच्या बरोबरचा प्रत्येक जिवंत प्राणी, प्रत्येक रांगणारा प्राणी व प्रत्येक पक्षी, पृथ्वीवर हालचाल करणारा प्रत्येक जीव, आपापल्या जातीप्रमाणे तारवातून बाहेर आले. ");
INSERT INTO mar_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","नोहाने परमेश्वराकरता एक वेदी बांधली. त्याने शुद्ध पक्ष्यांतून काही आणि शुद्ध पशुंतून काही घेतले, आणि त्यांचे वेदीवर होमार्पण केले. ");
INSERT INTO mar_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","परमेश्वराने तो सुखकारक सुगंध घेतला आणि आपल्या मनात म्हटले, “मानवामुळे मी पुन्हा भूमीला शाप देणार नाही; मानवाच्या मनातील योजना बालपणापासूनच वाईट आहेत. मी आता केले आहे त्याप्रमाणे मी पुन्हा कधीही सर्व जिवांचा नाश करणार नाही. ");
INSERT INTO mar_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","जोपर्यंत पृथ्वी राहील तोपर्यंत पेरणी व कापणी, थंडी व ऊन, हिवाळा व उन्हाळा, दिवस व रात्र व्हावयाची थांबणार नाहीत.” ");
INSERT INTO mar_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","नंतर देवाने नोहाला व त्याच्या मुलांना आशीर्वाद दिला आणि म्हटले, “फलदायी व्हा, बहुगुणित व्हा आणि पृथ्वी भरून टाका. ");
INSERT INTO mar_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","पृथ्वीवरील प्रत्येक जिवंत प्राणी, आकाशातील प्रत्येक पक्षी, जमिनीवर सरपटणारे सर्व प्राणी आणि समुद्रातील सर्व मासे ह्यांच्यावर तुमचे भय व धाक राहील; ते तुमच्या कह्यात दिले आहेत. ");
INSERT INTO mar_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","प्रत्येक हालचाल करणारा प्राणी हा तुमचे अन्न होईल. जशा मी हिरव्या वनस्पती दिल्या आहेत, तसेच आता सर्वकाही तुम्हास देत आहे. ");
INSERT INTO mar_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","पण ज्यामध्ये त्याचे जीवन म्हणजे रक्त आहे, ते मांस तुम्ही खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","परंतु तुमच्या रक्तासाठी, जे रक्त तुमचे जीवन आहे, त्याबद्दल मी आवश्यक भरपाई घेईन. प्रत्येक प्राण्याच्या हातून मी ती घेईन. मनुष्याच्या हातून, म्हणजे ज्याने आपल्या भावाचा खून केला आहे त्याच्या हातून, त्या मनुष्याच्या जिवाबद्दल मी भरपाईची मागणी करीन. ");
INSERT INTO mar_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","जो कोणी मनुष्याचे रक्त पाडतो, त्याचे रक्त मनुष्याकडून पाडले जाईल, कारण देवाने मनुष्यास त्याच्या प्रतिरूपाचे बनवले आहे. ");
INSERT INTO mar_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","तुम्ही मात्र फलदायी आणि बहुगुणित व्हा, सर्व पृथ्वीवर विस्तारा, आणि तिच्यावर बहुगुणित व्हा.” ");
INSERT INTO mar_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","मग देव नोहाला व त्याच्या मुलांना म्हणाला, ");
INSERT INTO mar_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“माझे ऐका! मी तुमच्याशी व तुमच्या नंतर तुमच्या वंशजाशी एक करार स्थापन करतो, ");
INSERT INTO mar_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","आणि तुमच्याबरोबर असलेले सर्व जिवंत प्राणी, म्हणजे तुमच्याबरोबर तारवातून बाहेर आलेले पक्षी, गुरेढोरे, आणि पृथ्वीवर राहणारे सर्व प्राणी त्यांच्याशीही एक करार स्थापित करतो. ");
INSERT INTO mar_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","अशा प्रकारे मी तुमच्याशी करार स्थापित करतो की, यापुढे पुराच्या पाण्याने पृथ्वीवरील सर्व देह पुन्हा कधीही नष्ट केले जाणार नाहीत व पुन्हा कधीही पुराने पृथ्वीचा नाश होणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","देव म्हणाला, “मी माझ्यामध्ये आणि तुमच्यामध्ये, व तुमच्याबरोबर जे सर्व जिवंत जीव आहेत त्यांच्यामध्ये भावी पिढ्यानपिढ्यासाठी हा करार केल्याची निशाणी हीच आहे. ");
INSERT INTO mar_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","मी ढगात मेघधनुष्य ठेवले आहे; ते सर्व पृथ्वी व माझ्यामध्ये केलेल्या कराराची निशाणी आहे. ");
INSERT INTO mar_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","मी जेव्हा पृथ्वीवर ढग आणीन तेव्हा तुम्हास ढगात मेघधनुष्य दिसेल, ");
INSERT INTO mar_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","नंतर मी ते पाहीन तेव्हा मी तुमच्याशी व पृथ्वीवरील सर्व देहातल्या जिवंत प्राण्यांशी केलेल्या माझ्या कराराची मला आठवण होईल, या कराराप्रमाणे पुराच्या पाण्याने पृथ्वीवरील सर्व देहाचा पुन्हा कधीही नाश करणार नाही. ");
INSERT INTO mar_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","मेघधनुष्य ढगात राहील आणि जो सर्वकाळचा करार देव आणि पृथ्वीवरील सर्व देहातले जिवंत प्राणी यांच्यामध्ये आहे त्याची आठवण म्हणून मी त्याकडे पाहीन.” ");
INSERT INTO mar_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","नंतर देव नोहाला म्हणाला, “हे मेघधनुष्य माझ्यामध्ये व पृथ्वीवरील सर्व देहांमध्ये स्थापित केलेल्या कराराची निशाणी आहे.” ");
INSERT INTO mar_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नोहाबरोबर त्याचे पुत्र तारवाबाहेर आले; त्यांची नावे शेम, हाम व याफेथ अशी होती. आणि हाम हा कनानाचा पिता होता ");
INSERT INTO mar_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","हे नोहाचे तीन पुत्र होते, आणि यांच्यापासूनच सर्व पृथ्वीवर लोकविस्तार झाला. ");
INSERT INTO mar_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नोहा शेतकरी बनला, आणि त्याने एक द्राक्षमळा लावला. ");
INSERT INTO mar_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","तो थोडा द्राक्षरस प्याला आणि तो धुंद झाला. तो त्याच्या तंबूत उघडा-वाघडा पडला होता. ");
INSERT INTO mar_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","तेव्हा कनानाचा पिता हाम याने आपला पिता उघडा-वागडा पडलेला असल्याचे पाहिले व त्याने तंबूच्या बाहेर येऊन ते आपल्या भावांना सांगितले. ");
INSERT INTO mar_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","मग शेम व याफेथ यांनी एक कपडा घेतला व तो आपल्या खांद्यावर ठेवून ते पाठमोरे तंबूत गेले. अशा प्रकारे त्यांनी आपल्या पित्याची नग्नता झाकली; पाठमोरे असल्यामुळे ती त्यांना दिसली नाही. ");
INSERT INTO mar_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जेव्हा नोहा नशेतून जागा झाला, तेव्हा आपला धाकटा मुलगा हाम याने काय केले हे त्यास समजले. ");
INSERT INTO mar_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","तेव्हा नोहा म्हणाला, “कनान शापित होवो, तो आपल्या भावाच्या गुलामातील सर्वांत खालचा गुलाम होवो.” ");
INSERT INTO mar_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","तो म्हणाला, “शेमाचा देव परमेश्वर धन्यवादित असो. कनान त्याचा सेवक होवो. ");
INSERT INTO mar_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","देव याफेथाचा अधिक विस्तार करो, आणि शेमाच्या तंबूत तो त्याचे घर करो. कनान त्यांचा सेवक होवो.” ");
INSERT INTO mar_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","पूरानंतर नोहा तीनशे पन्नास वर्षे जगला; ");
INSERT INTO mar_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","नोहा एकूण नऊशें पन्नास वर्षे जगला; मग त्यानंतर तो मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नोहाच्या शेम, हाम व याफेथ या मुलांचे वंशज हे आहेत. पुरानंतर त्यांना मुले झाली. ");
INSERT INTO mar_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","याफेथाचे पुत्र गोमर, मागोग, माद्य, यावान, तुबाल, मेशेख व तीरास हे होते. ");
INSERT INTO mar_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमरचे पुत्र आष्कनाज, रीफाथ व तोगार्मा हे होते. ");
INSERT INTO mar_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावानाचे पुत्र अलीशा, तार्शीश, कित्तीम व दोदानीम हे होते. ");
INSERT INTO mar_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","यांच्यापैकी समुद्र किनारपट्टीवरील लोक वेगळे झाले आणि आपापल्या भाषेनुसार, कुळानुसार त्यांनी देश वसवले. ");
INSERT INTO mar_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हामाचे पुत्र कूश, मिस्राईम, पूट व कनान होते. ");
INSERT INTO mar_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूशाचे पुत्र सबा, हवीला, साब्ता, रामा, व साब्तका होते आणि रामाचे पुत्र शबा व ददान हे होते. ");
INSERT INTO mar_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूशाने निम्रोदाला जन्म दिला, जो पृथ्वीवरचा पहिला जगजेत्ता बनला. ");
INSERT INTO mar_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","तो परमेश्वरापुढे पराक्रमी शिकारी मनुष्य बनला. त्यामुळे “निम्रोदासारखा परमेश्वरापुढे पराक्रमी शिकारी” अशी म्हण पडली आहे. ");
INSERT INTO mar_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","त्याच्या राज्याची पहिली मुख्य ठिकाणे शिनार देशातील बाबेल, एरक, अक्काद व कालने ही होती. ");
INSERT INTO mar_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","त्या देशातून तो अश्शूर देशास गेला व तेथे त्याने निनवे, रहोबोथ, ईर, कालह ही शहरे बांधली ");
INSERT INTO mar_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","आणि निनवे व कालह यांच्या दरम्यान त्याने रेसन नावाचे शहर वसवले. हे एक मोठे शहर आहे. ");
INSERT INTO mar_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिस्राईम हा लूदीम, अनामीम, लहाबीम, नाप्तुहीम, ");
INSERT INTO mar_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पात्रुसीम, कास्लूहीम (ज्यांच्यापासून पलिष्टी झाले), व कफतोरीम, ह्यांचा पिता बनला. ");
INSERT INTO mar_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान हा त्याचा प्रथम जन्मलेला मुलगा सीदोन आणि हेथ यांचा, ");
INSERT INTO mar_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","तसेच यबूसी, अमोरी, गिर्गाशी, ");
INSERT INTO mar_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, आर्की व शीनी ");
INSERT INTO mar_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वादी, समारी व हमाथी यांचा पिता होता. त्यानंतर कनानाची कुळे सर्वत्र पसरली. ");
INSERT INTO mar_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","कनान्यांची सीमा सीदोनापासून गराराकडे जाते त्या वाटेने गज्जा शहरापर्यंत होती. सदोम व गमोरा व तसेच अदमा व सबोयिम या शहरांकडे जाणाऱ्या वाटेवर लेशापर्यंत ती होती. ");
INSERT INTO mar_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","कूळ, भाषा, देश व यांनुसार हे सर्व हाम याचे वंशज होते. ");
INSERT INTO mar_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","शेम हा याफेथाचा वडील भाऊ होता. एबर हा शेम यांचा वंशज होता. तो सर्व एबर लोकांचा मूळ पुरुष होता. ");
INSERT INTO mar_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेम याचे पुत्र एलाम, अश्शूर, अर्पक्षद, लूद व अराम हे होते. ");
INSERT INTO mar_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अरामाचे पुत्र ऊस, हूल, गेतेर, आणि मेशेख हे होते. ");
INSERT INTO mar_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पक्षद हा शेलहचा पिता झाला, शेलह हा एबरचा पिता झाला. ");
INSERT INTO mar_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबर याला दोन मुले झाली. एकाचे नाव पेलेग होते, कारण त्याच्या काळात पृथ्वीची विभागणी झाली; त्याच्या भावाचे नाव यक्तान होते. ");
INSERT INTO mar_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","यक्तान अलमोदाद, शेलेफ, हसर्मावेथ, येरह ");
INSERT INTO mar_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोराम, ऊजाल, दिक्ला ");
INSERT INTO mar_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शबा, ");
INSERT INTO mar_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओफीर, हवीला व योबाब यांचा पिता झाला. हे सर्व यक्तानाचे पुत्र होते. ");
INSERT INTO mar_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","त्यांचा प्रदेश मेशापासून पूर्वेकडील डोंगराळ भागात, सेफर प्रदेशापर्यंत होता. ");
INSERT INTO mar_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","आपआपली कुळे, आपापल्या भाषा, देश व राष्ट्रे यांप्रमाणे विभागणी झालेले हे शेमाचे पुत्र. ");
INSERT INTO mar_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","पिढ्या व राष्ट्रे ह्यांनुसार ही नोहाच्या मुलांची कुळे आहेत. महापुरानंतर यांच्यापासून वेगवेगळी राष्ट्रे निर्माण होऊन पृथ्वीवर पसरली. ");
INSERT INTO mar_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","आता पृथ्वीवरील सर्व लोक एकच भाषेचा वापर करत होते आणि शब्द समान होते. ");
INSERT INTO mar_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ते पूर्वेकडे प्रवास करत असताना त्यांना शिनार देशात एक मैदान लागले आणि त्यांनी तेथेच वस्ती केली. ");
INSERT INTO mar_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ते एकमेकांना म्हणाले, “चला, आपण विटा करू व त्या पक्क्या भाजू.” त्यांच्याकडे बांधकामासाठी दगडाऐवजी विटा आणि चुन्याऐवजी डांबर होते. ");
INSERT INTO mar_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","मग लोक म्हणाले, “चला, आपण आपल्यासाठी नगर बांधू आणि ज्याचे शिखर आकाशापर्यंत पोहचेल असा उंच बुरूज बांधू, आणि आपण आपले नाव होईल असे करू या. आपण जर असे केले नाही, तर पृथ्वीच्या पाठीवर आपली पांगापांग होईल.” ");
INSERT INTO mar_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","आदामाच्या वंशजांनी बांधलेले ते नगर व तो बुरूज पाहण्यासाठी म्हणून परमेश्वर खाली उतरून आला. ");
INSERT INTO mar_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","परमेश्वर देव म्हणाला, “पाहा, हे सर्व लोक एक असून, एकच भाषा बोलतात आणि ही तर त्यांची सुरुवात आहे! लवकरच, जे काही करण्याचा त्यांचा हेतू आहे ते करणे त्यांना मुळीच अशक्य होणार नाही. ");
INSERT INTO mar_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","चला आपण खाली जाऊन त्यांच्या भाषेचा घोटाळा करून टाकू. मग त्यांना एकमेकांचे बोलणे समजणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","मग परमेश्वराने पृथ्वीभर त्यांची पांगापांग केली आणि म्हणून नगर बांधण्याचे काम त्यांनी थांबवले. ");
INSERT INTO mar_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","त्यामुळे त्या ठिकाणाचे नाव बाबेल पडले, कारण तेथे परमेश्वराने सर्व पृथ्वीच्या भाषेचा घोटाळा केला आणि परमेश्वराने त्यांना तेथून सर्व पृथ्वीच्या पाठीवर पांगविले. ");
INSERT INTO mar_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ही शेमाची वंशावळ: जलप्रलयानंतर दोन वर्षांनी शेम शंभर वर्षांचा झाला होता आणि तो अर्पक्षदाचा पिता झाला. ");
INSERT INTO mar_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अर्पक्षदाला जन्म दिल्यानंतर शेम पाचशे वर्षे जगला, तो आणखी मुले व मुलींचा पिता झाला. ");
INSERT INTO mar_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","अर्पक्षद पस्तीस वर्षांचा झाला तेव्हा त्याने शेलहाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","शेलहाला जन्म दिल्यानंतर अर्पक्षद चारशे तीन वर्षे जगला व त्याने आणखी मुलांना व मुलींना जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","जेव्हा शेलह तीस वर्षांचा झाला तेव्हा त्याने एबरला जन्म दिला; ");
INSERT INTO mar_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","एबरला जन्म दिल्यावर शेलह चारशे तीन वर्षे जगला व त्याने आणखी मुलांना व मुलींना जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","एबर चौतीस वर्षांचा झाला तेव्हा त्याने पेलेगाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","पेलेग झाल्यावर एबर चारशे तीस वर्षे जगला व त्याने आणखी मुलांना व मुलींना जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","पेलेग तीस वर्षांचा झाला, तेव्हा त्याने रऊ याला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","रऊ याला जन्म दिल्यावर पेलेग दोनशे नऊ वर्षे जगला व त्याने आणखी मुलांना व मुलींना जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","रऊ बत्तीस वर्षांचा झाला, तेव्हा त्याने सरुगाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","सरुगाला जन्म दिल्यावर रऊ दोनशे सात वर्षे जगला व त्याने आणखी मुलांना व मुलींना जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","सरुग तीस वर्षांचा झाला, तेव्हा त्याने नाहोराला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","नाहोराला जन्म दिल्यावर सरुग दोनशे वर्षे जगला आणि त्याने आणखी मुलांना व मुलींना जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","नाहोर एकोणतीस वर्षांचा झाला, तेव्हा त्याने तेरहाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","तेरहाला जन्म दिल्यावर नाहोर आणखी एकशे एकोणीस वर्षे जगला आणि त्याने मुलांना व मुलींना जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तेरह सत्तर वर्षांचा झाला, तेव्हा त्याने अब्राम, नाहोर व हारान यांना जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरहाची वंशावळ ही: तेरहाने अब्राम, नाहोर व हारान यांना जन्म दिला. हारानाने लोटाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान, आपला पिता तेरह जिवंत असताना आपली जन्मभूमी खास्द्यांचे ऊर येथे मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम व नाहोर या दोघांनीही लग्न केले. अब्रामाच्या पत्नीचे नाव साराय आणि नाहोरच्या पत्नीचे नाव मिल्का होते. मिल्का ही हारानाची मुलगी होती. हा हारान मिल्का व इस्का यांचा पिता होता. ");
INSERT INTO mar_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","साराय वांझ होती, तिला मूलबाळ नव्हते. ");
INSERT INTO mar_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","मग तेरह आपले कुटुंब घेऊन म्हणजे आपला मुलगा अब्राम, हारानचा मुलगा लोट, आणि आपली सून म्हणजे अब्रामाची पत्नी साराय यांना बरोबर घेऊन खास्द्यांचे ऊर येथून कनान देशास जाण्यासाठी निघाला आणि प्रवास करीत ते हारान प्रदेशापर्यंत येऊन तेथे राहिले. ");
INSERT INTO mar_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरह दोनशे पाच वर्षे जगला; त्यानंतर तो हारान येथे मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","आता परमेश्वर अब्रामाला म्हणाला, “तू आपला देश, आपले नातलग आणि बापाचे घर सोडून मी दाखवीन त्या देशात जा. ");
INSERT INTO mar_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","मी तुझे मोठे राष्ट्र करीन आणि मी तुला आशीर्वाद देईन आणि मी तुझे नाव मोठे करीन आणि तू आशीर्वादित होशील, ");
INSERT INTO mar_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","जे लोक तुला आशीर्वाद देतील त्यांना मी आशीर्वाद देईन, परंतु जो कोणी तुझा अनादर करील त्यास मी शाप देईन. तुझ्यामुळे पृथ्वीवरील सर्व कुटुंबे आशीर्वादित होतील.” ");
INSERT INTO mar_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","परमेश्वराने अब्रामाला सांगितल्याप्रमाणे त्याने केले, तो गेला आणि त्याच्याबरोबर लोट गेला. त्याने हारान सोडले त्या वेळी अब्राम पंचाहत्तर वर्षांचा होता. ");
INSERT INTO mar_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्रामाने त्याची पत्नी साराय, त्याच्या भावाचा मुलगा लोट आणि हारान प्रदेशामध्ये त्यांनी जमा केलेली सर्व मालमत्ता, आणि हारानात विकत घेतलेले लोक या सर्वांना बरोबर घेतले. ते कनान देशात जाण्यासाठी निघाले आणि कनान देशात आले. ");
INSERT INTO mar_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम कनान देशातून प्रवास करीत शखेमापर्यंत मोरेच्या एलोन झाडापर्यंत गेला. त्या काळी त्या देशात कनानी लोक राहत होते. ");
INSERT INTO mar_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","परमेश्वर अब्रामाला दर्शन देऊन म्हणाला, “हा देश मी तुझ्या वंशजांना देईन.” ज्या जागेवर परमेश्वराने अब्रामाला दर्शन दिले त्या जागी त्याने परमेश्वरासाठी वेदी बांधली. ");
INSERT INTO mar_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","मग अब्राम तेथून निघाला आणि प्रवास करीत तो बेथेलच्या पूर्वेस डोंगराळ भागात पोहचला व त्याने तेथे तंबू ठोकला; तेथून बेथेल पश्चिमेस होते आणि आय शहर पूर्वेस होते; तेथे त्याने परमेश्वरासाठी दुसरी वेदी बांधली आणि परमेश्वराचे नाव घेऊन प्रार्थना केली. ");
INSERT INTO mar_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","त्यानंतर अब्राम पुन्हा पुढच्या प्रवासास निघाला व दक्षिणेकडील नेगेब वाळवंटाकडे गेला. ");
INSERT INTO mar_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","त्या काळी त्या प्रदेशात मोठा दुष्काळ पडला; म्हणून अब्राम खाली मिसर देशामध्ये राहायला गेला. कारण देशात तीव्र दुष्काळ पडला होता. ");
INSERT INTO mar_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","मिसर देशात प्रवेश करण्यापूर्वी अब्राम आपली पत्नी साराय हिला म्हणाला, “पाहा मला माहीत आहे की, तू अतिशय सुंदर स्त्री आहेस. ");
INSERT INTO mar_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","मिसराचे लोक जेव्हा तुला पाहतील तेव्हा ते म्हणतील, ही त्याची पत्नी आहे, आणि मग तुझ्यासाठी ते मला मारून टाकतील, परंतु तुला जिवंत ठेवतील. ");
INSERT INTO mar_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","म्हणून, तू माझी बहीण आहेस, असे तू लोकांस सांग. म्हणजे तुझ्यामुळे माझे बरे होईल, आणि ते मला मारणार नाहीत, अशा रीतीने तू माझा जीव वाचवशील.” ");
INSERT INTO mar_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","अब्रामाने जेव्हा मिसर देशात प्रवेश केला, तेव्हा तेथील लोकांनी पाहिले की साराय ही फार सुंदर स्त्री आहे. ");
INSERT INTO mar_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","मिसर देशाचा राजा फारो याच्या राजकुमारांनी सारायला पाहिले व त्यांनी आपला राजा फारो याच्याजवळ तिच्या सौंदर्याची स्तुती केली आणि तिला राजाच्या घरी घेऊन जाण्यात आले. ");
INSERT INTO mar_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","तिच्यामुळे त्याने अब्रामाचे बरे केले. त्यास मेंढरे, गुरेढोरे, व गाढवे दिली तसेच अब्रामाला दास, दासी व उंटही मिळाले. ");
INSERT INTO mar_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","अब्रामाची पत्नी साराय हिला फारोने नेले म्हणून परमेश्वराने फारो व त्याच्या घरातील लोकांस भयंकर पीडांनी पीडले. ");
INSERT INTO mar_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","तेव्हा फारोने अब्रामास बोलावले. तो म्हणाला, “तू हे माझ्याबाबत का केलेस? साराय तुझी पत्नी आहे हे तू मला का सांगितले नाहीस? ");
INSERT INTO mar_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ती माझी बहीण आहे असे तू का म्हणालास? मला पत्नी करण्यासाठी मी तिला नेले होते, परंतु मी आता तुझी पत्नी तुला परत करतो, तिला घेऊन जा.” ");
INSERT INTO mar_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","मग अब्रामाची मिसरमधून बाहेर रवानगी करावी अशी फारोने आपल्या माणसांना आज्ञा दिली. तेव्हा अब्राम व त्याची पत्नी साराय यांनी आपले सर्वकाही बरोबर घेऊन मिसर सोडले. ");
INSERT INTO mar_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","अशा रीतीने अब्रामाने मिसर देश सोडला आणि तो, त्याची पत्नी साराय, आणि त्याचे जे सर्वकाही होते ते घेऊन नेगेबात गेला. लोटही त्याच्याबरोबर गेला. ");
INSERT INTO mar_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","आता अब्राम जनावरे, तसेच सोने आणि चांदी यांनी फार श्रीमंत झाला होता. ");
INSERT INTO mar_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","तो आपला प्रवास करीत नेगेबापासून बेथेल नगरामध्ये गेला, बेथेल व आय यांच्यामध्ये ज्या ठिकाणी त्याचा तंबू पूर्वी होता तेथपर्यंत गेला. ");
INSERT INTO mar_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","जेथे त्याने पहिल्याने वेदी बांधली होती तेथेच ही जागा आहे आणि तेथे त्याने परमेश्वराच्या नावाचा धावा केला. ");
INSERT INTO mar_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","आता लोट जो अब्रामाबरोबर प्रवास करीत होता. याच्याकडेसुद्धा कळप, गुरेढोरे व लोक होते. ");
INSERT INTO mar_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","तो देश त्या दोघांना एकत्र जवळ राहण्यास पुरेना, कारण त्यांची मालमत्ता फारच मोठी होती, ती इतकी की त्यांना एकत्र राहता येईना. ");
INSERT INTO mar_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","तेथे अब्रामाचे गुराखी व लोटाचे गुराखी यांच्यामध्ये भांडणेसुद्धा होऊ लागली; त्या काळी त्या देशात कनानी व परिज्जी लोक राहत होते. ");
INSERT INTO mar_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","तेव्हा अब्राम लोटाला म्हणाला, “तुझ्यामध्ये व माझ्यामध्ये, तसेच तुझे गुराखी व माझे गुराखी यांच्यामध्ये भांडण नसावे. शेवटी आपण एक कुटुंब आहोत. ");
INSERT INTO mar_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","तुझ्यापुढे सर्व देश नाही काय? पुढे जा आणि माझ्यापासून तू वेगळा हो. तू जर डावीकडे गेलास तर मी उजवीकडे जाईन, आणि तू जर उजवीकडे गेलास तर मी डावीकडे जाईन.” ");
INSERT INTO mar_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","लोटाने सभोवार पाहिले, आणि यार्देन खोऱ्याकडे नजर टाकली तेव्हा तेथे सर्वत्र भरपूर पाणी असल्याचे त्यास दिसले. परमेश्वराने सदोम व गमोरा या शहरांचा नाश करण्यापूर्वी सोअराकडे जाते त्या वाटेने लागणारे खोरे परमेश्वराच्या बागेसारखे, मिसर देशासारखे होते. ");
INSERT INTO mar_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","तेव्हा लोटाने यार्देनेचे सर्व खोरे निवडले. मग ते दोघे वेगळे झाले आणि लोटाने पूर्वेकडे प्रवास करण्यास सुरुवात केली, आणि ते एकमेकांपासून वेगळे झाले. ");
INSERT INTO mar_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनान देशातच राहिला आणि लोट यार्देनेच्या मैदानातल्या शहरामध्ये जाऊन राहिला; लोट दूर सदोमाला गेला आणि तेथेच त्याने आपला तंबू ठोकला. ");
INSERT INTO mar_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोम नगराचे लोक अतिशय दुष्ट असून परमेश्वराच्या विरूद्ध पाप करणारे होते. ");
INSERT INTO mar_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","लोट अब्राहापासून वेगळा झाल्यावर परमेश्वर अब्रामाला म्हणाला, “तू जेथे उभा आहेस त्या ठिकाणापासून उत्तरेकडे व दक्षिणेकडे, पूर्वेकडे व पश्चिमेकडे पाहा. ");
INSERT INTO mar_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","तू पाहतोस हा सगळा प्रदेश मी तुला आणि तुझ्यानंतर तुझ्या संततीला कायमचा देईन. ");
INSERT INTO mar_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","मी तुझी संतती या पृथ्वीवरील धुळीच्या कणांइतकी करीन, ते असे की, जर कोणाला ते धुळीचे कण मोजता येतील तर तुझे संतानही मोजता येईल. ");
INSERT INTO mar_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ऊठ, देशातून येथून तेथून चालत जा आणि त्याची लांबी व त्याची रुंदी पाहा, कारण तो मी तुला देणार आहे.” ");
INSERT INTO mar_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","तेव्हा अब्रामाने आपला तंबू हलविला व तो हेब्रोन शहराजवळील मम्रेच्या एलोन झाडाशेजारी रहावयास गेला. परमेश्वरासाठी त्याने तेथे वेदी बांधिली. ");
INSERT INTO mar_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","त्यानंतर शिनाराचा राजा अम्राफेल, एल्लासाराचा राजा अर्योक, एलामाचा राजा कदार्लागोमर आणि गोयिमाचा राजा तिदाल यांच्या दिवसात असे झाले की, ");
INSERT INTO mar_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","त्यांनी सदोमाचा राजा बेरा, गमोराचा राजा बिर्शा, अदमाचा राजा शिनाब, सबोयिमाचा राजा शमेबर आणि बेला ज्याला सोअर म्हणतात त्याच्या राजांशी युद्ध केले. ");
INSERT INTO mar_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","नंतर हे पाच राजे सिद्दीम खोऱ्यात एकत्र जमले. या खोऱ्याला क्षार समुद्र असेही म्हणतात. ");
INSERT INTO mar_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","त्यांनी बारा वर्षे कदार्लागोमरची सेवा केली होती, परंतु तेराव्या वर्षी त्यांनी त्याच्या विरूद्ध बंड केले. ");
INSERT INTO mar_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","त्यानंतर चौदाव्या वर्षी कदार्लागोमर व त्याच्या बरोबरचे राजे आले आणि त्यांनी अष्टरोथ-कर्णईम येथे रेफाईम लोकांस, हाम येथे जूजीम लोकांस, शावेह किर्याथाईम येथे एमीम या लोकांस मारले. ");
INSERT INTO mar_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","आणि होरी यांना त्यांच्या सेईर डोंगराळ प्रदेशात जे एल पारान रान आहे तेथपर्यंत त्यांनी जाऊन मारले. ");
INSERT INTO mar_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","नंतर ते मागे फिरून एन-मिशपात म्हणजे कादेश येथे आले. आणि त्यांनी सर्व अमालेकी देशाचा आणि तसेच हससोन-तामार येथे राहणाऱ्या अमोरी लोकांचाही पराभव केला. ");
INSERT INTO mar_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","नंतर सदोमाचा राजा, गमोराचा राजा, अदमाचा राजा, सबोयिमाचा राजा आणि बेला म्हणजे सोअराचा राजा ह्यांनी लढाईची तयारी केली. ");
INSERT INTO mar_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","एलामाचा राजा कदार्लागोमर, गोयिमाचा राजा तिदाल, शिनाराचा राजा अम्राफेल आणि एल्लासाराचा राजा अर्योक यांच्या विरूद्ध ते लढले. हे चार राजे पाच राजांविरूद्ध लढले. ");
INSERT INTO mar_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीम खोऱ्यात पूर्ण डांबराने भरलेले खड्डे होते आणि सदोम व गमोराचे राजे पळून जाताना त्यामध्ये पडले, जे राहिले ते डोंगराकडे पळून गेले. ");
INSERT INTO mar_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","अशा रीतीने शत्रूंनी सदोम व गमोरा नगराच्या सर्व वस्तू आणि त्यांचा सर्व अन्नसाठा लुटून घेऊन माघारी गेले. ");
INSERT INTO mar_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ते गेले तेव्हा त्यांनी अब्रामाच्या भावाचा मुलगा लोट जो सदोमात राहत होता, त्यालासुद्धा त्याच्या सर्व मालमत्तेसह नेले. ");
INSERT INTO mar_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","तेथून पळून आलेल्या एकाने अब्राम इब्रीला हे सांगितले. तो तर अष्कोल व आनेर ह्यांचा भाऊ मम्रे अमोरी याच्या एलोन झाडांजवळ राहत होता आणि ते सर्व अब्रामाचे सहकारी होते. ");
INSERT INTO mar_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जेव्हा अब्रामाने ऐकले की, त्याच्या नातेवाइकांना शत्रूंनी पकडून नेले आहे तेव्हा त्याने आपल्या घरी जन्मलेली, लढाईचे शिक्षण घेतलेली तीनशे अठरा माणसे घेऊन सरळ दान नगरापर्यंत शत्रूंचा पाठलाग केला. ");
INSERT INTO mar_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","त्याने रात्री त्याचे लोक त्यांच्याविरुद्ध विभागले आणि त्यांच्यावर हल्ला केला आणि दिमिष्काच्या डावीकडे होबापर्यंत त्यांचा पाठलाग केला. ");
INSERT INTO mar_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","अब्रामाने सगळी मालमत्ता आणि त्याचा नातेवाइक लोट आणि त्याच्या वस्तू, त्याचप्रमाणे स्त्रिया आणि इतर लोक यांना परत आणले. ");
INSERT INTO mar_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","मग कदार्लागोमर व त्याच्याबरोबरचे राजे यांचा पराभव केल्यावर अब्राम परत आला तेव्हा सदोमाचा राजा शावेच्या खोऱ्यात त्यास भेटायला बाहेर आला. या खोऱ्याला राजाचे खोरे असे म्हणतात. ");
INSERT INTO mar_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","देवाचा याजक असलेला शालेमाचा राजा मलकीसदेक भाकर व द्राक्षरस घेऊन अब्रामाला भेटण्यास आला. हा परात्पर देवाचा याजक होता. ");
INSERT INTO mar_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","त्याने अब्रामाला आशीर्वाद देऊन म्हटले, “अब्रामा, आकाश व पृथ्वी यांचा उत्पन्नकर्ता परात्पर देव तुला आशीर्वाद देवो. ");
INSERT INTO mar_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","परात्पर देव ज्याने तुझे शत्रू तुझ्या हाती दिले तो धन्यवादित असो.” तेव्हा अब्रामाने त्यास सर्वाचा दहावा भाग दिला. ");
INSERT INTO mar_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","सदोमाचा राजा अब्रामास म्हणाला, “मला फक्त माझे लोक द्या आणि तुमच्यासाठी वस्तू घ्या.” ");
INSERT INTO mar_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","अब्राम सदोमाच्या राजाला म्हणाला, “आकाश व पृथ्वीचा उत्पन्नकर्ता परमेश्वर परात्पर देव याच्यासमोर आपला हात उंचावून मी वचन देतो की, ");
INSERT INTO mar_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","तुझा दोरा, चपलेचा बंध, किंवा जे तुझे आहे त्यातून मी काहीच घेणार नाही, नाहीतर तू म्हणशील, ‘अब्रामाला मी धनवान केले.’ ");
INSERT INTO mar_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","माझ्या या तरुणांनी जे अन्न खाल्ले आहे तेवढे पुरे. आनेर, अष्कोल व मम्रे हे जे पुरुष माझ्याबरोबर गेले त्यांना आपापला वाटा घेऊ द्या.” ");
INSERT INTO mar_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","या गोष्टी घडल्यानंतर अब्रामाला दृष्टांतात परमेश्वराचे वचन आले. तो म्हणाला, “अब्रामा, भिऊ नको. मी तुझे संरक्षण करीन आणि तुला फार मोठे प्रतिफळ देईन.” ");
INSERT INTO mar_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्राम म्हणाला, “हे प्रभू परमेश्वरा, मी अजून निपुत्रिक आहे, आणि माझ्या घराचा वारस दिमिष्क शहरातील अलिएजर हाच होईल, तेव्हा तू मला काय देणार?” ");
INSERT INTO mar_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अब्राम म्हणाला, “तू मला संतान दिले नाहीस म्हणून माझ्या घराचा कारभारीच माझा वारस आहे.” ");
INSERT INTO mar_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","नंतर, पाहा, परमेश्वराचे वचन अब्रामाकडे आले. तो म्हणाला, “हा मनुष्य तुझा वारस होणार नाही, तर तुझ्या पोटी येईल तोच तुझा वारस होईल.” ");
INSERT INTO mar_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","मग त्याने त्यास बाहेर आणले, आणि म्हटले, “या आकाशाकडे पाहा, तुला तारे मोजता येतील तर मोज.” तो त्यास म्हणाला, “असे तुझे संतान होईल.” ");
INSERT INTO mar_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","त्याने परमेश्वरावर विश्वास ठेवला. आणि तो विश्वास त्याचा प्रामाणिकपणा असा मोजण्यात आला. ");
INSERT INTO mar_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","परमेश्वर त्यास म्हणाला, “हा देश तुला वतन करून देण्याकरता खास्द्यांच्या ऊर देशातून तुला आणणारा मीच परमेश्वर आहे.” ");
INSERT INTO mar_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","तो त्यास म्हणाला, “हे प्रभू परमेश्वरा मला हे वतन मिळेल हे मी कशावरून समजू?” ");
INSERT INTO mar_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","तो त्यास म्हणाला, “माझ्यासाठी तीन वर्षांची एक कालवड, तीन वर्षांची एक शेळी, तीन वर्षांचा एक एडका तसेच एक होला व एक पारव्याचे पिल्लू आण.” ");
INSERT INTO mar_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","त्याने ते सर्व त्याच्याकडे आणले आणि त्यांना चिरून त्या प्रत्येकाचे दोन दोन तुकडे केले व प्रत्येक अर्धा भाग दुसऱ्या अर्ध्या भागासमोर ठेवला. पण पक्षी त्याने चिरले नाहीत; ");
INSERT INTO mar_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","कापलेल्या प्राण्यांचे मांस खाण्याकरिता पक्ष्यांनी त्यावर झडप घातली, परंतु अब्रामाने त्यांना हाकलून लावले. ");
INSERT INTO mar_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","नंतर जेव्हा सूर्य मावळू लागला, तेव्हा अब्रामाला गाढ झोप लागली आणि पाहा निबिड आणि घाबरून सोडणाऱ्या काळोखाने त्यास झाकले. ");
INSERT INTO mar_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","मग परमेश्वर अब्रामाला म्हणाला, “तुला या गोष्टी समजल्या पाहिजेत; तुझे वंशज जो देश त्यांचा नाही त्या अनोळखी देशात राहतील आणि ते तेथे गुलाम होतील आणि चारशे वर्षे त्यांचा छळ होईल. ");
INSERT INTO mar_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","परंतु ज्याने त्यांना गुलाम बनवले त्या राष्ट्राचा मी न्याय करीन, आणि मग आपल्या बरोबर पुष्कळ धन घेऊन ते त्या देशातून निघतील. ");
INSERT INTO mar_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","तू स्वतः फार म्हातारा होऊन शांतीने आपल्या पूर्वजांकडे जाशील आणि चांगला म्हातारा झाल्यावर तुला पुरतील. ");
INSERT INTO mar_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","मग चार पिढ्यानंतर तुझे लोक या देशात माघारे येतील. कारण अमोरी लोकांचा अन्याय अद्याप त्याच्या मर्यादेपर्यंत पोहोचलेला नाही.” ");
INSERT INTO mar_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","सूर्य मावळल्यानंतर गडद अंधार पडला; मारलेल्या जनावरांच्या तेथेच पडलेल्या त्या तुकड्यांमधून धुराची अग्नीज्वाला आणि अग्नीची ज्योती गेली. ");
INSERT INTO mar_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","त्या दिवशी परमेश्वराने अब्रामाशी करार केला. तो म्हणाला, “मिसर देशाच्या नदीपासून फरात महानदीपर्यंतचा ");
INSERT INTO mar_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","केनी, कनिज्जी, कदमोनी, ");
INSERT INTO mar_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परिज्जी, रेफाईम, ");
INSERT INTO mar_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","अमोरी, कनानी, गिर्गाशी व यबूसी यांचा देश मी तुझ्या संतानाला देतो.” ");
INSERT INTO mar_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्रामाला आपली पत्नी साराय हिच्यापासून मूल झाले नाही, परंतु तिची एक मिसरी दासी होती, जिचे नाव हागार होते. ");
INSERT INTO mar_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","साराय अब्रामाला म्हणाली, “परमेश्वराने मला मुले होण्यापासून वंचित ठेवले आहे. तेव्हा तुम्ही माझ्या दासीपाशी जा. कदाचित तिच्यापासून मला मुले मिळतील.” अब्रामाने आपली पत्नी साराय हिचे म्हणणे मान्य केले. ");
INSERT INTO mar_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","अब्राम कनान देशात दहा वर्षे राहिल्यानंतर, अब्रामाची पत्नी साराय हिने आपली मिसरी दासी हागार ही, आपला पती अब्राम याला पत्नी म्हणून दिली. ");
INSERT INTO mar_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","त्याने हागार सोबत शरीरसंबंध केले, आणि अब्रामापासून ती गरोदर राहिली. आणि जेव्हा तिने पाहिले की आपण गरोदर आहोत, तेव्हा ती आपल्या मालकीणीकडे तिरस्काराने पाहू लागली. ");
INSERT INTO mar_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","नंतर साराय अब्रामाला म्हणाली, “माझ्यावरचा अन्याय तुमच्यावर असो. मी आपली दासी तुम्हास दिली, आणि आपण गरोदर आहो हे लक्षात आल्यावर, मी तिच्या दृष्टीने तुच्छ झाले. परमेश्वर तुमच्यामध्ये व माझ्यामध्ये न्याय करो.” ");
INSERT INTO mar_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","परंतु अब्राम सारायला म्हणाला, “तू हागारेची मालकीण आहेस, तुला काय पाहिजे तसे तू तिचे कर.” तेव्हा साराय तिच्याबरोबर निष्ठुरपणे वागू लागली म्हणून हागार तिला सोडून पळून गेली. ");
INSERT INTO mar_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","शूर गावाच्या वाटेवर वाळवंटातील एका पाण्याच्या झऱ्याजवळ हागार परमेश्वराच्या एका देवदूताला आढळली. ");
INSERT INTO mar_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","देवदूत तिला म्हणाला, “सारायचे दासी हागारे, तू येथे का आलीस? तू कोठे जात आहेस?” हागार म्हणाली, “माझी मालकीण साराय हिच्यापासून मी पळून जात आहे.” ");
INSERT INTO mar_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","परमेश्वराचा दूत तिला म्हणाला, “तू आपल्या मालकिणीकडे परत जा आणि तिच्या अधिकारात तिच्या अधीनतेत राहा.” ");
INSERT INTO mar_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","परमेश्वराचा दूत तिला आणखी म्हणाला, “तुझी संतती मी इतकी बहुगुणित करीन, की ती मोजणे शक्य होणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","परमेश्वराचा दूत तिला असे सुद्धा म्हणाला, “तू आता गरोदर आहेस आणि तुला मुलगा होईल त्याचे नाव तू इश्माएल म्हणजे परमेश्वर ऐकतो असे ठेव, कारण प्रभूने तुझ्या दुःखाविषयी ऐकले आहे. ");
INSERT INTO mar_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","इश्माएल जंगली गाढवासारखा मनुष्य असेल. तो सर्वांविरूद्ध असेल आणि सर्व लोक त्याच्या विरूद्ध असतील, आणि तो एका ठिकाणाहून दुसऱ्या ठिकाणी आपल्या भावांच्यापासून वेगळा राहील.” ");
INSERT INTO mar_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","नंतर तिच्याशी बोलणारा जो परमेश्वर त्याचे नाव, “तू पाहणारा देव आहेस,” असे तिने ठेवले, कारण ती म्हणाली, “जो मला पाहतो त्यास मी येथेही मागून पाहिले काय?” ");
INSERT INTO mar_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","तेव्हा तेथील विहिरीला बैर-लहाय-रोई असे नाव पडले; पाहा, ती कादेश व बेरेद यांच्या दरम्यान आहे. ");
INSERT INTO mar_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हागारेने अब्रामाच्या पुत्राला जन्म दिला, आणि ज्याला हगारेने जन्म दिला त्या त्याच्या पुत्राचे नाव अब्रामाने इश्माएल ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","हागारेला अब्रामापासून इश्माएल झाला तेव्हा अब्राम शहाऐंशी वर्षांचा होता. ");
INSERT INTO mar_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","अब्राम नव्याण्णव वर्षांचा झाला तेव्हा परमेश्वराने त्यास दर्शन दिले व त्यास म्हटले, “मी सर्वशक्तिमान देव आहे. माझ्या समक्षतेत चाल, आणि सात्त्विकतेने राहा. ");
INSERT INTO mar_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","तू असे करशील, तर मी माझ्यामध्ये व तुझ्यामध्ये एक करार करीन, आणि मी तुला अनेक पटींनी वाढवीन असे अभिवचन देतो.” ");
INSERT INTO mar_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","मग अब्रामाने देवास लवून नमन केले आणि देव त्यास म्हणाला, ");
INSERT INTO mar_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“पाहा, तुझ्यासोबत माझा करार असा आहे: तू अनेक राष्ट्रांचा महान पिता होशील. ");
INSERT INTO mar_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","येथून पुढे तुझे नाव अब्राम असणार नाही, तर तुझे नाव अब्राहाम असे होईल. कारण मी तुला अनेक राष्ट्रांचा पिता असे नेमले आहे. ");
INSERT INTO mar_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","मी तुला भरपूर संतती देईन, आणि मी तुझ्यापासून नवीन राष्ट्रे उदयास आणीन, आणि तुझ्यापासून राजे उत्पन्न होतील. ");
INSERT INTO mar_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","मी तुझ्यामध्ये आणि माझ्यामध्ये आणि तुझ्या वंशजांमध्येही पिढ्यानपिढ्या कायम लागू राहील असा सनातन करार करीन, तो असा की, मी तुझा आणि तुझ्यानंतर तुझ्या वंशजांचा देव होईन. ");
INSERT INTO mar_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ज्या प्रदेशामध्ये तू राहत आहेस तो, म्हणजे कनान देश, मी तुला व तुझ्या वंशजांना कायमचे वतन म्हणून देईन, आणि मी तुमचा देव होईन.” ");
INSERT INTO mar_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","नंतर देव अब्राहामाला पुढे म्हणाला, “आता या करारातील तुझा भाग हा असा, तू माझा करार पाळावा, तू आणि तुझ्या मागे तुझ्या वंशजांनी पिढ्यानपिढ्या पाळावयाचा माझा करार पाळावा. ");
INSERT INTO mar_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","माझा करार जो, तू आणि तुझ्या मागे तुझ्या संतानाने पाळायचा तो हा की: तुमच्यातील प्रत्येक पुरुषांची सुंता व्हावी. ");
INSERT INTO mar_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","माझ्यामध्ये आणि तुझ्यामध्ये असलेला करार हा, तुम्ही आपली सुंता करून घ्यावी. ");
INSERT INTO mar_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","पिढ्यानपिढ्या तुमच्यातील प्रत्येक पुरुषाची त्याच्या जन्मानंतर आठ दिवसानी सुंता करावी. मग तो पुरुष तुझ्या कुटुंबात जन्मलेला असो किंवा तो तुझ्या वंशातला नसून परक्यापासून पैसा देऊन घेतलेला असो. ");
INSERT INTO mar_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","अशा रीतीने तुझ्या राष्ट्रात जन्मलेल्या प्रत्येक पुरुषांची सुंता करावी, मग तो तुझ्या कुटुंबातील असो किंवा विकत घेतलेल्या गुलामाच्या कुटुंबात जन्मलेला असो; तुझ्या व माझ्यामध्ये केलेला करार या खुणेवरून कायम राहील. ");
INSERT INTO mar_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ज्या कोणाची सुंता झाली नाही अशा पुरुषाला त्याच्या लोकांतून बाहेर टाकावे; कारण त्याने माझा करार मोडला आहे.” ");
INSERT INTO mar_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","देव अब्राहामाला म्हणाला, “तुझी पत्नी साराय, हिला येथून पुढे साराय असे संबोधू नको. त्या ऐवजी तिचे नाव सारा असे होईल. ");
INSERT INTO mar_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","मी तिला आशीर्वादित करीन, आणि मी तुला तिच्यापासून मुलगा देईन. मी तिला आशीर्वादीत करीन, आणि ती अनेक राष्ट्रांची माता होईल. लोकांचे राजे तिच्यापासून निपजतील.” ");
INSERT INTO mar_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","अब्राहामाने देवाला लवून नमन केले आणि तो हसला, तो मनात म्हणाला, “शंभर वर्षांच्या मनुष्यास मुलगा होणे शक्य आहे का? आणि सारा, जी नव्वद वर्षांची आहे, तिला मुलगा होऊ शकेल का?” ");
INSERT INTO mar_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","अब्राहाम देवाला म्हणाला, “इश्माएल तुझ्या समोर जगावा तेवढे पुरे!” ");
INSERT INTO mar_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","देव म्हणाला, “नाही! परंतु तुझी पत्नी सारा हिलाच मुलगा होईल, आणि त्याचे नाव तू इसहाक असे ठेव. मी त्याच्याशी निरंतरचा करार करीन; तो करार त्याच्यानंतर त्याच्या वंशजांसोबत निरंतर असेल. ");
INSERT INTO mar_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","तू मला इश्माएलविषयी विचारलेस ते मी ऐकले आहे. पाहा, मी आतापासून पुढे त्यास आशीर्वाद देईन, आणि त्यास फलद्रुप करीन आणि त्यास बहुगुणित करीन. तो बारा सरदारांच्या वंशांचा पिता होईल, आणि मी त्यास एक मोठे राष्ट्र करीन. ");
INSERT INTO mar_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","परंतु मी इसहाकाबरोबर माझा करार स्थापीन, ज्याला सारा पुढल्या वर्षी याच वेळी जन्म देईल.” ");
INSERT INTO mar_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","देवाने त्याच्याशी बोलणे संपवल्यावर, देव अब्राहामापासून वर गेला. ");
INSERT INTO mar_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","त्यानंतर अब्राहामाने त्याचा मुलगा इश्माएल आणि त्याच्या घराण्यात जन्मलेले आणि जे सर्व मोल देऊन विकत घेतलेले अशा सगळ्या पुरुषांना एकत्र केले, आणि देवाने सांगितल्याप्रमाणेच त्याच्या घरातील सर्व पुरुषांची त्या एकाच दिवशी सुंता केली. ");
INSERT INTO mar_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","अब्राहाम नव्याण्णव वर्षांचा होता तेव्हा त्याची सुंता झाली. ");
INSERT INTO mar_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","आणि त्याचा मुलगा इश्माएल तेरा वर्षांचा होता तेव्हा त्याची सुंता झाली. ");
INSERT INTO mar_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहाम आणि त्याचा मुलगा इश्माएल या दोघांची एकाच दिवशी सुंता झाली. ");
INSERT INTO mar_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","त्याच्या घरी जन्मलेले व त्याने विकत घेतलेले असे त्याच्या घरचे सगळे पुरुष यांचीही त्याच्या बरोबर सुंता झाली. ");
INSERT INTO mar_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","परमेश्वराने मम्रेच्या एलोन झाडांजवळ अब्राहामाला दर्शन दिले, तेव्हा तो दुपारच्या उन्हाच्या वेळी तंबूच्या दाराशी बसला होता. ");
INSERT INTO mar_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","त्याने वर पाहिले आणि, पाहा, आपल्यासमोर तीन पुरुष उभे असलेले त्याने पाहिले. अब्राहामाने जेव्हा त्यांना पाहिले, तेव्हा तो त्यांना भेटण्यासाठी तंबूच्या दारापासून पळत गेला आणि त्याने त्यांना जमिनीपर्यंत खाली वाकून नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","तो म्हणाला, “प्रभू, जर माझ्यावर तुमची कृपादृष्टी असेल तर तुझ्या सेवकाला सोडून पुढे जाऊ नका. ");
INSERT INTO mar_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","थोडे पाणी आणू द्या, तुमचे पाय धुवा, आणि तुम्ही झाडा खाली आराम करा. ");
INSERT INTO mar_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","मी तुमच्यासाठी थोडे अन्न आणतो, जेणेकरून तुम्हास ताजेतवाने वाटेल. मग तुम्ही तुमच्या मार्गाने जा, यासाठीच तुमच्या या सेवकाकडे तुमचे येणे झाले असावे.” आणि ते म्हणाले, “तू म्हणतोस तसे कर.” ");
INSERT INTO mar_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","अब्राहाम पटकन तंबूत सारेकडे गेला आणि म्हणाला, “लवकर तीन मापे सपीठ घेऊन ते मळ आणि भाकरी कर.” ");
INSERT INTO mar_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","नंतर अब्राहाम गुरांच्या कळपाकडे पळत गेला आणि त्यातून त्याने कोवळे आणि चांगले वासरू घेतले आणि सेवकाजवळ देऊन त्याने त्यास ते लवकर तयार करण्यास सांगितले. ");
INSERT INTO mar_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","त्याने तयार केलेले वासरू, तसेच दूध व लोणी त्यांच्यापुढे खाण्यासाठी ठेवले आणि ते जेवत असता तो झाडाखाली त्यांच्याजवळ उभा राहिला. ");
INSERT INTO mar_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ते त्यास म्हणाले, “तुझी पत्नी सारा कोठे आहे?” त्याने उत्तर दिले, “तेथे ती तंबूत आहे.” ");
INSERT INTO mar_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","त्यांच्यातील एक म्हणाला, “मी वसंतऋतूच्या वेळी तुझ्याकडे नक्की परत येईन, आणि पाहा तेव्हा तुझी पत्नी सारा हिला मुलगा होईल.” तेव्हा त्याच्यामागे असलेल्या तंबूच्या दारामागून सारेने हे ऐकले. ");
INSERT INTO mar_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","आता अब्राहाम व सारा म्हातारे झाले होते, त्यांचे वय बरेच झाले होते, आणि स्त्रीला ज्या वयात मुले होऊ शकतात, ते साराचे वय निघून गेले होते. ");
INSERT INTO mar_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","म्हणून सारा स्वतःशीच हसून म्हणाली, “मी म्हातारी झाली आहे, आणि माझा पतीही म्हातारा झाला आहे, आता मला ते सुख लाभेल काय?” ");
INSERT INTO mar_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","परमेश्वर अब्राहामाला म्हणाला, “सारा का हसली? मी आता इतकी म्हातारी झाली असताना मला मुलगा होईल काय, असे ती का म्हणाली? ");
INSERT INTO mar_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","परमेश्वरास काही अशक्य आहे काय? येत्या वसंतऋमध्ये, सांगितल्याप्रमाणे मी पुन्हा येईन. पुढील वर्षी साधारण याच वेळी सारा हिला मुलगा होईल.” ");
INSERT INTO mar_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","नंतर सारा नाकारून म्हणाली, “मी हसले नाही,” कारण ती फार घाबरली होती. त्याने उत्तर दिले, “नाही, तू हसलीसच.” ");
INSERT INTO mar_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","नंतर ते पुरुष उठले व सदोम नगराकडे जाण्यास निघाले. अब्राहाम त्यांना वाटेस लावण्यासाठी त्यांच्या बरोबर गेला. ");
INSERT INTO mar_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","परमेश्वर देव म्हणाला, “मी जे काही करणार आहे ते अब्राहामापासून लपवू काय? ");
INSERT INTO mar_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","कारण अब्राहामापासून खरोखर एक महान व समर्थ राष्ट्र होईल, आणि पृथ्वीवरील सगळी राष्ट्रे त्याच्यामुळे आशीर्वादित होतील. ");
INSERT INTO mar_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","मी त्यास यासाठी निवडले आहे की, त्याने आपल्या मुलांना व कुटुंबाला अशी शिकवण द्यावी की, त्यांनी त्याच्यामागे न्यायीपणाने व धार्मिकतेने परमेश्वराचा मार्ग अनुसरावा, म्हणजे मग परमेश्वराने अब्राहामाविषयी जे सांगितले आहे ते तो त्यास प्राप्त करून द्यावे.” ");
INSERT INTO mar_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","मग परमेश्वर म्हणाला, “सदोम व गमोरा यांच्या दुष्टाईचा आक्रोश मोठा आहे, आणि त्यांचे पाप फार गंभीर असल्या कारणाने, ");
INSERT INTO mar_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","मी आता तेथे खाली जाईन आणि त्यांच्या पातकाचा जो बोभाटा माझ्या कानी आला आहे त्याप्रमाणेच त्यांची करणी आहे का हे पाहीन. तसे नसेल तर मला समजेल.” ");
INSERT INTO mar_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","मग ती माणसे तेथून वळून आणि सदोम नगराकडे गेली, परंतु अब्राहाम परमेश्वरापुढे तसाच उभा राहिला. ");
INSERT INTO mar_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","मग अब्राहाम परमेश्वराजवळ जाऊन म्हणाला, “तू दुष्टाबरोबर नीतिमानांचाही नाश करशील काय? ");
INSERT INTO mar_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","कदाचित त्या नगरात पन्नास नीतिमान लोक असतील तर त्या नगराचा तू नाश करणार काय? तू त्या नगरात राहणाऱ्या पन्नास नीतिमान लोकांसाठी नगराचा बचाव करणार नाहीस काय? ");
INSERT INTO mar_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","असे करणे तुझ्यापासून दूर असो. दुष्टाबरोबर नीतिमानाला मारणे म्हणजे नीतिमानाला दुष्टासारखे वागवणे हे तुझ्यापासून दूर असो! जो तू संपूर्ण पृथ्वीचा न्यायाधीश आहेस, तो तू योग्य न्याय करणार नाहीस काय?” ");
INSERT INTO mar_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","परमेश्वर म्हणाला, “या सदोम शहरात मला पन्नास नीतिमान लोक सापडले तरीही त्यांच्यासाठी मी संपूर्ण स्थळाचा बचाव करीन.” ");
INSERT INTO mar_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","अब्राहामाने उत्तर देऊन म्हटले, “पाहा मी केवळ धूळ व राख आहे, तरी प्रभूजवळ बोलायला धजतो! ");
INSERT INTO mar_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","समजा जर पाच लोक कमी असतील म्हणजे फक्त पंचेचाळीसच चांगले लोक असतील तर? त्या पाच कमी असलेल्या लोकांकरता तू सर्व नगराचा नाश करशील काय?” आणि तो म्हणाला, “मला पंचेचाळीस लोक चांगले आढळले तर मी नगराचा नाश करणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","पुन्हा तो परमेश्वरास म्हणाला, “आणि जर तेथे तुला चाळीसच चांगले लोक आढळले तर? संपूर्ण शहराचा तू नाश करशील काय?” परमेश्वर म्हणाला, “जर मला चाळीसच लोक चांगले आढळले तरीही, मी शहराचा नाश करणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","तो म्हणाला, “प्रभू, कृपा करून तुला राग न यावा म्हणजे मी बोलेन. तेथे फक्त तीसच मिळाले तर?” परमेश्वर म्हणाला, “जर तीस चांगले लोक असतील तरीही मी तसे करणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","तो म्हणाला, “मी प्रभूशी बोलायला धजतो! समजा तेथे कदचित वीसच मिळाले तर?” परमेश्वराने उत्तर दिले, “त्या वीसांकरताही मी नगराचा नाश करणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","शेवटी तो म्हणाला, “प्रभू, कृपा करून माझ्यावर रागावू नकोस, मी शेवटी एकदाच बोलतो. कदाचित तुला तेथे दहाच लोक मिळाले तर?” परमेश्वर म्हणाला, “त्या दहांकरताही मी नगराचा नाश करणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","मग परमेश्वराने अब्राहामाशी बोलणे संपविल्याबरोबर तो लगेच निघून गेला, आणि अब्राहाम आपल्या तंबूकडे परत आला. ");
INSERT INTO mar_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","संध्याकाळी ते दोन देवदूत सदोमास आले, त्या वेळी लोट सदोमाच्या वेशीजवळ बसला होता. लोटाने त्यांना पाहिले, तो त्यांना भेटण्यास उठला, आणि त्याने भूमीपर्यंत तोंड लववून त्यांना नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","तो म्हणाला, “माझ्या स्वामी, मी तुम्हास विनंती करतो की, कृपा करून तुम्ही आपल्या सेवकाच्या घरात या, आपले पाय धुवा, आणि आजची रात्र मुक्काम करा.” मग तुम्ही लवकर उठून तुमच्या मार्गाने जा. पण ते म्हणाले, “नाही, आम्ही रात्र नगरातील चौकात घालवू.” ");
INSERT INTO mar_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","परंतु लोटाने त्यांना आग्रहाने विनंती केली, म्हणून ते त्याच्याबरोबर त्याच्या घरी गेले. त्याने त्यांच्यासाठी जेवण तयार केले व बेखमीर भाकरी भाजल्या आणि ते जेवले. ");
INSERT INTO mar_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","परंतु ते झोपण्यापूर्वी, त्या नगरातील मनुष्यांनी, सदोम नगराच्या सर्व भागातील तरुण व वृद्ध अशा सर्व माणसांनी लोटाच्या घराला वेढले. ");
INSERT INTO mar_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","त्यांनी लोटाला हाक मारून म्हटले “आज रात्री तुझ्याकडे आलेली माणसे कोठे आहेत? त्यांना आमच्याकडे बाहेर आण; म्हणजे आम्ही त्यांच्याशी समागम करू.” ");
INSERT INTO mar_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","लोट घराच्या दारातून बाहेर त्यांच्याकडे आला व त्याने आपल्यामागे दार बंद करून घेतले. ");
INSERT INTO mar_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","तो म्हणाला, “माझ्या बंधूनो, मी तुम्हास विनंती करतो, तुम्ही असे भयंकर वाईट काम करू नका. ");
INSERT INTO mar_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","पाहा, माझ्या दोन मुली आहेत ज्यांचा अद्याप कोणाही पुरुषाशी संबंध आला नाही. मी तुम्हास विनंती करतो, मला त्यांना तुमच्याकडे बाहेर आणू द्या, आणि तुम्हास जे चांगले दिसेल तसे त्यांना करा. फक्त या मनुष्यांना काही करू नका, कारण ते माझ्या छपराच्या सावलीखाली राहण्यास आले आहेत.” ");
INSERT INTO mar_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ते म्हणाले, “बाजूला हो!” ते असेही म्हणाले, “हा आमच्यात परराष्ट्रीय म्हणून राहण्यास आला. आणि आता हा आमचा न्यायाधीश बनू पाहत आहे! आता आम्ही तुझे त्यांच्यापेक्षा वाईट करू.” ते त्या मनुष्यास म्हणजे लोटाला अधिक जोराने लोटू लागले व दरवाजा तोडण्यास ते जवळ आले. ");
INSERT INTO mar_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","परंतु त्या पुरुषांनी त्यांचा हात बाहेर काढून लोटाला आपणाजवळ घरात घेऊन दार बंद केले. ");
INSERT INTO mar_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","लोटाच्या पाहुण्यांनी घराच्या दाराबाहेर जी सर्व तरुण व म्हातारी माणसे होती, त्यांना आंधळे करून टाकले. ते घराचे दार शोधण्याचा प्रयत्न करून करून थकून गेले. ");
INSERT INTO mar_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","मग ते पुरुष लोटाला म्हणाले, “तुझे दुसरे कोणी येथे आहे काय? जावई, तुझी मुले, तुझ्या मुली आणि तुझे जे कोणी या नगरात आहेत त्यांना येथून बाहेर काढ. ");
INSERT INTO mar_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","यासाठी की, आम्ही या ठिकाणाचा नाश करणार आहोत. कारण या लोकांच्या दुष्टतेचा फार मोठा बोभाटा परमेश्वरासमोर झाला आहे, म्हणून त्याने आम्हांला या नगराचा नाश करण्यासाठी पाठवले आहे.” ");
INSERT INTO mar_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","मग लोट बाहेर गेला व ज्या मनुष्यांनी त्याच्या मुलींशी लग्न केले होते त्या आपल्या जावायांना तो म्हणाला, “उठा, तुम्ही, लवकर या ठिकाणातून बाहेर पडा; कारण परमेश्वर देव या नगराचा नाश करणार आहे.” परंतु लोट गंमत करत आहे असे त्याच्या जावयांना वाटले. ");
INSERT INTO mar_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","मग पहाट झाल्यावर दूत लोटाला घाई करून म्हणाले, “ऊठ, या नगराला शिक्षा होणार आहे; तेव्हा तू, तुझी पत्नी व तुझ्या येथे असलेल्या दोन मुली यांना घेऊन नीघ म्हणजे मग या नगराच्या शिक्षेत तुमचा नाश होणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","परंतु तो उशीर करीत राहिला. तेव्हा परमेश्वराची त्याच्यावर कृपा होती, म्हणून त्या पुरुषांनी त्याचा हात आणि त्याच्या पत्नीचा आणि त्याच्या दोन मुलींचे हात धरून त्यांना बाहेर आणले आणि नगराबाहेर आणून सोडले. ");
INSERT INTO mar_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","त्यांनी त्यांना बाहेर आणल्यावर त्यातील एक पुरुष म्हणाला, “आता पळा व तुमचे जीव वाचवा, नगराकडे मागे वळून पाहू नका आणि या मैदानात कोणत्याही ठिकाणी थांबू नका; डोंगराकडे निसटून जा म्हणजे तुमचा नाश होणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","लोट त्यांना म्हणाला, “हे माझ्या प्रभू, असे नको, कृपा कर! ");
INSERT INTO mar_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","माझा जीव वाचवून तू माझ्यावर मोठी दया दाखवली आहेस आणि तुझी कृपादृष्टी तुझ्या दासास प्राप्त झाली आहे, परंतु मी डोंगरापर्यंत पळून जाऊ शकणार नाही, कारण आपत्ती मला गाठेल व मी मरून जाईन. ");
INSERT INTO mar_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","पाहा, पळून जाण्यासाठी हे नगर जवळ आहे, आणि ते लहान आहे, कृपा करून मला तिकडे पळून जाऊ दे, ते लहान नाही काय? म्हणजे माझा जीव वाचेल.” ");
INSERT INTO mar_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","तो त्यास म्हणाला, “ठीक आहे, मी तुझी ही विनंतीसुद्धा मान्य करतो. तू उल्लेख केलेल्या नगराचा नाश मी करणार नाही. ");
INSERT INTO mar_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","त्वरा कर! तिकडे पळून जा, कारण तू तेथे पोहचेपर्यंत मला काही करता येणार नाही.” यावरुन त्या नगराला सोअर असे नाव पडले. ");
INSERT INTO mar_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","जेव्हा लोट सोअर नगरामध्ये पोहचला तेव्हा सूर्य उगवला होता, ");
INSERT INTO mar_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","नंतर परमेश्वराने सदोम व गमोरा या नगरांवर आकाशातून गंधक व अग्नी यांचा वर्षाव केला. ");
INSERT INTO mar_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","त्याने त्या नगरांचा नाश केला, तसेच त्या सगळ्या खोऱ्याचा आणि त्या नगरात राहणाऱ्या सगळ्यांचा, आणि जमिनीवर वाढणाऱ्या वनस्पतींचा नाश केला. ");
INSERT INTO mar_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","परंतु लोटाची पत्नी त्याच्यामागे होती, तिने मागे वळून पाहिले, आणि ती मिठाचा खांब झाली. ");
INSERT INTO mar_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","अब्राहाम सकाळी लवकर उठला आणि परमेश्वरासमोर तो ज्या ठिकाणी उभा राहिला होता तेथे गेला. ");
INSERT INTO mar_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","त्याने तेथून सदोम व गमोरा नगराकडे आणि खोऱ्यातील सर्व प्रदेशाकडे पाहिले. त्याने पाहिले तेव्हा पाहा, त्या अवघ्या प्रदेशातून भट्टीच्या धुरासारखा धूर त्या प्रदेशातून वर चढताना त्यास दिसला. ");
INSERT INTO mar_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","देवाने जेव्हा त्या खोऱ्यातील नगरांचा नाश केला तेव्हा अब्राहामाची आठवण केली. त्याने लोट राहत होता त्या नगरांचा नाश करण्यापूर्वी लोटाला त्या नाशातून काढले. ");
INSERT INTO mar_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","परंतु लोट त्याच्या दोन मुलींबरोबर सोअर नगरातून निघून डोंगरात राहण्यासाठी चढून गेला, कारण त्यास सोअरात राहण्याची भीती वाटली. तो आपल्या दोन मुलींसह एका गुहेत राहिला. ");
INSERT INTO mar_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","थोरली मुलगी धाकटीला म्हणाली, “आपला पिता म्हातारा झाला आहे आणि जगाच्या रीतीप्रमाणे आपल्याबरोबर संबंध ठेवण्यास येथे कोठेही कोणी पुरुष नाही. ");
INSERT INTO mar_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","चल, आपल्या पित्याला द्राक्षरस पाजू, आणि त्याच्याबरोबर झोपू. अशा रीतीने आपल्या पित्याचा आपण वंश चालवू.” ");
INSERT INTO mar_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","म्हणून, त्या रात्री त्यांनी आपल्या पित्याला द्राक्षरस पाजला. नंतर थोरली मुलगी आपल्या पित्याबरोबर झोपली; ती कधी झोपली व कधी उठली हे त्यास समजले नाही. ");
INSERT INTO mar_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","दुसऱ्या दिवशी थोरली धाकटीला म्हणाली, “मी काल रात्री माझ्या बापाबरोबर झोपले, तर आज रात्री पुन्हा आपण बापाला द्राक्षरस पाजू या, मग रात्री तू बापाबरोबर झोप. अशा रीतीने आपण बापाचा वंश चालवू.” ");
INSERT INTO mar_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","तेव्हा त्या रात्रीही त्यांनी आपल्या बापाला द्राक्षरस पाजला, नंतर धाकटी मुलगी आपल्या बापाबरोबर झोपली, आणि ती कधी झोपली व कधी उठली हे त्यास समजले नाही. ");
INSERT INTO mar_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","अशा रीतीने लोटाच्या दोन्हीही मुली आपल्या बापापासून गरोदर राहिल्या. ");
INSERT INTO mar_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","वडील मुलीला मुलगा झाला, तेव्हा तिने त्याचे नाव मवाब ठेवले. आजपर्यंत जे मवाबी लोक आहेत, त्यांचा हा मूळ पुरुष. ");
INSERT INTO mar_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","धाकट्या मुलीलाही मुलगा झाला; तिने त्याचे नाव बेनअम्मी असे ठेवले; आजमितीला जे अम्मोनी लोक त्यांचा हा मूळ पुरुष. ");
INSERT INTO mar_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","अब्राहाम तेथून नेगेबकडे प्रवास करीत आणि कादेश व शूर यांच्यामध्ये राहिला. तो गरारात परदेशी मनुष्य म्हणून राहिला होता. ");
INSERT INTO mar_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","अब्राहाम आपली पत्नी सारा हिच्याविषयी म्हणाला, “ती माझी बहीण आहे.” गराराचा राजा अबीमलेखाने आपली माणसे पाठवली आणि ते सारेला घेऊन गेले. ");
INSERT INTO mar_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","परंतु देव रात्री अबीमलेखाच्या स्वप्नात येऊन म्हणाला, “पाहा जी स्त्री तू घेऊन आलास तिच्यामुळे तू मेलाच म्हणून असे समज, कारण ती एका मनुष्याची पत्नी आहे.” ");
INSERT INTO mar_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","परंतु अबीमलेख तिच्याजवळ गेला नव्हता. तो म्हणाला, “प्रभू, तू नीतिमान राष्ट्राचाही नाश करणार काय? ");
INSERT INTO mar_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‘ती माझी बहीण आहे,’ असे तो स्वतःच मला म्हणाला नाही काय? आणि ‘तो माझा भाऊ आहे,’ असे तिनेही म्हटले. मी आपल्या अंतःकरणाच्या शुद्धपणाने आणि आपल्या हाताच्या निर्दोषतेने हे केले आहे.” ");
INSERT INTO mar_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","मग देव त्यास स्वप्नात म्हणाला, “होय! तू आपल्या अंतःकरणाच्या शुद्धतेने हे केले आहेस हे मला माहीत आहे, आणि तू माझ्याविरूद्ध पाप करू नये म्हणून मी तुला आवरले. मीच तुला तिला स्पर्श करू दिला नाही. ");
INSERT INTO mar_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","म्हणून आता तू अब्राहामाची पत्नी सारा ही त्यास परत दे; कारण तो संदेष्टा आहे; तो तुझ्यासाठी प्रार्थना करील व तू वाचशील. परंतु तू तिला त्याच्याकडे परत पाठवले नाहीस, तर तू आणि तुझ्या बरोबर जे सर्व तुझे आहेत ते खात्रीने मरतील, हे लक्षात ठेव.” ");
INSERT INTO mar_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","अबीमलेख सकाळीच लवकर उठला आणि त्याने आपल्या सर्व सेवकांना स्वतःकडे बोलावले. त्याने सगळ्या गोष्टी त्यांना सांगितल्या तेव्हा ती माणसे फारच घाबरली. ");
INSERT INTO mar_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","मग अबीमलेखाने अब्राहामास बोलावून त्यास म्हटले, “तू हे आम्हांला काय केले? मी तुझ्याविरूद्ध काय पाप केले की तू माझ्यावर आणि माझ्या राष्ट्रावर असे मोठे पाप आणले? तू माझ्याशी करू नये ते केले आहे अशा गोष्टी तू करायच्या नव्हत्या.” ");
INSERT INTO mar_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","अबीमलेख अब्राहामाला म्हणाला, “तुला हे करण्यास कोणी सुचवले?” ");
INSERT INTO mar_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहाम म्हणाला, “या ठिकाणी देवाचे भय खात्रीने नाही, म्हणून ते माझ्या पत्नीकरीता मला ठार मारतील, असा विचार मी केला. ");
INSERT INTO mar_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","शिवाय ती खरोखर माझी बहीण आहे. ती माझ्या बापाची मुलगी आहे, पण माझ्या आईची ती मुलगी नाही आणि म्हणून ती माझी पत्नी झाली आहे. ");
INSERT INTO mar_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","देवाने मला माझ्या बापाचे घर सोडून देऊन जागोजागी प्रवास करायला लावले, तेव्हा मी तिला म्हणालो, तू माझी पत्नी म्हणून मला एवढा विश्वासूपणा दाखव; जेथे जेथे आपण जाऊ तेथे तेथे माझ्याविषयी हा, ‘माझा भाऊ आहे असे सांग.’” ");
INSERT INTO mar_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","अबीमलेखाने अब्राहामाला सारा परत दिली; तसेच त्याने त्यास मेंढरे, बैल व दास-दासीही दिल्या. ");
INSERT INTO mar_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","अबीमलेख म्हणाला, “पाहा, माझा हा सर्व देश तुझ्यासमोर आहे; तुला बरे वाटेल तेथे तू राहा.” ");
INSERT INTO mar_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","तो सारेला म्हणाला, “तुझा भाऊ अब्राहाम याला मी चांदीची एक हजार नाणी दिली आहेत. तुझ्यासोबत असलेल्या सर्व लोकांसमोर तुझी भरपाई करण्यासाठी ते आहेत, आणि या प्रकारे तू सर्वांसमोर पूर्णपणे निर्दोष ठरली आहेस.” ");
INSERT INTO mar_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","अब्राहामाने देवाची प्रार्थना केली आणि देवाने अबीमलेख, त्याची पत्नी आणि त्याच्या दासी यांना बरे केले. मग त्यांना मुले होऊ लागली. ");
INSERT INTO mar_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","कारण परमेश्वराने अब्राहामाची पत्नी सारा हिच्यामुळे अबीमलेखाच्या घराण्यातल्या सर्व स्त्रियांची गर्भाशये अगदी बंद केली होती. ");
INSERT INTO mar_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","परमेश्वराने आपल्या म्हणण्याप्रमाणे सारेकडे लक्ष दिले, आणि परमेश्वराने सारेला वचन दिल्याप्रमाणे केले. ");
INSERT INTO mar_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","अब्राहामाच्या म्हातारपणी सारा गरोदर राहिली, त्यास जी नेमलेली वेळी देवाने सांगितली होती त्या वेळी त्याच्यापासून सारेला मुलगा झाला. ");
INSERT INTO mar_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहामाला जो मुलगा सारेपासून झाला त्याचे नाव त्याने इसहाक ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","देवाने आज्ञा केल्याप्रमाणे अब्राहामाने त्याचा मुलगा इसहाक आठ दिवसाचा झाल्यावर त्याची सुंता केली. ");
INSERT INTO mar_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","इसहाकाचा जन्म झाला तेव्हा अब्राहाम शंभर वर्षांचा होता. ");
INSERT INTO mar_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","सारा म्हणाली, “देवाने मला हसवले आहे; जो कोणी हे ऐकेल तो प्रत्येकजण माझ्याबरोबर हसेल.” ");
INSERT INTO mar_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","आणखी ती असेही म्हणाली, “सारा या मुलाला स्तनपान देईल असे अब्राहामाला कोण म्हणाला असता? आणि तरीसुद्धा त्याच्या म्हातारपणात मला त्याच्यापासून मुलगा झाला आहे!” ");
INSERT INTO mar_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","मग बालक वाढत गेला आणि त्याचे स्तनपान तोडले, आणि इसहाकाच्या स्तनपान तोडण्याच्या दिवशी अब्राहामाने मोठी मेजवानी दिली. ");
INSERT INTO mar_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","मग साराची मिसरी दासी हागार हिचा मुलगा इश्माएल जो तिला अब्राहामापासून झाला होता, तो चेष्टा करीत आहे असे सारेने पाहिले. ");
INSERT INTO mar_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","म्हणून सारा अब्राहामाला म्हणाली, “या दासीला व तिच्या मुलाला येथून बाहेर घालवून द्या. या दासीचा मुलगा, माझा मुलगा इसहाक याच्याबरोबर वारस होणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","त्याच्या मुलामुळे या गोष्टीचे अब्राहामाला फार दुःख झाले. ");
INSERT INTO mar_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","परंतु देव अब्राहामाला म्हणाला, “मुलाकरता व तुझ्या दासी करता दुःखी होऊ नकोस. तुला ती या बाबतीत जे काही सांगते, ते तिचे सर्व म्हणणे ऐक. कारण इसहाकाद्वारेच तुझ्या वंशाला नाव देण्यात येईल. ");
INSERT INTO mar_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","मी त्या दासीच्या मुलाचेही राष्ट्र करीन, कारण तो तुझा वंशज आहे.” ");
INSERT INTO mar_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","अब्राहाम सकाळीच लवकर उठला, भाकरी व पाण्याची कातडी पिशवी घेतली आणि हागारेला देऊन तिच्या खांद्यावर ठेवली. त्याने तिचा मुलगा तिला दिला आणि तिला पाठवून दिले. ती गेली आणि बैर-शेबाच्या रानामध्ये भटकत राहिली. ");
INSERT INTO mar_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","कातडी पिशवीतील पाणी संपले, तेव्हा हागारेने आपल्या मुलाला एका झुडपाखाली टाकले. ");
INSERT INTO mar_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","नंतर ती बरीच दूर म्हणजे बाणाच्या टप्प्याइतकी दूर जाऊन बसली, कारण तिने म्हटले “मला माझ्या मुलाचे मरण पाहायला नको.” ती त्याच्या समोर बसून मोठमोठ्याने हंबरडा फोडून रडू लागली. ");
INSERT INTO mar_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","देवाने मुलाच्या रडण्याचा आवाज ऐकला आणि देवाचा दूत स्वर्गातून हागारेला हाक मारून म्हणाला, “हागारे, तुला काय झाले? भिऊ नकोस, तुझा मुलगा जेथे आहे तेथून त्याचा आवाज देवाने ऐकला आहे ");
INSERT INTO mar_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ऊठ, मुलाला उचलून घे. आणि त्यास धैर्य दे, मी त्याच्यापासून एक मोठे राष्ट्र करीन.” ");
INSERT INTO mar_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","मग देवाने हागारेचे डोळे उघडले आणि तिने पाण्याची विहीर पाहिली. ती गेली आणि पाण्याची कातडी पिशवी भरून घेतली आणि मुलाला पाणी प्यायला दिले. ");
INSERT INTO mar_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","देव त्या मुलाबरोबर होता आणि तो वाढला. तो रानात राहिला आणि तिरंदाज बनला. ");
INSERT INTO mar_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","तो पारानाच्या रानात राहिला आणि त्याच्या आईने त्यास मिसर देशातील मुलगी पत्नी करून दिली. ");
INSERT INTO mar_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","त्यानंतर अबीमलेख व त्याचा सेनापती पिकोल यांनी अब्राहामाशी बोलणी केली, ते म्हणाले, “तू जे काही करतोस त्यामध्ये देव तुझ्याबरोबर आहे; ");
INSERT INTO mar_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","म्हणून आता येथे देवाची शपथ वाहा की, तू माझ्याशी व माझ्यामागे माझ्या मुलांशी किंवा माझ्या वंशजाशी खोटेपणाने वागणार नाहीस. जसा मी तुझ्याशी करार करून विश्वासूपणाने राहिलो, तसाच तू माझ्याशी व ज्या या माझ्या देशात तू राहिलास त्याच्याशी राहशील.” ");
INSERT INTO mar_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","आणि अब्राहाम म्हणाला, “मी शपथ वाहतो.” ");
INSERT INTO mar_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","मग अबीमलेखाच्या सेवकांनी पाण्याची विहीर बळकावली म्हणून अब्राहामाने अबीमलेखाकडे तक्रार केली. ");
INSERT INTO mar_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","अबीमलेख म्हणाला, “असे कोणी केले आहे ते मला माहीत नाही. ह्यापूर्वी तू हे मला कधीही सांगितले नाहीस. आजपर्यंत मी हे ऐकले नव्हते.” ");
INSERT INTO mar_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","म्हणून अब्राहामाने मेंढरे व बैल घेतले आणि अबीमलेखास दिले आणि त्या दोन मनुष्यांनी करार केला. ");
INSERT INTO mar_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहामाने अबीमलेखाला कळपातील सात कोकरे वेगळी करून त्यांच्यापुढे ठेवली. ");
INSERT INTO mar_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","अबीमलेख अब्राहामाला म्हणाला, “ही सात कोकरे तू वेगळी करून ठेवली याचा अर्थ काय आहे?” ");
INSERT INTO mar_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","त्याने उत्तर दिले, “तू ही कोकरे माझ्याकडून स्विकारशील तेव्हा ही विहीर मी खणली आहे असा तो पुरावा होईल.” ");
INSERT INTO mar_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","तेव्हा त्याने त्या जागेला बैर-शेबा असे नाव दिले, कारण त्या ठिकाणी त्या दोघांनी शपथ वाहून वचन दिले. ");
INSERT INTO mar_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","त्यांनी बैर-शेबा येथे करार केल्यानंतर अबीमलेख व त्याचा सेनापती पिकोल हे पलिष्ट्यांच्या देशात परत गेले. ");
INSERT INTO mar_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहामाने बैर-शेबा येथे एक एशेल झाड लावले. तेथे सनातन देव परमेश्वर याचे नाव घेऊन त्याने प्रार्थना केली. ");
INSERT INTO mar_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अब्राहाम पलिष्ट्यांच्या देशात पुष्कळ दिवस परदेशी म्हणून राहिला. ");
INSERT INTO mar_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","या गोष्टी झाल्यानंतर देवाने अब्राहामाची परीक्षा घेतली. तो अब्राहामाला म्हणाला, “अब्राहामा!” अब्राहाम म्हणाला, “हा मी येथे आहे.” ");
INSERT INTO mar_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","नंतर देव म्हणाला, “तुझा एकुलता एक प्रिय पुत्र, ज्याच्यावर तू प्रीती करतोस त्या इसहाकाला घेऊन तू मोरिया देशात जा आणि तेथे मी तुला सांगेन त्या डोंगरावर माझ्यासाठी त्याचे होमार्पण कर.” ");
INSERT INTO mar_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","तेव्हा अब्राहाम पहाटेस लवकर उठला, त्याने खोगीर घालून आपले गाढव तयार केले, आपला मुलगा इसहाक व त्याच्यासोबत दोन तरुण सेवकांना आपल्याबरोबर घेतले. त्याने होमार्पणाकरिता लाकडे फोडून घेतली आणि मग ते सर्व देवाने सांगितलेल्या ठिकाणी प्रवासास निघाले. ");
INSERT INTO mar_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तिसऱ्या दिवशी अब्राहामाने वर पाहिले आणि दूर अंतरावर ती जागा पाहिली. ");
INSERT INTO mar_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","मग अब्राहाम आपल्या तरुण सेवकांना म्हणाला, “तुम्ही येथे गाढवाजवळ थांबा, आणि मी व मुलगा तिकडे जातो. आम्ही देवाची आराधना करू आणि तुम्हाकडे परत येऊ.” ");
INSERT INTO mar_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","अब्राहामाने होमार्पणासाठी लाकडे घेऊन इसहाकाच्या खांद्यावर ठेवली; त्याने स्वतःच्या हातात अग्नी व एक सुरा घेतला. आणि ते दोघे बरोबर निघाले. ");
INSERT INTO mar_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाक आपल्या पित्याला म्हणाला, “माझ्या बाबा.” अब्राहामाने उत्तर दिले, “मी येथे आहे, माझ्या मुला.” इसहाक म्हणाला, “मला लाकडे व अग्नी दिसतात, परंतु होमार्पणासाठी कोकरू कोठे आहे?” ");
INSERT INTO mar_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहाम म्हणाला, “माझ्या मुला, होमार्पणासाठी कोकरू देव स्वतः आपल्याला पुरवेल.” तेव्हा अब्राहाम व त्याचा मुलगा बरोबर निघाले. ");
INSERT INTO mar_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","देवाने सांगितलेल्या ठिकाणी जेव्हा ते जाऊन पोहचले, तेथे अब्राहामाने एक वेदी बांधली, त्याने वेदीवर लाकडे रचली. नंतर त्याने आपला पुत्र इसहाक याला बांधले, आणि वेदीवरील लाकडावर ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","मग अब्राहामाने आपला हात पुढे करून आपल्या मुलाला मारण्यासाठी सुरा हातात घेतला. ");
INSERT INTO mar_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","परंतु तेवढ्यात, परमेश्वराच्या दूताने स्वर्गातून हाक मारून त्यास म्हटले, “अब्राहामा, अब्राहामा!” अब्राहामाने उत्तर दिले, “मी येथे आहे.” ");
INSERT INTO mar_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","तो म्हणाला, “तू आपल्या मुलावर हात टाकू नकोस, किंवा त्यास कोणत्याही प्रकारची इजा करू नकोस, कारण आता मला खात्रीने समजले की, तू देवाचे भय बाळगतोस, कारण तू माझ्यासाठी आपल्या एकुलत्या एका पुत्राला ही राखून ठेवले नाही.” ");
INSERT INTO mar_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","आणि मग अब्राहामाने वर पाहिले आणि पाहा, त्याच्यामागे एका झुडपात शिंगे अडकलेला असा एक एडका होता. मग त्याने जाऊन तो घेतला व आपल्या मुलाच्या ऐवजी त्या एडक्याचे होमार्पण म्हणून अर्पण केले. ");
INSERT INTO mar_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","तेव्हा अब्राहामाने त्या जागेला, “परमेश्वर पुरवठा करेल,” असे नाव दिले, आणि आजवर देखील, “परमेश्वराच्या डोंगरावर तो पुरवठा केला जाईल,” असे बोलले जाते. ");
INSERT INTO mar_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","नंतर स्वर्गातून परमेश्वराच्या दूताने अब्राहामास दुसऱ्यांदा हाक मारली ");
INSERT INTO mar_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","आणि म्हटले, हे परमेश्वराचे शब्द आहेत, “मी परमेश्वर आपलीच शपथ वाहून म्हणतो की, तू ही जी गोष्ट केली आहे, म्हणजे तू आपल्या एकुलत्या एका मुलाला राखून ठेवले नाही, ");
INSERT INTO mar_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","मी खरोखर तुला आशीर्वाद देईन व तुझे वंशज आकाशातल्या ताऱ्यांसारखे व समुद्र किनाऱ्यावरील वाळू इतके बहुतपट वाढवीनच वाढवीन; आणि तुझे वंशज आपल्या शत्रूच्या वेशीचा ताबा मिळवतील. ");
INSERT INTO mar_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","पृथ्वीवरील सर्व राष्ट्रे तुझ्या संततीद्वारे आशीर्वादित होतील, कारण तू माझा शब्द पाळला आहेस.” ");
INSERT INTO mar_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","मग अब्राहाम आपल्या तरुण सेवकाकडे परत आला आणि अब्राहाम, इसहाक व त्याचे सेवक असे सर्व मिळून बैर-शेबाला गेले, आणि तो बैर-शेबा येथे राहिला. ");
INSERT INTO mar_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","या सर्व गोष्टी घडल्यानंतर अब्राहामाला असा निरोप आला, “पाहा तुझा भाऊ नाहोर व त्याची पत्नी मिल्का यांनाही आता मुले झाली आहेत.” ");
INSERT INTO mar_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","त्याच्या पहिल्या मुलाचे नाव ऊस, त्याचा भाऊ बूज, अरामाचा बाप कमुवेल, ");
INSERT INTO mar_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","त्यानंतर केसेद, हजो, पिलदाश, यिदलाप आणि बथुवेल अशी त्यांची नावे आहेत. ");
INSERT INTO mar_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बथुवेल रिबकाचा बाप होता. अब्राहामाचा भाऊ नाहोर याजपासून मिल्केला हे आठ पुत्र झाले; ");
INSERT INTO mar_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","त्याची उपपत्नी रेऊमा हिलाही त्याच्यापासून तेबाह, गहाम, तहश व माका हे चार पुत्र झाले. ");
INSERT INTO mar_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा एकशे सत्तावीस वर्षे जगली; ही सारेच्या आयुष्याची वर्षे होती. ");
INSERT INTO mar_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","सारा कनान देशातील किर्याथ-आर्बा, म्हणजे, कनान देशातले हेब्रोन येथे मरण पावली. अब्राहामाने सारेसाठी शोक केला आणि तिच्यासाठी तो रडला. ");
INSERT INTO mar_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","मग अब्राहाम उठला आणि आपल्या मृत पत्नीपासून गेला, व हेथीच्या मुलांकडे जाऊन म्हणाला, ");
INSERT INTO mar_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“मी तुमच्यात परदेशी आहे. कृपा करून मृताला पुरण्यासाठी मला तुमच्यामध्ये माझ्या मालकीची अशी जागा मंजूर करा, म्हणजे मी माझ्या मृताला पुरू शकेन.” ");
INSERT INTO mar_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हेथीच्या मुलांनी अब्राहामाला म्हटले, ");
INSERT INTO mar_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“माझ्या स्वामी, आमचे ऐका. तुम्ही आमच्यामध्ये देवाचे सरदार आहात. आमच्याकडे असलेल्या उत्तम थडग्यात तुमच्या मयताला पुरा. आमच्यातील कोणीही आपले थडगे तुम्हास द्यायला मना करणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","अब्राहाम उठला व त्याने हेथीच्या मुलांना आणि देशातील लोकांस नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","तो त्यांना म्हणाला, “जर माझ्या मयताला पुरण्यासाठी तुम्ही सहमत आहात, तर मग माझे ऐका आणि माझ्याबरोबर सोहराचा मुलगा एफ्रोन याला माझ्यासाठी विनंती करा. ");
INSERT INTO mar_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","त्याच्या मालकीची शेताच्या एका टोकाला असलेली मकपेलाची गुहा मला विकत द्यायला सांगा. ती त्याने पूर्ण किंमतीस मला उघडपणे माझ्या मालकीची मृतांना पुरण्याची जागा म्हणून विकत द्यावी.” ");
INSERT INTO mar_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","तेथे एफ्रोन हा हेथीच्या मुलांबरोबर बसलेला होता, आणि हेथीची मुले व त्याच्या नगराच्या वेशीत येणारे सर्व ऐकत असता, एफ्रोन हित्ती याने अब्राहामाला उत्तर दिले, तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“नाही, माझे स्वामी, माझे ऐका. मी ते शेत आणि त्यामध्ये असलेली गुहा तुम्हास देतो. येथे माझ्या लोकांच्या मुलांसमक्ष मी ते शेत व ती गुहा मी तुम्हास देतो. तुमच्या मृताला पुरण्यास मी ते तुम्हास देतो.” ");
INSERT INTO mar_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","मग अब्राहामाने देशातील लोकांसमोर स्वतः वाकून नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","देशातले लोक ऐकत असता तो एफ्रोनास म्हणाला, “परंतु जर तुझी इच्छा आहे, तर कृपा करून माझे ऐक. मी शेताची किंमत तुला देईन. माझ्याकडून त्याचे पैसे घे, आणि मग मी आपल्या मयतास तेथे पुरेन.” ");
INSERT INTO mar_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","एफ्रोनाने अब्राहामाला उत्तर दिले, तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“माझे स्वामी, कृपया माझे जरा ऐका. जमिनीचा हा एक तुकडा चारशे शेकेल रुपे किंमताचा, तो माझ्या व तुमच्यामध्ये एवढा काय आहे? तुमच्या मृताला पुरा.” ");
INSERT INTO mar_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","तेव्हा अब्राहामाने एफ्रोनाचे ऐकले आणि हेथीची मुले ऐकत असता त्याने जितके रुपे सांगितले होते तितके, म्हणजे व्यापाऱ्याकडचे चलनी चारशे शेकेल रुपे एफ्रोनाला तोलून दिले. ");
INSERT INTO mar_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","एफ्रोनाचे जे शेत मम्रे शेजारी मकपेला येथे होते, ते शेत, व त्यामध्ये असलेली गुहा व त्याच्यासभोवती सीमेतील सर्व झाडे, ");
INSERT INTO mar_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ही हेथीच्या मुलांसमक्ष व त्याच्या नगराच्या वेशीत जाणाऱ्या-येणाऱ्या सर्वांसमक्ष अब्राहामाने विकत घेतली. ");
INSERT INTO mar_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","त्यानंतर अब्राहामाने आपली पत्नी सारा हिला कनान देशातील मम्रे म्हणजे हेब्रोन शहराच्या शेजारी मकपेलाच्या शेतातील गुहेत पुरले. ");
INSERT INTO mar_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ते शेत व त्यातील गुहा ही मृतांना पुरण्याची जागा म्हणून हेथीच्या मुलांकडून अब्राहामाच्या मालकीची झाली. ");
INSERT INTO mar_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","आता अब्राहाम बऱ्याच वयाचा म्हातारा झाला होता आणि परमेश्वराने अब्राहामाला सर्व गोष्टींत आशीर्वादित केले होते. ");
INSERT INTO mar_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहामाने त्याच्या सर्व मालमत्तेचा व घरादाराचा कारभार पाहणाऱ्या आणि त्याच्या घरातील सर्वांत जुन्या सेवकाला म्हटले, “तू आपला हात माझ्या मांडीखाली ठेव, ");
INSERT INTO mar_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","आणि आकाशाचा देव व पृथ्वीचा देव जो परमेश्वर, याची शपथ मी तुला घ्यायला लावतो की, ज्या कनानी लोकांमध्ये मी राहत आहे, त्यांच्या मुलींतून तू माझ्या मुलांसाठी पत्नी पाहणार नाहीस. ");
INSERT INTO mar_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","परंतु, तू माझ्या देशाला माझ्या नातेवाइकांकडे जाशील, आणि तेथून माझा मुलगा इसहाक याच्यासाठी पत्नी मिळवून आणशील.” ");
INSERT INTO mar_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","सेवक त्यास म्हणाला, “ती स्त्री जर माझ्याबरोबर या देशात येण्यास तयार झाली नाही तर? ज्या देशातून तुम्ही आला त्या देशात मी मुलाला घेऊन जावे काय?” ");
INSERT INTO mar_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","अब्राहाम त्यास म्हणाला, “तू माझ्या मुलाला तिकडे परत घेऊन न जाण्याची खबरदारी घे! ");
INSERT INTO mar_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","आकाशाचा देव परमेश्वर, ज्याने मला माझ्या वडिलाच्या घरातून व माझ्या नातेवाइकांच्या देशातून मला आणले व ज्याने बोलून, ‘मी हा देश तुझ्या संततीला देईन,’ असे शपथपूर्वक अभिवचन दिले, तो परमेश्वर आपल्या दूताला तुझ्या पुढे पाठवील, आणि तू तेथून माझ्या मुलासाठी पत्नी आणशील. ");
INSERT INTO mar_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","परंतु ती स्त्री तुझ्याबरोबर येथे येण्यास कबूल झाली नाही, तर मग तू माझ्या शपथेतून मोकळा होशील. परंतु माझ्या मुलाला तू तिकडे घेऊन जाऊ नकोस.” ");
INSERT INTO mar_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","तेव्हा त्या सेवकाने आपला धनी अब्राहाम याच्या मांडीखाली हात ठेवला आणि त्या बाबीसंबंधाने त्याच्याशी शपथ घेतली. ");
INSERT INTO mar_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","मग त्या सेवकाने धन्याच्या उंटांपैकी दहा उंट घेतले आणि निघाला (त्याच्या धन्याची सर्व मालमत्ता त्याच्या हाती होती). त्याने आपल्या धन्याकडून सर्व प्रकारच्या भेटवस्तू आपल्याबरोबर देण्यासाठी घेतल्या. तो अराम-नहराईम प्रदेशातील नाहोराच्या नगरात गेला. ");
INSERT INTO mar_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","त्याने नगराबाहेरच्या विहिरीजवळ आपले उंट खाली बसवले. ती संध्याकाळ होती, त्या वेळी पाणी काढायला स्त्रिया तेथे येत असत. ");
INSERT INTO mar_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","नंतर तो म्हणाला, “हे परमेश्वरा, तू माझा धनी अब्राहाम याचा देव आहेस, आज मला यश मिळण्यास मदत कर आणि तू प्रामाणिकपणाने करार पाळणारा आहेस हे माझा धनी अब्राहाम ह्याला दाखवून दे. ");
INSERT INTO mar_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","पाहा, मी पाण्याच्या झऱ्याजवळ उभा आहे. आणि नगरातील लोकांच्या मुली पाणी काढण्यास बाहेर येत आहेत. ");
INSERT INTO mar_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","तर असे घडू दे की, मी ज्या मुलीस म्हणेन, ‘मुली तुझी पाण्याची घागर उतरून मला प्यायला पाणी दे,’ आणि ती जर ‘तुम्ही प्या, आणि मी तुमच्या उंटांनाही पाणी पाजते,’ तर मग तीच तुझा सेवक इसहाक ह्याच्यासाठी तू नेमलेली असू दे. त्यावरून मी असे समजेन की, तू माझ्या धन्यासोबत करार पाळण्याचा प्रामाणिकपणा दाखवला आहे.” ");
INSERT INTO mar_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","मग असे झाले की, त्याचे बोलणे संपले नाही तोच, पाहा, रिबका तिची मातीची घागर तिच्या खांद्यावर घेऊन बाहेर आली. रिबका ही अब्राहामाचा भाऊ नाहोर याच्यापासून मिल्केला झालेल्या बथुवेलाची कन्या होती. ");
INSERT INTO mar_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ती तरुण स्त्री फार सुंदर आणि कुमारी होती. तिचा कोणाही पुरुषाबरोबर संबंध आलेला नव्हता. ती विहिरीत खाली उतरून गेली आणि तिची घागर भरून घेऊन वर आली. ");
INSERT INTO mar_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","तेव्हा तो सेवक धावत जाऊन तिला म्हणाला, “कृपा करून तुझ्या घागरीतून मला थोडे पाणी पाज.” ");
INSERT INTO mar_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ती म्हणाली, “प्या माझ्या प्रभू,” आणि तिने लगेच आपली घागर आपल्या हातावर उतरून घेऊन घेतली, आणि त्यास पाणी पाजले. ");
INSERT INTO mar_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","त्यास पुरे इतके पाणी पाजल्यानंतर ती म्हणाली, “मी तुमच्या उंटांसाठीसुद्धा, त्यांना पुरेल इतके पाणी पिण्यास काढते.” ");
INSERT INTO mar_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","म्हणून तिने घाईघाईने उंटांसाठी घागर कुंडात ओतली, आणि आणखी पाणी काढण्याकरिता ती धावत विहिरीकडे गेली, आणि याप्रमाणे तिने त्याच्या सगळ्या उंटांना पाणी पाजले. ");
INSERT INTO mar_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","तेव्हा, परमेश्वर देवाने आपला प्रवास यशस्वी केला की नाही, हे समजावे म्हणून तो मनुष्य तिच्याकडे शांतपणे पाहत राहिला. ");
INSERT INTO mar_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","उंटांचे पाणी पिणे संपल्यावर त्या मनुष्याने अर्धा शेकेल वजनाची सोन्याची नथ आणि तिच्या हातासाठी दहा शेकेल वजनाच्या दोन सोन्याच्या बांगड्या काढल्या, ");
INSERT INTO mar_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","आणि विचारले, “तू कोणाची मुलगी आहेस? तसेच तुझ्या वडिलाच्या घरी आम्हा सर्वांना रात्री मुक्काम करावयास जागा आहे का ते कृपा करून सांग.” ");
INSERT INTO mar_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ती त्यास म्हणाली, “मी बथुवेलाची, म्हणजे नाहोरापासून मिल्केला जो मुलगा झाला त्याची मुलगी आहे.” ");
INSERT INTO mar_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ती आणखी त्यास म्हणाली, “आमच्याकडे तुमच्या उंटांसाठी भरपूर गवत व पेंढा आहे आणि तुमच्या सर्वांसाठी मुक्काम करण्यासाठी आमच्याकडे भरपूर जागा आहे.” ");
INSERT INTO mar_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तेव्हा त्या मनुष्याने लवून परमेश्वराची उपासना केली. ");
INSERT INTO mar_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","तो म्हणाला, “माझा धनी, अब्राहाम ह्याचा देव परमेश्वर धन्यवादित असो, त्याने माझ्या धन्यासंबंधीचा कराराचा प्रामाणिकपणा आणि विश्वसनीयता सोडली नाही, माझ्याबाबत सांगायचे तर, परमेश्वराने मला माझ्या धन्याच्या नातेवाइकाकडेच सरळ मार्ग दाखवून आणले.” ");
INSERT INTO mar_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","नंतर ती तरुण स्त्री पळत गेली आणि तिने या सर्व गोष्टींबद्दल आपल्या आईला व घरच्या सर्वांना सांगितले. ");
INSERT INTO mar_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","रिबकेला एक भाऊ होता, आणि त्याचे नाव लाबान होते. लाबान बाहेर विहिरीजवळ रस्त्यावर उभ्या असलेल्या त्या मनुष्याकडे पळत गेला. ");
INSERT INTO mar_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","जेव्हा त्याने आपल्या बहिणीच्या नाकातील नथ व हातातील सोन्याच्या बांगड्या पाहिल्या, आणि “तो मनुष्य मला असे म्हणाला,” असे आपल्या बहिणीचे, म्हणजे रिबकेचे शब्द ऐकले, तेव्हा तो त्या मनुष्याकडे आला, आणि पाहतो तो, तो उंटांपाशी विहिरीजवळ उभा होता. ");
INSERT INTO mar_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","आणि लाबान त्यास म्हणाला, “परमेश्वराचा आशीर्वाद लाभलेले तुम्ही, आत या. तुम्ही बाहेर का उभे आहात? मी तुमच्यासाठी घर तयार केले आहे आणि उंटासाठीही जागा केली आहे.” ");
INSERT INTO mar_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","तो मनुष्य घरी आला आणि त्याने उंट सोडले. उंटांना गवत व पेंढा दिला आणि त्याचे पाय व त्याच्या बरोबरच्या लोकांचे पाय धुण्यासाठी पाणी देण्यात आले. ");
INSERT INTO mar_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","त्यांनी त्याच्या पुढे जेवण वाढले, परंतु तो म्हणाला, “मला जे काही सांगायचे ते सांगेपर्यंत मी जेवणार नाही.” तेव्हा लाबान म्हणाला, “सांगा.” ");
INSERT INTO mar_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","तो म्हणाला, “मी अब्राहामाचा सेवक आहे. ");
INSERT INTO mar_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","परमेश्वर देवाने माझ्या धन्याला फार आशीर्वादित केले आहे आणि तो महान बनला आहे. त्याने त्यास मेंढरांचे कळप, गुरेढोरे, तसेच सोने, चांदी, दासदासी, उंट व गाढवे दिली आहेत. ");
INSERT INTO mar_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","सारा, ही माझ्या धन्याची पत्नी वृद्ध झाली तेव्हा तिच्यापासून माझ्या धन्याला मुलगा झाला, आणि त्यास त्याने आपले सर्वकाही दिले आहे. ");
INSERT INTO mar_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","माझ्या धन्याने माझ्याकडून वचन घेतले, तो म्हणाला, ‘ज्यांच्या राज्यात मी माझे घर केले आहे त्या कनानी लोकांतून माझ्या मुलासाठी कोणी मुलगी पत्नी करून घेऊ नकोस. ");
INSERT INTO mar_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","त्याऐवजी माझ्या वडिलाच्या परिवाराकडे जा, आणि माझ्या नातलगांकडे जा व तेथून माझ्या मुलासाठी तू पत्नी मिळवून आण.’ ");
INSERT INTO mar_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","मी माझ्या धन्याला म्हणालो, ‘यदाकदाचित मुलगी माझ्याबरोबर येणार नाही?’ ");
INSERT INTO mar_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","परंतु तो मला म्हणाला, ‘ज्या परमेश्वरासमोर मी चालत आहे, तो त्याच्या दूताला तुझ्याबरोबर पाठवील व तो तुझा मार्ग यशस्वी करील, आणि तू माझ्या नातलगांतून व माझ्या वडिलाच्या घराण्यातून माझ्या मुलासाठी पत्नी आणशील. ");
INSERT INTO mar_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","परंतु जेव्हा तू माझ्या नातलगांमध्ये जाशील आणि जर त्यांनी तुला ती दिली नाही, तर मग तू माझ्या शपथेतून मोकळा होशील.’ ");
INSERT INTO mar_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","आणि आज मी या झऱ्याजवळ आलो आणि म्हणालो, ‘हे परमेश्वरा, माझा धनी अब्राहाम याच्या देवा, कृपा करून जर खरोखर माझ्या प्रवासाचा हेतू यशस्वी करीत असलास तर, ");
INSERT INTO mar_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","मी येथे या झऱ्याजवळ उभा आहे, आणि असे होऊ दे की, जी मुलगी पाणी काढण्यास येईल आणि जिला मी म्हणेन, “मी तुला विनंती करतो, तू आपल्या घागरीतले थोडे पाणी मला प्यायला दे,” ");
INSERT INTO mar_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","तेव्हा जी मला म्हणेल, “तुम्ही प्या, आणि मी तुमच्या उंटासाठी ही पाणी काढते” तीच मुलगी माझ्या धन्याच्या मुलासाठी परमेश्वराने निवडलेली आहे असे मी समजेन. ");
INSERT INTO mar_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","मी माझ्या मनात बोलणे संपण्याच्या आत पाहा रिबका खांद्यावर घागर घेऊन बाहेर आली. ती विहिरीत खाली उतरली आणि पाणी काढले. मग मी तिला म्हणालो, “मुली, कृपा करून मला थोडे पाणी प्यायला दे.” ");
INSERT INTO mar_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","तेव्हा तिने लगेच खांद्यावरून घागर उतरली आणि म्हणाली, “प्या आणि मी तुमच्या उंटांनाही पाणी पाजते.” मग मी प्यालो आणि तिने उंटांनाही पाणी पाजले. ");
INSERT INTO mar_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","मग मी तिला विचारले, “तू कोणाची मुलगी आहेस?” ती म्हणाली, “नाहोरापासून मिल्केला झालेल्या बथुवेलाची मी मुलगी,” तेव्हा मग मी तिला सोन्याची नथ आणि हातात घालण्यासाठी सोन्याच्या दोन बांगडया दिल्या. ");
INSERT INTO mar_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","नंतर मी मस्तक लववून माझा धनी अब्राहाम याचा देव परमेश्वर याची स्तुती केली, कारण त्याने मला माझ्या धन्याच्या भावाच्या मुलीला त्याच्या मुलाकडे नेण्याचा योग्य मार्ग दाखवला. ");
INSERT INTO mar_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","“आता तुम्ही माझ्या धन्याशी प्रामाणिकपणाने आणि सत्याने वागण्यास तयार असाल तर मला सांगा. परंतु जर नाही तर तसे मला सांगा; यासाठी की मी उजवीकडे किंवा डावीकडे वळेन.” ");
INSERT INTO mar_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","मग लाबान व बथुवेल यांनी उत्तर दिले, “ही गोष्ट परमेश्वराकडून आली आहे. आम्ही तुम्हास बरे किंवा वाईट काही बोलू शकत नाही. ");
INSERT INTO mar_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","पाहा, रिबका तुमच्यासमोर आहे. तिला तुम्ही घेऊन जा आणि परमेश्वर बोलल्याप्रमाणे ती तुमच्या धन्याच्या मुलाची पत्नी व्हावी.” ");
INSERT INTO mar_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","जेव्हा अब्राहामाच्या सेवकाने हे त्यांचे शब्द ऐकले, तेव्हा त्याने भूमीपर्यंत वाकून परमेश्वर देवाला नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","सेवकाने सोन्याचे दागिने व चांदीचे दागिने व वस्त्रे रिबकेला दिली. त्याने तिचा भाऊ व तिची आई यांनाही मोलवान देणग्या दिल्या. ");
INSERT INTO mar_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","मग त्याने व त्याच्या बरोबरच्या माणसांनी त्यांचे खाणे व पिणे झाल्यावर रात्री तेथेच मुक्काम केला. दुसऱ्या दिवशी सकाळी उठल्यावर ते म्हणाले, “आता मला माझ्या धन्याकडे पाठवा.” ");
INSERT INTO mar_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","तेव्हा तिची आई व भाऊ म्हणाले, “रिबकेला आमच्याजवळ थोडे दिवस म्हणजे निदान दहा दिवस तरी राहू द्या. मग तिने जावे.” ");
INSERT INTO mar_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","परंतु तो त्यांना म्हणाला, “मला थांबवून घेऊ नका, कारण परमेश्वराने माझा मार्ग यशस्वी केला आहे, मला माझ्या मार्गाने पाठवा जेणेकरून मी माझ्या धन्याकडे जाईन.” ");
INSERT INTO mar_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ते म्हणाले, “आम्ही मुलीला बोलावून तिला विचारतो.” ");
INSERT INTO mar_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","मग त्यांनी रिबकेला बोलावून तिला विचारले, “या मनुष्याबरोबर तू जातेस काय?” तिने उत्तर दिले, “मी जाते.” ");
INSERT INTO mar_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","मग त्यांची बहीण रिबका, तिच्या दाईसोबत अब्राहामाचा सेवक व त्याची माणसे यांच्या बरोबर प्रवासास निघाली. ");
INSERT INTO mar_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","त्यांनी रिबकेला आशीर्वाद दिला आणि तिला म्हटले, “आमच्या बहिणी, तू हजारो लाखांची आई हो, आणि तुझे वंशज त्यांचा द्वेष करणाऱ्यांच्या वेशीचा ताबा घेवोत.” ");
INSERT INTO mar_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","मग रिबका उठली व ती व तिच्या दासी उंटावर बसल्या आणि त्या मनुष्याच्या मागे गेल्या. अशा रीतीने सेवकाने रिबकेला घेतले आणि त्याच्या मार्गाने गेला. ");
INSERT INTO mar_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","इकडे इसहाक नेगेब येथे राहत होता आणि नुकताच बैर-लहाय-रोई विहिरीपासून परत आला होता. ");
INSERT INTO mar_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","इसहाक संध्याकाळी मनन करण्यास शेतात गेला होता. त्याने आपली नजर वर केली व पाहिले तेव्हा त्यास उंट येताना दिसले. ");
INSERT INTO mar_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबकेने नजर वर करून जेव्हा इसहाकाला पाहिले तेव्हा ती उंटावरून उडी मारून खाली उतरली. ");
INSERT INTO mar_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ती सेवकाला म्हणाली, “शेतातून आपल्याला भेटावयास सामोरा येत असलेला पुरुष कोण आहे?” सेवकाने उत्तर दिले, “तो माझा धनी आहे.” तेव्हा तिने बुरखा घेतला आणि स्वतःला झाकून घेतले. ");
INSERT INTO mar_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","सेवकाने इसहाकाला सर्व गोष्टी, त्याने काय केले त्याविषयी सविस्तर सांगितले. ");
INSERT INTO mar_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","मग इसहाकाने मुलीला आपली आई सारा हिच्या तंबूत आणले. आणि त्याने रिबकेला स्विकारले, आणि ती त्याची पत्नी झाली, आणि त्याने तिच्यावर प्रेम केले. अशा रीतीने आपल्या आईच्या मरणानंतर इसहाक सांत्वन पावला. ");
INSERT INTO mar_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहामाने दुसरी पत्नी केली; तिचे नाव कटूरा होते. ");
INSERT INTO mar_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","तिच्यापासून त्यास जिम्रान, यक्षान, मदान, मिद्यान, इश्बाक व शूह ही मुले झाली. ");
INSERT INTO mar_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","यक्षानास शबा व ददान झाले. अश्शूरी, लटूशी व लऊमी लोक हे ददानाचे वंशज होते. ");
INSERT INTO mar_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","एफा, एफर, हनोख, अबीदा व एल्दा हे मिद्यानाचे पुत्र होते. हे सर्व कटूरेचे वंशज होते. ");
INSERT INTO mar_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","अब्राहामाने आपले सर्वस्व इसहाकास दिले. ");
INSERT INTO mar_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","अब्राहामाने आपल्या उपपत्नीच्या मुलांना देणग्या दिल्या, आणि आपण जिवंत असतानाच त्याने आपला मुलगा इसहाकापासून त्यांना वेगळे करून दूर पूर्वेकडील देशात पाठवून दिले. ");
INSERT INTO mar_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहामाच्या आयुष्याच्या वर्षाचे दिवस हे इतके आहेत, तो एकशे पंच्याहत्तर वर्षे जगला. ");
INSERT INTO mar_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","अब्राहामाने शेवटचा श्वास घेतला आणि तो वृद्ध होऊन व पूर्ण जीवन जगून चांगल्या म्हातारपणी मेला व आपल्या लोकांस जाऊन मिळाला. ");
INSERT INTO mar_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","इसहाक व इश्माएल या त्याच्या मुलांनी त्यास सोहर हित्ती याचा मुलगा एफ्रोन याचे शेत मम्रेसमोर आहे त्यातल्या मकपेला गुहेत पुरले. ");
INSERT INTO mar_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","हे शेत अब्राहामाने हेथीच्या मुलाकडून विकत घेतले होते. त्याची पत्नी सारा हिच्याबरोबर तेथे अब्राहामाला पुरले. ");
INSERT INTO mar_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहामाच्या मृत्यूनंतर देवाने त्याचा मुलगा इसहाक याला आशीर्वादित केले आणि इसहाक बैर-लहाय-रोई जवळ राहत होता. ");
INSERT INTO mar_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","अब्राहामापासून सारेची दासी हागार हिला झालेल्या इश्माएलाची वंशावळ ही: ");
INSERT INTO mar_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्माएलाच्या मुलांची नावे ही होती. इश्माएलाच्या मुलांची नावे त्यांच्या जन्मक्रमाप्रमाणे: इश्माएलाचा प्रथम जन्मलेला मुलगा नबायोथ, केदार, अदबील, मिबसाम, ");
INSERT INTO mar_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दुमा, मस्सा, ");
INSERT INTO mar_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश व केदमा. ");
INSERT INTO mar_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ही इश्माएलाची मुले होती, आणि त्यांच्या गावांवरून आणि त्याच्या छावणीवरून त्यांची नावे ही पडली होती. हे त्यांच्या वंशाप्रमाणे बारा सरदार झाले. ");
INSERT INTO mar_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ही इश्माएलाच्या आयुष्याची वर्षे एकशे सदतीस आहेत. त्याने शेवटचा श्वास घेतला आणि मेला आणि आपल्या लोकांस जाऊन मिळाला. ");
INSERT INTO mar_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","त्याचे वंशज हवीलापासून ते शूरापर्यंत वस्ती करून राहिले, अश्शूराकडे जाताना मिसराजवळ हा देश आहे. ते एकमेकांबरोबर वैराने राहत होते. ");
INSERT INTO mar_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहामाचा मुलगा इसहाक ह्याच्यासंबंधीच्या घटना या आहेत. अब्राहाम इसहाकाचा बाप झाला. ");
INSERT INTO mar_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","इसहाक चाळीस वर्षांचा झाला तेव्हा त्याने पदन-अरामातील अरामी बथुवेलाची मुलगी व अरामी लाबानाची बहीण रिबका हिला पत्नी करून घेतले. ");
INSERT INTO mar_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाकाने आपल्या पत्नीसाठी परमेश्वराकडे प्रार्थना केली कारण ती निःसंतान होती, आणि परमेश्वराने त्याची प्रार्थना ऐकली, आणि रिबका त्याची पत्नी गरोदर राहिली. ");
INSERT INTO mar_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","मुले तिच्या उदरात एकमेकांशी झगडू लागली, तेव्हा ती म्हणाली, “मला हे काय होत आहे?” ती परमेश्वरास याबद्दल विचारायला गेली. ");
INSERT INTO mar_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","परमेश्वर तिला म्हणाला, “दोन राष्ट्रे तुझ्या गर्भाशयात आहेत आणि तुझ्यामधून दोन वंश निघतील. एक वंश दुसऱ्यापेक्षा बलवान असेल आणि थोरला धाकट्याची सेवा करील.” ");
INSERT INTO mar_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","जेव्हा तिची बाळंतपणाची वेळ आली तेव्हा तिच्या गर्भशयात जुळी होती. ");
INSERT INTO mar_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","आणि पहिला मुलगा बाहेर आला तो तांबूस वर्णाचा असून, त्याचे सर्व अंग केसांच्या वस्त्रासारखे होते. त्यांनी त्याचे नाव एसाव असे ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","त्याच्यानंतर त्याचा भाऊ बाहेर आला. त्याच्या हाताने त्याने एसावाची टाच हाताने धरली होती म्हणून त्याचे नाव याकोब असे ठेवले. जेव्हा त्याच्या पत्नीने त्यांना जन्म दिला तेव्हा इसहाक साठ वर्षांचा होता. ");
INSERT INTO mar_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ही मुले मोठी झाली, आणि एसाव तरबेज शिकारी झाला, तो रानातून फिरणारा मनुष्य होता; पण याकोब शांत मनुष्य होता, तो त्याचा वेळ तंबूत घालवीत असे. ");
INSERT INTO mar_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","एसावावर इसहाकाची प्रीती होती, कारण त्याने शिकार करून आणलेल्या प्राण्यांचे मांस तो खात असे, परंतु रिबकेने याकोबावर प्रीती केली. ");
INSERT INTO mar_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","याकोबाने वरण शिजवले. एसाव शिकारीहून परत आला, आणि तो भुकेने व्याकुळ झाला होता. ");
INSERT INTO mar_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","एसाव याकोबास म्हणाला, “मी तुला विनंती करतो, मला थोडे तांबडे डाळीचे वरण खायला घेऊ दे. मी फार दमलो आहे!” म्हणून त्याचे नाव अदोम पडले. ");
INSERT INTO mar_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकोब म्हणाला, “पहिल्यांदा तुझ्या ज्येष्ठपणाचा हक्क मला विकत दे.” ");
INSERT INTO mar_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसाव म्हणाला, “पाहा, मी मरायला लागलो आहे. या ज्येष्ठपणाच्या हक्काचा मला काय उपयोग आहे?” ");
INSERT INTO mar_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","याकोब म्हणाला, “प्रथम, तू माझ्याशी शपथ घे.” तेव्हा एसावाने तशी शपथ घेतली आणि अशा रीतीने त्याने आपल्या ज्येष्ठपणाचा हक्क याकोबाला विकला. ");
INSERT INTO mar_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","याकोबाने त्यास भाकर व मसुरीच्या डाळीचे वरण दिले. त्याने ते खाल्ले व पाणी पिऊन झाल्यावर उठला व तेथून त्याच्या मार्गाने निघून गेला. अशा रीतीने एसावाने त्याच्या ज्येष्ठपणाचा हक्क तुच्छ मानला. ");
INSERT INTO mar_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","अब्राहामाच्या दिवसात जो पहिला दुष्काळ पडला होता त्यासारखा दुसरा दुष्काळ त्या देशात पडला. तेव्हा इसहाक पलिष्ट्यांचा राजा अबीमलेख याजकडे गरार नगरामध्ये गेला. ");
INSERT INTO mar_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","परमेश्वराने त्यास दर्शन देऊन म्हटले, “तू मिसर देशात खाली जाऊ नकोस; जो देश मी तुला सांगेन त्यामध्येच राहा. ");
INSERT INTO mar_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","या देशात उपरी म्हणून राहा आणि मी तुझ्याबरोबर असेन आणि मी तुला आशीर्वाद देईन; कारण हे सर्व देश मी तुझ्या वंशजाला देईन, आणि तुझ्या बाप अब्राहाम याला शपथ घेऊन जे वचन दिले आहे ते सर्व मी पूर्ण करीन. ");
INSERT INTO mar_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","मी तुझे वंशज आकाशातील ताऱ्यांइतके बहुगुणित करीन आणि हे सर्व देश मी तुझ्या वंशजांना देईन. तुझ्या वंशजांद्वारे पृथ्वीवरील सर्व राष्ट्रे आशीर्वादित होतील. ");
INSERT INTO mar_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","मी हे करीन कारण अब्राहामाने माझा शब्द पाळला आणि माझे विधी, माझ्या आज्ञा, माझे नियम व माझे कायदे पाळले.” ");
INSERT INTO mar_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","म्हणून मग इसहाक गरारातच राहिला. ");
INSERT INTO mar_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","जेव्हा तेथील लोकांनी त्याच्या पत्नीविषयी त्यास विचारले, तेव्हा तो म्हणाला, “ती माझी बहीण आहे.” “ती माझी पत्नी आहे,” असे म्हणण्यास तो घाबरला. कारण त्याने विचार केला की, “रिबकेला मिळविण्यासाठी या ठिकाणचे लोक माझा घात करतील, कारण ती दिसायला इतकी सुंदर आहे.” ");
INSERT INTO mar_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","इसहाक बराच काळ तेथे राहिल्यावर, पलिष्ट्यांचा राजा अबीमलेख ह्याने एकदा खिडकीतून बाहेर पाहताना पाहिले की, इसहाक त्याच्या पत्नीला रिबकेला प्रेमाने कुरवाळत आहे. ");
INSERT INTO mar_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","अबीमलेखाने इसहाकाला बोलावले आणि म्हणाला, “पाहा नक्कीच ही तुझी पत्नी आहे. मग, ‘ती तुझी बहीण आहे’ असे तू का सांगितलेस?” इसहाक त्यास म्हणाला, “कारण मला वाटले की, तिला मिळविण्यासाठी कोणीही मला मारून टाकेल.” ");
INSERT INTO mar_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमलेख म्हणाला, “तू आम्हांला हे काय केलेस? कारण आमच्या लोकांतून कोणीही तुझ्या पत्नीबरोबर सहज लैंगिक संबंध केला असता, आणि त्यामुळे तू आमच्यावर दोष आणला असतास.” ");
INSERT INTO mar_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","म्हणून अबीमलेखाने सर्व लोकांस ताकीद दिली आणि म्हणाला, “जो कोणी या मनुष्यास किंवा याच्या पत्नीला हात लावेल त्यास खचित जिवे मारण्यात येईल.” ");
INSERT INTO mar_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाकाने त्या देशात धान्य पेरले आणि त्याच वर्षी त्यास शंभरपट पीक मिळाले, कारण परमेश्वराने त्यास आशीर्वाद दिला. ");
INSERT INTO mar_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","इसहाक धनवान झाला, तो अधिकाधिक वाढत गेला आणि खूप महान होईपर्यंत वाढत गेला. ");
INSERT INTO mar_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","त्याच्याकडे पुष्कळ मेंढरे व गुरेढोरे, मोठा कुटुंबकबिला होता. त्यावरून पलिष्टी त्याचा हेवा करू लागले; ");
INSERT INTO mar_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","म्हणून त्याच्या वडिलाच्या हयातीत पूर्वी त्याच्या नोकरांनी खणलेल्या सर्व विहिरी पलिष्ट्यांनी मातीने बुजवल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","तेव्हा अबीमलेख इसहाकास म्हणाला, “तू आमचा देश सोडून निघून जा कारण आमच्यापेक्षा तू अधिक शक्तीमान झाला आहेस.” ");
INSERT INTO mar_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","म्हणून इसहाकाने तो देश सोडला व गराराच्या खोऱ्यात त्याने तळ दिला आणि तेथेच राहिला. ");
INSERT INTO mar_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","अब्राहामाने आपल्या दिवसात ज्या पाण्याच्या विहिरी खणल्या होत्या, परंतु अब्राहामाच्या मरणानंतर त्या पलिष्टी लोकांनी मातीने बुजविल्या होत्या त्या पुन्हा एकदा इसहाकाने खणून घेतल्या, आणि त्याच्या वडिलाने दिलेली नावेच पुन्हा त्याने दिली. ");
INSERT INTO mar_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","जेव्हा इसहाकाच्या नोकरांनी एक विहीर खोऱ्यात खणली, तेव्हा त्या विहिरीत त्यांना एक जिवंत पाण्याचा झरा लगला. ");
INSERT INTO mar_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","गरार खोऱ्यातील गुराख्यांनी इसहाकाच्या गुराख्यांशी भांडणे केली, ते म्हणाले, “हे पाणी आमचे आहे.” ते त्याच्याशी भांडले म्हणून इसहाकाने त्या विहिरीचे नाव “एसेक” ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","मग त्यांनी दुसरी विहीर खणली, आणि तिच्यावरूनही ते भांडले म्हणून त्याने तिचे नाव “सितना” ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","तो तेथून निघाला आणि त्याने आणखी एक विहीर खणली, परंतु तिच्यासाठी ते भांडले नाहीत म्हणून त्याने तिचे नाव रहोबोथ ठेवले. आणि तो म्हणाला, “आता परमेश्वरने आम्हासाठी जागा शोधून दिली आहे, आणि देशात आमची भरभराट होईल.” ");
INSERT INTO mar_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","नंतर तेथून इसहाक बैर-शेबा येथे गेला. ");
INSERT INTO mar_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","त्याच रात्री परमेश्वराने इसहाकाला दर्शन देऊन म्हटले, “मी तुझा बाप अब्राहाम याचा देव आहे. भिऊ नकोस, कारण मी तुझ्याबरोबर आहे आणि माझा सेवक अब्राहाम याच्यासाठी मी तुला आशीर्वादित करीन व तुझे वंशज बहुतपट करीन.” ");
INSERT INTO mar_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","तेव्हा इसहाकाने तेथे वेदी बांधली व परमेश्वराच्या नावाने प्रार्थना केली. त्याने तेथे आपला तंबू ठोकला आणि त्याच्या नोकरांनी एक विहीर खणली. ");
INSERT INTO mar_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","नंतर गराराहून अबीमलेख, त्याचा मित्र अहुज्जाथ व त्याच्या सैन्याचा सेनापती पिकोल हे त्याच्याकडे गेले. ");
INSERT INTO mar_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाकाने त्यांना विचारले, “तुम्ही माझा द्वेष करता व मला तुम्ही आपणापासून दूर केलेत; तर आता तुम्ही माझ्याकडे का आलात?” ");
INSERT INTO mar_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","आणि ते म्हणाले, “परमेश्वर तुझ्याबरोबर आहे हे आम्हांला स्पष्टपणे दिसून आले आहे. म्हणून आम्ही ठरवले आहे की, आपणांमध्ये म्हणजे आम्हामध्ये व तुझ्यामध्ये तह असावा. म्हणून तू आम्हाबरोबर करार कर, ");
INSERT INTO mar_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","जसे आम्ही तुझी हानी केली नाही, आणि आम्ही तुझ्याशी चांगले वागलो आणि तुला शांतीने पाठवले, तशी तू आम्हास हानी करू नको. खरोखर परमेश्वराने तुला आशीर्वादित केले आहे.” ");
INSERT INTO mar_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","तेव्हा इसहाकाने त्यांना मेजवानी दिली, त्यांनी आनंदाने खाणे पिणे केले. ");
INSERT INTO mar_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","दुसऱ्या दिवशी सकाळी लवकर उठून एकमेकांशी शपथ वाहिली. नंतर इसहाकाने त्यांना रवाना केले आणि ते शांतीने त्याच्यापासून गेले. ");
INSERT INTO mar_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","त्याच दिवशी इसहाकाच्या नोकरांनी येऊन त्यांनी खणलेल्या विहिरीविषयी त्यास सांगितले. ते म्हणाले, “त्या विहिरीत आम्हांस पाणी मिळाले आहे.” ");
INSERT INTO mar_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","तेव्हा इसहाकाने त्या विहिरीचे नाव शेबा ठेवले, आणि त्या नगराला अजूनही बैर-शेबा नाव आहे. ");
INSERT INTO mar_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","एसाव चाळीस वर्षांचा झाल्यावर त्याने हेथी स्त्रियांशी लग्ने केली, एकीचे नाव होते यहूदीथ, ही बैरी हित्तीची मुलगी, आणि दुसरीचे नाव होते बासमथ, ही एलोन हित्तीची मुलगी होती. ");
INSERT INTO mar_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","त्यामुळे इसहाक व रिबका दुःखीत झाले. ");
INSERT INTO mar_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","जेव्हा इसहाक म्हातारा झाला आणि त्याची नजर मंद झाल्यामुळे त्यास दिसेनासे झाले तेव्हा त्याने आपला वडील मुलगा एसाव याला बोलावून म्हटले, “माझ्या मुला.” तो म्हणाला, “काय बाबा?” ");
INSERT INTO mar_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","तो म्हणाला, “हे पाहा, मी म्हातारा झालो आहे, माझ्या मरणाचा दिवस मला माहीत नाही. ");
INSERT INTO mar_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","म्हणून तुझी हत्यारे, बाणांचा भाता व धनुष्य घे, आणि बाहेर रानात जा आणि माझ्यासाठी शिकार घेऊन ये. ");
INSERT INTO mar_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","मला आवडणारे रुचकर जेवण तयार करून माझ्याकडे आण, म्हणजे मग मी ते खाईन व मरण्यापूर्वी मी तुला आशीर्वाद देईन.” ");
INSERT INTO mar_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","जेव्हा इसहाक त्याच्या मुलाशी बोलत होता तेव्हा रिबका ऐकत होती. एसाव रानात शिकार करून घेऊन येण्यासाठी गेला. ");
INSERT INTO mar_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","रिबका आपला मुलगा याकोब याला म्हणाली, “हे पाहा, तुझ्या बापाला तुझा भाऊ एसावाशी बोलताना मी ऐकले. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘माझ्यासाठी शिकार घेऊन ये आणि त्याचे रुचकर जेवण करून माझ्याकडे घेऊन ये म्हणजे मी ते खाईन आणि माझ्या मरण्यापूर्वी परमेश्वराच्या उपस्थितीत तुला आशीर्वाद देईन.’ ");
INSERT INTO mar_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","तर आता माझ्या मुला, मी तुला आज्ञा देते त्याप्रमाणे माझा शब्द पाळ. ");
INSERT INTO mar_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","आपल्या कळपाकडे जा आणि त्यातून दोन चांगली करडे घेऊन मला आणून दे. मी त्यांचे तुझ्या वडिलाच्या आवडीचे रुचकर जेवण तयार करते, ");
INSERT INTO mar_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","मग ते जेवण तुझ्या बापाकडे घेऊन जा, म्हणजे मग ते खाऊन तुझा बाप मरण्यापूर्वी तुला आशीर्वाद देईल.” ");
INSERT INTO mar_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","परंतु याकोब आपली आई रिबका हिला म्हणाला, “माझा भाऊ एसाव केसाळ मनुष्य आहे; मी गुळगुळीत मनुष्य आहे. ");
INSERT INTO mar_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","कदाचित माझा बाप मला स्पर्श करेल आणि मी फसवणारा असा होईल. मी आपणावर शाप ओढवून घेईन, आशीर्वाद आणणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","त्याची आई त्यास म्हणाली, “माझ्या मुला, तुझ्यावरचा शाप माझ्यावर येवो. केवळ माझा शब्द पाळ आणि जा, माझ्याकडे ते घेऊन ये.” ");
INSERT INTO mar_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","मग याकोब गेला आणि ती करडे आईकडे घेऊन आला. त्याच्या आईने त्यांचे त्याच्या वडिलाच्या आवडीचे रुचकर जेवण तयार केले. ");
INSERT INTO mar_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","रिबकाने आपला वडील मुलगा एसावाचे चांगले कपडे घरात तिच्याजवळ होते ते घेऊन आपला धाकटा मुलगा याकोबाच्या अंगात घातले. ");
INSERT INTO mar_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","तसेच तिने करडांचे कातडे याकोबाच्या हातावर व त्याच्या मानेवरच्या गुळगुळीत भागावर लावले. ");
INSERT INTO mar_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","तिने स्वतः इसहाकासाठी तयार केलेले रुचकर जेवण आणि भाकर आणून याकोबाच्या हातात दिले. ");
INSERT INTO mar_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ते घेऊन याकोब आपल्या बापाकडे गेला आणि म्हणाला, “माझ्या बापा” तो म्हणाला, “मी येथे आहे, माझ्या मुला तू कोण आहेस?” ");
INSERT INTO mar_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकोब आपल्या बापाला म्हणाला, “मी तुमचा वडील मुलगा एसाव आहे; तुम्ही मला सांगतिले तसे मी केले आहे. तेव्हा आता उठून बसा व तुमच्यासाठी शिकार करून आणलेले मांस खा म्हणजे मग तुम्ही मला आशीर्वाद द्याल.” ");
INSERT INTO mar_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाक आपल्या मुलाला म्हणाला, “माझ्या मुला एवढ्या लवकर तुला शिकार कशी काय मिळाली?” याकोब म्हणाला, “कारण तुमचा देव परमेश्वराने मला मिळवून दिली.” ");
INSERT INTO mar_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","इसहाक याकोबाला म्हणाला, “माझ्या मुला, माझ्याजवळ ये, म्हणजे मी तुला स्पर्श करतो आणि मग तू खरेच माझा मुलगा एसावच आहेस की नाही हे मला समजेल.” ");
INSERT INTO mar_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","तेव्हा याकोब आपल्या बापाजवळ गेला. इसहाकाने त्यास स्पर्श केला आणि म्हणाला, “तुझा आवाज तर याकोबाच्या आवाजासारखा आहे. परंतु तुझे हात मात्र एसावाच्या हातासारखे केसाळ आहेत.” ");
INSERT INTO mar_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","इसहाकाने त्यास ओळखले नाही कारण त्याचे हात एसावाच्या हातासारखे केसाळ होते, म्हणून त्याने त्यास आशीर्वाद दिला. ");
INSERT INTO mar_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","तो म्हणाला, “तू खरेच माझा मुलगा एसावच आहेस काय?” आणि तो म्हणाला, “मी आहे.” ");
INSERT INTO mar_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","इसहाक म्हणाला, “तू जेवण माझ्याकडे आण, आणि मी तू आणलेले हरणाचे ते मांस खाईन, मग तुला आशीर्वाद देईन.” तेव्हा याकोबाने आपल्या बापाला जेवण दिले. इसहाकाने ते खाल्ले आणि याकोबाने त्याच्यासाठी द्राक्षरसही दिला आणि तो प्याला. ");
INSERT INTO mar_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","मग इसहाक त्याचा बाप त्यास म्हणाला, “माझ्या मुला जरा माझ्याजवळ ये व मला चुंबन दे.” ");
INSERT INTO mar_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","मग याकोब आपल्या बापाजवळ गेला आणि त्याने त्याचे चुंबन घेतले. आणि त्याने त्याच्या कपड्यांचा वास घेतला; त्याने त्यास आशीर्वाद दिला. तो म्हणाला, “पाहा ज्या शेताला परमेश्वराने आशीर्वाद दिला त्याचा वास जसा येतो तसा माझ्या मुलाचा वास आहे. ");
INSERT INTO mar_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","देव तुला आकाशातले दव व भूमीची समृद्धी व भरपूर धान्य व द्राक्षरस देईल. ");
INSERT INTO mar_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","लोक तुझी सेवा करोत व राष्ट्रे तुझ्यापुढे नमोत. तू तुझ्या भावांवर राज्य करशील. तुझ्या आईची मुले तुला नमन करतील. तुला शाप देणारा प्रत्येकजण शापित होईल आणि तुला आशीर्वाद देणारा प्रत्येकजण आशीर्वादित होईल.” ");
INSERT INTO mar_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","इसहाकाने याकोबाला आशीर्वाद देण्याचे संपविले आणि त्यानंतर याकोब आपल्या बापापासून निघून गेला तोच एसाव शिकारीहून आला. ");
INSERT INTO mar_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","त्यानेही आपल्या वडिलाच्या आवडीचे रुचकर भोजन तयार करून आपल्या बापाजवळ आणले, तो त्याच्या बापाला म्हणाला, “माझ्या वडिलाने उठावे आणि तुमच्या मुलाने शिकार करून आणलेले मांस खावे जेणेकरून मला आशीर्वाद द्यावा.” ");
INSERT INTO mar_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","इसहाक त्याचा बाप त्यास म्हणाला, “तू कोण आहेस?” तो म्हणाला, “मी तुमचा मुलगा वडील मुलगा एसाव आहे.” ");
INSERT INTO mar_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","मग इसहाक भीतीने थरथर कापत म्हणाला, “तर मग तू येण्या अगोदर ज्याने मांस तयार करून मला आणून दिले तो कोण होता? मी ते सर्व खाऊन त्यास आशीर्वाद दिला. खरोखर तो आशीर्वादित होईल.” ");
INSERT INTO mar_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","जेव्हा एसावाने आपल्या बापाचे शब्द ऐकले, तो खूप मोठ्याने ओरडून आणि दुःखाने रडून म्हणाला “माझ्या पित्या; मलाही आशीर्वाद द्या.” ");
INSERT INTO mar_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","इसहाक म्हणाला, “तुझा भाऊ कपटाने येथे आला आणि तो तुझे आशीर्वाद घेऊन गेला.” ");
INSERT INTO mar_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसाव म्हणाला, “त्याचे याकोब हे नाव त्यास योग्यच आहे की नाही? त्याने माझी दोनदा फसवणूक केली आहे. त्याने माझा ज्येष्ठपणाचा हक्क हिरावून घेतला आणि आता त्याने माझा आशीर्वादही काढून घेतला आहे.” आणि एसाव म्हणाला, “माझ्याकरिता तुम्ही काही आशीर्वाद राखून ठेवला नाही काय?” ");
INSERT INTO mar_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाकाने एसावास उत्तर दिले आणि म्हणाला “पाहा, मी त्यास तुझ्यावर धनीपणा करण्याचा अधिकार दिला आहे, आणि तुझे सर्व बंधू त्याचे सेवक होतील. आणि त्यास मी धान्य व नवा द्राक्षरस दिला आहे. माझ्या मुला, मी तुझ्यासाठी काय करू.” ");
INSERT INTO mar_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसाव आपल्या बापाला म्हणाला, “माझ्या बापा, माझ्यासाठी तुमच्याकडे एकही आशीर्वाद नाही काय? माझ्या बापा मलाही आशीर्वाद द्या.” एसाव मोठ्याने रडला! ");
INSERT INTO mar_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","मग त्याचा बाप इसहाकाने उत्तर दिले आणि त्यास म्हणाला, “पाहा, जेथे पृथ्वीवरील समृद्धी व आकाशातले दंव पडते त्या ठिकाणापासून दूर तुझी वस्ती होईल. ");
INSERT INTO mar_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तुझ्या तलवारीने तू जगशील व आपल्या भावाची सेवा करशील, परंतु जेव्हा तू बंड करशील, तू आपल्या मानेवरून त्याचे जू मोडून टाकशील.” ");
INSERT INTO mar_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","त्यानंतर आपल्या वडिलाने त्यास जो आशीर्वाद दिला होता त्यामुळे एसाव याकोबाचा द्वेष करू लागला. एसाव त्याच्या मनात म्हणाला, “माझ्या पित्याकरिता शोक करण्याचे दिवस जवळ आले आहेत. त्यानंतर मी माझा भाऊ याकोब याला ठार मारीन.” ");
INSERT INTO mar_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","रिबकाला तिच्या वडील मुलाचे शब्द कोणी सांगितले. म्हणून तिने आपला धाकटा मुलगा याकोब याला निरोप पाठवून बोलावले आणि मग ती त्यास म्हणाली, “पाहा, तुझा भाऊ एसाव तुला ठार मारण्याचा बेत करीत आहे व स्वतःचे समाधान करून घेत आहे. ");
INSERT INTO mar_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","म्हणून आता माझ्या मुला, माझी आज्ञा पाळ आणि, हारान प्रांतात माझा भाऊ लाबान राहत आहे, त्याच्याकडे तू पळून जा. ");
INSERT INTO mar_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","तुझ्या भावाचा राग शांत होईपर्यंत थोडे दिवस त्याजकडे राहा. ");
INSERT INTO mar_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","तुझ्यावरून तुझ्या भावाचा राग निघून जाईल, आणि तू त्यास काय केले हे तो विसरेल. मग मी तुला तेथून बोलावून घेईन. एकाच दिवशी मी तुम्हा दोघांनाही का अंतरावे?” ");
INSERT INTO mar_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","मग रिबका इसहाकाला म्हणाली, “हेथीच्या मुलींमुळे मला जीव नकोसा झाला आहे. याकोबाने जर या देशाच्या मुली करून हेथाच्या लोकांतून पत्नी केली तर माझ्या जगण्याचा काय उपयोग?” ");
INSERT INTO mar_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","इसहाकाने याकोबाला बोलावून त्यास आशीर्वाद दिला आणि त्यास आज्ञा दिली, “तू कनानी मुलगी पत्नी करून घेऊ नको. ");
INSERT INTO mar_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ऊठ, तू पदन-अरामात तुझ्या आईचा बाप बथुवेल याच्या घरी जा. आणि तुझ्या आईचा भाऊ लाबान त्याच्या मुलींपैकीच एकीला पत्नी करून घे. ");
INSERT INTO mar_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वसमर्थ देव तुला आशीर्वादित करो आणि तू राष्ट्रांचा समुदाय व्हावे म्हणून तो तुला सफळ करून बहुतपट करो. ");
INSERT INTO mar_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","तो तुला व तुझ्यानंतर तुझ्या वंशजाला अब्राहामाचे आशीर्वाद देवो, आणि जो हा देश परमेश्वराने अब्राहामाला दिला व ज्यात तू राहतोस तो देश तुला वतन म्हणून लाभो.” ");
INSERT INTO mar_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","अशा रीतीने इसहाकाने याकोबाला दूर पाठवले. याकोब पदन-अराम येथे, अरामी बथुवेलाचा मुलगा, याकोब व एसाव यांची आई रिबका हिचा भाऊ लाबान याच्याकडे गेला. ");
INSERT INTO mar_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","एसावाने पाहिले की इसहाकाने याकोबाला आशीर्वाद दिला, व पदन-अरामातून पत्नी करून घेण्यासाठी तिकडे पाठवले. त्याने हे देखील पाहिले की, इसहाकाने त्यास आशीर्वाद दिला आणि आज्ञा देऊन म्हणाला की, “तू कोणत्याच कनानी स्त्रियांतली पत्नी करू नये.” ");
INSERT INTO mar_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","एसावाने हे देखील पाहिले की, याकोबाने आपल्या बापाची आणि आईची आज्ञा मानली, आणि पदन-अरामास गेला. ");
INSERT INTO mar_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","एसावाने पाहिले की, आपला बाप इसहाक याला कनानी मुली पसंत नाहीत. ");
INSERT INTO mar_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","म्हणून तो इश्माएलाकडे गेला आणि त्याने आपल्या स्त्रिया होत्या त्यांच्याशिवाय अब्राहामाचा मुलगा इश्माएलाची मुलगी, नबायोथाची बहीण महलथ ही पत्नी करून घेतली. ");
INSERT INTO mar_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकोबाने बैर-शेबा सोडले व तो हारानाला गेला. ");
INSERT INTO mar_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","तो एका ठिकाणी आला आणि सूर्य मावळला म्हणून त्याने तेथे रात्रभर मुक्काम केला. तेथे रात्री झोपताना त्याने त्या ठिकाणच्या धोंड्यांपैकी एक धोंडा घेतला, तो त्याच्या डोक्याखाली ठेवला आणि त्या ठिकाणी झोप घेण्यासाठी खाली पडून राहिला. ");
INSERT INTO mar_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","तेव्हा त्यास स्वप्न पडले आणि त्याने पाहिले, एक शिडी पृथ्वीवर उभी आहे. तिचे टोक वर स्वर्गापर्यंत पोहचलेले आहे आणि देवाचे दूत तिच्यावरून चढत व उतरत आहेत. ");
INSERT INTO mar_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","पाहा, तिच्यावरती परमेश्वर उभा होता, आणि तो म्हणाला, “मी परमेश्वर, तुझा बाप अब्राहाम याचा देव व इसहाकाचा देव आहे. तू ज्या भूमीवर झोपला आहेस, ती मी तुला व तुझ्या वंशजांना देईन. ");
INSERT INTO mar_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तुझे वंशज पृथ्वीवरील मातीच्या कणाइतके होतील, आणि तुझा विस्तार पूर्वेकडे, पश्चिमेकडे, उत्तरेकडे व दक्षिणकडे होईल. तुझ्यामध्ये व तुझ्या वंशजांमध्ये पृथ्वीवरील सर्व कुटुंबे आशीर्वादित होतील. ");
INSERT INTO mar_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","पाहा, मी तुझ्याबरोबर आहे आणि तू जेथे कोठे जाशील त्या प्रत्येक ठिकाणी मी तुझे रक्षण करीन आणि तुला या देशात परत आणीन; कारण मी तुला सोडणार नाही. मी तुला जी सर्व अभिवचने दिली ते सर्व मी करीन.” ");
INSERT INTO mar_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","मग याकोब त्याच्या झोपेतून जागा झाला, व म्हणाला, “खरोखर या ठिकाणी परमेश्वर आहे, आणि हे मला समजले नव्हते.” ");
INSERT INTO mar_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","त्यास भीती वाटली आणि तो म्हणाला, “हे ठिकाण किती भीतिदायक आहे! हे देवाचे घर आहे, दुसरे काही नाही. हे स्वर्गाचे दार आहे.” ");
INSERT INTO mar_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","याकोब मोठ्या पहाटे लवकर उठला आणि त्याने उशास घेतलेला धोंडा घेतला. त्याने तो स्मारकस्तंभ म्हणून उभा केला आणि त्यावर तेल ओतले. ");
INSERT INTO mar_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","त्या ठिकाणाचे नाव लूज होते, परंतु त्याने त्याचे नाव बेथेल ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","मग याकोबाने शपथ वाहून नवस केला, तो म्हणाला, “जर देव माझ्याबरोबर राहील आणि ज्या मार्गाने मी जातो त्यामध्ये माझे रक्षण करील, आणि मला खावयास अन्न व घालण्यास वस्त्र देईल, ");
INSERT INTO mar_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","आणि मी सुरक्षित माझ्या वडिलाच्या घरी परत येईन, तर परमेश्वर माझा देव होईल. ");
INSERT INTO mar_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","मग मी हा जो धोंडा या ठिकाणी स्तंभ म्हणून उभा केला आहे तो पवित्र धोंडा होईल, तो देवाचे घर होईल. जे सर्व तू मला देशील, त्याचा दहावा भाग मी तुला खचित परत देईन.” ");
INSERT INTO mar_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","नंतर याकोबाने आपला प्रवास पुढे चालू ठेवला आणि तो पूर्वेकडील लोकांच्या देशात आला. ");
INSERT INTO mar_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","त्याने पाहिले तेव्हा त्यास एका शेतात एक विहीर दिसली आणि पाहा तिच्याजवळ मेंढरांचे तीन कळप बसलेले होते. या विहिरीतून कळपांना पाणी पाजीत असत आणि या विहिरीच्या तोंडावरचा दगड मोठा होता. ");
INSERT INTO mar_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","जेव्हा सर्व कळप तेथे जमत तेव्हा मेंढपाळ विहिरीच्या तोंडावरील मोठा दगड ढकलून बाजूला काढीत मग सर्व कळपांचे पाणी पिऊन झाल्यावर ते तो दगड परत त्याच जागेवर ठेवत. ");
INSERT INTO mar_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकोब त्यांना म्हणाला, “माझ्या बंधूंनो, तुम्ही कोठून आलात?” ते म्हणाले, “आम्ही हारान प्रदेशाहून आलो आहोत.” ");
INSERT INTO mar_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","मग तो त्यांना म्हणाला, “नाहोराचा नातू लाबान याला तुम्ही ओळखता का?” ते म्हणाले, “होय, आम्ही त्यास ओळखतो.” ");
INSERT INTO mar_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","याकोबाने त्यांना विचारले, “तो बरा आहे काय?” त्यांनी उत्तर दिले, “तो बरा आहे आणि ती पाहा त्याची मुलगी राहेल मेंढरे घेऊन इकडे येत आहे.” ");
INSERT INTO mar_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","याकोब म्हणाला, “हे पाहा, अद्याप दिवस बराच आहे आणि तसेच कळपांना एकत्र करण्याची अजून वेळ झाली नाही. तेव्हा मेंढरांना पाणी पाजा, आणि चरण्यासाठी त्यांना परत जाऊ द्या.” ");
INSERT INTO mar_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","परंतु ते म्हणाले, “आम्हांला तसे करता येत नाही, कारण सर्व कळप एकत्र आल्यावरच आम्ही विहिरीवरील दगड बाजूला सारतो व मग सर्व कळपांना पाणी पाजतो.” ");
INSERT INTO mar_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","याकोब त्यांच्याशी बोलत असतानाच राहेल आपल्या बापाची मेंढरे घेऊन आली. कारण तीच त्यांना राखीत होती. ");
INSERT INTO mar_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","जेव्हा याकोबाने आपल्या आईचा भाऊ लाबान याची मुलगी राहेल हिला व आपल्या आईच्या भावाच्या मेंढरांना पाहिले तेव्हा याकोबाने जवळ येऊन विहिरीच्या तोंडावरून दगड लोटला व आपल्या आईचा भाऊ लाबान याच्या मेंढरांना पाणी पाजले. ");
INSERT INTO mar_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","याकोबाने राहेलीचे चुंबन घेतले आणि मोठ्याने रडला. ");
INSERT INTO mar_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","याकोबाने राहेलला सांगितले की, तो तिच्या वडिलाच्या नात्यातील आहे, म्हणजे रिबकेचा मुलगा आहे. तेव्हा राहेल धावत गेली आणि तिने आपल्या बापाला सांगितले. ");
INSERT INTO mar_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","जेव्हा आपल्या बहिणीचा मुलगा याकोब आल्याची बातमी लाबानाने ऐकली, तेव्हा लाबान धावत जाऊन त्यास भेटला. त्यास मिठी मारली, त्याची चुंबने घेतली आणि त्यास आपल्या घरी घेऊन आला. मग याकोबाने सर्व गोष्टी लाबानाला सांगितल्या. ");
INSERT INTO mar_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","मग लाबान त्यास म्हणाला, “खरोखर तू माझे हाड व माझे मांस आहेस.” त्यानंतर याकोब एक महिनाभर त्याच्यापाशी राहिला. ");
INSERT INTO mar_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","लाबान याकोबाला म्हणाला, “तू काही मोबदला न घेता काम करीत राहावेस काय? कारण तू माझा नातलग आहेस तर तुला मी काय वेतन द्यावे ते सांग?” ");
INSERT INTO mar_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबानाला दोन मुली होत्या; थोरल्या मुलीचे नाव होते लेआ आणि धाकटीचे राहेल. ");
INSERT INTO mar_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लेआचे डोळे अधू होते, परंतु राहेल सुडौल बांध्याची व दिसावयास सुंदर होती. ");
INSERT INTO mar_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकोबाचे राहेलीवर प्रेम होते, म्हणून तो लाबानास म्हणाला, “तुझी धाकटी मुलगी राहेल हिच्यासाठी मी सात वर्षे तुमची सेवाचाकरी करीन.” ");
INSERT INTO mar_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबान म्हणाला, “परक्या मनुष्यास देण्यापेक्षा, ती मी तुला द्यावी हे बरे आहे. माझ्यापाशी राहा.” ");
INSERT INTO mar_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","म्हणून याकोबाने सात वर्षे राहेलसाठी सेवाचाकरी केली; आणि राहेलीवरील प्रेमामुळे ती वर्षे त्यास फार थोड्या दिवसांसारखी वाटली. ");
INSERT INTO mar_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","नंतर याकोब लाबानास म्हणाला, “आता माझी मुदत भरली आहे, माझी पत्नी मला द्या म्हणजे मी तिच्याशी लग्न करीन.” ");
INSERT INTO mar_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","तेव्हा लाबानाने तेथील सर्व लोकांस एकत्र केले आणि मेजवानी दिली. ");
INSERT INTO mar_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","त्या संध्याकाळी लाबानाने आपली मुलगी लेआ हिला घेतले आणि याकोबाकडे आणले; तो तिच्यापाशी गेला ");
INSERT INTO mar_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबानाने आपली दासी जिल्पा आपल्या मुलीची दासी म्हणून तिला दिली. ");
INSERT INTO mar_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","सकाळी याकोबाने पाहिले तो पाहा, ती लेआ होती. मग याकोब लाबानाला म्हणाला, “तुम्ही मला हे काय केले आहे? मी राहेलीसाठी तुमची चाकरी केली नाही काय? तुम्ही मला का फसवले?” ");
INSERT INTO mar_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबान म्हणाला, “आमच्या रीतीरीवाजाप्रमाणे थोरल्या मुलीच्या आधी आम्ही धाकट्या मुलीला देत नाही. ");
INSERT INTO mar_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","या मुलीचा लग्न विधीचा सप्ताह पूर्ण होऊ दे, म्हणजे मग मी तुला लग्न करण्यासाठी दुसरीही देतो, परंतु त्यासाठी तू आणखी सात वर्षे माझी सेवाचाकरी केली पाहिजेस.” ");
INSERT INTO mar_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","त्याप्रमाणे याकोबाने केले, लेआचे सप्तक पूर्ण केले. मग लाबानाने त्याची धाकटी कन्या राहेल त्यास पत्नी करून दिली; ");
INSERT INTO mar_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबानाने आपली दासी बिल्हा, आपली कन्या राहेल हिला दासी म्हणून दिली. ");
INSERT INTO mar_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","तेव्हा मग याकोबाने राहेलीशीही लग्न केले; आणि याकोबाचे लेआपेक्षा राहेलीवर अधिक प्रेम होते, म्हणून लाबानाकडे याकोबाने राहेलीसाठी आणखी सात वर्षे सेवाचाकरी केली. ");
INSERT INTO mar_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","परमेश्वराने पाहिले की याकोबाचे लेआपेक्षा राहेलीवर अधिक प्रेम आहे, म्हणून परमेश्वराने लेआला मुले होऊ दिली परंतु राहेल निःसंतान होती. ");
INSERT INTO mar_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लेआला मुलगा झाला, तिने त्याचे नाव रऊबेन ठेवले. कारण ती म्हणाली, “परमेश्वराने माझे दुःख पाहिले आहे; कारण माझा पती माझ्यावर प्रेम करीत नाही; परंतु आता कदाचित तो माझ्यावर प्रेम करील.” ");
INSERT INTO mar_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","लेआ पुन्हा गरोदर राहिली आणि तिला आणखी एक मुलगा झाला. ती म्हणाली, “माझ्या नवऱ्याचे माझ्यावर प्रेम नाही हे परमेश्वराने ऐकले आहे, म्हणून त्याने मला हा सुद्धा मुलगा दिला आहे,” आणि या मुलाचे नाव तिने शिमोन ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","लेआ पुन्हा गर्भवती झाली व तिला मुलगा झाला. ती म्हणाली, “आता मात्र माझा पती माझ्यावर नक्की प्रेम करील कारण मी त्यांना तीन पुत्र दिले आहेत.” त्यामुळे तिने त्याचे नाव लेवी असे ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","त्यानंतर लेआ पुन्हा गर्भवती झाली आणि तिला आणखी एक मुलगा झाला. ती म्हणाली, “आता मी परमेश्वराची स्तुती करीन.” त्यामुळे तिने त्याचे नाव यहूदा ठेवले; नंतर तिला मुल होण्याचे थांबले. ");
INSERT INTO mar_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","याकोबापासून आपल्याला मुल होत नाहीत हे पाहिल्यावर राहेल आपली बहीण लेआ हिचा मत्सर करू लागली; तेव्हा राहेल याकोबाला म्हणाली, “मला मुल द्या, नाही तर मी मरेन.” ");
INSERT INTO mar_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","याकोबाचा राहेलवर राग भडकला. तो म्हणाला, “ज्याने तुला मुल होण्यापासून रोखून धरले आहे, त्या देवाच्या ठिकाणी मी आहे की काय?” ");
INSERT INTO mar_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ती म्हणाली, “पाहा, माझी दासी बिल्हा आहे. तुम्ही तिच्या जवळ जा म्हणजे मग ती माझ्या मांडीवर मुलाला जन्म देईल व तिजपासून मलाही मुले मिळतील.” ");
INSERT INTO mar_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","अशा रीतीने तिने त्यास आपली दासी बिल्हा पत्नी म्हणून दिली. आणि याकोबाने तिच्याबरोबर संबंध ठेवला. ");
INSERT INTO mar_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","तेव्हा बिल्हा गरोदर राहिली व याकोबाच्या मुलाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","मग राहेल म्हणाली, “देवाने माझे ऐकले आहे. त्याने माझा आवाज नक्कीच ऐकला आहे आणि मला मुलगा दिला आहे.” म्हणून तिने त्याचे नाव दान ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेलची दासी बिल्हा पुन्हा गर्भवती झाली व तिने याकोबाच्या दुसऱ्या मुलाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","राहेल म्हणाली, “मी माझ्या बहिणीशी प्रबळ स्पर्धा करून लढा दिला व विजय मिळवला आहे.” तिने त्याचे नाव नफताली ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जेव्हा लेआने पाहिले की, आता आपल्याला मुले होण्याचे थांबले आहे. तेव्हा तिने आपली दासी जिल्पा हिला घेतले आणि याकोबाला पत्नी म्हणून दिली. ");
INSERT INTO mar_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","नंतर लेआची दासी जिल्पाने याकोबाच्या मुलाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","लेआ म्हणाली, “मी सुदैवी आहे.” तेव्हा तिने त्याचे नाव गाद ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","नंतर लेआची दासी जिल्पाने याकोबाच्या दुसऱ्या मुलाला दिला. ");
INSERT INTO mar_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","लेआ म्हणाली, “मी आनंदी आहे! इतर स्त्रिया मला आनंदी म्हणतील” म्हणून तिने त्याचे नाव आशेर ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गहू कापणीच्या हंगामाच्या दिवसात रऊबेन शेतात गेला आणि त्यास पुत्रदात्रीची फळे सापडली. त्याने ती आपली आई लेआ हिच्याकडे आणून दिली. नंतर राहेल लेआस म्हणाली, “तुझा मुलगा रऊबेन याने आणलेल्या पुत्रदात्रीच्या फळातून मला काही दे.” ");
INSERT INTO mar_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","लेआ तिला म्हणाली, “तू माझ्या नवऱ्याला माझ्यापासून घेतलेस हे काय कमी झाले? आता माझ्या मुलाची पुत्रदात्रीची फळेही तू घेतेस काय?” राहेल म्हणाली, “तुझ्या मुलाची पुत्रदात्रीची फळे मला देशील तर त्याच्या बदल्यात आज रात्री तो तुझ्याबरोबर झोपेल.” ");
INSERT INTO mar_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","संध्याकाळी याकोब शेतावरून आला. तेव्हा लेआ त्यास भेटण्यास बाहेर गेली व ती म्हणाली, “आज रात्री तुम्ही माझ्याबरोबर झोपणार आहात, कारण माझ्या मुलाची पुत्रदात्रीची फळे देऊन मी तुम्हास मोलाने घेतले आहे.” तेव्हा याकोब त्या रात्री लेआपाशी झोपला. ");
INSERT INTO mar_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","तेव्हा देवाने लेआचे ऐकले व ती गर्भवती राहिली आणि तिने याकोबाच्या पाचव्या मुलाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","लेआ म्हणाली, “देवाने माझे वेतन मला दिले आहे कारण मी माझी दासी माझ्या नवऱ्याला दिली.” तेव्हा तिने आपल्या मुलाचे नाव इस्साखार ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लेआ पुन्हा गरोदर राहिली व तिने याकोबाच्या सहाव्या मुलाला जन्म दिला. ");
INSERT INTO mar_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","लेआ म्हणाली, “देवाने मला उत्तम देणगी दिली आहे. आता माझा पती माझा आदर करील कारण मी त्याच्या सहा मुलांना जन्म दिला आहे.” तिने त्याचे नाव जबुलून ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","त्यानंतर तिला एक मुलगी झाली. तिने तिचे नाव दीना ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","मग देवाने राहेलीचा विचार केला आणि तिचे ऐकले. त्याने तिची कूस वाहती केली. ");
INSERT INTO mar_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ती गर्भवती झाली व तिला मुलगा झाला. ती म्हणाली, “देवाने माझा अपमान दूर केला आहे.” ");
INSERT INTO mar_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","तिने त्याचे नाव योसेफ ठेवले. ती म्हणाली, “परमेश्वर देवाने आणखी एक मुलगा मला दिला आहे.” ");
INSERT INTO mar_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","मग राहेलीला योसेफ झाल्यानंतर याकोब लाबानाला म्हणाला, “मला माझ्या स्वतःच्या घरी आणि माझ्या देशात मला पाठवा. ");
INSERT INTO mar_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ज्यांच्यासाठी मी तुमची सेवा केली आहे त्या माझ्या स्त्रिया आणि माझी मुले द्या आणि मला जाऊ द्या, कारण मी तुमची सेवा कशी केली आहे हे तुम्हास माहीत आहे.” ");
INSERT INTO mar_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लाबान त्यास म्हणाला, “परमेश्वराने केवळ तुझ्यामुळे मला आशीर्वादित केले आहे हे मी जाणतो. जर तुझ्या दृष्टीने माझ्यावर तुझी कृपा असेल तर आता थांब.” ");
INSERT INTO mar_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","नंतर तो म्हणाला, “तुला काय वेतन द्यावे हे सांग आणि ते मी देईन.” ");
INSERT INTO mar_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकोब त्यास म्हणाला, “मी तुमची सेवा केली आहे आणि तुझी गुरेढोरे माझ्याजवळ कशी होती हे तुम्हास माहीत आहे. ");
INSERT INTO mar_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","मी येण्यापूर्वी तुम्हापाशी फार थोडी होती. आणि आता भरपूर वाढली आहेत. मी जेथे जेथे काम केले तेथे तेथे परमेश्वराने तुम्हास आशीर्वादित केले आहे. आता मी माझ्या स्वतःच्या घराची तरतूद कधी करू?” ");
INSERT INTO mar_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","म्हणून लाबान म्हणाला, “मी तुला काय देऊ?” याकोब म्हणाला, “तुम्ही मला काही देऊ नका. जर तुम्ही माझ्यासाठी ही गोष्ट कराल तर मी पूर्वीप्रमाणे आपले कळप चारीन व सांभाळीन. ");
INSERT INTO mar_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","परंतु आज मला तुमच्या सगळ्या कळपात फिरून त्यातील मेंढरांपैकी ठिपकेदार व प्रत्येक काळे व तपकरी असलेली मेंढरे व शेळ्यांतून तपकरी आणि काळ्या रंगाची ही मी बाजूला करीन; हेच माझे वेतन असेल. ");
INSERT INTO mar_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","त्यानंतर तुमच्यापुढे असलेल्या माझ्या वेतनाविषयी हिशोब घ्यायला याल तेव्हा माझा प्रामाणिकपणा माझ्याकरिता साक्ष देईल, जर त्यामध्ये तुम्हास माझ्याजवळच्या शेळ्यांतले जे प्रत्येक ठिपकेदार व तपकरी नाही व मेंढरांतले जे काळे नाही ते आढळले, तर ते मी चोरले आहे असे समजावे.” ");
INSERT INTO mar_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबान म्हणाला, “मी मान्य करतो. तुझ्या शब्दाप्रमाणे कर.” ");
INSERT INTO mar_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","परंतु त्याच दिवशी लाबानाने ठिपकेदार व बांडे एडके तसेच ठिपकेदार व बांड्या शेळ्या आणि मेंढरापैकी काळी मेंढरे कळपातून काढून लपवली, गुपचूप ती आपल्या मुलांच्या हवाली केली व त्यावर लक्ष ठेवून त्यांना सांभाळण्यास सांगितले; ");
INSERT INTO mar_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","तेव्हा लाबानाने आपल्यामध्ये व याकोबामध्ये तीन दिवसाचे अंतर ठेवले. याकोब लाबानाचे बाकीचे कळप चारीत राहिला. ");
INSERT INTO mar_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","मग याकोबाने हिवर व बदाम व अर्मोन या झाडांच्या हिरव्या कोवळ्या फांद्या कापून घेतल्या, त्याने त्यांच्या साली, त्याचे आतील पांढरे पट्टे दिसेपर्यंत त्या सोलून काढल्या. ");
INSERT INTO mar_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","त्याने त्या पांढऱ्या फांद्या किंवा पांढरे फोक कळपांच्या समोर पाणी पिण्याच्या टाक्यात ठेवले जेव्हा शेळ्यामेंढ्या पाणी पिण्यास तेथे येत तेव्हा त्यांच्यावर त्याचे नर उडत व त्या फळत. ");
INSERT INTO mar_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","तेव्हा त्या काठ्यांपाशी शेळ्यामेंढ्यांचे कळप फळले आणि त्या कळपात बांडी व ठिपकेदार, तपकरी अशी पिल्ले झाली. ");
INSERT INTO mar_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकोब कळपातील इतर जनावरांतून ठिपकेदार, पांढऱ्या ठिपक्यांची व काळी करडी कोकरे लाबानाच्या कळपापासून वेगळी करून ठेवत असे. ");
INSERT INTO mar_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","जेव्हा जेव्हा कळपातील चांगली पोसलेली जनावरे फळत असत तेव्हा तेव्हा याकोब त्या पांढऱ्या फांद्या त्यांच्या नजरेसमोर ठेवी आणि मग ती जनावरे त्या फांद्यांसमोर फळत. ");
INSERT INTO mar_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","परंतु जेव्हा दुर्बल जनावरे फळत तेव्हा याकोब त्यांच्या नजरेसमोर त्या झाडांच्या फांद्या ठेवत नसे. म्हणून मग अशक्त नर-माद्यापासून झालेली करडी, कोकरे लाबानाची होत. आणि सशक्त नर-माद्यांपासून झालेली करडी, कोकरे याकोबाची होत. ");
INSERT INTO mar_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","अशा प्रकारे याकोब संपन्न झाला. त्याच्यापाशी शेरडेमेंढरे, उंट, गाढवे व दासदासी हे सर्व भरपूर होते. ");
INSERT INTO mar_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","लाबानाचे पुत्र आपसात बोलत असताना याकोबाने ऐकले ते म्हणाले, “जे आपल्या बापाचे त्यातून सर्वकाही याकोबाने घेतले आहे आणि जे आमच्या वडिलाच्या त्या मालमत्तेतून तो संपन्न झाला आहे.” ");
INSERT INTO mar_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","याकोबाने लाबानाचा चेहरा पाहिला. त्याच्या वागण्यात बदल झाल्याचे त्याच्या लक्षात आले. ");
INSERT INTO mar_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","परमेश्वर याकोबाला म्हणाला, “तुझ्या वडिलाच्या देशात आपल्या नातलगांकडे तू परत जा, आणि मी तुझ्याबरोबर असेन.” ");
INSERT INTO mar_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","तेव्हा याकोबाने राहेल व लेआ यांना, तो आपले शेरडामेंढरांचे कळप राखीत होता, तेथे शेतात बोलावले, ");
INSERT INTO mar_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","आणि त्यांना म्हणाला, “तुमच्या वडिलाच्या वागण्यात मला बदल झालेला जाणवला आहे. परंतु माझ्या बापाचा देव माझ्याबरोबर आहे. ");
INSERT INTO mar_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","तुम्हास माहीत आहे की, मी आपल्या सर्व शक्तीने तुमच्या बापाची सेवा केली आहे. ");
INSERT INTO mar_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","तुमच्या वडिलाने मला फसवले आणि त्याने माझ्या वेतनात दहा वेळा बदल केलेला आहे. परंतु देवाने माझे नुकसान करण्याची परवानगी त्यास दिली नाही. ");
INSERT INTO mar_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","जेव्हा तो म्हणाला, सर्व ठिपकेदार शेळ्यामेंढ्या तुझे वेतन होतील, सर्व शेळ्यामेंढ्यांना ठिपकेदार करडे होऊ लागली. परंतु मग लाबान म्हणाला, तू बांड्या बकऱ्या घे; त्या तुला वेतनादाखल होतील. त्याने असे म्हटल्यानंतर सर्व बकऱ्यांना बांडी करडे होऊ लागली, ");
INSERT INTO mar_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","तेव्हा अशा रीतीने देवाने तुमच्या वडिलाच्या कळपातून गुरेढोरे काढून घेऊन ती मला दिलेली आहेत. ");
INSERT INTO mar_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","एकदा शेळ्यामेंढ्यांचा कळप निपजण्याच्या वेळेस मी आपली दृष्टी वर करून स्वप्नात पाहिले, तो पाहा, कळपातल्या माद्यांवर नर उडत होते ते फक्त ठिपकेदार व बांडे, करडे होते.” ");
INSERT INTO mar_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","देवाचा दूत मला स्वप्नात म्हणाला, “याकोबा,” मी म्हणालो, “काय आज्ञा आहे?” ");
INSERT INTO mar_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","तो म्हणाला, “आपले डोळे वर करून पाहा, ‘फक्त ठिपकेदार व बांडे, करडे असलेलेच नर माद्यांवर उडत आहेत. लाबान तुला काय करीत आहे ते सर्व मी पाहिले आहे. ");
INSERT INTO mar_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","बेथेलचा मी देव आहे. जेथे तू एका स्मारकस्तंभास अभिषेक केलास, जेथे नवस करून तू मला वचन दिले, आणि आता तू हा देश सोड आणि आपल्या जन्मभूमीस परत जा.’” ");
INSERT INTO mar_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","राहेल व लेआ यांनी त्यास उत्तर दिले आणि त्यास म्हणाल्या, “आमच्या वडिलाच्या घरी आम्हांला वारसा किंवा तेथे काही भाग नाही. ");
INSERT INTO mar_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","आम्ही परक्या असल्यासारखे त्याने आम्हांला वागवले नाही काय? त्याने आम्हास तुम्हास विकून टाकले, आणि आमचे पूर्ण पैसे खाऊन टाकले आहेत. ");
INSERT INTO mar_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","देवाने ही सर्व संपत्ती आमच्या पित्याकडून घेतली आणि आता ती आपली व आपल्या मुळाबाळांची संपत्ती झाली आहे. तेव्हा देवाने तुम्हास जे करावयास सांगितले आहे ते करा.” ");
INSERT INTO mar_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","तेव्हा याकोब उठला आणि त्याने आपल्या स्त्रिया व मुलांना उंटांवर बसवले. ");
INSERT INTO mar_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","तो आपली सर्व गुरेढोरे आणि आपण मिळवलेले सर्व धन, म्हणजे जे गुरांढोरांचे कळप त्याने पदन-अरामात मिळवले होते, ते घेऊन आपला बाप इसहाक याच्याकडे कनान देशास जाण्यास निघाला. ");
INSERT INTO mar_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","त्याच वेळी लाबान आपल्या मेंढरांची लोकर कातरण्यास गेला होता. तेव्हा राहेलने आपल्या वडिलाच्या कुलदेवतांच्या मूर्ती चोरल्या. ");
INSERT INTO mar_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","याकोबानेही अरामी लाबानाला फसवले. आपण येथून सोडून जात आहो हे त्यास सांगितले नाही. ");
INSERT INTO mar_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","याकोब आपली बायकामुले व सर्व चीजवस्तू घेऊन ताबडतोब पळाला. त्यांनी फरात नदी ओलांडली आणि ते गिलाद डोंगराळ प्रदेशाकडे निघाले. ");
INSERT INTO mar_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीन दिवसानंतर याकोब पळून गेल्याचे लाबानास कळाले. ");
INSERT INTO mar_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","तेव्हा त्याने आपले नातलग एकत्र जमवले आणि याकोबाचा पाठलाग सुरू केला. सात दिवसानंतर गिलादाच्या डोंगराळ प्रदेशाजवळ त्यास याकोब सापडला. ");
INSERT INTO mar_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","त्या रात्री देव अरामी लाबानाच्या स्वप्नात येऊन म्हणाला, “तू याकोबाला बरे किंवा वाईट बोलू नये म्हणून काळजी घे.” ");
INSERT INTO mar_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","लाबानाने याकोबाला गाठले. याकोबाने डोंगराळ प्रदेशात तळ दिला होता. लाबानानेही आपल्या बरोबरच्या नातलगासह गिलादाच्या डोंगराळ भागात तळ दिला. ");
INSERT INTO mar_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","लाबान याकोबाला म्हणाला, “तू मला हे काय केले? तू मला फसवलेस. आणि युद्धकैदी केलेल्या स्त्रियांप्रमाणे तू माझ्या मुलींना का घेऊन आलास? ");
INSERT INTO mar_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","तू मला न सांगता का पळून गेलास? मला का फसवले? तू मला सांगितले नाही. मी तर उत्सव करून आणि गाणी, डफ व वीणा वाजवून तुला पाठवले असते. ");
INSERT INTO mar_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तू मला माझ्या नातवांचा व माझ्या मुलींचा निरोप घेण्याची किंवा त्यांची चुंबने घेण्याची संधी दिली नाहीस. आता हा तू मूर्खपणा केला आहे. ");
INSERT INTO mar_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","खरे तर अपाय करण्याची माझ्यात ताकद आहे, परंतु काल रात्री तुझ्या बापाचा देव माझ्या स्वप्नात बोलला आणि म्हणाला, ‘तू याकोबाला बरे किंवा वाईट बोलू नको म्हणून काळजी घे.’ ");
INSERT INTO mar_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","तुला तुझ्या वडिलाच्या घरी जायचे आहे हे मला माहीत आहे आणि म्हणूनच तू जाण्यास निघालास, परंतु तू माझ्या घरातील कुलदेवता का चोरल्यास?” ");
INSERT INTO mar_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकोबाने उत्तर दिले आणि लाबानास म्हणाला, “मी गुप्तपणे निघालो कारण मला भीती वाटली, आणि मी विचार केला की, तुम्ही तुमच्या मुली माझ्यापासून हिसकावून घ्याल. ");
INSERT INTO mar_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ज्या कोणी तुमच्या कुलदेवता चोरल्या आहेत तर तो जगणार नाही. तुमच्या नातलगासमोर माझ्याबरोबर जे काही तुमचे आहे ते तुम्ही आपले ओळखा आणि ते घ्या.” राहेलीने त्या मूर्ती चोरल्या होत्या ते याकोबास माहीत नव्हते. ");
INSERT INTO mar_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","लाबान याकोबाच्या तंबूत गेला, लेआच्या तंबूत गेला आणि दासींच्या तंबूत गेला परंतु त्यास त्या सापडल्या नाहीत. त्यानंतर तो राहेलीच्या तंबूत गेला. ");
INSERT INTO mar_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेलीने त्या कुलदेवता उंटाच्या खोगिरात लपवून ठेवल्या होत्या आणि ती त्यांच्यावर बसली होती. लाबानाने सगळा तंबू शोधला परंतु त्या सापडल्या नाहीत. ");
INSERT INTO mar_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ती आपल्या पित्यास म्हणाली, “मी आपल्यासमोर उभी राहू शकत नाही म्हणून माझ्यावर रागावू नका, कारण माझी मासिकपाळी आली आहे.” अशा रीतीने त्याने शोध केला परंतु त्यास कुलदेवता सापडल्या नाहीत. ");
INSERT INTO mar_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","मग याकोबाला राग आला आणि त्याने लाबानाशी वाद केला, तो त्यास म्हणाला, “माझा गुन्हा काय आहे? माझे पाप कोणते आहे, म्हणून तुम्ही माझा रागाने पाठलाग केलात? ");
INSERT INTO mar_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","माझ्या मालकीच्या सर्व चीजवस्तू तुम्ही शोधून पाहिल्या आहेत. तुम्हास तुमच्या मालकीची एकतरी चीजवस्तू आढळली का? जर तुम्हास तुमचे काही मिळाले असेल तर ते आपल्या नातलगासमोर ठेवा. यासाठी की ते आपल्या दोघांचा न्याय करतील. ");
INSERT INTO mar_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","मी वीस वर्षे तुमच्याबरोबर होतो. त्या सर्व काळात एकही करडू किंवा कोकरू मरण पावलेले जन्मले नाही आणि तुमच्या कळपातील एकही बकरा मी खाल्ला नाही. ");
INSERT INTO mar_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जनावरांनी फाडलेले ते मी तुमच्याकडे आणले नाही. त्याऐवजी ते नुकसान मी भरून दिले. दिवसा किंवा रात्री चोरी गेलेले, प्रत्येक हरवलेले जनावर ते तुम्ही नेहमी माझ्या हातून भरून घेत होता. ");
INSERT INTO mar_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","दिवसा उन्हाच्या तापाने व रात्री गारठ्यामुळे मला त्रास होई. आणि माझ्या डोळ्यावरून झोप उडून जाई, अशी माझी स्थिती होती. ");
INSERT INTO mar_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","वीस वर्षे मी तुमच्या घरी राहिलो; पहिली चौदा वर्षे तुमच्या दोन मुलींसाठी आणि सहा वर्षे तुमच्या कळपांसाठी. दहा वेळा तुम्ही माझ्या वेतनात फेरबदल केला. ");
INSERT INTO mar_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","परंतु माझ्या पूर्वजांचा देव; अब्राहामाचा देव आणि इसहाकाचा देव ज्याचे मी भय धरतो, तो माझ्या बरोबर होता. तो जर माझ्याबरोबर नसता तर तुम्ही मला नक्कीच रिकामे पाठवले असते. देवाने माझ्यावर झालेला जुलूम पाहिला आणि मी कष्टाने केलेले काम पाहिले आणि काल रात्री त्याने तुम्हास धमकावले.” ");
INSERT INTO mar_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबानाने उत्तर दिले आणि तो याकोबाला म्हणाला, “या मुली माझ्या मुली आहेत आणि ही नातवंडे माझी नातवंडे आहेत आणि हे कळप माझे कळप आहेत. जे काही तू पाहतोस ते सर्व माझे आहे. परंतु आज मी या मुलींसाठी किंवा त्यांच्या मुलांसाठी ज्यांना त्यांनी जन्म दिला त्यांना मी काय करू शकतो? ");
INSERT INTO mar_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","म्हणून मी व तू आता आपण करार करू आणि तो माझ्यामध्ये व तुझ्यामध्ये साक्षी होवो.” ");
INSERT INTO mar_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","तेव्हा याकोबाने मोठा दगड घेऊन स्मारकस्तंभ उभा केला. ");
INSERT INTO mar_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","याकोब त्याच्या नातलगांना म्हणाला की, “दगड गोळा करा.” मग त्यांनी दगड गोळा करून त्याची रास केली. नंतर त्या दगडांच्या राशीशेजारी बसून ते जेवले. ");
INSERT INTO mar_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबानाने त्या राशीला यगर-सहादूथा असे नाव ठेवले. परंतु याकोबाने त्या जागेचे नाव गलेद ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबान म्हणाला, “ही दगडांची रास आज माझ्यामध्ये व तुझ्यामध्ये साक्षी आहे.” म्हणून त्याचे नाव गलेद ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","मग लाबान म्हणाला, “आपण एकमेकापासून दूर होत असताना परमेश्वर माझ्यावर व तुझ्यावर लक्ष ठेवो.” म्हणून त्या जागेचे नाव मिस्पा ठेवण्यात आले. ");
INSERT INTO mar_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","जर का तू माझ्या मुलींना दुःख देशील किंवा माझ्या मुलींशिवाय दुसऱ्या स्त्रिया करून घेशील. तर पाहा, “जरी आमच्याबरोबर कोणी नाही पण तुझ्यात व माझ्यात देव साक्षी आहे.” ");
INSERT INTO mar_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","लाबान याकोबास म्हणाला, या राशीकडे पाहा आणि स्मारकस्तंभाकडे पाहा, जो मी तुझ्यामध्ये व माझ्यामध्ये ठेवला आहे. ");
INSERT INTO mar_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ही रास व हा स्तंभ ही दोन्ही आपल्यातील कराराची साक्ष होवो, की हानी करायला मी तुझ्याकडे ही रास ओलांडून येणार नाही आणि तू ही माझ्याविरुद्ध ही रास ओलांडून कधीही येऊ नये. ");
INSERT INTO mar_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहामाचा देव, नाहोराचा देव आणि त्यांच्या वडिलांचा देव आमचा न्याय करो. याकोबाने त्याचा बाप इसहाक, ज्या देवाचे भय धरत असे त्याची शपथ घेतली. ");
INSERT INTO mar_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","मग याकोबाने त्या डोंगरावर यज्ञ केला आणि त्याने आपल्या सर्व नातलगांना भोजनासाठी आमंत्रण दिले. भोजन संपल्यावर त्यांनी ती रात्र डोंगरावरच घालवली. ");
INSERT INTO mar_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","दुसऱ्या दिवशी लाबान पहाटेस उठला. त्याने आपल्या मुली व आपली नातवंडे यांची चुंबने घेऊन त्यांचा निरोप घेतला. त्याने त्यांना आशीर्वाद दिला आणि मग तो आपल्या घरी परत गेला. ");
INSERT INTO mar_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकोबही आपल्या मार्गाने गेला आणि त्यास देवाचे दूत भेटले. ");
INSERT INTO mar_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","जेव्हा याकोबाने त्यांना पाहिले तेव्हा तो म्हणाला, “ही देवाची छावणी आहे.” म्हणून त्याने त्या जागेचे नाव महनाईम ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकोबाने आपला भाऊ एसाव याच्याकडे सेईर देशात म्हणजे अदोम प्रांतात आपले निरोपे पाठवले. ");
INSERT INTO mar_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","त्याने त्यांना आज्ञा देऊन म्हटले, “तुम्ही माझे धनी एसाव यांना सांगा, आपला सेवक याकोब असे म्हणतो की, ‘आजपर्यंत अनेक वर्षे मी लाबानाकडे राहिलो. ");
INSERT INTO mar_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","माझ्यापाशी पुष्कळ गाई-गुरे, गाढवे, शेरडामेंढरांचे कळप आणि दास व दासी आहेत. आपली कृपादृष्टी माझ्यावर व्हावी म्हणून मी आपल्या धन्याला हा निरोप पाठवीत आहे.’” ");
INSERT INTO mar_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","निरोपे याकोबाकडे परत आले आणि म्हणाले, “आम्ही आपला भाऊ एसाव याच्याकडे गेलो व त्यास भेटलो. तो आपणाला भेटावयास येत आहे. त्याच्या बरोबर चारशे माणसे आहेत.” ");
INSERT INTO mar_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","तेव्हा याकोब घाबरला आणि अस्वस्थ झाला. त्याने आपल्या सोबत असणाऱ्या लोकांच्या दोन टोळ्या केल्या, तसेच शेरडेमेंढरे, गुरेढोरे आणि उंट व गाढवे यांच्याही त्याने दोन टोळ्या केल्या. ");
INSERT INTO mar_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","तो म्हणाला, “जर एसावाने एका टोळीवर हल्ला करून मार दिला तर दुसरी टोळी निसटून जाईल व वाचेल.” ");
INSERT INTO mar_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","याकोब म्हणाला, “माझा बाप अब्राहाम याच्या देवा, आणि माझा बाप इसहाक याच्या देवा, परमेश्वर देवा, तू मला माझ्या देशात व माझ्या कुटुंबात परत येण्यास सांगितलेस. तसेच तू माझी भरभराट केलीस, ");
INSERT INTO mar_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तू माझ्यावर करुणा व सर्व सत्य विश्वसनीयता दाखवून, करार पाळून, आपल्या दासासाठी जे काही केले आहेस, त्यास मी पात्र नाही. आणि मी यार्देनेच्या पलीकडे गेलो तेव्हा माझ्याजवळ एका काठीशिवाय काहीही नव्हते. परंतु आता माझ्या दोन टोळ्या आहेत. ");
INSERT INTO mar_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","कृपा करून तू माझा भाऊ एसाव याच्यापासून मला वाचव. तो येऊन मला, व मायलेकरांना मारून टाकील, अशी मला भीती वाटते. ");
INSERT INTO mar_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","परंतु तू मला म्हणालास की, ‘मी नक्कीच तुझी भरभराट करीन. मी तुझी संतती वाढवीन आणि जिची गणना करता येणार नाही, अशी समुद्राच्या वाळूइतकी ती करीन.’” ");
INSERT INTO mar_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","त्या रात्री याकोब त्या ठिकाणी राहिला. त्याने आपल्याजवळ जे होते त्यातून, आपला भाऊ एसावाला देण्यासाठी भेट तयार केली. ");
INSERT INTO mar_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","त्याने दोनशे शेळ्या व वीस बोकड, दोनशे मेंढ्या व वीस एडके, ");
INSERT INTO mar_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","तसेच तीस दुभत्या सांडणी व त्यांची शिंगरे, चाळीस गाई व दहा बैल, वीस गाढवी व दहा गाढवे घेतली. ");
INSERT INTO mar_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","त्याने प्रत्येक कळप एकेका नोकराच्या ताब्यात दिला. मग तो नोकरांना म्हणाला, “प्रत्येक कळप वेगळा करा आणि कळपाकळपात थोडे अंतर ठेवून माझ्यापुढे चाला.” ");
INSERT INTO mar_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","याकोबाने कळपाच्या पहिल्या टोळीच्या चाकराला आज्ञा देऊन तो म्हणाला, “जेव्हा माझा भाऊ एसाव तुझ्याकडे येईल व विचारील, ‘ही कोणाची जनावरे आहेत? तू कोठे चाललास? तू कोणाचा नोकर आहेस?’ ");
INSERT INTO mar_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तेव्हा तू त्यास असे उत्तर दे, ‘ही जनावरे आपला सेवक याकोब याच्या मालकीची आहेत. त्याने ही माझा धनी एसाव याला भेट म्हणून पाठवली आहेत. आणि पाहा, तो आमच्या पाठोपाठ येत आहे.’” ");
INSERT INTO mar_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","याकोबाने दुसऱ्या, तिसऱ्या आणि इतर सर्व चाकरांना अशीच आज्ञा करून अशाच प्रकारे उत्तर देण्यास सांगितले. तो म्हणाला, “तुम्हास जेव्हा एसाव भेटेल तेव्हा तुम्ही असेच म्हणावे.” ");
INSERT INTO mar_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","तुम्ही असेही म्हणावे की, “आपला दास याकोब आमच्या मागून येत आहे.” त्याने विचार केला, “जर मी ही माणसे भेटीसह पुढे पाठवली तर कदाचित एसावाचा राग शांत होईल. त्यानंतर जेव्हा मी त्यास भेटेन, तेव्हा कदाचित तो माझा स्विकार करील.” ");
INSERT INTO mar_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","म्हणून त्याप्रमाणे याकोबाने भेट पुढे पाठवली. तो स्वतः त्या रात्री तळावर मागेच राहिला. ");
INSERT INTO mar_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","मग याकोब रात्री उठला. त्याने आपल्या दोन्ही स्त्रिया, दोन्ही दासी आणि अकरा मुले यांना बरोबर घेतले आणि तो यब्बोक नदीच्या उतारापाशी गेला. ");
INSERT INTO mar_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","अशा रीतीने त्याने आपले जे सर्वकाही होते त्यांसह सर्वांना नदी पार करून पाठवले. ");
INSERT INTO mar_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","याकोब एकटाच मागे राहिला होता, आणि एक पुरुष आला व त्याने याकोबाशी सूर्य उगवेपर्यंत कुस्ती केली. ");
INSERT INTO mar_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","जेव्हा त्या मनुष्याने पाहिले की, आपण याकोबाचा पराभव करू शकत नाही, तेव्हा त्याने त्याच्या जांघेला स्पर्श केला. तेव्हा त्याच्याशी कुस्ती करीत असता याकोबाच्या जांघेचा सांधा निखळला. ");
INSERT INTO mar_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","मग तो पुरुष याकोबाला म्हणाला, “आता मला जाऊ दे.” परंतु याकोब म्हणाला, “तू मला आशीर्वाद दिल्याशिवाय मी तुला जाऊ देणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","तो पुरुष त्यास म्हणाला, “तुझे नाव काय आहे?” आणि याकोब म्हणाला, “माझे नाव याकोब आहे.” ");
INSERT INTO mar_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","तेव्हा तो पुरुष म्हणाला, “तुझे नाव याकोब असणार नाही. येथून पुढे तुझे नाव इस्राएल असेल. कारण तू देवाशी व मनुष्यांशी झगडून विजय मिळवला आहेस.” ");
INSERT INTO mar_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","मग याकोबाने त्यास विचारले, “कृपया तुझे नाव मला सांग.” परंतु तो पुरुष म्हणाला, “तू माझे नाव का विचारतोस?” त्या वेळी तेथेच त्या पुरुषाने याकोबाला आशीर्वाद दिला. ");
INSERT INTO mar_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","म्हणून याकोबाने त्या जागेचे नाव पनीएल ठेवले. याकोब म्हणाला, “या ठिकाणी मी देवाला समक्ष पाहिले आहे, तरी माझा जीव वाचला आहे.” ");
INSERT INTO mar_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","मग पनीएलाहून तो पुढे निघाला तेव्हा सूर्य उगवला. याकोब आपल्या पायामुळे लंगडत चालत होता. ");
INSERT INTO mar_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","म्हणून आजपर्यंत इस्राएल लोक जनावरांच्या जांघेच्या सांध्याजवळचा स्नायू खात नाहीत कारण याच स्नायूपाशी याकोबाला दुखापत झाली होती. ");
INSERT INTO mar_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकोबाने वर पाहिले आणि पाहा, त्यास एसाव येताना दिसला आणि त्याच्या बरोबर चारशे माणसे होती. तेव्हा याकोबाने लेआ व राहेल व दोघी दासी यांच्याजवळ मुले वाटून दिली. ");
INSERT INTO mar_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","याकोबाने त्याच्या दासी व त्यांची मुले यांना आघाडीस त्यानंतर त्याच्यामागे लेआ व तिची मुले आणि राहेल व योसेफ यांना सर्वांत शेवटी ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","याकोब स्वतः पुढे गेला. आपल्या भावापर्यंत पोहचेपर्यंत त्याने सात वेळा भूमीपर्यंत लवून त्यास नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","एसावाने जेव्हा याकोबाला पाहिले तेव्हा त्यास भेटण्यास तो धावत गेला आणि त्यास आलिंगन दिले. त्याने गळ्यात गळा घालून याकोबाला मिठी मारली. त्याचे चुंबन घेतले, आणि ते दोघे रडले. ");
INSERT INTO mar_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","एसावाने आपल्या समोरील स्त्रिया व मुले पाहून विचारले, “तुझ्याबरोबर ही कोण मंडळी आहे?” याकोबाने उत्तर दिले, “तुझ्या सेवकाला ही मुले देऊन देवाने माझे कल्याण केले आहे.” ");
INSERT INTO mar_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","मग दोन दासी आपल्या मुलांबरोबर पुढे आल्या आणि त्यांनी एसावाला खाली वाकून नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","त्यानंतर लेआ व तिची मुले, मग राहेल व योसेफ एसावापुढे गेले आणि त्यांनी त्यास खाली वाकून नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसावाने विचारले, “इकडे येताना मला भेटलेल्या सर्व टोळ्यांचा अर्थ काय आहे?” याकोबाने उत्तर दिले, “माझ्या धन्याच्या दृष्टीने मला कृपा मिळावी म्हणून.” ");
INSERT INTO mar_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","एसाव म्हणाला, “माझ्या बंधू मला भरपूर आहे, तुझे तुला असू दे.” ");
INSERT INTO mar_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकोब म्हणाला, “मी आपणाला विनंती करतो, असे नको, आता जर मी तुमच्या दृष्टीने खरोखर कृपा पावलो तर माझ्या हातून या भेटीचा स्विकार करा, कारण मी आपले तोंड पाहिले, आणि जणू काय देवाचे मुख पाहावे तसे मी तुमचे मुख पाहिले आहे आणि आपण माझा स्विकार केला. ");
INSERT INTO mar_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","मी विनंती करतो की, मी आणलेल्या भेटीचा स्विकार करा. कारण देवाने माझे कल्याण केले आहे, आणि माझ्यापाशी भरपूर आहे.” याप्रमाणे याकोबाने एसावास आग्रहाची विनवणी केली आणि मग एसावाने त्यांचा स्विकार केला. ");
INSERT INTO mar_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","मग एसाव म्हणाला, “आता आपण आपल्या वाटेस लागू. मीही तुझ्या पुढे चालतो.” ");
INSERT INTO mar_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","परंतु याकोब त्यास म्हणाला, “माझी मुले लहान आहेत हे माझ्या स्वामीला माहीत आहे, आणि माझी मेंढरे व गुरेढोरे यांच्या पिल्लांची मला काळजी घेतली पाहिजे. मी जर त्यांची एका दिवशी अधिक दौड केली, तर सगळी जनावरे मरून जातील. ");
INSERT INTO mar_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","तर माझे धनी आपण आपल्या सेवकापुढे जा. मी माझी गुरेढोरे, शेरडेमेंढरे इत्यादी जनावरांना जितके चालवेल आणि माझी लहान मुलेही थकणार नाहीत अशा चालीने सावकाश चालेन व आपणास सेईर प्रदेशामध्ये येऊन भेटेन.” ");
INSERT INTO mar_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","तेव्हा एसाव म्हणाला, “मग मी माझ्या मनुष्यातून काही माणसे तुला मदत करण्यासाठी मागे ठेवतो.” परंतु याकोब म्हणाला, “तसे कशाला? माझ्या धन्याची आधीच माझ्यावर पुरेशी कृपा झालेली आहे.” ");
INSERT INTO mar_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","तेव्हा त्याच दिवशी एसाव सेईरास परत जाण्यास निघाला. ");
INSERT INTO mar_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","याकोब प्रवास करीत सुक्कोथास गेला. तेथे त्याने स्वतःसाठी घर बांधले आणि गुराढोरांसाठी गोठे बांधले, म्हणून त्या ठिकाणाचे नाव सुक्कोथ पडले. ");
INSERT INTO mar_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","याकोबाने पदन-अरामपासून सुरू केलेला प्रवास कनान देशातील शखेम शहरात सुखरूपपणे संपवला. त्या नगराजवळ त्याने आपला तळ दिला. ");
INSERT INTO mar_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","नंतर त्याने जेथे आपला तंबू ठोकला होता ती जमीन शखेमाचा बाप हमोर याच्या लोकांकडून शंभर चांदीची नाणी देऊन विकत घेतली. ");
INSERT INTO mar_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","त्याने तेथे एक वेदी बांधली आणि तिचे नाव “एल-एलोहे-इस्राएल” असे ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","याकोबापासून लेआस झालेली मुलगी दीना ही त्या देशातील मुलींना भेटण्यास बाहेर गेली. ");
INSERT INTO mar_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","तेव्हा त्या देशाचा राजा हमोर हिव्वी याचा मुलगा शखेम याने तिला पाहिले तो तिला घेऊन गेला, आणि तिच्यापाशी निजून त्याने तिला भ्रष्ट केले. ");
INSERT INTO mar_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","याकोबाची मुलगी दीना हिच्याकडे तो आकर्षित झाला. त्या मुलीवर त्याचे प्रेम जडले आणि तो प्रेमळपणे तिच्याशी बोलला. ");
INSERT INTO mar_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","शखेमाने आपला बाप हमोर ह्याला म्हटले, “ही मुलगी मला पत्नी करून द्या.” ");
INSERT INTO mar_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","आपली मुलगी दीना हिला त्याने भ्रष्ट केले हे याकोबाने ऐकले. परंतु त्याची सर्व मुले गुराढोरांबरोबर रानात होती म्हणून ते घरी येईपर्यंत याकोब शांतच राहिला. ");
INSERT INTO mar_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","शखेमाचा बाप हमोर बोलणी करण्यासाठी याकोबाकडे गेला. ");
INSERT INTO mar_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","जे काही घडले ते याकोबाच्या मुलांनी रानात ऐकले आणि ते परत आले. ती माणसे दुखावली गेली होती. त्यांचा राग भडकला होता, कारण याकोबाच्या मुलीवर शखेमाने बळजबरी करून इस्राएलाला काळिमा लावला, जे करू नये ते त्याने केले होते. ");
INSERT INTO mar_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","हमोर त्यांच्याशी बोलला. तो म्हणाला, “माझा मुलगा शखेम तुमच्या मुलीवर प्रेम करतो. मी तुम्हास विनंती करतो की ती त्यास पत्नी म्हणून द्या. ");
INSERT INTO mar_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","आमच्या बरोबर सोयरीक करा, तुमच्या मुली आम्हांला द्या, आणि आमच्या मुली तुमच्यासाठी घ्या. ");
INSERT INTO mar_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","तुम्ही आमच्या बरोबर राहा, आणि हा देश राहण्यास व व्यापार करण्यास तुमच्यापुढे मोकळा असेल, आणि त्यामध्ये मालमत्ता घ्या.” ");
INSERT INTO mar_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","शखेम तिच्या बापाला व तिच्या भावांना म्हणाला, “माझ्यावर तुमची कृपादृष्टी व्हावी म्हणून तुम्ही जे काही मागाल ते मी जरुर देईन. ");
INSERT INTO mar_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","माझ्याकडे वधूबद्दल मोठी किंमत मागा, जे काही तुम्ही मागाल ते मी तुम्हास देईन, परंतु ही मुलगी मला पत्नी म्हणून द्या.” ");
INSERT INTO mar_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","त्यांची बहीण दीना हिला शखेमाने भ्रष्ट केले होते, म्हणून याकोबाच्या मुलांनी शखेम व त्याचा बाप हमोर यांना कपटाने उत्तर दिले. ");
INSERT INTO mar_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ते त्यास म्हणाले, “ज्याची अद्याप सुंता झालेली नाही अशा मनुष्यास आम्ही आमची बहीण देऊ शकत नाही; त्यामुळे आम्हांला कलंक लागेल. ");
INSERT INTO mar_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","पण फक्त या एकाच अटीवर आम्ही तुझ्याशी सहमत होऊ: तुम्हा सर्वांची आमच्याप्रमाणे सुंता झाली पाहिजे, जर तुमच्यातील प्रत्येक पुरुषाची सुंता झाली तरच ");
INSERT INTO mar_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","आम्ही आमच्या मुली तुम्हास देऊ व तुमच्या मुली आम्ही करू आणि आम्ही तुम्हामध्ये राहू आणि आपण सर्व एक लोक होऊ. ");
INSERT INTO mar_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","पण जर तुम्ही आमचे ऐकणार नाही आणि सुंता करावयास नकार द्याल तर मग मात्र आमच्या बहिणीला घेऊ आणि निघून जाऊ.” ");
INSERT INTO mar_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","त्यांच्या शब्दाने हमोर व शखेम यांना फार आनंद झाला. ");
INSERT INTO mar_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","त्यांनी जे सांगितले होते ते करण्यास त्या तरुणाने उशीर केला नाही, कारण याकोबाच्या मुलीवर त्याचे मन बसले होते, आणि तो त्यांच्या वडिलाच्या घराण्यात सर्वांत आदरणीय होता. ");
INSERT INTO mar_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","हमोर व शखेम त्या नगराच्या वेशीपाशी गेले व नगरातील लोकांशी बोलले, ते म्हणाले, ");
INSERT INTO mar_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ही माणसे आपल्याशी शांतीने वागतात, म्हणून त्यांना आपणामध्ये आपल्या देशात राहू द्यावे आणि त्यामध्ये व्यापार करू द्यावा. खरोखरच, त्यांना पुरेल एवढा आपला देश मोठा आहे. त्यांच्या मुली आपण स्त्रिया करून घेऊ, आणि आपण आपल्या मुली त्यांना देऊ. ");
INSERT INTO mar_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","फक्त एकाच अटीवर ते लोक आपल्यासोबत राहायला आणि आपल्यासोबत एक व्हायला तयार आहेत: ती म्हणजे आपण सगळ्या पुरुषांनी त्या लोकांप्रमाणे सुंता करून घेण्याचे मान्य केले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","जर हे आपण करू तर मग त्यांची सर्व शेरडेमेंढरे गुरेढोरे व संपत्ती आपलीच होणार नाहीत काय? म्हणून आपण त्यांच्याशी सहमत होऊ, आणि मग ते आपल्या बरोबर येथेच वस्ती करून राहतील.” ");
INSERT INTO mar_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","तेव्हा वेशीतून येणाऱ्या सर्वांनी हे ऐकले व हमोर आणि शखेम यांचे म्हणणे मान्य केले. त्या वेळी तेथील सर्व पुरुषांनी सुंता करून घेतली. ");
INSERT INTO mar_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीन दिवसानंतर, सुंता केलेले लोक जखमांच्या वेदनांनी बेजार झालेले असताना, याकोबाची दोन मुले शिमोन व लेवी म्हणजे दीनाचे भाऊ यांनी आपआपली तलवार घेतली व ते नगर बेसावध असता त्यांनी तेथील सर्व पुरुषांना ठार मारले. ");
INSERT INTO mar_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","त्यांनी हमोर व त्याचा मुलगा शखेम यांनाही ठार मारले. नंतर दीनाला शखेमाच्या घरातून बाहेर काढून ते तिला घेऊन तेथून निघाले. ");
INSERT INTO mar_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","नंतर याकोबाची सर्व मुले नगरात गेली आणि त्यांनी तेथील सर्व चीजवस्तू लुटल्या, कारण त्यांनी त्यांच्या बहिणीला भ्रष्ट केले होते. ");
INSERT INTO mar_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","तेव्हा त्यांनी त्या लोकांची शेरडेमेंढरे, गुरेढोरे, गाढवे इत्यादी सर्व जनावरे आणि घरातील व शेतांतील सर्व वस्तू लुटल्या. ");
INSERT INTO mar_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","तसेच त्यांनी तेथील लोकांच्या मालकीची धनदौलत, मालमत्ता व सर्व चीजवस्तू आणि त्यांच्या स्त्रिया व मुलेबाळे देखील घेतली. ");
INSERT INTO mar_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","परंतु याकोब, शिमोन व लेवी यांना म्हणाला, “तुम्ही मला खूप त्रास देऊन संकटात टाकले आहे; आता या देशाचे रहिवासी कनानी व परिज्जी माझा द्वेष करतील व माझ्या विरूद्ध उठतील. आपण थोडकेच लोक आहोत. या देशातील सर्व लोक एकत्र होऊन आपल्या विरूद्ध जर लढावयास आले तर मग माझ्याजवळच्या आपल्या सर्वांचा माझ्याबरोबर नाश केला जाईल.” ");
INSERT INTO mar_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","परंतु शिमोन आणि लेवी म्हणाले, “शखेमाने आमच्या बहिणीशी वेश्येशी वागतात तसे वागावे काय?” ");
INSERT INTO mar_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","देव याकोबाला म्हणाला, “ऊठ, बेथेल नगरामध्ये जा आणि तेथे राहा. तुझा भाऊ एसाव याजपासून तू पळून जात असताना ज्याने तुला दर्शन दिले, त्या देवासाठी तेथे एक वेदी बांध.” ");
INSERT INTO mar_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","तेव्हा याकोब आपल्या घरातील सर्व मंडळीला व आपल्याबरोबरच्या सगळ्यांना म्हणाला, “तुमच्याजवळ असलेल्या परक्या देवांचा त्याग करा. तुम्ही स्वतःला शुद्ध करा. आपले कपडे बदला. ");
INSERT INTO mar_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","नंतर आपण येथून निघून बेथेलास जाऊ. मी दुःखात असताना ज्याने मला उत्तर दिले आणि जेथे कोठे मी गेलो तेथे जो माझ्याबरोबर होता, त्या देवासाठी मी वेदी बांधीन.” ");
INSERT INTO mar_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","तेव्हा त्या लोकांनी त्यांच्या हातातले सर्व परके देव आणि आपल्या कानातील कुंडलेही आणून याकोबाला दिली. तेव्हा याकोबाने त्या सर्व वस्तू शखेम नगराजवळील एला झाडाच्या खाली पुरून टाकल्या. ");
INSERT INTO mar_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ते तेथून निघाले, त्यांच्या सभोवतालच्या नगरावर देवाने भीती उत्पन्न केली, म्हणून त्यांनी याकोबाच्या मुलांचा पाठलाग केला नाही. ");
INSERT INTO mar_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","अशा रीतीने याकोब व त्याच्याबरोबरचे सर्व लोक कनान देशात लूज येथे येऊन पोहचले त्यालाच आता बेथेल म्हणतात. ");
INSERT INTO mar_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","त्याने तेथे एक वेदी बांधली, व त्या ठिकाणाचे नाव “एल-बेथेल” असे ठेवले. कारण आपला भाऊ एसाव याजपासून पळून जाताना याच जागी प्रथम देवाने त्यास दर्शन दिले होते. ");
INSERT INTO mar_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","रिबकेची दाई दबोरा या ठिकाणी मरण पावली तेव्हा त्यांनी तिला बेथेल येथे अल्लोन झाडाच्या खाली पुरले; त्या जागेचे नाव त्यांनी अल्लोन बाकूथ म्हणजे रडण्याचे अल्लोन असे ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","याकोब पदन-अराम येथून परत आला, तेव्हा देवाने त्यास पुन्हा दर्शन दिले आणि त्यास आशीर्वाद दिला. ");
INSERT INTO mar_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","देव त्यास म्हणाला, “तुझे नाव याकोब आहे, परंतु तुला आता याकोब म्हणणार नाहीत तर तुझे नवे नाव इस्राएल असे होईल.” म्हणून देवाने त्यास इस्राएल हे नाव दिले. ");
INSERT INTO mar_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","देव त्यास म्हणाला, “मी सर्व सर्वसमर्थ देव आहे. तू फलद्रूप आणि बहुगुणित हो. तुझ्यातून एक राष्ट्र आणि राष्ट्रांचा समुदाय येईल व तुझ्या वंशजातून राजे जन्मास येतील. ");
INSERT INTO mar_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","मी अब्राहाम व इसहाक यांना जो देश दिला, तो आता मी तुला व तुझ्यामागे राहणाऱ्या तुझ्या संततीला देतो.” ");
INSERT INTO mar_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","मग देव ज्या ठिकाणी त्याच्याशी बोलला तेथूनच वर निघून गेला. ");
INSERT INTO mar_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","मग याकोबाने तेथे स्मारक म्हणून दगडाचा एक स्तंभ उभा केला त्याने त्यावर पेयार्पण व तेल ओतले. ");
INSERT INTO mar_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","जेथे देवाने याकोबाशी भाषण केले होते त्या स्थानाचे नाव याकोबाने बेथेल ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","मग ते बेथेल येथून पुढे निघाले, ते एफ्राथ गावापासून काही अंतरावर आले असताना तेथे राहेलीस प्रसूतीवेदना सुरू झाल्या. तिला प्रसुतीच्या असह्य वेदना होत होत्या. ");
INSERT INTO mar_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","राहेलीस प्रसूतीवेदनांचा अतिशय त्रास होत असताना, राहेलीची सुईण तिला म्हणाली, “भिऊ नकोस कारण तुला हाही मुलगाच होईल.” ");
INSERT INTO mar_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","त्या मुलाला जन्म देताना राहेल मरण पावली, परंतु मरण्यापूर्वी तिने त्याचे नाव बेनओनी असे ठेवले, परंतु त्याच्या वडिलाने त्याचे नाव बन्यामीन असे ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","राहेल मरण पावली. एफ्राथ (म्हणजे बेथलहेम) गावास जाणाऱ्या वाटेजवळ राहेलीस पुरले. ");
INSERT INTO mar_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","आणि याकोबाने तिचे स्मारक म्हणून तिच्या कबरेवर एक स्तंभ उभा केला. तो स्तंभ आजपर्यंत तेथे कायम आहे. ");
INSERT INTO mar_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","त्यानंतर इस्राएल पुढे गेला आणि मिगदाल-एदेरच्या पलीकडे त्याने तळ दिला. ");
INSERT INTO mar_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","इस्राएल त्या देशात राहत होता, त्या वेळी रऊबेन, आपल्या पित्याची उपपत्नी बिल्हा हिच्यापाशी निजला, हे इस्राएलाने ऐकले. याकोबाला बारा पुत्र होते. ");
INSERT INTO mar_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","त्यास लेआपासून झालेले पुत्र: याकोबाचा ज्येष्ठ मुलगा रऊबेन आणि शिमोन, लेवी, यहूदा, इस्साखार व जबुलून. ");
INSERT INTO mar_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","त्यास राहेलीपासून झालेले पुत्र: योसेफ व बन्यामीन. ");
INSERT INTO mar_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","त्यास राहेलीची दासी बिल्हापासून झालेले पुत्र: दान व नफताली. ");
INSERT INTO mar_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","आणि लेआची दासी जिल्पा हिचे पुत्र गाद व आशेर. हे सर्व याकोबाचे पुत्र जे त्यास पदन-अरामात झाले. ");
INSERT INTO mar_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","याकोब मग किर्याथ-आर्बा (म्हणजे हेब्रोन) येथीन मम्रे या ठिकाणी आपला बाप इसहाक याजकडे आला. येथेच अब्राहाम व इसहाक हे राहिले होते. ");
INSERT INTO mar_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक एकशे ऐंशी वर्षे जगला. ");
INSERT INTO mar_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","इसहाकाने शेवटचा श्वास घेतला आणि मरण पावला, आणि आपल्या पूर्वजास मिळाला, तो म्हातारा व आयुष्याचे पूर्ण दिवस होऊन मरण पावला. त्याचे पुत्र एसाव व याकोब यांनी त्यास पुरले. ");
INSERT INTO mar_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव म्हणजे अदोम याची वंशावळ ही, ");
INSERT INTO mar_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसावाने कनानी मुलींतून स्त्रिया करून घेतल्या, एलोन हित्ती याची मुलगी आदा, सिबोन हिव्वी ह्याची नात म्हणजे अनाची मुलगी अहलीबामा ");
INSERT INTO mar_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","आणि इश्माएलाची मुलगी नबायोथाची बहीण बासमथ. ");
INSERT INTO mar_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","एसावापासून आदेला झालेल्या मुलाचे नाव अलीपाज व बासमथला झालेल्या मुलाचे नाव रगुवेल होते. ");
INSERT INTO mar_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","आणि अहलीबामेस, यऊश, यालाम व कोरह हे झाले. हे एसावाचे पुत्र त्यास कनान देशात झाले. ");
INSERT INTO mar_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","एसाव आपल्या स्त्रिया, आपली मुले, आपल्या मुली आणि आपल्या घरातील सर्व माणसे, आपली गुरेढोरे, आपली सर्व जनावरे, आणि आपली सर्व मालमत्ता जी त्याने कनान देशात जमा केली होती हे सर्व घेऊन आपला भाऊ याकोब ह्याच्या पूर्वेकडील देशात गेला. ");
INSERT INTO mar_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","कारण त्यांची मालमत्ता इतकी वाढली होती की त्यांना एकत्र राहता येईना. ज्या देशात ते राहत होते त्यामध्ये त्यांच्या गुरांढोरांचा निर्वाह होईना. ");
INSERT INTO mar_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","एसाव सेईरच्या डोंगराळ प्रदेशात वस्ती करून राहिला. एसावाला अदोमसुद्धा म्हणतात. ");
INSERT INTO mar_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेईरच्या डोंगराळ प्रदेशात राहणाऱ्या अदोमी लोकांचा पूर्वज एसाव याची ही वंशावळ: ");
INSERT INTO mar_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसावाच्या मुलांची नावे: एसाव व आदा यांचा मुलगा अलीपाज आणि एसाव व बासमथ यांचा मुलगा रगुवेल. ");
INSERT INTO mar_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","अलीपाजचे पुत्र तेमान, ओमार, सपो, गाताम व कनाज. ");
INSERT INTO mar_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","अलीपाज याची तिम्ना नावाची एक उपपत्नी होती, तिला अलीपाजापासून अमालेक झाला. ही एसावाची पत्नी आदा हिची नातवंडे होती. ");
INSERT INTO mar_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रगुवेलाचे हे पुत्र होते: नहाथ, जेरह, शाम्मा व मिज्जा. ही एसावाची पत्नी बासमथ हिची नातवंडे होती. ");
INSERT INTO mar_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","सिबोनाची मुलगी अना याची मुलगी व सिबोनाची नात अहलीबामा ही एसावाची पत्नी होती. यऊश, यालाम व कोरह हे तिला एसावापासून झाले. ");
INSERT INTO mar_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसावाचे वंशज आपापल्या कुळांचे सरदार झाले ते हे: एसावाचा पहिला मुलगा अलीपाज, त्याचे पुत्र: तेमान, ओमार, सपो, कनाज, ");
INSERT INTO mar_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम व अमालेक. आपापल्या कुळांचे हे सरदार अलीपाजला अदोम देशात झाले. ही आदेची नातवंडे होती. ");
INSERT INTO mar_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसावाचा मुलगा रगुवेल याचे पुत्र हे: सरदार नहाथ, सरदार जेरह, सरदार शम्मा, सरदार मिज्जा. हे सर्व सरदार रगुवेलास अदोम देशात झाले. एसावाची पत्नी बासमथ हिची ही नातवंडे होती. ");
INSERT INTO mar_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसावाची पत्नी अहलीबामा हिचे पुत्र: यऊश, यालाम व कोरह. हे सरदार एसावाची पत्नी, अनाची मुलगी अहलीबामा हिला झाले. ");
INSERT INTO mar_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","हे एसावाचे पुत्र होते, आणि हे त्यांचे वंश होते. ");
INSERT INTO mar_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","त्या देशात सेईर नावाच्या होरी मनुष्याचे पुत्र हे: लोटान, शोबाल, सिबोन, अना, ");
INSERT INTO mar_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसर व दिशान. हे अदोम देशात सेईराचे पुत्र होरी वंशातील आपापल्या कुळांचे सरदार झाले. ");
INSERT INTO mar_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोटानाचे पुत्र होते होरी व हेमाम, आणि तिम्ना ही लोटानाची बहीण होती. ");
INSERT INTO mar_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबालाचे पुत्र: अलवान, मानहाथ, एबाल, शपो व ओनाम. ");
INSERT INTO mar_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोनाचे दोन पुत्र होते: अय्या व अना. आपला बाप सिबोन याची गाढवे राखीत असता ज्याला डोंगरात गरम पाण्याचे झरे सापडले तोच हा अना. ");
INSERT INTO mar_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अनाचा मुलगा दिशोन व अनाची मुलगी अहलीबामा. ");
INSERT INTO mar_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोनाचे हे पुत्र होते: हेम्दान, एश्बान, यित्रान व करान. ");
INSERT INTO mar_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसराला बिल्हान, जावान व अकान हे पुत्र होते. ");
INSERT INTO mar_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशानाला ऊस व अरान हे पुत्र होते. ");
INSERT INTO mar_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरी कुळांचे जे सरदार झाले त्यांची नावे अशी: लोटान, शोबाल, सिबोन, अना, ");
INSERT INTO mar_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन, एसर व दीशान, सेईर प्रदेशात राहणाऱ्या होरींच्या कुळांचे हे वंशज झाले. ");
INSERT INTO mar_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","इस्राएलावर कोणी राजा राज्य करण्यापूर्वी अदोम देशात जे राजे राज्य करीत होते ते हेच: ");
INSERT INTO mar_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बौराचा मुलगा बेला याने अदोमावर राज्य केले, आणि त्याच्या नगराचे नाव दिन्हाबा होते. ");
INSERT INTO mar_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला मरण पावल्यावर बस्रा येथील जेरहाचा मुलगा योबाब ह्याने राज्य केले. ");
INSERT INTO mar_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब मरण पावल्यावर, तेमानी लोकांच्या देशाचा हुशाम याने राज्य केले. ");
INSERT INTO mar_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","हुशाम मरण पावल्यावर, बदाद याचा मुलगा हदाद याने त्याच्या जागी राज्य केले. यानेच मवाब देशात मिद्यानांचा पराभव केला. त्याच्या नगराचे नाव अवीत होते. ");
INSERT INTO mar_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदाद मरण पावल्यावर मास्रेका येथील साम्ला याने त्या देशावर राज्य केले. ");
INSERT INTO mar_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","साम्ला मरण पावल्यावर फरात नदीवर असलेल्या रहोबोथ येथील शौल याने त्या देशावर राज्य केले. ");
INSERT INTO mar_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शौल मरण पावल्यावर अकबोराचा मुलगा बाल-हानान याने त्या देशावर राज्य केले. ");
INSERT INTO mar_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","बाल-हानान मरण पावल्यावर हदार याने त्या देशावर राज्य केले. त्याच्या नगराचे नाव पाऊ होते. त्याच्या पत्नीचे नाव महेटाबेल होते. ही मात्रेद हिची मुलगी मेजाहाब हिची नात होती. ");
INSERT INTO mar_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एसावाच्या वंशातील कुळांप्रमाणे त्या त्या कुळांच्या सरदारांची नावे: तिम्ना, आल्वा, यतेथ, ");
INSERT INTO mar_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","अहलीबामा, एला, पीनोन, ");
INSERT INTO mar_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनाज, तेमान, मिब्सार, ");
INSERT INTO mar_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","माग्दीएल, व ईराम. ह्यातील प्रत्येक कूळ त्या कुळाचे नाव दिलेल्या प्रदेशात राहिले. अदोमी यांचा बाप एसाव याचा हा विस्तार आहे. ");
INSERT INTO mar_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकोब कनान देशात जेथे त्याचा बाप वस्ती करून राहिला होता त्या देशात राहिला. ");
INSERT INTO mar_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकोबासंबंधीच्या घटना या आहेत. योसेफ सतरा वर्षांचा तरुण होता. आपल्या भावांबरोबर तो कळप सांभाळीत असे. तो आपल्या वडिलाच्या स्त्रिया बिल्हा व जिल्पा यांच्या मुलांबरोबर होता. त्या भावांनी केलेल्या वाईट गोष्टीविषयी त्याने आपल्या बापाला सांगितले. ");
INSERT INTO mar_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","इस्राएल सर्व मुलांपेक्षा योसेफावर अधिक प्रीती करीत असे कारण तो त्याचा म्हातारपणाचा मुलगा होता. त्याने योसेफाला एक सुंदर पायघोळ झगा बनवून दिला होता. ");
INSERT INTO mar_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","आपला बाप आपल्या इतर भावांपेक्षा योसेफावर अधिक प्रीती करतो हे त्याच्या भावांना दिसले म्हणून ते त्याचा द्वेष करीत आणि त्याच्याशी प्रेमाने बोलत नसत. ");
INSERT INTO mar_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","योसेफास एक स्वप्न पडले. त्याने ते स्वप्न आपल्या भावांना सांगितले. त्यानंतर तर त्याचे भाऊ त्याचा अधिकच द्वेष करू लागले. ");
INSERT INTO mar_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","तो त्यांना म्हणाला, “मला पडलेले स्वप्न कृपा करून ऐका: ");
INSERT INTO mar_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","पाहा, आपण सर्वजण शेतात गव्हाच्या पेंढ्या बांधण्याचे काम करीत होतो, तेव्हा माझी पेंढी उठून उभी राहिली आणि तुम्हा सर्वांच्या पेंढ्या तिच्या भोवती गोलाकार उभ्या राहिल्या व त्यांनी माझ्या पेंढीला खाली वाकून नमन केले.” ");
INSERT INTO mar_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","हे ऐकून त्याचे भाऊ त्यास म्हणाले, “तू आमचा राजा होऊन आमच्यावर राज्य करणार काय? आणि खरोखर तू आम्हावर अधिकार करशील काय?” त्याच्या या स्वप्नामुळे व त्याच्या बोलण्यामुळे तर त्याचे भाऊ त्याचा अधिकच द्वेष करू लागले. ");
INSERT INTO mar_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","नंतर योसेफाला आणखी एक स्वप्न पडले. तेही त्याने आपल्या भावांना सांगितले. तो म्हणाला, “पाहा, मला आणखी एक स्वप्न पडले: सूर्य, चंद्र व अकरा तारे यांनी मला खाली वाकून नमन केले.” ");
INSERT INTO mar_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","त्याने आपल्या पित्यासही या स्वप्नाविषयी सांगितले. परंतु त्याच्या वडिलाने त्यास दोष देऊन म्हटले, “असले कसले हे स्वप्न आहे? तुझी आई, तुझे भाऊ व मी आम्ही भूमीपर्यंत लवून तुला नमन करू काय?” ");
INSERT INTO mar_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","योसेफाचे भाऊ त्याचा हेवा करीत राहिले. परंतु त्याच्या वडिलाने ही गोष्ट आपल्या मनात ठेवली. ");
INSERT INTO mar_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","एके दिवशी योसेफाचे भाऊ आपल्या बापाची मेंढरे चारावयास शखेम येथे गेले. ");
INSERT INTO mar_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","इस्राएल योसेफाला म्हणाला, “तुझे भाऊ शखेम येथे आपली मेंढरे चारावयास गेले आहेत ना? चल, मी तुला तेथे पाठवत आहे.” योसेफ त्यास म्हणाला, “मी तयार आहे.” ");
INSERT INTO mar_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","तो त्यास म्हणाला, “आता जा आणि तुझे भाऊ व माझी मेंढरे ठीक आहेत सुखरुप आहेत का? ते पाहा व मला त्यांच्यासंबंधी बातमी घेऊन ये.” अशा रीतीने याकोबाने त्यास हेब्रोनातून शखेमास पाठवले आणि योसेफ शखेमास गेला. ");
INSERT INTO mar_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","योसेफ शेतात भटकत होता. पाहा, तो कोणा मनुष्यास दिसला. त्या मनुष्याने त्यास विचारले, “तू काय शोधत आहेस?” ");
INSERT INTO mar_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","योसेफ म्हणाला, “मी माझ्या भावांना शोधत आहे, ते कोठे कळप चारीत आहेत, हे कृपा करून मला सांगता का?” ");
INSERT INTO mar_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","तो मनुष्य म्हणाला, “ते येथून गेले आहेत. आपण दोथान गावामध्ये जाऊ असे त्यांना बोलताना मी ऐकले.” म्हणून मग योसेफ आपल्या भावांच्या मागे गेला व ते त्यास दोथानात सापडले. ");
INSERT INTO mar_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","त्याच्या भावांनी योसेफाला दुरून येताना पाहिले आणि कट करून त्यास ठार मारण्याचे ठरवले. ");
INSERT INTO mar_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","त्याचे भाऊ एकमेकांना म्हणाले, “हा पाहा, स्वप्ने पाहणारा इकडे येत आहे. ");
INSERT INTO mar_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","आता चला, आपण त्यास ठार मारून टाकू आणि त्यास एका खड्ड्यात टाकून देऊ. आणि त्यास कोणा एका हिंस्र पशूने खाऊन टाकले असे आपल्या बापाला सांगू. मग त्याच्या स्वप्नांचे काय होईल ते आपण पाहू.” ");
INSERT INTO mar_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","रऊबेनाने ते ऐकले आणि त्यास त्यांच्या हातातून सोडवले. तो म्हणाला, “आपण त्यास ठार मारू नये.” ");
INSERT INTO mar_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","रऊबेन त्यांना म्हणाला, “रक्त पाडू नका. त्यास रानातल्या या खड्ड्यात टाका, परंतु त्याच्यावर हात टाकू नका.” आपल्या भावांच्या हातातून सोडवून त्यास त्याच्या बापाकडे परत पाठवून द्यावयाचे असा त्याचा बेत होता. ");
INSERT INTO mar_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","योसेफ त्याच्या भावांजवळ येऊन पोहचला तेव्हा त्यांनी त्याचा सुंदर झगा काढून घेतला. ");
INSERT INTO mar_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","नंतर त्यांनी त्यास एका खोल खड्ड्यात टाकून दिले. तो खड्डा रिकामा होता, त्यामध्ये पाणी नव्हते. ");
INSERT INTO mar_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ते भाकरी खाण्यास खाली बसले. त्यांनी वर नजर करून पाहिले, तो पाहा, इश्माएली लोकांचा तांडा मसाल्याचे पदार्थ व सुगंधी डिंक व बोळ लादलेल्या उंटांसहीत गिलाद प्रदेशाहून येत होता. ते खाली मिसर देशाकडे चालले होते. ");
INSERT INTO mar_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","तेव्हा यहूदा त्याच्या भावांना म्हणाला, “आपल्या भावाला ठार मारून आणि त्याचा खून लपवून ठेवून आपल्याला काय फायदा? ");
INSERT INTO mar_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","चला, आपण त्यास या इश्माएली लोकांस विकून टाकू, आपण आपल्या भावावर हात टाकू नये. कारण तो आपला भाऊ आहे, आपल्याच हाडामांसाचा आहे.” त्याच्या भावांनी त्याचे ऐकले. ");
INSERT INTO mar_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ते मिद्यानी व्यापारी जवळ आल्यावर त्या भावांनी योसेफाला खड्ड्यातून बाहेर काढले व त्या इश्माएली व्यापाऱ्यांना वीस चांदीची नाणी घेऊन विकून टाकले. ते व्यापारी योसेफाला मिसर देशास घेऊन गेले. ");
INSERT INTO mar_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","रऊबेन त्या खड्ड्याकडे परत गेला, तेव्हा पाहा, त्यामध्ये त्यास योसेफ दिसला नाही. त्याने आपली वस्त्रे फाडली. ");
INSERT INTO mar_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","तो भावांकडे येऊन म्हणाला, “मुलगा कोठे आहे? आणि मी, आता मी कोठे जाऊ?” ");
INSERT INTO mar_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","त्यांनी एक बकरा मारला आणि योसेफाचा झगा त्या रक्तात बुडवला. ");
INSERT INTO mar_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","नंतर तो झगा आणून, आपल्या बापाला दाखवून ते म्हणाले, “आम्हांला हा सापडला. हा झगा तुमच्या मुलाचा आहे की काय तो पाहा.” ");
INSERT INTO mar_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","याकोबाने तो ओळखला आणि तो म्हणाला, “हा माझ्याच मुलाचा झगा आहे. हिंस्र पशूने त्यास खाऊन टाकले असावे. माझा मुलगा योसेफ याला हिंस्त्र पशूने खाऊन टाकले आहे यामध्ये संशय नाही.” ");
INSERT INTO mar_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","याकोबाला आपल्या मुलाबद्दल अतिशय दुःख झाले, एवढे की, त्याने आपली वस्त्रे फाडली आणि कंबरेस गोणताट गुंडाळले आणि त्याने पुष्कळ दिवस आपल्या मुलासाठी शोक केला. ");
INSERT INTO mar_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","याकोबाच्या सर्व मुलांनी व मुलींनी त्याचे सांत्वन करण्याचा खूप प्रयत्न केला परंतु तो समाधान पावला नाही. तो म्हणाला, “मी मरेपर्यंत माझ्या मुलासाठी शोक करीत राहीन व अधोलोकात माझ्या मुलाकडे जाईन.” असा त्याचा बाप त्याच्याकरता रडला. ");
INSERT INTO mar_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","त्या मिद्यानी व्यापाऱ्यांनी योसेफाला मिसर देशात पोटीफर नावाचा फारो राजाचा अधिकारी, अंगरक्षकाचा सरदार याला विकून टाकले. ");
INSERT INTO mar_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","त्याच सुमारास यहूदा आपल्या भावांना सोडून अदुल्लाम नगरातील हिरा नावाच्या मनुष्याबरोबर त्याच्या घरी रहावयास गेला. ");
INSERT INTO mar_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","तेथे यहूदाला शूवा नावाच्या एका कनानी मनुष्याची मुलगी भेटली. तेव्हा त्याने तिच्यावर प्रेम केले आणि तिच्याशी लग्न केले. ");
INSERT INTO mar_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ती गरोदर राहिली व तिला मुलगा झाला. त्याने त्याचे नाव एर ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","त्यानंतर ती पुन्हा गरोदर राहिली व तिला मुलगा झाला. तिने त्याचे नाव ओनान ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","त्यानंतर तिला आणखी एक मुलगा झाला आणि त्याचे नाव शेला ठेवले. त्यास जन्म दिला होता तेव्हा ती कजीब नगरामध्ये राहत होती. ");
INSERT INTO mar_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदाने आपला पहिला मुलगा एर याच्यासाठी पत्नी शोधली. तिचे नाव तामार होते. ");
INSERT INTO mar_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","परंतु यहूदाचा प्रथम जन्मलेला मुलगा एर हा परमेश्वराच्या दृष्टीने दुष्ट होता. परमेश्वराने त्यास ठार मारले. ");
INSERT INTO mar_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","मग यहूदा ओनान याला म्हणाला, “तू तुझ्या भावाच्या पत्नीवर प्रेम कर. तिच्याबरोबर दिराचे कर्तव्य पार पाड, आणि तुझ्या भावाकरता तिला संतान होऊ दे.” ");
INSERT INTO mar_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ती मुले आपली होणार नाहीत, हे ओनानला माहीत होते. म्हणून जेव्हा तो त्याच्या भावाच्या पत्नीशी प्रेम करत असे, तेव्हा तो आपले वीर्य बाहेर जमिनीवर पाडत असे, यासाठी की त्यास त्याच्या भावासाठी मूल होऊ नये. ");
INSERT INTO mar_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","त्याने जे केले ते परमेश्वराच्या दृष्टीने वाईट होते, म्हणून परमेश्वराने त्यास मारून टाकले. ");
INSERT INTO mar_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","मग यहूदा आपली सून तामार हिला म्हणाला, “माझा मुलगा शेला लग्नाच्या वयाचा होईपर्यंत तू तुझ्या वडिलाच्या घरी जाऊन तेथे विधवा म्हणून राहा.” कारण त्याने विचार केला, “नाही तर, तोसुद्धा आपल्या दोन भावांप्रमाणे मरून जाईल.” मग तामार आपल्या वडिलाच्या घरी जाऊन राहिली. ");
INSERT INTO mar_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","बऱ्याच काळानंतर यहूदाची पत्नी, म्हणजे शूवाची मुलगी मरण पावली. तिच्यासाठी शोक करण्याचे दिवस संपल्यानंतर यहूदा अदुल्लाम येथील आपला मित्र हिरा याच्याबरोबर आपली मेंढरे कातरायला वर तिम्ना येथे गेला. ");
INSERT INTO mar_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","तेव्हा तामारेला कोणी सांगितले की, “पाहा, तुझा सासरा आपल्या मेंढरांची लोकर कातरवून घेण्याकरता तिम्ना येथे जात आहे.” ");
INSERT INTO mar_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तिने आपली विधवेची वस्त्रे काढली आणि बुरखा घेऊन शरीर लपेटून घेतले. नंतर तिम्नाच्या रस्त्यावर एनाईम नगराच्या वेशीत ती बसून राहिली. कारण तिने पाहिले की, शेला आता प्रौढ झाला असूनही आपल्याला अजून त्याची पत्नी करून दिले नाही. ");
INSERT INTO mar_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","यहूदाने तिला पाहिले, परंतु ती एक वेश्या असावी असे त्यास वाटले. तिने आपले तोंड झाकले होते. ");
INSERT INTO mar_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","तेव्हा यहूदा तिच्याजवळ जाऊन म्हणाला, “मला तुझ्यापाशी निजू दे.” ती आपली सून आहे हे यहूदाला माहीत नव्हते. ती म्हणाली, “तुम्ही मला त्याबद्दल काय मोबदला द्याल?” ");
INSERT INTO mar_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","यहूदा म्हणाला, “मी तुला माझ्या कळपातून एक करडू पाठवून देईन.” ती म्हणाली, “परंतु ते पाठवून देईपर्यंत तुम्ही माझ्याजवळ काय गहाण ठेवाल?” ");
INSERT INTO mar_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","यहूदा म्हणाला, “गहाण म्हणून मी तुझ्याकडे काय ठेवू?” तामार म्हणाली, “तुम्ही अंगठी, गोफ व हातातली काठी मला द्या.” तेव्हा यहूदाने त्या वस्तू तिला दिल्या. मग तो तिजपाशी जाऊन निजला. त्याच्यापासून ती गरोदर राहिली. ");
INSERT INTO mar_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ती उठली आणि निघून गेली. तिने आपला बुरखा काढून टाकला आणि आपली विधवेची वस्त्रे घातली. ");
INSERT INTO mar_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","यहूदाने आपला मित्र अदुल्लामकर ह्याला आपल्या कळपातील करडू घेऊन त्या स्त्रीला तारण म्हणून दिलेल्या वस्तू आणावयास पाठवले, परंतु त्यास ती सापडली नाही. ");
INSERT INTO mar_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","मग अदुल्लामकराने तेथील काही लोकांस विचारले, “येथे या एनाईमाच्या रस्त्यावर एक वेश्या होती ती कोठे आहे?” तेव्हा लोकांनी उत्तर दिले, “येथे कधीच कोणीही वेश्या नव्हती.” ");
INSERT INTO mar_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","तेव्हा यहूदाचा मित्र त्याच्याकडे परत गेला व म्हणाला, “ती वेश्या मला काही सापडली नाही, तेथे राहणारे लोक म्हणाले की, ‘तेथे कोणीही वेश्या कधीच नव्हती.’” ");
INSERT INTO mar_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","यहूदा म्हणाला, “जाऊ दे, त्या वस्तू तिला ठेवून घेऊ दे, नाहीतर आपलीच नालस्ती होईल. मी कबूल केल्याप्रमाणे तिला करडू देण्याचा प्रयत्न केला, परंतु ती आपल्याला सापडली नाही.” ");
INSERT INTO mar_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","या नंतर तीन महिन्यांनी कोणीतरी यहूदाला सांगितले, “तुझी सुन तामार हिने वेश्येप्रमाणे पापकर्म केले आणि त्या व्यभिचारामुळे ती आता गरोदर राहिली आहे.” यहूदा म्हणाला, “तिला बाहेर काढा व जाळून टाका.” ");
INSERT INTO mar_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","जेव्हा तिला बाहेर आणले तिने आपल्या सासऱ्यासाठी एक निरोप पाठवला, “ज्या मनुष्याच्या मालकीच्या या वस्तू आहेत त्याच्यापासून मी गरोदर आहे.” पुढे ती म्हणाली, “ही अंगठी, गोफ आणि काठी कोणाची आहेत ते ओळख.” ");
INSERT INTO mar_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदाने त्या वस्तू ओळखल्या आणि तो म्हणाला, “माझ्यापेक्षा ती अधिक नीतिमान आहे. कारण मी तिला वचन दिल्यानुसार माझा मुलगा शेला याला ती पत्नी म्हणून दिली नाही.” त्यानंतर त्याने तिच्याशी पुन्हा शरीरसंबंध केला नाही. ");
INSERT INTO mar_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","तिच्या प्रसुतीच्या वेळी असे झाले की, पाहा, तिच्या पोटात जुळी मुले होती. ");
INSERT INTO mar_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","प्रसुतीच्या वेळी एका बाळाचा हात बाहेर आला. तेव्हा दाईने त्याच्या हाताला लाल धागा बांधला व ती म्हणाली, “हा आधी जन्मला.” ");
INSERT INTO mar_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","परंतु त्या बाळाने आपला हात आखडून घेतला. त्यानंतर मग दुसरे बाळ प्रथम जन्मले. म्हणून मग ती सुईण म्हणाली, “तू आपल्यासाठी कशी वाट फोडलीस!” आणि त्याचे नाव पेरेस असे ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","त्यानंतर त्याचा भाऊ, ज्याच्या हाताला लाल धागा बांधलेला होता, तो बाहेर आला आणि त्याचे नाव जेरह असे ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","योसेफाला खाली मिसरात आणले. फारो राजाचा एक मिसरी अधिकारी, संरक्षक दलाचा सरदार पोटीफर, याने त्यास इश्माएली लोकांकडून विकत घेतले. ");
INSERT INTO mar_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","परमेश्वर देव योसेफाबरोबर होता. तो यशस्वी पुरुष होता. तो आपल्या मिसरी धन्याच्या घरी राहत असे. ");
INSERT INTO mar_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","परमेश्वर देव त्याच्याबरोबर आहे आणि म्हणून जे काही तो करतो त्या प्रत्येक कामात परमेश्वर देव त्यास यश देतो, हे त्याच्या धन्याला दिसून आले. ");
INSERT INTO mar_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","योसेफावर त्याची कृपादृष्टी झाली. त्याने पोटीफराची सेवा केली. पोटीफराने योसेफाला आपल्या घराचा कारभारी केले आणि त्याचे जे काही स्वतःचे होते ते सर्व त्याच्या ताब्यात दिले. ");
INSERT INTO mar_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","तेव्हा त्याने आपल्या घरात आणि आपले जे काही होते त्या सर्वावर योसेफाला कारभारी केले तेव्हापासून परमेश्वराने योसेफामुळे त्या मिसऱ्याच्या घरास आशीर्वाद दिला. घरात व शेतीत जे काही पोटीफराच्या मालकीचे होते त्या सर्वावर परमेश्वराचा आशीर्वाद होता. ");
INSERT INTO mar_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","पोटीफराने आपल्या घरादाराचा सर्व कारभार योसेफाच्या हवाली केला. तो जे अन्न खात असे, त्या पलीकडे कशाचाही तो विचार करत नव्हता. योसेफ फार देखणा व आकर्षक होता. ");
INSERT INTO mar_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","काही काळानंतर त्याच्या धन्याच्या पत्नीला योसेफाविषयी वासना निर्माण झाली. ती म्हणाली, “माझ्याबरोबर प्रेम कर.” ");
INSERT INTO mar_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","परंतु त्याने नकार दिला. तो त्याच्या धन्याच्या पत्नीला म्हणाला, “पाहा, घरात मी काय करतो याकडे माझा धनी लक्ष देत नाही आणि जे काही त्याचे आहे ते सर्व त्याने माझ्या ताब्यात सोपवले आहे. ");
INSERT INTO mar_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","या घरात माझ्यापेक्षा कोणीही मोठा नाही. तू त्याची पत्नी आहेस म्हणून तुझ्यावाचून त्याने माझ्यापासून काहीही राखून ठेवले नाही. असे असताना, देवाच्याविरूद्ध हे घोर पाप व मोठी दुष्टाई मी कशी करू?” ");
INSERT INTO mar_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ती दररोज योसेफाबरोबर तेच बोलत असे, परंतु त्याने तिच्याबरोबर निजण्यास व प्रेम करण्यास नकार दिला. ");
INSERT INTO mar_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एके दिवशी योसेफ आपले काही काम करण्याकरता आतल्या घरात गेला. तो तेथे अगदी एकटाच होता व घरात दुसरे कोणीही नव्हते. ");
INSERT INTO mar_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","तिने त्याचे वस्त्र धरून त्यास म्हटले “तू माझ्यापाशी नीज.” परंतु तो ते वस्त्र तिच्या हातात सोडून आतल्या घरातून बाहेर पळून गेला. ");
INSERT INTO mar_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","तेव्हा तो त्याचे वस्त्र आपल्या हाती सोडून आणि बाहेर पळून गेला हे तिने पाहिले. ");
INSERT INTO mar_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","आणि तिने हाक मारून तिच्या घरातील मनुष्यांना बोलावले. आणि ती म्हणाली, “पाहा, पोटीफराने या इब्र्याला आमच्या घरच्या मनुष्यांची अब्रू घेण्यासाठी आणून ठेवले आहे. त्याने आत येऊन माझ्यावर बळजबरी करण्याचा प्रयत्न केला. परंतु मी मोठ्याने ओरडले. ");
INSERT INTO mar_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","मी मोठ्याने ओरडले त्यामुळे त्याचे वस्त्र माइयापाशी टाकून तो पळाला आणि बाहेर गेला.” ");
INSERT INTO mar_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","तेव्हा त्याचा धनी घरी येईपर्यंत तिने त्याचे वस्त्र आपल्याजवळ ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","नंतर तिने त्यास सांगितले. ती म्हणाली, “तुम्ही हा जो इब्री घरी आणून ठेवला आहे त्याने माझ्यावर बळजबरी करण्याचा प्रयत्न केला. ");
INSERT INTO mar_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","परंतु तो माझ्याजवळ आल्यावर मी मोठ्याने ओरडले म्हणून तो आपले वस्त्र माझ्याजवळ टाकून बाहेर पळून गेला.” ");
INSERT INTO mar_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","आणि असे झाले की, त्याच्या धन्याने पत्नीचे बोलणे ऐकले, ती त्यास म्हणाली की, “तुझ्या सेवकाने माझ्याशी असे वर्तन केले,” तो खूप संतापला. ");
INSERT INTO mar_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","योसेफाच्या धन्याने त्यास धरले आणि जेथे राजाच्या कैद्यांना कोंडत असत त्या तुरुंगात टाकले. योसेफ त्या तुरुंगात राहिला. ");
INSERT INTO mar_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","परंतु परमेश्वर देव योसेफाबरोबर होता, आणि त्याने त्यास कराराची सत्यता दाखवली. त्याने तुरुंगाच्या अधिकाऱ्याची त्याच्यावर कृपादृष्टी होईल असे केले. ");
INSERT INTO mar_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","त्या अधिकाऱ्याने तुरुंगातील सर्व कैद्यांना योसेफाच्या स्वाधीन केले. ते तेथे जे काही करीत होते, त्याचा योसेफ प्रमुख होता. ");
INSERT INTO mar_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","तुरुंगाचा अधिकारी त्याच्या हाताखालील कोणत्याही कामाबद्दल काळजी करीत नसे. कारण परमेश्वर त्याच्याबरोबर होता. तो जे काही करी, त्यामध्ये परमेश्वर देव त्यास यश देई. ");
INSERT INTO mar_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","या गोष्टीनंतर असे झाले की, फारो राजाचा प्यालेबरदार म्हणजे राजाला द्राक्षरस देणारा आणि आचारी यांनी आपल्या धन्याचा, मिसराच्या राजाचा अपराध केला. ");
INSERT INTO mar_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","फारो राजा त्याच्या या दोन अधिकाऱ्यांवर म्हणजे त्याचा मुख्य प्यालेबरदार व त्याचा मुख्य आचारी यांच्यावर संतापला. ");
INSERT INTO mar_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","आणि त्याने त्यांना पहारेकऱ्यांचा सरदाराच्या वाड्यात, योसेफ कैदेत होता त्या ठिकाणी, तुरुंगात टाकले. ");
INSERT INTO mar_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","तेव्हा पहारेकऱ्यांच्या सरदाराने त्या दोघाही अपराध्यांना योसेफाच्या ताब्यात देऊन त्यांच्यावर लक्ष ठेवण्यास सांगितले. ते दोघे काही काळपर्यंत कैदेत राहिले. ");
INSERT INTO mar_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","मिसरी राजाला प्याला देणारा व त्याचा आचारी हे तुरुंगात असताना, त्या दोघांनाही एकाच रात्री त्यांना लागू पडतील अशी स्वप्ने पडली. ");
INSERT INTO mar_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","दुसऱ्या दिवशी सकाळी योसेफ त्यांच्याकडे गेला. तेव्हा पाहा, ते त्यास दुःखी असलेले दिसले. ");
INSERT INTO mar_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","तेव्हा, त्याच्या धन्याच्या वाड्यात जे फारोचे सेवक त्याच्या बरोबर कैदेत होते, त्यांना त्याने विचारले, “आज तुम्ही असे दुःखी का दिसता?” ");
INSERT INTO mar_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ते त्यास म्हणाले, “आम्हा दोघांनाही रात्री स्वप्ने पडली, परंतु त्यांचा अर्थ सांगणारा कोणी नाही.” योसेफ त्यांना म्हणाला, “स्वप्नांचा अर्थ सांगणे देवाकडे नाही काय? कृपया, आपापले स्वप्न मला सांगा.” ");
INSERT INTO mar_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","तेव्हा राजाला प्याला देणाऱ्या प्यालेबरदाराने योसेफाला आपले स्वप्न सांगितले. तो म्हणाला, “मी माझ्या स्वप्नात पाहिले की, माझ्यासमोर एक द्राक्षवेल आहे. ");
INSERT INTO mar_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","द्राक्षवेलाला तीन फाटे होते. त्या फाट्यांना पाने फुटली व त्यास फुलवरा आला व नंतर त्याच्या घडास पिकलेली द्राक्षे आली. ");
INSERT INTO mar_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","फारो राजाचा प्याला माझ्या हातात होता. तेव्हा मी ती द्राक्षे घेतली आणि फारोच्या त्या प्याल्यात पिळली आणि द्राक्षरसाचा तो प्याला मी फारोच्या हातात दिला.” ");
INSERT INTO mar_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","योसेफ त्यास म्हणाला, “तुझ्या स्वप्नाचा अर्थ मी तुला उलगडून सांगतो. ते तीन फाटे म्हणजे तीन दिवस आहेत. ");
INSERT INTO mar_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","तीन दिवसानी फारो राजा तुझे मस्तक उंचावील व तुला पुन्हा तुझ्या पूर्वीच्या कामावर परत घेईल. तू आतापर्यंत फारोच्या प्यालेबरदाराचे जे काम करीत होतास तेव्हाच्या त्या पहिल्या रीतीप्रमाणे तू फारोचा प्याला त्याच्या हातात देशील. ");
INSERT INTO mar_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","परंतु तुझे चांगले होईल तेव्हा माझी आठवण कर, व कृपा करून फारोला माझ्यासंबंधी सांगून मला या तुरुंगातून बाहेर काढ. ");
INSERT INTO mar_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","कारण मला माझ्या इब्री लोकांच्या देशातून येथे पळवून आणले आहे. मी येथे तुरुंगात रहावे असा कोणाचा काहीच अपराध मी केला नाही.” ");
INSERT INTO mar_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","स्वप्नाचा अर्थ चांगला आहे हे पाहून मुख्य आचाऱ्याने योसेफाला म्हटले, “मलाही एक स्वप्न पडले. आणि पाहा, माझ्या डोक्यावर भाकरीच्या तीन टोपल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","सगळ्यात वरच्या टोपलीत फारो राजासाठी भट्टीत भाजलेली सर्व प्रकारची पक्वान्ने होती, परंतु माझ्या डोक्यावरील त्या टोपलीतील पदार्थ पक्षी खात होते.” ");
INSERT INTO mar_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","योसेफाने उत्तर दिले, “तुझ्या स्वप्नाचा अर्थ मी उलगडून सांगतो, त्या तीन टोपल्या म्हणजे तीन दिवस आहेत. ");
INSERT INTO mar_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","तीन दिवसात फारो राजा तुझे शीर वर करून उडवून टाकील आणि तुला झाडाला टांगील आणि पक्षी तुझे मांस तोडून खातील.” ");
INSERT INTO mar_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","तीन दिवसानंतर फारो राजाचा वाढदिवस होता. तेव्हा त्याने आपल्या सर्व सेवकवर्गाला एक मेजवानी दिली. त्या वेळी त्याने त्याचा आचारी आणि प्यालेबरदाराकडे त्याच्या इतर सेवकांपेक्षा अधिक लक्ष दिले. ");
INSERT INTO mar_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","त्याने प्यालेबरदाराची सुटका केली व त्यास पुन्हा पूर्वीप्रमाणे त्याच्या कामावर ठेवले; आणि प्यालेबरदाराने पुन्हा एकदा प्याला फारो राजाच्या हातात दिला. ");
INSERT INTO mar_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","परंतु, योसेफाने अर्थ सांगितला होता त्याप्रमाणेच त्याने आचाऱ्याला फाशी दिली. ");
INSERT INTO mar_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","पण त्या प्यालेबरदाराला योसेफाची आठवण राहिली नाही. त्यास त्याचा विसर पडला. ");
INSERT INTO mar_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","साधारणपणे दोन वर्षे पूर्ण झाल्यानंतर फारो राजाला स्वप्न पडले. ते असे की, पाहा तो नाईल नदीच्या काठी उभा राहिला होता. ");
INSERT INTO mar_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","तेव्हा पाहा, त्याने सात गाई नाईल नदीतून बाहेर येताना पाहिल्या. त्या धुष्टपुष्ट व सुंदर होत्या. त्या तेथे उभ्या राहून गवतात चरत होत्या. ");
INSERT INTO mar_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","त्यानंतर आणखी सात दुबळ्या व कुरुप गाई नदीतून बाहेर आल्या व नदीच्या किनारी त्या सात धष्टपुष्ट व सुंदर गाईंच्या बाजूला उभ्या राहिल्या. ");
INSERT INTO mar_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","आणि त्या सात दुबळ्या व कुरुप गाईंनी त्या सात सुंदर व धष्टपुष्ट गाईंना खाऊन टाकले. त्यानंतर फारो राजा जागा झाला. ");
INSERT INTO mar_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","मग फारो राजा पुन्हा झोपल्यावर त्यास दुसऱ्यांदा स्वप्न पडले. त्यामध्ये त्याने पाहिले की, एकाच ताटाला सात भरदार कणसे आली. ");
INSERT INTO mar_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","त्यानंतर पाहा, त्या ताटाला सात खुरटलेली व पूर्वेच्या वाऱ्याने करपलेली अशी सात कणसे आली. ");
INSERT INTO mar_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","नंतर त्या सात खुरटलेल्या व करपलेल्या कणसांनी ती सात चांगली व टपोऱ्या दाण्यांची भरदार कणसे गिळून टाकली. तेव्हा फारो पुन्हा जागा झाला आणि ते तर स्वप्न असल्याचे त्यास समजले. ");
INSERT INTO mar_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","दुसऱ्या दिवशी सकाळ झाल्यावर फारो राजा त्या स्वप्नांमुळे चिंतेत पडून बेचैन झाला. त्याने मिसर देशातील जादूगार व ज्ञान्यांना बोलावले. फारोने आपली स्वप्ने त्यांना सांगितली. परंतु त्यांच्यातील कोणालाच त्या स्वप्नांचा अर्थ सांगता आला नाही. ");
INSERT INTO mar_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","तेव्हा प्यालेबरदार फारोस म्हणाला, “आज मला माझ्या अपराधाची आठवण होत आहे. ");
INSERT INTO mar_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","फारो, आपण माझ्यावर व आचाऱ्यावर संतापला होता आणि आपण आम्हांस पहारेकऱ्यांच्या सरदाराच्या वाड्यातील तुरुंगात टाकले होते. ");
INSERT INTO mar_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","तेव्हा तुरुंगात असताना एकाच रात्री मला व त्याला, आम्हा दोघांना स्वप्ने पडली. आम्हांला लागू होतील अशी निरनिराळी स्वप्ने आम्हांला पडली. ");
INSERT INTO mar_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","तेथे कोणी इब्री तरुण आमच्याबरोबर कैदेत होता. तो संरक्षण दलाच्या सरदाराचा दास होता. त्यास आम्ही आमची स्वप्ने सांगितली त्याने त्याचे स्पष्टीकरण केले. त्याने आमच्या प्रत्येकाच्या स्वप्नांचा अर्थ सांगितला. ");
INSERT INTO mar_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","आणि त्याने सांगितलेल्या अर्थाप्रमाणे तसे ते घडले. तो म्हणाला, फारो तुला पूर्वीप्रमाणे कामावर पुन्हा घेईल आणि परंतु दुसऱ्याला फाशी देईल.” ");
INSERT INTO mar_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","मग फारोने योसेफाला बोलावणे पाठवले. तेव्हा त्यांनी त्यास ताबडतोब तुरुंगातून बाहेर आणले. योसेफ दाढी करून व कपडे बदलून फारोकडे आला. ");
INSERT INTO mar_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","मग फारो योसेफास म्हणाला, “मला स्वप्न पडले आहे, परंतु त्याचा अर्थ सांगणारा कोणी नाही. मी तुझ्याविषयी ऐकले की, जेव्हा कोणी तुला स्वप्न सांगतो तेव्हा तू स्वप्नांचा अर्थ सांगतोस.” ");
INSERT INTO mar_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","योसेफाने फारोला उत्तर देऊन म्हणाला, “तसे सामर्थ्य माझ्यामध्ये नाही. देवच फारोला स्वप्नांचा अर्थ सांगेल.” ");
INSERT INTO mar_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","मग फारो योसेफाला म्हणाला, “माझ्या स्वप्नामध्ये मी नाईल नदीच्या काठी उभा होतो. ");
INSERT INTO mar_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","तेव्हा पाहा नदीतून सात धष्टपुष्ट व सुंदर गाई बाहेर आल्या व गवत खाऊ लागल्या असे मी पाहिले. ");
INSERT INTO mar_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","त्यानंतर पाहा, सात दुबळ्या व कुरुप गाई वर आल्या. मी सबंध मिसर देशात त्यांच्यासारख्या बेढब गाई कधीच पाहिल्या नव्हत्या. ");
INSERT INTO mar_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","त्या दुबळ्या व कुरुप गाईंनी आधीच्या धष्टपुष्ट व सुंदर गाई गिळून टाकल्या. ");
INSERT INTO mar_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","तरीही त्या दुबळ्या व कुरुपच राहिल्या, त्यांच्याकडे पाहिल्यावर त्यांनी त्या सात गाई गिळून टाकल्या असे वाटत नव्हते, त्या पूर्वीप्रमानेच कुरुप व दुबळ्या दिसत होत्या मग मी जागा झालो. ");
INSERT INTO mar_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","त्यानंतर माझ्या दुसऱ्या स्वप्नात एकाच ताटाला सात चांगली भरदार व टपोऱ्या दाण्यांची भरगच्च कणसे आली, ");
INSERT INTO mar_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","मग त्यांच्या मागून त्या ताटाला आणखी दुसरी वाळलेली, बारीक व पूर्वेच्या गरम वाऱ्याच्या झळांमुळे करपलेली सात कणसे आली. ");
INSERT INTO mar_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","बारीक कणसांनी ती चांगली सात कणसे गिळून टाकली. ही माझी स्वप्ने मी माझ्या जादुगारांना सांगितली. परंतु त्यांच्यातील कोणालाही त्यांचा उलगडा करून सांगता आले नाही.” ");
INSERT INTO mar_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","मग योसेफ फारोला म्हणाला, “महाराज, या दोन्हीही स्वप्नांचा अर्थ एकच आहे. देव जे काही करणार आहे ते त्याने आपणांस कळविले आहे. ");
INSERT INTO mar_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","त्या सात चांगल्या गाई आणि ती सात चांगली कणसे म्हणजे सात चांगली वर्षे आहेत. स्वप्ने सारखीच आहेत. ");
INSERT INTO mar_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","त्या दुसऱ्या सात दुबळ्या गाई व ती सात सुकलेली व पूर्वेच्या वऱ्याने करपलेली कणसेही म्हणजे अवघ्या देशावर येणाऱ्या दुष्काळाची सात वर्षे आहेत. ");
INSERT INTO mar_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","जी गोष्ट मी फारोला सांगितली ती हीच आहे. जे काय घडणार आहे हे देवाने आपणास दाखवले आहे. ");
INSERT INTO mar_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","पाहा सर्व मिसर देशात सात वर्षांच्या सुबत्तेच्या काळात चांगले व भरपूर पीक येईल. ");
INSERT INTO mar_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","परंतु सुकाळाच्या सात वर्षांनंतर सर्व देशभर दुष्काळाची अशी सात वर्षे येतील की, त्यामुळे मिसर देशाला सुकाळाचा विसर पडेल आणि हा दुष्काळ देशाचा नाश करील. ");
INSERT INTO mar_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","आणि भरपूर धान्य असतानाचे दिवस देशात कसे होते याचा लोकांस विसर पडेल, कारण तो फार भयंकर काळ असेल. ");
INSERT INTO mar_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","तेव्हा फारो महाराज, एकाच गोष्टीविषयी आपणाला दोनदा स्वप्ने पडली, ती यासाठी की, देव हे सर्व लवकरच व नक्की घडवून आणील हे आपणास दाखवावे. ");
INSERT INTO mar_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","तेव्हा, फारोने एखाद्या समंजस व शहाण्या मनुष्याची निवड करून त्यास सर्व मिसर देशावर नेमावे. ");
INSERT INTO mar_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","फारोने हे करावे: देशावर देखरेख करणारे नेमावे. त्यांनी येत्या सात वर्षांच्या सुकाळात मिसरातल्या पिकाचा पाचवा हिस्सा गोळा करून घ्यावा. ");
INSERT INTO mar_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","अशा रीतीने ही जी येणारी चांगली वर्षे, त्यामध्ये सर्व अन्नधान्य गोळा करावे. फारोच्या अधिकाराखाली ते धान्य नगरांमध्ये साठवून ठेवावे. त्यांनी त्याची राखण करावी. ");
INSERT INTO mar_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","येणाऱ्या दुष्काळातील सात वर्षांच्या काळात त्या धान्याचा पुरवठा मिसर देशाला करावा. अशा प्रकारे मग दुष्काळाच्या सात वर्षात देशाचा नाश होणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","हा सल्ला फारो राजाच्या दृष्टीने व त्याच्या सर्व सेवकांच्या दृष्टीने चांगला वाटला. ");
INSERT INTO mar_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","फारो त्याच्या सेवकांना म्हणाला, “देवाचा आत्मा ज्याच्यात आहे असा, ह्याच्यापेक्षा अधिक चांगला व योग्य असा दुसरा कोणी मनुष्य सापडेल काय?” ");
INSERT INTO mar_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","तेव्हा फारो योसेफास म्हणाला, “देवाने तुला या सर्व गोष्टी दाखवल्या आहेत, म्हणून तुझ्यासारखा समंजस व शहाणा दुसरा कोणी नाही. ");
INSERT INTO mar_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","तू माझ्या घराचा अधिकारी हो आणि तुझ्या शब्दाप्रमाणे माझे सर्व लोक चालतील. या देशात केवळ राजासनापुरता म्हणून काय तो मी तुझ्यापेक्षा मोठा असेन.” ");
INSERT INTO mar_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","मग फारो योसेफास म्हणाला, “मी तुला सर्व मिसर देशावर नेमले आहे.” ");
INSERT INTO mar_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","मग फारोने राजमुद्रा असलेली आपल्या बोटातील अंगठी योसेफाच्या बोटात घातली; तलम तागाच्या वस्त्राचा पोशाख त्यास घातला आणि त्याच्या गळ्यात एक सोन्याची साखळी घातली. ");
INSERT INTO mar_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","नंतर त्याने त्यास आपल्या दुसऱ्या रथात बसवले. लोक त्याच्यापुढे आरोळी देत चालले “गुडघे टेका.” फारोने त्यास सर्व देशावर नेमले. ");
INSERT INTO mar_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","फारो योसेफाला म्हणाला, “मी फारो आहे, आणि सर्व मिसर देशात तुझ्या हुकुमाशिवाय कोणी आपला हात किंवा पाय हलवू शकणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फारो राजाने योसेफाला “सापनाथ-पानेह” असे दुसरे नाव दिले. फारोने ओन शहराचा याजक पोटीफर याची मुलगी आसनथ ही योसेफाला पत्नी करून दिली. योसेफ सर्व मिसर देशावर अधिकारी झाला. ");
INSERT INTO mar_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","योसेफ मिसर देशाचा राजा फारो याची सेवा करू लागला तेव्हा तो तीस वर्षांचा होता. योसेफाने मिसर देशभर दौरा करून देशाची पाहणी केली. ");
INSERT INTO mar_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सुकाळाच्या सात वर्षात सर्व देशभर भरपूर पीक आले. ");
INSERT INTO mar_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","योसेफाने सुकाळाच्या सात वर्षात अन्नधान्य गोळा करून नगरोनगरी साठवून ठेवले. त्याने प्रत्येक नगराभोवतालच्या शेतातले अन्नधान्य त्यामध्येच साठवून ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","योसेफाने जणू काय समुद्राच्या वाळूप्रमाणे अन्नधान्य गोळा करून साठवून ठेवले. ते इतके होते की, त्याने मोजणे सोडले कारण ते मोजमाप करता येत नव्हते. ");
INSERT INTO mar_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","दुष्काळ येण्यापूर्वी योसेफाला, आसनथ जी ओनचा याजक पोटीफर याची मुलगी तिच्या पोटी दोन पुत्र झाले. ");
INSERT INTO mar_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","योसेफाने पाहिल्या मुलाचे नाव मनश्शे ठेवले. कारण तो म्हणाला, “देवाने, मला झालेल्या सर्व कष्टांचा व तसेच माझ्या वडिलाच्या घराचा विसर पडू दिला.” ");
INSERT INTO mar_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","त्याने दुसऱ्या मुलाचे नाव एफ्राईम असे ठेवले, कारण तो म्हणाला, “माझ्या दुःखाच्या भूमीमध्ये देवाने मला सर्व बाबतींत सफल केले.” ");
INSERT INTO mar_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","मिसरमध्ये असलेली भरपुरीची, सुबत्तेची सात वर्षे संपली. ");
INSERT INTO mar_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","सात वर्षांनंतर अगदी योसेफाने सांगितल्याप्रमाणे दुष्काळ पडण्यास सुरुवात झाली. सर्व देशांमध्ये दुष्काळ पडला होता, परंतु मिसरमध्ये मात्र अन्न होते. ");
INSERT INTO mar_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","दुष्काळ पडण्यास सुरुवात झाली, तेव्हा लोकांनी अन्नासाठी फारोकडे ओरड केली. तेव्हा फारो मिसरच्या सर्व लोकांस म्हणाला, “योसेफाला विचारा व तो सांगले ते करा.” ");
INSERT INTO mar_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","संपूर्ण देशामध्ये दुष्काळ पडला होता. योसेफाने सर्व गोदामे उघडली आणि मिसरच्या लोकांस धान्य विकत दिले. मिसरमध्ये फार कडक दुष्काळ पडला होता. ");
INSERT INTO mar_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","सर्व पृथ्वीवरील देशातून लोक धान्य विकत घेण्यासाठी मिसरात योसेफाकडे येऊ लागले, कारण त्या वेळी पृथ्वीच्या सर्व भागांत दुष्काळ पडला होता. ");
INSERT INTO mar_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","मिसरमध्ये धान्य असल्याचे याकोबाला समजले. तेव्हा याकोब आपल्या मुलांना म्हणाला, “तुम्ही एकमेकांकडे असे का बघत बसलात?” ");
INSERT INTO mar_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","“इकडे पाहा, मिसर देशात धान्य आहे असे मी ऐकले आहे. तुम्ही खाली जाऊन आपणासाठी तिकडून धान्य विकत आणा म्हणजे आपण जगू, मरणार नाही.” ");
INSERT INTO mar_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","तेव्हा योसेफाचे दहा भाऊ धान्य विकत घेण्यासाठी मिसरला गेले. ");
INSERT INTO mar_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","याकोबाने, योसेफाचा भाऊ बन्यामीन याला त्याच्या भावाबरोबर पाठवले नाही, कारण तो म्हणाला, “कदाचित त्यास काही अपाय होईल.” ");
INSERT INTO mar_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","कनान देशात फारच तीव्र दुष्काळ पडला होता, पुष्कळ लोक धान्य विकत घ्यावयास मिसराला गेले त्या लोकात इस्राएलाचे पुत्रही होते. ");
INSERT INTO mar_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","त्या वेळी योसेफ मिसरचा अधिपती होता. तो देशातल्या सर्व लोकांस धान्य विकत असे. योसेफाचे भाऊ त्याच्याकडे आले आणि त्यांनी आपली तोंडे भूमीकडे करून खाली वाकून नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","योसेफाने आपल्या भावांना पाहिल्याबरोबर ओळखले, परंतु ते कोण आहेत हे माहीत नसल्यासारखे दाखवून तो त्यांच्याशी कठोरपणाने बोलला. त्याने त्यांना विचारले, “तुम्ही कोठून आला?” त्याच्या भावांनी उत्तर दिले, “महाराज, आम्ही कनान देशातून धान्य विकत घेण्यासाठी आलो आहो.” ");
INSERT INTO mar_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","योसेफाने आपल्या भावांना ओळखले, परंतु त्यांनी त्यास ओळखले नाही. ");
INSERT INTO mar_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","आणि मग योसेफाला आपल्या भावांविषयी पडलेली स्वप्ने आठवली. तो त्यांना म्हणाला, “तुम्ही हेर आहात. तुम्ही धान्य खरेदी करण्यास नव्हे तर आमच्या देशाचा कमजोर भाग हेरण्यास आला आहात.” ");
INSERT INTO mar_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","परंतु त्याचे भाऊ म्हणाले, “आमचे धनी, तसे नाही. आम्ही आपले दास अन्नधान्य विकत घ्यावयास आलो आहोत. ");
INSERT INTO mar_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","आम्ही सर्व भाऊ एका पुरुषाचे पुत्र आहोत. आम्ही प्रामाणिक माणसे आहोत. आम्ही तुमचे दास हेर नाही.” ");
INSERT INTO mar_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","नंतर तो त्यांना म्हणाला, “नाही, तुम्ही आमच्या देशाचा कमकुवत भाग पाहण्यास आलेले आहात.” ");
INSERT INTO mar_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ते म्हणाले, “आम्ही तुमचे दास, बारा भाऊ, कनान देशातील एकाच मनुष्याचे बारा पुत्र आहोत. पाहा, आमचा सर्वांत धाकटा भाऊ घरी बापाजवळ आहे आणि आमच्यातला एक जिवंत नाही.” ");
INSERT INTO mar_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","परंतु योसेफ त्यांना म्हणाला, “मी तुम्हास म्हणालो तसेच आहे; तुम्ही हेरच आहात. ");
INSERT INTO mar_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","यावरुन तुमची पारख होईल. फारोच्या जीविताची शपथ, तुमचा धाकटा भाऊ येथे आल्याशिवाय तुम्हास येथून जाता येणार नाही. ");
INSERT INTO mar_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","तुमच्यातील एकाने मागे घरी जाऊन तुमच्या धाकट्या भावाला येथे घेऊन यावे, आणि तोपर्यंत तुम्ही येथे तुरुंगात रहावे. मग तुम्ही कितपत खरे बोलता हे आम्हांला कळेल. नाही तर फारोच्या जिवीताची शपथ खात्रीने तुम्ही हेर आहात.” ");
INSERT INTO mar_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","मग त्याने त्या सर्वांना तीन दिवस तुरुंगात अटकेत ठेवले. ");
INSERT INTO mar_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तीन दिवसानंतर योसेफ त्यांना म्हणाला, “मी देवाला भितो, म्हणून मी सांगतो तसे करा आणि जिवंत राहा. ");
INSERT INTO mar_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","तुम्ही जर खरेच प्रामाणिक असाल तर मग तुम्हातील एका भावाला येथे तुरुंगात ठेवा व बाकीचे तुम्ही तुमच्या घरच्या मनुष्यांकरिता धान्य घेऊन जा. ");
INSERT INTO mar_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","मग तुमच्या धाकट्या भावाला येथे माझ्याकडे घेऊन या. यावरुन तुम्ही माझ्याशी खरे बोलता किंवा नाही याची मला खात्री पटेल आणि तुम्हास मरावे लागणार नाही.” तेव्हा त्यांनी तसे केले. ");
INSERT INTO mar_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ते एकमेकांना म्हणाले, “खरोखर आपण आपल्या भावाविषयी अपराधी आहोत. कारण आपण त्याच्या जिवाचे दुःख पाहिले तेव्हा त्याने काकुळतीने रडून आपणास विनंती केली, परंतु आपण त्याचे ऐकले नाही. त्यामुळेच आता आपणांस हे भोगावे लागत आहे.” ");
INSERT INTO mar_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","मग रऊबेन त्यांना म्हणाला, “मी तुम्हास म्हणत नव्हतो का की, ‘मुलाविरूद्ध पाप करू नका,’ परंतु तुम्ही ते ऐकले नाही. आता पाहा, त्याचे रक्त तुमच्यापासून मागितले जात आहे.” ");
INSERT INTO mar_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","योसेफ दुर्भाष्यामार्फत आपल्या भावांशी बोलत असल्यामुळे, योसेफाला आपल्या भाषेतील बोलणे कळत असेल असे त्यांना वाटले नाही. ");
INSERT INTO mar_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","म्हणून तो त्यांच्यापासून बाजूला जाऊन रडला. थोड्या वेळाने तो परत त्यांच्याकडे आला आणि त्यांच्याशी बोलला. त्याने शिमोनाला त्यांच्यातून काढून घेतले आणि त्यांच्या नजरेसमोरच त्यास बांधले. ");
INSERT INTO mar_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","मग आपल्या भावांच्या पोत्यात धान्य भरण्यास सांगितले, तसेच त्या धान्याबद्दल त्याच्या भावांनी दिलेला पैसा ज्याच्या त्याच्या पोत्यात भरण्यास सांगितले, आणि त्यांच्या परतीच्या प्रवासात वाटेत खाण्यासाठी अन्नसामग्री देण्यास सेवकांना सांगतिले. त्यांच्यासाठी तसे करण्यात आले. ");
INSERT INTO mar_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","तेव्हा त्या भावांनी ते धान्य आपापल्या गाढवावर लादले व तेथून ते माघारी जाण्यास निघाले. ");
INSERT INTO mar_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ते भाऊ रात्रीच्या मुक्कामासाठी एका ठिकाणी थांबले. तेव्हा त्यांच्यापैकी एकाने त्याच्या गाढवाला थोडेसे धान्य देण्यासाठी आपली गोणी उघडली, तेव्हा त्याने धान्यासाठी दिलेले पैसे त्यास त्या गोणीत आढळले. ");
INSERT INTO mar_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","तेव्हा तो आपल्या इतर भावांना म्हणाला, “पाहा! धान्यासाठी मी दिलेले हे पैसे कोणीतरी पुन्हा माझ्या गोणीत ठेवले आहेत!” तेव्हा ते भाऊ अतिशय घाबरले, ते एकमेकांस म्हणाले, “देव आपल्याला काय करत आहे.” ");
INSERT INTO mar_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ते भाऊ कनान देशास आपला बाप याकोब याजकडे गेले आणि त्यांनी घडलेल्या सर्व गोष्टी त्यास सांगितल्या. ");
INSERT INTO mar_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ते म्हणाले, “त्या देशाचा अधिकारी आमच्याशी कठोरपणाने बोलला. आम्ही हेर आहोत असे त्यास वाटले. ");
INSERT INTO mar_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","परंतु आम्ही हेर नसून प्रामाणिक माणसे आहोत असे त्यास सांगितले. ");
INSERT INTO mar_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","आम्ही त्यास सांगितले की, ‘आम्ही बारा भाऊ एका मनुष्याचे पुत्र आहोत. आमच्यातला एक जिवंत नाही, आणि तसेच धाकटा भाऊ कनान देशात आज आमच्या पित्याजवळ असतो.’ ");
INSERT INTO mar_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","तेव्हा त्या देशाचा अधिकारी आम्हांला म्हणाला, ‘तुम्ही प्रामाणिक लोक आहात हे पटवून देण्याचा एक मार्ग आहे. तो असा की तुम्हातील एका भावास येथे माझ्यापाशी ठेवा. तुम्ही तुमच्या कुटुंबातील मनुष्यांसाठी धान्य घेऊन जा. ");
INSERT INTO mar_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","आणि नंतर तुम्ही तुमच्या धाकट्या भावाला येथे माझ्याकडे घेऊन या. मग तुम्ही खरेच प्रामाणिक माणसे आहात हे मला पटेल. तुम्ही जर खरे बोलत असाल तर मग मी तुमचा भाऊ परत तुमच्या हवाली करीन आणि तुम्ही देशात व्यापार कराल.’” ");
INSERT INTO mar_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","मग ते भाऊ आपापल्या पोत्यातून धान्य काढावयास गेले. तेव्हा प्रत्येकाच्या पोत्यात पैशाची पिशवी मिळाली. त्या पैशाच्या पिशव्या पाहून ते भाऊ व त्यांचा बाप हे अतिशय घाबरले. ");
INSERT INTO mar_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","याकोब त्यांना म्हणाला, “मी माझ्या सर्व मुलांना मुकावे अशी तुमची इच्छा आहे काय? योसेफ नाही. शिमोनही गेला. आणि आता बन्यामिनालाही माझ्यापासून घेऊन जाण्याची तुमची इच्छा आहे.” ");
INSERT INTO mar_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","मग रऊबेन आपल्या पित्यास म्हणाला, “मी जर बन्यामिनाला मागे आणले नाही तर माझे दोन पुत्र तुम्ही मारून टाका. माझ्यावर विश्वास ठेवा. मी खरोखर बन्यामिनाला परत तुमच्याकडे घेऊन येईन.” ");
INSERT INTO mar_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","परंतु याकोब म्हणाला, “मी बन्यामिनाला तुमच्याबरोबर पाठविणार नाही. त्याचा भाऊ मरण पावला आणि तो एकटाच राहिला आहे. ज्या वाटेने तुम्ही जाता तेथे त्यास काही अपाय झाला तर माझे पिकलेले केस अतिशय दुःखाने कबरेत पाठवाल.” ");
INSERT INTO mar_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","कनान देशात दुष्काळ फारच तीव्र पडला होता. ");
INSERT INTO mar_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","असे झाले की, त्यांनी मिसर देशाहून आणलेले सगळे धान्य खाऊन संपल्यावर त्यांचा बाप त्यांना म्हणाला, “तुम्ही पुन्हा जाऊन आपल्याला खाण्यासाठी आणखी धान्य विकत आणा.” ");
INSERT INTO mar_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","परंतु यहूदा त्यास म्हणाला, “त्या देशाच्या अधिकाऱ्याने आम्हांला ताकीद दिली. तो म्हणाला, ‘तुम्ही जर तुमच्या धाकट्या भावाला तुमच्या बरोबर माझ्याकडे आणले नाही तर तुम्ही माझे तोंडदेखील पाहणार नाही.’ ");
INSERT INTO mar_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","तेव्हा तुम्ही भावाला आमच्याबरोबर पाठवत असाल तरच आम्ही खाली जाऊन धान्य विकत आणू. ");
INSERT INTO mar_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","पण तुम्ही त्यास पाठवणार नाही तर मग आम्ही धान्य आणावयास खाली जाणार नाही. तुमच्या धाकट्या भावाशिवाय तुम्ही माझे तोंड पाहणार नाही असे त्या आधिकाऱ्याने आम्हांला बजावून सांगितले आहे.” ");
INSERT INTO mar_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","इस्राएल म्हणाला, “पण तुम्हास आणखी एक भाऊ आहे असे त्या मनुष्यास सांगून तुम्ही माझे असे वाईट का केले?” ");
INSERT INTO mar_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ते म्हणाले, “त्या मनुष्याने आमच्याविषयी व आपल्या परिवाराविषयी बारकाईने विचारपूस केली. त्याने आम्हांला विचारले, ‘तुमचा बाप अजून जिवंत आहे का? तुमचा आणखी दुसरा भाऊ आहे का?’ आम्ही तर त्याच्या या प्रश्नाप्रमाणे त्यास उत्तरे दिली. ‘तुम्ही आपल्या भावाला घेऊन या’ असे सांगेल, हे आम्हांला कुठे माहीत होते?” ");
INSERT INTO mar_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","मग यहूदा आपला बाप इस्राएल याला म्हणाला, “मुलाला माझ्याबरोबर पाठवा. म्हणजे आम्ही जाऊ. मग आपण म्हणजे आम्ही, तुम्ही व आपली मुलेबाळे जिवंत राहू, मरणार नाही. ");
INSERT INTO mar_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","मी त्याची हमी घेतो. त्याच्यासाठी मला जबाबदार धरा. जर मी त्यास परत माघारी तुमच्याकडे आणले नाही तर मी तुमचा कायमचा दोषी होईन. ");
INSERT INTO mar_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","जर आम्ही उशीर केला नसता तर आतापर्यंत नक्कीच आमच्या धान्य आणण्याच्या दोन फेऱ्या झाल्या असत्या.” ");
INSERT INTO mar_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","मग त्यांचा बाप इस्राएल म्हणाला, “जर असे आहे तर आता हे करा, त्या अधिकाऱ्याकरता आपल्या देशातले चांगले निवडक पदार्थ म्हणजे थोडा मध, मसाल्याचे पदार्थ व बोळ, पिस्ते, बदाम, डिंक, गंधरस वगैरे तुमच्या गोण्यांत घेऊन त्यास बक्षीस म्हणून घेऊन जा.” ");
INSERT INTO mar_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","या वेळी दुप्पटीपेक्षा जास्त पैसा तुमच्या हाती घ्या. मागच्या वेळी तुम्ही दिलेला जो पैसा तुमच्या गोण्यामधून परत आला तोही परत घेऊन जा. कदाचित काही चूक झाली असेल. ");
INSERT INTO mar_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","तुमच्या भावालाही बरोबर घ्या. उठा आणि त्या मनुष्याकडे परत जा. ");
INSERT INTO mar_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","“त्या अधिकाऱ्यापुढे तुम्ही जाऊन उभे रहाल तेव्हा सर्वसमर्थ देव तुम्हास साहाय्य करो. यासाठी की, त्याने बन्यामिनाला व शिमोनाला सोडून द्यावे. आणि जर मी माझ्या मुलांना मुकलो, तर मुकलो.” ");
INSERT INTO mar_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","अशा रीतीने त्या मनुष्यांनी भेटवस्तू घेतल्या. त्यांनी त्यांच्या हातात दुप्पट पैसा आणि बन्यामिनाला घेतले. ते उठले आणि खाली मिसरात गेले व योसेफापुढे उभे राहिले. ");
INSERT INTO mar_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","त्या भावांच्याबरोबर योसेफाने बन्यामिनास पाहिले. तेव्हा तो आपल्या कारभाऱ्याला म्हणाला, “या लोकांस माझ्या घरी आण. पशू मारून भोजन तयार कर, कारण हे सर्वजण दुपारी माझ्याबरोबर भोजन करतील.” ");
INSERT INTO mar_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","तेव्हा त्या कारभाऱ्याने त्यास योसेफाने सांगितल्याप्रमाणे भोजनाची सर्व तयारी केली. नंतर त्याने त्या सर्व भावांना योसेफाच्या घरी नेले. ");
INSERT INTO mar_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","योसेफाच्या घरी नेल्यावर ते भाऊ फार घाबरले. ते म्हणाले, “मागच्या वेळी आपल्या गोणीत आपण दिलेले पैसे परत ठेवण्यात आले म्हणून आपणांस येथे आणले आहे, त्यावरून आपणास दोषी ठरवण्याची संधी शोधत आहे. तो आपली गाढवे घेईल व आपल्याला गुलाम करील असे वाटते.” ");
INSERT INTO mar_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","म्हणून मग ते भाऊ योसेफाच्या कारभाऱ्याकडे गेले आणि घराच्या दरवाजाजवळ ते त्याच्याशी बोलू लागले. ");
INSERT INTO mar_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ते म्हणाले, “धनी, मागच्या वेळी आम्ही धान्य खरेदी करण्यासाठीच आलो होतो. ");
INSERT INTO mar_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","आम्ही घरी परत जाताना एका मुक्कामाच्या ठिकाणी आमची पोती उघडली तेव्हा पाहा, प्रत्येक मनुष्याचा पैसा ज्याच्या गोणीत पूर्ण वजनासह जसाच्या तसाच होता. आमच्या पोत्यात पैसे कसे आले हे आम्हांला माहीत नाही. परंतु ते सगळे पैसे तुम्हास परत देण्यासाठी आम्ही आमच्यासोबत आणले आहेत. ");
INSERT INTO mar_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","आणि आता या वेळी आणखी धान्य विकत घेण्यासाठी अधिक पैसे आणले आहेत, आमच्या गोणीत पैसे कोणी ठेवले हे आम्हांला ठाऊक नाही.” ");
INSERT INTO mar_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","परंतु कारभाऱ्याने उत्तर दिले, “तुम्हास शांती असो, भिऊ नका. तुमच्या व तुमच्या पित्याच्या देवाने तुमच्या गोणीत ते पैसे ठेवले असतील. मला तुमचे पैसे मिळाले आहेत.” नंतर त्या कारभाऱ्याने शिमोनाला तुरुंगातून सोडवून घरी आणले. ");
INSERT INTO mar_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","मग त्या कारभाऱ्याने त्या भावांना योसेफाच्या घरी आणले. त्याने त्यांना पाय धुण्यासाठी पाणी दिले व त्यांनी पाय धुतले. मग त्याने त्यांच्या गाढवांना वैरण दिली. ");
INSERT INTO mar_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","आपण योसेफासोबत भोजन करणार आहोत हे त्या भावांनी ऐकले होते. तेव्हा त्यांनी दुपारपर्यंत तयारी करून त्यास देण्याच्या भेटी तयार केल्या. ");
INSERT INTO mar_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","योसेफ घरी आला तेव्हा त्या भावांनी त्याच्यासाठी आपल्यासोबत आणलेली भेट त्याच्या हातात दिली व त्यांनी त्यास भूमीपर्यंत खाली वाकून नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","मग योसेफाने ते सर्व बरे आहेत ना, याची विचारपूस केली. तो म्हणाला, “तुमचा बाप, ज्यांच्याबद्दल तुम्ही मागे मला सांगितले होते, तो बरा आहे का? तो अजून जिवंत आहेत का?” ");
INSERT INTO mar_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","त्यांनी उत्तर दिले, “तुमचा दास, आमचा बाप, सुखरूप आहे. तो अजून जिवंत आहे.” त्यांनी खाली वाकून नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","मग त्याने नजर वर करून आपल्या आईचा मुलगा आपला भाऊ बन्यामीन याला पाहिले. तो म्हणाला, “तुम्ही मला ज्याच्याविषयी सांगितले तो हाच का तुमचा धाकटा भाऊ?” नंतर तो म्हणाला, “माझ्या मुला, देव तुझ्यावर कृपा करो.” ");
INSERT INTO mar_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","मग योसेफ घाईघाईने खोलीबाहेर निघून गेला. आपला भाऊ बन्यामीन याच्यासाठी त्याची आतडी तुटू लागली आणि कोठे तरी जाऊन रडावे असे त्यास वाटले. तो आपल्या खोलीत गेला व तेथे रडला. ");
INSERT INTO mar_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","मग तोंड धुऊन तो परत आला. मग स्वतःला सावरून तो म्हणाला, “जेवण वाढा.” ");
INSERT INTO mar_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","योसेफाला त्यांनी वेगळे व त्याच्या भावांना वेगळे वाढले. मिसरी लोक त्याच्यासोबत तेथे वेगळे असे जेवले, कारण इब्री लोकांबरोबर मिसरी लोक जेवण जेवत नसत, कारण मिसऱ्यांना ते तिरस्कारणीय वाटत असे. ");
INSERT INTO mar_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","त्याच्या भावांना त्याच्यासमोर बसवले, तेव्हा त्यांच्या ज्येष्ठतेच्या क्रमानुसार थोरल्या भावाला प्रथम बसवले, आणि इतरांस त्यांच्या वयांप्रमाणे बसवल्यामुळे ते चकित होऊन एकमेकांकडे पाहू लागले. ");
INSERT INTO mar_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","योसेफाने त्याच्या पुढील पक्वान्नामधून वाटे काढून त्यांना दिले, पण त्याने बन्यामिनाला इतरांपेक्षा पाचपट अधिक वाढले. ते सर्व भरपूर जेवले व मनमुराद पिऊन आनंदीत झाले. ");
INSERT INTO mar_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","मग योसेफाने आपल्या कारभाऱ्याला आज्ञा देऊन म्हटले, “या लोकांच्या गोणीमधे जेवढे अधिक धान्य मावेल व त्यांना नेता येईल तेवढे भर. आणि त्यासोबत प्रत्येकाचे पैसेही त्या पोत्यात ठेव. ");
INSERT INTO mar_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","सर्वांत धाकट्याच्या गोणीत धान्याच्या पैशाबरोबर माझा विशेष चांदीचा प्यालाही ठेव.” योसेफाच्या कारभाऱ्याने त्याच्या आज्ञेप्रमाणे सर्वकाही केले. ");
INSERT INTO mar_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","दुसऱ्या दिवशी अगदी सकाळी त्या भावांना त्यांच्या गाढवांसह त्यांच्या देशाला रवाना करण्यात आले. ");
INSERT INTO mar_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ते नगराबाहेर दूर गेले नाहीत, तोच थोड्या वेळाने योसेफ आपल्या कारभाऱ्याला म्हणाला, “जा आणि त्या लोकांचा पाठलाग कर आणि त्यांना थांबवून असे म्हण, ‘आम्ही तुमच्याशी भलेपणाने वागलो! असे असता तुम्ही आमच्याशी अशा वाईट रीतीने का वागला? तुम्ही माझ्या स्वामीचा चांदीचा प्याला का चोरला? ");
INSERT INTO mar_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","हा प्याला खास माझा धनी पिण्याकरिता वापरतात. तसेच देवाला प्रश्न विचारण्याकरिता उपयोग करतात. हा प्याला चोरून तुम्ही फार वाईट केले आहे.’” ");
INSERT INTO mar_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","तेव्हा त्या कारभाऱ्याने त्यांना गाठून योसेफाने आज्ञा केल्याप्रमाणे तो त्यांच्याशी बोलला. ");
INSERT INTO mar_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","परंतु ते कारभाऱ्याला म्हणाले, “माझे धनी असे का बरे बोलतात? आम्ही कधीच अशा गोष्टी करीत नाही. ");
INSERT INTO mar_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","पाहा, मागे आमच्या गोणीत मिळालेला पैसाही आम्ही कनान देशातून तुमच्याकडे परत आणला. तेव्हा आपल्या धन्याच्या घरातून आम्ही सोने किंवा चांदी कशी चोरणार? ");
INSERT INTO mar_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","या पेक्षा आम्हापैकी कोणाच्या पोत्यात तुम्हास जर तो चांदीचा प्याला मिळाला तर तो भाऊ मरेल. तुम्ही त्यास मारून टाकावे आणि मग आम्ही सर्वजण तुमच्या धन्याचे गुलाम होऊ.” ");
INSERT INTO mar_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","कारभारी म्हणाला, “ठीक आहे, तुम्ही म्हणता त्याप्रमाणे आपण करू. जर मला चांदीचा प्याला मिळाला तर मग तो मनुष्य माझ्या धन्याचा गुलाम होईल. इतरजण जाण्यास मोकळे राहतील.” ");
INSERT INTO mar_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","नंतर प्रत्येक भावाने लगेच आपली गोणी जमिनीवर उतरून उघडली. ");
INSERT INTO mar_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","कारभाऱ्याने थोरल्या भावापासून सुरुवात करून धाकट्या भावाच्या गोणीपर्यंत तपासून पाहिले. तेव्हा त्यास बन्यामिनाच्या गोणीत तो चांदीचा प्याला मिळाला. ");
INSERT INTO mar_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","दुःखामुळे त्यांनी आपली वस्त्रे फाडली आणि आपल्या गोण्या गाढवांवर लादून ते परत नगरात आले. ");
INSERT INTO mar_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","यहूदा व त्याचे भाऊ परत योसेफाच्या घरी गेले. योसेफ अजून घरातच होता. त्या भावांनी योसेफापुढे लोटांगण घातले. ");
INSERT INTO mar_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","योसेफ त्यांना म्हणाला, “तुम्ही असे का केले? मला शकून पाहण्याचे ज्ञान आहे हे तुम्हास माहीत नाही का?” ");
INSERT INTO mar_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदा म्हणाला, “माझ्या धन्याला आम्ही काय बोलावे? किंवा आम्ही अपराधी नाही हे कसे सिद्ध करावे? देवाला तुमच्या सेवकांचा दोष सापडला आहे. म्हणून आता त्याच्यासह आम्ही सर्वजण धन्याचे गुलाम झालो आहोत.” ");
INSERT INTO mar_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","परंतु योसेफ म्हणाला, “मी तुम्हा सर्वजणांना गुलाम करणार नाही. फक्त ज्याने चांदीचा प्याला चोरला तोच माझा गुलाम होईल. बाकीचे तुम्ही शांतीने आपल्या बापाकडे जाऊ शकता.” ");
INSERT INTO mar_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","मग यहूदा योसेफाजवळ जाऊन म्हणाला, “माझे धनी, मी विनंती करतो, तुमच्या सेवकाला कानात बोलू द्या आणि माझ्यावर राग भडकू देऊ नका. आपण फारो राजासमान आहात. ");
INSERT INTO mar_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","माझ्या धन्याने आपल्या सेवकाला विचारले होते, ‘तुम्हास बाप किंवा भाऊ आहे का?’ ");
INSERT INTO mar_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","आणि आम्ही आपल्या धन्याला म्हणालो, होय, आमचा बाप आहे, तो म्हातारा आहे तसेच वडिलाच्या म्हातारपणी झालेला लहान भाऊ आहे. आणि त्याचा भाऊ मरण पावला आहे. त्या आईचा हा एकच मुलगा राहिला आहे. आणि त्याचा बाप त्याच्यावर प्रीती करतो. ");
INSERT INTO mar_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","आणि तुम्ही आपल्या सेवकांना म्हणाला, ‘मग त्यास माझ्याकडे घेऊन या. मला त्यास पाहावयाचे आहे.’ ");
INSERT INTO mar_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","आणि आम्ही स्वामीस म्हणालो, तो मुलगा बापाला सोडून येऊ शकणार नाही, कारण त्याने बापाला सोडले तर आमचा बाप मरून जाईल. ");
INSERT INTO mar_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","परंतु आपण आम्हांला बजावून सांगितले, ‘तुम्ही तुमच्या धाकट्या भावाला घेऊन आलेच पाहिजे नाही, तर तुम्ही माझे तोंड पुन्हा पाहू शकणार नाही.’ ");
INSERT INTO mar_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","मग असे झाले की, आम्ही तुमचा सेवक आमचा बाप याच्याकडे परत गेलो व आमचा धनी जे बोलला ते त्यास सांगितले. ");
INSERT INTO mar_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","आणि आमचा बाप म्हणाला, पुन्हा जाऊन आपणासाठी धान्य विकत आणा. ");
INSERT INTO mar_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","आणि आम्ही म्हणालो, आमच्या धाकट्या भावाला बरोबर घेतल्याशिवाय जाणार नाही, कारण तुमच्या धाकट्या भावाला माझ्याकडे आणल्याखेरीज तुम्हास माझे तोंड पुन्हा पाहता येणार नाही, असे त्या अधिकाऱ्याने आम्हास बजावले आहे. ");
INSERT INTO mar_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","मग तुमचा सेवक आमचा बाप म्हणाला, तुम्हास माहीत आहे की, माझ्या पत्नीच्या पोटी मला दोन पुत्र झाले. ");
INSERT INTO mar_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","आणि त्यातला एक माझ्यापासून दूर निघून गेला आहे आणि मी म्हणालो, खरोखर त्यास वन्य पशूने फाडून तुकडे तुकडे केले आणि तेव्हापासून मी त्यास पाहिले नाही. ");
INSERT INTO mar_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","आणि आता माझ्या या मुलाला तुम्ही माझ्यापासून घेऊन गेला आणि त्यास जर काही अपाय झाला तर तुम्ही माझे पिकलेले केस शोकाने मृतलोकात जायला कारण व्हाल. ");
INSERT INTO mar_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","म्हणून आता तुझा सेवक, माझा बाप याच्याकडे मी गेलो आणि मुलगा माझ्याबरोबर नसला तर याच्या जिवाशी त्याचा जीव जडलेला असल्यामुळे, ");
INSERT INTO mar_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","असे होईल की, मुलगा नाही हे पाहून तो मरून जाईल. आणि तुमचा चाकर, आमचा बाप याचे पिकलेले केस शोकाने मृतलोकात जायला तुझे सेवक कारण होतील. ");
INSERT INTO mar_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","या मुलाबद्दल मी माझ्या पित्यास हमी दिली आहे. मी म्हटले, ‘जर मी त्यास तुमच्याकडे परत घेऊन आलो नाही तर मग जन्मभर मी तुमचा दोषी राहीन.’ ");
INSERT INTO mar_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","म्हणून आता, मी तुम्हास विनंती करतो, मला, तुमच्या या सेवकाला या मुलाच्याऐवजी माझ्या धन्याचा गुलाम म्हणून ठेवून घ्या. मुलाला त्याच्या भावांबरोबर जाऊ द्या. ");
INSERT INTO mar_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","माझ्या बापाकडे मी माघारी कसा जाऊ? माझ्या बापाचे वाईट होईल ते मला पाहावे लागेल याची मला भयंकर भीती वाटते.” ");
INSERT INTO mar_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","आता मात्र योसेफाला आपल्याजवळ जे उभे होते त्या सर्व सेवकांसमोर दुःख रोखून धरता येईना. तो मोठ्याने रडला. तो म्हणाला, “येथील सर्व लोकांस येथून बाहेर जाण्यास सांगा.” तेव्हा तेथील सर्वजण निघून गेले. केवळ त्याचे भाऊच त्याच्यापाशी राहिले. मग योसेफाने आपली ओळख त्यांना दिली. ");
INSERT INTO mar_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","तो मोठ्याने रडला. मिसर देशाच्या लोकांनी व फारो राजाच्या घराण्यातील लोकांनीही त्याचे रडणे ऐकले. ");
INSERT INTO mar_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","मग योसेफ आपल्या भावांना म्हणाला, “मी योसेफ आहे. माझा बाप अजून जिवंत आहे काय?” परंतु त्याचे भाऊ त्यास काही उत्तर देऊ शकले नाहीत. त्याच्या समोर ते फार घाबरले होते. ");
INSERT INTO mar_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","तेव्हा योसेफ आपल्या भावांना म्हणाला, “मी विनंती करतो जरा इकडे माझ्याजवळ या.” तेव्हा ते त्याच्या जवळ गेले. आणि तो त्यांना म्हणाला, “तुमचा भाऊ योसेफ मीच आहे. ज्याला तुम्ही मिसरी लोकांस विकले. ");
INSERT INTO mar_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","आता त्यासाठी काही खिन्न होऊ नका किंवा आपल्या स्वतःवर संताप करून घेऊ नका. मी येथे यावे व त्यामुळे आपणा सर्वांचे प्राण वाचावेत ही देवाचीच योजना होती. ");
INSERT INTO mar_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","हा दुष्काळ आता दोन वर्षे पडला आहे आणि आणखी पाच वर्षे पेरणी किंवा कापणी होणार नाही. ");
INSERT INTO mar_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","देवाने मला तुमच्या आधी येथे पाठवले आहे, यासाठी की, तुमचा पृथ्वीवर बचाव होऊन तुम्ही शेष रहावे आणि तुम्हास जिवंत ठेवून तुमची वंशवृद्धी होऊ द्यावी. ");
INSERT INTO mar_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","मला येथे पाठवण्यात तुमचा दोष नव्हता तर ही देवाची योजना होती. देवाने मला फारोच्या वडिलासमान केले आहे. त्यामुळे मी फारोच्या घरादाराचा धनी आणि सर्व मिसर देशाचा अधिकारी झालो आहे.” ");
INSERT INTO mar_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","योसेफ म्हणाला, “तर आता ताबडतोब माझ्या बापाकडे जाण्यास निघा. त्यास सांगा की, तुमचा मुलगा योसेफ याने तुम्हास संदेश पाठवला आहे. देवाने मला अवघ्या मिसर देशाचा धनी केले आहे. तर माझ्याकडे खाली निघून या. उशीर करू नका. ");
INSERT INTO mar_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","तुम्ही माझ्याजवळ गोशेन प्रांतात राहा. आणि तुम्ही, तुमची मुले, नातवंडे तसेच तुमची शेरडेमेंढरे, गुरेढोरे आणि जे काही तुमचे आहे ते माझ्याजवळ राहील. ");
INSERT INTO mar_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","येणाऱ्या दुष्काळाच्या पाच वर्षात मी तुम्हास सर्व प्रकारचा पुरवठा करीन त्यामुळे तुम्हावर व तुमच्या कुटुंबावर सर्व काही गमावून गरीब होण्याची वेळ येणार नाही. ");
INSERT INTO mar_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","पाहा, माझे तोंड तुम्हाशी बोलत आहे हे तुमचे डोळे, व माझा भाऊ बन्यामीन याचे डोळे पाहत आहेत. ");
INSERT INTO mar_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","मिसर देशातील माझे वैभव आणि तुम्ही येथे जे जे पाहिले आहे त्यासंबंधी माझ्या बापाला सांगा. आता लवकर जाऊन माझ्या बापाला माझ्याकडे खाली घेऊन या.” ");
INSERT INTO mar_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","मग त्याने आपला भाऊ बन्यामीन याला मिठी मारली आणि गळ्यात पडून रडला, आणि बन्यामीनही त्याच्या गळ्यात पडून रडला. ");
INSERT INTO mar_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","मग त्याने आपल्या प्रत्येक भावाला मिठी मारली व त्यांचे मुके घेतले आणि तो रडला. यानंतर त्याचे भाऊ त्याच्याबरोबर बोलू लागले. ");
INSERT INTO mar_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","“योसेफाचे भाऊ त्याजकडे आले आहेत” अशी बातमी फारो, त्याच्या घरची मंडळी व त्याचे सेवक यांना समजली त्यामुळे त्या सर्वांना आनंद झाला. ");
INSERT INTO mar_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","तेव्हा फारो योसेफाला म्हणाला, “तुझ्या भावांना सांग की, ‘तुम्हास गरज असेल तेवढी अन्नसामग्री जनावरांवर लादून कनान देशास जा. ");
INSERT INTO mar_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","तसेच तुमचा बाप आणि तुमच्या घरची सर्व मंडळी यांना घेऊन माझ्याकडे या. तुम्हास रहावयास मिसरमधील सर्वांत उत्तम प्रदेश मी देईन आणि तुमच्या घरातील मंडळी, यांना आमच्या येथे असलेले उत्तम पदार्थ खावयास मिळतील.’ ");
INSERT INTO mar_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","तुला माझी आज्ञा आहे, तू त्यांना सांग की, ‘असे करा, तुमच्या स्त्रिया व तुमची मुले या सर्वांकरिता मिसर देशातून गाड्या घेऊन जा. तुमच्या वडिलांना घेऊन या. ");
INSERT INTO mar_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","तुमची मालमत्ता व जे काही असेल त्याची चिंता करू नका, कारण मिसर देशामधील जे उत्तम ते सर्व तुमचेच आहे.’” ");
INSERT INTO mar_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","तेव्हा इस्राएलाच्या मुलांनी तसे केले. योसेफाने त्यांना फारोने आज्ञा दिल्याप्रमाणे गाड्या दिल्या, आणि त्यांच्या प्रवासाकरिता भरपूर अन्नसामग्री दिली. ");
INSERT INTO mar_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","तसेच त्याने प्रत्येक भावाला एक एक पोशाख दिला व बन्यामिनाला पाच पोशाख आणि चांदीची तीनशे नाणी दिली. ");
INSERT INTO mar_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","त्याने आपल्या वडिलासाठीही या देणग्या पाठवल्या: धान्य, भाकरी, आणि इतर पदार्थांनी लादलेल्या दहा गाढवी त्याच्या वडिलाच्या प्रवासासाठी पाठवल्या. ");
INSERT INTO mar_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","मग योसेफाने आपल्या भावांना निरोप दिला आणि ते निघाले. तो त्यांना म्हणाला, “रस्त्यात एकमेकांशी भांडू नका.” ");
INSERT INTO mar_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","अशा रीतीने त्याचे भाऊ मिसर सोडून कनान देशास आपला पिता याकोब याच्याकडे गेले. ");
INSERT INTO mar_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","त्यांनी आपल्या पित्यास सांगितले, “तुमचा मुलगा योसेफ अजून जिवंत आहे आणि तो अवघ्या मिसर देशाचा अधिकारी आहे.” हे ऐकून त्याचे हृदय विस्मित झाले, कारण त्याचा त्यांच्यावर विश्वास बसला नाही. ");
INSERT INTO mar_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","परंतु त्यांनी त्यास योसेफाने सांगितलेल्या सर्व गोष्टी कळवल्या. मग योसेफाने त्यास मिसरला घेऊन जाण्यासाठी पाठवलेल्या गाड्या याकोबाने पाहिल्या, तेव्हा त्यांचा बाप याकोब संजीवित झाला. ");
INSERT INTO mar_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","इस्राएल म्हणाला, “हे पुरेसे आहे. माझा मुलगा योसेफ अजून जिवंत आहे. आता मी मरण्यापूर्वी त्यास जाऊन भेटेन.” ");
INSERT INTO mar_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","इस्राएलाने, आपले जे काही होते त्याबरोबर प्रवासास सुरुवात केली आणि तो बैर-शेबास गेला. तेथे त्याने आपला बाप इसहाक याच्या देवाला अर्पणे वाहिली. ");
INSERT INTO mar_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","रात्री देव स्वप्नात दर्शन देऊन इस्राएलाशी बोलला, तो म्हणाला, “याकोबा, याकोबा.” त्याने उत्तर दिले, “काय आज्ञा?” ");
INSERT INTO mar_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","तो म्हणाला “मी देव आहे, तुझ्या बापाचा देव आहे. खाली मिसर देशास जाण्यास तू भिऊ नको, कारण मी तुझ्यापासून तेथे एक मोठे राष्ट्र तयार करीन. ");
INSERT INTO mar_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","मी तुझ्याबरोबर खाली मिसरात जाईन, आणि मी तुला मिसरमधून पुन्हा आणीन. आणि योसेफ आपल्या हातांनी तुझे डोळे झाकील.” ");
INSERT INTO mar_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","मग याकोब बैर-शेबाहून उठला. इस्राएलाच्या मुलांनी आपला बाप, आपल्या स्त्रिया व मुले या सर्वांना फारोने पाठवलेल्या गाड्यांतून मिसरला आणले. ");
INSERT INTO mar_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","त्याच प्रमाणे त्यांनी आपली शेरडेमेंढरे, गुरेढोरे आणि कनान देशात त्यांनी मिळवलेले सर्वकाही मिसरला नेले; याप्रमाणे याकोब व त्याची संतती मिसर देशास आली. ");
INSERT INTO mar_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","त्याने आपल्यासोबत आपली मुले व नातू, आपल्या मुली व नाती या सर्व संतानांना मिसरात नेले. ");
INSERT INTO mar_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","इस्राएलाचे जे पुत्र त्याच्याबरोबर मिसरला गेले त्याची नावे अशी: याकोबाचा प्रथम जन्मलेला रऊबेन; ");
INSERT INTO mar_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रऊबेनाचे पुत्र हनोख आणि पल्लू आणि हेस्रोन आणि कर्मी; ");
INSERT INTO mar_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमोनाचे पुत्र यमुवेल, यामीन, ओहाद, याकोन, जोहर आणि कनानी स्त्रीपासून झालेला मुलगा शौल; ");
INSERT INTO mar_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवीचे पुत्र गेर्षोन, कहाथ व मरारी; ");
INSERT INTO mar_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाचे पुत्र एर, ओनान, शेला, पेरेस व जेरह, (परंतु एर व ओनान हे कनान देशात मरण पावले. पेरेसाचे पुत्र हेस्रोन व हामूल), ");
INSERT INTO mar_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साखाराचे पुत्र तोला, पुवा, लोब व शिम्रोन; ");
INSERT INTO mar_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबुलूनाचे पुत्र सेरेद, एलोन व याहलेल ");
INSERT INTO mar_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(याकोबाला लेआपासून पदन-अरामात झालेली सहा मुले व दीना ही मुलगी; त्याच्या कुटुंबात मुले आणि मुली मिळून तेहतीस जण होते), ");
INSERT INTO mar_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गादाचे पुत्र सिफयोन आणि हग्गी, शूनी आणि एसबोन, एरी, अरोदी, आणि अरेली; ");
INSERT INTO mar_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेराचे पुत्र इम्ना आणि इश्वा, इश्वी, आणि बरीया, आणि त्याची बहीण सेराह; आणि बरीयाचे पुत्र हेबर व मलकीएल ");
INSERT INTO mar_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(जिल्पा जी लाबानने आपली मुलगी लेआ हिला दिली होती, तिच्यापासून झालेले हे सगळे याकोबाचे पुत्र होते. ती एकंदर सोळा माणसे होती), ");
INSERT INTO mar_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकोबाची पत्नी राहेल हिचे पुत्र योसेफ व बन्यामीन हे होते; ");
INSERT INTO mar_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","(योसेफास मिसर देशातील ओनचा याजक पोटीफर याची मुलगी आसनथ हिच्या पोटी मनश्शे व एफ्राईम हे पुत्र झाले), ");
INSERT INTO mar_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बन्यामिनाचे पुत्र बेला, बेकेर, आशबेल, गेरा, नामान, एही, रोष, मुप्पीम, हुप्पीम आणि आर्द. ");
INSERT INTO mar_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(याकोबापासून राहेलीस झालेली ही मुले. सर्व मिळून ते सर्व चौदा जण होते), ");
INSERT INTO mar_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","हुशीम हा दान याचा मुलगा होता; ");
INSERT INTO mar_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नफतालीचे पुत्र यासहेल, गुनी, येसेर आणि शिल्लेम हे होते. ");
INSERT INTO mar_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(लाबानाने आपली मुलगी राहेल हिला दिलेल्या बिल्हाचे याकोबापासून झालेले हे पुत्र. हे सर्व मिळून सात जण होते). ");
INSERT INTO mar_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याकोबाच्या वंशातील जी माणसे मिसरमध्ये गेली ती याकोबाच्या मुलांच्या स्त्रिया सोडून सहासष्ट जण होती. ");
INSERT INTO mar_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","योसेफास मिसर देशात झालेले दोन पुत्र मिळून एकंदर याकोबाच्या घराण्यातले सत्तर जण मिसर देशात होते. ");
INSERT INTO mar_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","याकोबाने प्रथम यहूदाला योसेफाकडे पाठवले; यहूदा गोशेन प्रांतात योसेफाकडे गेला त्यानंतर याकोब व त्याच्या परिवारातील सर्व मंडळी यहूदाच्या मागे गोशेन प्रांतात गेली. ");
INSERT INTO mar_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","योसेफास आपला रथ तयार करून आपला बाप इस्राएल याच्या भेटीस गोशेन प्रांतात त्यास सामोरा गेला. योसेफाने आपल्या पित्यास पाहिले तेव्हा त्याने त्याच्या गळ्यास मिठी मारली व त्याच्या गळ्यात गळा घालून तो बराच वेळ रडला. ");
INSERT INTO mar_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","मग इस्राएल योसेफाला म्हणाला, “आता मात्र मला शांतीने मरण येवो, मी तुझे तोंड पाहिले आहे, आणि तू जिवंत आहेस हे मला समजले आहे.” ");
INSERT INTO mar_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","मग योसेफ आपल्या भावांना व आपल्या वडिलाच्या घरच्या सर्वांना म्हणाला, “मी जाऊन फारोला सांगतो की, ‘माझे भाऊ व माझ्या वडिलाच्या घरातील सर्व मंडळी हे कनान देश सोडून येथे माझ्याकडे आले आहेत. ");
INSERT INTO mar_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","माझ्या वडिलाच्या घरचे सर्वजण मेंढपाळ आहेत, ते त्यांची शेरडेमेंढरे व गुरेढोरे पाळत आले आहेत. ते त्यांची शेरडेमेंढरे, गुरेढोरे व त्यांचे तेथे जे काही होते ते सर्व घेऊन आले आहेत.’ ");
INSERT INTO mar_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","जेव्हा फारो राजा तुम्हास बोलावून विचारील, ‘तुम्ही काय काम धंदा करता?’ ");
INSERT INTO mar_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तेव्हा तुम्ही असे सांगा, ‘आम्ही सर्व मेंढपाळ आहोत. हा आमचा पिढीजात धंदा आहे. आमच्या आधी आमचे वाडवडील हाच धंदा करीत होते.’ मग फारो तुम्हास गोशेन प्रांतात राहू देईल. मिसरी लोकांस मेंढपाळ आवडत नाहीत.” ");
INSERT INTO mar_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","योसेफ फारोकडे जाऊन म्हणाला, “माझा बाप माझे भाऊ व त्यांच्या कुटुंबातील सर्व मंडळी कनान देशातून त्यांची शेरडेमेंढरे, गुरेढोरे व त्यांचे सर्वकाही घेऊन येथे आले आहेत. ते गोशेन प्रांतात आहेत.” ");
INSERT INTO mar_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","त्याने आपल्याबरोबर फारोसमोर जाण्यासाठी आपल्या भावांपैकी पाच जणांना घेतले आणि त्यांची ओळख करून दिली. ");
INSERT INTO mar_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फारो राजा त्याच्या भावांना म्हणाला, “तुम्ही काय धंदा करता?” ते म्हणाले, “आम्ही आपले दास मेंढपाळ आहोत आणि आमचे पूर्वजही मेंढपाळच होते.” ");
INSERT INTO mar_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ते फारोला पुढे म्हणाले, “कनान देशात फारच भयंकर व कडक दुष्काळ पडला आहे. तेथे एकाही शेतात तुमच्या दासांच्या कळपांसाठी हिरवे गवत किंवा हिरवा चारा राहिलेला नाही म्हणून आम्ही या देशात तात्पुरते राहण्यास आलो आहोत. आम्ही आपणांस विनंती करतो की आम्हास गोशेन प्रांतात राहू द्यावे.” ");
INSERT INTO mar_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","मग फारो योसेफाला म्हणाला, “तुझा बाप व तुझे भाऊ तुझ्याकडे आले आहेत. ");
INSERT INTO mar_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","त्यांना राहण्याकरिता तू मिसर देशातील कोणतेही ठिकाण निवड. त्यांना उत्तम जमीन असलेला प्रदेश दे, त्यांना गोशेन प्रांतात वस्ती करून राहू दे. आणि त्याच्यात जर कोणी हुशार मनुष्य मनुष्ये तुला माहीत असतील तर मग त्यांना माझ्या गुराढोरांवर अधिकारी कर.” ");
INSERT INTO mar_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","मग योसेफाने याकोब त्याचा बाप याला आणले आणि फारोच्या समोर सादर केले. तेव्हा याकोबाने फारोस आशीर्वाद दिला. ");
INSERT INTO mar_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","मग फारोने याकोबाला विचारले, “तुमचे वय किती आहे?” ");
INSERT INTO mar_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकोबाने फारोस उत्तर दिले, “माझ्या कष्टमय जीवनाची वर्षे फक्त एकशे तीस वर्षे आहेत. परंतु माझ्या पूर्वजांइतके दीर्घ आयुष्य मला लाभले नाही.” ");
INSERT INTO mar_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","याकोबाने फारोला आशीर्वाद दिला व मग तो फारोपुढून निघून गेला. ");
INSERT INTO mar_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","योसेफाने फारोच्या आज्ञेप्रमाणे आपल्या बापाला व भावांना रामसेस नगरजवळील प्रांतातील उत्तम भूमी त्यांना रहावयास दिली. ");
INSERT INTO mar_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","आणि त्याने आपला बाप, आपले भाऊ व त्यांच्या कुटुंबाप्रमाणे, त्यांच्यावर अवलंबून असलेल्यांच्या संख्येप्रमाणे भरपूर अन्नसामग्री पुरवली. ");
INSERT INTO mar_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","त्या वेळी सर्व भूमीवर दुष्काळ तर फारच कडक पडला होता; अन्नधान्य कोठेच मिळत नव्हते. त्यामुळे मिसर व कनान देशातील जमीन दुष्काळामुळे उजाड झाली. ");
INSERT INTO mar_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","योसेफाने मिसर आणि कनान देशातील रहिवाशांना अन्नधान्य विकून त्यांच्याकडील सर्व पैसा गोळा केला. त्यानंतर योसेफाने तो पैसा फारोच्या राजवाड्यात आणला. ");
INSERT INTO mar_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","काही काळाने मिसर व कनान देशातील लोकांचे पैसे संपून गेले, त्यामुळे मिसरचे लोक योसेफाकडे येऊन म्हणाले, “आम्हास अन्न द्या! आमचे सर्व पैसे संपले आहेत म्हणून आम्ही तुमच्यासमोरच का मरावे?” ");
INSERT INTO mar_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","परंतु योसेफ म्हणाला, “जर तुमचे पैसे संपले आहेत, तर तुम्ही मला तुमची गुरेढोरे द्या आणि मग मी तुमच्या गुराढोरांच्या बदल्यात तुम्हास धान्य देईन.” ");
INSERT INTO mar_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","तेव्हा लोकांनी त्यांच्याकडील गुरेढोरे, शेरडेमेंढरे, घोडे, गाढवे आणि इतर जनावरे देऊन अन्नधान्य विकत घेतले. त्या वर्षात लोकांकडून गुरेढोरे घेऊन त्यांच्या बदल्यात योसेफाने त्यांना अन्नधान्य दिले. ");
INSERT INTO mar_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","परंतु त्या वर्षानंतर, पुढील वर्षी लोक योसेफाकडे जाऊन म्हणाले, “आमच्या धन्यापासून आम्ही काही लपवत नाही. आपणास माहीत आहे की, आमच्याकडे पैसे उरलेले नाहीत आणि आमची गुरेढोरेही धन्याची झाली आहेत. तेव्हा आमच्या धनाच्यासमोर आमची शरीरे व आमच्या जमिनी याशिवाय दुसरे काहीही उरलेले नाही. ");
INSERT INTO mar_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","तुमच्या डोळ्यांसमोर आम्ही का मरावे? आमचा व आमच्या जमिनीचाही नाश का व्हावा? परंतु जर आपण आम्हांला अन्नधान्य द्याल तर मग आम्ही आमच्या जमिनी फारोला देऊ आणि आम्ही त्याचे गुलाम होऊ. आम्हास बियाणे द्या म्हणजे आम्ही जगू, मरणार नाही आणि जमिनी ओस पडणार नाहीत.” ");
INSERT INTO mar_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","तेव्हा मिसरमधील सर्व शेतजमिनी योसेफाने फारोसाठी विकत घेतल्या. मिसरी लोकांनी आपल्या शेतजमिनी फारोला विकल्या कारण दुष्काळ भयंकर तीव्र झाला होता. ");
INSERT INTO mar_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","मिसरमधील एका टोकापासून तर दुसऱ्या टोकापर्यंतच्या सर्व लोकांस त्याने फारोचे गुलाम केले. ");
INSERT INTO mar_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","योसेफाने याजकांच्या मालकीच्या जमिनी मात्र विकत घेतल्या नाहीत. फारो याजकांना त्यांच्या कामाबद्दल पगार देत होता. त्या पैशातून ते आपणासाठी अन्नधान्य विकत घेत असत म्हणून त्यांच्यावर आपल्या जमिनी विकण्याची वेळ आली नाही. ");
INSERT INTO mar_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","तेव्हा योसेफ लोकांस म्हणाला, “पाहा, मी फारोकरता तुम्हास तुमच्या जमिनीसह विकत घेतले आहे तर मी आता तुम्हास बियाणे देतो. ते तुम्ही शेतात पेरा. ");
INSERT INTO mar_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","परंतु हंगामाच्या वेळी तुमच्या उत्पन्नातील पाचवा हिस्सा फारोला दिलाच पाहिजे. बाकीचे चार हिस्से तुम्ही तुमच्यासाठी घ्यावेत. त्यातून पुढच्या वर्षाकरता तुम्ही बियाणे ठेवावे व बाकीच्या धान्याचा तुमच्या घरातील लहानथोरांस खाण्यासाठी उपयोग करावा.” ");
INSERT INTO mar_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","लोक म्हणाले, “आपण आम्हांला वाचवले आहे, म्हणून फारोचे गुलाम होण्यात आम्हांला आनंद आहे.” ");
INSERT INTO mar_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","त्या वेळी मग योसेफाने देशासाठी एक कायदा केला, तो आजपर्यंत चालू आहे; त्या कायद्याप्रमाणे जमिनीच्या उत्पन्नाचा पाचवा भाग फारोचा आहे. फारो मिसरमधील सर्व जमिनीचा मालक आहे. फक्त याजकांची जमीन फारोच्या मालकीची नाही. ");
INSERT INTO mar_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इस्राएल मिसरमध्ये गोशेन प्रांतात राहिला. त्याची संतती खूप वाढली व त्यांची भरभराट झाली. त्यांना मिसरमधील जमीन मिळाली व त्यांनी वतने केली आणि तेथे त्यांचे सर्वकाही चांगले झाले. ");
INSERT INTO mar_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याकोब मिसरमध्ये सतरा वर्षे राहिला, तो एकशे सत्तेचाळीस वर्षांचा झाला. ");
INSERT INTO mar_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","इस्राएलाच्या मरणाचा काळ जवळ आला, म्हणून मग त्याने आपला मुलगा योसेफ याला आपणाजवळ बोलावले आणि तो त्यास म्हणाला, “तू जर माझ्यावर प्रेम करतोस तर माझ्या मांडीखाली तुझा हात ठेवून मला वचन दे की, मी जे सांगतो ते तू करशील आणि तू माझ्याशी खरेपणाने वागशील. मला मिसरामध्ये पुरू नको. ");
INSERT INTO mar_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","जेव्हा मी माझ्या वाडवडिलांसोबत झोपी जाईन, तेव्हा मला मिसरमधून बाहेर घेऊन जा आणि माझ्या पूर्वजांना जेथे पुरले आहे तेथे म्हणजे आपल्या वंशजांसाठी घेतलेल्या पुरण्याच्या जागेत मला मूठमाती दे.” योसेफाने उत्तर दिले, “तुम्ही मला जे करावयास सांगितले ते मी नक्की करीन.” ");
INSERT INTO mar_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","मग याकोब म्हणाला, “तू माझ्याशी तशी शपथ वाहा.” तेव्हा तसे करण्याबद्दल योसेफाने शपथ वाहिली. मग इस्राएलाने आपले डोके मागे पलंगाच्या उशावर नम्रतेने खाली वाकून नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","या गोष्टीनंतर “त्याचा बाप आजारी असल्याचे” कोणी योसेफाला कळवले, म्हणून आपले दोन पुत्र मनश्शे व एफ्राईम यांना बरोबर घेऊन तो गेला. ");
INSERT INTO mar_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","“योसेफ आपणास भेटावयास आला आहे” असे याकोबास कोणी सांगितले, हे कळवल्याबरोबर इस्राएलाने शक्ती एकवटली आणि बिछान्यावर उठून बसला. ");
INSERT INTO mar_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","मग याकोब योसेफास म्हणाला, “सर्वसमर्थ देवाने मला कनानातील लूज येथे दर्शन देऊन आशीर्वाद दिला. ");
INSERT INTO mar_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","देव म्हणाला, ‘मी तुला खूप संतती देईन व ती वाढवीन आणि मी तुला राष्ट्रांचा समुदाय करीन. आणि तुझ्यानंतर तुझ्या संतानाला हा देश कायमचा वतन म्हणून देईल.’ ");
INSERT INTO mar_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","आणि आता, मी येथे मिसर देशास येण्यापूर्वी, मिसराच्या भूमीमध्ये जे तुझ्या पोटी जन्मलेले हे दोन पुत्र, माझे आहेत. तुझे हे दोन पुत्र मनश्शे व एफ्राईम हे आता रऊबेन व शिमोन यांच्याप्रमाणेच माझे होतील. ");
INSERT INTO mar_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","त्यांच्यानंतर तुला जी संतती होईल ती तुझी होईल; त्यांच्या वतनात त्यांची नावे त्यांच्या भावांच्या नावांखाली नोंदवण्यात येतील. ");
INSERT INTO mar_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","परंतु पदन येथून मी येताना तुझी आई राहेल, एफ्राथापासून आम्ही थोड्याच अंतरावर असताना कनान देशात मरण पावली, त्यामुळे मी फार दुःखी झालो. तेव्हा एफ्राथच्या म्हणजे बेथलेहेमाच्या वाटेवर मी तिला पुरले.” ");
INSERT INTO mar_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","मग इस्राएलाने योसेफाच्या मुलांना पाहिले, तेव्हा इस्राएल म्हणाला, “हे कोणाचे आहेत?” ");
INSERT INTO mar_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","योसेफ आपल्या पित्यास म्हणाला, “हे माझे पुत्र आहेत. हे मला देवाने येथे दिले आहेत.” इस्राएल म्हणाला, “तुझ्या मुलांना माझ्याकडे आण म्हणजे मी त्यांना आशीर्वाद देईन.” ");
INSERT INTO mar_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएल अतिशय म्हातारा झाला होता आणि त्याची नजर मंद झाल्यामुळे त्यास चांगले स्पष्ट दिसत नव्हते. तेव्हा इस्राएलाने त्या मुलांना कवटाळून त्यांचे मुके घेतले. ");
INSERT INTO mar_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","मग इस्राएल योसेफास म्हणाला, “मुला तुझे तोंड पुन्हा पाहावयास मिळेल असे वाटले नव्हते, पण देवाने तुझी व माझी भेट होऊ दिली. मला तुझी मुलेही पाहू दिली.” ");
INSERT INTO mar_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","मग योसेफाने आपल्या मुलांना इस्राएलाच्या मांडीवरून काढून घेतले. ते पुत्र इस्राएलासमोर उभे राहिले व त्यांनी त्यास लवून नमन केले. ");
INSERT INTO mar_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","योसेफाने मनश्शेला आपल्या डाव्या हाती म्हणजे तो इस्राएलाच्या उजव्या हाती येईल असे व एफ्राईमाला आपल्या उजव्या हाती म्हणजे तो इस्राएलाच्या डाव्या हाती येईल असे उभे केले. ");
INSERT INTO mar_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","परंतु इस्राएलाने आपला उजवा हात पुढे केला आणि एफ्राइमाच्या, म्हणजे जो धाकटा मुलगा होता त्याच्या डोक्यावर ठेवला आणि त्याचा डावा हात थोरल्याच्या म्हणजे मनश्शेच्या डोक्यावर ठेवला. त्याने त्याच्या हातांची अदलाबदल करून ते उजवेडावे केले. ");
INSERT INTO mar_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","इस्राएलाने योसेफाला आशीर्वाद देऊन म्हटले, “ज्या देवासमोर माझे वडील, अब्राहाम व इसहाक चालले, ज्या देवाने माझ्या सर्व आयुष्यभर मला चालवले आहे, ");
INSERT INTO mar_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","तोच मला सर्व संकटातून सोडवणारा माझा देवदूत होता, तोच या मुलांना आशीर्वाद देवो. आता या मुलांना माझे नाव व वडील अब्राहाम व इसहाक यांचे नाव देण्यात येवो. ते वाढून त्यांची पृथ्वीवर अनेक कुटुंबे, कुळे व राष्ट्रे होवोत.” ");
INSERT INTO mar_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","आपल्या वडिलाने एफ्राईमाच्या डोक्यावर आपला उजवा हात ठेवला असे योसेफाने पाहिले तेव्हा त्यास ते आवडले नाही. तो हात एफ्राईमाच्या डोक्यावरून काढून मनश्शेच्या डोक्यावर ठेवावा म्हणून योसेफाने आपल्या बापाचा हात घेतला. ");
INSERT INTO mar_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","योसेफ आपल्या पित्यास म्हणाला, “असे नाही बाबा, कारण हा प्रथम जन्मलेला आहे. तुमचा उजवा हात याच्या डोक्यावर ठेवा.” ");
INSERT INTO mar_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","परंतु त्याचा वडिलाने नकार दिला आणि म्हटले, “माझ्या मुला, मला माहीत आहे. होय, मला माहीत आहे की, तोसुद्धा महान होईल. परंतु धाकटा भाऊ त्याच्यापेक्षाही अधिक महान होईल आणि त्याची कुळे वाढून त्यांचा मोठा राष्ट्रसमूह निर्माण होईल.” ");
INSERT INTO mar_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","त्या दिवशी इस्राएलाने त्या मुलांना या शब्दांत आशीर्वाद दिला, तो म्हणाला, “इस्राएल लोक आशीर्वाद देताना तुमची नावे उच्चारितील, ते म्हणतील, ‘देव तुम्हास एफ्राईमासारखा, मनश्शेसारखा आशीर्वाद देवो.’” ");
INSERT INTO mar_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","मग इस्राएल योसेफाला म्हणाला, “पाहा, मी आता मरणार आहे. परंतु देव तुमच्या बरोबर राहील, तो तुम्हास तुमच्या पूर्वजांच्या देशात घेऊन येईल. ");
INSERT INTO mar_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","तुझ्या भावांपेक्षा तुला एक भाग अधिक देतो, मी स्वतः तलवारीने व धनुष्याने लढून अमोरी लोकाकडून जिंकलेला डोंगरउतार तुला देतो.” ");
INSERT INTO mar_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","त्यानंतर याकोबाने आपल्या सर्व मुलांना आपल्याजवळ बोलावले, तो म्हणाला, “माझ्या मुलांनो, माझ्याजवळ या म्हणजे पुढील काळी तुमचे काय होईल, ते मी तुम्हास सांगतो.” ");
INSERT INTO mar_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“याकोबाच्या मुलांनो, तुम्ही सर्व एकत्र या आणि ऐका, तुमचा बाप इस्राएल याचे ऐका. ");
INSERT INTO mar_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","रऊबेना, तू माझा पहिलाच म्हणजे थोरला मुलगा आहेस. पुरुष म्हणून माझ्यात असलेल्या शक्तीचा तू पहिला पुरावा आहेस, तू सर्वांपेक्षा अधिक शक्तीवान व सर्वांपेक्षा अधिक अभिमान वाटावा असा आहेस. ");
INSERT INTO mar_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","परंतु तुझ्या भावना पुराच्या पाण्याच्या अनावर व चंचल लाटांप्रमाणे आहेत. कारण तू आपल्या वडिलाच्या पलंगावर गेलास व त्याच्या बिछान्यावर जाऊन तो अशुद्ध केलास.” ");
INSERT INTO mar_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“शिमोन व लेवी हे सख्खे भाऊ आहेत. या दोन भावांना तलवारीने लढण्याची आवड आहे. ");
INSERT INTO mar_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","माझ्या जिवा, त्यांच्या गुप्त मसलतींमध्ये गुंतू नको; त्यांच्या गुप्त बैठकांमध्ये सामील होऊ नको, त्यांचे हे बेत माझ्या जिवाला मान्य नाहीत. त्यांनी त्यांच्या रागाच्या भरात पुरुषांची कत्तल केली. आपल्या रागाने बैलांच्या पायांच्या शिरा तोडल्या. ");
INSERT INTO mar_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","त्यांचा राग शाप आहे, ते अति रागाने वेडे होतात. तेव्हा अतिशय क्रूर बनतात. मी त्यांना याकोबात विभागीन, ते सर्व इस्राएल देशभर पसरतील. ");
INSERT INTO mar_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","यहूदा, तुझे भाऊ तुझी स्तुती करतील. तुझा हात तुझ्या शत्रूंच्या मानेवर राहील. तुझ्या पित्याची मुले तुला लवून नमन करतील. ");
INSERT INTO mar_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा सिंहाचा छावा आहे. माझ्या मुला, तू शिकारीपासून वरपर्यंत गेलास. तो खाली वाकला आहे, तो सिंहासारखा, सिंहिणीसारखा दबा धरून बसला आहे. त्यास उठवण्याचे धाडस कोण करील? ");
INSERT INTO mar_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","शिलो येईपर्यंत यहूदाकडून राजवेत्र जाणार नाही, किंवा अधिकाराची काठी त्याच्या पायामधून निघून जाणार नाही. राष्ट्रे त्याच्या आज्ञा पाळतील. ");
INSERT INTO mar_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","तो त्याचा तरुण घोडा द्राक्षवेलीस, आणि त्याचे शिंगरु खास द्राक्षवेलीस बांधेल. त्याने त्याचे वस्त्र द्राक्षरसात आणि आपला झगा द्राक्षांच्या रक्तात धुतला आहे. ");
INSERT INTO mar_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","त्याचे डोळे द्राक्षरसापेक्षा अधिक लालबुंद होतील. त्याचे दात दूधापेक्षा अधिक सफेद होतील. ");
INSERT INTO mar_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","जबुलून समुद्र किनाऱ्याजवळ राहिल. तो जहाजासाठी सुरक्षित बंदर होईल. त्याच्या जमिनीची हद्द सीदोन नगरापर्यंत असेल.” ");
INSERT INTO mar_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साखार बळकट गाढव आहे. तो मेंढवाड्यांच्यामध्ये दबून बसला आहे. ");
INSERT INTO mar_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","आपले विसावा घेण्याचे ठिकाण चांगले आहे, आपला देश आनंददायक आहे असे त्याने पाहिले, आणि मग जड बोजा वाहून नेण्यास व अगदी गुलामाप्रमाणे काम करण्यास तो तयार झाला. ");
INSERT INTO mar_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","इस्राएलाचा एक वंश या नात्याने दान आपल्या लोकांचा न्याय करील. ");
INSERT INTO mar_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","तो रस्त्याच्या कडेला असणाऱ्या सापाप्रमाणे, वाटेच्या कडेला पडून असलेल्या भयंकर नागाप्रमाणे होईल. तो घोड्याच्या टाचेला दंश करील. त्यामुळे घोडेस्वार घोड्यावरून मागे कोसळेल. ");
INSERT INTO mar_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","हे परमेश्वरा, तुझ्याकडून उद्धार होण्याची मी वाट पाहत आहे. ");
INSERT INTO mar_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","गाद-लुटारूंची टोळी त्याच्यावर हल्ला करेल, परंतु तो त्यांच्या पार्श्वभागावर हल्ला करून त्यांना पळवून लावील. ");
INSERT INTO mar_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","आशेराचे अन्न समृद्ध होईल आणि तो राजाला योग्य असे शाही अन्नपदार्थ पुरवील. ");
INSERT INTO mar_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","नफताली मोकळ्या सुटलेल्या हरीणीप्रमाणे आहे. त्याचे बोलणे गोड असेल. ");
INSERT INTO mar_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","योसेफ हा फलदायी फाट्यासारखा आहे. तो ओढ्याकाठी वाढणाऱ्या द्राक्षवेलीसारखा आहे. त्याच्या फांद्या भिंतीवर चढून पसरल्या आहेत. ");
INSERT INTO mar_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","तिरंदाजांनी त्याच्यावर हल्ला केला. आणि त्यास तीर मारले व त्यास त्रास दिला. ");
INSERT INTO mar_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","तरी त्याचे धनुष्य मजबूत राहील, आणि त्याचे बाहु कुशल होतील याकोबाचा सामर्थ्यवान देव, मेंढपाळ, इस्राएलाचा खडक याजकडून त्याच्या हातांना शक्ती मिळते. ");
INSERT INTO mar_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","कारण तुझ्या बापाचा देव, जो तुला मदत करील, आणि सर्वशक्तिमान देवामुळे, जो तुला वरून आकाशाचे आशीर्वाद, खाली खोल दरीचे आशीर्वाद देवो, तसेच स्तनांचा व गर्भाशयांच्या उपजांचा आशीर्वाद तो तुला देवो. ");
INSERT INTO mar_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तुझ्या बापाचे आशीर्वाद माझ्या पूर्वजांच्या आशीर्वादापेक्षा मोठे होतील, अथवा सर्वकाळ टिकून राहणाऱ्या डोंगरांपासून प्राप्त होणाऱ्या इच्छित वस्तुंहून श्रेष्ठ होतील. ते योसेफाच्या मस्तकावर, जो आपल्या भावांमध्ये राजपुत्र त्याच्या मस्तकावर आशीर्वाद असे राहतील. ");
INSERT INTO mar_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","बन्यामीन हा भुकेला लांडगा आहे. तो सकाळी आपले भक्ष्य मारून खाईल, आणि संध्याकाळी तो लूट वाटून घेईल.” ");
INSERT INTO mar_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","हे सर्व इस्राएलाचे बारा वंश होत. त्यांच्या वडिलाने आशीर्वाद देऊन त्यांना म्हटले ते हेच. त्याने प्रत्येकाला ज्याच्या त्याच्या योग्यतेप्रमाणे आशीर्वाद दिला. ");
INSERT INTO mar_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","मग त्याने त्यांना आज्ञा दिली आणि त्यांना म्हणाला, “मी आता माझ्या लोकांकडे जात आहे. एफ्रोन हित्ती ह्याच्या शेतातील गुहेत माझ्या पूर्वजांबरोबर मला पुरावे, ");
INSERT INTO mar_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ती गुहा कनान देशात मम्रेजवळील मकपेलाच्या शेतात आहे, आपल्या घराण्याला पुरण्याची जागा असावी म्हणून अब्राहामाने ते शेत एफ्रोन हित्ती याच्याकडून विकत घेतले. ");
INSERT INTO mar_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","अब्राहाम व त्याची पत्नी सारा, यांना त्या गुहेत पुरले आहे; इसहाक आणि त्याची पत्नी रिबका यांनाही तेथेच पुरले आहे; आणि माझी पत्नी लेआ हिलाही मी तेथेच पुरले आहे. ");
INSERT INTO mar_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ते शेत व ती गुहा हेथी लोकांकडून विकत घेतलेली आहे.” ");
INSERT INTO mar_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","आपल्या मुलांशी हे बोलणे संपवल्यानंतर याकोबाने आपले पाय पलंगावर जवळ ओढून घेतले व मरण पावला, आणि तो आपल्या पूर्वजांकडे गेला. ");
INSERT INTO mar_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","त्यानंतर योसेफ आपल्या बापाला कवटाळून खूप रडला. त्याने त्याची चुंबने घेतली. ");
INSERT INTO mar_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","योसेफाने आपल्या सेवकांतील वैद्यांना आपल्या वडिलाच्या प्रेताला मसाला लावण्याची व भरण्याची आज्ञा केली. तेव्हा त्यांनी खास मिसरच्या पद्धतीने इस्राएलाचे प्रेत मसाला लावून, भरून तयार केले. ");
INSERT INTO mar_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","त्याकरता त्यांना चाळीस दिवस लागले, कारण तशा खास पद्धतीने प्रेत तयार करण्यासाठी तेवढा वेळ घेत. मिसरच्या लोकांनी त्याच्यासाठी सत्तर दिवस शोक केला. ");
INSERT INTO mar_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","सत्तर दिवसानंतर शोक करण्याचा काळ संपला, तेव्हा योसेफ फारोच्या शाही अधिकाऱ्यांना म्हणाला, “जर मला तुमच्या दृष्टीने कृपा लाभली असेल तर, फारोला हे सांगा, ");
INSERT INTO mar_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘माझा बाप मरावयास टेकला असताना त्याने मला शपथ घेण्यास सांगून म्हटले, “पाहा, मी मरणार आहे. माझी जी कबर मी आपणासाठी कनान देशात खणून ठेवली आहे तिच्यात तू मला नेऊन पूर.” तेव्हा कृपा करून माझ्या पित्यास पुरावयास जाऊ द्या; मग मी परत येईन. ");
INSERT INTO mar_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फारोने उत्तर दिले, “जा आणि आपल्या बापाला शपथ दिल्याप्रमाणे त्यास पुरून ये.” ");
INSERT INTO mar_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","तेव्हा योसेफ आपल्या बापाला पुरण्यासाठी गेला. तेव्हा फारोचे सर्व अधिकारी व मिसरचे नेते आणि सर्व वडीलजन योसेफाबरोबर गेले. ");
INSERT INTO mar_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","आपले कुटुंबीय, आपले भाऊ व त्यांचे कुटुंबीय तसेच आपल्या बापाचे कुटुंबीय योसेफाबरोबर होते. फक्त लहान मुले व पशू एवढेच गोशेन प्रांतात मागे राहिले होते. ");
INSERT INTO mar_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","तो लोकांचा खूप मोठा समूह होता. सैनिकांची एक पलटणही घोड्यांवर व रथांत बसून मोठ्या संख्येने योसेफाबरोबर गेली. ");
INSERT INTO mar_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ते यार्देन नदीच्या पूर्वेस अटादाच्या खळ्यावर आले, तेव्हा त्यांनी फारच मोठा शोक केला. योसेफाने त्याच्या पित्याकरिता सात दिवस शोक केला. ");
INSERT INTO mar_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","कनान देशात राहणाऱ्या लोकांनी अटादाच्या येथील हे प्रेतक्रियेचे विधी व संस्कार पाहिले तेव्हा ते म्हणाले, “मिसरच्या लोकांचा हा फारच दुःखाचा प्रसंग आहे.” त्यामुळे आता त्या जागेला आबेल-मिस्राईम असे नाव पडले आहे. ");
INSERT INTO mar_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","अशा प्रकारे याकोबाच्या मुलांनी आपल्या वडिलाने दिलेल्या आज्ञेप्रमाणे केले; ");
INSERT INTO mar_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","त्यांनी त्याचे प्रेत कनान देशात नेऊन एफ्रोन हित्ती याजकडून कबरस्तान म्हणून उपयोगी पडावे यासाठी अब्राहामाने विकत घेतलेल्या मम्रे येथील शेतातील मकपेला गुहेत पुरले. ");
INSERT INTO mar_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","आपल्या वडिलाच्या प्रेतक्रियेनंतर योसेफ आणि त्याच्याबरोबर गेलेला सर्व समुदाय मिसरला माघारी गेला. ");
INSERT INTO mar_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","याकोब मरण पावल्यावर योसेफाचे भाऊ चिंतेत पडले, फार पूर्वी आपण योसेफाबरोबर दुष्टपणाने वागलो त्यावरून आता आपल्यावर त्याचा राग भडकेल अशी त्यांना भीती वाटली. ते स्वतःशीच म्हणाले, “कदाचित योसेफ अजूनही आपला तिरस्कार करत असेल आणि आपण त्याच्याशी वाईट वागलो त्याचा तो बदला घेईल.” ");
INSERT INTO mar_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","तेव्हा त्या भावांनी योसेफाला येणेप्रमाणे निरोप पाठवला, “तुझ्या वडिलाने मरण्यापूर्वी आम्हांला अशी आज्ञा दिली, ");
INSERT INTO mar_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","तो म्हणाला, ‘योसेफाला सांगा की, तुझ्या भावांनी तुझ्याशी जे वाईट वर्तन केले त्याबद्दल तू त्यांची क्षमा करावीस अशी मी विनंती करतो.’ तेव्हा हे योसेफा, आम्ही तुला अशी विनंती करतो की, आम्ही तुझ्याशी वाईट रीतीने वागलो त्याबद्दल कृपया तू आमची क्षमा कर. आम्ही देवाचे, तुझ्या वडिलाच्या देवाचे दास आहोत.” योसेफाचे भाऊ वरीलप्रमाणे बोलले त्यामुळे योसेफाला फार दुःख झाले व तो रडला. ");
INSERT INTO mar_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","योसेफाचे भाऊ त्याच्याकडे गेले व ते त्याच्या पाया पडले. मग ते म्हणाले, “आम्ही आपले दास आहोत.” ");
INSERT INTO mar_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","मग योसेफ त्यांना म्हणाला, “भिऊ नका. मी काय देवाच्या स्थानी आहे काय? ");
INSERT INTO mar_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","तुम्ही माझे वाईट करण्याचा कट केला, पण देव माझ्यासाठी चांगली योजना करीत होता. असंख्य लोकांचे प्राण वाचविण्यासाठी माझा उपयोग करावा अशी देवाची योजना होती. आज तुम्ही ते पाहत आहात. ");
INSERT INTO mar_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","तेव्हा आता तुम्ही भिऊ नका. मी तुमची व तुमच्या मुलाबाळांची काळजी घेईन, तुमचे पोषण करीन.” अशा रीतीने त्याने त्यांचे समाधान केले आणि त्यांच्याशी ममतेने बोलला. ");
INSERT INTO mar_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","योसेफ आपल्या वडिलाच्या कुटुंबियांसह मिसरमध्ये राहिला. तो एकशे दहा वर्षांचा असताना मरण पावला. ");
INSERT INTO mar_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","योसेफाच्या हयातीत एफ्राईमाला मुले व नातवंडे झाली. त्याचा मुलगा मनश्शे याला माखीर नावाचा मुलगा झाला. योसेफाने माखीराची मुले ही पाहिली. ");
INSERT INTO mar_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","योसेफाचे मरण जवळ आले तेव्हा तो आपल्या भावांना म्हणाला, “माझी मरण्याची वेळ जवळ आली आहे; परंतु देव तुमची काळजी घेईल हे मला माहीत आहे. तो देव तुम्हास या देशातून काढून अब्राहाम, इसहाक, व याकोब यांना जो देश देण्याचे वचन त्याने दिले होते त्या देशात घेऊन जाईल.” ");
INSERT INTO mar_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","मग योसेफाने इस्राएल लोकांस शपथ घ्यायला लावली. तो म्हणाला, “देव जेव्हा तुम्हास येथून काढून पुढे घालून त्या नवीन देशात घेऊन जाईल तेव्हा माझे शरीर तुम्ही तुमच्या बरोबर घेऊन जाल असे मला वचन द्या.” ");
INSERT INTO mar_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","योसेफ एकशे दहा वर्षांचा झाल्यावर मिसरमध्ये मरण पावला. वैद्यांनी त्याच्या शरीराला मसाला लावून ते पुरण्यासाठी तयार केले व ते मिसर देशामध्ये शवपेटीत ठेवले.");
INSERT INTO mar_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","याकोबाबरोबर जे इस्राएलाचे पुत्र व त्यांची कुटुंबे मिसर देशात गेली, त्यांची नावे हीः ");
INSERT INTO mar_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रऊबेन, शिमोन, लेवी, यहूदा ");
INSERT INTO mar_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साखार, जबुलून, बन्यामीन; ");
INSERT INTO mar_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नफताली, गाद व आशेर. ");
INSERT INTO mar_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकोबाच्या वंशाचे एकूण सत्तरजण होते. योसेफ हा आधीच मिसर देशात होता. ");
INSERT INTO mar_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","नंतर योसेफ, त्याचे भाऊ व त्या पिढीतील सर्व मरण पावले. ");
INSERT INTO mar_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","इस्राएल लोक फार फलदायी होऊन त्यांची संख्या अतिशय वाढत गेली; ते महाशक्तीशाली झाले आणि सर्व देश त्यांनी भरून गेला. ");
INSERT INTO mar_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","नंतर मिसर देशावर नवीन राजा राज्य करू लागला. त्यास योसेफाच्या स्मरणाची काही काळजी नव्हती. ");
INSERT INTO mar_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","तो आपल्या लोकांस म्हणाला, “इस्राएली वंशाच्या लोकांकडे पाहा, ते पुष्कळ अधिक आहेत व आपल्यापेक्षा शक्तीमानही झाले आहेत; ");
INSERT INTO mar_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","चला, आपण त्यांच्याशी चतुराईने वागू, नाहीतर त्यांची निरंतर अधिक वाढ होईल आणि जर एखादा युद्धाचा प्रसंग आला तर हे लोक आपल्या शत्रूला जाऊन मिळतील; आणि मग ते आपल्याविरुद्ध लढतील आणि देशातून निघून जातील.” ");
INSERT INTO mar_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","म्हणून त्याने त्यांना कामाच्या ओझ्याने जाचण्यासाठी त्यांच्यावर मुकादम नेमले. त्यांनी फारोकरता पिथोम व रामसेस ही दोन शहरे इस्राएल लोकांकडून बांधून घेतली; ");
INSERT INTO mar_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","पण मिसऱ्यांनी त्यांना जसजसे जाचले तसतसे ते संख्येने अधिकच वाढत गेले व अधिकच पसरले, म्हणून इस्राएल लोकांची त्यांना भीती वाटू लागली. ");
INSERT INTO mar_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","आणि मग मिसऱ्यांनी इस्राएल लोकांवर अधिक कष्टाची कामे लादली. ");
INSERT INTO mar_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","अशाप्रकारे त्यांनी इस्राएल लोकांचे जीवन फारच कठीण काबाडकष्टांचे व हाल अपेष्टांचे केले; त्यांनी त्यांना विटा बनविण्याची, बांधकामासाठी चुना बनविण्याची तसेच शेतीची व इतर अतिशय कठीण व कष्टाची कामे बळजबरीने करायला लावली. ");
INSERT INTO mar_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","मग मिसराचा राजा इब्री सुइणींशी बोलला. त्यांच्यातल्या एकीचे नाव शिप्रा व दुसरीचे पुवा असे होते. ");
INSERT INTO mar_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","तो म्हणाला, “तुम्ही इब्री स्त्रियांचे बाळंतपण करत असता, त्या प्रसूत होण्याच्या जागी त्या बसल्या म्हणजे नीट पाहा, आणि त्या स्त्रियांना मुलगी झाली तर तिला जिवंत ठेवा; परंतु त्यांना मुलगा झाला तर त्यास अवश्य मारून टाका.” ");
INSERT INTO mar_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","परंतु त्या इब्री सुइणी देवाचे भय व आदर धरून त्याच्यावर विश्वास ठेवणाऱ्या होत्या, म्हणून त्यांनी मिसरी राजाची आज्ञा मानली नाही; तर त्यांनी जन्मणाऱ्या मुलांनाही जिवंत ठेवले. ");
INSERT INTO mar_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तेव्हा मिसराच्या राजाने त्या सुइणींना बोलावून विचारले, “तुम्ही असे का केले? तुम्ही जन्मलेल्या मुलांना का जिवंत ठेवले?” ");
INSERT INTO mar_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","त्या सुइणी फारोला म्हणाल्या, “या इब्री स्त्रिया मिसरच्या स्त्रियांपेक्षा फार ताकदवान आहेत; आम्ही सुइणी त्यांच्याकडे जाऊन पोहचण्यापूर्वीच त्या प्रसूत होतात.” ");
INSERT INTO mar_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","त्याबद्दल देवाने त्या सुइणींचे कल्याण केले. इस्राएल लोक तर अधिक वाढून फार बलवान झाले. ");
INSERT INTO mar_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","त्या सुइणी देवाचे भय बाळगणाऱ्या होत्या म्हणून त्याने त्यांची घराणे वसवली. ");
INSERT INTO mar_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","तेव्हा फारोने आपल्या सर्व लोकांस आज्ञा दिली, “जो प्रत्येक इब्री मुलगा जन्मेल त्यास तुम्ही नाईल नदीमध्ये फेकून द्या, पण प्रत्येक मुलगी मात्र जिवंत ठेवा.” ");
INSERT INTO mar_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी वंशातील एका मनुष्याने जाऊन लेवीच्या एका मुलीशी विवाह केला. ");
INSERT INTO mar_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ती स्त्री गरोदर राहिली व तिने मुलाला जन्म दिला; तो फार सुंदर आहे असे पाहून तिने त्यास तीन महिने लपवून ठेवले. ");
INSERT INTO mar_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","पुढे आणखी तिला तो लपवून ठेवता येईना म्हणून तिने एक लव्हाळ्याची पेटी तयार केली; तिला राळ व डांबर लावले. तिने त्या बाळाला पेटीत ठेवून ती पेटी नदीच्या तीरी लव्हाळ्यात नेऊन ठेवली. ");
INSERT INTO mar_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","त्याची बहीण, त्याचे पुढे काय होते ते पाहण्यासाठी तेथून दूर बाजूला उभी राहिली. ");
INSERT INTO mar_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","त्या वेळी फारोची मुलगी आंघोळ करण्यासाठी नदीवर आली. तिच्या दासी नदीच्या किनाऱ्यावर फिरत होत्या. तिने लव्हाळ्यात ती पेटी पाहिली; आणि एका दासीला तिकडे जाऊन ती पेटी आणण्यास सांगितले. ");
INSERT INTO mar_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","तिने ती पेटी उघडली तेव्हा तिला तिच्यात एक लहान बाळ दिसले. ते बाळ रडत होते. तिला त्याचा कळवळा आला, ती म्हणाली, “खात्रीने हे इब्र्याच्या मुलांपैकी आहे.” ");
INSERT INTO mar_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","मग ती बाळाची बहीण फारोच्या मुलीला म्हणाली, “या बाळाला दूध पाजण्यासाठी मी जाऊन तुझ्यासाठी इब्री स्त्रियांमधून एखादी दाई शोधून आणू का?” ");
INSERT INTO mar_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फारोची मुलगी तिला म्हणाली, जा. तेव्हा ती मुलगी गेली व त्या बाळाच्या आईलाच घेऊन आली. ");
INSERT INTO mar_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फारोच्या मुलीने त्या बाळाच्या आईला म्हटले, “या बाळाला घरी घेऊन जा, व माझ्याकरिता त्यास दूध पाज; त्याबद्दल मी तुला वेतन देईन.” तेव्हा ती स्त्री बाळाला घेऊन त्यास दूध पाजू लागली. ");
INSERT INTO mar_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ते मूल वाढून मोठे झाले. तेव्हा तिने त्यास फारोच्या मुलीकडे आणले; आणि तो तिचा मुलगा झाला; तिने त्याचे नाव मोशे ठेवले, ती म्हणाली, “कारण मी त्यास पाण्यातून बाहेर काढले.” ");
INSERT INTO mar_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","काही दिवसानी असे झाले की, मोशे मोठा झाल्यावर आपल्या लोकांकडे गेला आणि त्याने त्यांची कष्टाची कामे पहिली. कोणी एक मिसरी आपल्या इब्री मनुष्यास मारत असताना त्याने पाहिले. ");
INSERT INTO mar_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","तेव्हा आपल्याकडे पाहणारा आजूबाजूला कोणीही नाही हे जाणून मोशेने त्या मिसराच्या मनुष्यास जिवे मारले व वाळूत पुरून टाकले. ");
INSERT INTO mar_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","दुसऱ्या दिवशी तो बाहेर गेला, तेव्हा पाहा दोन इब्री माणसे मारामारी करत होती. त्यांच्यामध्ये जो दोषी होता त्यास तो म्हणाला, “तू आपल्या सोबत्याला का मारत आहेस?” ");
INSERT INTO mar_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","पण त्या मनुष्याने उत्तर दिले, “तुला आम्हांवर अधिकारी व न्यायाधीश कोणी नेमले? तू काल जसे त्या मिसऱ्यास जिवे मारलेस, तसे मला मारायला पाहतोस का?” तेव्हा मोशे घाबरला. तो विचार करीत स्वत:शीच म्हणाला, “मी काय केले ते आता खचीत सर्वांना माहीत झाले आहे.” ");
INSERT INTO mar_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","आणि फारोने याविषयी ऐकले तेव्हा त्याने मोशेला जिवे मारण्याचा प्रयत्न केला. परंतु मोशे फारोपासून दूर पळून गेला. तो मिद्यान देशात गेला आणि तेथे एका विहिरीजवळ बसला. ");
INSERT INTO mar_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिद्यानी याजकाला सात मुली होत्या; आपल्या वडिलाच्या कळपाला पाणी पाजण्यासाठी त्या विहिरीवर आल्या. त्या हौदात पाणी भरत होत्या; ");
INSERT INTO mar_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","परंतु काही मेंढपाळांनी त्यांना पाणी भरू न देता हुसकून लावण्याचा प्रयत्न केला. पण मोशेने उठून त्यांना मदत केली. त्याने त्यांच्या कळपाला पाणी पाजले. ");
INSERT INTO mar_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","मग त्या मुली आपला बाप रगुवेल याच्याकडे गेल्या; तेव्हा त्यांचा बाप त्यांना म्हणाला, “तुम्ही आज इतक्या लवकर घरी कशा आला आहात?” ");
INSERT INTO mar_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","त्या म्हणाल्या, “एका मिसरी मनुष्याने आम्हांला मेंढपाळाच्या हातून सोडवले. त्याने आम्हांसाठी पाणी देखील काढून कळपाला पाजले.” ");
INSERT INTO mar_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","तेव्हा तो आपल्या मुलींना म्हणाला, “तो कोठे आहे? तुम्ही त्या मनुष्यास का सोडले? त्यास बोलावून आणा म्हणजे तो आपल्याबरोबर भोजन करेल.” ");
INSERT INTO mar_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","त्या मनुष्यापाशी राहायला मोशे कबूल झाला. त्याने आपली मुलगी सिप्पोरा हिचा विवाह देखील त्याच्याशी करून दिला. ");
INSERT INTO mar_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","तिला एक मुलगा झाला. मोशेने त्याचे नाव गेर्षोम ठेवले, तो म्हणाला, “मी परदेशात वस्ती करून आहे.” ");
INSERT INTO mar_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","बऱ्याच काळानंतर मिसराचा राजा मरण पावला. तेव्हा इस्राएलांनी दास्यामुळे कण्हून आक्रोश केला. त्यांनी मदतीकरता हाका मारल्या व दास्यामुळे त्यांनी केलेला आकांत देवापर्यंत वर जाऊन पोहचला; ");
INSERT INTO mar_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","देवाने त्यांचे कण्हणे ऐकले आणि अब्राहाम, इसहाक व याकोब यांच्याशी केलेल्या कराराची त्यास आठवण झाली. ");
INSERT INTO mar_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","देवाने इस्राएली लोकांस पाहिले आणि त्यास त्यांची परिस्थिती समजली. ");
INSERT INTO mar_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","तेव्हा मोशे आपला सासरा इथ्रो जो मिद्यानी याजक याचा कळप चारत होता. मोशे रानाच्या मागे, देवाचा डोंगर होरेब येथवर आपला कळप घेऊन गेला. ");
INSERT INTO mar_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","तेव्हा परमेश्वराच्या दूताने त्यास एका झुडपातून निघणाऱ्या अग्नीच्या ज्वालेत दर्शन दिले. मोशेने पाहिले की, झुडूप अग्नीने जळत होते, परंतु ते जळून भस्म होत नव्हते. ");
INSERT INTO mar_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","मोशे म्हणाला, “मी त्या बाजूला वळतो आणि हे मोठे आश्चर्य जाऊन पाहतो की, हे झुडूप जळून नष्ट का होत नाही.” ");
INSERT INTO mar_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","मोशे झुडूपाजवळ येत आहे हे परमेश्वराने पाहिले. तेव्हा झुडपातून देवाने त्यास हाक मारून म्हटले, “मोशे! मोशे!” आणि मोशे म्हणाला, “हा मी इथे आहे.” ");
INSERT INTO mar_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","देव म्हणाला, “तू इकडे जवळ येऊ नकोस, तर तुझ्या पायातल्या चपला काढ; कारण ज्या जागी तू उभा आहेस ती भूमी पवित्र आहे. ");
INSERT INTO mar_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","तो आणखी म्हणाला, मी तुझ्या पित्याचा देव-अब्राहामाचा देव, इसहाकाचा देव व याकोबाचा देव आहे.” तेव्हा मोशेने आपले तोंड झाकून घेतले. कारण देवाकडे पाहायला तो घाबरला. ");
INSERT INTO mar_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","परमेश्वर म्हणाला, “मिसरामध्ये माझ्या लोकांचा जाच मी खरोखर पाहिला आहे; आणि मुकादमांच्या त्रासामुळे त्यांनी केलेला आकांत मी ऐकला आहे; त्यांचे दु:ख मी जाणून आहे. ");
INSERT INTO mar_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","त्यांना मिसऱ्यांच्या हातून सोडवून त्यांना त्या देशातून चांगल्या व मोठ्या देशात, दुधामधाचे प्रवाह ज्यात वाहत आहेत, कनानी, हित्ती, अमोरी, परिज्जी, हिव्वी व यबूसी यांच्या प्रदेशात घेऊन जावे म्हणून मी उतरलो आहे. ");
INSERT INTO mar_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","तर आता पाहा, मी इस्राएली लोकांचा आक्रोश ऐकला आहे आणि मिसरी ज्या जुलूमाने त्यांना जाचत आहेत तेही मी पाहिले आहे. ");
INSERT INTO mar_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","तर आता, माझ्या इस्राएली लोकांस मिसर देशामधून बाहेर काढण्यासाठी मी तुला फारोकडे पाठवत आहे.” ");
INSERT INTO mar_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","परंतु मोशे देवाला म्हणाला, “फारोकडे जाऊन इस्राएली लोकांस मिसर देशामधून काढून आणणारा असा मी कोण आहे?” ");
INSERT INTO mar_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","देवाने उत्तर दिले, “खचीत, मी तुझ्याबरोबर असेन, मी तुला पाठवत आहे याची खूण हीच असेल; तू इस्राएली लोकांस मिसरमधून बाहेर आणल्यावर याच डोंगरावर तुम्ही देवाची उपासना कराल.” ");
INSERT INTO mar_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मग मोशे देवाला म्हणाला, “परंतु मी जर इस्राएली लोकांकडे जाऊन म्हणालो, ‘तुमच्या पूर्वजांचा देव याने मला तुमच्याकडे पाठवले आहे’ तर मग ते लोक विचारतील ‘त्याचे नाव काय आहे?’ मग मी त्यांना काय सांगू?” ");
INSERT INTO mar_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","देव मोशेस म्हणाला, “जो मी आहे तो मी आहे. देव म्हणाला. तू इस्राएल लोकांस सांग, मी आहे याने मला तुम्हांकडे पाठवले आहे.” ");
INSERT INTO mar_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","देव मोशेला असे म्हणाला, “तू इस्राएल लोकांस सांग, तुमच्या पूर्वजांचा म्हणजे अब्राहामाचा देव, इसहाकाचा देव व याकोबाचा देव परमेश्वर याने मला तुम्हांकडे पाठवले आहे. हेच माझे सर्वकाळचे नाव आहे, व हेच माझे स्मारक सर्व पिढ्यांना होईल; ");
INSERT INTO mar_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","तू जाऊन इस्राएलाच्या वडीलजनांना एकत्रित करून त्यांना सांग की, तुमच्या पूर्वजांचा देव म्हणजे अब्राहाम, इसहाक व याकोब यांचा देव परमेश्वर, याने मला दर्शन देऊन म्हटले की, तुम्हांकडे खरोखर माझे लक्ष गेले आहे व मिसर देशात तुम्हांसोबत काय घडले आहे हे मला कळले आहे. ");
INSERT INTO mar_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","आणि मी तुम्हास मिसऱ्यांच्या जाचातून सोडवीन व कनानी, हित्ती, अमोरी, परिज्जी, हिव्वी व यबूसी यांच्या देशात, दुधामधाचे प्रवाह वाहणाऱ्या देशात घेऊन जाईन, असे मी सांगितले आहे हे त्यांना कळव. ");
INSERT INTO mar_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","ते तुझे ऐकतील, मग तू व इस्राएलाचे वडीलजन मिळून तुम्ही मिसराच्या राजाकडे जा व त्यास सांगा, इब्री लोकांचा देव परमेश्वर आम्हांला भेटला आहे. आमचा देव परमेश्वर याच्यासाठी यज्ञ करण्यासाठी म्हणून आम्हांला तीन दिवसाच्या वाटेवर रानात जाऊ दे. ");
INSERT INTO mar_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","परंतु मला माहीत आहे की, मिसराचा राजा तुम्हास जाऊ देणार नाही. त्यास माझे बाहुबल दाखविले तरी तो तुम्हास जाऊ देणार नाही; ");
INSERT INTO mar_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","तेव्हा मी मिसर देशात आपले बाहुबल दाखवून, ज्या अद्भुत कृती मी करणार आहे, त्यांचा मारा मी त्याजवर करीन. मग तो तुम्हास जाऊ देईल; ");
INSERT INTO mar_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","आणि या लोकांवर मिसऱ्यांची कृपादृष्टी होईल असे मी करीन. आणि असे होईल की, तुम्ही निघाल तेव्हा रिकामे निघणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","तर प्रत्येक स्त्री आपल्या शेजारणीकडून व आपल्या घरात राहणाऱ्या स्त्रीकडून भेटवस्तू मागून घेईल व ते लोक तिला भेटवस्तू देतील; ते तुम्हा लोकांस सोन्यारुप्याचे दागिने व कपडे भेट म्हणून देतील. तुम्ही ते आपल्या मुलांच्या व मुलींच्या अंगावर घालाल. अशा प्रकारे तुम्ही मिसराच्या लोकांस लुटाल.” ");
INSERT INTO mar_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","मग मोशेने उत्तर दिले, “ते माझ्यावर विश्वास ठेवणार नाहीत व माझे म्हणणे ऐकणार नाहीत; ते म्हणतील, परमेश्वराने तुला दर्शन दिलेलेच नाही.” ");
INSERT INTO mar_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","परंतु परमेश्वर मोशेला म्हणाला, “तुझ्या हातात ते काय आहे?” मोशेने उत्तर दिले, “काठी आहे.” ");
INSERT INTO mar_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","मग देव म्हणाला, “ती जमिनीवर टाक.” तेव्हा मोशेने तसे केले; आणि त्या काठीचा साप झाला. तेव्हा मोशे घाबरला व त्यापासून पळाला. ");
INSERT INTO mar_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","परंतु परमेश्वर मोशेला म्हणाला, “तुझा हात पुढे कर व त्याचे शेपूट धर.” तेव्हा त्याने तसे केले, आपला हात पुढे करून त्यास धरले. तेव्हा त्याच्या हातात तो पुन्हा काठी झाला. ");
INSERT INTO mar_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“म्हणजे ह्यावरून ते विश्वास धरतील, त्यांचा पूर्वजांचा-अब्राहामाचा देव, इसहाकाचा देव व याकोबाचा देव परमेश्वर याने तुला दर्शन दिले आहे.” ");
INSERT INTO mar_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","मग परमेश्वर त्यास आणखी म्हणाला, “तू तुझा हात तुझ्या छातीवर ठेव,” तेव्हा मोशेने आपला हात आपल्या छातीवर ठेवला; मग त्याने आपला हात बाहेर काढला तेव्हा तो कोडाने बर्फासारखा पांढरा झाला; ");
INSERT INTO mar_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","मग देव म्हणाला, “आता पुन्हा तुझा हात तुझ्या छातीवर ठेव.” तेव्हा मोशेने तसे केले. मग त्याने आपला हात छातीवरून काढला तेव्हा तो शरीराच्या इतर भागांप्रमाणे होऊन तो पुन्हा पूर्वीसारखा झाला. ");
INSERT INTO mar_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","मग परमेश्वर बोलला, “जर ते तुझ्यावर विश्वास ठेवणार नाहीत, व पहिल्या चिन्हामुळे तुझा शब्द ऐकणार नाहीत तर दुसऱ्या चिन्हामुळे ते तुझ्यावर विश्वास ठेवतील. ");
INSERT INTO mar_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ही दोन्ही चिन्हे दाखवल्यावरही त्यांनी जर तुझ्यावर विश्वास ठेवला नाही, तर मग नदीचे थोडे पाणी घे आणि ते कोरड्या जमिनीवर ओत; म्हणजे तू नदीतून घेतलेल्या पाण्याचे कोरड्या भूमीवर रक्त होईल.” ");
INSERT INTO mar_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","मग मोशे परमेश्वरास म्हणाला, “परंतु हे प्रभू, मी तुला खरे ते सांगतो; मी काही बोलका नाही; मी पूर्वीही नव्हतो आणि आता तुझ्याबरोबर बोलल्यानंतरही नाही. तुला माहित आहे की मी तर मुखाचा व जिव्हेचाही जड आहे.” ");
INSERT INTO mar_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","मग परमेश्वर त्यास म्हणाला, “मनुष्याचे तोंड कोणी केले? मनुष्यास मुका किंवा बहिरा, आंधळा किंवा डोळस कोण करतो? मी परमेश्वरच की नाही? ");
INSERT INTO mar_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","तेव्हा मी सांगतो, तू आता जा. मी तुझ्या मुखाला साहाय्य होईन व तू काय बोलावे हे मी तुला शिकवीन.” ");
INSERT INTO mar_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","परंतु मोशे म्हणाला, हे प्रभू! मी तुला विनंती करतो की, तुझ्या इच्छेस येईल त्याच्या हाती त्यास निरोप पाठव. ");
INSERT INTO mar_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","मग परमेश्वर मोशेवर रागावला. तो त्यास म्हणाला, “लेवी अहरोन हा तुझा भाऊ आहे ना? त्यास चांगले बोलता येते हे मला माहीत आहे. तो तुला भेटायला येत आहे. तुला पाहून त्यास मनात आनंद होईल. ");
INSERT INTO mar_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","तू त्याच्याबरोबर बोलून त्याच्या मुखात शब्द घाल. मी त्याच्या व तुझ्या मुखांना साहाय्य होईल आणि तुम्ही काय करावे हे तुम्हास शिकवीन. ");
INSERT INTO mar_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","आणि तो तुझ्यासाठी लोकांशी बोलेल; तो तुझे मुख होईल आणि त्याने काय बोलावे हे सांगणारा तू त्यास देवासारखा होशील. ");
INSERT INTO mar_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","तू आपल्या हाती ही तुझी काठी घे. हिच्या योगे तू चिन्हे करशील.” ");
INSERT INTO mar_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","मग मोशे आपला सासरा इथ्रो याच्याकडे परत गेला. तो त्यास म्हणाला, “मला मिसरातील माझ्या भाऊबंदांकडे जाऊ द्या. ते अद्याप जिवंत आहेत की नाहीत ते मला पाहू द्या.” इथ्रो मोशेला म्हणाला, शांतीने जा. ");
INSERT INTO mar_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","मिद्यान प्रांतात असताना परमेश्वर मोशेला म्हणाला, “आता मिसर देशात परत जा. जे लोक तुला ठार मारू पाहत होते ते आता मरण पावले आहेत.” ");
INSERT INTO mar_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","तेव्हा मोशेने आपली पत्नी व आपल्या मुलांना गाढवावर बसवले व त्यांना घेऊन तो मिसर देशाला माघारी जायल निघाला. तो देवाची काठी आपल्या हाती घेऊन चालला. ");
INSERT INTO mar_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","परमेश्वर मोशेला म्हणाला, तू मिसरात परत जाशील तेव्हा पाहा, जे सर्व चमत्कार मी तुझ्या हाती ठेवले आहे ते तू फारोपुढे करून दाखव. तथापि मी त्याचे मन कठीण करीन, आणि तो लोकांस जाऊ देणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","मग तू फारोला सांग की, परमेश्वर म्हणतो इस्राएल माझा पुत्र, माझा ज्येष्ठ पुत्र आहे. ");
INSERT INTO mar_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","परमेश्वर म्हणतो, मी तुला सांगत आहे की “तू माझ्या पुत्राला माझी उपासना करण्याकरता जाऊ दे!” जर तू त्यास जाऊ देण्याचे नाकारशील तर मी तुझ्या ज्येष्ठ पुत्राला ठार मारीन. ");
INSERT INTO mar_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","मोशे प्रवासात असताना एके ठिकाणी मुक्कामासाठी थांबला. तेव्हा परमेश्वराने मोशेला त्या ठिकाणी गाठून त्यास ठार मारण्याचा प्रयत्न केला. ");
INSERT INTO mar_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","परंतु सिप्पोराने एक गारगोटीची धारदार सुरी घेतली व तिने आपल्या मुलाची सुंता केली. मग तिने मुलांची अग्रत्वचा घेतली आणि ती मोशेच्या पायावर ठेवून ती त्यास म्हणाली, “खचीत तू माझा रक्ताने मिळवलेला पती आहेस.” ");
INSERT INTO mar_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","तेव्हा परमेश्वराने त्यास पीडण्याचे सोडले. रक्ताने मिळविलेला पती असे तिने सुंतेला उद्देशून म्हटले. ");
INSERT INTO mar_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","मग परमेश्वराने अहरोनाला सांगितले, “मोशेला भेटायला रानात जा.” तो गेला आणि देवाच्या डोंगरावर जाऊन मोशेला भेटला आणि त्याने त्याचे चुंबन घेतले. ");
INSERT INTO mar_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","परमेश्वराने त्यास जे सर्वकाही सांगून पाठवले होते ते, जी सर्व चिन्हे करून दाखवायची आज्ञा दिली होती ती मोशेने अहरोनाला सांगितली. ");
INSERT INTO mar_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","मग मोशे व अहरोन यांनी जाऊन इस्राएली वंशजांचे सर्व वडीलजन एकत्र जमवले. ");
INSERT INTO mar_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","नंतर परमेश्वराने मोशेला जे काही सांगितले होते ते सर्व अहरोनाने लोकांस कळवले; त्यांना चिन्हे करून दाखवली. ");
INSERT INTO mar_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","तेव्हा लोकांनी विश्वास ठेवला. परमेश्वराने इस्राएली घराण्याची भेट घेऊन त्यांचे दुःख पाहिले आहे हे त्यांनी ऐकले तेव्हा त्यांनी नमन करून त्याची उपासना केली. ");
INSERT INTO mar_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","या गोष्टी घडल्यानंतर, मोशे व अहरोन फारोकडे गेले व त्यास म्हणाले, “इस्राएली लोकांचा देव परमेश्वर म्हणतो, माझ्या लोकांनी माझ्यासाठी रानात उत्सव करावा म्हणून त्यांना जाऊ दे.” ");
INSERT INTO mar_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फारो म्हणाला, “हा परमेश्वर कोण आहे? मी त्याचा शब्द का ऐकावा आणि इस्राएलाला जाऊ द्यावे? मी त्या परमेश्वरास ओळखत नाही. म्हणून इस्राएलाला मी जाऊ देणार नाही.” ");
INSERT INTO mar_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","मग अहरोन व मोशे म्हणाले, “इब्री लोकांचा देव आम्हांशी बोलला आहे. म्हणून आम्हांला रानात तीन दिवसाच्या वाटेवर जाऊ द्यावे आणि तेथे आमचा देव परमेश्वर याल यज्ञार्पण करू द्यावे अशी आम्ही आपणाला विनंती करतो. आणि आम्ही जर असे केले नाही तर तो मरीने किंवा तलवारीने आमच्यावर तुटून पडेल.” ");
INSERT INTO mar_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","परंतु मिसराचा राजा फारो त्यांना म्हणाला, “हे मोशे, हे अहरोना, तुम्ही लोकांस काम सोडून जायला का लावता? तुम्ही आपल्या कामावर माघारी चालते व्हा. ");
INSERT INTO mar_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","फारो त्यांना असेही म्हणाला, येथे आता आमच्या देशात खूप इब्री आहेत आणि तुम्ही त्यांना काम करण्यापासून थांबवत आहात.” ");
INSERT INTO mar_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","त्याच दिवशी फारोने मुकादमांना व नायकांना आज्ञा दिली. ");
INSERT INTO mar_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","तो त्यांना म्हणाला, “तुम्ही लोकांस विटा बनवण्याकरिता आजपर्यंत सतत गवत दिलेले आहे. परंतु आता त्यांना लागणारे गवत त्यांना स्वत: शोधून आणायला सांगा. ");
INSERT INTO mar_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तरी पूर्वी इतक्याच विटा त्यांनी बनवल्या पाहिजेत. त्यामध्ये काही कमी करून स्वीकारू नका. कारण ते आळशी झाले आहेत. म्हणूनच ते ओरड करून म्हणतात, आम्हांला जाण्याची परवानगी दे आणि आमच्या देवाला यज्ञ करू दे. ");
INSERT INTO mar_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","तेव्हा त्यांच्यावर अधिक काम लादून त्यांना सतत कामात ठेवा. म्हणजे मग खोट्या बोलण्यावर विश्वास ठेवणार नाहीत.” ");
INSERT INTO mar_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","म्हणून लोकांचे मुकादम व नायक लोकांकडे जाऊन म्हणाले, “फारो असे म्हणतो, तुम्हास विटा बनवण्यासाठी लागणारे गवत देणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","तेव्हा तुम्हास लागणारे गवत तुम्ही स्वत:च आणले पाहिजे. तुमचे काम काही कमी होणार नाही.” ");
INSERT INTO mar_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","म्हणून मग लोक गवत शोधण्याकरता सर्व मिसर देशभर पांगले. ");
INSERT INTO mar_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","त्यांच्यावर नेमलेले मुकादम त्यांच्याकडून अधिक काम करवून घेऊन पूर्वी इतक्याच विटा तयार करण्याकरता त्यांच्यामागे सतत तगादा लावत. ");
INSERT INTO mar_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","मिसराच्या मुकादमांनी इस्राएली लोकांवर नायक नेमले होते. त्यांना फारोच्या मुकादमांनी मार देऊन विचारले की, “तुम्ही पूर्वी जेवढ्या विटा बनवत होता तेवढ्या आता का बनवत नाही?” ");
INSERT INTO mar_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","मग इस्राएली नायक तक्रार घेऊन फारोकडे गेले व म्हणाले, “आम्ही जे तुमचे सेवक त्या आमच्याशी तुम्ही अशा प्रकारे का वागत आहा? ");
INSERT INTO mar_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","तुम्ही आम्हांला गवत देत नाही, परंतु पूर्वी इतक्याच विटा बनवण्याचा हुकूम करता, आणि आता आपल्या दासांना मार मिळत आहे. पण सारा दोष आपल्या लोकांचा आहे.” ");
INSERT INTO mar_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फारो म्हणाला, “तुम्ही आळशी आहात, म्हणूनच तुम्ही म्हणता, आम्हांला परमेश्वरास यज्ञ करायला जाऊ देण्याची परवानगी दे. ");
INSERT INTO mar_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","आता आपल्या कामावर माघारी जा. तुम्हास गवत काही मिळायचे नाही, परंतु पूर्वीप्रमानेच विटा तुम्ही केल्या पाहिजेत. ");
INSERT INTO mar_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","आपण संकटात आहोत हे इस्राएली नायकांना समजले. कारण पूर्वी इतक्याच विटा व रोजचे काम त्यांना शक्य नव्हते.” ");
INSERT INTO mar_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","फारोच्या भेटीनंतर परत जाताना त्यांना वाटेत मोशे व अहरोन भेटले; ");
INSERT INTO mar_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","तेव्हा ते मोशे व अहरोन ह्यांना म्हणाले, “परमेश्वर तुम्हांकडे पाहो व तुम्हास शिक्षा करो. कारण फारो व त्याचे सेवक यांच्या दृष्टीने तुम्ही आम्हांला अपमानकारक केले आहे. आम्हांला मारून टाकण्यासाठी तुम्ही त्यांच्या हातात जणू तलवारच दिली आहे.” ");
INSERT INTO mar_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","मग मोशेने परमेश्वराकडे परत जाऊन प्रार्थना करून म्हटले, “प्रभू, तू या लोकांस का त्रास देत आहेस? पहिली गोष्ट म्हणजे तू मला का पाठवलेस? ");
INSERT INTO mar_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","मी तुझ्या नावाने बोलण्यासाठी फारोकडे आलो, तेव्हापासून तो या लोकांस त्रास देत आहे. आणि तू आपल्या लोकांस मुक्त तर मुळीच केले नाहीस.” ");
INSERT INTO mar_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तेव्हा परमेश्वर मोशेला म्हणाला, “मी आता फारोला काय करतो ते तू बघशील; मी माझे बाहुबल त्यास दाखवले म्हणजे मग तो माझ्या लोकांस जाऊ देईल. कारण माझ्या बाहुबलामुळे तो त्यांना आपल्या देशातून बाहेर घालवून देईल.” ");
INSERT INTO mar_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","मग देव मोशेला म्हणाला, “मी परमेश्वर आहे ");
INSERT INTO mar_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","मी अब्राहाम, इसहाक व याकोब यांना सर्वसमर्थ देव म्हणून प्रगट झालो; परंतु मी त्यांना परमेश्वर या माझ्या नावाने त्यांना माहीत नव्हतो. ");
INSERT INTO mar_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ज्या कनान देशात ते उपरी होते तो परदेश त्यांना वतन देण्याविषयीचा करार मी त्यांच्याशी केला आहे. ");
INSERT INTO mar_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ज्या इस्राएलाला मिसऱ्यांनी दास करून ठेवले आहे त्यांचे कण्हणे ऐकून मी आपल्या कराराची आठवण केली आहे. ");
INSERT INTO mar_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","तेव्हा इस्राएलाला सांग, मी तुमचा परमेश्वर आहे; मी तुम्हास मिसऱ्यांच्या दास्यातून सोडवीन आणि मी तुम्हास त्यांच्या अधिकारातून मुक्त करीन, आणि मी आपले सामर्थ्य दाखवून व सामर्थ्यशाली निवाड्याची कृती करून तुम्हास सोडवीन. ");
INSERT INTO mar_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","मी तुम्हास आपले लोक करून घेईन आणि मी तुमचा देव होईन. मी तुम्हास मिसऱ्यांच्या दास्यातून काढून आणतो तो मी तुमचा देव परमेश्वर आहे हे तुम्हास समजेल. ");
INSERT INTO mar_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","जो देश मी अब्राहाम, इसहाक व याकोबास देण्याची मी हात वर करून शपथ वाहिली होती त्यामध्ये मी तुम्हास नेईन; व तो मी तुम्हास वतन करून देईन. मी परमेश्वर आहे.” ");
INSERT INTO mar_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","तेव्हा मोशेने हे सर्व इस्राएल लोकांस सांगितले. परंतु त्यांच्या बिकट दास्यामुळे ते नाउमेद झाल्यामुळे ते त्याचे म्हणणे ऐकेनात. ");
INSERT INTO mar_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","मग परमेश्वर मोशेशी बोलला व म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“तू जाऊन मिसराचा राजा फारो याला सांग की इस्राएली लोकांस तुझ्या देशातून जाऊ दे” ");
INSERT INTO mar_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","तेव्हा मोशे परमेश्वरास म्हणाला, “इस्राएली लोकांनी माझे ऐकले नाही, तर फारो माझे कसे ऐकेल? कारण मी अजिबात चांगला वक्ता नाही.” ");
INSERT INTO mar_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","परमेश्वराने मोशे व अहरोन यांना इस्राएल लोकांस मिसर देशातून बाहेर नेण्याविषयी आज्ञा देऊन इस्राएल लोकांकडे आणि तसेच मिसरी राजा फारो याच्याकडे पाठवले. ");
INSERT INTO mar_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","मोशे व अहरोन यांच्या पूर्वजांपैकी प्रमुख पुरुषांची नावे अशीः इस्राएलाचा ज्येष्ठ पुत्र रऊबेन. त्याची मुले हनोख, पल्लू, हेस्रोन व कर्मी. हे रऊबेनाचे कुळ. ");
INSERT INTO mar_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमोनाचे पुत्र यमुवेल, यामीन, ओहद, याखीन, जोहर व (कनानी स्त्री पोटी झालेला शौल); ही शिमोनाची कूळे. ");
INSERT INTO mar_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवीचे आयुष्य एकशे सदतीस वर्षांचे होते. लेवीच्या वंशावळीप्रमाणे त्याच्या पुत्रांची नावे हेः गेर्षोन, कहाथ, व मरारी. ");
INSERT INTO mar_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्षोनाचे पुत्रः त्यांच्या त्यांच्या कुळाप्रमाणे हेः गेर्षोनाचे दोन पुत्र लिब्नी व शिमी. ");
INSERT INTO mar_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहाथाचे पुत्रः अम्राम, इसहार, हेब्रोन व उज्जियेल. कहाथाचे आयुष्य एकशे तेहतीस वर्षांचे होते. ");
INSERT INTO mar_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारीचे पुत्रः महली व मूशी. लेवीची कुळे त्याच्या वंशावळीप्रमाणे ही होती. ");
INSERT INTO mar_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्रामाने आपली आत्या योखबेद हिच्याशी लग्न केले, तिच्या पोटी त्यास अहरोन व मोशे हे दोन पुत्र झाले. अम्राम एकशे सदतीस वर्षे जगला. ");
INSERT INTO mar_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","इसहाराचे पुत्रः कोरह, नेफेग व जिख्री. ");
INSERT INTO mar_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्जियेलाचे पुत्र: मिशाएल, एलसाफान व सिथ्री. ");
INSERT INTO mar_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","अहरोनाने अलीशेबाशी लग्न केले. (अलीशेबा अम्मीनादाबाची कन्या व नहशोनाची बहीण होती) त्यांना नादाब, अबीहू, एलाजार व इथामार ही मुले झाली. ");
INSERT INTO mar_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरहाचे पुत्रः अस्सीर, एलकाना व अबीयासाफ; ही कोरहाची कुळे. ");
INSERT INTO mar_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","अहरोनाचा पुत्र एलाजार याने पुटीयेलाच्या कन्येशी लग्न केले; तिच्या पोटी त्यास फिनहास हा पुत्र झाला. हे सर्व लोक म्हणजे इस्राएलाचा पुत्र लेवी याची वंशावळ होय. ");
INSERT INTO mar_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","इस्राएल लोकांस मिसर देशातून बाहेर घेऊन जा असे परमेश्वराने ज्यांना सांगितले होते ते अहरोन व मोशे याच कुळातले. ");
INSERT INTO mar_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","इस्राएल लोकांस मिसर देशातून बाहेर जाऊ द्यावे असे मिसराचा राजा फारो याच्याशी जे बोलले तेच हे अहरोन व मोशे. ");
INSERT INTO mar_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","मग मिसर देशात परमेश्वर मोशेबरोबर बोलला. ");
INSERT INTO mar_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","परमेश्वर मोशेला म्हणाला, “मी परमेश्वर आहे. मी तुला सांगतो ते सर्व तू मिसराचा राजा फारो याला सांग.” ");
INSERT INTO mar_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","परंतु मोशेने परमेश्वरासमोर उत्तर दिले, “मी तर चांगला वक्ता नाही. फारो राजा माझे ऐकणार नाही.” ");
INSERT INTO mar_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","परमेश्वर मोशेला म्हणाला, “पाहा, मी तुला फारोच्या नजरेत देवासमान महान करतो; आणि तुझा भाऊ अहरोन हा तुझा संदेष्टा होईल; ");
INSERT INTO mar_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ज्या आज्ञा मी तुला करीन त्या सर्व तू अहरोनाला सांग; मग तू इस्राएल लोकांस हा देश सोडून जाऊ दे, असे तू फारोला सांग. ");
INSERT INTO mar_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","परंतु मी फारोचे मन कठोर करीन. मग मी मिसर देशामध्ये आपल्या सामर्थ्याची अनेक चिन्हे व अनेक आश्चर्ये दाखवीन. ");
INSERT INTO mar_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","तरीही फारो तुमचे काही ऐकणार नाही. तेव्हा मग मी आपला हात मिसरावर चालवीन आणि त्यास जबर शिक्षा करून मी आपली सेना, माझे लोक, इस्राएल वंशज यांना मिसर देशातून काढून आणीन. ");
INSERT INTO mar_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","आणि मिसरावर मी हात उगारून त्यांच्यातून इस्राएली लोकांस काढून आणीन, तेव्हा मिसऱ्यांना कळेल की मी परमेश्वर आहे.” ");
INSERT INTO mar_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","मग मोशे व अहरोन यांनी तसे केले. परमेश्वराने त्यांना आज्ञा केल्याप्रमाणे त्यांनी केले. ");
INSERT INTO mar_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ते फारोबरोबर बोलले तेव्हा मोशे ऐंशी वर्षांचा व अहरोन त्र्याऐंशी वर्षांचा होता. ");
INSERT INTO mar_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","नंतर परमेश्वर मोशे व अहरोन यांना म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“फारो तुम्हास एखादा चमत्कार दाखविण्याविषयी विचारील तेव्हा अहरोनाला आपली काठी फारोच्या देखत जमिनीवर टाकावयास सांग म्हणजे तिचा साप होईल.” ");
INSERT INTO mar_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","तेव्हा मोशे व अहरोन फारोकडे गेले आणि परमेश्वराने आज्ञा केल्याप्रमाणे त्यांनी केले. अहरोनाने आपली काठी फारो व त्याचे सेवक यांच्यापुढे टाकली आणि त्या काठीचा साप झाला. ");
INSERT INTO mar_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तेव्हा फारो राजाने आपले जाणते व मांत्रिक बोलावले; मिसराच्या त्या जादूगारांनी आपल्या मंत्रतंत्राच्या जोरावर तसाच प्रकार केला. ");
INSERT INTO mar_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","त्यांनीही आपल्या काठ्या जमिनीवर टाकल्या तेव्हा त्यांचेही साप झाले, परंतु अहरोनाच्या काठीने त्यांचे साप गिळून टाकले. ");
INSERT INTO mar_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","तरी परमेश्वराने सांगितल्याप्रमाणे फारोचे मन कठोर झाले आणि त्याने मोशे व अहरोन यांचे ऐकले नाही व इस्राएल लोकांस जाऊ दिले नाही. ");
INSERT INTO mar_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","मग परमेश्वर मोशेला म्हणाला, “फारोचे मन कठीण झाले आहे; तो इस्राएल लोकांस जाऊ देत नाही. ");
INSERT INTO mar_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","उद्या सकाळी फारो नदीवर जाईल; तू साप झालेली काठी बरोबर घे आणि नदीच्या काठी त्यास भेटण्यास उभा राहा. ");
INSERT INTO mar_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","त्यास असे सांग, ‘इब्र्यांचा देव परमेश्वर याने मला तुझ्याकडे पाठवले आहे व त्याच्या लोकांस त्याची उपासना करावयास रानात जाऊ दे, पण आतापर्यंत तू ऐकले नाहीस. ");
INSERT INTO mar_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","परमेश्वर म्हणतो, की मी परमेश्वर आहे हे त्यास यावरुन कळेल: मी नदीच्या पाण्यावर माझ्या हातातील काठीने मारीन तेव्हा त्याचे रक्त होईल. ");
INSERT INTO mar_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","मग पाण्यातील सर्व मासे मरतील. नदीला घाण सुटेल आणि मिसराचे लोक नदीचे पाणी पिऊ शकणार नाहीत. ");
INSERT INTO mar_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","परमेश्वराने मोशेला म्हटले, तू अहरोनाला सांग की, आपली काठी घेऊन मिसर देशामधील नद्यांवर, नाल्यावर, त्यांच्या तलावावर व त्यांच्या सर्व पाण्याच्या तळ्यावर आपला हात उगार म्हणजे त्या सर्वांचे रक्त होईल, घरातील लाकडांच्या व दगडांच्या भांड्यात रक्तच रक्त होईल.” ");
INSERT INTO mar_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","तेव्हा मोशे व अहरोन यांनी परमेश्वराने सांगितल्याप्रमाणे केले. अहरोनाने आपली काठी उचलून फारोच्या व त्याच्या अधिकाऱ्यासमोर पाण्यावर मारली. तेव्हा नदीतल्या सर्व पाण्याचे रक्त झाले. ");
INSERT INTO mar_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नदीतले मासे मरण पावले व तिला घाण सुटली. त्यामुळे मिसरी लोकांस नदीतील पाणी पिववेना. अवघ्या मिसर देशात रक्तच रक्त झाले. ");
INSERT INTO mar_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","तेव्हा मिसराच्या जादूगारांनी आपल्या मंत्रतंत्राच्या जोरावर तसेच केले. तेव्हा परमेश्वराने संगितल्याप्रमाणे फारोचे मन कठीण झाले. ");
INSERT INTO mar_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","नंतर फारो मागे फिरला व आपल्या घरी निघून गेला. त्याने याकडे लक्ष देखील दिले नाही. ");
INSERT INTO mar_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","मिसराच्या लोकांस नदीचे पाणी पिववेना म्हणून त्यांनी पिण्याच्या पाण्यासाठी झरे खणले. ");
INSERT INTO mar_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","परमेश्वराने नदीला दिलेल्या तडाख्याला सात दिवस होऊन गेले. ");
INSERT INTO mar_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","मग परमेश्वराने मोशेला सांगितले, “जा आणि फारोला सांग, परमेश्वर असे म्हणतो की, ‘माझ्या लोकांस माझी उपासना करण्याकरता जाऊ दे. ");
INSERT INTO mar_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","जर तू त्यांना जाऊ दिले नाहीस तर मी तुझा सारा देश बेडकांनी पीडीन. ");
INSERT INTO mar_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नदीत बेडकांचा सुळसुळाट होईल. बेडूक नदीतून तुझ्या वाड्यात झोपण्याच्या खोलीत, अंथरुणात तसेच तुझ्या सेवकांच्या व अधिकाऱ्यांच्या घरात, तुझ्या भट्ट्यात आणि काथवटीत येतील. ");
INSERT INTO mar_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","तुझ्या, तुझ्या सेवकांच्या व लोकांच्या अंगावर बेडूक चढतील.” ");
INSERT INTO mar_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","मग परमेश्वर मोशेला म्हणाला, “अहरोनाला त्याच्या हातातील काठी नद्या, नाले तलाव यांच्या जलावर लांब कर म्हणजे मग बेडूक मिसर देशावर चढून येतील.” ");
INSERT INTO mar_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","मग अहरोनाने आपला हात मिसराच्या जलाशयावर लांब केला तेव्हा बेडूक बाहेर आले आणि त्यांनी अवघा मिसर देश व्यापून टाकला. ");
INSERT INTO mar_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","तेव्हा जादूगारांनी मंत्रतंत्राच्या योगे तसेच केले आणि मिसर देशावर आणखी बेडूक आणले. ");
INSERT INTO mar_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","मग फारोने मोशे व अहरोन यांना बोलावून आणले. फारो त्यांना म्हणाला, “हे बेडूक माझ्यापासून, व माझ्या लोकांपासून दूर करण्याकरिता तुमच्या परमेश्वरास विनंती करा. मग तुमच्या परमेश्वराची उपासना करण्याकरिता मी तुम्हा लोकांस जाऊ देईन.” ");
INSERT INTO mar_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मोशे फारोला म्हणाला, “मग बेडूक तुम्हापासून व तुमच्या घरातून दूर होतील आणि फक्त नदीत राहतील. मी तुमच्यासाठी, तुमच्या लोकांसाठी व तुमच्या सेवकांसाठी कोणत्या वेळी प्रार्थना करावी हे सांगण्याचा मान माझ्याऐवजी तुला असो.” ");
INSERT INTO mar_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फारोने उत्तर दिले, “उद्या.” तेव्हा मोशे म्हणाला, “तुमच्या म्हणण्याप्रमाणे होईल अशा प्रकारे तुम्हास समजेल की आमच्या परमेश्वरासारखा कोणीच देव नाही. ");
INSERT INTO mar_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","बेडूक तुम्हापासून, तुमच्या घरातून, तुमचे सेवक व तुमचे लोक यांच्यापासून निघून जातील; ते फक्त नदीत राहतील.” ");
INSERT INTO mar_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","मग मोशे व अहरोन फारोपासून निघून गेले आणि फारोवर बेडूक आणले होते त्याविषयी मोशेने परमेश्वरास प्रार्थना केली. ");
INSERT INTO mar_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","मग परमेश्वराने मोशेच्या विनंतीप्रमाणे केले. तेव्हा घरादारात, अंगणात व शेतात होते ते सर्व बेडूक मरून गेले. ");
INSERT INTO mar_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","लोकांनी ते गोळा करून त्यांचे ढीग केले आणि त्यामुळे सर्व देशात घाण वास येऊ लागला. ");
INSERT INTO mar_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","बेडकांची पीडा दूर झाली हे फारोने पाहिले आणि त्याचे मन पुन्हा कठीण झाले. त्याने त्यांचे ऐकले नाही. परमेश्वराने सांगितल्याप्रमाणेच हे झाले. ");
INSERT INTO mar_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","मग परमेश्वर मोशेला म्हणाला, “अहरोनाला त्याची काठी जमिनीवरील धुळीवर मारण्यास सांग म्हणजे मग अवघ्या मिसर देशभर धुळीच्या उवा बनतील.” ");
INSERT INTO mar_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","त्याने तसे केले. अहरोनाने आपल्या हातातली काठी जमिनीवरील धुळीवर मारली, आणि त्यामुळे सगळ्या मिसर देशात धुळीच्या उवाच उवा बनल्या; त्या पशूंवर व मनुष्यांवर चढल्या. ");
INSERT INTO mar_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","जादुगारांनी त्यांच्या मंत्रतत्रांच्या जोरावर उवा उत्पन्न करण्याचा प्रयत्न केला, परंतु त्यांना धुळीतून उवा बनविता आल्या नाहीत; पशू व मनुष्य उवांनी भरून गेले. ");
INSERT INTO mar_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","तेव्हा जादूगारांनी फारोला सांगितले की, “यामध्ये देवाचा हात आहे.” परंतु फारोने मन कठीण केले व त्यांने त्यांचे ऐकायचे नाकारले. परमेश्वराने सांगितल्याप्रमाणेच तसे झाले. ");
INSERT INTO mar_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","मग परमेश्वर मोशेला म्हणाला, “सकाळी लवकर ऊठ आणि फारो नदीवर जाईल तेव्हा त्याच्यापुढे उभा राहा. त्यास असे सांग की परमेश्वर म्हणतो, माझी उपासना करण्यासाठी माझ्या लोकांस जाऊ दे. ");
INSERT INTO mar_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","जर तू त्यांना जाऊ देणार नाहीस तर मग तुझ्या घरात, तुझ्यावर, तुझ्या सेवकांवर गोमाशा येतील. अवघ्या मिसर देशातील घरे गोमाशांच्या थव्यांनी भरून जातील. गोमाशांचे थवे अंगणात व जमिनीवरही येतील. ");
INSERT INTO mar_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","तर ज्या गोशेन प्रातांत माझे लोक राहतात, तो मी त्या दिवशी वेगळा करीन, तेथे गोमाश्यांचे थवे जाणार नाहीत. यावरुन पृथ्वीवर मीच परमेश्वर आहे हे तुला समजेल. ");
INSERT INTO mar_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","तेव्हा उद्या माझ्या लोकांशी वागताना आणि तुमच्या लोकांशी वागताना मी भेद करीन. उद्या हा चमत्कार होईल.” ");
INSERT INTO mar_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","अशा रीतीने परमेश्वराने केले. मिसर देशात गोमाशांचे थवेच्या थवे आले. ते फारोच्या घरात व त्याच्या सेवकांच्या घरात व सगळ्या मिसर देशात गोमाशाचे थवेच्या थवे आले. गोमाश्यांच्या या थव्यांनी मिसर देशाची नासाडी केली. ");
INSERT INTO mar_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","म्हणून मग फारोने मोशे व अहरोन यांना बोलावून आणले व त्यांना सांगितले, “तुम्ही तुमच्या देवाला आमच्या येथेच म्हणजे आमच्या देशातच यज्ञ करा.” ");
INSERT INTO mar_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","परंतु मोशे म्हणाला, “तसे करणे योग्य होणार नाही, कारण आमचा देव परमेश्वर ह्याला आम्ही जो यज्ञ करणार आहो तो यज्ञ तुम्हा मिसरी लोकांच्या दृष्टीने किळसवाणा असेल, त्यामुळे आम्ही तो मिसरी लोकांसमोर केला तर ते आम्हांवर दगडफेक करायचे नाहीत काय? ");
INSERT INTO mar_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","तर आम्हांला रानात तीन दिवसाच्या वाटेवर जाऊ द्या. आमचा देव परमेश्वर ह्याने आम्हांला सांगेल त्याप्रमाणे त्यास यज्ञ करू.” ");
INSERT INTO mar_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","तेव्हा फारो म्हणाला, “मी तुम्हास तुमचा देव परमेश्वर ह्याला यज्ञ करण्याकरिता रानात जाऊ देण्याची परवानगी देतो. पण तुम्ही फार दूर जाऊ नका. माझ्यासाठी प्रार्थना करा.” ");
INSERT INTO mar_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मोशे म्हणाला, “पाहा, मी तुमच्यापासून जातो आणि फारो व त्याचे सेवक या सर्वांपासून उद्या गोमाशांचे थवे दूर करण्याकरिता परमेश्वरास विनंती करतो. परंतु परमेश्वरासाठी यज्ञ करण्यास जाणाऱ्या आमच्या लोकांस तुम्ही पुन्हा फसवू नये.” ");
INSERT INTO mar_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","तेव्हा मोशे फारोपासून निघून गेला आणि त्याने परमेश्वराची प्रार्थना केली. ");
INSERT INTO mar_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","या प्रकारे परमेश्वराने मोशेची विनंती मान्य केली व त्याने फारो, त्याचे सेवक व त्याचे लोक यांच्यापासून सर्व गोमाशाचे थवे दूर केले. तेथे एकही गोमाशी राहिली नाही. ");
INSERT INTO mar_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","परंतु फारोने पुन्हा आपले मन कठोर केले आणि त्याने इस्राएली लोकांस जाऊ दिले नाही. ");
INSERT INTO mar_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","नंतर परमेश्वराने मोशेला फारोकडे जाऊन असे बोलण्यास सांगितले, “इब्र्यांचा देव परमेश्वर म्हणतो, ‘माझी उपासना करण्याकरिता माझ्या लोकांस जाऊ दे.’ ");
INSERT INTO mar_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","जर तू त्यांना जाण्यापासून सतत असाच नाकारीत राहशील व जर तू त्यांना मागे ठेवून घेशील. ");
INSERT INTO mar_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","तर पाहा, घोडे, गाढवे, उंट, गुरेढोरे व शेरडेमेंढरांचे कळप, ही जी तुझी जनावरे रानांत आहेत त्यांच्यावर परमेश्वराचा हात पडेल. भयंकर मरी उद्भवेल. ");
INSERT INTO mar_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","परंतु परमेश्वर इस्राएलाची व मिसराची गुरेढोरे यांच्यात भेद करील; इस्राएली लोकांचे एकही जनावर मरणार नाही.” ");
INSERT INTO mar_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","याकरिता परमेश्वराने वेळही नेमलेली आहे. “या देशात उद्या हे सर्व घडून येईल.” ");
INSERT INTO mar_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","दुसऱ्या दिवशी परमेश्वराने ही गोष्ट केली आणि मिसरमधील सर्व गुरे मरण पावली. परंतु इस्राएल लोकांच्या गुरांपैकी एकही मरण पावले नाही. ");
INSERT INTO mar_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फारोने बारकाईने चौकशी केली आणि पाहा, इस्राएल लोकांच्या जनावरांपैकी एकही मरण पावले नव्हते. तरीपण फारोचे मन कठीणच राहिले. त्याने इस्राएल लोकांस जाऊ दिले नाही. ");
INSERT INTO mar_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","नंतर परमेश्वर मोशे व अहरोन यांना म्हणाला, “मोशेने ओंजळभर भट्टीची राख घेऊन फारोदेखत आकाशाकडे उधळावी. ");
INSERT INTO mar_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","त्या राखेचे बारीक कण सगळ्या मिसरभर पसरतील आणि त्यांच्या स्पर्शाने मनुष्यांना व पशूंना फोड येऊन गळवे येतील.” ");
INSERT INTO mar_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","तेव्हा मोशे व अहरोन यांनी भट्टीतून राख घेतली व ते फारो राजासमोर उभे राहिले. मोशेने ती राख हवेत उधळली आणि त्यामुळे मनुष्यांना व पशूंना फोड व गळवे आले. ");
INSERT INTO mar_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","गळव्यामुळे जादूगारांना मोशेपुढे उभे राहवेना. कारण जादूगारांना व सर्व मिसरी लोक यांना गळवे आली होती. ");
INSERT INTO mar_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","परंतु परमेश्वराने फारोचे मन कठीण केले आणि त्याने मोशे व अहरोन यांचे ऐकले नाही, व लोकांस जाऊ दिले नाही. परमेश्वराने मोशेला असे सांगितलेच होते. ");
INSERT INTO mar_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","मग परमेश्वर मोशेला म्हणाला, “तू पहाटेस उठून फारोपुढे उभा राहा; आणि त्यास सांग की इब्र्यांचा देव परमेश्वर असे म्हणतो, माझी उपासना करण्याकरिता माझ्या लोकांस जाऊ दे. ");
INSERT INTO mar_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","कारण या वेळेस मी आपल्या सर्व पीडा तुझ्यावर, तुझ्या सेवकांवर व तुझ्या लोकांवर पाठवीन म्हणजे सर्व पृथ्वीवर माझ्यासारखा कोणी देव नाही, हे यावरुन तुला कळेल. ");
INSERT INTO mar_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","मी आपला हात उगारून तुझ्यावर व तुझ्या लोकांवर मरीचा प्रहार केला असता तू पृथ्वीवरून नष्ट झाला असता. ");
INSERT INTO mar_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","परंतु मी तुला एका हेतूने ठेवले आहे की मी तुला माझे सामर्थ्य दाखवावे आणि माझे नाव सर्व पृथ्वीवर विख्यात व्हावे यासाठीच मी तुला राखले आहे. ");
INSERT INTO mar_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","तू अजूनही माझ्या लोकांविरुद्ध आहेस. तू त्यांना जाऊ देत नाहीस. ");
INSERT INTO mar_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","म्हणून उद्या याच वेळेस मी गारांचा असा काही वाईट वादळी वर्षाव मिसरावर आणीन की असा गारांचा वादळी वर्षाव मिसर राष्ट्राची स्थापना झाल्यापासून कधी आला नाही. ");
INSERT INTO mar_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","तर आता माणसे पाठवून रानांतून तुझी गुरेढोरे व दुसरे जे काही रानात असेल ते आण. कारण जर एखादा मनुष्य किंवा पशू शेतात राहील तर तो मारला जाईल. जे जे तुम्ही तुमच्या घरात गोळा करून ठेवणार नाही त्यावर गारांचा भडीमार पडेल.” ");
INSERT INTO mar_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","फारोच्या सेवकांपैकी काहींना परमेश्वराच्या संदेशाची भीती वाटली त्यांनी लगेच आपली गुरेढोरे व गुलाम यांना आसऱ्याला घरी आणले व सुरक्षित जागी ठेवले. ");
INSERT INTO mar_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","परंतु इतर सेवकांनी परमेश्वराच्या संदेशाकडे दुर्लक्ष केले व रानांतील त्यांचे सर्व दास व गुरेढोरे, रानात राहू दिली. ");
INSERT INTO mar_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","परमेश्वराने मोशेला सांगितले, “तू आपले हात आकाशाकडे उगार आणि मग सर्व मिसरभर गारांच्या वर्षावाला सुरुवात होईल. गारांचा मारा सर्व लोकांवर, गुरांवर आणि मिसर देशातील सर्व शेतांवर होईल.” ");
INSERT INTO mar_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","तेव्हा मोशेने आपली काठी आकाशाकडे उगारली आणि मग परमेश्वराने मेघगर्जना, लखलखणाऱ्या विजा व गारा यांचा पृथ्वीवर वर्षाव केला. अशा प्रकारे परमेश्वराने मिसर देशावर भडीमार केला. ");
INSERT INTO mar_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","गारांचा मारा व त्यासोबत विजांच्या अग्नीचा लोळ जमिनीवर आला. मिसर राष्ट्राची स्थापना झाल्यापासून गारांचे असे भयंकर व वाईट वादळ मिसरावर कधी आले नव्हते. ");
INSERT INTO mar_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","त्या गारांच्या वादळाच्या माऱ्याने मिसर देशात, मनुष्ये, गुरेढोरे वगैरे जे काही वनांत होते त्या सर्वांवर गारांचा मारा झाला. शेतांतील सर्व वनस्पतींवर मारा झाला. तसेच वनांतील सर्व मोठमोठी झाडे मोडून पडली. ");
INSERT INTO mar_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","गोशेन प्रांतात इस्राएल लोक राहत होते तेथे गारांचा मुळीच वर्षाव झाला नाही. ");
INSERT INTO mar_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","फारोने मोशे व अहरोन यांना बोलावून आणले व त्यांना सांगितले, “या वेळी मी पाप केले आहे. परमेश्वर न्यायी आहे; मी व माझे लोक, आम्ही अपराधी आहोत. ");
INSERT INTO mar_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","तुम्ही परमेश्वराकडे विनवणी करा. हा झालेला गारांचा मारा व मेघांचा गडगडाट फार भयंकर झाला तेवढे पुरे, मी तुम्हास जाऊ देतो. तुम्ही यापुढे राहणार नाही.” ");
INSERT INTO mar_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मोशेने फारोला सांगितले, “जेव्हा मी हे शहर सोडून जाईन तेव्हा माझे हात पसरून मी परमेश्वरापुढे विनंती करीन आणि मग ही मेघगर्जना व हा गारांचा मारा थांबेल; तेव्हा तुला कळेल की पृथ्वी परमेश्वराची आहे. ");
INSERT INTO mar_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","परंतु तू व तुझे सेवक अजूनही परमेश्वर देवाचे भय बाळगीत नाहीत हे मला माहीत आहे.” ");
INSERT INTO mar_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","या वेळी सातूचे दाणे तयार होऊन तो कापणीला आला होता व जवसास बोंडे आली होती. या पिकांचा आता नाश झाला. ");
INSERT INTO mar_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","परंतु साधा गहू व काठ्या गहू इतर धान्यापेक्षा उशिरा पिकतात; त्याची उशिरा पेरणी झाल्यामुळे ते अजून उगवले नव्हते, म्हणून त्यांचा नाश झाला नाही. ");
INSERT INTO mar_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","मोशे फारोपुढून निघून नगराबाहेर गेला. त्याने परमेश्वराकडे हात पसरून प्रार्थना केली, आणि मेघगर्जना व गारांचा वर्षाव थांबला आणि पृथ्वीवर पाऊस पडणे बंद झाले. ");
INSERT INTO mar_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","पाऊस, गारा व मेघांचा गडगडाट बंद झाल्याचे फारोने पाहिले तेव्हा फारो व त्याचे सेवक यांनी मन कठोर करून पुन्हा पाप केले. ");
INSERT INTO mar_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","फारोने आपण दिलेल्या वचनाप्रमाणे करण्याचे नाकारले व इस्राएल लोकांस मोकळे करून त्याने जाऊ दिले नाही. परमेश्वराने मोशेद्वारे सांगितल्याप्रमाणेच हे झाले. ");
INSERT INTO mar_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","नंतर परमेश्वर मोशेला म्हणाला, “तू फारोकडे जा. त्याचे मन व त्याच्या सेवकांची मने मीच कठीण केली आहेत. माझ्या सामर्थ्याची चिन्हे त्यांच्यामध्ये दाखवावी म्हणून मी हे केले. ");
INSERT INTO mar_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","मी मिसऱ्यांना कसे कठोरपणे वागवले आणि त्यांच्यामध्ये अनेक सामर्थ्याची चिन्हे कशी केली हे तुम्ही तुमच्या मुलांना व नातवांना सांगावे म्हणून मी हे केले. या प्रकारे मी परमेश्वर आहे हे तुम्हास कळेल.” ");
INSERT INTO mar_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","मग मोशे व अहरोन फारोकडे गेले. त्यांनी त्यास सांगितले, “इब्र्यांचा देव परमेश्वर म्हणतो, ‘तू माझ्यापुढे नम्र होण्याचे कोठवर नाकारशील? माझी उपासना करण्याकरिता माझ्या लोकांस जाऊ दे. ");
INSERT INTO mar_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","जर तू माझ्या लोकांस जाऊ देण्याचे नाकारशील, तर उद्या मी तुझ्या देशावर टोळधाड आणीन. ");
INSERT INTO mar_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ते टोळ सर्व जमीन झाकून टाकतील. ते इतके असतील की तुला जमीन दिसणार नाही. गारा व पावसाच्या तडाख्यातून जे काही वाचले असेल त्यास टोळ खाऊन टाकतील. शेतांतील सर्व झाडांचा पाला ते खाऊन फस्त करतील. ");
INSERT INTO mar_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ते टोळ तुझी घरे, तुझ्या सेवकांची घरे, व मिसरमधील घरे, व्यापून टाकतील. तुझ्या वाडवडिलांनी आजपर्यंत पाहिले नसतील त्यापेक्षा कितीतरी पटींनी अधिक ते असतील.” नंतर मोशे फारोसमोरून निघून गेला. ");
INSERT INTO mar_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फारोचे सेवक फारोला म्हणाले, “हा मनुष्य आम्हावर कोठपर्यंत संकटे आणणार आहे? या इस्राएलांना आपला देव परमेश्वर ह्यांची उपासना करण्याकरिता जाऊ द्यावे. मिसराचा नाश झाला आहे हे तुम्हास अजून कळत नाही काय?” ");
INSERT INTO mar_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","मोशे व अहरोन यांना पुन्हा फारोकडे आणले, तो त्यांना म्हणाला, “जा व तुमचा देव परमेश्वर याची उपासना करा. परंतु कोण कोण जाणार आहेत?” ");
INSERT INTO mar_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मोशेने उत्तर दिले, “आमची तरुण व वृध्द मंडळी, तसेच आम्ही, आमची मुले व कन्या, आमचे शेरडामेंढरांचे कळप व गुरेढोरे या सर्वांस आम्ही घेऊन जाणार. कारण आम्हांला परमेश्वराचा उत्सव करायचा आहे.” ");
INSERT INTO mar_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फारो त्यांना म्हणाला, “तुम्ही व तुमची मुलेबाळे यांना मिसरमधून जाऊ दिले तर परमेश्वराची शपथ. सांभाळा, पाहा, तुमच्या मनात काहीतरी वाईट आहे. ");
INSERT INTO mar_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","नाही! फक्त तुमच्यातील पुरुषांनी तुमच्या परमेश्वराची उपासना करावयास जावे. कारण तेच तर तुम्हास पाहिजे आहे.” त्यानंतर त्यांना फारोपुढून घालवून दिले. ");
INSERT INTO mar_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","मग परमेश्वराने मोशेला सांगितले, “आपली काठी मिसर देशावर उगार म्हणजे टोळधाड येईल! ते टोळ मिसर देशभर पसरतील आणि पाऊस व गारा यांच्या सपाट्यातून वाचलेल्या वनस्पती खाऊन टाकतील.” ");
INSERT INTO mar_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","मग मोशेने आपल्या हातातील काठी मिसर देशावर उगारली तेव्हा परमेश्वराने एक दिवसभर व रात्रभर पूर्वेकडून वारा वाहविला, तेव्हा सकाळी वाऱ्याबरोबर टोळच टोळ आले. ");
INSERT INTO mar_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ते उडत आले व अवघ्या मिसर देशभर जमिनीवर पसरले. इतके टोळ ह्यापूर्वी मिसर देशावर कधी आले नव्हते व इतके येथून पुढेही कधी येणार नाहीत. ");
INSERT INTO mar_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","त्या टोळांनी सर्व जमीन झाकून टाकली, आणि त्यांच्या आकाशात उडण्यामुळे सर्व देशभर अंधार पडला. गारांच्या तडाख्यातून वाचलेल्या वनस्पती आणि झाडावरील वाचलेली फळे त्यांनी खाऊन फस्त केली; आणि मिसरातील कुठल्याच झाडाझुडपांवर एकही पान राहिले नाही. ");
INSERT INTO mar_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","फारोने तातडीने मोशे व अहरोन यांना बोलावून आणले. तो म्हणाला, “तुमचा देव परमेश्वर याच्याविरुद्ध व तुम्हाविरुध्द मी पाप केले आहे. ");
INSERT INTO mar_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","तेव्हा या वेळी माझ्या पापाबद्दल मला क्षमा करा आणि हे टोळ माझ्यापासून दूर करण्याकरिता तुमचा देव परमेश्वर याकडे प्रार्थना करा.” ");
INSERT INTO mar_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","मोशे फारोसमोरून निघून गेला व त्याने परमेश्वराची प्रार्थना केली. ");
INSERT INTO mar_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","तेव्हा परमेश्वराने पश्चिमेकडून जोराचा वारा वाहविला तेव्हा त्या वाऱ्याने सर्व टोळांना उडवून तांबड्या समुद्रात लोटले. मिसरमध्ये एकही टोळ राहिला नाही. ");
INSERT INTO mar_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","तरी परमेश्वराने फारोचे मन पुन्हा कठीण केले आणि त्याने इस्राएल लोकांस जाऊ दिले नाही. ");
INSERT INTO mar_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","मग परमेश्वराने मोशेला सांगितले, “तू आपला हात आकाशात उंच कर म्हणजे अवघा मिसर देश अंधारात गडप होईल तो अंधार इतका दाट असेल की तुम्हास चाचपडत जावे लागेल.” ");
INSERT INTO mar_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","तेव्हा मोशेने आपला हात आकाशाकडे उभारिला आणि तीन दिवस सर्व मिसर देशात निबिड अंधकार झाला. ");
INSERT INTO mar_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","कोणालाही काहीही दिसेना आणि म्हणून कोणीही उठून तीन दिवस आपले घर सोडून गेले नाही; परंतु जिथे इस्राएली लोकांची वस्ती होती तेथे प्रकाश होता. ");
INSERT INTO mar_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","तेव्हा फारोने मोशेला बोलावले. तो म्हणाला, “तुम्ही जा व तुमच्या परमेश्वराची उपासना करा. तुम्ही तुमची मुलेबाळेही बरोबर न्या. परंतु तुमचे कळप व गुरेढोरे येथेच राहिली पाहिजेत.” ");
INSERT INTO mar_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मोशे म्हणाला, “आमचा देव परमेश्वर याच्यासाठी यज्ञ करण्यास यज्ञपशू व होमबली तू आमच्या हाती दिले पाहिजेत. ");
INSERT INTO mar_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","यज्ञ व होमार्पणासाठी आम्ही आमची गुरेढोरेही आमच्याबरोबर नेऊ. एक खूरही आम्ही मागे ठेवणार नाही. आमचा देव परमेश्वर याला यज्ञ व होमार्पण करण्यासाठी यातूनच घ्यावे लागेल आणि परमेश्वराची सेवा करण्यास आम्हांला काय लागेल ते आम्ही तेथे पोहचेपर्यंत सांगता येणार नाही;” ");
INSERT INTO mar_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","परमेश्वराने फारोचे मन पुन्हा कठीण केले. तेव्हा फारो इस्राएली लोकांस जाऊ देईना. ");
INSERT INTO mar_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","मग फारो मोशेवर ओरडला व म्हणाला, “तू येथून चालता हो! आपले तोंड मला पुन्हा दाखवू नकोस! यानंतर तू आपले तोंड मला दाखवशील त्या दिवशी तू मरशील!” ");
INSERT INTO mar_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मोशे म्हणाला, “तू बरोबर बोललास, मी तुझे तोंड पुन्हा कधीही पाहणार नाही!” ");
INSERT INTO mar_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","मग परमेश्वराने मोशेला सांगितले, “मी फारोवर व मिसरावर आणखी एक पीडा आणीन. त्यानंतर फारो तुम्हास येथून जाऊ देईल; तो तुम्हास जाऊ देईल तेव्हा तो तुम्हास सर्वस्वी ढकलून काढून लावील, ");
INSERT INTO mar_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","तू लोकांच्या कानांत सांगून ठेव की, प्रत्येक पुरुषाने आपल्या शेजाऱ्यापासून व प्रत्येक स्त्रीने आपल्या शेजारणीपासून सोन्याचांदीचे दागिने मागून घ्यावे.” ");
INSERT INTO mar_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","मिसरी लोकांची इस्राएली लोकांवर कृपादृष्टी होईल असे परमेश्वराने केले. मिसराचे सर्व लोक आणि फारोचे सेवक यांच्या दृष्टीने मोशे फार महान पुरुष होता. ");
INSERT INTO mar_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मोशे लोकांस म्हणाला, “परमेश्वर म्हणतो, मध्यरात्री मी मिसरातून फिरेन ");
INSERT INTO mar_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","आणि तेव्हा मिसराच्या सिंहासनावर विराजमान असलेल्या फारोपासून तो जात्यावर बसणाऱ्या दासीपर्यंत सर्वांचे ज्येष्ठ पुत्र व गुरांचे प्रथम वत्सदेखील मरतील. ");
INSERT INTO mar_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","मिसर देशात पूर्वी कधीही झाला नव्हता आणि भविष्यात कधीही होणार नाही असा मोठा आकांत होईल. ");
INSERT INTO mar_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","परंतु इस्राएल लोकांवर किंवा त्यांच्या जनावरांवर कुत्रा देखील भुंकणार नाही यावरुन मी परमेश्वर इस्राएली व मिसरांच्यामध्ये कसा भेद ठेवतो हे तुम्हास कळून येईल. ");
INSERT INTO mar_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","मग हे सर्व तुमचे दास म्हणजे मिसरी लोक माझ्या पाया पडून माझी उपासना करतील. ते म्हणतील, तुम्ही तुमच्या सर्व लोकांसह व परिवारासह येथून निघून जा.” मग त्यानंतर रागाने संतप्त होऊन मोशे फारोला सोडून निघून गेला. ");
INSERT INTO mar_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","परमेश्वराने मोशेला म्हटले, “फारो तुमचे ऐकणार नाही मी मिसर देशात पुष्कळ आश्चर्यकारक गोष्टी कराव्यात म्हणून असे होईल.” ");
INSERT INTO mar_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","आणि मोशे व अहरोन यांनी सर्व आश्चर्ये फारोपुढे केली; परंतु परमेश्वराने फारोचे मन कठीण केले आणि त्याने त्याच्या देशातून इस्राएल लोकांस बाहेर जाऊ दिले नाही. ");
INSERT INTO mar_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","मग मोशे व अहरोन मिसर देशामध्ये असताना परमेश्वर त्यांच्याशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“हा महिना तुमच्यासाठी आरंभीचा महिना व्हावा. तुमचा हा वर्षाचा पहिला महिना व्हावा. ");
INSERT INTO mar_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इस्राएलाच्या सर्व मंडळीला सांग की या महिन्याच्या दहाव्या दिवशी प्रत्येक मनुष्याने आपल्या कुटुंबातील लोकांकरता एक कोकरू घ्यावे. ");
INSERT INTO mar_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","आणि एक कोकरू, खाण्यासाठी घरातील माणसे थोडी असली तर त्याने आपल्या शेजाऱ्याच्या संख्येप्रमाणे कोकरू घ्यावे. प्रत्येकाच्या आहाराच्या मानाने एक कोकरू किती मनुष्यांना पुरेल याचा अंदाज घ्यावा. ");
INSERT INTO mar_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","तो कोकरा एक वर्षाचा नर असावा व तो पूर्णपणे निर्दोष असावा, तो कोकरा मेंढरातला किंवा बोकडातला असावा. तुम्हास वाटेल तो घ्यावा. ");
INSERT INTO mar_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","या पहिल्या महिन्याच्या चौदाव्या दिवसापर्यंत तो राखून ठेवावा. संध्याकाळी इस्राएली मंडळीतील लोकांनी त्यास वधावे. ");
INSERT INTO mar_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","त्या कोकऱ्याचे रक्त घेऊन ते ज्या घरात त्याचे मांस खाणार आहेत त्याच्या दोन्ही दारबाह्यांना व चौकटीच्या कपाळपट्टीवर लावावे. ");
INSERT INTO mar_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","त्याच रात्री त्याचे मांस विस्तवावर भाजून कडू भाजी व बेखमीर भाकरीबरोबर खावे. ");
INSERT INTO mar_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","तुम्ही त्याचे मांस कच्चेच किंवा पाण्यात शिजवून खाऊ नये तर विस्तवावर भाजून खावे; त्याची मुंडी, पाय व आतडी हीसुद्धा खावीत. ");
INSERT INTO mar_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","त्यातले काहीही सकाळपर्यंत ठेवू नये आणि सकाळपर्यंत काही उरलेच तर ते आगीत जाळून टाकावे. ");
INSERT INTO mar_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ते तुम्ही या प्रकारे खावे: तुमच्या कमरा कसून, पायांत जोडे घालून आणि हातात काठी घेऊन, ते घाईघाईने खावे; हा परमेश्वराचा वल्हांडण सण आहे. ");
INSERT INTO mar_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","आज रात्री मी मिसर देशात फिरेन आणि त्यातील मनुष्य व पशू या सर्वांचे प्रथम जन्मलेले मी मारून टाकीन, आणि मिसर देशातील सर्व दैवतांना शिक्षा करीन. मी परमेश्वर आहे. ");
INSERT INTO mar_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","परंतु तुमच्या घरांच्या दारावरील रक्त ही एक खूण असेल. मी जेव्हा रक्त पाहीन तेव्हा तुम्हास ओलांडून मी पुढे जाईन. मी मिसर देशाला मारीन तेव्हा कोणताही अनर्थ तुम्हावर येणार नाही व तुमचा नाश होणार नाही ");
INSERT INTO mar_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","हा दिवस तुम्हास आठवणीदाखल होईल, हा दिवस परमेश्वरासाठी तुम्ही विशेष उत्सवाचा सण म्हणून पाळावा. तुमच्या वंशजांनी येथून पुढे हा सण पिढ्यानपिढ्या कायमचा विधी समजून पाळावा. ");
INSERT INTO mar_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","सात दिवस बेखमीर भाकर खावी; पहिल्या दिवशी तुम्ही प्रत्येकाने आपल्या घरातील सर्व खमीर काढून टाकावे. तुम्हातील जर कोणी खमीर घातलेली भाकर खाईल तर त्यास तुम्ही इस्राएल लोकांमधून बाहेर टाकावे. ");
INSERT INTO mar_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","या सणाच्या पहिल्या व शेवटल्या म्हणजे सातव्या दिवशी पवित्र मेळा भरवावा; या दोन्ही दिवशी काही काम करू नये. फक्त खाण्यापिण्याच्या कामाशिवाय इतर कोणतेही काम करु नये. ");
INSERT INTO mar_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","या प्रकारे बेखमीर भाकरीच्या सण पाळावा. कारण याच दिवशी मी तुम्हा सर्वांना मिसर देशातून बाहेर काढून आणले. म्हणून हा दिवस पिढ्यानपिढ्या कायमचा विधी म्हणून पाळावा. ");
INSERT INTO mar_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","तेव्हा पहिल्या महिन्यातील चौदाव्या दिवसाच्या संध्याकाळपासून ते त्या महिन्याच्या एकविसाव्या दिवसाच्या संध्याकाळपर्यंत तुम्ही बेखमीर भाकरी खाव्या. ");
INSERT INTO mar_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","या सात दिवसात तुमच्या घरात खमीर नसावे; कारण जो कोणी एखादी खमिराची वस्तू खाईल मग तो परदेशी असो, किंवा स्वदेशी असो त्यास इस्राएलाच्या मंडळीतून बाहेर टाकावे. ");
INSERT INTO mar_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","त्या दिवशी कोणीही खमीर खाऊ नये; तुम्ही घरोघरी बेखमीर भाकरच खावी.” ");
INSERT INTO mar_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","मग मोशेने इस्राएली लोकांच्या सर्व वडीलधाऱ्या लोकांस एकत्र बोलावले. तो त्यांना म्हणाला, “तुम्ही आपापल्या घराण्याप्रमाणे एकएक कोकरू घ्यावे; आणि वल्हांडण सणाच्या यज्ञाकरिता त्याचा वध करावा. ");
INSERT INTO mar_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","मग एजोब झाडाची जुडी घेऊन त्या पात्रातील कोकराच्या रक्तात बुचकाळावी आणि त्याचे रक्त दाराच्या दोन्ही बाजूंच्या चौकटींना व कपाळपट्टीवर लावावे, आणि सकाळपर्यंत कोणीही घराबाहेर जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","कारण त्या वेळी परमेश्वर मिसरामधील प्रथम जन्मलेल्यांना ठार मारण्यासाठी फिरणार आहे; तो जेव्हा घराच्या दारावरील कपाळपट्टीवर व दाराच्या चौकटीच्या दोन्ही बाजूला लावलेले रक्त पाहील तेव्हा तो ते दार ओलांडून जाईल; नाश करणाऱ्याला तुमच्या घरात जाऊ देणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","हा विधी तुम्हास व तुमच्या पुत्रपौत्राला निरंतरचा आहे असे समजून तो पाळावा. ");
INSERT INTO mar_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","परमेश्वर त्याच्या वचनानुसार जो देश तुम्हास देणार आहे त्यामध्ये तुम्ही जाल तेव्हा तुम्ही हा उपासनेचा प्रकार म्हणून पाळावा. ");
INSERT INTO mar_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","जेव्हा तुमची मुलेबाळे तुम्हास विचारतील की या उपासनेचा अर्थ काय आहे? ");
INSERT INTO mar_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तेव्हा तुम्ही त्यांना सांगा, हा परमेश्वराच्या वल्हांडणाचा यज्ञ आहे; कारण आम्ही जेव्हा मिसरमध्ये होतो तेव्हा त्या दिवशी परमेश्वराने मिसराच्या लोकांस मारले व आपल्या घरांना वाचवले त्या वेळी तो मिसरातील इस्राएलांची घरे ओलांडून गेला, हे ऐकून लोकांनी नतमस्तक होऊन दंडवत घातले. ");
INSERT INTO mar_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","परमेश्वराने मोशे व अहरोन यांना आज्ञा दिली होती म्हणून इस्राएल लोकांनी त्यांच्या सांगण्याप्रमाणे केले. ");
INSERT INTO mar_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","मध्यरात्री असे झाले की मिसर देशातील सिंहासनारूढ असलेल्या फारोच्या ज्येष्ठ पुत्रापासून तर तुरुंगात पडलेल्या कैद्याच्या ज्येष्ठ पुत्रापर्यंत सर्व आणि तसेच गुराढोरांपैकी सर्व प्रथम वत्स परमेश्वराने मारून टाकले. ");
INSERT INTO mar_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","रात्रीच्या वेळी फारो, त्याचे सर्व सेवक आणि सगळे मिसराचे लोक जागे झाले आणि मिसर देशात मोठा हाहा:कार उडाला, कारण ज्यात कोणी मरण पावले नाही असे एकही घर राहिले नाही. ");
INSERT INTO mar_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","तेव्हा रातोरात फारोने मोशे व अहरोन यांना बोलावून आणले फारो त्यांना म्हणाला, तुम्ही व तुमचे सर्व इस्राएल लोक माझ्या लोकांतून निघून जा आणि तुम्ही म्हणता त्याप्रमाणे जाऊन तुमच्या परमेश्वराची उपासना करा. ");
INSERT INTO mar_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","आणि तुम्ही म्हणता त्याप्रमाणे तुमचे कळप, व गुरेढोरे ही तुमच्याबरोबर घेऊन चालते व्हा, आणि जाताना मलाही आशीर्वाद द्या. ");
INSERT INTO mar_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","लोकांनी देशातून तात्काळ निघून जावे म्हणून मिसरी लोकांनी त्यांच्यामागे तगादा लावला; कारण ते म्हणाले, आम्ही सर्वजण मेलोच आहोत.” ");
INSERT INTO mar_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","इस्राएल लोकांनी आपली मळलेली कणीक खमीर न घालता तशीच काथवटीसहीत कापडात गुंडाळून आपल्या खांद्यावर घेतली. ");
INSERT INTO mar_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इस्राएली लोकांनी मोशेने त्यांना सांगितल्याप्रमाणे आपल्या मिसऱ्याजवळ जाऊन कपडे, सोन्यारुप्याचे दागदागिने मागून घेतले. ");
INSERT INTO mar_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","मिसरी लोकांची कृपादृष्टी इस्राएल लोकांवर होईल असे परमेश्वराने केले आणि म्हणून त्यांनी जे जे मागितले ते ते त्यांनी त्यांना दिले. अशा प्रकारे त्यांनी मिसरी इस्राएल लोकांस लुटले. ");
INSERT INTO mar_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","तेव्हा इस्राएल लोक मिसर देशामधून निघून रामसेस शहरापासून प्रवास करीत सुक्कोथ नगरास गेले. मुलेबाळे सोडून ते सर्वजण मिळून सुमारे सहा लाख होते. ");
INSERT INTO mar_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","त्यांच्या सोबत लोकांचा मिश्र समुदाय गेला. तसेच पुष्कळ कळप, गुरेढोरे, जनावरे होती. ");
INSERT INTO mar_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","त्यांनी आपल्याबरोबर मिसर देशातून मळलेली कणीक आणली होती. त्यांना बेखमीर भाकरीच भाजाव्या लागल्या. त्यांना जबरीने बाहेर काढण्यात आले होते. त्यांना थांबण्यास वेळ नव्हता. तसेच खावयास काही विशेष जेवण करता आले नाही; ");
INSERT INTO mar_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्राएली लोक मिसर देशामध्ये येऊन चारशे तीस वर्षे राहिले होते. ");
INSERT INTO mar_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","मग चारशे तीस वर्षांच्या अखेरीस बरोबर त्याच दिवशी परमेश्वराच्या सर्व सेना मिसर देशातून बाहेर निघाल्या. ");
INSERT INTO mar_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","परमेश्वराने त्यांना मिसर देशातून बाहेर काढिले याकरिता ही परमेश्वरासाठी जागरणाची रात्र म्हणून अवश्य पाळावी. इस्राएल लोकांनी पिढ्यानपिढ्या ही रात्र परमेश्वरासाठी जागरणाची म्हणून अवश्य पाळावी. ");
INSERT INTO mar_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","परमेश्वराने मोशे व अहरोन यांना सांगितले, “वल्हांडण सण पाळण्याविषयीचे नियम असे आहेत. कोणाही परदेशी मनुष्याने वल्हांडणाचे भोजन खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","परंतु जर कोणी एखादा गुलाम विकत घेतला असेल आणि त्याची सुंता त्याने करवून घेतली असेल तर मग त्याने त्यातले खावे; ");
INSERT INTO mar_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","परंतु उपरा मनुष्य किंवा मोलकरी ह्यांपैकी कोणीही ते खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","प्रत्येक इस्राएली कुटुंबाने आपले वल्हांडण सणाचे भोजन एकाच घरात खाल्ले पाहिजे; ते भोजन घराबाहेर नेऊ नये. यज्ञपशूचे कोणतेही हाड मोडू नये. ");
INSERT INTO mar_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","सर्व इस्राएल मंडळीने हा सण पाळलाच पाहिजे. ");
INSERT INTO mar_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","परदेशीय एकजण तुम्हाबरोबर राहत असेल व जर त्यास परमेश्वराच्या वल्हांडण सणाच्या भोजनात सहभागी होण्याची इच्छा असेल तर त्याने सुंता करून घेतलीच पाहिजे. म्हणजे मग तो इस्राएल लोकांसारखा रहिवासी होईल. मग त्याने वल्हांडण सणाच्या भोजनात सहभागी व्हावे; परंतु त्याने सुंता करून घेतली नाहीतर त्यास त्यातले काही खाता येणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","हे नियम सर्वांसाठी सारखेच आहेत, मग तो इस्राएली असो किंवा तुमच्या देशात राहणारा इस्राएली नसलेला कोणी परदेशी असो. प्रत्येकासाठी सारखेच नियम आहेत.” ");
INSERT INTO mar_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","तेव्हा परमेश्वराने मोशे व अहरोन यांना ज्या आज्ञा दिल्या त्या सर्व इस्राएली लोकांनी पाळल्या. ");
INSERT INTO mar_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","अशा रीतीने त्याच दिवशी परमेश्वराने सर्व इस्राएली लोकांच्या सशस्त्र टोळ्या करून त्यांना टोळीटोळीने मिसर देशातून बाहेर काढून आणले. ");
INSERT INTO mar_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","मग परमेश्वर मोशेशी बोलला व म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“इस्राएली लोकांमध्ये मनुष्याचा व पशूचा या दोहोंचे प्रत्येक प्रथम जन्मलेले सर्व नर माझ्यासाठी पवित्र कर. प्रथम जन्मलेले ते माझे आहेत.” ");
INSERT INTO mar_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","मोशे लोकांस म्हणाला, “आजच्या दिवसाची आठवण ठेवा. तुम्ही मिसर देशात गुलाम म्हणून होता; परंतु या दिवशी परमेश्वराने आपल्या हाताच्या बळाने तुम्हास गुलामगिरीतून सोडवून बाहेर आणले म्हणून तुम्ही खमीर घातलेली भाकर खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आज अबीब महिन्यात तुम्ही मिसर सोडून निघत आहात. ");
INSERT INTO mar_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","परमेश्वराने तुमच्या पूर्वजांशी शपथपूर्वक करार केला होता की कनानी, हित्ती, अमोरी, हिव्वी व यबूसी ह्याच्या देशात, जेथे दुधामधाचे प्रवाह वाहतात त्या देशात आणल्यानंतर तुम्ही या महिन्यात ही सेवा करावी. ");
INSERT INTO mar_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","या सात दिवसात तुम्ही बेखमीर भाकर खावी. सातव्या दिवशी परमेश्वरासाठी तुम्ही हा सण पाळावा; ");
INSERT INTO mar_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","या सात दिवसात तुम्ही बेखमीर भाकर खावी. तुमच्या देशाच्या हद्दीत कोठेही खमिराचे दर्शनसुध्दा होऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","या दिवशी परमेश्वराने आम्हांला मिसर देशातून बाहेर आणले म्हणून आम्ही हा सण पाळीत आहोत असे तुम्ही आपल्या पुत्रपौत्रांना सांगावे. ");
INSERT INTO mar_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","हे चिन्ह तुझ्या हातावर, तुझ्या दोन्ही डोळ्यांच्या मध्ये स्मारक असे असावे, परमेश्वराचा नियम तुझ्या मुखी असावा. कारण की परमेश्वराने बलवान भुजाने तुला मिसर देशामधून बाहेर आणले. ");
INSERT INTO mar_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","म्हणून तू वर्षानुवर्षे नेमलेल्या वेळी हा विधी पाळावा. ");
INSERT INTO mar_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","परमेश्वराने तुमच्या पूर्वजांना वचन दिल्याप्रमाणे तो तुम्हास आता कनानी लोक राहत असलेल्या देशात घेऊन जाईल व तो देश तुझ्या हाती देईल. ");
INSERT INTO mar_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तेव्हा उदरातून निघालेला प्रथम पुरुष व जनावराच्या पोटचा प्रथम वत्स यांना परमेश्वरासाठी वेगळे करावे, सर्व नर परमेश्वराचे होत. ");
INSERT INTO mar_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","गाढवाचा प्रथम वत्स एक कोकरू देऊन सोडवून घ्यावा; त्याचा मोबदला काही न दिल्यास त्याची मान मुरगाळावी. तुझ्या मुलातील प्रथम नर मोबदला देऊन सोडवून घ्यावा. ");
INSERT INTO mar_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","पुढील काळी तुमची मुलेबाळे विचारतील की हे काय? तेव्हा त्यांना सांग, ‘मिसर देशातून गुलामगिरीतून परमेश्वराने आम्हांला आपल्या हाताच्या बलाने बाहेर काढले. ");
INSERT INTO mar_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","आणि फारो आम्हांस मिसर सोडून जाऊ देईना, तेव्हा परमेश्वराने मिसर देशामधील मनुष्य व पशू यांचे सर्व प्रथम नर मारून टाकले; आणि म्हणूनच आम्ही उदरातून निघालेल्या सर्व प्रथम नरांचा मी परमेश्वरास बली अर्पितो. पण माझे सर्व ज्येष्ठ पुत्र देऊन सोडवून घेतो. ");
INSERT INTO mar_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","तुझ्या हातावर आणि तुझ्या दोहो डोळ्यांच्या मध्यभागी हे स्मारक चिन्ह व्हावे. कारण परमेश्वराने आपल्या हाताच्या बलाने आम्हांला मिसर देशातून बाहेर आणले.” ");
INSERT INTO mar_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","फारोने लोकांस जाऊ दिले, परंतु परमेश्वराने लोकांस पलिष्टी लोकांच्या देशातून जवळची वाट असताना देखील त्यातून जाऊ दिले नाही “युध्द प्रसंग पाहून हे लोक माघार घेऊन मिसर देशाला परत जातील, असे देवाला वाटले.” ");
INSERT INTO mar_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","म्हणून देवाने त्यांना दुसऱ्या मार्गाने तांबड्या समुद्राजवळील रानातून नेले. इस्राएल लोक मिसरामधून सशस्त्र बाहेर निघाले होते. ");
INSERT INTO mar_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मोशेने योसेफाच्या अस्थी आपल्याबरोबर घेतल्या. कारण मरण्यापूर्वी योसेफाने आपणाकरता इस्राएली पुत्रांकडून वचन घेतले होते. तो म्हणाला होता, “देव जेव्हा तुम्हास मिसरमधून सोडवील तेव्हा माझ्या अस्थी मिसरमधून घेऊन जाण्याची आठवण ठेवा.” ");
INSERT INTO mar_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","मग ते सुक्कोथ नगराहून रवाना झाले व रानाजवळील एथामात त्यांनी तळ दिला. ");
INSERT INTO mar_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","त्यांनी रात्रंदिवस चालावे म्हणून परमेश्वर दिवसा त्यांना मार्ग दाखविण्यासाठी मेघस्तंभाच्या ठायी आणि रात्री त्यांना प्रकाश देण्यासाठी अग्नीस्तंभाच्या ठायी त्यांच्यापुढे चालत असे. ");
INSERT INTO mar_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","दिवसा मेघस्तंभ व रात्री अग्नीस्तंभ लोकांपुढून कधी दूर होत नसत. ");
INSERT INTO mar_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएल लोकांस असे सांग की, तुम्ही मागे फिरून मिग्दोल व समुद्र यांच्यामध्ये व बआल-सफोन जवळ असलेल्या पीहहीरोथ येथे तळ देऊन रात्री मुक्काम करावा. ");
INSERT INTO mar_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","इस्राएली लोकांविषयी फारो म्हणेल, ते रानात भटकत आहेत. रानात त्यांचा कोंडमारा झाला आहे. ");
INSERT INTO mar_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","मी फारोचे मन कठीण करीन व तो त्यांचा पाठलाग करीन. मी फारो व त्याची सेना यांचा पराभव करून गौरवशाली होईन, मग मिसराच्या लोकांस समजेल की मी परमेश्वर आहे.” त्याप्रमाणे इस्राएल लोकांनी केले. ");
INSERT INTO mar_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","इस्राएल लोक निसटून गेल्याचे मिसराच्या राजाला समजले तेव्हा तो व त्याचे अधिकारी यांचे विचार बदलले व आपण हे काय केले असे त्यांना वाटले. फारो म्हणाला, “आपण इस्राएली लोकांस आपल्या दास्यातून पळून का जाऊ दिले?” ");
INSERT INTO mar_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","तेव्हा फारोने आपला रथ तयार करण्यास सांगितले आणि आपल्या लोकांस घेऊन तो निघाला. ");
INSERT INTO mar_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","त्याने सहाशे उत्तम योद्धे व मिसरातील सर्व रथ त्यांवरील सरदारांसोबत आपल्याबरोबर घेतले. ");
INSERT INTO mar_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","इस्राएल लोक तर मिसरहून मोठ्या अवसानाने चालले होते, परंतु परमेश्वराने फारो राजाचे मन कठीण केले. ");
INSERT INTO mar_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","फारोच्या लष्करात पुष्कळ घोडेस्वार व रथ होते. मिसरी सैन्याने त्यांचा पाठलाग केला व इस्त्राएल लोकांनी लाल समुद्र व बआल-सफोनाच्या दरम्यान पीहहीरोथ येथे तळ दिला होता तेथे त्यांना गाठले. ");
INSERT INTO mar_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","फारो व मिसरी सैन्य आपणाकडे येताना इस्राएल लोकांनी पाहिले, तेव्हा ते अतिशय घाबरले; आणि मदतीसाठी ते परमेश्वराचा धावा करू लागले. ");
INSERT INTO mar_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ते मोशेला म्हणाले, “आम्हांला मिसरात काय कबरा नव्हत्या म्हणून येथे रानात मरावयास आणले? आम्हांला तू मिसरातून बाहेर का काढले? ");
INSERT INTO mar_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","मिसरमध्ये आम्ही तुला नव्हतो का म्हणत की आम्ही आहो ते ठीक आहो, आम्ही मिसरामध्ये गुलाम म्हणून राहिलो असतो तर बरे झाले असते. येथे रानात मरून जावे त्यापेक्षा मिसऱ्यांचे दास्य पत्करले.” ");
INSERT INTO mar_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","परंतु मोशेने उत्तर दिले, “भिऊ नका! स्थिर उभे राहा आणि परमेश्वर आज तुमचे तारण करील ते पाहा. आजच्या दिवसानंतर हे मिसराचे लोक तुम्हास पुन्हा कधीही दिसणार नाहीत. ");
INSERT INTO mar_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","परमेश्वर तुमच्याकरता त्यांच्याशी लढेल, तुम्ही शांत उभे राहा.” ");
INSERT INTO mar_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","मग परमेश्वर मोशेला म्हणाला, “माझा धावा करीत काय बसलास? इस्राएल लोकांस सांग की पुढे चला. ");
INSERT INTO mar_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","तू आपली काठी उचल आणि आपला हात समुद्रावर उगारून तो दुभाग म्हणजे इस्राएल लोक भर समुद्रात कोरड्या भूमीवरून चालतील. ");
INSERT INTO mar_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","आणि पाहा, मी स्वतः मिसऱ्यांची मने कठीण करीन आणि ते तुमचा पाठलाग करतील. आणि फारो व त्याचे सर्व सैन्य, स्वार व रथ यांचा पराभव केल्याने माझा महिमा प्रगट होईल. ");
INSERT INTO mar_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","फारो व त्याचे रथ व त्यांचे स्वार यांचा पराभव केल्याने माझा महिमा प्रगट झाला म्हणजे मी परमेश्वर आहे हे मिसरी लोकांस कळेल.” ");
INSERT INTO mar_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","इस्राएली सेनेच्या पुढे चालणारा देवाचा दूत सेनेच्या मागे गेला, आणि मेघस्तंभ त्यांच्या आघाडीवरून निघून त्यांच्या पिछाडीस उभा राहिला. ");
INSERT INTO mar_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","अशा रीतीने तो मिसराचे लोक व इस्राएल लोक यांच्यामध्ये उभा राहिला; मेघ व अंधकार होता तरी तो रात्रीचा प्रकाश देत होता. रात्रभर एका पक्षाला दुसऱ्या पक्षाकडे जाता आले नाही. ");
INSERT INTO mar_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","मग मोशेने तांबड्या समुद्रावर आपला हात उगारला, तेव्हा परमेश्वराने रात्रभर पूर्वेकडून जोराचा वारा वाहवून समुद्र मागे हटविला, असा की पाणी दुभागून मध्ये कोरडी जमीन झाली. ");
INSERT INTO mar_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","आणि इस्राएल लोक कोरड्या वाटेवरून भर समुद्रातून पार गेले. समुद्राचे पाणी त्यांच्या उजव्या व डाव्या बाजूला भिंतीसारखे उभे राहिले. ");
INSERT INTO mar_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","त्यानंतर तेव्हा मिसऱ्यांनी त्यांचा पाठलाग केला. फारोचे सर्व घोडे, रथ व स्वार त्यांच्या पाठोपाठ समुद्रामध्ये गेले. ");
INSERT INTO mar_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","तेव्हा त्या दिवशी भल्या पहाटे परमेश्वराने मेघस्तंभातून व अग्निस्तंभातून खाली मिसराच्या सैन्याकडे पाहिले आणि त्यांचा गोंधळ उडवून त्यांचा पराभव केला. ");
INSERT INTO mar_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","रथाची चाके रुतल्यामुळे रथावर ताबा ठेवणे मिसराच्या लोकांस कठीण झाले; तेव्हा ते मोठ्याने ओरडून म्हणाले, “आपण येथून लवकर निघून जाऊ या! कारण परमेश्वर इस्राएलाच्या बाजूने आम्हाविरूद्ध लढत आहे.” ");
INSERT INTO mar_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","नंतर परमेश्वर मोशेला म्हणाला, “तुझा हात समुद्रावर उगार म्हणजे भिंतीसारखे उभे राहिलेले पाणी पूर्ववत जमून मिसऱ्यावर, त्यांच्या रथावर व स्वारांवर येईल.” ");
INSERT INTO mar_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मोशेने आपला हात समुद्रावर उगारला तेव्हा दिवस उजाडल्यावर पाणी पहिल्यासारखे समान पातळीवर आले; तेव्हा मिसराच्या लोकांनी पळून जाण्याचा प्रयत्न केला, परंतु परमेश्वराने त्यांना समुद्रामध्ये उलथून पाडिले. ");
INSERT INTO mar_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","पाणी पूर्ववत झाले व त्याने घोडे, रथ व स्वारांना गडप केले आणि इस्राएल लोकांचा पाठलाग करणाऱ्या फारोच्या सर्व सैन्याचा नाश झाला, त्यांच्यातले कोणीही वाचले नाही. ");
INSERT INTO mar_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","परंतु इस्राएली लोक कोरड्या भूमीवरून भरसमुद्र ओलांडून पार गेले. ते पाणी त्यांच्या उजव्या व डाव्या हाताला भिंतीप्रमाणे उभे राहिले. ");
INSERT INTO mar_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","तेव्हा अशा रीतीने त्या दिवशी परमेश्वराने मिसऱ्यांच्या हातातून इस्त्राएल लोकांस सोडविले आणि मिसरी समुद्रतीरी मरून पडलेले इस्राएल लोकांनी आपल्या डोळ्यांनी पाहिले. ");
INSERT INTO mar_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","परमेश्वराने मिसऱ्यांना आपला प्रबळ हात दाखविला तो इस्राएल लोकांनी पाहिला, तेव्हा त्यांनी परमेश्वराचे भय धरले आणि परमेश्वरावर व त्याचा सेवक मोशे याच्यावरही विश्वास ठेवला. ");
INSERT INTO mar_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","नंतर मोशे व इस्राएल लोक यांनी परमेश्वरास हे गीत गाईले. ते म्हणाले, “मी परमेश्वरास गीत गाईन कारण तो विजयाने प्रतापी झाला आहे; घोडा व स्वार यांना त्याने समुद्रात उलथून टाकले आहे. ");
INSERT INTO mar_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","परमेश्वर माझे सामर्थ्य व माझे गीत आहे. तो माझे तारण झाला आहे. मी त्याची स्तुतीस्तोत्रे गाईन; परमेश्वर माझा देव आहे; तो माझ्या पूर्वजांचा देव आहे; मी त्याचे गौरव करीन. ");
INSERT INTO mar_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","परमेश्वर महान योद्धा आहे; त्याचे नाव परमेश्वर आहे. ");
INSERT INTO mar_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","त्याने फारोचे रथ व स्वार यांना समुद्रात फेकून दिले; त्याचे निवडक अधिकारी तांबड्या समुद्रात बुडाले आहेत. ");
INSERT INTO mar_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","खोल पाण्याने त्यांना बुडविले; ते खोल पाण्यात दगडाप्रमाणे तळापर्यंत बुडाले. ");
INSERT INTO mar_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे परमेश्वरा, तुझा उजवा हात आश्चर्यकारकरीत्या बलशाली आहे; त्या हाताने तू शत्रूंचा चुराडा करून टाकलास. ");
INSERT INTO mar_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","तुझ्या वैभवशाली सामर्थ्याने तू तुझ्याविरूद्ध बंड करून उठणाऱ्यांचा नाश करतोस; अग्नीने वाळलेल्या गवताच्या काड्या जाळाव्या तसे तू त्यांना तुझ्या रागाने जाळून भस्म करतोस. ");
INSERT INTO mar_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तुझ्या नाकपुड्यांच्या फुंकराने जलाच्या राशी बनल्या. जलप्रवाह राशी सारखे उंच उभे राहिले, जलाशय सागराच्या उदरी थिजून गेले. ");
INSERT INTO mar_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","शत्रू म्हणाला, मी त्यांचा पाठलाग करीन, त्यांना गाठीन, मी त्यांची सर्व संपत्ती लुटून घेईन; त्यामुळे माझा जीव तृप्त होईल. मी तलवार उपसून आपल्या हाताने त्यांचा नाश करीन. ");
INSERT INTO mar_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","परंतु तू त्यांच्यावर आपला फुंकर वायू सोडलास आणि समुद्राच्या पाण्याने त्यांना गडप केले; ते शिशाप्रमाणे समुद्रात खोल पाण्यात तळापर्यंत बुडाले. ");
INSERT INTO mar_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे परमेश्वरा, देवांमध्ये तुजसमान कोण आहे? पवित्रतेने ऐश्वर्यवान, स्तवनात भयानक, अद्भुते करणारा असा तुजसमान कोण आहे? ");
INSERT INTO mar_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तू तुझा उजवा हात उगारला, पृथ्वीने त्यांना गिळून टाकले. ");
INSERT INTO mar_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","तू उध्दारलेल्या लोकांस तू तुझ्या दयाळूपणाने चालवले आहेस; तुझ्या सामर्थ्याने तू त्यांना तुझ्या पवित्र आणि आनंददायी प्रदेशात नेले आहे. ");
INSERT INTO mar_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","इतर राष्ट्रे ही गोष्ट ऐकून भयभीत होतील; पलिष्टामध्ये राहणारे लोक भीतीने थरथर कापतील. ");
INSERT INTO mar_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","मग अदोमाचे अधिकारी हैराण झाले. मवाबाचे नायक भीतीने थरथर कापत आहेत आणि कनानी लोक गलित झाले आहेत. ");
INSERT INTO mar_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","तुझे सामर्थ्य पाहून ते लोक घाबरतील, आणि परमेश्वराचे लोक म्हणजे तू तारलेले लोक निघून पार जाईपर्यंत ते तुझ्या लोकांस काहीही न करता, दगडासारखे एकाच जागी उभे राहतील; ");
INSERT INTO mar_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","तू तुझ्या लोकांस तुझ्या वतनाच्या पर्वतावर घेऊन जाशील; हे परमेश्वरा, तू आपल्यासाठी केलेले निवासस्थान हेच आहे. हे प्रभू, तुझ्या हातांनी स्थापिलेले तुझे पवित्र स्थान हेच. ");
INSERT INTO mar_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","परमेश्वर सदासर्वदा राज्य करील.” ");
INSERT INTO mar_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","फारोचे घोडे, स्वार व रथ समुद्रात गेले, या प्रकारे परमेश्वराने त्यांना समुद्राच्या पाण्यात गडप केले; परंतु इस्राएल लोक भरसमुद्रातून कोरड्या जमिनीवरून चालत पार गेले. ");
INSERT INTO mar_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","त्यानंतर अहरोनाची बहीण मिर्याम संदेष्टी हिने हाती डफ घेतला आणि ती व इतर स्त्रिया नाचू लागल्या. मिर्याम हे गीत पुन्हा पुन्हा गात होती; ");
INSERT INTO mar_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","मिर्यामने त्यांच्या गाण्याला ध्रुपद धरले. “परमेश्वरास गीत गा; कारण त्याने महान कृत्ये केली आहेत. त्याने घोडा व स्वार यांना समुद्रात फेकून दिले आहे.” ");
INSERT INTO mar_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","मोशे इस्राएल लोकांस तांबड्या समुद्रापासून पुढे घेऊन गेला. ते लोक शूरच्या रानात गेले; त्यांनी तीन दिवस रानातून प्रवास केला; पण त्यांना पाणी कोठे मिळाले नाही. ");
INSERT INTO mar_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","तीन दिवस प्रवास केल्यानांतर ते लोक मारा नावाच्या ठिकाणी पोहोचले; तेथे पाणी फार कडू असल्यामुळे लोकांस ते पिववेना, म्हणूनच त्या ठिकाणाचे नाव मारा पडले. ");
INSERT INTO mar_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","लोक मोशेकडे कुरकुर करीत म्हणाले, “आता आम्ही काय प्यावे?” ");
INSERT INTO mar_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","मोशेने परमेश्वराचा धावा केला तेव्हा परमेश्वराने त्यास एक वनस्पती दाखवली. ती त्याने पाण्यात टाकल्यावर तेव्हा ते पाणी गोड झाले. त्या वेळी परमेश्वराने इस्राएल लोकांस विधी व नियम लावून दिला; तसेच त्याने त्यांचा विश्वासाची कसोटी घेतली. ");
INSERT INTO mar_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","तू आपला देव परमेश्वर याचे वचन मनःपूर्वक ऐकशील आणि त्याच्या दृष्टीने जे योग्य ते करशील, त्याच्या आज्ञांकडे कान देशील आणि त्याचे सर्व विधी पाळशील तर मिसरी लोकांवर ज्या व्याधी मी पाठवल्या त्यापैकी एकही तुजवर पाठविणार नाही. कारण मी तुला व्याधी मुक्त करणारा परमेश्वर आहे. ");
INSERT INTO mar_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","मग ते एलीम येथे आले; तेथे पाण्याचे बारा झरे होते व सत्तर खजुरीची झाडे होती; तेव्हा लोकांनी तेथे पाण्याजवळ तळ दिला. ");
INSERT INTO mar_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","मग इस्राएली लोकांची मंडळी प्रवास करीत एलीम या ठिकाणाहून निघाली व मिसरमधून निघाल्यानंतर दुसऱ्या महिन्याच्या पंधराव्या दिवशी एलीम व सीनाय यांच्या दरम्यान असलेल्या सीन रानात येऊन पोहचले. ");
INSERT INTO mar_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","त्या रानात इस्राएल लोकांच्या मंडळीने मोशे व अहरोन यांच्यासंबंधी कुरकुर केली; ");
INSERT INTO mar_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","इस्राएल लोक त्यांना म्हणू लागले की, “परमेश्वराच्या हातून आम्हांला मिसर देशामध्येच मरण आले असते तर बरे झाले असते, कारण तेथे आम्हांला खावयास लागणारे सर्व प्रकारचे अन्न भरपूर होते; परंतु तुम्ही आम्हांला येथे रानात उपासाने मारावे म्हणून आणले आहे.” ");
INSERT INTO mar_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","मग परमेश्वर मोशेला म्हणाला, “तुम्हास खाण्याकरता मी आकाशातून अन्नवृष्टी करीन; प्रत्येक दिवशी या लोकांनी आपल्याला त्या दिवसास पुरेल एवढे अन्न बाहेर जाऊन गोळा करावे. यावरुन ते माझ्या नियमाप्रमाणे चालतात की नाही हे पाहण्यासाठी मी त्यांची परीक्षा पाहीन. ");
INSERT INTO mar_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","सहाव्या दिवशी मात्र ते इतर दिवशी गोळा करतात त्याच्या दुप्पट असावे. ते जे गोळा करतील ते ते शिजवतील.” ");
INSERT INTO mar_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","म्हणून मोशे व अहरोन सर्व इस्राएल लोकांस म्हणाले, “आज संध्याकाळी तुम्ही परमेश्वराचे सामर्थ्य पाहाल; तेव्हा मिसरमधून तुम्हास वाचविणारा परमेश्वर हाच आहे हे तुम्हास कळेल. ");
INSERT INTO mar_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","उद्या सकाळी तुम्ही परमेश्वराचे तेज पाहाल; तुम्ही परमेश्वराविरुध्द कुरकुर केली त्याने ती ऐकली आहे. आम्ही कोण की तुम्ही आम्हाविरुध्द कुरकुर करावी?” ");
INSERT INTO mar_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","आणि मोशे म्हणाला, “परमेश्वर तुम्हास संध्याकाळी मांस खावयास देईल; आणि सकाळी पोटभर भाकरी देईल; कारण तुम्ही परमेश्वराविरूद्ध कुरकुर करीत आहा ती त्याने ऐकली आहे. आम्ही कोण आहो? तुमचे कुरकुरणे आमच्याविरुध्द नाही तर परमेश्वराविरुध्द आहे.” ");
INSERT INTO mar_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","मग मोशे अहरोनाला म्हणाला, “तू इस्राएल लोकांच्या मंडळीला सांग की, तुम्ही परमेश्वराकडे एकत्र या; कारण त्याने तुमच्या तक्रारी ऐकल्या आहेत.” ");
INSERT INTO mar_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","मग अहरोन सर्व इस्राएल मंडळीशी बोलत असताना सर्व लोकांनी वळून रानाकडे पाहिले; आणि त्यांना मेघात परमेश्वराचे तेज दिसले. ");
INSERT INTO mar_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मी इस्राएल लोकांच्या तक्रारी ऐकल्या आहेत तेव्हा त्यांना सांग, रात्री तुम्ही मांस खाल आणि दररोज सकाळी तुम्हास पाहिजे तितक्या भाकरी खाल; मग परमेश्वर मी तुमचा देव आहे हे तुम्हास समजेल.” ");
INSERT INTO mar_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","त्या संध्याकाळच्या वेळी, तेथे लावे पक्षी येऊन छावणीभर पसरले आणि सकाळी छावणीच्या सभोवती जमिनीवर दव पडले. ");
INSERT INTO mar_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","सूर्य उगवल्यावर दव विरून गेले, परंतु त्यानंतर जमिनीवर खवल्यासारखे हिमकणाएवढे सूक्ष्म कण पसरलेले दिसले. ");
INSERT INTO mar_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ते पाहून इस्राएल लोकांनी एकमेकांना विचारले, “हे काय आहे?” कारण ते काय आहे हे त्यांना माहीत नव्हते. तेव्हा मोशेने त्यांना सांगितले, “परमेश्वर हे अन्न तुम्हास खाण्याकरता देत आहे. ");
INSERT INTO mar_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","परमेश्वराने आज्ञा केली आहे ती ही आहे की, प्रत्येकाने आपल्याला जेवढ्या अन्नाची गरज आहे तेवढेच गोळा करावे; ज्याच्या तंबूत जेवढी माणसे असतील तेवढ्यासाठी त्याच्या आहाराप्रमाणे प्रत्येकी एकएक ओमर गोळा करावे.” ");
INSERT INTO mar_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इस्राएल लोकांनी तसे केले, कोणी कमी, कोणी जास्त गोळा केले. ");
INSERT INTO mar_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","त्यांनी ओमरच्या मापाने ते मापून पाहिले; तेव्हा ज्याने अधिक गोळा केले होते त्याचे अधिक भरले नाही. तसेच ज्याने थोडे गोळा केले होते त्याचे काही कमी भरले नाही. प्रत्येकाने आपआपल्या आहाराच्या मानाने ते गोळा केले. ");
INSERT INTO mar_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मोशेने लोकांस सांगितले, “कोणीही यापैकी काहीएक सकाळपर्यंत ठेवू नये.” ");
INSERT INTO mar_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","परंतु लोकांनी मोशेचे ऐकले नाही, काही लोकांनी त्या अन्नातून सकाळपर्यंत ठेवले त्यामध्ये किडे पडले व त्याची घाण येऊ लागली. त्यावरून मोशे त्यांच्यावर फार रागावला. ");
INSERT INTO mar_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","प्रत्येक दिवशी ते लोक आपल्याला पुरेसे अन्न गोळा करीत, ऊन फार वाढल्यावर ते वितळून जाई. ");
INSERT INTO mar_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","सहाव्या दिवशी त्यांनी दुप्पट म्हणजे प्रत्येक माणशी दोन ओमर गोळा केले. तेव्हा मंडळीचे सर्व पुढारी लोक मोशेकडे आले व त्यांनी हे त्यास कळवले. ");
INSERT INTO mar_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","तो त्यांना म्हणाला, “परमेश्वराचे सांगणे असे आहे की, उद्या विश्रामवार, परमेश्वराचा पवित्र शब्बाथ आहे. तुम्हास भाजावयाचे ते भाजा आणि शिजवायचे ते शिजवा आणि जे काही उरेल ते आपल्यासाठी सकाळपर्यंत ठेवावे.” ");
INSERT INTO mar_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","मोशेने सांगितल्याप्रमाणे त्यांनी ते सकाळपर्यंत ठेवले. पण त्याची घाण सुटली नाही किंवा त्यामध्ये कोठेही किडे पडले नाहीत. ");
INSERT INTO mar_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","मग मोशे म्हणाला, “ते आज खा, कारण आज परमेश्वराचा शब्बाथ आहे, आज रानात ते तुम्हास मिळावयाचे नाही. ");
INSERT INTO mar_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","तुम्ही सहा दिवस ते गोळा करावे, परंतु आठवड्याचा सातवा दिवस हा शब्बाथ आहे. त्या दिवशी काही मिळणार नाही.” ");
INSERT INTO mar_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","तरी काही लोक सातव्या दिवशी ते गोळा करावयास बाहेर गेले, परंतु त्यांना काहीच मिळाले नाही. ");
INSERT INTO mar_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","नंतर परमेश्वर मोशेला म्हणाला, “माझ्या आज्ञा व माझे नियम पाळावयास तुम्ही कोठवर नाकारणार? ");
INSERT INTO mar_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","पाहा परमेश्वराने तुम्हास शब्बाथ दिला आहे; म्हणून सहाव्या दिवशी तो तुम्हास तो दोन दिवस पुरेल एवढे अन्न देतो, तेव्हा सातव्या दिवशी आपआपल्या ठिकाणी स्वस्थ असावे, आपले स्थान सोडून कोणीही बाहेर जाऊ नये.” ");
INSERT INTO mar_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","याप्रमाणे लोकांनी सातव्या दिवशी विसावा घेतला. ");
INSERT INTO mar_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएल लोकांनी त्या अन्नाचे नाव मान्ना ठेवले; ते धण्यासारखे पांढरे असून त्याची चव मध घालून केलेल्या पोळीसारखी होती. ");
INSERT INTO mar_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मोशे म्हणाला, “परमेश्वराने अशी आज्ञा दिली आहे की ह्यातले एक ओमर पुढील पिढ्यांच्या लोकांसाठी राखून ठेवा. मी तुम्हास मिसर देशातून काढून नेल्यावर रानात कसे अन्न दिले हे त्यांना समजेल.” ");
INSERT INTO mar_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","तेव्हा मोशेने अहरोनाला सांगितले, “एक भांडे घे आणि त्यामध्ये एक ओमर मान्ना घाल. तो परमेश्वरापुढे सादर करण्यासाठी आपल्या पुढील पिढ्यांसाठी राखून ठेव.” ");
INSERT INTO mar_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","मग परमेश्वराने मोशेला दिलेल्या आज्ञेप्रमाणे अहरोनाने परमेश्वराच्या आज्ञापटापुढे ते भांडे ठेवले. ");
INSERT INTO mar_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएल लोक तो मान्ना चाळीस वर्षे, कनान देशाच्या सरहद्दीपर्यंत जाऊन पोहोचेपर्यंत खात होते. ");
INSERT INTO mar_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","एक ओमर मान्ना म्हणजे “एक एफाचा दहावा भाग” आहे. ");
INSERT INTO mar_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","सर्व इस्राएल लोकांचा समुदाय सीनच्या रानातून एकत्र प्रवास करत गेला, परमेश्वराने त्यांना आज्ञा केल्याप्रमाणे ते ठिकठिकाणाहून प्रवास करत रफीदिम येथे गेले आणि त्यांनी तेथे तळ दिला; तेथे त्यांना प्यावयास पाणी मिळेना. ");
INSERT INTO mar_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","तेव्हा इस्राएल लोक मोशेविरूद्ध उठले व त्याच्याशी भांडू लागले. ते म्हणाले, “आम्हांला प्यावयास पाणी दे.” मोशे त्यांना म्हणाला, “तुम्ही मजशी का भांडता? तुम्ही परमेश्वराची परीक्षा का पाहत आहात?” ");
INSERT INTO mar_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","परंतु लोक तहानेने कासावीस झाले होते म्हणून ते मोशेकडे कुरकुर करीतच राहिले; ते म्हणाले, “तू आम्हांला मिसर देशातून बाहेर का आणलेस? आमची मुले, गुरेढोरे यांना पाण्यावाचून मारण्यासाठी तेथून आम्हांला तू येथे आणलेस काय?” ");
INSERT INTO mar_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","तेव्हा मोशे परमेश्वराकडे धावा करून म्हणाला, “मी या लोकांस काय करू? ते तर मला दगडमार करावयास उठले आहेत.” ");
INSERT INTO mar_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","परमेश्वर मोशेला म्हणाला, “तू इस्राएल लोकांपुढे जा. त्यांच्यापैकी काही वडील माणसे तुजबरोबर घे. नील नदीच्या पाण्यावर तू जी काठी आपटली होतीस ती हाती घेऊन लोकांच्या पुढे चाल. ");
INSERT INTO mar_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","पाहा, होरेब डोंगरावरील एका खडकावर मी तुझ्यापुढे उभा राहीन, त्या खडकावर ती काठी आपट, त्यातून पाणी निघेल. म्हणजे ते हे लोक पितील,” मोशेने हे सर्व इस्राएलांच्या वडिलासमोर केले. ");
INSERT INTO mar_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","मोशेने त्या ठिकाणाचे नाव मस्सा व मरीबा ठेवले; कारण या ठिकाणी इस्राएल लोकांनी तेथे कलह केला आणि “परमेश्वर आमच्यामध्ये आहे किंवा नाही” असे म्हणून परमेश्वराची परीक्षा पाहिली. ");
INSERT INTO mar_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","रफीदिम येथे अमालेकी लोक इस्राएल लोकांवर चालून आले आणि त्यांनी त्यांच्याशी लढाई केली. ");
INSERT INTO mar_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","तेव्हा मोशे यहोशवाला म्हणाला, “काही लोकांस निवड व त्यांना घेऊन उद्या अमालेकांशी लढाई कर; देवाने मला दिलेली काठी हातात घेऊन मी डोंगराच्या माथ्यावर उभा राहीन.” ");
INSERT INTO mar_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","यहोशवाने मोशेची आज्ञा मानली व त्याप्रमाणे दुसऱ्या दिवशी तो अमालेकी लोकांविरूद्ध लढावयास गेला, त्या वेळी मोशे, अहरोन व हूर हे डोंगराच्या माथ्यावर गेले. ");
INSERT INTO mar_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","जेव्हा मोशे हात वर करी तेव्हा लढाईत इस्राएलाची सरशी होई; परंतु जेव्हा तो हात खाली करी तेव्हा अमालेकी लोकांची सरशी होई. ");
INSERT INTO mar_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","काही वेळाने मोशेचे हात थकून गेले. तेव्हा त्यांनी एक धोंडा घेऊन मोशाच्या खाली ठेवला व तो त्यावर बसला आणि नंतर एका बाजूने अहरोन व दुसऱ्या बाजूने हूर यांनी आधार देऊन मोशेचे हात सूर्य मावळेपर्यंत तसेच वर स्थिर धरून ठेवले. ");
INSERT INTO mar_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","तेव्हा यहोशवाने या लढाईत तलवारीच्या धारेने अमालेकी लोकांचा पराभव केला. ");
INSERT INTO mar_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","नंतर परमेश्वर मोशेला म्हणाला, “लढाई विषयीच्या या सर्व गोष्टी एका ग्रंथात लिहून ठेव आणि यहोशवाला सांग. कारण मी अमालेकी लोकांस पृथ्वीतलावरून नक्की पूर्णपणे नष्ट करीन.” ");
INSERT INTO mar_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","मग मोशेने तेथे एक वेदी बांधून तिला “परमेश्वर माझा झेंडा” असे नाव दिले. ");
INSERT INTO mar_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","आणि तो म्हणाला, “परमेश्वराच्या सिंहासनावर अमालेकी लोकांनी हात उचलल्यामुळे परमेश्वराचे अमालेकांशी पिढ्यानपिढ्या युध्द होईल.” ");
INSERT INTO mar_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","देवाने मोशे व इस्राएल लोक यांच्यासाठी जे केले तसेच त्यांना परमेश्वराने मिसर देशातून सोडवून बाहेर आणले यासंबंधी मोशेचा सासरा मिद्यांनी याजक इथ्रो याने ऐकले; ");
INSERT INTO mar_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","मोशेने आपली पत्नी सिप्पोरा पूर्वी परत पाठवली होती, तिला आणि तिच्या दोन पुत्रांना घेऊन मोशेचा सासरा इथ्रो आला; ");
INSERT INTO mar_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","पहिल्या मुलाचे नाव गेर्षोम होते कारण त्याचा जन्म झाला त्यावेळी मोशे म्हणाला होता, “मी या देशात परका आहे.” ");
INSERT INTO mar_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","दुसऱ्या मुलाचे नाव एलियेजर असे होते, कारण तो जन्मला तेव्हा मोशे म्हणाला होता, “माझ्या पित्याच्या देवाने मला मदत केली व मला फारोच्या तलवारीपासून वाचवले.” ");
INSERT INTO mar_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","तेव्हा इथ्रो रानात देवाच्या पर्वताजवळ जेथे मोशेने तळ दिला होता तेथे त्याची पत्नी सिप्पोरा व त्याचे दोन पुत्र घेऊन मोशेकडे आला. ");
INSERT INTO mar_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","त्याने मोशेला निरोप पाठवला, “मी तुझा सासरा, इथ्रो, तुझी पत्नी व तिचे दोन पुत्र यांना घेऊन तुझ्याकडे आलो आहे.” ");
INSERT INTO mar_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","तेव्हा मोशे आपल्या सासऱ्याला सामोरा गेला; त्याने त्याच्यापुढे लवून त्यास नमन केले, आणि त्याचे चुंबन घेतले. त्या दोघांनी एकमेकांची खुशाली विचारल्यावर ते तंबूत गेले. ");
INSERT INTO mar_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","परमेश्वराने इस्राएली लोकांसाठी फारोचे व मिसरी लोकांचे काय केले, तसेच मिसराहून प्रवास करताना काय काय संकटे आली व कसा त्रास झाला परमेश्वराने त्यांना कसे वाचवले ती सर्व हकिकत मोशेने आपल्या सासऱ्याला सांगितली. ");
INSERT INTO mar_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","परमेश्वराने इस्राएल लोकांसाठी ज्या चांगल्या गोष्टी केल्या त्या ऐकल्यावर आणि मिसराच्या लोकांपासून परमेश्वराने इस्राएल लोकांस स्वतंत्र केले म्हणून इथ्रोला फार आनंद झाला. ");
INSERT INTO mar_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","इथ्रो म्हणाला, “ज्याने तुम्हास मिसऱ्यांच्या व फारोच्या हातातून सोडवले ज्याने आपल्या प्रजेला मिसऱ्यांच्या तावडीतून स्वतंत्र केले तो परमेश्वर धन्य होय. ");
INSERT INTO mar_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","परमेश्वर सर्व देवांहून श्रेष्ठ आहे हे आता मला कळले. इस्राएल लोकांपेक्षा स्वत:ला श्रेष्ठ मानत असलेल्या मिसरी लोकांचे त्याने काय केले हे मला समजले.” ");
INSERT INTO mar_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","मग मोशेचा सासरा इथ्रो याने देवाला होमबली व यज्ञ केले. नंतर अहरोन इस्राएलाच्या सर्व वडिलांसह मोशेचा सासरा इथ्रो यांच्याबरोबर देवासमोर जेवण करावयास आला. ");
INSERT INTO mar_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","दुसऱ्या दिवशी मोशे लोकांचा न्यायनिवाडा करावयास बसला आणि सकाळपासून संध्याकाळपर्यंत लोक मोशेसमोर उभे होते. ");
INSERT INTO mar_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","मोशे लोकांसाठी काय काय करतो ते इथ्रोने पाहिले तेव्हा तो म्हणाला, “तू लोकांबरोबर जे हे करतोस ते काय आहे? तू एकटाच न्यायनिवाडा करण्यासाठी बसतोस आणि सकाळपासून संध्याकाळपर्यंत सर्व लोक तुझ्याभोवती उभे राहतात ते का?” ");
INSERT INTO mar_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मोशे आपल्या सासऱ्यास म्हणाला, “देवाला प्रश्र विचारण्यासाठी लोक माझ्याकडे येतात. ");
INSERT INTO mar_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","लोकांचा काही भांडणतंटा असेल तर ते माझ्याकडे येतात तेव्हा मी त्यांचा आपसांत निवाडा करतो आणि देवाचे नियम व विधी यांचे शिक्षण त्यांना देतो.” ");
INSERT INTO mar_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","परंतु मोशेचा सासरा त्यास म्हणाला, “हे तू करतोस ते चांगले नाही. ");
INSERT INTO mar_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","तुझ्या एकट्यासाठी हे काम फार आहे, त्यामुळे तू थकून जातोस व लोकही थकून जातात हे काम तुला एकट्याला करवणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","तर आता माझे ऐक, मी तुला सल्ला देतो, आणि देव तुला मदत करो. या लोकांचा देवाकडे तू मध्यस्थ हो आणि यांची प्रकरणे देवापाशी ने. ");
INSERT INTO mar_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","तू त्यांना नियम व विधी यासंबंधी शिक्षण दे; त्यांनी कोणत्या मार्गाने चालावे व कोणते काम करावे त्यांना तू समजावून सांग. ");
INSERT INTO mar_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","तू लोकांमधून कर्तबगार देवाचे भय धरणारे, व विश्वासू, सत्यप्रिय, अन्याय न करणारे असे लोक निवडून घे; त्यांना हजार लोकांवर, शंभर लोकांवर, पन्नास लोकावर आणि दहा लोकांवर नायक म्हणून नेम. ");
INSERT INTO mar_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","या नायक लोकांनी लोकांचा न्यायनिवाडा करावा; जर अगदी महत्वाची बाब असेल तर तिचा न्यायनिवाडा करण्याकरता तो वाद नायकांनी तुझ्याकडे आणावा, परंतु लहानसहान प्रकरणांसंबंधी त्यांनी स्वत: निर्णय द्यावेत. अशा प्रकारे तुझे काम सोपे होईल तसेच तुझ्या कामात ते वाटेकरी होतील. ");
INSERT INTO mar_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","तू असे करशील व देव तुला आज्ञा देईल तर तू टिकशील, आणि हे सर्व लोक शांतीने आपल्या ठिकाणास पोहचतील.” ");
INSERT INTO mar_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","तेव्हा मोशेने इथ्रोच्या म्हणण्याप्रमाणे केले. ");
INSERT INTO mar_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","मोशेने इस्राएल लोकांतून चांगले लोक निवडले आणि त्यांना हजार हजार, शंभर शंभर, पन्नास पन्नास व दहा दहांवर नायक म्हणून नेमले. ");
INSERT INTO mar_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ते लोकांवर न्यायाधीश झाले. लोक सतत नायकांकडे आपली गाऱ्हाणी आणू लागले व मोशेला फार महत्वाच्या प्रकरणांबद्दलच निकाल देण्याचे काम करावे लागे. ");
INSERT INTO mar_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","मग थोड्याच दिवसानी मोशेने आपला सासरा इथ्रो याला निरोप दिला आणि इथ्रो माघारी आपल्या घरी गेला. ");
INSERT INTO mar_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","मिसरामधून प्रवासास निघाल्यानंतर तिसऱ्या महिन्यात इस्राएल लोक सीनायच्या रानात येऊन पोहोचले. ");
INSERT INTO mar_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ते लोक रफीदिम सोडून सीनायच्या रानात आले होते; इस्राएल लोकांनी पर्वतासमोर आपला तळ दिला. ");
INSERT INTO mar_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","तेव्हा मोशे पर्वत चढून देवाकडे गेला. परमेश्वराने त्यास पर्वतावरून हाक मारून सांगितले की, “तू याकोबाच्या वंशजांना हे सांग, इस्राएल लोकांस हे सांग. ");
INSERT INTO mar_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","मिसऱ्यांचे मी काय केले आणि तुम्हास गरुडाच्या पंखावर उचलून घेऊन माझ्याजवळ कसे आणले हे तुम्ही पाहिले आहे. ");
INSERT INTO mar_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","म्हणून मी आता तुम्हास सांगतो की तुम्ही माझी वाणी खरोखर ऐकाल आणि माझ्या कराराचे पालन कराल, तर सर्व लोकांमध्ये माझा खास निधी व्हाल. सर्व पृथ्वी माझी आहे. ");
INSERT INTO mar_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","तुम्ही मला, याजक राज्य, पवित्र राष्ट्र व्हाल. तू इस्राएल लोकांस हेच सांग.” ");
INSERT INTO mar_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","मोशेने येऊन लोकांच्या वडिलांना एकत्र बोलावले; परमेश्वराने त्यास जी वचने सांगण्याची आज्ञा केली होती ती सर्व त्याने त्यांच्यापुढे सांगितली. ");
INSERT INTO mar_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","आणि सर्व लोक मिळून म्हणाले, “परमेश्वराने सांगितलेले सर्व आम्ही करू.” मोशेने परमेश्वरास लोकांचे म्हणणे सांगितले. ");
INSERT INTO mar_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","आणि परमेश्वर मोशेला म्हणाला, “मी दाट ढगात तुझ्याजवळ येऊन तुझ्याशी बोलेन आणि माझे तुझ्याबरोबरचे बोलणे सर्व लोकांस ऐकू जाईल;” त्यांचा नेहमी तुझ्यावरही विश्वास बसेल, मोशेने लोकांचे म्हणणे परमेश्वरास सांगितले. ");
INSERT INTO mar_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","परमेश्वर मोशेला म्हणाला, “तू जाऊन आज आणि उद्या लोकांस पवित्र कर; त्यांनी आपले कपडे स्वच्छ धुवावेत. ");
INSERT INTO mar_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","तिसऱ्या दिवशी त्यांनी तयार रहावे, कारण तिसऱ्या दिवशी सर्व लोकांदेखत परमेश्वर सीनाय पर्वतावर उतरेल. ");
INSERT INTO mar_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","परंतु लोकांसाठी तेथे सीमारेषा आखून लोकांनी ती ओलांडू नये, त्यांना बजावून सांग; पर्वतावर कोणीही चढू नये जो कोणी पर्वताला स्पर्श करेल तो खास आपल्या जिवाला मुकेल. ");
INSERT INTO mar_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","कोणीही त्यास हात लावू नये. हात लावला तर त्यास दगडमार करावी किंवा बाणांनी विंधावे, तो पशू असो किंवा मनुष्य असो, त्यास जिवंत ठेवू नये. शिंगाचा दीर्घ आवाज होईल तेव्हा लोकांनी पर्वताजवळ यावे.” ");
INSERT INTO mar_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","मग मोशे पर्वतावरून खाली उतरला; तो लोकांकडे गेला व देवाच्या भेटीसाठी त्याने त्यांना पवित्र केले. लोकांनी आपले कपडे धुवून स्वच्छ केले. ");
INSERT INTO mar_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","मग मोशे लोकांस म्हणाला, “तीन दिवस तुम्ही देवाची भेट घेण्यासाठी तयार राहा. तोपर्यंत स्त्रीस्पर्श करू नका.” ");
INSERT INTO mar_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तिसरा दिवस उजडताच मेघगर्जना झाली व विजा चमकू लागल्या, पर्वतावर दाट ढग आले आणि प्रचंड शिंगाचा फार आवाज होऊ लागला. तेव्हा छावणीत राहणारे सर्व लोक थरथर कापू लागले. ");
INSERT INTO mar_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","नंतर मोशेने लोकांस छावणीतून बाहेर काढून देवाच्या दर्शनाला बाहेर आणले आणि ते पर्वताच्या तळाजवळ उभे राहिले. ");
INSERT INTO mar_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","परमेश्वर सीनाय पर्वतावर अग्नीतून उत्तरला म्हणून तो पर्वत धुराने झाकून गेला. भट्टीतून येणाऱ्या धुरासारखा त्याचा धूर वर आला, आणि सर्व पर्वत थरथरू लागला. ");
INSERT INTO mar_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","शिंगाचा आवाज मोठमोठा होऊ लागला. तेव्हा मोशे बोलू लागला आणि देव त्यास आपल्या वाणीने उत्तर देत गेला. ");
INSERT INTO mar_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","परमेश्वराने पर्वताच्या शिखरावर उतरून मोशेला सीनाय पर्वताच्या शिखरावर बोलावले. तेव्हा तो पर्वतावर गेला. ");
INSERT INTO mar_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","परमेश्वर मोशेला म्हणाला, “तू खाली जा आणि लोकांस बजावून सांग की त्यांनी मर्यादा ओलांडून परमेश्वर काय आहे ते पाहण्यास तिकडे येऊ नये. जर ते तसे करतील तर बरेच जण मरतील. ");
INSERT INTO mar_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","तसेच परमेश्वराजवळ येणाऱ्या याजकांनीही पवित्र व्हावे; नाहीतर परमेश्वर त्यांना शिक्षा करील.” ");
INSERT INTO mar_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मोशेने परमेश्वरास सांगितले, “लोक सीनाय पर्वतावर येऊ शकणार नाहीत, कारण तूच स्वत: आम्हांला मर्यादा घालून दिली व सक्त ताकीद दिली व तो अधिक पवित्र करण्यास सांगितले.” ");
INSERT INTO mar_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","परमेश्वर त्यास म्हणाला, “तू खाली लोकांकडे जा व मागे येताना अहरोनाला तुझ्याबरोबर परत आण, परंतु याजक किंवा इतर लोकांस इकडे येऊ देऊ नको; ते जर माझ्याजवळ येतील तर मी त्यांना शिक्षा करीन.” ");
INSERT INTO mar_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","मग मोशेने खाली जाऊन लोकांस हे सांगितले. ");
INSERT INTO mar_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","देवाने ही सर्व वचने सांगितली, ");
INSERT INTO mar_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","मी परमेश्वर तुझा देव आहे. ज्याने तुला मिसर देशातून, गुलामगिरीतून सोडवून आणले. ");
INSERT INTO mar_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","माझ्यासमोर तुला इतर कोणतेही दुसरे देव नसावेत. ");
INSERT INTO mar_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","तू आपल्यासाठी कोरीव मूर्ती करू नकोस; वर आकाशातील, खाली पृथ्वीवरील व पृथ्वीखालच्या जलातील कशाचीही प्रतिमा करू नकोस; ");
INSERT INTO mar_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","त्यांची सेवा करू नको; किंवा त्यांच्या पाया पडू नकोस; कारण मी परमेश्वर तुझा देव ईर्ष्यावान देव आहे. जे माझा विरोध करतात, त्यांच्या मुलांना तिसऱ्या चौथ्या पिढीपर्यंत वडिलांच्या अपराधाबद्दल शिक्षा करतो; ");
INSERT INTO mar_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","परंतु जे माझ्यावर प्रेम करतात व माझ्या आज्ञा पाळतात अशांच्या हजारो पिढ्यांवर मी दया करतो. ");
INSERT INTO mar_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","तुझा देव परमेश्वर याचे नाव तू व्यर्थ घेऊ नकोस; कारण जो परमेश्वराचे नाव व्यर्थ घेईल त्याची तो गय करणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","शब्बाथ दिवस हा पवित्र दिवस म्हणून पाळण्याची आठवण ठेव; ");
INSERT INTO mar_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","सहा दिवस श्रम करून तू तुझे कामकाज करावेस; ");
INSERT INTO mar_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","परंतु सातवा दिवस तुझा देव परमेश्वर याचा शब्बाथ आहे, म्हणून त्या दिवशी तू, तुझा पुत्र, तुझी कन्या, तुझे दास व दासी यांनी तसेच तुझे पशू, किंवा तुझ्या वेशीत राहणाऱ्या परकीयांनीही कोणतेही कामकाज करु नये; ");
INSERT INTO mar_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","कारण परमेश्वराने सहा दिवस काम करून आकाश, पृथ्वी, समुद्र व त्यातील सर्वकाही उत्पन्न केले आणि त्यानंतर सातव्या दिवशी विसावा घेतला; या प्रमाणे परमेश्वराने शब्बाथ दिवस हा आशीर्वाद देऊन तो पवित्र केला आहे. ");
INSERT INTO mar_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","आपल्या बापाचा व आपल्या आईचा मान राख म्हणजे त्यामुळे परमेश्वर तुझा देव जो देश तुला देत आहे त्या देशात तू चिरकाळ राहशील. ");
INSERT INTO mar_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","खून करू नकोस. ");
INSERT INTO mar_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","व्यभिचार करू नकोस. ");
INSERT INTO mar_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","चोरी करू नकोस. ");
INSERT INTO mar_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","आपल्या शेजाऱ्याविरूद्ध खोटी साक्ष देऊ नकोस. ");
INSERT INTO mar_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“तू आपल्या शेजाऱ्याच्या घराचा लोभ धरू नकोस; आपल्या शेजाऱ्याच्या पत्नीचा लोभ धरू नकोस; आपल्या शेजाऱ्याचा दासदासी, बैल, गाढव, किंवा त्याच्या कोणत्याही वस्तूचा लोभ धरु नकोस.” ");
INSERT INTO mar_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","लोकांनी पर्वतावरील ढगांचा गडगडाट ऐकला, विजांचा चकचकाट पाहिला, शिंगाचा नाद होत आहे व पर्वतातून धूर वर चढताना पाहून भीतीने त्यांचा थरकाप झाला. ते दूर उभे राहिले. ");
INSERT INTO mar_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ते मोशेला म्हणू लागले आमच्याशी तूच बोल, आम्ही ऐकू; देव आमच्याशी न बोलो, तो बोलेल तर आम्ही मरून जाऊ. ");
INSERT INTO mar_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मग मोशे लोकांस म्हणाला, “भिऊ नका, कारण तुमची परीक्षा करावी आणि त्याचे भय तुमच्या डोळ्यांपुढे राहून तुम्ही पाप करू नये यासाठी देव आला आहे.” ");
INSERT INTO mar_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","मोशे, ढगांच्या दाट अंधारात, जेथे देव होता तेथे गेला, तोपर्यंत लोक पर्वतापासून लांब उभे राहिले. ");
INSERT INTO mar_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","मग परमेश्वर मोशेला म्हणाला, “तू इस्राएल लोकांस असे सांग, मी तुमच्याशी आकाशातून बोललो हे तुम्ही प्रत्यक्ष पाहिले आहे. ");
INSERT INTO mar_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","माझ्या बरोबरीला दुसरे देव करू नका आपल्यासाठी सोन्यारुप्याचे देव करू नका.” ");
INSERT INTO mar_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","माझ्यासाठी मातीची वेदी बांधा आणि तिजवर तुझी मेंढरे व तुझे बैल यांची होमार्पणे व शांत्यर्पणे वाहा; जेथे जेथे मी माझ्या नावाची आठवण व्हावी म्हणून मी सांगतो तेथे तेथे मी येऊन तुम्हास आशीर्वाद देईन. ");
INSERT INTO mar_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","तुम्ही जर दगडाची वेदी बांधणार असाल तर ती घडलेल्या चिऱ्याची नसावी; कारण तुम्ही आपले हत्यार दगडाला लावल्यास तो भ्रष्ट होईल. ");
INSERT INTO mar_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","तुझ्या शरीराची नग्नता माझ्या वेदीवर दिसून येऊ नये म्हणून तू पायऱ्यांनी चढता कामा नये. ");
INSERT INTO mar_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","आता जे इतर नियम तू इस्राएल लोकांस लावून द्यावेत ते हेच: ");
INSERT INTO mar_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","तुम्ही जर एखादा इब्री गुलाम विकत घेतला तर त्याने फक्त सहा वर्षे काम करावे; सातव्या वर्षी त्याच्याकडून काही भरपाई न घेता त्यास मुक्त होऊन जाऊ द्यावे. ");
INSERT INTO mar_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","जर तो एकटाच आला असेल तर त्याने मुक्त होताना एकटेच निघून जावे; परंतु जर तो त्याची पत्नी घेऊन आला असेल तर त्याने त्याच्या पत्नीला घेऊन जावे. ");
INSERT INTO mar_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","जर तो एकटा आला असेल तर त्याच्या मालकाने त्यास पत्नी करून द्यावी; तिला पुत्र किंवा कन्या झाल्या असतील तर ती व तिची मुले मालकाची राहतील; त्याने एकट्यानेच जावे. ");
INSERT INTO mar_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","मी माझ्या मालकावर व माझ्या पत्नीमुलांवर प्रेम करतो, मी मुक्त होऊ इच्छित नाही, असे जर तो स्पष्टपणे सांगतो, ");
INSERT INTO mar_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","तर त्याच्या मालकाने त्यास देवासमोर अथवा त्यास दाराच्या चौकटीजवळ उभे करावे व अरीने त्याचा कान टोचावा. मग तो त्याची आयुष्यभर चाकरी करील. ");
INSERT INTO mar_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","कोणी आपली कन्या गुलाम म्हणून विकली तर तिने पुरुष गुलामाप्रमाणे मुक्त होऊन जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","तिच्या मालकाने तिला आपली पत्नी करून घेण्याचे ठरवले असेल, पण पुढे तिच्यावरून त्याची मर्जी उडाली तर त्याने खंडणी घेऊन तिची मुक्तता करावी. तिला परक्या लोकांस विकण्याचा त्यास अधिकार नाही. तिच्याशी कपटाने वागल्यामुळे तिला विकण्याचा त्यास अधिकार नाही. ");
INSERT INTO mar_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","आपल्या मुलासाठी पत्नी म्हणून तिला ठेवून घ्यायची तिच्या मालकाची इच्छा असेल, तर त्याने तिला आपल्या स्वतःच्या मुलीप्रमाणे वागवावे. ");
INSERT INTO mar_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","त्याने दुसऱ्या स्त्रीशी लग्न केले तरी त्याने पहिल्या पत्नीस अन्न वस्त्र कमी पडू देऊ नये, किंवा तिच्या वैवाहिक अधिकारांना बाधा येऊ देऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","या तीन गोष्टी त्याने तिच्यासाठी केल्या नाहीत तर मग ती त्यास काही खंडणी न देता मुक्त होईल. ");
INSERT INTO mar_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","कोणी एखाद्याला मारले व त्यामुळे तो मेला तर त्यास अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","पूर्वसंकल्प न करता, पण आपघाताने जर एखाद्याच्या हातून कोणाचा मृत्यू झाला. तर त्यास पळून जात येईल असे ठिकाण मी नेमून देईल. ");
INSERT INTO mar_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","परंतु जर कोणी एकाने जाणूनबुजून व ठरवून रागाने किंवा द्वेषाने दुसऱ्या मनुष्यास ठार मारले तर मात्र त्यास शिक्षा करावी; त्यास वेदीपासून खेचून आणून ठार मारावे. ");
INSERT INTO mar_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","कोणी आपल्या पित्याला किंवा आईला मारहाण करील त्यास अवश्य ठार मारावे. ");
INSERT INTO mar_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","जो कोणी एखाद्याला चोरून नेऊन विकेल किंवा त्याच्याकडे तो सापडेल तर त्यास अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","जो कोणी आपल्या पित्याला किंवा आईला शिव्याशाप देईल त्या मनुष्यास अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","दोघेजण भांडत असताना एकाने दुसऱ्याला दगड किंवा ठोसा मारला आणि त्यामुळे तो मेला नाही, पण त्यास अंथरूणात पडून रहावे लागले, ");
INSERT INTO mar_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","तर मारणाऱ्याने त्यास त्याच्या वाया गेलेल्या वेळेबद्दल नुकसान भरपाई द्यावी व तो मनुष्य बरा होईपर्यंत त्याच्यासाठी लागणारा खर्च द्यावा. ");
INSERT INTO mar_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","काही वेळा लोक आपल्या गुलामाला किंवा गुलाम स्त्रीला छडीने मारहाण करतात, त्यामुळे जर तो गुलाम किंवा ती गुलाम स्त्री मरण पावली तर त्यांना मारणाऱ्याला अवश्य शिक्षा करावी; ");
INSERT INTO mar_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","पण तो एकदोन दिवस जिवंत राहिला तर मालकाला शिक्षा होणार नाही कारण तो त्याचेच धन आहे. ");
INSERT INTO mar_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","दोघे जर मारामारी करीत असतील व त्यांचा धक्का एखाद्या गरोदर स्त्रीला लागला आणि त्या स्त्रीचा गर्भपात झाला पण तिला इतर कोणतीही इजा झाली नाही, तर ज्याचा धक्का तिला लागला तिचा पती न्यायाधीशांच्या सल्ल्याने जो दंड ठरवील तो दंड त्याने द्यावा. ");
INSERT INTO mar_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","पण दुसरी काही जास्त इजा झाल्यास जिवाबद्दल जीव, ");
INSERT INTO mar_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","डोळ्याबद्दल डोळा, दाताबद्दल दात, हाताबद्दल हात, पायाबद्दल पाय, ");
INSERT INTO mar_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","चटक्याबद्दल चटका, ओरखड्याबद्दल ओरखडा, व जखमेबद्दल जखम असा बदला घ्यावा. ");
INSERT INTO mar_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","जर एखाद्याने आपल्या गुलामाच्या किंवा गुलाम स्त्रीच्या डोळ्यावर मारल्यामुळे त्याचा किंवा तिचा डोळा गेला तर त्याने त्यास मुक्त करावे. ");
INSERT INTO mar_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","एखाद्या मालकाने आपल्या पुरुष दासाच्या किंवा स्त्री दासीच्या तोंडावर मारल्यामुळे त्याचा किंवा तिचा दात पडला तर त्याने त्यास दास्यमुक्त करून जाऊ द्यावे. ");
INSERT INTO mar_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","एखाद्याच्या बैलाने एखाद्या पुरुषाला किंवा स्त्रीला हुंदडून जिवे मारले तर त्या बैलाला दगडमार करून जिवे मारावे, त्या बैलाचे मांस कोणी खाऊ नये, परंतु त्या बैलाच्या मालकाला सोडून द्यावे. ");
INSERT INTO mar_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","परंतु त्या बैलाला हुंदडण्याची सवयच असली आणि त्याविषयी त्याच्या मालकाला सूचना केली असूनही त्याने त्या बैलाला बांधून ठेवले नाही आणि त्यानंतर कोणा पुरुषाला किंवा स्त्रीला त्याने जिवे मारले तर त्याबद्दल त्याचा मालक दोषी आहे, त्या बैलाला धोंडमार करून जिवे मारावे व त्याच्या मालकालाही जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","त्याच्याकडून खंडणी मागितल्यास त्याने आपला प्राण वाचविण्यासाठी आपल्यावर लादलेली खंडणी देऊन टाकावी. ");
INSERT INTO mar_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","बैलाने एखाद्याच्या पुत्राला किंवा कन्येला हुंदडून जिवे मारले तर त्याबाबतीत हाच नियम लागू करावा. ");
INSERT INTO mar_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","एखाद्या बैलाने जर कोणाच्या पुरुष दासास किंवा स्त्री दासीला हुंदडून ठार मारले तर त्या बैलाच्या मालकाने त्याच्या मालकाला चांदीची तीस शेकेल नाणी द्यावी आणि त्या बैलालाही दगडमार करावी; ");
INSERT INTO mar_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","एखाद्या मनुष्याने बुजलेला खड्डा उकरला किंवा त्याने खड्डा खणून त्यावर झाकण ठेवले नसेल आणि जर कोणाचा बैल, गाढव वगैरे त्या खड्डयात पडून मरण पावले तर खड्ड्याचा मालक दोषी आहे; ");
INSERT INTO mar_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","त्याने त्या जनावराच्या मालकाला भरपाई म्हणून त्याची किंमत द्यावी आणि ते मरण पावलेले जनावर खड्ड्याच्या मालकाचे होईल. ");
INSERT INTO mar_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","जर एखाद्याच्या बैलाने दुसऱ्याच्या बैलाला हुंदडून मारून टाकले तर जिवंत राहिलेला बैल विकून आलेले पैसे दोघा मालकांनी विभागून घ्यावेत आणि मरण पावलेला बैलही विभागून घ्यावा. ");
INSERT INTO mar_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","परंतु तो बैल पूर्वीपासून मारका आहे हे ठाऊक असून मालकाने त्यास बांधून ठेवले नाही, तर त्याने बैलाबद्दल बैल द्यावा व मरण पावलेला बैल त्याचा व्हावा. ");
INSERT INTO mar_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","एखाद्याने बैल किंवा मेंढरू चोरून ते कापले किंवा विकून टाकले तर त्याने एका बैलाबद्दल पाच बैल व एका मेंढराबद्दल चार मेंढरे द्यावीत. ");
INSERT INTO mar_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","चोर घर फोडत असता सापडला व जीव जाईपर्यंत मार बसला तर त्याच्या खुनाचा दोष कोणावर येणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","परंतु तो चोरी करत असता सूर्योदय झाला तर मरणाऱ्यावर खुनाचा दोष येईल. चोराने नुकसान अवश्य भरून द्यावे. त्याच्याजवळ काही नसेल तर चोरीच्या भरपाईसाठी त्याची विक्री करावी. ");
INSERT INTO mar_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","चोरलेला बैल, गाढव, मेंढरू वगैरे चोराच्या हाती जिवंत सापडले तर त्याने एकेकाबद्दल दुप्पट परत द्यावी. ");
INSERT INTO mar_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","कोणी आपले जनावर मोकळे सोडले ते दुसऱ्याच्या शेतात किंवा द्राक्षमळ्यात जाऊन चरले व खाल्ले तर आपल्या शेतातील किंवा द्राक्षमळ्यातील चांगल्यात चांगल्या पिकातून त्याने त्याचे नुकसान भरून द्यावे. ");
INSERT INTO mar_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","जर कोणी काटेकुटे जाळण्यासाठी आग पेटवली व ती भडकल्यामुळे धान्याच्या सुड्या किंवा उभे पीक जळाले तर आग पेटवणाऱ्याने नुकसान भरून दिलेच पाहिजे. ");
INSERT INTO mar_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","कोणी शेजाऱ्याकडे आपला पैसा किंवा काही वस्तू ठेवण्यासाठी दिल्या आणि जर ते सर्व त्याच्या घरातून चोरीस गेले, तर चोर सापडल्यावर त्याच्या दुप्पट किंमत चोराने भरून द्यावी. ");
INSERT INTO mar_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","परंतु जर चोर सापडला नाही, तर घरमालकाला देवासमोर घेऊन जावे म्हणजे मग त्याने स्वतः त्या वस्तुला हात लावला की नाही त्याचा न्याय होईल. ");
INSERT INTO mar_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","जर हरवलेला एखादा बैल, एखादे गाढव, मेंढरू किंवा वस्त्र यांच्यासंबंधी दोन मनुष्यात वाद उत्पन्न झाला, आणि ती माझी आहे अशी कोणी तक्रार केली तर त्या हक्क सांगणाऱ्या दोन्ही पक्षांनी देवासमोर यावे; ज्याला देव दोषी ठरवील त्याने आपल्या शेजाऱ्याला तिच्याबद्दल दुप्पट बदला द्यावा. ");
INSERT INTO mar_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","एखाद्याने आपले गाढव, बैल, किंवा मेंढरू थोडे दिवस सांभाळण्याकरता आपल्या शेजाऱ्याकडे दिले, परंतु ते जर मरण पावले, किंवा जखमी झाले किंवा कोणी पाहत नसताना पकडून नेले; ");
INSERT INTO mar_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","तर त्या दोघांमध्ये परमेश्वराची शपथ व्हावी. आपण शेजाऱ्याच्या मालमत्तेला हात लावला नाही असे सांगितले तर त्या जनावराच्या मालकाने त्याच्या शपथेवर विश्वास ठेवावा; मग त्या शेजाऱ्याला जनावराची किंमत भरून द्यावी लागणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","त्याच्यापासून खरोखर ते चोरीस गेले असेल तर त्याची किंमत मालकाला भरून द्यावी. ");
INSERT INTO mar_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","जर ते जनावर कोणी मारून टाकले असेल तर ते पुराव्यादाखल आणून दाखवावे म्हणजे त्यास भरपाई भरून द्यावी लागणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","जर कोणी आपल्या शेजाऱ्याकडून त्याचे जनावर मागून घेतले मालक तेथे हजर नसताना त्या जनावराला जर इजा झाली किंवा ते मरण पावले तर त्या मालकाला त्याची किंमत अवश्य भरून द्यावी; ");
INSERT INTO mar_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","जर त्या वेळी तेथे जनावराजवळ मालक असेल तर मग भरपाई करावी लागणार नाही; किंवा ते जनावर भाड्याने घेतले असले तर त्याचे नुकसान भाड्यातच आले आहे. ");
INSERT INTO mar_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","आणि मागणी झाली नाही अशा कुमारिकेला फसवून जर कोणी तिला भ्रष्ट केले तर त्याने पूर्ण देज देऊन तिच्याशी लग्न केलेच पाहिजे; ");
INSERT INTO mar_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","तिच्या पित्याने त्यास ती देण्यास नकार दिला तर भ्रष्ट करणाऱ्याने तिच्या पित्याला कुमारिकेच्या रीतीप्रमाणे पैसा तोलून द्यावा. ");
INSERT INTO mar_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","कोणत्याही चेटकिणीला जिवंत ठेवू नये. ");
INSERT INTO mar_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","पशुगमन करणाऱ्याला अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","परमेश्वराशिवाय दुसऱ्या दैवतांना बली करणाऱ्याला अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","उपऱ्याचा छळ करू नये किंवा त्याच्यावर जुलूम करू नको. कारण मिसर देशात तुम्हीही उपरी होता. ");
INSERT INTO mar_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","विधवा किंवा अनाथ यांना तुम्ही जाचू नका ");
INSERT INTO mar_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","तुम्ही त्यांना कोणत्याही रीतीने जाचाल आणि ती मला हाक मारतील तर मी त्यांचे ओरडणे अवश्य ऐकेन; ");
INSERT INTO mar_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","व माझा राग तुम्हावर भडकेल व मी तुम्हास तलवारीने मारून टाकीन म्हणजे तुमच्या स्रिया विधवा व तुमची मुले पोरकी होतील. ");
INSERT INTO mar_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","तुझ्याजवळ राहणाऱ्या माझ्या एखाद्या गरीब मनुष्यास तुम्ही उसने पैसे दिले तर त्याबद्दल तुम्ही व्याज आकारू नये. ");
INSERT INTO mar_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","तू आपल्या शेजाऱ्याचे पांघरुण तुझ्याजवळ गहाण ठेवून घेतले तर सूर्य मावळण्याआधी तू त्याचे पांघरुण त्यास परत करावे; ");
INSERT INTO mar_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","कारण त्याचे अंग झाकायला तेवढेच असणार. ते घेतले तर तो काय पांघरूण निजेल? त्याने गाऱ्हाणे केले तर मी त्याचे ऐकेन, कारण मी करुणामय आहे. ");
INSERT INTO mar_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","तू आपल्या देवाची निंदा करू नको किंवा तुझ्या लोकांच्या राज्यकर्त्याला शाप देऊ नको. ");
INSERT INTO mar_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","आपल्या हंगामातले व आपल्या फळांच्या रसातले मला अर्पण करण्यास हयगय करू नको. तुझा प्रथम जन्मलेला पुत्र मला द्यावा; ");
INSERT INTO mar_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","तसेच प्रथम जन्मलेले बैल व मेंढरे, यांना जन्मल्यापासून सात दिवस त्यांच्या आईजवळ ठेवावे व आठव्या दिवशी ते मला द्यावेत. ");
INSERT INTO mar_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","तुम्ही माझे पवित्र लोक आहात म्हणून फाडून टाकलेल्या पशूंचे मांस तुम्ही खाऊ नये; ते कुत्र्यांना घालावे. ");
INSERT INTO mar_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","खोटी अफवा पसरवू नकोस; दुष्टाच्या हातात हात घालून अन्यायी साक्षी होऊ नकोस. ");
INSERT INTO mar_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","दुष्टाई करण्याकरता पुष्कळ जणांना तू अनुसरू नकोस, आणि तू पुष्कळ जणांच्या मागे लागून वादात न्याय विपरीत करण्यास बोलू नकोस. ");
INSERT INTO mar_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","एखाद्या गरीब मनुष्याचा न्याय होताना, त्याची बाजू खरी असल्याशिवाय त्याचा पक्ष घेऊ नकोस. ");
INSERT INTO mar_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","आपल्या शत्रूचा हरवलेला बैल किंवा एखादे गाढव मोकाट फिरताना दिसले तर त्यास वळवून ते त्याच्याकडे नेऊन सोड. ");
INSERT INTO mar_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","तुझ्या शत्रूचे गाढव जास्त ओझ्याखाली दबून पडलेले दिसले तर तू त्यास सोडून जाऊ नकोस, तू अवश्य त्याच्याबरोबर राहून ते सोड. ");
INSERT INTO mar_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","तू आपल्या गरीबाच्या वादात त्याचा योग्य न्याय विपरीत होऊ देऊ नकोस; ");
INSERT INTO mar_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","कोणावरही खोटे दोषारोप करू नकोस; एखाद्या निष्पाप वा निरपराधी ह्यांचा वध करू नकोस. कारण दुष्टाला मी नीतिमान ठरवणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","लाच देण्याचा प्रयत्न करील, तर ती तू मुळीच घेऊ नकोस; लाच घेऊ नको कारण लाच डोळसास आंधळे करते; आणि नीतिमानांच्या म्हणण्याचा विपरीत न्याय करते. ");
INSERT INTO mar_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","परक्याला कधीही छळू नकोस, कारण त्याच्या मनोभावनेची तुम्हास चांगली माहिती आहे; कारण तुम्ही देखील एके काळी मिसर देशात परके होता. ");
INSERT INTO mar_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","सहा वर्षे आपल्या जमिनीची पेरणी कर; आणि तिचे उत्पन्न साठीव. ");
INSERT INTO mar_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","परंतु सातव्या वर्षी जमीन पडीक राहू दे. त्या वर्षी शेतात काहीही पेरू नये. जर शेतात काही उगवले तर ते गरीबांना घेऊ द्या; व राहिलेले वनपशूंना खाऊ द्या; तुमचे द्राक्षमळे व जैतूनाची वने यांच्या बाबतीतही असेच करावे. ");
INSERT INTO mar_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","तुम्ही सहा दिवस काम करावे, व सातव्या दिवशी विसावा घ्यावा; त्यामुळे तुमच्या गुलामांना व इतर उपऱ्यांनाही विसावा मिळेल व त्यांना ताजेतवाने वाटेल; तुमच्या बैलांना व गाढवानांही विसावा मिळेल. ");
INSERT INTO mar_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","मी जे काही सांगितले ते सर्व नियम कटाक्षाने पाळावेत; इतर देवांचे नांव देखील घेऊ नका; ते तुमच्या तोंडाने उच्चारू नका. ");
INSERT INTO mar_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","वर्षातून तीनदा तू माझ्यासाठी उत्सव करून सण पाळ. ");
INSERT INTO mar_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","बेखमीर भाकरीचा सण पाळ; त्यामध्ये सात दिवस खमीर न घातलेली भाकर तुम्ही खावी; हा सण तुम्ही अबीब महिन्यात पाळावा, कारण याच महिन्यात तुम्ही मिसरमधून बाहेर निघून आला; कोणी रिकाम्या हाताने माझ्यासमोर येऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","शेतात पेरलेल्या पहिल्या पिकाच्या कापणीचा सण पाळावा. वर्षाच्या अखेरीस तू आपल्या श्रमाच्या फळांचा संग्रह करशील तेव्हा संग्रहाचा सण पाळावा. ");
INSERT INTO mar_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","वर्षातून तीनदा तुझ्या सर्व पुरुषांनी प्रभू परमेश्वरासमोर यावे. ");
INSERT INTO mar_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","तुम्ही यज्ञपशूचे रक्त मला अर्पण करावयाचे वेळी खमीर घातलेल्या भाकरीसोबत अर्पण करू नये; आणि मला अर्पण केलेल्या यज्ञपशूची चरबी दुसऱ्या दिवसापर्यंत राहू देऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","आपल्या जमिनीच्या प्रथम उपजातील सर्वोत्तम भाग आपला देव परमेश्वर ह्याच्या मंदिरात आणावा. करडू त्याच्या आईच्या दुधात शिजवू नये. ");
INSERT INTO mar_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","पाहा, वाटेने तुला सांभाळण्याकरता आणि मी तयार केलेल्या स्थानात तुला पोचविण्याकरता मी एक दूत तुझ्यापुढे पाठवत आहे. ");
INSERT INTO mar_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","त्याच्यासमोर सावधगिरीने राहा आणि त्याचे म्हणणे ऐक, आज्ञा पाळ आणि त्याच्यामागे चाल; त्याच्याविरुध्द बंड करू नकोस. कारण तो तुम्हास क्षमा करणार नाही; कारण त्याच्या ठायी माझे नाव आहे. ");
INSERT INTO mar_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","जर तू त्याची वाणी खरोखर ऐकशील व मी सांगतो ते सर्व करशील तर मी तुम्हाबरोबर राहीन; मी तुमच्या सर्व शत्रूंचा शत्रू व विरोधकांचा विरोधक होईन. ");
INSERT INTO mar_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","देव म्हणाला, माझा दूत तुमच्यापुढे चालून अमोरी, हित्ती, परिज्जी, कनानी, हिव्वी व यबूसी या लोकांकडे तुला नेईल आणि मी त्यांचा नाश करीन. ");
INSERT INTO mar_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","परंतु या सर्व लोकांच्या देवाला तू नमन करू नकोस; त्यांची सेवा करू नकोस, त्यांना जमीनदोस्त करावेस; आणि त्यांच्या स्तंभाचे तुकडे तुकडे करावेस. ");
INSERT INTO mar_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तू आपला देव परमेश्वर याचीच उपासना करावीस; म्हणजे तो तुझ्या अन्नपाण्यास बरकत देईल. मी तुमच्यामधून रोगराई दूर करीन. ");
INSERT INTO mar_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","तुझ्या देशात कोणाचा गर्भपात होणार नाही आणि कोणीही वांझ असणार नाही; मी तुला दीर्घायुषी करीन. ");
INSERT INTO mar_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ज्या ज्या लोकांच्या विरूद्ध तू जाशील त्यांना मी आधीच दहशत घालून त्यांची फसगत करीन. आणि तुझ्या सर्व शत्रूंना तुला पाठ दाखवयास लावीन. ");
INSERT INTO mar_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","मी तुझ्यापुढे गांधीलमाशा पाठवीन; त्या हिव्वी, कनानी, व हित्ती ह्यांना तुझ्यापुढून पळावयास लावतील. ");
INSERT INTO mar_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","मी त्यांना एका वर्षातच घालवून देणार नाही; कारण मी तसे केले तर देश एकदम ओस पडेल आणि मग वनपशूंची वाढ होऊन ते तुला त्रास देतील. ");
INSERT INTO mar_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","तुमची संख्या वाढून तू देशाचा ताबा घेशील तोपर्यंत मी हळूहळू तुझ्यापुढून त्यांना घालवून देईन. ");
INSERT INTO mar_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“मी तांबड्या समुद्रापासून पलिष्ट्यांच्या समुद्रापर्यंत आणि रानापासून ते फरात नदीपर्यंत मी तुझ्या देशाची सीमा करीन. तेथे राहणाऱ्या लोकांस मी तुझ्या हाती देईन व तू त्या सर्वांना तेथून घालवून द्याल. ");
INSERT INTO mar_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तू त्याच्याशी किंवा त्यांच्या देवांशी कोणताही करार करू नकोस. ");
INSERT INTO mar_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","तू त्यांना तुझ्या देशात राहू देऊ नकोस; तू जर त्यांना तुझ्यामध्ये राहू देशील तर ते पुढे तुला सापळ्यासारखे अडकविणारे होतील, ते तुला माझ्याविरूद्ध पाप करायला लावतील व तू त्यांच्या देवांची उपासना करण्यास सुरुवात करशील.” ");
INSERT INTO mar_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","मग तो मोशेला म्हणाला, “तू, अहरोन, नादाब, अबीहू आणि इस्राएलांच्या वडिलापैकी सत्तरजण असे मिळून परमेश्वराकडे पर्वतावर चढून येऊन त्यास दुरूनच नमन करा; ");
INSERT INTO mar_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","मग मोशेने एकट्यानेच परमेश्वराजवळ यावे; इतरांनी जवळ येऊ नये, आणि इतर लोकांनी तर पर्वत चढून वरही येऊ नये.” ");
INSERT INTO mar_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मोशेने लोकांस परमेश्वराचे सर्व नियम व आज्ञा सांगितल्या; मग सर्व लोक एका आवाजात म्हणाले, “परमेश्वराने जी वचने सांगितलेली त्या सर्वांप्रमाणे आम्ही करू.” ");
INSERT INTO mar_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","तेव्हा मोशेने परमेश्वराची सर्व वचने लिहून काढली, मोशेने पहाटेस उठून पर्वताच्या पायथ्याशी एक वेदी बांधली व इस्राएलाच्या बारा वंशाप्रमाणे बारा स्तंभ उभे केले. ");
INSERT INTO mar_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","मग मोशेने इस्राएल लोकांपैकी काही तरुणांना परमेश्वरास होमबली व बैलाची शांत्यर्पणे अर्पण करायला पाठवले. ");
INSERT INTO mar_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मोशेने त्या अर्पणातून अर्धे रक्त घेऊन कटोऱ्यात ठेवले आणि अर्धे रक्त त्याने वेदीवर शिंपडले. ");
INSERT INTO mar_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","मग मोशेने कराराचे पुस्तक घेऊन लोकांस वाचून दाखविले आणि ते ऐकून लोक म्हणाले, “परमेश्वराने सांगितले आहे तसे आम्ही करू आणि त्याने दिलेल्या आज्ञा आम्ही पाळू.” ");
INSERT INTO mar_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","मग मोशेने रक्त घेऊन लोकांवर शिंपडले. तो म्हणाला, “परमेश्वराने तुमच्याशी या वचनाप्रमाणे करार केला आहे असे हे त्या कराराचे रक्त आहे.” ");
INSERT INTO mar_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","नंतर मोशे, अहरोन, नादाब, अबीहू व इस्राएल लोकांमधील सत्तर वडीलधारी माणसे पर्वतावर चढून गेले. ");
INSERT INTO mar_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","तेथे त्यांनी इस्राएलाच्या देवाला पाहिले; इंद्रनीलमण्यांच्या चौथऱ्यासारखे तेथे काही होते, ते आकाशाप्रमाणे स्वच्छ होते ");
INSERT INTO mar_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","इस्राएलातील वडिलधाऱ्या मनुष्यांनी देवाला पाहिले, परंतु त्याने त्यांचा नाश केला नाही. मग त्यांनी तेथे एकत्र खाणेपिणे केले. ");
INSERT INTO mar_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","परमेश्वर मोशेला म्हणाला, “पर्वतावर मला भेटावयास ये; मी दोन दगडी पाट्यांवर इस्राएल लोकांच्या शिक्षणासाठी नियम व आज्ञा लिहिलेल्या आहेत; त्या मी तुला देतो.” ");
INSERT INTO mar_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","तेव्हा मोशे व त्याचा मदतनीस यहोशवा हे उठले आणि मोशे देवाच्या पर्वतावर चढून गेला. ");
INSERT INTO mar_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","मोशे इस्राएलांच्या वडिलांना म्हणाला, “आम्ही तुमच्याकडे परत येईपर्यंत तुम्ही येथेच थांबा, मी परत येईपर्यंत अहरोन व हूर हे तुमच्याबरोबर आहेत; कोणाचे काही प्रकरण असेल तर त्याने त्यांच्याकडे जावे.” ");
INSERT INTO mar_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","मग मोशे पर्वतावर चढून गेला आणि ढगाने पर्वत झाकून टाकला; ");
INSERT INTO mar_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","परमेश्वराचे तेज सीनाय पर्वतावर उतरले; ढगाने सहा दिवस पर्वताला झाकून टाकले; सातव्या दिवशी परमेश्वराने मोशेला हाक मारली. ");
INSERT INTO mar_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्राएल लोकांस पर्वताच्या शिखरावर परमेश्वराचे तेज भस्म करणाऱ्या धगधगत्या अग्नीसारखे दिसत होते. ");
INSERT INTO mar_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","मोशे पर्वतावर चढून आणखी वर ढगात गेला; मोशे चाळीस दिवस व चाळीस रात्र तेथे होता. ");
INSERT INTO mar_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्राएल लोकांस माझ्यासाठी अर्पणे आणायला सांग. ज्या कोणाची माझ्यासाठी मनापासून अर्पण करण्याची इच्छा असेल त्या प्रत्येकापासून ही अर्पणे तू माझ्यासाठी स्वीकारावी. ");
INSERT INTO mar_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","त्यांच्याकडून तू माझ्याकरिता घ्यावयाच्या वस्तूंच्या अर्पणाची यादी अशी: सोने, चांदी, पितळ; ");
INSERT INTO mar_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","निळ्या, जांभळ्या व किरमिजी रंगाचे सूत आणि तलम सणाचे कापड; बकऱ्याचे केस; ");
INSERT INTO mar_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","लाल रंगवलेली मेंढ्यांची कातडी; तहशाची कातडी, बाभळीचे लाकूड; ");
INSERT INTO mar_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","दिव्यासाठी तेल, अभिषेकाच्या तेलासाठी आणि सुगंधी धुपासाठी मसाले; ");
INSERT INTO mar_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","एफोद व ऊरपट ह्यात खोचण्यासाठी गोमेदमणी व इतर रत्ने.” ");
INSERT INTO mar_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","मी त्यांच्यामध्ये निवास करावा म्हणून त्यांनी माझ्यासाठी एक पवित्रस्थान तयार करावे. ");
INSERT INTO mar_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","निवासमंडप कसा असावा त्याचा नमुना व त्यातील वस्तू कशा असाव्यात त्यांचा नमुना मी तुला दाखवीन. त्या सगळ्याप्रमाणे तुम्ही तो तयार करावा. ");
INSERT INTO mar_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“बाभळीच्या लाकडाची एक पेटी तयार करावी; त्याची लांबी अडीच हात, रुंदी दीड हात व उंची दीड हात असावी. ");
INSERT INTO mar_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","तो आतून बाहेरून शुध्द सोन्याने मढवावा आणि त्याच्यावर सभोवती शुद्ध सोन्याचा काठ करावा. ");
INSERT INTO mar_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","त्याच्या चारही पायांना लावण्यासाठी सोन्याच्या चार गोल कड्या ओतून एकाबाजूला दोन व दुसऱ्या बाजूला दोन अशा लावाव्या. ");
INSERT INTO mar_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","बाभळीच्या लाकडाचे दांडे करावेत व तेही सोन्याने मढवावेत ");
INSERT INTO mar_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","कोशाच्या कोपऱ्यांवरील गोल कड्यांमध्ये दांडे घालून मग तो वाहून न्यावा. ");
INSERT INTO mar_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","हे दांडे कोशाच्या कड्यातच कायम तसेच राहू द्यावेत, ते काढून घेऊ नयेत.” ");
INSERT INTO mar_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","देव म्हणाला, मी तुला साक्षपट देईन तोही त्या कोशात ठेवावा. ");
INSERT INTO mar_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","मग शुद्ध सोन्याचे एक दयासन बनवावे; त्याची लांबी अडीच हात, रूंदी दीड हात असावी; ");
INSERT INTO mar_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","मग सोन्याचे घडीव काम करून दोन करुब करून ते दयासनाच्या दोन्ही टोकांना ठेवावेत. ");
INSERT INTO mar_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एक करुब एका बाजूला व दुसरा करुब दुसऱ्या बाजूला असे दयासनाशी एकत्र जोडून अखंड सोन्याचे घडवावेत. ");
INSERT INTO mar_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","त्या करुबांचे पंख आकाशाकडे वर पसरलेले असावेत व त्यांच्या पंखांनी दयासन झाकलेले असावे; त्याची तोंडे समोरासमोर असावीत व त्यांची दृष्टी दयासनाकडे लागलेली असावी. ");
INSERT INTO mar_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","दयासन कोशावर ठेवावे. मी तुला जो साक्षपट देईन तो तू त्या कोशात ठेवावा; ");
INSERT INTO mar_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","तेथे मी तुला भेटत जाईन. दयासनावरून त्या साक्षपटाच्या कोशावरील ठेवलेल्या दोन्ही करुबामधून मी तुझ्याशी बोलेन आणि तेथूनच मी इस्राएल लोकांसाठी माझ्या सर्व आज्ञा देईन. ");
INSERT INTO mar_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","बाभळीच्या लाकडाचे एक मेज बनवावे; त्याची लांबी दोन हात, रूंदी एक हात व उंची दीड हात असावी. ");
INSERT INTO mar_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ते शुद्ध सोन्याने मढवावे, व त्याच्या भोवती सोन्याचा काठ करावा. ");
INSERT INTO mar_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","मग चार बोटे रुंदीची एक चौकट बनवावी व सोन्याचा काठ तिच्यावर ठेवावा. ");
INSERT INTO mar_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","मग सोन्याच्या चार गोल कड्या बनवून त्या मेजाच्या चार पायांच्या कोपऱ्यांना लावाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","या कड्या मेजाच्या वरच्या भागा भोवती चौकटीच्या जवळ ठेवाव्यात. मेज वाहून नेण्यासाठी या कड्यांमध्ये दांडे घालावे. ");
INSERT INTO mar_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","मेज वाहून नेण्यासाठी बाभळीच्या लाकडाचे दांडे बनवावेत व ते सोन्याने मढवावेत. ");
INSERT INTO mar_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","मेजावरची तबके, धूपपात्रे, सुरया व पेयार्पणे ओतण्याकरता वाट्या बनव. ही शुद्ध सोन्याची असावीत. ");
INSERT INTO mar_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","माझ्यापुढे मेजावर समक्षतेची भाकर नेहमी ठेवावी. ");
INSERT INTO mar_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","शुद्ध सोन्याचा एक दीपवृक्ष तयार कर, हा दीपवृक्ष घडीव कामाचा असावा. त्याची बैठक व त्याचा दांडा, त्याच्या वाट्या, त्याच्या कळ्या व त्याची फुले ही सर्व एकाच अखंड तुकड्याची असावी. ");
INSERT INTO mar_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","त्या दीपवृक्षाला एका बाजूला तीन व दुसऱ्या बाजूला तीन अशा सहा शाखा असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","प्रत्येक शाखेला बदामाच्या फुलांसारख्या तीन तीन वाट्या या कळ्याफुलांसह असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","या दीपवृक्षाच्या दांड्याला बदामाच्या फुलांसारख्या कळ्या पाकळ्यासहीत असलेल्या फुलाप्रमाणे असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","या दीपवृक्षावर निघणाऱ्या सहा शाखांपैकी दोन दोन शाखा, त्याच्याखाली असलेले एकएक बोंड ही एकाच अखंड तुकड्याची असावी. ");
INSERT INTO mar_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","त्याची बोंडे व त्याच्या शाखा ही सर्व एकाच अखंड तुकड्याची असावी. तो सबंध दीपवृक्ष शुद्ध सोन्याचा एकच घडीव तुकडा असावा. ");
INSERT INTO mar_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","मग या दीपवृक्षावर सात दिवे बसवावेत म्हणजे त्या दिव्यातून दीपवृक्षाच्या समोरील भागावर प्रकाश पडेल. ");
INSERT INTO mar_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","दिवे मालवण्याचे चिमटे व त्यांच्या ताटल्या ही सर्व शुद्ध सोन्याची असावीत. ");
INSERT INTO mar_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","हा दीपवृक्ष त्याच्या सर्व उपकरणासहीत एक किक्कार शुद्ध सोन्याचा करावा; ");
INSERT INTO mar_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","आणि मी तुला पर्वतावर दाखवलेल्या नमुन्याप्रमाणेच या सर्व वस्तू बनविण्याकडे तू लक्ष दे. ");
INSERT INTO mar_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","निवासमंडप दहा पडद्यांचा कर. ते कातलेल्या तलम सणाच्या कापडाचे निळ्या, जांभळ्या व किरमिजी रंगाच्या सुतापासून तयार करावेत. व त्यावर कुशल कारागिराकडून करुब काढावेत. ");
INSERT INTO mar_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","प्रत्येक पडद्याचे मोजमाप एक सारखेच असावे म्हणजे लांबी अठ्ठावीस हात व रूंदी चार हात असावी; ");
INSERT INTO mar_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","त्यांपैकी पाच पडदे एकत्र जोडून एक भाग करावा व दुसऱ्या पाचांचा जोडून दुसरा भाग करावा; ");
INSERT INTO mar_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","जेथे एक पडदा दुसऱ्याशी जोडला जाईल तेथे किनारीवर निळ्या सुताची बिरडी करावीत, तसेच दुसऱ्या पडद्यावरील किनारीवरही तशीच बिरडी कर ");
INSERT INTO mar_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","एका पडद्याला पन्नास बिरडी कर व दुसऱ्या पडद्याच्या किनारीला पन्नास बिरडी कर. ही बिरडी समोरासमोर असावी; ");
INSERT INTO mar_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","पडद्यांचे ते दोन भाग जोडण्यासाठी सोन्याच्या पन्नास गोल कड्या बनवून त्यांच्या साहाय्याने ते दोन भाग एकत्र असे जोडावेत की सर्व मिळून निवासमंडप तयार होईल. ");
INSERT INTO mar_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","त्यानंतर निवासमंडपावरच्या तंबूसाठी बकऱ्याच्या केसांचे पडदे करावेत. हे पडदे अकरा असावे. ");
INSERT INTO mar_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","हे सर्व पडदे एकसारख्या मोज मापाचे म्हणजे तीस हात लांब व चार हात रुंद अशा मापाचे बनवावेत. ");
INSERT INTO mar_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","त्यातून पाच पडदे एकत्र जोडावे आणि सहा पडदे एकत्र जोडावे. सहावा पडदा तंबूच्या पुढल्या बाजूला दुमडावा. ");
INSERT INTO mar_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","पहिल्या भागाच्या कडेखाली पन्नास बिरडी करावीत व दुसऱ्या भागाच्या कडेलाही तशीच पन्नास बिरडी करावीत; ");
INSERT INTO mar_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","नंतर पडदे जोडण्यासाठी पितळेच्या पन्नास गोल कड्या कराव्यात; त्यामुळे दोन भागांना जोडून तंबू अखंड होईल. ");
INSERT INTO mar_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","या तंबूच्या शेवटच्या पडद्याचा अर्धा भाग पवित्र निवासमंडपाच्या मागच्या टोकाखाली लोंबत राहील. ");
INSERT INTO mar_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","आणि तंबूचे पडदे लांबीकडून हातभर या बाजूला व हातभर त्या बाजूला निवासमंडप झाकण्यासाठी त्याच्या दोन्ही बाजूला लोंबते ठेवावे. ");
INSERT INTO mar_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","तंबूसाठी तांबडा रंग दिलेल्या मेंढ्याच्या कातड्याचे एक आच्छादन व दुसरे समुद्र प्राण्याच्या कातड्याचे एक आच्छादन करावे. ");
INSERT INTO mar_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","पवित्र निवासमंडपाला बाभळीच्या लाकडाच्या उभ्या फळ्यांचा आधार करावा. ");
INSERT INTO mar_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","प्रत्येक फळीची लांबी दहा हात व उंची दीड हात असावी. ");
INSERT INTO mar_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","प्रत्येक फळी दुसऱ्याशी जोडण्यासाठी दोन बाजूला दोन कुसे करावीत; निवासमंडपाच्या सर्व फळ्या अशाच कराव्यात. ");
INSERT INTO mar_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","पवित्र निवासमंडपाच्या दक्षिण बाजूसाठी वीस फळ्या कराव्यात. ");
INSERT INTO mar_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","फळ्यांसाठी चांदीच्या चाळीस बैठका कराव्यात. प्रत्येक फळीला आत खोल जाण्यासाठी प्रत्येक बाजूस एक बैठक या प्रमाणे चांदीच्या दोन बैठका असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","पवित्र निवासमंडपाच्या दुसऱ्या म्हणजे उत्तर बाजूसाठी वीस फळ्या कराव्यात; ");
INSERT INTO mar_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","आणि त्यांच्यासाठी प्रत्येक फळीखाली दोन बैठका या प्रमाणे चांदीच्या चाळीस बैठका कराव्यात. ");
INSERT INTO mar_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","पवित्र निवासमंडपाच्या मागच्या बाजूसाठी म्हणजे पश्चिम बाजूसाठी आणखी सहा फळ्या कराव्यात; ");
INSERT INTO mar_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","आणि मागील बाजूला कोपऱ्यांसाठी दोन फळ्या कराव्यात. ");
INSERT INTO mar_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","कोपऱ्याच्या फळ्या खालच्या बाजूला जोडाव्यात; त्यांच्यावरील भागांची कडी त्यांना जोडून ठेवील, दोन्ही कोपऱ्यांसाठी असेच करावे. ");
INSERT INTO mar_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","पवित्र निवासमंडपाच्या पश्चिम टोकास एकूण आठ फळ्या असतील आणि त्या प्रत्येक फळीच्या खाली दोन याप्रमाणे चांदीच्या सोळा बैठका असतील. ");
INSERT INTO mar_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","त्यांच्या फळ्यांसाठी बाभळीच्या लाकडाचे अडसर करावेत; त्यांच्या पहिल्या बाजूस पाच अडसर व ");
INSERT INTO mar_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","दुसऱ्या बाजूस पाच अडसर असावेत; आणि त्यांच्या पाठीमागच्या म्हणजे पश्चिम बाजूस पाच अडसर असावेत. ");
INSERT INTO mar_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","मध्य भागावरील अडसर लाकडांच्या फळ्यातून एका टोकापासून दुसऱ्या टोकापर्यंत जावा. ");
INSERT INTO mar_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","फळ्या आणि अडसर सोन्याने मढवावेत आणि त्यांना जोडणाऱ्या कड्याही सोन्याच्या कराव्यात. ");
INSERT INTO mar_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","मी तुला पर्वतावर दाखवल्याप्रमाणे पवित्र निवासमंडप बांधावा. ");
INSERT INTO mar_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","तलम सणाच्या कापडाचा व निळ्या जांभळ्या व किरमिजी रंगाच्या सुताचा एक अंतरपट बनवावा आणि त्यावर कुशल कारागिराकडून करुब काढून घ्यावेत. ");
INSERT INTO mar_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","बाभळीच्या लाकडाचे चार खांब बनवून ते सोन्याने मढवावेत, त्यावर सोन्याच्या आकड्या लावाव्यात आणि ते खांब चांदीच्या चार उथळ्यांत उभे करावेत; ");
INSERT INTO mar_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","सोन्याच्या आकड्याखाली हा पडदा ठेवावा मग त्याच्यामागे आज्ञापटाचा कोश-ठेवावा; हा अंतरपट पवित्र स्थान व परमपवित्र स्थान यांना अलग करील; ");
INSERT INTO mar_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","परमपवित्रस्थानातील आज्ञापटाच्या कोशावर दयासन ठेवावे. ");
INSERT INTO mar_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","अंतरपटाच्या दुसऱ्या बाजूला तू बनविलेला मेज ठेवावा; तो निवासमंडपाच्या उत्तर बाजूला असावा व दक्षिण बाजूला मेजासमोर दीपवृक्ष ठेवावा. ");
INSERT INTO mar_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“पवित्र निवासमंडपाच्या दारासाठी निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा व कातलेल्या तलम सणाच्या कापडाचा पडदा करून त्यावर वेलबुट्टीदार पडदा बनवावा. ");
INSERT INTO mar_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","हा पडदा लावण्यासाठी बाभळीच्या लाकडाचे पाच खांब करावेत व ते सोन्याने मढवावेत; त्यांच्याकरिता पितळेच्या पाच बैठका बनवाव्यात; हा पडदा अडकविण्यासाठी सोन्याच्या आकड्या कराव्यात.” ");
INSERT INTO mar_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","परमेश्वर मोशेला म्हणाला, बाभळीच्या लाकडाची पाच हात लांब, पाच हात रुंद व तीन हात उंच अशी चौरस वेदी तयार कर. ");
INSERT INTO mar_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","वेदीच्या चार कोपऱ्यांना प्रत्येकी एक अशी चार शिंगे अंगचीच बनलेली असावी; मग वेदी पितळेने मढवावी. ");
INSERT INTO mar_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","वेदीवरील राख काढण्यासाठी लागणारी भांडी, फावडी, कटोरे, काटे व अग्निपात्रे ही सर्व उपकरणे पितळेची बनवावी. ");
INSERT INTO mar_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","तिच्यासाठी पितळेच्या जाळीची एक चाळण बनवावी. ");
INSERT INTO mar_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ही चाळण वेदीच्या कंगोऱ्याखाली, वेदीच्या तळापासून अर्ध्या उंची इतकी येईल अशा अंतरावर लावावी. ");
INSERT INTO mar_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","वेदीसाठी बाभळीच्या लाकडाचे दांडे करावेत व ते पितळेने मढवावेत. ");
INSERT INTO mar_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ते वेदीच्या दोन्ही बाजूच्या कड्यांत घालावेत म्हणजे वेदी उचलून नेण्यासाठी त्यांचा उपयोग होईल. ");
INSERT INTO mar_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","वेदी मध्यभागी पोकळ ठेवावी व बाजूंना फळ्या बसवाव्यात; पर्वतावर मी तुला दाखविल्याप्रमाणे ती तयार करावी. ");
INSERT INTO mar_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","निवासमंडपाला अंगण तयार कर; त्याच्या दक्षिणेला कातलेल्या तलम सणाच्या पडद्यांची कनात कर, तिची लांबी एका बाजूला शंभर हात असावी. ");
INSERT INTO mar_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","तिच्याकरता वीस खांब करावेत व त्यांच्यासाठी पितळेच्या वीस बैठका बनावाव्यात; खांबाच्या आकड्या व पडद्याचे गज चांदीचे करावेत. ");
INSERT INTO mar_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","वेदीच्या उत्तर बाजूलाही शंभर हात लांबीचे पडदे जोडून केलेली कनात असावी, तिच्यासाठी वीस खांब, पितळेच्या वीस बैठका आणि चांदीच्या आकड्या व गज हे सर्व असावे. ");
INSERT INTO mar_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","अंगणाच्या पश्चिम बाजूस पडद्यांची पन्नास हात लांबीचे पडदे जोडून केलेली कनात असावी; तिला दहा खांब व खांबांना दहा खुर्च्या असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","अंगणाची पूर्वेकडील म्हणजे प्रवेश द्वाराकडील बाजूही पन्नास हात असावी. ");
INSERT INTO mar_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","अंगणाच्या फाटकाच्या एका बाजूला पंधरा हात लांबीची पडद्याची कनात असावी; या बाजूस तीन खांब व तीन खुर्च्या असाव्यात; ");
INSERT INTO mar_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","फाटकाच्या दुसऱ्या बाजूलाही पंधरा हात लांबीची पडद्याची कनात, व तिलाही तीन खांब व तीन खुर्च्या हे सर्व असावे. ");
INSERT INTO mar_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","अंगणाच्या फाटकासाठी निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा व कातलेल्या तलम सणाच्या कापडाचा वीस हात लांबीचा पडदा असावा व त्यावर नक्षीदार विणकाम असावे; पडद्यासाठी चार खांब व चार खुर्च्या असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","अंगणाच्या सभोवतीचे सर्व खांब चांदीच्या बांधपट्टयांनी जोडलेले असावेत; त्यांच्या आकड्या चांदीच्या व खुर्च्या पितळेच्या असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","अंगणाची लांबी शंभर हात असावी व पन्नास हात रुंद असावी; अंगणासभोवतीची पडद्याची कनात पाच हात उंच असावी व ती कातलेल्या तलम सणाच्या सुताची बनविलेली असावी; आणि तिच्या खांबाच्या खुर्च्या पितळेच्या असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","पवित्र निवासमंडपातील सर्व उपकरणे, तंबूच्या मेखा आणि इतर वस्तू आणि अंगणासभोवतीच्या कनातीच्या मेखा पितळेच्या असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","इस्राएल लोकांनी दीपवृक्ष सतत जळत ठेवण्यासाठी जैतुनाचे हाताने कुटलेले निर्मळ तेल तुझ्याकडे घेऊन यावे; ");
INSERT INTO mar_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","अंतरपटातील पडद्यामागील आज्ञापटाच्या बाहेर असलेल्या दर्शनमंडपामध्ये अहरोन व त्याचे पुत्र ह्यांनी तो दीपवृक्ष संध्याकाळपासून सकाळपर्यंत परमेश्वरासमोर जळत ठेवण्याची व्यवस्था करावी; हा इस्राएल लोकांसाठी व त्यांच्या वंशासाठी पिढ्यानपिढ्या कायमचा विधी आहे. ");
INSERT INTO mar_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","परमेश्वर मोशेला म्हणाला, याजक म्हणून माझी सेवा करण्यासाठी तुझा भाऊ अहरोन व त्याचे पुत्र नादाब, अबीहू, एलाजार व इथामार यांना इस्राएल लोकांतून वेगळे होऊन तुजकडे येण्यास सांग. ");
INSERT INTO mar_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","आणि गौरवासाठी व शोभेसाठी तुझा भाऊ अहरोन याच्यासाठी पवित्र वस्रे तयार कर. ");
INSERT INTO mar_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ही वस्रे बनवणारे कारागीर ज्यांना मी ज्ञानाच्या आत्म्याने परिपूर्ण केले आहे त्या सर्वांना अहरोनाची वस्रे तयार करण्यास सांग. त्यामुळे तो माझी याजकीय सेवा करण्यासाठी पवित्र होईल. ");
INSERT INTO mar_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","तुझा भाऊ अहरोन व त्याचे पुत्र यांनी याजक या नात्याने माझी सेवा करावी म्हणून कारागिरांनी त्यांच्यासाठी ही पवित्र वस्त्रे ऊरपट, एफोद, झगा, चौकड्याचा अंगरखा, मंदिल व कमरबंद तयार करावीत. ");
INSERT INTO mar_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","त्यांनी सोन्याची जर आणि निळ्या, जांभळ्या व किरमिजी रंगाचे सूत व तलम सणाचे कापड वापरून ही वस्रे तयार करावीत. ");
INSERT INTO mar_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","सोन्याची जर व निळ्या, जांभळ्या व किरमिजी रंगाचे सूत तसेच कातलेल्या तलम सणाचे कापड घेऊन कुशल कारागिराकडून त्यांचे एफोद तयार करून घ्यावे; ");
INSERT INTO mar_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","एफोदाच्या दोन खांदपट्ट्या जोडलेल्या असाव्यात, त्याची दोन टोके जोडावी. ");
INSERT INTO mar_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","एफोद बांधण्यासाठी त्याच्यावर कुशलतेने विणलेली एक पट्टी असते तिची बनावट त्याच्यासारखीच असून ती अखंड असावी; सोन्याच्या जरीची, व निळ्या, जांभळ्या व किरमिजी रंगाचे सुताची व कातलेल्या तलम सणाच्या कापडाची ती असावी. ");
INSERT INTO mar_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","मग दोन गोमेद रत्ने घेऊन त्यांच्यावर इस्राएलाच्या पुत्रांची नावे त्यांच्या जन्माच्या क्रमाने कोरावी. ");
INSERT INTO mar_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","त्यांच्या नावांपैकी सहा नावे एका रत्नावर व बाकीची सहा नावे दुसऱ्या रत्नांवर कोरावी. ");
INSERT INTO mar_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","रत्नावर कोरीव काम करणारा कारागीर कुशलतेने एखादी मुद्रा कोरतो त्याप्रमाणे दोन्ही रत्नांवर इस्राएलाच्या बारा पुत्रांची नावे कोरावीत आणि ती सोन्याच्या जाळीदार कोंदणात बसवावीत. ");
INSERT INTO mar_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ती दोन्ही रत्ने एफोदाच्या दोन्ही खांदपट्ट्यांवर लावावी. ती इस्राएल लोकांची स्मारकरत्ने होत, म्हणजे अहरोन त्यांची नावे परमेश्वरासमोर आपल्या दोन्ही खांद्यांवर स्मरणार्थ वागवील. ");
INSERT INTO mar_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","त्याचप्रमाणे सोन्याची जाळीदार कोंदणे करावीत. ");
INSERT INTO mar_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","पीळ घातलेल्या दोरीसारख्या शुद्ध सोन्याच्या दोन साखळ्या कराव्यात व त्या पीळ घातलेल्या साखळ्या त्या कोंदणात बसवाव्या. ");
INSERT INTO mar_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","न्यायाचा ऊरपटही तयार कुशल कारागिराकडून तयार करावा. जसा एफोद तयार केला, तसाच तो करावा. तो सोन्याच्या जरीचा, आणि निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा व कातलेल्या तलम सणाच्या कापडाचा करावा; ");
INSERT INTO mar_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","तो चौरस व दुहेरी असावा; व त्याची लांबी व रुंदी प्रत्येकी एक वीत असावी. ");
INSERT INTO mar_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","त्यामध्ये रत्ने खोचलेल्या चार रांगा असाव्या; पहिल्या रांगेत लाल, पुष्कराज व माणिक; ");
INSERT INTO mar_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दुसऱ्या रांगेत पाचू, इंद्रनीलमणी व हिरा; ");
INSERT INTO mar_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तिसऱ्या रांगेत तृणमणी, सूर्यकांत व पद्मराग; ");
INSERT INTO mar_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","आणि चौथ्या रांगेत लसणा, गोमेद व यास्फे; ही सर्व रत्ने सोन्याच्या कोंदणात खोचावीत. ");
INSERT INTO mar_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ऊरपटावर इस्राएलाच्या प्रत्येक पुत्राच्या नावाच्या संख्येएवढी ही रत्ने असावीत. त्यांच्या संख्येइतकी बारा नावे असावीत. मुद्रा जशी कोरतात तसे बारा वंशांपैकी एकेकाचे नाव एकेका रत्नावर कोरावे. ");
INSERT INTO mar_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ऊरपटावर लावण्यासाठी दोरीसारखा पीळ घातलेल्या शुद्ध सोन्याच्या साखळ्या कराव्यात. ");
INSERT INTO mar_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ऊरपटावर सोन्याच्या दोन कड्या कराव्यात; त्या न्यायाच्या ऊरपटाच्या दोन्ही टोकांना लावाव्यात; ");
INSERT INTO mar_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ऊरपटाच्या टोकांना लावलेल्या या दोन कड्यांत पीळ घातलेल्या सोन्याच्या साखळ्या घालाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","पीळ घातलेल्या दोन्ही साखळ्यांची दुसरी टोके दोन्ही कोंदणात खोचून त्या एफोदाच्या दोन्ही खांदपट्ट्यांवर पुढल्या बाजूला लावाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","सोन्याच्या आणखी दोन कड्या करून न्यायाच्या ऊरपटाच्या आतल्या दोन्ही कोपऱ्यांना एफोदाच्या बाजूला लावाव्या. ");
INSERT INTO mar_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","सोन्याच्या आणखी दोन कड्या करून त्या खांदपट्ट्याखालील एफोदाच्या समोर त्याच्या जोडाजवळील पट्टीवर लावाव्या. ");
INSERT INTO mar_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","त्या ऊरपटाच्या कड्या एफोदाच्या कड्यांना निळ्या फितीने बांधाव्या, ह्याप्रमाणे तो कुशलतेने विणलेल्या एफोदाच्या पट्टीवर राहील, आणि ऊरपट एफोदावरून घसरणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","अहरोन पवित्रस्थानात प्रवेश करील तेव्हा त्याच्या ऊरपटावर म्हणजे आपल्या हृदयावर त्याने इस्राएलाच्या मुलांची नावे कोरलेली असतील, त्यामुळे परमेश्वरास इस्राएलाच्या बारा पुत्रांची सतत आठवण राहील. ");
INSERT INTO mar_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ऊरपटात तू उरीम व थुम्मीम ठेव. अहरोन परमेश्वरासमोर येईल तेव्हा ते त्याच्या हृदयावर असतील. त्यामुळे इस्राएल लोकांचा न्याय करण्याचा मार्ग तो नेहमी आपल्या हृदयावर घेऊन जाईल. ");
INSERT INTO mar_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","एफोदाबरोबर घालावयाचा झगा संपूर्ण निळ्या रंगाचा करावा; ");
INSERT INTO mar_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","त्याच्या मध्यभागी डोके घालण्यासाठी एक भोक असावे आणि त्याच्या भोवती कापडाचा गोट शिवावा म्हणजे झग्याचा तो भाग फाटणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताच्या कापडाची डाळिंबे काढून ती त्या झग्याच्या खालच्या घेराभोवती लावावीत आणि दोन डाळिंबाच्या मधील जागेत सोन्याची घुंगरे लावावीत; ");
INSERT INTO mar_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","त्यामुळे झग्याच्या घेराच्या खालच्या बाजूला एक डाळिंब व एक घुंगरू अशी क्रमवार ती असावीत. ");
INSERT INTO mar_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","सेवा करताना अहरोनाने हा झगा घालावा; जेव्हा जेव्हा तो पवित्रस्थानात परमेश्वरासमोर जाईल किंवा तेथून बाहेर पडेल तेव्हा तेव्हा त्या घुंगरांचा आवाज ऐकू येईल; त्यामुळे तो मरावयाचा नाही. ");
INSERT INTO mar_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","शुद्ध सोन्याची एक पट्टी बनवावी आणि मुद्रा कोरतात तशी तिच्यावर परमेश्वरासाठी पवित्र ही अक्षरे कोरावीत. ");
INSERT INTO mar_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ही सोन्याची पट्टी अहरोनाच्या मंदिलाला समोरील बाजूस निळ्या फितीने बांधावी; ");
INSERT INTO mar_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ती अहरोनाच्या कपाळावर सतत असावी. ह्यासाठी की ज्या गोष्टी इस्राएल लोक परमेश्वरास पवित्र अर्पण करतील म्हणजे ज्या पवित्र भेटी त्यासंबंधीचा दोष अहरोनाने वाहावा; त्यामुळे ती दाने परमेश्वरास मान्य ठरतील. ");
INSERT INTO mar_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","चौकड्यांचा अंगरखा तलम सणाचा करावा व एक मंदिलही तलम सणाचा करावा आणि एक वेलबुट्टीदार कमरबंद करावा. ");
INSERT INTO mar_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","अहरोनाच्या पुत्रांसाठीही अंगरखे, कमरबंद व फेटे करावेत; ही वस्रे गौरवासाठी व शोभेसाठी असावी. ");
INSERT INTO mar_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","तुझा भाऊ अहरोन ह्याला व त्याच्या पुत्रांना ही वस्रे घालून, त्यांना अभिषेक करावा व त्यांच्यावर संस्कार करावा आणि त्यांना पवित्र कर म्हणजे मग याजक या नात्याने ते माझी सेवा करतील. ");
INSERT INTO mar_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“त्यांच्यासाठी सणाच्या कापडाचे चोळणे कर म्हणजे कमरेपासून मांडीपर्यंत त्यांचे अंग झाकलेले राहील. ");
INSERT INTO mar_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","आणि अहरोन व त्याचे पुत्र दर्शनमंडपामध्ये प्रवेश करतील व पवित्रस्थानात सेवा करण्यास जातील तेव्हा त्यांनी हे चोळणे घातलेले असावे; तसे न केल्यास, दोषी ठरून ते मरतील; अहरोनाला व त्यानंतर त्याच्या वंशाला हा कायमचा नियम आहे.” ");
INSERT INTO mar_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","त्यांनी याजक या नात्याने माझी सेवा करावी म्हणून त्यांना पवित्र करण्यासाठी तू काय करावेस ते मी तुला सांगतो: एक गोऱ्हा व दोन निर्दोष मेंढे घ्यावेत; ");
INSERT INTO mar_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","बेखमीर भाकरी, तेलात मळलेल्या बेखमीर पोळ्या व तेल लावलेल्या बेखमीर चपात्या घ्याव्यात; या सर्व सपिठाच्या असाव्यात. ");
INSERT INTO mar_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","त्या सर्व एका टोपलीत घालून ती टोपली त्याचप्रमाणे तो गोऱ्हा व ते दोन मेंढे ह्यांच्यासहीत ती टोपली घेऊन ये. ");
INSERT INTO mar_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","अहरोन व त्याचे पुत्र यांना दर्शनमंडपाच्या दारासमोर घेऊन यावे; त्यांना आंघोळ घालावी; ");
INSERT INTO mar_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ती वस्रे घेऊन अहरोनाला त्याचा अंगरखा व एफोदाचा झगा घाल; त्यास एफोद व ऊरपट बांधावा आणि एफोदाचा बेलबुट्टीदार पट्टा त्याच्या कमरेला बांध; ");
INSERT INTO mar_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","त्याच्या डोक्याला मंदिल घाल. आणि मंदिलावर पवित्र मुकुट ठेव. ");
INSERT INTO mar_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","नंतर अभिषेकाचे तेल त्याच्या डोक्यावर ओतून त्यास अभिषेक कर; ");
INSERT INTO mar_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","मग त्याच्या पुत्रांना जवळ बोलावून त्यांना अंगरखे घालावेत; ");
INSERT INTO mar_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","आणि अहरोनाला व त्याच्या पुत्रांना कमरबंद बांध व त्यांच्या डोक्यांना फेटे बांधावेत; अशा प्रकारे या विधीने त्यांचे याजकपद कायमचे राहील, ह्याप्रमाणे अहरोन व त्याची मुले ह्यांच्यावर संस्कार करावेत ");
INSERT INTO mar_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","नंतर तो गोऱ्हा दर्शनमंडपासमोर आणावा आणि अहरोन व त्याची मुले यांनी आपले हात त्याच्या डोक्यावर ठेवावेत. ");
INSERT INTO mar_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","मग तेथेच परमेश्वरासमोर दर्शनमंडपाच्या दारापाशी त्या गोऱ्ह्याचा वध करावा; ");
INSERT INTO mar_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","मग गोऱ्ह्याचे थोडे रक्त घेऊन ते आपल्या बोटांनी वेदीच्या शिंगांना लावावे व बाकीचे सगळे रक्त वेदीच्या पायथ्याशी ओतावे. ");
INSERT INTO mar_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","मग त्याच्या आतड्यांवरील सर्व चरबी, काळजावरील पडदा आणि दोन्ही गुरदे व त्यांच्यावरील चरबी ही सर्व घेऊन त्याचा वेदीवर होम करावा. ");
INSERT INTO mar_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","पण गोऱ्ह्याचे मांस, कातडे व शेण ही छावणीबाहेर नेऊन आगीत जाळून टाकावी; हा पापार्पणाचा बली होय. ");
INSERT INTO mar_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","मग अहरोन व त्याच्या मुलांनी आपले हात एका मेंढ्याच्या डोक्यावर ठेवावेत; ");
INSERT INTO mar_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","आणि तो मेंढा वधावा; व त्याचे रक्त वेदीच्या चारही बाजूस टाकावे. ");
INSERT INTO mar_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","मेंढा कापल्यानंतर त्याचे तुकडे करावेत; मग त्याची आतडी व पाय धुऊन ते, त्याचे तुकडे व डोके यांच्यासह वेदीवर ठेवावेत; ");
INSERT INTO mar_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","त्यानंतर वेदीवर सबंध मेंढ्याचा होम करावा. हे परमेश्वराकरता होमार्पण होय. हे परमेश्वराप्रीत्यर्थ सुवासिक हव्य होय; ");
INSERT INTO mar_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","नंतर अहरोन व त्याच्या मुलांनी दुसऱ्या मेंढ्याच्या डोक्यावर आपले हात ठेवावेत; ");
INSERT INTO mar_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","मग तो मेंढा वधावा व त्याच्या रक्तातून थोडे रक्त घेऊन ते अहरोनाच्या व त्याच्या मुलांच्या उजव्या कानांच्या पाळ्यांना व त्यांच्या उजव्या हातांच्या व उजव्या पायांच्या अंगठ्यांना लावावे आणि बाकीचे रक्त वेदीवर चार बाजूंना शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","नंतर वेदीवरील रक्त आणि अभिषेकाचे तेल यांतले काही घेऊन अहरोनावर व त्याच्या वस्रावर तसेच त्याच्या पुत्रावर व त्यांच्या वस्रांवरही शिंपडावे; अशाने तो व त्याची वस्र आणि त्याच्याबरोबर त्याची मुले व त्यांची वस्रे पवित्र होतील. ");
INSERT INTO mar_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","तो मेंढा संस्काराचा आहे म्हणून त्याची चरबी, आणि त्याची चरबीदार शेपूट व त्याच्या आतड्यावरील चरबी व काळजावरील पडदा, दोन्ही गुरदे व त्याच्यावरील चरबी आणि उजवी मांडी ही घे; ");
INSERT INTO mar_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","त्याचप्रमाणे परमेश्वरासमोर ठेवलेल्या बेखमीर भाकरीच्या टोपलीतून एक भाकर, तेलात मळलेल्या सपिठाची एक पोळी व एक चपाती घ्यावी ");
INSERT INTO mar_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","आणि ते सर्व अहरोन व त्याच्या पुत्रांच्या हातावर ठेव व हे ओवाळणीचे अर्पण म्हणून परमेश्वरासमोर ओवाळ. ");
INSERT INTO mar_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","मग त्या सर्व वस्तू त्यांच्या हातातून घेऊन मेंढ्यासह परमेश्वरासमोर सुवासिक मधुर सुगंध म्हणून वेदीवरील होमार्पणावर त्यांचा होम करावा; ते परमेश्वरास अर्पिलेले सुवासिक हव्य होय. ");
INSERT INTO mar_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","मग अहरोनाच्या संस्कारासाठी वधिलेल्या मेंढ्यांचे ऊर घेऊन ओवाळणीचे अर्पण ते परमेश्वरासमोर ओवाळ, तो तुझा हिस्सा आहे. ");
INSERT INTO mar_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","नंतर अहरोन व त्याचे पुत्र यांच्या संस्कारासाठी वधिलेल्या मेंढ्यांचे ओवाळलेले ऊर व समर्पिलेली मांडी तू पवित्र करावी. ");
INSERT INTO mar_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","इस्राएल लोकांकडून मिळणारा अहरोनाचा व त्याच्या पुत्रांचा हा निरंतरचा हक्क आहे. कारण हे समर्पित केलेले दान आहे. हे इस्राएलाकडून त्यांच्या शांत्यर्पणाच्या यज्ञांपैकी परमेश्वराकरता समर्पित केलेले दान होय. ");
INSERT INTO mar_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","अहरोनाची पवित्र वस्रे त्याच्यानंतर त्याच्या पुत्रपौत्रांसाठी असावी, म्हणजे या वस्रांनिशी त्यांचा अभिषेक होऊन त्यांच्यावर संस्कार व्हावा. ");
INSERT INTO mar_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","अहरोनाच्या जागी त्याचा जो पुत्र याजक होईल त्याने पवित्रस्थानात सेवा करण्यासाठी दर्शनमंडपामध्ये जाताना ती वस्रे सात दिवस घालावीत. ");
INSERT INTO mar_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","समर्पण विधीसाठी वध केलेल्या मेंढ्याचे मांस घेऊन ते पवित्र जागी शिजवावे; ");
INSERT INTO mar_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","अहरोन व त्याच्या मुलांनी त्या मेंढ्याचे मांस आणि टोपलीतील भाकर दर्शनमंडपाच्या दारापाशी खावी; ");
INSERT INTO mar_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","त्यांचा संस्कार व पवित्रीकरण ह्यासाठी ज्या पदार्थांनी प्रायश्चित्त झाले ते पदार्थ त्यांनी खावे. पण कोणी परक्याने ते खाऊ नयेत. कारण ते पदार्थ पवित्र आहेत. ");
INSERT INTO mar_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","समर्पित केलेल्या मांसातले किंवा भाकरीतले जर काही सकाळपर्यंत उरले तर ते अग्नीत जाळून टाकावे, ते खाऊ नये कारण ते पवित्र आहे; ");
INSERT INTO mar_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","मी तुला आज्ञा केली आहे त्या सर्व गोष्टीप्रमाणे अहरोन व त्याचे पुत्र यांचे कर. सात दिवसपर्यंत त्यांच्यावर संस्कार कर. ");
INSERT INTO mar_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","प्रायश्चित्तासाठी पापबली म्हणून एक गोऱ्हा या प्रत्येक दिवशी बली दे. आणि वेदीसाठी प्रायश्चित्त करून ती पवित्र कर आणि ती पवित्र करण्यासाठी तिला अभिषेक कर. ");
INSERT INTO mar_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सातही दिवस वेदीसाठी प्रायश्चित्त करून ती पवित्र कर म्हणजे वेदी परमपवित्र होईल, ज्याचा वेदीला स्पर्श होईल ते पवित्र होईल. ");
INSERT INTO mar_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","वेदीवर होम करायचा तो असा: प्रतिदिनी एकएक वर्षाच्या दोन कोकरांचा नेहमी होम करावा. ");
INSERT INTO mar_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एका कोकराचा सकाळी व दुसऱ्या कोकराचा संध्याकाळी होम करावा. ");
INSERT INTO mar_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","कुटून काढलेल्या पाव हिन तेलात एक दशमांश माप सपीठ मळून ते एका कोकराबरोबर अर्पावे आणि पाव हिन द्राक्षरसाचे पेयार्पण करावे. ");
INSERT INTO mar_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","आणि संध्याकाळी दुसरे कोकरू अर्पावे व त्याच्याबरोबरही सकाळच्याप्रमाणे अन्नार्पण व पेयार्पण करावे; हे परमेश्वरास प्रिय असे सुवासिक हव्य होय. ");
INSERT INTO mar_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","दर्शनमंडपाच्या दारापाशी दररोज परमेश्वरासमोर तुम्ही पिढ्यानपिढ्या असेच होमार्पण करीत रहावे; या ठिकाणी मी तुमच्याशी बोलण्यासाठी तुम्हास भेटेन. ");
INSERT INTO mar_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","त्या ठिकाणी मी इस्राएल लोकांस भेटेन आणि माझ्या तेजाने मंडप पवित्र होईल. ");
INSERT INTO mar_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“ह्याप्रमाणे मी दर्शनमंडप व वेदी पवित्र करीन आणि अहरोन व त्याच्या पुत्रांनी याजक या नात्याने माझी सेवा करावी म्हणून मी त्यांनाही पवित्र करीन. ");
INSERT INTO mar_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","मी इस्राएल लोकांमध्ये राहीन आणि त्यांचा देव होईन. ");
INSERT INTO mar_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","आणि लोकांस समजेल की मी त्यांचा देव परमेश्वर आहे; मला त्यांच्याबरोबर राहता यावे म्हणून मीच त्यांना मिसर देशातून सोडवून आणले आहे हे त्यांना कळेल; मी त्यांचा देव परमेश्वर आहे.” ");
INSERT INTO mar_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","तू धूप जाळण्यासाठी बाभळीच्या लाकडाची एक वेदी कर. ");
INSERT INTO mar_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ती चौरस असून एक हात लांब व एक हात रुंद असावी, आणि ती दोन हात उंच असावी; तिची शिंगे एकाच अखंड लाकडाची करावी. ");
INSERT INTO mar_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","वेदीचा वरचा भाग व तिच्या चारही बाजू शुद्ध सोन्याने मढवाव्यात आणि सभोवती सोन्याचा कंगोरा करावा. ");
INSERT INTO mar_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","त्या कंगोऱ्याखाली वेदीच्या एकमेकीच्या विरूद्ध बाजूंना सोन्याच्या दोन दोन गोल कड्या असाव्यात; त्यांच्यात दांडे घालून वेदी उचलून नेण्याकरता त्यांच्या उपयोग होईल. ");
INSERT INTO mar_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","हे दांडे बाभळीच्या लाकडाचे करून ते सोन्याने मढवावेत. ");
INSERT INTO mar_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","वेदी अंतरपटासमोर ठेवावी; आज्ञापटाचा कोश अंतरपटाच्या मागे असेल; आज्ञापटाच्या कोशावर असणाऱ्या दयासनासमोर वेदी असेल; याच ठिकाणी मी तुला भेटत जाईन. ");
INSERT INTO mar_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","अहरोन दिव्याची तेलवात करण्यासाठी येईल त्या प्रत्येक सकाळी दररोज त्याने वेदीवर सुगंधी धूप जाळावा; ");
INSERT INTO mar_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","पुन्हा संध्याकाळी अहरोन दिवे लावण्यासाठी येईल तेव्हा त्याने वेदीवर सुंगधी धूप जाळावा; याप्रमाणे दररोज परमेश्वरापुढे सुंगधी धूप सतत पिढयानपिढया जाळीत जावा. ");
INSERT INTO mar_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","तिच्यावर निराळा धूप किंवा होमार्पण, अन्नार्पण किंवा कोणत्याही प्रकारचे पेयार्पण अर्पण करू नये. ");
INSERT INTO mar_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","अहरोनाने वर्षातून एकदा वेदीच्या शिंगावर प्रायश्चित्त करावे; पिढ्यानपिढ्या वर्षातून एकदा प्रायश्चित्तासाठी अर्पिलेल्या लोकांच्या पापांची भरपाई करण्यासाठी अहरोनाने पापार्पणाच्या रक्ताने तिच्यासाठी त्याने प्रायश्चित्त करावे. ही वेदी परमेश्वराकरता परमपवित्र आहे. ");
INSERT INTO mar_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","मग परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“तू इस्राएल लोकांची शिरगणती करशील तेव्हा गणनेवेळी आपणावर काही मरी येऊ नये म्हणून त्यांतल्या प्रत्येक इस्राएलाने स्वत:च्या जिवाबद्दल परमेश्वरास खंड द्यावा; ");
INSERT INTO mar_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","जितक्या लोकांची मोजदाद होईल तितक्यांनी पवित्रस्थानातील शेकेलाच्या चलनाप्रमाणे अर्धा शेकेल द्यावा. हा अर्धा शेकेल परमेश्वराकरता केलेले समर्पण आहे. ");
INSERT INTO mar_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","वीस वर्षे व त्याहून जास्त वयाच्या लोकांमध्ये ज्याची गणना होईल त्यातील प्रत्येकाने त्याने परमेश्वराकरता हे समर्पण करावे. ");
INSERT INTO mar_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","तुम्ही आपल्या जिवाबद्दल प्रायश्चित्त म्हणून परमेश्वराकरता हे समर्पण कराल तेव्हा श्रीमंत मनुष्याने अर्धा शेकेलापेक्षा जास्त देऊ नये व गरीबाने अर्धा शेकेलापेक्षा कमी देऊ नये; ");
INSERT INTO mar_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","इस्राएल लोकांकडून प्रायश्चित्ताचा पैसा घ्यावा आणि त्याचा दर्शनमंडपामधील सेवेसाठी उपयोग करावा; हा पैसा इस्राएल लोकांच्या जिवाबद्दल प्रायश्चित्त दिल्याचे स्मारक म्हणून त्यांच्याप्रीत्यर्थ परमेश्वरासमोर राहील.” ");
INSERT INTO mar_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“पितळेचे एक गंगाळ बनवून ते पितळेच्या बैठकीवर ठेवावे, त्यातील पाण्याचा हातपाय धुण्यासाठी उपयोग करावा; ते दर्शनमंडप व वेदी यांच्यामध्ये ठेवावे व ते पाण्याने भरावे. ");
INSERT INTO mar_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","या गंगाळातील पाण्याने अहरोन व त्याच्या मुलांनी आपले हातपाय धुवावेत; ");
INSERT INTO mar_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","दर्शनमंडपामध्ये व वेदीजवळ सेवा करण्यास जाताना म्हणजे परमेश्वराकरता हव्य जाळण्यासाठी जातेवेळी त्यांनी आपले हातपाय धुवावेत; नाहीतर ते मरतील. ");
INSERT INTO mar_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","अहरोन व त्याचे वंशज ह्याच्यासाठी हा पिढ्यानपिढ्या निरंतरचा विधी व्हावा.” ");
INSERT INTO mar_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","मग परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“तू उत्तम प्रकारचे मसाले घे; म्हणजे पवित्र स्थानातल्या चलनाप्रमाणे पाचशे शेकेल प्रवाही गंधरस; त्याच्या निम्मे म्हणजे अडीचशे शेकेल सुगंधी दालचिनी, पाचशे शेकेल सुगंधी बच, ");
INSERT INTO mar_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","आणि पवित्रस्थानाच्या शेकेलाप्रमाणे पाचशे शेकेल तज आणि एक हीनभर जैतूनाचे तेल घे, ");
INSERT INTO mar_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","व त्याचे अभिषेकाचे पवित्र तेल म्हणजे गांध्याच्या कसबाप्रमाणे मिसळलेले अभिषेकासाठी पवित्र, सुंगधी तेल तयार कर; ");
INSERT INTO mar_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","या तेलाने दर्शनमंडप व साक्षीकोश, ");
INSERT INTO mar_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","तसेच मेज व त्यांवरील सर्व वस्तू, दीपवृक्ष व त्याची उपकरणे, धूपवेदी, ");
INSERT INTO mar_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","तसेच होमवेदी व होमवेदीच्या सर्व वस्तू आणि गंगाळ व त्याची बैठक या सर्वांना अभिषेक करावा. ");
INSERT INTO mar_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","त्यांना पवित्र करावे म्हणजे ती परमपवित्र ठरतील; ज्याचा त्यांना स्पर्श होईल ते पवित्र होईल. ");
INSERT INTO mar_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","आणि अहरोन व त्याच्या पुत्रांना अभिषेक करून पवित्र कर. मग याजक या नात्याने ते माझी सेवा करतील; ");
INSERT INTO mar_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","इस्राएल लोकांस तू सांग की, पिढ्यानपिढ्या तुम्हास माझ्यासाठीच हेच पवित्र अभिषेकाचे तेल असणार. ");
INSERT INTO mar_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","हे तेल कोणाही मनुष्याच्या अंगाला लावायचे नाही. व या प्रकारचे तेल कोणीही तयार करू नये; हे तेल पवित्र आहे आणि तुम्ही ह्याला पवित्रच मानावे. ");
INSERT INTO mar_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जो कोणी त्याच्यासारखे मिश्रण तयार करील किंवा ते कोणा परक्याला लावील तर त्यास आपल्या लोकांतून बाहेर काढून टाकावे.” ");
INSERT INTO mar_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","नंतर परमेश्वर मोशेला म्हणाला, “तू हे सुवासिक मसाले म्हणजे उत्तम गंधरस, जटामासी, गंधाबिरुजा व शुद्ध ऊद ही घ्यावी. या सर्व वस्तू समभाग घ्याव्यात; ");
INSERT INTO mar_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","आणि गांध्याच्या कसबाप्रमाणे मिसळून मिठाने खारावलेले, निर्भेळ शुद्ध व पवित्र असे धूपद्रव्य तयार करावे; ");
INSERT INTO mar_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","त्यातले काही कुटून त्याचे चूर्ण करावे, व ते दर्शनमंडपामधील ज्या साक्षकोशापुढे मी तुला दर्शन देत जाईन तेथे ठेवावे; ते तुम्ही परमपवित्र लेखावे. ");
INSERT INTO mar_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","हे परमेश्वरासाठी पवित्र लेखावे; त्यासारखे दुसरे धूपद्रव्य तुम्ही स्वतःसाठी तयार करू नये. ");
INSERT INTO mar_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","सुवास घेण्याकरता कोणी असले काही तयार करील तर त्यास आपल्या लोकांतून बाहेर काढून टाकावे.” ");
INSERT INTO mar_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","नंतर परमेश्वर मोशेला म्हणाला ");
INSERT INTO mar_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“पाहा, यहूदा वंशातील उरीचा मुलगा म्हणजे हूरचा नातू बसालेल याला मी निवडून घेतले आहे. ");
INSERT INTO mar_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","देवाच्या आत्म्याने त्यास परिपूर्ण भरले आहे; आणि सर्व प्रकारची कामे करण्यासाठी मी त्यास अक्कल, बुद्धी व ज्ञान ही दिली आहेत. ");
INSERT INTO mar_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","तो सोने, चांदी व पितळ यांच्या कलाकुसरीचे काम करील. ");
INSERT INTO mar_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","तो रत्नांना सुंदर पैलू पाडील व हिरे जडवून देईल; तो लाकडावरील कोरीव कामही करील; आणि अशा सर्व प्रकारची कलाकुसरीची कामे करील. ");
INSERT INTO mar_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","त्याच्याबरोबर काम करण्याकरता दान याच्या वंशातील अहिसामाखाचा मुलगा अहलियाब यालाही मी निवडले आहे; एवढेच नव्हे तर जेवढे म्हणून बुध्दिमान आहेत त्या सर्वांच्या हृदयात मी बुध्दी ठेवली आहे. ती यासाठी की, तुला आज्ञा केल्याप्रमाणे त्यांनी सर्व गोष्टी तयार कराव्या. ");
INSERT INTO mar_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","म्हणजे दर्शनमंडप, आज्ञापटाचा कोश, त्यावरील दयासन आणि तंबूच्या सर्व वस्तू; ");
INSERT INTO mar_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","मेज व त्यावरील सर्व वस्तू, शुद्ध सोन्याचा दीपवृक्ष व त्याची उपकरणे; ");
INSERT INTO mar_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","होमवेदी व तिची उपकरणे, गंगाळ व त्याची बैठक; ");
INSERT INTO mar_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","अहरोन व त्याच्या मुलांनी याजक या नात्याने माझी सेवा करताना घालावयाची, कुशलतेने विणलेली तलम व पवित्र वस्रे; ");
INSERT INTO mar_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अभिषेकाचे सुवासिक तेल आणि पवित्र स्थानी जाळावयाचा सुंगधी द्रव्याचा धूप. या सर्व वस्तू मी तुला सांगितल्याप्रमाणे हे कारागीर तयार करतील.” ");
INSERT INTO mar_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","नंतर परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“इस्राएल लोकांस हे सांग की, तुम्ही माझे शब्बाथ अवश्य पाळावेत, कारण की पिढ्यानपिढ्या तुमच्यामाझ्यामध्ये ही खूण आहे. ह्यावरून हे कळावे की, तुम्हास पवित्र करणारा मी परमेश्वर आहे. ");
INSERT INTO mar_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","म्हणून शब्बाथ दिवस तुम्ही पवित्रपणे पाळावा; शब्बाथ दिवसास जर कोणी भ्रष्ट करील तर त्यास अवश्य जिवे मारावे; जो कोणी त्यादिवशी काम करील, त्यास आपल्या लोकांतून बाहेर काढून टाकावे. ");
INSERT INTO mar_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","सहा दिवस काम करावे. परंतु सातवा दिवस परमेश्वराचा पवित्र दिवस परमविश्रामाचा शब्बाथ होय. जर कोणी शब्बाथ दिवशी काम करील तर त्यास अवश्य ठार मारावे. ");
INSERT INTO mar_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इस्राएल लोकांनी शब्बाथ पाळावा; शब्बाथ हा निरंतरचा करार समजून त्यांनी तो पिढ्यानपिढ्या पाळावा. ");
INSERT INTO mar_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","शब्बाथ दिवस इस्राएल लोकांमध्ये व माझ्यामध्ये कायमची खूण आहे. परमेश्वराने सहा दिवस काम करून आकाश व पृथ्वी निर्माण केल्यावर सातव्या दिवशी स्वस्थ राहून विसावा घेतला.” ");
INSERT INTO mar_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","या प्रमाणे देवाने सीनाय पर्वतावर मोशेबरोबर आपले बोलणे संपविले व मग त्याने आपल्या बोटांनी लिहिलेल्या दोन दगडी पाट्यांचे आज्ञापट त्यास दिले. ");
INSERT INTO mar_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","मोशेला पर्वतावरून उतरण्यास बराच विलंब लागला आहे असे लोकांनी पाहिले तेव्हा सर्व लोक अहरोनाभोवती जमले व त्यास म्हणाले, “पाहा, मोशेने आम्हांला मिसर देशातून बाहेर आणले आहे. परंतु मोशेचे काय झाले ते आम्हांला कळत नाही, म्हणून आमच्यापुढे चालतील असे देव आमच्यासाठी तयार कर.” ");
INSERT INTO mar_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","तेव्हा अहरोन लोकांस म्हणाला, “तुम्ही तुमच्या स्रिया, पुत्र व कन्या यांच्या कानातील सोन्याची कुंडले मजकडे आणा.” ");
INSERT INTO mar_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","मग सर्व लोकांनी आपल्या कानातील सोन्याची कुंडले काढून अहरोनाकडे आणली. ");
INSERT INTO mar_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","अहरोनाने लोकांकडून ते सोने घेतले; आणि ते ओतून व कोरणीने कोरून त्यापासून वासरू केले. मग लोक म्हणाले, “हे इस्राएला, ज्या देवाने तुला मिसर देशातून बाहेर आणले आहे तो हाच देव आहे.” ");
INSERT INTO mar_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","अहरोनाने हे सर्व पाहिले तेव्हा त्याने त्या वासरापुढे एक वेदी बांधली आणि जाहीर करून तो म्हणाला, “तुमच्या परमेश्वराकरता उद्या उत्सव होणार आहे.” ");
INSERT INTO mar_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","लोक दुसऱ्या दिवशी पहाटेस उठले; त्यांनी होमार्पणे अर्पिली व शांत्यर्पणे आणली. मग ते खाण्यापिण्यास बसले; नंतर उठून ते खेळायला लागले. ");
INSERT INTO mar_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","त्या वेळी परमेश्वर मोशेला म्हणाला, “तू पर्वत उतरुन लवकर खाली जा, कारण ज्या तुझ्या लोकांस तू मिसर देशातून बाहेर आणले ते बिघडले आहेत. ");
INSERT INTO mar_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ज्या मार्गाने त्यांनी जावे म्हणून मी त्यांना आज्ञापिले होते त्या मार्गापासून किती लवकर ते बहकून गेले आहेत. त्यांनी आपल्यासाठी सोने वितळवून वासराची मूर्ती केली आहे; ते त्याची पूजा करीत आहेत व त्यास बली अर्पणे वाहत आहेत; ते म्हणत आहेत, ‘हे इस्राएला, याच देवांनी तुला मिसर देशातून बाहेर आणले आहे.” ");
INSERT INTO mar_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","परमेश्वर मोशेला म्हणाला, “या लोकांस मी पाहिले आहे; ते ताठ मानेचे लोक आहेत; ");
INSERT INTO mar_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","तर आता मला आड येऊ नको, त्यांना माझ्या रागाच्या तडाख्याने भस्म करतो. नंतर मी तुझ्यापासूनच एक महान राष्ट्र निर्माण करतो.” ");
INSERT INTO mar_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","परंतु काकुळतीने विनंती करून मोशे आपला देव परमेश्वर ह्याला म्हणाला, हे परमेश्वरा, तुझ्या महान सामर्थ्याने व भुजप्रतापाने त्यांना मिसर देशातून बाहेर आणले त्यांच्यावर तुझा कोप का भडकावा? ");
INSERT INTO mar_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","आणि परमेश्वराने त्यांचे वाईट करण्यासाठी, डोंगरावर त्यांना ठार मारण्यासाठी व पृथ्वीवरून त्यांचा नायनाट करण्यासाठी त्यांना मिसर देशातून बाहेर आणले असे मिसरी लोकांनी का म्हणावे? आपल्या तीव्र कोपापासून फीर, आणि आपल्या लोकांवर आपत्ती आणण्याच्या हेतूपासून परावृत्त हो. ");
INSERT INTO mar_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","तुझे सेवक अब्राहाम, इसहाक व इस्राएल, यांची आठवण कर; तू तुझ्या नावाने शपथ वाहिली होतीस; तू म्हणाला होतास, मी तुमची संतती आकाशातील ताऱ्यांइतकी जास्तीत जास्त करीन, मी ज्या देशाविषयी सांगितले तो सर्व देश मी तुझ्या संततीला देईन व तो सर्वकाळ त्यांचे वतन होईल. ");
INSERT INTO mar_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तेव्हा आपल्या लोकांवर आपत्ती आणण्याचा जो परमेश्वराचा हेतू होता, त्यापासून तो परावृत्त झाला. ");
INSERT INTO mar_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","मग मोशे पर्वतावरून साक्षपटाच्या दोन पाट्या घेऊन पर्वतावरून खाली उतरला. त्या पाट्यावर पुढे व मागे अशा दोन्ही बाजूंना लिहिलेले होते. ");
INSERT INTO mar_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","देवाने स्वत:च त्या पाट्या तयार केल्या होत्या व त्यांच्यावर कोरलेला लेख देवाने लिहिलेला होता. ");
INSERT INTO mar_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","यहोशवाने लोकांचा गोंगाट ऐकला व तो मोशेला म्हणाला, “छावणीत लढाईसारखा आवाज ऐकू येत आहे.” ");
INSERT INTO mar_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मोशेने उत्तर दिले, “एखाद्या सैन्याच्या विजयाचा हा आवाज नाही किंवा एखाद्या सैन्याच्या पराभवाचा हा आक्रोश नाही; मला जो आवाज ऐकू येत आहे तो नाचगाण्यांचा आहे.” ");
INSERT INTO mar_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","मोशे छावणीजवळ येऊन पोहोचल्यावर त्याने ते सोन्याचे वासरू व लोकांच्या नाचगाण्यांचा धिंगाणा पाहिला आणि तो भयंकर संतापला; त्याने आपल्या हातातल्या दगडी पाट्या खाली डोंगराच्या पायथ्याशी फेकून फोडून टाकल्या. ");
INSERT INTO mar_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","नंतर लोकांनी बनविलेले ते सोन्याचे वासरू मोशेने तोडून फोडून ते अग्नीत जाळले. व कुटून त्याची पूड केली; मग ती पाण्यात टाकली. नंतर ते पाणी त्याने इस्राएल लोकांस प्यायला दिले. ");
INSERT INTO mar_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","मोशे अहरोनास म्हणाला, “या लोकांनी तुझे असे काय केले होते की तू त्यांना असे भयंकर पाप करावयास लावलेस?” ");
INSERT INTO mar_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","अहरोन मोशेला म्हणाला, “स्वामी, असे माझ्यावर रागावू नका; या लोकांची प्रवृत्ती पापाकडे आहे, हे आपल्याला माहीत आहे. ");
INSERT INTO mar_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","लोक मला म्हणाले, ‘मोशेने आम्हांला मिसर देशातून काढून बाहेर आणले; परंतु आता त्याचे काय झाले हे आम्हांला माहीत नाही; तेव्हा आमच्यापुढे चालतील असे देव तू आमच्यासाठी करून दे.’ ");
INSERT INTO mar_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","तेव्हा मी त्यांना सांगितले, ‘जर तुमच्याकडे सोन्याची कुंडले असतील तर ती मला द्या.’ तेव्हा लोकांनी मला त्यांच्याकडील सोने दिले; मी सोने भट्टीत टाकले आणि तिच्यातून हे वासरू बाहेर आले.” ");
INSERT INTO mar_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मोशेने पाहिले की अहरोनाने लोकांवरचे नियंत्रण ढिले केले त्यामुळे ते बेभान होत गेले आणि त्यांच्या मूर्खपणाच्या आचरणाचा तमाशा त्यांच्या शत्रूंनी पाहिला. ");
INSERT INTO mar_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","तेव्हा मोशे छावणीच्या दाराजवळ उभा राहिला आणि म्हणाला, “ज्या कोणाला परमेश्वराच्या मागे यावयाचे असेल, त्याने मजकडे यावे,” आणि लगेच लेवी वंशाचे सर्व लोक मोशेकडे जमा झाले. ");
INSERT INTO mar_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","मग मोशे त्यांना म्हणाला, “इस्राएलाचा देव परमेश्वर काय म्हणतो ते मी तुम्हास सांगतो, ‘प्रत्येकाने आपल्या कमरेस तलवार लटकावावी आणि छावणीच्या या प्रवेशव्दारापासून त्या प्रवेशव्दारापर्यंत अवश्य जावे आणि प्रत्येक मनुष्याने आपला भाऊ, मित्र व शेजारी यांना अवश्य जिवे मारावे.” ");
INSERT INTO mar_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","लेवी वंशाच्या लोकांनी मोशेची आज्ञा पाळली आणि त्या दिवशी सुमारे तीन हजार इस्राएल लोक मरण पावले. ");
INSERT INTO mar_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","मग मोशे म्हणाला, “आज आपणाला परमेश्वराकरता समर्पण करून प्रत्त्येक पुरुषाने आपल्या पुत्रावर व भावावर चालून जावे, म्हणजे आज तो तुम्हास आशीर्वाद देईल.” ");
INSERT INTO mar_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","दुसऱ्या दिवशी सकाळी मोशेने लोकांस सांगितले, “तुम्ही भयंकर पाप केले आहे! परंतु आता मी परमेश्वराकडे पर्वतावर जातो; काहीतरी करून कदाचित मला तुमच्या पापांचे प्रायश्चित करता येईल.” ");
INSERT INTO mar_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","तेव्हा मोशे माघारी परमेश्वराकडे जाऊन म्हणाला, “हाय, हाय या लोकांनी फार घोर पातक केले आहे. आपणासाठी सोन्याचे देव बनविले; ");
INSERT INTO mar_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","तरी आता तू त्यांच्या या पापांची क्षमा कर! परंतु जर तू त्यांच्या पापांची क्षमा करणार नसशील तर मग तू लिहिलेल्या पुस्तकातून मला काढून टाक.” ");
INSERT INTO mar_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","परंतु परमेश्वर मोशेला म्हणाला, “जे माझ्याविरूद्ध पाप करतात केवळ त्या लोकांचीच नावे मी माझ्या पुस्तकातून काढून टाकतो. ");
INSERT INTO mar_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","तेव्हा तू आता खाली जा आणि मी सांगतो तेथे लोकांस घेऊन जा; माझा दूत तुझ्यापुढे चालेल व तुला मार्ग दाखवील. जेव्हा पाप केलेल्या लोकांस शिक्षा करण्याची वेळ येईल तेव्हा त्यांना शिक्षा केली जाईल.” ");
INSERT INTO mar_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","अहरोनाने बनवलेले वासरू लोकांनीच बनवले होते, म्हणून परमेश्वराने त्यांना ताडण केले. ");
INSERT INTO mar_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","मग परमेश्वराने मोशेला सांगितले, “तू आणि तुझ्याबरोबर मिसर देशातून तू आणलेले लोक, तुम्ही येथून पुढच्या प्रवासास निघा; आणि जो देश मी तुझ्या संततीला देईन अशी मी अब्राहाम, इसहाक व याकोब यांना शपथ वाहिली होती त्या देशाला तुम्ही जा. ");
INSERT INTO mar_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","तुमच्यापुढे चालण्यासाठी मी माझ्या दूताला पाठवीन आणि कनानी, अमोरी, हित्ती, परिज्जी, हिव्वी व यबूसी लोकांस तेथून घालवून देईन. ");
INSERT INTO mar_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","दुधामधाचे प्रवाह वाहत असलेल्या देशात तू जा; मी तुमच्याबरोबर येणार नाही, कारण तुम्ही फार ताठ मानेचे लोक आहात. मी आलो तर रस्त्यातच तुम्हास नष्ट करीन.” ");
INSERT INTO mar_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ही वाईट बातमी ऐकल्यावर लोक फार दु:खी झाले आणि त्यानंतर कोणीही आपल्या अंगावर दागदागिने घातले नाहीत; ");
INSERT INTO mar_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","कारण परमेश्वर मोशेला म्हणाला, “तू इस्राएल लोकांस असे सांग, ‘तुम्ही फार ताठ मानेचे लोक आहात; मी तुमच्याबरोबर थोडा वेळ जरी असलो तरी मी तुम्हास भस्म करीन; म्हणून तुम्ही तुमचे दागदागिने काढून ठेवा; मग तुमचे काय करावयाचे ते मी पाहीन.” ");
INSERT INTO mar_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","म्हणून होरेब पर्वतापासून पुढे इस्राएल लोक दागदागिन्यांवाचून राहिले. ");
INSERT INTO mar_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मोशे छावणीबाहेर बऱ्याच अंतरावर तंबू लावत असे. मोशेने त्यास दर्शनमंडप असे नाव दिले होते; ज्या कोणाला परमेश्वरास काही विचारावयाचे असेल तो छावणीबाहेरील दर्शनमंडपाकडे जाई. ");
INSERT INTO mar_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ज्या वेळी मोशे छावणीतून मंडपाकडे जाई त्या वेळी सर्व लोक आपापल्या तंबूच्या दारात उभे राहत आणि मोशे मंडपाच्या आत जाईपर्यंत त्यास निरखून बघत. ");
INSERT INTO mar_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","जेव्हा मोशे मंडपात जाई तेव्हा मेघस्तंभ खाली उतरून येई आणि मंडपाच्या दारापाशी तो उभा राही; ह्याप्रमाणे परमेश्वर मोशेशी बोलत असे. ");
INSERT INTO mar_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","जेव्हा लोक दर्शनमंडपाच्या दारात ढग बघत तेव्हा ते आपापल्या तंबूच्या दारात उभे राहून देवाला नमन करीत. ");
INSERT INTO mar_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","मित्रांशी बोलावे त्याप्रमाणे परमेश्वर मोशेबरोबर समोरासमोर बोलत असे. मोशे छावणीकडे माघारी जात असे. तरी मोशेचा मदतनीस नूनाचा मुलगा यहोशवा, हा तरुण मंडप सोडून बाहेर येत नसे. ");
INSERT INTO mar_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मोशे परमेश्वरास म्हणाला, “पाहा या लोकांस घेऊन जाण्यास तू मला सांगितलेस, परंतु तू माझ्याबरोबर कोणाला पाठविणार ते तू सांगितले नाहीस; तू मला म्हणालास, मी तुला तुझ्या नावाने ओळखतो आणि तुझ्यावर माझी कृपादृष्टी आहे. ");
INSERT INTO mar_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","आता माझ्यावर तुझी कृपादृष्टी असल्यास तुझे मार्ग मला दाखव म्हणजे मला तुझी ओळख पटेल आणि त्यामुळे तुझी कृपादृष्टी माझ्यावर होईल. पाहा, हे राष्ट्र तुझी प्रजा आहे.” ");
INSERT INTO mar_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","परमेश्वराने उत्तर दिले, “मी स्वत: तुझ्याबरोबर येईन व तुला विसावा देईन.” ");
INSERT INTO mar_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","मग मोशे परमेश्वरास म्हणाला, “जर तू स्वतः येणार नाहीस तर मग आम्हांला या येथून पुढे नेऊ नकोस. ");
INSERT INTO mar_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","तसेच तुझी कृपादृष्टी माझ्यावर व तुझ्या लोकांवर झाली आहे हे कशावरून समजावे? जर तू आमच्याबरोबर आल्याने मी व हे तुझे लोक पृथ्वीवरील इतर सर्व लोकांहून वेगळे झालो आहो यावरूनच ते समजायचे ना?” ");
INSERT INTO mar_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","मग परमेश्वर मोशेला म्हणाला, “तू मागतोस त्याप्रमाणे मी करीन, कारण माझी कृपादृष्टी तुझ्यावर झाली आहे आणि मी व्यक्तीशः तुला तुझ्या नावाने ओळखतो.” ");
INSERT INTO mar_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","नंतर मोशे म्हणाला, “आता कृपा करून मला तुझे तेज दाखव.” ");
INSERT INTO mar_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","मग परमेश्वराने मोशेला उत्तर दिले, “मी माझे सर्व चांगुलपण तुझ्यापुढे चालवीन; मी परमेश्वर आहे आणि हे माझे नाव मी जाहीर करीन. ज्याच्यावर कृपा करावीशी वाटेल त्याच्यावर मी कृपा करीन आणि ज्याच्यावर दया करावीशी वाटते त्याच्यावर दया करीन. ");
INSERT INTO mar_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","परंतु” तू माझा “चेहरा पाहू शकणार नाहीस, कारण माझा चेहरा पाहिलेला कोणीही मनुष्य जिवंत राहणार नाही.” ");
INSERT INTO mar_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","परमेश्वर म्हणाला, “माझ्याजवळ या ठिकाणी एक खडक आहे; तू त्यावर उभा राहा. ");
INSERT INTO mar_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","माझे तेज त्या जागेजवळून पुढे जाईल, तेव्हा मी तुला त्या खडकातील मोठ्या भेगेत ठेवीन; आणि मी निघून जाईपर्यंत माझ्या हाताने तुला झाकीन; ");
INSERT INTO mar_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","नंतर मी माझा हात काढून घेईन आणि तू माझी पाठ पाहशील; परंतु तू माझा चेहरा पाहणार नाहीस.” ");
INSERT INTO mar_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","मग परमेश्वर मोशेला म्हणाला, “पहिल्या दोन पाट्यांप्रमाणे आणखी दोन दगडी पाट्या घडून तयार कर म्हणजे फोडून टाकलेल्या पहिल्या पाट्यांवर जी वचने होती ती मी त्याच्यावर लिहीन. ");
INSERT INTO mar_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","पहाटेस तयार हो व सीनाय पर्वतावर चढून ये आणि तेथे पर्वताच्या शिखरावर माझ्यासमोर हजर राहा. ");
INSERT INTO mar_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तुझ्याबरोबर कोणी चढून वर येऊ नये पर्वतावरील कोणत्याच ठिकाणी कोणी मनुष्य दिसू नये; तसेच शेरडेमेंढरे कळप व गुरेढोरे ह्यांना त्या पर्वताच्या पायथ्याशी चरू देऊ नकोस.” ");
INSERT INTO mar_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","तेव्हा मोशेने पहिल्या पाट्यांसारख्याच आणखी दोन दगडी पाट्या घडून तयार केल्या; सकाळीच उठून त्या हाती घेऊन परमेश्वराच्या आज्ञेप्रमाणे सीनाय पर्वतावर चढून गेला; ");
INSERT INTO mar_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","तेव्हा मोशे पर्वतावर आल्यावर परमेश्वर एका ढगातून त्याच्याकडे खाली उतरला व तेथे त्याच्यापाशी उभा राहिला; आणि त्याने परमेश्वर या नावाची घोषणा केली. ");
INSERT INTO mar_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","परमेश्वर त्याच्यापुढून अशी घोषणा करीत गेला: “परमेश्वर, परमेश्वर, दयाळू, कृपाळू देव, मंदक्रोध, दयेचा व सत्याचा सागर, ");
INSERT INTO mar_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","हजारो जणांवर दया करणारा, अन्याय, अपराध व पाप यांची क्षमा करणारा, पण अपराधी जनांची मुळीच गय न करणारा, असा तो वडिलांच्या दुष्टाईबद्दल पुत्रपौत्रांचा तिसऱ्या व चौथ्या पिढीपर्यंतही समाचार घेतो.” ");
INSERT INTO mar_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","मग मोशेने ताबडतोब भूमीपर्यंत वाकून परमेश्वरास नमन केले. ");
INSERT INTO mar_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","मग तो म्हणाला, “हे प्रभू, तुझी कृपादृष्टी जर माझ्यावर झाली असेल तर तू आमच्याबरोबर चालावे. हे लोक ताठ मानेचे आहेत हे मला माहीत आहे; तरी आमचा अन्याय व पाप यांची तू आम्हांला क्षमा कर आणि आपले वतन म्हणून आमचा स्वीकार कर.” ");
INSERT INTO mar_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","मग परमेश्वर म्हणाला, “पाहा, मी तुझ्या सर्व लोकांबरोबर हा करार करीत आहे; आतापर्यंत पृथ्वीवरील कोणत्याही राष्ट्रासाठी यापूर्वी कधीही केलेले नाहीत ते चमत्कार मी करीन; ज्या लोकांमध्ये तू राहशील ते सर्व लोक परमेश्वराची कृती पाहतील, कारण जे मी तुझ्याबरोबर करणार आहे ते भयानक आहे. ");
INSERT INTO mar_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","मी आज तुला ज्या आज्ञा देतो त्या तू पाळ म्हणजे मग मी अमोरी, कनानी, हित्ती, परिज्जी, हिव्वी व यबूसी या लोकांस तुझ्यासमोरुन घालवून देतो. ");
INSERT INTO mar_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","सावध राहा, नाही तर तू ज्या देशात जात आहेस त्यामध्ये राहणाऱ्या लोकांबरोबर कोणत्याही प्रकारे करारमदार करशील आणि तो तुला पाश होईल. ");
INSERT INTO mar_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","परंतु त्यांच्या वेद्या पाडून टाक; त्यांचे स्तंभ तोडून टाक; त्यांच्या अशेरा मूर्ती फोडून टाक. ");
INSERT INTO mar_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","तू तर कोणत्याही दुसऱ्या देवाला नमन करू नये; कारण ज्याचे नाव ईर्ष्यावान असे आहे; तो परमेश्वर ईर्ष्यावान देव आहे. ");
INSERT INTO mar_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","तू सावध राहा. या देशातील रहिवाशाबरोबर कोणत्याही प्रकारचे करारमदार करू नको; ते व्यभिचारी मतीने आपल्या देवामागे लागून त्यांना बलिदान करतील. त्यातल्या कोणी तुला बोलावले असता तुम्ही त्यांच्या बलिदानातले काही खाल. ");
INSERT INTO mar_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","त्यांच्या कन्यांची तुम्ही आपल्या पुत्रांसाठी पत्नी म्हणून निवड कराल; त्यांच्या कन्या व्यभिचारी मतीने आपल्या देवाच्यामागे जातील आणि त्या तुमच्या पुत्रांना व्यभिचारी बुध्दीने त्यांच्या नादी लावतील. ");
INSERT INTO mar_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","तू आपल्यासाठी ओतीव देव करू नको. ");
INSERT INTO mar_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","बेखमीर भाकरीचा सण पाळ, मी दिलेल्या आज्ञेप्रमाणे नेमलेल्या वेळी अबीब महिन्यातील सात दिवसपर्यंत तू बेखमीर भाकर खावी, कारण अबीब महिन्यात मिसर देशातून तू बाहेर निघालास. ");
INSERT INTO mar_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","प्रत्येक प्रथम जन्मलेला माझा आहे; तसेच तुझ्या गुरांढोरापैकी गायीचे व मेंढराचे प्रथम जन्मलेले नरवत्स माझे आहेत. ");
INSERT INTO mar_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गाढवीचे पहिले शिंगरु खंडणी दाखल एक कोकरू देऊन सोडवून घ्यावे, पण त्यास तसे सोडवले नाही तर त्याची मान मोडावी. तुझ्या मुलांपैकी प्रत्येक ज्येष्ठ पुत्राला मोबदला देऊन सोडवून घ्यावा. कोणी रिकाम्या हाताने माझ्यासमोर येऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","सहा दिवस तू आपले कामकाज कर, परंतु सातव्या दिवशी विसावा घे; नांगरणीच्या व कापणीच्या हंगामातही सातव्या दिवशी तू विसावा घे. ");
INSERT INTO mar_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","तू सप्ताहाचा, म्हणजे गव्हाच्या कापणीच्या प्रथम पिकाचा सण पाळावा. ");
INSERT INTO mar_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","तुमच्या सर्व पुरुषांनी वर्षातून तीनदा इस्राएलाचा देव प्रभू परमेश्वर ह्यासमोर हजर रहावे. ");
INSERT INTO mar_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","मी तर परराष्ट्रांना तुझ्यापुढून घालवून देईन; मी तुझ्या देशाच्या सीमा वाढवीन; आणि वर्षातून तीनदा तू आपला देव परमेश्वर ह्याच्यामोर हजर राहायला जाशील त्या वेळी तुझ्या देशाचा कोणीही लोभ धरणार नाही. ");
INSERT INTO mar_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","माझ्या यज्ञबलीचे रक्त खमिराच्या भाकरीबरोबर अर्पू नये; आणि वल्हांडण सणाच्या यज्ञपशूचे काहीही सकाळपर्यंत राहू देऊ नये. ");
INSERT INTO mar_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","हंगामाच्या वेळी तुझ्या जमिनीच्या उत्पन्नातील प्रथम पिकाचा सर्वोत्तम भाग आपला देव परमेश्वर, ह्याच्या मंदिरात आणावा. करडू त्याच्या आईच्या दुधात शिजवू नये.” ");
INSERT INTO mar_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","मग परमेश्वर मोशेला म्हणाला, “ही वचने लिहून ठेव, कारण याच वचनांप्रमाणे मी तुझ्याशी व इस्राएल लोकांशी करार केला आहे.” ");
INSERT INTO mar_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मोशे तेथे परमेश्वराजवळ चाळीस दिवस व चाळीस रात्री राहिला; त्या दिवसात त्याने अन्न खाल्ले नाही, आणि तो पाणीही प्याला नाही; आणि त्या पाट्यांवर परमेश्वराने कराराची वचने म्हणजे दहा आज्ञा लिहून ठेवल्या. ");
INSERT INTO mar_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","मग मोशे, साक्षपटाच्या त्या दोन पाट्या घेऊन सीनाय पर्वतावरून खाली उतरला; परमेश्वराशी बोलल्यामुळे त्याच्या चेहऱ्यातून तेजाचे किरण निघत आहेत ह्याचे त्यास भान नव्हते. ");
INSERT INTO mar_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","अहरोन व सर्व इस्राएल लोक यांनी मोशेच्या चेहऱ्यावरील तेजस्वी किरणे पाहिली तेव्हा ते त्याच्याजवळ जायला घाबरले; ");
INSERT INTO mar_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","परंतु मोशेने अहरोन व मंडळीचे प्रमुख ह्याना बोलावले, तेव्हा अहरोन व मंडळीचे प्रमुख त्याच्याकडे परत आले, तो त्यांच्याशी बोलू लागला. ");
INSERT INTO mar_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","त्यानंतर सर्व इस्राएल लोक जवळ आले आणि जे काही परमेश्वराने त्यास सीनाय पर्वतावर सांगितले होते ते सगळे त्याने त्यांना आज्ञा देऊन सांगितले. ");
INSERT INTO mar_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","लोकांशी आपले बोलणे संपविल्यावर मोशेने आपला चेहरा आच्छादनाने झाकला. ");
INSERT INTO mar_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","जेव्हा कधीही मोशे परमेश्वराबरोबर बोलावयास त्याच्यासमोर आत जाई, तेव्हा तो बाहेर येईपर्यंत आपल्या चेहऱ्यावरील आच्छादन काढीत असे; मग तो इस्राएल लोकांकडे बाहेर येऊन परमेश्वर जी काही आज्ञा देई ती तो त्यांना सांगत असे. ");
INSERT INTO mar_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","मोशेचा तेजाने तळपणारा चेहरा इस्राएल लोक पाहत तेव्हा तो पुन्हा आपला चेहरा झाकून घेई; आणि तो परमेश्वराकडे बोलावयास आत जाईपर्यंत तो आपला चेहरा झाकून ठेवत असे. ");
INSERT INTO mar_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मोशेने सगळ्या इस्राएल लोकांच्या मंडळीला एकत्र केले; तो त्यांना म्हणाला, ज्या गोष्टी करण्याविषयी परमेश्वराने आज्ञा केली आहे त्या या; ");
INSERT INTO mar_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","सहा दिवस काम करावे, परंतु सातवा दिवस तुमच्यासाठी परमेश्वराचा पवित्र दिवस, परमविसाव्याचा शब्बाथ होय, त्या दिवशी काम करणाऱ्या कोणत्याही मनुष्यास अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","शब्बाथ दिवशी तुम्ही आपल्या राहत असलेल्या जागेत कोठेही विस्तव पेटवू नये. ");
INSERT INTO mar_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मोशे सर्व इस्राएल लोकांच्या मंडळीला म्हणाला, परमेश्वराने जे करण्याची आज्ञा दिली आहे ते हे; ");
INSERT INTO mar_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","परमेश्वरासाठी तुम्ही अर्पणे आणावी. ज्याची मनापासून इच्छा असेल त्याने परमेश्वराकरता सोने, चांदी, पितळ; ");
INSERT INTO mar_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","निळे, जांभळे व किरमिज रंगाचे सूत, व तलम सणाचे कापड, बकऱ्याचे केस; ");
INSERT INTO mar_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","लाल रंगवलेली मेंढ्याची कातडी व तहशाची कातडी, बाभळीचे लाकूड; ");
INSERT INTO mar_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","दिव्यासाठी तेल, अभिषेकाच्या तेलासाठी आणि सुगंधी धुपासाठी मसाले; ");
INSERT INTO mar_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","तसेच एफोद व ऊरपट ह्यात खोचण्यासाठी गोमेदमणी आणि इतर रत्ने आणावी. ");
INSERT INTO mar_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“तुमच्यापैकी जे कोणी कुशल कारागीर आहेत त्या सर्वांनी येऊन परमेश्वराने जे काही करण्याची आज्ञा दिली आहे ते सर्व करावे, म्हणजे ");
INSERT INTO mar_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","निवासमंडप, त्याचा बाहेरील तंबू व त्यावरील आच्छादान, त्याचे आकडे, फळ्या, अडसर, खांब, व उथळ्या; ");
INSERT INTO mar_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","कोश, त्याचे दांडे, दयासन व अंतरपाट, ");
INSERT INTO mar_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","मेज व त्याचे दांडे, त्यावरील सर्व पात्रे व समक्षतेची भाकर; ");
INSERT INTO mar_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","प्रकाशासाठी दीपवृक्ष, त्याची उपकरणे व दिवे, आणि दिव्यासाठी तेल; ");
INSERT INTO mar_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धूपवेदी व तिचे दांडे, अभिषेकासाठी तेल, सुगंधी द्रव्ययुक्त धूप, निवासमंडपाच्या दारासाठी पडदा; ");
INSERT INTO mar_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होमवेदी व तिची पितळेची जाळी, दांडे व तिचे इतर साहित्य, गंगाळ व त्याची बैठक; ");
INSERT INTO mar_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","अंगणाचे पडदे, त्यांचे खांब व त्यांच्या उथळ्या, आणि अंगणाच्या फाटकासाठी पडदा; ");
INSERT INTO mar_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","निवासमंडप व अंगण ह्याच्यासाठी मेखा व तणावे, ");
INSERT INTO mar_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्रस्थानात सेवा करण्यासाठी कुशलतेने विणलेली वस्रे आणि याजक या नात्याने सेवा करण्यासाठी अहरोन याजकाची व त्याच्या पुत्रांची पवित्र वस्रे.” ");
INSERT INTO mar_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","मग इस्राएल लोकांची सर्व मंडळी मोशेपुढून निघून गेली. ");
INSERT INTO mar_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","नंतर ज्यांच्या अंतःकरणांत स्फूर्ती झाली, त्या सर्वांनी दर्शनमंडपाच्या कामासाठी, त्यातील सगळ्या सेवेसाठी आणि पवित्र वस्रांसाठी परमेश्वरास अर्पणे आणली. ");
INSERT INTO mar_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ज्यांना मनापासून देण्याची इच्छा झाली त्या सगळ्या स्त्रीपुरुषांनी नथा, कुंडले, अंगठ्या, बांगड्या असे सर्व प्रकारचे सोन्याचे दागिने आणले; ही सोन्याची पवित्र अर्पणे परमेश्वरासाठी आणली. ");
INSERT INTO mar_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ज्या ज्या पुरुषांच्याकडे निळ्या, जांभळ्या व किरमिजी रंगाचे सूत व तलम सणाचे कापड, बकऱ्याचे केस, लाल रंगवलेली मेंढ्याची कातडी व तहशाची कातडी होती त्यांनी ते ते आणले. ");
INSERT INTO mar_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","चांदी व पितळ यांचे अर्पण करणाऱ्या प्रत्येकाने ती अर्पणे परमेश्वरासाठी आणली आणि ज्यांच्याकडे बाभळीचे लाकूड होते त्यांनी ते परमेश्वरास अर्पण केले. ");
INSERT INTO mar_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ज्या स्रिया शिवणकाम व विणकाम ह्यात तरबेज होत्या त्या सर्वांनी निळ्या, जांभळ्या व किरमिजी रंगाचे सूत व तलम सणाचे कापड आपल्या हातांनी विणून आणले. ");
INSERT INTO mar_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","आणि ज्या स्त्रियांच्या अंतःकरणात स्फूर्ती होऊन त्यांना बुध्दी झाली, त्या सर्वांनी बकऱ्याचे केस कातले. ");
INSERT INTO mar_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","अधिकाऱ्यांनी याजकाचे एफोद व ऊरपट ह्यात जडवण्यासाठी गोमेदमणी व इतर रत्ने आणली. ");
INSERT INTO mar_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","दिव्याचे तेल व अभिषेकाचे तेल व सुगंधी धुपासाठी मसाला आणला. ");
INSERT INTO mar_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","परमेश्वराने मोशेला जे करण्याची आज्ञा दिली होती त्या सर्वांसाठी इस्राएल लोकांनी स्वखुशीने परमेश्वरासाठी अर्पणे आणली, ज्या ज्या स्त्रीपुरुषांच्या अंतःकरणांत स्फूर्ती झाली त्यांनीही अर्पणे आणली. ");
INSERT INTO mar_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","तेव्हा मोशे इस्राएल लोकांस म्हणाला, पाहा, परमेश्वराने यहूदा वंशातील ऊरीचा पुत्र म्हणजे हूराचा नातू बसालेल ह्याला नाव घेऊन बोलावले आहे. ");
INSERT INTO mar_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","आणि त्याने त्यास देवाच्या आत्म्याने परिपूर्ण करून अक्कल, बुध्दी, ज्ञान आणि सर्व प्रकारचे कसब दिले आहे. ");
INSERT INTO mar_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","तो सोने, चांदी आणि पितळ ह्यांच्यापासून कलाकुसरीचे काम करील. ");
INSERT INTO mar_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","तो रत्नांना पैलू पाडील. लाकडाचे नक्षीकामही करून अशा सर्व प्रकारची कारागिरीची कामे करील. ");
INSERT INTO mar_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","परमेश्वराने त्यास आणि दान वंशातील अहिसामाखाचा पुत्र अहलियाब, ह्यांच्या ठायी शिक्षण देण्याचे सामर्थ्य ठेवले आहे. ");
INSERT INTO mar_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","कोरीव काम करणारे कुशल कारागीर, निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताच्या कापडावर व तलम सणाच्या कापडावर कशिदा काढणारे, विणकाम करणारे, सर्व प्रकारचे कसबी काम करणारे व कुशल कामाची योजना करणारे अशासारख्यांची सर्व कारागिरीची कामे करण्यासाठी त्याने या दोघांचे मन ज्ञानाने परिपूर्ण केले आहे. ");
INSERT INTO mar_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“परमेश्वराच्या आज्ञेप्रमाणे पवित्रस्थानाचे सेवेसाठी सर्व तऱ्हेचे काम कसे करावे ते समजण्यासाठी ज्यांच्या ठायी परमेश्वराने बुध्दी व समज घातली आहे ते बसालेल व अहलियाब आणि प्रत्येक ज्ञानी मनुष्य ह्यानी हे बांधकाम करावे.” ");
INSERT INTO mar_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","नंतर बसालेल व अहलियाब ह्यांना आणि ज्या ज्ञानी मनुष्यांच्या मनात परमेश्वराने बुध्दी घातली होती व ज्यांना हे कार्य करण्याची स्फूर्ती झाली होती, त्यांना मोशेने बोलावले. ");
INSERT INTO mar_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","आणि पवित्रस्थानाच्या सेवेसाठी म्हणजे ते बांधण्यासाठी इस्राएल लोकांनी जी एकंदर अर्पणे आणली होती ती त्यांनी मोशेच्या पुढून घेतली. लोकांनी रोज सकाळी आपली स्वखुशीची अर्पणे त्याच्यापाशी आणण्याचा क्रम चालू ठेवला. ");
INSERT INTO mar_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","शेवटी मग सर्व बुध्दिमान पुरुष पवित्रस्थानाचे करीत असलेले आपले काम सोडून मोशेकडे आले. ");
INSERT INTO mar_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","आणि ते मोशेला म्हणाले लोकांनी परमेश्वरासाठी खूप अर्पणे आणली आहेत! आम्हांला या पवित्रस्थानाचे बांधकाम पूर्ण करण्यासाठी लागणाऱ्या साहित्यापेक्षा कितीतरी अधिक आमच्यापाशी आले आहे! ");
INSERT INTO mar_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तेव्हा मोशेने सर्व छावणीभर असा हुकूम दिला की, “कोणाही स्त्रीने किंवा पुरुषाने आता पवित्रस्थानाच्या सेवेसाठी अर्पण म्हणून आणखी कोणतेही कसबाचे वगैरे काम करून आणू नये,” तेव्हा अशा रीतीने आणखी अर्पणे आणण्यास बंदी घालण्यात आली. ");
INSERT INTO mar_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","त्यांच्या हाती जी सामग्री जमली होती ती ते सर्व काम करण्यास पुरून उरेल इतकी होती. ");
INSERT INTO mar_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","मग त्या कसबी कारागिरांनी दहा पडद्यांचा निवासमंडप बनविला. त्यांनी कातलेल्या तलम सणाच्या कापडाचे आणि निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचे पडदे तयार केले व त्यांच्यावर त्यांनी कुशल कारागिराकडून करुब काढले. ");
INSERT INTO mar_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","प्रत्येक पडद्याचे मोजमाप अठ्ठावीस हात लांब व रुंदी चार हात असे सारखेच होते. ");
INSERT INTO mar_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","त्यांनी त्यापैकी पाच पडदे जोडून एक भाग व दुसरे पाच पडदे जोडून दुसरा भाग असे केले. ");
INSERT INTO mar_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","नंतर त्यांनी त्या दोन्हीही भागांच्या शेवटच्या किनारीवर निळ्या सुताची बिरडी केली; तसेच दुसऱ्या पडद्याच्या किनारीवरही तशीच बिरडी केली. ");
INSERT INTO mar_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","त्यांनी एका पडद्याखाली किनारीवर पन्नास बिरडी व दुसऱ्या पडद्याच्या किनारीवरही पन्नास बिरडी केली; ती बिरडी समोरासमोर होती. ");
INSERT INTO mar_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","नंतर ते दोन पडदे एकत्र जोडण्यासाठी त्यांनी सोन्याचे पन्नास गोल आकडे बनविले; त्या आकड्यांनी ते पडदे एकत्र जोडल्यावर त्या सर्वांचा मिळून अखंड पवित्र निवासमंडप तयार झाला. ");
INSERT INTO mar_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","नंतर पवित्र निवासमंडप झाकण्यासाठी त्या कारागिरांनी बकऱ्याच्या केसांच्या अकरा पडद्यांचा एक तंबू बनविला. ");
INSERT INTO mar_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","या सर्व पडद्यांचे मोजमाप सारखेच होते म्हणजे ते तीस हात लांब व चार हात रुंद होते. ");
INSERT INTO mar_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","त्या कारागिरांनी त्यांपैकी पाच पडदे जोडून एक भाग व दुसरे सहा पडदे जोडून दुसरा भाग तयार केला. ");
INSERT INTO mar_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","नंतर त्यांनी एका कनातीच्या बाहेरील शेवटच्या पडद्याच्या किनारीवर पन्नास बिरडी व तशीच दुसऱ्या कनातीच्या बाहेरील शेवटच्या पडद्याच्या किनारीवर पन्नास बिरडी केली. ");
INSERT INTO mar_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","हे दोन पडदे जोडून एक तंबू करण्यासाठी त्यांनी पितळेचे पन्नास आकडे केले. ");
INSERT INTO mar_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","मग त्यांनी पवित्र निवासमंडप झाकण्यासाठी लाल रंग दिलेल्या मेंढ्याच्या कातड्याचे व दुसरे तहशाच्या कमावलेल्या कातड्याचे अशी दोन आच्छादने केली. ");
INSERT INTO mar_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","पवित्र निवासमंडपाला आधार देण्यासाठी त्यांनी बाभळीच्या लाकडाच्या फळ्या तयार केल्या. ");
INSERT INTO mar_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","प्रत्येक फळी दहा हात लांब व दीड हात रुंद होती. ");
INSERT INTO mar_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","त्यांनी प्रत्येक फळी दुसऱ्या फळीशी जोडण्यासाठी त्यांनी तिला दोन कुसे केली. त्यांनी निवासमंडपाच्या सर्व फळ्या अशाच केल्या. ");
INSERT INTO mar_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","निवासमंडपासाठी ज्या फळ्या त्यांनी केल्या त्यांपैकी दक्षिण बाजूस लावण्यासाठी वीस फळ्या केल्या; ");
INSERT INTO mar_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","त्या वीस फळ्यांच्या खाली लावण्यासाठी त्यांनी चांदीच्या चाळीस उथळ्या केल्या, एका फळीच्या खाली कुसासाठी दोन दोन उथळ्या त्यांनी केल्या. ");
INSERT INTO mar_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","त्याचप्रमाणे निवासमंडपाच्या दुसऱ्या म्हणजे उत्तर बाजूस लावण्यासाठी त्यांनी वीस फळ्या केल्या. ");
INSERT INTO mar_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","त्यांनी त्याच्यासाठी चांदीच्या चाळीस उथळ्या केल्या म्हणजे एकेका फळीच्या खाली दोन दोन उथळ्या. ");
INSERT INTO mar_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","निवासमंडपाच्या मागील बाजूस म्हणजे पश्चिम बाजूस लावण्यासाठी सहा फळ्या केल्या, ");
INSERT INTO mar_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","आणि मागच्या बाजूस निवासमंडपाच्या कोपऱ्यासाठी दोन फळ्या त्यांनी केल्या. ");
INSERT INTO mar_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","या फळ्या खालपासून दोन दोन असून त्या दोन्ही वरच्या भागी एकेका कडीने त्यांनी जोडल्या होत्या; दोन्ही कोपऱ्यांसाठी त्यांनी अशाच फळ्या केल्या. ");
INSERT INTO mar_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","या प्रकारे आठ फळ्या व त्यांना चांदीच्या सोळा उथळ्या झाल्या. अर्थात एकेका फळीखाली दोन दोन उथळ्या होत्या. ");
INSERT INTO mar_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","त्यांनी बाभळीच्या लाकडाचे अडसर तयार केले. निवासमंडपाच्या एका बाजूच्या फळ्यांसाठी पाच, ");
INSERT INTO mar_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","दुसऱ्या बाजूच्या फळ्यांसाठी पाच आणि पश्चिमेच्या म्हणजे मागल्या बाजूसाठी पांच; ");
INSERT INTO mar_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","आणि त्यांनी फळ्याच्या मध्यभागी लावावयाचा अडसर एका टोकापासून दुसऱ्या टोकापर्यंत पोहचेल असा केला. ");
INSERT INTO mar_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","त्या फळ्या त्यांनी सोन्याने मढवल्या, अडसर लावण्याच्या कड्या सोन्याच्या बनवल्या आणि अडसरही सोन्याने मढवले. ");
INSERT INTO mar_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","मग त्यांनी निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा आणि तलम सणाच्या कापडाचा एक अंतरपट बनविला व त्यावर करुब काढले, ");
INSERT INTO mar_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","आणि त्यासाठी त्यांनी बाभळीच्या लाकडाचे चार खांब केले व ते सोन्याने मढवले; त्याच्या आकड्या सोन्याच्या केल्या आणि त्याच्यासाठी चांदीच्या चार उथळ्या ओतल्या. ");
INSERT INTO mar_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","मग त्यांनी निवासमंडपाच्या प्रवेशद्वारासाठी निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा व कातलेल्या तलम सणाच्या कापडाचा नक्षीदार पडदा बनवला. ");
INSERT INTO mar_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","व त्या पडद्यासाठी त्यांनी पाच खांब व त्यांच्या आकड्या बनवल्या; त्यांचा वरचा भाग व त्यांच्या बांधपट्ट्या सोन्याने मढविल्या; आणि खांबासाठी पितळेच्या पाच उथळ्या बनवल्या. ");
INSERT INTO mar_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बसालेलने बाभळीच्या लाकडाचा एक कोश बनवला; तो अडीच हात लांब, दीड हात रुंद व दीड हात उंच होता. ");
INSERT INTO mar_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","त्याने तो आतून बाहेरून शुद्ध सोन्याने मढवला आणि त्यासभोवती सोन्याचा कंगोरा केला. ");
INSERT INTO mar_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","त्याच्या चाऱ्ही पायांना लावण्यासाठी त्याने सोन्याच्या चार कड्या ओतून एका बाजूला दोन व दुसऱ्या बाजूला दोन अशा लावल्या. ");
INSERT INTO mar_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","त्याने बाभळीच्या लाकडाचे दांडे करून ते शुद्ध सोन्याने मढवले. ");
INSERT INTO mar_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","कोश उचलण्यासाठी ते दांडे त्याने त्याच्या दोन्ही बाजूंच्या कड्यांत घातले. ");
INSERT INTO mar_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","नंतर त्याने शुद्ध सोन्याचे दयासन बनविले; ते अडीच हात लांब व दीड हात रुंद होते. ");
INSERT INTO mar_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","बसालेलने सोने घडवून दोन करुब बनवले. ते दयासनाच्या दोन्ही टोकांसाठी बनवले. ");
INSERT INTO mar_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","त्याने एक करुब एका टोकासाठी व दुसरा करुब दुसऱ्या टोकासाठी बनवला. करुब व दयासन अखंड असून ते त्याने दोन्ही टोकांना बनवले. ");
INSERT INTO mar_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","त्या करुबांचे पंख वर असे पसरले होते की त्यांनी ते दयासन झाकले होते; त्यांची तोंडे समोरासमोर असून त्यांची दृष्टी दयासनाकडे लागलेली होती. ");
INSERT INTO mar_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","त्याने बाभळीच्या लाकडाचे मेज बनविले, ते दोन हात लांब, एक हात रुंद व दीड हात उंच होते. ");
INSERT INTO mar_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","त्याने ते शुद्ध सोन्याने मढवले व त्यासभोवती सोन्याचा कंगोरा केला; ");
INSERT INTO mar_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","आणि त्याने त्याच्यासाठी चार बोटे रुंदीची एक पाळ केली व त्या पाळीस सभोवती सोन्याचा कंगोरा केला. ");
INSERT INTO mar_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","त्याच्यासाठी सोन्याच्या चार गोल कड्या ओतून तयार केल्या व त्याच्या चाऱ्ही पायावरच्या चार कोपऱ्यांना त्या लावल्या. ");
INSERT INTO mar_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","या गोल कड्या त्या पाळीजवळ ठेवल्या, त्या मेज उचलावयाच्या दांड्यासाठी होत्या. ");
INSERT INTO mar_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","मेज उचलण्यासाठी त्याने बाभळीच्या लाकडाचे दांडे केले व ते सोन्याने मढवले; ");
INSERT INTO mar_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","नंतर त्याने मेजावरची पात्रे म्हणजे तबके, धूपपात्रे, सुरया व पेयार्पणे ओतण्यासाठी कटोरे ही सर्व शुद्ध सोन्याची बनवली. ");
INSERT INTO mar_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","त्याने शुद्ध सोन्याचा एक दीपवृक्ष बनविला; हा दीपवृक्ष, त्याची बैठक, त्याचा दांडा, त्याच्या वाट्या, त्याची बोंडे व त्याची फुले ही सर्व एकाच अखंड तुकड्याची घडवली. ");
INSERT INTO mar_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","या दीपवृक्षाला एका बाजूला तीन व दुसऱ्या बाजूला तीन अशा सहा शाखा होत्या. ");
INSERT INTO mar_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","प्रत्येक शाखेला बदामाच्या फुलासारख्या तीन तीन वाट्या, बोंडाफुलासह केल्या आणि दुसऱ्या बाजूच्या त्याच्या जोडीच्या प्रत्येक शाखेलाही बदामाच्या फुलांसारख्या तीन तीन वाट्या बोंडाफुलासारख्या केल्या. दीपवृक्षामधून निघालेल्या सहा शाखांची रचना अशीच होती. ");
INSERT INTO mar_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","दीपवृक्षाच्या दांड्याला बदामाच्या फुलांसारख्या बोडांफुलांसह चार वाट्या होत्या. ");
INSERT INTO mar_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","या दीपवृक्षामधून निघणाऱ्या सहा शाखांपैकी दोन दोन शाखा आणि त्यांच्याखाली असलेले प्रत्येकी एक बोंड ही एकाच अखंड तुकड्याची होती. ");
INSERT INTO mar_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","शाखा व फुले असलेला हा संपूर्ण दीपवृक्ष शुद्ध सोन्याच्या एकाच अखंड तुकड्यातून घडवलेला होता. ");
INSERT INTO mar_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","त्याने त्या दीपावृक्षाचे सात दिवे, त्याचे चिमटे व ताटल्या शुद्ध सोन्याच्या केल्या. ");
INSERT INTO mar_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","त्याने तो दीपवृक्ष व त्याचे बरोबरची सर्व उपकरणे एक किक्कार शुद्ध सोन्याची बनवली. ");
INSERT INTO mar_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","मग त्याने बाभळीच्या लाकडाची धूपवेदी केली; ती एक हात लांब, एक हात रुंद व दोन हात उंच अशी चौरस होती; तिची शिंगे अंगचीच होती. ");
INSERT INTO mar_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","त्याने त्या वेदीचा वरचा भाग, तिच्या चाऱ्ही बाजू व तिची शिंगे शुद्ध सोन्याने मढविली व तिला सभोवती सोन्याचा कंगोरा केला; ");
INSERT INTO mar_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","वेदी वाहून नेण्यासाठी दांडे घालण्याकरता त्याने सोन्याच्या दोन दोन गोल कड्या करून त्या कंगोऱ्यांच्या खाली तिच्या दोन्ही अंगांना लावल्या. ");
INSERT INTO mar_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","त्याने बाभळीच्या लाकडाचे दांडे केले व ते सोन्याने मढविले. ");
INSERT INTO mar_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","नंतर त्याने अभिषेकाचे पवित्र तेल आणि सुगंधी द्रव्ययुक्त शुद्ध धूप गांध्याच्या कृतीप्रमाणे केला. ");
INSERT INTO mar_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","बसालेलाने बाभळीच्या लाकडाची एक चौरस होमवेदी बनवली; ती पाच हात लांब व पाच हात रुंद व तीन हात उंच अशी केली. ");
INSERT INTO mar_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","त्याने तिच्या चाऱ्ही कोपऱ्यास चार शिंगे बनवली, ती अंगचीच होती, त्याने ती पितळेने मढविली. ");
INSERT INTO mar_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","त्याने वेदीची सर्व उपकरणे म्हणजे हंड्या, फावडी, कटोरे, काटे व अग्निपात्रे ही सर्व पितळेची बनवली. ");
INSERT INTO mar_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","त्याने वेदीला सभोवती कंगोऱ्याच्या खाली पितळेची जाळी बनवली, ती खालपासून वेदीच्या तळाच्या अर्ध्या अंतरापर्यंत वर आली. ");
INSERT INTO mar_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","त्याने पितळेच्या जाळीच्या चारही कोपऱ्यांना दांडे घालण्यासाठी चार कड्या ओतून तयार केल्या; ");
INSERT INTO mar_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","त्याने बाभळीच्या लाकडाचे दांडे केले व ते पितळेने मढवले. ");
INSERT INTO mar_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","वेदी उचलून नेण्याकरता तिच्या बाजूच्या कड्यांत त्याने दांडे घातले; वेदीच्या चारही बाजूंना फळ्या लावून ती मध्यभागी पोकळ ठेवली. ");
INSERT INTO mar_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","दर्शनमंडपाच्या दारापाशी सेवा करण्याऱ्या स्रियांनी अर्पण म्हणून आणलेल्या पितळी आरशांचे पितळ घेऊन त्याने गंगाळ व त्याची बैठक बनवली. ");
INSERT INTO mar_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","त्याने अंगण तयार केले; त्याच्या दक्षिण बाजूला कातलेल्या तलम सणाच्या कापडाच्या पडद्यांची लांबी शंभर हात होती. ");
INSERT INTO mar_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","तिला वीस खांब असून त्या खांबासाठी पितळेच्या वीस उथळ्या होत्या; खांबांच्या आकड्या व त्यांच्या बांधपट्ट्या चांदीच्या होत्या. ");
INSERT INTO mar_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","अंगणाच्या उत्तर बाजूलाही शंभर हात लांबीचे पडदे जोडून केलेली एक कनात होती व तिच्यासाठीही वीस पितळी उथळ्या असलेल्या वीस खांबावर ती आधारलेली होती; खांबांच्या आकड्या व त्यांच्या बांधपट्ट्या चांदीच्या होत्या. ");
INSERT INTO mar_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","अंगणाच्या पश्चिम बाजूला पडद्यांची पन्नास हात लांबीचे पडदे जोडून केलेली एक कनात होती; तिच्यासाठी दहा खांब व दहा उथळ्याही होत्या; या खांबांच्या आकड्या व त्यांच्या बांधपट्ट्या चांदीच्या होत्या; ");
INSERT INTO mar_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","पूर्वेकडील बाजू पन्नास हात लांब होती; ");
INSERT INTO mar_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","अंगणाच्या फाटकाच्या एका बाजूला पंधरा हात लांबीचे पडदे जोडून केलेली कनात होती; तिच्यासाठी तीन खांब व तीन उथळ्या होत्या; ");
INSERT INTO mar_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","आणि अंगणाच्या फाटकाची दुसरी बाजूही अगदी तशीच होती. अंगणाच्या फाटकाच्या या बाजूला व त्या बाजूला पंधरा पंधरा हात पडदे जोडून केलेल्या कनाती होत्या, त्यांना तीन तीन खांब व त्यांच्या उथळ्याही तीन तीन होत्या. ");
INSERT INTO mar_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","अंगणाच्या सभोवतालचे सर्व पडदे कातलेल्या तलम सणाच्या कापडाचे होते. ");
INSERT INTO mar_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","खांबांच्या उथळ्या पितळेच्या आणि आकड्या व बांधपट्ट्या चांदीच्या होत्या; खांबांची वरची टोके चांदीने मढवली होती; अंगणाचे सर्व खांब चांदीच्या बांधपट्ट्यांनी जोडले होते. ");
INSERT INTO mar_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","अंगणाच्या फाटकाचा पडदा निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा आणि कातलेल्या तलम सणाच्या कापडाचा होता; त्यावर वेलबुट्टीदार विणकाम केलेले होते; तो वीस हात लांब व पाच हात उंच होता; ही उंची अंगणाच्या पडद्या इतकी पाच हात असावी. ");
INSERT INTO mar_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","तो पडदा पितळेच्या चार उथळ्या आणि चार खांबावर आधारलेला होता; खांबांवरील आकड्या व बांधपट्ट्या चांदीच्या बनवलेल्या होत्या; खांबांची वरची टोके चांदीने मढवली होती. ");
INSERT INTO mar_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","निवासमंडपाच्या आणि अंगणाच्या सभोवती असलेल्या सर्व मेखा पितळेच्या होत्या. ");
INSERT INTO mar_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","निवासमंडपाचे म्हणजे साक्षपटाच्या निवासमंडपाच्या ज्या वस्तू लेव्यांच्या सेवेकरीता केले त्याची यादी मोशेच्या सांगण्यावरून अहरोन याजकाचा पुत्र इथामार ह्याने केली ती ही; ");
INSERT INTO mar_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ज्या ज्या वस्तू करण्याविषयी परमेश्वराने मोशेला आज्ञा दिली होती त्या सर्व वस्तू यहूदा वंशातील हुराचा नातू म्हणजे ऊरीचा पुत्र बसालेल याने बनवल्या; ");
INSERT INTO mar_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","तसेच त्यास मदतनीस म्हणून दान वंशातील अहिसामाखाचा पुत्र अहलियाब हा होता; तो सर्व प्रकारचे कोरीव काम करणारा कुशल कारागीर होता; तो विणकाम व निळ्या, जांभळ्या व किरमिजी रंगाच्या तलम कापडावर कशिदा काढणारा होता. ");
INSERT INTO mar_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्रस्थानाच्या सर्व कामाकरता अर्पण केलेले सोने सुमारे एकोणतीस किक्कार होते आणि पवित्रस्थानातील शेकेलाच्या चलनाप्रमाणे सातशे तीस शेकेल होते. ");
INSERT INTO mar_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","मंडळीपैकी ज्यांची नोंद करण्यात आली त्या एकूण लोकांनी अर्पण केलेली चांदी शंभर किक्कार भरली आणि पवित्रस्थानातील शेकेलाच्या चलनाप्रमाणे सतराशे पंचाहत्तर शेकेल भरली. ");
INSERT INTO mar_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","वीस वर्षे व त्याहून अधिक वयाच्या पुरुषांची गणती केली तेव्हा ते सहा लाख, तीन हजार, पाचशे पन्नास भरले आणि पवित्रस्थानातील शेकेलाच्या चलनाप्रमाणे प्रत्येका मनुष्यामागे एक बेका चांदी म्हणजे अर्धा शेकेल मिळाला. ");
INSERT INTO mar_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","त्यांनी ती शंभर किक्कार चांदी पवित्रस्थानातील उथळ्या व अंतरपटाच्या उथळ्या करण्यासाठी वापरली; त्यांनी प्रत्येक उथळीसाठी प्रत्येकी एक किक्कार अशा शंभर किक्काराच्या शंभर उथळ्या बनविल्या. ");
INSERT INTO mar_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","बाकीची सतराशे पंचाहत्तर शेकेल चांदी आकड्या, बांधपट्ट्या आणि खांबांना मढविण्यासाठी लागली. ");
INSERT INTO mar_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","सत्तर किक्कार व दोन हजार चारशे शेकेल अधिक पितळ अर्पण करण्यात आले होते. ");
INSERT INTO mar_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","त्या पितळेच्या दर्शनमंडपाच्या प्रवेश दाराजवळील उथळ्या, वेदीची उपकरणे व तिची जाळी ह्यांकरता; ");
INSERT INTO mar_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","त्याचप्रमाणे अंगणाच्या कनातीच्या खांबांच्या उथळ्या, प्रवेशद्वारावरील पडद्यांच्या खांबांच्या उथळ्या, तसेच पवित्र निवासमंडप अंगणाच्या चारही बाजूस लागणाऱ्या मेखा बनविण्यासाठी उपयोग झाला. ");
INSERT INTO mar_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे पवित्रस्थानातील सेवेसाठी निळ्या, जांभळ्या व किरमिजी रंगाची सुताची कुशलतेने विणलेली वस्रे केली; अहरोनासाठीही पवित्र वस्रे बनवली. ");
INSERT INTO mar_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","त्यांनी सोन्याच्या जरीचे आणि निळ्या, जांभळ्या, किरमिजी रंगाच्या सुताचे व कातलेल्या तलम सणाच्या कापडाचे एफोद तयार केले. ");
INSERT INTO mar_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","त्यांनी सोने ठोकून त्याचे पातळ पत्रे केले व ते पत्रे कापून त्याची तार केली आणि ती कुशल कारागिराकडून निळ्या, जांभळ्या व किरमिजी रंगाच्या सुतामध्ये व कातलेल्या तलम सणाच्या कापडामध्ये भरली. ");
INSERT INTO mar_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","त्यांनी एफोदसाठी खांदपट्ट्या केल्या व त्या एफोदाच्या दोन्ही टोकांना जोडल्या. ");
INSERT INTO mar_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","एफोद बांधण्यासाठी त्याच्यावर जी कुशलतेने विणलेली पट्टी असते तिची बनावट त्याच्यासारखीच असून ती अखंड तुकड्याची केली. ती सोन्याच्या जरीची, निळ्या, जांभळ्या, किरमिजी रंगाच्या सुताची व कातलेल्या तलम सणाच्या कापडाची केली. परमेश्वराने मोशेला सांगितल्याप्रमाणे हे केले. ");
INSERT INTO mar_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","मुद्रेवर छाप कोरतात तशी त्यांनी इस्राएलाच्या मुलांची नावे गोमेद रत्नावर कोरली व ती रत्ने सोन्याच्या कोंदणात बसवली. ");
INSERT INTO mar_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","इस्राएल लोकांची स्मारकरत्ने व्हावी म्हणून ती एफोदाच्या खांदपट्ट्यांवर लावली; परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे हे केले. ");
INSERT INTO mar_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","त्यांने कुशल कारागिराकडून एफोदप्रमाणेच सोन्याच्या जरीचा, निळ्या, जांभळ्या व किरमिजी रंगाच्या सुताचा व कातलेल्या तलम सणाच्या कापडाचा ऊरपट बनवून घेलता. ");
INSERT INTO mar_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","तो ऊरपट चौरस होता. त्यांनी तो दुहेरी केला; तो दुहेरी असून तो एक वीत लांब व एक वीत रुंद असा चौरस होता. ");
INSERT INTO mar_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","त्यामध्ये रत्नांच्या चार रांगा बसविल्या; पहिल्या रांगेत लाल, पुष्कराज व माणिक; ");
INSERT INTO mar_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दुसऱ्या रांगेत पाचू इंद्रनीलमणी व हिरा; ");
INSERT INTO mar_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तिसऱ्या रांगेत तृणमणी, सूर्यकांत व पद्मराग; ");
INSERT INTO mar_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","आणि चौथ्या रांगेत लसणा, गोमेद व यास्फे, ही सर्व रत्ने सोन्याच्या जाळीदार कोंदणात बसविली. ");
INSERT INTO mar_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","इस्राएलाच्या पुत्रांसाठी एक याप्रमाणे ती बारा रत्ने ऊरपटावर होती. त्यांच्या बारा वंशांच्या संख्येइतकी बारा नावे होती. एकेका रत्नावर एकेका मुलाचे नाव मुद्रा कोरतात त्याप्रमाणे त्यांनी कोरले होते. ");
INSERT INTO mar_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","दोरीसारखा पीळ घातलेल्या शुद्ध सोन्याच्या साखळ्या त्यांनी ऊरपटावर लावल्या. ");
INSERT INTO mar_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","सोन्याची दोन जाळीदार कोंदणे व सोन्याच्या दोन कड्या बनवून त्या ऊरपटाच्या दोन्ही टोकास लावल्या. ");
INSERT INTO mar_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ऊरपटाच्या टोकास लावलेल्या दोन्ही कड्यांत पीळ घातलेल्या सोन्याच्या साखळ्या घातल्या. ");
INSERT INTO mar_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","पीळ घातलेल्या दोन्ही साखळ्यांची दुसरी दोन टोके सोन्याच्या कोंदणात खोचून त्या त्यांनी एफोदाच्या दोन्ही खांदपट्ट्यांवर समोरच्या बाजूला लावल्या. ");
INSERT INTO mar_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","सोन्याच्या आणखी दोन कड्या करून त्या ऊरपटाच्या दोन्ही टोकांवर एफोदाच्या आतील बाजूच्या कडेला एफोदाजवळ लावल्या. ");
INSERT INTO mar_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","सोन्याच्या आणखी दोन कड्या करून एफोदाच्या दोन्ही खांदपट्ट्यांवर खालून त्याच्यासमोर त्याच्या सांध्याजवळ कुशलतेने विणलेल्या पट्टीवर लावल्या. ");
INSERT INTO mar_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","त्यांनी त्या ऊरपटाच्या कड्या एफोदाच्या कड्यांनी निळ्या, फितीने अशा बांधल्या की ऊरपट एफोदाच्या पट्ट्यांवर राहावा व तो ऊरपट एफोदावरून घसरू नये. परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे त्यांनी हे सर्व केले. ");
INSERT INTO mar_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","नंतर बसालेलने एफोदाबरोबर घालावयचा निळ्या रंगाच्या सुताचा झगा विणून घेतला. ");
INSERT INTO mar_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","त्यांनी झग्याच्या मध्यभागी एक भोक ठेवले व त्या दरम्यान झगा फाटू नये म्हणून त्या भोकाच्या किनारीला सभोवती कापडाचा गोट शिवला. ");
INSERT INTO mar_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","मग त्यांनी त्या झग्याच्या खालच्या घेराभोवती कातलेल्या तलम सणाच्या कापडाची व निळ्या, जांभळ्या व किरमिजी रंगाच्या कापडाची डाळिंबे काढली. ");
INSERT INTO mar_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","नंतर त्यांनी शुद्ध सोन्याची घुंगरे केली व ती झग्याच्या खालच्या घेराभोवती दोन दोन डाळिंबाच्यामध्ये लावली. म्हणजे झग्याच्या खालच्या घेराभोवती घुंगरु मग डाळिंब, पुन्हा घुंगरू मग डाळिंब याप्रमाणे दोन डाळिंबामध्ये एक घुंगरु अशी ती झाली; ");
INSERT INTO mar_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","सेवा करते वेळी अंगी घालायच्या झगाच्या घेराच्या काठावर सभोवती एक घुंगरू व एक डाळिंब व एक घुंगरू व एक डाळिंब असे लावले; परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे तसेच त्यांनी हे केले. ");
INSERT INTO mar_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","अहरोन व त्याच्या मुलांसाठी तलम सणाच्या विणलेल्या कापडाचे अंगरखे केले. ");
INSERT INTO mar_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","आणि त्यांनी तलम सणाचे मंदिल, फेटे व कातलेल्या सणाचे चोळणे केले. ");
INSERT INTO mar_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","मग त्यांनी तलम सणाच्या कापडाचा व निळ्या जांभळ्या व किरमिजी रंगाचा वेलबुट्टीदार कमरपट्टा बनविला; परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे हे केले. ");
INSERT INTO mar_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","मग त्यांनी पवित्र मुकुटासाठी शुद्ध सोन्याची पट्टी केली व तिच्यावर “परमेश्वरासाठी पवित्र” अशी अक्षरे कोरली. ");
INSERT INTO mar_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ती मंदिलाभोवती समोर बांधता यावी म्हणून तिला निळी फीत लावली. परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे हे केले. ");
INSERT INTO mar_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","अशा प्रकारे पवित्र निवासमंडपाचे म्हणजे दर्शनमंडपाचे सर्व काम पूर्ण झाले. परमेश्वराने मोशेला आज्ञा दिली होती अगदी त्याप्रमाणे इस्राएल लोकांनी सर्वकाही केले. ");
INSERT INTO mar_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","मग त्यांनी तो निवासमंडप मोशेकडे आणला. तंबू व तंबूच्या सर्व वस्तू म्हणजे आकड्या, फळ्या, अडसर, खांब, खांबाच्या उथळ्या; ");
INSERT INTO mar_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","आणि लाल रंगवलेली मंडप झाकण्याची मेंढ्यांची कातडी व तहशांची कातडी व अंतरपट; ");
INSERT INTO mar_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","साक्षपटाचा कोश, तो वाहून नेण्याचे दांडे आणि दयासन ");
INSERT INTO mar_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","मेज, त्यावरील सर्व वस्तू व पवित्र समक्षतेची भाकर; ");
INSERT INTO mar_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","शुद्ध सोन्याचा दीपवृक्ष, त्यावरील दिवे व त्याची सर्व उपकरणे व दिव्यासाठी तेल; ");
INSERT INTO mar_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सोन्याची वेदी, अभिषेकाचे तेल, सुगंधी धूप आणि तंबूच्या दारासाठी पडदा; ");
INSERT INTO mar_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","पितळेची वेदी व तिची पितळेची जाळी, वेदी वाहून नेण्याचे दांडे व तिची सर्व पात्रे, गंगाळ व त्याची बैठक: ");
INSERT INTO mar_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","अंगणाचे पडदे व कनाती, खांब व त्याच्या उथळ्या, अंगणाच्या प्रवेशदाराचा पडदा, तणावे, मेखा व पवित्र निवासमंडपाच्या व दर्शनमंडपाच्या सेवेसाठी लागणारे सर्व साहित्य; ");
INSERT INTO mar_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","पवित्रस्थानात सेवा करण्यासाठी कुशलतेने विणलेली वस्रे, अहरोन याजकाची पवित्र वस्रे आणि याजक या नात्याने सेवा करण्यासाठी त्याच्या पुत्रांची वस्रे ही सर्व त्यांनी आणली; ");
INSERT INTO mar_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","परमेश्वराने मोशेला आज्ञा दिली होती अगदी त्याप्रमाणे इस्राएल लोकांनी सगळे काम केले. ");
INSERT INTO mar_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","लोकांनी काम केले ते सर्व मोशेने बारकाईने पाहिले; ते त्यांनी अगदी परमेश्वराच्या आज्ञेप्रमाणे केले होते म्हणून मोशेने त्यांना आशीर्वाद दिला. ");
INSERT INTO mar_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","मग परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पहिल्या महिन्याच्या पहिल्या दिवशी दर्शनमंडपाचा निवासमंडप उभा कर. ");
INSERT INTO mar_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","साक्षपटाचा कोश त्यामध्ये ठेव व तू अंतरपटाने कोशाला पडदा घाल. ");
INSERT INTO mar_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","मग मेज आत आणून त्याच्यावरील सामान व्यवस्थित ठेव; नंतर दीपवृक्ष आत नेऊन त्याचे दिवे लाव. ");
INSERT INTO mar_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","साक्षपटाच्या कोशापुढे सोन्याची धूपवेदी ठेव आणि निवासमंडपाच्या दाराचा पडदा लाव. ");
INSERT INTO mar_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","दर्शनमंडपाच्या निवासमंडपाच्या दारापुढे होमवेदी ठेव. ");
INSERT INTO mar_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","दर्शनमंडप व वेदी यांच्यामध्ये गंगाळ ठेव व त्यामध्ये पाणी भर. ");
INSERT INTO mar_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","सभोवती अंगण कर व मग त्याच्या प्रवेशदारापाशी पडदा लाव. ");
INSERT INTO mar_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","अभिषेकाचे तेल घेऊन निवासमंडपाला व त्यातल्या सर्व वस्तूंना अभिषेक कर व त्याच्या सर्व वस्तू पवित्र कर म्हणजे तो पवित्र होईल. ");
INSERT INTO mar_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","होमवेदी व तिची सर्व उपकरणे यांना अभिषेक करून पवित्र कर म्हणजे ती परमपवित्र होईल. ");
INSERT INTO mar_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","गंगाळ व त्याच्या खालची बैठक ह्यास अभिषेक कर व त्यांना पवित्र कर. ");
INSERT INTO mar_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","अहरोन व त्याचे पुत्र ह्याना दर्शनमंडपाच्या दारापाशी नेऊन त्यांना आंघोळ घाल. ");
INSERT INTO mar_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","अहरोनाला पवित्र वस्रे घाल व त्यास तेलाने अभिषेक करून पवित्र कर, मग तो याजक या नात्याने माझी सेवा करील. ");
INSERT INTO mar_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","त्याच्या पुत्रांनाजवळ बोलावून अंगरखे घाल. ");
INSERT INTO mar_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","त्यांच्या पित्याला जसा अभिषेक करशील त्याप्रमाणेच त्यांना कर म्हणजे याजक या नात्याने ते माझी सेवा करतील; हा त्यांचा अभिषेक त्यांच्यासाठी पिढ्यानपिढ्या निरंतरच्या याजकपदाचा दर्शक होईल.” ");
INSERT INTO mar_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मोशेने परमेश्वराने आज्ञा दिल्याप्रमाणे सर्वकाही तसे केले. ");
INSERT INTO mar_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","दुसऱ्या वर्षातील पहिल्या महिन्याच्या पहिल्या दिवशी पवित्र निवासमंडपाची उभारणी झाली. ");
INSERT INTO mar_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","परमेश्वराने सांगितल्याप्रमाणे मोशेने पवित्र निवासमंडप उभा केला; प्रथम त्याने उथळ्या बसवून घेतल्या, मग त्याने त्यांच्यावर फळ्या लावल्या. अडसर लावले व त्यांचे खांब उभे केले; ");
INSERT INTO mar_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","त्यानंतर निवासमंडपावरचा तंबू केला, मग वरच्या तंबूवर त्याने आच्छादन घातले; परमेश्वराने आज्ञा केल्याप्रमाणे मोशेने हे सर्व केले. ");
INSERT INTO mar_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","मोशेने साक्षपट घेऊन कोशात ठेवला व कोशाला दांडे लावून त्याच्यावर दयासन ठेवले. ");
INSERT INTO mar_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","त्याने तो कोश निवासमंडपात आणला आणि योग्य ठिकाणी अंतरपट लावून साक्षपटाचा कोश झाकला; परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे त्याने हे केले. ");
INSERT INTO mar_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","मोशेने पवित्र निवासमंडपाच्या उत्तर बाजूला दर्शनमंडपामध्ये पडद्याच्या बाहेर मेज ठेवले; ");
INSERT INTO mar_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","त्याने त्याच्यावर परमेश्वरासमोर समर्पित भाकर ठेवली; परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे त्याने हे केले. ");
INSERT INTO mar_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","त्याने पवित्र निवासमंडपाच्या दक्षिण बाजूस दर्शनमंडपामध्ये मेजासमोर दीपवृक्ष ठेवला. ");
INSERT INTO mar_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","नंतर त्याने परमेश्वरासमोर दीपवृक्षावर दिवे लावले; परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे त्याने हे केले. ");
INSERT INTO mar_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","त्याने दर्शनमंडपामध्ये अंतरपटासमोर सोन्याची वेदी ठेवली. ");
INSERT INTO mar_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","नंतर त्याने तिच्यावर सुगंधी धूप जाळला; परमेश्वराने मोशेला आज्ञा केल्याप्रमाणे हे झाले. ");
INSERT INTO mar_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","त्याने पवित्र निवासमंडपाच्या दाराला पडदा लावला. ");
INSERT INTO mar_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","त्याने पवित्र निवासमंडपाच्या दर्शनमंडपाच्या दारापाशी होमवेदी ठेवली व तिच्यावर होमार्पणे व अन्नार्पणे अर्पण केली; परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे त्याने हे केले. ");
INSERT INTO mar_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","त्याने दर्शनमंडप आणि वेदी यांच्यामध्ये गंगाळ ठेवले व धुण्यासाठी त्यामध्ये पाणी भरले. ");
INSERT INTO mar_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","मोशे, अहरोन व अहरोनाचे पुत्र त्यामध्ये आपआपले हातपाय धूत असत; ");
INSERT INTO mar_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ते दर्शनमंडप व वेदीपाशी जाताना प्रत्येक वेळेस आपले हातपाय तेथे धूत असत; परमेश्वराने मोशेला आज्ञा केल्याप्रमाणे त्यांनी हे केले. ");
INSERT INTO mar_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","त्याने निवास मंडपाभोवती अंगणाची कनात उभी केली व अंगणात वेदी बसवली आणि अंगणाच्या फाटकाला पडदा लावला; या प्रकारे परमेश्वराने सांगितल्याप्रमाणे मोशेने सर्व काम संपविले. ");
INSERT INTO mar_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","दर्शनमंडपावर मेघाने छाया केली व पवित्र निवासमंडप परमेश्वराच्या तेजाने भरून गेला. ");
INSERT INTO mar_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","दर्शनमंडपावर मेघ राहिला व परमेश्वराच्या तेजाने निवासमंडप भरून गेला म्हणून मोशेला आत जाता येईना. ");
INSERT INTO mar_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","पवित्र निवास मंडपावरील मेघ वर जाई तेव्हा इस्राएल लोक आपला पुढील प्रवास सुरू करीत; ");
INSERT INTO mar_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","परंतु तो मेघ निवासमंडपावर असेपर्यंत लोक तेथून हलत नसत; तो वर जाईपर्यंत ते तेथेच थांबत. ");
INSERT INTO mar_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","परमेश्वराचा मेघ दिवसा निवासमंडपावर राही आणि रात्री त्यामध्ये अग्नी असे त्यामुळे सर्व इस्राएल लोकांस आपल्या प्रवासात तो दिसत असे.");
INSERT INTO mar_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","परमेश्वराने दर्शनमंडपातून मोशेला हाक मारली आणि त्यास म्हटले, ");
INSERT INTO mar_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","इस्राएली लोकांस असे सांग की, जेव्हा तुम्ही परमेश्वरास पशूबली अर्पण करता तेव्हा त्यांनी तो गुराढोरांपैकी किंवा शेरडामेढरांपैकी अर्पावा. ");
INSERT INTO mar_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","जेव्हा एखाद्या मनुष्यास गुरांढोरातले होमार्पण अर्पावयाचे असेल तेव्हा त्याने दोषहीन नर अर्पावा; तो त्याने दर्शनमंडपाच्या दारापाशी आणून अर्पावा म्हणजे परमेश्वरासमोर तो मान्य होईल. ");
INSERT INTO mar_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","त्या मनुष्याने यज्ञपशूच्या डोक्यावर आपला हात ठेवावा म्हणजे तो पशू त्याच्याबद्दल प्रायश्चित्त म्हणून मान्य होईल. ");
INSERT INTO mar_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","त्यानंतर त्याने परमेश्वरासमोर तो गोऱ्हा वधावा. दर्शनमंडपाच्या दाराशी परमेश्वरासमोर अर्पण करून अहरोनाचे पुत्र, जे याजक, त्यांनी त्याचे रक्त सादर करावे आणि दर्शनमंडपाच्या प्रवेशद्वारासमोरील वेदीवर सभोवती शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","याजकाने त्या यज्ञपशूचे कातडे काढावे व त्याचे तुकडे करावे. ");
INSERT INTO mar_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","नंतर अहरोन याजकाच्या मुलांनी वेदीवर विस्तव ठेवावा व नंतर त्याच्यावर लाकडे रचावी; ");
INSERT INTO mar_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","अहरोनाचे मुले जे याजक होते, त्यांनी वेदीवरच्या विस्तवावरील लाकडावर त्याचे तुकडे, डोके, व चरबी रचावी; ");
INSERT INTO mar_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","त्याचे पाय व आतडी ही पाण्याने धुवावी, मग याजकाने त्या सर्वांचा वेदीवर होम करून तो अर्पावा, हे होमार्पण आहे; हे परमेश्वरासाठी सुवासिक हव्य होय हे अग्नीद्वारे केलेले अर्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","जर कोणाला शेरडाचे किंवा मेंढराचे होमार्पण करावयाचे असल्यास त्याने दोषहीन नर अर्पावा. ");
INSERT INTO mar_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","त्याने वेदीच्या उत्तरेस परमेश्वरासमोर तो वधावा; मग अहरोनाचे पुत्र जे याजक आहेत त्यांनी त्याचे रक्त वेदीवर व वेदीच्या सभोवती शिंपाडावे. ");
INSERT INTO mar_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","मग याजकाने त्या पशूचे कापून तुकडे करावेत व त्याने ते तुकडे, डोके, व चरबी वेदीवरील विस्तवाच्या लाकडावर रचावी, ");
INSERT INTO mar_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","त्याचे पाय व आतडी पाण्याने धुवावी; मग याजकाने त्या सर्व भागांचा वेदीवर होम करावा; हे होमार्पण परमेश्वरासाठी सुवासिक हव्य होय. ");
INSERT INTO mar_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","जर कोणाला परमेश्वरासाठी पक्षाचे होमार्पण करावयाचे असेल तेव्हा त्याने त्याचे अर्पण होले किंवा पारव्याची पिल्ले अर्पावी. ");
INSERT INTO mar_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","याजकाने तो पक्षी वेदीजवळ आणावा, त्याचे मुंडके मुरगळून उपटून काढावे व वेदीवर त्याचा होम करावा आणि त्याचे रक्त वेदीच्या बाजूवर निचरून टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","त्याने त्याचा चुनाळ व पिसे काढून वेदीच्या पूर्वेस वेदीवरील राख टाकण्याच्या जागी फेकून द्यावी. ");
INSERT INTO mar_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","त्याने तो पक्षी पंखाच्या मधोमध फाडावा, परंतू त्याचे दोन वेगळे भाग करू नयेत; मग याजकाने त्या पक्षाचा वेदीवरील जळत्या लाकडावर होम करावा; हे पण होमार्पण आहे. हे परमेश्वरासाठी केलेले सुवासिक हव्य होय हे अग्नीद्वारे केलेले होमार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","जेव्हा कोणी परमेश्वरासमोर अन्नार्पण घेऊन येईल, तेव्हा त्याने अर्पणासाठी सपीठ आणावे; त्याने त्यामध्ये तेल ओतावे व त्यावर धूप ठेवावा; ");
INSERT INTO mar_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","मग त्याने ते अर्पण अहरोनाच्या याजक मुलांकडे आणावे; त्यांनी त्यातून मूठभर सपीठ, तेल व सगळा धूप घेऊन परमेश्वराच्या चांगुलपणाबद्दल स्मरणाचा भाग म्हणून वेदीवर त्याचा होम करावा. हे परमेश्वरासाठी सुवासिक हव्य होय. हे अग्नीद्वारे केलेले होमार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","अन्नार्पणातून जे काही उरेल ते अहरोनाचे व त्याच्या मुलांचे होईल. परमेश्वरासाठी केलेले हे अर्पण परमपवित्र अग्नीद्वारे केलेले होमार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","जेव्हा भट्टीत भाजलेले अन्नार्पण करावयाचे असेल, तर ते तेलात मळलेल्या सपिठाच्या बेखमीर भाकरीचे किंवा वरून तेल ओतलेल्या बेखमीर चपात्याचे असले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","जर तुला तव्यावर भाजलेल्या भाकरीचे अन्नार्पण करावयाचे असेल तर ते तेलात मळलेल्या बेखमीर सपिठाचे असावे. ");
INSERT INTO mar_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","त्याचे तू तुकडे करून त्याच्यावर तेल ओतावे; हे अन्नार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","कढईत तळलेल्यातले अन्नार्पण असेल तर ते तेलात मळलेल्या उत्तम सपिठाचे असावे. ");
INSERT INTO mar_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","अशाप्रकारचे अन्नार्पण तू परमेश्वरासमोर आणावेच; व ते याजकाकडे द्यावे व त्याने ते वेदीवर अर्पावे. ");
INSERT INTO mar_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","मग याजकाने अन्नार्पणातून काही भाग घेऊन परमेश्वराच्या महान चांगुलपणाबद्दल वेदीवर त्याचा होम करावा. हे अग्नीद्वारे केलेले होमार्पण होय आणि ते परमेश्वरासाठी सुवासीक हव्य होय. ");
INSERT INTO mar_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अन्नार्पणातून जे काही उरेल ते अहरोन व त्याच्या मुलांचे असेल; अग्नीद्वारे परमेश्वरास केलेले हे अर्पण परमेश्वरास परमपवित्र आहे. ");
INSERT INTO mar_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","खमीर असलेले कोणतेही अर्पण परमेश्वरास अर्पू नये कारण होमाग्नीमध्ये खमीर किंवा मध हे परमेश्वरास अर्पण म्हणून अर्पावयाचे नाही. ");
INSERT INTO mar_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","प्रथम उत्पन्न म्हणून त्यांचे अर्पण परमेश्वरास करावे; पण ते सुवासिक हव्य म्हणून वेदीवर ठेवू नये. ");
INSERT INTO mar_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","तू करशील ते प्रत्येक अन्नार्पण मिठाने रुचकर कर; तू आपल्या देवाशी केलेल्या कराराचे मीठ आपल्या अन्नार्पणात घालावयास चुकू नको; तुझ्या सर्व अर्पणाबरोबर मीठ पण अर्पावे. ");
INSERT INTO mar_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","जर परमेश्वराकरीता तुला अन्नार्पण म्हणून पहिल्या हंगामाचा उपज अर्पावयाचा असेल तर विस्तवावर भाजलेल्या हिरव्या कणसातले चोळून काढलेले ताजे दाणे आण; हे हंगामातील तुझ्या प्रथम पिकाचे अन्नार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","त्यावर तेल ओत आणि धूप ठेव; हे अन्नार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","चोळून काढलेले दाणे व तेल ह्यापैकी काही व सर्व धूप ह्यांचा याजकाने स्मारकभाग म्हणून होम जाळावा; हे परमेश्वरासाठी अग्नीद्वारे केलेले अर्पण आहे. ");
INSERT INTO mar_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","जर कोणाला शांत्यर्पणाचा यज्ञ करावयाचा असेल तर त्याने गुरांढोरापैकी दोष नसलेला नर किंवा मादी परमेश्वरासमोर अर्पावा. ");
INSERT INTO mar_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","त्याने त्याच्या अर्पणाच्या पशूच्या डोक्यावर आपला हात ठेवावा व दर्शनमंडपाच्या दारापाशी त्याचा वध करावा; मग अहरोनाचे पुत्र जे याजक आहेत त्यांनी त्याचे रक्त वेदीवर व सभोवती शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","परमेश्वरास शांत्यर्पण हे अग्नीद्वारे केलेले अर्पण होय. याजकाने पशूच्या आंतड्यावरील चरबी व त्यास लागून असलेली सर्व चरबी, ");
INSERT INTO mar_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","दोन्ही गुरदे, त्यांच्यावरची कमरेजवळची चरबी, आणि काळजाच्या पडद्यावरील चरबी हे सर्व काढावे ");
INSERT INTO mar_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","व या सर्वांचा अहरोनाच्या मुलांनी वेदीवरील विस्तवावर रचलेल्या लाकडावरील होमार्पणावर त्याचा होम करावा; हे परमेश्वरासाठी केलेले सुवासीक हव्य होय हे अग्नीद्वारे केलेले अर्पण आहे. ");
INSERT INTO mar_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","परमेश्वराकरिता कोणाला शांत्यर्पणासाठी शेरडांमेढरांचे अर्पण आणावयाचे असेल तर ते कळपातून दोष नसलेल्या नराचे किंवा मादीचे असावे. ");
INSERT INTO mar_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","जर त्यास कोकरू अर्पण करावयाचे असेल तर त्याने ते परमेश्वरासमोर आणून अर्पावे. ");
INSERT INTO mar_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","त्याने त्या अर्पणाच्या पशूच्या डोक्यावर आपला हात ठेवावा व दर्शनमंडपासमोर तो वधावा आणि अहरोनाच्या मुलांनी त्याचे रक्त वेदीसभोवती टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","अर्पण करणाऱ्यांने शांत्यर्पणाचा काही भाग परमेश्वरास हव्य म्हणून अर्पण करण्यासाठी द्यावा. त्याने त्या पशूची चरबी व पाठीच्या कण्यातून कापून काढलेले चरबीदार शेपूट, आतड्यावरील भोवतालची चरबी. ");
INSERT INTO mar_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","दोन्ही गुरदे, त्यांच्यावरची कमरेजवळील चरबी व गुरद्यापर्यंतचा चरबीचा पडदा हे सर्व काढावे. ");
INSERT INTO mar_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","मग याजकाने त्या सर्वाचा वेदीवर होम करावा; हे शांत्यर्पण अग्नीद्वारे परमेश्वरास केलेले अर्पण आहे. ");
INSERT INTO mar_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“कोणाला जर बकऱ्याचे अर्पण करावयाचे असेल तर त्याने तो बकरा परमेश्वरासमोर अर्पण करावा. ");
INSERT INTO mar_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","त्याने त्या बकऱ्याच्या डोक्यावर आपला हात ठेवावा व दर्शनमंडपासमोर त्याचा वध करावा; मग अहरोनाच्या मुलांनी त्याचे रक्त वेदीवर व त्याच्या सभोवती टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","त्याने त्या शांत्यर्पणाचा काही भाग परमेश्वरासाठी होम करण्याकरिता द्यावा; तसेच त्याने त्याच्या बलीच्या आतड्यावरील व त्यास लागून असलेली चरबी काढावी. ");
INSERT INTO mar_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","दोन्ही गुरदे, त्यावरील कमरेजवळची चरबी आणि गुरद्यापर्यंतचा काळजावरील चरबीचा पडदा हे सर्व काढावे. ");
INSERT INTO mar_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","मग याजकाने वेदीवर त्या सर्वाचा होम करावा या सुवासिक शांत्यर्पणाने परमेश्वरास आनंद होतो; हे अग्नीद्वारे केलेले अर्पण आहे. हे लोकांसाठी अन्न होईल. परंतु त्यातील उत्तम भाग म्हणजे चरबी परमेश्वराची आहे. ");
INSERT INTO mar_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","तुम्ही चरबी व रक्त मुळीच खाऊ नये; तुम्ही जेथे कोठे तुमचे घर बांधाल तेथे तुमच्यासाठी हा नियम पिढ्यानपिढया कायमचा चालू राहील.” ");
INSERT INTO mar_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","इस्राएल लोकांस असे सांग: जर कोणी परमेश्वराने निषिद्ध केलेल्या कृत्यापैकी एखादे कृत्य केले किंवा चुकून त्याच्या हातून पाप घडले तर त्याने पुढील गोष्टी कराव्यात: ");
INSERT INTO mar_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","जर अभिषेक झालेल्या मुख्य याजकाने लोकावंर दोष येईल, असे पाप केले तर आपल्या पापाबद्दल त्याने पापार्पण म्हणून कोणताही दोष नसलेला एक गोऱ्हा परमेश्वरासाठी अर्पावा. ");
INSERT INTO mar_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","त्याने तो गोऱ्हा परमेश्वरासमोर दर्शनमंडपाच्या दारापाशी आणावा, त्याच्या डोक्यावर त्याने आपला हात ठेवावा आणि परमेश्वरासमोर त्याचा वध करावा. ");
INSERT INTO mar_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","मग अभिषिक्त याजकाने गोऱ्ह्याचे थोडे रक्त घ्यावे व ते दर्शनमंडपामध्ये न्यावे. ");
INSERT INTO mar_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","याजकाने आपले बोट त्या रक्तात बुडवावे व परमेश्वरासमोर, परमपवित्र स्थानातील अंतरपटासमोर ते सात वेळा शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","मग याजकाने त्यातले काही रक्त घेऊन दर्शनमंडपापुढे परमेश्वरासमोर असलेल्या धूपवेदीच्या शिंगांना ते लावावे; मग त्या गोऱ्हाचे राहिलेले सगळे रक्त दर्शनमंडपाच्या दारापाशी असलेल्या होमवेदीच्या पायथ्यावर ओतावे. ");
INSERT INTO mar_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","आणि त्याने पापार्पणाच्या गोऱ्ह्याच्या आतड्यांवरील चरबी, त्यास लागून असलेली सर्व चरबी; ");
INSERT INTO mar_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","दोन्ही गुरदे, त्यांच्यावरची कमरेजवळची चरबी आणि गुरद्यापर्यंतच्या काळजावरील पडद्याची चरबी वेगळी करावी; ");
INSERT INTO mar_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","शांत्यर्पणात जसे बैलाचे हे भाग काढून अर्पण करतात तसेच ते अर्पण करून याजकाने त्यांचा होमवेदीवर होम करावा. ");
INSERT INTO mar_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","गोऱ्ह्याचे कातडे, आतडी, सर्व मांस, डोके, पाय व शेण, ");
INSERT INTO mar_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","अशाप्रकारे सर्व गोऱ्हा छावणी बाहेरील विधीपूर्वक नेमलेल्या व स्वच्छ केलेल्या ठिकाणी राख टाकण्याच्या जागेवर नेऊन लाकडाच्या विस्तवावर जाळून टाकावा. ");
INSERT INTO mar_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","इस्राएलाच्या सर्व मंडळीकडून चुकून काही पाप घडले आणि ते मंडळीच्या लक्षात आले नाही, म्हणजे परमेश्वराने निषिद्ध केलेले एखादे कृत्य केले तर ते सर्वजण दोषी ठरतील. ");
INSERT INTO mar_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","आणि मग जर ते त्यांच्या लक्षात आले तर त्यांनी सर्व लोकांकरिता पापार्पण म्हणून एक गोऱ्हा दर्शनमंडपाजवळ आणून अर्पावा. ");
INSERT INTO mar_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","मंडळीच्या वडिलांनी परमेश्वरासमोर त्या गोऱ्ह्याच्या डोक्यावर आपले हात ठेवावे व परमेश्वरासमोर गोऱ्ह्याचा वध करावा. ");
INSERT INTO mar_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","नंतर अभिषिक्त याजकाने त्या गोऱ्ह्याचे थोडे रक्त घ्यावे व ते दर्शनमंडपामध्ये न्यावे; ");
INSERT INTO mar_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","मग याजकाने त्या रक्तात आपले बोट बुडवून परमेश्वरासमोर, अंतरपटासमोर ते सात वेळा शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","मग त्याने परमेश्वरासमोर दर्शनमंडपामध्ये असलेल्या वेदीच्या शिंगांना थोडे रक्त लावावे, व बाकीचे सर्व रक्त दर्शनमंडपापाशी असलेल्या होमवेदीच्या पायथ्यावर ओतावे. ");
INSERT INTO mar_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","त्या गोऱ्ह्याची सर्व चरबी याजकाने काढून तिचा वेदीवर होम करावा. ");
INSERT INTO mar_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","पापार्पणाच्या गोऱ्ह्याच्या भागांचे जसे अर्पण करावयाचे तसेच ह्याच्याही भागांचे करावे; अशा प्रकारे याजकाने इस्राएल लोकांसाठी प्रायश्चित करावे म्हणजे त्यांच्या पापांची क्षमा होईल. ");
INSERT INTO mar_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","आधीचा गोऱ्हा जसा जाळून टाकावयाचा तसा हाही गोऱ्हा याजकाने छावणीच्या बाहेर नेऊन जाळून टाकावा. हे सर्व लोकांकरिता पापार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","एखाद्या अधिपतीने त्याचा देव परमेश्वर याने निषिद्ध केलेले कृत्य केले व चुकून पाप घडले म्हणून तो दोषी ठरला, ");
INSERT INTO mar_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","व त्याने केलेले पाप त्यास कळून आले तर त्याने एक दोष नसलेला बकरा अर्पिण्यासाठी आणावा. ");
INSERT INTO mar_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","त्याने त्या बकऱ्याच्या डोक्यावर आपला हात ठेवावा आणि परमेश्वरासमोर जेथे यज्ञपशूचा वध करतात तेथे त्याचा वध करावा. हे पापार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","मग याजकाने त्या पापार्पणातील काही रक्त घेऊन ते आपल्या बोटाने होमवेदीच्या शिंगांना लावावे व बाकीचे रक्त होमवेदीच्या पायथ्यावर ओतावे. ");
INSERT INTO mar_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","शांत्यर्पणाच्या यज्ञपशूच्या चरबीप्रमाणे याजकाने या बकऱ्याच्याही सर्व चरबीचा वेदीवर होम करावा; अशाप्रकारे त्या अधिपतीच्या पापाबद्दल याजकाने प्रायश्चित करावे, म्हणजे त्या अधिपतीची क्षमा होईल. ");
INSERT INTO mar_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","सामान्य मनुष्यांमधून कोणाकडून चुकून पाप घडले किंवा परमेश्वराने निषिद्ध केलेले एखादे कृत्य केल्यामुळे दोषी तो ठरला; ");
INSERT INTO mar_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","आणि त्याने केलेले पाप त्यास कळून आले तर त्याने त्या पापाबद्दल अर्पण म्हणून एक दोष नसलेली बकरी आणावी. ");
INSERT INTO mar_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","त्याने त्या पापबलीच्या डोक्यावर आपला हात ठेवावा आणि होमबलीचा वध करतात तेथे तिचा वध करावा; ");
INSERT INTO mar_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","मग याजकाने त्या अर्पणातील काही रक्त घेऊन आपल्या बोटाने ते होमवेदीच्या शिंगांना लावावे आणि बाकीचे सर्व रक्त वेदीच्या पायथ्यावर ओतावे. ");
INSERT INTO mar_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","आणि याजकाने त्या बकरीची चरबी शांत्यर्पणाच्या यज्ञपशूच्या चरबीप्रमाणे वेगळी काढून तिचा परमेश्वरासाठी सुवासिक हव्य म्हणून वेदीवर होम करावा; अशाप्रकारे याजकाने त्या मनुष्याकरिता प्रायश्चित्त करावे म्हणजे परमेश्वर त्यास क्षमा करील. ");
INSERT INTO mar_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","त्याने आपल्या अर्पणासाठी पापबली म्हणून कोकरु आणले तर ती दोष नसलेली मादी असावी. ");
INSERT INTO mar_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","त्याने त्या कोकराच्या डोक्यावर आपला हात ठेवावा व जेथे होमबलीचा वध करतात तेथे पापार्पणाकरिता त्यास वधावे. ");
INSERT INTO mar_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","याजकाने त्या पापार्पणातील काही रक्त घेऊन ते आपल्या बोटाने होमवेदीच्या शिंगांना लावावे व बाकीचे वेदीच्या पायथ्याशी ओतावे. ");
INSERT INTO mar_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","त्याने शांत्यर्पणाच्या कोकराच्या चरबीप्रमाणे त्याची सर्व चरबी काढून घ्यावी आणि होमवेदीवर तिचा परमेश्वरासाठी होम करावा. ह्याप्रमाणे त्याने केलेल्या पापांबद्दल याजकाने प्रायश्चित करावे म्हणजे त्याची क्षमा होईल. ");
INSERT INTO mar_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","जर एखाद्याने इतरास सांगण्यासारखी साक्ष ऐकली किंवा त्याने काही पाहिले किंवा ऐकले तर त्या बाबीसंबंधी त्याने साक्ष द्यावी; तो जर साक्ष द्यावयाचे नाकारील तर पाहिलेले किंवा माहित असलेले न सांगण्याचे पाप केल्यामुळे तो दोषी ठरेल; ");
INSERT INTO mar_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","किंवा कोणी अशुद्ध वस्तुला किंवा मरण पावलेल्या वनपशुला किंवा अशुद्ध मानलेल्या पाळीव प्राण्याला किंवा सरपटणाऱ्या अशुद्ध प्राण्याच्या शवाला जरी नकळत शिवल्यामुळे अशुद्ध झाला तर तो दोषी ठरेल. ");
INSERT INTO mar_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","त्याचप्रमाणे मनुष्याशी संबध असलेल्या एखाद्या अशुद्ध वस्तुला नकळत स्पर्श केला व आपण अशुद्ध झालो आहो असे त्यास नंतर कळाले तर तो दोषी ठरेल. ");
INSERT INTO mar_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","किंवा एखादी बरी किंवा वाईट गोष्ट करण्यासंबंधी कोणी आपल्या ओठांद्वारे अविचाराने शपथ घेतली आणि नंतर ती पूर्ण करण्यास तो विसरला; परंतु नंतर त्यास ती आठवली तर आपली शपथ पूर्ण न केल्यामुळे तो दोषी होईल. ");
INSERT INTO mar_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","तो अशा कोणत्याही गोष्टीविषयी दोषी ठरला तर त्याने पाप केलेली बाब कबूल करावी; ");
INSERT INTO mar_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","आणि केलेल्या पापाबद्दल परमेश्वरासमोर त्याने दोषार्पण म्हणून कोकरांची किंवा करडांची एक मादी कळपातुन आणावी; आणि मग याजकाने त्या मनुष्याच्या पापाबद्दल प्रायश्चित करावे. ");
INSERT INTO mar_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","त्यास कोकरु देण्याची ऐपत नसेल तर आपण केलेल्या पापाबद्दल त्याने दोषार्पण म्हणून दोन होले किंवा पारव्याची दोन पिल्ले परमेश्वरासमोर आणावी; त्यापैकी एकाचे पापार्पण व दुसऱ्याचे होमार्पण करावे. ");
INSERT INTO mar_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","त्याने ती याजकापाशी आणावी; मग याजकाने पहिल्याने त्यातील पापार्पण अर्पावे; त्याने पक्ष्याची मुंडी मुरगळून मोडावी परंतु ते वेगळे करु नये ");
INSERT INTO mar_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","पापार्पणाचे काही रक्त वेदीच्या भोंवती शिंपडावे व बाकीचे रक्त वेदीच्या पायथ्याशी निचरु द्यावे; हे पापार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","मग याजकाने दुसऱ्या पक्ष्याचा विधीप्रमाणे होम करावा; ह्याप्रमाणे त्याने केलेल्या पापाबद्दल याजकाने त्या मनुष्याकरिता प्रायश्चित करावे; म्हणजे त्याची क्षमा होईल. ");
INSERT INTO mar_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“जर दोन होले किंवा पारव्याची दोन पिल्ले देखील देण्याची त्याची ऐपत नसेल तर आपल्या पापाबद्दल त्याने एका एफाचा दहावा भाग सपिठ पापार्पण म्हणून आणावे; त्याने त्यावर तेल घालू नये किंवा त्याच्यावर धूप ठेवू नये, कारण हे पापार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","त्याने तो मैदा याजकाकडे आणावा आणि याजकाने त्याच्यातून मूठभर मैदा घेऊन त्याच्या स्मरणाचा भाग म्हणून परमेश्वराच्या चांगूलपणा करिता होम करावा; हे पापार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","अशा प्रकारे याजकाने त्याच्यासाठी प्रायश्चित करावे; आणि मग त्याची क्षमा होईल; अन्नार्पणाप्रमाणे पापार्पणाचे उरलेले सपिठ याजकाचे होईल.” ");
INSERT INTO mar_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","नंतर परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“परमेश्वराची कोणतीही पवित्र वस्तू चुकून दूषित करून कोणी पापी ठरला तर त्याने दोषार्पण म्हणून तू ठरवशील तितक्या चांदीच्या शेकेलांचा दोष नसलेला मेंढा असावा, हे शेकेल पवित्र निवास मंडपातील चलनाप्रमाणे असावे; हे दोषार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ज्या पवित्र वस्तूची विटंबना करून त्याने पाप केले असेल तिची त्याने भरपाई करावी आणि तिच्या किंमतीचा पाचवा हिस्सा रक्कम त्याने याजकाला द्यावी; ह्याप्रकारे याजकाने हा दोषार्पणाचा मेंढा अर्पून त्या मनुष्याकरिता प्रायश्चित करावे; आणि मग त्याची क्षमा होईल. ");
INSERT INTO mar_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","परमेश्वराने निषिद्ध केलेली एखादी गोष्ट करून कोणाकडून चुकून किंवा नकळत पाप घडले तर तो दोषी ठरेल; त्या पापाबद्दल त्याने शिक्षा भोगावी. ");
INSERT INTO mar_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","त्याने दोष नसलेला एक मेंढा दोषार्पणासाठी याजकापाशी आणावा; हे दोषार्पण होय, तू ठरवशील तेवढ्या किंमतीचा तो असावा अशाप्रकारे याजकाने त्या मनुष्याकडून नकळत घडलेल्या पापाबद्दल प्रायश्चित करावे; आणि मग त्याची क्षमा होईल. ");
INSERT INTO mar_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","हे दोषार्पण होय; परमेश्वरासमोर तो नक्कीच दोषी आहे.” ");
INSERT INTO mar_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","जर कोणी परमेश्वराविरूद्ध आज्ञेचा भंग करून पाप केले म्हणजे एखाद्याने गहाण ठेवलेली वस्तू किंवा ठेव या बाबतीत आपल्या शेजाऱ्याला फसवले किंवा लूट करून फसविले व त्याच्यावर जुलूम केला. ");
INSERT INTO mar_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","किंवा आपल्या शेजाऱ्याची हरवलेली वस्तू सापडली असता सापडली नाही अशी लबाडी केली व तिच्याविषयी खोटी शपथ वाहिली, अशा ज्या गोष्टी करून लोक पाप करतात त्यापैकी एखादी करून कोणी अपराधी ठरला; ");
INSERT INTO mar_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","म्हणजे असले पाप करून दोषी झाला; तर त्याने चोरलेली किंवा जुलूम करून जे घेतले असेल ते किंवा आपल्या जवळची कोणाची गहाण ठेवलेली वस्तू बूडविली असेल ती, किंवा कोणाची हरवलेली वस्तू त्यास सापडली असून त्याने परत केली नसेल ती. ");
INSERT INTO mar_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","किंवा एखाद्या कामाबद्दल खोटी शपथ वाहीली तर ती त्याने पूर्ण भरून द्यावी ज्या वस्तुचा त्याने अपहार केला असेल तिची पूर्ण भरपाई आपल्या दोषार्पणाच्या दिवशी करून देऊन त्या वस्तूंच्या किंमतीचा पाचवा हिस्सा अधिक भरावा; ");
INSERT INTO mar_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","त्याने परमेश्वरासाठी याजकाने सांगितलेल्या किंमतीचा एक निर्दोष मेंढा दोषार्पण म्हणून याजकापाशी आणावा; ");
INSERT INTO mar_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","मग याजकाने तो मेंढा घेऊन परमेश्वरासमोर जावे व त्याच्यासाठी प्रायश्चित करावे; आणि मग ज्या अपराधामुळे तो दोषी ठरला असेल त्याची क्षमा होईल. ");
INSERT INTO mar_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","अहरोन व त्याचे पुत्र ह्यांना आज्ञा कर की होमापर्णाचे असे नियम आहेत. होमबली अग्नीकुंडावर रात्रभर ठेवून तो सकाळपर्यंत राहू द्यावा; आणि वेदीवरील अग्नी तिच्यावर जळतच ठेवावा. ");
INSERT INTO mar_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","मग याजकाने आपला तागाचा झगा व चोळणा अंगात घालून होमार्पणमुळे वेदीवर राहिलेली राख उचलावी व ती वेदीजवळ ठेवावी. ");
INSERT INTO mar_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","मग याजकाने आपली वस्त्रे काढावी व दुसरी वस्त्रे घालून ती राख छावणीबाहेर एखाद्या स्वच्छ ठिकाणी न्यावी. ");
INSERT INTO mar_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","परंतु वेदीवरील अग्नी जळतच ठेवावा, तो विझू देऊ नये; याजकाने रोज सकाळी त्या अग्नीवर लाकडे ठेवून तो पेटता ठेवावा व त्याच्यावर होमबली रचून शांत्यर्पणाच्या अर्पणातील चरबीचा होम करावा. ");
INSERT INTO mar_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदीवरील अग्नी सतत जळत ठेवावा, तो विझू देऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","हा अन्नार्पणाचा नियम आहे: अहरोनाच्या मुलांनी ते परमेश्वरासमोर वेदीपुढे आणावे; ");
INSERT INTO mar_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","याजकाने त्या अन्नार्पणातून मूठभर सपिठ, थोडे तेल व धूप घ्यावा व त्याचा वेदीवर होम करावा; ते परमेश्वरासाठी स्मारक भाग म्हणून त्याच्या चांगूलपणासाठीचे सुवासीक हव्य होय. ");
INSERT INTO mar_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","अन्नार्पणातून जे काही उरलेले, व खमीर नसलेले अन्नार्पण अहरोन व त्याच्या मुलांनी दर्शनमंडपाच्या अंगणात पवित्र ठिकाणी बसून खावे. ");
INSERT INTO mar_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ते खमीर घालून भाजू नये; माझ्या अर्पणातून याजकाचा वाटा म्हणून मी ते त्यांना दिलेले आहे; पापार्पण व दोषार्पण या सारखेच हेही परमपवित्र आहे. ");
INSERT INTO mar_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","या अर्पणाला खाण्याचा हक्क अहरोनाच्या संतानातील प्रत्येक पुरुषाला आहे; परमेश्वराच्या अर्पणातून हा त्यांचा वाटा पिढ्यानपिढया सतत चालू राहावा; या अर्पणास जो स्पर्श करेल तो पवित्र होईल. ");
INSERT INTO mar_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","परमेश्वर मोशेला पुन्हा म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“अहरोनाच्या अभिषेकाच्या दिवशी अहरोन व त्याच्या मुलांनी परमेश्वरास अर्पण आणावयाचे ते हे: एक दशांश एफा मैदा नित्याचे अन्नार्पण म्हणून द्यावे व त्यापैकी अर्धे सकाळी व अर्धे संध्याकाळी अर्पावे. ");
INSERT INTO mar_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ते तव्यावर तेलात परतावे त्यामध्ये तेल चांगले मुरल्यावर ते आत ओतावे व परतलेल्या त्या अन्नार्पणाचे तुकडे करून ते परमेश्वराप्रीत्यर्थ सुवास म्हणून अर्पावे. ");
INSERT INTO mar_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","त्याच्या मुलांपैकी जो त्याच्या जागी अभिषिक्त याजक म्हणून निवडला जाईल त्यानेही असेच अर्पण करावे. कायमचा विधी म्हणून या अन्नार्पणाचा परमेश्वरासाठी पूर्णपणे होम करावा. ");
INSERT INTO mar_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","याजकाच्या प्रत्येक अन्नार्पणाचा संपूर्ण होम करावा; ते अन्नार्पण खाऊ नये.” ");
INSERT INTO mar_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","अहरोन व त्याचे पुत्र ह्याना सांग की पापार्पणाचा विधी असा. ज्याठिकाणी होमबलीचा वध करतात त्याच ठिकाणी परमेश्वरासमोर पापबलीचाही वध करावा; तो परमपवित्र आहे. ");
INSERT INTO mar_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जो याजक पापबली अर्पील त्याने तो खावा. दर्शनमंडपाच्या अंगणात पवित्र ठिकाणी तो खावा. ");
INSERT INTO mar_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ज्याला मांसाचा स्पर्श होईल तो पवित्र होईल; त्याचे रक्त जर कोणाच्या वस्त्रावर उडाले तर ते वस्त्र तू पवित्रस्थानी धुवावे. ");
INSERT INTO mar_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","मांस जर मडक्यात शिजवले असेल तर ते मडके फोडून टाकावे; पण ते जर पितळेच्या भांड्यात शिजवले असेल तर ते भांडे घासून पाण्याने धुवावे. ");
INSERT INTO mar_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","याजकाच्या घराण्यातील प्रत्येक पुरुषाला ते खाण्याचा हक्क आहे; ते परमपवित्र आहे; ");
INSERT INTO mar_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","आणि ज्या पापबलीचे थोडे रक्त दर्शनमंडपामध्ये पवित्र ठिकाणी प्रायश्चितासाठी आणले जाईल त्याचे मांस खाऊ नये; ते अग्नीत जाळावे. ");
INSERT INTO mar_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","दोषार्पणाविषयीचा विधी असा आहे: हे अर्पण परमपवित्र आहे. ");
INSERT INTO mar_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ज्या स्थानी होमबलीचा वध करावयाचा त्याच स्थानी दोषार्पणाच्या बलीचा वध करावा, आणि याजकाने त्या बलीचे रक्त वेदीवर सभोवती टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","त्याची सर्व चरबी त्याने अर्पावी; त्याचे चरबीदार शेपूट, आतड्यावरील चरबी, ");
INSERT INTO mar_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","दोन्ही गुरदे, त्याच्यावरील कमरेजवळील चरबी व गुरद्यापर्यंतचा काळजावरील चरबीचा पडदा वेगळे करावेत. ");
INSERT INTO mar_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","या सर्वांचा याजकाने होम करावा; हे परमेश्वरासाठी होमार्पण आहे. हेच दोषार्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","याजक वर्गातील प्रत्येक पुरुषाला हे दोषार्पण बली खाण्याचा हक्क आहे; ते परमपवित्र आहे, ते पवित्र स्थानी बसून खावे. ");
INSERT INTO mar_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","दोषार्पण पापार्पणासारखेच आहे; त्या दोघांचे विधी एकच आहेत; जो याजक ह्याच्याद्वारे प्रायश्चित करील त्याचा त्या अर्पणावर हक्क आहे. ");
INSERT INTO mar_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","प्रायश्चित करणाऱ्या याजकाचा त्या होमार्पणाच्या बलीच्या कातड्यावरही हक्क असेल. ");
INSERT INTO mar_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","भट्टीत भाजलेले कढईत किंवा तव्यावर तळलेले सर्व अन्नार्पण, ते अर्पण करणाऱ्या याजकाचे होईल. ");
INSERT INTO mar_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","प्रत्येक अन्नार्पण तेल मिश्रित किंवा कोरडे, ते अर्पण करणाऱ्या अहरोनाच्या मुलांचे आहे; त्या सर्वाचा त्यांच्यावर सारखाच हक्क आहे. ");
INSERT INTO mar_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","परमेश्वरासाठी कोणाला शांत्यर्पणाचा यज्ञ करावयाचा असेल तर त्याचा विधी असा: ");
INSERT INTO mar_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","त्यास तो शांत्यर्पणाचा यज्ञ उपकारस्तुतीसाठी करावयाचा असेल तर त्याने तेलात मळलेल्या, बेखमीर पोळ्या, तेल लावलेल्या बेखमीर चपात्या आणि तेलात मळलेल्या सपिठाच्या तळलेल्या पोळया उपकारस्तुतीच्या यज्ञासोबत अर्पाव्या. ");
INSERT INTO mar_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","त्याच्या उपकारस्तुतीच्या शांत्यर्पणाच्या यज्ञासोबत त्याने खमिर घातलेल्या भाकरीही अर्पाव्या ");
INSERT INTO mar_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","या प्रत्येक अर्पणातून परमेश्वरासाठी प्रत्येकी एक पोळी अर्पावी; शांत्यर्पणाचे रक्त शिंपडणाऱ्या याजकाचा त्या पोळीवर हक्क आहे. ");
INSERT INTO mar_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","त्याने उपकारस्तुतीसाठी केलेल्या शांत्यर्पणाच्या यज्ञबलीचे मांस, अर्पण करण्याच्या दिवशीच खावे; त्यातील काही सकाळपर्यंत ठेवू नये. ");
INSERT INTO mar_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","यज्ञबलीचे अर्पण नवसाचे किंवा स्वखुशीचे असेल तर ज्या दिवशी तो ते अर्पील त्यादिवशीच त्याने ते खावे आणि जर त्यातून काही उरेल तर त्याने दुसऱ्या दिवशीही खावे. ");
INSERT INTO mar_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","त्या यज्ञबलीचे काही मांस तिसऱ्या दिवसापर्यंत उरले तर ते अग्नीत जाळूत टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","जर कोणी शांत्यर्पणाच्या यज्ञबलीच्या मांसातून तिसऱ्या दिवशी मांस खाईल तर परमेश्वरास ते आवडणार नाही, व तो ते अर्पण मान्य करणार नाही; ते अर्पण अमंगळ होईल; त्या पापाबद्दल भोगाव्या लागणाऱ्या शिक्षेस तो स्वत: जबाबदार राहील. ");
INSERT INTO mar_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","ज्या मांसास कोणत्याही अशुद्ध वस्तूचा स्पर्श झाला असेल ते खाऊ नये; ते अग्नीत जाळून टाकावे. शुद्ध असणाऱ्यानेच यज्ञबलीचे मांस खावे; ");
INSERT INTO mar_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","परंतु जर कोणी अशुद्ध असून परमेश्वरास अर्पिलेल्या शांत्यर्पणाच्या यज्ञबलीचे मांस खाईल तर त्यास आपल्या लोकांतून बाहेर काढावे. ");
INSERT INTO mar_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","एखादा मनुष्य जर एखाद्या अशुद्ध वस्तुला स्पर्श करेल मग ती अशुद्धता मनुष्याची, पशूची किंवा दुसऱ्या कोणत्या अमंगळ पदार्थाची असो, तर तो अशुद्ध होईल आणि परमेश्वरास अर्पण केलेल्या शांत्यर्पणाच्या यज्ञबलीचे जर तो मांस खाईल तर त्यास आपल्या लोकांतून बाहेर काढावे. ");
INSERT INTO mar_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","सर्व इस्राएल लोकांस असे सांग: तुम्ही बैलाची मेंढराची किंवा बकऱ्याची चरबी खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","मरण पावलेल्या जनावराची चरबी किंवा इतर पशूंनी फाडून टाकलेल्या जनावराची चरबी तुम्ही इतर कामासाठी वापरावी पण ती मुळीच खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","परमेश्वरास होमाद्ववारे अर्पिलेल्या पशूची चरबी जर कोणी खाईल तर त्यास आपल्या लोकांतून बाहेर काढावे ");
INSERT INTO mar_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“तुम्ही कोठेही राहत असला तरी आपल्या घरात पक्ष्याचे किंवा जनावराचे रक्त तुम्ही कधीही खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","जर कोणी कोणतेही रक्त खाईल तर त्यास आपल्या लोकांतून बाहेर काढावे.” ");
INSERT INTO mar_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएल लोकांस असे सांग: जर कोणी परमेश्वरासमोर आपल्या शांत्यर्पणाचा यज्ञबली अर्पील तर त्याने त्या अर्पणातून काही भाग परमेश्वराकडे आणावा. ");
INSERT INTO mar_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","त्याने आपल्या हाताने परमेश्वरासाठी अर्पणे आणावी; त्याने चरबी व ऊर याजकाकडे आणावा; ते ऊर परमेश्वरासमोर ओवाळले जाईल; हे ओवाळणीचे अर्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","मग याजकाने त्या चरबीचा होम करावा परंतु ऊर अहरोन व त्याचे पुत्र ह्यांचा होईल. ");
INSERT INTO mar_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","तसेच तुम्ही आपल्या शांत्यर्पणाच्या यज्ञबलीची उजवी मांडीही समर्पित केलेला अंश म्हणून याजकाला द्यावी. ");
INSERT INTO mar_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","अहरोनाच्या मुलांपैकी जो कोणी शांत्यर्पणाचे रक्त व चरबी अर्पील त्याचा त्या मांडीवर हक्क असावा. ");
INSERT INTO mar_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","मी परमेश्वर इस्राएल लोकांच्या शांत्यर्पणाच्या यज्ञबलीतून ओवाळणीचा ऊर व उजवी मांडी काढून घेऊन अहरोन याजक व त्याचे पुत्र ह्याना दिली आहे; हा इस्राएल लोकांकडून त्यांना मिळणारा नेहमीचा हिस्सा आहे. इस्राएल लोकांनी हा निरंतरचा विधी म्हणून पिढ्यानपिढया पाळावा.” ");
INSERT INTO mar_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","परमेश्वराकरिता अर्पिलेल्या अर्पणातून हे भाग अहरोन व त्याचे पुत्र ह्यांना देण्यात आलेले आहेत; जेव्हा जेव्हा ते याजक म्हणून परमेश्वराची सेवा करतात तेव्हा तेव्हा त्या समर्पणातून ते भाग त्यांना मिळावेत. देवाची सेवा करणारे याजक म्हणून ज्या दिवशी त्यांची नेमणूक करण्यात आली त्याच दिवसापासून असे ठरले आहे. ");
INSERT INTO mar_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","परमेश्वराने ज्या दिवशी त्यांना अभिषेक केला त्यादिवशी त्याने इस्राएल लोकांकडून हा भाग त्यांना मिळावा अशी आज्ञा दिली व हा त्यांचा पिढ्यानपिढ्या कायमचा हक्क ठरला आहे. ");
INSERT INTO mar_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","हे विधी होमार्पण, अन्नार्पण, पापार्पण, दोषार्पण, याजकाच्या समर्पणाच्या वेळचे अर्पण आणि शांत्यर्पण या विषयीचे आहे; ");
INSERT INTO mar_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","इस्राएल लोकांनी परमेश्वराकरिता काय अर्पणे आणावीत या विषयी त्याने त्यांना सीनाय रानात आज्ञा दिली त्यावेळी त्याने मोशेला ह्याप्रमाणे सीनाय पर्वतावर हे विधी लावून दिले. ");
INSERT INTO mar_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","अहरोन व त्याच्याबरोबर त्याचे पुत्र ह्यांना आणि त्यांची वस्त्रे अभिषेकाचे तेल, पापार्पणाचा गोऱ्हा दोन मेंढे आणि बेखमीर भाकरीची टोपली घेऊन, ");
INSERT INTO mar_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","दर्शनमंडपाच्या दाराजवळ सर्व मंडळीला एकत्र जमवून आण. ");
INSERT INTO mar_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","परमेश्वराच्या आज्ञेप्रमाणे मोशेने केले. मंडळी दर्शनमंडपाच्या प्रवेशद्वाराशी जमली. ");
INSERT INTO mar_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","मग मोशे मंडळीला म्हणाला, “परमेश्वराने जे करायचे आज्ञापिले, ते हे.” ");
INSERT INTO mar_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","मग मोशेने अहरोन व त्याच्या मुलांना आणवून पाण्याने आंघोळ घातली. ");
INSERT INTO mar_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","मग त्याने अहरोनाला विणलेला सदरा घातला, त्याच्या कमरेला कमरबंद बांधला; मग त्यास झगा घातला, नंतर त्याच्यावर एफोद चढवला आणि त्यावर कुशलतेने विणलेली पट्टी आवळून बांधली. ");
INSERT INTO mar_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","मग मोशेने त्याच्यावर ऊरपट बांधला आणि त्याच्यात उरीम व थुम्मीम ठेवले; ");
INSERT INTO mar_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","नंतर त्याच्या डोक्यावर फेटा ठेवला; आणि फेट्याच्या पुढल्या भागावर सोन्याची पट्टी म्हणजे पवित्र मुकुट ठेवला; परमेश्वराने जसे करण्यास सांगितले होते, तसेच मोशेने केले. ");
INSERT INTO mar_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","मग मोशेने अभिषेकाचे तेल घेतले आणि पवित्र निवासमंडपावर व त्यातील सर्व वस्तूंना आभिषेक करुन त्यांना पवित्र केले. ");
INSERT INTO mar_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","अभिषेकाच्या तेलातून थोडे घेऊन त्याने ते वेदीवर सात वेळा शिंपडले आणि वेदी, तिची सर्व उपकरणे, गंगाळ व त्याची बैठक यांच्यावरही त्याने अभिषेकाचे तेल शिंपडून पवित्र केले. ");
INSERT INTO mar_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","मग मोशेने थोडे अभिषेकाचे तेल अहरोनाच्या डोक्यावर ओतले व अशा प्रकारे त्याने अभिषेक करून त्यास पवित्र केले. ");
INSERT INTO mar_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","मग मोशेने अहरोनाच्या मुलांना आणले, त्यांना विणलेले सदरे घातले, कमरेस कमरबंद घातले व त्यांच्या डोक्यांना फेटे बांधले; परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे त्याने हे केले. ");
INSERT INTO mar_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","मग मोशेने पापार्पणाचा गोऱ्हा आणला आणि अहरोन व त्याचे पुत्र ह्यांनी त्या गोऱ्ह्याच्या डोक्यावर आपले हात ठेवले. ");
INSERT INTO mar_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","मग मोशेने तो वधला व त्याचे रक्त घेऊन आपल्या बोटाने वेदीच्या सर्व शिंगांना ते लावले, अशाप्रकारे त्याने वेदी शुद्ध केली आणि उरलेले रक्त वेदीच्या पायथ्यावर ओतले, देवासाठी त्याने ती वेगळी केली. या प्रकारे ती पवित्र करण्यासाठी त्याने प्रायश्चित्त केले. ");
INSERT INTO mar_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","गोऱ्हाच्या आंतड्यावरील सर्व चरबी, काळजावरील चरबीचा पडदा आणि चरबीसहीत दोन्ही गुरदे घेऊन मोशेने वेदीवर त्यांचा होम केला. ");
INSERT INTO mar_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","परंतु गोऱ्हा, त्याचे कातडे, त्याचे मांस व त्याचे शेण ही सर्व छावणीबाहेर नेऊन अग्नीत जाळून टाकली, परमेश्वराने आज्ञा दिल्याप्रमाणे मोशेने हे केले. ");
INSERT INTO mar_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","मग त्याने होमापर्णाचा मेंढा आणला. अहरोन व त्याचे पुत्र ह्यांनी त्याच्या डोक्यावर आपले हात ठेवले. ");
INSERT INTO mar_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","मग मोशेने तो वधला व त्याचे रक्त त्याने वेदीवर व सभोवती शिंपडले. ");
INSERT INTO mar_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","मग मोशेने त्या मेंढ्याचे कापून तुकडे केले, मग त्याचे डोके, तुकडे व चरबी हे सर्व घेऊन त्याने वेदीवर होम केला. ");
INSERT INTO mar_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","त्याची आतडी पाय पाण्याने धुवून मोशेने वेदीवर संपूर्ण मेंढ्याचे होमार्पण केले. ते परमेश्वरासाठी सुवासिक हव्य झाले, परमेश्वराने आज्ञा दिल्याप्रमाणे त्याने हे केले. ");
INSERT INTO mar_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","मग मोशेने दुसरा मेंढा आणला; तो अहरोन व त्याची मुले यांची याजक म्हणून नेमणूक झाली हे दाखवण्याकरिता होता. अहरोन व त्याच्या मुलांनी आपले हात त्या मेंढ्याच्या डोक्यावर ठेवले. ");
INSERT INTO mar_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","मोशेने त्याचा वध केला व त्याचे थोडे रक्त घेऊन अहरोनाच्या उजव्या कानाच्या पाळीला: उजव्या हाताच्या अंगठ्याला व उजव्या पायाच्या अंगठ्याला लावले. ");
INSERT INTO mar_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","मग मोशेने अहरोनाच्या मुलांना आणून त्याच्या उजव्या कानाच्या पाळीला, उजव्या हाताच्या अंगठ्याला व उजव्या पायाच्या अंगठ्याला, काही रक्त लावले व मग ते रक्त त्याने वेदीवर व सभोवती शिंपडले. ");
INSERT INTO mar_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","मोशेने चरबी, चरबीदार शेपूट, आंतड्यावरील सर्व चरबी काळजावरील चरबीचा पडदा, दोन्ही गुरदे, त्यांच्यावरील चरबी व उजवी मांडी घेतली; ");
INSERT INTO mar_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","परमेश्वरासमोर ठेवलेल्या बेखमीर भाकरीच्या टोपलीतील एक बेखमीर पोळी, तेल लावलेली एक भाकर व एक पापडी घेऊन त्या, चरबीवर व मागच्या बाजूच्या उजव्या मांडीवर ठेवल्या. ");
INSERT INTO mar_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","हे सर्व त्याने अहरोन व त्याच्या मुलांच्या हातावर ठेवले आणि परमेश्वरासमोर ओवाळणीचे अर्पण म्हणून ते ओवाळले. ");
INSERT INTO mar_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","मग मोशेने ते त्यांच्या हातातून घेऊन वेदीवरील होमार्पणासहीत त्यांचा होम केला; अहरोन व त्याचे पुत्र ह्यांचे याजक म्हणून समर्पण करण्यासाठी हे अर्पण केले. हे होमार्पण होते हे सुवासीक हव्य होय. हे अग्नीद्वारे परमेश्वरास केलेले अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","मोशेने मेंढ्याच्या उराचा भाग घेऊन ओवाळणीचे अर्पण म्हणून तो परमेश्वरासमोर ओवाळला; याजकाच्या समर्पणासाठी असलेल्या मेंढ्याचा हा भाग मोशेच्या वाट्याचा होता; परमेश्वराने दिलेल्या आज्ञेप्रमाणे मोशेने हे केले. ");
INSERT INTO mar_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","मग मोशेने अभिषेकाचे काही तेल व वेदीवरील काही रक्त घेऊन अहरोन व त्याची वस्त्रे, व त्याच्यासहीत त्याचे पुत्र व त्यांची वस्त्रे ह्यांच्यावर शिंपडले आणि अहरोन व त्याची वस्त्रे व त्याच्याबरोबर त्याचे पुत्र व त्यांची वस्त्रे पवित्र केली. ");
INSERT INTO mar_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","मोशे अहरोन व त्याचे पुत्र ह्याना म्हणाला, “मी सांगितल्याप्रमाणे, ‘अहरोन व त्याच्या मुलांनी हे मांस खावे;’ तेव्हा ही भाकरीची टोपली व याजकाच्या समर्पणासाठीचे हे मांस घ्या; दर्शनमंडपाच्या दारापाशी ते शिजवा आणि मी सांगितल्याप्रमाणे मांस व भाकर तेथेच खा. ");
INSERT INTO mar_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","मांस व भाकर ह्यातून काही उरले तर ते अग्नीत जाळून टाका; ");
INSERT INTO mar_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","तुमच्या समर्पणाचा विधी सात दिवस चालेल; ते सात दिवस पूर्ण होईपर्यंत तुम्ही दर्शनमंडपाच्या बाहेर जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","परमेश्वराने आज्ञा केली आहे की आज केल्याप्रमाणे तुमच्यासाठी प्रायश्चित करावे. ");
INSERT INTO mar_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","तेव्हा दर्शनमंडपाच्या दारापाशी तुम्ही सात दिवस व रात्री राहा, ही परमेश्वराची आज्ञा तुम्ही पाळली नाहीतर तुम्ही मराल; कारण मला तशी आज्ञा दिली आहे.” ");
INSERT INTO mar_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","तेव्हा मोशेच्याद्वारे परमेश्वराने ज्या गोष्टींविषयी आज्ञा दिली होती त्या सर्व अहरोन व त्याच्या मुलांनी केल्या. ");
INSERT INTO mar_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठव्या दिवशी मोशेने अहरोन, त्याचे पुत्र तसेच इस्राएलांचे वडील ह्यांना बोलावले. ");
INSERT INTO mar_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","तो अहरोनाला म्हणाला, “पापार्पणासाठी एक निर्दोष गोऱ्हा व होमार्पणासाठी निर्दोष मेंढा आण आणि त्यांना परमेश्वरास अर्पण कर. ");
INSERT INTO mar_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","आणि इस्राएल लोकांस असे सांग, ‘तुम्ही पापार्पणासाठी एक बकरा आणा व होमार्पणासाठी एक गोऱ्हा व एक कोकरु आणा; ही दोन्ही प्रत्येकी एक वर्षाची व निर्दोष असावीत; ");
INSERT INTO mar_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","आणि परमेश्वरासमोर शांत्यर्पणे करण्यासाठी बली म्हणून एक बैल, एक मेंढा व तेलात मळलेले अन्नार्पण आणा कारण आज परमेश्वर तुम्हास दर्शन देणार आहे.” ");
INSERT INTO mar_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","मग मोशेने आज्ञा दिल्याप्रमाणे सर्व लोक आले व त्यांनी ते सर्व दर्शनमंडपाच्या दारापाशी आणले मग सर्वजण येऊन परमेश्वरासमोर उभे राहिले. ");
INSERT INTO mar_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","तेव्हा मोशे म्हणाला, “परमेश्वराने आज्ञा दिल्याप्रमाणे तुम्ही सर्वकाही करावे; मग परमेश्वराचे गौरव तुम्हास दिसेल.” ");
INSERT INTO mar_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","मग मोशेने अहरोनाला सांगितले, “जा व परमेश्वराने आज्ञा दिल्याप्रमाणे सर्वकाही कर; वेदीजवळ जाऊन आपला पापबली व होमबली ह्यांचे अर्पण कर आणि स्वत:साठी व लोकांसाठी प्रायश्चित कर आणि लोकांकडील बलीही अर्पण करून त्यांच्यासाठी प्रायश्चित कर.” ");
INSERT INTO mar_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","तेव्हा अहरोन वेदीजळ गेला व त्याने स्वत:साठी पापार्पणाचा गोऱ्हा वधला. ");
INSERT INTO mar_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","मग अहरोनाचे पुत्र रक्त घेऊन त्याच्यापाशी गेले. तेव्हा त्याने आपले बोट त्यामध्ये बुडवून ते वेदीच्या शिंगांना लावले मग ते वेदीच्या पायथ्याशी ओतले. ");
INSERT INTO mar_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","त्याने पापार्पणाची चरबी, गुरदे व काळजावरील चरबीचा पडदा घेऊन त्यांचा वेदीवर परमेश्वराने मोशेला दिलेल्या आज्ञेप्रमाणेच होम केला. ");
INSERT INTO mar_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","मग अहरोनाने मांस व कातडे छावणीबाहेर नेऊन अग्नीत जाळून टाकले. ");
INSERT INTO mar_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","नंतर त्याने होमबली वधला व त्याचे तुकडे केले; अहरोनाच्या मुलांनी त्या होमबलीचे रक्त अहरोनाकडे आणले तेव्हा त्याने ते वेदीवर व सभोवती शिंपडले. ");
INSERT INTO mar_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","नंतर अहरोनाच्या मुलांनी होमबलीचे तुकडे व त्याचे डोके अहरोनाकडे दिले आणि त्याने त्यांचा वेदीवर होम केला. ");
INSERT INTO mar_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","त्याने त्याची आतडी व पाय धुवून त्यांचाही वेदीवर होम केला. ");
INSERT INTO mar_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","मग त्याने लोकांचे अर्पण जवळ नेले व त्यांच्यासाठी आणलेला पापार्पणाचा बकरा वधला आणि पहिल्याप्रमाणेच तोसुध्दा पापार्पण म्हणून अर्पिला. ");
INSERT INTO mar_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","त्याने होमबलीही जवळ नेऊन परमेश्वराने आज्ञा दिल्याप्रमाणे तो अर्पिला. ");
INSERT INTO mar_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","मग त्याने अन्नार्पण वेदीजवळ नेले व त्यातले मूठभर घेऊन दररोज सकाळच्या होमार्पणासह तेही अर्पण केले. ");
INSERT INTO mar_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","लोकांसाठी शांत्यर्पणे म्हणून आणलेला बैल व मेंढा हे त्याने वधले आणि त्याच्या मुलांनी त्या बलींचे व मेंढ्याचे रक्त अहरोनाकडे आणले तेव्हा त्याने ते वेदीवर व सभोवती शिंपडले. ");
INSERT INTO mar_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","अहरोनाच्या मुलांनी बैलाची व मेंढ्याची चरबी, चरबीदार शेपूट, आंतड्यावरील चरबी, गुरदे आणि काळजावरील चरबीचा पडदा ही सर्व अहरोनाकडे आणली. ");
INSERT INTO mar_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","त्यांनी ती सर्व चरबी त्या बलींच्या ऊराच्या भागावर ठेवली; मग अहरोनाने त्या सर्वाचा वेदीवर होम केला. ");
INSERT INTO mar_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","अहरोनाने बलींचे ऊर व उजवी मांडी ही मोशेच्या सांगण्याप्रमाणे परमेश्वरासमोर ओवाळणीचे अर्पण म्हणून ओवाळली. ");
INSERT INTO mar_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","मग अहरोनाने लोकांकडे वळून, हात वर करून त्यांना आशीर्वाद दिला आणि ज्या वेदीवर त्याने पापार्पण, होमार्पण, व शांत्यर्पणे केली होती तेथून तो खाली आला. ");
INSERT INTO mar_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","मोशे व अहरोन दर्शनमंडपामध्ये गेले आणि बाहेर आल्यावर त्यांनी लोकांस आशीर्वाद दिला; तेव्हा परमेश्वराचे तेज सर्व लोकांस दिसले; ");
INSERT INTO mar_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","तेव्हा परमेश्वरासमोरून अग्नी निघाला व त्याने वेदीवरील होमार्पण व चरबी भस्म केली; हे पाहून सर्व लोकांनी जयजयकार केला व दंडवत घातले. ");
INSERT INTO mar_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","मग अहरोनाचे, पुत्र नादाब, व अबीहू ह्यानी आपआपली धुपाटणी घेतली व त्यामध्ये अग्नी पेटवला व त्यामध्ये धुप घालून तो अशास्त्र अग्नी परमेश्वरासमोर नेला, असा अग्नी परमेश्वरासमोर नेण्याची आज्ञा नव्हती; ");
INSERT INTO mar_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","म्हणून परमेश्वरासमोरुन अग्नी निघाला व त्याने त्यांना भस्म केले; ते परमेश्वरासमोर मरण पावले. ");
INSERT INTO mar_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","मग मोशे अहरोनाला म्हणाला, “परमेश्वर म्हणतो, ‘जे याजक माझ्याजवळ येतील. त्यांनी माझा मान राखलाच पाहिजे, मी पवित्र आहे हे त्यांना व सर्व लोकांस समजलेच पाहिजे. तेव्हा अहरोन, नादाब व अबीहू ह्यांच्या विषयी काहीही न बोलता गप्प राहिला.’” ");
INSERT INTO mar_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","अहरोनाचा चुलता उज्जियेल ह्याला मिशाएल व एलसाफान असे दोन पुत्र होते. मोशे त्या मुलांना म्हणाला, “या पवित्रस्थानाच्या भागाकडे जा व तुमच्या बांधवांची प्रेते पवित्र स्थानासमोरून उचलून छावणीबाहेर घेऊन जा.” ");
INSERT INTO mar_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","तेव्हा मोशेने सांगितल्याप्रमाणे मिशाएल व एलसाफान यांनी त्यांना उचलून छावणीबाहेर नेले; त्यावेळी परमेश्वराची सेवा करताना घालावयाचे विणलेले विशेष अंगरखे नादाब व अबीहू ह्यांच्या अंगात अद्याप तसेच होते. ");
INSERT INTO mar_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","मोशेने अहरोन व त्याचे पुत्र एलाजार व इथामार यांना सांगितले, “तुम्ही तुमचे केस मोकळे सोडू नका तर ते विंचरा, आणि तुमची वस्त्रे फाडू नका! तुमचे दु:ख दाखवू नका! म्हणजे मग तुम्ही मारले जाणार नाही आणि परमेश्वराचा राग सर्व मंडळीवर भडकणार नाही; सर्व इस्राएल घराणे तुमचे बांधव आहेत; नादाब व अबीहू ह्याना परमेश्वराने अग्नीने भस्म केल्याबद्दल त्यांनी शोक करावा; ");
INSERT INTO mar_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","पण तुम्ही दर्शनमंडपाच्या बाहेर जाऊ नये; जर बाहेर जाल तर मराल! कारण परमेश्वराच्या अभिषेकाच्या तेलाने तुमचा अभिषेक झाला आहे.” तेव्हा अहरोन, एलाजार व इथामार ह्यांनी मोशेची आज्ञा मानली. ");
INSERT INTO mar_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","मग परमेश्वर अहरोनाला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“जेव्हा तू व तुझे पुत्र तुम्ही दर्शनमंडपामध्ये जाल तेव्हा तुमच्यापैकी कोणीही द्राक्षरस किंवा मद्य पिऊ नये; प्याल तर मराल! हा तुमच्यासाठी पिढ्यानपिढया कायमचा विधि आहे. ");
INSERT INTO mar_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","तुम्ही परमेश्वराच्या दृष्टीने पवित्र व सामान्य तसेच शुद्ध व अशुद्ध ह्यामधील भेद जाणावा; ");
INSERT INTO mar_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","याप्रकारे परमेश्वराने मोशेद्वारे नेमून दिलेले सर्व विधीनियम अहरोनाने सर्व इस्राएल लोकांस शिकवावे.” ");
INSERT INTO mar_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","मग मोशे अहरोनाला आणि एलाजार व इथामार या हयात असलेल्या त्याच्या मुलांना म्हणाला, परमेश्वराच्या अर्पणापैकी उरलेले अन्नार्पण घ्या व ते वेदीपाशी खमीराशिवाय खा, कारण ते परमपवित्र आहे; ");
INSERT INTO mar_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","परमेश्वरासाठी अर्पिलेल्या अर्पणाचा तो भाग आहे आणि मी दिलेल्या विधीनियमांच्या शिकवणुकीप्रमाणे तो भाग तुझा व तुझ्या मुलांच्या हक्काचा आहे; परंतु तो तुम्ही पवित्र जागी खावा. ");
INSERT INTO mar_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“त्याप्रमाणे तू, तुझी मुले व तुझ्या मुली ह्यांनी, ओवाळलेला ऊर व मागचा पाय स्वच्छ ठिकाणी खावा; कारण इस्राएल लोकांनी केलेल्या शांत्यर्पणाच्या यज्ञापैकी तुला तो हक्क म्हणून दिला आहे. ");
INSERT INTO mar_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ओवाळणीचा ऊर व समर्पणाची मांडी ही चरबीच्या हव्याबरोबर ओवाळणीचे अर्पण म्हणून लोकांनी परमेश्वरासमोर ओवाळण्यासाठी आणावी; ओवाळून झाल्यावर परमेश्वराच्या आज्ञेप्रमाणे हा भाग तुझा व तुझ्या मुलाबाळांचा कायमच्या हक्काचा आहे.” ");
INSERT INTO mar_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","मोशेने पापार्पणाच्या बकऱ्याची बारकाईने विचारपूस केली असता तो जाळून टाकल्याचे त्यास कळाले; तेव्हा अहरोनाचे पुत्र एलाजार व इथामार ह्यांच्यावर मोशे भयंकर रागावला; तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“तुम्ही पापार्पणाच्या बलीचे मांस पवित्रस्थानी खावयास पाहिजे होते; कारण ते परमपवित्र आहे! तुम्ही ते परमेश्वरासमोर का खाल्ले नाही? मंडळीचा अन्याय वाहून त्यांच्यासाठी परमेश्वरासमोर प्रायश्चित करावे म्हणून परमेश्वराने ते तुम्हास दिले होते; ");
INSERT INTO mar_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","त्याचे रक्त पवित्रस्थानात आणण्यात आले नव्हते; माझ्या आज्ञेप्रमाणे तुम्ही त्याचे मांस पवित्र जागी बसून अवश्य खावयाचे होते.” ");
INSERT INTO mar_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","परंतु अहरोन मोशेला म्हणाला, “पाहा, आज त्यांनी आपले पापार्पण व होमार्पण परमेश्वरासमोर अर्पण केले, आणि तरी आज माझ्यावर कशी संकटे आली आहेत हे तू जाणतोस; तेव्हा आज मी पापबली खाल्ला असता तर परमेश्वरास ते आवडले असते, असे तुला वाटते काय? नाही ना!” ");
INSERT INTO mar_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","मोशेने हे ऐकले, तेव्हा त्याचे समाधान झाले. ");
INSERT INTO mar_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","परमेश्वर मोशे व अहरोन ह्यांना म्हणाला: ");
INSERT INTO mar_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","इस्राएल लोकांस असे सांगा की पृथ्वीवरील ज्या प्राण्यांचे मांस तुम्ही खावे ते हे: ");
INSERT INTO mar_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ज्या प्राण्यांचे खूर दुभंगलेले आहेत व जे रवंथ करतात त्यांचे मांस तुम्ही खावे. ");
INSERT INTO mar_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","काही प्राणी रवंथ करतात परंतु त्यांचे खूर दुभंगलेले नाहीत, म्हणून ते तुम्ही अशूद्ध समजावे, जसे उंट, हा रवंथ करतो पंरतू त्याचा खुर विभागलेला नाही, म्हणून तो तुम्ही अशुद्ध समजावा. ");
INSERT INTO mar_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","शाफान हा रंवथ करतो परंतु त्याचा खुर विभागलेला नाही म्हणून तुम्ही तो अशुद्ध समजावा. ");
INSERT INTO mar_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ससा हा रंवथ करतो परंतु त्याचा खुर विभागलेला नाही म्हणून तुम्ही तो सुध्दा अशुद्ध समजावा. ");
INSERT INTO mar_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","डुकराचे खूर दुभंगलेले आहे पण तो रवंथ करत नाही म्हणून तो तुम्हाकरिता अशुद्ध आहे. ");
INSERT INTO mar_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","या प्राण्यांचे मांस तुम्ही खाऊ नये व त्यांच्या शवांना शिवू नये; ते तुमच्यासाठी अशुद्ध आहेत. ");
INSERT INTO mar_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“जलाशयात, समुद्रात व नद्यात संचार करणाऱ्या ज्या प्राण्यांना पंख व खवले आहेत ते तुम्ही खावे. ");
INSERT INTO mar_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","जलचरापैकी समुद्रात व नद्यात संचार करणाऱ्या ज्या प्राण्यांना पंख आणि खवले नाहीत असे प्राणी तुम्ही खाऊ नये; परमेश्वराच्या दृष्टीने ते अयोग्य आहेत. ");
INSERT INTO mar_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ते तुम्ही अयोग्य समजावे; त्यांचे मांस खाऊ नये; त्यांच्या शवांना देखील शिवू नये. ");
INSERT INTO mar_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","जलाशयातल्या ज्या प्राण्यांना पंख व खवले नाहीत ते देवाच्या दृष्टीने खाण्यास योग्य नाहीत ते ओंगळ समजावे.” ");
INSERT INTO mar_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","देवाच्या दृष्टीने अशुद्ध प्राण्याप्रमाणेच अशुद्ध असलेले म्हणून खाऊ नयेत ते पक्षी असे; गरुड, गीध, कुरर, ");
INSERT INTO mar_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","घार, निरनिराळ्या जातीचे ससाणे, ");
INSERT INTO mar_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","निरनिराळ्या जातीचे कावळे, ");
INSERT INTO mar_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","शहामृग, गवळण, कोकीळ, निरनिराळ्या जातीचे बहिरी ससाणे, ");
INSERT INTO mar_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","पिंगळा, करढोक, मोठे घुबड, ");
INSERT INTO mar_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","पांढरे घुबड, पाणकोळी, गिधड, ");
INSERT INTO mar_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","करकोचा, निरनिराळ्या जातीचे बगळे, टिटवी आणि वटवाघूळ. ");
INSERT INTO mar_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","जितके पंख असलेले कीटक प्राणी चार पायावर चालतात तितके परमेश्वराच्या दृष्टीने खाण्यास योग्य नाहीत; ते खाऊ नये! ");
INSERT INTO mar_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","परंतु पायावर चालणाऱ्या व पंख असलेल्या प्राण्यांपैकी ज्यांना जमिनीवर उड्या मारण्यासाठी पायाबरोबर तंगड्या असतात ते तुम्ही खावे. ");
INSERT INTO mar_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","त्याचप्रमाणे निरनिरळ्या जातीचे टोळ, निरनिरळ्या जातीचे नाकतोडे, निरनिरळ्या जातीचे खरपुडे व निरनिरळ्या जातीचे गवत्ये टोळ तुम्ही खावू शकता. ");
INSERT INTO mar_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","परंतु चार पायाचे पंख असलेले इतर प्राणी परमेश्वराच्या दृष्टीने ओंगळ आहेत ते खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","त्यांच्यामुळे तुम्ही अशुद्ध व्हाल; जो कोणी त्यांच्या शवांना स्पर्श करेल तो संध्याकाळपर्यंत अशुद्ध होईल; ");
INSERT INTO mar_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","जो कोणी मरण पावलेल्या कीटकांना उचलील, त्याने आपली वस्त्रे धुवावी व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ज्या प्राण्याचे खूर दुभागलेले आहेत पण ते दोन अगदी सारखे भाग करीत नाहीत व जे रवंथ करीत नाहीत ते तुम्ही अशुद्ध समजावेत; ");
INSERT INTO mar_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","चार पायावर चालणाऱ्या सर्व पशूपैकी जे आपल्या पंजावर चालतात ते सर्व तुम्ही अशुद्ध समजावे; त्याचा शवांना जो कोणी स्पर्श करेल त्याने संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","जो कोणी त्यांची शवे उचलील त्याने आपली वस्त्रे धुवून संध्याकाळपर्यंत अशुद्ध रहावे; ते प्राणी तुम्ही अशुद्ध समजावे. ");
INSERT INTO mar_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","जमिनीवर रांगणाऱ्या प्राण्यांपैकी तुम्ही अशुद्ध समजावे ते हे: मुंगूस, उंदीर, निरनिराळ्या जातीचे सरडे, ");
INSERT INTO mar_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","चोपई, घोरपड, पाल, सांडा व गुहिऱ्या सरडा. ");
INSERT INTO mar_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","हे प्राणी तुम्हाकरिता अशुद्ध समजावे. त्यांच्या शवांना जो कोणी स्पर्श करेल त्याने संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","त्यांच्यापैकी कोणी मरून एखाद्या वस्तूवर पडला तर ती वस्तूही अशुद्ध समजावी; लाकडी पात्र, वस्त्र कातडे, तरट किंवा कोणत्याही कामाचे हत्यार असो, ते पाण्यात टाकावे व संध्याकाळपर्यंत अशुद्ध समजावे; मग ते धुतल्यावर शुद्ध समजावे. ");
INSERT INTO mar_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","त्यांच्यापैकी एखादा मरुन मातीच्या पात्रात पडला तर त्या पात्रात जे काही असेल ते अशुद्ध समजावे व ते पात्र फोडून टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","अशुद्ध भांड्याचे पाणी अन्नावर पडल्यास ते अन्नही अशुद्ध समजावे व अशा भांड्यातील कोणतेही पेय असेल तर तेही अशुद्ध समजावे. ");
INSERT INTO mar_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","त्यांच्या शवांचा एखादा भाग एखाद्या भट्टीवर किंवा चुलीवर पडला तर ती अशुद्ध समजून, तिचे तुकडे तुकडे करून ती मोडून तोडून टाकावी, ती पुन्हा शुद्ध होणार नाही; म्हणून तुम्ही ती अशुद्ध समजावी. ");
INSERT INTO mar_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","झरा किंवा विहीर, ज्यांच्यात सतत पाणी असते ते शुद्धच राहतात; परंतु त्याच्यातील शवांना जो स्पर्श करेल तो अशुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","त्या प्राण्याच्या शवाचा काही भाग पेरण्याच्या बियाणावर पडला तरी ते बियाणे शुद्ध समजावे; ");
INSERT INTO mar_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","परंतु जर बियाणे पाण्याने भिजल्यावर त्या प्राण्याच्या शवाचा काही भाग त्यावर पडला तर ते तुम्ही अशुद्ध समजावे. ");
INSERT INTO mar_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","खाण्यास योग्य अशा प्राण्यांपैकी एखादा मेला आणि त्याच्या शवास कोणी स्पर्श केला तर त्याने संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","कोणी त्याच्या शवाचा काही भाग खाल्ला तर त्याने आपली वस्त्रे धुवावी व संध्याकाळपर्यंत अशुद्ध रहावे; जो त्याचे शव उचलील त्यानेही आपली वस्त्रे धुवावी व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“जमिनीवर रांगणारे सर्व प्राणी अशुद्ध आहेत; परमेश्वराच्या सांगण्याप्रमाणे ते खाऊ नयेत. ");
INSERT INTO mar_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","जमिनीवर जे आपल्या पोटावर सरपटतात, किंवा चार पायावर चालतात, किंवा ज्यांना फार पाय आहेत असे सरपटणारे प्राणी तुम्ही खाऊ नयेत, कारण ते ओंगळ आहेत. ");
INSERT INTO mar_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","कोणत्याही जातीच्या रांगणाऱ्या प्राण्यामुळे तुम्ही स्वत:ला अशुद्ध करून घेऊ नका, किंवा त्यांच्यामुळे स्वत:ला अशुद्ध करून विटाळवू नका! ");
INSERT INTO mar_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","कारण मी परमेश्वर, तुमचा देव आहे! मी पवित्र आहे! म्हणून तुम्हीही आपणांस पवित्र असे ठेवावे! म्हणून जमिनीवर रांगणाऱ्या कोणत्याही जातीच्या प्राण्यामुळे तुम्ही आपणास विटाळवू नका! ");
INSERT INTO mar_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","मी परमेश्वर, ज्याने तुम्हास मिसर देशातून यासाठी बाहेर आणले की तुम्ही माझे पवित्र लोक व्हावे व मी तुमचा देव असावे; मी पवित्र आहे म्हणून तुम्हीही पवित्र असावे!” ");
INSERT INTO mar_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","प्राणी, पक्षी, सर्व जलचर व जमिनीवर रांगणारे सर्व प्राणी ह्याच्याविषयी हे नियम आहेत. ");
INSERT INTO mar_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","या नियमावरून शुद्ध प्राणी व अशुद्ध प्राणी, तसेच खाण्यास योग्य असे प्राणी व जे खाऊ नयेत असे प्राणी ह्याच्यातील भेद तुम्हास समजावा. ");
INSERT INTO mar_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","इस्राएल लोकांस सांग, जर स्त्री गर्भवत होऊन तिला मुलगा झाला तर तिने सात दिवस अशुद्ध रहावे; मासिक पाळीच्या वेळी जशी ती असते तशीच ती अशुद्ध समजावी. ");
INSERT INTO mar_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","आठव्या दिवशी त्या मुलाची सुंता करावी. ");
INSERT INTO mar_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","नंतर त्या स्त्रीला आपल्या रक्त स्त्रावापासून शुद्ध होण्यासाठी तेहतीस दिवस लागतील; त्या मुदतीत तिने कोणत्याही पवित्र वस्तुला शिवू नये व पवित्रस्थानात जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","परंतु जर तिला मुलगी झाली तर मासिक पाळीच्या काळात जशी ती असते तसेच तिने चौदा दिवस अशुद्ध रहावे; तिला आपल्या रक्त स्त्रावापासून शुद्ध होण्यासाठी सहासष्ट दिवस लागतील. ");
INSERT INTO mar_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","तिला मुलगा किंवा मुलगी झाल्यावर तिची शुद्धी होण्याची वेळ पूर्ण झाली म्हणजे तिने होमार्पणासाठी एक वर्षाचे कोकरु आणि पापार्पणासाठी पारव्याचे पिलू किंवा होला आणून दर्शनमंडपापाशी याजकाकडे द्यावीत. ");
INSERT INTO mar_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","मग याजकाने ते परमेश्वरासाठी अर्पून तिच्यासाठी प्रायश्चित करावे म्हणजे ती आपल्या रक्तस्त्रावापासून शुद्ध होईल; मुलगा किंवा मुलगी झालेल्या स्त्री विषयी हे नियम आहेत. ");
INSERT INTO mar_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","तिला कोकरु अर्पिण्याची ऐपत नसेल तर तिने दोन होले किंवा पारव्याची दोन पिल्ले, एक होमार्पणासाठी व दुसरा एक पापार्पणासाठी आणावी मग याजकाने तिच्यासाठी प्रायश्चित करावे म्हणजे ती शुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","परमेश्वर मोशे व अहरोन यांना म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","एखाद्या मनुष्याच्या अंगावरील कातडीला सूज, खवंद किंवा तकतकीत डाग असेल व तो महारोगाच्या चट्ट्यासारखा दिसत असेल तर त्यास अहरोन याजकाकडे किंवा त्याच्या याजक मुलांपैकी एकाकडे न्यावे. ");
INSERT INTO mar_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","मग याजकाने त्याच्या अंगाच्या कातडीवरील तो चट्टा तपासावा व त्या चट्ट्यावरील केस पांढरे झाले असल्यास व तो चट्टा कातडीपेक्षा खोल गेलेला दिसल्यास तो महारोगाचा चट्टा समजावा; मग त्या मनुष्याची तपासणी झाल्यावर याजकाने त्यास अशुद्ध ठरवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","त्या मनुष्याच्या अंगाच्या कातडीवरील डाग पांढरा असेल पण त्याच्या कातडीपेक्षा तो खरोखर खोल गेलेला नसेल व त्यावरील केस पांढरे झालेले नसतील तर याजकाने त्या चट्टा पडलेल्या मनुष्यास सात दिवस इतर मनुष्यापासून वेगळे एकटे ठेवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","सातव्या दिवशी याजकाने परत त्याची तपासणी करावी आणि तो चट्टा जसाच्या तसाच असून कातडीत पसरला नाही असे त्यास दिसून आले तर याजकाने त्यास आणखी सात दिवस इतरापासून वेगळे ठेवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","सातव्या दिवसानंतर याजकाने पुन्हा त्याची तपासणी करावी आणि चट्टा जर बुजत चालला असेल व तो कातडीत पसरला नसेल तर याजकाने त्यास शुद्ध ठरवावे; ते साधे खवंद होय; त्या मनुष्याने आपली वस्त्रे धुवावी आणि पुन्हा शुद्ध व्हावे. ");
INSERT INTO mar_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","परंतु त्या मनुष्याने स्वत:ला शुद्ध ठरवण्यासाठी याजकाला दाखविल्यानंतर त्याच्या कातडीवरील ते खवंद पसरत गेले असेल तर मग त्याने पुन्हा याजकापुढे हजर व्हावे. ");
INSERT INTO mar_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","याजकाने त्याची तपासणी करावी आणि ते खवंद कातडीत पसरल्याचे दिसून आल्यास त्याने त्यास अशुद्ध ठरवावे; तो महारोग होय. ");
INSERT INTO mar_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","एखाद्या मनुष्यास महारोगाचा चट्टा असेल तर त्यास याजकाकडे न्यावे. ");
INSERT INTO mar_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","याजकाने त्यास तपासावे; आणि जर त्याच्या कातडीच्या पांढऱ्या चट्ट्यावर सूज आली असेल व तेथील केस पांढरे झाले असतील व सुजेच्या जागेवरील मांस हुळहुळे झाले असेल तर ");
INSERT INTO mar_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","त्याच्या कातडीतला तो जुनाट महारोग होय; याजकाने त्यास अशुद्ध ठरवावे; अधिक तपासणीसाठी त्यास काही काळासाठी इतरापासून वेगळे ठेवू नये, कारण तो अशुद्धच आहे. ");
INSERT INTO mar_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","एखाद्या मनुष्याच्या कातडीला कोड फुटून तो डोक्यापासून पायापर्यंत अंगभर सर्व कातडीवर पसरला असेल तर याजकाने त्यास अंगभर तपासावे, ");
INSERT INTO mar_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","याजकाने त्याची तपासणी करावी त्याचा कोड अंगभर पसरल्याचे त्यास दिसून आले तर त्याने त्यास शुद्ध ठरवावे; त्याचे सर्व अंग पांढरे झाले आहे म्हणजे तो शुद्ध आहे. ");
INSERT INTO mar_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","पण त्याच्या अंगावर काही मांस कोवळे असेल तर तो अशुद्ध समजावा. ");
INSERT INTO mar_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","याजकाने कोवळे मांस पाहून त्यास अशुद्ध ठरवावे; असले कोवळे मांस अशुद्धच असते; तो महारोग होय. ");
INSERT INTO mar_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","परंतु ते कोवळे मांस जर परत पांढरे झाले तर त्याने परत याजकाकडे यावे; ");
INSERT INTO mar_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","याजकाने पुन्हा त्यास तपासावे आणि जर त्याचा चट्टा परत पांढरा झाला असेल तर त्याने त्या मनुष्यास शुद्ध ठरवावे; तो शुद्ध आहे. ");
INSERT INTO mar_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","कोणाच्या कातडीला फोड येऊन तो बरा झाला ");
INSERT INTO mar_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","व फोडाच्या जागी पांढरी सूज आली किंवा पांढरा तकतकीत लाल रेषा असलेला डाग पडला तर त्याने तो याजकाला दाखवावा. ");
INSERT INTO mar_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","याजकाने त्यास तपासावे आणि जर ती जागा कातडीपेक्षा खोल गेलेली दिसली व त्यावरील केस पांढरे झाले असले तर त्याने त्यास अशुद्ध ठरवावे; फोडातून बाहेर पडलेला हा महारोगाचा चट्टा आहे. ");
INSERT INTO mar_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","पण तपासणी केल्यावर त्यावरचे केस पांढरे झालेले नाहीत व ती जागा कातडीपेक्षा खोल गेलेली नाही तसेच ती बुजून पुसट होत चाललेली आहे असे याजकाला दिसून आले तर त्याने त्यास सात दिवस वेगळे ठेवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","त्यानंतर तो कातडीवर पसरत गेला आहे असे दिसले तर याजकाने त्या मनुष्यास अशुद्ध ठरवावे; तो चट्टा आहे. ");
INSERT INTO mar_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","पण तो तकतकीत डाग तेथल्या तेथेच राहून पसरला नाहीतर तो फोडाचा वण आहे, म्हणून याजकाने त्या मनुष्यास शुद्ध ठरवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","एखाद्याच्या कातडीत जळाल्याचा वण असेल व त्या वणाच्या कोवळ्या मांसात तांबूस-पांढरा किंवा पांढरा डाग दिसून येईल. ");
INSERT INTO mar_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","तर याजकाने त्यास तपासावे; त्या तकतकीत डागावरील केस पांढरे झाले असतील व कातडीपेक्षा ती जागा खोल गेलेली दिसत असेल तर त्या जळलेल्या जागी महारोग फुटला आहे; मग याजकाने त्यास अशुद्ध ठरवावे; तो महारोगाचा चट्टा होय. ");
INSERT INTO mar_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","परंतू तपासल्यावर त्या डागावरचे केस पांढरे झालेले नाहीत व ती जागा कातडीपेक्षा खोल गेलेली नाही आणि ती पुसट होत चालली आहे असे याजकाला दिसून आले तर त्याने त्यास सात दिवस वेगळे ठेवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","सातव्या दिवशी त्याने त्यास तपासावे व त्याचा डाग कातडीवर पसरत गेला आहे असे दिसले तर याजकाने त्या मनुष्यास अशुद्ध ठरवावे; तो महारोगाचा चट्टा होय; ");
INSERT INTO mar_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","परंतु तो डाग तेथल्या तेथेच असून कातडीवर पसरला नाही व तो पुसट होत चालला आहे असे दिसून आल्यास ती जळलेल्या जागेची सूज आहे म्हणून याजकाने त्यास शुद्ध ठरवावे; तो त्या जळलेल्या जागेवरचा वण होय. ");
INSERT INTO mar_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","एखाद्या पुरुषाच्या किंवा स्त्रीच्या डोक्यावर किंवा हनुवटीवर चट्टा असला, ");
INSERT INTO mar_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","तर याजकाने त्याची तपासणी करावी आणि ती जागा कातडीपेक्षा खोल दिसली व तिच्यावर काही पिंगट बारीक केस असले तर त्याने त्या व्यक्तीला अशुद्ध ठरवावे; ही चाई म्हणजे तो डोक्याचा किंवा हनुवटीचा महारोग होय. ");
INSERT INTO mar_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","तो चाईचा चट्टा कातडीपेक्षा खोल नसला व त्याच्यावर काळे केस नसले तर चाईचा चट्टा असलेल्या व्यक्तीला याजकाने सात दिवस वेगळे ठेवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातव्या दिवशी याजकाने त्या चट्ट्याची तपासणी करावी; ती चाई पसरली नाही, त्या जागी पिंगट केस नाहीत व ती जागा कातडीपेक्षा खोल गेलेली दिसली नाही, ");
INSERT INTO mar_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","तर त्या मनुष्याने आपल्या डोक्याचे केस काढावेत; पण चाईवरचे केस काढू नयेत; याजकाने चाई असलेल्या त्या मनुष्यास आणखी सात दिवस वेगळे ठेवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","सातव्या दिवशी याजकाने ती चाई पुन्हा तपासून पाहावी आणि चाई कातडीवर पसरलेली नसली व कातडीपेक्षा ती खोल गेलेली नसली तर याजकाने त्यास शुद्ध ठरवावे; त्या मनुष्याने आपले कपडे धुवावे व शुद्ध व्हावे. ");
INSERT INTO mar_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","परंतु तो शुद्ध ठरल्यानंतर ती चाई पसरत गेली ");
INSERT INTO mar_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","तर याजकाने त्यास तपासावे व ती चाई कातडीवर पसरलेली दिसली तर पिंगट केस शोधीत न बसता त्या मनुष्यास अशुद्ध ठरवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","परंतु ती चाई होती तेवढीच असेल व तिच्यावर काळे केस येत आहेत असे त्यास दिसून आले तर ती चाई बरी झाली आहे व तो मनुष्य शुद्ध झाला आहे; याजकाने त्यास शुद्ध ठरवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","कोणा पुरुषाच्या किंवा स्त्रीच्या अंगावर पांढरे डाग असतील. ");
INSERT INTO mar_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","तर याजकाने ते तपासावे व त्या व्यक्तीच्या अंगावरील ते डाग करडे असतील तर ती कातडीवर फुटलेली दाद होय. ती व्यक्ती शुद्ध होय. ");
INSERT INTO mar_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","कोणा मनुष्याचे केस गळून पडू लागले तर ते केवळ टक्कल आहे; तो मनुष्य शुद्ध होय. ");
INSERT INTO mar_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","त्याच्या डोक्याच्या बाजूचे केस गळू लागले तरी ते एक प्रकारचे टक्कल होय; तो मनुष्य शुद्ध आहे. ");
INSERT INTO mar_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","परंतु त्या टक्कल पडलेल्या डोक्यावरील चामडीवर तांबूस पांढरा चट्टा पडलेला असेल तर त्याच्या डोक्यावर महारोग फुटत आहे. ");
INSERT INTO mar_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","मग याजकाने त्यास तपासावे आणि त्याच्या टक्कल पडलेल्या डोक्याच्या भागावर, अंगावरील कातडीच्या महारोगासारखा तांबूस पांढरा चट्टा पडलेला असल्याचे दिसले, ");
INSERT INTO mar_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","तर त्या मनुष्याच्या डोक्यावर पडलेला चट्टा महारोगाचा होय; तो मनुष्य अशुद्ध होय; याजकाने त्यास अशुद्ध ठरवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","ज्या मनुष्यास महारोग झालेला आहे त्याचे कपडे फाटके असावे; त्याने आपले केस मोकळे सोडावे, आपले तोंड झाकावे व इतर लोकांस इशारा देण्यासाठी अशुद्ध, अशुद्ध असे ओरडत जावे. ");
INSERT INTO mar_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","जोपर्यंत त्याच्या अंगावर चट्टा असेल तितक्या दिवसापर्यंत त्याने अशुद्ध रहावे; तो अशुद्ध होय; त्याने एकटे रहावे; त्याची वस्ती छावणीबाहेर असावी. ");
INSERT INTO mar_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“एखाद्या लोकरीच्या किंवा सणाच्या वस्त्राला महारोगाचा चट्टा पडला, ");
INSERT INTO mar_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","किंवा तो सणाच्या किंवा लोकरीच्या ताण्याला किंवा बाण्याला, चमड्याला किंवा चामड्याच्या वस्तुला पडला. ");
INSERT INTO mar_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","आणि त्या वस्त्राला, त्याच्या ताण्याला किंवा त्याच्या बाण्याला अथवा चामड्याला किंवा चामड्याच्या कोणत्याही वस्तूचा चट्टा हिरवट किंवा तांबूस असला तर तो महारोगाचा चट्टा होय; तो याजकाला दाखवावा. ");
INSERT INTO mar_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","याजकाने तो चट्टा तपासावा; चट्टा पडलेली ती वस्तू त्याने सात दिवस वेगळी करून ठेवावी. ");
INSERT INTO mar_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","त्याने सातव्या दिवशी तो चट्टा तपासावा आणि चामड्यावर किंवा वस्त्राचा ताण्यावर किंवा बाण्यावर अथवा चामड्याच्या कोणत्याही वस्तूवर तो चट्टा पसरलेला दिसला तर ते वस्त्र किंवा चामडे अशुद्ध आहे, चरत जाणारे कुष्ठ आहे. ");
INSERT INTO mar_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ते वस्त्र लोकरीचे असो किंवा सणाचे असो त्याच्या ताण्यावर किंवा बाण्यावर, तसेच चामड्यावर किंवा चामड्याच्या एखाद्या वस्तूवर तो चट्टा असला तर याजकाने ते वस्त्र किंवा चामडे जाळून टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","परंतु तो चट्टा पसरला नाही असे याजकाला दिसून आले तर ते वस्त्र किंवा चामडे अवश्य धुतले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","याजकाने लोकांस ते वस्त्र किंवा चामडे धुण्यास सांगावे. मग धुवून झाल्यावर ते त्याने आणखी सात दिवस वेगळे ठेवावे. ");
INSERT INTO mar_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","त्यानंतर याजकाने पुन्हा त्याची तपासणी करावी, आणि जर तो आहे तसाच असला व जरी पसरलेला नसला तरी तो अशुद्ध समजावा आणि ते वस्त्र किंवा चामडे अग्नीत जाळून टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","परंतु धुतल्यावर तो चट्टा पुसट झाला आहे असे याजकाला दिसून आले तर त्याने त्या वस्त्राचा किंवा चामड्याचा अथवा ताण्याचा किंवा बाण्याचा भाग फाडून टाकावा. ");
INSERT INTO mar_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","इतके केल्यावरही जर त्या वस्त्रावर, त्याच्या ताण्यावर किंवा बाण्यावर अथवा चामड्याच्या कोणत्याही वस्तूवर तो चट्टा पुन्हा आला तर तो चट्टा चरत व पसरत आहे असे समजून ते चामडे किंवा वस्त्र अवश्य जाळून टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","परंतु तो चट्टा धुतल्यानंतर पुन्हा आला नाही तर ते चामडे किंवा वस्त्र शुद्ध समजावे, ते शुद्ध आहे.” ");
INSERT INTO mar_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","लोकरीच्या किंवा सणाच्या वस्त्रावर, त्याच्या ताण्यावर किंवा बाण्यावर अथवा चामड्याच्या कोणत्याही वस्तूवर महारोगाचा चट्टा दिसून आला तर ती शुद्ध किंवा अशुद्ध ठरविण्याचे हे नियम आहेत. ");
INSERT INTO mar_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","महारोग बरा झालेल्या लोकांस शुद्ध करून घेण्याविषयीचे नियम असे: याजकाने महारोग्याला तपासावे. ");
INSERT INTO mar_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","याजकाने छावणीच्या बाहेर जाऊन त्या महारोग्याला तपासावे व त्याचा महारोग बरा झाला आहे किंवा नाही ते पाहावे. ");
INSERT INTO mar_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","तो बरा झाला असल्यास याजकाने त्यास शुद्ध होण्यासाठी दोन जिवंत शुद्ध पक्षी, गंधसरूचे लाकूड, किरमिजी रंगाचे कापड व एजोब झाडाची फांदी घेऊन येण्यास सांगावे. ");
INSERT INTO mar_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","मग वाहत्या पाण्यावर मातीच्या पात्रात त्यातला एक पक्षी मारण्याची याजकाने आज्ञा द्यावी. ");
INSERT INTO mar_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","याजकाने जिवंत पक्षी, गंधसरुचे लाकूड, किरमिजी रंगाचे कापड व एजोब ही सामग्री घेऊन जिवंत पक्षासह वाहत्या पाण्यावर मारलेल्या पक्ष्याच्या रक्तात बुडवावी; ");
INSERT INTO mar_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","आणि ते रक्त महारोगापासून शुद्ध ठरवावयाच्या मनुष्यावर सात वेळा शिंपडावे; मग तो शुद्ध झाला आहे असे सांगावे व त्यानंतर याजकाने माळरानात जाऊन त्या जिवंत पक्ष्यास सोडून द्यावे. ");
INSERT INTO mar_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","मग शुद्ध ठरवावयाच्या मनुष्याने आपले कपडे धुवावे, आपले मुंडन करून घ्यावे आणि पाण्याने स्नान करावे म्हणजे तो शुद्ध ठरेल; त्यानंतर त्याने छावणीत यावे; तरी त्याने सात दिवस आपल्या तंबूबाहेर रहावे; ");
INSERT INTO mar_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातव्या दिवशी त्याने आपले डोके, दाढी, भुवया व अंगावरील एकंदर सर्व केस मुंडवावे; आपले कपडे धुवावे व पाण्याने स्नान करावे, म्हणजे तो शुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","आठव्या दिवशी त्या मनुष्याने दोन निर्दोष कोकरे, एक वर्षाची निर्दोष मेंढी, अन्नार्पणासाठी तेलात मळलेला तीन दशांश एफा मैदा, व एक लोगभर तेल ही सामग्री याजकाकडे आणावी; ");
INSERT INTO mar_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","आणि शुद्ध ठरविणाऱ्या याजकाने शुद्ध ठरवणाऱ्या मनुष्यास, त्या अर्पण करावयाच्या सामग्रीसह परमेश्वरासमोर दर्शनमंडपाच्या दारापाशी उभे करावे. ");
INSERT INTO mar_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","मग याजकाने दोषार्पणासाठी एक कोकरु व एक लोगभर तेल अर्पावे; ते ओवाळणीचे अर्पण म्हणून परमेश्वरासमोर ओवाळावे; ");
INSERT INTO mar_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","मग याजकाने पवित्रस्थानात जेथे पापबली व होमबली ह्यांचा वध करतात तेथे ते कोकरु वधावे कारण पापबली प्रमाणेच दोषार्पणावरही याजकाचा हक्क आहे; हे अर्पण परमपवित्र आहे. ");
INSERT INTO mar_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","मग याजकाने दोषार्पणाचे काही रक्त घेऊन शुद्ध ठरवावयाच्या मनुष्याच्या उजव्या कानाच्या पाळीला, उजव्या हाताच्या अंगठ्याला व उजव्या पायाच्या अंगठ्याला लावावे. ");
INSERT INTO mar_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","याजकाने लोगभर तेलातले थोडेस तेल आपल्या डाव्या तळहातावर ओतावे; ");
INSERT INTO mar_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","मग याजकाने आपल्या उजव्या हाताचे बोट आपल्या डाव्या तळहातावरील तेलात बुडवून त्यातले काही परमेश्वरासमोर सात वेळा बोटाने शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","त्याच्या तळहातावर जे तेल उरेल त्यातले काही घेऊन याजकाने शुद्ध ठरवावयाच्या मनुष्याच्या उजव्या कानाच्या पाळीवरील, उजव्या हाताच्या अंगठ्यावरील व उजव्या पायाच्या अंगठ्यावरील दोषार्पणाच्या रक्तावर लवावे. ");
INSERT INTO mar_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","तळहातावर उरलेले तेल याजकाने शुद्ध ठरवावयाच्या मनुष्याच्या डोक्याला लावावे आणि अशा प्रकारे त्या मनुष्यासाठी याजकाने परमेश्वरासमोर प्रायश्चित करावे. ");
INSERT INTO mar_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","मग याजकाने पापबली अर्पावा आणि अशुद्ध झालेल्या मनुष्याच्या शुद्धतेसाठी प्रायश्चित करावे; त्यानंतर त्याने होमबलीचा वध करावा; ");
INSERT INTO mar_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","मग याजकाने होमबली व अन्नबली वेदीवर अर्पून त्या मनुष्यासाठी प्रायश्चित करावे म्हणजे तो शुद्ध ठरेल. ");
INSERT INTO mar_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","परंतु तो मनुष्य गरीब असून एवढे आणण्याची त्यास ऐपत नसेल तर त्याने आपल्या प्रायश्चितासाठी ओवाळणीचे एक कोकरु दोषार्पण म्हणून आणावे आणि अन्नार्पणासाठी तेलात मळलेला, एक दशांश एफा मैदा आणि एक लोगभर तेल आणावे; ");
INSERT INTO mar_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","आणि ऐपतीप्रमाणे दोन होले किंवा पारव्याची दोन पिल्ले त्याने आणावी; त्यातील एक पापबली व एक होमबली व्हावा. ");
INSERT INTO mar_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","आठव्या दिवशी आपल्या शुद्धीकरणासाठी त्यानेही सामग्री घेऊन दर्शनमंडपाच्या दारापाशी याजकाकडे परमेश्वरासमोर जावे. ");
INSERT INTO mar_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","मग याजकाने ते दोषार्पणाचे कोकरू व लोगभर तेल घेऊन ओवाळणीचे अर्पण म्हणून परमेश्वरासमोर ओवाळावे. ");
INSERT INTO mar_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","त्यानंतर याजकाने दोषार्पणाच्या कोकराचा वध करावा आणि त्याने त्या कोकऱ्याचे काही रक्त घेऊन शुद्ध ठरवावयाच्या व्यक्तीच्या उजव्या कानाच्या पाळीला, उजव्या हाताच्या अंगठ्याला व उजव्या पायाच्या अंगठ्यांला लावावे. ");
INSERT INTO mar_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","याजकाने त्या तेलातले काही आपल्या डाव्या तळहातावर ओतावे; ");
INSERT INTO mar_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","मग याजकाने उजव्या हाताच्या बोटाने त्यातील काही तेल परमेश्वरासमोर सात वेळा शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","मग याजकाने आपल्या तळहातावरील काही तेल घेऊन शुद्ध ठरवावयाच्या मनुष्याच्या उजव्या कानाच्या पाळीवर, उजव्या हाताच्या व उजव्या पायाच्या अंगठ्यांवर, दोषार्पणाचे रक्त लावलेल्या जागेवर लावावे. ");
INSERT INTO mar_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","याजकाने तळहातावर उरलेले तेल शुद्ध ठरवावयाच्या मनुष्याच्या डोक्याला परमेश्वरासमोर त्या मनुष्यासाठी प्रायश्चित म्हणून लावावे. ");
INSERT INTO mar_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","मग त्याच्या ऐपतीप्रमाणे त्यास मिळालेले होले किंवा पारव्याची पिल्ले ह्यांच्यापैकी एकाचे त्याने अर्पण करावे. ");
INSERT INTO mar_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","त्यांच्यापैकी एकाचे पापार्पण करावे व दुसऱ्याचे होमार्पण करावे; पक्ष्यांची ही अर्पणे त्याने अन्नार्पणासहीत करावी; ह्याप्रकारे याजकाने शुद्ध ठरवावयाच्या मनुष्याकरिता परमेश्वरासमोर प्रायश्चित करावे; मग तो मनुष्य शुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","अंगावरील महारोगाचा चट्टा बरा झालेल्या मनुष्यास आपल्या शुद्धीकरणासाठी साहित्य मिळण्याची ऐपत नसलेल्या मनुष्याच्या शुद्धीकरणासंबंधी हे नियम आहेत. ");
INSERT INTO mar_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","परमेश्वर मोशे व अहरोन ह्याना असेही म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","कनान देश मी तुम्हास वतन म्हणून देत आहे. तुमचे लोक त्यामध्ये जाऊन पोहोंचतील त्यावेळी तुमच्या वतनाच्या देशातील एखाद्या घराला मी महारोगाचा चट्टा पाडला, ");
INSERT INTO mar_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","तर त्या घराच्या मालकाने याजकाला जाऊन सांगावे की, माझ्या घरात चट्ट्यासारखे काहीतरी दिसते. ");
INSERT INTO mar_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","मग याजकाने लोकांस घर रिकामे करण्याची आज्ञा द्यावी; लोकांनीही घरातील सर्व वस्तू याजक, चट्टा तपासण्यासाठी घरात जाण्याच्या अगोदर बाहेर काढाव्या नाहीतर घरातील सर्व वस्तू अशुद्ध समजाव्या. मग याजकाने रिकाम्या घरात जाऊन ते तपासावे. ");
INSERT INTO mar_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","तो चट्टा त्याने तपासावा, आणि घराच्या भिंतीवर हिरवट किंवा तांबूस रंगाची छिद्रे किंवा खळगे असतील व ती भिंतीच्या पृष्ठभागाच्या आत गेली असतील. ");
INSERT INTO mar_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","तर मग याजकाने घराबाहेर दारापाशी यावे व ते घर सात दिवस बंद करून ठेवावे. ");
INSERT INTO mar_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","मग सातव्या दिवशी याजकाने पुन्हा जाऊन ते घर तपासावे आणि तो चट्टा घराच्या भिंतीवर पसरला असल्यास, ");
INSERT INTO mar_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","चट्टा असलेले दगड काढून नगराबाहेर एखाद्या अशुद्ध जागी टाकून देण्याची याजकाने लोकांस आज्ञा द्यावी. ");
INSERT INTO mar_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","मग याजकाने घर लोकांकडून आतून खरडवून घ्यावे आणि खरडवून काढलेला चुना नगराबाहेर अशुद्ध ठिकाणी लोकांनी टाकून द्यावा. ");
INSERT INTO mar_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","त्या मनुष्याने त्या दगडांच्या ऐवजी भिंतीत दुसरे दगड बसवावे आणि त्या घराला नव्या चुन्याचा गिलावा करावा. ");
INSERT INTO mar_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","जुने दगड काढून नवीन दगड बसविल्यावर व घर खरडवून नवीन गिलावा केल्यावर जर तो चट्टा घरात पुन्हा उद्भवला. ");
INSERT INTO mar_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","तर याजकाने आत जाऊन तो तपासावा; घरात तो चट्टा पसरला असल्यास तो घरात चरत जाणारा महारोगाचा चट्टा होय; ते घर अशुद्ध आहे. ");
INSERT INTO mar_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","मग त्या मनुष्याने ते घर खणून पाडावे; त्याचे दगड, लाकूड व सगळा चुना त्याने तेथून काढून नगराबाहेर एखाद्या अशुद्ध ठिकाणी फेकून द्यावा. ");
INSERT INTO mar_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","आणि घर बंद असताना त्यामध्ये कोणी शिरला तर त्याने संध्याकाळपर्यंत अशुद्ध रहावे; ");
INSERT INTO mar_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","त्या घरात कोणी काही खाल्ले किंवा कोणी त्या घरात निजला तर त्याने आपले कपडे धुवावे. ");
INSERT INTO mar_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","घराला नवीन दगड बसविल्यावर व नवीन गिलावा केल्यावर याजकाने आत जाऊन ते घर तपासावे आणि घरात चट्टा परत उद्भवला नसेल तर त्या घरातला चट्टा गेल्यामुळे त्याने ते शुद्ध ठरवावे. ");
INSERT INTO mar_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","त्या घराच्या शुद्धीकरणासाठी दोन पक्षी, गंधसरुचे लाकूड, किरमिजी रंगाचे कापड व एजोब ही त्याने आणावी; ");
INSERT INTO mar_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","त्याने एक पक्षी वाहत्या पाण्यावर मातीच्या पात्रात मारावा; ");
INSERT INTO mar_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","मग त्याने गंधसरुचे लाकूड, एजोब, किरमिजी रंगाचे कापड व जिवंत पक्षी घेऊन त्या मारलेल्या पक्ष्याच्या रक्तात व वाहत्या पाण्यात बुडवून त्या घरावर सात वेळा शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","त्या पक्ष्याचे रक्त, वाहते पाणी, तो जिवंत पक्षी, गंधसरूचे लाकूड, एजोब, आणि किरमिजी रंगाचे कापड ह्याप्रकारे याजकाने ते घर शुद्ध करावे. ");
INSERT INTO mar_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","मग त्याने तो जिवंत पक्षी नगराबाहेर जाऊन माळरानात सोडून द्यावा; ह्याप्रकारे त्याने घरासाठी प्रायश्चित केले म्हणजे ते शुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","सर्व प्रकारचे महारोगाचे चट्टे, चाई, ");
INSERT INTO mar_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","कपड्यावरील किंवा घराचा महारोग, ");
INSERT INTO mar_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","सूज, खवंद, तकतकीत डाग या सर्वासंबधीचे हे नियम आहेत; ");
INSERT INTO mar_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","हे केव्हा शुद्ध व केव्हा अशुद्ध हे ठरविण्याविषयी शिकवतात; हे महारोगासंबंधीचे नियम आहेत. ");
INSERT INTO mar_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","परमेश्वर मोशे व अहरोन ह्यांना आणखी म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","इस्राएल लोकांस सांगा की एखाद्या पुरुषाच्या शरीरातून स्त्राव होत असल्यास तो पुरुष अशुद्ध होय. ");
INSERT INTO mar_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","त्याचा स्त्राव वाहत असो किंवा बंद पडो, ती त्याची अशुद्धताच होय. ");
INSERT INTO mar_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","स्त्राव होणारा मनुष्य ज्या बिछान्यावर झोपेल तो अशुद्ध होय आणि ज्या वस्तूवर तो बसेल तीही अशुद्ध होय. ");
INSERT INTO mar_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","जो कोणी त्याच्या बिछान्याला स्पर्श करेल त्याने आपले कपडे धुवावे, पाण्याने स्नान करावे व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","स्त्राव होणारा मनुष्य बसलेल्या वस्तूवर कोणी बसेल तर त्याने आपले कपडे धुवावे, पाण्याने स्नान करावे व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","स्त्राव होणाऱ्या मनुष्याच्या अंगाला जर कोणी स्पर्श केला तर त्याने आपले कपडे धुवावे, पाण्याने स्नान करावे व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","स्त्राव होणारा मनुष्य जर एखाद्या शुद्ध मनुष्यावर थुंकला तर त्या शुद्ध मनुष्याने आपले कपडे धुवावे, पाण्याने स्नान करावे व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","स्त्राव होणारा मनुष्य ज्या खोगीराचा उपयोग करील ते खोगीर अशुद्ध होय. ");
INSERT INTO mar_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","त्याच्या अंगाखालच्या कोणत्याही वस्तुला कोणी स्पर्श केला तर त्याने संध्याकाळपर्यंत अशुद्ध रहावे, व त्या वस्तू जो उचलील त्याने आपले कपडे धुवावे, पाण्याने स्नान करावे आणि संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","स्त्राव होणारा मनुष्य पाण्याने हात न धुता कोणाला स्पर्श केला तर त्या दुसऱ्या मनुष्याने आपले कपडे धुवावे, पाण्याने स्नान करावे व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","परंतु स्त्राव होणारा मनुष्य एखाद्या मातीच्या पात्राला स्पर्श केला तर ते पात्र फोडून टाकावे, मात्र प्रत्येक लाकडी पात्र पाण्याने धुवावे. ");
INSERT INTO mar_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","स्त्राव होणारा मनुष्य आपल्या स्त्रावापासून बरा झाल्यावर त्याने आपल्या शुद्धीकरणासाठी सात दिवस थांबावे आणि मग आपले कपडे धुऊन वाहत्या पाण्यात आपले अंग धुवावे म्हणजे तो शुद्ध ठरेल. ");
INSERT INTO mar_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठव्या दिवशी त्याने दोन होले किंवा पारव्याची दोन पिल्ले घेऊन दर्शनमंडपाच्या दारापाशी परमेश्वरासमोर जावे व याजकाकडे ती द्यावी. ");
INSERT INTO mar_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","मग याजकाने त्यातील एकाचे पापार्पण व दुसऱ्याचे होमार्पण करावे आणि त्या मनुष्याच्या स्त्रावाबद्दल परमेश्वरासमोर त्याच्यासाठी प्रायश्चित करावे. ");
INSERT INTO mar_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","एखाद्या पुरुषाचा वीर्यपात झाला तर त्याने आपले सर्वांग पाण्याने धुवून संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ज्या कपड्याला किंवा चामड्याला वीर्य लागले असेल तेही पाण्याने धुऊन संध्याकाळपर्यंत अशुद्ध समजावे. ");
INSERT INTO mar_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","स्त्री बरोबर निजला असताना पुरुषाचा वीर्यपात झाला तर त्या दोघांनी पाण्याने स्नान करावे व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","एखादी स्त्री ऋतुमती झाली तर तिने सात दिवस दूर बसावे; जो कोणी तिला स्पर्श करेल त्याने संध्याकाळपर्यंत अशुद्ध रहावे; ");
INSERT INTO mar_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ती दूर असेपर्यंत ज्यावर ती झोपेल वा बसेल तेही अशुद्ध होय. ");
INSERT INTO mar_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","जो कोणी तिच्या अंथरुणाला स्पर्श करेल, त्याने आपले कपडे धुवावे, पाण्याने स्नान करावे व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ती ज्यावर बसली असेल त्यास जो कोणी स्पर्श करेल त्याने आपले कपडे धुवावे, पाण्याने स्नान करावे व संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","तिच्या अंथरुणाला किंवा ज्यावर ती बसली असेल त्यास शिवणाऱ्याने संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","अशा स्त्रीबरोबर लैगिक संबंध केलेला पुरुषाने सात दिवस अशुद्ध रहावे व ज्या अंथरुणावर तो झोपेल तेही अशुद्ध समजावे. ");
INSERT INTO mar_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","एखाद्या स्त्रीचा ऋतुकाल नसताना जर अनेक दिवस तिला रक्तस्राव होत असेल किंवा मुदतीच्या बाहेर ती ऋतुमती राहिली तर तिचे स्त्रावाचे सर्व दिवस तिच्या ऋतुकालाच्या दिवसाप्रमाणे समजावे. ती अशुद्ध होय. ");
INSERT INTO mar_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","तिला स्त्राव होत असतानाच्या सर्व काळात ती ज्या अंथरुणावर झोपेल, ते अंथरुण तिच्या मासिक पाळीच्या वेळच्या अंथरुणाप्रमाणे समजावे. ती ज्यावर बसेल ती प्रत्येक गोष्ट तिच्या मासिक पाळीच्या काळात अशुद्ध असते. तशी अशुद्ध समजावी. ");
INSERT INTO mar_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","जर कोणी त्या वस्तूंना स्पर्श करेल तर तो अशुद्ध होईल. त्याने आपले कपडे धुवावे, पाण्याने स्नान करावे आणि संध्याकाळपर्यंत अशुद्ध रहावे. ");
INSERT INTO mar_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","त्या स्त्रीचा स्त्राव बंद झाल्यावर तिने सात दिवस थांबावे; त्यानंतर ती शुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","मग आठव्या दिवशी तिने दोन होले किंवा पारव्याची दोन पिल्ले घेऊन दर्शनमंडपाच्या दारापाशी याजकाकडे जावे. ");
INSERT INTO mar_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","मग याजकाने एकाचे पापार्पण व दुसऱ्याचे होमार्पण करावे. अशाप्रकारे याजकाने तिच्या अशुद्धतेकरिता परमेश्वरासमोर प्रायश्चित करावे. ");
INSERT INTO mar_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","ह्याप्रकारे तुम्ही इस्राएल लोकांस अशुद्धतेबद्दल बजावून ठेवावे; नाहीतर ते माझा पवित्र निवासमंडप भ्रष्ट करतील आणि मग त्याच्याबद्दल त्यांना मरावेच लागेल! ");
INSERT INTO mar_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","स्त्राव होऊन किंवा वीर्यपात होऊन जो पुरुष अशुद्ध होतो; ");
INSERT INTO mar_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","आणि जी स्त्री ऋतुमती होते आणि जो कोणी पुरुष, ऋतुमती असल्यामुळे अशुद्ध झालेल्या स्त्रीशी लैंगिक संबंध करून अशुद्ध होतो, त्यांच्या संबंधीचे हे नियम आहेत. ");
INSERT INTO mar_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","अहरोनाचे दोन पुत्र परमेश्वरासमोर गेले असताना मरण पावले त्यानंतर परमेश्वर मोशेशी बोलला. ");
INSERT INTO mar_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","परमेश्वर मोशेला म्हणाला, “तुझा भाऊ अहरोन ह्याच्याशी बोल व त्यास सांग की: त्याने वाटेल त्यावेळी परमपवित्रस्थानात अंतरपटाच्या आत पवित्र कोशावर असलेल्या दयासनापुढे जाऊ नये; अहरोन जर तेथे जाईल तर तो मरेल, कारण तेथे दयासनावरील ढगात मी दर्शन देत असतो. ");
INSERT INTO mar_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","परमपवित्रस्थानात जाण्यापूर्वी अहरोनाने पापार्पणासाठी एक गोऱ्हा व होमार्पणासाठी एक मेंढा आणावा. ");
INSERT INTO mar_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","त्याने पाण्याने स्नान करावे मग तागाचा पवित्र सदरा व तागाचे चोळणे आपल्या अंगात घालावे; तागाच्या कमरपट्ट्याने आपली कंबर कसावी आणि तागाचा फेटा बांधावा; ही पवित्र वस्त्रे आहेत. ");
INSERT INTO mar_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","मग त्याने इस्राएलाच्या मंडळीकडून पापार्पणासाठी दोन बकरे व होमार्पणासाठी एक मेंढा घ्यावा. ");
INSERT INTO mar_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","अहरोनाने आपल्यासाठी पापार्पणाचा गोऱ्हा अर्पण करून स्वत:साठी व आपल्या घराण्यासाठी प्रायश्चित करावे. ");
INSERT INTO mar_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","त्यानंतर त्याने ते दोन बकरे घेऊन दर्शनमंडपाच्या दारापाशी परमेश्वरासमोर उभे करावेत. ");
INSERT INTO mar_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","अहरोनाने त्या दोन बकऱ्यावर चिठ्ठ्या टाकाव्या; एक चिठ्ठी परमेश्वरासाठी व दुसरी पाप वाहून नेणाऱ्या बकऱ्यासाठी ");
INSERT INTO mar_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ज्या बकऱ्यावर परमेश्वराच्या नावाची चिठ्ठी निघेल तो बकरा अहरोनाने पापार्पण म्हणून अर्पण करावा; ");
INSERT INTO mar_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","पाप वाहून नेण्यासाठी अशी चिठ्ठी निघालेला बकरा परमेश्वरासमोर जिवंत उभा करावा व त्याच्याद्वारे प्रायश्चित व्हावे म्हणून पाप वाहून नेण्यासाठी रानात सोडून द्यावा. ");
INSERT INTO mar_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","अहरोनाने आपल्यासाठी पापार्पणाच्या गोऱ्ह्याचे अर्पण करून स्वत:साठी व स्वत:च्या घराण्यासाठी प्रायश्चित करावे. म्हणजे त्याने स्वत:साठी गोऱ्हा पापार्पण म्हणून वधावा. ");
INSERT INTO mar_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","नंतर अहरोनाने परमेश्वरासमोर असलेल्या वेदीवरील निखाऱ्यांनी भरलेले धुपाटणे घ्यावे आणि कुटून बारीक केलेला ओंजळभर सुगंधी धूप अंतरपटामागील आतल्या खोलीत आणावा. ");
INSERT INTO mar_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","त्याने तो धूप परमेश्वरासमोर अग्नीवर, असा घालावा की त्याच्या धुराने साक्षपटावरील दयासन व्यापून टाकावे, म्हणजे तो मरणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","त्याचप्रमाणे त्याने गोऱ्ह्याचे काही रक्त घेऊन ते दयासनावर पूर्वेस बोटाने शिंपडावे आणि काही रक्त दयासनासमोर बोटाने सात वेळा शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","मग अहरोनाने लोकांसाठी आणलेला पापार्पणाचा बकरा वधावा; त्याचे रक्त अंतरपटाच्या आत घेऊन जावे आणि त्याने गोऱ्ह्याच्या रक्ताचे जसे केले तसेच बकऱ्याच्या रक्ताचे करावे म्हणजे ते दयासनावर व दयासनासमोर शिंपडावे. ");
INSERT INTO mar_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","आणखी त्याने इस्राएली लोकांची अशुद्धतेची कामे, त्यांची बंडखोरी व त्यांची सर्व पापे या सर्वांबद्दल परमपवित्रस्थानासाठी प्रायश्चित करावे; परमेश्वर त्यांच्यामध्ये जेथे वस्ती करतो त्या, लोकांच्या अशुद्धतेने व्याप्त असलेल्या दर्शनमंडपासाठीही त्याने तसेच करावे. ");
INSERT INTO mar_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","अहरोन प्रायश्चित करण्यासाठी परमपवित्रस्थानात प्रवेशकरण्यासाठी जाईल तेव्हा, तो स्वतःसाठी व स्वत:च्या घराण्यासाठी आणि इस्राएल लोकांसाठी प्रायश्चित करून बाहेर येईपर्यंत दर्शनमंडपामध्ये कोणीही नसावे व कोणीही तेथे जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","मग त्याने तेथून निघून परमेश्वरासमोरील वेदीपाशी जावे व तिच्यासाठी प्रायश्चित करावे, त्याने गोऱ्ह्याचे काही रक्त व बकऱ्याचे काही रक्त घेऊन त्या वेदीच्या चारही बाजूच्या शिंगांना लावावे. ");
INSERT INTO mar_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","मग त्याने काही रक्त घेऊन आपल्या बोटाने ते सात वेळा तिच्यावर शिंपडावे; अशा प्रकारे त्याने इस्राएली लोकांच्या अशुद्धतेपासून ती शुद्ध व पवित्र करावी. ");
INSERT INTO mar_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","जेव्हा परमपवित्रस्थान, दर्शनमंडप आणि वेदी ह्यांच्याकरता तो प्रायश्चित करणे संपवतो त्यानंतर त्याने तो जिवंत बकरा सादर करावा. ");
INSERT INTO mar_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","अहरोनाने आपले दोन्ही हात त्या जिवंत बकऱ्याच्या डोक्यावर ठेवून इस्राएली लोकांची सर्व पापे व अपराध ह्यांचा अंगिकार करावा; व ती त्या बकऱ्याच्या डोक्यावर ठेवून त्यास घेऊन जाण्यासाठी तयार असलेल्या मनुष्याच्या हाती रानात पाठवून द्यावे. ");
INSERT INTO mar_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","तेव्हा तो बकरा त्या लोकांच्या सर्व दुष्कर्मांचा भार घेऊन निर्जन रानात वाहून नेईल; त्या मनुष्याने त्या बकऱ्याला रानात सोडून द्यावे. ");
INSERT INTO mar_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","मग अहरोनाने पुन्हा दर्शनमंडपामध्ये जावे आणि परमपवित्रस्थानात जाण्यापूर्वी घातलेली तागाची वस्त्रे काढावी आणि त्याने ती तेथेच ठेवावीत. ");
INSERT INTO mar_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","मग त्याने एखाद्या पवित्र ठिकाणी पाण्याने आंघोळ करावी, आपली वस्त्रे घालावी व तेथून बाहेर येऊन स्वत:साठी होमार्पण करावे तसेच लोकांसाठीही होमार्पण करावे आणि स्वत:साठी व लोकांसाठी प्रायश्चित करावे. ");
INSERT INTO mar_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","मग त्याने पापार्पणाच्या चरबीचा वेदीवर होम करावा. ");
INSERT INTO mar_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ज्या मनुष्याने पाप वाहून नेण्यासाठी निवडलेला बकरा रानात सोडून दिला त्याने आपले कपडे धुवावे, पाण्याने आंघोळ करावी व त्यानंतर तो छावणीत प्रवेश करु शकतो. ");
INSERT INTO mar_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","पापार्पणाच्या ज्या गोऱ्ह्याचे व बकऱ्याचे रक्त प्रायश्चितासाठी पवित्रस्थानात नेले होते त्या दोन्ही पशूंना छावणीच्या बाहेर न्यावे. तेथे त्यांचे कातडे, मांस व शेण ही अग्नीत जाळून टाकावीत. ");
INSERT INTO mar_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ज्या मनुष्याने ती जाळून टाकली त्याने आपले कपडे धुवावे, पाण्याने आंघोळ करावी; त्यानंतर तो छावणीत येऊ शकतो. ");
INSERT INTO mar_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","तुमच्यासाठी हा एक कायमचा विधी असावा; सातव्या महिन्याच्या दशमीस तुम्ही अन्न न घेता उपास करावा आणि त्या दिवशी कोणीही कोणतेही काम करू नये, मग तो तुमच्यात जन्मलेल्यांपैकी असो किंवा तुमच्यात राहणारा परदेशी असो; ");
INSERT INTO mar_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","हे यासाठी की या दिवशी तुमच्यासाठी तुम्ही तुमच्या सर्व पापांपासून शुद्ध व्हावे म्हणून प्रायश्चित करण्यात येईल, जेणेकरून तुम्ही परमेश्वरासमोर शुद्ध व्हाल. ");
INSERT INTO mar_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","तुमच्यासाठी हा पूर्ण विश्रामाचा शब्बाथ आहे; तुम्ही उपवास करावा व कसलेही काम करु नये; हा तुमच्यामध्ये कायमचा विधी असणार आहे. ");
INSERT INTO mar_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","तेव्हा आपल्या पित्याच्या जागी मुख्य याजक म्हणून ज्याची निवड होऊन ज्याचा अभिषेक होईल त्याने तागाची पवित्र वस्त्रे घालून प्रायश्चित करावे. ");
INSERT INTO mar_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","त्याने परमपवित्रस्थान, दर्शनमंडप व वेदी तसेच याजकवर्ग आणि सर्व इस्राएल लोक ह्यांच्यासाठी प्रायश्चित करावे.” ");
INSERT INTO mar_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","इस्राएल लोकांसाठी त्यांच्या सर्व पापाबद्दल वर्षातून एकदा प्रायश्चित करण्याकरिता हा कायमचा विधी होय; परमेश्वराने मोशेला दिलेल्या आज्ञेप्रमाणे त्यांनी ते सर्व केले. ");
INSERT INTO mar_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“अहरोन त्याचे पुत्र आणि सर्व इस्राएल लोक ह्यांना सांग की परमेश्वराने जी आज्ञा दिली आहे ती ही: ");
INSERT INTO mar_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","इस्राएल घराण्यातील एखाद्या मनुष्याने, छावणीत किंवा छावणीबाहेर एखादा बैल; कोकरू किंवा बकरा मारला, ");
INSERT INTO mar_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","परंतु परमेश्वराच्या निवासमंडपासमोर अर्पण करण्यासाठी दर्शनमंडपापाशी आणला नाही, तर त्या मनुष्यास रक्तपात केल्याचा दोष लागेल; त्याने त्या प्राण्याचा वध करून रक्त सांडले आहे म्हणून त्या मनुष्यास आपल्या लोकांतून बाहेर टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","या नियमाचा हेतू असा की इस्राएल लोक आपले पशू खुल्या शेतात मारतात ते त्यांनी दर्शनमंडपाच्या दारापाशी याजकाकडे परमेश्वरासमोर आणावे, व परमेश्वराकरिता शांत्यर्पणे म्हणून अर्पावे. ");
INSERT INTO mar_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","याजकाने त्यांचे रक्त दर्शनमंडपाच्या दारापाशी परमेश्वराच्या वेदीवर टाकावे आणि परमेश्वरास सुवास म्हणून त्यांच्या चरबीचा होम करावा. ");
INSERT INTO mar_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","आणि ह्यामुळे त्यांनी व्यभिचारी मतीने ‘अजमूर्तींच्या मागे लागून त्यांना आपले यज्ञपशु अर्पण करु नयेत. हे तुम्हास पिढ्यान् पिढ्या कायमचे विधी नियम आहेत! ");
INSERT INTO mar_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","तू त्यांना सांग की इस्राएल घराण्यापैकी किंवा त्यांच्यामध्ये राहणाऱ्या किंवा परदेशीय लोकांपैकी कोणी होमार्पण अथवा यज्ञ केला, ");
INSERT INTO mar_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","तर त्याने तो परमेश्वरास अर्पण करण्यासाठी दर्शनमंडपाच्या दारापाशी आणावा; त्याने तसे न केल्यास आपल्या लोकांतून त्यास बाहेर टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","इस्राएल घराण्यापैकी किंवा त्यांच्यामध्ये राहणाऱ्या परदेशीय लोकांपैकी कोणी रक्त सेवन केले! तर मी त्या मनुष्यापासून आपले तोंड फिरवीन व त्यास आपल्या लोकांतून बाहेर टाकीन. ");
INSERT INTO mar_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","कारण प्राण्याचे जीवन त्यांच्या रक्तात असते आणि तुमच्या जिवाबद्दल वेदीवर प्रायश्चित करण्यासाठी ते तुम्हास दिले आहे; कारण रक्तानेच प्रायश्चित होते हेच ते रक्त आहे की ज्याद्वारे जिवाचे प्रायश्चित होते. ");
INSERT INTO mar_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","म्हणून मी इस्राएल लोकांस सांगतले आहे की तुमच्यातील कोणीही, तसेच तुमच्यामध्ये राहणाऱ्या परदेशीयांनीही रक्त सेवन करु नये. ");
INSERT INTO mar_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","इस्राएल लोकांपैकी असो किंवा त्यांच्यामध्ये राहणाऱ्या परदेशीयांपैकी असो! कोणी खाण्यास योग्य पशूची किंवा पक्ष्याची शिकार केली तर त्याने त्याचे रक्त जमिनीवर ओतून मातीने झाकावे. ");
INSERT INTO mar_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","कारण प्राणीमात्रांच्या जीवनाविषयी म्हणाल तर त्यांचे रक्त हेच त्यांचे जिवन आहे ह्यामुळे मी इस्राएल लोकांस म्हणालो आहे की कोणत्याही प्राण्याचे रक्त सेवन करु नये, कारण सर्व प्राण्यांचे जिवन हेच त्यांचे रक्त आहे. ");
INSERT INTO mar_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“कोणी मनुष्याने मग तो त्यांच्यामध्ये राहणार किंवा परदेशीय असो! तो जर मरण पावलेल्या किंवा जंगली जनावराने मारलेल्या प्राण्याचे मांस खाईल त्याने आपले कपडे धुवावे, पाण्याने स्नान करावे व त्याने संध्याकाळपर्यंत अशुद्ध रहावे; म्हणजे तो शुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","त्याने आपले कपडे धुतले नाहीत किंवा स्नान केले नाही तर तो आपल्या अपराधाबद्दल दोषी ठरेल, त्याने त्याबद्दल शिक्षा भोगावी.” ");
INSERT INTO mar_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","इस्राएल लोकांस सांग, मी परमेश्वर तुमचा देव आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तुम्ही ज्या मिसर देशात राहत होता त्या देशातील रीतीरीवाजाप्रमाणे चालू नका! तसेच ज्या कनान देशात मी तुम्हास घेऊन जात आहे त्या देशातील चालीरीती प्रमाणेही तुम्ही चालू नका! त्यांचे विधी पाळू नका. ");
INSERT INTO mar_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","तुम्ही माझ्याच नियमाप्रमाणे चाला व माझेच विधी पाळा! कारण मी परमेश्वर तुमचा देव आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","म्हणून तुम्ही माझे विधी व माझे नियम पाळावे; ते जो पाळील तो त्यांच्यामुळे जिवंत राहील! मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","तुम्ही कोणीही आपल्याजवळच्या नातलगाशी शरीरसबंध ठेऊ नये! मी परमेश्वर आहे: ");
INSERT INTO mar_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","तू तुझ्या आईबरोबर शारीरिक संबंध ठेवून आपल्या बापाचा अनादर करु नको. ती तुझी आई आहे, म्हणून तिचा आदर कर. ");
INSERT INTO mar_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","तू तुझ्या सावत्र आईबरोबर शारीरिक संबंध ठेवू नको, त्यामुळे तुझ्या बापाची लाज उघडी करू नको. ");
INSERT INTO mar_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","तू तुझ्या बहिणीशी शरीरकसंबंध ठेवू नको, ती बहीण सख्खी असो किंवा सावत्र असो; ती तुझ्या घरात जन्मलेली असो किंवा तुझ्या घराबाहेर दुसऱ्याच्या घरी जन्मलेली असो तू तिच्यापाशी जाऊ नको. ");
INSERT INTO mar_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","तू तुझ्या नातीशी शारीरिक संबंध ठेवू नको, मग ती तुझ्या मुलाची मुलगी असो किंवा मुलीची मुलगी असो; कारण ती तुझीच लाज आहे! ");
INSERT INTO mar_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","जर तुझ्या वडिलाच्या पत्नीला तुझ्या बापापासून मुलगी झाली असेल तर ती तुझी बहीणच आहे; म्हणून तू तिच्याशी शारीरिक संबंध ठेवू नको. ");
INSERT INTO mar_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","तुझ्या आत्याशी शारीरिक संबंध ठेवू नको. ती तुझ्या बापाची जवळची नातलग आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","तुझ्या मावशीशी शारीरिक संबंध ठेवू नको, ती तुझ्या आईची जवळची नातलग आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","तू तुझ्या चुलत्याच्या पत्नीशी शारीरिक संबंध ठेवून त्याची लाज उघडी करु नको त्या हेतूने तिच्या जवळ जाऊ नको; ती तुझी चुलती आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","तुझ्या सुनेशी शारीरिक संबंध ठेवू नको, ती तुझ्या मुलाची पत्नी आहे तिच्याशी शारीरिक संबध ठेवू नको. ");
INSERT INTO mar_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","तुझ्या भावजयीशी शारीरिक संबंध ठेवू नको, ह्याप्रकारे त्याची लाज काढू नको. ");
INSERT INTO mar_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","एखाद्या स्त्रीशी व तिच्या मुलीशी म्हणजेच दोघींशी अथवा तिच्या नातीशी मग ती तिच्या मुलाची मुलगी असो किंवा मुलीची मुलगी असो शरीरसंबंध ठेवू नको. कारण त्या जवळच्या नातलग आहेत; असे करणे अतिदुष्टपणाचे आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","तुझी पत्नी जिवंत असताना तिच्या बहिणीला पत्नी करून तिला सवत करून घेऊ नको; तू तिच्या बहिणीशी शारीरिक संबंध ठेवू नको. ");
INSERT INTO mar_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","स्त्री ऋतुमती झाली असताना तिच्यापाशी जाऊ नको; कारण ऋतुकालात ती अशुद्ध असते. ");
INSERT INTO mar_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","तू आपल्या शेजाऱ्याच्या पत्नीशी शारीरिक संबंध ठेवू नको. आणि हे करून अमंगळ होऊ नको. ");
INSERT INTO mar_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","तू तुझ्या लेकरांपैकी कोणाचाही मोलख दैवतासाठी होम करु नको; असे करशील तर तू आपल्या देवाच्या नावाला कलंक लावू नको. मी परमेश्वर आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","स्त्रीगमनाप्रमाणे पुरुषगमन करु नको! ते भयंकर पाप आहे! ");
INSERT INTO mar_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","कोणत्याही पशूशी गमन करून त्यासोबत अमंगळ होऊ नको. त्याचप्रमाणे स्त्रीने पशूशी गमन करावयासाठी त्याच्यापाशी जाऊ नये; ते कृत्य निसर्गाविरूद्ध आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","अशाप्रकारे स्वत:ला अशुद्ध करून घेऊ नका; कारण जी राष्ट्रे मी तुमच्यासमोरुन बाहेर घालवून देणार आहे, तेथील लोकही अशाच कृत्यांनी अशुद्ध झाले. ");
INSERT INTO mar_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","त्यांचा देश भयंकर भ्रष्ट झाला आहे, म्हणून त्यांच्या दुष्टतेमुळे मी त्यांचा समाचार घेत आहे व तो देश आपल्या रहीवाशांचा त्याग करीत आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ह्याकरिता तुम्ही माझे विधी व नियम पाळावे; आणि स्वदेशीय अथवा तुमच्यात राहणारा परदेशीय ह्यापैकी कोणीही असली भयंकर अमंगळ कृत्ये करु नये. ");
INSERT INTO mar_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","कारण तुमच्या पूर्वी त्या देशात राहणाऱ्या लोकांनी भयंकर अमंगळ कृत्ये केल्यामुळे तो देश अमंगळ झाला आहे. ");
INSERT INTO mar_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","जर तुम्ही या गोष्टी केल्या तर त्यांनी हा देश भ्रष्ट केला तसा तो तुमचाही त्याग करील. ");
INSERT INTO mar_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","जे कोणी ह्यातील कोणतेही अमंगळ कृत्य करतील त्या सर्वांना आपल्या लोकांतून बाहेर टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","इतर लोकांनी असली भयंकर अमंगळ कृत्ये केली, परंतु तुम्ही माझे विधी व नियम पाळावेत; अशी भयंकर अमंगळ कृत्ये करून तुम्ही आपणाला अमंगळ करून घेऊ नये! मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","सर्व इस्राएलाच्या मंडळीतील लोकांस सांग की, मी तुमचा देव परमेश्वर पवित्र आहे, म्हणून तुम्हीही पवित्र असलेच पाहिजे. ");
INSERT INTO mar_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","तुमच्यातील प्रत्येकाने आपली आई व आपला बाप ह्यांचा मान राखलाच पाहिजे आणि माझा शब्बाथ पाळलाच पाहिजे; मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","तुम्ही मूर्तीपूजा करु नका, आपल्यासाठी ओतीव देव करु नका. मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","तुम्ही परमेश्वरासाठी शांत्यर्पणाचा यज्ञ कराल तेव्हा तो असा करा की त्यामुळे तुम्ही मला मान्य व्हाल. ");
INSERT INTO mar_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","त्या अर्पणाचे मांस यज्ञाच्या दिवशी व त्याच्या दुसऱ्या दिवशी खावे, पण तिसऱ्या दिवशी जर त्यातून काही उरले तर ते अग्नीत जाळून टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","तिसऱ्या दिवशी त्यातील खाणे भयंकर पाप आहे; ते अर्पण मान्य होणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","कोणी तसे करील तर ते पाप केल्यामुळे तो अपराधी ठरेल, कारण त्याने परमेश्वराच्या पवित्र वस्तूचा मान न राखता ती दूषित केली असे होईल; त्या मनुष्यास आपल्या लोकातून बाहेर टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","तुम्ही हंगामाच्या वेळी आपल्या शेतातील पिकाची कापणी कराल तेव्हा, आपल्या शेताच्या कोनाकोपऱ्यातील झाडून सारेच पीक काढू नका व पीक काढून घेतल्यावर सरवा वेचू नका. ");
INSERT INTO mar_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","आपला द्राक्षमळाही झाडून सारा खुडू नका, तसेच द्राक्षमळयात खाली पडलेली फळे गोळा करु नका; गोरगरीबांसाठी व तुमच्या देशातून प्रवास करणाऱ्या उपरी लोकांसाठी ती राहू द्यावी; मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","तुम्ही चोरी करु नये. कोणाला फसवू नये. एकमेकाशी कपटाने बोलू नये. ");
INSERT INTO mar_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","तुम्ही माझ्या नावाने खोटी शपथ वाहून आपल्या देवाच्या नावाला कलंक लावू नये. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","आपल्या शेजाऱ्यावर जुलूम करु नका व त्यास लुबाडू नका; मजुराची मजुरी रात्रभर दिवस उजाडेपर्यंत आपल्याजवळ ठेवू नका. ");
INSERT INTO mar_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","बहिऱ्याला शिव्याशाप देऊ नका; आंधळ्याने ठोकर लागून पडावे म्हणून एखाद्या वस्तूचे अडखळण त्याच्या वाटेत ठेवू नका; पण आपल्या देवाचा मान राखा त्याचे भय बाळगा. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","न्यायनिवाडा करताना कोणावर अन्याय करु नका तर योग्य न्याय द्या. न्यायदान करताना गरीब लोक व वजनदार लोक ह्याना विशेष मर्जी दाखवू नका. आपल्या शेजाऱ्याचा न्याय करताना योग्य तोच न्याय द्या. ");
INSERT INTO mar_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","आपल्या लोकांमध्ये चहाड्या करीत इकडे तिकडे फिरू नका, आपल्या शेजाऱ्याचा जीव धोक्यात येईल असे काही करु नका. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","आपल्या मनात आपल्या भावाचा द्वेष बाळगू नका; आपल्या शेजाऱ्याने चुकीचे काही कृत्य केल्यास त्याची कान उघडणी करावी, परंतु त्याच्या अपराधामध्ये सहभागी होऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","लोकांनी तुमचे वाईट केलेले विसरून जावे, त्याबद्दल सूड घेण्याचा प्रयत्न करु नका तर आपल्या शेजाऱ्यावर स्वत: सारखी प्रीती करा. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","तुम्ही माझे नियम पाळा. आपल्या पशूंचा भिन्न जातीच्या पशूंशी संकर करु नका. दोन जातीचे बी मिसळून ते आपल्या शेतात पेरू नका. भिन्न सूत एकत्र करून विणलेला कपडा अंगात घालू नका. ");
INSERT INTO mar_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","एखाद्या पुरुषाची स्त्री गुलाम, ती विकत घेतलेली नसेल किंवा खंडणी भरून मुक्त झाली नसेल, अशा स्त्रीशी कोणी शरीरसंबंध केल्यास त्या दोघांना शिक्षा व्हावी; परंतु तिची मुक्तता झाली नसल्यामुळे त्यांना जिवे मारू नये. ");
INSERT INTO mar_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","हे पाप केलेल्या मनुष्याने आपले दोषार्पण म्हणून एक मेंढा दोषार्पणासाठी, दर्शनमंडपाच्या दारापाशी परमेश्वरासमोर आणावा; ");
INSERT INTO mar_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","आणि त्याने केलेल्या पापाबद्दल दोषार्पणाच्या मेंढ्याद्वारे त्याच्यासाठी याजकाने परमेश्वरासमोर प्रायश्चित करावे; म्हणजे त्याने केलेल्या पापाची त्यास क्षमा होईल. ");
INSERT INTO mar_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","तुम्ही आपल्या देशात जाऊन पाहोचल्यावर खाण्यासाठी निरनिराळ्या प्रकारची फळझाडे लावाल, तेव्हा फळझाडे लावल्यावर तुम्ही तीन वर्षे थांबाबे, त्यांची फळे खाऊ नयेत. ");
INSERT INTO mar_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","पण चौथ्या वर्षी त्यांची सर्व फळे परमेश्वराची होतील; ती परमेश्वराच्या उपकारस्मरणाच्या यज्ञासाठी पवित्र समजावी. ");
INSERT INTO mar_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","मग पाचव्या वर्षी तुम्ही त्यांची फळे खावी. असे केल्याने त्यांना तुमच्यासाठी अधिक फळे येतील. मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","तुम्ही कोणतेही मांस रक्तासह खाऊ नका. तुम्ही काही जादूटोणा, मंत्रतंत्र व शकूनमुहूर्त ह्याच्याद्वारे भविष्य पाहण्याचा प्रयत्न करु नका. ");
INSERT INTO mar_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","आपल्या डोक्याला घेर ठेवू नका; आपल्या दाढीचे कोपरे छाटू नका. ");
INSERT INTO mar_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","मृताची आठवण म्हणून अंगावर जखम करून घेऊ नका. आपले अंग गोंदवून घेऊ नका. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","तू आपल्या मुलीला वेश्या करुन भ्रष्ट होऊ देऊ नको, त्यामुळे तू तिच्या पावित्र्याचा मान राखीत नाहीस असे दिसेल. तुमच्या देशात वेश्या होऊ देऊ नका त्या प्रकारच्या पापाने तुमचा देश भ्रष्ट होऊ देऊ नका. ");
INSERT INTO mar_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","तुम्ही माझे शब्बाथ, काम न करता विसाव्याचे दिवस म्हणून पाळावे. तुम्ही माझ्या पवित्रस्थानाविषयी आदर बाळगावा. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","सल्लामसलत विचारण्यासाठी पंचाक्षऱ्याकडे किंवा चेटक्याकडे जाऊ नका; त्यांच्यामागे लागू नका; ते तुम्हास अशुद्ध करतील. मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","वडीलधाऱ्या मनुष्यांना मान द्या; वृद्ध मनुष्य घरात आल्यास उठून उभे राहा; आपल्या देवाचे भय बाळगा. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","कोणी परदेशीय तुमच्या देशात तुमच्याबरोबर राहत असेल तर त्याच्याशी वाईट वागू नका. ");
INSERT INTO mar_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","तुमच्याबरोबर राहणाऱ्या परदेशीय मनुष्यास स्वदेशीय मनुष्यासारखेच माना; आणि त्याच्यावर स्वत: सारखीच प्रीती करा; कारण तुम्हीही एकेकाळी मिसरदेशात परदेशीय होता. मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","लोकांचा न्याय करताना तुम्ही योग्य न्याय करावा; मोजण्यामापण्यात व तोलण्यात तुम्ही अन्याय करु नका. ");
INSERT INTO mar_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","तुमच्यापाशी खरी मापे, खरी वजने, खरे तराजू, खरा एफा व खरा हिन असावा. मी परमेश्वर तुमचा देव आहे! मीच तुम्हास मिसर देशातून बाहेर आणले! ");
INSERT INTO mar_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“म्हणून तुम्ही माझे विधी व नियम यांची आठवण ठेवून ते पाळावे. मी परमेश्वर आहे!” ");
INSERT INTO mar_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“तू इस्राएल लोकांस आणखी असे सांग की, इस्राएलांपैकी किंवा इस्राएल लोकांमध्ये राहणाऱ्या परकियांपैकी कोणी आपल्या मुलाबाळांतून एखादे मूल मोलख दैवतास अर्पील तर त्या मनुष्यास जिवे मारावे! आपल्या देशाच्या लोकांनी त्यास धोंडमार करावा!” ");
INSERT INTO mar_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","मीही त्या मनुष्याच्या विरूद्ध होईन! आणि त्यास आपल्या लोकांतून बाहेर टाकीन! कारण त्याने आपले मूल मोलख दैवतास अर्पून माझे पवित्रस्थान भ्रष्ट केले व माझ्या पवित्र नावाला कलंक लावला! ");
INSERT INTO mar_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","मोलख दैवताला आपले मूल अर्पिण्याकडे देशाचे इतर सामान्य लोक डोळेझाक करून त्यास जिवे मारणार नाहीत. ");
INSERT INTO mar_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","तर मी त्या मनुष्याच्या व त्याच्या कुटुंबाच्या विरूद्ध होईन! आणि त्यास व मजवर अविश्वास दाखवून जो कोणी व्यभिचारी मतीने मोलख दैवताच्या नादी लागून त्यांच्यामागे जातील त्यांना आपल्या लोकांतून बाहेर टाकीन! ");
INSERT INTO mar_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","जो मनुष्य व्यभिचारी मतीने सल्लामसलत विचारण्यास पंचाक्षऱ्याकडे व चेटक्याकडे जातो तो माझ्याशी विश्वासघात करीत आहे मी त्याच्या विरूद्ध होईन व त्यास आपल्या लोकांतून बाहेर टाकीन. ");
INSERT INTO mar_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","म्हणून शुद्ध व्हा! आपणास पवित्र करा! कारण मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","तुम्ही माझ्या नियमांची आठवण ठेवून ते पाळा; मीच तुम्हास पवित्र करणारा परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","जो मनुष्य आपल्या बापाला किंवा आपल्या आईला शिव्याशाप देईल त्यास अवश्य जिवे मारावे त्याने आपल्या बापाला व आपल्या आईला शिव्याशाप दिला आहे म्हणून त्याच्या रक्तपाताची जबाबदारी त्याच्याच माथी राहील. ");
INSERT INTO mar_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","जो मनुष्य आपल्या शेजाऱ्याच्या पत्नीपाशी जातो तो मनुष्य व ती स्त्री, ते दोघेही व्यभिचाराच्या पापाचे अपराधी आहेत; त्या दोघांना अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","जो आपल्या वडिलाच्या पत्नीपाशी जातो तो आपल्या बापाची लाज उघडी करतो! तो मनुष्य व त्याच्या बापाची पत्नी त्या दोघांनाही अवश्य जिवे मारावे; त्यांच्या रक्तपाताची जबाबदारी त्यांच्याच माथी राहील. ");
INSERT INTO mar_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","एखादा पुरुष आपल्या सुनेशी शारीरिक संबंध ठेवेल तर त्या दोघांनाही अवश्य जिवे मारावे; त्यांनी शरीरसंबंधाचे भयंकर पाप केले आहे! त्यांच्या रक्तपाताची जबाबदारी त्यांच्याच माथी राहील. ");
INSERT INTO mar_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","एखाद्या पुरुषाने स्त्रीगमनाप्रमाणे पुरुषगमन केले तर ते भयंकर पाप त्या दोघांनी केले आहे म्हणून त्या दोघांनाही अवश्य जिवे मारावे; त्यांच्या रक्तपाताची जबाबदारी त्याच्याच माथी राहील. ");
INSERT INTO mar_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","कोणा पुरुषाने एखादी स्त्री व तिची मुलगी या दोघींबरोबर विवाह केला तर तो अतिदुष्टपणा होय. त्या पुरुषाला व त्या दोन्ही स्त्रीयांना अग्नीत जाळून टाकावे! तुमच्यामध्ये असे अतिदुष्टपणाचे पाप होऊ देऊ नये! ");
INSERT INTO mar_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","कोणा पुरुषाने पशूगमन केले तर त्यास अवश्य जिवे मारावे आणि त्या पशूलाही मारुन टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","कोणी स्त्री पशूगमन करील तर त्या स्त्रीला व त्या पशूला जिवे मारावे; त्यांना अवश्य मारुन टाकावे; त्यांच्या रक्तपाताची जबाबदारी त्यांच्याच माथी राहील. ");
INSERT INTO mar_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","कोणी आपल्या बहिणीला, मग ती त्याच्या बापाची मुलगी असो किंवा त्याच्या आईची मुलगी असो, आपली पत्नी करून घेईल व ती दोघे शरीरसंबंध करतील तर ते लाजीरवाणे कर्म आहे! त्या दोघांना आपल्या भाऊबंदादेखत शिक्षा व्हावी! त्यांना आपल्या लोकांतून बाहेर टाकावे. त्याने आपल्या बहिणीबरोबर केलेल्या वाईट कर्माबद्दल शिक्षा भोगावी. ");
INSERT INTO mar_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ऋतुमती स्त्रीशी कोणी पुरुषाने शरीरसंबंध केला तर तो पुरुष व ती स्त्री या दोघांनाही त्यांच्या लोकांतून बाहेर टाकावे; कारण त्यांने तिच्या रक्ताचा झरा उघडा करून पाप केले आहे. ");
INSERT INTO mar_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","आपली मावशी किंवा आपली आत्या ह्याच्याशी शारीरिक संबंध ठेवू नयेत व तसे करणाऱ्याने त्याच्या जवळच्या आप्ताची काया उघडी केली आहे त्यांनी आपल्या दुष्कर्माबद्दल शिक्षा भोगावी. ");
INSERT INTO mar_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","कोणी आपल्या चुलतीशी शारीरिक संबंध ठेवेल तर त्याने आपल्या चुलत्याची लाज उघडी केली असे होईल; ते आपल्या पापाची शिक्षा भोगतील व संतती न होता मरतील. ");
INSERT INTO mar_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","आपल्या भावजयीशी शारीरिक संबंध ठेवणे हे पापी कृत्य आहे; जो कोणी असे करील त्याने आपल्या भावाची लाज उघडी केली असे होईल! त्यांना संतती होणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","म्हणून तुम्ही माझे सर्व विधी व माझे सर्व नियम यांची आठवण ठेवून ते पाळावे म्हणजे ज्या देशात मी तुम्हास घेऊन जात आहे त्यामध्ये तुमची वस्ती होईल; तो देश तुमचा त्याग करणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ज्या राष्ट्रांना मी तुमच्या पुढून घालवून देत आहे त्यांनी असली सर्व पापी कृत्ये केली म्हणून मला त्यांचा वीट आला! तुम्ही त्यांच्या रीतीरीवाजाप्रमाणे चालू नका. ");
INSERT INTO mar_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","मी तुम्हास सांगितले आहे की त्यांचा देश तुमचे वतन होईल! तो मी तुमच्या ताब्यात देत आहे. त्यामध्ये दुधामधाचे प्रवाह वाहात आहेत; इतर राष्ट्रापासून वेगळे करून मी तुम्हास माझे विशेष लोक म्हणून चालविले आहे. मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","म्हणून तुम्ही शुद्ध व अशुद्ध पशू आणि शुद्ध व अशुद्ध पक्षी ह्याच्यातील भेद पाळावा, आणि जे पशू, पक्षी व जमिनीवर रांगणारे प्राणी मी अशुद्ध ठरविले आहेत ते तुम्ही खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तुम्ही माझेच असावे म्हणून मी तुम्हास इतर राष्ट्रापासून वेगळे केले आहे; तुम्ही माझ्याकरिता पवित्र व्हावे! कारण मी तुमचा परमेश्वर आहे आणि मी पवित्र आहे! ");
INSERT INTO mar_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","कोणी पंचाक्षरी किंवा चेटकी करणारा असला, मग तो पुरुष असो किंवा स्त्री असो, त्यांना अवश्य जिवे मारावे; लोकांनी त्यांना धोंडमार करावा; त्यांच्या रक्तपाताची जबाबदारी त्यांच्याच माथी राहील. ");
INSERT INTO mar_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","परमेश्वर मोशेला म्हणाला, “अहरोनाचे पुत्र, जे याजक त्यांना असे सांग की, आपल्या लोकांमधील मरण पावलेल्या मनुष्यास स्पर्श करून याजकाने स्वत:ला अशुद्ध करून घेऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","परंतु आपले जवळचे नातलग म्हणजे आपली आई, बाप मुलगा, मुलगी, भाऊ, ");
INSERT INTO mar_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","आणि आपल्याजवळ असलेली आपली अविवाहित बहीण जिला पती नाही तिचे मात्र सुतक धरावे. ");
INSERT INTO mar_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","याजक आपल्या लोकांचा प्रमुख असल्यामुळे त्याने सामान्य मनुष्याप्रमाणे लग्न करून स्वत:ला अपवित्र करून घेऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","याजकांनी आपल्या डोक्याचे मुंडण करु नये; आपल्या दाढीचे कोपरे छाटू नयेत किंवा आपल्या शरीरावर घाव करु नयेत; ");
INSERT INTO mar_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","त्यांनी आपल्या देवासाठी पवित्र रहावे आणि आपल्या देवाच्या नावाचा मान राखावा. त्याचे भय धरावे. आणि त्याच्या नांवाला काळिमा लावू नये; ते अग्नीद्वारे परमेश्वरास अर्पण म्हणजे अन्नार्पण अर्पित असतात म्हणून त्यांनी अवश्य पवित्र रहावे. ");
INSERT INTO mar_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","याजक पवित्रपणे देवाची सेवा करतात म्हणून त्यांनी भ्रष्ट झालेल्या स्त्रीला, वेश्येला, किंवा नवऱ्याने टाकलेल्या स्त्रीला आपली पत्नी करून घेऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","याजक पवित्रपणे देवाला अन्नार्पण करतो म्हणून तुम्ही त्यास पवित्र मानावे, त्यास तू पवित्र लेखावे; कारण तुम्हास पवित्र करणारा मी परमेश्वर पवित्र आहे. ");
INSERT INTO mar_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","एखाद्या याजकाची मुलगी वेश्याकर्म करील तर ती भ्रष्ट होईल, व आपल्या पावित्र्याचा नाश करून घेईल; आणि त्यामुळे ती आपल्या बापाला कलंक लावील; तिला अग्नीत जाळून टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","आपल्या भावांतून मुख्य याजक निवडला गेला, त्याच्या मस्तकावर अभिषेकाचे तेल ओतले गेले आणि पवित्र वस्त्रे परिधान करावयास त्याच्यावर संस्कार झाला; अशा रीतीने याजक या नात्याने पवित्र सेवा करण्यासाठी त्याची निवड झाली आहे, म्हणून त्याने आपल्या डोक्याचे केस मोकळे सोडू नयेत व लोकांमध्ये शोकप्रदर्शनार्थ आपली वस्त्रे फाडू नयेत; ");
INSERT INTO mar_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","त्याने आपणाला अशुद्ध करून घेऊ नये; त्याने प्रेताजवळ जाऊ नये; आपल्या वडिलाच्या किंवा आईच्या प्रेताजवळही जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","त्याने पवित्रस्थानाबाहेर जाऊ नये, त्याने अशुद्ध होऊ नये व आपल्या देवाचे पवित्रस्थान भ्रष्ट करु नये; त्याच्या डोक्यावर अभिषेकाचे तेल ओतल्यामुळे त्याच्यावर संस्कार झाला आहे व त्यामुळे इतर लोकांपासून तो वेगळा झाला आहे. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","मुख्य याजकाने कुमारीशीच लग्न करावे, ");
INSERT INTO mar_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","भ्रष्ट झालेली स्त्री, वेश्या किंवा टाकलेली स्त्री अथवा विधवा स्त्री ह्यापैकी कोणाही स्त्रीला त्याने पत्नी करून घेऊ नये; तर त्याने आपल्या लोकांतील एखाद्या कुमारीशीच लग्न करावे. ");
INSERT INTO mar_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","अशा प्रकारे त्याने आपल्या लोकात आपली संतती भ्रष्ट होऊ देऊ नये; कारण मी जो परमेश्वर त्या मी त्यास पवित्र सेवेसाठी पवित्र केले आहे.” ");
INSERT INTO mar_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“अहरोनाला असे सांग की पुढील पिढ्यानमध्ये, तुझ्या वंशात जर कोणाला काही व्यंग शारीरिक दोष निघाले तर त्याने आपल्या देवाकरता अन्न अर्पिण्यासाठी वेदीजवळ जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","शारीरिक व्यंग असलेल्या कोणत्याही मनुष्याने मला अर्पण आणू नये; याजक या नात्याने माझी सेवा करण्यास पात्र नसलेली माणसे अशी:आंधळा, लंगडा, चेहऱ्यावर विद्रूप वण असलेला, हातपाय प्रमाणाबाहेर लांब असलेला, ");
INSERT INTO mar_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","मोडक्या पायाचा, थोटा, ");
INSERT INTO mar_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","कुबडा, ठेंगू, डोळयात दोष असलेला, पुरळ किंवा त्वचेचे इतर वाईट रोग झालेला अथवा भग्नांड असलेला; ");
INSERT INTO mar_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","अहरोन याजकाच्या वंशापैकी कोणास असे व्यंग असेल तर त्याने परमेश्वरास अर्पण किंवा अन्न अर्पावयास वेदीजवळ जाऊ नये; त्याने आपल्या देवाला अन्न अर्पण करण्यासाठी जवळ जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","तो याजकाच्या कुटुंबापैकी असल्यामुळे त्याने त्याच्या देवाचे पवित्र अन्न तसेच परमपवित्र अन्न खावे; ");
INSERT INTO mar_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","परंतु त्यास व्यंग असल्यामुळे त्याने अंतरपटाच्या आत आणि वेदीजवळ जाऊ नये व माझी परमपवित्र स्थाने भ्रष्ट करु नये; कारण त्यांना पवित्र करणारा मी परमेश्वर आहे!” ");
INSERT INTO mar_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","तेव्हा मोशेने अहरोन, त्याचे पुत्र व सगळे इस्राएल लोक ह्याना हे सर्व सांगितले. ");
INSERT INTO mar_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“अहरोन व त्याचे पुत्र ह्याना सांग की इस्राएल लोक ज्या वस्तू मला समर्पण करतात त्यापासून त्यांनी दूर रहावे व माझ्या पवित्र नावाला कलंक लावू नये. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","तुझ्या वंशजापैकी कोणी जर अशुद्ध असेल त्याने इस्राएल लोकांनी समर्पीत केलेल्या पवित्र वस्तूंना हात लावू नये, त्यास मजसमोरुन दूर करावे. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","अहरोनाच्या वंशापैकी कोणी महारोगी किंवा स्त्राव होणारा असला तर त्याने शुद्ध होईपर्यंत पवित्र केलेले पदार्थ खाऊ नयेत. हा नियम अशुद्ध झालेल्या प्रत्येक याजकाला लागू आहे. प्रेताला स्पर्श केल्यामुळे किंवा वीर्यपातामुळे अशुद्ध झालेला मनुष्य, ");
INSERT INTO mar_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","किंवा जमिनीवर सरपटणाऱ्या कोणत्याही अशुद्ध प्राण्याला स्पर्श केल्यामुळे किंवा कोणत्याही इतर कारणामुळे अशुद्ध झालेल्या मनुष्यास स्पर्श केल्यामुळे ");
INSERT INTO mar_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","याजकाने अशा कोणालाही स्पर्श केला तर त्याने संध्याकाळपर्यंत अशुद्ध रहावे. त्याने पवित्र पदार्थ खाऊ नयेत; त्याने पाण्याने स्नान केले तरी पवित्र पदार्थ खाऊ नयेत. ");
INSERT INTO mar_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","सूर्य मावळल्यावरच तो मनुष्य शुद्ध ठरेल; त्यानंतर त्याने पवित्र पदार्थ खावे; कारण ते त्याचे अन्न आहे. ");
INSERT INTO mar_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","आपोआप मरण पावलेल्या किंवा जंगली जनावरांनी मारुन टाकलेल्या जनावराचे मांस याजकाने खाऊ नये, जर तो ते खाईल तर तो अशुद्ध होईल; मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","त्यांनी माझी आज्ञा पाळावी व पवित्र पदार्थ अपवित्र होणार नाहीत याची काळजी घ्यावी; त्यांनी ती घेतील नाही तर आज्ञाभंगाच्या पापामुळे ते मरतील. मी परमेश्वराने त्यांना या पवित्र कामासाठी वेगळे केले आहे. ");
INSERT INTO mar_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","फक्त याजकाच्या कुटुंबातील लोकांनी पवित्र अन्न खावे; त्याच्याकडील पाहुण्याने किंवा त्या याजकाने कामाला लावलेल्या मजुराने पवित्र अन्न खाऊ नये; ");
INSERT INTO mar_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","परंतु याजकाने स्वत:चे पैसे देऊन एखादा गुलाम विकत घेतला असेल तर त्या गुलामाने व याजकाच्या घरात जन्मलेल्या त्याच्या मुलाबाळांनी त्या पवित्र अन्नातून खावे. ");
INSERT INTO mar_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","याजकाच्या मुलीने याजक वंशाच्या बाहेरच्या मनुष्याबरोबर लग्न केले असेल तर तिने पवित्र पदार्थ खाऊ नयेत. ");
INSERT INTO mar_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","याजकाची मुलगी विधवा झाली असेल किंवा तिच्या नवऱ्याने तिला सोडून दिले असेल, तिला एकही मूल झालेले नसेल व परत ती तरुणपणी होती तशीच आपल्या वडिलाच्या घरी राहत असेल तर मग आपल्या वडिलाच्या म्हणजे याजकाच्या घरातील पवित्र अन्नातून तिने खावे, परंतु याजकाच्या घरचे पवित्र अन्न फक्त त्याच्या कुटुंबातील लोकांनीच खावे परकियाने खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","एखाद्याने चुकून पवित्र पदार्थ खाल्ला तर त्याने त्या खाल्लेल्या पदार्थाइतकी व त्या पदार्थाच्या पाचव्या हिश्श्याइतकी किंमत भरपाई म्हणून त्यामध्ये घालून याजकास द्यावी. ");
INSERT INTO mar_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","इस्राएल लोक परमेश्वरास अर्पणे देतात तेव्हा ती अर्पणे पवित्र होतात, म्हणून ती पवित्र अर्पणे याजकाने अपवित्र करु नयेत; ");
INSERT INTO mar_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","जर याजकांनी त्यांना पवित्र अर्पणे खाण्याची परवानगी दिली तर ते स्वत:वर अपराध ओढवून घेतील. आणि त्या अपराधाबद्दल त्यांना पैसे भरावे लागतील. मी परमेश्वर त्यांना पवित्र करणारा आहे! ");
INSERT INTO mar_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","मग परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","अहरोन, त्याचे पुत्र व सर्व इस्राएल लोक ह्याना सांग की तुम्हा इस्राएल लोकांपैकी किंवा तुम्हामध्ये राहणाऱ्या उपरी लोकांपैकी कोणाला आपल्या नवसाचा किंवा काही विशेष कारणासाठी स्वखुशीचा परमेश्वरासाठी यज्ञबली अर्पावयाचा असेल, ");
INSERT INTO mar_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","व तो मान्य असणारा असावा जसे गुरे, मेंढरे किंवा बकरे ह्यापैकी असेल तर तो त्यांच्यातील नर असावा, व त्याच्यात काहीही दोष नसावा! ");
INSERT INTO mar_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","परंतु दोष असलेली कोणतीही अर्पणे तू स्विकारू नये; त्या अर्पणामुळे मला संतोष होणार नाही! ");
INSERT INTO mar_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","एखाद्या मनुष्यास आपला नवस फेडण्यासाठी किंवा खुशीच्या अर्पणासाठी परमेश्वरास गुरांढोरातून किंवा शेरडांमेंढरातून शांत्यर्पण करावयाचे असेल तर ते दोषहीन असावे म्हणजे ते मान्य होईल. ");
INSERT INTO mar_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","आंधळा, हाड मोडलेला, लुळा, वाहती जखम असलेला किंवा अंगवार मस, चाई, खरुज असा त्वचेचा रोग असलेला असा कोणताही प्राणी परमेश्वरास अर्पू नये, किंवा परमेश्वराकरिता वेदीवर त्याचा अर्पण म्हणून होम करु नये. ");
INSERT INTO mar_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","गोऱ्हा किंवा मेंढा ह्याचा एखादा पाय आखुड पूर्णपणे न वाढलेला किंवा प्रमाणाबाहेर लांब असेल तर तो खुशीच्या अर्पणाकरिता चालेल, पण नवस फेडण्याकरिता त्याचा स्वीकार होणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ज्याचे अंड ठेचलेले, चिरडलेले किंवा फाटलेले असेल असा प्राणी परमेश्वरास अर्पण करु नये अशा गोष्टी तुम्ही तुमच्या देशात करु नयेत. ");
INSERT INTO mar_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","देवाला अर्पण करण्यासाठी म्हणून कोणतेही प्राणी तुम्ही परराष्ट्रीय लोकांकडून घेऊ नये कारण त्या प्राण्यांना काही इजा झालेली असेल किंवा त्यांच्यात काही दोष असेल तर; ते प्राणी स्वीकारले जाणार नाहीत! ");
INSERT INTO mar_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","वासरू, कोकरु किंवा करडू जन्मल्यावर सात दिवस त्याच्या आईजवळ असले पाहिजे; आठव्या दिवशी व त्यानंतर ते परमेश्वरास अर्पण म्हणून अर्पण करण्यासाठी स्वीकारावयास योग्य ठरेल. ");
INSERT INTO mar_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","परंतु गाय व तिचे वासरु, मेंढी व तिचे कोकरु ह्याप्रमाणे एखादा प्राणी व त्याची आई ह्यांचा एकाच दिवशी वध करु नये. ");
INSERT INTO mar_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","परमेश्वराकरिता तुम्हास उपकारस्तुतीचा यज्ञबली अर्पावयाचा असल्यास तो देवाला संतोष देईल अशाप्रकारे तुम्ही अर्पावा. ");
INSERT INTO mar_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","अर्पण केलेल्या पशूचे मांस त्याच दिवशी तुम्ही खाऊन टाकावे; त्यातील काहीही दुसऱ्या दिवशी सकाळपर्यंत शिल्लक ठेवू नये. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","तुम्ही माझ्या आज्ञांची आठवण ठेवून त्या पाळाव्या; मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","तुम्ही माझ्या पवित्र नांवाचा अनादर करू नये. माझे भय धरावे! इस्राएल लोकांमध्ये मला पवित्र मानण्यात येईल; मी तुम्हास माझे पवित्र लोक केले आहे मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","मी तुम्हास मिसर देशातून बाहेर आणले, आणि मी तुमचा देव झालो, मी परमेश्वर आहे!” ");
INSERT INTO mar_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएल लोकांस असे सांग. परमेश्वराने नेमलेल सण, पवित्र मेळे भरवण्यासाठी म्हणून तुम्ही जाहीर करावे; ते माझे नेमलेले पवित्रसण आहेत. ");
INSERT INTO mar_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","सहा दिवस कामकाज करावे, परंतु सातवा दिवस, विसाव्याचा शब्बाथ दिवस व पवित्र मेळ्याचा दिवस होय; या दिवशी तुम्ही कसलेही काम करु नये; तुमच्या सर्व घराघरात हा परमेश्वराचा शब्बाथ असावा. ");
INSERT INTO mar_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","परमेश्वराने ठरविलेले सणाचे दिवस तुम्ही पवित्र मेळ्याचे दिवस म्हणून जाहीर करावे; ते हे, ");
INSERT INTO mar_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","पहिल्या महिन्याच्या चौदाव्या दिवशी संध्याकाळपासून परमेश्वराचा वल्हांडण सण आहे. ");
INSERT INTO mar_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","त्याच निसान महिन्याच्या पंधराव्या दिवशी परमेश्वराचा बेखमीर भाकरीच्या सणाचा दिवस येतो. तेव्हा तुम्ही सात दिवस बेखमीर (खमीर न घातलेली भाकर खावी). ");
INSERT INTO mar_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","सणाच्या पहिल्या दिवशी तुम्ही पवित्र मेळा भरवावा; त्यादिवशी तुम्ही कसलेही काम करु नये. ");
INSERT INTO mar_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","सात दिवस तुम्ही परमेश्वराकरिता अग्नीत हव्य अर्पावे आणि सातव्या दिवशी आणखी दुसरा पवित्र मेळा भरवावा; त्यादिवशी काही काम करु नये.” ");
INSERT INTO mar_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएल लोकांस सांग: मी तुम्हास देत असलेल्या देशात तुम्ही जाऊन पोहोचाल व हंगामाच्या वेळी कापणी कराल त्यावेळी पिकाच्या पहिल्या उपजातील पेंढी तुम्ही याजकाकडे आणावी; ");
INSERT INTO mar_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","याजकाने ती पेंढी शब्बाथाच्या दुसऱ्या दिवशी परमेश्वरासमोर ओवाळावी म्हणजे ती तुमच्यासाठी मान्य होईल. शब्बाथाच्या पुढच्या दिवशी ती याजकाने ओवाळावी. ");
INSERT INTO mar_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","पेंढी ओवाळाल त्यादिवशी निर्दोष अशा एक वर्षाच्या मेंढ्याचे होमार्पण परमेश्वरासाठी करावे; ");
INSERT INTO mar_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","तुम्ही त्याचबरोबर तेलात मळलेल्या दोन दशमांश सपिठा अन्नार्पण अर्पावे. हे परमेश्वरासाठी सुवासिक हव्य होय; आणि त्या बरोबरचे पेयार्पण म्हणून एकचतुर्थांश हीन द्राक्षरस अर्पावा. ");
INSERT INTO mar_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","तुम्ही आपल्या देवाला हे सर्व अर्पण आणाल, त्या दिवसापर्यंत नव्या पिकाची भाकर, किंवा हुरडा किंवा हिरव्या धान्याची भाकर खाऊ नये; तुम्ही जेथे कोठे रहाल तेथे तुमच्याकरिता हा नियम पिढ्यानपिढ्या कायमचा चालू राहील. ");
INSERT INTO mar_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","तुम्ही शब्बाथ दिवसाच्या दुसऱ्या दिवशी सकाळी जेव्हा ओवाळणीची पेंढी आणाल, त्या दिवसापासून सात शब्बाथ दिवस मोजावे; ");
INSERT INTO mar_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातव्या शब्बाथ दिवसानंतर दुसऱ्या दिवशी येणाऱ्या पन्नासाव्या दिवशी तुम्ही परमेश्वराकरिता नवे अन्नार्पण आणावे. ");
INSERT INTO mar_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","त्यादिवशी तुम्ही आपल्या घरातून दोन दशांश एफाभर मैद्याच्या, खमीर घालून भाजलेल्या दोन भाकरी ओवाळण्यासाठी आणाव्या; परमेश्वराकरिता हे पहिल्या उपजाचे अर्पण होय. ");
INSERT INTO mar_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","एक गोऱ्हा, दोन मेंढे व प्रत्येकी एक वर्षाची सात नर कोकरे ही सर्व निर्दोष अशी घेऊन त्यांचा परमेश्वरासमोर अन्नार्पण आणि पेयार्पणासोबत परमेश्वरासाठी हव्य म्हणून होम करावा. त्या सुवासिक अर्पणामुळे परमेश्वरास संतोष होईल. ");
INSERT INTO mar_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","आणि पापार्पणासाठी एक बकरा व शांत्यर्पणासाठी प्रत्येकी एक वर्षाची दोन नर कोंकरे अर्पावित. ");
INSERT INTO mar_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","याजकाने ती अर्पणे प्रथम उपजाच्या भाकरीबरोबर त्या मेंढ्यांसह परमेश्वरासमोर ओवाळावी; ती परमेश्वराकरिता पवित्र आहेत; ती याजकाच्या वाट्याची व्हावी. ");
INSERT INTO mar_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","त्याच दिवशी तुम्ही पवित्र मेळा भरवावा; तुम्ही कोणतेही काम करु नये; तुमच्या प्रत्येक घरासाठी हा तुम्हास पिढ्यानपिढ्या निरंतरचा नियम होय. ");
INSERT INTO mar_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","तसेच तुम्ही आपल्या जमिनीतील पिकाची कापणी कराल तेव्हा तुमच्या शेताच्या कोनाकोपऱ्यातील साऱ्या पिकाची कापणी करु नका आणि सरवा वेचू नका; गरीब व तुमच्या देशातून प्रवास करणाऱ्या उपरी लोकांसाठी तो राहू द्या, मी तुमचा देव परमेश्वर आहे!” ");
INSERT INTO mar_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","आणखी परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएल लोकांस सांग: सातव्या महिन्याचा पहिला दिवस हा विसाव्याचा पवित्र दिवस असावा; त्यादिवशी पवित्र मेळा भरवावा व पवित्र स्मरणासाठी तुम्ही कर्णे फुंकावी; ");
INSERT INTO mar_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","तुम्ही कोणतेही काम करु नये; तर तुम्ही परमेश्वरास अर्पण अर्पावे.” ");
INSERT INTO mar_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“सातव्या महिन्याचा दहावा दिवस हा प्रायश्चिताचा दिवस म्हणून पाळावा; त्यादिवशी पवित्र मेळा भरवावा; काही न खाता आपल्या जिवांस दंडन करून नम्र व्हावे व परमेश्वरास अर्पण अर्पावे. ");
INSERT INTO mar_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","त्यादिवशी तुम्ही कसलेही कामकाज करु नये कारण तो प्रायश्चिताचा दिवस आहे; त्यादिवशी तुमचा देव परमेश्वर याच्यामोर तुमच्यासाठी प्रायश्चित करण्यात येईल. ");
INSERT INTO mar_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","त्यादिवशी जो मनुष्य काही न खाता आपल्या जिवास ताडन करून आपणाला नम्र करणार नाही त्यास आपल्या लोकांतून बाहेर टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","त्यादिवशी कोणाही मनुष्याने जर कसलेही काम केले तर मी देव त्यास त्याच्या लोकातून नाहीसा करीन. ");
INSERT INTO mar_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तुम्ही अजिबात कसलेही काम करु नये; तुम्ही जेथे कोठे राहत असाल तेथे तुमच्या सर्व घराघरात तुम्हास हा पिढ्यानपिढ्या कायमचा नियम होय. ");
INSERT INTO mar_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","तो दिवस तुम्हास पवित्र विसाव्याचा शब्बाथ दिवस व्हावा; त्यादिवशी तुम्ही काही न खाता आपल्या जिवास ताडन करावे व नम्र व्हावे; त्या महिन्याच्या नवव्या दिवसाच्या संध्याकाळापासून सुरवात करून दुसऱ्या दिवशी संध्याकाळपर्यंत तुम्ही हा विसाव्याचा दिवस पाळावा.” ");
INSERT INTO mar_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","परमेश्वर मोशेला पुन्हा म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएल लोकांस सांग: सातव्या महिन्याच्या पंधराव्या दिवसापासून पुढे सात दिवसपर्यंत परमेश्वराकरिता मंडपाचा सण पाळावा; ");
INSERT INTO mar_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहिल्या दिवशी पवित्र मेळा भरवावा; त्यादिवशी कसलेही काम करु नये. ");
INSERT INTO mar_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","सात दिवस परमेश्वरास अर्पण अर्पावे; आठव्या दिवशी दुसरा पवित्र मेळा भरवावा व त्या दिवशीही परमेश्वरास अर्पण अर्पावे; त्यादिवशी तुम्ही कसलेही काम करु नये. ");
INSERT INTO mar_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","परमेश्वराने हे सण नेमलेले आहेत: त्यादिवशी पवित्र मेळे भरवावेत; त्यामध्ये योग्य वेळी हव्य म्हणजे होमार्पण, अन्नार्पण, शांत्यर्पण व पेयार्पण परमेश्वरास अर्पावे. ");
INSERT INTO mar_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","परमेश्वराच्या नेहमीच्या शब्बाथ पालना शिवाय अधिक म्हणून हे सणाचे दिवस तुम्ही साजरे करावेत; तुमची सणाची अर्पणे ही तुमची नवस फेडीची अर्पणे, तुम्ही परमेश्वरास अर्पावयाच्या भेटी व इतर अर्पणे, ह्यांच्यात भर घालणारी अर्पणे असावीत. ");
INSERT INTO mar_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","जमिनीचा उपज गोळा केल्यावर त्याच सातव्या महिन्याच्या पंधराव्या दिवसापासून पुढे सात दिवसापर्यंत परमेश्वराकरिता सण पाळावा; त्यातील पहिला दिवस व आठवा दिवस हे विसाव्याचे दिवस म्हणून पाळावे. ");
INSERT INTO mar_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पहिल्या दिवशी तुम्ही झाडांची चांगली फळे, खजुरीच्या झावळ्या दाट पालवीच्या झाडांच्या डहाळ्या आणि ओहळालगतचे वाळूंज ही घेऊन तुमचा देव परमेश्वर यासमोर सात दिवस उत्सव करावा. ");
INSERT INTO mar_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","प्रत्येक वर्षी सात दिवस परमेश्वराकरिता हा सण पाळावा; तुमचा हा पिढ्यानपिढ्या कायमचा नियम होय; सातव्या महिन्यात हा सण पाळावा. ");
INSERT INTO mar_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","तुम्ही सात दिवस तात्पुरत्या उभारलेल्या मांडवात रहावे; जन्मापासून जे इस्राएल आहेत त्या सर्वानी मांडवात रहावे, ");
INSERT INTO mar_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","म्हणजे तुमच्या पुढील पिढ्यांना कळेल की, मी इस्राएल लोकांस मिसर देशातून बाहेर आणले तेव्हा त्यांना तात्पुरत्या उभारलेल्या मांडवात रहावयास लावले. मी परमेश्वर तुमचा देव आहे!” ");
INSERT INTO mar_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","तेव्हा ह्याप्रमाणे परमेश्वराने नेमिलेले सण मोशेने इस्राएल लोकांस कळवले. ");
INSERT INTO mar_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएल लोकांस आज्ञा कर की, दीप सतत तेवत राहून प्रकाश मिळावा म्हणून जैतूनाचे हातकुटीचे शुद्ध तेल त्यांनी तुझ्याकडे घेऊन यावे. ");
INSERT INTO mar_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","अहरोनाने दर्शनमंडपामध्ये साक्षपटासमोरील अंतरपटाबाहेर परमेश्वरासमोर संध्याकाळपासून सकाळपर्यंत दीप सतत तेवत ठेवावा; हा तुमचा पिढ्यानपिढ्या कायमचा नियम होय. ");
INSERT INTO mar_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","त्याने परमेश्वरासमोर शुद्ध सोन्याच्या दीपवृक्षावरील दिवे सतत तेवत ठेवावे. ");
INSERT INTO mar_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","तू मैदा घेऊन त्याच्या बारा पोळ्या भाज; एक पोळी दोन दशमांश एफाभर सपिठाची करावी. ");
INSERT INTO mar_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","त्यांच्या दोन रांगा करून एका रांगेत सहा सहा पोव्व्या शुद्ध सोन्याच्या मेजावर परमेश्वरासमोर ठेवाव्यात. ");
INSERT INTO mar_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","प्रत्येक रांगेवर धूप ठेव ह्यामुळे परमेश्वरास अग्नींतून केलेल्या अर्पणाचे ते प्रतीक असेल. ");
INSERT INTO mar_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","प्रत्येक शब्बाथ दिवशी अहरोनाने त्या, परमेश्वरासमोर मांडाव्या; इस्राएल लोकांच्या वतीने हा सर्वकाळचा करार होय. ");
INSERT INTO mar_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ती भाकर अहरोन व त्याचे पुत्र ह्यांचा कायमचा वाटा होय; त्यांनी ती पवित्र ठिकाणी खावी; कारण कायमच्या नियमाप्रमाणे परमेश्वरास अर्पिलेल्या अर्पणांपैकी ती त्यास परमपवित्र होय.” ");
INSERT INTO mar_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","त्याकाळी कोणा एका इस्राएली स्त्रीला मिसरी पुरुषापासून झालेला एक मुलगा होता; तो इस्राएली होता व इस्राएल लोकांप्रमाणे वागत होता. तो छावणीत एका इस्राएल मनुष्याशी भांडू लागला. ");
INSERT INTO mar_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","तो इस्राएली स्त्रीचा मुलगा परमेश्वराच्या नांवाची निंदा करून शिव्याशाप देऊ लागला म्हणून लोकांनी त्यास मोशेकडे आणले. त्याच्या आईचे नाव शलोमीथ होते; ती दान वंशातील दिब्री ह्याची मुलगी होती; ");
INSERT INTO mar_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","त्याच्या संबंधी परमेश्वराची आज्ञा स्पष्टपणे कळावी म्हणून त्यांनी त्यास अटकेत ठेवले. ");
INSERT INTO mar_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","मग परमेश्वर देव मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“तुम्ही त्या शिव्याशाप देणाऱ्या मनुष्यास छावणीबाहेर न्या; मग जितक्यांनी ती निंदा ऐकली तितक्यांना एकत्र बोलावा; त्यांनी आपले हात त्या मनुष्याच्या डोक्यावर ठेवावे; आणि मग सर्व लोकांनी त्यास दगडमार करून मारुन टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","तू इस्राएल लोकांस अवश्य सांग की, जो कोणी आपल्या देवाला शिव्याशाप देईल त्याने आपल्या पापाची शिक्षा भोगावी. ");
INSERT INTO mar_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","जो कोणी परमेश्वराच्या नावाची निंदा करील त्यास अवश्य जिवे मारावे; सर्व मंडळीने त्यास दगडमार करावी; तो परदेशीय असो किंवा स्वदेशीय असो, त्याने परमेश्वराच्या नावाची निंदा केली तर त्यास अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","जर एखादा मनुष्य दुसऱ्या मनुष्यास ठार मारील तर त्यास अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","जर कोणी दुसऱ्याच्या पशूस ठार मारील तर त्याने त्याच्या बदली दुसरा पशू देऊन भरपाई करावी. ");
INSERT INTO mar_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","जो कोणी एखाद्याला दुखापत करील त्यास उलट त्याच प्रकारची दुखापत करावी. ");
INSERT INTO mar_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","हाड मोडल्याबद्दल हाड मोडणे, डोळ्याबद्दल डोळा, दाताबद्दल दात; ह्याप्रमाणे एखाद्याने कोणा मनुष्यास जी इजा केली असेल त्याच प्रकारची इजा त्यास केली जावी. ");
INSERT INTO mar_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","पशूला ठार मारणाऱ्याने त्याची भरपाई करावी, पण मनुष्य हत्या करणाऱ्याला अवश्य जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","परदेशीयांना व स्वदेशीयांना एकच नियम लागू असावा; कारण मी परमेश्वर तुमचा देव आहे!” ");
INSERT INTO mar_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","मोशेने इस्राएल लोकांस ह्याप्रमाणे सांगितल्यावर त्यांनी त्या शिव्याशाप देणाऱ्या मनुष्यास छावणीबाहेर नेऊन दगडमार केला; अशाप्रकारे परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे इस्राएल लोकांनी केले. ");
INSERT INTO mar_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","सीनाय पर्वतावर परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","इस्राएल लोकांस असे सांग: मी तुम्हास देत असलेल्या देशात तुम्ही जाऊन पोहोचाल त्यावेळी देशाने परमेश्वरासाठी पवित्र शब्बाथ म्हणजे पवित्र विसाव्याची वेळ पाळावी. ");
INSERT INTO mar_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","सहा वर्षे आपली शेती करावी आणि सहा वर्षे आपल्या द्राक्षमळ्याची छाटणी करावी आणि त्याचे पीक जमा करावे; ");
INSERT INTO mar_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","पण सातव्या वर्षी देशाला विसावा द्यावा म्हणजे परमेश्वराकरिता हा पवित्र शब्बाथाचा विसावा असावा, त्यावर्षी शेते पेरू नयेत आणि द्राक्षमळयाची छाटणी करु नये. ");
INSERT INTO mar_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","तुमचा हंगाम संपल्यानंतर आपोआप उगवलेले ध्यान्य कापू नये; आणि न छाटलेल्या द्राक्षवेलीची फळे गोळा करु नयेत; देशाला ते वर्ष विसाव्याचे वर्ष असावे. ");
INSERT INTO mar_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","तरी तुम्हास शब्बाथाच्या वर्षात भरपूर अन्न मिळेल व तुमच्या दासदासींना, तुमच्या मजुरांना व तुमच्याबरोबर राहणाऱ्या परदेशीयांनाही भरपूर अन्न मिळेल; ");
INSERT INTO mar_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","आणि तुमची गायीगुरे व इतर पशू ह्यांनाही भरपूर खाद्य मिळेल. ");
INSERT INTO mar_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","तसेच तुम्ही सात वर्षाचे सात गट मोजा-सात शब्बाथ वर्षे-म्हणजे सात गुणिले सात इतकी वर्षे मोजा; तो एकोणपन्नास वर्षाचा काळ होईल. ");
INSERT INTO mar_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","मग सातव्या महिन्याच्या दहाव्या दिवशी म्हणजे प्रायश्चिताचा दिवशी मोठ्या आवाजाचे मेंढ्याचे शिंग देशभर सर्वत्र फुंकावे. ");
INSERT INTO mar_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","त्या पन्नासाव्या वर्षाला पवित्र मानावे, आणि देशातील सर्व रहिवासी मुक्त झाल्याची घोषणा करावी; या वर्षाला तुम्ही योबेल म्हणावे; या वर्षी तुम्ही आपापल्या वतनात व आपापल्या कुटुंबात परत जावे. ");
INSERT INTO mar_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","हे पन्नासावे वर्षे तुमच्यासाठी योबेल वर्ष होय; त्यावर्षी तुम्ही काही पेरु नये, आपोआप उगवलेले कापू नये आणि छाटणी न केलेल्या द्राक्षवेलीची फळेही गोळा करु नयेत; ");
INSERT INTO mar_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","कारण ते योबेल वर्ष होय; ते तुम्हाकरिता पवित्र वर्ष असावे; शेतात सापडेल तो उपज तुम्ही खावा. ");
INSERT INTO mar_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","या योबेल वर्षी तुम्ही सर्वांनी आपापल्या वतनात परत जावे. ");
INSERT INTO mar_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","तुम्ही आपल्या शेजाऱ्याला जमीन विकाल किंवा त्याच्याकडून जमीन विकत घ्याल तेव्हा एकमेकावर अन्याय करु नका. ");
INSERT INTO mar_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","तुम्हास तुमच्या शेजाऱ्याकडून जमीन विकत घ्यावयाची असेल तर गेल्या योबेल वर्षापासून किती वर्षे झाली ती मोजा; तुम्हास जमीन विकावयाची असेल तर योबेल वर्ष येईपर्यंत ती किती वर्षे पीक देईल ती मोजा; त्या वर्षावरुन खरेदी विक्रीची किंमत ठरविता येईल, कारण तो फक्त पुढच्या योबेल वर्षापर्यंत पीक घेण्याचे अधिकार तुम्हास विकत आहे. ");
INSERT INTO mar_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","जर वर्षे खूप असतील, तर किंमत जास्त असेल. जर वर्षे कमी असतील तर किंमतही कमी असेल. का? कारण तुमचा शेजारी तुम्हास खरोखर फक्त काही पिकच विकत आहे. पुढच्या योबेलच्या वर्षी जमीन पुन्हा त्याच्या कुटुंबाच्या मालकीची होईल. ");
INSERT INTO mar_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","तुम्ही एकमेकांवर अन्याय करु नये; तुम्ही परमेश्वराचे भय धरावे मी परमेश्वर तुमचा देव आहे! ");
INSERT INTO mar_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","माझ्या विधी नियमांची आठवण ठेवून ते पाळा म्हणजे मग तुम्ही आपल्या देशात सुरक्षित रहाल; ");
INSERT INTO mar_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","आणि भूमी तुम्हाकरिता चांगले पीक देईल; मग तुम्हाकरिता भरपूर अन्न असेल व तुम्ही देशात सुरक्षित रहाल. ");
INSERT INTO mar_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","तुम्ही कदाचित म्हणाल, आम्ही पेरावयाचे नाही व पीक गोळा करावयाचे नाही, तर मग सातव्या वर्षी खाण्याकरिता आम्हास काहीच राहणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","चिंता करु नका! सहाव्या वर्षी मी तुमच्यावर कृपा करीन व मी तुम्हास अशी बरकत देईन की जमीन तुम्हास तीन वर्षाचे पीक देईल. ");
INSERT INTO mar_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","मग आठव्या वर्षी तुम्ही पेराल तोपर्यंत तुम्ही जुना साठा खात रहाल, नवव्या वर्षाचे पीक हाती येईपर्यंत तुम्ही जुना साठा खात रहाल. ");
INSERT INTO mar_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","जमीन खरोखर माझी आहे; म्हणून ती तुम्हास कायमची विकता येणार नाही; तुम्ही परके व उपरी म्हणून माझ्या आश्रयाला आला आहा; ");
INSERT INTO mar_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","म्हणून तुझ्या वतनाच्या सर्व व्यवहारात विकलेली जमीन परत सोडवून त्यांच्या घराण्यातील कुळाला परत मिळण्याची तरतुद करावी. ");
INSERT INTO mar_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","तुझा कोणी भाऊबंद कंगाल झाला आणि त्याने आपल्या वतनातील मालमत्तेचा काही भाग विकला तर त्याच्या सगळ्यात जवळच्या नातलगाने पुढे येऊन आपल्या नातलगाकरिता खंडणी भरुन ती मालमत्ता परत विकत घेऊन सोडवावी. ");
INSERT INTO mar_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","आपल्या वतनाचा भाग सोडवून घ्यावयास एखाद्या मनुष्यास आपला जवळचा नातलग नसेल परंतु तो भाग सोडवून घ्यावयास त्याची स्वत:ची ऐपत वाढली असेल. ");
INSERT INTO mar_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","तर त्याने जमीन विकल्यापासूनची वर्षे मोजावीत आणि त्यांची संख्या पाहून त्या जमिनीसाठी किती किंमत द्यायची ते ठरवावे आणि ज्याला त्याने जमीन विकली असेल त्यास शिल्लक राहिलेली रक्कम द्यावी. ");
INSERT INTO mar_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","पण ते वतन परत मिळविण्याची त्यास ऐपत नसेल तर आपली जमीन त्याने योबेल वर्षापर्यंत विकत घेणाऱ्याच्या ताब्यात राहू द्यावी; योबेल वर्षी ती सुटेल आणि मग ते वतन परत योग्य मालकाकडे जाईल. ");
INSERT INTO mar_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","एखाद्या मनुष्याने तटबंदीच्या नगरात असलेले आपले घर विकले, तर ते विकल्यावर एक वर्षाच्या आत सोडवून परत घेण्याचा त्यास हक्क आहे, व तो हक्क एक वर्षभर राहील. ");
INSERT INTO mar_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","परंतु वर्ष संपण्याच्या आत त्याने ते सोडविले नाहीतर तटबंदीच्या नगरातले ते घर विकत घेणाऱ्याचे होईल व पिढ्यानपिढया त्याच्या वंशात कायम राहील; योबेल वर्षी ते आपल्या पहिल्या मालकाकडे परत जाणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","तटबंदी नसलेली नगरे उघड्या शेतासमान समजली जावी; म्हणून त्यातील घरे योबेल वर्षी ते परत विकत घेतले जातील व त्यांच्या पहिल्या मालकाकडे जातील. ");
INSERT INTO mar_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","परंतु लेव्यांच्या नगराविषयी म्हणावयाचे झाले तर त्यातील घरे लेव्यांना पाहिजे तेव्हा सोडविता येतील. ");
INSERT INTO mar_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","एखाद्या लेव्याच्या वतनाच्या नगरातले घर जर कोणी विकत घेतले व ते त्यास सोडवता आले नाही तर ते घर योबेल वर्षी परत त्या लेव्याचेच होईल; कारण लेव्यांच्या वतनाच्या नगरातली घरेच काय ती लेवी वंशाची वतने होत; ती इस्राएल लोकांनी त्यांना दिलेली आहेत. ");
INSERT INTO mar_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","लेवी लोकांच्या नगराभोवतीच्या शिवारातल्या जमिनी व कुरणे विकता येणार नाहीत; ती कायमची त्यांच्या मालकीची होत. ");
INSERT INTO mar_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","तुझा एखादा भाऊबंद, त्याचे स्वत:चे पोट देखील भरता येऊ नये, इतका कंगाल झाला तर तू त्यास परक्या किंवा उपऱ्याप्रमाणे तुझ्याजवळ राहू द्यावे; ");
INSERT INTO mar_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","त्यास तू पैसे देशील तर त्यावर व्याज घेऊ नको. परमेश्वर देवाचे भय धर व आपल्या भाऊबंदाला आपल्यापाशी राहू दे. ");
INSERT INTO mar_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तू त्यास उसने दिलेल्या पैशांवर व्याज घेऊ नको आणि त्यास विकलेल्या अन्न धान्यावर नफा काढण्याचा प्रयत्न करु नको. ");
INSERT INTO mar_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","मी परमेश्वर तुमचा देव आहे; तुम्हास कनान देश द्यावा व तुमचा देव व्हावे म्हणून मी तुम्हास मिसर देशातून बाहेर आणले. ");
INSERT INTO mar_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","तुझा एखादा भाऊबंद तुझ्यासमोर इतका कंगाल झाला की त्याने स्वत:ला तुला दास म्हणून विकले तर त्यास गुलामाप्रमाणे राबवून घेऊ नको; ");
INSERT INTO mar_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","योबेल वर्षापर्यंत त्याने मजुराप्रमाणे किंवा उपऱ्याप्रमाणे तुझ्यापाशी रहावे व तुझी सेवाचाकरी करावी. ");
INSERT INTO mar_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","त्यावर्षी त्याने आपल्या मुलांबाळासह तुझ्यापासून निघून आपल्या वाडवडिलांच्या वतनात परत जावे. ");
INSERT INTO mar_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","कारण ते माझे दास आहेत! मी त्यांना मिसर देशातून सोडवून बाहेर आणले; त्यांनी पुन्हा दास होऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","तू धनी म्हणून त्याच्यावर कठोरपणाने अधिकार चालवू नको; आपल्या देवाचे भय धर. ");
INSERT INTO mar_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","तुमच्या दासदासी; तुमच्या देशासभोवतीच्या राष्ट्रातून तुम्ही आपणासाठी गुलाम आणावे. ");
INSERT INTO mar_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","तसेच तुमच्या देशात राहणाऱ्या परदेशीय किंवा उपऱ्या लोकांच्या कुटुंबात जन्मलेली मुले तुम्ही गुलाम म्हणून विकत घ्यावी; ती तुमची मालमत्ता होतील; ");
INSERT INTO mar_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तुम्ही त्यांचा ताबा आपल्यामागे आपल्या मुलांना द्यावा म्हणजे ते तुमच्या मुलांचे दासदासी होतील; त्या लोकांस तुम्ही कायमचे गुलाम करून घ्यावे; पण तुमच्या इस्राएल भाऊबंदानी आपला अधिकार एकमेकांवर कठोरपणाने चालवू नये. ");
INSERT INTO mar_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","तुझा एखादा परदेशीय किंवा उपरी शेजारी धनवान झाला व त्याच्यापाशी असलेला तुझा एखादा बंधू कंगाल होऊन त्याने स्वत:स तुम्हामध्ये राहत असणाऱ्या त्या परदेशीयाला किंवा परदेशीयाच्या कुटुंबातील एखाद्याला गुलाम म्हणून विकले असेल; ");
INSERT INTO mar_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","तर त्यांची विक्री झाल्यावरही त्यास स्वत:ला सोडवून घेण्याचा हक्क राहील; त्याच्या भाऊबंदापैकी कोणासही त्यास सोडवता येईल. ");
INSERT INTO mar_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","किंवा त्याचा चुलता, चुलत भाऊ अथवा त्याच्या कुळापैकी कोणी जवळचा नातलग ह्यांना त्यास सोडवता येईल किंवा तो स्वत:च धनवान झाला तर त्यास स्वत: पैसे भरुन स्वत:ची सुटका करून घेता येईल. ");
INSERT INTO mar_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","त्यास विकत घेणाऱ्या परदेशीयाच्या बरोबर त्याने आपल्या विक्रीच्या वर्षापासून योबेल वर्षापर्यंत हिशोब करावा आणि वर्षाच्या संख्येप्रमाणे विक्रीची किंमत ठरवावी; कारण खरे पाहता त्या मालकाने त्यास फक्त थोडी वर्षे मजुराच्या रोजाप्रमाणे लावल्यासारखेच आहे! ");
INSERT INTO mar_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","योबेलास बरीच वर्षे असतील तर विक्रीच्या रकमेतून आपल्या मुक्ततेचे मोल त्या वर्षाच्या संख्येच्या प्रमाणात त्यास परत द्यावे; ते वर्षाच्या संख्येवर अवलंबून राहील. ");
INSERT INTO mar_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","योबेलास थोडीच वर्षे असतील तर त्याने मूळ किंमतीपैकी थोडाच भाग परत करावा. ");
INSERT INTO mar_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","त्याने आपल्या मालकापाशी सालादाराप्रमाणे रहावे; तुमच्यासमोर त्याच्या मालकाचा अधिकार कठोरपणाने तुम्ही त्याच्यावर चालू देऊ नये. ");
INSERT INTO mar_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","जरी त्या मनुष्यास पुन्हा कोणी विकत घेतले नाही, तरी तो स्वतंत्र होईल. योबेल वर्षी तो व त्याची मुलेबाळे मुक्त होतील. ");
INSERT INTO mar_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","कारण इस्राएल लोक माझे दास आहेत; त्या माझ्या दासांना मी मिसर देशातून बाहेर आणले आहे. मी तुमचा देव परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","तुम्ही आपणासाठी मूर्ती करु नका, तसेच कोरीव मूर्ती किंवा स्तंभ आकृती कोरलेला पाषाण पूजा करण्यासाठी आपल्या देशात, उभारू नका कारण मी परमेश्वर तुमचा देव आहे. ");
INSERT INTO mar_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","तुम्ही माझ्या पवित्र विसाव्याच्या दिवसाची पवित्र शब्बाथांची आठवण ठेवून तो पाळावा आणि माझ्या पवित्र स्थांनाविषयी आदर बाळगावा. मी परमेश्वर आहे. ");
INSERT INTO mar_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","तुम्ही आठवण ठेवून माझ्या नियमाप्रमाणे चालावे व माझ्या आज्ञा पाळाव्या, ");
INSERT INTO mar_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","तुम्ही असे कराल तर मी तुमच्यासाठी योग्य वेळी पाऊस पाडीन; जमीन आपले पीक देईल व मळ्यातील झाडे आपापली फळे देतील. ");
INSERT INTO mar_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","तुम्ही द्राक्षांच्या हंगामापर्यंत धान्याची मळणी करीत रहाल आणि पेरणीच्या दिवसापर्यंत द्राक्षांची तोडणी करीत रहाल. मग खाण्याकरिता तुम्हाजवळ भरपूर अन्न असेल, आणि तुम्ही आपल्या देशात सुरक्षित रहाल. ");
INSERT INTO mar_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","मी तुमच्या देशाला शांतता देईन; तुम्ही शांतीने झोपी जाल; तुम्हास कोणाची भीती वाटणार नाही, मी हिंस्र पशूंना तुमच्या देशाबाहेर ठेवीन आणि तुमच्या देशावर कोणी सैन्य चाल करून येणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","तुम्ही तुमच्या शत्रूंचा पाठलाग कराल व त्यांचा पराभव कराल. तुम्ही तुमच्या तलवारींनी त्यांचा वध कराल. ");
INSERT INTO mar_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तुमच्यातील पाच जण शंभरांना व शंभरजण दहा हजारांना पळवून लावतील. तुम्ही तुमच्या शत्रूंचा पराभव कराल, व तुमच्या तलवारीने त्यांना ठार माराल. ");
INSERT INTO mar_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","मग मी तुमच्याकडे वळेन व तुम्हास भरपूर संतती देईन आणि तुमच्याशी केलेला माझा करार पक्का करीन; ");
INSERT INTO mar_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","तुम्हास मुबलक धान्य मिळेल व ते वर्षभर पुरुन उरेल. तुम्हास नवीन धान्य आल्यावर जुने बाहेर काढावे लागेल म्हणजे नवीन धान्य ठेवावयास जागा मिळेल. ");
INSERT INTO mar_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","मी तुम्हामध्ये माझी वस्ती करीन; आणि मी तुमचा तिरस्कार करणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","मी तुमच्यामध्ये चालेन आणि तुमचा देव होईन, आणि तुम्ही माझे लोक व्हाल. ");
INSERT INTO mar_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","मी परमेश्वर तुमचा देव आहे. मिसर देशात तुम्ही गुलाम होता. मी तुम्हास मिसर देशातून बाहेर काढले; गुलाम म्हणून काम करताना जड वजनांचा भार वाहून तुम्ही वाकून गेला होता. परंतु तुमच्या खांद्यावरील जोखड मोडून मी तुम्हास पुन्हा ताठ चालवले आहे! ");
INSERT INTO mar_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","परंतु जर तुम्ही माझे ऐकले नाही व या सर्व आज्ञा पाळल्या नाहीत; ");
INSERT INTO mar_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","तुम्ही जर माझे विधि मानण्यास नकार दिला व माझ्या आज्ञा पाळण्याचे तुच्छ मानले, आणि माझ्या सर्व आज्ञा अमान्य करून माझा करार मोडला. ");
INSERT INTO mar_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","जर तुम्ही तसे कराल तर मग तुम्हावर भयंकर संकटे येतील असे मी करीन; क्षयरोग व ताप ह्यानी मी तुम्हास पीडीन; ती तुमची दृष्टी नष्ट करतील, व तुमचा जीव घेतील; तुम्ही बियाणे पेराल पण तुम्हास यश मिळणार नाही तुम्हास पीक मिळणार नाही आणि तुमचे शत्रू तुमचे धान्य खाऊन टाकतील. ");
INSERT INTO mar_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","मी माझे मुख तुमच्याविरुध्द करीन, म्हणून तुमचे शत्रू तुमचा पराभव करतील; जे लोक तुमचा द्वेष करीतात ते तुमच्यावर अधिकार गाजवतील, आणि कोणी तुमचा पाठलाग करत नसतानाही तुम्ही पळाल. ");
INSERT INTO mar_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","या नंतरही जर तुम्ही माझ्या आज्ञा पाळणार नाही; तर तुमच्या पापाबद्दल मी तुम्हास सातपट शिक्षा करीन. ");
INSERT INTO mar_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","मी तुमच्या बळाचा गर्व मोडून टाकीन; तुमचे आकाश लोखंडासारखे व तुमची जमीन पितळेसारखी करीन. ");
INSERT INTO mar_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तुम्ही खूप कष्ट कराल पण त्याचा काही उपयोग होणार नाही; कारण तुमची जमीन पीक देणार नाही व तुमची झाडे फळे देणार नाहीत. ");
INSERT INTO mar_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","तरीसुध्दा तुम्ही माझ्याविरूद्ध वागाल व माझ्या आज्ञा पाळण्यास नकार द्याल तर मी तुम्हावर तुमच्या पापांच्या मानाने सातपट अधिक संकटे आणीन. ");
INSERT INTO mar_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","मी तुमच्यावर हिंस्त्र पशू पाठवीन आणि ते तुमच्या मुलांबाळांना उचलून घेऊन जातील; ते तुमच्या गुराढोरांचा नाश करतील; आणि तुमची संख्या कमी करतील. त्यामुळे तुमचे रस्ते ओस पडतील. ");
INSERT INTO mar_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","एवढे करुनही तुम्ही माझ्या शिक्षणाचा स्वीकार केला नाही परंतु माझ्या विरुध्द चालत राहिलात, ");
INSERT INTO mar_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","तर मी ही तुमच्याविरुध्द होईन आणि, मीच तुमच्या पापाबद्दल तुम्हास सातपट ताडण करीन. ");
INSERT INTO mar_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","मी तुमच्यावर तलवार आणीन ती करार मोडल्याचा बदला घेईल. तुम्ही आपआपल्या नगरांत जमा व्हाल, तेव्हा मी तेथे तुमच्यावर आजार पाठवीन, आणि तुम्ही तुमच्या शत्रुच्या बळामुळे पराभुत व्हाल. ");
INSERT INTO mar_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","मी तुमच्या धान्याचा पुरवठा बंद करील तेव्हा दहा स्त्रिया एकाच चुलीवर तुमची भाकर भाजतील व ती तुम्हास तोलून देतील; ती तुम्ही खाल पण तुम्ही तृप्त होणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","एवढे सर्व करुनही तुम्ही माझे ऐकले नाही व तुम्ही माझ्याविरूद्ध वागला, ");
INSERT INTO mar_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","तर मग संतापून मी तुमच्याविरुध्द चालेन आणि तुमच्या पापाबद्दल तुम्हास सातपट शिक्षा करीन! ");
INSERT INTO mar_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तुमच्या मुलांचे व मुलींचे मांस खाण्याची पाळी तुम्हावर येईल. ");
INSERT INTO mar_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","तुमच्या पुजेची उच्चस्थाने मी नष्ट करीन; तुमच्या धूपवेद्या फोडून टाकीन आणि तुमच्या मूर्तीच्या मढ्यांवर तुमची मढी टाकीन; मला तुमचा वीट येईल. ");
INSERT INTO mar_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","मी तुमची नगरे नष्ट करीन, तुमची पवित्र स्थळे ओसाड करीन. तुमच्या सुवासिक द्रव्याचा वास मी घेणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","मी तुमचा देश ओसाड करीन; हे पाहून तुमच्या देशात राहण्यास येणारे तुमचे शत्रू चकित होतील. ");
INSERT INTO mar_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","परराष्ट्रांमध्ये मी तुमची पांगापांग करीन; मी माझी तलवार उपसून तुमच्या पाठीस लागेन. तुमच्या देशाचा नाश होईल आणि तुमची शहरे ओसाड पडतील. ");
INSERT INTO mar_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","जितके दिवस देश ओसाड पडून राहील आणि तुम्ही आपल्या शत्रूंच्या देशात रहाल तितके दिवस तुमचा देश आपले शब्बाथ उपभोगीत राहील. ");
INSERT INTO mar_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","देश ओसाड असेपर्यंत तुम्ही राहत असताना तुमच्या शब्बाथांनी मिळाला नाही इतका विसावा त्यास मिळेल. ");
INSERT INTO mar_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","तुमच्यातील जे उरतील त्यांच्या मनात ते शत्रुंच्या देशात असता मी अशी भिती घालीन की, उडणाऱ्या पाचोळ्याच्या आवाजाने ते पळून जातील, तलवार पाठीमागे लागल्यासारखे ते पळतील; कोणी पाठीमागे लागले नसतांनाही ते पडतील. ");
INSERT INTO mar_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","कोणी पाठीस लागले नसतांनाही तलवार पाठीस लागल्याप्रमाणे अडखळून एकमेंकावर पडतील. तुमच्या शत्रूविरूद्ध उभे राहण्याइतके बळ तुमच्यात नसणार. ");
INSERT INTO mar_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","राष्ट्राराष्ट्रात पांगून तुमच्या शत्रूंच्या देशात तुम्ही नाहीसे व्हाल. ");
INSERT INTO mar_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","तेव्हा उरलेले त्यांच्या शत्रूंच्या देशात आपल्या पापामुळे खंगत जातील आणि त्यांचे वाडवडील जसे त्यांच्या पापात खंगले त्याप्रमाणे ते आपल्या पापात खंगत जातील. ");
INSERT INTO mar_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","परंतु कदाचित ते आपली पापे व आपल्या वाडवडीलांची पापे व त्यांनी माझ्याविरूद्ध अपराध केला व माझ्या विरुध्द चालले हे कबूल करतील. ");
INSERT INTO mar_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","या कारणामुळे, मीही त्यांच्याविरुद्ध होऊन, त्यांना त्यांच्या शत्रूंच्या देशात आणले असे ते कबूल करतील आणि त्यांचे अशुद्ध हृदय लीन होऊन ते आपल्या पापांबद्दलची शिक्षा मान्य करतील. ");
INSERT INTO mar_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","तेव्हा जो करार मी याकोबाशी केला तो मी आठवेन तसेच इसहाकाशी केलेला करार व अब्राहाम ह्याच्याशी केलेला करार यांची मी आठवण करीन व त्या देशाचीही मी आठवण करीन. ");
INSERT INTO mar_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","त्यांच्यावाचून देश ओस पडेल आणि ओस असेपर्यंत तो आपल्या शब्बाथांचा विसावा उपभोगीत राहील; त्यांनी माझे विधी मानण्यास नकार दिला व माझे नियम तुच्छ लेखले म्हणूनच त्यांना त्यांच्या पापाचा दंड भरावा लागेल. ");
INSERT INTO mar_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","इतके असताही ते त्यांच्या शत्रुंच्या देशात असताना, त्यांचा सपूंर्ण नाश करावा व त्यांच्याशी केलेला करार अगदी मोडून टाकावा, एवढा त्यांचा मी नकार करणार नाही, कारण मी परमेश्वर त्यांचा देव आहे. ");
INSERT INTO mar_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","त्यांच्याकरिता मी त्यांच्या वाडवडिलांशी केलेल्या कराराची आठवण करीन, कारण मी त्यांचा देव व्हावे म्हणून त्यांच्या वाडवडिलांना मिसर देशातून बाहेर आणले आणि हे सर्व इतर राष्ट्रांनी पाहिले आहे. मी परमेश्वर आहे! ");
INSERT INTO mar_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","हे विधी, नियम व निर्बंध परमेश्वराने इस्राएल लोकांसाठी दिले. हे नियम परमेश्वर व इस्राएल लोक ह्यांच्यामधील करार आहे. हे नियम परमेश्वराने सीनाय पर्वतापाशी मोशेला दिले ते हेच होत मोशेने हे नियम इस्राएल लोकांस सांगितले. ");
INSERT INTO mar_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","इस्राएल लोकांस सांग: एखाद्या मनुष्याने परमेश्वरास मानवाचा विशेष नवस केला तर त्या मनुष्याचे मोल याजकाने याप्रमाणे ठरवावे. ");
INSERT INTO mar_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","वीस ते साठ वर्षे वयाच्या आतील पुरुषाचे मोल पवित्रस्थानातील शेकेलाच्या चलनाप्रमाणे पन्नास शेकेल रुपे असावे, ");
INSERT INTO mar_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","आणि त्याच वयाच्या स्त्रीचे मोल तीस शेकेल रुपे असावे. ");
INSERT INTO mar_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","मुलगा पाच वर्षे ते वीस वर्षांच्या आतील वयाचा असेल तर त्याचे मोल वीस शेकेल रुपे व मुलीचे दहा शेकेल रुपे असावे. ");
INSERT INTO mar_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","मुलगा एक महिन्याहून मोठा व पाचवर्षाहून लहान असला तर त्याचे मोल पाच शेकेल रुपे व मुलीचे तीन शेकेल रुपे असावे. ");
INSERT INTO mar_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","साठ वर्षे वा साठ वर्षाहून अधिक वर्षे वयाच्या पुरुषाचे मोल पंधरा शेकेल रुपे व स्त्रीचे दहा शेकेल रुपे असावे. ");
INSERT INTO mar_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","परंतु तू ठरविलेले मोल न देण्याइतका कोणी गरीब असेल तर त्यास याजकापुढे आणावे; आणि याजकाने नवस करणाऱ्याच्या ऐपतीप्रमाणे नवसाच्या मानवाचे मोल ठरवावे. ");
INSERT INTO mar_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","काही पशू परमेश्वरास अर्पण करता येतात त्यापैकी कोणी एखाद्या पशूचा नवस केला तर परमेश्वरास अर्पावयाचा असा प्रत्येक प्राणी पवित्र समजावा. ");
INSERT INTO mar_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","त्याने तो बदलू नये किंवा त्याच्या ऐवजी दुसरे काही देण्याचा प्रयत्न करु नये. त्याने वाईट पशू ऐवजी चांगला किंवा चांगल्याबद्दल वाईट असा बदल करू नये त्याने जर तसा बदल करण्याचा प्रयत्न केला तर मग ते दोन्ही पवित्र होतील व दोन्ही परमेश्वराच्या मालकीचे होतील. ");
INSERT INTO mar_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","काही पशू परमेश्वरास अर्पण करावयास योग्य नसतात ते अशुद्ध असतात कोणी अशुद्ध पशूपैकी एखादा परमेश्वरास अर्पण करावयास आणला तर त्याने तो याजकाकडे आणावा. ");
INSERT INTO mar_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","तो पशू चांगला असो किंवा वाईट असो याजकाने त्याचे मोल ठरवावे; याजक ठरवील ते त्याचे मोल समजावे. ");
INSERT INTO mar_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","पण नवस करणाऱ्याला तो पशू सोडवावयाचा असला तर त्या किंमतीत आणखी एकपंचमांश भर घालून त्याने तो सोडवावा. ");
INSERT INTO mar_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","एखाद्याने आपले घर परमेश्वरास वाहिले तर ते चांगले असो किंवा वाईट असो याजकाने त्या घराचे मोल ठरवावे; याजक ठरवील ते त्याचे मोल समजावे. ");
INSERT INTO mar_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","परंतु घर वाहणाऱ्याला ते सोडवून परत घ्यावयाचे असेल तर त्याने, याजकाने ठरवलेल्या किंमतीत एकपंचमांश भर घालून ते सोडवावे; मग ते घर त्याचे होईल. ");
INSERT INTO mar_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","एखाद्याने आपल्या शेतीचा काही भाग परमेश्वरास वाहिला तर त्यामध्ये किती बियाणे पेरले जाते त्यावरुन त्याचे मोल ठरेल; एक होमर, सुमारे सहा बुशेल जवासाठी पन्नास शेकेल रुपे अशी किंमत असावी. ");
INSERT INTO mar_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","योबेल वर्षापासून त्याने आपले शेत देवाला वाहिले तर याजक ठरविल त्याप्रमाणे त्याचे मोल होईल. ");
INSERT INTO mar_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","परंतु योबेल वर्षानंतर जर एखाद्याने आपले शेत परमेश्वरास वाहिले तर पुढच्या योबेल वर्षापर्यंत जितकी वर्षे उरली असतील तितक्या वर्षाचा हिशोब करून याजकाने त्याचे नक्की मोल ठरवावे. ");
INSERT INTO mar_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","शेत वाहणाऱ्याला, मोल देऊन आपले शेत सोडवून परत घ्यावयाचे असले तर त्याच्या ठरवलेल्या किंमतीत एकपंचमांश भर घालून त्याने ते सोडवावे. मग ते शेत परत त्याच्या मालकीचे होईल. ");
INSERT INTO mar_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","त्याने ते शेत सोडविले नसेल किंवा दुसऱ्या कोणाला ते विकले असेल तर त्या पहिल्या मालकाला ते सोडवून घेता येणार नाही; ");
INSERT INTO mar_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","पण योबेल वर्षी ते शेत परत विकत घेतले नाही तेव्हा पूर्णपणे समर्पित केलेल्या शेताप्रमाणे परमेश्वराकरिता ते पवित्र ठरेल, अर्थात ते याजकाचे कायमचे वतन होईल. ");
INSERT INTO mar_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","स्वत:च्या कुळाचे नसलेले म्हणजे एखाद्याने स्वत: खरेदी केलेले शेत त्यास परमेश्वराकरिता अर्पण करावयाचे असेल, ");
INSERT INTO mar_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","तर याजकाने योबेल वर्षापर्यंत त्याचा हिशोब करावा व जितके मोल ठरेल तितके परमेश्वराकरिता पवित्र समजून त्याने त्याच दिवशी ते देऊन टाकावे. ");
INSERT INTO mar_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ज्याच्याकडून त्याने ते शेत पहिल्यांदा खरेदी केलेले असेल म्हणजे ज्याच्या वतनाचे ते असेल त्याच्या ताब्यात ते योबेल वर्षी परत जावे. ");
INSERT INTO mar_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","मोल देताना ते पवित्रस्थानातील चलनाप्रमाणे ठरविलेले असावे. शेकेल म्हणजे वीस गेरा. ");
INSERT INTO mar_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","लोकांस गुरेढोरे, शेरडेमेढंरे विशेष देणग्या म्हणून अर्पण करता येतील परंतु त्यापैकी प्रथम जन्मलेला नर परमेश्वराचा ठरलेला आहेच; त्याला, ते विशेष भेट म्हणून वाहू शकणार नाहीत. ");
INSERT INTO mar_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","तो प्रथम जन्मलेला नर अशुद्ध पशूपैकी असला तर याजकाने ठरवलेल्या मोलात एकपंचमांश भर घालून अर्पण करणाऱ्याने तो सोडवावा; पण तो सोडवीत नसला तर याजकाने ठरवलेल्या किंमतीला तो विकून टाकावा. ");
INSERT INTO mar_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","लोक परमेश्वरास काही विशेष देणगी देतात, ती देणगी माणसे, पशू किंवा वतनांची शेते या प्रकारची असेल, ती देणगी परमेश्वराचीच आहे; ती सोडवून परत घेता येणार नाही किंवा विकता येणार नाही. ");
INSERT INTO mar_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ती वाहिलेली विशेष देणगी मानव प्राण्यांपैकी असेल तर त्या मानवाला सोडवून घेता येणार नाही; त्याचा अवश्य वध करावा. ");
INSERT INTO mar_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","भूमीच्या सर्व उत्पन्नाचा एक दशांश भाग म्हणजे, शेतातील सर्व उपज, आणि झाडे, वेली यांची फळे ह्यांचा एक दशांश भाग परमेश्वराकरिता पवित्र आहे. ");
INSERT INTO mar_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","म्हणून एखाद्याला आपला एक दशांश भाग सोडवून घ्यावयाचा असला तर त्याच्या किंमतीत एक पंचमांशाची भर घालून त्याने तो सोडवावा. ");
INSERT INTO mar_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","गुरेढोर किंवा शेरडेमेंढरे ह्यापैकी ज्यांची गणना काठीखालून चालवून होते अशा प्रत्येक दहांपैकी एक पशू याजक घेईल. प्रत्येक दहावे जनावर परमेश्वराचे वेगळे केलेले असेल. ");
INSERT INTO mar_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","निवडलेला पशू चांगला आहे किंवा वाईट आहे या विषयी त्याच्या धन्याने चिंता करु नये किंवा त्यास बदलू नये; त्याने बदल करावयाचे ठरविले तर मग तो पशू व त्याच्या बदलीचा पशू असे दोन्ही पशू परमेश्वराकरिता पवित्र होतील; किंमत देऊन ते सोडविता येणार नाहीत. ");
INSERT INTO mar_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","परमेश्वराने इस्राएल लोकांकरिता सीनायपर्वतावर मोशेला दिलेल्या आज्ञा याच आहेत.");
INSERT INTO mar_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","इस्राएल लोक मिसर देशातून निघाल्यावर दुसऱ्या वर्षाच्या दुसऱ्या महिन्याच्या पहिल्या दिवशी सीनाय रानातील दर्शनमंडपामध्ये परमेश्वर मोशेशी बोलला; परमेश्वर म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","सर्व इस्राएली लोकांच्या मंडळीची शिरगणती कर; प्रत्येक पुरुषाचे नांव, त्याचे कूळ आणि त्याच्या वाडवडिलांचे घराणे ह्याच्यासह त्यांच्या नावांची यादी कर. ");
INSERT INTO mar_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","वीस वर्षाचे किंवा त्याहून अधिक वयाचे जितके पुरुष सैन्यात जाण्यायोगे इस्राएलात असतील त्या सर्वाची त्यांच्या सैन्याप्रमाणे तू आणि अहरोन मिळून गणती करा. ");
INSERT INTO mar_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","प्रत्येक वंशातला एक पुरुष जो आपल्या वडिलांच्या घराण्याचा प्रमुख असेल तो तुम्हास मदत करील. ");
INSERT INTO mar_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","तुमच्याबरोबर राहून तुम्हास मदत करणाऱ्यांची नावे हीः रऊबेन वंशातला, शदेयुराचा मुलगा अलीसूर; ");
INSERT INTO mar_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शिमोन वंशातला सुरीशाद्दैचा मुलगा शलूमीयेल. ");
INSERT INTO mar_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदा वंशातला अम्मीनादाबाचा मुलगा नहशोन; ");
INSERT INTO mar_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्साखार वंशातला सुवाराचा मुलगा नथनेल; ");
INSERT INTO mar_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जबुलून वंशातला हेलोनाचा मुलगा अलीयाब. ");
INSERT INTO mar_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","योसेफ पुत्राच्या वंशात म्हणजे एफ्राइम वंशातला अम्मीहूदाचा मुलगा अलीशामा, आणि मनश्शे वंशातला पदाहसुराचा मुलगा गमलीयेल. ");
INSERT INTO mar_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बन्यामीन वंशातला गिदोनीचा मुलगा अबीदान. ");
INSERT INTO mar_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान वंशातला अम्मीशाद्दैचा मुलगा अहीएजर; ");
INSERT INTO mar_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेर वंशातला आक्रानाचा मुलगा पागीयेल; ");
INSERT INTO mar_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गाद वंशातला दगुवेलाचा मुलगा एल्यासाप; ");
INSERT INTO mar_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नफताली वंशातला एनानाचा मुलगा अहीरा. ");
INSERT INTO mar_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","हे लोकांतून निवडलेले माणसे होती, त्यांच्या पूर्वजांच्या वंशाचे अधिपती होते. ते इस्राएलाच्या कुळाचे प्रमुख होते. ");
INSERT INTO mar_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ज्यांच्या नावाची नोंद होती त्या मनुष्यांना मोशे व अहरोन ह्यानी आपल्याबरोबर घेतले; ");
INSERT INTO mar_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","आणि त्यांनी दुसऱ्या महिन्याच्या पहिल्या दिवशी सर्व मंडळीस एकत्र जमविले; मग इस्राएलाच्या कुळांप्रमाणे व त्यांच्या वडिलांच्या घराण्यांप्रमाणे त्यांची नोंद करण्यात आली. वीस किंवा त्यापेक्षा जास्त वय असलेल्यांची यादी करण्यात आली. ");
INSERT INTO mar_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","परमेश्वराने मोशेला आज्ञा दिली होती अगदी त्याप्रमाणे त्याने सीनाय रानात त्यांची गणती केली. ");
INSERT INTO mar_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","इस्राएलाचा ज्येष्ठ मुलगा रऊबेन ह्याच्या वंशाचे लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी त्यांची गणना करण्यात आली. ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्यापेक्षा अधिक वयाचे असून युद्धास लायक होते त्यांची यादी करण्यात आली; त्यांची यादी घराणी आणि कुळे ह्याच्याप्रमाणे करण्यात आली. ");
INSERT INTO mar_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","रऊबेनाच्या वंशातले मोजलेले एकूण शेहेचाळीस हजार पाचशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","शिमोन वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्यापेक्षा अधिक वयाचे असून सैन्यात दाखल होण्यास लायक होते त्यांची यादी करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","शिमोनाच्या वंशातले मोजलेले एकूण एकोणसाठ हजार तीनशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गाद वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्यापेक्षा अधिक वयाचे असून युद्धास लायक होते त्यांची यादी करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","गादाच्या वंशातले मोजलेले एकूण पंचेचाळीस हजार सहाशे पन्नास भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदा वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्यापेक्षा अधिक वयाचे असून युद्धास लायक होते, त्या सर्वाची नोंद करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","यहूदाच्या वंशातले मोजलेले एकूण चौऱ्याहत्तर हजार सहाशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्साखार वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्याहून अधिक वयाचे असून युद्धास लायक होते त्या सर्वाची नोंद करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इस्साखाराच्या वंशातले मोजलेले एकूण चौपन्न हजार चारशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","जबुलून वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्याहून अधिक वयाचे असून युद्धास लायक होते त्या सर्वांची नोद करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","जबुलून वंशातील मोजदाद एकूण सत्तावन्न हजार चारशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","योसेफ पुत्रांपैकी एफ्राइम वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्याहून अधिक वयाचे असून युद्धास लायक होते त्या सर्वांची नोंद करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","एफ्राइमाच्या वंशातले मोजलेले एकूण चाळीस हजार पाचशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","मनश्शे वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्याहून अधिक वयाचे असून युद्धास लायक होते त्या सर्वांची नोंद करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मनश्शेच्या वंशात मोजलेले एकूण बत्तीस हजार दोनशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बन्यामीन वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्याहून अधिक वयाचे असून युद्धास लायक होते त्या सर्वांची नोंद करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","बन्यामीन वंशातील लोकांची जी मोजदाद झाली ती एकूण पस्तीस हजार चारशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दान वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्याहून अधिक वयाचे युद्धास लायक होते त्या सर्वांची नोंद करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","दानाच्या वंशातले मोजलेले एकूण बासष्ट हजार सातशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आशेर वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षांचे व त्याहून अधिक वयाचे असून सैन्यात सेवा करण्यास लायक होते त्या सर्वांची नोंद करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","आशेर वंशातील लोकांची जी मोजदाद झाली ती एकूण एकेचाळीस हजार पाचशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नफताली वंशातील लोक म्हणजे त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे जितके पुरुष वीस वर्षाचे व त्याहून अधिक वयाचे असून युद्धास लायक होते त्या सर्वांची नोंद करण्यात आली. ");
INSERT INTO mar_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","नफतालीच्या वंशातील मोजलेले एकूण त्रेपन्न हजार चारशे भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मोशे, अहरोन आणि इस्राएलांच्या प्रत्येक घराण्यातील एक प्रमुख असे बारा नेते, ह्यानी ही मोजदाद केली. ");
INSERT INTO mar_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","इस्राएली वंशातले वीस वर्षांचे व त्याहून अधिक वयाचे असून युद्धास लायक असलेल्या प्रत्येक पुरुषाची त्याच्या वाडवडिलांच्या घराण्याप्रमाणे नोंद केली. ");
INSERT INTO mar_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ती मोजदाद एकूण सहा लाख तीन हजार पाचशे पन्नास भरली. ");
INSERT INTO mar_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","इस्राएल लोकांबरोबर लेव्याची नोद त्यांच्या वडिलांच्या वंशावरून घेतली नव्हती. ");
INSERT INTO mar_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","परमेश्वराने मोशेला सांगितले होते की, ");
INSERT INTO mar_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","लेवी वंशाच्या दलातील लोकांची गणती करु नको किंवा इतर इस्राएल लोकांच्या गणतीत त्यांचा समावेश करु नको. ");
INSERT INTO mar_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","लेवी लोकांस सांग की साक्षपटाच्या निवासमंडपावर व त्याबरोबर त्यातील सर्व वस्तूंवर त्याचे जे आहे त्यावर त्यांना नेम. त्यांनी निवासमंडप व त्यातील सर्व वस्तू वाहून न्याव्यात. त्यांनी आपले तंबू निवासमंडपाभोवती उभारावेत आणि त्याची निगा राखावी. ");
INSERT INTO mar_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","जेव्हा निवासमंडप हलवावयाचा असेल तेव्हा तो लेवी लोकांनीच उतरावा व तो उभारताना लेवी लोकांनीच तो उभा करावा; त्याची निगा राखणे हे त्यांचेच काम आहे; कोणी परका जवळ आला तर त्यास जिवे मारावे. ");
INSERT INTO mar_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","इस्राएल लोकांपैकी प्रत्येकाने आपापले तंबू आपापल्या दलाप्रमाणे आपापल्या छावणीत आपापल्या कुळाच्या निशाणाजवळ द्यावेत. ");
INSERT INTO mar_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","परंतु लेवी लोकांनी आपले तंबू पवित्र निवासमंडपाच्या सभोवती ठोकावेत; त्यांनी आज्ञापट असलेल्या पवित्र निवासमंडपाचे रक्षण करावे म्हणजे इस्राएल लोकांच्या मंडळीवर संकट येणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे इस्राएल लोकांनी सर्वकाही केले. ");
INSERT INTO mar_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","परमेश्वर, मोशे व अहरोन यांच्याशी पुन्हा बोलला, तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","इस्राएलाच्या प्रत्येक वंशजाने आपल्या सैन्याच्या निशाणाजवळ जो त्याच्या सैन्याच्या दलाचा आहे आणि लहान झेंडा तो त्याच्या वंशाला दर्शवितो त्यापाशी तळ द्यावा. त्याच्या तळाचे तोंड दर्शनमंडपाच्या समोर असावे. ");
INSERT INTO mar_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","यहूदावंशाच्या छावणीचे निशाण उगवत्या सूर्याच्या दिशेला म्हणजे पूर्व दिशेला असावे. यहूदावंशातील सर्व लोकांनी आपली छावणी त्या निशाणाजवळ ठोकावी. अम्मीनादाबाचा मुलगा नहशोन हा यहूदावंशाचा प्रमुख सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","त्याच्या दलात चौऱ्याहत्तर हजार सहाशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","इस्साखार वंशाच्या लोकांनी यहूदावंशाच्या छावणी शेजारी आपली छावणी ठोकावी. सुवाराचा मुलगा नथनेल हा इस्साखारवंशाचा प्रमुख सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","त्याच्या दलात चौपन्न हजार चारशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","जबुलून वंशाच्या लोकांनीही यहूदावंशाच्या छावणीनंतर जवळच आपली छावणी उभारावी. हेलोनाचा मुलगा अलीयाब हा जबुलून वंशाचा प्रमुख सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","त्याच्या दलात सत्तावन्न हजार चारशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","यहूदावंशाच्या छावणीत एकूण एक लाख शहाऐंशी हजार चारशे लोक होते. ते त्यांच्या कुळाप्रमाणे विभागलेले होते. इस्राएल लोकांनी एका ठिकाणाहून दुसऱ्या ठिकाणाकडे प्रवास करिताना यहूदावंशाच्या दलाने सर्वात पुढे चालावे. ");
INSERT INTO mar_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","पवित्र निवासमंडपाच्या दक्षिण बाजूस रऊबेन वंशाच्या छावणीचे निशाण असावे. प्रत्येक गटाने आपापल्या निशाणाजवळ आपली छावणी उभारावी. शदेउराचा मुलगा अलीसूर हा रऊबेन वंशाचा प्रमुख सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","त्याच्या दलात शेहेचाळीस हजार पाचशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","शिमोन वंशातल्या कुळांनी रऊबेन वंशाच्या छावणी शेजारी आपली छावणी उभारावी. सुरीशाद्दैचा मुलगा शलूमीयेल हा शिमोन वंशाचा प्रमुख सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","त्याच्या दलात एकोणसाठ हजार तीनशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","गादवंशाच्या कुळांनीही रऊबेन वंशाच्या छावणीजवळ आपली छावणी उभारावी. रगुवेलाचा मुलगा एल्यासाप हा गाद वंशाचा प्रमुख सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","त्याच्या दलात पंचेचाळीस हजार सहाशे पन्नास लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","रऊबेनच्या छावणीत कुळांप्रमाणे एकंदर एक लाख एकावन्न हजार चारशे पन्नास लोक होते. इस्राएल लोकांचा मुक्काम हलविताना रऊबेनच्या दलातील लोकांनी दुसऱ्या क्रमांकावर चालावे. ");
INSERT INTO mar_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","त्यानंतर सर्व छावण्यांच्या मध्यभागी लेव्यांच्या छावणीसह दर्शनमंडप पुढे न्यावा. प्रवास करताना छावण्या ज्या क्रमाने निघतात त्याच क्रमाने मुक्काम करताना त्यांनी आपापल्या छावण्या द्याव्यात. प्रत्येक मनुष्याने आपल्या कुळाच्या निशाणाजवळ रहावे. ");
INSERT INTO mar_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","एफ्राइम वंशाच्या छावणीचे निशाण पश्चिम बाजूस असावे व त्याच्या कुळातल्या लोकांनी आपली छावणी तेथे उभारावी. अम्मीहूदाचा मुलगा अलीशामा एफ्राइम वंशाचा प्रमुख सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","त्याच्या दलात चाळीस हजार पाचशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","मनश्शे वंशाच्या दलाने एफ्राइम वंशाच्या छावणी शेजारी आपली छावणी ठोकावी. पदासुराचा मुलगा गमलीयेल हा मनश्शे वंशाचा प्रमुख सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","त्याच्या दलात बत्तीस हजार दोनशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","बन्यामीन वंशाच्या दलानेही एफ्राइमाच्या दलाशेजारी आपली छावणी ठोकावी. बन्यामीन वंशाचा प्रमुख सरदार गिदोनीचा मुलगा अबीदान हा असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","त्याच्या दलात पस्तीस हजार चारशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","एफ्राइम वंशाच्या छावणीत एकूण एक लाख आठ हजार शंभर लोक होते. इस्राएल लोकांचा मुक्काम हलविताना एफ्राइम वंशाचा तिसरा क्रमांक असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","दान वंशाच्या छावणीचे निशाण उत्तरेकडील बाजूस असावे. त्यांच्या कुळातल्या लोकांनी आपल्या दलाची छावणी तेथे उभारावी. अम्मीशाद्दैचा मुलगा अहीएजर हा दानवंशाचा सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","त्याच्या दलात बासष्ट हजार सातशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","आशेर वंशाच्या दलाने दान वंशाच्या छावणी शेजारी आपली छावणी उभारावी. आक्रानाचा मुलगा पगीयेल हा आशेर वंशाचा सरदार असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","त्याच्या दलात एकेचाळीस हजार पाचशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","नफताली वंशाचे लोक. एनानाचा मुलगा अहीरा हा नफताली वंशाचा पुढारी असावा. ");
INSERT INTO mar_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","त्याच्या दलात त्रेपन्न हजार चारशे लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","दान वंशाच्या छावणीत एक लाख सत्तावन्न हजार सहाशे लोक होते. इस्राएल लोकांचा तळ ठिकठिकाणाहून हलविताना दानवंशाच्या कुळांनी सर्वात शेवटी चालावे. ");
INSERT INTO mar_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","अशी इस्राएल लोकांची मंडळी होती. त्यांच्या वंशात त्यांच्या कुळाप्रमाणे व त्यांच्या वाडवडिलांच्या घराण्याप्रमाणे त्यांची गणती केली तेव्हा त्यांची एकूण संख्या सहा लाख तीन हजार पाचशे पन्नास होती. ");
INSERT INTO mar_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","मोशेने परमेश्वराच्या आज्ञेप्रमाणे इस्राएल लोकांबरोबर लेवी लोकांची गणती केली नाही. ");
INSERT INTO mar_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","तेव्हा परमेश्वराने मोशेला दिलेल्या आज्ञाप्रमाणे सर्वकाही इस्राएल लोकांनी केले. प्रत्येक कुळाने आपआपल्या निशाणापाशी तळ दिला. प्रत्येकजण आपापल्या कुळात व आपापल्या वाडवडिलांच्या घराण्यांच्या छावणीत राहिला. ");
INSERT INTO mar_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","जेव्हा परमेश्वर सीनाय पर्वतावर मोशेशी बोलला त्याकाळचा अहरोन व मोशे ह्याच्या वंशावळीचा इतिहास आता हा असाः ");
INSERT INTO mar_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","अहरोनाच्या मुलांची नावे हीः नादाब हा प्रथम जन्मलेला, व अबीहू, एलाजार व इथामार. ");
INSERT INTO mar_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","अहरोनाचे हे पुत्र जे अभिषेक केलेले याजक होते, ज्यांना त्याने याजकपदात सेवा करण्यासाठी समर्पित केले, त्यांची नावे ही आहेत ");
INSERT INTO mar_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","परंतु नादाब व अबीहू परमेश्वराची सेवा करिताना सीनाय रानात परमेश्वरापुढे अस्विकारनीय अग्नी अर्पिला तेव्हा ते परमेश्वरापुढे मरण पावले. त्यांना पुत्र नव्हते म्हणून एलाजार व इथामार हे आपला बाप अहरोन हयात असताना याजक होऊन परमेश्वराची सेवा करीत असत. ");
INSERT INTO mar_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","लेवीच्या वंशाला आण आणि त्यांना अहरोन याजकासमोर त्यास मदत करण्यास हजर कर. ");
INSERT INTO mar_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","अहरोन व सर्व मंडळी दर्शनमंडपामध्ये सेवा करीत असता लेवी लोक त्यांना मदत करतील. त्यांनी निवासमंडपात सेवा करावी. ");
INSERT INTO mar_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","त्यांनी दर्शनमंडपामधील सर्व वस्तूंची काळजी घ्यावी आणि इस्राएल वंशांना निवासमंडपाच्या सेवेत त्यांना सामान वाहण्यास मदत करावी. ");
INSERT INTO mar_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","अहरोन व त्याच्या मुलांना तू लेवींच्या हाती दे. इस्राएल लोकांची सेवा करण्यासाठी त्यांना पूर्णपणे मदतीसाठी देण्यात आले आहे. ");
INSERT INTO mar_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“अहरोन व त्याचे पुत्र यांची याजक म्हणून नेमणूक कर. त्यांनी याजक म्हणून आपले सेवेचे काम करावे. कोणी परका जवळ आल्यास त्यास जिवे मारावे.” ");
INSERT INTO mar_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","परमेश्वर मोशेशी बोलला तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","पाहा, मी इस्राएल लोकांतील प्रथम जन्मलेल्यांच्या ऐवजी मी आता माझी सेवा करण्यासाठी लेवी वंशातील लोकांस निवडून घेत आहे. लेवी माझेच असतील. ");
INSERT INTO mar_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","“सर्व प्रथम जन्मलेले माझेच आहेत. मी मिसर देशात सर्व प्रथम जन्मलेल्यांना मारून टाकले. त्याच दिवशी इस्राएल लोकांतील पुरुषांपैकी व पशूपैकी प्रथम जन्मलेले सर्व मी आपणासाठी पवित्र ठरवले. ते माझेच आहेत. मी परमेश्वर आहे.” ");
INSERT INTO mar_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","परमेश्वर सीनाय रानात पुन्हा मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“लेवी वंशातील जितके पुरुष व एक महिन्याचे किंवा त्याहून अधिक वयाची मुले असतील त्यांची, त्यांच्या कुळाप्रमाणे व त्यांच्या वाडवडिलांच्या घराण्याप्रमाणे गणती कर.” ");
INSERT INTO mar_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","मोशेने परमेश्वराच्या वचनाप्रमाणे त्यास झालेल्या परमेश्वराच्या आज्ञेनुसार त्यांची गणती केली. ");
INSERT INTO mar_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लेवींच्या मुलांची नावे गेर्षोन, कहाथ व मरारी होते. ");
INSERT INTO mar_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","गेर्षोनाच्या मुलांची नावे त्यांच्या कुळावरून ही आहेत. लिब्नी व शिमी. ");
INSERT INTO mar_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कहाथाचे पुत्र त्यांच्या कुळाप्रमाणे हे: अम्राम, इसहार, हेब्रोन व उज्जियेल. ");
INSERT INTO mar_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मरारीचे पुत्र त्यांच्या कुळाप्रमाणे हे: महली व मूशी. ही लेवी कुळातील घराणी होत. ");
INSERT INTO mar_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","गेर्षोनापासून लिब्नी व शिमी ही कुळे चालू झाली ही गेर्षोनी कुळे. ");
INSERT INTO mar_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","या दोन कुळात एक महिन्याचे व त्याहून अधिक वयाचे पुत्र व पुरुष मिळून सात हजार पाचशे होते. ");
INSERT INTO mar_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेर्षोन कुळांनी त्यांना सांगितल्याप्रमाणे पश्चिमेच्या बाजूस पवित्र निवासमंडपाच्या मागे आपले डेरे दिले. ");
INSERT INTO mar_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","लायेलाचा मुलगा एल्यासाप हा गेर्षोनी घराण्याचा सरदार होता. ");
INSERT INTO mar_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","दर्शनमंडपामधील निवासमंडप, तंबू आणि त्यावरील आच्छादन, दर्शनमंडपाच्या प्रवेशद्वाराचा पडदा यांची निगा राखण्याचे काम गेर्षोनी लोकांवर सोपविण्यात आले. ");
INSERT INTO mar_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","पवित्र निवासमंडप व वेदी ह्यांच्या सभोंवतीच्या अंगणाचे पडदे, अंगणाच्या दाराचा पडदा, त्यांच्यासाठी लागणारे तणावे व इतर सामान यांची निगा राखण्याची जबाबदारी त्यांनी घेतली. ");
INSERT INTO mar_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","कहाथापासून अम्राम, इसहार, हेब्रोन व उज्जियेल ही कुळे चालू झाली; ही कहाथी कुळे. ");
INSERT INTO mar_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","या कुळात एक महिन्याचे व त्याहून अधिक वयाचे पुत्र व पुरुष आठ हजार सहाशे होते. पवित्रस्थळातील वस्तूची निगा राखण्याचे काम कहाथी कुळांना देण्यात आले. ");
INSERT INTO mar_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कहाथी कुळांनी निवासमंडपाच्या दक्षिणेस आपली छावणी उभारली. ");
INSERT INTO mar_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","उज्जियेलाचा मुलगा अलीसापान हा कहाथी घराण्याचा पुढारी होता. ");
INSERT INTO mar_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","पवित्र कराराचा कोश, मेज, दीपस्तंभ, वेद्या, पवित्रस्थानाची सेवेसाठी असलेली पात्रे, पडदा व इतर सर्व वस्तूंची देखभाल करण्याची जबाबदारी त्यांनी घेतली. ");
INSERT INTO mar_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","अहरोनाचा मुलगा एलाजार याजक हा लेवी लोकांच्या पुढऱ्यांचा पुढारी होता. पवित्र वस्तूचे रक्षण करण्याचे काम ज्यांच्यावर सोपवले होते त्या सर्वांवर देखरेख करणारा तो प्रमुख होता. ");
INSERT INTO mar_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","मरारीपासून महली व मुशी ही घराणी चालू झाली ही मरारी कुळे. ");
INSERT INTO mar_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","या कुळात एक महिन्याचे व त्याहून अधिक वयाचे पुत्र व पुरुष सहा हजार दोनशे होते. ");
INSERT INTO mar_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","अबीहाईलाचा मुलगा सूरीएल हा मरारी घराण्याचा पुढारी होता. या कुळांना पवित्र निवासमंडपाच्या उत्तरेकडचा भाग दिला होता तेव्हा त्यांनी तेथे आपली छावणी ठोकली. ");
INSERT INTO mar_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","मरारी वंशातील लोकांस पवित्र निवासमंडपाच्या फळ्या व त्यांचे सर्व अडसर, खांब व उथळ्या आणि पवित्र निवासमंडपाच्या फळ्यांशी निगडीत अशा सर्व वस्तूंची निगा राखण्याचे काम देण्यात आले; ");
INSERT INTO mar_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","तसेच पवित्र निवासमंडपाच्या अंगणासभोंवतीचे सर्व खांब, त्यांच्या बैठका, उथळ्या, मेखा आणि तणाव्याचे दोर यांची ही देखभाल करण्याचे काम त्यांनी घेतले. ");
INSERT INTO mar_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","मोशे, अहरोन व त्याचे पुत्र यांची छावणी दर्शनमंडपाच्या समोर असलेल्या पवित्र निवासमंडपाच्या पूर्वेस होती. इस्राएल लोकांच्यावतीने पवित्र निवासस्थानाच्या रक्षणाचे काम त्यांना देण्यात आले. सर्व इस्राएलाकरिता त्यांनी हे काम केले. कोणी दुसरा पवित्र निवासस्थानाजवळ आल्यास त्यास जिवे मारावे असा त्यांना आदेश होता. ");
INSERT INTO mar_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","लेवी वंशातील एक महिन्याचे व त्याहून अधिक वयाचे पुत्र व पुरुष यांची गणती करण्यास परमेश्वराने मोशे व अहरोन ह्याना सांगितले, तेव्हा पुरुष लेवीची एकूण संख्या बावीस हजार भरली. ");
INSERT INTO mar_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","परमेश्वर मोशेला म्हणाला, “इस्राएल लोकांपैकी जितके प्रथम जन्मलेले, एक महिन्याचे व त्याहून अधिक वयाचे पुत्र व पुरुष असतील त्यांच्या नांवाची एक यादी तयार कर; ");
INSERT INTO mar_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","आता मी इस्राएलाचे प्रथम जन्मलेले पुत्र व पुरुष घेणार नाही, त्याऐवजी मी परमेश्वर, लेवी वंशाचे लोक घेईन, तसेच इस्राएल लोकांच्या प्रथम जन्मलेल्या पशूंच्या ऐवजी लेवी लोकांच्या पशूंचे प्रथम जन्मलेले घेईन.” ");
INSERT INTO mar_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","तेव्हा मोशेने परमेश्वराच्या आज्ञेप्रमाणे केले, त्याने इस्राएल लोकांच्या प्रथम जन्मलेल्या सर्वाची गणती केली. ");
INSERT INTO mar_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","मोशेने प्रथम जन्मलेले एक महिन्याचे व त्याहून अधिक वयाचे जे इस्राएल पुत्र व पुरुष होते त्यांच्या नांवाची यादी केली. त्या यादीत बावीस हजार दोनशे त्र्याहत्तर नांवे होती. ");
INSERT INTO mar_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","परमेश्वर मोशेशी पुन्हा बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","इस्राएल लोकांच्या प्रथम जन्मलेल्या ऐवजी तू लेवी लोक घे आणि इस्राएलांच्या पशू ऐवजी लेवी लोकांचे पशू घे, कारण लेवी माझेच आहेत. मी परमेश्वर आहे. ");
INSERT INTO mar_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","लेवी लोक बावीस हजार आहेत आणि इस्राएल लोकांच्या कुळात प्रथम जन्मलेले बावीस हजार दोनशे त्र्याहत्तर आहेत. म्हणजे इस्राएलातील प्रथम जन्मलेल्यांपैकी दोनशे त्र्याहत्तर पुत्र अधिक शिल्लक राहतात. ");
INSERT INTO mar_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","त्यांना सोडवून घेण्यासाठी प्रत्येकाकडून पवित्रस्थानाच्या शेकेलाप्रमाणे पाच पाच शेकेल घे. एक शेकेल म्हणजे वीस गेरा. ");
INSERT INTO mar_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","प्रथम जन्मलेल्यांच्या सोडवणुकीचे जे अधिक पैसे येतील तो पैसा अहरोन व त्याच्या मुलांना दे. ");
INSERT INTO mar_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","आणि लेव्यांकडून ज्यांची खंडणी झाली त्यांच्याहून जे अधिक होते त्यांच्यापासून त्यांच्या खंडणीचा पैसा मोशेने घेतला. ");
INSERT INTO mar_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","इस्राएलांच्या प्रथम जन्मलेल्याकडून त्याने जे पैसे घेतले अधिकृत पवित्रस्थानातील चलनाप्रमाणे मोशेने एकूण एक हजार तीनशे पासष्ट शेकेल भरले. ");
INSERT INTO mar_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","मोशेने खंडणीचे पैसे अहरोन व त्याच्या मुलांना दिले. जशी परमेश्वराने त्यास आज्ञा केली होती ती प्रत्येक गोष्ट परमेश्वराच्या वचनानुसार मोशेने केली. ");
INSERT INTO mar_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","परमेश्वर मोशे व अहरोन यांच्याशी बोलला, तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","लेवी लोकांपैकी कहाथी कुळांच्या पुरुषांची त्यांच्या वाडवडिलांच्या घराण्याप्रमाणे गणती कर. (हे लोक लेवीच्या कुळापैकीच होते) ");
INSERT INTO mar_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","तीस ते पन्नास वर्षांच्या पुरुषांची गणती कर. हे पुरुष दर्शनमंडपातली सेवा करण्यासाठी सैन्यात जातात त्यांची गणती कर. ");
INSERT INTO mar_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","कहाथ वंशजांनी दर्शनमंडपामधील परमपवित्र वस्तू ज्या माझ्यासाठी राखून ठेवल्या आहेत त्यांची त्यांनी काळजी घ्यावी. ");
INSERT INTO mar_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","जेव्हा छावणी आपला तळ पुढे हलविण्याची तयारी करील, तेव्हा अहरोन व त्याच्या मुलांनी तंबूत जाऊन परमपवित्र स्थानातील पडदा जो पवित्रस्थानापासून वेगळा करतो तो खाली काढावा व त्याने कराराचा कोश झाकावा. ");
INSERT INTO mar_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","मग त्यांनी कोशावर तहशाच्या कातड्याचे आच्छादन घालावे व त्यावर संपूर्ण निळ्या रंगाचे कापड पसरावे व त्यांनी तो वाहून नेण्यासाठी दांडे लावावे. ");
INSERT INTO mar_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","त्यांनी समक्षतेच्या भाकरीच्या मेजावर निळ्या रंगाचे कापड पसरावे व त्यावर तबके, धूपपात्रे, वाट्या व पेयार्पणे ओतण्याचे पेले ठेवावे; त्याचप्रमाणे नेहमीची भाकरही त्यावर ठेवावी. ");
INSERT INTO mar_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","त्या सर्वांवर किरमिजी रंगाचे कापड पसरावे व नंतर ते सर्व तहशाच्या कातड्याने झाकून टाकावे; तो वाहून नेण्यासाठी मेजाला दांडे बसवावे. ");
INSERT INTO mar_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","त्यांनी दीपस्तंभ आणि त्यावरील दिवे, तसेच दिवे सतत तेवत ठेवण्याकरिता लागणारी सर्व उपकरणे चिमटे, ताटल्या आणि दिव्यासाठी लागणाऱ्या तेलाची सर्व पात्रे ही सर्व निळ्या कापडाने झाकावी. ");
INSERT INTO mar_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","या सर्व वस्तू त्यांनी तहशाच्या कातड्याने लपेटून घ्याव्यात आणि हे सर्व वाहून न्यावयाच्या चौकटीवर त्यांनी ठेवावे. ");
INSERT INTO mar_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","त्यांनी सोन्याच्या वेदीवर निळे कापड पसरावे. ते तहशाच्या कातड्याने झाकावे व मग वेदीला वाहून नेण्याचे दांडे बसवावे. ");
INSERT INTO mar_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","मग पवित्रस्थानातील उपासनेसाठी लागणारी सर्व उपकरणे त्यांनी गोळा करावीत व ती निळ्या कापडात गुंडाळावीत; त्यावर तहशाच्या कातड्याचे आच्छादन टाकावे आणि मग हे सर्व त्यांनी वाहून नेणाऱ्या चौकटीवर ठेवावे. ");
INSERT INTO mar_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","मग त्यांनी वेदीवरील सर्व राख काढून ती स्वच्छ करावी व वेदीवर जांभळ्या रंगाचे कापड पसरावे. ");
INSERT INTO mar_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","नंतर त्यांनी वेदीच्या सेवेची सर्व उपकरणे म्हणजे अग्नीपात्रे, काटे, फावडी व कटोरे या वेदीच्या सर्व वस्तू गोळा करून त्या वेदीवर ठेवाव्यात; मग तिच्यावर तहशाच्या कातड्याचे आच्छादन घालावे व मग तिला वाहून नेण्याचे दांडे बसवावेत. ");
INSERT INTO mar_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","अहरोन व त्याचे पुत्र ह्यानी पवित्रस्थानातील सर्व पवित्र वस्तूवर आच्छादन टाकण्याचे पूर्ण करावे; मग कहाथी लोकांनी आत जावे आणि त्या वस्तू वाहून नेण्याचे काम सुरु करावे; अशा प्रकारे ते पवित्र वस्तूंना स्पर्श करणार नाहीत आणि मरणार नाहीत. दर्शनमंडपामधील जी ओझी कहाथवंशजांनी वाहावयाची ती हीच. ");
INSERT INTO mar_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","पवित्र निवासमंडप व त्यातील सर्व वस्तू व उपकरणे म्हणजे पवित्रस्थान व त्यातील दिव्यांना लागणारे तेल, सुगंधी धूप, रोजची अन्नार्पणे व अभिषेकाचे तेल या सर्वांची जबाबदारी अहरोन याजकाचा मुलगा एलाजार ह्याने घ्यावी. ");
INSERT INTO mar_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","परमेश्वर मोशे व अहरोनाशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","तुम्ही कहाथी वंशातल्या कुळाचा वंश लेव्यातून काढून टाकण्याची परवानगी देऊ नका; ");
INSERT INTO mar_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","जेव्हा ते परमपवित्रस्थानातील वस्तूजवळ जातील तेव्हा त्यांनी मरू नये पण जगावे म्हणून अहरोन व त्याचे पुत्र ह्यांनी आत जाऊन त्यांच्यातील एकएकाला त्यांचे काम व ओझे नेमून द्यावे. ");
INSERT INTO mar_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","पवित्र स्थानातील वस्तू पाहण्यास त्यांनी क्षणभरही आत जाऊ नये किंवा गेले तर ते मरतील. अहरोनाने व त्याच्या मुलांनी आत जाऊन कहाथीतल्या एकएकाला त्याचे काम व त्याचे विशेष काम नेमून द्यावे. ");
INSERT INTO mar_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","परमेश्वर मोशेशी पुन्हा बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","गेर्षोन वंशातील पुरुषांची गणना कर आणि त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याच्याप्रमाणे त्यांची यादी कर; ");
INSERT INTO mar_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","म्हणजे तीस ते पन्नास वर्षे वयाचे जे दर्शनमंडपातले काम करायला पात्र असतील अशा लोकांची गणती कर. ");
INSERT INTO mar_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","गेर्षोनी कुळांनी करावयाची सेवा व वाहावयाची ओझी ही अशीः ");
INSERT INTO mar_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","त्यांनी निवासमंडपाचे पडदे, दर्शनमंडप व त्याचे आच्छादन आणि त्यावर असलेले तहशाच्या कातड्याचे आच्छादन तसेच दर्शनमंडपाच्या प्रवेशद्वाराचा पडदा, ");
INSERT INTO mar_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","निवासमंडप व वेदी ह्यांच्या भोंवतीच्या अंगणाच्या कनातीचे पडदे, तसेच अंगणाच्या प्रवेश दाराचा पडदा, सर्व तणावे व त्यांच्याबरोबर लागणारी उपकरणे, या सर्व वस्तू गेर्षोनी कुळांनी वहाव्यात; आणि या सामानासंबंधी जे काही काम पडेल ते त्यांनी करावे. ");
INSERT INTO mar_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","गेर्षोनी लोकांनी त्यांना नेमून दिलेली कामे वाहने आणि जी सर्व सेवा, अहरोनाच्या व त्याच्या मुलांच्या आज्ञेवरून करावी. त्यांचा भार त्यांच्याकडे सोपवावा. ");
INSERT INTO mar_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","गेर्षोनी कुळातील लोकांची दर्शनमंडपातली ही सेवा आहे. अहरोन याजकाचा मुलगा इथामार ह्यांच्या हाताखाली त्यांनी कामाची जबाबदारी पार पाडावी. ");
INSERT INTO mar_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","मरारी वंशजांचीही, त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी या प्रमाणे गणती कर. ");
INSERT INTO mar_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","म्हणजे तीस ते पन्नास वर्षेच्या वयाच्या दर्शनमंडपामधील सेवा करण्यास पात्र असलेल्या पुरुषांची गणती कर. ");
INSERT INTO mar_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","दर्शनमंडपाच्या ज्या वस्तू वाहून नेण्याची जबाबदारी त्यांना करावी लागेल ती हीः निवासमंडपाच्या फळ्या, अडसर, खांब, उथळ्या, वाहून नेण्याचे काम त्यांनी करावे. ");
INSERT INTO mar_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","तसेच सभोंवतीच्या अंगणाचे खांब, उथळ्या, तंबूच्या मेखा, तणावे आणि अंगणाच्या खांबासाठी लागणारी इतर उपकरणे, इत्यादी सर्वसामान वाहून नेण्याचे व निगा राखण्याचे काम मरारी लोकांचे आहे. त्या मनुष्यांच्या नावांची यादी करा व प्रत्येकाने नक्की काय वाहून न्यायचे ते त्यास सांगा. ");
INSERT INTO mar_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","दर्शनमंडपाची कामे करिताना मरारी कुळातील पुरुषांनी ही सेवा करावी त्यांच्या कामासाठी अहरोन याजकाचा मुलगा इथामार हा जबाबदार राहील. ");
INSERT INTO mar_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","मोशे, अहरोन व इस्राएलाच्या मंडळीचे पुढारी ह्यानी कहाथी लोकांची, त्यांची कुळे व वाडवडिलांची घराणी ह्याप्रमाणे गणती केली. ");
INSERT INTO mar_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","त्यांनी, दर्शनमंडपाच्या सेवेसाठी पात्र असलेल्या तीस ते पन्नास वर्षे वयाच्या पुरुषांची गणती केली. ");
INSERT INTO mar_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ज्या पुरुषांची त्यांच्या वंशाप्रमाणे गणती झाली ते दोन हजार सातशे पन्नास लोक होते. ");
INSERT INTO mar_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","कहाथी वंशापैकी जे दर्शनमंडपामध्ये पवित्र सेवा करीत त्यांची गणती करण्यात आली. मोशे व अहरोन ह्यानी, परमेश्वराने मोशेला सांगितल्याप्रमाणे हे केले. ");
INSERT INTO mar_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","तसेच गेर्षोनी वंशजांचीही, त्यांची कुळे व वाडवडिलांची घराणी ह्याप्रमाणे गणती करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","म्हणजे दर्शनमंडपाच्या सेवेसाठी पात्र असलेले तीस ते पन्नास वर्षे वयाच्या सर्व पुरुषांची गणती करण्यात आली. ");
INSERT INTO mar_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ज्या पुरुषांची, त्यांचे वंश व वाडवडिलांची घराणी ह्यास अनुसरून गणती झाली ती दोन हजार सहाशे तीस होती. ");
INSERT INTO mar_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","गेर्षोनी कुळांपैकी नोंद घेतलेले जे सर्व दर्शनमंडपामध्ये सेवा करीत असत, ज्यांची नोंद मोशे व अहरोन ह्यानी, परमेश्वराच्या आज्ञेप्रमाणे केली. ");
INSERT INTO mar_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","त्याचप्रमाणे मरारी वंशजांचीही, त्यांची कुळे व त्यांच्या वाडवडिलांची घराणी ह्याप्रमाणे गणती करण्यात आली, ");
INSERT INTO mar_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","म्हणजे तीस ते पन्नास वर्षे वयाचे जे दर्शनमंडपातले काम करायला पात्र होते ते सर्व, ");
INSERT INTO mar_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ज्या पुरुषांची त्यांच्या कुळास अनुसरून गणती झाली ते तीन हजार दोनशे भरले. ");
INSERT INTO mar_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","मरारी वंशापैकी ज्या पुरुषांची गणती मोशे व अहरोन ह्यानी, परमेश्वराने मोशेला आज्ञा केल्याप्रमाणे केली, ते इतके भरले. ");
INSERT INTO mar_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","तेव्हा मोशे, अहरोन व इस्राएलाचे पुढारी ह्यानी सर्व लेवी लोकांची गणती, त्यांची कुळे व वाडवडिलांची घराणी ह्याप्रमाणे केली. ");
INSERT INTO mar_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","तीस ते पन्नास वर्षे वय असलेल्या व दर्शनमंडपामधील सेवा करण्यास व ओझे वाहण्यास पात्र असलेल्या पुरुषांची गणती करण्यात आली; ");
INSERT INTO mar_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","त्यांची एकूण संख्या आठ हजार पांचशे ऐंशी होती. ");
INSERT INTO mar_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","तेव्हा परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे प्रत्येक मनुष्याची गणती करण्यात आली; प्रत्येक मनुष्यास त्याने स्वत: करावयाचे काम नेमून देण्यात आले व त्याने काय वाहून न्यावयाचे ते सांगण्यात आले. हे सर्व परमेश्वराने आज्ञा दिल्याप्रमाणे करण्यात आले. ");
INSERT INTO mar_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“इस्राएल लोकांस अशी आज्ञा कर की, प्रत्येक महारोगी, व कोणाला कसल्याही प्रकारचा स्त्राव होत असेल व कोणी प्रेताला शिवल्यामुळे अशुद्ध झालेला असल्यास अशा लोकांस त्यांनी छावणीच्या बाहेर घालवून द्यावे; ");
INSERT INTO mar_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","मग तो पुरुष असो किंवा ती स्त्री असो त्यांना छावणीच्या बाहेर काढावे म्हणजे मग छावणी आजार व विटाळापासून शुद्ध स्वच्छ राहील; कारण मी छावणीत तुमच्याबरोबर राहत आहे.” ");
INSERT INTO mar_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","तेव्हा परमेश्वराने मोशेला आज्ञा दिल्याप्रमाणे इस्राएल लोकांनी परमेश्वराची आज्ञा मानून त्या लोकांस छावणीबाहेर काढून टाकले. ");
INSERT INTO mar_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","परमेश्वर पुन्हा मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","इस्राएल लोकांस हे सांग की एखादा पुरुष वा स्त्री दुसऱ्याचा अपराध करील तर खरे पाहता तो परमेश्वराविरूद्धच पाप करील व म्हणून तो दोषी ठरेल. ");
INSERT INTO mar_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","तेव्हा त्या मनुष्याने आपला अपराध कबूल करावा. मग ज्याचा त्याने अपराध केला आहे त्याची त्याने पूर्णपणे भरपाई करावी व त्या भरपाईत आणखी एक पंचमांशाची भर घालून ज्याचा त्याने अपराध केला आहे त्यास ती सर्व द्यावी. ");
INSERT INTO mar_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","पण ज्याच्यावर अपराध घडला आहे तो मेला आणि अपराधाबद्दलची भरपाई घेण्यास त्याचे जवळचे कोणी नातलग नसतील तर त्या अपराधी मनुष्याने ती भरपाई परमेश्वरास अर्पण करावी. त्याने ती पूर्ण भरपाई याजकाकडे द्यावी. याजकाने त्या अपराध्याच्या प्रायश्चितासाठी प्रायश्चिताचा मेंढा अर्पण करावा परंतु राहिलेली भरपाई याजकाने ठेवावी. ");
INSERT INTO mar_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“जर कोणी इस्राएली लोकांमधून परमेश्वरास समर्पित करण्याकरिता काही विशेष देणगी याजकाकडे देईल तर ती याजकाने ठेवून घ्यावी; ती त्याचीच होईल. ");
INSERT INTO mar_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","प्रत्येक मनुष्याने पवित्र केलेल्या वस्तू त्या याजकाच्याच होत. याजकाला कोणी काही दिले तर ते त्याचेच होईल.” ");
INSERT INTO mar_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","मग परमेश्वर पुन्हा मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","इस्राएल लोकांस असे सांग की एखाद्या मनुष्याच्या पत्नीने त्याचा विश्वासघात केला. ");
INSERT INTO mar_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","म्हणजे तिने दुसऱ्या मनुष्याशी कुकर्म केले व ही गोष्ट तिने आपल्या नवऱ्यापासून लपवून ठेवली तर कोणी साक्षीदार नसल्यामुळे हे कुकर्म तिच्या नवऱ्याला कधीच कळणार नाही; ती स्वत: तर आपल्या नवऱ्याला ही गोष्ट सांगणारच नाही; ");
INSERT INTO mar_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","आणि तिच्या पतीच्या मनात प्रेमशंका उदभवली आणि आपल्या स्त्रीच्या पातिव्रत्याबद्दल त्यास संशय येऊन ती जर खरोखर भ्रष्ट झालेली असली अथवा तिच्या पतीच्या मनात प्रेमशंका उदभवून आपल्या स्त्रीच्या पातिव्रत्याबद्दल त्यास संशय आला आणि ती वास्तविक भ्रष्ट झालेली नसली. ");
INSERT INTO mar_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","जर असे झाले, तर त्या मनुष्याने आपल्या पत्नीला याजकाकडे घेऊन जावे. तसेच त्याने अर्पण म्हणून एक दशमांश एफा जवाचे पीठ अर्पावे; त्याच्यावर त्याने तेल ओतू नये किंवा धूप ठेवू नये; कारण परप्रेमशंकेमुळे केलेले म्हणजे अनीतीचे स्मरण करून देणारे हे अन्नार्पण होय. ");
INSERT INTO mar_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","याजकाने त्या स्त्रीला परमेश्वरासमोर उभे करावे. ");
INSERT INTO mar_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","मग याजकाने मातीच्या पात्रात पवित्र पाणी घ्यावे व पवित्र निवासमंडपाच्या जमिनीवरील थोडीशी धूळ त्यामध्ये टाकावी. ");
INSERT INTO mar_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","याजकाने त्या स्त्रीला परमेश्वरासमोर उभे रहावयास सांगावे. मग त्याने तिच्या डोक्याचे केस सोडावे, आणि द्वेषामुळे अर्पण करण्यासाठी आणिलेले जवाचे पीठ तिच्या हातावर ठेवावे. त्याचवेळी याजकाने शाप आणणारे जे कडू पाणी आपल्या हातात घ्यावे; ");
INSERT INTO mar_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","मग त्या याजकाने त्या स्त्रीला खोटे न बोलण्याबद्दल सूचना द्यावी. तसेच तिने खरे सांगण्याचे वचन द्यावे. याजकाने तिला म्हणावे; तू लग्न झालेल्या तुझ्या नवऱ्याविरूद्ध पाप करून दुसऱ्या पुरुषाबरोबर कुकर्म केले नसेल तर मग या शाप देणाऱ्या कडू पाण्यापासून मुक्त हो. ");
INSERT INTO mar_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","परंतु तू जर तुझ्या नवऱ्या विरूद्ध पाप केले असेल, तू दुसऱ्या पुरुषाबरोबर संबंध केला असशील तर मग तू भ्रष्ट झाली आहेस. ");
INSERT INTO mar_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","मग याजकाने त्या स्त्रीला परमेश्वरापुढे शापाची शपथ घ्यावयास सांगावे; परमेश्वर तुझी मांडी सडवील व तुझे पोट फुगविल तेव्हा परमेश्वर तुला लोकांच्या शापाला व तिरस्काराला पात्र करो. ");
INSERT INTO mar_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","याजकाने म्हणावे, म्हणजे तुझे पोट फुगविण्यासाठी व मांडी सडविण्यासाठी हे शापजनक पाणी तुझ्या आतड्यात शिरेल. मग त्या स्त्रीने आमेन, आमेन असे म्हणावे. ");
INSERT INTO mar_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","मग याजकाने हे शापशब्द पुस्तकात लिहून ते कडू पाण्यात धुवावे. ");
INSERT INTO mar_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","मग ते शापित कडू पाणी त्या स्त्रीने प्यावे. हे पाणी तिच्या पोटात जाईल आणि तिच्या पोटात कडूपणा उत्पन्न करील. ");
INSERT INTO mar_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","नंतर याजकाने ते द्वेषाबद्दलचे अन्नार्पण त्या स्त्रीच्या हातातून घ्यावे व परमेश्वरासमोर उंच धरावे आणि मग ते वेदीजवळ घेऊन जावे. ");
INSERT INTO mar_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","मग त्यातील मूठभर अन्नार्पण घेऊन त्याचे स्मारक म्हणून ते वेदीवर जाळावे. त्यानंतर याजकाने त्या स्त्रीला हे पाणी पिण्यास सांगावे. ");
INSERT INTO mar_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","जर त्या स्त्रीने आपल्या नवऱ्याविरूद्ध अपराध केला असेल तर शापजनक पाणी पाजल्यावर ते तिच्या पोटात जाईल व कडूपणा उत्पन्न करील. तिचे पोट फुगेल, तिची मांडी सडेल तिच्या लोकात तिचे नाव शापित होईल. ");
INSERT INTO mar_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","परंतु त्या स्त्रीने आपल्या नवऱ्याविरूद्ध पाप केले नसेल व ती शुद्ध असेल तर ती स्त्री अपराधी नाही असे याजकाने तिला सांगावे. मग ती मुक्त होईल व गर्भधारणेस पात्र ठरेल. ");
INSERT INTO mar_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","तेव्हा द्वेषासंबंधी हा नियम आहे. एखाद्या स्त्रीने आपल्या नवऱ्याविरूद्ध जर पाप केले तर तू ही अशी कारवाई करावी. ");
INSERT INTO mar_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","किंवा एखाद्या पुरुषाने आपल्या पत्नीने आपल्या विरूद्ध पाप केले आहे असा संशय व द्वेष, धरला तर त्या मनुष्याने अशी कारवाई करावी; त्या मनुष्याने स्त्रीला परमेश्वरासमोर उभे करावे व सांगितलेल्या नियमाप्रमाणे तिच्याविरूद्ध कारवाई करावी. ");
INSERT INTO mar_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","मग पती अधर्म करण्यापासून मुक्त होईल परंतु जर स्त्रीने पाप केले असेल तर तिला त्रास भोगावा लागेल. ");
INSERT INTO mar_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","इस्राएल लोकांशी बोल. त्यांना सांग, जेव्हा कोणी पुरुष किंवा स्त्री आपणास परमेश्वरासाठी वेगळे होऊन नाजीराचा विशेष नवस करील, ");
INSERT INTO mar_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","त्याने मद्य किंवा मादक द्रव्यापासून दूर रहावे. त्याने मद्यापासून केलेला शिरका किंवा मादक पेय पिऊ नये. त्याने द्राक्षाचा कसलाही रस पिऊ नये किंवा ताजी द्राक्षे किंवा मनुकेही खाऊ नयेत. ");
INSERT INTO mar_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","तो माझ्यासाठी वेगळा झाला त्या सर्व दिवसात, त्याने द्राक्षापासून केलेली प्रत्येक गोष्ट, जी बियापासून ते सालपटापर्यंत समाविष्ट आहे काहीच खाऊ नये. ");
INSERT INTO mar_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","त्याने परमेश्वरासाठी वेगळे राहण्याचा कालावधी पूर्ण होईपर्यंत त्याच्या नवसाच्या दिवसापर्यंत त्याच्या डोक्यावर वस्तऱ्याचा उपयोग करू नये. तो देवासाठी वेगळा केला आहे. त्याने आपल्या डोक्याचे केस लांब वाढू द्यावेत. ");
INSERT INTO mar_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","त्याने आपल्या स्वतःला परमेश्वरासाठी वेगळे केलेल्या सर्व दिवसात, त्याने प्रेताजवळ जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","त्याच्या स्वत:चा बाप, आई, भाऊ किंवा बहीण जर कोणी मरण पावले तर त्यांच्याकरिता अशुद्ध होऊ नये. कारण तो देवासाठी वेगळा केलेला आहे, जसे प्रत्येकजण त्याच्या डोक्यावरील लांब केस पाहतील. ");
INSERT INTO mar_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","आपल्या वेगळे राहण्याच्या सर्व दिवसात तो परमेश्वरासाठी पवित्र, राखीव आहे. ");
INSERT INTO mar_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","जर कोणी अचानक त्याच्याजवळ मरण पावला आणि त्याने वेगळा केलेला मनुष्य अशुद्ध झाला, तर त्याने आपल्या शुद्धीकरण्याच्या दिवशी डोक्याचे मुंडण करावे, म्हणजे ते सातव्या दिवसानंतर करावे. तेव्हा त्याने आपले डोके मुंडावे. ");
INSERT INTO mar_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","आठव्या दिवशी त्याने दोन होले किंवा पारव्याची दोन पिल्ले दर्शनमंडपाच्या प्रवेशदारापाशी याजकाकडे आणावीत. ");
INSERT INTO mar_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","मग याजकाने एक पक्षी पापार्पण व दुसऱ्याचा होमार्पण करावा. हे त्याच्यासाठी प्रायश्चित आहे कारण प्रेताजवळ जाऊन त्याने पाप केले. त्याने त्याच दिवशी आपल्या स्वतःला पुन्हा पवित्र करावे. ");
INSERT INTO mar_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","त्याने परमेश्वरासाठी वेगळे होण्यासाठी स्वत:ला पुन्हा समर्पित करावे. त्याने एक वर्षाचा मेंढा दोषार्पणासाठी आणावा. त्याने आपल्याला अशुद्ध करून घेण्याच्या पूर्वीचे दिवस मोजू नयेत. कारण तो देवासाठी वेगळा झाला तेव्हा तो अशुद्ध झाला होता. ");
INSERT INTO mar_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","मग त्याच्या नाजीरपणाच्या नवसाचे दिवस पूर्ण झाल्यावर त्यास दर्शनमंडपाच्या प्रवेशदारापाशी आणावे. ");
INSERT INTO mar_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","त्याने आपले अर्पण परमेश्वरास भेट द्यावे. त्याने होमबलि म्हणून एक वर्षाचा व दोषहीन मेंढा अर्पावा. त्याने पापबलि म्हणून एक वर्षाची व दोषहीन मेंढी अर्पावी, त्याने शांत्यर्पणासाठी एक दोषहीन मेंढा आणावा. ");
INSERT INTO mar_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","त्याने तेलात मळलेल्या मैद्याच्या एक टोपलीभर बेखमीर भाकरीसुद्धा आणाव्या व तेल लावलेले बेखमीर पापड त्याबरोबर त्यांचे अन्नार्पणे व पेयार्पणे आणावीत. ");
INSERT INTO mar_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","याजकाने ती परमेश्वरापुढे सादर करावी. त्याने त्याचे पापार्पण व होमार्पण परमेश्वरास अर्पावेत; ");
INSERT INTO mar_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","त्याने बेखमीर भाकरीच्या टोपलीबरोबर, परमेश्वराकरता शांत्यर्पणाच्या यज्ञासाठी मेंढा सादर करावा. याजकाने अन्नार्पण व पेयार्पणही सादर करावी. ");
INSERT INTO mar_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","मग नाजीराने आपण देवासाठी वेगळे झालेल्याचे चिन्ह म्हणून दर्शनमंडपाच्या प्रवेशदारापाशी आपल्या डोक्याचे मुंडण करावे. त्याने त्याच्या डोक्यापासूनचे केस घ्यावे आणि शांत्यर्पणाच्या यज्ञाखाली अग्नी आहे त्याच्यावर ठेवावेत. ");
INSERT INTO mar_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","नाजीराने आपण वेगळेपणाचे असलेले चिन्ह म्हणजे त्याने डोक्याचे मुंडण केल्यावर याजकाने मेंढ्याचा शिजविलेला फरा, टोपलीतून एक बेखमीर भाकर व एक बेखमीर पापड घेऊन त्याच्या हातावर ठेवावी. ");
INSERT INTO mar_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","मग याजकाने ते अर्पणाप्रमाणे परमेश्वरासमोर उंच करून त्यास सादर करावे. जे मेंढ्याचे ऊर व मांडीसह एकत्रित परमेश्वरापुढे उंच केलेले हे याजकासाठी राखून ठेवलेले पवित्र अन्न आहे. त्यानंतर नाजीर मद्य पिऊ शकतो. ");
INSERT INTO mar_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“जो कोणी नाजीर आपल्या वेगळेपणाचा परमेश्वरास अर्पण करण्याचा नवस करतो त्याचा नियम हा आहे. जे काही तो देईल, त्याने आपण घेतलेल्या शपथेचे बंधन पाळावे, तो जो नवस करतो त्या त्याच्या नाजीरपणासाठी दर्शविलेल्या नियमाप्रमाणे केले पाहिजे.” ");
INSERT INTO mar_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","पुन्हा परमेश्वर मोशेशी बोलला, तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","अहरोन व त्याच्या मुलांशी बोल. म्हण, तू इस्राएल लोकांस ह्याप्रमाणे आशीर्वाद द्या. तुम्ही त्यांना म्हणावे. ");
INSERT INTO mar_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","परमेश्वर तुला आशीर्वाद देवो व तुझे संरक्षण करो. ");
INSERT INTO mar_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","परमेश्वर आपला मुखप्रकाश तुझ्यावर पाडो, तुझ्याकडे पाहो व तुजवर दया करो. ");
INSERT INTO mar_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","परमेश्वर आपल्या प्रसन्नमुखासह तुजकडे पाहो व तुला शांती देवो. ");
INSERT INTO mar_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","याप्रमाणे त्यांनी माझे नाव इस्राएल लोकांस द्यावे. मग मी त्यांना आशीर्वाद देईन. ");
INSERT INTO mar_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ज्या दिवशी मोशेने निवासमंडपाचे काम संपविले, त्याने तो अभिषेक करून व परमेश्वराच्या उपयोगासाठी त्यातील सर्व एकत्रित साहित्यासह पवित्र केला. त्याने वेदी व त्यातील सर्व पात्रे अभिषेक करून पवित्र केली. त्याने त्यास अभिषेक केला व त्यास पवित्र केले. ");
INSERT INTO mar_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","त्यादिवशी, जे इस्राएलांचे अधिपती, त्यांच्या पूर्वजांच्या घराण्यांचे प्रमुख होते त्यांनी अर्पणे अर्पिली; हीच माणसे जमातीचे नेतृत्व करणारे होते. याच लोकांनी शिरगणतीचे काम पाहिले होते. ");
INSERT INTO mar_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","त्यांनी परमेश्वरापुढे अर्पणे आणली. त्यांनी झाकलेल्या सहा गाड्या व बारा बैल आणले. त्यांनी प्रत्येक दोन अधिपतीसाठी एक गाडी व प्रत्येक अधिपतीसाठी एक बैल दिला. त्यांनी या वस्तू निवासमंडपासमोर सादर केल्या. ");
INSERT INTO mar_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","मग परमेश्वर मोशेशी बोलला. तो म्हणाला ");
INSERT INTO mar_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“त्यांच्यापासून अर्पणे स्विकार आणि दर्शनमंडपाच्या कामासाठी अर्पणांचा उपयोग कर. प्रत्येक लेवीला ज्याच्या त्याच्या कामाच्या आवश्यकतेनुसार अर्पण दे.” ");
INSERT INTO mar_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","मोशेने गाड्या व बैल घेतले आणि ते लेवींना दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","त्याने दोन गाड्या व चार बैल गेर्षोनी वंशाना दिले कारण त्यांच्या कामासाठी त्यांना त्यांची गरज होती. ");
INSERT INTO mar_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","त्याने चार गाड्या व आठ बैल मरारी वंशाना दिले, ते अहरोन याजकाचा मुलगा इथामार ह्याच्या देखरेखीखाली होते. त्याने हे अशासाठी केले की त्यांना त्याची गरज होती. ");
INSERT INTO mar_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","परंतु त्याने कहाथी वंशाना त्यातील काहीच दिले नाही, कारण निवासमंडपातील राखीव वस्तू आणि साहित्य याच्या संबंधीत त्यांचे काम असून, त्या वस्तू आपल्या स्वतःच्या खांद्यावर वाहून नेण्याचे होते. ");
INSERT INTO mar_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","मोशेने वेदीला अभिषेक केला त्या दिवशी अधिपतींनी वेदीला आपला माल समर्पित करण्यासाठी आणला. अधिपतींनी आपली अर्पणे वेदीसमोर अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","परमेश्वर मोशेला म्हणाला, “प्रत्येक अधिपतीनी आपल्या स्वतःच्या दिवशी, वेदीच्या समर्पणासाठी आपले अर्पण आणावे.” ");
INSERT INTO mar_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","पहिल्या दिवशी, यहूदा वंशाचा अधिपती अम्मीनादाबाचा मुलगा नहशोन ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी आणली. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","त्यानेही धूपाने भरलेले दहा शेकेल वजनाचे, एक सोन्याचे पात्र आणले. ");
INSERT INTO mar_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","त्याने एक गोऱ्हा, एक मेंढा आणि एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यासाठी दिली. हे अम्मीनादाबाचा मुलगा नहशोन याची भेट होती. ");
INSERT INTO mar_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","दुसऱ्या दिवशी, इस्साखार वंशाचा, अधिपती सूवाराचा मुलगा नथनेल, ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी अर्पिली. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","त्यानेही धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","त्याने एक गोऱ्हा, एक मेंढा, एक वर्षाचे एक नर कोकरु ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिली. हे सूवाराचा मुलगा नथनेल याची भेट होती. ");
INSERT INTO mar_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","तिसऱ्या दिवशी, जबुलून वंशाचा अधिपती हेलोनाचा मुलगा अलीयाब ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी दिली. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","त्यानेही धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","त्याने एक गोऱ्हा, एक मेंढा, एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिली. हे हेलोनाचा मुलगा अलीयाब ह्याचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","चौथ्या दिवशी, रऊबेन वंशाचा अधिपती शदेयुराचा मुलगा अलीसूर ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी होती. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","त्यानेही धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र अर्पिले. ");
INSERT INTO mar_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","त्याने एक गोऱ्हा, एक मेंढा आणि एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिली. हे शदेयुराचा मुलगा अलीसूर ह्याचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","पांचव्या दिवशी, शिमोन वंशाचा अधिपती सुरीशाद्दैचा मुलगा शलूमीयेल ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी होते. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","त्यानेही धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र अर्पिले. ");
INSERT INTO mar_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","त्याने एक गोऱ्हा, एक मेंढा, एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिली. हे सुरीशाद्दैचा मुलगा शलूमीयेल यांचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","सहाव्या दिवशी, गाद वंशाचा अधिपती दगुवेलाचा मुलगा एल्यासाप ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी होती. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या मैद्याच्या पिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","त्याने धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","त्याने एक गोऱ्हा, एक मेंढा, एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे ही अर्पिण्यास दिली, हे दगुवेलाचा मुलगा एल्यासाप ह्याचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","सातव्या दिवशी, एफ्राईम वंशाचा अधिपती अम्मीहूदाचा मुलगा अलीशामा ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी होती. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","त्याने धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","त्याने एक गोऱ्हा, एक मेंढा, एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिली. अम्मीहूदाचा मुलगा अलीशामा यांचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","आठव्या दिवशी, मनश्शे वंशाचा अधिपती पदाहसुराचा मुलगा गमलीयेल ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी होती. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","त्याने धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","त्याने एक गोऱ्हा, एक मेंढा, एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिली. हे पदाहसुराचा मुलगा गमलीयेल याचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","नवव्या दिवशी, बन्यामीन वंशाचा अधिपती गीदोनीचा मुलगा अबीदान ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी होती. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","त्याने धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","त्याने एक गोऱ्हा, एक मेंढा, एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिली. हे गिदोनीचा मुलगा अबीदान ह्याचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","दहाव्या दिवशी, दान वंशाचा अधिपती अम्मीशाद्दैचा मुलगा अहीएजर ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी होती. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","त्याने धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","त्याने एक गोऱ्हा, एक मेंढा, एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिले. हे अम्मीशाद्दै याचा मुलगा अहीएजर ह्याचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","अकराव्या दिवशी, आशेर वंशाचा अधिकारी आक्रानाचा मुलगा पगीयेल ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाची चांदीची एक वाटी होती. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","त्याने धूपाने भरलेले दहा शेकेल वजनाचे एक सोन्याचे पात्र दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","त्याने होमार्पणासाठी एक गोऱ्हा, एक मेंढा व एक वर्षाचे नर कोकरू दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिली. हे आक्रानाचा मुलगा पगीयेल याचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","बाराव्या दिवशी, नफताली वंशाचा अधिपती एनानाचा मुलगा अहीरा ह्याने आपली अर्पणे अर्पिली. ");
INSERT INTO mar_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","त्याचे अर्पण पवित्रस्थानाच्या चलनाप्रमाणे एकशेतीस शेकेल वजनाचे चांदीचे एक ताट व सत्तर शेकेल वजनाचा चांदीचा एक कटोरा होता. त्या दोन्ही वस्तू अन्नार्पणासाठी तेलात मळलेल्या सपिठाने भरलेल्या होत्या. ");
INSERT INTO mar_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","त्याने धूपाने भरलेले, दहा शेकेल वजनाचे एक सोन्याचे पात्र दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","त्याने एक गोऱ्हा, एक मेंढा, एक वर्षाचे एक नर कोकरू ही होमार्पणासाठी दिली. ");
INSERT INTO mar_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","त्याने पापार्पणासाठी एक बकरा दिला. ");
INSERT INTO mar_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","त्याने शांत्यर्पणासाठी दोन बैल, पाच मेंढे, पाच बकरे आणि एक वर्षाची पाच नर कोंकरे अर्पिण्यास दिली. हे एनानाचा मुलगा अहीरा याचे अर्पण होते. ");
INSERT INTO mar_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","मोशेने वेदीला अभिषेक केला त्या दिवशी इस्राएलांच्या अधिपतींनी या सर्व वस्तू समर्पित केल्या. त्यांनी चांदीची बारा ताटे, चांदीच्या बारा वाट्या आणि सोन्याची बारा पात्रे समर्पित केली. ");
INSERT INTO mar_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","प्रत्येक चांदीच्या ताटाचे वजन एकशेतीस शेकेल व प्रत्येक चांदीच्या वाट्यांचे वजन सत्तर शेकेल होते. पवित्रस्थानाच्या चलनाप्रमाणे चांदीची ताटे व चांदीच्या वाट्या मिळून त्यांचे एकूण वजन दोन हजार चारशे शेकेल होते. ");
INSERT INTO mar_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","धूपाने भरलेले सोन्याची बारा पात्रे, प्रत्येकी पवित्रस्थानाच्या शेकेलाप्रमाणे दहा शेकेल वजन होते. ");
INSERT INTO mar_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","त्यांनी होमार्पणासाठी बारा गोऱ्हे, बारा मेंढे व एक वर्षाची बारा नर कोंकरे समर्पित केली. त्यांनी आपले अन्नार्पण दिले. त्यांनी पापार्पणासाठी बारा बकरे दिले. ");
INSERT INTO mar_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","शांत्यर्पणाच्या अर्पणासाठी त्यांनी आपल्या सर्व गुराढोरातून चोवीस बैल, साठ मेंढे, साठ बकरे व एक वर्षाची साठ नर कोंकरे दिली. जेव्हा अभिषेक झाला होता, तेव्हा त्यांनी ही वेदीला अर्पणे केली. ");
INSERT INTO mar_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","जेव्हा मोशे परमेश्वराबरोबर बोलण्यासाठी दर्शनमंडपामध्ये गेला, त्यावेळी त्याने देवाची वाणी त्याच्याशी बोलताना ऐकली. देव साक्षीकोशावर जे दयासन होते त्यावरून म्हणजे दोन करुबांच्या मधून आपणाशी बोलणारी वाणी ऐकली. परमेश्वर त्याच्याशी बोलला. ");
INSERT INTO mar_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“अहरोनाशी बोल. त्यास सांग, जेव्हा तू दिवे लावतोस तेव्हा त्या सात दिव्यांचा प्रकाश दीपस्तंभाच्यासमोर पडावा.” ");
INSERT INTO mar_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","अहरोनाने तसे केले. परमेश्वराने मोशेला दिलेल्या आज्ञेप्रमाणे त्याने दीपस्तंभावरील दिव्यांचा उजेड समोर पडावा म्हणून दिवे लावले. ");
INSERT INTO mar_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","दीपस्तंभ याप्रमाणे बनवलेला होताः परमेश्वराने मोशेला दीपस्तंभाच्या तळापासून त्याच्या कळ्यापर्यंत दाखविल्याप्रमाणे त्याने तो घडीव सोन्याचा घडविला. ");
INSERT INTO mar_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","पुन्हा, परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","लेवींना इस्राएल लोकांमधून घे व त्यांना शुद्ध कर. ");
INSERT INTO mar_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","त्यांना शुद्ध करण्यासाठी हे करः पापक्षालनाचे पाणी घेऊन त्यांच्यावर शिंपड. त्या प्रत्येकाने आपल्या पूर्ण शरीरावर वस्तरा फिरवावा आणि आपले कपडे धुवावे आणि त्यामुळे स्वतःला शुद्ध करावे. ");
INSERT INTO mar_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","मग त्यांनी एक गोऱ्हा घ्यावा आणि तेलात मळलेल्या सपिठाचे अन्नार्पण घ्यावे. त्यांनी पापार्पणासाठी दुसरा एक गोऱ्हा घ्यावा. ");
INSERT INTO mar_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","लेवींना दर्शनमंडपासमोर सादर कर व इस्राएल लोकांच्या सर्व मंडळीला एकत्र जमव. ");
INSERT INTO mar_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","लेवींना परमेश्वरासमोर सादर कर. तेव्हा इस्राएल लोकांनी लेवींच्या डोक्यावर आपले हात ठेवावे. ");
INSERT INTO mar_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","अहरोनाने लेव्यांना इस्राएल लोकांच्यावतीने माझी सेवा करण्यास सादर करावे. लेव्यांनी माझी सेवा करावी यासाठी त्याने हे करावे. ");
INSERT INTO mar_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","लेवींनी आपले हात बैलाच्या डोक्यावर ठेवावे. लेव्यांच्या प्रायश्चितासाठी एक बैल पापार्पण व दुसरा बैल माझ्या होमार्पणासाठी अर्पावा. ");
INSERT INTO mar_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","लेवींना अहरोन व त्याचे पुत्र ह्यांच्या समोर सादर कर आणि माझ्यासाठी त्यांना अर्पणाप्रमाणे उंच करावे. ");
INSERT INTO mar_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","याप्रकारे तुम्ही लेव्यांपासून इस्राएल लोकांना वेगळे करा. लेवी माझेच होतील. ");
INSERT INTO mar_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","तू त्यांना शुद्ध कर. तू त्यांना अर्पणाप्रमाणे माझ्यापर्यंत त्यांना उंच कर. यानंतर त्यांनी दर्शनमंडपामध्ये जाऊन सेवा करावी. ");
INSERT INTO mar_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","हे करा, कारण इस्राएल लोकांमधून ते पूर्णपणे माझे आहेत. इस्राएल वंशातील गर्भाशयातून निघणारे प्रत्येक प्रथम पुरुष मूलाची ते जागा घेतील. मी लेवींना आपल्या स्वतःसाठी घेतले आहे. ");
INSERT INTO mar_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इस्राएल लोकांतले, मनुष्यापैकी आणि पशूपैकी या दोन्हीमधील सर्व प्रथम जन्मलेले माझे आहेत. मिसर देशातील सर्व प्रथम जन्मलेली मुले व पशू मी मारले त्यादिवशी मी त्यांना आपल्याकरता पवित्र केले. ");
INSERT INTO mar_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","मी इस्राएल लोकातील सर्व प्रथम जन्मलेल्यांच्या ऐवजी लेवींना घेतले आहे. ");
INSERT INTO mar_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","अहरोन व त्याच्या मुलांना मी लेवींना दान म्हणून दिले आहेत. दर्शनमंडपामध्ये सर्व इस्राएल लोकांचे काम करण्यासाठी मी त्यांना घेतले आहे. जेव्हा लोक पवित्रस्थानाजवळ येतील तर त्यांनी मरीने नाश होऊ नये म्हणून इस्राएल लोकांसाठी प्रायाश्चिताची अर्पणे करावी. ");
INSERT INTO mar_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","तेव्हा मोशे, अहरोन आणि सर्व इस्राएल लोकांची मंडळी ह्यांनी ह्याप्रकारे लेव्यांना केले. परमेश्वराने लेव्यांविषयी मोशेला आज्ञा केल्याप्रमाणे त्यांनी त्यांचे सर्व काही केले. इस्राएलाच्या लोकांनी त्याच्याबरोबर हे केले. ");
INSERT INTO mar_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लेव्यांनी आपले कपडे धुऊन स्वतःला पापापासून शुद्ध केले. तेव्हा अहरोनाने त्यांना अर्पणाप्रमाणे परमेश्वरास सादर केले आणि त्यांना शुद्ध करण्यासाठी त्याने प्रायश्चित्त केले. ");
INSERT INTO mar_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","त्यानंतर, लेवी दर्शनमंडपामध्ये अहरोनापुढे व त्याच्या मुलांपुढे आपली नेमलेली सेवा करण्यास आत गेले. परमेश्वराने मोशेला लेव्याबद्दल आज्ञा केल्याप्रमाणे केले. त्यांनी सर्व लेव्यांना ह्याप्रकारे वागवले. ");
INSERT INTO mar_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","पुन्हा, परमेश्वर मोशेशी बोलला, तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","जे लेवी पंचवीस वर्षे किंवा त्यापेक्षा अधिक वयाचे आहेत त्या सर्वासाठी हे आहे. त्यांनी दर्शनमंडपामध्ये सेवा करण्यास मंडळात भाग घ्यावा. ");
INSERT INTO mar_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","त्यांनी वयाच्या पन्नासव्या वर्षांपासून सेवेत याप्रकारे थांबावे. नंतर त्यांनी थांबावे. ");
INSERT INTO mar_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","त्यांनी दर्शनमंडपामध्ये सेवा करणाऱ्या आपल्या बंधूंना त्यांच्या कामात मदत करावी, परंतु त्यांनी अधिक सेवा करु नये. तू लेव्यांना या सर्व गोष्टीत मार्गदर्शन करावे. ");
INSERT INTO mar_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","मिसर देशामधून इस्राएल लोक बाहेर आल्यानंतर दुसऱ्या वर्षाच्या पहिल्या महिन्यात परमेश्वर सीनायच्या रानात मोशेबरोबर बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“इस्राएल लोकांस वर्षातील ठरलेल्या वेळी वल्हांडण सण पाळण्यास सांग. ");
INSERT INTO mar_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","या महिन्यात चौदाव्या दिवशी संध्याकाळी त्याच्या नेमलेल्या वेळी तुम्ही तो पाळावा. भोजन करावे. त्याच्या सर्व नियमाप्रमाणे आणि त्याच्या विधीप्रमाणे तो पाळावा.” ");
INSERT INTO mar_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","मग मोशेने इस्राएल लोकांस वल्हांडण सण पाळावयास सांगितले. ");
INSERT INTO mar_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","तेव्हा परमेश्वराने मोशेद्वारे दिलेल्या आज्ञेप्रमाणे इस्राएल लोकांनी सीनायच्या रानात पहिल्या महिन्याच्या चौदाव्या दिवशी संध्याकाळी वल्हांडण सण पाळला; परमेश्वराने मोशेला दिलेल्या आज्ञेप्रमाणे इस्राएल लोकांनी सर्वकाही केले. ");
INSERT INTO mar_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","त्यादिवशी प्रेताला शिवल्यामुळे काही लोक अशुद्ध झाले. त्यामुळे त्यांना वल्हांडण सण पाळता येईना. ते त्याच दिवशी मोशे व अहरोन ह्यांच्यापुढे गेले. ");
INSERT INTO mar_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ती माणसे मोशेस म्हणाली, “एका मृत मनुष्यामुळे आम्ही अशुद्ध झालो. इस्राएलाच्या लोकांमध्ये परमेश्वराचे अर्पण वर्षाच्या नेमलेल्या वेळी करण्यापासून आम्हास दूर कां ठेवत आहेस?” ");
INSERT INTO mar_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मोशे त्यांना म्हणाला, “जरा थांबा, तुम्हाविषयी परमेश्वर काय सूचना देतो, हे मी ऐकतो.” ");
INSERT INTO mar_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","मग परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","तू इस्राएल लोकांशी बोल. म्हण, जर तुमच्यापैकी कोणी किंवा तुम्ही प्रेतामुळे अशुद्ध झाला किंवा लांबच्या प्रवासावर असला, तरी त्याने परमेश्वरासाठी वल्हांडण सण पाळावा. ");
INSERT INTO mar_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","त्यांनी वल्हांडण सण दुसऱ्या महिन्याच्या चौदाव्या दिवशी संध्याकाळी साजरा करावा. त्यांनी तो बेखमीर भाकर व कडू भाजीबरोबर खावा. ");
INSERT INTO mar_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","त्यांनी सकाळपर्यंत काहीही शिल्लक ठेवू नये किंवा त्यांनी पशूचे हाड मोडू नये. त्यांनी वल्हांडण सणासाठीचे सर्व नियम पाळावेत. ");
INSERT INTO mar_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","परंतु जर कोणी शुद्ध आहे आणि दूरच्या प्रवासात नाही, पण जो वल्हांडण सण पाळत नाही तर त्यास आपल्या लोकातून काढून टाकावे कारण त्याने परमेश्वराचे अर्पण त्याच्या नेमलेल्या वेळी केले नाही. त्या मनुष्याने आपले पाप वहावे. ");
INSERT INTO mar_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","जर तुमच्यामध्ये एखाद्या परराष्ट्रीय मनुष्य राहतो आणि परमेश्वराच्या सन्मानार्थ वल्हांडण सण पाळतो, तो त्याने पाळावा आणि त्याने दिलेल्या आज्ञा व वल्हांडणाचे सर्व नियम व विधीप्रमाणे पाळून साजरा करावा. परक्यांना आणि तुम्ही देशात जन्मलेल्या सर्वांना सणाचे नियम सारखेच आहेत. ");
INSERT INTO mar_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ज्या दिवशी निवासमंडप उभा करण्यात आला, निवासमंडपाला, कराराच्या कोशाच्या तंबूला ढगाने झाकले. संध्याकाळी ढग निवासमंडपावर होता. तो सकाळपर्यंत अग्नीसारखा दिसला. ");
INSERT INTO mar_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","अश्याप्रकारे ते सतत होत. ढग निवासमंडपाला झाकी आणि रात्री तो अग्नीसारखा दिसे. ");
INSERT INTO mar_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","जेव्हा ढग तंबूवरून वर घेतला गेला, म्हणजे तेव्हा इस्राएल लोकही त्यांच्या प्रवासास निघत असत. जेव्हा ढग थांबत असे, तेव्हा लोक आपला तळ देत असत. ");
INSERT INTO mar_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","परमेश्वराच्या आज्ञेवरून, इस्राएल लोक प्रवास करीत आणि त्याच्या आज्ञेप्रमाणे तळ देत. जोपर्यंत ढग निवासमंडपावर थांबत असे, तोपर्यंत ते आपल्या तळात राहत. ");
INSERT INTO mar_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","जेव्हा कधी ढग निवासमंडपावर बरेच दिवस राहत असे, मग इस्राएल लोक परमेश्वराचा नियम पाळून आणि प्रवास करीत नव्हते. ");
INSERT INTO mar_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","काहीवेळेला ढग थोडेच दिवस निवासमंडपावर राहत असे. याबाबतीत, ते परमेश्वराची आज्ञा पाळत ते तेथे तळ देत असत आणि मग ते त्याच्या आज्ञेने पुन्हा प्रवासास निघत. ");
INSERT INTO mar_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","काहीवेळेला ढग संध्याकाळपासून सकाळपर्यंत हजर राहत असे. जेव्हा सकाळी ढग वरती घेतला गेला म्हणजे ते प्रवास करत. जर दिवसा आणि रात्री ढग वर गेले की, ते एकसारखा प्रवास करीत असत. ");
INSERT INTO mar_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","जर ढग निवासमंडपावर दोन दिवस, महिनाभर किंवा वर्षभर राहिला तरी इस्राएल लोक तळ देऊन राहत असत आणि प्रवास करीत नव्हते. पण मग ढग वर गेला म्हणजे ते प्रवासास निघत. ");
INSERT INTO mar_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","परमेश्वराच्या आज्ञेप्रमाणे ते तळ देत आणि त्याच्या आज्ञेप्रमाणे ते प्रवास करीत; परमेश्वराने मोशेच्याद्वारे दिलेल्या आज्ञा ते पाळीत. ");
INSERT INTO mar_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","चांदीचे दोन कर्णे बनव. चांदी ठोकून ते बनव. मंडळीला एकत्र बोलवण्यासाठी आणि त्यांचा तळ हलविण्यासाठी या कर्ण्यांचा उपयोग करावा. ");
INSERT INTO mar_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","सर्व मंडळीला दर्शनमंडपाच्या प्रवेशद्वारासमोर एकत्र बोलविण्यासाठी याजकाने कर्णे वाजवावे. ");
INSERT INTO mar_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","जर याजकाने एकच कर्णा वाजविला तर मग अधिकाऱ्यांनी, इस्राएलांच्या वंशाच्या अधिपतीनी तुझ्याकडे जमावे. ");
INSERT INTO mar_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","जेव्हा तू कर्णा मोठ्याने फुंकून इशारा दिला म्हणजे पूर्वेकडील छावण्यांनी त्यांचा प्रवासास सुरवात करावी. ");
INSERT INTO mar_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","जेव्हा दुसऱ्या वेळी मोठ्याने फुंकून इशारा दिला म्हणजे तेव्हा दक्षिणेकडील छावण्यांनी प्रवासास सुरवात करावी; त्यांच्या प्रवासासाठी मोठ्याने फुंकून इशारा द्यावा. ");
INSERT INTO mar_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","जेव्हा मंडळीला एकत्र जमावावयाचे असेल तेव्हा कर्णा फुंका, पण मोठ्याने फुंकू नये. ");
INSERT INTO mar_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","अहरोनाचे मुले, याजक, यांनीच कर्णे वाजवावीत. हा तुमच्या लोकांस पिढ्यानपिढ्याचा कायमचा नियम आहे. ");
INSERT INTO mar_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","तुम्ही जेव्हा तुमच्या देशात तुम्हावर जुलूम करणाऱ्या शत्रूविरूद्ध लढायला जाता, मग तेव्हा तुम्ही कर्ण्याचा गजर करा. मी, परमेश्वर, तुमचा देव तुमची आठवण करीन आणि तुमच्या शत्रूपासून तुमचे रक्षण करील. ");
INSERT INTO mar_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","तसेच तुम्ही आनंदाच्या प्रसंगी, तुमचे दोन्ही नियमीत सण व महिन्याच्या सुरवातीच्या दिवशी तुमची होमार्पणाच्या, शांत्यर्पणाच्या यज्ञांच्या सन्मानासाठी तुम्ही कर्णे वाजवावेत. तुमच्या परमेश्वरास तुमची आठवण करून देण्याची ही एक कृती आहे. हे तुम्ही करावे अशी मी तुम्हास आज्ञा देतो. मी तुमचा देव परमेश्वर आहे. ");
INSERT INTO mar_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","दुसऱ्या वर्षी, दुसऱ्या महिन्यात, महिन्याच्या विसाव्या दिवशी, साक्षपटाच्या निवासमंडपापासून ढग वर घेतला गेला. ");
INSERT INTO mar_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","तेव्हा इस्राएल लोक सीनाय रानातून आपल्या प्रवासास निघाले. ढग पारानाच्या रानात थांबला. ");
INSERT INTO mar_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","परमेश्वराने मोशेच्याद्वारे दिलेल्या आज्ञेप्रमाणे त्यांनी हा पहिला प्रवास केला. ");
INSERT INTO mar_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","पहिल्याने यहूदा वंशाच्या छावणीच्या निशाणाखालील त्यांच्या वैयक्तिक सैन्यासह बाहेर निघाले. अम्मीनादाबाचा मुलगा नहशोन यहूदाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","सुवाराचा मुलगा नथनेल इस्साखार वंशाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","हेलोनाचा मुलगा अलीयाब जबुलून वंशाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","गेर्षोन व मरारी वंश निवासमंडपाची काळजी घेण्यासाठी होते, त्यांनी निवासमंडप खाली काढला आणि मग तो उचलून घेऊन त्यांच्या प्रवासास सुरवात केली. ");
INSERT INTO mar_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","त्यानंतर, रऊबेनाच्या निशाणाखालील छावणीतील सैन्यांनी त्यांच्या प्रवासास सुरवात केली. शदेयुराचा मुलगा अलीसूर त्यांच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","सुरीशाद्दैचा मुलगा शलूमीयेल शिमोन वंशाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","रगुवेलाचा मुलगा एल्यासाप गाद वंशाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","कहाथींनी प्रवासास सुरवात केली. ते पवित्रस्थानातील पवित्र वस्तू घेऊन निघाले. ते पुढच्या तळावर जाऊन पोहोचेपर्यंत अगोदरच्या इतरांनी पवित्र निवासमंडप उभा करून तयार ठेवला होता. ");
INSERT INTO mar_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","त्यानंतर एफ्राइम वंशाच्या निशाणाखालील छावणीतील सैन्यांनी प्रवासास सुरवात केली. अम्मीहूदाचा मुलगा अलीशामा त्यांच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","पदाहसुराचा मुलगा गमलीयेल मनश्शे वंशाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","गिदोनीचा मुलगा अबीदान बन्यामीन वंशाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","दान वंशाच्या निशाणाखालील सैन्यांची शेवटची छावणी होती. अम्मीशाद्दै चा मुलगा अहीएजर दान वंशाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","आक्रानाचा मुलगा पगीयेल आशेर वंशाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","एनानाचा मुलगा अहीरा नफताली वंशाच्या सैन्याच्या अग्रस्थानी होता. ");
INSERT INTO mar_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ह्याप्रकारे इस्राएल लोकांचे सैन्य त्यांच्या प्रवासास सुरवात करीत. ");
INSERT INTO mar_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","मोशेने आपला सासरा मिद्यानी रगुवेल ह्याचा मुलगा होबाब ह्याच्याशी बोलला. रगुवेल मोशेच्या पत्नीचा पिता होता. मोशे होबेबाशी बोलला व म्हणाला, “परमेश्वराने वर्णन केलेल्या देशात आम्ही जात आहोत. तो देश देण्याचे परमेश्वराने आम्हास वचन दिले आहे. तू आमच्याबरोबर ये आणि आम्ही तुझे चांगले करू. परमेश्वराने इस्राएल लोकांसाठी चांगले करण्याचे वचन दिले आहे.” ");
INSERT INTO mar_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","परंतु होबाबाने उत्तर दिले “मी तुमच्याबरोबर येणार नाही. मी माझ्या देशात व माझ्या स्वतःच्या लोकात जाईल.” ");
INSERT INTO mar_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","मग मोशेने त्यास उत्तर दिले, “कृपा करून तू आम्हास सोडून जाऊ नको. तुला रानात कसा तळ द्यायचा हे माहित आहे. तू आमचा वाटाड्या हो. ");
INSERT INTO mar_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","तू जर आमच्याबरोबर येशील तर परमेश्वर जे काही आमचे चांगले करील तेच आम्ही तुझे करू.” ");
INSERT INTO mar_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","परमेश्वराच्या पर्वतापासून तीन दिवसाचा प्रवास करीत गेले. परमेश्वराच्या कराराचा कोश त्यांच्या विसाव्यासाठी जागा शोधायला तीन दिवसाच्या वाटेवर त्यांच्यापुढे गेला. ");
INSERT INTO mar_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","जसा ते प्रवास करत होते तसा परमेश्वराचा ढग दिवसरात्र त्यांच्यावर होता. ");
INSERT INTO mar_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","जेव्हा कराराचा कोश प्रवासास निघत तेव्हा मोशे म्हणत असे, “हे परमेश्वरा, ऊठ, तुझ्या शत्रूंची पांगापांग कर, जे तुझा द्वेष करतात ते तुझ्यापासून पळून जावोत.” ");
INSERT INTO mar_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","जेव्हा कराराचा कोश थांबत असे, तेव्हा मोशे म्हणत असे, “हे परमेश्वरा, इस्राएलाच्या लाखो लोकांकडे परत ये.” ");
INSERT INTO mar_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","इस्राएल लोक आपल्या त्रासाबद्दल कुरकुर करू लागले तसे परमेश्वराने ऐकले. परमेश्वराने लोकांचे ऐकले आणि तो रागावला. परमेश्वरापासूनचा अग्नी त्यांच्यात पेटला आणि त्याने छावणीच्या हद्दीवरचे काही भाग भस्म केले. ");
INSERT INTO mar_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","तेव्हा लोकांनी मोशेकडे मदतीसाठी ओरड केली. मोशेने परमेश्वरास विनंती केली तेव्हा अग्नी विझला. ");
INSERT INTO mar_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","त्यामुळे त्या ठिकाणाचे नांव तबेरा असे पडले. लोकांनी त्या ठिकाणाला तसे नांव दिले कारण परमेश्वराच्या अग्नीमुळे छावणीचा भाग जळून गेला. ");
INSERT INTO mar_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","जे परराष्ट्रीय इस्राएल लोकाबरोबर राहत होते, त्यांना चांगले अन्न खावेसे वाटू लागले. इस्राएल लोकांनी तक्रार व रडण्यास करण्यास सुरवात केली. “आम्हांला मांस खावयास कोण देईल? ");
INSERT INTO mar_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","मिसरमध्ये आम्हास मासे फुकट खाण्यास मिळत होते. त्याचप्रमाणे तेथे आम्हास काकड्या, खरबूजे, फळभाजी, कांदे, लसूण मिळत असे त्याची आठवण आम्हास येते. ");
INSERT INTO mar_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","आता आम्ही कमजोर झालो आहोत. मान्न्याशिवाय आम्ही येथे काहीच पाहत नाही!” ");
INSERT INTO mar_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","हा मान्ना धण्याच्या बीसारखा होता, त्याचा रंग मोत्यासारखा होता. ");
INSERT INTO mar_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","लोक तो चोहोकडे फिरून गोळा करीत. तो जात्यात दळीत किंवा उखळात कुटीत, भांड्यात शिजवीत व त्याच्या भाकरी करीत. त्याची चव ताज्या जैतून तेलात तळलेल्या पुरीसारखी लागत असे. ");
INSERT INTO mar_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","जेव्हा रात्री छावणीवर दहिवर पडले म्हणजे मान्नासुध्दा पडत असे. ");
INSERT INTO mar_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","सर्व लोक त्यांच्या कुटुंबात रडत असल्याचा आवाज मोशेने ऐकला. आणि प्रत्येक मनुष्य आपापल्या तंबूच्या दाराशी बसून रडत होते. परमेश्वराचा राग भयंकर भडकला आणि मोशेच्या दृष्टीने त्यांची तक्रार चूक होती. ");
INSERT INTO mar_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","मोशे परमेश्वरास म्हणाला, तू आपल्या दासास इतके वाइट का वागवतोस? तू माझ्यावर प्रसन्न नाहीस का? या सर्व लोकांचा भार तू मला वाहण्यास सांगतोस. ");
INSERT INTO mar_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","मी या लोकांचे गर्भधारण केले काय? मी त्यांना जन्म दिला आहे का म्हणून तू म्हणतोस की, जसा पिता आपल्या बाळाला छातीशी धरून घेऊन जातो तसे मी त्यांना न्यावे? जो देश देण्याविषयी त्यांच्या पूर्वजांना तू शपथ दिली त्यांना मी घेऊन जावे का? ");
INSERT INTO mar_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","एवढ्या लोकांस पुरेल एवढे मांस देण्यासाठी मी कोठे शोधू? ते माझ्याकडे आसवे गाळून रडत आहेत, ते म्हणतात आम्हास खावयास मांस दे! ");
INSERT INTO mar_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","मी एकटा या सर्वांची काळजी घेऊ शकत नाही. हे माझ्यासाठी फारच जड आहे. ");
INSERT INTO mar_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","जर तू मला अशा मार्गाने वागवतोस, तुझी दया माझ्यावर असल्यास मला आता मारुन टाक आणि माझे दुःख दूर कर. ");
INSERT INTO mar_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","परमेश्वर मोशेला म्हणाला, इस्राएलाच्या वडिलांचे सत्तर मनुष्ये मजकडे आण. मंडळीचे नेते असलेल्या या लोकांस दर्शनमंडपाच्या दारापाशी आण; व तुझ्याबरोबर त्यांना उभे कर. ");
INSERT INTO mar_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","मग मी खाली येऊन तेथे तुझ्याशी बोलेन. मग तुझ्यावर असलेल्या आत्म्यातून काही भाग मी त्यांनाही देईन. मग लोकांची काळजी घेण्यास ते तुला मदत करतील. ह्याप्रकारे इस्राएल लोकांची जबाबदारी केवळ तुझ्या एकट्यावर राहणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","लोकांस सांग उद्या तुम्ही स्वत: शुद्ध राहा म्हणजे तुम्हास मांस खावयास मिळेल. परमेश्वराने तुमचे रडगाणे ऐकले आहे. आम्हास मांस खाण्यास पाहिजे! आम्ही मिसरमध्ये होतो ते बरे होते, असे तुम्ही म्हणाला ते शब्दही परमेश्वराने ऐकले आहेत. तेव्हा आता परमेश्वर तुम्हास मांस देईल आणि तुम्ही ते खाल. ");
INSERT INTO mar_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","तुम्ही ते एक, किंवा दोन, किंवा पाच, किंवा दहा दिवस, वीस दिवसच नाही तर, ");
INSERT INTO mar_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","परंतु तुम्ही ते पूर्ण महिनाभर तुमच्या नाकपुड्यातून निघेपर्यंत आणि तुम्हास शिसारी येईपर्यंत तुम्ही ते खाल. कारण तुम्ही जो परमेश्वर तुम्हामध्ये राहतो त्यास तुम्ही नाकारले आहे. तुम्ही त्याच्यासमोर रडला. तुम्ही म्हणाला, आम्ही मिसर देश का सोडला? ");
INSERT INTO mar_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","नंतर मोशे म्हणाला, परमेश्वरा येथे सहा लाख लोक आहेत आणि तू म्हणतोस की, ह्याना पूर्ण महिनाभर पुरेल एवढे मांस मी खावयास देईन! ");
INSERT INTO mar_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","आम्ही त्यांना तृप्त करावे म्हणून शेरडेमेंढरे व गुरेढोर कापावीत काय? किंवा समुद्रातील सर्व मासे त्यांच्यासाठी गोळा करून आणावे काय? ");
INSERT INTO mar_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","परमेश्वर मोशेला म्हणाला, “माझा हात तोकडा आहे काय? आता माझे शब्द खरे आहेत की नाही हे तू पाहशील.” ");
INSERT INTO mar_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","मोशे बाहेर गेला आणि परमेश्वर जे बोलला ते लोकांस सांगितले. मग मोशेने मंडळीच्या सत्तर वडिलांना एकत्र जमविले आणि त्याने त्यांना तंबू सभोवती उभे केले. ");
INSERT INTO mar_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","मग परमेश्वर ढगात उतरून आला आणि मोशेशी बोलला. मोशेवर परमेश्वराचा आत्मा होता. त्यातून काही घेऊन परमेश्वराने ते त्या सत्तर वडिलावर ठेवला. तो आत्मा आल्यावर ते संदेश सांगू लागले. परंतु त्यानंतर मात्र त्यांनी पुन्हा संदेश सांगितला नाही. ");
INSERT INTO mar_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","त्यातील दोन वडील एलदाद व मेदाद छावणीच्या बाहेर गेले नाहीत. त्यांची नांवे वडीलांच्या यादीत होती. परंतु ते छावणीतच राहिले; त्यामुळे आत्मा त्यांच्यावरही आला आणि ते छावणीतच संदेश सांगू लागले. ");
INSERT INTO mar_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","तेव्हा एका तरुणाने पळत जाऊन मोशेला हे सांगितले. तो म्हणाला, एलदाद व मेदाद हे छावणीत संदेश सांगत आहेत. ");
INSERT INTO mar_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","तेव्हा नूनाचा मुलगा यहोशवा मोशेला म्हणाला, मोशे, माझे स्वामी तुम्ही त्यांना बंदी घाला. यहोशवा तरुण असल्यापासून मोशेचा मदतनीस होता. ");
INSERT INTO mar_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","मोशेने त्यास उत्तर दिले, माझ्या प्रतिष्ठेसाठी तू त्यांचा हेवा करतोस काय? परमेश्वराचे सर्वच लोक संदेष्टे असते आणि परमेश्वराने त्या सर्वांवर आपला आत्मा ठेविला असता तर किती बरे होते. ");
INSERT INTO mar_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","मग मोशे व इस्राएलाच्या वडीलजनासह छावणीत परत गेला. ");
INSERT INTO mar_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","मग परमेश्वराने समुद्रावरुन जोरदार वारा वाहावयास लाविला. त्या वाऱ्याने लावे पक्षी त्या भागात वाहून आणले. ते लावे पक्षी सर्व छावणीच्या भोंवती उडत राहिले. ते इतके होते की छावणीचे अंगण व सारा परिसर त्यांनी भरुन गेला. त्यांचा जमिनीपासून दोन हात उंचीचा थर साचला. मनुष्य एक दिवसभरात जितका दूर चालत जाईल तिथपर्यंत तो थर होता. ");
INSERT INTO mar_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","लोक बाहेर पडले व त्यांनी दिवसभर व रात्रभर लावे पक्षी गोळा केले आणि त्यांनी पूर्ण दुसरा दिवसभरही ते गोळा केले. ज्याने सर्वात कमी गोळा केले पक्षी त्यांचे दहा होमर भरले. त्यांनी लावे पक्षी सर्व छावणी सभोवती पसरून ठेवले. ");
INSERT INTO mar_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ते मांस त्यांच्या दातात होते, ते चावण्याच्या आधीच परमेश्वराचा राग त्यांच्यावर भयंकर भडकला. त्यांने लोकांचा भयंकर आजाराने संहार केला. ");
INSERT INTO mar_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","त्या जागेला किब्रोथ-हत्तव्वा असे नांव दिले. कारण ज्या लोकांस मांस खाण्याची अतिशय तीव्र इच्छा झाली होती त्यांना तेथे पुरण्यात आले. ");
INSERT INTO mar_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","किब्रोथ-हत्तव्वापासून लोकांनी हसेरोथ गावापर्यंत प्रवास केला व तेथे त्यांनी मुक्काम केला. ");
INSERT INTO mar_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मग मिर्याम व अहरोन मोशेविरूद्ध बोलू लागले. कारण त्याने एका कुशी-स्त्रीशी लग्न केले. ");
INSERT INTO mar_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ते म्हणाले, “परमेश्वर फक्त मोशेबरोबरच बोलला काय? तो आमच्याबरोबरही बोलला नाही काय? आता परमेश्वराने ते जे काय बोलले ते ऐकले.” ");
INSERT INTO mar_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","आता पृथ्वीवरील कोणत्याही मनुष्यापेक्षा मोशे अधिक नम्र होता. ");
INSERT INTO mar_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","तेव्हा परमेश्वर एकाएकी मोशे, अहरोन व मिर्याम ह्याच्याशी बोलला. “तुम्ही तिघे आत्ताच्या आता दर्शनमंडपापाशी या!” तेव्हा ते तिघे बाहेर आले. ");
INSERT INTO mar_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","परमेश्वर एका ढगाच्या खांबातून खाली आला मंडपाच्या प्रवेशदारापाशी उभा राहिला. परमेश्वराने हाक मारली, अहरोन व मिर्याम तेव्हा ते दोघे पुढे आले. ");
INSERT INTO mar_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","परमेश्वर म्हणाला, “आता माझे शब्द ऐका. जेव्हा माझे संदेष्टे तुमच्याबरोबर आहेत, मी स्वतः त्यांना दृष्टांतातून प्रकट होतो, आणि त्यांच्याशी स्वप्नात बोलतो ");
INSERT INTO mar_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","माझा सेवक मोशे तसा नाही.” तो माझ्या सर्व घराण्यात विश्वासू आहे. ");
INSERT INTO mar_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","मी त्याच्याशी समोरासमोर बोलतो. दृष्टांताने किंवा कोड्यानी बोलत नाही. तो माझे स्वरूप पाहत असतो. तर असे असताना माझा सेवक मोशे ह्याच्या विरूद्ध बोलताना तुम्हास भीती कशी वाटली नाही? ");
INSERT INTO mar_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","परमेश्वराचा राग त्यांच्यावर खूप भडकला आणि नंतर तो त्यांना सोडून गेला. ");
INSERT INTO mar_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ढग निवास मंडपापासून वर गेला. आणि मिर्याम अचानक बर्फासारखी पांढरी झाली होती. तेव्हा अहरोन मिर्यामकडे वळाला, त्याने पाहिले मिर्याम कोडी झाली. ");
INSERT INTO mar_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","अहरोन मोशेला म्हणाला, अहो, माझे स्वामी, आम्ही केलेल्या मूर्खपणाच्या पापाबद्दल आमची क्षमा करा व त्याचा दोष आमच्यावर ठेवू नको. ");
INSERT INTO mar_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","कोणी आपल्या आईच्या उदरातून अर्धे शरीर नष्ट झालेला असा मेलेलाच बाहेर पडतो, त्याच्यासारखी ही मृतवत होऊ नये. ");
INSERT INTO mar_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","म्हणून मोशे परमेश्वराकडे रडून म्हणाला, हे देवा, मी तुला विनंती करतो, तू हिला बरे कर. ");
INSERT INTO mar_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","परमेश्वराने मोशेला उत्तर दिले, जर तिचा बाप तिच्या तोंडावर थुंकला असता तर तिला सात दिवस लाज वाटली असती ना! तेव्हा सात दिवस तिला छावणीच्या बाहेर काढ मग ती बरी होईल; मग तिने परत छावणीत यावे. ");
INSERT INTO mar_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","म्हणून त्यांनी मिर्यामला सात दिवस छावणीबाहेर कोंडून ठेवले आणि ती छावणीत परत येईपर्यंत लोकांनी आपला मुक्काम हलविला नाही. ");
INSERT INTO mar_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","त्यानंतर लोकांनी हसेरोथ सोडले आणि पारानाच्या रानापर्यंत त्यांनी प्रवास केला आणि तेथे रानातच त्यांनी आपला तळ ठोकला. ");
INSERT INTO mar_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","नंतर परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“कनान देश हेरण्यासाठी काही लोकांस पाठव. हाच देश मी इस्राएल लोकांस देणार आहे. त्यांच्या बारा वंशानुसार प्रत्येकी एका सरदाराला पाठव.” ");
INSERT INTO mar_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","तेव्हा मोशेने परमेश्वराची आज्ञा मानून, लोक पारानाच्या रानात असताना हे सरदार पाठवले. ते सर्व इस्राएलाच्या वंशातील होते. ");
INSERT INTO mar_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","त्यांची नांवे अशी आहेत:रऊबेन वंशातला जक्कुराचा मुलगा शम्मुवा. ");
INSERT INTO mar_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","शिमोन वंशातला होरीचा मुलगा शाफाट. ");
INSERT INTO mar_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदा वंशातला यफुन्नेचा मुलगा कालेब. ");
INSERT INTO mar_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्साखार वंशातला योसेफाचा मुलगा इगाल. ");
INSERT INTO mar_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एफ्राईम वंशातला नूनाचा मुलगा होशा. ");
INSERT INTO mar_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बन्यामीन वंशातला राफूचा मुलगा पलटी, ");
INSERT INTO mar_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","जबुलून वंशातला सोदीचा मुलगा गद्दीयेल, ");
INSERT INTO mar_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","योसेफ वंशातला (मनश्शे) सूसीचा मुलगा गद्दी, ");
INSERT INTO mar_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दान वंशातला गमल्लीचा मुलगा अम्मीयेल. ");
INSERT INTO mar_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशेर वंशातला मीकाएलाचा मुलगा सतूर, ");
INSERT INTO mar_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नफताली वंशातला बाप्सीचा मुलगा नहब्बी. ");
INSERT INTO mar_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","आणि गाद वंशातला माकीचा मुलगा गऊवेल. ");
INSERT INTO mar_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","मोशेने देश हेरावयास पाठवलेल्या लोकांची ही नांवे होती. (मोशेने नूनाचा मुलगा होशा ह्याचे नांव यहोशवा असे ठेवले.) ");
INSERT INTO mar_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","मोशेने कनान देश हेरण्यास पाठवताना लोकांस सांगितले की तुम्ही येथून नेगेब प्रांतामधून निघा आणि मग डोंगराळ प्रदेशात जा. ");
INSERT INTO mar_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","देश कसा आहे? तेथील लोक कसे आहेत! ते बलवान आहेत किंवा दुबळे आहेत? ते थोडे आहेत किंवा फार आहेत? ते पाहा व समजून घ्या. ");
INSERT INTO mar_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ते राहतात तो देश कसा आहे? तो चांगला आहे किंवा वाईट आहे? ते लोक कशा प्रकारच्या नगरात राहतात? संरक्षणासाठी त्या नगरांभोवती कोट आहेत का? त्या नगरांची संरक्षण व्यवस्था बलवान आहे का? या सर्व गोष्टी पाहा व समजून घ्या. तेथील जमीन पीक घेण्यास ");
INSERT INTO mar_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","योग्य आहे का? त्या प्रदेशात झाडे आहेत का? तेथील काही फळे बरोबर घेऊन या. ते दिवस द्राक्षाच्या पहिल्या बहराचे होते. ");
INSERT INTO mar_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","म्हणून ते तो प्रदेश शोधायला निघाले. त्यांनी सीन रानापासून रहोब आणि लेबो हमाथपर्यंतच्या प्रदेशात शोध घेतला. ");
INSERT INTO mar_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","त्यांनी नेगेबमधून त्या प्रदेशात प्रवेश केला आणि ते हेब्रोनला गेले. हेब्रोन शहर मिसर देशातल्या सोअन शहराच्या सात वर्षे आधी बांधले होते. अहीमान शेशय आणि तलमय हे अनाकाचे वंशज तेथे राहत होते. ");
INSERT INTO mar_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","नंतर ते लोक अष्कोलच्या खोऱ्यात गेले. तेथे त्यांनी द्राक्षाच्या वेलीची एक फांदी तोडली. त्या फांदीला द्राक्षाचा घोसासहीत त्यांनी ती फांदी एका खांबावर ठेवली आणि दोघेजण ती आपल्या मधोमध ठेवून घेऊन गेले. त्यांनी बरोबर काही डाळिंबे व अंजीर ही घेतली. ");
INSERT INTO mar_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","त्या जागेला अष्कोल खोरे असे म्हणतात कारण तिथे इस्राएल लोकांनी द्राक्षाचा घड तोडला होता. ");
INSERT INTO mar_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","त्या लोकांनी त्या प्रदेशाचा चाळीस दिवस शोध घेतला. नंतर ते आपल्या छावणीत परत गेले. ");
INSERT INTO mar_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","इस्राएल लोकांची छावणी पारानाच्या वाळवंटात कादेशजवळ होती ते लोक मोशे, अहरोन आणि इस्राएलाच्या सर्व मंडळीजवळ गेले. त्यांनी मोशे, अहरोन आणि इतर लोकांस त्यांनी पाहिलेल्या गोष्टीविषयी सांगितले आणि त्या प्रदेशातली फळे त्यांना दाखवली. ");
INSERT INTO mar_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ते लोक मोशेला म्हणाले, “तू आम्हास ज्या देशात पाठवले आणि आम्ही तेथे पोहचलो. आणि खचीत दूध व मध वाहणारा तो देश आहे आणि ही त्यातली काही फळे आहेत. ");
INSERT INTO mar_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","पण तेथे राहणारे लोक खूप शक्तीशाली आहेत. शहरे खूप मोठी आणि तटबंदीची आहेत. शहरांचे रक्षण चांगल्या प्रकारे होते. काही अनाकांच्या वंशाजानाही आम्ही पाहिले. ");
INSERT INTO mar_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","अमालेकी लोक नेगेबमध्ये राहतात. हित्ती, यबूसी आणि अमोरी डोंगराळ भागात राहतात. आणि कनानी लोक समुद्राजवळ आणि यार्देन नदीच्या काठावर राहतात.” ");
INSERT INTO mar_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","मोशेजवळच्या लोकांस गप्प बसण्यास सांगून कालेब म्हणाला, “परत जाऊन तो प्रदेश आपण घ्यायला पाहिजे. आपण तो प्रदेश सहज घेऊ शकू.” ");
INSERT INTO mar_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","पण जे लोक त्याच्याबरोबर तेथे गेले होते ते म्हणाले, “आपण त्यांच्याशी लढू शकणार नाही. ते आपल्यापेक्षा खूप शक्तीशाली आहेत.” ");
INSERT INTO mar_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","आणि त्या मनुष्यांनी इस्राएलाच्या सर्व लोकांस सांगितले की त्या प्रदेशातल्या लोकांचा पराभव करण्याइतके शक्तीशाली आपण नाहीत. ते म्हणाले, आम्ही जो प्रदेश पाहिला तो शक्तीशाली लोकांनी भरलेला आहे. ते लोक तिथे जाणाऱ्या कोणत्याही मनुष्याचा सहज पराभव करण्याइतके शक्तीमान आहेत. ");
INSERT INTO mar_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","आम्ही तिथे खूप नेफीलीम म्हणजे नेफीलीम घराण्यातील अनाकाचे वंशज पाहिले. त्यांच्यापुढे आम्ही स्वतःच्या दृष्टीने नाकतोड्यासारखे असे होतो अशी तुलना केली आणि त्यांच्या दृष्टीनेसुद्धा आम्ही तसेच होतो. ");
INSERT INTO mar_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","त्या रात्री सर्व मंडळीने गळा काढून जोरजोरात आक्रोश केला आणि रडले. ");
INSERT INTO mar_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","इस्राएल लोकांनी मोशे आणि अहरोनाविरूद्ध तक्रारी केल्या. सर्व मंडळी त्यांना म्हणाली “आम्ही मिसर देशामध्ये किंवा रानात मरण पावलो असतो तर बरे झाले असते. ");
INSERT INTO mar_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","तलवारीने आमचा नाश व्हावा म्हणून या नवीन प्रदेशात युद्धात जाण्यासाठीच परमेश्वराने आम्हास इथे आणले का? शत्रू आम्हास मारून टाकील आणि आमच्या स्त्रिया मुलांना घेऊन जाईल. मिसर देशात परत जाणेच आमच्या दृष्टीने जास्त बरे आहे.” ");
INSERT INTO mar_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","नंतर ते एकमेकांना म्हणाले, “आपण आता दुसरा नेता निवडू आणि मिसर देशात परत जाऊ.” ");
INSERT INTO mar_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","तिथे जमलेल्या सर्व इस्राएलांच्या मंडळीसमोर मोशे आणि अहरोन पालथे पडले. ");
INSERT INTO mar_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","नूनाचा मुलगा यहोशवा आणि यफुन्नेचा मुलगा कालेब, जे कोणी देश तपासणीसाठी पाठवले होते त्यामधील हे दोघे होते, त्यांनी आपली वस्त्रे फाडली. ");
INSERT INTO mar_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ते इस्राएल लोकांच्या सर्व मंडळीशी बोलले. ते म्हणाले, आम्ही जो देश हेरायला येथून तेथे फिरलो तो देश खूप चांगला आहे. ");
INSERT INTO mar_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","जर परमेश्वर आपल्यावर प्रसन्न झाला तर तो आपल्याला त्या देशात नेईल आणि तो दूध व मध वाहणारा देश आपल्याला देईल. ");
INSERT INTO mar_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","“परंतु परमेश्वराविरूद्ध बंड करू नका आणि त्या देशातल्या लोकांची भीती बाळगू नका. आपल्या अन्नाप्रमाणे आपण त्यांना सहज भक्ष्य करू. त्यांचे संरक्षण त्यांच्यापासून काढले जाईल, कारण परमेश्वर आमच्याबरोबर आहे. त्यांना घाबरु नका.” ");
INSERT INTO mar_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","पण सर्व मंडळी म्हणू लागली त्यांना दगडमार करा. परंतु परमेश्वराचे तेज दर्शनमंडपावर इस्राएल लोकांस दिसले. ");
INSERT INTO mar_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","परमेश्वर मोशेला म्हणाला, “हे लोक कोठवर मला तुच्छ लेखतील? ह्यांच्यामध्ये मी केलेली शक्तीशाली चिन्हे पाहूनही त्याची पर्वा न करता माझ्यावर विश्वास ठेवण्यास चुकत आहेत. ");
INSERT INTO mar_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","मी त्यांना मरीने मारून टाकीन. मी त्यांचा वारसा हक्क काढून घेईल, आणि मी तुझ्या स्वतःच्या कुळापासून त्यांच्यापेक्षा मोठे व सामर्थ्यशाली राष्ट्र करीन.” ");
INSERT INTO mar_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","मोशे परमेश्वरास म्हणाला, जर तू असे केलेस तर ते मिसरी लोक ऐकतील कारण तू आपल्या सामर्थ्याने या लोकांस बाहेर आणले. ");
INSERT INTO mar_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ते त्या देशातल्या राहणाऱ्यांना हे सांगतील, त्यांनी ऐकले आहे की तू परमेश्वर या लोकांच्या मध्ये आहेस, कारण तू परमेश्वर प्रत्यक्ष दिसत आहेस तुझा ढग त्यांच्यावरती उभा राहतो, आणि दिवसा ढगाच्या खांबात रात्री त्या ढगाचा अग्नीच्या खांबात तू त्यांच्यापुढे चालतोस. ");
INSERT INTO mar_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","आता जर तू या लोकांस एका मनुष्याप्रमाणे मारले, तर ज्या राष्ट्रांनी तुझी किर्ती ऐकली आहे ते बोलतील आणि म्हणतील, ");
INSERT INTO mar_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","परमेश्वराने त्यांना जो देश देण्याचे शपथपूर्वक सांगितले होते त्यामध्ये तो आणू शकला नाही म्हणून त्याने त्यांना रानात मारून टाकले. ");
INSERT INTO mar_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“म्हणून आता मी विनंती करतो, तुझ्या महान सामर्थ्याचा उपयोग कर. तू, म्हणाला होतास, ");
INSERT INTO mar_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","परमेश्वर रागवायला मंद आहे आणि विपुल दयेने भरलेला आहे. तो अपराधांची व अधर्माची क्षमा करतो पण जे लोक अपराधी आहेत त्यांची मुळीच गय करत नाही. तो पूर्वजांच्या पापाबद्दल त्यांच्या वंशजाच्या तिसऱ्या व चौथ्या पिढीवर वडिलांच्या अन्यायाची शिक्षा लेकरांना करतो. ");
INSERT INTO mar_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","मी तुला विनंती करतो, तुझ्या महान विश्वसनीयतेच्या कराराने त्यांच्या पापांची क्षमा कर. त्यांनी मिसर सोडल्यापासून आतापर्यंत तू जसा त्यांना क्षमा करीत आला आहेत तशीच आताही त्यांना क्षमा कर.” ");
INSERT INTO mar_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","परमेश्वर म्हणाला, “तू विनंती केल्याप्रमाणे मी त्यांना क्षमा केली आहे.” ");
INSERT INTO mar_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","पण खचित जसा मी जिवंत आहे आणि सारी पृथ्वी परमेश्वराच्या वैभवाने भरलेली आहे. ");
INSERT INTO mar_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ज्या सर्व लोकांनी माझे वैभव आणि मिसर देशात व रानात सामर्थ्याची चिन्हे पाहिले. तरी दहादा त्यांनी माझी परीक्षा पाहिली आणि माझी वाणी ऐकली नाही. ");
INSERT INTO mar_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","मी जो देश त्यांच्या पूर्वजांना शपथपूर्वक देऊ केला तो ते खचित पाहणार नाहीत. ज्यांनी मला तुच्छ मानले त्यांच्यापैकी तो कोणीही पाहणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","पण माझा सेवक कालेब याच्यासोबत वेगळा आत्मा होता. तो माझे अनुकरण पूर्णपणे करतो. म्हणून ज्या देशात तो गेला होता त्या देशात मी त्यास नेईल. आणि त्याच्या वंशजांना तो देश वतन होईल. ");
INSERT INTO mar_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","अमालेकी आणि कनानी लोक खोऱ्यात राहत आहेत. म्हणून उद्या तुम्हीही जागा सोडली पाहिजे. तांबड्या समुद्राकडे रस्त्यावरच्या रानात परत जा. ");
INSERT INTO mar_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","परमेश्वर मोशे आणि अहरोनाशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","ही दुष्ट मंडळी माझ्याविरूद्ध टिका करते त्यांचे मी किती काळ सहन करू? इस्राएली लोक माझ्याविरूद्ध तक्रार करतात त्या मी ऐकल्या आहेत. ");
INSERT INTO mar_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","तू त्यांना सांग, परमेश्वर म्हणतो, मी जिवंत आहे. जसे तुम्ही माझ्या कानात बोलला तसे मी करीन. ");
INSERT INTO mar_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","तुमची प्रेते या रानात पडतील. तुमच्यापैकी ज्यांची गणना झाली त्यांच्या पूर्ण संख्येतील वीस वर्षांचा किंवा त्याहून अधिक वयाचे ज्यांनी माझ्याविरूद्ध कुरकुरले, ");
INSERT INTO mar_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ज्या देशात तुमचे घर देण्याचे वचन मी तुम्हास दिले त्यामध्ये तुमच्यापैकी कोणीही जाणार नाही. फक्त यफुन्नेचा मुलगा कालेब आणि नूनाचा मुलगा यहोशवा जातील. ");
INSERT INTO mar_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ज्या तुमच्या मुलाबाळाविषयी तुम्ही म्हणाला की, त्यांची लूट होईल. मी त्यांना त्या देशात नेईल. तुम्ही जो देश नाकारला तो देश ते अनुभवतील. ");
INSERT INTO mar_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","आणि तुमच्याविषयी तर तुमची प्रेते या रानात पडतील. ");
INSERT INTO mar_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","तुमची प्रेते या रानात नष्ट होईपर्यंत चाळीस वर्षे तुमची मुलेबाळे तुम्ही केलेल्या विश्वासघाताची शिक्षा भोगीत रानात भटकणारी होतील. ");
INSERT INTO mar_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","तुम्हास तुमच्या पापाबद्दल चाळीस वर्षे दु:ख भोगावे लागेल. त्या मनुष्यांना तो प्रदेश शोधायला चाळीस दिवस लागले. त्या प्रत्येक दिवसासाठी एक वर्ष मी तुमच्या विरोधात असणे ही किती भयानक गोष्ट आहे हे तुम्हास समजेल. ");
INSERT INTO mar_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“मी परमेश्वर आहे आणि मी बोललो आहे. मी वचन देतो की या दुष्ट मनुष्यांना मी या सर्व गोष्टी करीन. माझ्याविरूद्ध जाण्यासाठी ते लोक एकत्र आले म्हणून ते सर्व या रानात मरतील.” ");
INSERT INTO mar_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","मोशेने ज्या लोकांस नवीन प्रदेश शोधण्यासाठी पाठवले होते त्याच लोकांनी परत येऊन इस्राएल लोकांमध्ये तक्रारी पसरावयाला सुरुवात केली. ते लोक म्हणाले की त्या प्रदेशात जाण्याइतके आपले लोक शक्तीवान नाहीत. ");
INSERT INTO mar_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ज्यांनी वाईट वर्तमान आणले ते पुरुष जबाबदार होते ते परमेश्वरासमोर मरीने मरण पावले. ");
INSERT INTO mar_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","यफुन्नेचा मुलगा कालेब आणि नूनाचा मुलगा यहोशवा हे ही तो देश शोधायला पाठवलेल्या लोकात होते परंतु परमेश्वराने त्या दोघांना वाचवले. ");
INSERT INTO mar_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","मोशेने या सर्व गोष्टी इस्राएल लोकांस सांगितल्या. लोक खूप दु:खी झाले. ");
INSERT INTO mar_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","दुसऱ्या दिवशी पहाटे लोकांनी डोंगरावर असलेल्या त्या देशात जायला सुरुवात केली. लोक म्हणाले, “आम्ही पाप केले आहे. आम्ही परमेश्वरावर विश्वास ठेवला नाही याचे आम्हास वाईट वाटते. परमेश्वराने वचन दिलेल्या देशात आम्ही जाऊ.” ");
INSERT INTO mar_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","पण मोशे म्हणाला, “तुम्ही परमेश्वराची आज्ञा का पाळत नाही? तुम्हास यश मिळणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","त्या देशात जाऊ नका. परमेश्वर तुमच्याबरोबर नाही म्हणून तुमचा सहज पराभव होऊ शकेल. ");
INSERT INTO mar_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","अमालेकी आणि कनानी लोक आहेत तुम्ही तलवारीने पडाल. तुम्ही परमेश्वरापासून दूर गेला आहात म्हणून युध्दाच्या वेळी तो तुमच्याबरोबर नसेल आणि तुम्ही सर्व युद्धात मारले जाल.” ");
INSERT INTO mar_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","परंतु लोकांनी मोशेवर विश्वास ठेवला नाही. ते उंच डोंगरावरच्या प्रदेशात गेले. परंतु मोशे आणि परमेश्वराचा आज्ञापटाचा कोश त्यांच्याबरोबर गेला नाही. ");
INSERT INTO mar_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","डोंगरावरच्या प्रदेशात राहणारे अमालेकी आणि कनानी लोक खाली आले आणि त्यांनी इस्राएल लोकांवर हल्ला केला. त्यांनी इस्राएल लोकांचा सहज पराभव केला आणि हर्मा नगरापर्यंत त्यांचा पाठलाग केला. ");
INSERT INTO mar_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","मग परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","इस्राएल लोकांबरोबर बोल आणि त्यांना सांग. परमेश्वर तुम्हास एक देश वस्ती करण्यासाठी देत आहे. तुम्ही जेव्हा तिथे पोहचाल, ");
INSERT INTO mar_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","आणि तुम्ही परमेश्वरासाठी सुवास म्हणून गुरेढोरे किंवा शेरडेमेंढरे यांचे परमेश्वराकरता अर्पण कराल, मग ते होमार्पणाचे असो किंवा नवस फेडण्याचा किंवा स्वखुशीचा किंवा तुमच्या सणातला तो यज्ञ असो. ");
INSERT INTO mar_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","जो कोणी आपले अर्पण परमेश्वराकरता आणतो त्याने हिनाच्या एक चतुर्थाश तेलात मळलेले एफाचा एक दशांश सपिठ अन्नार्पण आणावे. ");
INSERT INTO mar_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","प्रत्येक कोकऱ्याच्या होमार्पणाकरता किंवा यज्ञाकरता पेयार्पणासाठी एका हीनाचा एक चतुर्थाश द्राक्षरस तयार कर. ");
INSERT INTO mar_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","अन्नार्पण म्हणून प्रत्येक मेंढ्यामागे एकतृतीयांश हिन तेलात मळलेले दोन दशमांश एफा सपीठ तयार करावे. ");
INSERT INTO mar_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","परमेश्वरास सुवास यावा म्हणून एकतृतीयांश हिनभर द्राक्षरसाचे पेयार्पण तयार करावे. ");
INSERT INTO mar_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","जेव्हा तू परमेश्वराकरता होमार्पण किंवा नवस फेडण्यासाठी यज्ञ किंवा शांत्यर्पणाचा यज्ञ म्हणून गोऱ्हा म्हणून अर्पण करावा. ");
INSERT INTO mar_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","तेव्हा अर्पण करणाऱ्याने त्या गोऱ्ह्या बरोबर अर्धां हिन तेलात मळलेल्या तीन दशमांश एफा सपिठाचे अन्नार्पण करावे. ");
INSERT INTO mar_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","तू पेयार्पणासाठी अर्धा हीन द्राक्षरस अग्नीतून केलेले अर्पण, परमेश्वरास सुवासाचे अर्पण कर. ");
INSERT INTO mar_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","तुम्ही परमेश्वरास जो बैल, मेंढा, मेंढी किंवा कोकरा यांचे अर्पण कराल ते याप्रमाणे करावे. ");
INSERT INTO mar_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","तुम्ही जे प्रत्येक अर्पण तयार कराल आणि ते अर्पण याप्रमाणे अर्पण करा. ");
INSERT INTO mar_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","अग्नीतून केलेले अर्पण परमेश्वरास सुवासाचे असे अर्पण करताना देशात जन्मलेल्या सर्वांनी या वस्तू याप्रमाणे अर्पण कराव्या. ");
INSERT INTO mar_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","तुमच्याबरोबर राहत असलेल्या परदेशीयाला अथवा पिढ्यानपिढ्या तुमच्यामध्ये वस्ती करून राहिलेल्या कोणालाही परमेश्वराकरता हे सुवासिक हव्य अर्पण करायची इच्छा झाली तर तुमच्या प्रमाणेच त्यानेही केले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","हेच नियम सर्वांना लागू आहेत. इस्राएलचे लोक आणि परदेशी लोक तुमच्या देशात राहतात. त्यांना हे नियम सर्वकाळ लागू राहतील. तुम्ही आणि तुमच्याबरोबर राहणारे इतर लोक परमेश्वरापुढे समान आहात. ");
INSERT INTO mar_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","हे नियम व विधी तुम्हास आणि तुमच्यात राहणाऱ्या इतरांना एकच असावा. ");
INSERT INTO mar_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","परमेश्वर मोशेशी पुन्हा बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","इस्राएल लोकांशी बोल व त्यांना सांग मी ज्या देशात तुम्हास घेऊन जात आहे त्यामध्ये तुम्ही जाऊन पोहचाल. ");
INSERT INTO mar_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","जेव्हा तुम्ही तेथे पिकणारे अन्न खाल तेव्हा त्यातला काही भाग समर्पण म्हणून परमेश्वरास अर्पण करा. ");
INSERT INTO mar_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","मळलेल्या कणिकेची पहिली पोळी करून परमेश्वरास अर्पण करावा. तुम्ही आपल्या खळ्यातला समर्पण म्हणून जो भाग अर्पण करता त्याप्रमाणे ही अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","मळलेल्या कणिकेतून पहिला काही भाग तुम्ही समर्पण म्हणून परमेश्वरास पिढ्यानपिढ्या द्यावा. ");
INSERT INTO mar_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","जेव्हा तुम्ही परमेश्वराने मोशेला सांगितलेल्या या सर्व आज्ञेपैकी कधीतरी नकळत मोडली. ");
INSERT INTO mar_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","परमेश्वराने त्या आज्ञा तुम्हास मोशे मार्फत दिल्या आहेत त्या दिवसापासून व पुढेही तुमच्या पिढ्यानपिढ्या आहेत. ");
INSERT INTO mar_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","तेव्हा असे व्हावे की, मंडळीला नकळत जर तुम्ही पाप केले, तर सर्व मंडळीने मिळून परमेश्वरास सुवास म्हणून एक गोऱ्हा होमार्पण, नियमानुसार अन्नार्पण आणि पेयार्पण करावे. तुम्ही पापार्पणासाठी बकराही अर्पण करावा. ");
INSERT INTO mar_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","म्हणून याजकाने इस्राएलाच्या सर्व लोकांसाठी प्रायश्चित करावे. म्हणजे त्याची क्षमा होईल. कारण त्यांचे पाप चुकून झाले असून त्यांनी आपल्या या चुकीबद्दल आपले अर्पण म्हणजे परमेश्वराकरता हव्य आणि आपला पापबलि परमेश्वरासमोर अर्पिला आहे. ");
INSERT INTO mar_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","इस्राएलाच्या सर्व लोकांस आणि त्यांच्यात राहणाऱ्या इतर लोकांस क्षमा केली जाईल. त्यांना क्षमा करण्यात येईल. कारण आपण चूक करीत आहोत हे त्यांना माहीत नव्हते. ");
INSERT INTO mar_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","पण जर फक्त एकाच मनुष्याने नकळत पाप केले तर त्याने एक वर्ष वयाची बकरी आणली पाहिजे. ती बकरी पापासाठी अर्पण केली जाईल. ");
INSERT INTO mar_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","त्या मनुष्याने चुकून परमेश्वरापुढे पाप केले. तर त्या नकळत पाप करणाऱ्या मनुष्यासाठी प्रायश्चित करायला याजकाने प्रायश्चित करावे म्हणजे त्याची क्षमा होईल. ");
INSERT INTO mar_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","जो मनुष्य चुकून पाप करतो त्याच्यासाठी हा नियम आहे. इस्राएलच्या कुटुंबात जन्मलेल्या लोकांसाठी व तुमच्यात राहणाऱ्या परदेशी लोकांसाठी सारखेच नियम आहेत. ");
INSERT INTO mar_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","पण जर एखादा व्यक्ती काही कृत्य करून उघड विरोध करतो, इस्राएलाच्या वंशात जन्मलेल्या मनुष्यासाठी किंवा परदेशी असो, तो परमेश्वराची निंदा करणारा समजावा. त्या मनुष्यास आपल्या लोकांतून काढून टाकावे. ");
INSERT INTO mar_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","कारण त्याने परमेश्वराचा शब्द तुच्छ मानला आहे आणि त्याने माझी आज्ञा मोडली. तर त्या व्यक्तीला पुर्णपणे तुमच्यातून काढून टाकले पाहिजे. त्याचा दोष त्याच्यावरच राहील. ");
INSERT INTO mar_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","यावेळी इस्राएल लोक अजून वाळवंटात राहत होते. एका मनुष्यास जळणासाठी लाकूड सापडले म्हणून तो ते गोळा करीत होता. परंतु तो शब्बाथाचा दिवस होता. इतरांनी त्यास ते करताना पाहिले. ");
INSERT INTO mar_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ज्या लोकांनी त्यास लाकडे गोळा करताना पाहिले त्यांनी त्यास मोशे व अहरोनाकडे आणले आणि सर्व लोक भोवती गोळा झाले. ");
INSERT INTO mar_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","त्यांनी त्या मनुष्यास तिथेच ठेवले कारण त्यास काय शिक्षा द्यायची ते त्यांना माहीत नव्हते. ");
INSERT INTO mar_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","नंतर परमेश्वर मोशेला म्हणाला, “तो मनुष्य मेला पाहिजे. तेव्हा सर्व लोकांनी त्याच्यावर छावणीबाहेर दगडमार करावी.” ");
INSERT INTO mar_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","म्हणून लोक त्यास छावणीबाहेर घेऊन गेले आणि त्यास दगडमार करून मारले. परमेश्वराने मोशेला आज्ञा केली त्याप्रमाणे त्यांनी हे केले. ");
INSERT INTO mar_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","परमेश्वर मोशेशी बोलला. तो म्हणाला ");
INSERT INTO mar_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","इस्राएली वंशजाशी बोल आणि त्यांना आज्ञा कर की, त्यांनी पिढयानपिढया आपल्या वस्त्राच्या टोकांना गोंडे लावावे आणि प्रत्येक टोकाच्या गोंड्यावर एक निळा दोरा बांधा. ");
INSERT INTO mar_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","या गोंड्याचा उद्देश असा की, ते बघून परमेश्वराने दिलेल्या सगळ्या आज्ञा लक्षात ठेवाल व आज्ञा पाळाल. तुमचे हृदय व तुमची दृष्टी ज्यांच्यामागे जाऊन तुम्ही व्यभिचारी होत असा, त्याच्यामागे तुम्ही जाऊ नये. ");
INSERT INTO mar_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","“माझ्या सगळ्या आज्ञा पाळायच्या आहेत हे तुम्ही लक्षात ठेवावे. आपल्या देवाकरता पवित्र व्हावे. ");
INSERT INTO mar_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","मी तुमचा देव परमेश्वर आहे. तुम्हास मिसर देशातून आणणारा मीच आहे. तुमचा देव होण्यासाठी मी हे केले. मीच तुमचा देव परमेश्वर आहे.” ");
INSERT INTO mar_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","कोरह इसहारचा मुलगा, इसहार कहाथचा मुलगा आणि कहाथ लेवीचा मुलगा, दाथान आणि अबीराम भाऊ होते आणि ती अलीयाबाची मुले होती. ओन पेलेथचा मुलगा होता. दाथान, अबीराम आणि ओन रऊबेन वंशातील होते. यांनी काही माणसे जमवली. ");
INSERT INTO mar_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","या चार मनुष्यांनी इस्राएलातून अडीचशे माणसे एकत्र जमविली आणि ते मोशेविरूद्ध उठले. ते लोकांनी निवडलेले नेते होते, हे सर्व लोकांस माहीत होते. ");
INSERT INTO mar_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ते मोशेविरूद्ध व अहरोनाविरूद्ध एकत्र समुहाने आले. ते त्यांना म्हणाले, “तुम्ही फारच अधिकार दाखवता आता पुरे झाले! इस्राएलाचे इतर लोकसुद्धा पवित्र आहेत. त्यांच्यात अजूनही परमेश्वर राहतो. तुम्ही परमेश्वराच्या इतर लोकांपेक्षा स्वत:ला अधिक महत्वाचे समजत आहात.” ");
INSERT INTO mar_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","जेव्हा मोशेने ते ऐकले, तो पालथा पडला. ");
INSERT INTO mar_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","मग मोशे कोरह व त्याच्या सर्व अनुयायांना म्हणाला, “उद्या सकाळी परमेश्वर कोण खरोखर त्याचा मनुष्य आहे ते दाखवील. कोण खरा पवित्र आहे ते परमेश्वर दाखवील आणि परमेश्वर त्या मनुष्यास त्याच्याजवळ आणिल. परमेश्वर त्या मनुष्याची निवड करील आणि त्यास स्वत: जवळ आणिल. ");
INSERT INTO mar_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","म्हणून कोरह तू आणि तुझ्या गटाने धुपाटणे आणा. ");
INSERT INTO mar_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","उद्या अग्नी आणि धूप काही खास भांड्यात ठेवा. नंतर ती भांडी परमेश्वरासमोर आणा. खरोखरच जो पवित्र असेल त्याची परमेश्वर निवड करील. लेवीच्या वंशजांनो तुम्ही फार पुढे गेलात. तुम्ही चूक केलीत.” ");
INSERT INTO mar_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","मोशे कोरहाला आणखी म्हणाला, “लेवीच्या वंशजांनो तुम्ही माझे ऐका ");
INSERT INTO mar_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","तुमची निवड इस्राएलच्या देवाने केली आहे आणि तुम्हास खास दर्जा दिला आहे म्हणून तुम्ही आनंदी असायला हवे. तुम्ही इस्राएलच्या इतर लोकांपेक्षा वेगळे आहात. परमेश्वराने तुम्हास खास कामासाठी, इस्राएल लोकांस परमेश्वराची भक्ती करायला मदत व्हावी म्हणून त्याच्या पवित्र निवासमंडपात त्याच्याजवळ आणले. हे पुरेसे नाही का? ");
INSERT INTO mar_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","परमेश्वराने लेवीच्या वंशजांना याजकांच्या मदतीसाठी जवळ आणले. परंतु आता तुम्हीच याजक होण्याची वेळ प्रयत्न करीत आहात. ");
INSERT INTO mar_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","तुम्ही आणि तुमचे अनुयायी एकत्र आलात आणि परमेश्वराच्या विरूद्ध गेलात. अहरोनाने काही चूक केली का? नाही. मग तुम्ही अहरोनाविरूद्ध का तक्रार करीत आहात.” ");
INSERT INTO mar_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","नंतर मोशेने दाथान, अबीराम, या अलीयाबाच्या मुलांना बोलावले पण ते दोघे म्हणाले, आम्ही येणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","तू आम्हास रानात जिवे मारावे म्हणून दूध व मध वाहण्याच्या देशातून काढून वर आणले आहेस हे काय थोडे आहे. आणि आता आमच्यावर तुझी अधिक सत्ता आहे हे तुला दाखवायचे आहे. ");
INSERT INTO mar_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","आणखी तू आम्हास दूध व मध वाहण्याच्या देशात आणले नाही आणि आम्हास शेताचे व द्राक्षमळ्याचे वतन दिले नाही. आता तू पोकळ वचने देऊन आमचे डोळे आंधळे करीत आहेस काय? आम्ही तुझ्याकडे येणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","म्हणून मोशेला खूप राग आला. तो परमेश्वरास म्हणाला, “मी या लोकांच्या बाबतीत काहीही वाईट केले नाही. मी त्यांच्याकडून एक गाढव देखील घेतले नाही! आणि मी कोणाचेही वाईट केले नाही. ");
INSERT INTO mar_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","नंतर मोशे कोरहाला म्हणाला, उद्या तू आणि तुझे अनुयायी परमेश्वरापुढे उभे राहतील. तिथे तू अहरोन आणि तुझे अनुयायी असतील. ");
INSERT INTO mar_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","तुम्ही प्रत्येकाने एक भांडे आणावे त्यामध्ये धूप टाकावा आणि ते परमेश्वरास द्यावे. नेत्यांसाठी अडीचशे भांडी असतील आणि एकेक भांडे तुझ्यासाठी व अहरोनासाठी असेल.” ");
INSERT INTO mar_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","म्हणून प्रत्येकाने भांडे आणले आणि त्यामध्ये उद धूप जाळला, नंतर ते दर्शनमंडपाच्या दारात उभे राहिले. मोशे आणि अहरोनसुद्धा तिथे उभे राहिले. ");
INSERT INTO mar_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","कोरहानेसुद्धा त्याच्याविरुध्द दर्शनमंडपाच्या दारापाशी सर्व लोक जमा केले. नंतर प्रत्येकाला परमेश्वराचे तेज दिसले. ");
INSERT INTO mar_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","परमेश्वर मोशेला आणि अहरोनाला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","या लोकांपासून दूर जा. मला आता त्यांचा नाश करायचा आहे. ");
INSERT INTO mar_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","पण मोशे आणि अहरोन जमिनीवर पालथे पडले आणि ओरडले, हे देवा सर्व देहधारी आत्म्यांच्या, देवा! फक्त एका मनुष्याने पाप केले आहे! म्हणून सर्व मंडळीवर रागावू नकोस. ");
INSERT INTO mar_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","नंतर परमेश्वर मोशेला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","सर्व लोकांस कोरह, दाथान, व अबीराम यांच्या तंबूपासून दूर जायला सांग. ");
INSERT INTO mar_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","मोशे उभा राहिला आणि दाथान व अबीराम यांच्याकडे गेला. इस्राएलचे सर्व वडिलधारी त्यांच्यामागे गेले. ");
INSERT INTO mar_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","मोशेने सर्व लोकांस बजावले, या दुष्टांच्या तंबू पासून दूर जा. त्यांच्या कोणत्याही वस्तुला हात लावू नका. जर तुम्ही हात लावला तर त्यांच्या पापामुळे तुमचाही नाश होईल. ");
INSERT INTO mar_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","म्हणून लोक कोरह, दाथान व अबीराम यांच्या तंबू पासून दूर गेले. दाथान आणि अबीराम त्यांच्या तंबूकडे गेले. ते त्यांच्या तंबू बाहेर आपल्या स्त्रिया, मुले आणि लहाण्या मुलांबरोबर उभे राहिले. ");
INSERT INTO mar_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","नंतर मोशे म्हणाला, “परमेश्वराने मला मी तुम्हास सांगितलेल्या गोष्टी करायला पाठवले आहे या बद्दलचा पुरावा मी तुम्हास दाखवीन. या गोष्टी करण्याची कल्पना माझी नव्हती हेही मी तुम्हास दाखवीन. ");
INSERT INTO mar_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","हे इथले लोक मरतील. पण ते जर सामान्य रीतीने मरण पावले जशी माणसे नेहमी मरतात, तर त्यावरून असे दिसेल की परमेश्वराने मला खरेच पाठवले नाही. ");
INSERT INTO mar_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","पण जर परमेश्वराने या लोकांस वेगळ्या नव्या रीतीने मारले. तर तुम्हास कळेल की त्यांनी परमेश्वराविरूद्ध पाप केले होते. हा पुरावा आहे. धरती दुभागेल आणि त्या लोकांस आपल्या पोटात घेईल. ते जिवंतपणीच त्यांच्या कबरेत जातील. आणि त्यांची सर्व चीजवस्तू त्यांच्याबरोबर जाईल.” ");
INSERT INTO mar_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","जेव्हा मोशेचे बोलणे संपले तेव्हा त्या लोकांच्या पायाखालची जमीन दुभागली. ");
INSERT INTO mar_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","धरतीने जणू आपले तोंड उघडून त्यांना गिळून टाकले. कोरहाची सगळी माणसे, त्याचे संपूर्ण घराणे आणि त्यांची सर्व चीजवस्तू त्यांच्याबरोबर जमिनीत गेली. ");
INSERT INTO mar_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ते लोक जिवंतपणी कबरेत गेले आणि त्यांची सगळी चीजवस्तूही त्यांच्याबरोबर गेली. नंतर जमीन पूर्ववत झाली. ते नष्ट झाले-लोकांतुन नाहीसे झाले. ");
INSERT INTO mar_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","इस्राएल लोकांनी नाश होत असलेल्या लोकांचे आक्रोश ऐकले म्हणून ते सर्व सैरावैरा धावू लागले आणि म्हणाले, पृथ्वी आपल्यालासुद्धा गिळून टाकील. ");
INSERT INTO mar_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","नंतर परमेश्वराकडून अग्नी आला. त्याने धूप जाळणाऱ्या अडीचशे लोकांचा नाश केला. ");
INSERT INTO mar_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","परमेश्वर मोशेशी पुन्हा बोलला व म्हणाला ");
INSERT INTO mar_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","याजक अहरोन याचा मुलगा एलाजार याला धुपाटणी अग्नीतून काढ कारण ती पवित्र आहेत आणि तो अग्नी पसरावयाला सांग. ");
INSERT INTO mar_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","लोकांनी माझ्याविरूद्ध पाप केले आणि त्यांच्या पापामुळे त्यांना प्राण गमवावे लागले. पण धुपाटणी भांडी अजूनही पवित्र आहेत. ही भांडी पवित्र आहेत कारण ती परमेश्वरास अर्पण केली होती. भांडी ठोकून त्याचा पत्रा कर. या पत्र्याचा उपयोग वेदी झाकायला कर. इस्राएलाच्या सर्व लोकांस हा ताकीद दिल्याचा इशारा असेल. ");
INSERT INTO mar_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","म्हणून याजक एलाजाराने लोकांनी आणलेली काशाची सर्व भांडी गोळा केली. ते सगळे लोक जळून गेले पण त्यांची भांडी मात्र होती. नंतर एलाजाराने काही मनुष्यांना भांडी ठोकून त्यांचा पत्रा करायला सांगितले. नंतर त्याने धातूचा पत्रा वेदीवर ठोकला व वेदी मढवली. ");
INSERT INTO mar_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","परमेश्वराने मोशेला जशी आज्ञा केली होती तसेच त्याने केले. अहरोनाच्या वंशातीलच कोणीतरी परमेश्वरासमोर धूप जाळू शकतो, दुसऱ्या कोणी परमेश्वरासमोर धूप जाळला तर तो कोरह आणि त्याच्या अनुयायांप्रमाणे मरेल. हे इस्राएल लोकांनी लक्षात ठेवायची ही एक खूण होती. ");
INSERT INTO mar_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","दुसऱ्या दिवशी इस्राएलच्या सर्व लोकांनी मोशे आणि अहरोनाविरूद्ध तक्रार केली. ते म्हणाले, तुम्ही परमेश्वराची माणसे मारली. ");
INSERT INTO mar_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","मोशे आणि अहरोन दर्शनमंडपाच्या दारात उभे होते. लोक मोशे आणि अहरोन विरूद्ध तक्रार करायला एकत्र जमले. पण जेव्हा त्यांनी दर्शनमंडपाकडे पाहिले तेव्हा ढगांनी त्यास झाकून टाकले आणि तिथे परमेश्वराचे तेज दिसू लागले. ");
INSERT INTO mar_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","हे पाहून मोशे आणि अहरोन दर्शनमंडपाच्या पुढच्या भागात आले. ");
INSERT INTO mar_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","मग परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","त्या लोकांपासून दूर जा म्हणजे मी त्यांचा नाश करीन ताबोडतोब. मोशे आणि अहरोन यांनी त्यांचे चेहरे जमिनीपर्यंत लववून दंडवत घातले. ");
INSERT INTO mar_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","नंतर मोशे अहरोनाला म्हणाला, तुझे तांब्याचे भांडे आणि थोडासा अग्नी वेदीवरुन घे. नंतर त्यावर धूप टाक. लवकर मंडळीकडे घेऊन जा आणि त्यांच्यासाठी प्रायश्चित कर. कारण. परमेश्वराचा कोप भडकला आहे; मरी सुरू झाली आहे. ");
INSERT INTO mar_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","म्हणून अहरोनाने मोशेने जे सांगितले ते केले. अहरोनाने अग्नी व धूप घेतला आणि मग तो मंडळीमध्ये धावत गेला. परंतु लोकात मरीची लागण झाली होती आणि त्याने धूप घालून लोकांसाठी प्रायश्चित केले. ");
INSERT INTO mar_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","अहरोन मरण पावलेल्या आणि अजून जिवंत असलेल्या लोकांच्या मध्ये जाऊन उभा राहिला, अहरोनाने लोकांस पवित्र करण्यासाठी प्रायश्चित केले आणि मरी तिथेच थांबली. ");
INSERT INTO mar_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","पण त्या मरीमुळे चौदा हजार सातशे लोक मरण पावले. यामध्ये कोरहामुळे मृत्यूमुखी पडलेल्यांचा समावेश नाही. ");
INSERT INTO mar_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","भयानक मरी थांबली आणि अहरोन परत दर्शनमंडपाच्या दाराशी असलेल्या मोशेकडे गेला. ");
INSERT INTO mar_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","इस्राएल लोकांशी बोल. त्यांच्याकडून बारा काठ्या घे. बारा वंश प्रमुखांकडून प्रत्येकी एक काठी घे. प्रत्येक मनुष्याचे नाव त्यांच्या त्यांच्या काठीवर लिही. ");
INSERT INTO mar_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","“लेवीच्या काठीवर अहरोनाचे नाव लिही. प्रत्येक वंश प्रमुखासाठी एकेक काठी असलीच पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","या काठ्या दर्शनमंडपामध्ये आज्ञापटाचा कोशाच्या वेदीजवळ ठेव. हीच मी तुला भेटण्याची जागा आहे. ");
INSERT INTO mar_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","खरा याजक म्हणून मी एका मनुष्याची निवड करीन. मी कोणाची निवड केली ते तुला कळेल कारण त्याच्या काठीला पालवी फुटायला लागेल. याप्रमाणे मी इस्राएली तुझ्या आणि माझ्याविरूद्ध तक्रारी करतात ते बंद पाडीन.” ");
INSERT INTO mar_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","म्हणून मोशे इस्राएलाच्या लोकांशी बोलला. प्रत्येक वंश प्रमुखाने त्यास काठी दिली. त्या बारा काठ्या होत्या. प्रत्येक वंश प्रमुखाकडून एकेक काठी आली. एक काठी अहरोनाची होती. ");
INSERT INTO mar_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मोशेने त्या काठ्या साक्षपटाच्या तंबूत परमेश्वरासमोर ठेवल्या. ");
INSERT INTO mar_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","दुसऱ्या दिवशी मोशे साक्षपटाच्या तंबूत गेला. लेवी वंशाकडून आलेल्या अहरोनाच्या काठीला पाने फुटली असल्याचे त्यास दिसले. त्या काठीला फांद्याही फुटल्या होत्या आणि बदामही लागले होते. ");
INSERT INTO mar_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","म्हणून मोशेने परमेश्वराच्या जागेतून सगळ्या काठ्या आणल्या. मोशेने त्या काठ्या इस्राएल लोकांस दाखवल्या. त्या सर्वांनी काठ्यांकडे पाहिले आणि प्रत्येकाने आपली काठी परत घेतली. ");
INSERT INTO mar_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","नंतर परमेश्वर मोशेला म्हणाला, अहरोनाची काठी परत मंडपात आज्ञापटाचा कोशाजवळ ठेव. जे लोक नेहमी माझ्याविरूद्ध बंड करतात त्यांच्यासाठी ही अपराधाची खूण असेल. माझ्याविरूद्ध तक्रारी करणे ती यामुळे बंद होईल म्हणजे ते मरायचे नाहीत. ");
INSERT INTO mar_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","मोशेने परमेश्वराच्या आज्ञेप्रमाणे केले. ");
INSERT INTO mar_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","इस्राएलाचे लोक मोशेला म्हणाले, “आम्ही मरणार आहोत हे आम्हास माहित आहे आम्ही हरलो आहोत. आमचा सगळ्यांचा नाश होणार आहे. ");
INSERT INTO mar_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","जो कोणी मनुष्य नुसता परमेश्वराच्या निवासमंडपाजवळ जाईल तो मरेल. आम्हा सर्वाचा नाश होणार की काय?” ");
INSERT INTO mar_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","परमेश्वर अहरोनास म्हणाला, या पवित्र स्थानासंबंधीचा दोष तुला व तुझ्या मुलांना आणि तुझ्याबरोबरच्या तुझ्या घराण्यास वाहावा लागेल. त्याच प्रमाणे याजक पदासंबंधीचा दोष तुला व तुझ्याबरोबर तुझ्या मुलांना वाहवा लागेल. ");
INSERT INTO mar_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","तुझ्या वंशातील इतर लेवी लोकांस आण. तुझ्याबरोबर आणि साक्षपटाच्या तंबूत काम करण्यासाठी ते तुला आणि तुझ्या मुलांना मदत करतील. ");
INSERT INTO mar_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","लेवी वंशातील लोक तुझ्या सत्तेखाली आहेत. मंडपात जे जे काम करायचे आहे ते ते लोक करतील. परंतु त्यांनी पवित्र स्थानाजवळ आणि वेदीजवळ जाता काम नये. जर ते गेले तर ते मरतील आणि तू सुद्धा मरशील. ");
INSERT INTO mar_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ते तुझ्याबरोबर असतील आणि तुला मदत करतील. ते दर्शनमंडपाची काळजी घ्यायला जबाबदार असतील. मंडपात जे काही काम करायचे असेल ते सर्व ते करतील. तू जेथे असशील तेथे दुसरा कोणीही येऊ नये. ");
INSERT INTO mar_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","पवित्र जागेची आणि वेदीची काळजी घेण्याची जबाबदारी तुझ्यावर आहे. इस्राएल लोकांवर मला पुन्हा रागवायचे नाही. ");
INSERT INTO mar_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","इस्राएल मधल्या सर्व लोकांतून मीच लेवी वंशाच्या लोकांस निवडले. ते तुझ्यासाठी एक भेट आहे. त्या लोकांस मी तुला दिले. ते परमेश्वराची सेवा करतील आणि दर्शनमंडपामध्ये काम करतील. ");
INSERT INTO mar_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","पण अहरोन फक्त तू आणि तुझ्या मुलांनीच याजकाचे काम केले पाहिजे. वेदीजवळ फक्त तुम्हीच जाऊ शकता. पवित्रस्थानाच्या पडद्याआड फक्त तुम्हीच जाऊ शकता. मी तुला एक भेट देत आहे याजक म्हणून तू करावयाची सेवा. माझ्या पवित्र स्थानाजवळ दुसरा कोणी आला तर त्यास मारुन टाकले जाईल. ");
INSERT INTO mar_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","नंतर परमेश्वर अहरोनास म्हणाला, पाहा मला केलेली समर्पणे इस्राएलाच्या ज्या पवित्र भेटी मला देतात त्या सर्व मी तुला दिल्या आहेत. तू आणि तुझी मुले त्या वाटून घेऊ शकता. तो नेहमीच तुमचा हक्क होय. ");
INSERT INTO mar_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","लोक होमार्पण, अन्नार्पण, पापार्पणे आणि अपराधासाठी करावयाची अर्पणे इत्यादी बऱ्याच गोष्टी आणतील. ती अर्पणे पवित्र आहेत. सर्वात पवित्र अर्पणातला जळलेला भाग तुझा असेल. त्या सगळ्या गोष्टी फक्त तुझ्यासाठी आणि तुझ्या मुलांसाठी असतील. ");
INSERT INTO mar_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","त्या गोष्टी फक्त पवित्र जागेतच खा. तुझ्या कुटुंबातला प्रत्येक पुरुष ते खाऊ शकतो. पण ती अर्पणे पवित्र आहेत हे तू लक्षात ठेव. ");
INSERT INTO mar_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","आणि इस्राएलचे लोक ओवाळणीची अर्पणे म्हणून जी अर्पणे देतील ती सुद्धा तुझीच असतील. मी ती तुला, तुझ्या मुलांना आणि मुलींना देत आहे. तुझ्या घरातल्या शुद्ध असलेल्या सर्व मनुष्यांनी ती खावी. ");
INSERT INTO mar_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","आणि मी तुला सर्वात चांगले जैतूनाचे तेल. नवीन द्राक्षरस आणि धान्य देत आहे. या गोष्टी इस्राएलचे लोक मला परमेश्वरास देतात. कापणीच्या वेळी या गोष्टी ते प्रथम गोळा करतात. ");
INSERT INTO mar_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","लोक जेव्हा कापणीच्या वेळी धान्य गोळा करतात तेव्हा प्रथम गोळा केलेले धान्य ते परमेश्वराकडे आणतात. म्हणून मी या गोष्टी तुला देतो आणि तुझ्या कुटुंबातील शुद्ध माणसे ते खाऊ शकतात. ");
INSERT INTO mar_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","इस्राएलात अर्पिलेले सर्व तुझे होईल. ");
INSERT INTO mar_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","स्त्रीचे पहिले मूल आणि जनावराचे पहिले पाडस परमेश्वरास अर्पण केलेच पाहिजे. ते मूल तुझे असेल. जन्माला आलेले पहिले पाडस जर अशुद्ध असेल तर ते परत मागे विकत घेतले पाहिजे. जर ते मूल असेल तर ते परत मागे विकत घेतले पाहिजे. ते मूल परत त्या कुटुंबाचे होईल. ");
INSERT INTO mar_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ज्यांना खंडणी भरून सोडवायचे ते मूल एक महिन्याचे झाल्यानंतर तुझ्या ठरावाप्रमाणे पवित्रस्थानाच्या शेकेलाच्या चलनाप्रमाणे पाच शेकेल रुपे म्हणजे वीस गेरा घेऊन त्यांना सोडून द्यावे. ");
INSERT INTO mar_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","परंतु तू गाईचे प्रथम जन्मलेले, मेंढीचे प्रथम जन्मलेले आणि बकरीचे प्रथम जन्मलेले यांची खंडणी भरून सोडू नकोस. ते प्राणी पवित्र आहेत, ते माझ्यासाठी राखीव आहेत. त्यांचे रक्त वेदीवर शिंपड आणि त्यांची चरबी जाळून टाक. ही अग्नीत दिलेली अर्पणे आहेत. त्यांचा सुवास परमेश्वरास संतोष देतो. ");
INSERT INTO mar_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","पण या प्राण्यांचे मांस तुझे असेल. ओवाळणीचा ऊर तुझा असेल आणि इतर अर्पणातली उजवी मांडी तुझीच असेल. ");
INSERT INTO mar_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“इस्राएली लोक ज्या पवित्र गोष्टी मला अर्पण करतात त्या मी परमेश्वर तुला देतो. तो तुझा वाटा आहे. मी तो तुला, तुझ्या मुलांना व मुलींना देत आहे. हा नियम सदैव अस्तित्वात राहील. तो परमेश्वराबरोबर केलेला निरंतरचा मिठाचा करार आहे. तो मोडता येणार नाही. मी तुला आणि तुझ्या वंशजांना असे वचन देतो.” ");
INSERT INTO mar_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","परमेश्वर अहरोनाला आणखी म्हणाला, तुला जमीनीपैकी काहीही वतन मिळणार नाही आणि जे दुसऱ्या लोकांचे आहे ते तुला मिळणार नाही. मी परमेश्वर तुझा हिस्सा आहे. इस्राएल लोकांमध्ये मीच तुझा वाटा व वतन आहे. ");
INSERT INTO mar_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","लेवीचे वंशज दर्शनमंडपाची सेवा करतात तिच्याबद्दल इस्राएल लोकांकडून जे सर्व दशमांश येतात तेच वतन म्हणून त्यांना मी नेमून दिले आहे. ");
INSERT INTO mar_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","यापुढे इस्राएल लोकांनी कधीही दर्शनमंडपाजवळ जाता कामा नये. ते जर गेले त्यांना पाप लागेल व ते मरतील. ");
INSERT INTO mar_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","लेवीचे जे वंशज दर्शनमंडपामध्ये काम करतात ते त्याच्याविरुध्द केलेल्या पापाला जबाबदार असतील. हा नियम नेहमी अस्तीत्वात राहील. लेव्यांना इस्राएल लोकांमध्ये वतन नसावे. ");
INSERT INTO mar_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","परंतु इस्राएल लोक जे समर्पित अंश म्हणून परमेश्वरास अर्पण करतात ते लेव्याची वतनभाग म्हणून मी त्यांना नेमून दिले आहेत म्हणूनच मी लेवी लोकांबद्दल असे बोललो, इस्राएल लोकांमध्ये त्यांना वतन मिळावयाचे नाही. ");
INSERT INTO mar_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","परमेश्वर मोशेशी बोलला व म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","तू लेवी लोकांशी बोल आणि त्यांना सांग: इस्राएल लोकांचे जे दशमांश तुमचे वतन म्हणून तुम्हास नेमून दिले आहेत, तो दहावा भाग लेवी लोकांचा असेल. पण त्याचा दहावा भाग तू परमेश्वरास अर्पण केला पाहिजेस. ");
INSERT INTO mar_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","हा तुमचा समर्पित अंश खळ्यातल्या धान्यासारखा व रसकुंडातल्या द्राक्षरसासारखा तुमच्या हिशोबी गणिला जाईल. ");
INSERT INTO mar_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","याप्रमाणे तू सुद्धा इस्राएलाचे लोक देतात तशी परमेश्वरास अर्पणे देशील. इस्राएलचे लोक परमेश्वरास जे देतात त्याच्या दहावा भाग ते तुला देतील आणि त्यातला दहावा भाग तू याजक अहरोनाला देशील. ");
INSERT INTO mar_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","इस्राएलचे लोक जेव्हा त्यांच्याकडे असलेल्या गोष्टीतील दहावा भाग तुला देतील तेव्हा तू त्यातला सर्वात चांगला आणि पवित्र भाग निवडायला पाहिजेस आणि तो दहावा भाग तू परमेश्वरास अर्पण केला पाहिजेस. ");
INSERT INTO mar_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“मोशे लेवी लोकांस सांग, तुम्ही त्यातून जे उत्तम त्याची उचलणी करता तेव्हा ते लेव्यांकडे, खळ्यातले उत्पन्न आणि द्राक्षरसाच्या कुंडातले उत्पन्न यासारखे मोजले जाईल. ");
INSERT INTO mar_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","उरलेले तुम्ही आणि तुमचे कुटुंबीय ह्यानी खावा. तुम्ही दर्शनमंडपामध्ये जे काम करता त्याबद्दलची ही मजुरी आहे. ");
INSERT INTO mar_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","आणि जर तुम्ही सर्वांत चांगला भाग समर्पित अंश म्हणून अर्पण केल्यामुळे तुम्हास पाप लागणार नाही. इस्राएल लोकांच्या पवित्र वस्तू भ्रष्ट करू नये म्हणजे तुम्ही मरणार नाही.” ");
INSERT INTO mar_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","परमेश्वर मोशेशी आणि अहरोनाशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","परमेश्वराने इस्राएल लोकांस जी शिकवण दिली तिचे हे नियम आहेत. निर्दोष व अव्यंग आणि जिच्यावर अद्याप जू ठेवलेले नाही अशी एक लाल कालवड घ्या. ");
INSERT INTO mar_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ती याजक एलाजाराला द्यावी. त्याने तिला छावणीबाहेर न्यावे आणि तिथे कोणा एकाने तिला त्याच्यासमोर मारावे. ");
INSERT INTO mar_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","नंतर एलाजार, हा याजक थोडे रक्त आपल्या बोटावर घेईल आणि काही रक्त दर्शनमंडपाकडे शिंपडेल. त्याने असे सात वेळा केले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","नंतर संपूर्ण कालवड त्याच्यासमोर जाळून, कातडी, मांस रक्त आणि आतडे सर्वकाही जाळले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","नंतर याजकाने गंधसरूची एक काठी, एजोबाची फांदी व लाल दोरी घ्यावी. याजकाने या गोष्टी कालवड जळत असलेल्या जाळात फेकाव्या. ");
INSERT INTO mar_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","याजकाने स्वत:ला आणि त्याच्या कपड्यांना स्वच्छ पाण्याने धुवावे. आणि मगच छावणीत परत यावे. याजक संध्याकाळपर्यंत अशुद्ध असेल. ");
INSERT INTO mar_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ज्या मनुष्याने कालवडीला जाळले असेल त्याने स्वत:ला धुवावे. स्वत:चे कपडेही पाण्याने स्वच्छ धुवावे. तो संध्याकाळपर्यंत अशुद्ध असेल. ");
INSERT INTO mar_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","नंतर जो मनुष्य शुद्ध असेल तो कालवडीची राख गोळा करेल. तो ती राख छावणीच्या बाहेर स्वच्छ जागी ठेवावी आणि ती इस्राएल वंशाच्या मंडळीकरता अशुद्धी दूर करण्याच्या पाण्यासाठी ती राखून ठेवावी, ती पापार्पण अशी आहे. ");
INSERT INTO mar_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ज्या मनुष्याने कालवडीची राख गोळा केली असेल त्याने त्याचे कपडे धुवावे. तो संध्याकाळपर्यंत अशुद्ध राहील. हे नियम नेहमी अस्तित्वात असतील. हा नियम इस्राएलच्या सर्व नागरिकांसाठी आहे आणि तुमच्याबरोबर जे परदेशी लोक राहत आहेत त्यांच्यासाठीही हा नियम आहे. ");
INSERT INTO mar_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","जर एखाद्याने प्रेताला हात लावला तर तो सात दिवस अशुद्ध राहील. ");
INSERT INTO mar_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","त्याने स्वत:ला तिसऱ्या दिवशी ती राख घेऊन आपणास शुद्ध करावे व नंतर सातव्या दिवशी तो शुद्ध होईल, पण जर तो तिसऱ्या दिवशी आपणास शुद्ध करणार नाहीतर तो सातव्या दिवशी तो शुद्ध होणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","जर एखाद्याने प्रेताला हात लावला तर तो अशुद्ध होईल. जर मनुष्य अशुद्ध असताना परमेश्वराच्या पवित्र निवास मंडपात गेला तर मंडपही अशुद्ध होईल. म्हणून त्या मनुष्यास इस्राएल लोकांपासून दूर ठेवावे. जर अशुद्ध मनुष्यावर खास पाणी शिंपडले नाहीतर तो अशुद्ध राहील. ");
INSERT INTO mar_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","जे लोक त्यांच्या मंडपात मरतात त्यांच्यासाठी हा कायदा आहे. जर एखादा मनुष्य त्याच्या मंडपात मेला तर त्या मंडपातले सगळे लोक आणि सगळ्या वस्तू अशुद्ध होतील. ते सात दिवस अशुद्ध राहतील. ");
INSERT INTO mar_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","आणि ज्यावर झाकण बांधले नाही असे प्रत्येक उघडे भांडे अशुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","खुल्या मैदानात तलवारीने वधलेल्या जर एखाद्याने प्रेताला हात लावला तर तो सात दिवस अशुद्ध राहील. जर ते प्रेत बाहेर उघड्यावर असेल किंवा तो मनुष्य युद्धात मारला गेला असेल तरच हे लागू आहे. आणि जर एखाद्याने मरण पावलेल्या मनुष्याच्या अस्थींना हात लावला तरी तो मनुष्य सात दिवस अशुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","त्या अशुद्ध मनुष्यास पुन्हा स्वच्छ करण्यासाठी जाळलेल्या कालवडीची राख तुम्ही वापरली पाहिजे. एखाद्या भांड्यात राखेवर ताजे पाणी टाका. ");
INSERT INTO mar_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","शुद्ध मनुष्याने एजोबाची काठी घेऊन ती पाण्यात बुडवावी. नंतर ते पाणी तंबूवर, भांड्यावर आणि मंडपातल्या मनुष्यांवर शिंपडावे. जो प्रेताला हात लावली त्याच्या बाबतीत हे करावे. तुम्ही हे प्रत्येकाला करा. जो युद्धात कबरेला हात लावील किंवा मरण पावलेल्या मनुष्याच्या हाडांना हात लावील त्याच्या बाबतीत हे करा. ");
INSERT INTO mar_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","नंतर शुद्ध मनुष्याने हे पाणी तिसऱ्या व सातव्या दिवशी अशुद्ध मनुष्याच्या अंगावर शिंपडावे. तो मनुष्य सातव्या दिवशी शुद्ध होईल. त्याने त्याचे कपडे पाण्यात धुवावे. तो संध्याकाळी शुद्ध होईल. ");
INSERT INTO mar_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","एखादा मनुष्य अशुद्ध झाल्यानंतर पुन्हा शुद्ध झाला नाहीतर त्यास इस्राएल लोकांपासून वेगळे ठेवावे. कारण त्याने परमेश्वराचे पवित्र निवास मंडपही अशुद्ध करील. ");
INSERT INTO mar_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","तुमच्यासाठी हा नियम सदैव असेल. ज्या मनुष्यावर पाणी शिंपडले त्या मनुष्याने स्वत:चे कपडे सुद्धा धुतले पाहिजेत. कोणत्याही मनुष्याने त्या खास पाण्याला स्वर्श केला तर तो संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO mar_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","जर त्या अशुद्ध मनुष्याने दुसऱ्या कोणाला स्पर्श केला तर तो मनुष्य सुद्धा अशुद्ध होईल. तो मनुष्य संध्याकाळपर्यंत अशुद्ध राहील. ");
INSERT INTO mar_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","इस्राएलाचे लोक सीनच्या वाळवंटात पहिल्या महिन्यात आले. त्यांनी कादेशला मुक्काम केला. मिर्याम तेथे मरण पावली आणि तिला तेथेच पुरण्यात आले. ");
INSERT INTO mar_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","त्याठिकाणी लोकांस पुरेसे पाणी नव्हते. म्हणून ते मोशे आणि अहरोनाजवळ तक्रार करण्यासाठी एकत्र आले. ");
INSERT INTO mar_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","लोकांनी मोशेशी वाद घातला. ते म्हणाले, आमचे भाऊबंद जसे परमेश्वरासमोर मरण पावले तसेच आम्ही मरायला पाहिजे होते. ");
INSERT INTO mar_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","“तू परमेश्वराच्या लोकांस या रानात का आणलेस? आम्ही आणि आमची जनावरे इथे मरावी असे तुला वाटते का? ");
INSERT INTO mar_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","तू आम्हास मिसर देशातून का आणलेस? तू आम्हास या वाईट ठिकाणी का आणलेस? इथे धान्य नाही. इथे अंजीर, द्राक्षे किंवा डाळिंबही नाहीत आणि इथे पिण्यास पाणीही नाही.” ");
INSERT INTO mar_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","म्हणून मोशे आणि अहरोन लोकांची गर्दी सोडून दर्शनमंडपाच्या प्रवेशद्वाराशी गेले. त्यांनी जमिनीपर्यंत लवून नमस्कार केला आणि त्यांना परमेश्वराचे तेज दिसले. ");
INSERT INTO mar_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","परमेश्वर मोशेशी बोलला आणि म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","तुझी काठी घे. तुझा भाऊ अहरोन याला आणि त्या लोकांस बरोबर घे आणि खडकाजवळ जा. लोकांसमोर खडकाशी बोल. नंतर त्या खडकातून पाणी वाहू लागेल आणि तू ते पाणी त्या लोकांस आणि त्यांच्या जनावराना देऊ शकशील. ");
INSERT INTO mar_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","मोशेला आज्ञा केल्याप्रमाणे परमेश्वरापुढून त्याने काठी घेतली. ");
INSERT INTO mar_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","मोशे आणि अहरोन यांनी लोकांस त्या खडकासमोर भेटायला सांगितले. नंतर मोशे म्हणाला, अहो, तुम्ही बंडखोरांनो ऐका. तुम्हासाठी आम्ही या खडकातून पाणी काढावयाचे काय? ");
INSERT INTO mar_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","मोशेने आपला हात वर उचलला आणि काठीने खडकावर दोन वार केले. खडकातून पाणी बाहेर वाहू लागले आणि माणसे व जनावरे ते पाणी पिऊ लागली. ");
INSERT INTO mar_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","पण परमेश्वर मोशेला आणि अहरोनाला म्हणाला, तुम्ही माझ्यावर विश्वास ठेवला नाही. इस्राएली लोकांपुढे तुम्ही माझे पावित्र्य राखले नाही. मी वचन दिल्याप्रमाणे या मंडळीला जो देश दिला आहे ह्याना त्या देशात तुम्ही त्यांना तिथे घेऊन जाणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","त्या जागेला मरीबा असे नांव पडले. इस्राएल लोकांनी परमेश्वराबरोबर जिथे वाद घातला तीच ती जागा होती. याच जागेवर परमेश्वराने त्यांना तो किती पवित्र आहे ते दाखवले होते. ");
INSERT INTO mar_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","मोशे कादेशला होता तेव्हा त्याने अदोमाच्या राजाकडे काही लोकांस एक निरोप देऊन पाठवले. तो निरोप होता, तुझे भाऊ, इस्राएलचे लोक तुला म्हणतात, आमच्यावर जी जी संकटे आली त्याबद्दल तुला माहिती आहेच. ");
INSERT INTO mar_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","खूप वर्षापूर्वी आमचे पूर्वज मिसर देशात गेले. आणि तिथे आम्ही अनेक वर्षे राहिलो. मिसर देशाचे लोक आमच्याशी फार दुष्टपणे वागले. ");
INSERT INTO mar_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","पण आम्ही परमेश्वराकडे आरोळी केली. त्याने आमची वाणी ऐकली आणि आमच्या मदतीसाठी देवदूताला पाठवले आणि आम्हास मिसर देशातून बाहेर आणले. तर आता पाहा आम्ही तुझ्या देशाच्या सीमेच्या अगदी शेवटास असलेल्या कादेशमध्ये आलो आहोत. ");
INSERT INTO mar_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","कृपाकरून आम्हास तुझ्या प्रदेशातून जाऊ दे. आम्ही कोठल्याही शेतातून वा द्राक्षाच्या मळ्यातून जाणार नाही. आम्ही तुझ्या विहिरीचे पाणी पिणार नाही. आम्ही राजरस्त्यांच्या बाजूने फक्त जाऊ. आम्ही रस्ता सोडून डावीकडे अथवा उजवीकडे वळणार नाही. तुझ्या देशातून बाहेर येईपर्यंत आम्ही रस्त्यावरच राहू. ");
INSERT INTO mar_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","परंतु अदोमाच्या राजाने उत्तर दिले, तुम्ही आमच्या देशातून जाणार नाही. जर तुम्ही आमच्या देशातून जायचा प्रयत्न केला तर आम्ही येऊन तुमच्याशी तलवारीने युद्ध करु. ");
INSERT INTO mar_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","इस्राएल लोकांनी उत्तर दिले, आम्ही मुख्य रस्त्यावरुन जाऊ. जर आमची जनावरे तुमचे पाणी प्यायले तर आम्ही तुम्हास त्याचा मोबदला देऊ. आम्हास फक्त तुमच्या देशातून जायचे आहे. आम्हास तो प्रदेश आमच्यासाठी घ्यायची इच्छा नाही. ");
INSERT INTO mar_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","पण अदोमाने पुन्हा उत्तर दिले, आम्ही तुम्हास आमच्या देशातून जाण्याची परवानगी देणार नाही. नंतर अदोमाच्या राजाने मोठी आणि शक्तीशाली सेना गोळा केली आणि तो इस्राएल लोकांशी लढावयास गेला. ");
INSERT INTO mar_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","अदोमाच्या राजाने इस्राएल लोकांस त्याच्या देशातून जाण्याची परवानगी दिली नाही. आणि इस्राएलाचे लोक तोंड फिरवून दुसऱ्या रस्त्याने निघून गेले. ");
INSERT INTO mar_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","इस्राएलाचे सर्व लोक कादेशहून होर पर्वताकडे गेले. ");
INSERT INTO mar_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","होर पर्वत अदोमाच्या सरहद्दीजवळ होता. परमेश्वर मोशेला आणि अहरोनाला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","अहरोन आता आपल्या पूर्वजांस जाऊन मिळेल. मी इस्राएल लोकांस ज्या प्रदेशात नेण्याचे वचन दिले होते त्यामध्ये त्याचा प्रवेश होणार नाही. कारण तुम्ही मी मरीबाच्या पाण्याजवळ दिलेल्या आज्ञांचे उल्लघन करून बंड केले. ");
INSERT INTO mar_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","आता अहरोनाला आणि त्याचा मुलगा एलाजार यांना घेऊन होर पर्वतावर जा. ");
INSERT INTO mar_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","अहरोनाचे खास कपडे त्याच्याकडून घे आणि ते कपडे त्याचा मुलगा एलाजार याला घाल. अहरोन तिथे त्याच्या पूर्वजांकडे जाईल व मरेल. ");
INSERT INTO mar_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","मोशेने परमेश्वराची आज्ञा पाळली. मोशे, अहरोन आणि एलाजार होर पर्वतावर गेले. इस्राएलाच्या सर्व लोकांनी त्यांना जाताना पाहिले. ");
INSERT INTO mar_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मोशेने अहरोनाचे खास कपडे काढले व ते एलाजाराला घातले. नंतर अहरोन पर्वतावर मरण पावला. मोशे आणि एलाजार पर्वतावरुन खाली आले. ");
INSERT INTO mar_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","इस्राएलाच्या सर्व लोकांस अहरोन मरण पावला हे कळले. म्हणून त्यांनी तीस दिवस दुखवटा पाळला. ");
INSERT INTO mar_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","अरादाचा कनानी राजा नेगेबमध्ये राहत होता. इस्राएल लोक अथारीम वरून जात आहेत हे त्याने ऐकले. म्हणून राजा त्यांच्यावर हल्ला करण्यासाठी बाहेर पडला आणि त्याने त्यांच्यातील काही लोकांस कैद केले. ");
INSERT INTO mar_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","नंतर इस्राएल लोकांनी परमेश्वरास खास वचन दिले, परमेश्वरा या लोकांचा पराभव करायला आम्हास मदत कर. जर तू हे केले तर आम्ही तुला त्यांची शहरे देऊ. आम्ही त्यांचा संपूर्ण नाश करु. ");
INSERT INTO mar_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","परमेश्वराने इस्राएल लोकांचे म्हणणे ऐकले आणि त्याने इस्राएल लोकांस कनानी लोकांचा पराभव करायला मदत केली. इस्राएल लोकांनी कनानी लोकांचा व त्यांच्या शहरांचा संपूर्ण नाश केला. म्हणून त्या प्रदेशाला हर्मा असे नाव पडले. ");
INSERT INTO mar_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","इस्राएल लोकांनी होर पर्वत सोडला व ते तांबड्या समुद्राकडे जाणाऱ्या रस्त्याला लागले. अदोम देशाला वळसा घालून जाण्यासाठी त्यांनी असे केले. परंतु लोक अधीर झाले. ");
INSERT INTO mar_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","त्यांनी मोशेविरूद्ध व देवाविरूद्ध तक्रार करायला सुरुवात केली. लोक म्हणाले, तू आम्हास या रानात मरण्यासाठी मिसर देशातून बाहेर का आणलेस? इथे भाकरी नाही, पाणी नाही आणि या हलक्या अन्नाला आम्ही कंटाळलो आहोत. ");
INSERT INTO mar_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","तेव्हा परमेश्वराने लोकांमध्ये विषारी साप सोडले. साप लोकांस चावले आणि बरेच इस्राएल लोक मरण पावले. ");
INSERT INTO mar_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","लोक मोशेकडे आले आणि म्हणाले, आम्ही तुझ्याविरूद्ध आणि परमेश्वराविरूद्ध बोललो तेव्हा आम्ही पाप केले हे आम्हास माहीत आहे. तू परमेश्वराची प्रार्थना कर. हे साप आमच्या मधून काढून टाक. तेव्हा मोशेने लोकांसाठी परमेश्वराची प्रार्थना केली. ");
INSERT INTO mar_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","परमेश्वर मोशेला म्हणाला, एक पितळेचा साप कर आणि तो खांबावर ठेव. साप चावल्यानंतर जर एखाद्याने खांबावरच्या पितळेच्या सापाकडे पाहिले तर तो मनुष्य मरणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","मोशेने परमेश्वराची आज्ञा पाळली त्याने पितळेचा साप बनवला व तो खांबावर ठेवला. नंतर जेव्हा जेव्हा एखाद्या साप चावलेल्या मनुष्याने त्या खांबावरच्या पितळेच्या सापाकडे पाहिले तेव्हा तो जिवंत राहिला. ");
INSERT INTO mar_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","इस्राएल लोक तो प्रदेश सोडून ओबोथ येथे आले. ");
INSERT INTO mar_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","नंतर ओबोथ सोडून त्यांनी ईये-अबारीमाला मवाबाच्या पूर्वेकडे रानात तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","तो सोडून ते जेरेद खोऱ्यात आले व तिथे तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ते तेथूनही निघाले आणि आर्णोन नदीत्या पैलतीरावरच्या वाळवंटात त्यांनी तळ दिला. या नदीचा उगम आमोऱ्याच्या सरहद्दीवर आहे. या नदीचे खोरे हीच मवाब आणि अमोरी यांची सरहद्द होती. ");
INSERT INTO mar_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","म्हणून परमेश्वराचे युद्ध या पुस्तकात पुढील शब्द लिहिले आहेत, सुफातला वाहेब व आर्णोनाची खोरी, ");
INSERT INTO mar_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","त्या खोऱ्याची उतरण आर शहराकडे वळते, आणि मवाबाच्या सरहद्दीपर्यंत खाली जाते. ");
INSERT INTO mar_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","तेथपासून ते बैर येथे प्रवास करीत गेले. ज्या विहिरीविषयी परमेश्वराने मोशेला सांगितले होते तीच ही विहिर आहे, “माझ्यासाठी लोकांस एकत्र जमव म्हणजे मी त्यांना पाणी देईन.” ");
INSERT INTO mar_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","नंतर इस्राएली हे गाणे गाइलेः विहिर, उसळून ये. त्या संबंधी गाणे गा. ");
INSERT INTO mar_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","आमच्या सरदारांनी विहीर खणली, सरदारांनी ही विहीर खणली. त्यांच्या राजदंडानी व आपल्या काठ्यांनी विहीर खणली, मग त्यांनी अरण्यापासून ते मत्तानापर्यंत प्रवास केला. ");
INSERT INTO mar_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","लोक मत्तानाहून नाहालीयेलला गेले. नंतर ते नाहीलयेलासहून बामोथाला गेले. ");
INSERT INTO mar_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","लोक बामोथाहून मवाबाच्या खोऱ्यात गेले. या जागी पिसगा पर्वताच्या उंच माथा वाळवंटाकडे जातो. पिसगा पर्वताच्या उंच माथ्यावरुन वाळवंट दिसते. ");
INSERT INTO mar_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","इस्राएल लोकांनी काही माणसे अमोऱ्याचा राजा सीहोन याच्याकडे पाठवली. ते राजास म्हणाले, ");
INSERT INTO mar_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“आम्हास तुमच्या देशातून जाण्याची परवानगी द्या. आम्ही कोणत्याही शेतातून वा द्राक्षाच्या मळयातून जाणार नाही. आम्ही तुमच्या कोणत्याही विहिरीचे पाणी पिणार नाही. आम्ही केवळ राजामार्गवरुनच जाऊ.” ");
INSERT INTO mar_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","पण सीहोन राजाने इस्राएल लोकांस त्याच्या देशातून जाण्याची परवानगी दिली नाही. राजाने आपले सैन्य गोळा केले आणि तो रानाकडे कूच करीत निघाला. तो इस्राएल लोकांबरोबर युद्ध करण्यासाठी निघाला होता. याहसला राजाच्या सैन्याने इस्राएल लोकांशी युद्ध केले. ");
INSERT INTO mar_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","पण इस्राएलानी त्याच्यावर तलवार चालविली. नंतर त्यांनी आर्णोन आणि यब्बोक नद्यांच्या मधला प्रदेश घेतला. त्यांनी अम्मोनी लोकांच्या सरहद्दीपर्यंतचा प्रदेश घेतला, ते त्या सरहद्दीवर थांबले कारण अम्मोनी लोक तिचे रक्षण करीत होते. ");
INSERT INTO mar_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","इस्राएल लोकांनी सगळी अमोऱ्यांची शहरे घेतली आणि तिथे रहायला सुरुवात केली. त्यांनी हेशबोन शहराचा व आजूबाजूच्या लहान शहरांचाही पराभव केला. ");
INSERT INTO mar_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेशबोनामध्ये अमोऱ्यांचा राजा सीहोन राहत होता. पूर्वी सीहोनाने मवाबाच्या राजाशी युद्ध केले होते. सीहोनाने आर्णोन नदीपर्यंतचा प्रदेश घेतला होता. ");
INSERT INTO mar_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","यावरुन ते म्हणीमध्ये बोलतात; ते म्हणतात, हेशबोनाला या. पुन्हा सीहोनाचे शहर बांधू द्या, त्याची स्थापना होऊ द्या. ");
INSERT INTO mar_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","हेशबोनामधून आग निघाली आहे, ज्वाला सीहोनाच्या शहरातून निघाली आहे. त्या आगीत मवाबामधले आर शहर बेचीराख झाले. आणि आर्णोनेच्या गढ्याचे स्वामी भस्म करून टाकले आहेत. ");
INSERT INTO mar_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","हे मवाबा! तू हायहाय करशील, कमोशाचे लोक नष्ट झाले. त्याची मुले पळून गेली. त्याच्या मुलींना अमोऱ्याचा राजा सीहोन याने कैद करून पकडून नेले. ");
INSERT INTO mar_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","पण आम्ही सीहोन जिंकले आहे. दीबोनापर्यंत हेशबोन सर्व नष्ट झाले आहे. आम्ही नोफा जे मेदबाजवळ पोहचते तेथपर्यंत त्यांचा सर्व पराभव केला आहे. ");
INSERT INTO mar_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","याप्रमाणे इस्राएल लोक अमोऱ्यांच्या देशात राहू लागले. ");
INSERT INTO mar_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","मग मोशेने याजेर शहर बघण्यासाठी काही लोकांस पाठवले. त्यांनी त्यातली गावे हस्तगत करून घेतली आणि जे अमोरी लोक तेथे होते त्यांना घालवून दिले. ");
INSERT INTO mar_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","नंतर इस्राएल लोक बाशानाच्या रस्त्याला लागले. बाशानाचा राजा ओग याने त्याचे सैन्य घेतले व तो इस्राएल लोकांशी लढावयास निघाला. तो त्यांच्याबरोबर एद्रई येथे लढला. ");
INSERT INTO mar_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","तेव्हा परमेश्वर मोशेला म्हणाला, “त्याला भिऊ नकोस. कारण मी तुला त्याच्यावर, त्याच्या सर्व सैन्यावर आणि त्याच्या देशावर विजय दिला आहे. तू हेशबोनमध्ये राहणाऱ्या अमोऱ्यांचा राजा सीहोन ह्याचे जे केलेस तेच याचेही कर.” ");
INSERT INTO mar_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","तेव्हा त्यांनी त्याला, त्याच्या मुलांना आणि त्याच्या सर्व सैन्याला, इतके मारले की, त्याच्या लोकांपैकी कोणी जिवंत उरला नाही. मग त्यांनी त्यांचा सर्व प्रदेश घेतला. ");
INSERT INTO mar_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","नंतर इस्राएल लोक मवाबामधल्या यार्देन नदीच्या खोऱ्याकडे निघाले. यरीहोच्या पलिकडे असलेल्या यार्देन नदीजवळ त्यांनी तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","सिप्पोराच्या मुलाने, बालाक याने इस्राएल लोकांनी अमोरी लोकांचे काय केले ते पाहिले होते. ");
INSERT INTO mar_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","मवाबाचा राजा खूप घाबरला कारण इस्राएलचे लोक खूप होते. मवाब त्यांना खरोखरच भीत होता. ");
INSERT INTO mar_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मवाबाचा राजा मिद्यानीं लोकांच्या वडीलांना म्हणाला, बैल जसा शेतातले सगळे गवत खाऊन टाकतो तसेच हे लोक आपला नाश करतील. त्यावेळी सिप्पोराचा मुलगा बालाक मवाबाचा राजा होता. ");
INSERT INTO mar_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","त्याने बौराचा मुलगा बलाम ह्याला बोलवायला काही माणसे पाठवली. बलाम फरात नदीकाठी पथोर शहरात राहत होता. इथेच बलामचे लोक राहत असत. बालाकाचा निरोप हा होता. एका नवीन राष्ट्राचे लोक मिसर देशातून आले आहेत. ते इतके आहेत की ते सगळा प्रदेश व्यापून टाकतात. त्यांनी माझ्याजवळच तळ दिला आहे. ");
INSERT INTO mar_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","तर आता ये, मी तुला विनंती करतो, तू या लोकांस माझ्यासाठी शाप दे. कारण ते माझ्यापेक्षा खूप भारी आहेत. कदाचित मी त्यांना मारावयास समर्थ होऊन देशातून घालवून टाकील. कारण मला माहीत आहे. जर तू एखाद्याला आशीर्वाद दिलास तर त्यास आशीर्वाद मिळतो. आणि जर एखाद्यास शाप दिलास तर त्यास शाप लागतो. ");
INSERT INTO mar_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","मवाबी वडील आणि मिद्यानी वडील बलामाशी बोलावयास गेले. त्याच्या कामाचा मोबदला म्हणून त्यांनी बरोबर पैसै नेले. नंतर त्यांनी बालाक काय म्हणाला ते बलामास सांगितले. ");
INSERT INTO mar_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","बलाम त्यांना म्हणाला, “रात्री इथे रहा. मी परमेश्वराशी बोलेन आणि तो काय उत्तर देतो ते तुम्हास सांगेन.” मवाबाचे पुढारी त्या रात्री बलामाबरोबर राहिले. ");
INSERT INTO mar_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","देव बलामाकडे आला आणि त्याने विचारले, “तुझ्याकडे हे कोण लोक आले आहेत?” ");
INSERT INTO mar_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बलाम देवाला म्हणाला, सिप्पोराचा मुलगा बालाकाने, मवाबाच्या राजाने यांना माझ्याकडे एक निरोप देऊन पाठवले आहे. ");
INSERT INTO mar_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","तो निरोप हा, एका नवीन राष्ट्राचे लोक मिसर देशामधून आले आहेत. ते इतके आहेत की ते सगळा प्रदेश व्यापून टाकतात. म्हणून आता तू येऊन माझ्यासाठी त्यांना शाप दे. नंतर कदाचित मी त्या लोकांचा पराभव करु शकेन आणि त्यांना माझ्या देशातून जायला भाग पाडू शकेन. ");
INSERT INTO mar_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","पण देव बलामास म्हणाला, त्यांच्याबरोबर जाऊ नकोस. तू त्या लोकांस शाप देऊ नको. कारण ते माझे आशीर्वादित लोक आहेत. ");
INSERT INTO mar_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","दुसऱ्या दिवशी बलाम उठला आणि बालाकाच्या पुढाऱ्यांना म्हणाला, तुम्ही तुमच्या देशात परत जा. परमेश्वर मला तुमच्याबरोबर जाऊ देणार नाही ");
INSERT INTO mar_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","त्यामुळे मवाबाचे पुढारी बालाककडे परत गेले आणि त्यांनी त्यास हे सांगितले. ते म्हणाले, बलामाने आमच्याबरोबर यायला नकार दिला. ");
INSERT INTO mar_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","म्हणून बालाकाने बलामाकडे दुसरे पुढारी पाठवले. यावेळी त्याने पहिल्या वेळेपेक्षा खूप जास्त पुढारी पाठवले. हे पुढारी पहिल्या पुढाऱ्यांपेक्षा अधिक महत्वाचे होते. ");
INSERT INTO mar_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ते बलामाकडे गेले आणि म्हणाले, बालाक, सिप्पोराचा मुलगा तुला हे सांगतो, तुझ्या इथे येण्याच्या आड कोठलीही गोष्ट येऊ देवू नको. ");
INSERT INTO mar_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","मी जे सांगतो ते तू केलेस तर मी तुला नक्कीच मान देईन आणि तू मला जे काही विनवशील ते मी करीन परंतु तू ये व माझ्यासाठी या लोकांस शाप दे. ");
INSERT INTO mar_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","बलामाने बालाकाच्या पुढाऱ्यांना उत्तर दिले. तो म्हणाला, परमेश्वर माझा देव ह्याच्या शब्दाबाहेर मला कमीजास्त काहीएक करता येत नाही. बालाकाने माझे घर सोन्या चांदीने भरुन दिले तरीही मी काही करणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","तरीपण रात्री तुम्ही येथे राहा आणि परमेश्वर मला काय सांगतो ते मला कळू शकेल. ");
INSERT INTO mar_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","त्या रात्री देव बलामाकडे आला. देव म्हणाला, “तुला घेऊन जाण्यासाठी हे लोक पुन्हा आले आहेत. म्हणून तू त्यांच्याबरोबर जाऊ शकतोस. पण मी जे सांगेन तेवढेच तू कर.” ");
INSERT INTO mar_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","दुसऱ्या दिवशी सकाळी बलाम उठला आणि त्याने आपल्या गाढवीवर खोगीर घातले. नंतर तो मवाबाच्या पुढाऱ्यांबरोबर चालला. ");
INSERT INTO mar_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","बलाम त्याच्या गाढवीवर बसला होता. त्याचे दोन नोकर त्याच्याबरोबर होते. बलाम प्रवास करीत होता तेव्हा देव त्याच्यावर रागावला. परमेश्वराचा दूत रस्त्यावर बलामापुढे येऊन उभा राहिला. देवदूत बलामास थांबवणार होता. ");
INSERT INTO mar_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","बलामाच्या गाढवीने परमेश्वराच्या दूताला रस्त्यात उभे असलेले पाहिले. देवदूताने हातात तलवार घेतली होती. म्हणून गाढवी रस्ता सोडून शेतात गेली. बलामास देवदूत दिसू शकला नाही. म्हणून तो गाढवीवर खूप रागावला. त्याने गाढवीला मारले आणि जबरदस्तीने रस्त्यावर आणले. ");
INSERT INTO mar_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","नंतर परमेश्वराचा दूत रस्ता जिथे अरुंद होता तिथे थांबला. हा दोन द्राक्षांच्या मव्व्यांच्या मधला भाग होता. रस्ताच्या दोन्ही बाजूला भिंती होत्या. ");
INSERT INTO mar_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","गाढवीने पुन्हा परमेश्वराच्या दूताला पाहिले म्हणून ती एका भिंतीला चिकटून चालू लागली त्यामुळे बलामाचा पाय भिंतीला लागून चिरडला गेला. म्हणून बलामने गाढवीला पुन्हा मारले. ");
INSERT INTO mar_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","नंतर परमेश्वराचा दूत दुसऱ्या ठिकाणी उभा राहिला. अरुंद रस्ता असलेले हे दुसरे ठिकाण होते. येथे वळायला सुद्धा मुळीच जागा नव्हती गाढवीला त्यास वळसा घालून जाणे शक्य नव्हते. ");
INSERT INTO mar_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","गाढवीने परमेश्वराच्या दूताला पाहिले म्हणून बलाम तिच्यावर बसला असतानाच ती खाली बसली त्यामुळे बलाम खूप रागावला आणि त्याने गाढवीला त्याच्या काठीने मारायला सुरुवात केली. ");
INSERT INTO mar_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","नंतर परमेश्वराने गाढवीला बोलते केले. गाढवी बलामास म्हणाली, तू माझ्यावर का रागावला आहेस? मी तुला काय केले आहे? तू मला तीन वेळा मारलेस. ");
INSERT INTO mar_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बलामने गाढवीला उत्तर दिले, तू मला मूर्ख बनवलेस. जर माझ्या हातात तलवार असती तर मी तुला मारुन टाकले असते. ");
INSERT INTO mar_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","पण गाढवी बलामास म्हणाली, बघ मी तुझीच गाढवी आहे. खूप वर्षे तू माझ्यावर बसत आला आहेस. आणि यापूर्वी मी असे काही केले नाही हे तुला माहीत आहे. बलाम म्हणाला, नाही. ");
INSERT INTO mar_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","नंतर परमेश्वराने बलामाचे डोळे उघडले, तेव्हा त्यास परमेश्वराचा दूत दिसला. तो रस्त्यात तलवार घेऊन उभा होता. त्याने परमेश्वराच्या दूताला रस्त्यात जमिनीपर्यंत वाकून नमस्कार केला. ");
INSERT INTO mar_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","परमेश्वराच्या दूताने बलामास विचारले, तू तुझ्या गाढवीला तीनदा का मारलेस? तुला थांबवण्यासाठी मी आलो आहे. पण अगदी ऐनवेळी ");
INSERT INTO mar_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","तुझ्या गाढवीने मला पाहिले आणि ती दूर गेली. असे तीन वेळा घडले. जर गाढवी वळली नसती तर आतापर्यंत मी तुला मारले असते आणि तुझ्या गाढवीला जिवंत राहू दिले असते. ");
INSERT INTO mar_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","तेव्हा बलाम परमेश्वराच्या दूताला म्हणाला, मी पाप केले आहे. तू रस्त्यात उभा आहेस हे मला माहीत नव्हते. मी जर चूक करीत असेन तर मी घरी परत जाईन. ");
INSERT INTO mar_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","तेव्हा परमेश्वराचा दूत बलामास म्हणाला, नाही! तू या लोकांबरोबर जाऊ शकतोस. पण सावध रहा. मी जे सांगेन तेच शब्द बोल. म्हणून बलाम बालाकाने पाठवलेल्या पुढाऱ्यांबरोबर गेला. ");
INSERT INTO mar_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","बलाम येत असल्याचे बालाकाला समजले. म्हणून तो बलामास भेटायला आर्णोन नदीजवळच्या मवाबाच्या शहरात गेला. ते त्याच्या देशाच्या उत्तर सरहद्दीवर होते. ");
INSERT INTO mar_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","जेव्हा बालाकाने बलामास पाहिले तेव्हा तो त्यास म्हणाला, मी तुला आधीच यायला सांगितले होते. तुला साजेसा सन्मान करण्यास मी समर्थ नव्हतो काय? ");
INSERT INTO mar_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","बलामाने बालाकाला उत्तर दिले, पण आताच मी येथे आलो आहे. मी आलो आहे पण तू सांगितलेल्या गोष्टी मला कदाचित करता येणार नाहीत. परमेश्वर देव जेवढे सांगेल तेवढेच मी बोलू शकतो. ");
INSERT INTO mar_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","नंतर बलाम बालाकाबरोबर किर्याथ-हसोथ येथे गेला. ");
INSERT INTO mar_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","बालाकाने काही गुरे व मेंढ्या बली म्हणून मारल्या. त्याने थोडे मांस बलामास दिले आणि थोडे त्याच्याबरोबर असलेल्या पुढाऱ्यांना दिले. ");
INSERT INTO mar_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","दुसऱ्या दिवशी सकाळी बालाक बलामास घेऊन बामोथ-बआल शहरी गेला. तेथून त्यांना इस्राएल लोकांच्या तळाचा शेवटचा भाग दिसू शकत होता. ");
INSERT INTO mar_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","बलाम बालाकाला म्हणाला, इथे सात वेद्या बांधा आणि माझ्यासाठी सात बैल आणि सात मेंढे तयार ठेवा. ");
INSERT INTO mar_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बलामाने सांगितले तसे बालाकाने एक मेंढा व एक बैल प्रत्येक वेदीवर मारला. ");
INSERT INTO mar_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","नंतर बलाम बालाकाला म्हणाला, तू या होमबली जवळ थांब. मी दुसरीकडे जातो. नंतर परमेश्वर माझ्याकडे येईल आणि मी काय बोलायचे ते मला सांगेल. नंतर बलाम उंच जागी गेला. ");
INSERT INTO mar_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","देव त्या जागी बलामाकडे आला आणि बलाम म्हणाला, मी सात वेद्या तयार केल्या आहेत. आणि प्रत्येक वेदीवर मी एकेक मेंढा व बैल बली दिला आहे. ");
INSERT INTO mar_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","नंतर परमेश्वराने काय बोलायचे ते बलामास सांगितले. परमेश्वर म्हणाला, बालाकाकडे परत जा आणि मी सांगतो तेच त्यास जाऊन सांग. ");
INSERT INTO mar_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","तेव्हा बलाम बालाकाकडे परत आला आणि तो आपल्या होमार्पणाजवळ उभा होता आणि मवाबाचे सर्व पुढारी त्याच्याबरोबर होते. ");
INSERT INTO mar_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","नंतर बलामाने आपला संदेश सांगण्यास सुरवात केली आणि म्हणाला, पूर्वेकडील अराम पर्वतावरुन मवाबाचा राजा बालाक याने मला येथे आणले. तो म्हणाला, ये, माझ्यासाठी याकोबाला शाप दे, ये, इस्राएलींना विरोध कर. ");
INSERT INTO mar_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ज्याला देवाने शाप दिला नाही त्यास मी कसा शाप देऊ? ज्याला परमेश्वराने धमकी दिली नाही त्यास मी कशी धमकी देऊ? ");
INSERT INTO mar_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","मी त्या लोकांस पर्वतावरुन बघू शकतो; मी त्यांना उंच डोंगरावरुन बघतो. पहा, तेथे लोक एकटेच राहत आहे आणि ते स्वतःला सर्वसाधारण राष्ट्रामध्ये गणित नाहीत. ");
INSERT INTO mar_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","इस्राएलाचा केवळ चौथा हिस्सा कोण मोजेल किंवा याकोबाच्या धुळीचे कण कोण मोजू शकेल? मला नीतिमान मनुष्याप्रमाणे मरण येऊ दे, आणि त्यांच्याप्रमाणेच माझ्या जीवनाचा शेवट होऊ दे! ");
INSERT INTO mar_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","बालाक बलामास म्हणाला, तू हे काय केलेस? माझ्या शत्रूंना शाप देण्यासाठी मी तुला येथे आणले. पण पहा, तू तर त्यांना आशीर्वाद दिलास. ");
INSERT INTO mar_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","बलामाने उत्तर दिले व म्हणाला, परमेश्वराने माझ्या मुखात जे घातले, केवळ तेच मी बोलण्याची काळजी घेऊ नये काय? ");
INSERT INTO mar_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","नंतर बालाक त्यास म्हणाला, म्हणून माझ्याबरोबर दुसऱ्या जागी ये. तिथून तुला ह्यातील आणखी बरेच लोक दिसू शकतील. तू त्या सगळ्यांना बघू शकणार नाहीस. पण त्यांचा काही भाग तुला दिसू शकेल. कदाचित त्या जागेवरुन तू त्यांना माझ्यासाठी शाप दे. ");
INSERT INTO mar_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","तेव्हा बालाक बलामास पिसगाच्या माथ्यावरील सोफीमाच्या माळ्यावर घेऊन गेला. तेथे बालाकाने सात वेद्या बांधल्या. नंतर बालाकाने प्रत्येक वेदीवर एक बैल आणि एक मेंढा बली दिला. ");
INSERT INTO mar_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","तेव्हा बलाम बालाकाला म्हणाला, तू येथे आपल्या होमबलीजवळ या वेदीजवळ थांब. मी तिकडे जाऊन देवाला भेटून येतो. ");
INSERT INTO mar_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","परमेश्वर बलामाकडे आला आणि काय बोलायचे ते त्याने त्यास सांगितले. नंतर परमेश्वराने बलामास बालाकाकडे जायला सांगितले. आणि त्याने सांगितलेलेच बोलायला सांगितले. ");
INSERT INTO mar_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","म्हणून बलाम बलाकाकडे परत गेला. बालाक वेदीजवळच उभा होता. मवाबाचे पुढारी होमबलीपाशी उभे होते. बालाकाने बलामास येताना पाहिले. आणि तो म्हणाला, परमेश्वराने काय सांगितले? ");
INSERT INTO mar_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","बलामाने त्याच्या संदेशास सुरवात केली. तो म्हणाला, बालाका, उठ आणि ऐक. तू सिप्पोरेच्या मुला, माझे ऐक, ");
INSERT INTO mar_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","देव मनुष्य नाही, की त्याने खोटे बोलावे, किंवा तो काही मनुष्यप्राणी नाही की, त्याने मन बदलावे. जर त्याने काही वचन दिले तर तो ते केल्याशिवाय राहील काय? तो बोलला आहे मी हे करील तर ते तो पुरे केल्याशिवाय राहील काय? ");
INSERT INTO mar_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","पहा, मी आशीर्वाद द्यायला आज्ञा केली, देवाने आशीर्वाद दिला आणि मी तो उलटा फिरवू शकत नाही. ");
INSERT INTO mar_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","त्यास याकोबात काही कष्ट किंवा इस्राएलात त्रास दिसला नाही. त्यांचा परमेश्वर देव त्यांच्याबरोबर आहे, राजाचा जयघोष त्यांच्यात आहे. ");
INSERT INTO mar_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","देवाने त्यांना मिसर देशातून बाहेर आणले. ते रानबैला इतके शक्तीमान आहेत. ");
INSERT INTO mar_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","याकोबाच्याविरूद्ध मंत्रतंत्र चालणार नाही आणि इस्राएलींना दैवप्रश्र सांगणारे हानी पोचवू शकत नाही, याकोबाविषयी व इस्राएलाविषयी म्हणतील की पहा, देवाने केवढे महान कार्य केले! ");
INSERT INTO mar_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","पहा, लोक सिंहिणीसारखे उठत आहेत, सिंहासारखा बाहेर येतो आणि हल्ला करतो. तो त्याची शिकार खाऊन आणि वधलेल्यांचे रक्त प्यायल्याखेरीज तो खाली बसणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","नंतर बालाक बलामास म्हणाला, तू त्यांना शापहि देऊ नको आणि आशीर्वादहि देऊ नको. ");
INSERT INTO mar_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बलामाने बालाकाला उत्तर दिले, मी तुला आधीच सांगितले होते की परमेश्वर जे सांगेल तेच मला बोलता येईल. ");
INSERT INTO mar_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","नंतर बालाक बलामास म्हणाला, तेव्हा माझ्याबरोबर दुसऱ्या ठिकाणी ये. कदाचित देव आनंदी होईल आणि तुला त्या लोकांस शाप द्यायची परवानगी देईल. ");
INSERT INTO mar_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","म्हणून बालाक बलामास घेऊन पौर पर्वताच्या माथ्यावर गेला. या पर्वतावरुन वाळवंट दिसते. ");
INSERT INTO mar_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","बलाम बालाकाला म्हणाला, “इथे सात वेद्या बांध. नंतर सात बैल आणि सात मेंढे बली देण्यासाठी तयार कर.” ");
INSERT INTO mar_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बलामाने सांगितल्याप्रमाणे बालाकाने साऱ्या गोष्टी केल्या. बालाकाने वेदीवर बैल आणि मेंढे बली दिले. ");
INSERT INTO mar_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","इस्राएलाला आशीर्वाद द्यायची परमेश्वराची इच्छा आहे हे बलामाने पाहिले. म्हणून त्याने ते कोणत्याही प्रकारचे मंत्रतंत्र वापरुन थांबवायचा प्रयत्न केला नाही. पण तो वळला आणि त्याने रानाकडे पाहिले. ");
INSERT INTO mar_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","बलामाने रानाकडे पाहिले आणि त्यास इस्राएलाचे सगळे वंश दिसले. त्यांनी आपापल्या भागात आपापल्या गटासह तळ दिला होता. नंतर देवाचा आत्मा बलामावर आला. ");
INSERT INTO mar_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","त्याने हा संदेश स्विकारला आणि म्हणाला, बौराचा मुलगा बलाम, ज्या मनुष्याचे डोळे स्पष्ट उघडे आहेत त्याविषयी बोलत आहे. ");
INSERT INTO mar_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","जो देवाचे शब्द ऐकतो आणि बोलतो, जो सर्वसमर्थापासून दृष्टांत पाहतो, जो त्याच्यापुढे डोळे उघडे ठेवून नतमस्तक होतो. ");
INSERT INTO mar_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","हे याकोबा तुझे तंबू, हे इस्राएला, जिथे तू राहतो ते किती सुंदर आहे! ");
INSERT INTO mar_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","खोऱ्यासारखे विस्तृत पसरलेले, नदीकाठी लावलेल्या बागेसारखे, परमेश्वराने लावलेल्या कोरफडीप्रमाणे आहे, पाण्याजवळच्या गंधसरूसारखे ते आहेत. ");
INSERT INTO mar_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","पाणी त्यांच्या बादलीतून वाहील, आणि त्यांच्या बीजाला भरपूर पाणी मिळेल. त्यांचा राजा अगाग राजापेक्षा थोर होईल व त्यांच्या राजाचा गौरव होईल. ");
INSERT INTO mar_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","देवाने त्यांना मिसरामधून बाहेर आणले. त्यांना रानटी बैलासारखी शक्ती आहे. तो आपल्याविरूद्ध लढणाऱ्या राष्ट्रांना खाऊन टाकील. तो त्यांच्या हाडांचे तुकडे तुकडे करील. तो आपल्या बाणांनी त्यांना मारील. ");
INSERT INTO mar_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","तो सिंहासारखा, सिंहिणीसारखा दबा धरून बसला आहे. त्यास उठवण्याची कोण हिंम्मत करील? जो तुला आशीर्वाद देईल तो प्रत्येकजण आशीर्वाद देईल; तुला शाप देणारा प्रत्येकजण शापित होईल. ");
INSERT INTO mar_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","बलामाविरूद्ध बालाकाचा राग भडकला आणि त्याने रागाने आपले हात एकत्रीत आपटले. बालाक बलामास म्हणाला, “मी तुला माझ्या शत्रूंना शाप देण्यासाठी बोलावले, पण पाहा, तू त्यांना तीन वेळा आशीर्वाद दिलास. ");
INSERT INTO mar_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","तर आता मला सोडून घरी जा. मी तुला चांगला मोबदला देईन असे म्हटले होते, परंतु परमेश्वराने तुला कोणतेही इनाम मिळण्यापासून दूर ठेवले आहे.” ");
INSERT INTO mar_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बलाम बालाकाला म्हणाला, तूच माझ्याकडे माणसे पाठवलीस. त्या मनुष्यांनी मला येण्याबद्दल विचारले. पण मी त्यांना म्हणालो, ");
INSERT INTO mar_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","बालाक मला त्याचे सोन्या-चांदीने भरलेले घर देऊ शकेल. पण मी परमेश्वराने आज्ञा केलेल्या गोष्टीच बोलेन. मी स्वत: काहीही चांगले अथवा वाईट करु शकत नाही. परमेश्वर जेवढी आज्ञा देईल तेवढीच मी बोलतो. तुला या गोष्टी नक्कीच आठवत असतील की मी हे तुझ्या मनुष्यांना सांगितले होते. ");
INSERT INTO mar_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","तर आता पाहा. मी माझ्या मनुष्यांकडे परत जात आहे. पण मी तुला एक इशारा देतो. इस्राएलाचे हे लोक भविष्यात तुला आणि तुझ्या लोकांस काय करतील ते सांगतो. ");
INSERT INTO mar_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","बलामाने हा संदेश सांगण्यास सुरवात केली. तो म्हणाला, बौराचा मुलगा बलाम बोलतो, ज्या मनुष्याचे डोळे सताड उघडे आहेत. ");
INSERT INTO mar_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","हा संदेश जो कोणी देवाकडून ऐकतो, ज्याला परात्परापासूनचे ज्ञान आहे, ज्याला सर्वसमर्थापासून दर्शन आहे, जो डोळे उघडे ठेवून दंडवत घालतो. ");
INSERT INTO mar_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","मी त्यास पाहीन, पण तो आता इथे नाही. मी त्याच्याकडे पाहीन, पण तो जवळ नाही. याकोबातून एक तारा बाहेर येईल, आणि इस्राएलातून एक राजदंड निघेल. तो मवाबाच्या नेत्यांना चिरडून टाकील आणि शेथाच्या सर्व मुलांचा तो नाश करील. ");
INSERT INTO mar_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","नंतर अदोम इस्राएलाचे वतन होईल, आणि सेईरही आपल्या इस्राएली शत्रूंचे वतन होईल, ज्याला इस्राएल आपल्या पराक्रमाने जिंकेल. ");
INSERT INTO mar_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","याकोबाच्या घराण्यातून एक राजा येईल तो त्यांच्यावर राज्य करील, आणि तो त्यांच्या शहरातील उरलेल्यांचा नाश करील. ");
INSERT INTO mar_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","नंतर बलामाने अमालेकाकडे पाहिले आणि त्याच्या संदेशास सुरवात केली. तो म्हणाला, “अमालेकी एकदा राष्ट्रांत महान होता, पण त्याचा अंतीम शेवट नाश होईल.” ");
INSERT INTO mar_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","नंतर बलामने केनीकडे पाहिले आणि त्याने त्याच्या संदेशास सुरवात केली. तो म्हणाला, “तू जेथे राहतोस ती जागा बळकट आहे, आणि तुझे घरटे खडकात आहे.” ");
INSERT INTO mar_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","“तरीसुद्धा केनी राष्ट्रांचा नाश होईल, जेव्हा अश्शूर तुला बंदिवान करून नेईल.” ");
INSERT INTO mar_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","नंतर बलामाने अंतीम संदेशास सुरवात केली. तो म्हणाला, देव जेव्हा असे करतो “हायहाय! जेव्हा देव हे करीत असता कोण जिवंत राहील?” ");
INSERT INTO mar_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","कित्तीमाच्या किनाऱ्यापासून जहाजे येतील; ते अश्शूरावर हल्ला करतील आणि एबर जिंकून घेतील. पण त्यांचासुद्धा नाश होईल. ");
INSERT INTO mar_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","नंतर बलाम उठला आणि गेला. तो आपल्या घरी परत गेला आणि बालाकही आपल्या वाटेने गेला. ");
INSERT INTO mar_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","इस्राएली शिट्टीमात राहत असताना त्यांनी मवाबी बायकांबरोबर व्यभिचार करू लागले. ");
INSERT INTO mar_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","मवाबाच्या स्त्रियांनी पुरुषांना त्यांच्या देवांच्या अर्पणात आमंत्रण दिले. तेव्हा लोक जेवले व त्यांनी त्यांच्या देवांना नमन केले. ");
INSERT INTO mar_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","इस्राएल लोकांनी बआल-पौराच्या देवांची उपासना करायला सुरुवात केली आणि परमेश्वराचा राग इस्राएलांवर भडकला. ");
INSERT INTO mar_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","परमेश्वर मोशेला म्हणाला, “त्या सर्व लोकांच्या पुढाऱ्यांना आण, नंतर त्यांना परमेश्वराकरता भरदिवसा फाशी दे म्हणजे परमेश्वराचा इस्राएलावर भडकलेला राग जाईल.” ");
INSERT INTO mar_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","मोशे इस्राएलच्या न्यायधिशांना म्हणाला, “तुम्ही प्रत्येकाने आपआपल्या ताब्यातील पुरुष बआल-पौराच्या देवांची उपासना करतात त्या सर्वांना तुम्ही मारून टाका.” ");
INSERT INTO mar_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","त्यावेळी मोशे आणि इस्राएलची वडीलधारी मंडळी जमली होती. एका इस्राएली मनुष्याने एक मिद्यानी स्त्री त्यांच्यासमोर आपल्या भावाच्या घरी आणली. मोशे आणि इतर वडीलधारी (पुढारी) यांनी ते पाहिले आणि ते तर दर्शनमंडपाशी रडत होते. ");
INSERT INTO mar_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","जेव्हा फिनहास एलाजाराचा मुलगा, याजक अहरोन याचा नातू याने ते पाहिले, तेव्हा तो मंडळीमधून उठला आणि त्याने त्याच्या हातात भाला घेतला. ");
INSERT INTO mar_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","तो त्या इस्राएली मनुष्याचा मागे त्याच्या तंबूत गेला आणि त्याने त्या दोघांच्या म्हणजे इस्राएली मनुष्याच्या व त्या स्त्रीच्या पोटात भाला आरपार खुपसला. त्यावेळी इस्राएल लोकांमध्ये पसरलेली मरी बंद झाली. ");
INSERT INTO mar_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","या मरीमुळे एकून चोवीस हजार लोक मरण पावले. ");
INSERT INTO mar_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","एलाजाराचा मुलगा फिनहास याजक अहरोनाच्या नातवाने इस्राएल लोकांस माझ्या ईर्ष्येने पेटून इस्राएलावरील माझा राग दूर केला. म्हणून मला आधी वाटत होते त्याप्रमाणे मी त्यांचा नाश केला नाही. ");
INSERT INTO mar_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","फिनहासला सांग की मी त्याच्याबरोबर शांतीचा करार करीत आहे. ");
INSERT INTO mar_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","हा त्यास आणि त्याच्यामागे त्याच्या वंशजाना सर्वकाळ याजकपणाचा करार होईल. कारण तो आपल्या देवाबद्दल खूप आवेशी झाला. आणि त्याने इस्राएलाच्या वंशासाठी प्रायश्चित केले. ");
INSERT INTO mar_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","“मिद्यानी स्त्री बरोबर जो इस्राएली मनुष्य मारला गेला होता त्याचे नाव जिम्री होते. तो सालूचा मुलगा होता. तो शिमोनी वंशातील एका घराण्याचा प्रमुख होता.” ");
INSERT INTO mar_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","आणि मारल्या गेलेल्या मिद्यानी स्त्रीचे नाव कजबी होते. ती सूरची मुलगी होती. सूर मिद्यानी कुटुंबाचा प्रमुख होता व पुढारी होता. ");
INSERT INTO mar_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","परमेश्वर मोशेशी बोलला. तो म्हणालाः ");
INSERT INTO mar_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“तू त्यांना ठार मारले पाहिजेस. मिद्यानाचे लोक तुझे शत्रू आहेत. ");
INSERT INTO mar_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","कारण त्यांनी तुला आपल्या कपटाने शत्रूसारखे वागवले. त्यांनी तुला पौराच्या वाईट गोष्टींच्या बाबतीत आणि मिद्यानाच्या अधिपतीची मुलगी कजबी, त्यांची बहीण, जी पौराच्या प्रकरणात मरी पसरली तेव्हा ती मारली गेली, तिच्या गोष्टीने ते तुम्हास जाचतात.” ");
INSERT INTO mar_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","मरी येऊन गेल्यानंतर परमेश्वर मोशे आणि अहरोनाचा मुलगा याजक एलाजार यांच्याशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“इस्राएलात, वीस वर्षाचे आणि वीस वर्षांवरील अधिक वयाचे असून युध्दास जाण्याच्या लायकीचे असतील त्या सगळ्या मंडळीची त्यांच्या पूर्वजांच्या घराण्याप्रमाणे मोजणी करा.” ");
INSERT INTO mar_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","तेव्हा मोशे आणि याजक एलाजार त्याच्याशी बोलले यरीहोपाशी यार्देन नदीतीरी मवाबाच्या मैदानात त्यांना बोलले, ते म्हणाले, ");
INSERT INTO mar_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","मोशे आणि जे इस्राएल लोक, मिसर देशातून बाहेर आले होते त्यांना परमेश्वराने ही आज्ञा दिल्याप्रमाणे, वीस वर्षे आणि त्याहून अधिक वयाच्या लोकांची तुम्ही मोजणी करा. ");
INSERT INTO mar_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","रऊबेन हा इस्राएलाचा पहिला जन्मलेला मुलगा होता. रऊबेनाच्या मुलांपासून जी कुळे आली ती कुळे म्हणजे: हनोखाचे हनोखी कूळ, पल्लूचे पल्लूवी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेस्रोनाचे हेस्रोनी कूळ, कर्मीचे कर्मी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","रऊबेनाच्या वंशातील ही कुळे. त्यामध्ये एकूण त्रेचाळीस हजार सातशे तीस भरली. ");
INSERT INTO mar_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","पल्लूचा मुलगा अलीयाब. ");
INSERT INTO mar_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","अलीयाबाची मुले नमुवेल, दाथान व अबीराम. दाथान व अबीराम हे दोन पुढारी मोशेच्या आणि अहरोनाच्या विरूद्ध गेले होते. कोरह जेव्हा परमेश्वराच्या विरूद्ध गेला तेव्हा त्यांनी कोरहाला पाठींबा दिला. ");
INSERT INTO mar_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","त्यावेळी ती अडीचशे माणसे अग्नीने खाऊन टाकली, त्याचे सर्व अनुयायी मरण पावले तेव्हा धरतीने आपले तोंड उघडले आणि तिने कोरहासह त्यांना गिळून टाकले. ते इशाऱ्याचे चिन्ह असे झाले. ");
INSERT INTO mar_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","परंतु कोरहाच्या कुळातले इतर लोक मात्र मरण पावले नाहीत. ");
INSERT INTO mar_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","शिमोनाच्या कुळातलीही काही कुळेः नमुवेलाचे नमुवेली कूळ, यामीनाचे यामीनी कूळ, याकीनाचे याकीनी कूळ, ");
INSERT INTO mar_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","जेरहाचे जेरही कूळ, शौलाचे शौली कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ही शिमोनी वंशातील कुळे. ते एकूण बावीस हजार दोनशे. ");
INSERT INTO mar_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","गाद कुळातून जी कुळे निर्माण झाली ती अशीः सफोनाचे सफोनी कूळ, हग्गीचे हग्गी कूळ, शूनीचे शूनी कूळ, ");
INSERT INTO mar_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","आजनीचे आजनी कूळ, एरीचे एरी कूळ, ");
INSERT INTO mar_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोदाचे अरोदी कूळ. अरलीचे अरेली कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","गादच्या वंशातील ही कूळे. त्यामध्ये एकूण चाळीस हजार पाचशे पुरुष होते. ");
INSERT INTO mar_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","जेरहाचे जेरही कूळ. यहूदाची दोन मुले एर आणि ओनान हे कनान मध्ये मरण पावले. ");
INSERT INTO mar_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","यहूदाच्या कुळातून जी कूळे निर्माण झाली ती अशीः शेलाचे शेलानी कूळ, पेरेसाचे पेरेसी कूळ, जेरहाचे जेरही कूळ ");
INSERT INTO mar_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","पेरेसाच्या कुळातील ही कुळेः हेस्रोनाचे हेस्रोनी कूळ, हामूलाचे हामूली कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ही यहूदाच्या कुळातील कुळे. त्यामध्ये एकूण शहात्तर हजार पाचशे पुरुष होते. ");
INSERT INTO mar_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","इस्साखाराच्या कुळातील काही कुळे अशी:तोलाचे तोलाई कूळ पूवाचे पुवाई कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","याशूबाचे याशूबी कूळ, शिम्रोनाचे शिम्रोनी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","इस्साखाराच्या कुळातील ही कुळे. त्यामध्ये एकूण चौसष्ट हजार तीनशे पुरुष होते. ");
INSERT INTO mar_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","जबुलूनाच्या कुळातील कुळेः सेरेदचे सेरेदी कूळ, एलोनाचे एलोनी कूळ, याहलेलचे याहलेली कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","जबुलूनाच्या कुळातील ही कुळे, त्यामध्ये एकूण साठ हजार पाचशे पुरुष होते. ");
INSERT INTO mar_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","योसेफाची मुले मनश्शे व एफ्राईम. या प्रत्येकापासून कुळे निर्माण झाली. ");
INSERT INTO mar_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनश्शेच्या कुळातील कुळेः माखीराचे, माखीरी कूळ (माखीर गिलादाचा बाप होता), गिलादाचे गिलादी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलादाची कूळे होतीः इयेजेराचे इयेजेरी कूळ, हेलेकाचे हेलेकी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","अस्रियेलाचे अस्रियेली कूळ, शेखेमाचे शेखेमी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","शमीदचे शमीदाई कूळ, हेफेराचे हेफेरी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","हेफेराचा मुलगा सलाफहाद याला मुले नव्हती, फक्त मुली होत्या. त्याच्या मुलींची नावे महला, नोआ, होग्ला, मिल्का व तिरसा. ");
INSERT INTO mar_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ही मनश्शेच्या कुळातील कुळे होती ते एकूण बावन्न हजार सातशे पुरुष होते. ");
INSERT INTO mar_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एफ्राइमाच्या कुळातील घराणी पुढीलप्रमाणे होती, शूथेलाहाचे शूथेलाही कूळ. बेकेराचे बेकेरी कूळ व तहनाचे तहनी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","एरान शूथेलाहाच्या कुटुंबातील होता. एरानाचे कूळ एरानी. ");
INSERT INTO mar_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ही एफ्राइमाच्या कुळातील कुळे: त्यामध्ये बत्तीस हजार पाचशे पुरुष होते. ते सगळे योसेफाच्या कुळातील होते. ");
INSERT INTO mar_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","बन्यामीनाच्या कुळातील कुळे होतीः बेलाचे बेलाई कूळ, आशबेलाचे आशबेली कूळ, अहीरामाचे अहीरामी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","शफूफामाचे शफूफामी कूळ, हुफामाचे हुफामी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","बेला ह्याचे पुत्र आर्द व नामान हे होते. आर्दीचे आर्दी कूळ, नामानाचे नामानी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ही सगळी कुळे बन्यामीनाच्या कुळातील. त्यातील पुरुषांची संख्या पंचेचाळीस हजार सहाशे होती. ");
INSERT INTO mar_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दानाच्या कुळातील कुळे होती: शूहामाचे शूहामी कूळ. ही कूळे दानाच्या कुळातील होते. ");
INSERT INTO mar_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","शूहामीच्या कुळात अनेक कुळे होती. त्यातील पुरुषांची संख्या चौसष्ट हजार चारशे होती. ");
INSERT INTO mar_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेराच्या कुळातील कुळे होतीः इम्नाचे इम्नाई कूळ, इश्वीचे इश्वी कूळ, बरीयाचे बरीयाई कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","बरीयाच्या कुळातील कुळे होतीः हेबेराचे हेबेरी कूळ, मलकीएलाचे मलकीएली कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","आशेरला सेरा नावाची मुलगी होती. ");
INSERT INTO mar_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ही सगळे लोक आशेराच्या कुळातील होते. त्यातील पुरुषांची संख्या त्रेपन्न हजार चारशे होती. ");
INSERT INTO mar_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","नफतालीच्या कुळातील कुळे होतीः यहसेलाचे यहसेली कूळ, गूनीचे गूनी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेराचे येसेरी कूळ, शिल्लेमाचे शिल्लेमी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ही नफतालीच्या कुळातील कुळे, त्यातील पुरुषांची संख्या पंचेचाळीस हजार चारशे होती. ");
INSERT INTO mar_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ही इस्राएलामधील मोजलेली पूर्ण पुरुषांची संख्या सहा लाख एक हजार सातशे तीस होती. ");
INSERT INTO mar_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","परमेश्वर मोशेशी बोलला व म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","त्यांच्या नावाच्या संख्येप्रमाणे वतनासाठी देश वाटून द्यायचा आहे. ");
INSERT INTO mar_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","मोठ्या कुळाला जास्त वतन मिळेल आणि लहान कुळाला कमी वतन मिळेल. त्यांना जे वतन मिळेल ती त्या कुळात मोजलेल्या मनुष्यांच्या समप्रमाणात असेल. ");
INSERT INTO mar_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","देश चिठ्ठ्या टाकून वाटायचा आहे त्यांच्या वडिलांच्या वंशाच्या नावांप्रमाणे त्यांनी वतन करून घ्यावा. ");
INSERT INTO mar_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","प्रत्येक लहान आणि मोठ्या कुळाला वतन मिळेल आणि निर्णय करण्यासाठी तू चिठ्ठ्या टाकशील. ");
INSERT INTO mar_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","त्यांनी लेव्याच्या कुळातील, कुळांचीही गणती केली, ती ही होतीः गेर्षोनाचे गेर्षोनी कूळ, कहाथाचे कहाथी कूळ, मरारीचे मरारी कूळ. ");
INSERT INTO mar_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","लेव्याची ही कूळे होतीः लिब्नी कूळ, हेब्रोनी कूळ, महली कूळ, मूशी कूळ, आणि कोरही कूळ. अम्राम कहाथाच्या कुळातील होता. ");
INSERT INTO mar_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अम्रामाच्या पत्नीचे नाव योखबेद होते. ती सुद्धा लेव्याच्या कुळातील होती. ती मिसर देशात जन्मली. अम्राम आणि योखाबेदला दोन मुले: अहरोन आणि मोशे. त्यांना एक मुलगीही होती. तिचे नाव मिर्याम. ");
INSERT INTO mar_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","नादाब, अबीहू, एलाजार व इथामार यांचे अहरोन वडील होते. ");
INSERT INTO mar_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","पण नादाब व अबीहू हे परमेश्वरासमोर अन्य अग्नी अर्पीत असताना मरण पावले. ");
INSERT INTO mar_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","लेव्याच्या कुळातील एकूण पुरुषांची संख्या तेवीस हजार होती. परंतु यांची गणती इस्राएलाच्या इतर लोकांबरोबर केली नाही. परमेश्वराने इतर लोकांस वतन दिले त्यामध्ये यांना हिस्सा मिळाला नाही. ");
INSERT INTO mar_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मोशे आणि याजक एलाजार यांनी जे मोजले ते हेच आहेत. त्यांनी मवाबाच्या मैदानात यरीहोजवळ यार्देनवर इस्राएलाच्या वंशाची मोजणी केली. ");
INSERT INTO mar_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","खूप वर्षांपूर्वी सीनायाच्या वाळवंटात मोशे आणि याजक अहरोन यांनी इस्राएल लोकांची गणती केली होती. पण ते सगळे लोक आता मरण पावले होते. त्यापैकी कोणीही आता जिवंत नव्हते. ");
INSERT INTO mar_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","कारण इस्राएल लोकांस तुम्ही रानात मराल असे परमेश्वराने सांगितले होते. फक्त दोन पुरुषांना परमेश्वराने जिवंत ठेवले होते. यफुन्नेचा मुलगा कालेब व नूनाचा मुलगा यहोशवा होते. ");
INSERT INTO mar_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","मग योसेफाचा मुलगा मनश्शे ह्याच्या कुळातला सलाफहाद हेफेरचा मुलगा होता. हेफर गिलादाचा मुलगा होता. गिलाद माखीरचा मुलगा होता. माखिर मनश्शेचा मुलगा होता. सलाफहादला पाच मुली होत्या. त्यांची नावे महला, नोआ, होग्ला, मिल्का व तिरसा. ");
INSERT INTO mar_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","या पाच स्त्रिया दर्शनमंडप प्रवेशद्वारापाशी गेल्या आणि मोशे, याजक एलाजार, पुढारी आणि इस्राएलाच्या मंडळीसमोर जाऊन उभ्या राहिल्या. त्या म्हणाल्या, ");
INSERT INTO mar_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","आमचे वडील रानात असताना मरण पावले. ज्या मंडळीने कोरहाच्या समूहाला मिळून परमेश्वरास विरोध केला होता त्यामध्ये तो नव्हता तर तो आपल्याच पापाने मेला. त्याऐवजी त्याच्या स्वतःच्या पापाच्या कारणाने तो मेला. ");
INSERT INTO mar_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","त्यास पुत्र नव्हते एवढ्यावरूनच आमच्या बापाचे नाव त्याच्या कुळातून का काढून टाकावे? आमच्या वडिलांच्या भावांमध्ये आम्हास वतन दे. ");
INSERT INTO mar_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","तेव्हा मोशेने परमेश्वरासमोर त्यांचे प्रकरण ठेवले. ");
INSERT INTO mar_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","परमेश्वर मोशेशी बोलला व म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","सलाफहादाच्या मुलींचे म्हणणे बरोबर आहे. त्यांच्या वडिलांच्या नातेवाईकांबरोबर त्यांना मिळणाऱ्या वतनात त्यांचाही वाटा द्यावा. म्हणून त्यांच्या वडिलांचे वतन त्यांच्या नावे कर. ");
INSERT INTO mar_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","इस्राएल लोकांसाठी हा नियम कर: जर एखाद्याला मुलगा नसला आणि तो निपुत्रिक मेला तर त्याचे वतन त्याच्या मुलींना मिळावे. ");
INSERT INTO mar_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","जर त्यास मुलीही नसल्या तर त्याचे वतन त्याच्या भावांना मिळावे. ");
INSERT INTO mar_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","जर त्यास भाऊही नसला तर त्याचे वतन त्याच्या चुलत्याला द्यावे. ");
INSERT INTO mar_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","जर त्याच्या वडिलांना भाऊ नसेल तर त्याचे वतन त्याच्या कुळापैकी जो सर्वात जवळचा नातेवाईक असेल त्यास ते मिळावे. इस्राएल लोकांमध्ये हा कायदा असावा अशी आज्ञा परमेश्वराने मोशेला केली. हा इस्राएली लोकांचा कायदा व्हावा. ");
INSERT INTO mar_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","परमेश्वर मोशेला म्हणाला, यार्देन नदीच्या पूर्वेकडील रानातील अबारीम डोंगरावर तू चढून जा. मी इस्राएल लोकांस जो देश देणार आहे तो तेथून पाहा. ");
INSERT INTO mar_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","तो पाहिल्यानंतर तुझा भाऊ अहरोन जसा आपल्या पूर्वजांस जाऊन मिळाला तसा तू आपल्या पूर्वजांस जाऊन मिळशील. ");
INSERT INTO mar_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","त्सीनच्या रानात मंडळीचे भांडण झाले त्यावेळी त्या झऱ्याजवळ त्यांच्यासमोर माझे पावित्र्य प्रगट करावे म्हणून जी आज्ञा होती तिच्याविरूद्ध तुम्ही दोघांनी बंड केले. हे त्सीनच्या रानात कादेश येथील मरीबा झऱ्याच्याजवळ घडले. ");
INSERT INTO mar_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मोशे परमेश्वराशी बोलला व म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","परमेश्वर सर्व मानवजातीच्या आत्म्यांचा देव याने एका मनुष्यास मंडळीवर नेमून ठेवावे. ");
INSERT INTO mar_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","तो त्यांच्यापुढे बाहेर जाईल व त्यांच्यापुढे आत येईल. तो त्यांना बाहेर नेईल व आत आणील म्हणजे परमेश्वराची मंडळी मेंढपाळ नसलेल्या मेंढरासारखी होणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","तेव्हा परमेश्वर मोशेला म्हणाला, नूनाचा मुलगा यहोशवा ह्याला घेऊन त्याच्यावर आपला हात ठेव, त्याच्याठायी माझा आत्मा राहतो. ");
INSERT INTO mar_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","त्यास याजक एलाजार आणि सर्व मंडळीसमोर उभे करून आणि त्यास त्यांच्या समक्ष आज्ञा कर. ");
INSERT INTO mar_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","तू आपला काही अधिकार त्यास दे. याकरिता की, इस्राएलाच्या सर्व मंडळीने त्याची आज्ञा मानावी. ");
INSERT INTO mar_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","तो एलाजार याजकापुढे उभा राहील, तो त्याच्यावतीने उरीमाच्या निर्णयासाठी परमेश्वरास विचारील. त्याने व त्याच्याबरोबर इस्राएलाच्या सर्व लोकांनी त्याच्या सांगण्यावरून बाहेर जावे व आत यावे. ");
INSERT INTO mar_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","मोशेने परमेश्वराने आज्ञा दिल्याप्रमाणे केले. त्याने यहोशवाला एलाजार याजकाच्या आणि लोकांच्या पुढे उभे केले. ");
INSERT INTO mar_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","परमेश्वराने आज्ञा दिल्याप्रमाणे मोशेने त्याच्यावर हात ठेवले आणि त्याने त्यास नेतृत्व करण्याची आज्ञा दिली. ");
INSERT INTO mar_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","परमेश्वर मोशेशी बोलला आणि म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","इस्राएल लोकांस आज्ञा दे आणि त्यांना सांग की, माझे अर्पण, म्हणजे मला मधुर सुवासाची अग्नीतून केलेली माझी अर्पणे यासाठी माझे अन्न, तुम्ही त्यांच्या नेमलेल्या वेळी अर्पणे करण्यास जपा. ");
INSERT INTO mar_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","आणखी तू त्यांना सांग, अग्नीतून केलेले अर्पण त्यांनी परमेश्वरास अर्पावे ते हे आहेः त्यांनी नेहमी होमार्पणासाठी रोज एक एक वर्षाची दोन निर्दोष नर कोकरे. ");
INSERT INTO mar_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","एक कोकरू सकाळी आणि दुसरे संध्याकाळी अर्पण करावे. ");
INSERT INTO mar_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","हातकुटीच्या पाव हिन तेलात मळलेल्या एक दशमांश एफा सपिठाचे अन्नार्पण करावे. ");
INSERT INTO mar_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","हे नित्याचे होमार्पण, सीनाय पर्वतावर नेमलेले, परमेश्वरास सुवासासाठी अग्नीतून केलेले असे अर्पण आहे. ");
INSERT INTO mar_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","त्याबरोबरचे पेयार्पण एका कोकरामागे पाव हिन असावे, म्हणजे परमेश्वरासाठी पवित्रस्थानी मदिरेचे पेयार्पण तू ओतावे. ");
INSERT INTO mar_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","दुसरे कोकरू संध्याकाळी अर्पावे. जसे सकाळचे अन्नार्पणाप्रमाणे व त्याबरोबरची पेयार्पणे तसे ते परमेश्वरास मधुर सुवासाचे, अग्नीतून केलेले अर्पण असे अर्पण कर. ");
INSERT INTO mar_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“प्रत्येक शब्बाथ दिवशी एक एक वर्षाचे दोन निर्दोष नर कोकरे आणि अन्नार्पणासाठी तेलात मळलेले दोन दशमांश एफा सपीठ व त्याबरोबरची पेयार्पण ही अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","नेहमीचे होमार्पण व त्याबरोबरचे पेयार्पण याखेरीज आणखी हा होमार्पण प्रत्येक शब्बाथ दिवशी अर्पावा.” ");
INSERT INTO mar_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","प्रत्येक महिन्याच्या पहिल्या दिवशी तुम्ही परमेश्वरास होमार्पणे करावे. या अर्पणात दोन बैल, एक मेंढा आणि एक वर्षाच्या सात मेंढ्या असतील. त्या मेंढ्या दोषरहित असाव्यात. ");
INSERT INTO mar_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","प्रत्येक बैलामागे अन्नार्पण म्हणून तेलात मळलेले तीन दशमांश एफा सपीठ आणि प्रत्येक मेंढ्यामागे अन्नार्पण म्हणून तेलात मळलेले दोन दशमांश एफा सपीठ. ");
INSERT INTO mar_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","आणि प्रत्येक कोकराबरोबर अन्नार्पण म्हणून तेलात मळलेले एक दशमांश एफा सपीठ अर्पावे. हे होमार्पण, मधुर सुवासाचे परमेश्वरास अग्नीतून केलेले अर्पण असे आहे. ");
INSERT INTO mar_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","लोकांची पेयार्पणे ही प्रत्येक बैलाकरता अर्धा हीन, व प्रत्येक मेंढ्याकरता एकतृतीयांश हीन व प्रत्येक कोकऱ्याकरता एक चतुर्थाश हीन इतका द्राक्षरस असावा, वर्षातील प्रत्येक महिन्यात हे होमार्पण करावे. ");
INSERT INTO mar_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","आणि निरंतरचे होमार्पण व त्याचे पेयार्पण याखेरीज परमेश्वरास पापार्पणासाठी शेरडातला एक बकरा अर्पावा. ");
INSERT INTO mar_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","परमेश्वराचा वल्हांडण सण महिन्याच्या चौदाव्या दिवशी आहे. ");
INSERT INTO mar_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","बेखमीर भाकरीचा सण महिन्याच्या पंधराव्या दिवशी सुरु होतो. हा सण सात दिवस असेल. खमीराशिवाय केलेली भाकरीच फक्त तुम्ही खाऊ शकता. ");
INSERT INTO mar_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","या सणाच्या पहिल्या दिवशी तुम्ही खास सभा बोलावली पाहिजे. त्यादिवशी तुम्ही कसलेही काम करायचे नाही. ");
INSERT INTO mar_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","तुम्ही परमेश्वरास होमार्पणे द्याल. या अर्पणात दोन बैल, एक मेंढा आणि एक वर्षाची सात कोकरे असतील. ती दोषरहित असावीत. ");
INSERT INTO mar_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","त्याबरोबरचे अन्नार्पण तेलात मळलेल्या सपिठाचे असावे. गोऱ्ह्यामागे तीन दशमांस एफा आणि त्या मेंढ्याच्यामागे दोन दशमांस एफा, ");
INSERT INTO mar_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","आणि सात कोकरापैकी प्रत्येक कोकरामागे एक दशमांश एफा अर्पावे. ");
INSERT INTO mar_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","तुम्ही एक बकराही अर्पण केला पाहिजे. तुम्हास शुद्ध करण्यासाठी देण्यात येणारे ते पापार्पण असेल. ");
INSERT INTO mar_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","सकाळचे होमार्पण जे निरंतरचे होमार्पण आहे त्याव्यतिरिक्त हे अर्पण करावे. ");
INSERT INTO mar_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","याप्रमाणे वल्हाडणाचे सात दिवस दररोज परमेश्वरास मधुर सुवासाचे, अग्नीतून केलेल्या अर्पणाचे अन्न अर्पण करा, निरंतरचे होमार्पणे आणि त्याचे पेयार्पण याव्यतिरिक्त हे अर्पण असावे. ");
INSERT INTO mar_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","नंतर या सणाच्या सातव्या दिवशी तुम्ही पवित्र मेळा भरवावा आणि तुम्ही त्यादिवशी काहीही अंगमेहनीतीचे काम करू नये. ");
INSERT INTO mar_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","सप्ताहांच्या सणात प्रथम पीक अर्पिण्याच्या दिवशी तुम्ही परमेश्वरास नव्या अन्नाचे अर्पण कराल त्यावेळी तुम्ही एक पवित्र मेळा बोलवा त्यादिवशी तुम्ही कसलेही अंगमेहनीतीचे काम करू नये. ");
INSERT INTO mar_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","तुम्ही परमेश्वरास सुवासासाठी होमार्पणे म्हणून तुम्ही दोन गोऱ्हे, एक मेंढा व एक एक वर्षाचे सात कोकरे अर्पण करा. ");
INSERT INTO mar_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","आणि त्याबरोबरचे अन्नार्पण तेलात मळलेल्या सपिठाचे असावे. प्रत्येक गोऱ्ह्यामागे तीन दशमांश एफा व मेंढ्यामागे दोन दशमांश एफा द्यावे. ");
INSERT INTO mar_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","व त्या सात कोकराबरोबर एक दशमांश एफा सपीठ अर्पावे. ");
INSERT INTO mar_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","आणि तुम्हासाठी प्रायश्चित करायला एक बकरा अर्पावा. ");
INSERT INTO mar_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","आणि निरंतरचे होमार्पण व अन्नार्पणाशिवाय ते अर्पण करावे. जेव्हा ते प्राणी तुम्हासाठी अर्पण करायचे ते निर्दोष असावे; त्याबरोबरची पेयार्पणे सुद्धा अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","सातव्या महिन्याच्या पहिल्या दिवशी पवित्र मेळा भरवावा. त्यादिवशी तुम्ही कसलेही अंगमेहनतीचे काम करू नये. हा तुमचा कर्णा वाजवण्याचा दिवस आहे. ");
INSERT INTO mar_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","परमेश्वरास मधुर सुवास यावा म्हणून एक गोऱ्हा, एक मेंढा आणि एक एक वर्षांची सात निर्दोष कोकरे होमबलि म्हणून अर्पण करावी. ");
INSERT INTO mar_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","त्याबरोबरचे अन्नार्पण तेलांत मळलेल्या सपीठाचे असावे, गोऱ्ह्यामागे तीन दशमांश एफा, मेंढ्यामागे दोन दशमांस एफा, ");
INSERT INTO mar_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","मेंढ्याबरोबर आठ कप पीठ प्रत्येक कोकराबरोबर अर्पण करावे. ");
INSERT INTO mar_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","तुम्हासाठी प्रायश्चित करायला पापार्पणासाठी एक बकरा अर्पावा. ");
INSERT INTO mar_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","चंद्रदर्शनाचे होमार्पण आणि त्याबरोबरचे अन्नार्पण, तसेच नेहमीचे होमार्पण व त्याबरोबरचे अन्नार्पण व त्याबरोबरची पेयार्पणे याव्यतिरिक्त परमेश्वरास मधुर सुवासासाठी अग्नीतून केलेले हे अर्पण असावे. ");
INSERT INTO mar_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","सातव्या महिन्याच्या दहाव्या दिवशी तुम्ही पवित्र मेळा भरवावा. त्यादिवशी तुम्ही अन्न घ्यायचे नाही आणि काही कामही करायचे नाही. ");
INSERT INTO mar_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","तुम्ही परमेश्वरास मधुर सुवास मिळावा म्हणून होमार्पणे करावे ते हे, तुम्ही एक गोऱ्हा, एक मेंढा आणि एक एक वर्ष वयाचे सात निर्दोष कोकरे अर्पण करावेत. ");
INSERT INTO mar_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","आणि त्याबरोबर तेलात मळलेल्या सपिठाचे अन्नार्पण असावे. गोऱ्ह्यामागे तीन दशमांश एफा, मेंढ्यामागे दोन दशमांस एफा, ");
INSERT INTO mar_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","सात कोकरांपैकी प्रत्येक कोकराबरोबर एक दशमांश एफा सपीठ अर्पावे. ");
INSERT INTO mar_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","पापार्पणासाठी एक बकराही अर्पावा. याखेरीज प्रायश्चित्ताचे पापार्पण व निरंतरचे होमार्पण व त्याचे अन्नार्पण, पेयार्पणे ही असावीत. ");
INSERT INTO mar_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","सातव्या महिन्याच्या पंधराव्या दिवशी पवित्र मेळा भरवावा. त्यादिवशी तुम्ही कसलेहि अंगमेहनतीचे काम करू नये आणि परमेश्वरासाठी सात दिवस सण साजरा करावा. ");
INSERT INTO mar_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","तुम्ही होमार्पणे करावीत. ही अग्नीबरोबर करावयाची अर्पणे आहेत. त्यांचा सुवास परमेश्वरास आनंदीत करील. तुम्ही तेरा गोऱ्हे, दोन मेंढे, एकएक वर्षाची नरजातीची चौदा कोकरे, ही दोषरहित असावी. ");
INSERT INTO mar_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","त्याबरोबर तेलात मळलेल्या सपिठाचे अन्नार्पण असावे. तेरा गोऱ्ह्यांपैकी प्रत्येक गोऱ्ह्यामागे तीन दशमांश एफा, दोन मेंढ्यापैकी प्रत्येक मेंढ्याबरोबर दोन दशमांश एफा, ");
INSERT INTO mar_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","आणि चौदा कोकरापैकी प्रत्येक कोकराबरोबर एक दशमांश एफा सपीठ अर्पावे. ");
INSERT INTO mar_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","आणि पापार्पणासाठी एक बकरा अर्पावा. याखेरीज निरंतरचे होमार्पणाव्यातिरिक्त आणि त्याबरोबरच्या अन्नार्पण व त्यांची पेयार्पण ही अर्पणे असावीत. ");
INSERT INTO mar_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","दुसऱ्या दिवशी तुम्ही बारा गोऱ्हे, दोन मेंढे आणि एक वर्षाचे चौदा कोकरे अर्पण करावेत. ती दोषरहित असावी. ");
INSERT INTO mar_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","त्याबरोबर गोऱ्ह्यासाठी, मेंढ्यासाठी आणि कोकरे यांच्याबरोबर तुम्ही योग्य प्रमाणात अन्नार्पण आणि पेयार्पण विधिपूर्वक करावी. ");
INSERT INTO mar_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","आणि पापार्पणासाठी एक बकरा म्हणून द्यावा. याखेरीज निरंतरचे होमार्पण व त्यांची पेयार्पण ही असावीत. ");
INSERT INTO mar_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","तिसऱ्या दिवशी तुम्ही अकरा गोऱ्हे, दोन मेंढे आणि एक वर्षाचे चौदा निर्दोष कोकरे अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","त्याबरोबर गोऱ्ह्यासाठी, मेंढ्यासाठी आणि कोकरे यांच्याबरोबर तुम्ही योग्यप्रमाणात अन्नार्पण व पेयार्पण केले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","पापार्पण म्हणून एक बकराही द्यावा. हे निरंतरचे होमार्पण व अन्नार्पण व त्यांचे पेयार्पणाव्यतिरिक्त असावी. ");
INSERT INTO mar_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","चौथ्या दिवशी तुम्ही दहा गोऱ्हे, दोन मेंढे व एक वर्षाचे चौदा निर्दोष कोकरे अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","गोऱ्हे, मेंढे व कोकरे यांच्याबरोबर तुम्ही योग्यप्रमाणात अन्नार्पण व पेयार्पणही नियमाप्रमाणे करावी. ");
INSERT INTO mar_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","आणि पापार्पणासाठी एक बकरा अर्पावा. याखेरीज निरंतरचे होमार्पण, त्याचे अन्नार्पण व त्याचे पेयार्पण ही असावी. ");
INSERT INTO mar_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","पाचव्या दिवशी तुम्ही नऊ गोऱ्हे, दोन मेंढे व एक वर्षाचे चौदा निर्दोष कोकरे अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","त्या बरोबर गोऱ्ह्यासाठी, मेंढ्यासाठी व कोकरासाठी यांच्याबरोबर तुम्ही योग्यप्रमाणात अन्नार्पण व पेयार्पण विधिपूर्वक करावी. ");
INSERT INTO mar_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","एक बकरा पापार्पणासाठी म्हणून अर्पावा. याखेरीज निरंतरचे होमार्पण व त्याचे अन्नार्पण, त्याचे पेयार्पण ही असावी. ");
INSERT INTO mar_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","सहाव्या दिवशी तुम्ही आठ गोऱ्हे, दोन मेंढे व एक वर्षांचे चौदा निर्दोष कोकरे अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","आणि त्यांबरोबर गोऱ्ह्यासाठी, मेंढ्यासाठी व कोकरासाठी यांच्याबरोबर तुम्ही योग्यप्रमाणात अन्नार्पण, व पेयार्पण विधिपूर्वक करावी. ");
INSERT INTO mar_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","एक बकरा पापार्पण म्हणून अर्पावा. याखेरीज निरंतरचे होमार्पण, अन्नार्पण व त्याचे पेयार्पण ही असावी. ");
INSERT INTO mar_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","सातव्या दिवशी तुम्ही सात गोऱ्हे, दोन मेंढे व एक वर्षांचे चौदा निर्दोष कोकरे अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","त्याबरोबर गोऱ्ह्यासाठी, मेंढ्यासाठी व कोकरासाठी यांच्याबरोबर तुम्ही योग्यप्रमाणात अन्नार्पण व पेयार्पणे नियमपूर्वक करावी. ");
INSERT INTO mar_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","एक बकरा पापार्पण म्हणून अर्पावा. याखेरीज निरंतरचे होमार्पण, अन्नार्पण व त्याचे पेयार्पण अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","आठव्या दिवशी तुमच्यासाठी पवित्र मेळा भरवावा. त्यादिवशी तुम्ही कसलेहि अंगमेहनतीचे काम करू नये. ");
INSERT INTO mar_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","तुम्ही परमेश्वरास मधुर सुवासाचे होमार्पण, अग्नीतून केलेले अर्पण म्हणून तुम्ही एक गोऱ्हा, एक मेंढा व एक एक वर्षाचे सात निर्दोष कोकरे अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","आणि त्याबरोबर गोऱ्ह्यासाठी, मेंढ्यांसाठी व कोकरासाठी त्यांच्या त्यांच्या संख्येप्रमाणे तुम्ही अन्नार्पण व पेयार्पणे विधिपूर्वक अर्पण करावी. ");
INSERT INTO mar_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","एक बकरा पापार्पण म्हणून अर्पावा. याखेरीज निरंतरचे होमार्पण, अन्नार्पण, व त्यांचे पेयार्पण अर्पावा. ");
INSERT INTO mar_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","तुमचे नवस व स्वखुशीचे या व्यतिरिक्त नेमलेल्या सणात हे होमार्पण व पेयार्पण ही नवस व शांत्यर्पणे परमेश्वरास अर्पावी. ");
INSERT INTO mar_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","मोशेने परमेश्वराच्या या सर्व आज्ञा इस्राएल लोकांस सांगितल्या. ");
INSERT INTO mar_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","मोशे इस्राएलाच्या सर्व वंशप्रमुखांशी बोलला. तो म्हणाला, परमेश्वराने जी काही आज्ञा दिली ती ही आहे. ");
INSERT INTO mar_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","जर एखाद्याने परमेश्वरास नवस केला किंवा शपथपूर्वक स्वतःला वचनाने बंधन घालून घेतले तर त्याने ते मोडू नये. जे त्याच्या मुखातून निघाले ते सर्व वचने त्याने पाळावे. ");
INSERT INTO mar_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","एखादी तरुण स्त्री असून तिच्या वडिलांच्या घरात राहत असेल आणि तिने परमेश्वरास खास वस्तू देण्याचे वचन दिले असेल. ");
INSERT INTO mar_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","जर तिच्या वडिलांनी या वचनाबद्दल ऐकले आणि ते सहमत झाले तर त्या स्त्रीने वचनाप्रमाणे केले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","पण जर तिच्या वडिलांनी वचनाबद्दल ऐकले आणि ते सहमत झाले नाहीत तर ती तिच्या वचनातून मुक्त होईल. परमेश्वर तिला क्षमा करील. ");
INSERT INTO mar_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","आणि ती नवऱ्याकडे असता जर तिचे नवस असले किंवा ज्याकडून तिच्या वडिलांनी तिला मना केले म्हणून परमेश्वर तिला माफ करील. ");
INSERT INTO mar_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","तिच्या नवऱ्याने त्या वचनाबद्दल ऐकले आणि तो त्याच्याशी सहमत झाला तर त्या स्त्रीने वचनाची पूर्तता करावी. ");
INSERT INTO mar_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","पण जर नवऱ्याने वचनाबद्दल ऐकले आणि तो सहमत झाला नाहीतर तिला वचन पूर्ण करण्याची गरज नाही. तिच्या नवऱ्याने वचन मोडले. तिने जे सांगितले ते पूर्ण करण्याची त्याने परवानगी दिली नाही म्हणून परमेश्वर तिला क्षमा करील. ");
INSERT INTO mar_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","विधवा किंवा घटस्फोटिता स्त्रीने परमेश्वरास वचन दिले असेल तर तिने वचनाप्रमाणे केले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","आणि जर लग्न झालेल्या स्त्रीने आपल्या पतीच्या घरी राहत असता परमेश्वरास काही नवस केला असेल, ");
INSERT INTO mar_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","तिच्या नवऱ्याने ते ऐकून काही बोलला नाही आणि ते पूर्णता करण्याची त्याने तिला परवानगी दिली तर तिचे नवस कायम राहतील. ");
INSERT INTO mar_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","पण जर तिच्या नवऱ्याने वचनाबद्दल ऐकले आणि त्याने तिला त्याप्रमाणे करण्याची परवानगी दिली नाहीतर तिने वचनाप्रमाणे वागण्याची गरज नाही. तिने काय वचन दिले होते त्यास महत्व नाही. तिचा पती वचन मोडू शकतो. तिच्या नवऱ्याने वचन मोडले तर परमेश्वर तिला क्षमा करील. ");
INSERT INTO mar_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","लग्न झालेल्या स्त्रीने परमेश्वरास काही वचन दिले असेल किंवा काही गोष्टी सोडण्याचे वचन तिने दिले असेल किंवा तिने देवाला काही खास वचन दिले असेल. ");
INSERT INTO mar_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","पती यापैकी कोणत्याही वचनाला मनाई करु शकतो. किंवा त्यापैकी कोणत्याही वचनाची पूर्णता करण्याची परवानगी तो देऊ शकतो. ");
INSERT INTO mar_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","पण त्याने ऐकल्यानंतर पुढे ती रद्द केली तर त्याच्या स्त्रीच्या अपराधांची शिक्षा त्याने भोगावी. ");
INSERT INTO mar_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","परमेश्वराने मोशेला या आज्ञा दिल्या. एक पुरुष आणि त्याची पत्नी यांच्याबद्दलच्या आज्ञा आणि वडील व वडीलांच्या घरी राहणारी मुलगी यांच्याबद्दलच्या या आज्ञा आहेत. ");
INSERT INTO mar_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","परमेश्वर मोशेशी बोलला व म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","इस्राएल लोकांसाठी मिद्यान्याविरूद्ध सूड घे. हे केल्यानंतर तू मरण पावशील आणि त्यानंतर तू तुझ्या लोकांस जाऊन मिळशील. ");
INSERT INTO mar_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","मग मोशे लोकांशी बोलला. तो म्हणाला, तुमच्यातल्या काहींची सैनिक म्हणून निवड करा. परमेश्वर त्यांचा उपयोग मिद्यान्याचा सूड घेण्यासाठी करील. ");
INSERT INTO mar_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","इस्राएलाच्या प्रत्येक वंशातून एक एक हजार लढाईस पाठवा. ");
INSERT INTO mar_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","इस्राएलाच्या हजार आणि हजारांमधून प्रत्येक वंशाचे एक हजार, असे सर्व बारा हजार सैनिक लढाईसाठी पुरवले जातील. ");
INSERT INTO mar_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","मोशेने प्रत्येक वंशातून एक हजार असे बारा हजार लोकांस लढाईवर पाठवले. त्यांना आणि त्यांच्याबरोबर याजक एलाजाराचा मुलगा फिनहासास पवित्र पात्रे व इशारा देण्यासाठी रणशिंगे त्यांच्या हवाली करून पाठवले. ");
INSERT INTO mar_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","मग मोशेने व एलाजार याजकाने मोशेला परमेश्वराने दिलेल्या आज्ञेप्रमाणे मिद्यान्यांबरोबर केले. ");
INSERT INTO mar_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","त्यांनी जे लोक मारले त्यामध्ये अवी, रेकेम, सूर, हूर व रेबा हे मिद्यानाचे राजे होते. त्यांनी बौराचा मुलगा बलामासही तलवारीने मारले. ");
INSERT INTO mar_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इस्राएल लोकांनी मिद्यानाच्या स्त्रियांना व मुलांना कैद करून नेले. त्यांनी त्यांची सर्व गुरे व त्यांचे सर्व कळप व सर्व धन लूट म्हणून त्यांनी घेतले. ");
INSERT INTO mar_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","त्यांनी त्यांची सर्व वस्तीची नगरे व त्यांच्या सर्व छावण्याही जाळल्या. ");
INSERT INTO mar_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","त्यांनी त्यांची सर्व लूट व बंदीवान, दोन्ही लोक आणि जनावरे बरोबर घेतली. ");
INSERT INTO mar_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","यरीहोपाशी यार्देनतीरी मवाबाच्या मैदानातील छावणीत मोशे, याजक एलाजार आणि इस्राएल लोकांच्या मंडळीसमोर त्यांना आणले. ");
INSERT INTO mar_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","नंतर मोशे, याजक एलाजार आणि लोकांचे पुढारी सैनिकांना भेटण्यासाठी छावणीबाहेर त्यांना सामोरे गेले. ");
INSERT INTO mar_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","जे सैनिकांचे सेनापती युद्धावरुन परतले होते एक हजार सैनिकांच्या प्रमुखावर आणि शंभर सैनिकांच्या प्रमुखावर मोशे खूप रागावला. ");
INSERT INTO mar_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","मोशे त्यांना म्हणाला, तुम्ही स्त्रियांना जिवंत का ठेवले? ");
INSERT INTO mar_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","पाहा ह्यांनीच बलामाच्या मसलतीवरून पौराच्या प्रकरणी इस्राएलाच्या वंशाना परमेश्वराविरूद्ध अपराध करायला लावले. यावरुन परमेश्वराच्या मंडळीत मरी पसरली. ");
INSERT INTO mar_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","आताच मिद्यानाच्या सर्व मुलांना ठार मारा आणि पुरुषाबरोबर राहिलेल्या सर्व स्त्रियांना मारून टाका. कोणत्याही पुरुषाबरोबर लैंगिक संबंध असलेल्या सर्व स्त्रियांना मारून टाका. ");
INSERT INTO mar_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","“आणि नंतर तुमच्यापैकी ज्यांनी दुसऱ्यांना मारले असेल त्यांनी सात दिवस तळाच्या बाहेर रहावे. ");
INSERT INTO mar_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","तुम्ही प्रेताला केवळ हात जरी लावला असला तरीही तुम्ही बाहेर रहावे. तिसऱ्या दिवशी तुम्ही स्वत:ला आणि तुमच्या कैद्यांना शुद्ध करा. हीच गोष्ट पुन्हा सातव्या दिवशीही करा. ");
INSERT INTO mar_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","तुम्ही तुमचे सर्व कपडे धुवा. लाकूड, लोकर आणि चामडे यांपासून बनवलेल्या वस्तू धुवा. तुम्ही शुद्ध झालेच पाहिजे.” ");
INSERT INTO mar_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","नंतर याजक एलाजार सैनिकांशी बोलला. तो म्हणाला, “परमेश्वराने मोशेला सांगितले ते हे नियम आहेत. युद्धावरुन परत आलेल्या सैनिकांसाठी हे नियम आहेत. तुम्ही सोने, चांदी, तांबे, ");
INSERT INTO mar_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","पितळ, लोखंड, पत्रा किंवा शिसे वगैरे ");
INSERT INTO mar_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","जे काही अग्नीत टिकेल ते तुम्ही अग्नीत घालून काढा ते शुद्ध होईल: तरी अशुद्धी दूर करण्याच्या पाण्याने ते शुद्ध करावे आणि जे काही अग्नीत टिकणार नाही ते पाण्याने धुवावे. ");
INSERT INTO mar_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","सातव्या दिवशी तुम्ही तुमचे सर्व कपडे धुवा. नंतर तुम्ही शुद्ध व्हाल त्यानंतर तुम्ही तळावर येऊ शकता.” ");
INSERT INTO mar_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","नंतर परमेश्वर मोशेशी बोलला व म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","सैनिकांनी जे कैदी, प्राणी आणि इतर गोष्टी युद्धावरुन आणल्या आहेत त्यांची मोजदाद एलाजार याजक, तू आणि नेत्यांनी करावी. ");
INSERT INTO mar_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","नंतर युद्धावर गेलेल्या सैनिकांत आणि इस्राएलाच्या इतर लोकात त्यांची वाटणी करा. ");
INSERT INTO mar_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","युद्धावर गेलेल्या सैनिकांच्या हिश्श्यातून काही भागातून माणसे, गाईबैल, गाढवे व शेरडेमेंढरे ह्यांच्यापैकी प्रत्येक पाचशेमागे एक परमेश्वराप्रीत्यर्थ कर म्हणून घ्यावा. ");
INSERT INTO mar_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","त्यांच्या हिश्श्यातून घेऊन तो परमेश्वराप्रीत्यर्थ समर्पित अंश म्हणून याजक एलाजाराला द्यावा. ");
INSERT INTO mar_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","“नंतर इस्राएल लोकांस मिळालेल्या हिश्श्यातून माणसे, गाईबैल, गाढवे, शेरडेमेंढरे वगैरे सर्व पशू ह्यांच्यापैकी प्रत्येक पन्नासांमागे एक घेऊन परमेश्वराच्या निवासमंडपाची रक्षण करणाऱ्या लेव्यांना द्यावे.” ");
INSERT INTO mar_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","परमेश्वराने मोशेला आज्ञा केल्याप्रमाणे मोशे आणि एलाजार याजकाने केले. ");
INSERT INTO mar_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","सैनिकांनी लुटून घेतलेल्या वस्तूंशिवाय सहा लक्ष पंचाहत्तर हजार शेरडेमेंढरे, ");
INSERT INTO mar_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","बहात्तर हजार गाईबैल, ");
INSERT INTO mar_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","एकसष्ट हजार गाढवे ");
INSERT INTO mar_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","आणि बत्तीस हजार स्त्रिया आणल्या. (यांत कोणत्याही पुरुषाबरोबर लैंगिक संबंध न आलेल्या स्त्रियांचाच फक्त समावेश आहे). ");
INSERT INTO mar_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","युद्धावर गेलेल्या सैनिकांना तीन लक्ष सदतीस हजार पाचशे मेंढ्या मिळाल्या. ");
INSERT INTO mar_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","त्यांनी सहाशे पंच्याहत्तर मेंढ्या परमेश्वरास दिल्या. ");
INSERT INTO mar_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","गाईबैल छत्तीस हजार असून त्यातील बहात्तर परमेश्वराचा कर होते. ");
INSERT INTO mar_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","सैनिकांना तीस हजार पाचशे गाढवे मिळाली. त्यातील एकसष्ट गाढवे त्यांनी परमेश्वरास दिले. ");
INSERT INTO mar_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","सैनिकांना सोळा हजार स्त्रिया मिळाल्या. त्यांपैकी बत्तीस स्त्रिया त्यांनी परमेश्वरास दिल्या. ");
INSERT INTO mar_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","परमेश्वराने मोशेला आज्ञा केल्याप्रमाणे परमेश्वराप्रीत्यर्थ हा कर समर्पित म्हणून त्याने याजक एलाजाराला दिल्या. ");
INSERT INTO mar_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","नंतर युद्धावर गेलेल्या इस्राएली सैनिकांकडून मोशेने घेतलेला अर्धा भाग होता. ");
INSERT INTO mar_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","लोकांस तीन लक्ष सदतीस हजार पाचशे मेंढ्या. ");
INSERT INTO mar_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","छत्तीस हजार गाईबैल, ");
INSERT INTO mar_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","गाढवे तीस हजार पाचशे ");
INSERT INTO mar_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","आणि सोळा हजार स्त्रिया मिळाल्या. ");
INSERT INTO mar_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","आणि इस्राएलाच्या वंशाच्या अर्ध्या भागातून, मनुष्यातून व जनावरांतून प्रत्येक पन्नास वस्तूमागे मोशेने एक वस्तू परमेश्वरासाठी घेतली. त्यामध्ये पशू आणि माणसे याचा समावेश होता. नंतर त्याने या वस्तू लेवींना दिल्या. कारण त्यांनी परमेश्वराच्या पवित्र निवासमंडपाची काळजी घेतली. ");
INSERT INTO mar_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","नंतर सैनिकांचे पुढारी सहस्त्राधिपती सैनिकांचे व शताधिपती सैनिकांचे पुढारी मोशेकडे आले. ");
INSERT INTO mar_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","त्यांनी मोशेला सांगितले, आम्ही तुझ्या सेवकांनी आमचे सैनिक मोजले. आम्ही एकही सैनिक सोडला नाही. ");
INSERT INTO mar_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","म्हणून आम्ही प्रत्येक सैनिकाकडून परमेश्वराची भेट आणत आहोत. आम्ही सोन्याच्या वस्तू आणत आहोत; बाजूबंद, बांगडया, आंगठ्या, कुड्या आणि हार. ही आम्ही परमेश्वरास अर्पण म्हणून आमच्या जिवासाठी परमेश्वरारासमोर प्रायश्चित करण्याकरता आणली आहेत. ");
INSERT INTO mar_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","मोशे आणि एलाजार याजकाने ते सर्व सोने व घडीव वस्तू त्यांच्याकडून स्विकारल्या. ");
INSERT INTO mar_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","सहस्त्रपती आणि शतपती ह्यांनी परमेश्वरास समर्पण केलेले सोने सोळा हजार सातशे शेकेल भरले. ");
INSERT INTO mar_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","सैनिकांनी त्यांना युद्धात मिळालेल्या इतर वस्तू स्वतःजवळ ठेवल्या. ");
INSERT INTO mar_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","मोशे आणि एलाजार याजक यांनी हजार आणि शंभर सैनिकांवरच्या प्रमुखांकडून सोने घेऊन इस्राएल लोकांसाठी परमेश्वरासमोर स्मारक म्हणून दर्शनमंडपामध्ये नेऊन ठेवले. ");
INSERT INTO mar_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","रऊबेन आणि गाद या घराण्यांकडे गुरांढोरांची खूप खिल्लारे होते. त्यांनी याजेर व गिलाद येथील जमिनी पाहिल्या. ही जमीन आपल्या गुरांढोरांसाठी चांगली आहे असे त्यांना वाटले. ");
INSERT INTO mar_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","म्हणून रऊबेन व गाद यांच्या घराण्यातील लोक मोशेकडे आले. ते मोशे, याजक एलाजार आणि लोकांचे पुढारी यांच्याशी बोलले. ");
INSERT INTO mar_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","अटारोथ, दीबोन, याजेर, निम्रा, हेशबोन, एलाले, सबाम, नबो व बौन. ");
INSERT INTO mar_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ह्यांचा जो प्रांत परमेश्वराने इस्राएलाच्या लोकांसाठी देवाने जी जमीन जिंकली ती गुरांढोरांसाठी खूप चांगली आहे आणि तुझ्या दासांजवळ गुरेढोरे आहेत. ");
INSERT INTO mar_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","जर आम्हावर तुझी कृपादृष्टी असेल तर तो प्रदेश आम्हास वतन करून देण्यात यावा. आम्हास यार्देन नदीच्या पलिकडे नेऊ नको. ");
INSERT INTO mar_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","रऊबेन आणि गादच्या घराण्यातील लोकांस मोशे म्हणाला, तुमचे भाऊबंद लढाईस जातील तेव्हा तुम्ही येथेच बसून राहणार का? ");
INSERT INTO mar_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","जो देश परमेश्वराने इस्राएल लोकांस दिला आहे तेथे उतरून जाण्याकरता त्यांचे मन का निरूत्साहित करीत आहात? ");
INSERT INTO mar_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","तुमच्या वाडवडिलांनी हीच गोष्ट माझ्याबाबतीत केली होती. कादेश-बर्ण्याला मी काही हेरांना जमीन बघण्यासाठी पाठवले. ");
INSERT INTO mar_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ते लोक अष्कोल खोऱ्यापर्यंत गेले. त्यांनी जमीन बघितली आणि त्या लोकांनी इस्राएल लोकांस परमेश्वराने दिलेल्या प्रदेशात जाण्याच्या इच्छेपासून परावृत केले. ");
INSERT INTO mar_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","परमेश्वर त्या लोकांवर खूप रागावला. त्याने शपथ घेतली आणि म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","मिसर देशातून आलेल्या वीस वर्षांवरील कोणत्याही मनुष्यास हा प्रदेश बघू दिला जाणार नाही. मी अब्राहाम, इसहाक व याकोब यांना वचन दिले होते. त्यांना मी ही जमीन द्यायचे कबूल केले होते. परंतु त्यांनी मला मनापासून अनुसरले नाही. म्हणून त्यांना हा प्रदेश मिळणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","फक्त कनिज्जी यफुन्नेचा मुलगा कालेब आणि नूनाचा मुलगा यहोशवा हे मनापासून परमेश्वरास अनुसरले. ");
INSERT INTO mar_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","परमेश्वर इस्राएल लोकांवर खूप रागावला होता. परमेशवराच्यादृष्टीने त्यांनी वाईट कृत्ये केली त्यांची सर्व पिढी नष्ट होईपर्यंत त्यांना चाळीस वर्षे रानात भटकावयास लावले. ");
INSERT INTO mar_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","आणि आता तुमच्या वाडवडिलांनी जी गोष्ट केली तीच तुम्ही करीत आहात. पाप्यांनो परमेश्वराने त्याच्या इस्राएल लोकांवर आणखी रागवावे अशी तुमची इच्छा आहे का? ");
INSERT INTO mar_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","जर तुम्ही परमेश्वराची भक्ति करायचे सोडले तर परमेश्वर इस्राएल लोकांस अधिक काळ रानात ठेवील आणि नंतर तुम्ही त्या सर्व लोकांचा नाश कराल. ");
INSERT INTO mar_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","पण रऊबेनाच्या आणि गादच्या घराण्यातील लोक मोशेकडे गेले. ते म्हणाले, आम्ही या जागेवर आमच्या मुलांसाठी शहरे आणि आमच्या जनावरांसाठी गोठे उभारू. ");
INSERT INTO mar_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","त्यामुळे आमची मुले याठिकाणी वस्ती करणाऱ्या इतर लोकांपासून सुरक्षित राहतील. पण आम्ही इस्राएलाच्या इतर लोकांस मदत करण्यासाठी आनंदाने येऊ. आम्ही त्यांना त्यांच्या प्रदेशात आणू. ");
INSERT INTO mar_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","इस्राएलातील प्रत्येकाला त्याचे वतन मिळाल्याशिवाय आम्ही परतणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","यार्देनेच्या अलीकडे पूर्वेस आम्हास आमचे वतन प्राप्त झाले म्हणून आम्ही यार्देनेच्या पलीकडे व पुढे त्यांच्याबरोबर वतन घेणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","तेव्हा मोशे त्यांना म्हणाला, जर तुम्ही या सर्व गोष्टी केल्या तर हा प्रदेश तुमचा होईल. परंतु तुमच्या सैनिकांनी परमेश्वरासमोर लढाईत उतरले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","आणि तो आपणापुढून आपले शत्रू वतनातून घालवीन आणि देश परमेश्वरापुढे हस्तगत होईल तुमच्या सैन्याने यार्देन नदी पार करून शत्रू सैन्याला या प्रदेशातून हाकलले पाहीजे. ");
INSERT INTO mar_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","आणि तर तो देश त्याच्या ताब्यात आल्यावर तुम्ही परत याल. नंतर परमेश्वराकडे आणि इस्राएलाकडे तुम्ही निरपराधी असाल. तर हा देश परमेश्वरापुढे तुमचे वतन असा होईल. ");
INSERT INTO mar_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","पण जर तुम्ही या गोष्टी केल्या नाहीत तर तुम्ही परमेश्वराविरूद्ध पाप कराल आणि तुमच्या पापाबद्दल तुम्हास शासन होईल याची खात्री बाळगा. ");
INSERT INTO mar_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","तुमच्या मुलांसाठी शहरे वसवा आणि जनावरांसाठी गोठे बांधा. पण तुम्ही वचन दिल्याप्रमाणे सारे काही करा. ");
INSERT INTO mar_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","नंतर रऊबेन आणि गादच्या कुटुंबातील लोक मोशेला म्हणाले, आम्ही तुझे नोकर आहोत. तू आमचा मालक आहेस म्हणून तू जे सांगतोस ते आम्ही करु. ");
INSERT INTO mar_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","आमच्या स्त्रिया, मुले, शेरडेमेंढरे आणि सर्व गुरेढोरे गिलाद शहरात राहतील. ");
INSERT INTO mar_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","पण आम्ही, तुझे नोकर यार्देन नदी पार करु. आम्ही परमेश्वरापुढे लढाईस जाऊ. जसे आमचा धनी सांगत आहे. ");
INSERT INTO mar_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","याप्रमाणे त्यांनी वचन दिले. ते मोशे, याजक एलाजार, नूनाचा मुलगा यहोशवा आणि इस्राएलचे सर्व वंशाचे प्रमुख या सर्वांनी ते ऐकले. ");
INSERT INTO mar_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","मोशे त्यांना म्हणाला, गाद आणि रऊबेनचे लोक यार्देन नदी पार करतील. ते लढाईत परमेश्वराच्यापुढे चालतील. ते तुम्हास प्रदेश जिंकायला मदत करतील आणि तुम्ही गिलादाचा प्रदेश त्यांच्या वाटेचा भाग म्हणून द्याल. ");
INSERT INTO mar_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","पण ते तुमच्या सैन्याबरोबर जाण्यात अपयशी ठरले तर कनानमध्ये तुमच्यामध्ये त्यांना वतन मिळेल. ");
INSERT INTO mar_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","गाद आणि रऊबेनच्या लोकांनी उत्तर दिले व म्हणाले, “आम्ही परमेश्वराच्या आज्ञेप्रमाणे सर्वकाही करण्याचे वचन देतो.” ");
INSERT INTO mar_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","आम्ही स्वतः सशस्र होऊन परमेश्वरापुढे पलीकडे कनान देशात जाऊ. पण आमचे वतन यार्देन नदीच्या पूर्वेला असावे. ");
INSERT INTO mar_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","तेव्हा मोशेने गादाचे वंशज, रऊबेनाचे वंशज आणि योसेफाचा मुलगा मनश्शे याचा अर्धा वंश अमोऱ्याचा राजा सीहोन याच्या राज्याचा व बाशानाचा राजा ओग याच्या राज्याचा देश दिला. देश, नगरे व त्यामध्ये आजुबाजूच्या प्रदेशातील नगरे दिली. ");
INSERT INTO mar_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","गादच्या लोकांनी दीबोन, अटारोथ, अरोएर, ");
INSERT INTO mar_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अटारोथ-शोफान, याजेर यागबहा, ");
INSERT INTO mar_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बेथ-निम्रा आणि बेथ-हारान ही शहरे वसवली. त्यांनी शहराभोवती तटबंदी उभारली आणि त्यांच्या जनावरांसाठी गोठे बांधले. ");
INSERT INTO mar_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","रऊबेनच्या लोकांनी हेशबोन, एलाले, किर्याथाईम. ");
INSERT INTO mar_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","नबो व बाल-मौन आणि सिब्मा ही शहरे वसवली. त्यांनी पुन्हा वसवलेल्या शहरांना जुनीच नावे दिली. पण नेबो आणि बाल-मोनचे नांव त्यांनी बदलले. ");
INSERT INTO mar_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","माखीरच्या कुटुंबातील लोक गिलादाला गेले माखीर मनश्शेचा मुलगा होता. त्यांनी त्या शहराचा पराभव केला. तेथे राहणाऱ्या अमोरी लोकांस घालवले. ");
INSERT INTO mar_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","मोशेने गिलाद मनश्शेच्या कुटुंबातील माखीराला दिले. म्हणून त्याचे कुटुंब तेथे राहिले. ");
INSERT INTO mar_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","मनश्शेच्या कुटुंबातील याईर याने छोट्या शहरांचा पराभव केला. नंतर त्याने त्यांना याईराची शहरे असे म्हटले. ");
INSERT INTO mar_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","नोबाहाने कनाथ व त्याच्या आसपासच्या छोट्या शहरांचा पराभव केला. नंतर त्याने त्या जागेला आपले नाव दिले. ");
INSERT INTO mar_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","मोशे आणि अहरोन ह्यांच्या नेतृत्वाखाली इस्राएल लोक सैन्याप्रमाणे मिसर देशामधून टोळ्यांनी बाहेर पडले. तेव्हा त्यांचे मुक्काम झाले ते हे आहेत. ");
INSERT INTO mar_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","परमेश्वराने आज्ञा केल्याप्रमाणे ते कोठून निघाले ते कोठे गेले. त्यांच्या मजला त्यांच्या मुक्कामाप्रमाणे मोशेने लिहिल्या त्या या. ");
INSERT INTO mar_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","पहिल्या महिन्याच्या पंधराव्या दिवशी त्यांनी रामसेस सोडले. वल्हांडणाच्या दुसऱ्या दिवशी इस्राएलचे लोक विजयोत्सवात हात वर करून बाहेर पडले. मिसर देशाच्या सगळ्या लोकांनी त्यांना पाहिले. ");
INSERT INTO mar_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","मिसर देशाचे लोक परमेश्वराने मारलेल्या लोकांचे दफन करीत होते. ते त्यांच्या पहिल्या मुलांचे दफन करीत होते. परमेश्वराने मिसर देशाच्या देवतांना कडक शासन केले. ");
INSERT INTO mar_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","इस्राएल लोकांनी रामसेस सोडले आणि ते सुक्कोथाला गेले. ");
INSERT INTO mar_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ते सुक्कोथाहून एथामाला गेले. लोकांनी तेथे रानाच्या काठावर तंबू दिले. ");
INSERT INTO mar_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","त्यांनी एथाम सोडले आणि ते पीहहीरोथला गेले. ते बआल-सफोन जवळ होते. लोकांनी मिग्दोलासमोर तंबू दिले. ");
INSERT INTO mar_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","मग लोकांनी पीहहीरोथहून कूच करून आणि ते समुद्र ओलांडून रानात गेले. आणि एथाम रानात तीन दिवसाची मजल करून त्यांनी मारा येथे तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","लोकांनी मारा सोडले व ते एलिमाला जाऊन राहिले. तिथे बारा पाण्याचे झरे होते आणि सत्तर खजुराची झाडे होती. ");
INSERT INTO mar_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","लोकांनी एलिम सोडले व त्यांनी तांबड्या समुद्राजवळ तंबू दिले. ");
INSERT INTO mar_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","त्यांनी तांबडा समुद्र सोडला आणि सीन रानात तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","सीन रान सोडून ते दफका येथे तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","लोकांनी दफका सोडले व ते आलूश येथे राहिले. ");
INSERT INTO mar_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","लोकांनी आलूश सोडले व रफीदिमला तळ दिला. त्या जागी पिण्यासाठी पाणी नव्हते. ");
INSERT INTO mar_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","लोकांनी रफीदिम सोडले व त्यांनी सीनाय रानात तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","त्यांनी सीनाय वाळवंट सोडले व किब्रोथ-हत्तव्वा येथे तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","किब्रोथ-हत्तव्वा येथून ते हसेरोथला राहिले. ");
INSERT INTO mar_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","हसेरोथ येथून त्यांनी रिथमाला तंबू दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","रिथमा सोडून ते रिम्मोन-पेरेसला आले. ");
INSERT INTO mar_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","रिम्मोन-पेरेस सोडल्यावर त्यांनी लिब्नाला तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","लोकांनी लिब्ना सोडले व रिस्सा येथे तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","रिस्सा सोडून ते कहेलाथा येथे तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","लोकांनी कहेलाथा सोडले व त्यांनी शेफेर पर्वतावर तंबू ठोकले. ");
INSERT INTO mar_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","शेफेर पर्वत सोडून लोक हरादांत आले. ");
INSERT INTO mar_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","लोकांनी हरादा सोडले व मकहेलोथ येथे तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","मकहेलोथ सोडून ते तहथाला आले. ");
INSERT INTO mar_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","लोकांनी तहथा सोडले व ते तारहला आले. ");
INSERT INTO mar_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","तारह सोडून त्यांनी मिथकाला तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","लोकांनी मिथका सोडले व हशमोना येथे तंबू दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","हशमोना सोडून ते मोसेरोथला आले. ");
INSERT INTO mar_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","त्यांनी मोसेरोथ सोडले व बनेयाकानाला तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","बनेयाकान सोडून ते होर-हागिदगादला आले. ");
INSERT INTO mar_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","होर-हागिदगाद सोडून त्यांनी याटबाथाला तंबू ठोकले. ");
INSERT INTO mar_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","याटबाथा येथून ते अब्रोनाला आले. ");
INSERT INTO mar_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","अब्रोनाहून त्यांनी एसयोन-गेबेर येथे तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","लोकांनी एसयोन-गेबेर सोडले व त्यांनी त्सीन रानात कादेश येथे तंबू दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","लोकांनी कादेश सोडले व त्यांनी होरला तंबू ठोकले. अदोम देशाच्या सीमेवरील हा एक पर्वत होता. ");
INSERT INTO mar_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","याजक अहरोनाने परमेश्वराची आज्ञा पाळली व तो होर पर्वतावर गेला. अहरोन त्याजागी मरण पावला. हा इस्राएल लोकांनी मिसर देश सोडल्याचा चाळीसाव्या वर्षाच्या पाचव्या महिन्याचा पहिला दिवस होता. ");
INSERT INTO mar_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","अहरोन होर पर्वतावर मेला तेव्हा तो एकशे तेवीस वर्षाचा होता. ");
INSERT INTO mar_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","कनान देशातील नेगेब जवळ अराद शहर होते. अराद येथे असलेल्या कनानी राजाने इस्राएलचे लोक येत असल्याबद्दल ऐकले. ");
INSERT INTO mar_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","लोकांनी होर पर्वत सोडला व सलमोनाला तंबू दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","त्यांनी सलमोना सोडले व ते पूनोनला आले. ");
INSERT INTO mar_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","पूनोन सोडून त्यांनी ओबोथाला तळ दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","लोकांनी ओबोथ सोडले व ते इये-अबारीमाला आले. हे मवाब देशाच्या सीमेवर होते. ");
INSERT INTO mar_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","मग ईयीमाहून (इये-अबारिम) ते दीबोन-गादला आले. ");
INSERT INTO mar_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","लोकांनी दीबोन-गाद सोडले व अलमोन-दिलाथाईमाला आले. ");
INSERT INTO mar_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","अलमोन-दिलाथाईमहून त्यांनी नबोजवळच्या अबारीम पर्वतावर तंबू दिला. ");
INSERT INTO mar_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","लोकांनी अबारीम पर्वत सोडला व ते यार्देन खोऱ्यातल्या मवाब येथे आले. हे यरीहोच्या समोर यार्देन नदीजवळ होते. ");
INSERT INTO mar_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","त्यांनी मवाबाच्या मैदानात यार्देनतीरी त्यांचे तंबू बेथ-यशिमोथापासून आबेल-शिट्टीमापर्यंत होते. ");
INSERT INTO mar_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","आणि मवाबाच्या मैदानामध्ये यार्देनेपाशी यरीहोजवळ परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","इस्राएल लोकांशी बोल, त्यांना या गोष्टी सांग, तुम्ही यार्देन नदी पार कराल. तुम्ही कनान देशात जाल. ");
INSERT INTO mar_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","तिथे जे लोक तुम्हास आढळतील त्यांना देशातून घालवा. तेव्हा तुम्ही त्यांच्या कोरीव पुतळयांचा आणि मूर्तीचा नाश करा. त्यांच्या उंचावरच्या पुजेच्या ठिकाणांचा नाश करा. ");
INSERT INTO mar_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","तुम्ही तो प्रदेश घ्या आणि तिथेच रहा. कारण मी हा देश तुम्हास वतन करून दिला आहे. ");
INSERT INTO mar_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","तुमच्यातील प्रत्येक कुळाने चिठ्ठ्या टाकून देश वतन करून घ्या. मोठ्या कुळाला जमिनीचा मोठा भाग मिळेल. लहान कुळाला लहान भाग मिळेल. एखाद्या ठिकाणासाठी ज्याच्या नावाची चिठ्ठी निघेल ते त्याचे वतन होईल. आपआपल्या वाडवडिलांच्या वंशाप्रमाणे तुम्हास वतन मिळेल. ");
INSERT INTO mar_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","परंतु तुम्ही आपणापुढून त्या देशात राहणाऱ्यांना बाहेर घालवले नाही जर तुम्ही त्यांना तिथेच राहू दिले तर ते तुम्हास डोळ्यातील कुसळासारखे तुमच्या कुशीत काट्यासारखे बोचतील. तुम्ही ज्या देशात रहाल त्या देशात ते अनेक संकटे आणतील. ");
INSERT INTO mar_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","मी तुमच्याबाबत काय करणार आहे ते मी तुम्हास दाखवले आहे. आणि जर तुम्ही त्यांना त्या देशात राहू दिले तर मी ते सर्व तुमच्याबाबतीत करीन. ");
INSERT INTO mar_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","परमेश्वर मोशेशी बोलला व म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","इस्राएल लोकांस ही आज्ञा दे आणि त्यांना सांग, तुम्ही कनान देशात येत आहात. तुम्ही त्या देशाचा पराभव करा. तुम्ही सर्व कनान देश घ्या. ");
INSERT INTO mar_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","दक्षिणेकडे अदोमाजवळच्या त्सीन रानाचा काही भाग तुम्हास मिळेल. तुमची दक्षिणेकडची सीमा मृत समुद्राच्या दक्षिण टोकापासून सुरु होईल. ");
INSERT INTO mar_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","तेथून अक्रब्बीम चढावाचे दक्षिण टोक पार करून ती त्सीन रानातून कादेश-बर्ण्याला जाईल. आणि नंतर हसर-अद्दारपर्यंत जाऊन असमोनाला पोहोचेल. ");
INSERT INTO mar_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","असमोनाहून ती मिसर देशाच्या नदीपर्यंत जाईल आणि समुद्रात तिची समाप्ती होईल. ");
INSERT INTO mar_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","तुमची पश्चिमेकडची सीमा म्हणजे महासमुद्र व त्याचा किनारा राहिल तीच तुमची पश्चिम सीमा आहे. ");
INSERT INTO mar_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","तुमची उत्तरेकडची सीमा महासमुद्रात सुरु होईल व होर पर्वताकडे एक रेषा आंखावी. ");
INSERT INTO mar_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","होर पर्वतावरुन ती लेबो हमाथाला जाईल व तेथून सदादला. ");
INSERT INTO mar_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","नंतर ती सीमा जिप्रोनला जाईल व हसर-एनानला ती संपेल. तेव्हा ती तुमची उत्तर सीमा. ");
INSERT INTO mar_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","तुमची पूर्व सीमा हसर-एनानजवळ सुरु होईल व ती शफामपर्यंत जाईल. ");
INSERT INTO mar_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","शफामपासून ती अईनाच्या पूर्वेकडे रिब्लाला जाईल. ती सीमा उतरत किन्नेरेथ समुद्राच्या पूर्वेकडील किनाऱ्याच्या पर्वतांच्या रांगापर्यंत जाईल. ");
INSERT INTO mar_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","आणि नंतर ती यार्देन नदीच्या काठाने जाऊन मृतसमुद्रात तिची समाप्ती होईल. तुझ्या देशाच्या या सीमा आहेत. ");
INSERT INTO mar_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","तेव्हा मोशेने इस्राएल लोकांस आज्ञा केली व म्हणाला की, चिठ्ठ्या टाकून ज्या देशाचे वतन तुम्हास मिळणार आहे. म्हणजे साडे नऊ वंशाना जो देश देण्याचे परमेश्वराने देण्याचे ठरविले आहे तो हाच. ");
INSERT INTO mar_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","रऊबेन आणि गादची वंश आणि मनश्शेच्या अर्ध्या वंशानी आधीच त्यांचे वतन घेतले आहे. ");
INSERT INTO mar_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","त्या अडीच वंशानी यरीहोजवळ यार्देन नदीच्या पूर्वेकडचे वतन मिळाले आहे. ");
INSERT INTO mar_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","नंतर परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","जो पुरुष हा देश तुम्हास वतन म्हणून वाटून देणार आहे तो याजक एलाजार आणि नूनाचा मुलगा यहोशवा. ");
INSERT INTO mar_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","प्रत्येक वंशाचा एक प्रमुख वतन म्हणून देशाची विभागणी करण्यास घ्यावा. ");
INSERT INTO mar_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","त्या मनुष्यांची नावे ही आहेत यहूदाच्या वंशातला, यफुन्नेचा मुलगा कालेब. ");
INSERT INTO mar_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","शिमोनाच्या वंशातील, अम्मीहुदाचा मुलगा शमुवेल. ");
INSERT INTO mar_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","बन्यामिनाच्या वंशातील, किसलोनाचा मुलगा अलीदाद. ");
INSERT INTO mar_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","दानी वंशातील, सरदार यागलीचा मुलगा बुक्की. ");
INSERT INTO mar_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","योसेफाच्या वंशातील, सरदार मनश्शेच्या वंशातील, एफोदाचा मुलगा हन्नीएल. ");
INSERT INTO mar_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","एफ्राईम वंशातील, सरदार शिफटानाचा मुलगा कमुवेल. ");
INSERT INTO mar_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","जबुलून वंशातील सरदार पनीकाचा मुलगा अलीसाफान. ");
INSERT INTO mar_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इस्साखार वंशातील सरदार अज्जानाचा मुलगा पलटीयेल. ");
INSERT INTO mar_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आशेरी वंशातील सरदार शलोमीचा मुलगा अहीहूद. ");
INSERT INTO mar_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","आणि नफताली वंशातील सरदार अम्मीहुदाचा मुलगा पदाहेल. ");
INSERT INTO mar_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","परमेश्वराने कनानाच्या भूमीची इस्राएल लोकांमध्ये वाटणी करण्यासाठी या मनुष्यांची निवड केली. ");
INSERT INTO mar_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","परमेश्वर मोशेशी बोलला. हे मवाबामधील यार्देनाच्या खोऱ्यात यरीहोसमोर यार्देन नदीजवळ घडले. परमेश्वर म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","इस्राएल लोकांस सांग की, त्यांनी त्यांच्या वतनातील काही नगरे लेवी लोकांस द्यावी. इस्राएल लोकांनी काही नगरे आणि त्याच्या आजूबाजूची कुरणे लेवी लोकांस द्यावी. ");
INSERT INTO mar_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","लेवी लोक त्या नगरात राहतील आणि लेवी लोकांची कुरणे गाईबैल आणि शेरडेमेंढरे इत्यादी जनावरांसाठी असावीत. ");
INSERT INTO mar_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","आणि नगराची जी कुरणे लेव्यांना जी गायराने द्याल ती हजार हात सभोवार असावी. ");
INSERT INTO mar_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","नगरांच्या तटबंदी बाहेर पूर्व बाजूस दोन हजार हात, दोन हजार हात दक्षिणेला, दोन हजार हात पश्चिमेला आणि दोन हजार हात उत्तर बाजूस मोजावे. नगर मध्ये असावे. ");
INSERT INTO mar_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","त्यापैकी सहा शहरे शरणपुरे असतील. जर एखाद्या मनुष्याने चुकून कुणाला मारले तर तो मनुष्य संरक्षणासाठी त्या शहरात जाऊ शकतो. त्या सहा शहरांखेरीज आणखी बेचाळीस नगरे तुम्ही लेवींना द्या. ");
INSERT INTO mar_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","म्हणजे तुम्ही एकूण अठ्ठेचाळीस नगरे लेवींना द्या. त्या शहरांभोवतालची जमीनही तुम्ही लेवींना द्या. ");
INSERT INTO mar_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","इस्राएलाच्या मोठ्या कुटुंबांना वतनाचे मोठे तुकडे मिळतील आणि लहान वतनातून कमी अशी द्यावीत. प्रत्येक वंशाने आपआपल्या वतनाच्या मानाने लेव्यांना नगरे द्यावी. ");
INSERT INTO mar_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","नंतर परमेश्वर मोशेशी बोलला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","इस्राएलाच्या वंशाशी बोल, त्यांना या गोष्टी सांग, तुम्ही लोक यार्देन नदी पार करून कनानच्या प्रदेशात जाल. ");
INSERT INTO mar_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","तेव्हा तुम्ही शरणपुरे निवडा. जर एखाद्याने चुकून कुणाला ठार मारले तर तो संरक्षणासाठी त्यापैकी एखाद्या शहरात जाऊ शकतो. ");
INSERT INTO mar_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","आणि ती नगरे सूड घेणाऱ्यापासून आश्रयासाठी असावी. त्या मनुष्याचा न्याय होईपर्यंत तो तेथे सुरक्षित राहू शकतो. ");
INSERT INTO mar_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","अशी सहा संरक्षक शहरे असतील. ");
INSERT INTO mar_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","यापैकी तीन शहरे यार्देन नदीच्या पूर्वेला असतील आणि तीन शहरे कनानाच्या प्रदेशात यार्देन नदीच्या पश्चिमेला असतील ती तुम्ही आश्रयाची नगरे म्हणून द्या. ");
INSERT INTO mar_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ही शहरे इस्राएलाच्या नागरिकांसाठी, परदेशी नागारिकासाठी आणि प्रवाशांसाठी शरणपुरे असतील. यांच्यापैकी कोणीही चुकून कुणाला ठार मारले तर ते संरक्षणसाठी या शहरात जाऊ शकतात. ");
INSERT INTO mar_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","जर एखादा मनुष्य कुणाला मारण्यासाठी लोखंडी शस्त्राचा उपयोग करत असेल तर त्याने मरण पावले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","आणि जर एखाद्याने दगड घेऊन कुणाला मारले तर त्यानेसुध्दा मरण पावले पाहिजे. पण त्या दगडाचा आकार एखाद्याला मारण्यासाठी वापरण्यात येणाऱ्या दगडाएवढा असला पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","आणि जर एखादा मनुष्य कुणाला मारण्यासाठी लाकडाच्या तुकड्याचा उपयोग करीत असेल तर तो मनुष्य सुद्धा मेला पाहीजे. हा लाकडाचा तुकडा म्हणजे सामान्यतः कोणाला तरी मारण्यासाठी उपयोगात आणतात तसे लाकडाचे शस्त्र असले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","मरण पावलेल्या मनुष्याच्या कुटुंबातील कोणीही त्या खुन्याचा पाठलाग करून त्यास ठार मारू शकतो. ");
INSERT INTO mar_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","मनुष्य एखाद्याला हाताने मारून सुद्धा ठार मारू शकतो. किंवा एखाद्याला ढकलून देऊन सुद्धा ठार मारू शकतो. किंवा कोणाला काही फेकून मारून सुद्धा त्यास ठार करु शकतो. ");
INSERT INTO mar_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","जर कोणी ते हेतूपूर्वक द्वेषबुद्धीने केले असेल तर तो खुनी ठरतो. त्या मनुष्यास ठार मारलेच पाहिजे. मरण पावलेल्या मनुष्याच्या कुटुंबातील कोणीही त्या खुन्याचा पाठलाग करून त्यास मारु शकतो. ");
INSERT INTO mar_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","एखादा मनुष्य अपघाताने दुसऱ्याला मारू शकेल. मरण पावलेल्या मनुष्याचा त्याने द्वेष केला नाही त्यास त्याने चुकून मारले असेल. किंवा त्याने एखादी वस्तू चुकून फेकली असेल आणि ती चुकून एखाद्याला लागून तो मेला तर त्याने ते विचारपूर्वक केले असे नाही. ");
INSERT INTO mar_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","किंवा एखाद्या मनुष्याने दगड फेकला आणि तो त्यास न दिसलेल्या मनुष्यास लागला व तो मेला तर त्या मनुष्याने योजनापूर्वक मारले असे नाही. तो मनुष्य मरण पावलेल्या मनुष्याचा द्वेष करत नव्हता. तो केवळ योगायोगाने मेला. ");
INSERT INTO mar_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","जर असे घडले तर काय करायचे ते लोकांनी ठरवायचे. मरण पावलेल्या मनुष्याच्या कुटुंबातील एखादा मनुष्य त्यास मारु शकतो की नाही ते लोक न्यायालयाने ठरवायचे. ");
INSERT INTO mar_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","जर लोकांनी खुन्याचे त्या कुटुंबापासून रक्षण कराचये असे ठरवले तर लोकांनी खुन्याला संरक्षक शहरात परत न्यावे आणि पवित्र तेलाने अभिषेक केलेला मुख्य याजक मरत नाही तोपर्यंत खुन्याने तिथेच रहावे. ");
INSERT INTO mar_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","त्या मनुष्याने संरक्षक शहराच्या बाहेर जायचे नाही. जर त्याने त्या सीमा ओलांडल्या ");
INSERT INTO mar_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","आणि आश्रयाच्या नगराच्या सीमेबाहेर मृत मनुष्याच्या कुटुंबाने त्यास पकडले आणि मारले तर त्या कुटुंबातील तो मनुष्य खुनाचा अपराधी ठरणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","एखाद्या मनुष्याने चुकून कोणाला मारले असेल तर त्याने मुख्य याजक मरेपर्यंत शरणपुरातच राहिले पाहिजे. मुख्य याजक मेल्यानंतर तो मनुष्य त्याच्या स्वत:च्या प्रदेशात जाऊ शकतो. ");
INSERT INTO mar_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","तुम्हा लोकांच्या सर्व शहरांमध्ये हाच नियम सदैव लागू राहील. ");
INSERT INTO mar_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","मारणाऱ्याला मरणाची शिक्षा जर साक्षीदार असेल तरच दिली जाईल. जर एकच साक्षीदार असेल तर कोणालाही मरणाची शिक्षा दिली जाणार नाही. ");
INSERT INTO mar_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","जर एखाद्या मनुष्यावर खुनाचा दोष असेल तर त्यास मारलेच पाहिजे. पैसे घेऊन त्याची शिक्षा बदलू नका, त्या खुन्याला आवश्य जीवे मारावे. ");
INSERT INTO mar_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","जर एखाद्याने कुणाला मारले आणि तो संरक्षक शहरात पळून गेला तर घरी जाण्यासाठी त्याच्याकडून पैसे घेऊ नका. मुख्य याजक मरेपर्यंत त्याने शरणापुरातच राहिले पाहिजे. ");
INSERT INTO mar_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ज्या देशात तुम्ही रहाल तो भ्रष्ट करू नका. कारण खुनाने देश भ्रष्ट होतो आणि रक्तपात केल्याशिवाय देशाबद्दल म्हणजे त्या देशात झालेल्या रक्तपाताबद्दल प्रायश्चित होऊ शकत नाही. ");
INSERT INTO mar_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","मी परमेश्वर आहे. मी तुमच्या देशात इस्राएल लोकांबरोबर राहीन. मी तिथे राहणार आहे. म्हणून ती जागा निष्पाप लोकांच्या रक्ताने अशुद्ध करु नका. ");
INSERT INTO mar_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","नंतर योसेफवंशाच्या कुळातला मनश्शेचा मुलगा माखीर याचा मुलगा गिलाद याच्या वंशातल्या घराण्यातील प्रमुख जवळ आले ते मोशेपुढे व इस्राएल लोकांच्या घराण्यातील प्रमुखांशी बोलायला गेले. ");
INSERT INTO mar_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","ते म्हणाले, परमेश्वराने इस्राएलाला चिठ्ठ्या टाकून आमचे वतन घेण्याची आमच्या स्वामींना आज्ञा केली आहे. याप्रकारे परमेश्वराने सलाफहादची जमीन त्याच्या मुलींना द्यायची आज्ञा केली आहे. सलाफहाद आमचा भाऊ होता. ");
INSERT INTO mar_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","आता जर त्या इस्राएलाच्या वंशातल्या दुसऱ्या कोणत्याही वंशांच्या मुलाशी विवाह केला तर त्यांचे वतन आमच्या वडिलांच्या वतनातून त्यांचा हिस्सा काढून घेतला जाईल. ");
INSERT INTO mar_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","आणि जेव्हा इस्राएलाच्या वंशाचे योबेल होईल तेव्हा ज्यांच्या त्या होतील त्यांच्या वंशाच्या वतनात त्यांचे वतन मिळवले जाईल, अशाने त्यांचे वतन आमच्या वडिलांच्यावंशाच्या वतनातून काढून टाकले जाईल. ");
INSERT INTO mar_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","मोशेने परमेश्वराच्या सांगण्यावरून इस्राएल लोकांस ही आज्ञा दिली, तो म्हणाला, योसेफाच्या वंशाचे म्हणणे बरोबर आहे. ");
INSERT INTO mar_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","सलाफहादाच्या मुलींसाठी परमेश्वराची ही आज्ञा आहे: जर तुम्हास कोणाशी लग्न करायचे असेल तर तुम्ही तुमच्या वंशातील कोणाशी तरी लग्न करा. ");
INSERT INTO mar_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","यामुळे इस्राएल लोकांमध्ये वतन एका वंशाकडून दुसऱ्या वंशाकडे जाणार नाही. आणि प्रत्येक इस्राएली मनुष्यास त्याच्या पूर्वजांकडून मिळालेले वतन ठेवता येईल. ");
INSERT INTO mar_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","आणि इस्राएल वंशातल्या कोणत्याही एखाद्या स्त्रीला तिच्या वडिलांकडून वतन मिळाले तर तिने तिच्या कुळातील एखाद्याशीच लग्न केले पाहिजे. यामुळे प्रत्येकाला पूर्वजांकडून मिळालेली वतन ठेवता येईल. ");
INSERT INTO mar_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","तेव्हा इस्राएल लोकांमध्ये वतन एक वंशाकडून दुसऱ्या कुळाकडे जाऊ शकणार नाही. प्रत्येक इस्राएली मनुष्य त्याच्या पूर्वजांकडून मिळालेले वतन जवळ बाळगू शकेल. ");
INSERT INTO mar_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","सलाफहादच्या मुलींनी परमेश्वराने मोशेला दिलेल्या आज्ञांचे पालन केले. ");
INSERT INTO mar_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","म्हणून सलाफहादच्या महला, तिरसा, होग्ला, मिल्का व नोआ यांनी त्यांच्या चुलत भावांशी लग्न केले. ");
INSERT INTO mar_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","योसेफाचा मुलगा मनश्शे याच्या वंशातील ते होते. म्हणून त्यांची वतने त्यांच्या वडिलांच्या कुळाकडेच राहिली. ");
INSERT INTO mar_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","परमेश्वराने यार्देनपाशी यरीहोजवळ मवाबाच्या मैदानात मोशेच्याद्वारे इस्राएलाच्या वंशाना दिलेल्या या आज्ञा व नियम आहेत.");
INSERT INTO mar_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","यार्देन नदीच्या पूर्वेकडील रानात अराबामध्ये सुफासमोर, पारान, तोफेल, लाबान, हसेरोथ व दि-जाहाब यांच्या दरम्यान मोशे सर्व इस्राएलाशी वचने बोलला ती ही. ");
INSERT INTO mar_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","होरेबपासून कादेश-बर्ण्यापर्यंतचा प्रवास सेईर डोंगरामार्गे अकरा दिवसाचा आहे. ");
INSERT INTO mar_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","हे मिसर सोडल्यानंतर चाळीसाव्या वर्षी घडले, अकराव्या महिन्यातील पहिल्या दिवशी मोशे इस्राएल लोकांशी हे बोलला, परमेश्वराने जे काही सांगायची आज्ञा केली; ते सर्व त्याने सांगितले. ");
INSERT INTO mar_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","अमोऱ्यांचा राजा सीहोन आणि बाशानाचा राजा ओग यांच्यावर परमेश्वराने हल्ला केल्यानंतरची ही गोष्ट आहे. (सीहोन अमोरी लोकांचा राजा होता. तो हेशबोनमध्ये राहत असे. ओग बाशानाचा राजा होता. तो अष्टारोथ व एद्रई येथे राहणारा होता.) ");
INSERT INTO mar_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","परमेश्वराच्या आज्ञेप्रमाणे मोशे आता यार्देनच्या पलीकडे पुर्वेस मवाबाच्या देशात नियमांचे विवरण करू लागला. तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","आपला देव परमेश्वर होरेबात आपल्याशी बोलला, या डोंगरात तुम्ही पुष्कळ दिवस राहीला आहात. ");
INSERT INTO mar_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","आता तुम्ही येथून अमोऱ्यांच्या डोंगराळ प्रदेशात जा आसपासच्या सर्व प्रदेशात प्रवास करा यार्देनेच्या खोऱ्यात, अराबाच्या पहाडी प्रदेशात, पश्चिमेकडील उतारावर, नेगेबमध्ये समुद्रकिनारी कनान आणि लबानोन मार्गे फरात या महानदीपर्यंत जा. ");
INSERT INTO mar_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","पाहा हा प्रदेश मी तुम्हास देऊ करत आहे जा आणि त्यावर ताबा मिळवा अब्राहाम, इसहाक आणि याकोब या तुमच्या पूर्वजांना व त्यांच्यानंतर त्यांच्या वंशजांना हा प्रदेश देण्याचे परमेश्वराने वचन दिले होते. ");
INSERT INTO mar_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","तेव्हा मी तुम्हास म्हणालो होतो की “मी एकटा तुमचा सांभाळ करू शकणार नाही. ");
INSERT INTO mar_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","आणि आता तर तुमची संख्या कितीतरी वाढली आहे परमेश्वर देवाच्या कृपेने ती वाढून आकाशातील ताऱ्यांइतकी झाली आहे. ");
INSERT INTO mar_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","तुमच्या पूर्वजांचा देव परमेश्वर, ह्याच्या कृपेने आणखी वाढून आताच्या हजारपट होवो आणि त्याने कबूल केल्याप्रमाणे त्याचा आशीर्वाद तुम्हास मिळो. ");
INSERT INTO mar_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","परंतु मी एकटा तुमचा भार तसेच तुमची आपापसांतली भांडणे कोठवर सहन करू? ");
INSERT INTO mar_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","म्हणून मी तुम्हास सांगितले, आपापल्या वंशातून अनुभवी, ज्ञानी व समंजस व्यक्तींची निवड करा. मी त्यांना तुमचे प्रमुख म्हणून नेमतो.” ");
INSERT INTO mar_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","त्यावर, “हे चांगलेच झाले असे” तुम्ही मला उत्तर देऊन म्हणालात. ");
INSERT INTO mar_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","म्हणून मी त्या ज्ञानी व अनुभवी व्यक्तींना तुमचे प्रमुख म्हणून नेमले. हजारांच्या समूहावर एक अधिकारी, शंभरांवर एक, पन्नासांवर, दहावर तसेच घराण्यावर अशा या अधिकाऱ्यांच्या नेमणुका केल्या. ");
INSERT INTO mar_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","या न्यायाधीशांना मी त्यावेळी सांगितले की तुमच्या भाऊबंदांतील वाद नीट ऐकून घ्या. निवाडा करताना पक्षपात करू नका मग तो वाद दोन भावांमधला असो की एखादा मनुष्य व त्याचा भाऊबंद व उपरी यांच्यातील असो. नीतिने न्याय करा. ");
INSERT INTO mar_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","न्याय करताना कोणालाही कमी लेखू नका. लहान मोठ्यांचे सारखे ऐकून घ्या. कोणाचे तोंड पाहून घाबरू नका; कारण न्याय करणे देवाचे काम आहे. एखादे प्रकरण तुम्हास विशेष अवघड वाटले तर ते माझ्याकडे आणा. मी त्याचा निवाडा करीन. ");
INSERT INTO mar_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","तुमच्या इतर कर्तव्यांबद्दलही मी तेव्हाच तुम्हास आज्ञा केली होती. ");
INSERT INTO mar_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","मग आपला देव परमेश्वर ह्याच्या आज्ञेनुसार आपण होरेबहून पुढे अमोऱ्यांच्या डोंगराळ प्रदेशाकडे निघालो तेव्हा वाटेत तुम्हास ते विस्तीर्ण आणि भयंकर रान लागले ते सर्व ओलांडून आपण कादेश-बर्ण्याला पोहचलो. ");
INSERT INTO mar_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","मी तुम्हास म्हणालो की पाहा, “अमोऱ्यांच्या पहाडी प्रदेशात तुम्ही पोहोचलात आपला देव परमेश्वर तुम्हास हा प्रदेश देत आहे. ");
INSERT INTO mar_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","पाहा हा प्रदेश तुझा देव परमेश्वर याने पुढे ठेवला आहे. पूर्वजांचा परमेश्वर ह्याच्या आज्ञेनुसार तो हस्तगत करा. कचरू नका व कशाचीही भीती बाळगू नका.” ");
INSERT INTO mar_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","पण तेव्हा तुम्ही सगळे मला म्हणालात, “आधी आपण काही जणांना त्या प्रदेशाच्या पाहाणीसाठी पुढे पाठवू म्हणजे ते त्या देशाची माहिती मिळवून आपल्याला कोणत्या मार्गाने जावे लागेल, कोणकोणती नगरे तेथे लागतील याची खबर आणतील.” ");
INSERT INTO mar_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","मलाही ते पटले म्हणून प्रत्येक घराण्यातून एक अशी बारा माणसे मी निवडली. ");
INSERT INTO mar_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ते लोक मग निघाले व पहाडी प्रदेशात जाऊन अष्कोल ओढ्यापर्यंत पोहचले व त्यांनी तो देश हेरला. ");
INSERT INTO mar_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","येताना त्यांनी तिकडची काही फळे बरोबर आणली. त्या प्रदेशाची माहिती सांगितली व ते म्हणाले, “आपला देव परमेश्वर देत असलेला देश हा उत्तम आहे.” ");
INSERT INTO mar_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","तथापि तुम्ही तेथे हल्ला करण्याचे नाकारले आपला देव परमेश्वर याच्या आज्ञेविरूद्ध बंड केले. ");
INSERT INTO mar_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","तुम्ही आपापल्या तंबूत जाऊन कुरकुर करत म्हणालात परमेश्वर आमचा द्वेष करतो अमोऱ्यांच्या हातून आमचा नाश व्हावा म्हणूनच आम्हास त्याने मिसर देशातून बाहेर काढले आहे. ");
INSERT INTO mar_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","आता आम्ही कोठे जाणार? आमच्या या भावांच्या बातम्यांमुळे घाबरून आमच्या हृदयाचे पाणीपाणी झाले आहे. त्यांच्यानुसार हे लोक धिप्पाड व आमच्यापेक्षा उंच आहेत. तेथील नगरे मोठी असून त्यांची तटबंदी आकाशाला भिडली आहे. आणि तेथे अनाकी वंशाचे महाकाय आहेत. ");
INSERT INTO mar_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","तेव्हा मी तुम्हास म्हणालो, “भिऊ नका, त्या लोकांस घाबरू नका. ");
INSERT INTO mar_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","स्वत: परमेश्वर देव तुमच्यापुढे जात आहे. मिसर देशात तुमच्यासमोर त्याने जे केले तेच तो येथेही करील, तो तुमच्यासाठी लढेल; ");
INSERT INTO mar_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","तसेच रानातल्या वाटचालीतही तुम्ही पाहीले, त्यामध्ये तुमचा देव परमेश्वर तुमच्यापुढे होता. मनुष्य आपल्या मुलाला जपून नेतो तसे त्याने तुम्हास येथपर्यंत सांभाळून आणले.” ");
INSERT INTO mar_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","तरीही तुम्ही आपल्या परमेश्वर देवावर विश्वास ठेवला नाही. ");
INSERT INTO mar_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","परमेश्वर प्रवासात तुमच्यासाठी मुक्कामाचे ठिकाण शोधायला तसेच रात्री अग्नीत व दिवसा मेघात प्रकट होऊन तुम्हास मार्गदर्शन करायला तुमच्यापुढे चालत असे. ");
INSERT INTO mar_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","परमेश्वराने तुमचे बोलणे ऐकले व तो संतापला शपथपूर्वक तो म्हणाला, ");
INSERT INTO mar_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“तुमच्या पूर्वजांना शपथ वाहून देवू केलेला हा उत्तम प्रदेश या दुष्ट पिढीतील एकाच्याही दृष्टीस पडणार नाही, ");
INSERT INTO mar_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","यफुन्नेचा मुलगा कालेब मात्र तो पाहील त्याचे पाय या भूमीला लागले आहेत. त्यास व त्याच्या वंशजांना मी ही भूमी देईल. कारण तो परमेश्वराचा खरा अनुयायी आहे.” ");
INSERT INTO mar_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","तुमच्यामुळे परमेश्वराचा माझ्यावरही कोप झाला. तो म्हणाला, मोशे, “तूही या प्रदेशात प्रवेश करणार नाहीस. ");
INSERT INTO mar_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","पण तुझ्या सेवेस हजर राहणारा, नूनाचा मुलगा यहोशवा तेथे जाईल त्यास तू प्रोत्साहन दे, कारण तो इस्राएलांना देश वतन म्हणून मिळवून देईल. ");
INSERT INTO mar_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","परमेश्वर पुढे आपल्याला म्हणाला, शिवाय आपले शत्रू आपल्या मुलाबाळांना पळवतील असे तुम्ही म्हणालात ती आज जी तुमची मुले बरे किंवा वाईट जाणत नाहीत ती मात्र या देशात जातील आणि त्यांना मी तो देश देईन व ते देश ते हस्तगत करतील. ");
INSERT INTO mar_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","पण तुम्ही परत फिरून तांबड्या समुद्राच्या वाटेने रानाकडे कूच करा.” ");
INSERT INTO mar_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","मग तुम्ही मला असे उत्तर दिले की “आमच्या हातून परमेश्वराविरुध्द पाप घडले आहे आपल्या परमेश्वर देवाच्या आज्ञेनुसार आम्ही वर जाऊन लढू.” मग प्रत्येक मनुष्याने आपली शस्त्रास्त्रे घेतली. आणि तुम्ही डोंगराळ प्रदेशावर चढावयला तयार झाला. ");
INSERT INTO mar_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","परमेश्वर मला म्हणाला, “त्यांना तेथे सांग युद्ध करू नका. कारण मी त्यांच्या बरोबर नाही. शत्रू त्यांना पराभूत करेल.” ");
INSERT INTO mar_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","त्याप्रमाणे तुम्हास मी सांगितले. पण तुम्ही ऐकले नाही. तुम्ही परमेश्वराची आज्ञा पाळली नाही. आणि धिटाई करून त्या डोंगराळ प्रदेशात चढाई करून गेलात. ");
INSERT INTO mar_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","तेव्हा तेथील अमोरी तुमच्याशी सामना करायला सामोरे आले. आणि चवताळलेल्या मधमाश्यांप्रमाणे त्यांनी सेईर देशातील हर्मापर्यंत तुम्हास पिटाळून लावले. ");
INSERT INTO mar_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","मग तुम्ही परत येऊन परमेश्वराकडे रडू लागला. पण त्याने तुमचे काहीही ऐकले नाही. ");
INSERT INTO mar_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","तेव्हा तुम्ही कादेश येथे बरेच दिवस राहिला ते तुम्हास माहितच आहे. ");
INSERT INTO mar_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","मोशे आणखीन पुढे म्हणाला; “परमेश्वराने मला सांगितल्याप्रमाणे आपण मागे फिरुन तांबड्या समुद्राच्या वाटेने रानात निघालो बरेच दिवस सेईर डोंगराभोवती फिरत राहिलो. ");
INSERT INTO mar_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","परमेश्वर तेव्हा मला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘या डोंगराभोवती तुम्ही फार दिवस फिरत राहिला आहात. आता उत्तरेकडे वळा. ");
INSERT INTO mar_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","आणि लोकांस आणखी एक सांग, तुम्हास वाटेत सेईर लागेल. ती भूमी एसावाच्या वंशाजांची, तुमच्या भाऊबंदांची आहे त्यांना तुमची भीती वाटेल तेव्हा सांभाळा. ");
INSERT INTO mar_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","त्यांच्याशी भांडू नका. त्यांच्यातली तसूभरही जमीन मी तुम्हास देणार नाही. कारण सेईर डोंगर मी एसावाला वतन म्हणून दिला आहे. ");
INSERT INTO mar_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","तुमचे अन्न पैसे देवून, विकत घेवून खा. पाणीही विकत घेवून प्या. ");
INSERT INTO mar_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","तुमच्या हातच्या सर्व कार्यात तुमचा देव परमेश्वर याने तुम्हास आशीर्वादीत केले आहे. तुमच्या या रानातील वाटचालीकडे त्याचे लक्ष आहे. गेली चाळीस वर्षे तुमचा देव परमेश्वर तुमच्या सोबत राहीला आहे. तुम्हास कशाचीही वाण पडली नाही.’ ");
INSERT INTO mar_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","तेव्हा एसावचे वंशज राहत असलेल्या सेईर वरुन आपण गेलो. एलाथ आणि एसयोन-गेबेर वरून येणारा अराबाचा मार्ग आपण सोडला आणि मवाबाच्या रानातल्या रस्त्याला आपण वळालो. ");
INSERT INTO mar_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","परमेश्वर मला म्हणाला, ‘मवाबाला उपद्रव करू नका. त्यांच्याशी युद्धाचा प्रंसग आणू नका. त्यांच्यातली जमीन मी तुम्हास देणार नाही. कारण आर नगर मी लोटच्या वंशजांना इनाम दिले आहे.’” ");
INSERT INTO mar_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","पूर्वी तेथे एमी लोक राहत असत. ते बहुसंख्य, धिप्पाड व अनाकी लोकांप्रमाणे महाकाय होते. ");
INSERT INTO mar_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","या एमींना लोक अनाकी यांच्याप्रमाणेच रेफाई समजत असत. पण मवाबी लोक त्यांना एमी म्हणतात. ");
INSERT INTO mar_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","पूर्वी सेईरात होरी लोकही राहत असत. पण एसावाच्या वंशजांनी त्यांची जमीन बळकावली, होरींचा संहार केला व तेथे स्वत: वस्ती केली. परमेश्वराने त्यांना दिलेल्या देशाचे इस्राएलींनी जसे केले तसेच त्यांनी इथे केले. ");
INSERT INTO mar_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“मग परमेश्वराने मला जेरेद ओढ्यापलीकडे जायला सांगितले.” त्याप्रमाणे आपण जेरेद ओढ्यापलीकडे गेलो. ");
INSERT INTO mar_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","कादेश बर्ण्या सोडून जेरेद ओढ्यापलीकडे पोहोचेपर्यंत अडतीस वर्षे उलटली होती. तोपर्यंत आपल्या पिढीतील सर्व लढवय्ये मरण पावले होते. परमेश्वराने शपथ वाहिल्या प्रमाणे हे झाले. ");
INSERT INTO mar_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","त्यांचा समूळ नाश होईपर्यंत छावणीतून त्यांचा संहार करावा म्हणून परमेश्वराचा त्यांच्यावर हात उगारलेला होता ");
INSERT INTO mar_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ह्याप्रकारे सर्व योद्धे मरण पावले, ती पिढी नामशेष झाली, ");
INSERT INTO mar_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","परमेश्वर मला म्हणाला, ");
INSERT INTO mar_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“तुला आज मवाबाची सीमा ओलांडून आर नगरापलीकडे जायचे आहे. ");
INSERT INTO mar_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","तेथे अम्मोनी लोक भेटतील. त्यांना उपद्रव देऊ नको. त्यांच्याशी युध्द करू नको. त्यांच्या जमिनीतील वाटा मी तुला देणार नाही. कारण ते लोटाचे वंशज असून त्यांना मी ती वतन दिली आहे.” ");
INSERT INTO mar_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","त्या भागाला “रेफाई देश” असेही म्हणतात. पूर्वी तेथे रेफाई लोकांची वस्ती होती. अम्मोनी त्यांना “जमजुम्मी” म्हणत. ");
INSERT INTO mar_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","जमजुम्मी संख्येने पुष्कळ व सशक्त होते. अनाकी लोकांप्रमाणे ते धिप्पाड होते. पण त्यांचा संहार करायला अम्मोनी लोकांस परमेश्वराचे साहाय्य होते. आता त्या जमिनीचा ताबा घेऊन अम्मोनी तेथे राहतात. ");
INSERT INTO mar_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","एसावाच्या वंशजांनाही देवाचे असेच पाठबळ होते. पूर्वी सेईर येथे होरी लोक राहत असत. त्यांनी त्यांना हुसकावून लावले. पण एसावाच्या वंशजांनी होरींचा संहार केला व आजपर्यंत ते तेथे राहतात. ");
INSERT INTO mar_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","त्याचप्रमाणे अव्वी लोक गज्जापर्यंतच्या खेड्यात वस्ती करून होते, त्यांचा कफतोराहून आलेल्या कफतोरी लोकांनी उच्छेद करून त्यांची भूमी बळकावली आणि आता ते तेथे राहत आहेत. ");
INSERT INTO mar_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","पुढे परमेश्वर मला म्हणाला, “आता उठा व आर्णोनाचे खोरे ओलांडून जा. हेशबोनाचा अमोरी राजा सीहोन व त्याचा देश मी तुझ्या हाती दिला आहे, तो देश आपल्या ताब्यात घे आणि त्यास लढाईला प्रवृत्त कर. ");
INSERT INTO mar_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","तुमच्याविषयी या सर्व आकाशाखालच्या लोकांच्या मनात आज अशी भीती व दहशत निर्माण करीन की, तुमचे वर्तमान ऐकताच ते थरथर कापतील व भयभीत होतील.” ");
INSERT INTO mar_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","मग मी कदेमोथच्या रानातून हेशबोनचा राजा सीहोन याच्याकडे दूताकरवी सलोख्याचा निरोप पाठवला की, ");
INSERT INTO mar_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“तुमच्या देशातून आम्हास जाऊ दे. आमची वाट सोडून आम्ही उजवीडावीकडे वळणार नाही. ");
INSERT INTO mar_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","तू पैसे घेऊन मला खाण्यासाठी अन्न विकत दे आणि पाणीही पैसे घेऊन विकत प्यायवयास दे, आम्हास फक्त इथून पलीकडे पायी जाऊ दे. ");
INSERT INTO mar_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","यार्देनपलीकडे आमचा देव परमेश्वर आम्हास देणार असलेल्या जमिनीपर्यंत आम्हास जायचे आहे. सेईरच्या एसाव लोकांनी आणि आर येथील मवाबी लोकांनी आम्हास जाऊ दिले तसेच तूही कर.” ");
INSERT INTO mar_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","पण हेशबोनचा राजा सीहोन आपल्या देशातून जाऊ देईना. आपण त्यास पराभूत करावे म्हणूनच तुमचा देव परमेश्वर ह्याने त्यास कठोर केले. त्याचे मन कठीण केले. आज तुम्ही पाहातच आहात की तो देश आपल्या हाती आहे. ");
INSERT INTO mar_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","परमेश्वर मला म्हणाला, “सीहोन राजा आणि त्याचा देश हे मी तुमच्या हवाली करत आहे. त्याचा देश तुझे वतन व्हावे म्हणून त्यांचा ताबा घे.” ");
INSERT INTO mar_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","आणि तेव्हा सीहोन व त्याची प्रजा याहस येथे आमच्याबरोबर लढाईसाठी सज्ज झाले. ");
INSERT INTO mar_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","परमेश्वर देवाने त्यास आपल्या ताब्यात दिले म्हणून आम्ही त्याचा, त्याच्या मुलांचा व सर्व लोकांचा पराभव करू शकलो. ");
INSERT INTO mar_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","त्यांच्या सर्व नगरांचा आम्ही ताबा घेतला व पुरुष, स्त्रिया, मुलेबाळे ह्याच्यासह सर्वांचा समूळ नाश केला, कोणालाही जिवंत ठेवले नाही. ");
INSERT INTO mar_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","तेथील पशू आणि जिंकलेल्या नगरातील लुट मात्र आम्ही आमच्यासाठी घेतली. ");
INSERT INTO mar_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","आर्णोन खोऱ्याच्या कडेला वसलेले अरोएर नगर, खोऱ्याच्या मध्यावरील एक नगर तसेच आर्णोन खोरे ते गिलादापर्यंत सर्व नगरे, आमचा देव परमेश्वर याने आम्हास दिली. आम्हास दुर्गम असे एकही नगर नव्हते. ");
INSERT INTO mar_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","अम्मोन्याचा प्रदेश वगळता फक्त यब्बोक नदीच्या किनाऱ्यावर तसेच डोंगराळ प्रदेशातील नगरांकडे आम्ही गेलो नाही. कारण आमचा देव परमेश्वर याने तेथे जाण्यास बंदी केली होती. ");
INSERT INTO mar_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","मग आपण वळसा घेऊन बाशानच्या वाटेने निघालो. तेव्हा बाशानाचा राजा ओग आणि त्याची सेना युद्धासाठी एद्रई येथे चाल करून आली. ");
INSERT INTO mar_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","परमेश्वर मला म्हणाला, त्यास भिऊ नका. तो, त्याची प्रजा आणि त्याची भूमी मी तुमच्या हाती दिलेली आहे. हेशबोनवर राज्य करणारा अमोऱ्यांचा राजा सीहोन ह्याचे केले तसेच याचेही करा. ");
INSERT INTO mar_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","आमचा देव परमेश्वर ह्याने बाशानाचा राजा ओग आणि त्याची प्रजा आमच्या हाती दिली. आम्ही त्यास असा मार दिला की त्यांच्यापैकी कोणीही जिवंत राहिले नाही. ");
INSERT INTO mar_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","मग ओगच्या ताब्यातील सर्वच्या सर्व साठ नगरे म्हणजे अर्गोबाचा सारा प्रदेश घेतला, बाशानातले ओगचे राज्य ते हेच. ");
INSERT INTO mar_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","या सर्व नगरांना भक्कम तटबंदी होती. त्यांना उंच भिंती, वेशी, मजबूत अडसर होते. याव्यतिरिक्त तट नसलेली खेडी पुष्कळच होती. ");
INSERT INTO mar_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","हेशबोनच्या सीहोन राजाच्या नगरांप्रमाणेच येथेही आम्ही समुळ नाश केला. पुरुष, स्त्रिया, मुलेबाळे कोणालाही म्हणून शिल्लक ठेवले नाही. ");
INSERT INTO mar_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","गुरेढोरे आणि नगरातील लूट मात्र घेतली. ");
INSERT INTO mar_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“अशाच पद्धतीने अमोऱ्यांच्या दोन राजांच्या ताब्यातला प्रदेशही आपण घेतला, तो म्हणजे यार्देनच्या पूर्वेकडचा, आर्णोन खोऱ्यापासून हर्मोन पर्वतापर्यंतचा. ");
INSERT INTO mar_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(सीदोनी लोक या हर्मोन पर्वताला सिर्योन म्हणतात. पण अमोरी लोक सनीर म्हणतात.) ");
INSERT INTO mar_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","माळावरील सर्व नगरे, सगळा गिलाद प्रांत तसेच बाशानच्या ओगच्या राज्यातील सलेखा व एद्रई सकट सर्व प्रांत आम्ही काबीज केला.” ");
INSERT INTO mar_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","रेफाई लोकांपैकी बाशानाचा राजा ओग तेवढा अजून जिवंत होता. त्याचा पलंग लोखंडाचा होता. तो पलंग तेरा फूट लांब आणि सहा फूट रुंद होता. अम्मोन्यांच्या राब्बा नगरात तो अजूनही आहे. ");
INSERT INTO mar_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“तेव्हा ती जमीन आम्ही काबीज केली. रऊबेनी आणि गादी यांना त्यातील काही भाग मी दिला. तो असाः आर्णोन खोऱ्यातील अरोएर नगरापासून गिलादाच्या डोंगराळ प्रदेशाचा अर्धा भाग व त्यातील नगरे. ");
INSERT INTO mar_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","गिलादाचा उरलेला अर्धा भाग आणि संपूर्ण बाशान मनश्शेच्या अर्ध्या वंशाला दिले.” बाशान म्हणजे ओगचे राज्य त्याच्या एका भागाला अर्गोब म्हणतात (ह्यालाच रेफाईचा देशही म्हणतात. ");
INSERT INTO mar_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","मनश्शेचा मुलगा याईर याने गशूरी आणि माकाथी यांच्या सीमेपर्यंत अर्गोबाचा सर्व प्रदेश हस्तगत केला. आणि बाशानाला आपले नाव दिले म्हणून आजही लोक त्यास हव्वोथ-याईराची नगरेच म्हणतात.) ");
INSERT INTO mar_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","आणि गिलाद प्रदेश मी माखीर याला दिला. ");
INSERT INTO mar_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","त्याचा पुढचा प्रदेश रऊबेनी आणि गादी ह्यांना गिलादापासून आर्णोन खोऱ्याच्या मध्यभागापासून अम्मोन्यांच्या सीमेवरील यब्बोक नदीपर्यंत त्याची सरहद्द ठरवली. ");
INSERT INTO mar_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","तसेच किन्नेरेथापासुन अरबाचा समुद्र म्हणजेच क्षार समुद्र ईथपर्यंतचा पिसगाची उतरण व त्याच्या तळाशी असलेला अराबा व यार्देनेच्या पुर्वेकडील प्रदेश मी त्यांना दिला. ");
INSERT INTO mar_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","त्यावेळी मी त्या सर्वांना आज्ञा दिली की यार्देन नदीच्या अलीकडचा हा प्रदेश “तुमचा देव परमेश्वर ह्याने तुमच्या हवाली केला आहे. पण तुमच्यापैकी सर्व लढाऊ पुरुषांनी पुढाकार घेऊन, हत्यारबंद होऊन आपल्या इस्राएली भाऊबंदाना पलीकडे घेऊन जावे. ");
INSERT INTO mar_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","तुमच्या स्त्रिया, मुलेबाळे आणि गुरेढोरे (ती बरीच आहेत हे मला माहीत आहे) इथेच मी दिलेल्या नगरात राहतील. ");
INSERT INTO mar_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","आणि तुमच्याचप्रमाणे तुमच्या भाऊबंदांना परमेश्वर विसावा देईल, व तुमचा देव परमेश्वर ह्याने त्यांना देऊ केलेला यार्देनेपलीकडचा देश तेही ताब्यात घेतील; त्यानंतर जो प्रदेश मी तुम्हास दिलेला आहे तेथे तुम्ही सर्व आपापल्या वतनावर परत या.” ");
INSERT INTO mar_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","मग मी यहोशवाला असे सांगितले की, “या दोन राजांचे तुमचा देव परमेश्वर ह्याने काय केले हे तू पाहिलेच. पुढेही ज्या ज्या राज्यात तू जाशील त्या सर्वांचे परमेश्वर असेच करील. ");
INSERT INTO mar_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","तेथील राजांना घाबरु नका. कारण युद्धात तुमचा देव परमेश्वर तुमच्या बाजूने लढणार आहे.” ");
INSERT INTO mar_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","मग त्या वेळी मी परमेश्वरास विनंती करून म्हणालो, ");
INSERT INTO mar_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“हे प्रभू परमेश्वरा, तू तुझ्या दासास आपला महान व सामर्थ्यशाली हात दाखवत आहेस. तुझ्यासारखे थोर प्रताप करणारा देव स्वर्गात किंवा पृथ्वीवर दुसरा कोण आहे? ");
INSERT INTO mar_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","तेव्हा कृपाकरून मला यार्देन नदी पलीकडची सुपीक भूमी, चांगला डोंगराळ प्रदेश आणि लबानोन पाहू दे.” ");
INSERT INTO mar_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","पण तुमच्यापायी परमेश्वर माझ्यावर रुष्ट झाला होता. त्याने माझे म्हणणे ऐकले नाही. तो म्हणाला, “पुरे, आता एक शब्दही बोलू नको. ");
INSERT INTO mar_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","पिसगाच्या शिखरावर जा. आणि तेथून पूर्व, पश्चिम, उत्तर, दक्षिण अशा चारी दिशांना बघ. तेथून तुला सर्वकाही दिसेल पण यार्देनच्या पलीकडे तू पाऊल ठेवू शकणार नाहीस. ");
INSERT INTO mar_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","यहोशवाला मात्र तू सूचना दे. त्यास उत्तेजन देऊन समर्थ कर. कारण तोच लोकांस पलीकडे नेईल. तू तो देश पाहशील पण यहोशवाच त्यांना ती जमीन राहण्यासाठी मिळवून देईल.” ");
INSERT INTO mar_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","“आणि आम्ही बेथ-पौराच्या समोरच्या खोऱ्यात राहिलो.” ");
INSERT INTO mar_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","आता अहो इस्राएल लोकहो, मी जे नियम आणि आज्ञा सांगतो त्या नीट ऐकून घ्या. त्यांचे पालन केलेत तर जिवंत रहाल आणि तुमच्या पूर्वजांचा देव परमेश्वर जो देश तुम्हास देणार आहे त्याचा ताबा घ्याल. ");
INSERT INTO mar_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","माझ्या आज्ञांमध्ये तुम्ही कमी किंवा अधिक असे काही करु नका. अशासाठी की, तुमचा देव ह्याच्या ज्या आज्ञा मी तुम्हास देत आहे. त्या तुम्ही पाळाव्या. ");
INSERT INTO mar_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","बआल-पौराच्या विषयी परमेश्वराने काय केले हे तुम्ही तुमच्या डोळ्यांनी पाहीले आहे; जे बआल-पौराच्या नादी लागले त्यांना तुमचा देव परमेश्वर याने तुमच्यामधून नष्ट केले आहे. ");
INSERT INTO mar_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","परंतु तुमचा देव परमेश्वर याच्याशी जे जडून राहिले ते तुम्ही आज जिवंत आहा. ");
INSERT INTO mar_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","पाहा माझा देव परमेश्वर याने आज्ञा दिली त्याप्रमाणे विधी आणि नियम मी तुम्हास शिकवले. तुम्ही जो देश ताब्यात घेण्यास जात आहात तेथे तुम्ही ते पाळावे म्हणून मी ते सांगितले. ");
INSERT INTO mar_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","त्यांचे काटेकोरपणे पालन करा. म्हणजे तुम्ही सूज्ञ व समजूतदार आहात हे इतर देशवासीयांना कळेल. हे नियम ऐकून ते म्हणतील, खरेच, हे महान राष्ट्र बुद्धिमान व समंजस लोकांचे आहे. ");
INSERT INTO mar_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","आपण आपला देव परमेश्वर ह्याचा धावा करतो तेव्हा तो आपल्या जवळच असतो, असे देव जवळ असणारे महान राष्ट्र दूसरे कोणते आहे? ");
INSERT INTO mar_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ज्या विधी आणि नियमांची शिकवण मी तुम्हास दिली तसे नियमशास्त्र असणारे दुसरे राष्ट्र तरी कोठे आहे? ");
INSERT INTO mar_vpl VALUES ("DT4_9","006_4_9",