﻿USE sofia;
DROP TABLE IF EXISTS sofia.maqNT_vpl;
CREATE TABLE maqNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES maqNT_vpl WRITE;
INSERT INTO maqNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Xujun vihi ne, setaha xujun ñihi rë xutachanga rë Jesucristu, me xi tjë rë David, hacuaha tjë rë Abraham. ");
INSERT INTO maqNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ne, me vëhë xi xutachanga xi má nahmi rë Isaac. Isaac ne, me vëhë xi xutachanga xi má nahmi rë Jacob. Jacob ne, me vëhë xi xutachanga xi má nahmi rë Judá cojo hntsë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ne, nahmi má me tsëhë Fares cojo Zara; naa rë me ne, Tamar hmí rë. Fares ne, me vëhë xi xutachanga xi má nahmi rë Esrom. Esrom ne, me vëhë xi xutachanga xi má nahmi rë Aram. ");
INSERT INTO maqNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ne, me vëhë xi xutachanga xi má nahmi rë Aminadab me xi xutachanga xi má nahmi rë Naasón, me vëhë xi xutachanga xi má nahmi rë Salmón. ");
INSERT INTO maqNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ne, nahmi rë Booz me; hane Rahab ne, naa rë me. Booz ne, nahmi má me tsëhë Obed. Naa rë me vë; má Rut. Obed ne, me vëhë xi xutachanga xi má nahmi rë Isaí. ");
INSERT INTO maqNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ne, me vëhë xi xutachanga xi má nahmi rë David. David jan ne, me vëhë xi cavitexa nangui rë Israel. Hane David ne, me vëhë xi xutachanga xi má nahmi rë Salomón. Naa rë Salomón ne, titjun chjuun rë Urías camá me. ");
INSERT INTO maqNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ne, me vëhë xi xutachanga xi má nahmi rë Roboam. Roboam ne, me vëhë xi xutachanga xi má nahmi rë Abías. Abías ne, me vëhë xi xutachanga xi má nahmi rë Asa. ");
INSERT INTO maqNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ne, me vëhë xi xutachanga xi má nahmi rë Josafat. Josafat ne, me vëhë xi xutachanga xi má nahmi rë Joram. Hane Joram ne, me vëhë xi xutachanga xi má nahmi rë Uzías. ");
INSERT INTO maqNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ne, me vëhë xi xutachanga xi má nahmi rë Jotam. Jotam ne, me vëhë xi xutachanga xi má nahmi rë Acaz. Acaz ne, me vëhë xi xutachanga xi má nahmi rë Ezequías. ");
INSERT INTO maqNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ne, me vëhë xi xutachanga xi má nahmi rë Manasés. Manasés ne, me vëhë xi xutachanga xi má nahmi rë Amón. Amón ne, me vëhë xi xutachanga xi má nahmi rë Josias. ");
INSERT INTO maqNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias ne, me vëhë xi xutachanga xi má nahmi rë Jeconías cojo hntsë cha. Nixtin hya ne, xutaxín ne, cafahaxin me xuta nangui rë Israel, quijicojo me xuta jan nangui Babilonia. ");
INSERT INTO maqNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hane xi cama quiji me Babilonia, Jeconías vë ne, camá me vëhë xutachanga xi má nahmi rë Salatiel. Salatiel ne, me vëhë xi xutachanga xi má nahmi rë Zorobabel. ");
INSERT INTO maqNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ne, me vëhë xi xutachanga xi má nahmi rë Abiud. Abiud ne, me vëhë xi xutachanga xi má nahmi rë Eliaquim. Eliaquim ne, me vëhë xi xutachanga xi má nahmi rë Azor. ");
INSERT INTO maqNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ne, me vëhë xi xutachanga xi má nahmi rë Sadoc. Sadoc ne, me vëhë xi xutachanga xi má nahmi rë Aquim. Aquim ne, me vëhë xi xutachanga xi má nahmi rë Eliud. ");
INSERT INTO maqNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ne, me vëhë xi xutachanga xi má nahmi rë Eleazar. Eleazar ne, me vëhë xi xutachanga xi má nahmi rë Matán. Matán ne, me vëhë xi xutachanga xi má nahmi rë Jacob. ");
INSERT INTO maqNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ne, má me nahmi rë José, xihin rë María naa rë Jesús me xi hacuaha yaha ñihi rë Mesías. ");
INSERT INTO maqNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Cuatjin camá xi cavatju teñuju ndiya xi cavatju xi cjín xuta tisetsin me nixtin rë Abraham hisca nixtin rë David. Hacuaha cama teñuju ndiya xi cjín xuta tisetsin me nixtin rë David hisca hya xi xutaxín jan ne, cafahaxin me xuta nangui rë Israel, quijicojo me xuta nangui Babilonia. Hane hacuaha camá teñuju ndiya tsëhë nixtin hya hisca nixtin xi catsin Mesías. ");
INSERT INTO maqNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cuitjin camá nixtin xi catsin Jesucristu: María, naa rë Jesús ne, tacun vasen cjuavixan rë na cojo José. Peru chaja sa xi cjuaha xicjin na cojo me ne, casacu rë na quihndi ngatsë rë Hasen rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, me xi cuixan cojo na jan ne, tyjahi me cojo cjuatacun rë me xcun Nina. Hane xi mijí scandi me cjuasava rë na, catsingatahacacun me xi taha hma ni ne tsismicacun me na. ");
INSERT INTO maqNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cuatjin catsingatahacacun me xi sahmi me peru hora hya ne, cafehetsejen ngu ángel rë Nina ngajñi chini rë me, hane cuitjin cachja ángel: ―‍José, ngaye quihndi tjë rë David, ximacjintacuin xi chjehentse María cuma chjuun riji na ta, sacuaha quihndi xi yaha na ne, ngatsë rë Hasen rë Nina, camá xi casacu rë na. ");
INSERT INTO maqNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tsin rë na ngu quihndi xihin. Quihndi vë ne, tehe ñihi rë Jesús. Cuatjin cjuaha ñihi ta, tsëhë xi cuaxëtje rë xuta rë tsëhë jyë́ rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yëjë xcusun vihi ne cuatjin cama, cojo sa xi cuetjucaa jain cjua xi cachja profeta nixtin hatsëë cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ngayujun ni nutsujun ta ngu chjuun xungun ne, sacu rë na ngu quihndi xihin. Quihndi jan ne, suañihi me Emanuel. Emanuel ne, vëhë cjua xi vijne: Nina ne, jiya me ngajñi naja. ");
INSERT INTO maqNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ngajan xi hya xi cavasca rë José ne, casahmi me tutjin cachja ángel cojo me. Cafahatsja me María ne xi camá chjuun rë me na. ");
INSERT INTO maqNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Peru hisca xi cavatju catsin quihndi ne, sehe caviyuju cojo xicjin me. Hane casuañihi rë me quihndi jan, Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nixtin xi catsin Jesús nangui Belén, distritu Judea, nixtin hya ne, Herodes vitexa me xuta nangui vë. Hacuaha nixtin hya ne, ngu jo cha xi vechutaha cjuatacun rë ne, cavetjun cha ladu vetjucaa tsuhi cafehe cha nandya Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hane cuitjin cachja cha: ―‍¿Jani sacu niji quihndi xi cuitexa nangui Israel? ta cahyin xi cavetjucaa niñú rë me ngajan ladu vetjucaa tsuhi. Hane nduvintjenguin me xi chjihinrcuin me. ");
INSERT INTO maqNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hya xi cama ne, jemu cama xti rë Herodes xi tu cahndë me cjua jan; cojo xuta nangui Jerusalén ne, cama xti rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hya xi cama ne, Herodes ne, cajindayavaha me yëjë ni nahmi xi matitjun cojo yëjë cha vicuya cjuachacun rë xuta nangui Israel. Sehe cavinenguise me ¿jani xi tsin xu me xi má Cristu? ");
INSERT INTO maqNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hane cuitjin cafayangui me: ―‍Ngajan nandya Belén, distritu Judea tsin ta cuatjin catsihindu profeta tsëhë nandya jan xi ngajan tsin quihndi: ");
INSERT INTO maqNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ngaye, nandya Belén, ngaye nandya tsëhë xuta tjë rë Judá, hacuaha vengui chji ri xcun xuta matitjun nangui Judá. Ta ngajñi rë xuta riji ne cuetjutsejen ngu me xi cuitexa rë xuta naha, xuta nangui Israel. ");
INSERT INTO maqNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hya xi camá ne, Herodes ne, cajindayahma me cha xi vechu cjuatacun rë jan. Cafahataha rë me cha. ¿Mé hora cjuaquixi tsëhë mé nixtin camatsejen niñú jan? ");
INSERT INTO maqNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ngaxtun vëhë ne, sehe cavitexa me cha xi cjue cha Belén. Hacuaha cuitjin cachja me cojo cha: ―‍Tangun ngajan Belén. Chjinengunsunndujun yëjë tsëhë quihndi. Hane xi sacu nuju cjuaquixi ne, ningatjun ná cjua sehe cojo ngahan ne hacuaha cjuë́ cjuahárcun quihndi. ");
INSERT INTO maqNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Xi cavihndë cha xi cuicun vi cjua jan, cavetju cha quiji cha. Hane niñú xi cavetjucaa ngajan ladu vetjucaa tsuhi jan ne, hacuaha quiji titjun hisca xi cavechu cahndë́ hiscan xi jiña quihndi, hane ngajan cavasén. ");
INSERT INTO maqNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hane xi cavëë cha niñú xi ngajan cavasen ne, jercu tu ndama camaha ni rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hane xi cavisehen cha ndihya hiscan siu me ne, cavëë cha quihndi jan. Hacuaha cavëë cha naa rë me, xi hmí rë María. Sehe quiji cavixcuhnchi cha cafaharcun cha quihndi jan. Hane sehe cavuxaha cha hiscan hincha rë cha cuatjo, hane casua cha oro cojo tyjungunsa cojo tyjungunjne xi hmí rë mira. ");
INSERT INTO maqNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hya xi cavatju vëhë ne, tsëhë xi cachja chini cojo rë cha xi cuyaain cha taha ladu hiscan tacun Herodes ne, tahaxin cavuya cha nangui rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hya xi quiji cha xi vechu cjuatacun rë jan ne, cafehetsejen ngu ángel rë Nina ngajñi chini rë José, hane cachja cuitjin: ―‍Tisatjinhngue, tihincueje quihndi cojo naa rë. Tiyun hiscan nangui Egipto. Hane ngajan cuinechun hisca xi tsingátju cjua xi cuyun. Cuatjin nihñu ta tsëhë xi Herodes ne, cuanguise me quihndi xi tsiquehen me. ");
INSERT INTO maqNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hane cavisatjenhnga me nixten quijicojo me quihndi jan cojo naa rë, cafe me Egipto. ");
INSERT INTO maqNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hane xi cafehe me ngajan Egipto ne, ngajan caviyujutaha me hisca nixtin xi cahme Herodes. Cuatjin cama sehe hatuxa camachihin cjua xi catsingatju Nina cojo profeta rë me hatsëë nixtin. Cuitjin chja cjua jan: “Cajindáya rë quihndi naha xi nduvaniji tsëhë nangui Egipto.” ");
INSERT INTO maqNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hya xi camachaya rë Herodes xi camá cavindacha cha xi vechu cjuatacun rë jan ne, jercu cama cjan rë me. Hane cavitexa me yo xi tsiquehen rë yëjë ni quihndi xihin xi cjëë cjuë jyan nu, yëjë ni quihndi nandya Belén cojo distritu rë. ");
INSERT INTO maqNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Vëhë cjua xi cachja Nina xi catsihindu profeta Jeremías: ");
INSERT INTO maqNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Vinuhya rë cjuava ngajan nandya Ramá. Jemu tjin cjuandusin. Na Raquel ne, jihndava na ngatsë rë quihndi rë na. Hane tsajin cjuetacun xi cuma rë na ta tsëhë xi ha cafë quihndi. ");
INSERT INTO maqNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hane xi cavatju cahme Herodes ne, cavuya cafehetsejen nga ángel rë Nina ngajñi chini rë José ngajan Egipto ne, ");
INSERT INTO maqNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","cuitjin cachja: ―‍Tisatjinhngue tihincueje quihndi cojo naa rë. Tihinniji nandya Israel. Tihin ta tsëhë xi ha cahme cha xi meje tsiquehen rë quihndi. Cuatjin cachja. ");
INSERT INTO maqNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hya xi camá ne, cavisatjenhnga José ne, sehe cavetju me quijicojo me quihndi cojo naa rë, hane sehe cavisehen nga me nangui Israel. ");
INSERT INTO maqNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Peru xi cahndë José xi Archelaus vitexa me distritu Judea ta me vëhë vitexa me ngojo rë nahmi rë me, Herodes, vëhë xi camacjincacun José mijí cjue me ngajan. Hane xi cachja chini cojo rë me ne, sehe cavisehen me distritu Galilea. ");
INSERT INTO maqNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Caviyujutaha me ngajan ngu nandya xi hmí rë Nasaret. Cuatjin cama sehe cuetjucaa cjua xi catsihindu profeta tsëhë me xi xuta ne, cuichja me xi Jesús ne, xuta Nasaret me. ");
INSERT INTO maqNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nixtin hya ne, cavetjucaa tsejen Juan Vitenda rë Xuta ngajan nguijña tsëhë distritu Judea. ");
INSERT INTO maqNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Cuitjin catsiquihndë me xuta: ―‍Nindeyun cjuatacun nuju ta, camatiña nixtin xi Nina ne, cuitexa me ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Cuatjin tsëhë cha Juan vihi, cha vihi xi camahindu tsëhë cha xcun xujun xi chja cjua rë profeta Isaías xi chja cuitjin: Cuitjin jercu hñu tsiquihndë ngu xuta ngajan hiscan jemu xín tsëhë nandya: “Tuhun chjinu ndiya xi cuinduva Nina; hacuaha ninguixun cjuatacun nuju tsëhë me.” Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tsjian rë Juan jan ne, tsja rë chu camellu camá hacuaha cojo ngu cinturón chuxin tsihñu me cahntsua me. Hane xi jinë me ne, chu nchahva cojo tsjen rë chu tusen. ");
INSERT INTO maqNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hane jemu cjín xuta quijitjengui me Juan, xuta nandya Jerusalén, xuta distritu Judea cojo xuta xi siutahandee rë ndajyë Jordán. ");
INSERT INTO maqNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Xuta jan, xi cavijacun me jyë́ rë me cojo Nina camá cavitenda Juan me ngajan ndajyë Jordán. ");
INSERT INTO maqNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Peru xi cavutsejen Juan xi cjín xuta tifehe tixtenda me; cha tsëhë partidu fariseo cojo cha tsëhë partidu saduceo ne cachja me cojo cha cuitjin: ―‍¡Ngayujun ni ngayun quihndi rë chu tsehen matsejen ne!, ¿yo cavinchangui nuju xi nihñu ngahñu xi cjuetjuntjun tsëhë castigu xi hatuxa tsingatju Nina? ");
INSERT INTO maqNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sá xi meje jain cjuetjuntjun matsejen ne, nihñu suvá cjuandaja sacuatjin sahmi xuta xi catsindeya jain me cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Xicanujuun cahntsua xahasen nuju cjua vihi: “Ngayaan ne, tsajin mé cuma naja ta, tsëhë xi tjë rë Abraham ngayaan.” Xicanujuun cuatjin matsejen ta, nguehe cuichjá cojo nuju ta Nina ne, hisca cojo ndyojo xi cuicun vi ne, cuma sahmi me xi cumá tjë rë Abraham. ");
INSERT INTO maqNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chutsujun ta ngayun matsejen ne, tangun ngayun cojo yatjë xi ha quitahachjine quicharcu tyjama rë xi cuetsihin xti rë. Yëjë ni yatjë xi suaain tu xi ndaja matsejen ne, xtí rë, sehe cueti. ");
INSERT INTO maqNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngahan matsejen ne, cojo nandá ni tiviténda nuju, peru sehe cuinduva me xi hitsë sa jyë ngahñu tjin rë cjuatacun rë xi cuma ná ngahan, me xi hitsë sa jyë hnga cojo cjuatacun rë xi cuma ná ngahan. Hane me vëhë cueya me Hasen rë Nina cahntsua xahasen nuju, hacuaha tangun me sacuaha ngu ndihi xi tsityjahi rë cjuatacun nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Me vëhë matsejen ne, sacuaha xi ha yahatsja me quicha xi tsicaha rë xtë rë trigu cojo sa xi cuma tyjahi ndaja trigu xi casechun rë tsëhë me, hacuaha cjuaya me trigu tyjahi xi cuinchandaja me, hane xtë rë jan matsejen ne, cuaca me xcun ndihi xi tsajin nixtin coho. ―‍Cuatjin cachja Juan. ");
INSERT INTO maqNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nixtin hya ne, hacuaha cavetju Jesús tsëhë distritu Galilea hane cafehe me ndajyë Jordán xi xtenda me. ");
INSERT INTO maqNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Peru mijí sua Juan cahndë́ ta cachja me: ―‍Hitsë sa ndaja xi ngayun cuitendun ná. Hacuiin xi ngahan cuitenda nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngajan xi cafayangui Jesús cuitjin: ―‍Jéya, cuatjin ndatjin xi cuma quihndë ta mameje rë xi cumachihin yëjë xcusun xi cavitexa Nina. Hane catsingatihin Juan ne, cavitenda me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Xi cama caxtenda Jesús ne, xi tu tivetju me tsëhë nandá jan ne, ngajan cavëë me xi ngahnga ne, catuxaha. Hane Hasen rë Nina ne, canduvajnetsejen casesun rcu me. Hane sacuajyihi xcusun rë ngu paloma jyihi. ");
INSERT INTO maqNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hacuaha canuhya rë ngu cjua ngajan ngahnga xi cachja cuitjin: ―‍Cha vihi xi quihndi naha xi hmú cácun. Jemu ndama ná ngatsë rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hya xi camá ne, Hasen rë Nina ne, quijiniji xu cojo Jesús ngajan ngu xín tsëhë nandya ta ngajan cjuahachuva xitsehen me. ");
INSERT INTO maqNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hya xi cama ne, Jesús ne, yachan nixtin cojo yachan nixten cajinii me niñu. Hya xi cavatju vëhë ne, jercu camavojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sehe camatiñataha xu xitsehen xi cjuahachuva rë me. Cachja cojo rë me cuitjin: ―‍Sá xi ngaye jain xi Quihndi rë Nina ngaye ne, tinoje cojo ndyojo vihi ne, catama niñu. ―‍Cuatjin xu cachja xitsehen cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Peru cuitjin cafayangui me tsëhë xitsehen jan: ―‍Xcun xujun rë Nina ne, cuitjin camahindu: “Hacuiin suvá ngatsë rë niñu xi siu xuta cjuahñu ta hacuaha mameje rë me tsëhë yëjë ni cjua xi catsingatju Nina.” ");
INSERT INTO maqNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sehe xitsehen jan quijicojo xu rë me nandya Jerusalén, nandya ximinchacun, quijisun xu me rcu cjin yungun xi matitjun ");
INSERT INTO maqNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","sehe ngajan xi cachja xu xitsehen: ―‍Sá xi ngaye jain xi Quihndi rë Nina ngaye ne, ningatjin yojo riji tsëhë ndyá ne hisca nangui. Ndaja hye ta tsajin mé cuma ri ta xcun xujun rë Nina ne, cuitjin chja: Nina ne cuitexa me ángel rë me xi sahmi ri cuidadu. Cjuahántsa ri, cojo sa xi ntsacui ne, sacuinhmuaain rë cojo hisca ngu ndyojo. ");
INSERT INTO maqNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ngajan xi cafayangui xu Jesús tsëhë xitsehen cuitjin: ―‍Hacuaha cuitjin chja xcun xujun rë Nina: “Mijí rë xi chjuhunchuvun Nina nuju.” ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hane ngu ndiya nga quijicojo xitsehen Jesús, quijicojo rë me ngu ndetjún hnga ne, sehe catsingacun xitsehen jan me jingujyë ni nandya tsëhë ngasunhndë cojo yëjë ni cjuanchina xi tjin rë. ");
INSERT INTO maqNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ngajan xi cachja xitsehen cojo rë me cuitjin: ―‍Suá ri yëjë nandya xi cuacún vë cojo cjuanchina rë. Hatuxa suá ri sa xi cuindove cuiticjexcuin nguehe xi chjehercuin ná. ");
INSERT INTO maqNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sehe cafayangui Jesús tsëhë xitsehen cuitjin: ―‍Tihinxin Satanás, ta tsëhë xi xcun xujun rë Nina ne, cuitjin camahindu: “Meje rë xi chjuhunrcun Nina naja, hacuaha ngu ni me vëhë xi meje rë xi nihñuchuhun hacutjin xi meje rë me.” ");
INSERT INTO maqNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Xi cuatjin xu cachja Jesús cojo xitsehen jan ne, cavetjuxin tsëhë me. Hane cafehe tjengui ángel me xi cjuahacuenda rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Xi camachaya rë Jesús xi jiya Juan Vitenda rë Xuta ndavaya ne, quiji me distritu Galilea. ");
INSERT INTO maqNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hane cavetjuxin me tsëhë nandya Nasaret, quiji cavejña me nandya Capernaum. Nandya jan ne, tacun tjehen rë ndajyë. Hane nandya jan ne tsëhë xuta tjë rë Zabulón cojo Neftalí. ");
INSERT INTO maqNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Cuatjin cama sehe camachihin cjua xi camahindu xcun xujun xi chja cjua rë profeta Isaías xi chja cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Xuta xi viyuju me nangui rë Zabulón cojo Neftalí, nangui ngajan ngunda ndajyë Jordán, ngajan tjehen rë ndachacun, tsëhë distritu Galilea, nangui rë xutaxín. ");
INSERT INTO maqNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Xuta jan xi jñu cjuatacun rë me, cavëë me ngu me xi sacuaha ngu ndihi seti xi sua rë me cjuahasen. Xuta xi jemu tsavi siu me tsëhë cjuaveya, ndihi jan ne casua rë me hasen rë. ");
INSERT INTO maqNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nixtin hya ne, Jesús ne, cavetsihin catsujyihiya me cachja me cojo xuta cjua rë Nina. Cuitjin cachja me: ―‍Nindeyun cjuatacun nuju ta tsëhë xi camatiña nixtin xi Nina ne cuitexa me ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cama ngu nixtin xi tsujyihiya me ngajan tjehen laguna tsëhë Galilea ne, cavëë me jo me xi hntsë, ngu me xi hmí rë Simón cojo ngu me xi hmí rë Andrés. Titsingatjenya me changa ngajñi ndachacun, tsëhë xi hatuxa xá rë me xi faha me chu ti. ");
INSERT INTO maqNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hane Jesús ne, cachja me cojo me cuitjin: ―‍Nduvun cuanguen cojo ná. Hane cuicuyá nuju xi cuangun nuvun xuta xi cuisehen me ladu naha ngojo rë xi nuvun chu ti. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hane hora vëhë ni caviyuju me changa jan, hane cavetju me quiji me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hitsë sa nguvan ne, cavëë Jesús jo cha xi hacuaha hntsë: Jacobo cojo Juan, cha quihndi rë Zebedeo. Hincha cha cahntsua barcu cojo nahmi rë cha, ngajan tifuyataha cha changa rë cha. Hacuaha cajindaya Jesús cha xi cjuecojo me cha. ");
INSERT INTO maqNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sehe caviyuju cha barcu jan, hane cavejña cha nahmi rë cha quiji cha cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hane Jesús ne, catsujyihiya me yëjë ni ladu tsëhë distritu Galilea. Xi cavisehen me yungun ne, cavicuya me xuta, cachja me cojo xuta cjuandajyihi tsëhë gubiernu xi sahmi Nina. Hacuaha catsirqui me xuta hmu rë; camandaja xuta tsëhë yëjë ni chíhin cojo tsëhë yëjë ni cjuahmu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hane cavitsojo cjua tsëhë cjuarcun xi casahmi Jesús. Cavitsojo cjua jan hisca yëjë nangui xi hmí rë Siria. Hane xuta ne, cafehetjengui me Jesús yaha me xuta hmu rë tsëhë yëjë xcusun chíhin hane catsirqui me. Hacuaha catsirqui me xuta xi hincha xitsehen cahntsua xahasen rë me cojo xuta xi má rë me chajan cojo xuta xi cahme yojo rë. ");
INSERT INTO maqNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hane quijitjengui xutacjín jan Jesús ne, xuta tsëhë cahndë́ xi cuicun vi: tsëhë të nandya xi tsëhë Decápolis, cojo nandya Jerusalén, cojo yahnga sa xuta tsëhë distritu Judea, cojo xuta tsëhë nangui ngunda tsëhë ndajyë Jordán. ");
INSERT INTO maqNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Hya xi cavutsejen Jesús xi camatangun xutacjín jan ne, quijiniji me ngu ndetjun, hane xi cavéjña Jesús ne, casahmitiña xuta tsëhë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sehe cavetsihin cavicuya me xuta jan cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―‍Jemu ndaja tsëhë me xi machaya rë me xi tsichaja sa rë cjuatacun rë me xcun Nina matsejen ta satë rë me gubiernu xi sahmi Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Jemu ndaja tsëhë me xi jihndava me tsëhë cjuachoho matsejen ta Nina sua rë me cjuetacun. ");
INSERT INTO maqNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Jemu ndaja tsëhë xuta jeya, xuta xi hacuiin xta me matsejen ta, cjuahatsja me nangui xi sua Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Jemu ndaja tsëhë me xi sacuaha sahmi yahnga xuta xi vojo rë xi fi tjengui rë comida, cuanitjin tjengui me xcusun xi cuma tyjahi cjuatacun rë me xcun Nina matsejen ta, cuechu nixtin xi cuiyujuchihin cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Jemu ndaja tsëhë me xi tjin rë cjuayumatacun cojo xuta, ta hacuaha cjuahatsja me cjuayumatacun tsëhë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Jemu ndaja tsëhë me xi tjin ngu cjuatacun tyjahi cahntsua xahasen rë me matsejen ta, scuëë me Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Jemu ndaja tsëhë me xi tsinguejyu rë xuta xi chohovëë xicjin me matsejen ta, me vëhë jan ne, cuichja Nina xi quihndi rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Jemu ndaja tsëhë me hya xi tsujyihiya tjengui xuta me cojo cjuahngatacun ngatsë rë xi tjin rë me ngu cjuatacun cojo Nina matsejen, ta satë rë me gubiernu xi sahmi Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Jemu ndaja tsujun ngayun ne sá xi ngatsë naha choho cuichja xuta tsujun o sá xi tsujyihiya tjengui nuju xuta cojo cjuahngatacun o sá xi cojo cjuandesu tsicanijijyë me ngayun. ");
INSERT INTO maqNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nixtin hya ne, jemu catama sua rë xahasen nuju ngatsë rë cjuañihi vë ta jemu jyë ngu cjuandaja xi tacunya nuju ngajan ngahnga. Cuanitjin ni choho casahmi xutachanga naja cojo profeta rë Nina xi caviyuju hatsëë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Ngayun, tjin hacutjin machji rëhë ngayun ngajñi rë xuta sacuaha sahmi naxa xi sahmi xtya rë ngu xichine. Ta sá xi naxa cjuë xtya rë ne, tsajin sa ngu xcusun xi cuma sahmi xtya rë. Hane sá xi cjuë xtya rë ne, tsajin me machji rëhë ta, scandi ni xuta, ngajan ni sune me. ");
INSERT INTO maqNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Cuanitjin ne, tjin hacutjin machji rëhë ngayun ngajñi rë xuta sacuaha machji rëhë ngu ndihi xi sua hasen rë. Ta sá xi ndetjun tacun nandya matsejen ne, hatuxa tsejen; tsajin me xi cuatsa rë. ");
INSERT INTO maqNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Cuanitjin ne, hacuaha tsajin ngu xuta xi ha xcun xi ha cavetaha rë me ngu ndihi ne, sehe cjuaha me cueyahma me ngahma rë ngu caxa. Hatuxa cjuaha me cuejñatsejen me cahndë́ rë cojo sa xi xuta xi siu me hiscan xi seti ndihi jan ne, cuechu hasen rë. ");
INSERT INTO maqNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hacuanitjin chuva vëhë, meje rë xi nihñu cjuandaja xi scuëë xuta xcusun xi nihñu hane ngatsë rë xcusun jan ne, sahmi jyë me sahmi hnga me Nahmi nuju xi tacun me ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Xi caningatuuntacuun matsejen xi nduvá tsinguétsun ngahñu rë ley xi catsihindu xutachanga naja Moisés o cjua xi cachja profeta. Cahndë́ rë xi tsinguétsun ne, sahmechihin cjua jan. ");
INSERT INTO maqNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hatuxa cuichjá cojo nuju cjuaquixi ta hya xi tacun cuaha ngahnga ne tacun cuaha ngasunhndë ne, cumaji chjahanxin rë cjua rë ley jan cojo yëjë ni letra rë ta, cuejña cuaha hiscan cumachihin cjua rë. ");
INSERT INTO maqNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Vëhë xi tu yo ni xi sahmicuendaain tsëhë hisca ngu rquí cjua rë, hane sá cuinchangui me yahnga xuta xi cuanitjin sahmi me, chuva cuengui chji rë me hya xi sahmi Nina gubiernu. Peru tu yo ni me xi cjuahacuenda me hacuaha tsingacun me xuta xi cjuahacuenda me ley jan, me vëhë cuma titjun me hya xi sahmi Nina gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nguehe cuichjá cojo nuju ngayun ta meje rë xi hitsë sa tyjahi cjuatacun nuju xi cumá rë cjuatacun rë xuta xi vicuya me ley o sá xi xuta partidu fariseo, ta sá tsajin ne, satiin nuju gubiernu xi sahmi Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ha hyun cjua xi cafaha xuta hatsëë nixtin xi chja xi canicuun xingun hacuaha chja xi yo xi tsiquehen xicjin matsejen ne, cjue me xcun juez xi tsichuva me jyë́ rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Peru cuichjá cojo nuju xi hisca yo xi macjan rë cojo xicjin ne, satë rë xi tsichuva me. Hane yo xi chjataha xicjin ne, cjue xcun juez xi matitjun. Cuanitjin yo me xi cuichja tsëhë xuta: “Ngarca ngayun”, cuechji me tsëhë jyë́ rë me ngajan xcun ndihi xi tsajin nixtin coho. ");
INSERT INTO maqNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ngatsë rë vihi, sá xi hora xi vejñu chjë nuju ngasunscun ne, sá xi tu ñahñu ni vitsjen nuju xi choho canihñu cojo xingun ");
INSERT INTO maqNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ngajan catejñavasen chjë nuju, titjun cuangun tjengun xingun, hane chjayun rë me cjuaninchataha hane xi camandaja yun cojo me, sehe cuyun cuejñu chjë nuju jan. ");
INSERT INTO maqNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Sá ndiya tivangun cojo xuta xi meje cuinchajyë nuju xcun xutaxa rë ne, meje rë xi cuisiajmuchuhun cojo me, cojo sa xi ngajñi nuju cuma chihin ta sá tsajin ne, cjuecojo nuju me xcun juez. Hane juez matsejen ne, squindaya me mayu sehe sahmi nuju me entregadu, hane cjue cueya nuju me ndavaya. ");
INSERT INTO maqNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta cuichjá cojo nuju cjuaquixi ta hatuxa tsajin nixtin xi cuetjun tsëhë ngajan jinguyëjë rë xi cjëë cuechjun yëjë ni tujún xi quitjun. ");
INSERT INTO maqNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ha hyun cjua xi cafaha xuta hatsëë nixtin xi chja cuitjin: “Xicanihñuu cjuatsehen cojo rë ngu chjuun o cojo rë ngu xihin xi hacuiin tsujun.” ");
INSERT INTO maqNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Peru cuichjá cojo nuju xi hisca xi ngu xihin xi vutsejen me ngu chjuun xi macacun me cojo na, ngajñi cjuatacun rë me ne, ha casahmi me cjuatsehen cojo ran. ");
INSERT INTO maqNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Hindë sá xi cjuatacun nuju meje rë xi nihñu ngu jyë́ tsëhë xcusun xi chutsujun cojo tuxcuun ladu quixi, hitsë sa ndaja tsujun sá xi chjuhunxun tuxcuun jan chandunxun cojo sa xi hacuiin tsitsehen nuju, ta hitsë sa vengui chji rëhë xi ma chaja nuju ngu rquí yojo nuju hane hacuiin xi cuangun jingu hiscan xi má hasen rë nima castigu. ");
INSERT INTO maqNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Cuanitjin ne, sá xi cjuatacun nuju meje rë xi nihñu ngu jyë́ cojo ntsun quixi ne, hitsë sa venguichji rëhë xi chandunxun ntsun jan ta hitsë sa ndaja tsujun xi machaja ngu rquí yojo nuju tsëhë xi cuangun jingu hiscan xi má hasen rë nima castigu. ");
INSERT INTO maqNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Hacuaha cafaha xuta hatsëë nixtin cjua xi chja cuitjin: “Ngu cha xi tsismi chjuun rë ne catejña cha ngu xujun tsja chjuun jan xi ha quihndë mijí rë cha na.” ");
INSERT INTO maqNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Peru nguehe cuichjá cojo nuju ta yo xi tsismi chjuun rë handasa ndastu mé cjuatsehen casahmi chjuun jan cojo ngu xihin xi hacjahi, hacuaha tjin rë me jyë́ ta sehe ngatsë rë xi catsismi me na ne sahmi chjuun jan cjuatsehen. Hacuaha yo xi cuixan cojo chjuun jan ne, tangun jyë́ rë cojo ngu xi sahmi cjuatsehen cojo ngu chjuun xi hacuiin chjuun rë. ");
INSERT INTO maqNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Hacuaha hyun cjua xi cafaha xuta hatsëë nixtin xi chja cuitjin: Hya xi cuinújun: “Vëë Nina”, hatuxa sahmi ngujyë xi nihñuchuhun cjua xi canújun. ");
INSERT INTO maqNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Peru nguehe cuichjá cojo nuju ta hora xi cuisiajmu cojo xingun ne, hacuiin cuinújun xi vëë Nina, hacuiin cuinújun xi vëë sa jingu sa quihndi ngasunhndë. Cuinujuun xi vëë ngahnga ta ngahnga ne, tacun Nina xi vitexa me. ");
INSERT INTO maqNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hacuaha cuinujuun xi vëë ngasunhndë ta ngasunhndë ne, tangun sacuaha ngu yatë hiscan xi tine ntsacu Nina. Cuinujuun xi vëë Jerusalén ta Jerusalén ne, nandya xi tsëhë Nina, Me xi Matitjun. ");
INSERT INTO maqNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Cuinujuun cuitjin: “Sá xi quixiin jain cjua naha ne, catinduva ngu cjuacjintacun xi cuatjun”, ta tsëhë xi ngayun ne, hisca hitsë cumaji cuitexun sá xi cuma jma tsjarcun o sá xi cuma tyjava. ");
INSERT INTO maqNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hya xi cuisiajmu, sá xi “joho” nújun ne, cuanitjin ni cuitejña; o sá xi “jéya” nújun, hacuaha cuanitjin ni ndatjin ta, sá xi vetjutë visiajmu cjua cjín jan ne, cjua cjín jan ne, nduva tsëhë cjuatsehen. ");
INSERT INTO maqNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Hyun cjua xi cafaha xuta hatsëë xi chja cuitjin: Cha xi cuahaxin tuxcun xicjin ne, hacuaha chjahaxin rë tsëhë cha. Cuanitjin cha xi cuahaxin nehñu xicjin ne, hacuaha cuanitjin ni chjahaxin rë nehñu cha. ");
INSERT INTO maqNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Peru nguehe cuichjá cojo nuju ta, canicuyuun cjuatsehen. Sá xi tjin yo xi vanguihmu nuju, yo xi vajaya ngu ladu tsa nuju matsejen ne, nicuyun sa ngu ladu catajaya. ");
INSERT INTO maqNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Cuanitjin ne, sá xi tjin yo xi cjuecojo nuju xcun juez xi fahataha chingá nuju matsejen ne, hacuaha tuhun rë me cojo yëjë ni tsjian hasu nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Cuanitjin ne sá xi ngu xuta ne, sahmi nuju me ngujyë xi chanuju chaha rë me ngu kilómetro, cahndë́ rë ngu ni, tanguncujun jo kilómetro. ");
INSERT INTO maqNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yëjë ni xuta xi fehya nuju me mé xi machaja rë me matsejen ne, tuhun rë me. Hane sá xi scuxetaha nuju me, tuhun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Hyun cjua xi cafaha xuta hatsëë nixtin xi chja cuitjin: “Nihmutacún xuta xi siutahndee nuju; choho hyun xuta xi má condra nuju.” ");
INSERT INTO maqNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Peru cuichjá cojo nuju ta, hacuaha nihmutacún xuta xi má condra nuju; ndaja nihñu cojo xuta xi choho vëë nuju me. Nújunyumuntuhun rë xuta xi tsujyihiya tjengui nuju me cojo cjuahngatacun. ");
INSERT INTO maqNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Sá xi cuatjin nihñu ne, cumatsejen xi chjayunngun sacuaha sahmi Nahmi nuju xi tacun ngahnga ta, Nina ne, sahmi me xi ngu chihin ni vetjucaa tsuhi xi casahmi me hane vechu hasen rë hiscan siu xuta tsehen hacuaha hiscan siu xuta ndaja. Hacuaha sahmi me xi vaha tsi xcun jnu rë xuta xi tjin xi cun rë me, hane hacuaha xcun jnu rë xuta xi tsajin xi cun rë me xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tsajin yo xi sua chjí nuju tsëhë xi hmutacún xuta xi hmucacun nuju me matsejen, tsëhë xi hacuaha hisca cha faha tujúnsa (xi jemu vaxë cha tujún) matsejen ne, hmucacun cha xuta xi hmucacun rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hacuanitjin ne, sá xi suvun cuinújun nina cojo xuta nuju ne, ¿há hitsë sa ndaja yun xi cuma rë yahnga xuta? ¡Jéya! Hisca xuta xi macjaain rë me Nina ne, tjin rë me xcusun ndaja vë. ");
INSERT INTO maqNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Vëhë xi mameje rë xi tangun cojo ngasunhndë nuju cojo ngu xcusun xi tyjahi chichihin ni, cumatangun xcusun nuju cojo xcusun rë Nina xi tyjahi chichihin cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Hya xi nihñu ngu cjuandaja ne, nihñu nguñajatacun, hacuiin nihñu tsëhë xi scuëë nuju xuta; ta sá tsajin ne, ndastu me chji sacu tsëhë Nahmi nuju xi tacun ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cuanitjin ni sacuaha cjua vë, hya xi tuhun ngu caridad matsejen ne, xi canijanuu ngu tyjo xi tuhun cumachaya rë xuta cjuandaja jan. Hacuaha cuatjin sahmi xuta xi jo xcun jo hntsua me hya xi sua me caridad ngajan yungun o ndiya ngatsë rë xi vaxëndaja xuta me. Tichjá cojo nuju ta ha vëhë ni chji sacu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Vëhë xi ngayun ne, hya xi tuhun caridad ne, catuun cumachaya rë ntsun ladu xcun mé xi tuhun cojo ntsun ladu quixi. ");
INSERT INTO maqNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Cuatjin hya xi tuhun caridad ne, tuhunhmu matsejen ne, hane xi cuatjin nihñu ne, Nahmi nuju xi tacun ngahnga ne xi cavëë me cjuandaja xi canihñu ne, sua me chji nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Hacuaha hya xi nihñu oración, xi canihñuu sacuaha xuta xi jo xcun jo hntsua me ta me vëhë ne, jemu meje sahmi me oración cahntsua yungun cojo sa hiscan sahmi cru ndiya të hiscan xi scuëë xuta me. Nguehe cuichjá cojo nuju ta ha vëhë ni chji sacu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Vëhë xi ngayun ne, hya xi nihñu oración ne, techjun tingotjo ndya nuju hane tangun cahnchun, ngajan hma nihñu oración cojo Nahmi nuju xi tacun ngahnga ta ngu ni me vëhë xi tacun me cojo nuju. Hane Nahmi nuju jan xi vëë me yëjë xcusun xi hincha hma ne, sua me chji nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Hacuaha hya xi nihñu oración, caveyunnanguun ngu cjua xi hisca suvun vijniircun sacuaha xcusun xi sahmi xuta xi hvíin me cjua rë Nina, ta xi má rë me vë ne, xi hitsë cjín cjua cuichja me ne, hacuaha hitsë sa cuahacuenda Nina tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mijí rë xi nihñu xcusun vëhë, ta hisca chaja sa xi chjahyun rë Nahmi nuju xi tacun ngahnga ne, ha vëë me mé xcusun xi mameje nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Cuanitjin nújun hya xi nihñu oración: Ngayun Nahmi niji xi nechun ngahnga ne, meje rë xi ngayijin ni xuta ngasunhndë chjihinrcuin nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nduvun nihñu niji gubiernu. Catamachihin cjuatacun nuju nguehe ngasunhndë sacuaha ngahnga xi ha camachihin. ");
INSERT INTO maqNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nchunchujun ni ne, tuhun niñu xi xini. ");
INSERT INTO maqNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ninchatuhun niji tsëhë yëjë ni jyë́ niji ta hacuaha ngayin suvin ni tininchatihin rë xuta xi choho sahmi me cojo niji. ");
INSERT INTO maqNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Caningatjuun xi chjaháchuva niji cojo cjuatacun niji ta, tuhun niji ngahñu xi cuma cuetjinxin tsëhë cjuatsehen. Tsujun suvun gubiernu cojo ngahñu, hacuaha tsujun ni hasen rë ngahñu cjua nuju. Tsujun yëjë vë, yëjë nu, yëjë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Hya xi cajnetaha oración jan, cachja sa Jesús cuitjin: sá xi ninchatuhun xuta xi choho casahmi me cojo nuju ne, hacuaha Nahmi nuju xi tacun ngahnga ne, tsinchataha me jyë́ nuju, ");
INSERT INTO maqNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","peru sá xi ninchatuun xuta xi choho casahmi me cojo nuju ne, hacuaha Nahmi nuju jan ne, tsinchataain me jyë́ nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ngayun ne, nixtin xi nechun xun rë Nina ne, nihñuu va xcusun nuju sacuaha sahmi xuta xi jo xcun jo hntsua me ta sahmi va me xcusun rë me, ta me vëhë ne, hisca catsindeya me xcusun rë me sehe cumatsejen xi tacun me xun rë Nina. Cuichjá quixi cojo nuju ta ha vëhë chji xi sacu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Vëhë xi ngayun ne, hya xi nechun xun rë Nina ne, tinchacjun, nihñu tyjahi yojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Cuatjin nihñu cojo sa xi tsajin yo vëë rë xi nechun xun rë Nina, ta suva Nina, Nahmi nuju vëë me. Hane me vëhë ne cuechji me yun. ");
INSERT INTO maqNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Cavetjuun cjuanchina nuju nguehe ngasunhndë, ta nguehe ne, sahmi dañu chu xavi cojo xutsë. Nguehe ne cuma scuxahaya cha chëjë, hane sehe tsichëjë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hitsë sa ndaja ne, tetjún cjuanchina ngajan ngahnga ta ngajan ne tsajin dañu xi sahmi chu xavi cojo sa xutsë. Ngajan ne scuxaain cha sehe xi tsichëjë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Cuatjin meje rë xi ngajan cuetjun tsujun ta, tsëhë xi hiscan tetjo cjuanchina nuju ne, hacuaha ngajan quitaha cjuatacun nuju cojo. ");
INSERT INTO maqNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Tuxcuun matsejen ne, vëhë xi sacuaha ndihi rë yojo naja. Vëhë xi hya xi tuxcuun ndacun ne, hatuxa seya cjuahasen cahntsua yojo naja. ");
INSERT INTO maqNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Peru sá xi tuxcuun hmu matsejen ne, hacuaha ma jñu cahntsua yojo naja. Sacuaha hasen xi jiya cahntsua yojo naja ne, sá xi hacuiin hasen xi cjuaquixi jain ta, suva jñú ne, ¡jercu tu jñú camahani cuma sa! ");
INSERT INTO maqNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Tsajin yo xi ma fahacuenda xa tsëhë jo patrón ta, tsëhë xi choho scuëë rë patrón xi tjun hane tsihmu cacun rë patrón xi majo jan. O sá tsajin ne, jemu cuetaha yojo rë cojo patrón xi tjun hane patrón xi majo jan ne, hisca sahmicuendaain rë. Vëhë xi xi ngu tangun ni ne, cumaji nihñu hacutjin xi meje rë Nina cojo hacutjin meje rë cjuanchina tsehen xi tsëhë ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Vëhë xi cuichjá cojo nuju ta hacuiin cuityjanguntacun sá sacu o sá sacuiin mé xcusun xi xinu xi sua nuju ngahñu. Hacuaha hacuiin cuityjanguntacun sá sacu o sá sacuiin tsjian xi chujun. Hitsë sa vengui chji rë cjuahñu nuju xi cumá rë xi chinu, hacuaha hitsë sa vengui chji rë yojo nuju xi cumá rë tsjian xi chujun. ");
INSERT INTO maqNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chutsujun chu nisë xi vitjen chu ngahnga ta hacuiin tsitjë chu, hacuiin fanchi chu, hacuaha tsajin rë chu ndyahnga hiscan cuinchandaja chu xi sinë chu, peru Nahmi nuju xi tacun me ngahnga ne, tsicjen me chu. Ngayun ne, hitsë sa vengui chji nuju xi cumá rë chu nisë vë. ");
INSERT INTO maqNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hacuaha tsajin hisca xi ngu xuta xi cuma cuesuntaha me cjuahñu rë me hisca ngu hora ta hacuiin cavatsë chji me cjuahñu rë me. Tu mahya ne xi tjercu vityanguicacun me. ");
INSERT INTO maqNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Cuanitjin ne, ¿mé má chji rëhë xi cuityjanguntacun tsëhë tsjian xi chujun? Chutsujun naxu liriu xi vetju nguijña ta tsihyaain nachjun hacuaha fahyaain tsjian rë. ");
INSERT INTO maqNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Peru ngahan cuichjá cojo nuju ta tsjian rë xutachanga naja Salomón ne, handasa jercu ndacun camahani, peru hitsë sa ndajyihi tsejen ngu naxu vëhë xi cuma rë tsjian jan. ");
INSERT INTO maqNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sá xi cuatjin tsicaja Nina xca nguijña xi ngu nixtin ne siutaha nguijña, hane xi tu cuma nchujun nga ne, cueti ne, hitsë guan sa ngayun xi hatuxa tsicaja nuju me. Peru ngayun ne, cjëë cumangutacunndujun cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Vëhë xi hacuiin cumacjintacún hane cuinengunsuun cuitjin: “¿Mé comida xini? o sá ¿jani sacu niji xi sihin? o sá ¿mé tsjian chijin?” ");
INSERT INTO maqNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hacuiin ta, tsëhë xi xcusun vëhë ne, xuta xi hvíin me cjua rë Nina ne, me vëhë xi vityanguicacun me xcusun vëhë. Peru ngayun ne, Nina Nahmi naja ne, ha vëë me xi machaja nuju xcusun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tityjanguntacun hacuaha nechunyun rë gubiernu xi sahmi Nina, hacuaha catama tangun cjuatacun nuju cojo cjuatacun rë me ne, hane yëjë ni xcusun vëhë ne, quitahacoo sa sacú nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Cuanitjin ne, hacuiin cumacjintacún tsëhë mé xi cuma cuatju nchujuni, ta xi cumá rë nchujuni matsejen ne, hya yaha cjuacjintacun rë. Ngu nixtin ngu nixtin ne, chjuhun cuendun cjuacjintacun rë ta jima ngu nixtin cojo tsëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Hacuiin nichuvun jingu sa xuta cojo cjuatacun rë me, sehe hacuiin tsichuva Nina ngayun. ");
INSERT INTO maqNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Canichuvuun ta sá tsajin ne, chuva xi quixi yun cojo xuta ne, hacuaha cuanitjin quixi Nina cojo nuju; hacuaha chuva xi nichuvunyun matsejen ne, vëhë ni tsichuva Nina yun. ");
INSERT INTO maqNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Hacutjin má xi matsejen nuju xtë xi jiya tuxcun xingun? ta ngayun ne hitsë sa jyë xi jiya túxcun. ");
INSERT INTO maqNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Hacutjin má xi cuma cuinújun cojo xingun xi meje naxun xtë xi jiya tuxcun me jinguyëjë rë xi suvun matsejen ne, machayiin nuju xi hitsë sa jyë xta xi jiya túxcun vë ni? ");
INSERT INTO maqNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ngayun xuta xi jo xcun jo hntsua ne, naxun titjun xtë jyë xi jiya túxcun vë, sehe cumatsejenndaja nuju xtë xi jiya tuxcun xingun cojo sa xi cuma naxun. ");
INSERT INTO maqNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Sá xi tjin nuju mé xi venguichji rëhë sacuaha tjin rë cjuandaja xi casua Nina yun, tetjuhunndujun hacuiin tu yo ni tuhun rë ta sá tsajin ne, xuta jan ne, tsitjungui me xi ngayun jemu ximinchacun xi cuma nuju. Hacuaha cuichjataha nuju me. ");
INSERT INTO maqNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Chjahyun rë Nina, hane sua nuju me. Tinchunsun, hane sacú nuju. Tinújun hacuaha chjahyun cahndë́, hane Nina sua me cahndë́ xi cuisuhun cuinújun cjuacjintacun nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Cuatjin nihñu ta, yëjë ni xuta xi fehya rë me ne, cuahatsja me, hane yo xi vanguise ne, sacu rë me, hane yo xi chja hacuaha fehya cahndë́ me ne, sacu cahndë́ cuisehen me. ");
INSERT INTO maqNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Há tjin ngu nahmi xi, hya xi quihndi rë me cjuehya ngu niñu ne, cahndë́ rë xi vëhë ne, sua me ngu ndyojo, ");
INSERT INTO maqNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","o sá xi cjuehya quihndi yojo rë chu ti ne, cahndë́ rë vëhë ne, sua me ngu yë? ");
INSERT INTO maqNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sá xi ngayun xi xuta jyë́ yun ma tuhun rë quihndi nuju xcusun xi ndaja. Hitsë guan sa Nina Nahmi naja xi tacun me ngahnga xi jyë hnga me cojo cjuandaja rë me ne, me vëhë vëë me mé cuatjo ndaja xi cuma sua me xuta xi cjuehya rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Sacuatjin xi meje nuju xi sahmi xuta cojo nuju matsejen ne, hacuaha cuanitjin ni nihñu cojo rë me: cuatjin nihñu ta cojo ngu xcusun ni xi tinihñu vëhë ne, ngayun tinihñuchuhun yëjë ni cjua rë ley cojo yëjë ni cjua xi catsihindu profeta. ");
INSERT INTO maqNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Cuisuhun hiscan sahmi Nina gubiernu sá xi cuisuhun tingotjo xcu ta, tsëhë xi sá xi cuisuhun táha tingotjo të o ndiya xi cjín me vatjun me ne; vëhë ni cjuecojo nuju cjuaveya hiscan xi jemu cjín xuta cjue me. ");
INSERT INTO maqNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ta tingotjo xcu o ndiya hndë ne, vëhë xi cjue cojo nuju hisca xi sacu nuju cjuahñu. Jemu chuva xuta xi sacu rë me tingotjo xcu jan. ");
INSERT INTO maqNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Cuidadu tsëhë profeta ndacha ta xi tjengui nuju me, jeya tsejen xcusun rë me sacuaha xcusun rë chu tsánga, peru quixiin vëhë ta suva cjuandacha ta xahasen rë me ne, quitsë rë cjuatsehen sacuaha cahntsua xahasen rë chu lobo. ");
INSERT INTO maqNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tsejen mé xcusun xuta me ngatsë rë xcusun xi sahmi me. Sacuaha ngu ya ne, tsejen mé xcusun rë ngatsë rë tu xi sua. Sacuiin rë xuta uva tsëhë ya nahyálatu, hacuaha sacuiin rë xuta tuhaxi xi hmí higo tsëhë nahyándehya. ");
INSERT INTO maqNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Quixi jain ta ngu yatjë xi ndaja ne, sua tú xi ndaja, hacuaha ngu ya xi machjiriin ne, hacuaha machjiriin tu rë. ");
INSERT INTO maqNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Vëhë xi ngu yatjë ndaja ne, cumaji sua tú xi machjiriin, hacuaha ngu ya xi machjiriin ne, cumaji sua tú xi ndaja. ");
INSERT INTO maqNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hane yatjë xi machjiriin tú rë ne, xtíjñi rë tsëhë xi ndaja sehe cueti. ");
INSERT INTO maqNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Cuanitjin xuta ne, tutjin rë yatë vë ne, cuatjin rë me ta, tsejen xcusun rë xahasen rë me ngatsë rë xcusun xi sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Tjin yo me xi cuichjacojo ná ta nai rë me ngahan, peru cuisiin me gubiernu xi sahmi Nina nahmi naha; ta ngajan cuisehen suva xuta xi sahmichihin me cjuatacun xi vitexa Nahmi naha xi tacun me ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Vëhë xi handasa xi jemu cjín me cuichja me nixtin hya jan cuitjin ta: “Nai naha, ngatsë rë xi hñu ngayun, vëhë xi caveyinnangui ñihi nuju ne canújin cjua rë Nina, hacuaha xi canújin ñihi nuju ne, canaxinxin xitsehen, hane cojo ngahñu rë ñihi nuju cama canihñi cjuarcun.” Cuatjin cuichja me nixtin hya. ");
INSERT INTO maqNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngajan xi ngahan ne, cuitjin cjuayanguë tsëhë me nixtin hya: “Tángunxun tsahan ta hveen yo ngayun, ngayun xi nihñu cjuatsehen.” ");
INSERT INTO maqNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Yahnga xuta xi visiñuju me cjua naha hacuaha sahmi me sacuatjin chjá cojo rë me matsejen ne, tangun me cojo ngu cha quicun xi hya xi casahmi cha ngu ndihya matsejen ne, hiscan xcun nanguihñu casahmi cha. ");
INSERT INTO maqNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hane hya xi cavaha tsi, camajyë ndajyë hacuaha casesuntë nandá, hacuaha cavanga tjo hñu ne, jercu hñu catsivaha rë ndihya jan, peru caticjaainjnii tsëhë xi xcun nanguihñu secun. ");
INSERT INTO maqNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Peru yahnga nga xuta xi visiñujuu me cjua naha hacuaha sahmii me sacuatjin chjá cojo rë me matsejen ne, tangun me cojo ngu cha ngarca xi hya xi casahmi cha ngu ndihya matsejen ne, hiscan xcun nangui tsumi casahmi cha. ");
INSERT INTO maqNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hane hya xi cavaha tsi, camajyë ndajyë hacuaha casesuntë nandá, hacuaha cavanga tjo hñu ne, jercu hñu catsivaha rë ndihya jan, hane tu ngu ñahñu ne caticja ndihya jan, ngu cafë cavetsunya. ");
INSERT INTO maqNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Xi cajnetaha cachja Jesús ne, xutacjín ne jercu quijircun rë me tsëhë cjua xi cavicuya Jesús ta, ");
INSERT INTO maqNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tsëhë xi cjua xi vicuya me ne, jercu tjin rë ngahñu, hacuiin sacuatjin cjua xi vicuya maestru xi vicuya ley. ");
INSERT INTO maqNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hya ha cavijne me tsëhë ndetjun jan, jemu cjín xuta tjengui rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hya xi camá ne, cafehe ngu cha xi jingujyë ni chuxin rë yaha rë ngu chíhin xi vitaha, caticjaxcun cha cafaharcun cha Jesús hane cachja cha cuitjin cojo rë me: ―‍Tatá. Sá xi meje nuju ne, cuma chjuhunxun chíhin xi yaha ná vi. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Hane xi catsixinga Jesús tsja me ne cavetahatsja me cha ne, sehe cachja me cuitjin: ―‍Meje ná. Catamandaja ngaye. ―‍Cuatjin cachja me. Hane chíhin jan ne, ngutjen ni cafëya. ");
INSERT INTO maqNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sehe cavitexa me cha cuitjin: ―‍Hisca xi ngu ni canujiin cojo. Tihin ningacuin yojo riji xcun nahmi sehe catutsejen me xi camandaja ye. Sehe tihinchjehe cjuatjo riji xi tehe rë Nina ngatsë rë xi camandaja ngaye tsëhë chihin jan, sacuaha cavitexa Moisés xutachanga naja. Cuatjin nihñi cojo sa xi cumatsejen xi camandaja jain ngaye. ");
INSERT INTO maqNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Xi cavatju vihi ne, sehe rë cavisehen me nandya Capernaum, hane ngajan cafehe tjengui rë me ngu capitán cafehya cha me favor ");
INSERT INTO maqNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","cuitjin cachja cha: ―‍Tatá. Tjin ná ngu cha mosu xi jiñahmu ndya naha. Cahme yojo rë cha hane jemu jiñañihi cha. ");
INSERT INTO maqNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ngajan cafayangui Jesús: ―‍Cjuë́ ngahan, tsírquë rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngajan xi cafayangui capitán jan cuitjin: ―‍Hisca hacuiin sahmi ngujyë xi ngayun cuinduvun ndya naha ta tsëhë xi hitsë sa hñu cjua yun xi cuma ná ngahan. Quihndë ne, ndastu tinújun xi cumandaja mosu naha hane cuma ndaja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Hacuaha ngahan ne, tjin ná xuta xi matitjun tsahan, hane hacuaha tjin ná ngu cientu sindadu xi siu ngahma gubiernu naha xi sahmi hacutjin xi meje ná. Hya xi chjá cojo ngu xi cjue ne, fi; hacuaha xi chjá cojo ngu nga xi cuinduva ne, nduva, hane mosu naha ne, xi chjá cojo xi sahmi mé xi meje ná ne, sahmi. ―‍Cuatjin cafayangui capitán. ");
INSERT INTO maqNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hane xi cahndë Jesús cjua vëhë ne, jemu quijircun rë me tsëhë capitán jan, hane cachja me cojo xuta xi tjengui rë me cuitjin: ―‍Cuichjá cojo nuju ngu cjua ta, ngajñi naja ngayejen ni ngayaan xuta tjë rë Israel ne, cjëë scuëë ngu xuta xi cuatjin ndaja mangucacun me cojo ná sacuaha capitán vihi xi hacuiin xuta tjë naja me. ");
INSERT INTO maqNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Hacuaha cuichjá cojo nuju ta cuinduva xutaxín tsëhë táha ladu vetjucaa tsuhi cojo táha ladu vetje tsuhi cuiyuju me sinësuhi me cojo Abraham cojo Isaac cojo Jacob ngajan hiscan sahmi Nina gubiernu, ");
INSERT INTO maqNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Peru xuta tjë rë Abraham xi quihndi cjuaquixi ne, cuma tsingatju me hiscan jñu ngajan candatsen. Ngajan ne, jemu squihnda me hacuaha tsijanerii me nehñu me. ");
INSERT INTO maqNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hya xi camá cachja Jesús cuatjin cojo xuta ne, sehe cachja Jesús cojo capitán jan cuitjin: ―‍Cuma cuangun ta tsëhë xi xcusun xi vetjutacun xi má sahme, camachihin. Hane hora xi cachja me cuatjin ne, camandaja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Hya xi cama ne, cavisehen Jesús ndava Pedru ne, hane cavëë me xi jiñahmu nahya rë Pedru cojo chíhin suë. ");
INSERT INTO maqNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ngajan xi cavetahatsja Jesús tsja na, hane ngutjen cavetjuxin chíhin jan tsëhë na. Hane hora vëhë ni ne, cavisatjenhnga na hisca cama cafahacuenda na me. ");
INSERT INTO maqNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hane hora xi tivetje tsuhi ne, xuta ne, quijicojo me cjín xuta xi hincha rë xitsehen hane quiji me hiscan tacun Jesús. Hane Jesús ne, cavaxëxin me xitsehen jan cojo cjua ni, hacuaha catsirqui me yëjë xuta hmu rë. ");
INSERT INTO maqNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Cuatjin casahmi me sehe cumachihin cjua xi cachja profeta Isaías xi cachja me cuitjin: “Cafaha suva me yëjë chíhin hinda xi tjin rë yojo naja, hane suva me cavaha me chíhin naja.” ");
INSERT INTO maqNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Xi cavëë Jesús xi jemu tsë xuta hiscan tacun me ne, casua me cjua cojo xicjin me xi cjuexin cojo rë me ngunda laguna. ");
INSERT INTO maqNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngajan cafehe tjengui rë me ngu cha maestru rë ley sehe cachja cha cuitjin: ―‍Maestro. Tu yani ni xi cuangun ne, cjuë́ cojo nuju. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sehe Jesús ne, cafayangui me cuitjin: ―‍Chu ninda ne, tjin nguijo hiscan viyuju chu, hane nisë xi vitjen chu ngahnga ne, tjin ndava chu, peru ngahan xi hatuxa Quihndi rë Xuta ngahan ne, hisca ndya naha tsajin. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ngu nga xuta xi tjengui rë me cachja cojo rë me cuitjin: ―‍Tatá. Cuanguen cojo nuju peru hya xi cuatju seyaniji nahmi naha. ");
INSERT INTO maqNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Peru cafayangui Jesús cuitjin: ―‍Hanguen. Tehe vëhë catisahmi xuta xi cahme cjuatacun rë me, me vëhë catinchaniji me nima. ");
INSERT INTO maqNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hya xi camá ne, cavisehen Jesús cahntsua ngu barcu hane ngajan quiji tjengui rë me xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hora xi cjui barcu jan ne, canduva ngu tjohñu xi cavanga xcun laguna jan, hane hisca meje tsa rë barcu jan cojo tsindyu rë nandan xi satë rë jan. Peru hora vëhë Jesús ne, jiñafë me. ");
INSERT INTO maqNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sehe xuta ladu rë me ne, catsingasca rë me, hane cuitjin cachja me: ―‍¡Tatá, tatá! ¡Naxuntjun naja! ¡Nguehe cjuëyan! ―‍Cuatjin cachja me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hane cachja Jesús cuitjin: ―‍¿Mé má cuatjin jemu rcun ngayun, ngayun xi cjëë cumangutacún cojo ná? Hya xi cachja me cuatjin ne, cavisatjenhnga me cavatëcja me ngahñu rë tjo jan cojo tsindyu rë nandan jan, hane jingujyë ni jan ne, cavejñajyuu. ");
INSERT INTO maqNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hya xi camá ne, xuta jan ne, jercu quijircun rë me hane cachja me cuitjin: ―‍¿Yo xuta me vihi xi hisca tjo hisca tsindyu rë nandan vihndë tsëhë me? ");
INSERT INTO maqNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hya xi camá ne, cafehe Jesús cojo cha ladu rë me ngunda vëhë, hisca ladu rë xuta nandya Gadara ne, ngajan jo me xi hincha xitsehen xahasen rë quiji tiña me tsëhë Jesús. Catsijo me xi cuacun jan ne, siu cahndë́ me ngojo naxi hisca xi sacuaha tsjun. Hacuaha jemu cjan rë me hisca tsajin yo xi tsujyihiya taha vë jan. ");
INSERT INTO maqNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hya xi cavechu me hiscan tacun Jesús, cojo ngahñu rë xitsehen jan, cavetsihin cachja me cuitjin: ―‍Mé má cuatjin ninguisuhunjñu cojo niji ngayun Jesús, Quihndi rë Nina. ¿Há tuhun niji cjuañihi handasa chaja sa nixtin rë? ");
INSERT INTO maqNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nixtin hya ne, ngajan tiñataha ne, tacun ngu cahndë́ hiscan jemu cjín chu chinga hinchataha chu tijine chu. ");
INSERT INTO maqNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hane xitsehen jan ne, ña yuma chja cojo Jesús cachja cuitjin: ―‍Sá xi hatuxa naxunxun niji tsëhë xahasen rë cha xi cuicun vi, ningatjun niji hiscan siutaha chinga, hacuaha ningatuhun niji xi cuisihin cahntsua xahasen rë chu. ");
INSERT INTO maqNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hane cachja Jesús ta: ―‍Joho, tangun. Hya xi camá ne, cavetjuxin xitsehen tsëhë cahntsua xahasen rë cha jan, hane cavisehen cahntsua xahasen rë chu chinga jan. Hya xi camá ne, yëjë ni chu chinga jan ne, cavanga chu quijijne chu taha rcu ndetjún, hane ngajan cavixuya chu ngajñi nandá tsëhë laguna, hane ngajan cafë chu, cahme chu. ");
INSERT INTO maqNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hane ngatsë rë chircun jan ne, cha xi sahmi cuidadu rë chu chinga jan, cavanga cha quiji cha nandya. Hane xi cavisehen cha nandya, casua cha camachaya rë xuta tsëhë xcusun xi camá rë chu chinga jan cojo xcusun xi cavatju jo cha xi hincha rë xitsehen jan. ");
INSERT INTO maqNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hya xi camá ne, yëjë xuta tsëhë ladu tsëhë nandya Gadara ne, quijitjengui me Jesús hiscan tacun me, hane xi cavechutaha xuta me ne, cafehya me Jesús xi catje me tsëhë ladu rë me jan. ");
INSERT INTO maqNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hya xi camá ne, cavisehen nga Jesús barcu, cafe me nangui rë me ta tacun ngunda laguna. ");
INSERT INTO maqNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hya xi camá ne, ngutjen ni quijitjengui xuta me hane xuta jan ne, yahahnga me ngu cha xi cahme yojo rë cha, jiña cha xcun nijña rë cha. Hane xi cavëë Jesús xi cuatjin mangu cacun xuta xi cuacun jan cojo rë me ne, sehe cachja xu me cojo cha hmu rë jan cuitjin: ―‍Tuhun cjuasua xahasen nuju ta jyë́ nuju, tsan ne, ha camanchataha. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ngajan xi ngu jo maestru xi vicuya cjuachacun ne, cavetsihin catsingataha cacun me cuitjin: “Nina tsixcuehyu cha.” ");
INSERT INTO maqNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hane tsëhë xi vëë Jesús cjua xi tsingatahacacun maestru jan ne, cuitjin cavinenguise me cha: ―‍¿Mé má cuatjin chojyihi ningatuhuntacun? ");
INSERT INTO maqNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Xi má nuju, ¿jarë cjua xi hitsë sa tsaviin fi xi cuichjá: há xi “Jyë́ nuju ne, ha camanchataha” o há tsajin ne; há “Tisatjunhngun ne, tujyuhunyun?” ");
INSERT INTO maqNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Peru nguehe suá cumachaya nuju ta ngahan xi Quihndi rë Xuta Jain ngahan ne, yahá xá xi tsinchátaha jyë́ rë xuta nguehe ngasunhndë. Sehe ngajan cachja xu Jesús cojo cha hmu rë jan: ―‍Quihndë ne, ngayun tsan ne, tisatjunhngun chjuhun nijña nuju vë, sehe tjangun ndya nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hya xi camá ne, cavisatjenhnga cha quiji cha ndava cha. ");
INSERT INTO maqNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Xi cavëë xuta xcusun xi camá ne, quijircun rë me, sehe casahmi hnga me Nina ta Nina ne, casua me cahndë́ Jesús xi cuatjin casahmi me. ");
INSERT INTO maqNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Xi quiji sa xu Jesús ne, cavechu me hiscan cavëë me ngu xihin xi tacun cahndë́ hiscan xi faha tujúnsa. Mateo hmí rë me. Ngajan xi cachja Jesús cojo me cuitjin: ―‍Nduvun, cuanguen cona. Hane Mateo jan ne, cavetju me quiji me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ha nixtin vëhë ne, tijine Jesús niñu ndava Mateo. Hane jemu cjín sa cha xi faha tujúnsa cojo yahnga cha xi tsitjungui xuta nangui vë ne, hacuaha tijine cha niñu ngajan. ");
INSERT INTO maqNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Peru xi cavëë cha partidu fariseo xcusun jan, sehe cavinenguise cha cojo cha ladu rë Jesús cuitjin: ―‍¿Mé má jinë hvi maestru nuju cojo cha xi faha tujúnsa cojo ngujo sa cha xi hacuaha cha tsehen cha? ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Peru cavihndë Jesús cjua xi cachja cha, hane cafayangui me cuitjin: ―‍Xuta xi hacuiin hmu rë me ne, mamijí rë me xi cjuahacuenda rë me doctor ta suvá ni xuta xi hmu rë me ne, me vëhë meje rë xi cjuahacuenda rë me doctor. ");
INSERT INTO maqNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","¿Há vijnii rcun mé vijne cjua rë Nina vihi?: “Hitsë sa ndama ná xi mayuma nuju xingun xi cuma rë xi nicuhun chu sacuaha cjuatjo xi tuhun ná.” Hacuanitjin ná ngahan ta ngahan ne, hacuiin canduvá xi squindáyavaha rë xuta xi tsajin xi cun rë me xcun Nina, ta xa xi canduvá ne, xi squindáyavaha rë xuta tsehen, hane cuichjá cojo me xi tsindeya me cjuatacun rë me. ―‍Cuitjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ngajan xi xuta ladu rë Juan ne, cafehe me cavinenguise me Jesús cuitjin: ―‍Ngayijin ni, vinechin xun rë Nina hacuaha cha partidu fariseo hacuaha viyuju cha xun rë Nina. ¿Mé tsëhë xi xuta ladu nuju ne, sahmii me cuatjin ne? ");
INSERT INTO maqNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ngajan xi Jesús ne, cuitjin cachja me cojo cha: ―‍Cumaji xi xuta rë cha xi tivixan ne, sahmi me xun rë Nina jinguyëjë rë xi cha xi tivixan ne, tacun cha cojo rë me. Peru cuechú nixtin xi cha xi tivixan jan ne, chjaháxin rë cha tsëhë xuta rë cha, hane hya cuma sahmi me xun rë Nina. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hacuaha cachja sa me ta: ―‍Tsajin yo xi cueyacoo ngu tsjian changa cojo ngu rquí tsjian xi cjëë cjueyu ta sá xi cuatjin sahmi me, xi cjueyu tsjian xatsë jan ne, cuicheya rë tsjian changá jan hane sahmi jyë sa rë hiscan xi ntsun. ");
INSERT INTO maqNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Cuanitjin ne, tsajin yo xi vincha xan xatsë cahntsua chuxin changá ta, sá xi cuatjin sahmi me ne, tsitsingá rë chuxin jan. Hane cjuë cuixu xan jan, hacuaha cuetsun chuxin jan. Xi meje rë ne, xan xatsë ne, xincha cahntsua chuxin xatsë ta cuatjin ne, catsijo ni ne tsajin mé cuma rë. ");
INSERT INTO maqNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Hora xi tivisiajmi me cuatjin ne, canduva ngu me xi xutaxa rë yungun. Hane quiji caticjaxcun me xcun Jesús cachja me cuitjin: ―‍Ndicumaha ni cahme na lihndi naha. Peru sa xi cuanguen ne, cuisanu ntsun na ne, cuya nga na cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hya xi camá ne, cavetju Jesús quiji me cojo nahmi rë na lihndi jan hacuaha quiji xuta ladu rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hane ngajñi cjui me ne, ngu na xi tjin rë tejó nu xi yaha rë na chíhin xahmajni quiji tiña na táha ngaxtun Jesús ne, quiji cavetahatsja na ntsacu tsjian rë me ta, ");
INSERT INTO maqNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","catsingatahacacun na cuitjin: “Sá xi cuetahantsa ndastu tsjian rë me ne, cumandaja ngahan.” ");
INSERT INTO maqNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Peru cavuya Jesús taha ngaxtun me ne, sehe cavutsejen me na hane cachja me cojo na cuitjin: ―‍Tuhun cjuasua xahasen nuju, tsan, camandaja ngayun ta camacjain nuju. Hane ngutjen ni ne, camandaja na. ");
INSERT INTO maqNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hya xi camá ne, cafehe Jesús ndava xutaxa rë jan. Ngajan cavëë me xi ha siu cha chjinetyjo cojo xutacjín xi jihnda me ngatsë rë cjuandusin. ");
INSERT INTO maqNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sehe cachja me cojo xuta cuitjin: ―‍Tjangunxun. Na lihndi vë ne, hacuiin cahme na ta jiñafë ni na. ―‍Cuatjin cachja me. Ngajan xi xuta jan ne, tu cavejnucëë me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Peru xi casahmi me xi cavetju xin xuta jan, sehe cavisehen Jesús hiscan jiña nima lihndi jan ne, cafaha me tsja na hane catsisatjenhnga me na. ");
INSERT INTO maqNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hya xi camá ne, cavitsojo cjua rë xcusun jan jingujyë nangui vë. ");
INSERT INTO maqNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Xi cavetju Jesús quiji me tsëhë ngajan ne, canduva tjengui rë me jo cha rcá hane cajindaya cha cachja cha cuitjin: ―‍¡Ngayun Jesús, tjë rë David! Catamayuma nuju ngayin. ―‍Cuitjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Xi cavisehen Jesús ndihya ne, sehe cavechutaha cha rcá me, hane cavinenguise Jesús cha cjua vi: ―‍Xi má nuju, ¿há cuma sahme xcusun xi chjayun? Cafayangui cha cuitjin: ―‍Macjain niji, Tatá, cuma nihñu. ");
INSERT INTO maqNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hya xi camá ne, cavetahatsja me tuxcun cha hane cachja me cojo cha cuitjin: ―‍Cuatjin catama cojo nuju xcusun sacuaha xi macjain nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hane ha hora vëhë ni ne, catuxaha tuxcun cha hane camatsejen rë cha. Ngajan xi Jesús ne, cavitexa me cha cuitjin: ―‍Tsajin yo cuinújun cojo tsëhë xcusun vihi. ");
INSERT INTO maqNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Peru cavatju xi quiji cha jan ne, cavitsojo cjua tsëhë me jingujyë nandya jan. ");
INSERT INTO maqNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hora xi ha quiji jo cha jan ne, cafehe xuta xi canduva me cojo ngu cha xi hincha rë xitsehen; hane xitsehen jan ne, casahmi lihmi rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Hane hya xi cavetju xitsehen tsëhë cha lihmi jan, cavetsihin cachja cha. Hane xutacjín xi cavutsejen me ne, jemu quijircun rë me ne cachja me cuitjin: ―‍Nguehe nangui naja Israel ne, tsajin ngu nixtin xi tsejen cjuarcun sacuaha tijimá quihndë. ");
INSERT INTO maqNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Peru cha partidu fariseo ne, cachja cha cuitjin: ―‍Xitsehen xi matitjun ne, vëhë casua rë cha xa xi vaxëxin cha xitsehen. ");
INSERT INTO maqNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús ne, catsujyihiya me jemu cjín nandya cojo ranchun ne, ngajan cavicuya me xuta cahntsua yungun rë me. Casua me camachaya rë me cjuandajyihi xi chja tsëhë gubiernu xi sahmi Nina. Hacuaha catsirqui me xuta tsëhë yëjë ni chíhin cojo yëjë ni xcusun xi cjuahmu. ");
INSERT INTO maqNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Peru xi cavëë Jesús xutacjín ne, camayuma rë me xuta jan ta tsëhë xi jemu va tjin rë xahasen rë me, jemu camachohocacun me sacuaha chu tsánga xi tsajin yo xi cjuahacuenda rë chu. ");
INSERT INTO maqNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Vëhë xi cuitjin cachja me cojo cha ladu rë me: ―‍Xutacjín vi ne siu me sacuaha siu niji ngajan nguijña xi jemu ndaja camá peru tsajin cha mosu xi cuanga rë. ");
INSERT INTO maqNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Vëhë xi meje rë xi chjahyun rë Nai naja xi tsingatju me xuta xi cuanga me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Cavechú ngu nixtin xi casahmitangun Jesús xuta ladu rë me xi tejó jan ne, sehe casua rë me ngahñu hacuaha casua rë me xá xi me xi cuacún vë, cuitexa me yëjë xitsehen hane cuaxëxin me xitsehen tsëhë xuta; hacuaha sahmi me xi xuta xi hmu rë me ne cuma ndaja me tsëhë tu me ni chíhin xi yaha rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cha xi tejó jan ne, cuitjin hmí rë cha: titjun ne, Simón, me xi hacuaha yaha ñihi rë Pedru, cojo Andrés hntsë Simón, Jacobo quihndi rë Zebedeo cojo Juan hntsë Jacobo, ");
INSERT INTO maqNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe cojo Bartolomé, Tomás cojo Mateo, cha xi faha tujúnsa, Jacobo quihndi rë Alfeo cojo Tadeo, ");
INSERT INTO maqNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón xi tsëhë partidu cananayu cojo Judas Iscariote, me xi sahmi entregadu rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tejó xuta jan ne, catsingatju Jesús me ne, cavitexa me cuitjin: ―‍Tanguun ngajan ndiya xi fi xuta xi hvíin me cjua rë Nina, hacuaha cuisuun nandya rë distritu Samaria ta; ");
INSERT INTO maqNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","tángun hiscan siu xuta nandya rë Israel, xuta jan ne tangun me cojo ngu chu tsánga rë Nina xi cachaja chu. ");
INSERT INTO maqNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tuhun cumachaya rë xuta cjuandajyihi rë Nina xi jima tiña gubiernu xi sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nihñu xi cuma ndaja xuta hmu rë, nicuyun cjuahñu rë nima, nihñu xi cuma ndaja xuta xi yaha chuxin rë me chihin vitaha, hacuaha naxunxun xitsehen. Ngahñu xi meje nuju xi cuatjin nihñu ne, tu cuatjo ni sacu nuju, vëhë xi hacuaha tu cuatjo ni tuhun ngahñu jan. ");
INSERT INTO maqNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Xicachjuun oro o sá quicha tyava o tu mé ni tujún xi cuinchunndujun cahntsua tsá tujún nuju xi tsëhë gastu nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Xicachjuun changa, xicachjuun ngu xúta tsjian, hacuaha xicachjuun ngu xúta chuxinxtë o sá ngu bastón ta, xuta xi sahmi me xá ne, tsëhë xá jan sacu rë me gastu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Cuanitjin ne, tu mé ni nandya o sá tu mé ni ranchun xi cuisuhun ne, ngajan cuinchunsun ngu xuta xi ndaja xahasen rë me, ngajan ndava me ne, nechuncahndun hisca xi cuetjunxun tsëhë nangui jan. ");
INSERT INTO maqNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hane hya xi cuisuhun ngu ndihya ne, tinújun ngu nina cuitjin: “Nina sua nuju me cjuandaja cjuajeya.” ");
INSERT INTO maqNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hane sá xi nai rë ndihya jan ndaja vëë me yun ne, catisatë rë ndava me jan cjuajeya; peru sá xi hacuiin ndaja vëë me yun ne, satiin rë me cjuajeya jan. ");
INSERT INTO maqNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hane hiscan xi tjin xuta xi cjuahatsjaain nuju me, xi chjuhun ndiya xi cuetjunxun tsëhë nandya vëhë ne, titsunu chojo rë ntsacu. ");
INSERT INTO maqNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cuichjá cojo nuju ngu cjuaquixi ta hya xi cuechú nixtin xi tsichuva Nina xuta tsëhë jyë́ rë me ne, hitsë sa jyë castigu cuatju xuta tsëhë nandya xi cafahatsjaain nuju jan, xi cumá rë xuta tsëhë nandya Sodoma cojo xuta nandya Gomorra. ");
INSERT INTO maqNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Ngahan titsingátju nuju ngayun xuta jeya xi cuangun ngajñi rë xuta hnga cacun sacuaha cjue ngu chu tsánga ngajñi rë chu cjan rë. Vëhë xi meje rë xi ndaja quicuntacun sacuaha quicuncacun chu yë, peru hacuiin tsavi yun sacuaha tsajin tsavi chu paloma. ");
INSERT INTO maqNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Peru nechun cuidadu ta, cjuaha nuju xuta cjuecojo nuju me xcun xutaxa rë ndihyavasen, hacuaha cuaja nuju me ngajan yungun rë me, ");
INSERT INTO maqNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","hisca cjuecojo nuju me xcun gobernador, hacuaha cjuecojo nuju me xcun me xi vitexa me jingujyë ni nandya. Cuatjin cuangun ngatsë rë xi ladu naha má ngayun. Ngatsë rë vëhë sacu nuju cahndë́ xi ninguixun cjua xi cavicuyá nuju xcun xuta jan cojo xuta xi hvíin me cjua rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hya xi cuatjin cjuecojo nuju me ne, hacuiin cuityjanguntacun tsëhë hacutjin xi ninguixun ta, tsëhë xi hora vëhë ne, Nina sua me ngayun cjua xi nicuyun. ");
INSERT INTO maqNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ta tsëhë xi hacuiin cjua nuju xi cuinújun ta tsëhë Hasen rë Nina cuinduva cjua xi cuinújun. ");
INSERT INTO maqNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Hacuaha xuta ladu naha ne, hntsë me, cuinchajyë rë me, xutacha rë me, cuinchajyë rë me, quihndi rë me cuinchajyë rë me cojo sa xi xutaxa rë ne, cjuaha rë me me ne, tsiquehen rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yëjë ni xuta ne, choho scuëë nuju me, tsëhë xi ladu naha ngayun. Peru jarë ngayun xi scaa nuju cojo cjuacjintacun vëhë hisca xi cueyun ne, cuechun xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hya xi tsujyihiyatjengui nuju me ngu nandya ne, tangun ngu nandya tiñataha ta, cuichjá quixë cojo nuju ta xi chaja sa cuatjun jingujyë ni nandya tsëhë nangui rë Israel ne, cúya ngahan Quihndi rë Xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ngu cha xi sehe tivutaya matsejen ne, hacuiin hitsë sa matitjun cha xi cumá rë maestru rë cha, cuanitjin ne, ngu cha hndixahan ne, chuva venguichji rë cha xi cumá rë nai rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Catamangucacun cha tsëhë xi cuechú nixtin xi tangun cuenguichji rë cha cojo maestru rë cha o tangun cuenguichji rë hndixahan cojo nai rë. Ha chuva vëhë ni cuatjun ta sá xi choho cuichja xuta nai rë ndihya ne, ngu xitsehen me, hitsë sa choho cuichja me tsëhë xuta rë nai rë ndihya jan. ");
INSERT INTO maqNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Xicarcuun xuta condra nuju. Yëjë ni xcusun xi casetsangui ne, cuechú nixtin xi chjaháxin rë xi titsangui rë. Vëhë xi yëjë ni xcusun xi hma ne, handasa sahmangui ne, peru cuechú nixtin xi cuetjucaa tsejen. ");
INSERT INTO maqNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yëjë ni cjua xi cuichjá cojo nuju hiscan jñu ne, cuinújunsun hiscan hasen. Yëjë ni cjua xi cuichjáhma ne, cuechú nixtin xi cuinuhya rë jinguyëjë ni nandya. ");
INSERT INTO maqNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Xicarcuun xuta xi cuma tsiquehen yojo nuju, peru ngaxtun vëhë ne, tsajin me dañu ma sahmi me cojo hasen nuju. Hitsë sa ndaja ne, rcun Nina, me xi tjin rë chuva rë xi tsiquehen me yojo nuju hane hacuaha tsingatjenya nuju me hiscan xi má hasen nuju castigu. ");
INSERT INTO maqNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Chutsujun ta jo chu nisë langa ne, ngu ni tujún chji rë chu, peru handasa cuatjin ne, hiscan ngu chu cumaji cueya chu sá xi suaain Nina cahndë́. ");
INSERT INTO maqNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hane ngayun ne, hisca jimangu tsjarcun ne xqui tjin rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Vëhë xi xicarcuun ta, tsëhë xi jimangu ngayun ne, hitsë sa jercu vengui chji nuju xi cumá rë chu nisë vë, handasa jemu cjín chu. ");
INSERT INTO maqNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Yëjë xuta xi tsinguixi me xcun yahnga xuta xi xuta ladu naha má me ne, hacuaha ngahan tsinguixë xcun Nahmi naha xi tacun ngahnga xi xuta ladu naha má me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Peru yëjë xuta xi tsinguixiin me xcun yahnga xuta xi hacuiin xuta ladu naha má me ne, hacuaha hacuanitjin ni tsinguixë ngahan xcun Nahmi naha xi tacun ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Xi má nuju ngayun ne, ¿há cjuajeya canduvácojo xi cumá rë xuta ngasunhndë? Hacuiin cuatjin. Ngahan ne, si canduvá cojo. ");
INSERT INTO maqNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Canduvá tsinguetsuntaha xicjin xuta. Cha quihndi ne, sahmi condra cha nahmi rë cha, hane na quihndi ne, sahmi condra na naa rë na, hane jahnda ne, sahmi condra na nahya rë na. ");
INSERT INTO maqNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Cuatjin xuta condra rë me ne, cuma ni xuta rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Sá xi ngu me ne hitsë sa tsihmu cacun me nahmi rë o sá xi naa rë me xi cumá ná ngahan ne, vechiin chuva rë xi tsahan cuma me. Hacuaha sá xi ngu me ne hitsë sa tsihmu cacun me quihndi rë me sá xihin sá chjuun xi cuma rë xi tsihmu cacun me ngahan ne, vechiin chuva rë xi tsahan cumá me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ha cuanitjin ne, sá xi ngu me ne mijí cjuejñahñu xahasen rë me xi cjuecojo me ndiya naha handasa cueya me xcun cru ne, cumaji cuechu me chuva rë xi tsahan cumá me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Xuta xi nguehe ni ngasunhndë meje cjuenduju me cojo cjuahñu rë me ne, titsichajá me cjuahñu xatsë xi sua Nina me. Peru xuta xi titsichajá me cjuahñu rë me nguehe ngasunhndë ne ngatsë naha ne, hatuxa sacú rë me cjuahñu xatsë xi sua Nina me. ");
INSERT INTO maqNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Xuta xi cjuahatsja me yun, tangun sacuaha xi cjuahatsja ná me ngahan suva, hane xuta xi cjuahatsja ná me ne, tangun sacuaha xi cjuahatsja me Nahmi naha, me xi catsingatju ná. ");
INSERT INTO maqNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Xuta xi cjuahatsja me ngu me xi chja me cjua rë Nina ne ngatsë xi chja me jan cjua rë Nina ne, tangun chji sacu rë me cojo me jan. Hacuaha xuta xi cjuahatsja me ngu xihin xi tyjahi cjuatacun rë me xcun Nina ngatsë rë ndaja xihin jan ne, tangun chji sacu rë me cojo xihin jan. ");
INSERT INTO maqNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cuanitjin ne, xuta xi sua me ndastu ngu vasu nandá cjuahatsja tu yo ni xi xuta ladu naha ne handasa jemu yuma jyihi me ne, sacu chji rë me ngatsë rë xi cuatjin sahmi me cojo xuta xi tjengui ná. ");
INSERT INTO maqNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hya xi camá ne, xi cajnetaha cjua xi cavitexa Jesús cha xi tejó má jan, sehe cavetjuxin me quiji me nandya xi siutahndee, ngajan cavicuya me xuta cachja me cojo tsëhë cjuandajyihi rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nixtin hya ne, ha jiya Juan Vitenda rë Xuta ndavaya, hane ngajan camachaya rë me tsëhë xcusun xi sahmi Jesús. Vëhë xi catsingatju me ngujo cha ladu rë me xi quiji cha ");
INSERT INTO maqNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","cavinenguise cha Jesús cuitjin: ―‍¿Há ngayun xi tsingatju nuju Nina, o há tsajin ne, há cuinechinyin xi cuinduva nga ngu? ―‍Cuatjin cavinenguise xuta xi catsingatju Juan jan. ");
INSERT INTO maqNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hya xi camá ne, catsicuya Jesús cjua cojo cha xi cuacun jan hane cuitjin cachja me: ―‍Tjangun ne, sehe tinújun cojo Juan yëjë cjua xi canuhyun cojo yëjë xcusun xi cahyun. ");
INSERT INTO maqNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tinújun ta xuta rcá ne, camá camatsejen rë me; xuta rengun ne, camá quijindaja me; xuta xi yaha rë chíhin vitaha xi setaha yojo naja ne, camandaja me; nima ne, cavuya nga cjuahñu; xuta yuma ne, casacu camachaya rë me cjuandajyihi rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hacuaha jemu ndaja tsëhë tu yo ni xuta xi hacuiin tsismicacun me xi mangu cacun me cojo ná. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hane hya xi cavetju quiji xuta ladu rë Juan jan ne, sehe cavetsihin cachja Jesús cojo xutacjín jan cuitjin tsëhë Juan: ―‍Hya xi cavetjun catsangun ngajan ngu xín tsëhë nandya catsangun tjengun Juan matsejen ne, ¿há caningatuhuntacún xi cuechuntuhun ngu xihin xi hacuiin ngu ni cjuatacun rë me, sacuatjin rë ngu ndeje xi fi nguehe fi ngajan rcu sacuatjin cjui tjo? ");
INSERT INTO maqNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O há tsajin ne, ¿há caningatuhuntacún xi cuechuntuhun ngu xihin xi yaja ngu tsjian xi jemu tu ndajyihi camahani? Hacuiin cuatjin. Ha hyaan matsejen ta xuta xi jercu tu ndacun camahani tsjian vaja me ne, sacuiin naja ngajan xin jan, ta sacu naja ndava ngu xuta nchina. ");
INSERT INTO maqNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Peru ngayun matsejen ne, catsangun cachutsujun ngu profeta. Hacuaha cjuaquixi xi vëhë cachutsujun. Peru profeta Juan vë matsejen ne, hitsë sa vengui chji rë me xi cumá rë yëjë sa profeta xi yahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hacuaha me vëhë xi cachja Nina tsëhë me xcun xujun rë me cuitjin: Ngahan ne, tsingátju titjun ngu cha xi scuxaha cjuatacun rë xuta tsëhë xi cjuehe ngaye. ");
INSERT INTO maqNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cuichjá cojo nuju matsejen ta ngajñi rë yëjë xuta xi catsin me tsëhë naa rë me matsejen ne, tsajin ngu xi hitsë sa vengui chji rë xi cumá rë Juan. Peru hya xi cuetsihin Nina sahmi me gubiernu nguehe ngasunhndë matsejen ne, xuta xi chuva cuengui chji rë me nixtin hya matsejen ne, hitsë sa cuengui chji rë me nixtin hya, xi cuma rë xi vengui chji rë Juan quihndë. ");
INSERT INTO maqNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Hisca nixtin xi caxtenda Juan hisca nixtin quihndë ne, má cjuasuë xi satë rë gubiernu xi sahmi Nina; xuta ne, meje cuisehen me ngajan, handasa cojo cjuachan. ");
INSERT INTO maqNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Xi chaja sa nduva Juan ne, yëjë ni xujun xi catsihindu profeta cojo xujun rë ley ne, suva casua camachaya rë xuta tsëhë gubiernu xi sahmi Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sá xi meje nuhyun cjuaquixi ne: Juan ne, hacui Elías, xi sehe nduva xu. ");
INSERT INTO maqNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yo ngayun xi tjin nuju cjuasua xi cuinuhyun cjua vihi matsejen ne, ndaja tetuhunrcun. ");
INSERT INTO maqNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Ngayun xuta tsëhë nixtin vihi matsejen ne, ¿mé xi tangun ngayun cojo? Tangun ngayun cojo langa xi siu ngajan ndetsin, xi jindaya xicjin ");
INSERT INTO maqNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","cojo cjua vihi: “Canijani tsujun ne, mijí xtun; casin va ne, mijí chjihndun.” Cuatjin jindaya langa. ");
INSERT INTO maqNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Cuatjin chjá cojo nuju matsejen ta, Juan xi vitenda nuju ne jinii me niñu hacuaha hviin me xan, hane nújun ta jiya xitsehen xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hane ngahan xi Quihndi rë Xuta Jain matsejen ne, jinë hacuaha hvë, hane nújun ta ngu cha cahntsuaniñu ngahan, ngu cha cahntsuaxan ngahan, hacuaha ngu cha amigu rë cha xi faha tujúnsa cojo jingu sa xuta tsehen ngahan. Tsejen xi ndaja ngu cjuatacun xi casacu rë ngatsë rë xi ndaja tivetjucaa tsujun xi tinihñuchuhun. ");
INSERT INTO maqNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hya xi cama ne, cavetsihin Jesús chjataha me xuta nandya jani hitsë sa jemu casahmi me cjuarcun camá, ta catsindeyaain me cjuatacun rë me. Cuitjin cachja me: ");
INSERT INTO maqNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―‍¡Jemu chojyihi tsujun xuta nandya Corazín! ¡Hacuaha jemu chojyihi tsujun xuta nandya Betsaida! Jemu chojyihi tsujun ta, tsëhë xi sá xi xutaxín tsëhë Tiro cojo xutaxín tsëhë Sidón cavëë me cjuarcun xi cahyun ne, ha catsindeya me cjuatacun rë me, hacuaha ha cavajá me tsjian xi sacuaha tsánaxá hacuaha caviyuju me ngajñi ndesu, sacuaha xcusun naja hya xi choho má naja. ");
INSERT INTO maqNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Vëhë xi hya xi tsichuva Nina yëjë xuta tsëhë jyë́ rë me ne, xuta nandya Tiro cojo xuta nandya Sidón ne, hitsë sa chuva castigu cuatju me cumá xi cumá nuju ngayun xuta nandya Corazín cojo ngayun xuta nandya Betsaida. ");
INSERT INTO maqNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hane ngayun xuta nandya Capernaum ne, ¿há cuangun hisca ngahnga hiscan tacun Nina? ¡Hacuiin! Hatuxa cuangun nduchin, cahndë́ hiscan fi hasen rë nima ta, tsëhë xi sá xi xuta tsehen tsëhë Sodoma cavëë me cjuarcun xi cahyun ne, ha catsindeya me cjuatacun rë me, hane tacun cuaha nandya jan hisca quihndë. ");
INSERT INTO maqNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Vëhë xi hya xi tsichuva Nina xuta ne, hitsë sa chuva castigu cuatju xuta Sodoma xi cumá nuju ngayun xuta nandya Capernaum. ");
INSERT INTO maqNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nixtin hya ne, cachja Jesús cojo Nina cuitjin: ―‍Ngayun nahmi naha ne, sahme jyë sahme hnga nuju, ngayun xi Nai rë ngahnga cojo nangui, ngayun, tsëhë xi ngayun caveyúnhmu cjuatacun vëhë xi cuma rë xuta xi jemu vechú cjuatacun rë, hane catuhun camachaya rë xuta xi jñu tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ngayun nahmi naha, cuatjin canihñu ta, tsëhë xi cuatjin xi cachuya nuju. ―‍Cuatjin cachja Jesús cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cachja me cojo xuta: ―‍Yëjë ngarca matsejen ne, Nina Nahmi naha casua ná me. Tsajin hisca ngu xi vëë yo xi Quihndi rë Nina matsejen ta suvá ni Nina Nahmi naha xi vëë me. Hacuaha tsajin yo xi vëë Nahmi naha matsejen ne ta, suva ni ngahan xi Quihndi rë me ngahan xi hvë, cojo tu yo ni xi ngahan meje suá cumachaya rë. ");
INSERT INTO maqNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ngayun xi fenda rë xahasen nuju, ngayun xi hai tjin tacun tsëhë jyë́ nuju ne, nduvun tjengun ná, hane cjuaháxen vëhë xi sahmi hai nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ningatuhun xi chjuhun yugu naha sacuaha má cojo ndyaja hya xi cjuaha chu xa sahmi chu, hacuaha chjayunngun tsahan. Ta ngahan ne, tjin ná cjuandaja cjuajeya, hane sacu hñu rë xahasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta yugu xi suá nuju vihi ne, hacuiin hai, tanguaain cojo tsëhë chu ndyaja, hane xa xi suá nuju ne, hacuaha hacuiin hai. ");
INSERT INTO maqNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nixtin hya ne, cuatjin camá ngu nixtin xi chjahájenda rë. Hora xi tivatju Jesús cojo xuta ladu rë me hiscan tjin tjë trigu ne, cama vojo rë xuta ladu rë me, cavetsihin cavotohosun xuta jan tsë tsë trigu jan ne, catsufëtsja me cajine me. ");
INSERT INTO maqNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hane cha tsëhë partidu fariseo xi cavëë cha xi cuatjin casahmi me, cachja cha cojo Jesús cuitjin: ―‍Chutsujun ni, xuta ladu nuju ne, tisahmi me xa quihndë nixtin xi chjahájenda rë, handasa chja ley naja xi cumaji xi cuatjin nihña. ");
INSERT INTO maqNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Hane cafayangui Jesús cuitjin: ―‍Ngayun, ha cachutayun xcusun xi casahmi xutachanga naja David hatsëë nixtin hya xi jercu camá vojo rë me cojo xuta xi siu cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Cavisehen me ndava Nina, hane cafaha me pan xi viyuju xcun Nina xi tsajin cahndë́ xi tu yo ni sinë ta suvá ni nahmi xi cuma sinë me. Peru David ne, cajinë me hacuaha casua me cajinë xuta xi siu cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Cuanitjin ne, ha cachutayun xi chja cjua rë ley naja xi nahmi xi sahmi xa ndava Nina ne, ngajan tjin xa xi satë rë me nixtin xi chjahájenda rë peru tsajin jyë́ xi cuma rë me handasa tisahmi me xa nixtin hya. ");
INSERT INTO maqNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Cuichjá quixë cojo nuju ta nguehe tacun ngu xi hitsë sa meje rë xi chjahanrcun rë xi cumá rë yungun xi matitjun. ");
INSERT INTO maqNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Cjëë cuijnercun cjua xi chja: “Hitsë sa ndama ná xi cumayuma nuju xingun tsëhë xi cumá rë xi nicuhun chu sacuaha cjuatjo xi tuhun ná.” ");
INSERT INTO maqNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Hacuaha cachja sa Jesús cuitjin: Ngahan xi Quihndi rë Xuta Jain ngahan ne, ngahan xi vitéxa mé xi cuma nixtin xi chjahájenda rë. ");
INSERT INTO maqNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Hya xi camá ne, xi quiji sa Jesús ne, cavisehen me yungun ngajan. ");
INSERT INTO maqNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hane tacun ngu cha cahntsua yungun jan xi quixíhñu tsja quixi cha. Hane cha xi vicuya cjuachacun cojo cha fariseo ne, cavinenguise cha Jesús cuitjin: ―‍¿Mé xi tsingatihi ley xi nihña nixtin xi chjahájenda rë? ¿Há sua cahndë́ xi nirquen rë xuta hmu rë? ―‍Cuatjin cafinenguise cha me xi sehe cuma cuinchajyë cha me. ");
INSERT INTO maqNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hane cuitjin cafayangui Jesús tsëhë cha: ―‍¿Há cuma xi ngu ngayun handasa hya xi nixtin xi chjahájenda rë ne, cuanguun naxun chu tsánga nuju sá xi cjuinenguiya chu ngu ngojo xi jemu nungun? ");
INSERT INTO maqNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sá cuatjin vengui chji rë ngu chu tsánga ne, hitsë sa cjín vengui chji rë ngu xihin. Vëhë xi tsingatihi ley xi nixtin xi chjahájenda rë ne nihña cjuandaja. ");
INSERT INTO maqNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sehe cachja Jesús cojo cha hmu rë cuitjin: ―‍Nixingun ntsun. ―‍Cuatjin cachja me. Hane cuatjin casahmi cha. Hane tsja cha xi quixi ne, ha camandaja sacuatjin jyihi tsja cha xingu. ");
INSERT INTO maqNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hya xi camá ne, cha partidu fariseo jan ne, cavetju cha quiji cha, cachja cha ngajñi rë cha cojo xicjin cha xi meje rë xi sacuya ra xcusun hacutjin cuma tsiquehen cha Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Peru Jesús ne, machaya rë me cjuatacun jan, hane cavetju me quiji me tsëhë ngajan. Hacuaha cjín xuta quiji tjengui cojo rë me, hane catsindaja me yëjë ni xuta tsëhë chíhin xi má rë me, ");
INSERT INTO maqNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","sehe cachja me cojo me xi cuichjaain të me yo me jan. ");
INSERT INTO maqNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Cuatjin casahmi Jesús xi cuetjucaa cjua xi catsihindu profeta Isaías xi chja cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Cha vihi ne, cha mosu naha, cha xi cavitéxa ngahan, cha xi tsihmúcacun, cha xi ndama ná tsëhë. Suá cha Hasen naha, cuichja cha cojo xutaxín tsëhë hacutjin quixi Nina hya xi tsichuva me xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Cha vihi ne, hacuiin cjin cuisiajmi cha cojo xuta; hacuiin jindaya të cha xi chja cha. Cuichjaain hñu cha cojo sa xi jemu catjaha cuenda rë cha xuta xi tsujyihiya me ndiya të. ");
INSERT INTO maqNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Xcotaain cha cjuatacun rë hisca ngu xuta yuma xi tangun me cojo ngu ndeje xi caxtane, hacuaha sahmi chuvaain cha cjuatacun rë xuta yuma xi tangun me cojo ngu candil xi ha ndiya coho. Yëjë xcusun vihi ne, sahmii cha hisca xi cumatsejen cjuaquixi rë gubiernu rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hane xuta ngasunhndë ne, cuetahacacun me cha. ");
INSERT INTO maqNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Cavechú ngu nixtin xi cafehe tjengui xuta Jesús hane yaha me ngu cha xi jiya xitsehen xahasen rë cha. Rcá cha jan hacuaha lihmi cha. Hya xi camá ne, Jesús ne casahmi me xi camandaja cha jan hisca cama cachja cha hisca cavutsejen ndaja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hane xutacjín ne, jemu quijircun rë me cachja me cuitjin: ―‍¿Há cumacacun xi cha vihi hacui quihndi tjë rë David xi tsingatju Nina? ");
INSERT INTO maqNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Peru cha partidu fariseo xi camachaya rë cha cjua jan ne, cachja cha cuitjin: ―‍Hacuiin suvá cha vaxëxin cha xitsehen ta Beelzebú, xitsehen xi matitjun ne, vëhë casuaxá rë cha xi vaxëxin cha xitsehen. ");
INSERT INTO maqNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Peru Jesús ne, tsëhë xi ha vëë me mé xi tsingataha cacun xuta xi cuacún jan ne, cuitjin cachja me cojo cha: ―‍Hya xi xuta tsëhë ngu nandya ticjan me ngajñi rë me cojo xicjin me, cjuë ngahñu cjua rë, hane cjuincanii rë me. Hacuaha sá xi xuta tsëhë ngu ndihya ne, scaan me ngajñi rë me ne, ngajan chajá ngahñu cjua rë ndihya jan. ");
INSERT INTO maqNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ha cuanitjin rë Satanás ta, sá xi Satanás ne vaxëxin xitsehen xi yahnga ne, cavatëcja ngahñu cjua rë, hane cumaji cuitexa xicjin. ");
INSERT INTO maqNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Vëhë xi sá xi Beelzebú casua ná xa xi vaxë́xen xitsehen ne, hacuaha ha Beelzebú vëhë casua rë ngu ngu xuta ladu nuju xa xi hacuaha vaxëxin me xitsehen. Vëhë xi me vëhë ni cuma cuichja me xi cuaaintjin cjua xi nújun xi Beelzebú casua ná xa. ");
INSERT INTO maqNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Peru sá xi hacuiin Beelzebú casua ná xa ta Nina casua me ne, ngajan matsejen xi gubiernu xi sahmi Nina ne, ha tivetsihin. ");
INSERT INTO maqNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Hisca ngu cha chëjë cumaji tu cuisehen ni cha ndava ngu xuta xi hñu cjua rë sá xi tacun me. Titjun tsihñu cha xuta xi ndava ta cuatjin xi cuma tsichëjë cha tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Xuta xi fiin me favor naha ne, condra naha má me. Hane xuta xi visecuaain ná me xi nihñi tangun cjuatacun rë xuta cojo Nina ne, tsinguetsun me cjuatacun rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Hacuaha cuichjá cojo nuju cjuaquixi ta tu mé ni jyë́ xi sahmi xuta hacuaha tu mé ni cjua xi choho cuichja me tsëhë xuta ne, sacú rë me cjuaninchataha sa xi cuijacun me jyë́ jan. Peru tu yo ni xi choho cuichja tsëhë Hasen rë Nina ne, tsajin cjuaninchataha xi cuma rë. ");
INSERT INTO maqNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Cuanitjin ne, tu mé ni cjua xi choho cuichja xuta tsëhë Quihndi rë Xuta Jain ne, cuma sacú rë me cjuaninchataha. Peru tu yo ni xi choho cuichja tsëhë Hasen rë Nina ne, tsajin cjuaninchataha nguehe nixtin vi, hacuaha tsajin cjuaninchataha nixtin xi nduva. ");
INSERT INTO maqNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’¿Jarë xi meje nuju?, ¿há xi ndaja ya hacuaha ndaja tu rë? o há tsajin ne, ¿há xi ndajin ya hane ndajin tu rë? Jima ngu ya ne, cuma tsejen sá xi ndaja o sá xi ndajin ngatsë rë tu xi sua. ");
INSERT INTO maqNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ngayun quihndi rë chu tsehen, maji nújun cjua xi ndaja. Maji ta tsëhë xi cjua xi quitsë rë xahasen nuju ne, vëhë cjua xi vetju nújun. ");
INSERT INTO maqNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vëhë xi xuta ndaja ne, tsëhë cjuandaja xi tetjo rë me cahntsua xahasen rë me cojo cahntsua cjuatacun rë me ne, tsëhë ngajan vetju cjuandaja. Cuanitjin ne xuta tsehen ne, tsëhë cjuatsehen xi tetjo rë me ne, ngajan vetju cjuatsehen. ");
INSERT INTO maqNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Cuichjá cojo nuju ta tu mé ni cjua xi cuinújun, handasa tu visiajmu ni ne, tuhuncuenda rë Nina cjua jan nixtin xi tsichuva me yaan. ");
INSERT INTO maqNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Cuatjin ta cojo cjua xi canújun ne, cjua jan cuma testigu xi cuetjunxun tsëhë castigu, o sá tsajin ne, cjua xi canújun vëhë cuma testigu tsëhë castigu xi cueyun. ");
INSERT INTO maqNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ngajan xi ngujo cha xi vicuya cjuachacun cojo ngujo cha partidu fariseo catsicuya cha tsëhë me, cuitjin cachja cha: ―‍Maestro, ningacun niji ngu cjuarcun xi sua seña yo ngayun. ");
INSERT INTO maqNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngajan cafayangui Jesús cuitjin: ―‍Ngayun xuta tjë rë Israel xi nechun nixtin vihi matsejen ne, tsehen cjuatacun nuju, hacuaha majotacun xcun Nina. Vëhë xi chjahyun ná ngu seña xi sua Nina. Peru seña vëhë ne, sacuiin nuju ta ngu ni seña xi sacú nuju matsejen ne, vëhë seña xi casua profeta Jonás hatsëë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sacuatjin rë profeta Jonás ne, jyan nixtin cojo jyan nixten caseya me cahntsua chu ti jyë, hane ha cuanitjin ni ne cumá rë Quihndi rë Xuta Jain, ta jyan nixtin cojo jyan nixten seya me ngahma nangui. ");
INSERT INTO maqNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Hya xi cuechú nixtin xi tsichuva Nina jyë́ nuju, ngayun xi nechun nixtin vihi ne, yëjë ni xuta nandya Nínive matsejen ne, cjue cuinchajyë nuju me; ta me vëhë ne catsindeya me cjuatacun rë me hya xi casua profeta Jonás camachaya rë me cjua rë Nina. Peru nguehe ne ha tejña ngahan sacuaha ngu seña xi hitsë sa vengui chji rë xi cuma rë profeta Jonás. ");
INSERT INTO maqNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hacuaha nixtin hya ne, na xi cavitexa ngajan nangui Sabá ne, cjue cuinchajyë nuju ta, tsëhë xi jemu cjuañihi cavatju na tsëhë xi jercu cjin hiscan canduva na xi cuihndë na cjuatacun ndacun rë Salomón, me xi cavitexa xuta naja nixtin hatsëë. Peru nguehe tejña ngahan xi hitsë sa vengui chji rë cjuatacun naha xi cumá rë cjuatacun rë Salomón. ");
INSERT INTO maqNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Hya xi vetjuxin xitsehen tsëhë xahasen rë ngu xuta hiscan xi camá sacuaha ndava xitsehen jan ne, fi táha hiscan jemu nangui quixí camahani, vanguise cahndë́ hiscan xi cuejñajenda. ");
INSERT INTO maqNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hane xi sacuiin rë cahndë́ hiscan cuejñajenda ne, cuitjin tsingatahacacun: “Cúya rë cjuë́ ndya naha hiscan xi cavétjuxen.” Cuatjin tsingataha cacun xitsehen jan. Hane hya xi vuya fehe xitsehen jan cahntsua xahasen jan ne, vutsejen xitsehen jan cahntsua xahasen jan sacuaha ngu ndihya tiya, ngu xi caxtecha tyjahi tyjahi, hacuaha siundaja chichihin ngu tsë́ ngu xtí. ");
INSERT INTO maqNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Xi vutsejen xitsehen xi cuatjin jyihi jan ne, sehe fi jaha sa rë yatu sa xitsehen xi hitsë sa tsehen xi cumá rë vëhë ne, sehe visehen nga viyujucahndë́ jan. Peru xi má ngascan ne, hitsë sa chojyihi tsëhë xuta vëhë xi cumá rë titjun. Cuitjin cumá tsëhë xuta xi siu nixtin vihi. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Hya xi tichja me cojo xutacjín ne, naa rë me cojo xicjin me ne, cafehetjengui me Jesús, hane maji vechútahacjin me xi cuichja me cojo ta tsëhë xi jemu quitsë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ngajan xi cachja ngu xi cachja cuitjin: ―‍Nutsujun ni. Ná nuju cojo nixti xingun ne, hinchacun me ngajan candatsen, xi meje nduvatjengui nuju me cuichja me cojo nuju. ―‍Cuatjin casacu camachaya rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Hya xi camá ne, cavuya me catsicuya me cjua cuitjin: ―‍¿Yo xi má nuju xi ná naha cojo xingueen? ");
INSERT INTO maqNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hya xi cuatjin cachja me ne, catsingacun tsja me xuta ladu rë me sehe cachja me cuitjin: ―‍Ngayun xi nechun nguehe ne, ngayun xi sacuaha ná naha cojo sacuaha xingueen ngayun ta, ");
INSERT INTO maqNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","tu yo ni me xi sahmi me sacuaha meje rë Nahmi naha xi tacun me ngahnga ne, me vëhë tangun ni cojo xingueen, cojo ná naha. ");
INSERT INTO maqNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nixtin hya ne, cavetjuxin Jesús tsëhë ndihya ne, quiji me tjehen laguna ngajan cavejña me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hane ngajan camatangun xutacjín. Vëhë xi cavisehen me ngu barcu ngajan cavéjña me. Hane xutacjín jan ne, caviyuju me nangui quixí tjehen nandan jan. ");
INSERT INTO maqNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sehe cavicuya Jesús me jemu cjín cjua sacuaha xcusun rë ejemplu. Cuitjin cachja me: ―‍Cuejñaa ne xi ngu cha xi tsitjë cha trigu matsejen ne, cavetju cha quiji cha xi tsitjë cha trigu. ");
INSERT INTO maqNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Hane jinguyëjë rë xi titsitjë cha matsejen ne, ngujo matsejen ne, cavixu ndiya. Hane canduva chu nisë, catsicjë chu cajine chu. ");
INSERT INTO maqNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hane ngujo nga matsejen ne, cavixu hiscan xi jemu naxindya, hacuaha jemu chuva nihndë quisun. Ngajan jemu xati cavetju ta tsëhë xi hacuiin tjain nihndë quisun. ");
INSERT INTO maqNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hane xi cavetjucaa tsuhi ne, cavaca rë cojo ndavá jan. Hane tsëhë xi tsajin tyjama rë xi nungun matsejen ne, caxintsen. ");
INSERT INTO maqNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ngujo nga ne, cavixu ngajñi nahyá. Hane xi camacha tangun matsejen ne, nahyá jan ne, vëhë casahmi hndë rë catsixi rë. ");
INSERT INTO maqNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Hane xi yahnga matsejen ne, cavixu hiscan nihndë ndaja. Hane camayehe ne, ngujo ne casua tutjë rë ngu cientu sa cuatjin sacuatjin xi camatjë́, ngujo nga ne, yachantë sa, hane ngujo nga ne, cantë sa sacuatjin xi camatjë́. ");
INSERT INTO maqNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yo ngayun xi tjin nuju cjuasua xi cuinuhyun cjua naha ne, ndaja tetuhunrcun. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hya xi camá ne, cafehetiña xuta ladu rë me cavinenguise me Jesús tsëhë ejemplu xi chja me ta, ¿mé tsëhë xi ejemplu ni vicuya me cojo? ");
INSERT INTO maqNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hane cafayangui me tsëhë xuta jan cuitjin: ―‍Nina ne casua me cahndë́ xi ngayun ne, cuijne rcu cjuatacun tsëhë gubiernu xi sahmi Nina, cjuatahahma xi titjun ne tsajin yo machaya rë. Peru yëjë sa me xi yahnga ne, casuaain me cahndë́ xi cuijnercu me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Me xi ha tjin rë cjuatacun jan ne, sua sa Nina me, ndaja cuijne rcu me. Hane me xi tsajin cjín rë cjuatacun jan ne, cjuahataha Nina hitsë xi tjin rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Vëhë xi suvá ejemplu tichjá cojo rë me ta, handasa vutsejen me, peru sahmicuendaain me; visiñuju me ne, peru sahmi me sacuaha xi vihndiin me hacuaha vijnii rcu me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Xi cuatjin sahmi me ne, sahmichihin me cjua xi catsihindu profeta Isaías xi catsihindu cjua vihi: Handasa cuisiñuju ngayun ne, peru ha tuxa cuijnii rcun; Handasa chutsujun ne, peru cumatsijiin nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Xuta xi cuacun vë ne, tichjá cjuatacun rë me, tyjavañuju me cojo tuxcun me ne, cavechja me, ta sá tu scuëë me cojo tuxcun me, hane sá cuihndë me cojo tyjavañuju me, hacuaha cuijne rcu me cojo cjuatacun rë me, sehe cuya me ladu naha xi cuaxë́tjë me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Peru ngayun ne, jemu ndaja tsujun ngayujun ni tsëhë xi hatuxa tichutsujun cojo tuxcun; hacuaha visiñuju cojo tyjavañuju. ");
INSERT INTO maqNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nguehe cuichjá quixë cojo nuju ta jemu ndaja tsujun ta, tsëhë xi hacuaha jemu cjín profeta hacuaha jemu cjín xuta xi matitjun xi caviyuju titjun ne, jemu meje scuëë me xcusun xi ngayun tichutsujun, peru casacuiin cavëë me. Hacuaha jemu meje cuisiñuju me cjua xi tivisiñuju ngayun, peru casacuiin cavisiñuju me ta, tsëhë xi cjëë cuechu nixtin. ");
INSERT INTO maqNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Cuatjin hindë ne, nuhyun mé meje cuichja ejemplu tsëhë cha xi catsitjë trigu. ");
INSERT INTO maqNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hya xi visiñuju ngu xuta cjua tsëhë gubiernu xi sahmi Nina ne, peru vijniircu me cjua jan, sehe vinduva Satanás ne, fahataha cjua jan tsëhë xahasen rë me. Cjua vi ne, hacui sacuaha trigu xi cavixu ndiya. ");
INSERT INTO maqNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Hane tsëhë trigu xi cavixu hiscan jemu naxindya ne, hacui sacuaha hya xi vihndë xuta cjua rë Nina, hane fahatsja me cojo cjuasua. ");
INSERT INTO maqNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Peru trigu xi cuacun vë ne, jemu chúva tyjama rë vetju. Hacuanitjin ni vatju ngujo xuta má. Macjain rë me ngujo nixtin peru hya xi vechú ngu nixtin xi satë rë me cjuañihi o cjuandya xi sua xuta me ngatsë rë cjua rë Nina ne, fëcacun me cojo cjua jan. ");
INSERT INTO maqNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hane tsëhë trigu xi cavixu ngajñi nahyá ne, hacui sacuaha hya xi vihndë xuta cjua rë Nina, peru ha xcun xi cjuinduju me cojo nixtin rë me ne, tsingataha cacun me tsëhë cjuatacun xi satë naja nguehe ngasunhndë, hacuaha meje rë me cjuanchina xi cjuicanii rë, hane vëhë suaain cahndë́ xi cumajyë cjua rë Nina cahntsua xahasen rë me, hacuaha sahmii me ngu cjuandaja xi tsingacun xi xuta rë Nina má me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hane hya xi vixu yahnga trigu hiscan nihndë ndaja ne, hacuaha hacui sacuaha hya xi vihndë xuta cjua rë Nina hane vijne rcu me mé vitexa Nina, hane sahmi me cjuandaja. Tjin me xi jercu quisun cjuandaja sahmi, hane tjin nga me ne, chuva cjuandaja sahmi me, hane yahnga me, hitsë sa chuva cjuandaja sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sehe cachja nga me ngu ejemplu cojo me, hane cuitjin cachja me: ―‍Gubiernu xi sahmi Nina ne, cumá sacuaha camá hya xi catsitjë ngu xuta tutjë rë trigu ndaja xcun nangui rë. ");
INSERT INTO maqNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Peru nixten ne, hya xi jiñafë xuta ne, cafehe ngu xi condra rë me catsitjë cha ngu ndiji xi meje tanguncun cojo trigu. Ngajan ngajñi rë trigu jan catsitjë hma cha sehe quiji cha. ");
INSERT INTO maqNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hya xi camá ne, hisca xi cavetju xca rë, cavetju tú rë, sehe camachaya rë me tsëhë ndiji jan. ");
INSERT INTO maqNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hya xi camachaya rë me ne, cafehe mosu rë me xi tsëhë nangui jan, cavinenguise mosu me: “Nai, tutjë ndaja xi camá canitjun, ¿há cutjin cavetjun xi casecjan cojo ndiji ne?” ");
INSERT INTO maqNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ngajan cafayangui me tsëhë mosu jan: “Ngu me xi condra naha casahmi me.” Hane cafayangui mosu jan cuitjin: “¿Há hanguin chjanijñi ndiji jan?” ");
INSERT INTO maqNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Peru cafayangui me cuitjin: “¡Jéya! Caveni chjanujñu ndiji jan ta sá tsajin ne, hacuaha chjanu trigu xi ndaja. ");
INSERT INTO maqNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Catamacha catsijo, sehe cuichja hya xi tjune rë xi tjun ni cjuanejñi cha ndiji, sahmi cha xtë rë xi cuaca cha. Sehe cjuaya cha trigu, cuinchandaja cha cahndë́ rë.” Cuatjin fi ejemplu xi cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús ne, cachja nga me ngu ejemplu cuitjin: ―‍Gubiernu xi sahmi Nina ne, hacuaha cumajyë tangun cojo ngu tutjë ya mostasa ta jemu lihndi camahani ne. Tutjë jan ne, cafaha ngu cha catsitjë cha xcun nangui rë cha; ");
INSERT INTO maqNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tutjë rë ya mostasa ne, handasa hitsë sa lihndi má xi cumá rë yëjë ni tutjë xi yahnga ne, hya xi camá cha ni, hitsë sa jyë camá xi cumá rë yëjë ni ya xi yahnga. Cuma ngu ya xi hiscan nisë xi vitjen chu ngahnga ne, cuma sahmi chu ndava chu rcu ya jan. ");
INSERT INTO maqNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Cavuya cachja nga Jesús cuitjin: ―‍Gubiernu xi sahmi Nina ne, hacuaha tangun sahmi sacuaha san rë pan xi visecjan ngu chjuun ngajñi rë jyan chuva rë nahyu rë pan cojo sa xi sahmixa ngajñi rë yëjë ni nahyu cjín jan. ");
INSERT INTO maqNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Cuatjin cachja Jesús cojo xutacjín, ta ejemplu ni cachja me cojo xuta ne, cachjaain me chichihin ta, suvá cojo ejemplu. ");
INSERT INTO maqNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Cuatjin cavicuya me sehe cuetjucaa cjua xi catsihindu profeta ta: Cjua xi vetju ntsuva ne, suva ejemplu ni; Cuichjá cjua xi hinchahma hisca ntsacu cavetsihin ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hya xi cavatju cachja me, sehe catsicjë Jesús cjua cojo xutacjín jan, cavisehen me cahntsua ndihya hane ngajan cafehe tjengui rë me cha ladu rë me, cavinenguise cha me ¿mé vijne ejemplu tsëhë ndiji nguijña jan? ");
INSERT INTO maqNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sehe cafayangui Jesús cuitjin: ―‍Cha xi catsitjë trigu ne, hacui Quihndi rë Xuta Jain. ");
INSERT INTO maqNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hane nguijña ne, hacui ngasunhndë. Tutjë ndaja ne, vëhë xuta xi vihndë me tsëhë Nina, hane ndiji jan ne, hacui xuta xi vihndë tsëhë xitsehen. ");
INSERT INTO maqNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Cha condra xi catsitjë cha ndiji jan ne, hacui xitsehen xi matitjun cha. Hacuaha nixtin xi cjuanga ne, hya xi cjuë ngasunhndë. Hane cha xi cjuanga ne, hacui ángel. ");
INSERT INTO maqNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Cuanitjin sacuaha ndiji xi casahmi cha xtë rë xi cueti, cuatjin cumá cojo xuta xi hndiin tsëhë Nina hya xi cjuë ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Hya ne Quihndi rë Xuta Jain ne, tsingatju me ángel rë me xi cuahaxin me yëjë ni xuta xi candiya xicjin me ngajñi rë cjuatsehen cojo xuta xi sahmi me cjuatsehen, cuaxëxin me tsëhë gubiernu xi sahmi Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Hya xi camá cavaxëxin me ne, scandiya me xuta hiscan cuaca me ngu ndihi jyë, ngajan jemu squihnda me hacuaha jemu cuanerii nehñu me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Peru xuta xi tyjahi cjuatacun rë me xcun Nina ne, cumá me sacuaha tsuhi xi seti xi sua hasen rë camá ngajan gubiernu xi sahmi Nina nahmi rë me. Yo ngayun xi tjin nuju cjuasua xi cuinuhyun cjua naha ne, ndaja tetuhunrcun. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Xuta xi meje cuisehen gubiernu xi sahmi Nina ne, hacuaha tangun me sacuaha ngu cha xi casacu rë cha ngu cahndë́ hiscan xi caseyanijihma tujún cjín. Hane hya xi camá ne, cavetsa nga cha tujún jan, sehe quiji cha cojo cjuasua ne, caviteña cha yëjë xi tjin rë cha sehe cavechutaha cha chji rë xáhva jan. ");
INSERT INTO maqNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Hacuaha xuta xi meje cuisehen me gubiernu xi sahmi Nina ne, tangun me sacuaha ngu cha viteña xi vanguise cha ngu tuseti xi hitsë sa ndaja seti. ");
INSERT INTO maqNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hane xi sacu rë cha ngu xi jercu tu vengui chji rë ne, quiji cha caviteña cha yëjë xi tjin rë cha sehe cavechutaha cha chji rë tuseti jan. ");
INSERT INTO maqNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Hacuaha gubiernu xi sahmi Nina ne, cumá sacuaha ngu changa jyë xi catsingatjeya xuta ndachacun. Hane hya xi camá ne, ngajan cahntsua changa jan camá tangun yëjë xcusun chu ti. ");
INSERT INTO maqNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Vëhë xi hora xi catsë rë ne, cajuvë nga xuta changa jan ne cavejña me tjehen rë ndachacun ngajan cavaxijin me chu. Chu xi chine ne, cavinchanndaja me, peru cacandi me chu xi yahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Cuanitjin ne cumá hya xi cjuë ngasunhndë, ta cuinduva ángel ne, cuatëcja me xuta xi tsehen cjuatacun rë me tsëhë xuta xi tyjahi cjuatacun rë me, ");
INSERT INTO maqNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","sehe scandi me xuta tsehen hiscan cuaca me ngu ndihi jyë. Hane ngajan ne, jemu squihnda me hacuaha jemu cuanerii nehñu me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Hya xi camá ne, Jesús ne, cavinenguise me xicjin me: ―‍¿Há cavijne rcu cjua vi? Ngajan cafayangui me: ―‍Juun, cavijnircuin. ");
INSERT INTO maqNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sehe ngajan cachja Jesús cuitjin: ―‍Hya xi ngu maestru xi vicuya me ley ne, sá xi scutaya me xi meje cuisehen me ladu tsëhë gubiernu xi sahmi Nina ne, sahmi me sacuaha nai rë ngu ndihya jyë. Xuta jan ne, vaxë me xcusun xatsë ne, hacuaha vaxë me xcusun changá tsëhë cahndë́ xi cavinchandaja me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Hya xi camá cajnetaha cachja Jesús ejemplu vihi ne, sehe cavatju quijixin me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hane xi quiji me ne, cafehe me nangui rë me, ngajan cavicuya me xuta cahntsua yungun rë. Hya xi camá ne, jercu cavëhërcun me Jesús, hane cachja me cuitjin: ―‍¿Jani cavutaya cha vihi ta jemu tjin rë cha cjuatacun? ¿Jani casacu rë cha cahndë́ xi sahmi cha cjuarcun? ");
INSERT INTO maqNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Cha vihi ne, quihndi rë cha chjineya jan. Naa ra ne, María hmí na. Hacuaha xicjin cha ne, hacui Jacobo, José, Simón cojo Judas. ");
INSERT INTO maqNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hacuaha tichjá cha ne, xuta nandya naja. Ha hyun ta cuatjin peru, ¿jani casacu rë cha cjua xi tichja cha? ");
INSERT INTO maqNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Cuatjin ne mijí cjuaha cuenda me cjua rë Jesús tsëhë xi tangun nangui rë me. Sehe cachja Jesús cuitjin: ―‍Ngu profeta ne, macjain rë xuta me, peru hatuxa xuta nangui rë me macjaain rë me tsëhë me. Hacuaha xuta ndava me ne, macjaain rë me tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Cuatjin camá ta tsëhë xi ngatsë rë xi macjaain rë xuta me ne, ndastu cjín cjuarcun casahmi me ngajan. ");
INSERT INTO maqNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nixtin hya ne, camachaya rë me xi matitjun xi hmí rë Herodes cjua xi tichja xuta tsëhë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ngajan xi cachja me cojo xuta xi faha cuenda rë me ta: ―‍Cha vëhë ne, hacui nima Juan Vitenda Xuta. Handasa cahme nima, peru ha cavascaya rë, vëhë xi tjin rë cha ngahñu xi má sahmi cha cjuarcun. ");
INSERT INTO maqNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ta Herodes jan ne, ha catsingatju me cachjaha rë Juan ne, catsihñu me cha xi quiji cha ndavaya. Cuatjin casahmi Herodes ta tsëhë xi cuatjin cachuya rë na Herodía, chjuun rë hntsë Herodes. ");
INSERT INTO maqNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tsëhë na vë cachja Juan cojo Herodes cuitjin: ―‍Chja ley ta ndajintjin camahani xi chjahan chjuun rë xingueen. ");
INSERT INTO maqNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes ne, meje tsiquehen me Juan jan, peru camaji ta tsëhë xi xi má rë xuta ne, cha Juan ne, hacui profeta má cha. Hane Herodes ne, tsacjun me xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Cuatjin camá xi hya xi cavechu nixtin rë suhi tsëhë Herodes, na quihndi rë na Herodía ne, catë na ngajñi xuta xi siu suhi jan. Hane jemu cachuya rë Herodes xi cuatjin catë na. ");
INSERT INTO maqNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sehe ngajan xi Herodes casua na me cjua quixi rë me xi sua me na tu mé ni xi meje cjuehya na. ");
INSERT INTO maqNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ngajan xi na vë ne, hya xi ha cavinchangui na naa rë na ne, cachja na cuitjin: ―‍Meje ná xi cahntsua ngu tyuva ne, tuhun ná rcu Juan Vitenda Xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hya xi camá ne, jercu choho cama rë Herodes. Peru tsëhë xi hisca Nina caveyanangui me hane tsëhë xi xcun cjín xuta jan casua me cjua ne, catsingatju me cjua xi cuatjin cumá. ");
INSERT INTO maqNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hane cavitexa me sindadu cavatësun cha rcu Juan ngajan ndavaya. ");
INSERT INTO maqNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hya xi camá ne, cafehe cha cojo rcu jan xcun ngu tyuva hane casua me na. Sehe quijitjengui na naa rë na, casua na naa rë na. ");
INSERT INTO maqNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hya xi camá ne, xuta ladu rë Juan jan, cafehya me nima caveyaniji me. Sehe quiji me casua me camachaya rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hane xi camachaya rë Jesús ne, cavetju me ngajan cavisehen me ngu barcu quiji me ngu cahndë́ xín. Peru xi camachaya rë xuta ne, cavetju me tsëhë nandya ne, quiji ntsacu me tjehen laguna quiji tjengui me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Xi tu cavetju Jesús tsëhë barcu ngunda ne, cavutsejen me xutacjín jan, hane camayuma rë me xuta jan. Hane catsindaja me xuta hmu rë. ");
INSERT INTO maqNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hane hya xi jimá nguixun ne, cafehe xuta ladu rë me cachja cojo me cuitjin: ―‍Jemu xín camahani cahndë́ vi, hane ha quiji hora. Ninguijnutuhun cjua cojo xutacjín vë ne, sehe catji me nandya xi siu tiñataha catatsë me comida xi sinë me. ");
INSERT INTO maqNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Peru Jesús ne, cuitjin cachja me cojo cha xi tejó jan: ―‍Sahmii ngujyë xi cjuexin me ne, ngayun tuhun xi sinë me. ");
INSERT INTO maqNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sehe ngajan xi cachja cha ladu rë me cuitjin: ―‍Hñu pan ne cojo jo ti tjin naja. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sehe cachja Jesús cuitjin: ―‍Nduvuncujun. ");
INSERT INTO maqNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hya xi camá ne, casahmi Jesús xi catiyuju xutacjín jan xcun ndiji; sehe cafahatsja me hñu rquí pan jan cojo jo ti jan. Hane tivutsejenniji me ngahnga ne, casua me nacuechji rë Nina, sehe cavotoho langa me pan casua me pan jan cha ladu rë me xi cjue sua cha sinë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hane xuta ne, yëjë ni me cajinë me hacutjin cachuya rë xahasen rë me. Hane xi cachjaya rë xi cavangui cajinë xuta jan ne, catsë tejó chajne. ");
INSERT INTO maqNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Me xi cajinë pan jan ne, hñú mil má me xi xihin. Ha xin yachjin cojo langa xi hacuiin cojo camaxqui. ");
INSERT INTO maqNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hya xi camá ne, Jesús ne, casahmi rë me ngujyë xuta ladu rë me xi cuisehen me barcu hane cjue titjun ni me ngunda vëhë, jinguyëjë rë xi tsinguijnetaha me cjua cojo xutacjín jan. ");
INSERT INTO maqNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hane hya xi camá quiji xutacjín ne, sehe camijixin Jesús rcu ndetjún xi cuisiajmi me cojo Nina. Hane hora xi camá nguixun ne, tacun suvá me. ");
INSERT INTO maqNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Peru barcu jan ne, vasentjin laguna cjui, hane jemu chja cjui ngatsë rë tsindyu rë nandá xi tsivaha rë barcu ta, tsëhë xi tjo ne, taha hiscan cjui ne, ngajan nduva. ");
INSERT INTO maqNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hane hya xi tiña sahasen ne, quiji ntsacu Jesús xcun nandan ne quiji tjengui me me tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hya xi cavëë xuta ladu rë me xi nduva ntsacu me xcun nandan ne, jemu camá xti rë me cachja me ta nima xi meje cuincharcun rë me, hane cajindayatë me. ");
INSERT INTO maqNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngajan xi cachja Jesús cojo me ta: ―‍¡Xi carcuun! ¡Tuhun cjuetacun xahasen nuju ta ngahan vi! ");
INSERT INTO maqNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hya xi camá ne, cafayangui Pedru tsëhë Jesús cuitjin: ―‍Nai, sá xi quixi xi ngayun ne, tuhun ná cahndë́ nduvá tjenguë nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sehe cachja Jesús cuitjin: ―‍Nduvun. Hane cavitjujne Pedru tsëhë barcu jan, quiji ntsacu me quiji tjengui me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Peru xi camachaya rë me tjoxtin ne, catsacju me camá, sehe cavetsihin cavisehen ngahma me ngajñi nandan. Hya xi camá ne cajindayatë me Jesús cachja me cuitjin: ―‍¡Nai, naxuntjun ná! ");
INSERT INTO maqNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hya xi camá ne, ngutjen cafahatsja Jesús me, cavaniji me me ne, cachja me cojo me cuitjin: ―‍Ngayun ne, cjëë cumangutacunndujun cojo ná, ¿mé má macjaain nuju? ");
INSERT INTO maqNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hya xi camá ne, cavisehen catsijo me cahntsua barcu jan, hane hora vëhë ne casejyu tjo jan. ");
INSERT INTO maqNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ngajan xi xuta xi hincha barcu jan ne, cavixcuhnchi me cafaharcun me Jesús cachja me cuitjin: ―‍Ngayun ne, quixi jain xi Quihndi rë Nina yun. ");
INSERT INTO maqNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Xi quiji sa me cojo barcu ne, cafehe me tjehen laguna hiscan nandya xi hmí Genesaret. ");
INSERT INTO maqNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hane xi camachaya rë xuta xi Jesús xi cafehe me, catsingatju me cjua rë yëjë ni nandya xi siutahndee, hane xuta ne quijicojo me xuta hmu rë me hiscan tacun Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sehe cafehya me cojo Jesús xi ndastu satëtaha xuta hmu rë jan ntsacu tsjian rë Jesús. Hane yëjë ni xuta hmu rë xi casatëtaha ntsacu tsjian rë Jesús ne, camandaja me. ");
INSERT INTO maqNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ngu ndiya ne, ngujo cha tsëhë partidu fariseo cojo ngujo cha maestru rë ley ne, canduva cha tsëhë nandya Jerusalén, quiji cha hiscan tacun Jesús, cachja cha cojo me cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―‍¿Hacutjin cumá xi cha ladu nuju ne, sahmii cha sacuaha yaha xcusun rë xutachanga naja? Ta cuatjin vanii cha tsja cha hora xi jinë cha niñu. ");
INSERT INTO maqNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ngajan xi Jesús cafayangui me tsëhë cha cuitjin: ―‍Hane ngayun ne, ¿hacutjin cumá xi vejñuxun cjua xi cavitexa Nina ngatsë rë xi nihñu xu xcusun rë xutachanga naja? ");
INSERT INTO maqNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Cachja Nina ta: “Chjuhunrcun na nuju, chjuhunrcun nahmi nuju”, hacuaha chja ta: “Yo xi choho chja tsëhë xutacha rë ne, xuta ne tsiquehen rë.” ");
INSERT INTO maqNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Peru ngayun tuhun cahndë́ xi cuichja xuta cojo xutacha rë ta: “Ha quihndë cumaji cuisécoo nuju ta yëjë ni xcusun xi tjin ná ne, ha cavejñá tsja Nina.” ");
INSERT INTO maqNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","¿Mé má cuatjin tuhun cahndë́ xi faharcuiin cha nahmi rë cha? Cuitjin ne, ngatsë rë xcusun nuju sacuaha xi venguichjiin rë cjua rë Nina xi cuma rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ngayun ne, xuta jo xcun jo hntsua ngayun. Cachja quixi profeta Isaías xi cuitjin catsihindu me tsujun: ");
INSERT INTO maqNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Xuta xi cuacun vi ne, ndaja chja me tsahan peru xi cojo xahasen rë me ne, hisca tsinguitsjiin me ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tu mahya xi faharcun ná me ta, Xi vicuya xicjin me ne, hacuiin cjua naha ta tu cjua rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hya xi camá cachja me cuatjin ne, cajindaya Jesús xutacjín cachja me cojo cuitjin: ―‍Ngayujun ngarca ni ne, nuhyun ndaja cjua vi: ");
INSERT INTO maqNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Xcusun xi tsitsehen rë xuta ne, hacuiin xcusun xi chine xi visehen hntsua me, ta xcusun xi tsitsehen rë xuta ne, xcusun xi vetjun tsëhë hntsua me. ");
INSERT INTO maqNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sehe cafehe xuta ladu rë Jesús ne, cavinenguise me cuitjin: ―‍¿Há hyun xi canicjun rë cha partidu fariseo ne xi cuatjin canújun? ");
INSERT INTO maqNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Peru cafayangui Jesús cuitjin: ―‍Tu mé ni tutjë xi catsitjiin nahmi naha xi tacun ngahnga ne, tjune rë hisca cojo tyjama rë. ");
INSERT INTO maqNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","¡Caveni! ¡Nihñuu cuendun me! Me vëhë tangun me cojo xuta rcá xi cjuecani xicjin me. Hane sá xi cuatjin ne, cuixuya catsijo me xanga. ");
INSERT INTO maqNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sehe cachja Pedru cuitjin: ―‍Ningacun niji mé vijne ejemplu jan. ");
INSERT INTO maqNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ngajan xi Jesús cachja cojo me ta: ―‍¿Há hiscan ngayun cajnii rcun cjua xi cachjá ni? ");
INSERT INTO maqNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Há hyuun xi xcusun xi jinë xuta ne visehen cahntsua me? Fë ne, vetjutaha ndatsen. ");
INSERT INTO maqNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Peru xcusun xi vetju chja me ne, nduva tsëhë xahasen rë me, hane vëhë tsitsehen rë me, ");
INSERT INTO maqNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ta tsëhë xi tsëhë xahasen rë xuta ne, nduva cjuatacun tsehen sacuaha jyë́ xi tsiquehen xicjin xuta, sacuaha jyë́ xi sahmi chjuunnahñu rë me jingu sa chjuun, sacuaha yachjin xi viteña yojo rë, sacuaha cjuachëjë, sacuaha testigu xi vindacha me, sacuaha cjuachjataha. ");
INSERT INTO maqNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yëjë cjuatsehen xi cuacun vëhë ne, nduva tsëhë xahasen rë xuta, hane vëhë tsitsehen rë me; peru sá jinë me niñu cojo tsja me xi cjëë cuane me ne, tsitsiin rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hane Jesús ne, cavetju me ngajan, quiji me ngu nanguixin táha distritu nandya Tiro cojo nandya Sidón. ");
INSERT INTO maqNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hya xi camá ne, cafehetjengui rë me ngu chjuun cananea xi tsëhë ngajan. Cajindaya na cachja na cojo Jesús cuitjin: ―‍¡Nai! Ngayun, quihndindaicjin rë David, ¡catamayuma nuju ngahan! ta na quihndi naha ne, jiya xitsehen xi jemu suandya rë na cahntsua xahasen rë na. ");
INSERT INTO maqNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Peru Jesús ne, ndastu me cjua catsicuya me. Hane xuta ladu rë me ne, cafehya me Jesús cuitjin: ―‍Ningatjunxun na, ta jemu si nduvatjengui na yaan fehyataha na yun. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ngajan xi cafayangui Jesús cuitjin: ―‍Nina ne, catsingatju me ngahan ngatsë rë xuta rë nangui Israel, ta me vëhë sacuaha tsánga xi cachaja má me. ");
INSERT INTO maqNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hya xi camá ne, cafehetiña na tsëhë Jesús cavixcuhnchi na xcun Jesús xi cafaharcun na me. Cachja nga na cuitjin: ―‍Tatá, nihñu favor tisecun ná. ");
INSERT INTO maqNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ngajan xi cachja Jesús ejemplu vi: ―‍Sechiye ne catijnetaha catjine nixti ta, hacuiin ndatjin xi chjahantahan niñu tsëhë nixti hane sehe tahan rë naña. ");
INSERT INTO maqNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hane cafayangui na cuitjin: ―‍Quixi jain xi nújun, peru naña xi siu ngahma maxë ne, sacu xi rë pan xi vixuhndu ngahma maxë rë nai rë chu hane jinë chu. ");
INSERT INTO maqNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sehe cafayangui Jesús cachja me cojo na cuitjin: ―‍Ngaye chjuun, jemu ndaja mangutacuin cojo ná. Catamandaja quihndi riji sacuaha xi meje ri. Hya xi camá ne, hora hya ne, camandaja quihndi rë na. ");
INSERT INTO maqNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Hya xi camá ne, cavetju Jesús taha vëhë quiji me tahndee rë laguna Galilea sehe ngajan camiji me ngu ndetjún, ngajan cavejña me. ");
INSERT INTO maqNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hane jemu quijitjengui rë me xutacjín, yaha me xuta rengun, xuta rcá, xuta lihmi, xuta yoho cojo xuta xi má rë hacjahi chíhin ne caviyujutë me xuta jan xcun Jesús hane Jesús ne, casahmi me xi camandaja me. ");
INSERT INTO maqNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Xi cavëë xutacjín xi cuatjin camá ta, cama cachja xuta lihmi, camajingu xuta yoho, findaja xuta rengun hacuaha tsejen rë xuta rcá ne, sehe jercu quijircun rë me, hane casahmi hnga me, casahmi jyë me Nina, Nina jan xi faharcun xuta nangui Israel. ");
INSERT INTO maqNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ngajan cajindaya Jesús xuta ladu rë me, cafehe me cachja Jesús cojo rë me cuitjin: ―‍Jemu yuma má ná xutacjín vi ta ha quihndë jyë nixtin hinchataha me cojo naja, hane ha quihndë tsajin camahani mé xi sinë me. Tsajin mangucacun xi tsingátju me cjue me xi cjëë sinë me niñu ta, sá tsajin ne, cjuaha rë me hinda ndiya. ");
INSERT INTO maqNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sehe ngajan xi xuta ladu rë me ne cafayangui me tsëhë me cuitjin: ―‍Peru nguehe nangui xín ne ¿jani cuma sacú niji pan xi sinë xutacjín vi? ");
INSERT INTO maqNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ngajan xi cavinenguise Jesús cojo xuta cuitjin: ―‍¿Há cjín pan tjin nuju? Ngajan xi cachja me ta: ―‍Yatu má pan hacuaha siu ngujo ti langa. ");
INSERT INTO maqNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ngajan xi Jesús ne cavitexa me xutacjín xi cuiyujutë me nangui. ");
INSERT INTO maqNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hya xi camá casahmi xuta ne, sehe cafaha Jesús yatu pan cojo ti jan ne sehe casua me nacuechji rë Nina. Hane cavotoho langa me pan cojo ti jan, casua me xuta ladu rë me xi cavatëcja me ne cafaha xutacjín. ");
INSERT INTO maqNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Cuatjin camá cajine xuta jan, hane jemu ndaja cama rë xahasen rë me. Hane xi cafaya xuta xi cavangui cajinë xuta jan ne catsë yatu nisinya. ");
INSERT INTO maqNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Xuta xi cajinë ne, sacuaha ñuju mil má me xi xihin me, hacjahi má xuta chjuun cojo quihndi. ");
INSERT INTO maqNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hya xi cajnetaha vëhë ne, catsingatju Jesús xuta cafe me, hane suvá ni me, cavisehen me ngu barcu quiji me taha nandya Magadán. ");
INSERT INTO maqNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Xi cafehe me ngajan ne, hacuaha cafehe cha tsëhë partidu fariseo cojo cha partidu saduceo hane ta tsëhë xi meje cjuahachuva cha me, cafehya cha me ngu cjuarcun xi nduva ngahnga, cojo sa xi scuëë cha xi Nina catsingatju rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Peru Jesús ne, cafayangui me cojo ejemplu vi cuitjin: ―‍Nguehe ne, hya xi chutsujun xi má haní ngahnga ne, nújun jain, ta: “Tyjahi nchujun ni, ndajyihi nixtin.” ");
INSERT INTO maqNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Cuanitjin hya xi sahasen ne, sá xi má haní ngahnga hane hincha yufí jma ne, nújun ta: “Va cumá nixtin.” Jo má tacun. ¿Hacutjin cuma xi jemu hyun mé vijne xcusun xi cún ngahnga, peru vijniircun mé vijne xcusun xi tijima nguehe nixtin vihi ni? ");
INSERT INTO maqNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Xuta tsëhë nixtin vihi ne, xuta xi tsehen cjuatacun rë me, xi tjenguiin me Nina cojo ngu ni cjuatacun, xuta vë xi fehya me ngu seña. Peru sacuiin rë me seña ta seña xi sacu rë me ne, sacuaha seña xi ha catsingacun profeta Jonás hatsëë nixtin. Sehe xi cajnetaha cachja Jesús cjua vëhë ne, caviyuju me xuta jan ne, quiji me. ");
INSERT INTO maqNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hya xi cafehe xuta ladu rë me ngunda laguna ne, hacuaha cachaya rë me cjuaha me pan. ");
INSERT INTO maqNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sehe Jesús cachja cojo me: ―‍Nechun cuidadu tsëhë san rë pan tsëhë cha partidu fariseo cojo xi tsëhë cha partidu saduceo. ");
INSERT INTO maqNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sehe cha ladu rë me ne, cavisiajmi cha cojo xicjin cha cuitjin: ―‍Tsëhë xi cachaya naja pan ne, vëhë xi cuatjin chja me. ");
INSERT INTO maqNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Peru xi camachaya rë Jesús xi veyanangui cha xi tsajin rë cha pan ne, cachja me cojo cha cuitjin: ―‍Ngayun ne, cjëë cumangutacun nduju cojo ná. ¿Mé má cuatjin nújun xi chjá ta tsëhë xi tsajin nuju pan? ");
INSERT INTO maqNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Há nuhyuun? ¿Há vitsjiin nuju? Hya xi cajinë hñu mil xuta hñu pan ne, ¿há cjín chajne cachjayun tsëhë pan xi cavangui jan? ");
INSERT INTO maqNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Hacuaha hya xi cajinë ñuju mil xuta yatu pan ne, hya ne ¿há cjín chajne cachjayun? ");
INSERT INTO maqNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Hacutjin cuma xi nuhyuun xi hacuiin tsëhë pan xi cachjá cjua jan? Xi chjá ne, nechun cuidadu tsëhë san rë pan tsëhë cha partidu fariseo cojo xi tsëhë cha partidu saduceo. ");
INSERT INTO maqNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hya xi camá ne, camachaya rë me xi cachjaain me xi meje cuidadu cojo san xi sahmixa pan ta cachjá me tsëhë xi meje cuidadu cojo cjuachacun xi sahmixa cha partidu fariseo cojo cha partidu saduceo. ");
INSERT INTO maqNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ngu ndiya xi ha cavisehen Jesús distritu tsëhë nandya Cesarea tsëhë Filipo ne, cavinenguise me xuta ladu rë me cuitjin: ―‍Mé chja xuta tsahan, ¿yo ngahan, Quihndi rë Nina Jain? ―‍Cuatjin cavinenguise me cha. ");
INSERT INTO maqNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sehe ngajan xi cachja cha cojo Jesús cuitjin: ―‍Yahnga me ne, chja me ta nima Juan Vitenda rë Xuta ngayun, hane yahnga nga me ne, chja me ta Elías, hane yahnga nga me ne, chja me ta nima Jeremías, hane me xi yahnga nga ne, chja me ta ngayun ne, ngu profeta xi hacjahi. ");
INSERT INTO maqNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","―‍Hane ngayun ne, ¿mé nújun ni, yo ngahan? ―‍Cuatjin cavinenguise Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ngajan xi cafayangui Símon Pedru cuitjin: ―‍Ngayun ne, Mesías xi catsingatju nuju Nina; ngayun, Quihndi rë Nina, Nina quicun jain. ");
INSERT INTO maqNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sehe cachja Jesús cuitjin: ―‍Ndatjin tsujun, Símon, quihndi rë Jonás. Tsajin ngu xuta xi casua camachaya nuju cjua jan, ta Nahmi naha xi tacun me ngahnga ne, me vëhë xi casua me xi camachaya nuju tsëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Hane ngahan ne, suá cumachaya nuju xi ngayun ne, ngayun xi hmí nuju Pedru. Hane ñihi nuju ne, vijne ndyojo. Hane xcun ndyojo vihi sahme yungun naha; yungun jan ne, hisca cjuaveya ne tsajin ngahñu xi tsicjëya rë. ");
INSERT INTO maqNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Suá nuju quicha tsëhë gubiernu xi sahmi Nina, ngajan xi xcusun xi nihñucjun nguehe ngasunhndë ne, hacuaha cumahñucjan ngajan ngahnga, hacuaha xcusun xi chundecjun nguehe ngasunhndë ne, hacuaha tundecjan ngajan ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sehe Jesús ne, cavitexa me xuta jan xi tsajin camahani yo xi cuichja me cojo tsëhë xi Mesías má me. ");
INSERT INTO maqNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hya xi camá ne, sehe cavetsihin vicuya Jesús xuta ladu rë me tsëhë xi sahmi ngujyë xi cjue me nandya Jerusalén, hane ngajan ne, jemu cjín cjuañihi cuátju me cuma xi sahmi xuta changá cojo nahmi xi matitjun tsëhë nahmi cojo cha xi vicuya cjuachacun ne. Tsitjungui cha me, tsiquehen cha me; peru xi cumá jyan nixtin ne, tsicuya Nina me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ngajan xi Pedru ne, quijixin me cojo Jesús. Sehe cavetsihin cachjataha me Jesús cuitjin: ―‍Tatá, ¡catamamiji rë Nina! ¡Hatuxa cumaji cuatjun cuatjin! ");
INSERT INTO maqNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hane xi cavuya Jesús cavutsejen me Pedru, ngajan cachja cojo me cuitjin: ―‍Tihinxin ngaye Satanás, ngaye ne, sacuaha ngu ndyojo xi meje xtenguiya ná ngajní cjuatsehen tsëhë xi ningatiintacuin ngaye sacuaha tsingatahacacun Nina ta ningatehetacuin sacuaha ngu xuta ngasunhndë ni. ");
INSERT INTO maqNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sehe cachja Jesús cojo cha ladu rë me cuitjin: ―‍Sá xi tjin yo xi meje rë xi cuma cuisehen me ladu naha ne, ha quihndë mijí rë xi sahmi me hacutjin xi meje rë suvá me ta nchunchujun ni meje rë xi catejñahñu xahasen rë me xi cjuenduju me cojo ndiya naha, handasa hisca cueya me xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yo xi mijii cuisehen ladu naha tsëhë xi tsacjun me xi cueya me ne, cahndë́ xi vetjo me cjuahñu rë me ne, tsichaja me cjuahñu xatsë xi sacu rë me. Peru yo xi ngatsë rë xi cavisehen ladu naha cueya ne, sacu rë cjuahñu jan. ");
INSERT INTO maqNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Mé machji rëhë rë yo xi sacú rë yëjë cjuanchina rë ngasunhndë peru sehe cueya ne cumá castigu? Tsajin mé xi cuma tsindeya xicjin me cojo cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ta ngahan, quihndi rë Xuta Jain, cuinduvá cojo hasen ndajyihi tsëhë Nahmi naha hacuaha cojo ángel naha cuinduvá; hane hya ne, cuechji me jimangu me, ¿há ndaja há ndajin casahmi me? ");
INSERT INTO maqNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cuichjá quixë cojo nuju ta tjin yahnga ngayun xi sechun nguehe xi cueyuun jinguyëjë rë xi cjëë chun xi cuitexa Quihndi rë Xuta Jain gubiernu xi sahmi Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hya xi camá cavatju jyun nixtin ne, quijixin Jesús quijicojo me Pedru cojo Jacobo cojo Juan, hntsë Jacobo, quijiniji me ngu naxi hnga. ");
INSERT INTO maqNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ngajan camá xi cavëë me xi cavindeya xcusun rë Jesús: Xcun me ne, camaseti sacuaha seti tsuhi, hacuaha tsjian rë me ne, jemu tu tyava camahani camá sacuaha hasen rë ndihi. ");
INSERT INTO maqNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hacuaha ngajan cavëë me xi cafehetsejen nima profeta Moisés cojo profeta Elías, me xi caviyuju hatsëë nixtin ne, tivisiajmi me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sehe cachja Pedru cojo Jesús cuitjin: ―‍Nai, tu ma rë xi nguehe nechin ne, sá xi meje nuju ne, sahme jyan puestu; ngu cuma tsujun ne, ngu cuma tsëhë Moisés, hane cojo ngu cuma tsëhë Elías. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hane hora xi tichja Pedru ne, canduva ngu yufí xi seti tsejen casahmi tjahnguen rë tsëhë me, hane canuhya rë ngujo cjua xi cavetju ngajñi yufí jan xi cachja cuitjin: ―‍Cha vihi xi Quihndi naha cha xi jemu hmu cacún. Jemu ndama ná ngatsë rë cha. Tinuhyun cjua xi chja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hya xi cahndë xuta rë me cjua jan ne, caticaxcun me. Hane jemu catsacjun camahani me camá. ");
INSERT INTO maqNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ngajan xi cafehe Jesús cavetahatsja me me, hane cuitjin cachja me: ―‍Tisatjunhngun. Xicarcuun. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hane xi cavutsejenniji me ngajan ne, ndastu yo siu ta suva ni Jesús tacun me. ");
INSERT INTO maqNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Xi tu tivijne me tsëhë rcu naxi jan cojo xuta ladu rë me xi quijicojo me jan ne, ngajan xi cachja me cojo me ta tsajin yo xi cuichja me cojo xcusun xi cavëë me. Xi cuatju cueya Quihndi rë Xuta Jain, sehe cuya nga me cjuahñu ne, hya cuichja me. ");
INSERT INTO maqNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ngajan xi cavinenguise me cojo Jesús cuitjin: ―‍¿Mé má cuatjin chja maestru tsëhë ley xi titjun Elías cuinduva me, sehe cuinduva Mesías? ");
INSERT INTO maqNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ngajan cafayangui Jesús cuitjin: ―‍Quixi xi Elías cuinduva me titjun ta me vëhë cuiyujuchihin me yëjë ni xcusun. ");
INSERT INTO maqNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Peru cuichjá cojo nuju ta ha canduva me, peru xuta ne, hvíin me xi hacui me, hane choho casahmi xuta cojo me hacutjin meje rë xahasen rë me. Hane hacuanitjin sahmi me xi cuátju cjuañihi Quihndi rë Xuta Jain. ");
INSERT INTO maqNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ngajan xi camachaya rë xuta rë me ta tichja me tsëhë Juan Vitenda xuta hya xi chja me Elías. ");
INSERT INTO maqNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hane xi quiji me ne cavechutaha me xutacjín ne, ngajan cafehetjengui rë me ngu xihin, cavixcuhnchitaha cha Jesús cachja cha cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―‍Nai. ¡Catamayuma nuju cha lihndi naha ta, jemu faha rë cha chajan hane jemu choho sahmi cojo cha. Jiya hora ne, finenguiya cha ngajñi ndacahi, hane jiya hora nga ne, viticjaya cha ngajñi nandan. ");
INSERT INTO maqNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cëjëcojo cha xcun xuta ladu nuju xi tsirqui me cha peru camaji casahmi me. ");
INSERT INTO maqNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sehe ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Ngayujun ni ne, xuta xi macjaain rë ngayun hacuaha xuta xi cavetjuxin tsëhë ndiya ndajyihi ngayun. ¿Há jyë sa xi cuitejña cojo nuju? ¿Há jyë sa nixtin xi scaa ná cojo nuju? Nduvuncujun cha nguehe. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hya xi camá ne, cachjataha Jesús xitsehen xi hincha xahasen rë cha, hane cavetjuxin xitsehen jan, hane hora hya ne, camandaja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hya xi camá ne, xi cafehe xuta ladu rë Jesús cavinenguise me me cuitjin: ―‍¿Mé má ngayin ne xi camaji canaxinxin xitsehen jan tsëhë xahasen rë cha vë? ");
INSERT INTO maqNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ngajan xi cachja Jesús cojo me ta: ―‍Camaji ta hacuiin ndaja macjain nuju. Ta cuichjá quixë cojo nuju ta sá xi mangutacún cojo ná ndastu hitsë ne, hacuaha cuma cuinújun cojo naxi vihi: “Catjixin, catjin catisecun ngajan tavëhë.” Hane cuihndë tsujun. Hisca sá xi mangutacún cojo ná ndastu hitsë ne, tsajin me xi cumaji nihñu. ");
INSERT INTO maqNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Peru sacuaha xitsehen xi cuacun vë ne, meje rë xi titjun chjahyan rë Nina hacuaha cuinechan xun rë me, cojo sa xi cuma naxexeen. ");
INSERT INTO maqNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nixtin xi caviyuju Jesús cojo xuta ladu rë me ngajan distritu Galilea ne, cachja Jesús cojo me ngu nixtin cuitjin: ―‍Ngahan xi Quihndi rë Xuta Jain ngahan ne, hatuxa tjin xi cuma ngahan entregadu tsja xuta ");
INSERT INTO maqNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","xi tsiquehen ná me. Peru xi cjuë xi jyan nixtin ne, cuya nga cjuahñu. Hane xi cahndë me cjua jan ne, jemu cafaha me cjuachoho. ");
INSERT INTO maqNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hya xi cafehe me nandya Capernaum, cafehe xuta xi faha me tujúnsa rë yungun, camatiña me tsëhë Pedru cachja me cojo me cuitjin: ―‍Maestru nuju ne, ¿há vechjitje me tujúnsa rë yungun? ");
INSERT INTO maqNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ngajan cafayangui Pedru cuitjin: ―‍Juun, vechjitje me. Hya xi camá ne, xi cavisehen Pedru ndihya ne, peru chajasa xi cuichja me ne, ngajan xi cachja Jesús cojo me cuitjin: ―‍Simón, ¿mé nújun? Sacuaha me xi matitjun tsëhë nandya ngasunhndë ne, ¿yo vitexa me xi satë rë xi cuechjitje tujúnsa? ¿Há quihndi rë me? ¿Há xutaxín? ");
INSERT INTO maqNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ngajan xi cachja Pedru cuitjin: ―‍Xutaxín cuechji me. Cachja nga Jesús cuitjin: ―‍Sá xi cuatjin ne, quihndi rë me xi matitjun jan ne, ha cavatjuhnga tsëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Quixi vë, peru cojo sa hacuiin ngatsë rë vëhë cumacjan rë me o maxti rë me cojo naja ne, tangun laguna ne, chandunyun tsitin ngajñi nandan ne, hane hya xi faha tsitin ngu ti ne, chu xi tjun faha rë ne, chjuhun chu nuxuhun hntsua chu hane ngajan cahntsua hntsua chu jan ne, sacú tujún xi stetaha cuechjun tujúnsa xi satë ná cojo xi satë nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hya ne, xuta ladu rë Jesús cafehe tjengui me me, cavinenguise me cuitjin: ―‍¿Yo xi hitsë sa cumatitjun hya xi sahmi Nina gubiernu? ");
INSERT INTO maqNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hya xi camá ne, cajindaya Jesús ngu lihndi, cavejña me cavasencja. ");
INSERT INTO maqNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Sehe cachja me cuitjin: ―‍Hisca ngu ngayun cumaji cuisuhun gubiernu xi sahmi Nina ne, sá xi hacuiin nindeyun cjuatacun nuju hisca cuma yun sacuaha ngu quihndi. ");
INSERT INTO maqNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Vëhë xi yo xi tsinguijne suvá me yojo rë me xi cuihndë me sacuaha vihndë ngu quihndi ne, me vëhë xi hitsë sa cumatitjun me hya xi sahmi Nina gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hane tu yo ni xi cjuahatsja rë ngu quihndi xi cuacun vë ngatsë rë xi ladu naha má ne; vëhë cuma sacuaha xi cafahatsja me ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Peru yo xi nduvacojo xcusun xi sahmi xi tsismicacun ngu quihndi ndiya naha ne, hitsë sa ndaja tsëhë xuta vëhë xi xtyangui ngu ndyojo natsi nguisin me sehe ningatjeya rë me ngajñi ndachacun. ");
INSERT INTO maqNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jemu choho vatju xuta ngasunhndë ngatsë rë xcusun xi tsitsehen rë me xi sahmi me cjuatsehen. Hatuxa cuinduva xcusun xi meje sahmi xi tsismicacun xuta ndiya rë Nina, peru jemu chojyihi tsëhë xuta xi nduvacojo me xcusun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Hane sá xi cjuatacun nuju meje rë xi nihñu ngu jyë́ cojo ntsun o sá xi cojo ntsacu ne, vengui sa chji rë xi chandunxun, ta hitsë sa ndaja tsujun xi cuma yoho yun xi cuma rë xi cuechun jingu cojo catsijo ntsun o catsijo ntsacu xcun ndihi xi tsajin nixtin tsajin nixten xi coho. ");
INSERT INTO maqNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hacuaha sá xi cjuatacun nuju meje rë xi nihñu ngu jyë́ cojo xcusun xi chutsujun cojo tuxcun ne, chjuhunxun tuxcun jan chandunxun, ta tsëhë xi hitsë sa ndaja tsujun xi sacu nuju cjuahñu xatsë handasa cojo ngu ni tuxcun xi cuma xi cojo catsijo tuxcun cuechun xcun ndihi xi sahmi castigu rë nima. ");
INSERT INTO maqNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Cojo yëjë ni ne, nihñu cuidadu xi nitjunguun ngu quihndi sacuaha quihndi vihi, ta tsëhë xi ángel xi sahmi cuenda me ne, yëjë nixtin yëjë hora ne, siu tangun me cojo Nahmi naha hane sahmii ngujyë xi cjuehya me cahndë́ xi cuichja me cojo. ");
INSERT INTO maqNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","’Quihndi rë Xuta Jain ne, canduvá me xi cuaxëtje me xuta xi cachajá. ");
INSERT INTO maqNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Mé xi nújun? Cuejñaa ne xi ngu xihin tjin rë me ngu cientu chu tsánga. Hane sá xi chajá ngu chu rë me, ¿há hyuun xi cuiyujutaha me chu xi ñujuchan tyjuhun ñuju jan nguijña ne, sehe cjue me cuanguise me ngu chu xi cachajá jan? ");
INSERT INTO maqNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Hane hya xi sacú rë me chu ne, hitsë sa jyë cjuasua tjin rë xahasen rë me ngatsë rë xi casacu rë me chu xi cachaja xi cuma rë cjuasua tsëhë ñujuchan tyjuhun ñuju chu xi tetjo. ");
INSERT INTO maqNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cuanitjin xi cuma rë Nahmi nuju xi tacun ngahnga, ta mijí rë me xi chajá hisca ngu quihndi rë me cuatjin. ");
INSERT INTO maqNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Hane sá xi ngu xingun choho sahmi cojo nuju ne, tangun suvun tinújuntuhun rë, hane sá xi tsindeya cjuatacun rë ne, ndatjin, ta hacuiin cuetsuntaha cjuandaja xi tjin nuju cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Peru sá xi vihndiin me tsujun ne, tangun chjuhun ngujo xuta tanguncujun xi tinújuntuhun rë tsëhë xi hya xi cuma me testigu nuju tsëhë, sehe cumatsejen cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sá xi hisca cojo me vë vihndiin me tsëhë me ne, tangun tinújun tsëhë xcun xuta yungun, hane sá xi hacuaha vihndiin me cjuatacun rë xuta yungun jan, cumá me xi cuma nuju sacuaha ngu xutaxín o sacuaha ngu xuta ndacha xi faha rë tujúnsa. ");
INSERT INTO maqNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Cuichjá quixë cojo nuju ta xcusun xi nihñucjun nguehe ngasunhndë ne, hacuaha mahñucjan ngajan ngahnga, hacuaha xcusun xi nihñu ndaya nguehe, hacuaha mandaya ngajan ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Hacuaha cuichjá cojo nuju ta sá nguehe ngasunhndë ne matangun cjuatacun rë jo ngayun tsëhë ngu xcusun xi chjahyun rë Nina ne, cuetjucaa jain tsujun ta sahmi chihin Nahmi naha xi tacun me ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta tu mé ni cahndë́ xi cuiyujuntangun ngu jo jyan xuta xi ngajan veyanangui ñihi naha, hacuaha ngajan ngajñi rë me tejña ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sehe cafehe Pedru cachja cojo me cuitjin: ―‍Nai, ¿há cjín ndiya sahmi ngujyë xi tsinchátaha xingueen sá xi choho sahmi me cojo ná? ¿Há ndatjin xi yatu ndiya? ");
INSERT INTO maqNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ngajan cafayangui Jesús cuitjin: ―‍Hacuiin yatu ndiya ni, ta cuichjá cojo nuju ta mameje rë xi jyanchan të cuatjin xi yatu ndiya ninchatuhun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ngajan tsejen xi hya xi Nina sahmi me gubiernu ne, cumá sacuaha ngu me xi matitjun xi meje cuaxëchihin me cuenta xi tjin rë me cojo xuta rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hane hora xi tijima ne, cajindaya rë ngu cha xi cafehe cha hane cha jan ne, të mil tujún quitjen cha. ");
INSERT INTO maqNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hane ngatsë rë xi tsajin camahani cha rë tujún xi sahmingojo cha, cachja me xi matitjun jan xi xteña cha xi cuma cha ngu mosu, xteña suva cha, hacuaha cojo chjuun rë cha cojo quihndi rë cha cojo yëjë ni xi tjin rë cha, hane sehe cuatjin cuma cuechji cha tsëhë xi quitjen cha. ");
INSERT INTO maqNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hya xi camá ne, cavixcuhnchi cha xcun me cafaharcun cha me cafehya cha me cuitjin: “Nai, catijnehnchan cjuacjan nuju, tuhun ná hitsë cahndë́ hane cuechjë tsujun.” ");
INSERT INTO maqNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ngajan xi me xi matitjun jan ne, camayuma rë me cha, catsijyëcacun me tsëhë cha tsëhë cjuacjintacun jan, catsinchataha me cha. ");
INSERT INTO maqNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Peru xi cavetju quiji cha jan, cavechutaha cha jan ngu cha xicjin cha xi quitjen tsëhë cha hitsë tujún, hane cafaha cha nguisin xicjin cha jan, cachja cha cuitjin: “Nihñi ngojo yëjë xi quitjin tsahan.” ");
INSERT INTO maqNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hane xi cavixcuhnchi xicjin cha xcun cha ne, cachja xicjin cha jan cuitjin: “Catijnehnchan cjuacjan nuju, tuhun ná hitsë cahndë́ ta cuechjë tsujun.” ");
INSERT INTO maqNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Peru mijí sua cha cahndë́, hane quiji caveya cha xicjin cha ndavaya, ngajan seya xicjin hisca xi cuma sahmingojo tujún. ");
INSERT INTO maqNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hya xi cavëë yahnga mosu xcusun xi camá cavatjun jan, jemu camá xti rë me quiji casuacuenda me tsëhë cojo me xi matitjun tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ngajan xi cajindayavaha me xi matitjun cha jan, cachja me cuitjin: “Ngaye, jemu choho xcusun riji. Catsinchátaha yëjë ni xi quitjin tsahan, tsëhë xi jemu cachjahye. ");
INSERT INTO maqNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Hane ngaye, ¿hacutjin cumá xi tsajin ri cjuayuma cojo xinguin? ta ngahan ne, cama yuma ná ngaye.” ");
INSERT INTO maqNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cuatjin camá xi jemu camacjan rë me xi matitjun cojo cha jan, catsingatju me cha cjuañihi ngajan ndavaya jñu hisca nixtin xi cjuë cuechji cha xi quitjen cha. ");
INSERT INTO maqNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Hane cuatjin sahmi Nahmi naha xi tacun ngahnga cojo nuju, sá xi ninchatuun xingun cojo yëjë xahasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Hya xi cajnetaha cachja Jesús cjua vi, sehe cavetju me distritu Galilea ne, cavisehen me distritu Judea ngajan tahndee ndajyë Jordán ladu vetjucaa tsuhi. ");
INSERT INTO maqNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hacuaha quiji tjengui rë me xutacjín hane casahmi me xi camandaja xuta hmu rë. ");
INSERT INTO maqNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hya xi camá ne, ngajan cafehe cha tsëhë partidu fariseo ne, quiji cha hiscan tacun Jesús hane tsëhë xi meje cjuahachuva cha me cojo cjua rë me ne, cachja cha cuitjin: ―‍¿Há tsingatihi ley xi ngu xihin ne, tsismi chjuun rë ngatsë rë tu mé ni xcusun xi chuyiin rë me tsëhë? ");
INSERT INTO maqNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ngajan xi cafayangui me cuitjin: ―‍Ngayun ne, ¿há cachutayuun ta tsëhë xi hisca ntsacu cavetsihin casahmi Nina ngasunhndë ne, casahmi me xi chjuun xi xihin xuta? ");
INSERT INTO maqNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Cachja Nina ta ngatsë rë xi cuatjin casahmi me xuta ne: “Vëhë xi ngu xihin ne, cuejña cha nahmi rë cha, hacuaha cuejña cha naa rë cha, hane cumatangun cha cojo chjuun rë cha sacuaha ngu ni xahasen.” ");
INSERT INTO maqNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ha quihndë hacuiin jo ta sacuaha xi ngu ni xahasen. Hane tsëhë xi ha Nina cachja me xi cuatjin cuma ngu xahasen me ne, ndajintjin xi xuta ne, tsinguetsuntaha me tsëhë xicjin me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ngajan cavinenguise cha cuitjin: ―‍Sá xi cuatjin ne, ¿mé má casua Moisés cahndë́ xi ngu xihin cuma cuejña cha ngu xujun tsja chjuun rë cha xi ha quihndë mijí rë cha na? Hane xi cuatjin ne, cuma tsismi cha na. ");
INSERT INTO maqNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sehe ngajan xi Jesús ne, cachja me cojo cha ta: ―‍Ngatsë rë cjuataja rë xahasen nuju ne, vëhë xi Moisés ne casua me cahndë́ xi nismu chjuun nuju, peru hacuiin cuatjin cavitexa Nina ntsacu cavetsihin. ");
INSERT INTO maqNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cuichjá cojo nuju ta yo xi tsismi chjuun rë handasa ndastu mé cjuatsehen casahmi chjuun jan cojo ngu xihin hacjahi, hane cuixan cojo ngu nga chjuun ne, tjin jyë́ rë me ta tsëhë xi ngatsë rë cjua rë me sahmi chjuun jan cjuatsehen. ");
INSERT INTO maqNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ngajan xi cachja xuta ladu rë Jesús cuitjin: ―‍Sá xi cuatjin sacuaha xi nújun, ndajintjin tsajan xi cuixan. ");
INSERT INTO maqNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Cachja nga Jesús cuitjin: ―‍Hacuiin yëjë ni xuta ma vijnercu me cjua vi, suva xuta xi Nina casua cahndë́ xi vijnercu me ne, me vëhë vihndë me. ");
INSERT INTO maqNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tjin xuta xi cumaji cuixan me, sacuaha xihin xi hisca chaja sa catsin me ne, maji matangun me cojo ngu chjuun. Hacuaha tjin yahnga me xi catsixindë xuta me, hacuaha tjin yahnga me xi faain me ngu chjuun ngatsë rë xi sahmixa rë gubiernu xi sahmi Nina. Catjahatsja cjua vi tu yo ni xi cuma cjuahatsja rë. ");
INSERT INTO maqNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Hacuaha quijicojo xuta nixti rë me hiscan tacun Jesús xi cuisanetsja me nixti jan hacuaha cjuehya me cjuandaja rë Nina ngatsë rë me. Peru hya xi cavëë xuta ladu rë Jesús xi cuatjin tijima ne, cavatëcja me cjuatacun rë xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Peru Jesús ne, cachja me cojo xuta ladu rë me cuitjin: ―‍Tuhun rë nixti cahndë́ catinduva tjengui ná. Xicanichuun rë cahndë́ ta, tsëhë xi gubiernu xi sahmi Nina ne, má tsëhë nixti xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hane ngajan cavisanetsja me nixti jan sehe cavetju me tsëhë cahndë́ jan. ");
INSERT INTO maqNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hya xi camá ne, cafehe ngu cha nixti xi cavinenguise cha Jesús cuitjin: ―‍Ngayun Maestro, ¿mé cjuandaja meje rë xi sahme cojo sa xi sacú ná cjuahñu xatsë xcun Nina? ―‍Cuatjin cachja cha. Ngajan xi cachja Jesús cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","―‍¿Mé má noje tsahan xi ndaja ngahan? Ngu ni Nina xi ndaja me. Peru sá xi meje sacú ri cjuahñu xatsë jan, nohye cjua rë ley xi cavitexa Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ngajan cafayangui cha cuitjin: ―‍¿Jarë cjua jan? Hane cachja Jesús ta: ―‍Xicanicuun xuta, xicanihñuu cjuatsehen cojo rë ngu chjuun o cojo rë ngu xihin xi hacuiin tsujun, xicanihñuu cjuachëjë, xicanujuun cjuandesu tsëhë xuta, ");
INSERT INTO maqNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","chjuhunrcun nahmi nuju hacuaha chjuhunrcun na nuju. Hacuaha nihñu hmutacun xingun sacuaha hmutacun suva yojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ngajan cachja cha nixti jan ta: ―‍Yëjë ni cjua vëhë ne, ha cáhndë tsëhë hisca cjualihndi naha. ¿Mé sa meje rë xi sahme? ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ngajan cafayangui Jesús cuitjin: ―‍Tjin sa ngu cjua sehe cuma chihin yëjë ni: yëjë ni xcusun xi tjin ri ne, titeñi, hane sehe tichecje tujún rë ngajñi rë xuta yuma. Hane xi cuatjin nihñi ne, jemu jyë cjuanchina sacú ri ngajan ngahnga. Hane xi cjuë cuichecje tujún vëhë ne, sehe ndove tisecue ná. ");
INSERT INTO maqNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Peru xi cahndë cha nixti cjua xi cachja Jesús ne, jemu va camá cacun cha hane quiji cha, tsëhë xi jemu nchina camahani cha. ");
INSERT INTO maqNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hya xi camá quiji cha ne, cachja Jesús cojo xuta ladu rë me cuitjin: ―‍Cuichjá quixë cojo nuju ta jemu chja xi ngu xuta xi tjin rë me cjuanchina cuisehen me hiscan sahmi Nina gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hisca cuichjá nga xi hitsë sa chjaain cuatju ngu chu camellu ngojo rë ngu níndu xi cuma rë xi cuisehen ngu xuta nchina hiscan sahmi Nina gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ngajan xi xuta ladu rë me ne jemu quijircun rë me cjua rë me tsëhë xi cachja me tsëhë xuta nchina hane cavinenguise me Jesús cuitjin: ―‍Sá cuatjin ne, ¿yo xi cuma cuetjutje ni? ");
INSERT INTO maqNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ngajan xi Jesús ne, cavutsejen me hiscan siu xuta jan ne, cachja me cojo me cuitjin: ―‍Xuta ne, maji sahmi me; peru yëjë ni xi maji sahmi xuta ne, Nina ne, hatuxa ma sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sehe cachja Pedru cojo me cuitjin: ―‍Chutsujun ni. Ngayin ne, ha canismitacuin yëjë ni xcusun xi tjin niji, hane tivisecuin nuju. Hindë ne, ¿mé sacu niji? ");
INSERT INTO maqNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sehe cachja Jesús cuitjin: ―‍Cuichjá cojo nuju cjuaquixi ta hya xi cuechu nixtin xi cumá xatsë yëjë ni ne, nixtin xi cuejña Quihndi rë Xuta Jain xcun silla xi sahmi me gubiernu ne, ngayun xi tejó ne, ngayun xi cavisuhun ladu naha hacuaha cuinechun xcun silla nichuvun cjuatacun rë yëjë tejó tjë naja, ngayaan xi tjë rë xutachanga naja Israel ngayaan. ");
INSERT INTO maqNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hacuaha yëjë xuta xi tsismicacun me ndava me, tsismicacun me xicjin me, tsismicacun me xutacha rë me, tsismicacun me quihndi rë me, tsismicacun me nangui rë xitjë rë me, ngatsë naha; sacú rë me ngu cientu sa quisun tsëhë hane hacuaha sacú rë me cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Peru xuta xi matitjun quihndë ne, jemu cjín me xi cumachjiriin me hya, hane xuta xi hacuiin matitjun quihndë ne, hya ne cumachji rëhë me xi cumatitjun me. ");
INSERT INTO maqNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Sua Nina cahndë́ xi cuisehen xuta gubiernu xi sahmi me ne, sacuaha casahmi ngu me xi nai rë ngu ranchun. Xati nguitajñu quiji me cavanguise me mosu xi sahmi xá hiscan catsitjë me uva. ");
INSERT INTO maqNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hya xi casacu rë me ngujo cha, casahmi me compromisu hane cavejña chji rë cha xi ngu tujún xi hmí rë denario xi ngu nixtin. Hane hora hya casua me cha xá quiji cha nguijña xitjë. ");
INSERT INTO maqNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hya xi camá ne, sacuaha fane ñaja ne, cavuya nai jan ndetsin hane ngajan cavëë me cha xi hacjahi hane mahya rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sehe cachja me cojo cha cuitjin: “Hacuaha tangun xitjë naha, sehe sua nuju hacutjin satë nuju.” Hane quiji cha jan. ");
INSERT INTO maqNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hane jo ndiya nga ne, sacuaha nchisen hane sacuaha fane jyan ne, quiji nai jan ndetsin, tangun casahmi me tangun cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hane xi cavechu sacuaha fane hñu nguixun ne, quiji nga me ndetsin, ngajan casacu rë me yahnga cha xi mahya rë, sehe cachja me cojo cha cuitjin: “¿Mé má tu nechun ni nguehe cuahanixtin?” ");
INSERT INTO maqNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hane cafayangui cha cuitjin: “Tsëhë xi tsajin yo xi casua niji xa.” Sehe cachja me cuitjin: “Hacuaha tangun nihñu xa xitjë naha.” ");
INSERT INTO maqNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Hane hya xi ha camá nguixun, nai rë xitjë ne, cachja me cojo cha xi fahacuenda rë xitjë jan cuitjin: “Chjindayun rë mosu ne, tuhun rë me chji rë yëjë ni me, titjun ne tuhun chji rë cha xi cafehe ngascan hane cuatjin ne hisca xi cuijnetaha ne, sehe tuhun rë cha xi tjun cafehe.” ");
INSERT INTO maqNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hane xi cafehe cha xi casacu rë xa sacuaha fane hñu nguixun ne, cafahatsja cha chji ra xi ngu denario. ");
INSERT INTO maqNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hane xi camachaya rë cha xi tjun casacu rë xá ne, xi má rë cha ne, hitsë sa hnga cumá chji rë cha, peru hacuaha cafahatsja cha ngu denario ni. ");
INSERT INTO maqNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hane xi cafahatsja cha chji rë cha ne, cachjataha cha nai jan cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Cha vë ne, ngascan cafehe cha, ngu ni hora casahmi cha xa, hane tangun catuhun chji rë cha cojo niji. Ngayin ne, canihñi xa cuaha nixtin hacuaha cacaa niji ndavá.” ");
INSERT INTO maqNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Peru nai rë xitjë jan ne, cafayangui me tsëhë cha jan cuitjin: “Tai, tsajin me cjuachan, ¿há quixi, há quixiin xi cavisiajme xi chji nuju ne, ngu denario? ");
INSERT INTO maqNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chjuhun tujún xi satë nuju hane cuangun; ta ngahan ne, cachuya ná ngahan xi ngu chichihin suá rë cha hacuaha suá nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngahan xi tsahan ne, ngahan cuitexa. ¿O há tsajin ne, há machinitacun tsëhë xi casahme cuatjin?” ");
INSERT INTO maqNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Hacuaha chuva vëhë ni, xuta xi matitjun quihndë ne, cumachjiriin hya, hane xuta xi hacuiin matitjun me quihndë ne, cumachji rëhë me xi cumatitjun me. Jemu cjín má me xi cachjindaya rë xi canduva me, peru tsëhë yëjë me jan ne, chuva má me xi catuxijin rë. ");
INSERT INTO maqNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hya xi camá ne, hora xi jiya ndiya Jesús xi cjui me nandya Jerusalén, quijixin me cojo xuta ladu rë me xi tejó ni cachja me cojo me cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―‍Chutsujun ni, tivanguen Jerusalén, hane ngajan ne, ngahan xi Quihndi rë Xuta jain ne, cuma ngahan entregadu tsja nahmi xi matitjun cojo maestru tsëhë ley; hane cuichja me jyë́ naha ne, vechu chuva rë xi cueya ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sehe sahmi entregar me ngahan xutaxín, cuejnucëë ná xuta, cuëhënatya ná me, cuaja ná me ne, sehe cuetaha ná me xcun cru. Peru xi má jyan nixtin ne, cúya nga cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hya xi camá ne, naa rë quihndi rë Zebedeo quijitjengui na Jesús cojo cha quihndi rë na. Cavixcuhnchi na xcun Jesús tsëhë xi fehya na ngu favor. ");
INSERT INTO maqNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sehe cavinenguise Jesús na cuitjin: ―‍¿Mé xi meje rë xahasen nuju? Hane cuitjin cafayangui na: ―‍Tuhun cahndë́ xi cuiyujutaha cha quihndi naha ngu ngu ladu tjehen nuju, hya xi nihñu gubiernu nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ngajan cachja Jesús cojo cha cuitjin: ―‍Ngayun ne, hyuun mé xi chjayun. ¿Há scaa nuju cuatjun cjuañihi xi cuátju ngahan ni? Sehe cafayangui catsijo cha: ―‍Juun, scaa niji. ");
INSERT INTO maqNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ngajan xi cachja nga Jesús cojo cha cuitjin: ―‍Cjuañihi xi cuátju ngahan cuma ne, hatuxa hacuaha cojo ngayun cuatjun cuma. Peru xi cuinechuntuhun ngu ngu ladu tjehen naha ne, hacuiin ngahan cuichjá ta Nina cuichja me yo xuta xi sua rë me cahndë́ xi cuiyujutaha me. ");
INSERT INTO maqNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Xi cahndë yahnga xuta xi të jan cjua xi cachja Jesús ne, cavetsihin camacjan rë me cojo jo me xicjin me jan. ");
INSERT INTO maqNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ngajan xi cajindaya Jesús yëjë ni me, cachja cojo me cuitjin: ―‍Ngayun ne ha hyun ta yëjë ni xuta xi matitjun nguehe ngasunhndë ne, jemu sahmi yehe me yojo rë me sacuaha xi me vëhë xi nai rë xuta, hacuaha jercu meje cuitexa me. ");
INSERT INTO maqNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Peru hacuiin cojo ngayun cuatjin nihñu ta xi meje rë ne, ngu ngayun xi meje nihñi yehe yojo nuju ne; ninguijnu yojo nuju tisecun xingun. ");
INSERT INTO maqNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Hane ngu ngayun xi meje cumatitjun ngayun, nihñu xi cuma yun sacuaha ngu mosu rë xingun. ");
INSERT INTO maqNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ta cuanitjin ne, casahme ngahan Quihndi rë Xuta Jain, ta canduvá ne, peru hacuiin canduvá xi xuta cuisecoo ná me ta ngahan cuisécoo rë xuta, hacuaha tsingatehen xi tsiquehen ná xuta, cojo sa xi ngatsë rë vëhë cjín xuta cuaxëtje Nina me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hya xi cavetju me nandya Jericó ne, jemu xutacjín quijitjengui rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hane ngajan hiscan cavatju me siu jo cha rcá xi viyuju cha tjehen ndiya, hane xi canuhya rë xi Jesús tivatju me, cajindaya cha cachja cha cuitjin: ―‍¡Nai, ngayun tjë rë David! Catamayuma nuju ngayin. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hane xuta xi siu ne, cavisiajmicjan me cojo cha xi sejyu cha, peru cha vëhë ne, hitsë sa jercu cajindaya cha chja cha ta: ―‍¡Nai, ngayun tjë rë David! Catamayuma nuju ngayin. ");
INSERT INTO maqNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hya xi camá ne, ngajan casecunhñu Jesús, cajindaya me cha xi nduva cha. Sehe cavinenguise me cha cuitjin: ―‍¿Mé xi meje nuju xi sahme cojo nuju ni? ");
INSERT INTO maqNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ngajan xi cachja cha rcá jan ta: ―‍Tatá, xi meje niji ne, xi cuma tsejen niji. ");
INSERT INTO maqNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Hane Jesús ne, camayuma rë me cha; cavisanetsja me tuxcun cha. Hane ngutjen ni, camatsejen nga rë cha, sehe quiji cha cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hane hya xi ha jima tiña Jesús xi cjuehe me Jerusalén, cavechu me nandya Betfajé, ngajan ndetjún xi hmí rë Ndetjún Olivu ne, sehe catsingatju me jo xuta ladu rë me xi cjue tixa rë me, ");
INSERT INTO maqNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","hane cuitjin cachja me cojo me: ―‍Tángun nandya xi tsejen tacun vë. Hane ngutjen xi cjuhun tjehen rë ne, sacú nuju ngu burru xi tjihñu chu cojo quihndi rë chu. Hane chundecjun chu, nduvuncujun chu. ");
INSERT INTO maqNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Hane sá xi tjin yo xi cuichja cojo nuju tsëhë chu, sehe tinújun ta: “Maestru niji ne, meje rë me chu.” Hane sehe sua me cahndë́. ");
INSERT INTO maqNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Cuatjin camá cojo sa xi cuetjucaa jain cjua xi cachja profeta cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tinújun cojo xuta nangui Sion: “Chutsujun ne, nduva me xi matitjun tsujun hiscan nechun. Hacuiin xta me ne, nduva me quisun me chu burru, quisun me quihndi rë chu xi vaniji chaha.” ");
INSERT INTO maqNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sehe xuta ladu rë me jan, cavetju quiji me hane casahmi me hacutjin cachja Jesús, ");
INSERT INTO maqNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","canduvacojo me chu burru cojo quihndi rë chu hiscan tacun Jesús. Hane caviyujusun me tsjian rë me ngaxtun chu, sehe camiji Jesús burru jan. ");
INSERT INTO maqNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hane xi quiji Jesús ne, quisun me burru jan, hane xutacjín ne, táha cacandi me tsjian rë me ndiya hiscan cjui Jesús. Hane yahnga me ne, quiji cavotohosun me xca xcuen hane hacuaha cacandi me ndiya hacutjin cjui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hane yëjë ni me xi cjui tjun cojo yëjë me xi tjengui jan ne, cavetsihin jercu cajindaya me cachja me: ―‍¡Hosana! ¡Nacuechji rë Nina xi cafehe me xi cuitexa naja sacuaha cavitexa David hatsëë! ¡Jemu catsinchacun Nina me xi nduva vi tsëhë xi Nina catsingatju rë me! ¡Hisca ngahnga ne, cuechu cjua rë cjuandaja rë Nina! ");
INSERT INTO maqNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hya xi camá ne, xi cavisehen me nandya Jerusalén jercu jyë cjuandya camá hane cavinenguise xuta nandya cuitjin: ―‍¿Yo me vihi? ");
INSERT INTO maqNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ngajan cafayangui xutacjín jan cuitjin: ―‍Me vihi, hacui profeta Jesús, xuta Nasaret tsëhë distritu Galilea. ");
INSERT INTO maqNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hya xi camá ne, quiji me yungun xi matitjun. Hane hya xi cavisehen me ndatsen yungun jan; cavaxë me xuta xi sahmi me ndetsin. Hacuaha catsindefa me maxë xi xinchasun tujún xi tsindeya cha cojo tujún rë xuta ngu nangui cojo puestu rë cha xi viteña nisëtyava. ");
INSERT INTO maqNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sehe cachja me cojo cha jan cuitjin: ―‍Chja cjua rë Nina ta: “Ndya naha ne, tacunxa xi cjue xuta sahmi me oración rë me. Peru ngayun ne, tinihñuxun cojo sacuaha ngu cahndë́ xi matangun xuta xi sahmi cjuamaña.” ");
INSERT INTO maqNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hya xi ha cavatju vëhë ne, ngajan yungun xi matitjun ne, cavechutaha me xuta rcá cojo xuta rengun; hane casahmi me xi camandaja me. ");
INSERT INTO maqNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngajan xi cavëë nahmi xi matitjun cojo cha xi vicuya cjuachacun ne cjuarcun xi casahmi Jesús, hacuaha cahndë me xi jindaya nixti ta: “¡Hosana! ¡Nacuechji rë Nina xi cafehe me xi cuitexa naja sacuaha cavitexa David hatsëë!”; hane jemu cama xti rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Cachja me cojo Jesús cuitjin: ―‍¿Há nuhyun cjua xi tichja me? Ngajan xi cafayangui Jesús cuitjin: ―‍Juun, vihndë. Hane ngayun ne, ¿há cjëë chutahanyun cjua rë Nina xi chja tsëhë? Chja cjua ta: Hisca cjua rë nixti hisca cjua rë quihndinda ne canihñu xi cuetju xi sahmi hnga nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hya xi camá cachja me ne, cavetju Jesús tsëhë Jerusalén quiji me nandya Betania cavejña me nguixun. ");
INSERT INTO maqNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Xi camanchujun jan ne, xi cavuya nga Jesús Jerusalén ne, cama vojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hya xi camá ne, tjehen ndiya ne, cavëë me ngu yaxujun xi chine tú rë, peru xi cavechu me ngajan ne, ndastu me tú yaja rë, ta suva xca ni yaja rë. Ngajan xi cachja Jesús tsëhë: ―‍Quihndë tsajin nixtin xi cuaquí tú riji. Hane ngutjen ne, caxintsen ya jan. ");
INSERT INTO maqNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hya xi cavëë xuta ladu rë me xi cuatjin camá ne, cafaharcun me Jesús cachja me cuitjin: ―‍¿Hacutjin cumá xi jemu xati caxintsen yaxujun jan? ");
INSERT INTO maqNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ngajan cafayangui Jesús tsëhë me cuitjin: ―‍Cuichjá quixë jain cojo nuju ta sá xi macjain nuju Nina hane hacuiin jo cjuatacun nuju ne, cumá nihñu sacuaha casahme cojo yaxujun vi. Hacuaha hisca sá xi cuinújun cojo ndetjún vihi ta: “Tihinxin tsëhë nguehe. Tihin tisihin ngajñi ndachacun.” Hane cuatjin cumá. ");
INSERT INTO maqNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yëjë ni xcusun ne, tu mé ni xi chjahyun cojo Nina hane sá xi macjain nuju xi sacú nuju ne, cuetjucaa quixi. ");
INSERT INTO maqNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Hane xi vicuya Jesús ngajan ndatsen yungun xi matitjun ne, camatangun nahmi xi matitjun cojo xuta changá, hane cuitjin cavinenguise me Jesús: ―‍¿Yo cavitexa nuju xi nihñu xa vi? ¿Yo casuaxa nuju? ");
INSERT INTO maqNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hane xi cafayangui Jesús ne, cuitjin cachja me: ―‍Hacuaha cuinenguësë nuju ngu cjua, hane sá xi chjayunngun tsahan ne, sehe cuichjá cojo nuju yo cavitexa ná xi sahme xcusun vihi. ");
INSERT INTO maqNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Yo cavitexa rë Juan xi cuitenda me xuta? ¿Há Nina ne, o há tsajin ne, há xuta? ―‍Cuatjin cachja me. Sehe ngajan xi xuta xi cuacun jan ne, cavisiajmicjín me ngajñi rë me, cachja me cuitjin: ―‍Sá xi cuinújan xi Nina cavitexa me cha Juan vë ne, cjuinenguise naja me: “Sá cuatjin ne, ¿mé má camacjaain nuju cha?” ");
INSERT INTO maqNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Hane sá xi cuinújan xi xuta cavitexa rë cha ne, tsajin yo hvë mé sahmi xuta cojo naja ta, tsëhë xi yëjë ni xuta ne, ha macjain rë me xi cha vëhë ne, profeta cha. ");
INSERT INTO maqNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hane xi cafayangui xuta jan tsëhë Jesús ne chja me ta: ―‍Hyiin. Ngajan xi hacuaha Jesús ne, cachja me ta: ―‍Hacuaha cuichjaan cojo nuju yo cavitexa ná xi sahme xá vihi. ");
INSERT INTO maqNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","’Peru ¿mé nújun tsëhë cuentu vi? Ngu xihin ne, jo má cha quihndi rë me. Hya xi camá ne, cafehe cachja me cojo ngu cha cuitjin: “Tsan, tihin nihñi xá ngajan hiscan camatjë xca rë uva.” ");
INSERT INTO maqNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Peru cha quihndi jan ne, cafayangui cha cuitjin: “¡Jéya! ¡Mijí cjuë́!” Peru hya xi camá ne, cavindeya cjuatacun rë cha hane quiji cha xcun xá jan. ");
INSERT INTO maqNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sehe hacuanitjin cachja nahmi jan cojo quihndi xi má jo, hane cuitjin cafayangui cha jan cachja cha: “Tatá, ngahan ne, cjuë́.” Peru quijiin cha. ");
INSERT INTO maqNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hindë ne, ¿jarë cha xi casahmi chihin cha xcusun xi meje rë nahmi rë cha? Ngajan cafayangui me ta: ―‍Cha xi tjun cachja. Sehe cachja Jesús cojo me cuitjin: ―‍Cuichjá quixë cojo nuju ta xuta xi cojo cjuamaña faha tujúnsa cojo chjuun xi viteña na yojo ran hitsë sa tjun cuisehen me gubiernu xi sahmi Nina xi cuma nuju ngayun, ");
INSERT INTO maqNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ta cafehe Juan cavicuya me ngayun hacutjin nihñu xcun Nina hane camacjaain nuju cjua rë me. Peru xuta xi faha tujúnsa cojo chjuun xi viteña yojo rë na, me vëhë camacjain rë me. Ngayun ne, handasa cahyun yëjë xcusun vëhë ne, canindeyuun cjuatacun nuju; camacjaain nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Nuhyun sa ngu ejemplu xi cuitjin fi: Ngu nai rë ngu ranchun matsejen ne, catsitjë me xcun nangui rë me xca rë uva. Hacuaha casahmi me hnchua xondyojo tahndee rë xitjë jan, hane ngajan ni ne, cafahnguiya me ngu ndyojotë hiscan cuaxë nandá rë uva jan. Hacuaha casahmi me ngu cahndë́ hiscan xi cavesun me ngu nachan ngahnga xi sesun xuta xi sahmi cuidadu xitjë rë me. Sehe casua me ngujo cha sahmixa xi cjuahacuenda cha. Sehe cjuaha tsë tsë me cojo cha. Hane hya xi camá ne, cavetju me quiji me ngu nangui xin. ");
INSERT INTO maqNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Xi cavechú nixtin rë tútjë jan matsejen ne, sehe catsingatju me mosu rë me xi quiji cachja cha cojo cha xi fahacuenda xitjë jan xi sua cha hitsë tutjë xi satë rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Peru cha xi sahmixa jan ne, cafaha cha mosu jan tu cavaja cha ngu mosu, catsiquehen cha ngu nga, hane cavetaha cha ndyojo xcun ngu nga. ");
INSERT INTO maqNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sehe catsingatju nga me mosu hacjahi xi hitsë sa cjín má cha tsëhë mosu xi tjun catsingatju me, peru cha xi sahmixa jan ne, ha chuva vëhë ni casahmi cha cojo yëjë ni. ");
INSERT INTO maqNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Hya xi camá ne, hisca catsingatju me suva quihndi rë me ta catsingatahacacun me cuitjin: “Tuxa cjuaharcun rë cha, xi quihndi naha.” ");
INSERT INTO maqNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Peru xi cavëë cha xi hatuxa quihndi rë me xi nduva ne, cavisiajmicjín cha cojo xicjin cha cuitjin: “Cha vihi ne, quihndi xi cjuahatsja xitjë vi cha. Niquen cha, cojo sa xi tsajan cuma nangui vi.” Cuatjin cavisiajmicjín cha. ");
INSERT INTO maqNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hya xi camá ne, cafaha cha cha quihndi jan quijicojo cha ndatsen cahndë́ jan, sehe catsiquehen cha cha. ");
INSERT INTO maqNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Hindë ne, xi má nuju ne, ¿mé sahmi nai rë xitjë jan cojo cha xi cuacun fahacuenda jan? ");
INSERT INTO maqNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ngajan cafayangui me tsëhë Jesús cuitjin: ―‍Cjue tsiquehen me cha xi tsehen cjuatacun rë jan, sehe sua me xitjë jan cjuahacuenda jingu sa cha sahmixa, cha xi sua cha xitjë xi satë rë me hya xi cuechú nixtin rë. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sehe cachja Jesús cojo me cuitjin: ―‍¿Há cachutayuun xujun rë Nina xi chja cuitjin?: Ndyojo xi catsitjungui chjinevexo ne, vëhë ndyojo xi cavéjña tjun tjun yuju rë xihndënaña. Cuatjin casahmi Nina xi cuma. Hane xi chutsejen ngayaan ne, jemu chjahanrcun xahasen naja. ");
INSERT INTO maqNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Vëhë xi cuichjá cojo nuju ta, chjahataha nuju cahndë́ xi cuisuhun gubiernu xi sahmi Nina, hane sua Nina xuta nanguixin cahndë́ jan, xuta xi sua me xi satë rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hane ndyojo jan ne, hya xi ngu xuta cjuinenguisun me xcun ndyojo vëhë matsejen ne, cuatëlanga rë me. Hane hya xi ndyojo vëhë cuinenguisun rë ngu xuta matsejen ne, ña cumá të me. ");
INSERT INTO maqNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hane xi cahndë nahmi xi matitjun cojo cha partidu fariseo ejemplu xi cachja Jesús tsëhë xuta vë ne, camachaya rë me xi condra rë me tichja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Vëhë xi cavangui me chuva rë hacutjin cuma xi cjuaha me Jesús peru camaji ta tsacjun me xuta, ta xi má rë xuta ne, ngu profeta má Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sehe quijinduju sa cachja Jesús ejemplu cojo rë me cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―‍Nina ne sahmi me cojo xuta xi cuisehen me gubiernu xi sahmi me sacuaha casahmi ngu xihin xi matitjun tsëhë ngu nangui hya xi casahmi me suhi xi cuixan quihndi rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hya xi casune hora rë, catsingatju me mosu hndixahan rë me quiji cha ndava xuta xi ha casua me camachaya rë xi nduva me cjuavixan, peru canduvaain me suhi. ");
INSERT INTO maqNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Sehe catsingatju me hndixahan xi hacjahi ne, cuitjin cavitexa me: “Tinoje cojo xuta xi nduva cuitjin: Chutsujun ni tai, ha tjin chihin comida, ha cahme chu xi tetjo ná tsëhë suhi vi, hane cachjan yojo. Tjin chihin yëjë ni: nduvun ne, xinëësuhi.” ");
INSERT INTO maqNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Peru casahmi cuendaain me cjua jan, hane quijixin me cafahacuenda me cjuacjintacun rë me. Ngu me quiji me xcun xitjë rë me, ngu nga me hiscan sahmi me negocio. ");
INSERT INTO maqNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hane yahnga nga me ne, cafaha me mosu hndixahan jan, choho casahmi me cojo cha hisca catsiquehen me cha. ");
INSERT INTO maqNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hya xi camá ne, me xi matitjun jan ne, cama cjan rë me. Catsingatju me sindadu rë me. Catsiquehen sindadu cha tsiquehen jan hane cavaca me nandya rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hya xi camá ne, cachja nga me cojo hndixahan rë me cuitjin: “Ha tjin ndaja xcusun rë cjuavixan. Peru xuta xi cuinduva ne, hacuiin ndaja cjuatacun rë me ndajintjin xi nduva me. ");
INSERT INTO maqNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Vëhë xi tihin hisca cruci ndiyatë ne, hane tu hacutjin cjín má xuta xi sacu ri, noje cojo yëjë ni me xi catinduva me catjinesuhi me.” ");
INSERT INTO maqNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ngajan xi quiji hndixahan jan hiscan ndiyatë rë nandya ne, hane yëjë ni xuta xi cavechutaha cha, sá xuta tsehen, o sá xuta ndaja ne, casahmi cha xi camatangun me quiji me suhi. Hane ña catsëxtin xuta ndava suhi. ");
INSERT INTO maqNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Hya xi tijima suhi ne, xi cavisehen me xi matitjun jan xi scutsejen me xuta xi cafehe me, cavutsejen me ngu cha xi yuma jyihi cojo tsjian rë. ");
INSERT INTO maqNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ngajan xi cachja me cojo cha cuitjin: “Tai, ¿hacutjin cama xi cavisuhun nguehe handasa jemu yuma jyihi tsjian nuju?” Peru cavejñajyuu cha vë cachjaain cha. ");
INSERT INTO maqNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sehe cachja me xi matitjun jan cojo hndixahan rë me cuitjin: “Tetuhunhñu tsja cha cojo ntsacu cha sehe naxun cha ndatsen hiscan jñu. Ngajan hiscan hincha xuta xi tijihnda me, hacuaha titsijanerii me nehñu me.” ");
INSERT INTO maqNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Cjín má me xi cachjinda rë xi nduva me, peru chuva má me xi tuxijijñi rë. ");
INSERT INTO maqNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hya xi camá ne, cha partidu fariseo ne, cavisiajmichihin cha casacuse rë cha ngu cjuacjintacun xi tsavi fi xi cjuayangui Jesús tsëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hya xi camá ne, catsingatju cha ngujo cha ladu jan, cojo cha ladu rë Herodes ne, cachja cha cojo Jesús cuitjin: ―‍Maestro, ngayin ne, hyin ta ngayun ne xuta ndaja ngayun. Vicuyun ndiya rë Nina cojo cjuaquixi. Ha tuxa cjuaquixindaja xi nújun, ha ndasa cojo xuta nchina visiajmu o sá cojo xuta yuma. ");
INSERT INTO maqNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Xi má nuju ne, mé xi ndaja cuinújan. Sacuaha ley rë Moisés ne, ¿há tsingatihi xi cuechjen tujúnsa naja cojo César, me xi matitjun, o há tsingatiin? ");
INSERT INTO maqNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Peru Jesús ne, tsëhë xi ha vacun rë me xi jemu choho xcusun rë cha ne, cachja me cojo cha cuitjin: ―‍¿Mé má cuatjin meje chjuhunchuvun ná? Xuta ndacha ngayun. ");
INSERT INTO maqNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ningacun ná ngu tujún jan scutsejen. Hane canduvacojo cha ngu tujún tyava. ");
INSERT INTO maqNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sehe cavinenguise me cha cuitjin: ―‍¿Yo xcusun rë hacuaha yo ñihi rë xi quitaha xcun tujún vë? ―‍Cuatjin cavinenguise Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hane cha xi cuacun vë ne, cuitjin cafayangui cha: ―‍Tsëhë César. Sehen ngajan xi Jesús ne, cuitjin cachja me cojo cha: ―‍Cuatjin ne, tuhun rë César xi tsëhë me, hane tuhun rë Nina xi tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hya xi cahndë cha cjua xi cachja Jesús ne, quijircun rë cha, sehe cavetju cha quiji cha tsëhë cahndë́ xi tacun me. ");
INSERT INTO maqNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sehe nixtin hya ne, cafehe tjengui Jesús cha partidu saduceo, cha xi vicuya cjuachacun xi chja xi xuta xi cahme ne, cuyaain nga me cjuahñu. Sehe cavinenguise cha Jesús cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―‍Maestro, Moisés ne cachja me ta: “Sá xi ngu xihin cueya, hane tsajin rë chjuun rë hisca ngu quihndi ne, hntsë nima vëhë ne, meje rë xi cjuaha rë chjuun cahan vëhë, cojo sa xi sacú rë na quihndi xi cuma sacuaha quihndi rë nima vëhë.” ");
INSERT INTO maqNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Quihndë ne, siu yatu cha cojo hntsë cha. Hane cha tjun ne, cafaha cha chjuun. Peru cahme cha, hane tsëhë xi tsajin quihndi rë cha, hntsë nima vë ne, cafaha cha chjuun jan. ");
INSERT INTO maqNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hane cuanitjin cavatju cha xi majo cojo cha xi majyan hisca chuva ngu chuva ngu cha hisca cojo cha xi má yatu. ");
INSERT INTO maqNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hane xi cajnetaha ne, sehe cahme chjuun jan. ");
INSERT INTO maqNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Quihndë ne, hya xi cuya yëjë nima cjuahñu ne, ¿jarë cha xi cuacún vë xi chjuun rë cha na xi cjuaquixi ta, tsëhë xi yëjë ni xi yatu cha ne, camá chjuun rë cha na? ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ngajan xi cachja Jesús cojo cha ta: ―‍Ngayun ne, cuaaintjin xi nújun, tsëhë xi vijnii rcun cjua xi chja xujun tsëhë Nina, hacuaha hyuun xi Nina ne, jemu hñu cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ta hya ne, cumaji cjuavixan hacuaha tsinguixaain xicjin me hya ta, sacuaha ángel xi siu ngahnga ne, cuatjin cuiyuju me. ");
INSERT INTO maqNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Quihndë xi tinújun tsëhë nima xi cuya cjuahñu ne, cuinenguësë nuju ne, ¿há cjëë chutayun cjua xi cachja Nina cojo nuju xcun xujun rë me tsëhë nima xutachanga nuju xi cuicun vi? ");
INSERT INTO maqNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ngahan xi Nina rë Abraham ngahan, Nina rë Isaac hacuaha cojo Nina rë Jacob.” Cuatjin cachja Nina. Peru ndaja hyun ta Nina ne, hacuiin Nina rë nima ta Nina rë xuta xi quicun me. ");
INSERT INTO maqNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hya xi cahndë xutacjín cjua jan, jercu tu quijircun rë me cjua xi catsicuya Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Peru cha partidu fariseo xi camachaya rë cha xi catsinguejyu Jesús cjua rë cha partidu saduceo ne, camatangun cha cojo xicjin cha, ");
INSERT INTO maqNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","hane sehe cavitexa cha ngu maestru rë ley xi cavinenguise cha me cjua vi cojo sa xi cuma cjuahachuva cha me. Cuitjin cachja maestru jan: ");
INSERT INTO maqNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―‍Maestro, tsëhë yëjë ni cjua xi cavitexa Nina naja xcun xujun ley ne, ¿jarë artículo xi hitsë sa matitjun? ");
INSERT INTO maqNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ngajan xi cafayangui Jesús cuitjin: ―‍“Meje rë xi nihmutacún Nina naja cojo nguñajatacún, cojo yëjë ni xahasen nuju, cojo yëjë ni ngahñu nuju, cojo yëjë ni cjuatacun nuju.” ");
INSERT INTO maqNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Cjua vë xi hitsë sa venguichji rë ne, hitsë sa matitjun xi cumá rë yëjë ni cjua rë ley. ");
INSERT INTO maqNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hane xi má jo ni: “Meje rë xi nihmutacún xingun sacuatjin hmutacún suvun yojo nuju.” ");
INSERT INTO maqNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tsëhë jo artículo vi ne vetjun sa yëjë cjua rë ley xi catsihindu Moisés cojo yëjë cjua xi catsihindu profeta. ―‍Cuatjin cachja Jesús cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hya xi ha camá tangun cha partidu fariseo ne, sehe cavinenguise Jesús cha cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―‍¿Mé nújun? Mesías o sa Cristu ne, ¿yo tjë rë má me? Cafayangui me ta: ―‍Tjë rë David má me. ");
INSERT INTO maqNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sehe cachja Jesús cuitjin: ―‍Sá xi quixi xi cuatjin ne, ¿hacutjin cavátju xi suva David ne, hya xi catsihindu me cjua xi cachja Hasen tsëhë Nina cojo rë me, “Nai” cachja me tsëhë Mesias? ta cuitjin catsihindu me: ");
INSERT INTO maqNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nina ne, cachja me cojo Nai naha cuitjin: “Tinechin nguehe ladu quixi naha, hisca hya xi yëjë ni xi sahmi ri condra ne, cuiyúju ngahan ngahma gubiernu riji.” ");
INSERT INTO maqNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Quihndë ne, sá xi suvá David chja me xi Nai rë me má me xi tsingatju Nina ne, ¿hacutjin má ne xi hacuaha tjë rë me má me vëhë? ");
INSERT INTO maqNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ngajan camá xi ndastu mé cafayangui cha, hacuaha hisca hya ne, tsacjun cha cjuinenguise sa cha me. ");
INSERT INTO maqNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hya xi camá ne, cachja Jesús cojo xutacjín hacuaha cojo xuta ladu rë me cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―‍Cha xi vicuya cjuachacun cojo cha partidu fariseo ne, casatë rë cha xá rë ley xi casatë rë Moisés hatsëë. ");
INSERT INTO maqNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Vëhë xi meje rë xi nuhyun cjua rë cha hacuaha nihñuchuhun yëjë ni xi vicuya cha; peru nihñuu sacuaha sahmi cha ta, ndaja chja cha jan peru hacjahi sahmi cha. ");
INSERT INTO maqNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Cjua xi vicuya cha jemu chja sahmi chihin xuta ta tangun sacuaha ngu chaha xi hai vaniji tyja rë me, peru suva ni cha ne, visecuaain cha me hisca hitsë. ");
INSERT INTO maqNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yëjë ni xi sahmi cha ne, sahmi cha ngatsë rë xi scuëë xuta cha, sahmihnga xuta cha. Vatjutaha cha chuva rë xujun xi chja ley xi setaha xten xuta, cojo tsjahya xi tsingaqui cha ntsacu tsjian rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hacuaha jemu chuya rë cha hya xi satë rë cha cahndë́ xi matitjun tsëhë ngu ndava suhi o tsëhë yungun. ");
INSERT INTO maqNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hacuaha hora xi fi tsujyihiya cha, jemu chuya rë cha xi cuatjin fi xuta chja me nina cojo cha ngajan ngajñi ndetsin, maestro chja xuta tsëhë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Peru ngayun ne, xi cuichjaain xuta tsujun Maestro ta ngu ni me xi Maestru nuju, hane ngajñi nuju ngayun ne, xingun má yun. ");
INSERT INTO maqNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hacuaha xuta ngasunhndë ne, canujuun tsëhë me xi Nahmi ta ngu ni me xi tacun me ngahnga ne, hacui Nahmi nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Cuanitjin ne, xi cuichjaain xuta tsujun Nai ta ngu ni me xi Nai nuju, me vëhë ne, Cristu. ");
INSERT INTO maqNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hane ngu ngayun xi meje cumatitjun ngayun ne, sahmi me sacuaha ngu mosu rë xicjin. ");
INSERT INTO maqNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tsëhë xi yëjë xuta xi sahmi yehe suvá me yojo rë me ne, cuechu nixtin xi Nina ne, tsinguijne me cjuatacun rë. Hane xuta xi tsinguijne suvá me cjuatacun rë me, hya ne, Nina ne, sahmi yehe rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Jemu chojyihi tsujun, ngayun cha xi vicuya cjuachacun cojo ngayun cha partidu fariseo. ¡Xuta ndacha yun!, ta vechjun tingotjo hisca visehen gubiernu xi sahmi Nina cojo sa xi cumaji cuisehen xuta. Tivisuun suvun, hacuaha tituun cahndë́ xi cuisehen xuta xi meje cuisehen me. ");
INSERT INTO maqNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Jemu chojyihi tsujun, ngayun cha xi vicuya cjuachacun cojo ngayun cha partidu fariseo. Jemu cjín tujún naxun yachjin cahan xi hisca ndava na tsajin. Hane hya xi nújunyumun ne jemu nduju hora nihñu, peru hacuiin nguñaja tacun nújun ta, vindachun ni. Vëhë xi hitsë sa jyë cuma castigu xi cumá nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Jemu chojyihi tsujun, ngayun cha xi vicuya cjuachacun cojo ngayun cha partidu fariseo. ¡Xuta ndacha yun! ta cuangun jingujyë ni ngasunhndë xi sacu ngu ni me xi cuisehen ladu nuju. Peru hya xi cavicuyun rë me, hitsë sa jyë castigu satë rë me xi cuma nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Jemu chojyihi tsujun, ¡xuta rcá yun xi meje ningacun ndiya! Nújun ta: “Sá xi tuhun cjua nuju hane cuinújun ta: Quixi, vëë yungun xi matitjun ne, sahmii ngujyë xi nihñu chihin cjua nuju, peru sá xi tuhun cjua nuju cojo oro xi jiya yungun xi matitjun ne, vëhë sahmi ngujyë xi tuhun xi canújun.” ");
INSERT INTO maqNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","’¡Ngarca ni ngayun! ¡Rcá yun! ¿Jarë xi meje rë xi chjaanrcun? ¿Há oro jan? o sá tsajin ne, ¿há yungun xi matitjun? ta, ngatsë rë yungun ne, vëhë xi camanchacun oro xi hincha cahntsua. ");
INSERT INTO maqNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hacuaha nújun ta: “Sá xi tuhun cjua nuju hane cuinújun xi ngasunscun yungun cuma testigu ne, sahmii ngujyë xi nihñu chihin cjua nuju, peru sá xi nújun ta cuatjo xcun ngasunscun jan cuma testigu ne, sehe sahmi ngujyë xi tuhun xi canújun.” ");
INSERT INTO maqNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Rcá yun! ¿Jarë xi meje rë xi chjaanrcun? ¿Há cuatjo jan? o sá tsajin ne, ¿há ngasunscun ta, tsëhë xi xcun vëhë ngajan camachacun cuatjo? ");
INSERT INTO maqNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Vëhë xi yo xi cuisiajmi hane cuichja me xi vëë ngasunscun ne, hacuaha tichja me xi vëë yëjë xi hinchasun xcun; ");
INSERT INTO maqNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","hacuaha yo xi cuisiajmi hane cuichja me xi vëë yungun xi matitjun ne, hacuaha tichja me xi vëë Nina xi tacun me ngajan. ");
INSERT INTO maqNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Hane yo xi cuisiajmi hane cuichja me xi vëë ngahnga ne, hacuaha tichja me xi vëë cahndë́ hiscan sahmi Nina gubiernu hane hacuaha xi vëë Nina xi sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Jemu chojyihi tsujun, ngayun cha xi vicuya cjuachacun cojo ngayun cha partidu fariseo. ¡Xuta ndacha yun! Ngayun ne, handasa tuhun diezmu nuju hisca cojo nchurca cojo ruda cojo yëjë sa xcusun ndeya ne, peru nihñucuenduun xi nihñuchihin artículo rë ley xi hitsë sa meje rë Nina xi nihñuchuhun sacuaha xi chja cuitjin: nihñu hacutjin xi cjuaquixi cojo xingun, sacuaha xi mayuma nuju xingun, hane sacuaha xi ngu ni má cjua nuju; hitsë sa ndaja sa canihñu yëjë xcusun vihi, hane canihñucuendun tsëhë xcusun xi canihñu. ");
INSERT INTO maqNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ngayun ne xuta rcá yun xi meje ningacun ndiya! Nihñu sacuaha sahmi ngu xuta xi tsicaha me vinu rë me, sehe cuetjuxin ngu chu xihi xi jiya ngajñi rë. Peru cuma tsinguijne jingu me ngu chu camellu. ");
INSERT INTO maqNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Jemu chojyihi tsujun, ngayun cha xi vicuya cjuachacun cojo ngayun cha partidu fariseo. ¡Jo xcun jo ntsuvun yun! Nihñu tyjahi táha ngaxtun ngu vasu cojo ngu tyuva, peru cahntsua ne, quitsë camahani rë cjuachëjë cojo cjuatacun xi nimuju yëjë ni xcusun. ");
INSERT INTO maqNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo rcá, titjun nihñu tyjahi cahntsua vasu cojo tyuva jan ta tsëhë xi cuatjin ne, hacuaha cuma tyjahi táha ngaxtun. ");
INSERT INTO maqNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Jemu chojyihi tsujun, ngayun cha xi vicuya cjuachacun cojo ngayun cha partidu fariseo. ¡Jemu ndacha yun! Ngayun ne, tangun cun cojo ngu tsjun xi cahvi rë xujñu, ta ndaja tsejen tsjun jan, peru cahntsua ne, quitsë rë cojo ninda rë nima cojo yëjë ni xi jehndu. ");
INSERT INTO maqNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Cuanitjin cun ngayun ta xi vutsejen xuta yun, tsejen sacuaha xuta ndaja tyjahi yun, peru cahntsua xahasen nuju ne, quitsë rë cojo cjuandacha cojo cjuatsehen. ");
INSERT INTO maqNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Jemu chojyihi tsujun, ngayun cha xi vicuya cjuachacun cojo ngayun cha partidu fariseo. Ngayun ne, nindujun tsjun ndacun tsëhë yëjë ni nima profeta, hacuaha nihñu ndacun tsjun tsëhë nima xi tsajin xi cun rë me xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hacuaha ngayun nújun ta: “Sá xi ngayin cavinechin nixtin hatsëë xi quicun xutachanga niji ne, cavisecuiin rë me xi tsiquehen me profeta xi cuacun vë ta cumacjain niji.” ");
INSERT INTO maqNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Quihndë ne, cahyun ta cojo cjua nuju vë, tuhun testigu condra nuju ta tsëhë xi ngayun ne hatuxa quihndi rë xutachanga nuju ngayun, hane me vëhë ne xi catsiquehen me profeta jan. ");
INSERT INTO maqNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Quihndë ngayun ne, ¡tangun cuéchun chuva rë cjuatsehen xi casahmi xutachanga nuju! ");
INSERT INTO maqNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Sacuaha cun yë chacun cuatjin cun ngayun, ¡quihndi rë yë yun! ¿Hacutjin cumá cuetjuntjun tsëhë castigu xi má hasen rë nima? ");
INSERT INTO maqNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Vëhë xi tsingátju sa nuju profeta cojo xuta xi quicun cjuatacun rë me cojo maestru ne, hane ngujo me ne, ngayun ne nicuhun me hacuaha cuetuhun me xcun cru. Ngujo nga me cujun rë me ngayun ngajan ndatsen yungun hacuaha tuhun rë me cjuañihi xi cuatju me sehe cuanga me ngu nandya ngu nandya. ");
INSERT INTO maqNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Cojo chuva vëhë ne, chanujujyun cjuaveya rë yëjë ni xuta xi tyjahi cjuatacun rë me xi cahme nguehe ngasunhndë. Chanujujyun cjuaveya rë xutachanga naja Abel cojo hisca cjuaveya rë xutachanga naja Zacarías quihndi rë Berequías, me xi canicuhun tiña ngasunscun hiscan ndatsen rë ndava Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cuichjá quixë cojo nuju ta tsëhë cjuaveya rë yëjë ni me vë chanujujyun ngayujun ni xi nechun quihndë. ");
INSERT INTO maqNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Ngayun xuta Jerusalén, ngayun xi cojo ndyojo nicuhun profeta xi tsingatju Nina ngajñi nuju! ¡Jemu choho má ná tsujun! ¡Mé hitsë ndiya xi meje scávëvaha nuju sacuaha javëvaha ngu nisë quihndi rë chu xi cuincha chu ngahma tyjunga rë chu! Peru ngayun ne, mijí nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chutsujun ni, Nina ne, catsismicacun me ngayun. ");
INSERT INTO maqNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cuichjá cojo nuju ta chuun camahani ná hisca hya xi cuechú nixtin xi cuinújun cuitjin: “¡Catsinchacun Nina me xi titsingatju me ngajñi naja!” ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hora xi tivetju Jesús tsëhë ndatsen yungun xi matitjun jan xi cjui xin me ne, ngajan cafehe xuta ladu rë me caveyanangui me hane catsingacun tsja me xi yungun jan ne, jemu ndajyihi. ");
INSERT INTO maqNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Hya xi camá ne, cuitjin cachja Jesús tsëhë yungun jan: ―‍Sacuaha yëjë ni ndihya vihi xi chutsujun tsëhë yungun ne, cuichjá cojo nuju ta cuechú nixtin xi hisca ngu ndyojo ndacun xi cuicun vi ne, tsajin xinchasuncoo xicjin ta cjuë yëjë cuixujne. ―‍Cuitjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Xi cafë cachja Jesús cuitjin ne, sehe cafehe me tiña rcu Ndetjún Olivu. Hane xi tacun suvá me, ngajan cafehe xuta ladu rë me, cavinenguise rë me cuitjin: ―‍¿Mé nújun? ¿Janihya cuetjucaa xcusun vëhë ni? ¿Hane hacutjin cuma sacú niji cjuaquixi xi ha tivechú nixtin xi nduvun ngayun tivechú hora xi cjuë nixtin rë ngasunhndë vi? ");
INSERT INTO maqNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ngajan xi cachja Jesús cojo rë me cuitjin: ―‍Nechun cuidadu, cojo sa xi hacuiin cuma ndacha ngayun ta, ");
INSERT INTO maqNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","tsëhë xi jemu cjín xuta cuetjucaa me xi cuichja me xi hacui me xi catsingatju Nina me. “Ngahan Cristu”, cuichja me. Hane cuatjin jemu cjín xuta cumacjain rë me cjuandacha rë me xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hacuaha hya xi cumachaya nuju cjua xi jemu yehe si tijima ngu nación o sá xi tjin cjuacjintacun xi jemu yehe si nduva ne, xicarcuun ta, hatuxa tjin xi titjun xcusun vëhë cuma. Peru hacuiin ha hya cuijnetaha nixtin vihi. ");
INSERT INTO maqNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hacuiin hya cuma ta, titjun ne, scaan xuta ngu nación cojo jingu sa nación. Hacuaha scaan xuta ngu nandya cojo ngu nga nandya. Hacuaha jemu cjín cahndë́ xi cuma cuechu jindya. Jemu cjín cahndë́ xi cjuani nangui. ");
INSERT INTO maqNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Peru xi cuatjin cumá yëjë ni xcusun vihi ne, sehe ntsacu tivetsihin cjuañihi xi cuatju xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Sehe cjuaha nuju xuta, cjuecojo nuju me xi cuatjun cjuañihi, xi tsiquehen me ngayun. Hacuaha jemu chohovëë xuta rë yëjë nangui yun ngatsë naha. ");
INSERT INTO maqNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hya xi cumá ne, cjín xuta tsismicacun me ladu naha, hane tsindeya me cjuatacun rë me. Sehe cojo cjua ni cuiteña xicjin me. ");
INSERT INTO maqNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hacuaha jemu cjín profeta xi vindacha me xuta cuetjucaa me. Hane cuatjin jemu cjín xuta cumacjain rë me cjuandacha rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hacuaha cjuatsehen ne, jemu cumayehetaha. Vëhë xi hya ne, cumachuva cjuahmutacun xi tjin rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Peru jarë ngayun xi scaa nuju cojo cjuacjintacun vëhë hisca xi cueyun ne, cuechun xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hane xuta ne, cjue me jingujyë ni ngasunhndë cuichja me cjuandajyihi vihi tsëhë gubiernu xi sahmi Nina, xi cumachaya rë xuta ngasunhndë. Hane hisca xi cuma chihin yëjë xcusun vëhë cuijnetaha nixtin vihi. ");
INSERT INTO maqNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Profeta Daniel ne, catsihindu me xcun xujun rë Nina tsëhë ngu xcusun tsehen xi tsinguetsun. Cuechún nixtin xi cuejña vëhë xu cahndë́ ximinchacun ―‍xuta xi vutaya cjua vi, catjahacuenda me cjua―‍. Hya xi cuatjin tsejen ne, ");
INSERT INTO maqNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","hya ne, xuta xi siu yëjë nandya tsëhë distritu Judea ne, catanga me hane catangahma me hiscan ndetjún. ");
INSERT INTO maqNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hacuaha jarë me xi hinchasun me rcu ndava me ne, mé tsëhë me xi siu cahntsua ndihya ne, mijí rë xi cjuejaha me. ");
INSERT INTO maqNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hacuaha ha chuva vëhë ni ne, xuta xi siutaha me nguijña ne, mijí rë xi cuya cjuejaha me tsjanga rë me ndava me. ");
INSERT INTO maqNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Jemu chojyihi tsëhë yëjë yachjin xi hinchahma quihndi rë cojo yëjë me xi tjin rë quihndi vaqui xi cojo me cuanga me nixtin hya! ");
INSERT INTO maqNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chjahyun rë Nina xi cjuañihi vëhë ne, hacuiin cuinduva nixtin chan hnchan o sá nixtin xi chjahájenda rë ta, ");
INSERT INTO maqNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","tsëhë xi cjuañihi jyë xi cuma ne, ngu cjuandya jyë xi cjëë camahani camá hisca ntsacu cavetsihin ngasunhndë. Hacuaha cuyaain cuma nga. ");
INSERT INTO maqNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jemu jyë cjuañihi jan, sá tsajin xi ha camachuva nixtin rë cjuañihi vëhë ne, hisca ngu xuta ne, cuetjintjiin me. Peru ngatsë rë cjuahmutacun xi tjin rë Nina cojo xuta xi cavaxijin me xi cuma ladu rë me ne, casahmichuva me nixtin vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Hya ne, sá xi cuichja yahnga me cojo nuju ta: “Cuajyihi Cristu nguehe”, o sá “Cuajyihi me ngajan.” Xi camacjaain nuju cjua jan ta, ");
INSERT INTO maqNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","tsëhë xi nixtin hya ne, jemu cjín xuta cuetjucaa me xi cuichja me cuindacha me ta Cristu me o sá profeta me. Hacuaha jemu sahmi me cjuarcun tsëhë xi meje cuindacha me xuta, hisca cojo xuta xi cavaxijin Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Quihndë ne cojo chaja sa xi cuechu nixtin vëhë ne, ngahan ne, ha cachjá cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Vëhë xi sá xi cuichja yahnga me cojo nuju ta: “Jemu xín tsëhë nandya tacun me”, hacuiin cuangun cojo me. O sá xi cuichja me ta: “Ndihya cahnchun tacun me”, camacjain nuju tsëhë me ta, ");
INSERT INTO maqNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","sacuaha sahmi hasen ndihichuhún xi ha tu ñahñu sahmi hasen rë jingujyë ni ngahnga, hiscan ladu vetjucaa tsuhi hiscan ladu vetje tsuhi ne, cuatjin ha tu ñahñu scutsejen ná yëjë ni xuta hya xi cuinduvá nga ngahan xi Quihndi rë Xuta jain. ");
INSERT INTO maqNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Cuatjin cuma nixtin hya sacuaha chja cjua ta hiscan jiña chu xi cahme ne, hacuaha ngajan matangun chu lote. ");
INSERT INTO maqNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ngutjen xi camá cavatju cjuañihi jan ne, cuinduva nixtin xi cjuë ndavá rë tsuhi. Hacuaha sá ne, ha quihndë suaain ndavá rë. Hane niñú ne, cuixu tsëhë ngahnga. Hisca ngahñu xi tjin ngahnga ne, cjuiniyaya. ");
INSERT INTO maqNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Hya xi camá ne, ngajan cuma tsejen seña tsëhë Quihndi rë Xuta Jain. Hane yëjë xuta xi siu ngasunhndë ne, jindayava me. Sehe hya scuëë xuta ngahan, xi Quihndi rë Xuta Jain ngahan, xi cuinduvá ngajñi rë yufí cojo jemu jyë ngahñu, hisca seti hisca vatë jyihi ngahan xi cuinduva. ");
INSERT INTO maqNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hya ne, tsingátju ángel naha, hane xi ndaja hñu cuinuhya rë xi fane ngu tyjo, sehe cjuejaha rë yëjë ni xuta naha xi cavaxejen, sahmitangun rë me tsëhë jinguyëjë ni ladu ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Quihndë ne, ningatuhuntacún tsëhë ejemplu xi sua yaxujún: Hya xi cuetsihin cumá xcuen tsja rë tsëhë xi ha jemu camatiña cuetsihin cuetjusehen ne, ngayun ne, ha hyun ta ha jemu camatiña chan tsin. ");
INSERT INTO maqNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hacuaha chuva vëhë ni ne, hya xi chun xi cuetsihin cumá yëjë xcusun xi cachjá cojo nuju vë ne, vëhë sua cumachaya nuju xi ha camatiña nixtin rë, hisca meje cumá. ");
INSERT INTO maqNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cuichjá cjuaquixi cojo nuju ta xuta xi siu nixtin vihi ne siu cuaha me hya xi cuetjucaa xcusun xi cachjá cojo nuju jan. ");
INSERT INTO maqNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ngahnga cojo nguehe ngasunhndë ne, hatuxa cjuë. Peru hisca ngu cjua naha ne, tsajin xi cuetjincaain. ");
INSERT INTO maqNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Sacuaha nixtin xi cuetjucaa cjuatacun vëhë ne, tsajin yo vëë rë. Hisca víin ángel xi siu ngahnga. Hisca hveen ngahan xi Quihndi rë Xuta Jain. Suva tutu ni Nina nahmi naja ne, me vëhë xi vëë me. ");
INSERT INTO maqNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Sacuaha casahmi xuta hya xi cavéjña xutachanga naja Noé ne, hacuanitjin ni sahmi xuta hya xi cuinduva Quihndi rë Xuta Jain. ");
INSERT INTO maqNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tsëhë xi hya ne, xi chaja sa casesuntë nandan ngasunhndë ne, jine tjihvi xuta, vixan me, tsinguixan me quihndi rë me. Cuatjin casahmi cuaha me hisca nixtin xi cavisehen Noé cahntsua barcu. ");
INSERT INTO maqNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hacuaha camachayiin rë me hisca xi casesuntë nandá quijicojo rë yëjë ni me jan. Hacuaha cuanitjin ni sahmi xuta hya xi cuinduvá ngahan xi Quihndi rë Xuta Jain ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jo cha ne, cuiyujutaha cha nguijña. Ngu cha ne, chjaháxin rë cha, hane cha xingu jan ne, cuejña cha. ");
INSERT INTO maqNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hacuaha jo nga yachjin ne, cuiyujutaha na coho na. Ngu na ne, chjaháxin rë na, hane na xingu jan ne, cuejña na. ");
INSERT INTO maqNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Vëhë xi nechun cuidadu. Hacuaha ningascun rë cjuatacun nuju ta ngayun ne, hyúun janihya cjuehe Nai nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hacuaha meje rë xi cumachaya nuju cjuatacun vihi: sá xi nai rë ngu ndihya ha machaya rë me hora xi cuinduva cha chëjë ndava me ne, suaain me cahndë́ xi scuxaha cha ndava me ne, sehe tsichëjë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hacuanitjin ni meje rë xi ngayujun ni ngayun ne, tuhun chjinu yojo nuju ta, tsëhë xi hora xi ningatuuntacún xi cjuëhë ngahan xi Quihndi rë Xuta jain ngahan ne, hora vëhë cjuëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Yo ngayun xi nihñu sacuaha sahmi ngu mosu hndixahan xi jemu quicun cacun xi sahmichihin yëjë ni hacutjin xi meje rë nai rë? Ngu hndixahan xi cjuahaxa xi cjuahacuenda rë yëjë sa hndixahan xi hora tjin sua xi sinë. ");
INSERT INTO maqNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jemu ndaja tsëhë ngu hndixahan jan xi tisahmi tutjin xi casuaxa rë nai rë. ");
INSERT INTO maqNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cuichjá cojo nuju cjuaquixi ta, nai rë hndixahan vëhë ne, suaxa me hndixahan vëhë xi hacuaha cjuahacuenda yëjë sa xcusun xi tjin rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Peru cuejñaa ne xi hndixahan vëhë ne, jemu choho xcusun rë me, tsingataha cacun cojo cjuatacun rë cuitjin: “Nai naha ne, tijima tafi sa xi cjuehe me.” Cuatjin tsingataha cacun. ");
INSERT INTO maqNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Sehe cuetsihin cuaja rë hndixahan xi yahnga jan, hacuaha cuatjutaha sinë cuihi hisca cuma chihi. ");
INSERT INTO maqNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Peru cuechú ngu nixtin xi tsajin tacunya hndixahan vëhë, ngu hora xi hisca hvíin ne, hya cjuehe nai rë. ");
INSERT INTO maqNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hane jemu jyë castigu sahmi me, sehe tsingatju me cuatju tangun cjuañihi cojo xuta xi jo xcun jo hntsua me. Ngajan ne, jemu squihnda me, hacuaha tsijanerii me nehñu me. ");
INSERT INTO maqNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Hya xi cuechú nixtin xi sahmi Nina gubiernu ne, cumá sacuaha cavatju të na nixti xi cafaha na ndihi tsëhë aceite, sehe quiji na xi cuejñaya na cha xi cuixan hora xi nduva cha. ");
INSERT INTO maqNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hya xi camá ne, hñu na jan ne, rcu taja na, hacuiin ndaja tsingatahacacun na. Peru hñu nga na jan ne, ndaja quicun na. ");
INSERT INTO maqNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Cavejña xi na rcu taja ne, hora xi cafaha na ndihi ne, cafaain na aceite xi cuya cuincha na tsëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Peru sacuaha na quicun jan ne, cafaha na ndihi ne, hacuaha xin cafaha na aceite. ");
INSERT INTO maqNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hane xi ma tafi xi nduva cha xi cuixan jan ne, cafaha rë na nijña ne, caviyujufë na. ");
INSERT INTO maqNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hya xi camá ne, sacuaha vasen nixten ne, canuhya rë xi jindaya xuta ta: “¡Nduva cha xi cuixan! Tangun tjengun cha xi cuanguncujun.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Xi cuatjin canuhya rë ne, cavisatjenhnga na nixti jan ne, cavëhëchjine na ndihi jan. ");
INSERT INTO maqNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hya xi camá ne, cachja na xi taja rcu cojo na quicun cuitjin: “Tuhun niji hitsë aceite nuju ta meje cjuë xi tsijin ne, coho ndihi niji.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Peru cafayangui na quicun cuitjin: “Cumaji tihin nuju ta sá cuatjin ne, cuechutaain tsëhë xi cuma meje nuju hacuaha tsëhë xi cuma meje niji. Hitsë sa ndaja ne, tangun hiscan xi xteña ne, hiscan ngajan chuhun.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Cuatjin camá xi hora xi quiji cavatsë na jan aceite ne, cafehe cha xi cuixan. Hane na xi siuya ne, cojo na cavisehen na ndava suhi. Sehe casechjahñu tingotjo ndihya. ");
INSERT INTO maqNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hya xi camá ne, cafehe na nixti xi quiji jan, hane cajindaya na tingotjo ndihya cuitjin: “Tatá, chuxuhun tingotjo tsijin.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Peru me vëhë jan ne, cafayangui me cuitjin: “Hveen jani nduvun ngayun.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Vëhë xi nechun cuidadu, hacuaha ningascun rë cjuatacun nuju ta ngayun ne, hyúun mé hora, hyúun mé nixtin xi cumá. ");
INSERT INTO maqNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Cuejña ne xi ngu xuta jan ne, quiji me ngu nangui cjin. Hane chaja sa xi cjue me ne, cajindaya me mosu hndixahan rë me casua me xi cuejñatsja cha xi tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hora xi casua me ne, ngu cha, casua me cha hñu mil tujún, hane ngu nga cha ne jo mil, hane ngu nga cha ne ngu mil. Cuatjin casua me cha hatucutjin tsejen xi chutaha cha. Hya xi camá ne, cavetju me quiji me. ");
INSERT INTO maqNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ngajan camá xi cha xi cafahatsja cha hñu mil tujún ne, casahmi cha ngu negocio. Hane ngajan cavesun rë cha hñu cuatjin sa. ");
INSERT INTO maqNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hacuaha cha xi cafahatsja cha jo mil tujún ne, cuanitjin ne cavesun rë cha jo cuatjin sa. ");
INSERT INTO maqNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Peru cha xi cafahatsja cha ngu mil tujún tsëhë nai rë cha ne, quiji cha cafahangui cha ngu ngojo nangui. Hane ngajan caveyanijihma cha tujún jan. ");
INSERT INTO maqNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Hya xi jercu cavatju nixtin xi quiji nai jan, cavuya cafehe me, cajindaya me cha xi sua cuenda cha tsëhë tujún jan. ");
INSERT INTO maqNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ngajan xi cha xi cafahatsja cha hñu mil tujún ne, yaha cha hñu mil sa. Hane cachja cha cojo me ta: “Tatá, hñu mil catuhun ná, hindë ne, cavesun ná hñu cuatjin sa.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ngajan xi nai rë hndixahan jan ne, cuitjin cachja me cojo: “Ndatjin ri. Ngaye ne, ngu hndixahan ndaja ngaye. Ngatsë rë xi jemu ndaja canihñi xa lihndi vëhë ne, hitsë sa quisun xa xi sua ri. Quihndë ne, tehe cjuasua xahasen riji cojo ná.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Sehe cafehe cha xi cafahatsja cha jo mil tujún. Hane cachja cha cuitjin: “Tatá, jo mil catuhun ná, hindë nguehe tacun tsujun jo cuatjin sa xi cavesun ná.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ngajan cachja nai jan cuitjin: “Ndatjin. Ngaye ne, ngu hndixahan ndaja ngaye. Ngatsë rë xi jemu ndaja canihñi xa lihndi vëhë ne, hitsë sa quisun xa xi sua ri. Quihndë ne, tehe cjuasua xahasen riji cojo ná.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Hacuaha cafehe cha xi cafahatsja cha ngu mil tujún. Hane cuitjin cachja cha: “Tatá, ha machaya ná xi ngayun ne, jemu hñu cjua nuju. Nangun xitjë handasa hacuiin ngayun xi canitjun. Ngayun ne, hacjahi sahmi xa ne, ngayun chjuhunntsun chji rë. ");
INSERT INTO maqNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Vëhë xi tsácjun ngahan. Hane cëjë caveyaneje hma tujún nuju. Cuajyihi tujún nuju nguehe.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ngajan xi nai rë cha ne, catsicuya me tsëhë cha cuitjin: “Ngaye ne, machjiriin ngaye. Ngaye ne, mosu hndixahan tsehen. Sá xi hye xi fanga handasa hacuiin ngahan xi catsitjë, hye xi hacjahi sahmi xa ne, peru ngahan fahántsa chji rë, ");
INSERT INTO maqNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","hitsë sa ndaja xi xcun bancun cahmi chani tujún xi casuá ri, cojo sa xi hya xi cjuëhë ne, cúya cjuahántsa tujún naha, peru cojo quihndi rë.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Sehe cachja me cojo me xi hinchacun jan cuitjin: “Chjuhuntuhun tujún xi yaha cha vë. Sehe tuhun rë cha xi tjin rë të mil tujún ta, ");
INSERT INTO maqNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","me xi ha tjin rë ne, sua sa Nina me, hisca vesun tsëhë. Hane me xi tsajin cjín jan ne, cjuahataha Nina hitsë xi tjin rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hacuaha chandunxin hndixahan xi machjiriin hiscan jñu ngajan candatsen. Ngajan ne, jemu squihnda me hacuaha tsijanerii me nehñu me.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Hya xi cuya Quihndi rë Xuta Jain cuinduva me cojo hasen ndajyihi tsëhë Nina hacuaha cojo ángel rë Nina cuinduva me, cuejña me cahndë́ hñu hiscan tsichuva me xuta. ");
INSERT INTO maqNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Hane ngajan xcun me ne, cumatangun xuta rë jinguyëjë ni ngasunhndë ne, sehe scuxijin me xuta sacuaha sahmi ngu cha xi faha cuenda rë chu hora xi vaxijin cha chu tsanga tsëhë ngajñi rë chu tentsun. ");
INSERT INTO maqNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Vinchaxin cha chu tsánga taha quixi rë cha, hane vinchaxin cha chu tentsun taha xcun. ");
INSERT INTO maqNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hya xi cumá ne, me xi matitjun jan, cuichja me cojo xuta taha quixi ta: “Nduvun nechun, ngayun xi catsinchacun Nina Nahmi naha. Ngayun xi satë nuju cuisuhun gubiernu xi Nina cavëhëchjini me tsujun hisca ntsacu cavetsihin ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cuatjin satë nuju ta tsëhë xi hya xi vojo ná, canicjun ná. Hya xi xinda ná, catuhun ná nandá; xutaxín ngahan, peru catuhun cahndë́ cavitejñajenda ndya nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tsajin ná tsjian, peru catuhun ná tsjian xi mameje; hmu ná hane cafuhun cachusuhunyun ná; tejñaya ndavaya hane cafuhun cachutsujun ná.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Sehe xuta tyjahi jan, tsicuya me cjua cuitjin: “Tatá, ¿janihya camachaya niji xi vojo nuju, hane canicjin nuju? ¿O sá xi xinda nuju, hane catihin nuju nandá? ");
INSERT INTO maqNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿O janihya cachutsijin nuju nujyuhunyun sacuaha xutaxín hane catihin cahndë́ nechunjendun ndya niji? ¿Janihya cahyin xi tsajin nuju tsjian hane catihin? ");
INSERT INTO maqNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hacuaha ¿janihya cahyin xi hmu nuju o nechunyun ndavaya xi canduvintjenguin nuju?” ");
INSERT INTO maqNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sehe cuichja me xi matitjun jan ta: “Cuichjá quixi cojo nuju ta hya xi canihñu cjuandaja vë xi cavisecun rë tuyoni xuta yuma ladu naha ne, cavisecun ná ngahan.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Hya xi camá ne, cachja me xi matitjun jan cojo xuta xi siu ladu scun rë me cuitjin: “Tangunxun ngayun xi cuatjun castigu rë Nina ne, tangun cuechún xcun ndihi xi catsindaja Nina xi cuisehen xitsehen xi matitjun cojo ángel rë. Ndihi jan ne, tsajin nixtin tsajin nixten xi coho. ");
INSERT INTO maqNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Cuatjin satë nuju ta tsëhë xi hya xi vojo ná, ha canicjuun ná; hya xi xinda ná, catuun ná nandá; xutaxín ngahan, peru catuun cahndë́ cavitejñajenda ndya nuju; ");
INSERT INTO maqNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tsajin ná tsjian, peru catuun ná tsjian xi mameje; hmu ná hane cafuun cachusuunyuun ná; tejñaya ndavaya hane cafuun chutsuun ná.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sehe cuinenguise me cuitjin: “Tatá, ¿janihya camachaya niji xi vojo nuju, o sá xi xinda nuju? ¿O janihya canutsijin nuju nujyuhunyun sacuaha xutaxín, o xi tsajin nuju tsjian? Hacuaha ¿janihya cahyin xi hmu nuju o nechunyun ndavaya? ¿Janihya cahyin vë xi cavisecuiin nuju?” ");
INSERT INTO maqNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Sehe cuichja me xi matitjun jan ta: “Cuichjá quixë cojo nuju ta tsëhë xi mijí nihñu cjuandaja vë xi cuisecun rë tuyoni xuta yuma ladu naha ne, mijí cuisecun ná ngahan.” ");
INSERT INTO maqNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sehe xuta jan ne, cuisehen me castigu xi nixtin nixten cumá, peru xuta xi tyjahi cjuatacun rë me ne, satë rë me cjuahñu xatsë xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hya xi camá ne, xi cajnetaha cachja Jesús yëjë cjua cuatjin ne, sehe cachja me cojo xuta ladu rë me cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―‍Ha hyun xi chaja sa jo nixtin xi cuechú suhi tsëhë pascua ne hane ngahan xi Quihndi rë Xuta Jain ngahan ne, hatuxa hya cumá ngahan entregadu tsja xuta xi cuetaha ná xcun cru. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nixtin hya ne, yëjë nahmi xi matitjun cojo xuta changá rë xuta tjë rë Israel ne, casahmi me ngu junta ngajan ndihya jyë rë Caifás, me xi vitexa yëjë nahmi xi matitjun. ");
INSERT INTO maqNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ngajan xi caviyuju me cjuatacun rë me hacutjin xi cuma cuindacha me Jesús cojo sa xi cuma cjuahahma me me xi tsiquehen me me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Peru cachja me ta: ―‍Ndatjin xi cuinechanyan ne cuatju suhi, sehe chjahanhma cha, sá tu cumacjan rë xutacjín, hane cumá ngu suë jyë. ");
INSERT INTO maqNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hya ne, Jesús ne, nandya Betania quitaha me. Tacun me ndava cha Simú, cha xi camandaja tsëhë chíhin vitaha xi casatë chuxin rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Hane ngajan camá xi cafehetjengui rë me ngu chjuun xi yaha na ngu frascu xi ndyojo camá, hincha ngu aceite ndaja xi jercu hnga chji rë. Hya xi camá ne, cavitejnu na aceite jan rcu Jesús hora xi tijinë me niñu. ");
INSERT INTO maqNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Peru xi cavutsejen cha ladu rë me xi cuatjin casahmi na jan ne, camacjan rë cha cachja cha cuitjin: ―‍¿Mé má tu mahya ni catsichaja na aceite vë? ");
INSERT INTO maqNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sá xi xteña ne ndaja sacú tujún rë. Hane tujún vëhë ne cuma cuisecoo rë xuta yuma. ―‍Cuatjin cachjataha cha na. ");
INSERT INTO maqNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Peru xi camachaya rë Jesús xi cuatjin chja cha ne, catsicuya me cjua cuitjin: ―‍¿Mé má cuatjin tivichuncjun tsëhë na ta jemu vengui chjí rë xcusun xi casahmi na cojo ná? ");
INSERT INTO maqNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Xuta yuma ne, yëjë nu yëjë nixtin ne, siu me cojo nuju. Peru ngahan ne, hacuiin yëjë nu yëjë nixtin tejña cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tsëhë xi xi cavitejnu ná na aceite jan ne cojo tjun ni ne cuëhëchjine na yojo naha xi seyaniji ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cuichjáquixë cojo nuju ta tuyani ni tsëhë jingujyë ni ngasunhndë xi cuichja xuta cjua tsëhë Nina ne, hacuaha cueyanangui me na vihi, cojo sa xi xuta xi yahnga ne, cumachaya rë me xcusun xi casahmi na cojo ná. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hya xi camá ne, ngu cha tsëhë ngajñi rë me xi tejó xi má ladu rë Jesús, cha xi hmí rë Judas Iscariote ne, quiji cavisiajmi cha cojo nahmi xi matitjun ");
INSERT INTO maqNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","cavinenguise cha me cuitjin: ―‍¿Há cjín tujún tuhun ná sá xi sahme entregadu nuju Jesús? Ngajan xi cavexqui me hane casua me cha cantë tujún tyava. ");
INSERT INTO maqNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hane ngajan cavejñaya cha ngu hora xi ndaja xi cuma sahmi cha entregadu Jesús cojo xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hya xi camá ne, nixtin xi tjun tjun tsëhë suhi xi chinë pan xi tsajin san rë, cafehe xuta ladu rë Jesús xi tejo jan, cachja cha cojo me cuitjin: ―‍¿Jani meje nuju xi cuihinchjini xi xine nguixun tsëhë suhi? ");
INSERT INTO maqNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sehe cafayangui Jesús cuitjin: ―‍Tangun nandya Jerusalén. Hane xi cuechú ndava ngu cha xi cuacun jan ne, tinújun cojo rë cha cuitjin: “Chja maestru naja cuitjin: Meje cuechú hora naha, hindë ne, ndya nuju ne sínë niñu tsëhë pascua cojo xuta ladu naha.” ");
INSERT INTO maqNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sehe quiji xuta ladu rë me ne, casahmi cha sacuaha xi cavitexa Jesús cha, hane cavëhëndaja cha xi sinënguixun me tsëhë pascua. ");
INSERT INTO maqNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hya xi quiji hora jan ne, tijinë me niñu cojo xuta ladu rë me xi tejó jan, ");
INSERT INTO maqNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","hane ngajñi hora xi tijinë me ne, cachja Jesús cuitjin: ―‍Cuichjá cojo nuju cjuaquixi ta ngu ngayun ne, nihñu ná entregadu. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ngajan xi jemu choho camá rë cha, cavetsihin cha cachja chuva ngu chuva ngu cha cojo rë me cuitjin: ―‍Nai, ¿há cumácacun xi ngahan sahme? ");
INSERT INTO maqNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hya xi camá ne, cafayangui Jesús cuitjin: ―‍Ngu cha xi ngu ni tyuva tsinguísehenquinda niñu naha cojo ne, cha vëhë xi sahmi ná entregadu. ");
INSERT INTO maqNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngahan xi Quihndi rë Xuta Jain ngahan ne, hatuxa tjin ná xi cueya sacuatjin ha camá camahindu xcun xujun tsahan, peru jemu chojyihi tsëhë cha xi sahmi ná entregadu. Vengui sa chji rë xi catsiin cha. ");
INSERT INTO maqNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sehe Judas, cha xi sahmi rë me entregadu cachja cha ta: ―‍Maestro, ¿há cumácacun xi ngahan sahme? Ngajan xi cafayangui Jesús tsëhë cha cuitjin: ―‍Juun, quixi. ");
INSERT INTO maqNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hora xi tijinë me comida ne, cafaha me ngu niñutsju hacuaha casua me nacuechji rë Nina ne, sehe cavotohocja me niñutsju jan, casua rë me xi tejó jan ne, sehe cachja me cuitjin: ―‍Chjuhun xinu. Vihi ne, yojo naha vi. ");
INSERT INTO maqNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Hya xi camá ne, cafaha me ngu vasu ne, sehe casua me nacuechji rë Nina, sehe cachja me cuitjin: ―‍Juhun vihi sehe siuhun ngajñi ngayujun ni, ");
INSERT INTO maqNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ta xan rë uva vihi ne, vihi jni naha xi cuetju ngatsë rë xuta sehe cuma chihin compromisu xi cuaxëtje rë xuta tsëhë jyë́ rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Hacuaha cuichjá cojo nuju ta quihndë cojo nixtin xi cjuiniji sa ne, ha quihndë cuyaan cuëhë xan rë uva. Cuëhë, peru hisca hya xi cuëhë nga cojo nuju ngajan hiscan sahmi Nina gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Xi cajnetaha cajinë me ne, casë me ngu tsëhë Nina. Sehe cavetju me quiji me Naxi Olivu. ");
INSERT INTO maqNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hane sehe ngajan cachja Jesús cojo xuta ladu rë me cuitjin: ―‍Ngayujun ni ngayun ne, nismutacun ná hacuaha cuma ndaya cjuatacun nuju quihndë nguixun vi ne, hane cuejñu ná suva ta cumá sacuaha camahindu xcun xujun rë Nina xi chja xi: “Nina ne, tsiquehen me cha xi sahmi cuidadu rë chu tsánga, hane chu tsánga vë ne cuitsojo chu.” ");
INSERT INTO maqNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Cuatjin cumá, peru hya xi cúya nga cjuahñu naha ne cjuë́ titjun tsujun hisca distritu Galilea. ");
INSERT INTO maqNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedru ne, cafayangui cha cuitjin: ―‍Ha ndasa ngayëjë cha xi cuicun vi cuejña suva cha ngayun, hatuxa tsajin nixtin xi cojo ngahan sahme cuatjin. ");
INSERT INTO maqNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hya xi camá ne, cuitjin cachja Jesús cojo cha: ―‍Cuichjáquixë cojo ri ta tajñu ni xi chaja squihnda xahnda ne, ha jyan ndiya cuinoje xi hyiin yo ngahan. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Cachja Pedru cuitjin: ―‍Ha ndasa hisca cueya cojo nuju ne, peru cuichjaan xi hveen yo ngayun. Hacuaha cuanitjin ni cachja cha xi yahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sehe quiji Jesús cojo cha xi tejó jan ne, cafehe me ngu cahndë́ xi hmí rë Getsemaní. Ngajan cachja Jesús cuitjin: ―‍Nechun ni nguehe. Cjuë́ nguvan hitsë ni cuisiajme cojo Nina. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hya xi camá ne, cavaxë me Pedru cojo jo cha quihndi rë Zebedeo xi quiji cojo me cha. Hane xi cjui me ne, cavetsihin jemu camá va rë me, hacuaha jemu macjincacun me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sehe cachja me cojo cha cuitjin: ―‍Jercu choho camahani má rë xahasen naha, sacuaha xi vëhë ni tsiquehen ná. Nguehe nechuncun ngayun cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sehe ngajan xi Jesús ne, quiji me hitsë nguvan. Hane ngajan cafañatsacjan me, cafehya rë me Nina cuitjin: ―‍Ngayun Nahmi naha, sá tjin sa ngu chuva rë ne, catisatiin ná cjuañihi xi cuátju cuma vi. Peru catama sacuatjin xi meje nuju ngayun, hacuiin sacuatjin xi meje ná ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hya xi camá ne, cavuya cafehe me hiscan siu jyan xuta ladu rë me xi quijicojo me jan ne, casacutsja me xi siufë me. Ngajan xi cachja Jesús cojo Pedru cuitjin: ―‍Cahyun ni, ¿há camaji cavacun ngayun cojo ná hisca ngu hora ni? ");
INSERT INTO maqNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nechuncun ngayun, nihñu oración nuju, sátu chjaháchuva nuju cojo cjuatacun nuju. Xahasen nuju ne, ndaja meje rë xi nihñu, peru yojo nuju ne, chuvacacun. ");
INSERT INTO maqNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hya xi camá ne, camá jo ndiya xi quiji me nguvan cafehya me Nina cuitjin: ―‍Nahmi naha, sá xi cumaji cuatju chuva rë xi satiin ná cjuañihi ne, catama sacuatjin xi meje nuju ngayun. ");
INSERT INTO maqNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hya xi camá ne, cavuya nga cafehe me hiscan siu jyan xuta jan casacutsja me xi siufë me ta jemu hai nijña rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hya xi camá ne, camá jyan ndiya xi quiji me nguvan ne hacuaha cojo vëhë nga ne, cafehya me Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sehe cavuya nga me cafehe me hiscan siu xuta jan ne, cachja Jesús cuitjin: ―‍¿Há tsjuñufun cuhun? Chutsujun ne, ha cavechú hora xi ngahan Quihndi rë Xuta Jain ne, cjuaha ná xuta xi sahmi ná entregadu cojo xuta tsehen. ");
INSERT INTO maqNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tisatjunhngun, cuanguen chutsejen ta ha nduva cha xi sahmi ná entregadu. ");
INSERT INTO maqNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jinguyëjë rë xi tichja cuaha Jesús ne, cafehe Judas, cha xi cojo jiyajñi ngajñi rë cha xi tejó xi catsujyihiya cojo me. Hacuaha jemu cjín xuta tivisecoo rë cha, xuta xi cavitexa nahmi xi matitjun cojo xuta changá xi quijijaha me Jesús. Hane yaha me quicha, yaha me ya. ");
INSERT INTO maqNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Chaja sa xi cjuehe cha jan xi sahmi cha entregadu Jesús ne, cachja cha cojo xutacjín jan cuitjin: ―‍Cha xi cjuë́ cuitatsuha xi suá rë nina ne, cha vëhë xi hacui cha. ");
INSERT INTO maqNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Xi tu cavechu cha hiscan nduva Jesús ne, ngutjen quiji casahmitiña cha tsëhë me hacuaha casua cha me nina cachja cha cuitjin: ―‍Cuhndanu, maestro ―‍chja cha. Hane quiji cavitatsuha cha me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ngajan xi cachja Jesús cojo cha cuitjin: ―‍Tai, Nihñichihin xa vëhë xi candove. Hya xi camá ne, quiji xuta jan ne, cafaha me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngajan xi ngu cha xi secun cha cojo Jesús ne, cavaxë cha quichanduju rë cha, hane cavaja rë cha ngu cha mosu rë nahmi xi matitjun, hane cavatësun cha ngu ladu tyjavañuju. ");
INSERT INTO maqNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngajan xi cachja Jesús cojo cha cuitjin: ―‍Teyendeje quicha riji vë. Xuta xi tsicojo me quicha ne, hacuaha cojo quicha cueya me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Há hyuun ta sá xi cjuehya rë Nahmi naha ne, jemu cjín mil ángel tsingatju me cuisecoo ná? ");
INSERT INTO maqNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Peru sá xi cuatjin sahme ne, ¿hacutjin cumachihin cjua rë xujun rë Nina? ta cuitjin meje rë xi cumá. ");
INSERT INTO maqNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hya xi cajnetaha cachja Jesús cojo xuta ladu rë me ne, sehe cachja me cojo xutacjín cuitjin: ―‍¿Há nduvun chjuhun ná sacuaha ngu xuta xi chëjë me, xi cuatjin nduvun cojo ya cojo quicha vë ni? Xi cavitejñaya cojo nuju nchunchujun ni ndatsen yungun jan ne, cavetuhunntsuun ná cachjuun ná. ");
INSERT INTO maqNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Peru cuitjin tijima cojo sa xi cuetjucaa jain hacutjin camahindu xcun xujun rë Nina xi catsihindu profeta. ");
INSERT INTO maqNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hya xi camá ne, xi cafaha xuta jan Jesús ne, quijicojo me me ndava Caifás, nahmi xi matitjun tsëhë yëjë ni nahmi ta tsëhë xi ngajan ha camá tangun yëjë ni cha xi vicuya cjuachacun cojo yëjë ni xuta changá. ");
INSERT INTO maqNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedru ne, hacuaha tjengui cha cjui cha tu cjin tu cjin ni hacutjin cjui xuta jan cojo Jesús hisca xi cavisehen cha ndatsen rë ndava nahmi xi matitjun jan. Hane ngajan cavéjña cha cojo cha nísë rë yungun cojo sa xi cumachaya rë cha mé cumá. ");
INSERT INTO maqNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hane nahmi xi matitjun jan cojo yëjë sa xuta xi matitjun ne, cavangui me xuta ndacha xi tsinguixi jyë́ rë Jesús, cojo sa xi cuma tsiquehen me me. ");
INSERT INTO maqNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Peru tsajin mé jyë́ rë Jesús xi casacu rë me handasa jemu cjín má xuta ndacha xi cachja me. Hisca xi ha tisacuiiyiin rë me hacutjin cuma, sehe cafehe jo cha ndacha xi cachja cha ");
INSERT INTO maqNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","cuitjin: ―‍Cha vi cuitjin cachja cha ta: “Ngahan ne, cuma tsinguétsun yungun xi matitjun vi xi casahmi xuta tsëhë Nina, hane cahntsua xi jyan nixtin ne, sahme nga ngu.” ");
INSERT INTO maqNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ngajan xi nahmi xi matitjun tsëhë nahmi xi yahnga jan ne casecunvasen me, cavinenguise me Jesús cuitjin: ―‍¿Há chjayinnguiin hisca ngu cjua? ¿Mé noje tsëhë jyë́ xi vincha xuta jan? ");
INSERT INTO maqNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Hane Jesús ne, tu jyuu ni casecun me. Sehe cachja nahmi xi matitjun jan cojo Jesús cuitjin: ―‍Cuitexa ri ngatsë rë xi macjain ri tsëhë ngu ni Nina quicun xi hora xi cjuahataha ri ne cuinoje cjuaquixi. ¿Há ngaye xi Quihndi rë Nina? ¿Há ngaye xi Cristu? ");
INSERT INTO maqNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ngajan cafayangui Jesús tsëhë me ta: ―‍Sacuatjin nújun vë ne, cuatjin jain. Hacuaha cjuehe nixtin xi chutsujun ná xi tejña ladu quixi tsëhë ngahñu rë Nina. Hacuaha chutsujun ná xi cuinduvajne ngajñi rë yufí tsëhë ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hane ngajan xi nahmi xi matitjun tsëhë nahmi xi yahnga jan ne xi jemu camacjan rë me ne, hisca tsjian rë me cavicheya me. Hacuaha cuitjin cachja me: ―‍Tsixcuehyu cha Nina. Tsajin sa cjua testigu xi mameje. Ngayun ne, ha canuhyun hacutjin tsixcuehyu cha Nina. ");
INSERT INTO maqNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Mé nújun quihndë? Ngajan cafayangui me cuitjin: ―‍¡Meje rë xi cueya cha! ");
INSERT INTO maqNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hya xi camá ne, ngu jo me cavetsihin me cavëhënatya me Jesús hacuaha cavajaya me xcun. Yahnga nga me ne, cojo cahntsua tsja me cavaja me xcun Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Cachja me cuitjin: ―‍Tinoje, ngaye Cristu, ¿yo xi cavaja ri? ");
INSERT INTO maqNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jinguyëjë rë xi cuatjin tijima ne, Pedru ne, tacun me ndatsen ndihya. Hya xi camá ne canduva ngu na mosu hndixahan tsëhë nahmi jan, cafehe cachja na cojo Pedru cuitjin: ―‍Ngaye ne, ladu rë Jesús tsëhë distritu Galilea má ye. ");
INSERT INTO maqNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peru xcun yëjë me xi siu me ne, cafahahma me cachja me cuitjin: ―‍Hisca hveen mé xi noje. ");
INSERT INTO maqNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hya xi camá ne, sehe cavetju me quiji me casecun me hiscan tu cuiseen ni tsëhë ndatsen ndihya. Hane ngajan xi ngu nga na cachja na cojo xuta xi siu ta: ―‍Cha vihi ne, ladu rë Jesús nandya Nasarét má cha. ");
INSERT INTO maqNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hya xi camá ne, ngu ndiya nga ne cafahahma me cuitjin: ―‍Vëë Nina xi hveen xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hya xi cavatju ngu hora ne, sehe camatiña xuta xi hinchacun cojo Pedru jan cachja me cuitjin: ―‍Ha cjuaquixindaja ta ngaye ne, cojo ngaye nechin cojo cha xi cuajyihi vë, ta tsëhë xi cjua riji tsingacun xi xuta distritu vë ngaye. ");
INSERT INTO maqNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ngajan xi cavetsihin nga Pedru cafahahma me cjuaquixi hisca cachja me xi catinduva ngu cjuacjintacun xi cuatju me sá xi tichja me ngu ndesu. Cuitjin cachja me: ―‍Vëë Nina jain xi hveen yo me xi nújun vë. Hane hora vëhë ne, cajihnda ngu xahnda. ");
INSERT INTO maqNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Hane Pedru ne, catsinguitsjen me cjua xi cachja Jesús cojo rë me xi cachja me cuitjin: “Chaja sa xi squihnda ngu xahnda ne, hacuaha camá jyan ndiya nújun xi hyúun yo ngahan.” Hane xi cavetju me candatsen ne, cajihnda susu me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hya xi camá nchujun ni ne, yëjë ni nahmi xi matitjun cojo yëjë xuta changá ne camatangun nga me xi sacuya rë me xcusun hacutjin cuma tsiquehen me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sehe catsihñu me Jesús ne, quijicani me xcun gobernador xi hmí rë Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hya xi camá ne, Judas ne, cha xi casahmi rë me entregadu, camachaya rë cha xi cueya Jesús. Ngajan xi choho camá rë cha hane catsindeya cha cjuatacun rë cha. Quiji cha catsicuya cha catë tujún tyava jan cojo nahmi xi matitjun cojo xuta changá. ");
INSERT INTO maqNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Cuitjin cachja cha: ―‍Jemu tjin jyë́ naha ta tsëhë xi casahme entregadu ngu me xi tsajin xi cun rë. Peru cafayangui me cuitjin: ―‍¡Mé tsijin vë! Cjuacjintacun vë hatuxa tsiji sove. ");
INSERT INTO maqNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hya xi camá ne, ngajan yungun xi matitjun ne, cacandi cha tujún tyava jan sehe cavatju cha quiji cha hiscan ngu cahndë́ xi cavityjangui cha yojo rë cha hisca xi camá cahme cha. ");
INSERT INTO maqNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nahmi xi matitjun jan cafaha me tujún tyava jan peru cachja me cuitjin: ―‍Cumaji cuinchan tujún vi cahntsua caxa tujún rë yungun ta tsëhë xi tujún vi ne, cavengui chji rë jni rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hya xi camá ne, cachuya rë me xi cuatsë me ngu xáhva xi chja xuta Nangui rë Cha Chjinetiji. Xáhva jan ne cumachji rëhë xi xinchaniji xutaxín xi cueya me nangui vë. ");
INSERT INTO maqNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ngatsë rë xi cuatjin casacu xahva jan ne, hisca nixtin quihndë ne cahndë́ vëhë ne yaha ñihi xi Cahndë́ Tsëhë Jni. ");
INSERT INTO maqNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Xi cuatjin camá ne, camachihin cjua xi catsihindu profeta Jeremías xi cuitjin chja: “Cafaha me catë tujún tyava, xi cavejña chji rë cha xi cafehya xuta nangui Israel, ");
INSERT INTO maqNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","sehe casua me tujún jan xi cjuaha me nangui rë cha chjinetiji. Cuatjin casahmi me sacuaha cavitexa Nina.” ");
INSERT INTO maqNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hya xi camá ne, Jesús ne secun me xcun gobernador. Ngajan cavinenguise me Jesús cuitjin: ―‍¿Há ngaye xu matitjun ngaye tsëhë xuta tjë rë Israel? ―‍Cuatjin cavinenguise me. Hane Jesús ne, cuitjin cafayangui me: ―‍Cuatjin sacuatjin nújun vë. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Peru hora xi nahmi xi matitjun cojo xuta changá jan cavincha jyë́ me Jesús ne, ndastu mé cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ngajan xi cachja Pilatu cojo me cuitjin: ―‍¿Há nuhyiin cjua xi chja me? Jercu cjín jyë́ riji cavincha me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Peru Jesús ne ha quihndë cafayanguiin me hisca ngu cjua. Hane Pilatu ne, jemu quijircun camahani rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tjin ngu xcusun xi nu nu ni, hya xi cumá nixtin rë suhi jan ne, tsismi gobernador ngu presu xi xuta vaxijin me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nixtin hya ne, jiya ngu presu xi jemu tjin cjua tsëhë, Barrabás hmí rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ngajan xi camá xi hya xi camatangun xutacjín ne, ngajan cavinenguise Pilatu xuta cuitjin: ―‍¿Jarë cha xi meje nuju xi tsisme? ¿Há Barrabás ne? ¿Há Jesús xi Mesías xu? ");
INSERT INTO maqNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Cuatjin cachja me cojo xuta ta tsëhë xi ha vëë me xi ngatsë ni rë cjuaxin sahmi nahmi xi matitjun jan cojo Jesús, vëhë xi casahmi me entregadu xi meje rë me xi cueya. ");
INSERT INTO maqNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hora xi tijimá vë, tacun Pilatu xcun silla hiscan vejña me hora xi vitexa me, ngajan xi chjuun rë me ne, catsingatju na cjua xi cuitjin chja: “Caninguisuunjñuu cjuacjintacun tsëhë cha vë xi tyjahi cjuatacun rë cha, ta nguchjin ne ngajñi nijña naha jemu cjín xcusun xi chocun camá ná chini ngatsë rë cha.” Cuatjin fi cjua xi catsingatju na. ");
INSERT INTO maqNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hya xi camá ne, nahmi xi matitjun cojo xuta changá jan jemu cachja me cojo sa xi cama cuinchahaxi me xuta xi cjuehya xuta Pilatu jan xi tsismi me Barrabás ne, tsiquehen me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ngajan cachja nga gobernador cuitjin: ―‍Tsëhë jo cha vë ne, ¿jarë cha xi meje nuju xi tsisme? Ngajan cafayangui xutacjín jan cuitjin: ―‍Nismu Barrabás. ");
INSERT INTO maqNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sehe cachja nga Pilatu cuitjin: ―‍Sá cuatjin ne, ¿mé xi sahme cojo Jesús xi Cristu xu? Ngajan xi cafayangui yëjë xutacjín jan cuitjin: ―‍¡Tetuhun cha xcun cru! ");
INSERT INTO maqNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ngajan xi cachja Pilatu cojo rë me ta: ―‍Peru ¿mé xi rcu jyë́ casahmi cha? Peru xutacjín ne hitsë sa hñu cajindaya me cachja me cuitjin: ―‍¡Tetuhun cha xcun cru! ");
INSERT INTO maqNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hya xi camachaya rë Pilatu xi sahmi cuendaain xuta xi chja me ta tu hitsë sa tijima ngu suë jyë ne, cafehya me nandá sehe cavane me tsja me xcun xutacjín jan. Sehe cachja me cuitjin: ―‍Quitjeen jyë́ tsëhë cjuaveya rë cha vihi ta, tsajin jyë́ rë cha. Vëhë ne, ha chaha nuju vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hya xi camá ne, yëjë xutacjin jan ne, ngu tangun ni cafayangui me cuitjin: ―‍Tsëhë cjuaveya rë cha vëhë ne, chanijijyin cojo quihndi niji. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hya xi camá ne, catsismi me Barrabás, peru casahmi me xi Jesús ne casehen rë me sehe casua Pilatu me xi cjue cueya me xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hya xi camá ne cha sindadu xi vitexa gobernador ne, quiji cojo cha Jesús taha cahntsua ndava gobernador jan. Hane sehe casahmitangun sa cha yëjë sindadu cjín. ");
INSERT INTO maqNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hya xi camá ne, cavaxë cha tsjian rë Jesús, hane sehe catsicaja cha me ngu tsjian hani. ");
INSERT INTO maqNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Hacuaha catsihya cha ngu corona nahyá sehe cavesun cha rcu Jesús hane cavisengui cha ngu bastón tsja me. Hya xi camá ne, cavixcuhnchi cha xcun me, catsixcuehyu cha me, cuitjin cachja cha: ―‍¡Viva! Me xi matitjun tsëhë xuta tjë rë Israel. ");
INSERT INTO maqNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hacuaha cavëhënatya cha me, hacuaha cafaha cha bastón jan xi yaha tsja me hane cavaja cha rcu me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hya xi camá xi cuatjin catsixcuehyu cha me ne, cafahaxin cha tsjian hani jan, catsicaja nga cha me tsjian rë me. Hya xi camá ne, sehe quijicojo cha me xi cuetaha cha me xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hya xi cavetjun cjuicojo sindadu Jesús ne, cavechutaha cha ngu me xi hmí rë Simón tsëhë nandya Cirene. Sehe sindadu jan ne, casahmi cha ngujyë xi cuaniji me cru jan. ");
INSERT INTO maqNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hane xi cafehe cha cojo Jesús hiscan xi hmí rë Gólgota, cjua xi meje cuichja Naxi Nínda Rcuun. ");
INSERT INTO maqNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hya xi camá ne, casua cha me xan rë uva xi tecjan rë nandá rë tyjungunsa xi cuihi Jesús. Peru xi cavutaha me hitsë ne, cahviin me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ngajan xi sindadu jan ne, xi cavatju casetaha me xcun cru ne, sehe cafaha cha tsjian rë me hane cavaxë cha suerte tsëhë ne, jarë cha xi satë rë cha jima ngu tsjian. ");
INSERT INTO maqNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sehe ngajan ne cavejñataha cha cavutsejensun cha Jesús xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hacuaha camahindu ngujo cjua xi casetaha xcun cru ngatihin rcu Jesús sacuaha xcusun rë me xi setaha xujun jyë́ rë xuta, hane cuitjin chja cjua jan: “Jesús, me xi Matitjun Tsëhë Xuta Israel.” ");
INSERT INTO maqNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hacuaha cavityangui cha ngu chëjë ngu ngu ladu tjehen rë me, jima ngu cojo cru rë. ");
INSERT INTO maqNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hya xi camá ne, xuta xi cavatju jan ne, catsixcuehyu me Jesús ne, catsitjiya rcu me, hacuaha cuitjin cachja me: ");
INSERT INTO maqNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","―‍Ngaye xi ha canoje xi cuma ninguetsin yungun xi matitjun, hane cahntsua xi jyan nixtin ne; cama nga canindeje ngu. Quihndë ne, sá cuatjin cuma nihñi ne, naxetje sove yojo riji. Sá xi Quihndi Jain rë Nina ngaye, titujni tsëhë cru vë. ");
INSERT INTO maqNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ha chuva vëhë ni ne, nahmi xi matitjun ne cojo cha vicuya cjuachacun rë ley cojo xuta changá ne cachja me cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―‍Cavaxëtje xu cha xuta, peru quihndë ne, cumaji cuaxëtje suva cha yojo rë cha. Sá xi hacui jain cha xi Matitjun Tsëhë Xuta Israel ne, catitujne cha tsëhë cru chutsejen, cojo sa xi cumacjain naja tsëhë cha. ");
INSERT INTO maqNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Macjain xu rë cha tsëhë Nina, quihndë ne cataxëtje Nina cha sá xi Nina meje rë me cha; ta cachja cha ta: “Quihndi rë Nina, ngahan.” ");
INSERT INTO maqNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hacuaha cha chëjë xi cojo caxtyangui taha cru jan ne, cojo cha choho cachja cha tsëhë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hane hora vëhë ne, camajñu jingujyë ni. Cavetsihin xi camanchisen ne, quiji cani rë hisca fane jyan. ");
INSERT INTO maqNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hya xi camá ne, jercu hñu camahani cachja Jesús cuitjin: ―‍Elí, Elí, ¿lama sabactani? -cjua vëhë meje cuichja ta: Ngayun Nina naha, mé má canismutacun ná. ");
INSERT INTO maqNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hane ngujo xuta xi hinchacun jan ne, xi cajnii rcu me hne jan hane cachja me cuitjin: ―‍Tijindaya me profeta Elías. ");
INSERT INTO maqNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hya xi camá ne, ngutjen ni, cavanga ngu me, quiji catsicahnchi me ngu tsjian hinda cojo xan rë uva xi ha sán, sehe cavetaha me rcu ngu ya nduju, sehe cavetaha me hntsua Jesús xi cuihingui me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngajan xi yahnga xuta ne, cachja me cuitjin: ―‍Caveni tuhun. Cuinechanyan hitsë ne, ¿há cuinduva jain Elías cuaxëtje me cha? ");
INSERT INTO maqNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hane Jesús ne, hora vëhë ne, jercu cajindaya nga me hane cahme me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hacuaha hora vëhë ni ne, tsjian nduju xi tyjangui cahntsua yungun xi matitjun jan ne, hisca rcu hisca ntsacu canduva catiyavasen. Hacuaha cafani nangui. Hacuaha cavacjan ndyojo. ");
INSERT INTO maqNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Hacuaha hora vëhë ni ne, catuxaha tsjun rë nima, hane jemu cjín xuta xi tyjahi cjuatacun rë me xcun Nina ne, cavuya cjuahñu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Cavetjun xuta jan tsëhë tsjun. Hane hya xi ha cavuya cjuahñu rë Jesús ne, sehe cavisehen me nandya Jerusalén hane ngajan ne, cjín xuta ne, cavëë rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hora xi cahme Jesús ne, cha capitán tsëhë cha sindadu cojo yahnga sindadu xi hinchacun me ngajan vutsejensun me Jesús ne, camachaya rë cha xi fani nangui cojo cjin xcusun sa xi cavatju camá. Hane jercu quijircun camaha ni rë cha. Hacuaha cachja cha cuitjin: ―‍Hacui jain me vihi xi Quihndi Jain rë Nina, me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hacuaha ngajan ne, tsëhë cjin ne hinchacun cuaha cjín yachjin xi tivutsejen me. Yachjin jan ne quijitjengui me Jesús xi cuisecoo me Jesús, sahmi cuenda me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ngajñi yachjin jan ne, hinchajñi na xi cuicun vi: na María na Mágdala, hacuaha na María naa rë Jacobo cojo José, hacuaha cojo naa rë cha quihndi rë Zebedeo. ");
INSERT INTO maqNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hya xi cajne hora ne, ngu cha nchina xi hmí rë José, ngu xuta Arimatea cha xi hacuaha xuta ladu rë Jesús cha. ");
INSERT INTO maqNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Cha vëhë quiji cha xcun Pilatu, cafehya cha cahndë́ sá xi cuma cjuahaxin cha nima Jesús. Hane Pilatu ne, casua me cha cahndë́. ");
INSERT INTO maqNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ngajan xi cafahatsja cha nima jan ne, sehe catsitjingui rë cha tsjian tyjahi, sacuaha xcusun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sehe caveya cha nima cahntsua ngu tsjun xatsë rë suva cha xi ha casahmi cha xi camá catjuhngui rë taha naxi. Sehe catsindefajne cha ngu ndyojo jyë xi cuechja rë tingotjo rë tsjun jan. Hya xi camá casahmi cha ne, quiji cha cojo xuta ra. ");
INSERT INTO maqNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Peru na María na Mágdala cojo na María xi hacjahi ne, caviyujutaha na xcun tsjun. ");
INSERT INTO maqNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Hya xi cumá nchujun ni ne, hya nixtin xi cjuahajenda rë me ne, hya camatangun nahmi xi matitjun cojo cha partidu fariseo sehe cachja cha cojo Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Cuitjin cachja cha tsëhë Jesús: ―‍Nai, ngayin ne vitsjen niji xi hya xi chaja sa cueya cha cachja cha ndacha vë cuitjin: “Cahntsua jyan nixtin ne, cuya cjuahñu naha.” ");
INSERT INTO maqNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ngatsë rë vëhë ne, meje rë xi nihñu cuendun xi sehñu ndaja tsjun rë cha hisca xi ha cavatju jyan nixtin jan, cojo sa xi cumaji nduva cha ladu rë nima vë ne, cjuahaxin cha nima tsëhë tsjun jan, sehe cuichja cha xi cavuya cjuahñu rë nima. Cuatjin nihñu ta tsëhë xi sá xi cuatjin sahmi cha, hisca hitsë sa choho cuatjuun cumá. ");
INSERT INTO maqNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ngajan xi cachja Pilatu cojo rë me cuitjin: ―‍Sacu nuju sindadu jan xi sahmi cuidadu rë tsjun, sehe tanguncujun ne, hacuaha ndaja techjunhñu tsjun vë hacutjin cuma xi nihñu. ");
INSERT INTO maqNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sehe quiji me cojo sindadu jan, cavechjahñu me tsjun, cojo sa xi cumatsejen sa xi cuaxë cha nima, hacuaha caviyuju cha sindadu xi sahmi cuidadu rë. ");
INSERT INTO maqNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Xi cavatju nixtin xi chjahájenda rë jan ne, xi tu casahasen ni tsëhë nixtin ngu tsëhë totje ne, na María na Mágdala jan cojo na María xi hacjahi ne, cavetju na quiji vutsejen na xcun tsjun rë nima Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hya xi camá ne, jercu cafani nangui ta tsëhë xi canduvajne ngu ángel rë Nina tsëhë ngahnga. Hane ángel jan ne, quiji catsivahaxin ndyojo xi cavechja rë tingotjo rë tsjun jan, sehe cavejña xcun. ");
INSERT INTO maqNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ángel jan ne, sacuaha ndihi chuhun ne, cuatjin jyihi ángel. Hacuaha tsjian rë ne, jemu tu tyava camahani jyihi, sacuaha jyihi hnchan xi hmí rë nieve. ");
INSERT INTO maqNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Xi camachaya rë me tsëhë ángel jan ne, jemu catsacjun sindadu xi siu cuidadu ngajan, hisca cafatsë hnchan cha hisca sacuaha cahme yojo ra cojo chircun. ");
INSERT INTO maqNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ngajan xi cachja ángel cojo yachjin xi siutaha jan cuitjin: ―‍Xicarcuun. Ha hvë xi Jesús vinchunsun me, me xi cavetaha xuta xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Me vëhë ne, tsajin me nguehe ta cavuya me cjuahñu sacuaha cachja me. Nduvun chutsujun cahndë́ hiscan cafaña me. ");
INSERT INTO maqNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Quihndë ne tangun sanii ne, tuhuncuendun rë xuta ladu rë me cuitjin: “Ha cavuya cjuahñu rë me; hane cjue titjun me tsujun Galilea. Hane ngajan sacu xingueen.” Hindë ne, vëhë cjua xi cuichjá cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hya xi camá ne, cavetju quiji yachjin jan. Jercu quijircun rë na peru hacuaha jercu ndama rë na. Cuatjin quiji na xi suacuenda na xuta ladu rë Jesús tsëhë cjua xi cachja ángel. ");
INSERT INTO maqNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hane hora xi tifi na ndiya ne, Jesús ne cavechutaha me na jan, casua me na nina. Sehe chjuun jan ne, cafehetiña na tsëhë Jesús, caticjaxcun na cafaha na ntsacu Jesús hane cafaharcun na me. ");
INSERT INTO maqNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hya xi camá ne, Jesús ne, cachja me cojo na cuitjin: ―‍Xicarcuun. Tangun tuhuncuendun rë hermano naja, tinújun cojo me xi cjue me distritu Galilea. Hane ngajan sacu xingueen. ");
INSERT INTO maqNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jinguyëjë rë xi quiji yachjin jan ne, ngujo cha sindadu jan cavisehen cha nandya Jerusalén, casuacuenda cha nahmi xi matitjun tsëhë xcusun xi camá. ");
INSERT INTO maqNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sehe nahmi jan ne, hya xi ha camátangun me cojo xuta changá hane cavisiajmi cjin me tsëhë mé xi sahmi me. Hane xi cama chihin cjua ne, jemu cjín camahani tujún casua me cha sindadu jan, ");
INSERT INTO maqNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","hacuaha cachja me cojo sindadu cuitjin: ―‍Vihi cjua xi cuinújun ni. Cuinújun ta xuta ladu rë me ne, nguixun ne, hora xi catsuñufun ne, cafehe me. Hane tahahma ne catsichëjë me nima. ");
INSERT INTO maqNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hane sá xi cumachaya rë gobernador tsëhë cjua jan ne, ngayin ne, cuanguin cuinújin cojo rë me cojo sa xi cuijnecacun me tsajin mé sahmi me cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Cuatjin camá xi cafahatsja cha tujún jan, hane cachja cha sacuaha cavitexa nahmi jan. Cjua vëhë ne, cavitsojo ngajñi rë xuta nangui Israel. Hane cuatjin chja cjua hisca nixtin quihndë. ");
INSERT INTO maqNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hya xi camá ne, xuta ladu rë Jesús xi má tengu me ne, quiji me distritu Galilea, hisca naxi xi cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hya xi camá ne, ngajan cavëë me Jesús ne, cafaharcun me me. Peru ngujo ni me macjaain rë me. ");
INSERT INTO maqNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ngajan xi camatiña Jesús tsëhë me, cachja me cojo me cuitjin: ―‍Ha cafahantsa ngahñu xi cumá sahme tu mé ni xcusun sá xi tsëhë ngahnga o sá xi tsëhë ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ngatsë rë ngahñu vëhë ne, tsingátju nuju ne, tangun jinguyëjë rë nandya ngasunhndë, cuinújun cojo xuta jan cojo sa xi cuisehen me ladu naha. Catiseyanangui ñihi rë Nina Nahmi, cojo ñihi naha, Quihndi rë Nina, cojo ñihi rë Hasen rë Nina hora xi xtenda me. ");
INSERT INTO maqNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Hacuaha ticuyun rë me xi cuihndë me ne, sahmichihin me yëjë xcusun xi cavitéxa nuju ngahan. Hane xi cuatjin ne, hacuaha cuitejñacuaha cojo nuju yëjë ni hora hisca cuijnetaha nixtin rë ngasunhndë.");
INSERT INTO maqNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cuitjin cavetsihin cjua tsëhë Jesucristu, me xi Quihndi rë Nina Jain. ");
INSERT INTO maqNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaías ne, ngu xutachanga xi cama cafaha cjua rë Nina hacuaha cachja me cojo xuta hatsëë nixtin. Cuitjin catsihindu me, hacutjin cachja Nina cojo me: Tsingátju titjun ngu cha xi cjuaha cjua naha, cojo sa xi scuxaha cha cjuatacun rë xuta, tsëhë xi cjuehe ngaye. ");
INSERT INTO maqNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hane hiscan jemu xín tsëhë nandya ne, ngajan cuejña cha. Hane cuitjin cuichja cha: “Sacuatjin matyjahi ndiya hya xi nduva ngu xuta rcun ne, cuatjin nihñu tyjahi cjuatacun nuju tsëhë xi cuinduva me xi matitjun tsajan.” Cuatjin cuichja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Sacuatjin jain catsihindu Isaías ne, cuatjin jain camá ta cafehe cha xi catsingatju Nina, cha xi hmí rë Juan, ngajan hiscan jemu xín tsëhë nandya. Casua cha camachaya rë xuta ta meje rë xi tsindeya me cjuatacun rë me hacuaha xtenda me, cojo sa xi tsinchataha Nina me tsëhë jyë́ rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Hane jercu cjín xuta quijitjengui me cha, xuta tsëhë distritu Judea cojo nandya Jerusalén. Hane cavitenda cha me xi cavijacun jyë́ rë cojo Nina ngajan ndajyë Jordán. ");
INSERT INTO maqNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tsjian rë cha Juan jan ne, tsja rë chu camellu camá. Cojo ngu cinturón chuxin quitaha cahntsua cha. Xi camá niñu rë cha ne, chu nchahva. Cojo tsjen rë chu tusen cahvi cha. ");
INSERT INTO maqNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Cuitjin cachja cha: ―‍Canduvá ngahan titjun. Peru sehe cuinduva ngu me xi hitsë sa vechu cjuatacun rë xi cumá ná ngahan, xi hisca chuxinxtë rë me cumaji tsinguisehercu sahme tyjahi. ");
INSERT INTO maqNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngahan ne, tu caviténda ni nuju. Peru me vëhë ne, cueya me Hasen rë Nina cahntsua xahasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sacuaha nixtin vëhë ne, cavetju Jesús tsëhë nandya Nasaret, distritu Galilea. Quijitjengui me cha Juan xi cuitenda cha me. Hane cavitenda cha me ngajan ndajyë Jordán. ");
INSERT INTO maqNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Xi camá caxtenda me ne, xi tu tivetju me tsëhë nandan jan ne, cavëë me xi ngahnga ne tituxaha, hacuaha Hasen rë Nina ne, nduvajne sacuaha tsejen ngu paloma, quiji cavisehen cahntsua xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hacuaha canuhya rë ngu cjua ngajan ngahnga xi chja cuitjin: ―‍Ngaye ne, quihndi naha ngaye. Jercu hmucacun ri. Jercu ndama ná ngatsë riji. ");
INSERT INTO maqNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ngajan xi Jesús ne, ngutjen ni quiji me ngajan ngu xín ta tsëhë xi Hasen rë Nina ne, cavaxëxin rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Casetaha me ngajan xín yachan nixtin. Hacuatjin cojo Satanás quijitjengui rë me. Hane handasa jercu cavangui Satanás chuva rë xi choho sahmi Jesús ne, peru casahmii me. Hacuaha quiji ángel caviyujutaha xi cjuahacuenda rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hacuaha camá nga ngu xcusun xi xuta xi matitjun ne, caveya me cha Juan ndavaya. Cavatju vëhë ne, sehe cavuya cafe nga Jesús distritu Galilea, cachja me cojo xuta cjua rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Cuitjin cachja me: ―‍Camatiña nixtin xi Nina ne, cuitexa me ngasunhndë. Vëhë xi meje rë xi nindeyun cjuatacun nuju hacuaha catamacjain nuju cjua xi tichjá cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nixtin xi catsujyihiya me hya ne, cavatju me tjehen laguna tsëhë Galilea. Hora hya ne, cavëë me cha Simón cojo cha Andrés hntsë cha. Titsingatjenya cha nahya ngajñi laguna jan, tsëhë xi ha tuxa xa vëhë sahmi cha. ");
INSERT INTO maqNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hane ngajan xi cachja me cojo cha ta: ―‍Nduvun cuanguen cojo ná. Hane cuicuyá nuju xi nuvun xuta xi cuisehen me ladu naja ngojo rë xi chu ti nuvun. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hane hora vëhë ni caviyuju cha nahya jan ne, quiji cha cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ha xcun xi ha cjui Jesús cojo cha xi cuacun jan hitsë ni nguvan ne, cavëë me cha Jacobo cojo cha Juan hntsë cha, quihndi rë Zebedeo. Hincha cha cahntsua barcu, tifuyataha cha nahya. ");
INSERT INTO maqNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hane hacuaha cajindaya me cha. Sehe caviyuju cha nahmi rë cha xi hmí Zebedeo cojo mosu rë me ngajan cahntsua barcu. Sehe quiji cha cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hya xi camá ne, cafehe me cojo catsiñuju cha xi cuacun vëhë nandya Capernaum. Hane hya xi cavechu nixtin xi chjahájenda rë ne, quiji me yungun, cavicuya me xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hane xuta jan ne, quijircun rë me hacutjin vicuya Jesús ta, tsëhë xi tivicuya me sacuaha ngu xi matitjun jain, hacuiin sacuatjin maestru xi vicuya ley rë xuta tsëhë nangui Israel. ");
INSERT INTO maqNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hacuaha ha tu ñahñu canduva ngu cha xi jiya xitsehen cahntsua xahasen rë cha ngajan cahntsua yungun jan. ");
INSERT INTO maqNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Hane cuitjin cajindaya cha: ―‍Ngayun ne, ¿mé cuenda nuju tsijin? ¿Há nduvun nicjun niji? Ngayun ne, Jesús tsëhë nandya Nasaret ngayun. Hacuaha hvë xi ngayun xi tsajin jyë́ nuju ngayun xi catsingatju nuju Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hane Jesús ne, cachja cjan me cojo xitsehen xi jiya xahasen rë cha jan. Cuitjin cachja me: ―‍Jyuu nechin. Hacuaha tetjixin tsëhë cha vi. ");
INSERT INTO maqNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Xi tu cahmexcuen cha xi casahmi xitsehen ne, hisca cajindaya, hane cavetjuxin tsëhë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yëjë ni xuta jan ne, jemu quijircun rë me, hisca cavisiajmi me cojo xicjin me cuitjin: ―‍¿Mé nga xcusun vihi ni? Ngu cjua xatsë xi vicuya me vihi, ta hisca xitsehen, hacuaha hndë tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hacuaha marcu macjain canuhya rë tsëhë me jinguyëjë ni ladu tsëhë distritu Galilea. ");
INSERT INTO maqNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hya xi camá ne, cavetju me yungun jan, quiji me ndava cha Simón. Quiji me cojo cha Jacobo cojo cha Juan, hacuaha cojo cha Andrés hntsë cha Simón. ");
INSERT INTO maqNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hane nahya rë cha Simón ne, jiña na xi hmu rë na cojo chihinsuë. Hane ngutjen cachja cha cojo Jesús xi hmu rë na. ");
INSERT INTO maqNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ngajan xi quiji tiña Jesús hiscan jiña na, cafaha me tsja na, catsisatjen me na. Hane hora vëhë ni, casejyu suë xi má rë na. Hisca cafaha cuenda na xi sinë me cojo xicjin me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hane xi cavetje tsuhi ne, jemu cjín xuta quijicojo me xuta hmu rë hiscan tacun Jesús, hacuaha cojo me xi hincha xitsehen xahasen rë, ");
INSERT INTO maqNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","camatangun me cojo xuta nandya ngajan tingotjo ndihya. ");
INSERT INTO maqNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hane jemu cjín xuta hmu rë camandaja me xi casahmi Jesús, xuta xi má rë me tu mé ni chíhin xi má rë xuta. Hacuaha jemu cjín xitsehen cavaxëxin me tsëhë xahasen rë xuta. Hane casuaain me cahndë́ xi cachja xitsehen ta tsëhë xi ha vëë rë me. Hane ngutjen cuichja ta me vëhë xi catsingatju Nina me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Xi camá nchujuni, jñu sa nguitajñu cavisatjenhnga me. Hane cavetju me ndihya quiji me ngu cahndë́ hiscan xin. Hane ngajan cavisiajmi me cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ngajan xi cha Simón cojo cha xi yahnga jan ne, cavanguise cha Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hane xi casacu rë cha me ne, sehe cachja cha cojo me ta: ―‍Jemu cjín xuta cafehetjengui nuju me. ―‍Cuatjin chja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngajan xi cachja me cojo cha ta: ―‍Cuanguen sa nandya xi siu tahndee, cojo sa xi hacuaha cuichjá cojo xuta vëhë cjua rë Nina ta tsëhë xi xa vëhë canduvá. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hane sehe quiji sa me yungun xi siu yëjë ni nandya tsëhë Galilea. Cachja me cojo xuta cjua rë Nina, hacuaha cavaxëxin me xitsehen xi hincha xahasen rë ngujo xuta xi siu nandya jan. ");
INSERT INTO maqNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hya xi catsujyihiya me nandya xi cuacun vëhë, hya cachja ngu cha xi yaha rë ngu chíhin vitaha xi setaha chuxin naja. Hane cachjajyë cha cojo Jesús, hisca cavixcuhnchi cha xcun me, sehe cachja cha cuitjin: ―‍Sá xi nihñu favor ne, cuma naxunxun chíhin xi yaha ná. ");
INSERT INTO maqNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús ne, camayuma rë me cha. Hane cavetahatsja me cha. Sehe cachja me cojo cha cuitjin: ―‍Joho. Ha camandaja ngaye. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hane ngutjen ni cavetjuxin chíhin jan ne, camandaja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Hane sehe casua me cha cuidadu. Hane ngutjen ni catsingatju me cha, quiji cha. ");
INSERT INTO maqNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Cuitjin cachja me: ―‍Ndaja cuidadu xi canujiin camahani xcusun vi cojo hisca ngu. Peru tihin ningacuin yojo riji cojo nahmi ngajan yungun. Hane tejñi ngu cjuatjo sacuatjin chja ley tsëhë Moisés ta camandaja ngaye, cojo sa xi xuta ne, cumacjain rë me. ―‍Cuatjin cachja me cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Peru xi cavetju cha quiji cha ne, cavetsihin casua cha camachaya rë xuta. Jercu cachjatë cha tsëhë xcusun vëhë. Vëhë xi Jesús ne, ha quihndë cavisiin me nandya ta tsëhë xi ha ngutjen jercu tsë xuta. Hane ngajan ni nguijña casetaha me. Peru xuta ne, yëjë ni ladu cavetju me, quijitjengui me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hane cahntsua xi ngujo nixtin ne, cavuya quiji nga Jesús cojo cha ladu rë me ngajan nandya Capernaum. ");
INSERT INTO maqNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hane xi casacu cjua xi tacun ndihya me ne, jercu camatangun xuta, hisca tingotjo ndihya quitsë me. Hane sehe cachja Jesús cjua rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ngajan xi canduva ñuju cha hiscan tacun Jesús, yahahnga cha ngu cha xi cahme yojo rë. ");
INSERT INTO maqNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hane xi maji ficojo cha cha hisca hiscan tacun Jesús, tsëhë xi jemu quitsë xuta ne, cavuxaha cha rcu ndihya quixi rë hiscan tacun me. Sehe ngajan catsinguisehen cha cha hmu rë jan cojo ni nachan xi quisun cha. ");
INSERT INTO maqNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hya xi cavëë Jesús hacutjin xi macjain rë cha me ne, sehe cachja me cojo cha hmu rë jan ta: ―‍Jyë́ riji tsan ne, ha camanchataha. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hora vëhë ne, hacuaha tivisiñuju ngujo cha maestru tsëhë ley, hacuaha taha titsingatahacacun cha cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Mé má cuitjin chja cha xi cuijyihi vi?, ta Nina tsixcuehyu cha. Tsajin yo xi cuma tsinchataha jyë́ rë ngu xuta ta suva ni Nina má sahmi me.” ");
INSERT INTO maqNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús ne, ha hisca vëë me cojo cjuatacun rë me xi cuatjin tsingatahacacun cha xi cuacún vë, hane sehe cavinenguise me cuitjin: ―‍¿Mé má cuatjin ningatuhuntacun cjuatacun vëhë? ");
INSERT INTO maqNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jarë xi hitsë sa tsavi xi cuichjá cojo cha hmu rë vi? ¿Há xi: “Jyë́ riji ne, ha camanchataha?” O há tsajin ne, ¿há xi: “Tisatjinhngue ne, chjaye nijña riji, hane tjihin?” ");
INSERT INTO maqNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Hindë cojo sa xi cumachaya nuju xi Nina cavitexa me ngahan xi tsinchátaha jyë́ rë xuta nguehe ngasunhndë ne, nguehe chutsujun hacutjin cuichjá cojo cha hmu rë vi. Sehe cachja me cojo cha hmu rë cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―‍Tisatjinhngue tsan. Chjaye nijña riji ne, tjihin ndya riji. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ngajan xi cha hmu rë jan ne, ngutjen ni cavisatjenhnga cha, cafaya cha nijña rë cha, sehe cafe cha xcun ni ngayëjë xuta. Vëhë xi ngayëjë ni xuta jan ne, jemu quijircun rë me. Hacuaha cachja me ta: ―‍Jemu cjuarcun jain Nina. Vëhë xi cuatjin camá casahmi me. Cjëë camahani chaan xcusun sacuaha vëhë. ―‍Cuatjin cachja xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ngu nixtin nga ne, cavatju Jesús tjehen laguna. Hane jemu cjín xuta quijitjengui rë me. Hane cavicuya me xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hane hya xi cjui cjui me ne, cavechu me hisca tacun cha Leví, quihndi rë cha Alfeo. Tacun cha ndihya hiscan faha cha xi machjitje tsëhë xi xteña. Sehe cachja Jesús cojo cha cuitjin: ―‍Cuanguen cojo ná. Hya xi camá ne, cavetju cha, quiji cha cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Cuitjin camá nga ngu nixtin jan, tijinë Jesús niñu ndava cha Leví. Hacuaha jemu cjín sa cha xi faha tujúnsa cojo jingu sa cha tsehen tijinë cha cojo Jesús cojo cha ladu rë me, ta hacuaha jemu cjín xuta xi cuacún vë xi tjengui rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Peru cha maestru tsëhë ley cojo cha tsëhë partidu fariseo ne xi tu cavëë cha xi tijinë Jesús cojo cha xi cuacún jan ne, sehe cavinenguise cha cojo cha ladu rë me cuitjin: ―‍¿Mé má cuatjin tijinë Jesús cojo cha xi choho xcusun rë vë ni? ");
INSERT INTO maqNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Xi tu cahndë Jesús cjua rë cha ne, sehe ngajan xi cachja me cojo cha ngu ejemplu cuitjin: ―‍Xuta xi hacuiin hmu rë me ne, mijí rë me doctor. Me xi hmu ni rë me ne, me vëhë xi mameje rë me. Hacuaha ha chuva vëhë ni canduvá ngahan. Canduvá cuanguë xuta xi choho cjuatacun rë, cuichjá cojo rë me cjua rë Nina. Peru hacuiin cojo me xi ha tyjahi cjuatacun rë. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Camá xi cha ladu rë cha Juan cojo cha tsëhë partidu fariseo ne, nixtin hya ne siu cha xun tsëhë Nina. Hane cafehe ngujo cha xi cavinenguise rë Jesús cuitjin: ―‍¿Mé má cha ladu rë cha Juan cojo cha tsëhë partidu fariseo ne, tijinii cha quihndë ta, siu cha xun rë Nina, hane cha ladu nuju ne, faharcuiin cha cuatjin ni? ");
INSERT INTO maqNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sehe catsicuya Jesús cjua cojo ngujo ejemplu cuitjin: ―‍Jinguyëjë rë xi cha xi cuixan ne, tacun cha cojo xuta rë cha ne, cumaji cuiyuju me xun rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Peru cuinduva nixtin hya xi cha xi vixan ne, cojo cjuachan cjuecojo condra rë cha cha. Hane hya cuiyuju xuta rë me xun rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hacuaha cachja me cojo cha cuitjin: ―‍Tsajin yo xi fuyataha tsjian changá cojo ngu rquí tsjian xatsë ta tsëhë xi cjëë cjueyu. Cuatjin ta, sá xi cuatjin sahmi me ne, xi cjueyu tsjian xatsë jan ne, cuicheya rë tsjian xi changá jan hane sahmi jyë sa rë hiscan xi ntsun. ");
INSERT INTO maqNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hacuaha tsajin yo xi vincha xan xatsë cahntsua chuxin changá ta, sá xi cuatjin sahmi me ne xan jan ne, tsitsinga rë chuxin jan. Hane xan jan ne, chajan. Hacuaha cuetsun chuxin jan. Vëhë xi xan xatsë ne meje rë chuxin xi xatsë. Maji secjan jo xcusun. ");
INSERT INTO maqNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Cuitjin camá nga ngu nixtin xi chjahájenda rë. Hora xi tivatju Jesús cojo cha ladu rë me hiscan tjin tjë trigu ne, cavetsihin cavotohosun cha tsë tsë trigu jan. ");
INSERT INTO maqNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sehe cha tsëhë partidu fariseo cavinenguise cha me cuitjin: ―‍¿Mé má cuatjin quihndë nixtin xi chjahájenda rë ne, sahmi cha ladu nuju xa xi chja ley xi cumaji nihña? ");
INSERT INTO maqNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sehe Jesús ne, cafayangui me tsëhë cha cuitjin: ―‍¿Há cjëë camahani chutayun xujun hiscan chja tsëhë xcusun xi casahmi David hya xi tjin rë me cjuandya xi jemu vojo rë me cojo cha xi siutaha cojo me? ");
INSERT INTO maqNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Hya xi Abiatar má me nahmi xi matitjun jan ne, hya cavisehen me ndava Nina. Hane David ne, cajinë me pan xi viyuju xcun Nina. Hacuaha casua me cajinë cha xi siu cojo me. Cuatjin casahmi me handasa xi chja ley ta suva ni nahmi tjin cahndë́ xi cuma sinë me pan xi cuacún vë. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ngajan xi cachja me cojo cha ta: ―‍Xi má nuju ngayun ne, ¿há titjun cavejña Nina nixtin xi chjahájenda rë, sehe catsindaja me xuta xi cjuaharcun rë nixtin vëhë? ¡Hacuiin cuatjin camá! Nina ne, titjun catsindaja me xuta, hane xi camá ngascan ne, cavajña me nixtin xi cjuahajenda xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Cuatjin ne, ngahan xi tsëhë Nina canduvá ne, hacuaha satë ná ngahan sacuaha nai rë xi cuichjá mé xi ndatjin xi cuma nixtin xi chjahájenda rë. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ngu nixtin nga xi quiji Jesús ngu yungun ne, ngajan tacun ngu xihin xi quixihñu ngu ladu tsja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hane cha tsëhë partidu fariseo ne, cojo sa xi cuma cuinchajyë cha Jesús ne, siu cha cuidadu, ¿há tsindaja Jesús hiscan hmu rë xihin jan nixtin xi chjahájenda rë? ");
INSERT INTO maqNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hane ngajan xi cachja Jesús cojo cha xi quixihñu tsja jan cuitjin: ―‍Xcun ni yëjë xuta vi ne, tisechin. ");
INSERT INTO maqNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sehe cavinenguise me xuta xi siu me cuitjin: ―‍¿Mé xi sacu cahndë́ nixtin xi chjahájenda rë? ¿Há xi ndaja ne, o há xi ndajin, há xi naxentjen xuta o há xi niquen me? Peru cafayinnguiin me hisca hitsë. ");
INSERT INTO maqNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Vëhë xi Jesús ne, cama cjan rë me. Hacuaha cama vacacun me ta, tsëhë xi sahmi yumahasen xuta. Xi tu cavutsejen Jesús yëjë ni xuta ne, sehe cachja me cojo xihin hmu rë jan cuitjin: ―‍Nixingun ntsun. Xi tu catsixinga cha tsja cha ne, ha camandaja. ");
INSERT INTO maqNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ngajan xi cha tsëhë partidu fariseo ne, cavetju cha yungun. Quiji casahmitangun cha cjua cojo cha tsëhë partidu Herodes xi tsiquehen cha Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ngajan xi Jesús cojo cha ladu rë me ne, quiji nga me laguna. Hacuaha jemu cjín xuta tsëhë distritu Galilea quijitjengui me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Hane xi camachaya rë xuta xcusun xi casahmi Jesús ne, canduva camaha sa xuta tsëhë cahndë́ xi cuicun vi: nandya Jerusalén cojo yëjë sa nandya tsëhë distritu Judea, cojo distritu Idumea, cojo ngunda vëhë tsëhë ndajyë Jordán cojo hisca tahndee rë nandya Tiro cojo nandya Sidón. ");
INSERT INTO maqNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sehe ngajan xi cachja me cojo cha ladu rë me ta meje rë xi cuejña cha ngu barcu tiña hiscan tacun me, ta jemu cuehnchun xuta me. ");
INSERT INTO maqNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hane tsëhë xi jemu cjín xuta camandaja me xi casahmi Jesús ne, vëhë xi yëjë ni me xi hmu rë catsëxti me ne, cojo sa xi ndastu satë tsja me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Hane xi cavëë xitsehen xi hincha xahasen rë xuta jan Jesús ne, quiji caticja xuta jan hisca tacun Jesús. Sehe ña jindayatë xuta jan, ta xitsehen casahmi xi cachja me cuitjin: ―‍Ngayun xi Quihndi rë Nina ngayun. ―‍Cuatjin cajindaya me. ");
INSERT INTO maqNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngajan xi Jesús ne, cavitexa me xitsehen xi tsajin yo cuichja cojo yo me. ");
INSERT INTO maqNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Hya xi camá ne, camiji Jesús ngu naxi. Sehe catsingatju me cjua rë cha xi meje rë me. Hane quijitjengui cha me. ");
INSERT INTO maqNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hane cavaxijin me tejó cha xi cuisecoo rë me, hane hacuaha tsingatju me cha cjue cuicuya cha xuta cjua rë Nina, ");
INSERT INTO maqNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","hacuaha cuaxëxin cha xitsehen xi hincha xahasen rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Cha xi tejó tsëhë cha ladu rë me cuitjin hmí ra: cha Simón ne, hacui cha xi cachja Jesús xi hmí rë Pedru, ");
INSERT INTO maqNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","cha Jacobo cojo cha Juan hntsë cha ne, xi quihndi rë Zebedeo, cha xi casuañihi me Boanergerne, ngu ñihi xcuehyu xi meje cuichja Jemu Xti Naja, ");
INSERT INTO maqNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","cha Andrés, cha Felipe, cha Bartolomé, cha Mateo, cha Tomás, cha Jacobo, quihndi rë Alfeo, cha Tadeo, cha Simón xi tsëhë partidu cananayu, ");
INSERT INTO maqNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","hane cha Judas tsëhë nandya Queriote, cha xi cuiteña rë Jesús cojo condra rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hya xi camá ne, cavuya quiji nga Jesús ndihya hiscan véjña me. Hacuanitjin nga camatangun xuta cjín. Hisca xi sinë Jesús niñu cojo cha ladu rë me maji. ");
INSERT INTO maqNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hya xi camachaya rë xuta rë me cjua vëhë ne, quiji me xi cuaxëxin rë me, tsëhë xi há sa má rë me, sca rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hane cha maestru tsëhë ley ne, canduva cha tsëhë Jerusalén. Sehe cavisiajmi cha cojo xicjin cha cuitjin: ―‍Jiya Satanás xahasen rë me. Hane ngatsë rë xitsehen xi matitjun vë ne, vëhë xi ma vaxëxin Jesús xitsehen. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ngajan xi casahmi tangun Jesús cha xi cuacun vëhë ne, sehe cojo ngujo ejemplu cachja me cojo cha cuitjin: ―‍Jemu yuma hasen rë Satanás sá xi suva ni cuaxëxin xicjin. ");
INSERT INTO maqNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ha hyan ta sá xi xutaxa rë tsëhë ngu nandya scaan me ngajñi rë me ne, cjuicanii rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hacuaha sá xi xuta xi ngu ndava me ne, scaan me ngajñi rë me ne, ngajan chaja. ");
INSERT INTO maqNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ha cuanitjin rë Satanás ta sá xi scaan cojo xicjin ne, ha quihndë cumachjiriin xi matitjun ta, tsëhë xi ha quihndë cuihndiin xicjin tsëhë. ");
INSERT INTO maqNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Hacuanitjin ne, hisca ngu cha chëjë cumaji tu cuisehen ni cha ndava ngu xuta xi hñu ngahñu rë me xi tsichëjë cha tsëhë me. Cumaji sa xi hacuiin titjun tsihñu cha me ta cuatjin xi cuma tsichëjë cha tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Cuichjá cojo nuju cjuaquixi ta tu mé ni jyë́ xi sahmi xuta hacuaha tu mé ni cjua xi choho cuichja me ne, sacu rë me cjuaninchataha, sá xi cuijacun me jyë́ rë me cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Peru tu yo ni xi choho cuichja tsëhë Hasen rë Nina ne, tsajin ngu nixtin xi sacu rë cjuaninchataha ta jemu jyë jyë́ rë. ");
INSERT INTO maqNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Cuatjin cachja Jesús ta tsëhë xi cachja cha jan xi jiya xitsehen xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hane cafehe naa rë me cojo hntsë me ne, ngajan ni ndatsen hinchacun me ne, catsingatju me cjua xi meje cuisiajmi me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Vëhë ta jemu cjín xuta siundee me Jesús ne, sehe cachja xuta cojo rë me cuitjin: ―‍Nutsujun ni. Ná nuju cojo tsuhun cojo tichjun ne, jindaya nuju me ngajan candatsen. ");
INSERT INTO maqNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sehe cafayangui Jesús cuitjin: ―‍¿Yo xi má nuju xi ná naha cojo xingueen? ");
INSERT INTO maqNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Cavutsejen me xuta xi siundee rë me, sehe cachja me cuitjin: ―‍Ngayun xi nechun nguehe, ngayun xi sacuaha ná naha cojo xingueen ");
INSERT INTO maqNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ta, tu yo ni xi sahmi sacuatjin chja Nina ne, vëhë xi sacuaha ná naha sacuaha xingueen. ");
INSERT INTO maqNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ngu ndiya nga ne, cavetsihin cavicuya Jesús xuta tjehen laguna. Hane ngu cuatjin nga jercu tu catsë camahani xuta hiscan tacun me. Vëhë xi cavisehen me ngu barcu cavéjña me. Hane quijicojo rë me hitsë xcun nandá, ngajan cavéjña. Hane yëjë ni xutacjín jan ne, caviyuju me nangui quixí tjehen nandan. ");
INSERT INTO maqNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sehe cavicuya Jesús me jemu cjín cjua. Cuitjin cachja me ngu ejemplu: ");
INSERT INTO maqNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―‍Cuejña ni xi ngu xihin ne, quiji catsitjë cha trigu. ");
INSERT INTO maqNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hane hora xi ticandi cha tjë rë ne, ngujo ne, cavixu ndiya. Hane canduva nisë ne, cajinë chu. ");
INSERT INTO maqNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ngujo nga ne, cavixu hiscan xi jemu ndyojotë, hacuaha jemu chuva nihndë quisun. Hane jemu xati cavetju ta tsëhë xi hacuiin tjain nihndë quisun. ");
INSERT INTO maqNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hane xi jemu suë camá ne, caxiya tsëhë xi jemu chuva tyjama rë. ");
INSERT INTO maqNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ngujo nga ne, cavixu ngajñi rë nahyá. Xi tu camayehe nahyá ne, casahmihndë rë xitjë, hane camayiin. ");
INSERT INTO maqNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hane ngujo nga ne, cavixu hiscan ndajyihi nangui. Vëhë ne, jemu ndaja camá, hisca yehe hnga camá ya rë. Ngujo ne jemu ndaja camá. Ngujo nga jan ne, hitsë sa ndaja camá. Hane xi yahnga jan ne, jercu vatjutaha ndaja camá. Cuatjin fi ejemplu tsëhë cha xi tsitjë trigu. ");
INSERT INTO maqNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","’Jarë ngayun xi meje nuju cuma nuju ne, ningatuhuntacun nduju mé vijne cjua vë. ");
INSERT INTO maqNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hya xi cafe xutacjín jan ne, ngajan xi me xi siundee cuaha jan cojo cha xi tejó jan ne, cavinenguise me tsëhë cuentu jan. ");
INSERT INTO maqNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sehe cafayangui Jesús cuitjin: ―‍Ngayun ne casua nuju Nina cahndë́ xi vijne rcun cjuatahahma tsëhë gubiernu xi sahmi me. Peru me xi hacuiin ladu naja ne, cojo suva ejemplu tichjá cojo rë me, ");
INSERT INTO maqNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","cojo sa xi handasa cuihndë me ne, peru cuijnii rcu me ta, sá tu tsindeya me cjuatacun rë me ne, hacuaha cumanchataha me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sehe ngajan xi cachja Jesús cojo cha ladu rë me ta: ―‍Sá xi ha canuhyuun ejemplu vëhë ne, hacutjin cuinuhyun sa xi yahnga ni. Nguehe cuichjá cojo nuju mé vijne ejemplu xi cachjá cojo nuju vë. ");
INSERT INTO maqNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Cha xi tsitjë trigu ne, sacuaha ngu cha xi chja cjua rë Nina cojo xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ngujo me xi vihndë cjua vëhë ne, sacuaha tjë rë trigu xi cavixu ndiya ta cjua ndajyihi xi vihndë me ne, ngutjen ni nduva Satanás ne, fahataha cjua xi caseya cahntsua xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yahnga nga me xi vihndë cjua vëhë ne, sacuaha tjë xi cavixu hiscan jemu ndyojotë ta hya xi vihndë me cjua ndajyihi ne, ngutjen ni jemu cojo cjuasua macjain rë me cjua. ");
INSERT INTO maqNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Peru tsëhë xi hacuiin nguñaja cacun me macjain rë me ne, vëhë xi seyaain cahntsua xahasen rë me hya xi má cjuandya, sacuaha cumá rë tjë xi jemu chuva tyjama rë ne ta, cain rë xi jyë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hane ngujo nga me xi vihndë cjua vëhë ne, sacuaha tjë xi cavixu ngajñi nahyá. Vihndë me cjua. ");
INSERT INTO maqNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Peru tsëhë xi jemu tjin rë me cjuandya hacuaha jercu meje rë me xi cuma nchina me, vëhë xi chuva cuenda sahmi me cjua ndajyihi xi cavisiñuju me. Fë ne, tsajin mé vetjucaa. ");
INSERT INTO maqNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngujo nga me xi vihndë cjua ndajyihi vëhë ne sacuaha tjë xi camatjë hiscan ndajyihi nangui ta xi tu vihndë me cjua vëhë ne, faha nguñajacacun me. Vëhë xi ngujo me ne, ndaja cuiyujuchihin cjuatacun rë me. Ngujo nga me ne, hitsë sa ndaja cuiyujuchihin cjuatacun rë me. Hane me xi yahnga jan ne, jercu tu ndaja camahani cuiyujuchihin cjuatacun rë. ");
INSERT INTO maqNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hacuaha cachja me cojo rë me cuitjin: ―‍Hya xi setaha rë candil ne, ¿jani cuejña? ¿Há ngahma caxa ne? o ¿há ngahma nachan? Hacuiin cuatjin nihñu ta, cuejña cahndë́ rë. ");
INSERT INTO maqNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sacuaha ndaja tsejen ndihi jan ne, hatuxa cuechu nixtin xi cuijne rcu xuta cjua naha xi hacuiin ndaja vijne rcun me quihndë. ");
INSERT INTO maqNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jarë ngayun xi meje nuju cumá nuju ne, ningatuhuntacunndujun mé vijne cjua vë. ");
INSERT INTO maqNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hacuaha cachja sa me cojo xutacjín cuitjin: ―‍Ndaja tetuhunrcun xi tivisiñuju. Chuva xi tuhun ne, ha chuva vëhë sua nuju Nina. Hisca quisun sa sua nuju me. ");
INSERT INTO maqNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Me xi ha tjin rë ne, sua sa Nina me, hane me xi tsajin cjín rë ne, cjuahataha Nina xi tjin rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sehe cachja Jesús cojo xutacjín jan ngu ejemplu cuitjin: ―‍Xuta xi cuisehen me ladu rë Nina ne, ha tuxa cumá cjín me sacuaha tjë tsëhë trigu xi tsitjë ngu xihin xcun nangui rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Fañafë cha nguixun ne, visatjenhnga cha nguitajñu. Hane tjë ne, vetju, hacuaha mayehe xitjë. Peru xihin jan ne, hvíin hacutjin camá xi camayehe xitjë jan. ");
INSERT INTO maqNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nangui ne, ha tuxa má xitjë. Titjun ne, cuetju xca rë. Xi cuijin sa ne, cuetju tú chihndë rë. Hiscan xi cuijnetaha ne, jemu cjín tutjë rë cuetju. ");
INSERT INTO maqNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hane hya xi camacha tutjë rë ne, sehe tsingatju xihin jan mosu xi cjue cuatë ta tsëhë xi ha cavechu nixtin xi xtí rë. ");
INSERT INTO maqNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sehe cachja Jesús cuitjin: ―‍Nguehe cuichjá cojo nuju ngu nga ejemplu tsëhë gubiernu xi sahmi Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xuta xi cuisehen ladu rë Nina ne, cumacjín me sacuaha majyë ngu ya mostasa. Tutjë rë ya vëhë ne, hitsë sa langa xi cumá rë yëjë ni tutjë xi tjin ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Peru hya xi matjë ngu ne, sehe cuetju xca rë hacuaha hitsë sa jyë má xi cuma rë yëjë ni xca xi chine. Hane tsja rë ne, hacuaha yehe, hisca nisë ma sahmi chu ndava chu xcun tsja rë hiscan tjahnguen. ");
INSERT INTO maqNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jemu cjín ejemplu sacuaha vëhë cachja Jesús hya xi tivicuya me xuta cjua rë Nina, hatucutjin hora xi cama cavetaharcu xuta. Hane cojo xuta ne, cachja me suva ejemplu. ");
INSERT INTO maqNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Peru hya xi suva siu cha ladu rë me ne, casua cuenda me cha mé vijne yëjë ejemplu jan. ");
INSERT INTO maqNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Xi quiji hora tsëhë nixtin vëhë ne, Jesús ne, cachja me cojo cha ladu rë me cuitjin: ―‍Cuanguen ngunda vëhë. ―‍Cuitjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ngajan xi caviyuju ni me xutacjín jan ne, sehe cha ladu rë me ne, quiji cha cojo me tu cuanitjin ni. Hacuaha cojo sa barcu xi yahnga jan ne, quiji tangun cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hora xi cjui barcu ne, canduva ngu tjo xi jercu tu hñu camahani. Hane tsindyu rë laguna jan ne, vixuya cahntsua barcu, hisca meje tsë rë barcu cojo nandá. ");
INSERT INTO maqNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hane Jesús ne, hisca cahnchun barcu jan jiñafë me, tijiña me xcun tsjian sanercu me. Hya xi camá ne, catsingasca cha me, sehe cachja cha cojo me cuitjin: ―‍Maestro. Xati nihñutacun catasca nuju. ¿Há tsajin mé cuenda nuju ta, meje xtyusehen barcu cojo naja? ");
INSERT INTO maqNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hane cavasca rë me ne, cachja me cojo tjo cojo laguna cuitjin: ―‍Jyuu nechun. Xi tu cachja me cuatjin ne, casejyu yëjë ni. ");
INSERT INTO maqNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ngajan xi cachja me cojo rë cha cuitjin: ―‍¿Mé má cuatjin jemu rcun? ¿Hacujyihi ni xi hisca cjëë cumacjain ndaja nuju ngahan? ");
INSERT INTO maqNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hya xi camá ne, jercu catsacjun camahani cha ladu rë me jan. Hane sehe ngajñi rë cha jan ne, cavisiajmi cha cuitjin: ―‍¿Yo me xi cuijyihi vi? ta, hisca tjo hisca laguna hndë tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hya xi camá ne, cafehe Jesús cojo cha ladu rë me ngunda vëhë tsëhë laguna, hiscan ladu rë xuta nandya Gadara. ");
INSERT INTO maqNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hane xi cavetju me barcu jan, canduva tiña ngu xihin xi hincha xitsehen xahasen rë, canduva cha tsëhë ngajñi rë tsjun ngajan tahndë. ");
INSERT INTO maqNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Hacuaha ha ngajan tacun cahndë cha tahndë. Hacuaha tjihñu cha xi sejyu cha hisca cojo cadena. ");
INSERT INTO maqNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Jemu cjan rë cha, cjín ndiya camahñu tsja camahñu ntsacu cha cojo cadena, peru tu cavicheya ni cha. Vëhë xi tsajin yo xi cama casahmi cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Catsujyihiya cha nixtin nixten ngajan tahndë cojo ngajñi nguijña cha. Hane cajindayatëcjin ni cha, hacuaha cavanguihmucjin ni cha yojo rë cha cojo ndyojo. ");
INSERT INTO maqNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hane hora xi cavëë cha Jesús ne, cjin sa nduva cha ne, vanga cha quiji cavixcuhnchi cha xcun Jesús xi cjuaharcun cha me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ña cajindayatë cha cachja cha cuitjin: ―‍¿Mé cuenda nuju tsahan, Jesús, Quihndi rë Nina xi matitjun? Catamaniji rë Nina xi tuhundyun ná. ");
INSERT INTO maqNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Cuatjin cachja cha ta tsëhë xi ha tichja Jesús xi cuetjuxin xitsehen jan tsëhë xahasen rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sehe cavinenguise me ñihi rë cha. Hane cafayangui cha tsëhë me cuitjin: ―‍Ñihi naha ne, Sindadu Cjín, tsëhë xi jemu cjín ngayin. ");
INSERT INTO maqNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sehe jercu cafehya cha cojo Jesús xi hacuiin cjín camaha tsingatju me xitsehen jan tsëhë cahndë́ vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jinguyëjë rë xi cuatjin tijima ne, ngajan tiñataha ne, tacun ngu cahndë́ hiscan chu chinga hinchataha chu tijinë chu. ");
INSERT INTO maqNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Hane xitsehen jan ne, ña yuma chja cojo Jesús cachja cuitjin: ―‍Ningatjun niji hiscan siutaha chinga, xi cuisihin cahntsua xahasen rë chu. ");
INSERT INTO maqNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hane Jesús ne, joho cachja me. Hane hora xi cavetju xitsehen xahasen rë xihin jan ne, quiji cavisehen cahntsua xahasen rë chinga jan. Sehe yëjë ni chinga jan, xi meje jo mil jan ne, cavanga chu quiji cavetje chu ngu ndetjun tsëhë rcu naxi hane ngajan cavixuya chu ngajñi laguna. Ngajan camiji rë chu, hane cahme chu. ");
INSERT INTO maqNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hane cha xi titsicjén rë chinga jan ne, cavanga cha quiji cha. Casua cha camachaya rë xuta xi siutaha nguijña, cavechu hisca nandya cachja cha. Ngajan xi xuta xi cahndë cjua jan ne, quiji cavutsejen me mé xi camá jan. ");
INSERT INTO maqNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cafehe me hisca tacun Jesús, hane cavëë me cha xi jemu cjín xitsehen caxincha xahasen rë, tacun cha, yaja cha tsjian rë cha, hacuaha ha quihndë tsajin mé má rë cjuatacun rë cha. Hane xuta jan ne, jemu catsacjun me camá. ");
INSERT INTO maqNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hacuaha xuta xi cavëë hacutjin cavatju cha camá hacuaha hacutjin cavatju chinga camá ne, cachja me cojo xuta xi yahnga. ");
INSERT INTO maqNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sehe cavetsihin cachja me cojo Jesús xi catje me tsëhë ladu rë me xi cuicun vi. ");
INSERT INTO maqNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hya xi camá ne, hora xi tivisehen Jesús barcu ne, jercu cafehya cha xi caxincha xitsehen xahasen rë jan xi cjue cha cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Peru Jesús ne casuaain me cahndë́ xi cjue cha. Hane cuitjin cachja me cojo cha: ―‍Tjihin ndya riji. Tjihin tjengui xuta riji, hane tinoje cojo rë me xi Nina ne, camayuma rë me ngaye. Hacuaha tinoje tsëhë cjuandaja xi casahmi me cojo ri. ");
INSERT INTO maqNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ha xcun xi cafë cahndë cha cjua xi cachja Jesús ne, sehe cavetju cha quiji cha ladu hiscan xi hmí rë Të Nandya. Hane cavetsihin cha casuacuenda cha cjuandaja xi casahmi Jesús cojo cha. Sehe xuta xi siu cahndë́ jan ne, jemu quijircun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Xi tu cavuya nga Jesús cojo barcu ladu vihi tsëhë laguna ne, jercu catsë nga xuta hiscan cafehe me tjehen laguna. ");
INSERT INTO maqNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hacuaha cafehe ngu xutaxa rë yungun rë ngu nandya. Cha vëhë ne, Jairo hmí rë cha. Hya xi cavëë cha Jesús ne, quiji cavixcuhnchi cha xcun me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sehe jercu cafehya cha favor cojo me. Cuatjin cachja cha: ―‍Quihndi naha ne, ha tu hora sa xi cueya na. Cuanguen ne, cuisanu ntsun na ne, cojo sa xi cumandaja na, hane cuejña sa na cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Xi tu cahndë Jesús cjua rë cha ne, sehe quiji me cojo cha. Hacuaha jemu cjín camahani xuta quiji me hacutjin quiji Jesús. Quiji hnchun hnchun me cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hane ngajñi rë xuta jan ne, jiyajñi ngu chjuun xi ha nduva tejó nu xi hmu rë na tsëhë chíhin xahmajni. ");
INSERT INTO maqNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hane jemu jyë cjuañihi cavatju na camá ta ha ndasa jemu cjín doctor catsirqui me na, tu mahya catsicjë na tujún rë na ta tsajin mé cavetjucaa. Tu hitsë sa jyë camá chíhin rë na. ");
INSERT INTO maqNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Xi tu cahndë na cjua tsëhë xcusun xi casahmi Jesús ne, quiji tiña na taha ngaxtun me, cavetahatsja na tsjian rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Cuatjin casahmi na ta catsingatahacacun na cuitjin: “Sá xi cuetaha ntsa ndastu tsjian rë me ne, cumandaja ngahan.” ");
INSERT INTO maqNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hane ngutjen ni caxiya jni xi vixu rë na. Hane hacuaha camachaya rë na ta camandaja na tsëhë chíhin xi má rë na. ");
INSERT INTO maqNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús ne, camachaya rë me xi tjin xa xi casahmi ngahñu rë me. Cavuya me taha ngaxtun me ne, cavutsejen me xuta jan ne, sehe cavinenguise me cuitjin: ―‍¿Yo xi casatëtsja tsjian naha? ");
INSERT INTO maqNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Sehe ngajan xi cha ladu rë me jan ne, cachja cha cojo me cuitjin: ―‍¿Hacutjin meje nuju xi cuinújin yo xi casahmi? ta ha chutsujun xutacjín xi ña tisatëtaha me ngayun ndya jan. ");
INSERT INTO maqNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sehe cavutsejen nga me xuta tahndee rë me ne, ¿yo xi cuatjin casahmi? ");
INSERT INTO maqNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sehe chjuun xi casahmi jan ne ta ha vëë na hacutjin cavatju na camá ne, ña fatsë na xi catsacjun na camá. Sehe quiji cavixcuhnchi na xcun Jesús, hane cachja na yëjë ni hacutjin xi cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sehe ngajan xi Jesús ne, cachja me cojo na cuitjin: ―‍Ha camandaja ngayun ta camacjain nuju. Tjangun cojo cjuasua ta chíhin vë ne, ha quihndë cuyaain suaxti nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jinguyëjë rë xi Jesús tichja cuaha me ne, canduva ngujo me tsëhë ndava xutaxa rë yungun jan. Hane cuitjin cachja me: ―‍Ha cahme quihndi nuju. Tahanndyaan sa rë maestru. ");
INSERT INTO maqNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Peru Jesús ne, handasa cahndë me cjua xi cachja me xi cafehe jan ne, sehe cachja me cojo xutaxa rë yungun jan ta: ―‍Xi camacjiintacun. Ningatuhuntacun ni xi cumandaja na. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sehe casuaain me cahndë́ xi cjue yëjë xuta jan. Suva ni cha Pedru, cha Jacobo cojo cha Juan hntsë cha Jacobo, cha vëhë quiji cha cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Xi cafehe me ndava xutaxa rë yungun jan ne, ngajan siu xutacjín xi jihnda me jindaya me ngatsë rë cjuandusin. ");
INSERT INTO maqNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hane xi cavisehen Jesús ndihya ne, sehe cachja me cojo xuta jan cuitjin: ―‍¿Mé má cuatjin va má ngayun chjihndun? Na lihndi vë ne, hacuiin cahme na ta jiñafë na. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sehe ngajan xi xuta xi siu jan ne, tu vejnucjëë me tsëhë cjua xi cachja Jesús. Sehe ngajan xi Jesús ne, catsitëë me xuta xi siu jan candatsen. Hane suva ni nahmi rë nima quihndi cojo naa rë cojo cha xi ticojo me cavisehen me cojo hiscan jiña. ");
INSERT INTO maqNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sehe cafaha me tsja nima quihndi jan ne, sehe cachja me cojo cuitjin: ―‍Talita cumi ―‍cjua xi meje cuichja: Tichjá cojo ri, tsan, tisatjinhngue. ");
INSERT INTO maqNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Xi cafë cachja Jesús cuatjin ne, cavuya cjuahñu rë na lihndi jan hacuaha ngutjen ni cavisatjenhnga na catsujyihiya na. Na lihndi jan ne, tejó nu tjin rë na. Hane me xi siu jan ne, jercu quijircun camahani rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Hya xi camá ne, jemu cachja camahani Jesús cojo xuta rë na xi tsajin yo cuichja me cojo xcusun jan. Hacuaha cachja me cojo xuta rë na xi sua me xi sinë na. ");
INSERT INTO maqNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hya xi cavetju Jesús tsëhë Capernaum ne, cavuya cafe me cojo cha ladu rë me nandya Nasaret, hiscan xi camacha me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hya xi cavechu nixtin xi chjahájenda rë ne, cavetsihin cavicuya me xuta ngajan yungun. Hane xutacjín xi tivisiñuju cjua rë Jesús jan ne, jemu quijircun rë me. Sehe cachja me ngajñi rë me cuitjin: ―‍¿Jani cavutaya cha xi cuijyihi vi cjua xi tichja cha? Jemu tjin rë cha cjuatacun. Hacuaha jemu yehe cjuarcun sahmi cha. ");
INSERT INTO maqNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Há hyan ngayaan xi cha vihi xi chjineya jan ni, cha xi quihndi rë na María. Hntsë cha ne, hacui cha Jacobo, cha José, cha Judas cojo cha Simón. Hacuaha nandya naja tacun ndava tíchja cha. Hane jemu xti rë xuta jan, tsëhë xi ha vëë me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Vëhë xi Jesús ne, cachja me cojo xuta jan cuitjin: ―‍Xuta ne, ha tuxa faharcun me ngu xihin xi suacuenda cjua rë Nina. Suva ni xuta rë xihin jan cojo xuta xi tangun nangui rë cojo, me vëhë xi faharcuaain me xihin jan. ");
INSERT INTO maqNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ngajan ne, hacuiin cjín cjuarcun casahmi me, tsëhë xi macjaain rë xuta me. Tu cavisanetsja ni me ngujo xuta hmu rë, hane camandaja xuta hmu rë jan. ");
INSERT INTO maqNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hane Jesús ne quijircun rë me ta, tsëhë xi xuta jan ne, cuatjin camacaain rë me. Hane sehe quiji catsujyihiya Jesús nandya tahndee rë jan, cavicuya me xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sehe casahmitangun me cha xi tejó jan hane cavetsihin catsingatju me jo jo cha jima ngu ladu. Hacuaha casua me cha ngahñu xi cuma cuaxëxin cha xitsehen. ");
INSERT INTO maqNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hacuaha cachja me cojo yëjë ni cha xi tsajin mé xi cjuaha cha xi cjue cha. Suva ni ngu ya xi cuisecoo rë cha. Hacuiin niñu ne, hacuiin morra, hacuiin xi tujún. ");
INSERT INTO maqNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Chuxinxtë ni catincha ntsacu cha. Hacuaha cuaain cha chingá. ");
INSERT INTO maqNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ngajan xi cachja me cojo yëjë ni cha cuitjin: ―‍Hya xi cjuhun ngu ndihya ne, xi cuisuhun ne, ha ngajan ni tinechun nguixun nguixun ni hisca xi cuetjun tsëhë nandya hiscan xi casatë nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tuyani ni xi tsingatiin nuju me hacuaha hisca cuisiñijii me tsujun ne, tetjun tsëhë ngajan ne, titsunu chojo rë ntsacu. Vëhë cuma ngu seña tsëhë jyë́ rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xi cajnetaha cachja Jesús cuatjin ne, sehe cavetju cha quiji cha hiscan xi casatë rë cha. Cachja cha cojo xuta xi tsindeya me cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hacuaha jemu cjín xitsehen cavaxëxin cha. Hane xuta hmu rë ne, aceite tsëhë tuxine xi hmí olivu catsufë cha xten me hane camandaja me jan. ");
INSERT INTO maqNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Me xi matitjun xi hmí rë Herodes ne, cahndë me cjua tsëhë Jesús, tsëhë xi xuta ne, jercu cachja me tsëhë Jesús. Hane ngujo me ne, cuitjin cachja me: ―‍Nima Juan, cha xi cavitenda rë xuta ne, ha ndasa cahme cha, peru cavascaya rë cha. Vëhë xi ma sahmi cha cjuarcun. ");
INSERT INTO maqNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hane ngujo nga me ne, cachja me ta Jesús ne, hacui rë Elías, ngu xutachanga xi casuacuenda cjua rë Nina hatsëë. Hane cachja sa yahnga me ta Jesús ne, hacui rë ngu profeta, sacuaha me xi casuacuenda xutachanga xi caviyuju titjun. ");
INSERT INTO maqNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Peru Herodes ne, hya xi cahndë me cjua vëhë ne, sehe cachja me ta: ―‍Nima Juan má me. Catsingátju catisun rë rcu cha, hane cavuya rë cjuahñu rë cha. ―‍Cuatjin cachja Herodes. ");
INSERT INTO maqNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes ne, ha catsingatju me cachjaha rë cha Juan xi cjue cha ndavaya. Cuatjin casahmi me ngatsë rë na Herodía. Na vëhë cafaha Herodes, camá chjuun rë me ha ndasa xi ha chjuun rë cha Felipe hntsëjñu me má na. ");
INSERT INTO maqNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Hane ngatsë rë vëhë, cuitjin cachja cha Juan cojo rë me: ―‍Chja ley ta ndajintjin camahani xi chjahan chjuun rë xingueen. Vëhë xi ngayun ne, ndajintjin xi cuatjin canihñu. ―‍Cuatjin cachja cha Juan. ");
INSERT INTO maqNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ngajan xi na Herodía ne, caveyacacun na cavutsejen na cha Juan. Hane meje rë na xi cueya cha. Peru camaji ta tsëhë xi ");
INSERT INTO maqNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes ne, cafaharcun me cha, tsëhë xi vëë me ta Juan ne, ngu xihin xi tyjahi cjuatacun rë cha, hane cavéjña cha tsëhë Nina. Hane vëhë xi casahmi me cha cuidadu. Hacuaha hya xi Herodes cavisiñuju me cjua rë cha Juan ne, jercu cachuya rë me ha ndasa casecjan cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Peru casacu rë na Herodía cahndë́ tsëhë xi meje rë na hya xi cavechu nixtin tsëhë suhi rë Herodes. Hya cachja Herodes cojo ngujo xutaxa rë ndihyavasen cojo me xi matitjun tsëhë sindadu, cojo sa ngujo xuta changá xi matitjun tsëhë distritu Galilea, xi cjue me ta casehenchjine ngu comida tsëhë suhi rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hane hora xi tijinë me ne, cavisehen na quihndi rë na Herodía, catë na. Hane jercu cachuya rë Herodes cojo me xi yahnga jan hacutjin catë na. Sehe ngajan xi Herodes, me xi matitjun jan ne, cachja me cojo na cuitjin: ―‍Tu mé ni xi meje ri ne, chjahye ná, hane suá ri. ");
INSERT INTO maqNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Vëë Nina jain ta suá ri hisca vasentjin nandya xi siu ntsa. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Xi tu cavetju na quiji na hiscan tacun naa rë na ne, cavinenguise na cuitjin: ―‍¿Mé xi ndatjin cjuéhya rë me? Sehe ngajan xi chja naa rë na ta: ―‍Chjaye rcu cha Juan, cha xi vitenda rë xuta. ―‍Cuatjin cavinchangui naa rë na na. ");
INSERT INTO maqNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Xi tu cavuya cavisehen na hiscan tacun Herodes ne, ngajan xi cachja na cuitjin: ―‍Meje ná xi ngutjen ni ne, cahntsua ngu tyuva ne tuhun ná rcu cha Juan. ―‍Cuatjin cachja na quihndi jan. ");
INSERT INTO maqNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ngajan xi Herodes ne, jemu choho camá rë me peru tsëhë xi hisca Nina caveyanangui me xi casua me cjua rë me, hacuaha tsëhë xi yëjë ni amigu rë me cahndë me cjua jan, vëhë sahmi xi má sava rë me tsindeya me cjua rë me cojo na. ");
INSERT INTO maqNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ngajan xi Herodes ne, ngutjen catsingatju me ngu sindadu hiscan jiya cha Juan. Hacuaha cavitexa me xi cuinduva cojo cha rcu cha Juan. Sehe ngajan xi cha sindadu jan ne, quiji cha ndavaya, cavatësun cha rcu cha Juan. ");
INSERT INTO maqNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sehe caveya cha cahntsua tyuva, quijicojo cha. Xi cafehe cha cojo ne, casua cha na quihndi rë na Herodía. Hane sehe casua na naa rë na. ");
INSERT INTO maqNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sehe hya xi cahndë cha ladu rë cha Juan tsëhë mé xi cavatju cha cama ne, sehe quiji cha cafaha cha nima caveyaniji cha. ");
INSERT INTO maqNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hya xi cajnetaha catsujyihiya cha apóstol xi catsingatju Jesús jan ne, cavuya camatangun nga cha cojo me. Sehe cachja cha hacutjin casahmi cha hacuaha hacutjin cavicuya cha. ");
INSERT INTO maqNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sehe ngajan xi Jesús ne, cachja me cojo cha cuitjin: ―‍Nduvun suvun ni ne, cuanguen hiscan xín, chjahanjeyan hitsë. Cuatjin meje cjue cjuahajeya me ta tsëhë xi jemu cjín xuta xi cjui nduva me hiscan tacun Jesús. Hisca maxatiin jinë me niñu. ");
INSERT INTO maqNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sehe quiji me cojo cha ladu rë me cojo barcu ngajan hiscan xín. ");
INSERT INTO maqNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Hane xuta jan ne, cavëë me xi cjui me cojo cha ladu rë me. Hacuaha vëë me xi hacui Jesús. Sehe xuta tsëhë nandya tahndee jan ne, cavanga me quiji me taha vëhë. Hisca tjun sa me cafehe me, sehe cafehe Jesús cojo cha ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Xi tu cavetju Jesús tsëhë barcu jan ne, cavëë me xi jemu cjín xuta siu me. Hane camayuma rë me xuta jan ta tsëhë xi siu me sacuaha chu tsánga xi tsajin yo xi cjuahacuenda rë chu. Sehe cavetsihin cavicuya me xuta jan, jemu cjín cjua cavicuya me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hya xi ha quiji hora jan ne, ngajan xi cachja cha ladu rë me cojo me ta: ―‍Nguehe ne jemu xín camahani. Hacuaha jemu quiji hora. ");
INSERT INTO maqNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ninguijnutuhun cjua cojo xutacjín vi cojo sa xi catji me nandya xi siu tiñataha, hane catatsë me xi sinë me. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hane cuitjin cafayangui Jesús: ―‍Tuhun ngayun xi sinë me. Sehe ngajan xi cachja cha ladu rë me cuitjin: ―‍¿Hacutjin sacú niji xi sinë me xi cuarcu cjín me? Xi cuatjin cjín pan chihin ne, meje miji chji rë jo cientu mosu. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sehe cachja Jesús cuitjin: ―‍Tangun chutsujun ¿há cjín pan tjin ngajñi nuju ngayujun ni? Xi tu cavëë cha há cjín pan tjin ra ne, sehe cachja cha cojo me cuitjin: ―‍Hñú pan, cojo jo ti má. ");
INSERT INTO maqNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sehe ngajan xi cachja Jesús cojo cha ta catichja cha cojo xuta, catiyuju me xcun ndiji, ngujo ngujo me ngu ngu cahndë́. ");
INSERT INTO maqNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hane caviyuju me ngu cientu me ngu cahndë́, o vasen cientu ngu cahndë́ hisca xi cafë yëjë me caviyujuchihin me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sehe Jesús ne, cafaha me xi hñu pan cojo jo ti jan, cavutsejenniji me ngahnga ne, casua me nacuechji rë Nina, sehe cavotoho langa me pan jan. Hane casua me cha ladu rë me xi sua cha sinë xuta. Hacuaha cojo catsijo ti jan cavatëcja Jesús xi sinë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jercu caxuva pan cojo ti jan. Hane yëjë ni me cajinë me hacutjin xi cachuya rë xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Xi cavatju cajinë xuta jan ne, sehe cafaya cha pan cojo ti xi cafiin jan ne, hane catsinguitsë cha tejó chajne cojo. ");
INSERT INTO maqNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Me xi cajinë pan jan ne, hñu mil má me xi xihin. Hacuaha xin má yachjin cojo langa xi cajinë me. ");
INSERT INTO maqNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ngajan xi Jesús ne, catsingatju me cha ladu rë me cojo barcu jan xi cjue titjun ni cha ngunda vëhë, hiscan nandya Betsaida, jinguyëjë rë xi tsinguijnetaha me cjua cojo xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hya xi camá catsinguijnetaha me cjua jan, sehe camiji me ngu ndetjún xi cuisiajmi me cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hane hora xi camá nguixun ne, barcu jan ne, vasencja laguna cjui. Hane Jesús ne, tacun suva cuaha me nangui quixí. ");
INSERT INTO maqNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hacuaha cavutsejen me ta jemu chja tivatju cha xi cjui cha cojo barcu, tsëhë xi tjo ne, taha hiscan cjui cha ne, ngajan nduva. Hane xi tiña sahasen ne, camatiña Jesús tsëhë cha, cjui me xcun nandan. Hane cuatjin cjui me sacuaha xi meje cuatjutaha me cha. ");
INSERT INTO maqNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Xi tu cavëë cha xi cjui me xcun nandan ne, catsingatahacacun cha ta nima xi meje cuincharcun rë cha. Hane jercu cajindayatë cha, ");
INSERT INTO maqNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tsëhë xi catsacjun cha xi cavëë cha me. Hane ngutjen ni cachja Jesús cojo cha cuitjin: ―‍Xi carcuun. ");
INSERT INTO maqNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hane sehe cavisehen Jesús barcu hiscan siu cha. Hora vëhë ne, casejyu tjo. Ngajan xi jemu quijircun camahani rë cha ta, ");
INSERT INTO maqNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ha ndasa cavëë cha cjuarcun xi casahmi Jesús cojo pan jan ne, peru cajnii rcu cha, tsëhë xi vechiin cjuatacun rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Xi quiji sa me cojo barcu ne, cafehe me tjehen laguna, tiña nandya xi hmí Genesaret. Hane ngajan catsihñu me barcu. ");
INSERT INTO maqNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hya xi cavetju Jesús tsëhë barcu ne, cavëë xuta ta hacui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hane xuta jan ne, marcu macjain quiji me yëjë ni ladu tsëhë nandya jan, xi quiji jaha me xuta hmu rë, caviyuju me xcun Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hane tuyani ni xi quiji Jesús, há nandya langa ne, há nandya hñu, o há xi ranchun, caviyuju me xuta hmu rë hiscan ndetsin. Sehe cafehya me cojo Jesús xi ndastu satëtaha xuta hmu rë jan tsjian rë Jesús. Hane yëjë ni xuta hmu rë xi casatë tsjian rë Jesús ne, camandaja me. ");
INSERT INTO maqNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ngujo cha tsëhë partidu fariseo cojo ngujo cha maestru tsëhë ley ne canduva cha tsëhë nandya Jerusalén quiji cha ngajan hiscan tacun Jesús, ngajan camatangun cha. ");
INSERT INTO maqNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Xi cafehe cha ngajan ne, cavëë cha xi ngujo cha ladu rë Jesús ne tjin sa jyë́ rë tsja cha ne, tijinë cha niñu ta cavanii cha tsja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hane cachuyiin rë cha ta tsëhë xi ngayëjë ni xuta nangui niji ne, sahmi ngujyë xi cuane me tsja me sehe sinë me niñu. Yaha me xcusun rë xutachanga niji. ");
INSERT INTO maqNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hacuaha hisca sa xi fehe me xi fi me ndetsin ne, sá xi cjëë cuane me tsja me ne, sinii me niñu. Hacuaha jemu cjín sa xcusun rë xutachanga niji xi yaha me ta sacuaha xi ha tyjahi trasti ne, cuane nga me. Hacuaha cuanitjin sahmi me cojo nachan. ");
INSERT INTO maqNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ngajan xi cha tsëhë partidu fariseo cojo cha maestru tsëhë ley ne, cachja cha cojo Jesús cuitjin: ―‍¿Mé má cuatjin sahmiichiin cha ladu nuju ley rë xutachanga naja? ta, tsëhë xi vanii cha tsja cha xi jinë cha niñu. ");
INSERT INTO maqNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ngajan xi cafayangui Jesús cuitjin: ―‍Ngayun ne, jo xcun jo ntsuvun yun. Jemu quixi cjua xi catsihindu Isaías tsujun xcun xujun rë me sacuatjin cachja Nina xi xuta ne, jemu ndacha me. Cuitjin fi cjua jan: Xuta xi cuicun vi ne, ndaja chja me tsahan, peru xi cojo xahasen rë me ne, hisca tsinguitsjiin me ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tu mahya xi faharcun ná me ta xi vicuya xicjin me ne, hacuiin cjua naha cuicuya me ta, tu cjua rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Cuanitjin ngayun ta nismutacun cjua rë Nina, hane hitsë sa tivetuhunrcun xcusun rë xutachanga naja. ");
INSERT INTO maqNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cachja sa me cuitjin: ―‍Xi má nuju ne, jemu ndatjin casacuse nuju hacutjin vejñuxun cjua rë Nina cojo sa xi nihñuchuhun xcusun rë xutachanga naja. ");
INSERT INTO maqNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés ne, cuitjin catsihindu me hacutjin xi cachja Nina xi nihña ngayaan xuta rë me: “Chjuhunrcun ná nuju, chjuhunrcun nahmi nuju”, hacuaha: “Yo xi choho chja tsëhë xutacha rë ne, xuta ne tsiquehen rë.” ");
INSERT INTO maqNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Peru ngayun ne, cjuatacun rë xutachanga naja vicuyun ta, nújun ta ngu cha ne cuma cuichja cha cojo xutacha rë cha cuitjin: “Ha quihndë cumaji cuisecoo nuju ta yëjë ni xcusun xi tjin ná ne, ha cavejñá tsja Nina.” ");
INSERT INTO maqNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Hane xi cuatjin cuichja cha ne, ha quihndë sahmii ngujyë xu xi cuisecoo cha xutacha rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Xi cuatjin ne, ha camachjiriin nuju cjua rë Nina ta, nihñu sacuaha xcusun rë xutachanga naja, hacuaha vicuyun rë jingu sa. Hacuaha cjín sa xcusun ndacha sacuaha vëhë nihñu. ―‍Cuatjin cachja Jesús cojo maestru jan. ");
INSERT INTO maqNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hacuaha cajindaya Jesús xuta xi cumatangun me. Hya xi camá ne cuitjin cachja me cojo: ―‍Ngayujun ngarcun ni ne, tinuhyun cjua xi cuichjá vi. ");
INSERT INTO maqNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Xcusun xi vixuya cahntsua xuta ne, hacuiin vëhë tsitsehen rë me ta, cjuatacun xi nduva rë me ne, vëhë tsitsehen rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jarë ngayun xi meje nuju xi cumá nuju ne, tetuhunrcun. ");
INSERT INTO maqNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Xi cavatju cachja me vëhë ne, caviyuju xuta ngajan ne, sehe cavisehen me cojo cha ladu rë me cahntsua ndihya. Ngajan xi cha ladu rë me ne, cavinenguise cha me tsëhë cjua vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ngajan xi cachja me cuitjin: ―‍¿Há hisca ngayun cajnii rcun cjua xi cachjá ni? Nguehe cuichjá cojo nuju mé vijne cjua vëhë. Cuma xinëë yëjë xcusun comida ta tsajin ngu xcusun xi jinë xuta xi cuma tsitsehen rë me ");
INSERT INTO maqNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ta xi sinë me ne, hacuiin cahntsua xahasen rë me cjui ta cahntsua me. Fi ne vetjutaha ndatsen. ");
INSERT INTO maqNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hacuaha cachja sa Jesús cuitjin: ―‍Cjuatacun xi nduva tsëhë xahasen rë xuta ne, vëhë tsitsehen rë me ta, ");
INSERT INTO maqNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","tsëhë xi xi nduva tsëhë xahasen rë me ne, cjuatacun tsehen, sacuaha yachjin xi viteña yojo rë, sacuaha jyë́ tsëhë xi sahmi me chjuunnahñu rë me jingu sa chjuun, cojo cjuachëjë, cojo xi tsiquehen xicjin, ");
INSERT INTO maqNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cojo xi jercu meje rë me cjuanchina, cojo xi sahmi me cjuatsehen, sahmi me cjuandacha, choho sahmi me, tjin rë me cjuaxin, sahmi me cjuachjataha, tjin rë me cjuaxihin, sahmi me cjuangarca. ");
INSERT INTO maqNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yëjë cjuatsehen xi cuacun vëhë ne, nduva tsëhë xahasen rë xuta, hane vëhë tsitsehen rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xi cavetju me tsëhë distritu Galilea, cafe me ladu tsëhë nandya Tiro cojo nandya Sidón. Xi cafehe me ngajan ne, cavisehen me cahntsua ngu ndihya, tsëhë xi mijí rë me xi scuëë xuta xi cafehe me. Peru camaji cavejñahma me. ");
INSERT INTO maqNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Xi cafehe Jesús ngajan ne, ngutjen camachaya rë naa rë ngu na xi jiya xitsehen cahntsua xahasen rë na. Hane quiji na cavixcuhnchi na xcun Jesús xi cjuaharcun na me. ");
INSERT INTO maqNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na vëhë jan ne, xutaxin na, na ladu tsëhë distritu Sirofenisia, hacuiin na xuta tjë rë Israel. Hane cafehya na cojo Jesús xi cuaxë me xitsehen xi jiya cahntsua xahasen rë na quihndi rë na. ");
INSERT INTO maqNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Hane xi cafayangui Jesús tsëhë na jan ne, cuitjin cachja me ngu ejemplu cojo rë na. ―‍Sechiye ni, catijnetaha catjinë nixti ta hacuiin ndatjin xi chjahatahan niñu tsëhë nixti hane sehe tahan rë naña. ");
INSERT INTO maqNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ngajan xi naa rë na hmu rë jan ne, cuitjin cajnercu na xi tichja me tsëhë xuta tjë rë Israel cojo xutaxin. Hane cafayangui na cuitjin: ―‍Nai. Quixi xi nújun, peru naña xi siu ngahma maxë ne, sacu xi vixuhya hntsua nixti, sehe jinë chu. ");
INSERT INTO maqNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hane sehe cachja Jesús cojo rë na cuitjin: ―‍Ndatjin xi canoje. Quihndë ta cuatjin ne, cuma cjuihin ta xitsehen xi caseya cahntsua xahasen rë na quihndi riji ne, ha cavetjuxin. ");
INSERT INTO maqNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Xi cavuya cafe na ndava na ne, quihndi rë na ne, ha jyuu jiña na hacuaha xitsehen xi caseya cahntsua xahasen rë na ne, ha cavetjuxin. ");
INSERT INTO maqNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sehe cavetju Jesús ladu tsëhë nandya Tiro, cavatju me nandya Sidón cojo ladu xi hmí Të Nandya, vëhë cafehe me laguna tsëhë Galilea. ");
INSERT INTO maqNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hane cafehecojo nga xuta ngu cha xi loho hacuaha lihmi cha. Hane cafehya xuta jan cojo Jesús xi cuetahatsja me cha, sehe cumandaja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ngajan xi Jesús ne cavaxëxin me cha tsëhë ngajñi rë xuta ne, sehe caviyujutaha me rcu tsja me ngu ngu ladu ngojo tyjavañuju cha. Hane hacuaha cavëhënatya me rcu tsja me sehe cavetaha me neje cha. ");
INSERT INTO maqNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hya xi camá ne, cavutsejenniji me ngahnga hane cafëcacun me. Sehe cachja me cuitjin: ―‍¡Efata! ―‍cjua xi meje cuichja: ¡Nuxuhunyun! ");
INSERT INTO maqNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hane xi tu cachja me cuatjin ne, catuxaha tyjavañuju cha xi loho. Hacuaha hora vëhë ni ne, camá ndandaja cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sehe ngajan xi cachja Jesús cojo xuta xi tsajin yo cuichja cojo me xcusun vëhë. Peru xuta jan ne, hitsë sa jercu cachjatë me tsëhë xcusun xi casahmi Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jercu quijircun camahani rë xuta. Cuitjin cachja me: ―‍Tu mé xcusun ni jercu ndaja sahmi Jesús. Xuta xi loho ne, vihndë sahmi me, hacuaha xuta xi lihmi ne, sahmi me xi ma chja. ");
INSERT INTO maqNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nixtin hya ne, hacuaha jercu cjín xuta siu me hisca tacun Jesús. Hane tsëhë xi tsajin camahani mé xi sinë me ngajan ne, vëhë xi Jesús ne, cajindaya me cha ladu rë me, sehe cachja me cojo cha cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―‍Jemu yuma má ná xutacjín vi ta ha quihndë jyan nixtin hinchataha me cojo naja, hane ha quihndë tsajin camahani mé xi sinë me. ");
INSERT INTO maqNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sá xi tsingátju me cjue me xi cjëë sinë me niñu ne, cjuaha rë me hinda ndiya. Ngujo xuta xi cuicun vi ne, jemu cjin canduva me. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sehe ngajan xi cha ladu rë me ne, cafayangui cha tsëhë me cuitjin: ―‍¿Jani cuma sacú naja xi sinë xuta vi ta nguehe ne, jemu xín camahani tsëhë nandya? ");
INSERT INTO maqNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ngajan xi cavinenguise Jesús cojo cha cuitjin: ―‍¿Há cjín pan tjin nuju? Ngajan xi chja cha ta: ―‍Yatu má. ");
INSERT INTO maqNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ngajan xi Jesús ne, cavitexa me xutacjín jan xi cuiyuju me nangui. Xi cafë xuta caviyuju me nangui ne, sehe cafaha Jesús pan jan sehe casua me nacuechji rë Nina. Hane cavotoho langa me pan jan, casua me cha ladu rë me xi cuiyuju cha sinë xutacjín jan. Hane cuatjin casahmi cha. ");
INSERT INTO maqNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hacuaha tjin ra ngujo ti. Hane Jesús ne casua me nacuechji rë Nina tsëhë ti jan, hane sehe cachja me cojo cha ladu rë me xi sua cojo ti jan sinë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Xi camá cajinë xuta jan ne, jemu ndaja camá rë xahasen rë me. Hane xi cafaya cha ladu rë Jesús xi cavangui cajinë xuta jan ne, catsë yatu nisinya. ");
INSERT INTO maqNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Xuta jan ne, sacuaha chuva rë ñuju mil má me. ");
INSERT INTO maqNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Hane hisca xi cajnetaha cjuandaja vëhë ne, sehe catsingatju Jesús xuta, cafe xuta ndava me. Hya xi camá ne, cavisehen me barcu cojo cha ladu rë me, hane cavuya me ngunda vihi taha ladu rë hiscan xi hmí rë Dalmanuta. ");
INSERT INTO maqNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Xi cafehe me ngajan ne, hacuaha cafehe cha tsëhë partidu fariseo. Hane cavetsihin cha cavisiajmi cha cojo Jesús ta meje cjuahachuva cha me. Cafehya cha cojo rë me xi tsingacun me ngu cjuarcun xi nduva ngahnga, cojo sa xi scuëë cha xi Nina catsingatju jain rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ngajan xi Jesús ne, cojo cjuachohotacun ne, cachja me cojo cha cuitjin: ―‍¿Mé má cuatjin chjahyun xi sahme ngu cjuarcun xi nduva ngahnga? Cuichjá quixë cojo nuju ta hisca ngu xcusun vëhë ne, sahmee xi xcun cojo xcun. ");
INSERT INTO maqNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ngajan xi caviyuju me cha xi cuacun jan ne, cavisehen me barcu cojo cha ladu rë me. Hane sehe cavuya quiji me ngunda vëhë tsëhë laguna. ");
INSERT INTO maqNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Peru cha ladu rë me ne, cachaya rë cha xi cjuaha cha pan, hane cahntsua barcu ne, ngu tutu sa pan jiya ndaja. ");
INSERT INTO maqNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sehe ngajan xi chja Jesús cojo cha cuitjin: ―‍Nechun cuidadu cojo san rë pan tsëhë cha tsëhë partidu fariseo cojo cha ladu rë Herodes. ");
INSERT INTO maqNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Sehe ngajan xi cavisiajmicjín cha ngajñi rë cha cuitjin: ―‍¿Há tsëhë xi tsajin naja pan ne, há tsëhë vëhë xi cuatjin chja me? ");
INSERT INTO maqNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Xi camachaya rë Jesús xi veyanangui cha xi tsajin rë cha pan ne, cachja me cojo cha cuitjin: ―‍¿Mé má cuatjin nújun xi tsajin pan? ¿Há nuhyuun? ¿Há vijnii rcun? ¿Há jemu taja rcun? ");
INSERT INTO maqNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tjin nuju túxcun hacuaha tjin tyjavañuju. ¿Mé má matsijin nuju? hacuaha ¿mé má nuhyuun? ¿Há vitsjiin nuju? ");
INSERT INTO maqNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Hya xi cavótoho langa hñú pan ngajñi rë xi hñú mil xuta, ¿há cjín chajne sa quitsë cachjayun tsëhë pan xi cavangui jan? ―‍Cuatjin cavinenguise me. Ngajan xi cafayangui cha ladu rë me ta: ―‍Tejó. ");
INSERT INTO maqNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―‍Hane hya xi cavótoho langa yatu pan jan xi cajinë ñuju mil xuta, ¿ha cjín nisinya sa cavangui? Ngajan xi cha ladu rë me ne, cuitjin cachja nga cha: ―‍Yatu. ");
INSERT INTO maqNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ngajan xi cavinenguise Jesús cojo cha cuitjin: ―‍¿Há cjëë camahani cuijne rcun cjua xi cachjá tsëhë san rë pan? ");
INSERT INTO maqNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hya xi camá ne, cavechu barcu tjehen laguna. Hane xi cavitujne me barcu ne, cafehe me nandya xi hmí Betsaida. Xi cafehe me ngajan ne, cafehe nga xuta cojo ngu cha xi rcá. Hane jercu cachja xuta jan cojo Jesús xi cuetahatsja me cha, hane sehe cumatsejen rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hya xi camá ne, cafaha me tsja cha hane quijicojo me cha ngajan tjehen nandya. Xi cafehe me cojo cha ngajan ne, cavëhë natya me tuxcun cha hacuaha cavetahatsja me tuxcun cha, sehe cavinenguise me cha cuitjin: ―‍¿Há tsejen ri hitsë quihndë? ");
INSERT INTO maqNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Xi catsiquijin cha xcun cha cavutsejen cha ne, chja cha ta: ―‍Vutsejen xuta. Peru sacuaha tsejen ya, cuatjin tsejen me xi cjui me. ");
INSERT INTO maqNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ngajan xi Jesús ne, cavetahatsja nga me tuxcun cha. Sehe casahmi cha ngujyë cavutsejen ndaja cha, hane camandaja cha, camatsejen ndaja rë cha. Hane sehe catsingatju me cha cafe cha ndava cha. ");
INSERT INTO maqNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hacuaha cachja me cojo cha cuitjin: ―‍Xi cavisiin ngajñi nandya xi cuinoje cojo xuta jan xcusun xi casahme cojo ri. ");
INSERT INTO maqNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Hya xi camá ne, cavetju nga Jesús tsëhë ngajan cojo cha ladu rë me ne, quiji me ngujo nandya xi siu tahndee rë nandya xi hmí Cesarea Felipe. Hane ndiya jiya me cojo cha ne, cavinenguise me cha cuitjin: ―‍¿Mé chja xuta, yo ngahan? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ngajan xi cafayangui cha ladu rë me cuitjin: ―‍Ngujo me ne, chja me ta ngayun xi cha Juan ngayun, cha xi cavitenda rë xuta. Ngujo nga me ne, chja me ta Elías. Hane ngujo nga me ne, chja me ta ngu profeta xi suacuenda cjua rë Nina. ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ngajan xi cachja nga Jesús cojo cha ta: ―‍Hane ngayun ne, ¿mé nújun? ¿Yo ngahan? Ngajan xi cha Pedru ne, cuitjin cafayangui cha: ―‍Ngayun xi tjin cjua xi tsingatju nuju Nina. Ngayun xi Cristu. ");
INSERT INTO maqNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ngajan xi Jesús ne, cavitexa me cha ta tsajin yo xi cuichja cha cojo tsëhë. ");
INSERT INTO maqNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hya xi camá ne, cavetsihin cavicuya me cha tsëhë xi ha ndasa xi Cristu, Quihndi rë Xuta Jain má me ne, peru jemu cjín cjuañihi cuatju me cumá ta tsingatiin xuta changá me, hacuaha tsiquehen xuta changá jan me, peru xi cjuë jyan nixtin ne, cuya nga me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cjua vëhë ne cachja quixi camahani me cojo cha. Ngajan xi cha Pedru ne, quijixin cha cojo Jesús. Sehe cavetsihin cachja cha cojo me xi ¿mé má cuatjin chja me? ");
INSERT INTO maqNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngajan xi cavuya Jesús cavutsejen me hiscan siu cha ladu rë me. Sehe cachja me cojo cha Pedru cuitjin: ―‍Tihinxin ngaye Satanás, tsëhë xi ningatiintacuin ngaye sacuaha tsingatahacacun Nina ta, ningatehetacuin sacuaha ngu xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ngajan xi Jesús ne, cajindaya me xutacjín jan cojo cha ladu rë me xi cuinduva me hiscan tacun Jesús, sehe cachja me cuitjin: ―‍Sá xi tjin yo xi meje cuisehen ladu naha ne, meje rë xi nichuvun cjuatacun nuju, hane hacuaha tejñuhñu xahasen nuju xi cuanguncujun ndiya naha handasa xi cueyun xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yo ngayun xi mijí cuisuhun ladu naha tsëhë xi rcun xi cueyun ne, cahndë́ xi ndaja ne, nichujun xahasen nuju. Peru yo ngayun xi ngatsë naha o sá xi ngatsë rë cjua rë Nina cueyun ne, hacuiin nichujun xahasen nuju ta Nina ne, cuaxëtje me. ");
INSERT INTO maqNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mé ndaja cuma nuju xi sacu nuju yëjë xi tjin ngasunhndë, sá xi cueyun hane cuma nuju castigu, ");
INSERT INTO maqNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ta sá xi cuaxintiin Nina xahasen nuju hya xi cueyun ne, ha quihndë tsajin rqui rë. ");
INSERT INTO maqNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yo ngayun xi ma sava nuju ngatsë naha o sá xi ngatsë rë cjua naha nguehe xcun xuta tsehen xi manguaaincacun cojo cjua rë Nina ne, hacuaha cojo ngahan xi canduvá tsëhë Nina ne, cuma sava ná ngahan ngatsë nuju ngayun, hya xi cuinduvá cojo cjuandajyihi tsëhë nahmi naha ne, hacuaha cojo ángel xi vejña tsëhë Nina cuinduvá cojo. ");
INSERT INTO maqNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hacuaha cachja sa Jesús cuitjin: ―‍Cuichjá quixë cojo nuju ta tecjan yahnga xuta nguehe xi hisca xi scuëë me xi cuitexa jain Nina ne, sehe cueya me. ");
INSERT INTO maqNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Xi cafë jyun nixtin jan ne, quijixin Jesús ngu rcu naxi hnga cojo cha Pedru cojo cha Jacobo cojo cha Juan. Xi cafehe me cojo cha ngajan ne, cavëë cha xi cavindeya xcusun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tsjian rë me ne, ña seti tsejen, tsëhë xi jercu tu tyava camahani, hisca xi ngu xuta cumaji cuane me xi cuatjin tyava. ");
INSERT INTO maqNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hya xi camá ne, ha tu ñahñu camatsejen hasen rë Elías cojo hasen rë nima Moisés, tivisiajmi cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ngajan xi cachja cha Pedru cojo Jesús ta: ―‍Maestro, tu ma rë xi nguehe nechin cojo nuju ne, nihñi jyan puestu: ngu tsujun ne, cojo ngu ngu tsëhë Moisés cojo Elías. ");
INSERT INTO maqNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Cuatjin cachja cha Pedru ta, sacuinyiin rë cha mé sa cuichja cha ta tsëhë xi jercu catsacjun camahani cha camá. ");
INSERT INTO maqNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hora vëhë ne, canduva ngu yufí casahmi tjahnguen rë. Hane ngajñi rë yufí jan ne, canuhya rë ngujo cjua xi cachja cuitjin: ―‍Cha vihi xi quihndi naha cha. Jercu hmucacun cha. Tinuhyun xi chja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Xi tu cahndë cha ladu rë Jesús cjua vëhë ne, vutsejen nguehe vutsejen ngajan cha, hane suva sa Jesús tacun me xi cavëë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Xi tu tivitujne me tsëhë rcu naxi jan cojo cha ladu rë me xi quijicojo me jan ne, ngajan xi chja xu me cojo cha ta tsajin yo xi cuichja cha cojo xcusun xi cavëë cha. Xi cuatju cueya Quihndi rë Xuta Jain ne, cuya nga me cjuahñu, sehe hya cuichja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Vëhë xi cavaha cha cjua jan cahntsua xahasen rë cha. Ngajñi rë ni cha cojo xicjin cha cavisiajmicjín cha ¿mé vijne cjua xi cuya nga me cjuahñu? ");
INSERT INTO maqNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ngajan xi cavinenguise cha cojo Jesús cuitjin: ―‍¿Mé má cuatjin chja maestru tsëhë ley xi titjun Elías cuinduva me, sehe cuinduva me xi cuaxëtje naja? ");
INSERT INTO maqNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ngajan xi cafayangui Jesús cuitjin: ―‍Quixi xi Elías cuinduva me titjun ta, me vëhë cuiyujuchihin me yëjë ni xcusun. Peru ha canduva me, handasa hacuiin cojo ñihi rë me ta cojo ñihi rë cha Juan. Hane choho casahmi xuta cojo me sacuatjin chja xujun rë Nina. Hacuaha chja xujun xi cuacun vëhë ta handasa xi Quihndi rë Xuta Jain ngahan ne, hacuanitjin ne jemu jyë cjuañihi cuátju hacuaha tsitjungui xuta ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Xi tu cavuya cafehe Jesús cojo cha xi quijicojo me hiscan siu yahnga cha ladu rë me xi tejó jan ne, cavëë me xi tjercu siu xuta jan cojo ngujo cha maestru tsëhë ley siu me visiajmi me cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Xi tu cavëë xuta jan xi cafehe Jesús ne, jemu quijircun rë me, vanga sanii me quiji cachja me nina cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ngajan xi Jesús ne, cavinenguise me cojo cha ladu rë me cuitjin: ―‍¿Mé xi visiajmu cojo xuta xi cuacun vë? ");
INSERT INTO maqNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Hane ngajan ngajñi rë xutacjín xi siu jan ne, cavetjujñi ngu me xi cachja me cuitjin: ―‍Maestro, canduvá cojo quihndi naha, tsëhë xi jiya xitsehen cahntsua xahasen rë cha. Hane tsëhë vëhë xi sahmi lihmi rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hora xi faha xitsehen jan cha ne, ngutjen tsiticjahñu rë cha, hacuaha vaxë natyaxu hntsua cha, hisca tsijanerii nehñu cha jiña cha. Hane ngatsë rë vëhë ne, jemu jima ndaya cha. Hacuaha cachjá cojo cha ladu nuju xi cuaxëxin cha xitsehen tsëhë quihndi naha. Peru camaji cavaxëxin cha. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ngajan xi Jesús ne, cachja me cojo xuta xi siu jan cuitjin: ―‍¿Mé camá nuju ngayun xi macjaain camahani nuju? ¿Há jyë sa nixtin meje rë xi cuitejña cojo nuju? Nduvun cojo cha nguehe. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hya xi camá ne, cafehe xuta cojo cha hiscan tacun Jesús. Xi tu cavëë xitsehen jan Jesús ne, marcu macjain catsiticja rë cha nixti jan. Hane xi caticja cha ne, cavuya cavindefa cha cafaña cha. Hacuaha cavetju natyaxu hntsua cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ngajan xi Jesús ne, cavinenguise me cojo nahmi rë cha cuitjin: ―‍¿Há tsëë xi cuitjin má rë cha? Ngajan xi chja nahmi rë cha ta: ―‍Hisca cjuaquihndi rë cha, cuatjin má rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Jiya hora xi faha xitsehen jan cha ne, tsingatjeya rë cha xcun ndacahi. Tjin nga ne, tsingatjenya rë cha ngajñi nandan, ta meje tsiquehen rë cha. Vëhë xi sá xi tsejen xi ha hyun mé nihñu cojo cha ne, catamayuma nuju ngahan cojo quihndi naha, hane tisecun niji. ");
INSERT INTO maqNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ngajan xi cachja Jesús cojo nahmi rë cha ta: ―‍Há xa vë xi hvë. Sá xi macjain nuju ne, yëjë ni ne, cuma. ");
INSERT INTO maqNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ngajan xi nahmi rë cha ne, ngutjen cachja me cuitjin: ―‍Tatá. Macjain ná. Peru tisecun ná cojo sa xi cumacjain sa ná. ");
INSERT INTO maqNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Xi vutsejen Jesús xi jercu tijima tangun xuta ne, cacjan me cojo xitsehen jan. Cuitjin cachja me: ―‍Ngaye xitsehen loho lihmi, tetjixin tsëhë cha vi. Hacuaha ha quihndë cuyiin cuisihin cahntsua xahasen rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ngajan xi xitsehen jan ne, hisca cajindaya xi catsicuya catsindefa rë cha. Sehe cavetju quiji. Hane cha vëhë ne, jiña cahme cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Peru Jesús ne, cafaha me tsja cha catsisatjenhnga me cha, hane casecun cha. ");
INSERT INTO maqNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hya xi camá ne, quiji Jesús cojo cha ladu rë me, hane cavisehen me cahntsua ndihya. Xi cavisehen me jan ne, sehe ngajan xi chja cha cojo rë me cuitjin: ―‍¿Mé má ngayin xi camaji canaxinxin xitsehen jan tsëhë cahntsua xahasen rë cha vë? ");
INSERT INTO maqNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ngajan xi cachja Jesús cojo cha cuitjin: ―‍Cuatjin camá nuju ta tsëhë xi xitsehen xi cuacun vë ne, meje rë xi titjun chjahyan rë Nina hacuaha cuinechan xun rë me, cojo sa xi cuma naxenxen. ");
INSERT INTO maqNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hya xi camá ne, sehe cavetju me quiji me taha distritu Galilea. Hacuaha mijí rë me xi cumachaya rë xuta jani taha tsujyihiya me ta, ");
INSERT INTO maqNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tsëhë xi tivicuya me cha ladu rë me hacutjin cuatju me cumá. Cuitjin cavicuya me: ―‍Ha ndasa tsëhë Nina canduva Quihndi rë Xuta Jain ne, peru cjuaha xuta me ne, tsiquehen me me. Peru xi cjuë xi jyan nixtin ne, cuya nga me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Peru cha ladu rë me ne, vijnii rcu cha tsëhë xi cueya Jesús, hacuaha cuya me cjuahñu. Hacuaha tsacjun cha cuinenguise cha me cjua jan. ");
INSERT INTO maqNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hya xi camá ne, cafehe me nandya Capernaum. Hya xi cafehe me jan ne, cavisehen me cahntsua ndihya hisca cuiyuju me. Sehe ngajan xi cavinenguise me cojo cha ladu rë me mé xi cavisiajmi cha cojo xicjin cha ngajan ndiya. ");
INSERT INTO maqNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Hane tu jyuu ni caviyuju cha ta xi cavisiajmi cha ndiya jan ne, cuitjin cachja cha: ―‍¿Jarë ngayaan xi hitsë sa venguichji naja? ");
INSERT INTO maqNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hya xi camá ne, quiji Jesús cavéjña me. Sehe ngajan xi cajindaya me yëjë tejó cha ladu rë me jan ne, sehe ngajan xi cachja me cojo cha cuitjin: ―‍Sá xi tjin ngu yun xi meje nuju xi cumatitjun ngayun ne, meje rë xi hacuiin jemu jyë nihñu yojo nuju hacuaha cuisecun xingun. ");
INSERT INTO maqNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hya xi camá ne, cafaha me ngu lihndi, cavejña me cavasencja, hane sehe cavataha me. Hane ngajan xi cachja me cojo cha cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―‍Jarë ngayun xi ndaja nihñu cojo ngu lihndi sacuaha vihi xi ngatsë naha ne, sacuaha xi ngahan ndaja nihñu cojo ná. Hacuaha jarë ngayun xi ndaja nihñu cojo ná ne, hacuiin ngahan ni ta, hacuaha cojo Nahmi naha xi catsingatju ná me, cojo me vëhë ndaja nihñu cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ngajan xi cachja cha Juan cojo Jesús cuitjin: ―‍Maestro, cahyin ngu cha xi tijima tivaxëxin xitsehen tsëhë xahasen rë xuta, hane xi sahmi cha ne, cojo ñihi nuju veyanangui cha. Peru tsëhë xi hacuiin cha ladu naja cha ne, canújin cojo cha ta ha quihndë sahmii cha cuitjin. ");
INSERT INTO maqNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngajan xi Jesús ne, cachja me cuitjin: ―‍Xi cavichecjiin tsëhë cha ta xuta xi cuma sahmi me cjuandaja vëhë, sacuaha xi ngahan jain cavitéxa rë me ne, cumaji xi ngutjen choho cuichja me tsahan. ");
INSERT INTO maqNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Xuta xi hacuiin choho vëë naja me ne, chuya rë me tsajan. ");
INSERT INTO maqNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Cuichjá quixë cojo nuju ta yo me xi sua ngu vasu nandá siuhun, tsëhë xi vëë me xi xuta ladu naha ngayun, hacuaha vëë me xi ngahan xi catsingatju ná Nina ne, me vëhë ne, sacu rë me ngu cjuandaja xi sua Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Peru yo xi nduvacojo xcusun xi sahmi xi tsismicacun ngu quihndi ndiya naha ne, hitsë sa ndaja tsëhë xuta vëhë xi xtyangui ngu ndyojo natsi nguisin me sehe ningatjeya rë me ngajñi ndachacun. ");
INSERT INTO maqNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Hane sá xi cjuatacun nuju meje rë xi nihñu ngu jyë́ cojo ntsun ne, vengui sa chji rë xi chandunxun ntsun ta, jemu sa ndaja tsujun xi cuma yoho yun xcun Nina, xi cumá rë xi cuechun xcun xitsehen cojo ntsun ngajñi rë ndihi jyë xi tsajin nixtin hvo. ");
INSERT INTO maqNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ngajan cuinechun, hiscan xi cjuiin nuju cjuañihi ta ndihi ne, tsajin nixtin xi hvo. ");
INSERT INTO maqNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Sá xi cjuatacun nuju meje rë xi nihñu ngu jyë́ jani xi cuangun ne, vengui sa chji rë xi chandunxun ntsacun ta, jemu sa ndaja cuechun xcun Nina xi yoho yun xi cuma rë xi cuechun xcun xitsehen cojo ntsacun. ");
INSERT INTO maqNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ngajan xcun xitsehen vëhë ne, cjuiin nuju cjuañihi ta ndihi ne, tsajin nixtin hvo. ");
INSERT INTO maqNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Hacuaha sá xi cjuatacun nuju meje rë xi chutsujun xcusun xi ndajintjin xi chutsujun ne, chuhunxun tuxcun jan chandunxun, ta tsëhë xi hitsë sa ndaja tsujun xi sacu nuju cahndë́ ngajan hiscan sahmi Nina gubiernu handasa cojo ngu ni tuxcun xi cuma rë xi cojo catsijo tuxcun cuechun xcun ndihi xi sahmi castigu rë nima. ");
INSERT INTO maqNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ngajan xcun xitsehen ne, ngajan cjuiin nuju cjuañihi ta ndihi ne, tsajin nixtin hvo. ");
INSERT INTO maqNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Hya xi tsichuva Nina ngayëjë ni xuta há ndaja há ndajin casahmi me ne, me xi tsajin mé casahmi ne, Nina ne, jemu chuya rë me. Hya xi Nina cjuahatsja me ngu cjuatjo xi tahan rë me ne, sá xi cojo naxa sehen ndaja ne, jemu chuya rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","’Naxa ne, jemu ndaja. Peru sá xi cjuë xtya rë ne, machjiriin. Cjuandaja rë Nina ne, hacuaha jemu ndaja. Vëhë xi chjuhun cjuandaja rë Nina, teyun cahntsua xahasen nuju, hacuaha ndaja tinechun cojo xingun. ");
INSERT INTO maqNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Hya xi camá ne, cavetju Jesús tsëhë nandya Capernaum quiji me distritu Judea cojo ngunda ndajyë Jordán. Hacuaha jercu cjín nga xuta quijitjengui rë me. Hane sacuaha xcusun xi ha sahmi Jesús ne, cavetsihin cavicuya nga me xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hya xi camá ne, ngujo cha tsëhë partidu fariseo ne, quiji cha hiscan tacun Jesús. Vinenguise cha me tsëhë xi ngu xihin, ¿há ndatjin xi tsismi chjuun rë? Cuatjin cachja cha ta tsëhë xi meje cjuahachuva cha me cojo cjua rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ngajan xi cafayangui me tsëhë cha cuitjin: ―‍Moisés ne, xutachanga naja ne, ¿mé cavitexa naja me? ");
INSERT INTO maqNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ngajan xi cafayangui cha tsëhë me cuitjin: ―‍Moisés ne, casua me cahndë́ xi ngu xihin ne, cuma cuejña cha ngu xujun tsja chjuun rë cha xi ha quihndë mijí rë cha na. Hane xi cuatjin ne, cuma tsismi cha na. ");
INSERT INTO maqNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sehe ngajan xi Jesús ne, cachja me cojo cha cuitjin: ―‍Ngatsë rë cjuataja rë xahasen nuju ne, vëhë xi Moisés ne, casua me cahndë́ xi cuatjin nihñu. ");
INSERT INTO maqNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Peru hya xi casahmi Nina ngasunhndë ne: “Casahmi me xi chjuun xi xihin xuta.” ");
INSERT INTO maqNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Vëhë xi ngu xihin ne, cuejña cha nahmi rë cha, hacuaha cuejña cha naa rë cha, ");
INSERT INTO maqNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","hane cumatangun cha cojo chjuun rë cha sacuaha ngu ni xahasen.” ");
INSERT INTO maqNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ha quihndë hacuiin jo ta sacuaha xi ngu ni xahasen. Hane tsëhë xi ha Nina cachja me xi cuatjin cuma ngu xahasen me ne, ndajintjin xi xuta ne, tsinguetsuntaha me tsëhë xicjin me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ngajan xi hya xi Jesús tacun ndihya me cojo cha ladu rë me ne, cavinenguise nga cha me ngu ndiya tsëhë cjuavisiajmi vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ngajan xi cachja me cojo cha cuitjin: ―‍Yo xi tsismi chjuun rë hane cuixan cojo ngu sa chjuun ne, jemu jyë jyë́ rë xi cuatjin sahmi. ");
INSERT INTO maqNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hacuaha sá xi ngu chjuun tsismi na xihin rë na hane cuixan na cojo ngu sa xihin ne, hacuaha jemu jyë jyë́ rë na. ");
INSERT INTO maqNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jinguyëjë rë xi tivisiajmi Jesús cojo cha ladu rë me ne, cavetsihin tjemu canduva xuta cojo quihndi rë me, xi cuisanetsja Jesús nixti jan cojo sa xi sacú rë cjuandaja rë me. Peru cha ladu rë Jesús jan ne, cacjan cha cojo xuta jan ta, xi má rë cha ladu rë me ne, mahyiin rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hya xi cavëë Jesús xi cuatjin sahmi cha ladu rë me ne, camacjan rë me cojo cha. Ngajan xi cachja me cuitjin: ―‍Tuhun cahndë́ catinduva tjengui suva ná nixti. Xi canichuun cahndë́ xi cuma rë ta, xuta xi sahmi me yojo rë me sacuaha ngu quihndi ne, xuta vëhë xi sahmi me sacuatjin vitexa Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cuichjá cojo nuju cjuaquixi ta yo xi meje cuisehen gubiernu rë Nina ne, cuma cuisehen peru sacuaha ngu quihndi. Sá sahmii cuatjin ne, cumaji cuisehen. ");
INSERT INTO maqNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ngajan xi Jesús ne, cavataha me nixti jan. Hane hora xi cavisanetsja me ne, cachja me cjuandaja rë me cojo. ");
INSERT INTO maqNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hya xi camá ne, cavetju me quiji me jingu sa cahndë́. Hane ndiya cjui me ne, vanga ngu cha cafehe cha cavixcuhnchi cha xcun me xi faharcun cha me. Sehe chja cha cojo me cuitjin: ―‍Ngayun maestro. Jemu ndaja ngayun. Nújun, ¿mé xi sahme xi cuma sacú ná cjuahñu xatsë? ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ngajan xi Jesús ne, cafayangui me tsëhë cha cuitjin: ―‍¿Mé má cuatjin noje xi ndaja ngahan? Tsajin xuta xi ndaja suva ni Nina xi ndaja me. ");
INSERT INTO maqNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ha hye cjua xi cavitexa Nina: “Xi caniquiin xuta. Xi canihñii chjuun nahñu riji jingu sa chjuun. Hacuiin mé chjehehmi tsëhë xuta. Xi canujiin cjuandesu tsëhë xuta. Xi cavindachiin rë xuta. Chjehercuin nahmi riji hacuaha chjehercuin ná riji.” Vëhë cjua xi cavitexa Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ngajan xi cachaja cha cojo Jesús ta: ―‍Maestro, yëjë cjua vëhë ne, hisca cjuanixti naha ne, ha cahndë. ");
INSERT INTO maqNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Xi cahndë Jesús cjua rë cha ne, jemu cachuya rë me tsëhë cha. Ngajan xi chja me cojo cha ta: ―‍Machaja sa ri ngu xcusun. Tjihin ne, titeñi yëjë xi tjin ri hane tujún xi sacu ri ne, tehe rë xuta yuma. Hane sehe ndovetjengui ná. Sá xi nihñi cuatjin ne, xi cjuehe xcun Nina ne, ngajan sacú ri cjuanchina xi ndajyihi. ");
INSERT INTO maqNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Xi cahndë cha cjua vëhë ne, jemu choho camá rë cha. Va va má cacun cha, cavetju cha cafe cha ta, tsëhë xi jemu nchina cha. ");
INSERT INTO maqNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ngajan xi Jesús ne, vutsejen me yëjë ni ladu hiscan siu cha ladu rë me ne, sehe cachja me cojo cha cuitjin: ―‍Jemu chja tsëhë ngu xuta nchina xi cuisehen me ladu rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ngajan xi cha ladu rë me ne, jemu quijircun rë cha xi cuatjin cachja me. Ngajan xi cachja nga Jesús cojo cha cuitjin: ―‍Compañeru, jercu chja tsëhë xuta xi cuisehen me ladu rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sacuatjin rë naxin xi cumaji cuatju chu ngojo rë nindu ne, cuatjin rë xuta xi jemu meje rë me cjuanchina ta, cumaji cuisehen me ladu rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Xi cahndë cha ladu rë me cjua vëhë ne, jemu quijircun camahani rë cha. Ngajan xi cachja cha ngajñi rë cha cojo xicjin cha: ―‍¿Peru yo ni xi cuma cuetjutje ni? ");
INSERT INTO maqNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Xi cavuya me vutsejen me hiscan siu cha ne, ngajan xi cachja me cuitjin: ―‍Yëjë ni xi maji sahmi xuta ne, Nina ne, hatuxa ma sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ngajan xi cavetsihin cachja cha Pedru cojo Jesús cuitjin: ―‍Chutsujun ni. Ngayin ne, canismitacuin yëjë ni xcusun, hane cavisihin ladu nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ngajan xi cachja Jesús ta: ―‍Cuichjá quixë cojo nuju ta, tu yo ni xi tsismicacun ndava, tsismicacun hntsë, tsismicacun tichja, tsismicacun naa rë o sá nahmi rë o sá quihndi rë, hacuaha tsismicacun nangui rë xitjë rë ngatsë naha cojo ngatsë rë cjua rë Nina ne, jinguyëjë rë xi ngasunhndë vihi tacun me ne, ");
INSERT INTO maqNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","sacú rë me ngu cientu sa quisun tsëhë ngu ngu xcusun xi catsismicacun me. Cjín ndava me sacu rë me. Cjín hntsë me sacu rë me. Cjín tichja me sacu rë me. Cjín naa rë me sacú rë me. Cjín quihndi rë me sacú rë me. Hacuaha cjín nangui rë xitjë rë me sacu rë me. Handasa cojo cjuañihi, peru sacú rë me. Hane hya xi cueya me ne, cuechú me cjuahñu xatsë xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tsëhë xuta xi matitjun quihndë ne, jemu cjín me xi cumachjiriin hya xi cuinduva Nina ngasunhndë. Hane xuta xi hacuiin matitjun quihndë ne, hya ne, cumachji rë me xi cuma titjun me. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hya xi camá ne, hora xi jiya ndiya Jesús cjui me cojo cha ladu rë me nandya Jerusalén ne, titjun Jesús cjui me. Hane cha ladu rë me ne, jercu fircun ra, tsëhë xi tsacjuiin Jesús xi cjui me. Hane xuta xi tjengui cjui cojo me jan ne, hacuaha jemu tsacjun me má. Ngajan xi Jesús ne, cajindaya nga me cha ladu rë me xi tejó ni jan, sehe cavetsihin cachja me cojo cha xcusun xi ha tacun xati xi cuatju me cuma. ");
INSERT INTO maqNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Cuitjin cachja me: ―‍Tinuhyun ni, tivanguen nandya Jerusalén. Hane ngajan ne, tjin yo me xi cuiteña ná ngajan cojo nahmi xi matitjun cojo cha maestru tsëhë ley. Cuatjin sahmi me ha ndasa xi ngahan xi Quihndi rë Xuta Jain. Hane xuta xi cuacun vë cuichja me xi cueya ngahan, hacuaha sua nga me ngahan cojo xuta rë jingu sa nandya. ");
INSERT INTO maqNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sehe tsixcuehyu me ngahan. Cuëhënatya me ngahan, cuaja me ngahan, hisca tsiquehen me ngahan. Peru xi cjuë jyan nixtin ne, cúya nga cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Xi cajnetaha cachja Jesús cuatjin ne, sehe quiji cha Jacobo cojo cha Juan, quihndi rë Zebedeo, quiji tjengui tiña cha Jesús. Ngajan xi chja cha cojo rë me cuitjin: ―‍Maestro. Nihñu favor ne, cjua xi chjahyin nuju ne, ningatuhun niji. ");
INSERT INTO maqNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ngajan xi cachja me cojo cha cuitjin: ―‍¿Mé xi meje nuju xi sahme ni? ");
INSERT INTO maqNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ngajan xi chja cha cojo rë me cuitjin: ―‍Tuhun cahndë́ xi ngu ngu ngayin ne, cuinechintihin ngu ngu ladu tjehen nuju, hya xi nihñu gubiernu nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngajan xi cachja Jesús cojo cha cuitjin: ―‍Ngayun ne, hyuun mé xi chahyun. ¿Há scaa nuju cuatju cjuañihi xi cuátju ngahan ni? ");
INSERT INTO maqNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngajan xi cachja cha ta: ―‍Scaa niji. Ngajan xi cachja nga Jesús cojo cha cuitjin: ―‍Cjuañihi xi cuatju ngahan cumá ne, hacuaha cojo ngayun cuatjun cumá. ");
INSERT INTO maqNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Peru xi cuinechuntuhun ngu ngu ladu tjehen naha ne, hacuiin ngahan cuichjá ta xcusun vëhë ne, sacu rë xuta xi cuichja Nina xi sacu rë me cahndë́. ");
INSERT INTO maqNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Xi cahndë cha xi të jan cjua xi cachja Jesús ne, cavetsihin camacjan rë cha cojo cha Jacobo cojo cha Juan. ");
INSERT INTO maqNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hya xi camá ne, cajindaya Jesús cha xi të jan ne, cachja me cojo cha cuitjin: ―‍Ngayun ne, ha hyun ta xuta matitjun nguehe ngasunhndë jemu sahmi yehe me yojo rë me, ta jercu meje cuitexa me. ");
INSERT INTO maqNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Peru hacuiin cojo ngayun cuatjin nihñu ngajñi nuju ta xi meje rë ne, jarë ngayun xi meje nuju xi cumatitjun ngayun ne, nihñu xa rë xingun sacuaha mosu. ");
INSERT INTO maqNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Hane jarë ngayun xi meje nuju xi xingun ne, cjuaharcun me yun ne, nihñu xa rë xingun sacuaha mosu xi caxteña. ");
INSERT INTO maqNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hisca ngahan ne, Quihndi rë Xuta Jain má ngahan, peru hacuiin canduvá xi xuta cuisecoo ná me ta ngahan cuisecoo rë xuta. Hisca tsingatehen xi tsiquehen ná xuta, cojo sa xi cjín xuta cuaxëtje Nina me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hya xi camá ne, cjui cjui me cojo cha ladu rë me ne, cavechu me nandya Jericó. Xi cavatju me tsëhë nandya vëhë cojo xutacjín xi ticojo me ne, cavechutaha me cha quihndi rë Timeu, cha xi hmí rë Bartimeo, ngu cha rcá, hane tifehya cha caridad tjehen ndiya. ");
INSERT INTO maqNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Xi cahndë cha rcá jan xi Jesús tsëhë nandya Nasaret hacui me xi nduva me, jercu cachja cha: ―‍Jesús, quihndindaicjin rë David, catamayuma nuju ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hane cavisiajmicjan xuta jan cojo cha ta, catisejyu cha. Peru hitsë sa hñu chja cha cuitjin: ―‍Quihndindaicjin rë David, catamayuma nuju ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ngajan xi casecunhñu Jesús. Sehe ngajan xi chja me cojo cha ladu rë me cuitjin: ―‍Chjindayun rë cha. Hya xi camá ne, cha ladu rë me jan ne, cajindaya cha cha rcá jan, sehe cachja cha cojo cha cuitjin: ―‍Tehe cjuetacun xahasen riji quen. Tisatjinhngue ta, jindaya me ngaye. ");
INSERT INTO maqNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Cuatjin camá xi cafaha cha tsjanga rë cha catsingatjenxin cha. Sehe marcu macjain casecun cha. Sehe quijitjengui cha Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Hane xi cavechutaha cha me ne, ngajan xi cachja me cojo cha cuitjin: ―‍¿Mé xi meje ri xi sahmi cojo ri? Ngajan xi cachja cha rcá jan ta: ―‍Maestro, xi meje ná ne, xi cuma tsejen ná. ");
INSERT INTO maqNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ngajan xi cachja Jesús cojo cha cuitjin: ―‍Ndatjin. Cuma cjuihin ta, camandaja ye, tsëhë xi camacjain ri ngahan. Hane ha hora vëhë ni ne, camatsejen rë cha. Hane quiji cha cojo rë me hacutjin cjui me. ");
INSERT INTO maqNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hane xi camatiña me Jerusalén xi ha cjuaha me nandya Betfajé cojo Betania, quiji me ndetjun xi hmí rë Ndetjun Olivu, ngu ndetjún xi tiña tacun cojo nandya xi cuacun vëhë ne, catsingatju me jo cha ladu rë me quiji cha tixa. ");
INSERT INTO maqNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Cuatjin cachja me cojo cha: ―‍Tangun nandya xi tsejen vë. Hane xi tu cjuhun tjehen nandya ne, sacú nuju ngu burru xatsë xi hisca ngu cjëë cuijin rë chu, quitahahñu chu ngajan. Hane chundecjun chu, sehe nduvuncujun chu. ");
INSERT INTO maqNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sá xi yo xi cuichja cojo nuju ta: “¿Mé má cuatjin chundecjun chu ne?”, cuitjin tinújun: “Me xi matitjun tsijin meje rë me chu. Peru sehe tsicuya nga me chu.” ―‍Cuatjin cachja Jesús cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hya xi camá ne, quiji cha tixa xi cachja Jesús cojo cha. Xi tu cafehe cha ngajan ne, casacu rë cha ngu chu burru xatsë quitahahñu chu ngajan ndiya tiña tingotjo ndihya. Hane cavundecja cha chu. ");
INSERT INTO maqNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hane ngujo cha xi hinchacun jan ne, cachja cha cojo cha ladu rë Jesús cuitjin: ―‍¿Mé má cuatjin cachundecjun chu burru vë? ");
INSERT INTO maqNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ngajan xi cachja cha ladu rë Jesús hacutjin cachja me cojo cha. Sehe cha xi cuacun jan ne, casua cha cahndë́ quijicojo cha cha ladu rë Jesús chu burru jan. ");
INSERT INTO maqNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hane sehe quijicojo cha chu hiscan tacun Jesús. Hacuaha casua cha tsjian rë cha casesun ngaxtun chu sehe camiji me chu. ");
INSERT INTO maqNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hya xi camá ne, jemu cjín xuta xi cacandi me tsjian xcun rë me ndiya hacutjin cjui Jesús. Hane ngujo nga me ne quiji cavotohosun me xca xcuen ngajan nguijña, hane hacuaha cacandi me ndiya hacutjin cjui Jesús cojo sa xi tifaharcun me me. ");
INSERT INTO maqNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hane yëjë me xi cjui titjun cojo yëjë me xi tjengui jan ne, cavetsihin jercu cajindaya me cachja me: ―‍Nacuechji rë Nina ta cafehe me xi catsingatju Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Catsinchacun me me xi cuitexa naja sacuaha cavitexa David xutachanga naja. Jemu catsinchacun Nina me xi nduva tsëhë xi Nina catsingatju rë me. ―‍Cuatjin cajindaya xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Xi tu cavisehen me nandya Jerusalén ne, quiji me yungun xi matitjun. Xi tu cavutsejen nguehe cavutsejen ngajan me ne, mé ta quiji hora ne, cavetju nga me cojo cha ladu rë me xi tejó jan ne, cavuya cafehe nga me nandya Betania. ");
INSERT INTO maqNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Xi camá nchujun jan ne, cavuya cavetju nga Jesús tsëhë nandya Betania. Hane ha jemu vojo rë me hora xi cavetju me. ");
INSERT INTO maqNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hya xi camá ne, tsëhë cjin ni cavëë me ngu yaxujun xi chine tú rë xi jemu ndaja tsejen yaha xca rë. Hane quiji me hiscan secun, sá sacu sinë me. Peru xi cafehe me ngajan ne, tsajin camahani mé xi casacu rë me, tsëhë xi hacuiin nixtin rë tuhaxi jan. ");
INSERT INTO maqNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ngajan xi cachja me cojo ya jan cuitjin: ―‍Quihndë tsajin nixtin xi cuaqui tú riji xi sinë xuta. Hane cha ladu rë me ne, cahndë cha cjua rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hya xi camá ne, cafehe me nandya Jerusalén. Xi cafehe me ngajan ne, quiji me ndatsen yungun xi matitjun jan. Hane cavetsihin cavaxë me xuta xi sahmi ndetsin ngajan. Catsindefa me maxë rë xuta xi tsindeya tujún. Hacuaha cacandi me siya rë xuta xi viteña nisë tyava. ");
INSERT INTO maqNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hane casuaain me cahndë́ xi tjin mé xi cjuaha xuta xi cuatjuvasen me ndatsen yungun jan. ");
INSERT INTO maqNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sehe cavetsihin cavicuya me xuta jan cuitjin: ―‍Ngayujun ni ne, ha hyun xi cuitjin cachja Nina xcun xujun rë me: “Ndya naha ne, ngu ndihya xi vinduva xuta tsëhë yëjë ni nandya cuisiajmi me cojo ná.” Peru ngayun ne, tinihñu ndava Nina vi sacuaha ndava chëjë. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hya xi camá ne, xi cahndë nahmi xi matitjun cojo maestru tsëhë ley cjua jan ne, cavetsihin cavangui me chuva rë xi cuma tsiquehen me Jesús. Cuatjin meje rë me tsëhë cjuaxin xi tjin rë me, tsëhë xi yëjë xuta ne, jemu quijircun rë hacutjin cavicuya Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Xi quiji hora ne, cavetju nga Jesús tsëhë nandya jan cojo cha ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hane xi camá nchujun jan ne, cavuya cafe nga me nandya Jerusalén. Hane xi cavatju nga me hiscan secun ya xujun jan ne, cavëë me xi ya xujun jan ne, cafë caxi hisca rcu hisca ntsacu. ");
INSERT INTO maqNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ngajan xi cha Pedru ne, catsinguitsjen cha cjua xi cachja Jesús cojo ya jan ngujña ne, sehe ngajan xi cachja cha cojo Jesús cuitjin: ―‍Maestro. Chutsujun ta ya xujun xi canújuncjun cojo jan ne, cafë caxi. ");
INSERT INTO maqNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ngajan xi cafayangui Jesús tsëhë cha cuitjin: ―‍Catamacjain nuju tsëhë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cuichjá cojo nuju ngu cjuaquixi ta tu yo ni xi cuichja cojo naxi vëhë cuitjin: “Tihinxin tsëhë nguehe, tihin tisihin ngajñi ndachacun”, sá xi hacuiin majo cacun, sá xi macjain jain rë hacutjin xi cachja ne, cuatjin jain cuma. ");
INSERT INTO maqNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Vëhë xi chjá cojo nuju ta yëjë ni xi chjahyun cojo Nina ne, ningatuhuntacun sacuaha xi ha casacu nuju ta xi cuatjin ne, sacu jain nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Hora xi chjahyun rë Nina ne, sá xi tjin yo xi choho cachja tsujun, o sá xi choho casahmi tsujun ne, ninchatuhun rë, cojo sa xi Nahmi naja xi tacun ngahnga ne, hacuaha tsinchataha nuju me tsëhë jyë́ nuju ta, ");
INSERT INTO maqNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","sá xi ninchatuun rë me ne, Nahmi naja xi tacun ngahnga ne, hacuaha tsinchataain nuju me. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Cjui cjui me ne, cafehe me nandya Jerusalén. Hane xi cafehe me jan ne, quiji me yungun xi matitjun. Hora xi tsujyihiya me ndatsen yungun jan ne, nahmi xi matitjun cojo maestru tsëhë ley cojo sa xuta changá xi yahnga jan ne, cafehe tjengui me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hane cuitjin cavinenguise me: ―‍¿Yo cavitexa ri xi cuatjin nihñi xcusun vë? ¿Yo casuaxa ri? ");
INSERT INTO maqNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ngajan xi Jesús ne, cachja me cojo xuta jan cuitjin: ―‍Cjuinenguësë nuju ngu cjua. Hane sá xi nicuyun tsahan ne, sehe cuichjá cojo nuju yo cavitexa ná xi sahme xcusun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ngayun mé nújun, ¿Yo xi cavitexa rë cha Juan xi cavitenda cha xuta? ¿Há Nina cavitexa me cha ne, há xuta cavitexa me cha? Tinújun cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ngajan xi vetsihin visiajmi xuta jan ngajñi rë me cojo xicjin me cuitjin: ―‍Sá xi cuinújan xi Nina cavitexa me ne, cuichja me vihi cojo naja cuitjin: “Sá xi cuatjin ne, ¿mé má camacjaain nuju xi cachja cha ni?” ");
INSERT INTO maqNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Peru ¿há cuma cuinújan xi xuta cavitexa me cha? Cuatjin casacuinyiin rë xuta xi cuacun vë mé cjua xi tsicuya me tsëhë Jesús ta, tsëhë xi tsacjun me xutacjín, tsëhë xi yëjë ni xuta jan ne, macjain rë me xi cha Juan ne, Nina cavitexa jain me cha xi suacuenda cha cjua rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Vëhë xi hya xi cafayangui me tsëhë Jesús ne, cachja me cuitjin: ―‍Hyiin. Ngajan xi hacuaha Jesús ne, cachja me ta: ―‍Sá xi cuatjin ne, ta mijí nicuyun cjua tsahan ne, hacuaha cuichjaain cojo nuju yo cavitexa ná xi sahme xcusun vihi. ");
INSERT INTO maqNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sehe cavetsihin cavicuya Jesús xuta jan ngujo cjua, peru cojo suva ejemplu cachja me. Cuitjin cavetsihin me cjua: ―‍Cuejñaa xi ngu xihin ne, catsitjë me nahñu rë uva ngu rquí nangui. Hacuaha casahmi me hnchua xondyojo rë tahndee rë xitjë jan. Ha ngajan ne ne, cafahanguiya me ngu ndyojotë hiscan cuaxë nandá rë tuhaxi jan. Hacuaha casahmi me ngu cahndë́ hiscan xi cavesun me ngu nachan ngahnga xi sesun xuta xi sahmi cuidadu xitjë rë me. ’Hya xi camá ne, casuatsja me cojo jingu sa xuta xi sahmi cha cuidadu rë, hane cjuaha me tsë tsë cojo rë cha. Sehe cavetju me quiji me ngu nanguicjin. ");
INSERT INTO maqNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Xi cavechú nixtin tsëhë tutjë jan ne, catsingatju me xi tsëhë jan ngu mosu hiscan xi quitaha xitjë rë me, xi cjuahatsja cha tsëhë xi satë rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hya xi camá ne, xi cavechu cha mosu jan ne, cavaja xuta xi tacun tsja xitjë jan cha mosu jan. Hane catsicuya cha cha cafe cha. ");
INSERT INTO maqNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ngajan xi me xi tsëhë jan ne, cavuya catsingatju nga me ngu mosu quiji. Hane xi cavechu mosu vëhë ngajan ne, me xi siutaha jan ne, cavanguihmu me rcu cha, hacuaha choho cachja me cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Cafë ne, me xi tsëhë jan ne, cavuya catsingatju nga me ngu mosu. Peru mosu jan ne, catsiquehen me xi cuacun jan cha. Cafë vëhë ne, catsingatju camaha sa cha mosu. Hane ngujo mosu jan ne, tu cavaja ni cha. Hane ngujo nga ne, catsiquehen camahani cha. ");
INSERT INTO maqNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Quihndë me xi tsëhë cahndë́ jan ne, ngu ni quihndi tjin rë me ne, vëhë sa tacun. Handasa jemu hmucacun me cha ne, peru catsingatju me cha, tsëhë xi cuitjin catsingatahacacun me: “Quihndi naha vi ne, cjuaharcun me cha.” ");
INSERT INTO maqNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Peru xi cafehe cha quihndi rë me ngajan ne, ngajan xi chja xuta xi sahmi cuidadu xitjë jan cojo xicjin me ta: “Cha vihi quihndi xi cjuahatsja cha cahndë́ vihi. Quihndë ne, niquen cha, cojo sa xi cumá tsajan nangui.” ");
INSERT INTO maqNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hya xi camá ne, cafaha me cha catsiquehen me cha, sehe catsingatjexin me cha tsëhë cahndë́ jan. Cuatjin casahmi me xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Hindë ne, me xi tsëhë nangui jan ne, ¿mé sahmi me cojo xuta xi siutaha cuidadu rë xitjë jan? Hatuxa cjue me ne, tsiquehen me me, hane sua me cahndë́ jan cojo jingu sa xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Quihndë, ngayun ne, ha chutayuun cjua tsëhë xujun rë Nina xi chja cuitjin: Ndyojo xi chja cha chjinevexo xi machjiriin ne, ndyojo vëhë xi cachja Nina xi cuejña tjun tjun yuju rë xihndënaña. ");
INSERT INTO maqNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Cuatjin casahmi Nina xi cumá hacuaha jemu chuya rë xahasen naja xi cuatjin camá. ");
INSERT INTO maqNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hya xi camá ne, xuta changá xi cafehe tjengui rë Jesús jan ne, meje cjuaha me me, tsëhë xi camachaya rë me xi condra rë me xi cachja Jesús. Ha ndasa meje cjuaha xuta changá jan Jesús ne, peru xi tsacjun me tsëhë xutacjín jan ne, ha quihndë tsajin mé casahmi me, hane cafe me. ");
INSERT INTO maqNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hya xi camá ne, xuta changá xi cuacun jan ne, catsingatju me ngujo cha tsëhë partidu fariseo cojo ngujo cha ladu rë Herodes xi cjuahangahma cha Jesús, cojo sa xi xuta changá jan ne, cuma cuinchajyë me me. Xi tu cafehe cha ne, ngajan xi cachja cha cojo rë me ta: ");
INSERT INTO maqNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","―‍Maestro. Ngayin ne, hyin ta ngayun ne, quixi cjua tsujun. Ha tuxa cjuaquixi xi nújun ha ndasa xi cojo xuta nchina visiajmu o sá cojo xuta yuma. Tu yo ni ne tangun ni visiajmu cojo ta tsëhë xi ngayun ne, vicuyun ndiya rë Nina cojo cjuaquixi camahani. Quihndë ne, sacuaha ley rë Moisés ne, ¿há sua cahndë́ xi cuechjen tujúnsa naja cojo César, me xi matitjun, o há suaain cahndë́? ―‍Cuatjin cavinenguise cha. ");
INSERT INTO maqNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Peru Jesús ne, tsëhë xi ha vacun rë me xi jemu ndacha cha ne, cuitjin xu cachja me cojo cha: ―‍¿Mé má cuatjin meje chuhunchuvun ná? Nduvuncujun ngu tujún scutséjen. ");
INSERT INTO maqNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hya xi camá ne, cha xi cuacun jan ne, canduvacojo cha ngu tujún tyava. Ngajan xi cachja me cojo cha cuitjin: ―‍¿Yo xcusun rë hacuaha yo ñihi rë xi quitahá xcun tujún vë? ―‍Cuatjin cavinenguise Jesús. Ngajan xi chja cha cojo rë me cuitjin: ―‍Tsëhë César. ―‍Chja xu cha. ");
INSERT INTO maqNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo cha: ―‍Sá xi cuatjin ne, tuhun rë César xi tsëhë me; hane tuhun rë Nina xi tsëhë me. ―‍Cuatjin cachja Jesús. Hya xi camá ne, jemu quijircun rë cha xi cuatjin ndaja cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hacuaha canduva tjengui rë me ngujo cha tsëhë partidu saduceo, cha xi vicuya ngu cjuachacun xi chja xi hya xi cueyan ne, ha quihndë cuyaain cjuahñu naja. Hane cuitjin cachja cha ngujo cjua cojo Jesús: ");
INSERT INTO maqNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―‍Maestro. Moisés ne, catsihindu me xcun xujun rë Nina xi sá xi ngu xihin cueya, hane tsajin rë chjuun rë hisca ngu quihndi ne, hntsë nima vëhë ne, meje rë xi cjuaha rë chjuun cahan vëhë, cojo sa xi sacú rë na quihndi xi cuma sacuaha quihndi rë nima vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Quihndë ne, cuejña xi ngu ndihya ne, siu yatu cha cojo hntsë cha. Hane cha tjun ne, cafaha cha chjuun. Peru cahme cha, hane chjuun rë cha vëhë ne, casacuiin rë na hisca ngu quihndi cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hya xi camá ne, hntsë nima vëhë, cha xi majo ne, cafaha cha na cahan vëhë camá chjuun rë cha na, peru hacuaha cahme cha hane casacuiin rë na quihndi. Hacuanitjin ni cafaha cha xi majyan jan na, ");
INSERT INTO maqNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","hisca xi cafë yëjë xi yatu cha cafaha cha na. Peru yëjë cha xi cuacun vëhë ne, cafë cha cahme cha chuva ngu chuva ngu cha. Hane na vëhë ne, casacuiin rë na hisca ngu quihndi cojo cha xi cuacun vëhë. Hiscan xi cajnetaha ne, hacuaha cahme na. ");
INSERT INTO maqNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Quihndë ne, ¿mé nújun? Hya xi cuya yëjë nima cjuahñu ne, ¿jarë jain cha xi chjuun rë cha na xi cjuaquixi? ta yëjë xi yatu cha ne, cavixan cha cojo rë na. ―‍Cuatjin cavinenguise cha. ");
INSERT INTO maqNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ngajan xi cachja Jesús cojo cha cuitjin: ―‍Ngayun ne, cuaaintjin xi nújun, tsëhë xi vijnii rcun cjua xi chja xujun rë Nina, hacuaha hyuun xi Nina ne, jemu hñu cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hya xi cuya cjuahñu rë nima ne, ha quihndë hacuiin cuixan me hacuaha hacuiin tsinguixan me, ta tangun cumá sacuaha xi siu ángel ngahnga ne, cuatjin cuiyuju me. ");
INSERT INTO maqNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Hacuaha quihndë xi tinújan tsëhë nima xi cuya cjuahñu rë ne, ngayun ne, sacuaha xi cjëë chutayun xujun xi catsihindu Moisés hacutjin cahndë́ me cjua rë Nina xi cavetju tsëhë cahntsua ngu ya lihndi xi seti. Cuitjin cachja Nina cojo me hya: “Ngahan xi Nina rë Abraham ngahan. Nina rë Isaac, hacuaha cojo Nina rë Jacobo má ngahan.” Cuatjin cachja Nina tsëhë xuta xi ha cahme me. ");
INSERT INTO maqNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Peru Nina ne, hacuiin nina rë nima ta nina rë xuta xi quicun me. Hane sá xi quicun nima jan, ngajan tsejen xi cjuachacun xi nújun ne, quixiin. ");
INSERT INTO maqNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hacuaha cafehe ngu cha maestru tsëhë ley hiscan tacun Jesús. Hane xi cahndë́ cha cjuavisiajmi rë me ne, xi ndaja cama catsicuya Jesús, ngajan xi cavinenguise cha me cuitjin: ―‍Maestro, tsëhë yëjë ni cjua xi cavitexa Nina naja xcun xujun ley ne, ¿jarë artículo xi hitsë sa matitjun? ");
INSERT INTO maqNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ngajan xi cafayangui Jesús cuitjin: ―‍Xi matitjun ne, cuitjin chja: “Ngayujun ni ngayun xuta ladu rë nangui Israel, Nina naja ne, ngu tu tu ni me. ");
INSERT INTO maqNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Meje rë xi nihña hmutacun Nina, me xi matitjun tsajan, cojo ngayëjë ni cjuatacun naja, cojo ngayëjë ni xahasen naja, hacuaha cojo ngayëjë ni ngahñu naja.” ");
INSERT INTO maqNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hane xi má jo ne hacui vihi: “Meje rë xi nihña hmutacun xingueen sacuatjin hmutacun suvaan yojo naja.” Tsëhë yëjë ni artículo xi cavitexa Nina ne, jo ni cjuatacun vëhë xi matitjun. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ngajan xi cachja cha maestru tsëhë ley cojo rë me cuitjin: ―‍Ndatjin canújun, maestro. Canújun cjuaquixi ta Nina naja ne, ngu tu tu ni me. ");
INSERT INTO maqNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Hacuaha ndatjin canújun xi meje rë xi nihña hmutacun Nina cojo ngayëjë ni cjuatacun naja, cojo ngayëjë ni ngahñu naja, hacuaha meje rë xi nihña hmutacun xingueen sacuaha nihña hmutacun yojo naja suvaan. Cjua vëhë ne, tjercu venguichji rë. Hisca vengui sa chji rë xi cuma rë yëjë ni cjuandaja cojo yëjë cjuatjo xi cjue xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Xi tu cahndë Jesús ta ndatjin cafayangui cha maestru jan ne, ngajan xi cachja me cojo cha cuitjin: ―‍Ha jemu hitsë sa chaja xi cuisuhun ladu rë Nina. Ha quihndë tsajin yo xi macacun sa cjuinenguise rë me ngu cjua. ");
INSERT INTO maqNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ngajan xi Jesús ne, hora xi tivicuya me xuta ngajan yungun xi matitjun ne, cachja me cojo xuta cuitjin: ―‍Maestru tsëhë ley ne, chja cha ta Cristu, me xi tsingatju Nina xi cumatitjun tsajan ne, tjë rë David má me. ");
INSERT INTO maqNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Peru suva David ne, catsihindu me cjua xi cachja Hasen rë Nina cojo rë me cuitjin: Nina ne, cachja me cojo Nai naha cuitjin: “Tinechin ladu quixi naha hiscan hya xi yëjë xi sahmi condra ne, cuiyuju ngahan ngahma gubiernu riji.” ");
INSERT INTO maqNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ndatjin, sá xi cuatjin cachja David tsëhë me ne, ¿há cuma xi hisca tjë rë David má me ni, hacuaha matitjun nga me tsëhë David ni? ―‍Cuatjin cachja Jesús. Hane xutacjín ne, jemu cojo cjuasua cavisiñuju me cjua rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Hacuaha cuatjin cachja nga me ngu ndiya xi tivicuya me xuta: ―‍Tjin nuju cuidadu. Hacuiin cojo ngayun nihñu sacuatjin sahmi cha maestru tsëhë ley. Cha xi cuacun vëhë ne, jemu meje tsujyihiya chacun cha hacuaha meje rë cha xi cuichja xuta nina cojo cha ngajñi ndetsin. ");
INSERT INTO maqNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Hacuaha hora xi fi cha yungun ne, cjue cha cuiyuju cha ngu cahndë́ ndatjin hiscan viyuju xuta xi matitjun. Ha cuanitjin ni hiscan xi cjue sinë cha ngu ndava suhi ne, fi cha viyuju cha cahndë́ ndatjin hiscan viyuju xuta xi matitjun. ");
INSERT INTO maqNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hacuaha yachjin cahan ne, jemu cjín tujún vaxë cha na. Hisca ndava na tsajin. Hane hisca xi chjayuma cha ne, jemu nduju hora chja cha, peru hacuiin nguñaja cacun cha chja cha. Vëhë xi cha xi cuacun vë ne, hitsë sa jyë castigu cuatjun cha, xi cuma rë jingu sa xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sehe quiji cavéjña me tiña hiscan xi tacun caxa xi xincha tujún chjë rë Nina, vutsejen me hacutjin vincha xuta tujún. Hane jemu cjín xuta nchina quiji cavincha me chjë rë, jercu cjín tujún cavincha me. ");
INSERT INTO maqNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Hya xi camá ne, cojo ngu na cahan xi jemu yuma camahani quiji cavincha na jo tujún siné xi jemu chuva chji rë cahntsua caxa jan. ");
INSERT INTO maqNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ngajan xi Jesús ne, casahmitangun me cha ladu rë me, sehe cachja me cojo cha cuitjin: ―‍Cuichjá cojo nuju cjuaquixi ta xuma chjuun cahan vihi ne, hitsë sa vengui chji rë tujún xi cavincha na, xi cumá rë tujún xi jemu cjín cavincha cha nchina jan ta, ");
INSERT INTO maqNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","tsëhë xi cha xi cuacun vëhë ne, xi vangui rë cha ne, vëhë xi cavincha cha. Hane ha ndaja na vëhë ne, cojo cjuayuma xi tacun na ne, tujún xi cavincha na jan ne, ha vëhë yëjë ni xi tjin rë na. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hya xi camá ne, hora xi tivetju Jesús tsëhë ndatsen yungun xi matitjun jan cojo cha ladu rë me ne, ngajan xi chja nga cha ladu rë me jan cojo rë me cuitjin: ―‍Maestro, chutsujun ndyojo xi texo yungun vihi ta tjercu tu ndacun camahani. Hacuaha ndihya tsëhë ne, jercu tu cun camahani. ");
INSERT INTO maqNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ngajan xi chja Jesús cojo cha cuitjin: ―‍Sacuaha ndihya ndacun xi chutsujun ne, cuechu nixtin xi hisca xi ngu ndyojo vi ne, tsajin hinchasuncoo xicjin ta, cjuë yëjë cuixujne. ");
INSERT INTO maqNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Cafë cachja me cuitjin ne, sehe cavetju me quiji me cojo cha ladu rë me, cafehe me tiña rcu Naxi Olivu, quixi rë tingotjo yungun xi matitjun jan. Hane xi quijixin me cojo cha Pedru cojo cha Jacobo cojo cha Juan cojo cha Andrés, sehe cavinenguise cha me cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―‍¿Janihya cuetjucaa xcusun vëhë xi canújun? ");
INSERT INTO maqNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ngajan xi cachja Jesús cojo cha cuitjin: ―‍Nechun cuidadu cojo sa xi hacuiin cuma ndacha ngayun ta, ");
INSERT INTO maqNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","tsëhë xi jemu cjín xuta cjuehe me xi cuichja me cueyanangui me ñihi naha cuichja me xi hacui me xi Cristu me. Hane cuatjin jemu cjín xuta cumacjain rë me cjuandacha rë me xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Hacuaha hya xi cumachaya nuju cjua xi jemu yehe si tijima ne o sá xi tjin cjuacjintacun ta jemu yehe si nduva ne, hacuiin cumacjintacun ta ha tuxa cuatjin cuma. Peru hacuiin ha hya cjuë nixtin rë ngasunhndë vihi. ");
INSERT INTO maqNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Xuta nandya scaan cojo xuta xi hacjahi. Ngu nación cojo ngu nga ne, scaan. Hacuaha cjín cahndë́ xi cjuani nangui. Hacuaha cjín cahndë́ ne, cuma jindya. Cuatjin cumá xi cuetsihin cjuañihi xi cuatju xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Nechun cuidadu ta, cuechu nixtin xi xuta nandya ne, cjue cani nuju me xcun xutaxa rë yungun ne, hacuaha cuaja nuju me. Hacuaha tjin nuju xi cuangun xcun xutaxa rë ndihyavasen cojo xcun gobernador ngatsë rë xi macjain nuju ngahan. Hane ngajan ninguixun yëjë cjua hacutjin cavicuyá nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Peru chaja sa xi cjuë ngasunhndë ne, meje rë xi cuichja xuta ladu naha cjua rë Nina jingujyë ni nandya tsëhë ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hora xi cjui chani nuju xcun xutaxa rë ne, hacuiin cumacjintacun tsëhë cjua xi cuinújun jan ta, Hasen rë Nina ne, scuxaha cjuatacun nuju hora vëhë hacutjin cuinújun. Hacuaha vëhë ni cuinújun ta tsëhë xi hacuiin cjuatacun nuju xi cuinújun ta cjuatacun rë Nina xi sua nuju Hasen rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Xuta nandya ne, cuinchajyë me hntsë me, cuinchajyë me xutacha rë me, hacuaha cuinchajyë me quihndi rë me, cojo sa xi xutaxa rë ne, cjuaha me xuta xi cuacun vë ne, tsiquehen me. ");
INSERT INTO maqNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Hane yëjë xuta ne, choho scuëë nuju me ngatsë naha. Peru jarë ngayun xi scaa nuju cojo cjuacjintacun vëhë hisca xi cueyun ne, cuechun xcun Nina. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Yo xi scutaya cjua xi sehe nduva vi ne, meje rë xi ndaja catetaharcun. Tjin xcusun xi tsinguetsun rë cahntsua yungun xi matitjun. Hane hya xi cjuehe ngu xcusun xi cuacun vë hiscan xi ndajintjin xi cjuehe ne, yëjë ni xuta xi siu ladu tsëhë distritu Judea nixtin hya ne, ngutjen ni catangahma me hiscan ndetjun. ");
INSERT INTO maqNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hacuaha jarë me xi hinchasun rcu ndava xi cuitujne me, hacuiin cuijne me xi cuisehen me cahntsua ndihya cjuaha me mé tsëhë me xi cjuaha me. ");
INSERT INTO maqNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Hacuaha yo xi hinchataha me nguijña ne, mijí rë xi cuya cjue me ndava me xi cjuejaha ndastu tsjanga rë. ");
INSERT INTO maqNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jemu chojyihi tsëhë yëjë ni yachjin xi hinchahma quihndi rë cojo yëjë me xi tjin rë quihndi vaqui ne nixtin hya. ");
INSERT INTO maqNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chjahyun rë Nina xi cjuañihi vëhë ne, hacuiin cuinduva nixtin chan hnchan ta, ");
INSERT INTO maqNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","cjuañihi xi cuma ne, ngu cjuañihi jyë xi cjëë camahani cumá hisca ntsacu cavetsihin ngasunhndë hacuaha cuyaain cuatjin cuma. ");
INSERT INTO maqNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sá xi jemu cjín nixtin cjuecani rë cjuañihi vëhë ne, hisca ngu xuta ne, cuetjintjiin me. Peru ngatsë rë cjuahmutacun xi tjin rë Nina cojo xuta xi cavaxijin me xi cumá me ladu rë me ne, sahmichuva me nixtin vëhë. ");
INSERT INTO maqNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Nixtin vëhë ne, sá xi yo xi cuichja cojo nuju xi ngajan o sá xi nguehe tacun me xi má Cristu, xi camacjaain nuju ta quixiin xi chja me. ");
INSERT INTO maqNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ngujo xuta vindacha ne, cuichja me ta: “Ngahan xi Cristu xi cumatitjun ngahan tsujun.” Ngujo nga me ne, cuichja me ta: “Ngahan xi chjá cjua rë Nina.” Peru vindacha ni me, quixiin cjua xi cuichja me. Hacuaha sahmi me xcusun sacuaha cjuarcun, tsëhë xi hisca cojo xuta xi cavaxijin Nina meje cuindacha me. ");
INSERT INTO maqNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nechun cuidadu ta cojo chaja sa xi cuechu nixtin vëhë ne, ngahan ne, ha casua camachaya nuju xi cuatju vë. ");
INSERT INTO maqNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Xi cuatjun nixtin tsëhë cjuañihi jan ne, cuinduva nixtin xi cjuë ndavá rë tsuhi. Sá ne, hacuaha ha quihndë suaain ndavá rë. ");
INSERT INTO maqNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hane niñu ne, cuixu tsëhë ngahnga. Hisca ngahñu xi yaha ngahnga ne, cjuiniyaya. ");
INSERT INTO maqNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Xcun cjuacjintacun vëhë ne, scuëë xuta xi ngahan, Quihndi rë Xuta Jain, cuinduvá ngajñi rë yufí cojo jemu jyë ngahñu hisca seti tsejen ngahan xi nduvá. ");
INSERT INTO maqNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hya ne, tsingátju ángel naha yëjë ni ladu tsëhë ngasunhndë, cjuejaha rë yëjë xuta naha xi cavaxejen, sahmi tangun rë hiscan tejña. ");
INSERT INTO maqNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Quihndë ne, cuetaharcun ngujo cjua tsëhë yaxujun xi chine tú rë. Hya xi cuetsihin cumá xcuen tsja rë yaxujun jan tsëhë xi cuetsihin cuetjusehen ne, ngayun ne ha hyun ta ha jemu camatiña chan tsi. ");
INSERT INTO maqNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hacuaha xi cjuehe cjuañihi xi cachjá cojo nuju ne, vëhë sua cumachaya nuju ta ha tiña tacun xi cjuë ngasunhndë, hisca meje cumá. ");
INSERT INTO maqNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cuichjá cjuaquixi cojo nuju ta xuta xi siu quihndë ne, siu cuaha me hya xi cuetjucaa xcusun xi cachjá cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cuechu nixtin xi cjuë nangui, cjuë ngahnga. Peru cjua naha ne, tsajin nixtin xi cjuë. ");
INSERT INTO maqNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Sacuaha nixtin xi cuetjucaa cjuatacun vëhë ne, tsajin yo vëë rë janihya cuetjucaa. Hisca hvíin ángel xi siu ngahnga. Hisca hveen ngahan xi Quihndi rë Nina. Suva ni Nina ngu tutu nahmi naja ne, me vëhë xi vëë me janihya cumá. ");
INSERT INTO maqNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Vëhë xi nechun cuidadu, hacuaha ningascun rë hitsë cjuatacun nuju ta, ngayun ne, hyuun janihya xi cjuehe Nai nuju. Vëhë xi chjá cojo nuju ta ningascun rë hitsë cjuatacun nuju ta ngayun ne, hyuun janihya cúya, ¿há jñu ne?, ¿há ñahñu cjuëhë? ");
INSERT INTO maqNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ngahan ne, sacuaha ngu xuta xi cuetju cjue ngu nangui cjin. Chaja sa xi cuetjun me tsëhë ndava me, cuichja me cojo mosu rë me mé xa sahmi jimangu mosu. Hacuaha cuitexa ngu mosu xi cuahacuenda tingotjo ndava me. Cuatjin sahme. ");
INSERT INTO maqNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Vëhë xi chjá cojo nuju ta ningascun rë hitsë cjuatacun nuju ta ngayun ne, hyuun janihya cúya, ¿há jñu ne, há nixten ne, há tiña sahasen, o sa sahasen camahani cúya? Sa xi ñahñu cjuëhë hane tsajin tjin chjine ngayun. ");
INSERT INTO maqNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cuidadu sá xi ngu ñahñu nduvá hane ngayun ne, tsajin tjin chine ngayun. ");
INSERT INTO maqNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Xi chjá cojo nuju ne, ha cuanitjin ni chjá cojo yëjë ni xuta: Meje rë xi catitsingasca me hitsë cjuatacun rë me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Hya xi camá ne, casahmi chaja sa jo nixtin xi cuechu suhi tsëhë pascua ne, sacuaha xcusun niji ne, hya chini pan xi tsajin san rë. Ngajan xi nahmi xi matitjun jan cojo cha maestru tsëhë ley ne, jemu tivangui me chuva rë xi cuindacha me Jesús, cojo sa xi cuma cjuaha me me tsiquehen me me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Peru cachja me cojo xicjin me cuitjin: ―‍Ndatjin xi cuinechanyan ne, cuatju suhi sehe chjahanhma cha, ta sá xi tsajin ne, tu cumacjan rë xutacjín hane cumá ngu suë jyë. ");
INSERT INTO maqNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Hya ne, Jesús ne, nandya Betania quitaha me. Tacun me ndava cha Simón, cha xi camandaja tsëhë chíhin cjan rë xi cafaha rë chuxin yojo rë. Hora xi tacun me tijinë me niñu ne, cafehe ngu na xi yaha na ngu frascu ndyojo, hincha aceite tsëhë nardo xi jercu hnga chjí rë. Hane xi cavotohosun na rcu frascu hiscan hincha aceite jan ne, sehe quiji cavitejnu na aceite jan rcun Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ngujo me xi siu jan ne, camacjan rë me xi cuatjin casahmi na. Hane sehe cachja me ngajñi rë me cojo xicjin me cuitjin: ―‍¿Mé má cuatjin tu catsinguetsun na aceite vë? ");
INSERT INTO maqNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sá xi xteña vë, sacú tujún sacuaha tujún xi sacu rë ngu mosu xi casahmi xa ngu nu, hane tujún vëhë ne, cuma cuisecoo rë xuta yuma. ―‍Cuatjin cachjataha me na. ");
INSERT INTO maqNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngajan xi cachja Jesús cuitjin: ―‍Xi canujuun tsëhë na. ¿Mé má cuatjin tivichuncjun tsëhë na? ta, jemu venguichji rë xcusun xi casahmi na cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Xuta yuma ne, yëjë nu yëjë nixtin siu me ngajñi nuju. Peru ha ndaja ngahan ne, hacuiin jyë nixtin tejña cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Na vihi ne, casahmi na hacutjin xi chutaha na. Hane cojo chaja sa xi cueya ngahan ne, cavitejnu ná na aceite xi cuëhëchjine ni na yojo naha xi seyaniji ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cuichjá quixë cojo nuju ta tuyani tsëhë jingujyë ngasunhndë xi cuichja xuta cjua tsëhë Nina ne, hacuaha cueyanangui me na vihi cojo sa xi xuta xi yahnga ne, cumachaya rë me xcusun xi casahmi na cojo ná. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hya xi camá ne, cha Judas tsëhë nandya Queriote, cha ladu rë Jesús tsëhë cha xi tejó jan ne, quiji cha xcun nahmi xi matitjun ne, cavëhë chihin cha cjua cojo rë me xi sahmi me entregadu cha Jesús cojo rë nahmi jan. ");
INSERT INTO maqNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hya xi cahndë nahmi xi matitjun jan cjua rë Judas ne, jercu ndama camahani rë me. Hacuaha ngutjen ni cachja me ta, sua me cha tujún. Hane ngajan xi cha Judas jan ne, cavetsihin cavangui cha chuva rë hacutjin xi cuma sahmi entregadu cha Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hya xi camá ne, nixtin tjun tjun tsëhë suhi xi chini pan xi tsajin san rë, nixtin xi hacuaha niquihin chu tsánga tsëhë suhi tsëhë pascua ne, hya ne, cha ladu rë Jesús ne, cavinenguise cha cojo rë me cuitjin: ―‍¿Jani hiscan xi meje nuju xi cuanguin cuihinchjini xi xinëë nguixun tsëhë suhi vi? ");
INSERT INTO maqNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ngajan xi catsingatju me jo cha ladu rë me quiji cha tixa. Hane cuitjin cachja me cojo cha: ―‍Tangun nandya Jerusalén. Hane ngajan cuechuntuhun ngu cha xi nduva ne, quisun rcu cha ngu nisa nandá. Tangun cojo cha hacutjin cjui cha. ");
INSERT INTO maqNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hane ndihya xi cuisehen cha ne, tinújun cojo me xi nai rë ndihya jan cjua vihi: “Cuitjin chja maestru ta, ¿jarë cuartu hiscan xi sinë nguixun me cojo niji tsëhë pascua?” Cuatjin tinújun cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hane me vëhë ne, cjue tsingacun nuju me ngu cuartu jyë ngajan ndihya ngahnga hiscan xi ha tjin chjine. Hane ngajan tuhunndujun xi xinëë. ");
INSERT INTO maqNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hane ngajan xi cavetju cha xi cuacun jan quiji cha. Xi cafehe cha nandya Jerusalén ne, cuatjin camá tu tjin cachja Jesús cojo cha. Hane cavëhë ndaja cha xi sinë nguixun me cojo rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Xi quiji hora jan ne, cafehe Jesús cojo yëjë tejó cha ladu rë me. Hane quiji me caviyuju me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sehe cavetsihin cajinë me. Hora xi tijinë me jan ne, ngajan xi cachja Jesús cuitjin: ―‍Nguehe cuichjá cojo nuju cjuaquixi ta ngu ngayun xi nechan tichine cojo nuju nguehe ne, nihñu ná entregadu. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ngajan xi jemu choho camá rë cha, cavetsihin cha cachja cha chuva ngu chuva ngu cha, cuitjin cachja cha: ―‍Hacuiin ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ngajan xi cachja Jesús cuitjin: ―‍Ngajñi nuju xi tejó ngayun, ngajan jiyajñi ngu xi sahmi cuitjin. Ngu me xi ngu ni tyuva tsinguísehen quinda niñu naha cojo ne, me vëhë xi sahmi ná me entregadu. ");
INSERT INTO maqNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngahan xi Quihndi rë Xuta Jain ne, hatuxa tjin xi cueyá ta, xujun rë Nina ne, cuatjin chja. Peru xuma cha xi cuiteña ná. Vengui sa chji rë sá xi catsiin camahani cha. ");
INSERT INTO maqNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hora xi ha camatiña xi cuijnetaha sinë me niñu ne, cafaha Jesús ngu niñutsju, hane casua me nacuechji rë Nina, sehe cavotohocja me niñutsju jan. Hane sehe casua me ngu rquí ngu rquí niñu jan cha ladu rë me, hane cuitjin cachja me cojo cha: ―‍Juhun vihi ta, vihi ne, yojo naha. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Hacuaha cafaha nga me ngu vasu xi hincha xan rë uva, hane casua nga me nacuechji rë Nina. Hane sehe casua me tsë tsë cahvi cha jima ngu cha ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hacuaha cachja me cojo cha cjua vihi: ―‍Vihi jni naha xi cuetju ná ngatsë rë xuta. Xcusun vihi ne, ngu compromisu xatsë xi sehe tivëhëchihin Nina cojo xuta cojo sa xi jni naha ne, vëhë cuaxëtje rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cuichjá quixë cojo nuju ta ha quihndë cueen xan rë uva nguehe ngasunhndë. Cuëhë, peru hisca hya xi nduva Nina cuitexa me ngasunhndë, hya cuëhë, peru hacuiin tangun cumá. ―‍Cuatjin cachja Jesús cojo cha ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Xi cajnetaha cajinë me ne, casë me ngu tsëhë Nina. Sehe cavetju me quiji me Naxi Olivu. ");
INSERT INTO maqNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hane sehe ngajan xi chja me cojo cha ladu rë me cuitjin: ―‍Ngayujun ni ngayun cumanguaintacuun cojo ná ta cuma sacuaha camahindu xcun xujun rë Nina xi chja cuitjin: “Nina ne, tsiquehen me cha xi sahmi cuidadu rë chu tsánga. Hane chu tsánga ne, cuitsojo chu.” ");
INSERT INTO maqNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Cuatjin cumá, peru hya xi cúya nga cjuahñu naha ne, cjué titjun tsujun hiscan distritu Galilea. ");
INSERT INTO maqNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ngajan xi cachja cha Pedru cojo Jesús cuitjin: ―‍Ha ndasa ngayëjë cha xi cuicun vi cuejña suva cha ngayun ne, peru ngahan ne, cuejñaa nuju suvun. ");
INSERT INTO maqNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngajan xi cachja Jesús cojo cha cuitjin: ―‍Cuichjá quixë cojo ri ta tajñu ni xi chaja sa squindaya xahnda ne, ha jyan ndiya cuinoje xi hyiin yo ngahan. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peru cha Pedru ne, cavuya cachja nga cha cjua vihi: ―‍Ha ndasa hisca cueya cojo nuju ne, peru cuichjaain xi hveen yo ngayun. ―‍Cuatjin cachja cha. Hacuaha cuanitjin ni cachja cha xi yahnga. ");
INSERT INTO maqNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hya xi camá ne, cavetju me quiji me ngu cahndë́ xi hmí rë Getsemaní. Ngajan xi cachja me cojo cha ladu rë me cuitjin: ―‍Nechun ni nguehe ne, cjuë́ cuisiajme cojo Nina. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hya xi camá ne, cavaxë me cha Pedru cojo cha Jacobo cojo cha Juan, quiji me cojo cha. Ha xcun xi ha cjui cjui me jan ne, cavetsihin jemu casercun rë me, hacuaha macjincacun me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ngajan xi cachja me cojo cha cuitjin: ―‍Jercu choho má camahani rë xahasen naha. Xi má ná ne, cueya tsëhë. Nechun ni nguehe cuacun ngayun cojo ná. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sehe ngajan xi Jesús ne, quiji me hitsë ni nguvan. Hane ngajan cafañatsacjan me, cafehya rë me Nina sá xi tjin tu mé ni xi cumá cojo sa xi cuatjiin me cjuacjintacun xi cuatju me jan. ");
INSERT INTO maqNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hane cuitjin cafehya rë me Nina: ―‍Papá. Xi cumá nuju ngayun ne, yëjë ni xcusun ne, hacuiin chja cuma. Vëhë xi tiféhya nuju xi naxuntjun ná tsëhë cjuacjintacun xi cuátju cumá. Cuatjin meje ná, peru cjua xi cuinújun ne, cuatjin catama. ―‍Cuatjin cafehya rë me Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hya xi camá ne, cavuya cafehe nga me hiscan siu cha ladu rë me xi quijicojo me jan. Hane xi vutsejen me ne, siufë cha. Ngajan xi chja me cojo cha Pedru cuitjin: ―‍Simón, ¿mé má tsjuñife? ¿Há camaji cavacun ngayun cojo ná hisca ngu hora? ");
INSERT INTO maqNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nechun quicun, hacuaha chjahyun rë Nina cjuandaja rë me, cojo sa xi hacuiin chjaha chuva nuju cojo cjuatacun nuju. Xahasen nuju ne, ndaja meje rë xi nihñu, peru yojo nuju ne, chuva caa rë. ―‍Cuatjin cachja me cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hya xi camá ne, quiji nga me ngu ndiya hitsë ni nguvan. Hane ha cjua vëhë nga ni cavuya cafehya rë me Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hya xi cavuya nga me ne, siufë nga cha ladu rë me xi jyan jan, tsëhë xi ha quihndë ticaain rë cha xi jemu nijña rë cha. Xi catsingasca Jesús cha ne, sacuinyiin rë cha mé cuichja cha cojo me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Xi cavuya me xi quiji me má jyan ndiya ne, cachja me cojo cha ladu rë me jan cuitjin: ―‍Ha tsjuñufun cuaha. Juun, peru ha camá. Ha cavechu hora xi ngahan, Quihndi rë Xuta Jain, cjuaha ná xuta tsehen ta, ha caxteña ngahan. ");
INSERT INTO maqNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tisatjunhngun, cuanguen chutsejen ta, ha nduva cha xi sahmi ná entregadu. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ha tu tichja cuaha Jesús cojo cha ladu rë me ne, cafehe cha Judas, cha xi cojo jiyajñi ngajñi rë cha xi tejó jan. Hacuaha jercu cjín xuta tivisecoo rë cha hora xi nduva cha. Yaha me quicha. Yaha me ya. Nahmi xi matitjun cojo cha maestru tsëhë ley cojo xuta changá jan ne, me vëhë cavitexa me xutacjín jan xi quiji jaha me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Chaja sa xi cjuehe cha Judas cojo xutacjín jan hiscan tacun Jesús ne, ha cachja cha cojo xuta jan cjua vihi: ―‍Cha xi cjuë́ cuitátsuha xi suá rë nina ne, cha vëhë xi hacui cha. Chjuhun cha, hacuaha nihñu cha, sehe tangun cojo cha. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Xi tu cavechu cha hiscan nduva Jesús cojo cha ladu rë me xi yahnga jan ne, ngutjen quiji casahmi tiña cha tsëhë me, hacuaha casua cha me nina cuitjin: ―‍Cuhndanu, Maestro. ―‍Cuatjin cachja cha. Cafë cachja cha cuitjin ne, sehe cavitatsuha cha Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hya xi camá ne, quiji xuta jan ne, cafaha me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngajan xi ngu cha xi secun jan ne, cavaxë cha quicha nduju rë cha, hane cavaja rë cha ngu cha mosu rë nahmi xi matitjun ne, cavatësun cha ngu ladu tyjavañuju. ");
INSERT INTO maqNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ngajan xi cachja Jesús cuitjin: ―‍¿Mé má sacuaha vangun chjuhun xuta chëjë ne, cuatjin nduvun chjuhun ná? ta, quichuhun quicha quichuhun ya. ");
INSERT INTO maqNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ngahan ne, nchunchujun ni cavitejñaya yungun xi matitjun, cavicuyá rë xuta, hane ¿mé má cachjuun ná ngajan? Juun, peru cuatjin tijima cojo sa xi cuetjucaa jain hacutjin camahindu xcun xujun rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hya xi camá ne, cha ladu rë Jesús ne, cavejña suva cha me, hane cafë yëjë cha cavanga cha. ");
INSERT INTO maqNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngu sa cha jan yaja cha ngu tsjian tu të ni. Hane xi tu meje cjuaha xuta cha jan ne, tsjian ni rë cha cama cafaha me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Peru cha vëhë ne, cama cavanga cha tu quixti ni. ");
INSERT INTO maqNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hya xi camá ne, quijicojo xuta jan Jesús xcun nahmi xi matitjun. Hane xi cafehe cha cojo Jesús jan ne, sehe camatangun yëjë ni nahmi xi matitjun cojo xuta changá cojo cha maestru tsëhë ley. ");
INSERT INTO maqNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ngajan xi cha Pedru ne, quijitjengui cha Jesús tu cjin tu cjin ni. Cafehe cha hiscan ndatsen ndava nahmi xi matitjun jan. Hane ngajan cavéjña cha cojo cha nísë tjehen ndava ndihi, tsihasu rë cha yojo rë cha cojo cha nísë jan. ");
INSERT INTO maqNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hane nahmi xi matitjun jan cojo yëjë sa xuta xi matitjun ne, cavangui me xuta xi tsinguixi jyë́ rë Jesús, cojo sa xi cuma tsiquehen me me. Peru tsajin mé jyë́ rë Jesús casacu rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ha ndasa jemu cjín xuta xi cavinchajyë me Jesús ne, peru suva cjuandesu yëjë ni cjua xi cachja me ta, hacjahi chja ngu ne, hacjahi chja ngu. Hacuiin tangun má cjua rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ngujo me ne, chja me ta cahndë me xi cuitjin cachja Jesús: ");
INSERT INTO maqNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ngahan ne, tsinguétsun yungun xi matitjun xi casahmi xuta vë, hane cahntsua xi jyan nixtin ne, sahme nga ngu. Peru hacuiin cojo tsja xuta xi cuma hya.” Cuahaxutjin cahndë me xi cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hisca me xi cuacun jan ne, hacuaha hacuiin tangun camá cjua rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ngajan xi nahmi xi matitjun tsëhë nahmi xi yahnga jan ne, casecunvasen me, hane sehe cavinenguise me Jesús cuitjin: ―‍¿Há chjayinnguiin hisca xi ngu cjua tsëhë jyë́ riji xi vincha xuta xi cuicun vi? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Hane Jesús ne, tu jyuu ni casecun me. Hisca ngu cjua cafayanguiin me. Hya xi camá ne, cavinenguise nga nahmi xi matitjun jan ngu ndiya cojo Jesús cuitjin: ―‍¿Há ngaye xi Quihndi rë Nina naja? ¿Há ngaye xi catsingatju me xi cumá titjun tsijin? ");
INSERT INTO maqNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ngajan xi cafayangui Jesús cuitjin: ―‍Juun, ngahan. Hacuaha cjuehe nixtin xi chutsujun ná xi tejña ladu quixi tsëhë Nina. Hacuaha chutsujun ná xi cuinduva ngajñi rë yufí, xi cúya nga tsëhë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hane ngajan xi nahmi xi matitjun jan ne, jemu camacjan rë me ne, hisca tsjian rë me cavicheya me. Hane cuitjin cachja me: ―‍¿Mé sa cjua xi mameje? ");
INSERT INTO maqNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ngayun ne, ha canuhyun hacutjin xi tsixcuehyu cha Nina. ¿Mé xi nújun quihndë? Ngajan xi yëjë xuta jan ne, cachja me ta meje rë xi cueya Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hane cavetsihin ngujo me cavëhë natya me Jesús. Hane hacuaha cavatsa me xcun Jesús, sehe cavetsihin cavaja me. Sehe ngajan xi cachja me cuitjin: ―‍Tinoje yo xi cavaja ri. Hya xi camá ne, cavetsihin xi cha nísë jan ne, jemu cavaja cha me. ");
INSERT INTO maqNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jinguyëjë rë xi cuatjin tijima ne, cha Pedru ne, tacun cha ndatsen ndihya. Hya xi camá ne, hora vëhë canduva ngu na xi sahmi xa ndava nahmi xi matitjun jan. ");
INSERT INTO maqNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hane cavëë na xi tacun cha Pedru tsihasu rë cha yojo rë cha hiscan tacun ndava ndihi. Hane casecun na cafahacuenda na cha. Sehe ngajan xi cachja na cojo cha cuitjin: ―‍Ngayun ne, ladu rë Jesús tsëhë nandya Nasaret ngayun. ");
INSERT INTO maqNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngajan xi cachja cha Pedru cuitjin: ―‍Hisca hveen mé xi noje. Hya xi camá ne, sehe cavetju cha quiji cha casecun cha hiscan tu cuiseen ni tsëhë ndatsen ndihya. ");
INSERT INTO maqNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hane ngajan xi na xi sahmi xa tsëhë nahmi jan ne, cafahacuenda nga na cha hiscan quisecun cha. Hacuaha cavetsihin nga na cachja na cojo xuta xi hinchacun jan cuitjin: ―‍Cha vëhë ne, ladu rë Jesús má cha. ");
INSERT INTO maqNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Xi tu cahndë cha Pedru xi cuatjin cachja na jan ne, ngutjen cafayangui cha xi quixiin xi chja na. Xi cafë ngu hora lihndi ne, hacuaha cachja xuta xi hinchacun jan cojo cha cuitjin: ―‍Quixi jain xi ladu rë Jesús má ngaye ta distritu Galilea ne, ngajan nangui riji. ");
INSERT INTO maqNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sehe ngajan xi hisca Nina caveyanangui cha Pedru ne, cachja cha xi hvíin cha me, cuitjin cachja cha: ―‍Vëë Nina jain xi hveen yo me xi nújun vë. ");
INSERT INTO maqNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hane hora vëhë ne, cajihnda xahnda. Hya xi camá ne, catsinguitsjen cha Pedru cjua xi cachja Jesús cojo cha xi cachja me cuitjin: “Chaja sa xi squihndajo xahnda ne, ngaye ne, ha jyan ndiya cuinoje xi hyiin yo ngahan.” Hora xi catsinguitsjen cha cjua vëhë ne, cajihnda cha. ");
INSERT INTO maqNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hya xi casahasen xi camá nchujun jan ne, camatangun nga nahmi xi matitjun cojo xuta changá cojo cha maestru tsëhë ley cojo yahnga sa xutaxa rë xi hinchajñi me. Sehe catsihñu me Jesús ne, sehe quijicani me xcun gobernador xi hmí rë Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Xi cafehe me cojo Jesús xcun Pilatu ne, sehe cavinenguise Pilatu cojo Jesús cuitjin: ―‍¿Há ngaye xi matitjun ngaye tsëhë xuta nangui Israel? Ngajan xi cafayangui Jesús cuitjin: ―‍Cuatjin sacuaha canújun vë. ");
INSERT INTO maqNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hane ngajan xi nahmi xi matitjun jan ne, jemu cjín xcusun jyë́ xi cavincha me tsëhë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ngajan xi Pilatu ne, cavuya cavinenguise nga me Jesús cuitjin: ―‍¿Há chjayinnguiin camahani? Jercu cjín jyë́ riji cavincha me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Peru Jesús ne, ha quihndë cafayinnguiin camahani me. Hane Pilatu ne, jemu quijircun camahani rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Suhi vëhë ne, Pilatu ne, ha tuxa xcusun rë me xi nu nu ni vëhëndaya me ngu presu xi meje rë xuta xi cumandaya. ");
INSERT INTO maqNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ndavaya ne, jiya ngu presu xi hmí rë Barrabás cojo ngujo sa presu xi catsiquehen rë xuta tsëhë ngu si. ");
INSERT INTO maqNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hya xi camá ne, canduva xutacjín ne, cafehya me cojo Pilatu xi sahmi me vëhë sacuatjin xi ha xcusun rë me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ngajan xi cachja Pilatu cojo rë xuta jan cuitjin: ―‍¿Há meje nuju xi cuáxë cha xi matitjun tsujun? ");
INSERT INTO maqNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Cuatjin cachja Pilatu ta tsëhë xi ha vëë me xi ngatsë rë cjuaxin sahmi nahmi xi matitjun jan cojo Jesús, vëhë xi quijicani me Jesús ngajan. ");
INSERT INTO maqNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Peru nahmi xi matitjun jan ne, quiji cavinchangui me xutacjín jan xi meje rë me xi cuichja xuta jan xi catëhëndaya Pilatu Barrabás. ");
INSERT INTO maqNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ngajan xi cavinenguise nga Pilatu cojo xutacjín jan cuitjin: ―‍¿Mé sahme cojo cha xi nújun xi matitjun tsujun ni? ");
INSERT INTO maqNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngajan xi xuta jan ne, cuitjin jercu cachja me: ―‍Tetuhun cha xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ngajan xi cachja Pilatu cojo rë me cuitjin: ―‍Peru ¿mé xi choho casahmi cha? Peru xuta jan ne, hitsë sa rcu cachja me cuitjin: ―‍Tetuhun cha xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hya xi camá ne, ta meje rë Pilatu xi cumangucacun xuta ne, cavëhëndaya me Barrabás. Hane xi cavatju catsingatju me Jesús casehen rë ne, sehe cavuya casua nga me cojo cha sindadu xi cjue cuetaha cha me xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hya xi camá ne, quijicojo cha Jesús taha cahntsua hnchua hiscan ndatsen ndava Pilatu. Hane sehe casahmi tangun sa cha yëjë sindadu cjín. ");
INSERT INTO maqNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hya xi camá ne, cavaxë cha tsjian rë Jesús, hane sehe catsicaja cha me ngu tsjian hani. Hacuaha catsihya cha ngu corona nahyá xi cavesun cha rcu me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sehe cavetsihin cavincha cha viva rë me xi tsixcuehyu cha me, sacuaha xi macjain rë me xi me vëhë matitjun me tsëhë xuta tsëhë nangui Israel. ");
INSERT INTO maqNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hya xi camá ne, sehe cavaja cha ngu rquí ya rcu me. Cavëhë natya cha me. Hacuaha cavixcuhnchi cha xcun me, sacuaha xi faharcun cha me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hya xi cajnetaha catsixcuehyu cha me cuatjin ne, sehe cavaxë cha tsjian hani xi catsicaja cha me, hane sehe cavuya catsicaja nga cha me tsjian rë me xi tsëhë jain me. Hya xi camá ne, sehe quijicojo cha me xi cuetaha cha me xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ndiya cjui cha cojo me ne, cavechutaha cha ngu xuta changá xi hmí rë Simón tsëhë nandya Cirene, nahmi rë cha Alejandru cojo cha Rufu. Nduva me xi quiji me nguijña. Hane xi cavechutaha cha me, casahmi cha me ngujyë xi cuesuntyja me cru rë Jesús. Hya xi camá ne, cavesuntyja me, sehe quiji me cojo. ");
INSERT INTO maqNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sehe cavechu yëjë xuta jan hiscan xi hmí rë Gólgota, cjua xi meje cuichja Naxi Nínda Rcuun. ");
INSERT INTO maqNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sehe xuta jan ne, tisua me xan rë uva xi tecjan rë nandá rë tyjungunsa xi cuihi Jesús, peru cahviin me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hya xi camá ne, cavetaha cha me xcun cru. Hane tsjian rë me ne, cavincha rë cha ngu suerte ne, sehe cumatsejen mé xcusun tsjian rë me xi satë rë xingu xingu cha. ");
INSERT INTO maqNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hya ne, chuva rë fane ñaja tsëhë nguitajñu. ");
INSERT INTO maqNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hane camahindu ngu letreru cojo jyë́ rë me xi chja cuitjin: “Me xi Matitjun tsëhë Xuta nangui Israel.” Sehe quiji casetaharcu cru. ");
INSERT INTO maqNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hacuaha cavityangui cha ngu chëjë ngu ngu ladu rë tjehen rë me, jimangu cojo cru rë. ");
INSERT INTO maqNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Cuatjin cavetjucaa cjua xi camahindu xcun xujun rë Nina xi chja cuitjin: “Cuichja xuta ta me vihi ne, ngu xuta tsehen me.” ");
INSERT INTO maqNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hya xi camá ne, xuta xi cavatju jan ne, xi catsixcuehyu me Jesús ne, catsiniya me rcu me, hacuaha cuitjin cachja me: ―‍Canoje xi cuma ninguetsin yungun xi matitjun, hane cahntsua xi jyan nixtin ne, cama nga canindeje sove. ");
INSERT INTO maqNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Quihndë ne, sá cuatjin cuma nihñi ne, naxetje sove yojo riji, titujni tsëhë cru vë. ―‍Cuatjin cachja xuta. ");
INSERT INTO maqNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ha chuva vëhë ni, cavisiajmi nahmi xi matitjun cojo cha maestru tsëhë ley ne, ngajñi rë me cojo xicjin me xi tsixcuehyu me Jesús. Cuitjin chja me: ―‍Cavaxëtje cha xuta, peru quihndë ne, maji vaxëtje cha yojo rë cha. ");
INSERT INTO maqNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Sá xi hacui jain cha xi catsingatju Nina xi cumatitjun tsajan ne, catitujne cha tsëhë cru chutsejen, cojo sa xi cumacjain naja tsëhë cha. ―‍Cuatjin cachja me tsëhë Jesús. Hacuaha cha chëjë xi cojo xtyangui taha cru jan ne, cojo cha choho cachja cha tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Xi camanchisen tsëhë nixtin vëhë ne, jingujyë ni ladu vëhë ne, camajñu. Jyan hora quijicani rë. ");
INSERT INTO maqNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Xi cafë jyan hora vëhë ne, jercu cajindaya Jesús, cachja me hne rë me cuitjin: ―‍Eloí. Eloí, ¿lama sabactani? ―‍cjua xi meje cuichja cuitjin: Ngayun, Nina naha, ¿mé má canismutacun ná? ");
INSERT INTO maqNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hane ngujo xuta xi hinchacun jan ne, xi cavijniinrcu me hne rë Jesús ne, xi má rë xuta jan ne, nima Elías, ngu profeta tsëhë nixtin hatsëë, jindaya Jesús me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hane sehe cavanga ngu me quiji catsicahnchi me ngu tsjian hinda cojo xan rë uva xi ha san. Sehe cavetaha me rcu ngu ya nduju, sehe cavetaha me hntsua Jesús xi cuihingui me. Hacuaha chja me cojo xicjin me cuitjin: ―‍Cuinechanyan hitsë ne, ¿há cuinduva jain Elías tsitujne me Jesús tsëhë cru? ");
INSERT INTO maqNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Peru Jesús ne, hora vëhë jercu cajindaya me, hane cahme me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hacuaha hora vëhë ni ne, tsjian nduju xi tyjangui cahntsua yungun xi matitjun ne, hisca rcu hiscan ntsacu canduva catiyavasen. ");
INSERT INTO maqNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hya xi camá ne, ngu cha capitán tsëhë sindadu xi secun tiña cru hisca tyjangui Jesús jan ne, xi cavëë cha hacutjin xi cahme Jesús ne, ngajan xi chja cha cuitjin: ―‍Cjuaquixindaja xi me vihi xi Quihndi rë Nina me. ");
INSERT INTO maqNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hacuaha hinchacun sa ngujo yachjin, vutsejen na tsëhë cjin ni. Ngajñi rë na xi cuacun vëhë ne, quisecun na Salomé cojo na María tsëhë nandya Mágdala cojo na María naa rë cha Jacobo lihndi cojo cha José. ");
INSERT INTO maqNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na yachjin xi cuacun vë ne, cojo na cavisecoo na catsindaja na xi cajinë Jesús cojo cha ladu rë me, hya xi catsujyihiya me ngajan ladu tsëhë distritu Galilea. Hacuaha jercu cjín sa yachjin hinchacun na jan xi hacuaha cojo na quiji na ngajan nandya Jerusalén cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nixtin xi cahme Jesús ne, hacuaha hya vispra tsëhë nixtin xi chjahájenda rë. Hane xi quiji hora jan ne, ");
INSERT INTO maqNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ngu xutaxa rë xi tjemu chjahanrcun rë, xi hmí rë José tsëhë nandya Arimatea, me xi hacuaha tacunya nixtin xi cjuehe Nina cuma titjun me tsëhë yëjë Israel, cavejñahñu me cjuatacun rë me sehe quiji me ndava Pilatu. Hane cafehya me cahndë́ cojo Pilatu xi cjuahaxin me nima Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Hya xi camá ne, Pilatu ne, quijircun rë me xi cuatjin cachja José xi ha cahme nima ta, tsëhë xi cjëë jyë hora xi casetaha Jesús xcun cru. Hane vëhë xi catsingatju me quiji chjaha rë cha capitán. Hane sehe cavinenguise me cha sá xi quixi xi ha cahme jain Jesús. ");
INSERT INTO maqNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Xi tu camachaya rë me cjua tsëhë cha capitán jan xi ha cahme jain Jesús ne, sehe ngajan xi cachja me cojo José ta cuma cjue tsitjujne me nima. ");
INSERT INTO maqNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ngajan xi José ne, vëhë ta cavatsë me ngu tsjiantë xatsë ne, sehe quiji catsitujne me nima Jesús tsëhë cru, sehe cavaxtë rë me tsjian jan. Hane sehe cavaha me nima quijicojo me hiscan tacun rë me ngu tsjun xi cafahanguitaha me cahntsua ngu naxi. Hane ngajan caveya me nima. Sehe catsindefajne me ngu ndyojo jyë xi cavechja rë tingotjo tsjun jan. ");
INSERT INTO maqNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Hane na María tsëhë nandya Mágdala cojo na María naa rë cha José ne, cavëë na hiscan caseya nima. ");
INSERT INTO maqNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Xi camá nguixun tsëhë nixtin xi chjahájenda rë jan ne, na Salomé cojo na María tsëhë nandya Mágdala cojo na María naa rë cha Jacobo ne, cavatsë na rqui xi ndaja jne xi cuitejnu na nima. ");
INSERT INTO maqNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Xi casahasen domingu ne, hora xi tivetjucaa tsuhi ne, cavatju na yachjin jan quiji na hiscan tacun tsjun rë nima. ");
INSERT INTO maqNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hane ngajñi cjui na jan ne, ngajan xi chja na cojo xicjin na cuitjin: ―‍¿Yo cuisecoo naja xi nindefajne ndyojo xi quitaha tingotjo rë tsjun jan? ");
INSERT INTO maqNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Peru xi tu cafehe na jan ne, ndyojo jyë xi quitaha tingotjo rë tsjun jan ne, ha quihndë tsajin quitaha cahndë́ rë ta ha xin jiña. ");
INSERT INTO maqNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Xi cavisehen na cahntsua tsjun jan ne, cavëë na ngu cha xi tacun cha taha ladu quixi, yaja cha ngu tsjian tyava nduju. Hya xi camá ne, jemu catsacjun camahani na. ");
INSERT INTO maqNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ngajan xi cachja cha cojo rë na cuitjin: ―‍Xicarcuun. Ngahan ne, ha hvë xi Jesús tsëhë nandya Nasaret vinchunsun me, me xi cavetaha xuta xcun cru. Peru me vëhë ne, tsajin me nguehe ta cavuya cjuahñu rë me. Chutsujun cahndë́ hiscan xi cafaña xuta me. ");
INSERT INTO maqNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Quihndë ne, tjangun sanii ne, tinújun cojo cha ladu rë me, cha Pedru ne cojo cha xi yahnga ta, Jesús ne, hisca tjun cuechutaha me yun ngajan distritu Galilea sacuahatjin xi ha cachja me cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Xi tu cavetju na tsëhë tsjun jan ne, ña fatsë na xi jemu catsacjun na camá. Hane vanga sanii na cafe na. Hane hisca xi ngu cachjaain na cojo, tsëhë xi jemu catsacjun na camá. ");
INSERT INTO maqNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús ne, xati camaha sa tsëhë nixtin domingu ne, hya cavuya cjuahñu rë me. Hya xi camá ne, tjun sa na María tsëhë nandya Mágdala cavëë na me, na xi cavaxë me yatu xitsehen xahasen rë hatsëë. ");
INSERT INTO maqNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hane na vëhë quiji quicun na xuta ladu rë me xi jemu jihnda tsëhë cjuachoho. ");
INSERT INTO maqNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hane xi cahndë me cjua ta Jesús tacun nga me cjuahñu hane na vëhë ne, cavëë na me, camacjaain rë xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hya xi cavatju vëhë ne, jo cha ladu rë Jesús ne cjui cha nguijña. Hane cojo Jesús cjui me cojo cha, peru ha ngu xcusun jyihi me. ");
INSERT INTO maqNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hane cha xi cuacun jan ne, xi tu cavëë cha xi hacui me ne, cavuya cha ne, quiji cachja cha cojo cha xi yahnga xi cavëë cha me. Peru hacuaha camacjaain rë cha xi yahnga jan. ");
INSERT INTO maqNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ngu ndiya nga ne, cafehe nga me hiscan siu cha ladu rë me xi tengu jan, tijinë cha niñu. Hane cachjataha me yëjë ni cha ngatsë rë xi jemu taja rcu cha, tsëhë xi camacjaain rë cha tsëhë xuta xi cavëë rë me xi tacun nga me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Cavatju cacjan me cojo cha ne, sehe ngajan cavetsihin cachja me cojo cha cuitjin: ―‍Tangún jingujyë ni ngasunhndë ne, tinújun cojo yëjë ni xuta cjua rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yo xi cumacjain rë cjua vëhë hacuaha xtenda ne, cuechu xcun Nina. Yo xi cumacjaain rë ne, cuechu me castigu xi sahmi Nina xi cueyun. ");
INSERT INTO maqNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Hane xuta xi cumacjain rë me ne, sahmi me xcusun vihi xi cueyanangui me ñihi naha ne: cuma cuaxë me xitsehen xi hincha xahasen rë xuta; cuma cuichja me ngu ngu xcusun hne; ");
INSERT INTO maqNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","yë ne, sá xi cjuahatsja me chu, o sá xi cuihi me ngu venenu ne, tsajin mé cumá rë me; hane tu cuetahatsja ni me xuta hmu rë ne, cumandaja xuta hmu rë jan. ");
INSERT INTO maqNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Xi cajnetaha cachja Jesús, me xi Nai naja, cojo cha ladu rë me cjua vëhë ne, quiji me ngahnga, cavéjña me ladu quixi tsëhë Nina. ");
INSERT INTO maqNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hane cha ladu rë me ne, cavetju cha quiji cha, cachja cha cjua rë Nina yëjë ni ladu. Hacuaha Nai naja ne, cavisecoo me cha. Hane ngatsë rë xcusun xi cavëë xuta xi casahmi cha jan ne, vëhë xi tsejen xi quixi cjua xi cachja cha.");
INSERT INTO maqNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Jemu cjín xuta xi ha catsihindu me cjua xi chja tsëhë yëjë xcusun xi sehe casahmi Nina ngajñi naja ngayaan xuta ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Meje tsihindu me cjua vëhë sacuatjin camahani casua camachaya naja me xi cavëëndaja cojo tuxcun hisca ntsacu cavetsihin sehe cafahaxa me xi tsinguitsojo me cjua jan. ");
INSERT INTO maqNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hisca hatsëë ne, ngahan ne, hacuaha ha jemu ndaja cavinenguësë yëjë ni hacutjin camá. Vëhë xi xi má ná ne, hacuaha ndatjin xi tsihindu chichihin nuju cjua tsëhë yëjë hacutjin camá, ngayun tatá Teófilo, ");
INSERT INTO maqNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","cojo sa xi sacúndaja nuju cjuaquixi tsëhë cjua xi ha camachaya nuju jan. ");
INSERT INTO maqNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nixtin hya xi Herodes cavitexa me yëjë ni xuta tjë rë Israel ne, cavéjña xu ngu nahmi xi hmí rë Zacarías, me xi má ladu rë Abías. Hane chjuun rë Zacarías ne, Elisabet hmí rë me, hacuaha tjë rë Aarón xu má me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hane Zacarías cojo Elisabet ne, tyjahi cjuatacun rë me xcun Nina ta, tsëhë xi tsajin xu jyë́ rë me xi tisahmichihin me yëjë ni sacuatjin cavitexa Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hane tsajin rë me quihndi ta, tsëhë xi Elisabet ne, hatuxa maji xu sacu rë me quihndi, hacuaha catsijo ni me ne, ha jemu changá xu me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Hya xi camá ne, cavechú nixtin xi casatë rë Zacarías cojo yëjë sa nahmi xi má ladu rë Abías xi sahmi xu me xá xcun Nina xi má me nahmi. ");
INSERT INTO maqNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Hane sacuaha xcusun rë nahmi ne, catsintsavë xu me ngu suerte cojo sa xi cuma tsejen ne, jarë xu me xi satë rë xi cuisehen ndava Nina, cuaca tyjungunsa. Hya xi camá ne, casatë xu rë Zacarías. ");
INSERT INTO maqNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hane yëjë xutacjín jan ne, caviyuju xu me candatsen sahmi me oración rë me, hora xi tivaca xu Zacarías tyjungunsa cahntsua ndava Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hane hora xi tivaca me tyjungunsa jan ne, camatsejen xu ngu ángel secun taha ladu quixi tsëhë ngasunscun hiscan xi tí tyjungunsa. ");
INSERT INTO maqNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hane xi cavëë Zacarías ángel jan ne, jemu quijircun rë me hacuaha jemu catsacjun xu me camá. ");
INSERT INTO maqNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ngajan xi ángel jan ne, cuitjin xu cachja cojo rë me: ―‍Xicarcuiin ngaye Zacarías ta, cjua xi cachjahye ne, cahndë Nina. Vëhë xi na Elisabet chjuun riji ne, sacú rë na ngu quihndi, hane quihndi vëhë ne, Juan tehe ñihi rë. ");
INSERT INTO maqNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hane jemu cjue ri cjuasua hacuaha jemu ndaja cuma ri, hacuaha jemu cjín xuta xi jercu tjin rë me cjuasua xi catsin quihndi vëhë ta, ");
INSERT INTO maqNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tsëhë xi jemu jyë hnga cuma cojo cjuatacun rë ngajan xcun Nina. Hacuaha cuiin camahani xan hacuaha cuiin camahani nandá machihi. Hacuaha hisca hya xi caseya quihndi vë cahntsua naa rë ne, Hasen rë Nina quitsë rë xahasen rë. ");
INSERT INTO maqNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hacuaha quihndi vëhë sahmi xi jemu cjín xuta tjë rë Israel cuya nga me ndiya rë Nina rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Quihndi vë ne, vëhë cuinduva titjun, sehe cuinduva Nina. Hane sacuatjin jyë hnga profeta Elías cojo cjuatacun rë me hatsëë nixtin ne, hacuanitjin ni jyë hnga cuma quihndi vëhë cojo cjuatacun rë, cojo sa xi quihndi vëhë ne, sahmi xi cuya cuma ndaja cacun nga yëjë ni nahmi rë nixti cojo nixti rë me, hacuaha sahmi xi yëjë xuta xi vihndiin me tsëhë Nina ne, cuma tangun cjuatacun rë me cojo cjuatacun rë xuta xi tyjahi cjuatacun rë me. Hane cuatjin chuva vëhë ne, cuëhëchjine quihndi vëhë xuta xi cuihndë me tsëhë Nina. ―‍Cuahaxutjin cachja ángel. ");
INSERT INTO maqNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sehe ngajan xi Zacarías ne, cuitjin xu cavinenguise me ángel: ―‍¿Hacutjin sacú ná cjuaquixi xi cuatjin jain cuma ni? ta ngahan ne, ha jemu changá ngahan, hacuanitjin ni chjuun naha ta jemu changá na. ―‍Cuahaxutjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sehe ngajan xi ángel jan ne, cuihixutjin cafayangui nga: ―‍Ngahan xi Gabriel ngahan; ngahan xi tejña ngajan xcun Nina. Hacuaha ngahan xi catsingatju ná Nina xi cuisiajme cojo ri hacuaha suá cumachaya ri cjuandajyihi vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Chutsijin ni, quihndë ta camacjaain ri tsëhë cjua xi cachjá cojo ri ne, cumaji cuinoje, tsëhë xi cuma lihmi ngaye hisca hya xi cuetjucaa cjua xi cachjá cojo ri. Cjua vëhë ne, hatuxa cuetjucaa hya xi cuechú nixtin rë. ―‍Cuahaxutjin cafayangui ángel. ");
INSERT INTO maqNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jinguyëjë rë ne, xutacjín jan ne, jercu siuya xu me Zacarías, hisca fircun rë me tsëhë xi cuatjin jercu vindeya rë Zacarías xi cavisehen xu me ndava Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hane hya xi cavetju me ne, maji xu chja me cojo xuta. Hane xuta jan ne, cavacun rë me ta Zacarías ne, tjin mé xi cavëë me. Hacuaha tu tisahmitsja ni me ta, tsëhë xi lihmi cuaha xu me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hya xi cavatju nixtin xi satë rë me xi sahmi me xá xi má me nahmi ne, cavuya cafe xu me ndava me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hya xi camá ne, xi cavatju sa nixtin ne, casacu xu rë chjuun rë me quihndi, hane cahntsua hñú sá xi jiya quihndi rë Elisabet jan ne, cuatjin caseyahma xu me ndava me. Hane cuitjin xu cachja suvá me: ");
INSERT INTO maqNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Cuitjin casahmi Nina cojo ná ngu cjuandaja, quihndë xi camayuma rë me ngahan hane cafahaxin me cjuasava xi má ná ngajñi rë xuta tsëhë xi sacuiin ná quihndi.” Cuahaxutjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Xi ma jyun sá xi jiya xu quihndi rë Elisabet ne, catsingatju Nina ángel xi hmí rë Gabriel ngu nandya xi hmí rë Nasaret, tsëhë distritu Galilea, ");
INSERT INTO maqNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ndava ngu chjuun xungun xi hmí xu rë María. Hane María jan ne, tacunvasen cjuavixan rë me cojo ngu xihin xi hmí rë José, ngu me xi tjë rë David, ngu xutachanga xi camatitjun xu tsëhë xuta tjë rë Israel. ");
INSERT INTO maqNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hane xi cavisehen ángel ndava María jan ne, sehe cachja xu cuitjin: ―‍Cuhndari, tsan. Nina ne, catsinchacun me ngaye, hacuaha tacun me cojo ri. Ngajñi rë yëjë ni yachjin ne, ngaye xi jercu catsinchacun ri Nina. ―‍Cuatjin xu cachja ángel. ");
INSERT INTO maqNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Xi cahndë xu María cjua xi cachja ángel jan ne, catsacjun me camá, sehe catsingataha cacun xu me mé xcusun nina xi casua ángel me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sehe ngajan xi ángel ne, cuitjin xu cachja cojo rë me: ―‍Xicarcuiin María ta Nina ne, jemu tjin rë me cjuandaja cojo ri. ");
INSERT INTO maqNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Quihndë ne, sacú ri ngu quihndi, hane hacuaha cuechú nixtin xi tsin ri quihndi vëhë. Quihndi vëhë ne, tehe ñihi rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hacuaha jemu jyë hnga cuma cojo cjuatacun rë, hacuaha Quihndi rë Nina xi Matitjun cjuahañihi. Hacuaha Nina sahmi me xi cuitexa quihndi vëhë sacuatjin cavitexa xutachanga rë, me xi hmí rë David. ");
INSERT INTO maqNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Hane vëhë cuitexa rë xuta tjë rë Israel, hane gubiernu rë ne, tsajin nu tsajin nixtin cuijnetaha. ―‍Cuatjin xu cachja ángel. ");
INSERT INTO maqNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Sehe ngajan xi María ne, cavinenguise xu me ángel cuitjin: ―‍¿Hacutjin cuma xcusun vi? ta ngahan ne, cjëë sacú xihin naha. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hane xi cafayangui ángel ne, cuitjin xu cachja: ―‍Hasen rë Nina xi Matitjun ne, cuinduva cuaxtë ri sacuaha ngu tjahnguen. Vëhë xi quihndi xi tsin ri ne, hatuxa tyjahi cojo cjuatacun rë, hacuaha Quihndi rë Nina Jain. ");
INSERT INTO maqNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hacuaha na Elisabet xinguin ne, handasa ha jemu changá na ne, hacuaha casacu rë na ngu quihndi. Ha quihndë jyun sá yaha na quihndi, na xi chja cjua xi hatuxa maji sacu rë quihndi. ");
INSERT INTO maqNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Cuatjin camá ta, xi cuma rë Nina ne, tsajin camahani mé xi cumaji cuma. ―‍Cuatjin xu cachja ángel. ");
INSERT INTO maqNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ngajan xi María ne, cuitjin xu cafayangui me: ―‍Ngahan ne, sacuaha ngu hndixahan rë Nina ngahan. Catisahmi Nina cojo ná sacuatjin cjua xi canújun. ―‍Cuatjin xu cachja me. Ngaxtun vëhë ne, sehe cafe ángel. ");
INSERT INTO maqNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nixtin hya ne, cavetju xu María, ngu quixi ni quiji me ngu nandya ngajan nangui ndetjún tsëhë distritu Judea. ");
INSERT INTO maqNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hane xi cafehe me ngajan ne, cavisehen xu me ndava Zacarías, sehe cachja me nina cojo Elisabet. ");
INSERT INTO maqNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hane xi cahndë xu Elisabet xi cachja María nina ne, cafiniya xu quihndi xi jiya cahntsua Elisabet. Ngajan xi Elisabet ne, catsë rë xahasen rë me cojo Hasen rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Hane sehe jercu hñu xu cachja me cjua vihi cojo María: ―‍Ngajñi rë yëjë ni yachjin ne, ngaye xi jercu catsinchacun ri Nina, hacuaha catsinchacun me quihndi xi tsin ri. ");
INSERT INTO maqNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¡Mé má ngahan xi tu ngaye xi naa rë nai naha ngaye, ndove tichusihinye ná! ");
INSERT INTO maqNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Xi tu cahndë xi canoje nina cojo ná ne, hora vëhë cafiniya quihndi xi jiya cahntsuá xi ndama rë. ");
INSERT INTO maqNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jemu ndaja tsiji xi macjain ri xi yëjë ni cjua xi cachja Nina cojo ri ne, cuetjucaa jain. ―‍Cuatjin xu cachja Elisabet. ");
INSERT INTO maqNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sehe ngajan xi María ne, cuitjin xu cachja me: Ngahan ne, jercu sahme jyë sahme hnga Nina; ");
INSERT INTO maqNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","hacuaha jercu ndama ná tsëhë Nina, me xi vaxëtje ná. ");
INSERT INTO maqNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Casahmicuenda Nina ngahan, ngahan xi sacuaha ngu hndixahan rë me ngahan ta, quihndë cojo nixtin xi cjui sa ne, cuichja yëjë xuta xi siu cojo xuta xi sehe tsin sa xi jemu ndaja tsahan; ");
INSERT INTO maqNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tsëhë xi Nina xi jemu jyë hnga me cojo ngahñu rë me ne, jemu vengui chji rë xcusun xi casahmi me cojo ná. ¡Jemu tyjahi me cojo cjuatacun rë me! ");
INSERT INTO maqNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nina ne, hatuxa jemu tjin rë me cjuayumatacun cojo yëjë xuta xi faharcun rë me ha tucutjin cjín xuta tisetsin me jima ngundiya jima ngundiya. ");
INSERT INTO maqNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nina ne, sahmi me hacutjin xi meje sahmi me cojo ngahñu jyë xi tjin rë me: tsinguitsojo me yëjë xuta xi jemu tjin rë cjuaxta cahntsua xahasen rë; ");
INSERT INTO maqNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","tsinguijne me xuta xi matitjun tsëhë xcun xá rë, hacuaha sahmi yehe sahmi hnga me xuta yuma. ");
INSERT INTO maqNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Xuta xi machaja rë me ne, jemu yehe cjuandaja sua Nina me, peru xuta nchina ne, suvá tsja tiya me tsicuya Nina me cjue me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nina ne, cuisecoo naja me ngayejen ni xuta tjë rë Israel, ngayaan xi tsëhë me ngayaan, hacuaha tsinguitsjen me xi cumayuma rë me ngayaan. ");
INSERT INTO maqNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Xi cuatjin ne, cuetjucaa jain sacuatjin xi ha cachja me cojo xutachanga naja Abraham, cojo yëjë sa tjë rë me. Cuatjin xu cachja María. ");
INSERT INTO maqNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Hya xi camá ne, María jan ne, cavéjña xu me jyan sá ndava Elisabet, sehe cavuya cafe me nangui rë me hiscan tjin ndava me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Quihndë ne, cavechú nixtin xi tsin rë Elisabet quihndi, hane catsin rë me ngu quihndi xihin. ");
INSERT INTO maqNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Xi camachaya rë yëjë xuta xi siu tahndee ndava me cojo yëjë xicjin Elisabet xi jercu camayuma rë Nina Elisabet ne, jercu ndaja camá rë me xingu xingu me cojo Elisabet. ");
INSERT INTO maqNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hya xi camá xu ne, xi cavetjucaa quihndi jan jyin nixtin ne, cafehe nga me xi siu tahndee ndava me jan cojo xicjin Elisabet xi cuma suhi tsëhë xi xtí chuxin rë quihndi. Hane meje suañihi me quihndi jan Zacarías, tsëhë xi cuatjin hmí rë nahmi rë. ");
INSERT INTO maqNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ngajan xi cachja xu naa rë quihndi jan cuitjin: ―‍Hajín ta quihndi vi ne, Juan cjuahañihi. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hane xuta jan ne, cuitjin xu cachja me: ―‍Peru ngayun ne, tsajin hisca ngu xingun xi cuatjin hmí rë. ―‍Cuatjin xu cachja xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ngajan xi xuta xi cuacun jan ne, tu casahmi tsjá xu ni me cojo nahmi rë quihndi xi cavinenguise me hacutjin meje rë nahmi rë quihndi xi cjuahañihi quihndi jan. ");
INSERT INTO maqNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ngajan xi Zacarías ne, cafehya xu me ngu pizarra, sehe ngajan catsihindu me cjua vihi: “Juan cjuahañihi.” Cuatjin xu catsihindu me. Hya xi camá ne, yëjë ni me ne, jemu quijircun xu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hane hora vëhë ni ne, camá xu cachja Zacarías, hane jemu ndaja cavaxëndaja me Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ngajan xi xuta xi siu tahndee ndava me jan ne, jemu catsacjun xu me camá, hane jingujyë ni ladu nangui ndetjún tsëhë distritu Judea hiscan xi siu xuta ne, jercu cavisiajmi xu me tsëhë cjuacjintacun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hane yëjë xuta xi camachaya rë cjuacjintacun vëhë ne, jercu cjín catsingataha cacun me, hisca cachja xu me cuitjin: ―‍¡Cuechú nixtin xi quihndi vi ne, cuma ngu xihin xi jyë hnga cojo cjuatacun rë! Cuatjin xu cachja xuta xi cuacun jan ta, tsëhë xi quihndi vëhë ne, Nina yahangui jain me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, nahmi rë quihndi jan ne, ña catsë rë me cojo Hasen rë Nina, hane cachja xu me cuitjin cjua xi cafahatsja me tsëhë Nina: ");
INSERT INTO maqNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Tjemu ndaja Nina naja ngayaan xuta tjë rë Israel! tsëhë xi cuinduva me cjuaha naja me xi cuma yaan xuta rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nina sahmi me xi ngajñi rë tjë rë David, ngu xuta rë Nina ne, cuetjujñi ngu xihin xi cuaxëtje naja, ");
INSERT INTO maqNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sacuatjin xi ha cachja profeta xi cavejña me tsëhë Nina, hya xi cachja me cojo xutachanga naja cjua rë Nina hatsëë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Hacuaha cachja Nina xi cuaxëtje naja me tsëhë condra naja, hacuaha cuaxëtje naja me tsëhë yëjë xuta xi choho vëë naja, ");
INSERT INTO maqNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","hacuaha cumayuma rë me tsëhë xutachanga naja hacuaha tsinguitsjen me compromisu ximinchacun xi casahmi me cojo xutachanga naja. ");
INSERT INTO maqNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nina ne, cachja me: “Ngahan suva hvë”, hya xi casahmi me compromisu jan cojo xutachanga naja Abraham. ");
INSERT INTO maqNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Hya xi casahmi me compromisu vëhë ne, cachja me xi cuëhëndaya naja me tsëhë condra naja, cojo sa xi ngayaan ne, hacuiin cojo chircun chjahanrcun me ta ");
INSERT INTO maqNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","chjahanrcun me cojo ngu cjuatacun tyjahi, xi tsajin jyë́ naja xcun me hacutjin nixtin xi nechan xcun cjuahñu naja. ");
INSERT INTO maqNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ngaye tsan ne, hacuaha cuma ngaye ngu profeta tsëhë Nina xi Matitjun ta, tsëhë xi ngaye cuihintitjin, choxehe ndiya tsëhë Nina, ");
INSERT INTO maqNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","hacuaha tehe cumachaya rë xuta rë Nina xi cuaxëtje Nina me, cuma cuinújan ne, tsinchataha me tsëhë jyë́ rë ");
INSERT INTO maqNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ngatsë rë ta tsëhë xi Nina ne, jemu tjin rë me cjuayumatacun cojo naja. Hacuaha ngatsë rë cjuayumatacun vëhë ne, Nina tsingatju me tsëhë ngahnga ngu xi sacuaha tsuhi, ");
INSERT INTO maqNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","cojo sa xi sua hasen rë ngajñi naja xi nechan cojo ngu cjuacjintacun jyë xi hisca sacuinyiin naja hacutjin naxentjeen yojo naja, ngayaan xi tjemu tsavi nechantahan tsëhë cjuaveya, hacuaha cojo sa xi cjuecojo naja ndiya tsëhë cjuajeya. Cuatjin cachja xu Zacarías. ");
INSERT INTO maqNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hya xi camá ne, quihndi jan ne, camajyë, hacuaha cavejñahñu xu cjuatacun rë. Hane xi camá ngu xihin jyë ne, quiji cavéjña xu ngajan ngu xín camahani tsëhë nandya, hisca hya xi cavechú nixtin xi cavetsihin cachja cjua rë Nina cojo xuta tjë rë Israel. ");
INSERT INTO maqNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Cuitjin xu camá nga ngunixtin hya xi Herodes vitexa me xuta tjë rë Israel. Me xi matitjun camahani xi hmí rë César Augusto ne, cavitexa xu me xi yëjë ni xuta xi siu ngahma gubiernu rë me ne, cjue me cuiyujutahaxujun me xi cuechjitje me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hacuaha hya xi cuatjin tjuntjun caviyujutaha xujun xuta ne, hya vitexa xuta Cirene ngajan distritu Siria. ");
INSERT INTO maqNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ngajan xi yëjë ni xuta ne, quiji xu me caviyujutaha xujun me, jima ngu me hiscan nangui rë xutachanga rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Cuatjin camá xi José ne, cavetju xu me tsëhë nandya Nasaret, distritu Galilea, quiji me distritu Judea, nangui rë xutachanga rë me David, hiscan xi hmí rë Belén, tsëhë xi José ne, tjë rë David xu má me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Quiji casetahaxujun tangun me cojo María, me xi tacunvasen cjuavixan rë me cojo. Hane María ne, jiya xu quihndi rë me hya xi quiji me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hya xi camá ne, jinguyëjë rë xi siutahá xu me ngajan ne, cavechú nixtin xi tsin xu quihndi rë me, ");
INSERT INTO maqNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","hane catsin rë me ngu quihndi xihin, xi quihndi tjun rë me. Hane xi cavatju catsin quihndi jan ne, sehe cafaha me cavaxtë me ngu tsjian, sehe cafaña xu me quihndi jan cahntsua hiscan jineyá chu ta, tsëhë xi casacuiin xu cahndë́ cahntsua ndihya xi cuiyuju me, tsëhë xi jemu quitsë camahani xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ha taha ladu vëhë ni ne, siutahá ngujo cha nguixun ngajan nguijña, xi sahmi cuidadu xu cha chu tsánga rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hya xi camá ne, ha tu ñahñu camatsejen xu ngu ángel tsëhë Nina hiscan xi siutahá cha, hane hora vëhë ni ne, hasen ndajyihi rë Nina ne, jercu casahmi hasen xu rë jingujyë ni hiscan xi siutahá cha, hane jemu catsacjun camahani cha camá. ");
INSERT INTO maqNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ngajan xi cachja xu ángel cojo cha cuitjin: ―‍Xicarcuun ta, nguehe nduva tisuá cumachaya nuju ngu cjuandajyihi xi hisca yëjë xuta tjë rë Israel jercu ndaja cuma rë me ");
INSERT INTO maqNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ta nguehe Belén, nangui rë xutachanga nuju David ne, quihndë catsin ngu quihndi xi cuaxëtje nuju, quihndi xi Nina catsingatju rë xi cumatitjun tsujun. ");
INSERT INTO maqNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hane cuitjin sacú nuju cjuaquixi tsëhë cjua xi cachjá cojo nuju vë: xi cjuhun jan ne, cuechun hiscan xi chun ngu quihndi tixtë rë tsjian, jiña cahntsua hiscan jineyá chu. ―‍Cuatjin xu cachja ángel. ");
INSERT INTO maqNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hane ha tu ñahñu camatsejen sa jercu cjín camahani ángel xi nduva xu ngahnga, cafehe hiscan xi secun ángel xi cafehe titjún, tivaxëndaja rë Nina cojo cjua vihi: ");
INSERT INTO maqNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Jemu jyë hnga Nina cojo Hasen rë me ngajan ngahnga! ¡Hane nguehe nangui ne, cuisehen cjuajeya rë Nina cahntsua xahasen rë xuta xi chuya rë Nina tsëhë! Cuatjin xu cachja ángel cjín jan. ");
INSERT INTO maqNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hya xi camá ne, hya xi cavuya quiji nga ángel jan ngahnga ne, cha xi sahmi cuidadu chu tsánga rë jan ne, cuitjin cachja cha cojo xicjin cha: ―‍¡Cjuanguen ni! Cjuanguen hisca nandya, cuanguen chutsejen xcusun xi camá vi, sacuatjin casua Nina camachaya naja. ―‍Cuatjin xu cachja cha cojo xicjin cha. ");
INSERT INTO maqNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hya xi camá ne, ngusun xu ni cafe cha, hane xi cafehe cha nandya ne, casacuse rë cha hiscan tacun María cojo José, cojo quihndi jan, jiña cahntsua hiscan jineyá chu. ");
INSERT INTO maqNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hya xi cavëë xu cha quihndi jan ne, sehe cavetsihin casuacuenda cha yëjë cjua xi cachja ángel cojo rë cha tsëhë quihndi vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Hane xi cahndë xuta cjua xi cachja cha xi cuacun jan cojo rë me ne, jemu quijircun xu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Peru María ne, cavetjo cavetjo ni me yëjë ni cjua vëhë cahntsua xahasen rë me, hacuaha jercu cjín xu catsingataha cacun me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hane xi cavuya quiji nga cha xi sahmi cuidadu chu rë jan ngajan nguijña ne, taha tisahmi jyë tisahmi hnga xu cha Nina hacuaha taha tivaxëndaja cha me tsëhë yëjë cjua xi cahndë cha cojo xcusun xi cavëë cha, sacuatjin cachja ángel cojo rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Xi cavechú xu jyin nixtin quihndi ne, hacuaha hatuxa hya cavechú nixtin xi xtí chuxin rë, hane cuatjin camá cojo quihndi. Hacuaha Jesús cafahañihi xu quihndi, ñihi xi ha cachja ángel hisca chaja sa xi seyahma quihndi cahntsua naa rë. ");
INSERT INTO maqNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Hya xi camá ne, xi cavechú xu nixtin xi cjue naa rë quihndi yungun xi matitjun cojo quihndi xi cuma tyjahi me xcun Nina tutjin chja ley rë Moisés ne, quiji José cojo María Jerusalén, quiji cani me ngu cjuatjo ta, tsëhë xi chja ley rë Nina ta meje rë xi cjue jo chu tucjin, o sá xi jo chu paloma chihndë. Hacuaha quijicojo xu me quihndi jan Jerusalén xi tsingacun me quihndi jan cojo Nina. Quitahá xujun xcun ley rë Nina xi yëjë ni quihndi tjun xi xihin ne, hatuxa tsëhë Nina cuma. ");
INSERT INTO maqNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Cavéjña xu ngu xihin xi hmí rë Simeón ngajan Jerusalén. Xihin vëhë ne, tyjahi xu me cojo cjuatacun rë me ngajan xcun Nina, hacuaha jemu faharcun me Nina. Hacuaha jemu meje xu rë me xi cjuehe xuta xi yaha cjuetacun jan xi cuma rë xuta tjë rë Israel. Hacuaha Hasen rë Nina ne, jiya cahntsua xahasen rë Simeón. ");
INSERT INTO maqNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Hane Hasen rë Nina jan ne, casua xu camachaya rë me xi jinguyëjë rë xi cjëë scuëë me xuta xi tsingatju Nina jan ne, hatuxa cueyaain xu me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Hane quiji me yungun xi matitjun, tsëhë xi cuatjin cachja Hasen rë Nina cojo rë me. Hacuaha xutacha rë quihndi xi hmí rë Jesús jan ne, quijicojo xu me quihndi jan yungun vëhë, xi sahmichihin me sacuaha xcusun xi vitexa ley rë Moisés hacutjin cuatju quihndi cuma. ");
INSERT INTO maqNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Hya xi camá ne, cafaha xu Simeón quihndi jan cavataha me, sehe hacuaha cavaxëndaja me Nina cojo cjua vihi: ");
INSERT INTO maqNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ngayun Nina naha, ngayun ne, ha cuma tuhun cahndë́ xi ngahan hndixahan nuju ne, cueya cojo cjuandaja cojo cjuajeya sacuatjin xi ha canújun. ");
INSERT INTO maqNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Cuma cueya ta, tsëhë xi quihndë ne, cahvë suva xuta xi caningatjun xi cuaxëtje niji, ");
INSERT INTO maqNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","me xi caningatjun xcun cojo xcun yëjë ni xuta, ");
INSERT INTO maqNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","me xi cuinduva sacuaha ngu ndihi xi sua me cjuahasen xi cuma rë xutaxín, hacuaha cuinduva me xi sahmi yehe sahmi hnga niji me, ngayin xuta nuju, xuta tjë rë Israel. Cuatjin xu cachja Simeón. ");
INSERT INTO maqNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Hane xutacha rë quihndi jan ne, jemu quijircun xu rë me tsëhë xi cuatjin cachja Simeón tsëhë quihndi jan. ");
INSERT INTO maqNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hane Simeón ne, catsinchacun me me xi cuacun jan, sehe cachja xu me cojo María naa rë quihndi jan cuitjin: ―‍Quihndi vihi ne, hacuaha sahmi xi jemu cjín xuta tjë rë Israel chajá me, hacuaha sahmi xi jemu cjín xuta tjë rë Israel cuetjutje me. Hacuaha quihndi vihi ne, sua cumachaya rë xuta mé xi meje rë Nina, hacuaha jemu choho cuichja xuta tsëhë quihndi. ");
INSERT INTO maqNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Cuatjin cuma cojo sa xi ngajan sesunhngatsejen yëjë hacutjin xi tsingataha cacun jemu cjín xuta cojo cjuatacun rë me. Hacuaha ngayun ne, jercu cuma rë xahasen nuju, sacuaha xi quicha casehen rë xahasen nuju. ―‍Cuatjin xu cachja Simeón. ");
INSERT INTO maqNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hacuaha tacun xu ngu chjuun xi hmí rë Ana ngajan yungun, quihndi rë Fanuel, tjë rë xutachanga xi hmí rë Aser. Chjuun jan ne, profeta xu má me. Hacuaha jercu changá xu me. Xi cavixan me ne, cavéjña me cojo xihin rë me yatu nu. ");
INSERT INTO maqNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ngaxtun vëhë ne, cavéjña cahan me. Hane xi casacu xicjin xu me cojo xutacha rë Jesús ne, ñujuchan ñuju nu xu tjin rë me. Hacuaha jemu quiji camaha xu ni me yungun xi matitjun. Jemu cjín ndiya ne, cajinii xu me niñu xi faharcun me Nina. Hacuaha jercu sahmi xu me oración rë me. Nixtin nixten faharcun me Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hacuaha ha hora xi siu xu ni xutacha rë Jesús ngajan yungun jan ne, cafehe Ana. Hane xi cavëë me quihndi Jesús jan ne, casua xu me nacuechji rë Nina. Ngaxtun vëhë ne, sehe cavetsihin cachja xu me tsëhë Jesús cojo yëjë xuta xi jemu meje rë xi cuechú nixtin xi cuaxëtje Nina nandya Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Xutacha rë Jesús ne, hya xi ha cafë casahmichihin xu me yëjë xcusun xi vitexa ley rë Nina ne, cavuya cafe me nangui rë me, hiscan xi hmí Nasaret, distritu Galilea. ");
INSERT INTO maqNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Quihndi jan ne, camajyë hacuaha casacuhñu rë, hacuaha jercu cavechútáha cjuatacun rë, hacuaha jercu cavisehen xu cjuandaja rë Nina cahntsua xahasen rë. ");
INSERT INTO maqNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Chuva nu chuva nu ne, xutacha rë Jesús ne, fi xu me suhi tsëhë Pascua ngajan Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hane hya xi Jesús cavechú me tejó nu ne, sacuaha xcusun rë xuta cojo suhi vëhë ne, quiji xu Jesús cojo xutacha rë me ngajan Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Xi cavatju suhi jan ne, xutacha rë Jesús ne, cavetju xu me tsëhë Jerusalén xi cuya cjue me nangui rë me. Peru Jesús ne, hisca camachayiin rë xutacha rë me ne, casetaha suvá xu me Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Xi má rë xutacha rë me ne, jiyajñi me ngajñi rë xutacjín tife me. Hane xi cafë ngu nixtin tife xutacha rë me ndiya ne, cavetsihin cavanguise xu me Jesús jan ngajñi rë xuta rë me cojo ngajñi rë yëjë xuta xi vinga rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hane xi casacuiin rë me Jesús jan ngajñi rë xutacjín jan ne, cavuya quiji xu me hisca Jerusalén, xi tivanguise me me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hya xi camá ne, xi majyan nixtin jan ne, sehe casacu xu rë me Jesús ngajan yungun xi matitjun, tacun me ngajñi rë maestru xi vicuya cjuachacun, tivisiñuju me cjua rë maestru hacuaha tivinenguise xu rë me jingu sa cjuachacun. ");
INSERT INTO maqNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hane yëjë ni xuta xi tivisiñuju cjua rë Jesús jan ne, jercu fircun xu rë me, tsëhë xi cuarcu quicun cacun me hacuaha tsëhë xi jercu ndaja titsicuya me cjua tsëhë maestru jan. ");
INSERT INTO maqNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hane hya xi cavëë xu xutacha rë Jesús xi ngajan tacun me ne, tu quiji tsëhë me, sehe cachja naa rë me cuitjin: ―‍¿Mé má cuatjin canihñi cojo niji, tsan? Chutsijin ta cuajyihi ngahan cojo nahmi riji ne, cojo cjín cjuacjintacun niji ne, catujyihinyin cavinchinsin ri. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ngajan xi Jesús ne, cuitjin xu cachja me cojo xutacha rë me: ―‍¿Mé má cuatjin tu nguehe tu ngajan cavinchunsun ná ni? ¿Há hyúun ta hatuxa meje rë xi cuitejña ndava nahmi naha? ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Peru xutacha rë Jesús ne, cajnii xu rcu me cjua xi cachja Jesús cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hya xi camá ne, cavuya cafe xu Jesús cojo xutacha rë me nangui rë me ngajan Nasaret. Hacuaha cahndë me tsëhë xutacha rë me hacutjin xi quiji sa nixtin rë me. Hane naa rë Jesús ne, cavetjo cavetjo xu ni me yëjë ni cjua vëhë cahntsua xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sacuaha Jesús ne, jima jyë xu me cojo yojo rë me, hacuaha jima jyë jima hnga me cojo cjuatacun rë me. Hacuaha tichuya sa xu rë Nina tsëhë me, hacuaha tichuya sa rë xuta tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Cuitjin xu camá hya xi cafë tyjuhun nu jiya me xi matitjun camaha ni xi hmí rë Tiberio César xcun xá rë me xi vitexa me jingu ni ladu. Poncio Pilatu ne, me vëhë vitexa xu me distritu Judea, hane Herodes ne, me vëhë xu vitexa me distritu Galilea, hane hntsëjñu me xi hmí rë Felipe ne, me vëhë xu vitexa me distritu Iturea cojo distritu Traconite, hacuaha Lisanias ne, me vëhë xu vitexa me distritu Abilinia. ");
INSERT INTO maqNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hane sacuaha nahmi xi matitjun xu ne, Anás cojo Caifás má me. Hane sacuaha nixtin vëhë ne, Juan quihndi rë Zacarías ne, hya xi quitahá me ngajan ngu xín tsëhë nandya ne, cafahatsja me cjua xi catsingatju xu Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hane quiji catsujyihiya me yëjë ni ladu tiña tsëhë ndajyë Jordán, tichja me xi meje rë xi tsindeya xu xuta cjuatacun rë me hacuaha xtenda me, cojo sa xi tsinchataha Nina xuta tsëhë jyë́ rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Xi cuatjin xu casahmi Juan ne, casahmichihin me sacuatjin camahindu hatsëë nixtin xcun xujun xi chja cjua rë profeta Isaías xi chja cuitjin: Cuitjin jercu hñu cuichja ngu xuta ngajan hiscan jemu xín tsëhë nandya: “Tuhunchjinu ndiya tsëhë Nai naja; ninguixun ndiya tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yëjë ni hiscan nangui cahntsua ne, tsë́ya rë, yëjë ni ndetjún cojo yëjë ni naxi ne, cuijnenangui, yëjë ni ndiya lahñi ne, cuma quixi, yëjë ni ndiya xi hacuiin chihin ne, cuma chihin. ");
INSERT INTO maqNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hane yëjë ni xuta ne, scuëë me hacutjin vaxëtje Nina xuta rë me.” Cuatjin xu catsihindu Isaías cjua xi jercu hñu cuichja xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ngajan xi hya xi quiji xutacjín xi xtenda me ne, cuitjin xu cachja Juan cojo xuta: ―‍¡Ngayujun ni ngayun quihndi rë chu tsehen matsejen ne!, ¿yo cavinchangui nuju xi nihñu ngahñu xi cuetjuntjun tsëhë castigu xi hatuxa tsingatju Nina? ");
INSERT INTO maqNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sá xi meje jain cuetjuntjun matsejen ne, nihñu suvá cjuandaja sacuatjin sahmi xuta xi catsindeya jain me cjuatacun rë me. Xicanujuun cahntsua xahasen nuju cjua vihi: “Ngayaan ne, tsajin mé cuma naja ta, tsëhë xi tjë rë Abraham ngayaan.” Xicanujuun cuatjin matsejen ta, nguehe cuichjá cojo nuju ta Nina ne, hisca ndyojo xi cuicun vi ne, cuma sahmi me tjë rë Abraham. ");
INSERT INTO maqNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chutsujun ta ngayun matsejen ne, tangun ngayun cojo yatjë xi ha quitaháchjine quicharcu tyjama rë xi cuetsihin xtí. Yëjë ni yatjë xi suaain tu xi ndaja matsejen ne, xtí rë, sehe cjue cueti. ―‍Cuatjin xu cachja Juan. ");
INSERT INTO maqNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ngajan xi xutacjín jan ne, cuitjin xu cavinenguise rë me Juan: ―‍¿Hacutjin ndatjin nihñi xi cuma nihñi cjuandaja xi nújun vë ni? ―‍Cuatjin xu cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Hane xi cafayangui Juan ne, cuitjin xu cachja me: ―‍Jarë ngayun xi tjin nuju jo tsjian nuju ne, tuhun rë ngu yo xi tsajin rë. Jarë ngayun xi tjin xi chinu ne, ha chuva vëhë ni tuhun hitsë catjinë me xi tsajin xi sinë. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Hacuaha canduva sa xu ngujo cha xi faha tujúnsa xi meje rë cha xi xtenda cha, hane cuitjin xu cavinenguise cha: ―‍Tatá, ¿mé xi ndatjin nihñi ngayin? ―‍Cuatjin xu cavinenguise cha. ");
INSERT INTO maqNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sehe ngajan xi Juan ne, cuitjin xu cachja me cojo cha: ―‍Hacuiin cjín sa tujún chjahyun rë xuta. Chjahyun rë me hacutjin xi casatëxa ni nuju. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Hacuaha cavinenguise nga ngujo sindadu me cuitjin: ―‍Hane ngayin ne, ¿mé xi ndatjin nihñi? ―‍Cuatjin xu cavinenguise cha. Sehe cachja xu me cojo cha cuitjin: ―‍Xicanaxuun rë xuta tujún cojo cjuachan, o sá xi cojo ngu cjuandacha. Catamangutacún ni cojo tujún xi ha ma chji nuju. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Xuta ne, jercu siuya camahani me mé xi cuma, hacuaha vinenguise xu me cahntsua xahasen rë me cuitjin: “Hyaan sa xi Juan rë vi Xihin xi Tsingatju Nina xi cuaxëtje naja me.” Cuatjin xu cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Sehe ngajan xi Juan ne, cuitjin xu cachja me cojo yëjë xuta jan: ―‍Ngahan matsejen ne, cojo nandá ni tiviténda nuju, peru sehe cuinduva me xi cueyá me Hasen rë Nina cahntsua xahasen nuju, hacuaha cuaha me sacuaha ngu ndihi xi tsityjahi rë cjuatacun nuju. Me vëhë ne, hitsë sa jyë hnga me cojo cjuatacun rë xi cumá ná ngahan, hisca cumaji tsinguisehercu sahme tyjahi chuxinxtë rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Me xi tsingatju Nina jan matsejen ne, sacuaha xi ha yahatsja me quicha xi tsinguitjen rë xtë rë trigu cojo sa xi cuma tyjahi ndaja trigu xi casechun rë tsëhë me, hacuaha cjuaya me trigu tyjahi xi cuinchandaja me, hane xtë rë jan matsejen ne, cuaca me xcun ngu ndihi xi tsajin nixtin hvo. ―‍Cuatjin xu cachja Juan. ");
INSERT INTO maqNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hacuaha hacuiin suvá xu ni cjua vëhë cachja Juan cojo xuta hya xi cachja me cjuandajyihi rë Nina ta cachja sa xu me jemu cjín cjua. ");
INSERT INTO maqNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herodes, me xi cavitexa ngajan distritu Galilea ne, hacuaha cachjataha xu Juan me ngatsë rë xi cafaha Herodes na Herodía, chjuun rë hntsëjñu me, xi cumá chjuun rë me na. Hacuaha cachjataha sa xu Juan me tsëhë jingu sa xcusun tsehen xi casahmi me. ");
INSERT INTO maqNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Peru xcun yëjë cjuatsehen vëhë ne, cavetahacoo sa Herodes xcusun vihi: caveya xu me Juan ndavaya. ");
INSERT INTO maqNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hane hya xi chaja sa xu cjue Juan ndavaya ne, ngu nixtin xi caxtenda yëjë ni xuta ne, hacuaha cojo xu Jesús caxtenda me. Hane xi cavatju caxtenda me ne, hora xi tisahmi xu me oración rë me ne, ngahnga ne, catuxaha, ");
INSERT INTO maqNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","hane Hasen rë Nina ne, canduvajnetsejen casesun rcu me. Sacuajyihi ngu paloma jyihi. Hacuaha hora vëhë ni ne, canuhya xu rë ngu cjua ngajan ngahnga xi cachja xu cuitjin: “Ngaye xi quihndi naha ngaye xi jemu hmú cácun ri. Jemu ndama ná ngatsë riji.” Cuatjin xu cachja. ");
INSERT INTO maqNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Quihndë ne, Jesús ne, tjin xu rë me sacuaha cantë nu hya xi cavetsihin me cojo xá rë me. Hacuaha xi má xu rë xuta ne, quihndi rë José má me. Hane José ne, quihndi rë Elí. ");
INSERT INTO maqNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí ne, quihndi rë Matat. Matat ne, quihndi rë Leví. Leví ne, quihndi rë Melqui. Melqui ne, quihndi rë Jana. Jana ne, quihndi rë José. ");
INSERT INTO maqNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José ne, quihndi rë Matatías. Matatías ne, quihndi rë Amós. Amós ne, quihndi rë Nahum. Nahum ne, quihndi rë Esli. Esli ne, quihndi rë Nagai. ");
INSERT INTO maqNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ne, quihndi rë Maat. Maat ne, quihndi rë Matatías. Matatías ne, quihndi rë Semei. Semei ne, quihndi rë José. José ne, quihndi rë Judá. ");
INSERT INTO maqNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá ne, quihndi rë Joana. Joana ne, quihndi rë Resa. Resa ne, quihndi rë Zorobabel. Zorobabel ne, quihndi rë Salatiel. Salatiel ne, quihndi rë Neri. ");
INSERT INTO maqNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ne, quihndi rë Melqui. Melqui ne, quihndi rë Adi. Adi ne, quihndi rë Cosam. Cosam ne, quihndi rë Elmodam. Elmodam ne, quihndi rë Er. ");
INSERT INTO maqNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ne, quihndi rë Jesús. Jesús ne, quihndi rë Eliezer. Eliezer ne, quihndi rë Jorim. Jorim ne, quihndi rë Matat. ");
INSERT INTO maqNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat ne, quihndi rë Leví. Leví ne, quihndi rë Simeón. Simeón ne, quihndi rë Judá. Judá ne, quihndi rë José. José ne, quihndi rë Jonán. Jonán ne, quihndi rë Eliaquim. ");
INSERT INTO maqNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ne, quihndi rë Melea. Melea ne, quihndi rë Mainán. Mainán ne, quihndi rë Matata. Matata ne, quihndi rë Natán. ");
INSERT INTO maqNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán ne, quihndi rë David. David ne, quihndi rë Isaí. Isaí ne, quihndi rë Obed. Obed ne, quihndi rë Booz. Booz ne, quihndi rë Salmón. Salmón ne, quihndi rë Naasón. ");
INSERT INTO maqNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón ne, quihndi rë Aminadab. Aminadab ne, quihndi rë Aram. Aram ne, quihndi rë Esrom. Esrom ne, quihndi rë Fares. Fares ne, quihndi rë Judá. ");
INSERT INTO maqNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá ne, quihndi rë Jacob. Jacob ne, quihndi rë Isaac. Isaac ne, quihndi rë Abraham. Abraham ne, quihndi rë Taré. Taré ne, quihndi rë Nacor. ");
INSERT INTO maqNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor ne, quihndi rë Serug. Serug ne, quihndi rë Ragau. Ragau ne, quihndi rë Peleg. Peleg ne, quihndi rë Heber. Heber ne, quihndi rë Sala. ");
INSERT INTO maqNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ne, quihndi rë Cainán. Cainán ne, quihndi rë Arfaxad. Arfaxad ne, quihndi rë Sem. Sem ne, quihndi rë Noé. Noé ne, quihndi rë Lamec. ");
INSERT INTO maqNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec ne, quihndi rë Matusalén. Matusalén ne, quihndi rë Enoc. Enoc ne, quihndi rë Jared. Jared ne, quihndi rë Mahalaleel. Mahalaleel ne, quihndi rë Cainán. ");
INSERT INTO maqNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán ne, quihndi rë Enós. Enós ne, quihndi rë Set. Set ne, quihndi rë Adán. Adán ne, me vëhë xi Nina casahmi rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Hya xi camá ne, hya xi catsë rë Jesús cojo Hasen rë Nina hya xi caxtenda me ne, cavuya xu me tsëhë ndajyë Jordán xi cjue me ndava me, peru Hasen rë Nina ne, quiji nguehe quiji ngajan xu cojo rë me ngajan ngu xín tsëhë nandya ");
INSERT INTO maqNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","cahntsua yachan nixtin. Hacuaha yasen ni tifahachuva xitsehen xi matitjun me. Hacuaha Jesús ne, tsajin camaha xu ni mé xi cajinë me cahntsua nixtin xi cuacun vëhë. Hane xi cavatju nixtin xi cuacun vë ne, jercu camavojo xu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sehe ngajan xi xitsehen jan ne, cuitjin xu cachja cojo Jesús: ―‍Sá xi Quihndi jain rë Nina ngaye ne, tinoje cojo ndyojo vihi ne, catama niñu. ―‍Cuatjin xu cachja xitsehen. ");
INSERT INTO maqNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Hane Jesús ne, cuitjin xu cafayangui me tsëhë xitsehen jan: ―‍Xcun xujun rë Nina ne, cuitjin camahindu: “Hacuiin suvá ngatsë rë niñu xi siu xuta cjuahñu.” ―‍Cuatjin xu cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hane xi quijicojo xitsehen me ngu ndetjún hnga ne, sehe nguhñusasa xu catsingacun ni xitsehen jan me jingujyë ni nandya tsëhë ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sehe cachja xu xitsehen cuitjin cojo rë me: ―‍Suá ri yëjë nandya xi cuacun vë cojo yëjë cjuanchina rë xi ngaye nihñi gubiernu. Cuma suá ri ta, tsëhë xi hatuxa ngahan cafahántsa, hane ha tu yo ni xi meje suá rë ne, suá rë. ");
INSERT INTO maqNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Quihndë ne, sá xi cuindove cuiticjexcuin nguehe xi chjehercuin ná ne, cumá tsiji yëjë ni nandya vë. ―‍Cuatjin xu cachja xitsehen. ");
INSERT INTO maqNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sehe ngajan xi cafayangui xu Jesús cuitjin: ―‍Xcun xujun rë Nina ne, cuitjin camahindu: “Meje rë xi chjuhunrcun Nina naja, hacuaha suvá ni me vëhë meje rë xi nihñu hacutjin xi meje rë me.” ―‍Cuatjin xu cachja Jesús cjua vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hya xi camá ne, xitsehen jan ne, quijicojo xu rë Jesús ngajan Jerusalén, hane quijicani rë me hisca rcu cjin yungun xi matitjun. Sehe cachja xu cojo rë me cuitjin: ―‍Sá xi Quihndi jain rë Nina ngaye ne, ningatjin yojo riji ndyá hisca nangui. ");
INSERT INTO maqNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ha hye ta tsajin mé cuma ri ta xcun xujun rë Nina ne, cuitjin chja: Nina cuitexa me ángel rë me xi sahmi ri cuidadu. ");
INSERT INTO maqNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Cuahatsjá ri, cojo sa xi hisca ntsacui ne, sacuinhmaain rë cojo ngu ndyojo. Cuatjin xu cachja xitsehen cjua vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Hane Jesús ne, cuitjin xu cafayangui me tsëhë xitsehen: ―‍Xujun rë Nina ne, cuitjin chja: “Mijí rë xi chjuhunchuvun Nina naja.” ");
INSERT INTO maqNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hya xi camá ne, xi cajnetaha cafahachuva xitsehen jan Jesús ne, cavetjuxin xu tsëhë me hisca janihya cuya nga. ");
INSERT INTO maqNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ngajan xi Jesús ne, cojo ngahñu rë Hasen rë Nina ne, quijinduju sa xu me xi cjue me ndava me ngajan distritu Galilea. Hane xi cafehe xu me jan ne, jercu cachja xuta tsëhë me ngajan Galilea cojo jingujyë ni nandya xi siu tahndee rë. ");
INSERT INTO maqNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hane quiji me yungun rë jimangu nandya tsëhë Galilea, cavicuya me xuta. Hane yëjë ni xuta jan ne, casahmi jyë casahmi hnga xu me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Cavechú ngu nixtin xi quiji xu Jesús ngajan nandya Nasaret hiscan xi camacha me. Hane sacuaha xcusun xi tjin rë me ne, nixtin xi chjahájenda rë ne, quiji xu me yungun. Sehe quiji casecunvasen me xi cuichjasun xu me xujun rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hya xi camá ne, casengui tsja me xujun xi hincha cjua rë Nina xi catsihindu profeta Isaías. Hane xi titsixinga xu me xujun jan ne, táha tivanguise me cahndë́ xi quitahá cjua xi meje rë me. Hane xi casacu rë me cahndë́ vëhë ne, sehe cavetsihin cachjasun xu me cjua vihi xcun xuta: ");
INSERT INTO maqNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Hasen rë Nina ne, jiya cahntsua xahasen naha, vëhë xi casuaxa ná Nina xi suá cumachaya rë xuta yuma cjuandajyihi rë me: catsingatju ná me xi suá cumachaya rë xuta xi hincha ndavaya ta hatuxa cuma ndaya me, suá cumachaya rë xuta xi rcá me ta hatuxa cuya cuma tsejen nga rë me; cuëhëndaya xuta xi jemu choho sahmi jingu sa xuta cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Hacuaha suá cumachaya rë xuta xi cavechú nu xi jercu sahmi Nina cjuandaja cojo xuta rë me. Cuatjin chja cjua rë xujun xi cachjasun Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hane xi cavuya catsijeyu nga Jesús xujun jan ne, sehe cavuya casua nga me me xi sahmi xá cahntsua yungun jan. Sehe cavéjña Jesús xi cuicuya rë me xuta. Hane yëjë ni xuta xi siu cahntsua yungun jan ne, jercu cavëhërcun me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sehe ngajan xi Jesús ne, cavetsihin cachja me cuitjin cojo xuta: ―‍Quihndë, jinguyëjë rë xi cavinuhyun cjua xi camahindu xcun xujun rë Nina xi cavutaya jan ne, ngajan cavetjucaa cjua vëhë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yëjë ni xuta ne, jemu ndaja xu cachja me tsëhë Jesús, hacuaha hisca quijircun rë me tsëhë xi jemu ndaja camahani cjua xi cachja Jesús. Sehe cachja xuta jan cuitjin: ―‍¡Peru cha vihi xi quihndi rë cha José jan! ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hane Jesús ne, cuitjin xu cachja me cojo xuta jan: ―‍Ngahan matsejen ne, ha hvë ta ngayun ne, cuinújun cojo ná cjua vihi: “Doctor, nircun suvun rë yojo nuju.” Hacuaha cuinújun nga cuitjin: “Xcusun xi camachaya niji xi canihñu ngajan Capernaum matsejen ne, hacuaha nihñu xcusun vëhë nguehe xi nangui nuju.” ");
INSERT INTO maqNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Cuichjá cojo nuju cjuaquixi ta hisca xi ngu profeta matsejen ne, hatuxa macjaain rë xuta nangui rë me tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hacuaha ha cjuaquixi ta jemu cjín chjuun cahan xi caviyuju na nguehe Israel hya xi cavéjña profeta Elías hatsëë nixtin. Hacuaha nixtin vëhë matsejen ne, cavaain camahani tsi sacuaha jyan nu vasen, hane jercu jyë camahani jindya cavéjña jingujyë ni ladu. ");
INSERT INTO maqNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Peru catsingatjiin Nina profeta Elías xi cjue cuisecoo me hisca ngu na cahan xi cuacun vë matsejen ta ngu ni na cahan xi hisca hacuiin na tjë rë Israel na catsingatju Nina profeta xi cuisecoo me na ngajan nandya Sarepta, ladu tsëhë nandya Sidón. ");
INSERT INTO maqNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hacuaha nguehe Israel matsejen ne, jemu cjín xuta xi yaha rë ngu chíhin vitaha xi setaha yojo naja caviyuju me hya xi cavéjña profeta Eliseo hatsëë nixtin. Peru hisca xi ngu me xi cuacun vë camandajin me matsejen ta ngu ni Naamán xi hisca hacuiin xuta tjë rë Israel ta xuta Siria me matsejen ne, me vëhë ni xi camandaja me. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hane yëjë ni xuta xi siu xu cahntsua yungun jan ne, hya xi cahndë me cjua xi cachja Jesús jan ne, jemu camacjan rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hya xi camá ne, xi caxinchacun xuta jan ne, cavaxëxin xu me Jesús, quijicojo me me hisca ngajan ngu xín tsëhë nandya, ngu rcu ndetjún hnga hiscan xi cavéjña nandya rë me, xi meje tsingatjen me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Peru Jesús ne, cavatju xu me ngajñi rë xuta jan quijixin me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hya xi camá ne, quiji xu Jesús Capernaum, ngu nandya tsëhë distritu Galilea. Hane nixtin xi chjahájenda rë ne, quiji xu me yungun cavicuya me xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hane yëjë xuta xi siu jan ne, jercu quijircun xu rë me tsëhë cjua xi vicuya Jesús ta, tsëhë xi cjua xi vicuya me ne, sacuaha cjua xi chja ngu xi matitjun jain. ");
INSERT INTO maqNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hacuaha cahntsua yungun jan ne, tacun xu ngu cha xi jiya xitsehen cahntsua xahasen rë cha. Hane xitsehen jan casahmi xi jercu cajindaya cha cachja cha cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―‍¡Ja! ¿Mé má cuatjin ninguisuhunjñu cojo niji ngayun Jesús, xuta Nasaret? ¿Há canduvun xi nicjun niji? Ngahan ne, ha hvë yo ngayun. Ngayun xi hatuxa vinechun tsëhë Nina ngayun. ―‍Cuatjin xu casahmi xitsehen xi cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Hya xi camá ne, cuitjin xu cachja Jesús xi cavatëcja me cjua rë xitsehen xi jiya cahntsua xahasen rë cha: ―‍¡Jyuu nechin, hacuaha tetjixin tsëhë cha vë! ―‍Cuatjin xu cachja Jesús. Hya xi camá ne, catsiticja xu xitsehen jan cha ngajñi rë xuta, sehe cavetju quiji tsëhë xahasen rë cha, peru tsajin camahani mé cavanguihmu rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hya xi camá ne, yëjë xuta jan ne, jercu quijircun rë me, hisca cachja xu me ngajñi rë me cojo xicjin me cuitjin: ―‍¿Mé nga xcusun cjua vihi xi cojo yëjë ni ngahñu vitexa rë hisca xitsehen, hacuaha vetjuxin ni? ―‍Cuatjin xu cachja xuta ngajñi rë me cojo xicjin me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hya xi camá ne, jingujyë ni ladu tahndee rë cahndë́ jan ne, cavitsojo xu cjua xi cachja xuta tsëhë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Xi cavetju Jesús tsëhë yungun ne, quiji xu me ndava ngu me xi hmí rë Simón. Hane nahya rë Simón ne, jemu hmu xu rë me xi yaha rë me chíhinsuë. Hane yëjë xuta rë me ne, cafehya me cojo Jesús xi cuisecoo Jesús nahya rë Simón. ");
INSERT INTO maqNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Hane xi quiji cavutsejenya xu Jesús xcun nahya rë Simón ne, cavatëcja me chíhinsuë xi má rë xuta changá vëhë, hane cavetjuxin xu chíhin jan tsëhë me. Hane hora vëhë ni ne, cavisatjenhnga nahya rë Simón cavetsihin cafahacuenda me cjuandaja xi sahmi me cojo yëjë ni me xi cafehe jan. ");
INSERT INTO maqNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hane hora xi tivetje tsuhi xu ne, yëjë ni xuta xi tjin rë me xutahmu rë tsëhë tu mé ni xcusun chíhin ne, quijicojo me xutahmu rë jan nixtin hya hiscan tacun Jesús. Hane xi cavisanetsja xu Jesús jima ngu xutahmu rë jan ne, camandaja me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hacuaha jemu cjín xu xuta xi siu jan cavetjuxin xitsehen xi hincha rë me. Hane xi cavetju xitsehen jan quiji ne, jercu cachja camahani cuitjin: ―‍¡Ngayun xi Quihndi jain rë Nina ngayun! ―‍Cuatjin xu cachja xitsehen jan. Peru cavatëcja xu Jesús cjua xi tichja xitsehen jan, casuaain me cahndë́ xi cuichja xitsehen ta, tsëhë xi ha vëë xu xitsehen xi me vëhë xi catsingatju Nina me. ");
INSERT INTO maqNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hane xi casahasen jan ne, cavetju xu Jesús quiji me ngajan ngu xín tsëhë nandya. Hane xutacjín jan ne, cuatjin quiji cavanguise xu me Jesús, hane xi cavechú me hiscan tacun Jesús ne, meje tsinguijnehai me Jesús cojo sa xi hacuiin cuetjuxin me tsëhë xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Peru Jesús ne, cuitjin xu cachja me cojo xuta jan: ―‍Hacuaha sahmi ná ngujyë xi cjuë́ jingu sa cahndë́, suá cumachaya rë xuta cjuandajyihi tsëhë gubiernu xi sahmi Nina ta ngatsë rë vëhë xi catsingatju ná Nina. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hane cuatjin xu catsujyihiya casua me camachaya rë xuta cjuandajyihi vëhë yëjë ni yungun tsëhë ladu vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cuitjin xu camá nga ngu nixtin jan. Jercu cjín camahani xuta quijitjengui me Jesús xi cuihndë me cjua rë Nina. Na cavehnchun xu me Jesús xi secun me tjehen laguna Genesaret, xi hacuaha hmí rë laguna Galilea. ");
INSERT INTO maqNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hya xi camá ne, cavëë Jesús jo barcu ngajan tjehen rë laguna jan, hane cha xi tsëhë barcu jan ne, ha cavitujne xu cha tsëhë barcu, hane hincha vane cha nahya rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hane Jesús ne, quiji cavisehen xu me ngu barcu xi cavëë me jan. Barcu jan ne, tsëhë Simón. Sehe cachja me cojo Simón xi cjuecojo me hitsë barcu ngajñi nandá. Hya xi camá ne, quiji cavéjña me sehe cavicuya xu me xutacjín jan tsëhë ngajan ni cahntsua barcu. ");
INSERT INTO maqNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hane xi cajnetaha cavicuya me xuta jan ne, sehe ngajan xi cachja xu me cojo Simón cuitjin: ―‍Tángunvuhun sa cojo barcu vi hiscan nungun nandá, sehe ngajan ningatjunyun nahya xi chjuhun ti. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sehe ngajan xi cafayangui xu Simón tsëhë Jesús cuitjin: ―‍Tatá, cuaha nixten tinihñí xá vëhë ne, ndastu mé sacu niji. Peru sá xi cuatjin nújun ne, cuichjá cojo compañeru naha ne, ningatjinyin nahya. ―‍Cuatjin cafayangui xu Simón. ");
INSERT INTO maqNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hane xi casahmi me cuatjin ne, jercu tu cjín camaha xu ni ti cafaha me, ña meje xtiya nahya rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hya xi camá ne, casahmitsja xu me cojo xicjin me xi hincha barcu xingu jan xi cjue cuisecoo xicjin me. Sehe quiji me xi cuacun jan. Hya xi camá ne, catsinguitsë me catsijo barcu cojo ti xi cafaha me jan. Hane xi jercu catsë barcu ne, ña meje xtyusehen. ");
INSERT INTO maqNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hane xi cavëë Simón Pedru xcusun xi camá jan ne, sehe quiji caticjaxcun me xcun Jesús, sehe cachja xu me cuitjin: ―‍Tatá. Tángunxun hitsë tsahan ta, ngahan ne, ngu xuta tsehen ngahan. ―‍Cuatjin xu cachja Simón Pedru. ");
INSERT INTO maqNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Cuatjin cachja me ta, tsëhë xi jercu quijircun camahani rë me cojo compañeru rë me ngatsë rë ti xi jemu cjín camahani chu cafaha me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hacuanitjin xu ni quijircun rë yahnga compañeru rë Simón, me xi hmí rë Jacobo cojo Juan, me xi quihndi rë Zebedeo. Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo Simón: ―‍Xicarcuun ta quihndë cojo nixtin xi cjuiniji sa vi ne, ngayun cuangun nuvun xuta xi cuisehen me ladu naha ngojo rë xi nuvun chu ti. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hya xi camá ne, Simón cojo compañeru rë me ne, cavaxëxin xu me barcu jan tsëhë xcun nandá, caviyuju me nangui quixí. Sehe caviyuju me yëjë ni tsëhë me ne, sehe quiji me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cuitjin camá nga xu hya xi casetaha Jesús ngu nandya jan. Cafehe xu ngu cha xi jingujyë ni yojo rë yaha rë ngu xcusun chíhin vitaha. Hane xi cavëë xu cha Jesús ne, quiji cha caticjaxcun cha xcun Jesús cafehya cha cjuandaja xi sahmi me cojo rë cha, cuitjin xu cachja cha: ―‍Tatá. Sá xi meje nuju ne, cuma chjuhunxun chíhin xi yaha ná. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Hane xi catsixinga xu Jesús tsja me cavetahatsja me cha ne, cachja me cuitjin: ―‍Meje ná. Catamandaja ngayun. ―‍Cuatjin xu cachja me. Hane chíhin jan ne, ngutjen xu ni cavetjuxin. ");
INSERT INTO maqNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sehe cavitexa me cha cuitjin: ―‍Tsajin camahani yo xi cuinújun cojo xcusun vihi. Nihñu sacuatjin cavitexa Moisés xutachanga naja hatsëë nixtin. Tángun ningacun yojo nuju cojo nahmi, sehe tángun chjuhun ngu cjuatjo xi tuhun rë Nina tsëhë xi camandaja ngayun. Cuatjin nihñu cojo sa xi cumatsejen xi camandaja jain ngayun. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Peru handasa cuatjin xu cachja Jesús cojo cha ne, hitsë sa jercu cavitsojo cjua tsëhë xcusun xi casahmi me. Hya xi camá ne, jercu tu cjín camahani xuta quijitjengui xu me Jesús xi cuihndë me cjua rë Jesús hacuaha cumandaja me tsëhë chíhin xi ma rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Peru Jesús ne, yasen xu ni cavaxëxin me yojo rë me fi me ngajan ngu xín camahani, sahmi me oración rë me cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Cuitjin camá nga xu ngu nixtin hya xi tivicuya Jesús xuta. Hacuaha siu xu ngujo cha fariseo cojo ngujo cha xi vicuya cjuachacun xi canduva cha yëjë ni nandya tsëhë distritu Galilea cojo distritu Judea, cojo nandya Jerusalén. Hacuaha jercu yaha Jesús ngahñu rë Nina xi sahmi me xi cumandaja xuta hmu rë. ");
INSERT INTO maqNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hya xi camá xu ne, hora vëhë cafehe ngu cha xi cahme yojo rë, quichahahnga rë cha cojo nijña rë cha. Hane cha xi yahahnga rë cha ne, casahmi cha cjuandya xi cuisehen cha cahntsua ndihya xi cuejña cha cha hmu rë jan hiscan tacun Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Peru xi casacuiin xu rë cha chuva rë hacutjin cuisehen cha ngatsë rë xuta xi jercu quitsë camahani me jan ne, camiji xu cha rcu ndihya, hane cafahaxin cha tyjavanitja, sehe catsitujne cha cha hmu rë jan taha rcu ndihya cojo ni nijña rë cha, xi camá cavejña cha cha ngajñi rë xuta hiscan tacun Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hane xi cavëë Jesús xi cuatjin mangucacun cha xi cuacun jan cojo rë me ne, sehe cachja xu me cuitjin cojo cha hmu rë jan: ―‍Jyë́ nuju tsan ne, ha camanchataha. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hya xi camá xu ne, cha xi vicuya cjuachacun cojo cha fariseo xi cuacun jan ne, cavetsihin catsingataha cacun cha cachja xu cha cuitjin cojo xicjin cha: ―‍¿Yo cha xi cuijyihi vi xi tsixcuehyu cha Nina? ¡Hatuxa tsajin yo xi cuma tsinchataha jyë́ rë xuta ta suvá ni Nina xi cuma tsinchataha me! ―‍Cuatjin xu cachja cha cojo xicjin cha. ");
INSERT INTO maqNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Peru tsëhë xi Jesús ne, ha vëë me mé xi titsingataha cacun cha xi cuacun jan ne, cachja xu me cojo cha cuitjin: ―‍¿Mé xi tiningatuhuntacún cojo cjuatacun nuju? ");
INSERT INTO maqNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jarë cjua xi hitsë sa tsaviin xi cuichjá? ¿Há xi: “Jyë́ nuju ne, ha camanchataha?”, o ¿há xi: “Tisatjunhngun ne, tujyuhunyun?” ");
INSERT INTO maqNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Peru nguehe suá cumachaya nuju xi ngahan xi Quihndi rë Xuta Jain ngahan ne, yahá xá xi tsinchátaha jyë́ rë xuta nguehe ngasunhndë. Sehe ngajan xi cachja xu Jesús cojo cha hmu rë jan: ―‍Quihndë ne, ngayun tsan ne, tisatjunhngun, chjuhun nijña nuju vë ne, sehe tjangun ndya nuju. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hya xi camá ne, ngutjen ni cavisatjenhnga xu cha ngajñi rë yëjë ni xuta, sehe cafaha cha nijña rë cha, cafe cha, taha sahmi jyë sahmi hnga cha Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Hane yëjë ni xuta jan ne, jercu quijircun xu rë me, hacuaha cojo me casahmi jyë casahmi hnga xu me Nina, hisca catsacjun me camá. Hacuaha cachja xu me cuitjin: ―‍Quihndë cahyan xcusun xi tsajin nixtin xi hyan. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hya xi camá xu ne, xi cavetju Jesús jan ne, cavechú me ngu cahndë́ hiscan xi tacun ngu me xi faha tujúnsa, me xi hmí rë Leví. Sehe cachja xu me cojo me cuitjin: ―‍Nduvun, cuanguen cona. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Hya xi camá ne, Leví jan ne, caviyuju yëjë mé xcusun xi sahmixa me cojo jan ne, sehe cavetju xu me quiji me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hane xi cavatju vëhë ne, sehe casahmi xu me ngu suhi ngajan ndava me ngatsë rë Jesús. Hacuaha jercu cjín camaha xu ni cha xi faha tujúnsa cojo jingu sa xuta tijinë me niñu cojo Jesús cojo Leví. ");
INSERT INTO maqNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hane cha fariseo cojo cha xi vicuya cjuachacun cavetsihin cachjataha xu cha xuta ladu rë Jesús cuitjin: ―‍¿Mé má cuatjin chinu hyun tangun cojo cha xi faha tujúnsa cojo ngujo sa cha xi hacuaha cha tsehen cha? ―‍Cuatjin xu cachjataha cha. ");
INSERT INTO maqNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hane xi cafayangui Jesús tsëhë cha ne, cuitjin xu cachja me: ―‍Xuta xi hacuiin hmu rë me ne, mijí rë xi cjuahacuenda rë me doctor ta suvá ni xuta xi hmu rë me ne, me vëhë xi meje rë xi cjuahacuenda rë me doctor. ");
INSERT INTO maqNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Hacuanitjin ná ngahan ta ngahan ne, hacuiin canduvá nguehe xi squindáyavaha rë xuta xi tsajin jyë́ rë me ta xi canduvá ne, xi squindáyavaha rë xuta tsehen. Cuichjá cojo rë me xi tsindeya me cjuatacun rë me. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ngajan xi cha fariseo cojo cha xi vicuya cjuachacun ne, cachja xu cha cuitjin cojo Jesús: ―‍Yëjë xuta ladu rë Juan ne, yasen ni sahmi me xun rë me hacuaha sahmi me oración rë me cojo Nina. Hacuanitjin ni yëjë xuta ladu rë cha fariseo. Peru xuta ladu nuju ne, jinë jihvi me. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ngajan xi Jesús ne, cuitjin xu cachja me cojo cha: ―‍Cumaji xi xuta rë cha xi tivixan ne, sahmi me xun rë me jinguyëjë rë xi cha xi tivixan ne, tacun cha cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Peru cuechú nixtin xi cha xi tivixan chjaháxin rë cha tsëhë xuta rë cha ne, hya sahmi me xun rë me. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hacuaha cachja nga xu me ngu ejemplu vihi cojo cha xi cuacun jan: ―‍Tsajin yo xi cuicheya ngu rquí tsjian xatsë sehe cueyacoo cojo ngu tsjian changá ta sá xi cuatjin sahmi me ne, tsjian xatsë jan ne, tsinguetsun me. Hacuaha cumatanguaain ngu rquí tsjian xatsë cojo tsjian changá jan. ");
INSERT INTO maqNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hacuaha tsajin yo xi cuincha xan xatsë cahntsua chuxin changá ta sá xi cuatjin sahmi ne, xan xatsë jan ne, tsitsinga rë chuxin jan. Hane cjuë cuixu xan, hacuaha chuxin jan ne, cuetsun. ");
INSERT INTO maqNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Xi meje rë ne, xan xatsë ne, xincha cahntsua chuxin xatsë. ");
INSERT INTO maqNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hacuaha ngu xuta xi ha cahvi me xan changá ne, ha quihndë mijí cuihi me xan xatsë, tsëhë xi chja me ta xan changá ne, vëhë xi ndaja hyun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hacuaha cuitjin camá nga xu ngu nixtin xi chjahájenda rë. Hya xi tivatju xu Jesús cojo xuta ladu rë me hiscan tjin tjë trigu ne, cavotohosun xuta ladu rë me tsë tsë trigu jan, sehe catsufëtsja me, sehe cajinë me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sehe ngajan xi ngujo cha fariseo xi cojo cjui jan ne, cachjataha xu cha me cuitjin: ―‍¿Mé má cuatjin tisahmi xuta ladu nuju xá, handasa chja ley naja xi tsajin cahndë́ xi nihña xá nixtin xi chjahájenda rë? ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ngajan xi Jesús ne, cuitjin xu cafayangui me tsëhë cha: ―‍Ngayun ne, ha cachutayun xcusun xi casahmi xutachanga naja David hatsëë nixtin. Hya xi jercu camavojo rë me cojo xuta xi siu cojo me ne, ");
INSERT INTO maqNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","cavisehen me ndava Nina, hane cafaha me pan xi viyuju xcun Nina xi tsajin cahndë́ xi tu yo ni sinë ta suvá ni nahmi xi cuma sinë me. Peru me vëhë ne, cajinë me hacuaha casua me cajinë xuta xi siu cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hacuaha cachja sa Jesús cuitjin: ―‍Ngahan xi Quihndi rë Xuta Jain ngahan ne, ngahan xi vitéxa mé xi cuma nixtin xi chjahájenda rë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Cuitjin camá nga xu ngu nixtin xi chjahájenda rë. Quiji Jesús yungun ne, cavicuya me. Hane tacun xu ngu cha cahntsua yungun jan xi quixíhñu tsja quixi cha. ");
INSERT INTO maqNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hane cha xi vicuya cjuachacun cojo cha fariseo xu ne, siu tifahachuva xu ni cha Jesús, ¿há sahmi me xi cumandaja xuta nixtin xi chjahájenda rë?, cojo sa xi cuma cuinchajyë cha me tsëhë xi sahmi me xá nixtin xi chjahájenda rë. ");
INSERT INTO maqNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Peru Jesús ne, ha vëë me mé xi tsingataha cacun cha xi cuacun jan. Sehe cachja xu me cojo cha xi quixíhñu tsja jan cuitjin: ―‍Tisatjunhngun, hane tisechun nguehe cavasencja. ―‍Cuatjin xu cachja Jesús. Hane sehe cavisatjenhnga xu cha cavisecun cha. ");
INSERT INTO maqNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sehe ngajan xi cachja xu Jesús cojo cha xi cuacun jan cuitjin: ―‍Sahme nuju ngu cjuachjinenguise vihi: Nixtin xi chjahájenda rë ne, ¿mé xi sua cahndë́ ley xi nihña?, ¿há xi cjuandaja ne?, o ¿há xi cjuatsehen? ¿Há xi naxentjeen cjuahñu rë xingueen ne?, o ¿há xi nicjeen? ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Xi cavutsejen Jesús xuta jingujyë ni tahndee rë me ne, sehe cachja xu me cojo cha xi hmu tsja jan cuitjin: ―‍Nixingun ntsun. ―‍Cuatjin xu cachja me. Hane cuatjin casahmi cha. Hane tsja cha ne, ha camandaja xu sacuatjin xi jyihi titjún. ");
INSERT INTO maqNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hya xi camá ne, cha xi cuacun jan ne, jemu camacjan camaha xu ni rë cha, hisca cachja cha ngajñi rë cha cojo xicjin cha mé xi ndatjin sahmi xu cha cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hacuaha cuitjin camá nga xu ngu nixtin nixtin xi cuacun vë. Cavetju Jesús quiji xu me ngu ndetjún xi sahmi me oración, hane ngajan cavéjña me cuaha nixten sahmi me oración rë me cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hane xi casahasen ne, cajindayavaha xu me xuta ladu rë me, hane ngajñi rë xuta xi cuacun vë ne, cavaxijinjñi xu me tejó xihin. Hane me xi tejó vëhë ne, me vëhë xu xi cachja Jesús tsëhë me apóstol. ");
INSERT INTO maqNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Me xi cuicun vi xi tejó me xi cavaxijin Jesús: Simón, me xi hacuaha casuañihi me me Pedru, cojo Andrés hntsë Simón, Jacobo cojo Juan, Felipe cojo Bartolomé, ");
INSERT INTO maqNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo cojo Tomás, Jacobo quihndi rë Alfeo cojo Simón, me xi tsëhë partidu zelota, ");
INSERT INTO maqNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas xuta rë Jacobo cojo Judas Iscariote, me xi sahmi entregadu rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Hane xi cavuya canduvajne xu Jesús tsëhë naxi jan cojo xuta ladu rë me jan ne, xi cafehe xu me ngu ngasun ne, ngajan caxinchacunhñu xu me cojo xuta jan. Hacuaha jercu cjín sa xuta ladu rë me xi siuya jan, siuya tangun cojo jemu cjín camaha xu ni xuta tsëhë nandya Jerusalén cojo tsëhë yëjë sa nación Israel, hisca cojo xu xuta xi nduva tsëhë nandya Tiro cojo Sidón, xi siu ladu tsëhë tjehen ndachacun. ");
INSERT INTO maqNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yahnga xu xuta xi cuacun vë ne, canduva me xi meje cuisiñuju me cjua rë Jesús, hacuaha yahnga nga me ne, canduva me xi meje rë me xi cumandaja me tsëhë chíhin xi yaha rë me. Hacuaha me xi jemu tivatju cjuañihi xi hincha xitsehen cahntsua xahasen rë me ne, hacuaha camandaja xu me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yëjë ni xutacjín jan ne, cavanguise me chuva rë xi satëtsja me Jesús ta, tsëhë xi Jesús ne, jemu tjin rë me ngahñu rë Nina, hane ngahñu vëhë tisahmi xi mandaja xu yëjë xuta hmu rë. ");
INSERT INTO maqNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ngajan xi ngaxtun vëhë xu ne, cavutsejen Jesús xuta ladu rë me, sehe cachja xu me cojo cuitjin: ―‍Jemu ndaja tsujun ngayun xi yumu matsejen ta, tsëhë xi ngayun matsejen ne, satë nuju gubiernu xi sahmi Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Jemu ndaja tsujun ngayun xi vojo nuju quihndë matsejen ta, tsëhë xi cuechú nixtin xi jemu chuya rë xahasen nuju. ’Jemu ndaja tsujun ngayun xi tichjihndun quihndë matsejen ta, tsëhë xi cuechú nixtin xi cuéjnu. ");
INSERT INTO maqNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Hacuaha jemu ndaja tsujun ngayun hya xi choho scuëë nuju xuta, o hya xi cuaxëxin nuju me tsëhë ngajñi rë me, o hya xi choho cuichja me cojo nuju, o hya xi tsitjungui nuju me, ngatsë rë xi tjin tangun cjuatacun nuju cojo ná ngahan xi Quihndi rë Xuta Jain ngahan. ");
INSERT INTO maqNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hisca chijihngun xi ndama nuju xi cuatjin tivatjun tijima nixtin hya matsejen ta, tsëhë xi jemu jyë ngu cjuandaja xi tacunya nuju ngajan ngahnga. Jemu ndaja tsujun matsejen ta, tsëhë xi cuanitjin ni choho casahmi xutachanga naja cojo profeta hatsëë nixtin, hane jemu cachuya rë Nina tsëhë profeta xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Peru jemu chojyihi tsujun ngayun xi nchina ngayun matsejen ta, tsëhë xi ha casacu nuju cjuetacun xi cuma nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Jemu chojyihi tsujun ngayun xi ha jemu chuya rë xahasen nuju quihndë matsejen ta, tsëhë xi cuechú nixtin xi cuma vojo nuju. ’Jemu chojyihi tsujun ngayun xi tivéjnu quihndë matsejen ta, tsëhë xi cuechú nixtin xi jercu chjihndun xi cuma va rë xahasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Hacuaha jemu chojyihi tsujun ngayun hya xi ndaja cuichja yëjë xuta tsujun matsejen ta, tsëhë xi cuanitjin ni ndaja casahmi xutachanga naja cojo profeta ndacha hatsëë nixtin, hane profeta ndacha xi cuacun vë ne, cachuyiin rë Nina tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Peru ngayun xi tinuhyun xi chjá matsejen ne, cuichjá cojo nuju cuitjin: Nihmutacún xuta xi má condra nuju, ndaja nihñu cojo xuta xi choho vëë nuju me, ");
INSERT INTO maqNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","chjahyun rë Nina cjuandaja xi cuma rë xuta xi fehya rë me Nina cjuahngatacun xi cuatjun cuma. Ngajñi rë oración nuju matsejen ne, chjahyun rë Nina cjuandaja xi cuma rë xuta xi vangui nuju me si. ");
INSERT INTO maqNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yo xi vajaya ngu ladu tsa nuju matsejen ne, nicuyun sa ngu ladu catajaya. Yo xi fahatahá chingá nuju matsejen ne, xicanichuun rë hisca chingá ngahma nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yëjë ni xuta xi fehya nuju me mé xi fehya nuju me matsejen ne, tuhun rë me. Yo xi fahatahá mé xi fahatahá tsuhun matsejen ne, xicanujuun xi tsicuya nga me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sacuatjin xi meje nuju xi sahmi xuta cojo nuju matsejen ne, hacuaha cuanitjin ni nihñu cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tsajin yo sua nacuechji nuju tsëhë xi hmutacún xuta xi hmucacun nuju me matsejen ta, tsëhë xi hacuaha hisca xuta tsehen matsejen ne, hmucacun me xuta xi hmucacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hacuaha tsajin yo sua nacuechji nuju tsëhë xi ndaja nihñu cojo xuta xi ndaja sahmi me cojo nuju matsejen ta, tsëhë xi hacuaha hisca xuta tsehen matsejen ne, hacuanitjin ni sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Hacuaha tsajin yo sua nacuechji nuju tsëhë xi tuhun vuxetaha xuta xi vetuhun tacún xi ngascan matsejen ne, sua me nuxetuhun matsejen ta, tsëhë xi hacuaha hisca xuta tsehen matsejen ne, sua me vuxetaha xicjin me, cojo sa xi cuya cjuahatsja nga me chuva vëhë ni. ");
INSERT INTO maqNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Cúya cuichjá nga cojo nuju, nihmutacún xuta xi má condra nuju. Ndaja nihñu, hacuaha tuhun tuxetaha rë, peru xicavetuun tacún xi cuya chjuhunntsun nga. Sá xi cuatjin nihñu matsejen ne, jemu jyë cjuandaja xi sua nuju Nina ngascan, hane cjuandaja xi nihñu ngayun matsejen ne, tangun cojo cjuandaja xi sahmi Nina matsejen ta, tsëhë xi me vëhë matsejen ne, hatuxa jemu ndaja me cojo xuta tsehen xi hisca nacuechji rë Nina suaain me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Meje rë xi tjin nuju cjuayumatacun sacuatjin tjin rë Nina Nahmi naja cjuayumatacun. ");
INSERT INTO maqNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Hacuiin nichuvun jingu sa xuta cojo cjuatacun rë me, sehe hacuiin tsichuva Nina ngayun. Hacuiin ninguixun jyë́ rë jingu sa xuta, sehe hacuiin tsinguixi Nina jyë́ nuju. Ninchatuhun rë jingu sa xuta matsejen ne, sehe hacuaha tsinchataha nuju Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tuhun rë jingu sa xuta matsejen ne, sehe hacuaha sua nuju Nina. Sua nuju me chuva xi cjuaquixi, hisca tsuquihine me, hisca tsiniyaya me chuva rë, hacuaha hisca xotje rë chuva xi sua nuju me. Cuatjin nihñu matsejen ta, tsëhë xi chuva xi nichuvun matsejen ne, hacuaha chuva vëhë tsichuva Nina xi sua nuju me. ―‍Cuatjin xu cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hya xi camá ne, cachja sa xu me ngu ejemplu cuitjin: ―‍Ngu cha rcá matsejen ne, cumaji cjuecani cha ngu nga cha rcá matsejen ta, sá xi cuatjin matsejen ne, catsijo ni cha cuixuya cha xanga. ");
INSERT INTO maqNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ngu cha xi sehe tivutaya matsejen ne, hacuiin hitsë sa vengui chjí rë cha xi cuma rë maestru rë cha matsejen ta hya xi ha ndaja cavutaya cha yëjë ni matsejen ne, sehe ngajan xi cuechútáha cjuatacun rë cha sacuaha cjuatacun rë maestru rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Hacutjin má xi matsejen nuju xtë xi jiya tuxcun xingun, hane machayiin nuju tsëhë yasin xi jiya túxcun suvun ni? ");
INSERT INTO maqNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Hacutjin má xi cuma cuinújun cojo xingun xi meje naxun xtë xi jiya tuxcun me jinguyëjë rë xi suvun matsejen ne, matsijin nuju yasin xi jiya túxcun vë ni? Ngayun xuta ndacha, naxun titjun yasin xi jiya túxcun vë, sehe cumatsejenndaja nuju xtë xi jiya tuxcun xingun cojo sa xi cuma naxun. ");
INSERT INTO maqNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ha hyan matsejen ta tsajin hisca xi ngu yatjë xi ya ndaja xi sua tú xi ndajin, hacuaha tsajin hisca xi ngu ya xi ya machjiriin xi sua tú xi ndaja matsejen ta, ");
INSERT INTO maqNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","jima ngu ya ne, cuma tsejen sá xi ndaja o sá xi ndajin ngatsë rë tú xi sua. Hatuxa sacuiin naja tú xi hmí higo rcu ngu yanahyálatu, hacuaha sacuiin naja uva rcu ngu yanahyátindu. ");
INSERT INTO maqNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Cuanitjin ni rë xuta matsejen ta sacuaha xuta ndaja matsejen ne, tsëhë cjuandaja xi tetjo rë me cahntsua xahasen rë me cojo cahntsua cjuatacun rë me matsejen ne, tsëhë ngajan vetju cjuandaja. Peru xuta tsehen matsejen ne, tsëhë cjuatsehen xi tetjo rë me matsejen ne, tsëhë ngajan vetju cjuatsehen. Cuatjin matsejen ta, tsëhë xi yëjë ni xuta ne, cjua xi quitsë rë xahasen rë me cojo cjuatacun rë me matsejen ne, vëhë cjua xi vetju hntsua me. ");
INSERT INTO maqNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Yasen ni nújun xi nai nuju ngahan, peru ¿mé má nihñuu sacuatjin xi chjá cojo nuju ni? ");
INSERT INTO maqNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yahnga ngayun xi nduvuntjengun ná hacuaha visiñuju cjua naha hacuaha nihñu sacuatjin chjá cojo nuju matsejen ne, nguehe cuichjá cojo nuju yo xi tangun ngayun cojo: ");
INSERT INTO maqNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","tangun ngayun cojo ngu cha xi hya xi casahmi cha ngu ndihya matsejen ne, ndaja nungun cafahngui cha, sehe ngajan cavejña cha xihndënaña rë hisca xcun ndyojohñu. Hane hya xi camajyë ndajyë hacuaha casesuntë nandá matsejen ne, jercu hñu catsivaha rë ndihya jan, peru hisca catsiniyaain rë, tsëhë xi jemu ndatjin casecun. ");
INSERT INTO maqNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Peru yahnga nga ngayun xi visiñuju cjua naha peru nihñuu sacuatjin xi chjá matsejen ne, tangun ngayun cojo ngu cha xi casahmi ngu ndihya suvá xcun nangui ni, xi tsajin xihndënaña rë. Hane hya xi camá ne, xi camajyë ndajyë matsejen ne, catsivaha rë ndihya jan, hane ngutjen ni caticja. Hane cavetsun camahani ndihya vëhë. Cuatjin xu cajnetaha cavicuya Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Xi cajnetaha xu cachja Jesús yëjë ni cjua xi meje cuichja me cojo xuta ne, sehe cavuya quiji nga me nandya Capernaum. ");
INSERT INTO maqNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hane nandya jan ne, ngajan xu tacun ngu capitán xi tjin rë me ngu hndixahan xi cavatsë me xi jiñahmú, ha ña meje cueya camaha xu ni. Capitán jan ne, jemu hmucacun xu me hndixahan jan. ");
INSERT INTO maqNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hane xi camachaya xu rë capitán jan xi tacun Jesús ne, catsingatju xu me ngujo xuta changá rë xuta tjë rë Israel xi quiji cachja me cojo Jesús xi cjue sahmi me xi cumandaja hndixahan rë capitán jan. ");
INSERT INTO maqNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hane xi cafehe xuta changá jan hiscan tacun Jesús ne, nguñaja camahani cacun me cafehya me xi cjue xu Jesús. Cachja me cuitjin: ―‍Nihñu favor ne, tisecun rë capitán hitsë ta, tsëhë xi jemu ndaja me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Handasa hisca hacuiin tjë rë xutachanga naja me ne, peru jemu hmucacun me ngayaan xuta tjë rë Israel, hacuaha casahmi me yungun niji cojo ngahñu rë suva me. ―‍Cuatjin xu cachja xuta changá jan. ");
INSERT INTO maqNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hya xi camá ne, quiji xu Jesús cojo rë me. Hane xi ha jima tiñataha me ne, sehe catsingatju xu capitán ngujo xuta ndaja rë me xi quijitjengui me Jesús. Hane xi cavechútáha xu me Jesús ngajan ndiya ne, cuitjin cachja me sacuatjin cachja capitán cojo rë me xi cuichja me cojo Jesús: ―‍Tatá. Xicatuhunndyuun yojo nuju. Ngahan ne, vechiin chuva rë xi ngayun cuinduvun ndya naha ta, tsëhë xi ngayun xi jemu jyë hnga ngayun cojo cjuatacun nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Vëhë xi hacuaha tsingátaha cácun xi jemu chúva ngahan cojo cjuatacun naha xi cjuë́ cuichjá cojo nuju. Quihndë ne, ndastu nihñu favor ne, tinújun xi cumandaja hndixahan naha. ");
INSERT INTO maqNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngahan ne, hvë xi cuma nihñu xcusun vëhë ta, ngahan ne, hacuaha tjin xuta xi matitjun tsahan, hane hacuaha tjin ná sindadu xi siu ngahma gubiernu naha xi sahmi hacutjin xi meje ná. Hya xi chjá cojo ngu xi cjue ne, fi. Hacuaha hya xi chjá cojo ngu nga xi cuinduva ne, nduva. Hane hndixahan naha ne, xi chjá cojo xi sahmi mé xi meje ná ne, sahmi. ―‍Cuatjin xu cachja xuta ndaja rë capitán jan cjua rë capitán cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hane xi cahndë xu Jesús cjua vëhë ne, jemu quijircun rë me tsëhë capitán jan. Hane xi cavuya me cavutsejen me xutacjín xi tjengui rë me jan ne, cachja xu me cuitjin: ―‍Cuichjá cojo nuju ta, ngajñi naja ngayejen ni ngayaan xuta tjë rë Israel ne, cjëë scuëë ngu xuta xi cuatjin ndaja mangucacun me cojo ná. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hane xi cavuya xu me xi quiji tixa jan ne, cavëë me xi ha camandaja cha hndixahan jan. ");
INSERT INTO maqNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Xi cavatju vëhë ne, quiji nga xu Jesús ngu nandya xi hmí rë Naín. Cavisecoo xuta ladu rë me me quiji me, cojo jingu sa xutacjín xi cojo me quiji me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hane xi tijima tiña xu me tsëhë tingotjo hnchua tsëhë nandya jan ne, cjui seyaniji xu ngu nima, ngu nima xi quihndi ngu tsëhë naa rë. Hacuaha naa rë nima jan ne, cahan xu me. Jercu cjín camahani xuta nandya visecoo me chjuun jan cjui me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hane xi cavëë xu Nai naja chjuun jan ne, camayuma rë me me. Sehe cachja me cojo chjuun jan cuitjin: ―‍Ha quihndë xicachjihnduun. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hane xi quiji tiña xu Jesús hiscan xi cjui me cojo nima jan ne, sehe quiji cavetahatsja xu me nachan xi quisun nima jan. Hane xuta xi yahahnga rë nima jan ne, caxinchacunhñu me. Sehe ngajan xi Jesús ne, cachja xu me cuitjin: ―‍Quihndë ne, ngayun tsan ne, tisatjunhngun. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hane nima jan ne, cavisatjenhnga xu cha cavéjña cha. Sehe cavetsihin cachja cha. Sehe cachja Jesús cojo naa rë cha jan xi cjuahatsja nga me quihndi rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hya xi camá xu ne, yëjë ni xuta jan ne, jemu catsacjun me camá. Hacuaha casahmi jyë casahmi hnga me Nina, cuitjin xu cachja me: ―‍Cavetjujñi ngajñi naja ngu profeta xi jercu vengui chji rë me, hacuaha casahmi Nina cjuandaja rë me cojo naja ngayaan xuta rë me. ―‍Cuatjin xu casahmi jyë casahmi hnga me Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hya xi camá ne, cavitsojo xu cjua vëhë tsëhë Jesús jingujyë ni ladu vëhë cojo jingujyë ni nación Israel. ");
INSERT INTO maqNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Cuitjin xu camá nixtin xi cuacun vë. Xuta ladu rë Juan ne, casua me camachaya rë me yëjë xcusun xi casahmi Jesús. Sehe ngajan xi Juan ne, cajindaya xu me jo xuta ladu rë me jan ne, ");
INSERT INTO maqNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sehe catsingatju me me xi cjue cjuinenguise xu me Nai naja sá xi me vëhë xi chja xujun rë Nina xi tsingatju Nina me, o sá xi meje rë xi cuiyujuya rë xi cuinduva nga ngu. ");
INSERT INTO maqNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hane xi cafehe xuta xi catsingatju Juan jan hiscan quitahá Jesús ne, cachja xu me cuitjin: ―‍Juan Vitenda rë Xuta ne, catsingatju niji me xi nduvin vinenguisin nuju ¿há ngayun xi tsingatju nuju Nina, o há tsajin ne, há cuinechinyin xi cuinduva nga ngu? ―‍Cuatjin xu cavinenguise xuta xi catsingatju Juan jan. ");
INSERT INTO maqNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hane ha hora vëhë ni ne, Jesús ne, casahmi me xi jemu cjín xu xuta camandaja me tsëhë tu mé ni xcusun chíhin xi má rë me. Hacuaha jemu cjín sa xuta xi cavaxëxin Jesús xitsehen xi hincha cahntsua xahasen rë. Hacuaha jemu cjín sa xu xuta rcá xi casahmi Jesús xi camá camatsejen rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hya xi camá ne, xi catsicuya me cjua cojo xuta ladu rë Juan ne, cuitjin xu cachja me: ―‍Tjangun ne, sehe tinújun cojo Juan yëjë xcusun xi cahyun cojo yëjë cjua xi canuhyun. Tinújun ta xuta rcá ne, camá camatsejen rë me; xuta rengun ne, camá quijindaja me; xuta xi yaha rë chíhin vitaha xi setaha yojo naja ne, camandaja me; xuta xi loho me ne, camá cahndë me; nima ne, cavuya nga cjuahñu; xuta yuma ne, casacu camachaya rë me cjuandajyihi rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hacuaha jemu ndaja tsëhë tu yo ni xuta xi hacuiin tsismicacun me xi mangu cacun me cojo ná. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hane hya xi cavuya cafe xu xuta ladu rë Juan jan ne, sehe cachja Jesús cojo xutacjín jan cuitjin tsëhë Juan: ―‍Hya xi cavetjun catsangun ngajan ngu xín tsëhë nandya catsanguntjengun Juan matsejen ne, ¿há caningatuhuntacún xi cuechuntuhun ngu xihin xi hacuiin ngu ni cjuatacun rë me?, sacuatjin rë ngu ndeje xi fi nguehe fi ngajan rcu sacuatjin cjui tjo. ");
INSERT INTO maqNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O há tsajin ne, ¿há caningatuhuntacún xi cuechuntuhun ngu xihin xi yaja ngu tsjian xi jemu tu ndajyihi camahani? Hacuiin cuatjin. Ha hyan matsejen ta xuta xi jercu tu ndacun camahani tsjian vaja me hacuaha hatuxa jemu cjuasua siu me matsejen ne, sacuiin naja me ngajan ngu xín camaha ni tsëhë nandya matsejen ta hiscan xi sacu naja me ne, ndava ngu xuta nchina. ");
INSERT INTO maqNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Peru ngayun matsejen ne, catsangun cachutsujun ngu profeta. Hacuaha cjuaquixi xi vëhë cachutsujun. Peru profeta Juan vë matsejen ne, hitsë sa vengui chji rë me xi cuma rë yëjë sa profeta xi yahnga. ");
INSERT INTO maqNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Hacuaha me vëhë xi cachja Nina tsëhë me xcun xujun rë me cuitjin: Ngahan ne, tsingátju titjun ngu cha xi scuxaha cjuatacun rë xuta tsëhë xi cjuehé ngaye. Cuatjin cachja Nina cojo Quihndi rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cuichjá cojo nuju matsejen ta ngajñi rë yëjë xuta xi catsin me tsëhë naa rë me matsejen ne, tsajin ngu xi hitsë sa vengui chji rë xi cuma rë Juan. Peru hya xi cuetsihin Nina sahmi me gubiernu nguehe ngasunhndë matsejen ne, xuta xi chuva cuengui chji rë me quihndë matsejen ne, hitsë sa cuengui chji rë me nixtin hya, xi cuma rë xi ha vengui chji rë Juan quihndë. ");
INSERT INTO maqNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hane hya xi yëjë ni xuta hisca cojo cha xi faha tujúnsa cahndë me cjua xi cachja Juan matsejen ne, catsingatihin me xi cuitenda Juan me. Hane chuva vëhë matsejen ne, catsingacun me xi macjain rë me xi Nina matsejen ne, yëjë xcusun xi sahmi me matsejen ne, hatuxa cjuaquixindaja jain. ");
INSERT INTO maqNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Peru jemu cjín cha fariseo cojo cha vicuya cjuachacun matsejen ne, catsingatiin cha xi cuitenda Juan cha. Hane chuva vëhë matsejen ne, catsitjungui cha xcusun xi meje sahmi Nina xi cuma tsëhë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","’Ngayun xuta tjë rë Israel tsëhë nixtin vihi matsejen ne, ¿mé xi tangun ngayun cojo? ");
INSERT INTO maqNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tangun ngayun cojo langa xi siu ngajan ndetsin, xi jindaya xicjin cojo cjua vihi: “Canijani tsujun ne, mijí xtun; casin va ne, mijí chjihndun.” Cuatjin jindaya langa. ");
INSERT INTO maqNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Cuatjin chjá cojo nuju matsejen ta, Juan xi vitenda nuju ngayun matsejen ne, jinii me niñu hacuaha hviin me xan, hane ngayun nújun ta jiya xitsehen xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hane ngahan xi Quihndi rë Xuta Jain matsejen ne, jínë hacuaha hvë, hane nújun xi ngahan matsejen ne, ngu cha cahntsuaniñu ngahan, ngu cha cahntsuaxan ngahan, hacuaha ngu cha amigu rë cha xi faha tujúnsa cojo jingu sa xuta tsehen ngahan. ");
INSERT INTO maqNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Peru xuta xi fitjengui me cjuatacun rë Nina matsejen ne, xuta xi cuacun vëhë xi tsingacun naja me xi cjuatacun vëhë matsejen ne, ndaja jain. ―‍Cuatjin xu catsinguijnetaha Jesús cjua rë me cojo xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ngu nixtin nga jan ne, cuitjin xu camá. Ngu cha fariseo ne, cachja xu cha cojo Jesús xi cjue sinë me cojo cha niñu ndava cha. Hane xi cavisehen me ndava cha fariseo jan ne, sehe quiji cafaha xu me cahndë́ rë me xcun maxë xi sinë me niñu. ");
INSERT INTO maqNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ngajan xi ngu chjuun tsehen tsëhë nandya vëhë ne, camachaya xu rë na xi Jesús ne, tacun me ndava ngu cha fariseo tijinë me niñu cojo cha ne, yaha xu na ngu frascu xi ndyojo camá, hincha ngu xcusun aceite ndaja xi jercu hnga chji rë. ");
INSERT INTO maqNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Quiji xu na secun na táha ntsacu me, jihnda na. Hane cojo ndatuxcun na ne, cavetsihin catsicahnchi xu na ntsacu me. Hane cojo tsjarcu na ne, cavujnu na, sehe cavitatsuha na. Hya xi camá xu ne, sehe cavitejnu na aceite. ");
INSERT INTO maqNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Peru xi cavëë xu cha fariseo xi quijicojo rë me jan xi cuatjin casahmi na ne, catsingataha cacun cha cuitjin: “Cha xi cuijyihi vihi ne, sá xi profeta jain cha ne, ha vëë cha mé xcusun chjuun na xi cuatjin satëtsja rë cha ta, tsëhë xi na vëhë ne, ngu chjuun tsehen na.” Cuatjin catsingataha cacun xu cha. ");
INSERT INTO maqNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sehe ngajan xi Jesús ne, catsicuya xu me cjua tsëhë cjuatacun xi catsingataha cacun cha fariseo jan, cuitjin xu cachja me: ―‍Simón, tjin ná ngujo cjua xi cuichjá cojo nuju. ―‍Cuatjin xu cachja me. Ngajan xi cha Simón jan ne, cuitjin xu cafayangui cha tsëhë me: ―‍Maestro, tinújun. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hya xi camá xu ne, cachja Jesús cuitjin cojo cha ngu ejemplu: ―‍Cuejña ne xi jo cha jan ne, quitjen cha tujún tsëhë ngu cha nchina. Ngu cha ne, quitjen cha tujún tsëhë hñu cientu nixtin xi sahmi ngu mosu xá. Hane ngu nga cha ne, quitjen cha tujún tsëhë yachan të nixtin. ");
INSERT INTO maqNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hane xi tsajin rë cha xi cuacun vë tujún xi sahmingojo cha ne, cha nchina jan ne, catsinchataha cha catsijo cha. ¿Jarë cha xi cuicun vi xi hitsë sa tsihmu cacun cha cha nchina jan, xi má nuju? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sehe ngajan xi cafayangui xu cha Simón cuitjin: ―‍Xi má ná ne, cha xi hitsë sa cjín quitjen. ―‍Cuatjin xu cachja cha Simón. Sehe ngajan xi cachja xu Jesús cojo cha cuitjin: ―‍Jemu ndaja canichuvun cjua xi canújun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hane xi cavuya xu me cavutsejen me chjuun jan ne, sehe cachja nga me cojo cha Simón cuitjin: ―‍Chutsujun hacutjin casahmi chjuun vihi cojo ná. Ngayun ne, hora xi cavísehen ndya nuju ne, catuun nandá xi cjuengui ntsacú. Peru chjuun vihi ne, cojo ndatuxcun na catsicahnchi na ntsacú, hane cojo tsjarcu na ne, cavujnu na. ");
INSERT INTO maqNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hacuaha ngayun ne, cavitatsuun ná. Peru na vihi ne, hisca hora xi cavísehen ne, cjëë cuejñaxin na xi vitatsuha na ntsacú. ");
INSERT INTO maqNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ngayun ne, cavitejnuu aceite rcú. Peru chjuun vihi ne, cavitejnu na aceite ntsacú, aceite xi jemu ndaja jne camahani. ");
INSERT INTO maqNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Vëhë xi cuichjá cojo nuju ta tsejen xi ha camanchataha na tsëhë jyë́ cjín xi tjin rë na ta, tsëhë xi jemu tjin rë na cjuahmutacun. Peru yo xi manchataha tsëhë hitsë jyë́ xi tjin rë ne, hacuaha chúva cjuahmutacun tjin rë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ngajan xi cachja xu Jesús cojo chjuun jan cuitjin: ―‍Jyë́ nuju ne, ha camanchataha. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hane xuta xi tijinë xu cojo rë me jan ne, cavetsihin cavinenguise me ngajñi rë me cojo xicjin me cuitjin: ―‍¿Yo rë cha xi cuijyihi vi xi hisca jyë́ rë xuta tsinchataha cha? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Peru Jesús ne, cachja nga xu me cojo rë chjuun jan cuitjin: ―‍Ngayun ne, ha cavetjuntjun ta, tsëhë xi camangutacún cojo ná. Cuma cuangun cojo cjuasua. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Cuitjin camá nga xu ngu nixtin. Jesús ne, titsujyihiya xu me jemu cjín nandya cojo ranchun tisua me tijimachaya rë xuta cjuandajyihi xi chja tsëhë gubiernu xi sahmi Nina. Hacuaha cojo tejó xuta ladu rë me jan cavisecoo xu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Hacuaha cojo sa ngujo yachjin xi cavetju xitsehen xi hincha xahasen rë me hacuaha camandaja me tsëhë chíhin xi má rë me ne, cojo xu me quiji me. María, na xi hacuaha hmí rë na Mágdala, ngu chjuun xi cavetju yatu xitsehen xahasen rë, ");
INSERT INTO maqNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","cojo Juana, chjuun rë Chuza, ngu cha xi sahmixa ndava Herodes, me xi cavitexa ngajan distritu Galilea, cojo Susana cojo jemu cjín sa yachjin xi hacjahi. Yëjë ni yachjin xi cuacun vë ne, cojo xcusun xi tjin rë suvá me ne, cafahacuenda xu me Jesús cojo yëjë ni xuta xi ticojo me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cuitjin camá xu ngu ndiya nga. Hya xi jemu cjín xuta camatangun me xi canduva nguehe canduva ngajan me jingu sa nandya xi nduva tjengui xu me Jesús ne, cachja Jesús cojo xuta jan ngu ejemplu vihi: ");
INSERT INTO maqNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―‍Cuejñaa ne xi ngu cha xi tsitjë trigu matsejen ne, cavetju cha quiji cha xi tsitjë cha trigu. Hane jinguyëjë rë xi titsitjë cha matsejen ne, ngujo matsejen ne, cavixu ndiya, hane canune rë. Hane xi canduva chu nisë matsejen ne, catsicjë chu cajinë chu. ");
INSERT INTO maqNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hane ngujo nga matsejen ne, cavixu hiscan xi jemu naxindya. Hane xi cavetsihin tijima yehe ne, caxintsen matsejen ta, tsëhë xi tsajin mé xcuen rë. ");
INSERT INTO maqNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hane ngujo nga matsejen ne, cavixu ngajñi nahyá. Hane xi camachatangun matsejen ne, nahyá jan matsejen ne, vëhë casahmi hndë rë catsixi rë. ");
INSERT INTO maqNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Hane xi yahnga nga matsejen ne, cavixu hiscan nihndë ndaja. Hane xi camayehe matsejen ne, casua tutjë́ rë, ngu cientu sa cuatjin sacuatjin xi camatjë́. Xi cafë cachja me cjua vëhë ne, sehe jercu hñu xu cachja me cuitjin: ―‍Yo ngayun xi tjin nuju cjuasua xi cuinuhyun cjua naha ne, ndaja tinuhyun. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ngajan xi xuta ladu rë me jan ne, cavinenguise xu me mé meje cuichja ejemplu xi cachja Jesús jan. ");
INSERT INTO maqNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hane Jesús ne, cachja xu me cuitjin: ―‍Nina ne, casua me cahndë́ xi ngayun ne, cuijne rcun cjuatacun tsëhë gubiernu xi sahmi Nina, cjuatacun xi titjún ne, tsajin yo machaya rë. Peru yëjë sa me xi yahnga ne, tichjá cojo rë me cojo suvá ejemplu, cojo sa xi handasa cuihndë me cjua naha ne, peru cuijnii rcu me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Quihndë ne, nguehe cuichjá cojo nuju mé meje cuichja ejemplu vëhë. Trigu xi tsitjë ngu cha jan ne, vëhë xi sacuaha cjua rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Hane hya xi vixu ngujo trigu ndiya ne, hacui sacuaha hya xi visiñuju xuta cjua rë Nina. Sehe vinduva Satanás ne, fahatahá cjua rë Nina tsëhë xahasen rë me, cojo sa xi cuetjintjiin me ngatsë rë xi cumacjain rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Hane hya xi vixu ngujo trigu hiscan xi jemu naxindya ne, hacui sacuaha hya xi vihndë xuta cjua rë Nina, hane fahatsja me cojo cjuasua. Peru trigu xi cuacun vë ne, jemu chúva tyjama rë vetju. Hacuanitjin ni vatju ngujo xuta má. Macjain rë me ngujo nixtin ni, peru hya xi vechú ngunixtin xi chjaháchuva rë me ne, fi ngaxtun me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hane hya xi vixu ngujo trigu ngajñi nahyá ne, hacui sacuaha hya xi vihndë xuta cjua rë Nina, peru ha xcun xi ha cjuinduju me cojo nixtin rë me ne, tsingataha cacun me tsëhë cjuacjintacun tsëhë cahntsua ndava me, tsingataha cacun me tsëhë cjuanchina, hacuaha tsingataha cacun me tsëhë cjuasua xi tjin ngasunhndë, hane vëhë suaain cahndë́ xi cumajyë cjua rë Nina cahntsua xahasen rë me, hacuaha sahmii me ngu cjuandaja xi tsingacun xi xuta rë Nina me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hane hya xi vixu yahnga trigu hiscan nihndë ndaja ne, hacuaha hacui sacuaha hya xi vihndë xuta cjua rë Nina cojo ngu xahasen ndaja, ngu xahasen tyjahi, hacuaha tsismicacuaain me. Hane cuatjin cojo jeya ne, caa rë me sahmi me cjuandaja. ");
INSERT INTO maqNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Hacuaha tsajin hisca xi ngu xuta xi ha xcun xi ha cavetaha rë me ngu ndihi ne, sehe faha me veyahma me ngahma rë ngu tyucu o sá xi faha me vejña me ngahma nachan ta, hatuxa faha me vejña me cahndë́ rë, cojo sa xi yëjë xuta xi visehen me hiscan setí ndihi jan ne, scuëë me hasen rë. ");
INSERT INTO maqNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hacuanitjin ni chuva vëhë, yëjë cjua rë Nina xi tivicuyá nuju suvun ni ngayun xuta ladu naha ne, handasa hinchahma yëjë cjua vëhë quihndë ne, peru cuechú nixtin xi cuetjucaa tsejen, hacuaha cuicuyun rë yëjë xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Vëhë xi meje rë xi nihñu ngahñu xi ndaja cuisiñuju cjua rë Nina ta, tsëhë xi tu yo ni xi tjin rë cjua vëhë ne, Nina ne, sua sa rë me. Hane tu yo ni xi tsajin rë cjua vëhë ne, hitsë cjua vëhë xi má rë xi tjin rë ne, chjahátahá rë. ―‍Cuatjin xu cavicuya Jesús xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngajan xi naa rë Jesús cojo xicjin me ne, cafehetjengui xu me Jesús. Hane maji vechútahacjin rë me ta, tsëhë xi jercu quitsë camaha xu ni xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hane tjin xu yo casua camachaya rë Jesús cuitjin: ―‍Naa nuju cojo nixti xingun ne, hinchacun me ngajan candatsen, xi nduvatjengui nuju me. ―‍Cuatjin xu casacu camachaya rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Peru Jesús ne, cuitjin xu cafayangui me: ―‍Xuta xi vihndë me cjua rë Nina hacuaha sahmi me sacuatjin chja cjua vëhë ne, hacuaha tangun ni hmú cácun me sacuatjin hmú cácun naa naha cojo xingueen. ―‍Cuatjin xu cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cuitjin camá nga xu ngu nixtin jan. Cavisehen Jesús cahntsua ngu barcu cojo xuta ladu rë me, sehe cachja xu me cojo xuta jan cuitjin: ―‍Cuanguen ngunda vëhë. ―‍Cuatjin xu cachja me. Sehe quiji me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hane ngajñi cjui xu barcu cojo rë me ne, Jesús ne, cafañafë xu me. Hya xi camá ne, canduva ngu tjo hñu xi jercu tu cjuachan camahani vanga xcun laguna jan. Hane barcu jan ne, jercu tivisehen xu nandá cahntsua, hane me xi cuacun jan ne, jemu tsavi camahani xi cuma rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hane xi quiji tiña xu me hiscan jiñafë Jesús ne, sehe catsingasca me me, cuitjin xu cachja me: ―‍¡Tatá, tatá! ¡Nguehe tifë ngayaan! ―‍Cuatjin xu cachja xuta ladu rë Jesús jan. Hane xi cavasca xu rë Jesús ne, cavatëcja me ngahñu rë tjo jan cojo cjuasca rë nandá jan. Sehe casejyu tjo casejyu nandá, jemu ndaja cavéjñajyuu jingujyë ni. ");
INSERT INTO maqNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo xuta ladu rë me jan: ―‍¿Há manguaaintacún cojo ná ni? ―‍Cuatjin xu cachja me. Hane xi catsacjun xuta jan camá ne, jemu quijircun rë me. Sehe cachja xu me ngajñi rë me cojo xicjin me cuitjin: ―‍¡Mé xcusun xuta me vi xi hisca tjo hisca nandá vitexa me, hacuaha vihndë tsëhë me ni! ―‍Cuatjin xu cachja xuta ladu rë me jan. ");
INSERT INTO maqNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hya xi camá xu ne, cafehe me nandya Gadara, ngu nandya xi tacun ngunda vëhë tsëhë laguna Galilea. ");
INSERT INTO maqNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Hane xi cafehe xu Jesús nangui quixí cojo xuta ladu rë me ne, cavechútáha me ngu cha tsëhë nandya vëhë xi hincha xitsehen xahasen rë cha. Cha vëhë ne, ha jemu tsëë xu xi vajin cha tsjian, hacuaha hacuiin cahntsua ndihya véjña cha ta ngajan tahndë véjña cha. ");
INSERT INTO maqNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Xi cavëë xu cha Jesús ne, jercu cajindaya cha quiji caticjaxcun cha xcun me, hacuaha jercu hñu cachja cha cuitjin: ―‍¿Mé má cuatjin ninguisuhunjñu cojo ná ngayun Jesús, Quihndi rë Nina xi hatuxa jyë hnga cojo Hasen rë? Nihñu favor ne, xicatuun ná cjuañihi. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Cuatjin cachja cha ta, tsëhë xi Jesús ne, ha cavitexa me xitsehen xi cuetjuxin tsëhë cha. Ha jemu tsëë xu nduva nixtin xi visehen xitsehen xahasen rë cha. Hane xuta ne, tsihñu tsja tsihñu ntsacu me cha cojo cadena cojo sa xi ha quihndë cuetjiin cha cjue cha. Peru xi vicheya cha cadena ne, xitsehen ne, ficojo cjuachan rë cha ngajan ngu xín camahani tsëhë nandya. Jemu cjín ndiya xu xi cavatju cha camá cuatjin. ");
INSERT INTO maqNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ngajan xi Jesús ne, cuitjin xu cavinenguise me cha: ―‍¿Hacutjin hmí nuju? ―‍Cuatjin xu cachja me. Hane cha vëhë ne, cuitjin cafayangui cha: ―‍Sindadu Cjín. ―‍Cuatjin xu cachja cha. Cuatjin cachja cha ta, tsëhë xi jemu cjín xitsehen cavisehen xahasen rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hane ngajan xi xitsehen xi cuacun jan ne, jemu cafehya xu favor cojo Jesús xi hacuiin cuitexa me xi cjue ngajan nduchin. ");
INSERT INTO maqNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hane tiña ngajan ne, jemu cjín xu chinga hinchataha chu tijinë chu ngajan ngu ndetjún. Hane xitsehen jan ne, cafehya cojo Jesús xi sua me cahndë́ xi cuisehen xitsehen jan xahasen rë chinga. Hane casua xu me cahndë́. ");
INSERT INTO maqNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hane xi cavetju xu xitsehen jan tsëhë xahasen rë cha vëhë ne, quiji cavisehen xahasen rë chinga. Hya xi camá xu ne, chinga jan ne, cavanga chu quijijne chu tsëhë rcu ndetjún, hane ngajan cavixuya xu chu ngajñi nandá tsëhë laguna, hane ngajan camiji rë chu nandá ne, ngajan cafë xu chu. ");
INSERT INTO maqNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ngajan xi xi cavëë xu cha xi sahmi cuidadu rë chu chinga jan xcusun xi camá ne, cavanga cha quiji casua cha camachaya rë nandya cojo ranchun xcusun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hya xi camá ne, xuta jan ne, cavetju xu me quiji cavutsejen me xcusun xi camá jan. Hane xi cavechútáha me Jesús ne, hacuaha cavëë me cha xi cavetju xitsehen xahasen rë jan, yaja xu cha ngu tsjian, hacuaha ha cavéjña chihin cjuatacun rë cha, tacun cha tiña ntsacu Jesús. Hane xuta jan ne, jemu catsacjun me camá. ");
INSERT INTO maqNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hane xuta xi cavëë xu xcusun xi camá jan ne, casuacuenda me cojo xuta xi yahnga jan hacutjin camá xi camandaja cha xi caxincha xitsehen xahasen rë jan. ");
INSERT INTO maqNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hya xi camá ne, yëjë xuta tsëhë ladu tsëhë nandya Gadara ne, cafehya xu me cojo Jesús xi cuetjuxin Jesús tsëhë xuta xi cuacun jan ta, tsëhë xi jemu catsacjun camaha ni yëjë me camá. Hane ngajan xi Jesús cojo xuta ladu rë me ne, cavisehen xu me barcu sehe cavuya nga me ngunda vihi. ");
INSERT INTO maqNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hane chaja sa xi cjue Jesús ne, cha xi cavetju xitsehen xahasen rë jan ne, cafehya cha cojo rë me xi cjue cha cojo rë me. Peru Jesús ne, catsinguijnetaha xu me cjua cojo rë cha, cachja me cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―‍Tuyun tjangun ndya nuju ne, hacuaha tinújun cojo xuta tsëhë cjuandaja xi cuacun casahmi Nina cojo nuju. ―‍Cuatjin xu cachja Jesús. Ngajan xi xi cavuya cafehe xu cha nandya ne, sehe cavetsihin catsujyihiya casuacuenda cha xuta jingujyë ni ngajñi nandya yëjë ni cjuandaja xi cuacun casahmi Jesús cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hya xi cavuya Jesús ngunda vihi ne, yëjë ni xutacjín jan ne, jemu ndaja cafahatsja xu me Jesús ta, tsëhë xi hatuxa siuya me me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hane hora vëhë ne, canduva xu ngu me xi hmí rë Jairo, me xi má xutaxa rë yungun. Hane quiji caticjaxcun xu me xcun Jesús. Hane cafehya me favor cojo Jesús xi cjue Jesús ndava me ta, ");
INSERT INTO maqNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tsëhë xi me vëhë ne, tjin xu rë me ngu na lihndi xi quihndi ngu tsëhë me. Hane na lihndi vë ne, sacuaha tejó na nu. Hane meje cueya xu na. Ngajan xi Jesús ne, quiji xu me. Hane ngajñi cjui me ne, jemu tivehnchun xu xuta me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hane ngu na jan ne, tjin rë tejó nu xi yaha rë na chíhin xahmajni. Hane cafë tujún rë na cavechji na xcun doctor. Peru tsajin xu yo camá cafahaxin chíhin xi má rë na. ");
INSERT INTO maqNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hane xi quiji tiña na táha ngaxtun Jesús ne, quiji na casatëtsja na ntsacu tsjian rë me. Hya xi camá xu ne, ha tu ñahñu cavasen xi vanga rë na jni. ");
INSERT INTO maqNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ngajan xi Jesús ne, cachja xu me cuitjin: ―‍¿Yo xi casatëtsja ná? ―‍Cuatjin xu cachja me. Hane xi cachja yëjë xuta xi hacuiin me casatëtsja me ne, sehe cachja xu Pedru cuitjin: ―‍Tatá, xutacjín ne, tivehnchun nuju me, hacuaha hisca titsivaha nuju me. ―‍Cuatjin xu cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Peru Jesús ne, cachja nga xu me cuitjin: ―‍Peru tjin yo xi casatëtsja ná ta ngahan ne, camachaya ná xi cavetju ná hitsë ngahñu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hane xi vutsejen na xi cumaji seyahma na ngajñi rë xuta ne, ña fatsë xu na quiji caticjaxcun na xcun Jesús. Sehe catsinguixi na xcun yëjë ni xuta mé má cuatjin quiji na casatëtsja na Jesús, cojo tsëhë xi ngutjen ni camandaja na. ");
INSERT INTO maqNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sehe ngajan xi Jesús ne, cuitjin cachja xu me cojo rë na: ―‍Ngayun tsan ne, camandaja ngayun ta, tsëhë xi camangutacún cojo ná. Cuma cuangun cojo cjuasua. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tu tichja cuaha xu Jesús cojo na xi camandaja jan ne, cafehe nga ngu me xi canduva me tsëhë ndava xutaxa rë yungun jan, hane cuitjin xu cachja me cojo xutaxa rë jan: ―‍Quihndi nuju ne, ha cahme na. Ha quihndë xicatuhunndyuun rë maestru. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hane hya xi cahndë Jesús cjua vëhë ne, sehe cachja xu me cojo xutaxa rë jan cuitjin: ―‍Xicarcuun. Catamangutacún ni cojo ná ne, quihndi nuju ne, cumandaja na. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hya xi camá xu ne, xi cafehe Jesús ndava xutaxa rë yungun jan ne, casuaain me cahndë́ xi cojo jingu sa xuta cuisehen me. Suvá ni Jesús cojo Pedru cojo Juan cojo Jacobo cojo naa cojo nahmi rë nima lihndi jan cuisehen me cahntsua ndihya. ");
INSERT INTO maqNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hane yëjë ni xuta ne, hisca chja hisca jihnda xu me tsëhë nima jan. Ngajan xi Jesús ne, cuitjin xu cachja me cojo xuta jan: ―‍Ha quihndë xicachjihnduun. Na lihndi vë ne, hacuiin cahme na ta jiñafë na. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Peru xuta jan ne, tu cavejnucëë xu me Jesús ta, tsëhë xi vëëndaja me xi cahme jain nima. ");
INSERT INTO maqNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hane xi cavisehen Jesús hiscan jiña nima lihndi jan ne, sehe quiji me cafaha me tsja, sehe ndaja hñu cachja xu me cuitjin: ―‍¡Tisatjinhngue, tsan! ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hya xi camá xu ne, cavuya hasen rë nima, sehe ngutjen ni cavisatjenhnga na. Hane sehe cavitexa xu Jesús xi sua xuta rë na lihndi jan niñu sinë na. ");
INSERT INTO maqNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Hya xi camá xu ne, xutacha rë na lihndi jan ne, jemu quijircun rë me. Ngajan xi Jesús ne, cachja xu me cojo xutacha rë na lihndi jan xi tsajin camahani yo cuichja me cojo xcusun xi camá. ");
INSERT INTO maqNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Cavechú ngu nixtin xi casahmitangun xu Jesús xuta ladu rë me xi tejó jan ne, sehe casua rë me ngahñu hacuaha casua rë me xá xi me xi cuacun vëhë cuitexa xu me yëjë xitsehen hacuaha sahmi me xi xuta hmu rë ne, cuma ndaja xu me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hya xi camá xu ne, sehe catsingatju Jesús me xi sua me cumachaya rë xuta tsëhë gubiernu xi sahmi Nina hacuaha sahmi xuta xi cuacun vë xi xuta hmu rë ne, cuma ndaja xu me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hane cuitjin xu cachja Jesús cojo rë me: ―‍Xi cuetjun cuangun ne, tsajin camahani mé xi chuhun, hacuiin bastón ne, hacuiin changa, hacuiin niñu, hacuiin tujún, hacuaha hacuiin jo tsjian ngahma chuhun jima ngu ngayun. ");
INSERT INTO maqNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hacuaha xi cjuhun ngu ndihya ne, ha ngajan ni tinechun nguixun nguixun ni, hisca xi cuetjunxun tsëhë nandya vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hya xi xuta tsëhë ngu nandya cjuahatsjaain nuju me ne, xi cuetjun tsëhë nandya vëhë ne, titsunu chojo rë ntsacun cojo sa xi cuma tsejen xi xuta jan cún rë me. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sehe ngajan xi cavetju xu xuta ladu rë Jesús jan, quiji catsujyihiya me yëjë ni nandya tsëhë distritu Galilea, casua me camachaya rë xuta tsëhë cjuandajyihi xi chja tsëhë gubiernu xi sahmi Nina hacuaha casahmi me xi xuta hmu rë ne, camandaja xu me jingujyë ni ladu vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hane Herodes, me xi cavitexa ngajan distritu Galilea ne, camachaya xu rë me yëjë xá xi tisahmi Jesús cojo xuta ladu rë me. Hane ngu cachajá xu cjuatacun rë me ta, tsëhë xi ngujo xuta ne, chja me ta Jesús ne, hacui nima Juan Vitenda rë Xuta, hacuaha handasa cahme xu nima Juan vë ne, peru cavuya cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ngujo nga me ne, chja me ta profeta Elías xi cavuya, hane yahnga nga me ne, chja xu me ta ngu nima profeta xi hacjahi, xi cavéjña hatsëë nixtin ne, handasa cahme ne, peru cavuya cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Peru Herodes ne, catsingataha cacun xu me cuitjin: “Nima Juan ne, ha cavitéxa xi catisun rcu. Peru quihndë ¿yo rë cha xi cuajyihi vë xi jemu cjín cjua nuhya rë tsëhë cha?” Cuatjin xu catsingataha cacun me. Jemu casahmi xu me ngujyë xi scuëë me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Hane xi cavuya xu apóstol tsëhë hiscan xi quiji me jan ne, sehe casuacuenda xu me Jesús xcusun xi casahmi me. Ngajan xi Jesús ne, quijicojo xu me suvá ni apóstol jan ngu cahndë xín, tiña tsëhë ngu nandya xi hmí Betsaida. ");
INSERT INTO maqNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Peru xi camachaya rë xutacjín jan ne, quijitjengui xu me Jesús. Hane Jesús ne, jemu ndaja cafahatsja me xuta jan, hane sehe cachja me cojo xuta jan tsëhë gubiernu xi sahmi Nina. Hane xuta xi meje rë xi cuma ndaja me ne, casahmi xu Jesús xi camandaja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hane xi quiji hora jan ne, xuta ladu rë Jesús xi tejó jan ne, quijivaha me xcun Jesús sehe cachja xu me cojo cuitjin: ―‍Tinújun cojo xutacjín vë ne, catji me nandya xi siu tiñataha o sá xi ranchun xi siu tiñataha, cojo sa xi cuanguise me cahndë́ xi cuiyuju me hacuaha cuanguise me xi sinë me ta, tsëhë xi jemu xín tsëhë nandya hiscan xi nechantahan vi. ―‍Cuatjin xu cachja apóstol. ");
INSERT INTO maqNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngajan xi Jesús ne, cuitjin xu cachja me cojo apóstol jan: ―‍Ngayun tuhun xi sinë me. ―‍Cuatjin xu cachja me. Ngajan xi apóstol ne, cafayangui xu me cuitjin: ―‍Hñú tutu pan cojo jo ti tjin naja. ¿Há cuanguin chíhin niñu xi sinë yëjë xuta xi cuicun vi ni? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cuatjin cachja me ta, tsëhë xi ngajñi rë yëjë xuta xi siutahá jan ne, sacuaha hñú mil má xuta xi xihin. Sehe ngajan xi cachja xu Jesús cojo xuta ladu rë me jan cuitjin: ―‍Tinújun cojo rë xuta vë ne, catiyuju me sacuaha yachantë me ngu ngu cahndë́. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ngajan xi xuta ladu rë Jesús jan ne, cuatjin casahmi me, hane caviyuju xu yëjë xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Hya xi camá ne, cafaha xu Jesús hñú pan cojo jo ti jan ne, hane xi cavutsejenniji me ngahnga ne, casua me nacuechji rë Nina, sehe cavotoho langa me pan hacuaha cavatëlanga me ti jan, sehe casua xu me cojo xuta ladu rë me xi cjue sua rë me xutacjín jan. ");
INSERT INTO maqNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Hane xuta ne, yëjë ni me cajinë me hacutjin xi cachuya rë xahasen rë me. Hane xi cachjaya rë xi cavangui cajinë xuta jan ne, catsë xu tejó chajne. ");
INSERT INTO maqNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cuitjin camá nga ngundiya. Hya xi tisahmi xu Jesús oración rë me ne, xuta ladu rë me ne, hacuaha cojo me siu me cojo rë me. Sehe ngajan xi cavinenguise xu Jesús me cuitjin: ―‍¿Mé chja xutacjín jan ne, yo ngahan? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sehe ngajan xi cachja xu me cojo Jesús cuitjin: ―‍Yahnga me ne, chja me ta Juan Vitenda rë Xuta ngayun. Hane yahnga nga me ne, chja me ta profeta Elías ngayun. Hane me xi yahnga nga ne, chja me ta ngayun ne, ngu profeta xi hacjahi, xi cavéjña hatsëë nixtin, xi handasa cahme ne, peru cavuya cjuahñu. ―‍Cuatjin xu cachja xuta ladu rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sehe Jesús ne, cuitjin xu cavinenguise nga me: ―‍Hane ngayun ne, ¿mé nújun ni, yo ngahan? ―‍Cuatjin xu cavinenguise Jesús. Ngajan xi Pedru ne, cuitjin xu cafayangui me: ―‍Ngayun xi catsingatju nuju Nina xi cumatitjun ngayun tsijin. ―‍Cuatjin xu cafayangui Pedru. ");
INSERT INTO maqNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Peru Jesús ne, cavitexa xu me xuta jan xi tsajin camahani yo xi cuichja cojo me cjuatacun jan. ");
INSERT INTO maqNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Cuitjin xu cachja me: ―‍Ngahan xi Quihndi rë Xuta Jain ngahan ne, hachu meje rë xi jemu cjín cjuañihi cuátju cuma; xuta changá cojo nahmi xi matitjun tsëhë nahmi cojo cha xi vicuya cjuachacun ne, tsitjungui me ngahan, tsiquehen me ngahan. Peru xi ma jyan nixtin ne, tsicuya Nina ngahan cjuahñu. ―‍Cuatjin xu cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hane sehe cavuya cachja nga me cojo yëjë ni xuta jan cuitjin: ―‍Sá xi tjin yo xi meje rë xi cuma xuta ladu naha matsejen ne, ha quihndë mijí rë xi sahmi hacutjin xi meje rë suvá matsejen ta nchunchujun ni matsejen ne, catejñahñu xahasen rë xi cjuecojo ndiya naha, handasa hisca cueya xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Cuatjin matsejen ta, tsëhë xi yo xi meje cjuenduju cojo ngasunhndë rë cojo cjuatacun rë suvá matsejen ne, cuechintaain cjuahñu xatsë. Peru yo xi cuatju cjuañihi o hisca cueya ngatsë naha matsejen ne, vëhë xi cuechútáha cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Mé machjirëhë rë yo xi sacú rë yëjë cjuanchina rë ngasunhndë sá xi cueya hacuaha cuma castigu? ");
INSERT INTO maqNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Machjiriin matsejen ta, tsëhë xi yo xi ma sava rë ngatsë naha cojo ngatsë rë cjua naha matsejen ne, ngahan xi Quihndi rë Xuta Jain ngahan matsejen ne, hacuaha cuma sava ná tsëhë hya xi cuinduva cojo hasen ndajyihi naha hacuaha tsëhë Nahmi naha hacuaha tsëhë ángel xi vejña tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nguehe cuichjá cojo nuju cjuaquixi matsejen ta tjin yahnga ngayun xi sechun nguehe xi cueyuun jinguyëjë rë xi cjëë chun gubiernu xi sahmi Nina. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Cuitjin camá nga xu ngundiya hya xi cavatju sacuaha jyin nixtin xi cavicuya Jesús cjua vëhë. Quijicojo me Pedru cojo Juan cojo Jacobo quijiniji xu me ngu ndetjún xi sahmi me oración rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hora xi tisahmi xu Jesús oración rë me ne, xcun me ne, cavindeya xcusun rë. Hane tsjian rë me ne, jercu tu tyava camahani camá, ña setí jyihi. ");
INSERT INTO maqNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hacuaha camatsejen xu jo xihin hinchacun visiajmi cojo rë me. Xihin jan ne, hacui xu nima profeta Moisés cojo profeta Elías. ");
INSERT INTO maqNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Me xi cuacun vëhë ne, camatsejen me cojo ngu hasen ndajyihi, tivisiajmi xu me tsëhë cjuaveya xi hatuxa tjin rë xi cuechútáha Jesús ngajan Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peru Pedru cojo jo sa me xi yahnga jan ne, ha siufë me, tsëhë xi jercu nijñá rë me. Peru xi cavascandaja xu rë me ne, cavëë me hacutjin jercu setí camahani tsejen hiscan secun Jesús, hacuaha cavëë xu me jo me jan hinchacuntangun me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hya xi camá ne, hora xi tivetjuxin me xi cuacun vë tsëhë Jesús ne, sehe cachja xu Pedru cojo Jesús cuitjin: ―‍Tatá. Tu ma rë xi nguehe nechin ne, nihñi jyan puestu; ngu cuma tsujun ne, ngu cuma tsëhë Moisés, hane cojo ngu cuma tsëhë Elías. ―‍Cuatjin xu cachja Pedru, peru hisca hvíin me mé xi chja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hane hora xi tichja xu Pedru cuatjin ne, canduva ngu yufí casahmi tjahnguen rë tsëhë me. Hane jemu catsacjun me camá xi caxinchavasen me tsëhë yufí jan. ");
INSERT INTO maqNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hya xi camá ne, canuhya xu rë ngujo cjua xi cavetju ngajñi yufí jan xi cachja cuitjin: ―‍Cha vihi xi Quihndi naha cha, cha xi ngahan cavejñá cácun xi tsingátju. Tinuhyun cjua xi chja cha. ―‍Cuatjin xu cachja cjua jan. ");
INSERT INTO maqNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hane xi cavatju cachja cjua jan ne, Jesús ne, camasuvá sa me secun me. Hya xi camá xu ne, jyan xuta ladu rë Jesús jan ne, tu caviyujujyuu ni me. Hane nixtin hya ne, cachjaain camaha xu ni me cojo hisca ngu tsëhë xcusun xi cavëë me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cuitjin camá nga xu camá nchujun hya xi canduvajne Jesús tsëhë ndetjún cojo jyan xuta ladu rë me jan. Tjercu cjín camahani xuta canduvatjengui xu rë me ndiya. ");
INSERT INTO maqNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hane ngajñi rë xutacjín jan ne, cavetjujñi ngu xihin xi jercu cajindaya xu cachja cojo Jesús cuitjin: ―‍Maestro, nihñu favor ne, nduvun chutsujun cha lihndi naha ta ngu tutu má cha vi xi tacun ná cha. ");
INSERT INTO maqNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hane cuitjin sahmi ngu xitsehen cojo rë cha: faha rë cha, hane tu ñahñu jindaya, sehe vitsuneya rë cha, ña vetju natyaxu hntsua cha, hane hisca hya xi ndiya cjuë cha ne, sehe vetjuxin tsëhë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xuta ladu nuju, caféhya rë me favor xi cuaxëxin me, peru camaji cavaxëxin me. ―‍Cuatjin xu cachja xihin jan cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sehe ngajan xi Jesús ne, cuitjin xu cafayangui me: ―‍Ngayujun ni ne, xuta xi macjaain rë ngayun hacuaha xuta xi cavetjuxin tsëhë ndiya ndajyihi ngayun. ¿Jani hisca hya xi tjin ná xi cuitejña cojo nuju? ¿Jani hisca hya xi tjin ná xi scaa ná cojo nuju? Nduvuncujun quihndi nuju nguehe. ―‍Cuatjin xu cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hane hora xi tijima tiña xu cha lihndi jan tsëhë Jesús ne, xitsehen ne, catsiticja rë cha, hacuaha vitsuneya rë cha. Hya xi camá ne, cavatëcja Jesús tsëhë xitsehen, hane casahmi me xi camandaja xu cha lihndi jan. Sehe casua me cha cojo nahmi rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hane yëjë ni xuta jan ne, jemu quijircun camaha xu ni rë me xi cuatjin jyë hnga Nina cojo Hasen rë me. Hane jinguyëjë rë xi cuatjin tifircun rë xutacjín jan tsëhë yëjë ni xcusun xi sahmi Jesús ne, cachja xu me cojo xuta ladu rë me cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―‍Ndaja tetuhunrcun cjua xi tichjá cojo nuju vi: Ngahan xi Quihndi rë Xuta Jain ngahan ne, hatuxa tjin xi cuma ngahan entregadu tsja xuta. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Peru xuta ladu rë Jesús jan ne, cavijnii rcu me mé vijne cjua jan ta, tsëhë xi casetsa xu rë cjuatacun rë me, cojo sa xi cuijnii rcu me. Hacuaha tsacjun xu me xi cjuinenguise me Jesús mé vijne cjua vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ngu nixtin jan ne, cavetsihin sacuaha xi meje scaanya xu xuta ladu rë Jesús ngajñi rë me yo xi hitsë sa matitjun. ");
INSERT INTO maqNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Peru Jesús ne, xi ha vëë me hacutjin tsingataha cacun xuta ladu rë me jan ne, sehe cafaha me ngu lihndi cavisecun me ndaya rë me, ");
INSERT INTO maqNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","sehe cachja xu me cojo xuta ladu rë me jan cuitjin: ―‍Tu yo ni xi cjuahatsja rë lihndi vihi tsëhë xi ladu naha má ne, hacuaha hora vëhë cjuahatsja ná ngahan. Hacuaha xi cuatjin cjuahatsja ná ngahan ne, hacuaha cjuahatsja rë Nina xi catsingatju ná. Hane tu yo ni xi má nuju xi ma tjengui tsëhë ngajñi nuju ngayujun ni ne, vëhë xi matitjun xi má rë Nina. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ngajan xi Juan ne, cachja xu me cojo Jesús cuitjin: ―‍Tatá, cahyin ngu me xi tivaxëxin xitsehen sacuaha xi suvun catuhun rë me xá. Hane canújin cojo rë me xi ha quihndë sahmii me cuatjin ta, tsëhë xi me vëhë ne, tsujyihintjenguiin me ngayun sacuatjin niji ngayin. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Hane Jesús ne, cuitjin xu cafayangui me: ―‍Xicanujuun cojo rë me cuatjin ta, tsëhë xi xuta xi hacuiin condra naja má me ne, hatuxa favor naja fi me. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hya xi camá ne, xi tijima tiña xu nixtin xi cjueniji Jesús ngajan ngahnga ne, cavejñahñu me cjuatacun rë me xi cjue me ngajan Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Vëhë xi catsingatju titjun xu me jo xuta ladu rë me. Xi quiji me ne, cafehe me ngu nandya tsëhë xuta Samaria, xi cuanguise me cahndë́ xi cuejña Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Peru xuta jan ne, cafahatsjaain xu me Jesús ta, tsëhë xi Jesús ne, hatuxa tjin cacun me xi cjue me hisca Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Peru hya xi camachaya xu rë Jacobo cojo Juan, xuta ladu rë Jesús, cjua vëhë ne, cachja xu me cojo Jesús cuitjin: ―‍Tatá. ¿Há nihña sacuatjin casahmi profeta Elías hatsëë nixtin? ¿Há cuitexan xi cuinduva ndihi tsëhë ngahnga, tsicjë rë xuta xi cuicun vi? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ngajan xi Jesús ne, cavuya vutsejen me xuta ladu rë me jan ne, sehe cavatëcja xu me cjuatacun xi tsingataha cacun me xi cuacun jan, cuitjin cachja me: ―‍Ngayun ne, hyúun mé xcusun Hasen xi tsëhë nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ngahan xi Quihndi rë Xuta Jain ngahan ne, hacuiin canduvá xi tsicjë́ xuta ta xi canduvá ne, xi cuáxëtjë me. ―‍Cuatjin xu cachja Jesús. Sehe quiji xu me ngu nga nandya. ");
INSERT INTO maqNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hane ndiya cjui Jesús cojo xuta ladu rë me ne, cachja xu ngu me jan cojo rë me cuitjin: ―‍Tatá. Tu yani ni xi cuangun ne, cjuë́ cojo nuju. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo xuta jan: ―‍Chu ninda ne, tjin nguijo hiscan viyuju chu, hane nisë xi vitjen chu ngahnga ne, tjin ndava chu, peru ngahan xi Quihndi rë Xuta Jain ngahan ne, hisca ndya naha tsajin. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Cachja sa xu me cuitjin cojo ngu nga xuta jan: ―‍Nduvun, cuanguen cojo ná. ―‍Cuatjin xu cachja me. Peru xuta jan ne, cuitjin xu cachja me: ―‍Tatá. Tuhun ná cahndë́, titjun cjuë́ xi seyaniji nahmi naha. ―‍Cuatjin xu cachja ngu nga xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ngajan xi Jesús ne, cuitjin xu cachja me: ―‍Xuta xi sacuaha xi cahme cjuatacun rë me xi sahmicuendaain me Nina ne, me vëhë catinchaniji me nima rë me. Peru ngayun ne, tángun tuhun cumachaya rë xuta tsëhë gubiernu xi sahmi Nina. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ngu nga xuta ne, cachja xu me cojo Jesús cuitjin: ―‍Tatá. Ngahan ne, hacuaha cjuë́ cojo nuju. Peru tuhun ná cahndë́, cjuë́ tsinguíjnetaha cjua cojo xuta naha. ―‍Cuatjin xu cachja xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Peru Jesús ne, cuitjin xu cachja me cojo xuta jan: ―‍Ngu xuta xi ha cavejña cacun me xi cjuetjengui me ndiya rë Nina sehe cumangu cumajo cacun me ¿há cjue, há cjuiin me ne?, tangun me cojo ngu cha xi ha cafaha cha ndetsihin latu xi cuetsihin cuacjan cha nangui peru tivutsejen sa cha taha ngaxtun cha. Sacuatjin machjiriin cha vihi xi cuacjan cha nangui ne, hacuanitjin ni machjiriin me vëhë xi cuisecoo me Nina hiscan xi sahmi Nina gubiernu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Xi cavatju xu vëhë ne, sehe casuaxa Nai naja jyanchan tejó sa xuta ladu rë me, sehe catsingatju titjun me chuva jo chuva jo xuta jan yëjë ni nandya cojo yëjë ni cahndë́ xi catsingataha cacun Jesús xi sehe cjue me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hane cuitjin xu cachja me cojo: ―‍Jemu tjin camahani xuta xi meje cuisiñuju me cjua rë Nina, peru me xi sua cumachaya rë xuta ne, jemu chuva má me. Vëhë xi meje rë xi chjahyun rë Nina favor xi tsingatju me me xi cjue sua cumachaya rë xuta cjua rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tángun ni. Ngahan titsingátju nuju ngayun xuta jeya ngajñi rë xuta hnga cacun, sacuaha cjue ngu chu hnditsánga ngajñi rë chu cjan rë. ");
INSERT INTO maqNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Xicachjuun tujún, xicachjuun changa, hacuaha xicachjuun chuxinxtë. Xicavisiajmuu cojo xuta hora xi sacu xingun cojo rë me ndiya. ");
INSERT INTO maqNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Hane tu jarë ni ndihya xi cuisuhun ne, titjun tinújun ngu nina cuitjin: “Nina sua nuju me cjuandaja cjuajeya.” Cuatjin tinújun. ");
INSERT INTO maqNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hane sá xi ndihya vëhë tjin quihndi tsëhë cjuajeya ne, hacuaha sacú rë me cjuajeya. Peru sá xi hacuiin quihndi tsëhë cjuajeya xi siu jan ne, sacuiin rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Hane xi cuisuhun ngu ndihya ne, ha ngajan ni tinechun, xinu siuhun cojo rë me mé xi sua me. Cuatjin nihñu ta, tsëhë xi ngu xuta xi sahmi me xá ne, vechú chuva rë xi sacú chji rë me. Vëhë xi mijí rë xi cuangun nguehe cuangun ngajan cuinechun. ");
INSERT INTO maqNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Hane tu jarë ni nandya xi cuisuhun hiscan xi cjuahatsja nuju xuta ne, xinu xcusun xi sua me xinu, ");
INSERT INTO maqNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","hacuaha nihñu xi xutahmu rë tsëhë nandya jan ne, cumandaja me, hacuaha cuitjin tinújun cojo yëjë xuta: “Ha camatiña nixtin xi cuma nuju xi sahmi Nina gubiernu.” Cuatjin tinújun. ");
INSERT INTO maqNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Hane tu jarë ni nandya xi cuisuhun hiscan xi cjuahatsjaain nuju xuta ne, xi chjuhun ndiya xi cuetjunxun tsëhë nandya vëhë ne, cuitjin tinújun cojo xuta: ");
INSERT INTO maqNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Hisca chojo rë ngajñi nandya nuju xi cavaqui rë ntsacuin ne, cuitsuni cojo sa xi cuma tsejen xi ngayun cún nuju. Peru meje rë xi cuijne rcun xi ha camatiña nixtin xi sahmi Nina gubiernu.” Cuatjin tinújun. ");
INSERT INTO maqNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Cuichjá cojo nuju ta hya xi cuechú nixtin xi tsichuva Nina xuta tsëhë jyë́ rë me ne, hitsë sa jyë castigu cuatju xuta tsëhë nandya xi fahatsjaain nuju, xi cuma rë xuta tsëhë nandya Sodoma xi jercu tu casahmi camahani me cjuatsehen. ");
INSERT INTO maqNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Jemu chojyihi tsëhë xuta nandya Corazín! ¡Hacuaha jemu chojyihi tsëhë xuta nandya Betsaida! Jemu chojyihi tsëhë me ta, tsëhë xi miji tsindeya me cjuatacun rë me, handasa cavëë me cjuarcun xi casahme ngajñi rë me. Xuta nandya Tiro cojo xuta nandya Sidón ne, hisca hacuiin xuta ladu rë Nina má me sacuatjin rë xuta Corazín cojo Betsaida. Peru sá xi xuta Tiro cojo Sidón cavëë me cjuarcun xi cuacun vë ne, ha catsindeya me cjuatacun rë me, hacuaha ha cavajá me tsjian xi sacuaha tsánaxá hacuaha caviyuju me ngajñi ndesu, sacuaha xcusun naja, cojo sa xi cuma tsejen xi jemu choho má jain rë me tsëhë jyë́ rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Vëhë xi hya xi tsichuva Nina yëjë xuta tsëhë jyë́ rë me ne, xuta nandya Tiro cojo xuta nandya Sidón ne, hitsë sa chúva castigu cuatju me cuma xi cuma rë xuta Corazín cojo xuta Betsaida. ");
INSERT INTO maqNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hane xuta nandya Capernaum ne, ¿há cjue me hisca ngahnga hiscan tacun Nina? ¡Hacuiin! Hatuxa cjue me nduchin, cahndë́ hiscan ma hasen rë nima castigu. ");
INSERT INTO maqNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Xuta xi cuihndë me tsujun ne, hacuaha tivihndë me tsahan. Hane xuta xi tsitjungui nuju me ne, hacuaha titsitjungui me ngahan. Hane xuta xi tsitjungui ná me ne, hacuaha titsitjungui me Nina xi catsingatju ná. Cuatjin xu cachja Jesús cojo xuta ladu rë me, sehe cavetju xuta ladu rë me jan quiji me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hya xi camá ne, xi cavuya xu xuta ladu rë Jesús xi jyanchan tejó jan ne, jercu sua rë xahasen rë me. Hane cuitjin xu cachja me cojo Jesús: ―‍¡Tatá! ¡Xi veyinnanguin ñihi nuju hora xi tinihñí xá xi cavitexun niji ne, hisca xitsehen vihndë tsijin! ―‍Cuatjin xu cachja xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo xuta jan: ―‍Jinguyëjë rë xi tivutsején ngahnga hiscan tacun Nina ne, cjanengui Satanás sacuaha camá ni ngu ndihichuhún. Hane cuatjin cahvë xi tichjahátáha rë gubiernu xi sahmi Satanás. ");
INSERT INTO maqNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chutsujun ni, ngahan casuá nuju chuva rë xi tsajin mé cuatjun cuma, handasa nunú chu yë o sá nunú chu naya o sá xi suvá camahani Satanás choho meje sahmi cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hacuiin ndaja cuma nuju tsëhë xi vihndë xitsehen tsujun ta xi meje rë ne, ndaja catama nuju tsëhë xi ha quitaháxujun ñihi nuju ngajan ngahnga. ―‍Cuatjin xu cachja Jesús cojo xuta ladu rë me jan. ");
INSERT INTO maqNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hane ha hora vëhë ni ne, Hasen rë Nina casahmi xi jemu sua camahani camá rë xahasen rë Jesús, sehe cachja xu me cuitjin cojo Nina: ―‍Ngayun nahmi naha ne, sahmejyë sahmehnga nuju cojo Hasen nuju, ngayun xi Nai rë ngahnga cojo nangui ngayun, tsëhë xi ngayun caveyúnhmu cjuatacun vëhë xi cuma rë xuta xi jemu vechú cjuatacun rë, hane catuhun camachaya rë xuta xi hvíin camahani. Ngayun nahmi naha, cuatjin canihñu ta, tsëhë xi cuatjin xi cachuya nuju. ―‍Cuatjin xu cachja Jesús cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Hane xi cojo yëjë ni xuta ne, cuitjin xu cachja me: ―‍Yëjë ngarca ni matsejen ne, Nina Nahmi naha casua ná me. Tsajin hisca ngu xi vëë yo xi Quihndi rë Nina matsejen ta suvá ni Nina Nahmi naha xi vëë me. Hacuaha tsajin hisca xi ngu xi vëë yo xi Nahmi naha matsejen ta suva ni ngahan xi Quihndi rë me ngahan xi hvë, cojo tu yo ni xi ngahan meje suá cumachaya rë. ―‍Cuatjin xu cachja me cojo yëjë xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Cavuya vutsejen nga me hiscan siu xuta ladu rë me ne, sehe cachja xu me cojo suvá ni me xi cuacun vëhë cuitjin: ―‍Jemu ndaja tsujun ngayujun ni xi tichutsujun xcusun xi tijima nixtin vihi. ");
INSERT INTO maqNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nguehe cuichjá cojo nuju ta jemu ndaja tsujun ta, tsëhë xi hacuaha jemu cjín profeta hacuaha jemu cjín xuta xi matitjun xi caviyuju titjún ne, jemu meje scuëë me xcusun xi ngayun tichutsujun, peru casacuiin cavëë me. Hacuaha jemu meje cuisiñuju me cjua xi tivisiñuju ngayun, peru casacuiin cavisiñuju me ta, tsëhë xi cjëë cuma xcusun vëhë nixtin hya. ―‍Cuatjin xu cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ngundiya nga hya xi tacun xu Jesús cojo xuta ne, casecun ngu cha xi vicuya cjuachacun cavinenguise xu cha cuitjin xi cjuahachuva cha me: ―‍Maestro. ¿Mé ndatjin xi sahme cojo sa xi cuéchutáha cjuahñu xatsë xcun Nina? ―‍Cuatjin xu cavinenguise cha me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ngajan xi Jesús ne, cuitjin xu cachja me cojo cha: ―‍¿Hacutjin camahindu xcun ley rë Moisés? ¿Mé xi chutayun jan? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hane xi cafayangui cha ne, cuitjin xu cachja cha: ―‍“Meje rë xi nihmutacún Nina naja cojo nguñajatacún, cojo yëjë xahasen nuju, cojo yëjë ngahñu nuju, cojo yëjë cjuatacun nuju, hacuaha cuatjin nihmutacún xingun sacuatjin hmutacún suvun yojo nuju.” ―‍Cuatjin xu cachjasun cha cjua rë ley. ");
INSERT INTO maqNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Hane cuitjin xu cachja Jesús cojo cha: ―‍Cjuaquixi cjua xi canújun. Cuatjin nihñu, sehe cuechuntuhun cjuahñu xatsë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngajan xi cha xi vicuya cjuachacun jan ne, xi meje tsingacun cha xi jemu quixi cha cojo cjuatacun rë cha ne, cuitjin xu cavinenguise cha cojo Jesús: ―‍¿Yo xi xingueen ni? ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Hane ngajan xi Jesús ne, cojo ngu ejemplu cafayangui xu me tsëhë cha cuitjin: ―‍Cuejña ne xi ngu xuta jan ne, cavetju me tsëhë nandya Jerusalén ne, cjui me nandya Jericó. Hane ndiya cjui me ne, cavechútáha ngujo cha chëjë me. Hane cafahatahá cha yëjë tsëhë me xi yaha me, sehe cavaja cha me. Ña catsiquehenñaja cha me, hane sehe cavanga cha. ");
INSERT INTO maqNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hya xi camá ne, hora vëhë canduva ngu nahmi cavatju me ndiya vëhë, hane xi cavëë me xuma xuta xi casacuhmu rë jan ne, tjehen ndiya ladu xingu cavatju me quiji me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ha chuva vëhë ni ne, cafehe ngu sangrista cahndë́ vëhë. Hane xi cavëë cha xi jiña me xi casacuhmu rë jan ne, cavetahaxin cha hitsë ndiya rë cha sehe cavatju cha quiji cha. ");
INSERT INTO maqNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Peru ngu cha tsëhë distritu Samaria xi quiji cha ndiya vëhë ne, cafehe cha hiscan jiña xutahmu rë jan. Hane xi cavëë cha me ne, jemu camayuma rë cha me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hane xi quijivaha cha xcun me ne, catsirqui cha me, cavitejnu cha aceite cojo xan hiscan casacuhmu rë me sehe catsitjinguiya cha me tsjian. Hya xi camá ne, sehe catsiquijin cha me naxin rë cha, sehe quijicojo cha me ngu ndihya hiscan xi hatuxa ndihya viyuju xuta, hane ngajan casahmi cha me cuidadu. ");
INSERT INTO maqNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hane xi camá nchujun jan ne, cavaxë cha jo denario, tujún xi faha ngu mosu xi sahmixa jo nixtin, sehe casua cha me xi nai rë ndihya jan, sehe cachja cha cojo rë me cuitjin: “Nihñu cjuandaja ne, chjuhuncuendun xuma xutahmu rë vi. Hane xi quisun sa nicujun tsëhë xcun tujún xi suá nuju vi ne, xi cúya ne, sehe cuechjë tsujun.” Cuatjin cachja cha Samaria. ");
INSERT INTO maqNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ngajan xi Jesús ne, xi cuatjin cajnetaha ejemplu xi cachja me ne, sehe cachja xu me cojo cha xi vicuya cjuachacun jan cuitjin: ―‍¿Jarë tsëhë catsijyan xuta xi cuacun vë xi má nuju xi cjuaquixi xi camá xicjin me xi cavanguihmu chëjë jan? ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ngajan xi cha xi vicuya cjuachacun jan ne, cuitjin xu cafayangui cha tsëhë Jesús: ―‍Cha xi ngatsë rë cjuayuma ne, casahmi cjuandaja cojo me xi casacuhmu rë jan. ―‍Cuatjin xu cachja cha. Hane Jesús ne, cuitjin cachja nga xu me cojo cha: ―‍Quihndë xi cuangun ne, hacuaha cuatjin nihñu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Hane xi cjui sa xu Jesús cojo xuta ladu rë me ne, xi cavisehen me ngu nandya jan ne, ngu na xi hmí rë Marta ne, cafahatsja na Jesús ndava na. ");
INSERT INTO maqNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na Marta jan ne, tjin ngu tíchja na xi hmí rë María. Hane na María jan ne, quiji xu na cavéjña na táha ntsacu Jesús, tivisiñuju na cjua xi tivicuya me. ");
INSERT INTO maqNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Peru na Marta ne, jemu cjín xcunya xá xi tisahmi na. Hane xi cavatju na hiscan tacun Jesús ne, cuitjin xu cachja na: ―‍Tatá. ¿Há marcuaain nuju xi na tichja ne, cavejñasuva ná na cojo xá xi tacunvasen tisahme? Tinújun cojo rë na, catisecoo na ngahan. ―‍Cuatjin xu cachja na. ");
INSERT INTO maqNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngajan xi Jesús ne, cuitjin xu cafayangui me tsëhë na: ―‍Marta, jercu marcun nuju tsëhë jemu cjín xcusun. ");
INSERT INTO maqNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Peru ngu xcusun ni xi sahmi ngujyë. Na María ne, cavaxijin na xcusun xi ndaja vë, hane hacuiin chjahátahá rë tsëhë na. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cuitjin camá xu ngundiya hya xi tisahmi Jesús oración rë me ngu cahndë́ jan. Hane xi cajnetaha casahmi me oración rë me ne, ngu xuta ladu rë me jan ne, cuitjin xu cachja me cojo Jesús: ―‍Tatá. Ticuyun niji hacutjin nihñi oración niji, sacuatjin cavicuya Juan xuta ladu rë me. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ngajan xi Jesús ne, cuitjin xu cafayangui me: ―‍Hya xi nihñu oración ne, cuitjin tinújun: Ngayun Nahmi niji, meje niji xi ngayijin ni xuta ngasunhndë chjihinrcuin nuju. Meje niji xi cuinduvun nihñu niji gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nchunchujun ni tuhun niñu xi xiní. ");
INSERT INTO maqNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ninchatuhun niji tsëhë jyë́ xi jemu quitjin ta ngayin suvin ne, hacuaha tininchatihin rë yëjë ni xuta xi quitjen me jyë́ tsijin. Xicatuun cahndë́ xi chjaháchuva niji cojo cjuatacun niji. Cuatjin tinújun. ―‍Cuatjin xu cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Hya xi camá ne, cachja nga xu Jesús ngu ejemplu cojo xuta ladu rë me. Cuitjin xu cachja me: ―‍Cuejña ne xi ngayun tjin nuju ngu xuta xi vinga nuju, hane vasen nixten cuangun ndava me, cuinújun cojo rë me cuitjin: “Amigu, nihñu favor tuhun jyan niñu scuxétaha ta, ");
INSERT INTO maqNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tsëhë xi ngu amigu naha cafehe ndya naha xi cjui me ngu nangui, hane tsajin ná mé xi suá sinë me.” Cuatjin cuinújun cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿Há cjuayangui me tsujun cuitjin tsëhë hisca cahntsua ndihya?: “Xicatuhunndyuun ná ta tingotjo ndihya ne, ha tichjá, hacuaha quihndi naha ne, nguehe siufë cojo ná. Cumaji cuisátjenhnga suá nuju.” ¿Há cuatjin cjuayangui me tsujun? Hacuiin cuatjin. ");
INSERT INTO maqNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Cuichjá cojo nuju ta handasa amigu nuju me, peru hacuiin ngatsë rë vëhë xi cuisatjenhnga me sua nuju me ta ngatsë rë xi ngajan cjui ngajan nduva cuinújun ne, cuisatjenhnga me sua nuju me ha tucutjin xi chjahyun. ");
INSERT INTO maqNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hacuaha cuichjá cojo nuju cuitjin: Chjahyun rë Nina, hane sua nuju me. Tinchunsun, hane sacú nuju. Tinújun, hane Nina ne, sua me cahndë́ cuisuhun. ");
INSERT INTO maqNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Cuatjin nihñu ta, yëjë ni xuta xi fehya me ne, fahatsja me, hane yo xi vanguise ne, sacu rë, hane yo xi chja ne, sacu cahndë́ visehen. ");
INSERT INTO maqNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Tsajin ngu nahmi xi, hya xi quihndi rë me cjuehya ngu niñu ne, cahndë́ rë xi sua me ngu niñu ne, sua me ngu ndyojo, o sá xi hya xi quihndi cjuehya ngu chu ti ne, cahndë́ rë xi sua me ngu chu ti ne, sua me ngu chu yë, ");
INSERT INTO maqNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","o sá xi hya xi quihndi cjuehya ngu chjoo ne, sua me ngu chu naya. ");
INSERT INTO maqNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ngayun xi tsehen cjuatacun nuju ne, ma tuhun rë quihndi nuju xcusun xi ndaja. Hitsë guan Nahmi naja xi tacun me ngahnga ta hitsë sa jercu meje sua me Hasen rë me cojo xuta xi cjuehya rë me. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Cavechú xu ngu nixtin xi cavaxëxin Jesús ngu xitsehen xi casahmi lihmi rë ngu cha jan. Hane hya xi cavetju xitsehen jan ne, cha lihmi jan ne, cavetsihin cachja cha. Hane xutacjín jan ne, jemu quijircun rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hya xi camá ne, ngujo xuta jan ne, cuitjin xu cachja me: ―‍Beelzebú, xitsehen xi matitjun ne, vëhë casua rë cha xá xi vaxëxin cha xitsehen. ―‍Cuatjin xu cachja xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hane ngujo nga xuta ne, xi meje cjuahachuva me Jesús ne, cafehya me me xi sahmi me ngu cjuarcun xi cuinduva ngajan ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Peru Jesús ne, tsëhë xi ha vëë me mé xi tsingataha cacun xuta xi cuacun jan ne, cuitjin xu cachja me: ―‍Hya xi xuta tsëhë ngu nandya ticjan me ngajñi rë me cojo xicjin me ne, nandya vëhë ne, ha tivéjña xahva, hisca ndihya ne, tivixusun xcun xicjin. ");
INSERT INTO maqNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hacuanitjin ni sá xi Satanás scaan cojo xitsehen xi yahnga xi hacuaha Satanás má nai rë ne, tsichajá ngahñu rë xi vëhë matitjun. Cuatjin chjá ta, tsëhë xi nújun xi Beelzebú casua ná xá xi vaxë́xen xitsehen. ");
INSERT INTO maqNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Peru sá xi Beelzebú casua ná xá xi vaxë́xen xitsehen ne, hacuaha ha Beelzebú vëhë casua rë ngu ngu xuta ladu nuju xá xi hacuaha vaxëxin me xitsehen. Vëhë xi ha me vëhë ni cuichja me xi cuaaintjin xi nújun xi Beelzebú casua ná xá. ");
INSERT INTO maqNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Peru sá xi Nina casua ná me xá xi vaxë́xen xitsehen ne, ngajan matsejen xi gubiernu xi sahmi Nina ne, ha tivetsihin. ");
INSERT INTO maqNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Satanás ne, tangun cojo ngu cha xi jemu hñu ngahñu rë. Hya xi ha ndaja tjin chjine cha cojo quicha rë cha xi sahmi cuidadu cha ndava cha ne, yëjë xcusun xi tjin rë cha ne, hacuaha ha ndaja cuidadu tjin. ");
INSERT INTO maqNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Peru ngahan ne, tangun ngahan cojo ngu me xi hitsë sa jemu hñu camahani ngahñu rë. Hya xi me xi hitsë sa hñu ngahñu rë scaan me cojo cha xi hñu ngahñu rë jan hacuaha tsinguijne me cha ne, cjuahatahá me quicha xi vetaha cacun cha xi cuaxëtje rë cha, hane sehe cuatëcja me yëjë xcusun xi tjin rë cha jan ngajñi rë me cojo xicjin me. ");
INSERT INTO maqNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Xuta xi fiin me favor naha ne, condra naha má me. Hane xuta xi visecuaain ná me xi nihñi tangun cjuatacun rë xuta cojo Nina ne, tsinguetsun me cjuatacun rë xuta. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Hya xi camá ne, Jesús ne, quijinduju sa xu cachja me cuitjin: ―‍Hya xi vetjuxin xitsehen tsëhë xahasen rë ngu xuta hiscan xi camá sacuaha ndava xitsehen jan ne, fi táha hiscan jemu nangui quixí camahani, vanguise cahndë́ hiscan xi cuejñajenda. Hane xi sacuiin rë cahndë́ hiscan cuejñajenda ne, cuitjin tsingataha cacun: “Cúya rë cjuë́ ndya naha hiscan xi cavétjuxen.” Cuatjin tsingataha cacun xitsehen jan. ");
INSERT INTO maqNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hane xi vuya fehe xitsehen jan cahntsua xahasen rë xuta jan ne, vutsejen xitsehen jan cahntsua xahasen jan sacuaha ngu ndihya xi caxtecha tyjahi tyjahi, hacuaha siundaja chichihin ngu tsë́ ngu xtí. ");
INSERT INTO maqNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Xi vutsejen xitsehen jan xi cuatjin jyihi jan ne, sehe fi jaha sa rë yatu sa xitsehen xi hitsë sa tsehen xi cuma rë vëhë ne, sehe visehen nga viyujucahndë́ jan. Peru xi ma ngascan ne, hitsë sa chojyihi tsëhë xuta vëhë xi cuma rë titjún. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Peru jinguyëjë rë xi tichja xu Jesús cjua vëhë ne, ngu na xi jiyajñi ngajñi rë xutacjín jan ne, cajindaya na cachja xu na cuitjin: ―‍Jemu ndaja tsëhë chjuun xi catsin rë ngayun, hacuaha jemu ndaja tsëhë ndanisin xi cavacuntuhun. ―‍Cuatjin xu cachja na. ");
INSERT INTO maqNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Peru Jesús ne, cuitjin xu cafayangui me tsëhë na: ―‍Quixi, peru hitsë sa ndaja tsëhë xuta xi visiñuju me cjua rë Nina hacuaha vihndë me tsëhë. ―‍Cuatjin xu cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Vëhë ta jima tangun camaha sa xutacjín jan ne, cavetsihin cachja xu Jesús cuitjin: ―‍Ngayujun ni ngayun xuta tjë rë Israel tsëhë nixtin vihi matsejen ne, hatuxa tsehen cjuatacun nuju. Tichjahyun ngu seña xi sahmi Nina, peru sacuiin nuju matsejen ta ngu ni seña xi sacú nuju matsejen ne, sacuaha seña xi catsingacun profeta Jonás hatsëë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sacuatjin rë profeta Jonás xi me vëhë camá me ngu seña xi cuma rë xuta nandya Nínive hatsëë nixtin matsejen ne, ha cuanitjin ni ná ngahan xi Quihndi rë Xuta Jain ngahan matsejen ta ngahan cuma ngahan seña xi cuma nuju ngayujun ni xi nechun nixtin vihi. ");
INSERT INTO maqNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Hya xi cuechú nixtin xi tsichuva Nina xuta tsëhë jyë́ rë me matsejen ne, na xi cavitexa ngajan nangui Sabá hatsëë nixtin matsejen ne, cjue cuinchajyë nuju na ngayujun ni ngayun xuta tjë rë Israel xi nechun nixtin vihi. Cuatjin sahmi na matsejen ta, tsëhë xi jercu tu cjin camahani xi canduva na xi cuihndë na cjuatacun ndacun xi jercu tu ma camahani rë Salomón, me xi cavitexa rë xutachanga naja hatsëë nixtin. Peru ha tejña ngahan nguehe sacuaha ngu seña xi hitsë sa vengui chji rë xi cuma rë Salomón. ");
INSERT INTO maqNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hacuaha hya xi cuechú nixtin xi tsichuva Nina xuta tsëhë jyë́ rë me matsejen ne, yëjë xuta nandya Nínive matsejen ne, cjue cuinchajyë nuju me ngayujun ni ngayun xuta tjë rë Israel xi nechun nixtin vihi. Cuatjin sahmi me matsejen ta, tsëhë xi me xi cuacun vëhë matsejen ne, catsindeya me cjuatacun rë me hya xi casua profeta Jonás camachaya rë me cjua rë Nina. Peru ha tejña ngahan nguehe sacuaha ngu seña xi hitsë sa vengui chji rë xi cuma rë profeta Jonás. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hane xi quijinduju sa cachja me ne, cuitjin xu cachja me: ―‍Tsajin hisca xi ngu xuta xi ha xcun xi ha cavatju cavetaha rë me ngu ndihi matsejen ne, faha me veyahma me o sá xi faha me veya me ngahma ngu caxa matsejen ta faha me vejña me cahndë́ rë, cojo sa xi yëjë xuta xi visehen me hiscan setí ndihi jan matsejen ne, scuëë me hasen rë. ");
INSERT INTO maqNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tuxcuun matsejen ne, vëhë xi sacuaha ndihi rë yojo naja. Vëhë xi hya xi tuxcuun ndacun matsejen ne, hatuxa ma hasen cahntsua yojo naja. Peru sá xi tuxcuun chocun matsejen ne, hacuaha ma jñu cahntsua yojo naja. ");
INSERT INTO maqNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ndandaja ningatuhuntacún matsejen ne, sacuaha hasen xi jiya cahntsua yojo nuju matsejen ne, ¿há hasen xi cjuaquixi jain?, o há tsajin ne, ¿há jñú? ");
INSERT INTO maqNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Quihndë matsejen ne, sá xi jingujyë ni yojo nuju jiya hasen, hisca xi hitsë jñú tsajin rë matsejen ne, jingujyë ni yojo nuju matsejen ne, jiya hasen sacuaha hya xi sahmi hasen tsajan hasen rë ngu ndihi. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hane xi cajnetaha xu cachja Jesús ne, ngu cha fariseo ne, cachja cha cojo Jesús xi cjue sinë me cojo cha niñu. Xi cavisehen Jesús ndihya ne, quiji xu me cafaha me cahndë́ rë me xcun maxë. ");
INSERT INTO maqNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Peru xi cavëë xu cha fariseo xcusun rë Jesús ne, jemu quijircun rë cha tsëhë xi hacuiin titjun cavane xu me tsja me sehe sinë me niñu sacuaha vitexa xcusun rë xutachanga rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ngajan xi Nai naja ne, cachja xu me cojo cha cuitjin: ―‍Ngayujun ni ngayun xuta fariseo ne, xcusun nuju xi nihñu tyjahi táha ngaxtun ni ngu vasu o sá xi ngu tyuva, peru cahntsua xahasen nuju ne, quitsë camahani rë cjuatsehen cojo cjuatacun xi nimuju yëjë ni xcusun. ");
INSERT INTO maqNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sca nuju ngayun. Catijne rcun ta ha me xi casahmi ni táha ngaxtun ne, hacuaha ha me vëhë ni casahmi me táha cahntsua. ");
INSERT INTO maqNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Peru xi hincha cahntsua ne, vëhë tuhun sacuaha caridad. Sá xi cuatjin nihñu ne, yëjë ni xcusun ne, tyjahi xi cuma nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Peru jemu chojyihi tsujun ngayun xuta fariseo, tsëhë xi ngayun ne, handasa nihñu cuidadu xi tuhun diezmu nuju hisca cojo nchurca cojo ruda cojo yëjë sa xcusun ndeya ne, peru nihñucuenduun xi nihñu hacutjin xi cjuaquixi cojo xingun, hacuaha nihñucuenduun xi nihmutacún Nina. Ngayun ne, meje rë xi ha canihñucuendun Nina, peru hacuaha hacuiin nichayun diezmu nuju vë. ");
INSERT INTO maqNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Hacuaha jemu chojyihi tsujun ngayun xuta fariseo, tsëhë xi ngayun ne, jemu ndama nuju xi cuatjin satë nuju cahndë́ xi matitjun tsëhë cahntsua yungun. Hacuaha jemu ndama nuju xi cuatjin fi chja xuta nina cojo nuju ngajan ngajñi ndetsin. ");
INSERT INTO maqNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Hacuaha jemu chojyihi tsujun ta, handasa matsijin ne, peru jemu chocun xahasen nuju. Vëhë xi tangun ngayun cojo tsjun xi hisca matsijin, hane xuta ne, hisca machayiin rë me cjui nduva me sune me xcun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ngajan xi ngu cha xi vicuya cjuachacun ne, cachja xu cha cuitjin cojo Jesús: ―‍Maestro, hya xi nújun cjua vëhë ne, hacuaha cojo ngayin choho nújun tsijin. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Hane Jesús ne, cuitjin xu cachja me: ―‍Hacuaha cojo ngayun cha xi vicuya cjuachacun, jemu chojyihi tsujun, tsëhë xi vicuyun rë xuta jemu cjín xcusun xi jemu chja camahani cuma sahmichihin me, hane suvun ne, visecuún rë me hisca hitsë. ");
INSERT INTO maqNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Jemu chojyihi tsujun ngayun ta, tsëhë xi ngayun ne, nindujun tsjun ndacun tsëhë yëjë ni nima profeta xi xutachanga nuju catsiquehen me hatsëë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ngayun suvun ningacun xi chuya nuju xcusun xi casahmi xutachanga nuju ta, tsëhë xi ngu ladu ne, me vëhë catsiquehen me profeta xi cuacun vë, hane ngu ladu nga ne, ngayun nindujun tsjun rë. ");
INSERT INTO maqNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Vëhë xi Nina, me xi jemu vechútaha cjuatacun rë me ne, cachja me cuitjin: “Tsingátju profeta cojo apóstol ngajñi rë xuta xi siu nixtin vihi, hane yahnga me xi cuacun vë ne, tsiquehen xuta me, hane yahnga me ne, sua xuta cjuañihi xi cuatju me xi cuacun vë.” Cuatjin cachja Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hane cojo chuva vëhë ne, xuta xi siu nixtin vihi ne, me vëhë cháha rë me tsëhë cjuaveya rë yëjë profeta xi cahme hisca ntsacu cavetsihin ngasunhndë, ");
INSERT INTO maqNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","vetsihin cojo hisca cjuaveya rë xutachanga naja Abel vijnetaha cojo hisca cjuaveya rë xutachanga naja Zacarías, me xi catsiquehen rë xuta tiña ngasunscun hiscan ndatsen rë ndava Nina. Cuichjá nga cojo nuju ta yëjë cjuaveya xi cuacun vë ne, cháha rë xuta xi siu nixtin vihi. ");
INSERT INTO maqNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Jemu chojyihi tsujun, ngayun cha vicuya cjuachacun ta, tsëhë xi cavejñuxun cjuatacun rë Nina. Canitjungun cjuatacun rë me, hacuaha hisca catuun cahndë́ xi sacú rë xuta xi meje rë me cjuatacun rë Nina jan. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hane hya xi tivetju xu Jesús tsëhë cahndë́ hiscan cajinë me niñu jan ne, cha xi vicuya cjuachacun cojo cha fariseo jan ne, jemu cjan rë cha, jemu cjín cjua cafahataha xu cha me, ");
INSERT INTO maqNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","hacuaha jemu cavangui xu cha chuva rë hacutjin xi sacú rë cha ngu cjua rë me xi cuaaintjin cuichja me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jinguyëjë rë xi tichja sa xu Jesús cojo cha xi cuacun jan ne, jercu jima tangun camahani xuta, ña vehnchun xicjin me. Sehe ngajan xi Jesús ne, cavetsihin cachja xu me tjutjun cojo xuta ladu rë me cuitjin: ―‍Xicaninguisuhunjñuu cojo cha fariseo xi cuacun vë ta, tsëhë xi cjuandacha xi sahmi cha ne, tangun cojo san rë pan xi hatuxa vitsojo ngajñi rë yëjë ni nahyu. ");
INSERT INTO maqNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yëjë ni xcusun xi casetsangui ne, cuechú nixtin xi chjaháxin rë xi titsangui rë. Vëhë xi yëjë ni xcusun xi hma ne, handasa sehmangui ne, peru cuechú nixtin xi cuetjucaa tsejen. ");
INSERT INTO maqNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yëjë ni cjua xi má hiscan jñu ne, cuechú nixtin xi cuinuhya rë hiscan hasen. Vëhë xi yëjë ni cjua xi má táha hma ne, cuechú nixtin xi cuinuhya rë táha tsejen. ");
INSERT INTO maqNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Nguehe cuichjá cojo nuju, ngayujun ni. Xicarcuun xuta xi tsiquehen nuju me, hane ngaxtun vëhë ne, ha quihndë tsajin mé sa xi cuma sahmi me cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Peru nguehe cuichjá cojo nuju yo xi meje rë xi rcún. Meje rë xi Nina xi rcún me. Me xi ngaxtun xi ha catsiquehen nuju ne, tjin rë me cahndë xi tsingatjenya nuju me hiscan xi má hasen rë nima castigu. Cuichjá nga cojo nuju ta hatuxa me vëhë xi meje rë xi rcún me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Chutsujun ta hñú chu nisë langa ne, jemu xtengui chji rë chu. Peru Nina ne, tsichayaain me hisca xi ngu chu. ");
INSERT INTO maqNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hacuaha ngayun ne, hisca tsjarcun xqui tjin rë Nina. Vëhë xi xicarcuun ta, tsëhë xi jima ngu ngayun ne, hitsë sa jercu vengui chji nuju xi cuma rë xi jemu cjín chu nisë vë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Nguehe cuichjá cojo nuju ta yëjë xuta xi tsinguixi me xcun xuta xi yahnga xi xuta ladu naha má me ne, hacuaha ngahan xi Quihndi rë Xuta jain ngahan ne, tsinguixë xcun yëjë ni ángel rë Nina xi xuta ladu naha má xuta xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Peru yëjë xuta xi tsinguixi me xcun xuta xi yahnga xi hacuiin xuta ladu naha má me ne, hacuaha hacuanitjin ni tsinguixë ngahan xcun ángel rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Hacuaha yëjë xuta xi choho chja me tsahan, ngahan xi Quihndi rë Xuta Jain ngahan ne, tsinchataha Nina me, sá xi cjuehya me cjuaninchataha. Peru yëjë xuta xi choho chja me tsëhë Hasen rë Nina ne, tsajin cjuaninchataha xi cuma rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Hya xi xuta nandya cjuaha nuju me cjuecojo nuju me xcun xutaxa rë yungun o sá xi xcun xutaxa rë ndihyavasen ne, hacuiin cumacjintacún tsëhë chuva rë hacutjin xi chjayunngun o tsëhë xi cuinújun ta, ");
INSERT INTO maqNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tsëhë xi ha hora vëhë ni ne, Hasen rë Nina cuichja cojo nuju mé cjua xi meje rë xi cuinújun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hya xi camá ne, ngu xuta tsëhë ngajñi rë xutacjín jan ne, cachja xu me cojo Jesús cuitjin: ―‍Maestro, tinújun cojo cha vëhë xingueen, catisua cha ngahan xcusun xi satë ná xi cavejña nahmi niji hya xi cahme me. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sehe ngajan xi Jesús ne, cuitjin xu cachja me: ―‍Peru ngahan ne, hacuiin xá naha xi ngahan cuátëcja xcusun xi satë nuju xingu xingu ngayun. ―‍Cuatjin xu cachja Jesús cojo xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sehe cachja nga xu me cojo xutacjín jan cuitjin: ―‍Nechun cuidadu, hacuiin jercu nimuju cjuanchina matsejen ta, tsëhë xi hacuiin ngatsë rë cjuanchina xi tjin naja matsejen ne, vëhë xi ndacun cjuahñu naja. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ngaxtun vëhë ne, sehe cachja xu Jesús ngu ejemplu cojo xuta cuitjin: ―‍Cuejña ne xi ngu cha nchina jan matsejen ne, jercu ndaja camá xitjë xcun nangui rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hya xi camá ne, cuitjin catsingataha cacun cha: “¿Mé xi ndatjin sahme quihndë? Ha quihndë tsajin ná cahndë́ hiscan xinchandaja tutjë́ naha. ");
INSERT INTO maqNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ndatjin rë xi cuitjin sahme. Tsinguétsun ndihya hiscan hinchandaja tutjë́ naha, hane tsindaja xi hitsë sa yehe. Hane ngajan cuínchandaja yëjë tutjë́ naha cojo ngu tsë́ ngu xtí sa xi tjin ná. ");
INSERT INTO maqNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Hane sehe cuichjá cojo xahasen naha cuitjin: Jercu cjín camahani xcusun hinchandaja ná quihndë, hacuaha jemu cjín nu cjuecani rë. Cuitejñajenda quihndë. Sínë cuëhë tsahan. Suá cjuasua xahasen naha.” Cuatjin catsingataha cacun cha nchina jan. ");
INSERT INTO maqNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ngajan xi Nina matsejen ne, cuitjin cachja me cojo cha: “Sca ri ngaye. Nguixun quihndë ne, cueye. Hane yëjë xcusun xi cavetje ne, tsajin mé sacú ri tsëhë.” Cuatjin cachja Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Cuatjin rë xuta xi jercu vetjo cjuanchina xi cuma rë suvá me, peru xcun Nina matsejen ne, tsajin mé xi tjin rë me. ―‍Cuatjin xu cachja Jesús ejemplu vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ngajan xi Jesús ne, cuitjin cachja xu me cojo xuta ladu rë me: ―‍Vëhë xi cuichjá cojo nuju ta: Hacuiin cumacjintacún tsëhë xcusun xi xinu xi sua nuju ngahñu. Hacuaha hacuiin cumacjintacún tsëhë tsjian xi chujun. ");
INSERT INTO maqNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hacuiin cumacjintacún ta, tsëhë xi hitsë sa vengui chji rë cjuahñu nuju xi cuma rë xi chinu. Hacuaha hitsë sa vengui chji rë yojo nuju xi cuma rë tsjian xi chujun. ");
INSERT INTO maqNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Chutsujun chu chenda ta hacuiin tsitjë chu, hacuiin fanga chu, hacuaha tsajin rë chu ndyahnga hiscan cuinchandaja chu xi sinë chu. Peru Nina tsicjen me chu. Ngayun ne, hitsë sa jercu vengui chji nuju xi cuma rë chu nisë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hacuaha tsajin hisca xi ngu xuta xi cuma cuesuntaha me cjuahñu rë me hisca ngu hora ngatsë rë xi ma cjín cacun me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sá xi hitsë lihndi xcusun vëhë maji nihñu ne, ¿mé má jercu macjintacún tsëhë xcusun xi yahnga jan ni? ");
INSERT INTO maqNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Chutsujun naxu liriu ta tsihyaain nachjun hacuaha fahyaain tsjian. Peru ngahan cuichjá cojo nuju ta tsjian rë xutachanga naja Salomón ne, handasa jercu ndacun camahani, peru hitsë sa ndajyihi ngu naxu vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sá xi cuatjin tsicaja Nina xca nguijña xi ngu nixtin ne siutahá nguijña, hane xitu ngu nixtin ne cueti ne, hitsë sa ngayun ta hatuxa tsicaja nuju me, ngayun xi cjëë cumangutacúnndujun cojo me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hacuiin jercu nijendun rë xahasen nuju xi vinchunsun xi xinu xi siuhun ta, ");
INSERT INTO maqNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","tsëhë xi xcusun vëhë ne, yëjë xutaxín tsëhë jingujyë ni ngasunhndë ne, me vëhë xi vangui me xcusun vëhë. Peru ngayun ne, Nina Nahmi naja ne, ha vëë me xi hatuxa sahmi ngujyë xi sacú nuju xcusun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Catamarcun nuju tsëhë gubiernu xi sahmi Nina, hane xcusun vëhë ne, quitahácoo sa sacú nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Xicamacjiintacún ngayun xuta ladu naha xi jemu chúva má ngayun ta, tsëhë xi Nina Nahmi naja ne, ha cavejña cacun me xi cojo cjuandaja rë me ne, sua nuju me xá xi nihñu gubiernu hiscan xi sahmi me gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Titeñu xcusun xi tjin nuju, hane tujún xi sacú nuju ne, tuhun rë xuta xi tsajin rë me, sacuaha tuhun ngu caridad. Nihñu ngujyë xi sacú nuju cjuanchina xi jercu cjuecani rë. Cuma cuinújan ne, ngu cjuanchina xi tsajin nixtin cjuë xi cuetjún ngajan ngahnga hiscan xi cha chëjë ne, maji ma tiña cha, hisca chu quixún ne, tsinguetsiin chu. ");
INSERT INTO maqNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Cuatjin meje rë xi nihñu ta, tsëhë xi hiscan tetjo cjuanchina nuju ne, hacuaha ngajan quitahá cjuatacun nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Tuhunchjinu yojo nuju, hacuaha catisetí ni ndihi nuju, tsëhë xi cjuehe Nai nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nihñu sacuatjin sahmi hndixahan xi viyujuya me nai rë me, hya xi nai rë me quiji ngu ndava suhi. Siuchjine ni me cojo sa xi hora xi cjuehe nai rë me ne, xi tu cuichja ne, ngutjen cjue scuxaha me tingotjo xi cuisehen nai rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jemu ndaja tsëhë yëjë hndixahan xi, hora xi cjuehe nai rë ne, sacútsja rë xi siu quicun. Nguehe cuichjá cojo nuju cjuaquixi ta, xi scuëë nai rë hndixahan jan xi cuatjin quicun hndixahan ne, cuëhëchjine me yojo rë me, sehe cjuecojo me hndixahan xcun maxë, sehe cuiyuju me xi sinë me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jemu ndaja tsëhë hndixahan xi sacútsja rë nai rë xi siu quicun, handasa nixten cjuehe me o sá hisca tiña sahasen cjuehe me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hacuaha meje rë xi cumachaya nuju cjuatacun vihi: sá xi nai rë ngu ndihya ha machaya rë me hora xi cuinduva cha chëjë ndava me ne, suaain me cahndë́ xi scuxaha cha ndava me, sehe tsichëjë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hacuanitjin ni meje rë xi ngayujun ni ngayun ne, tuhunchjinu yojo nuju ta, tsëhë xi hora xi ningatuuntacún xi cjuëhë ngahan xi Quihndi rë Xuta Jain ngahan ne, hora vëhë rë cjuëhë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hya xi camá ne, Pedru ne, cuitjin xu cachja me cojo Nai naja: ―‍Tatá. Ejemplu xi canújun vë ne, ¿há suvin ni ngayin xuta ladu nuju meje rë xi cuetihinrcuin?, o há tsajin ne, ¿há cojo yëjë sa xuta xi yahnga cuetaharcu me? ―‍Cuatjin xu cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ngajan xi Nai naja ne, cuitjin xu cafayangui me: ―‍Ngayujun ni ne, meje rë xi nihñu sacuaha sahmi ngu hndixahan xi jemu quicun cacun xi sahmichihin yëjë ni hacutjin xi meje rë nai rë, ngu hndixahan xi cjuahaxa xi cjuahacuenda rë yëjë sa hndixahan xi hora tjin sua xi sinë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jemu ndaja tsëhë ngu hndixahan xi, hora xi cjuehe nai rë ne, sacútsja me hndixahan jan xi tisahmi tutjin xi casuaxa rë nai rë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cuichjá cojo nuju cjuaquixi ta, nai rë hndixahan vëhë ne, suaxa me hndixahan vëhë xi hacuaha cjuahacuenda yëjë sa xcusun xi tjin rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Peru cuejña ne xi hndixahan vëhë ne, tsingataha cacun cojo cjuatacun rë cuitjin: “Nai naha ne, tijima tafi sa xi cjuehe me.” Cuatjin tsingataha cacun. Sehe cuetsihin cuaja rë hndixahan xi yahnga jan, hacuaha cuetsihin cuatjutaha sinë cuihi hisca cuma chihi. ");
INSERT INTO maqNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Peru cuechú ngu nixtin xi tsajin tacunya hndixahan vëhë, ngu hora xi hisca hvíin ne, hya cjuehe nai rë, hane jemu jyë castigu sahmi me. Sehe tsingatju me cuatjutangun cjuañihi cojo hndixahan xi yahnga xi casahmichiin tutjin xi casatëxa rë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Hndixahan xi ha ndaja vëë hacutjin xi meje rë nai rë hane cavihinchjinii, hacuaha casahmii tutjin meje rë nai rë ne, jemu sehen camahani rë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Peru hndixahan xi hvíin hacutjin xi meje rë nai rë hane casahmi xcusun xi vechú chuva rë xi cuma castigu ne, chúva sehen rë. Hane yëjë ni hndixahan xi jemu cjín xcusun xá casua nai rë xi sahmi ne, hacuaha cuatjin jercu cjín cjua chjahya rë hya xi sahmi entregadu cuenta rë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ngahan ne, canduvá ne xi cuétaha rë sacuaha ngu ndihi ngasunhndë, ngu ndihi xi tsingacun mé cún cjuatacun rë xuta. Hacuaha jemu meje ná xi ha hisca ha casetaha rë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngahan ne, tjin ná xi cuátju ngu cjuañihi sacuatjin rë ngu xuta xi tjin rë me xi satë rë me nandá hya xi xtenda me. Hacuaha jercu choho má ná hisca xi cuma chihin cjuacjintacun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Xi má nuju ngayun ne, ¿há cjuajeya canduvácojo xi cuma rë xuta ngasunhndë? Hacuiin cuatjin. Ngahan ne, canduvá ne xi sahme xi sahmi condra xuta xicjin me. Cuatjin sahmi condra xicjin me ta, tsëhë xi ngujo me ne, cumangu cacun me cojo ná, hane ngujo nga me ne, cumanguaain cacun me cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Xi cuetsihin nixtin vihi ne, hisca cojo xi cjuiniji sa ne, cuejña ne xi ngu ndihya ne, siu hñú xuta cojo xicjin me. Hane jyan me ne, sahmi condra me me xi jo jan. Hane me xi jo jan ne, sahmi condra me me xi jyan jan. ");
INSERT INTO maqNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nahmi ne, sahmi condra me cha quihndi rë me, hane cha quihndi rë me jan ne, sahmi condra cha nahmi rë cha. Naa ne, sahmi condra me na quihndi rë me, hane na quihndi rë me ne, sahmi condra na naa rë na. Nahya ne, sahmi condra me jahnda rë me, hane jahnda rë me ne, sahmi condra na nahya rë na. ―‍Cuatjin xu cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hya xi camá ne, cachja nga xu Jesús cojo xutacjín jan cuitjin: ―‍Nguehe nangui naja matsejen ne, hya xi chutsujun xi tivisecún ngu yufí ngajan táha ladu vetje tsuhi matsejen ne, ngutjen nújun ta cuaha ngu tsi hñu, hane cuatjin jain má. ");
INSERT INTO maqNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hane hya xi vanga ngu tjo xi cjui táha ladu ngatihin matsejen ne, ngayun matsejen ne, nújun ta cuma suë, hane cuatjin jain má. ");
INSERT INTO maqNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jemu hyun mé vijne xcusun xi cún nangui cojo xcusun xi cún ngahnga. ¿Mé má nújun xi hyúun mé vijne xcusun xi tijima nixtin vihi ni? ¡Jemu ndacha ngayun! ");
INSERT INTO maqNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Hane ngayun matsejen ne, ¿mé má nichuvuun suvun cojo cjuatacun nuju xcusun xi cjuaquixi ni? ");
INSERT INTO maqNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ndiya tivangun cojo xuta xi meje cuinchajyë nuju ngajan xcun xutaxa rë matsejen ne, nihñu ngahñu xi cuisuhun cjuandaja cojo me, cojo sa xi xticja si xi tacun ngajñi nuju cojo rë me matsejen ta, sá tsajin ne, cjuecojo nuju me xcun juez. Hane juez matsejen ne, squindaya me mayu sehe sahmi nuju me entregadu, hane mayu jan matsejen ne, cjue cueyá nuju me ndavaya. ");
INSERT INTO maqNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Hane cuichjá cojo nuju cjuaquixi matsejen ta hatuxa cuetjuun tsëhë ngajan jinguyëjë rë xi cjëë cuechjun yëjë ni tujún xi quitjun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ha hora vëhë ni ne, cafehe xu ngujo xuta hiscan tacun Jesús. Hane cachja xu me cojo Jesús tsëhë ngujo xuta tsëhë distritu Galilea xi cavitexa Pilatu xi cueya hya xi titsiquehen xuta xi cuacun vë chu rë me xi sua me cjuatjo cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ngajan xi Jesús ne, cuitjin xu cachja me cojo xuta xi cachja cojo rë me jan: ―‍Hane tsëhë xi cuatjin cahme ngujo xuta Galilea xi cuacun vë ne, ¿há vëhë xi má nuju xi hitsë sa tsehen me xi cuma rë yëjë sa me xi yahnga? ");
INSERT INTO maqNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jéya, hacuiin cuatjin. Peru sá xi ngayun nindeyuun cjuatacun nuju ne, ngayujun ni ne, hacuaha cuatjin cueyun. ");
INSERT INTO maqNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O há tsajin ne, xuta xi tyjuhunjyan xi cahme hya xi caticjane rë torre tsëhë Siloé jan ne, ¿há má nuju xi hitsë sa tsehen me xi cuma rë yëjë sa xuta xi caviyuju ngajan Jerusalén? ");
INSERT INTO maqNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jéya, hacuiin cuatjin. Peru sá xi ngayun nindeyuun cjuatacun nuju ne, ngayujun ni ne, hacuaha cuatjin cueyun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sehe ngajan xi Jesús ne, cachja sa xu me ngu ejemplu cojo xuta jan, cojo sa xi sua me cumachaya rë xuta xi jemu chúva camá nixtin xi cuma tsindeya xuta cjuatacun rë me. Cuitjin cachja me: ―‍Cuejñaa ne xi ngu ya túhaxi jan ne, secun xcun nangui rë ngu cha jan. Hane xi canduva cha xi tsëhë jan, vanguise cha tú rë ne, casacuiin rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sehe ngajan xi cachja cha cojo cha mosu rë cha cuitjin: “Ha tjin rë jyan nu xi vinduva vanguësë tú rë ya vi ne, sacuiin ná. Tiche. ¿Mé má tu cuenda cuisecun tsinguetsun rë nangui?” Cuatjin cachja cha xi tsëhë jan. ");
INSERT INTO maqNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ngajan xi cha mosu jan ne, cuitjin cafayangui cha: “Tatá. Tuhun rë cahndë́ catisecun ndastu ngu nu sa, hane cuacján nangui rë, hacuaha cuíncha rë abono. ");
INSERT INTO maqNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xi cuatjin ne, ¿há suaain tú rë nduva nga ngu nu? Hane sá xi hacuaha ni suaain tú rë ne, sehe cuichan.” Cuatjin cafayangui mosu jan. Cuatjin xu fi ejemplu xi cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ngu nixtin xi chjahájenda rë, hya xi tivicuya xu Jesús cahntsua ngu yungun jan ne, ");
INSERT INTO maqNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ngajan tacun ngu chjuun xi ha cjui tyjuhunjyan nu xi camaticua na hane ha quihndë maji xu ma quixi nínda ngaxtun na. ");
INSERT INTO maqNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Xi cavëë Jesús na ne, cajindaya xu me na, sehe cachja me cojo na cuitjin: ―‍Ngayun tsan ne, ha camandaya ngayun tsëhë xi cuatjin jyihi ngayun vë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hane ha hora vëhë ni cavisanetsja xu me na, hane ngutjen ni camaquixi nínda ngaxtun na. Hya xi camá ne, casahmi jyë casahmi hnga xu na Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Peru presidente rë yungun jan ne, jemu camacjan xu rë me tsëhë xi casahmi Jesús xi camandaja ngu chjuun nixtin xi chjahájenda rë. Vëhë xi cachja xu me cojo xutacjín jan cuitjin: ―‍Tjin naja jyun nixtin xi nihña xá. Vëhë xi meje rë xi ngajñi rë jyun nixtin vëhë matsejen ne, hya nduvun xi cumandaja ngayun, hacuiin xi tu nixtin xi chjahájenda rë matsejen ne, hya cuinduvun. ―‍Cuatjin xu cachja presidente rë yungun jan. ");
INSERT INTO maqNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Peru Nai naja ne, cuitjin xu cachja me: ―‍¡Jercu choho ningatuhuntacún! Jima ngu ngayun matsejen ne, hatuxa vuhunndayun ndyaja vuhunndayun burru nuju tsëhë cahndë́ rë chu xi cuangun nicuhun chu nandá, handasa nixtin xi chjahájenda rë. ");
INSERT INTO maqNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hane na vihi xi xuta ladu rë Nina na hacuaha tjinhñu rë Satanás na cahntsua tyjuhunjyan nu matsejen ne, ¿há ndaintjin xi sehenndaya na nixtin xi chjahájenda rë ni? ―‍Cuatjin xu cachja Nai naja. ");
INSERT INTO maqNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hane xi cafë xu cachja Jesús cjua vëhë ne, yëjë ni xuta xi má condra rë me ne, jemu camasava xu rë me. Peru yëjë sa xuta xi yahnga ne, jercu ndaja camá xu rë me tsëhë yëjë ni xcusun ndaja xi casahmi Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Hacuaha cachja sa xu Jesús ejemplu vihi: ―‍Gubiernu xi sahmi Nina ne, ¿mé xi tangun cojo? ");
INSERT INTO maqNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tangun cojo ngu tutjë́ xi jemu lihndi camahani. Hya xi ngu xuta tsitjë me tutjë́ vëhë xcun nangui rë me ne, cuetju, cuma ngu ya, hisca nisë xi vitjen chu ngahnga ne, sahmi chu ndava chu rcu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Cavuya cachja nga xu Jesús cuitjin: ―‍Gubiernu xi sahmi Nina ne, ¿mé xi tangun cojo? ");
INSERT INTO maqNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tangun cojo san rë pan xi visecjan ngu chjuun ngajñi rë nahyu rë pan cojo sa xi sahmixa ngajñi rë yëjë ni nahyucjín jan. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ndiya cjui xu Jesús ngajan Jerusalén ne, cavatju xu me nandya cojo ranchun xi siu ndiya cjui me jan, hane cachja me cojo xuta cjua rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hya xi camá ne, cavinenguise xu ngu me xi cavinenguise rë Jesús cuitjin: ―‍Tatá. ¿Há jemu chúva xuta xi tivetjutje me? ―‍Cuatjin xu cavinenguise xuta jan. Sehe ngajan xi Jesús ne, cachja xu me cojo xuta xi siu jan cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―‍Nihñu ngahñu xi cuma cuisuhun hiscan sahmi Nina gubiernu táha tingotjo xi xcu ta, tsëhë xi nguehe cuichjá cojo nuju ta cuechú nixtin xi jemu cjín xuta xi cuma meje cuisehen me jan, peru cumaji. ");
INSERT INTO maqNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ta hya xi ngahan xi nai rë cahndë́ vëhë ngahan, cuinduva cuéchja tingotjo ne, ngayun ne, cuinechun candatsen, sehe cujunntsun tingotjo jan hacuaha cuitjin cuinújun: “Tatá. Chuxuhun tingotjo tsijin.” Cuatjin cuinújun. Hane xi cjuayanguë tsujun ne, cuitjin cuichjá: “Hveen jani canduvun ngayun.” Cuatjin cuichjá cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hane ngayun ne, cuitjin cuinújun nga: “Cachini cahyin tangun cojo nuju, hacuaha nangui niji canujyuhunyun cavicuyun cjua rë Nina.” Cuatjin cuinújun. ");
INSERT INTO maqNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hane cuitjin cuichjá nga cojo nuju: “Hveen jani nandya nuju. Tángunxun tsahan, ngayujun ni ngayun xuta sahmi cjuatsehen.” Cuatjin cuichjá. ");
INSERT INTO maqNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ngajan ni ne, jemu chjihndun hacuaha nijanurii nehñu, hya xi chutsujun Abraham cojo Isaac cojo Jacob, cojo yëjë profeta xi siu me ngajan hiscan xi sahmi Nina gubiernu, peru ngayun ne, caviyujú nuju candatsen. ");
INSERT INTO maqNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Hane cuinduva xuta tsëhë táha ladu vetjucaa tsuhi cojo táha ladu vetje tsuhi cojo yëjë sa ladu, cuinduva me sinë tangun me hiscan xi sahmi Nina gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nguehe cuichjá cojo nuju ta yahnga xuta xi tjengui me quihndë ne, me vëhë cuma titjun me, hane yahnga me xi titjun quihndë ne, me vëhë cuma tjengui me hya xi cuejña Nina gubiernu rë me jan. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ha hora vëhë ni ne, cafehe xu ngujo cha fariseo, hane cuitjin xu cachja cha cojo Jesús: ―‍Ndatjin xi tetjunxun tsëhë nguehe ta, tsëhë xi Herodes ne, meje tsiquehen nuju me. ―‍Cuatjin xu cachja cha xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hane ngajan xi Jesús ne, cuitjin cafayangui xu me: ―‍Tángun ne tinújun cojo rë chu ninda vë cuitjin: “Chutsujun ni, quihndë cojo nchujun ni ne, cuáxëxen xitsehen hacuaha sahme xi cuma ndaja xuta hmu rë, hane nguini ne, tsinguíjnetaha xá xi tisahme.” Cuatjin tinújun. ");
INSERT INTO maqNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Peru hacuaha sahmi ná ngujyë xi cjuë́ sa quihndë nchujun ni cojo nguini hisca xi cjuëhë hiscan xi tifë́ ta, tsëhë xi profeta ngahan, hane ngu profeta ne, cumaji xi cueya jingusa nandya xi hacuiin nandya Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Ngayun xuta Jerusalén, ngayun xi cojo ndyojo nicuhun profeta xi tsingatju Nina ngajñi nuju! ¡Jemu choho má ná! ¡Mé hitsë ndiya xi meje scávëvaha nuju sacuaha javëvaha ngu nisë quihndi rë chu xi cuincha chu ngahma tyjunga rë chu, peru ngayun ne, mijí nuju! ");
INSERT INTO maqNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chutsujun ni, Nina ne, catsismicacun me ngayun. Cuichjá cojo nuju ta chuun camahani ná hisca hya xi cuechú nixtin xi cuinújun cuitjin: “¡Catsinchacun Nina me xi titsingatju me ngajñi naja!” ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cuitjin camá xu ngu nixtin xi chjahájenda rë hya xi quiji cajinë Jesús niñu ndava ngu cha xi matitjun ngajñi rë cha fariseo. Xi cafehe Jesús jan ne, cha xi siu jan ne, siu tifahachuva xu ni cha Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Hacuaha hiscan tacun Jesús ne, ngajan xu tacun ngu cha xi yaha rë chíhinsquee. ");
INSERT INTO maqNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ngajan xi Jesús ne, cavinenguise xu rë me cha xi vicuya cjuachacun cojo cha fariseo cuitjin: ―‍¿Há tjin cahndë́ nixtin xi chjahájenda rë xi nihña xi cumandaja xuta, o há tsajin cahndë́? ―‍Cuatjin xu cavinenguise Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hane cha xi cuacun jan ne, tu caviyujujyuu xu ni cha. Hya xi camá ne, cafaha xu Jesús cha hmu rë jan, hane casahmi me xi camandaja cha, sehe catsingatju me cha cafe cha. ");
INSERT INTO maqNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sehe cavinenguise xu me cha xi siu jan cuitjin: ―‍¿Há tjin ngu ngayun xi nixtin xi chjahájenda rë ne, cuanguun marcu macjain naxun quihndi nuju o sá ndyaja nuju sá xi cjuinenguiya ngu ndava nandá xi jemu nungun? ―‍Cuatjin xu cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hane cha xi cuacun jan ne, camaji cafayangui xu cha hisca xi ngu cjua xi meje rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hya xi camá ne, tsëhë xi vutsejen xu Jesús xi xuta xi cachjindaya rë tsëhë suhi jan ne, tivaxijin me cahndë́ xi matitjun ngajan xcun maxë ne, vëhë xi cachja xu me cojo xuta jan cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―‍Hya xi chjindaya nuju cuangun xinu ngu comida ne, xicachjuun cahndë́ xi matitjun ngajan xcun maxë ta sá tu hacuaha cachjindaya rë ngu me xi hitsë sa meje rë xi chjahárcun rë xi cuma nuju ngayun. ");
INSERT INTO maqNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Hane cuinduva me xi cajindaya nuju catsijotjun ni ne, cuichja me cojo nuju cuitjin: “Tuhun rë me vihi cahndë́ nuju vë.” Cuatjin cuichja me cojo nuju. Ngajan xi ngayun ne, cojo jyë cjuasava ne, cuangun chjuhun cahndë́ xi ma tjengui. ");
INSERT INTO maqNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Xi meje rë ne, hya xi cuatjin chjindaya nuju ne, tángun chjuhun cahndë́ xi ma tjengui, cojo sa xi hya xi cuinduva me xi cajindaya nuju ne, cuichja me cojo nuju cuitjin: “Ngayun ne, nduvun chjuhun ngu cahndë́ xi hitsë sa matitjun.” Cuatjin cuichja me. Ngajan xi ngayun ne, jercu sahmi jyë sahmi hnga nuju me ngajñi rë yëjë xuta xi siu jan. ");
INSERT INTO maqNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Cuatjin cuma ta, tsëhë xi yëjë xuta xi sahmi yehe suvá me yojo rë me ne, cuechú nixtin xi Nina ne, tsinguijne me cjuatacun rë. Hane xuta xi tsinguijne suvá me yojo rë me ne, Nina ne, sahmi yehe rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hacuaha cachja nga xu Jesús cuitjin cojo me xi cajindaya rë me: ―‍Hya xi nihñu ngu suhi ne, xicachjindayuun rë amigu nuju, xicachjindayuun rë xingun, hacuaha xicachjindayuun rë xuta nchina xi siu tahndee ndya nuju, sá tu hacuaha squindaya nuju me xi cuangun ndava suhi rë me, hane cojo vëhë ni ne, ha camangojo cjuandaja nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cahndë́ rë vëhë ne, hya xi nihñu ngu suhi ne, chjindayun rë xuta yuma, chjindayun rë xuta xi yoho me, chjindayun rë xuta rengun, hacuaha chjindayun rë xuta rcá. ");
INSERT INTO maqNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sá xi cuatjin nihñu ne, jemu ndaja tsujun ta, tsëhë xi xuta xi cuacun vë ne, tsajin rë me mé cojo sahmingojo me cjuandaja nuju. Peru Nina sahmingojo me tsujun hya xi tsicuya me cjuahñu xuta xi tsajin jyë́ rë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hane xi cahndë xu ngu cha xi cojo tijinë jan cjua xi cachja Jesús ne, cuitjin xu cachja cha cojo rë me: ―‍¡Jemu ndaja tsëhë xuta xi sinë me niñu hiscan xi sahmi Nina gubiernu! ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ngajan xi Jesús ne, casuacuenda xu me cha ngu ejemplu vihi: ―‍Cuejña ne xi ngu cha jan ne, casahmi cha ngu suhi jyë, hacuaha jemu cjín xuta cajindaya rë cha me. ");
INSERT INTO maqNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Xi casune hora xi sinë cha cojo xuta ne, sehe catsingatju cha hndixahan rë cha ndava xuta xi ha cachja cha cojo xi cuichja hndixahan jan cojo rë xuta cjua vihi: “¿Há cuangun xu ta, ha tjin chjine yëjë ni?” Cuatjin cachja hndixahan jan. ");
INSERT INTO maqNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hya xi camá ne, cavetsihin jima ngu me cachja me mé tsëhë xi cumaji cjue me. Hane me xi tjutjun ne, cuitjin cachja me cojo hndixahan jan: “Ngu rquí nangui cavátsë ne, sahmi ná ngujyë xi cjuë́ scutséjen. Vëhë xi cumaji cjuë́ ndava suhi.” Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hane ngu nga me ne, cuitjin cachja me: “Cavátsë hñú ninchin ndyaja, hane cjuë́ cjuaháchuva chu. Vëhë xi cumaji cjuë́ ndava suhi.” Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Hane ngu nga me ne, cuitjin cachja me: “Cumaji cjuë́ ta, tsëhë xi ngahan ne, ha cavíxan.” Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Hya xi camá ne, hndixahan jan ne, quiji cachja cojo nai rë cjua xi cachja xuta xi cuacun jan. Hane xi camacjan rë nai rë ndihya jan ne, cuitjin cachja cha cojo hndixahan rë cha: “Tetji ne, tihin sanii ngajan ndiyatë cojo ndiyahndë tsëhë ngajñi nandya ne, chjindaye rë xuta yuma cojo xuta yoho cojo xuta rcá cojo xuta rengun ne, ndovecueje me.” Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hane xi cavuya hndixahan jan ne, cuitjin cachja: “Tatá. Camá tutjin xi cavitexun ná, peru tjin sa cahndë́.” Cuatjin cachja hndixahan jan. ");
INSERT INTO maqNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ngajan xi cachja nga nai rë hndixahan jan cojo rë cuitjin: “Tihin nga hisca ndiya nguijña, hane nihñi rë xuta ngujyë ndovecueje me, cojo sa xi catitsë rë ndya naha. ");
INSERT INTO maqNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nguehe cuichjá cojo ri ta hisca xi ngu me xi cajindáya rë tjun tjun ne, satiin rë me sinë me tsëhë suhi xi tisahme.” Cuatjin cachja nai rë hndixahan jan. ―‍Vëhë cajnetaha xu ejemplu xi casuacuenda Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ngajan xi hya xi quiji sa xu Jesús ndiya rë me xi cjui me Jerusalén ne, jemu cjín camahani xuta cjui me cojo rë me. Hane xi cavuya me cavutsejen me xutacjín jan ne, cuitjin xu cachja me: ");
INSERT INTO maqNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―‍Sá xi tjin ngu ngayun xi meje cuinduvuntjengun ná matsejen ne, meje rë xi hitsë sa nihmutacún ná ngahan xi cuma rë xi nihmutacún nahmi nuju, naa nuju, chjuun nuju, quihndi nuju, xingun, hisca cojo yojo nuju suvun. Sá tsajin ne, cumaji cuma ngayun ngu xuta ladu naha. ");
INSERT INTO maqNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jarë ngayun xi nduvuntjengun ná matsejen ne, sá xi cuejñuhñuun xahasen nuju xi cuanguncujun ndiya naha handasa hisca cueyun xcun cru matsejen ne, cumaji cuma ngayun ngu xuta ladu naha. ");
INSERT INTO maqNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ha hyan matsejen ta hya xi ngu xuta meje sahmi me ngu ndihya jyë ne, titjun sahmi me cuenta rë me, há chutaha tujún rë me hisca xi tsinguijnetaha me sahmi me ndihya. ");
INSERT INTO maqNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Cuatjin sahmi me cuenta rë me matsejen ta sá tsajin ne, sá xi ngutjen sahmi me xihndënaña rë hane cumaji tsinguijnetaha me sahmi me ndihya matsejen ne, yëjë ni xuta xi scuëë me matsejen ne, jemu cuejnucëë me me. ");
INSERT INTO maqNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Cuitjin cuichja me: “Cha xi cavetsihin casahmi ngu ndihya jyë vi ne, camaji catsinguijnetaha cha casahmi cha.” Cuatjin cuichja xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Hacuaha ha hyan matsejen ta hya xi ngu me xi matitjun cjue sahmi me ngu si jyë cojo jingu sa me xi matitjun xi condra rë me matsejen ne, titjun tsingataha cacun ndaja me, ¿há scaa rë me cojo të mil xuta rë me xi sahmi me si cojo condra rë me xi ticojo can mil xuta rë? ");
INSERT INTO maqNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sá xi vutsejen me ta scaain rë me matsejen ne, jinguyëjë rë xi cjin sa nduva condra rë me matsejen ne, tsingatju me ngujo xuta xi tsinguijnehnchan cjua. ");
INSERT INTO maqNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Vëhë xi ngayujun ni matsejen ne, meje rë xi cuatjin titjun ndaja ningatuhuntacún ¿há scaa nuju, há scaain nuju? matsejen ta, tsëhë xi yëjë ni ngayun xi nismutacuun yëjë ni xcusun xi tjin nuju matsejen ne, cumaji cuma ngayun xuta ladu naha. Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Hacuaha cachja sa xu Jesús cojo xutacjín jan cuitjin: ―‍Ngayejen ni matsejen ne, ha hyan matsejen ta naxa matsejen ne, ndaja. Peru sá xi cjuë xtya rë matsejen ne, ¿hacutjin cuma xincha nga tutju rë ni? ");
INSERT INTO maqNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ha quihndë tsajin mé cumachjirëhë. Cumaji nicojonxan sacuaha nihndë, hacuaha cumaji nicojonxan sacuaha abono. Chjahá rë cuixu candatsen. Yo ngayun xi tjin nuju cjuasua xi cuinuhyun cjua naha matsejen ne, ndaja tinuhyun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ngundiya jan ne, jemu cjín xu cha faha tujúnsa cojo xuta tsehen xi yahnga jan quiji casahmi tiña me tsëhë Jesús, xi meje cuisiñuju me cjua xi cuichja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hane cha fariseo cojo cha xi vicuya cjuachacun ne, cachjahma xu cha cojo xicjin cha cuitjin: ―‍Cha xi cuijyihi vi ne, tsingatihin cha visiajmi cha cojo xuta tsehen hacuaha jinëtangun cha cojo me. ―‍Cuatjin xu cachjahma cha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sehe ngajan xi Jesús ne, cachja xu me ngu ejemplu cojo cha xi cuacun vë cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―‍Cuejña ne xi ngu ngayun tjin nuju ngu cientu chu tsánga. Hane sá xi chajá ngu chu tsujun ne, hatuxa cuiyujuntuhun chu xi ñujuchan tyjuhunñuju jan nguijña ne, sehe cuangun cuinchunsun ngu chu xi cachajá jan hisca xi sacú nuju chu. ");
INSERT INTO maqNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hane xi sacú nuju chu ne, chjuhun chu cuesuntuhun chu xi jercu ndama nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hane xi cjuhun ndya nuju ne, nihñutangun yëjë xuta xi vinga nuju cojo me xi siu tahndee ndya nuju, hane cuitjin cuinújun cojo rë me: “Cuinechan cojo ná cjuasua ta casacu ná chu tsánga naha xi cachajá.” Cuatjin cuinújun. ");
INSERT INTO maqNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nguehe cuichjá cojo nuju ta hacuaha hitsë sa jyë cjuasua cuejña ngajan ngahnga ngatsë rë ngu xuta tsehen xi tsindeya me cjuatacun rë me xi cuma rë ngatsë rë ñujuchan tyjuhunñuju xuta ndaja xi tsajin mé má tsindeya me cjuatacun rë me. Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Hya xi camá ne, cuitjin cachja nga xu Jesús ngu ejemplu: ―‍Cuejña ne xi ngu chjuun jan ne, tjin rë me të tujún quicha xi jercu hnga chji rë. Hane sá xi tsichajá me ngu ne, hatuxa cuetaha rë me ndihi, sehe cuitecha me ndihya sehe cuanguise chichihin me hisca xi sacú rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hane xi sacú rë me ne, sahmitangun me yëjë xuta xi vinga rë me cojo me xi siu tahndee ndava me ne, hane cuitjin cuichja me cojo rë me: “Cuinechan cojo ná cjuasua ta casacu ná tujún naha xi catsichajá.” Cuatjin cuichja me. ");
INSERT INTO maqNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nguehe cuichjá cojo nuju ta hacuaha jemu jyë cjuasua cuiyuju ángel tsëhë Nina ngatsë rë ngu xuta tsehen xi tsindeya me cjuatacun rë me. Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hya xi camá ne, cuitjin cachja nga xu Jesús ngu ejemplu: ―‍Cuejña ne xi ngu me jan ne, tjin rë me jo quihndi. ");
INSERT INTO maqNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hane cavechú ngunixtin xi cha quihndi ngascan tsëhë me vihi ne, cachja cha cojo rë me cuitjin: “Papá, tsëhë yëjë ni xcusun xi satë ná hya xi cueyun ne, meje ná xi tuhun ná quihndë.” Cuatjin cachja cha. Sehe ngajan xi nahmi rë cha jan ne, cavatëcja me hacutjin xi satë rë xingu xingu quihndi rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hane hacuiin tsëë ni jan ne, cha quihndi ngascan jan ne, xi casahmi tangun cha yëjë xcusun xi casatë rë cha jan ne, sehe cavetju cha quiji cha ngu nangui cjin. Hane xi cafehe cha jan ne, sehe cavetsihin cha tujyë catsicojo cha tujún rë cha, casahmi cha yëjë ni hacutjin xi ndama rë xahasen rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hane xi cafë catsicojo cha tujún jan ne, hya canduva ngu jindya jyë jingujyë ni ladu vëhë. Hya cavetsihin camachaja rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hya xi camá ne, cavetsihin casahmi cha xá sacuaha mosu rë ngu me tsëhë nandya jan. Hane me vëhë catsingatju me cha xi cjue sahmi cuidadu cha chu chinga rë me ngajan ranchun. ");
INSERT INTO maqNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hane tsëhë xi jemu vojo camahani rë cha ne, hisca meje sinë cha xi tijinë chu chinga jan, peru tsajin yo casua rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Hane hya xi catsingataha cacun ndaja cha ne, cuitjin catsingataha cacun cha: “Yëjë mosu rë nahmi naha ne, tsajin mé machaja rë xi sinë, hane ngahan ne, tivéya jindya nguehe xi vojo ná. ");
INSERT INTO maqNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jemu sa rë ndaja ne, cúya cjuë́ nga ndava nahmi naha, hane cuitjin cuichjá cojo rë me: Cahndeen tsëhë Nina hacuaha cahndeen tsujun. ");
INSERT INTO maqNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ha quihndë vechiin chuva rë xi cuitejña cojo nuju sacuaha quihndi nuju. Nihñucuendun sacuaha xi mosu nuju ngahan quihndë xi cavúya.” Cuatjin catsingataha cacun cha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hya xi camá ne, sehe cavuya cafe cha nangui rë cha xi cjue cha ndava nahmi rë cha. ’Peru cjin sa cjui cha tsëhë ndava nahmi rë cha ne, cavëë nahmi rë cha xi nduva cha, hane jemu camayuma rë me cha. Sehe vanga me quijitjengui me cha, catsuvacja me cha hisca cavitatsuha me cha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Sehe ngajan xi cavetsihin cachja cha cojo nahmi rë cha cuitjin: “Papá, cahndeen tsëhë Nina hacuaha cahndeen tsujun. Ha quihndë vechiin chuva rë xi cuitejña cojo nuju sacuaha quihndi nuju.” Cuatjin cavetsihin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Peru nahmi rë cha ne, cachja me cuitjin cojo ngujo hndixahan rë me: “Tángunsanii, tángun chjuhun ngu tsjian xi tsjian ndaja jan ne, sehe nduvun nicujún cha quihndi naha vi. Hacuaha nduvuncujun ngu xtungun sehe teyun rcutsja cha, hacuaha nduvuncujun chuxinxtë xi cuinchun ntsacu cha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Xi camá vëhë ne, sehe tángun chjuhun ngu ndyaja xi ndaja hñu cacun chu cueya chu xinëë chu. Nihña ngu suhi, tahan cjuasua xahasen naja ta, ");
INSERT INTO maqNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","tsëhë xi cha quihndi naha vi ne, sacuaha xi cahme cha hane sehe cavuya cha cjuahñu, sacuaha xi cachajá cha hane sehe casacu nga cha.” Cuatjin cachja nahmi rë cha. Hya xi camá ne, sehe cavetsihin casahmi me suhi. ");
INSERT INTO maqNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Peru cha quihndi tjun rë me vihi ne, tsajin cha ta nguijña quiji cha. Hane xi camatiña cha tsëhë ndava cha xi cavuya cha xi quiji cha nguijña ne, cahndë cha xi fane tyjó ndava cha hacuaha titë́ xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hya xi camá ne, sehe cajindaya cha ngu cha hndixahan rë nahmi rë cha, sehe cavinenguise cha mé jima jan. ");
INSERT INTO maqNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hane cha hndixahan jan ne, cuitjin cafayangui cha: “Cha tsuhun cavuya cha. Hane hacuaha cavitexa nahmi nuju xi cahme ngu ndyaja xi ndaja hñu cacun xi cuma suhi, tsëhë xi cavuya cafahatsja nga me xingun cojo ngu cjuahñu ndajyihi.” Cuatjin cafayangui hndixahan jan. ");
INSERT INTO maqNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Peru cha quihndi tjun jan ne, jemu camacjan rë cha, hisca ndihya mijí cuisehen cha. Hane xi cavetju nahmi rë cha ne, jercu cjín cachja me cojo cha xi cuisehen cha ndihya. ");
INSERT INTO maqNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngajan xi cha vëhë ne, cuitjin cafayangui cha tsëhë nahmi rë cha: “Chutsujun ni, ngahan ne, ha jemu tsëë nduva nixtin xi tivisécoo nuju, hacuaha tsajin ngu cjua xi cahndeen tsujun xi canújun. Peru ngahan ne, hisca ngu tentsun catuun chu xi cueya chu xi sahme ngu suhi cojo amigu naha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Peru quihndë xi cafehe cha quihndi nuju vë xi tu ngajan quiji catsicjë cha cjuanchina nuju cojo yachjin tsehen jan ne, canicuhun ngu ndyaja hñu cacun xi xinu cojo cha.” Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Hya xi camá ne, cuitjin cachja nga nahmi rë cha: “Ngaye tsan xi nchunchujun ni nechin cojo ná ne, yëjë ni xi tsahan ne, hacuaha tsiji. ");
INSERT INTO maqNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ndatjin xi nihña ngu suhi cuitjin, cuinechan cjuasua ta, cha tsajan vi ne, sacuaha xi cahme cha peru cavuya cha cjuahñu, sacuaha xi cachajá cha peru casacu nga cha.” Cuatjin cachja nahmi rë cha. Vëhë xu ejemplu xi cachja Jesús cojo cha fariseo cojo cha xi vicuya cjuachacun. ");
INSERT INTO maqNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hacuaha cachja nga xu Jesús cojo xuta ladu rë me ngu ejemplu cuitjin: ―‍Cuejña ne xi cavéjña ngu xuta nchina xi hacuaha tjin rë me ngu cha xi matitjun tsëhë yëjë ni xa rë me. Hane cha xi matitjun tsëhë xa jan ne, cavinchajyë ngu xi cavinchajyë rë cha cojo me xi tsëhë xa tsëhë xi jemu catsicojo cha tujún rë me xi matsijin mé casahmi cha cojo. ");
INSERT INTO maqNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hane xi cajindaya me xi tsëhë xa jan cha ne, sehe cachja me cojo cha cuitjin: “Ngaye ne, cafahántsa ngu jyë́ riji. Quihndë ne, nihñi ná entregadu cuenta tsëhë xa xi tacun ntse ta, ngaye ne, ha quihndë cumaji cuihinnduju cojo xa xi nechintehe.” Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sehe ngajan xi cha xi matitjun tsëhë xa jan ne, cuitjin catsingataha cacun cha: “¿Mé xi ndatjin sahme quihndë xi tivaxëxin ná nai naha tsëhë xa xi tejñataha? Ngahan ne, maji sahme xa xi hai. Hacuaha sava ná cjuë́ cjuéhya caridad. ");
INSERT INTO maqNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Haan, ha hvë mé xi sahme cojo sa xi cjuahatsja ná xuta ndava me hya xi cuétjuxen tsëhë xa xi tejñataha.” Cuatjin catsingataha cacun cha. ");
INSERT INTO maqNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hya xi camá ne, cajindaya cha chuva ngu chuva ngu xuta xi quitjen tsëhë nai rë cha. Hane cuitjin cachja cha cojo ngu me: “Ngayun ne, ¿hacutjin quitjun tsëhë nai naha?” Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Sehe ngajan xi me xi quitjen jan ne, cuitjin cafayangui me: “Ngu cientu tonel tsëhë aceite.” Cuatjin cafayangui me. Hane cha xi matitjun tsëhë xa jan ne, cuitjin cachja cha cojo rë me: “Juhun xujun tsëhë cuenta nuju vi ne, tinechun sanii, nihñu sa ngu, hane tetuhun yachantë ni.” Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Hya xi camá ne, cachja nga cha cojo ngu nga me cuitjin: “Ngayun ne, ¿há cjín quitjun tsëhë nai naha?” Cuatjin cachja cha. Hane cuitjin cafayangui me xi quitjen jan: “Ngu cientu xutsu trigu.” Cuatjin cafayangui me. Hane cha xi matitjun tsëhë xa jan ne, cuitjin cachja cha: “Juhun xujun tsëhë cuenta nuju vi ne, nihñu sa ngu, hane tetuhun ñujuchan ni.” Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ngajan xi xuta nchina xi nai rë xa jan ne, cavaxëndaja me cha tsehen xi matitjun tsëhë xa ngatsë rë xi jemu quicun cacun cha xi cuatjin casahmi cha. Hitsë sa quicun cacun xuta tsehen cojo ngasunhndë rë me, xi cuma rë xuta xi fitjengui me ndiya rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Nguehe cuichjá cojo nuju ngayun xuta ladu naha ta hacuaha meje rë xi chjuhun tujún nuju, handasa hatuxa tsehen ta tsëhë xi tsëhë ngasunhndë, hane nicujunxun, cojo sa xi cuinga rë xuta ngayun. Cuatjin nihñu cojo sa xi hya xi cuechú nixtin xi cueyun hacuaha ha quihndë cumachjiriin nuju tujún ne, cjuahatsja nuju Nina ngajan hiscan xi cuinechan cojo rë me yëjë nu yëjë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Yo xi tjin rë cjuaquixi xi ndaja sahmi ngu xa xi chúva ne, hacuaha hatuxa tjin rë cjuaquixi xi ndaja sahmi ngu xa xi jyë. Hacuaha yo xi vindacha hya xi sahmi ngu xa xi chúva ne, hacuaha hatuxa vindacha hya xi sahmi ngu xa xi jyë. ");
INSERT INTO maqNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Vëhë xi ngayun ne, sá xi vindachun hya xi nicujunxun tujún tsehen xi tsëhë ngasunhndë ne, hatuxa cuejñaai Nina ntsun cjuanchina xi cjuaquixi, xi tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hacuaha sa xi vindachun hya xi nicujunxun cjuanchina tsëhë jingu sa ne, Nina ne, hatuxa suaain nuju me cjuanchina xi cuma tsujun suvun. ");
INSERT INTO maqNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Tsajin ngu hndixahan xi ma fahacuenda xa tsëhë jo nai rë xa ta, tsëhë xi choho scuëë rë ngu nai rë hane tsihmu cacun nai rë xi majo jan. O sá tsajin ne, jemu cuetaha yojo rë cojo ngu nai rë, hane nai rë xi majo jan ne, hisca sahmicuendaain rë. Vëhë xi xi ngu ñahñu ni ne, maji nihñu hacutjin xi meje rë Nina cojo hacutjin meje rë cjuanchina tsehen xi tsëhë ngasunhndë. Cuatjin xu cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Cha fariseo, xi hacuaha jemu chuya rë cha tsëhë tujún ne, cahndë xu cha yëjë cjua xi cachja Jesús cojo xuta ladu rë me jan. Hane cavejnucëë cha Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ngajan xi Jesús ne, cachja xu me cojo cha cuitjin: ―‍Ngayun xi nújun cojo xuta xi jemu ndaja xuta ngayun, peru Nina ne, vëë me cjuatacun xi jiya cahntsua xahasen nuju. Hane cjuatacun xi sahmi yehe sahmi hnga xuta ne, Nina ne, chuyiin camahani rë me tsëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Hya xi chaja sa tsujyihiya Juan Vitenda Xuta ne, yëjë xuta ne, casacu camachaya rë me cjua rë Nina ngatsë rë ley xi cavejña Nina tsja Moisés, cojo ngatsë rë profeta xi hacuaha cachja me cjua rë Nina. Hisca nixtin rë Juan ne, hisca quihndë ne, tisuá ngahan tijimachaya rë xuta cjuandajyihi xi chja xi Nina ne, sahmi me gubiernu. Hane yëjë ni xuta ne, meje cuisehen me hiscan sahmi Nina gubiernu, handasa cojo cjuachan. ");
INSERT INTO maqNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ngahnga cojo nangui ne, hitsë sa chjaain cjuë xi cuma rë xi chjaháxin rë ngu cjua tsëhë ley rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Ngu xuta xi tsismi me chjuun rë me sehe cuixan me cojo jingu sa chjuun ne, tangun me cojo ngu xi sahmi cjuatsehen cojo ngu chjuun xi hacuiin chjuun rë. Hacuaha yo xi cuixan cojo ngu chjuun xi xihin rë na ne, catsismi cha na ne, tangun cojo ngu xi sahmi cjuatsehen cojo ngu chjuun xi hacuiin chjuun rë. ");
INSERT INTO maqNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Cuejña ne xi cavéjña ngu cha xi jemu nchina, xi jercu ndaja camahani tsjian vajá. Nchunchujun ni ne, jemu ndajyihi suhi sahmi cha. ");
INSERT INTO maqNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hacuaha cavéjña ngu xuma cha yuma xi hmí rë Lázaro, xi jingujyë ni yojo rë cha camatsë. Hane jiña cha ngajan tingotjo ndava cha nchina jan. ");
INSERT INTO maqNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Hane hacuaha cojo cha yuma jan jemu meje sinë cha hitsë xi vangui jinë cha nchina jan. Hatuxa jemu choho vatju cha má, hisca vinduva naña chimajnu chu tsë xi yaja rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hya xi camá ne, xi cahme xuma cha yuma jan ne, quijicojo ángel hasen rë cha ngajan cahndë́ ndajyihi, cavéjña tangun cojo hasen rë nima Abraham. Hane cha nchina jan ne, hacuaha cahme cha, hane caseyaniji cha. ");
INSERT INTO maqNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Hane hya xi jiya hasen rë cha nchina jan cahndë́ hiscan xi fi hasen rë nima ne, jercu tivatju cjuañihi. Hane xi cavuya cavutsejenniji hasen rë cha ne, cavëë rë hasen rë nima Abraham tsëhë cjin ni, hacuaha cavëë rë hasen rë nima Lázaro, tacun tangun cojo hasen rë nima Abraham. ");
INSERT INTO maqNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hya xi camá ne, cajindaya hasen rë cha nchina jan tsëhë hasen rë nima Abraham, cuitjin cachja: “Tatá Abraham, catamayuma nuju ngahan ne, tinújun cojo cha Lázaro vë ne, catitsicahnchi cha rcutsja cha cojo nandá, sehe ningatjun cha catinduva catitsinguijnehnchan cha hitsë neje ta, tsëhë xi jercu má camahani ná cojo ndihi vi.” Cuatjin cachja hasen rë cha nchina jan. ");
INSERT INTO maqNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Peru hasen rë nima Abraham ne, cuitjin cafayangui: “Ninguitsjin tsan ta xcun cjuahñu riji ne, jemu ndaja cavatji camá, hane xuma cha Lázaro vi ne, jemu choho cavatju cha camá. Peru quihndë ne, tisacu rë cha cjuetacun nguehe, hane ngaye ne, tivatji cjuañihi. ");
INSERT INTO maqNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hacuaha tjin sa ngu cjua xi cuichjá cojo ri: Nina ne, cavejña me ngu xanga jyë xi jiyavasen tsëhë hiscan xi nechintihin ngayin cojo tsëhë hiscan xi nechintehe ngaye, cojo sa xi yo ngayin xi meje cuátjin xi cuinduvin ndyá ne, cumaji, hacuaha yo ngayun xi meje cuatjun cuinduvun nguehe ne, hacuaha cumaji.” Cuatjin cafayangui hasen rë nima Abraham. ");
INSERT INTO maqNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Sehe ngajan xi hasen rë cha nchina jan ne, cuitjin cachja: “Tatá, nihñu favor ne, ningatjun cha Lázaro ngajan ndava nahmi naha, ");
INSERT INTO maqNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","cojo sa xi sua cha cumachaya rë catsihñú xingueen xi siu jan, cojo sa xi hacuiin cojo cha cuechú cha cahndë́ vihi hiscan xi tacun cjuañihi xi tivatjin tijima.” Cuatjin cachja hasen rë cha nchina. ");
INSERT INTO maqNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Hane hasen rë nima Abraham ne, cuitjin cachja: “Peru cha xi cuacun vë ne, cuma cuisiñuju cha cjua xi ha catsihindu Moisés cojo cjua xi ha catsihindu profeta hatsëë nixtin. Vëhë catetaharcu cha.” Cuatjin cachja hasen rë nima Abraham. ");
INSERT INTO maqNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ngajan xi hasen rë cha nchina jan ne, cuitjin cafayangui: “Tatá Abraham, cumaji xi cojo cjua vëhë ni. Peru sá xi yo cuetju tsëhë ngajñi rë nima xi cjue cuichja cojo cha ne, ngajan xi tsindeya cha cjuatacun rë cha.” Cuatjin cafayangui hasen rë cha nchina jan. ");
INSERT INTO maqNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Peru hasen rë nima Abraham ne, cuitjin cachja: “Sá xi mijí cuihndë cha tsëhë cjua xi catsihindu Moisés cojo cjua xi catsihindu profeta ne, hacuanitjin ni cumacjaain rë cha, handasa ngu nima cuya cjuahñu, cjue cuichja cojo rë cha.” Cuatjin cachja hasen rë nima Abraham. Cuatjin xu fi cjua xi cachja Jesús cojo cha fariseo cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ngu nixtin jan ne, hacuaha cachja xu Jesús cojo xuta ladu rë me cuitjin: ―‍Hatuxa cuinduva xcusun xi meje sahmi xi nismetacuun ndiya rë Nina, peru jemu chojyihi tsëhë xuta xi nduvacojo xcusun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hitsë sa ndaja tsëhë xuta vëhë xi xtyangui ngu ndyojo natsi nguisin me sehe ningatjenya rë me ngajñi ndachacun, xi cuma rë xi sahmi me xi ngu xuta ladu naha tsismicacun me ndiya rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Nechun cuidadu tsëhë xcusun xi nihñu. Sá xi ngu xingun choho sahmi cojo nuju ne, tinújuntuhun rë. Hane sá xi tsindeya cjuatacun rë ne, ninchatuhun rë. ");
INSERT INTO maqNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Hane sá xi hisca yatu ndiya choho sahmi cojo nuju ngu nixtin, hane hacuaha jima ngu ndiya vëhë cjue cuichja cojo nuju xi tsindeya cjuatacun rë ne, ninchatuhun rë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ngajan xi apóstol ne, cuitjin xu cachja me cojo Nai naja: ―‍Nihñu xi hitsë sa ndaja cumangu tacuín cojo nuju. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sehe ngajan xi Nai naja ne, cuitjin xu cafayangui me: ―‍Sá xi mangutacún cojo ná ndastu hitsë ne, hacuaha cuma cuinújun cojo ya vihi catjixin tsëhë cahndë́ hiscan secun, hane catji catisecun ngajan ngajñi ndachacun, hane hacuaha cuihndë tsujun. ");
INSERT INTO maqNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Cuejña ne xi ngu ngayun ne, tjin nuju ngu hndixahan xi vacjan nangui tsujun o sá xi sahmi cuidadu rë chu nuju. Hane xi cjuehe hndixahan vëhë xi quiji nguijña ne, ¿há cuinújun cojo cuitjin: “Ndove sanii ne, xini niñu”? ");
INSERT INTO maqNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jéya, hacuiin ta cuitjin cuinújun cojo: “Tehe chjini xi sínë, hacuaha tehe chjini yojo riji xi cuindove chani xi sínë xi cuëhë, hane xi cuijnetaha sínë ne, sehe xini sihi ngaye.” Cuatjin cuinújun. ");
INSERT INTO maqNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hacuaha tuun nacuechji rë hndixahan vëhë tsëhë xi casahmi yëjë ni hacutjin xi cavitexun rë. ");
INSERT INTO maqNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hacuanitjin nuju ngayun ta hya xi ha cafë canihñu yëjë ni hacutjin cavitexa nuju Nina ne, cuitjin meje rë xi ningatuhuntacún: “Ngahan ne, ngu hndixahan tujyë ni ngahan ta xi casahme ne, hacutjin xi casatëxa ná ne, vëhë ni xi casahme. Cuatjin meje rë xi ningatuhuntacún.” Vëhë xu cjua xi cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hane hya xi tivatju xu Jesús vasencja tsëhë distritu Samaria cojo distritu Galilea xi cjui me ngajan Jerusalén ne, cuitjin camá. ");
INSERT INTO maqNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hora xi ha cuisehen me ngu nandya jan ne, nduvatjengui xu të cha me, cha xi yaha rë ngu xcusun chíhin vitaha xi setaha yojo naja. Hane caxinchacunhñu xu cha hitsë jan, ");
INSERT INTO maqNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","hane tsëhë cjin ni cajindaya xu cha cachja cha cuitjin: ―‍¡Tatá Jesús! ¡Catamayuma nuju ngayin! ¡Nihñu xi cumandaja ngayin! ―‍Cuatjin xu cajindaya cha cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hane xi cavëë Jesús cha ne, cuitjin xu cachja me: ―‍Tángun hiscan xi siu nahmi, ningacun rë me yojo nuju xi tsajin mé cún ngayun. ―‍Cuatjin xu cachja me. Hane ndiya cjui cha ne, camandaja xu cha. ");
INSERT INTO maqNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hya xi camá ne, xi cavëë xu ngu cha xi camandaja cha ne, cavuya quijitjengui xu cha Jesús, jindaya cha chja cha xi tisahmi jyë tisahmi hnga xu cha Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hane xi cafehe xu cha hiscan secun Jesús ne, quiji caticjaxcun cha xcun me, xi tisua cha nacuechji rë me. Cha xi cuajyihi jan ne, cha Samaria cha. ");
INSERT INTO maqNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sehe ngajan xi Jesús ne, cuitjin xu cavinenguise me xuta ladu rë me: ―‍¿Hacuiin yëjë të cha xi cuicun vi xi camandaja cha ni? ¿Cha xi ñaja sa ne, jarë cha ne? ");
INSERT INTO maqNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Há suvá ni cha xi cuijyihi vi xi ngu xutaxín cha xi cavuya cha xi sahmi jyë sahmi hnga cha Nina ni? ");
INSERT INTO maqNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sehe cachja xu me cojo cha xi camandaja jan cuitjin: ―‍Tisatjunhngun, hane tjangun. Ngatsë rë xi camangutacún cojo ná ne, vëhë xi camandaja ngayun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Cuitjin xu camá nga ngundiya. Cha fariseo ne, cavinenguise cha Jesús janihya cuinduva Nina sahmi me gubiernu. Sehe ngajan xi Jesús ne, cuitjin xu cafayangui me tsëhë cha: ―‍Nina ne, hya xi cuinduva me sahmi me gubiernu ne, hacuiin titjun sua me cumachaya naja sehe cuinduva me. ");
INSERT INTO maqNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tsajin yo cuichja: “Cuajyihi Nina nguehe”, o sá: “Cuajyihi Nina ngajan”; ta Nina ne, ha tisahmi me gubiernu ngajñi nuju. ―‍Cuatjin xu cachja me cojo cha fariseo. ");
INSERT INTO maqNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hya xi camá ne, cuitjin xu cachja me cojo xuta ladu rë me: ―‍Cuechú nixtin xi jemu cuma meje chutsujun ná ndastu ngu hora, ngahan xi Quihndi rë Xuta jain ngahan, peru cumaji. ");
INSERT INTO maqNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yahnga me cuichja me cojo nuju: “Cuajyihi me nguehe”, o sá: “Cuajyihi me ngajan”; peru hacuiin cuangun cojo me, hacuiin cuanguntjengun me ta ");
INSERT INTO maqNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","sacuaha sahmi hasen ndihichuhún xi ha tu ñahñu sahmi hasen rë jingujyë ni ngahnga, hisca nguehe hisca ngajan ne, cuatjin ha tu ñahñu scutsejen ná xuta tsëhë yëjë ni ladu hya xi cuechú nixtin xi cuinduva nga ngahan xi Quihndi rë Xuta Jain ngahan. ");
INSERT INTO maqNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Peru chaja sa xi cuechú nixtin vëhë ne, hatuxa meje rë xi jemu cjín cjuañihi cuátju cuma, hacuaha xuta xi siu nixtin vihi ne, tsitjungui ná me. ");
INSERT INTO maqNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sacuatjin casahmi xuta nixtin hya xi cavéjña xutachanga naja Noé ne, hacuanitjin ni sahmi xuta hya xi ngahan cuinduva. ");
INSERT INTO maqNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nixtin rë Noé vë ne, jinë jihvi xuta, vixan me, tsinguixan me quihndi rë me. Cuatjin sahmi cuaha me hisca nixtin xi cavisehen Noé cahntsua barcu, hacuaha casesuntë nandá, hane ngajan cafë yëjë xuta cahme me. ");
INSERT INTO maqNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hacuanitjin ni xcusun vëhë casahmi xuta nixtin hya xi cavéjña ngu xutachanga xi hmí rë Lot: jinë hvi me, vatsë me, viteña me, vincha me tjë, hacuaha sahmi me ndihya. ");
INSERT INTO maqNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Peru nixtin xi cavetju Lot tsëhë nandya Sodoma ne, cavixu ndihi tsëhë ngahnga, hacuaha cavixu ndyojo xi yaha rë ndihi, sacuaha xi cavaha ngu tsihñu, hane ngajan cafë yëjë xuta cahme me. ");
INSERT INTO maqNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Hacuaha cuanitjin ni sahmi xuta hya xi cuinduva ngahan xi Quihndi rë Xuta Jain ngahan. ");
INSERT INTO maqNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Nixtin hya ne, xuta xi hinchasun me rcu ndava me ne, mé tsëhë me xi siu cahntsua ndihya ne, miji rë xi cuitujne me cjue jaha me. Hacuaha ha chuva vëhë ni ne, xuta xi siutahá me nguijña ne, miji rë xi cuya cjue me ndava me. ");
INSERT INTO maqNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ninguitsjun sacuaha xcusun xi cavatju nima chjuun rë Lot. ");
INSERT INTO maqNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yo xi meje cjuenduju cojo ngasunhndë rë cojo ngahñu rë suvá ne, cuechintaain cjuahñu xatsë; peru yo xi cuatju cjuañihi o hisca cueya ngatsë naha ne, vëhë xi cuechútáha cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Nguehe cuichjá cojo nuju ta nguixun nixtin hya ne, jo xuta cuiyujufë tangun me ngu nachan. Ngu me ne, chjaháxin rë me, hane me xingu jan ne, cuejña me. ");
INSERT INTO maqNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hacuaha jo nga yachjin ne, cuiyujutahá na coho na. Ngu na ne, chjaháxin rë na, hane na xingu jan ne, cuejña na. ");
INSERT INTO maqNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hacuaha jo nga cha ne, cuiyujutahá cha nguijña. Ngu cha ne, chjaháxin rë cha, hane cha xingu jan ne, cuejña cha. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hane xuta ladu rë me ne, cuitjin xu cavinenguise rë me: ―‍¿Hane jani cuma xcusun vëhë ni, tatá? ―‍Cuatjin xu cavinenguise me. Sehe ngajan xi Jesús ne, cachja xu me ngu ejemplu cuitjin: ―‍Hiscan jiña chu xi cahme ne, hacuaha ngajan matangun chu lote. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Hacuaha cachja sa xu Jesús ngu ejemplu cojo xuta ladu rë me xi sua me cumachaya rë xi meje rë xi yasen ni ne, sahmi me oración rë me, miji rë xi sahmi chúva cacun me. ");
INSERT INTO maqNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Cuitjin xu cachja me: ―‍Cuejñaa ne xi ngu nandya jan ne, tjin ngu juez xi tsacjuiin rë Nina hacuaha faharcuaain rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hacuaha nandya jan ne, tacun ngu chjuun cahan. Hane nchunchujun ni quiji na xcun juez jan ne, cachja na cuitjin: “Meje ná xi nihñucuendun jyë́ xi vincha xuta tsahan.” Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Peru juez jan ne, jemu jyë nixtin xi mijí sahmicuenda me tsëhë na. Peru xi camá ngascan ne, cuitjin catsingataha cacun me: “Handasa tsacjuun Nina hacuaha faharcuun xuta ne, ");
INSERT INTO maqNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","peru ngatsë rë xi jemu tisuaxti na cahan vi ngahan ne, vëhë xi cjuahácuenda cjuacjintacun rë na, sá tsajin ne, jemu tsijenda na ngahan xi ngajan cjui ngajan nduva na.” Cuatjin xu catsingataha cacun me. ");
INSERT INTO maqNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sehe ngajan xi Nai naja ne, cachja sa xu me cuitjin: ―‍Chutsujun hacutjin chja juez tsehen vë. ");
INSERT INTO maqNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nina ne, ¿hacuiin hatuxa cjuahacuenda me cjuacjintacun rë xuta xi cavaxijin me, xi nguixun nguitajñu fehya rë me xi cjuahacuenda me tsëhë? ¿Há jemu cuindeya cjuahacuenda me? ");
INSERT INTO maqNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nguehe cuichjá cojo nuju ta Nina ne, ngutjen ni cjuahacuenda me. Peru hya xi cuinduva nga ngahan xi Quihndi rë Xuta Jain ngahan ne, ¿há tjin xuta xi mangucacun cojo ná nguehe ngasunhndë? ―‍Cuatjin xu cachja Nai naja. ");
INSERT INTO maqNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Hacuaha siu sa xu ngujo xuta xi tsingataha cacun suvá me xi tsajin jyë́ rë me xcun Nina hacuaha sahmi xta me cojo xuta xi yahnga. Hane xuta xi cuacun vë ne, cuitjin xu cachja Jesús ngu ejemplu cojo rë me: ");
INSERT INTO maqNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―‍Cuejña ne xi jo cha jan ne, quiji cha yungun xi matitjun xi sahmi cha oración rë cha. Ngu cha ne, cha fariseo cha, hane cha xingu ne, cha faha tujúnsa cha. ");
INSERT INTO maqNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Cha fariseo jan ne, cavisecun cha casahmi cha oración rë cha cahntsua xahasen ni rë cha, cachja cha cuitjin: “Ngayun Nina, suá nacuechji nuju ta ngahan ne, hacuiin tangun ngahan cojo jingu sa cha xi ndacha cha, tsehen cha, tsindesu cha cojo jingu sa chjuun, hacuaha hisca tanguaain ngahan cojo cha faha tujúnsa vi. ");
INSERT INTO maqNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sahme xun naha jo ndiya xi ngu totje, hacuaha vátëcja të cahndë́ tsëhë yëjë ni xi sacu ná, hane suá nuju ngu cahndë́.” Cuatjin casahmi cha fariseo oración rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Peru cha faha tujúnsa ne, hitsë ni cjin secun cha, hacuaha hisca cavuyaain cavutsejen cha ngahnga ta tu cavisanetsja ni cha rcu cha, cachja cha cuitjin: “Ngayun Nina, catamayuma nuju ngahan xi jemu tjin jyë́ naha.” Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Cuichjá cojo nuju ta cha faha tujúnsa jan ne, xi tu cavuya cafe cha ndava cha ne, ha cafë jyë́ rë cha xcun Nina, peru cha fariseo jan ne, hacuiin cuatjin cafë jyë́ rë cha. Cuatjin camá ta, tsëhë xi yëjë xuta xi sahmi yehe suvá me yojo rë me ne, cuechú nixtin xi Nina ne, tsinguijne me cjuatacun rë. Hane xuta xi tsinguijne suvá me yojo rë me ne, Nina ne, sahmi jyë rë me. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hacuaha cjuicojo xu xuta nixti rë me hiscan tacun Jesús xi cuisanetsja me nixti jan. Peru hya xi cavëë xu xuta ladu rë Jesús xi cuatjin cjui xuta cojo nixti rë me ne, cavatëcja xu me cjuatacun rë xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Peru Jesús ne, cajindaya xu me nixti jan xi cjuetjengui rë me, sehe ngajan xi cachja xu me cojo xuta ladu rë me cuitjin: ―‍Tuhun rë nixti cahndë́ catinduva tjengui ná. Xicanichuun rë cahndë́ ta, tsëhë xi nixti xi cuacun ne, hatuxa visehen ngajan hiscan xi sahmi Nina gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cuichjá cojo nuju cjuaquixi ta suvá ni xuta xi tsingatihin me xi sahmi Nina me gubiernu sacuatjin tsingatihin nixti ne, me vëhë ni xi cuisehen me hiscan xi sahmi Nina gubiernu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ngu xuta xi matitjun ne, cavinenguise xu me Jesús cuitjin: ―‍Ngayun Maestro, jemu ndaja ngayun. ¿Mé xi meje rë xi sahme cojo sa xi sacú ná cjuahñu xatsë? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sehe ngajan xi Jesús ne, cuitjin xu cafayangui me: ―‍¿Mé má cuatjin nújun xi ndaja ngahan? Tsajin yo xi ndaja. Ngu ni Nina xi ndaja me. ");
INSERT INTO maqNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ngayun ne, ha hyun hacutjin chja ley rë Nina xi chja cuitjin: “Xicanihñuu cjuatsehen cojo rë ngu chjuun o cojo rë ngu xihin xi hacuiin tsujun, xicanicuun xuta, xicanihñuu cjuachëjë, xicanujuun cjuandesu tsëhë xuta, chjuhunrcun nahmi nuju hacuaha chjuhunrcun na nuju.” ―‍Cuatjin xu cachja Jesús cjua rë ley rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hane ngajan xi xuta xi matitjun jan ne, cuitjin xu cachja me cojo Jesús: ―‍Yëjë cjua vëhë ne, ha cáhndë tsëhë hisca cjualihndi naha. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hane xi cahndë xu Jesús cjua rë me ne, sehe cachja xu me cuitjin: ―‍Tjin sa ngu cjua xi machaja nuju: yëjë ni xcusun xi tjin nuju ne, titeñu, hane sehe tichuncjun tujún rë ngajñi rë xuta yuma. Hane xi cuatjin nihñu ne, jemu jyë cjuanchina sacú nuju ngajan ngahnga. Hane xi cjuë cuichuncjun tujún vëhë ne, sehe nduvun tisecun ná. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Peru xi cahndë xu xuta xi matitjun jan cjua xi cachja Jesús ne, jemu va camá cacun me, tsëhë xi jercu nchina camahani me. ");
INSERT INTO maqNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hane xi vutsejen xu Jesús xi jemu va camá cacun xuta xi matitjun jan ne, sehe cachja xu me cuitjin: ―‍Jemu chja xi ngu xuta xi tjin rë me cjuanchina cuisehen me hiscan sahmi Nina gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ha hitsë sa chjaain cuatju ngu chu camellu ngojo rë ngu níndu xi cuma rë xi cuisehen ngu xuta nchina hiscan sahmi Nina gubiernu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ngajan xi xuta xi cahndë me cjua jan ne, cuitjin xu cachja me: ―‍Sá cuatjin ne, ¿yo xi cuma cuetjutje ni? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Hane Jesús ne, cuitjin xu cafayangui me: ―‍Yëjë ni xi maji sahmi xuta ne, Nina ne, hatuxa ma sahmi me. ―‍Cuatjin xu cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ngajan xi Pedru ne, cuitjin xu cachja me cojo Jesús: ―‍Chutsujun ni. Ngayin ne, ha canismitacuín yëjë ni xcusun xi tjin niji, hane tivisecuin nuju. ―‍Cuatjin xu cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Hane Jesús ne, cuitjin xu cachja me: ―‍Cuichjá cojo nuju cjuaquixi ta yëjë xuta xi tsismicacun me ndava me, tsismicacun me chjuun rë me, tsismicacun me xicjin me, tsismicacun me xutacha rë me, tsismicacun me quihndi rë me, xi cjuetjengui me ndiya rë Nina ne, ");
INSERT INTO maqNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hatuxa cjín sa cahndë́ sacú rë me xi cuma sacuaha ndava me, hacuaha hatuxa cjín sa xuta sacú rë me xi cuma sacuaha xuta rë me, quihndë xi siu me ngasunhndë vihi, hane hya xi cueya me ne, sacú rë me ngu cjuahñu xatsë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hya xi camá xu ne, quijicojoxin Jesús tejó xuta ladu rë me, sehe cachja xu me cojo cuitjin: ―‍Quihndë ne, tivanguen Jerusalén. Hane xi cjuehen jan ne, cuetjucaa yëjë sacuatjin catsihindu profeta tsahan, ngahan xi Quihndi rë Xuta Jain ngahan. ");
INSERT INTO maqNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ngahan ne, cuma ngahan entregadu tsja xutaxín, cuejnucëë ná xuta, choho cuichja me tsahan, cuëhënatya ná me. ");
INSERT INTO maqNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hane xi cjuë cuaja ná me ne, sehe tsiquehen ná me. Peru xi ma jyan nixtin ne, cúya nga cjuahñu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Peru xuta ladu rë me jan ne, hisca ngu xu cjua vëhë cajnii rcu me ta tjihma cjuatacun vëhë xi cuma rë me. Vëhë xi hvíin xu me mé vijne cjua xi cachja Jesús jan. ");
INSERT INTO maqNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hya xi camá ne, xi camatiña xu Jesús tsëhë nandya Jericó cojo xuta ladu rë me ne, ngajan tacun xu ngu cha rcá tjehen ndiya, fehya cha caridad. ");
INSERT INTO maqNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hane xi cahndë cha xi jercu cjín xuta fane ntsacu me ne, sehe cavinenguise xu cha mé jima jan. ");
INSERT INTO maqNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hane tjin xu yo cachja cojo cha xi Jesús tsëhë nandya Nasaret tivatju me cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hane cha rcá jan ne, cuitjin xu cajindaya cha cachja cha: ―‍¡Ngayun Jesús, tjë rë David! Catamayuma nuju ngahan. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hane xuta xi cjui titjun jan ne, cavisiajmi cjan xu me cojo cha xi sejyu cha. Peru cha vëhë ne, hitsë sa jercu cajindaya xu cha cachja cha, cuitjin cachja cha: ―‍¡Ngayun tjë rë David! Catamayuma nuju ngahan. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ngajan xi Jesús ne, xi casecunhñu xu me ne, sehe cavitexa me xi cuinduva cojo xuta cha rcá jan hiscan xi secun me. Hane xi camatiña cha tsëhë Jesús ne, sehe cavinenguise xu me cha cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―‍¿Mé xi meje nuju xi sahme cojo nuju ni? ―‍Cuatjin xu cavinenguise me. Sehe ngajan xi cha rcá jan ne, cuitjin xu cachja cha: ―‍Tatá. Meje ná xi cuma tsejen nga ná. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hane Jesús ne, cuitjin xu cachja me cojo cha: ―‍Catamatsejen nga nuju. Ngayun ne, camandaja túxcun ta, tsëhë xi camangutacún cojo ná. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hane ha hora vëhë ni ne, camatsejen nga xu rë cha. Sehe quiji xu cha cojo Jesús táha sahmi jyë sahmi hnga cha Nina. Hane xi cavëë yëjë xuta xcusun xi camá jan ne, jemu cavaxëndaja xu me Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hya xi camá ne, cavisehen xu Jesús nandya Jericó xi cuatju me vasencja nandya. ");
INSERT INTO maqNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hane ngajan tacun xu ngu cha xi hmí rë Zaqueo, ngu cha xi matitjun tsëhë cha faha tujúnsa, hacuaha jemu nchina cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Hane cha vëhë ne, jemu meje scuëë xu cha yo xi Jesús, peru camaji ta, tsëhë xi jercu cjín camahani xuta quitsë me, hacuaha cha vëhë ne, jemu patú xu cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hane xi cavangatitjun cha ne, quiji camiji xu cha ngu ya jyë, cojo sa xi cuma scuëë cha Jesús ta, tsëhë xi hatuxa ngajan cuatju me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hane xi cafehe xu Jesús jan ne, sehe cavuya cavutsejenniji me rcu ya hiscan quisun cha ne, sehe cachja xu me cojo cha cuitjin: ―‍Zaqueo, nduvunjnu sanii ta, tsëhë xi sahmi ná ngujyë xi ndya nuju cuitejña quihndë. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ngajan xi cha Zaqueo ne, marcu macjain xu cavitujne cha, cafahatsja cha Jesús cojo yëjë ni cjuasua, quijicojo cha me ndava cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hane xi cavëë yëjë xuta xi cuatjin casahmi Jesús ne, sehe cachjahma xu me cojo xicjin me cuitjin: ―‍Quiji cavéjña me cojo ngu cha tsehen. ―‍Cuatjin xu cachjahma me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hya xi camá ne, xi ha tacun Jesús ndava cha Zaqueo ne, cavisatjenhnga xu cha, sehe cachja xu cha cojo Nai naja cuitjin: ―‍Chutsujun ni, tatá. Vasentjin tsëhë yëjë ni xcusun xi tjin ná ne, suá rë xuta yuma. Hane sá xi tjin yo xi cavaxë́ rë tujún cojo cjuandacha ne, ñuju cuatjin sacuatjin xi cafahá ne, tsicúya tsëhë me. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ngajan xi Jesús ne, cuitjin xu cachja me: ―‍Quihndë ta cuatjin ne, ngayujun ni tsëhë ndihya vihi ne, cavetjuntjun ta, me xi cuijyihi vi ne, hacuaha cojo me má me xuta ladu rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Hane ngahan xi Quihndi rë Xuta Jain ngahan ne, canduvá xi cuanguësë hacuaha cuaxë́tjë xuta ladu rë Nina xi cachajá me tsëhë ndiya rë Nina. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Xi tu cajnetaha cavisiñuju xuta cjua vëhë ne, Jesús ne, cachja sa xu me ngu ejemplu cojo xuta jan ta, tsëhë xi tiña siutahá me cojo nandya Jerusalén, hane má xu rë xuta ta ha hisca tacun xati xi cuinduva Nina sahmi me gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hane cuitjin xu cachja me: ―‍Cuejña ne xi ngu xuta chacun jan ne, quiji me ngu nangui cjin, xi cjuahaxa me xi cumatitjun me tsëhë estadu rë me, sehe cuya nga me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hane chaja sa xi cjue me ne, cajindaya me të hndixahan rë me, sehe casua rë me jima ngu hndixahan jan tujún. Sehe cachja me cojo cuitjin: “Nihñu xa cojo tujún vihi jinguyëjë rë xi cjuë́ sehe cúya.” Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Peru xuta tsëhë estadu rë me ne, jemu choho vëë rë me. Vëhë xi hya xi ha quiji xuta chacun ja ne, catsingatju xuta estadu rë me jan ngujo cha xi cuichja cha cuitjin cojo xuta xi suaxa rë xuta chacun jan: “Mamijí niji xi me xi cuajyihi vë cumatitjun me tsijin.” Cuatjin cuichja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hya xi camá ne, xi cavuya xuta chacun jan xi cafë cafahatsja me xa ne, cavitexa me xi chjindaya rë cha hndixahan rë me xi casua rë me tujún jan, cojo sa xi sua cha cumachaya rë me há cjín cavesun rë cha jima ngu cha xi casahmi cha xa cojo tujún xi casua me cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hane cha hndixahan xi canduva titjun ne, cuitjin cachja cha: “Tatá. Sacuatjin tujún xi catuhun ná ne, cavesun ná të cuatjin sa.” Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Sehe ngajan xi nai rë hndixahan jan ne, cuitjin cachja me cojo: “Ndatjin ri. Ngaye ne, ngu hndixahan ndaja ngaye. Ngatsë rë xi jemu ndaja canihñi xa xi chúva vë ne, suá ri të nandya xi cumatitjun ngaye tsëhë.” Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hane xi canduva cha xi majo ne, cuitjin cachja cha: “Tatá. Sacuatjin tujún xi catuhun ná ne, cavesun ná hñú cuatjin sa.” Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hane nai rë hndixahan jan ne, cuitjin cachja me: “Ngaye ne, cumatitjun ngaye tsëhë hñú nandya.” Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hya xi camá ne, xi canduva nga ngu cha ne, cuitjin cachja cha: “Tatá. Cuajyihi tujún xi catuhun ná nguehe. Tujún vi ne, cavinchándaja cahntsua ngu pañutu ta, ");
INSERT INTO maqNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tsëhë xi tsácjun nuju. Ta ngayun ne, jemu hñu cjua nuju. Tangun ngayun cojo ngu xuta xi fanga me handasa hacuiin me vëhë catsitjë me ta, tsëhë xi ngayun ne, hacjahi sahmi xa ne, ngayun chjuhunntsun chji rë.” Cuatjin cachja cha hndixahan vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ngajan xi xuta chacun jan ne, cuitjin cachja me cojo hndixahan vëhë: “Ngaye, hndixahan tsehen ne, cojo cjua riji sove ni tsichúva ri. Ngaye xi noje xi hye xi jemu hñu cjua naha, hacuaha tangun ngahan cojo ngu xuta xi fanga me handasa hacuiin me catsitjë me, tsëhë xi ngahan ne, hacjahi sahmi xa ne, ngahan fahántsa chji rë. ");
INSERT INTO maqNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Sá xi hye xi cuatjin ne, ¿mé má hacuiin xcun bancun cahmi chani tujún xi casuá ri, cojo sa xi hya xi cjuëhë ne, cúya cjuahántsa tujún naha, peru cojo quihndi rë ni?” Cuatjin cachja xuta chacun jan cojo hndixahan rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sehe cachja sa me cojo ngujo hndixahan rë me xi hinchacun jan cuitjin: “Chjuhuntuhun tujún xi yaha cha vë ne, sehe tuhun rë cha xi cavesun rë të cuatjin sa sacuatjin tujún xi casuá rë.” Cuatjin cachja xuta chacun jan. ");
INSERT INTO maqNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Hane hndixahan jan ne, cuitjin cafayangui: “Tatá. ¡Peru cha vëhë ne, ha tjin rë cha të cuatjin sa!” Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ngajan xi xuta chacun jan ne, cuitjin cachja me: “Nguehe cuichjá cojo nuju ta yëjë xuta xi cavesun rë me xcun xi ha tjin rë me ne, suá sa rë me. Hane xuta xi tsajin mé cavesun rë me ne, hisca xi tjin rë me ne, cjuahátahá. ");
INSERT INTO maqNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hane sacuaha condra naha xi mijí rë xi ngahan cumatitjun ngahan tsëhë ne, tángun chjuhun, nduvuncujun nguehe, sehe nicuhun nguehe xcún.” Cuatjin cachja xu xuta chacun xcun ejemplu xi cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hya xi camá xu ne, xi cavatju cachja Jesús cjua vëhë ne, sehe cavetju me quiji sa xu me xi cjuehe me Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hane hya xi camatiña me tsëhë nandya Betfajé cojo nandya Betania, nandya xi siu tiña tsëhë ndetjún xi hmí rë Ndetjún Olivu ne, sehe catsingatju xu me jo xuta ladu rë me xi cjue tixa rë me, ");
INSERT INTO maqNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","hane cuitjin xu cachja me: ―‍Tángun nandya xi tsejen tacun vë. Hane xi cjuhun jan ne, ngajan cuechuntuhun ngu chu burru xatsë, xi hisca ngu cjëë cuijin rë chu, tjihñu chu. Hane chundecjun chu, nduvuncujun chu. ");
INSERT INTO maqNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Hane sá xi yo cjuinenguise nuju mé má cuatjin chundecjun chu ne, sehe tinújun cuitjin: “Nai niji meje rë me chu.” Cuatjin tinújun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hane me xi casatëxa rë jan ne, quiji xu me, hane cavetjucaa jain sacuatjin cachja Jesús cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hane jinguyëjë rë xi tivundecja me burru jan ne, nai rë chu ne, cuitjin xu cachja me: ―‍¿Mé má cuatjin chundecjun burru vë? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hane xuta ladu rë Jesús jan ne, cuitjin xu cafayangui me: ―‍Nai niji meje rë me chu. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sehe quijicojo xu me chu hiscan tacun Jesús. Hane caviyujusun me tsjian rë me ngaxtun chu, sehe catsiquijin xu me Jesús burru jan. ");
INSERT INTO maqNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hane xi cjui Jesús quisun me burru jan ne, táha ticandi xu xuta tsjian rë me hiscan cjui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ngajan xi xi jima tiña xu Jesús cojo yëjë xutacjín jan nandya Jerusalén, hiscan xi cafaha rë xi ha cuitsingaxten ndiya tsëhë Ndetjún Olivu ne, yëjë ni xutacjín xi xuta ladu rë Jesús jan ne, jercu ndama xu rë me, hisca cavetsihin cajindaya me cachja me xi cavaxëndaja me Nina tsëhë yëjë ni cjuarcun xi cavëë me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Cuitjin xu cachja me: ―‍Jemu catsinchacun Nina me xi nduva vi xi cuma titjun tsajan, tsëhë xi Nina catsingatju rë me. Ngahnga ne, hatuxa jemu tjin cjuandaja cjuajeya, hacuaha Nina ne, hatuxa jyë hnga me cojo Hasen rë me. ―‍Cuatjin xu cavaxëndaja xuta Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hane ngujo cha fariseo xi hinchajñi ngajñi rë xutacjín jan ne, cachja xu cha cojo Jesús cuitjin: ―‍Maestro, tichuncjun cjua xi tichja xuta ladu nuju vë. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hane xi cafayangui Jesús ne, cuitjin xu cachja me: ―‍Nguehe cuichjá cojo nuju ta sá xi xuta xi cuicun vi sejyu me ne, ndyojo vi cuetsihin squindaya cuichja nga. ―‍Cuatjin xu cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hane xi camatiña sa xu Jesús tsëhë Jerusalén ne, xi cavëë me nandya jan ne, cajihnda xu me ngatsë rë. ");
INSERT INTO maqNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Sehe cachja xu me sacuaha xi tichja me cojo xuta Jerusalén, cuitjin xu cachja me: ―‍¡Sá mé ni xi hacuaha cojo ngayun hyun cjuatacun xi yaha cjuandaja cjuajeya! Peru quihndë matsejen ne, cjuatacun vëhë matsejen ne, jiyahma xi cuma nuju. Vëhë xi hyúun. ");
INSERT INTO maqNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Peru cuechú nixtin xi yëjë ni condra nuju matsejen ne, sahmi me ngujyë xi cuma cuisehen me nandya nuju, xinchandee nuju me yëjë ni ladu xi cuinchahñu nuju me. ");
INSERT INTO maqNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tsixujne me yëjë ni ndihya tsëhë nandya nuju, tsicanguiin me hisca ngu ndyojo xi tinecoo, hacuaha tsiquehen nuju me ngayujun ni xi nechun nandya nuju. Cuatjin cuatjun cuma matsejen ta, tsëhë xi ngayun matsejen ne, cajnii rcun hya xi cafehe Nina xi cuaxëtje nuju me. Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hane xi cafehe me nandya Jerusalén ne, sehe quiji xu me yungun xi matitjun. Hane xi cavisehen me ndatsen yungun jan ne, cavetsihin cavaxë me xuta xi sahmi ndetsin jan. ");
INSERT INTO maqNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Cuitjin xu cachja me: ―‍Cuitjin camahindu xcun xujun rë Nina sacuatjin xi cachja me: “Ndya naha ne, vejña xa xi cjue xuta sahmi me oración rë me.” Cuatjin chja Nina. Peru ngayun ne, tinihñuxun cojo sacuaha ngu cahndë́ hiscan xi matangun xuta chëjë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hya xi camá ne, nchunchujun xu ni quiji Jesús cavicuya me xuta ngajan ndatsen yungun xi matitjun. Hane yëjë ni nahmi xi matitjun cojo yëjë cha xi vicuya cjuachacun cojo yëjë sa xuta xi matitjun ne, jemu cavangui xu me chuva rë xi tsiquehen me Jesús, ");
INSERT INTO maqNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","peru casacuinyiin xu rë me mé sahmi me ta, tsëhë xi yëjë ni xuta ne, tivisiñuju xu me cjua rë Jesús nguñaja cacun me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Cuitjin camá xu ngu nixtin hya xi tivicuya Jesús xuta hacuaha tisua me jimachaya rë cjuandajyihi rë Nina ngajan ndatsen yungun xi matitjun. Hacuaha camatangun xu nahmi xi matitjun cojo cha xi vicuya cjuachacun cojo xuta changá, ");
INSERT INTO maqNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","hane cuitjin xu cavinenguise me Jesús: ―‍Tinújun cojo niji ne, ¿yo cavitexa nuju xi cuatjin nihñu? ¿Yo casuaxa nuju? ―‍Cuatjin xu cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Hane xi cafayangui Jesús ne, cuitjin xu cachja me: ―‍Hacuaha cjuinenguësë nuju ngu cjua, hane chjayunngun tsahan: ");
INSERT INTO maqNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Yo cavitexa rë Juan xi cuitenda me xuta? ¿Há Nina ne, o há tsajin ne, há xuta? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sehe ngajan xi xuta xi cuacun jan ne, cavisiajmicjín me ngajñi rë me, cachja xu me cuitjin: ―‍Sá xi cuinújan xi Nina cavitexa me cha Juan vë ne, cjuinenguise naja me: “¿Mé má camacjaain naja cha?” ");
INSERT INTO maqNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Hane sá xi cuinújan xi xuta cavitexa rë cha ne, yëjë ni xuta ne, tsiquehen naja me cojo ndyojo ta, tsëhë xi yëjë ni xuta ne, ha macjain rë me xi cha vëhë ne, profeta cha. ―‍Cuatjin xu cavisiajmicjín me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ngajan xi xuta xi cuacun jan ne, cachja me xi hvíin me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sehe ngajan xi Jesús ne, cuitjin xu cachja me: ―‍Sá cuatjin ne, ngahan ne, hacuaha cuichjaan cojo nuju yo cavitexa ná xi cuitjin sahme. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hya xi camá ne, cavetsihin cachja xu Jesús cojo yëjë ni xuta jan ejemplu vihi: ―‍Cuejña ne xi ngu me jan matsejen ne, catsitjë me xcun nangui rë me xca rë uva. Sehe casua me ngujo cha sahmixa xi cjuahacuenda cha sehe cjuaha tsë tsë me cojo cha. Hya xi camá ne, sehe cavetju me quiji me ngu nangui jemu tsëë camahani. ");
INSERT INTO maqNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hane xi cavechú nixtin rë tutjë́ jan matsejen ne, sehe catsingatju me ngu mosu hndixahan rë me xi quiji cachja cha cojo cha xi fahacuenda xitjë jan xi sua cha hitsë tutjë́ xi satë rë me xi casacu rë cha xcun nangui rë me jan. Peru cha xi fahacuenda xitjë jan matsejen ne, tu cavaja cha cha hndixahan jan, sehe catsingatju cha cafe, ndastu mé casua rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hya xi camá ne, cavuya catsingatju nga me ngu hndixahan rë me. Hndixahan vëhë matsejen ne, jemu cavaja rë cha, jemu choho cachja cha cojo, sehe catsingatju cha cafe, ndastu mé casua rë cha. ");
INSERT INTO maqNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hya xi camá ne, cavuya catsingatju nga me ngu hndixahan xi majyan. Hndixahan vëhë matsejen ne, jemu cavanguihmu rë cha, sehe cavaxëxin cha tsëhë ngajan. ");
INSERT INTO maqNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ngajan xi nai rë xitjë jan matsejen ne, cuitjin catsingataha cacun me: “¿Mé xi ndatjin sahme quihndë? Ndatjin rë xi tsingátju quihndi naha xi jemu hmú cácun. Cjuaharcun rë cha, xi quihndi naha.” Cuatjin catsingataha cacun me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Peru xi cavëë cha xi fahacuenda xitjë jan cha vëhë matsejen ne, sehe cavisiajmicjín cha cojo xicjin cha cuitjin: “Cha vihi ne, quihndi rë me xi cuahatsja cha xitjë vi. Niquen cha, cojo sa xi tsajan cuma nangui vi.” Cuatjin cavisiajmicjín cha. ");
INSERT INTO maqNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hane xi cavaxëxin cha cha tsëhë nangui jan matsejen ne, sehe catsiquehen cha. ’Xi má nuju matsejen ne, ¿mé sahmi nai rë xitjë jan cojo cha xi cuacun fahacuenda jan? ");
INSERT INTO maqNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cjue tsiquehen me cha, sehe sua me xitjë jan cjuahacuenda jingu sa cha sahmixa. ―‍Cuatjin xu cachja Jesús. Hane xi cahndë yëjë xuta cjua vëhë ne, cachja xu me cuitjin: ―‍¡Catamamiji cacun Nina xi cuatjin cuma! ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ngajan xi xi cavuya vutsejen Jesús xuta jan ne, cuitjin xu cachja me: ―‍¿Mé vijne xi cuitjin camahindu xcun xujun rë Nina?: Ndyojo xi catsitjungui chjinevexo ne, vëhë ndyojo xi cavéjña tjun tjun yuju rë xihndënaña. Cuatjin camahindu. ");
INSERT INTO maqNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hya xi ngu xuta cjuinenguisun me xcun ndyojo vëhë matsejen ne, cuatëlanga rë me. Hane hya xi ndyojo vëhë cjuinenguisun rë ngu xuta matsejen ne, ña cuma të me. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Vëhë xi cha xi vicuya cjuachacun cojo nahmi xi matitjun ne, jemu cavangui xu me chuva rë hacutjin cuma xi cjuaha me Jesús hora vëhë ni, tsëhë xi vëë me xi ejemplu xi cachja Jesús ne, condra rë me chja. Peru tsëhë xi tsacjun xu me xuta ne, vëhë xi cafaain xu me Jesús ngutjen. ");
INSERT INTO maqNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tu siu xu ni me cuidadu tsëhë cjua rë Jesús, hisca catsingatju xu me ngujo cha xi tsejen sacuaha xuta ndaja, xi cuangui cha chuva rë xi cuaxë rë cha Jesús ngu cjua xi cuaaintjin, cojo sa xi cuma chjahá rë me cjuechani rë me xcun xutaxa rë ndihyavasen. ");
INSERT INTO maqNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hane cha xi cuacun jan ne, cuitjin xu cachja cha cojo Jesús. ―‍Maestro, ngayin ne, hyin ta ngayun ne, vicuyun rë xuta cojo cjuaquixi. Hacuaha tangun ni nújun cojo yëjë xuta ta, tsëhë xi ngayun ne, hatuxa vicuyun ndiya rë Nina cojo cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Quihndë ne, sacuaha ley rë Moisés ne, ¿há sua cahndë́ xi cuechjen tujúnsa naja cojo César, me xi matitjun, o há suaain cahndë́? ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Peru Jesús ne, tsëhë xi ha vacun rë me xi jemu ndacha cha ne, cuitjin xu cachja me cojo cha: ");
INSERT INTO maqNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―‍Ningacun ná ngu tujún. Quihndë ne, ¿yo xcusun rë hacuaha yo ñihi rë xi quitahá xcun tujún vë? ―‍Cuatjin xu cavinenguise Jesús. Hane cha xi cuacun vë ne, cuitjin xu cafayangui cha: ―‍Tsëhë César. ―‍Chja xu cha. ");
INSERT INTO maqNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo cha: ―‍Sá xi cuatjin ne, tuhun rë César xi tsëhë me, hane tuhun rë Nina xi tsëhë me. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hane camaji cavaxë xu rë cha Jesús ngu cjua xi cuaaintjin xi cuihndë xuta. Hane xi quijircun xu rë cha tsëhë cjua xi cafayangui Jesús ne, tu caviyujujyuu xu ni cha. ");
INSERT INTO maqNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hya xi camá ne, cafehe xu ngujo cha saduceo hiscan tacun Jesús. Cha xi cuicun vi ne, vicuya cha cjuachacun xi chja xi xuta xi cahme ne, cuyaain nga me cjuahñu. Ngajan xi cha xi cuacun cafehe jan ne, cachja xu cha cojo Jesús cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―‍Maestro, Moisés ne, catsihindu me xcun xujun rë Nina xi sá xi ngu xihin cueya, hane tsajin rë chjuun rë hisca ngu quihndi ne, hntsë nima vëhë ne, meje rë xi cjuaha rë chjuun cahan vëhë, cojo sa xi sacú rë na quihndi xi cuma sacuaha quihndi rë nima vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Quihndë ne, cuejña xi ngu ndihya ne, siu yatu cha cojo hntsë cha. Hane cha tjun ne, cafaha cha chjuun. Peru cahme cha, hane chjuun rë cha vëhë ne, casacuiin rë na hisca ngu quihndi cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hya xi camá ne, hntsë nima vëhë, cha xi majo ne, cafaha cha na cahan vëhë camá chjuun rë cha na, peru hacuaha cahme cha hane casacuiin rë na quihndi. ");
INSERT INTO maqNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hacuanitjin ni cafaha cha xi majyan jan na hisca xi cafë yëjë xi yatu cha cafaha cha na. Peru yëjë cha xi cuacun vë ne, cafë cha cahme cha chuva ngu chuva ngu cha. Hane na vëhë ne, casacuiin rë na hisca ngu quihndi cojo cha xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hiscan xi cajnetaha ne, na vëhë ne, hacuaha cahme na. ");
INSERT INTO maqNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Quihndë ne, hya xi cuya yëjë nima cjuahñu ne, ¿jarë cha xi cuacun vë xi chjuun rë cha na xi cjuaquixi ta, tsëhë xi yëjë ni xi yatu cha ne, camá chjuun rë cha na? ―‍Cuatjin xu cachja cha saduceo cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo cha: ―‍Xuta xi siu me ngasunhndë quihndë ne, tsinguixan me hacuaha vixan me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Peru xuta xi vechú chuva rë xi cuya me cjuahñu xi ha cuatju cueya me hacuaha sacú rë me cjuahñu xatsë ne, cuixaain me hacuaha tsinguixaain me hya ta, ");
INSERT INTO maqNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","tsëhë xi ha quihndë cueyaain nga me, tsëhë xi tangun cuma me cojo ángel. Hacuaha cuma me quihndi rë Nina, tsëhë xi cuya me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hacuaha hya xi chutayan cjua xi cachja Moisés ngajan hiscan xi catí yanahyá xcuen ne, hya sacu machaya naja tsëhë xi nima ne, cuya cjuahñu ta, tsëhë xi cachja Moisés xi Nina naja ne, Nina rë Abraham, Nina rë Isaac, cojo Nina rë Jacob má me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Peru Nina ne, hacuiin nina rë nima ta nina rë xuta xi quicun me ta, tsëhë xi xi cuma rë Nina ne, yëjë ni xuta ne, quicun me, handasa cahme yahnga me. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ngajan xi ngujo cha vicuya cjuachacun ne, cuitjin xu cachja cha: ―‍Maestro, ndatjin cjua xi canújun. ");
INSERT INTO maqNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Cuatjin xu cachja cha ta, tsëhë xi tsacjun xu cha cjuinenguise sa cha me. ");
INSERT INTO maqNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sehe ngajan xi Jesús ne, cachja nga xu me cuitjin: ―‍¿Hacutjin má xi cuatjin chja xuta xi me xi tsingatju Nina ne, tjë rë David má me? ");
INSERT INTO maqNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ta suvá David ne, cachja me cuitjin xcun xujun tsëhë Salmo: Nina ne, cachja me cojo Nai naha cuitjin: “Tinechin nguehe ladu quixi naha, ");
INSERT INTO maqNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hisca hya xi yëjë ni xi sahmi ri condra ne, cuiyujú ngahan ngahma gubiernu riji.” Cuatjin cachja David cjua xi cachja Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Quihndë ne, sá xi suvá David chja me xi Nai rë me má me xi tsingatju Nina ne, ¿hacutjin má ne xi hacuaha tjë rë me ni? ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jinguyëjë rë xi tivisiñuju yëjë xuta jan ne, Jesús ne, cachja xu me cuitjin cojo xuta ladu rë me: ");
INSERT INTO maqNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―‍Xicaninguisuhunjñuu cojo cha xi vicuya cjuachacun, xi jemu ndama rë cha xi cuatjin vajá cha tsjian nduju, hora xi fi tsujyihiya cha, jemu chuya rë cha xi cuatjin fi chja xuta nina cojo cha ngajan ngajñi ndetsin, hacuaha jemu chuya rë cha xi cuatjin satë rë cha cahndë́ xi matitjun tsëhë cahntsua yungun, o hiscan ngu ndava suhi. ");
INSERT INTO maqNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Cha xi cuacun vë ne, hacuaha jemu cjín tujún vaxë cha yachjin cahan. Hisca xi chjayuma cha ne, hacuaha jemu nduju hora, peru hacuiin nguñaja cacun cha chja cha. Vëhë xi cha xi cuacun vë ne, hitsë sa jyë castigu cuatju cha xi cuma rë jingusa xuta. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ngu nixtin jan ne, jinguyëjë rë xi tivutsejen xu Jesús xi tivincha xuta nchina tujún cahntsua alcancía tsëhë cjuandaja rë me cojo Nina ne; ");
INSERT INTO maqNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","hacuaha cavëë xu me xi canduva ngu chjuun cahan xi jemu yuma, hane hacuaha cavincha na jo tujún langa cahntsua alcancía jan. ");
INSERT INTO maqNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sehe ngajan xi cachja xu Jesús cojo xuta ladu rë me cuitjin: ―‍Cuichjá cojo nuju cjuaquixi ta na cahan vë xi jemu yuma na ne, hitsë sa vengui chji rë tujún xi cavincha na xi cuma rë tujún xi jemu cjín cavincha yëjë xuta nchina xi cuacun vë ta, ");
INSERT INTO maqNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","tsëhë xi me xi cuacun vë ne, tsëhë cjuanchina xi tjin rë me ne, ngajan cavaxë me tujún xi cavincha me. Peru na vëhë ne, handasa jemu tjin rë na cjuachaja ne, hitsë lihndi tujún xi tjin rë na ne, cavincha na yëjë cahntsua alcancía. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ngu ndiya, hya xi ngujo xuta jan cachja xu me xi yungun xi matitjun ne, jemu ndacun ndyojo camá cojo, hacuaha jercu camaxcuen cojo tu mé ni xcusun cjuatjo xi casua xuta ne, cachja xu Jesús cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―‍Sacuaha xcusun xi chutsujun vi ne, cuechú nixtin xi hisca ngu ndyojo ndacun xi cuicun vi ne, tsajin hinchasuncoo xicjin ta cjuë yëjë cuixujne. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ngajan xi xuta jan ne, cavinenguise xu me cojo Jesús cuitjin: ―‍Maestro, hane ¿janihya cuetjucaa xcusun vëhë ni? ¿Hacutjin cuma sacú niji cjuaquixi xi xcusun vëhë ne, ha tivechú nixtin xi cuetjucaa ni? ―‍Cuatjin xu cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ngajan xi Jesús ne, cuitjin xu cachja me: ―‍Nechun cuidadu, cojo sa xi hacuiin cuma ndacha ngayun ta, tsëhë xi jemu cjín xuta cuetjucaa me xi cuichja me xi hacui me xi catsingatju Nina me, hacuaha cuichja me xi ha camatiña nixtin. Peru xicatsanguntjenguun me. ");
INSERT INTO maqNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hacuaha hya xi cuma chaya nuju cjua xi jemu yehe si tijima ngu nación ne, o sá xi tjin cjuatacun xi jemu yehe si nduva ne, xicarcuun ta, hatuxa tjin xi titjun xcusun vëhë cuma. Peru hacuiin ngutjen hya cuijnetaha nixtin vihi. ");
INSERT INTO maqNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Hacuaha quijinduju sa xu cachja me cuitjin: ―‍Scaan xuta tsëhë ngu nación cojo jingu sa nación, hacuaha scaan xuta tsëhë ngu nandya cojo ngu nga nandya. ");
INSERT INTO maqNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hacuaha jemu cjín cahndë́ xi cjuani nangui, jemu cjín cahndë́ xi cuatju chíhin vitaha, jemu cjín cahndë́ xi cuma jindya, hacuaha jemu yehe chircun cuma tsejen ngajan ngahnga xi sua cumachaya nuju mé xi cuma. ");
INSERT INTO maqNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Peru chaja sa xi cuma yëjë xcusun vëhë ne, xuta ne, tsujyihiyatjengui nuju me cojo cjuahngatacun. Cjuaha nuju me cjuecojo nuju me xcun xutaxa rë yungun, hisca cuincha nuju me ndavaya. Cjuecojo nuju me xcun xutaxa rë ndihyavasen, hisca xcun gobernador, ngatsë rë xi ladu naha má ngayun. ");
INSERT INTO maqNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Xi cuatjin cuatjun cuma ne, vëhë sua nuju cahndë́ xi ninguixun yëjë cjua hacutjin cavicuyá nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tejñungutacún xi hacuiin titjun jemu cjín ningatuhuntacún hacutjin chjayunngun tsëhë xutaxa rë ta, ");
INSERT INTO maqNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tsëhë xi ngahan suá nuju cjuatacun xi cuinújun ngu cjua xi condra nuju ne, cumaji tsitjungui me hacuaha cumaji cuichja me xi quixiin. ");
INSERT INTO maqNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hacuaha hisca xutacha nuju, o sá xi xingun, o sá xi xuta nuju, o sá xi amigu nuju ne, cuinchajyë nuju me. Hacuaha tjin yahnga ngayun ne, hisca tsiquehen nuju me. ");
INSERT INTO maqNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yëjë ni xuta ne, choho scuëë nuju me, tsëhë xi ladu naha ngayun. ");
INSERT INTO maqNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Peru xicamacjiintacún ta tsajin camahani mé xi nichujun. ");
INSERT INTO maqNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Caticaa nuju ta, tsëhë xi cuatjin xi cuetjuntjun. ");
INSERT INTO maqNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Peru hya xi chun xi jemu cjín xuta nduvacjin cuetsihin xinchandee me nandya Jerusalén xi sahmi me ngu si jyë cojo nuju ne, vëhë sua machaya nuju xi camatiña nixtin xi nandya Jerusalén ne, cjuë tsinguetsun xuta nduvacjin vë. ");
INSERT INTO maqNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nixtin hya ne, ngayujun ni xi nechun yëjë nandya tsëhë distritu Judea ne, tiyun tángun hiscan ndetjún. Hacuaha ngayujun ni xi nechun nguehe nandya Jerusalén ne, tetjunxun. Hacuaha ngayujun ni xi nechun ranchun rë Jerusalén ne, xicatsanguun nandya xi naxuntjun yojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Cuatjin meje rë xi nihñu ta, tsëhë xi nixtin hya ne, sahmi Nina castigu nandya vihi, cojo sa xi xi cuatjin ne, cuetjucaa yëjë hacutjin camahindu xcun xujun rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jemu chojyihi tsëhë yëjë yachjin xi hinchahma quihndi rë me cojo yëjë me xi tjin rë quihndi vaqui nixtin hya ta, tsëhë xi cuatju ngu cjuandya jyë nación vihi, hacuaha cuatju xuta nguehe ngu castigu. ");
INSERT INTO maqNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Hacuaha jemu cjín xuta nguehe cueya me cojo quicha, hacuaha jemu cjín xuta nguehe tsihñu xuta tsëhë jingu sa nación me sehe tsingatju me me yëjë ni nación. Hane xi cuatju vëhë ne, suvá xutaxín cjue nduva me sunesun me xcun nangui tsëhë nandya Jerusalén, hisca xi cjuë nixtin xi xuta xi cuacun vë cuitexa me nandya Jerusalén vi. ");
INSERT INTO maqNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Nixtin hya ne, hacuaha cuma tsejen cjuarcun xi cuma xcun tsuhi cojo sá cojo niñú. Hane nguehe ngasunhndë ne, jercu cjín tsingataha cacun xuta tsëhë yëjë ni nación, ña cuya sca me tsëhë xi jercu cjuane ndachacun, hacuaha jercu tsiquijin rë tsindyu rë. ");
INSERT INTO maqNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yëjë xuta ne, ña cuma ndaya cacun me xi tsacjun me, xi tsingataha cacun me tsëhë chircun xi cuma nguehe ngasunhndë ta, tsëhë xi hisca ngahñu xi yaja ngahnga ne, cjuiniyaya. ");
INSERT INTO maqNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sehe hya scuëë xuta ngahan, xi Quihndi rë Xuta Jain ngahan, xi cuinduva ngajñi rë yufí cojo jemu jyë ngahñu, hisca setí hisca vatë jyihi ngahan xi cuinduva. ");
INSERT INTO maqNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hya xi xcusun xi cuacun vë cuetsihin cuma ne, tisechun chutsujun ngahnga ta camatiña nixtin xi cuetjuntjun. ");
INSERT INTO maqNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Xi quijinduju sa cjuavisiajmi rë Jesús ne, cachja xu me ngu ejemplu vihi: ―‍Quihndë ne, ningatuhuntacún tsëhë yaxujún o sá yahnga sa ya xi vixu xca rë. ");
INSERT INTO maqNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Xi tu chun xi cuetjusehen ya xi cuacun vë ne, ha hyun ta ha camatiña chan tsi. ");
INSERT INTO maqNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hacuaha chuva vëhë ni ne, hya xi chun xi cuetsihin cuma yëjë xcusun xi cachjá cojo nuju vë ne, vëhë sua cumachaya nuju xi ha camatiña nixtin xi nduva Nina sahmi me gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Cuichjá cojo nuju cjuaquixi ta ngayujun ni xi nechun nixtin vihi ne, hacuiin ngayujun caveyun chaja sa xi cuatju yëjë xcusun xi cachjá cojo nuju jan. ");
INSERT INTO maqNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ngahnga cojo nguehe ngasunhndë ne, hatuxa cjuë. Peru hisca ngu cjua naha ne, tsajin xi cuetjincaain. ");
INSERT INTO maqNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Nechun cuidadu tsëhë xcusun xi nihñu. Xicatuun cahndë́ xi cjuatacun nuju ne, tsë́ rë cojo cjuatacun tsëhë cjuachihi, cojo cjuacjintacun tsëhë xcusun xi mameje nuju xcun ngasunhndë nuju, sá tu tsajin tjin chjine ngayun hya xi cuechú nixtin vëhë, ");
INSERT INTO maqNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","sacuatjin tsajin tjin chjine ngu chu hya xi finenguisun rë chu chen. Vëhë xi nechun cuidadu ta, tsëhë xi hatuxa cuechú nixtin vëhë, hya xi sahmi Nina gubiernu yëjë ni xuta jingujyë ni ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nechun cuidadu. Yasen ni chjahyun rë Nina xi cuechú chuva rë xi cuetjuntjun tsëhë yëjë ni cjuacjintacun xi ha tu hora sa xi cuinduva. Hacuaha chjahyun rë Nina xi cuma cuetjunndujun hora xi cuisechun xcún xi cjuaháchuva nuju cojo cjuatacun nuju, ngahan xi Quihndi rë Xuta Jain ngahan. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nguinixtin ne, ndatsen yungun xi matitjun xu véjña Jesús vicuya me xuta. Hane nguixun ne, vetju xu me fi véjña me ndetjún xi hmí rë Ndetjún Olivu. ");
INSERT INTO maqNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hane yëjë ni xuta ne, tajñu tajñu xu ni fi me yungun jan xi cuisiñuju me cjua xi vicuya Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hya xi camá xu ne, camatiña suhi tsëhë pan xi hacuiin cojo san rë pan má, suhi xi hmí rë Pascua. ");
INSERT INTO maqNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hane nahmi xi matitjun cojo cha vicuya cjuachacun ne, jemu tivangui xu me chuva rë hacutjin xi tsiquehen me Jesús. Peru táhahma xu tisahmi me xcusun vëhë ta, tsëhë xi tsacjun xu me xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hya xi camá xu ne, Satanás ne, cavisehen xu cahntsua xahasen rë Judas, cha xi hacuaha hmí rë Iscariote, ngu cha ngajñi rë me xi tejó xi má ladu rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ngajan xi Judas jan ne, quiji cavisiajmicjín xu cha cojo ngujo nahmi xi matitjun cojo ngujo cha mayu yungun hacutjin cuma xi cjuaha xuta xi cuacun vë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Hane nahmi xi matitjun cojo mayu jan ne, jemu ndaja camá xu rë me, hisca caviyuju cacun me xi sua me cha tujún. ");
INSERT INTO maqNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hane Judas ne, cojo cjuatacun vëhë ne, camangu cacun cha, sehe ngajan xi cavangui xu cha ngu hora xi tsajin cjín xuta, xi sahmi cha entregadu Jesús cojo xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Cavechú xu nixtin tsëhë suhi rë pan xi hacuiin cojo san rë pan má, nixtin hya xi meje rë xi cueya chu tsánga. ");
INSERT INTO maqNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sehe ngajan xi Jesús ne, catsingatju xu me Pedru cojo Juan ngu tixa, hane cuitjin xu cachja me: ―‍Tángun tuhunchjinu xi xinëënguixuun tsëhë suhi. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Sehe ngajan xi me xi cuacun jan ne, cavinenguise xu me Jesús cuitjin: ―‍¿Hane jani meje nuju xi cuihinchjini ni? ―‍Cuatjin xu cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Hane Jesús ne, cuitjin xu cachja me: ―‍Chutsujun ni, xi cjuhun tjehen nandya jan ne, ngajan cuechuntuhun ngu cha xi yaniji ngu nisa nandá, hane tánguntjengun cha hisca xi cjuhun ndihya hiscan cjui cha, ");
INSERT INTO maqNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","sehe tinújun cojo nai rë ndihya jan cuitjin: “Cuitjin cjua xi catsingatju maestru tsujun: ¿Jarë cuartu xi tuhun, sehe ngajan sínë niñu tsëhë suhi cojo xuta ladu naha?” Cuatjin tinújun cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hane me vëhë ne, tsingacun nuju me ngu cuartu jyë xi tacun ngahnga hiscan xi ha tjin chjine ndihya. Hane ngajan tuhunchjinu xi xinëë. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hane xi quiji me xi jo jan ne, cavetjucaa jain yëjë cjua xi cachja Jesús cojo rë me. Hane ngajan cavëhëndaja xu me xi sinë nguixun Jesús cojo rë me tsëhë suhi. ");
INSERT INTO maqNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hane xi cavechú hora ne, cafaha xu Jesús cahndë́ rë me xcun maxë cojo xingu xingu apóstol. ");
INSERT INTO maqNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hane sehe cachja xu me cojo apóstol jan cuitjin: ―‍Jemu meje sínë cojo nuju comida tsëhë suhi vihi chaja sa xi cjuehe cjuaveya naha ta, ");
INSERT INTO maqNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","tsëhë xi nguehe cuichjá cojo nuju ta ha quihndë tsajin nixtin xi cúya sínë nga comida tsëhë suhi vihi. Sínë nga, peru hisca hya xi cuinduva Nina sahmi me gubiernu ta, tsëhë xi cjuatacun xi vicuya naja suhi vihi ne, hya cuetjucaa jain. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hane xi cafahatsja xu me ngu vasu ne, sehe casua me nacuechji rë Nina, sehe cachja xu me cuitjin: ―‍Juhun vihi ne, sehe siuhun tsë tsë cojo xingun ta, ");
INSERT INTO maqNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","hacuaha cuichjá nga cojo nuju ta quihndë cojo nixtin xi cjuiniji sa ne, ha quihndë cuyaan cuëhë xan rë uva. Cuëhë, peru hisca hya xi cuinduva Nina sahmi me gubiernu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hane xi cafaha me ngu niñutsju hacuaha casua me nacuechji rë Nina ne, sehe cavotohocja xu me niñutsju jan. Hane xi casua rë me apóstol jan ne, sehe cachja xu me cuitjin: ―‍Vihi ne, yojo naha vi, xi tisuá xi cueya ngatsë nuju. Cuitjin nihñu xcusun vihi yasen ni, cojo sa xi ninguitsjun ná. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hane xi cajnetaha cajinë nguixun me ne, hacuanitjin xu ni casahmi me cojo vasu. Hora xi casua rë me apóstol ne, cuitjin xu cachja me: ―‍Xan vihi ne, vihi jni naha xi cuetju ngatsë nuju. Cuatjin xi cuma chihin compromisu xatsë xi tisahmi Nina cojo xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Peru chutsujun ni, cha xi sahmi ná entregadu ne, nguehe tacun cha ngajñi naja. ");
INSERT INTO maqNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hane ngahan xi Quihndi rë Xuta Jain ngahan ne, hatuxa tjin ná xi cueya sacuatjin cavichaya Nina tsahan. Peru jemu chojyihi tsëhë cha xi sahmi ná entregadu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ngajan xi yëjë xu apóstol jan ne, cavetsihin cavinenguise xicjin me jarë me xi sahmi xcusun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hya xi camá xu ne, cavetsihin sacuaha xi meje scaanya me ngajñi rë me yo xi chja xuta xi hitsë sa matitjun. ");
INSERT INTO maqNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ngajan xi Jesús ne, cuitjin xu cachja me: ―‍Yëjë ni xuta xi matitjun nguehe ngasunhndë ne, jercu sahmi yehe me yojo rë me sacuaha xi me vëhë má me nai rë xuta. Hacuaha jercu meje rë me xi yëjë xuta ne, cuichja me xi jemu ndaja me xi matitjun vë. ");
INSERT INTO maqNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Peru ngayun ne, mijí rë xi cuatjin nihñu ta xi meje rë ne, ngu xi matitjun tsëhë ngajñi nuju ne, catitsinguijne yojo rë sacuaha ngu xi chúva nu rë. Hane ngu xi vitexa tsëhë ngajñi nuju ne, hacuaha catitsinguijne yojo rë sacuaha ngu hndixahan. ");
INSERT INTO maqNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Yo xi hitsë sa matitjun ni? ¿Há ngu xi tijinë ne, o há tsajin ne, há ngu hndixahan xi cjui cani comida? Xi tijinë ne, hatuxa vëhë xi hitsë sa matitjun. Peru ngahan ne, tejña ngajñi nuju sacuaha ngu hndixahan nuju. ");
INSERT INTO maqNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ngayun ne, ngayun xi cacaa nuju cojo yëjë cjuañihi xi cavatjuun camá. ");
INSERT INTO maqNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Vëhë xi sacuaha casuaxa ná Nahmi naha xi ngahan sahme gubiernu ne, cuatjin suáxa nuju xi nihñu gubiernu, ");
INSERT INTO maqNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","cojo sa xi ngayun ne, hacuaha xinu siuhun cojo ná ngajan hiscan sahme gubiernu. Hacuaha suáxa nuju xi nichuvun cjuatacun rë yëjë tejó tjë naja, ngayaan xi tjë rë xutachanga naja Israel ngayaan. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Hacuaha cachja sa xu Jesús cuitjin cojo Pedru xi hacuaha hmí rë me Simón: ―‍Chutsujun ni Simón. Satanás ne, casacu rë cahndë́ xi tsichuva cjuatacun nuju ngayujun ni. ");
INSERT INTO maqNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Peru ngayun Simón ne, caféhya rë Nina ngatsë nuju, cojo sa xi hacuiin cumandaya tacún sacuatjin xi mangutacún cojo ná. Hane hya xi ngayun cuyun nga ndiya naha ne, tuhun ngahñu xingun. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngajan xi Pedru ne, cachja xu me cojo Jesús cuitjin: ―‍Tatá. Ngahan ne, tsingatehen cjuë́ ndavaya cojo nuju hisca tsingatehen cueya cojo nuju. ―‍Cuatjin xu cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ngajan xi Jesús ne, cuitjin xu cafayangui me tsëhë Pedru: ―‍Nguehe cuichjá cojo nuju, Pedru. Chaja sa xi squihnda ngu xahnda ne, ha jyan ndiya canújun xi hyúun yo ngahan. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hacuaha cachja me cojo xuta ladu rë me cuitjin: ―‍Hya xi catsingátju nuju xi cachjá cojo nuju xi chuun tujún, chuun changa hacuaha chuun chuxinxtë ne, ¿há quixi xi tsajin mé camachaja nuju? ―‍Cuatjin xu cachja Jesús. Hane xuta ladu rë me jan ne, cuitjin xu cachja me: ―‍Juun, tsajin mé. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hane Jesús ne, cachja nga xu me cuitjin: ―‍Peru quihndë ne, jarë ngayun xi tjin nuju tujún, tjin nuju changa ne, chuhun, tángun cojo. Hane yo xi tsajin rë ngu quichandujú ne, catiteña tsjanga rë ne, sehe catatsë ngu quichandujú. ");
INSERT INTO maqNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Cuatjin meje rë ta, tsëhë xi nguehe cuichjá cojo nuju ta hacutjin xi camahindu tsahan xcun xujun rë Nina ne, hatuxa tjin rë xi cuetjucaa, cjua xi chja cuitjin: “Cuichja xuta tsëhë me xi ngu xuta tsehen me.” Cuatjin camahindu. Hatuxa cuetjucaa sacuatjin camahindu. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sehe ngajan xi xuta ladu rë Jesús jan ne, cuitjin xu cachja me: ―‍Chutsujun ni, tatá. Nguehe ne, ha siu jo quichandujú. ―‍Cuatjin xu cachja me. Sehe ngajan xi Jesús ne, cuitjin xu cafayangui me: ―‍Cojo vëhë ne, ha cuma. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hya xi camá ne, xi cavetju xu me tsëhë nandya Jerusalén ne, sacuatjin xi ha xcusun rë me ne, quiji xu me Ndetjún Olivu. Hacuaha cojo yëjë xuta ladu rë me quiji xu me cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hane xi cafehe me jan ne, cachja xu me cojo xuta jan cuitjin: ―‍Chjahyun rë Nina xi hacuiin chjaháchuva nuju cojo cjuatacun nuju. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hane xi quijixin me hitsë tsëhë xuta ladu rë me jan ne, sehe ngajan cavixcuhnchi xu me xi sahmi me oración rë me, ");
INSERT INTO maqNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","cuitjin xu cachja me: ―‍Ngayun Nahmi naha, sá mé ni xi meje nuju ne, chjuhunxun cjuañihi xi cuátju cuma vi. Peru catama sacuatjin xi meje nuju ngayun, hacuiin sacuatjin xi meje ná ngahan. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hya xi camá ne, cavëë xu me ngu ángel xi canduva tsëhë ngahnga, casua rë me ngahñu. ");
INSERT INTO maqNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hane xi jemu jima ndaya cacun xu me ne, hitsë sa jercu cafehya rë me Nina. Hacuaha ndasueya xi cavetju rë me ne, sacuaha jni xu cún xi cavixu nangui. ");
INSERT INTO maqNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hane xi cavisatjenhnga xu Jesús xi cajnetaha casahmi me oración rë me ne, xi cavuya quiji me hiscan siu xuta ladu rë me jan ne, casacutsja xu me xi siufë, ngatsë rë cjuachoho rë. ");
INSERT INTO maqNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo xuta jan: ―‍¿Mé má cuatjin tsjuñufun ni? Tisatjunhngun ne, nihñu oración nuju, sátu chjaháchuva nuju cojo cjuatacun nuju. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jinguyëjë rë xi tichja cuaha xu Jesús ne, ha tu ñahñu jercu cjín xuta cafehe me. Hane cha xi hmí rë Judas, ngu cha ngajñi rë me xi tejó xi má ladu rë Jesús jan ne, titjun xu cha xcun xuta cjín jan cjui cha. Hane xi cafehe cha jan ne, sehe quijitiña xu cha xi cuitatsuha cha Jesús xi sua cha me nina. ");
INSERT INTO maqNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ngajan xi Jesús ne, cuitjin xu cachja me cojo cha: ―‍Judas, ¿há cuatjin cuitatsuhun ná xi nihñu ná entregadu, ngahan xi Quihndi rë Xuta Jain ngahan? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hane xi cajne rcu xuta xi siu cojo Jesús xcusun xi cuma jan ne, sehe cachja xu me cuitjin: ―‍Tatá. ¿Há cuíjin rë me quicha? ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hya xi camá xu ne, ngutjen cavaja ngu me jan cha hndixahan rë nahmi xi matitjun tsëhë yëjë ni nahmi, hane cavatësun xu me tyjavañuju quixi cha. ");
INSERT INTO maqNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hane ngajan xi Jesús ne, cuitjin xu cachja me: ―‍Camá ni. ―‍Cuatjin xu cachja me. Hane xi cavetahatsja xu me hiscan cati rë cha ne, camandaja xu cha casahmi Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hane nahmi xi matitjun cojo cha mayu yungun xi matitjun cojo xutachanga, xi cafehe me xi cjuaha me Jesús ne, cachja xu Jesús cojo rë me cuitjin: ―‍¿Há nduvun chjuhun ná sacuaha ngu xuta xi chëjë me, xi cuatjin nduvun cojo ya cojo quicha vë ni? ");
INSERT INTO maqNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Xi cavitejñaya cojo nuju nchunchujun ni ndatsen yungun jan ne, cavetuhunntsuun ná. Peru quihndë cavechú hora xi casua Nina cahndë́ xi nihñu cojo ná tu mé ni xi meje nuju, cavechú hora xi Satanás cuitexa. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hya xi camá xu ne, xi cafaha xuta jan Jesús ne, quijicojo me me ndava nahmi xi matitjun tsëhë yëjë ni nahmi. Pedru ne, hacuaha tjengui xu me cjui me tu cjin tu cjin ni hacutjin cjui xuta jan cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hane xi cafehe xu me jan ne, casahmi me ngu ndava ndihi ngajan ndatsen ndihya, sehe ngajan quiji me caviyuju tangun me. Hacuaha cojo xu Pedru quiji me cavéjña tangun me cojo xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hane xi cavëë xu na hndixahan rë nahmi jan Pedru, tacun me xcun ndihi jan ne, xi cavutsejenndaja na me ne, sehe cachja xu na cuitjin: ―‍Me xi cuijyihi vi ne, cojo me tacun me cojo me xi cuajyihi vë hya. ―‍Cuatjin xu cachja na. ");
INSERT INTO maqNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hane Pedru ne, cavitijaya me cachja xu me cuitjin: ―‍Hveen yo vë. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Xi cavatju nga ngu hora lihndi ne, xi cavëë nga ngu cha Pedru ne, cachja xu cha cuitjin: ―‍Ngayun ne, hacuaha ladu rë me xi cuacun vë má ngayun. ―‍Cuatjin xu cachja cha. Ngajan xi Pedru ne, cuitjin xu cachja me: ―‍¡Jéya, hacuiin! ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Xi cavatju sacuaha ngu hora nga xu ne, cachja nga ngu cha xi tacun jan cuitjin: ―‍Ha cjuaquixindaja ta cha xi cuijyihi vi ne, cojo cha tacun cha cojo cha xi cuajyihi vë, tsëhë xi hacuaha cha Galilea cha. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngajan xi Pedru ne, cuitjin xu cafayangui me: ―‍Hveen mé xi nújun vë. ―‍Cuatjin xu cachja me. Hane ha tu tichja cuaha xu Pedru ne, ha tu ñahñu cajindaya ngu xahnda jan. ");
INSERT INTO maqNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ngajan xi Nai naja ne, cavuya vutsejen xu me Pedru. Hane Pedru ne, catsinguitsjen xu me cjua xi cachja Nai naja cojo rë me, xi cachja me cuitjin: “Chaja sa xi squihnda ngu xahnda ne, hacuaha camá jyan ndiya nújun xi hyúun yo ngahan.” Cjua vëhë xi catsinguitsjen xu Pedru. ");
INSERT INTO maqNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hane xi cavetju xu me candatsen ne, cajihnda susu me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hane cha xi siutahá sahmi cuidadu rë Jesús jan ne, titsixcuehyu xu cha me hacuaha tivaja cha me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Hane xi cavetsa xu cha tuxcun me ne, sehe cavaja sa cha me, sehe cachja xu cha cuitjin: ―‍¡Tinoje! ¿Yo xi tivaja ri? ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hacuaha jemu cjín sa xu cjua cachja cha xi choho chja cha tsëhë me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hane xi camá nchujun jan ne, camatangun xu xuta changá tsëhë nandya jan cojo nahmi xi matitjun cojo cha xi vicuya cjuachacun. Sehe quiji chani xu rë Jesús xcun xuta xi cuacun jan xi chjahácuenda rë jyë́ rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Hane xi cafehe Jesús jan ne, sehe cavinenguise xu xuta jan cuitjin: ―‍Sá xi ngaye xi catsingatju Nina ngaye ne, tinoje cojo niji. ―‍Cuatjin xu cavinenguise xuta jan. Sehe ngajan xi Jesús ne, cuitjin xu cafayangui me: ―‍Sá xi cuichjá cojo nuju ne, hatuxa cumacjaain nuju xi cuichjá. ");
INSERT INTO maqNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Hacuaha sá xi cjuinenguësë nuju ngu cjua ne, hatuxa chjayunnguun tsahan. ");
INSERT INTO maqNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Peru cuetsihin cojo quihndë ni ne, ngahan xi Quihndi rë Xuta Jain ngahan ne, cuitejña ladu quixi tsëhë Nina, me xi jemu hñu ngahñu rë. ―‍Cuatjin xu cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ngajan xi yëjë ni xuta jan ne, cavinenguise xu me Jesús cuitjin: ―‍¿Há ngaye xi Quihndi rë Nina ngaye ni? ―‍Cuatjin xu cavinenguise me. Hane Jesús jan ne, cuitjin xu cafayangui me: ―‍Sacuatjin nújun vë ne, cuatjin jain. ―‍Cuatjin xu cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ngajan xi xuta xi cuacun jan ne, cuitjin xu cachja me cojo xicjin me: ―‍¿Mé sa nihña xuta xi tsinguixi me jyë́ rë cha? Ha canuhyaan suvaan xi hntsua cha cavetju xi cachja cha. ―‍Cuatjin xu cachja xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hya xi camá ne, cavisatjenhnga yëjë xu xuta xi matitjun jan ne, sehe quijicojo me Jesús xcun Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hane cavetsihin xu cavinchajyë me cuitjin: ―‍Casacuntsin cha xi cuijyihi vi tivisecjan cha cjuatacun rë xuta. Hacuaha mijí rë cha xi cuechjin tujúnsa niji cojo César, me xi matitjun. Hacuaha chja sa cha ta hacui cha xi catsingatju Nina cha, hacuaha matitjun xu cha. ―‍Cuatjin xu cachja me xi cavinchajyë me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sehe ngajan xi Pilatu ne, cavinenguise xu me Jesús cuitjin: ―‍¿Há ngaye xu matitjun ngaye tsëhë xuta tjë rë Israel? ―‍Cuatjin xu cavinenguise Pilatu. Hane Jesús ne, cuitjin xu cafayangui me: ―‍Cuatjin sacuatjin nújun vë. ―‍Cuatjin xu cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ngajan xi Pilatu ne, cuitjin xu cachja me cojo nahmi xi matitjun cojo yëjë xutacjín jan: ―‍Sacuiin ná hisca ngu jyë́ rë cha xi cuijyihi vi. ―‍Cuatjin xu cachja Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Peru quijinduju sa xu cachja xuta xi matitjun jan cuitjin: ―‍Jemu tivisecjan cha cjuatacun rë xuta ngatsë rë cjua xi tivicuya cha jingujyë ni distritu Judea vi. Cavetsihin cha hisca ngajan distritu Galilea, hisca nguehe cafehe cha. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hane xi cahndë Pilatu cjua vëhë ne, sehe cavinenguise xu me xuta jan cuitjin: ―‍¿Há cha Galilea cha xi cuijyihi vi ni? ―‍Cuatjin xu cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hane xi casacu xu rë Pilatu cjuaquixi xi hiscan xi vitexa Herodes canduva Jesús ne, sehe catsingatju xu Pilatu me xcun Herodes, tsëhë xi Herodes ne, hacuaha quitahá xu me ngajan Jerusalén nixtin hya. ");
INSERT INTO maqNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hane hya xi cavëë Herodes Jesús ne, jemu ndaja camá xu rë me, tsëhë xi ha titjun sa ne, jemu meje scuëë me Jesús, tsëhë xi ha machaya rë me cjua tsëhë Jesús, hacuaha meje scuëë xu me xi sahmi Jesús ngu cjuarcun. ");
INSERT INTO maqNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hane jercu cjín cjuachjinenguise casahmi xu me Jesús, peru Jesús ne, tsajin camahani mé xi cafayangui xu me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hane nahmi xi matitjun cojo cha xi vicuya cjuachacun ne, jemu tivincha xu me jyë́ rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ngajan xi Herodes cojo sindadu rë me ne, jemu casahmixta xu me cojo Jesús, hacuaha catsixcuehyu me me. Hane xi catsicaja xu me Jesús ngu tsjian xi jemu ndajyihi camahani ne, sehe cavuya catsingatju nga xu me Jesús xcun Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hane nixtin hya ne, Herodes cojo Pilatu ne, jemu cavinga xu rë me xicjin me, handasa titjún xu ne, maji vëë xicjin me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hya xi camá ne, xi casahmitangun xu Pilatu nahmi xi matitjun cojo xutaxa rë cojo xuta nandya ne, ");
INSERT INTO maqNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","sehe cachja xu me cojo cuitjin: ―‍Ngayujun ni matsejen ne, canduvuncujun cha xi cuijyihi vi nguehe matsejen, tsëhë xi xi má nuju matsejen ne, tivisecjan cha cjuatacun rë xuta. Peru quihndë matsejen ne, chutsujun ta, xcún ni matsejen ne, cafahátaha rë cha, peru casacuiin ná hisca xi ngu jyë́ rë cha sacuatjin jyë́ xi cavinchun. ");
INSERT INTO maqNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hacuanitjin ni Herodes matsejen ta, casacuiin rë me jyë́ rë cha, vëhë xi catsicuya nga me cha. Chutsujun ta tsajin camahani mé casahmi cha xi vechú chuva rë xi niquen cha. ");
INSERT INTO maqNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Vëhë xi cuitéxa sehen ni rë cha matsejen ne, sehe tsisme cha. ―‍Cuatjin xu cachja Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hatuxa xcusun xu rë Pilatu xi tsismi me ngu presu xi xuta vaxijin me nu nu ni nixtin rë suhi. ");
INSERT INTO maqNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Peru yëjë ni xuta xi matitjun jan ne, ngu tangun ni camá xu me cajindaya me cachja me cuitjin: ―‍¡Nicuhun cha vi ne, Barrabás nismu cha! ―‍Cuatjin xu cajindaya me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Cha Barrabás ne, quiji cha ndavaya ngatsë rë xi casahmi xu cha ngu si cojo xutaxa rë, hacuaha catsiquehen xu cha. ");
INSERT INTO maqNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Peru ngu ndiya nga cachja xu Pilatu cojo xuta xi matitjun jan, tsëhë xi Pilatu ne, meje tsismi me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Peru xuta xi matitjun jan ne, cavuya cajindaya nga me cachja xu me cuitjin: ―‍¡Tetuhun cha, tetuhun cha xcun cru! ―‍Cuatjin xu cajindaya me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hane xi ma jyan ndiya ne, cavinenguise xu Pilatu xuta xi matitjun jan cuitjin: ―‍Peru ¿mé xi jemu choho casahmi cha ni? Tsajin camahani mé jyë́ rë cha casacu ná xi vechú chuva rë xi niquen cha. Vëhë xi cuitéxa sehen ni rë cha matsejen ne, sehe tsisme cha. ―‍Cuatjin xu cachja Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Peru yëjë ni xuta xi matitjun jan ne, quijinduju sa xu cajindaya me cafehya me xi setaha Jesús xcun cru. Vëhë xi cajne cacun xu Pilatu, ");
INSERT INTO maqNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","hacuaha cavejña cacun xu me xi sahmi me hacutjin xi fehya xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hya xi camá ne, catsismi xu me cha xi cafehya xuta xi matitjun jan, ngu cha xi quiji ndavaya tsëhë xi casahmi xu si cojo xutaxa rë hacuaha catsiquehen xu cha. Peru Jesús ne, casua xu Pilatu me xi cjue cueya me, sacuatjin meje rë xuta xi matitjun jan. ");
INSERT INTO maqNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hane xi cjuicojo sindadu Jesús ne, ngajan ndiya jan cavechútáha xu cha ngu me xi hmí rë Simón tsëhë nandya Cirene, xi nduva xu me quiji me nguijña. Hane cafaha xu sindadu jan me, catsicaniji xu cha me cru xi cjue me cojo hacutjin cjui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hane jercu cjín camaha xu ni xuta quiji me cojo Jesús hacuaha jercu cjín xu yachjin xi hisca chja hisca jihnda na xi jemu choho má rë na ngatsë rë Jesús quiji xu na cojo me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hane xi cavuya Jesús cavutsejen me na ne, sehe cachja xu me cuitjin: ―‍Ngayun na quihndi nandya Jerusalén, xicachjihnduun ngatsë naha. Chjihndun ngatsë nuju suvun cojo ngatsë rë quihndi nuju ta, ");
INSERT INTO maqNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","cuechú nixtin xi cuichja xuta cuitjin: “Jemu ndaja tsëhë yachjin xi hatuxa maji sacu rë na quihndi; jemu ndaja tsëhë yachjin xi hisca ngu quihndi casacuiin rë na; hacuaha jemu ndaja tsëhë yachjin xi casacuiin quihndi catsicha na.” Cuatjin cuichja xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nixtin hya ne, hacuaha cuichja xuta cojo ndetjún cuitjin: “Tjinengunsun niji.” Hane naxi ne, cuitjin cuichja me cojo: “Tatsun niji.” Cuatjin cuichja me ta, ");
INSERT INTO maqNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","sá xi cuitjin choho tisahmi xuta vi cojo ná quihndë, ngahan xi tangun ngahan sacuaha ngu ya xcuen ne, hatuxa hitsë sa choho sahmi me cojo nuju nchujun ni nguini, ngayun xi tangun ngayun sacuaha ngu ya quixí. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hacuaha cojo sa xu jo cha tsehen quijicojo sindadu jan cha, xi tsiquehen tangun cha cha cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hane xi cafehe cha cojo Jesús hiscan xi hmí rë Nínda Rcuun ne, ngajan cavetaha xu cha Jesús xcun cru hacuaha caviyujutaha sa cha catsijo cha tsehen jan xcun cru rë cha. Ngu cru xi quitahá ngu cha ne, casecun xu táha xcun tsëhë Jesús, hane ngu nga ne, táha quixi. ");
INSERT INTO maqNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ngajan xi Jesús ne, cachja xu me cuitjin: ―‍Ngayun Nahmi naha. Ninchatuhun rë xuta vi ta, hvíin me mé xi tisahmi me. ―‍Cuatjin xu cachja Jesús. Hane xi cuatëcja sindadu tsjian rë Jesús jan ne, cavaxë xu cha ngu suerte. ");
INSERT INTO maqNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hane xutacjín jan ne, caxinchacun xu me cavutsejen me xcusun xi tijima jan. Hacuaha xutaxa rë jan ne, cavejnucëë me Jesús, cuitjin xu cachja me: ―‍Cavaxëtje cha jingu sa xuta. Quihndë ne, cataxëtje suvá cha yojo rë cha, sá xi hacui jain cha xi cavaxijin Nina hacuaha catsingatju me. ―‍Cuatjin xu cachja xutaxa rë. ");
INSERT INTO maqNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Hacuaha sindadu jan ne, catsixcuehyu xu cha Jesús. Quijitiña cha hiscan tyjangui me xcun cru, hane meje sua xu cha xan yufa cuihi me, ");
INSERT INTO maqNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","sehe cachja xu cha cuitjin cojo rë me: ―‍Sá xi ngaye jain matitjun ngaye tsëhë xuta tjë rë Israel ne, naxetje sove yojo riji. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hacuaha camahindu xu ngujo cjua rcu cru rë Jesús xi chja cuitjin: “Matitjun cha vihi tsëhë xuta tjë rë Israel.” Cuatjin xu camahindu. Jyan hne camahindu cjua xi cuacun vë: hne griego cojo latín cojo hebreo. ");
INSERT INTO maqNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hane ngu cha tsehen xi cojo casetaha xcun cru jan ne, cuitjin xu choho cachja cha tsëhë Jesús: ―‍¿Hacuiin ngaye xi catsingatju ri Nina ni? ¡Naxetje sove yojo riji ne, hacuaha naxetje niji! ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hane xi cavatëcja xu cha xingu jan cjua rë cha xi choho chja tsëhë Jesús ne, cuitjin xu cachja cha: ―‍¿Há rcuiin Nina, quihndë xi tivatjun castigu sacuatjin tivatju me vëhë tijima? ");
INSERT INTO maqNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ngayaan ne, cojo cjuaquixi xi tivatjun tijima ta, ngatsë rë xcusun xi canihña ne, vëhë xi vechú chuva rë xi cuitjin tivatjun castigu. Peru me vihi ne, tsajin mé xi jemu choho casahmi me. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sehe cachja xu cha cojo Jesús cuitjin: ―‍Jesús, ninguitsjun ná hya xi cuinduvun nihñu gubiernu. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Hane Jesús ne, cuitjin xu cafayangui me: ―‍Cuichjá cojo nuju cjuaquixi ta ha cojo quihndë ni ne, cuinechun cojo ná ngajan cahndë́ ndajyihi hiscan xi hmí rë Paraíso. ―‍Cuatjin xu cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hane hora vëhë ne, camajñu xu jingujyë ni. Cavetsihin xi camanchisen ne, quiji cani rë hisca fane jyan, ");
INSERT INTO maqNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","tsëhë xi tsuhi ne, ha quihndë casuaain xu ndavá rë. Hacuaha ngajan cahntsua yungun xi matitjun, tsjian xi vitechja rë tingotjo rë Ndava Nina ne, catiyavasen xu. ");
INSERT INTO maqNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Hya xi camá ne, jercu hñu camaha xu ni cachja Jesús cuitjin: ―‍Ngayun Nahmi naha. Ntsun cuejñá hasen naha. ―‍Cuatjin xu cachja me. Hane xi cavatju cachja me cuatjin ne, cahme xu me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hane ngu capitán xi secun tiña xu jan ne, xi cavëë cha xcusun xi camá jan ne, casahmi jyë casahmi hnga cha Nina, cachja xu cha cuitjin: ―‍Quixi jain xi cha xi cuijyihi vi ne, tsajin jyë́ rë cha. ―‍Cuatjin xu cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hane yëjë ni xutacjín xi camatangun me xi scutsejen xu me xcusun jan ne, xi cavatju cavëë me yëjë xcusun xi camá jan ne, cavuya me cafe xu me, ña yaha xu me rcu me ngatsë rë cjuachoho rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Peru yëjë ni xuta xi cavinga xu rë Jesús cojo yëjë yachjin xi cavetju me tsëhë distritu Galilea cojo Jesús ne, tsëhë cjin ni hinchacun cuaha xu me tivutsejen me xcusun xi tivatju Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Hane tacun ngu xu me xi hmí rë José, ngu xuta nandya Arimatea, ngu nandya rë xuta tjë rë Israel. Me vëhë ngu xihin ndaja me hacuaha tsajin xu mé jyë́ rë me tjin. ");
INSERT INTO maqNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hacuaha cachuyiin xu rë me sacuatjin caviyuju xutaxa rë xi yahnga jan cjuatacun rë me cojo xcusun xi casahmi me. Hacuaha José jan ne, jemu meje xu rë me xi cuinduva Nina sahmi me gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ngajan xi me vëhë ne, quiji xu me xcun Pilatu, hane cafehya xu me nima Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Hane xi casacu cahndë́ ne, quiji catsitujne me, sehe cavaxtë xu me ngu tsjian. Hya xi camá ne, quiji caveya xu me cahntsua ngu tsjun xi catjuhngui rë taha naxi, hacuaha hisca ngu xu nima cjëë seyaniji. ");
INSERT INTO maqNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nixtin hya ne, vispra xu. Ha hisca meje cuechú xu hora xi cuisehen nixtin xi chjahájenda rë. ");
INSERT INTO maqNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hane yachjin xi cojo xu me cavetjutangun me cojo Jesús ngajan Galilea ne, tjengui xu me quiji me cojo nima. Hane cavëë me tsjun hacuaha cavëë xu me hacutjin caseya nima. ");
INSERT INTO maqNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hane xi cavuya me ne, cavëhëchjine xu me rqui cojo aceite xi ndaja jne tsëhë nima. Hane xi camá nchujun jan, xi cavechú xu nixtin xi chjahájenda rë ne, caviyujujyuu xu me, sacuatjin vitexa ley rë Moisés. ");
INSERT INTO maqNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Peru tu casahasen ni tsëhë nixtin ngu tsëhë totje ne, yachjin jan ne, cavuya quiji nga xu me xcun tsjun jan hacuaha cavaha xu me rqui xi ha cavëhëchjine me jan. ");
INSERT INTO maqNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hane xi cafehe me jan ne, cavëë xu me xi ndyojo xi cavechja rë tingotjo rë tsjun jan ne, ha canivahaxin rë. ");
INSERT INTO maqNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hane xi cavisehen me cahntsua tsjun jan ne, cavëë xu me xi tsajin nima Nai naja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hane jinguyëjë rë xi sacuinyiin rë me mé sahmi me ne, ha tu ñahñu camatsejen xu jo ángel jan, xi jercu tu setí camaha xu ni tsjian rë. ");
INSERT INTO maqNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Hane xi jemu catsacjun me camá ne, catsiquindi xu me xcun me. Sehe ngajan xi ángel jan ne, cuitjin xu cachja cojo rë me: ―‍¿Mé má ngajñi rë nima vinchunsun me xi quicun? ");
INSERT INTO maqNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Me vëhë ne, tsajin me nguehe ta cavuya me cjuahñu. Ninguitsjun hacutjin cachja me cojo nuju hya xi tacun cuaha me ngajan Galilea, ");
INSERT INTO maqNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","hya xi cachja me xi me xi Quihndi rë Xuta Jain ne, hatuxa tjin xi cuma me entregadu tsja xuta tsehen, sehe cueya me xcun cru, hane xi cuma jyan nixtin ne, cuya nga me cjuahñu. ―‍Cuatjin xu cachja ángel jan. ");
INSERT INTO maqNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sehe ngajan xi yachjin jan ne, catsinguitsjen xu me cjua rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hane xi cavuya me xi quiji me xcun tsjun jan ne, quiji casua xu me camachaya rë xuta ladu rë Jesús xi tengu jan cojo yëjë sa me xi yahnga tsëhë yëjë ni hacutjin cavatju me camá. ");
INSERT INTO maqNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Quihndë ne, yachjin xi casua camachaya rë apóstol jan ne, hacui xu na María na Mágdala cojo na Juana cojo na María naa rë Jacobo cojo sa yachjin xi yahnga. ");
INSERT INTO maqNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Peru apóstol jan ne, xi má xu rë me ne, suvá cjuangarca xi chja yachjin jan, vëhë xi camacjaain xu rë me. ");
INSERT INTO maqNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peru Pedru ne, vangasanii xu me quiji me hiscan tacun tsjun jan. Hane xi cafehe me jan ne, catsiquindi xu me yojo rë me, sehe cavutsejenya xu me cahntsua tsjun jan ne, hane cavëë xu me suvá tsjian jan siu. Sehe cavuya cafe xu me. Jercu quijircun xu rë me tsëhë xcusun xi camá jan. ");
INSERT INTO maqNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hya xi camá ne, ha nixtin hya xu ni ne, jo cha ladu rë Jesús jan ne, cavetju xu cha quiji cha ngu nandya xi hmí rë Emaús, xi tacun sacuaha chuva rë tengu kilómetro tsëhë Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Hane ndiya cjui cha jan ne, cavisiajmi xu cha ngajñi rë cha tsëhë yëjë xcusun xi camá. ");
INSERT INTO maqNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hane jinguyëjë rë xi tivisiajmi cha jan ne, cavechútáha xu Jesús cha, hane quijitangun xu me cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Peru handasa vutsejen cha me ne, casuaain xu Nina cahndë́ xi scuëë cha xi hacui me. ");
INSERT INTO maqNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sehe ngajan xi Jesús ne, cavinenguise xu me cha cuitjin: ―‍¿Mé cjua xi tivisiajmu xi táha tivangun? ―‍Cuatjin xu cavinenguise me. Hane cha xi cuacun jan ne, caxinchacunhñu xu cha, hacuaha jemu va tjin cacun cha. ");
INSERT INTO maqNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hane ngu cha xi cuacun jan xi hmí rë Cleofas ne, cachja xu cha cojo Jesús cuitjin: ―‍¿Há ngu tu tu ngayun xi nechuntuhun nguehe Jerusalén xi cuatjin hyúun mé xi sehe cavatju camá ni? ―‍Cuatjin xu cachja cha cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo cha: ―‍¿Mé xcusun jan? ―‍Cuatjin xu cachja me. Hane cha xi cuacun jan ne, cuitjin xu cachja cha: ―‍Xcusun xi cavatju ngu me xi hmí rë Jesús camá, ngu me xi canduva tsëhë nandya Nasaret. Me vëhë ne, xi camá rë Nina cojo xi camá rë yëjë ni xuta ne, ngu profeta me, xi jemu tjin rë me ngahñu xi casahmi me yëjë ni xcusun xi casahmi me, hacuaha xi cavicuya me yëjë ni cjua xi cavicuya me. ");
INSERT INTO maqNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Hacuaha nahmi xi matitjun cojo xutaxa rë yungun naja ne, casahmi me entregadu me vëhë cojo xutaxa rë Roma xi cueya me. Hane cuaha jain tjin cavetaha me xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ngayin ne, ha cavetihin tacuín xi me vëhë xi cuaxëtje naja me ngayejen ni ngayaan xuta tjë rë Israel. Cojo yëjë sa ne, quihndë ne, ha camá jyan nixtin cavatju xcusun xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Hacuaha ngujo yachjin tsëhë ladu niji ne, catsisca na cjuatacun niji, tsëhë xi xati sa nguitajñu ne, quiji xu na xcun tsjun, ");
INSERT INTO maqNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","hane xi casacuiin rë na nima ne, cafehe cachja na cojo niji xi cavëë na sacuaha ángel ngajan, hane cachja cojo rë na xi me vëhë ne, tacun me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hya xi camá ne, ngujo cha xi siu cojo niji ne, quiji cha xcun tsjun jan, cavëë cha xi quixi jain cjua xi cachja na, peru me vëhë ne, cahviin cha me. ―‍Cuatjin xu cachja cha cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sehe ngajan xi Jesús ne, cuitjin xu cachja me cojo cha: ―‍Ngayun yuma hasen, ngayun xi jemu tafi sehe macjain nuju yëjë cjua xi cachja profeta. ");
INSERT INTO maqNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Hacuiin hatuxa casahmi ngujyë xi me xi catsingatju Nina ne, cuatjin cavatju me cjuañihi, sehe camajyë camahnga me cojo hasen ndajyihi rë me? ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hane sehe ngajan xi Jesús ne, casuacuenda xu me cha mé vijne yëjë ni cjua xi camahindu tsëhë me xcun yëjë ni xujun rë Nina, cavetsihin me cojo cjua xi catsihindu Moisés, hane cajnetaha me cojo hisca cjua xi catsihindu yëjë sa profeta. ");
INSERT INTO maqNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hya xi camá ne, xi camatiña xu cha cojo Jesús nandya hiscan cjui cha jan ne, Jesús ne, casahmi xu me sacuaha xi cjuenduju sa me. ");
INSERT INTO maqNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Peru cha xi cuacun jan ne, jercu cjín xu cachja cha cojo rë me cuitjin: ―‍Tinechun cojo niji ta quihndë ne, ha quiji hora hacuaha hisca meje cjuë nixtin. ―‍Cuatjin xu cachja cha. Ngajan xi Jesús ne, quiji xu me cojo cha, hane cavisehen me ndava cha xi cuejña me cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hane xi ha cafaha me cahndë́ rë me xcun maxë xi sinë me niñu cojo cha ne, sehe cafaha xu me ngu niñu, hane casua me nacuechji rë Nina, sehe cavatëlanga me, casua xu me cha. ");
INSERT INTO maqNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hane hora vëhë xu casua Nina cahndë́ xi camá cavëë cha xi hacui Jesús. Hya xi camá ne, ha tu ñahñu cafëya xu me. ");
INSERT INTO maqNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hane sehe cachja xu cha ngajñi rë cha cojo xicjin cha cuitjin: ―‍¡Jercu ndaja camahani camá rë xahasen naja, hora xi tichja me cojo naja ngajan ndiya jan mé vijne cjua xi hincha xcun xujun rë Nina! ―‍Cuatjin xu cachja cha cojo xicjin cha. ");
INSERT INTO maqNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hane hora vëhë ni ne, cavisatjenhnga xu cha tsëhë maxë jan, sehe cavuya quiji cha Jerusalén. Hane xi cafehe cha jan ne, casacutsja xu cha me xi tengu jan, tjintangun me cojo me xi yahnga sa. ");
INSERT INTO maqNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hane sehe cachja xu me cojo cha cuitjin: ―‍Quixi jain xi cavuya Nai naja cjuahñu, hacuaha cha Simón ne, cavëë cha me. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ngajan xi cha xi cuacun jan ne, casuacuenda xu cha hacutjin cavatju cha camá ngajan ndiya, hacuaha hacutjin camá cavëë cha xi hacui Jesús hya xi cavatëlanga me niñu. ");
INSERT INTO maqNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hane tu tichja cuaha xu cha xi cuacun jan cojo me vëhë cjua jan ne, ha tu ñahñu cavëë xu yëjë me Jesús, secun me ngajñi rë me. Hane Jesús ne, cachja xu me nina cojo rë me cuitjin: ―‍Nina sua nuju me cjuandaja cjuajeya. ―‍Cuatjin xu cachja me. ");
INSERT INTO maqNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hane yëjë xuta ladu rë Jesús jan ne, jemu catsacjun camaha xu ni me camá tsëhë xi xi má rë me ne, tivutsejen me ngu hasen. ");
INSERT INTO maqNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ngajan xi Jesús ne, cachja xu me cuitjin: ―‍¿Mé má cuatjin jemu fircun nuju? Hacuaha ¿mé má cuatjin mangu majo tacún? ");
INSERT INTO maqNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chutsujun ntsa cojo ntsacú ta ngahan vi. Nduvun tetuhun ntsun ná, hacuaha chutsujun ná ta ngu hasen ne, tsajin yojo rë hacuaha tsajin nínda rë sacuatjin chutsujun ná ngahan cojo yojo cojo nínda naha. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hane xi cavatju cachja me cjua vëhë ne, sehe catsingacun xu me tsja me cojo ntsacu me. ");
INSERT INTO maqNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hane xuta ladu rë Jesús jan ne, hisca maji xu macjain rë me ngatsë rë xi jercu tu ndaja má camahani rë me hacuaha hisca fircun rë me. Ngajan xi Jesús ne, cavinenguise xu me xuta jan cuitjin: ―‍¿Há tjin nuju hitsë xi xinëë nguehe? ―‍Cuatjin xu cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Hane ngu me jan ne, casua xu me ngu rquí ti camatsju. ");
INSERT INTO maqNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Hane xi cafaha me ne, cajinë xu me xcun yëjë ni xuta. ");
INSERT INTO maqNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sehe cachja xu me cuitjin: ―‍Yëjë xcusun xi cavátju camá ne, tsëhë vëhë cjua xi cachjá cojo nuju hya xi tejña cuaha ngajñi nuju. Cachjá cojo nuju ta hatuxa meje rë xi cuetjucaa yëjë hacutjin camahindu tsahan xcun xujun xi catsihindu Moisés cojo xcun xujun xi catsihindu profeta, cojo xcun xujun tsëhë Salmo. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sehe ngajan xi Jesús ne, cavuxaha xu me cjuatacun rë xuta jan, cojo sa xi cuijnercu me cjua xi camahindu xcun xujun rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hacuaha cachja xu me cuitjin: ―‍Cuitjin camahindu xi me xi catsingatju Nina ne, hatuxa cuatju me cjuañihi, hane xi cjuë jyan nixtin xi cueya me ne, cuya nga me cjuahñu, ");
INSERT INTO maqNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","hacuaha sacú cumachaya rë yëjë ni xuta tsëhë ngasunhndë xi sá xi mangucacun me cojo me vëhë hacuaha tsindeya me cjuatacun rë me ne, tsinchataha Nina me tsëhë jyë́ rë me. Jerusalén vi ne, nguehe cuetsihin cuitsojo cjua vëhë. ");
INSERT INTO maqNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ngayun cuinújun cojo xuta cjua vihi ta ngayun xi cahyun hacutjin camá. ");
INSERT INTO maqNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chutsujun ni, ngahan tsingátju nuju Hasen xi ha cachja Nahmi naha xi sua nuju me. Peru ha tinechun ni nguehe nandya vihi hisca xi chjuhunntsun Hasen vëhë, xi cuinduva hisca ngahnga. ―‍Cuatjin xu cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hya xi camá ne, cavaxëxin xu Jesús xuta ladu rë me tsëhë nandya Jerusalén, quijicojo me me hisca nandya Betania. Hane xi cafehe me jan ne, catsiquijin xu Jesús tsja me hane catsinchacun me xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hane ngajñi rë xi titsinchacun me xuta jan ne, cavetjuxin xu me quiji me ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hane xuta ladu rë Jesús jan ne, xi cavatju cafaharcun me Jesús ne, sehe cavuya nga xu me Jerusalén cojo jemu jyë cjuasua. ");
INSERT INTO maqNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hacuaha nchunchujun ni quiji xu me yungun xi matitjun, vaxëndaja me Nina.");
INSERT INTO maqNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ntsacu cavetsihin ngasunhndë ne, ha tacun ngu me xi hmí rë Cjua. Me vëhë ne, tacun me cojo Nina, hacuaha Nina me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Me vëhë ne, hisca ntsacu cavetsihin ne, ha cuatjin tacun me cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yëjë ni xi tjin ne, cojo me vëhë catsindaja Nina. Tsajin mé xi camandaja xi cuajin me vëhë camandaja. ");
INSERT INTO maqNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Me vëhë xi hatuxa tjin rë me cjuahñu, hane cjuahñu vëhë ne, vëhë sua cjuahasen xi cuma rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hane cjuahasen vëhë ne, vitsojo ngajñi rë cjuatsehen sacuatjin sahmi hasen ngu ndihi ngajñi jñú, peru cjuatsehen ne, cacaain rë catsicjë rë cjuahasen jan. ");
INSERT INTO maqNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Cavéjña ngu me xi hmí rë Juan, xi Nina catsingatju rë. ");
INSERT INTO maqNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Me vëhë ne, cavetjujñi me xi cuichja me cojo xuta hane tsinguixi me tsëhë cjuahasen jan, cojo sa xi ngatsë rë cjua xi cuichja me ne, cumacjain rë yëjë ni xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hacuiin me vëhë xi cjuahasen jan me ta me vëhë ne, cavetjujñi me cojo sa xi cuichja me tsëhë cjuahasen jan. ");
INSERT INTO maqNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cjuahasen xi cjuaquixi jan ne, xi visehen ngajñi rë cjuatacun rë yëjë xuta ne, sehe canduva nguehe ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Me xi hmí rë Cjua jan ne, cavéjña me ngasunhndë. Hacuaha handasa cojo me xi catsindaja Nina ngasunhndë ne, peru xuta ne, hvíin me yo. ");
INSERT INTO maqNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Canduva me ngasunhndë rë suvá me, peru xuta nangui rë suvá me ne, cafahatsjaain rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Peru ngu jo xuta nangui rë me xi cafahatsja rë me hacuaha camangu cacun cojo rë me ne, me xi Cjua jan ne, casua me chuva rë xi cuma xuta xi cuacun jan quihndi rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Xuta xi cuacun jan ne, hacuiin camá me quihndi rë Nina chuva rë xi meje rë ngu xihin ngu quihndi ta suvá Nina casahmi me xi camá xuta xi cuacun jan quihndi rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Me xi Cjua jan ne, camá me ngu xuta, hacuaha cavéjñacahndë me ngajñi niji. Hatuxa quitsë rë xahasen rë me cjuandaja, quitsë rë xahasen rë me cjuaquixi. Ngayin ne, cahyin hacutjin xi jemu jyë hnga me cojo hasen rë me. Jyë hnga me sacuatjin casahmi rë me Nahmi rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Vitenda rë Xuta ne, cachja me cojo xuta tsëhë me xi Cjua jan, cuitjin cachja me: ―‍Me vihi xi cachjá tsëhë, xi me xi sehe cuinduva ne, handasa ngahan canduvá titjun ne, peru me vëhë xi hitsë sa venguichji rë me xi cuma ná ngahan, tsëhë xi ha tacun me hya xi catsin ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tsëhë xi hatuxa jemu quitsë rë xahasen rë me cjuandaja ne, vëhë xi ngayejen ni ne, hacuaha jemu cachjahanntsan cjuandaja. ");
INSERT INTO maqNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ley rë Nina ne, nima Moisés casua naja me, peru cjuandaja cojo cjuaquixi ne, Jesucristu casua naja me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tsajin camahani yo xi cavëë rë Nina. Suvá ni Quihndi ngu rë Nina xi hacuaha nina me hacuaha tacun tangun me cojo Nina Nahmi naja ne, me vëhë casua me camachaya naja yo xi Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Cuitjin cachja Juan hya xi catsingatju xutaxa rë tsëhë nandya Jerusalén ngu jo nahmi cojo sacristán xi cjue cjuinenguise rë me Juan cuitjin: ―‍Ngayun ne, ¿yo ngayun? ―‍Cuatjin cjuinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hane hora xi cuatjin cavinenguise me ne, Juan ne, catsinguixi me, hacuiin cavetsangui me, cuitjin catsinguixi me: ―‍Hacuiin ngahan Xihin xi Tsingatju Nina. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ngajan xi cavinenguise nga nahmi xi cuacun jan cuitjin: ―‍¿Mé ni ni? ¿Há xutachanga naja Elías ngayun? ―‍Cuatjin cavinenguise me. Ngajan xi Juan ne, cuitjin cafayangui me: ―‍Hacuiin ngahan. ―‍Cuatjin cafayangui me. Ngajan xi cavinenguise nga nahmi xi cuacun jan cuitjin: ―‍¿Há ngayun profeta xi jemu nechanyan rë? ―‍Cuatjin cavinenguise me. Hane Juan ne, cuitjin cafayangui nga me: ―‍Jéya. ―‍Cuatjin cafayangui nga me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ngajan xi nahmi xi cuacun jan ne, cavinenguise nga me cuitjin: ―‍¿Yo ngayun ni? Tinújun cojo niji ne, cojo sa xi cuma nicuyin ngu cjua tsëhë me xi catsingatju niji. ¿Mé nújun tsujun suvun? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ngajan xi Juan ne, cuitjin cafayangui me: ―‍Ngahan ne, xuta xi jercu hñu chjá nguehe hiscan jemu xín tsëhë nandya, xi catitsinguixi xuta ndiya tsëhë Nai naja, sacuatjin cachja profeta Isaías hatsëë nixtin. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Quihndë ne, xuta xi cuacun catsingatju cha partidu fariseo xi cuichja me cojo Juan ne, ");
INSERT INTO maqNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","cuitjin cavinenguise me: ―‍¿Mé má cuatjin vitendun xuta sa xi hacuiin ngayun xi Tsingatju Nina ngayun, hacuiin ngayun xi profeta Elías ngayun, hacuiin ngayun xi profeta xi jemu nechanyan rë ngayun ni? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ngajan xi Juan ne, cuitjin cafayangui me: ―‍Ngahan ne, cojo nandá tiviténda nuju, peru ngajñi nuju secun ngu me xi hyúun yo. ");
INSERT INTO maqNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngahan ne, canduvá titjun, sehe canduva me vëhë, peru hisca tsajin mé cumachjirëhë ngahan xi cuma rë me. ―‍Cuatjin cafayangui Juan. ");
INSERT INTO maqNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Xcusun vëhë ne, camá ngajan ngu cahndë́ hiscan xi hmí Betania, ngunda vëhë tsëhë ndajyë Jordán, hiscan tivitenda Juan xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Xi camá nchujun jan ne, cavëë Juan xi nduva Jesús hiscan secun me. Hane cuitjin cachja Juan cojo xuta: ―‍¡Chutsujun ni! Cuajyihi me xi sacuaha chu tsánga xi sua Nina xi tsicjë jyë́ rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Me vëhë xi cachjá cojo nuju xi me xi sehe cuinduva. Handasa ngahan canduvá titjun ne, peru me vëhë xi hitsë sa venguichji rë me xi cuma ná ngahan, tsëhë xi ha tacun me hya xi catsin ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngahan suva ne, hveen yo me. Peru cojo sa xi ngayaan xuta tjë rë Israel cumachaya naja yo me ne, vëhë xi cuitjin tiviténda xuta. ―‍Cuatjin cachja Juan. ");
INSERT INTO maqNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Hacuaha cachja Juan cuitjin tsëhë Jesús: ―‍Ngahan ne, cahvë Hasen rë Nina xi canduvajne tsëhë ngahnga sacuaha ngu paloma, quiji casesun rcu me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ngahan suva ne, hveen yo me, peru me xi cavitexa ná xi cuiténda xuta cojo nandá ne, cuitjin cachja me cojo ná: “Me xi che xi cuinduvajne Hasen naha cjue sesun rcu ne, me vëhë xi cuitenda me xuta cojo Hasen naha.” Cuatjin cachja Nina cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ngahan ne cahvë hacuaha cachjá cojo xuta xi me vëhë xi Quihndi rë Nina me. ―‍Cuatjin cachja Juan. ");
INSERT INTO maqNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Xi camá nchujun nga jan ne, secun Juan cojo jo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hane xi cavëë Juan Jesús xi tivatju me jan ne, cachja me cuitjin: ―‍¡Chutsujun ni! Cuajyihi me xi sacuaha chu tsánga xi sua Nina. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Xi cahndë jo xuta ladu rë Juan cjua jan ne, quijitjengui me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Xi cavuya Jesús cavutsejen me xi cjuitjengui xuta jan me ne, sehe cavinenguise Jesús me cuitjin: ―‍¿Mé meje nuju ngayun? ―‍Cuatjin cavinenguise me. Ngajan xi xuta jan ne, cuitjin cafayangui me: ―‍Maestro, ¿jani nechun? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ngajan xi Jesús ne, cuitjin cachja me cojo jo xuta jan: ―‍Nduvun chutsujun. ―‍Cuatjin cachja me. Hane xi quiji vutsejen xuta jan ne, sehe cavëë me hiscan véjña Jesús. Sacuaha chuva rë fane ñuju hora vëhë. Hane caviyuju me ngajan cojo Jesús nixtin hya. ");
INSERT INTO maqNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ngu xuta ladu rë Juan xi cahndë sacuatjin cachja me hacuaha quijitjengui rë Jesús ne, hacui Andrés, me xi hntsë Simón Pedru. ");
INSERT INTO maqNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Me vëhë titjun quiji jaha me hntsë me Simón, hane xi casacu rë me ne, cuitjin cachja me cojo: ―‍¡Cahyin Mesías! ―‍Cuatjin cachja me. (Mesías ne, hacui cjua xi meje cuichja: Me xi Tsingatju Nina.) ");
INSERT INTO maqNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hya xi camá ne, Andrés ne, quijicojo me Simón xicjin me ngajan hiscan tacun Jesús. Hane xi cafehe me jan ne, cavutsejenya Jesús xcun Simón ne, sehe cachja me cuitjin cojo rë me: ―‍Ngayun ne, Simón hmí nuju, peru chjuhunñuhu Cefas. ―‍Cuatjin cachja Jesús. (Ñihi xi Cefas ne, tangun vijne cojo ñihi xi Pedru ta catsijo ni ne, ndyojo, meje cuichja.) ");
INSERT INTO maqNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Hane xi camá nchujun jan ne, cavejña cacun Jesús xi cjue me ngu nandya tsëhë distritu Galilea. Chaja sa xi cjue me ne, cavechútáha me Felipe, hane cachja me cojo cuitjin: ―‍Nduvun, cuanguen cojo ná. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe ne, Betsaida nangui rë me, hiscan nangui rë Andrés cojo Pedru. ");
INSERT INTO maqNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Hya xi camá ne, Felipe ne, quiji jaha me Natanael, hane xi casacu rë me ne, cachja me cuitjin: ―‍Cahyin ngu xuta Nasaret xi hmí rë Jesús, quihndi rë José. Me vëhë xi catsihindu Moisés cojo jingu sa profeta tsëhë, ngajan xcun xujun rë Nina. ―‍Cuatjin cachja Felipe cojo Natanael. ");
INSERT INTO maqNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ngajan xi Natanael ne, cavinenguise me cojo Felipe cuitjin: ―‍¡Ja! ¿Há cuma cuetjujñi ngajan Nasaret ngu xuta xi jemu venguichji rë ni? ―‍Cuatjin cavinenguise Natanael. Ngajan xi cafayangui Felipe cuitjin: ―‍Ndove chutsijin ni. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hane xi cavëë Jesús xi camatiña Natanael ne, sehe cachja me cuitjin tsëhë: ―‍Chutsujun ni, cuajyihi ngu me xi xuta tjë rë Israel xi cjuaquixi jain, ngu me xi tsajin cjuandacha cahntsua xahasen rë. ―‍Cuatjin cachja Jesús tsëhë Natanael. ");
INSERT INTO maqNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ngajan xi Natanael ne, cuitjin cavinenguise me Jesús: ―‍¿Hacutjin má xi cuatjin hyun yo ngahan ni? ―‍Cuatjin cavinenguise Natanael. Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Chaja sa xi cuichja Felipe cojo nuju ne, ngahan ne, ha cahvë nuju hya xi sechun ngahma yaxujun jan. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Hane Natanael ne, cuitjin cachja me: ―‍Maestro, Ngayun xi Quihndi rë Nina ngayun, ngayun xi matitjun ngayun tsajan ngayaan xuta tjë rë Israel. ―‍Cuatjin cachja Natanael. ");
INSERT INTO maqNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ngajan xi Jesús ne, cachja me cuitjin: ―‍Ngayun ne, camangu tacún cojo ná, tsëhë xi cachjá xi cahvë nuju hya xi nechun ngahma ya higo jan. Peru sehe chutsujun sa xcusun xi cuetjucaa xi hitsë sa venguichji rë. ");
INSERT INTO maqNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Hacuaha cachja sa Jesús cjua vihi: ―‍Cuichjá cojo nuju cjuaquixi ta ngayujun ni ne, cuechú nixtin xi chutsujun xi ngahnga ne, sacuaha xi tixaha, hacuaha ángel rë Nina ne, sacuaha xi cjuijne cjuiniji hiscan tejña ngahan xi Quihndi rë Xuta Jain ngahan. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hane xi cavatju jyan nixtin ne, camá ngu cjuavixan ngajan Caná, distritu Galilea. Naa rë Jesús ne, ngajan quitahá me ndava suhi. ");
INSERT INTO maqNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Hacuaha Jesús cojo xuta ladu rë me ne, hacuaha camá me invitar xi cjue me ndava suhi, hane quiji me. ");
INSERT INTO maqNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hya xi camá ne, cafë xan xi tsëhë suhi jan. Sehe ngajan xi naa rë Jesús ne, cuitjin cachja me cojo Jesús: ―‍Ha quihndë tsajin rë me xan nguehe. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Hacuiin cuenda naha xi ngahan nújun cojo ná. Cjëë cuechú hora xi sahme mé xi sahme. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngajan xi naa rë Jesús ne, cuitjin cachja me cojo cha xi vincha xan jan: ―‍Tu mé ni xi cuichja cha cojo nuju ne, cuatjin nihñu. ―‍Cuatjin cachja naa rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Quihndë ne, siu ngajan jyun tiji xi ndyojo camá, xi xincha nandá xi vitejnu xuta tjë rë Israel hitsë tu mé ni xcusun xi sahmixa me cojo, sacuatjin xi ha xcusun rë yungun rë me. Jima ngu tiji jan ne, xincha sacuaha yachantë o sa jyanchantë litru nandá. ");
INSERT INTO maqNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ngajan xi cachja Jesús cojo cha xi vincha xan cuitjin: ―‍Ninguitsun rë tiji xi cuacun vë cojo nandá. ―‍Cuatjin cachja me. Ngajan xi cha xi cuacun jan ne, catsinguitsë camahani rë cha tiji jan cojo nandá. ");
INSERT INTO maqNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hya xi camá ne, sehe cachja nga Jesús cuitjin cojo cha: ―‍Quihndë ne, chjuhun hitsë xi cavinchun tiji vë ne, tángun chanu rë xutacha. ―‍Cuatjin cachja me. Hane cuatjin casahmi cha xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hya xi camá ne, cavutaha xutacha jan nandá xi camá xan jan. Me vëhë ne, hisca hvíin me jani canduva xan jan, peru cha xi vincha xan xi cafaha quijicojo jan ne, vëë cha. Ngajan xi xutacha jan ne, cajindaya me cha xutavixan jan ne, ");
INSERT INTO maqNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","sehe cachja me cojo cha cuitjin: ―‍Xcusun naja ne, titjun xan xi ndajyihi taan hvi xuta, hane ha xcun xi ha cjín cahvi me ne, sehe taan rë me xan xi ha va jyihi. Peru ngaye ne, hisca ndicumaha ni titehe xan xi ndajyihi. ―‍Cuatjin cachja xutacha jan. ");
INSERT INTO maqNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Cjuarcun xi tjun tjun casahmi Jesús vë ne, casahmi me ngajan Caná, distritu Galilea. Cuatjin catsingacun me xi jemu jyë hnga me cojo hasen rë me. Hane xuta ladu rë me ne, camangu cacun me cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Xi cavatju vëhë ne, cavetju me quijijne me nandya Capernaum. Quiji me cojo naa rë me cojo xicjin me cojo xuta ladu rë me. Hane ngajan caviyujutaha me ngujo nixtin. ");
INSERT INTO maqNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Cavechú nixtin xi camatiña suhi xi hmí rë Pascua, ngu suhi xi sahmi xuta tjë rë Israel. Ngajan xi Jesús ne, quijiniji me ngajan nandya Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hane xi cafehe me jan ne, quiji me yungun xi matitjun. Ngajan cavëë me xuta xi tiviteña chu ndyaja cojo chu tsánga cojo chu nisëtyava, hacuaha cavëë me xuta xi siu titsindeya tujún tsëhë xuta cojo tujún rë yungun. ");
INSERT INTO maqNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hane xi cavëë Jesús xi cuatjin tisahmi xuta jan ne, cafaha me ngu nahñu xi jiña ne, casahmi me ngu cuarta, sehe catsicanga me yëjë ni chu xteña, sa ndyaja sa tsánga. Hacuaha cacandi me tujún rë xuta xi tsindeya tujún, hacuaha catsindefa me maxë xi xinchasun tujún jan. ");
INSERT INTO maqNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hane xuta xi tiviteña chu nisëtyava jan ne, cuitjin cachja Jesús cojo rë me: ―‍Tángunxun cojo chu xi cuicun vi. Xicanihñuu ndava Nahmi naha sacuaha ngu ndetsin. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ngajan xi xuta ladu rë Jesús jan ne, catsinguitsjen me xi camahindu xcun xujun rë Nina cuitjin: “Ngayun Nina naha, xi jemu hmú cácun camahani ndya nuju ne, ña sca má rë xahasen naha.” Cuatjin camáhindu. ");
INSERT INTO maqNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ngajan xi xutaxa rë yungun jan ne, cuitjin cachja me: ―‍Quihndë ne, ¡jarë ngu cjuarcun xi nihñu cojo sa xi cumachaya niji xi tjin jain nuju chuva rë xi cuatjin nihñu! ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Ninguetsun yungun vihi ne, cahntsua xi jyan nixtin ne, ngahan sahme ndaja nga. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hane xutaxa rë yungun xi matitjun ne, cuitjin cachja nga me: ―‍Yachan jyun nu quiji cani rë xi camandaja yungun naja vi. Hane sehe ngayun nujún ne, ¡cahntsua xi jyan nixtin ne, cuyun nindujun nga ni! ―‍Cuatjin cachja xutaxa rë yungun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Peru Jesús ne, hya xi cachja me tsëhë yungun jan ne, tsëhë yojo rë suvá me xi cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Vëhë xi hya xi cavuya Jesús cjuahñu ne, xuta ladu rë me ne, catsinguitsjen me xi cuatjin cachja Jesús, hane camacjain rë me cjua xi chja xujun rë Nina hacuaha camacjain rë me cjua xi cachja Jesús jan. ");
INSERT INTO maqNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jinguyëjë rë xi cuatjin quitahá Jesús ngajan Jerusalén nixtin rë suhi tsëhë Pascua ne, jemu cjín xuta camangu cacun me cojo rë me, xi cavëë me cjuarcun xi Jesús tisahmi me. ");
INSERT INTO maqNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Peru suvá Jesús ne, camanguaain cacun me cojo xuta xi cuacun jan ta, tsëhë xi ha vëë me xahasen rë yëjë me xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hacuaha cuatjin camanguaain cacun me cojo xuta jan ta, tsëhë xi hacuiin sahmi ngujyë xi tjin yo xi cuichja cojo rë me tsëhë xuta ta, tsëhë xi ha vëë me mé cjua xi hincha cahntsua xahasen rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Cavéjña ngu xuta fariseo xi hmí rë Nicodemo. Me vëhë ne, ngu xuta matitjun me tsëhë ngajñi rë xuta tjë rë Israel. ");
INSERT INTO maqNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ngundiya jan ne, nguixun quiji cavisiajmi me cojo Jesús, hane cuitjin cachja me: ―‍Maestro, ngayin ne, hyin ta ngayun ne, ngu maestru xi Nina catsingatju rë. Cuatjin hyin ta, tsëhë xi tsajin yo xi cuma sahmi cjuarcun xi nihñu ngayun sa xi hacuiin Nina visecoo rë. ―‍Cuatjin cachja Nicodemo cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Cuichjá cojo nuju cjuaquixi ta sa xi ngu xuta tsiin me ngu ndiya nga ne, cumaji cuisehen me hiscan sahmi Nina gubiernu. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Hane Nicodemo ne, cavinenguise me Jesús cuitjin: ―‍¿Peru hacutjin cuma xi ngu xihin xi ha changá ne, cuya tsin nga ni? ¿Há cuma cuisehen nga cahntsua naa rë sehe tsin nga ngu ndiya? ―‍Cuatjin cavinenguise Nicodemo. ");
INSERT INTO maqNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Cuichjá cojo nuju cjuaquixi ta hatuxa sahmi ngujyë xi cuisehen xuta ngu cjuahñu xatsë ngatsë rë nandá cojo ngatsë rë Hasen rë Nina ta, ha chuva rë vëhë ni xi cuma cuisehen me hiscan sahmi Nina gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hya xi ngu xuta tsin me ngatsë rë xutacha rë me ne, sacu rë me cjuahñu xi tsëhë ngasunhndë. Peru hya xi tsin me ngatsë rë Hasen rë Nina ne, sacu rë me cjuahñu xatsë xi tsëhë Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hacuiin cjuercun nuju xi cuatjin cachjá cojo nuju xi mameje rë xi tsin nga ngayun ngu ndiya. ");
INSERT INTO maqNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tjo ne, hatuxa vanga hiscan meje rë, peru suva machaya naja xi vanga ta nuhya rë xi fane vanga, ta matsijin hiscan nduva o hiscan vechú. Hane xuta xi tsin me ngatsë rë Hasen rë Nina ne, tjin rë me sacuaha tjo jan, ta tsin me ngu ndiya nga, peru matsijin hacutjin. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ngajan xi Nicodemo ne, cuitjin cavinenguise me cojo Jesús: ―‍Peru ¿hacutjin cuma sacuatjin nújun vë ni? ");
INSERT INTO maqNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hane Jesús ne, cuitjin cafayangui me: ―‍¿Hacutjin nga ne xi ngayun ne, maestru má ngayun tsëhë xuta tjë rë Israel, hane sehe hyúun mé vijne cjua xi cachjá cojo nuju vë ni? ");
INSERT INTO maqNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cuichjá cojo nuju cjuaquixi ta ngayin ne, nújin cjua xi hyin hacuaha nújin tsëhë xcusun xi cachutsijín, peru cjua xi nújin cojo nuju ne, mijí chjuhunntsun. ");
INSERT INTO maqNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Sa xi camacjaain nuju hya xi cachjá cojo nuju cjua tsëhë xcusun tsëhë ngasunhndë ne, ¿hacutjin cumacjain nuju sa xi cuichjá cojo nuju cjua tsëhë xcusun tsëhë ngahnga ni? ");
INSERT INTO maqNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Tsajin hisca ngu xuta xi quiji cavutsejen me hacutjin jyihi ngahnga sehe cavuya me xi sua cuenda nuju me. Suvá ni me xi ha tsëhë ngajan canduva me ne, me vëhë xi cuma sua cuenda nuju me, suvá ni me xi Quihndi rë Xuta Jain. ");
INSERT INTO maqNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Chuva rë xi casahmi Moisés hatsëë nixtin xi cavunihnga me ngu quicha xcusun rë chu yë taha rë ngu ya ngajan ngu xín camahani jan ne, ha chuva vëhë ni ne, me xi Quihndi rë Xuta Jain ne, meje rë xi tjunihnga rë me taha rë ngu ya. ");
INSERT INTO maqNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Cuatjin meje rë, cojo sa xi yëjë ni xuta xi cumangu cacun me cojo rë me vëhë ne, sacú rë me cjuahñu xatsë. ―‍Cuatjin cafayangui Jesús tsëhë Nicodemo. ");
INSERT INTO maqNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","―‍Tsëhë xi jemu catsihmu cacun Nina xuta ne, hisca casua me Quihndi ngu rë me, cojo sa xi yëjë ni xuta xi cumangu cacun me cojo me vëhë ne, hacuiin cjue hasen rë me xcun cjuañihi ta sacú rë me cjuahñu xatsë xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nina ne, catsingatju me Quihndi rë me nguehe ngasunhndë, peru hacuiin xi cjuahachuva rë xuta ngasunhndë ta xi cuaxëtje rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Xuta xi mangucacun cojo Quihndi rë Nina ne, hacuiin chjaháchuva rë me. Peru me xi hacuiin mangucacun cojo Quihndi rë Nina ne, ha cachjaháchuva rë me ta, tsëhë xi hacuiin mangucacun me cojo me xi Quihndi ngu rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hane cuitjin fahachuva Nina xuta ngasunhndë: Nina ne, ha catsingatju me Quihndi rë me ngasunhndë sacuaha ngu ndihi xi sua hasen rë. Peru xuta ne, hitsë sa cachuya rë me tsëhë jñu xi cuma rë hasen ta, tsëhë xi xcusun xi casahmi me ne, suvá cjuatsehen. ");
INSERT INTO maqNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yëjë ni xuta xi sahmi xcusun tsehen ne, hatuxa chuyiin rë me tsëhë hasen, hisca sahmitiñaai me hiscan xi hasen, sa tu sesunhnga xcusun xi sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Peru xuta xi ndiya rë cjuaquixi xcusun xi sahmi me ne, sahmitiña me hiscan xi hasen, cojo sa xi sesunhnga xi xcusun xi sahmi me ne, vëhë xcusun xi meje rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hya xi camá ne, quiji Jesús cojo xuta ladu rë me ngajan nguijña tsëhë distritu Judea. Hane ngajan caviyujutahá cojo me xuta xi cuacun vë. Hane cavitenda me xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hacuaha ha nixtin hya ni ne, Juan Vitenda rë Xuta ne, tivitenda me xuta ngajan hiscan xi hmí rë Enón, tiña tsëhë Salim. Ngajan quitahá me ta, tsëhë xi ngajan ne, jemu yehe nandá tjin. Hane hacuaha quiji xuta caxtenda me. ");
INSERT INTO maqNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nixtin hya ne, cjëë cjue Juan jan ndavaya. ");
INSERT INTO maqNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Quihndë ne, ngujo xuta ladu rë Juan ne, cavetsihin ticjanjo cjua rë me cojo ngu xutaxa rë yungun tsëhë xcusun changá rë me xi ma tyjahi me xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hya xi camá ne, quiji cachja me cojo Juan cuitjin: ―‍Maestro, ¿Há vitsjen nuju me xi casetaha cojo nuju ngunda vëhë tsëhë ndajyë Jordán, me xi canújun cojo niji tsëhë jan? ¡Chutsujun ta hacuaha cojo me vëhë tivitenda me, hane yëjë ni xuta cjuitjengui rë me! ―‍Cuatjin cachja xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ngajan xi Juan ne, cuitjin cafayangui me: ―‍Tsajin mé xi sacú cjuahatsja ngu xuta sa xi Nina suaain rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ngayun suvun ne, ha canuhyun xi cachjá xi hacuiin ngahan Xihin xi Tsingatju Nina ta ngahan ne, cha xi catsingatju titjun Nina, sehe catsingatju Nina me vëhë. ");
INSERT INTO maqNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Chutsujun ta na xutavixan ne, tsëhë cha xutavixan na. Peru ngu cha amigu ndaja rë cha xutavixan xi secun tivisiñuju cjua rë cha xutavixan jan ne, jercu ndama rë cha tsëhë cjua rë cha vëhë. Vëhë xi ngahan xi sacuaha cha amigu rë cha xutavixan vë ne, jercu tu ndaja camahani má ná. ");
INSERT INTO maqNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Me vëhë ne, meje rë xi quihndë nga nchujun cuma jyë cuma hnga sa me cojo xa rë me, peru ngahan ne, hacuiin cuatjin ta xi meje rë ne, cuijnetaha xa naha. ―‍Cuatjin cafayangui Juan. ");
INSERT INTO maqNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Me xi nduva tsëhë ngahnga ne, me vëhë xi hitsë sa jemu vengui chji rë me xi cuma rë yëjë xuta. Ngayaan xi tsëhë ngasunhndë ngayaan ne, ha xuta ngasunhndë ni ngayaan, hacuaha suvá cjuatacun rë ngasunhndë xi visiajme. Me xi nduva tsëhë ngahnga ne, me vëhë xi hitsë sa jemu vengui chji rë me xi cuma rë yëjë xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Me vëhë ne, sua me machaya naja tsëhë xcusun xi cavëë me cojo tsëhë cjua xi cahndë me, peru xuta ne, fahatsjaain me cjua xi chja me vëhë. ");
INSERT INTO maqNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Peru ngujo xuta ne, fahatsja me cjua rë me vëhë, hane cuatjin maquixi xi Nina ne, quixi jain me cojo cjua rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Me xi Nina catsingatju rë ne, cjua rë Nina chja me ta, tsëhë xi Nina ne, hacuiin chuva hitsë sua me Hasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nina Nahmi naja ne, jemu hmu cacun me Quihndi Ngu rë me, hacuaha yëjë ni xcusun ne, cavejña me tsja Quihndi rë me jan. ");
INSERT INTO maqNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Xuta xi mangucacun me cojo Quihndi rë Nina jan ne, tjin rë me cjuahñu xatsë. Peru xuta xi vihndiin me tsëhë Quihndi rë me jan ne, sacuiin rë me cjuahñu xatsë ta castigu rë Nina cuatju me cuma. ");
INSERT INTO maqNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Quihndë ne, cha fariseo ne, camachaya rë cha xi Jesús ne, hitsë sa cjín jima xuta ladu rë me xi cuma rë xuta ladu rë Juan, hacuaha hitsë sa cjín xuta tivitenda me xi cuma rë xuta xi tivitenda Juan. ");
INSERT INTO maqNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Peru suvá Jesús ne, cavitendaain me ta xuta ladu rë me ne, me vëhë xi cavitenda me xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Hane xi camachaya rë Jesús xi cuatjin camachaya rë cha fariseo xi cuacun vë ne, cavetjuxin me tsëhë distritu Judea. Hane cavuya quiji nga me ngu nandya tsëhë distritu Galilea. ");
INSERT INTO maqNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Hane ndiya xi cjui me jan ne, tjin xi cuatju me ngujo nandya tsëhë distritu Samaria. ");
INSERT INTO maqNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Hya xi camá ne, cafehe me ngu nandya tsëhë distritu Samaria xi hmí rë Sicar, ngu nandya xi tacun tiña tsëhë nangui xi casua Jacob quihndi rë me José jemu hatsëë camahani. ");
INSERT INTO maqNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hane cahndë́ vëhë ne, tacun ngu ndava nandá xi casahmi Jacob. Hane tsëhë xi jemu cafenda rë Jesús tsëhë ndiya xi nduva me ne, quiji me cavéjña me hiscan ndava nandá jan. Sacuaha chuva rë nchisen xi cafehe me jan. ");
INSERT INTO maqNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Hora vëhë ne, canduva ngu na samaritana, canduva jaha na nandá. Hane cuitjin cachja Jesús cojo rë na: ―‍Tuhun hitsë nandá cuëhë. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Hora vëhë ne, tsajin xuta ladu rë Jesús ta nandya quiji me xi cuatsë me xi sinë me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ngajan xi na samaritana jan ne, cuitjin cachja na cojo Jesús: ―‍Ngayun xi xuta tjë rë Israel ngayun ne, ¿hacutjin má xi tichjahyun ná nandá, ngahan xi na samaritana ngahan ni? ―‍(Cuatjin cachja na ta, tsëhë xi xuta tjë rë Israel ne, hatuxa tsinguisihinjñii me cojo xuta samaritana.) ");
INSERT INTO maqNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ngajan xi Jesús ne, cuitjin cafayangui me tsëhë na: ―‍Sa xi ngayun hyun cjuatjo xi Nina sua me hacuaha hyun yo ngahan xi tifehya nuju nandá ne, ngahan cachjahyun ná nandá, hane ngahan casuá nuju nandá xi sua cjuahñu. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hane na vëhë ne, cuitjin cachja na: ―‍Tatá, peru ndava nandá vi ne, jemu nungun, hane tsajin quichuhun mé xi naxun cojo nandá. ¿Jani naxun nandá xi sua cjuahñu vë ni? ");
INSERT INTO maqNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Xutachanga naja Jacob casua niji me ndava nandá vi. Hacuaha cojo me cojo quihndi rë me cojo chu rë me cahvi me nandá tsëhë ndava nandá vihi. ¡Ja! Peru ¿há hitsë sa matitjun ngayun xi cuma rë me vëhë ni? ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Hane xi cafayangui Jesús ne, cuitjin cachja me cojo rë na: ―‍Yëjë ni xuta xi hvi me nandá vihi ne, cuma xinda nga rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Peru xuta xi cuihi me nandá xi suá ngahan ne, hatuxa ha quihndë tsajin nu tsajin nixtin xi cuya cumaxinda nga rë me ta nandá xi suá ngahan ne, cuma sacuaha ngu nandá xi ña vangatë xi sua rë me cjuahñu xatsë. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ngajan xi na vëhë ne, cuitjin cachja na cojo Jesús: ―‍Tatá, tuhun ná hitsë nandá xi nújun vë, cojo sa xi cumaxindaain ná hacuaha ha quihndë cuinduvaan jaha nandá. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Hane Jesús ne, cuitjin cachja me cojo rë na: ―‍Tángun chjuhun xihin nuju, sehe nduvuncujun me nguehe. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ngajan xi na vëhë ne, cuitjin cafayangui na: ―‍Tsajin xihin naha. ―‍Cuatjin cafayangui na. Hane cuitjin cachja Jesús cojo rë na: ―‍Ndaja nújun xi tsajin xihin nuju ta ");
INSERT INTO maqNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","hñú cha xi cavinechuncujun, hane cha xi nechuncujun quihndë ne, hacuiin xihin nuju cha. Canújun cjuaquixi. ―‍Cuatjin cachja Jesús cojo rë na. ");
INSERT INTO maqNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ngajan xi na vëhë ne, cuitjin cafayangui na: ―‍Tatá. Xi má ná ne, ngayun ne, ngu profeta ngayun. ");
INSERT INTO maqNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xutachanga niji ne, nguehe ndetjún vihi canduva cafaharcun me Nina. Hane ngayujun ni xuta nangui rë Israel ne, nújun ta Jerusalén ne, ngajan tacun cahndë́ xi meje rë xi cjue chjahárcun rë Nina. ―‍Cuatjin cafayangui na. ");
INSERT INTO maqNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ngajan xi cachja Jesús cojo rë na cjua vihi: ―‍Ngayun chjuun, catamacjain nuju cjua xi cuichjá vi: cuechú nixtin xi hacuiin ndetjún vihi hacuiin Jerusalén chjuhunrcun Nina Nahmi naja. ");
INSERT INTO maqNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ngayun xuta samaritano ne, chjuhunrcun Nina, peru hyúun me xi ndandaja. Ngayin ne, ha hyinndijin Nina ta, tsëhë xi me xi cuaxëtje rë xuta ne, cuetjujñi me ngajñi niji ngayin xuta nangui Israel. ");
INSERT INTO maqNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Cuechú nixtin o ha hisca cavechú nixtin xi xuta xi cjuaquixi xi faharcun me Nina Nahmi naja ne, Hasen rë Nina cuisecoo rë me xi cjuaharcun me Nina cojo cjuaquixi. Ha cjuaquixi ta xuta xi cuatjin sahmi me ne, me vëhë xi meje rë Nina Nahmi naja xi cjuaharcun rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nina ne, Hasen me. Hane xuta xi faharcun rë me ne, hatuxa meje rë xi Hasen rë Nina cuisecoo rë me xi cjuaharcun me Nina cojo cjuaquixi. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Hane chjuun jan ne, cuitjin cachja na cojo Jesús: ―‍Ngahan ne, ha hvë xi cuinduva Me xi Tsingatju Nina, me xi hmí rë Cristu. Hane hya xi cuinduva me vëhë ne, suacuenda naja me yëjë ni cjuatacun. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ngajan xi Jesús ne, cuitjin cachja me cojo rë na: ―‍Ngahan xi tichjá cojo nuju vi ne, ha ngahan xi nújun vë. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hane hora vëhë cavuya xuta ladu rë Jesús xi quiji jaha me comida. Hane jemu quijircun rë me xi cavëë me xi visiajmi Jesús cojo rë ngu chjuun. Peru hisca ngu me xi cuacun vë cavinenguisiin me cuitjin: “¿Mé xi meje nuju?” o “¿mé xi visiajmu cojo rë na?” Cuatjin camá. ");
INSERT INTO maqNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chjuun jan ne, cavejña na nisa rë na, sehe cavuya quiji na nandya, hane cuitjin cachja na cojo xuta: ");
INSERT INTO maqNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―‍Nduvun cuanguen chutsejen ngu me xi cachja cojo ná yëjë xcusun xi casahme. ¿Hacuiin hacui me vëhë xi Tsingatju Nina? ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hya xi camá ne, cavetju xuta quiji me cojo rë na hiscan quitahá Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jinguyëjë rë ne, xuta ladu rë Jesús jan ne, cuitjin cachja me: ―‍Maestro, xinu niñu. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Peru Jesús ne, cuitjin cafayangui me: ―‍Ngahan ne, ha tjin xi sínë xi ngayun ne, hyúun mé jan. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ngajan xi xuta ladu rë Jesús jan ne, cuitjin cavinenguise xicjin me xingu xingu me: ―‍¿Há cuma cacun sa xi tjin yo xi cafehe cani xi cajinë me? ―‍Cuatjin cavinenguise xicjin me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Hane Jesús ne, cuitjin cachja me cojo xuta ladu rë me jan: ―‍Jemu chuya rë xahasen naja xi chinë niñu. Peru ngahan ne, hitsë sa chuya rë xahasen naha xi sahme sacuatjin meje rë me xi catsingatju ná, hacuaha hitsë sa chuya rë xahasen naha xi tsinguíjnetaha xa xi casua ná me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Chja ngu cjua ta: “Chaja sa ñuju sá, sehe tjunihnga rë xitjë.” Peru ngahan cuichjá cojo nuju ta chutsujun xuta ta, tsëhë xi tangun me cojo xitjë xi ha camacha, ha cuma tjunihnga rë. ");
INSERT INTO maqNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Me xi tivunihnga xitjë ne, ha tifaha me chji rë me, cuma cuinújan ne, tisahmi tangun me xuta xi sacú rë xuta xi cuacun vë cjuahñu xatsë. Cuatjin tijima cojo sa xi tangun cuiyujusua me xi vincha tjë cojo me xi vunihnga xitjë. ");
INSERT INTO maqNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Quixi cjua xi chja xi: “Hacjahi cha xi vincha tjë ne, hacjahi cha xi vunihnga xitjë.” ");
INSERT INTO maqNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ngahan catsingátju nuju chunihngun xitjë hiscan xi hacuiin ngayun canihñu xa. Jingusa me casahmi me xa, hane ngayun cavisuhunjñu ngajñi rë xa rë me. ―‍Cuatjin cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jemu cjín xuta samaritano tsëhë nandya jan camangu cacun me cojo Jesús, ngatsë rë cjua xi cachja chjuun jan cuitjin: “Cachja me cojo ná yëjë xcusun xi casahme.” ");
INSERT INTO maqNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ngajan xi hya xi cafehe xuta samaritano ngajan hiscan quitahá Jesús ne, cachja xuta jan cojo rë me xi cjue cuejña me cojo rë me. Hane Jesús ne, quiji cavéjña me jo nixtin cojo xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hane jemu cjín sa xuta xi camangu cacun me ngatsë rë cjua rë suvá Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hane chjuun jan ne, cuitjin cachja xuta jan cojo rë na: ―‍Ha quihndë hacuiin ngatsë rë cjua riji xi mangutacuín ta, tsëhë xi suvin canuhyin cjua rë me, hane ngayin ne, hyin ta cjuaquixindaja xi me vihi xi cuaxëtje me xuta. ―‍Cuatjin cachja xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Xi cavatju jo nixtin jan ne, cavetju Jesús cojo xuta ladu rë me, quiji me ngu nandya tsëhë distritu Galilea. ");
INSERT INTO maqNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ta suvá Jesús cachja me xi quixi xi xuta ne, faharcuaain me profeta xi tsëhë nangui rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Vëhë xi hya xi tivatju Jesús ngujo nandya tsëhë distritu Galilea ne, ndaja cafahatsja xuta me ta, tsëhë xi hacuaha cojo xuta jan quiji me suhi ngajan Jerusalén, hane ngajan cavëë me yëjë xcusun xi casahmi Jesús nixtin rë suhi jan. ");
INSERT INTO maqNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hya xi camá ne, cavuya cafehe me Caná, ngu nandya tsëhë distritu Galilea, hiscan xi casahmi me xi nandá ne, cavuya camá xan rë uva. Hane ngajan nandya Capernaum ne, cavéjña ngu xutaxa rë xi hmu rë cha quihndi rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hane xi camachaya rë me xi cafehe Jesús ngajan Caná ne, cavetju me quijitjengui me Jesús. Hane xi cafehe me jan ne, cafehya me favor cojo Jesús xi cjue Jesús cojo rë me nangui rë me xi sahmi Jesús xi cumandaja quihndi rë me ta ha tu hora sa xi cueya. ");
INSERT INTO maqNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ngajan xi Jesús ne, cachja me cuitjin cojo xutaxa rë jan: ―‍¡Ngayujun ni ngayun ne, sa xi chuun cjuarcun ne, cumanguaain camahani tacún cojo ná! ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ngajan xi xutaxa rë jan ne, cuitjin cafayangui me: ―‍Tatá, cuanguen sanii, chaja sa xi cueya quihndi naha. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hane Jesús ne, cuitjin cachja me: ―‍Cuma cuangun ta, quihndi nuju ne, jimandaja cha. ―‍Cuatjin cachja Jesús. Hya xi camá ne, xutaxa rë jan ne, camacjain rë me cjua xi cachja Jesús, hane cavetju me quiji me. ");
INSERT INTO maqNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hane ndiya cjui me ne, cavechútáha me ngujo cha mosu hndixahan rë me, hane cachja cha cojo rë me xi cha quihndi rë me ne, tijimandaja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ngajan xi xutaxa rë jan ne, cavinenguise me cojo cha hndixahan rë me jan mé hora cavetsihin camandaja cha hmu rë jan. Hane cha hndixahan rë me jan ne, cuitjin cachja cha: ―‍Ngujña fane ngu cavetjuxin chíhinsuë xi sahmi cojo cha. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hane nahmi rë quihndi jan ne, ha vëë me ta hora vëhë xi cachja Jesús cojo rë me xi quihndi rë me ne, tijimandaja cha. Cuatjin camá xi xutaxa rë jan cojo yëjë xuta rë me ne, camangu cacun me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Cuatjin camá xi, hya xi cavetju Jesús tsëhë ladu rë distritu Judea hane cafehe me Caná, distritu Galilea ne, casahmi me cjuarcun xi majo xi casahmi me ngajan. ");
INSERT INTO maqNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Xi cavatju nixtin xi cuacun vë ne, quiji Jesús ngajan Jerusalén xi cjue me suhi xi cuma ngajan yungun xi matitjun. ");
INSERT INTO maqNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Quihndë ne, ngajan Jerusalén ne, tiña tingotjo Chu Tsánga ne, ngajan tacun ngu ndava nandá xi tjin rë hñú cahndë́ ngahma ndihya. Hane ndava nandá vëhë ne, xi hne hebreo ne, Betesda hmí rë. ");
INSERT INTO maqNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Cahndë́ jan ne, jemu cjín xuta siuhmu me. Siu xuta rcá, siu xuta rengun, siu xuta xi quixíhñu yojo rë xi tacunya rë me xi cuiniya nandan ");
INSERT INTO maqNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ta jiya hora jiya hora ne, finiya nandan ta ngu ángel ne, vijne tsiniya nandan jan. Sehe cha xi tjun cuisehen ne, marqui rë tsëhë chíhin xi má rë. ");
INSERT INTO maqNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hane ngajñi rë xuta hmu rë xi cuacun jan ne, jiña ngu cha xi ha tjin rë can tyjuhunjyan nu xi hmu rë cha. ");
INSERT INTO maqNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Hane xi cavëë Jesús xi cuatjin jiña cha hacuaha ha vëë me xi ha jemu tsëë hmu rë cha ne, cavinenguise me cha cuitjin: ―‍¿Há meje nuju xi cuma ndaja ngayun? ―‍Cuatjin cavinenguise Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hane cha hmu rë jan ne, cuitjin cafayangui cha: ―‍Tatá, tsajin yo xi tsinguisehen ná ndava nandá hora xi finiya nandá. Jinguyëjë rë xi tifë́ tiña ne, hacjahi me xi ha cavisehen. ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ngajan xi Jesús ne, cuitjin cachja me cojo cha: ―‍Tisatjunhngun, chjuhun nijña nuju, sehe tujyuhunyun. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Cha vëhë ne, ha tu ñahñu camandaja cha, cafaha cha nijña rë cha, cavetsihin catsujyihiya cha. Nixtin vëhë ne, nixtin xi chjahájenda rë. ");
INSERT INTO maqNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ngajan xi xutaxa rë yungun ne, cachja me cojo cha xi camandaja jan cuitjin: ―‍Quihndë ne, nixtin xi chjahájenda rë. Ndajintjin xi cuatjin quichehe nijña riji. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hane cha xi camandaja jan ne, cuitjin cafayangui cha: ―‍Me xi casahmi xi camandaja ngahan ne, me vëhë cachja me cojo ná xi cjuahá nijña naha sehe tsujyëhëya. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ngajan xi xutaxa rë jan ne, cavinenguise nga me cuitjin: ―‍¿Hane yo xi cachja cojo ri xi chjehe nijña riji ne, sehe tujyihiye? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Peru cha xi camandaja jan ne, hvíin cha yo ta, tsëhë xi Jesús ne, cavetjuxin me tsëhë cahndë́ vëhë, tsëhë xi jemu xutacjín quitsë me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hane xi cavatju vëhë ne, cavechútáha Jesús cha ngajan yungun xi matitjun, hane cachja me cojo cha cuitjin: ―‍Chutsujun ni, camandaja ngayun. Quihndë ne, xicavinechunyuun sa ndiya rë cjuatsehen, sa tu choho sa cuatjun cuma. ―‍Cuatjin cachja Jesús cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sehe cavetju cha quiji cachja cha cojo xutaxa rë ta me xi casahmi xi camandaja cha ne, Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Vëhë xi xutaxa rë jan ne, tsujyihiyatjengui me Jesús cojo cjuahngatacun ta, tsëhë xi casahmi Jesús xcusun vëhë nixtin xi chjahájenda rë. ");
INSERT INTO maqNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ngajan xi Jesús ne, cuitjin cachja me cojo xutaxa rë jan: ―‍Nahmi naha ne, hisca quihndë tisahmi me xa, hacuaha ngahan ne, tisahme xa. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ngatsë rë cjua vëhë ne, xutaxa rë jan ne, hitsë sa cavangui me chuva rë xi tsiquehen me Jesús. Cuatjin casahmi xutaxa rë ta, tsëhë xi hacuiin suvá ni cafaharcuaain Jesús nixtin xi chjahájenda rë ta hacuaha cachja me xi Nahmi rë me ne, Nina. Hane xi cuatjin cachja Jesús ne, tsingacun me xi tangun me cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ngajan xi Jesús ne, cuitjin cachja me cojo xutaxa rë xi cuacun jan: ―‍Cuichjá cojo nuju cjuaquixi ta ngahan xi Quihndi rë Nina ngahan ne, tsajin mé xi cuma sahme xi cojo cjuatacun naha suva ta xi vutsején xi sahmi Nahmi naha ne, vëhë xi sahme. Xcusun xi sahmi me vëhë ne, hacuaha xcusun vëhë sahme ngahan Quihndi rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nahmi naha ne, hmu cacun ná me, ngahan Quihndi rë me, hacuaha tsingacun ná me yëjë xcusun xi sahmi me. Hane xcusun xi sehe tsingacun ná me ne, hisca yehe sa xi cuma rë xcusun xi casahme xi camandaja cha hmu rë jan. Cuatjin cuma cojo sa xi ngayun ne, cjuercun nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sacuatjin faha Nahmi naha nima sehe sua nga rë me cjuahñu ne, hacuanitjin ni ngahan Quihndi rë me ta suá rë cjuahñu yo xi meje suá rë. ");
INSERT INTO maqNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nahmi naha ne, tsajin yo tsichuva me cojo cjuatacun rë ta ntsa ngahan cavejña me yëjë xa vëhë, ");
INSERT INTO maqNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","cojo sa xi yëjë ni xuta ne, cjuaharcun me ngahan sacuatjin faharcun me Nahmi naha. Yo xi cjuaharcuaain ná ngahan ne, faharcuaain rë Nahmi naha, me xi catsingatju ná. ");
INSERT INTO maqNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Cuichjá cojo nuju cjuaquixi ta xuta xi vihndë me cjua xi chjá hacuaha mangucacun me cojo rë Nina, me xi catsingatju ná ne, tjin rë me cjuahñu xatsë. Hacuaha cumachuvaain me cojo cjuatacun rë me ta sacuaha xi ha cahme me hacuaha ha casacu rë me cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cuichjá cojo nuju cjuaquixi ta cuechú nixtin o ha hisca cavechú nixtin xi xuta xi hndiin tsëhë Nina sacuaha nima ne, cuihndë me xta naha, ngahan xi Quihndi rë Nina ngahan. Hane me xi cuihndë tsahan ne, sacú rë me cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Cjuahñu xi tjin rë Nina ne, tsajin yo casua rë me, ta nduva tsëhë cjuandaja rë suva me. Hane hacuanitjin ná ngahan, ta casua ná cahndë́ xi hacuaha tjin ná cjuahñu tsëhë cjuandaja rë suvá. ");
INSERT INTO maqNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Hacuaha casua ná me xa xi tsichúva xuta cojo jyë́ rë me ta, tsëhë xi ngahan ne, Quihndi rë Xuta Jain ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hacuiin cjuercun nuju tsëhë cjua naha. Cuechú nixtin xi yëjë ni nima xi hincha cahntsua tsjun rë ne, cuihndë xta naha, ");
INSERT INTO maqNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","sehe cuetju tsëhë tsjun rë. Hane nima xi ndaja xcusun casahmi xcun cjuahñu rë ne, sacú rë cjuahñu xatsë. Hane nima xi choho xcusun casahmi ne, cuatju castigu. ");
INSERT INTO maqNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ngahan ne, hatuxa tsajin mé xi sahme xi cojo cjuatacun naha suva ta, sacuatjin cjua xi víhndë xi chja Nahmi naha ne, cuatjin tsichúva xuta cojo cjuatacun rë me. Hane hatuxa quixi ngahan cojo cjuatacun naha ta, tsëhë xi sahmee hacutjin xi meje ná suva ta sacuatjin xi meje rë Nahmi naha, me xi catsingatju ná ne, cuatjin xi sahme. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Cjuinduju sa tichja Jesús cojo xutaxa rë yungun cuitjin: ―‍Sa xi ngahan cuichjá favor naha suva ne, cuinújun ta quixiin cjua xi chjá. ");
INSERT INTO maqNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Peru tjin sa ngu xi tichja favor naha, hane hvë ta cjua xi chja me vëhë tsahan ne, cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ngayun ne, caningatjun xuta quiji cavinenguise rë me Juan ngu cjua, hane Juan ne, catsicuya me cjua xi cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Peru ngahan ne, me xi tichja me favor naha hacuiin xuta me, peru cjua xi tichjá vi ne, tichjá cojo sa xi ngayun ne, cuetjuntjun. ");
INSERT INTO maqNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan vë ne, sacuaha ngu ndihi xi setí xi sua hasen rë camá me. Hane ngayun ne, cachuya nuju tsëhë xi cavinechun sua ngujo nixtin ngajñi rë cjuahasen rë Juan. ");
INSERT INTO maqNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Peru ngahan ne, tjin xcusun xi hitsë sa ndaja tsingacun yo ngahan xi cuma rë cjua xi cachja Juan tsahan. Xa xi casua Nahmi naha ngahan xi sahmechehen ne, cuma cuinújan ne, xa xi ha tisahme ne, suvá xa vëhë tsingacun xi Nahmi naha catsingatju ná me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hacuaha Nahmi naha, me xi catsingatju ná ne, chja me favor naha. Ngayun ne, hisca xta rë me cjëë cuinuhyun, hacuaha cjëë chun hacutjin jyihi me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Hisca cjua rë me ne, tsajin tetjo ngajñi rë cjuatacun nuju ta, tsëhë xi ngahan xi catsingatju ná me vëhë ne, manguaain tacún cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ngayun ne, jemu chutayun xujun rë Nina ta, tsëhë xi ningatuhun tacún ta xi cuatjin chutayun ne, sacú nuju cjuahñu xatsë. Hane xujun vëhë ne, vëhë xi chja favor naha. ");
INSERT INTO maqNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hane ngayun ne, mijí cuisuhun ladu naha xi sacú nuju cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ngahan ne, hacuiin sahmi ngujyë xi xuta sahmi jyë sahmi hnga ná me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Hacuaha ngahan ne, ha hvë xcusun nuju ta tsajin cjuahmutacun rë Nina jiya cahntsua xahasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngahan ne, canduvá ta, tsëhë xi Nahmi naha casuaxa ná me, peru ngayun ne, mijí chjuhunntsun ná. Hane sa xi jingu sa xuta cuinduva me cojo cjuatacun rë suvá me ne, ha hvë ta me vëhë ne, hatuxa chjuhunntsun me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tsajin nixtin xi cumangu tacún cojo ná ngahan jinguyëjë rë xi tivinchun chuva rë xi ngajñi nuju cojo xingun ni ne, sahmi yehe sahmi hnga nuju me hane vinchunsuun xi Nina xi ngu tu tu ni ne, me vëhë sahmi yehe sahmi hnga nuju me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Xicaningatuun tacún xi ngahan cuíncha jyë nuju xcun Nahmi naha ta xutachanga naja Moisés, me xi jemu vetuhun tacun ne, me vëhë xi cuincha jyë́ nuju me. ");
INSERT INTO maqNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sa xi camacjain nuju cjua xi catsihindu Moisés ne, hacuaha camacjain nuju cjua naha ta Moisés vë catsihindu me tsahan. ");
INSERT INTO maqNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Peru sa xi macjaain nuju cjua xi catsihindu Moisés ne, ¿hacutjin cumacjain nuju cjua xi chjá ngahan ni? ");
INSERT INTO maqNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Xi cavatju yëjë xcusun vëhë ne, cavetju Jesús quiji me ngunda vëhë tsëhë laguna Galilea, xi hacuaha hmí rë laguna Tiberias. ");
INSERT INTO maqNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Hane jemu xutacjín camahani xi quijitjengui me Jesús ta, tsëhë xi cavëë me cjuarcun xi casahmi Jesús cojo xuta hmu rë. ");
INSERT INTO maqNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Hane Jesús ne, quijiniji me ngu ndetjún, hane ngajan cavéjña me cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hane Pascua, suhi xi sahmi xuta tjë rë Israel ne, hacuaha ha camatiña. ");
INSERT INTO maqNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hane xi vutsejen Jesús xi jemu xuta cjín nduvatjengui rë me ne, sehe cachja me cojo Felipe cuitjin: ―‍¿Jani cuanguen chaan niñu xi sinë xuta xi cuacun vë? ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Cuatjin cachja me xi cjuahachuva me Felipe ta, tsëhë xi Jesús ne, ha vëë me mé xi sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ngajan xi Felipe ne, cuitjin cafayangui me: ―‍Sa xi chaan niñu cojo tujún xi chji rë xuta jo cientu nixtin ne, hisca chutaain xi sacú tsë tsë sinë jima ngu xuta vë. ―‍Cuatjin cafayangui Felipe. ");
INSERT INTO maqNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ngajan xi ngu xuta ladu rë Jesús, Andrés hntsë Simón Pedru ne, cuitjin cachja me cojo Jesús: ");
INSERT INTO maqNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―‍Nguehe secun ngu cha lihndi xi yaha hñú niñu cojo jo chu ti. Peru ¿mé chutaha vë xi sinë xuta xi cuarcumu cjín me? ―‍Cuatjin cachja Andrés. ");
INSERT INTO maqNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Tinújun cojo xuta vë ne, catiyuju me. ―‍Cuatjin cachja me. Quihndë ne, ngajan cahndë́ vëhë ne, jemu jyë cahndë́ tjin ndiji. Hya xi camá ne, ngajan caviyuju sacuaha hñú mil xihin. ");
INSERT INTO maqNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ngajan xi Jesús ne, cafaha me niñu jan, hane, xi cafë casua me nacuechji rë Nina ne, sehe cavatëcja me niñu jan ngajñi rë xuta xi siu jan. Hacuanitjin ni casahmi me cojo chu ti jan. Casua me ha tucutjin xi meje sinë xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hane hya xi ha catsë rë xuta xi cajinë me ne, sehe cachja Jesús cojo xuta ladu rë me jan cuitjin: ―‍Quihndë ne, chjayun yëjë xi cavángui vë ne, cojo sa xi hacuiin chajá hisca hitsë. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hane xi cafaya xuta ladu rë Jesús yëjë ni xi cavángui tsëhë hñú niñu xi cajinë yëjë xutacjín jan ne, catsinguitsë me tejó chajne. ");
INSERT INTO maqNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hane xi cavëë xuta cjuarcun xi casahmi Jesús jan ne, cuitjin cachja me: ―‍Cjuaquixi xi me vihi profeta xi cuinduva ngasunhndë. ―‍Cuatjin cachja xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Peru Jesús ne, ha vëë me xi ha tu hora sa xi cjuaha xuta me cojo ngujyë camahani xi suaxa rë me xi cuma titjun me. Vëhë xi Jesús ne, cavetjuxin nga me, quiji suvá ni me hisca rcu ndetjún. ");
INSERT INTO maqNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Quihndë ne, xi quiji hora jan ne, quijijne xuta ladu rë Jesús tjehen laguna. ");
INSERT INTO maqNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Hane xi cavisehen me ngu barcu ne, cavuya canduva nga me ngunda vihi tsëhë laguna xi cjue me nandya Capernaum. Hya xi camá ne, camajñu, peru Jesús ne, cjëë cjuetjengui me xuta ladu rë me jan. ");
INSERT INTO maqNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hane hora vëhë ne, xi jercu tu hñu camahani tivanga tjo ne, sacuaha xi sexu nandá tsëhë laguna jan. ");
INSERT INTO maqNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ha xcun xi ha quiji me xi cuacun jan cojo barcu sacuaha hñú o sa jyun kilómetro xcun nandá jan ne, cavëë me xi nduva ntsacu Jesús xcun nandá, tisahmitiña me tsëhë barcu. Hane xuta ladu rë me jan ne, catsacjun me camá. ");
INSERT INTO maqNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Peru Jesús ne, cachja me cuitjin cojo xuta ladu rë me jan: ―‍Ngahan vi. Xicarcuun. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ngajan xi xuta ladu rë Jesús jan ne, cojo yëjë ni cjuasua ne, cafahatsja me Jesús cahntsua barcu. Hane ha tu ñahñu cafehe barcu cojo rë me nangui quixí, cahndë́ hiscan cjui me. ");
INSERT INTO maqNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hane xi camá nchujun jan ne, xutacjín xi caviyuju ngunda vëhë tsëhë laguna jan ne, catsinguitsjen me xi ngujña ne, ngu tu tu barcu tacun jan. Hacuaha vëë me xi Jesús ne, quijiin me cojo xuta ladu rë me barcu vëhë ta suvá ni xuta ladu rë Jesús quiji me. ");
INSERT INTO maqNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Peru ngujo barcu xi canduva tsëhë nandya Tiberias ne, cafehe tiña hiscan xi cajinë xutacjín jan niñu hora xi cafë casua Nai naja nacuechji rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hane xi cavëë xutacjín jan xi hacuiin Jesús hacuiin xuta ladu rë me siu cuaha me jan ne, sehe cavisehen me barcu xi sehe cafehe jan, quiji me nandya Capernaum xi cuanguise me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hane xi casacu rë xuta xi cuacun jan Jesús ngunda vihi tsëhë laguna jan ne, cavinenguise me cuitjin: ―‍Maestro, ¿janihya canduvun nguehe ni? ―‍Cuatjin cavinenguise xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Cuichjá cojo nuju cjuaquixi ta ngayujun ni ngayun ne, nduvuntjengun ná, peru hacuiin ngatsë rë xi cahyun cjuarcun xi casahme ta ngatsë rë xi cachinu niñu jan hisca xi catsë nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nihñu ngatsë rë xichine, peru hacuiin xichine xi vetsun ta xichine xi hacuiin vetsun hacuaha hisca sua cjuahñu xatsë. Vëhë xichine xi suá nuju ngahan xi Quihndi rë Xuta Jain ngahan, ngahan xi sahme cjuarcun cojo sa xi cumatsejen xi cjuaquixi jain xi Nina Nahmi naha catsingatju ná me. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ngajan xi xuta xi cuacun jan ne, cuitjin cavinenguise me cojo Jesús: ―‍¿Hacutjin ndatjin nihñi, cojo sa xi nihñi hacutjin xi chuya rë Nina? ―‍Cuatjin cavinenguise xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hane Jesús ne, cuitjin cafayangui me: ―‍Cuitjin meje rë Nina xi nihñu: catamangu tacún cojo ná, ngahan xi catsingatju ná me. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ngajan xi xuta jan ne, cuitjin cavinenguise me Jesús: ―‍¿Mé cjuarcun nihñu xi sacú chutsijín, cojo sa xi cumangu tacuín cojo nuju? ¿Mé xi nihñu? ");
INSERT INTO maqNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yëjë ni xutachanga naja ne, cajinë me niñu xi camá cojo scuan maná ngajan ngu xín camahani tsëhë nandya, sacuatjin camahindu xcun xujun rë Nina xi chja cuitjin: “Nina ne, tsëhë ngahnga catsingatju me niñu xi cajinë xuta.” Cuatjin camahindu. ―‍Vëhë cjua xi cavinenguise xuta xi cuacun jan Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ngajan xi Jesús ne, cuitjin cachja me cojo xuta jan: ―‍Cuichjá cojo nuju cjuaquixi ta hacuiin Moisés xi casua me niñu xi nduva tsëhë ngahnga ta Nahmi naha xi sua nuju me niñu jain xi nduva tsëhë ngahnga. ");
INSERT INTO maqNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Niñu xi sua Nina ne, vëhë niñu xi nduvajne tsëhë ngahnga hacuaha sua rë xuta cjuahñu. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hane xuta xi cuacun jan ne, cuitjin cafehya me cojo Jesús: ―‍Tatá, tuhun niji niñu vëhë nchunchujun ni. ―‍Cuatjin cafehya xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Ngahan xi sacuaha niñu jan xi sua cjuahñu ngahan. Xuta xi cuisehen me ladu naha xi mangucacun me cojo ná ne, ña tsë rë xahasen rë me cjuandaja, sacuaha xi ha quihndë cumavajin rë me cumaxindaain rë me ngundiya nga. ");
INSERT INTO maqNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngahan ne, ha cachjá cojo nuju ta ha tichutsujun xcusun xi sahme peru manguaain tacún cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yëjë ni xuta xi Nahmi naha casua ná me ne, cuinduvatjengui ná me. Hane me xi cuinduvatjengui ná ne, hatuxa tsitjungueen me ta, ");
INSERT INTO maqNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","tsëhë xi ngahan ne, xi canduvajne tsëhë ngahnga ne, hacuiin xi sahme sacuatjin xi meje ná ta sacuatjin xi meje rë me xi catsingatju ná. ");
INSERT INTO maqNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hane me xi catsingatju ná vë ne, meje rë me xi hisca ngu xuta tsëhë yëjë ni me xi casua ná me ne, tsichajan me ta tsicúya me cjuahñu nixtin xi chjaháchuva rë sa nima sa xuta cojo cjuatacun rë. ");
INSERT INTO maqNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Hacuaha Nahmi naha ne, meje rë me xi yëjë ni xuta xi vijnercu me yo ngahan xi Quihndi rë Nina ngahan hacuaha cumangu cacun me cojo ná ne, sacú rë me cjuahñu xatsë. Hane ngahan tsicúya me cjuahñu nixtin xi tsichuva Nina sa nima sa xuta. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Vëhë xi xutaxa rë yungun xi cuacun jan ne, cavetsihin cavisiajmihma me tsëhë Jesús ta, tsëhë xi cachja Jesús ta: “Ngahan sacuaha niñu xi nduvajne tsëhë ngahnga ngahan.” ");
INSERT INTO maqNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Cuitjin cavisiajmihma me: ―‍¿Hacuiin cha Jesús vihi, xi quihndi rë José? ¿Hacuiin ha hyan nahmi rë cha hacuaha ha hyan naa rë cha? ¿Hacutjin má xi quihndë ne, chja cha xi tsëhë ngahnga canduvajne cha ni? ―‍Cuatjin cavisiajmihma me. ");
INSERT INTO maqNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ngajan xi Jesús ne, cuitjin cachja me cojo xutaxa rë jan: ―‍Camá ni cuinújunhmú cojo xingun xingu xingu ngayun. ");
INSERT INTO maqNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Xuta xi cuma cuisehen me ladu naha ne, suvá ni xuta xi cuisecoo Nahmi naha, me xi catsingatju ná. Me vëhë xi cuma cuisehen me, hane ngahan tsicúya me cjuahñu nixtin xi tsichuva Nina sa nima sa xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Cuitjin camahindu xcun xujun rë Nina xi catsihindu profeta: “Suvá Nina scuxaha me cjuatacun rë yëjë ni xuta.” Cuatjin camahindu. Hane xuta xi vetaharcu cjua rë Nina hacuaha Nina vuxaha me cjuatacun rë ne, visehen me ladu naha. ");
INSERT INTO maqNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Hacuiin xi ha tjin yo xi cavutsejen rë Nahmi naha ta suva ni ngahan xi tsëhë Nina canduva ne, ngahan xi cahvë Nahmi naha. ");
INSERT INTO maqNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Cuichjá cojo nuju cjuaquixi ta yo xi mangucacun cojo ná ne, tjin rë cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngahan xi sacuaha niñu xi sua cjuahñu ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yëjë ni xutachanga nuju ne, cajinë me niñu xi camá cojo scuan maná ngajan ngu xín camahani tsëhë nandya, peru cavechú nixtin xi cahme me. ");
INSERT INTO maqNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Peru niñu xi nduvajne tsëhë ngahnga xi chjá ngahan tsëhë ne, sa xi yo sinë niñu vëhë ne, cueyaain. ");
INSERT INTO maqNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngahan xi quicun ngahan ne, ngahan xi sacuaha niñu xi canduvajne tsëhë ngahnga jan ngahan. Sa xi ngu xuta sinë me niñu vëhë ne, handasa cueya me ne, peru hasen rë me ne, cjue xcun Nina. Niñu xi suá ngahan vë ne, hacui yojo naha xi suá cojo sa xi xuta ngasunhndë ne, sacú rë me cjuahñu xatsë. ―‍Cuatjin cachja Jesús cojo xutaxa rë. ");
INSERT INTO maqNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hya xi camá ne, xutaxa rë jan ne, cavetsihin cavisiajmicjan me tsëhë Jesús ngajñi rë me cojo xicjin me, cuitjin cachja me: ―‍¿Hacutjin cuma sua cha xi cuajyihi vë yojo rë cha xi xinëë ni? ―‍Cuatjin cachja xutaxa rë jan. ");
INSERT INTO maqNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hane Jesús ne, cuitjin cachja me cojo xuta xi cuacun jan: ―‍Cuichjá cojo nuju cjuaquixi ta sa xi ngayun xinuu yojo naha ngahan xi Quihndi rë Xuta Jain ngahan hacuaha siuun jni naha ne, tsajin nuju cjuahñu xi cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Xuta xi jinë me yojo naha hacuaha hvi me jni naha ne, tjin rë me cjuahñu xatsë, hacuaha ngahan tsicúya me cjuahñu nixtin xi tsichuva Nina sa nima sa xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cuatjin cuma ta, tsëhë xi yojo naha ne, vëhë comida xi cjuaquixi, hane jni naha ne, vëhë nandá xi cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Me xi jinë yojo naha hacuaha hvi me jni naha ne, visehen me yojo naja, hacuaha ngahan ne, visehen yojo rë. ");
INSERT INTO maqNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nahmi naha, me xi hatuxa tjin rë cjuahñu ne, catsingatju ná me, hane ngatsë rë me vëhë xi tejña cjuahñu ngahan. Ha chuva vëhë ni ne, xuta xi jinë ná ne, cuejña me cjuahñu ngatsë naha. ");
INSERT INTO maqNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Cuatjin sahmi niñu xi canduvajne tsëhë ngahnga. Hacuiin tangun cojo niñu xi cajinë xutachanga nuju ta cavechú nixtin xi cahme me. Ha ndaja xuta xi sinë me niñu xi chjá ngahan ne, handasa cueya me ne, peru hasen rë me ne, cjue xcun Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","―‍Cuatjin cachja Jesús hya xi cavicuya me xuta ngu yungun ngajan nandya Capernaum. ");
INSERT INTO maqNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hya xi camá ne, jemu cjín xuta ladu rë Jesús xi cuitjin cachja me hya xi cahndë me cjua jan: ―‍¡Jemu choho visiajmi me! ¡Scaain naja cojo cjua vëhë! ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Peru Jesús ne, ha vëë me cojo cjuatacun rë me xi cuatjin visiajmihma xuta ladu rë me xi cuacun jan. Vëhë xi cachja me cuitjin: ―‍Sa xi meje cuetjunxun tsëhë ndiya naha ngatsë rë cjua xi cachjá cojo nuju vë ne, ");
INSERT INTO maqNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿mé ningatuhun tacún sa xi chutsujun xi cúya cjuë́neje nga ngahnga hiscan xi cavitejña titjun, ngahan xi Quihndi rë Xuta Jain ngahan? ");
INSERT INTO maqNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hasen rë Nina ne, vëhë xi sua cjuahñu. Peru ngu xuta ngasunhndë ne, hatuxa cumaji sahmi me cuatjin. Yëjë ni cjua xi ngahan cachjá cojo nuju ne, vëhë sua machaya nuju tsëhë Hasen rë Nina cojo tsëhë cjuahñu xi sua. ");
INSERT INTO maqNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Peru tjin yahnga ngayun xi manguaain tacún cojo ná. ―‍Cuatjin cachja Jesús ta, tsëhë xi hisca ntsacu cavetsihin ne, ha vëë me yo xuta xi cumanguaain cacun cojo rë me hacuaha ha vëë me yo xi sahmi rë me entregadu. ");
INSERT INTO maqNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Hacuaha cachja sa me cuitjin: ―‍Vëhë xi cuatjin cachjá cojo nuju xi xuta xi cuma cuisehen me ladu naha ne, suvá ni xuta xi cuichja Nahmi naha xi cuisehen. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ngatsë rë vëhë xi jemu cjín xuta ladu rë Jesús ne, quiji ngaxtun me, hacuaha ha quihndë catsujyiin me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ngajan xi Jesús ne, cavinenguise me xuta ladu rë me xi tejó jan cuitjin: ―‍¿Hacuiin cojo ngayun meje cuangunxun? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hane Simón Pedru ne, cuitjin cafayangui me: ―‍Ngayun nai naha, ¿yo cuanguintjenguin?, ta ngayun ne, tjin nuju cjua xi sua machaya niji tsëhë cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Hacuaha ngayin ne, mangutacuín cojo nuju hacuaha hyin xi tsëhë jain Nina ngayun. ―‍Cuatjin cafayangui Simón Pedru. ");
INSERT INTO maqNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Handasa ngahan suva cavaxejen nuju ngayujun ni xi tejó ngayun, peru ngajñi nuju ne, jiyajñi ngu xi ha jiya xitsehen xahasen rë. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús ne, tichja me tsëhë ngu cha tsëhë ngajñi rë xi tejó xuta ladu rë me, ngu cha xi hmí rë Judas, quihndi rë Simón Iscariote. Cuatjin cachja me ta, tsëhë xi cha vëhë sahmi cha me entregadu cojo condra rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Xi cavatju vëhë ne, catsujyihiya Jesús ngujo nandya tsëhë distritu Galilea. Mijí tsujyihiya me nandya xi siu ladu tsëhë distritu Judea ta, tsëhë xi xutaxa rë yungun ne, tivanguise me Jesús xi tsiquehen me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Quihndë ne, ha camatiña suhi tsëhë Ndihya Tsjian, suhi xi sahmi xuta tjë rë Israel. ");
INSERT INTO maqNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ngajan xi me xi xicjin Jesús jan ne, cuitjin cachja me cojo Jesús: ―‍Tihin ngajan distritu Judea, cojo sa xi hacuaha cojo xuta ladu riji xi siu jan ne, scuëë me xcusun xi nihñi ta ");
INSERT INTO maqNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","tsëhë xi ngu cha xi meje rë xi cumachaya rë xuta xcusun xi sahmi cha ne, hacuiin táha hma sahmi cha. Ngaye ta cuatjin jemu nihñi cjuandaja ne, ningacuin rë yëjë xuta cjuandaja vëhë. ―‍Cuatjin cachja xicjin Jesús cojo rë me ta, ");
INSERT INTO maqNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","tsëhë xi me xi cuacun vë ne, camanguaain cacun me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Cjëë cuechú nixtin xi sahme mé xi sahme. Peru ngayun ne, tu mé ni nixtin ne, ndatjin xi cuma nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ngayun ne, cumaji choho scuëë nuju xuta, peru ngahan ne, choho vëë ná me ta, tsëhë xi ngahan ne, chjá cjuaquixi xi xcusun xi sahmi me ne, hatuxa tsehen. ");
INSERT INTO maqNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tángun ni ngayun ta ngahan ne, cjueen suhi vëhë. Cjueen ta cjëë cuetjucaa nixtin xi sahme mé xi sahme. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Xi cavatju cachja me cojo xicjin me cjua vëhë ne, cavéjña ni me nangui rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hane xi cavatju quiji xicjin Jesús suhi jan ne, hacuaha cojo Jesús quiji me. Peru hacuiin táha tsejen ta sacuaha xi táha hma quiji me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hya xi camá ne, xutaxa rë yungun jan ne, cavanguise me Jesús hiscan jima suhi jan. Cuitjin cavinenguise me: ―‍¿Jani tacun cha vëhë? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hane xutacjín jan ne, jercu visiajmihma me ngajñi rë me tsëhë Jesús. Ngujo me ne, cuitjin cachja me: ―‍Ngu xuta ndaja me. ―‍Cuatjin cachja me. Peru ngujo nga xuta ne, cuitjin cachja me: ―‍¡Jéya, vindacha cha xutacjín! ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Peru tsajin hisca ngu xuta xi cachjatë me tsëhë Jesús ta, tsëhë xi tsacjun me xutaxa rë yungun. ");
INSERT INTO maqNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Quihndë ne, hya xi camavasen tijima suhi jan ne, quiji Jesús yungun xi matitjun, sehe cavetsihin cavicuya me xuta cjua rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Hane xutaxa rë yungun jan ne, quijircun rë me xi cuatjin jemu ndaja chja Jesús. Cuitjin cachja me ngajñi rë me cojo xicjin me: ―‍¿Hacutjin má xi cuarcu vechú cjuatacun rë cha vë xi hisca hacuiin cavutaya cha? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ngajan xi Jesús ne, cuitjin cachja me cojo xutaxa rë xi cuacun jan: ―‍Cjua xi vicuyá rë xuta ne, hacuiin cjua naha suva ta cjua rë me xi catsingatju ná. ");
INSERT INTO maqNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sa xi ngu xuta meje sahmi me sacuatjin xi meje rë me xi catsingatju ná ne, ngajan sacú cumachaya rë me tsëhë cjua xi vicuyá, ¿há xi tsëhë Nina ne? o ¿há xi nduva tsëhë cjuatacun naha suva? ");
INSERT INTO maqNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Xuta xi chja me cjua xi nduva tsëhë cjuatacun rë suvá me ne, meje sahmi jyë sahmi hnga suvá me yojo rë me. Peru xuta xi meje sahmi jyë sahmi hnga me me xi catsingatju rë me ne, me vëhë ne, quixi me cojo cjua rë me hacuaha tsajin cjuatsehen cahntsua xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés ne, casua nuju me ley rë Nina, peru hisca ngu ngayun nihñuchuun sacuatjin chja ley vëhë. ¡Tsëhë vëhë rë xi meje nicuhun ná! ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ngajan xi xutacjín jan ne, cuitjin cafayangui me: ―‍¿Yo xitsehen xi cachja cojo nuju? ta nguehe ne, tsajin yo xi meje tsiquehen nuju. ―‍Cuatjin cafayangui xutacjín jan. ");
INSERT INTO maqNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hane xi cafayangui Jesús ne, cuitjin cachja me: ―‍Ngayujun ni ngayun ne, quijircun nuju ngatsë rë ngu xcusun xi casahme nixtin xi chjahájenda rë. ");
INSERT INTO maqNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Peru suvá Moisés hacuaha cavejña me xcusun xi xtí chuxin rë quihndi xihin. (Xi cjuaquixi ne, hacuiin Moisés ta xutachanga nuju xi cavejña me xcusun vëhë.) Hane vëhë xi ngayun ne, vichun chuxin rë quihndi xihin handasa nixtin xi chjahájenda rë. ");
INSERT INTO maqNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Sa xi vichun chuxin rë quihndi xihin nixtin xi chjahájenda rë cojo sa xi nihñuchuhun sacuatjin cjua xi chja ley rë Moisés ne, ¿mé má cuatjin ma cjan nuju cojo ná xi casahme xi camandaja camahani ngu xuta nixtin xi chjahájenda rë ni? ");
INSERT INTO maqNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ha quihndë hacuiin tujyë nichuvun ná ta nichuvun ná cojo ngu cjuatacun xi cjuaquixi. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ngajan xi ngujo xuta nandya Jerusalén ne, cuitjin cachja me ngajñi rë me: ―‍¿Hacuiin me vihi xi vinchise rë xi cueya ni? ");
INSERT INTO maqNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Peru chutsujun ta cuajyihi me secun me tichja tichja me cojo xuta, hane ndastu ngu cjua chja xutaxa rë cojo rë me. ¡Hyaan sa xi vëëndaja xutaxa rë xi me vihi xi catsingatju jain Nina me! ");
INSERT INTO maqNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Me vihi ne, ha hyan jani canduva me, peru hya xi cuinduva me xi Nina tsingatju rë ne, tsajin yo vëë jani cuetju me cuinduva me. ―‍Cuatjin cachja xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ngajan xi Jesús ne, xi quijinduju sa cavicuya me xuta ngajan yungun xi matitjun ne, jercu hñu cachja me cuitjin: ―‍¿Há quixi xi hyun ná hacuaha hyun jani canduva? Peru ngahan ne, hacuiin cjuatacun naha suva xi canduva. Me xi catsingatju ná ne, hatuxa quixi me cojo cjua rë me, peru ngayun ne, hyúun me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngahan ne, hvë me ta, tsëhë xi hiscan tacun me ne, ngajan canduvá. Hacuaha me vëhë catsingatju ná me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tsëhë xi cuatjin cachja Jesús cjua vëhë ne, vëhë xi meje cjuaha xuta xi cuacun jan me. Peru tsajin yo xi cavetahatsja rë me ta, tsëhë xi cjëë cuetjucaa nixtin xi cuatjin cuma. ");
INSERT INTO maqNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hane jemu cjín xuta ngajñi rë xutacjín jan ne, camangu cacun me cojo Jesús. Cuitjin cachja me: ―‍Hya xi cuinduva me xi Nina tsingatju rë ne, ¿há hitsë sa cjín cjuarcun sahmi me xi cuma rë cjuarcun xi casahmi me vihi? ―‍Cuatjin cachja xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Hane ngujo cha fariseo ne, cahndë cha xi visiajmihma xutacjín jan ngajñi rë me cojo xicjin me cjua vëhë. Ngajan xi yëjë ni nahmi xi matitjun cojo cha fariseo jan ne, catsingatju me mayu cojo nisë rë cha xi chjahá rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hane Jesús ne, cuitjin cachja me: ―‍Ngujo nixtin sa xi cuitejña cojo nuju, sehe cúya cjuë́ nga hiscan tacun me xi catsingatju ná. ");
INSERT INTO maqNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ngayun ne, cuinchunsun ná, peru sacuiin nuju ngahan ta, tsëhë xi hiscan xi cuitejña ne, cumaji cuangun. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ngajan xi xutaxa rë jan ne, cavinenguise xicjin me cuitjin: ―‍¿Jani cjue cha xi cuijyihi vi xi sacuiin naja cha? ¿Há cjue cha ngu nangui cjin, cjue tjengui cha xuta naja xi cavitsojo ngajñi rë xutaxín hane ngajan cuicuya cha xutaxín jan ni? ");
INSERT INTO maqNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Mé vijne cjua xi chja cha xi cuinchaseen cha ne, sacuiin naja cha, tsëhë xi hiscan cuejña cha ne, cumaji cuanguen? ―‍Cuatjin cavinenguise xicjin xutaxa rë jan. ");
INSERT INTO maqNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Quihndë ne, nixtin xi cajnetaha suhi jan ne, vëhë nixtin jyë tsëhë suhi jan. Hane casecun Jesús cachjahñu me cojo xuta cuitjin: ―‍Sa xi tjin yo xi xinda rë ne, catinduva tjengui ná catihi. ");
INSERT INTO maqNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Xuta xi mangucacun me cojo ná ne, cuatju me sacuatjin chja xujun rë Nina xi chja cuitjin: “Cuetju tsëhë xahasen rë me sacuaha nandá xi ña vangatë xi sua rë me cjuahñu xatsë.” ―‍Cuatjin cachjahñu Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Xi cuatjin cachja Jesús ne, cachja me tsëhë Hasen rë Nina xi sehe sacú rë xuta xi mangucacun me cojo Jesús. Cuatjin cachja Jesús ta, tsëhë xi Nina ne, cjëë sua me Hasen rë me, tsëhë xi Jesús ne, cjëë cuma jyë cuma hnga me cojo Hasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hane xi cahndë xutacjín jan cjua vëhë ne, ngujo me ne, cuitjin cachja me: ―‍Me vëhë ne, cjuaquixi xi me vëhë profeta xi jemu nechanyan rë. ―‍Cuatjin cachja ngujo me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hane ngujo nga me ne, cuitjin cachja me: ―‍Me vëhë xi Tsingatju Nina. ―‍Cuatjin cachja me. Peru ngujo nga me ne, cachja me cuitjin: ―‍¡Peru Me xi Tsingatju Nina ne, hacuiin ngajñi rë xuta Galilea cuetjujñi me! ");
INSERT INTO maqNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¡Ha hyan xi xujun rë Nina ne, chja ta Me xi Tsingatju Nina ne, cuinduva me tsëhë tjë rë xutachanga naja David, ngajan Belén hiscan nangui rë David! ―‍Cuatjin cachja me xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Cuatjin camá xi ngatsë rë Jesús ne, hacuiin ngu ni cjuatacun catsingataha cacun xutacjín jan. ");
INSERT INTO maqNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vëhë xi ngujo xuta jan ne, meje cjuaha me Jesús cjuecojo me ndavaya. Peru tsajin yo xi cavetahatsja rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hya xi camá ne, mayu cojo nisë rë cha ne, cavuya quiji nga cha xcun nahmi xi matitjun cojo xcun cha fariseo xi cuacun jan, hane xutaxa rë xi cuacun jan ne, cuitjin cachja me cojo mayu jan: ―‍¿Mé má canduvuun cojo cha? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ngajan xi cha mayu cojo nisë rë cha jan ne, cuitjin cafayangui cha: ―‍¡Cjëë camahani cuinuhyin xi chja ngu xuta sacuatjin chja me vëhë! ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Hane cha fariseo jan ne, cuitjin cachja cha cojo cha xi cuacun jan: ―‍¡Tu ma rë sa xi cojo ngayun camandacha ngayun! ");
INSERT INTO maqNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¡Ngayun ne, hyun ta hisca ngu xutaxa rë, hisca xi ngu xuta fariseo ne, cjëë cumangu cacun me cojo cha xi cuajyihi vë! ");
INSERT INTO maqNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Peru xutacjín xi cuacun hisca hvíin hacutjin chja ley rë Moisés ne, ¡mijí rë Nina me! ―‍Cuatjin cachja cha fariseo jan. ");
INSERT INTO maqNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ngajan xi ngu cha fariseo xi hmí rë Nicodemo, cha xi quiji tjengui rë Jesús hatsëë ne, cuitjin cachja cha cojo cha xi cuacun vëhë: ");
INSERT INTO maqNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―‍Chja ley naja ta cumaji nihña castigu ngu xuta xi cjëë cuinuhyan mé cuichja me hacuaha sacú naja cjuaquixi mé casahmi me. ―‍Cuatjin cachja cha Nicodemo. ");
INSERT INTO maqNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ngajan xi cha fariseo xi cuacun jan ne, cuitjin cafayangui cha: ―‍¿Hacuaha cojo ngayun má ngayun xuta rë distritu rë Galilea ni? Chutayun xujun rë Nina ne, sehe ngajan sacú cumachaya nuju ta ngajan Galilea ne, cuetjinjñii hisca ngu profeta. ―‍Cuatjin cafayangui cha fariseo xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Hya xi camá ne, jima ngu xuta jan cafe me ndava me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Peru Jesús ne, cavetju me quiji me ndetjún Olivu. ");
INSERT INTO maqNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hane xi casahasen camá nchujun jan ne, cavuya quiji nga Jesús ndatsen yungun xi matitjun. Hane yëjë xuta jan ne, casahmitiña me tsëhë Jesús. Hane xi quiji cavéjña Jesús ne, sehe cavetsihin cavicuya me xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ngajan xi ngujo cha vicuya cjuachacun cojo ngujo cha fariseo ne, cafehecojo cha ngu chjuun xi cachjahá rë na xcun cjuatsehen xi tisahmi na cojo ngu xihin xi hacuiin xihin rë na. Hane cha xi cuacun jan ne, quiji cavisecun cha na ngajñi rë xuta hiscan tacun Jesús, ");
INSERT INTO maqNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","sehe cachja cha cojo Jesús cuitjin: ―‍Maestro, chjuun vihi ne, cachjahá rë na xcun cjuatsehen xi tisahmi na cojo ngu xihin xi hacuiin xihin rë na. ");
INSERT INTO maqNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Quihndë ne, xcun ley xi cavejña naja Moisés ne, cavitexa me xi tu yo ni xuta xi sahmi xcusun vëhë ne, cueya me cojo ndyojo. Ngayun ne, ¿mé xi cuinújun? ");
INSERT INTO maqNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","―‍Cuatjin cavinenguise cha xi cuacun vëhë, xi tifahachuva cha Jesús, cojo sa xi sacú rë cha chuva rë xi cuinchajyë cha me. Ngajan xi Jesús ne, catsiquindi me yojo rë me, sehe cavetsihin catsihindu me nangui cojo rcutsja me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hane tsëhë xi cjuinduju sa tivinenguise cha xi cuacun jan Jesús ne, catsinguixi me yojo rë me, sehe cachja me cojo cha cuitjin: ―‍Tu jarë ni ngayun xi tsajin jyë́ nuju ne, ngayun tjun tjun tetuhun rë na ndyojo. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hane sehe catsiquindi nga me yojo rë me, hane catsihindu sa me nangui. ");
INSERT INTO maqNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hane xi cahndë cha xi cuacun jan xi cuatjin cachja Jesús ne, ta vëë me xi hacuiin tyjahi cjuatacun rë me, chuva ngu chuva ngu cha cavetju cha cafe cha. Cavetsihin cavetju tjun tjun cha xi hitsë sa changá. Hane camá suvá sa Jesús, cojo chjuun xi secun ngajñi rë xutacjín jan. ");
INSERT INTO maqNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Hane xi catsinguixi me yojo rë me ne, cavinenguise me chjuun jan cuitjin: ―‍Ngayun chjuun, ¿jarë me ne? ¿Há tsajin yo xi casahmi nuju castigu? ―‍Cuatjin cavinenguise Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ngajan xi chjuun jan ne, cuitjin cafayangui na: ―‍Tsajin yo, tatá. ―‍Cuatjin cafayangui na. Ngajan xi Jesús ne, cuitjin cachja me: ―‍Ngahan ne, hacuaha sahmee nuju castigu. Cuma cuangun, peru ha quihndë xicanihñuu sa cjuatsehen. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Hya xi camá ne, cachja nga Jesús cojo xutacjín jan cuitjin: ―‍Ngahan ne, sacuaha hasen xi cuma rë xuta ngasunhndë ngahan. Xuta xi cuisehen me ladu naha ne, hatuxa cuiyijin me ngajñi jñú ta ngajñi hasen xi sua cjuahñu xatsë cuiyuju me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ngajan xi cha fariseo xi cuacun jan ne, cuitjin cachja cha cojo Jesús: ―‍Ngayun ne, tinújun favor nuju suvun. Vëhë xi cjua xi nújun ne, tsajin rë cjuaquixi. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hane xi cafayangui Jesús ne, cuitjin cachja me: ―‍Handasa chjá favor naha suva ne, cjua xi chjá ne, cjuaquixi ta, tsëhë xi ngahan ne, hvë jani canduva hacuaha hvë jani cúya cjuë́ nga. Peru ngayun ne, hyúun jani canduva hacuaha hyúun jani cúya cjuë́ nga. ");
INSERT INTO maqNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ngayun ne, xi nichuvun xuta cojo cjuatacun rë me ne, chuva xi tsingatahacacun xuta ngasunhndë ne, cuatjin ningatuhuntacún. Ngahan ne, titsichuvaan hisca ngu xuta cojo cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Peru sa xi tsichúva ngu xuta ne, hatuxa cjuaquixi cjua xi cuichjá ta, tsëhë xi hacuiin suva sahme ta ngahan cojo me xi catsingatju ná nihñi tangun. ");
INSERT INTO maqNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Xcun ley xi vitexa nuju ne, hacuaha camahindu xi hya xi jo xuta sua me cjuaquixi rë me xcun xutaxa rë hane ngu tangun ni cjua chja me ne, cjuaquixi cjua xi chja me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngahan xi chjá favor naha suva, hane Nahmi naha xi catsingatju ná me ne, hacuaha cojo me chja me favor naha. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ngajan xi cha fariseo jan ne, cuitjin cavinenguise cha Jesús: ―‍¿Jani tacun nahmi nuju ni? ―‍Cuatjin cavinenguise cha. Hane Jesús ne, cuitjin cafayangui me: ―‍Hacuiin ngahan hyun ná ne, hacuiin Nahmi naha hyun me. Sa xi ngahan hyun ná ne, hacuaha hyun Nahmi naha. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Cjua vëhë ne, cachja Jesús hya xi tivicuya me xuta ngajan yungun xi matitjun, ngu ndihya hiscan xi siu alcancía. Peru hisca ngu xuta cafaain rë me, tsëhë xi cjëë cuetjucaa nixtin xi cuatjin cuma. ");
INSERT INTO maqNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Hya xi camá ne, quijinduju sa cachja Jesús cojo xuta cuitjin: ―‍Ngahan ne, cuétju cjuë́, hane ngayun ne, cuinchunsun ná. Peru ngatsë rë cjuatsehen xi cún ngayun ne, cuechuun xcun Nina hya xi cueyun. Hiscan xi cjuë́ ne, ngayun ne, cumaji cuangun. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ngajan xi xutaxa rë xi cuacun jan ne, cuitjin cachja me ngajñi rë me cojo xicjin me: ―‍Tu ma rë sa xi cjue tsiquehen suvá me yojo rë me xi cuatjin chja me xi hiscan cjue me ne, cumaji cuanguen. ―‍Cuatjin cachja xutaxa rë xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ngajan xi Jesús ne, cuitjin cachja me cojo me xi cuacun vë: ―‍Ngayun ne, tsëhë nguehe nangui ngayun. Ngahan ne, tsëhë ngahnga ngahan. Ngayun ne, tsëhë ngasunhndë vihi ngayun. Ngahan ne, hacuiin tsëhë ngasunhndë vihi ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Vëhë xi cuatjin cachjá cojo nuju xi ngatsë rë cjuatsehen xi cún ngayun ne, cuechuun xcun Nina hya xi cueyun. Sa xi macjaain nuju xi Ngahan Vi, hmí ná ne, ngatsë rë cjuatsehen xi cún ngayun ne, cuechuun xcun Nina hya xi cueyun. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ngajan xi xuta xi cuacun jan ne, cavinenguise me Jesús cuitjin: ―‍¿Yo ngayun ni? ―‍Cuatjin cavinenguise me. Hane Jesús ne, cuitjin cachja me: ―‍¡Sacuatjin cachjá cojo nuju hisca ntsacu cavetsihin! ");
INSERT INTO maqNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jemu tjin ná cjua xi cuichjá tsujun, hacuaha jemu tjin xi cjuaháchuva tsujun. Peru me xi catsingatju ná ne, quixi jain me cojo cjua rë me, hane ngahan ne, cjua xi cáhndë xi cachja me ne, cjua vëhë xi chjá nguehe ngasunhndë. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Peru xutaxa rë xi cuacun jan ne, cajnii rcu me xi Jesús ne, tsëhë Nina Nahmi naja xi tichja me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Vëhë xi Jesús ne, cuitjin cachja me: ―‍Hya xi ngayun chjunihngun ná ngahan xi Quihndi rë Xuta Jain ngahan ne, hya cuijne rcun xi Ngahan Vi hmí ná. Hane ngahan ne, hatuxa tsajin mé xi sahme xi cojo cjuatacun naha suva ta sacuaha cjua xi cachja Nahmi naha cojo ná ne, cjua vëhë xi chjá. ");
INSERT INTO maqNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Hacuaha me xi catsingatju ná ne, tacun me cojo ná, cavejñaai ná me xi suva ta, tsëhë xi ngahan ne, hatuxa sahme tutjin xi chuya rë me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hane xi cachja Jesús cjua vëhë ne, jemu cjín xuta camangu cacun me cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ngajan xi Jesús ne, cachja me cuitjin cojo xutaxa rë yungun xi camacjain rë tsëhë cjua rë me: ―‍Sa xi ngayun cuangun nduju xi quitahá rcun cjua naha ne, quixi xi ha camá ngayun xuta ladu naha. ");
INSERT INTO maqNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Hacuaha cuijne rcun xi hmí rë cjuaquixi, hane cjuaquixi jan ne, cuëhëndaya nuju. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ngajan xi xutaxa rë xi cuacun jan ne, cuitjin cafayangui me: ―‍Peru ngayaan ne, tjë rë xutachanga naja Abraham má ngayaan, hane cjëë camahani cuma ngayaan mosu hndixahan rë xuta. ¿Mé má nújun xi cumandaya ngayin? ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hane Jesús ne, cuitjin cafayangui me: ―‍Cuichjá cojo nuju cjuaquixi ta yëjë ni xuta xi hincha me ndiya rë cjuatsehen ne, hatuxa tjinhñu me cojo cjuatsehen sacuatjin tjinhñu ngu mosu hndixahan cojo nai rë. ");
INSERT INTO maqNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ngu mosu hndixahan ne, hacuiin hatuxa cuiyujucahndë ngajñi xuta xi ndava, peru ngu quihndi xi cjuaquixi ne, hatuxa tsëhë xuta xi ndava. ");
INSERT INTO maqNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Vëhë xi sa xi Quihndi rë Nina cuëhëndaya nuju ne, cumandaya jain ngayun cojo cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ngahan ne, hacuaha hvë xi tjë rë Abraham má ngayun. Peru ngayun ne, tivinchun chuva rë xi nicuhun ná, tsëhë xi tuun cahndë́ xi cuisehen cjua naha cahntsua xahasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngahan ne, xcusun xi cahvë hiscan tacun Nahmi naha ne, tsëhë vëhë xi tichjá. Peru ngayun ne, sacuatjin canuhyun xi cachja nahmi nuju ne, cuatjin tinihñu. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ngajan xi xutaxa rë xi cuacun jan ne, cuitjin cachja me: ―‍Nahmi niji ne, hacui xutachanga naja Abraham. ―‍Cuatjin cachja me. Ngajan xi Jesús ne, cuitjin cachja me: ―‍Sa xi quixi xi quihndi rë Abraham má ngayun ne, sacuatjin casahmi Abraham ne, hacuaha cuatjin nihñu. ");
INSERT INTO maqNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngahan ne, cachjá cojo nuju cjuaquixi xi cáhndë xi cachja Nina, peru quihndë ne, tivinchun chuva rë xi nicuhun ná. Xutachanga naja Abraham ne, casahmii me cuatjin. ");
INSERT INTO maqNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ngayun ne, sacuatjin casahmi nahmi nuju ne, hacuanitjin ni tinihñu. ―‍Cuatjin cachja Jesús. Ngajan xi xutaxa rë xi cuacun jan ne, cachja me cuitjin: ―‍Ngayin ne, hacuiin quihndi xca ngayin. Nina ne, ngu ni me vëhë xi Nahmi niji. ―‍Cuatjin cachja xutaxa rë xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Hane Jesús ne, cuitjin cachja me: ―‍Sa xi quixi xi Nahmi nuju Nina ne, hacuaha canihñu hmu tacún ná ta, tsëhë xi ngahan ne, Nina catsingatju ná me, hane quihndë ne, nguehe tejña. Ngahan ne, hacuiin cjuatacun naha suva xi canduvá ta me vëhë catsingatju ná me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Mé má vijnii rcun cjua xi chjá? Cuatjin vijnii rcun ta, tsëhë xi caain nuju visiñuju cjua naha. ");
INSERT INTO maqNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ngayun ne, quihndi rë nahmi nuju Satanás ngayun, hane xcusun xi meje rë nahmi nuju ne, xcusun vëhë xi meje nihñu. Xitsehen xi matitjun vë ne, hisca ntsacu cavetsihin ne, hatuxa tsiquehen vë xuta. Hatuxa tsajin jiya vë ngajñi rë cjuaquixi ta, tsëhë xi tsajin cjuaquixi ngajñi rë cjuatacun rë. Hya xi chja xitsehen vë cjuandacha ne, chja sacuatjin xcusun rë suvá ta, tsëhë xi hatuxa ndacha, hacuaha nahmi rë yëjë ni cjuandacha. ");
INSERT INTO maqNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Peru ngahan ne, tsëhë xi chjá cjuaquixi ne, vëhë xi macjaain nuju ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jarë ngayun xi cuma ninguixun xi ngahan ne, tjin jyë́ naha? Sa xi chjá xi cjuaquixi ne, ¿mé má macjaain nuju ngahan? ");
INSERT INTO maqNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Me xi tsëhë jain Nina ne, vetaharcu me cjua rë Nina. Ngayun ne, tsëhë xi hacuiin tsëhë Nina ngayun ne, vëhë xi mijí cuetuhunrcun cjua rë me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hane xutaxa rë xi cuacun jan ne, cuitjin cachja me cojo Jesús: ―‍¡Hatuxa cjuaquixi xi nújin hya xi nújin xi ngayun ne, ngu xuta samaritano ngayun hacuaha jiya xitsehen xahasen nuju! ―‍Cuatjin cachja xutaxa rë jan. ");
INSERT INTO maqNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Tsajin xitsehen xahasen naha. Ngahan ne, fahárcun Nahmi naha, hane ngayun ne, choho nújun tsahan. ");
INSERT INTO maqNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Hacuaha mijí sahme jyë sahme hnga suva yojo naha. Tjin ngu me xi meje sahmi jyë sahmi hnga ná, hane me vëhë ne, tsichuva naja me cojo cjuatacun naja. ");
INSERT INTO maqNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cuichjá cojo nuju cjuaquixi ta xuta xi cuihndë me tsëhë cjua naha ne, hatuxa tsajin nu tsajin nixtin xi cueya me. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Hane xutaxa rë xi cuacun jan ne, cuitjin cachja me cojo Jesús: ―‍Quihndë matsejenndaja xi jiya jain xitsehen xahasen nuju. Xutachanga naja Abraham ne, cahme me, hacuaha yëjë profeta ne, cahme me, hane sehe ngayun nújun xi xuta xi cuihndë me tsëhë cjua nuju ne, hatuxa tsajin nu tsajin nixtin xi cueya me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¡Ja!, peru ¿há hitsë sa matitjun ngayun xi cuma rë xutachanga naja Abraham, me xi cahme ni? ¡Hacuaha cahme yëjë profeta! ¡Ngayun tinihñu yojo nuju sacuaha xi jemu matitjun ngayun! ―‍Cuatjin cachja xutaxa rë jan. ");
INSERT INTO maqNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hane Jesús ne, cuitjin cafayangui me: ―‍Sa xi sahme jyë sahme hnga suva yojo naha ne, cjua xi cuichjá tsahan ne, cuenguiin camahani chji rë. Peru Nahmi naha, me xi nújun xi Nina nuju ne, me vëhë xi sahmi jyë sahmi hnga ná me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ngayun ne, hyúun me, peru ngahan ne, hvë me. Sa xi ngahan cuichjá xi hveen me ne, tangun ndacha ngahan cojo nuju ngayun. Peru ngahan ne, hvë me, hacuaha víhndë tsëhë cjua rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Xutachanga naja Abraham ne, jemu ndaja camá rë me xi satë rë me xi scuëë me nixtin xi cuinduva ngahan. Hane cavëë jain me, hacuaha jemu sua camá rë me. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ngajan xi xutaxa rë xi cuacun jan ne, cuitjin catsixcuehyu me Jesús: ―‍Hisca cjëë yachantë nu tjin nuju. ¿Há cahyun xutachanga naja Abraham ni? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hane Jesús ne, cuitjin cachja me: ―‍Cuichjá cojo nuju cjuaquixi ta hisca chaja sa xi tsin xutachanga naja Abraham ne, ngahan ne, Ngahan Vi hmí ná. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Vëhë xi xutaxa rë yungun xi cuacun jan ne, cafaha me ndyojo xi cuetaha me Jesús xi meje tsiquehen me. Peru Jesús ne, cavetjuhmá me tsëhë yungun xi matitjun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hya xi camá ne, xi cavatju Jesús ngu cahndë́ jan ne, cavëë me ngu cha rcá xi ha cuatjin rcá cha hisca hya xi catsin cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Hane xuta ladu rë me jan ne, cuitjin cavinenguise me: ―‍Maestro, ¿yo casahmi cjuatsehen xi cuatjin rcá cha xi catsin cha? ¿Há suvá cha vihi ne?, o há tsajin ne, ¿há xutacha rë cha? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Hacuiin cha vihi ne, hacuiin xutacha rë cha casahmi me cjuatsehen ta cuatjin camá cojo sa xi ngatsë rë cjuandaja xi sahmi Nina cojo cha vihi ne, cumatsejen xa xi sahmi Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Meje rë xi nihña xa rë me xi catsingatju ná jinguyëjë rë xi hasen sa ta cuechú hora xi cumajñu, hane tsajin yo xi cuma sahmi xa. ");
INSERT INTO maqNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Jinguyëjë rë xi tejña nguehe ngasunhndë ne, sacuaha hasen xi cuma rë xuta ngasunhndë ngahan. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Xi cavatju cachja Jesús cjua vëhë ne, sehe cacandi me natya rë me nangui, hane casahmi me hitsë ndasi, sehe catsufë me tuxcun cha rcá jan. ");
INSERT INTO maqNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sehe cachja me cojo cha cuitjin: ―‍Tángun tinchacjun ngajan nda Siloé. ―‍Cuatjin cachja Jesús. (Siloé ne, meje cuichja Caningatjun rë.) Hya xi camá ne, quiji cha cavinchacjan cha. Xi tu cavuya cafe cha ndava cha ne, ha tsejen rë cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ngajan xi xuta xi siu tahndee ndava cha cojo me xi cavëë rë cha xi casahmi cha caridad ne, cavinenguise xicjin me cuitjin: ―‍¿Hacuiin cha vëhë xi véjña sahmi caridad jan ni? ―‍Cuatjin cavinenguise me xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ngujo me jan ne, cuitjin cachja me: ―‍Juun, hacui cha vë. ―‍Cuatjin cachja me. Hane ngujo nga me ne, cuitjin cachja me: ―‍Cuatjin tsejen, peru hacuiin cha. ―‍Cuatjin cachja me. Hane suvá cha ne, cuitjin cachja cha: ―‍Ngahan vi. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ngajan xi xuta xi cuacun jan ne, cavinenguise me cha cuitjin: ―‍¿Hacutjin camá xi camandaja túxcun ngayun? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ngajan xi cha vëhë ne, cuitjin cafayangui cha: ―‍Me xi hmí rë Jesús ne, casahmi me hitsë ndasi, sehe catsufë me túxcun, sehe cachja me cojo ná xi cjuë́ cuínchacjan nda Siloé. Hane xi cëjë cavinchácjan jan ne, camatsejen ná. ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Cavinenguise nga me cha cuitjin: ―‍¿Jani tacun me ni? ―‍Cuatjin cavinenguise me. Hane cha vëhë ne, cuitjin cachja cha: ―‍Hveen. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ngajan xi xuta xi cuacun jan ne, quijicojo me cha xi sehe camatsejen rë jan hiscan xi siu cha fariseo. ");
INSERT INTO maqNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Quihndë ne, nixtin xi casahmi Jesús ndasi hane casahmi me xi camandaja tuxcun cha rcá jan ne, nixtin xi chjahájenda rë. ");
INSERT INTO maqNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ngajan xi cha fariseo xi cuacun jan ne, hacuaha cavinenguise cha cha xi camandaja tuxcun jan hacutjin camá xi camatsejen rë cha. Hane cuitjin cafayangui cha: ―‍Ndasi catsufë me túxcun, sehe cëjë cavinchácjan, hane cama camatsejen ná. ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hane ngujo cha fariseo xi cuacun jan ne, cuitjin cachja cha: ―‍Me vëhë ne, tsejen xi hacuiin Nina catsingatju rë me, tsëhë xi faharcuaain me nixtin xi chjahájenda rë. ―‍Cuatjin cachja cha. Peru ngujo nga cha ne, cuitjin cachja cha: ―‍Cumaji sahmi me cjuarcun xi cuacun vëhë sa xi ngu cha tsehen me. ―‍Cuatjin cachja cha. Hacuiin ngu tangun ni camá cjua rë cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hane ngajan xi cavuya cachja nga cha cojo cha xi camandaja tuxcun jan cuitjin: ―‍Quihndë ta casahmi me xi camandaja tuxcuin ne, ¿mé noje tsëhë me? ―‍Cuatjin cachja cha. Hane cha xi camandaja tuxcun jan ne, cuitjin cafayangui cha: ―‍Ngu profeta me. ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Peru xutaxa rë yungun jan ne, macjaain rë me xi titjun ne, rcá cha hane quihndë ne, tsejen rë cha. Hisca xi cajindaya me xutacha rë cha xi camandaja tuxcun jan ne, ");
INSERT INTO maqNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","sehe cafahatáha rë me cuitjin: ―‍¿Há cha vihi xi quihndi nuju, cha xi nújun xi ha cuatjin rcá hisca hya xi catsin? ¿Hacutjin camá xi quihndë ne, tsejen rë cha? ―‍Cuatjin cafahatáha me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ngajan xi xutacha rë cha ne, cuitjin cafayangui me: ―‍Hyin xi cha vihi xi quihndi niji cha, hacuaha ha cuatjin rcá cha hisca hya xi catsin cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Peru hyíín hacutjin camá xi quihndë ne, tsejen rë cha. Hacuaha hyíín yo xi casahmi xi camandaja tuxcun cha. Chjinengunsun rë cha ta ha jiya nu rë cha. Suvá cha sua nuju cha cjuaquixi rë cha. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Cuatjin cachja xutacha rë cha ta, tsëhë xi tsacjun me xutaxa rë jan ta, xutaxa rë xi cuacun jan ne, ha casahmi tangun me cjua xi yo xi cuichja xi Nina catsingatju me Jesús ne, tsichohotje rë me yungun. ");
INSERT INTO maqNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Vëhë xi xutacha rë cha ne, cachja me: “Ha jiya nu rë cha ne, chjinengunsun rë cha.” ");
INSERT INTO maqNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Vëhë xi cajindaya nga xutaxa rë majo ndiya cha xi camandaja tuxcun jan, hane sehe cachja me cojo cha cuitjin: ―‍“Vëë Nina”, noje xi cuatjin camá. Ngayin ne, hyin xi me xi casahmi xi camandaja tuxcuin ne, ngu cha tsehen me. ―‍Cuatjin cachja xutaxa rë jan. ");
INSERT INTO maqNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ngajan xi cha vëhë ne, cuitjin cafayangui cha: ―‍Ngahan ne, hveen sa xi ngu cha tsehen me. Ngu xcusun ni xi hvë ne, titjun ne, rcá ngahan, peru quihndë ne, tsejen ná. ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hane xutaxa rë jan ne, cavinenguise me cha cuitjin: ―‍¿Mé casahmi me cojo ri? ¿Hacutjin casahmi me xi camandaja tuxcuin? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hane cha vëhë ne, cuitjin cafayangui cha: ―‍Ha cachjá cojo nuju ne, mijí cuetuhunrcun. ¿Mé má meje cuisiñuju nga ngundiya? ¿Há cojo ngayun meje cuisuhun ladu rë me? ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hane xutaxa rë jan ne, cacjan me cojo cha, cuitjin cachja me: ―‍¡Ngaye xi ladu rë cha vëhë má ngaye! ¡Ngayin ne, ladu rë Moisés má ngayin! ");
INSERT INTO maqNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ngayin ne, hyin xi Moisés ne, cachja me cjua xi casua Nina me, peru cha vëhë ne, hisca hyíín jani cavetju cha canduva cha. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ngajan xi cha vëhë ne, cuitjin cafayangui cha: ―‍¡Jemu sihya xi ngayun ne, hyúun jani cavetju me canduva me, handasa casahmi me xi camandaja túxcun ngahan! ");
INSERT INTO maqNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ha hyan ta Nina ne, fahacuendaain me cjua xi chja xuta tsehen. Peru sa xi ngu xuta faharcun me Nina hacuaha sahmi me hacutjin xi meje rë Nina ne, me vëhë ne, fahacuenda Nina cjua xi chja me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Cjëë camahani cuinuhya rë xi ngu xuta sahmi me xi mandaja tuxcun ngu xuta xi rcá me hisca hya xi catsin me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sa xi hacuiin Nina catsingatju rë me vëhë ne, tsajin camahani mé xi cuma sahmi me. ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ngajan xi xutaxa rë jan ne, cuitjin cachja me: ―‍¡Ngaye ne, ngajñi rë cjuatsehen camahani catsin ngaye! ¡Machjiriin camahani ngaye xi cuicoye niji! ―‍Cuatjin cachja me. Sehe cavaxë me cha candatsen. ");
INSERT INTO maqNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Hya xi camá ne, camachaya rë Jesús xi cavaxë xutaxa rë yungun cha xi camandaja tuxcun jan candatsen. Hane xi casacu xicjin Jesús cojo cha ne, cachja me cojo cha cuitjin: ―‍¿Há mangutacún ngayun cojo me xi Quihndi rë Xuta Jain? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hane cha vëhë ne, cuitjin cafayangui cha: ―‍Tatá, tinújun cojo ná yo me vë ne, cojo sa xi cumangu cácun cojo rë me. ―‍Cuatjin cafayangui cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ngajan xi Jesús ne, cuitjin cachja me cojo cha: ―‍Ngayun ne, ha cahyun me ta, ngahan xi tichjá cojo nuju vi ne, ha ngahan xi Quihndi rë Xuta Jain ngahan. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Hane cha vëhë ne, cuitjin cachja cha: ―‍Mangucácun, Tatá. ―‍Cuatjin cachja cha, sehe cafaharcun cha me. ");
INSERT INTO maqNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Canduvá ngahan ngasunhndë vi ne, xi tsichúva xuta cojo cjuatacun rë me, sehe ngajan xi xuta xi cjëë ndaja cuijne rcu me cjua rë Nina ne, cuijnercundaja me, hane xuta xi cuenda chja me xi jemu ndaja vijne rcu me cjua rë Nina ne, cumajñu tsëhë me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Hane ngujo cha fariseo xi hinchacun tiña hiscan secun Jesús ne, cahndë cha cjua vëhë, hane cuitjin cachja cha: ―‍¿Peru hacuiin cojo ngayin jñu tsijin? ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Sa xi jñu tsujun ne, tsajin jyë́ nuju. Peru quihndë xi nújun xi hacuiin jñu tsujun ne, ngajan matsejen xi tjin jyë́ nuju. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ngajan xi Jesús ne, cachja sa me cuitjin: ―‍Cuichjá cojo nuju cjuaquixi ta xuta xi visiin me táha tingotjo hnchua rë chu tsánga ta tu táha xín mijisun me hnchua ne, me vëhë ne, chëjë me hacuaha fahatahá cjuachan me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Peru me xi visehen táha tingotjo hnchua ne, me vëhë xi paxtu rë chu tsánga. ");
INSERT INTO maqNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Cha xi quitahá cuidadu rë tingotjo hnchua ne, vuxaha cha tingotjo tsëhë me vëhë. Chu tsánga ne, vihndë chu xta rë me, hane jindaya me chu xi tsëhë me, jimangu chu cojo ñihi rë chu, sehe vaxë me chu. ");
INSERT INTO maqNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hane hya xi ha cavaxë me yëjë chu xi tsëhë me ne, sehe cjui titjun me, hane chu tsánga ne, fitjengui chu me, tsëhë xi vëë chu xta rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Peru jingu sa xuta ne, hatuxa cjuiin tjenguiin chu me ta tu cuanga chu tsëhë me, tsëhë xi hvíin chu xta rë jingu sa xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Cuatjin cachja Jesús ejemplu vëhë cojo xuta xi cuacun vë, peru cajnii rcu me mé vijne cjua xi cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús ne, cachja sa me cojo xutaxa rë xi cuacun jan cuitjin: ―‍Cuichjá cojo nuju cjuaquixi ta ngahan ne, sacuaha tingotjo xi vatju chu tsánga ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yëjë ni cha xi cavetjujñi ngajñi rë xuta xi meje cumatitjun cha hya xi chaja sa cjuëhë ngahan ne, sacuaha cha chëjë cha, cha fahatahá cjuachan cha. Peru xuta ladu rë Nina ne, casahmicuendaain me cha, sacuatjin rë chu tsánga xi fitjenguiin chu jingu sa xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngahan ne, sacuaha tingotjo ngahan. Sa xi ngu xuta cuisehen me táha tingotjo jan ne, cuetjutje me. Hacuaha tsajin mé cumacjín cacun me cuetju cuisehen me jan, hane tsajin mé cuma chaja rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Cha chëjë ne, xi vinduva cha ne, suvá ni xi tsichëjë cha, tsiquehen cha, hacuaha tsinguetsun cha. Peru ngahan ne, canduvá cojo sa xi sacú rë xuta cjuahñu xatsë, hacuaha jercu sacú camahani rë me cjuahñu vëhë. ");
INSERT INTO maqNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","’Ngahan ne, sacuaha paxtu rë chu xi jemu ndaja fahácuenda chu tsánga. Paxtu ndaja jan ne, hisca sua me yojo rë me xi cueya me ngatsë rë chu tsánga. ");
INSERT INTO maqNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ngu mosu xi hacuiin paxtu rë chu má cha, hacuiin tsëhë cha chu tsánga ne, xi scuëë cha xi nduva tiña chu lobo ne, viyujutahá ni cha chu tsánga jan, hane vanga cha. Hane chu lobo jan ne, faha chu ngujo chu tsánga, sehe tsicangacojo chu chu xi yahnga jan tu nguehe tu ngajan. ");
INSERT INTO maqNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cuatjin sahmi cha ta, tsëhë xi mosu ni má cha, hane marcuaain rë cha tsëhë chu tsánga. ");
INSERT INTO maqNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ngahan ne, sacuaha paxtu ndaja jan ngahan. Sacuatjin vëë ná Nahmi naha hane ngahan ne, hvë Nahmi naha ne, ha chuva vëhë ni ne, ngahan ne, hvë chu tsahan hane chu tsahan ne, vëë chu ngahan. Hacuaha suá yojo naha xi cueya ngatsë rë chu. ");
INSERT INTO maqNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tjin sa ná chu tsánga xi hacuiin tsëhë hnchua vihi chu. Chu xi cuacun vë ne, hacuaha meje rë xi sahme chu cuidadu. Xi cuihndë chu xta naha ne, cuinduvatjengui chu ngahan, hane cuma tangun chu cojo chu xi ha tisahme cuidadu, hacuaha ngu ni ngahan xi paxtu rë chu. ");
INSERT INTO maqNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Ngahan ne, hmu cacun ná Nahmi naha, tsëhë xi suá yojo naha xi cueya, hane sehe sahme xi cúya nga cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tsajin yo xi cjuahatahá cjuahñu naha ta ngahan ne, cojo cjuatacun naha suva suá yojo naha xi cueya. Tjin ná chuva rë xi suá yojo naha, hacuaha tjin ná chuva rë xi sahme xi cúya nga cjuahñu. Cuatjin cavitexa ná Nahmi naha xi sahme. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hya xi camá ne, ngu ndiya nga hacuiin ngu tangun ni camá nga cjua rë xutaxa rë jan ngatsë rë cjua vëhë. ");
INSERT INTO maqNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Hane jemu cjín me xi cuacun jan ne, cuitjin cachja me: ―‍¡Jiya xitsehen xahasen rë cha, vëhë xi sca rë cha! ¡Venguiin chji rë xi cuatjin visiñuju cjua rë cha! ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Peru yahnga nga me ne, cuitjin cachja me: ―‍Cjua vëhë ne, hacuiin cjua rë ngu xuta xi jiya xitsehen xahasen rë me. ¿Ngu xitsehen ne, cumaji sahmi xi cumandaja tuxcun ngu xuta xi rcá me? ―‍Cuatjin cachja yahnga me jan. ");
INSERT INTO maqNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Quihndë ne, hya xi cavechú nixtin rë chan hnchan ne, camá suhi rë yungun xi matitjun ngajan Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Hane Jesús ne, tsujyihiya me ndatsen yungun xi matitjun, ngajan Ngahma Ndihya tsëhë Salomón. ");
INSERT INTO maqNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hane xutaxa rë yungun jan ne, quiji caxinchacunndee me Jesús, sehe cachja me cojo me cuitjin: ―‍¿Jani hisca hya tuhun niji cjuaquixi? Sa xi ngayun jain xi tsingatju Nina ngayun ne, tinújunquixun cojo niji. ―‍Cuatjin cachja xutaxa rë jan. ");
INSERT INTO maqNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Ha cachjá cojo nuju, peru macjaain nuju. Xcusun xi tisahme sacuatjin tivitexa ná Nahmi naha ne, xcusun vëhë ni tsingacun yo ngahan. Peru ngayun ne, macjaain nuju, ");
INSERT INTO maqNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","tsëhë xi hacuiin xuta ladu naha má ngayun. ");
INSERT INTO maqNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Xuta xi ladu naha má me ne, tangun me sacuaha chu tsánga. Me xi cuacun vë ne, vëë me xta naha, hacuaha ngahan ne, hvë me, hane fitjengui ná me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ngahan ne, suá rë me cjuahñu xatsë, hane hatuxa tsajin nu tsajin nixtin xi cjue hasen rë me xcun cjuañihi, hacuaha tsajin yo cuaxëxin rë me xi siu ntsa me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Xuta xi cuacun casua ná Nahmi naha ne, hitsë sa venguichji rë me xi cuma rë yëjë sa xcusun. Hacuaha tsajin yo cuma cuaxëxin rë me xi siu tsja Nahmi naja me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngahan cojo Nahmi naja ne, ngu ni xahasen niji, ngu ni cjuatacun niji, ngu ni hasen niji. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ngajan xi xutaxa rë xi cuacun jan ne, cafaha nga me ndyojo xi cuetaha me Jesús xi tsiquehen me me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Hane Jesús ne, cuitjin cachja me: ―‍Ngahan ne, jemu cjín xcusun ndaja casahme ngajñi nuju sacuatjin cavitexa ná Nahmi naja. Hane ¿jarë xcusun vëhë tsëhë xi cuetuhun ná ndyojo ni? ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ngajan xi xutaxa rë jan ne, cuitjin cafayangui me: ―‍Hacuiin tsëhë ngu xcusun ndaja xi canihñi xi cuetihin ri ndyojo ta ngatsë rë xi nixcuehyi Nina, ngatsë rë xi handasa ngu xuta ni ngaye ne, peru noje xi tangun ngaye cojo Nina. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Ley rë Moisés xi vitexa nuju ne, ha ndaja hyun xi camahindu cjua vihi xi cachja Nina: “Ngayujun ni ne, nina ngayun.” Cuatjin camahindu. ");
INSERT INTO maqNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ngayejen ni ne, ha hyan ta cjua xi chja xcun xujun rë Nina ne, hatuxa cjuaquixi jain. Hane Nina ne, cachja me nina tsëhë xuta xi cuacun cafahatsja cjua rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Quihndë ta Nina cavaxijin ná me hacuaha catsingatju ná me nguehe ngasunhndë ne, ¿hacutjin má xi nújun xi ngahan ne, choho chjá, tsëhë xi cachjá xi Quihndi rë Nina ngahan ni? ");
INSERT INTO maqNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sa xi ngahan tisahmee xcusun xi cavitexa Nahmi naha xi sahme ne, xicamacjaain nuju ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Peru sa xi tisahme ne, handasa cumacjaain nuju ngahan ne, ndastu tsëhë xcusun xi sahme ne, catamacjain nuju, cojo sa xi cuijne rcun ngundiyaxa ni xi Nahmi naja ne, jiya me xahasen naha, hane ngahan ne, tejñaya xahasen rë me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ngajan xi casahmi nga xutaxa rë jan cjuandya xi cjuaha me Jesús, peru Jesús ne, cavetjutje me tsëhë xuta jan quiji me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Hya xi camá ne, cavetju Jesús quiji nga me ngunda vëhë tsëhë Ndajyë Jordán, ngajan hiscan xi casetaha Juan cavitenda me xuta ntsacu cavetsihin. Hane ngajan casetaha me. ");
INSERT INTO maqNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Hane jemu cjín xuta quijitjengui me Jesús. Hane cuitjin cachja xingu xingu me cojo xicjin me: ―‍Juan ne, handasa casahmii me cjuarcun, peru yëjë ni cjua xi cachja me tsëhë me vihi ne, cjuaquixi jain. ");
INSERT INTO maqNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hane jemu cjín xuta camangu cacun me cojo Jesús ngajan cahndë́ vëhë. ");
INSERT INTO maqNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tacun ngu cha hmu rë xi hmí rë Lázaro, ngu cha Betania, nangui rë na María cojo na Marta tíchja na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Na María vëhë ne, na vëhë xi cavitejnu na ntsacu Nai naja ngu xcusun aceite xi jemu ndaja jne camahani hacuaha jercu hnga chji rë, sehe catsixiya na cojo tsjarcu na. Na vëhë xi hmu rë cha Lázaro hntsë na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ngajan xi catsijo na vëhë ne, catsingatju na cjua vihi tsëhë Jesús: ―‍Tatá, chutsujun ni, cha xi jemu vinga nuju jan ne, jemu hmu rë cha. ―‍Vëhë cjua xi catsingatju na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Hane xi cahndë Jesús cjua vëhë ne, cuitjin cachja me: ―‍Chíhin vëhë ne, cuetjincaain cjuaveya rë cha Lázaro cojo ta xi cuetjucaa ne, cuma jyë cuma hnga Nina cojo Hasen rë me, cojo sa xi Quihndi rë Nina ne, hacuaha cuma jyë cuma hnga me cojo Hasen rë me ngatsë rë chíhin vëhë. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Quihndë ne, Jesús ne, jemu vinga rë me na Marta cojo tíchja na cojo cha Lázaro. ");
INSERT INTO maqNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Peru xi camachaya rë Jesús xi hmu rë cha ne, casetaha me jo nixtin sa hiscan xi ha quitahá me jan. ");
INSERT INTO maqNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Xi cavatju vëhë ne, sehe cachja me cojo xuta ladu rë me jan cuitjin: ―‍Cuyan cuanguen nga ngu cahndë́ tsëhë distritu Judea. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ngajan xi xuta ladu rë me jan ne, cuitjin cachja me: ―‍Maestro, xutaxa rë yungun jan ne, ¡sehe tiña nixtin xi casahmi me cjuandya xi tsiquehen nuju me cojo ndyojo! ¡Xi meje rë ne, cuanguun ngajan! ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Hane Jesús ne, cuitjin cafayangui me: ―‍¿Hacuiin tejó hora tjin rë xi ngu nixtin ni? Quihndë xi cjëë cuechú hora xi cuichja Nina xi cueya ngahan ne, tsajin mé cuma ná, sacuatjin xtenguiin naja xi nguinixtin tsëhë xi tsejen naja hasen rë tsuhi. ");
INSERT INTO maqNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Peru xi cuechú hora xi cuichja Nina xi cueya ngahan ne, cueya, sacuatjin xtengui naja xi nixten tsëhë xi tsajin hasen xi cuma naja. ");
INSERT INTO maqNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Cuatjin cafayangui Jesús cjua vëhë, hane sehe cachja sa me cuitjin: ―‍Cha amigu naja, cha Lázaro ne, cafañafë cha. Peru cjuë́ ngahan tsingásca rë cha. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ngajan xi xuta ladu rë me jan ne, cuitjin cachja me: ―‍Tatá, sa xi cafañafë jain cha ne, vëhë tsejen xi cumandaja cha. ―‍Cuatjin cachja xuta ladu rë me jan. ");
INSERT INTO maqNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Quihndë ne, cjua xi cachja Jesús vë ne, tsëhë cjuaveya rë cha Lázaro. Peru xi má rë xuta ladu rë me jan ne, tichja me tsëhë nijñá ni rë cha. ");
INSERT INTO maqNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ngajan xi Jesús ne, cachja quixi me cuitjin: ―‍Cha Lázaro ne, cahme cha. ");
INSERT INTO maqNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Hane ngahan ne, jemu ndama ná xi hacuiin ngajan tejña hora vëhë ta, xi chutsujun hacutjin cuma ne, cumangu tacún cojo ná. Peru cuanguen tjenguen nima. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ngajan xi Tomás, me xi chja me tsëhë cha Lihma ne, cuitjin cachja me cojo xuta ladu rë Jesús xi yahnga jan: ―‍Hacuaha cuanguen ngayaan, cojo sa xi cueyan tangun cojo rë me. ―‍Cuatjin cachja Tomás. Sehe cavetju yëjë me quiji me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Hya xi camá ne, xi cafehe me ngajan Betania ne, camachaya rë Jesús xi ha tjin rë ñuju nixtin xi jiyaniji nima Lázaro. ");
INSERT INTO maqNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania jan ne, sacuaha chuva rë jyan kilómetro tacun tsëhë Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Hane jemu cjín xuta quiji tjengui me na Marta cojo na María xi sua me na cjuetacun tsëhë cjuaveya rë hntsë na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Hane xi camachaya rë na Marta xi nduva Jesús ne, cavetju na quiji cafahatsja na me. Peru na María ne, cavéjña ni na ndava na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Hya xi camá ne, xi casacu xicjin na Marta cojo Jesús ne, cuitjin cachja na cojo rë me: ―‍Tatá, sa ngayun nechun nguehe ne, cahmii nima xingueen. ");
INSERT INTO maqNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Peru hvë ta hisca quihndë ne, tu mé ni xi chjahyun rë Nina ne, sua nuju me. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ngajan xi Jesús ne, cuitjin cachja me cojo rë na: ―‍Nima xingun ne, cuya cjuahñu. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Hane na Marta ne, cuitjin cachja na: ―‍Hvë ta cuya nima xingueen cjuahñu hya xi hacuaha yëjë nima cuya cjuahñu, nixtin xi tsichuva Nina sa nima sa xuta. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ngajan xi Jesús ne, cuitjin cachja me cojo rë na: ―‍Ngahan xi suá cjuahñu hacuaha tsicúya nima cjuahñu. Xuta xi mangucacun me cojo ná ne, ha ndasa cueya me ne, peru cuya me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Hane yëjë xuta xi tjin rë me cjuahñu xatsë hacuaha mangucacun me cojo ná ne, hatuxa tsajin nu tsajin nixtin xi cjue hasen rë me xcun cjuañihi. ¿Há macjain nuju cjua vëhë? ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ngajan xi na vëhë ne, cuitjin cafayangui na: ―‍Juun, macjain ná, Tatá. Macjain ná xi ngayun xi catsingatju nuju Nina, ngayun xi Quihndi rë Nina ngayun. Hacuaha ngayun xi jemu cavinechinyin nuju xi cuinduvun ngasunhndë. ―‍Cuatjin cafayangui na Marta. ");
INSERT INTO maqNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Xi cafë cachja na Marta cuatjin ne, sehe cavuya na quiji jaha na na María tíchja na. Hane xi cafehe na jan ne, sehe cajindayahma na na María, cuitjin cachja na: ―‍Cafehe maestru, hane jindaya me ngaye. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Xi tu cahndë na María cjua vëhë ne, marcu macjain cavisatjen na quiji tjengui na Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Quihndë ne, cjëë sa cuisehen Jesús nandya ta secun cuaha me cahndë́ hiscan cavechútaha na Marta me. ");
INSERT INTO maqNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hane xuta xi siu cojo na María ndava na xi tisua me na cjuetacun ne, xi cavëë me xi marcu macjain cavisatjen na quiji na ne, quiji tjengui me na. Xi má rë me ne, xcun tsjun cjui na, cojo sa xi ngajan squihnda na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Hane xi cafehe na María hiscan secun Jesús ne, xi cavëë na me ne, quiji caticjaxcun na xcun me, sehe cachja na cuitjin: ―‍Tatá, sa xi ngayun nechun nguehe ne, cahmii nima xingueen. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Hane xi cavëë Jesús xi cuatjin jihnda na hacuaha jihnda yëjë xuta xi ticojo na jan ne, camandya cacun me, jemu choho camahani camá rë xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hane cuitjin cavinenguise me: ―‍¿Jani tacun tsjun xi caveyun nima? ―‍Cuatjin cavinenguise me. Hane xuta jan ne, cuitjin cafayangui me: ―‍Tatá, nduvun chutsujun. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hane cajihnda Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ngajan xi xuta jan ne, cuitjin cachja me ngajñi rë me: ―‍Chutsujun ni hacutjin catsihmu cacun me nima. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Peru ngujo me ne, cuitjin cachja me: ―‍Me vihi xi casahmi me xi camandaja tuxcun cha rcá jan ne, ¿há camaji casahmi me xi cahmii nima vëhë? ―‍Cuatjin cachja ngujo xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ngajan xi Jesús ne, ngu ndiya nga jemu camandya cacun me. Sehe quiji me xcun tsjun. Tsjun jan ne, ngu nguijo, hane tingotjo rë ne, titsa ngu ndyojo. ");
INSERT INTO maqNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Chjuhunxun ndyojo vë. ―‍Cuatjin cachja me. Ngajan xi na Marta, tíchja nima ne, cuitjin cachja na: ―‍Tatá, ha choho jne vë ta, ha tjin rë ñuju nixtin. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Hane Jesús ne, cuitjin cachja me cojo rë na: ―‍Ha cachjá cojo nuju ta sa xi cumacjain nuju cjua naha ne, ngayun ne, chutsujun hacutjin jyë hnga Nina cojo Hasen rë me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hya xi camá ne, cachjaháxin rë ndyojo jan. Hane hora vëhë cavutsejenniji Jesús ngahnga, sehe cachja me cuitjin: ―‍Ngayun Nahmi naha, suá nacuechji nuju ta canihñucuendun cjua xi cachjá cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Hacuaha ha hvë ta ngayun ne, hatuxa nihñucuendun cjua naha. Vëhë xi hacuiin ngujyë xi cuichjá cojo nuju cjua vihi, peru ngatsë rë xuta xi hinchacunndee vi ne, vëhë xi cuitjin tichjá, cojo sa xi cumacjain rë me xi ngayun caningatjun ná. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hane xi cajnetaha cachja me cuatjin ne, sehe ña cajindaya me cachja me cuitjin: ―‍¡Lázaro, tetjun! ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hya xi camá ne, cavetju Lázaro tsëhë tsjun jan, tjinguiya tsjian ntsacu me, tjinguiya tsjian tsja me, hacuaha tjihñu xcun me cojo ngu pañutu. Hane Jesús ne, cuitjin cachja me cojo xuta jan: ―‍Chundecjun tsjian vë sehe cumandaya me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Quihndë ne, jemu cjín xuta quiji cavusehenya rë na María hacuaha cavëë me hacutjin casahmi Jesús. Hane xuta xi cuacun jan ne, camangu cacun me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Peru ngujo xuta ne, quiji cachja me cojo cha fariseo hacutjin casahmi Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ngajan xi yëjë nahmi xi matitjun cojo cha fariseo xi cuacun jan ne, casahmi me ngu junta. Hane xcun junta jan ne, cuitjin cachja me: ―‍¿Mé ndatjin nihña? ta cha xi cuajyihi vë ne, jemu tisahmi cha cjuarcun. ");
INSERT INTO maqNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sa xi tsajin mé xi nihña ne, yëjë xuta ne, cumangu cacun me cojo cha. Hane vëhë xi xutaxa rë Roma ne, cuma cjan rë me, hane cjuahatahá me yungun xi matitjun naja hacuaha cjuahatahá me gubiernu xi tinihña. ―‍Cuatjin cachja me xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Peru ngu me xi cuacun jan xi hmí rë Caifás, me xi hacuaha má nahmi xi matitjun tsëhë yëjë nahmi nu vëhë ne, cachja me cuitjin: ―‍Ngayun ne, hyúun camahani. ");
INSERT INTO maqNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Vijnii rcun xi ndaja tsujun xi ngu xihin ni cueya ngatsë rë yëjë ni xuta, hane hacuiin yëjë xuta cueya me. ―‍Cuatjin cachja Caifás. ");
INSERT INTO maqNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Peru me vëhë ne, hacuiin cachja me cojo cjuatacun rë suvá me ta, ngatsë rë xi má me nahmi xi matitjun nu vëhë ne, cachja me cjua xi casua Nina me xi Jesús cueya me ngatsë rë xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Peru hacuiin ngatsë rë suvá ni xuta tjë rë Israel ta hacuaha cueya me cojo sa xi sahmi tangun me yëjë quihndi rë Nina xi tinguitsojo, sehe cuma yëjë me sacuaha ngu ni xcusun xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ngajan xi hisca nixtin xi cachja Caifás cuatjin ne, nahmi xi matitjun cojo cha fariseo xi cuacun jan ne, caviyuju me cjuatacun rë me xi tsiquehen me Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Vëhë xi Jesús ne, catsujyihiyaaintë me nandya xi siu ladu rë distritu Judea ta cavetjuxin me tsëhë ngajan, quiji me ngu nandya xi hmí rë Efraín, tiña hiscan xi faha rë xi ha jemu xín camahani tsëhë nandya. Hane ngajan casetaha me cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Quihndë ne, ha camatiña suhi tsëhë Pascua. Hane jemu cjín xuta quiji me Jerusalén chaja sa nixtin rë suhi jan xi cuma tyjahi me sacuatjin xi ha xcusun rë xutachanga. ");
INSERT INTO maqNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jemu siu me cuidadu há cjuehe Jesús suhi jan. Hane jinguyëjë rë xi hinchacun me yungun xi matitjun jan ne, vinenguise xicjin me xingu xingu me cuitjin: ―‍¿Mé xi má nuju? ¿Há cuinduvaain me suhi? ―‍Cuatjin cavinenguise xicjin me. ");
INSERT INTO maqNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Quihndë ne, nahmi xi matitjun cojo cha fariseo xi cuacun jan ne, ha cavitexa me xi yo xi vëë hiscan tacun Jesús ne, sua cumachaya rë me, cojo sa xi chjahá rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jyun nixtin chaja sa xi cuechú suhi tsëhë Pascua ne, cavuya quiji Jesús ngajan Betania, hiscan xi tacun cha Lázaro, cha xi catsicuya Jesús cjuahñu hya xi cahme cha. ");
INSERT INTO maqNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hane ngajan casehenndaja ngu comida xi sinë me. Na Marta tivincha na comida, peru cha Lázaro ne, cojo cha tijinë cha cojo Jesús cojo me xi yahnga sa. ");
INSERT INTO maqNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hane na María ne, cafaha na ngu frascu xi hincha jo cuartu aceite nardo xi jemu ndaja jne hacuaha jemu hnga chji rë, quiji cavitejnu na ntsacu Jesús, sehe catsixiya na cojo tsjarcu na. Hane cahntsua ndihya jan ne, ña catsë rë cojo xta rë aceite jan. ");
INSERT INTO maqNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ngajan xi Judas Iscariote, ngu cha ladu rë Jesús, cha xi sahmi rë me entregadu ne, cuitjin cachja cha: ");
INSERT INTO maqNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―‍¿Mé má cuatjin casahmi na? Aceite vë ne, cuma xteña hane sacú chji rë jyan cientu nixtin xa xi sahmi ngu xuta, hane tujún vëhë ne, tahan rë xuta yuma. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Peru Judas ne, hacuiin tsëhë xi marcun rë cha tsëhë xuta yuma xi cuatjin cachja cha ta tsëhë xi chëjë cha, hacuaha cha vëhë tjin tsja cha tsá xi hincha yëjë tujún, hane jiya hora ne, tsichëjë cha tsë tsë. ");
INSERT INTO maqNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Xicanújiin cojo rë na. Catetjo na xi tjin rë na hisca hya xi seyaniji ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Xuta yuma ne, yëjë nu yëjë nixtin ne, siu me cojo nuju, peru ngahan ne, hacuiin yëjë nu yëjë nixtin tejña cojo nuju. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Hya xi camá ne, jemu xutacjín tsëhë nandya xi siu distritu Judea ne, camachaya rë me xi Jesús ne, Betania quitahá me. Ngajan xi quiji xuta ngajan, hacuiin tsëhë xi meje scuëë ni me Jesús ta hacuaha tsëhë xi meje scuëë me cha Lázaro, cha xi catsicuya Jesús cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hane nahmi xi matitjun jan ne, caviyuju cacun me xi hacuaha cojo cha Lázaro tsiquehen me cha, ");
INSERT INTO maqNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tsëhë xi ngatsë rë cha vëhë ne, jemu cjín xuta titsitjungui me nahmi jan, hane tijimangu cacun me cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Xi camá nchujun jan ne, xutacjín xi cafehe suhi jan ne, camachaya rë me xi Jesús ne, hacuaha nduva me Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Hane cafaha me xca jne, sehe cavetju me quijitjengui me Jesús hiscan nduva me. Hane hisca jindaya me cachja me cuitjin: ―‍¡Jemu ndaja Nina! ¡Jemu catsinchacun Nina me xi nduva vi tsëhë xi Nina catsingatju rë me, me xi cumatitjun tsajan ngayaan xuta tjë rë Israel! ―‍Cuatjin cajindaya me cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Hane xi casacu rë Jesús ngu burru chihndë ne, sehe camiji me chu, sacuatjin camahindu tsëhë me xcun xujun rë Nina hiscan xi chja cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","¡Xicarcuun ngayun xuta Jerusalén; chutsujun ni, me xi matitjun tsujun ne, nduva me quisun me ngu burru chihndë! ");
INSERT INTO maqNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hya xi cuatjin camá ne, xuta ladu rë Jesús ne, cajnii rcu me. Peru hya xi Jesús cama jyë cama hnga me cojo Hasen rë me ne, hya xi cavuya cjuahñu rë me hya catsinguitsjen xuta xi cuacun jan xi cuatjin camahindu tsëhë Jesús hane cuatjin jain cavatju me camá. ");
INSERT INTO maqNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Xuta xi siu cojo Jesús hya xi cajindaya me cha Lázaro xi cuetju cha tsëhë tsjun hacuaha catsicuya me cha cjuahñu ne, casua me camachaya rë jingu sa xuta hacutjin camá. ");
INSERT INTO maqNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Vëhë xi xutacjín jan ne, cavetju me quijitjengui me Jesús, tsëhë xi camachaya rë me xi casahmi Jesús cjuarcun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Vëhë xi cha fariseo ne, cachja cha ngajñi rë cha cojo xicjin cha cuitjin: ―‍Cahyun ni ne, tsajin mé xi cuma nihña. Chutsujun ta yëjë ni xuta ne, tjengui rë cha. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Quihndë ne, ngajñi rë xuta xi quiji me suhi xi cjuaharcun me Nina ne, hinchajñi ngujo xutaxín. ");
INSERT INTO maqNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hane me xi cuacun vëhë ne, quijitjengui me Felipe, xuta Betsaida, ngu nandya tsëhë distritu Galilea, hane cuitjin cachja me: ―‍Tatá, ngayin ne, meje cuisiajmí cojo Jesús. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ngajan xi Felipe ne, quiji cachja me cojo Andrés, sehe catsijo ni me quiji casua me camachaya rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ngajan xi Jesús ne, cuitjin cachja me cojo rë me: ―‍Cavechú hora xi ngahan xi Quihndi rë Xuta Jain ngahan ne, cuma jyë cuma hnga ngahan cojo hasen naha. ");
INSERT INTO maqNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cuichjá cojo nuju cjuaquixi ta ngu tú rë trigu xi cjuinengui nangui ne, sa xi cueyaain ne, ha ngu tu tu ni má yëjë nu yëjë nixtin. Peru sa xi cueya ne, jemu cjín tjë sua. ");
INSERT INTO maqNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Xuta xi vangui me suvá ni xi ndaja cjuahñu rë me nguehe ngasunhndë ne, titsichajá me cjuandaja xi sua Nina me cjuahñu xatsë. Peru xuta xi marcuaain rë me tsëhë suvá ni xi ndaja cjuahñu rë me nguehe ngasunhndë ne, hatuxa sacú rë me cjuandaja xi sua Nina me cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Xuta xi meje cuisehen me ladu naha ne, catinduva tjengui ná me. Hane hiscan xi cuitejña ngahan ne, hacuaha ngajan cuejña me xi má ladu naha. Xuta xi má me ladu naha ne, sahmi jyë sahmi hnga Nina Nahmi naja me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Cachja sa Jesús cuitjin: ―‍Quihndë ne, jemu macjín cácun. Peru ¿mé cuichjá ni? ¿Há cuichjá cuitjin: “Ngayun Nahmi naha, naxuntjun ná tsëhë xcusun xi cuátju cuma quihndë?” Peru cuichjaan cuatjin ta, tsëhë xi hatuxa canduvá xi cuatjin cuátju cuma. ");
INSERT INTO maqNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ngayun Nahmi naha, tuhun cumachaya rë xuta hacutjin jyë hnga ngayun cojo Hasen nuju. ―‍Cuatjin cachja Jesús. Ngajan xi canuhya rë ngu xta xi canduva ngajan ngahnga xi cachja cuitjin: ―‍Ha casuá camachaya rë me, hacuaha cúya suá nga cumachaya rë me. ―‍Cuatjin cachja xta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hane ngujo xuta xi hinchacun jan xi cahndë me xta jan ne, cachja me ta chuhun xi catsingá. Hane ngujo nga me ne, cachja me xi ngu ángel cachja cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ngajan xi Jesús ne, cuitjin cachja me cojo xuta jan: ―‍Hacuiin xi cuíhndë ngahan xi cachja xta vëhë ta xi cuinuhyun ngayun. ");
INSERT INTO maqNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cavechú nixtin xi cuma chuva xuta cojo cjuatacun rë me. Cavechú nixtin xi cjuahatahá Nina gubiernu xi tisahmi Satanás. ");
INSERT INTO maqNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hane ngahan ne, hya xi tjunihnga ná tsëhë nangui ne, sahme xi xuta ne, cuisehen me ladu naha. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Xi cuatjin cachja Jesús ne, casua me camachaya rë xuta mé chuva rë cueya me. ");
INSERT INTO maqNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ngajan xi xuta jan ne, cuitjin cafayangui me tsëhë Jesús: ―‍Ngayin ne, hyin xi chja ley ta me xi Nina tsingatju rë ne, tsajin nixtin xi cueya me. ¿Hacutjin má xi nújun ngayun xi me xi Quihndi rë Xuta Jain ne, tjunihnga rë me? ¿Yo me xi Quihndi rë Xuta Jain vë ni? ―‍Cuatjin cafayangui xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ngajan xi Jesús ne, cuitjin cachja me cojo xuta jan: ―‍Ha tu chúva sa nixtin xi ngahan xi sacuaha hasen ngahan ne, tejña ngajñi nuju. Tángun xcun sa cojo ndiya xi ha tivangun jinguyëjë rë xi tacun sa hasen ngajñi nuju, sa tu cuechútáha nuju jñú. Xuta xi cjui me ngajñi jñú ne, hvíin me jani cjui me. ");
INSERT INTO maqNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Vëhë xi jinguyëjë rë xi tejña ngajñi nuju ne, catamangu tacún cojo ná, cojo sa xi tsë rë xahasen nuju cojo cjuahasen naha. ―‍Cuatjin cachja Jesús. Hane xi cavatju cachja Jesús cjua vëhë ne, cavetju me quijihma me tsëhë xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Handasa cavëë xuta xi jemu cjín cjuarcun casahmi Jesús ne, peru camanguaain cacun me cojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Cuatjin camá xi cavetjucaa cjua rë profeta Isaías xi camahindu xcun xujun rë Nina hiscan xi chja cuitjin: Ngayun Nina niji, tsajin yo camacjain rë cjua xi canújin; Tsajin yo cajne rcu hacutjin xi hñu ngahñu rë Nina. Cuatjin cachja profeta Isaías. ");
INSERT INTO maqNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Vëhë xi xuta jan ne, camaji camangu cacun me cojo Jesús ta, tsëhë xi hacuaha cachja nga profeta Isaías cuitjin: ");
INSERT INTO maqNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Sacuaha ngu xuta xi tsihñu me xcun ngu nga xuta cojo sa xi cumatsijin rë me ne, cuatjin casahmi jñu Nina tsëhë cjuatacun rë xuta, cojo sa xi cuijnii rcu me hacuaha cuyaain me ladu rë Nina xi sahmi Nina xi cumandaja me. ");
INSERT INTO maqNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Cuatjin cachja Isaías cjua vëhë ta, tsëhë xi cavëë me hacutjin jyë hnga Jesús cojo hasen rë me hane cuatjin cachja me tsëhë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Handasa cuatjin casahmi Nina ne, jemu cjín xutaxa rë camangu cacun me cojo Jesús. Peru tsëhë xi tsacjun me cha fariseo ne, catsinguixiin me ngajñi rë xuta, sa tu cumachohotje rë me yungun. ");
INSERT INTO maqNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Xutaxa rë xi cuacun vë ne, hitsë sa meje rë me xi sahmi yehe sahmi hnga xuta me, xi cuma rë xi sahmi yehe sahmi hnga Nina me. ");
INSERT INTO maqNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ngu ndiya nga jan ne, jemu hñu cachja Jesús cuitjin: ―‍Xuta xi mangucacun me cojo ná ne, hacuiin suva ni mangucacun me cojo ná ta hacuaha mangucacun me cojo Nina Nahmi naja, me xi catsingatju ná. ");
INSERT INTO maqNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hane xuta xi vijne rcu me yo ngahan ne, hacuaha vijne rcu me yo me xi catsingatju ná. ");
INSERT INTO maqNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngahan xi sacuaha hasen xi cuma rë xuta ngahan ne, canduvá nguehe ngasunhndë, cojo sa xi yëjë xuta xi mangucacun me cojo ná ne, cjuë xi jñu tsëhë cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hane sa xi ngu xuta vetaha rcu me cjua xi chjá peru faharcuaain me ne, ngahan ne, tsichuvaan me cojo cjuatacun rë me ta, tsëhë xi ngahan ne, hacuiin canduvá xi tsichúva xuta cojo cjuatacun rë me ta canduvá xi cuáxëtje me. ");
INSERT INTO maqNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Xuta xi tsitjungui ná me hacuaha fahatsjaain me cjua naha ne, ha tjin yo xi tsichuva rë me. Cjua xi cachjá ne, cjua vëhë xi tsichuva rë me nixtin xi tsichuva Nina sa nima sa xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ngahan ne, cjua xi cachjá ne, hacuiin cachjá cojo cjuatacun naha suva ta Nina Nahmi naja, me xi catsingatju ná ne, suvá me cavitexa ná me hacutjin meje rë xi cuichjá. ");
INSERT INTO maqNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Hane hvë ta cjua xi vitexa me vëhë ne, sua naja cjuahñu xatsë. Vëhë xi cjua xi chjá ne, suvá cjua xi cavitexa Nina Nahmi naja. ");
INSERT INTO maqNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Quihndë ne, cavechú nixtin xi chaja sa ngu nixtin xi cuma suhi tsëhë Pascua. Hane Jesús ne, ha vëë me xi cavechú hora xi cuetju me tsëhë ngasunhndë vihi, cjue tjengui me Nina Nahmi naja. Hatuxa catsihmu cacun me xuta ladu rë me xi siu ngasunhndë vihi, hacuaha hacuanitjin ni catsihmu cacun me hisca xi cahme me. ");
INSERT INTO maqNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesús cojo xuta ladu rë me ne, tijinë nguixun me. Hane cha Judas, quihndi rë Simón Iscariote ne, ha casahmi Satanás xi cuejña cacun cha xi sahmi entregadu cha Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Peru Jesús ne, ha vëë me xi ha cavejña Nina yëjë xcusun tsja me. Hacuaha ha vëë me xi hiscan tacun Nina canduva me, hane hacuaha ngajan ni cuya cjue nga me. ");
INSERT INTO maqNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Hya xi camá ne, cavejña Jesús xi tijinë me jan ne, cavisatjenhnga me, sehe cavaxë me chingá rë me cavejñaxin me, hane cafaha me ngu toalla cavityanguitaha me. ");
INSERT INTO maqNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sehe cafaha me nandá cojo nisu, hane cavetsihin cavane me ntsacu xuta ladu rë me hacuaha catsixiya me cojo toalla xi tyjanguitaha rë me jan. ");
INSERT INTO maqNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Hane xi cafehe me xcun Simón Pedru ne, cachja Pedru cuitjin: ―‍Tatá, ¿há xi ngayun cuanu ntsacú? ―‍Cuatjin cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Xcusun xi tisahme vi ne, vijnii rcun quihndë, peru ngascan ne, hya cuijne rcun. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Hane Pedru ne, cuitjin cachja me: ―‍¡Hatuxa tsajin nu tsajin nixtin xi ngayun cuanu ntsacú! ―‍Cuatjin cachja me. Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Sa xi cuánee ntsacun ne, hacuiin xuta ladu naha ngayun. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ngajan xi Simón Pedru ne, cuitjin cachja me cojo Jesús: ―‍Tatá, sa cuatjin ne, ¡hacuiin suvá ni ntsacú ta hacuaha cojo ntsa cojo rcú tanu! ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ngajan xi Jesús ne, cuitjin cafayangui me tsëhë Pedru: ―‍Xuta xi ha cavinduya me ne, suvá ni ntsacu me meje rë xi cjuengui ta, tsëhë xi ha tyjahi me. Ngayujun ni ne, ha tyjahi ngayun. Peru ngu ngayun ne, hacuiin cuatjin. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tsëhë xi ha vëë Jesús yo xi sahmi rë me entregadu, vëhë xi cachja me xi: “Hacuiin ngayujun xi tyjahi ngayun.” ");
INSERT INTO maqNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hane xi cavatju cavane Jesús ntsacu xuta ladu rë me ne, sehe cavuya cavajá me chingá rë me, sehe quiji cafaha nga me cahndë́ rë me xcun maxë. Hane sehe cachja me cojo xuta ladu rë me cuitjin: ―‍¿Há vijne rcun xcusun xi casahme cojo nuju vë? ");
INSERT INTO maqNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ngayun ne, maestru niji hacuaha nai niji nújun tsahan. Hane ndatjin xi cuatjin nújun ta, tsëhë xi cuatjin jain. ");
INSERT INTO maqNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Quihndë ne, quihndë ta ngahan xi nai nuju hacuaha maestru nuju ngahan cavane ntsacun ne, hacuaha meje rë xi cuatjin cuanu ntsacu xingun xingu xingu ngayun. ");
INSERT INTO maqNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ngahan ne, cavejñá nuju ngu ejemplu vë, cojo sa xi sacuaha xcusun xi casahme cojo nuju vë ne, hacuaha cuatjin nihñu. ");
INSERT INTO maqNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cuichjá cojo nuju cjuaquixi ta ngu mosu hndixahan ne, hacuiin hitsë sa venguichji rë xi cuma rë nai rë, hacuaha ngu xi ningatjun rë ne, hacuiin hitsë sa matitjun xi cuma rë me xi catsingatju rë. ");
INSERT INTO maqNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Quihndë ta ha vijne rcun cjua vëhë ne, jemu ndaja tsujun sa xi nihñu cuatjin. ");
INSERT INTO maqNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Peru ngahan ne, hacuiin tichjá tsujun ngayujun ni ta ngahan ne, ha hvë yo xi cavaxejen. Peru meje rë xi cuetjucaa cjua xi camahindu xcun xujun rë Nina xi chja cuitjin: “Cha xi cajinë tangun cojo ná ne, camá cha condra naha.” Cuatjin camahindu. ");
INSERT INTO maqNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tichjá cojo nuju cjua vëhë quihndë chaja sa xi cuetjucaa, cojo sa xi hya xi cuetjucaa ne, ngayun ne, cumacjain nuju xi Ngahan Vi hmí ná. ");
INSERT INTO maqNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cuichjá cojo nuju cjuaquixi ta xuta xi cjuahatsja me tu yo ni xi tsingátju ne, tangun sacuaha xi cjuahatsja ná me ngahan suva. Hane xuta xi cjuahatsja ná me ne, tangun sacuaha xi cjuahatsja me Nahmi naha xi catsingatju ná me. ―‍Cuatjin cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Xi cavatju cachja Jesús cuatjin ne, jemu camandya cacun me, hane cuitjin cachja me: ―‍Cuichjá cojo nuju cjuaquixi ta ngu ngayun ne, nihñu ná entregadu. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Hane xuta ladu rë Jesús xi cuacun jan ne, cavutsejenya me xcun xicjin me xingu xingu me. Hvíin camahani me yo tsëhë xi cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Hane ngu cha ladu rë Jesús xi jemu vinga rë me ne, tjehen rë Jesús ne, ngajan tijinë cha niñu. ");
INSERT INTO maqNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Vëhë xi Simón Pedru ne, casahmi rcu me cojo cha vëhë, sehe cachja me cuitjin: ―‍Chjinengunsun rë me yo tsëhë xi chja me. ―‍Cuatjin cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hane xi catsicuya cha vëhë xcun cha tiña xcun Jesús ne, sehe cavinenguise cha me cuitjin: ―‍Tatá, ¿yo xi nújun vë? ―‍Cuatjin cavinenguise cha. ");
INSERT INTO maqNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Cha xi suá rë ngu rquí niñu vi hora xi cjuë tsinguísehen quinda ne, cha vëhë xi hacui cha. ―‍Cuatjin cafayangui me. Hane hora xi camá catsinguisehen quinda me niñu jan ne, sehe casua me cha Judas, quihndi rë Simón Iscariote. ");
INSERT INTO maqNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hane xi cavatju cafaha Judas ngu rquí niñu jan ne, hora vëhë cavisehen Satanás xahasen rë cha. Ngajan xi Jesús ne, cuitjin cachja me cojo cha: ―‍Xcusun xi nihñu ne, nihñu ni ngu ndiya xa. ―‍Cuatjin cachja Jesús cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Peru hisca ngu me xi tijinë niñu jan hvíin me mé má cuatjin cachja Jesús cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yahnga me ne, catsingataha cacun me xi tsëhë xi Judas yaha cha tsá tujún ne, vëhë xi cachja Jesús cojo cha xi cjue cuatsë cha xi mameje tsëhë suhi o sa xi sua cha tsë tsë xuta yuma. ");
INSERT INTO maqNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hane xi cavatju cafaha cha ngu rquí niñu jan ne, ngutjen ni cavetju cha quiji cha. Hora vëhë ne, ha camajñu. ");
INSERT INTO maqNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ngajan xi, xi cavetju Judas quiji cha ne, sehe cachja Jesús cuitjin: ―‍Ngahan xi Quihndi rë Xuta Jain Ngahan ne, quihndë cuetsihin cuma jyë cuma hnga ngahan cojo hasen naha, hacuaha ngahan tsingácun hacutjin jemu jyë hnga Nina cojo hasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Hane sa xi ngahan tsingácun hacutjin jemu jyë hnga Nina cojo Hasen rë me ne, Nina ne, hacuaha tsingacun me hacutjin jemu jyë hnga ngahan cojo hasen naha. Hane ngutjen ni sahmi me cuatjin. ");
INSERT INTO maqNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Jemu chúva sa nixtin xi cuitejña cojo nuju, tsan. Ngayun ne, cuinchunsun ná, peru quihndë cuichjá cojo nuju sacuatjin cachjá cojo xutaxa rë yungun xi hiscan xi cjuë́ ne, cumaji cuangun. ");
INSERT INTO maqNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nguehe cuitéxa nuju ngu cjua xatsë cuitjin: “Meje rë xi nihñu hmu tacún xingun xingu xingu ngayun. Sacuatjin casahme hmu cácun nuju ngahan, cuatjin meje rë xi nihñu hmu tacún xingun.” ");
INSERT INTO maqNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Hane xi cuatjin tjin cjuahmutacun ngajñi nuju cojo xingun ne, ngajan cumachaya rë yëjë xuta ta ngayun ne, xuta ladu naha má ngayun. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ngajan xi Simón Pedru ne, cuitjin cavinenguise me: ―‍Tatá, ¿jani cuangun ni? ―‍Cuatjin cavinenguise me. Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Hiscan xi cjuë́ ne, quihndë ne, cumaji cuanguntjengun ná. Peru xi cuma ngascan ne, cuanguntjengun ná. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Hane Pedru ne, cuitjin cachja me cojo Jesús: ―‍Tatá, tsajin mé má cumaji cjuë́ tjënguë nuju quihndë. Hisca yojo naha suá ngatsë nuju. ―‍Cuatjin cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍¿Há xi tuhun yojo nuju ngatsë naha? Cuichjá cojo nuju cjuaquixi ta chaja sa xi squihnda xahnda ne, ngayun ne, ha jyan ndiya cuinújun xi hyúun yo ngahan. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Quijinduju sa cachja Jesús cojo xuta ladu rë me cuitjin: ―‍Xicamandyaain tacún. Catamangu tacún sa cojo Nina, hacuaha catamangu tacún sa cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ngajan ngahnga hiscan tacun Nahmi naha ne, jemu cjín cahndë́ tjin xi cuiyuju yëjë xuta ladu rë me. Sa xi hacuiin cuatjin ne, ngahan ne, ha cachjá cojo nuju. Peru xicamacjiin tacún ta cjuë́ cuë́hëndaja cahndë́ xi cuma nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Hane hya xi ha cëjë cavëhë́ndaja cahndë́ xi cuma nuju ne, sehe cúya nga, hane cjuë́cojo nuju, cojo sa xi hiscan xi cuitejña ne, hacuaha ngajan cuinechun. ");
INSERT INTO maqNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hacuaha hiscan xi cjuë́ ne, ngayun ne, ha hyun ndiya. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Hane Tomás ne, cuitjin cachja me cojo Jesús: ―‍Tatá, hyíín jani cuangun. ¿Hacutjin má xi nújun xi ha hyin ndiya ni? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Hane Jesús ne, cuitjin cafayangui me tsëhë Tomás: ―‍Ngahan ne, sacuaha ndiya xi cjui xcun Nina ngahan. Ngahan ne, hatuxa tjin ná cjuaquixi rë Nina, hatuxa tjin ná cjuahñu. Suvá ni xuta xi visehen me ladu naha ne, me vëhë ni xi cuma cuechú me xcun Nina Nahmi naja. ");
INSERT INTO maqNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ngatsë rë xi ha hyun ná ne, vëhë xi hatuxa chun Nahmi naha. Quihndë ne, hyun me, hacuaha ha cachutsujun me. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ngajan xi Felipe ne, cuitjin cachja me cojo Jesús: ―‍Tatá, ningacun niji Nina Nahmi naja, hane cojo vëhë cumangu tacuín. ―‍Cuatjin cachja Felipe. ");
INSERT INTO maqNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Ngahan ne, ha jemu jyë nixtin tejña cojo nuju, hane ¿há hyúun ná ni, Felipe? Xuta xi ha cavëë ná me ne, ha cavëë me Nina Nahmi naja. ¿Hacutjin má xi nújun xi tsingácun nuju Nina Nahmi naja ni? ");
INSERT INTO maqNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Há macjaain nuju xi ngahan ne, tejñaya xahasen rë Nina Nahmi naja, hane me vëhë ne, jiya me xahasen naha? Cjua xi chjá cojo nuju ne, hacuiin chjá cojo cjuatacun naha suva. Nina Nahmi naja xi jiya me xahasen naha ne, me vëhë sahmi me xa rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Catamacjain nuju xi ngahan ne, tejñaya xahasen rë Nina Nahmi naja hacuaha me vëhë ne, jiya me xahasen naha. O sa xi macjaain nuju cjua naha ne, catamacjain nuju ngahan ndastu ngatsë rë cjuarcun xi casahme. ");
INSERT INTO maqNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cuichjá cojo nuju cjuaquixi ta xuta xi mangucacun me cojo ná ne, cjuarcun xi sahme ngahan ne, hacuaha cojo me sahmi me. Ha hisca yehe sa cjuarcun sahmi me ta, ngahan ne, cjuë́ tjënguë Nina Nahmi naja. ");
INSERT INTO maqNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Hane tu mé ni xi chjahyun rë Nina ngatsë rë xi ladu naha ngayun ne, vëhë sahme, cojo sa xi cuma jyë cuma hnga Nina Nahmi naja cojo Hasen rë me ngatsë rë xcusun xi sahme, ngahan xi Quihndi rë me ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sa xi chjahyun ná ngu cjuandaja ngatsë rë xi ladu naha ngayun ne, ngahan ne, sahme. ―‍Cuatjin cachja Jesús cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Quijinduju sa cachja Jesús cuitjin: ―‍Sa xi ngayun nihñu hmu tacún ná ne, hacuaha cuinuhyun sacuatjin vitéxa nuju, ");
INSERT INTO maqNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","hane ngahan cuichjá cojo Nina Nahmi naja, hane tsingatju me ngu nga xi cuisecoo nuju, xi cuejña cahndë́ cojo nuju yëjë nu yëjë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hane vëhë ne, vëhë Hasen xi hatuxa tjin rë cjuaquixi rë Nina. Xuta xi marcuaain rë me tsëhë Nina ne, cumaji xi cuisehen Hasen vëhë xahasen rë me ta, tsëhë xi tsijin rë me Hasen vëhë hacuaha hvíin me Hasen vëhë. Peru ngayun ne, hyun Hasen vëhë ta, tsëhë xi tacun cahndë́ cojo nuju hacuaha cuisehen xahasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Ngahan ne, hacuiin cuiyuju nuju suvun ta cúya nga cuitejñacahndë cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ha tu hitsë sa ne, ha quihndë scuiin ná xuta. Peru ngayun ne, chun ná. Hane tsëhë xi ngahan ne, hatuxa tjin ná cjuahñu ne, vëhë xi ngayun ne, hatuxa sacú nuju cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nixtin hya ne, cuijne rcun xi ngahan ne, tejñaya xahasen rë Nahmi naha, hane ngayun ne, nechunyun xahasen naha, hane ngahan ne, tejñaya xahasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","’Xuta xi tivihndë sacuatjin vitéxa ne, me vëhë xi hmu cacun ná me. Hane xuta xi cuatjin hmu cacun ná me ne, hacuaha sahmi hmu cacun Nahmi naha me. Ngahan ne, hacuaha sahme hmú cácun me, hacuaha suá cumachaya rë me yo ngahan. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, me xi hacuiin cha Judas Iscariote jan ne, cavinenguise me cuitjin: ―‍Tatá, ¿hacutjin má xi tuhun cumachaya niji yo ngayun, hane hacuiin cojo yëjë sa xuta ni? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Xuta xi hmu cacun ná me ne, hacuaha cuihndë me tsëhë cjua naha. Hane sahmi hmu cacun Nahmi naha me, hacuaha cuinduvin cuinechinyincahndin xahasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Xuta xi hacuiin hmu cacun ná me ne, vihndiin me tsëhë cjua naha. Cjua xi tinuhyun vi ne, hacuiin cjua naha suva ta cjua rë Nina Nahmi naja, me xi catsingatju ná. ");
INSERT INTO maqNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Jemu cjín cjua tichjá cojo nuju jinguyëjë rë xi tejña sa cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Peru Hasen rë Nina xi tsingatju Nina Nahmi naja xi cuejña cahndë́ naha ne, vëhë cuisecoo nuju, tsinguixi cojo nuju yëjë sa cjua xi machaja, hacuaha tsinguitsjen nuju tsëhë yëjë cjua xi ha cachjá cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Cjuandaja cjuajeya cuejñá nuju. Cjuandaja cjuajeya naha suá nuju. Peru hacuiin sacuatjin sua xuta ngasunhndë suá nuju. Xicamandyaain tacún, xicamacjiin tacún. ");
INSERT INTO maqNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ha canuhyun xi cachjá cojo nuju ta cjuë́ peru cúya nga cuinduva tjënguë nuju. Sa xi ndaja jain hmu tacún ná ne, hacuaha ndama nuju xi cjuë́ tjënguë Nina Nahmi naja ta, Nina Nahmi naja ne, hitsë sa venguichji rë me xi cuma ná ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ha cachjá cojo nuju quihndë, chaja sa xi cuetjucaa cjua vëhë, cojo sa xi hya xi cuetjucaa ne, ngayun ne, cumacjain nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ha quihndë cuichjaan sa cojo nuju cjín cjua ta, ha nduva Satanás, xi matitjun tsëhë ngasunhndë. Peru ngahan ne, tsajin mé xi cuma sahmi cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ngahan ne, sahme sacuatjin cavitexa Nina Nahmi naja, cojo sa xi yëjë xuta ne, cumachaya rë me xi hmú cácun Nina Nahmi naja. ’Nduvun ne, cuanguenxeen tsëhë nguehe. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Hacuaha cachja sa Jesús cuitjin: ―‍Ngahan ne, sacuaha nahñu naa cjuaquixi rë xca rë uva ngahan, hane Nahmi naha ne, sacuaha me xi tsicha xcatjë vëhë me. ");
INSERT INTO maqNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jima ngu nahñu tsja rë xi vaquiin tú rë ne, vatë me. Hane jima ngu nahñu tsja rë xi vaquí tú rë ne, vatëjñi me tsja langa rë, cojo sa xi cjín sa tú rë cuaquí. ");
INSERT INTO maqNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Hacuanitjin ni nuju ngayun xi sacuaha nahñu tsja rë jan ngayun ta, cjua xi cachjá cojo nuju ne, ha catsityjahi rë cjuatacun nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nihñutangun sa cjuatacun nuju cojo ná, hane ngahan ne, sahmetangun cjuatacun naha cojo nuju. Ha hyan ta nahñu tsja rë ne, cumaji sua tú rë sa xi tsajin quitahácoo cojo nahñu naa rë. Hacuanitjin ni nuju ngayun ta cumaji ninguitsujun cjuandaja rë Nina sa xi tsajin tjin tangun cjuatacun nuju cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Ngahan ne, sacuaha nahñu naa rë xca rë uva ngahan, hane ngayun ne, sacuaha nahñu tsja rë. Xuta xi tjin tangun cjuatacun rë me cojo ná hacuaha tjin tangun cjuatacun naha cojo rë me ne, me vëhë ne, jercu tsinguitsojo me cjuandaja rë Nina. Vëhë xi sa xi tsajin tjin tangun cjuatacun nuju cojo ná ne, cumaji camahani ninguitsujun cjuandaja rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Xuta xi tsajin tjin tangun cjuatacun rë me cojo ná ne, cuatju me cuma sacuatjin vatju nahñu tsja rë xca rë uva xi tijñi jan má: chandi rë, sehe xi; sehe chjaya rë cjue cueti. ");
INSERT INTO maqNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Sa xi nihñu tangun sa cjuatacun nuju cojo ná hacuaha cuiyujucahndë sa cjua naha ngajñi rë cjuatacun nuju ne, chjahyun tu mé ni xi meje nuju, hane sacú nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nahmi naha ne, ma jyë ma hnga me cojo Hasen rë me hya xi ningacun xi xuta ladu naha jain má ngayun xi ninguitsujun cjuandaja rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sacuatjin hmu cacun ná Nahmi naja ne, hacuaha cuanitjin hmú cácun nuju. Xicanichayuun cjuahmutacun naha. ");
INSERT INTO maqNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Sa xi vinuhyun tsëhë cjua xi vitéxa nuju ne, ngayun ne, hatuxa nichayuun cjuahmutacun naha, sacuatjin ná ngahan xi cavíhndë tsëhë cjua xi cavitexa ná Nahmi naha hacuaha tsichayaan cjuahmutacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Cuatjin chjá cojo nuju, cojo sa xi cjuasua xi tjin ná ne, cuejña cahntsua xahasen nuju, sehe jercu tu ndaja camahani cuma nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Vihi cjua xi vitéxa nuju: nihñu hmu tacún xingun xingu xingu ngayun, sacuatjin sahme hmú cácun nuju ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tsajin yo xi hitsë sa jyë cjuahmutacun tjin rë xi cuma rë ngu xuta xi sua me yojo rë me ngatsë rë amigu rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hane ngayun ne, amigu naha má ngayun, sa xi nihñu sacuatjin xi vitéxa nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ha quihndë cuichjaan xi hndixahan naha ngayun ta, tsëhë xi ngu mosu hndixahan ne, hvíin mé xi sahmi nai rë. Ngayun ne, amigu naha chjá tsujun ta, tsëhë xi yëjë cjua xi cáhndë xi cachja Nahmi naha ne, casuá camachaya nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Hacuiin ngayun canaxujun ná ta ngahan cavaxejen nuju. Hacuaha casuáxa nuju xi cuangun ninguitsujun cjuandaja rë Nina. Hane cjuandaja vëhë ne, tsajin nu tsajin nixtin xi cjuë. Xi cuatjin nihñu ne, tu mé ni xi chjahyun rë Nina Nahmi naja ngatsë rë xi xuta ladu naha má ngayun ne, sua nuju me. ");
INSERT INTO maqNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Vihi cjua xi vitéxa nuju: nihñu hmu tacún xingun xingu xingu ngayun. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Quijinduju sa cachja Jesús cuitjin: ―‍Sa xi choho vëë nuju xuta xi marcuaain rë tsëhë Nina ne, suá cumachaya nuju ta chaja sa xi choho scuëë nuju me ne, ngahan ne, ha choho vëë ná me. ");
INSERT INTO maqNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sa xi hacuaha xuta xi marcuaain rë tsëhë Nina má ngayun ne, xuta xi cuacun vë ne, sahmi hmu cacun nuju me ta, ngayun ne, ladu rë me ngayun. Peru tsëhë xi ngayun ne, hacuiin xuta xi marcuaain rë tsëhë Nina má ngayun ta ngahan cavaxejen nuju xi cuetjunxun tsëhë xuta xi cuacun vë, vëhë xi choho vëë nuju me. ");
INSERT INTO maqNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ninguitsjun cjua xi cachjá cojo nuju hya xi cachjá cojo nuju cuitjin: “Ngu mosu hndixahan ne, hacuiin hitsë sa venguichji rë xi cuma rë nai rë.” Sa xi catsujyihiya tjengui ná xuta cojo cjuahngatacun ne, hacuaha tsujyihiyatjengui nuju me cojo cjuahngatacun. Sa xi cahndë me tsëhë cjua naha ne, hacuaha cuihndë me tsëhë cjua nuju ngayun. ");
INSERT INTO maqNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yëjë xcusun vëhë sahmi xuta xi cuacun vë cojo nuju ngatsë naha ta, tsëhë xi hvíin me Nina, me xi catsingatju ná. ");
INSERT INTO maqNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tsajin mé jyë́ quitjen xuta xi cuacun vë sa xi canduvaan cachjá cojo rë me. Peru quihndë ne, sacuinyiin rë me mé xi cuichja me xi cuaxëtje me yojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Xuta xi choho vëë ná ngahan ne, hacuaha cojo Nahmi naha choho vëë me. ");
INSERT INTO maqNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tsajin mé jyë́ quitjen xuta xi cuacun vë sa xi casahmee ngajñi rë me cjuarcun xi tsajin sa ngu xuta xi ha casahmi me. Peru quihndë ne, ha cavëë me cjuarcun xi casahme, hane choho vëë ná me cojo Nahmi naha. ");
INSERT INTO maqNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Peru cuatjin camá cojo sa xi cuetjucaa cjua xi camahindu xcun xujun rë Nina xi chja xuta xi cuacun vë xi jemu vihndë me tsëhë, cjua xi chja cuitjin: “Choho cavëë ná me, handasa vechiin chuva rë.” Cuatjin chja cjua jan. ");
INSERT INTO maqNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Cuinduva Hasen rë Nina, xi hatuxa tjin rë cjuaquixi rë Nina, hane cuisecoo nuju. Ngahan tsingátju nuju Hasen vëhë xi cuetju hiscan tacun Nina Nahmi naja, hane xi cjuehe ne, cuichja tsahan. ");
INSERT INTO maqNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hacuaha ngayun ne, cuinújun tsahan cojo xuta, tsëhë xi ngayun ne, ha nechun cojo ná hisca ntsacu cavetsihin. ");
INSERT INTO maqNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Cuatjin tichjá cojo nuju, cojo sa xi hacuiin cuetjunxun tsëhë ndiya naha. ");
INSERT INTO maqNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Cuechú nixtin xi cumachohotje nuju yungun. Cuechú nixtin xi xuta xi tsiquehen nuju me ne, tsingataha cacun me xi jemu ndaja faharcun me Nina xi cuatjin sahmi me. ");
INSERT INTO maqNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Cuatjin sahmi me ta, tsëhë xi hvíin me Nina Nahmi naja, hacuaha vijnii rcu me yo ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Cachjá cojo nuju cjua vëhë, cojo sa xi hya xi cuechú hora xi cuetjucaa ne, ninguitsjun xi cuatjin cachjá cojo nuju. ―‍Cuatjin cachja Jesús. Quijinduju sa cachja Jesús cuitjin: ―‍Cachjaan cojo nuju cjua vëhë ntsacu cavetsihin ta, tsëhë xi ngahan ne, tejña cuaha cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Peru quihndë ne, cjuë́tjënguë me xi catsingatju ná, hane hisca ngu ngayun ne, chjinengunsuun ná jani cjuë́. ");
INSERT INTO maqNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Hane tsëhë xi cuatjin cachjá cojo nuju cjua vëhë ne, ña catsë rë xahasen nuju cjuachoho. ");
INSERT INTO maqNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Peru ngahan ne, cuichjá cojo nuju cjuaquixi ta tsujun ndaja xi cjuë́ ta, sa xi cjueen ne, Hasen xi cuisecoo nuju jan ne, hatuxa cuinduvaain. Peru sa xi cjuë́ ne, tsingátju nuju Hasen rë Nina vë. ");
INSERT INTO maqNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Hane hya xi Hasen vëhë cuinduva ne, vëhë tsinguixi xi hacuiin cuatjin xi tsingataha cacun xuta tsëhë cjuatsehen, hacuiin cuatjin xi tsingataha cacun me tsëhë cjuandaja, hacuiin cuatjin xi tsingataha cacun me tsëhë chuva rë xi cjuahachuva Nina xuta cojo cjuatacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Hacuiin cuatjin xi tsingataha cacun xuta tsëhë cjuatsehen ta, tsëhë xi manguaain cacun me cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Hacuiin cuatjin xi tsingataha cacun xuta tsëhë cjuandaja ta, tsëhë xi ngahan ne, cjuë́tjënguë Nina Nahmi naja hane ngayun ne, ha quihndë chuun ná. ");
INSERT INTO maqNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Hacuiin cuatjin xi tsingataha cacun xuta tsëhë xi cjuahachuva Nina xuta cojo cjuatacun rë me ta, tsëhë xi Satanás, xi matitjun tsëhë ngasunhndë vihi ne, ha catsichuva Nina cojo cjuatacun rë. ");
INSERT INTO maqNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Jemu tjin sa ná cjua xi cuichjá cojo nuju, peru ngayun ne, scaain nuju cuinuhyun quihndë. ");
INSERT INTO maqNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Peru hya xi cuinduva Hasen xi hatuxa tjin rë cjuaquixi rë Nina ne, vëhë cuinchandiyandaja nuju ndiya rë cjuaquixi. Hacuiin cojo cjuatacun rë suvá xi cuichja ta sacuatjin cjua xi chja Nina cojo ne, cjua vëhë cuichja. Hacuaha vëhë cuichja cojo nuju hacutjin cuma nixtin nduva. ");
INSERT INTO maqNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hasen vëhë ne, vëhë sahmi jyë sahmi hnga ná cojo cjuatacun naha ta, tsëhë xi vëhë cjuaha xi tsahan sehe sua cumachaya nuju tsahan. ");
INSERT INTO maqNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yëjë ni xi tsëhë Nina Nahmi naja ne, hacuaha tsahan. Vëhë xi cachjá xi Hasen jan ne, cjuaha xi tsahan sehe sua cumachaya nuju tsahan. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Hacuaha cachja sa Jesús cuitjin: ―‍Ha tu hitsë sa ne, ha quihndë chuun ná, hane ha tu hitsë nga sa ne, chun ná. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ngajan xi ngujo xuta ladu rë Jesús jan ne, cuitjin cachja me cojo xicjin me: ―‍¿Mé vijne cjua xi cuatjin chja me cojo naja? Chja me xi: “Ha tu hitsë sa ne, chuun ná, hane ha tu hitsë nga sa ne, chun ná”, hacuaha chja sa me xi: “Tsëhë xi cjuë́ tjënguë Nina Nahmi naja”. ");
INSERT INTO maqNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Mé vijne cjua xi “ha tu hitsë sa”? Vijnii rcuun mé xi chja me. ―‍Cuatjin cachja me cojo xicjin me. ");
INSERT INTO maqNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús ne, ha vëë me xi meje cjuinenguise xuta xi cuacun jan me tsëhë cjua vëhë, vëhë xi Jesús ne, cachja me cojo rë xuta jan cuitjin: ―‍¿Há tichjinengunsun xingun tsëhë xi cachjá xi ha tu hitsë sa ne, chuun ná hane ha tu hitsë nga sa ne, chun ná? ");
INSERT INTO maqNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cuichjá cojo nuju cjuaquixi ta ngayun ne, chjihndun hacuaha chjihndunsun, peru xuta xi marcuaain rë me tsëhë Nina ne, jercu ndaja cuma rë me. Ngayun ne, jemu choho cuma nuju, peru cjuachoho nuju ne, cuya sua. ");
INSERT INTO maqNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hya xi ngu chjuun tsin rë me quihndi ne, jemu tjin rë me cjuachoho ta, tsëhë xi cavechú hora xi cuatju me cjuañihi. Peru hya xi cavatju catsin quihndi ne, ha quihndë vitsjiin rë me tsëhë cjuañihi jan, ngatsë rë cjuasua rë me xi catsin ngu quihndi. ");
INSERT INTO maqNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Cuatjin nuju ngayun ta quihndë ne, tjin nuju cjuachoho. Peru ngahan ne, cúya scuëë nga nuju, hane ngayun ne, jemu ndaja cuma rë xahasen nuju, hane cjuasua nuju jan ne, tsajin yo cuma cjuahatahá. ");
INSERT INTO maqNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Hane nixtin hya ne, chjinengunsuun ná hisca ngu cjua. ’Cuichjá cojo nuju cjuaquixi ta tu mé ni xi chjahyun rë Nina Nahmi naja ne, sua nuju me tsëhë xi ladu naha má ngayun. ");
INSERT INTO maqNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hisca quihndë ne, cjëë chjahyun ná ngu cjuandaja tsëhë xi ladu naha má ngayun. Chjahyun ne, sehe sacú nuju, cojo sa xi xahasen nuju ne, tsë rë cjuasua. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Quijinduju sa cachja Jesús cuitjin: ―‍Ngahan ne, cojo ejemplu cachjá cojo nuju. Peru cuechú nixtin xi ha quihndë hacuiin cojo ejemplu cuichjá cojo nuju ta cuichjáquixë cojo nuju tsëhë Nina Nahmi naja. ");
INSERT INTO maqNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nixtin hya ne, hatuxa chjahyun cjuandaja tsëhë xi ladu naha má ngayun. Hane chjaan cojo nuju xi cuichjá ngatsë nuju cojo Nina Nahmi naja ta, ");
INSERT INTO maqNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","suvá Nina Nahmi naja ne, jemu meje rë me ngayun, tsëhë xi ngayun ne, hacuaha jemu meje nuju ngahan hacuaha macjain nuju xi ngahan ne, Nina catsingatju ná me. ");
INSERT INTO maqNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ngahan ne, hiscan tacun Nina cavétju canduvá nguehe ngasunhndë. Quihndë ne, cuétju tsëhë ngasunhndë, cúya cjuë́tjënguë Nina Nahmi naja. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ngajan xi xuta ladu rë Jesús ne, cuitjin cachja me: ―‍Chutsujun ni. Quihndë ne, hacuiin cojo ejemplu tinújun ta tinújunquixun. ");
INSERT INTO maqNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Quihndë ne, hyin ta ngayun ne, hyun yëjë ni cjuatacun, hacuaha hacuiin sahmi ngujyë xi cjuinenguise nuju xuta ngu cjua cojo sa xi cumachaya nuju mé xi tsingataha cacun xuta jan. Ngatsë rë vëhë xi macjain niji xi Nina catsingatju nuju me. ―‍Cuatjin cachaja xuta ladu rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍¿Há macjain jain nuju quihndë? ");
INSERT INTO maqNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Chutsujun ni. Cuechú hora o ha hisca cavechú xi cuitsojo ngayun, jima ngu ngayun cojo ndya nuju, hane cuejñu ná suva. Peru ngahan ne, hacuiin suva tejña ta Nina Nahmi naja tacun me cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Cuatjin chjá cojo nuju cojo sa xi sacú nuju cjuandaja cjuajeya ngatsë rë xi tjin tangun cjuatacun nuju cojo ná. Nguehe ngasunhndë ne, vatjun cjuañihi. Peru tuhun cjuasua xahasen nuju ta, ngahan ne, hacuaha cacaa ná catsinguíjne cjuatsehen rë ngasunhndë. ―‍Cuatjin cachja Jesús cojo xuta ladu rë me jan. ");
INSERT INTO maqNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Xi cavatju cachja Jesús cuatjin ne, sehe cavutsejenniji me ngahnga, hane cachja me cuitjin: ―‍Ngayun Nahmi naha, ha cavechú hora. Nihñu jyë nihñu hnga ná cojo Hasen naha ngahan xi Quihndi nuju ngahan, cojo sa xi ngahan ne, hacuaha sahme jyë sahme hnga nuju cojo Hasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ngayun catuhunxun ná xi matitjun ngahan tsëhë yëjë xuta, cojo sa xi yëjë me xi catuhun ná ne, suá rë me cjuahñu xatsë. ");
INSERT INTO maqNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hane cuitjin xi sacú rë me cjuahñu xatsë, xi vëë me ngayun, ngayun xi ngu ni ngayun xi Nina xi cjuaquixi ngayun, hacuaha xi vëë ná me, ngahan xi Jesucristu ngahan, ngahan xi ngayun caningatjun ná. ");
INSERT INTO maqNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ngahan ne, casahme jyë casahme hnga nuju nguehe ngasunhndë ta, catsinguíjnetaha xa xi catuhun ná xi sahme. ");
INSERT INTO maqNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Quihndë ne, nihñu jyë nihñu hnga ná cojo Hasen naha ndyá hiscan nechun, ngayun Nahmi naha. Tuhun ná Hasen ndajyihi xi ha tjin ná hya xi nechan tangun cojo nuju hisca hya xi chaja sa cuejña ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ngahan ne, casuá camachaya rë xuta xi catuhun ná nguehe ngasunhndë yo ngayun. Me xi cuacun vë ne, tsujun me, peru catuhun ná me. Hane cahndë me tsëhë cjua nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ha vëë me quihndë xi yëjë ni xcusun xi catuhun ná ne, ngayun caningatjun. ");
INSERT INTO maqNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Cuatjin vëë me ta, tsëhë xi yëjë ni cjua xi catuhun ná ne, hacuaha casuá rë me. Hane me xi cuacun vë ne, cafahatsja me cjua vëhë, hacuaha vëëndaja me xi hiscan nechun cavétju canduvá nguehe, hacuaha macjain rë me xi ngayun caningatjun ná. ");
INSERT INTO maqNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ngahan ne, tichjá cojo nuju ngatsë rë me xi cuacun vë. Tichjaan ngatsë rë xuta xi marcuaain rë tsujun ta tichjá ngatsë rë me xi catuhun ná, tsëhë xi tsujun me. ");
INSERT INTO maqNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yëjë ni xi tsahan ne, hacuaha tsujun, hane xi tsujun ne, hacuaha tsahan. Hane ngahan ne, cama jyë cama hnga ngahan cojo Hasen naha ngatsë rë xi tjin tangun cjuatacun rë me xi cuacun vë cojo ná. ");
INSERT INTO maqNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ha quihndë cuitejñaa sa nguehe ngasunhndë. Me xi cuacun vë ne, siu me ngasunhndë, peru ngahan ne, cuinduvatjënguë nuju. Ngayun Nahmi naha, ngayun xi hatuxa tyjahi cjuatacun nuju ne, nihñu me cuidadu cojo ngahñu nuju, ngahñu xi catuhun ná, cojo sa xi tjin tangun cjuatacun rë me cojo xicjin me, sacuatjin naja ngayaan. ");
INSERT INTO maqNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Hya xi tejña cojo rë me ne, casahme cuidadu me cojo ngahñu nuju xi catuhun ná. Casahme cuidadu me, hane hisca ngu me cachajin me. Suvá ni cha xi hatuxa chajá ne, cha vëhë xi cachajá cha, cojo sa xi cuetjucaa cjua xi camahindu xcun xujun nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Peru quihndë ne, cuinduvatjënguë nuju. Hane tichjá cjua vihi nguehe ngasunhndë, cojo sa xi xuta ladu naha ne, tsë́ rë xahasen rë me cojo cjuasua xi quitsë rë xahasen naha suva. ");
INSERT INTO maqNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ngahan ne, casuá camachaya rë me cjua nuju. Hane xuta ngasunhndë xi marcuaain rë tsujun ne, choho vëë rë me, tsëhë xi hacuiin tsëhë ngasunhndë má me, sacuatjin ná ngahan xi hacuiin tsëhë ngasunhndë má ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Cjuehyaan nuju xi naxunxun me tsëhë ngasunhndë ta tiféhya nuju xi nihñu me cuidadu tsëhë Satanás. ");
INSERT INTO maqNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Xuta ladu naha jan ne, hacuiin tsëhë ngasunhndë má me, sacuatjin ná ngahan xi hacuiin tsëhë ngasunhndë má ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nihñu tsujun jain me cojo cjua xi hatuxa cjuaquixi. Cjua nuju ne, vëhë xi hmí rë cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sacuatjin caningatjun ná ngahan ngajñi rë xuta xi marcuaain rë tsujun ne, hacuaha cuatjin catsingátju xuta ladu naha ngajñi rë xuta xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Hane ngatsë rë xuta ladu naha ne, suá nuju yojo naha, cojo sa xi me xi cuacun vë ne, hacuaha tsujun jain cuma me cojo cjuaquixi. ");
INSERT INTO maqNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Quihndë ne, hacuiin ngatsë rë suvá ni xuta ladu naha vi xi tichjá cojo nuju ta hacuaha cojo ngatsë rë me xi sehe cumangu cacun cojo ná xi cuihndë me cjua xi chja xuta ladu naha tsahan. ");
INSERT INTO maqNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ngahan ne, xi meje ná ne, xi yëjë ni me xi cuacun vë ne, cuma tangun cjuatacun rë me cojo xicjin me. Sacuatjin nuju ngayun, Nahmi naha, xi nechunyun xahasen naha hane ngahan ne, tejñaya xahasen nuju ne, meje ná xi me xi cuacun vë ne, hacuaha hincha me xahasen naja, cojo sa xi xuta ngasunhndë ne, cumacjain rë me xi ngayun caningatjun ná. ");
INSERT INTO maqNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ngahan ne, casahme yehe casahme hnga me cojo cjuatacun rë me sacuatjin canihñu jyë canihñu hnga ná ngahan cojo cjuatacun naha, cojo sa xi cuma tangun cjuatacun rë me cojo xicjin me, sacuatjin tjin tangun cjuatacun naja ngayaan cojo xingueen. ");
INSERT INTO maqNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Meje ná xi ngahan ne, cuitejñaya xahasen rë me, sacuatjin nechunyun xahasen naha. Meje ná xi cuma tangun camahani cjuatacun rë me cojo xicjin me, cojo sa xi xuta ngasunhndë ne, cuijne rcu me xi ngayun caningatjun ná, hacuaha xi nihñu hmu tacún me sacuatjin nihñu hmu tacún ná ngahan. ");
INSERT INTO maqNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Ngayun, Nahmi naha, xuta xi catuhun me xi cuma me ladu naha ne, meje ná xi hiscan xi cuitejña ne, hacuaha ngajan cuiyuju me cojo ná, cojo sa xi scutsejen me hacutjin jyë hnga ngahan cojo hasen ndajyihi naha xi ngayun catuhun ná, tsëhë xi canihñu hmu tacún ná hisca chaja sa xi cuejña ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ngayun Nahmi naha, ngayun xi quixi ngayun cojo cjuatacun nuju, xuta ngasunhndë ne, hvíin nuju me, peru ngahan ne, hvë nuju, hane xuta ladu naha vi ne, vëë me xi ngayun caningatjun ná. ");
INSERT INTO maqNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ngahan casuá camachaya rë me yo ngayun, hane suá sa cumachaya rë me, cojo sa xi cjuahmutacun xi tjin nuju cojo ná ne, cuejña cahntsua xahasen rë me hacuaha ngahan ne, cuitejña cahntsua xahasen rë me. ―‍Cuatjin cafehya Jesús cjuandaja cojo Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Hya xi camá ne, xi cavatju cachja Jesús cjua vëhë ne, sehe cavetju me quiji me cojo xuta ladu rë me ngunda vëhë tsëhë caniña Cedrón. Hane ngajan cavisehen Jesús cojo xuta ladu rë me ngu ngajñi yatjë xi tjin jan. ");
INSERT INTO maqNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Quihndë ne, cha Judas, cha xi sahmi rë entregadu Jesús ne, hacuaha vëë cha cahndë́ vëhë ta, jemu quiji Jesús cahndë́ vëhë camatangun me cojo xuta ladu rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ngajan xi cha Judas ne, quijicojo cha ngujo sindadu cojo cha mayu cojo cha nisë rë cha, cha xi catsingatju nahmi xi matitjun cojo cha fariseo. Quiji cha xi cuacun jan ngajan cojo ndihi cojo quicha. ");
INSERT INTO maqNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Hane Jesús ne, tsëhë xi ha vëë me yëjë xcusun xi cuatju me cuma ne, quijivaha me xcun cha xi cuacun jan, sehe cavinenguise me cha cuitjin: ―‍¿Yo xi meje nuju? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ngajan xi cha xi cuacun jan ne, cuitjin cafayangui cha: ―‍Xuta Nasaret xi hmí rë Jesús. ―‍Cuatjin cafayangui cha. Hane Jesús ne, cuitjin cachja me: ―‍Ngahan xi nújun vë. ―‍Cuatjin cachja me. Quihndë ne, Judas, cha xi sahmi rë me entregadu ne, cojo cha secun cha cojo cha xi cuacun vë. ");
INSERT INTO maqNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hane hya xi cachja Jesús xi: “Ngahan xi nújun vë” ne, quijingaxtun yëjë cha xi cuacun jan, hane caticja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ngajan xi Jesús ne, cavinenguise nga me cha cuitjin: ―‍¿Yo xi meje nuju? ―‍Cuatjin cavinenguise me. Hane cha xi cuacun jan ne, cuitjin cachja nga cha: ―‍Xuta Nasaret xi hmí rë Jesús. ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Hane Jesús ne, cuitjin cafayangui me: ―‍Ha cachjá cojo nuju ta ngahan xi nújun vë. Sa xi ngahan meje nuju ngahan ne, tuhun cahndë́ catje me xi cuicun vi. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Cuatjin cachja Jesús cjua vëhë cojo sa xi cuetjucaa cjua xi ha cachja me cuitjin: “Xuta xi catuhun ná me ne, hisca ngu me catsichajan me.” ");
INSERT INTO maqNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ngajan xi Simón Pedru ne, cavaxë me quichandujú xi yaha me, hane cavatësun me tyjavañuju quixi mosu hndixahan rë nahmi xi matitjun jan, cha xi hmí rë Malco. ");
INSERT INTO maqNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ngajan xi Jesús ne, cuitjin cachja me cojo Pedru: ―‍Teyunndujun quicha nuju vë. Hatuxa tsingatehen xi cuátju cjuañihi sacuatjin xi meje rë Nina Nahmi naja. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hya xi camá ne, cha sindadu cojo capitán rë cha, cojo mayu cojo cha nisë rë cha, cha xi catsingatju xutaxa rë yungun jan ne, cafaha cha Jesús, catsihñu cha me, ");
INSERT INTO maqNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sehe quiji cani cha me titjun xcun Anás. Anás vë ne, nahmichahya rë Caifás má me. Hane nu vëhë ne, nahmi xi matitjun tsëhë yëjë ni nahmi má Caifás. ");
INSERT INTO maqNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Quihndë ne, Caifás vë ne, me vëhë xi cavinchangui me xutaxa rë xi ndaja tsëhë xutaxa rë xi ngu xihin ni cueya ngatsë rë yëjë ni xuta. ");
INSERT INTO maqNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Quihndë ne, Simón Pedru cojo ngu sa cha ladu rë Jesús jan ne, tjengui me quiji me cojo Jesús. Hane cha ladu rë Jesús xingu jan ne, tsëhë xi vëë nahmi xi matitjun jan cha ne, cojo cha cavisehen cha cojo Jesús cahntsua hnchua ndatsen ndava nahmi xi matitjun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peru Pedru ne, casecun ni me ngajan candatsen tingotjo hnchua jan. Ngajan xi cha ladu rë Jesús xi vëë nahmi jan ne, cavetju nga cha quiji cachja cha cojo na xi quitahá cuidadu rë tingotjo hnchua jan. Hane sehe catsinguisehen cha Pedru cahntsua hnchua. ");
INSERT INTO maqNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Hane na xi sahmi cuidadu tingotjo hnchua jan ne, cuitjin cavinenguise rë na Pedru: ―‍¿Hacuiin cojo ngayun má ngayun ladu rë me xi cuajyihi vë? ―‍Cuatjin cavinenguise na. Hane Pedru ne, cuitjin cafayangui me: ―‍Jéya, hacuiin. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hane mosu rë nahmi jan cojo cha sindadu jan ne, cavejña cha ngu ndava ndihi, tsëhë xi jemu hnchan. Sehe hinchacun cha tijima hasu rë cha jan. Hacuaha cojo Pedru secun me jan, jima hasu rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Hane xi cafehe cha xi cuacun jan cojo Jesús jan ne, sehe cavetsihin cafahatáha nahmi xi matitjun jan me tsëhë xuta ladu rë me cojo tsëhë cjuachacun rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Hane Jesús ne, cuitjin cafayangui me: ―‍Ngahan ne, xcun cojo xcun cachjá cojo yëjë ni xuta, hacuaha cavicuyá rë me ngajan yungun langa o sa xi ngajan yungun xi matitjun, hiscan xi matangun ngayejen ni xuta tjë rë Israel. Tsajin mé xi cachjá xi táhahma. ");
INSERT INTO maqNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Hane ¿mé má ngahan chjuhuntuhun ná ni? Chjuhuntuhun rë me xi cahndë cjua naha. Chjinengunsun rë me mé xi cachjá cojo rë me. Me xi cuacun vë ne, vëë me cjua xi cachjá. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hane xi cuatjin cachja Jesús cjua vëhë ne, ngu cha mayu xi secun tiña jan ne, cavajaya cha ngu xcun Jesús, sehe cachja cha cuitjin cojo rë me: ―‍¿Há cuatjin chjayengui tsëhë nahmi xi matitjun? ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ngajan xi Jesús ne, cuitjin cafayangui me tsëhë cha: ―‍Sa xi choho cachjá ne, tinújun cojo yëjë xuta mé xi choho cachjá. Peru sa xi ndaja cachjá ne, ¿mé má cuatjin vujun ná ni? ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ngajan xi Anás ne, hacuanitjin ni tjihñu cuaha Jesús ne, catsingatju me Jesús xcun nahmi xi matitjun tsëhë yëjë ni nahmi. ");
INSERT INTO maqNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jinguyëjë rë xi tichjahátáha rë Jesús jan ne, Pedru ne, secun me xcun ndihi tijima hasu rë me. Hane cachjahátáha rë me cuitjin: ―‍¿Hacuiin cojo ngayun má ngayun ladu rë me vëhë? ―‍Cuatjin cachjahátáha rë me. Hane Pedru ne, cavetsangui me, cuitjin cachja me: ―‍Jéya, hacuiin. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ngajan xi ngu mosu rë nahmi xi matitjun jan, cha xi xicjin rë cha xi cavatësun Pedru tyjavañuju jan ne, cuitjin cachja cha cojo Pedru: ―‍¿Há cahveen nuju cojo rë me ngajñi yatjë jan ni? ―‍Cuatjin cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Cavetsangui nga Pedru ngu ndiya. Hane ha hora vëhë ni ne, cajihnda xahnda. ");
INSERT INTO maqNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ngajan xi xuta matitjun tsëhë xuta tjë rë Israel jan ne, cavaxë me Jesús tsëhë ndava Caifás, hane quijicojo me ndihya jyë hiscan tacun Pilatu, xutaxa rë xi matitjun. Nguitajñu xati hora vëhë. Hane xuta xi quijicojo rë Jesús jan ne, cavisiin me cahntsua ndihya jyë jan, ngatsë rë xcusun rë me xi ma chocun yojo rë me xcun Nina hya xi visehen me ndava xutaxín. Hane sa xi cuatjin cuma chocun yojo rë me ne, cumaji sinë nguixun me comida suhi tsëhë Pascua. ");
INSERT INTO maqNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Vëhë xi cavetju Pilatu quijitjengui rë me candatsen. Hane cuitjin cavinenguise me: ―‍¿Mé jyë́ vinchun tsëhë cha xi cuijyihi vi? ―‍Cuatjin cavinenguise Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hane xuta xi cuacun jan ne, cuitjin cafayangui me: ―‍Sa xi hacuiin choho tisahmi cha ne, canduvinchanii nuju cha. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hane Pilatu ne, cuitjin cachja me: ―‍Chjuhun cha ne, chjuhunchuvun suvun cha cojo jyë́ rë cha sacuatjin chja ley nuju. ―‍Cuatjin cachja Pilatu. Ngajan xi xutaxa rë yungun xi cuacun jan ne, cuitjin cachja me: ―‍Ley nuju ngayun ne, chja ta ngayin ne, cumaji niquihin xuta. ―‍Cuatjin cachja xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Cuatjin camá cojo sa xi cuetjucaa cjua xi cachja Jesús hya xi cachja me mé chuva rë cueya me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ngajan xi Pilatu ne, cavuya cavisehen nga me ndihya. Hane cajindaya me Jesús, sehe cavinenguise me cuitjin: ―‍¿Há ngaye xu matitjun ngaye tsëhë xuta tjë rë Israel? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Hane Jesús ne, cuitjin cafayangui me: ―‍¿Há cojo cjuatacun nuju suvun chjinengunsun ná cjua vëhë?, o há tsajin ne, ¿há tjin yo cachja cojo nuju tsahan? ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ngajan xi Pilatu ne, cuitjin cafayangui me: ―‍¡Peru ngahan ne, hacuiin xuta Israel ngahan! Suvá xuta nangui riji cojo nahmi xi matitjun casahmi ri me entregadu cojo ná. ¿Mé canihñi? ―‍Cuatjin cafayangui Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ngajan xi Jesús ne, cuitjin cafayangui me: ―‍Xa naha xi sahme gubiernu ne, hacuiin ngasunhndë vihi cafahántsa. Sa xi ngasunhndë vihi cafahántsa xa xi sahme gubiernu ne, xuta ladu naha ne, scaan me cojo sa xi cumaji cuma ngahan entregadu tsja xutaxa rë yungun. Peru xa naha xi sahme gubiernu ne, hacuiin nguehe cafahántsa. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hane Pilatu ne, cuitjin cachja me cojo Jesús: ―‍¿Ngajan xi ngaye xi matitjun ngaye ni? ―‍Cuatjin cachja me. Hane Jesús ne, cuitjin cafayangui me: ―‍Cuatjin sacuatjin nújun vë. Ngahan ne, canduvá nguehe ngasunhndë hacuaha catsin ngahan cojo sa xi cuichjá cojo xuta cjua xi cjuaquixi. Yëjë xuta xi marcun rë me tsëhë cjuaquixi ne, hatuxa vetaharcu me cjua naha. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Hane Pilatu ne, cuitjin cachja me: ―‍¿Mé xi hmí rë cjuaquixi ni? ―‍Cuatjin cachja Pilatu. Hane xi cafë cachja Pilatu cjua vëhë ne, sehe cavetju nga me quiji cachja me cojo xutaxa rë yungun, cuitjin cachja me: ―‍Sacuiin ná hisca ngu jyë́ rë cha xi cuajyihi vë. ");
INSERT INTO maqNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Peru ngayun ne, tjin nuju ngu xcusun xi tsisme ngu presu nixtin rë suhi rë Pascua. ¿Há meje nuju xi tsisme me xi matitjun tsujun? ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hane xuta xi cuacun jan ne, cajindaya me cachja me cuitjin: ―‍¡Hacuiin cha vëhë ta Barrabás nismu cha! ―‍Cuatjin cajindaya me cachja me. Quihndë ne, Barrabás jan ne, ngu cha fahataha cjuachan cha. ");
INSERT INTO maqNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ngajan xi Pilatu ne, catsingatju me Jesús casehen rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Hane cha sindadu xi cuacun jan ne, xi camá catsihya cha ngu corona nahyá ne, sehe cavesun cha rcu Jesús, hacuaha catsicaja cha me ngu tsjian moradu. ");
INSERT INTO maqNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Hya xi camá ne, quijivaha cha jima ngu cha xcun me, sehe cavetsihin cavincha cha viva rë me xi tsixcuehyu cha me sacuaha xi me vëhë matitjun me tsëhë xuta tjë rë Israel. Hacuaha cavajaya cha xcun me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Hya xi camá ne, Pilatu ne, cavetju nga me candatsen, hane cuitjin cachja me cojo xuta xi cuacun jan: ―‍Chutsujun ni, cuáxë cha nguehe, cojo sa xi cumachaya nuju ta sacuiin ná hisca ngu jyë́ rë cha. ―‍Cuatjin cachja Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ngajan xi Jesús ne, cavetju me candatsen, quisun rcu me corona nahyá hacuaha yaja me tsjian moradu jan. Sehe cachja Pilatu cojo xuta cuitjin: ―‍Chutsujun ni, cuajyihi cha nguehe. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hane hya xi cavëë nahmi xi cuacun matitjun jan cojo cha mayu cojo nisë rë cha Jesús ne, cajindaya cha cachja cha cuitjin: ―‍¡Tetuhun cha xcun cru! ¡Tetuhun cha xcun cru! ―‍Cuatjin cajindaya cha cachja cha. Ngajan xi Pilatu ne, cuitjin cachja me: ―‍¡Chjuhun suvun cha, tetuhun cha xcun cru ta, ngahan ne, sacuiin ná hisca ngu jyë́ rë cha! ―‍Cuatjin cachja Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ngajan xi xutaxa rë xi cuacun jan ne, cuitjin cachja me: ―‍Ngayin ne, tjin ngu ley xi vitexa niji, hane sacuatjin chja ley vëhë ne, vechú chuva rë xi cueya cha ta, tsëhë xi cachja suvá cha xi Quihndi rë Nina cha. ―‍Cuatjin cachja xutaxa rë jan. ");
INSERT INTO maqNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hane xi cahndë Pilatu cjua vëhë ne, hitsë sa catsacjun me camá. ");
INSERT INTO maqNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sehe cavuya cavisehen nga me cahntsua ndihya, hane sehe cafahatáha me Jesús cuitjin: ―‍Ngayun ne, ¿jani canduvun? ―‍Cuatjin cafahatáha me Jesús. Peru Jesús ne, cafayanguiin me tsëhë Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ngajan xi Pilatu ne, cuitjin cavinenguise me cojo Jesús: ―‍¿Há chayunnguun tsahan? ¿Há hyúun ta ngahan ne, cuma tsisme nuju hacuaha cuma cuitéxa xi setaha ngayun xcun cru? ―‍Cuatjin cavinenguise Pilatu. ");
INSERT INTO maqNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Hane Jesús ne, cuitjin cafayangui me: ―‍Ngayun ne, cuma nihñu cojo ná cuatjin, peru suvá ni ngatsë rë xi Nina casua nuju me cahndë́. Vëhë xi me xi casahmi ná entregadu cojo nuju ne, hitsë sa jyë jyë́ rë me xi cuma nuju ngayun. ―‍Cuatjin cafayangui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Xi cahndë Pilatu cjua vëhë ne, cavangui me chuva rë xi tsismi me Jesús. Peru xutacjín jan ne, cajindaya me cachja me cuitjin: ―‍Sa xi nismu cha xi cuajyihi vë ne, hacuiin amigu rë César, me xi matitjun camahani, má ngayun. Ngu xuta xi chja suvá me xi matitjun me ne, hatuxa condra rë César má me. ―‍Cuatjin cajindaya me cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hane xi cahndë Pilatu cjua vëhë ne, sehe cavaxë nga me Jesús candatsen, sehe quiji me cavéjña me hiscan sahmi cuenda me jyë́ rë xuta, cahndë́ hiscan hmí rë Texondaja rë, hane xi hne hebreo ne, Gabata hmí rë. ");
INSERT INTO maqNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hora vëhë ne, sacuaha nchisen tsëhë nixtin vispra rë suhi tsëhë Pascua. Ngajan xi Pilatu ne, cuitjin cachja me cojo xuta: ―‍¡Chutsujun ni, cuajyihi me xi matitjun tsujun nguehe! ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Hane xuta jan ne, cuitjin cajindaya me cachja me: ―‍¡Naxunxun cha, naxunxun cha tsëhë nguehe! ¡Tetuhun cha xcun cru! ―‍Cuatjin cajindaya me cachja me. Ngajan xi Pilatu ne, cuitjin cavinenguise me: ―‍¿Há cuétaha me xi matitjun tsujun xcun cru ni? ―‍Cuatjin cavinenguise me. Ngajan xi nahmi xi cuacun matitjun jan ne, cuitjin cafayangui me: ―‍¡Ngu ni César, me vëhë xi matitjun me tsijin! ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ngajan xi Pilatu ne, cajne cacun me. Hane casahmi me entregadu Jesús xi cjue setaha me xcun cru xi cueya me. Sehe cafahatsja xuta xi cuacun jan me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Hya xi camá ne, quisuntyja suvá Jesús cru, cavetju me quiji me cojo xuta cahndë́ hiscan xi hmí rë Nínda Rcuun, hane xi hne hebreo ne, Gólgota hmí rë. ");
INSERT INTO maqNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hane ngajan casetaha me xcun cru. Hacuaha cojo sa jo cha caviyujutaha cha xcun cru rë cha, ngu ngu cha ngu ngu ladu tjehen rë me. Hane Jesús ne, cavasen caseya me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Hacuaha catsihindu Pilatu ngujo cjua xi casetaha rcu cru rë Jesús, cuitjin camahindu: “Jesús, Xuta Nasaret, Xi Matitjun Tsëhë Xuta Israel.” ");
INSERT INTO maqNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Cjua vëhë ne, jemu cjín xuta cavutaya me, tsëhë xi cahndë́ hiscan casetaha Jesús xcun cru ne, tiña tacun nandya. Camahindu cjua vëhë cojo hne hebreo cojo latín cojo griego. ");
INSERT INTO maqNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ngajan xi nahmi xi matitjun tsëhë xuta tjë rë Israel jan ne, cuitjin cachja me cojo Pilatu: ―‍Ndajintjin xi cuatjin canihindun “Xi Matitjun Tsëhë Xuta Israel” ta, xi ndatjin ne, “Cachja Cha: Ngahan Matitjun Ngahan Tsëhë Xuta Israel.” ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Hane Pilatu ne, cuitjin cafayangui me: ―‍Ha catsihindu cjua xi meje tsihindu. ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ngajan xi sindadu jan ne, xi cavatju cavetaha cha Jesús xcun cru ne, sehe cafaha cha tsjian xcun rë me cojo yëjë sa xi tsë́ xi xtí xi sahmixa cojo me, cavatëcja cha ngajñi catsiñuju cha. Hacuaha cafaha cha tsjian ngahma rë me. Quihndë ne, tsjian vëhë ne, hacuiin casehencoo ta tsjian tu të ni. ");
INSERT INTO maqNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ngajan xi cha sindadu jan ne, cachja cha cojo xicjin cha cuitjin: ―‍Tsjian vëhë ne, hacuiin cuichan ta naxeen suerte tsëhë ne, jarë ngayaan xi satë naja. ―‍Cuatjin cachja cha. Cuatjin camá cojo sa xi cuetjucaa cjua xi camahindu xcun xujun rë Nina xi chja cuitjin: Cavatëcja cha tsjian naha ngajñi rë cha, hacuaha cavaxë cha suerte ngatsë rë tsjian naha. Cuatjin casahmi cha sindadu jan. ");
INSERT INTO maqNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Quihndë ne, tiña cru rë Jesús jan ne, secun naa rë me, cojo tíchja naa rë me, cojo na María chjuun rë Cleofas, cojo na María na Mágdala. ");
INSERT INTO maqNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Hane xi cavëë Jesús naa rë me cojo cha ladu rë me xi jemu vinga rë me jan xi secun tangun cha cojo naa rë me ne, sehe cachja me cuitjin cojo naa rë me: ―‍Ngayun chjuun, cuajyihi quihndi nuju ndyá. ");
INSERT INTO maqNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hane cha ladu rë me jan ne, cuitjin cachja me cojo rë cha: ―‍Cuajyihi naa nuju ndyá. ―‍Cuatjin cachja Jesús. Ha nixtin hya ni ne, quijicojo cha ladu rë Jesús jan naa rë me ndava cha, ngajan cavéjñacahndë me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hane xi camá ngascan ne, Jesús ne, ha vëë me xi camachihin yëjë xa xi cachja Nina xi sahmi me. Hane cojo sa xi cuetjucaa cjua xi camahindu xcun xujun rë Nina ne, cuitjin cachja me: ―‍Jemu xinda ná. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Quihndë ne, tacun jan ngu hiscan jemu hincha xan yufa. Ngajan xi sindadu jan ne, catsicahnchi cha ngu tsjian hinda cojo xan jan ne, sehe catsitjinguiya cha rcu ngu ya nduju, sehe catsiquijin cha cavetaha cha hntsua Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Hane xi camá cahvi Jesús xan jan ne, sehe cachja me cuitjin: ―‍Camachihin quihndë. ―‍Cuatjin cachja Jesús. Hane xi catsiquindi me rcu me ne, hora vëhë cahme me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Hya xi camá ne, xutaxa rë yungun ne, cafehya me favor cojo Pilatu xi cuitexa me ne, xtotoho ntsacu me xi caviyujutaha xcun cru rë jan, sehe chjaháxin rë nima. Cuatjin cafehya me ta, tsëhë xi nixtin hya ne, vispra tsëhë suhi, hane mijí rë me xi cuiyujutaha nima xcun cru rë hisca cuma nchujun, tsëhë xi, xi cuma nchujun jan ne, nixtin chjahájenda rë hacuaha jemu nixtin jyë. ");
INSERT INTO maqNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ngajan xi sindadu jan ne, quiji cavotoho cha ntsacu catsijo ni cha xi hacuaha cojo caviyujutaha xcun cru rë cojo Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Peru xi cafehe cha xcun cru rë Jesús ne, xi cavëë cha xi ha cahme me ne, cavotaain cha ntsacu me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Peru ngu cha sindadu jan ne, quiji cavitengui cha quicha ngu ladu ntsacu ndanisin rë Jesús, hane ngutjen ni cavetju jni cojo nandá. ");
INSERT INTO maqNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Cha xi cavëë ne, chja cha tsëhë xcusun vëhë, cojo sa xi ngayujun ni ngayun ne, cumacjain nuju. Cjua xi chja cha ne, cjuaquixi, hacuaha cha vëhë ne, vëë cha ta cjuaquixi cjua xi chja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Cuatjin camá xcusun vëhë, cojo sa xi cuetjucaa cjua xi chja xujun rë Nina xi chja cuitjin: “Hisca ngu nínda rë me xtotaain.” ");
INSERT INTO maqNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Hacuaha chja nga ngu cahndë́ xujun rë Nina cuitjin: “Scuëë xuta me xi caxtengui rë quicha.” Cuatjin chja xujun rë Nina. ");
INSERT INTO maqNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Xi cavatju xcusun vëhë ne, José, ngu xuta Arimatea ne, cafehya me cahndë́ cojo Pilatu xi cjuahaxin me nima Jesús. José jan ne, hacuaha xuta ladu rë Jesús má me, handasa catsingacuiin me xi xcun cojo xcun, tsëhë xi tsacjun me xutaxa rë yungun. Hane Pilatu ne, casua me cahndë́. Hya xi camá ne, quiji cafahaxin José nima. ");
INSERT INTO maqNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo, me xi quiji cavisiajmi cojo Jesús ngu nguixun jan ne, hacuaha cojo me quiji me cojo José. Yaha me sacuaha cantë kilu aceite xi jemu ndaja jne xi cuëhëchjine me yojo rë nima jan. ");
INSERT INTO maqNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ngajan xi, xi cafaha me nima jan ne, sehe cavitejnu rë me aceite hacuaha catsitjingui rë me tsjian, sacuatjin xcusun rë xuta tjë rë Israel hya xi vinchaniji me nima rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Quihndë ne, tiña hiscan cavetaha xuta Jesús xcun cru xi catsiquehen me ne, tjin ngu ngajñi yatjë. Hane ngajñi yatjë jan ne, tacun ngu tsjun xatsë, xi hisca ngu nima cjëë seya. ");
INSERT INTO maqNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ngajan ni caveya me nima Jesús, tsëhë xi ngajan xi tiña, hacuaha ha vispra tsëhë suhi nixtin hya. ");
INSERT INTO maqNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Quihndë ne, nixtin xi tjun tjun tsëhë totje jan ne, na María na Mágdala jan ne, nguitajñu jñu sa ne, cavetju na quiji na xcun tsjun rë nima Jesús. Hane xi cafehe na jan ne, cavëë na xi ndyojo xi quitahá tingotjo rë tsjun jan ne, cachjaháxin rë. ");
INSERT INTO maqNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ngajan xi vangasanii na quiji na hiscan tacun Simón Pedru cojo cha ladu rë Jesús xingu jan, cha xi jemu vinga rë Jesús. Hane xi cafehe na jan ne, cuitjin cachja na: ―‍Cavaxë me nima Nai naja tsëhë tsjun rë, hane hyaan jani quiji chani rë. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ngajan xi Pedru cojo cha xingu jan ne, cavetjusanii me, quiji me xcun tsjun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Vanga me catsijo me quiji me, peru cha xingu jan ne, hitsë sa hñu cavanga cha xi cuma rë Pedru, hane tjun cha vëhë cafehe cha xcun tsjun. ");
INSERT INTO maqNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hane xi cafehe cha jan ne, catsiquindi cha yojo rë cha, hane cavëë cha tsjian xi cavitjingui rë nima Jesús, siu jan. Peru cavisiin cha. ");
INSERT INTO maqNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Hane xi cafehe Simón Pedru xi camá ngascan ne, cavisehen me cahntsua tsjun jan. Hane cavëë me tsjian jan siu, ");
INSERT INTO maqNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","hane pañutu xi camahñu rcu nima jan ne, hacuiin tacun tangun cojo tsjian jan ta tjeyu ne, xín tacun. ");
INSERT INTO maqNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ngajan xi cha ladu rë Jesús xi cafehe titjun xcun tsjun jan ne, hacuaha cavisehen cha. Hane cavëë cha hacuaha camacjain rë cha. ");
INSERT INTO maqNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nixtin hya ne, cjëë sa cuijne rcu cha xi chja xujun rë Nina xi nima Jesús ne, meje rë xi cuya me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hya xi camá ne, xuta ladu rë Jesús jan ne, cavuya cafe me. ");
INSERT INTO maqNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hane na María ne, hacuaha cavuya quiji nga na xcun tsjun jan, hane ngajan casecun na tingotjo cajihnda na. Hane táha tijihnda na ne, catsiquindi na yojo rë na, cavutsejenya na cahntsua tsjun jan. ");
INSERT INTO maqNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Hane cavëë na jo ángel xi tyava tsjian rë, siu hiscan cafaña nima; ngu ne, táha hiscan cafaña rcu nima hane xingu ne, táha hiscan caviyuju ntsacu. ");
INSERT INTO maqNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ngajan xi ángel jan ne, cuitjin cavinenguise rë na: ―‍Ngaye chjuun, ¿mé má chjihnde? ―‍Cuatjin cavinenguise ángel jan na. Hane na vëhë ne, cuitjin cachja na: ―‍Cavaxë me maestru naha ne, hveen jani quiji chani rë. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hane xi cavatju cachja na cjua vëhë ne, sehe cavuya na táha ngaxtun na, hane cavëë na Jesús secun me jan. Peru hvíin na xi hacui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ngajan xi Jesús ne, cuitjin cachja me: ―‍Ngaye chjuun, ¿mé má cuatjin chjihnde? ¿Yo xi vinchise? ―‍Cuatjin cachja me. Hane xi má rë na vëhë ne, cha xi sahmi cuidadu yatjë jan xi cachja. Vëhë xi cachja na cuitjin: ―‍Tatá, sa xi ngayun canaxun nima ne, tinújun jani catsangun chanu, sehe cjuë́ jaha. ―‍Cuatjin cachja na. ");
INSERT INTO maqNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ngajan xi Jesús ne, cuitjin cachja me cojo rë na: ―‍¡María! ―‍Cuatjin cachja me. Hane xi cavuya na ne, sehe cachja na hne hebreo cuitjin: ―‍¡Rabuni! ―‍Cuatjin cachja na cjua xi meje cuichja Maestro. ");
INSERT INTO maqNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ngajan xi Jesús ne, cuitjin cachja me cojo rë na: ―‍Ha quihndë xicachunhñuu sa ná ta cjëë cjuë́neje cjuë́tjënguë Nina Nahmi naja. Peru tánguntjengun xuta ladu naha xi yahnga, hane cuitjin tinújun cojo rë me: “Cjuë́neje, cjuë́tjënguë Nahmi naha, me xi hacuaha Nahmi nuju, me xi Nina naha hacuaha Nina nuju ngayujun ni.” Cuatjin tinújun. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ngajan xi na María na Mágdala jan ne, quiji cachja na cojo xuta ladu rë Jesús cuitjin: ―‍¡Cahvë maestru naja! ―‍Cuatjin cachja na. Hacuaha cachja na cjua xi cachja Jesús cojo rë na. ");
INSERT INTO maqNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hane xi camajñu ndaja tsëhë nixtin tjun tjun tsëhë totje jan ne, tjin tangun xuta ladu rë Jesús jan. Hane tichjáhñu tingotjo ndihya siu me, tsëhë xi tsacjun me xutaxa rë yungun jan. Hya xi camá ne, cafehetsejen Jesús casecun me ngajñi rë xuta ladu rë me, hane cuitjin cachja me: ―‍Cjuandaja cjuajeya catejña cojo nuju. ―‍Cuatjin cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hane xi cavatju cachja me cjua vëhë ne, sehe catsingacun me tsja me hacuaha catsingacun me ngu ladu ntsacu ndanisin rë me. Ngajan xi xuta ladu rë me jan ne, jemu ndaja camá rë me hora xi cavëë me maestru naja. ");
INSERT INTO maqNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Hane cachja nga Jesús cojo rë me xi cuacun jan cuitjin: ―‍Cjuandaja cjuajeya catejña cojo nuju. Sacuatjin catsingatju ná Nina Nahmi naja ne, hacuaha cuatjin tsingátju nuju ngayun. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hane xi cavatju cachja me cjua vëhë ne, sehe cachimatjo me xuta jan, sehe cachja me cuitjin: ―‍Chjuhunntsun Hasen rë Nina cahntsua xahasen nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Xuta xi ninchatuhun jyë́ rë me ne, ha camanchataha. Hane xuta xi ninchatuun jyë́ rë ne, ha camanchataain. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás, me xi chja me tsëhë Cha Lihma, ngu xuta ladu rë Jesús ngajñi rë me xi tejó jan ne, cuajin me tacun me hya xi cafehe Jesús hiscan xi tjin tangun xuta ladu rë me xi yahnga jan. ");
INSERT INTO maqNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ngajan xi xuta ladu rë Jesús xi yahnga jan ne, cuitjin cachja me cojo Tomás: ―‍Cahyin Nai naja. ―‍Cuatjin cachja me. Peru Tomás ne, cuitjin cachja me: ―‍Sa xi scueen hiscan cavanguihmu rë xin tsja me hacuaha tsinguiseen rcuntsa hiscan cavisehen xin jan hacuaha cuetahanntsaan ngu ladu ntsacu ndanisin rë me ne, cumacjaain camahani ná. ―‍Cuatjin cachja Tomás. ");
INSERT INTO maqNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Xi cavatju jyin nixtin jan ne, tjin tangun nga xuta ladu rë Jesús cahntsua ndihya, hacuaha cojo Tomás tacun me cojo me xi cuacun vë. Hane cafehe nga Jesús casecun me ngajñi rë me xi cuacun vë, ha ndasa tichjá tingotjo ndihya. Hane sehe cachja Jesús cuitjin: ―‍Cjuandaja cjuajeya catejña cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sehe cachja me cojo Tomás cuitjin: ―‍Jarë rcuntsun. Chutsujun ntsa ne. Hacuaha jarë ntsun. Ninguisuhun ngu ladu ntsacu ndanisin naha. Tejñuxun xi cuatjin macjaain nuju. Catamacjain nuju. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ngajan xi Tomás ne, cuitjin cafayangui me tsëhë Jesús: ―‍¡Ngayun Nai naha! ¡Ngayun Nina naha! ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Hane Jesús ne, cuitjin cachja me: ―‍¿Há macjain nuju ngatsë rë xi tichutsujun ná? Ndatjin, peru jemu ndaja tsëhë me xi macjain rë, ha ndasa vutsijin ná me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Quihndë ne, jemu cjín sa cjuarcun casahmi Jesús xcun xuta ladu rë me xi camahindiin xcun xujun vihi. ");
INSERT INTO maqNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Peru cjuarcun vihi ne, camahindu cojo sa xi ngayujun ni ngayun ne, cumacjain nuju xi Jesús ne, hacui me xi Catsingatju Nina, hacuaha hacui Quihndi rë Nina me. Hacuaha camahindu cojo sa xi, xi cuatjin cumacjain nuju ne, sacú nuju cjuahñu xatsë ngatsë rë xi ladu rë me má ngayun. ");
INSERT INTO maqNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Xi camá ngascan ne, cavetjucaatsejen nga Jesús ngajñi rë xuta ladu rë me ngajan tjehen laguna Tiberias, xi hacuaha hmí rë laguna Galilea. Hane cuitjin camá. ");
INSERT INTO maqNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siu tangun me xi cuicun vi: Simón Pedru, cojo Tomás, me xi chja me tsëhë Cha Lihma, cojo Natanael, xuta Caná, ngu nandya tsëhë distritu Galilea, cojo quihndi rë Zebedeo, cojo jo sa xuta ladu rë Jesús jan. ");
INSERT INTO maqNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Hane Simón Pedru ne, cuitjin cachja me cojo xicjin me: ―‍Ngahan ne, cjuë́ cúaxë chu ti. ―‍Cuatjin cachja me. Hane me xi yahnga jan ne, cuitjin cachja me: ―‍Hacuaha cuanguin ngayin cojo nuju. ―‍Cuatjin cachja me. Sehe cavetju me quiji me cojo xicjin me, cafaha me barcu, quiji me xcun nandá. Peru nguixun hya ne, casacuiin camahani rë me chu ti. ");
INSERT INTO maqNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hane hora xi tisahasen jan ne, cavëë me Jesús secun me tjehen laguna jan, peru hvíin me xi hacui Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ngajan xi Jesús ne, cuitjin cajindaya me cavinenguise rë me me xi cuacun jan: ―‍¿Há sacuiin nuju chu ti, tsan? ―‍Cuatjin cavinenguise Jesús. Hane me xi cuacun jan ne, cuitjin cajindaya me cafayangui me: ―‍¡Sacuiin niji chu! ―‍Cuatjin cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ngajan xi Jesús ne, cuitjin cajindaya me cachja nga me cojo rë me: ―‍¡Ningatjunyun nahya vë táha ladu quixi tsëhë barcu ne, sehe sacú nuju chu! ―‍Cuatjin cachja me. Hane xi catsingatjenya xuta ladu rë me jan nahya táha ladu quixi ne, caain rë me cavaxë me nahya jan, ngatsë rë ti xi jemu cjín chu hincha chu. ");
INSERT INTO maqNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ngajan xi cha ladu rë Jesús xi jemu vinga rë Jesús jan ne, cuitjin cachja cha cojo Pedru: ―‍¡Nai naja vë! ―‍Cuatjin cachja cha. Ngajan xi Simón Pedru ne, xi cahndë me cjua xi hacui Nai naja ne, cavajásanii me tsjian rë me, tsëhë xi quixti me xi sahmi me xa jan. Hane sehe catsingatjenya me yojo rë me ngajñi nandá xi cjuetjengui me Jesús tjehen laguna jan. ");
INSERT INTO maqNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Peru xuta ladu rë Jesús xi yahnga jan ne, quijitjengui me Jesús cojo barcu jan, táha javë me nahya, ña quitsë rë cojo chu ti. Hacuiin cjin hincha me tsëhë tjehen nandá ta sacuaha ngu cientu metru ni cjin. ");
INSERT INTO maqNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hane xi cafehe me tjehen nandá jan ne, sehe cavetju me barcu, hane ngajan cavëë me ngu ndava ndihi tacun, quisun ngu ti xcun ndixuhi, hacuaha cavëë me niñu. ");
INSERT INTO maqNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ngajan xi Jesús ne, cuitjin cachja me cojo me xi cuacun vë: ―‍Tuhun ngujo chu ti xi sehe canaxun vë. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sehe quiji Simón Pedru cajavë me nahya jan cavaxë me nangui quixí, quitsë rë cojo suvá ti yehe, sacuaha ngu cientu cojo yachan tejyan má chu. Hane handasa cuatjin cjín chu ti hincha chu nahya jan ne, catiyaain. ");
INSERT INTO maqNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ngajan xi Jesús ne, cuitjin cachja me cojo xuta ladu rë me jan: ―‍Nduvun xinu tajñu. ―‍Cuatjin cachja me. Peru hisca ngu xuta ladu rë me cavetjiin cacun me cavinenguise me cuitjin: “Yo ngayun”, tsëhë xi ha vëë me xi hacui Nai naja. ");
INSERT INTO maqNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ngajan xi Jesús ne, cafaha me niñu jan, casua me xuta ladu rë me. Hacuaha cuanitjin ni casua me chu ti jan. ");
INSERT INTO maqNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Vihi majyan ndiya xi cavetjucaatsejen Jesús ngajñi rë xuta ladu rë me, quihndë xi cavuya nga me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hane xi cajnetaha cajinë tajñu me ne, sehe cavinenguise Jesús Simón Pedru cuitjin: ―‍Ngayun Simón, quihndi rë Jonás, ¿há hitsë sa hmu tacún ná ngayun xi cuma rë me xi cuicun vi? ―‍Cuatjin cavinenguise me. Hane Pedru ne, cuitjin cafayangui me tsëhë Jesús: ―‍Juun. Tatá, ngayun ne, hyun ta hmú cácun nuju. ―‍Cuatjin cafayangui Pedru. Hane Jesús ne, cuitjin cachja me cojo Pedru: ―‍Nihñu cuidadu xuta ladu naha sacuatjin ndaja cuidadu sahmi ngu paxtu rë chu hnditsánga rë me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Cavinenguise nga Jesús Pedru majo ndiya cuitjin: ―‍Ngayun Simón, quihndi rë Jonás. ¿Há hmu tacún ná? ―‍Cuatjin cavinenguise Jesús. Hane Pedru ne, cuitjin cafayangui me: ―‍Juun. Tatá, ngayun ne, hyun ta hmú cácun nuju. ―‍Cuatjin cafayangui Pedru. Hane Jesús ne, cuitjin cachja me cojo Pedru: ―‍Nihñu cuidadu xuta ladu naha sacuatjin ndaja cuidadu sahmi ngu paxtu rë chu hnditsánga rë me. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Cavinenguise nga Jesús xi majyan ndiya Simón Pedru cuitjin: ―‍Ngayun Simón, quihndi rë Jonás. ¿Há hmu tacún ná? ―‍Cuatjin cavinenguise Jesús. Ngajan xi Pedru ne, choho camá rë me xi cuatjin cavinenguise Jesús me xi majyan ndiya sa xi hmu cacun me Jesús, hane cuitjin cachja me: ―‍Tatá, ngayun ne, yëjë ni ne, hyun. Ngayun ne, hyun ta hmú cácun nuju. ―‍Cuatjin cachja Pedru. Hane Jesús ne, cuitjin cachja me cojo Pedru: ―‍Nihñu cuidadu xuta ladu naha sacuatjin ndaja cuidadu sahmi ngu paxtu rë chu hnditsánga rë me. ");
INSERT INTO maqNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Hacuaha cuichjá cojo nuju cjuaquixi ta hya xi chúva sa nixtin nuju ne, cachujun suvun tsjian nuju sehe catsangun hiscan xi meje cuangun. Peru hya xi cuma changá ngayun ne, nicujun tyja nuju, hane hacjahi xuta tsihñu me cahntsua nuju, sehe cjuecojo nuju me hiscan xi mijí cuangun. ―‍Cuatjin cachja Jesús cojo Pedru. ");
INSERT INTO maqNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Xi cuatjin cachja Jesús ne, casua me camachaya rë Pedru mé chuva rë cueya Pedru, hacuaha casua me camachaya rë me xi sahmi jyë sahmi hnga me Nina xi cuatjin cueya me. Xi cavatju cachja Jesús cjua vëhë ne, sehe cachja me cuitjin cojo Pedru: ―‍Nduvun cuanguen cojo ná. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Xi cavuya cavutsejen Pedru táha ngaxtun me ne, cavëë me xi tjengui cha xi jemu vinga rë Jesús jan nduva cha, cha xi quijivaha tiña xcun Jesús hya xi tijinë me comida jan hacuaha cavinenguise cha me cjua vihi: “Tatá, ¿yo xi sahmi nuju entregadu ni?” ");
INSERT INTO maqNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Hane xi cavëë Pedru cha vëhë ne, cavinenguise me cuitjin cojo Jesús: ―‍Tatá, hane me vëhë ne, ¿mé cuatju me cuma ni? ―‍Cuatjin cavinenguise Pedru. ");
INSERT INTO maqNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ngajan xi Jesús ne, cuitjin cachja me cojo Pedru: ―‍Sa xi ngahan meje ná xi cuejña me hisca hya xi cúya nga ne, ¿mé cuenda nuju ngayun ni? Ngayun ne, nduvun cuanguen cojo ná. ―‍Cuatjin cachja Jesús. ");
INSERT INTO maqNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hane cavitsojo ngajñi rë xuta ladu rë Jesús cjua xi cha xi jemu vinga rë Jesús jan ne, cueyaain cha. Peru Jesús ne, hacuiin cachja me cojo Pedru xi cueyaain cha vëhë ta xi cachja me ne, cjua vihi: “Sa xi ngahan meje ná xi cuejña me hisca hya xi cúya nga ne, ¿mé cuenda nuju ngayun ni?” Vëhë cjua xi cachja me. ");
INSERT INTO maqNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Cha xi cuajyihi jemu vinga rë Jesús jan ne, cha vëhë xi cachja cha cjua vëhë hacuaha cha vëhë catsihindu cha. Hacuaha ngayin xi tinihindin ngujo cjua vihi ne, hyin ta cjuaquixi cjua xi cachja cha. ");
INSERT INTO maqNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hacuaha jemu cjín sa xcusun xi casahmi Jesús. Peru sa xi cumahindu yëjë ni xcusun vëhë chuva ngu chuva ngu ne, xi má ná ne, chutaain cahndë́ setjo yëjë ni libru xi cumahindu, handasa jingujyë ni ngasunhndë.");
INSERT INTO maqNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ngayun Teófilo, xcun xujun naha xi catsihindu nuju tjun tjun ne, cachjá cojo nuju yëjë ni hacutjin cavetsihin casahmi xu Jesús cojo hacutjin cavetsihin cavicuya me. Cavétsehen hisca ntsacu cuetsihin ne, ");
INSERT INTO maqNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","catsinguíjnetaha hisca hya xi quiji me ngahnga. Hya xi chaja sa cjue me ngahnga ne, cachja xu me cojo apóstol xi ha cavaxijin me xi camá ladu rë me jan, hacutjin sahmi. Hacuaha cojo ngahñu rë Hasen rë Nina xi cachja xu me. ");
INSERT INTO maqNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Hya xi ha cavatju nixtin xi cahme me ne, cavuya cafehetjengui nga me apóstol jan, casua me camachaya xu rë ta quixi jain xi tacun quicun nga me. Hane ngajñi rë xi yachan nixtin ne, cavëë apóstol jan Jesús, hacuaha cachja sa Jesús cojo me ngujo cjua tsëhë hacutjin cuma hya xi cuinduva Nina sahmi me gubiernu. ");
INSERT INTO maqNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hane xi tacun Jesús cojo apóstol jan ngajan Jerusalén ne, cavitexa xu me me cuitjin: ―‍Hacuiin cuetjunxun tsëhë nandya vi ta nechunyun rë cjuandaja xi sua nuju Nahmi naha, sacuatjin xi ha cachjá cojo nuju. ");
INSERT INTO maqNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Cuatjin nihñu ta, xuta ne, handasa cojo nandá cavitenda Juan me, peru ngayun ne, xtenda ngayun cojo Hasen rë Nina cahntsua xi ngujo sa nixtin. ―‍Cuatjin cavitexa me. ");
INSERT INTO maqNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hya xi camá ne, ngu nixtin xi siu tangun xu apóstol cojo Jesús ne, cavinenguise me Jesús cuitjin: ―‍Tatá, ¿há cavechú nixtin xi tuhun cahndë́ xi xutaxa rë nangui naja ne, cuya cuitexa nga me nguehe nangui naja cojo jingu sa nangui, sacuatjin xi cavitexa me hatsëë ni? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ngajan xi cafayangui xu Jesús cuitjin: ―‍Satiin nuju ngayun xi cumachaya nuju jarë nixtin xi Nina cavejña cacun me cojo cjuatacun rë suvá me xi cuma yëjë ni xcusun vëhë. ");
INSERT INTO maqNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Peru hya xi cuinduva Hasen rë Nina cuisehen cahntsua xahasen nuju ne, hya sacú sa nuju ngahñu, sehe cuinújun cjua naha cojo xuta nguehe nandya Jerusalén, cojo yëjë ni nandya distritu Judea cojo Samaria, hisca cojo yëjë sa nangui xi siu ngasunhndë. ―‍Cuatjin xu cafayangui me. ");
INSERT INTO maqNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Xi cafë cachja xu Jesús cjua vëhë ne, tivutsejen ni apóstol ne, cavetsihin quiji me ngahnga. Sehe cavisehen me ngajñi rë yufí, ha quihndë camatsijin sa me. ");
INSERT INTO maqNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ha tu tivutsejen cuaha xu apóstol ngahnga hacutjin cjui Jesús ne, xi tu camachaya rë me ne, hinchacun jo xihin xi tyava tsjian rë hiscan siu me. ");
INSERT INTO maqNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hane cuitjin cavinenguise xu xihin jan me: ―‍Ngayun, cha Galilea. ¿Mé má cuatjin chutsujun ngahnga? Jesús, me xi quiji ngahnga vë ne, cuatjin tutjin xi cahyun xi quiji me ne, tjin ngu nixtin ne, ha cuanitjin ni cuya nga me. ―‍Cuatjin cachja xu xihin jan. ");
INSERT INTO maqNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hya xi camá xu ne, apóstol jan ne, cavetjuxin me tsëhë ndetjún xi hmí ndetjún Ya Olivu, hane cavuya quiji nga me Jerusalén, xi tacun sacuaha ngu mil metru tsëhë ndetjún vëhë. ");
INSERT INTO maqNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hya xi cafehe me ngajan ne, quiji me ndihya hiscan xi viyuju me, hane quijiniji me pisu ngahnga. Me xi cuicun xu vi xi viyuju me ngajan: Pedru, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo xi quihndi rë Alfeo, Simón xi tsëhë partidu zelota, cojo Judas xi xuta rë Jacobo. ");
INSERT INTO maqNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yëjë ni me xi cuacun jan, cojo yëjë ni me xi xicjin Jesús, cojo María naa rë me, cojo yachjin xi yahnga ne, nchunchujun ni camatangun me xi sahmi me oración rë me. ");
INSERT INTO maqNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ngu ndiya hya xi camatangun xu sacuaha chuva rë ngu cientu cojo can xuta xi cuacun ladu rë Jesús ne, casecunvasen Pedru ne, sehe cachja me cojo xuta jan cjua vihi: ");
INSERT INTO maqNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―‍Ngayujun ngarcun ni ngayun xuta ladu rë Jesús. Cavetjucaa jain cjua xi catsihindu xutachanga naja David xcun xujun rë Nina hatsëë. Hatuxa cuatjin camameje rë xi cuma ta, tsëhë xi chaja sa xi cuma matsejen ne, Hasen rë Nina ne, ha casua camachaya rë xutachanga naja jan hacutjin sahmi nima Judas, nima xi cavisecoo rë xuta xi cafaha rë Jesús, catsihñu rë me. ");
INSERT INTO maqNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nima Judas jan matsejen ne, hacuaha camá ladu rë Jesús sacuaha ngayaan matsejen ta, tsëhë xi cavaxijin Jesús nima xi cuisecoo rë me xcun xa rë Nina xi sahmi me. ―‍Cuahaxutjin cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","’Nima Judas jan ne, cavatsë xu ngu rquí nangui cojo tujún xi cafaha tsëhë xcusun tsehen xi casahmi xi casahmi rë entregadu Jesús. Hane ha xcun nangui xi cavatsë xu nima jan ne, caticja xcun, hane catsingá xu cahntsua nima, hisca cavetju yëjë ni ntsehen rë. ");
INSERT INTO maqNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Sacuatjin camá xu xi cahme nima ne, yëjë cjua vëhë ne, cavechútáha rë yëjë xuta ngajan Jerusalén. Vëhë xi xuta ngajan ne, casuañihi xu rë me cahndë́ jan Acéldama, ñihi xi meje cuichja xi hne rë me ne, Cahndë́ Tsëhë Jni. ");
INSERT INTO maqNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Hacuaha quijinduju sa cachja Pedru cuitjin: ―‍Hacuaha xcun xujun tsëhë Salmo matsejen ne, cuitjin camahindu: Catejña cuatjin ndava cha, hacuaha hisca ngu cuiyijin jan. Hacuaha camahindu sa cuitjin: Xa rë cha ne, catjaha jingu sa xuta. Cuatjin camahindu matsejen. ");
INSERT INTO maqNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Vëhë xi meje rë xi cuinchise rë ngu cha xi cuma tangun cojo niji matsejen, ngu cha xi ha cuatjin cavisecoo niji yëjë ni nixtin xi canujyihinyin cojo Nai naja Jesús, ");
INSERT INTO maqNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","hisca nixtin xi cavitenda Juan me cojo hisca nixtin xi quiji me ngahnga. Cha vëhë matsejen ne, cuma tangun cha cojo niji, xi tsinguixi cha hacutjin camá xi cavuya Jesús cjuahñu. ―‍Cuatjin cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hya xi cajnetaha cachja Pedru cuatjin ne, catuxijin xu rë jo xihin: José cojo Matías. José jan ne, hacuaha hacui me xi hmí rë Barsabás cojo Justo. ");
INSERT INTO maqNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Sehe cafehya rë me Nina cuitjin: ―‍Ngayun Nai niji, ngayun xi hyun cjuatacun rë ngayëjë ni xuta ne, tsëhë jo cha xi cuicun vihi ne, naxujun jarë cha xi chuya nuju ngayun ");
INSERT INTO maqNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","xi cuisehen cha xa sacuaha apóstol cahndë́ rë nima Judas ta, tsëhë xi nima vëhë ne, cavéjña tiya cahndë́ rë xi quiji hiscan xi casatë rë. ―‍Cuatjin cafehya rë me Nina. ");
INSERT INTO maqNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Xi cajnetaha cachja apóstol cuatjin ne, sehe cavaxë xu me ngu suerte, hane Matías casatë rë me. Ngajan xi Matías ne, camatangun me cojo tengu apóstol jan. ");
INSERT INTO maqNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Hya xi camá ne, xi cavechú nixtin tsëhë suhi xi hmí Pentecostés ne, ngu cahndë́ ni camatangun xu yëjë ni xuta ladu rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xi siu tangun me jan ne, ha tu ñahñu cahndë xu me xi jercu cafane ngajan ngahnga, sacuaha nuhya rë xi fane vanga tjo xi jemu hñu camahani. Sehe yëjë ni xuta jan ne, cahndë xu me xi canduva cafane hisca cahntsua ndihya hiscan siu me. ");
INSERT INTO maqNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hacuaha cavëë xu me ndihi xi langa sacuaha neje xuta, hane cavitsojo quiji casatë xu rë jima ngu jima ngu me. ");
INSERT INTO maqNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Hya xi camá ne, catsë xu rë Hasen rë Nina xahasen rë jima ngu me jan, hacuaha cavetsihin cachja xu me jima ngu me cjuandaja rë Nina ne, cachja xu me jingu sa hne xi maji rë me, tucutjin xi Hasen jan casahmi xi camá cachja me. ");
INSERT INTO maqNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ngajan Jerusalén ne, siu xuta tjë rë Israel xi faharcun jain me Nina, canduva me tsëhë yëjë ni nangui xi tjin ngasunhndë. ");
INSERT INTO maqNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hane hya xi canuhya rë xi cuatjin jercu fane ne, jercu xutacjín camatangun xu me xi quiji cavutsejen me mé xi camá. Hane xutacjín jan ne, jemu quijircun xu rë me, tsëhë xi hora xi tichja xuta ladu rë Jesús ne, xuta jan ne, hne ni rë suva me cahndë me jima ngu me xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ngajan xi cachja xu me cojo xicjin me cuitjin: ―‍¿Mé nga vihi ni? ¡Yëjë ni me xi tichja vi ne, xuta distritu Galilea me! ");
INSERT INTO maqNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Hacutjin má xi jima ngu ngayaan ne, tinuhyan hne naja suvaan ta, ");
INSERT INTO maqNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","tsëhë xi jemu cjín nangui canduvan? Ngujo ngayaan ne, xuta Partia ngayaan. Ngujo nga ngayaan ne, xuta Media ngayaan. Cojo sa xuta Elam, xuta Mesopotamia, xuta Judea, xuta Capadocia, xuta Ponto, xuta Asia, ");
INSERT INTO maqNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","xuta Frigia, xuta Panfilia, xuta Egipto, xuta ladu Libia, tiñataha nandya xi hmí Cirene, xuta Roma, ");
INSERT INTO maqNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","xuta Creta, xuta Arabia. Ngayaan xuta ngu nangui xi macjain naja Nina rë xuta tjë rë Israel ne, jemu cjín ngayaan xi nechanyanjñe nguehe ngajñi rë xuta tjë rë Israel. Hacuaha ngayejen ngarca ni tinuhyan xi tichja me hne naja. Tichja me tsëhë cjuandaja xi jercu casahmi Nina. ―‍Cuatjin xu cachja xuta xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Hane tsëhë xi cuatjin camacjíncacun me xi jemu quijircun camahani rë me ne, cavinenguise xicjin xu me cuitjin: ―‍¿Mé rë meje cuichja xcusun vi? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Peru yahnga me ne, catsixcuehyu me xuta ladu rë Jesús, hane cachja xu me ta chihi xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hya xi camá ne, caxinchacun yëjë tengu apóstol jan ne, sehe cachja xu Pedru cojo xutacjín jan cuitjin: ―‍Ngayujun ngarcun ni ngayun xuta tjë rë Israel xi nechun nguehe Jerusalén matsejen ne, tinuhyun ngujo cjua xi cuichjá cojo nuju vi, cojo sa xi cumachaya nuju. ");
INSERT INTO maqNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ngayujun ni matsejen ne, nújun ta me xi cuicun vi ne, chihi me. Peru quixiin xi nújun ta ndicumaha ni ne, sehe fane ñaja tsëhë nguitajñu. ");
INSERT INTO maqNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Peru xcusun xi sehe cavatju camá nguehe matsejen ne, cavetjucaa cjua xi cachja xutachanga naja profeta Joel hatsëë nixtin, hya xi catsihindu me cjua xi casua Nina. Cuitjin catsihindu me: ");
INSERT INTO maqNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Cjua xi cuicun vi xi chja Nina cojo naja: Hya xi cuma tiña nixtin xi cjuë ngasunhndë ne, hya tsingátju Hasen naha xi cuisehen xahasen rë xuta jingujyë ni ngasunhndë; hane quihndi nuju, sa chjuun sa xihin ne, suacuenda me cjua naha, hacuaha cha nixti nuju cojo xuta changá nuju ne, cuichja chini cojo rë me tsëhë cjuatacun naha. ");
INSERT INTO maqNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hacuaha nixtin hya ne, tsingátju Hasen naha xi cuisehen xahasen rë me xi sahmi cjuatacun naha, sa chjuun, sa xihin, hane me vëhë ne, suácuenda me cjua naha. ");
INSERT INTO maqNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Hya sahme xcusun cjuarcun vihi ngajan ngahnga, cojo nguehe nangui xi chutsujun: cuáxëcaa jni, cojo ndihi, cojo nihndi cjín. ");
INSERT INTO maqNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tsuhi ne, cuma jma; sá ne, cuma hani sacuaha jni. Cuatjin cuma hya xi chaja sa xi cuechú nixtin xi ngahan xi Nina ngahan ne, tsichúva yëjë ni xuta cojo cjuatacun rë me; ngu nixtin jyë ngu nixtin ndajyihi nixtin vëhë. ");
INSERT INTO maqNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hane nixtin hya ne, yëjë ni xuta xi cjuehya ná me cjuandaja naha ngahan xi Nina ngahan ne, cuetjutje me. Cuatjin catsihindu profeta Joel cjua xi cachja Nina. ");
INSERT INTO maqNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Cjuinduju sa tichja Pedru cjua vihi: ―‍Quihndë matsejen ne, tinuhyun cjua xi cuichjá cojo nuju, ngayujun ngarcun ni xuta tjë rë Israel. Jesús, me Nasaret matsejen ne, camachaya naja xi Nina catsingatju rë me matsejen ta, tsëhë xi jemu cjín xcusun cjuarcun casahmi me ngajñi naja sacuatjin xi ha ndaja hyun. Camá casahmi me cjuarcun jan matsejen ta, ngatsë rë xi Nina casua rë me cahndë́ xi cuatjin casahmi me. ");
INSERT INTO maqNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nina matsejen ne, ha vëë me yëjë ni xcusun. Vëhë xi cojo tjun sa ne, ha catsingataha cacun me ta Jesús vë ne, cuma me entregadu cojo xuta tsehen. Cuatjin cavejña Nina cjuatacun rë me hisca chaja sa xi cuetjucaa xcusun vëhë. Sacuaha xi ngayun canicuhun Jesús ta, ngatsë nuju xi cavetaha xuta tsehen me xcun cru. ");
INSERT INTO maqNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Peru cavëhëndaya Nina me tsëhë cjuaveya, catsicuya me me cjuahñu ta, tsëhë xi hatuxa camaji xi cavéjña me ngahma gubiernu rë cjuaveya. ");
INSERT INTO maqNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Xutachanga naja David matsejen ne, catsihindu me tsëhë Jesús cuitjin: Cahvë Nina xi cjui titjun me tsahan yëjë ni nixtin; ticojo ná me, cojo sa xi tsajin mé cuma ná. ");
INSERT INTO maqNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Vëhë xi xahasen naha ne, jemu sua rë, hacuaha ntsuva ne, suvá cjuandaja chjá. Hacuaha vëhë xi ngahan ne, vetahá cácun Nina. ");
INSERT INTO maqNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Cuatjin sahme ta, tsëhë xi ngayun Nina ne, hacuiin nismutacun hasen naha xi cuejña ngajan Hades hiscan siu nima, hacuaha hatuxa tuun cahndë́ xi cjuehndu yojo naha, ngahan xi hatuxa tjënguë nuju cojo yëjë xahasen naha. ");
INSERT INTO maqNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ngayun ne, catuhun camachaya ná ndiya xi cuéchu hiscan sacú ná cjuahñu ndajyihi. Hacuaha ninguitsun rë xahasen naha cjuasua xi cuéchutaha nuju hiscan nechun. Cuatjin catsihindu David. ");
INSERT INTO maqNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Hacuaha cachja sa Pedru cuitjin: ―‍Ngayujun ngarcun ni matsejen ne, nguehe cuichjáquixë cojo nuju matsejen ta, xutachanga naja David ne, cahme me, hacuaha caseyaniji me hatsëë nixtin. Hane tsjun rë me ne, tacun cuaha hisca quihndë hiscan xi cavéjña. ");
INSERT INTO maqNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Peru xi chaja sa xi cueya David jan matsejen ne, ngu profeta me, hacuaha ha vëë me xi ha cachja Nina cojo rë me cuitjin: Ngahan suva hvë xi ngu xuta tjë riji ne, cuitexa rë xuta, sacuatjin tivitexe ngaye. Cuatjin cachja Nina cojo David. ");
INSERT INTO maqNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Vëhë xi camachaya rë David xcusun xi sahmi Nina ngascan. Ha vëë me xi cuya nga cjuahñu me xi tsingatju Nina, hane vëhë xi cachja me ta hacuaha hacuiin cuejña me vëhë ngajan Hades ngajñi rë nima, hacuaha hacuiin cjuehndu yojo rë me. ");
INSERT INTO maqNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Hane ngayijin ni matsejen ne, cahyin suvin xi Jesús, me xi catsingatju Nina vë ne, catsicuya Nina me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hane quihndë matsejen ne, ha catsiquijin Nina me xi cavechú me ngahnga hiscan véjña suvá Nina. Hacuaha cafahatsja me Hasen rë Nina sacuatjin xi cachja Nina Nahmi rë me xi sua rë me. Vëhë xi Jesús matsejen ne, tisahmi me xcusun xi tijima nguehe ngajñi niji. ");
INSERT INTO maqNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Xi tsejen ne, cachjaain David tsëhë suvá me ta, tsëhë xi hacuiin quiji me ngahnga sacuatjin quiji Jesús matsejen ta, catsihindu sa me cuitjin: Nina ne, cachja me cojo Nai naha cuitjin: “Tinechin nguehe, ladu quixi naha, ");
INSERT INTO maqNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hisca hya xi yëjë ni xi sahmi ri condra ne, cuiyujú ngahan ngahma gubiernu riji.” Cuatjin catsihindu David hatsëë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Vëhë xi ngayujun ni xuta nangui Israel matsejen ne, ndaja catijne rcun cjua xi chjá cojo nuju vi: Jesús vë, me xi ngayun catuhun xi cahme xcun cru matsejen ne, Nina casahmi me xi me vëhë ne, camá me Nai naja hacuaha catsingatju Nina me xi cuaxëtje naja me. ―‍Cuahaxutjin cachja Pedru cojo xutacjín jan. ");
INSERT INTO maqNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Xi cahndë xutacjín jan cjua vëhë ne, jemu choho camá rë me. Ngajan xi cavinenguise me Pedru cojo apóstol xi yahnga jan cuitjin: ―‍Xi má nuju ngayun ne, ¿mé xi ndatjin nihñi? ―‍Cuatjin cavinenguise xuta jan. ");
INSERT INTO maqNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ngajan xi cachja xu Pedru cojo rë me cuitjin: ―‍Nindeyun cjuatacun nuju. Hacuaha jima ngu ngayun ne, catixtenda ngayun, ngatsë rë xi camangu tacún cojo Jesucristu, sehe ngajan xi tsinchataha nuju Nina tsëhë jyë́ nuju. Xi cuatjin ne, hacuaha sahmi me cjuandaja xi sua nuju me Hasen rë me. ");
INSERT INTO maqNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Cjuandaja vëhë ne, ha cachja Nina xi sua nuju me ngayun cojo quihndi nuju, hisca cojo yëjë xuta tjë nuju. Nina naja ne, sua me cjuandaja vëhë xi cuma rë yëjë ni xuta xi cuaxijin me. ―‍Cuahaxutjin cachja Pedru. ");
INSERT INTO maqNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Hacuaha jemu cjín sa cjua cachja me cuitjin, hacutjin meje rë xi sahmi xuta jan: ―‍Naxunxun yojo nuju tsëhë xuta tsehen xi siu quihndë. ―‍Cuatjin cachja xu me. ");
INSERT INTO maqNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ngajan xi xuta xi cachuya rë me cjua xi cachja Pedru ne, caxtenda me. Hane cuatjin xi nixtin vëhë xu ne, sacuaha jyan mil xuta xi cavisehen me ladu rë Jesús. ");
INSERT INTO maqNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Casua me yojo rë me cojo cjua xi tivicuya apóstol jan, hacuaha nguñaja cacun xu me xi ma tangun me cojo yëjë sa xuta ladu rë Jesús. Nchunchujun ni ne, camatangun me cojo xicjin me xi sahmi me oración, cojo xi sinë tangun me niñu. ");
INSERT INTO maqNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jemu cjín xcusun xu cjuarcun casahmi apóstol ngatsë rë ngahñu xi casua Nina me, hane vëhë xi yëjë ni xuta xi hacuiin ladu rë Jesús ne, jemu tsacjun me. ");
INSERT INTO maqNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Peru yëjë ni xuta ladu rë Jesús ne, camatangun xu cjuatacun rë me, hacuaha yëjë ni xcusun xi tsëhë jima ngu xu me ne, hacuaha camá tsëhë yëjë ni me xi yahnga jan. ");
INSERT INTO maqNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Caviteña xu me xcusun xi tjin rë me ne, sehe cavatëcja xu me tujún ngajñi rë yëjë ni me xi casahmi chaja rë. ");
INSERT INTO maqNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nchunchujun xu ni ne, camatangun me nguñaja cacun me ngajan yungun xi matitjun xi cjuaharcun me Nina. Hacuaha xi cajinë xu me niñu ndava me cojo xicjin me ne, jemu cojo cjuasua, cojo cjuandaja cojo cjuajeya. ");
INSERT INTO maqNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hacuaha jemu cavaxëndaja me Nina. Hane yëjë xuta xi yahnga jan ne, xi cavëë xu me xcusun rë xuta ladu rë Jesús jan ne, cachja xu me ta xuta ndaja me xi cuacun vë. Hacuaha nchunchujun ni ne, tivaxëtje Nai naja ngujo ngujo sa xuta. Vëhë xi nchunchujun ni ne, jima cjín sa xuta yungun jan. ");
INSERT INTO maqNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ngu nixtin jan ne, Pedru cojo Juan ne, quijiniji tangun xu me yungun xi matitjun chuva rë fane jyan, hora xi fi chjayuma xuta. ");
INSERT INTO maqNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hane ngu cha xi maji fi, tsëhë xi tsehen ntsacu cha hisca hya xi catsin cha ne, hacuaha hora vëhë cjuicojo xuta rë cha cha yungun. Nchunchujun ni quiji chani rë cha ngajan tingotjo hnchua xondyojo rë yungun xi hmí Tingotjo Ndajyihi, xi sahmi cha caridad tsëhë xuta xi visehen ndatsen yungun jan. ");
INSERT INTO maqNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hane xi cavëë cha hmu rë jan xi camatiña Pedru cojo Juan hiscan tacun cha xi cuisehen me ndatsen yungun jan ne, cafehya xu cha me cjuandaja rë me. ");
INSERT INTO maqNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ngajan xi cavutsejenndaja me cha. Hane Pedru ne, cuitjin cachja me cojo cha: ―‍Chutsijin niji hitsë ―‍Chja xu me. ");
INSERT INTO maqNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hane cavutsejen cha me ta, xi má rë cha ne, tjin mé xi sua me cha. ");
INSERT INTO maqNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ngajan xi cavuya cachja nga Pedru cojo rë cha cuitjin: ―‍Tsajin camahani ná tujún. Peru xi tjin ná, tsan ne, suá ri. Jesucristu, me Nasaret ne, casua ná me ngahñu, hane vëhë xi chjá cojo ri ta, tisechin, hane tujyihiye. ―‍Cuatjin cachja xu me cojo cha. ");
INSERT INTO maqNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sehe cafaha me tsja quixi cha hmu rë jan hane catsisatjenhnga xu me cha. Hane ngutjen ni casacuhñu rë ntsacu cha cojo ndyojo naxa rë cha. ");
INSERT INTO maqNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Xi tu cafaha Pedru tsja cha ne, cacaahnga cha, hacuaha casecun cha. Sehe cavetsihin catsujyihiya cha. Hacuaha cavisehen cha yungun xi matitjun cojo me xi cuacun jan, cjui cha, hisca chijihnga cha, taha tivaxëndaja cha Nina. ");
INSERT INTO maqNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yëjë ni xuta xi siu ndatsen yungun jan ne, cavëë me xi cjui cha, hacuaha cahndë me xi tivaxëndaja cha Nina. ");
INSERT INTO maqNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Hane jemu quijircun rë xuta jan tsëhë xcusun xi cavatju cha camá ta, tsëhë xi ha vëë me xi ha hacui cha vëhë xi véjña cha sahmi cha caridad ngajan tingotjo yungun xi hmí Tingotjo Ndajyihi. ");
INSERT INTO maqNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Cha xi camandaja xu jan ne, mijí cjuexin cha tsëhë Pedru cojo Juan. Hane tsëhë xi jemu quijircun rë xuta ne, cavanga me quiji me hiscan siu me xi cuacun jan, camatangun me ngajan ngu ngahma ndihya tsëhë yungun, cahndë́ xi hmí Tsëhë Salomón. ");
INSERT INTO maqNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Xi cavëë xu Pedru xi cuatjin camatangun xuta ne, cuitjin cachja me: ―‍Ngayujun ngarcun ni xuta tjë rë Israel matsejen ne, ¿mé má cuatjin fircun nuju tsëhë cha xi cuijyihi vi? ¿Mé má cuatjin jercu chutsujun niji sacuaha xi ngatsë rë cjuatacun niji suvin o ngatsë rë xi jemu ndaja chjihinrcuin Nina ne, vëhë xi camá canihñi xi camandaja cha? ¡Jéya! Hacuiin cuatjin. ");
INSERT INTO maqNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nina rë Abraham cojo Isaac cojo Jacob, Nina rë xutachanga naja matsejen ne, casahmi jyë casahmi hnga me Jesús, me xi casahmi xa rë Nina. Hane ngatsë rë me cama cjuarcun vi. Peru ngayun matsejen ne, catuhun Jesús cojo xutaxa rë. Hane ngajan xcun gobernador Pilatu matsejen ne, hora xi meje tsismi me Jesús ne, catuun cahndë́. ");
INSERT INTO maqNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesús jan ne, hatuxa tjengui me Nina cojo yëjë xahasen rë me, hatuxa cjuaquixi xi sahmi me. Peru ngayun matsejen ne, canitjungun me. Hane cahndë́ rë xi chjahyun rë Pilatu xi tsismi me Jesús matsejen ne, cachjahyun rë me xi tsismi me ngu cha tsiquehen. ");
INSERT INTO maqNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hane Jesús, me xi sua cjuahñu naja ne, ngayun catuhun me xi cahme me. Peru Nina matsejen ne, catsicuya me Jesús jan cjuahñu. Hane ngayin ne, hisca cahyin me quihndë xi tacun nga me cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Cha xi cuijyihi tichutsujun vi ne, ha hyun yo cha. Casacu rë ntsacu cha ngahñu ta, tsëhë xi ngayin matsejen ne, mangutacuín cojo Jesús. Hacuaha ngatsë rë xi cuatjin mangutacuín cojo Jesús ne, vëhë casahmi xi camandaja cha sacuahatjin xi cahyun ngayujun ni. ");
INSERT INTO maqNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Quihndë ne, ha hvë ta ngayujun ni cojo yëjë xutaxa rë yungun naja matsejen ne, hya xi catuhun Jesús xi cahme me ne, hyúun yo xi canihñu cojo. ");
INSERT INTO maqNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Peru Nina matsejen ne, cuatjin casahmi me xi cavetjucaa cjua xi cachja yëjë ni profeta cojo xutachanga naja hatsëë nixtin hya xi cachja profeta jan, tsëhë cjuañihi xi cuatju ngu me xi tsingatju naja Nina nchujun ni nguini. ");
INSERT INTO maqNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Vëhë xi meje rë xi nindeyun cjuatacun nuju, tisuhun ndiya rë Nina, cojo sa xi Nina matsejen ne, cjuahaxin me yëjë ni jyë́ nuju. ");
INSERT INTO maqNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Xi cuatjin nihñu ne, Nina ne, sua me cahndë́ xi cjuahajenda hitsë xahasen naja. Hacuaha xi cuatjin ne, tsingatju nga naja me Jesús ta, tsëhë xi ha me vëhë xi cachja Nina hisca hatsëë xi cjuaha me xa xi cuaxëtje naja me. ");
INSERT INTO maqNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Peru Jesús jan ne, meje rë xi cuejña sa me ngajan ngahnga hisca xi Nina ne, cuya sahmi ndaja nga me yëjë ni xcusun, sacuatjin xi ha cachja profeta rë me, hya xi cachja me cojo xutachanga naja cjua rë Nina hatsëë nixtin. ");
INSERT INTO maqNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Xutachanga naja Moisés matsejen ne, cuitjin cachja me ngu cjua xi catsingatju Nina tsëhë me hatsëë: “Nina ne, sahmi me xi cuetjujñi ngajñi nuju ngu xi cuma profeta sacuaha ngahan. Tetuhunrcun yëjë cjua xi cuichja me cojo nuju ta, ");
INSERT INTO maqNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","sa xi yo xi cuetaharcuaain cjua rë profeta jan ne, hatuxa cueya, ha quihndë cuejñaai ngajñi naja ngayaan xuta rë Nina.” Cuahaxutjin cachja Pedru cjua rë Moisés. ");
INSERT INTO maqNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Sehe cachja sa Pedru cojo xuta cuitjin: ―‍Hacuahanitjin yëjë profeta, xi cavetsihin cojo xutachanga naja Samuel cojo xi canduvaniji sa ne, jemu cachja me tsëhë xcusun xi camá nixtin xi nechan vi. ");
INSERT INTO maqNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Cjuandaja xi cachja Nina xi sua me xutachanga naja nchujun ni nguini ne, vëhë cjuandaja xi tisua naja me quihndë. Hacuaha compromisu xi casahmi me cojo xutachanga naja matsejen ne, tisahmichihin me cojo naja quihndë. Nina ne, casahmi me compromisu jan nixtin xi cachja me cojo xutachanga naja Abraham cuitjin: “Ngatsë rë ngu xuta tjë riji ne, ngahan ne, tsinchácun yëjë ni xuta ngasunhndë.” Cuatjin cachja Nina cojo Abraham. ");
INSERT INTO maqNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Sehe ngajan xi Nina matsejen ne, hya xi cavaxijin me Jesús xi cjuaha xa rë me ne, tjun tjun ngayaan xuta tjë rë Israel catsingatju naja Nina me. Cuatjin xi tsinchacun naja me xi cuetjunxeen jima ngu ngayaan tsëhë ndiya tsehen xi tivanguen. ―‍Cuahaxutjin cachja Pedru cojo xuta. ");
INSERT INTO maqNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Hya xi camá ne, Pedru cojo Juan ne, tichja cuaha sa me cojo xutacjín jan, hora xi cafehe xu ngujo nahmi. Hacuaha cha mayu rë yungun xi matitjun cojo ngujo sa cha saduceo ne, cafehe xu cha cojo nahmi xi cuacun jan. ");
INSERT INTO maqNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Hane jemu xti má rë yëjë me ta, tsëhë xi tivicuya apóstol jan xuta, tichja me xi ngatsë rë xi catsicuya Nina Jesús cjuahñu ne, vëhë xi machaya naja xi cuechú nixtin ne, tsicuya nga Nina yëjë ni nima cjuahñu. ");
INSERT INTO maqNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hya xi camá ne, cachjaha rë Pedru cojo Juan. Peru tsëhë xi ha quiji xu hora ne, tu caxincha ni me ndavaya. ");
INSERT INTO maqNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Peru jemu cjín xuta xi cahndë cjua rë apóstol jan ne, camacjain xu rë me. Vëhë xi yëjë xuta xihin xi macjain rë ne, sacuaha hñú mil xu camá me, cojo me xi hatsëë camacjain rë cojo me xi sehe camacjain rë. ");
INSERT INTO maqNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Xi camá nchujun jan ne, ngujo xutaxa rë yungun cojo ngujo xuta changá cojo ngujo cha xi vicuya cjuachacun ne, camatangun xu me ngajan Jerusalén. ");
INSERT INTO maqNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Camatangun me cojo Anás, me xi matitjun tsëhë yëjë ni nahmi, cojo Caifás, cojo Juan, cojo Alejandru, cojo yëjë sa me xi xuta rë me xi matitjun tsëhë nahmi jan. ");
INSERT INTO maqNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Hya xi camá xu ne, catsingatju me quiji chjahá rë Pedru cojo Juan, caviyuju me me cavasencja jan ne, sehe cavinenguise me me cuitjin: ―‍¿Hacutjin canihñu xi camá camandaja cha hmu rë jan? ¿Yo casua nuju chuva rë xi cuatjin canihñu? ―‍Cuatjin cavinenguise me. ");
INSERT INTO maqNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ngajan xi Pedru ne, cojo ngahñu rë Hasen rë Nina xi quitsë rë xahasen rë me ne, cuitjin cafayangui xu me: ―‍Ngayun xi má ngayun xutaxa rë tsajan, ngayun xi má ngayun xuta changá naja matsejen ne, ");
INSERT INTO maqNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","quihndë xi meje cumachaya nuju hacutjin canihñi ngu cjuandaja xi camandaja ngu cha hmu rë. ");
INSERT INTO maqNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nguehe cuinújin cojo nuju cojo sa xi cumachaya rë yëjë ni xuta tjë rë Israel ta cha hmu rë vi ne, nguehe secun cha xcun ngayujun ni matsejen ta, tsëhë xi camandaja cha ngatsë rë ngahñu rë Jesucristu, me xi tsëhë nandya Nasaret. Ngayun ne, catuhun me xi cahme me xcun cru, peru Nina matsejen ne, catsi