﻿USE sofia;
DROP TABLE IF EXISTS sofia.mamNT_vpl;
CREATE TABLE mamNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mamNT_vpl WRITE;
INSERT INTO mamNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ejee' tzunj lu tz'i'ben cybi tiy'jil Jesucristo. Ja Jesucristo t-xe'chel David, bix jatzen David t-xe'chel Abraham. ");
INSERT INTO mamNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Yaltzen te Abraham, tman Isaac. Jatzen te Isaac, tman Jacob. Bixsen te Jacob, cyman Judá cyuyax ke ttzicy bix ke titz'en. ");
INSERT INTO mamNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Bixsen te Judá, cyman Fares tuyax Zara, tal Tamar kej lu. Bix te Fares, tman Esrom. Bix te Esrom, tman Aram. ");
INSERT INTO mamNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Bix te Aram, tman Aminadab. Bix te Aminidab, tman Naasón. Bix te Naasón, tman Salmón. ");
INSERT INTO mamNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Bix te Salmón, tman Booz, tal Rahab. Bix te Booz, tman Obed, tal Rut. Bix te Obed, tman Isaí. ");
INSERT INTO mamNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Bix te Isaí, tman jrey David. Bix te David, tman Salomón, tal jxuj xuuj t-xu'l jxin Urías. ");
INSERT INTO mamNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Yaltzen te Salomón, tman Roboam. Bix te Roboam, tman Abías. Bix te Abías, tman Asa. ");
INSERT INTO mamNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Bix te Asa, tman Josafat. Bix te Josafat, tman Joram. Bix te Joram, tman Uzías. ");
INSERT INTO mamNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Bix te Uzías, tman Jotam. Bix te Jotam, tman Acaz. Bix te Acaz, tman Ezequías. ");
INSERT INTO mamNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Bix te Ezequías, tman Manasés. Bix te Manasés, tman Amón. Bix te Amón, tman Josías. ");
INSERT INTO mamNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Bix te Josías, tman Jeconías cyuyax ke ttzicy bix ke titz'en. Ete' ke Jeconías tej cyxi' k'i'n xjal aj Israel tuj Babilonia. ");
INSERT INTO mamNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yaltzen te Jeconías, tman Salatiel. Otk chi pon k'i'n aj Israel tuj Babilonia tej titz'j Salatiel. Bix te Salatiel, tman Zorobabel. ");
INSERT INTO mamNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Bix te Zorobabel, tman Abiud. Bix te Abiud, tman Eliaquim. Bix te Eliaquim, tman Azor. ");
INSERT INTO mamNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Bix te Azor, tman Zadoc. Bix te Zadoc, tman Aquim. Bix te Aquim, tman Eliud. ");
INSERT INTO mamNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Bix te Eliud, tman Eleazar. Bix te Eleazar, tman Matán. Bix te Matán, tman Jacob. ");
INSERT INTO mamNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Bix te Jacob, tman José, tchmil María. Bix ja te María, ttxu Jesús, jaj Cristo tbi, jaj xjal scy'o'n tu'n Dios te cawel tibaj cykilca. ");
INSERT INTO mamNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ju' tzunj, at cyajlaaj cloj cyiy'jil xjal e tzaj xe't ti'j Abraham ul ti'j David. Bix at cyajlaaj cloj cyiy'jil xjal e tzaj xe't ti'j David ul tej k'ij tej cyxi' k'i'n aj Israel tuj Babilonia. Bix at cyajlaaj cloj cyiy'jil xjal e tzaj xe't tej k'ij tej cytzyet cyu'n aj Babilonia ul baj tej titz'j Cristo. Ju'tzen tten oc Jesucristo t-xe'chel jrey David. ");
INSERT INTO mamNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bix ja te Jesucristo, Tcwal Dios. Tej tul itz'j, ju' e baj cyjulu. Ttxu Jesús, jaj txin María, otk yolen tuyaj xin José tu'n tmajetxin tuyaxin. Pero te mitkna'x majetxin tuyaxin, bix te mitkna'x toc ipan José ti'jtxin, ya atl taltxin tuj tc'u'jtxin. Preñadatltxin tu'n Espíritu Santo. ");
INSERT INTO mamNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yaltzen te José, jxin xjal tu'n tmaje tuya María, jun xjal e tnima tley Dios. Ju' tzunj, tej tel tniy'xin ti'j otk tz'oc María preñada, e tajbexin tu'n tcyaj ttzokpi'nxin María, pero yaa'n cywitz nejenel tuj tja Dios, cuma tcy'ixin tu'n tcub tch'ixew María. ");
INSERT INTO mamNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tajxin tu'n el tpaa'n tiibxin ti'jtxin, pero ul jlet jun tsanjel Dios tuj cya'j tuj twitziy'xin, bix e tkba texin: —José, tiy'jil David, mi'n tzaj ttz̈i ti'ja tu'n tmajey tuya María, cuma tu'n tipemal Espíritu Santo ma tz'oc jlet taltxin. ");
INSERT INTO mamNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bix q'uitz'jel jun taltxin, bix c'oquel tk'o'na tbi te Jesús, jatzen japeninaj “Clol xjal.” Jatzen tbi c'oquel tk'o'na, cuma chi cletel xjal tu'n tuj cyil—tz̈i ángel te José. ");
INSERT INTO mamNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Cykilcatzen jlu e baj tu'ntzen tjapan baj tyol Dios e cyaj tkba'n cye xjal tu'n jun tyolel. E tkba tyolel Dios cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","—Cycye'yenc, c'oquel preñada jun txin mitkna'x toc ipan jun xinak ti'j, bix q'uitz'jel jun taltxin, bix c'oquel k'o'n tbi te Emanuel, jatzen japeninaj “At Dios kuya”—tz̈i Dios te jun tyolel. ");
INSERT INTO mamNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bix el twatl José. Bix e tcuya tuyaj yol e tkba tsanjel Dios texin tuj twitziy'xin, bix e majexin tuya María. ");
INSERT INTO mamNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero min oc ipanxin ti'jtxin tejxe tul itz'j taltxin. Bix oc tk'o'nxin tbik'a te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Itz'jtzen Jesús tuj tnom Belén tuj departamento te Judea, bix ja tzunj jxin Herodes rey tej titz'jk'a. Tej titz'j Jesús, e pon juun xjal nim cynaabl tuj Jerusalén. Otk chi tzaj te jun tnom te ocne. ");
INSERT INTO mamNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bix e xi' cykanenxin cye xjal: —¿Jaa' ta' jxjal at tu'n tcawen cyibaj xjal judío? Jaxte ma tz'itz'j, cuma ma kila jun che'w ocne tzin tyeec'an ma tzul cawel cye xjal judío. Kaja tu'n t-xi' kyeec'ana knimbila twitz—tz̈i ke jawnex xjal te juntl tnom ocne. ");
INSERT INTO mamNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tejtzen tbinte rey Herodes otk tz'itz'j juntl rey cye xjal judío, bi'x e tzaj ttz̈i ti'jxin, bix e tzaj ttz̈i cyi'j aj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Oc tchmo'n Herodes cykilca nejenel cye pala cyuyax ke tx'olbal ley, bix e xi' tkanenxin cyexin jaa' tu'n titz'ja Cristo, jxjal Scy'o'n tu'n Dios te Cawel. ");
INSERT INTO mamNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bix aj cytzak'be'nxin texin: —Tu'n titz'j tuj tnom te Belén tuj departamento te Judea, cuma e cyaj tz'i'bet tu'n jun tyolel Dios cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Tz̈i Dios, ‘Jay, tnom Belén, amale ch'ineta cyxol tnom te Judá, pero nintzaja, cuma tuyey tzula itz'ja jun Cawel tu'n tajben te Cylel te ntanema Israel,’ tz̈i Dios,” tz̈i jun tyolel Dios—tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tej tel tniy' Herodes ti'j otk tz'itz'j jun cawel, bix e tzaj ttxco'nxin kej xjal nim cynaabl, pero tuj ewjel, bix e xi' tkanenxin cyexin: —¿Jtoo ul jlet che'w te ocne?—tz̈i rey. ");
INSERT INTO mamNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tej tbaj yolen Herodes cyuya aj naabl te ocne, e xi' tsma'nxin ejee'xin tuj tnom Belén, bix e xi' tkba'nxin cyexin: —Cyucxa cyey tuj tnom te Belén, bix chebe chebe chi jyona ti' nee'. Ojtzen tcnet cyu'na, cykbantza weya, tu'ntzen jax ju'x weya tu'n nxi'ya yec'l nnimbila twitz—tz̈i Herodes, pero ẍtak' yol. ");
INSERT INTO mamNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tej cybintexin tyol rey, exkexin, bix tujx naj tul jlet che'w juntl maj otk cyilxin tej cytenxin ocne. Bix e cub nej che'w cywitzxin, bix tej tpon che'w tibaj jaa' jaa' ta' nee', e we' che'w. ");
INSERT INTO mamNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tejtzen cylontexin che'w, nimxsen e jaw tzalajkexin. ");
INSERT INTO mamNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bix ocxkexin tuj jaa', bix e cyilxin nee' tuya ttxu, ja María, bix e cub mutzk'ajkexin twitz nee' tu'n tjaw cynimsa'nxin ja. Otk txi' cyii'nxin ch'in ti'j cyk'inemalxin, bix e jaw cyjko'nxin. E jatz cyii'nxin cyoybilxin, bix e xi' cyk'o'nxin tek'a oro tuya incienso tuya jun wik c'oc'sbil mirra tbi. ");
INSERT INTO mamNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pero tej tpon tumel tu'n cyajxin, e tzaj tkba'n Dios cyexin tuj cywitziy'xin tu'n mi'n chi aj meltz'ajxin tuya Herodes. Ju' tzunj, ajkexin tuj cytanemxin tuj junxitl be. ");
INSERT INTO mamNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cyajlenxitltzen ke aj naabl, at jun e baj. Ul jlet jun tsanjel Dios tuj cya'j tuj twitziy' José, bix e xi' tkba'n te José: —Wey'tztzen, bix k'inxa nee' tuyax ttxu, bix ju' txi'y tuj Egipto, bix ajkelbilx tu'na, bix jatztzen ctemeley ojxe t-xi' nkba'na tey tu'n tul meltz'aja, cuma tzul Herodes jyolte nee' tu'n tcub tbyo'nxin—tz̈i ángel. ");
INSERT INTO mamNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bix e jaw we' José, bix tex koniyan e xi' tii'nxin nee' tuya ttxu, bix e xi' okxin tuj Egipto. ");
INSERT INTO mamNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bix e tenkexin tuj Egipto tejxe tcyim Herodes. Ju'tzen e'la jaxxix tyol Dios. E cub ttz'i'ben jun tyolel Dios cyjulu: “Tuj Egipto q'ueletz ntxco'na Ncwala,” tz̈i Dios tej xin tyolel. ");
INSERT INTO mamNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yaltzen te Herodes, tej tbintexin otk cub sbu'nxin cyu'n aj naabl te ocne, nimxsen e tzaj tk'ojxin, bix e xi' tsma'nxin tsoldadoxin tu'n tcub cybyo'nxin cykilca cwal xinak tuj Belén bix cyuj ke aldea tuj tcwent Belén. E xi' tkba'nxin tu'n cycub byet cykilca cwal nitz'j hasta te ca'ba jnabk'ike, cuma el tniy'xin ti'j tu'n cyyol aj naabl otk bint ca'ba jnabk'i tej tul jlet jawnex che'w te ocne. ");
INSERT INTO mamNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ju'tzen e'la jaxxix tyol Dios e tkba tyolel Dios Jeremías. E cyaj ttz'i'ben Jeremías cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Cbijel jun s̈itz̈'bil tuj Ramá, jatzen k'ajk'ajel cywi' xuuj te nimxsen bisbajil. Chi ook'el ke cyiy'jil Raquel cyi'j ke cyal, bix mlay bint tu'n tcyiwsaj cyc'u'j, cuma min-altl cyal,” tz̈i Jeremías jatxe ootxa. ");
INSERT INTO mamNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tejtzen tcyim Herodes, at juntl e baj. Juntl maj ul jlet jun tsanjel Dios tuj cya'j tuj twitziy' José tuj Egipto. Bix e xi' tkba'nxin te José: ");
INSERT INTO mamNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Wey'tztzen, bix k'inxa nee' tuyax ttxu, bix cu txiy tuj tx'otx' te Israel, cuma o chi cyim kej xjal e cyajbe tu'n tcub byet nee'—tz̈i ángel. ");
INSERT INTO mamNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ju' tzunj, e jaw we' José, bix e xi' tii'nxin nee' tuyax ttxu, bix e ponkexin tuj tx'otx' te Israel. ");
INSERT INTO mamNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","E tajbexin tu'n tnajanxin tuj departamento te Judea, pero tej tbintexin otk tz'oc Arquelao te cawel te t-xel Herodes tuj Judea, e tzaj ttz̈i ti'jxin tu'n tnajanxin tuj Judea. E tzaj tkba'n Dios texin tuj twitziy'xin tu'n mi'n pon meltz'ajxin tuj Judea. Ju' tzunj, e xi'kexin tuj departamento te Galilea, ");
INSERT INTO mamNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","bix e ponkexin tuj jun tnom Nazaret tbi. Ju'tzen e'la jaxxix jtyol Dios e cub ttz'i'ben jun tyolel Dios ti'j jxjal Scy'o'n tu'n Dios. Tz̈i cyjulu: “Jun aj Nazaret c'oquele tbi.” ");
INSERT INTO mamNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mas yaj, ultzen junxin xjal Juan Bautista tbi tuj jun lugar tuj Judea jaa' yaa'n nim xjal najl tuj. E tk'ume Juan tyol Dios, bix tz̈i cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Cyk'oncja cyila bix chi meltz'aja tuya Dios, cuma tzul lk'e tcawbil Dios kxol—tz̈i Juan Bautista. ");
INSERT INTO mamNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ju' e tyole Juan, cuma jaxin jxjal e yolen Isaías ti'j, jxin tyolel Dios te ootxa. E tkba Isaías cyjulu: “C-yolel jun tyolel Dios jaa' yaa'n nim xjal najl tuj. Tz̈itzen tbel cyjulu: ‘Cybincham cyiiba twitz Taaw twitz tx'otx'. Cyjkom tbexin tuj cyanema,’ tz̈i tbel jxjal c-yolel,” tz̈i Isaías. ");
INSERT INTO mamNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yaltzen te Juan, jatzen t-xbalen toc ttzmal camello, bix tz'u'n tq'uelbilxin toc. Yaltzen twaxin, cuchi'kejil, bix tc'a'xin ta'l xii' e cnet tu'nxin tuj c'ul. ");
INSERT INTO mamNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bix e pon nim xjal te nin tnom Jerusalén tuya Juan, cyuyax xjal te niy'tl tnom tuj Judea, cyuyax jxjal najl ttzii' nima' Jordán. ");
INSERT INTO mamNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bix e bautizarj ke xjal tu'n Juan tuj nima' Jordán tej tjatz cykba'n cyil. ");
INSERT INTO mamNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero tej tlonte Juan otk chi ul nim xjal tej cloj fariseo bix tej cloj saduceo, tu'ntzen cybautizarj tu'nxin, e xi' tkba'nxin cye: —Ke cyey cynaabla tisen lbaj. ¿Tikentzen cycy'iy tu'n tcyaj cyk'o'na cyila? Cyaj cyey tu'n cybautizarja wu'na nuk tu'n mi'n cub castiwa cyibaja tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ka cycy'iy tu'n tcub castiwa tu'n Dios cyibaja, cybinchamtzen alcyej ba'n, tu'ntzen tchic'ajax ka otk cyaj cyk'o'na cyila bix ka otk chi meltz'aja tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bix mi'n cub cyximana tuj cyanema: ‘Cuma tiy'jil Abraham ko'ya, mlay tzaj kcastiwiya tu'n Dios, cuma t-xjal Dios ko'ya,’ tz̈i key. Pero yaa'n ju'wa. Cxe'l nkba'na cyey, ka ma chi oc xjal te t-xjal Dios nuk tu'nj tiy'jil Abrahamke, ba'ntzenle tbint tu'nxin tu'n cyoc ke xak te t-xjal Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tzul castiwa cyibaj kej xjal yaa'n ba'n twitz Dios. C'oquel cyc'u'ja ti'j ja tumel lu. Taaw cab tken lo'pj c'oquel tcye'yen cyi' cyken lo'pj. Kej min cyak' cywitz ba'n, chi jawel tx'omet ttzi tx'otx', bix nuk te tuj k'ak' chi ajbela. ");
INSERT INTO mamNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Weya, nuk jun xjal kena tu'n cybautizarj xjal wu'na, ka cyaj xjal txi' cyyeec'an ma tz'ajtz ti' cynaabl twitz Dios. Pero at jun xjal lepch wi'ja jawnexxsen nwitza. Mintlpetii' woclena tu'n tel npju'na tak'el t-xaab. Ja tzunj xjal tzul, yaa'n nuk jun techel ctk'a' tisen weya, sino ctzaal tk'o'nxin Espíritu Santo te cyej cyey ma cyaj cyk'o'na cyila, bix ctzaal tk'o'nxin tu'n cyxi'y tuj k'ak' te cyej cyey min cyaj cyk'o'na cyila bix min ma tz'ajtz ti' cynaabla. ");
INSERT INTO mamNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jun awal triwa q'uelel tpa'n jtwitz triwa tuya t-xc'omel. Jtwitz triwa c'oquex tuj tx'utx', pero tzunj t-xc'omel c'oquex tuj jk'ak' mlay yubtz'aj. Ju'tzen ctemel pjel tpa'n jxjal tzul kej xjal at tu'n cyclet cyuyaj xjal at tu'n cyxi' tuj k'ak'—tz̈i Juan cye aj fariseo bix cye aj saduceo. ");
INSERT INTO mamNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Etztzen Jesús tuj departamento te Galilea, bix ulxin tuya Juan ttzii' nima' Jordán, tu'ntzen tbautizarjxin tu'n Juan. ");
INSERT INTO mamNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero tuj twitz Juan, yaa'n tumel tu'n tbautizarj Jesús tu'nxin. E xi' tkba'nxin te Jesús: —Il ti'j tu'n nbautizarja tu'na, yaa'n tu'n tbautizarja wu'na—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero e xi' tkba'n Jesús texin: —Jax tu'na, pero ja'lewe waja tu'n tbint jwajbila tu'na, tu'ntzen tbint jma tkba Dios—tz̈i Jesús. Bix e tcuya Juan. ");
INSERT INTO mamNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tejtzen tbautizarj Jesús tu'n Juan, e jatz Jesús tuj nima', bix e jket cya'j, bix e tilxin tcu'tz Espíritu Santo tisen junjil cucu', bix e cub licy'pajjil tuj twi' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bix e tzaj jun yol tuj cya'j. E tkba cyjulu: —Ja tzunj xjal lu Ncwala n-oc tak' weya. Nchin tzalaja ti'j—tz̈i Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yajc'atltzen bix e xi' k'i'n Jesús tu'n Espíritu Santo tuj jun lugar mintii' cynajbil xjal tuj, tu'ntzen toc tk'o'n taaw il tipen ti'jxin tu'n tyeec'ante Jesús tnimbil texin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","E cub tpa'n weyaj cya'wnak k'ij tuyax cya'wnak koniyan, bix tej tjapan baj cya'wnak k'ij, otkxsen bajxin tu'n weyaj. ");
INSERT INTO mamNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bix e pon taaw il tuya Jesús tu'n tbint tajbil taaw il tu'n Jesús. E xi' tkba'n texin: —Ka Tcwal Diosa, binchanc'a tzunj xaka te tway te yec'bil—tz̈i taaw il. ");
INSERT INTO mamNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero e xi' tkba'nxin te taaw il: —Tzin tkba'n tuj tyol Dios cyjulu: “Yaa'n nuk o'cx tu'n twa jun xjal i'tzen. Ja te mas il ti'j, tu'n tnimante cykilca yol tzin tkba'n Dios,”—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bix e xi' tii'n taaw il ja Jesús tuj Jerusalén, ja tnom nintzaj, bix e jaw tii'n taaw il jaxin maa twi' tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bix e xi' tkba'n taaw il texin: —Ka jay Tcwal Dios, xoo'nx tiiba twitz tx'otx'. Mlay cyima, cuma tzin tkba'n tyol Dios cyjulu: “Chi tzaal tk'o'n Dios tsanjel tuj cya'j te clol tey. Ejee' chi tzyulte tey tuj cyk'ab, tu'ntzen mi'n tzak' tkena cywi' xak,” tz̈i tyol Dios—tz̈i taaw il. ");
INSERT INTO mamNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pero aj ttzak'be'n Jesús te: —Pero jax tzin tkba'n tyol Dios cyjulu: “Mi'n tz'oc cycyakwusa'na Cyaawey Dios tu'nj toc cyk'o'na tuj malbil te, ka jax tu'n,”—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bix e xi' k'i'n Jesús juntl maj tu'n taaw il. E pon k'i'nxin twi' jun witz te nimxsen twe', bix e xi' tyeec'an taaw il texin cykilca tnom twitz tx'otx' tuyax cyk'inemal tnom nimxix. ");
INSERT INTO mamNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bix e xi' tkba'n taaw il texin: —Cykilca ke tnom lu cxe'l nk'o'na tey ka ma cub majey nwitza te yec'bil ka inayena taawa tuj twitza—tz̈i taaw il texin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bix e xi' tkba'nxin te taaw il: —¡Min! Cutxey, Satanás, cuma tzin tkba'n tyol Dios cyjulu: “Nuk o'cx ja Dios cjawel cynimsa'na, bix nuk o'cx te texin ba'n cyajbe'ney,”—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bixsen e cyaj tk'o'n taaw il jaxin, bix ul ke tsanjel Dios tuj cya'j onlte texin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tejtzen tbinte Jesús otk tz'ocx Juan tuj tzee', e xi'xin tuj departamento te Galilea, ");
INSERT INTO mamNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","tu'ntzen tponxin tuj ttanemxin Nazaret. Pero etzxin tuj Nazaret, bix e ponxin tu'n tnajanxin tuj tnom te Capernaum. Tcub Capernaum ttzii' jun tnijabel a', jaa' najle kej tchmanxin Zabulón bix kej tchmanxin Neftalí. ");
INSERT INTO mamNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tej tak'ananxin tuj taak'en Dios jatzewe, el jax j-e tkba jxin tyolel Dios Isaías. E cub ttz'i'ben Isaías cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kej xjal tuj tx'otx' te Zabulón bix kej xjal te Neftalí, cyuyax xjal ttzii' tnijabel a' bix jlajxe nima' Jordán, bix kej xjal yaa'n judío tuj Galilea, ");
INSERT INTO mamNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ejee'j tzunj xjal lu chi temel tuj klolj. Nuk chi ayol cycyamecy, pero cxe'l cycye'yen jun spi'yen nintzaj. Kej xjal lu najlke tuj jun tx'otx' jaa' ta' nuk klolj bix cyamecy, pero cwel koptz'aj jun spi'yen cyibaj,” tz̈i Isaías jatxe ootxa. ");
INSERT INTO mamNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tponlenxitltzen Jesús Capernaum, ak'xin k'umlte tyol Dios. E tkbaxin cyjulu: “Chi meltz'aja tuya Dios, cuma ma pon tumel tu'n tul tcawbil Dios tuj cya'j,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","At jun k'ij e bet Jesús ttzii' jnintzaj tnijabel a' te Galilea, bix e tilxin ca'ba xjal cyitz'en cyiib. At jxin Simón, bix juntl tbixin Pedro, bix at jxin Andrés. Bix e cu'x cyxoo'nxin jun xiy'pa tuj a', cuma tzyul quis̈kexin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Bix e xi' tkba'nxin cyexin: —Chi lpetza wi'ja. Ja'lewe lu key nchi chmona quis̈. Pero chi oquel nk'o'na te chmol xjal tu'n cyxi' lpe wi'ja—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bix ncyaj cyk'o'n najtlxin cyxiy'paxin, bix oc lpekexin ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tejtzen t-xi' tbet-xin juntl tkiy', e tilxin ca'batl xjal cyitz'en cyiib, jaj jxin Jacobo, bix jxin Juan. Tcwal jxin Zebedeo ejee'xin. Ete'c'axxin tuj jun barc tuya Zebedeo, cymanxin, nchi remyenaxin cyxiy'paxin. Bix e tzaj ttxco'nxin ejee'xin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bix e cyaj cyk'o'nxin najtlxin cybarcxin tuyax cymanxin, bix oc lpekexin ti'j Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Bix e bet Jesús tuj cykilca ke tnom tuj Galilea. Tuj jaca juun camon jaa' te xnak'tzbil tyol Dios, e xi' t-xnak'tza'nxin cye xjal, bix e xi' tk'umenxin jtbanel yol ti'j tcawbil Dios. Bix oc tk'anexin kej xjal yaab. El tii'nxin nuk alcyexja cyyabel xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bix el tpocbal Jesús tuj cykilca ke tnom tuj Siria. Ju' tzunj, ul k'i'n twitzxin nimxsen xjal yaab cyu'n aj Siria. Ul kej xjal nim q'uixc'aj ete' tu'n yabbil, bix kej nchyon cyi'j, bix kej xjal otk chi oc biman cyi'j, bix kej e tzaj tuj cywi', bix kej mintii' tanem cyxumlal. Bix e k'anjke tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nimxsen xjal oc lpe ti'jxin. E tzajke tuj Galilea, bix cyuj ke tnom te Decápolis, bix tuj Jerusalén, bix cyuj tnom te Judea, bix at e tzaj jlajxe nima' Jordán. ");
INSERT INTO mamNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tejtzen toc tcye'yen Jesús nim xjal oc lpe ti'jxin, e jaxxin twi' jun witz. Tej tcub kexin, e pon lk'e ke t-xnak'atzxin ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Bix ak'xin yolel cyuyaxin. E xi' t-xnak'tza'nxin cye t-xnak'atzxin cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—At t-xtalbil Dios cyibaj kej xjal n-el cyniy' ti'j mintii' cyipemal tu'n cyclet cyu'nx, cuma ck'ojel cye tu'n cyocx tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","At t-xtalbil Dios cyibaj kej xjal nchi bisen ti'j cyil, cuma ccywixel cyc'u'j. ");
INSERT INTO mamNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","At t-xtalbil Dios cyibaj kej xjal min jaw cyniman cyiib, cuma ck'ojel twitz tx'otx' te cykab. ");
INSERT INTO mamNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","At t-xtalbil Dios cyibaj kej xjal nimxsen cyaj tu'n cyoc jiquenxix twitz Dios, cuma ctzaal tk'o'n Dios cyajbil. ");
INSERT INTO mamNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","At t-xtalbil Dios cyibaj kej xjal n-oc cyk'o'n lastim cye cabtl xjal, cuma c'oquel tk'o'n Dios lastim cye. ");
INSERT INTO mamNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","At t-xtalbil Dios cyibaj kej xjal sakxix tuj cyanem, cuma c'oquel cycye'yen Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","At t-xtalbil Dios cyibaj kej xjal n-oc cyipen tu'n twe' k'oj cyxol xjal bix tu'n cyten xjal tuj ttz̈yal cyuya juntl, cuma c'oquel k'o'n cybi tcwal Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","At t-xtalbil Dios cyibaj kej xjal nchi baj yaset cyu'n xjal nuk tu'nj jiquen ete' twitz Dios, cuma ck'ojel cye tu'n cyocx tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","At t-xtalbil Dios cyibaja oj nchi xmucchan xjal cyi'ja bix oj nchi oc yaseta cyu'n bix oj nchi yolen xjal ka' cyi'ja tuya xtz'imj yol nuk wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chi tzalaja, cuma ctzaal k'o'n cyey nim cycotza tuj cya'j, bix cuma juniy' cytena cyuya ke tyolel Dios te ootxa. Oc cyyasen xjal ejee' nuk ti'j tyol Dios—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Bix e xi' tkba'ntlxin cyexin: —Tisen tzin tk'o'n atz'en ttz̈yal waabj, bix tu'n mi'n k'ey waabj, jax ju'x nchi ajbena cyxol xjal tu'n cyten xjal ba'n. Katzen ma tz'el baj tik'bil atz'en, ¿ti tten tu'n tcub meltz'ajtl ttz̈yal? Mintii' c'ajbeletl. O'cx nuk tu'n tex xe't, bix tu'n tbaj wa'ban cyu'n xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ejee'y tisen spi'yen cye xjal. Bix chic'aj cynaabla tisen jun tnom tcub twi' jun witz. Yaa'n ba'n tu'n tcub cyewena cynaabla cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Oj toc t-xket cantil tu'n jun xjal, yaa'n tu'n tocx ewet tjak' jun alma, sino cwel tk'o'n twi' mes, tu'ntzen tk'onte spi'yen cye kej xjal at tuj jaa'. ");
INSERT INTO mamNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jax ju'x cyey, cyii'nxa cychunk'lala cywitz xjal tuj tumel, tu'ntzen tchic'ajax cybinchbena ba'n, tu'ntzen tjaw cynimsa'n xjal Cymana Dios at tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mi'n cub cybisena ka ma chin ula tu'n tel wii'na tajwalel tley Moisés bix ti'j j-e cub cytz'i'ben tyolel Dios. Min in ula tu'n nk'ojla ti'j, sino tu'n tjapan baj wu'na. ");
INSERT INTO mamNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Jaxxix cxe'l nkba'na cyey, cbinel cykilcaj e cub tz'i'bet tuj tyol Dios. Mlay xitj twitz cya'j bix twitz tx'otx' hasta ojxe tbint cykilcaj yol e cub tz'i'bet tuj tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ju' tzunj, alcyej xjal ma tziy' tibaj jun ley tuj tyol Dios, amale ch'int jun mandamyent, bix ma txi' t-xnak'tza'n cye cabtl tu'n cyiy' tibaj ley, c'oqueltzen te ch'in cyxol t-xjal Dios. Pero alcyej xjal nbint tyol Dios tu'n, bix ma txi' t-xnak'tza'n cye cabtl tu'n cyniman tyol Dios, jatzen xjala c'oquel tk'o'n Dios jawnex cyxol t-xjal Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Jaxxix cxe'l nkba'na cyey, ka min ma chi oca mas jiquen twitz Dios cywitz ke tx'olbal ley bix kej xjal cyiwxix tuj ley, ejee'j aj fariseo, mlay chi ocxa tuj tcawbil Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","O cybiy nejl e cykba kej xjal crinsipal: “Mi'n cub cybyo'na xjal. Alcye jun xjal ma byon, cwel castiwa tibaj cyu'n juez,” tz̈ike. Pero o'cx jlu e cykba. ");
INSERT INTO mamNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero jatzen weya, cxe'l nkba'na cyey, alcye jun xjal ma tzaj tk'oj ti'j juntl xjal, cwel castiwa tibaj tu'n Dios. Tzin cykba'n cyxnak'tzala alcye jun xjal ma tz'oc t-xmuccha'n juntl xjal, c'oqueltzen cywitz juez mas jawnex. Pero jatzen weya, cxe'l nkba'na cyey, alcye jun xjal ma tz'oc t-xmuccha'n juntl xjal, cxe'ltzen tuj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ju' tzunj, oj t-xi'y k'ol te toybila twi' altar tuj tja Dios, pero q'uiyel tuj tc'u'ja ka at jun tila tuj twitz juntl xjal, ");
INSERT INTO mamNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","cyjel tk'o'na toybila twi' altar, bix cutxey tuyaj xjal tu'n tbint ttena tuya. Ojtzen tcuba tuj ttz̈yal tuya, ba'ntzen tu'n t-xi' tk'o'na toybila. ");
INSERT INTO mamNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ka at jun tc'asbena te jun xjal, bix taj xjal txi' tii'n jay twitz juez, cxe'l naja yolel tuyaj xjal, tu'ntzen tbint ttena tuya te mitkna'x tpon k'i'na twitz juez tu'n, cuma ka ma cub tz'aka tuj tila twitz juez, cxe'l k'i'na cyu'n ke policía tuj tzee'. ");
INSERT INTO mamNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jaxxix cxe'l nkba'na cyey, mlayx tz'etza tuj tzee' ojxe tchjet cykilca tc'asbena. ");
INSERT INTO mamNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","O cybiy nejl e cykba nejenel cye xjal: “Mi'n chi jyona juntl xuuj te pajbaj.” Pero o'cx jlu e cykba. ");
INSERT INTO mamNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero jatzen weya, cxe'l nkba'na cyey, alcye jun xjal ma txi' cye'yente juntl xuuj bix taj tu'n toc ipan ti'j, ya ma tbincha aj pajlel tuya tuj tanem. ");
INSERT INTO mamNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ju' tzunj, ka ma cub tz'aka tuj il tu'n tlaj tbak' twitza tuj tmank'aba, k'imatza bix xomaxa, cuma mas ba'n tu'n tetz jun tbak' twitza twitzj tu'n t-xi' xe't cykilca t-xumlala tuj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bix ka ma cub tz'aka tuj il tu'n tlaj tmank'aba, tx'omela bix xomaxa, cuma mas ba'n tu'n tel tx'omet jun tk'aba twitzj tu'n t-xi' xe't cykilca t-xumlala tuj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nejl, e cykba nejenel cye xjal: “Alcye jun xjal taj tu'n tcub tpa'n tiib tuya t-xu'l, ba'n tu'n tex tlojo'n nuk tu'nj cxe'l tk'o'n te xuuj jun tu'l tyol xinak otk chi pax.” ");
INSERT INTO mamNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero jatzen weya, cxe'l nkba'na cyey, jaca juun xjal ma cub tpa'n tiib ti'j t-xu'l, ka min e tbincha t-xu'l pajlel, nbinchantzen jun ka' ti'j, cuma cwel maje t-xu'l tuya juntl xjal, bix c'oquel te aj paj. Bix c'oquel aj paj alcye jun xjal ma cub maje tuyaj xuuj aj paj. ");
INSERT INTO mamNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jax o cybiy e cykba ke crinsipal xjal nejl: “Oj nxi' cyk'o'na cyyola te Dios tuya jun jurament tu'n tbint jun ak'untl twitz, ka'xsen ka min ma japan baj cyyola. Il ti'j tu'n tjapan baj cyyola oj t-xi' cykba'na ‘tzkinn Dios,’” tz̈ike. Pero o'cx jlu e cykba. ");
INSERT INTO mamNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero jatzen weya, cxe'l nkba'na cyey, mi'n txi' cykba'na “tzkinn Dios” tu'n tcywix cyyola. Tuj cywitz nejenel cye xjal, at mas tipemal jyol “tzkinn Dios” twitzj jyol “tstiwa cya'j wi'ja” ");
INSERT INTO mamNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","bix twitzj yol “tstiwa twitz tx'otx' wi'ja” bix ja yol “tstiwa Jerusalén wi'ja.” Pero yaa'n il ti'j lu, cuma tuj cya'j ncawen Dios, bix najben twitz tx'otx' tu'n tcub tk'o'n Dios tken, bix Jerusalén jtnom jaa' ccawel Dios tisen rey. ");
INSERT INTO mamNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bix mi'n txi' cykba'na tu'n tel tx'omet cywi'ya ka min ma chi japan baja ti' cyyola, cuma o'cx te Dios ncawen tibaj cywi'y. C'oquel cyc'u'ja ti'j mlay bint cyu'na tu'n toc ttzmal cywi'y sak bix ka k'ek. ");
INSERT INTO mamNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ju' tzunj, mi'n txi' cykba'na jun yol te jurament tu'n tcywix cyyola. Nuk o'cx tu'n cyyolena tuya jun yol jaxxix. Ka ma tz'oc cyk'o'na juntl yol tibaj, ka' tzunj lu. ");
INSERT INTO mamNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","O cybiy e cykba kej xjal crinsipal nejl: “Ka ma txi' tbak' twitza bix ka twitz tey tuj il tu'n juntl xjal, ba'n tu'n tjyona tcastiwa twitz ley, tu'ntzen t-xela junx.” ");
INSERT INTO mamNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero jatzen weya, cxe'l nkba'na cyey, mi'n chi k'ojla cyi'j xjal nchi binchan ka' cyi'ja. Ka ma txi' ttz'ajen jun xjal tk'o'txa tuj tmank'aba, k'onxa juntl plaj tu'ntzen t-xi' ttz'ajen. ");
INSERT INTO mamNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ka taj jun xjal txi' tii'n jay twitz juez tu'n tel k'i'n tcamisa, k'onxtla tcapẍeyena te. ");
INSERT INTO mamNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ka ma tz'oc tfwersen jun xjal jay tu'n t-xi' tii'na tiketz jun ajlabl, k'onx tiiba te tu'n t-xi' tii'na juntl ajlabl mastl. ");
INSERT INTO mamNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ka at jun xjal ma tkane jun tiixja tey, k'onxa te. Bix ka at jun xjal ma tkane pwak tey te tc'asben, mi'n cub t-xq'ueyena. ");
INSERT INTO mamNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","O cybiy e cykba kej xjal crinsipal nejl: “C'oquel cyak' cyuyey cyey, bix q'uelel cyiiq'uena cyaj k'oja cyi'ja.” ");
INSERT INTO mamNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero jatzen weya, cxe'l nkba'na cyey, il ti'j c'oquel cyak' cyey kej xjal nchi k'ojl cyi'ja, bix chi na'na Dios cyi'kej nchi yasen cyi'ja, ");
INSERT INTO mamNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tu'ntzen tchic'ajax ka tcwal Cymana tuj cya'j ejee'y. Tu'nxin njawelen k'ij cyibaj kej xjal yaa'n ba'n bix kej xjal ba'n, bix ntzaj tk'o'nxin jbal cyibaj kej xjal jiquen bix kej xjal yaa'n jiquen. ");
INSERT INTO mamNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ka ma tz'oc cyak' cyey nuk ejee'j xjal n-oc cyak'a cye, ¿alcyetzen cycotza ctzaal k'o'n cyey? Jax ju'x kej chmol chojentj alak' n-oc cyak' cyuya cye. ");
INSERT INTO mamNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bix ka ma txi' cyk'olbe'na nuk ejee'j cyuyey, ¿alcyetzen nchi binchana mas cywitz mastl xjal? ¿Yaa'mpatzen tzin cybincha'n kej xjal yaa'n ttanem Dios ju'wa? ");
INSERT INTO mamNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ju' tzunj, chi ocxa tz'aklxix, tisen te Cymana tuj cya'j tz'aklxixte—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Bix e xi' tkba'ntl Jesús cye t-xnak'atz: —C'oquel cycwenta ti'j tu'n mi'n cybinchana ba'n nuk o'cx tu'n cyoc cye'yena cyu'n xjal. Ka ma cybinchaya nuk tu'n tchic'ajax cybinchbena cywitz xjal, mlay tzaj k'o'n cycotza tu'n Cymana Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ju' tzunj, oj t-xi' cyonena ke mebe, mi'n txi' cyk'o'na tumel cye xjal tuya xux ti nbaj cyey, tisen nbint cyu'n xmeletz' xjal cyuj camon jaa' bix cyuj be, tu'ntzen cyjaw nimsa'n cyu'n xjal. Jaxxix cxe'l nkba'na cyey, o'cx cycotz nuk tu'n cyjaw nimset cyu'n xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Jatzen cyey, oj t-xi' cyonena ke mebe, mi'n txi' cykba'na cye cyuyey ti nbint cyu'na. ");
INSERT INTO mamNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ka ju' nbint cyu'na tuj ewjel, cxe'l tk'o'n Cymana Dios t-xel cyey, cuma ncye'yen Dios ti'j cykilca nbint cyu'na tuj ewjel. ");
INSERT INTO mamNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ojtzen cyna'na Dios, mi'n chi binchana tisen nbint cyu'n xmeletz' xjal. Cyaj tu'n cyten wa'l cyuj camon jaa' bix cyuj be tu'n cyna'n Dios cywitz xjal. Jaxxix cxe'l nkba'na cyey, oj nchica'jax cynabl Dios ju'wa, ya otktzen cyiik' cycotz. Mintii'tl t-xel cye mas yaj. ");
INSERT INTO mamNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jatzen cyey, oj cyna'na Dios, cyocxa cyjunala tuj cyjay, bix tz'etz cylomo'na tlemel cyjay, bix chi na'na Cymana Dios min chic'aj. Ncye'yen ti'j cykilcaj yaa'n chic'aj cyu'n xjal, bix cxe'l tk'o'n t-xel cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ojtzen cyna'na Dios, mi'n txi' cymeltz'u'na nimc'a maj jax cyyola tisen nbint cyu'nj xjal yaa'n ocslal oj nchi na'n cydios. Tuj cywitz, cybi' cydios cyyol tu'n nim tken cyyol, pero yaa'n ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ju' tzunj, mi'n chi binchana tisenj cye, cuma te mitkna'x txi' cykanena te Cymana Dios, ya ttzki'ntlxin ti cyaja. ");
INSERT INTO mamNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chi na'na Dios tisen ja yec'bil lu: “Kman Dios ata tuj cya'j, nimsajxit tbiy cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kaja tu'n tul tcawbila twitz tx'otx'. Chi nimanxit cykilca xjal twitz tx'otx' tyola tisenx nnimja tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","K'ontza kwaya ja'lewe. ");
INSERT INTO mamNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bix najsanq'uey ja il o cub kbincha'na twitza, tisen keya ncub knajsa'na jka' o tz'oc cybincha'n xjal ki'ja. ");
INSERT INTO mamNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mi'n ko cub tk'o'na tuj kni'ya, sino cloma ko'ya tuj tk'ab taaw il, cuma jay cawel tibaj cykilca twitz tx'otx' bix tuj cya'j, bix at mas tipemala cywitz cykilca, bix jawnex tey tibaj cykilca te junx maj. Ju'xit ttena,” tz̈i cybela oj cyna'na Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ma che'x nxnak'tza'na ju'wa, cuma ka ma cub cynajsa'na cyil ke xjal o tz'oc cybincha'n ka' cyi'ja, jax ju'x te Cymana Dios tuj cya'j cwel tnajsa'nxin cyey cyil. ");
INSERT INTO mamNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero ka min ma cub cynajsa'na cyil xjal, jax ju'x mi'n cub tnajsa'n Cymana Dios cyila. ");
INSERT INTO mamNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Bix oj ncub cypa'na weyaj, mi'n txi' cyyeec'ana cywitza tisen nchi bisena, tisenx nbint cyu'n xmeletz' xjal. Cyaj tu'n tchic'ajax ka ncub cypa'n weyaj, bix ju' tzunj min nxi' cybincha'n cywitz, tu'ntzen bis cycye'nc. Jaxxix cxe'l nkba'na cyey, mintii'tl t-xel cye, cuma o'cx t-xel cye ma tz'oc cycye'yen xjal ejee'. ");
INSERT INTO mamNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jatzen cyey, ka ma cub cypa'na weyaj, cyk'onwexa c'oc'sbil cywi'y bix cytxjomela cywitza tisex cytena, ");
INSERT INTO mamNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tu'ntzen mi'n txi' cyyeec'ana cye xjal ka ncub cypa'na weyaj. Nuk o'cx twitz Cymana Dios min chic'aj cwel cypa'na weyaj. Bix cuma tzin tcye'yen Dios cykilcaj nbint tuj ewjel, ctzaal tk'o'nxin t-xel cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mi'n nuk tz'oc cyipena ti'j tchmoj k'inemala twitz tx'otx'. Nuk o'cx c'oquex poc' tuj te xitlte, bix pjel acumax, bix chi oquex alak' cyjay te k'ilbetzte. ");
INSERT INTO mamNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mas ba'n tu'n tbaj cychmo'na cyk'inemala te tuj cya'j, jaa' mlay tz'ocx poc' tuj te xitlte bix mi'n baj acumax bix min-al alak' ba'n tocx ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ka n-oc cyipena ti'j cyk'inemala te tuj cya'j, ja tzunj lu tzin tyeec'an at jcyajbila tuya ti taj Dios, pero ka nuk o'cx n-oc cyipena ti'j cyk'inemala te twitz tx'otx', ja tzunja nyeec'ante mintii' cyanema tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yaltzen te cynaabla, tisen tbak' cywitza. Nchi ajben tbak' cywitza tu'n cycye'yena. Ka ba'n tbak' cywitza, ba'ntzen cycye'yena alcyej cchic'ajaxel tu'n tken luz. ");
INSERT INTO mamNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero ka yaa'n ba'n tbak' cywitza, ete'y tuj klolj. Jaxse ju'x cynaabla. Ju' tzunj, ka tcy'i cynaabla tu'n cyela ba'n twitz Dios, tisen tuj nimxsen klolj ete'y. ");
INSERT INTO mamNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mlay tz'ajben jun ak'anal te ca'ba patrón. Ka ma tjoy tu'n tajben te jun patrón, cyjeltzen tk'o'n juntl. Bix ka jatz ma tak'a tiib tuya tcab patrón, cyjeltzen tk'o'n jxin tneel. Ju'tzen tten tuya Dios bix k'inemal. Ka tuya cykil cyc'u'ja nche'x lpey ti' k'inemal, mintzentii' cyaja tu'n cyajbena te Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Cuma ma tzaj tk'o'n Dios cychunk'lala, ju' tzunj cxe'l nkba'na cyey, mi'n chi labta ti'j cyway bix cyc'a'y tu'n cyitz'ja bix ti'j cyxbalena te cyxumlala. ¿Mimpa o tzaj tk'o'n Dios cychunk'lala ti'j mas nuk nchi waa'na? ¿Bix mimpa o tzaj tk'o'n Dios cyxumlala ti'j mas nuk n-oc cyxbalena? ");
INSERT INTO mamNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cycye'yenc ke ch'it twitz cya'j. Min nchi awanjil, bix min nchi jtx'onjil, bix min nchi chmonjil twitz awal tuj cytx'utx'jil. Pero nchi itz'jjil, cuma ntzaj tk'o'n Cymana Dios tuj cya'j cywajil. Yajtzen cyey, ¿yaa'mpa mas jawnexkey cywitz ch'it? ");
INSERT INTO mamNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿C'ajbelpa oj nchi labta ti' jun tii'? Mi nuket jun k'ij ba'n txi' cyk'o'na te cychunk'lala tu'nj nchi labta ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Tikentzen nchi labta ti' cyxbalena? Cycye'yenc kej abech. Ntz̈'iy, amale mint nchi chkon bix min nchi tz̈mon. ");
INSERT INTO mamNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero amale mint nchi labt ti'j cyxmaquel, pero cxe'l nkba'na cyey, mas cyeca cycye'nc twitzj jawnex t-xbalen jrey Salomón. ");
INSERT INTO mamNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ntzaj tk'o'n Dios cyxmaquel c'ul, amale nuket ca'ba oxe k'ij nten bix n-el tz'ak bix ncub patet. Yaltzen cyey, ¿yaa'mpa mas jawnexkey cywitz c'ul? Ejee'y yaa'n nimxix n-oc ke cyc'u'ja ti'j Dios. Ka ma tzaj tk'o'nxin cyxmaquel c'ul, jax ju'x ctzaal tk'o'nxin cyxbalena. ");
INSERT INTO mamNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ju' tzunj, mi'n chi labta ti'j ti tten tu'n cyitz'ja. Mi'n txi' cykba'na: “¿Ti cxe'l kwaa'na?” bix ka “¿Ti cxe'l kc'a'na?” bix ka “¿Jaa' ctzaal kxbalena?” ");
INSERT INTO mamNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mi'n chi tena tisen kej xjal yaa'n ttanem Dios, cuma nuk o'cx nchi labt ti'j cykilcaj lu. Mi'n chi labta, cuma ttzki'n Cymana Dios tuj cya'j najben cykilcaj lu cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mas il ti'j tu'n t-xi' cyk'on cyiiba ti'j tajbil Dios bix tu'n cytena jiquen twitzxin. Ka ma che'x lpey ti'j jlu, cykilcatzen najben tu'n cyitz'ja cxe'l k'o'n cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ju' tzunj, mi'n chi labta ti'j ti pjel nchi'j, cuma oj tpon nchi'j, otktzen pon tumel tu'n tiy'x jq'uixcaj te nchi'j cyu'na. O'cx tu'n tiy'x jn-oc cyi'ja ja'lewe—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Bix e xi' tkba'ntl Jesús cye t-xnak'atz: —Mi'n tz'oc cycye'yena ke xjal tu'n t-xi' cykba'na ka ka'ke xjal, tu'ntzen mi'n cub castiwa tu'n Dios cyibaja, ");
INSERT INTO mamNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","cuma ka ma chi yolena cyi' xjal tuya cyiw yol, jax tzul tk'o'n Dios cyiw yol cyey. N-oc tcye'yen Dios la' ti cyey nxi' cyk'o'n cye xjal, bix ctk'a' t-xel cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Tikentzen nyoleney ti'j jun tuyey tocx jun ni' tz'is tuj tbak' twitz, pero min tz'el tni'ya ti'j tuj tey tbak' twitz tocxe jun tzee'? ");
INSERT INTO mamNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Tikentzen nxi' tkba'na te tuyey: “Hermano, q'ueletz wii'na ni' tz'is tuj tbak' twitza,” tz̈iy, pero jey', lu jun tzee' tocx tuj tey twitza? ");
INSERT INTO mamNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jay at tpaltela, pero nbint tu'na tisenc'a mintii' tila. K'imetz jtey nejl jtzee' tocx tuj twitza, tu'ntzen ba'n tetz tii'na jte tuyey tocx tuj twitz. ");
INSERT INTO mamNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mi'n txi' cyk'o'na tyol Dios te cyej xjal min tz'oc tak' cye. Ka ma txi' cyk'o'na tyol Dios ju'wa, tisentzen nxi' cyk'o'na cye txyan jnajben te Dios, bix ka tisen ma txi' cyk'o'na cyk'inemala cywitz boch. Nuk pjel cywa'ben boch tu'n cyken, bix chi aal meltz'ajjil tu'n cybaj tzakena cyu'njil. ");
INSERT INTO mamNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Cykanenx te Dios tu'n ttzaj tk'o'n jnajben cyey, bix ctzaal k'o'n cyey. Cycubsanx cywitza te Dios, bix tzul tbi'n. Bix cytco'ncx tlemel tjaxin, tu'ntzen tjket cywitza. ");
INSERT INTO mamNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jaca juun xjal nxi' tkanen te Dios, ctzaaltzen tk'o'n Dios te, bix jaca juun xjal ncubsan twitz te Dios ti' onbilte, ctiik'eltzen, bix jaca juun xjal n-oc cytco'n tlemel jaa', cjketel twitz. ");
INSERT INTO mamNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ka ma txi' tkanen tcwal jun xjal twa, ¿atpa jun mambaj cyxola cxe'l tk'o'n jun xak te tcwal? Min. ");
INSERT INTO mamNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bix ka ma txi' tkanen jun quis̈, ¿lbajpa cxe'l tk'o'n tman te? Min. ");
INSERT INTO mamNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mlay cybinchay ju'wa. Amale aj iletkey, pero jaj ba'n cxe'l cyk'o'na cye cycwala. Yajtzen te Cymana tuj cya'j, ¿yaa'mpale masxsen jaj ba'n ctzaal tk'o'n cyey oj t-xi' cykanena? ");
INSERT INTO mamNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ju' tzunj, ka cyaja tu'n tbint jun ba'n cyey cyu'n xjal, ccybinchay jun ba'n cye, cuma ju' tzin tkba'n tley Moisés bix ju' e cykba tyolel Dios tuj tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ch'in twitz ttzii' tcawbil Dios, pero cyk'o'nc cyipena ti'j tu'n cyocxa tuj, cuma nim twitz ttzii' jbe nxi' tii'n ke xjal tuj k'ak', bix te nim twe' ja be'we, bix nim xjal nchi ocx tuj, cuma yaa'n cyiw tu'n cyocx. ");
INSERT INTO mamNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero ttzii' jbe nxi' tii'n ke xjal tu'n cypon tuj cychunk'lal tuya Dios, ch'in twitz, bix yaa'n nim xjal ncnet ja be lu cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Cyc'ojlam cyiiba cye kej xnak'tzal tyol Dios ẍtak' chi ul cyuyey. Ccyeec'a cyiib tisenc'a carnelke, pero xo'jke, bix cyaj tu'n cyxitja. ");
INSERT INTO mamNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tu'nj cybinchben q'uelel cyni'ya ti'j ti tten cyanem. ¿Jac'apa tz'el lo'pj te uva ti' jun skman ch'i'x, bix lo'pj te higo ti' jun tzee' at ch'utel? ");
INSERT INTO mamNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mlay. Jun tzee' ka' tzin tk'o'n twitz ka', bix jun tzee' ba'n tzin tk'o'n twitz ba'n. ");
INSERT INTO mamNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jun tzee' ba'n, mlay tak' twitz yaa'n ba'n. Bix jun tzee' yaa'n ba'n, mlay tak' twitz ba'n. ");
INSERT INTO mamNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jaca juun tzee', ka yaa'n ba'n twitz tzin tk'o'n, cjawel tx'omet bix c'oquex tuj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Cxe'l nkba'na cyey, q'uelel cyni'ya ti'j ka ba'n jun xjal bix ka yaa'n ba'n la' tii'n tbinchben. ");
INSERT INTO mamNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","At nim xjal tzin cykba'n weya, “Kaaw, Kaaw.” Pero yaa'n cykilcake chi oquex tuj cya'j. Nuk o'cx kej xjal tzin cybincha'n tajbil Nmana tuj cya'j chi oquex tuj tcawbilxin. ");
INSERT INTO mamNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tuj jk'ij tzul oj cyoc cykil xjal tuj xkela, nim xjal ctzaal tkba'n weya: “Taat, Taat, ¿mimpatzen e xi' kk'umena tyol Dios tu'n tipemal tey tbi? ¿Bix mimpatzen el kii'na biman cyi' xjal tu'n tipemal tey tbi? ¿Bix mimpatzen e kbinchaya nim ak'untl jawnex tuj taak'en Dios tu'n tipemal tey tbi?” tz̈i cybel. ");
INSERT INTO mamNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cxe'ltzen nkba'na cye: “Min ntzki'nkey. Cypa'mel cyiiba wi'ja, key binchal il,” tz̈i nbela. ");
INSERT INTO mamNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tu'n tpon baj twi' nyola, cxe'l nkba'na cyey jun techel. Jaca juun xjal tzin tbi'n nyola bix nbint tu'n, ja tzunja tisen jun xjal at tnaabl e jaw tbincha'n tja twi' xak cyiw. ");
INSERT INTO mamNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bix e cub nintzaj jbal, bix e jaw noj nima', bix e tzaj nim cyk'i'k, bix oc punntz'aj a' tuyax cyk'i'k ti' jaa'. Pero min iy' tz'ak jaa', cuma ba'nxix e cub k'ukbet twi' xak. ");
INSERT INTO mamNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero jaca juun xjal tzin tbi'n nyola pero min tniman, ja tzunja tisen jun xjal mintii' tnaabl e jaw tbincha'n tja tuj ttxa tz'a'n. ");
INSERT INTO mamNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bix e cub nintzaj jbal, bix e jaw noj nima', bix e tzaj nim cyk'i'k, bix oc punntz'aj a' tuyax cyk'i'k ti' jaa', bix iy' tz'ak jaa', bi'x e cub xitj cykilca—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tejtzen tbaj yolen Jesús, cykilca xjal e jaw klee' ti'j t-xnak'tzbilxin, ");
INSERT INTO mamNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","cuma e xnak'tzanxin tisen jun xjal tuya tipemal, yaa'n tisenj cyej xin tx'olbal ley. ");
INSERT INTO mamNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tejtzen tcu'tz Jesús twi' witz, nimxsen xjal oc lpe ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bix ul junxin xjal yaab. Otk tzaj k'ey t-xumlalxin tu'nj yabel lepra. Bix e cub majexin twitz Jesús, bix e xi' tkba'nxin: —Taat, ka taja, at tey tipemal tu'n tel tii'na jyabela wi'j—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Bix e xi' tnukpa Jesús tk'ab tibaj yaab, bix oc tmoco'nxin, bix e xi' tkba'nxin: —Wajwe. Cyajtey ba'n—tz̈ixin. Bix tujx naj t-xi' tk'umenxin, tzin ncyajtl jxin xjal ba'n. ");
INSERT INTO mamNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bix e xi' tkba'n Jesús texin: —Mi'n txi' tkba'na cye xjal ti ma baj ti'ja, sino cutxena tey, bix yeec'anx tiiba twitzj xin pala tu'n tel tniy' ti'j ka ma tzul tnaabla. Bix k'oncx jtoybila texin tisen o tkba Moisés, tu'ntzen t-xi' tkba'n pala cywitz xjal ya ma cyaja ba'ntla—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bix e xi' Jesús tuj tnom te Capernaum, bix tej tocxxin tuj tnom, e pon twitz Jesús junxin capitán cye soldado te Roma. Bix e cubsanxin twitz te Jesús: ");
INSERT INTO mamNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Taat, at jun wak'anala nim tajbel weya, pero ma yebt. Attzen njaya, bix min yucchtl t-xumlal. Nimxsen nchyon te—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Bix e xi' tkba'n Jesús texin: —Chin xe'la te k'anlte—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero e xi' ttzak'be'n capitán te Jesús: —Taat, mintii' wajbela twitza. Ju' tzunj, yaa'n tumel tu'n tocxa tuj njaya. Bix yaa'n il ti'j tu'n tula njaya tu'n tk'anj wak'anala. Nuk kbantza jyol, bix cyjel wak'anala ba'n. ");
INSERT INTO mamNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","N-el nni'ya ti'j o'cx tu'n tyola ba'n tbint tajbila, cuma jax ju'x weya o k'oj woclena te cawel. At nim soldado tjak' ncawbila. Ka ma txi' nkba'na te jun soldado, “Cutxey,” ka ntz̈iya, il ti'j cxe'l. Bix ka ma txi' nkba'na te juntl soldado, “Cyixtey,” ka ntz̈iya, jax il ti'j c'ulel. Jax ju'x ka ma txi' nkba'na te jun wak'anala, “Bincham jlu,” ka ntz̈iya, jax il ti'j cbinel tu'n—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tejtzen tbinte Jesús tyol capitán, e jaw klee'xin ti' capitán, bix e xi' tkba'nxin cyej xjal lepchec ti'jxin: —Jaxxix cxe'l nkba'na cyey, bajxsen wila jun aj Israel n-oc ke tc'u'j wi'ja tisen ja capitán lu yaa'n te Israel pero ma tz'oc ke tc'u'j wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bix cxe'l nkba'na cyey, cyxolj xjal chi temel cyxol ttanem Dios tuj tcawbil, at xjal te cykilca twitz tx'otx'. At te ocne bix at te elne, bix chi cwel ke ti' mes ttxlaj Abraham tuya Isaac bix tuya Jacob. ");
INSERT INTO mamNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero kej xjal te Israel, amale ttanemet Dios ejee' tuj cywitz, pero chi xe'l xoo'n tuj klolj te junx maj, jatztzen chi jawel ok', bix jatztzen cjawele kitx'itx'in t-xee' twitz cye—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bix e xi' tkba'n Jesús te capitán: —Cu txiy. Cbinel tey tisenj ma tocslay—tz̈ixin. Bix jaxj hora e k'anj t-ak'analxin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bix e xi' Jesús tja Pedro. Tej tponxin, e xi' tcye'yenxin otk yebt jxuj tjii' Pedro tu'n cyak. Tjaxxuj twi' wetbil. ");
INSERT INTO mamNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bix oc tmoco'nxin tk'abxuj, bix e chewex cyak tuj t-xumlalxuj. Bix e jaw we'tlxuj, bix ak'xuj k'olxte waabj texin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tejtzen tcu'x k'ij, e pon cyii'n xjal nim xjal otk tz'oc licy'paj biman cyi'j, bix el tlojo'nxin biman cyi' xjal nuk tu'nj tyolxin. Bix oc tk'a'nenxin cykilca xjal yaab e pon. ");
INSERT INTO mamNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ju'tzen tten el jaxxix jtyol Dios e tz'i'bet tu'n Isaías nbyan cyjulu: “Jaj xin Scy'o'n tu'n Dios q'uelel k'inte kyabel, bix q'uelel tii'nxin q'uixc'aj ki'j,” tz̈i tyolel Dios Isaías. ");
INSERT INTO mamNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tejtzen tlonte Jesús nimxsen tajlal xjal oc chmet ti'jxin, e xi' tkba'nxin cye t-xnak'atzxin tu'n cyiy'x jlajxe tnijabel a'. ");
INSERT INTO mamNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pero attzen junxin tx'olbal ley e xi' tkba'nxin te Jesús: —Xnak'tzal, chin xe'la tuyena nuk jaa'xja tu'n t-xi'y—tz̈i xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Pero e xi' tkba'n Jesús texin: —Kej ẍiwel at cyja t-xol xak bix kej ch'it at cyk'u'sem, pero jatzen tey, ka taja tz'oc lpey wi'ja, ilxix ti'j q'uelel tni'ya ti'j mintii' njaya bix nchin wutana te koniyan jaa' nchin poniya, inayena, ja Sma'n tu'n Dios tu'n ntena cyuya xjal—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Cyxol xjal chmo'n ti'j Jesús at juntl xjal e tajbe tu'n toc lpe ti'j Jesús. Pero e xi' tkba'nxin te Jesús: —Taat, najsama, waja nejl cwelex nmaku'na nmana—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero e xi' tkba'n Jesús texin: —Lpe'c'a wi'ja, bix k'oncja tu'n tcu'x cymaku'n cyimne cycyimne—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tejtzen tocx Jesús tuj barc, jax ju'x ocx ke t-xnak'atzxin tuj barc tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bix jey', e cub pok'ch naj jun nintzaj jbal bix cyk'i'k tibaj a'. Nimxsen oc punntz'aj a' tu'n cyk'i'k ti' barc, bix e noj barc tu'n a'. Pero te Jesús, nwutanxin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bix ul lk'e ke t-xnak'atzxin ttxlajxin, bix oc cyc'asenxin jaxin, bix e xi' cykba'nxin texin: —Taat, ¡ko tcla'y, cuma at tu'n kcyima! ");
INSERT INTO mamNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bix e xi' tkba'nxin cyexin: —¿Tikentzen cutzexsen ttz̈i cyi'ja? ¿Tiken min s-oc ke cyc'u'ja wi'ja?—tz̈ixin. Bix e jaw we'xin, bix e xi' tkba'nxin te cyk'i'k bix te tnijabel a' tu'n cywe'. Bi'x tzinenxsen e cyja'. ");
INSERT INTO mamNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bix e jaw we' ke t-xnak'atzxin, bix e xi' cykba'nxin: —¿Altzen loj jxjal lu? Hasta cyk'i'k bix a' ma tz'oc tilenxin, bix ma cybi—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tejtzen cyiy'x bajkexin juntl jlaj tnijabel a' tuj tnom te Gadara, etz ca'ba xinak tuj camposant bix oc nojkexin twitz Jesús. Otk chi oc nimxsen biman cyi'jxin, bix tu'n cyipemal biman, e k'ojlkexin ti' cykilca. Ju' tzunj, tu'n ttz̈i cyi'j aj Gadara, min e betke tuj be tcub ttzi camposant. ");
INSERT INTO mamNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tej toc cycye'yenxin Jesús, e jawxsen cys̈i'nxin, bix e xi' cykba'nxin: —¿Ti jilel tbinchaya ki'ja, jay Tcwal Dios? ¿Mapa tzula tu'n tbaj tyajla'na ejoo'ja te mina'x tpon tumel tu'n kxi'ya tuj q'uixc'aj?—tz̈i ke biman. ");
INSERT INTO mamNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nakchtzen ch'in ete' nimjil boch nchi waa'n. ");
INSERT INTO mamNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bix ak' ke biman cubsal cywitz twitz Jesús: —Ka ma tz'ex tlojo'na ejoo'ya cyuj xjal lu, ko ttzakpi'cxa cyxol jil boch luwe—tz̈i ke biman. ");
INSERT INTO mamNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Bix e xi' tkba'nxin cyexin: —Cyucxey. Bix el ke biman cyi'j xin xjal, bixsen ocxke tuj cyxumlal boch. Bix jey', e xi' ajkelkejil tc'u'j witz tuj tnijabel a', bix e jaw jik'bekejil. ");
INSERT INTO mamNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yal tzunkej xjal cylel boch, bix e xi' okke tuj tnom. Bix e xi' cyk'umen cykilca otk baj, bix ti e baj cyej xjal otk chi el biman cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bix cykilca xjal tuj tnom etz te cyey'lte Jesús, bix tej t-xi' cycye'yen jaxin, ak'kexin cubsal cywitzxin te Jesús tu'n tiy'xin tuj cytanemxin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Bix ocx Jesús tuj barc, bix iy'x jlajxe tnijabel a', bix e ponxin tuj jtnom jaa' e najanaxin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tejtzen tponxin tuj ttanemxin te Capernaum, ul jun cloj xjal iken jun yaab twi' jun wetbil. Mintii' tanem t-xumlal. Tej tzunj toc tcye'yenxin k'uklec cyc'u'j xjal ti'jxin, e xi' tkba'nxin tej xin yaab: —Ncwal, nimsam tc'u'ja. Ma najset tila—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tejtzen cybinte ke tx'olbal ley ja yol ka otk najset til yaab tu'n Jesús, ak'kexin yolel cyxolxxin: —Ja xjal lu n-oc tk'on tiib te Dios. Ncub t-xniy'be'nxin ka Diosxin—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero el tniy' Jesús ti'j jka' iy' tuj cyc'u'jxin, bix e xi' tkanenxin: —¿Tikentzen nxi' cyximana tuj cyanema ka' kena bix mlay bint wu'na tu'n tnajset cyil xjal? ");
INSERT INTO mamNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tuj cywitza, ¿alcyej yol mas secy tyol jilj tu'n t-xi' nkba'na tej yaaba, japaj “Ma najset tila,” bix ma jaj “We'wetzen tey bix cutxetzen tjay”? ");
INSERT INTO mamNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Te weya, junx ta'. Tu'n tel cyni'ya ti'j at wipemala tu'n tcub nnajsa'na cyil xjal, cwel nk'anena ja yaab lu—tz̈i Jesús cye tx'olbal ley. Bix e xi' tkba'nxin te yaab: —We'wetzen tey, k'inx twetbila, bix cutxetzen tjay—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bix e jaw we' yaab, bix e jaw tii'n twetbil, bix aj tja. ");
INSERT INTO mamNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yaltzen kej xjal otk chi chmet ti'jxin, tej cylonte ti e baj, nimxsen e jaw klee'ke, bix e jaw cynimsa'n tbi Dios, cuma otk tzaj tk'o'nxin tipemalxin te jun xjal tu'n tbint jlu tu'n. ");
INSERT INTO mamNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tbajlenxittzen ju'wa, bix e xi' tbeten Jesús juntl tkiy'. Bix tej texxin twitz jun jaa' jaa' ete'c'a kej xin chmol chojentj, e xi' tcye'yenxin tunwen k'uklecx jxin Mateo. Bix e xi' tkba'nxin te Mateo: —Lpetz tey wi'ja, tu'ntzen toca te nxnak'atza. Bix e jaw we' Mateo, bix oc lpe ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mas yaj, tej tcub ke Jesús cyuya t-xnak'atz lepch ti'jxin ti' mes tuj tja Mateo, jax nim chmol alcabala bix nim xjal yaa'n ba'n tuj cywitz aj fariseo e pon te waa'l cyuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tej toc cycye'yen fariseo nwaa'ncx Jesús cyuya kej xjal yuwin tuj cywitz fariseo, e xi' cykanenxin cye t-xnak'atzxin: —¿Tikentzen nwaa'ncx jxin xnak'tzal cyey cyuyaj chmol alcabala bix tuya mastl aj il?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pero e tbi Jesús ja yol lu, bix e xi' tkba'nxin cye fariseo: —Kej xjal ba'n min che'xcye tuya k'anel. Nuk o'cx kej xjal yaab nche'x tuya k'anel. ");
INSERT INTO mamNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","At jun tyol Dios tzin tkba'n cyjulu: “Waja tu'n toc k'ak'en cyc'u'ja cyi' xjal, yaa'n nuk o'cx cyoybila,” tz̈i Dios tuj tyol. K'o'nc cyipena ti'j tu'n tel cyni'ya ti'j ti japenina ja yol lu, cuma min ma chin ul weya te txcolte cyej xjal mintii' cyil tuj cywitz, sino te cyej xjal aj il tuj cywitz tu'n cymeltz'aj—tz̈ixin cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yajc'atl, bix e pon tuya Jesús cab xjal lepchec ti'j Juan Bautista, bix e xi' cykba'nxin texin: —Ncub kpa'na weyaj bix ncub cypa'n aj fariseo weyaj. Pero kej tey t-xnak'atza, ¿tikentzen min ncub cypa'n weyaj?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bix aj ttzak'be'n Jesús: —Oj nchi pon xjal ti' mejoblenel, ¿cwelpa cypa'n weyaj? Min, cuma tumel tu'n cyiy'san xjal tuya chmilbaj. Ju'tzen cye nxnak'atza. Tisen nchi tzalaj ke xjal tuya chmilbaj, ju'xse nchi tzalaj ke nxnak'atza wuyena, cuma ntiina cyuya. Mas yaj, oj wel k'i'na cyi'j, chi cyjeltzen tuj bis, bix cweltzele cypa'n weyaj. ");
INSERT INTO mamNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Min-al jun xjal jac'a jatz tii'n jun tkiy' remyent ti' jun ac'aj xbalen tu'n tcu'x te remyent ti' jun xbalen k'anak, cuma mas q'uelex rotj k'anak tu'n ac'aj oj toc yut'paj. ");
INSERT INTO mamNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jax min-al jun xjal cwel tk'o'n vino ac'aj tuj jun tz'u'n k'anak, cuma ka ma cub tk'o'n ju'wa, q'uelel rotj tz'u'n tu'n vino oj tel ipc'aj, bix q'uelel kojl vino, bix cxe'l tz'u'n tuj il. Cwel cyk'eysa'n xjal ac'aj vino tuj ac'aj tz'u'n, tu'ntzen mi'n tz'ex rotj tz'u'n, bix tu'n mi'n tz'el koj vino. Jaxse ju'x weya nxnak'tzbila. Ac'aj nxnak'tzbila, bix mlay tz'ocx k'anak xnak'tzbil te ootxa tuj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mitkna'x tbaj yolen Jesús tej tpon twitz junxin xjal cawel cyxolj xjal e chmet tuj camon jaa' xnak'tzbil tyol Dios. E cub mejtz'ajxin twitz Jesús, bix e xi' tkba'nxin te: —Ja'lecuwe xcyim nmeela. Najsama, quixta wuyena bix k'a'c'a tk'aba tibajtxin tu'n titz'jtltxin—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Bix e tcuya Jesús bix oc lpe ti'j cawel cyuya t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pero jey', at junxuj xuuj e pon lk'e tzalti'jxin, bix oc tmoco'nxuj ttxa'n t-xbalenxin. Otk bint cablaaj jnabk'i tak'lenxuj tu'n cyak a' ti'jxuj. ");
INSERT INTO mamNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bix iy' tuj tc'u'jxuj: —Nuketle oj toc nmoco'na t-xbalenxin, ya tzultzen nnaabla—tz̈i tzunxuj. ");
INSERT INTO mamNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero aj meltz'aj Jesús, bix e xi' tcye'yenxin jaxuj, bix e xi' tkba'nxin texuj: —Tey xuuj, nimsam tc'u'ja. Tu'nj s-oc ke tc'u'ja wi'ja, ma tzul tnaabla—tz̈i tzunxin. Bix texsen hora e we'tl tyabelxuj. ");
INSERT INTO mamNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tejtzen tocx Jesús tuj tja cawel tuj camon jaa', bix tej t-xi' tcye'yenxin n-oc xux cyu'n xjal bix nim ook'el nbaj, ");
INSERT INTO mamNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","e xi' tkba'nxin cye xjal: —Cyexa, cuma min ma cyim tej txin cwala. Nuk nwutantxin—tz̈ixin. Bix e jaw tze'n ke xjal ti'jxin, cuma el cyniy' ti'j otk cyimtxin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero tej cyetz lojo'n xjal pe'n, ocxxin tuj cwart jaa' tocxe nee', bix e tzaj ttzyu'nxin tk'abtxin, bix e jaw twa'baxin jatxin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Bix eltzen tpocbal jlu tuj cykil lugar. ");
INSERT INTO mamNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tejtzen tex Jesús tuj ja jaa' lu, oc lpe ca'ba xjal mos̈ ti'jxin. Bix e jaw s̈i'nke: —¡Jay tiy'jil jrey David, k'ak'entz tc'u'ja ki'ja! ");
INSERT INTO mamNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bix ocx Jesús tuj jun jaa', bix oc lpekexin tuyaxin tunwen. Bix e xi' tkba'nxin cyexin: —¿Mapa tz'oc ke cyc'u'ja wi'ja ka ba'n wu'na tu'n tcub nk'anena ejee'y? Bix aj cytzak'be'nxin: —Ma tz'oc ke kc'u'ja ti'ja, Taat. ");
INSERT INTO mamNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Octzen tmoco'nxin tbak' cywitzxin, bix e xi' tkba'nxin: —Chi k'anxita tu'nj n-oc ke cyc'u'ja wi'ja—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bix ul tnaabl tbak' cywitzxin. Bix tuya cyiw yol e xi' tkba'nxin cyexin: —Ten cycwenta ti'j tu'n mi'n cybi xjal ti ma baj cyi'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero tej cyexxin tuj jaa', el cyk'umenxin tuj cykil lugar tpocbal ti otk bint tu'n Jesús cyi'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Matkxsen cyexlen ca'ba mos̈, tpon k'i'n jun xjal men twitz Jesús. Min bintl tyolen tu'nj biman otk tz'oc ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tej tel tlojo'n Jesús biman ti' xjal men, nbintltzen tyolen xinak. Bix e jawxsen klee' cykilca xjal ti'j, bix e xi' cykba'n: —Bajxsen tz'oca kcye'yen jun maj tisenj lu kxol aj Israel—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero ejee'tzen kej xjal fariseo e xi' cykba'n: —Tipemal jxjal luwe tu'n tel tlojo'n biman yaa'n te Dios, sino o k'oj te tu'n cawel cye biman—tz̈i ke fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","E baj tbete Jesús tuj cykilca tnom bix aldea, bix e xi' tk'o'nxin t-xnak'tzbil cyuj camon jaa' bix e xi' tk'umenxin jtbanel tpocbal tcawbil Dios. Bix jaa'xja e ponaxin, e cub tk'anexin cykilca wik cyyabel xjal bix nuk alcyexja q'uixc'aj toc cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tuj cykil lugar, tej toc tcye'yenxin ke xjal, oc k'a'ben tc'u'jxin cyi'j, cuma cyiw ta' cychunk'lal bix mintii' onbil cye, tisen jun cloj carnel min-al cylel cye. ");
INSERT INTO mamNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Bix e xi' tkba'nxin cye t-xnak'atzxin: —Jtaak'en Dios cyi' xjal tisen jun jaatx'en. Nimxsen jaatx'en, pero yaa'n nimxix ak'anal at te chmolte. ");
INSERT INTO mamNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ju' tzunj, cykanenx te Taaw ak'untl tu'n t-xi' tsma'nxin ak'anal te chmolte twitz awal—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Bix e cub tchmo'n Jesús kej cablaaj t-xnak'atz, bix e xi' tk'o'nxin tipemalxin cye tu'n tel cylojo'n biman cyi' xjal bix tu'n cyk'anenxin ti' cykilca wik cyyabel xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ejee'tzen xinj e tsicy' Jesús te t-xel, ejee'j xin lu: Tneel, ja Simón, jxjal oc tbi te Pedro tu'n Jesús, bix tuyax Andrés, titz'en Simón, tuya Jacobo, tcwal jxin Zebedeo, tuya Juan, titz'en Jacobo, ");
INSERT INTO mamNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tuya Felipe, tuya Bartolomé, tuya Tomás, tuya Mateo, jxin chmol alcabala, tuya Jacobo, tcwal jxin Alfeo, tuya Tadeo, ");
INSERT INTO mamNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","tuya Simón, jxjal tocx te jun cloj Cananeo tbi, tuya Judas Iscariote, jxjal e xi' tq'ueyen Jesús mas yaj. ");
INSERT INTO mamNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ejee' tzunj cablaaj xjal e xi' tchk'o'n Jesús te binchalte taak'en. Pero tneelxix, e xi' tkba'nxin cyexin: —Mi'n che'xa cyxol kej xjal yaa'n judío, bix mi'n chi ocxa tuj cytanem aj Samaria. ");
INSERT INTO mamNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nuk o'cx chi xe'la cyxol kej aj Israel o chi tzpet. ");
INSERT INTO mamNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ojtzen cyxi'y, cyk'umenx cye xjal cyjulu: “Tzul lk'e tcawbil Dios tzul tuj cya'j,” tz̈i cybela. ");
INSERT INTO mamNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cyk'anenx kej xjal yaab. Chi jawetz cyitz'jsa'na kej xjal cyimne tuj cyamecy. Cyk'anenx kej xjal ma tz'el k'ey cyk'ab bix cyken tu'nj yabel lepra. Q'uelel cylojo'na biman cyi'j xjal ma chi oc biman cyi'j. Bix mi'n chi kanena pwak cye xjal oj tcub cyk'anena, cuma nuk cotz jwipemala ma cyiik'a. ");
INSERT INTO mamNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mi'n txi' cyii'na pwak, mi nuket oro bix ka plata bix ka cobre tu'n cyitz'ja. ");
INSERT INTO mamNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Bix mi'n txi' cyii'na cypay tuj be, mi nuket cych'ixpubla cyi'ja, mi nuket juntl moj cyxaaba, mi nuket juntl cybardona te tcab, cuma il ti'j tu'n tk'oj twa jun t-ak'anal Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Oj cyocxa tuj jun tnom bix ka tuj jun aldea, cykanenx cye xjal ka at jun xjal at tajbil tu'n tk'on posada cye t-ak'anal Dios, bix chi cyjela tuya ojxe cyi'ya tuj ja tnoma. ");
INSERT INTO mamNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Oj cyocxa tuj jaa' jaa' tumel chi wutala, nejl cxe'l cyk'o'na jun k'olbebl te cykilca xjal tuj jaa'. ");
INSERT INTO mamNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ka ma tiik' taaw jaa' ejee'y tuya cykil tc'u'j, tzajxit cyk'o'na cyxtalbila te. Pero ka tcy'i ejee'y, mi'n txi' cyk'o'na cyxtalbila te. ");
INSERT INTO mamNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ka at xjal cycy'i ejee'y bix ka ma tz'el cyxoo'n cyyola, oj cyi'ya tuj cyja bix ka tuj cytanem, cytz̈toncjtzen kuk ti' cyxaaba cywitz, te yec'bil min chi k'umentla tyol Dios cyxol. ");
INSERT INTO mamNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jaxxix cxe'l nkba'na cyey, tuj jk'ij te castiwa tzul, mas castiwa tzul tk'o'n Dios cyej tnom n-el cyiiq'uen tk'umj tyolxin twitzj e cub tk'o'nxin cyibaj ka' tnom te Sodoma tuyax tnom te Gomorra jatxe ootxa. ");
INSERT INTO mamNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Q'ueleltzen cyni'ya ti'j ejee'y nuk cyisen tal carnel bix chi xe'l nsma'na cyxolj xjal cyisen xo'j. Ju' tzunj, chi tena ẍbi'l tisen lbaj, pero jax chi tena tisen cucu'. Mi'n cybinchay ka' cyi' xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cyc'ojlamxix cyiiba cye xjal, cuma chi xe'l k'o'na cywitz juez nuk wi'jc'a, bix cxe'l cyk'o'n tz'u'n cyi'ja cyuj cycamon jaa'. ");
INSERT INTO mamNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hasta cywitz gobernador bix cywitz rey chi xe'l chk'eta nuk wi'jc'a, tu'ntzen tk'umj nbi'ya cyexin bix cyej xjal yaa'n judío. ");
INSERT INTO mamNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero oj cytzyeta, mi'n chi labta ti'j ti tten tu'n cyclon cyiiba bix ti'j alcye yol tu'n t-xi' cykba'na cywitz cawel, cuma oj tpon tumel, chi xe'l onet cyey ti' cyyola. ");
INSERT INTO mamNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yaa'n ti' cywi'y ctzaala cyyola, sino ja te Espíritu Santo k'o'n cyey tu'n Cymana Dios cxe'l k'onte cyyola. ");
INSERT INTO mamNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tzul jun k'ij at xjal cyitz'en cyiib bix jun cxe'l q'ueyente juntl tuj cyk'ab cawel tu'n cybyet, bix jax cxe'l cyq'ueyen cyman ke cycwal tu'n cybyet. Bix ke cwal chi oquel k'ojl cyi' cyman, bix chi oquel cyipen ti'j tu'n cybyet cyman. ");
INSERT INTO mamNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Cykilca xjal q'uelel cyiiq'uen ejee'y tu'nj cyk'on cyiiba wuyena. Pero alj xjal mi'n cyaj tcye'yen inayena, amale n-oquet cyiw q'uixc'aj ti'j, cleteltzen tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ka ma chi yajlaja tuj jun tnom, cyiy' oka tuj juntl tnom. Pero jaxxix cxe'l nkba'na cyey, mitkna'x t-xi' cyk'umena tyol Dios tuj cykilca tnom te Israel oj wul meltz'aja, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yaa'n ejee'y mas jawnex nwitza, tisen jun xjal nxnak'tzan yaa'n mas jawnex twitz tmaystro, bix jun ak'anal yaa'n mas jawnex twitz tpatrón. ");
INSERT INTO mamNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jnbaj ti' jun maystro, jax nbaj ti' t-xnak'atz. Bix jnbaj ti' jun patrón, jax nbaj ti' t-ak'anal. Ju' tzunj, jcbinel wi'ja cyu'n xjal, jax cbinel cyi'ja. Ma tz'oc cyk'o'n xjal nbi'ya te Cyaaw biman. Katzen ju' ma cykba xjal wi'ja, jaxse ju'x c'oquel cyyasen xjal ejee'y. ");
INSERT INTO mamNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ju' tzunj, tu'n cyajbena weya, mi'n tzaj cytz̈i kej yasel xjal cyi'ja. Jjaxxix yol e'wen ja'lewe, ilxsen ti'j tu'n tk'umj. ");
INSERT INTO mamNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jnxi' nkba'na cyey oj nko tena kjunal, q'uelex cypocba'na tuj cykil lugar. Bix jnxi' njasena cyey ja'lewe tuj ewjel, cyk'umenx te cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mi'n tzaj cytz̈i cyi'ja kej xjal pjel cybyo'n cyxumlala. O'cx jlu cbinel cyu'n, pero mintii' cyipemal tu'n tcub cyanema cyu'n. Mas il ti'j tu'n ttzaj ttz̈i Dios cyi'ja, jaj xjal at tipemal tu'n tcu'x tk'o'n cyxumlala tuyax cyanema tuj k'ak' te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ncye'yen Dios cykilcaj nbaj cyi'ja. C'oquel cyc'u'ja cyi'j tal ch'it. ¿Mimpatii' nq'ueyj ca'ba tu'n nuk jun centavo? Pero amale yaa'nt nim cywi', mi nuk jun cwel tz'ak twitz tx'otx' bix mint n-oc tcye'yen Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yajtzen cyey, ¿chi elelpey tuj tc'u'j Dios? Min. Hasta ttzmal cywi'y ttzki'n Dios jte'. ");
INSERT INTO mamNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ju' tzunj, mi'n tzaj ttz̈i jcbinel cyi'ja, cuma at mas cyajbela cywitz nim ch'it. ");
INSERT INTO mamNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kej xjal tzin cykba'n cywitz xjal ka lepchecke wi'ja, cxe'ltzen nk'umena twitz Nmana tuj cya'j ka ejee'tzen nxjalja. ");
INSERT INTO mamNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero kej xjal cycy'i cykba cywitz xjal ka lepchecke wi'ja, cxe'ltzen nkba'na twitz Nmana tuj cya'j ka yaa'n ejee'ja weya. ");
INSERT INTO mamNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mi'n cub cybisena in ula twitz tx'otx' tu'n twe' cykil k'oj wu'na. Yaa'n ju'wa, sino in ula k'ol k'oj cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","In ula k'ol k'oj jk'a cwal tuya tmank'a, bix jtxin cwal tuya ttxutxin, bix jtxin elibj tuya tliibtxin. ");
INSERT INTO mamNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kej tuj tja jun xjal, chi oqueltzen te aj k'oj ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Alcyej xjal taj tz'oc lpe wi'ja, pero mas n-oc tak' tman bix ka ttxu te nwitza, mlay tz'oc te nxnak'atza. Bix alcyej xjal mas n-oc tak' tcy'aal te bix ka tmeel, mlay tz'oc te nxnak'atza. ");
INSERT INTO mamNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bix alcyej xjal yaa'n binne tten tu'n tiy'x q'uixc'aj bix ch'ixbajil tu'n tu'n toc lpe wi'ja, mlay tz'oc te nxnak'atza. ");
INSERT INTO mamNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ja tzunj xjal tcy'i tz'oc lpe wi'ja cuma at cytz̈i kej xjal ti'j cyaj tu'n tcub, cxe'l t-xoo'n tchunk'lal. Pero ja tzunj xjal cyjel tk'o'n tchunk'lal te twitz tx'otx' tu'nj lepchec wi'ja, ctcamantzen tchunk'lal te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Chi xe'la te nxela, bix alcye xjal c'oquel tbi'n cyyola, jax n-oc tbi'n jweya. Bix alcye xjal c'ocslal wi'ja, jax n-ocslan ti'j Dios e tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Alcyej xjal ctk'a' posada cyey cuma jaxxix tyolel Dioskey tuj twitz, ctzaaltzen k'o'n te jaxj cotz ntzaj k'o'n cye tyolel Dios. Bix alcyej xjal ctk'a' tk'olbebl cyey cuma jiquenkey tuj twitz, ctzaaltzen k'o'n te jaxj cotz ntzaj k'o'n cyej xjal jiquen. ");
INSERT INTO mamNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bix alcye jun xjal ctzaal onente cyey cuma nxnak'atzkey tuj twitz, amale nuket jun vas a' tzaj tk'o'n te cyey, bix ka ma tzaj tk'o'n te jun mas ch'in cyxola, il ti'j ctzaal k'o'n tcotz—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tejtzen tbaj tkba'n Jesús ja xnak'tzbil lu cyej cablaaj t-xnak'atzxin, iy'tzen tuj ja lugar lu bix e xi'xin xnak'tzal cyuj cytanem judío. ");
INSERT INTO mamNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yaltzen te Juan Bautista tocx tuj tzee', tej tbinte cykilcaj e bint tu'n Cristo, e xi' tsma'nxin ca'ba xjal lepchec ti'j t-xnak'tzbilxin, tu'n cypon tuya Cristo. ");
INSERT INTO mamNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bix e xi' cykanenxin te Jesús: —¿Japa tey Jscy'o'n tu'n Dios tu'n tul te cawel, bix ka at juntl ko ayola ti'j tu'n tul?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bix aj ttzak'be'n Jesús cyexin: —Cyucxey tuya Juan bix cykbanx texin jaj ma cybiy bix jaj ma cyila nbint wu'na. ");
INSERT INTO mamNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kej mos̈ ya lutlke nchi cye'yena. Kej cox ya lutlke nchi bete. Kej xjal ma k'ey cyk'ab bix cyken tu'nj yabel lepra, ma k'anj. Kej chquint ya niy'xtl tuj cywi'. Kej cyimne ma chi jaw itz'j juntl maj. Bix kej mebe lu n-oc cybi'n ba'n tpocbal colbil cye. ");
INSERT INTO mamNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Cyk'umenx te Juan ctzaal tk'o'n Dios t-xtalbil cyej xjal min baj cyc'u'j wi'ja, bix min cyaj cyk'o'n tu'n cyxi' lpe wi'ja—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tej cyex tsanjel Juan, ak'tzen Jesús yolel cye xjal, bix nim ba'n yol e xi' tkba'nxin ti' Juan. E xi' tkba'nxin: —Tej cyxi'y te cyey'lecte Juan ttzii' nima' Jordán, ¿e pompakey cuma e cyajbey tu'n toc cybi'na jun xjal yaa'n cyiw tnaabl, tisen jun ptz'unt nbaj lajpaj tu'n cyk'i'k? Min. ");
INSERT INTO mamNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Bix e pompakey nuk te cyey'lecte t-xbalen jawnex? Min. Cykilcakey cytzki'na nuk ejee' cyej xjal k'ina tuj nin tja cawel n-oc jawnex xbalen cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Bix e pompakey te cyey'lecte jun tyolel Dios? Jaxte jun tyolel Dios Juan, bix cxe'l nkba'na cyey, yaa'n nuk o'cx jun tyolel Dios Juan, sino atl mas. ");
INSERT INTO mamNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tzin tkba'n tyol Dios cyjulu: “E tkba Dios te Tcwal: ‘Cxe'l nsma'na nsanjela nejl twitza, tu'ntzen binne cyten xjal oj tpona twitz tx'otx',’ tz̈i Dios te Tcwal,” tz̈i tyol Dios. Ma japan baj twi' ja tyol Dios lu tu'n Juan. ");
INSERT INTO mamNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jaxxix cxe'l nkba'na cyey, cyxol tyolel Dios o ten twitz tx'otx', min-al jun mas jawnex twitzj Juan. Pero jxjal mas ch'in tuj tcawbil Dios mas jawnex twitzj Juan. ");
INSERT INTO mamNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","At nim tajbel taak'en Juan Bautista, cuma jatxe tej tak' Juan kbalte hasta ja'lewe, ma tz'oc cyipen nim xjal ti'j tu'n cyocx tuj tcawbil Dios, bix tuya cykil cyc'u'j nchi ocx xjal tuj. ");
INSERT INTO mamNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Cykilca tyol Dios te ootxa e tkba at tu'n tul Elías juntl maj, bix ja Juan ul. ");
INSERT INTO mamNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ka cyaja tu'n cyocslana tyol Juan, ja Juan tisen Elías, jtyolel Dios at tu'n tul. ");
INSERT INTO mamNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Cyjkom cyẍquina tu'n tel cyni'ya ti'j nyola, bix cybisenx ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Key xjal n-el cyiiq'uena j-e tk'umen Juan bix jnxi' nk'umena, ¿ti techel c'ajbel tu'n tel cyni'ya ti'j ti cytena? Ejee' tzuna tisen kej nee' tuj be cycy'i tu'n cykẍan cyuya kej nchi kẍan. Oj cykẍan kej nee' tisen ti' jun mejoblenel, cxe'l cykba'n cyekej cycy'i chi kẍan cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Keya, n-oc kxuxen. Cyey, ¿ti min chi tzaja te bixel kuyena?” tz̈ike. Bix oj cykẍan kej nchi kẍan tisen oj ncu'x maket jun cyimne, cxe'l cykba'n cyekej cycy'i tu'n cykẍan cyjulu: “Keya, nko ook'a. Cyey, ¿ti min chi tzaja te ook'el kuyena?” tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ejee'y tisenj kej nee' cycy'i chi kẍan, cuma tej tul Juan bix min ex tk'ij nwaa'n bix nc'an, e xi' cykba'na, “Jxjal lu ma tz'oc jun biman ti'j, cuma min bint tu'n tisenj nbint cyu'n cykilca. Min tz'ajben tyol,” tz̈ikey. ");
INSERT INTO mamNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pero tej tul jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal, bix min e cub npa'nwe weyaj tisen Juan, sino in waa'nwe bix in c'anwe tisex tten, tzin cykba'na, “Jey', jxjal lu min cub tpa'n weyaj tisen tten kxol, sino nuk nwaa'n bix nc'an vino bix nbet cyuya chmol alcabala bix cyuya niy'tl aj il. Il ti'j q'uelel kiiq'uen tyol,” tz̈ikey. Pero cchic'ajaxeltzen alcye kej xjal at cynaabl tu'nj alcyej chi ocslal tyol Juan bix weya nyol—tz̈i Jesús cyej xjal el cyxoo'n jaxin bix tyol Juan. ");
INSERT INTO mamNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bix oc ten Jesús ilel ti'j kej tnom min e meltz'aj tuya Dios, amale nimxsen otk tyeec'anxin tipemalxin cyuj. ");
INSERT INTO mamNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","E xi' tkba'nxin: —¡Ayxsen kej judío te Corazín! ¡Bix ayxsen kej judío te Betsaida! O tz'el cyiiq'uen tyol Dios, amale nimet e yec'j wipemala cyuj tzunj tnom lu. Nuket e yec'j jwipemala cyej aj il yaa'n judío cyuj tnom te Tiro bix Sidón, ya otetle tz'oc cyk'o'n cyxbalen te bisbajil bix otetle chi cub ke tuj tza'j te techel ete'tzen tuj bis tu'n cyil. ");
INSERT INTO mamNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jaxte min e meltz'aj tuya Dios, pero cxe'l nkba'na cyey, tuj jk'ij te castiwa tzul, mas castiwa tzul tk'o'n Dios cyej xjal aj Corazín bix cyej xjal aj Betsaida twitzj tzul tk'o'nxin cyej xjal te Tiro bix cyej xjal te Sidón. ");
INSERT INTO mamNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yaltzen cyej xjal te tnom te Capernaum, tuj cywitz ba'nxsen chi elel twitz Dios bix chi camal jun jawnex lugar tuya Dios tuj cya'j, pero yaa'n ju'wa. Chi cwel baj tuj ch'ixbajil tuj k'ak'. Nuket e yec'j jwipemala cyej xjal tuj tnom te Sodoma tisen ma yec'j cyxola, at-xetle tnom te Sodoma ja'lewe. ");
INSERT INTO mamNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jaxte min e meltz'aj tuya Dios, pero cxe'l nkba'na cyey, tuj jk'ij te castiwa tzul, mas castiwa tzul tk'o'n Dios cyey twitzj tzul tk'o'nxin cyej xjal te Sodoma—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tuj ja tyem lu, e na'n Jesús Dios. E xi' tkba'nxin: —Taat Nmana, jay taaw tibaj cykilca tuj cya'j bix tibaj cykilca twitz tx'otx'. Bix nxi' nk'o'na chjonte tey ti'j e cub tninc'u'na ti'j tcawbila e'wen tu'na te cyej xjal nimxsen ba'n cyu'n tuj cywitz, pero te cyej xjal ajnintz cynaabl tisen ke nee', o txi' tk'o'na tu'n tel cyniy' ti'j ti tten tcawbila. ");
INSERT INTO mamNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ju'tzen o bint tu'na, cuma ju' tajbila—tz̈i Jesús te Tman. ");
INSERT INTO mamNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bix e xi' tkba'n Jesús cye xjal: —O tzaj tk'o'n Nmana cykilca at tuj nk'aba. Min-al ttzki'n inayena, Tcwal Dios. Nuk o'cx Nmana ttzki'n inayena. Bix min-al ttzki'n Nmana. Nuk o'cx inayena ntzki'na Nmana, bix kej xjal waja tu'n t-xi' nyeec'ana Nmana cye, tu'n tel cyniy' ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Key xjal ma chi sicta tjak' cyiketza te cyiw ley, chi ocslana wi'ja, bix cxe'l nk'o'na cyajlabla te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chi eletza tjak' cyiketza al, bix cyii'nxa nxnak'tzbila. Cyxnak'tzamel cyiiba wi'ja, cuma yaa'n cyiw nxnak'tzbila bix maans kena, bix ctemeltzen cyajlabla. ");
INSERT INTO mamNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yaa'n cyiw nxnak'tzbila, bix yaa'n al cyiketza oj t-xi' cyii'na nxnak'tzbila—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Te jun k'ij te ajlabl, ex bet Jesús tuj triwa cyuya t-xnak'atzxin. Oc tak' weyaj cye t-xnak'atzxin, bix ak'kexin piẍc'ulbilte twitz triwa, bix e xi' cywaa'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pero tej toc cycye'yen kej aj fariseo jlu, e xi' cykba'n te Jesús: —Tzin tkba'n ley yaa'n tumel tu'n kak'anan tuj k'ij te ajlabl, pero kej tey t-xnak'atza, ma tz'el cyii'n twitz triwa—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero e xi' tkba'n Jesús cyexin: —¿Bajxpatzen txa' cycye'yena tuj tyol Dios ti e baj te jxin kiy'jil David cyuya ke tuyaxin tej toc nim tak' weyaj cyexin jun maj? ");
INSERT INTO mamNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ocx David tuj nin tja Dios, bix e xi' twaa'n jpan k'o'n te Dios. Amale tzint tkba'n ley ja xjan pan lu o'cx te cyej xin pala ba'n t-xi' cywaa'nxin, pero e xi' cywaa'n David. ");
INSERT INTO mamNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bix at juntl. ¿Bajxpa txa' cycye'yena tuj ley ke pala tuj tja Dios nchi ak'anan tuj k'ij te ajlabl bix mintii' cyil ti'j? ");
INSERT INTO mamNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Cxe'l nkba'na cyey, mas nintzaj inayena twitz tja Dios. Bix yaa'n tjak' ley te ajlabl tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tzin tkba'n tyol Dios cyjulu: “Waja tu'n tk'ak'en cyc'u'ja cyi' cabtl, yaa'n nuk o'cx cyoybila weya,” tz̈i Dios tuj tyol. Nuket tz'el cyni'ya ti'j ti japenina ja yol lu, mintle e tzaj cyk'oja cyi'j nxnak'atza mintii' cyil. ");
INSERT INTO mamNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Inayena, jaj xjal Sma'n tu'n Dios tu'n ntena cyuya xjal, kbalte ti cbinel tuj jk'ij te ajlabl—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iy'tzen Jesús tuj ja lugar lu, bix tuj tzunj k'ij te ajlabl ocxxin tuj jun camon jaa' xnak'tzbil tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Bix at junxin xjal otk tz'el tanem tk'abxin. Bix ete'c xsunj xjal fariseo tuj camon jaa', bix e xi' cykanenxin te Jesús: —¿K'o'npa tu'n ley tu'n tcub tk'anj jun xjal tuj k'ij te ajlabl?—tz̈ikexin. E xi' cykanenxin texin ju'wa tu'n tcub tz'akxin tuj cyexin cyley. ");
INSERT INTO mamNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bix e xi' ttzak'be'nxin cyexin: —Ka ma cu'x tz'ak jun carnel tuj jun jul tuj k'ij te ajlabl, ¿alcye jun cyey mlaypale tjatz tii'n, amale nuket jun carnel? ");
INSERT INTO mamNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yajtzen jun xjal, ¿yaa'mpale mas tajbel twitz jun carnel? Ju' tzunj, k'o'n tu'n ley tu'n tcub nk'anena jun xjal tuj k'ij te ajlabl—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tej tbaj yolen Jesús ju'wa, e xi' tkba'nxin tej xin min yucchtl tk'ab: —Nukpinx tk'aba. Bix e xi' tnukpi'nxin tk'abxin, bix ul tnaabl tk'abxin tisen juntl tk'abxin. ");
INSERT INTO mamNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pero yaltzen cye fariseo, etzkexin, bix e yolenkexin cyxolxxin tu'n ti tten tu'n tcub cybyo'nxin ja Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","El tniy' Jesús ti'j ti e cub cyninc'u'n fariseo ti'j, bix el lk'exin tuj ja lugar lu. Nim xjal oc lpe ti'jxin, bix e cub tk'a'nexin cykilca yaab cyxol. ");
INSERT INTO mamNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero e tkbaxin cye xjal tu'n mi'n txi' cyk'umen ka otk chi k'anj. ");
INSERT INTO mamNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","E tk'anexin ke xjal tu'ntzen tbint tisenj e tkba Dios te tyolel Isaías jatxe ootxa. Tz̈i Dios cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Lu jxjal ma nsicy'a tu'n tajben weya. A wanema ti'j, bix nim nchin tzalaja ti'j. Cwel nk'o'na jweya Espíritu tibajxin. Bix cxe'l tk'umenxin cyej xjal te cykil tnom ti tten tu'n cyten jiquen nwitza. ");
INSERT INTO mamNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mi'n jaw k'ojlxin cyi' xjal bix mi'n jaw s̈-inxin cye xjal. Mi'n k'ajt-xin cyiw tu'n cyoc lpe xjal ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jun xjal yaa'n cyiw tisen jun ptz'unt ncub toket, cxe'l tyeec'anxin tk'ak'bil tc'u'jxin te. Bix jun xjal yaa'n nimxix tocslabl, tisen oj ch'itk tcub yubtz'aj jun tken cantil, cxe'l tyeec'anxin tpasensyaxin ti'j. Ju' cbinel tu'nxin ojxe tcamanxin ti'j cykil ka'. ");
INSERT INTO mamNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ti'jxin c'oquel ke cyc'u'j xjal te cykil tnom,” tz̈i Dios tuj tyol tu'n Isaías. ");
INSERT INTO mamNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yajc'atltzen, bix e xi' k'i'n twitz Jesús junxin xjal toc ten jun biman ti'j. Mos̈xin, bix min e bintl tyolenxin. Pero tej tel tlojo'n Jesús biman ti'jxin, nbintltzen tyolen xinak bix nbintl tu'nxin tu'n tcye'yenxin. ");
INSERT INTO mamNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bix e jaw klee' cykilca xjal, bix e xi' cykba'nxin: —¿Japatzen loj ja xjal lu Tcwal David at tu'n tul te cawel? ");
INSERT INTO mamNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero cye fariseo, tej cybinte ti toc cyu'n xjal, e xi' cykba'nxin: —Min. Nuk tu'nj tipemal k'o'n te tu'n Beelzebú, cawel cyibaj biman, ba'n tu'n tel tlojo'n ja xjal lu biman cyi' xjal—tz̈i ke fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero el tniy' Jesús ti'j ti iy' tuj cyc'u'jxin, bix e xi' tkba'nxin cyexin: —Tzin cykba'na nchin ak'anana te taaw il, Satanás. ¿Pero ti tten ju'wa? Cytzki'ntla ka ma tz'el tpa'n tiib jun tnom bix pjel cyk'ojlen cyiib xjal, mlay cyaj tnom ba'n. Jax ju'x ke te jun jaa', ka ma chi jaw k'oj, bi'x cxe'l cynajle'n tuj il. ");
INSERT INTO mamNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ju'tzen tten tuya taaw il. Ka ma tz'el tlojo'n Satanás kej biman ete' tjak' tcawbil, nk'ojl tzunxin ti'jxxin, bix tu'n t-xi' tcawbilxin tuj il. ");
INSERT INTO mamNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Oj tel cyii'n ke cyxnak'atza biman, min txi' cykba'na tu'n tipemal Beelzebú nbint cyu'n. Ju' tzunj, mi'n txi' cyyolena n-el wii'na biman tu'n tipemal Beelzebú, cuma cytzki'ntla mi nuk cyu'n bix mi nuk wu'na bixet tz'el biman tu'n tipemal Beelzebú. ");
INSERT INTO mamNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ju' tzunj, tu'nx tipemal Espíritu Santo te Dios n-el wii'na biman. Bix cuma tu'n tipemal Dios, q'ueleltzen cyni'ya ti'j tu'nj wul-lena o tzul tcawbil Dios cyibaja. ");
INSERT INTO mamNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Ba'mpa tocx jun alak' tuj tja jun xjal cyiw te k'ilbetz tk'inemal ka min ma cub tẍpo'n alak' taaw jaa' nejl? Min. Pero ka ma cub tẍpo'n, ba'ntzen tetz talk'a'n tk'inemal. Weya, at wipemala tu'n tel wii'na j-at tuj tk'ab taaw il. ");
INSERT INTO mamNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ejee'y, ka min ma tz'oc cyk'on cyiiba wuyena, nchi k'oj tzuna wi'ja. Kej xjal min cyak' cyiib wuyena tu'n cyclet xjal tuj tk'ab Satanás, ju'tzen chi onen ti' Satanás tu'nx cyxi' xjal tuj il. ");
INSERT INTO mamNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ju' tzunj, cxe'l nkba'na cyey, ba'n tcub tnajsa'n te Dios tixja ilel bix tixja xmucchabl yol wi'ja. Pero kej xjal tzin cykba'n ka junx Espíritu Santo tuya taaw il, mlay najset cyil. ");
INSERT INTO mamNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kej xjal yaa'n ocslal wi'ja, ka ma chi yolen ka' wi'ja, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal, ba'n tnajset cyil. Pero kej xjal tzin cykba'n jnbint tu'n tipemal Espíritu Santo, tu'n tipemal Satanás, mlay najset cyil, yaa'n nuk tuj ja tyem lu, sino jax ju'x tuj jtyem tzul. ");
INSERT INTO mamNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tu'nj tbinchben jun xjal q'uelel cyni'ya ti'j ti tten tnaabl jun xjal. Jun tzee' ba'n mi'n tak' twitz ka', bix jun tzee' k'eynen mlay tak' twitz ba'n. Ju' tzunj, mi'n txi' cykba'na ka ba'n nbinchbena pero ka' nnaabla. ");
INSERT INTO mamNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ejee'y, tisen lbajkey, cuma nuk ka' n-el tuj cytziy. Kej xjal ka', chi yolel ka', cuma ti' tyol jun xjal tzin tyeec'an ti tten tuj tanem. ");
INSERT INTO mamNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kej xjal ba'n nchi yolen ba'n, cuma tuj cyanem ta' ba'n. Pero kej xjal yaa'n ba'n, nchi yolen ka', cuma tuj cyanem ta' ka'. ");
INSERT INTO mamNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Cxe'l nkba'na cyey, jaca yol min tz'ajben nxi' tkba'n jun xjal, cxe'l tk'o'ntzen tcwent te Dios oj tul k'ij te xkelbil twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Cyyola te ja'lewe kbalte ti pjel cyey tuj tzunj k'ij tzul, cuma ka ba'n yol n-etz tuj cytziy ja'lewe, cchic'ajaxeltzen ka ba'nkey twitz Dios. Pero ka ka' yol n-etz tuj, cweltzen cytziy tk'o'n Dios cycastiwiya—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bix e xi' cykba'n juun tx'olbal ley bix juun fariseo texin: —Xnak'tzal, kaja tu'n ttzaj tyeec'ana jun yec'bil jawnex keya tu'ntzen tchic'ajax ka ju' otk tzaja tuya Dios—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero aj ttzak'be'nxin cyexin: —Key xjal judío te ja'lewe, ka'key bix ma tz'el cypa'n cyiiba ti' Dios. Min chin cyiik'a, sino nuk ete'c'a kanlte we mastl yec'bil. Pero jtechel tzin cykanena, mlay k'oj cyey. Oj tbaj wi'ja tisenxj e baj ti'j tyolel Dios Jonás, jatzen c'ajbel te yec'bil cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tisenxj e ten Jonás oxe k'ij bix oxe koniyan tuj tc'u'j jun tij quis̈ tuj mar, jaxse ju'x chin temela oxe k'ij bix oxe koniyan tuj tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Oj tpon tumel tu'n cyoc cykil xjal tuj xkelbil tu'n Dios, ejee'j aj Nínive chi jawel yolel cyi'j ejee'y judío te ja'lewe, cuma tej t-xi' tk'umen jxin tyolel Dios Jonás cye aj Nínive tu'n taajtz ti' cyanem, aajtztzen ti' cyanem. Pero cyey, amale nxi't tk'umen jun xjal mas jawnex twitz Jonás cyey, pero min cynimey. ");
INSERT INTO mamNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jax ju'x cjawel yolel jxuj xuuj e cawen cyuj tnom te jawne jatxe ootxa cyi'ja judío te ja'lewe tuj jk'ij te xkelbil tzul. E xi'xuj nakch te ebilte tnaabl rey Salomón, bix oc tbi'nxuj bix e tnimanxuj. Pero cyey, n-oc cybi'na tyol jun xjal mas jawnex twitz Salomón, pero min txi' cynimana. ");
INSERT INTO mamNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Oj tel lojo'n jun biman ti' jun xjal, nbettzen biman tuj tzkij tx'otx' jaa' min-al xjal. Njyon tu'n tajlan, pero min cnet jaa' tu'n twe'ban. ");
INSERT INTO mamNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ju' tzunj, nxi' tkba'n: “Chin aal meltz'aja tuyaj xjal jaa' ntiniya nejl,” tz̈i. Oj taj meltz'aj biman tuyaj xjal, oj toc tcye'yen xjal, tisenc'a jun jaa' min-al xjal tuj, bix tz'isen tten tuj, bix binne tten. ");
INSERT INTO mamNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Oj toc tcye'yen min-al xjal tuj, n-eltltzen biman jyolte mas tuya, bix cpomel meltz'aj tuya wuuktl biman mas ka' twitz. Enteraxseke chi oquex tunwen tu'n cynajan, bix ju' tzunj yal tzunj xjal masxsen tuj il ta' twitz nejl. Ju'tzen pjel cyi'ja judío ka' te ja'lewe—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mitkna'x tbaj yolen Jesús cye xjal tej tpon ttxuxin cyuyax ke titz'enxin. Wa'lc'akexin pe'n, bix e cyajbexin tu'n cyyolenxin tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bix at jun xjal e xi' tkba'n texin: —Jey', lu ttxuy cyuya ke titz'ena wa'lc'a pe'n, bix cyaj tu'n cyyolen tuyey—tz̈i xjal te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero e xi' tkba'nxin tej xjal otk k'umen jlu: —Tuj twitza, ¿al tzunj weya ntxu bix al tzunj weya witz'en?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bix e xi' tch'iquexin tk'abxin cye t-xnak'atzxin, bix e xi' tkba'nxin: —Ejee' tzunj luwe weya ntxu bix weya witz'en. ");
INSERT INTO mamNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aljxe xjal binchante tajbil Nmana tuj cya'j, ejee' tzunja witz'ena bix waneba bix ntxuya—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tujx jk'ij lu, etztzen Jesús tuj jaa'wa, bix e cub ke ttzii' tnijabel a'. ");
INSERT INTO mamNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bix e pon cychmon cyiib nimxsen xjal ti'jxin. Ju' tzunj, ocxxin tuj jun barc bix e cub kexin tuj tu'n t-xnak'tzan cye xjal. Yaltzen cye xjal, e cyaj we'ke ttzii' a'. ");
INSERT INTO mamNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bix ak' Jesús xnak'tzalcye. Nim xnak'tzbil e xi' tk'o'nxin cyexin, pero tuya nim ttxolen yol. E cub tk'o'nxin ja techel lu cyexin: —Attzen junxin xjal e xi'xin te awal triwa. ");
INSERT INTO mamNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tejtzen tak'xin tz̈itlxte iyaj, at tiyajxin e cub tz'ak tuj be. Bix ul noj ke ch'it ti'j bix e jaw cywaa'njil. ");
INSERT INTO mamNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Cabtl twitz iyaj e cub tz'ak twitz pc'at tx'otx'. Yaa'n nimxix tx'otx', bix ju' tzunj, tuj jun rato e jaw pok'chke, cuma mintii' t-xee' tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero tu'n tcykal k'ij, bix oc woch'paj tejxe ttzkij, cuma yaa'n nim tloc' otk txi' tuj tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","At cabtl twitz iyaj e cyaj tz'ak tuj tik'ch ch'i'xel. Pero nuk e jaw ẍcy'ilpaj tjak' ch'i'x, tejxe tetz cyim. ");
INSERT INTO mamNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero at cabtl twitz iyaj e cyaj tz'ak tuj tbanel tx'otx', bix e tak' nim twitz. At juun tken e tak' syent twitz, at cabtl e tak' oxc'al twitz, bix at cabtl e tak' winaklaaj twitz. ");
INSERT INTO mamNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ka cyaja tz'el cyni'ya ti'j ja techel lu, cyjkom cyẍquina bix cybisenx ti'j—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bix ul lk'e ke t-xnak'atzxin ti'jxin, bix e xi' cykanenxin texin: —¿Tu'n tikentzen nyolena cye xjal tuj yaa'n tzinen yol? ");
INSERT INTO mamNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bix aj ttzak'be'nxin cyexin: —Te cyey, ejee'y nxnak'atza, ma txi' tk'o'n Dios cyey tu'n tel cyni'ya ti'j ti tten tcawbil Dios min e yec'j nejl. Pero te cyej niy'tl xjal, min o k'oj cye. ");
INSERT INTO mamNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jxjal n-oc tipen tu'n tnimante nyola, cxe'l k'o'n tu'n tel tniy' ti'j mastl, bix ctemel nim te. Pero jxjal min tz'oc tipen tu'n tnimante nyola, q'uelel k'i'n alcyej ch'in otk bint tu'n. ");
INSERT INTO mamNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ju' tzunj, yaa'n chic'aj jnxi' nyolena cye xjal, cuma amale n-oquet cycye'yen bix amale n-oquet cybi'n, pero min tz'el cyniy' ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ejee' tzunja tisen e tkba Dios tu'nj tyolel Isaías tuj tyol Dios cyi'j xjal min e cybi Dios. E tkba Dios tu'n Isaías cyjulu: “Amale c'oquelet cybi'n bix amale c'oquelet cycye'yen, pero mi'n tz'el cyniy' ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cyiwxsen cyanem jxjala, bix cycy'ix tz'oc cybi'n nyola. Cwel cymutz'ba'n cywitz ti'j jaxxix yol, cuma cycy'i tz'el cyniy' ti'j. Cyiw cyten, cuma cycy'i chi meltz'aj wuyena, tu'ntzen cyclet wu'na,” tz̈i Dios jatxe ootxa. ");
INSERT INTO mamNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero cyey, jun nintzaj xtalbil o k'oj cyey, cuma ete'y tuyaj xjal Sma'n tu'n Dios, bix nxi' cybi'na nyola. ");
INSERT INTO mamNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cxe'l nkba'na cyey, nim tyolel Dios bix nim xjal jiquen te ootxa e cyajbe tu'n toc cycye'yen jxjal Scy'o'n tu'n Dios, tisenj cyey n-oc cycye'yen ja'lewe, pero mix oca cycye'yen. Bix e cyajbe tu'n toc cybi'n kej tyol jxjal Scy'o'n tu'n Dios, tisenj cyey n-oc cybi'n ja'lewe, pero mix oca cybi'n. ");
INSERT INTO mamNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ja'lewe cxe'l ntx'olba'na jtechel ti'j awal. ");
INSERT INTO mamNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oj nxi' tbi'n jun xjal yol ti'j tcawbil Dios, pero min tz'el tniy' ti'j, n-ultzen taaw il tu'n tjatz tii'n ja yol lu otk cu'x awa'n tuj tanem. J-iyaj e cub tz'ak tuj be, ju'tzen japenina tisenj xjal lu min e cyaj tyol Dios tuj tanem. ");
INSERT INTO mamNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","J-iyaj e cub tz'ak tibaj pc'at tx'otx', ju'tzen japenina tisenj xjal n-oc tbi'n tyol Dios tuya cykil tc'u'j tuj tneel. ");
INSERT INTO mamNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero min cywix tuj tanem. Nuk ca'ba k'ij ncyaj ten, cuma oj n-oc jun q'uixc'aj bix ka jun pena ti'j tu'n tlaj tyol Dios, ncub bajtl tc'u'j ti' tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ja tzunj iyaj e cub tz'ak cyxol twitz ch'i'x bix e cyim tjak' ch'i'x, ju'tzen japenina tisenj xjal n-oc tbi'n tyol Dios, pero nuk o'cx k'inemal bix tu'n titz'j taj, bix tu'n tzunj lu ncaman te xitbil tyol Dios tuj tanem. Tchunk'lal tisen jun tken triwa mintii' twitz. ");
INSERT INTO mamNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero j-iyaj e cub tz'ak tuj tbanel tx'otx', ju'tzen japenina tisenj xjal n-oc tbi'n tyol Dios bix n-el tniy' ti'j. Tchunk'lal cyisen tken triwa tzin cyk'o'n twitz. At juun nchi k'on syent twitz. At cabtl nchi k'on oxc'al twitz. Bix at cabtl tken nchi k'on winaklaaj twitz—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Bix e xi' tk'o'n Jesús juntl techel cye xjal: —Oj ttz̈'iy tcawbil Dios twitz tx'otx', tisenj ti nbaj oj ncu'x tawa'n jun xjal iyaj tuj tcojbil. At junxin xjal e cu'x tawa'n iyaj ba'n tuj tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero at jun koniyan ul t-enemiwa, bix tej cywutan cykil xjal, tuj ewjel e cu'x tawa'nxin ka' c'ul t-xol triwa, bix ajxin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lwewa, tej tjaw pok'ch triwa bix e tak' twitz, jax ju'x e jaw pok'ch ka' c'ul tuj. ");
INSERT INTO mamNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tej tjaw pok'ch triwa tuyax ka' c'ul, ul ke t-ak'anal jxin taaw cojbil twitzxin, bix e xi' cykba'nxin texin: “Taat, ¿yaa'mpa nuk iyaj ba'n e cu'x tawa'na tuj tcojbila? ¿Ti tten ma jaw pok'ch nim ka' c'ul t-xol triwa?” tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bix aj ttzak'be'nxin cyexin: “Tu'n jun xjal at tk'oj wi'ja ma bint jlu,” tz̈ixin. Bix e xi' cykanen t-ak'analxin texin: “¿Tajpey tu'n kxi'ya tu'n tjatz kbako'na ka' c'ul?” tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero aj ttzak'be'nxin: “Min, cuma ka ma jatz cybako'na ka' c'ul, tuyax triwa cjawetz bakl cyu'na. ");
INSERT INTO mamNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","E ttz̈'iy ka' c'ul junx tuya triwa ojxe tpon tumel tu'n tjtx'et. Ojtzen tpon tumel tu'n tjaw chmet triwa, cxe'l nkba'na cye chmol awal: ‘Tneelxix, cjawetz cychmo'na ka' c'ul bix cwel cymanoja tu'n tocx tuj k'ak'. Jatzente triwa, cychmo'ncx tu'n tocx tuj ntx'utx'a,’ ntz̈iya,” tz̈i taaw cojbil—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Bix e xi' tk'o'n Jesús juntl techel cye xjal: —Oj ttz̈'iy tcawbil Dios, ctz̈'iyel tisen tten oj ncu'x tawa'n jun xjal iyaj te mostaza tuj ttx'otx'xin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ja tzunj twitz mostaza, jatzen jun iyaj mas xmutz' twitz cykilca twitz tiy'jil itzaaj. Pero oj toc te tzee', mas twe' cywitz cykilcatl itzaaj tuj tcojbil, bix najben tu'n cyajlan ke ch'it tuj tk'ab—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bix e xi' tk'o'nxin juntl techel cye xjal: —Tcawbil Dios ctz̈'iyel tisen tten oj ntz̈'iy k'otj tu'n levadura. Ocx tk'o'n jun xuuj levadura tuj k'otj te pan, bix e xi' tk'o'nxuj oxe malbil k'otj tuj jun tcublel. Bix e jaw tz̈'iy k'otj te pan tu'n levadura hasta tejxe tjaw punntz'aj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Cykilcaj lu e tkbaxin cye xjal. Minxix e ttx'olbaxin, sino tuya techel yol tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tej t-xi' tk'o'nxin techel cye xjal ju'wa, el jaxxix j-e tkba jun tyolel Dios jatxe ootxa. Tz̈i cyjulu: “‘Chin yolela tuya techel. Cxe'l nk'umena j-e'wen ta' jatxe tej mitkna'x tbint twitx tx'otx',’ tz̈i Dios,” tz̈i jun tyolel Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","E cyajtzen tcye'yen Jesús ke nimxsen xjal, bix ocxxin tuj jun jaa'. Bix ul lk'e ke t-xnak'atzxin ti'jxin, bix e xi' cykba'nxin: —Najsama, tx'olbantz keya ti elpenina jtechel ti'j ka' c'ul tuj cojbil—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bix aj ttzak'be'nxin: —Jxjal e cu'x tawa'n j-iyaj ba'n, jatzen xjalja Sma'n tu'n Dios tu'n tten cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jcojbil, jatzen cykilca twitz tx'otx'. Yaltzen kej iyaj ba'n, ju'tzen japenina tisen kej xjal cyaj tcawbil Dios. Kej iyaj ka' c'ul, ju'tzen japenina tisen kej xjal nche'x lpe ti'j taaw il. ");
INSERT INTO mamNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jxjal enemiwa e cu'x tawa'n ka' c'ul, jatzen japenina tisen taaw il. Bix jaatx'en, jatzen japenina tisen manc'bil k'ij twitz tx'otx'. Kej chmol awal, ejee'tzen kej tsanjel Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tisenj njaw chmet ka' c'ul bix cxe'l tuj k'ak', ju'tzen pjel tuj manc'bil k'ij. ");
INSERT INTO mamNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Cweletz nsma'na ke n-ángela, bix q'uelex cyii'n tuj ncawbila cykilca kej xjal n-oc cyipen ti'j tu'n cybinchantl niy'tl xjal il, bix xsunj cykilca kej xjal cycy'i tley Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Cxe'l nxoo'na tuj k'ak' te junx maj, jatztzen chi ook'el bix cjawel kitx'itx'in t-xee' twitz cye. ");
INSERT INTO mamNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jatzen kej xjal jiquen, chi koptz'ajel tuj tcawbil Cyman Dios tisen tken k'ij. Cyjkom cyẍquina tu'n tel cyni'ya ti'j nyola, bix cybisenx ti'j—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Bix e xi' tkba'ntl Jesús: —Jtajbil jun xjal ti'j tcawbil Dios tisenj tajbil jun xjal ti'j jun jawnex k'inemal. Ka ma cnet tu'nj xjal ak'anal jun k'inemal maku'n ta' tuj jun cojbil cwelex te'wenxin juntl maj, bix tuya cykil tc'u'j cxe'l tq'ueyen cykilca at texin, tu'ntzen tlok'onte ja cojbil lu tuya k'inemal otk tilxin tuj. ");
INSERT INTO mamNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jax jtajbil jun xjal ti'j tcawbil Dios tisenj tajbil jun q'ueyel cyi'j perla. ");
INSERT INTO mamNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ka ma cnet jun perla wi'yelxsen tu'n, cxe'l tq'ueyen cykilca at texin, tu'ntzen tlok'ontexin ja perla lu. ");
INSERT INTO mamNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jax ju'x, jnbaj oj tul tcawbil Dios tisenj nbaj oj nxi' cyxoo'n tzyul quis̈ cyxiy'pa tuj tnijabel a'. Cykilca wik quis̈ ntzyet cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ojtzen tnoj cyxiy'pa, cjawetz cyii'n cyxiy'pa tuj a' bix cxe'l k'i'n cyu'n ttzii' a'. Chi cwel ke bix cjawetz cyscy'o'n quis̈ ba'n tu'n tcub cyk'o'n cyuj chi'l. Pero kej quis̈ yaa'n ba'n, q'uelex cyxoo'n. ");
INSERT INTO mamNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ju'tzen pjel cyuj manc'bil k'ij. Chi tzaal tsanjel Dios tuj cya'j, bix q'uelel cypa'n kej xjal ka' cyi'j xjal jiquen. ");
INSERT INTO mamNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bix chi xe'l cyxoo'n kej ka' tuj k'ak' junx maj, jatztzen chi ook'el bix cjawel kitx'itx'in t-xee' twitz cye tu'n tak'. ");
INSERT INTO mamNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","¿Mapa tz'el cyni'ya ti'j cykilca kej yol lu?—tz̈i Jesús cye t-xnak'atz. —Ma tz'el kni'ya ti'j, Taat—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bix e xi' tkba'nxin cyexin: —Ka ju' ma tz'el cyni'ya ti'j nxnak'tzbila ti'j tcawbil Dios, matzen chi oca te xnak'tzal. Ejee'y tisen jun taaw jaa' ba'n tu'n t-xi' tk'o'n cykilca ba'n cye ke te tja. Ba'n t-xi' cyxnak'tza'na jaxxix yol te ootxa, bix ba'n tu'n t-xi' cyxnak'tza'na kej jaxxix yol ac'aj yaa'n telniy' nejl—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tejtzen tbaj tkba'n Jesús kej techel lu, iy'tzen tuj ja tnom lu, ");
INSERT INTO mamNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","bix ulxin tuj ttanemxin. Bix tej tocxxin tuj camon jaa' te xnak'tzbil tyol Dios, ak'xin xnak'tzal cye xjal. Bix e jaw klee' kej xjal te ttanemxin ti'jxin, bix e xi' cykba'nxin: —¿Jaa'tzen ma tzaa' tcno'n jxjal lu nimxsen tnaabl? ¿Bix jaa'tzen ma tzaa' tipemal te k'anl xjal? ");
INSERT INTO mamNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Yaa'mpatzen nuk tcwal carpintero? ¿Yaa'mpatzen ja María ttxuxin, bix yaa'mpatzen Jacobo bix José bix Simón bix Judas ke titz'enxin? ");
INSERT INTO mamNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Bix yaa'mpa najl cykilca ke tanebxin kxol tzalu? Ju' tzunj, ¿jaa'tzen ma tzaa' tcno'n jxjal lu jtipemal?—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ju' tzunj, min ocxix cybi'n xjal aj Nazaret tyolxin. Ju' tzunj, e xi' tkba'n Jesús cyexin: —Jun tyolel Dios jaa'xja tumel n-oc ocslette. Ja tzunj tuj ttanem bix tuj tja min tz'oc ocslet—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Cuma min e cyyocsla ke aj ttanemxin ti'jxin, ju' tzunj yaa'n nimxix e tyeec'axin tipemalxin cyxolxin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Cyujtzen ja k'ij lu, e tbi jxin gobernador Herodes tpocbal jnbint tu'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Bix e xi' tkba'nxin cye xjal ajben texin: —Ja te Juan Bautista ja xjal lu. Ma jatz itz'j juntl maj cyxol cyimne, bix ju' tzunj at nim tipemal tu'n tbint cykilcaj lu tu'n—tz̈i gobernador. ");
INSERT INTO mamNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tz̈itzen Herodes ju'wa cuma nejl otk cub cytzyu'n tsoldadoxin ja Juan bix otk cub cyẍpo'nxin bix otk tz'ocx cyk'o'nxin tuj tzee'. E bint tu'n Herodes ju'wa cuma otk tz'el tikenxin t-xu'l titz'enxin Felipe, Herodías tbixuj. ");
INSERT INTO mamNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nuk tu'nj otk txi' tkba'n Juan texin: “Yaa'n tumel tu'n toc t-xulena t-xu'l titz'ena.” ");
INSERT INTO mamNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Otk tajbexin tu'n tcub byet Juan, pero min e xi' tkba'nxin cye tsoldadoxin tu'n tcub byet, cuma tcy'ixin tu'n tjaw cyk'oj xjal ti'jxin. Tuj cywitz xjal, jun tyolel Dios ja Juan. ");
INSERT INTO mamNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero manc'biltzen, otk cub byet Juan tu'n tlaj t-xu'l Herodes. Tjapantzen bajxin tu'n tiy' tk'ijxin, bix ocx jtxin tal Herodías bixel twitzxin bix cywitz xjal ttxlajxin. Ba'nxsen e'la bixentxin tuj twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ju' tzunj, e xa' tkba'nxin tetxin: “Alcyexja ctzaal tkanena weya, jac'a txi' nk'o'na. Tzkinn Dios,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nejl, e xi'txin kanlte te ttxutxin ti taj ttxutxin tu'n t-xi' tkanentxin texin. Tej tul meltz'aj twitz Herodes, e xi' tkba'ntxin texin: “Waja tu'n ttzaj tk'o'na twi' Juan Bautista weya tuj jun lak,” tz̈i tzuntxin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Otk tz'el ka' tkanbiltxin twitzxin, pero cuma ya otk cyaj tk'o'nxin tyolxin tuya jun jurament bix cuma ya mix e cwa' tch'ixbe'nxin tyolxin cywitz ttxocanxin, e tcuyaxin tu'n tk'oj twi' Juan tetxin, ");
INSERT INTO mamNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","bix e xi' tchk'o'nxin junxin tsoldadoxin te k'ilbel twi' Juan. Bix el ttx'omanxin twi' Juan, ");
INSERT INTO mamNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","bix e pon tii'nxin tuj jun lak. Bix e xi' tk'o'nxin tetxin, bix e xi' tk'o'ntltxin te ttxutxin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bix otk pon cab xjal lepchec ti'j Juan k'ilbetz t-xumlal Juan bix e cu'x cymaku'n, bix e xi' kbalte tpocbal tcyimlen Juan te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tejtzen toc tbi'n Jesús otk cub byet Juan, el lk'exin cyuya t-xnak'atzxin bix e xi'kexin tuj jun barc jaa' min-al xjal najl. Pero oc cybi'n xjal jaa' e xa' Jesús, bix txolen etz ke xjal tuj cytanem tu'n cypon ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tej tetzxin tuj barc, e tilxin nimxsen xjal, bix oc k'a'ben tc'u'jxin cyi' xjal, bix ak'xin k'anl kej yaab cyxol. ");
INSERT INTO mamNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tejtzen ch'itk tex k'ij, oc lk'e ke t-xnak'atzxin tuyaxin, bix e xi' cykba'nxin texin: —Taat, tzalu mintii'xse waabj ba'n tcnet bix ya kalatltzen. K'umenx cye xjal tu'n cyxi' lok'ol cywa tuj kej coc' tnoma—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero e xi' tkba'n Jesús cyexin: —Yaa'n il ti'j tu'n cyxi' xjal. Ejee'x cyey cyk'onx cywa xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bix e xi' cykba'nxin texin: —Nuk jwe' mukan tuya ca'ba quis̈ at kuyena—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Cyii'ntza nwitza—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Bix e xi' tkba'nxin tu'n cycub ke ke xjal tuj polen tuj chk'ajlaj. Bix e xi' ttzyu'nxin jjwe' pan tuyaj ca'ba quis̈, bix e jaw tcye'yenxin twitz cya'j, bix e xi' tk'o'nxin chjonte te Dios ti' waabj. Bix e cub tpiẍen pan bix e xi' tk'o'nxin cye t-xnak'atzxin, tu'ntzen t-xi' cypa'nxin cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bix cykilca xjal e waa'nke tejxe tnoj cyc'u'j. Tej cybaj waa'n xjal, bixsen e jaw chmet ttx'akan waabj otk cyaj, bix e noj cablaaj chi'l. ");
INSERT INTO mamNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Atle jwe' mil xinak e waa'n, bix yaa'n cyuyax ke xuuj bix cyuyax ke cwalbaj oc te tajlal. ");
INSERT INTO mamNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tejtzen tbaj ju'wa, bix e xi' tkba'n Jesús cye t-xnak'atz tu'n cycu'xxin tuj barc tu'n cyiy'x nejlxin twitzxin jlajxitl tnijabel a'. Jatzen te Jesús, e cyaj tenxin kbalte cye xjal tu'n cyaj cyja. ");
INSERT INTO mamNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tej tzunj tpon baj tyolxin cyuya xjal, bix e jaxxin tjunal twi' witz te yolel tuya Dios. Tcubtzen klolj, bix e tenxin tjunalxin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pero ke t-xnak'atzxin, ete'cxin tuj barc tmij tnijabel a' nakch ttzii' a'. Bix cyiw tkitj barc tuj a', cuma nimxsen oc punntz'aj a' tu'n jun nintzaj cyk'i'k. ");
INSERT INTO mamNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Te ch'itk cyskixxin, bix e xi' bet-xin tibaj a' tu'n tponxin cyi'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tej cylontexin nbet-xin tibaj a', e jawxsen sey'pajkexin, bix e xi' cykba'nxin: —Jun t-xneq'uetz'il biman nbet tibaj a'—tz̈ikexin, bix ak'kexin s̈-il tu'n ttz̈i cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero lwewa naj e xi' tkba'n Jesús cyexin: —Cynimsam cyc'u'ja. Inayen weja. Mi'n tzaj ntz̈iya cyi'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aj ttzak'be'n Pedro texin: —Taat, ka jaxxix ka jay, kbantza weya tu'n nxi'ya tuyey tibaj a'. ");
INSERT INTO mamNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Bix e xi' tkba'nxin te Pedro: —Cu ttzaja. Ju' tzunj, e cu'tz Pedro tuj barc bix ak' betel tibaj a' tu'n tpon tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero tej tna'nte Pedro tipemal cyk'i'k, e tzaj ttz̈i ti'jxin, bix n-ak' xe'l bajtlxin tjak' a', bix e jaw s̈-in: —Taat, ¡chin tcla'y! ");
INSERT INTO mamNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bix e xi' tnukpi'n naj Jesús tk'ab te tzyulte te Pedro, bix e xi' tkba'nxin: —Yaa'n nimxix ma tz'oc ke tc'u'ja wi'ja. ¿Tiken xbaj tc'u'ja wi'ja?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tej tjaxxin tuj barc tuya Pedro, nwe'tl cyk'i'k. ");
INSERT INTO mamNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ejee'j t-xnak'atzxin e ten tuj barc, e cub majekexin t-xee' tkenxin te nimsalte texin. Bix e xi' cykba'nxin: —Tzinen ta' Tcwal Diostey. ");
INSERT INTO mamNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tejtzen cyiy'xin jlajxe a', e ponkexin tuj ttx'otx' Genesaret. ");
INSERT INTO mamNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tej tel cyniy' xjal aj Genesaret ka ja Jesús otk pon, e xi' cysma'n cysanjel kbalte tuj tnom bix cyuj coc' tnom. Bix e xi' cyii'n xjal ke yaab twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bix oc cycubsa'n xjal cywitz texin tu'n tcuyanxin tu'n toc cymoco'n yaab amatle nuk ti' ttxa'n t-xbalenxin. Bix aljxe xjal oc moconte texin, ul cynaabl. ");
INSERT INTO mamNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Attzen jun k'ij bix e pon tuya Jesús cab xjal nimalxsen te ley, ejee'j xjal fariseo, tuya cabxin tx'olbal ley. Otk chi tzajxexin maa Jerusalén. E xi' cykanenxin texin: ");
INSERT INTO mamNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Tikentzen min tzin cyniman tey t-xnak'atza ley cye xjal te ootxa? Nchi waa'n pero min ma txjet cyk'abxin tisex tten te mitkna'x toc waa'n—tz̈i ke fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bix aj ttzak'be'n Jesús cyexin: —¿Tiken n-el cyiiq'uena tley Dios tu'n cyoc lpey ti'j jcyexa cyleya? ");
INSERT INTO mamNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","E tkba Dios cyjulu: “Cybi'nq'uey cymana bix cytxuy. Alcye ma txi' tkba'n ka' ti'j tman bix ka ti'j ttxu, il ti'j tu'n tbyet,” tz̈i Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero cyey, tzin cyxnak'tza'na cye xjal: “Amale atet il ti'j tman jun xjal bix ka ttxu, pero ka ma txi' toyen tpwak te tja Dios, ");
INSERT INTO mamNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mas il ti'j jlu twitzj tu'n t-xi' tk'o'n onbil cye tman,” tz̈ikey. Ju'tzen tten n-el cyiiq'uena jtzin tkba'n Dios tu'n toc cyc'ojla'na jcyexa cyleya. ");
INSERT INTO mamNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Xmeletz' xjalkey! Jaxxix toc tu'n tyol tyolel Dios Isaías tej tcyaj ttz'i'ben cyi'ja cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Kej xjal lu nchi na'n Dios nim tuya cytzi, perotzen cyanem nakch ta' wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mintii' ba'n tajbe'na oj nchi na'n nbi'ya. Bix xnak'tzbil cye yaa'n wu'na, sino nuk cyu'nx,’ tz̈i Dios,” tz̈i Isaías—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yajc'atltzen bix e ttxoc Jesús ke xjal, bix e xi' tkba'nxin cyexin: —Chin cybi'tzen, bix tz'elx cyni'ya ti'j nyola. ");
INSERT INTO mamNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yaa'n jc'oquex tuj ttzi jun xjal cchucjalet tu'n, sino ja tej ctzaal ti' tanem xjal, jatzente teja ctz'ilaxix xjal tu'n twitz Dios—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","E pontzen lk'e ke t-xnak'atzxin ttxlajxin, bix e xi' cykba'nxin texin: —¿Mapa tz'el tni'ya ti'j ka' s-ela tyola tuj cywitz fariseo? ");
INSERT INTO mamNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","E xi' ttzak'be'nxin: —Mi'n baj cyc'u'ja cyi'j, cuma mi'n cyaj cybinchben cyu'n. Cykilca awal min ma cu'x tawa'n Nmana at tuj cya'j, cjawetz lequet cyloc'. ");
INSERT INTO mamNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ju' tzunj, mi'n che'x lpey cyi'j aj fariseo. Ejee' cyisen mos̈, bix kej xjal nchi oc lpe cyi'j, jax cyisen mos̈. Ka ma txi' tyeeca'n jun mos̈ be te juntl mos̈, junx chi xe'l tz'ak tuj jun jul—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","E xi' tkba'n Pedro te Jesús: —Kbantz keya ti elpenina tyola cye xjal ti'j waabj. ");
INSERT INTO mamNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Bix aj ttzak'be'nxin: —¿Mina'xpatzen tel cyni'ya ti'j? Ejee'y tisen ke niy'tl xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Mimpa ma tz'el cyni'ya ti'j ka ti jilel ma tz'ocx tuj ttzi jun xjal, cxe'lte tuj tc'u'j, tu'n tiy' tc'u'n? ");
INSERT INTO mamNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jaj ctzaal itz'j ti' tanem xjal bix n-etz tuj ttzi, jatzen teja ctz'ilelxix xjal tu'n twitz Dios, ");
INSERT INTO mamNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","cuma tujxe tanem ntzaa' itz'ja tka'yel, bi'yen, aj pajlel, tu'n toc ipan ti' juntl xuuj, alk'al, ẍtak'el, bix tu'n tyolen ka' ti' juntl xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Cykil tzunj lu ntz'ilaxix xjal twitz Dios. Pero oj t-xi' twaa'n jun xjal bix min ma tz'el ttxjo'n tk'ab, mlay chucj te xjal tu'n—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yajc'atltzen, bix etz Jesús tuj lugar lu, bix e xi' tuj tnom te Tiro tuyax tnom te Sidón. ");
INSERT INTO mamNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Attzen junxuj xuuj yaa'n judío najl tuj lugar lu, aj Canaánxuj. Etzxuj tuj ttanemxuj tu'n tponxuj tuya Jesús, bix ak'xuj s̈-il: —Taat, jay Tcwal Rey David, k'ontz tc'u'ja wi'ja, cuma nimxsen nyajlan jun biman ti'j txin wala—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero te Jesús, min aj ttzak'be'nxin texuj. Bix e pon lk'e ke t-xnak'atzxin ti'jxin, bix e xi' cykanenxin texin: —Kbanxa te xuuj lu tu'n taj, cuma nuk lepchec s̈-il ki'j. ");
INSERT INTO mamNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pero aj ttzak'be'nxin cyexin: —Nuk cyej xjal aj Israel o che'x tz'ak cyisen carnel e tzaj tsma'n Dios inayena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero te xuuj, e cub majexuj twitz Jesús, bix e cubsanxuj twitzxuj texin: —Taat, chin tonentza. ");
INSERT INTO mamNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bix aj ttzak'be'nxin texuj: —Yaa'n tumel oj tel k'i'n cywa nee' tu'n t-xi' k'o'n cye txyan—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero e xi' tkba'nxuj: —Jax toc tu'na, Taat. Pero tzintlpe cyyo'n txyan tjak' mes niy' q'uelel tz'ak ttx'akan cywa cyaawjil ttxa'n mes—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Bix aj ttzak'be'n Jesús texuj: —Naa, nimxix tocslabla wi'ja. Cbinel tajbila—tz̈ixin. Bix jaxj hora e k'anj talxuj. ");
INSERT INTO mamNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yajc'atltzen, bix etz Jesús cyuj tnom lu, bix aj meltz'ajxin ttzii' tnijabel a' te Galilea. Bix e jaxxin twi' jun witz, bix e cub kexin. ");
INSERT INTO mamNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","E pontzen nimxsen xjal tuyaxin. E xi' cyii'n kej xjal ẍt'unc, kej xjal cox, kej mos̈, kej men, bix kej xjal yaab, bix e cub cyk'o'n t-xee' tkenxin. Bix cykilca e k'anj tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tejtzen cylonte xjal nbintl cyyolen men bix e cyaj ba'n ke ẍt'unc bix nchi bet ke cox juntl maj bix nbintl cycye'yen ke mos̈, e jaw klee'tzen ke xjal, bix e jaw cynimsa'n tbi Dios ncawen cyibaj aj Israel. ");
INSERT INTO mamNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Bixse e tzaj ttxco'nxin ke t-xnak'atzxin, bix e xi' tkba'nxin cyexin: —Ma tz'oc k'a'ben nc'u'ja cyi'j xjala, cuma ma bint oxe k'ij cyten wuyena tzalu, bix mintzentii'tl cywa. Ncy'iya tu'n t-xi' nsma'na cye cyja mitkx nchi waa'n, cuma kape yaa'n yaj chi tzaj yumtz'aj tuj be tu'n weyaj—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bix aj cytzak'be'n t-xnak'atzxin texin: —¿Pero titzen tten tu'n tcnet waabj ku'na tu'n cynoj cykilca xjal lu? Min-al xjal najl tzalu—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Bix e xi' tkba'nxin cyexin: —¿Jte' mukan k'i'n cyu'na? E xi' cykba'nxin: —Wuuk k'i'n ku'na, cyuyax cab quis̈ coc'—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bixse e xi' tkba'nxin tu'n cycub ke cykil xjal twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bixse e tzaj ttzyu'nxin jwuuk pan cyuyax quis̈, bix e xi' tk'o'nxin chjonte te Dios cyi'j, bix e cub tpa'nxin, bix e xi' tk'o'nxin cye t-xnak'atzxin tu'ntzen t-xi' cypa'nxin cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Cykilca xjal e waa'n tejxe cynoj. Bix e jaw cychmo'n ttx'akan waabj ya min otk baj cyu'n xjal, bix e noj wuuk chi'l. ");
INSERT INTO mamNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kej e waa'n, cyaja mil xinak, bix at nimtl xuuj cyuya ke cyal e waa'n. ");
INSERT INTO mamNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tej cybaj waa'n xjal, bix e xi' tkba'nxin cye tu'n cyaj cyja. Bix e cu'xxin tuj jun barc, bix e ponxin tuj tx'otx' te Magdala. ");
INSERT INTO mamNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","E pontzen tuya Jesús tzunkej xjal nimalxse tuj cyley, ejee'j xjal fariseo, cyuya jun cloj xjal saduceo, bix ak'kexin niy'belecte tnaabl Jesús tu'ntzen tcub tz'akxin tuj cyyolxin. E xi' cykanenxin tu'n t-xi' tyeec'anxin tipemalxin tu'n tchic'ajax ka ju' otk tzajxin tuya Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero aj ttzak'be'n Jesús cyexin: —Oj n-ex k'ij, bix cyak t-xee' cya'j, tzin cykba'na: “Mintii' jbal nchi'j, cuma chic'aj t-xee' cya'j,” tz̈ikey. ");
INSERT INTO mamNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bix oj kskix, ka cyak t-xee' cya'j, tzin cykba'na: “Tzul jbal ja'lewe, cuma cyak t-xee' cya'j, bix at k'ek muj,” tz̈ikey, bix jax cyu'na. At cynaabla tu'n tel cyni'ya ti'j techel twitz cya'j, ¿pero titzen tten min n-el cyni'ya ti'j ti nbaj te Dios cyxola tuj tyem te ja'lewe? ");
INSERT INTO mamNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Key xjal judío te ja'lewe, ka'key bix ma tz'el cypa'n cyiiba ti'j Dios. Min chin cyocslay, sino nuk ete'c'a kanlte weya mastl yec'bil. Pero jtechel tzin cykanena, mlay k'oj cyey. Oj pjel wi'ja tisenxj e baj ti'j tyolel Dios Jonás, jatzen c'ajbel te yec'bil cyey—tz̈i Jesús, bix exxin cyxolxin. ");
INSERT INTO mamNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iy'xtzen Jesús cyuya t-xnak'atzxin jlajxe tnijabel a'. Pero tej cyponxin, min e cyna'n t-xnak'atzxin tu'n t-xi' cyii'nxin cywaxin. ");
INSERT INTO mamNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Bix e xi' tkba'nxin cyexin: —Cyc'ojlam cyiiba tuyaj cypan aj fariseo bix xsunj cypan aj saduceo—tz̈ixin tuj ewjel ch'in ti'j cyxnak'tzbil fariseo bix saduceo. ");
INSERT INTO mamNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pero min el cyniy'xin ti'j tyolxin, bix ak'kexin yolel cyxolxxin: —Min sul kii'n kwa, pero tcy'ixin tu'n lk'et pan cye fariseo oj ttzaj klok'o'n—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero el tniy' Jesús ti'j ti otk tz'e'la tyolxin tuj cywitzxin, bix e xi' tkba'nxin cyexin: —Key xjal nuk ch'in n-oc ke cyc'u'ja wi'ja, ¿tiken nchi yolena cyxolxa ti'j mintii' cyway? ");
INSERT INTO mamNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mimpa ma tz'el cyni'ya ti'j ba'n t-xi' nk'o'na cyway? ¿Mimpa na'n cyu'na tej tcub npa'na jjwe' pan t-xol jwe' mil xinak, bix jte' chi'l ttx'akan pan e jaw cychmo'na tej cybaj waa'n xjal? ");
INSERT INTO mamNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Bix mimpa na'n cyu'na tej tcub npa'na jwuuk pan t-xol cyaja mil xinak, bix jte' chi'l ttx'akan pan e jaw cychmo'na? ");
INSERT INTO mamNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Tikentzen min s-el cyni'ya ti'j yaa'n ti'j cyway xi' nkba'na cyey? Juntl maj cxe'l nkba'na cyey, cyc'ojlam cyiiba tuyaj cypan aj fariseo bix xsunj cypan aj saduceo—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eltzen cyniy' t-xnak'atzxin ti'j min e tkbaxin tu'n cyc'ojlan cyiibxin tuyaj cypan aj fariseo bix aj saduceo, sino tuya tej cyxnak'tzbilxin. ");
INSERT INTO mamNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tejtzen tpon Jesús tuj tnom te Cesarea te Filipo, e xi' tkanenxin cye t-xnak'atzxin: —¿Alcye kena tuj cywitz xjal? ¿Ti toc cyu'n xjal ti'j xjal Sma'n tu'n Dios tu'n ntena cyuya xjal? ");
INSERT INTO mamNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bix aj cytzak'be'nxin: —At xjal nkbante ka jay Juan Bautista. At juntl wik nkbante ka jay jtyolel Dios Elías. At juuntl tzin cykba'n ka jay Jeremías. Bix at juuntl tzin cykba'n ja loy juntl tyolel Dios te ootxa—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Bix aj tkanen Jesús: —Yajtzen cyey, ¿altzen kena tuj cywitza? ");
INSERT INTO mamNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bix aj ttzak'be'n jxin Simón Pedro: —Ja teja Scy'o'n tu'n Dios te cawel, jay Tcwal Dios i'tz—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Bix e xi' tkba'n Jesús te Pedro: —Dios ma tzaj tk'o'n t-xtalbil tey, Simón, tcwal Jonás, cuma ja tumel lu yaa'n ma k'oj tey cyu'n xjal. Nuk o'cx Nmana tuj cya'j ma tzaj tyeec'an jlu tey. ");
INSERT INTO mamNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Cxe'l nkba'na tey, jay Pedro, bix “xak” japenina tbiy. C'oquela tisen jun xak c'ajbel te t-xee' jun jaa', bix ja jaa' lu kej xjal chi oquel lpe wi'ja. Bix mlay caman taaw il cyi'j nxjala. ");
INSERT INTO mamNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Cxe'l nk'o'na tey tal jaa' ttzi tcawbil Dios tuj cya'j. Jay kbalte ti pjel cyxol ntanema. Alcyej ctkba'y yaa'n ba'n tu'n tbint cyxol ntanema twitz tx'otx', q'ueleltzen ba'n tuj nwitza tuj cya'j. Jax ju'x alcyej ctkba'y ba'n tu'n tbint cyxol ntanema twitz tx'otx', chin cuyalatzen tuj cya'j—tz̈ixin te Pedro, ");
INSERT INTO mamNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","bix e xi' tkba'nxin cye t-xnak'atzxin tu'n mi'n jaa' tz'oca cykba'nxin ka jaxin Jscy'o'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Cyi'j ja tyem lu, ak' Jesús xnak'tzalec cye t-xnak'atzxin il ti'j tu'n t-xi'xin tuj Jerusalén, tu'ntzen tiy'x nim q'uixc'aj tu'nxin cyu'n nejenel cye xjal bix cyu'n nejenel cye pala bix cyu'n tx'olbal ley. E tkbaxin tu'n tbyet-xin, bix cjawetz itz'jxin te toxen k'ij tbyetlenxitlxin. ");
INSERT INTO mamNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pero min el tyol Jesús ba'n tuj twitz Pedro, bix ex ttxco'nxin ja Jesús cyjunalxin, bix ak' Pedro ocsalec tc'u'j Jesús tu'n mi'n tyolenxin ju'wa. E xi' tkba'nxin: —Taat, mi'nxit tbyeta. Cutz̈it ka mi'n bint jlu ti'ja—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero aj tcye'yen Jesús bix e xi' tkba'nxin te Pedro: —¡Ctela nwitza, Satanás! Pedro, n-oc tona tey ja Satanás. Tcy'i Satanás japan baj waak'ena twitz tx'otx'. Jatzen tyolja tuyaj cyajbil xjal lepchec ti'j Satanás, yaa'n tuyaj tajbil Dios—tz̈i Jesús texin. ");
INSERT INTO mamNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bix e xi' tkba'ntl Jesús cye t-xnak'atz: —Alcyej taj tz'oc lpe wi'ja, cyk'oncjtzen tik'ch cyaja, ojxe tcyaj cyk'o'na tzalu twitz tx'otx'. Cyk'a'y cyiiba te cyamecy tu'n lepchec wi'ja, tisenj weya twitz cruz chin byetela. ");
INSERT INTO mamNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ja tzunj xjal tcy'i tz'oc lpe wi'ja cuma taj tz'oc tk'on tiib ti'j ti taj, cxe'l t-xoo'n tchunk'lal. Pero ja tzunj xjal cyjel tk'o'n tchunk'lal te twitz tx'otx' tu'nj lepchec wi'ja, ctcamantzen tchunk'lal te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ti c'ajbela cykilca twitz tx'otx' te jun xjal ka ma cyaj tk'o'n tchunk'lal te junx maj tu'n ttzyet tu'n? ¿Bix ma jte'tzen ctchja' jun xjal twi' tchunk'lal te junx maj, nuket jac'a tlok'? ");
INSERT INTO mamNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chin ul meltz'aja twitz tx'otx' tuya tipemal Nmana bix cyuya tsanjel Dios tuj cya'j, bix ctzaal nk'o'na, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal, teeylex juun la' alcye xbint tu'n. ");
INSERT INTO mamNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Jaxxix cxe'l nkba'na cyey, at juun cyey tcub tzalu min otk cyim ojxe toc cycye'yena techel ti tten oj tul jxjal Sma'n tu'n Dios tu'n tcawen—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Eltzen wukak k'ij, bix e xi' tii'n Jesús ja Pedro, tuya Jacobo, bixse Juan twi' jun witz nim. Cyjunalxin e xi'kexin. ");
INSERT INTO mamNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Cywitz tzunxin tej tcub meltz'aj tcye'nc Jesús. E koptz'aj twitz tisen tken k'ij, bix tzinxsen ntxakakan t-xbalenxin. Otk tz'oc sak tilbil t-xbalen te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bix tujx naj ul jlet Moisés tuya Elías cywitzxin, bix e yolenkexin tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bix e xi' tkba'n Pedro te Jesús: —Taat, ¡axsen tbanel eto' tzalu! Ka ba'n tuj twitza, cjaweltzen kbincha'na oxe ni' pach, jun te tey, juntl te Moisés, bix juntl te Elías—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mitkna'x tbaj yolen Pedro tej tcub jun muj nkoptz'aj, bix e cyaj bajkexin tuj muj. Bix jey', tuj muj etztzen jun yol. Tz̈i cyjulu: —Jatzen xinj lu Ncwala n-oc tak' weya, bix nimxsen nchin tzalaja ti'j. K'o'nc cyc'u'ja ti' tyol—tz̈i Dios tuj muj. ");
INSERT INTO mamNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tej cybinte t-xnak'atzxin ja yol lu, bi'xsen e cub ttz̈i cyibaj, bix e cub mutzk'ajkexin twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","E tzajtzen lk'e Jesús cytxlaj, bix oc tmoco'nxin ejee'xin, bix e xi' tkba'nxin: —Chi wey'tzen, bix mi'n tzaj ttz̈i cyi'ja. ");
INSERT INTO mamNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tejtzen toc cycye'yenxin, ya min-altl ke xjal e cyilxin, nuk o'cx tjunal Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cyajcatztzen meltz'ajkexin twi' witz, bix e xi' tkba'n Jesús cyexin: —Mi'n txi' cykba'na te jun xjal ti jilel ma cyila, ojxe tjatz itz'j tuj cyamecy jxjal Sma'n tu'n Dios tu'n ntena cyxol xjal—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bix e xi' cykanen t-xnak'atzxin texin: —¿Tikentzenle nbyana cyu'n tx'olbal ley ka il ti'j tzul meltz'aj jxin Elías twitz tx'otx' nejl twitzj xin Sma'n tu'n Dios?—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Bix aj ttzak'be'nxin cyexin: —Jax cyu'n tx'olbal ley nejl tzul meltz'ajte Elías te ninc'ul xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero cxe'lxixse nkba'na cyey, ya ma tzul Elías, pero min el cyniy' xjal ti'jxin, bix ju' tzunj e cub cybyo'n jaxin. Bix ju' pjel weya. Q'uiyelx nim q'uixc'aj wu'na cyu'n xjal—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bix el cyniy'xin ti'j e yolenxin ti'j Juan Bautista. ");
INSERT INTO mamNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tej tzunj cypon meltz'ajkexin jaa' ete'j ke nimal xjal, ul junxin xjal tuya Jesús bix e cub maje twitzxin. Bix e xi' tkba'n texin: ");
INSERT INTO mamNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Taat, k'ak'entz tc'u'ja ti'j ncwala, cuma ntzaj tuj twi'k'a bix nim niy'x q'uixc'aj tu'nk'a. Nim maj nxi' tz'ak tuj k'ak' bix tuj a'. ");
INSERT INTO mamNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xi' wii'na cyuya t-xnak'atza, pero mix xk'anjak'a cyu'n—tz̈i tmank'a otk tz'oc biman ti'jk'a. ");
INSERT INTO mamNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Bix e xi' tkba'n Jesús: —¿Mimpatzen-al xjal n-oc ke cyc'u'j wi'ja? ¿Cykilpakey min tz'el cyni'ya ti'j? ¿Jaa'tzen ta' cyocslabla? ¿Jte'tltzen maj cxe'l nyeec'ana wipemala tu'ntzen toc ke cyc'u'ja wi'ja? Cyii'ntzna wuyena—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bix oc cawenxin ti' biman, bix ex biman tex hora, bix e k'anj nee'. ");
INSERT INTO mamNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yajc'atltzen tej cycyajxin cyjunalxxin, e xi' cykanen t-xnak'atzxin texin: —¿Tikentzen min xko xcyeya tu'n tel klojo'na biman?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Bix aj ttzak'be'nxin cyexin: —Tu'nj yaa'n nimxix cyocslabla, mix s-etza biman cyu'na. Jaxxix cxe'l nkba'na cyey, nuket tz'oc ke cyc'u'ja ti' Dios, ikchetle ju' ch'in cyocslabla tisen jun twitz mostaza, jac'atzen txi' cyk'umena tej witz lu tu'n tjaw k'ukpaj tu'n t-xi' maa chix, ctcuyate witz. Ka min ma baj cyc'u'ja, cykilca ba'n tbint tu'n Dios cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero tej jun wik biman lu mlay tz'el ka mitkx nchi na'ney Dios bix ka mitkx ncwa' cypa'na weyaj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bix iy'kexin tuj departamento te Galilea, bix tej toc cychmon cyiibxin, e xi' tkba'n Jesús cye t-xnak'atzxin: —Inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal, chin xe'l k'o'na tuj cyk'ab xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Chin byetela cyu'n, bix chin jawetz itz'ja te toxen k'ij nbyetlenxitla—tz̈ixin. Bix nim e tzaj cybisxin tej cybintexin ja yol lu. ");
INSERT INTO mamNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tejtzen cyponxin tuj Capernaum, ul kej xin chmol chojentj te nin tja Dios tuya Pedro, bix e xi' cykanenxin texin: —Yajtzen cyey Cyxnak'tzal, ¿mi'mpale tzaj tk'o'nxin jchojbil tu'n tajben tuj tja Dios?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","E xi' tkba'n Pedro: —Tzin tk'o'nxin. Tejtzen tocx Pedro tuj jaa' jaa' e ten Jesús, e tzaj yolen Jesús nejl te Pedro: —¿Ti toc tu'na, Pedro? Ke cawel at twitz tx'otx', ¿te alej chojentj tzin cykanen? ¿Cyepale cycwalxin, bix ka cyej niy'tl xjal?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aj ttzak'be'n Pedro: —Min. Nuk cye cyej niy'tl xjal n-el cykanen. Bix e xi' tkba'n Jesús: —Ju' tzunj, mintii' il ti'j tu'n t-xi' tk'o'n Tcwal Cawel twitz tx'otx' alcabala. ");
INSERT INTO mamNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero kcy'i tu'n koc ten cyakwusalte ke chmol chojentj. Ju' tzunj, cutxa tey ttzii' tnijabel a', bix xoo'nx tuj a' jun ganch te tzyul quis̈. Jtneel quis̈ ctzyetel tu'na, jkonwa ttzijil. Cneteltzen jun pwak tuj ttzijil tu'na. K'intza, bix k'onxa cye chmol chojentj, tu'ntzen tchjet chojentj te weya bix te tey—tz̈i Jesús te Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Cyuj ja k'ij lu, e pon lk'e ke t-xnak'atz Jesús ti'jxin, bix e xi' cykanenxin texin: —Oj tul tcawbil Dios tzul tuj cya'j, ¿alcye xjal mas jawnex tuj?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tu'ntzen taj ttzak'be'nxin, e tzaj ttxco'nxin jun nee' ttxlajxin tu'n toc we' cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Bix e xi' tkba'nxin cyexin: —Jaxxix cxe'l nkba'na cyey, ka min ma cub cych'ixpu'na cynaabla tu'n cyoca tisen ja nee' lu, mlay chi ocxa tuj tcawbil Dios tzul tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Alj xjal ma tz'oc tk'on tiib tu'n toc te jun xjal maans tisen ja nee' lu, ja tzunja mas jawnex tuj tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Alj ma tkba ka il ti' jun nee', jaxse weya il wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pero alj xjal ncub tk'o'n tzpetsabl tuj tbe juntl yaa'n cyiw tuj tocslabl tu'n t-xi' tzpet tuj tbe Dios, masetlpele ba'n oj tcub ye' jun xak al tkul, tu'n t-xi' xe't tuj mar. ");
INSERT INTO mamNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ayxsen cyej xjal twitz tx'otx', cuma ncub cyk'o'n tzpetsabl tuj cybe juntl! Mlay we' at ocsabl c'u'jbaj tu'n t-xi' tzpet jun xjal tuj tbe Dios. ¡Pero ayxsen tej xjal ncub tk'o'n tzpetsabl tuj tbe juntl! ");
INSERT INTO mamNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yaltzen ka ma chi cub tz'aka tuj il tu'n cyk'aba bix ka tu'n cykena, cytx'omela bix cyxoomexa. Mas ba'ntetpele oj tel tx'omet jun cyk'aba bix ka jun cykena tu'n cycyaja cox pero tu'n cyocxa tuj cya'j twitzj tu'n cyxi'y tuj k'ak' te junx maj tuya ca'ba cyk'aba bix ka ca'ba cykena. ");
INSERT INTO mamNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bix ka nchi jyona il tuya tbak' cywitza, cyimetz bix cyxoomexa. Mas ba'ntetpele tu'n cytena tuya junx tbak' cywitza twitz tx'otx' pero tu'n cyocxa tuj cya'j twitzj tu'n cyxi'y tuj k'ak' te junx maj tuya cyca'bel tbak' cywitza. ");
INSERT INTO mamNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mi'n tz'el cyiiq'uena ke nee', cuma jaxxix cxe'l nkba'na cyey, n-oc cycye'yen tsanjel Dios tuj cya'j ti nbaj cyi'j, bix nchi pon kej ángel lu twitz Dios te kbalte texin ti nbaj. ");
INSERT INTO mamNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Il ti'j q'uelel cyni'ya ti'j o chin u'la te jyol cyej xjal o che'x tzpet, tu'ntzen cyclet wu'na, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Ti toc cyu'na? Ka at jun cylel carnel, ka at syent tcarnelxin, bix ka ma txi' tz'ak junjil, ¿mi'mpa cyaj tk'o'nxin jnoventa y nuevejil jaa' ete'jil, tu'n t-xi'xin jyol tej jil otk cyaj tz'ak, tu'n tcnetjil? ");
INSERT INTO mamNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bix ka ma cnetjil tu'nxin, jaxxix cxe'l nkba'na cyey, mas ctzalajelxin ti'j ja jil lu twitzj noventa y nuevejil min e che'x tzpet. ");
INSERT INTO mamNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ju' tzunj, tzinen ta' tcy'i Cymana tuj cya'j tu'n t-xi' jun nee' tuj il. ");
INSERT INTO mamNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ka at jun k'i'n tyol Dios tu'n bix ka ma tbincha il, cutxetey tuya tu'n t-xi' tkba'n te tu'n mi'n binchantl il, pero cyjunala tuya. Ka ma cyaj tk'o'n til, ma camana tu'n mi'n cyaj j-ocslala tuj til. ");
INSERT INTO mamNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero ka min ma cyaj tk'o'n til, k'i'nx juntl ocslal bix ka ca'ba ocslal tuyey, tu'ntzen at ca'ba oxe tstiwa tu'n toc cycye'yen tii'n tnaabl j-ocslala. ");
INSERT INTO mamNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka tcy'i binchal il tu'n toc tbi'n cyyola, kbanx cye cykilca ocslal tuj tja Dios. Ka ma tz'el tiiq'uen cyyol cykilca ocslal, yaa'ntltzen ocslal tuj cywitza, sino tisenc'a jun xjal yaa'n te ttanem Dios bix ka jun chmol alcabala. ");
INSERT INTO mamNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jaxxix cxe'l nkba'na cyey, ejee'y kbalte ti pjel cyxol ocslal twitz tx'otx'. Alcyej cxe'l cykba'na yaa'n ba'n tu'n tbint, ba'ntzen q'uelel cyyola tuj cya'j. Bix alcyej cxe'l cykba'na ba'n tu'n tbint cyxol ocslal, jax ba'ntzen q'uelel cyyola tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Juntl maj cxe'l nkba'na cyey, ka at ca'ba cyey twitz tx'otx' junx ta' cykanbila te Dios, ctzaal k'o'n cyey tu'n Nmana Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Cbinel tu'n Nmana, cuma jaa' nchmet ca'ba oxe ocslal tu'n cyajben weya, ntii'n tzuna cyxol—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bix e pon lk'e Pedro ti' Jesús, bix e xi' tkanenxin te: —Taat, ¿jte' maj cwel nnajsa'na til jun xjal ka ma tbincha jun ka' wi'ja? ¿Yaa'mpa wuuk maj?—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aj ttzak'be'n Jesús: —Min nxi' nkba'na tey ka o'cx wuuk maj. Jatzen nxi' nkba'na tey tu'n tcub tnajsa'na cykilca maj, seya wuuk maj setenta. ");
INSERT INTO mamNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jnbaj cyej xjal ttanem Dios tisenj e baj cyej xjal jun maj tjak' tcawbil junxin rey twitz tx'otx'. E tajbe rey tu'n tchjet texin cykilca cyc'asben t-ak'analxin. ");
INSERT INTO mamNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tej cypon t-ak'analxin twitzxin tu'n tchjet cyc'asben, e pon k'i'n twitzxin jun t-ak'analxin nimxsen tc'asben. Laaj mil talento tc'asben. ");
INSERT INTO mamNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero mintii' tpwak. Ju' tzunj, e tkba rey tu'n t-xi' q'ueyet, tuyax t-xu'l, cyuyax tcwal, tuyax cykilcaj at te, tu'ntzen tk'oj pwak te rey. ");
INSERT INTO mamNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tej tbinte t-ak'analxin jlu, bi'xsen e cub mutzk'ajxin twitz tx'otx' twitz rey, bix e xi' tcubsa'n twitz texin: “Taat, ten tpasensyiya wi'ja, bix cxe'l nchjo'na cykilca nc'asbena tey,” tz̈i t-ak'analxin. ");
INSERT INTO mamNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bix oc q'uixbe tc'u'j rey ti' t-ak'analxin, bix e xi' ttzakpi'nxin, bix e cub tnajsa'nxin cykilca tc'asben. ");
INSERT INTO mamNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero tej tetz jxin el libre, bix e xi'xin jyolte tej jun tuyaxin c'asbenel twitzxin. At ch'inee' tc'asben twitzxin. Bix e xi'xin tzyulte, bix oc tẍk'o'nxin tkul, bix e xi' tkba'nxin te: “K'ontz jtey tc'asbena jun syent denario weya.” ");
INSERT INTO mamNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Bix e cub mutzk'aj tuyaxin twitz tx'otx' twitzxin, bix e xi' tcubsa'n twitz texin: “Ten tpasensyiya wi'ja, bix cxe'l nchjo'na nc'asbena tey,” tz̈i. ");
INSERT INTO mamNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero ja tzunj texin min e xi' tbi'nxin tuyaxin. Nuk o'cx ocx tk'o'nxin tuj tzee', tu'n mi'n tz'etz ojxe tchjet cykil tc'asben. ");
INSERT INTO mamNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tejtzen toc cycye'yen niy'tl t-ak'anal rey ti otk baj, ka'xsen el tuj cywitzxin, bix e xi'kexin kbalte te rey ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tbintetzen rey, bix e tzaj ttxco'n rey jaj xin ak'analxin otk najsaxin tc'asben, bix e xi' tkba'nxin te: “Jay ak'anal yaa'n ba'n, e cub nnajsa'na cykilca tc'asbena weya cuma e tzaj tcubsa'na twitza weya. ");
INSERT INTO mamNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Yaa'mpatzen tu'n toc q'uixbe tc'u'ja ti' tuyey, tisen e xi' nk'o'na lastim tey?” tz̈i rey. ");
INSERT INTO mamNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bix e tzaj tk'oj rey, bix e xi' tk'o'nxin tuj cyk'ab pjul xjal tu'n tq'uixbaset nim ojxe tchjet cykilca tc'asben texin. ");
INSERT INTO mamNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jax ju'x ctbincha' Nmana tuj cya'j cyi'ja ka min xcub cynajsa'na ke cyuyey tuya cykil cyc'u'ja—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tejtzen tbaj tkba'n Jesús kej yol lu cye t-xnak'atz, etzxin tuj Galilea, bix e xi'xin tuj jun lugar nka departamento te Judea jlajxe nima' Jordán. ");
INSERT INTO mamNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bix nimxsen xjal oc lpe ti'jxin, bix e cub tk'a'nexin kej xjal yaab jatzewe. ");
INSERT INTO mamNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bix e pon cabxin fariseo tuyaxin. Nuktzen ti cyajaxin tu'n tcub tz'akxin tuj tyolxin. Ju' tzunj, e xi' cykanenxin texin: —¿K'o'npale tu'n ley tu'n tel tpa'n tiib jun xinak ti' t-xu'l nuk tu'n tlaj jun tiixjati'?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bix aj ttzak'be'nxin cyexin: —¿Bajxpa jaw cys̈i'na tuj tyol Dios ti toc tu'n Dios ti'j jun moj xjal tej tbint tu'n? Tzin tkba'n tyol Dios cyjulu: “E cub tbincha'nte Dios xinak tuya xuuj. ");
INSERT INTO mamNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ju' tzunj cyjela tk'o'n xinak tman bix ttxu tu'n toc maje tuya xuuj. Cyca'beltzen chi elel tisen junx xjal bix tu'n cyel junx,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ju' tzunj, yaa'n ca'batl cybet, sino tisen jun xjal mlay tz'el pax. Ju' tzunj, j-o tz'oc tmojba'n Dios te junx, yaa'n tu'n tcub cypa'n cyiib—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","E xi' cykba'nxin texin: —¿Tikentzen e tcuya te Moisés tu'n t-xi' tk'o'n xinak jun u'j te xuuj tzin tkba'n otk chi cub pax?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Bixse aj ttzak'be'n Jesús cyexin: —Ju'tzen tcyajlen tkba'n Moisés tu'n tex cylojo'na cyxu'la, pero tu'n cyyuwinela. Pero tuj tneel yaa'n ju' tewa. ");
INSERT INTO mamNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jatzen weya, cxe'l nkba'na cyey, alj ma tz'el tpa'n tiib ti' t-xu'l, bix ka mintii' nbint tu'n t-xu'l, bix ma maje tuya juntl xuuj, tzin tbincha'n pajlel—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","E xi' cykba'n t-xnak'atz Jesús te: —Ka ju' tten xinak tuya xuuj, masetpele ba'n tu'n mi'n maje jun xjal tuya jun xuuj—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pero aj ttzak'be'nxin cyexin: —At juun xjal mas ba'n tu'n mi'n chi maje tuya jun xuuj. Pero mlay bint tu'n cykilca xjal tu'n mi'n maje, nuk o'cx kej xjal ma k'oj tu'n Dios tu'n mi'n chi maje. ");
INSERT INTO mamNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","At juun xjal mlay tu'n cymaje cuma cyitz'jlenx mixbe tu'n cyoc ipan cyi' xuuj. At juuntl xjal mlay tu'n cymaje cuma ma chi cpet cyu'n xjal. Bix at juuntl xjal ma tz'oc cyk'on cyiib tu'n mi'n chi maje nuk tu'n cyajben te Dios tu'n ttz̈'iy tcawbil Dios. Alcyej xjal jac'a bint jlu tu'n, e tbinchante—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yajc'atltzen, bix e xi' cyii'n xjal ke cynee' twitz Jesús, tu'ntzen tcub tk'o'nxin tk'abxin cyibaj, bix tu'n tna'nxin Dios cyi'j. Pero bix ak' ke t-xnak'atzxin te cawlec cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero e xi' tkba'n Jesús: —Cytzakpi'nctz kej nee'wa tu'n cytzaj wi'ja, cuma nuk ka ju' tanem jun xjal tisen ejee' nee'wa, ba'ntzen tocx tuj tcawbil Dios—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bix e cub tk'o'nxin tk'ab cyibaj nee', bix exxin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ultzen junk'a xjal tuya Jesús, bix oc tkanenk'a te: —Xnak'tzal ba'n, ¿alcye ba'n cbinel wu'na tu'n ncamana nchunk'lala te junx maj?—tz̈ik'a. ");
INSERT INTO mamNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aj ttzak'be'n Jesús tek'a: —¿Tikentzen nchin oca tk'o'na te ba'n? Min-alte jun xjal ba'n. Nuk ja te Dios ba'n. Yal tzunj tkanbila, ka taja tu'n tcamana tchunk'lala te junx maj, nimanx kej mandamyent e cyaj tk'o'n Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Bix e xi' tkanenk'a: —¿Alcyetzen ke mandamyent tu'n tbint wu'na? Bix e xi' tkba'n Jesús: —Mi'n chi byona xjal. Mi'n chi jyona juntl xuuj te pajbaj. Mi'n chi alk'ana. Mi'n chi ẍtak'ena. ");
INSERT INTO mamNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chi nimala twitz cymana bix cytxuy. Bix c'oquelxix tak' jun xjal cyey tisen n-oc cyey cyak' cyey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bix e xi' tkba'n jk'a xjal te Jesús: —Cykilcaj lu o bint wu'na. ¿Alcyetzen juntl mina'x tbint wu'na?—tz̈ik'a. ");
INSERT INTO mamNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","E xi' tkba'n Jesús tek'a: —Ka taja tu'n toca tz'aklxix, q'ueyex tik'ch tey, bix k'onxse twi' cye mebe. Ju'tze cnetela tk'inemala tuj cya'j. Ojtzen tbint tu'na, lpetztzen wi'ja—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tej tbintek'a jyol lu, e tzaj tbisk'a bix exk'a, cuma k'ina xsunk'a. ");
INSERT INTO mamNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bix e xi' tkba'n Jesús cye t-xnak'atzxin: —Jaxxix cxe'l nkba'na cyey, cyiwxsen tu'n tocx jun k'ina tuj tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Cxe'l nkba'ntl cyey, mas cyiw tu'n tocx jun k'ina tuj tcawbil Dios twitzj tu'n tex junjil tz̈ej tuj tẍyo'p bak—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Toctzen cybi'n t-xnak'atzxin jlu, e jaw klee'kexin, bix e xi' cykanenxin: —Ka ju' ttena, ¿titzen tten tu'n tclet jun xjal?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Toctzen tcye'yenxin ejee'xin, bix e xi' ttzak'be'nxin: —Cye xjal, mlay bint cyu'nx tu'n cyocx tuj tcawbil Dios. Pero jatzen te Dios, cykilca ba'n tbint tu'n—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bix ak' Pedro kbalxte texin: —Taat, ttzki'na o cyaj kk'o'na tik'ch keya tu'n koc lpeya ti'ja. ¿Alcyetzen ctzaal k'o'n keya?—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aj ttzak'be'n Jesús: —Jaxxix cxe'l nkba'na cyey, oj toc cykilca te ac'aj, bix oj ncub keya tuj nk'ukbila jawnex tu'n ncawena tibaj cykilca, jax ju'x cyey, ejee'y ma chi oc lpeya wi'ja, ck'ojel cyey tu'n cycub key tuj cyk'ukbila tu'n cycawena cyibaj jcablaaj cloj tiy'jil Israel. ");
INSERT INTO mamNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bix alcyej nuk wi'ja ma cyaj tk'o'n tja, bix ma titz'en, ttzicy, tman, ttxu, ke tcwal, ttx'otx', nimxsen ctzaal k'o'n te, bix ctiik'eltzen tchunk'lal te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero nim xjal nintzaj ja'lewe, ejee' tzunj chi oquela te ch'in tuj tcawbil Dios. Bix nim xjal yaa'n nintzaj ja'lewe, ejee' tzunj chi oquel te nintzaj tuj tcawbil Dios tzul—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Bix e xi' tkba'ntl Jesús cye t-xnak'atz: —Jpjel oj tul tcawbil Dios tisenj e baj jun maj tuj tawal jun xjal taaw tx'otx'. Ex taaw tx'otx' te kskix jyol ak'anal tu'n cyak'anan tuj tawal. ");
INSERT INTO mamNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","E binttzen ti'j tu'nxin cyuya t-ak'analxin jun denario pwak twi' cyc'u'j jun k'ij. E cycuya ak'anal, bix e xi' tsma'nxin ejee' tuj tawalxin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tej tpon beljaj hora te klax, ex taaw tx'otx' juntl maj, bix e tilxin cab xjal ete' tuj plaza mintii' cyaak'en. ");
INSERT INTO mamNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Bix e xi' tkba'nxin cye: “Jax ju'x cyey, cyucxa cyey tuj wawala tu'n cyak'anana, bix oj tex k'ij, cxe'l nk'o'na cyk'ija,” tz̈ixin. Bix exkexin ak'anal. ");
INSERT INTO mamNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tej tpon chil k'ij, juntl maj ex taaw tx'otx' jyol ak'anal. Bix te oxe hora te kale, e jyonxin ak'anal tu'n cyak'anan tuj tawalxin. Bix te cykilca ak'anal, e xi' tkba'nxin tu'n t-xi' tk'o'nxin cyexin cyk'ijxin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tejtzen tpon tajlal jwe' hora te kale, juntl maj e xi'xin cyxol xjal, bix e cnet juun xjal tu'nxin mintii' cyaak'en. Bix e xi' tkba'nxin cyexin: “¿Tu'n tiken nuk n-ex cyk'ija wa'lkey tzalu?” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","E xi' cytzak'be'nxin: “Min-al jun xjal ma tzaj tk'o'n kaak'ena,” tz̈ikexin. E xi' tkba'nxin: “Cyucxa cyey cyuya juntl wak'anala tuj wawala, bix oj tbaj k'ij, cxe'l nk'o'na cyk'ija,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tejtzen tex k'ij, e xi' tkba'n taaw tx'otx' te tmayordomo: “Txcontza ke ak'anal bix k'onxa twi' cyc'u'j. Nejl, k'onxa twi' cyc'u'j kej ak'anal e xi' ak'anal te yaj. Ja tzunj kej ẍi ak' ak'anal nejl, manc'biltzen cxe'l tk'o'na twi' cyc'u'j,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tejtzen cyul kej ak'anal otk chi ak' ak'anal te jwe' tajlal te kale, teeyle juun e cyiik' jun denario. ");
INSERT INTO mamNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ju' tzunj, tej cyul kej ak'anal otk chi ak' ak'anal te klax, tuj cywitz at tu'n cychjet mas twi' cyc'u'j. Pero ju'x e chjeteke tu'n junx denario. ");
INSERT INTO mamNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tej cyiik'ente twi' cyc'u'j te jun denario, e jaw yolenke ti' taaw tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","E xi' cykba'nxin: “Kej xjal lu ẍi pon ak'anal te manc'bil, nuk junx hora ẍi ak'anan. Pero ma txi' tk'o'na jun twi' cyc'u'j tisenx keya, bix ma ko sicta tuj ak'untl bix ma tziy'x ti' k'ij cykil k'ij ku'na,” tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pero aj ttzak'be'nxin te jun cyxolxin: “Jay wuyena, mintii' ka' tzin nbincha'na cyey. ¿Yaa'mpatzen xbint ti'j ku'n tu'n jun denario pwak twi' tc'u'ja? ");
INSERT INTO mamNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","K'inxa twi' tc'u'ja, bix cutxey. Cyej ak'anal ẍi pon ak'anal te manc'bil, waja txi' nk'o'na jun twi' cyc'u'j junx tuyey. ");
INSERT INTO mamNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Inayena taaw ntx'otx'a bix taaw npwaka. ¿Yaa'mpa tumel tu'n nbinchantiya alcye waja ti'j jweya? ¿Tiken ma tzaj tk'oja tu'n ma txi' nk'o'na wanema cyej xjal lu?” tz̈i taaw tx'otx' te jun ak'anal. ");
INSERT INTO mamNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ju' tzunj, nim xjal nintzaj tuj cywitz ja'lewe, chi oqueltzen te ch'in tuj manc'bil k'ij. Bix nim xjal yaa'n nintzaj ja'lewe, chi oqueltzen te nintzaj la' alcye jun k'ij—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tej ch'itk tpon tumel tu'n t-xi' Jesús tuj Jerusalén, ex ttxco'nxin ke cablaaj t-xnak'atzxin cyjunalxxin tuj be, bix e xi' tkba'nxin cyexin: ");
INSERT INTO mamNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Cybintz nyola. Ko xe'l tuj tnom te Jerusalén, jaa'j chin xe'la k'o'n tuj cyk'ab ke nejenel cye pala bix ke tx'olbal ley. Ejee' tzunxin chi kbalte tu'n nbyeta, ");
INSERT INTO mamNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","bix cxe'l cykba'n tu'n nxi' k'o'na tuj cyk'ab nmak xjal te Roma. Ejee'tzen xinj chi oquel xmucchante weya, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal. Cxe'l cyk'o'n kej xjal yaa'n judío lu tz'u'n wi'ja, bix chin cwel cybyo'na twitz cruz. Pero te toxen k'ij ncyimlena oj njaw itz'jtla juntl maj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","E pontzen twitz Jesús t-xu'l jxin Zebedeo cyuya talxuj, Juan bix Jacobo. E tajbexuj tu'n t-xi' tkanenxuj jun xtalbil, bix e cub majexuj twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Bix e xi' tkba'nxin texuj: —¿Alcye taja? Aj ttzak'be'nxuj: —Oj toc tey te cawel, waja tu'n cycawen kej ca'ba wala lu tuyey, jun tuj tmank'aba bix juntl tuj tneẍa—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero aj ttzak'be'n Jesús: —Min tz'el cyni'ya ti'j ti jilel ntzaj cykanena weya. ¿Jac'apatzen tziy'x cyey cyu'n oj tiy' a' cyc'u'ja tisenj at tu'n tiy'x wu'na?—tz̈ixin. Bix aj cytzak'be'nxin: —Cbinel ke ku'n—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","E xi' tkba'nxin cyexin: —Jax cyu'na q'uiyal a' cyc'u'ja cyu'na tisenj weya. Yaltzen cykanbila weya, yaa'n inayenwe chin kbalte al ccawel wuyena oj woca te cawel. Jatzen ma txi' k'o'n tu'n Nmana te alcyekej tu'n cycub ke ntxlaja tu'n cycawen wuyena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Toctzen cybi'n jlaajtlxin t-xnak'atz Jesús tyol Jacobo tuya Juan, bix oc chi'l ch'inkexin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero e tzaj ttxco'n Jesús cykilcakexin, bix e xi' tkba'nxin cyexin: —Cytzki'ntl tzuna kej cawel te twitz tx'otx' nchi cawen tu'n t-xi' cyyeec'an nim cyajwalel cye xjal. Bix cyiw nchi oc cyi' xjal tjak' cycawbil. ");
INSERT INTO mamNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Perotzen cyey cyxol, yaa'ntzen ju' ctemela tewa. Al tzunj taj tu'n tten nintzaj cyxola, c'oquel tipen ti'j tu'n tajben cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bix alcye taj tu'n toc te nejenel cyxola, nejl c'oquel te tajbel te cykilcatl cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chi oquela tisen weya. Min in ula tu'n cyajben xjal weya. Nuk o'cx in ula tu'n wajbena cye xjal, bix tu'n t-xi' nk'o'na nchunk'lala tu'n cyco'pj nim xjal tuj tk'ab il—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yajc'atltzen, bix e pon Jesús cyuya t-xnak'atz tuj tnom te Jericó. Tejtzen cyetz Jesús tuj Jericó, nimxsen xjal oc lpe ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Attzen ca'ba xjal mos̈ k'uklc'a ttzii' be. Tej cybintexin tzul Jesús, e jawxsen s̈-inkexin: —Taat, tiy'jil David, k'ontza lastim keya—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kej xjal ete' tuya Jesús, oc ilente ke mos̈ tu'n mi'n tz'el cywi'. Pero mas el cys̈i'nxin cywi'xin, bix e xi' cykba'nxin juntl maj: —¡Taat, tiy'jil David, k'ontza lastim keya!—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tej toc tbi'n Jesús ke mos̈, bix e we'xin, bix e xi' tsma'nxin xjal tu'n t-xi' cyii'n ke mos̈ twitzxin, bix e xi' tkba'nxin cyexin: —¿Ti cyaja tu'n tbint wu'na cyi'ja?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bix aj cytzak'be'nxin texin: —Taat, k'ontza keya tu'n kcye'yena—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bix e jaw tlastim Jesús cyi'jxin, bix oc tmoco'nxin tbak' cywitzxin. Bix n-ultl tnaabl tbak' cywitzxin, bix ak' xe'l lpekexin ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tejtzen cypon Jesús tuj tnom te Betfagé, jun coc' tnom tcub t-xee' jwitz Olivos tbi bix nka Jerusalén, e xi' tsma'n Jesús ca'ba t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","E xi' tkba'nxin cyexin: —Cyucxatzen tuj jni' tnom n-oc kcye'yen jatzewe. Oj cypona, c'oquel cycye'yena junjil bur yo'lecjil, bix tuyax jun taljil ttxlajjil. Cypjumeltzen cyca'beljil, bix cyii'ntz tzalu. ");
INSERT INTO mamNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Katzen al ma tz'oc kanente cyey tiken n-el cypju'na ke jila, cxe'l cykba'na: “Ejee' jilja chi c'ajbel te Kaawa,” tz̈i cybela, bix chi tzaal tk'o'n naj texin ejee'jil—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","E baj jlu tu'ntzen tel jax j-e tkba Dios tu'nj tyolel jatxe ootxa. E tkba Dios te tyolel cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kbanx cye xjal te Israel aj Sión cyjulu: ‘C'ulel Cycawela cyuyey. Maansxin, bix tjaxxin tibaj jun tal bur ikel iktz oj tulxin,’ tz̈i tbela,” tz̈i Dios te tyolel. ");
INSERT INTO mamNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bix e xi'kexin, bix e cybinchaxin tisen e xi' tkba'n Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bix e xi' cyii'nxin bur tuyax taljil te Jesús, bix e jax cyk'o'nxin cyxbalenxin tuj tzalcyi'jjil te jun k'ukbil, bix e jax cyk'o'nxin Jesús tibaj xbalen. ");
INSERT INTO mamNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bix e xi' bet bur, bix nimxse xjal e bet tuyaxin, bix e cub cyk'o'n cyxbalen tuj tbexin. Atl xjal el cytx'omen tk'ab xa'j tu'n tcub cyk'o'n tuj tbexin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bix cykilcaxsen xjal nejl twitzxin bix lepch tzinxsen nchi s̈-in: —¡Tcy'iwlanxit tchman David, jaj Kcawel! ¡Chjonte te Dios ti'j ja xjal lu o tzul sma'n tu'nxin te cawel! ¡Jawxit nimset tbi Kaaw Dios tuj cya'j!—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tejtzen tocx Jesús tuj Jerusalén, e jaw klee' ke xjal ti'j tnimal xjal nchi ocx lpe ti'j Jesús, bix e xi' cykba'n: —¿Alcye ja xjal lu? ");
INSERT INTO mamNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bix aj cytzak'be'n kej xjal lepchec ti'j Jesús: —Ja te Jesús tyolel Dios, aj Nazaret tuj Galilea—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bix ocx Jesús tuj nin tja Dios bix etz tlojo'nxin kej xjal ete'cx lok'ol bix q'ueyel tuj tja Dios. Bix e jaw tpac'tz'enxin kej mes cyej xjal ch'ixpul twitz pwak tuyax cyk'ukbil cyej xjal nchi q'ueyen cucu'. ");
INSERT INTO mamNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Bix e xi' tkba'nxin cyexin: —Tzin tkba'n tyol Dios cyjulu: “Il ti'j tu'n tajben njaya te nablte nbi'ya,” tz̈i Dios. Pero cyey, ma tz'oc cyk'o'na te jun cyja alak'—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bix ultzen kej xjal mos̈ bix kej xjal cox tuya Jesús tuj tja Dios, bix e cub tk'a'nexin cykilca. ");
INSERT INTO mamNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero cyej nejenel cye pala bix cyej tx'olbal ley, tej cylonte jjawnex tipemal e xi' tyeec'an Jesús, bix tej cylonte hasta ke nee' nchi s̈-in tuj tja Dios: “¡Tcy'iwlanxit tchman David, jaj Kcawel!” e tzaj cyk'oj ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bix e xi' cykba'nxin texin: —¿Tzimpa tbi'na jnxi' cykba'n kej nee' lu?—tz̈ikexin. Bix aj ttzak'be'nxin: —Tzin. Yajtzen cyey, ¿bajxpa jaw cys̈i'na tuj tyol Dios ti toc tu'n ti'j lu? Tzin tkba'n cyjulu: “Te cyej nee' bix ẍlak nchi ch'u'n, o txi' tk'o'na tu'n tjaw cynimsa'n tbi'ya,” tz̈i jun xjal te Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bix e cyaj tk'o'nxin ke xjal, bix etzxin cyuya t-xnak'atzxin tuj tnom te Jerusalén, bix e ponxin tuj tnom te Betania, jatztzen e cyja'xin te koniyan. ");
INSERT INTO mamNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tetzen juntl k'ij te klax, tej cypon meltz'aj Jesús tuj Jerusalén, oc tak' weyaj texin tuj be. ");
INSERT INTO mamNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","E xi' tcye'yenxin jun wi' lo'pj higuera tcub ttzii' be. Pero tejtzen tpon lk'exin ti' tken higuera, mintii' twitz e cnet tu'nxin. Nuk o'cx t-xaak at. Ju' tzunj, e xa' tkba'nxin te tken higuera: —Junxse maj mlayx tz'octl twitza—tz̈ixin. Bix tujx naj e tzkij jtken higuera. ");
INSERT INTO mamNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tej cylonte t-xnak'atzxin ti otk baj, e jaw klee'kexin, bix e xi' cykanenxin: —¿Titzen tten xtzkij tken higuero tujx naj?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Bix aj ttzak'be'n Jesús cyexin: —Jaxxix cxe'l nkba'na cyey, ka ma ke cyc'u'ja ti' Dios, bix ka min ma baj cyc'u'ja, yaa'n nuk o'cx jac'a bint tu'n ttzkij tken higuera cyu'na, pero oj t-xi' cykba'na tej witz lu tu'n tjaw k'ukpaj tu'n t-xoo'n tiib tuj mar, ctcuyate witz. ");
INSERT INTO mamNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bix cykilcaj cxe'l cykanena te Dios, ka ma ke cyc'u'ja ti'j, ccyiik'ela—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tej tocx Jesús tuj nin tja Dios, ak'xin xnak'tzal. Bix e pon lk'e kej nejenel cye pala bix kej nejenel cye xjal ti'jxin, bix e xi' cykba'nxin texin: —¿Titzen jilel toclena tu'n tbinchantiya cykilcaj lu? ¿Bix al ma tz'oc k'onte tajwalela tu'n tex tlojo'na ke q'ueyel tuj tja Dios ewe?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bix aj ttzak'be'nxin cyexin: —Jax ju'x weya cxe'l nkanena cyey. Ka ma tzaj cykba'na weya alcyej nkanbila cyey, jaxse jac'a txi' nkba'nwe cyey tuya alcye wajwalela ncwa' nbincha'na cykilcaj lu. ");
INSERT INTO mamNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tej cybautizarj xjal tuj a' tu'n Juan Bautista tu'n binne cyten xjal tej tul jxjal Scy'o'n tu'n Dios, ¿jaa' e tzaa' tajwalelxin, tu'npa Dios tuj cya'j, ma tu'npa xjalj?—tz̈ixin. Bix ak' kej xin pala bix kej tx'olbal ley yolel cyxolx ti tten tu'n taj cytzak'be'nxin: —Katzen ma txi' kkba'n ka ja Dios e tzaj k'onte taak'en Juan, bixse c'aaltz tkba'nxin ka tu'n tiken min oc kbi'na tyol Juan. ");
INSERT INTO mamNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero ka ma txi' kkba'n e tk'umen Juan nuk texxin tyolxin, q'uelel cyiiq'uen xjal ejoo', cuma tuj cywitz xjal, tyolel Diosxin—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ju' tzunj, e xa' cykba'nxin te Jesús: —Min ktzki'nke—tz̈i tzunkexin te Jesús. Bix aj ttzak'be'nxin cyexin: —Jaxne mlay txi' nkba'na cyey al e tzaj k'onte weya woclen. ");
INSERT INTO mamNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Pero cxe'l nkanena cyey, ¿ti toc cyu'na ti'j ja techel lu? At junxin xjal at ca'ba tcwal. E ponxin tuyaj tcwalxin mas nim bix e xi' tkba'nxin: “Ncwala, waja tu'n tak'anana tuj wawala ja'lewe.” ");
INSERT INTO mamNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bix aj ttzak'be'nk'a: “Min chixa.” Pero yajxitltzen, ajtztl ti' tanemk'a, bix e xi'k'a. ");
INSERT INTO mamNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jax ju'x e ponxin tuya juntl titz'enk'a, bix e xi' tkba'nxin: “Ncwala, waja tu'n tak'anana tuj wawala ja'lewe.” Aj ttzak'be'n tcwalxin: “Cu, taat.” Pero min e xi'k'a. ");
INSERT INTO mamNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tuj cywitza, ¿alcyetzen cyxol cyca'bel k'a e cybinchak'a tajbil cymank'a?—tz̈i Jesús. Aj cytzak'be'nxin: —Jaj k'a tzicbaj. Bix e xi' tkba'n Jesús cyexin: —Jaxxix cxe'l nkba'na cyey, mas cyiw tu'n cyocxa tuj tcawbil Dios cywitzj kej xjal chmol chojentj bix kej xuuj aj paj. ");
INSERT INTO mamNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tzin nkba'na jlu cyey cuma tej tul Juan Bautista kbalte ti tten tu'n cyoca jiquen twitz Dios, min e cyocslay jaxin. Pero kej chmol chojentj bix kej xuuj aj paj, tej cybinte jaxxix tyolxin, e cyocsla tyolxin. Pero cyey, amale e cyileta ncyaj cycye'yen xjal cyil, pero min ajtz ti' cyanema tu'n cyocslana tyol Juan Bautista. ");
INSERT INTO mamNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Cybinxa juntl techel. At junxin xjal e cu'x tawa'nxin cab tken uva bix oc tk'o'nxin penwen ti'j. Bix e jaw tbincha'nxin jun ttemlel uva tu'n tel vino ti'j, bix e jaw tbincha'nxin jun jaa' nim twe' te c'ojlablte tawalxin. Bix e cub tninc'u'nxin cyuya manal tx'otx' tu'n t-xi' cycye'yen ti'j tawalxin. Bix exxin tuj tbexin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tejtzen tpon tumel tu'n t-xilj uva, e xi' tsma'nxin cab tsanjelxin cyuya manal tx'otx' te k'ilte jun tkiy' twitz uva. ");
INSERT INTO mamNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero tejtzen cypon tsanjelxin, bix oc cypju'n manal tx'otx' jun tsanjelxin, bix e cub cybyo'n juntl, bix toxen oc cyxoo'nxin tuya xak. ");
INSERT INTO mamNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bix e xi' tsma'n taaw tx'otx' juntl cloj tsanjelxin cyuya t-ak'analxin, mas cybet cywitz kej e tzaj tsma'nxin nejl. Pero juntl maj e cybincha t-ak'analxin cyi'j tisen e cybincha nejl. ");
INSERT INTO mamNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Manc'biltzen e xi' tsma'nxin tcwalxin, bix e xi' tkba'nxin: “Il ti'j cybi' manal tx'otx' ncwala oj tpon,” tz̈ixin tuj tanemxin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero tej t-xi' cycye'yen ke manal tx'otx' tcwalxin, e xi' cykba'nxin cyxolxxin: “Lu jk'a tcwal jxin taaw tx'otx' tzule. Tele tek'a cyjele ja tx'otx'e te tkabk'a. Ko kbya'c'ak'a, tu'ntzen tcyaj te ke,” tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bix e tzaj cytzyu'nxin jak'a, bix ex cyii'nxin tuj cojbil, bix e cub cybyo'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cxe'l nkanena cyey, ¿ti ctse' jxin taaw awal kej t-ak'analxin oj tulxin?—tz̈i Jesús cye pala bix tx'olbal ley. ");
INSERT INTO mamNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bix aj cytzak'be'nxin te Jesús: —Chi cwel tbyo'n taaw tx'otx' kej ka' manal tx'otx', bix cninc'ulxin ti'j cyuya cabtl xjal tu'n tcub cypa'nxin cyawalxin tuyaxin oj tpon tumel—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","E xi' tkba'n Jesús cyexin: —Tisen el iiq'uet tcwal taaw tx'otx', ju'xsen q'uelel iiq'uet jxjal Scy'o'n tu'n Dios. ¿Bajxpa cyila tuj tyol Dios ti toc tu'n ti'j jlu? Tzin tkba'n cyjulu: “Jxak el cyiiq'uen ke binchal jaa', c'oquel xak tej xak mas nintzaj te t-xee' jaa'. Jatzen Dios cwel meltz'unte xak te tbanel xak. Ju' tzunj, axse q'uelela tuj kwitz,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Cxe'l nkba'na cyey, cuma ma tz'el cyiiq'uena Tcwal taaw tx'otx', ju' tzunj, q'uelel k'i'n tcawbil Dios cyi'ja, ejee'y tnom te Israel, tu'ntzen t-xi' k'o'n te jun wik xjal cyaj txi' cyk'o'n te Dios cuma texin. ");
INSERT INTO mamNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ja xak ma tz'el iiq'uet, jatzen xak kbalte ti pjel cyi' xjal. Alj xjal ncub tz'ak twi'j xak lu, bi'x cwel buchj tu'n, bix oj ttzaj tz'ak jxak lu tibaj jun xjal, bi'x cwel patz'ex—tz̈i Jesús cye nejenel xjal te Israel. ");
INSERT INTO mamNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tej cybinte nejenel cye pala cyuyax ke fariseo ke techel e tkba Jesús, el cyniy' ti'j ka cyi'jxin otk yolena Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pero tej toc cyipenxin ti'j tu'n ttzyet Jesús cyu'nxin, mintzen e cytzuyxin jaxin tu'n cytz̈i jxjal lepchec ti'jxin, cuma tuj cywitz xjal, tyolel Diosxin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Bix e xi' tkba'ntl Jesús tuya yol min e tx'olbaxixxin ti tten cye nejenel cye xjal. E xi' tkba'nxin: ");
INSERT INTO mamNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Jpjel tuj tcawbil Dios tisenj e baj jun maj tej tbincha junxin rey jun nim waabj tu'n tiy'sanxin jmejoblenel tej tmaje tcwalxin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","E xi' tsma'nxin ke tsanjelxin te txcol cyej xjal otk txi' tkba'nxin cye tu'n cyul tuj mejoblenel. Pero cycy'i tu'n cyul. ");
INSERT INTO mamNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ju' tzunj, e xa' tsma'nxin cabtl tsanjelxin, bix e xi' tkba'nxin cyexin: “Cykbanxa cyej xjal e ntxoca: ‘Lu ma bint jun nin waabj wu'na te cyey. Ma chi cub wacẍ wu'na cyuyax juntl alimaj tbanelxix. Cykilca ma bint tten. Cytzaj tzuna tuj mejoblenel,’ tz̈i cybela,” tz̈i cawel cye tsanjelxin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero min e xi' cybi'n xjal. Nuk o'cx e xi' cyii'n cychunk'lal tisex tten. At jun e xi' ak'anal tuj tawal. At juntl e xi' ak'anal tuj tq'ueybil. ");
INSERT INTO mamNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bix ke niy'tl xjal, e tzaj cytzyu'n ejee' sanjel, bix oc ten yasel cyi'j, bix e cub cybyo'n ejee'. ");
INSERT INTO mamNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tej tbinte cawel ti otk baj, e tzaj nimxsen tk'oj, bix e xi' tsma'nxin ke tsoldadoxin tu'n tcub cybyo'n kej byol xjal bix tu'n tcub cypaten cytanem. ");
INSERT INTO mamNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bix e xi' tkba'nxin cye tsanjelxin: “Binne tten nin waabj te mejoblenel. Pero kej xjal e ntxoca, yaa'n ba'nke. ");
INSERT INTO mamNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ju' tzunj, cyucxa cyey tuj cojbil tu'n tcnet xjal nchi bet cyuj be cyu'na, bix cykbanxa cye tu'n cyul tuj mejoblenel,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bix e xi' ke tsanjelxin cyuj be ti'jxe tnom, bix e tzaj cytxco'nxin cykilca xjal e cnet cyu'nxin, kej xjal ba'n cyuyax kej xjal yaa'n ba'n tuj cywitz xjal, bix e noj jaa' te mejoblenel cyu'n xjal otk chi tzaj txco'n. ");
INSERT INTO mamNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pero tej tocx cawel tuj jaa' cyey'lte cye xjal otk chi chmet, e tilxin junxin xjal yaa'n t-xbalen toc jnajben te mejoblenel. ");
INSERT INTO mamNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bix e xi' tkba'nxin te: “Jay wuyena, ¿ti ma tz'octzey bix yaa'n toc t-xbalena te mejoblenel?” tz̈i cawel. Pero jatzente xjal, mintii' aj ttz'ak'be'n. ");
INSERT INTO mamNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bix e xi' tkba'n cawel cye tsanjelxin: “Cyẍpo'nc ke tk'ab cyuyax tken, bix cyxoomex tuj klolj, jatztzen cok'ela bix ckitx'itx'il t-xee' twitz te,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tzin nkba'na cyey, cykilca xjal o tzaj txco'n tu'n Dios tu'n cyocx tuj tcawbil, pero yaa'n te cykilca k'o'n tu'n cyocx—tz̈i Jesús cye nejenel cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yajc'atltzen, bix e chmet ke aj fariseo, bix e yolen cyxolx ti tten tu'n tcub tz'ak Jesús tuj jun tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bix e xi' cysma'nxin cab cyxnak'atz yaa'n ba'n tuj cywitz tu'n cychjet chojentj tej rey Cesar, cyuyax cab xjal tej cloj Herodes ba'n tuj cywitz tu'n cychjet chojentj te Cesar. Bix e xi' cykanen kej sanjel lu te Jesús: —Taat Xnak'tzal, ktzki'na jax tey tyol. Mintii' cytz̈i ti'ja te kbalte cye cykilca xjal ti taj Dios. Min tz'aj tk'on tey tiib tuya juntl xjal. Min tz'oc tcye'yen tey tii'n ke xjal oj n-ak'a ninc'ul xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ju' tzunj, kbantz keya, ¿tajpa Dios tu'n t-xi' kk'o'n te cawel te Roma jchojentj tzin tkanen ke, bix ka min?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero el tniy'xin ti'j ka' iy' tuj cyc'u'j, bix aj ttzak'be'nxin: —Ke cyey xjal ca'ba twi' cyanema, ¿tikentzen ncwa' cyk'o'na c'o'bil tuj nbe'ya tuya cyyola? ");
INSERT INTO mamNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Cyk'ontza jpwak chojentja weya—tz̈ixin. Bix e xi' cyk'o'nxin jun pwak texin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bix e xi' tkanenxin cyexin: —¿Ale jwitzbaj bix ale jbiybaj tcub twitzj pwaka?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aj cytzak'be'nxin: —Te cawel te Roma—tz̈ikexin. Bix e xi' tkba'nxin cyexin: —Kane ju'wa, cyk'onxne te cawel te Roma alcyej te, bix cyk'onx te Dios alcyej te Dios—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tej cybintexin jlu, e jaw klee'kexin, bix e cyaj cycye'yenxin, bix exkexin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tujx k'ij lu e pon tuya Jesús juntl cloj xjal, saduceo tbi cycloj. E cykbaxin ka oj tcyim jun xjal, mintii' tu'n tjatz itz'j. Bix e xi' cykanenxin texin: ");
INSERT INTO mamNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Taat Xnak'tzal, e cyaj ttz'i'ben Moisés cyjulu: “Ka ma cyim jun xinak, bix ka min-al tcwal, il ti'j tu'n tmaje jun ttzicy ma titz'en tuya t-xu'l, tu'ntzen titz'j jun tiy'jil, tu'ntzen mi'n naj tiy'jil,” tz̈i tley Moisés. ");
INSERT INTO mamNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Attzen jun maj at wuuk xjal cyitz'en cyiib e ten kxola. E maje cytzicy tuya jun xuuj, pero e cyimxin. Pero min-al tcwalxin e cyaj. Ju' tzunj, e maje tneel titz'enxin tuya t-xu'lxin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pero jax ju'x e cyimxin, bix min-al tcwalxin e cyaj. Ju'x e baj te toxen. Cykilcaj wuuk e maje tuya junx cyxu'lxin, bix cykilcakexin e cyimkexin, bix min-alx jun cyexin itz'j tcwal tuya xuuj. ");
INSERT INTO mamNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Manc'biltzen, bix e cyim xuuj. ");
INSERT INTO mamNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ojtzen cyjatz itz'j ke cyimne juntl maj tuj cyamecy, ¿altzen cyxolj wuuk xinak c'oquel te tchmil ja xuuj? Tzinen ta' mintii'tl kchunk'lal oj kcyim, cuma ka at, iletle ti'j tu'n cyoc cykilcaj wuuk xinak te tchmilxuj, bix yaa'n tumel jlu—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pero aj ttzak'be'n Jesús cyexin: —Junxse maj tzpetpajninkey. Min cytzki'na ti toc tu'n tyol Dios, bix min cytzki'na at nim tipemal Dios tu'n tjatz titz'jsa'ntl t-xumlal jun xjal cyimne. ");
INSERT INTO mamNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Oj cyjatz itz'j cyimne juntl maj, mlay chi maje xjal juntl maj, sino chi oquel tisen ke ángel tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tuj cywitza, oj cycyim xjal, cyimneke te junx maj. ¿Pero bajxpa tz'oca cyc'u'ja ti'j ti toc tu'n Dios? E xi' tkba'n cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Inayena Tdios Abraham bix Tdios Isaac bix Tdios Jacob,” tz̈i Dios. Kej yol lu tzin cyyeec'an i'tz kej xjal o chi cyim, cuma yaa'n Cydios cyimne texin, sino Cydios i'tz texin—tz̈i Jesús cye saduceo. ");
INSERT INTO mamNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tej cybinte tnimal xjal jlu, e jaw klee'xsen ti' t-xnak'tzbilxin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pero tej cybinte fariseo otk caman Jesús cyibaj saduceo, e baj cychmon cyiib te yolel cyxolx ti tten tu'n tel cyii'n tipemal Jesús tuj cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","At junxin tx'olbal ley cyxolxin e pon tuya Jesús, bix tu'n tcub tz'akxin tuj tyolxin, e xi' tkanen tx'olbal ley texin: ");
INSERT INTO mamNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Taat Xnak'tzal, ¿altzen cyej mandamyent tuj tcawbil Dios mas il ti'j?—tz̈i tx'olbal ley texin. ");
INSERT INTO mamNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Bix aj ttzak'be'nxin: —C'oquelxix tak' Cyaawey Dios cyey tu'n cykil cyc'u'ja bix tu'n cykil cyanema bix tu'n cykil cynaabla. ");
INSERT INTO mamNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jatzen mandamyent lu ja mas nintzaj. ");
INSERT INTO mamNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bix tcab tmandamyent Dios tisen tneel. Tzin tkba'n: “C'oquelxix tak' jun xjal cyey tisenx n-oc cyak' cyiiba cyey,” tz̈i ley te Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tu'nj tzin cynimana kej ca'ba mandamyent lu, tzin cynimana cykilcatl mandamyent tuj tley Moisés bix tuj tyol Dios tz'i'bet cyu'n tyolel Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jooc'tzen cychmonx cyiib fariseo, e xi' tkanen Jesús cyexin: ");
INSERT INTO mamNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Ti toc cyu'na ti'j jxjal Scy'o'n tu'n Dios? ¿Ale cwalbaj tuj cywitza? Bix aj cytzak'be'nxin: —Te David. ");
INSERT INTO mamNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","E xi' tkba'nxin cyexin: —Ka nuk tcwal David Jscy'o'n tu'n Dios, ¿titzen tten jax David e kbante tu'n tipemal Espíritu Santo ka Jscy'o'n tu'n Dios Taawxin? E xi' tkba'n David cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“E tkba Dios te Waaweya: ‘Kequey tuj nmank'aba te tneel xjal. Tcyaja tzalu hasta ojxe cyocx k'ojlel ti'ja tjak' tkena wu'na,’ tz̈i Dios te Waaweya,” tz̈i David. ");
INSERT INTO mamNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Katzen jax David oc k'onte Scy'o'n tu'n Dios te Taaw at-xxe k'ij, ¿titzen tten ka tcwalxin jxjal Scy'o'n tu'n Dios?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Min-al jun cye e cnet yol tu'n tu'n t-xi' ttzak'be'n texin. Bix ya min-al juntl e tnimsa tiib tu'n tbaj t-xkelentl texin. ");
INSERT INTO mamNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Bix e xi' tkba'n Jesús cye tnimal xjal bix cye t-xnak'atzxin: ");
INSERT INTO mamNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Ke tx'olbal ley bix ke fariseo, cye cyaak'en tu'n cyk'onte xnak'tzbil ti'j tley Moisés. ");
INSERT INTO mamNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ju' tzunj, cykilcaj ntzaj cykba'n tu'n tbint cyu'na, cynimanx bix cybinchanx. Pero mi'n cybinchay tisenj cye tzin cybincha'n, cuma min nbint cyu'n tisenj tzin cykba'n. ");
INSERT INTO mamNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nimxsen ley cyiw nbint cyu'n tu'n tjaw cyiken xjal, pero mintii' nbint cyu'n tu'n t-xi' cyonen ke xjal tu'n tbint ley cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Cykilcaj nbint cyu'nxin, nuk o'cx tu'n toc cycye'yen xjal. Ncub cytz'i'benxin tyol Dios twitz jun piẍ tz'u'n bix n-oc cyẍpo'nxin ti' twi' cywitz bix ti' cyk'ab, tu'ntzen toc cycye'yen xjal cynimbil ti' ley. Bix n-oc cyk'o'nxin punc ttxa'n cyxbalenxin tu'n tchic'ajax ka jiquenkexin tuj ley. ");
INSERT INTO mamNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bix cyajxin tu'n cycub kexin tuj tneel k'ukbil tuj nin waabj. Oj cyponxin tuj camon jaa', nuk jaj k'ukbil mas jawnex nche'xxin jyolte. ");
INSERT INTO mamNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ju'x oj nche'xxin tuj plaza, cyajxin oj cyoc k'olben ke xjal cyexin tuya nim nimbil, bix tu'n toc cyk'o'n xjal cybixin Xnak'tzal. ");
INSERT INTO mamNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero cyey, mi'n tz'oc cyk'o'na cyiiba tu'n toc cyk'o'n xjal cybiy Xnak'tzal, cuma junx Xnak'tzal cyey at, jaj Scy'o'n tu'n Dios, bix cykilcakey cyitz'en cyiiba tjak' tcawbilxin. ");
INSERT INTO mamNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bix mi'n tz'oc cyk'o'na tbi jun xjal te cymana tzalu twitz tx'otx', cuma junx Cymana at tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bix mi'n tz'oc cyk'o'na cyiiba tu'n toc cyk'o'n xjal cybiy tneel te cye, cuma junx nejenel cyey at, jaj Cristo. ");
INSERT INTO mamNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kej xjal n-oc cyk'on cyiib ti'j tu'n cyajben cye niy'tl, ejee'tzen mas jawnex cyxola. ");
INSERT INTO mamNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Alj xjal njaw tniman tiib, c'oquel te ch'in. Bix alj xjal n-oc tk'on tiib te ch'in, ck'ojel te tu'n toc te nim. ");
INSERT INTO mamNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yaltzen cyey tx'olbal ley bix aj fariseo, ¡ay xsunkey! Xmeletz'key. Tzin cylomo'na tlemel jaa' cywitz xjal cyaj tu'n cyocx tuj tcawbil Dios. Cycy'iy tu'n cyocxa, pero amale cyajat niy'tl xjal tu'n cyocx, pero n-oc cyipena ti'j tu'n mi'n chi ocx. ");
INSERT INTO mamNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Ay xsunkey tx'olbal ley bix fariseo! Xmeletz'key, cuma nchi kanena nim chojbil jaa' cye viuda, tu'ntzen ka min xchjet cyu'n viuda, n-eltzen cyii'ntla cyjaxuj, tzinxsen chi na'na Dios nim tyem cywitz xjal nuk tu'n tcub naj cybinchbena cywitz xjal. Ju' tzunj, mas cycastiwiya cwel cyibaja cywitzj cwel cyibaj niy'tl xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Ay xsunkey tx'olbal ley bix fariseo! Xmeletz'key, cuma nbaj cybetena mar bix twitz tx'otx' cyxol jun wikxitl xjal tu'n tocx jun xjal tuj cyxnak'tzbila, bix oj tocx xjal tuj cyxnak'tzbila, mas aj il n-oca cywitza, bix mas nxi' tuj il cyu'na tu'n t-xi' tuj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Ay xsunkey k'ol tumel cye xjal pero tisen mos̈key! Tzin cykba'na ka yaa'n nimxix tajben nin tja Dios te jurament tu'n tcywix tyol jun xjal. Pero ka ma tzaj k'o'n tipemal tyol jun xjal tu'n oro tuj tja Dios te jurament, iltzen ti'j tu'n tjapan baj ti' tyol, tz̈ikey. ");
INSERT INTO mamNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mintii' cynaabla, bix mos̈key! ¿Alcye mas xjan? ¿Japa oro, bix ka nintzaj tja Dios jaa' ta' Dios? Mas il ti'j Dios, bix xjan oro nuk o'cx cuma tocx tuj tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jax ju'x tzin cykba'na ka yaa'n nimxix tajben altar te yol te jurament tu'n tcywix tyol jun xjal. Mas tipemal oybil tibaj altar tu'n tcywix tyol, bix ju' tzunj, ka ma tzaj k'o'n tipemal tyol jun xjal tu'nj oybil te jurament, iltzen ti'j tu'n tjapan baj ti' tyol, tz̈ikey. ");
INSERT INTO mamNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Mos̈key! ¿Alcye mas il ti'j? ¿Japa altar te Dios, bix ka oybil tibaj altar oyet te Dios? Mas il ti'j Dios, bix xjan altar nuk o'cx cuma tocx tuj tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ju' tzunj, yaa'n il ti'j ka ma cywix tyol jun xjal tu'nj altar te Dios te jurament bix ka tu'nj oybil, cuma tu'n Dios te altar tzin tk'o'n tipemal tyol. ");
INSERT INTO mamNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Bix ka ma cywix tyol jun xjal tu'n tja Dios te jurament, tu'n Dios tuj tja Dios tzin tk'o'n tipemal tyol. ");
INSERT INTO mamNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Bix ka ma cywix tyol jun xjal tu'n yol ti'j cya'j te jurament, tu'n Dios ncub ke tuj tk'ukbil tzin tk'o'n tipemal tyol. ");
INSERT INTO mamNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ay xsunkey tx'olbal ley bix fariseo! Xmeletz'key, cuma nchi k'ona tlajan pa' te alwent bix anís bix comino, pero min tz'oc cyk'on cyiiba tu'n tbint ja mas il ti'j tz'i'ben tuj ley cyu'na. Min tz'oc cyk'on cyiiba te onlte cye xjal bix tu'n toc cyk'ak'en cyc'u'ja cyi'j bix tu'n cybeta ba'n tuya Dios. Tumel tu'n t-xi' cyk'o'na tlajan pa' te Dios, pero yaa'n tumel ma cyaj cycye'yena jniy'tl tz'i'bet tuj ley. ");
INSERT INTO mamNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Amale mint tz'el cyni'ya ti'j ti jilel mas il ti'j tu'n tbint, pero tzin cykba'na cye xjal alcye tu'n tbint cyu'n. Tisen mos̈ k'il xjalkey. Ejee'y tisen jun xjal nxi' twaa'n, bix ka ma cnet jun us tuj twa, n-eltzen tii'n. Pero ka at jun tz̈ej tuj twa, min tz'el tniy' ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Ay xsunkey tx'olbal ley bix fariseo! Xmeletz'key, cuma ejee'y tisen jun xjal n-oc tk'o'n ti'j tu'n tel ttxjo'n ti'jxe jun vaso bix ka jun lak. Pero yajtzen tuj tc'u'j lak, ncyaj tz'il. Jax ju'x cyey, nim nbint cyu'na cywitz xjal tu'n tchic'ajax ka sakkey. Pero tuj cyanema, nuk alak' xjalkey, bix nuk ka' cyaja tu'n tbint. ");
INSERT INTO mamNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ejee'y fariseo mos̈, il ti'j tu'n ttxjet cyanema, tu'ntzen tsakxix te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Ay xsunkey tx'olbal ley bix fariseo! Xmeletz'key. Tisen cyjayel anemkey. Tocse txun cyi'j panteón, bix cyeca cyi'jxe. Pero tuj cyc'u'j, nuk nojne tu'n cybakel anem, bix nuk k'eyne at cyuj. ");
INSERT INTO mamNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jax ju'x cyey, tzin cyyeec'an cyiiba cywitz xjal tisenc'a jiquenkey. Pero tuj cyanema, nojnekey tuya xmeletz'bil bix jyaa'n ba'n. ");
INSERT INTO mamNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Ay xsunkey tx'olbal ley bix fariseo! Xmeletz'key, cuma njaw cybincha'na cypanteón tyolel Dios te ootxa, bix nbaj cybincha'na cypanteón tu'n tcyaj mejor cycye'nc. ");
INSERT INTO mamNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tzin cykba'na: “Nuket eto' tuj tyem tej cyten kiy'jil, mintle e tzaj konen cye kiy'jil tu'n tcub cybyo'n ke tyolel Dios,” tz̈ikey. ");
INSERT INTO mamNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero oj nxi' cykba'na ka cychmana kej xjal e byonte ke tyolel Dios, tzin cykba'na ka junx cynaabla cyuyaj cyiy'jila byol tyolel Dioske. ");
INSERT INTO mamNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","At-x ch'intl tu'n tpon baj twi' j-ak'untl e tzyet cyu'n cyiy'jila te ootxa. Ju' tzunj, japanx baj twi' cyu'na jmin o japan baj cyu'n cyiy'jila. ");
INSERT INTO mamNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Lbajkey! Mlay chi co'pja tu'n mi'n che'xa tuj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tu'n tpon baj twi'j ak'untl e tzyet cyu'n cyiy'jila, jey', cxe'l nsma'na mas tyolel Dios cyuyey, cyuyax kej at cynaabl, cyuyax ke tz'ibel tyol Dios. Cyxoltzen kej lu at juun cwel cybyo'na twitz cruz. At juuntl cxe'l cyk'o'na tz'u'n cyi'j tuj camon cyjay, bix at juuntl pjel yaset cyu'na tuj cykilca tnom. ");
INSERT INTO mamNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bix oj tbint cyu'na ju'wa, cwel cychjo'na cykilca cycublen xjal jiquen, jatxe tcublen Abel, hasta tejxe tcub Zacarías, tchman Berequías, jtyolel Dios e cub cybyo'na tuj tja Dios ti'jxe altar twitz tneel xjan cwart. ");
INSERT INTO mamNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jaxxix cxe'l nkba'na cyey, ejee'y judío te ja'lewe chi iklte nim castiwa tu'n tlaj kej il lu—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Bix e xi' tkba'ntl Jesús: —Key aj Jerusalén, aj Jerusalén, ¿tikentzen nchi cub cybyo'na ke tyolel Dios? ¿Bix tiken nchi cub cybyo'na tu'n xak kej xjal nxi' tsma'n Dios cyuyey? Nim maj o wajbe'ya tu'n nclonteya ejee'y, tisen nchi ocx clet tal jun ttxu ey' tjak' t-xiicy', pero cycy'iy inayena. ");
INSERT INTO mamNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jey', cyjel tcye'yen Dios cytanema, bix min-al xjal cyjel tuj. ");
INSERT INTO mamNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cxe'l nkba'na cyey, oj ncyima, mi'n tz'oc cycye'yena nwitza juntl maj hasta ojxe tpon jk'ij oj t-xi' cykba'na: “Chjonte te Dios ti'j ja xjal lu tzul sma'n tu'n Dios te cawel,” tz̈i cybela—e xi' tkba'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tej tbaj yolen Jesús, etzxin tuj tja Dios, bix e xi'xin. Bix e xi' cych'iquen t-xnak'atzxin tja Dios texin, tii'n tcye'nc. ");
INSERT INTO mamNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bix e xi' tkba'nxin cyexin: —Cycye'yenx cykilcaj lu, cuma jaxxix cxe'l nkba'na cyey, mi nuket jun xak bix cyjel tibaj juntl. Cykilca pjel xitj—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yajc'atltzen, bix e cub kexin twi'j witz Olivos tbi. Cyjunalxin cyuya t-xnak'atzxin. Bix e pon lk'e ke t-xnak'atzxin ti'jxin, bix e xi' cykanenxin: —Taat, kbantz keya, ¿jtojtzen pjel cykilca kej lu ma tkbay? ¿Bix titzen jilel techel tzul oj ch'itk tul meltz'aja bix oj ch'itk tpon manc'bil k'ij?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Bix aj ttzak'be'nxin: —Cyc'ojlam cyiiba cywitz kej xjal chi ul tzpetsal cyey. ");
INSERT INTO mamNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Cyuj jk'ij chi ul, tzul nim xjal te kbalte ka ejee' Scy'o'n tu'n Dios te clol xjal, bix cwel cysbu'n nim xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Cxe'l cybi'na nbajtl k'oj tuj ttanema bix jak'ch tumel. Pero mi'n chi jaw sey'paja, cuma il ti'j at k'oj te mitkna'x wula. Pero kej k'oj lu yaa'nja te yec'bil ch'ixc'a tpon manc'bil k'ij. ");
INSERT INTO mamNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cyuj jk'ij chi ul, chi jawel nmak tnom te k'ojlel cyuya juntl nmak tnom, bix ju' pjel tuj cykilca twitz tx'otx'. Bix tzul nim weyaj tuj nim lugar twitz tx'otx'. Bix nuk jak'ch q'uiyela xcyaklajnab. ");
INSERT INTO mamNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero kej tchiyonel lu nuk ch'in teja cywitzj q'uixc'aj nim tzul mas yaj oj tul manc'bil k'ij. ");
INSERT INTO mamNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Cyuj k'ij chi ul, chi xe'l k'o'na tuj cyk'ab cawel, bix chi yasjela cyu'n, bix chi cwel byo'na cyu'n. Bix chi elel iiq'uena tuj cykilca tnom tu'nj lepcheckey wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tu'n tlaj q'uixc'aj lu, nim xjal cyjel cyk'o'n cyocslabl wi'ja, bix cxe'l cyq'ueyen ke ocslal tuj cyk'ab aj k'oj wi'ja, bix q'uelel cyiiq'uen cyiib. ");
INSERT INTO mamNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Chi ul nim xjal tzin cykba'n ka tyolel Dioske, pero nuk tenx cyu'n, bix nim xjal chi tzpetel cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tz̈'iynen tjaw tz̈'iy il twitz tx'otx', bix ju' tzunj, nim xjal mi'n tz'octl cyak' ke cyuya cye. ");
INSERT INTO mamNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero alcyej xjal min xcyaj cye'yente weya hasta ojxe tcyim, ccleteltzen tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jba'n tpocbal tcawbil Dios cxe'l pocbet tuj cykilca twitz tx'otx', tu'ntzen cybinte cykilca wik xjal tyol Dios. Bix oj tbint lu, tzultzen manc'bil k'ij. ");
INSERT INTO mamNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Cykilcatzen jlu il ti'j pjel cyuj k'ij chi ul. Pero mas yaj tzul manc'bil k'ij. Ju' tzunj, ilxsen ti'j q'uelel cyniy' kej xjal n-oc cybi'n cyyola ti'j ti pjel oj ch'itk tul manc'bil k'ij. Jatxe ootxa, e tkba jtyolel Dios Daniel tzul jun k'ij oj tocx jun xjal ka'xsen te junx maj tuj nin tja Dios tu'n ttz'ilex bix tu'n ttzpet bix cxitjel tja Dios tu'n. Oj toc cycye'yena otk tz'ocx ja xjal lu tuj xjan cwart tja Dios, tz'ocxix cyc'u'ja ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tu'n tclet cychunk'lal, chi elel ok kej xjal ete' tuj Judea tuj c'ul cyxol witz. ");
INSERT INTO mamNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Alcyekej xjal ete'wex tuj tcab cxo'la cyja, mi'n chi ocxtl k'ilbetz te tik'ch cye tuj cyja, sino txucl chi elex ok tuj c'ul tu'n cyajkelbil. ");
INSERT INTO mamNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bix alj nak'anan tuj tcojbil, mi'n tz'ajtz meltz'aj tja, mitetpe te k'ilbex ke ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pero lastim kej xuuj preñada, bix ma nch'u'n cyal, oj tul ja ila, cuma mlay bint tu'n cyel ok. ");
INSERT INTO mamNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Cykanenx te Dios nuket mi'n baj ju'wa tuj tyem te tchewel, bix ka tuj jun k'ij te ajlabl, cuma cyiw tu'n cyel ok xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bajxse pja' jun maj ju'wa jatxe tcublen itz'j twitz tx'otx' tu'n Dios, bix mi'n baj juntl maj ju'wa oj tbaj ja lu. ");
INSERT INTO mamNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nuket mi'n cub tbajsa'n Dios twi' kej k'ij te q'uixc'aj lu, milen-al jun xjal jac'a cyaj itz'j. Pero cwel tbajsa'nxin twi' tu'n tk'ak'bil tc'u'jxin cyi'j texin ttanem scy'o'n tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Katzen at jun xjal ma tz'oc kbante cyey: “Cycye'yenctzen, lu tzunj xin Scy'o'n tu'n Dios lu,” ka tz̈i cyseja, mi'n tz'oc cybi'na, ");
INSERT INTO mamNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","cuma tzultzen nim xjal ẍtak' kbalte ka ejee' Scy'o'n tu'n Dios te cawel, bix tzul xjal ẍtak'el ka ejee' tyolel Dios. Ejee' tzunj xjal lu chi cwel binchante jawnex techel bix nuk tik'ch cbinel cyu'n tuya cyipemal, tu'ntzen cysbun ke xjal, bix ch'innch'e oj tcub sbu'n jun te Dios t-xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cykil tzunja lu ma txi' nkba'na cyey nejl. ");
INSERT INTO mamNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ju' tzunj, ka ma cykba xjal: “Lu Cristo at tuj lugar min-al xjal tuj,” ka cytz̈ike ju'wa, mi'n che'xa. Bix ka ma cykba xjal: “Lu Cristo tocx tuj cwart lu, cyjyo'nx,” ka cytz̈ike ju'wa, mi'n txi' cyocsla'na cyyol. ");
INSERT INTO mamNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Min chin ula tuj ewjel. Oj wula, cchic'ajaxel cywitz cykilca xjal, tisenj oj tcub koptz'aj jun tken k'ancyok te ocne bix niy'tl koptz'aj twitz cya'j tu'n tex te elne. ");
INSERT INTO mamNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jaa' tcwa' t-xumlal cyimne, jatztzen chi chmetel ke c'utz. Mintii' il ti'j tu'n toc cykanenjil jaa' tcwa'. ");
INSERT INTO mamNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ojtzen tbaj kej k'ij te cyiwxsen q'uixc'aj lu, c'oquel klolj twitz k'ij, bix ya mi'ntl txakentl xjaw. Chi c'u'l tz'ak che'w twitz cya'j, bix nuk clu'l cykilca twitz cya'j tisen jun xlok'laj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Oj tbaj lu, cchic'ajaxel jun yec'bil twitz cya'j te techel at tu'n tul jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal. Bix chi jawel ok' xjal tuj cykilca tnom twitz tx'otx', cuma cyla' xjal inayena oj ncu'tza tuj muj tuya nim wipemala bix nchin txakakan xsuna. ");
INSERT INTO mamNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tuj tzunj k'ij lu oj wula, ctzaaltzen nsma'na nsanjela tuj cya'j tu'nj tk'ajt tk'ajk'ajel jun jawnex xux, bix chi chmol ke n-ángela ke nxjala tuyaxe cykil jaa' pomnina baj twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Cycnomtzen. Ko nk'a'c'atzen jun techel ti tten oj wula. Ju' tten tisenj oj ntzaj xulan jun wi' higuera. Oj ntzaj alajin tk'ab higuera bixsen n-ak' eletz muxk'aj t-xul, ya telniy'tzen tuj cywitza ka ch'itk toc coresma. ");
INSERT INTO mamNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jaxse ju'x oj wula. Tisen tzunj t-xul higuera n-etz te ch'itk coresma, q'uelelc'atzen cyni'ya ti'j oj tbaj cykilca ma txi' nkba'na cyey twitz tx'otx', jatzen techel ka ch'itk wetza tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jaxxix cxe'l nkba'na cyey, kej xjal cyla' cykilca kej yec'bil ma txi' nkba'na cyey, min otk chi cyim oj tul tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Il ti'j ju' pjela. Te cya'j bix te twitz tx'otx' cwel xitj, pero ke weya nyol, mlay baj twi'. ");
INSERT INTO mamNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yaltzen tej tu'n alcye k'ij bix niy' hora oj wula, min-al ebilte. Mitetpe ejee' tsanjel Dios tuj cya'j itzkilte, bix mitetpe inayena. Nukxix ja te Nmana itzkilte niy' hora pjel jlu. ");
INSERT INTO mamNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yal cyej xjal at twitz tx'otx' oj ch'itk wul meltz'aja, min n-oc cyc'u'j ti'j alcyej at tu'n tbaj, tisenx kej xjal e ten tuj ttyem Noé min oc cyc'u'j ti'j alcyej at tu'n ttzaj cyibaj. ");
INSERT INTO mamNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tuj k'ij te mitkna'x tcub cycastiwa a' cyibaj xjal, tej tjaw tz̈'iy a', nuk ex cyk'ij nchi waa'n, nchi c'an, bix nchi maje, nuk cytenx. Pero nuk tisen tii' tej tpon jk'ij tej cyocx Noé tuj barc. ");
INSERT INTO mamNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Min e cyocsla aj il ka at tu'n tcub jun castiwa cyibaj hasta tejxe ttzaj jun nintzaj jbal cyibaj, bix e baj cykilca xjal. Jax ju'x nuk q'uelex cyk'ij xjal oj wul meltz'aja twitz tx'otx' juntl maj. Bix cwel castiwa cyibaj. ");
INSERT INTO mamNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tuj tzunj k'ij oj wul meltz'aja, at ca'ba xinak tuj cojbil. Jun cjawel k'i'n, pero juntl cyjel ten tu'n tcub tcastiwa. ");
INSERT INTO mamNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","At ca'ba xuuj chi tz̈ee'l junx ti'j jun cyaa'. Jun cjawel k'i'n, pero juntl cyjel ten. ");
INSERT INTO mamNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ju' tzunj, cuma min cytzki'na jtoj chin ula, inayena Cyaawa, cyc'ojlam cyiiba tu'ntzen binne cytena. ");
INSERT INTO mamNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Cybima ja yol lu. Nuket e bi'n tu'n taaw jun jaa' niy' hora te koniyan tzul alak', jac'ale cub ten c'ojlal, tu'ntzen mlay txi' tk'o'n amle'n te alak' tu'n tocx tuj tja. ");
INSERT INTO mamNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jax ju'x cyey, cykil hora cyitz'lem cyiiba, cuma chin ul meltz'aja tuj jun k'ij min nayona ti'j, inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ju' tzunj, ba'nxit chi e'la tuj cyaak'ena, tisen jun t-ak'anal patrón at tnaabl bix cuyan tu'n tuj taak'en k'o'n tu'n tpatrón tu'n t-xi' tk'o'n cywa kej te tja patrón oj tpon hora. ");
INSERT INTO mamNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","At nim xtalbil tibaj jun ak'anal ka cuyan tu'n tuj taak'en oj tul meltz'aj tpatrón. ");
INSERT INTO mamNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jaxxix cxe'l nkba'na cyey, cxe'l tk'o'n patrón tej ak'anal tu'n toc te ninc'ulte cykilca at te patrón. ");
INSERT INTO mamNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero ka ma txi' tkba'n ak'anal ka': “Yaj tzulwe npatróna,” ka tz̈i, ");
INSERT INTO mamNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bix ma tz'oc ten pjul cye mastl ak'anal bix ma tz'oc ten waa'l bix c'al cyuya ke c'al k'e'n, ");
INSERT INTO mamNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tzultzen meltz'aj tpatrón tuj jun k'ij min nayon ti'j bix tuj jun hora min ttzki'n. ");
INSERT INTO mamNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bix cwel k'o'n nim castiwa te ak'anal, bix cxe'l t-xoo'n tpatrón cyxol ke xmeletz' xjal, jatztzen chi jawela ok'ja, bix jaa' cjawela kitx'itx'in t-xee' twitz cye—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Bix e xi' tkba'ntl Jesús cye t-xnak'atz: —Yaa'n cykilca xjal binne cyten oj tul tcawbil Dios. Oj wul meltz'aja tuj cya'j, jpjel tisenj e baj tuj jun mejoblenel. Mitkna'x tul chmilbaj tuj mejoblenel. At laajtxin xuuj. E xi' cyii'ntxin cycantiltxin bix exketxin te clulte texin tuj be, tisenx tten. ");
INSERT INTO mamNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cyxoltzen laaj txin xuuj, jwe'txin at cynaabltxin ti'j, pero jwe'tltxin mintii' cynaabltxin ti'j, ");
INSERT INTO mamNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","cuma min e xi' cyii'ntxin aseyt tu'n tajben tuj cycantiltxin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jatzen kej txin at cynaabl, e xi' cyii'ntxin ch'intl aseyt tuj tcublel tuyax cycantiltxin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pero e yajt te chmilbaj tu'n tul, bix ul cywatltxin, bix iy' wutanketxin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pero te chil ak'bil, e jaw s̈i'n jun xjal: “¡Jey', lu chmilbaj tzula! ¡Qui cyetza te clulte texin!” tz̈i xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bix e jaw we' ke laaj txin, bix oc cytxko'ntxin cycantiltxin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bix e xi' cykba'n kej jwe' txin mintii' cynaabltxin ti'j cyej jwe'tltxin: “Cyk'ontz ch'in kaseyta, cuma ch'ix cycub yubtz'aj kcantila,” tz̈iketxin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero aj cytzak'be'n jtxin at cynaabltxin: “Min. Mas ba'n tu'n cyxi'y cyuya ke q'ueyel te lok'ol cyaseyta, tu'ntzen mi'n baj naj keya,” tz̈iketxin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bix exketxin lok'ol. Pero jooc'tzen nche'xtxin lok'ol aseyt, ul chmilbaj. Jatzen kej txin binne cyten e bet tuya chmilbaj, bix ocxketxin tuyaxin tuj mejoblenel. Bi'x lmet ttzi jaa'. ");
INSERT INTO mamNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Te yajxetzen, ul kej jwe'tltxin, bix e xi' cykba'ntxin: “¡Taat, taat! ¡Jkom jaa' kwitza!” tz̈iketxin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero aj ttzak'be'n chmilbaj: “Jaxxix cxe'l nkba'na cyey, min ntzki'na cywitza,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ju' tzunj, cyc'ojlam cyiiba tu'n binne cytena oj wula, cuma mintii' tumel cyuyey jtoj chin ula bix niy' hora—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Bix e xi' tkba'ntl Jesús: —Jpjel tuj tcawbil Dios tzul tuj cya'j tisenj e baj tej tex junxin xjal tuj jun tnom nakch. Nejl, e tzaj ttxco'nxin ke t-ak'analxin, tu'ntzen t-xi' tk'o'nxin pwak cyexin, tu'n cyak'ananxin ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Te jun t-ak'analxin e xi' tk'o'nxin jwe' talento. Te juntl t-ak'analxin e xi' tk'o'nxin ca'ba talento, bix te juntl, jun talento. Te teeylex juun e xi' tk'o'nxin pwak, la' ti' ba'n tbint cyu'n ti'j. Bix e tzyet be tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jt-ak'analxin e tiik' jwe' talento, texj k'ij ak' lok'ol bix q'ueyel tuya tpwak, bix e caman jwe'tl talento. ");
INSERT INTO mamNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jax ju'x jt-ak'analxin e tiik' ca'ba talento, texj k'ij ak' tu'n tak'anan ti' tpwak, bix e caman ca'batl talento. ");
INSERT INTO mamNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero jt-ak'analxin e tiik' jun talento, e xi'tzen bix e cu'x tlucu'nxin tx'otx', bix e cu'x tewenxin jpwak tpatrón tuj tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tbajlenxitltzen nim k'ij, ul meltz'aj cypatrón ak'anal, bix e xi' tkanenxin jte' pwak otk tcaman jaca juun t-ak'analxin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bix e pon jt-ak'analxin otk tiik' jwe' talento twitzxin, nxi' tii'n jwe'tl talento otk tcaman. Bix e xi' tkba'n: “Taat, jwe' talento e tzaj tk'o'na weya. Lu jwe'tl talento ma ncamana,” tz̈i. ");
INSERT INTO mamNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","E xi' tkba'n tpatrón te: “Ba'n ma bint tu'na, jay ak'anal ba'n. Ba'n toc ke nc'u'ja ti'ja. Ma tz'ak'anana ba'n ti'j ch'in e xi' nk'o'na tey. Ju' tzunj, cxe'l nk'o'na nim tey tu'n tcawena tibaj. Tzalaja wuyena,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jax ju'x jt-ak'analxin otk tiik' ca'ba talento e pon twitz tpatrón, bix e xi' tkba'n texin: “Taat, ca'ba talento e tzaj tk'o'na weya. Cye'yenc. Lu ca'batl talento ma ncamana,” tz̈i. ");
INSERT INTO mamNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","E xi' tkba'n tpatrón te: “Ba'n ma bint tu'na, jay ak'anal ba'n. Ba'n toc ke nc'u'ja ti'ja. Ma tz'ak'anana ba'n ti'j ch'in e xi' nk'o'na tey. Ju' tzunj, cxe'l nk'o'na nim tey tu'n tcawena tibaj. Tzalaja wuyena,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jax ju'x jt-ak'analxin otk tiik' jun talento, e pon twitz tpatrón, bix e xi' tkba'n texin: “Taat, ntzki'na jay jun xjal cyiw tnaabla. Nuk taja tu'n ttz̈'iy tpwaka. Ntz̈'iy tpwaka nuk tu'n cyak'mal juntl xjal, bix njtx'ona nuk tuj tawal juntl. ");
INSERT INTO mamNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","At ttz̈i wi'ja. Ju' tzunj, in xi'ya ewlte tpwaka tuj tx'otx'. Cye'nca. Lu tpwaka lu,” tz̈i ak'anal. ");
INSERT INTO mamNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aj ttzak'be'n tpatrón te: “Jay ak'anal yaa'n ba'n bix cy'aj, ka tuj twitza inayena jun xjal il ti'j tu'n ttz̈'iy npwaka, bix tu'n ncamana tu'n cyak'mal juntl wik xjal, ");
INSERT INTO mamNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿tikentzen min e xi' tk'o'na npwaka tuj banco, tu'ntzen ttz̈'iy tuj tk'ab juntl xjal? Nuket e bint tu'na ju'wa, otetle tz̈'iy tuya tal tej ẍin ul meltz'aja,” tz̈i patrón. ");
INSERT INTO mamNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bix e xi' tkba'nxin cyej xjal ete'c'a twitzxin: “Cyimel jpwak tej xjal lu, bix cyk'onx tej xjal e caman jwe' talento tibaj. ");
INSERT INTO mamNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jxjal e caman ti'j e k'oj te, mastl ck'ojel te, pero ja tzunj xjal mintii' e tcaman, ti'j e k'oj te, q'uelel k'i'ntl te. ");
INSERT INTO mamNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bix ja ak'anal lu min tz'ajben, q'uelex xoo'n tuj klolj te junx maj, jatztzen chi jawela ook' xjal, bix jatztzen chi jawela kitx'itx'in t-xee' twitz cye,” tz̈i patrón—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Bix e xi' tkba'ntl Jesús cye t-xnak'atz: —Ojtzen wul meltz'aja, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal, chin ula te cawel, bix cyuyax cykilca nsanjela tuj cya'j, bix chin cwel keya tuj nk'ukbila jawnex tu'n ncawena tibaj cykilca. ");
INSERT INTO mamNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bix chi oquel chmet nwitza cykilca xjal te cykilca tnom twitz tx'otx'. Bix q'uelex npa'na juun cyxol ke niy'tl, tisen jun cylel nchi el tpa'n ke carnel cyxol ke chiva. ");
INSERT INTO mamNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Cwel nk'o'na ke carnel tuj nmank'aba, bix ke chiva cwel nk'o'na tuj nneẍa. ");
INSERT INTO mamNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bix cxe'l nkba'na, inayena Cawel, cyej xjal ete' tuj nmank'aba: “Cytzaja, ejee'y ma cyiik'a t-xtalbil Nmana, bix cyocxa tuj cawbil o bint te cyey jatxe tej tbint twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ntzaj ntxco'na tu'n cyocxa, cuma tej ttzaj tak' weyaj wi'ja, e tzaj cyk'o'na nwaya, bix tej ttzaj tak' a' wi'ja, e tzaj cyk'o'na a' weya. Jun wikxitl xjal kena, pero e tzaj cyk'o'na nposadiya. ");
INSERT INTO mamNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tej mintii' nxbalena, e tzaj cyk'o'na nxbalena. Tej nyebta, ulkey cyey'l weya. Tej tocx cyxoo'n xjal inayena tuj tzee', ulkey wuyena,” tz̈i nbela. ");
INSERT INTO mamNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Bix ctzaal cykba'n kej xjal jiquen weya: “Taat, ¿jtoo kila at tak' weyaj ti'ja bix e xi' kk'o'na tway? ¿Bix jtoo kila at tak' a' ti'ja bix e xi' kk'o'na tc'ay? ");
INSERT INTO mamNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Bix jtootzen tzul aaja tisen jun wikxitl xjala bix e xi' kk'o'na tposadiya? ¿Bix jtootzen kila mintii' t-xbalena bix e xi' kk'o'na t-xbalena? ");
INSERT INTO mamNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Bix jtootzen kila ka yaaba bix ka tuj tzee' bix ul ko'ya cyey'lte tey?” tz̈i cybel. ");
INSERT INTO mamNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Bix cxe'l ntzak'be'na, inayena Cawel, cye: “Jaxxix cxe'l nkba'na cyey, tej cybinchantiya cykilcaj lu cyej ocslal yaa'n jawnex, tisenc'a weya e cybinchay jlu,” tz̈i nbela. ");
INSERT INTO mamNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jax ju'x cxe'l nkba'na cyej xjal tuj nneẍa: “Cypa'mel cyiiba wi'ja, key xjal cwel castiwa cyibaja. Chi xe'la tuj k'ak' te junx maj o bint te taaw il bix cye tbiman. ");
INSERT INTO mamNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Il ti'j tu'n cyxi'y tuj k'ak', cuma tej ttzaj tak' weyaj wi'ja, min e tzaj cyk'o'na nwaya, bix tej ttzaj tak' a' wi'ja, min e tzaj cyk'o'na a' weya. ");
INSERT INTO mamNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Jun wikxitl xjal kena, pero min e tzaj cyk'o'na nposadiya. Tej mintii' nxbalena, min e tzaj cyk'o'na nxbalena. Tej nyebta, min ulkey cyey'lte weya. Tej tocx cyxoo'n xjal inayena tuj tzee', min ulkey wuyena,” tz̈i nbela. ");
INSERT INTO mamNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Bix ctzaal cykba'n kej xjal lu weya: “Taat, ¿jtootzen kila at tak' weyaj ti'ja, bix jtootzen kila at tak' a' ti'ja, bix jtootzen tzula tisen jun wikxitl xjal, bix jtootzen kila mintii' t-xbalena, bix jtootzen kbi'ya ka yaaba bix ka tuj tzee', bix min e xi' kk'o'na onbil tey?” tz̈i cybel. ");
INSERT INTO mamNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Bix cxe'l ntzak'be'na cye: “Jaxxix cxe'l nkba'na cyey, tej min e cybinchay cykilcaj lu cyej ocslal yaa'n jawnex, tisenc'a min e cybinchay jlu te weya,” tz̈i nbela. ");
INSERT INTO mamNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bix kej xjal aj il lu chi xe'l tuj k'ak' te junx maj. Jatzen kej xjal jiquen, ck'ojel cye cychunk'lal te junx maj—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tejtzen tbaj tkba'n Jesús cykilca yol lu, e xi' tkba'nxin cye t-xnak'atzxin: ");
INSERT INTO mamNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Cytzki'na cabj tzul jnink'ij te Pascua bix ma pon tumel tu'n nk'oja tuj cyk'ab xjal tu'n nbyeta twitz cruz, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Bix e baj cychmon cyiib ke nejenel cye pala cyuyax nejenel cye xjal twitz pe'n tja Caifás, jpala mas jawnex cyxol pala. ");
INSERT INTO mamNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bix e yolenkexin cyxolxxin ti tten tu'n ttzyet Jesús tuj ewjel, tu'ntzen tbyet-xin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero e xi' cykba'nxin cyxolxxin: —Yajtzen yaa'n cyuj k'ij te Pascua, tu'ntzen mi'n jaw cyk'oj xjal ki'j—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yaltzen te Jesús, e ponxin tuj tnom te Betania, tuj tja jxin Simón otk tzaj k'ey tchu'l tu'n lepra. ");
INSERT INTO mamNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nchi waa'nxin ttxa'n mes tuj tja Simón tej tpon junxuj xuuj tuya jun ni' cyeca lmet nojne tuya c'oc'sbil cyi' xjal bix wi'ylxsen. Bix e jax tko'nxuj c'oc'sbil cyi' xjal tuj twi' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yaltzen cye t-xnak'atzxin, tej toc cycye'yenxin ti otk tse xuuj, e jaw yolenkexin: —¿Tikentzen ma pja' tyaa'n jxuuja jc'oc'sbila? ");
INSERT INTO mamNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yaa'n tumel. Ba'ntetpele xi' q'ueyet, matle jaw nim pwak ti'j, bixetle s-ajben te onl cye mebe—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pero el tniy' Jesús ti'j ti iy' tuj cyc'u'jxin, bix e xi' tkba'nxin cyexin: —¿Tikentzen ete'quey ya'l texuj? Jtexuj ma tz'oc tbincha'n wi'ja, ba'n teja. ");
INSERT INTO mamNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ka cyaja txi' cyyeec'ana cyanema cye mebe, attzen mebe cyxola cykil k'ij. Pero weya, nuk ch'intl chin temela cyxola. ");
INSERT INTO mamNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma tz'oc tko'nxuj c'oc'sbil wi'ja teja mitkna'x ncyima, tu'ntzen tbaj bint nxumlala tu'n nmaketa. ");
INSERT INTO mamNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jaxxix cxe'l nkba'na cyey, jaa'xja cpomela baj tumel jba'n tpocbal co'pbil cye xjal, cbyal tpocbal ti ma tbinche jxuj xuuja wi'ja. Ju'tzen cna'jalewe—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tbajlen yolenxitl tzunxin, bix el Judas Iscariote, jun t-xnak'atz Jesús t-xol cablaajxin. Bix e xi' Judas te yolel cyuya nejenel cye pala. ");
INSERT INTO mamNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Bix e xi' tkba'n Judas cye: —¿Jte' pwak ctzaal cyk'o'na weya ka ma txi' nk'o'na Jesús tuj cyk'aba?—tz̈i. Bixsen e bint cyyolxin tu'n toc cyk'o'nxin winak laaj pwak te plata te. ");
INSERT INTO mamNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bix ak' Judas jyolte ti tten tu'n t-xi' tk'o'n ja Jesús tuj cyk'ab nejenel cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tetzen tneel k'ij te nink'ij te Pascua, jnink'ij tej cywaa'n xjal pan mintii' levadura tuj, e pon lk'e t-xnak'atz Jesús ti'jxin, bix e xi' cykanenxin texin: —¿Jaa' tumel taja tu'n tbaj kbincha'na jwaabj te xjan k'ij?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Bix aj ttzak'be'nxin: —Cyucxa tuj tnom te Jerusalén, bix oj toc noj junxin xjal cywitza, cykbanx te: “Taat, tz̈i Xnak'tzal tey cyjulu: ‘Ch'ix tpon tumel tu'n ncyima. Q'uiy'setel Pascua wu'na cyuya nxnak'atza tuj tjay,’ tz̈i Jesús,” tz̈i cybela tej xin lu—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bix e cybincha t-xnak'atzxin tisen e tkbaxin, bix ak'kexin binchal cywaxin te Pascua. ");
INSERT INTO mamNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tetzen n-ak' cwelc'a klolj, e cub ke Jesús ti'j mes cyuyax kej cablaaj t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Maantktzen nchi waa'nxin, e xi' tkba'n Jesús: —Jaxxix cxe'l nkba'na cyey, at jun cyxola cxe'l tq'ueyen inayena tuj cyk'ab kej xjal cyaj tu'n ncuba—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Toctzen cybi'nxin tyol Jesús, e tzajtzen nim cybisxin. Bix juun n-ela cyexin ak' kanlecte te Jesús: —¿Inayenpatzen weya, Taat?—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Bix aj ttzak'be'nxin: —Alcye tzunj cyey cwelex mu'nte tpan junx wuyena tuj lak, ja tzunja cxe'l k'onte weya tuj cyk'ab byol xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jxin xjal Sma'n tu'n Dios tu'n tten cyuya xjal, amale tzint tkba'n tyol Dios tu'n tbyet-xin, pero ayxsen tixsen tna'x jcxe'l k'onte weya. Masetlpele ba'n minxit itz'j xjala—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Bix e xi' tkba'n Judas, jxjal otk ninc'un tu'n t-xi' tq'ueyen Jesús: —Xnak'tzal, ¿japatzen kena? Bix aj ttzak'be'n Jesús: —Pjel tisenj ma tkbay. ");
INSERT INTO mamNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Maantktzen nchi waa'nxin, tej tjaw ttzyu'n Jesús jun pan, bix e xi' tkanenxin xtalbil te Dios ti' pan. Bix ak'xin piẍlcate, bix e xi' tk'o'nxin cye t-xnak'atzxin, bix e xi' tkba'nxin: —Cytzyunxa bix cywaa'nx, cuma ja tzunja pana techlal nxumlala cwel yuchj bix cbyetel—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bix e jaw tii'nxin jun vaso nojne tuya vino, bix e xi' tk'o'nxin chjonte te Dios ti'j, bix e xi' tk'o'nxin cye t-xnak'atzxin, bix e xi' tkba'nxin: —Cyc'anx cykilcakey ja vino lu, ");
INSERT INTO mamNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","cuma techel ntz̈q'uela q'uelel c'ala. Cxe'l oyet ntz̈q'uela tu'ntzen tnajset cyil nim xjal. Tu'nj ntz̈q'uela q'uelel c'ala, ctemeltzen jun ac'aj ttrat Dios cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Cxe'l nkba'na cyey, mi nuket juntl maj cxe'l nc'a'na vino ti'j lux kena ini'tza texe jk'ij oj woca te cawel tuj tcawbil Nmana, maxetzen cxe'l nc'a'ntla, bix cyuyax xsuna—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cybajlen waa'n tzunkexin, bix ak'kexin bitzel. Cybajlentzen bitzenxin, bix e xi'kexin tc'u'j witz te Olivos. ");
INSERT INTO mamNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bix e xi' tkba'nxin cyexin: —Cykilca key cyjel cycye'yena inayena te koniyan ja'lewe, cuma tz̈i Dios jun maj tuj tyol cyjulu: “Cwel nbyo'na cylel, bix chi elel tz̈itj ke carnel,” tz̈i Dios jatxe ootxa. ");
INSERT INTO mamNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero ojtzen njatz itz'ja tuj cyamecy, chin xe'l neja cywitza tuj departamento te Galilea—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pero e xi' ttzak'be'n Pedro: —Amale cykilcatlet cyjel cycye'yen jay tu'nj ttz̈i cyi'j, pero weya, mlayx cyaj ncye'yena jay—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","E xi' tkba'n Jesús: —Jaxxix cxe'l nkba'na tey, te ja koniyan ja'lewe, te mitkna'x kskix, oj took' coo', tu'n ttz̈i ti'ja otktzen txi' tkba'na oxe maj min ttzki'na nwitza—tz̈ixin te Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","E xi' tkba'n Pedro texin: —Mi'n txi' nkba'na min ntzki'na twitza. Ka at il ti'j, chin cymela tu'n woc lpeya ti'ja. Mlay cyaj ncye'yena jay—tz̈i Pedro. Jax ju'x e xi' cykba'n cykilcatl t-xnak'atz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yajc'atltzen ch'intl tex koniyan, bix e cu'xkexin tuj jun lugar Getsemaní tbi. Bix e xi' tkba'nxin cye t-xnak'atzxin: —Chi kequetzen cyey tzalu, matzen chixwe ma chixa yolel tuya Dios—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bix e xi' tii'nxin Pedro cyuyax ca'ba tcwal Zebedeo, bix e tzaj nim tbisxin bix ak' cwel talelxin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Bix e xi' tkba'nxin cyexin: —May'xsen tz'oc jun bis ti' wanema. Mlayxsen npawe. Chi tenc'atzen cyey tzalu. Cyimeltzen ch'in cywatla—tz̈ixin, ");
INSERT INTO mamNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","bix el lk'exin ch'intl cyi'jxin. Bix e cub mutzk'ajxin twitz Dios, bix e xi' tcubsa'nxin twitzxin te Dios. E xi' tkanenxin: —Nmana, ka ba'n tuj twitza, chin tco'pa tzuna ti'j tu'n tiy'x jniy' jlu wu'na. Pero yaa'n tej weya waj bint cbinel, sino ja tej alcye tey taj bint, jatzen wej waja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tbajtzen yolenxin tuya Dios, bix e pon meltz'ajxin cyi' Pedro. Nchi wutanxin tej tponxin cyi'jxin. Bix e xi' tkba'nxin cye Pedro: —¿Nchi wutanpa tzuna? ¿Mitetpa jun hora ma cypay watl? ");
INSERT INTO mamNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cyimelxix ch'in cywatla, bix chi na'n Dios, tu'n mi'n chi cub tz'aka tuj jun il. Taj cyey cyanem tu'n tbint jba'n, pero mintii' tipen cyxumlala tu'n tbinchet alcye taj cyanema—tz̈ixin cye Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bix elxin juntl maj te yolel tuya Dios. Bix juntl maj e xi' tcubsa'nxin twitzxin te Dios: —Taat Nmana, ka yaa'n ba'n tuj twitza tu'n mi'n tziy'x jq'uixc'aj lu wu'na, bint-xit jtajbila—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tejtzen tpon meltz'ajxin, nchi wutan t-xnak'atzxin juntl maj cyoxelxin, cuma ntzajxe mtz'e cywitzxin tu'n nim watl. ");
INSERT INTO mamNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bix elxin cyi' t-xnak'atzxin juntl maj te yolel tuya Dios toxen maj. Ejee' xsunj tyolxin te tneel maj bix tcab maj, ejee' xsunja e xi' tkba'nxin te Dios te toxen maj. ");
INSERT INTO mamNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tbajlen yolen tzunxin te toxen maj tuya Dios, e pon meltz'ajxin cyuya t-xnak'atzxin, bix e xi' tkba'nxin cyexin: —¡Jey'! ¿Nchi wutanxpa tzuna? ¿Tzinxpatzen chi ajlana? Matzen pon tumel tu'n nxi' k'o'na tuj cyk'ab aj il. ");
INSERT INTO mamNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Chi we'wa. Lu jxin ma txi' k'onte weya tzula. Ko'ke clul texin—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tzinx yolen Jesús tej tpon Judas, jun t-xnak'atzxin t-xolj tcablaajxin, tuya nim xjal binne cyten tuya espada bix tuya tzee'. Chk'o'n tzunkexin cyu'n nejenel cye pala bix cyu'n nintzaj xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Otktzen txi' tkba'n Judas jun techel cye tzuyel ti tten oj ttzyet Jesús. Ju'tzen toc tu'n Judas cyjulu: “Al tzunj ma tz'el ntz'u'ban twitz, ja tzunja. Cytzyumetztzen,” tz̈i Judas. ");
INSERT INTO mamNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ju' tzunj e xi' lk'e Judas ti' Jesús, bix e xi' tkba'n texin: —Jey' Xnak'tzal—tz̈i tzunxin, bix el ttz'u'banxin twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Bix e xi' tkba'n Jesús te Judas: —Jay wuyena, binchanx jtsanlala—tz̈ixin. Bix e xi' cyk'abxin te tzyultzte Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pero cyxol cyej ete' tuya Jesús, at jun e jatz tii'n tspada bix e xi' tjubac tspada ti' twi' jun t-ak'anal jpala mas jawnex, bix el ttx'oman jun tẍquin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Bix e xi' tkba'n Jesús te: —K'onc'ax tspadiy tuj tjayel. Kej xjal nchi k'on cyiib tu'n cyk'ojl cyi' juntl, chi cymeltzen tuj k'oj. ");
INSERT INTO mamNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mimpa tz'el tni'ya ti'j ka jac'a txi' nkanena te Nmana tu'n ttzaj tsma'n mas te setenta mil tsanjel tuj cya'j tu'n cyco'pan weya? ");
INSERT INTO mamNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero nuket ma txi' nkanena tu'n mi'n chin cyima, ¿titzen tten tu'n tel jax jtyol Dios e tkba il ti'j tu'n ntzyeta?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bix e xi' tkba'n Jesús cyej nim xjal otk chi ul tzyulte: —¿Alak'pa kena, tu'ntzen at il ti'j tu'n cyula tuya cyspadiy bix cytzee'y te tzyul weya? Cykilca kej k'ij lu ma chin tena cyxola te xnak'tzal cyey tuj nin tja Dios, pero mintlpe in cytzuya. ");
INSERT INTO mamNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero cykil tzunja nbaja tetzen tu'n tjapan baj twi'j tyol Dios o cyaj tz'i'bet cyu'n tyolel Dios—tz̈i Jesús. Bix cykilca ke t-xnak'atzxin e cyaj cycye'yen jaxin, bix e baj pjel okkexin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bix e xi' cytzyu'n xjal ja Jesús, bix e xi' cyii'nxin jaxin twitz tneel pala Caifás, jatztzen otk txi' cychmon cyiib ke tx'olbal ley cyuyax nejenel cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nakchtzen e xa' lpete Pedro ti' Jesús, tejxe tpon Jesús tja tneel pala. Ocxtzen Pedro twitz pe'n, bix e cub kexin cyuya ke c'ojlal nin tja Dios, tu'ntzen tlontexin ti pjel. ");
INSERT INTO mamNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tunwentzen nchi jyona jxin nejenel cye pala cyuyax cawel cyxol xjal judío cab tstiwa ẍtak' ti' jun til Jesús tu'n tbyet-xin cyu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero min e cnet jun tilxin cyu'nxin, amale nimet xjal e pon cywitz cawel te ẍtak'el. Pero manc'biltzen, e pon ca'ba xjal cywitzxin, ");
INSERT INTO mamNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bix e xi' cykba'n: —E tkba ja xjal lu cyjulu: “Jac'a bint tu'n tcub xitj tja Dios wu'na, bix tu'n tjaw nbincha'na juntl maj tuj oxe k'ij,” tz̈i xjal lu—tz̈i ke ca'ba tstiwa. ");
INSERT INTO mamNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ju' tzunj, e jaw we' tneel pala, bix e xi' tkanen te Jesús: —¿Mimpatii' ctzaal ttzak'be'na cyi'j yola? ¿Ti toc cyu'na ti'j cyyol jxjal lu?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero min ak' Jesús. Bix e xi' tkba'n tneel pala te: —Cxe'l ncubsa'na nwitza twitz Dios i'tz, kbantz keya ka jay jxjal Scy'o'n tu'n Dios te cawel, ka jay Tcwal Dios—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","E xi' tkba'n Jesús texin: —Jax ma tkbay. Jax ju'x, cxe'l nkba'na cyey, cyla' tzuna inayena k'uklec tuj tmank'ab Dios nim tipemal, bix cyla' tzuna oj ntzaj twitz tx'otx' tuj muj twitz cya'j—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Toc tbi'n tneel pala kej yol lu, bix el ttzakenxin ti'jxin tu'n tk'ojxin, bix e xi' tkba'nxin: —Njuben yol ti' Dios ka junxxin tuya Dios. ¿Titzen kaj te mas tstiwa? ¡Jey', ejee' xsuna ma chi oc ebinte lu tzunxin njuben yol ti' Diosa! ");
INSERT INTO mamNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ti toc cyu'na?—tz̈ixin. Bix aj cytzak'be'nxin: —At til. Il ti'j tu'n tbyet—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bix ak'kexin tzublecte ti' twitz Jesús, bix oc cypju'nxin, bix at juuntl oc cytz'ajenxin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Bix e xi' cykba'nxin: —Jay Scy'o'n tu'n Dios, kbantz keya, ¿alj xjal kxola s-oc pjunte tey?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yaltzen te Pedro, tcub xsunxin pe'n. Bix e pon juntxin xuuj tk'opaj tneel pala, bix e xi' tkba'ntxin te Pedro: —Jax ju'x jaan tey tuya Jesús te Galilea—tz̈itxin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero tcy'i Pedro jtyoltxin ju'wa, bix e xi' tkba'nxin cywitz cykilca xjal: —Mintlpe n-el nni'ya ti'j ali'j nyoleney—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tej tetz Pedro ttzi penwen tu'n ttzyet be tu'nxin, at juntl tk'opaj tneel pala e til jaxin, bix e xi' tkba'ntxin cyej xjal ete' pe'n: —Ja xjal lu e ten tuya Jesús aj Nazaret—tz̈itxin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Juntl maj elx tii'n tiibxin. E xi' tkba'nxin: —Tzkinn Dios min ntzki'nwe twitz xjal lu—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yajc'atltzen ch'intl bix oc cyumla'n jxjal ete'c'a pe'n ja Pedro: —Jaxxix jaanxix tey cyxol kej xjal lepchec ti' Jesús, cuma ti'j tyola n-el kni'ya ti'ja junxitl xjal tey—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bix ak' Pedro k'ilbel tiib: —Tzkinn Dios yaa'n jaan kenwe tuya. Min ntzki'nwe twitzj xjal lu—tz̈i Pedro. Tzinx yolen Pedro tej took' coo', ");
INSERT INTO mamNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","bix ul tuj tc'u'jxin ti otk tkba Jesús: “Te mitkna'x took' coo', otktzen txi' tkba'na oxe maj min ttzki'na nwitza,” otk tkba Jesús te Pedro. Bix ex Pedro bix e jaw ok' xsunxin nim. ");
INSERT INTO mamNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tejtzen tcub spi'yen te klax, oc cychmon cyiib cykilca nejenel cye pala cyuyax nintzaj xjal, te ninc'ul ti tten tu'n tcyim Jesús cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bix e cub cyẍpo'n, bix e xi' cyii'n twitzj xin gobernador, Pilato tbi. ");
INSERT INTO mamNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yaltzen te Judas, jxjal e xi' q'ueyente ja Jesús tuj cyk'ab byol xjal, tej tlonte otk cub cyninc'u'n nintzaj xjal tu'n tcub cybyo'n ja Jesús, e tzaj tbisxin. Bix aj tk'o'nxin jwinak laaj pwak te plata cye nintzaj pala bix cye nintzaj xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","E xi' tkba'nxin cyexin: —Ma chin binchana jun jawnex il, cuma ma txi' nk'o'na tuj cyk'aba jun xjal mintii' til—tz̈i Judas. Pero aj cytzak'be'nxin texin: —Mintii'ke kaj ti'j. Ti'j tey toca—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ju' tzunj e cub t-xoo'n Judas pwak te plata tuj tja Dios, bix etzxin, bix e jawtyo'ben tiibxin ti' tk'ab jun tzee', bix e tzaj t-xoo'n tiibxin twitz tx'otx' tu'n tcyimxin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jatzen cye nejenel cye pala, e jaw cyii'nxin pwak te plata, bix e xi' cykba'nxin: —Yaa'n k'o'n tu'n ley tu'n tcu'x kk'o'n tuj tcublel oybil tu'n tajben tuj tja Dios, cuma ja pwak lu ma tz'ajben te chojbil twi' tcyimlen jun xjal—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bix ak'kexin yolel cyxolxxin ti' pwak, bix el cylok'o'nxin jun tx'otx' ti' pwak Xcab Tx'otx' tbi, tu'ntzen tajben tu'n cycu'x maket kej xjal yaa'n aj Jerusalén tuj. ");
INSERT INTO mamNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ju' tzunj, hasta ja'lewe o tz'oc cyk'o'n xjal tbi ja tx'otx' lu te Jcamposant Tlok'aj Tu'n Pwak Twi' Tz̈iy'. ");
INSERT INTO mamNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tej tel cylok'o'nxin ja tx'otx' lu, el jaxxix j-e tkba jtyolel Dios Jeremías jatxe ootxa. Tz̈i cyjulu: “Cxe'ltzen cyii'n winaklaaj pwak te plata, jatzen twi' jun ajnintz xjal tuj cywitz aj Israel, ");
INSERT INTO mamNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bix cxe'l cyk'o'n ja pwak lu tu'n cylok'onte jtx'otx' Xcab Tx'otx' tbi. Ju'tzen e tzaj tkba'n Dios weya,” tz̈i Jeremías. ");
INSERT INTO mamNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yaltzen te Jesús, tej wa'lecxxin twitz gobernador, e xi' tkanen gobernador texin: —¿Japa tey rey cye xjal judío? Bix aj ttzak'be'nxin: —Jay ma scy'onte ja yol rey cye judío, yaa'n inayena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bixsen nimxsen oc cyumla'n nejenel cye pala cyuyax nintzaj xjal jaxin twitz Pilato, pero mintii' ak'xin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Bix e xi' tkanen Pilato texin: —¿Mimpa tzin tbi'na tik'ch cyyol xjal ti'ja? ");
INSERT INTO mamNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero mi nuketpe jun yol aj ttzak'be'n Jesús, bi'xsen e jaw klee' gobernador. ");
INSERT INTO mamNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Attzen jun costumbre. Jaca jnabk'i tuj tzunj nink'ija te Pascua, tz'etz ttzakpi'n gobernador jun xjal aj Israel tuj tzee', la' alj cyaj xjal aj Israel tu'n tetz. ");
INSERT INTO mamNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Te tzunja jnabk'i lu, tocxse tuj tzee' junxin ka'xsen xjal, Barrabás tbi. ");
INSERT INTO mamNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ju' tzunj, tej tbaj cychmon cyiib nim xjal, e xi' tkanen Pilato cye: —¿Alcyej xjal cyaja tu'n tex ntzakpi'na cyey? ¿Cyajpey tu'n tex ntzakpi'na jxin Barrabás, bix ka ja Jesús, jxjal Scy'o'n tu'n Dios tbi?—tz̈i gobernador. ");
INSERT INTO mamNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ju'tzen toc tu'nxin cye xjal cuma at tumel tuyaxin ka nuk tu'n tchi'lel cyc'u'j ke nintzaj xjal otk pon cyii'nxin ja Jesús twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Cubtzen ke Pilato tuj k'ukbil tu'n tcawen, e tzaj sma'n jun xjal tu'n t-xu'lxin kbal texin: “Mi'n tz'oc tk'on tiiba ti'j ja xjal lu jiquenxix, cuma sulxin tuj nwitzi'ya te koniyan, bix nim siy' tuj nc'u'ja tu'n tlajxin,” tz̈i t-xu'lxin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero kej nejenel cye pala bix kej nintzaj xjal, e cub cyi'j xjal cyu'n tu'n t-xi' cykanen tu'n tetz Barrabás tuj tzee', bix tu'n t-xi' cykba'n tu'n tbyet Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pero e xi' tkanen gobernador juntl maj cye xjal: —¿Alcyej xjal cyaja tu'n tetz ntzakpi'na cyey? Bix aj cytzak'be'n xjal: —Ja te Barrabás tu'n tetz ttzakpi'na—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","E xi' tkba'n Pilato cyexin: —Jey', ¿tine cyaja tz'oc nbincha'na ti'j Jesús, ja xjal Scy'o'n Tu'n Dios tbi?—tz̈ixin. E cykba cykilca xjal: —¡K'onwexin twitz cruz tu'n tcyimxin!—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Bix e xi' tkba'n Pilato: —¿Tiken? ¿Tine jilel ka' ma cub tbinchexin?—tz̈ixin. Pero bix aj cytzak'be'n xjal juntl maj mas cyiw: —¡E tjaw twitz cruz!—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tejtzen tlonte Pilato mintii' tu'n tcub cyi'j xjal tu'nxin, bix nuk e jaw cys̈itz̈'bil xjal, e jatz tii'nxin ch'in a', bix el ttxjo'nxin tk'abxin cywitz xjal te techel mintii' tilxin ti'j, bix e xi' tkba'nxin cyexin: —Mintii' wila ka ma cyim jaj xjal jiquen lu. Te cyeya cyila ka ma cyim—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bix aj cytzak'be'n cykilca xjal: —¡Ejoo'ya at kila ka ma cyim, bix jax ju'x at cyil kcwala!—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Bix etz ttzakpi'n Pilato ja Barrabás cye xjal. Pero e xi' tchk'o'nxin ke tsoldadoxin te k'olx tz'u'n tocsen ch'ut twi' ti'j Jesús, bix tu'n tjaw cyk'o'nxin twitz cruz. ");
INSERT INTO mamNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bix e xi' cyii'n tsoldado gobernador tuj cuartel, bix e xi' cychk'o'nxin cykilca soldado tu'n toc cychmon cyiib ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bix el cyii'nxin t-xbalen Jesús, bix oc cyk'o'nxin jun t-xbalen cyak tisen t-xbalen jun rey, te tzeblte Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bix e cub cybincha'nxin jun tcorona nuk ch'i'xc'a, bix e cub cylomo'nxin tuj twi'xin. Bix oc cyk'o'nxin jun ptz'unt tuj tmank'abxin te techel bara nuk te cytzeblxin, bix e cubxe majekexin twitzxin nuk te cyxmucchablxin. Bix e xi' cykba'nxin: —¡Axse Cycawel xjal judío!—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bix ocx cytzubanxin tuj twitzxin, bix etz cyii'nxin ptz'unt tuj tk'abxin tu'n tcu'x cyjubenxin tuj twi'xin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tbajlen cyxmuccha'nxitl tzunxin Jesús, bix el cyii'nxin jt-xbalenxin otk tz'oc cyk'o'nxin, bixsen oc cyk'o'nxin jtexin t-xbalen tocx. Bix e xi' cyii'nxin jaxin tu'n tjawxin twitz cruz ttxa'nxe tnom Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tejtzen cyetzxin tuj tnom, oc noj junxin xjal Simón tbi, aj Cirene, cywitzxin. Bix e cub cymako'nxin, bix e jaw cyk'o'nxin cruz ti' tkul jxin xjala. ");
INSERT INTO mamNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tejtzen cyponxin tuj jun lugar Gólgota tbi, jatzen elpeninaj Tbakel Wi'ybaj, ");
INSERT INTO mamNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","e xi' cyk'o'nxin tc'a'xin vino smo'n tuya jun wik remeda c'axsen. Pero tej tniy'bentexin, tcy'ixin tu'n t-xi' tc'a'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bixse e jaw pjet Jesús tuya clavos twitz cruz cyu'n soldado. Bix e cub cypa'n soldado t-xbalen Jesús cyxolxxin. E cub cyk'o'nxin suerte ti'j tu'n al ccamal ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bix e cub kekexin te c'ojlalecte. ");
INSERT INTO mamNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bix e jaw cyk'o'nxin cab letra tibaj twi'xin tzin tkba'n tilxin. Tz̈i cyjulu: “Ja xjal lu Jesús, cawel cye xjal judío,” tz̈i letra. ");
INSERT INTO mamNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Te xsunj k'ij tjaw ca'baxin alak' junx tuya Jesús. Jun cyexin e jaw twitz jun cruz tuj tmank'ab Jesús, bix juntlxin e jaw twitz cruz tuj tneẍ Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yal tzunkej xjal exc'a ttxlaj cruz jaa' tjawa Jesús, n-ocxetzen cytze'n xjal jaxin, bix nxi'xe cyyucan xjal cywi', ");
INSERT INTO mamNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bix njawxetzen yolen: —Jatzen teja tcublel xitente nin tja Dios bix tu'n tjaw tbincha'na tuj oxe k'ij, co'pacatz tiiba. Katzen Tcwal Diosa, tcu'tztzen twitz cruz—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ju'tzen tten cyoc ten nejenel cye cawel bix ke tx'olbal ley bix ke nintzaj xjal xmucchalec te Jesús. E xi' cykba'nxin: ");
INSERT INTO mamNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—E tco'paxin nim xjal, pero yaltzen texin, mlay bint tco'pa tiibxin. Ka Cycawel aj Israelxin, e tcu'tz tzunxin twitz cruz ja'lewe, tu'ntzen kocslan ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Oc ke tc'u'jxin ti' Dios. Bix e tkbaxin ka Tcwal Diosxin. Ju' tzunj, il ti'j ccletelxin tu'n Dios ja'lewe. Pero la' ka taj Dios—tz̈i ke nintzaj xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hasta jaan kej xin alak' otk chi jaw pjet twitz cruz, e xoo'n yol te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tejtzen tpon chil k'ij, bix e cub jpet jun nintzaj klolj entera twitz tx'otx', bix e ten klolj oxe hora. ");
INSERT INTO mamNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tej tpon tajlal oxe te kale, bix e jaw s̈-in Jesús cyiw tuj tyol: —Elí Elí, ¿lama sabactani?—tz̈ixin, jatzenj elpenina jyola “¡Ndios! ¡Ndios! ¿Tiken ma chin cyja' tcye'yena?” ");
INSERT INTO mamNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Attzen cab xjal oc ebinte tyol Jesús, pero min el cyniy' xjal ti'j. Bix e jaw yolenkexin: —Cybinx. Luxin ntxcon jtyolel Dios Elías—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Toctzen tbi'n junxin xjal cyxolxin, bix e xi' ajkelenxin k'ilbetz jun esponja, bix e cu'x tmu'nxin ch'in brat vino tuj, tx'om ch'in, bix oc tẍpo'nxin twi' jun ptz'unt, bix e jax toyenxin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero e xi' cykba'n niy'tlkexin cyxol: —Kokcye'yectzen la'tzen ka tzul Elías k'ilcatz texin—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Cwa tel jun cyiw twi' Jesús, bix aj baj t-xewxin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tujxse naj tej tel tanem Jesús, jnintzaj xbalen tjaw tuj nintzaj tja Dios te maksbil twitzj mas jawnex xjan cwart jaa' u'la Dios, bi'x e cub rotj tmij. Bix tuyax jun xcyaklajnab, bi'x e baj cub c'abch ke xak. ");
INSERT INTO mamNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bi'x e jket cyjayel anem. ");
INSERT INTO mamNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mas yaj, tej tjatz itz'j Jesús juntl maj tuj cyamecy, nim cyxumlal ocslal otk chi cyim e jatz itz'j tuj cyamecy, bix etzke tuj camposant bix ulke tuj xjan tnom te Jerusalén tu'n t-xi' cyyeec'an cyiib cywitz nim xjal. ");
INSERT INTO mamNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yal tzunj xin capitán cye soldado e jaw k'onte Jesús twitz cruz, cyuyaj xin c'ojlalte Jesús, tej toc cycye'yenxin xcyaklajnab bix cykilcaj otk baj, e tzaj ttz̈i cyi'jxin, bix e xi' cykba'nxin: —Jaxnete tej xin xinak lu Tcwal Dios texin—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bix jax at nim xuuj ncye'yentz nakch. Otk chi oc lpe ke xuuj lu ti' Jesús tej ttzaj tuj Galilea, kej otk chi ajben te onel tuyaxin tuj be. ");
INSERT INTO mamNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Cyxol tzunxuj tocxe jxuj María Magdalena, tuyax juntlxuj María, ttxu Jacobo tuya José, bix xsunj xuj cytxu tcwal jxin Zebedeo. ");
INSERT INTO mamNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tejtzen ch'itk tex k'ij, ul junxin k'ina, José tbi, aj tnom te Arimatea. Otk tz'oc lpexin ti' t-xnak'tzbil Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jatzen José e xi' tuya Pilato te kanlte t-xumlal Jesús. E tcuya Pilato, bix e tkba tu'n t-xi' k'o'n t-xumlal Jesús texin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Bix e cu'tz tii'n José t-xumlal Jesús, bix oc tbalk'i'nxin jun xbalen sak ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bix ocx tk'o'nxin tuj jun ac'aj tjayel anem twitz xak, tex texin tjayelxin otk tz'oc tbincha'nxin. Bix oc tlomo'nxin ttzii' tuya jun tij xak, bix etzxin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yaltzen te María Magdalena tuya juntl María, k'uklkexuj twitz tjayel anem. ");
INSERT INTO mamNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tetzen juntl k'ij, jk'ij te ajlabl, e baj cychmon cyiib kej nejenel cye pala cyuyax aj fariseo twitz Pilato. ");
INSERT INTO mamNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","E xi' cykba'nxin texin: —Taat, n-ul tuj kc'u'ja j-e tkba ja ẍtak' xjal lu tej mitkna'x tcyim. E tkbaxin: “Te toxen k'ij chin jawel itz'ja juntl maj tuj cyamecy,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ju' tzunj, kbanx cye soldado tu'n tcyiwset tlemel tjayelxin cyuj ja oxe k'ij lu, tu'ntzen mi'n chi ul t-xnak'atzxin te koniyan tu'n tetz cyalk'a'nxin t-xumlalxin, bix cxe'l cykba'n cye xjal ka ma jatz itz'jxin juntl maj tuj cyamecy. Ka ju' pjel, mas chi pjel sbu'n ke xjal twitzj nejl—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","E xi' tkba'n Pilato cyexin: —Lu jun cloj soldado te cyey. Cyucxa cyey, bix cycyiwsam tjayelxin tisenj tzin cyse'na—tz̈i Pilato. ");
INSERT INTO mamNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Exkexin, bix e baj cycyiwsa'nxin tjayel Jesús. Oc cyk'o'nxin jun techel ti'j tij xak ttzii', tu'ntzen tchic'ajax ka otk tz'aj lk'e xak, bix e cyaj cyk'o'nxin ke soldado te c'ojlal. ");
INSERT INTO mamNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tbajlenxitzen jk'ij te ajlabl, tej ch'itk kskix tuj tneel k'ij te smant, ja tzunj xuj María Magdalena, tuya juntlxuj María, ul cye'yelte tjayel Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tisen tii' tej ttzaj jun nintzaj xcyaklajnab, bix e cu'tz jun tsanjel Dios tuj cya'j, bix el tii'n jxak ttzii' tjayel anem, bix e cub ke ángel tibaj xak. ");
INSERT INTO mamNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tzinxsen ntxakakan, tisen jun tken k'ancyok, bix sakxix t-xbalen tisen skbaken. ");
INSERT INTO mamNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jatzen ke soldado, e tzaj lu'lenkexin tu'n ttz̈i ángel cyi'jxin, bix ya min e yucchkexin, tisen ke cyimne. ");
INSERT INTO mamNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bix e xi' tkba'n tsanjel Dios cye xuuj: —Mi'n chi jaw sey'paj cyey. Ntzki'na nchi jyon cyey t-xumlal Jesús, jxin e jaw twitz cruz. ");
INSERT INTO mamNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pero ya min-altl texin tzalu, cuma ma jaw itz'jxin juntl maj, tisen e tkbaxin. Cycye'yenctz. Min-alxin jaa'j ocxexin. ");
INSERT INTO mamNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cyucxa naja cykba'xsen cye t-xnak'atzxin ma jatz itz'jxin juntl maj tuj cyamecy, bix cxe'l nej texin cywitz tuj Galilea, jatztzen c'oquel cycye'yen jaxin. Lu ma txi' nkba'na cyey—tz̈i ángel. ");
INSERT INTO mamNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Entonces bix etz ajkelen kej xuj xuuj. E tzaj ttz̈i cyi'jxuj, pero jax ju'x e tzalajkexuj. E xi'kexuj tuj ajkelbil kbalte tyol ángel cye t-xnak'atz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pero jey', oc nojtl Jesús cywitzxuj, bix e xi' tk'o'nxin jun k'olbebl cyexuj. Bix e pon lk'ekexuj ti'jxin, bix e cub majekexuj twitzxin tu'n cysukenxuj t-xee' tkenxin. ");
INSERT INTO mamNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Bix e xi' tkba'nxin cyexuj: —Mi'n tzaj ttz̈i cyi'ja. Cyucxa cykba'x xsuna cye nxnak'atza tu'n cyxi' tuj Galilea, jatztzen c'oquel cycye'yen inayena—tz̈i tzunxin. ");
INSERT INTO mamNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Maatktzen xi'ne cyxi' kej xuuj lu, at juun cyxol soldado c'ojlal tjayel Jesús e xi' tuj Jerusalén, bix e xi' cyk'umen cye nejenel cye pala ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tejtzen cybinte pala cyyol soldado, e baj cychmon cyiib cyuya nintzaj xjal tu'n cyyolen ti'j cyxolx. E xi' cyk'o'n nim cypwak ke soldado, ");
INSERT INTO mamNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bix e xi' cykba'n cye: —Cykbanx cye xjal: “Ul ke t-xnak'atz Jesús te koniyan bix etz cyalk'a'n t-xumlalxin tej nko wutana,” tz̈i cybela. ");
INSERT INTO mamNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bix ka ma tbi gobernador etz k'i'n Jesús jooc'tzen nchi wutana, cbinel ti'j ku'na tuyaxin tu'ntzen mi'n chi byeta—tz̈i nejenel cye judío cye soldado te Roma. ");
INSERT INTO mamNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","E xi' cyii'ntzen soldado pwak, bix e cybincha tisenx e tzaj cykba'n cye. Ja ẍtak' yol lu el tz̈itj cyxol judío, bix hasta ja'lewe at xjal tzin cybi'n. ");
INSERT INTO mamNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yaltzen cye junlaaj t-xnak'atz Jesús, e ponkexin tuj Galilea, twi' witz jaa' otk tkba Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bix tej cylontexin Jesús, e jaw cynimsa'nxin jaxin. Pero at cab cyxolxin e baj cyc'u'jxin ka yaa'n jaxin. ");
INSERT INTO mamNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Bix e xi' tkba'n Jesús cye t-xnak'atz: —Ma tzaj k'o'n weya wipemala tu'n ncawena tibaj cykilca tuj cya'j bix twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ju' tzunj, cyucxa tuj cykilca tnom twitz tx'otx' te kbalte cye xjal tu'n cyoc nxnak'atza. Bix cybautizara cye te techel cywitz xjal ma txi' cyk'on cyiib te Dios Mambaj bix te Dios Cwalbaj bix te Espíritu Santo. ");
INSERT INTO mamNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Cyxnak'tzanx cye tu'n tbint cyu'n cykilcaj ma txi' nkba'na cyey. Bix chin temela cyuyey cykilca k'ij, hasta ojxe tul manc'bil k'ij—tz̈i Jesús cye t-xnak'atz.");
INSERT INTO mamNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ja libro lu ma tzak' yolel ti' tbanel tpocbal Jesús, tcwal Dios, jaj junxin xjal e tyole Dios jatxe tuj tneel. ");
INSERT INTO mamNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jatxe nejl, bix e cyaj ttz'i'ben Isaías, jaj jxin tyolel Dios cyxol xjal te Israel, ti toc tu'n Dios te Tcwal. Tz̈itzen Dios cyjulu te Tcwal, tz̈i Isaías: “Cxe'l nchk'o'n jun nyolel nejl twitza te yolel cyuya xjal nejl tu'ntzen cych'ixbente xjal cyanem. ");
INSERT INTO mamNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Cjawel yolen jxjala jaa' yaa'n nim xjal najl. Tz̈itzen tbel cyjulu: ‘Cybincham cyiiba twitz Taaw twitz tx'otx'. Cyjkom tbexin tuj cyanema,’ tz̈i tbel jxjal cjawel yolen,” tz̈i Dios te Tcwal, tz̈i Isaías tcyajlen ttz'i'benxin. ");
INSERT INTO mamNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yaa'ntzen ti e baj. Eltzen cab jnabk'i ba'nxix. Cwatzen tul itz'j jxin xjal e tkba Dios. Bix oc tbixin te Juan Bautista. Tej tzunj toc Juan ma' xjal, bix e xi' Juan tuj jun lugar jaa' yaa'n nim xjal najl. Bix nim xjal e pon tu'ntzen cybautizarj xjal tuj nima' te Jordán. Bix e xi' tkba'n Juan cye xjal cyjulu: —E cybautizarj tzuna tu'ntzen telniy' ka otk tz'ajtz ti' cynaabla twitz Dios, tu'ntzen tcub tnajsa'n Dios cyila—tz̈i Juan Bautista cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bix e pon nim xjal tej tnom Judea bixsen tuj nin tnom te Jerusalén te ebil tyol Juan. Bix e jatz cykba'n cyil, bixse e bautizarjke tu'n Juan tuj nima' te Jordán. Jatzen techel ka otk tz'oc cyk'on cyiib xjal tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yaltzen te Juan t-xbalen, binne tuya ttzmal camello, ẍpo'ntzen tcy'itzxin tuya jun gamús. Yaltzen twaxin, bix e cnet tchi'xin ni' coc'kejil tisen jun cuchi', bix tc'a'xin ta'l xii'. ");
INSERT INTO mamNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yaltzen tyolxin cye xjal, tz̈i tzunxin cyjulu: —Tzul juntl xjal lepchxe wi'ja mas nintzaj nwitza. Nintzaj xsunxin, yal weya mitetpe tak'el t-xaabxin ba'n tel npju'na. ");
INSERT INTO mamNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Matzen chi bautizarja wu'na nuk tuya a', pero tzunj xjal tzul cxe'ltzen tk'o'n Espíritu Santo cyey—tz̈i Juan Bautista cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nk'ontzen Juan ke xjal tuj a', tej tetz Jesús tuj Nazaret, jun tnom te Galilea, bix e ponxin ti' Juan ttzii' jnima' te Jordán, bixsen e tbautizaran Juan Jesús tuj a'. ");
INSERT INTO mamNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Njatzcaxix Jesús tuj a' tej t-xi' tcye'yenxin tej tjket cya'j, bix e tilxin tej tetz Espíritu Santo tuj cya'j tisen junjil cucu'. Bix e cub licy'paj tuj twi' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bix e tbi Jesús ttzaj tyol Dios tuj cya'j. Tz̈itzen cyjulu: —Jay Ncwal a wanem ti'j. Jay ma nsicy'a—tz̈i jyol ttzaj tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yajc'atltzen, bix e xi' k'i'n Jesús tu'n Espíritu Santo tuj jun lugar yuman. Min-al xjal najl tuj. ");
INSERT INTO mamNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","E ten Jesús cya'wnak k'ij tuj ja lugara. E tenxin cyxol talen c'ul. Bix jatztzen oca ten taaw il niy'belte tii'n tipemal Jesús. Tbajlenxitl tzunj ju'wa, bixse ul ke tsanjel Dios onlte Jesús. Bix ocx Juan Bautista tuj tzee' tu'n cawel tuj Judea cuma tajxin e we' t-xnak'tzbil Juan Bautista. ");
INSERT INTO mamNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tocxlenxitltzen Juan tuj tzee', bix e xi' Jesús tuj tnom te Galilea te k'umlte tumel cye xjal ti' tpocbal jtbanel Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tz̈i tzunxin cyjulu: —Ya matzen pon tumel tu'n tul tcawbil Dios cyxola. Matzen pon tumel tu'n t-xi' tyeec'an Dios cyey ti tse'xa ejee'y tu'n cyco'pja tuj cyila. Ya lutzen ma tzula. Cyimaltzen cyiiba ti' il. Ccyajtzen meltz'aj tuya Dios, bix cybimtzen tumel jtbanel tyol Dios—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","At jun maj t-xi' Jesús betel ttzii' jun tnijabel a', tcub tuj Galilea, bix oc noj Jesús ti'j jxin Simón, bix yajc'atl oc juntl tbixin Pedro, bix titz'enxin Andrés. Tzyul quis̈kexin tuj a'. Tej toc noj Jesús cyi'jxin, nxi' cyxoo'nxin cyxiy'paxin tuj a' te tzyul quis̈. ");
INSERT INTO mamNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Bix e xi' tkba'n Jesús cyexin: —Chi lpetz wi'ja. Ja'lewe lu key nchi chmon quis̈a. Pero inayenxse chin oquel k'onte cyey te txcol xjal tu'n cybinte nyola—tz̈i Jesús te Simón tuya Andrés. ");
INSERT INTO mamNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tejtzen cybinte xinj ju'wa, bixse tcyaj cyk'o'nxin cyxiy'paxin tu'n cyoc lpexin ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bix e xi' cybetexin juntl tkiy', bix oc nojkexin ti'j jxin Santiago tuya titz'enxin Juan, junxitl Juan, tcwal jxin Zebedeo tbi. Ete'c'axxin tuj jun choc, nchi binchanxin cyxiy'paxin. ");
INSERT INTO mamNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bix e tzaj ttxco'n Jesús ejee'xin. Bix e cyaj cyk'o'nxin cyxiy'paxin te cymanxin bix cye ke onl cyexin, bix e xi'kexin tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bix e ponkexin tuj jun tnom Capernaum tbi. Tec'atzen jun k'ij cynimbil xjal tej tocx Jesús tuj jun camon jaa', jaa' nchi na'na xjal Dios, sinagoga tbi, bix ak'xin xnak'tzal cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bix e baj jaw klee' ke xjal ti'j t-xnak'atz Jesús cuma e xnak'tzanxin tisen jun xjal tuya tipemal, yaa'n ju' yolexin tisen kej xin tx'olbal ley. ");
INSERT INTO mamNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nxnak'tzantzen Jesús tuj camon jaa' te xnak'tzabl tyol Dios, tej tocpan jun xjal otk tz'oc licy'paj biman ti'j. Bix e jaw s̈-in: ");
INSERT INTO mamNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Jey'! ¿tu'n tikentzen ma tzuley yajlalec keya, Jesús te Nazaret? ¿Mapa tzula te xitlc'a keya? Ntzki'nwe al cyey, bix ntzki'nwe ka jay jxjan te Dios—tz̈i biman otk tz'oc ti' xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bix aj ttzak'be'n Jesús te biman: —¡C'ol! ¡Bix k'oncj xjal lu!—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bi'xse e tzaj cyim jxin xjal tu'n tipemal biman tej tel ok ti'jxin tu'n Jesús. Tzinxse ns̈-in biman tej tel. ");
INSERT INTO mamNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bix cykilca ke xjal e jaw klee' bix ak' ke xjal kanlte tiy' cyxol: —¿Titzen xjalel jxin lu? Nejl ma ko baj t-xnak'tza'nxin tuya nim tipemalxin. Yaltzen ja'lewe hasta cyuyax biman ma tz'abinte tyolxin—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Lwewaxse el tz̈itj naj tpocbalxin tuj cykil Galilea. ");
INSERT INTO mamNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tejtzen tetz Jesús cyuya Santiago bix Juan cyuyax Simón bix Andrés tuj camon jaa' te xnak'tzabl tyol Dios, bix e xi' bajkexin cyja Simón tuya Andrés. ");
INSERT INTO mamNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tej tzunj cyponxin tja Simón, tjax jxuj tjii' Simón twi' wetbil, cuma otk tzaj yebt-xuj tu'n nin cyak. Bix e xi' cykba'nxin te Jesús ka yaabxuj. ");
INSERT INTO mamNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bix e xi' lk'e Jesús, bix e jaw tii'nxin tk'abxuj. Tzinxix njaw tii'nxin tk'abxuj tu'n tjaw we'xuj, n-el licy'pajtl yabel. Bix ak'xuj cyey'lx cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tetzen otk cu'x k'ij, tej cyak' pomel nim xjal tja Simón tuya cyyaab bix kej xjal otk tz'oc licy'paj biman cyi'j, tu'ntzen toc tk'a'na Jesús ke yaab, bix tu'n tel tlojo'n Jesús biman cyi' xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nimxse xjal e pon ttziyan tisenc'a cykilca tnom. ");
INSERT INTO mamNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bix oc tk'a'na Jesús kej xjal yaab, bix el tlojo'nxin biman cyi'j juntl wik xjal. Pero tej tzunj tel tlojo'nxin biman cyi' xjal, mintzen e tcuya Jesús tu'n cyjaw yolen biman, cuma cytzki'n biman twitz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tetzen klaxca, n-ak' cwelc'a jket t-xee' cya'j, bix e jaw we' Jesús, bix exxin ttxa'n tnom te yolel tuya Dios tjunalxin. ");
INSERT INTO mamNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yaltzen te Simón bix xsunj oxetl tuyaxin, bix exkexin te jyolte Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tej tzunj tcnet Jesús cyu'nxin, bix e xi' cykba'nxin te Jesús cyjulu: —Cykilcaxse xjal njyon ti'ja. ¿Tikentzen min che'x tcye'yena xjal?—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero bix aj ttzak'be'n Jesús cyexin: —Mlay ko aj meltz'ajtl cyuya xjal, cuma il ti'j ma ko'x te pocbal tej tbanel Dios cye xjal cyuj jun wikxitl tnom nka tzalu, cuma yaa'n nuk tzalu ma chin tzaa' kbalte tyol Dios—tz̈i Jesús cye Simón. ");
INSERT INTO mamNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ju'tzen e pja' cybetsa'n Jesús cyuya ke tuya tuj cykilca ke tnom te Galilea. Bix tuj jaca camon jaa' tuj juun tnom ocxakexin kbalte cye xjal jtbanel tyol Dios. Bix n-elxitzen tlojo'nxin biman cyi'j xjal otk tz'oc licy'paj biman cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pero attzen jun k'ij, bix ul junxin xjal yaab tu'n lepra otk tzaj k'ey tk'abxin tisen tu'n tz'enak. Bix e xi' lk'exin ti' Jesús, bix e cub majexin, bix e xi' tkanenxin te Jesús tu'n toc k'anet-xin. Tz̈i tzunxin cyjulu: —Taat, ¿tajpey tz'el tii'na ch'in jyabela wi'ja? At tey tipemal tu'n tel tii'na—tz̈i tzunxin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bix oc cy'ixbe tc'u'j Jesús ti'jxin. Bix oc tmoco'n Jesús jaxin. —Wajwe, cyaj tey ba'n—tz̈itzen Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tujx naj t-xi' tk'umen Jesús, tzin ncyajtl jxin xjal ba'n. ");
INSERT INTO mamNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bix e xi' tkba'n Jesús texin: —Cutxena tey. ");
INSERT INTO mamNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Pero mi'n txi' tk'umena ti ma baj tey, sino jiquen t-xi'y te yec'l tiiba twitzj xin tawil na'l Dios, tu'n toc tcye'yenxin jay ka ma tzul tnaabla. Bix k'inx xsunj tik'ch c'ajbel tey tisej e cyaj tkba'n Moisés, tu'ntzen t-xi' toyen tawil na'l Dios tisex tten tley Moisés, tu'ntzen tcyaja tuj chic'aj ka ma tzul tnaabla—tz̈i Jesús texin. ");
INSERT INTO mamNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ch'in tel-len lk'e jxin xjal, bix ak'xin kbalte ka otk tzul tnaablxin tu'n Jesús cye cykil xjal. Ju'tzen e'la nim tpocbal Jesús. Ya min ocxtlxin cyuj tnom tu'n nimxse xjal oc cutz'j ti'jxin. Ju'tzen e webaxin tuj cojbil jaa' yaa'n nim xjal najl. Pero nuk jak'ch e tzaa' jlet ke xjal cyey'lte texin. ");
INSERT INTO mamNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Eltzen cabtl k'ij, bix ocx meltz'aj Jesús juntl maj tuj tnom te Capernaum. Pero tej tzunj tbijt tpocbal Jesús ka otk ponxin tuj jun jaa' tuj tnom, ");
INSERT INTO mamNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","lwewa e jaw tchmon naj tiib xjal tpe'nj jaa' jaa' otk tz'ocxa Jesús, bix ocx baj ke xjal tunwen. Ya min ocx bajtl ke xjal tunwen, bix mitetpe pe'ntl oca baj ke xjal. Bix ak'xin te tx'olbal tyol Dios cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ntx'olbantzente Jesús cyxol xjal, tej tul jun cloj xjal ikentzen jun yaab tu'n cyaja cyexin twitz jun wetbil. Mintii' tanem t-xumlalxin. ");
INSERT INTO mamNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero ya mix ocxakexin jaa' tocxe Jesús tunwen, cuma otk noj jaa' cyuya xjal. Entonces bixse e baj cybincha'nxin yaab tu'n tjax cyii'nxin yaab twi' jaa'. Bix el cyii'nxin jun txol twi' jaa', tu'n tcu'x cyxtunenxin yaab twitz wetbil jaa'j tcu'xa Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pero tej tzunj toc tcye'yen Jesús k'uklec cyc'u'j xjal ti' Jesús, bix e xi' tkba'nxin te yaab cyjulu: —Ncy'aal, matzen najset tey til ja'lewe—tz̈itzen Jesús te yaab. ");
INSERT INTO mamNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pero k'uklec xsunkej xin tx'olbal ley, bix iy' tuj cyc'u'jxin cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Tikentzen t-xoo'na tiib jxjal lu te yolel ju'wa? Nxoo'n teja yol ti' Dios. O'cxc'ate Dios ba'n tnajsante cyil xjal—tz̈i tzunkexin tuj cyc'u'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero el naj tniy' Jesús ti'j ti jilel niy' tuj cyc'u'j tx'olbal ley, bix e xi' tkanenxin: —¿Tikentzen nxa' cyxi'mana ju'wa? ");
INSERT INTO mamNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Alcye mas secy tyol jilj tej yaaba tuj cywitza, japa: “Ma najset tila,” bix ma jaj: “We'wetzen tey, k'inx twetbila, bix cutxetzen tjay”? Oj t-xi' tk'umen jun xjal: “Ma najset tila,” yaa'n cyiwte tyol jilj, cuma min chic'aj ka otk najset til xjal, bix ka min. Pero oj t-xi' tk'umen jun xjal tej yaaba: “We'wetzen tey, k'inx twetbila, bix cutxetzen tjay,” mas cyiw tyol jilj, cuma cchic'ajaxel naj ka ma tzul tnaabl, bix ka min. ");
INSERT INTO mamNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero konyeec'axse cyey ka inayen weja, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal, at wipemala twitz tx'otx' tu'n nnajsa'na cyil xjal—tz̈i Jesús cye tx'olbal ley. Entonces bix e xi' tkba'n Jesús tej xin yaab: ");
INSERT INTO mamNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—We'wetzen tey, k'inx twetbila, bix cutxetzen tjay—tz̈i Jesús te yaab. ");
INSERT INTO mamNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tej tzunj t-xi' tkba'n Jesús, tzin njaw we'tlte yaab, tzin niy' ti'tlxin twetbilxin, n-etztlxin tuj jaa' cyxol xjal. Ju' tzunj nimxse e jaw klee' ke xjal, bix oc tzalaj ke xjal ti' Dios, bix e baj jaw yolenke: —Bajxse tz'oca kcye'yen jun maj tisej lu—tz̈itzen ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tbajlen tk'a'naxitltzen Jesús jxin mintii' tanem t-xumlal, bix e xi' meltz'ajxin ttzii' jtnijabel a', bix ak' pomel lk'e ke xjal ti' Jesús, bix nxnak'tzantzen Jesús cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","T-xi' tbeten Jesús juntl tkiy', bix exxin twitz jun jaa', jaa' ete'c'a kej xin chmol chojentj najben te juntl tnom Roma tbi. Jatztzen oca noj Jesús ti' Leví, tcwal jxin Alfeo. Jatzen Leví chmol pwak tu'n Roma. Bix e xi' tkba'n Jesús te Leví: —Lpetz tey wi'j te wuya—tz̈itzen Jesús. Bix e jaw we' Leví, bix oc lpexin ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yaa'ntzen ti e baj, bix e xi' ttxco'n Leví ja Jesús te waa'l tja cyuyax ke t-xnak'atz Jesús lepch ti'j, bixse ke kanl chojentj, bix nimtl xjal iiq'uenke tu'n juntl wik, cuma nimxse xjal yaa'n ba'n oc lpe ti'j Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bix e pon cabxin tx'olbal ley, cyxol jun cloj xjal n-oc cyk'on cyiib cyiw tuj jtley Dios e cyaj tk'o'n Moisés, fariseo tbi cyclojan xjal. Tej tzunj tocx cycye'yen tx'olbal ley nwaa'ncx Jesús cyuya yuwin xjal, bix e xi' cykanenxin cye t-xnak'atz Jesús: —¿Titzen taj jxin xnak'tzal cyey nwaa'ncxxin cyuyaj yuwin xjal bix xsunkej kanl chojentja?—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pero e tbi Jesús cyyol tx'olbal ley tej t-xi' cykba'n cye t-xnak'atz Jesús. Bix e xi' tkba'nxin cye tx'olbal ley: —Kej xjal ba'n min che'xcye tuya k'anel. Yal tzunkej xjal yaab, il ti'j nche'x tuya k'anel. Jaxse ju'x weya. Min ma chin ul weya te k'ilectz cyej xjal mintii' cyil cyey tuj cywitz, sino ma chin ul weya k'ilectz cyej xjal aj il tuj cywitza—tz̈i Jesús cye tx'olbal ley cyxol fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pero attzen jun maj min chi waa'n xjal lepch ti' tyol Juan Bautista bix xsunkej xjal lepch ti'j ley fariseo, tu'n t-xi' cyyeec'an xjal cyanem te Dios. Attzen cabtl xjal e xi' kanlecte te Jesús: —Ma kila ka min chi waa'n jxjal lepch ti' Juan Bautista bix ke lepch ti'j ley fariseo. Pero yaltzen kej tey t-xnak'atz, minttzen chi waa'n tisej cyewa. ¿Tikentzen min cybinche tisej cyej xjala?—tz̈i ke xjal te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Bix aj ttzak'be'n Jesús cye xjal: —Tuj jun mejoblenel tzul nim xjal tuya chmilbaj te iy'sal nin k'ij. Jayaxittzen cub cyyo'n xjal weyaj, sino chi waa'lcye xjal, cuma nchi tzalaj. ");
INSERT INTO mamNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","La' altzen cye jun k'ij oj tcub naj chmilbaj, attzen bis. Entonces jatzen mi'n chi waa'ncye xjalj. Jaxse ju'x weya. Ojtzen ncub naja, ba'ntzen tcub cyyo'n weya nxnak'atz weyaj, pero ja'lewe mlay. ");
INSERT INTO mamNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Pero at juntl cxe'l nkba'n cyey. Min-al jun xjal ncu'x k'onte jun remyent ac'aj ti' jun xbalen k'anak, cuma mas q'uelex rotj k'anak tu'nj ac'aj oj toc yut'paj. Jaxse ju'x weya, ac'aj nyola. Mlay tz'oc tmoj k'anak xnak'tza'n. Tej min chi waa'n xjal ja'lewe ja te xnak'tza'nja te nejl. ");
INSERT INTO mamNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bix juntl. Tise oj ncub cyk'eysa'na ac'aj cyviney tuj jun k'anak tz'u'n, n-ex rotj tu'n vino oj n-el ipc'aj, cuma cxe'l tz'u'n tuj il tuyax vino q'uelel kojl. Pero oj ncub cyk'eysa'na ac'aj cyviney tuj ac'aj tz'u'n, mintzen tz'ex rotj. Jaxse ju'x weya nxnak'atz. Mlay tz'ocx tuj cyey k'anak cyxnak'atza—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Attzen jun k'ij, bix ex bet Jesús cyxol triwa cyuya t-xnak'atz. Tec'a manc'bil k'ij tuj smant, jaj k'ij xjan cyxol xjal. Nchi exxe tzunxin ttzii' triwa, niy'xetzen cytokaxin tspigayil triwa, nxi'xetzen cywaa'nxin, tisenx cyten xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bix oc naj cykanbil jxjal fariseo twitz Jesús: —Cyena. ¿Tikentzen tzin tcuyaney tu'n tel cytokan jtey t-xnak'atza tspigayil jtriwawa? Xjante ja'lewe. Keya kxol, ak'untl teja, bix jatzen jun k'ij tu'n kajlan keya ja'lewe—tz̈itzen ke fariseo te Jesús, cuma nimalxse ke xjal tuj cyley. ");
INSERT INTO mamNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero bix aj ttzak'be'n Jesús: —¿Bajxpatzen txa' cycye'yena tuj u'j ti e baj tej xin kiy'jil David cyuya ke tuyaxin tej toc nim tak' weyaj cyexin jun maj? ");
INSERT INTO mamNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Te tzunj tyem tej tocx Abiatar te nintzaj tawil na'l Dios, bix ocx David tuj tja Dios, bix etz tii'nxin jpan clo'n tex te Dios, bix jatzen panj xjan t-xi' twaa'n jun xjal, o'cxc'a ke tawil na'l Dios ba'n t-xi' waa'nte. Bix e xi' twaa'n David cyuya ke tuya—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bix e xi' tkba'n Jesús juntl yol cyexin: —At juun tley Dios mas nintzaj twitz cabtl tley Dios, tisen tzunj ley tu'n tclet xjal tu'n weyaj twitzj nuk c'u'n xjan pan. Yaltzen tisen ja lu, ja k'ij te ajlabl o cub tbincha'n Dios te onbil xjal. Pero yaa'n te xjal o cub bint te c'ojlal te k'ij. ");
INSERT INTO mamNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ju' tzunj inayena, jxjal Sma'n tu'n Dios, at wipemala ncawena cyibaj xjal la' ti cwel cybinchen te ja k'ij ja'lewe—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pero attzen jun maj, bix ocx meltz'aj Jesús tuj jun camon jaa' te xnak'tzabl tyol Dios. Pero toc tcye'yen Jesús, tocx junxin xjal cyimne jun tk'abxin tuj camon jaa'. Tec'aj k'ij manc'bil tuj smant, xjan cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pero tec'a tzunj k'ij xjan, bix ete'c xsunj xjal tej cloj fariseo tuj camon jaa'. Tej tzunj toc cycye'yen fariseo ja Jesús, bix oc tenkexin c'ojlalte Jesús ka tu'n toc tk'a'naxin tk'ab jxjal yaab tuj k'ij xjan, tu'ntzen teleniy' ka tu'n tcub tz'akxin tuj tley Moisés. ");
INSERT INTO mamNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Entonces bix e xi' tkba'n Jesús tej xin yaab: —We'wey, bix we'c'atzen tzalu cywitz xjal—tz̈i Jesús texin. ");
INSERT INTO mamNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bixse e xi' tkanen Jesús cye xjal fariseo: —¿Cuyanpatzale tu'nj cyleya tu'n tcub kbinchen jun xtalbil tej k'ij ajlabla, bix ma ja jun k'ij tu'n tcub kbinchen jka'? ¿Cuyanpale tu'nj cyleya tu'n toc clet cychunk'lal xjal, bix ma ja jun k'ij nuk c'oquel cye'yet jun xjal oj tcub cyim?—tz̈i Jesús. Pero min-al ajtz tzak'bente Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Toc tcye'yen Jesús mintii' lastim cye xjal tuj cywitz fariseo, bix e tzaj tk'ojxin tuyax e jaw bisexin, bix e xi' tkba'n Jesús tej xin mintii' tanem tk'ab: —Nukpinx tk'aba—tz̈i Jesús. Bix e xi' tnukpi'n jxin xjal tk'abxin, bix ul tnaabl tk'abxin. ");
INSERT INTO mamNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pero tej tzunj toc cycye'yen jxin fariseo ja lu, bix etzkexin tuj camon jaa', bix ak'kexin te ninc'ul ti'j, tuya juntl clojxin tk'on tiib tuya Herodes, tu'n ti tten tu'n tcub Jesús. Jatzen Herodes cawel tibaj Galilea. ");
INSERT INTO mamNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yal te Jesús, bix e xi'xin ttzii' tnijabel a' cyuya t-xnak'atzxin. Pero nimxse xjal aj Galilea lepchec ti' Jesús. Bix nimxse xjal e tzaj te jun wiktl tnom. E tzaj te Judea, ");
INSERT INTO mamNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","te Jerusalén, te Idumea, te juntl jlajxe te nima' Jordán, tej tnom Tiro, bixse te Sidón, cuma txolen toc cybi'n xjal tik'ch nbint tu'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tocxse lpe nim xjal, bix e xi' tkba'n Jesús cye t-xnak'atz tu'n tcub cybincha'n jun choc tuj a' tu'ntzen mi'n tz'oc cutz'jxin cyu'n xjal, ");
INSERT INTO mamNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","cuma nimxse xjal yaab otk tzul tnaabl tu'n tipemal Jesús. Ju' tzunj nimxse juntl wik xjal yaab e baj tcu'tz'en tiib te mocolec te Jesús tu'n tul cynaabl. ");
INSERT INTO mamNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bix ju'x kej xjal otk tz'oc biman cyi'j, bix e ponke ti' Jesús. Pero tej tzunj toc cycye'yen biman ja Jesús, bix oc cychk'o'n biman ke xjal tu'n cycub maje twitz Jesús. Bix e jaw s̈-in ke biman: —¡Ja teyj Tcwal Dios!—tz̈itzen ke biman. ");
INSERT INTO mamNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero bix e xi' tmayo'n Jesús ke biman tu'n mi'n jaw cys̈i'n biman alcye Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yajc'atltzen bix e xi' Jesús cyxol coc' witz, bix e xi' ttxco'nxin kej xjal e tajbexin. Tej tzunj cychmet-xin, ");
INSERT INTO mamNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","bix etz tscy'o'n Jesús cablajajxin te tuya Jesús, bix tu'ntzen cyxi'xin kbal tbanel tpocbal Jesús cye xjal tuj cykil tnom. ");
INSERT INTO mamNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bix e xi' tk'o'n Jesús cyipemalxin te lojolbel biman cyi' xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ejee'tzen xinj e tsicy' Jesús, kej xin lu: Simón, pero bix oc tk'o'n Jesús tcab tbixin te Pedro, ");
INSERT INTO mamNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago, bixse titz'enxin Juan, tcwal jxin Zebedeo, jatzen Santiago tuya Juan oc tk'o'n Jesús cybi te tcwal k'ancyok, cuma nim nchi k'ajt-xin, ");
INSERT INTO mamNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, bixse Santiago, tcwal jxin Alfeo, Tadeo, Simón, xcul xjal te jun cloj Celote tbi, ");
INSERT INTO mamNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","bixse Judas Iscariote, jatzen xinja t-xi'lel q'ueyente Jesús mas yaj. Ejee'tzen xinj oc cybi te t-xel Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tetzlenxitltzen tscy'o'n Jesús ke t-xnak'atz, bix aj meltz'ajxin cyuya t-xnak'atz tuj jaa' jaa' ntemaxin. Bix tocxse chmet nim xjal ti' Jesús juntl maj, ya mintey' e binttl twaa'nxin cyuya ke t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pero tejtzen toc cybi'n ke te tja Jesús tik'ch nbaj texin, bix e xi'ke te k'ilx texin cyja, cuma e'latzen tuj cywitz ka tuj twi'xin otk jaw. ");
INSERT INTO mamNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ju'x kej xin tx'olbal ley, otk chi tzajxe tej tnom Jerusalén, ka' cyyolxin ti' Jesús. Bix e baj yolenkexin cyjulu: —Ma tz'oc tawil biman ti'jxin, bix ma tzaj tk'o'n tawil biman tipemalxin tu'n tel tlojo'nxin ke biman cyi' xjal—tz̈itzen ke tx'olbal ley te Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bix e tzaj ttxco'n Jesús ke tx'olbal ley, bix e xi' tkanen Jesús cyexin: —¿Ti tten oj tel tlojo'n tawil biman ke tuya ti' jun xjal? ");
INSERT INTO mamNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mlay tpa jun tnom ka tpa'n tiib tu'n k'oj. Cwel xitj. ");
INSERT INTO mamNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jun najaj xjal tpa'n tiib tuj tja jax mlay tz'itz'j tu'n k'oj. ");
INSERT INTO mamNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jaxse ju'x te bimana. Ka ma jaw meltz'aj biman ti'jx biman, jax mlay cypa biman. ");
INSERT INTO mamNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","At juntl cxe'l nkba'na cyey. Min-al ba'n tocx tuj tja jun xjal cyiw te k'ilbetz tk'inemal tuj tja. Katzen ẍpo'n, ba'ntzen tetz tk'inemal tuj tja. Jaxse ju'x weya. Waja chi el walk'a'na xjal te biman. Ju' tzunj cwel nẍpo'na biman. Ka ma tz'el nlojo'na ke biman cyi' xjal, jatzen ncub nẍpo'na biman bix chic'ajtzen ka at mas wipemala twitz biman. ");
INSERT INTO mamNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","¡Mi'n cyxoo' cyiiba! Tzinen cxe'l nkba'n cyey ba'n tcub tnajsa'nte Dios tixja ilel, bix tixja xoo'j yol ti' Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero al tzunj ma xoo'n yol ti' Espíritu Santo, mlaytzen tnajsa Dios til junx maj, sino matzen cyaj t-xee' til te junx maj—tz̈i Jesús cye tx'olbal ley, ");
INSERT INTO mamNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","cuma otk tz'oc cykba'nxin ka tu'n tipemal tawil biman otk tz'ela tlojo'n Jesús ke biman cyi' xjal, bix ju' otk tzaj te Jesús tipemal tu'n Espíritu Santo. Bix etzke tx'olbal ley. ");
INSERT INTO mamNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nuk ch'in tuj, tej tpon ttxu Jesús cyuya ke titz'enxin tpe'nj jaa' jaa' tocxa Jesús, bix ocx txocbajxin cyu'n ttxuxin tu'n tetzxin. ");
INSERT INTO mamNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pero min ocpan canantl jxjal ocx te txcolte Jesús. Entonces ejee'tl tzunj xjal k'uklec nka ttxlaj Jesús e xi' kbante: —Lu ttxuy cyuya ke titz'ena ete'c'a pe'na, bix lu ke nchi jyon ti'ja—tz̈i ke xjal te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bix aj ttzak'be'n Jesús: —¿Al tzunj weya ntxu, bix al tzunj weya witz'en?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bix ak' Jesús cyey'lec cye xjal, bix e xi' tkba'nxin: —Ejee' tzunj luwe weya ntxu bix weya witz'en. ");
INSERT INTO mamNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yal tzun kej ma chi ula jatzen weya ntxuj bix witz'ena te ntz̈q'uela. Pero aljxe xjal nbinchante tajbil Nmana Dios, ejee' tzunj c'oquel cyak' we, tisex ntxuya bix ke witz'ena te ntz̈q'uela—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Te juntl maj, bix ak' Jesús xnak'tzal xjal ttzii' tnijabel a' juntl maj. Tjawxse chmet xjal, bix e cu'x Jesús tuj jun choc tibaj a', bix e cub kexin tuj choc, nchi cyaj bajtltzen xjal ttzii' a'. ");
INSERT INTO mamNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Entonces bixse ak' Jesús xnak'tzal xjal, tuya jun tumel ti' awal. Tujtzen t-xnak'atz Jesús e xa' tkba'n cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Cyabintz ja lu: At junxin awal ex te awal triwa. ");
INSERT INTO mamNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tak' tzunxin awal, at cab iyaj e cub tz̈itj tuj be. Bix e pontl ke ch'it njaw cywaa'ntljil. ");
INSERT INTO mamNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Cabtl twitz iyaj e cyaj tz'ak twitz pc'at tx'otx'. Bix e jatz pok'ch te iyaj, cuma yaa'n nim t-xee' tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tu'ntzen tcykal k'ij, bix oc woch'paj, tejxe ttzkij, cuma yaa'n nim tloc' otk txi' tuj tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","At cabtl twitz iyaj e cyaj tz'ak tuj tik'ch ch'i'xel. Pero nuk e jaw ẍq'uililin tjak' ch'i'x, tejxe tetz cyim. Mintii' twitz e tak'. ");
INSERT INTO mamNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero at cabtl twitz iyaj e cyaj tz'ak tuj tbanel tx'otx', bix e jaw tz̈'iy, bix e tak' nim twitz. At juun tken e tak' winaklajaj twitz. At cabtl e tak' oxc'al twitz. Bix at cabtl tken e tak' jun mutx' tuya wink'an twitz, bix ma syent—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bix e xi' tkba'n Jesús: —Cyjkom cyẍquina. Katzen cyaja tz'el cyni'ya ti'j yol lu, cyxi'maxsen ti'j—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tcyajtzen Jesús tjunal cyuya t-xnak'atz bix cabtl xjal, bix e xi' cykanen te Jesús ti elpenina jyol otk tkba Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Bix aj ttzak'be'n Jesús: —Mintii' tumel cyuya xjal ti tten tjawlel ttz̈'is̈en Dios tcawbil. Yaltzen cyey, ejee'y nxnak'atz, matzen txi' tk'o'n Dios cyey tu'n tel cyni'ya ti'j ti tten bix ti ctemela tcawbil Dios twitz tx'otx'. Yaltzen cyej xjal min tz'oc cybi'n nyol, nchi oc nxnak'tza'nwe, pero yaa'nxix tuj jiquen yol. ");
INSERT INTO mamNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nchin xnak'tzantzenwe ju'wa tu'ntzen tchic'ajax ti elpenina jtyol kiy'jil Isaías tej t-xi' tkba'nxin cyjulu: “Cuma amale n-oquet cycye'yen, pero mintey' n-ak' cywitz ti'j. Bix seya n-oc cybi'n, pero mintey' n-el cyniy' ti'j. Nuket el cyniy' ti'j, otle chi meltz'aj tuya Dios bix otle najset cyil,” tz̈i Isaías. ");
INSERT INTO mamNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yajtzen cykanbila ti'j weya nyol, ¡jayaxittzen min tz'el cyni'ya ti'j! Kane min tz'el cyni'ya ti'j ja lu, jey', ¿tine cyse'y tu'n tel cyni'ya ti'j cabtl cyiw tpocbal tzul? ");
INSERT INTO mamNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Konkba'xne cyey ti elpenina jyola. Jxjal awal jatzen xjalj nkban tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ja tzunj iyaj cwel tz'ak tuj be, ja tzunja tisej nbajte tyol Dios tuj cyanem jun wik xjalja. Ejee'tzen xjalja n-oc e binte tyol Dios, bix n-el tii'ntl naj biman tuj cyc'u'j. ");
INSERT INTO mamNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ja tzun kej awal cjawel itz'j tuj pc'at tx'otx', jatzen juntl wik xjalja. Ejee'tzen xjalja n-oc e binte tyol Dios, bix n-oc juch cyc'u'j ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero yaa'n cyiw cyc'u'j, tisen yaa'n nim tloc' iyaj tuj tx'otx'. Ju' tzunj min cypa. Ka ti ilel ma tzaj cyi'j tu'n tyol Dios, ya mintltzen tz'oc juch tyol Dios ti' cyanem xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ja tzunj tx'otx' nim ch'i'x twitz, jatzen juntl wik xjalja. N-oc e binte tyol Dios, ");
INSERT INTO mamNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero nuk ju' naj cyc'u'j ti'j ti jilel at twitz tx'otx'. Ja tzunj nuk ju' toc cyanem ti'j ti q'uelexa cyk'ij, k'ak' cyc'u'j ti' k'inemal, bix n-oc tak' twitz tx'otx' cye, ejee' tzunja k'e'lecx tibaj tyol Diosa. Ya mintzentey' n-oc juchtl cyc'u'j xjal ti' tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ja tzunj iyaj e cub tz'ak tuj tbanel tx'otx', ja tzunja tisen kej xjal n-oc cybi'n tyol Dios, tzin cyiik' tyolxin, bi'x n-oc ten ti' cyanem. Ejee'tzen xjalja tisenj awal tzin tk'o'n nim twitz, tisenj tspigayil triwa attzen tk'o'n winaklajaj twitz, at te oxc'al twitz, bix at te syent twitz—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Bix ak' Jesús xnak'tzal xjal tuj ewjel yol juntl maj: —¿Jac'apatzen tzaj tii'n jun xjal jun cantil tu'n tocx ewet tjak' jun alma bix ma tjak' wetbil? ¡Min! Sino c'oquex k'it ja cantila tunwen tu'n tcub ten txakel tujxix chic'aj. Oj mintkna'x tocx cantil tunwen, min chic'aj tik'ch jilel tuj klolj. Pero ya oj tocpan cantil, cykilcaj min chic'ajax tuj klolj, ya chic'ajtltzen tuj tken cantil. ");
INSERT INTO mamNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jaxse ju'x weya. Jatzen cantilj weya jaxxix yol k'i'n wu'na. Ja nyola jaxxix yaa'n tu'n tcub ewet cyu'na, sino tu'n tk'umj. ");
INSERT INTO mamNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Al at tẍquin ti' twi', cybimc'atzen—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bix e xi' tkba'n Jesús juntl yol cye t-xnak'atz bix cye cabtl xjal: —Cyk'o'nc cyc'u'ja ti'j c'oquel cybi'na, cuma la' jniy' ch'in cyanema ti' tyol Dios, ka nim, jax tzul tk'o'n Dios nim tkenal tyol cyuyey. Ka yaa'n nim cyc'u'ja ti' tyol Dios, jax yaa'n nim tkenal tyolxin ctzaal cyuyey. ");
INSERT INTO mamNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bix xsunkej n-ocxix cyc'u'j ti' tyol Dios, tzul tk'o'n Dios mas ttxolen tyol cyuya. Pero tzunkej min k'ak'xix cyc'u'j ti' tyol Dios, hasta q'uelel baj tuj cyc'u'j alcyej ch'in otk bint cyu'n—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Bix e xi' tkba'n Jesús juntl wik yol cye xjal: —Jte Dios tcawbil ju'c'a tisen iyaj, ");
INSERT INTO mamNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","tisen oj ncu'x awet twitz iyaj tuj tx'otx' tu'n jun xjal. Tiẍtetltzen te xjal baj te tii'j, kale nwutan bix kale i'tz, pero te iyaj, ntz̈'iyte tjunal tu'nx tipemal. Ntz̈'iyte te k'ijl bix te koniyan. Mintii' te xjal tumel tuya ti tten ntz̈'iy awal. ");
INSERT INTO mamNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nejl njatz itz'j tuj tx'otx', bix njaw tz̈'iy tken, bix manc'biltzen n-ak' twitz. ");
INSERT INTO mamNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yal ojtzen ntzkij, bixsen ntzyet tchmoj, cuma otk pon tumel tu'n tjtx'et. Tisex ttenj iyaj njaw tz̈'iy tjunalx, ojxe tzin tk'o'n twitz, ju'xse ttenj tcawbil Dios njaw tz̈'iy tjunalx—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Bix at juntl tyol Jesús: —¿Titzen tten oj tel niy' ti'j ti tten tcawbil Dios, bix ti tten oj ttz̈'iy? ");
INSERT INTO mamNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ju'c'a tisen twitz jun wik itzaaj mostaza. Ja tzunj twitz mostaza jatzen jun iyaj mas xmutz' twitz cykilca twitz tiy'jil itzaaj ncu'x cyawa'n xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero junxse maj ncu'x awet, njaw tz̈'iy ojxe niy' tibaj t-xaak. Ma' nimxse, bix at maj nchi ocx najan ch'it tjak' tlequemal—tz̈i Jesús te techlal ka nejl nuk cab xjal toclel tjak' tcawbil Dios, yal mas yaj, mas nim xjal c'oquel. ");
INSERT INTO mamNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ju'tzen tten t-xnak'tzan Jesús tuya tyol yaa'n tzinenxix, la' jniy' ch'inxja yol el cyniy' xjal ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Min e t-xnak'tzaxin ke xjal tujxix tzinen, sino tuj ewjel ch'in tyolxin. Pero yaltzen cye t-xnak'atzxin, e xi'tzen tkba'nxin tej ya cyjunaltlxin ti tten juun yol min otk tz'el cyniy' ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tejtzen tak' cwel klolj texj k'ij, bix e xi' tkba'n Jesús cye t-xnak'atz: —Ko iy'x juntl jlajxe tnijabel a'—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bix e cyaj cycye'yenxin xjal ttzii' a', bix iy'xkexin tuj choc jaa' tcu'xa Jesús. Bix oc lpe juntl wik xjal cyi'jxin tuj juntl wik choc. ");
INSERT INTO mamNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pero lwewa e cub pok'ch naj jun jbal bix cyk'i'k cyibajxin. Nimxse oc punntz'aj a' tu'n cyk'i'k ti' choc. Bix ocx noj a' tuj choc, tejxe tak' xe'l tjak' a'. ");
INSERT INTO mamNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero yaltzen te Jesús, otk tzul twatlxin nka ttzii' tẍyo'p choc. Bix ocx cyc'asen t-xnak'atzxin jaxin. Tz̈i tzunkexin cyjulu: —¡Taat! ¿minmatii' toclena ki'j oj kxi' baj tjak' a'?—tz̈ikexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bix e jaw we' Jesús, bix e xi' tkba'nxin te cyk'i'k bix te tnijabel a': —¡C'ol! ¡We'!—tz̈i Jesús. Nwe'tlte cyk'i'k. Tzinexse e cyja'. ");
INSERT INTO mamNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tejtzen twe' cyk'i'k, bix e xi' tkba'n Jesús cye t-xnak'atz: —¿Tikentzen cutzen ttz̈i cyi'ja? ¿Mina'xpatzen toc ke cyc'u'ja ka ba'n cycleta tu'n Dios?—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero otkxsen cub kojl ttz̈i cyi'jxin, bix ak'kexin kanlecte tiy' cyeylexxin: —¿Altzen loj junxin xjal lu? Maj ma tbi a' bix cyk'i'k tyolxin—tz̈i ke t-xnak'atz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bix iy'pan bajkexin juntl jlaj tnijabel a', jaa' najla kej xjal aj tnom Gerasa tbi. ");
INSERT INTO mamNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tej tzunj tetz Jesús tuj choc, bix e xi' lk'e junxin xjal toc biman ti'j. Jatzen otk tz'etzenxin cyxol tjayel anem, ");
INSERT INTO mamNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","cuma jatzen najlaxin tuj camposant. Pero tij cyiw xsunxin. Min-al juntl ba'n tcub ẍpon texin, mitetpe tuya cadena. ");
INSERT INTO mamNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nimxse maj e cub ẍpet tkenxin bix tk'abxin tuya cadena, pero oj toc cye'yet-xin, otk baj ttzakaxin cadena. Min-al juntl ocx cye ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bix e bet-xin te k'ijl bix te koniyan cyxol witz bixsen tuj camposant. Ns̈-in tzunxin, bix n-ocxetzen tpjun tiibxin tuya xak. ");
INSERT INTO mamNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tej tzunj tak' twitzxin ti'j Jesús, bix e xi' ajkelxin tu'n tpon cananxin ti'j Jesús. Tpon tzunxin, bix e cub majexin twitz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Bix e xi' tkba'n Jesús te biman najl tuj tanem jxin xjal: —Xewbaj yuwin, ctetz tuj tanem xjala—tz̈i Jesús te biman. Bix ak' biman s̈-il twitz Jesús: —¿Titzen toclena wi'ja, Jesús, Tcwal nintzaj Dios? Mi'nxse chin baj tyajla'na, nuksamxse Dios—tz̈i biman te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bix e xi' tkanen Jesús te biman: —¿Ti tbiy?—tz̈i Jesús. Bix aj ttzak'be'n biman: —Nimxse nbiya, cuma nimxse kbeta najl tuj tanem jxjala—tz̈i biman. ");
INSERT INTO mamNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bix ak' biman kanl xtalbil te Jesús tu'n mi'n chi ex tlojo'n Jesús ke biman tuj cytx'otx' Gerasa. ");
INSERT INTO mamNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bix attzen jun witz nka ttzii' tnijabel a'. Bix attzen nimjil boch nchi waa'n tc'u'j witz. ");
INSERT INTO mamNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bix e xi' cykanen biman te Jesús: —Ko ttzakpi'cxa cyxol jil bocha, tu'ntzen kocxa tuj cyxumlaljil—tz̈i ke biman. ");
INSERT INTO mamNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bix e tcuya Jesús, bix etz ke biman tuj tanem jxin xjal, bix ocxke tuj cyxumlal boch. Tej tzunj cyocx biman tuj cyxumlal boch, bix e xi' ajkelkejil tc'u'j witz tu'n cycu'panjil tuj tnijabel a'. Bix e jaw jik'bakejil. Ca'ba mil jil boch e cyim. ");
INSERT INTO mamNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yal tzun kej xjal cylel boch, bix e xi' ok ke xjal tuj tnom bix tuj cojbil te kbalte ti otk baj cye boch. Bix e xi' baj ke xjal ttzii' a' te cyey'lte ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tej tzunj cypon xjal jaa' tcwa' Jesús, bix oc cycye'yen xjal jxin ocx najan ke biman tuj tanem, k'uklc'axin, toc ti'jxin, bix ba'ntl tzunxin, mintzen s̈-intlxin. Bix e jaw sey'paj ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bix alkch tzunj otk tz'oc cye'yente ti otk baj tuyaj xin xjal e najan biman tuj tanem bix ti e baj cye boch, bix ak'kexin kbalte te juntl wik. ");
INSERT INTO mamNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tejtzen tbaj cybi'n xjal, bix ak' ke xjal cubsal cywitz te Jesús tu'n texxin tuj cytanem xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tej tzunj tocx meltz'aj Jesús tuj choc juntl maj, ja tzunj xin xjal otk ten biman tuj tanem, bix oc tenxin cubsal twitzxin tu'n t-xi'xin tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero min e tcuya Jesús, bix e xi' tkba'nxin: —Cutxa tey cyxol t-xjala. K'umenxse cye ti xtse Dios jay, bix ti tten s-oc k'a'ben tc'u'jxin ti'ja—tz̈i Jesús tej xin xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bix aj jxin xjal, bix ak'xin kbalte tuj Gerasa bix t-xol juntl tnom tuj ja lugar Lajaj Tnom tbi ti otk temaxin tu'n Jesús, ka otk tz'el tlojo'n Jesús ke biman ti'jxin. Cykilcaxse xjal e jaw klee' ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tej tzunj tpon meltz'aj Jesús juntl maj tujx choc juntl jlajxe tnijabel a', bix oc chmet nim xjal ti'jxin ttzii' a'. ");
INSERT INTO mamNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Texse naj hora tej tpon junxin tawil c'ojlal jun camon jaa' te xnak'tzabl tyol Dios, Jairo tbixin. Tpontzen cananxin ti' Jesús, bix e xi' t-xoo'n tiibxin t-xee' tken Jesús, ");
INSERT INTO mamNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","bix nim oc tenxin cubsal twitzxin te Jesús. Tz̈i tzunxin cyjulu: —Ch'ix tel tanem jtxin nmeela te cablajaj jnabk'itxin. Quixta ch'in wuya, bix k'a'c'a ch'in tk'aba tibajtxin tu'n tul tnaabltxin bix tu'n titz'jtxin tu'n tipemala—tz̈itzen tawil c'ojlal camon jaa' te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bix e tcuya Jesús tu'n t-xi' tuyaxin. Tej tzunj cyxi'xin, nimxse xjal oc lpe cyi'jxin. Nimxse oc cutz'j Jesús cyu'n xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Cyxoltzen tnimal xjal e pona junxuj xuuj yaab. Otk bint cablajaj jnabk'i toclen we' cyak a' ti'jxuj. ");
INSERT INTO mamNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Otkxse tziy'xuj tuya nim k'anel, bix otkxse baj tpwakxuj, pero minxsetii' ch'in otk tz'oc tbinche. Mastlpe otk tzak' cwel bint-xuj. ");
INSERT INTO mamNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Cwatzen toc tbi'nxuj ka nim xjal n-ul tnaabl tu'n tipemal Jesús, bix otk pon Jesús tuj ttanemxuj, bix iy' tuj tc'u'jxuj: —Nuketle oj toc nmoco'n t-xbalenxin, ya tzultzen nnaabl—tz̈i tzunxuj. Bix ocx tcutz'en tiibxuj cyxol xjal tu'n toc tmoco'nxuj t-xbalen Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tej tzunj toc tmoco'nxuj Jesús, bix e we' tyabelxuj. Bi'xse e tna'xuj ka otk tzkij tyabelxuj. ");
INSERT INTO mamNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pero tej tzunj tel tniy' Jesús ti'j ka tu'n tipemalxin otk tzula tnaabl jun xjal, bix aj meltz'ajxin kanlte cye xjal: —¿Al ma tz'oc moconte nxbalen?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bix aj cytzak'be'n t-xnak'atz Jesús: —N-oc tcye'yena ka nim xjal n-oc cutz'ente tey. ¿Tikentzen n-oc tkanentla keya: “¿Al ma tz'oc moconte we?”—tz̈i ke t-xnak'atz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero bix oc ten Jesús cyey'lec cye xjal la' al otk tz'oc moconte texin. ");
INSERT INTO mamNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yal tzunj xuj xuuj, otk jaw lu'lenxuj tu'n ttz̈i, cuma otk tz'el tii'nxuj tipemal Jesús tuj ewjel. Bix e xi' lk'exuj twitz Jesús, bix e cub majexuj, bix e xi' tkba'nxuj tik'ch otk baj texuj. ");
INSERT INTO mamNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bix e xi' tkba'n Jesús texuj: —Xuuj, tu'nxse cykil tanema wi'j ma tzula tnaabla. Mi'n baj tc'u'ja. Cutxey tuj ttz̈yal, cuma ma tzul tnaabla—tz̈i Jesús texuj. ");
INSERT INTO mamNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nyolenxsete Jesús tuyaj xuj xuuj, tej cypon cab te tja jxin Jairo, bix e xi' cykba'n sanjel texin: —Ma cyim tmeela. Mi'ntzen tz'oc tentla yajlalte Xnak'tzal—tz̈ikexin te Jairo. ");
INSERT INTO mamNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero bix e tbi Jesús cyyolxin, bix e xi' tkba'nxin te tawil c'ojlal camon jaa': —Mi'n tzaj ttz̈i ti'ja. Kee'c tc'u'ja. Tzul tnaabl tmeela—tz̈i Jesús te Jairo. ");
INSERT INTO mamNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bix ak' pomel canaxin tja Jairo. Pero min e tcuya Jesús tu'n t-xi' lpe nim xjal. Nuk jac'a Pedro, Santiago, bix titz'en Santiago, Juan. O'cxse xinj e tcuya Jesús tu'n cyxi'. ");
INSERT INTO mamNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bix e ponkexin tja tawil. Tej tzunj cyponxin tja tawil, bix oc cycye'yenxin nim il nbaj, bix nchi ook' xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bix ocx Jesús tunwen, bix e xi' tkanenxin cye xjal: —¿Tikentzen nchi labaney? Min ma cyim tej txin cwala. Nuk nwutantxin—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero nuk oc cytze'n xjal tyol Jesús. Pero bix etz tlojo'n Jesús cykilca ke xjal pe'n. Bix ocx tii'n Jesús ke tman nee' bix ke t-xnak'atzxin jaa'j tocxa nee'. ");
INSERT INTO mamNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bix e tzaj ttzyu'n Jesús tk'ab jtxin cyimne, bix e xi' tkba'nxin te cyimne tuj cyyol xjal: —Txin ni' cwal, we'wey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tzinxix njaw we'tl naj tej txin cwal. Nak'tltxin betel. Bixse e jaw klee' cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bix e xi' tkba'n Jesús tu'n t-xi' twatxin. Pero cyiwtzen e xi' tkba'n Jesús tu'n min jaa' tz'oca cykba'n xjal ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bix el Jesús ttzii' tnijabel a', bix ajxin tuj ttanemxin Nazaret. Bix e xi'ke t-xnak'atzxin tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tej tzunj tul canan jmanc'bil k'ij tuj smant, jaj k'ij xjan cyxol xjal, bix ocxxin tuj camon jaa' te xnak'tzabl tyol Dios, bix ak'xin xnak'tzal xjal. Tej toc cybi'n xjal tyol Jesús, bix e jaw klee' ke xjal, bix ak'ke kanlecte tiy' cyeeylex: —¿Jaa'tzen ma tzaa' tcno'n jxjal lu jyola? ¿Tikentzen nimxse ba'n tu'n? ¿Bix jaa'tzen ma tzaa' tipemal te k'anl xjal? ");
INSERT INTO mamNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Yaa'mpatzen loja carpintero e ten tzalu, tal jxuj María, ttzicy Santiago, tuya José, Judas, bixse Simón? ¿Yaa'mpatzen najl ke taneb kxol tzalu?—tz̈i cab xjal te cabtl. Ju' tzunj min ocxix cybi'n xjal aj Nazaret tyol Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pero bix aj ttzak'be'n Jesús cye xjal: —Jaa'xja tumel n-oc ocslette tyolel Dios. Pero yal jaa' najlaxin, mintii' tilelxin cye te tjaxin bix cye te ttanemxin—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mintii'xix e bint tu'nxin, cuma min oc cybi'n aj Nazaret jaxin. Nuk jaa'x e cwa' tk'o'nxin tk'abxin tibaj juun xjal tu'n cyoc k'anet. ");
INSERT INTO mamNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bix e jaw klee' ch'in Jesús, cuma min e cybi xjal jaxin. Bix e xi' Jesús betel cyuj ni' coc' tnom ttxa'nxin nin tnom, bix nxnak'tzanxexin xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Attzen jun k'ij, bix oc tchmo'nxin jcablajaj t-xnak'atzxin. Bix ak'xin smalxcye ca'cab cybet te xnak'tzal cyuj jun wikxitl tnom. Bix e xi' tk'o'n Jesús cyipemal tu'n tel cylojo'nxin biman cyi' xjal. Bix ak' Jesús kbalxte ti chi temela tuj be. ");
INSERT INTO mamNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bix e xi' tkba'nxin: —Mintii'xix cxe'l cyii'na tuj be, sino nuk juun cybardóna te juun, bix mintii' pwak bix cyway t-xi' cyii'na, bix mi'n txi' cyii'na cypay. ");
INSERT INTO mamNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ba'n toc cyxaaba. Pero mi'n txi' cyii'na cych'ixpubla. ");
INSERT INTO mamNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bix oj cyocxa tuj jun jaa', jaxse chi temelaja ojxe cyi'ya. ");
INSERT INTO mamNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Katzen at jaa' min ẍi cmetey bix min ẍi oc ebi'na, cytz̈toncjtzen kuk ti' cyxaaba cywitz tetzen yec'bil ka ejee'xtl xjal cyey'l cyiib twitz Dios bix ka mintii'tl cyoclena cye xjal, bix chi ela—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Entonces bix ex ke t-xnak'atz Jesús te kbalte tu'n cymeltz'aj xjal tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bix el cylojo'nxin nim biman cyi' xjal, bix oc cyk'a'nexin nim yabel, n-ocxetzen cysu'nxin aseyt, ta'l jun wik lo'pj olivo tbi, cyi' xjal te techel ka tu'n tul cynaabl xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bix e tbi jxin Herodes, cawel cyibaj cykil tnom tuj Galilea, ti toc cyyol xjal ti'j Jesús, cuma otkxse tz'el tpocbalxin. E'latzen tuj twitz juun xjal ka ja Jesús jxin Juan Bautista. Tz̈i tzun kej xjala cyjulu: —Ma jatz itz'j Juan Bautista juntl maj tuj tx'otx'. Ju' tzunj at nim tipemal—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","At cabtlxin e kbante: —¿Al tzunj Jesús? Ja loj jxin Elías, tchak'el Dios e ten nejl ma cu'tz meltz'aj tuj cya'j—tz̈i tzunkexin. Bix cabtl xjal e kbante: —Jesús jatzen xinja juntl wikxin tyolel Dios e ten nejl—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero tejtzen toc tbi'n Herodes nbaj yol ju'wa, tz̈i tzunxin cyjulu: —Min. Ja te Juanja. Inayena e nkbante tu'n tel tx'omet twi' Juan. Yaltzen ja'lewe, matzen jatz itz'jtlxin—tz̈i Herodes. ");
INSERT INTO mamNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Tz̈itzen Herodes ju'wa, cuma yaa'ntzen ti otk baj nejl. Otktzen tz'el tiken Herodes t-xu'l Felipe, titz'en Herodes, Herodías tbixuj. Pero tejtzen toc tbi'n Juan Bautista, bix e xi' tkba'nxin te Herodes: —Yaa'n tumel toc t-xu'lena t-xu'l titz'ena—tz̈i Juan te cawel. Ju' tzunj e tzyeta Juan tu'n Herodes tu'n tocxxin tuj tzee', bix ocx ẍpet-xin tuya cadena. Tu'n tzunj xuj Herodías ocxe Juan tuj tzee', cuma nk'ojlec tzunxuj ti' Juan. ");
INSERT INTO mamNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","E tajbe tzunj xuj Herodías tu'n tcub byet Juan, pero min e tcuya Herodes, ");
INSERT INTO mamNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","cuma at ttz̈i Juan ti'jxin, cuma ttzki'n Herodes ka ba'n xjalte Juan bix at tajwalelxin tu'n Dios te yolel twitz tx'otx'. Bix oc tclo'nxin ja Juan. At maj e yolen Herodes tuya Juan. Pero cab tc'u'jxin tyolenxin tuya Juan, cuma e tajbexin yolenxin nim tuya Juan, pero tu'n tcuyan texin tyol Juan, min. ");
INSERT INTO mamNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero attzen jun k'ij toc tcye'yen Herodías ya tumeltzen tu'n tbyet Juan. Yaa'ntzen ti e baj. Tjapantzen baj Herodes twi' juntl jnabk'i tchunk'lalxin, bix iy' tiy'sa'nxin jun nink'ij cyuya tawil tc'ojlalxin, bix ke tcab cawel ttxlajxin, bix ke nintzaj xjal tuj Galilea. ");
INSERT INTO mamNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tuj tzunja nink'ij, bix ocx jtxin tal Herodías bixel. Ba'nxse e'la bixentxin tuj twitz tcab tmantxin, Herodes, bix tuj cywitz niy'tl xjal nchi waa'n tuya Herodes. Ju' tzunj e xa' tkba'nxin cyjulu: —Kanentz we ti taja. Jac'a txi' nk'o'nwe. ");
INSERT INTO mamNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Seya niy'janj ttx'otx' Galilea ma tzaj tkanena we, jac'a txi' nk'o'n tey—tz̈i Herodes te tal Herodías. ");
INSERT INTO mamNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bix etztxin te kanlte te ttxutxin: —¿Ti cxe'l nkanen?—tz̈i tzuntxin. Pero ya otktzen tc'olba tumel tuj twitz Herodías, bixse aj ttzak'be'nxuj te talxuj: —Kanenx twi' Juan Bautista—tz̈i Herodías. ");
INSERT INTO mamNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bix ocx ajkeltxin jaa' tocxexin cawel, bix e xi' tkba'ntxin: —Waj tu'n ttzaj tk'o'n naja twi' Juan Bautista we tuj jun lak—tz̈i tzuntxin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bix e jaw bisen cawel, pero cuma ya otk txi' toyenxin tetxin cywitz ttxocanxin, ya mix e cwa' tch'ixbe'nxin tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ju' tzunj e xa' tchk'o'n cawel junxin aj k'oj tuj tzee' te k'ilbel twi' Juan. ");
INSERT INTO mamNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bix e xi' aj k'oj, bix el ttx'omanxin twi' Juan, bix e pon tii'nxin tuj jun lak. Bix e xi' tk'o'nxin tetxin, bix e xi' tk'o'ntltxin te ttxutxin te yec'bil ka otk cyim Juan. ");
INSERT INTO mamNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tejtzen toc cybi'n kej xjal lepche ti' tyol Juan, bix e ponkexin k'ilbetz t-xumlal Juan te mukbil. ");
INSERT INTO mamNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Entonces tejtzen cypon meltz'aj jcablajajxin sma'n tu'n Jesús te xnaktz'al jaa'j ta'xin, bix ak'kexin kbalte te Jesús tik'ch otk baj cyexin bix tik'ch otk baj cyxnak'tzanxin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bix e xi' tkba'n Jesús cyexin: —Ko'ke ajlal kjunalx tuj jun lugar tuj ttz̈yal—tz̈i Jesús, cuma txolen cypon xjal bix xi'nax cyxi' xjal. Mitetpe e binttl cywaa'nxin tu'n nimxse xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bix ocx Jesús cyuya t-xnak'atz tuj jun choc tu'n cyiy'xxin tuj jun chk'ajlaj jaa' min-ala xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero nim xjal oc cye'yente cyexin tej cyiy'xxin. Tej tzunj toc cycye'yen xjal, bix e xi' baj ke xjal cyuj tnom tu'n cypon xjal jaa'j cypomlel Jesús. Bix e pon ke xjal nejl twitz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tej tzunj cypon Jesús, bix oc tcye'yenxin nimxse xjal. Bix oc k'a'ben tc'u'j Jesús cyi' xjal, cuma tisen jun cloj carnel min-al cycylel. Bix ak' Jesús xnak'tzal cye xjal ti' tik'ch jilel. ");
INSERT INTO mamNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tetzen kale, bix oc lk'e ke t-xnak'atz Jesús ti'j, bix e xi' cykba'nxin: —Ya kaletltzen, bix tzalu mintii'xse ba'n tcnet. ");
INSERT INTO mamNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bajsanc'atzen twi' t-xnak'atza cyuya xjal tu'n cyxi' lok'ol cywa tuj kej coc' tnoma—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero bix aj ttzak'be'n Jesús: —Ejee' cyey cyk'onx cywa xjal—tz̈i Jesús. Bix aj cytzak'be'n t-xnak'atzxin: —¿Tipa ttena ko xe'l tzuna lok'ol nim pan? Atetle twi' tc'u'j jun xjal te jun jnabk'i, la'tzen ka canan te twi' pan—tz̈ikexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Pero bix aj ttzak'be'n Jesús: —Jte' pan k'i'n cyu'na. Cyjya'x—tz̈i Jesús. Tej tzunj tbaj cyjyo'nxin, bix e xi' cykba'nxin te Jesús: —Ma cnet jwe' pan ku'na bix ca'ba quis̈—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bix e xi' tkba'n Jesús tu'n cycub ke xjal tibaj ẍk'ilen c'ul tuj chk'ajlaj. ");
INSERT INTO mamNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bix e cub ke ke xjal tuj tclojan te syent bix te cya'wnak tuya lajaj. ");
INSERT INTO mamNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tejtzen tbint cyten xjal, bix e tzaj ttzyu'n Jesús jjwe' pan bix xsunj ca'ba quis̈. Ncye'yen xsunxin tuj cya'j, t-xi' tkanenxin chjonte te Dios ti' cywaxin. Bix ak' Jesús pa'lc'ate pan te ke t-xnak'atzxin tu'n t-xi' cypa'nxin cye xjal. Mixe jun e jatz baj pan tuj tcublel, cuma otk txi' tz̈'iy tken pan. Bix ju'x tchu'l quis̈. ");
INSERT INTO mamNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bix cykiltzen e waa'n tejxe tnoj cyc'u'j. ");
INSERT INTO mamNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Cybajtzen waa'n xjal, e cyajx cablajaj chi'l pan bix quis̈. ");
INSERT INTO mamNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Atle jwe' mil xjal xinak e waa'n. ");
INSERT INTO mamNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tbaj tzunj ju'wa, bix e xi' tkba'n Jesús cye t-xnak'atz tu'n cycu'xxin tuj choc juntl maj nejltzen twitz Jesús tu'n cyiy'paxin jlajxitl a' tuj jun tnom Betsaida tbi. Bix iy'xkexin, ncyajtltzente Jesús te bajsalca twi' tyol cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tej tzunj tpon baj tyolxin cyuya xjal, bix e jax Jesús twi' jun witz te yolel tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tcubtzen klolj, nyolentzente Jesús tuya Dios twi' witz, bix ete'tl t-xnak'atzxin tmij a' tuj choc. ");
INSERT INTO mamNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bix oc tcye'yen Jesús ka cyiw tkitj choc tuj a', cuma ju' ntzaj cyk'i'k jaa' xa'ninakexin. Te ch'itk cyskixxin, bix e xi' bet Jesús tibaj a' tu'n tpon cyi'jxin. Cwa tpon canan Jesús cytxlajxin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tej tzunj toc cycye'yenxin, e'la tuj cywitzxin ka jun t-xlenel biman nbet tibaj a', bix e jaw sey'pajkexin, bix ak'kexin s̈-il. ");
INSERT INTO mamNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yaa'n nuk junxin oc cye'yente, sino cykilcakexin oc cye'yente. Pero bix e xi' yolen Jesús cyi'jxin: —¡Cyiwx chi oqueley! Inayen weja. Mi'n tzaj ttz̈i cyi'ja—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bix e cu'xxin tuj choc, bix jax n-aj lk'etlte cyk'i'k. Bi'xse e jaw klee' ke t-xnak'atz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Amale otket tz'oc cycye'yenxin ti otk tse Jesús kej pan, mitkx n-e'la cyniy'xin ti'j ka cykil ba'n tu'n Jesús. Klolj tuj cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cwa cyponxin tuj ttx'otx' Genesaret, jaa' oca cyẍpo'nxin cychocxin ttzii' a'. ");
INSERT INTO mamNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tzinxix nchi cu'tzxin tuj choc el naj cyniy' xjal ti'j ka ja Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tejtzen toc cycye'yen xjal jaxin, bix ex ke xjal kbalte cykil tuj tnom bix tuj cojbil. Bix ak' xe'l cyii'n xjal ke yaab twitz wetbil twitz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tisexse e baj tzalu, ju'xse e baj tuj juntl wik tnom jaa' oca Jesús. Nuk jak'ch e cwa cyk'o'n xjal ke yaab tuj be n-ocxetzen cycubsa'n xjal cywitz te Jesús tu'n tcuyan texin tu'n toc cymoco'n yaab, amatle nuk tziy' ajx ch'in cyk'ab ti' t-xbalena. Bix aljxe xjal oc moconte texin, ul cynaabl. ");
INSERT INTO mamNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Attzen jun k'ij, bix e pon kej xjal nimalxsen tuj ley, ejee'j xjal tej cloj fariseo, tuya cabxin tx'olbal ley. Otk chi tzajxexin maan Jerusalén. Bix e ponkexin ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Toctzen cycye'yenxin nchi waa'n t-xnak'atz Jesús min otk txjet cyk'abxin tisexix tten cyu'n fariseo, bix el ka'yba tuj cywitzxin, cuma e'latzen tuj cywitz fariseo otk chi chucj t-xnak'atz Jesús twitz Dios, ");
INSERT INTO mamNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","cuma kej xjal judío lepchxke cye xjal ti'j jun ley te nejl ka tu'n mixbe cywaa'n xjal ka mitkx n-e'la txjet cyk'ab tisexix tten. ");
INSERT INTO mamNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jaxse ju'xe, oj nchi ul meltz'aj lok'ol tuj plasen, jax n-el cytxjo'n cyk'ab tisex tten. Bix yaa'n o'cxc'aj, sino atl nim cyley xjal, tisen txjoj cylak, ke xaran, ke wicy'il, ke los, bix ke wetbil tisex tten cyu'n xjal judío nimal tuj cyley fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ju' tzunj, tej toc cycye'yen ke fariseo bix ke tx'olbal ley min otk txjet cyk'ab t-xnak'atz Jesús tisen cyexin cyten, ya otktzen chi chucjxin tuj cywitz fariseo. Bix e xi' cykba'n te Jesús: —¿Tikentzen min chi waa'n tey t-xnak'atz tisen kej xjal ootxa? Nchi waa'n tey t-xnak'atz bix chucjninke twitz Dios—tz̈i tzunkexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pero bix aj ttzak'be'n Jesús: —Jaxne toc tyol Isaías, tyolel Dios, tej tcyaj ttz'i'benxin jtyol Dios cyi'j xmeletz' cytzi tisej cyey. Tz̈itzen Dios cyjulu, tz̈i Isaías: “Kej xjal lu tzin chi na'n Dios nim tuya cytzi, perotzen cyanem nakch ta' wi'j. ");
INSERT INTO mamNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mintii' ba'n tajbe'na ncub cychmon cyiib te na'l weya. Bix xnak'tzben cye yaa'n wu'na, sino nuk cyu'nx,” tz̈i Dios, tz̈i Isaías tcyajlen ttz'i'ben. ");
INSERT INTO mamNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Cuma cyey, nuk n-el cyiiq'uena jtzin tkba'n Dios tu'n cyxi' lpey ti'j cyley xjal nejl. ");
INSERT INTO mamNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cytzki'nxix cyey ti tten oj n-aj cylak'ba'na tyol Dios tu'n toc cyc'ojla'na jcyey cyleya. ");
INSERT INTO mamNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tisen tzunj: Ma tz'aj cylak'ba'na jtyol Moisés tej tkbantexin: “Ebimc'a tmana bix ttxuy,” bix “Al tzunj ma tz'el xoo'nte tman bix ttxu, bi'xse cbyetel naj cyu'n xjal,” tz̈i Moisés cye xjal nejl. ");
INSERT INTO mamNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero yaltzen cyey, ba'ntzen t-xi' tkba'n jun xjal te tman bix te ttxu: “Mlay tz'oc wonen wey, cuma alcyej ch'intl ma cyaj cxe'l oyette te Dios.” ");
INSERT INTO mamNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ju' tzunj al tzunj taj tz'oc onente cye tman tuya pwak, mlaytltzen, cuma mintzen tcuyantl cyleya. ");
INSERT INTO mamNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ju'tzen tten ncub cybajsa'na tyol Dios tuya cyleya. Bix nimxtl nbaj cyey tisex jluwe—tz̈i Jesús cye tx'olbal ley bix cyej xjal nimal tuj cyley. ");
INSERT INTO mamNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yajc'atltzen bix e ttxoc Jesús ke xjal, bix e xi' tkba'nxin: —Chin cybi'tzen, bix cybimquey. ");
INSERT INTO mamNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Mintii'te jun ti jilel c'oquex tuj ttzi jun xjal cchucjalet tu'n, sino ja tej ctzaal ti' tanem xjal, jatzente cchucjal twitz Dios—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tcyajtzen tcye'yen Jesús ke xjal, bix ocxxin tuj jun jaa'. Bix e xi' cykanen t-xnak'atzxin ti elpenina jtyolxin cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Bix e xi' tkba'n Jesús: —Jax ju'x cyey, ¿mimpatzen ma tz'el cyni'ya ti'j? ¿Mimpatzen ma tz'el cyni'ya ti'j ka ti jilel ma tz'ocx tuj ttzi jun xjal, mi'n chucjte twitz Dios? ");
INSERT INTO mamNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mi'n chucjte xjal, cuma mi'n txi' tuj tanem, sino ju' cxe'lte tuj tc'u'j, tu'n tiy' tc'u'n. Mintii' jun waabj ba'n tchucj jun xjal tu'n. ");
INSERT INTO mamNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ja tej ctzaal ti' tanem xjal, jatzen te ja ctz'ilex xjal tu'n twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Cuma tujxe tanem xjal ntzaa' itz'j tka'yel, tisej kej xjal nuk xinak ma nuk xuuj n-oc tak' cye, alk'al, biy'yen, ");
INSERT INTO mamNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pajlel, k'abj tik'ch te xjal, cyak wisaj xjal, yajlaj xjal, loch' c'u'jbaj, xchi'len c'u'jbaj, ka' yol ti' xjal, n-oc tk'on tiib jun xjal te jawnex, bix mintii' tc'u'j ti' juntl xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Cykil tzunj tka'yel lu ntzaj tuj cyanem xjal. Cyu'n tzunj lu ntz'ilaxe xjal twitz Dios—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bix e xi' Jesús tuj jun wikxitl tnom, Tiro tbi. Bix ocxxin tuj jun jaa'. E tajbexin tu'n min-al xjal tz'oc cye'yente texin, pero mix e bina tewexin. ");
INSERT INTO mamNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lwewatzen naj e tbi junxuj xuuj, ttxu juntxin cwal otk tz'oc biman ti'j, ka otk pon jlet Jesús. Bix e xi'xuj, bix e cub majexuj twitz tken Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pero yaa'n judíaxuj, sino tej tnom Fenicia tej nin tnom Siria, ttxlaj Galilea te jawne. Bix ak'xuj cubsal twitzxuj twitz Jesús tu'n tel tlojo'nxin biman ti' talxuj. ");
INSERT INTO mamNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero bix aj ttzak'be'n Jesús texuj: —Tneel chi oquel ncye'yen weja weya nxjal aj judío. Yaa'n tumel oj tel k'i'n cywa nee' tu'n t-xi' k'o'n cye txyan. Nejl chi waa'l ke nee'—tz̈i Jesús texuj te niy'bel tnaablxuj. ");
INSERT INTO mamNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero bix aj ttzak'be'n jxuj xuuj: —Jax toc tu'na, Taat. Pero tzintlpe cyyo'n cyej jil txyan jniy' q'uelel tz'ak ttx'akan cywa nee'. Jaxse ju'x weya cnyo'wa la' niy' chin tzaal tonena—tz̈i tzunxuj. ");
INSERT INTO mamNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Bix aj ttzak'be'n Jesús: —Ma bint ttzak'bentey nyol. Ba'ntzen taja tjay. Ya ma tz'el biman ti' tala—tz̈i Jesús texuj. ");
INSERT INTO mamNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tejtzen tponxuj tjaxuj, tjax talxuj twi' wetbil, pero ya otk tz'el biman ti' talxuj. ");
INSERT INTO mamNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bix etz meltz'aj Jesús tuj tnom te Tiro, iy'xin tuj tnom te Sidón, bix iy'xin cyuj tnom te Lajaj Tnom, cwa tponxin ttzii' tnijabel a' te Galilea. ");
INSERT INTO mamNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tej tzunj tponxin, bix e pon cyii'n xjal jun yaab min tziy'x tuj twi' bix makma. Bix e xi' cykanen xjal tu'n tcub tk'o'n Jesús tk'ab tibaj yaab. ");
INSERT INTO mamNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Bix el lk'e Jesús tuya yaab cyi'j xjal otk jaw chmet, bix ocx tk'o'n Jesús ke twi' tk'ab cyuj tẍquin yaab. Bix oc ttzubanxin ti' tk'abxin, bix oc tmoco'nxin twi' taak' yaab. ");
INSERT INTO mamNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Njawtzen tcye'yen Jesús twitz cya'j, bix e jaw jawsanxin, bixse e xi' tkba'nxin tej xjal yaab: —Jkomtzen tiiba—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Texse naj tjket tẍquin yaab, bix ncyajtl taak' ba'n. N-ak'tltzen yaab yolel. ");
INSERT INTO mamNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bix e xi' tkba'n Jesús cye xjal tu'n mi'n txi' cykba'n ti otk baj te Jesús tuya yaab. Pero amale otket txi' tkba'n Jesús cye xjal tu'n mi'n txi' cykba'n, ilx ti'j e cub ten ke xjal kbalte. ");
INSERT INTO mamNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Otkxse chi jaw klee' xjal, bix e xi' cyyolen: —¡Cykilxse ba'n tbint tu'n Jesús! Hasta kej xjal min tziy'x tuj cywi' bix xsun kej me, ba'n tbint cyyolen tu'n—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Attzen jun k'ij, bix oc cychmon cyiib nim xjal ti' Jesús juntl maj. Mintzentii' cywa xjal. Bixse e tzaj ttxco'nxin ke t-xnak'atzxin, bix e xi' tkba'n Jesús cyexin: ");
INSERT INTO mamNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ma tz'oc k'a'ben nc'u'ja cyi'j xjala, cuma ma bint oxe k'ij cyten wuya tzalu, bix mintzentii'tl cywa. ");
INSERT INTO mamNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ka ma chi aj nsma'n cyja mitkx nchi waa'na, tzul tuj cywitz tu'n weyaj, cuma at juun cye tzajninxe nakch—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bix aj cytzak'be'n t-xnak'atz Jesús: —¿Pero titzen tten oj t-xi' kk'o'n cywa jxjala tzalu? Min-al xjal najl tzalu—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pero bix aj tkanen Jesús: —¿Jte' pan k'i'n cyu'na?—tz̈i Jesús. —Wuuk k'i'n ku'na—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bixse e xi' tkba'n Jesús tu'n cycub ke cykil xjal twitz tx'otx'. Bixse e tzaj ttzyu'nxin jwuuk pan, bix e xi' tkanenxin t-xtalbil Dios cyi'j. Bixse e cub tpa'nxin, bix e xi' tk'o'nxin cye t-xnak'atzxin tu'ntzen t-xi' cypa'nxin cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bix jax k'i'n cabjil quis̈ cyu'nxin. Jax ju'xe bix e xi' tkanen Jesús t-xtalbil Dios cyi'jjil, bix e xi' tkba'n Jesús tu'n t-xi' cypa'n t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Cykilca xjal e waa'n tejxe cynoj. Cybajtzen waa'n xjal, e cyajxtl wuuk chi'ltl piẍ pan. ");
INSERT INTO mamNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cykilca kej xjal e waa'n atle cyaja mil. Bixsen e k'olben Jesús cye xjal, ");
INSERT INTO mamNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","n-ocxtl tzunxin tuj choc cyuya t-xnak'atzxin, bixse e xi'xin tuj jun tnom Dalmanuta tbi. ");
INSERT INTO mamNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Cypon tzunj xjal nimalxse tuj cyley, ejee'j xjal tej cloj fariseo, bix ak'kexin rasonel tuya Jesús. Bix e xi' cykanenxin te Jesús tu'n t-xi' tyeec'an Jesús tipemal cyexin tu'ntzen tchic'ajax ka ju' otk tzaj Jesús tuya Dios. E'la tuj cywitzxin ka tu'n tcub tz'ak Jesús tuj cyyolxin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bi'xse e jaw jawsen tc'u'jxin, cuma ete'c fariseo yajlal texin. Bix e xi' tkba'n Jesús: —¿Tikentzen ete'c'a xjal kanl te weya tu'n t-xi' nyeec'ana wipemala? Nuktzen ti cyaja tu'n ncub tz'aka. Tzinenxix cxe'l nkba'n cyey mintii' tu'n t-xi' nyeec'an wipemal—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bix e cyaj tcye'yen Jesús ejee'xin, bix ocx meltz'ajxin tuj barc cyuya t-xnak'atz, bix iy'x meltz'ajxin juntl jlaj tnijabel a'. ");
INSERT INTO mamNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pero otktzen tz'el cywaxin tuj cyc'u'j t-xnak'atzxin. Nukxix jun pan k'i'n cyu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Toctzen tbi'n Jesús nchi yolen t-xnak'atzxin ti' pan, bix e xi' tkba'n Jesús: —Nchi yolena ti' pan, cyc'ojlam cyiiba tuyaj cypan fariseo bix xsunj tpan jxin cawel Herodes—tz̈i Jesús cye t-xnak'atz. Pero yaa'ntzen nyolen texin ti' pan, sino nxi'tzen tkba'nxin tu'n mi'n txi' cybi'n t-xnak'atzxin jcyxnak'atz fariseo bix jte Herodes. ");
INSERT INTO mamNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pero mintzen el cyniy' t-xnak'atzxin ti'j ti elpeninatzen tyol Jesús. Tuj cywitzxin tu'n toc cyc'u'jxin ti' lk'oj pan. ");
INSERT INTO mamNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Bix el tniy' Jesús ti'j ti otk tz'e'la tyolxin tuj cywitz t-xnak'atzxin, bix e xi' tkba'nxin: —¿Tikentzen n-e'la tuj cywitza ka mintii' cypana? ¿Mimpatzen tz'el cyni'ya ti'j yaa'n ti' pan nchin yolenawe? ¿Junxpatzen maj klolj tuj cywitza? ");
INSERT INTO mamNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ju'c'a ke cyey tise kej xjal at tbak' cywitz, pero mintey' n-ak' cywitz ti'j, bix at cyẍquin, pero mintey' n-el cyniy' ti'j. Yal tzunj pan tzin cyyolena, ¿tikentzen n-oca tak' cyey? ¿Mimpatzen tzul tuj cyc'u'ja ti in se nejl? ");
INSERT INTO mamNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tej tcub npa'n jjwe' pan t-xol jwe' mil xinak, ¿jte' chi'l piẍ pan e jaw cychmo'na tej cybaj waa'n xjal?—tz̈i Jesús. Bix aj cytzak'be'nxin: —Cablajaj chi'l, Taat—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bix e xi' tkanen Jesús juntl maj: —Yaj tzunj tej tcub npa'n jwuuk pan t-xol jcyaja mil xjal, ¿jte' chi'l pan e cyaj?—tz̈i Jesús. Bix aj cytzak'be'nxin: —Jax wuuktl chi'l—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Entonces bixse aj tkba'n Jesús: —Jeyney, jayaxittzen mix n-e'la cyni'ya ti'j ka cykil ba'n tbint wu'na—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Cwatzen cyponxin tuj tnom te Betsaida, jlajxe tnijabel a', bix e pon cyii'n xjal jun xjal mos̈. Bix oc cycubsa'n xjal cywitz te Jesús tu'n toc tmoco'n Jesús jxjal mos̈. ");
INSERT INTO mamNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bix e tzaj ttzyu'n Jesús tk'ab mos̈, bix ex tii'nxin yaab ttxa'nxe tnom. Bix ocx tk'o'n Jesús ta'l ttzi tuj twitz mos̈. Tcubtzen tk'o'n Jesús tk'ab tibaj mos̈, bix e xi' tkanenxin: —¿Atpa ch'in ma tzak' twitza ti'j?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bix ak' mos̈ cyeyel tiy' ttxlaj, bix aj ttzak'be'n jxin mos̈: —At ch'in chic'aj. Lu ke xjal nchi oc ncye'yen tise jun tzee', bix nchi bet—tz̈i tzunxin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bix oc tmoco'n Jesús tbak' twitzxin juntl maj. Bix cyiw e cub tse'n mos̈ twitz, bi'xse ul tnaabl tbak' twitzxin. Ya ba'ntzen ak'tl twitzxin ti' tik'ch jilel. ");
INSERT INTO mamNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bix e xi' tkba'n Jesús texin: —Ba'ntzen taja tjay. Pero cutxetzen jiquen tjay. Mi'ntzen tzi'ya tuj tnom bix min jaa' tz'oca tkba'na—tz̈i Jesús texin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tbajlenxitl tzunj ja lu, bix e xi' Jesús cyuya t-xnak'atz cyuj ke ni' coc' tnom ttxa'n nin tnom te Cesarea Filipo. Tujtzen be e xa' tkanen Jesús cye t-xnak'atz: —¿Alcye ken tuj cywitz xjal?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bix aj cytzak'be'n t-xnak'atzxin: —At xjal nkbante ka jay Juan Bautista. At juntl wik nkbante ka jay Elías, tulel nejl twitzj xin Scy'o'n tu'n Dios. Bix at juntl wik xjal nkbante ka jay jun wikxitl tyolel Dios e ten nejl—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bix aj tkanen Jesús: —Yajtzen cyey, ¿altzen cye ken tuj cywitza?—tz̈i Jesús. Bix aj ttzak'be'n jxin Pedro, t-xnak'atz Jesús: —Ja te ja Scy'o'n tu'n Dios, jaj xin tulel tsma'n Dios te cawel tibaj Israel, jxin e byan tu'n Dios jatxe tuj tneel—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero e xi' tkba'n Jesús cye t-xnak'atz tu'n min jaa' tz'oca cykba'nxin ka jaxin cawel tibaj Israel. ");
INSERT INTO mamNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bixse ak' Jesús xnak'tzalec cyexin ka jxin Sma'n tu'n Dios tu'n tten cyuya xjal q'uiyalxse a' tc'u'jxin, bix q'uelel xoo'nxin cyu'n nintzaj xjal tuj tja Dios, cyu'n tawil na'l Dios, bix cyu'n tx'olbal ley. Bixse e tkbaxin ka cbyetelxin, bix cjawetz itz'jxin te toxen k'ij tbyetlenxitlxin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Bix e cyaj tk'o'nxin kej yol lu tuj tzinen. Pero min el tyol Jesús ba'n tuj twitz Pedro. Bix ex ttxco'nxin ja Jesús cyjunalxin, bix ak' Pedro ocsalec tc'u'j Jesús tu'n mi'n tyolexin ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tejtzen toc tbi'n Jesús tyol Pedro, bix aj tcye'yenxin cykilcatl ke t-xnak'atzxin, bix oc yokpajxin ti' Pedro: —Pedro, ti'j tyola ju'wa, ju'x tuj cywitz xjala, pero tuj twitz Dios, min. Ja te Satanás, tawil biman, n-oc lmonte tey. Tcy'i Satanás chin japan baj ti'j ti waj ma chin tzaj twitz tx'otx'. Ti'j tzunj tyola tu'n mi'n chin cyim, attzen tyola tuya tawil biman, yaa'n tuya Dios—tz̈i Jesús te Pedro cywitz niy'tl t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yajc'atltzen bix e tzaj ttxco'n Jesús ke t-xnak'atz bix juntl wik xjal, bix e xi' tkba'nxin cye: —Al cyey taj tz'oc lpe wi'j, cyk'oncjtzen tik'ch cyaja, tuyaxe cychunk'lala cyimal tuj cyc'u'ja. Ka at-xix il ti'j tu'n cyoca tuj q'uixc'aj nuk wi'jc'a, cyk'onxsen cyiiba. Bix ka ma chi el xoo'na cyu'n xjal nuk wi'jc'a, cyxoo'xixsen cyiiba. Bix katzen at-xix il ti'j, bixse t-xi' cyk'on cyiiba te cyamecy, tisej weya twitz cruz chin byetela. ");
INSERT INTO mamNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Al tzunj ma bint tu'n ju'wa, chi lpebaltzen wi'j, cyk'a' tzuna cychunk'lala nuk wi'jc'a bix nuk ti' nyol tu'n cyclet xjal tuj il, ka ma bint cyu'na ju'wa, attzen cychunk'lala. Pero alj tcy'i cyim nuk wi'jc'a, nuk tchunk'lal n-oc tak' te, ja tzunj cxe'l tz'ak. ");
INSERT INTO mamNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ti c'ajbela cykilca twitz tx'otx' te jun xjal oj t-xcye ti'j ka otk txi' t-xoo'n tchunk'lal nuk tu'n ttzyet tu'n? ");
INSERT INTO mamNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Bix ma jte'tzen ctchja' jun xjal twi' tchunk'lal ka o txi' t-xoo'n, nuket jac'a tlok' juntl maj? Cuma at mas twi' tanem jun xjal twitz cykilca twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Alj ma tz'el ch'ixwe wi'j bix ti' nyol cywitz xjal nakch ete' wi'j bix cywitz aj il, jaxse ju'x inayena, jxjal Sma'n tu'n Dios, q'ueleltzen ch'ixwexe ti'j oj tul meltz'ajxin juntl maj twitz tx'otx' tuya nimxsen tajwalelxin tu'n Tmanxin Dios, bix tzinxse ntxakakanxin, bix cyuyax xjan tsanjel Dios tuj cya'j—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bix jax e xi' tkba'n Jesús: —Cxe'lxix nkba'n cyey ka at juun cyey tcub tzalu mi'n cyim ojxe toc cycye'yena techel ti tten tipemal tcawbil Dios—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Eltzen wukak k'ij, bix e xi' Jesús twi' jun nim witz. Nuktzen ja Pedro, tuya Santiago, bixse Juan e xi' tii'nxin tuyaxin. Cywitz tzunxin tej tcub meltz'aj tcye'yenc Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yalxse t-xbalen Jesús tzinxse ntxakakan, masxse sak otk tz'oca tilbil twitz oj tey'x tbaj txjet jun ti jilel. ");
INSERT INTO mamNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bix tujx naj toc cycye'yenxin nyolen Jesús tuya Elías bix Moisés, ca'ba ktzan tyolel Dios nejl. ");
INSERT INTO mamNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bix e xi' tkba'n Pedro te Jesús: —Xnak'tzal, axse tbanel jlu ko' eto' tzalu. Cjaweltzen kbincha'n oxe ni' pach, juntzen tey, juntltzen te Moisés, bixse juntl te te Elías—tz̈itzen Pedro te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yaa'ntzen tii' e xa' tkba'n Pedro jcyjulu, cuma otkxse chi jaw sey'pajxin. Ya mintii'tl ul tuj tc'u'j Pedro tu'n ti t-xi'lel tkba'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nbajc'atzen yolen Pedro, tej ttzaj jlet jun muj. Bix e cyaj bajkexin tuj. Tujtzen muj etza jun yol. Tz̈i cyjulu: —Jatzen weya Ncwalja n-oc tak' weya. Cybimc'atzen—tz̈itzen tyol Dios tetz tuj muj. ");
INSERT INTO mamNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tujx naj tej cycye'yenxin cytxlajxin, ya min-altl tcub cyuyaxin. Nuk jac'atl Jesús tjunal tcub. ");
INSERT INTO mamNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cyajcatztzen meltz'ajxin twi' witz, bix e xi' tkba'n Jesús cyexin tu'n mi'n jaa' tz'oca cykba'nxin ti jilel otk tz'oc cycye'yenxin, ojxe tjatz itz'j jxjal Sma'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ju' tzunj e cwa' cyewenxin ti jilel otk tz'oc cycye'yenxin. Pero bix ak'kexin kanlecte tiy' cyeeylexxin titzen jilel “ojxe tjatz itz'j.” ");
INSERT INTO mamNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bix e xi' cykanenxin te Jesús: —¿Tikentzele nbyana cyu'nj xin tx'olbal ley ka il ti'j tzul meltz'aj jxin Elías twitz tx'otx' nejl twitzj xin Scy'o'n tu'n Dios?—tz̈i tzunkexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Bix aj ttzak'be'n Jesús: —Jax cyu'n tx'olbal ley. Tzul meltz'ajte Elías twitzj Scy'o'n tu'n Dios nejl te ninc'ul xjal. Pero cxe'lxixse nkba'n cyey tej tul Juan Bautista, ju'tzen tul-lenxin tisex Elías, tisec'aj toc tu'n tyol Dios. Bix ch'innch'etzen tbyet Juan Bautista cyu'n xjal. Pero attzen jun kanbil cyey: ¿Ti toc tu'n tyol Dios ti pjel tej xjal Sma'n tu'n Dios? Tz̈itzen cyjulu: “Jxin Sma'n tu'n Dios q'uiyelxse a' tc'u'jxin, bix q'uelel xoo'nxin cyu'n xjal,” tz̈i tyol Dios—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tej tzunj cypon meltz'ajxin jaa' ete'j cabtlxin t-xnak'atz Jesús, bix e pon cnetkexin tuya nim xjal otk tz'oc cychmon cyiib cyi'jxin, bix cabxin tx'olbal ley nchi rasonen tzunxin cyuya t-xnak'atz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tejtzen toc cycye'yen xjal ja Jesús, cykilxse xjal e xi' k'olbelte Jesús. Bi'xse e jaw klee' ke xjal tu'n nchi tzalaj, cuma cytzki'ntltzen xjal cykil ba'n tbint tu'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Bix e xi' tkanen Jesús cye xjal: —¿Titzen jilel nxi' cyyolena cyuya nxnak'atza?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Juntltzen cye xjal ocx tzak'bente: —Taat Xnak'tzal, ma tzul wii'na ncy'aala ma tz'oc biman ti'j, bi'x ma cyaj me. ");
INSERT INTO mamNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jaa'xja tcwa'k'a ti'j, ntzaj ttzyu'n biman jak'a, bix ncub xoo'nk'a tu'n twitz tx'otx', bix n-ak' eletz plut tuj ttzik'a, bix njawxse kitx'itx'in t-xee' twitz tek'a, bix ncyaj tx'ilek'a. Ma txi' ncubsa'n nwitz cye t-xnak'atza tu'n tel cylojo'n biman ti' ncy'aal, pero mix nbina cyu'n—tz̈i tman cwal. ");
INSERT INTO mamNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Bix aj ttzak'be'n Jesús cye xjal: —¿At-xpatzen xjal min tz'oc ke tc'u'j ti' Dios, bix wi'j? Jey', ¿jte'tzen maj cxe'l nyeec'an wipemal cyey tu'n toc ke cyc'u'ja? ¿Jte'tltzen maj chi oquel nxnak'tza'na tu'n tel cyni'ya ti'j? Cyii'ntzna jcwala tzalu—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bixse e xi' cyii'n xjal cwal twitz Jesús. Tejtzen toc tcye'yen jbiman toc ti' cwal ja Jesús, bix e tzaj cyim cwal tu'n biman, bi'x e cub tz'ak cwal twitz tx'otx', bix e cub ten balk'ajel, bix e jaw swaquen ttzik'a. ");
INSERT INTO mamNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Bix e xi' tkanen Jesús te tmank'a: —¿Jtootzen tzyet ni' k'a tu'nj lu?—tz̈i Jesús. Bix aj ttzak'be'n tmank'a: —Jatxe ni' nee'xk'a, ");
INSERT INTO mamNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","bix nimxse maj o txi' t-xoo'n biman jak'a tuj k'ak' bix tuj a' tu'n tcubk'a. Ju' tzunj kape jac'a bint tu'na, k'antz ch'in tc'u'ja ki'ja. Ko toneca—tz̈i tzunxin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Bix aj ttzak'be'n Jesús texin: —¿Titzen ttenj “jac'ape bint tu'na?” Cykilca ba'n tbint te alj ma tz'ocslante ka ba'n tbint wu'na—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Entonces bix e jaw s̈-in tman cwal cyjulu: —Tzin wocsla'nwe. Chin toneca tu'n toc wocsla'na mas—tz̈itzen tman cwal. ");
INSERT INTO mamNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Toctzen tcye'yen Jesús otk jaw chmet nim xjal, bix oc cawenxin ti' biman: —Xewbaj, tu'na ma tz'oca jcwala me bix chquint. Inayentzen cxe'l kbante tey tu'n tetza tuj tchu'l jxjala, bix ya mi nuket juntl maj bix tz'oca ti'j—tz̈i Jesús te biman. ");
INSERT INTO mamNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Bix e jaw s̈-in biman, bix e tzaj cyim cwal juntl maj tu'n biman, bix el biman ti'jk'a. Tejtzen tel biman, bi'xse e cyaj bint ttenk'a tisen cyimne. Nim xjal e kbante ka otk cyimk'a. ");
INSERT INTO mamNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero bix e tzaj ttzyu'n Jesús tk'abk'a, bix e jaw tii'nxin jak'a, bix e cub we'k'a. ");
INSERT INTO mamNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yajc'atltzen bix ocx Jesús tuj jun jaa'. Cycyajtzen Jesús cyjunalx cyuya t-xnak'atz, bix ak'kexin kanlte: —¿Tikentzen min s-el biman ti'j k'a cwala ku'na?—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Bix aj ttzak'be'n Jesús: —Ke cyej biman lu mlay chi el cyeja ka mitkx nchi na'na xjal Dios tuya cykil tanem—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tejtzen cyetzxin jatzewe, bix iy'kexin cyuj tnom te Galilea. Pero tcy'ixse Jesús oc cye'yet cyu'n xjal, ");
INSERT INTO mamNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","cuma nxnak'tzanxin ke t-xnak'atzxin tuj ewjel. Bix e xi' tkba'nxin cye t-xnak'atzxin: —Tej xin Sma'n tu'n Dios cxe'l k'o'nxin tuj cyk'ab xjal, bix cbyetelxin. Pero tetzen toxen k'ij cjawetza itz'jxin—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero min el cyniy'xin ti'j ti jilel e tkba Jesús, pero tu'ntzen cych'ixewxin min e xi' cykanenxin te Jesús ti elpenina tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bix e ponkexin juntl maj tuj nin tnom te Capernaum. Tejtzen cyponxin tuj jaa' tu'n cywe'baxin, bix e xi' tkanen Jesús cye t-xnak'atz: —¿Titzen jilelj cyey xi' cyyolena tuj be?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero mintii' aj cytzak'be'nxin tu'n cych'ixewxin, cuma jatzen e xi' cyyolen xinj tuj be alcyexin mas nintzaj cyxolxin. ");
INSERT INTO mamNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Bix e cub ke Jesús, bix e tzaj ttxco'nxin cycablajaj t-xnak'atzxin, bix e xi' tkba'nxin cye: —Cyaj cyey chi oca te nintzaj. Pero cxe'lxixse nkba'n cyey, alj ma txi' tc'u'j ti' juntl xjal, ejee' tzunja chi oquel te nmak xjal tuj twitz Dios. Al kej cyaj chi cawen, ejee' tzunja chi cyjel ti'jxe—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bix e tzaj tii'nxin jun nee' cyxol t-xnak'atzxin te techel. Njawtzen tchle'nxin nee', bix e xi' tkba'nxin: ");
INSERT INTO mamNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Alj ma tz'oc il ti' jun nee' tisenc'a ju'x wi'ja, ju'xse tten oj toc il wi'j. Bix ojtzen toc il wi'j, yaa'n nuk wi'jc'a, sino ju'xse c'oquel il ti' Dios e tzaj tsma'n inayena—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Bix ocx ttx'oman Juan tyol Jesús: —Xnak'tzal, oc kcye'yena jun xinak n-el tlojo'n biman cyi' xjal tbi tzuna najben te. Pero otzen kmaya, cuma yaa'n toctz kxol—tz̈i Juan te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bix e tbi Jesús tyol Juan, bix aj ttzak'be'nxin: —Min, mi'n tz'oc cymyo'na, cuma ju' tk'on teja tiib kuya. Alj xjal ma bint jun ti jilel tu'n, tu'n tipemal nbi'ya, mlay yolente ka' wi'j, cuma yaa'n toc chilsal we. ");
INSERT INTO mamNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Alj min tz'oc k'ojl ki'j, kuyatzen ta'. ");
INSERT INTO mamNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Alj tk'on tiib kuya, ctyeec'ate tiib, amale nuket jun vas a' tzaj tk'o'n te cyey, ejee'y lepch ti'j Scy'o'n tu'n Dios. Cxe'lxixse nkba'n cyey, jaante ctiik'el t-xel te Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ko nbajsa' xsunj nyol nxi' nkba'n cyey. Ka at jun xjal ma tz'oc ten yajlalecte juntl xjal tu'n tcub tz'ak tuj il, bix mintkna'x tcywix tuj tyol Dios, tisen ja nee' luwe, ba'ntetpetzenle oj tcub ẍpet jun nim cyaa' tkul tu'n t-xi' xe't tuj mar, twitzj oj toc ten ocsal tc'u'j juntl xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Yaltzen ka tu'nx ma cwa' tz'ak tuj il, cxe'ltzen nk'o'n juntl tumel cyey. Oj tcub tz'aka tuj il, jatzen tbeyel k'ak'. Ju' tzunj ka at jun il ma tzaj ti'ja, cyiwx tcla' tiiba twitz. Ba'n tcub tpa'n ch'ina tak' tu'n tcleta te il twitzj oj t-xi' tk'on tiiba tuj il bix cxe'la tuj k'ak'. Ba'ntetpele oj tel tx'omet jun tk'aba oj taja tz'ajben tey tu'n t-xi'y tuj il tu'n tpona tuj cya'j twitzj oj t-xi'y tuj k'ak' tuya cyca'bel tk'aba. ");
INSERT INTO mamNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ju'xse tten tuya tkena ka ja k'ilx tey tuj il. Ba'ntetpele oj tel tx'omet tkena sictzen tocxa tuj cya'j. Mas ba'n oj ttena twitz tx'otx' coxa twitzj oj tpona tuya cyca'bel tkena tuj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bix ka njyona il tuya tbak' twitza, ba'ntetpele oj tetz sictzen tocxa tuj cya'j. Cuma mas ba'n oj ttena tuya junx tbak' twitza twitz tx'otx' twitzj oj t-xi'y tuya cyca'bel tbak' twitza tuj k'ak', ");
INSERT INTO mamNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","jaa'j mintey'xse nyubtz'aj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Pero cxe'lxixse nkba'n cyey, cykilcakey chi elel k'i'na tuj niy' tisen tuj jun k'ak', tu'n cytxjeta tuj cyila, bix tu'ntzen cytena yaa'n nuk jun tisenj chi'pj atz'emi'. ");
INSERT INTO mamNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ba'nte atz'en. Pero ka ma tz'oc te tzaa', ya mlay cub meltz'aj ttz̈yal juntl maj, bix ya mintii'tl ba'n tajbena. Tej atz'en tisenc'axsen a tnaabl cyuyey. J-atz'en mintii' ba'n tajbe'na ka mintii' ttz̈yal, ju'xse cyey yuwinkey ka yaa'n ba'n cynaabla twitz juntl xjal bix twitz Dios. Ju' tzunj, ba'nxkey. Tisen tzunj oj tcub tena tuj tbanel tuya juntl xjal, jatzen ba'n tnaablja—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bix etz Jesús tuj tnom te Capernaum, bix e xi'xin tbeyel ttx'otx' Judea, ttxlaj Capernaum te iy'na, bix iy'xxin tuj nima' te Jordán, jlajxe Judea. Bix e jaw chmet xjal ti' Jesús juntl maj, bix ak' Jesús xnak'tzal cye xjal tisex nbaj texin cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bix e pon cabxin xjal nimal tuj cyley, ejee'j xin fariseo, bix e xi' cykanenxin te Jesús ka ba'n tel tpa'n tiib xinak ti' t-xu'l. Nuktzen ti cyajaxin tu'n tcub tz'ak Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bix aj ttzak'be'n Jesús: —¿Titzen e cyaj tkba'n Moisés cyey?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bix aj cytzak'be'nxin: —E tcuya te Moisés tu'n tel tpa'n tiib xinak ti' t-xu'l. Tu'ntzen cycub pax, nuktzen jun u'j txi' tk'o'n xinak te xuuj tzin tkba'n otk chi cub pax—tz̈ikexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bixse aj ttzak'be'n Jesús: —Ju'tzen tcyajlen tkba'n Moisés, pero tu'nj cyyuwinela. ");
INSERT INTO mamNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero tuj tneel yaa'n ju' tewa. E cyaj ttz'i'ben Moisés: “E cub tbincha'nte Dios xinak tuya xuuj. ");
INSERT INTO mamNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ju' tzunj cyjela tk'o'n xinak tman bix ttxu tu'n toc maje tuya xuuj. ");
INSERT INTO mamNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Cyca'beltzen chi elel tisen junx xjal bix ma tu'n cycub ten mojl junx,” tz̈i Moisés tcyajlen ttz'i'ben. Ju' tzunj yaa'n ca'ba cybet, sino tisen jun xjal mixbe tu'n tel pax. ");
INSERT INTO mamNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ju' tzunj tcyajlen tk'o'n Dios te junx, yaa'n tu'n tcub tpa'n jun xjal—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bix jaantzen ke t-xnak'atzxin oc ebinte tyol Jesús cye fariseo. Ete' xsunxin tuj jjaa' jaa' ete'xin, bix e xi' cykanen t-xnak'atzxin ti tten tyol Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Bix e xi' tkba'n Jesús: —Alj ma tz'el tpa'n tiib ti' t-xu'l, bix ma maje tuya juntl xuuj, ma tz'oc tbinche pajlel ti' tneel t-xu'l bix twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bix jax ju'x te xuuj, ka ma cyaj tk'o'n tchmil, bix ma maje tuya juntl xinak, ma tz'oc tbinchen pajlel ti' tneel tchmil bix twitz Dios—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bix e xi' cyii'n xjal cab nee' tu'n toc tmoco'n Jesús ejee', tu'n cyoc te wunak. Pero bix ak' ke t-xnak'atz Jesús te cawlec cyej xjal k'ilcye nee' tu'n mi'n che'x lk'e nee' ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Toctzen tcye'yen Jesús, bix e tzaj tk'ojxin cyi' t-xnak'atzxin, bix e xi' tkba'nxin cyjulu: —Cytzakpi'nctz kej nee'wa tu'n cytzaj wi'j. Mi'n cysey tisenj tzin cyse'na, cuma nuktzen ejee' cyej xjal tisen kej nee'wa ba'n cyten tjak' tcawbil Dios, cuma tzin cybi'n bix min baj cyc'u'j. ");
INSERT INTO mamNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cxe'lxixse nkba'n cyey, alj min ma tz'oc tbi'n tcawbil Dios tisen jun nee', mlay tz'oc tuya Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bix e jaw tchle'n Jesús ke nee', bix e cub tk'o'nxin tk'abxin cyibaj nee' te cy'iwlablcye. ");
INSERT INTO mamNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tu'ntzen ttzyet tbe Jesús jaa' xa'ninaxin, bix e pon ajkel junxin xjal, bix e cub majexin twitz Jesús, bix e xi' tkanenxin: —Jey', ba'n Xnak'tzal, ¿ti cwel nbincha'n tu'n ncaman ti' nchunk'lal te junx maj tuya Dios?—tz̈i tzunxin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Bix aj ttzak'be'n Jesús: —¿Tikentzen n-oca tkba'na ba'n weya? C'oquelxix tc'u'ja ti' tyola, cuma min-alte jun xjal ba'n. Nuk jac'a te Dios ba'n. ");
INSERT INTO mamNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yal tzunj tkanbila, ttzki'ntl tzuna jlaaj cawbil e cyaj tk'o'n Dios. Mi'n byona, mi'n tz'ikena xuuj, mi'n tz'alk'ana, mi'n ẍtak'ena ti' juntl xjal, mi'n cub tyajla'na xjal, ebimc'a tmana bix ttxuy, bix xsunj cabtla. Katzen ma cybiy ja lu, bix ka min xcub tz'aka twitz, ccamal tzuna ti' tchunk'lala te junx maj tuya Dios—tz̈i Jesús texin. ");
INSERT INTO mamNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bix e xi' tkba'n jxin xjal te Jesús: —Xnak'tzal, cykil te ja luwe o bint weya wu'n jatxe tuj ncwalela—tz̈i tzunxin. ");
INSERT INTO mamNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Bix aj ttzak'be'n Jesús tuya tc'u'j: —At-x juntl mina'x tbint tu'na. Q'ueyex tik'ch tey, bix k'onxse twi' cye mebe. Ju'tzen cnetela tk'inemala tuj cya'j. Ojtzen tbint tu'na, lpetztzen wi'j—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bix e jaw baj tc'u'j jxin xjal tej toc tbi'nxin, bix e jaw bisenxin, cuma k'ina xsunxin. Bix elxin ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bix aj tcye'yen Jesús ke t-xnak'atz ttxlaj, bix aj tkba'nxin: —Penaxse tu'n toc cyk'on cyiib jxjal k'ina tjak' tcawbil Dios—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bi'x e naj cynaabl ke t-xnak'atz Jesús cyu'n tyolxin, cuma e'la tuj cywitzxin ka ejee' k'ina mas wunak twitz Dios. Bix e xi' tkba'n Jesús cyexin: —Key cwal, aljxe xjal ti'j, cyiwxsen tu'n toc cyk'on cyiib tjak' tcawbil Dios. Tisen kej xjal k'inan. ");
INSERT INTO mamNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mlay tz'ocx naj jun k'inan tuj tcawbil Dios twitz junjil tz̈ej tu'n texjil tuj tẍyo'p jun bak—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Toctzen cybi'n t-xnak'atz Jesús, masx e jaw klee'kexin, bix ak'kexin yolel cyxolelexxin: —Katzen ju' ttena, ¿altzen jun ba'n tco'pan tiib tu'n mi'n cyaj ti'jxe tcawbil Dios?—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Toctzen tcye'yen Jesús ejee'xin, bix e xi' ttzak'be'n Jesús: —Cye xjal, mlayx bint cyocxcye tuj tcawbil Dios. Pero te Dios, cykilca ba'n tbint tu'nxin—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bix ak' Pedro, t-xnak'atz Jesús, kbalxte texin: —Keya, o cyaj kcye'yena tik'ch jilel keya tu'n koc lpeya ti'ja—tz̈i Pedro te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Bix aj ttzak'be'n Jesús: —Tzinen cxe'l nkba'n cyey, aljxe xjal nuk wu'n bix ma ti' nyol te co'pbil ma cyaj tcye'yen tja, bix ke titz'en, ke ttzicy, bix ke tman, ke tcwal, bixsen ttx'otx', ");
INSERT INTO mamNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mas c'oquel k'o'n te tu'n Dios twitzx ja tx'otx'a. Ctiik'eltzen mas nim c'ojlablte. Bix ctiik'eltzen nim titz'en, bix ttzicy, bix tman, bix ttx'otx', bix ma tja. Pero al tzunj ma tz'oc lpe wi'j, jax q'uiyal a' ch'in tc'u'j. Pero amale cyiwet ch'in twitz ja tx'otx'a, ojtzen tul ac'aj twitz tx'otx', ctiik'eltzen tchunk'lal te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bix nimxse xjal nintzaj ja'lewe, ejee' tzunj mintii' chi oquela tuj juntl twitz tx'otx'. Bix nimxse xjal yaa'n nintzaj ja'lewe, ejee' tzunj chi oquel te nintzaj tuj juntl twitz tx'otx' tu'n Dios—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bix e tzyet jcybexin tzyu'n tu'n cyponxin tuj tnom te Jerusalén, nejltzen Jesús cywitz t-xnak'atz. Yaltzen ke t-xnak'atzxin, otkxse chi jaw klee'xin, cuma ju' e xi' tiin tiib Jesús Jerusalén jaa' ta' nim xjal nk'ojlec ti'jxin. Bix at juntl wik xjal lepch cyi'jxin. Otkxse cub ttz̈i cyi' xjal, cuma cytzki'ntl xjal nimxse xjal nk'ojlec ti' Jesús tuj tnom te Jerusalén. Bix ex ttxco'n Jesús kej t-xnak'atz juntl maj cyjunalxin. Bixse ak'xin kbalte ti jilel tbajlel ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Bix e xi' tkba'nxin: —Cyena. Lutzen ko' xi'nin tuj Jerusalén, jaa'j chin xe'la k'o'n tuj cyk'ab ke nintzaj tawil na'l Dios bix ke tx'olbal ley. Ejee' tzunxin chi kbalte tu'n nbyet bix chin xe'l cyk'o'nxin tuj cyk'ab nmak xjal te Roma. ");
INSERT INTO mamNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ejee'tzen xinj chi oquel xmucchante weya, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal. Pjel cytzuuben xjal inayena, chin oquel cypju'na xjal, bix chin cwel cybyo'na xjal. Pero tetzen toxen k'ij oj njatz itz'ja juntl maj—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ja tzunj xin Santiago tuya Juan, t-xnak'atz Jesús, ke tcwal jxin Zebedeo, bix e xi' lk'ekexin ti' Jesús, bix e xi' cykba'nxin cyjulu: —Xnak'tzal, kaja bint jun xtalbil tu'na ki'ja, jaj cxe'l kkanena tey—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Bix aj tkanen Jesús: —¿Titzen jilel cyaja tz'oc nbinche cyi'ja?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bix e xi' cykba'nxin cyjulu: —Oj toc tey te cawel, ctk'a'y jun nin kaak'ena ttxlajquey te cawel tuyey, jun keya tuj tmank'aba, bix juntl keya tuj tneẍa—tz̈i tzunkexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bix aj ttzak'be'n Jesús: —Min tz'el cyni'ya ti'j ti jilel ntzaj cykanena we. ¿Jac'apatzen tziy'x cyey cyu'n oj tiy' a' cyc'u'ja tisej weya? Il ti'j chin byetela. Jey', ¿mama cub cybisen cyey tu'n cycyima wuya?—tz̈i Jesús cye Juan bix Santiago. ");
INSERT INTO mamNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bix aj cytzak'be'nxin: —Cbinelke ku'n—tz̈i tzunkexin. Bix e xi' tkba'n Jesús: —Min cytzki'na, pero jax cyu'na q'uiyal a' cyc'u'ja bix chi byetela. ");
INSERT INTO mamNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yaltzen cykanbila weya, yaa'n inayenwe chin kbalte al ccawel wuya oj woc te cawel. Jatzen cxe'la k'o'nte ak'untl cyej xjal o tscy'o Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Toctzen cybi'n jlajajtlxin t-xnak'atz Jesús tyol Santiago tuya Juan, bix oc chi'l ch'inkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Toctzen tcye'yen Jesús tik'ch nbajcye t-xnak'atz, bix e tzaj ttxco'nxin cykilcakexin, bix e xi' tkba'n Jesús cyexin: —Cytzki'ntl tzuna cyxol kej xjal te Roma nchi cawen cyibaja at cawel nchi cawen tu'n t-xi' cyyeec'an nim cyajwalel cye xjal. Bix cyiw nchi oc cyi' xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Perotzen cyey cyxol, yaa'ntzen ju' ctemela tewa. Tec'axtl ctemelate, cxe'l cycye'yena ke xjal nejl twitzj tu'n cycawena cyibaj xjal. Al tzunj ma bint tu'n ju'wa, ejee' tzunj chi oquel te nintzaj cyxola. ");
INSERT INTO mamNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mitetpe ja tej xjal Sma'n tu'n Dios o tzul te cyc'ojla'betz xjal, sino ja texin o tzul te ajbel cye xjal, tuyaxetzen cxe'l tk'o'nxin tchunk'lalxin te twi' colbil nim xjal tuj tk'ab il—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tbajtzen tkba'n Jesús ke tyol, bix e tzyet tbexin cyuya t-xnak'atzxin juntl maj. Cwa cyponxin tuj tnom te Jericó. Te xsunxin ttxa'n tnom, bix oc lpe nim xjal ti'jxin. Cwa tpon canaxin ti'j junxin mos̈ k'uklc'a tuj be, kanl tcotz cye xjal. Bartimeo tbi jxin mos̈, tcwal junxin xjal Timoteo tbi. ");
INSERT INTO mamNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tej tzunj tbinte mos̈ jxin xjal tzajnin ta'xin ja Jesús aj Nazaret, bix ak'xin s̈-il: —¡Jesús, jay Tcwal David, k'antz tc'u'ja wi'j!—tz̈i mos̈. ");
INSERT INTO mamNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nimtl xjal oc ilente mos̈ tu'n mi'n tz'el twi'. Pero mas el ts̈i'nxin twi'xin, bix e xi' tkba'nxin juntl maj: —¡Tcwal David, k'antz tc'u'ja wi'ja!—tz̈i tzunxin. ");
INSERT INTO mamNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bix e cub we' Jesús, bix e xi' tkba'nxin cye xjal: —Cytxcontz jmos̈a—tz̈i Jesús. Bix e tzaj cytxco'n xjal jaxin: —¡Nimx tc'u'ja! ¡We'wey! Luy ntxquet tu'n Jesús—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tbintetzen mos̈, bix ex t-xoo'nxin ttxow'xin toc, bix e jaw t'icypajxin, bix e xi' lk'exin ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Bix e xi' tkanen Jesús te mos̈: —¿Ti jilel taja tz'oc nbinche ti'ja?—tz̈i Jesús. Bix aj ttzak'be'n mos̈ te Jesús: —Xnak'tzal, waj chin cye'yen juntl maj—tz̈i tzunxin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Bix e xi' tkba'n Jesús texin: —Ba'n taja. Tu'n cykil tc'u'ja ma tzula tnaabla—tz̈i Jesús. Tujx naj tul tnaabl tbak' twitzxin, bix ak' xe'l lpexin ti' Jesús tuj be. ");
INSERT INTO mamNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Otktzen pon cana Jesús nka Jerusalén, cyuj tnom te Betfagé bix Betania, junx tuya jun witz Olivos tbi. Bix e xi' tsma'n Jesús ca'ba t-xnak'atz tuj jun cyej tnoma. ");
INSERT INTO mamNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Bix e xi' tkba'nxin: —Cyucxatzen. Ojtzen cyocxa tuj jtnom, n-oc kcye'yena. C'oquel cycye'yena junjil bur yo'lecjil, bix min-al jun xjal o jax ke tibajjil. Cypjumeljil bix cyii'ntz tzunjil. ");
INSERT INTO mamNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Katzen al ma tz'oc kanente cyey tiken n-el cypju'n jila, cyk'umenxse ka c'ajbeljil te cyaawa, bix tzul tmeltz'u'n naj texin jajil—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Entonces bix e xi'kexin, bix e cnet jjil bur cyu'nxin, ẍpo'njil tuj be twitz tlemel jun jaa'. Bix el cypju'nxin jajil. ");
INSERT INTO mamNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bix attzen cab xjal tcub tuj be, bix e xi' cykanenxin cye t-xnak'atz Jesús: —¿Titzen nbaj cyey? ¿Tikentzen n-e'la cypju'na jil bura?—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bix aj cytzak'be'nxin tisecaj otk tkba Jesús. Bix e cycuyan xjal tu'n t-xi' cyii'nxin bur. ");
INSERT INTO mamNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bix e xi' cyii'nxin bur te Jesús, bix e jax cyk'o'nxin cyxbalenxin tibajjil, bix e jax ke Jesús tibajjil. ");
INSERT INTO mamNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bix e tzyet tbe Jesús, bix nimxse xjal oc lpe ti'j Jesús. Bix e cub cyk'o'n xjal cyxbalen tuj tbe Jesús, bix atl xjal e cub k'onte tk'ab xa'j tuj tbexin. Jatzen techelj oj tocx jun nin cawel tuj tnom. ");
INSERT INTO mamNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bix cykilcaxse xjal nejl twitzxin bix lepch tzinxse nchi s̈-in: —¡Ma tzul kaaw! ¡E tten tzunxin kuya nim k'ij! ¡Cy'iwla'nxit-xin, cuma ma tzulxin tuya tajwalelxin tu'n Dios! ");
INSERT INTO mamNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Cy'iwla'nxit-xin, cuma ma tzul t-xe'chel David te cawel! ¡Axse tbanel!—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ju'tzen tten tocxlen Jesús tuj nin tnom te Jerusalén, jaj jun tnom mas nintzaj cyxol xjal judío. Tejtzen tocx Jesús tuj Jerusalén, bix e xi'xin tuj nin tja Dios te cyey'lecxte tuj. Bix ajtz meltz'ajxin tuya cycablajaj t-xnak'atzxin tuj tnom te Betania, cuma ch'itk tex k'ij. ");
INSERT INTO mamNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tetzen juntl k'ij bix ex Jesús cyuya t-xnak'atz tuj Betania. Tujtzen be bix oc tak' weyaj te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nakchtzen e xa' tcye'yenxin jun wi' lo'pj higuera tbi. At nim t-xaak, tzin tyeec'an ka at twitz. Bix e xi'kexin te k'ilbel twitz. Pero tejtzen cyponxin, mintii' twitz e cnet cyu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ju' tzunj e xa' tkba'n Jesús te tken higuera: —Junxse maj min-altl xjal cxe'l lo'nte twitza, cuma mintii' twitza q'uelel—tz̈i Jesús te tzee'. Bix e cybi t-xnak'atz Jesús tyolxin te tzee'. ");
INSERT INTO mamNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bix e ponkexin tuj tnom te Jerusalén. Tejtzen cyponxin, bix ocx Jesús tuj nin tja Dios. Bix ak'xin lojolbetz cyej xjal nchi q'ueyen bix nchi lok'on tuj tja Dios, cuma oc tcye'yenxin tja Dios tisen jun plasen. Bix e jaw tpac'tz'enxin kej mes cyej xjal ch'ixbel pwak te Roma te pwak te Israel tu'n tocx cychojentj xjal te tja Dios, bix e jaw tpac'tz'enxin kej cyk'a'j xjal nchi q'ueyen cucu' te juntl wik tu'n t-xi' cyoyenxin te Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bix min e tcuyaxin tu'n cyex xjal tuj tja Dios tuya tik'ch k'i'n cyu'n, cuma nim xjal ex tuj tja Dios cuma nkatzen ch'intl be. ");
INSERT INTO mamNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bix ak'xin kbalte cye xjal tiken e tbinchexin ju'wa: —Tz̈i tuj tyol Dios cyjulu: “Weya nja te nabl wewa cyu'n xjal tuj cykil twitz tx'otx',” tz̈i Dios. Pero yaltzen cyey, matzen cub meltz'aj tja Dios cyu'na tisen jun tja alak'—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tejtzen toc cybi'n ke nintzaj tawil na'l Dios bix ke tx'olbal ley ti e baj te Jesús, bix ak'kexin ninc'ul ti'j ti ctemela tu'n tbyet Jesús, cuma at nim ttz̈i Jesús cyi'jxin, cuma ya tu'n cyoc baj xjal tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pero bix etz Jesús te kale tuj Jerusalén, tisex e tsexin te jun k'ij. ");
INSERT INTO mamNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tetzen juntl k'ij, bix excakexin ta'j tken higuera oc cycye'yenxin te jun k'ij. Yal toc cycye'yenxin, otk tzkij. ");
INSERT INTO mamNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bix ul tuj tc'u'j Pedro ti otk tz'oc tkba'n Jesús te higuera te jun k'ij, bix e jaw yolen Pedro: —Xnak'tzal, ¡cye'nja higuera e cyaj tsbu'na ewe! ¡Ma tzkij!—tz̈i Pedro te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Bix aj ttzak'be'n Jesús: —Mintii' teja. Alj k'uklec tc'u'j ti' Dios, jac'a bint tik'ch tu'n. Ju' tzunj c'oquelxix ke cyc'u'ja ti' Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tzinexixse cxe'l nkba'n cyey, al k'uklec tc'u'j ti' Dios, ctk'a'te Dios ti jilel cxe'l cykanena texin. Tisej oj t-xi' cykba'na tej witz lu tu'n tjaw k'ukpaj tu'n t-xi' tuj mar, ctcuyate witz ka k'uklec cyc'u'ja ti' Dios, bix ka min baj cyc'u'ja. ");
INSERT INTO mamNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ju' tzunj cxe'l nkba'n cyey, ba'n tbinte Dios tik'ch tu'n ka ilxix ti'j. Nuk cxe'l cykanen ch'ina tuya cykil cyc'u'ja, bix ccyiik'ey te Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nko yolentzen ti' na'j Dios, attzen juntl tumel. Ojtzen cyak'a na'l Dios, ka at til jun xjal twitza, cynajsanq'uey ka cyaja najset cyila tu'n Dios at tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero ka min xcub cynajsa'na til juntl xjal, jax mlay najset cyila tu'n Dios—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tbajlenxitltzen yolenxin, bix aj meltz'ajkexin tuj tnom te Jerusalén, bix e xi' Jesús tuj tja Dios juntl maj. Toctzen cycye'yen ke nintzaj xjal bix ke tx'olbal ley bix ke nintzaj tawil na'l Dios ja Jesús, bix e xi' lk'ekexin te kanlecte te Jesús: ");
INSERT INTO mamNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Titzen jilel tajwalela ti'j nuk tik'ch ncub tbinchena? ¿Altzen ma tz'oc k'onte tajwalela tu'n tex tlojo'nkey xjal tuj tja Dios ewe?—tz̈i tzunkexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Bix aj ttzak'be'n Jesús: —Ju'x we jax cxe'l nkanen cyey. Ka ma tzaj cykba'na we alcyej nkanbil cyey, jaxse jac'a t-xi' nkba'nwe cyey tuya alcye wajwalel ncwa' nbinche. ");
INSERT INTO mamNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jatzen nkanbil ja lu: Tej tbautizaran tii'n Juan Bautista cye xjal, ¿jaa' e tzaa' tajwalelxin, tu'npa Dios, ma tu'npa xjalj?—tz̈i Jesús cye nintzaj xjal tuj tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bix ak'kexin yolel cyxolelexxin: —Katzen ma txi' kkba'n ka ja Dios e tzaj k'onte tajwalel Juan, bixse c'aaltz tkba'nxin ke tu'n tiken min oc kbi'n tyol Juan. ");
INSERT INTO mamNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bix jax mlay txi' kkba'n ka xjal oc k'onte tajwalelxin—tz̈i tzunkexin, cuma cycy'ixa oc cycyakwusa'nxin ke xjal, cuma cykil xjal etzkilte ka ja Dios e k'onte tajwalel Juan. ");
INSERT INTO mamNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ju' tzunj aj cytzak'be'nxin: —Min ktzki'nke—tz̈i tzunkexin te Jesús. Bix aj ttzak'be'n Jesús cyexin: —Jaxne ju'x we mlay txi' nkba'n tuya alcye wajwalel ncub nbinche—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bix ak'x Jesús kbalte cye tx'olbal ley bix cye nintzaj xjal bix cyuya tawil na'l Dios, bix e cub tk'o'nxin jun techel ka tu'n tbyet-xin. Tz̈i tzunxin cyjulu: —At junxin xjal e cu'x awante cab tken uva. Bix oc tk'o'nxin penwen ti'j. Bix e jaw tbincha'nxin jun ttemlel uva tu'n tel vino ti'j, bix e jaw tbincha'nxin jun jaa' nim twe' te c'ojlablte tawalxin bix te c'ojlabl ttemlel twitz uva. Bix e cub bint tyolxin cyuya cab xjal tu'n tcub cymina'n ttx'otx'xin tu'ntzen oj tjaw awal twitz, niy'jantzen te taaw tx'otx' bix niy'jantzen cye ak'anal. Bix exxin tuj tbexin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tetzen tumel tu'n t-xilj uva, bix e xi' tsma'nxin jun tsanjelxin te pa'lbel tej texin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero tejtzen tpon sanjel, bix oc cypju'n manal tx'otx' jaxin, bix aj ljet-xin mintii' uva otk tiik'xin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tejtzen tpon meltz'ajxin tuya taaw tx'otx' mintii' uva k'i'n tu'nxin, bix e xi' tsma'n taaw tx'otx' juntl tsanjel. Tej tzunj tpon sanjel, bix oc cypa'n manal tx'otx' twi' sanjel, bix e baj yaset-xin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bix e xi' tsma'nxin juntl tsanjelxin. Yal tzunj ja juntl xina, bi'xse e byet-xin. Bix e xi' tchk'o'nxin nimtl tsanjelxin cabtl maj. Attzen e baj pjet, bix attzen bi'x e cub cybyo'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Bix e xi' tchk'o'n texin cykilca ke tsanjelxin. Ya min-altl e cyaj. Nuk jun tcy'aalc'atlxin at tuyaxin. Bix e xi' t-xi'manxin ti'j cyjulu: “Oj t-xi' nchk'o'n ncwal, kapetzen cybi' manal tx'otx' ncwal, tz̈i tzunxin. Bix e xi' tchk'o'nxin tcwalxin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero tej tpon tcwalxin, bix ak' ke manal tx'otx' yolel: Ja tcwal taaw tx'otx' ma tzul. Tetzele tkabk'a cyjela jtx'otx'a. Ka miin kbya'c'ak'a, tu'ntzen ke cyjela,” tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bix e tzaj cytzyu'n manal tx'otx' jak'a, bix e cub byetk'a, bix ex xe't t-xumlalk'a ti'jxe penwen. ");
INSERT INTO mamNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Attzen jun cxe'l nkanen cyey. ¿Tii'ntzen cyey tuj cywitz? ¿Ti ctse' jxin taaw awal kej xjal manala? Cxe'ltzen nkba'n cyey, oj t-xi' jxin taaw tx'otx', cwel tbyo'nxin ke manal tx'otx', bix cxe'l tk'o'nxin tx'otx' te tmaan juntl wik. ");
INSERT INTO mamNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Mixpatzen n-e'la cyni'ya ti'j tyol Dios nbyan cyjulu: “Jxak q'uelel ka'yba tuj cywitz binchal jaa' te tk'uklel t-xee' jaa', ja tzunja cwel meltz'aj te nin tk'uklel jaa'. ");
INSERT INTO mamNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jatzen Dios cwel meltz'unte xak te tbanel xak. Ju' tzunj axse q'uelela tuj kwitz,” tz̈i tyol Dios tuj jun bitz?—tz̈i Jesús cye nintzaj xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Toctzen cybi'n ke nintzaj tawil na'l Dios, ke tx'olbal ley, bix ke nintzaj xjal tyol Jesús, cyaj tzunxin e tzyet Jesús tu'n tbyet-xin, cuma el cyniy'xin ti'j ka cyi'jxin otk yolena Jesús, cuma otk tz'el cyxoo'nxin ja Jesús. Pero mintzen e cytzuyxin Jesús tu'n cytz̈i jxjal lepchec ti'j Jesús. Bix e cyaj cycye'yenxin Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yajc'atltzen bix e xi' cychk'o'n nintzaj xjal cabxin nimal tuj cyley bixsen cabxin cycy'i chi k'ojl tuya xjal aj Roma, cuma jatzen Roma cawel tibaj Israel. Bix e xi'kexin ti' Jesús te kanlecte jun cyiw yol te Jesús tu'n tcub tz'ak Jesús tuj cyk'abxin tu'n ka' tyol Jesús ti' Roma. ");
INSERT INTO mamNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bix e xi' cykanenxin te Jesús: —Xnak'tzal, ktzki'na jax tey tyol. Min tz'aj tk'on tey tiib tuya juntl xjal. Min tz'oc tcye'yen tey tii'n ke xjal oj n-ak'a ninc'ul xjal. Jtey nbaj tyeec'ana ja te ja tisexix taj Dios. Jey'tzen, ¿ti tey toc tu'n? ¿Ilxixpa ti'j tu'n tcub kchoona te te Roma, ma minj?—tz̈i tzunkexin. Nuktzen e cyyoxin la' ti toc tu'n Jesús, cuma nim xjal e tajbe tu'n tcub tchoon, bix nim xjal min e tcuya tu'n tcub tchoon. ");
INSERT INTO mamNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero ttzki'n Jesús ca'ba tten cyanem xjal, bix e xi' tkba'nxin cye xjal: —¿Tikentzen ncwa' cyk'o'na c'o'bil tuj nbe tuya cyyola? Cyk'antz jun pwak we. At jun cxe'l nyeec'an cyey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bix e xi' cyk'o'nxin jun pwak te Jesús. Bix e xi' tkanen Jesús cyexin: —¿Ale jwitzbaj bix ale jbiybaj tcub twitzj pwaka?—tz̈i Jesús. Bix aj cytzak'be'nxin: —Jaj twitz nin cawel cyibaj cawel te Roma—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bix aj ttzak'be'n Jesús cyexin: —Kane ju'wa, cyk'onxne te cawel alcyej te cawel taj, bix cyk'onx te Dios alcyej te Dios taj—tz̈i Jesús. Bix e jaw klee'kexin tu'n tyol Jesús. Otktzen cub tzpet cyc'o'bilxin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yajc'atltzen bix e pon jun clojxin xjal, saduceo tbi cyclojxin, ti' Jesús. Ejee'tzen xinj e kbante ka oj tcyim jun xjal, bi'x ccymel junx maj. Mintii' tu'n tjatz itz'j. Bix e ponkexin te k'olc'a c'o'bil tuj tbe Jesús tuya cyyolxin. Tz̈ikexin cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Xnak'tzal, o cyaj ttz'i'ben Moisés ka jun xinak najlel ma cyim, bix min-al tcwal tuya t-xu'l, il ti'j tu'n tmaje xuuj tuya jun titz'en ma jun ttzicy cyimne tu'n titz'j tal xuuj. Yaltzen tneel tal xuuj n-octltzen te tcwal ktzan tchmil xuuj te c'ojlal tx'otx' bix tu'n mi'n txi' tz'ak tiy'jil cyimne. ");
INSERT INTO mamNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jaxse ba'nte, attzen jun maj at wuuk xjal cyitz'en cyiib. Ja tzunj xin tneel e majexin, pero bix e cyimxin, bix min e cyaj jun tcwalxin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Entonces bix e maje viuda tuya tneel titz'en ktzan tchmil xuuj. Pero jax bix e cyimtlxin minxn-al tal xuuj itz'j. Ju'xtl e baj tuya tcab cyitz'enxin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","E majekexin cywuukelxin tuya xuuj, bix min-alx jun cyexin itz'j tcwal tuya xuuj. Manc'biltzen bix e cyim xuuj. ");
INSERT INTO mamNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ba'ntzete. Pero ojtzen cyjatz itz'j xjal juntl maj, ¿altzenle jun cyexin c'oquel te tchmilxuj ti'j cywuukelxin e maje tuyaxuj?—tz̈i tzunkexin te Jesús te k'ilbel tipemalxin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Pero bix aj ttzak'be'n Jesús: —Junxse maj tzpetpajninkey, cuma min cytzki'na ti toc tu'n tyol Dios, bix min cytzki'na ka tu'n tipemal Dios ba'n tjatza itz'jtl t-xumlal jun xjal cyimne. ");
INSERT INTO mamNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Oj cyjatz itz'j cyimne juntl maj, jun wikxitlte chunk'lal. Xuujle, xinakle, mlay chi majecye juntl maj, tise ke tsanjel Dios tuj cya'j min chi oc maje. ");
INSERT INTO mamNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Cxe'ltzen nkba'n cyey ka il ti'j chi jawetz itz'j cyimne juntl maj. ¿Bajxpatzen txa' cycye'yena tyol Dios e cyaj ttz'i'ben Moisés ti toc tu'n Dios tej tetz yolenxin tuya Moisés tuj tken k'ak' tuj ch'i'x? Tz̈i Dios cyjulu: “Inayen wej Tdios Abraham, bix te Isaac, bix te Jacob,” tz̈i Dios te Moisés tuj tken k'ak'. Ju'tzen e xa' tkba'n Dios cuma i'tzx Abraham, Isaac bix Jacob tuj juntl chunk'lal. ");
INSERT INTO mamNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Cycye'nc tzuna Dios, yaa'n Tdios cyimne texin, sino Tdios i'tz texin. Ju' tzunj tzpetpajninx ke cyey—tz̈i Jesús cye xjal saduceo. ");
INSERT INTO mamNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Toctzen tcye'yen junxin tx'olbal ley otk tz'aj ttzak'be'n Jesús tisexix tten, bix e xi' lk'exin ti' Jesús te kanlecte cyjulu: —¿Altzen cyej tneel tcawbil Dios cyxol cykilca mas il ti'j?—tz̈i tzunxin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Bix e xi' tkba'n Jesús: —Jatzen tneel tcawbil Dios cyxol cykilca ncnet tuj tyol Dios ja lu: “Tz̈i Moisés: ‘Key xjal te Israel, cybimq'uey: Jxin Kaaw Dios o'cxc'a jun xinj Taaw twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ju' tzunj c'oquelxix tak' Cyaawa cyey tu'n cykil cyanema, tu'nxix cykil cyc'u'ja, tu'nxix cykil cynaabla, bix tuyaxix cykil cyipemala,’ tz̈i Moisés cye xjal aj Israel,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tcabtzen tcawbil Dios ja lu: “C'oquelxix tak' jun xjal cyey tisex n-oc cyak' cyiiba cyey,” tz̈i Moisés cye xjal aj Israel nejl. Mintii' juntl tcawbil Dios ju'xix tisej ca'ba lu—tz̈i Jesús te tx'olbal ley. ");
INSERT INTO mamNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bix aj ttzak'be'n jxin tx'olbal ley: —Ju'xe, Taat Xnak'tzal. Jax toc tu'na junxte Dios at. Min-al juntl at ti'jxexin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jaxte. Aljxe xjal ma tz'oc tak' Dios te tuya cykil tanem bix tu'n cykil tc'u'j bix tuya tipemal, bix ma tz'oc tak' jun xjal te tisex n-oc tc'ojlante tiib, masx ba'nte twitz Dios twitzj oj nxi' cyoyen xjal cyoybil te Dios—tz̈i jxin tx'olbal ley te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Toctzen tbi'n Jesús ttxolan tyol tx'olbal ley, bix e xi' tkba'n Jesús texin: —Yaltzen tey, n-eltzen tni'ya ti' tcawbil Dios. Yaa'ntzen nakch ta'y tu'n toctzen tjak' tcawbil Dios—tz̈i Jesús texin. Cybajtzen yolenxin tuya tx'olbal ley, min-altl xjal oc nimsante tc'u'j te kanlec tik'ch jilel te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bix ak'xxin xnak'tzal xjal juntl maj, bix e xi' tkanenxin cye xjal: —¿Tikentzen nbyana cyu'n tx'olbal ley ka jxin Scy'o'n tu'n Dios t-xe'chel David jaxin? Ju'xte ttena. Pero jaxtlpe David e kbante ka Taaw David jaxin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cycye'nctzen tyol David tu'n tipemal Espíritu Santo. Tz̈i David cyjulu: “Bix e xi' tkba'n Dios te Waawa: ‘Kequey tuj nmank'ab te tneel xjal. Ayomtzen ojxe cyocx baj tajk'oja tjak' tkena wu'n,’ tz̈i Dios te Tcwal,” tz̈i David tej tcyaj ttz'i'ben—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nyolenx Jesús t-xi' tkba'n: —Jax David oc k'onte Scy'o'n tu'n Dios te Taaw at-xe k'ij. Katzen ju'wa, yaa'nale nuk t-xe'chel David jaxin, sino Taawnele David jaxin jatxe nejl—tz̈i Jesús cye xjal. Ti'jxxin nyolenaxin. Nimxse xjal oc achente tyol Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bix e xnak'tzanxxin mas cye xjal: —Cyc'ojlam cyiiba mi'n chi oc lpey cyi' tx'olbal ley, cuma cyachenxin chi iy' bet-xin tuya cu'j cyxbalenxin te yec'bilte ka nmak xjalkexin, cuma cyajxin chi oc k'olbet-xin tuya nim c'u'jbaj cyi'jxin oj nchi iy'xin tuj plasen. ");
INSERT INTO mamNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bix ja xsunkej nintzaj k'ukbil nxi' cyjyo'nxin tuj camon jaa' te xnak'tzabl tyol Dios bix tuj jun o'na. ");
INSERT INTO mamNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nchi na'nxin Dios tuya nim yol nuk tu'n t-xi' cyyeec'axin cyiibxin cye xjal ka ba'nkexin. Peroxix cyexin cynaabl tzin cyyeec'axin oj nbaj cyalk'a'nxin ke cyja viuda. Ejee'tzen cye xinja c'oquel mas cyiw cycastiwa tu'n Dios twitz juntl wik aj il—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yajxetzen ch'intl, k'uklc'atzen Jesús nka ttzii' tja Dios, jaa' ete'c'a jcaxin tcublel pwak n-ocx te tcotz tja Dios. Bixse oc tc'u'j Jesús ti'j tii'n chi k'on xjal pwak. Nimxse k'ina cu'x k'onte nim pwak. ");
INSERT INTO mamNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Cwa tpon junxuj viuda mebexuj, bix e cu'x tk'o'nxuj ca'ba centavo tuj caxin. ");
INSERT INTO mamNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bix e tzaj ttxco'n Jesús ke t-xnak'atz, bix e xi' tkba'nxin cyexin: —Cxe'lxix nkba'n cyey jxuj mebewa ma cu'x tk'o'nxuj mas nim twitzj cabtl xjal ncu'x k'onte nim, ");
INSERT INTO mamNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","cuma kej xjal k'inawa ncu'x cyk'o'n ya min tz'ajbenxixtl cye, pero jte xuja ma cu'x tk'o'nxuj kej manc'bil ca'ba centavo k'i'n tu'nxuj tu'n titz'jxuj tuj tmebeyilxuj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Teltzen Jesús ti' tja Dios cyuya t-xnak'atz, bix e xi' tkba'n jun cyexin te Jesús: —Xnak'tzal, cyena, ¡a xsun xak binchbil tej tja Diosa, bix axse cycye'yencj nmak jaa' tej tja Diosa!—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Pero bix aj ttzak'be'n Jesús: —Cye'ncxixseke ti'j lux ke jaa' ete'wa, cuma tzul jun k'ij oj cyiy' kuch'j jaa'wa. Mi nuket jun xak cyjel tibaj juntl—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bix etzkexin tuj Jerusalén, bix e xi'kexin twi'j witz te Olivos tumel tja Dios. Bix e cub ke Jesús tuj c'ul. Bix e xi' lk'e ke Pedro, Santiago, Juan, bix Andrés ti' Jesús te kanlecte: ");
INSERT INTO mamNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Taat, ¿jtojtzen pjel jma tzaj tkba'na keya? ¿Bix titzen jilel techel tzul oj ch'itk tbaj ju'wa?—tz̈i tzunkexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bix aj ttzak'be'n Jesús: —Cyk'o'nc cyc'u'ja ti'j nuk al cub yajlante cyey. ");
INSERT INTO mamNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Cuma tzul nim xjal kbalte: “Inayen wej Scy'o'n tu'n Dios,” tz̈i cybel, bix cwel cyyajla'n nim xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ojtzen toc cycye'yena nbaj k'oj tzalu bix nxi' cybi'na nbajtl k'oj jak'ch tumel, mi'n chi jaw sey'paja, cuma ju' il ti'j pjel te mintkna'x tbaj twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tzul jun k'ij c'oquel k'oj tu'n jun nin tnom tuya juntl nin tnom tuj cykil twitz tx'otx'. Bix nuk jak'ch q'uiyela xcyaklajnab. Bix pjel nim weyaj twitz tx'otx'. Maantkxixse ja te t-xee' tchyonelja, tisen jun xuuj at tuj tchyonel tal. Ju'tzen pjelte twitz tx'otx' oj mitkna'x tbaj. ");
INSERT INTO mamNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yaltzen cyey, cyc'ojlamxix cyiiba tuya tik'ch cyyola, cuma chi xe'l k'o'na cye cawel tu'n cyoc pjeta cyuj camon jaa' te xnak'tzabl tyol Dios nuk wi'jc'a. Bix chi xe'l chk'eta cywitz gobernador bix cywitz nin cawel nuk wi'jc'a, bixse t-xi' cyk'umena ti nten. ");
INSERT INTO mamNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tetzen mintkna'x tbaj twitz tx'otx', q'uelex tz̈itj tpocbal jyol co'pbil xjal tuj cykil tnom twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ejee' tzuna chi elex tz̈itpunte tej yola. Ju' tzunj mi'n tzaj ttz̈i cyi'ja oj tzyu'nkey cyu'n cawel nuk wi'jc'a, bix mi'n baj cyninc'u'na ti'j ti cyyola, cuma yaa'n ti' cywi'y ctzaala cyyola, sino ja te Espíritu Santo c'oquex kbante tuj cywi'y ti cyyola cye cawel. ");
INSERT INTO mamNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cye tzunj k'ij chi ul, ke cytzicyxse xjal ke cyitz'enxse xjal cxe'l k'onte juntl tuj cyk'ab cawel tu'n cybyet, bix ke cwal chi oquel k'ojl cyi' cyman, bix cxe'l cyk'o'n cwal ke cyman tu'n cybyet. ");
INSERT INTO mamNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bix nim xjal c'oquel chi'l cyi'ja cuma telniy'x ka wuya cyk'ona cyiiba. Pero alj xjal min xcyaj cye'yente we ojxe tbyet, chi tzakpajeltzen twitz k'ak' tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Cxe'ltzen nkba'n cyey juntl yol ilc'a ti'j. Cyc'ojlam cyiiba. Ojtzen toc cycye'yena jun xjal xitel, bi'x cyjel we' jun ti jilel tu'n tjunalx bix chi i'yel tz'e'ya tu'n, tocxsen jaa'j yaa'n ba'n tocxe ten, jatzen ba'n cyxi' okj jxjal te Judea tuj c'ul cyxol witz tu'n tclet cychunk'lal. Il ti'j pjel te ja lu. Ju' tzunj tz'ocxix cyc'u'ja ti'j oj tbaj. ");
INSERT INTO mamNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Alcyej najlan tja oj tul jxjal xitel, mi'n chi ocxtle k'ilbetz titl cyey tuj cyjay, sino txucl chi xe'l oka tuj c'ul. ");
INSERT INTO mamNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bix alj nak'anan tuj taak'en, mi'n tz'ajtz meltz'aj tuj taak'en, mitetpe te k'ilbex ke ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mlayxix kej xuuj preñada, bix ma nch'u'n cyal, oj cyel ok oj tul ja ila. ");
INSERT INTO mamNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bix cykanex te Dios nuket mi'n baj ju'wa tuj jbalel, cuma cyiwxse tbetsaj. ");
INSERT INTO mamNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bix cuma jaxse cab k'ij tchyonelj, bix bajxsen pja' jun maj ju'wa jatxe tcublen itz'j twitz tx'otx' tu'n Dios, bix mi'n baj juntl maj ju'wa oj tbaj ja lu. ");
INSERT INTO mamNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nuket mi'n cub tbajsa'n Dios ja q'uixc'aja twitz tx'otx', milen-al juntl xjal jac'a cyaj itz'j. Pero tzulxin te bajsalc'a twi' tu'n tanemxin cyi'j texin t-xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Katzen al jun xjal ma tz'oc kbante cyey: Cycye'yenctzen, lu tzunj xin Scy'o'n tu'n Dios lu, ka tz̈i cyseja, mi'n tz'oc cybi'na, ");
INSERT INTO mamNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","cuma tzultzen nim xjal ẍtak' kbalte ka ejee' Scy'o'n tu'n Dios te cawel, bix tzul xjal ẍtak'el ka ejee' tyolel Dios. Ejee' tzunj xjal lu chi cwel binchante techel bix nuk tik'ch cbinel cyu'n tuya cyipemal te yajlal cye xjal, bix chi oquel ten niy'belte tuya cyipemal la' ka mi'n chi cub tz'ak cyuyaxe jte Dios t-xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cykil tzunja lu nxi' nkba'n cyey nejl. Cyc'ojlantzen cyiiba twitz tu'n mi'n chi cub tz'aka. ");
INSERT INTO mamNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yaltzen tej k'ij oj tak' iy'pa n-el baj q'uixc'aj, c'oquel klolj twitz k'ij, ya mi'n txakentl xjaw, ");
INSERT INTO mamNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","chi c'u'l tz'ak che'w, bix nuk clu'leltl tipemal twitz cya'j tu'n t-xi' xitj. ");
INSERT INTO mamNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Cyuj xsunj k'ij oj nchic'ajaxa inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal, tzajnin kena twitz tx'otx' tuj muj, tuya nim wipemala bix tzinxsen chin txakakana. ");
INSERT INTO mamNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ojtzen wul, chi ultzen nsma'n nsanjel tuj cya'j tuj cykil twitz tx'otx', tuyaxe cykil jaa' pomnina baj ttxa'n twitz tx'otx', tu'n cyoc chmet jxjal ebil nyola. ");
INSERT INTO mamNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Cycnomtzen. Nk'a'c'atzen jun techel ti tten oj wul, tuya ti tten oj nxulan jun wi' higuera. Oj n-alajin tk'ab higuera bixsen n-ak' eletz muxk'aj t-xul, ya telniy'tzen tuj cywitza ka ch'itk toc coresma. ");
INSERT INTO mamNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tisen tzunj t-xul higuera n-etz te ch'itk coresma, q'uelelc'atzen cyni'ya ti'j oj tbaj tik'ch ma txi' nkba'n cyey twitz tx'otx', jatzen techel ka ch'itk tetz jxjal Sma'n tu'n Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tzinexix cxe'l nkba'n cyey jcyiy'jil xjal te Israel mi'n baj teja, sino q'uitz'jelxte ojxe tbaj tisej ma txi' nkba'n cyey. ");
INSERT INTO mamNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Il ti'j ju' pjela. Te cya'j bix te twitz tx'otx' chi pjelxcye, pero ke weya nyol mlay chi bajcye. ");
INSERT INTO mamNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yaltzen tej tu'n alcye k'ij bix jniy' hora oj wul, min-al ebilte. Mitetpe ejee' tsanjel Dios tuj cya'j itzkilte, bix mitetpe inayena, Tcwal Dios, itzkilte. Nukxix ja te Mambaj itzkilte jtoj pjel. ");
INSERT INTO mamNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cuma min cytzki'na jtoj chin ulwe, ju' tzunj cyc'ojlam cyiiba tu'ntzen binne cytena oj cyul canbaja. ");
INSERT INTO mamNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ju' teja tisen jun xjal matk tziy' bint tu'n t-xi' tuj juntl tnom. Tetzen mintkna'x tex bint taaw jaa', ncyajtzen tk'o'n cyaak'en ak'anal teeylex te juun, bix te c'ojlal jaa' tu'n t-xi' tc'ojla'n. ");
INSERT INTO mamNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Inayentzen wej tisen taaw jaa'. Mintii' tumel jtoj c'ulel meltz'aj taaw jaa', matzen te ncub klolj, matzen te chil ak'bila, matzen te nok' ey' te ch'itk kskix, bix matzen te k'ijl. Ju' tzunj cyna'mc'a cyiiba, ");
INSERT INTO mamNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","cuma yaa'n tumel nchi wutana tuj cyaak'ena oj wul meltz'aj. ");
INSERT INTO mamNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Alcyej nxi' nkba'n cyey, yaa'n nuk cyequey nxa' nkba'n, sino te cykilj xjal lepchec wi'j. ¡Cyna'mc'a cyiiba!—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tetzen ca'batl k'ij tu'n tiy' cyiy'sa'n xjal te Israel jnink'ij oc tbi te Iy' Dios Bix E Tcolxin Ke Xjal Te Israel, bix ka nink'ij te Pascua, oj nchi ak' xjal waa'l pan mintii' tk'anel tocx. Te tzunj ca'batl k'ij te mintkna'x tul canan nink'ij, bix oc cychmon cyiib ke nintzaj cyawil na'l Dios bix ke tx'olbal ley, te ninc'ul ti'j ti tten tu'n ttzyet Jesús, bix tu'n tbyet-xin. Pero cyaj tzunxin e tzyet Jesús tuj ewjel, cuma cytzki'nxin ka a cyanem xjal ti'j Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero at cab cyexin e kbante: —Mi'n jaw ktzyu'n Jesús tuj nink'ij, cuma ka ma jaw ktzyu'nxin tujc'a nink'ij, chi jawel meltz'aj xjal ki'j—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yaltzen te Jesús, otktzen txi'xin tuj tnom te Betania tja jxin Simón e yaabt tu'n lepra, jaj jun wik yabel tisen tx'a'c nuk ntzaj k'ey cychu'l xjal tu'n. Nchi waa'ntzen Jesús ttxa'n mes tej tpon junxuj xuuj tuya jun ni' cyeca lmet nojne tuya c'oc'sbil cyi' xjal bix wi'yelxsen. Bix e jaw tjko'nxuj ttzii' lmet, bix e jax tko'nxuj c'oc'sbil cyi' xjal tuj twi' Jesús, tejxe tel baj t-xee' lmet. ");
INSERT INTO mamNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Toctzen cycye'yen cab xjal ti otk tse xuuj, bix e jaw yolen ch'inkexin: —¿Tikentzen ma pja' tyajla'n jxuuj lu jtij c'oc'sbila? ");
INSERT INTO mamNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nuket xi' tq'ueyenxuj, matle tz'oc twi' tisen twi' tc'u'j xjal te jun jnabk'i, bixetle s-ajben twi' te onl cye mebe—tz̈i tzunkexin. Bix ak'kexin ilec te xuuj. ");
INSERT INTO mamNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero bix e xi' tkba'n Jesús cyexin: —Yaa'n ilj xuja. ¿Tikentzen ete'q'uey ya'l texuj? Jtexuj ma tz'oc tbinche wi'ja, ba'n teja. ");
INSERT INTO mamNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cuma ke cyej mebewa chi temelx cyeja cyey cyxol. Ba'ntzen toc cyk'o'na ti jilel cye oj cyaja txi' cyk'o'na cye. Pero we, mlay chin tenwe cyxola. ");
INSERT INTO mamNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tej xuj xuuj lu ma tyeec'axuj cykil tanemxuj wi'j. Bix juntl. Tisentzen cyten xjal oj n-oc seet c'oc'sbil cyi'j oj nbint cyten tu'n cyxi' tuj mukbil, ju'xse ma tse jxuj xuuja ma tz'oc tko'nxuj c'oc'sbil wi'j teja mina'x ncyima, tetzen jun techel ncyamecy, bix tu'n tbaj bint nxumlal tuya c'oc'sbil tu'n nmaketa. ");
INSERT INTO mamNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tzinexix cxe'l nkba'n cyey, jaa'xja cpomela baj tumel jba'n tpocbal tyol Dios ti'j co'pbil xjal, il ti'j cbyal tpocbal ti ma tbinche jxuj xuuja wi'j. Ju'tzen cna'jalewe—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Cybajlen yolenxitl tzunxin tja Simón, bix el Judas Iscariote, jun t-xnak'atz Jesús t-xol cablajajxin. Bix e xi' Judas te yolel cyuya nintzaj cyawil na'l Dios tu'n toc tonen Judas ejee'xin tu'n ttzyet Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Toctzen cybi'n tawil na'l Dios, e jawxsen tzalajkexin, bixse e bint cyyolxin tu'n toc cyk'o'nxin tpwak Judas. Bix ak' Judas jyolte ti tten tu'n t-xi' tk'o'n Judas ja Jesús tuj cyk'ab tawil na'l Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tetzen tneel k'ij nink'ij Pascua, oj nchi waa'n xjal pan mintii' k'anel tocx, bix oj nchi byon xjal juun carnel te juun te na'l ja nink'ij lu, bixse e xi' tkanen t-xnak'atz Jesús te: —¿Jaa' tumel taja txa' kbincha'q'ueya jil carnel te tbel kwa bixse tik'ch jilel ke?—tz̈i tzunkexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Toctzen tbi'n Jesús cyyolxin, bix e xi' tchk'o'nxin ca'ba cye t-xnak'atzxin, bix e xi' tkba'nxin: —Cyucxa tuj tnom te Jerusalén. Ojtzen cypona tuj tnom, bix c'oquel noj jun xinak cywitza tuya jun xaran a'. Bix chi oquel lpey ti'j. ");
INSERT INTO mamNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ojtzen tocx jxinaka tuj jun jaa', cykanenxsen te taaw jaa' cyjulu: “Taat, ma tzaj tkanen Xnak'tzal: ‘¿Altzen cyej cwart ctzaal tk'o'na keya tu'n tbint kwaya cyuya nxnak'atza te ja nink'ija?’ tz̈i Jesús,” tz̈i cybela te taaw jaa'. ");
INSERT INTO mamNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tzultzen tyeec'an taaw jaa' jun ma' nim cwart cyey bix binnentlte tten te tcab cxo'len jaa'. Cybinchamtzen kwa jatzewe—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bix e xi'kexin tuj tnom. Bix ju'x e baj tisenx e tkba Jesús cyexin, bix ak'kexin binchal cywaxin te kale. ");
INSERT INTO mamNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tetzen n-ak' cwel klolj, bix e pon Jesús cyuya cycablaaj t-xnak'atz te waa'l jaa'j otk bina cywaxin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Maantktzen nchi waa'nxin twi' mes, tej t-xi' tkba'n Jesús: —Tzinexix cxe'l nkba'n cyey, attzen jun cyey toctz kxol, nwaa'n wuya, cxe'l k'onte we tuj biybil—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Toctzen cybi'nxin tyol Jesús, tcubxsen licy'paj ttz̈i cyi'jxin, bi'xse e naj cynaablxin tu'n ttz̈i. Bix juun n-ela cyexin ak' kanlecte te Jesús: —¿Inayenpatzen weya, Taat?—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bix aj ttzak'be'n Jesús cyexin: —Ja jun cyej cablajaj cyey nwaa'n wuyena, jaj jun cyey ncu'x mu'nte tpan junx wuya tuj lak. ");
INSERT INTO mamNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Il ti'j ncuya tisenj nbyan tuj tyol Dios tu'n nbyeta, pero ay tixse tna'xj cxe'l k'onte we. ¡Masetlpele ba'n minxet itz'j xjala!—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Maantktzen nchi waa'nxin, tej tjaw ttzyu'n Jesús jun pan, bix e xi' tkanenxin xtalbil te Dios ti' pan. Bix ak'xin piẍlcate, bix e xi' tk'o'nxin cye t-xnak'atzxin, bix e xi' tkba'nxin: —Cywaa'nx xsunj piẍen pana, cuma ja tzunj pana techlal nxumlala cwel yuchj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Cybajtzen waa'nxin pan, bix e tzaj ttzyu'nxin jun nim malbil nojne tuya vino, bix e xi' tkanenxin xtalbil ti' vino te Dios. Bix e xi' tk'o'nxin malbil te jaca juun t-xnak'atzxin tu'n tel cyc'a'n ti' vino. Bix cykilcakexin el c'ante. ");
INSERT INTO mamNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bix e xi' tkba'n Jesús cyexin: —Jatzen weya techel ntz̈q'uelja, q'uelel kojl ti' nim xjal oj ncyima. Tu'ntzen ntz̈q'uela cwela we' jun ac'aj tyol Dios cyuya xjal. Tu'ntzen weya cyamecy cwel we' te ja ac'aj tumel tu'n ti tten oj cylonte xjal cywitz tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tzinexse cxe'l nkba'n cyey mi nuket juntl maj t-xi' nc'a'nj vinowa ti'j lux ken ini'tzen texej k'ij oj woca te cawel tibaj twitz tx'otx' tuya Nmana Dios ncyimlenxitle, maxetzen cxe'l nc'a'ntl vino—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cybajlen waa'nxitl tzunxin, bix ak'kexin bitzel. Cybajtzen bitzenxin, bix e xi'kexin tc'u'j witz te Olivos te koniyan. ");
INSERT INTO mamNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Bix e xi' tkba'n Jesús cye t-xnak'atz: —Cykilcakey chi cyjel cye'yente we. Ju'tzen toc cyu'n tyol Dios. Tz̈itzen cyjulu: “Cwel nbyo'n cylel, bixse chi elel tz̈itj tcarnel,” tz̈i Dios tuj u'j. Ju'xse we oj ncyim. Chi elel tz̈itja wi'j. ");
INSERT INTO mamNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero ojtzen njatz itz'j, chin xe'l nejl cywitza tuj Galilea—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bix aj tkba'n Pedro: —Taat, amale cykilcat ke kuya cyjel cye'yente tey, pero we mlay cyaj ncye'yen wey—tz̈i Pedro te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Bix aj ttzak'ben Jesús: —Tzinexix cxe'l nkba'n tey, tex ja koniyan lu, te mintkna'x took' ey' te tcab maj, q'uelel tii'n tiiba wi'j oxe maj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero cyiwx oca tk'on tiib Pedro: —Amale mat chin cyim junx tuyey, mi'n tz'el wii'n wiib tuyey—tz̈i Pedro. Juylexsen toc cyu'nj cabtlxin t-xnak'atz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yajc'atzen ch'intl bix tex koniyan, bix e cu'xkexin tuj jun lugar jaa' ta' nim tken abech bix t-xol tzee' tken olivo, Getsemaní tbi lugar, t-xee'j witz te Olivos. Bix e xi' tkba'n Jesús cye t-xnak'atz: —Chi kequetzen cyey tzalu; matzen chixwe yolel tuya Dios—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bix e xi' tii'nxin Pedro, Santiago, bixse Juan tuyaxin. Bix ak' cwel talelxin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Bix e xi' tkba'nxin te cyoxel t-xnak'atzxin: —May'xsen tz'oc jun bis ti' wanem. Mlayxsen npawe. Chi tenc'atzen cyey tzalu. Cyimaltzen ch'in cywatla—tz̈i Jesús cye Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bix el lk'e Jesús ch'intl cyi'jxin, bix e cub mutzk'ajxin twitz Dios, bi'x e pon tibaj twitzxin twitz tx'otx'. Bix e xi' tcubsa'nxin twitzxin te Dios ka ilxix ti'j tu'n tiy'x q'uixc'aja tu'nxin, bix ka min, tu'n tel tii'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Bixsen e xi' tkanenxin cyjulu te Dios: —Ntaat, cykil ba'n tu'na. Chin tco'pa tzuna tuj ja tc'ayela. Pero yaa'n tej weya waj bint cbinel, sino ja tej alcye tey taj bint, jatzen wej waj—tz̈i Jesús te Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tbajtzen yolenxin tuya Dios, bix e pon meltz'ajxin cyi' Pedro. Nchi wutanxin tej tpon Jesús cyi'jxin. Bix e xi' tkba'nxin te Pedro: —Simón, ¿nwutanpa tzuna? Mitetpe jun hora ma tpay watl—tz̈i Jesús te Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bix e xi' tkba'n Jesús te cyoxel t-xnak'atz: —Cyiimalxix ch'in cywatla, bix chi na'n Dios, tu'n mi'n chi cub tz'aka tuj oj cyel oka. Cyey cyc'u'j cyiwte te binchal jun ti jilel ba'n, pero yaa'n cyiw cychu'la te binchal tej ti taj cyc'u'ja—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bix el Jesús cyi' t-xnak'atz juntl maj te yolel tuya Dios. Ejee' xsunj tyolxin te tneel maj, ejee' xsunj e xi' tkba'nxin te Dios te tcab maj. ");
INSERT INTO mamNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tejtzen tpon meltz'ajxin, nchi wutan t-xnak'atzxin juntl maj cyoxelxin, cuma ntzajxe mtz'e cywitzxin tu'n nim watl. Ya mintii'tl aj cytzak'be'nxin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tbajlen yolenxitltzen Jesús te toxen maj tuya Dios, tpon meltz'ajxin cyuya t-xnak'atzxin, bix e xi' tkba'nxin: —¡Jey'! ¿nchi wutanxpa tzuna? Ya o'cx xsunj. Matzen pon tumel tu'n t-xi' k'o'n jxjal Sma'n tu'n Dios tuj cyk'ab aj il. ");
INSERT INTO mamNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Chi we'wa. Lu jxin ma txi' k'onte we tzula. Ko'ka clul texin—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Maantkxsen nyolen Jesús, tej tpon Judas, jun t-xnak'atz Jesús t-xolj tcablajajxin, tuya nim xjal binnen tten tuya espada bix tuya tzee'. Chk'o'n tzunkexin cyu'n nintzaj cyawil na'l Dios, cyu'n tx'olbal ley, bix cyu'n nintzaj xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Otktzen txi' tkba'n Judas jun techel cye tzuyel ti tten oj ttzyet Jesús. Ju'tzen toc tu'n Judas cyjulu: “Al tzunj ma tz'el ntz'u'ben twitz, ja tzunj. Cytzyumtzen, bix cyii'nxsen,” tz̈i Judas tej t-xi' tkba'n cye tzuyel tej mintkna'x cypon canaxin ta' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ju' tzunj bix e xi' lk'e Judas ti' Jesús, bix e xi' tkba'n Judas te Jesús: —Xnak'tzal—tz̈i Judas, bix el ttz'u'benxin twitz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Entonces bix e xi' cyk'abxin te tzyultzte Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero attzen junxin t-xnak'atz Jesús tcub, bix e jatz tii'nxin tspadaxin, bix el ttx'omanxin jun tẍquin junxin tk'opaj tneel cyawil na'l Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bix e xi' tkanen Jesús cye xjal tzuyel: —¿Tikentzen ma chi tzaa'y tuya espada bix tuya tzee' te tzyul weya, jac'a xsunj xobel kena? ");
INSERT INTO mamNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cykilca kej k'ij lu ma chin tena cyxola te xnak'tzal cyey tuj nin tja Dios, pero mintlpe in cytzuya. Pero yaltzen ja'lewe tetzen koniyan ma chi tzaja tzyul we. Pero cykil tzunj nbaja tetzen tu'n tjapan baj twi'j tyol Dios o cyaj tz'i'bet—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Cykilca ke t-xnak'atz Jesús e cyaj cye'yen texin, bix e baj pjel okkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero attzen junk'a xjal nuk oc lpe ti' Jesús tej t-xi' cyii'n xjal jaxin tuj tnom. Yal tzunj k'a xjal nuk jun sábana toc ti'jk'a. Bix e cytzuy xjal jak'a. ");
INSERT INTO mamNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero ttzyet tzunk'a, bix e xi' ttzokpan k'aj sábana toc ti'jk'a. Ẍbikl tzunk'a tej t-xi' tzokpajk'a. ");
INSERT INTO mamNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yaltzen te Jesús, bix e xi' cyii'n xjal jaxin twitz tneel cyawil ke na'l Dios, cyuya cykil ke tcab cyawil na'l Dios, cyuyatzen cykilca ke nintzaj xjal, bix cykilca ke tx'olbal ley. Ejee'tzen xinja jun cloj at te nin cawel cyxol xjal te Israel. ");
INSERT INTO mamNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nakchtzen e xa' lpete Pedro ti' Jesús, tejxe tpon Jesús cyu'n tzuyel maan tuj tja tneel cyawil na'l Dios. Bix e cyaj ten Pedro twitz pe'n, bix e cub kexin ti' k'ak' te mek'l tiibxin cyuya ke c'ojlal te nin tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pero tunwentzen nchi jyona jxin nin cawel cyxol xjal te Israel bix ke tcab cyawil na'l Dios cab tstiwa ti' til Jesús tu'n tbyet-xin, pero min e cnet cyu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Amale nimet xjal oc tk'on tiib te tstiwa, pero min el cyyol xjal junelna. ");
INSERT INTO mamNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","At juun xjal e jaw we' bix e jaw cymeltz'u'nxin tyol Jesús cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—O tz'ocxe kbi'n keya tyol jxin lu: “Cwel nxitaj nin tja Dios e bint cyu'n xjala. Tetzen toxen k'ij oj tbint juntl tja Dios wu'n, yaa'n cyu'n xjal,” tz̈itzen xina—tz̈itzen ke tstiwa cye cawel. ");
INSERT INTO mamNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero ju'x kej xjal e kbante ja yol lu min e maje cyyol. ");
INSERT INTO mamNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ju' tzunj e jawa we' tneel cyawil na'l Dios cyxol xjal, bix e xi' tkanenxin te Jesús: —¿Mimpatii' c'aal ttzak'be'na cyi'j yola? ¿Ti toc tu'na ti'j cyyol xjal lu?—tz̈i tneel cawel te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero min ak' Jesús. Mintii' aj ttzak'be'nxin. Bix e xi' tkanen tneel cawel te Jesús juntl maj: —¿Japa teja Scy'o'n tu'n Dios, Tcwal Dios cy'iwla'n?—tz̈i tzunxin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Bix aj ttzak'be'n Jesús te tneel cyawil na'l Dios: —Inayentzen weja. Bix cyla' tzuna inayena, Jsma'n tu'n Dios, k'uklec tuj tmank'ab Dios nim tipemal tuj cya'j bix cyla' tzuna oj ntzaj twitz tx'otx' tuj muj twitz cya'j—tz̈i Jesús te cawel. ");
INSERT INTO mamNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Entonces toc tbi'n tneel cyawil na'l Dios tyol Jesús, bix el ttzakenxin ti'jxin tu'n tk'ojxin ti' tyol Jesús, cuma ka'j yol tisenj te Jesús tuj cywitz xjal. Bix e xi' tkba'n tneel cyawil na'l Dios: —¿Titzen kaj te mas tstiwa? ");
INSERT INTO mamNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ejee' xsuna ma chi oc ebinte lu tzunxin njuben yol ti' Diosa ka junxxin tuya Dios. ¿Ti toc cyu'na?—tz̈i tzunxin. Cykilca xjal e jaw yolen ka tu'nxxin bix e tbyettzen. ");
INSERT INTO mamNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Attzen naj cab xjal oc tzubente ti'jxin, bix oc makset twitzxin. Bix ak' ke xjal pjulec texin, bixse oc cykanen xjal texin: —Katzen Diosa, tzak'c'ax tu'na al s-oc pjunte tey—tz̈i ke xjal texin. Cyuyaxse ke c'ojlal tja Dios oc pjunte twitz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yaltzen te Pedro, tcub xsunxin pe'n, bix e pon juntxin xuuj tk'opaj tneel cyawil na'l Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tejtzen toc tcye'yentxin Pedro nmek'enxin tiibxin ti' k'ak', bix oc tenatxin cyey'lecte Pedro, bix e xi' tkba'ntxin: —Tuyax tey niy' tuya Jesús, aj Nazaret—tz̈i tzuntxin te Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero bix elx tii'n tiibxin: —Min. Min ntzki'nwe twitzxin. Mitetpe n-el nniy' ti'j ali'j nyoleney—tz̈i Pedro. Bix el lk'exin pe'n. Bix e jaw ok' junjil coo'. ");
INSERT INTO mamNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bix oc noj jtxin k'opaj ti' Pedro juntl maj, bix e xi' tkba'ntxin cye cabtl xjal: —Jatzen juntl xinja lepchec ti' Jesús—tz̈i tzuntxin. ");
INSERT INTO mamNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero elx tii'n tiibxin juntl maj. Yajc'atzen ch'intl bix oc cyumla'n jxjal ete'c'a pe'n ja Pedro: —Jaanxix tey lepchec ti' Jesús. Aj Galilea tey, cuma ti' yolena—tz̈i tzunkexin te Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bix ak' Pedro k'ilbel tiib: —Tzkinn Dios yaa'n jaan kenwe. Min ntzki'nwe twitzj xjal nchi yolena ti'ja—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tujxse tjaw ok' coo' te tcab maj, bix ul tuj tc'u'j Pedro ti otk tkba Jesús texin: “Te mintkna'x took' ey' te tcab maj, q'uelel tii'n tiiba wi'j oxe maj,” tz̈i Jesús te Pedro te jya'x. Tjket-xsen jun took'xin tu'n bis. ");
INSERT INTO mamNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tetzen tak' cwel spi'yen, bix oc cychmon cyiib jclojxin nin cawel, binne tten cyu'n tneel cyawil na'l Dios, tcab cyawil na'l Dios, ke tx'olbal ley, bix ke nintzaj xjal tuj nin tja Dios. Bixse e cub cyu'n tu'n t-xi' cyii'nxin Jesús twitz cawel tuj Jerusalén chk'o'n tu'n cawel tibaj Roma te cawel cyibaj xjal judío. Pilato tbi cawel. Ju'tzen tten t-xi' ak'baj Jesús twitz Pilato, ẍpo'nxin. ");
INSERT INTO mamNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tejtzen tpon Jesús, bix e xi' tkanen Pilato texin: —¿Japa teja cawel cyibaj xjal judío?—tz̈i Pilato te Jesús. Bix aj ttzak'be'n Jesús: —Ju'tzen tisenj ma tkbay—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bix nimxse oc cyumla'n ke cyawil na'l Dios ja Jesús twitz Pilato. ");
INSERT INTO mamNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ju' tzunj e xi' tkanen Pilato juntl maj: —¿Mimpatii' c'aal ttzak'be'na cye xjal? Cye'yenca tik'chj cyyol xjal ti'ja—tz̈i Pilato te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero mintii' aj ttzak'be'n Jesús, bi'xse e jaw klee' Pilato, cuma mintii' tyol Jesús aj. ");
INSERT INTO mamNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yaltzen te cawel aj Roma tten tcawbil cyibaj xjal te Israel nejl, jac'a tzunj nink'ija tz'etz ttzakpi'nxin jun xjal aj Israel tuj tzee', la' alj cykanen xjal aj Israel tu'n tetz. ");
INSERT INTO mamNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Te tzunja jnabk'i lu, tocxse junxin aj judío tuj tzee', Barrabás tbixin tuya cabtl tuyaxin aj k'oj. Jatzen Barrabás cyawilxin. Otktzen cybiyxin ke xjal aj Roma tuj jun k'oj tuya cawel te Roma. ");
INSERT INTO mamNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tisaxse cye xjal cyten, bix e baj pon nim xjal kanlte te Pilato tu'n tetz jun cye xjal aj Israel tuj tzee'. ");
INSERT INTO mamNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bix aj ttzak'be'n Pilato: —¿Cyajpey tu'n tex ntzakpi'n jxin xjal lu Cycawel judío?—tz̈i Pilato. ");
INSERT INTO mamNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ju'tzen toc tu'nxin cye xjal, cuma at tumel tuyaxin ka nuk tu'n tchi'lel cyc'u'j ke nintzaj tawil na'l Dios otk pona cyii'nxin Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero tejtzen toc cybi'n tawil na'l Dios tyol Pilato, bix ak'kexin ocsalec cyc'u'j xjal tu'n tetz Barrabás tuj tzee', yaa'n tu'n t-xi' tzakpette Jesús. Bix ja xsunja e xi' cykanenxin te Pilato. ");
INSERT INTO mamNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bix aj tkanen Pilato cye xjal juntl maj: —Jey', ¿tine cyaja tz'oc nbinchen ti'j jxjal n-oc cyk'o'na tbi “Cycawel aj judío”?—tz̈i Pilato cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bix aj cytzak'be'n xjal cyiwx: —K'onwexin twitz cruz tu'n tcyimxin—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bix aj tkanen Pilato: —Jey', ¿tine jilel ka' ma cub tbinchexin?—tz̈i Pilato. Pero bix aj cytzak'be'n xjal juntl maj mas cyiw: —¡K'onwexin twitz cruz!—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Entonces yaltzen te Pilato, cuma taj tzunxin ocxin ba'n cyuya xjal, bix etz ttzakpi'nxin Barrabás, bix e xi' tchk'o'nxin cabxin aj k'oj te k'olx tz'u'n tocxsen ch'ut twi' ti' Jesús, bix tu'n tjawxin twitz cruz. ");
INSERT INTO mamNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bix e xi' cyii'n aj k'oj ja Jesús twitz tpe'n jjaa' jaa' tocxe cawel, bix e xi' nim tz'u'n ti' Jesús. Bix oc cychmo'nxin jun tkiy'xin aj k'oj. ");
INSERT INTO mamNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bix oc cyk'o'nxin jun t-xbalen Jesús tisen tilbil t-xmaquel San Juan te tzeblte Jesús, cuma cye xjal cawel tisentzen tilbil t-xmaquel San Juan cyxbalenxin toc. Bix e cub cybincha'n aj k'oj jun tcorona Jesús nuk ch'i'xc'a, bix e cub cycutz'exin tuj twi' Jesús te cyxmucchbilxin. ");
INSERT INTO mamNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bix ak'ke aj k'oj s̈-il: —¡Axse Cycawel xjal judío!—tz̈i ke aj k'oj. ");
INSERT INTO mamNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Coc'caxse e cu'x cytz'ajaxin tuj twi' Jesús tuya jun jitx'k'aj tzee', bix ocx cytzubaxin ti' Jesús, nchi cubxetzen majexin twitz Jesús nuk te cyxmucchablxin. ");
INSERT INTO mamNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tbajlen cyxmuccha'nxitl tzunxin Jesús, bix el cyii'nxin jt-xbalen Jesús otk tz'oc cyk'o'nxin, bixse oc cyk'o'nxin jte Jesús t-xbalen tocx. Bix e xi' cyii'n aj k'oj jaxin tu'n tjawxin twitz cruz ttxa'nxe Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jaxse Jesús e xi' ikente cruz, pero mix e xcyebexin tjak' tuj be. Niy'c'atltzen junxin xjal, Simón tbixin, tman junxin Alejandro tbi bix juntlxin Rufo tbi, te jun wikxitl tnom Cirene tbi, bix ocx cyk'o'n aj k'oj jaxin tjak' cruz k'i'n tu'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bix e xi' cyii'nxin Jesús tuj jun lugar Gólgota tbi, jatzen elpeninaj “Ttemlel Tbakel Wi'ybaj.” ");
INSERT INTO mamNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tejtzen cyponxin, bix e xi' cyk'o'n xjal tc'a'xin vino smo'n tuya jun wik remeda mirra tbi, tu'n taj lk'e ch'in tchiyonel ti' Jesús. Pero min e tiik'xin. ");
INSERT INTO mamNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bixse e jaw pjet-xin tuya clavos twitz cruz. Bix ak'ke aj k'oj niq'uel la' al jun cyexin tu'n tcaman ti' t-xbalen Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tetzen beljaj tajlal hora te klax, tjaw cypjo'nxin Jesús twitz cruz. ");
INSERT INTO mamNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bix e jaw cyk'o'nxin cab letra tibaj twi' Jesús. Tz̈i cyjulu: “Cycawel judío,” tu'ntzen telniy' tiken otk jawa Jesús twitz cruz. ");
INSERT INTO mamNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Te xsunj k'ij tjaw ca'baxin alak' twitz jun cruz junx tuya Jesús, jun cyexin e jaw twitz jun cruz tuj tmank'abxin, bix juntlxin e jaw twitz cruz tuj tneẍ Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ju'tzen tten tel-len jax tyol Dios nbyan cyjulu: “Jaan tzunxin c'oquel ten cyajlal ka' xjal,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yal tzunkej xjal exc'a ttxlaj cruz jaa' tjawa Jesús, n-ocxetzen cytze'n xjal jaxin, bix nxi'xe cyyucan xjal cywi', nchi jawxetzen yolen: —¡A weena! Jatzen teja tcublel xitente nin tja Dios, bix tu'n tjaw tbincha'na te toxen k'ij. ");
INSERT INTO mamNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Katzen tbinlel tu'na ju'wa, co'pamtzen tiiba, bix tcu'tztzen twitz cruz—tz̈i ke xjal te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ju'xse tten cyoc ten cyawil na'l Dios bix ke tx'olbal ley xmucchalec te Jesús. Tz̈ikexin cyjulu: —E tco'paxin nim xjal tuya tik'ch jilel, pero yaltzen texin, mlay bint tco'pa tiibxin. ");
INSERT INTO mamNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","E tcu'tzxin twitz cruz, jxin n-oc tk'on tiib te Scy'o'n tu'n Dios bix n-oc tk'on tiib te Cawel cyibaj Israel, tu'ntzen toc kcye'yen ka jax tu'nxin, bix tu'ntzen toc kbi'nxin—tz̈i ke nintzaj cyawil na'l Dios bix ke tx'olbal ley. Hasta jaan kej xin alak' otk chi jaw pjet twitz cruz e xoo'n yol te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tejtzen tpon chil k'ij, cykilcaxse tibaj ttx'otx' judío e cwa' jun nin klolj. Oxe hora e cub klolj. ");
INSERT INTO mamNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tejtzen tcub spi'yen te oxe tajlal hora te kale, bix e jaw s̈-in Jesús cyiw tuj tyol: —¡Ndios! ¡Ndios! ¿Tiken ma chin cyja' tcye'yena?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Attzen cab xjal oc ebinte tyol Jesús, pero min el cyniy' xjal ti'j. Bix e jaw yolenkexin: —Cybinx. Luxin ntxcon Elías, tyolel Dios—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Toctzen tbi'n junxin xjal, bix e xi'xin k'ilbetz jun brat vino, bix tx'om ch'in, bix e cu'x tmu'nxin jun ttx'aken tz̈omj tuj, bix oc tẍpo'nxin twi' jun ptz'unt, bix e xi' ajkelxin oylxte te Jesús. Bix e xi' tkba'nxin: —Ko kcye'yectzen la' ka tzul Elías k'ilc'atz texin—tz̈i tzunj xin xjal. ");
INSERT INTO mamNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pero cwa tel jun twi' Jesús jatzen tcyim xinj. ");
INSERT INTO mamNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tujxse tel tanem Jesús, tej tcub rotj jma' xbalen tcub te maksbil tej cwart nintzaj xjan tuj nin tja Dios. E tzajxe rotj tuj twi' e cu'pan baj t-xee'. ");
INSERT INTO mamNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ja tzunj xin cyaj wilel aj k'oj te Roma, tcub tzunxin twitzj cruz jaa' pjo'nwa Jesús, toctzen tcye'yenxin ti tten tcyimlen, bix e tkbaxin cyjulu: —Jaxnete tej xin xinak lu Tcwal Dios texin—tz̈i tzunxin. ");
INSERT INTO mamNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bix jax at cabxuj xuuj ncye'yen nakch. Cyxol tzunxuj tocxe jxuj María Magdalena, juntlxuj María, ttxu José bix Santiago, yaa'nte Santiago t-xnak'atz Jesús, bix xsunj xuj Salomé. ");
INSERT INTO mamNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ejee'tzen xujja oc lpe ti' Jesús, bix jaan tzunkexuj oc onente Jesús tej at-xin tuj tnom te Galilea. Bix yaa'n o'cxc'a ke xuj, sino at nimtl xuuj oc lpe ti'jxin tej xi'ninxin tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Te tzunj k'ij tej tjaw Jesús twitz cruz tec'aj k'ij te nchi'tk nink'ij te ajlabl, bix nchi binchantzen xjal tik'ch cye te ja nink'ija. Cuma cye xjal judío cyxol, il ti'j tu'n tcu'x maket jun xjal cyimne tex k'ij. Ju' tzunj tetzen ch'itk tex k'ij, ");
INSERT INTO mamNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","cyiwtzen tc'u'j junxin xjal José tbi, tej tnom te Arimatea, t-xi'xin kanl t-xumlal Jesús te Pilato te mukbil. Jaantzen José toc te nintzaj xjal cyxol jclojxin nin cawel binnen tten cyu'n cyawil na'l Dios, ke tx'olbal ley, bixsen ke nintzaj xjal tuj nin tja Dios. Jax nayon texin jtoj tul-lel Tcawel Dios te cawel twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Toctzen tbi'n Pilato tyol José ka otk cyim Jesús, bix e jaw klee'xin, cuma ke cyej xjal nchi jaw twitz cruz, min ttzki'n chi cyimcye twitz cruz tex k'ij. Bix e tzaj ttxco'nxin jxin cyaj wilel aj k'oj, bix e xi' tkanen Pilato ka jax tu'n José ka otk cyim Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Toctzen tbi'n Pilato ka jax otk cyim Jesús, bixse e xi' tk'o'n Pilato tumel te José tu'n tcu'tz tii'nxin t-xumlal Jesús twitz cruz. ");
INSERT INTO mamNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Entonces bix etz tlok'o'n José jun nintzaj xbalen, bix e cu'tz tii'n José t-xumlal Jesús twitz cruz. Bix oc tbalk'exin ti' t-xumlal Jesús. Bix ocx tk'o'nxin t-xumlal Jesús tuj jun tij xak, bix oc tlomo'nxin ttzii' tuya juntl tij xak. ");
INSERT INTO mamNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Yaltzen te María Magdalena tuya María ttxu José, nchi cye'yenc tzunxuj jaa' otk tz'ocxa t-xumlal Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Te xsunj k'ij te ajlabl, tetzen juntl k'ij, ja tzunj xuj María Magdalena, tuyaj xuj María ttxu Santiago, tuya Salomé, etztzen cylok'o'nxuj c'oc'sbil cyi' xjal te c'oc'sbel t-xumlal Jesús. ");
INSERT INTO mamNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Te xsunj tneel k'ij te smant, te ncubc'a c'atxpaj t-xee' cya'j, bix e xi'kexuj ttzii' tjayel Jesús te k'olec c'oc'sbil ti' t-xumlalxin. Cwa cyponxuj te njawelc'a k'ij. ");
INSERT INTO mamNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nchi yolen tzunxuj cyil cyiibxuj tej xi'ninkexuj cyjulu: —¿Altzen ba'n tel k'in tej tij xak toc ttzii'j tjayel Jesús?—tz̈i tzunkexuj. ");
INSERT INTO mamNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero tej cypon canaxuj ti'j, toctzen cycye'yenxuj jxak toc te maksbilte, yaa'ntzen tcwa'tl jaa'j tcwa'. Otk tz'el tolj, amale ma' nimet xak. ");
INSERT INTO mamNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tej tzunj cyocxxuj tuj tjayel Jesús, bix oc cycye'yenxuj jun k'a xinak k'uklc'ak'a tej plaj te tmank'ab tjayel Jesús, toc jun ma' nu'k t-xbalenk'a, tij skopanxse. Bi'xse e jaw sey'paj kej xuj xuuj. ");
INSERT INTO mamNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero bix etz yolenk'a cyi'jxuj: —Mi'n chi jaw sey'paj cyey. Nchi jyon cyey t-xumlal Jesús aj Nazaret, jxin e jaw twitz cruz. Pero ya min-altl texin tzalu, cuma ma jaw itz'jxin juntl maj. ¡Cycye'nc'a! Min-alxin jaa'j e cwa' tenxin. ");
INSERT INTO mamNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cyucxa cykba'xsen cye t-xnak'atzxin: “Cxe'l nej te Jesús cywitza tuj tnom te Galilea, tisenx o tkbaxin. Jatztzen c'oquela cycye'yen xina,” tz̈i cybela cye t-xnak'atz Jesús. Jaxix Pedro il ti'j tu'n tbinte—tz̈ik'a cyexuj. ");
INSERT INTO mamNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Entonces bix etz ok kej xuj xuuj tuj tjayel Jesús tu'n ttz̈i cyi'jxuj. Bix tzinxsen nchi lu'lenxuj. Ya tu'n ttz̈itl cyi'jxuj, min jaa' oca cykba'nxuj. ");
INSERT INTO mamNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Texse k'ij te klaxc'a tej tjaw itz'j Jesús juntl maj, texj tneel k'ij te smant. Tejtzen tjawlen itz'jxitlxin, nejltzen el jlet-xin twitz María Magdalena, junxuj xuuj jaa' otk tz'e'la tlojo'n Jesús wuuk biman ti'jxuj. ");
INSERT INTO mamNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bix e xi'xuj kbalte cyej xin xjal oc lpe ti'jxin. Tejtzen tponxuj, tzinxsen chi ok'xin tu'n cybisxin. ");
INSERT INTO mamNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Toctzen cybi'nxin ka otk tz'oc tcye'yen María ja Jesús, bix ka i'tzxin, min el jax tuj cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tbajlenxitl tzunj ju'wa, bix el jlet-xin jun wikxitl tcye'yencxin twitz ca'ba cyej xin oc lpe ti'j Jesús. Otk chi etzxin betel ttxa'n tnom. ");
INSERT INTO mamNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Toctzen cycye'yenxin, bix aj meltz'ajkexin tuj tnom te kbalte cyej cabtlxin, pero ju'xe, min el jax tuj cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yajc'atltzen, bix el jlet-xin cywitz junlajaj t-xnak'atzxin tej nchi waa'nxin. Bix oc ilen ch'inxin cyi'jxin, cuma otk tz'el cyxoo'nxin tpocbal Jesús e cykba jxjal oc cye'yente ka otk jaw itz'jxin. ");
INSERT INTO mamNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bix e xi' tkba'n Jesús cyexin: —Cyucxatzen tuj cykil twitz tx'otx' te kbalte cye xjal ja yol te co'pbila. ");
INSERT INTO mamNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Alj ma tz'oc ebin tej yol te co'pbila, bix ma bautizarj te techel ka otk tz'oc wunak wuya, ja tzunj cco'pjel tjak' il. Pero alj min ma tz'oc ebinte, ja tzunj cwelex til twitz Dios, bix cxe'l tk'o'n Dios ejee' tuj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Cyxol tzunj ma tz'oc ke cyc'u'j wi'j, cbineltzen techel cyu'n tisen ke ja lu: Tu'ntzen wajwalela q'uelela cylojo'n biman cyi' xjal, cbinel juntl ac'aj yol cyu'n bix min otk tz'oc cyxnak'tza'n. ");
INSERT INTO mamNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bix ka ma chi cub tz'ak tuj jun il tisenj oj cyoc tx'a'n tu'n lbaj, bix ma ch'innch'e oj t-xi' cyc'a'n veneno, mintii' chi oquel i'k'en tu'n. Bix ka ma cub cyk'o'n cyk'ab cyibaj yaab tu'n tul cynaabl, c'ulel cynaabl tu'n tipemal Dios—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tbajlen yolenxitltzen Jesús cyuyaxin, bix e jax k'i'nxin tu'n Dios tuj cya'j, bix e cub kexin tuj tmank'ab Dios te cawel tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yaltzen cye t-xnak'atz Jesús, bix exkexin te xnak'tzal cye xjal ti'j tyol Jesús tuj cykil lugar, toctzen Cyaawxin onl cyexin, bix toctzen Cyaawxin yeec'l cyyolxin tuya techlal nim tipemalxin.");
INSERT INTO mamNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nim xjal o tz'oc cyipen tu'n tcub cytz'i'ben ti'j e bint tu'n Jesús tej ttenxin twitz tx'otx' kxol. ");
INSERT INTO mamNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","O cub cytz'i'ben j-oc cybi'n cyej xjal oc cyeyente j-e bint tu'n Jesús jatxe tej ttzaj tzyet taak'enxin bix e cykba tpocbalelxin te cykilca ko'. ");
INSERT INTO mamNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ju' tzunj ba'n e'la tuj nwitza jax ju'x weya cwel ntz'i'bena jti e baj texin, cuma o tz'oc wipena tu'n tjaw wii'na tumel tu'n tixix tten ti'j cykilca e baj texin jatxe titz'jlenxin. Ncub ntz'i'bena tixix tten e baj ti'jxin bix tu'n tcyaj tpocbalelxin wu'na tujxix tumel te cyey n-oc tak' Dios cyey, ");
INSERT INTO mamNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tu'ntzen telxix cyni'ya ti'j jaxxix j-o tz'oc cybi'na ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tejtzen tocx Herodes cawel tuj cytanem judío, attzen junxin pala, k'olxte chojbil il, Zacarías tbixin. Jaj xin te jun cloj pala Abías tbi. Bix at jun t-xu'lxin Elisabet tbixuj. Tiy'jil Aarónxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Cyca'bel tzunj xjal lu e xi' cyii'n cynaabl ba'nxix twitz Dios. Min-al ka' tyol cyi'jxin, cuma e xi' cynimanxin cykilca tley Dios e cyaj tk'o'n Moisés. ");
INSERT INTO mamNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kej xjal lu min-al cycwal itz'j, cuma mixbe tz'alenxuj, bix tijtlke. ");
INSERT INTO mamNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nponxetzen smant tu'n tajben jcloj Abías tuj tja Dios, e pontzen jk'ij tu'n tocx Zacarías tuj xjan cwart te patlte incienso twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","E cye'yen kej xin pala tuj cysuertexin al c'oquex tuj xjan cwart jaca juun k'ij, tisex tten cyu'nxin, bixsen e cana suerte tej k'ij tu'n tocx Zacarías te patlte incienso. ");
INSERT INTO mamNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nim xjal otk chmet tuj tja Dios tec'ax ja tocxe jxjan cwart jaa' npatja incienso, bix tej tak' pala patlte incienso, nchi ak'tltzen xjal na'l Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Maatktzen tocx Zacarías tuj xjan cwart, tej tjaw jlet jun ángel sma'n tu'n Kaaw. Tjaw tcye'yen Zacarías, wa'lc'atl ángel tuj mank'ab te altar jaa' npatja incienso. ");
INSERT INTO mamNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tej toc tcye'yenxin ángel, bi'x el tanemxin, bi'x e jaw sey'pajxin. ");
INSERT INTO mamNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bixsen e xi' tkba'n ángel te Zacarías: —Mi'n tzaj ttz̈i ti'ja. Dios tzul k'onte j-o txi' tkanena te Dios. Jxuj t-xu'la Elisabet tzul jun tcy'aala ti'jxuj, bix c'oquel tk'o'na tbi Juan. ");
INSERT INTO mamNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nimxsen ctzalajela ti'j tcwala, bix ju'x nim xjal ctzalajel ti'j, ");
INSERT INTO mamNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","cuma ctzaal tk'o'n Dios jawnex jun taak'en. Bix mlay tz'oc c'al k'e'n. Bix oj titz'j, ctemel Espíritu Santo tuya cykil tyem tuj tchunk'lal. ");
INSERT INTO mamNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bix nim xjal te Israel c'oquel cybi'n tyol tu'n cymeltz'aj tuya Dios, Cyaaw. ");
INSERT INTO mamNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ckbal Juan cyxol Israel nejl ojtzen tul Cyaaw. Ckbalxin mintii' ttz̈i ti'jxin bix tuya nim tipemalxin, tisenj e bint tu'n Elías, jxin tyolel Dios ootxa. Ckbalxin tu'ntzen toc cyak' mambaj cye cycwal, bix tu'ntzen t-xi' cyii'n cynaabl tujxix tumel twitz Dios kej xjal min tz'oc cybi'n Dios. Ckbalxin tu'ntzen binnen cyten xjal twitzj tul-len Cyaaw—tz̈i ángel te Zacarías. ");
INSERT INTO mamNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Bix e xi' tkba'n Zacarías te ángel: —¿Ti tten tu'n tel nni'ya ti'j ka jaxxix tyola? Tijtl kena, bix ju'x nxu'la tijtlxuj—tz̈i Zacarías te ángel. ");
INSERT INTO mamNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bix aj ttzak'be'n ángel: —Inayena Gabriel. Inayena tsanjel Dios ebilte tyol Dios jaa'xix ta' Dios. O chin tzaj sma'na tu'n Dios te kbalte tey jba'n tpocbalel tcwala. ");
INSERT INTO mamNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero min tocslay nyola. Ju' tzunj c'oqueley te men. Mlaytzen yoletley hasta ojxe titz'j tcwala. Amale mint tocslay nyola, pero ju' ctemela cykilj ma txi' nkba'na tey oj tpon tumel—tz̈i ángel te Zacarías. ");
INSERT INTO mamNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Yal tzunkej xjal ete'cx tuj tja Dios nchi ayontzen tu'n tetz Zacarías tuj xjan cwart, nimxsen otk chi jaw klee' mixe jun-al Zacarías eelel. ");
INSERT INTO mamNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cwatzen telelxin, pero ya mentlxin. Ya min e bintl tyolexin cyuya xjal. Nuk tuya tk'abxin e tak'xin tumel ti otk tz'oc tcye'yenxin tunwen. Ju' tzunj el cyniy' xjal ti'j otk tz'oc tcye'yenxin jun yec'bil tu'n Dios tuj xjan cwart. ");
INSERT INTO mamNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tejtzen tjapan baj jsmant tej cloj Abías tu'n cyajben tuj tja Dios, bixsen aj Zacarías tja. ");
INSERT INTO mamNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bix mas yaj, oc t-xu'lxin Elisabet preñada. Bix jwe' xjaw nuk e tenxuj tjaxuj. Mintey' ex bet-xuj. Bix e xi' tkba'nxuj: ");
INSERT INTO mamNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Jawnexsen jun xtalbil o tzaj tk'o'n Kaaw weya. Yaltzen ja'lewe mintzentii'tl nch'ixewa cyxol xjal, cuma tzultzen itz'j wala—tz̈i Elisabet. ");
INSERT INTO mamNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tetzen tkaken xjaw tel tniy' Elisabet ti'j at tal tuj tc'u'j, jaxj ángel Gabriel e yolen tuya Zacarías jax e xi' tchk'o'n Dios tuj tnom te Nazaret tuj departamento te Galilea. ");
INSERT INTO mamNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Bix e pon ángel tuj tja jun txin xuuj mintkna'x tlonte xinak, María tbitxin. Otk yolentxin tu'n tmajetxin tuya jun xinak José tbi, jun tiy'jil ktzan rey David. ");
INSERT INTO mamNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tej tocx Gabriel tuj tjatxin, e xi' tkba'n tetxin: —Ẍin tzaja k'olbel tey. O tzaj tk'o'n Dios xtalbil te tey. At Kaaw tuyey—tz̈i ángel te María. ");
INSERT INTO mamNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tej tbintetxin jyol lu, e jaw sey'pajtxin tu'n, bix ak'txin bislte ti'j: —¿Tu'n tiken ma tkba' ángel weya ju'wa?—tz̈itxin. ");
INSERT INTO mamNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pero e xi' tkba'n ángel tetxin: —Mi'n tzaj ttz̈i ti'ja, María, cuma o scy'eta tu'n Dios tu'n tk'onte jun xtalbil jawnex te tey. ");
INSERT INTO mamNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jnxi' nkba'na tey jax wu'na, cuma c'oquela preñada, bix c'alela jun tala, bix c'oquel tk'o'na tbi Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jawnexsen c'oquele tala, bix q'uelel cyniy' xjal ti'j jaxin Tcwal jawnex Dios. Bix cxe'l tk'o'n Kaaw Dios texin tu'n tcawenxin te junx maj, cuma tiy'jilx Davidxin, jxin rey e cyaj tk'o'n Dios tyol tuyaxin tu'n titz'j jun tchmanxin te cawel te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jaxin ccawel tibaj Israel te junx maj. Mintii' tbajlel tcawbilxin—tz̈i ángel te María. ");
INSERT INTO mamNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Bix e xi' tkba'n María te ángel: —¿Titzen tten ma chin oca preñada, cuma mina'x nmajewa?—tz̈i María. ");
INSERT INTO mamNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aj ttzak'be'n ángel tetxin: —Espíritu Santo cwel tibaja, bix ctemela jun rato tjak' tipemal jawnex Dios. Ju' tzunj, jtala q'uitz'jel tu'na mintii' til, bix cbyal tbi Tcwal Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jax ju'x ttzicya Elisabet, amale tijet, pero o tz'oc preñada. E cykba xjal mlay tz'alenxuj, pero ya tkaken xjaw talxuj tuj tc'u'jxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ja lu tzin tyeec'an mintii' jun mi'nt bint tu'n Dios—tz̈i ángel. ");
INSERT INTO mamNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Bix e xi' tkba'n María: —Cu. Nukle nyo'ya tajbil Kaaw. Bint-xit wi'ja tisenj ma tkbay—tz̈i María. Bix aj ángel. ");
INSERT INTO mamNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tejtzen tkbaj ju'wa, bixsen e xi' María tuj ajkelbil tu'n tpon tuj departamento te Judea, bix e pontxin tuj ttanem Elisabet, jun tnom t-xol witz tcu'xe. ");
INSERT INTO mamNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tej tpontxin, bix ocxtxin tuj tja Zacarías, bix e k'olbentxin te Elisabet. ");
INSERT INTO mamNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tejtzen tbinte Elisabet tej tjaw k'olbentxin, e jawxsen yucch talxuj tuj tc'u'jxuj, bix tu'n tipemal Espíritu Santo ");
INSERT INTO mamNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ak'xuj yolel, bix e jaw yolenxuj cyiw. Tz̈ixuj te María cyjulu: —¡Jawnex jun xtalbil ma tzaj tey cywitz niy'tl xuuj! ¡Bix at t-xtalbil Dios tibaj jtala tuj tc'u'ja! ");
INSERT INTO mamNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¡Titzen nxi'lena ma tzaja k'olbel weya, jay ttxu Waawiya! ");
INSERT INTO mamNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ya ntzki'ntla c'oquela ttxu Kaaw, cuma tej nbintiya tjaw k'olbena, nim e jaw yucch wala tuj nc'u'ja tu'n ttzalajebl. ");
INSERT INTO mamNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cuma ma tocslay tyol Kaaw, ctiik'ela nim tzalajebl, cuma cjapanelxin ti' tyolxin—tz̈i Elisabet te María. ");
INSERT INTO mamNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Bix e xi' tkba'n María: —Tuya cykil nc'u'ja cjawel nnimsa'na tbi Kaaw. ");
INSERT INTO mamNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nchin tzalaja ti' Dios, Clol weya. ");
INSERT INTO mamNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Amale minttii' wajbelela tuj cywitz xjal, pero ma tzul Dios te k'olte jun wajbela. Ja'lewe bix tuj cykilca tyem cykba' xjal ma tsicy' Dios inayena te k'olte jun jawnex woclena. ");
INSERT INTO mamNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","O tak' Dios jun jawnex xtalbil wibaja. ¡Xjanxsen tbixin! ");
INSERT INTO mamNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","At lastim tu'nxin te cyej xjal nchi niman jaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nimxsen o bint tu'nxin tu'n tipemalxin. O xcyexin cyi'j kej xjal e jaw cyniman cyiib. ");
INSERT INTO mamNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","O tz'el tii'nxin tipemal cycawbil kej cawel, bix o tzaj tk'o'nxin cyajbel kej xjal yaa'n jawnex. ");
INSERT INTO mamNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","O tzaj tk'o'nxin jun ba'n te cyej xjal at il ete'. Pero mintii' o tzaj tk'o'nxin te cyej xjal mintii' il ete' tuj cywitz. ");
INSERT INTO mamNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Bix o tzulxin te onlcye ke Israel, kej xjal e tsicy'xin tu'n cyajben texin, tu'n tjapan bajxin ti' tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","E cyaj tyolxin tuya kiy'jil Abraham tu'n ttzaj lastim tu'nxin cye tchman Abraham te junx maj, bix tu'nj o bint tu'nxin wi'ja, otzen japan bajxin ti' tyolxin—tz̈i María. ");
INSERT INTO mamNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Bix e tenle María tuya Elisabet jun oxe xjaw. Bix aj meltz'ajtxin tjatxin. ");
INSERT INTO mamNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tejtzen tpon tumel tu'n talen Elisabet, bix itz'j jun talxuj xinak. ");
INSERT INTO mamNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ke tvesint-xuj bix ke titz'enxuj e cybi otk tz'itz'j talxuj, bix e jaw tzalajke tuyaxuj ti'j jawnex xtalbil otk tzaj tk'o'n Dios texuj. ");
INSERT INTO mamNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Te twajxakan k'ij titz'jlen talxuj, bix e pon ke cyvesint-xuj bix ke cyermanaxuj tuj cyjaxuj, cuma otk pon tumel tu'n tel cpet ttz'umel twi' ttz'albil nee' te techel judíotzen nee'. Bix oc cyk'o'n xjal tbi nee' Zacarías, tisex tbi tman. ");
INSERT INTO mamNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero bix e xi' tkba'n ttxu nee': —Min. Te tbi c'oquel Juan—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pero e xi' cykba'n xjal texuj: —¿Tu'n tikentzen taja tz'oc tbi tala te Juan? Min-al Juan cyxol ke cyiy'jila—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bixsen oc cykanen xjal te tman nee' alcye tbi nee' c'oquel. Pero nuk tuya cyk'ab e yoleneke, cuma menx ta' Zacarías bix otk chquinba. ");
INSERT INTO mamNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bix e tkanen Zacarías jun tzlom, bix e cub ttz'i'benxin: “C'oquel tbi te Juan.” Bix cykilca xjal e jaw klee'. ");
INSERT INTO mamNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tejtzen tcub ttz'i'benxin ju'wa, njketltzen ttzixin, bixsen ak'xin k'olxte chjonte te Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tejtzen cybinte ke xjal cyvesint-xin ti otk baj tuj tja Zacarías, e jawxsen klee'ke, bix cykilca kej xjal najl cyxol witz te Judea e yolenke ti'j ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kej xjal e binte ti otk baj bix ak'ke bislte ti'j, bix e baj cykanen cye ke cyuya: “¿Titzele c'oquele jnee' lu?” tz̈i ke xjal. Ju'xne e jaw klee' ke xjal, cuma otk cub tk'ab Dios tibaj nee'. ");
INSERT INTO mamNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tejtzen otk jket ttzi Zacarías tu'n tyolen, bixsen e tak' Espíritu Santo tipemalxin tu'n tkbantexin tyol Dios, bix e xi' tkba'nxin: ");
INSERT INTO mamNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Jawxit nimset tbi Dios, jatzen Kaawja kibaj ejoo' Israel, cuma min ma ko el tuj tc'u'jxin, bix ma bint tu'nxin tu'n kclet, ejoo' t-xjalxin. ");
INSERT INTO mamNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ma tzaj tk'o'nxin jun Clol ke nim tipemal. Jatz q'uelela itz'j ti' tiy'jil David, jaj xin cawel ajben te Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ma japan bajxin ti'j tyolxin e cyaj tk'o'nxin ke cyu'n kej tyolelxin ajben texin jatxe ootxa. ");
INSERT INTO mamNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","E cykbaxin at tu'n tul jun Clol ke tu'n kclet tuj cyk'ab kej xjal nchi k'ojl ki'j, bix tu'n ktzakpet tjak' cycawbil kej n-el iiq'uente ke. ");
INSERT INTO mamNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ma tzaj tk'o'nxin Clol ke tu'ntzen tjapan bajxin ti'j jawnex tyolxin e cyaj tk'o'nxin cye kiy'jil, tu'n tk'ontexin lastim cye t-xjalxin. ");
INSERT INTO mamNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bix ma tzaj tk'o'nxin Clol ke tu'n tjapan bajxin ti' tyolxin tuya kiy'jil Abraham. ");
INSERT INTO mamNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","E cyaj tk'o'nxin tyolxin te Abraham tu'n cyclet tiy'jil Abraham tuj cyk'ab ke k'ojlel cyi'j. Ma tzaj tk'o'nxin te ke tu'n ktzakpet tuj cycawbil kej k'ojlel ki'j tu'ntzen mi'n bet kk'ij tuya ttz̈i ki'j, sino tu'ntzen tbet kk'ij tu'n kajben te Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tajxin tu'n t-xi' kii'n kchunk'lal sakxix bix jiquen twitzxin te cykil k'ij. ");
INSERT INTO mamNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yaltzen tey, ncy'aal, c'oquela te tyolel jawnex Dios, cuma ckbala tulel Kaaw, tu'ntzen binne cyten xjal oj tul. ");
INSERT INTO mamNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ckbala cye xjal ti tten tu'n cyclet, jaj tu'n tnajset cyil ");
INSERT INTO mamNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","tu'nj tk'ak'bil tc'u'j Kman Dios ki'j. Cuma ma tzaj k'ak'en tc'u'j Dios ki'j, ju' tzunj c'ulel jlet jun Clol ke kxol. Jaxin jun spi'yen ");
INSERT INTO mamNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","cyej xjal ete' tuj klolj bix te cyej xjal ete' tjak' t-xlequemal cyamecy. Ja tzunxin c-yec'lte ti tten tu'n kten tuj ttz̈yal—tz̈i Zacarías. ");
INSERT INTO mamNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","E tz̈'iy tcwal Zacarías bix ocxe ma xjal, bix ocx nim tnaablxin. Bix e najanxin tuj jun lugar jaa' min-al xjal najl, hasta tejxe tpon tumel tu'n t-xi' tk'umenxin tyol Dios cye Israel tuj lugar ttzii' nima' Jordán. ");
INSERT INTO mamNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tejtzen mitkna'x titz'j Jesús, ja tzunj xin cawel tibaj cykil twitz tx'otx', Augusto tbixin, e tkbaxin tu'n tjaw jun tumel te tajlal jte' xjal at twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ja jun tneel censo e bint ju'wa, bix tej tjaw censo, tocx jxin Cirenio cawel tuj Siria. ");
INSERT INTO mamNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iltzen ti'j e pja'j ke xjal tuj cytanem ke cyiy'jil te ootxa, tu'ntzen cyk'onte cyumel te jaa'ke. ");
INSERT INTO mamNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Bix najltzen José tuj tnom te Nazaret tuj departamento te Galilea. Pero tiy'jil Davidxin, bix jatztzen ttanem David Belén tuj departamento te Judea. Ju' tzunj il ti'j e xi' José tuj Belén, ");
INSERT INTO mamNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","te tz'ibl tiibxin. Bix k'i'n María tu'nxin, cuma t-xu'tlxin. Bix ch'itk talentxin. ");
INSERT INTO mamNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tejtzen cypon José tuya María tuj Belén, bix e pon tumel tu'n ttzaj itz'j taltxin. ");
INSERT INTO mamNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bix itz'j taltxin. Tneel taltxin, bix xinak. Itz'j taltxin tuj cyja alimaj, cuma mintii' cyposada e cnet tuj tnom. Bix e jaw tbo'tz'entxin nee' tuj bu's̈, bix e cu'x tcotz'ba'ntxin nee' tuj tcublel cywa alimaj. ");
INSERT INTO mamNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ttxa'nxitzen tnom te Belén attzen cab cylel najlke cyi' cycarnel. Nchi c'ojlan cycarnel te koniyan. ");
INSERT INTO mamNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tisen tii' tej tpon jlet jun tsanjel Dios tuj cya'j cywitz, bix tspi'yemal Dios e cub txakpaj cyibaj, bix e jaw sey'pajke. ");
INSERT INTO mamNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bix e tkba ángel cye cylel: —Mi'n tzaj ttz̈i cyi'ja, cuma k'i'n jun tpocbalel jun tzalajebl wu'na te cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tuj ja koniyan lu, bix tuj ja tnom lu, ttanem jxin cyiy'jila David, ma tz'itz'j Clol cyey, jxin scy'o'n tu'n Dios te cawel. ");
INSERT INTO mamNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ka cxe'l cycye'xa nee', ojtzen tcnet jun nee' cyu'na bo'tz'en tuj bu's̈ bix tcu'x tuj tcublel cywa alimaj, q'ueleltzen cyni'ya ti'j ja tzunja—tz̈i ángel cye cylel. ");
INSERT INTO mamNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tej tbaj tkba'n ángel kej yol lu, nukxix tisen tii' tjaw jlet mas nim cybaj ángel te tuj cya'j ttxlaj ángel e pon nejl. Nimxsen e jaw cynimsa'n tbi Dios, bix e xi' cykba'n: ");
INSERT INTO mamNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—¡Jawnex tbi Dios tuj cya'j! Ma tzaj tk'o'n jun xtalbil twitz tx'otx' tu'n cyten xjal tuj ttz̈yal tuya Dios—tz̈i ke ángel. ");
INSERT INTO mamNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tej cyaaj meltz'aj ke tsanjel Dios tuj cya'j, bix ak' ke cylel yolel cyxolx: —Ko'ne cyey'lte jnee' ma tz'itz'j tuj Belén, jatzen nee'ja ma k'umj tu'n Dios—tz̈i ke cylel. ");
INSERT INTO mamNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bix e xi'kexin tuj ajkelbil te cyey'lte, bix e cnet María tuya José cyu'nxin tuyax ni' ẍlak. Xukaq'uex tuj tcublel cywa alimaj. ");
INSERT INTO mamNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tejtzen cylontexin nee' tuj tcublel cywa alimaj, bix ak'kexin kbalte cye xjal ti otk tkba ángel cyexin ti' nee'. ");
INSERT INTO mamNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","E jaw klee' kej xjal e cybi cyyol kej cylel. ");
INSERT INTO mamNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yaltzen te María, mintey' ak'txin, sino nuk e jaw bisentxin ti'j cykilca otk baj. ");
INSERT INTO mamNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bix aj meltz'aj ke cylel jaa' ete' cycarnelxin, bix e jaw cynimsa'nxin tbi Dios. E xi' cyk'o'nxin chjonte te Dios ti'j cykilca otk cybixin bix otk cyilxin, bix jax e'la tuj cywitzxin ti'j e tkba ángel. ");
INSERT INTO mamNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tetzen twajxakan k'ij titz'jlen tal María, jatzen tumelj tu'n toc techel ti' ttz'albil taltxin judíotzen nee'. Te xsunj k'ij lu tej toc tbi te Jesús, jaxj tbi e tkba ángel Gabriel te María tej mitkna'x toc jlet taltxin. ");
INSERT INTO mamNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mas yaj, e xi' José tuya María tuj Jerusalén, cuma tzin tkba'n tley Moisés, oj talen jun xuuj, il ti'j tu'n t-xi' oyet jun alimaj, tu'ntzen tcyaj sak xuuj twitz Dios. Ju' tzunj, tej tpon tumel, e xi'kexin tuj tja Dios tuj Jerusalén. Bix tex k'ij tej t-xi' oyet jnee' Jesús tuj tk'ab Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","E binttzen cyu'n ju'wa tu'ntzen cynimante tley Dios. Tzin tkba'n cyjulu: “Jaca juun tneel xinak q'uitz'jel t-xol tal jun xuuj, ck'ojel tuj tk'ab Dios,” tz̈i tley Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bix tu'n cycuyante tu'nj tley Dios ti'j tx'ajbilte xuuj, e xi' cyoyen María tuya José alimaj te Dios, cuma tzin tkba'n tley Dios: “Tuya jun moj cucu' bix ka jun moj palomas il ti'j cxe'l oyet,” tz̈i tley Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Attzen junxin xjal tuj tnom te Jerusalén Simeón tbixin. Jatzen jun xinj k'i'nxix tyol Dios tu'nxin. El tniy' Simeón ti'j tu'n ttzaj tk'o'n Dios jun jawnex Cawel cye Israel la' alcye jun k'ij te clolcye, bix nayon tzunxin ti'j. Tu'n Espíritu Santo e'la tniy'xin. ");
INSERT INTO mamNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","E tkba Espíritu Santo texin tu'n mi'n cyimxin hasta ojxe toc tcye'yenxin jxjal ayonke Israel ti'j. ");
INSERT INTO mamNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tpontzen tumel, e xi' k'i'nxin tu'n Espíritu Santo tuj tja Dios. Te tzunj k'ij tej tpon cyii'n tman Jesús ja Jesús tuj tja Dios tu'n tyec'j te Dios, tisen tzin tkba'n ley. ");
INSERT INTO mamNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tej toc tcye'yen Simeón nee', bix e xi'xin chleljawte, bix e jaw tnimsa'nxin tbi Dios ti'j, bix e xi' tkba'nxin: ");
INSERT INTO mamNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Taat, ba'ntzen tu'n ncyima tuj ttz̈yal, inayenja ma chin ajbena tey, cuma ma japan baja ti' tyola. ");
INSERT INTO mamNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ma tzaj tk'o'na tu'n toc ncye'yena Jclol keya ma tzul. ");
INSERT INTO mamNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","O tsicy'a ja tu'n toc Clol cye cykilca xjal twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","C'ajbel tisen jun spi'yen cyxol xjal yaa'n judío, tu'ntzen tel cyniy' ti'j. Bix c'oquel te jun xjal mas jawnex cyxol t-xjala, kej Israel—tz̈i Simeón te Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tejtzen cybinte José tuya ttxu Jesús tyol Simeón ti' cycwal, e jaw klee'ke. ");
INSERT INTO mamNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Bix e xi' tkanen Simeón te Dios tu'n ttzaj tk'o'n Dios xtalbil te cye, bix e xi' tkba'nxin te María, ttxu nee': —Ebi'nc nyola. Ja tala lu c'oquel te kbalte ti'j ti pjel te jaca juun aj Israel, ka tu'n t-xi' tuj castiwa, bix ka tu'n tel ba'n. Nim cbinel tu'n, tu'ntzen tel cyniy' xjal ti'j ja Clol cye, pero nim xjal q'uelel iiq'uente. ");
INSERT INTO mamNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tu'nj q'uelel cyiiq'uen, cchic'ajaxeltzen ka'xsen cynaabl. Pero kej n-oc ke cyc'u'j ti'jxin, oj tbint cyu'n ju'wa, cchic'ajaxeltzen ba'n cynaabl. Yal tey, c'oquex tuj tanema jun nintzaj bisbajil ti'j tala, tisenc'a c'oquex twi' spada tuj tanema—tz̈i Simeón te María. ");
INSERT INTO mamNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","At junxuj xuuj at tuj tja Dios, Ana tbixuj. Tmeel Fanuelxuj bix tiy'jil Aserxuj. Kbal tyol Diosxuj. Ni' tijtl xsunxuj. E majexuj wuuk tyem, ");
INSERT INTO mamNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","bix e tentlxuj viuda ochenticuatro jnabk'i. Jaca k'ij ocxxuj tuj tja Dios. Cykil k'ij bix cykil ak'bil e na'nxuj Dios, bix nim maj e cub tpa'nxuj weyaj tu'n tnimanxuj Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Texsen hora nyolen Simeón tej tpon Ana jaa' tocxe María tuya José, bix ak'xuj k'olx chjonte te Dios ti'j ti otk bint tu'n Dios. Bix e xi' tkba'nxuj cye aj Jerusalén, kej otk tz'oc ke cyc'u'j ti' tulel Clol cye: —Ja tzunj ẍlak lu Clol ke—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tej cyniman María bix José alcyej tzin tkba'n tley Dios ti'j ti tten oj nitz'j jun nee', bixsen aj meltz'ajkexin jaa' najlekexin tuj tnom te Nazaret, tuj departamento te Galilea. ");
INSERT INTO mamNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bix tz̈'iyne e tz̈'iy nee', bix ocx k'o'n tipen, bix tnaabl tu'n tel tniy' ti'j, bix chic'aj el ba'n twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bix jaca tyem nche'x tman Jesús tuj Jerusalén te iy'salte jnink'ij te Pascua. ");
INSERT INTO mamNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tej tjapan Jesús cablaaj tyem titz'jlen, e xi'kexin juntl maj tuj Jerusalén te iy'sal jnink'ij, tisex tten. ");
INSERT INTO mamNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bix tej tbaj nink'ij, bix ajke María tuya José cyjaxin. Pero bix e cyaj Jesús tuj Jerusalén, bix min el cyniy' José bix ttxu ti'j ka otk cyaj. ");
INSERT INTO mamNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tuj cywitzxin tocx Jesús cyxol kej xjal junen cyuya tu'n cypon Galilea. Tejtzen cykax tu'n cywe'xin, bix ak'kexin jyolte Jesús cyxol ke cyuyaxin bix ke te cyjaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero min-al e cnet. Bixsen aj meltz'ajkexin te jyolte tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Te toxen k'ij tcyajlen tii'n tiib Jesús tej tcnet tuj tja Dios cyu'nxin. K'uklecx cyxol ke tx'olbalte tleyel tyol Dios. Toc ebilte cyyolxin bix toc kanlte tyol Dios cyexin. ");
INSERT INTO mamNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bix e jaw klee' niy'tl xjal oc ebinte tyol Jesús, cuma nimxsen tyol Dios ttzki'n Jesús, bix tuya nim ba'n tu'n e xi' ttzak'be'n cye tx'olbal ley. ");
INSERT INTO mamNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tej tocx cycye'yen María bix José tocx Jesús cyxol tx'olbal ley, e jawxsen klee'ke. Bix e xi' tkba'n ttxu te: —Wal, ¿tu'n tikentzen e cyja'y tzalu bix mintii' e tkbay keya? Nimxsen ma ko jyona ti'ja tuya tmana, pero yaj ma cneta ku'na, bix nim ma ko ajkela ti'ja—tz̈i ttxu. ");
INSERT INTO mamNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pero e xi' tkba'n Jesús cye tman: —¿Titzen min el cyni'ya ti'j ka jatzen ntiiniya tzalu tuj tja Dios? ¿Mimpatzen tz'el cyni'ya ti'j il ti'j tu'n ntena tuj taak'en Nmana?—tz̈i Jesús cye tman. ");
INSERT INTO mamNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero María bix José min el cyniy' ti'j ti e tkba Jesús ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bix e tcuyak'a tu'n tajk'a cyuya tmank'a tu'n cyponxin Nazaret. Bix e tnima tzunk'a cykilca cyyol tmank'a. Yaltzen te María, nuk e bisenxuj ti'j cykilca otk baj. ");
INSERT INTO mamNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yaltzen te Jesús, tz̈'iyne ttz̈'iy tnaabl, bix ocxin ma xjal, bix masxse elxin ba'n tuj twitz Dios bix tuj cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Otktzen bint olaaj jnabk'i tcawbil Tiberio tibaj cykilca twitz tx'otx', tej tak' Juan kbalte tyol Dios. Tej tyem, tocx xsunj jxin Poncio Pilato cawel tuj departamento te Judea, bix tocx jxin Herodes cawel tuj departamento te Galilea, bix tocx Felipe, jxin titz'en Herodes, cawel cyuj departamento te Iturea bix Traconite, bix tocx jxin Lisanias cawel tuj departamento te Abilinia, ");
INSERT INTO mamNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","bix ete'c xsunj jxin Anás bix Caifás nejenel cye pala cyxol judío. Jatzen te Juan, tcwal Zacarías, e ten jaa' min-al xjal najl. Dios e k'onte kej yol te Juan tu'n tkbante cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bix e xi' Juan tiy' tuj cykil lugar ttzii' nima' Jordán te kbalte cye judío tu'n tcyaj cyk'o'n cyil tu'n cymeltz'aj tuya Dios, tu'ntzen tnajset cyil, bix tu'n cycu'x tk'o'nxin tuj a' te jun techel otktzen chi oc tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tej tk'umente Juan ju'wa, ju'tzen e'la jaxxix tyol Isaías, jxin kbalte tyol Dios nejl. E tkba Isaías tuj tyol Dios: “Tuj jun lugar min-al xjal najl tuj, cjawel jlet jun xinak, bix ctkba' cye xjal cyjulu: ‘Tzul Kaaw tu'n tten kxol. Ju' tzunj, key xjal, cyjel cyk'o'na cyila, tu'ntzen binne cytena oj tul. ");
INSERT INTO mamNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tisentzen binne tten jun be cyu'na oj tul jun jawnex cawel. Il ti'j tu'n tbaj cynojsa'na jul tuj tbexin, bix tu'n tcub kuutz̈'it witz tuya bu'j tu'n tcyaj chk'ajlaj. Bix kej be at cyẍoquel, tu'n cycyaj jiquen, bix kej be at xak cyuj, cjawel buchet, tu'n cycyaj jiquen. ");
INSERT INTO mamNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ch'ix tpon tumel cykil xjal cyla' jun colbil ke tk'a' Dios,’ ju' ctkba' jun xjal,” tz̈i Isaías. ");
INSERT INTO mamNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nim xjal e pon ti' Juan ttzii' nima' tu'ntzen cycu'x tu'nxin tuj a'. Bix e xi' tkba'nxin cye: —Mina'x tcyaj cyk'o'na cyila. Ke cyey nuk tisen lbaj nchi el ok twitz k'ak'. Cyaj cyey tu'n cycu'xa wu'na tuj a' nuk tu'n mi'n cub castiwa cyibaja tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ka cycy'iy tu'n tcub cycastiwiya tu'n Dios cyibaja, cybinchamtzen alcyej ba'n, tu'ntzen tchic'ajax ka otk cyaj cyk'o'na cyila bix otk chi meltz'aja tuya Dios. Mi'n cykbay: “Tu'nj tiy'jil Abraham ko'ya, mlay tzaj kcastiwiya tu'n Dios, cuma t-xjal Dios ko'ya.” Yaa'n ju'wa. Cxe'l nkba'na cyey ka at xjal t-xjal Dios nuk tu'nj tiy'jil Abrahamke, cykilcatzen loj xak lu ba'n toc te t-xjal Dios, cuma attzen tipemal Dios tu'n cyoc te tiy'jil Abraham. ");
INSERT INTO mamNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jaxte tzulte castiwa cyibaj kej xjal yaa'n ba'n twitz Dios. C'oquel cyc'u'ja ti'j ja tumel lu. Taaw cab tken lo'pj c'oquel tcye'yen cyi' cyken lo'pj. Kej min cyak' cywitz, chi jawel tx'omet ttzi tx'otx', bix nuk te tuj k'ak' chi ajbela—tz̈i Juan cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bix e xi' cykanen xjal te Juan: —¿Titzen pjel keya, tu'ntzen tchic'ajax ka otk ko meltz'aja tuya Dios?—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","E xi' tkba'n Juan cye: —Jun xjal at ca'ba tcapẍeyen, il ti'j tu'n t-xi' tk'o'n jun te tej xjal mintii' tcapẍeyen. Bix jun xjal at twa, il ti'j tu'n t-xi' tk'o'n ch'in tej mintii' twa—tz̈i Juan. ");
INSERT INTO mamNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","E pon cab chmol alcabala tu'n cycu'x tu'n Juan tuj a', bix e xi' cykanen te Juan: —¿Titzen pjel keya tu'n tchic'ajax ka otk ko meltz'aja tuya Dios?—tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","E xi' tkba'n Juan cye: —Chi chmola alcabala nuk jaj tzin tkba'n ley. Mi'n chi chmona pwak nuk te cyexa—tz̈i Juan. ");
INSERT INTO mamNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bix at cabtl soldado ttzii' nima', bix e xi' cykanen te Juan: —Yajtzen keya, ¿titzen pjel keya tu'ntzen tchic'ajax tu'n kmeltz'aja tuya Dios?—tz̈ike. Bix e xi' ttzak'be'n Juan cye: —Mi'n tz'el cykanena cypwak xjal tu'n cyclet cywitza. Mi'n jaw cyxtz'imena cyi' xjal tu'n cycamana cyi'j. Mi'n nuk cub cytziy ti'j twi' cyc'u'ja—tz̈i Juan cye soldado. ");
INSERT INTO mamNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Cykil aj Israel nchi ayon tu'n tul jxjal Scy'o'n tu'n Dios te cawel, jxjal Cristo, bix kej xjal e pon ttzii' nima' e yolenke ti' Juan, ka ja Juan te Cawel at tulel, bix ka min. ");
INSERT INTO mamNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tbinte Juan ju'wa, bix e xi' tkba'nxin cye xjal: —Weya, yaa'n jawnex kena twitzj xjal tzul. Jxjal tzul, mintlpetii' woclena tu'n tel npju'na tak'el t-xaab. Weya, nuk jun techel tzin nk'o'na, jaj tu'n cycu'xa wu'na tuj a'. Pero ja tzunj xjal tzul, yaa'n nuk jun techel ctk'a', sino ctzaal tk'o'nxin Espíritu Santo te cyej cyey ma cyaj cyk'o'na cyila, bix ctzaal tk'o'nxin tu'n cyxi'y tuj k'ak' te cyej cyey min cyaj cyk'o'na cyila. ");
INSERT INTO mamNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ju'tzen tten pjel tpa'nxin kej xjal at tu'n cyclet cyuyaj xjal at tu'n cyxi' tuj k'ak', tisen jun awal triwa q'uelel tpa'nxin twitz tuya t-xc'omel. Jtwitz triwa c'oquex tuj tx'utx', pero ja tzunj t-xc'omel c'oquex tuj jk'ak' min yubtz'aj—tz̈i Juan cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ju'tzen tten tej tk'umen Juan tyol Dios cye xjal, bix tuya mastl tumel ti'j colbil cye e tk'umexin cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pero bix e pon tumel tu'n mintl e k'umen Juan tyol Dios, tu'n tyol Herodes, cuma otk tz'el tii'n Herodes t-xu'l ttzicy, Herodías tbixuj, bix otk bint mas ka' tu'nxin. Tu'n tzunj lu e xi' tkba'n Juan texin otk bint ka' tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ju' tzunj e tbinchaxin juntl tka'yelxin, jaj tu'n ocx tk'o'nxin Juan tuj tzee'. ");
INSERT INTO mamNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tej tcu'x tk'o'n Juan ke xjal tuj a', bix e pon Jesús ti'jxin, bix e cu'x tk'o'nxin tuj a'. Tejtzen tjatz Jesús tuj a', bix ak' na'l Dios, bix e jket cya'j, ");
INSERT INTO mamNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","bix e cub Espíritu Santo tibajxin tisen tcye'nc junjil cucu', bix e tzaj tk'ajk'ajel yol tuj cya'j. Tz̈i yol cyjulu: —Jay Ncwala n-oc tak'a weya. Nchin tzalaja jay ma scy'et wu'na—tz̈i Kman Dios te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tejtzen tbint jlu ti' Jesús, bixsen e xi' ttzyu'nxin jtaak'enxin otk tzaj tk'o'n Dios tu'n tbint tu'nxin cyxol xjal. Tej tak'xin ak'anal ti' taak'en Dios, otk japanxin winaklaaj jnabk'i. Bix cybi tiy'jilxin jaa' ela itz'jxin ejee' tzunj lu: Tuj cywitz xjal, tcwal José jaxin. Yaltzen te José, tcwal Elíxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yaltzen te Elí, tcwal Matat-xin. Te Matat, tcwal Levíxin. Te Leví, tcwal Melquixin. Te Melqui, tcwal Janaxin. Te Jana, tcwal Joséxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Te José, tcwal Matatíasxin. Te Matatías, tcwal Amósxin. Te Amós, tcwal Nahumxin. Te Nahum, tcwal Eslixin. Te Esli, tcwal Nagaixin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Te Nagai, tcwal Maat-xin. Te Maat, tcwal Matatíasxin. Te Matatías, tcwal Semeixin. Te Semei, tcwal Joséxin. Te José, tcwal Judáxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Te Judá, tcwal Joanaxin. Te Joana, tcwal Resaxin. Te Resa, tcwal Zorobabelxin. Te Zorobabel, tcwal Salatielxin. Te Salatiel, tcwal Nerixin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Te Neri, tcwal Melquixin. Te Melqui, tcwal Adixin. Te Adi, tcwal Cosamxin. Te Cosam, tcwal Elmodamxin. Te Elmodam, tcwal Erxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Te Er, tcwal Josuéxin. Te Josué, tcwal Eliezerxin. Te Eliezer, tcwal Jorimxin. Te Jorim, tcwal Matat-xin. Te Matat, tcwal Levíxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Te Leví, tcwal Simeónxin. Te Simeón, tcwal Judáxin. Te Judá, tcwal Joséxin. Te José, tcwal Jonánxin. Te Jonán, tcwal Eliaquimxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Te Eliaquim, tcwal Meleaxin. Te Melea, tcwal Mainánxin. Te Mainán, tcwal Matataxin. Te Matata, tcwal Natánxin. Te Natán, tcwal Davidxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Te David, tcwal Isaíxin. Te Isaí, tcwal Obedxin. Te Obed, tcwal Boozxin. Te Booz, tcwal Salmónxin. Te Salmón, tcwal Naasónxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Te Naasón, tcwal Aminadabxin. Te Aminadab, tcwal Aramxin. Te Aram, tcwal Esromxin. Te Esrom, tcwal Faresxin. Te Fares, tcwal Judáxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Te Judá, tcwal Jacobxin. Te Jacob, tcwal Isaacxin. Te Isaac, tcwal Abrahamxin. Te Abraham, tcwal Taréxin. Te Taré, tcwal Nacorxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Te Nacor, tcwal Serugxin. Te Serug, tcwal Ragauxin. Te Ragau, tcwal Pelegxin. Te Peleg, tcwal Heberxin. Te Heber, tcwal Salaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Te Sala, tcwal Cainánxin. Te Cainán, tcwal Arfaxadxin. Te Arfaxad, tcwal Semxin. Te Sem, tcwal Noéxin. Te Noé, tcwal Lamecxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Te Lamec, tcwal Matusalénxin. Te Matusalén, tcwal Enocxin. Te Enoc, tcwal Jaredxin. Te Jared, tcwal Mahalaleelxin. Te Mahalaleel, tcwal Cainánxin. ");
INSERT INTO mamNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Te Cainán, tcwal Enósxin. Te Enós, tcwal Set-xin. Te Set, tcwal Adánxin. Te Adán, tcwal Diosxin. ");
INSERT INTO mamNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tejtzen tjatz Jesús tuj a', bix etzxin tuj lugar Jordán. Ya at tzunxin tjak' tipemal Espíritu Santo, bix e xi' tii'n Espíritu Santo jaxin tuj jun lugar min-al xjal najl tuj. ");
INSERT INTO mamNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Npontltzen taaw il ti'jxin te niy'belte tnaablxin. E tenxin tuj lugar tzkij tx'otx' cya'wnak k'ij. Min e waa'nxin, bix tej tjapan baj cya'wnak k'ij, ¡otkxsen bajxin tu'n weyaj! ");
INSERT INTO mamNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Bix e xi' tkba'n taaw il te Jesús: —Katzen Tcwal Diosa, binchanc'a tzunj xaka te tway—tz̈i taaw il. ");
INSERT INTO mamNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bix aj ttzak'be'n Jesús: —Tzin tkba'n tuj tyol Dios cyjulu: “Mas il ti'j tu'n tnimante jun xjal Dios twitzj tu'n titz'j nuk tu'n twa,”—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bix e jaw tii'n taaw il ja Jesús jawne bix e xi' tyeec'an taaw il texin cykilca tnom twitz tx'otx'. Bix e tilxin cykilca tnom te jun niy' rato. ");
INSERT INTO mamNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bix e xi' tkba'n taaw il te Jesús: —Cykilca kej tnom lu tuya cykilca k'inemal cyuj cxe'l nk'o'na tey, cuma te weya o chi k'oja, bix chi xe'l nk'o'na la' al taaw waja. ");
INSERT INTO mamNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ka ma cub maje tey nwitza nniman tzuna nwitza, chi xe'ltzen nk'o'na tey—tz̈i taaw il te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero aj ttzak'be'n Jesús te: —Tzin tkba'n tuj tyol Dios cyjulu: “Nuk ja Dios cjawel cynimsa'na, bix nuk te ba'n cyajbe'ney,” tz̈i tyol Dios cye xjal—tz̈itzen Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bix e xi' tii'n taaw il ja Jesús tuj tnom te Jerusalén, bix e jaw tii'n taaw il ja Jesús maa twi' tja Dios. Bix e xi' tkba'n taaw il texin: —Ka jay Tcwal Dios, xoo'nx tiiba twitz tx'otx', tu'ntzen tel cyniy' xjal ti'ja jay Scy'o'na tu'n Dios ka min xcyima. ");
INSERT INTO mamNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mlay cyima, cuma tz'i'ben tuj tyol Dios: “Chi tzaal tk'o'n Dios tsanjel tuj cya'j te clol tey. ");
INSERT INTO mamNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ejee' chi tzyulte tey tuj cyk'ab, tu'ntzen mi'n cub tz'aka twitz tx'otx' bix tu'n mi'n tzak' tkena twi' xak,” tz̈i tyol Dios—tz̈i taaw il te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero aj ttzak'be'n Jesús te: —Tzin tkba'n tuj tyol Dios cyjulu: “Mi'n tz'oc cycyakwusa'na Dios tu'n toc cyk'o'na tuj malbil te, ka jax tu'n,” tz̈i tyol Dios—tz̈i Jesús te taaw il. ");
INSERT INTO mamNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tej mix e xcyeba taaw il tu'n t-xi' tniman Jesús ja, bixsen e cyaj tk'o'n taaw il jaxin te ayolte juntl k'ij tu'n t-xcye tibajxin. ");
INSERT INTO mamNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Bix e pon meltz'aj Jesús tuj departamento te Galilea. Nim tipemalxin k'i'n tu'nxin tu'n Espíritu Santo, bix e pon baj tpocbalelxin tuj cykilca tnom nkaylex ete'. ");
INSERT INTO mamNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ocx Jesús cyuj camon jaa' te xnak'tzabl tyol Dios, bix ak'xin kbalte cye xjal ti tten tyol Dios, bix elxin ba'n tuj cywitz cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","E ponxin tuj tnom te Nazaret jaa' otk tz̈'iyxin. Tej tpon k'ij te ajlabl, ocxxin tuj camon jaa' te k'umlte xnak'tzbil ti' tyol Dios, tisex tten tu'nxin. Tej tpon tumel, bix e jaw we'xin cywitz xjal tu'n tjaw ts̈i'nxin tyol Dios cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bix e tzaj tii'n jun xjal j-u'j tz'i'ben tu'n Isaías, jxin tyolel Dios. Bix el tlicy'pe Jesús u'j, bix e tjoyxin, bix e cnet tu'nxin alcyej e tjoyxin. Bix ak'xin s̈-ilte cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Te weya o k'oj Espíritu Santo tu'n Dios, cuma o chin scy'eta tu'n Dios tu'n t-xi' nk'umena jun ba'n tpocbalel te colbil cye xjal. Inayena sma'n te onlte ke mebe xjal, bix tu'n cytzokpaj kej ete' tuj cyk'ab ke enemiwa, bix tu'n tjket cywitz xjal mos̈, bix tu'n cyclet kej xjal at tjak' cycawbil kej yajlal xjal, ");
INSERT INTO mamNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","bix tu'n t-xi' nk'umena ma pon tumel tu'n ttzaj t-xtalbil Dios cyibaj xjal.” ");
INSERT INTO mamNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ejee' tzunj yol lu e jaw ts̈i'n Jesús tuj tu'j te Isaías. Bix e jaw tbalk'i'nxin u'j bix e xi' tk'o'nxin te c'ojlal u'j, bix e cub kexin tu'ntzen t-xi' ttx'olba'nxin tyol Dios cye ke xjal ete' tuj camon jaa'. Bix oc txle cywitz xjal ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bix e xi' tkba'nxin cye: —Jyol ma cybiy ja'lecuwe, ja'le tzuna matzen japan baj tuj chic'aj cywitza—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Cykil xjal el cyniy' ti'j ti e tkba Jesús, bix e jaw klee'ke ti'j otk tkbaxin jax xinj xjal at tulel, bix ak' ke xjal yolel cyxolx: —¿Pero yaa'mpatzen jxjal lu nuk tcwal José?—tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Bix e xi' tkba'n Jesús cye: —Ntzki'na mas yaj cykba'y weya cyjulu: “Yeec'amne ka jawnex tipemala. O kbiya e bint nim tu'na tuj tnom te Capernaum. Binchamtzen tzalu kxola, ejoo'ya xjal te ttanema, tu'ntzen kocslana ti'ja,” tz̈i cybela. ");
INSERT INTO mamNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ju'tzen cykba'y, cuma chin elel cyiiq'uena, cuma jun tyolel Dios tuj cyex cytanem n-el cyiiq'uen. ");
INSERT INTO mamNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Cxe'l nkba'na cyey ju' pjel weya tisen te Elías, jxin tyolel Dios nejl. At nim xuuj viuda tuj tx'otx' te Israel tej tcub jun weyaj tuj Israel tu'n mintii' jbal e cub oxe jnabk'i tuya kak xjaw. ");
INSERT INTO mamNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero yaa'n ju' e xi' chk'et Elías tu'n Dios cyey'lcye viuda tuj ttanemxin, sino ju' e xi' chk'et-xin cyey'lte jun viuda tuj juntl tnom Sarepta tbi, tuj tx'otx' te Sidón. ");
INSERT INTO mamNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bix ju' pjel weya tisen e baj tej xin tyolel Dios Eliseo. At jun tyem at nim xjal tuj Israel nim el k'ey cyk'ab bix cyken tu'nj yabel lepra, pero min-al jun te ttanemxin e tk'anexin. Jun wikxitl xjal e tk'anexin, jatl jxin Naaman te tnom te Siria—tz̈i Jesús cye aj Nazaret. ");
INSERT INTO mamNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tej cybinte kej xjal tuj camon jaa' tyol Jesús ju'wa, e tzaj cyk'oj xjal, ");
INSERT INTO mamNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","bix e jaw we' ke xjal bix e xi' cylich'o'nxin Jesús, bix e xi' cykitexin twitz tx'otx' tu'n tex ttxa'n tnom. Toc Nazaret tc'u'j jun witz. Bixsen e xi' cyii'nxin Jesús twi' witz tu'ntzen tetz cyxoo'nxin twitz xak. ");
INSERT INTO mamNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero nuk tisen tii' tetz jilpaj Jesús cyxolxin, bix e cu'x meltz'aj Jesús maa t-xee' witz. ");
INSERT INTO mamNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Bix e pon Jesús tuj tnom te Capernaum tuj departamento te Galilea. Jaca k'ij te ajlabl ocx Jesús tuj camon jaa', bix e xi' tk'o'nxin xnak'tzbil cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","E jaw klee' ke xjal ti'j t-xnak'tzbilxin, cuma e xnak'tzanxin tuya nim tipemal tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","At jun k'ij e pon junxin xjal tuj camon jaa'. Otk tz'oc biman ti'jxin, bix e jaw s̈-inxin: ");
INSERT INTO mamNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Ko tk'a'cja, Jesús te Nazaret! ¿Mapa tzula te k'olxte keya ejoo'ya biman tuj castiwa? Ntzki'na alcyey. Jay Tcwal Dios mintii' tila—tz̈i biman te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Bix e xi' tkba'n Jesús: —C'ola bix texa tuj ja xjal lu—tz̈i Jesús. Tbinte biman tyol Jesús, bix e cub t-xoo'n jxjala twitz tx'otx' cywitz xjal tu'n tis̈j xjal, bix etz biman tuj. Pero min is̈j te xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nimxsen e jaw klee' ke xjal ti'j lu, bix e jaw yol cyxolxxin: —¿Ti tten nuk tu'n tyolxin nchi etz ke biman tuj jun xjal? Nimxsen tipemalxin—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bix el tpocbalelxin e pon cyuj tnom ti'jxe Capernaum. ");
INSERT INTO mamNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tej tetz Jesús tuj camon jaa', e ponxin tuj tja Simón. Attzen tjii' Simón tuya, bix yaabxuj tu'n nim cyak ti'jxuj. Ejee' tzunj xjal ete' tuj tja Simón e xi' cykanen te Jesús tu'n tk'anenxin ti'jxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bix e pon lk'e Jesús jaa' tocxexuj, bix e xi' tkba'nxin tu'n tetz jyabel tuj t-xumlalxuj, bix nwe'tl cyak ti'jxuj. Tex rato njaw we'tlxuj, bix ak'xuj k'olxte waabj cye xjal tuj jaa'. ");
INSERT INTO mamNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Te xsunj k'ij te ajlabl, bix mitkna'x tex k'ij, bix e pon nimtl xjal cyuya yaab jaa' ta' Jesús. Bix e cub tk'o'n Jesús tk'ab tibaj juun yaab, bix ul cynaabl tex hora. ");
INSERT INTO mamNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bix nim xjal e pon toc biman cyi'j, bix e xi' tkba'n Jesús cye biman tu'n cyel cyi' xjal. Tejtzen cyel, e jawxsen s̈-inke: “Jay Tcwal Dios,” tz̈i ke biman te Jesús. Pero bix e xi' tmyo'n Jesús ke biman tu'n mi'n chi yolentl, cuma el cyniy' biman ti'j ka jaxin Jscy'o'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Te juntl k'ij, te jya'x, bix iy'xin tja Simón, bix e xi'xin jaa' min-al xjal. Nim xjal e jyon ti'jxin, bix e cnet-xin cyu'n, bix e cubsanke cywitz texin tu'n mi'n tziy'xin cyxol. ");
INSERT INTO mamNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero e xi' tkba'nxin cye: —Il ti'j tu'n nxi'ya cyuj cabtl tnom, tu'n t-xi' nyeec'ana cye niy'tl xjal ti tten tcawbil Dios, cuma sma'n kena tu'n Dios te kbalte tzul tcawbil Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ju'tzen tten tej t-xi' Jesús cyuj cytanem judío. Oj tponxin tuj juun tnom, bix ocxxin tuj camon jaa', bix ak'xin xnak'tzalte tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","At jun k'ij wa'lc'a Jesús ttzii' jun nima' Genesaret tbi. Nim xjal e chmet ti'jxin te ebilecte t-xnak'tzbilxin ti' tyol Dios, bix oc cycutz'en cyiib ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bix oc nojxin ti' ca'ba barc min-al xjal cyuj nka ttzii' a'. Cyaak'en jxin cyaaw barc tzyul quis̈kexin. Otktzen chi cyaj cyk'o'nxin cybarcxin, bix nchi txjon tzunxin cyxiy'paxin te k'iljawtz quis̈. ");
INSERT INTO mamNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bix ocx Jesús tuj jun barc, bix e xi' tkanenxin te taaw barc tu'n taac lk'e ch'intl barc tuj a'. Simón tbi taaw barc, bix juntl tbixin Pedro. Bix ocx ke Jesús tuj barc, bix ak'xin xnak'tzal cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tejtzen tbaj xnak'tzanxin cye xjal, e xi' tkba'nxin te Simón: —Ko'tzen. K'inx barc maa jaa' ta' nim t-xee' a', bix cyxoo'nxsa cyxiy'pay tuj a', tu'ntzen tjatz cyquis̈a—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pero aj ttzak'be'n Simón te Jesús: —Taat, ma tz'ex cykil ak'bil kquis̈ena, bix mintii' xjatz ku'na. Pero c'oquel ke nc'u'ja ti' tyola. Cxe'l kxoo'na kxiy'paya tuj a' juntl maj—tz̈i Simón te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bix e cu'x cyk'o'nxin cyxiy'paxin tuj a'. Tej tjatz, nojnexsen tuya quis̈, ya nuk tu'n tel rotjtl cyxiy'paxin. ");
INSERT INTO mamNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bix mix e xcyebatlkexin tu'n tjatz tjak' talel. Ju' tzunj e xa' cyyeec'a Simón cyk'abxin cyuya ke tuyaxin te cyej cabtl cyuyaxin tuj juntl barc tu'n cyponxin onjawtzte cyxiy'paxin. Tejtzen cypon jcabtl cyuyaxin, entera xsunkexin e jatz onente, bix cyca'bel cybarcxin e noj tuya quis̈, ya nuk tu'n tak' xe'l bajtlke tjak' a' tu'n talel. ");
INSERT INTO mamNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tejtzen toc tcye'yen Simón Pedro ti otk baj, e cubxsen majexin twitz Jesús, bix e xi' tkba'nxin: —Taat, ikch mi'n tzaj lk'ey wi'ja, cuma aj il kena—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","E tkbaxin ju'wa tu'nj e jaw klee'xin cyuya ke ak'anal tuyaxin ti'j nimxsen quis̈ e jatz cyu'nxin tu'n tipemal tyol Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jax ju'x e jaw klee' kej xin Jacobo bix Juan, kej xin tcwal Zebedeo, bix tuya Simón ejee'tzen xinja cyaaw barc. Bix e xi' tkba'n Jesús te Simón: —Mi'n tzaj ntz̈iya ti'ja. Tetzen ja'lewe mi'ntzen tz'ak'anantl tey k'iljawtz quis̈, sino jatltzen teja taak'en tu'n t-xi' tk'umena cye xjal tu'n cyoc wuyena—tz̈i Jesús te Pedro. ");
INSERT INTO mamNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bixsen e jatz cyii'nxin cybarcxin tuj a' bix e cyajke twitz tx'otx', bix e cyaj cyk'o'nxin cykilca, bixsen e xi' cytzyu'nxin cyaak'enxin tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","At juntl k'ij e pon Jesús tuj jun tnom. Bix attzen junxin xjal ncub tu'n jun yabel lepra tbi. Tejtzen toc tcye'yen jxin yaab ja Jesús, e cubxsen majexin twitz Jesús, bix e xi' tcubsa'nxin twitzxin: —Taat, n-el nni'ya ti'ja at tipemala tu'n tk'anena wi'ja, ka ba'n tuj twitza—tz̈i yaab. ");
INSERT INTO mamNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Bix e xi' tnukpa Jesús tk'ab tibaj yaab, bix oc tmoco'nxin, bix e xi' tkba'nxin: —Ba'n tuj nwitza. Tu'n tel yabel ti'ja—tz̈i Jesús. Bix tzinx yolen Jesús tej tel yabel ti' xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Bix e xi' tkba'n Jesús te: —Mi'n txi' tkba'na cye xjal ti ma baj ti'ja. Nuk o'cx tej xin pala cxe'la tyeec'a tiiba ka ba'ntla, bix k'oncx jtoybila texin tisen o tkba Moisés, tu'ntzen t-xi' tkba'n pala ya ma txjeta. Yeec'ax cyexin tu'n tel cyniy'xin ti'j at wipemala tu'n nk'anena xjal—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero amale otket tkba Jesús te yaab tu'n mi'n baj ttx'olba'n ka otk k'anj, pero elx tz̈it tpocbal tk'anbilxin. Tzajnexsen e tzaj lk'e nimxsen xjal ti'jxin te ebilte tyolxin bix tu'n cyk'anj. ");
INSERT INTO mamNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","E pon ke xjal te jyolte, pero at maj el lk'exin cyi' xjal tuj jun lugar min-al xjal tuj, bix e na'nxin Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","At jun k'ij e xi' tk'o'n Jesús xnak'tzbil cye xjal. Twitztzen Jesús at cab xjal tej cloj cyiwxsen tuj cyley judío, fariseo tbi cyclojenxin, cyuyax cab tx'olbal ley. Ejee' tzunxin e pon otk chi tzaj tuj nim tnom tuj departamento te Galilea, bix at juun otk chi tzaj tuj departamento te Judea bix tuj tnom te Jerusalén. Bix at tipemal Dios tuya Jesús tu'n tk'anen ke yaab. ");
INSERT INTO mamNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nxnak'tzan Jesús tej cypon cab xinak. K'i'n jun xjal twi' jun wetbil cyu'nxin min yucchtl t-xumlal. Cyajxin ocxkexin tunwen tu'n tcub cyk'o'nxin yaab twitz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero mix ocxe cyu'nxin, cuma nim xjal. Ju' tzunj e jaxkexin twi'yen tu'n cyjapanxin twi' jaa', bix e jaw cyc'obchexin twi' jaa', bix e cu'x cyk'o'nxin yaab tuyax twetbil. E cu'pan twitz Jesús cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tej toc tcye'yen Jesús yaab cyuyax kej xjal k'ilte oc ke cyc'u'j ti'jxin tu'n tk'anj yaab tu'nxin, e xi' tkba'nxin te yaab: —Tey, ma najset tila—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tejtzen cybinte ke tx'olbal ley bix ke fariseo ja yol ka otk najset til yaab tu'n Jesús, bixse e tzaj cyk'ojxin, bix ak'kexin kanlte cyxolxxin: —¿Ti tten nyole ja xjal lu ka junx tuya Dios? Ncub t-xmuccha'nxin Dios, cuma min-alte jun ba'n tnajsante til jun xjal, nuk o'cx te Dios—tz̈i ke xjal crinsipal cyxolx. ");
INSERT INTO mamNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","N-el najtl tniy' Jesús ti'j alj nyolen cyxolx, e xi' tkba'nxin cye: —¿Tikentzen ncwa' cybisena ka mlay bint wu'na tu'n tnajset cyil xjal? ");
INSERT INTO mamNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ba'n t-xi' nkba'na te yaab: “Ma najset tila,” bix ba'n t-xi' nkba'na: “Tu'n tjaw we'y bix taja tjay.” Tuj cywitza ¿alcye mas nim t-xi'len tu'n tbint tej yaab? ");
INSERT INTO mamNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Cbinel wu'na alcyej mas nim t-xi'len cyey tuj cywitz tu'n tbint, jaj tu'n tk'anj ja yaab lu, tu'ntzen tel cyni'ya wi'ja at wipemala tzalu twitz tx'otx' tu'n tnajset cyil xjal wu'na, inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal—tz̈i Jesús. Ju' tzunj e xi' tkba'nxin tej xjal min yucch t-xumlal: —Ebintz nyola. Wey'tztzen, k'inx twetbila, bix cutxetzen tjay—tz̈i Jesús te yaab. ");
INSERT INTO mamNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tzinx yolen Jesús tej tjaw we' yaab, bix e jaw tii'n twetbil, bix aj tja. Nimxsen e jaw tnimsa'n yaab tbi Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bix cykil xjal e jaw klee', bix e jaw cynimsa'n tbi Dios. Bix e cub ttz̈i cyi'j, bix e xi' cykba'n cyjulu: “¡Bajxsen kla' jma kil ja'lewe!” tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tbajlenxetzen ju'wa, bix el bet Jesús tuj tnom. Bix tej texxin twitz jun jaa' jaa' n-ele kanet alcabala, taac tcye'yenxin tunwen k'uklecx jxin xjal k'ilbelte alcabala, Leví tbi. Bix e xi' tkba'nxin te Leví: —Lpetzen wi'ja tu'ntzen toc te nxnak'atza—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Bix e jaw we' Leví, bix e cyaj tk'o'nxin cykilca, bix oc lpexin ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tu'n tyeec'atexin a tanemxin ti' Jesús, bix iy' tiy'sa'nxin jun nink'ij tjaxin. Nim chmol alcabala bix nim xjal tuyax Jesús e pon tja Leví te waa'l. ");
INSERT INTO mamNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kej xjal fariseo bix ke tx'olbal ley oc cycye'yenxin jlu, bix el ka' tuj cywitzxin, bix e xi' cykba'nxin cye t-xnak'atz Jesús: —¿Tikentzen nchi waa'ncxey cyuya chmol alcabala bix tuya mastl aj il?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bix e xi' tkba'n Jesús cyexin: —Kej xjal mintii' yabel cyi'j, mlay che'x tuya k'anel. Ja tzunkej xjal yaab, il ti'j nche'x tuya k'anel. ");
INSERT INTO mamNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ju'x xsunkej xjal aj il. Min o chin ula te cyej xjal mintii' cyil tuj cywitz tu'n tcyaj cyk'o'n cyil, sino o chin ula te cyej xjal n-el cyniy' ti'j aj ilke tu'n tul cyil tuj cyc'u'j—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mas yajtl at cabtl xjal e xi' cykba'n te Jesús: —¿Titzen tten kej tey t-xnak'atz min ncub cypa'n weyaj? Ja tzunkej te Juan t-xnak'atz, nim maj ncub cypa'n weyaj bix nchi na'n Dios, tisex kej xin lepch ti' cyley fariseo. Ja tzunkej tey t-xnak'atza, min ncub cypa'n weyaj. Nuk nchi waa'ncye—tz̈i ke xjal te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aj ttzak'be'n Jesús: —¿Titzen nbaj ti' jun mejoblenel? Oj nchi pon xjal ti' mejoblenel, ¿tzimpa cub cypa'n weyaj? Min, cuma tumel tu'n cyiy'san xjal tuya chmilbaj. ");
INSERT INTO mamNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ju'tzen cye nxnak'atza. Tisen nchi tzalaj ke xjal tuya chmilbaj, ju'xse nchi tzalaj ke nxnak'atza wuyena, cuma ntiina cyuya. Mas yaj, oj wel k'i'na cyi'j, ejee'tzen nxnak'atza chi cyjel tuj bis bix cweltzele cypa'n weyaj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bix e xi' tk'o'n Jesús juntl xnak'tzbil cye xjal. E xi' tkba'nxin: —Min-al jun xjal jac'a jatz tii'n jun tkiy' remyent ti' jun ac'aj xbalen tu'n tcu'x te remyent ti' jun xbalen k'anak, cuma yaa'n tumel tu'n tcyaj jun oyaj ti'j ac'aj, bix ju'x jremyent ac'aj oj tcu'x ti'j xbalen k'anak, tii'n tcye'nc mlay tz'el junx. ");
INSERT INTO mamNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jax min-al jun xjal cwel tk'o'n vino ac'aj tuj jun tz'u'n k'anak, cuma ka ma cub tk'o'n ju'wa, q'uelel rotj tz'u'n tu'n vino oj tel ipc'aj. Ju'tzen tten cxe'l tz'u'n tuj il tuyax vino q'uelel koj. ");
INSERT INTO mamNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ju' tzunj, oj ncub vino ac'aj tuj tz'u'n, il ti'j tu'n tcub tuj tz'u'n ac'aj. ");
INSERT INTO mamNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","J-ac'aj vino tisenj weya nxnak'tzbil. Ac'aj jnxi' nxak'tzana, bix mlay tmojba tiib tuyaj xnak'tzbil te ootxa. Kej xjal cycy'i nxnak'tzbila tisen kej xjal nuk jaj vino k'anak cyaj, bix cycy'i vino ac'aj. “Masxse ba'n jk'anak,” tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te juntl maj exc'a Jesús tuj triwa cyuya ke t-xnak'atz. Tujc'a jun k'ij te ajlabl, jk'ij xjan cyxol judío. Bix iy' cyii' ke t-xnak'atzxin cab twitz triwa, bix el cysk'uchexin t-xc'omel tuya cyk'abxin, tu'n t-xi' cywaa'nxin twitz. ");
INSERT INTO mamNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Lepchtzen cyxi' kej xjal fariseo ti' Jesús, bix tejtzen toc cycye'yenxin n-el cyii'n t-xnak'atz Jesús tspigayil triwa, n-octzen cykaneltlxin te Jesús: —¿Tikentzen tzin tcuyana tu'n tel cyii'n tuyey twitz triwa tuj ja k'ij lu te ajlabl? Tzin tkba'n ley yaa'n tumel jtzin cybincha'na—tz̈i ke fariseo, cuma cyiw tuj cyley. ");
INSERT INTO mamNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Aj ttzak'be'n Jesús cyexin: —¿Bajxpatzen txa' cycye'yena tuj tyol Dios ti e baj te kiy'jil David cyuya ke tuyaxin tej toc nim tak' weyaj cyexin jun maj? ");
INSERT INTO mamNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ocx David tuj tja Dios bix etz tii'nxin jpan k'o'n te Dios. Amale tzint tkba'n ley ja xjan pan lu o'cx te cyej xin pala ba'n t-xi' cywaa'nxin, pero e xi' twaa'n David, bix e xi' tk'o'nxin te cywa ke tuyaxin, cuma otkxsen chi cyimxin tu'n weyaj. Katzen ba'n o txi' twaa'nte David jpan bix tu'n t-xi' tk'o'n cye ke tuyaxin, jaxse ju'x weya, mas ba'n tu'n ncuyanteya tu'n t-xi' cywaa'n nxnak'atza triwa ja'lewe, ");
INSERT INTO mamNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","cuma inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal, taaw jk'ij te ajlabl—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tuj juntl k'ij te ajlabl, ocx Jesús tuj juntl camon jaa', bix ak'xin xnak'tzal cye xjal. Bix at junxin xjal otk tz'el tanem tk'abxin. Min yucchtl tk'abxin te tmank'abxin. ");
INSERT INTO mamNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bix ete' tzunj xin tx'olbal ley bix ke fariseo. Bixsen oc cyc'u'jxin ti' Jesús ka tu'n tk'anenxin cyi' xjal tuj k'ij te ajlabl, tu'ntzen tcub tz'akxin tuj cyexin cyley. ");
INSERT INTO mamNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero el tniy' Jesús ti'j ti iy' tuj cyc'u'jxin. Ju' tzunj e xi' tkba'n Jesús tej xin cyimnen tk'ab: —We'wey, bix ju'tzen cwel we'y cywitz xjal—tz̈i Jesús. Bix e cub we'xin jaa' otk tkba Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Bix e xi' tkba'n Jesús cye fariseo: —Cxe'l nkanena cyey, ¿tzimpa tcuyan tley Moisés tu'n tbint jun ba'n tuj k'ij te ajlabl, bix ka tu'n tbint jun ka'? ¿Tzimpa tkba'n kley tu'n tk'anj xjal, bix ka tu'n tbyet xjal?—tz̈i Jesús, cuma el tniy'xin ti'j e cyajbe tu'n tbyet-xin. ");
INSERT INTO mamNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ocx tcye'yen Jesús tuj cywitzxin cykil xjal, pero min-al ak'. Bix e xi' tkba'n Jesús te yaab: —Nukpinx tk'aba—tz̈i Jesús. E xi' tnukpi'nxin tk'abxin, bix ul tnaabl tk'abxin. ");
INSERT INTO mamNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero yalx cye fariseo, nimxe e tzaj cyexin cyk'oj, bix nim e yolenkexin tu'n ti tten tu'n tcub cybyo'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Attzen jun k'ij ex Jesús na'l Dios cyxol witz jaa' min-al xjal. Ex ak'bil tna'nxin Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tej tul k'ij, e tzaj ttxco'nxin kej xin oc lpe ti'jxin, bix etz tscy'o'nxin cablaaj t-xnak'atzxin cyxol, bix e xi' tkba'nxin cye: —Ejee'y chi oquel te nxela—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kej cablaaj t-xelxin ejee' tzunj lu: Simón, jxjal oc tbi te Pedro tu'n Jesús, bix tuyax titz'en Pedro, Andrés, tuya Jacob, tuya Juan, tuya Felipe, tuya Bartolomé, ");
INSERT INTO mamNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","tuya Mateo, tuya Tomás, tuya Jacobo, tcwal Alfeo, tuya Simón, jxjal tk'on tiib tuj k'oj nejl tu'n cytzakpinte judío tjak' tcawbil Roma, ");
INSERT INTO mamNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","tuya Judas, tcwal Jacobo, tuya Judas Iscariote, jxjal e xi' tq'ueyen Jesús tuj cyamecy mas yaj. ");
INSERT INTO mamNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tej tetz tscy'o'nxin kej t-xnak'atzxin lu, bix e cu'x tii'nxin ke t-xnak'atzxin, bix e ponkexin tuj jun chk'ajlaj. Bix nimxsen xjal e pon jaa' wa'lc'a Jesús. At xjal te Judea bix te Jerusalén bix at xjal te mlaj tx'otx' ttzii' mar te mediterráneo cyej tnom te Tiro bix Sidona. ");
INSERT INTO mamNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","E pon ke xjal te ebilte t-xnak'tzbilxin bix tu'n cyk'anj tu'nxin. Bix kej otk tz'oc biman cyi'j, bix el tii'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bix cykilxse xjal oc cyipen tu'n toc cymaco'n jaxin, cuma tej tpon canan cyk'ab ti'jxin, n-ultltzen cynaabl tu'n tipemalxin. ");
INSERT INTO mamNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Bix oc tcye'yen Jesús cywitz t-xnak'atzxin, bix e xi' tkba'nxin cye cyjulu: —Ejee'y mebe, at t-xtalbil Dios cyibaja, cuma ck'ojel cyey tu'n cycawena tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ejee'y at weyaj cyey ti' Dios ja'lewe, at t-xtalbil Dios cyibaja, cuma cnool cyanema. Ejee'y nchi ok' ja'lewe, at t-xtalbil Dios cyibaja, cuma chi tzalajela. ");
INSERT INTO mamNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ka ma chi el iiq'uena cyu'n xjal, bix ka ma chi el xoo'na cyu'n xjal, bix ka ma chi xmucchaja cyu'n xjal, bix ka ma tkbaj ka' xjalkey nuk tu'nj nche'x lpey wi'ja, ");
INSERT INTO mamNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ka ju' n-oc bint cyi'ja, chi tzalajxa bix chi tenx aleyre, cuma jaxte ctk'a' Dios nim t-xel tuj cya'j. Ju'x e baj cye tyolel Dios te ootxa. ");
INSERT INTO mamNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero ja tzunkej k'ina, lastimke, cuma nuk ja'lewe at cyk'inemal. ");
INSERT INTO mamNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bix xsunkej nojne cyc'u'j ja'lewe, lastimke, cuma c'oquel tak' weyaj cye. Bix xsunkej nchi tze'n ja'lewe, lastimke, cuma tzul bisbajil cye bix chi ook'el. ");
INSERT INTO mamNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bix xsunkej njaw nimset cybi cyu'n cykilca xjal te twitz tx'otx', lastimke, cuma ejee' tzunja tisen kej ẍtak' kbal tyol Dios te ootxa. Jax ju'xkewe, e jaw nimset cybi cyu'n cykilca xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero jatzen cyey, ejee'y n-oc ebinte nyola, cxe'l nkba'na cyey il ti'j c'oquel cyak' cyey kej xjal nchi k'ojl cyi'ja. Cyk'onx jun ba'n te cyej n-el cyiiq'uen ejee'y. ");
INSERT INTO mamNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cykanenxa te Dios tu'n ttzaj tk'o'n xtalbil cyibaj kej nchi sbun cyi'ja. Chi na'na Dios cyi'kej nchi yasen cyi'ja. ");
INSERT INTO mamNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ka ma txi' ttz'ajen jun xjal tk'o'txa, cxe'l tk'o'ntla juntle tu'ntzen t-xi' ttz'ajen. Ka ma tz'el tii'n jun xjal tcapẍeyena, bix ka taj tuyax tcamisa, k'onxa te. ");
INSERT INTO mamNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ka at jun xjal ma tkane jun tiixja tey, k'onxa te. Ka ma tz'el talk'a'n jun xjal ti'ja, mi'n cub ttzyu'na tu'n tel tii'na te j-otk tz'el talk'a'n. ");
INSERT INTO mamNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ka taja tu'n tbint jun ba'n tey cyu'n xjal, tneel ctbinchay jun ba'n cye. ");
INSERT INTO mamNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ka ma tz'oc tak' tey nuk jaj xjal n-oc tak'a te, yaa'n jawnex jlu twitz Dios, cuma jax ju'x kej xjal aj il n-oc cyak' cyuya cye. ");
INSERT INTO mamNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bix ka ma tbinchay jun ba'n nuk tej xjal o tbincha jun ba'n tey, yaa'n jawnex jlu twitz Dios, cuma jax ju'x kej aj il nbint cyu'n ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bix ka nmanana pwak nuk tej xjal jaa' cmanalatla mas yaj, yaa'n jawnex jlu twitz Dios, cuma jax ju'x kej xjal aj il chi manal cyej xjal jaa' ba'n tu'n cymananatl cyxol. ");
INSERT INTO mamNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero weya, cxe'l nkba'na cyey, il ti'j c'oquel cyak' cyey kej xjal nchi k'ojl cyi'ja, amale mi'nt tz'oc cyak'a cye. Bix il ti'j chi binchala jun ba'n cye, amale mi'nt cybincha jun ba'n cyey. Bix il ti'j chi manala cyuya, amale mi'nt cymana cyey te t-xel. Ka ma bint cyu'na ju'wa, tk'a' Dios nim t-xel te cyey, bix ejee' tzuna chi yec'lte k'i'ntzen tnaabl jawnex Dios cyu'na, cuma ntzaj tk'o'n Dios t-xtalbil tibaj kej xjal ka' bix min nchi k'on chjonte te. ");
INSERT INTO mamNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","C'oquel cyk'o'na lastim cye xjal, tisente Kman Dios nk'on lastim cyey. ");
INSERT INTO mamNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mi'n chi yolena ti' cyuyey, bix mi'n cykba'y ka'ke cyuyey, cuma ka ma bint cyu'na ju'wa, ju'x pjel cyi'ja. Pero ka ma cub cynajsa'na cyil ke cyuyey oc cybincha'n cyi'ja, jax cwel najset cyey cyil tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ka ma chi xtalena cye xjal, jax chi xtalel ke xjal cyey. Cnool cypay cyu'n tuyaj ba'n, bix cwelex cutz'et, bix cjawel tz̈tet, tu'ntzen tcu'x nim tuj, hasta ojxe ttzt'et. N-oc tcye'yen Dios la' ti cyey nxi' cyk'o'n cye xjal, bix ctk'a' t-xel cyey—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jax ju'x e cyaj tk'o'n Jesús cabtl techel cye: —¿Ba'mpa t-xi' tyeec'an jun mos̈ be te juntl mos̈? ¿Yaa'mpatzele junx chi xe'l tz'ak tuj jun jul? ");
INSERT INTO mamNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jaxse ju'x jun maystro tuya jun t-xnak'atz. Ka min tz'el tniy' maystro ti'j, jax cyjel t-xnak'atz min tz'el tniy' ti'j, cuma jun xjal nxnak'tzan mlay tz'el tniy' ti'j mas twitz tmaystro. Bix la' alcye n-oc t-xnak'tza'n maystro te, jaxsen cbinel tu'n. Junxsen q'uelele t-xnak'atz tuya maystro. ");
INSERT INTO mamNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Tikentzen nyolena ti'j jun tuyey tocx jun ni' tz'is tuj twitz, pero min tz'el tni'ya ti'j tuj tey tocxe jun tzee'? ");
INSERT INTO mamNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Tiken nxi' tkba'na te tuyey: “Q'ueletz wii'na ni' tz'is tuj twitza,” tz̈iy, pero min tz'el tni'ya ti'j at jun tzee' tuj tey twitz? Jay at tpalta, pero nbint tu'na tisenc'a mintii' tila. K'imetz jtey nejl jtzee' tuj twitza, tu'ntzen ba'n tetz tii'na jte tuyey tocx tuj twitz. ");
INSERT INTO mamNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jun tken lo'pj ba'n mlay tak' twitz yaa'n ba'n. Jax ju'x jun wik tzee' yaa'n ba'n mlay tak' twitz ba'n. ");
INSERT INTO mamNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Q'uelel kniy' ti'j ka ba'n jun tzee' bix ka yaa'n ba'n la' tii'n twitz. Mlay tz'el lo'pj te higo ti' jun tzee' at ch'utel, bix jax ju'x mlay tz'el lo'pj te uva ti' jun skman ch'i'x. ");
INSERT INTO mamNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ju'tzen japenina ke xjal. Kej xjal ba'n chi binchal ba'n, cuma tuj cyanem ta' ba'n. Pero kej xjal yaa'n ba'n, chi binchal ka', cuma tuj cyanem ta' ka'. Ti' yolen jun xjal tzin tyeec'an ti tten tuj tanem. ");
INSERT INTO mamNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Tikentzen tzin cykba'na weya: “Kaawiya jay,” tz̈ikey, pero min cybiy nyola? ");
INSERT INTO mamNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kej xjal tzin cybi'n nyola bix nbint cyu'n, cxe'l nkba'na cyey, ");
INSERT INTO mamNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ejee' tzunja tisen jun xjal njaw tbincha'n tja ba'nxix cyjelel. Tneel, cjawetz tii'n tx'otx' yaa'n cyiw, tu'n tcnet cyiw tx'otx'. Bix cwelex tk'o'n tsimyentel jaa', bix cjawel tbincha'n jaa'. Ojtzen tcub nintzaj jbal, bix ojtzen tjaw noj nima' bix c'oquel punntz'aj ti' jaa', mlay yucch jaa' bix mlay txi' tuj il, cuma binne tten. ");
INSERT INTO mamNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero kej xjal tzin cybi'n nyola pero min cyniman, ejee' tzunja tisen jun xjal min cyajxix tja ba'n. Min cu'x tk'o'n tk'uklel jaa', sino look' naj ncu'x tk'o'n tuj tx'otx'. Ojtzen toc punntz'aj a' ti' tja, niy' tz'aktl jaa', bix ju'tzen e pja' jaa'—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tejtzen tpon baj tyol Jesús cye t-xnak'atz cywitz xjal, bix e xi'xin tuj tnom te Capernaum. ");
INSERT INTO mamNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tuj tzunj ja tnoma at junxin xjal capitán cye soldado. Ja tzunj xin capitán at jun t-ak'analxin nimxsen tajbel texin. Bix oc yabel ti'j t-ak'analxin. Ya ch'itk tcyim. ");
INSERT INTO mamNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","E tbi capitán ka ba'n k'ane Jesús cyi' xjal. Ju' tzunj e xi' tsma'nxin cab nintzaj xjal cye judío tuya Jesús te cubsal cywitz te Jesús tu'n ttzaj Jesús te k'anlte jxin t-ak'analxin. ");
INSERT INTO mamNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tejtzen cypon tsanjel capitán twitz Jesús, bixsen e xi' cykba'nxin te: —Taat, ma ko tzaja cubsal kwitza tey tu'n t-xi'y k'anlte t-ak'anal capitán. Jxin ma tzaj chk'onte keya, ba'n xjal texin. Ju' tzunj kaja jac'a txi' ch'ina te k'anlte t-ak'analxin. ");
INSERT INTO mamNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Amale tet Roma texin, pero n-oc kak' ejoo' judío texin, bix o bint jun kjaya camon tu'nxin te xnak'tzabl tyol Dios—tz̈i ke sanjel. ");
INSERT INTO mamNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ju' tzunj e xi' Jesús cyuyaxin. Ch'itktzen cyponxin tja capitán, tej t-xi' tchk'o'n capitán cabtl tuyaxin te tsanjelxin, bix e xi' cykba'n tyol capitán te Jesús. —Taat, mi'n txi'tla njaya, cuma mintii' wajbela twitza. Yaa'n tumel tu'n tocxa tuj njaya, cuma aj il kena. ");
INSERT INTO mamNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bix tu'n nch'ixewa min ẍin etza njaya tu'n npona tuyey. Yal tey tulel, yaa'n il ti'j tu'n tula tuj njaya, cuma n-el nni'ya ti'j nuk tu'nj tyola ba'n tk'anj wak'anala. ");
INSERT INTO mamNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","N-el nni'ya ti'j o'cx tu'n tyola ba'n tbint tajbila, cuma jax ju'x weya o k'oj woclena te cawel. Ka ma nkba'ya te jun soldado, “Cutxey,” ka ntz̈iya, il ti'j cxe'l, bix ka ma nkba'ya te juntl soldado, “Cyixtey,” ka ntz̈iya, jax il ti'j c'ulel. Jax ju'x ka ma nkba'ya te wak'anala: “Bincham jlu,” ka ntz̈iya, jax il ti'j cbinel. Jax ju'x xsunj tey. Alcyej tzin tkba'na tu'n tbint, il ti'j cbinel—tz̈i capitán te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tej tbinte Jesús tyol capitán, e jaw klee' Jesús ti' capitán, bix e jaw sutpajxin te cyey'lte cyej xjal lepchec ti'jxin, bix e xi' tkba'nxin cye: —Cxe'l nkba'na cyey, bajxsen wila'ya jun aj Israel n-oc ke tc'u'j wi'ja tisen ja capitán lu yaa'n aj Israel ma tz'oc ke tc'u'j wi'ja—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bix aj meltz'aj ke tsanjel capitán tjaxin, bix tej cyponxin, otk tzul tnaabl t-ak'analxin. ");
INSERT INTO mamNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Te cabtl k'ij, e xi' Jesús tuj tnom te Naín. E xi' ke t-xnak'atzxin tuyaxin, cyuyax nimtl xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tej tponxin ttxa'n tnom, n-e'lelc'a jun cyimne k'i'n cyu'n xjal xi'ne tuj mukbilte. Junk'a cyimne, tal jun mebe xuuj. Nuk junx talxuj at. Nim xjal e xi' lpe ti' xuuj bix ti' cyimne. ");
INSERT INTO mamNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tej toc tcye'yen Jesús ja xuuj, oc tk'o'nxin lastim te xuuj, bix e xi' tkba'nxin texuj: —Mi'n tz'ok'a, xuuj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bix e pon lk'exin ti' tcajon cyimne, bix e cub tk'o'nxin tk'abxin tibaj, bix e we' ke xjal k'ilte. Bix e xi' tkba'nxin: —K'a cwal, we'wey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bix e jaw k'ukpajk'a, bix ak'k'a yolel. Bix e xi' tkba'n Jesús te ttxuk'a: —Lutzen tala lu—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tejtzen toc cycye'yen ke xjal jlu, nimxsen e jaw klee'ke, bix ak'ke nimsaljawte tbi Dios, bix e xi' cykba'n: —Ma tzul jun jawnex tyolel Dios kxol. Dios ma tzaj k'onte te onlte ke, ejoo' t-xjalxin—tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bix e pon tpocbalel otk tak' Dios jun jawnex tyolelxin tuj cykilca cytx'otx' judío bix cyuj tnom ti'jxe cytx'otx' judío. ");
INSERT INTO mamNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Cykilcaj e bint tu'n Jesús, ocx tpocbal te Juan Bautista tuj tzee' jaca k'ij cyu'n kej lepchec ti' t-xnak'tzbil Juan. ");
INSERT INTO mamNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Bix e ttxoc Juan ca'ba t-xnak'atz, bix e xi' tkba'nxin cye tu'n cyxi' tuya Jesús te kanlte cyjulu: “¿Japa tey Jscy'o'n tu'n Dios tu'n tul te cawel, bix ka at juntl ko ayola ti'j tu'n tul?” tz̈i cybela. ");
INSERT INTO mamNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ejee' tzunj ca'ba tsanjel Juan e ponke tuya Jesús, bix e xi' cykba'n te: —Ja Juan s-aj chk'onte keya tuyey, bix taj tu'n t-xi' kkanena tey cyjulu: “¿Japa tey Jscy'o'n tu'n Dios tu'n tul te cawel, bix ka at juntl ko ayola ti'j tu'n tul?” tz̈i Juan—tz̈i ke t-xel Juan te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tejtzen cypon t-xel Juan, nk'anen Jesús nim xjal, bix etz ke biman tuj cyxumlal xjal nuk tu'n tyolxin, bix e jaw jket cywitz ke mos̈ tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bix e xi' tkba'nxin cye: —Cyucxey tuya Juan bix cykbanx texin jnbint wu'na j-e tkba Isaías at tu'n tbint tu'n Jscy'o'n tu'n Dios. Cykbanx texin jaj ma cyila bix jaj ma cybiy. Cykbanx kej mos̈ ya lutlke nchi cye'yena, bix ke cox ya lutlke nchi bet, kej yaab tu'n tx'a'c ya lutlke ma chi k'anja, bix kej chquint ya niy'xtl tuj cywi', bix kej cyimne o chi jaw itz'j juntl maj, bix kej mebe lu n-oc cybi'n ba'n tpocbal colbil cye. ");
INSERT INTO mamNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Cyk'umenx te Juan ctzaal tk'o'n Dios t-xtalbil cyej xjal min baj cyc'u'j wi'ja, bix min cyaj cyk'o'n tu'n cyxi' lpe wi'ja—tz̈i Jesús cye tsanjel Juan. ");
INSERT INTO mamNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tej cyex tsanjel Juan, ak'tzen Jesús yolel cye xjal, bix nim ba'n yol e xi' tkba'nxin ti' Juan. E tkbaxin cyjulu: —Tej cyxi'y te cyey'lecte Juan ttzii' nima' Jordán, ¿e pompakey cuma e cyajbey tu'n toc cybi'na jun xjal yaa'n cyiw tnaabl, tisen jun tz̈'im nbaj lajpaj tu'n cyk'i'k? Min. ");
INSERT INTO mamNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Bix e pompakey nuk te cyey'lecte t-xbalen jawnex? Min. Cykilcakey cytzki'na nuk ejee' cyej xjal tuj tja cawel, jawnex cyxbalen bix nbint cyu'n nuk jaj alcye cyaj. ");
INSERT INTO mamNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Tikentzen e xa'key te cyey'lecte Juan? ¿Yaa'mpa e xi'key te cyey'lecte jun tyolel Dios? Jaxte jun tyolel Dios Juan, bix cxe'l nkba'na cyey, cyxol cykilca tyolel Dios, ");
INSERT INTO mamNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","nuk ti'j Juan tz'i'bena cyjulu: “E tkba Dios te Tcwal: ‘Cxe'l nsma'na nsanjela nejl twitza, tu'n binne cyten xjal oj tpona,’ tz̈i Dios te Tcwal,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cxe'l nkba'na cyey, cyxol tyolel Dios itz'j cyxol xjal, min-al jun ju' jawnex twitzj Juan. Pero jxjal mas ch'in tuj tcawbil Dios, ja tzunja mas jawnex twitz Juan—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tej cybinte xjal bix kej xin chmol alcabala tyol Jesús ti'j Juan, el tyol ba'n tuj cywitzxin, bix e xi' cyk'o'nxin chjonte te Dios ti' tyol Jesús, cuma otk chi cu'xxin tuj a' tu'n Juan. ");
INSERT INTO mamNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero yal cye fariseo bix ke tx'olbal ley, min e xi' cyk'o'nxin chjonte te Dios ti' Juan, cuma yaa'n cyuyaxxin otk chi cu'x tuj a' tu'n Juan. El cyxoo'nxin j-otk cub tninc'u'n Dios te cyexin. ");
INSERT INTO mamNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Bix e yolen Jesús mas cye xjal: —Key xjal n-el cyiiq'uena j-e tk'umen Juan bix ju'x jweya tzin nkba'n, ¿ti techel c'ajbel tu'n tel cyni'ya ti'j ti cytena? ");
INSERT INTO mamNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ejee' tzuna te ja'lewe tisen kej nee' tuj be cycy'i tu'n cykẍan cyuya kej nchi kẍan. Oj cykẍan kej nee' nchi kẍan tisen jun mejoblenel, cxe'l cykba'n cyekej cycy'i chi kẍan cyjulu: “Keya, n-oc kxuxen. Cyey, ¿ti min chi tzaja te bixel kuyena?” tz̈ike. Bix oj cykẍan kej nchi kẍan tisen oj ncu'x maket jun cyimne, cxe'l cykba'n cyekej cycy'i tu'n cykẍan cyjulu: “Keya, nko ook'a. Cyey, ¿ti min chi tzaja te ook'el kuyena?” tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Cxe'l nkba'na cyey, ejee'y tisenj kej nee' cycy'i chi kẍan, cuma tej tul Juan Bautista bix min ex tk'ij nwaa'n pan bix nc'an vino, e xi' cykba'na: “Jxjal lu min nbint tu'n tisenj nbint cyu'n cykilca, bix ju' tzunj ma tz'oc jun biman ti'j. Ju' tzunj, il ti'j q'uelel kiiq'uen tyol,” tz̈ikey. ");
INSERT INTO mamNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pero tej wul weya, bix min e cub npa'nwe weyaj tisen Juan, sino in waa'nwe bix in c'anwe tisex tten, tzin cykba'na cyjulu: “Jxjal lu, min cub tpa'n weyaj tisen tten kxol, sino nuk nwaa'n bix nc'an vino bix nbet cyuya chmol alcabala bix cyuya niy'tl aj il. Ju' tzunj, il ti'j q'uelel kiiq'uen tyol,” tz̈ikey. ");
INSERT INTO mamNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ja tzunkej n-el cyniy' ti'j, cchic'ajaxeltzen n-el cyniy' ti'j tu'nj tzin cyocsla'n tyol Juan bix inayena—tz̈i Jesús cyej xjal el cyxoo'n jaxin bix tyol Juan. ");
INSERT INTO mamNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Junxin xjal cyxol fariseo, Simón tbixin, e xi' ttxco'nxin Jesús tu'n tpon Jesús waa'l tuyaxin tuj tjaxin. Bix e xi' Jesús tjaxin, bix e cub kexin ti' mes. ");
INSERT INTO mamNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bix at jun e baj. Tuj tzunj tnom lu at junxuj xuuj nimxsen xinak tu'nxuj. Tej tbintexuj nwaa'n Jesús tuj tja jxin fariseo, e xi'xuj tjaxin. Bix e xi' tii'nxuj jun c'oc'sbil cyi' xjal wi'yelxsen tuj jun lmet te xak. ");
INSERT INTO mamNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bix e xi' lk'exuj ti' Jesús, bix e cub majexuj t-xee' tkenxin, bix ak'xuj ook'el. Bix e cub tx'utl ta'l twitzxuj twi' tken Jesús, bix el tsu'nxuj ta'l twitzxuj ti' tkenxin tuya ttzmal twi'xuj. Bix el ttz'u'benxuj ti' tkenxin tu'n tyeec'antexuj tnimbilxuj, bix e cub tsu'nxuj jc'o'csbil tibaj tkenxin. ");
INSERT INTO mamNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ja tzunj xin fariseo e txconte Jesús te waa'l tuyaxin, tej toc tcye'yenxin ti oc tbincha'n jxuuj aj il ti' Jesús, e cub tbisenxin ti'j: “Nuket ja xjal jlu sma'n tu'n Dios, mayetzele tz'el tniy'xin ti'j xuuja ma tz'oc maconte texin aj il xsunxuj.” ");
INSERT INTO mamNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pero el tniy' Jesús ti'j ti niy' tuj tc'u'j fariseo, bix e xi' tkba'nxin te: —Simón, at jun nyola tey—tz̈i Jesús. Bix aj ttzak'be'n Simón: —Kbantzney, taat. ");
INSERT INTO mamNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Bix e xi' tkba'n Jesús cyjulu: —At junxin xjal e xi' tk'o'nxin pwak te maan te ca'ba xjal. Attzen junxin e tmanaxin tisenj tzin tcamanxin te ca'ba jnabk'i, bix juntlxin e manan nuk tisenj tzin tcamanxin te ca'ba xjaw. ");
INSERT INTO mamNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero mix e xcyebakexin cychjontexin pwak. Ju' tzunj e xa' tkba'n jxin k'ol pwak tu'n mintii' t-xel. ¿Alcye jun cyej xjal lu cxe'l k'onte nim chjonte tej xin k'ol maan?—tz̈i Jesús te Simón. ");
INSERT INTO mamNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aj ttzak'be'n Simón: —Tuj nwitza, jaj xjal c'asbenel nim—tz̈i Simón. Bix e xi' tkba'n Jesús te: —Jax toc tu'na. ");
INSERT INTO mamNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bix aj meltz'aj Jesús cyey'lte tej xuuj tcub, bix e xi' tkba'nxin te Simón: —¿Tzimpa n-el tni'ya ti'j ti nbint tu'n ja xuuj lu? Tej ẍin oca tuj tjay, min xi' tkba'na te tk'opaja tu'n ttzaj tk'o'n a' te tx'ajbil nkena, tisenj tten ku'n. Pero ja tzunj xuuj lu, ma tz'el ttxjo'n nkena tuya ta'l twitz bix ma tz'el tsu'nxuj nkena tuya ttzmal twi'xuj. ");
INSERT INTO mamNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jatzen tey, min s-el ttz'u'bena nwitza te k'olbebl weya, pero ja tzunj xuuj lu, ch'ima maj ma tz'el ttz'u'benxuj ti' nkena jatxe tej ẍin oca tuj tjay. ");
INSERT INTO mamNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tej ẍin oca tuj tjay, tey min xjax tko'na ch'in aseyt te olivo tuj nwi'ya, tisenj tten ku'n, pero ja tzunj xuuj lu, ma cub tko'n c'oc'sbil cyi' xjal jawnexsen twi' ti' nkena. ");
INSERT INTO mamNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cykilca tzunj lu ma bint tu'nxuj, cuma n-el tniy'xuj ti'j ni'j tilxuj, amale nimet, pero ma najset. Ju' tzunj nim ma tz'oc k'ak'en tc'u'jxuj wi'ja. Pero ktzki'n jaj xjal yaa'n nimxix tzin tyeec'an jun tk'ak'bil tc'u'j, jatzen xjalja yaa'n nim til tuj twitz tu'n tnajset—tz̈i Jesús te Simón. ");
INSERT INTO mamNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bix e xi' tkba'n Jesús te xuuj: —Ma najset tila—tz̈i Jesús te xuuj cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kej xjal k'uklec ti' mes tuya Jesús bix ak'ke yolel cyxolx: —Nim o bint tu'nj xjal lu, hasta at jun najsabl til xjal tu'n. ¿Al tzunj xjal lu?—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero bix e xi' tkba'n Jesús te xuuj: —Tu'nj ma tz'oc ke tc'u'ja wi'ja, ma cleta. Cutxa tzuna. Tujtzen ttz̈yal ta'y ja'lewe tuya Dios—tz̈i Jesús te xuuj cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mas yaj e xi' Jesús tuj cabtl tnom te kbalte tpocbalel tcawbil Dios. Tuya cablaaj t-xnak'atzxin e xi', ");
INSERT INTO mamNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","cyuyax jxuuj otk tz'el tii'n Jesús biman cyi'j bix otk k'anenxin ti' cyyabel. Ejee' tzunj xuuj lu: María Magdalena, jaj xuj otk tz'el tii'n Jesús wuuk biman ti'j, ");
INSERT INTO mamNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","tuyax Juana, t-xu'l junxin xjal Chuza tbixin. Ja tzunj xin Chuza tocx te mayordomo ttxlaj gobernador Herodes. Tuyax junxuj xuuj Susana tbi. Bix nimc'atl xuuj e xi' tuya Jesús te onl texin bix cye t-xnak'atzxin tuya cyk'inemal. ");
INSERT INTO mamNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Te jun k'ij, cyul chmet nim xjal te nim tnom tu'n cybinte t-xnak'tzbil Jesús, ak'tzen Jesús xnak'tzalcye. Bix e cub tk'o'nxin jun techel cye: ");
INSERT INTO mamNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Attzen junxin xjal e xi'xin awal triwa tuj tcojbenxin. Tejtzen tak'xin tz̈itlxte iyaj, at tiyajxin e cub tz'ak tuj be. Bix e baj cywa'be xjal twitz iyaj tuj cybe, bix ul noj ke ch'it ti'j bix e jaw cywaa'njil mastl. ");
INSERT INTO mamNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Cabtl twitz iyaj e cub tz'ak twitz pc'at tx'otx'. Pero tej tjaw pok'ch, bix e cub tz̈'iyelex, bix e tzkij, cuma mintii' tcha'xel tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bix cabtl twitz iyaj e cub tz'ak cyxol twitz ch'i'x, bix e jaw pok'chke junx, bix ja ch'i'x e tz̈'iy mas bix e cyaj baj triwa tjak'. ");
INSERT INTO mamNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bix cabtl twitz iyaj e cub tz'ak tuj tbanel tx'otx', bix lwewa e jaw pok'ch, bix e tz̈'iy naj, bix e tak' nim twitz. Juun tken e tak' syent twitz—tz̈i Jesús. Tej tbaj tkba'n Jesús ja techel lu, bix e xi' tkba'nxin cyiw cye xjal: —Cyjkom cyẍquina tu'n tel cyni'ya ti' nyola, bix cybisenx ti'j—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bix oc cykanen ke t-xnak'atz Jesús te ti japenina ja yec'bil lu ti' iyaj. ");
INSERT INTO mamNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Bix aj ttzak'be'n Jesús: —Tuj ewjel ta' jnxi' nyolena cye xjal ti'j o baj tninc'u'n Dios ti' tcawbil. Te cyey, ejee'y nxnak'atza, o k'oj cyey tu'n t-xi' ntx'olba'na ti japenina kej techel. Pero te cyej niy'tl xjal, nuk jaj techel ncub nk'o'na. Ejee' tzunja tisen e tkba tyol Dios cyi'j xjal min cybi Dios: “Amale n-oquet cycye'yen, bix amale n-oquet cybi'n, pero min tz'el cyniy' ti'j,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ja'lewe cxe'l nkba'na cyey ti japenina jtechel ti' iyaj. J-iyaj tisen tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","J-iyaj e cub tz'ak tuj be, ju'tzen japenina tisenj tyol Dios n-oc cybi'n xjal pero min cyaj tuj cyanem. Lwewa n-el tii'n taaw il tuj cyanem tu'ntzen mi'n cyocsla, tu'n mi'n chi clet. ");
INSERT INTO mamNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","J-iyaj e cub tz'ak tibaj pc'at tx'otx', ju'tzen japenina tisenj tyol Dios n-oc cybi'n xjal tuya tzalajebl ti'j tuj tneel. Pero min cywix tuj cyanem, tisen tzunj awal min txi'xix tloc' tuj pc'at tx'otx'. Min cypa, cuma oj n-oc jun q'uixc'aj cyi'j, ncub bajtl cyc'u'j ti' tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ja tzunj iyaj e cub tz'ak cyxol twitz ch'i'x bix e cyim tjak' ch'i'x, ju'tzen japenina tisenj tyol Dios n-oc cybi'n xjal peroj cyachbil jaj cykilca at twitz tx'otx'. Nuk o'cx cyk'inemal cyaj bix cykil achbil twitz tx'otx', bix n-oc cyk'on cyiib ti'j cyaj, bix tu'n tzunj lu ncaman te xitbil tyol Dios tuj cyanem. Cychunk'lal tisen jun tken triwa mintii' twitz. ");
INSERT INTO mamNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero j-iyaj e cub tz'ak tuj tbanel tx'otx', ju'tzen japenina tisenj tyol Dios n-oc cybi'n xjal tuya cykil cyc'u'j. Nchi ximan ti'j, bix nbint cyu'n ti toc tu'n. Ncub cypa'n, bix cychunk'lal tisen jun tken triwa tzin tk'o'n twitz. ");
INSERT INTO mamNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","At juntl techel. ¿Jac'apatzen tzaj tii'n jun xjal jun cantil tu'n tocx ewet tjak' jun alma bix ma tjak' wetbil? ¡Min! Cwel ten twi' mes, tu'ntzen ba'n cycye'yen xjal oj cyocx tunwen. ");
INSERT INTO mamNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jaxsen ju'x cyey. Ja cantil lu tisenj nyola jaxxix nchin k'ona cyey. Ja nyola jaxxix yaa'n tu'n tcub ewet cyu'na, sino tu'n tk'umj. ");
INSERT INTO mamNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ju' tzunj, k'o'nc cyc'u'ja ti' nyola tu'n tel cyni'ya ti'j. Jxjal n-oc tipen ti'j tu'n tniman te nyola, cxe'l k'o'n tu'n tel tniy' ti'j mastl. Pero jxjal min tz'oc tipen ti'j tu'n tniman te nyola, q'uelel k'i'n j-e k'oj te—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","At jun k'ij e pon ttxu Jesús cyuya ke titz'enxin jaa' ta' Jesús, pero mix ocxeke tuj jaa' jaa' tocxe Jesús tu'n nim xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bix ocx k'umet te Jesús: —Lu ttxuy cyuya ke titz'ena wa'lc'a pe'n. Cyaj tu'n cyyolen tuyey—tz̈i ke xjal te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bix e xi' tkba'n Jesús cye xjal: —Alj n-oc tbi'n tyol Dios bix tzin tniman, jatzen xjalja wermaniya. Tisen ntxuya bix tisen witz'enke—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","At juntl k'ij ocx Jesús tuj jun barc cyuya ke t-xnak'atzxin. Bix e xi' tkba'nxin cye: —Ko iy'x jlajxe a'—tz̈i Jesús, bix ak' i'yaxke. ");
INSERT INTO mamNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tej tak' i'yel bet barc tuj a', bix e tzaj twatl Jesús. Pero bix ak' jun nintzaj cyk'i'k tibaj a'. Nimxsen oc punntz'aj a' tu'n cyk'i'k ti' barc, bix e noj barc tuya a', ya tu'n tak' xe'l tjak' a'. ");
INSERT INTO mamNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tu'ntzen ttz̈i cyk'i'k cyi'j t-xnak'atzxin bix e xi'ke yuclecx texin tu'n ttzaj q'uisjxin, bix e xi' cykba'n texin: —¡Taat! ¡Taat! ¿Ti pjel ke? ¡Ko pjel!—tz̈ike. Bix e jaw we' Jesús, bix e xi' tkba'nxin te cyk'i'k tu'n twe' bix te a' tu'n mi'n tz'oc punntz'aj, bix ya nwe' najtl cyk'i'k tuya a', bix ncyajtl tuj tumel. ");
INSERT INTO mamNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bix e xi' tkba'n Jesús cye t-xnak'atzxin: —¿Tikentzen min s-oc ke cyc'u'ja wi'ja?—tz̈i Jesús. Pero otk cyaj ttz̈i cye t-xnak'atzxin, bix nimxsen e jaw klee'ke, bix e yolenke cyxolx: —¿Ti xjalel jxjal lu? Hasta cyk'i'k bix a' ma tz'oc tilenxin, bix ma cybi—tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bix iy'pakexin jlajxe a', tumelx jaa' otk che'xexin tuj Galilea, bix e ponkexin ttzii' a' tuj tnom te Gadara. ");
INSERT INTO mamNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tejtzen tetz Jesús tuj barc, bix e pon lk'e ttzii' a' jun xjal te Gadara. Jxjal e pon, nimxsen biman otk tz'oc ti'j, bix nimxe k'ij cyoclen biman ti'jxin. Mintey' ti'jxin toc, bix min tenxin tuj jun jaa', sino ju' najlxin cyxol cyjayel anem. ");
INSERT INTO mamNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tej t-xi' tcye'yenxin Jesús, e jawxsen s̈-inxin, bix e cub majexin twitz Jesús, bix e xi' ts̈i'nxin: —Mi'n tzaj yolena wuyena, Jesús. Ja tey Tcwal jawnex Dios, bix mintii' tajbila waja. Cxe'l ncubsa'na nwitza tey mi'n ko tak'a tuj q'uixc'aj—tz̈i xjal at tjak' cycawbil biman. ");
INSERT INTO mamNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ju'tzen tten tej cyyolen biman, cuma e xi' tkba'n Jesús tu'n cyel ti'j xjal. El tii'n Jesús ke biman ti' xjal cuma nim maj cyak'len yaal te xjal. Ch'ima maj e tzyet-xin cyu'n xjal, bix e cub ẍpet tk'abxin tuya cadena, bix oc cadena te tmaneyxin ti' tkenxin, pero jaca maj oj tcub ẍpet-xin, ncubxin ttzakaxin cadena, bix e xi' cyii'n biman jaxin tuj jun lugar jaa' min-al xjal najl. ");
INSERT INTO mamNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Bix e xi' tkanen Jesús texin: —¿Ti tbiy?—tz̈i Jesús texin. Bix e xi' tkba'nxin: —Nimc'a tajlal nbi'ya—tz̈ixin, cuma otk chi oc nim biman ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","E cubsan ke biman cywitz twitz Jesús tu'n mi'n che'x tk'o'nxin tuj jjul mintii' t-xee' jaa' tzyu'na ke biman. ");
INSERT INTO mamNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Attzen jun linaj nka ttzii' a', bix nim boch nchi waa'nc tc'u'j linaj. E cubsan ke biman cywitz twitz Jesús tu'n cyocx tk'o'nxin tuj cyxumlal boch, bix e tcuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bixsen el ke biman ti'j xjal, bixsen ocxke tuj cyxumlal boch. Tejtzen cyocx biman tuj cyxumlal boch, cyeltzen sey'paj boch, bi'x e xi'kejil tuj a', bix e jaw jik'bakejil, bix e cyimkejil. ");
INSERT INTO mamNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yaltzen cye c'ojlal boch, tej toc cycye'yenxin ti e baj, bi'x el okkexin, bix el tpocbal cyu'nxin tuj tnom bix tuj cojbil ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ju' tzunj enterax ke xjal e xi' baj cyey'lte ti otk baj, bix tejtzen cypon xjal jaa' ta' Jesús, oc cycye'yen xjal jxin otk chi el biman ti'jxin. K'uklc'atlxin twitz Jesús, toctl tij t-xbalenxin, bix otk baj bint-xin. Bix e jaw sey'paj ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kej xjal otk tz'oc cycye'yen ti otk baj bix e baj cyk'umentl cyej xjal e pon lepchxitl. E baj cyk'umen ti tten tej tk'anen Jesús ti'j xjal otk baj yaa'n cyu'n biman. ");
INSERT INTO mamNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tejtzen tbaj cybi'n kej xjal te Gadara bix niy'tlke te cojbil, ocxsen ttz̈i Jesús cyi'j, bix e cubsanke cywitz twitzxin tu'n tetzxin tuj cytanem. E tcuya Jesús, bix ocxxin tuj barc tu'n taj meltz'ajxin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tej tocxxin tuj barc, yal tzunj xin otk chi el biman ti'j e cubsan xsunxin twitzxin te Jesús tu'n t-xi' tii'n Jesús jaxin. Pero e xi' tkba'n Jesús texin tu'n tcyajxin. E xi' tkba'n Jesús: ");
INSERT INTO mamNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Cutxey tjay, bix kbanxa cye tuyey jba'n ma bint tu'n Dios tey—tz̈i Jesús. Bix ajxin, bix e baj tk'umenxin te cykilca xjal tuj tnom jba'n otk bint tu'n Jesús texin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yaltzen cye xjal te Galilea, tzinxsen chi ayon tu'n tpon meltz'aj Jesús juntl maj. Ju' tzunj, tej tpon meltz'aj Jesús cyxol, e jawxsen tzalajke. ");
INSERT INTO mamNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Attzen junxin xjal Jairo tbi. Ja tzunxin cawel cyxolj xjal e chmet tuj camon jaa'. Tej tpon meltz'aj Jesús, bix e pon jxin Jairo twitz Jesús, bix e cub mejtz'ajxin twitz Jesús, bix e cubsanxin twitzxin te Jesús tu'n tpon Jesús tjaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","E bint tu'nxin ju'wa cuma ch'itk tbaj tmeelxin. Te cablaaj jnabk'itxin, bix o'cx junx tmeelxin. E tcuya Jesús, bix e xi' tuyaxin. Pero tej t-xi' Jesús, nimxsen xjal e baj cycutz'en cyiib ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Cyxoltzen tnimal xjal tocx junxuj xuuj yaab. Otk bint cablaaj jnabk'i tak'lenxuj tu'n cyak a' ti'jxuj. Otk tx'ajxuj cyuya nimc'a k'anel, bix otk baj tpwakxuj, pero mintii' otk tz'oc tbinche. ");
INSERT INTO mamNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chebe ocxxuj cyxol xjal tu'n tpon canaxuj ttzal ti'j Jesús, bix chebe e pon canan twi' tk'abxuj ti' ttxa'n t-xbalen Jesús tuj ewjel ch'in. Tej toc tmaco'nxuj, nwe'tl tyabelxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bix e xi' tkba'n Jesús: —¿Al tzunj s-oc tzyunte weya ja'lecuwe?—tz̈i Jesús. E xi' cykba'n kej xjal nka te'c ti' Jesús: —Pero min-alte xpon canan tk'ab ti'ja—tz̈ike. Bix e xi' tkba'n Pedro: —Taat Xnak'tzal, ¿titzen n-oca tkanena al s-oc tocl ti'ja, nukpatzen jun xjal n-oc tocl ti'ja cyxol tnimal xjal n-oc cycutz'en cyiib ti'ja?—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aj ttzak'be'n Jesús: —Jaxte at jun sul canan tk'ab wi'ja, cuma xnna'ya tej s-el wipemala tu'n tk'anj jun xjal—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tej tel tniy' xuuj ti'j ka otk tz'el tniy' Jesús ti'jxuj, ak'xuj lu'lel, bix e pon lk'exuj twitzxin, bix e cub majexuj twitzxin. Bix e xi' tkba'nxuj texin twitz cykil xjal ka otk tz'oc tmaco'nxuj jaxin tu'n tul tnaablxuj, bi'x e we' tyabelxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bix e xi' tkba'n Jesús te xuuj: —Tey xuuj, tu'nj s-oc ke tc'u'ja wi'ja, ma tzul tnaabla. Cutxa tzuna, cuma ya ba'ntla—tz̈i Jesús texuj. ");
INSERT INTO mamNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Maatkxsen nyolen Jesús tuya xuuj tej tpon jun sanjel te tja jxin cawel tuj camon jaa', bix e xi' tkba'nxin te Jairo: —Ma cyim tmeela. Mi'n tyaa'tla jxin taat Xnak'tzal tu'n t-xi'xin tjay—tz̈i sanjel. ");
INSERT INTO mamNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bix e tbi Jesús tyol sanjel, bix e xi' tkba'nxin te Jairo: —Mi'n baj tc'u'ja. Keec tc'u'ja wi'ja, tu'n tk'anj tmeela—tz̈i Jesús texin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tej tocx Jesús tuj tja Jairo, min e tkeyxin tu'n cyocx xjal tuyaxin tunwen. Nuk ja Pedro bix Jacobo tuya Juan, nuk ejee'ja ocx tuyaxin, tuya tmantxin bix ttxutxin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nim xjal tocx tunwen, bix nim ok'el nbaj tu'n cybis. Bixsen e xi' tkba'n Jesús cye xjal: —Mi'n chi ook'a mas. Jnee' lu min ma cyim. Nuk nwutan—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bix e jaw tze'n ke xjal ti' Jesús, cuma oc cycye'yen xjal otk cyimtxin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bix e xi' Jesús tzyuljaw tk'abtxin, bix e xi' tkba'nxin tetxin: —Txin, we'wey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bix ul t-xewtxin, bix njawtzen we'tltxin. Bix e xi' tkba'n Jesús tu'n t-xi' twatxin. ");
INSERT INTO mamNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","E jawxsen klee' ke tmantxin tuya ttxutxin ti'j lu, pero e xi' tkba'n Jesús cye tu'n mi'n cyk'umen cye xjal ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Attzen jun k'ij e cub tchmo'n Jesús kej cablaaj t-xnak'atzxin. Bix e xi' tk'o'nxin tipemalxin bix jtoclenxin cye tu'n tel cyii'nxin biman cyi' xjal bix tu'n cyk'anenxin ti' cyyabel xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bix e xi' tchk'o'nxin ejee' te kbalte ti'j tcawbil Dios bix te k'anlte ke yaab. ");
INSERT INTO mamNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bix e xi' tkba'nxin cye: —Mintii' cxe'l cyii'na tuj be, mi nuk cybardóna, mi nuk cypay, mi nuk cyway, mi nuk cypwaka, mi nuk ch'ixpubl cyi'ja. ");
INSERT INTO mamNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bix ja tzunj jaa' cnetel cyu'na jaa' chi wutaley, hasta ojxe cyi'ya tuj tnom cyjel cyk'o'na. ");
INSERT INTO mamNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ka at jun tnom ma tz'el t-xoo'n cyyola, cytz̈toncjtzen kuk ti' cyxaaba cywitz xjal oj cyi'ya tuj tnom, te yec'bil min chi k'umentla tyol Dios cyxol, cuma cycy'i—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bix iy'ke bix ocxkexin cyuj nim tnom. Tuj jaca juun tnom e baj cyk'umenxin jba'n tpocbalel tcawbil Dios, bix e k'anenkexin ke xjal yaab. ");
INSERT INTO mamNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yal tzunj xin gobernador Herodes, cykilj tpocbal niy' jnbint tu'n Jesús e pon tuj twi'xin, pero min e cnet tumel tu'nxin alj xin Jesús. E'la tuj cywitz juun xjal ka ja Juan Bautista otk jaw itz'j juntl maj cyxol cyimne. ");
INSERT INTO mamNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yal cabtl xjal, e'la tuj cywitz kape ja ktzan tyolel Dios Elías otk tzul jlet juntl maj. Yal cabtl xjal, e'la tuj cywitz kape jaj juntl tyolel Dios te ootxa otk jaw itz'j tuj cyamecy juntl maj. ");
INSERT INTO mamNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tej toc tbi'n Herodes cyyol xjal, e xi' tkba'nxin: —Yaa'n te Juan, cuma inayena e k'umente tu'n tel tx'omet twi' Juan. ¿Pero alcyenexin? cuma nim tzin nbi'na ti'j nbint tu'nj xin xjal—tz̈i Herodes ti' Jesús. Bix nim e tajbe Herodes tu'n toc tcye'yen jaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yal tzunj cablaaj t-xnak'atz Jesús otk txi' tsma'nxin, bixsen ul meltz'ajkexin tuya Jesús, bixsen e baj cykba'nxin ti otk bint cyu'nxin cyuj tnom. Bix e xi' tii'n Jesús ejee'xin tuj jun lugar nka ttxa'n tnom te Betsaida, tu'ntzen cytenxin cyjunalxin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero oc cybi'n xjal jaa' e xa' Jesús, bix e xi' ke xjal jaa' e temaxin. Tej cypon xjal, e tiik'xin ejee', bix ak'xin kbalte ti'j tcawbil Dios, bix oc tk'a'nexin kej xjal yaab. ");
INSERT INTO mamNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tejtzen ch'itk tex k'ij, bix e xi' lk'ej cablaaj t-xnak'atz Jesús tuyaxin, bix e xi' cykba'nxin texin: —K'umenx cye xjal lu tu'n cyxi' jyol cywa bix cyposada tiy' cyuj tnom nka tzalu bix tuj cojbil, cuma ja lu tuj tzkij tx'otx', bix mintii' te cye at tuj—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero aj ttzak'be'n Jesús cyexin: —Ejee'x cyey cxe'l k'onte cywa xjal—tz̈ixin. Bix e xi' cykba'nxin texin: —Nuk jwe' pan tuya ca'ba quis̈ at kuyena. ¿Tajpey tu'n kxi'ya lok'ol cywa xjal?—tz̈i ke t-xnak'atzxin, ");
INSERT INTO mamNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","cuma atle jwe' mil xinak. Bix e xi' tkba'n Jesús cye t-xnak'atzxin: —Cykbanx cye xjal tu'n cycub ke juun cya'wnak tuya laaj xjal q'uelela juun cloj cyu'na—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bix e cycuyaxin bix e xi'kexin te pa'l cye xjal, bix e cub ke cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bix e xi' ttzyu'n Jesús jjwe' pan bix jca'ba quis̈, bix e jaw tcye'yenxin twitz cya'j, bix e xi' tk'o'nxin chjonte te Dios ti' waabj. Bix ak'xin piẍlte, bix e xi' tk'o'nxin cye ke t-xnak'atzxin tu'n t-xi' cypa'n cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bix cykilca xjal e waa'nke tejxe tnoj cyc'u'j. Tej cybaj waa'n xjal, bixsen e jaw chmet ttx'akan waabj otk cyaj, bix e noj cablaaj chi'l. ");
INSERT INTO mamNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","At juntl k'ij e ten Jesús tjunalxin cyuya ke t-xnak'atzxin. Bix e na'n Jesús Dios tjunalxin. Tej tbaj na'nxin Dios, e xi' tkanenxin cye: —Tuj cywitz xjal, ¿al-le kena?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aj cytzak'be'n t-xnak'atzxin texin: —At juun xjal tzin cykba'n jay Juan Bautista. At juuntl tzin cykba'n jay jtyolel Dios Elías. Bix at juuntl tzin cykba'n ja loy juntl tyolel Dios te ootxa o jatz meltz'aj juntl maj tuj cyamecy—tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Bix e xi' tkba'n Jesús cye: —Yajtzen cyey, ¿al kena tuj cywitza?—tz̈ixin. Aj ttzak'be'n Pedro: —Jay jxjal o tscy'o Dios te cawel tibaj cykilca—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bix cyiw e xi' tk'umen Jesús cyexin: —Jax tu'na, Pedro, pero mi'n txi' cyk'umena cye xjal ka inayena Jscy'o'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal, tu'n tiy'x nim q'uixc'aj wu'na, bix tu'n wel iiq'uena cyu'n nintzaj xjal tuj nintzaj tja Dios, bix cyu'n pala, bix cyu'n tx'olbal ley. Chin cwel byeta, pero te toxen k'ij oj njaw itz'jtla juntl maj tuj cyamecy tu'n Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mas yaj, e xi' tkba'n Jesús cye xjal: —Ka at juun cyey taj tz'oc lpe wi'ja, cyjeltzen cyk'o'na cykilcaj taj cyc'u'ja, bix q'uelel cyni'ya ti'j q'uiyax q'uixc'aj cyu'na nuk tu'nj lepcheckey wi'ja, ojxe cycyima. Ka jaca k'ij at cyanema tu'n cyoc lpey wi'ja, amale tu'nt cycuba nuk wi'jq'ueya, ju'tzen tten lepcheckey wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ja tzunj xjal tcy'i tz'oc lpe wi'ja tu'nj n-oc tk'on tiib ti'j ti taj, cxe'l t-xoo'n tchunk'lal. Pero ja tzunj xjal cyjel tk'o'n tchunk'lal te twitz tx'otx' tu'nj lepchec wi'ja, ctcamantzen tchunk'lal te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Ti tajbel cykilca twitz tx'otx' te jun xjal oj tcaman ti'j bix ka otk txi' t-xoo'n tchunk'lal nuk ti'j? ");
INSERT INTO mamNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jax ju'x jxjal at tch'ixew cywitz xjal wi'ja bix ti' nyola, jaxsele ju'x weya at nch'ixewa ti'j oj wul meltz'aja twitz tx'otx' juntl maj. Inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal, chin ul meltz'aja tuya nimxsen wipemala bix tuya nim woclena tu'n Nmana Dios, bix cyuya ke jawnex tsanjel Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pero cxe'l nkba'na cyey, ti'j ja tipemal tcawbil Dios lu, at juun tocx cyxola ja'lecuwe, tuj cychunk'lala te ja'lewe, te ja mina'x cycyima, c'oquel cycye'yena jun rato ti tten tipemal tcawbil Dios—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Otk tz'ex junle smant tbajlen tkba'n Jesús kej yol at toclel cycye'yen juun xjal jun techel ti tten tcawbil Dios, bix e jawxin twi' witz te na'l Dios. Bix e xi' tii'nxin Pedro bix Juan tuya Jacobo. ");
INSERT INTO mamNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Maatktzen nna'nxin Dios, tej tcub ch'ixpet tcye'nc twitzxin, bix e cub meltz'aj tilbil t-xbalenxin puro sak bix nkoptz'ajxsen. ");
INSERT INTO mamNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nuk tisen tii' tej tul ca'ba xjal bix ak'ke yolel tuyaxin. Ejee'tzen Moisés tuya Elías, ");
INSERT INTO mamNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bix tzinxsen chi koptz'ajxin. E yolenkexin tuya Jesús ti'j tcyamecyxin tu'n tnimantexin tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bix otk tzaj ch'in cywatl Pedro cyuya ke tuya, pero tej cyjaw q'uisjxin, e jaw cycye'yenxin tzinxsen koptz'aj tcye'nc Jesús tuyaj ca'batl tuyaxin wa'lc'a. ");
INSERT INTO mamNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tej ch'itk cycub naj Moisés tuya Elías, e xi' tkba'n Pedro te Jesús: —Taat, Xnak'tzal, ¡axsen tbanel eto' tzalu! Cjaweltzen kbincha'na oxe ni' pach, jun te tey, juntl te Moisés, bix juntl te Elías—tz̈i Pedro, pero mintii' oc tc'u'jxin ti'j. ");
INSERT INTO mamNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mitkna'x tbaj yolen Pedro tej tcub jun muj, bix e cyaj baj Pedro bix Juan tuya Jacobo tuj muj, bi'xsen e cub ttz̈i cyibajxin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tujtzen muj etztzen jun yol. Tz̈i cyjulu: —Jatzen xinj lu Ncwala, jatzen xjalja o nkba'ya tu'n tcawen. K'onc cyc'u'ja ti' tyol—tz̈i Dios tuj muj. ");
INSERT INTO mamNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tej ttzaj baj jyol e xi' cybi'nxin, bix ak' cywitzxin ti' Jesús tjunalxtlxin tcubxin. Min e baj cykba'nxin ti otk baj. Otktzen tz'el nim k'ij bixsen e baj cykba'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tetzen juntl k'ij bixsen e cu'tzkexin twi' witz, bix tej cyc'u'lxin t-xee' witz, nimxsen xjal e pon twitz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Cyxoltzen xjal at junxin e xi' tkba'nxin te Jesús: —Taat, cxe'l ncubsa'na nwitza tey tu'n ttzaj tonena ncy'aala, cuma o'cxc'a junx ncy'aala. ");
INSERT INTO mamNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","O tz'oc jun biman ti'j, bix nim maj nbaj tyaa'n biman jak'a bix njaw s̈-ink'a tu'n, bix ncub xoo'nk'a tu'n twitz tx'otx', bix n-ak' eletz plut tuj ttzik'a. Tcy'i biman tz'el ti'jk'a, bix ma txi' ncy'aala tuj il tu'n. ");
INSERT INTO mamNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xi' ncubsa'na nwitza cye t-xnak'atza tu'n tel cyii'n biman ti' ncwala, pero mix ma binne cyu'n—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aj ttzak'be'n Jesús texin: —¿Mimpatzenal xjal n-oc ke cyc'u'j wi'ja? ¿Jaa'tzen ta' cyocslabla? ¿Jte'tltzen maj cxe'l nyeec'ana wipemala, tu'ntzen toc ke cyc'u'ja wi'ja? ¿Jte'tltzen maj tu'n cyiy'xa wu'na? Cyii'ntznej ni' cwale wuyey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bix e tzaj cyii'nxin ni' cwal te Jesús, pero mitkna'x tpon nee' twitzxin tej tcub t-xoo'n biman ja nee' twitz tx'otx' bix ak' nee' balk'ajel. Bix el tlojo'n Jesús biman bix e k'anj nee', bix e xi' tk'o'n Jesús nee' te tman. ");
INSERT INTO mamNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bix cykilca xjal e jaw klee' ti' tipemal Dios. Nim e yolenke t-xnak'atz Jesús cyi'j jawnex tbinchben Jesús, pero e xi' tkba'n Jesús cye: ");
INSERT INTO mamNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Cyk'onc cyc'u'ja ti'j cxe'l nkba'na cyey. Inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal, chin k'ojela tuj cyk'ab xjal tu'n nbyeta—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero ke t-xnak'atzxin, min el cyniy' ti' tyolxin ti'j at tu'n tbyet-xin. Te cye, e'wen ta' ti japenina cuma min e cyocsla at tu'n tbyet-xin, bix at cych'ixew tu'n t-xi' cykanen ti japenina kej tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Attzen jun k'oj e jaw cyxol t-xnak'atz Jesús. “Inayena mas jawnex,” tz̈i jun. “Min, inayena,” tz̈i juntl. ");
INSERT INTO mamNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero ttzki'n Jesús te jaca juun e cub tbisen tuj tanem ka ja mas jawnex. Ju'tzen e tzaa' ttxco'n Jesús jun nee' tu'n toc we' ttxlajxin, ");
INSERT INTO mamNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","bix e xi' tkba'nxin cye: —Alj ma tz'oc tk'on tiib tu'n tajben te jun xjal yaa'n jawnex, tisen ja nee' lu yaa'n jawnex, bix tu'n toc wak'a cye, ja tzunja najben weya. Bix oj tajben weya, yaa'n nuk te weya, sino tuyax te Dios, jxjal e tzaj k'onte weya. Ju' tzunj, alj cyxola mas najben cye cabtl, ja tzunja mas jawnex tuj twitz Dios—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Bix e xi' tkba'n Juan te Jesús: —Taat, ejoo'ya t-xnak'atza e tjoya te kajbela tey. Pero oc kcye'yena juntl xjal n-el tii'n biman cyi' xjal tu'n tipemal tey tbi. Pero e xi' kkba'na texin tu'n twe'xin tbinchantexin ju'wa, cuma yaa'n jaanxin toc te tajlal t-xnak'atza kuyena—tz̈i Juan. ");
INSERT INTO mamNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aj ttzak'be'n Jesús: —Mi'n txi' cymayo'na. Alj xjal min k'ojl ki'j, kuya ta'—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","At juntl maj e xi' tkba'n Jesús cye t-xnak'atzxin ti ctemela tej cytzpet. Tej ch'itk tpon tumel tu'n tcyim Jesús bix tu'n tjaxxin tuj cya'j, bix e tnimsaxin tc'u'jxin tu'n t-xi'xin tuj Jerusalén tu'n tbyet-xin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","E xi' tsma'n Jesús cab tsanjelxin nejl twitzxin, tu'n tcnet cyposadaxin. Ocx ke tsanjelxin tuj jun tnom tuj departamento te Samaria. ");
INSERT INTO mamNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero tej toc cybi'n kej xjal tej tnom jaa' tu'n tpona posadayin Jesús, cycy'i xjal tu'n tponxin, cuma cytzki'n xjal nx-ajxin Jerusalén te iy'sal Pascua, bix yaa'n junx jlu tuyaj cyreligión aj Samaria. ");
INSERT INTO mamNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tej cybinte ke t-xnak'atzxin Jacobo bix Juan otk tz'el cyxoo'n kej xjal tej tnoma ja Jesús, e xi' cykba'nxin texin: —Taat, ¿yaa'mpaxsele ba'n tuj twitza tu'n t-xi' kkanen k'ak' twitz cya'j tu'n cynaj xjal lu?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bix oc tilenxin ejee', bix e xi' tkba'nxin: —Min, yaa'n ju'wa. Yaa'n tumel cynaabla. ");
INSERT INTO mamNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Min in ula te xitl cye xjal, sino te co'plcye—tz̈ixin. Bix e xi'kexin posadayil tuj juntl tnom. ");
INSERT INTO mamNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","At juntl maj oc noj junxin xjal cywitzxin tuj be, bix e xi' tkba'n jxin xjal te Jesús: —Taat, chin xe'la tuyena nuk jaa'xja tu'n t-xi'y—tz̈i xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pero aj ttzak'be'n Jesús: —Kej ẍiwel at cyja tuj tjulel xak bix kej ch'it at cyk'u'sem, pero jatzen tey, ka taja tz'oc lpey wi'j, iltzen ti'j q'uelel tni'ya ti'j mintii' njaya bix nchin wutana te koniyan jaa' nchin poniya—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","E xi' tkba'n Jesús te juntl xjal: —Lpe'c'a wi'ja—tz̈ixin. Bix aj ttzak'be'n jxin xjal: —Taat, waja tu'n woc lpeya ti'ja, pero najsama, waja cu'x nmaku'na nmana nejl oj tcyim—tz̈i xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero e xi' tkba'n Jesús te: —Ka taja tz'oc lpeya wi'ja, k'oncja tu'n tcu'x cymaku'n cyimne cycyimne. Jatzen tey, k'o'nc tiiba te k'umlte ti'j tcawbil Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","At juntl xjal oc kbante te Jesús: —Taat, chin oquel lpeya ti'ja. Pero najsama, waja tneel pjel nk'olbe'na ke wermaniya ke nmana bix ntxuya—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Bix aj ttzak'be'n Jesús: —Jun xjal ncjon tuya wacẍ, il ti'j cxe'l tcye'yen twitz tu'n t-xi' ttz'utz' jiquen. Mlay txi' jiquen ka n-ajxe tcye'yen ti'jxe. Ju' tzunj xjal c'oquel lpe wi'ja. Ka ma tz'aj tcwent ti'j ma cyaj ti'jxe, mintii' c'ajbela tuj taak'en Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tbajlenxitltzen yolen Kaaw ti'j tcawbil Dios, e jaw tscy'o'nxin juntl oxc'al tuya laaj xjal tu'n cyajben te tsanjelxin tuj jun ak'untl. Bix e pje'x tpa'nxin ejee' ca'cab cybaj tuj juun tnom bix lugar jaa' at tu'n tponxin mas yaj. ");
INSERT INTO mamNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bix e xi' tkba'n Jesús cyexin: —Ak'untl cyi' xjal tisen jun jaatx'en. Nimxsen jaatx'en, pero yaa'n nimxix ak'anal at te chmolte. Ju' tzunj cykanenx te Kaaw ti' ak'untl tu'n t-xi' tsma'nxin ak'anal te chmolte twitz awal. ");
INSERT INTO mamNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Chi xe'la tuj juun tnom jaa' cxe'l nkba'na cyey. Q'uelel cyni'ya ti'j ejee'y cyisen tal carnel bix chi xe'l nsma'na cyxolj xjal cyisen xo'j cyaj tz'oc cytx'a'n ejee'y. ");
INSERT INTO mamNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Oj cyxi'y, mi'n txi' cyii'na pwak, bix cypay, bix ch'ixpubl cyxaaba. Bix mi'n chi yolena cyuya xjal tiy' tuj be. ");
INSERT INTO mamNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Oj cyocxa tuj jun jaa', tneel cyyola c'oquex te taaw jaa' cyjulu: “Tu'n tten ja jaa' lu tuj jttz̈yal tzin tk'o'n Dios,” tz̈i cybela. ");
INSERT INTO mamNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ka ma tiik' cyyola ti'j ja ttz̈yal te Dios tzin cyk'umena, ck'ojeltzen te. Pero ka min ma tiik', mlaytzen k'oj te. ");
INSERT INTO mamNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ka ma tzalaj taaw jaa' ti'j yol tzin cyk'umena, jatztzen chi temela ch'ina tuya. Jaxsele ju'x oj ttzaj tk'o'n ch'in cyway bix cyc'a'y, mi'n chjet cyu'na, cuma ak'analkey ti' tyol Dios, bix cykilca ak'anal tumel tu'n cychjet. ");
INSERT INTO mamNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Oj cypona tuj jaak'ch tnom, ka ma cyiik' xjal ejee'y, mi'n tz'el cyiiq'uena cyway oj ttzaj cyk'o'n cyey. ");
INSERT INTO mamNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bix chi k'anela kej xjal yaab cyxol, bix chi kbala cyej xjal aj tnom cyjulu: “Jcawel scy'o'n tu'n Dios o tzul twitz tx'otx', bix ju'x tcawbil Dios o tzul tii'n. Nkatzen ta' te cyey,” tz̈i cybela. ");
INSERT INTO mamNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero ka ma tz'el cyiiq'uen xjal ejee'y oj cypona tuj jun tnom, ju'tzen chi xe'la cyuj nmak be tuj tnom, bix chi kbala cye xjal cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bi'x cyjel ktz̈to'na cywitza jkuk te cytanema otk tz'oc ti' kxaaba, te jun yec'bil te cyey. Tisenxsen otk tz'el cyiiq'uena tyol Dios, jaxse ju'x q'uelel tiiq'uen Dios ejee'y tuj tcawbil. Jaxte tzul tcawbil Dios, pero amale oyjet cyey, pero o tz'el cyiiq'uena,” tz̈i cybela. ");
INSERT INTO mamNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nim castiwa e cub tu'n Dios tibaj tnom te Sodoma jun maj jatxe ootxa, pero cxe'l nkba'na cyey, tuj jk'ij te castiwa tzul, mas castiwa tzul tk'o'n Dios cyej tnom n-el cyiiq'uen tk'umj tcawbilxin twitzj e cub tk'o'nxin tuj Sodoma—tz̈i Jesús cyej setenta tsanjelxin. ");
INSERT INTO mamNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Bix at mastl tyolxin e tkbaxin cye tsanjelxin: —¡Ayxsen kej judío te Corazín, bix ayxsen kej judío te Betsaida! cuma o tz'el cyiiq'uen tyol Dios, amale nimet e yec'j wipemala cyuj tzunj tnom lu. Nuket e yec'j jwipemala cyej aj il yaa'n judío cyuj tnom te Tiro bix Sidón, ya otetle tz'oc cyk'o'n cyxbalen te bisbajil bix otetle chi cub ke tuj tza'j te techel ete'tzen tuj bis tu'n cyil. ");
INSERT INTO mamNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tuj jk'ij te castiwa tzul, mas castiwa tzul tk'o'n Dios cyej xjal aj Corazín bix cyej xjal aj Betsaida twitzj tzul tk'o'nxin cyej xjal te Tiro bix cyej xjal te Sidón. ");
INSERT INTO mamNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yaltzen cyej xjal te tnom te Capernaum, tuj cywitz ba'nxsen chi elel twitz Dios bix chi camal jun jawnex lugar tuya Dios tuj cya'j, pero yaa'n ju'wa. Chi cwel baj tuj ch'ixbajil tuj k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Key nsanjel, kej xjal ma cyiik' cyyola, inayen tzuna tzin cyiik'ente. Pero kej xjal n-el cyiiq'uen cyyola, inayen tzuna n-el cyiiq'uen. Bix kej xjal n-el cyiiq'uen inayena, jatzen Dios n-el cyiiq'uen, ja Dios e tzaj tsma'n inayena—tz̈i Jesús cyej tsanjelxin, bix e xi' tsma'nxin ejee' te kbalte tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tej tpon baj cyaak'en jsetenta tsanjel Jesús, bix e pon meltz'ajkexin, bix e tzalajkexin. Bix e xi' cykba'nxin te Jesús: —Taat, tej t-xi' kk'umena tbiy, cyuyax ke biman oc cybi'n ejoo'ya—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Bix e xi' tkba'n Jesús cyexin: —Jaxte il ti'j tu'n cynimante ke biman nbi'ya. Oc ncye'yena tej tel tz'ak taaw il, Satanás, tuj cya'j. Tej tel tz'ak, tuj ajkelbil tisen jun tken k'ancyok bix ncub najtl. ");
INSERT INTO mamNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jwipemala e xcye tibaj taaw il, o txi' nk'o'na cyey, tu'n cycamana cyi' biman bix tibaj cykilcatl n-oc cyi'ja cyisen lbaj bix cyisen si'cy. Tu'n cyxcyey ti'j cykilca nbint tu'n taaw il cyi'ja, o k'oj cyey cyipemala. Mlay caman cyi'ja tuya jun ka'. ");
INSERT INTO mamNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero mi'n chi tzalaja nuk tu'nj o k'oj cyey cyipemala cyibaj biman. Ja te mas il ti'j, jaj o chi tz'ibja tuj cya'j—tz̈i Jesús cye tsanjelxin. ");
INSERT INTO mamNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tej tbaj cyk'umen tsanjelxin cykilca ti otk bint cyu'n, e jaw tzalajxin, bix e na'nxin Dios. E xi' tkba'nxin: —Nmana, Taat, jay taaw tibaj cykilca tuj cya'j bix tibaj cykilca twitz tx'otx'. Bix nxi' nk'o'na chjonte tey j-e cub tninc'u'na ti'j tcawbila e'wen tu'na te cyej xjal nimxsen ba'n cyu'n tuj cywitz, pero te cyej xjal ajnintz cynaabl cyisen ke nee', o txi' tk'o'na tu'n tel cyniy' ti'j ti tten tcawbila. Ju'tzen o bint tu'na, cuma ju' tajbila. ");
INSERT INTO mamNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Cykilca o k'oj tu'na tuj nk'aba, Taat. Min-al ttzki'n nuk o'cx te weya, inayena Tcwala, o tbinchay jlu. Nuk o'cx jay ttzki'na jlu, Taat. Bix min-al ttzki'n ka Nmana jay. Nuk inayena etzkilte, bix xsunkej nxi' nk'o'na tumel cye—tz̈i Jesús te Tman. ");
INSERT INTO mamNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tej tten Jesús tjunal cyuya ke t-xnak'atzxin, e xi' tkba'nxin cye: —Jun nintzaj xtalbil o k'oj cyey, cuma ete'y tuyaj xjal Scy'o'n tu'n Dios te cawel. ");
INSERT INTO mamNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Cxe'l nkba'na cyey, nim tyolel Dios bix kej cawel ootxa e cyajbe tu'n toc cycye'yen tipemal Jscy'o'n tu'n Dios, tisenj n-oc cycye'yena ja'lewe, pero mixbe toc cycye'yen. E cyajbe tu'n toc cybi'n kej tyol Jscy'o'n tu'n Dios, tisenj n-oc cybi'na ja'lewe, pero mixbe toc cybi'n—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","At jun maj e pon lk'e jun tx'olbal ley ti' Jesús te kanlecte ka n-el tniy' Jesús ti'j ley. E xi' tkba'nxin: —Taat Xnak'tzal, ¿alcyej il ti'j tu'n tbint wu'na tu'n ncamana nchunk'lala te junx maj?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aj ttzak'be'n Jesús texin: —¿Ti tz'i'ben tuj ley? ¿Alcyej cxe'l cymeltz'u'na tyol jilj?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aj ttzak'be'n tx'olbal ley: —C'oquel tak' Cyaawey Dios cyey tuya cykil cyc'u'ja, bix tuya cykil cyanema, bix tuya cykil cyipena, bix tuya cykil cynaabla. Bix c'oquel cyak' ke cyuyey cyey tisenj n-oc cyak' cyiiba cyey—tz̈i tx'olbal ley. ");
INSERT INTO mamNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","E xi' tkba'n Jesús texin: —Jax tu'na. Bincham ja lu, bixsen ccamala tchunk'lala te junx maj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero tcy'i jxin xjal lu tz'oc cyak' ke tuyaxin texin. Ju' tzunj e xa' tkba'nxin te Jesús: —¿Alcyetzen ke wuyena?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","E xi' tkba'n Jesús texin: —Cxe'l nk'o'na jun tumel tey alcyej tuyey. At junxin xjal e tzaj tuj tnom te Jerusalén tu'n tponxin tuj tnom te Jericó. Pero e cub tzyu'nxin tuj be cyu'n alak'. El baj tik'ch texin, tuyax ke ti'jxin toc. Bix e baj pju'nxin hasta ch'itk tcyimxin, bix el ke alak' ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ju'x e xi' junxin pala tujx be. Tej toc noj jxinak tcub tuj be ti'jxin, min e we'xin, sino txucl exxin ttxlaj. ");
INSERT INTO mamNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jax ju'x e xi' junxin aj Leví tujx be, junxin cyuyaj jxin ak'anal tuj tja Dios. Tej toc noj jxin elninakexin ti'jxin, jax ju'x min e we'xin tu'n tjaw tonenxin, sino txucl exxin ttxlaj. ");
INSERT INTO mamNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Jax ju'x e baj tej junxin aj Samaria e xi' tujx be. Tej toc tcye'yenxin jxjal iken elninakexin tu'n, bix oc k'ak'en tc'u'jxin ti'j. ");
INSERT INTO mamNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Bix e xi' lk'exin ti'j, bix oc tsu'nxin aseyt te olivo bix vino ti'j elninakexin iken tu'nxin, tu'n tk'anj, bix oc tpotzenxin tuya xbalen, bix e jax tk'o'nxin jaxin tibaj tburxin, bix e xi' tii'nxin tuj jun posada, bix e cyaj tenxin te c'ojlalte. ");
INSERT INTO mamNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Te juntl k'ij bix ocx tk'o'nxin pwak te plata te taaw posada, bix e xi' tkba'nxin te: “C'ojlanx ch'in jxjal elninakexin. Ka ma tz'ajben mas pwak, cxe'l nk'o'ntla tey oj wul meltz'aja,” tz̈i aj Samaria. ");
INSERT INTO mamNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Ti toc tu'na? ¿Altzen jun cyej oxe xjal lu oc te tuyaj xin otk tzak' cyu'n alak'?—tz̈i Jesús te tx'olbal ley. ");
INSERT INTO mamNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aj ttzak'be'n tx'olbal ley: —Jaj xjal oc k'ak'en tc'u'j ti'j elninakexin—tz̈ixin. Bix e xi' tkba'n Jesús texin: —Jax tu'na. Cutxeney bix binchama tisenj e bint tu'n aj Samaria—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","At juntl maj tej cybet Jesús cyuya t-xnak'atz tuj be, bix e ponkexin tuj jun ch'in tnom. Tuj tzunj tnom lu at junxuj xuuj Marta tbi, bix e ttxocxuj ja Jesús tu'n tponxin tjaxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ja tzunj xuj xuuj lu, at jun titz'enxuj María tbi. Tejtzen tpon Jesús tjaxuj, e cub ke María twitz Jesús tu'ntzen toc tbi'nxuj ti toc tu'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero yal te Marta, nuk taak'en texuj oc tipenxuj ti'j tu'n tbint. E xi' lk'exuj ti' Jesús, bix e xi' tkba'nxuj: —Taat, ¿mimpa ma tz'oc tcye'yena ma cyaj tcye'yen witz'ena ak'untl nwitza? Kbanx ch'in texuj tu'n tonenxuj wi'ja—tz̈i Marta. ");
INSERT INTO mamNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aj ttzak'be'n Jesús texuj: —Marta, Marta, o'cx ncub tbisena ti'j nim taak'ena, ");
INSERT INTO mamNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero at jun mas ilxsen ti'j. Yaltzen te María, ma baj tscy'o'nxuj alcye mas ba'n, jaj tu'n t-xi' tbi'nxuj nxnak'tzbila, bix mlay tz'el wii'na texuj—tz̈i Jesús te Marta. ");
INSERT INTO mamNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","At juntl maj e na'n Jesús Dios tuj jun lugar. Tej tbaj na'nxin Dios, at jun t-xnak'atzxin e xi' tkba'n texin: —Taat, xnak'tzantz keya ti tten tu'n kna'na Dios, tisenj te Juan Bautista e xi' t-xnak'tza'n kej xjal oc lpeke ti' t-xnak'tzbil—tz̈i. ");
INSERT INTO mamNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Bix e xi' tkba'n Jesús cye t-xnak'atzxin: —Oj cyna'na Dios, cykbanxa ju lu: “Kman Dios ata tuj cya'j, jawxit nimsa'n tbiy xjan tu'n cykilca xjal. Tzulxit tcawbila twitz tx'otx'. Bint-xit jtajbila twitz tx'otx' ku'na tisenj nbint tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","K'ontza kwaya te ja'lewe. ");
INSERT INTO mamNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bix najsama kila ncub kbincha'na twitza, cuma ju'x keya ncub knajsa'na jka' n-oc cybincha'n xjal ki'ja. Bix ko toney oj koca tuj niy'bebl, tu'n tiy'x ku'na,” ju' tz̈i cybela oj cyna'na Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Bix e xi' tkba'ntlxin cye t-xnak'atzxin: —¿Tk'a'pa Dios oj cycubsana cywitza te Dios ju'wa? ¿Ti toc cyu'na ti'j ja tumel lu? Te chil ak'bil oj tpon jun tuyey tjay. Pero mintii' waabj tuj tjay. Ju' tzunj cxe'ley tuya tvesinta, bix cxe'l tkba'na te cyjulu: “Taat, najsama, at jun il ti'j wi'ja. K'ontz oxe pan nch'exa. ");
INSERT INTO mamNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ma tzul jun wuleya njaya. Nakch ma tzaa', bix ma tz'oc tak' weyaj te, pero mintii'tl weya nwa tu'n t-xi' nk'o'na te,” tz̈i tbela. ");
INSERT INTO mamNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿C'aalpa ttzak'be'n taaw jaa': “Mintii'. Cutxey. Lu kenwe nchin wutana cyuya ncwala, bix lu jaa' lmo'na. Mlay chin jaw we'wa k'olte waabj tey,” tz̈ipa tbel tvesinta tey? ");
INSERT INTO mamNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Cxe'l nkba'na cyey mi'n txi' tkba'nxin ju'wa. Il ti'j tk'a'xin. Amale tcy'it-xin txi' tk'o'nxin nuk tu'nj tvesint tiibxin, pero il ti'j cxe'l tk'o'nxin tu'n mi'n tz'el tch'ixewxin cywitz xjal. Yaltzen te Dios, ¿mi'mpa tzaj tk'o'nxin cyey alcye il ti'j, tu'n mi'n cub baj nimbilte tbixin, bix tuya cykil tc'u'jxin? ");
INSERT INTO mamNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ju' tzunj, tuya cykil cyc'u'ja cykanenx te Dios tu'n ttzaj tk'o'n jnajben cyey. Ka ma chi cubsana cywitza te, tzul tbi'n. ");
INSERT INTO mamNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Cxe'l nkba'na cyey jaca juun xjal nxi' tkanen te Dios tu'n ttzaj tk'o'n j-il ti'j, ctzaaltzen tk'o'n Dios te, bix jaca juun xjal ncubsan twitz te Dios ti' onbilte, ctiik'eltzen, tisenj oj toc cytco'na tlemel jaa' bix cjketel cywitza. ");
INSERT INTO mamNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bix jctzaal tk'o'n Dios cyey, ¿japaj min tz'ajben? Cxe'l nkanena cyey, oj tkanente jun cycwala ch'in tchi' quis̈ cyey, ¿lbajpa cxe'l cyk'o'na te? ");
INSERT INTO mamNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bix oj tkanente jun cycwala jun ni' tjos, ¿si'cypa cxe'l cyk'o'na te? ");
INSERT INTO mamNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Min. Mlay cybinchay ju'wa. Amale aj iletkey, pero jaj ba'n cxe'l cyk'o'na cye cycwala. Yajtzen te Cymana tuj cya'j, masxsen jaj ba'n ctzaal tk'o'n cyey oj t-xi' cykanena. Jaj ba'n ctzaal tk'o'n Dios te cyey, hasta tuyax Espíritu Santo tk'a'xin te cyey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","At juntl k'ij e xi' tkba'n Jesús tu'n tel biman ti' jun xinak. Tej toc ten biman ti' xinak, min e bintl tyolen, pero tej tel biman, nbintltzen tyolen xinak. E jawxsen klee' cykilca xjal ti'j. ");
INSERT INTO mamNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero at juun cyxol xjal cycy'i tu'n tjaw nimset tbi Jesús, bix e xi' cykba'n: —Jtipemal jxjal luwe cyibaj biman yaa'n te, sino o k'oj te tu'n cyaaw biman, jaj Beelzebú tbi—tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","At juuntl cyxol xjal e xi' cykanen te Jesús tu'n tk'ontexin jun yec'bil cywitz xjal ka otk k'oj tipemalxin tu'n Dios tuj cya'j, cuma tuj cywitz yaa'n jaxin Jscy'o'n tu'n Dios, bix e cyajbexin tu'n tchic'ajax mlay bint tu'nxin tu'n tyeec'antexin ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero el tniy' Jesús ti'j ti iy' tuj cyc'u'jxin, bix e xi' tkba'nxin cyexin: —Tzin cykba'na nchin ak'anana te taaw il. ¿Pero ti tten ju'wa? Cytzki'ntla ka ma tz'el tpa'n tiib jun tnom bix pjel cyk'ojlen cyiib xjal, cxe'l tnom tuj il. Jax ju'x jun moj najlel, ka ma chi jaw k'oj, bi'x cxe'l cynajle'n tuj il. ");
INSERT INTO mamNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ju'tzen tten tuya taaw il, Satanás. Ka ma txi' tkba'n te cyej ete' tjak' tcawbil tu'n t-xi' cyniman juntl patrón, cxe'l tcawbil tuj il. Ju' tzunj, jcyey ncub cybisen, ka ja Beelzebú o tzaj k'onte wipemala tu'n nk'ojla cyi' cybiman, mlay bint ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bix oj tzin cykba'na n-el wii'na biman tu'n tipemal Beelzebú, ¿tzimpa cykba'na oj tel cyii'n ke cyuyey biman, tu'npatzen tipemal Beelzebú? Mi'n txi' cyyolena ju'wa, cuma cytzki'ntla mi nuk cyu'n bix mi nuk wu'na bixet tz'el biman tu'n tipemal Beelzebú. ");
INSERT INTO mamNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ju' tzunj, tu'nx tipemal te Dios n-el wii'na biman. Bix ka tu'n tipemal Dios, q'ueleltzen cyni'ya ti'j tu'nj wul-lena o tzul tcawbil Dios cyibaja. ");
INSERT INTO mamNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Cybisenx ti'j ja techel lu. At jun taaw jaa' nc'ojlan tja tuya tmacbil. Ka min-al tzul tuya mas tipemal twitz, mlaytzele tz'etz jtik'ch te. ");
INSERT INTO mamNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero ka ma tzul jun tuya mas tipemal, bix ck'ojlel ti' taaw jaa', jatzen ccamal, bix q'uelel tii'n cykilca macbil te taaw jaa' oc ke tc'u'j ti'j, bix q'ueletz tii'n tik'ch at tunwen. Jaxse ju'x weya at wipemala tu'n tel wii'na j-at tuj tk'ab taaw il. ");
INSERT INTO mamNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ju' tzunj, mi'n chi tzpeta. Ka min ma tz'oc cyk'on cyiiba wuya, nchi k'oj tzuna wi'ja. Kej xjal min cyak' cyiib wuya tu'n cyclet xjal tuj tk'ab Satanás, ju'tzen chi onen ti' Satanás tu'nx cyxi' ke xjal tuj il—tz̈i Jesús cyej xjal e xi' cykba'n ka jaxin el tii'n biman tu'n tipemal cawel cyibaj biman. ");
INSERT INTO mamNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Bix e xi' tkba'n Jesús cyi'j biman: —Oj tel ljo'n jun biman ti' jun xjal, nbettzen biman jaa' min-al xjal. Njyon tu'n tajlan, pero min cnet jaa' tu'n twe'ban. Ju' tzunj nxi' tkba'n: “Chin aal meltz'aja tuyaj xjal jaa' ntiiniya nejl,” tz̈i. ");
INSERT INTO mamNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Oj taj meltz'aj biman tuyaj xjal, oj toc tcye'yen jxjal tisen jun jaa' tz'isen tuj, bix binne tten, bix nayon al c'oquex tuj. ");
INSERT INTO mamNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Oj toc tcye'yen min-al wa'lc'a ttziyen, n-eltltzen biman jyolte mas tuya, bix cpomel meltz'aj tuya wuuktl tuya, mas ka' twitz. Enteraxseke chi oquex tunwen tu'n cynajan, bix ju' tzunj yal tzunj xjal masxsen tuj il ta' twitz nejl—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","At jun xuuj cyxol tnimal xjal. Tej toc tbi'nxuj nyolen Jesús ju'wa, e jaw klee'xuj cyi' tyol Jesús, bix e jaw ts̈i'nxuj: —Nim t-xtalbil Dios e k'oj tej xuuj jaa' e'la itz'jey, bix jaa' e ch'u'ney—tz̈i xuuj. ");
INSERT INTO mamNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero e xi' ttzak'be'n Jesús: —Mas ba'n tu'n t-xi' tkba'na tzin tk'o'n Dios t-xtalbil te jaca juun xjal n-oc tbi'n tyol Dios bix nxi' tniman—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mas yaj aj ttzak'be'n Jesús cyej xjal otk chi kanen jun yec'bil tu'nxin ti cbinel tu'nxin. Nim oc cyc'utzen cyiib tnimal xjal ti'jxin, bix e xi' tkba'nxin cye xjal: —Key xjal judío te ja'lewe ka'key. Min chin cyiik'a, sino nuk ete'c'a kanlte we ti cbinel wu'n tetzen techel ka sma'n kena tu'n Dios. Pero jtechel ete'c'a kanlte, mlay k'oj cyey. Oj pjel wi'ja tisenxj e baj ti' Jonás, jatzen c'ajbel te techel cyey. ");
INSERT INTO mamNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tisenxj e baj ti' Jonás ajben te techel cye aj Nínive ka sma'n Jonás tu'n Dios, jaxse ju'x jpjel wi'ja c'ajbel te techel cyey judío o chin tzaj sma'na tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Oj tpon tumel tu'n cyoc cykil xjal tuj xkela tu'n Dios, jaj xuj xuuj e cawen tuj tnom te Saba jatxe ootxa cjawel yolel cyi'ja judío te ja'lewe. E xi'xuj nakch te ebilte ke tyol rey Salomón, bix oc tbi'nxuj bix e tnimanxuj. Pero cyey, n-oc cybi'na tyol jun xjal mas jawnex twitz Salomón, pero min txi' cynimana. Ju' tzunj ctkba'xuj tu'n cyaaja tuj castiwa. ");
INSERT INTO mamNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jax ju'x chi jawel yolel kej aj Nínive cyi'j ejee'y judío te ja'lewe tuj jk'ij te xkela tzul. Tej t-xi' tk'umen jxin tyolel Dios Jonás cye aj Nínive tu'n tajtz ti' cyanem, ajtztzen ti' cyanem. Pero cyey, amale nxi't tk'umen jun xjal mas jawnex twitz Jonás, pero min cynimey—tz̈i Jesús cye judío. ");
INSERT INTO mamNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Bix e xi' tkba'ntl Jesús cye xjal: —Min-al jun xjal n-oc txkonte jun cantil tu'n tcub te'wen bix ka tu'n tocx tk'o'n tjak' alma, sino cjawel tk'o'n twi' mes, tu'ntzen at tken luz cywitz xjal oj cyocx tunwen. ");
INSERT INTO mamNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yaltzen te tbak' cywitza, najben tu'n cycye'yena. Ka ba'n tbak' cywitza, ba'ntzen cycye'yena alcyej cchic'ajaxel tu'n tken luz. Pero ka yaa'n ba'n tbak' cywitza, ete'y tuj klolj. ");
INSERT INTO mamNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tisentzen najben tbak' cywitza te cyxumlala tu'n cycye'yena, jaxse ju'x najben cynaabla tu'n tel cyni'ya ti'j alcyej ma yec'j cyey tu'n Dios. Ju' tzunj, c'oquel cyc'u'ja ti'j, cuma ka lmo'n cynaabla, tuj klolj ete'y. ");
INSERT INTO mamNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pero ka yaa'n lmo'n cynaabla, c'oquexsen jaxxix yol tuj cyanema, bix q'ueleltzen cyni'ya ti'j jaxxix yol, bix cynimey, tisenj oj ba'n tbak' cywitza bix ba'n cycye'yena tu'n cantil tuj jun jaa' bix ba'n cybeta tuj tumel cuma chic'ajxsen cybey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tej tbaj yolen Jesús, attzen junxin tej cloj fariseo e xi' tkanenxin te Jesús tu'n t-xi' tuyaxin tjaxin te waa'l. Bix e pon Jesús tjaxin bix ocx Jesús tunwen bix e cub ke ti' mes. ");
INSERT INTO mamNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","E jaw klee' aj fariseo ti' Jesús tu'n min e tnima Jesús ti'j ti tten cye fariseo tx'ajbil cyk'ab tej cyak'xin waa'l. ");
INSERT INTO mamNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bix e xi' tkba'n Kaaw texin: —Ejee'y fariseo nimel xsunkey tuj cyleya. Lepchkey ti' cyleya ti'j ti tten tu'n tel cytxjo'na ti'jxe cyvasey bix cylaka, peroj tuj cyanema yaa'n sak. Nuk nchi bisena ti'j tu'n cyelk'ana bix nuk n-oc cyk'on cyiiba te cykilca cyaja. ");
INSERT INTO mamNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¿Mimpa tz'el cyni'ya ti'j ocx tbincha'n Dios cyanema, yaa'n nuk o'cx cyxumlala, bix il ti'j tuj twitzxin tu'n ttxjet cyanema, yaa'n o'cx cyxumlala? ");
INSERT INTO mamNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ka cyaja tu'n tcyaj cyanema sak, cyonenxsen ke mebe. Ka ma txi' cyk'o'na cye tuya tzalajebl, sak tzunkey twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Ay xsunkey fariseo! Nchi k'ona jnu'ẍ cyoybila te alwent bix n-ula bix cykilca itzaaj, pero min tz'oc cyk'on cyiiba te onlte cye xjal bix min tz'oc tak' Dios cyey. Ba'n tu'n t-xi' cyk'o'na tlajan pa' te cyawala, pero min tz'ajben ka min txi' cyii'na cynaabla tisen taj Dios bix ka min tz'oc tak' Dios cyey. ");
INSERT INTO mamNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ay xsunkey fariseo! Nuk te cyey n-oc tak' cyey. Oj cypona tuj camon jaa', nuk jaj k'ukbil mas jawnex nche'xa jyolte. Ju'x oj nche'xa tuj plaza, cyaja oj cyoc k'olben ke xjal cyi'ja tuya nim nimbil. ");
INSERT INTO mamNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ay xsunkey fariseo! Xmeletz'key. Ejee'y cyisen cyimne maku'n tjak' tx'otx' tiy' tuj cjo'n. Oj nchi bet ke xjal tuj cjo'n, min tz'el cyniy' ti'j nchi bet cyibaj k'eynen. Jaxse ju'x oj toc cybi'n xjal cyyola. Min tz'el cyniy' ti'j ka k'eyna tuj cyanema—tz̈i Jesús te fariseo. ");
INSERT INTO mamNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jax at jun tx'olbal ley tuj tja fariseo, bix e xi' tkba'nxin te Jesús: —Taat, oj n-oc ilena cyi' fariseo ju'wa, tuyax kibaj keya ejoo'ya tx'olbal ley cwela jtyola—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","E xi' tkba'n Jesús texin: —Jax ju'x cxe'l nkba'na cyey tx'olbal ley, ¡ay xsunkey! Nimxsen ley cyiw o bint cyu'na tu'n tjaw cyiken xjal, pero mintii' o bint cyu'na tu'n tbint cyu'n. Tisen njaw cyk'o'na jun iktz al ti' cykul, pero mi nuket jun twi' cyk'aba txi' onjawte cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ay xsunkey! Ejee'y cyisenx kej cyiy'jila e cub cybyo'n ke tyolel Dios ootxa, amale tet ja'lewe njaw cybincha'na cyjayel te nabbilcye te cyey. ");
INSERT INTO mamNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ke cyiy'jila te ootxa cycy'ixin oc cybi'nxin cyyol ke tyolel Dios, bix ju' tzunj e cwa' cybyo'nxin ejee', bix e jaw cybincha'nxin jawnex cyjayel. Bix lux key nbaj cybincha'na ja'lewe cyjayel kej tyolel Dios e cub byet cyu'n ke cyiy'jila. Pero nuk cye cybakel nxa' cyk'o'na cynimbila. Ju' tzunj junx ete'y cyuyaj cyiy'jila e cub cybyo'n ke tyolel Dios, ");
INSERT INTO mamNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","cuma ba'n tuj cywitza cycublen byet ke tyolel Dios. Cykilca ttzki'n Dios, bix e xi' tkba'nxin cyjulu: “Cxe'l nk'o'na ke nyolela bix ke nxela te cyej xjal lu. At juun cyxol ke n-ak'anala byo'n chi temela, bix juuntl pjel yaset. ");
INSERT INTO mamNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chi xe'l nk'o'na te cyej xjal lu, tu'ntzen oj cycub byet, otktzen pon tumel tu'n ttzaj nk'o'na castiwa te t-xel cykilcaj nyolela o cub byet tbintlen twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Cwel cychjo'n cykilca cycublen n-ak'anala, jatxe tcublen Abel, hasta tejxe tcub Zacarías tuj tja Dios twitz altar twitz tneel xjan cwart,” tz̈i Dios. Cxe'l nkba'na cyey, ju'tzen pjel. Ma pon tumel tu'n tk'oj castiwa te t-xel cykilcaj bi'ya o baj cye n-ak'anala, bix ejee'y judío te ja'lewe chi iklte ja castiwa lu. ");
INSERT INTO mamNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ay xsunkey tx'olbal ley! Cyey cyaak'en tu'n t-xi' cytx'olba'na tyol Dios cye xjal, pero min o bint cyu'na. Min o tz'el cyni'ya ti'j tixix tten tyol Dios, bix tej cyaj cabtl xjal tu'n tel cyniy' ti'j, bix oc cymayo'nkey ti'j—tz̈i Jesús te tx'olbal ley tuj tja fariseo. ");
INSERT INTO mamNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tej tetz Jesús tuj tja jxin fariseo, nimxsen e jaw cyk'oj fariseo cyuya tx'olbal ley ti'jxin. Nimxsen cyxkelbilxin oc te Jesús, tu'n tcub tzpet-xin cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bixsen e cyyoxin tu'n tcub tz'akxin tuj tyolxin, tu'ntzen tjaw cytzyu'nxin tuj til. Pero mlay bint cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tujx jtyem e cub cyninc'u'n ke fariseo bix ke tx'olbal ley ti tten tu'n tcub tz'ak Jesús tuj cyk'ab, tnimaltl xjal nuk e cyajbe tu'n toc cybi'n tyolxin. Jte'le mil xjal e chmet ti'jxin, hasta e baj cywa'be cyken. Ete' t-xnak'atzxin tuyaxin, bix e xi' tkba'nxin cye: —Cyk'o'nc cyc'u'ja ti'j tu'n mi'n txi' cyii'na cynaabla tisen cynaabl fariseo. Jawnex chi xnak'tzan, tu'ntzen tuj cywitz xjal ba'nxsenke, pero nojne tuj cyanem tuya ka'. ");
INSERT INTO mamNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pero jka' at tuj cyanem cchic'ajaxeltzen. Cykilca e'wen cyjel tuj chic'aj. ");
INSERT INTO mamNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mi'n cub cyewena jka' tisen nbint cyu'n fariseo. Cykilcaj nbint cyu'na oj min-al n-oc cyeyente cyey, q'uelex tpocbal tuj cykil lugar. Bix cykilcaj nchi jasena tuj ewjel tu'n min-al tz'oc ebinte, cyjel tuj tzinen cywitz cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ejee'y wuyena, cxe'l nkba'na cyey, mi'n tzaj cytz̈i cyi'ja jxjal n-el iiq'uente cyey nuk wi'ja. O'cx cbinel cyu'n pjel cybyo'n cyxumlala. Oj tbint cyu'n ju'wa, mintii'tl c'oquel bint cyu'n cyi'ja. Mlay cubtl cyanema cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cxe'l nkba'na cyey alj ctzaal ttz̈i cyi'ja. Ja Dios, cuma at tipemalxin yaa'n nuk o'cx tu'n tcub byet cyxumlala, sino jax ju'x at tipemalxin tu'n t-xi' t-xoo'nxin ejee'y tuj k'ak'. Ju' tzunj nxi' nkba'na cyey tu'n ttzaj ttz̈i Dios cyi'ja. ");
INSERT INTO mamNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","N-oc tcye'yen Dios cykilcaj nbaj cyey. C'oquel cyc'u'ja cyi'j tal ch'it. ¿Mimpatii' nq'ueyj jwe' tu'n nuk ca'ba oxe centavo tuj plaza? Pero amale yaa'nt nim cywi', mi nuk jun q'uelel tuj tc'u'j Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pero yaltzen cyey, jawnexsen cywi'y cywitz nim ch'it. Pero katzen min chi el ch'it tuj tc'u'j Dios, yajtzen cyey, ¿chi elelpey tuj tc'u'jxin? Min. Nim n-el tniy' Dios ti'j ti nbaj cyey. Hasta ttzmal cywi'y ttzki'n Dios jte'. Ju' tzunj mi'n tzaj ttz̈i jcbinel cyi'ja cyu'n kej xjal iic'bel te weya, cuma Dios ncye'yen ti'j nbaj. ");
INSERT INTO mamNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Cxe'l nkba'na cyey kej xjal tzin cykba'n cywitz xjal ka lepchecke wi'ja, cxe'l nk'umena cywitz ke tsanjel Dios tuj cya'j ka ejee' nxjalja, inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero kej xjal cycy'i cykba cywitz xjal ka lepchecke wi'ja, cxe'ltzen nkba'na cywitz t-ángel Dios ka yaa'n ejee'ja te weya. ");
INSERT INTO mamNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kej xjal yaa'n ocslal wi'ja, ka ma chi k'ojl wi'ja, inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal, ba'n tnajset cyil. Pero kej xjal tzin cykba'n ka' jnbint wu'na, amale n-elet cyniy' ti'j nbint tu'n tipemal Espíritu Santo, mlay najset cyil. ");
INSERT INTO mamNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Oj cyxi' tzyeta nuk tu'nj lepcheckey wi'ja bix oj cypon k'i'na cywitz ke nejenel xjal tuj camon jaa' tu'ntzen cyel xoo'na nuk tu'nj lepcheckey wi'ja, mi'n chi bisena ti'j ka tu'n cycuyantey alcyej cye cyaj, bix ka min, bix mi'n chi labta ti'j alcyej c'aal cytzak'be'na oj toc kanet cyey. ");
INSERT INTO mamNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mi'n chi xoba, cuma oj tpon tumel tu'n toc kanet cyey, c'oneltzen Espíritu Santo cyi'ja oj taj cytzak'be'na cyyol—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Cyxoltzen tnimal xjal tocxe junxin xjal e jaw s̈-in ti' Jesús: —Taat Xnak'tzal, kbanxa te ntzicya tu'n tcub tpa'n kkaba bix tu'n ttzaj tk'o'n jweya—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","E xi' tkba'n Jesús texin: —Xinak, yaa'n weja waak'en tu'n tcub npa'na cykaba—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bix e xi' tkba'n Jesús cye cykilcaj xjal: —C'oquel cycwenta ti'j tu'n mi'n txi' cyii'na jun cynaabla tu'n tten mas cyuyey, cuma yaa'n tu'nj nim tk'inemal nojne tchunk'lal jun xjal tuya tzalajebl. ");
INSERT INTO mamNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Cxe'l nk'o'na jun tumel cyey. At junxin xjal k'ina, bix nim twitz tawalxin e chmet tuj ttx'otx'xin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bix ak'xin bisel ti' twitz tawalxin, bix e xi' tkba'nxin: “Nimxsen twitz wawala, hasta mlay tz'ocx baj cyuj ntx'utx'a. ¿Ti pjel weya?” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bix e xi' tkba'nxin cyjulu: “Ma tzul tuj nc'u'ja ti pjel weya. Cwel nxitiya ke ntx'utx'a, tu'n cyjaw bintl te mas nmak, tu'ntzen tocx baj cykilca twitz wawala bix tik'ch weya at. ");
INSERT INTO mamNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nimxsen tik'ch weya at. At nwaya te nim tyem. Mi'ntltzen chin ak'anala, sino nuktzen cxe'l niy'be'ntla tik'ch tal nwaya bix nc'a'ya, bix tuj txubtx chin temela ch'ina,” tz̈ixin tuj tanemxin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero e xi' tkba'n Dios tej xin k'ina: “Mintii' tnaabla. Tujx koniyan te ja'lewe q'uelel wii'na tchunk'lala. Bix oj tcyima, cykilcaj tk'inemala o tz'oc tipena ti'j tu'n tchmet, c'aal te juntl,” tz̈i Dios tej xin k'ina. ");
INSERT INTO mamNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ju'tzen pjel te cyej xjal min nchi bisen ti'j tu'n tbint alcyej ba'n, sino nuk nchi bisen ti'j tu'n tchmet cyk'inemal. Pero pjel—tz̈i Jesús cye cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tej tbaj tkba'n Jesús ja yol lu cye xjal, e xi' tkba'nxin cye t-xnak'atzxin: —Cuma jk'inemal min tzin tk'o'n cychunk'lala, ju' tzunj cxe'l nkba'na cyey, mi'n chi labta ti'j waabj tu'n cyitz'ja bix ti'j xbalen te cyxumlala. ");
INSERT INTO mamNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Min o k'oj cychunk'lala nuk tu'n cywaa'na, bix min o k'oj cyxumlala nuk tu'n toc cyxbalena. ");
INSERT INTO mamNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cyway, Dios ck'olte cyway. Cycye'yenc ke joj. Min nchi awanjil, bix min nchi jtx'onjil. Mintii' cycajonjil tcublel ixi'n, bix mintii' cytx'utx'jil. Pero nchi itz'jjil, cuma ntzaj tk'o'n Dios cywajil. Yaltzen cyey, mas jawnexkey cywitz joj. Ju' tzunj, ¿mimpa tzaj tk'o'n Dios cyway? ");
INSERT INTO mamNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Min tz'ajben oj nchi labta ti'j jun tii', cuma mi nuket jun k'ij ba'n txi' cyk'o'na te cychunk'lala tu'nj nchi labta ti'j. ");
INSERT INTO mamNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Katzen min tz'ajben tu'n t-xi' cyk'o'na jun k'ij te cychunk'lala tu'nj nchi labta, ¿tikentzen nchi labta ti'j cykilcatl? ");
INSERT INTO mamNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Cycye'yenc kej abech. Min nchi chkon bix min nchi tz̈mon. Pero cxe'l nkba'na cyey, mas cyeca cycye'nc twitzj jawnex t-xbalen jrey Salomón. ");
INSERT INTO mamNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ntzaj tk'o'n Dios cyxmaquel c'ul, amale nuket ca'ba oxe k'ij nten bix n-el tz'ak bix ncub patet. Yaltzen cyey, ¿yaa'mpa mas jawnexkey cywitz c'ul? Ejee'y yaa'n nimxix n-oc ke cyc'u'ja ti'jxin. Ka ma tzaj tk'o'nxin cyxmaquel c'ul, jax ju'x ctzaal tk'o'nxin cyxbalena. ");
INSERT INTO mamNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ju' tzunj, mi'n chi labta ti'j jaa' tu'n tcnet cyway bix cyc'a'y, bix mi'n baj cyc'u'ja ctzaal tk'o'n Dios tu'n cyitz'ja. ");
INSERT INTO mamNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kej xjal yaa'n lepchec ti' Dios, nuk o'cx n-oc cyipen ti'j tu'n tcnet cywa bix cyc'a'. Pero cyey, ejee'y ocslal ti'j Cymana Dios, bix ttzki'nxin cyaja cyway bix cyc'a'y. ");
INSERT INTO mamNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ju' tzunj, c'oquel cyipena tu'n tbint tajbil Dios cyu'na. Ka ma bint cyu'na ju'wa, ck'ojel cyoclena tuj tcawbil Dios, bix jax ju'x ck'ojel cyway bix cyc'a'y bix cyxbalena. ");
INSERT INTO mamNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jatzen cyey lepchec wi'ja yaa'n nim cybaja, mi'n chi bisena ka nuk cyajxa oj nbint ti taj Dios cyu'na, cuma jaxte ck'ojel cyey tu'n cycawena tuya Dios tuj tcawbil. Ja tzunj lu tajxin tu'n ttzaj tk'o'nxin cyey. ");
INSERT INTO mamNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Cyq'ueyenx tik'ch cyey at, bix cyk'onx cye mebe. Oj nbint tajbil Dios cyu'na ju'wa, j-o txi' cyk'o'na cye cabtl tisenc'a chmo'n ta' tuj cya'j te cyey. Jtzin cyk'o'na chmo'n tuj cya'j, mlay tz'oc k'anak, bix mlay cub naj cyk'inemala jatzewe. Min-al alk'al ba'n tocx ti'j, bix mintii' poc' ba'n tocx tuj te xitlte. ");
INSERT INTO mamNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ka nchi k'ona cyk'inemala tuj cya'j, ja tzunj lu tzin tyeec'an at jcyajbila tuya ti taj Dios, pero ka nuk o'cx n-oc cyipena ti'j cyk'inemala twitz tx'otx', ja tzunja nyeec'ante mintii' cyanema tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tzul tcawbil Dios twitz tx'otx'. Ju' tzunj, cyitz'lem cyiiba, tu'ntzen binne cytena oj wul meltz'aja, tisen kej xjal ntxakan cytzaj nbaj ak'bil. ");
INSERT INTO mamNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Cyitz'le'n cyiiba tisen kej xjal nchi c'ojlan tja cypatrón oj t-xi' cypatrón ti' jun mejoblenel. Chi ayol ke c'ojlal jaa' oj tpon meltz'aj taaw jaa', tu'ntzen i'tzke tu'n tocx cyjko'n tlemel jaa' oj tocx tco'n taaw jaa'. ");
INSERT INTO mamNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ctk'a'tzen taaw jaa' xtalbil cyej c'ojlal jaa' cuma i'tzke bix nchi ayon oj tul meltz'aj cypatrón. Cxe'l nkba'na cyey, tu'nj ttzalajeblxin cyi'j t-ak'analxin, cxe'l tkba'nxin cye tu'n cycub ke ti' mes, bix c'oquel jun twitz tkenxin, bix jaxxin cxe'l k'onte cywa, te yec'bil tanemxin cye. ");
INSERT INTO mamNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ka ma tzulxin chil ak'bil, bix ka ma tzulxin te ch'itk kskix, ka ma chi ayon ke t-ak'analxin ti'jxin, ccyiik'eltzen jun chojbil cye tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Cxe'l nk'o'na juntl tumel cyey. Cybisenx ti'j jun jaa' jaa' ocxe jun alak' tuj, te alk'al. Nuket el tniy' taaw jaa' ni' hora tu'n tpon alk'al tuj tjaxin, c'ojla'ntle tjaxin tu'nxin te tej hora. ");
INSERT INTO mamNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jatzen cyey, mi'n cybinchay tisenj taaw jaa', sino cykil hora cyitz'lem cyiiba, cuma mintii' tumel cyuyey jtoj tu'n wul meltz'aja, inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bix e xi' tkanen Pedro te Jesús: —Taat, jma baj tkba'na cyi' c'ojlal jaa', ¿nukpa te ke keya, ma tuyax te cykilcatl xjal?—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aj ttzak'be'n Kaaw texin: —Jaj alcye mas il ti'j, tu'n tcub cybisena ti'j ti tten tu'n cyoca te ba'n ak'analkey. Oj tex jun patrón, bix cyjel tk'o'nxin jun mayordomo te cyey'lte ke t-ak'analxin bix te k'olte cywa, ¿ti toc cyu'na? ¿Mi'mpa jaw tjyo'nxin jun mayordomo at tnaabl bix c'oquel ke tc'u'jxin ti'j? ");
INSERT INTO mamNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cjyolxin ju'wa, bix ctk'a' patrón xtalbil te ka nbinchan mayordomo alcyej otk txi' tkba'n tpatrón te oj tul meltz'aj tpatrónxin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cxe'l nkba'na cyey, cxe'l tk'o'n patrón te mayordomo tu'n toc te cawel tibaj cykilca at te texin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","¿Pero ti pjel tej mayordomo ka ma txi' tkba'n: “Tuj nwitza, yaj c'ulel meltz'aj patrón,” ka ma tz̈i ju'wa, bix ka ma tzak' k'olte tz'u'n cyej ak'anal xinak bix cyej ak'anal xuuj, bix ka ma tz'oc tk'on tiib te nim waa'n bix te nc'an k'e'n, bix ka ma tz'oc te bola? ");
INSERT INTO mamNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tuj jun k'ij te min tz'ayonxin tpatrónxin, ja ponj tpatrónxin, bix oj toc tcye'yen patrón ka min tz'ak'anan tmayordomoxin, sino nbinchan nim ka', cwel byet, tisen nbint te cykilcaj ak'anal min cyniman tyol cypatrón. ");
INSERT INTO mamNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","¿Titzen pjel te jun mayordomo n-el tniy' ti'j alcyej taak'enxin e xi' tkba'n tpatrónxin, pero min nbint taak'en tpatrónxin tu'nxin, bix yaa'n binne ttenxin oj tul meltz'aj tpatrónxin? Te texin ck'ojel nim tz'u'n. ");
INSERT INTO mamNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yaltzen tej xin mayordomo mintii' tumel tuyaxin alcyej taj tpatrónxin tu'n tbint tu'nxin, bix ntzpet-xin tuj taak'en tpatrónxin, amale yaa'nt nim tilxin twitzj ka' e bint tu'nj juntl mayordomo, pero ck'ojel ch'in tz'u'n texin. Pero ka nim ma k'oj te jun xjal tu'n n-el tniy' ti'j alcyej ak'untl tu'n tbint tu'n, il ti'j tu'n tel taak'en ba'n, cuma ju' ctkane tpatrón—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Bix e xi' tkba'ntl Jesús cye t-xnak'atzxin: —O chin ula twitz tx'otx' tisen jun tzaj nk'on k'ak' tuj c'ul, cuma wu'na c'oquel nim k'oj twitz tx'otx'. Nuket bint alcyej tu'n tbint wu'na. ");
INSERT INTO mamNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero mina'x tbint wu'na. At jun jawnex q'uixc'aj il ti'j q'uiyax wu'na, bix hasta ojxe wi'ya tuj, nchin ayona ti'j tuya nim tchyonel—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bix e xi' tkba'ntlxin: —¿Tzimpa cub cybisena ka in ula tu'n twe' cykil k'oj twitz tx'otx' wu'na? Yaa'n ju'wa, sino in ula tu'n tbaj cypa'n cyiib xjal wu'na. ");
INSERT INTO mamNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Te ja'lewe, t-xol jaca juun najaj xjal pjel cypa'n cyiib wu'na. Ka at jwe' xjal tuj jun najaj, c'oquel k'ojl oxe ti' ca'ba, bix ka ja ca'ba ti' oxe. ");
INSERT INTO mamNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jax ju'x chi k'ojlel mambaj tuya tcwal, bix txuybaj tuya tal, bix elibj tuya tliib—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Bix e xi' tkba'n Jesús cye tnimal xjal ti'jxin: —Cyey, n-el cyni'ya ti'j twitz cya'j bix ti'j cyk'i'k. Oj t-xi' cycye'yena njaw muj jaa' n-exa k'ij, nxi' cykba'na: “Tzul jbal,” bix ju' nbaja. ");
INSERT INTO mamNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bix oj tak' cyk'i'k, nxi' cykba'na: “Tzul cyak,” bix jax cyu'na. ");
INSERT INTO mamNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","At cynaabla tu'n tel cyni'ya cyi'j techel twitz cya'j bix twitz tx'otx'. ¿Titzen tten min tz'el cyni'ya cyi'j techel o tyeec'an Dios cyey ti'j ti nbaj cyxola tuj tyem te ja'lewe? Xmeletz'key, cuma cycy'iy tz'el cyni'ya ti'j alcyej o cub tyeec'an Dios, amale tzint cykba'na ka cyaja. ");
INSERT INTO mamNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jax ju'x, ¿tikentzen min n-oc cyipena tu'n tel cyni'ya ti'j alcyej tu'n tbint cyu'na tu'n cycyaja jiquen twitz Dios? ");
INSERT INTO mamNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Cxe'l nkba'na jun tumel cyey. Ka at jun cyc'asbena te jun xjal, bix ka ma txi' tkba'nxin cyey tu'n t-xi' tii'nxin ejee'y twitz juez, tu'n tchjet cyu'na, mas ba'n cwel cyninc'un cyiiba tuya taaw pwak te mitkna'x cypona twitz juez. Ka min ma cub cyninc'un cyiiba, chi aal k'o'na tuj cyk'ab soldado tu'n juez, bix chi xe'la tuj tzee', ");
INSERT INTO mamNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","bix cxe'l nkba'na cyey, mi'n chi etz oka tuj tzee' hasta ojxe tocx baj tchjoj cykil cyc'asbena hasta manc'bil centavo—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Cyxoltzen tnimal xjal, at cab oc cykba'n te Jesús otk chi baj byet juun aj Galilea tu'n tley jxin gobernador Pilato. Otk chi pon ke aj Galilea maa tuj Jerusalén, bix nchi oyen alimaj te Dios tej cypon soldado te byolcye. ");
INSERT INTO mamNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","E xi' tkba'n Jesús cye: —¿Ti ncub cybisena? Tu'nj e k'oj cycastiwa kej aj Galilea, ¿tzimpa cub cybisena mas aj ilke cywitzj niy'tl ejee'y aj Galilea? ");
INSERT INTO mamNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pero yaa'n ju'wa. Cxe'l nkba'na cyey, ka min ẍi meltz'aja tuya Dios, jax ck'ojeltzen cycastiwey te cyamecy te cykilca cyey. ");
INSERT INTO mamNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Cxe'l nkanena juntl cyey. Kej wajxaklaaj aj Jerusalén e cyim tej tiy' tz'ak jcuartel nim twe' cyxol Siloé, ¿tzimpa cub cybisena mas aj ilke cywitzj niy'tl aj Jerusalén? ");
INSERT INTO mamNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Min, yaa'n ju'wa. Cxe'l nkba'na te cykilca cyey, ka min sul cyila tuj cyc'u'ja, jax cykilcakey chi naal najtla. ");
INSERT INTO mamNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Cxe'l nk'o'na jun tumel cyey. At junxin xjal e cu'x tawa'nxin jun wi' higuera tuj ttx'otx'xin. Jaca jnabk'i e ponxin tuj ttx'otx'xin te cyey'lte ka at twitz ti' tzee', pero mintii' twitz toc. ");
INSERT INTO mamNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ju' tzunj e xi' tkba'nxin te c'ojlal ttx'otx'xin: “Otk tz'ex oxetl tyem tibaj tu'n tk'onte ja tzee' lu twitz. Pero oj wula jaca jnabk'i te cyey'lte, mixtii' twitz n-oc. Ju' tzunj tx'omajaw. Min tz'ajben tuj ntx'otx'a,” tz̈i taaw tx'otx' tej xin c'ojlal ttx'otx'xin. ");
INSERT INTO mamNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Aj ttzak'be'n jxin c'ojlal: “Taat, k'oncj te juntl tyem. Chin ak'anala t-xee' tuj tx'otx' bix cwelex nk'o'na cytxa alimaj t-xee'. ");
INSERT INTO mamNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Katzen ma tak' twitz, mi'nttzen jaw tx'omet. Pero ka mixtii' twitz, cjaweltzenle tx'omet,” tz̈i c'ojlal—e xi' tkba'n Jesús tu'n tyeec'an alcyej tbajlel cyi'j tu'nj min tzul cyil tuj cyc'u'j. ");
INSERT INTO mamNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tujtzen jun k'ij te ajlabl, ocx Jesús tuj jun camon jaa', tu'ntzen t-xi' tk'o'nxin t-xnak'tzbilxin cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ocpe junxuj xuuj otk tz'oc jun yabel ti'jxuj wajxaklaaj jnabk'i. Nuk c'onen tiy'xuj. Min jaw we' ti'jxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tej t-xi' tcye'yen Jesús jaxuj, e xi' ttxco'nxin jaxuj, bix e xi' tkba'nxin texuj: —Xuuj, ma tz'el yabel ti'ja—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Bix e cub tk'o'n Jesús ke tk'abxin tibajxuj, bix ya njaw we'tl ti'jxuj. Bix ak'xuj nimsaljawte tbi Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tej t-xi' tcye'yen jxin cawel tuj camon jaa' otk tk'anen Jesús jun xuuj tuj k'ij te ajlabl, bix e tzaj tk'ojxin, bix e xi' tkba'nxin cye xjal: —Tuj jun smant at kak k'ij ba'n tu'n kak'anan. Ka cyaja tu'n cyk'anja, cytzaja cyuj jk'ij ba'n te ak'untl, yaa'n tuj k'ij te ajlabl—tz̈i cawel tuj camon jaa'. ");
INSERT INTO mamNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bix aj ttzak'be'n Jesús texin: —Xmeletz' yolena. ¿Mimpa che'xa jaca k'ij te ajlabl te k'ilbetz ke cywacẍa bix cybura tu'n cyxi'jil c'al a'? ");
INSERT INTO mamNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yal tej xuuj lu, o ten tjak' tcawbil Satanás wajxaklaaj jnabk'i. Ju' tzunj, ¿ti ncwa cybisena? Ka ba'n tu'n cytzakpet ke alimaj tuj k'ij te ajlabl, ¿jax yaa'mpa tumel tu'n ttzakpet jxuuj tiy'jil Abraham lu tuj k'ij te ajlabl?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tej t-xi' tkba'n Jesús ju'wa, kej xjal e jaw yolen ti'jxin e cub cych'ixew cywitz xjal, pero ke niy'tl xjal e jaw tzalajke ti'j cykilca jawnex nbint tu'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Bix ak' Jesús te xnak'tzal. E xi' tkba'nxin: —¿Ti cxe'l nkba'na ti'j tcawbil Dios? ¿Ti tten oj ttz̈'iy? ");
INSERT INTO mamNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ctz̈'iyel tisen tten tej tcu'x tawa'n jun xjal iyaj te jun tzee' mostaza tuj ttx'otx'xin. E tz̈'iy mostaza tejxe toc te tzee', bix ajben tu'n cyajlan ke ch'it tuj tk'ab. ");
INSERT INTO mamNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Cxe'l nkanena juntl maj, ¿ti c'ajbel te techel ti'j ti tten oj tz̈'iynen ctz̈'iyel tcawbil Dios? ");
INSERT INTO mamNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","C'ajbel levadura te techel. Ocx tk'o'n jun xuuj levadura tuj k'otj te pan, bix e cub tk'o'nxuj k'otj tuj oxe tcublel. Bix e jaw tz̈'iy k'otj te pan tu'n levadura hasta tejxe tjaw punntz'aj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iy' Jesús cyuj nimc'a tnom, tu'ntzen t-xi' t-xnak'tza'nxin cye xjal. At tnom nmak, bix at coc'. Min el tuj tc'u'jxin tu'n tponxin Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","At jun k'ij e xi' tkanen jun xjal texin: —Taat, kej chi cletel, ¿nimxixpa cybaj, bix ka yaa'n nimxix?—tz̈i xjal. Bix e xi' tkba'n Jesús cye xjal: ");
INSERT INTO mamNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ka ma tz'ocx nim tuj tcawbil Dios, bix ka yaa'n nim, pero cyk'o'nc cyipena tu'n ejee'xa chi caman tu'n cyocxa. Ttzii' tcawbil Dios ch'in, bix at nim xjal mlay nchi ocx. Mas yaj ccyajbe' tu'n cyocx, pero otk lmet ttzii'. ");
INSERT INTO mamNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Oj tpon koniyan, bix oj tel tniy' taaw jun jaa' ti'j ka otk chi oc baj cykilca ttxocaxin tuj tjaxin, bixsen q'ueletz tlomo'nxin jaa'. Katzen ma chi pona oj ya otk lmet ttzii' jaa', bix cxe'l cykba'na: “Taat, jkom jaa' kwitza,” ka tz̈i cybela ju'wa, nuk q'ueletz ttzak'be'nxin: “Min ntzki'nkey,” tz̈i tbelxin. Ju'tzen pjel oj mi'n jket ttzii' tcawbil Dios cywitza. ");
INSERT INTO mamNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bix chi cubsala cywitza texin: “Taat, mi'n tbinchey. Kape jac'a ko ocxa, cuma e waa'n ko'ya bix e c'an ko'ya tuyey, bix e tzaj tk'o'na xnak'tzbil tuj kq'ueybila,” tz̈i cybela. ");
INSERT INTO mamNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero cxe'l tkba'nxin cyey: “Min ntzki'na cywitza. Cyucxey, cuma nuk binchal ilkey. Mlay jket tcawbil Dios cywitza,” tz̈i tbelxin, ");
INSERT INTO mamNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","bix jatzen chi jaw ook'ja, bix jatzen jaw kitx'itx'in t-xee' twitz cyey tu'n cyk'oja, cuma c'oquex cycye'yena jcyiy'jila Abraham bix Isaac bix Jacob tunwen, cyuyaj cykilca tyolel Dios, pero jatzen cyey chi cyjelxa ti'jxa. ");
INSERT INTO mamNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Cyxol jxjal chi pomel tuj tcawbil Dios, ejee'j ocslan ti' nyola, at xjal te cykilca twitz tx'otx'. At te ocne, te elne, te jawne, bix te cubne, bix chi temel tuya Dios te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","C'oquel cyc'u'ja ti'j kej xjal tzin cykba'na yaa'n nintzajke tuj twitz Dios, chi pomel, pero ejee'y mas jawnex tuj cywitza, mi'n chi pona—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tujx k'ij, e pon juun aj fariseo, bix e xi' cykba'nxin te Jesús: —Taj jxin gobernador Herodes tu'n tcub byeta. Il ti'j c'aala tuj Galilea—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero e xi' tkba'n Jesús cyexin: —Jaj xin Herodes o'cx tajxin tu'n tcub tyaa'nxin inayena, tu'ntzen waaja. Cyucxey kbalte tej yaal xjal chin cyjela tzalu ca'ba oxetl k'ij te ak'anal tisex tten. Q'uelel wii'na biman cyi' xjal bix chin k'anela kej xjal yaab. Oj tpon baj twi' jca'ba oxe k'ij, otktzen bint waak'ena tzalu tuj Galilea. ");
INSERT INTO mamNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero il ti'j q'uelel cyni'ya ti'j, amale mint ẍin aja tu'n ttz̈i Herodes wi'ja, pero tuj ca'ba oxe k'ij chin aala. Il ti'j chin xe'la Jerusalén tu'n nbyeta, cuma cytzki'n cykil xjal jatzen nchi cwa' byete ke tyolel Dios—tz̈i Jesús cye aj fariseo. ");
INSERT INTO mamNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Bix e xi' tkba'ntl Jesús: —Key aj Jerusalén, key aj Jerusalén, ¿tikentzen nchi cub cybyo'na ke tyolel Dios? ¿Bix tiken nchi cub cybyo'na tu'n xak kej xjal nxi' tsma'n Dios cyey? Nim maj o wajbe'ya tu'n nclonteya ejee'y, tisen nchi ocx clet tal jun ttxu ey' tjak' t-xiicy', pero cycy'iy inayena. ");
INSERT INTO mamNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jey', cyjel tcye'yen Dios cytanema, bix min-al xjal chi cyjel tuj. Cxe'l nkba'na cyey, oj wel iiq'uena, mi'n tz'oc cycye'yena nwitza juntl maj hasta ojxe tpon jk'ij oj t-xi' cykba'na: “Chjonte te Dios ti'j ja xjal lu tzul tsma'n tu'nxin te cawel,” tz̈i cybela—e xi' tkba'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","At juntl k'ij te ajlabl e xi' Jesús te waa'l tja junxin xjal nenel cye fariseo. Bix oc cycye'yen kej xin fariseo jaxin ka tu'n tak'ananxin tuj k'ij te ajlabl. ");
INSERT INTO mamNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bix e pon junxin xjal yaab twitz Jesús. Otk jaw mal ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Bix e xi' tkba'n Jesús cye tx'olbal ley bix cye fariseo: —¿Ti ncub cybisena ti'j? ¿Tzimpa tk'o'n ley amle'n tu'n tk'anj jun xjal tuj k'ij te ajlabl, bix ka min?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mintii' aj cytzak'be'n. Bix e cub tk'o'n Jesús ke tk'ab ti' tkul yaab, bix e tk'anexin, bix e xi' tkba'nxin te yaab tu'n taj tja. ");
INSERT INTO mamNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bix e xi' tkba'nxin cye fariseo: —Ka at jun cyxola nxi' tz'ak tbur bix ka twacẍ tuj jun jul, ¿mi'mpatzen jatz tii'n najxin, amale tujet k'ij xjan?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Min-al jun e bint ttzak'bej tu'n. ");
INSERT INTO mamNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tej tpon tumel tu'n cywaa'n, oc tcye'yen Jesús kej tuya fariseo e cyajbe tu'n cycub ke cyuj k'a'j toc ttxa'n mes mas cymunel. Ju' tzunj e xi' tk'o'n Jesús jun tumel cyexin. E xi' tkba'nxin: ");
INSERT INTO mamNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ka ma ttxoc jun xjal ejee'y tuj jun mejoblenel, mi'n chi cub key cyuj k'a'j mas cymunel. Ka ma txi' ttxco'n taaw mejoblenel jun xjal mas nintzaj cywitza, ");
INSERT INTO mamNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","oj tpon, iltzen ti'j ctkba' taaw mejoblenel cyey: “Najsamkey, chi aal lk'e ch'ina, cuma ma tzul jun xjal mas nintzaj cywitza,” tz̈i tbel. Bix jun ch'ixbajil nim oj cycub key cywi'j k'a'j menos cymunel. ");
INSERT INTO mamNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ju' tzunj, oj cytxqueta tuj jun mejoblenel, ju' chi cwel key cywi'j k'a'j menos cymunel, tu'ntzen ba'n txi' tkba'n taaw mejoblenel cyey: “Cyixtekey tzalu cyuj k'a'j mas cymunel,” tz̈i. Bix kej xjal ete' twi' mes cyuyey, q'uelel cyniy' ti'j ejee'y nchi nimj cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ja tumel lu tzin tyeec'an ti'j xjal njaw tniman tiib, c'oquel te ch'in, bix alj xjal n-oc tk'on tiib te ch'in, ck'ojel te tu'n toc te nim—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bix e xi' tkba'n Jesús te fariseo jxin otk txi' txconte Jesús tu'n twaa'n tuyaxin: —Oj t-xi' ttxco'na ke xjal tu'n cywaa'n tuyey, yaa'n nuk ejee' ke tuyey, bix ke titz'ena, bix ke titz'en tmana, bix ke tvesinta k'ina. Jax cxe'l cytxco'n jay tu'n twaa'na cyuya, tu'ntzen t-xelenta tiib. ");
INSERT INTO mamNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Oj t-xi' ttxco'na ke xjal tu'n cywaa'n tuyey, txcom ke mebe tuyey bix kej xjal tal tpaltel, coxle, mos̈le, bix atle mastl. ");
INSERT INTO mamNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ka ju' nbint tu'na tu'n t-xi' ttxco'na kej mlay cyak' t-xel tey, cwel xtalbil tibaja, cuma ck'ojel t-xel tey tuj jk'ij oj cyjatz itz'j cykilca kej xjal ba'n cyten twitz Dios tuj cyamecy juntl maj—tz̈i Jesús te fariseo. ");
INSERT INTO mamNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Juntlxin xjal k'uklc'a tuya Jesús ti' mes, tej toc tbi'nxin kej tyol Jesús lu, bix e xi' tkba'nxin te Jesús: —Taat, cykilca ejoo' judío ko oquel tuj tcawbil Dios bix ck'ojel xtalbil ke. ¿Yaa'mpa ju'wa?—tz̈i jun judío. ");
INSERT INTO mamNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pero e xi' tkba'n Jesús texin: —Tuj cywitza ju' pjela. Pero c'oquel tc'u'ja ti'j ja tumel lu. At junxin xjal e tajbe tu'n tiy'sanxin jun nink'ij tuj tjaxin, bix e ttxocxin nim xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tej tpon tumel tu'n cypon tuj tjaxin, e xi' tsma'nxin jun t-ak'analxin te txcol cye xjal. Te jaca juun txoca e xi' tkba'n t-ak'analxin: “Ttzaj ch'ina te iy'salte nink'ij, cuma cykilca ch'in ma bint,” tz̈ixin te cykilca. ");
INSERT INTO mamNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero cykilca ke xjal e kbante ka mlay chi pon. Tneel e tkba junxin: “Najsama, kbanx ch'in te tpatróna mlay chin pona. At ch'in tx'otx' o cyaj nlok'o'na, bix il ti'j ma chixa cyey'lte,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","At juntl xjal e xi' tkba'n: “Najsama, kbanx ch'in te tpatróna mlay chin pona. Ma cyaj nlok'o'na jwe' moj wacẍ, bix il ti'j tu'n toc nniy'be'n ke jila te cjol,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Juntl xjal e xi' tkba'n: “Najsama, mlay chin pona, cuma ma chin majeya tuya jun xuuj,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tej tpon meltz'aj tsanjelxin tuya tpatrónxin, e xi' tkba'nxin tik'ch j-otk cykba xjal texin. Tej tbinte tpatrónxin ju'wa, bix e jaw k'ojxin, bix e xi' tkba'nxin te t-ak'analxin: “Cutxa tuj ajkelbil cyuj be te tnom, bix k'intz ke mebe bix kej xjal tal tpaltel, coxle, mos̈le, bix atle mastl,” tz̈i patrón. ");
INSERT INTO mamNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","E tcuya t-ak'analxin, bix tej tbint alcyej otk txi' tkba'n tpatrónxin texin, e xi' tkba'nxin te tpatrónxin: “Taat, o bint wu'na cykilcaj e tkbay weya, pero nimx k'ukbil at,” tz̈i t-ak'analxin. ");
INSERT INTO mamNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bix e xi' tkba'n patrón te t-ak'analxin: “Ja'lewe cutxey ttxa'n tnom bix tiy' cyxol jaa' nakch, bix xmoxetz ke xjal tu'n cyul bix te waa'l, tu'ntzen tnoj njaya cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kej xjal e ntxoca nejl, cxe'l nkba'na tey mi nuk juncye cxe'l waa'nte tuj nnink'ija,” tz̈ixin—e xi' tkba'n Jesús ti'j alcye kej xjal chi oquel tuj tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nimxsen xjal oc lpe ti'j Jesús. Bix aj meltz'ajxin te cyey'lcye, bix e xi' tkba'nxin cye: ");
INSERT INTO mamNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ka cyaja chi oc lpey wi'ja, pero ka mas n-oc tak' cymana cyey, bix cytxuy, bix cyxu'la, bix ke cycwala, bix ke cyxibena, bix ke cyaneba, bix ju'x cyey, mlay chi oca te nxnak'atza. ");
INSERT INTO mamNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bix ka cycy'iy tu'n cybyeta wuyena bix tu'n tiy'x ch'ixbajil cyu'na tu'nj tu'n cyoc lpey wi'ja, mlay chi oca te nxnak'atza. ");
INSERT INTO mamNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ka al cyey taj tz'oc lpe wi'ja, il ti'j cwel cybisena ti'j tik'ch cyjel cyk'o'na. Tisen tzunj ka cyaja jaw bint jun nmak jaa'. Oj cybinchana cyjay, ¿yaa'mpa il ti'j tuj tneel cwel cybisena jte' pwak cbinela, bix ka chi xcyebela ti'j tu'n tbint? ");
INSERT INTO mamNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ka ma chi ak'a binchal cyjay, bix nuk t-xee' cyjay cbinel cyu'na, ojtzen toc cycye'yen xjal, chi tze'l cyi'ja. ");
INSERT INTO mamNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Cxe'l cykba'n ke tze'l cyi'ja: “Jxjal lu oc ttzyu'n tu'n tbint tja, pero tu'n min e cub tbisen ti' gast ti'j, mlay bint,” tz̈i cybel. ");
INSERT INTO mamNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Cxe'l nk'o'na juntl tumel cyey. Ka at jun rey tu'n tclonte ttanem nuk tuya laaj mil tsoldado twitz juntl rey tzul k'ojlel tibaj tuya wink'an mil tsoldado, cwel tbisen tuj tneel ka ba'n cyxcye tuya laaj mil tsoldado twitz wink'an mil. ");
INSERT INTO mamNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ka tuj twitz mlay xcye nuk tuya laaj mil tsoldado, bix cxe'l tsma'n jun tsanjel tuyaj rey tzajnen ttzaj tuya wink'an mil tsoldado te kanlte tu'n mlaype we' k'oj, bix alcye taj tu'n tk'oj te tu'n twe' k'oj. ");
INSERT INTO mamNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ju'tzen cytena. Cwel cybisena nejl ka cyaja tu'n cyxi' lpey wi'ja. Ka yaa'n tuya cykil cyanema tu'n tcyaj cyk'o'na cykilca at te cyey tu'n cyxi' lpey wi'ja, mlay chi oc lpey wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Chi ajbela weya nuk ka tuya cykil cyc'u'ja lepchkey wi'ja, tisen atz'en najben nuk ka ba'nx. Ka ma tz'el baj tik'bil atz'en, ¿ti tten tu'n tajben te atz'en? ");
INSERT INTO mamNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mintii' c'ajbeletl, mi nuket te abono tuj tx'otx', bix mi nuket te tuj cytxa alimaj tu'n tonen. O'cx nuk tu'n tex xe't. Ka cyaja tz'el cyni'ya ti'j, c'oquel cyc'u'ja ti'j ma txi' nkba'na cyey—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Cykilca chmol chojentj bix cykilcatl kej yaa'n ba'n tuj cywitz judío, nchi pon lk'e ti' Jesús te ebilte tyol. ");
INSERT INTO mamNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yal tzunkej xin te cloj fariseo cyxol judío bix ke tx'olbal ley cye judío, e jaw yolenke ti'j lu. E xi' cykba'nxin: —Ju'x tej xin Jesús, jaan tej xina cyuyaj kej aj ila, hasta nwaa'n xina cyuya—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bix e xi' tkba'n Jesús jun techel cyexin, tu'n tel cyniy' ti'j tu'n tiken oca tjunen tiibxin cyuya aj il: ");
INSERT INTO mamNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Jaca juun cylel carnel cyxola, ka at syent tcarnelxin bix ka ma txi' tz'ak junjil, ¿mi'mpa cyaj tk'o'nxin jnoventa y nuevejil jaa' ete'jil, tu'n t-xi'xin jyol tej jil otk cyaj tz'ak, tu'n tcnetjil? ");
INSERT INTO mamNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Oj tcnetjil tu'nxin, cjawel tzalajxin, bix cjawel tk'o'nxin jajil ti' tkulxin, tu'n tajjil cyxol tuyajil. ");
INSERT INTO mamNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bix oj tponxin tjaxin, chi tzaal ttxco'nxin ke tuyaxin bix ke tvesint-xin, bix cxe'l tkba'nxin cye: “Chi tzalaj ch'ina wuyena, cuma jncarnela e cyaj tz'ak, ma cnetjil wu'na,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tisentzen te cylel njaw tzalaj ti'j carnel e cnet tu'nxin, ju'tzen te Dios njaw tzalaj cyi' aj il oj tcyaj cyk'o'n cyil. Cxe'l nkba'na cyey, nim tzalajebl at tuj cya'j oj tcyaj tk'o'n jun aj il til, pero mintii' tzalajebl cyi'j noventa y nueve xjal mintii' cyil tuj cywitz. ");
INSERT INTO mamNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Cxe'l nkba'na juntl tumel cyey. Ka at jun xuuj at laaj pwak te dracma, bix ka ma txi' tz'ak jun, ¿mi'mpa tz'oc ttxko'n jun cantil, bix chebe q'ueletz tmso'nxuj tz'is tuj tjaxuj, tu'n tcnet? ");
INSERT INTO mamNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ojtzen tcnet tu'nxuj, chi tzaal ttxco'nxuj ke tuyaxuj bix ke tvesint-xuj, bix cxe'l tkba'nxuj cye: “Chi tzalaj ch'ina wuyena, cuma jpwak e xi' tz'ak, ma cnet,” tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tisen tzunja xuuj lu cjawel tzalaj cyuya tvesint-xuj ti'j jun tpwakxuj oj tcnet, cxe'l nkba'na cyey, njaw tzalaj Dios cyuya ke t-ángelxin tuj cya'j ti'j jun aj il ncyaj tk'o'n til—tz̈i Jesús cye fariseo bix cye tx'olbal ley. ");
INSERT INTO mamNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Bix e xi' tkba'n Jesús juntl tumel cye: —At junxin xjal at ca'ba tcwal. ");
INSERT INTO mamNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","At jun k'ij e xi' tkba'n jk'a ch'i'p te tmank'a: “Taat, k'ontz weya nkab,” tz̈ik'a. “Cu,” tz̈i tmank'a, bix e xi' tk'o'nxin juun kab te juun. ");
INSERT INTO mamNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Min el k'ij tej tak'k'a chmolte ke tik'ch tek'a, bix e xi'k'a tuj jun tnom nakch. Bix e cub baj tpwakk'a bix tik'ch tek'a jaa'j nponak'a, tu'n nuk tik'ch e tajbek'a. ");
INSERT INTO mamNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tejtzen tcub baj niy'j tkabk'a, ntzajc'atltzen jun weyaj tuj tnom jaa' e ponak'a, bix e tzajtzen tcyajlal ti'jk'a. ");
INSERT INTO mamNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bix e xi'k'a cubsal twitzk'a te junxin aj tnom tu'n tk'ontexin taak'enk'a, bix e tak'xin taak'enk'a te c'ojlal boch. ");
INSERT INTO mamNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Bix yaa'n nimxix twak'a e tak' tpatrónk'a. Nimxsen tak' weyaj oc tek'a. Nimxsen e tajbek'a tu'n t-xi' twaa'nk'a cywa boch, pero mi nuket cywa boch min e k'oj tek'a. ");
INSERT INTO mamNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Cwatzen tel tniy'k'a ti'j texk'a tilk'a e tjoyk'a, bix ak'k'a bislte ti pjel tek'a. Ul tuj tc'u'jk'a: “At nim t-ak'anal nmana, bix k'o'ncye nim cywa. Pero weya tzalu, ch'ix ncyima tu'n weyaj. ");
INSERT INTO mamNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Chin pomel meltz'aja tuya nmana, bix cxe'l nkba'na texin: ‘Taat, oxsen nbinchaya nim wila twitz Dios bix twitza. ");
INSERT INTO mamNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mi'n chin n-oc tk'o'ntla te tcwala, sino nuk te jun t-ak'anala chin oqueleya ka ma tzaj tk'o'na xtalbil tu'n wak'anana te tey,’ tz̈i nbela,” ju'tzen iy' tuj tc'u'j k'awa. ");
INSERT INTO mamNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bix ajtzk'a cyxol boch bix e tzyet tbek'a tu'n tponk'a tuya tmank'a. Maat-x tzajnen ttzajk'a nakch tej tel tniy' tmank'a ti'jk'a, bix oc k'aben tc'u'jxin ti' tcwalxin, bix e xi' ajkelenxin te clulte tek'a, bix e tzaj t-xk'e'nxin jak'a bix el ttz'u'benxin twitzk'a. ");
INSERT INTO mamNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bix e xi' tkba'nk'a te tmank'a: “Taat, oxsen nbinchaya nim wila twitz Dios bix twitza. Mi'n chin n-oc tk'o'ntla te tcwala,” tz̈ik'a. ");
INSERT INTO mamNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero min e tkba tc'u'j tmank'a ju'wa, sino e xi' tkba'nxin cye t-ak'analxin: “Cyk'o'nc cyipena. Cyii'ntz xbalen tbanel bix cyk'o'nc ti' ncwala. Bix cyk'o'ncc'a jxmul k'abbaj tzin tkba'n ka ncwal k'eya, bix cyk'o'nc t-xaabk'a. ");
INSERT INTO mamNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bix cyii'ntz ch'inj wacẍ n-oc tz̈'is̈et tu'n tajben weya tuj nink'ij, bix cybyo'nc'a, tu'ntzen kwaa'n ti'j te tnink'ij ncwala, ");
INSERT INTO mamNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","cuma jncwala lu tisenc'a o cyim, pero ma tzul meltz'aj wi'ja. El tzpet, pero ma tzul jlet,” tz̈ixin cye tmaanxin. Bix ak'kexin iy'salte jun nink'ij. ");
INSERT INTO mamNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yal tzunj xin ttzicyk'a, nak'ananxin tuj cycojbilxin. Tejtzen tpon lk'exin nka ta' cyjaxin, bix e tzaj tbi'nxin nbajxsen jun tij nink'ij. ");
INSERT INTO mamNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bix e xi' ttxco'nxin jun cymaanxin, bix oc tkanenxin: “¿Ti nbaj? ¿Ti nink'i'l nbaj?” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Bix e xi' tkba'n maan texin: “Ja titz'ena ma tzul meltz'aj, bix ba'nk'a. Ju' tzunj ma tkba cymana tu'n tcub jjil wacẍ clo'n tu'nxin te tnink'ijxin, tu'ntzen tiy' tnink'ij jk'a titz'ena ma tzul,” tz̈i maan. ");
INSERT INTO mamNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tejtzen tbaj tbi'nxin ju'wa, bix e tzaj tk'ojxin. Ya tcy'itlxin ocxxin tuj cyjaxin. Bix etz cymanxin cubsal twitz texin tu'n mi'n k'ojxin. ");
INSERT INTO mamNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bix e xi' tkba'nxin te tmanxin: “Nimxsen tyem ma chin ak'anana cyiw tuj taak'ena, tisenx kej t-ak'anala. Pero bajx tz'e'len nxoo'na tleya. Bix mintii' o tzaj tk'o'na weya, mi nuket jun ni' nchiviya tu'n tajben weya cyuya ke wuyena. ");
INSERT INTO mamNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero tej sul jk'a tey tcy'aal, jk'a xbaj yaa'nte tpwaka cyuya xuuj tiy' jak'ch tumel, bix ma cub tbyo'na jjil wacẍ clo'n tu'na te tek'a. Yaa'n tumel tuj nwitza,” tz̈i ttzicyk'a. ");
INSERT INTO mamNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","E xi' tkba'n tmanxin texin: “Ncy'aal, ma tena wuyena cykil tyem, bix cykilca tik'ch weya, te tey. O'cx ctzaal tkanena weya. ");
INSERT INTO mamNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero yal tzunj titz'ena, e najk'a. Tisenc'a e cyimk'a, pero ja'lewe ma tzul meltz'ajk'a i'tzk'a. El tzpetk'a, pero ja'lewe ma tzul jletk'a juntl maj. Ju' tzunj tumel tu'n ktzalaj bix tu'n kiy'san tnink'ijk'a,” tz̈i cymanxin—ju'xsen te Jesús e tkba cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Bix e xi' tkba'n Jesús cye t-xnak'atzxin: —Cxe'l nkba'na jun tumel cyey. At junxin ak'anal tuya jun patrón k'ina, bix e k'oj texin tu'n t-xi' tcye'yenxin cykilca tk'inemal tpatrónxin. At jun k'ij oc cykba'n cab xjal te tpatrónxin: “Jtey tmayordomo min tz'ajben ba'n. Nuk nbaj tyaa'n tpwaka,” tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bix e ttxoc jxin k'ina ja mayordomo, bix e xi' tkba'nxin texin: “¿Ti ttenj tzin nbi'na nbaj tyaa'na npwaka? K'om tcwenta weya ti ttenj tik'ch weya at tuj tcwenta, cuma ya mi'n tz'ajbentla te n-ak'anala,” tz̈i tpatrónxin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bix e cub tbisen mayordomo ti'j: “¿Ti pjel weya tu'n witz'ja, cuma q'uelel tii'n npatróna waak'ena? Yaa'n nak'l kena ncjo'na, bix at nch'ixewa oj wak'a kanl ncotza. ");
INSERT INTO mamNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa, ma tzul tuj nc'u'ja. Cwel nninc'u'na ti'j tu'n ttzaj cyk'o'n xjal xtalbil weya tuj cyja oj tel k'i'n waak'ena,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bixsen e ttxocxin cykilcaj xjal jaa' otk txa' tk'o'nxin tpwak tpatrónxin te maan. E xi' tkba'nxin te tneel c'asbenel: “¿Jte' tey tc'asben twitz npatróna?” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bix e xi' tkba'n: “Ex wii'n weya jun syent bot te aseyt te olivo,” tz̈i. Bix e xi' tkba'n mayordomo te: “Lu tu'l lu. Kequey bix tuj ajkelbil k'o'nq'uey juntl u'j, bix tz'i'bac'ax tuj nuk cincuenta bot,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bix e xi' tkanen mayordomo te juntl c'asbenel: “Yaj tey, ¿jte' tey tc'asben?” tz̈ixin. E xi' tkba'n: “Ex wii'n weya jun syent alma triwa,” tz̈i. Bix e xi' tkba'n mayordomo: “Lu tu'l lu. K'o'nq'uex tuj juntl u'j nuk jun mutx',” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tej tbinte k'ina ti otk bint tu'n mayordomo, e xi' tkba'nxin: “Jnmayordomiya yaa'n ba'n, pero amale ot bint jun ka' tu'n wi'ja, pero te junx maj ẍbi'l, cuma ma cub tbisen ti'j tu'n titz'j yaj,” tz̈ixin—tz̈i Jesús. Bix e xi' tkba'ntl Jesús cye t-xnak'atz: —Ja tumel lu ma txi' nkba'na cyey, tu'n t-xi' nyeec'ana cyey kej xjal yaa'n lepchec ti' Dios mas ncub cybisen ti tten tu'n cyitz'j twitz tx'otx' cywitzj kej xjal lepchec ti' Dios ncub cybisen ti tten tu'n tbint cyten ti' cychunk'lal tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tisen te mayordomo oc tipen ti'j tu'n tajben te cykilcaj at tuj tcwent tu'n tcaman tu'n tk'oj xtalbil mas yaj cyu'nj cyuya, jaxse ju'x cyey, il ti'j c'oquel cyipena ti'j tu'n tajben tik'ch cyey tu'n cyela ba'n te Dios, tu'ntzen oj cybaja twitz tx'otx', cycaman tzuna t-xel tu'n Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Al ma cuyante tuj jun ak'untl ch'in, jax ju'x ctcuya tuj jun ak'untl nim. Bix al mi'n tcuyan tuj jun ak'untl ch'in, jax mlay tcuyan tuj jun ak'untl nim. ");
INSERT INTO mamNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ka min ma chi ela ba'n tuj jch'in at cyuyey twitz tx'otx', jey'tzen, ¿ti tten tu'n toc ke tc'u'j Dios cyi'ja tuj jnim tuj cya'j? ");
INSERT INTO mamNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka min ma chi cuyana tuj j-ak'untl nk'oj tu'n Dios cyey twitz tx'otx', ¿ctzaalpa tk'o'n Dios t-xel tuj cya'j? Min. ");
INSERT INTO mamNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mlay tz'ajben jun ak'anal te ca'ba patrón. Ka ma tjoy tu'n tajben te jun patrón, cyjeltzen tk'o'n juntl. Bix ka jatz ma tak'a tiib tuya tcab patrón, cyjeltzen tk'o'n jtneel. Ju'tzen tten tuya Dios bix k'inemal. Ka tuya cykil cyc'u'ja nche'x lpey ti' k'inemal, mintzentii' cyaja tu'n cyajbena te Dios—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Octzen cybi'n fariseo cykilcaj e xi' tkba'n Jesús cye t-xnak'atz ti'j k'inemal. Ocx tak' k'inemal cyexin, bix tuj cywitzxin otk k'oj k'inemal cyexin tu'nj nimxsen ajbenkexin te Dios. Ju' tzunj, oc cytze'nxin ja Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","E xi' tkba'n Jesús cyexin: —Cywitz xjal nxi' cyyeec'a cyiiba ka ba'n xjalkey. Pero ttzki'n Dios ti niy' tuj cyc'u'ja. Nchi ela ba'n tuj cywitz xjal, pero twitz Dios ejee'y tzu'key. ");
INSERT INTO mamNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nejl e k'oj cyey tley Dios bix cyyol tyolel Dios tu'n cynimante. Bix mas yaj ul Juan Bautista te kbalte jba'n tpocbal tu'n tul tcawbil Dios, bix tuj ajkelbil nchi txquet cykil xjal tu'n cyocx tuj tcawbilxin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero tuj cyanema cycy'iy jtzin tkba'n Dios. Pero mlay chi camana ti'j tzin tkba'n Dios. Cyiw tu'n t-xitj twitz cya'j bix twitz tx'otx', pero mas cyiw tu'n tbaj tilel tyol Dios. Tcawbil tyol Dios mlay baj twi', mi nuket ch'in tu'n tbaj tilel. ");
INSERT INTO mamNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tisen tzunj, tzin cykba'na tumel tu'n tcub cypa'na cyiiba tuya cyxu'la, tu'ntzen ba'n cymajey tuya juntl. Pero tzin tkba'n tley Dios, ka ma cub cypa'n cyiiba tuya cyxu'la bix ka ma chi majey tuya juntl, tzin cybincha'na aj pajlel. Jax ju'x ka ma maje jun xinak tuya jun xuuj o cub tpa'n tiib tuya tchmil, aj pajlel tzin tbincha'n—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Bix e xi' tkba'ntl Jesús cye fariseo: —At junxin xjal k'ina. Oc ti'jxin nukxsen jaj tisen t-xbalen rey bix jawnexsen twi'. Te jaca k'ij jawnexsen tbel twaxin, bix nuk jaca k'ij tziy' tnink'ijxin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bix at juntlxin xjal mebe te junx maj, Lázaro tbixin. Nimxsen tx'a'c ti'jxin. Bix e xi' cyk'a'x xjal jaxin ttzi tjaxin k'ina, tu'ntzen tk'oj ch'in twaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nim e tajbe Lázaro tu'n t-xi' twaa'n nuk tbuchlel tpan k'ina el tz'ak tej nwaa'nxin, pero nuk el tc'u'j ti'j. Bix yaa'n nuk o'cx at tak' weyaj, sino jax ju'x e pon ke txyan te lk'bilte twitz tx'a'c ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tetzen jun k'ij tej tcyim Lázaro. Bix e xi' k'i'n cyu'n ángel jaa' ta' Abraham. Jax ju'x e cyim k'ina, bix e cu'x maket. ");
INSERT INTO mamNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jatz e pone k'ina tuj cynajbil cyimne, bix oc tuj q'uixc'aj. Tej t-xi' tcye'yenxin, e tilxin Abraham. Nakch tcwa' Abraham, bix tcub Lázaro ttxlajxin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bix e jaw s̈-in k'ina: “Taat Abraham, najsama, k'ontz ch'in lastim weya. Kbanx ch'in te Lázaro tu'n ttzaj tii'n a' weya, ikch nuk tcu'x tmu' twi' tk'ab tuj a', tu'n toc tk'o'n ti' waak'a, tu'n tchewex, cuma nimsxen niy'x q'uixc'aj wu'na tzalu tuj k'ak',” tz̈i k'ina. ");
INSERT INTO mamNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero aj ttzak'be'n Abraham: “Nchman, c'ulel tuj tc'u'ja tej ttena i'tza twitz tx'otx', nuk te tey e cub ttzyu'na cykilca, pero te Lázaro, nuk jaj ka' e k'oj te. Pero ja'lewe, te te tu'n tten tuj tzalajebl. Jatzen tey, tu'n ttena tuj q'uixc'aj. ");
INSERT INTO mamNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bix yaa'n nuk o'cx jlu, pero jax ju'x at jun jul mintii' tumel jaa'le npomnina baj t-xee' tmij jaa' eto'we, tu'ntzen ka taj jun xjal tzalu tu'n tpon tuyey, mlay tziy'x tibaj jul, bix tu'ntzen mlay tziy'tza tzalu kuyena,” tz̈i Abraham. ");
INSERT INTO mamNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bix e xi' tkba'n k'ina te Abraham: “Nchman, ka ju' ttena, cxe'l ncubsa'na nwitza tey tu'n t-xi' tsma'na Lázaro tja nmana twitz tx'otx', ");
INSERT INTO mamNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","cuma at jwe' witz'ena, bix waja tu'n t-xi' tk'umen cye ti ttenj jaa' ntiiniya, tu'ntzen mi'n chi cu'tz tzalu tuj q'uixc'aj,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Bix aj ttzak'be'n Abraham: “Min. At tyol Moisés cyuya, bix cyyol cabtl tyolel Dios. Ba'n toc cybi'n,” tz̈i Abraham. ");
INSERT INTO mamNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Pero e xi' tkba'n k'ina: “Pero mlay tz'oc cybi'n ke witz'ena tyol Dios. Najsama, chk'onx jun xjal o cyim cyuya, tu'ntzen toc cybi'n, tu'n tcyaj cyk'o'n cyil,” tz̈i k'ina. ");
INSERT INTO mamNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Bix aj ttzak'be'n Abraham: “Ka min o tz'oc cybi'n alcyej e tkba Moisés bix cyej cabtl tyolel Dios, jax mlay tz'oc cybi'n oj tpon juntl te kbalte tyol Dios, amale njawet itz'j jun cyimne juntl maj, bix npon te kbalte,” tz̈i Abraham—tz̈i Jesús cye fariseo, kej xin nim oc cyachen k'inemal. ");
INSERT INTO mamNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Attzen jun k'ij e xi' tkba'n Jesús cye t-xnak'atz: —Mlay we' at ocsabl c'u'jbaj tzul tu'n t-xi' tzpet jun xjal tuj tbe Dios. ¡Pero ay xsunj xjal ncub tk'o'n tzpetsabl tuj tbe juntl yaa'n cyiw tuj tocslabl, tu'n t-xi' tzpet tuj tbe Dios! ");
INSERT INTO mamNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Masetlpele ba'n oj tcub ye' jun xak al tkul jxjal nk'on tzpetsabl te juntl, tu'n t-xi' xe't tuj mar, twitzj tu'nxix t-xi' tuj castiwa tu'n Dios tu'nj ncub tk'o'n tzpetsabl cyej xjal yaa'n cyiw tuj cyocslabl. ");
INSERT INTO mamNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ju' tzunj, c'oquel cyc'u'ja ti'j tu'n mi'n txi' cytzpetsa'na jun xjal tuj tbe Dios. Katzen at jun k'i'n tyol Dios tu'n bix ka ma tz'oc tbincha'n il cyi'ja, cykbanx te tu'n mi'n binchantl il. Ka ma cyaj tk'o'n til, cynajsanq'uey. ");
INSERT INTO mamNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bix ka at jun xjal nbinchan jun ka' cyey nim maj, kape wuuk maj tex k'ij, bix ka jaca maj tzin tkba'n cyey: “Najsama, najsanq'uey wila tu'nj ka' n-oc nbincha'na ti'ja,” ka tz̈i ju'wa, il ti'j cwel cynajsa'na til jaca maj—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","At juntl k'ij e xi' cykba'n kej xin sma'n tu'n Jesús texin: —Taat, k'ontz keya tu'n mas tu'n toc ke kc'u'ja ti' Dios, tu'ntzen tbint mas ku'na tu'n tipemalxin—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","E xi' tkba'n Kaaw cyexin: —Nuket tz'oc ke cyc'u'ja ti' Dios cykilca texin ba'n tbint tu'n, ikchetle ju' ch'in cyocslabla tisen jun twitz mostaza, jac'atzenle t-xi' cyk'umena tej tzee' lu tu'n tjatz tii'n tiib tuyax tloc', tu'n tcu'x tawan tiib tuj mar, bix jac'atzele tbi cyyola—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","E xi' tkba'n juntl yol cye t-xnak'atz: —C'oquel cyc'u'ja ti'j ja tumel lu ti'j junxin xjal tuya t-ak'analxin. Jaxin cxe'l tchk'onte t-ak'analxin te cjol ttx'otx'xin bix ka te cylel ke tcarnelxin. Oj tpon meltz'aj t-ak'analxin tuj taak'en tja tpatrónxin, ¿cxe'lpa tkba'n tpatrónxin texin: “Ctoctz tey, bix kequey te waa'l. Ja'lex txi' nk'o'na tway,” tz̈ipa tbel tpatrónxin? ");
INSERT INTO mamNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Min, yaa'n ju'wa, sino ju' cxe'l tkba'nxin te t-ak'analxin cyjulu: “Binchama nwaya, bix k'ontza weya. Oj nbaj waa'na bix oj nbaj wc'ana, ba'ntzen twaa'n tey bix tu'n tc'ana,” tz̈i tbelxin. ");
INSERT INTO mamNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Oj nbint tu'n ak'anal alcye otk tkba tpatrón, ¿ilpa ti'j cxe'l tk'o'n tpatrónxin chjonte texin tu'nj otk bint tu'nxin? Min. ");
INSERT INTO mamNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jaxse ju'x cyey t-ak'anal Dios, oj tbint cyu'na alcyej ckbajel cyey, mlay chi ayona ti'j tu'n tk'oj jun chjonte cyey, sino cxe'l cykba'na: “Nuk ak'anal ko'ya. Mintii' il ti'j tu'n tk'oj chjonte keya, cuma o bint ku'na nuk jaj il ti'j tu'n tbint ku'na,” tz̈i cybela—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tejtzen ttzyet tbe Jesús tu'n t-xi'xin tuj Jerusalén, bix e xi'xin tujele tmojon Galilea tuya Samaria. ");
INSERT INTO mamNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tejtzen tpon lk'exin ti' jun tnom, ttxa'ntzen tnom attzen laaj xjal tuya jun yabel nk'ey cychu'l tu'n, lepra tbi. E cub we'ke nakch ch'in twitz Jesús, ");
INSERT INTO mamNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bix e jaw s̈-inke twitzxin: —Taat, Jesús, k'ontz tanema kibaja bix k'anena ki'ja—tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","E xi' tcye'yen Jesús ejee'xin, bix e xi' tkba'nxin: —Cyucxey cyuya ke pala bix cwel cyyeec'a cyiiba cywitz, tu'ntzen toc cycye'yen ya mintii'tl lepra cyi'ja—tz̈i Jesús. Ju'tzen e xa'kexin, bix tuj be e k'anjake tu'n tipemal Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","At jun cyxolxin, tej toc tcye'yenxin mintii'tl tyabelxin, e jawxsen tnimsa'nxin tbi Dios tuya jun cyiw tuj twi'xin, bix aj meltz'ajxin tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bix e cub mutzk'ajxin t-xee' tken Jesús, bix e xi' tk'o'nxin chjonte te. Jxin xjal aj meltz'aj tuya Jesús, te Samariaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Bix e xi' tkba'n Jesús cyej xjal tcub tuyaxin: —¿Yaa'mpatzen laaj cybaj jxjal ma chi k'anj? Yaj tzunj beljajtl, ¿tii'n ma che'x? ");
INSERT INTO mamNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Japa jxjal yaa'n judío jlu tjunal s-ajtz meltz'aj tu'n tk'onte chjonte te Dios?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bix e xi' tkba'n Jesús tej xin e cub mutzk'aj: —We'wey bix cutxey. Tu'nj s-oc ke tc'u'ja wi'ja, ma cleta—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","At juntl k'ij e xi' cykanen ke fariseo te Jesús: —Kbantz keya jtoj tzul tcawbil Dios twitz tx'otx'—tz̈ikexin. Aj ttzak'be'n Jesús cyexin: —Cyaja tu'n t-xi' nkba'na cyey alcyej techel tzul jlet te yec'bil ch'itktzen tul tcawbil Dios, pero jn-oc cykanena, mlay cyila. ");
INSERT INTO mamNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tuj cywitza tzul jun k'ij oj tk'umj: “At tcawbil Dios tuj lugar lu,” bix ka oj tk'umj: “Ma pon tcawbil Dios maa chix.” ¿Mimpa tz'el cyni'ya ti'j atl tcawbil Dios cyxola ja'lewe?—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pero te cyex t-xnak'atzxin e xi' tkba'nxin cyjulu: —Nimxsen il cyuj k'ij chi ul. Cxe'l cykba'na: “Maxitpe tzul Kaaw ja'lewe te cawel, ikchetle nuk jun k'ij,” tz̈i cybela, pero mlay cyila, cuma mina'tl tpon tumel. ");
INSERT INTO mamNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","At xjal cykba': “Ma tzul jxin Scy'o'n tu'n Dios. Luxe at chixa,” bix ka cykba': “Luxe at tzalu,” tz̈i cybel. Pero mi'n cyocslay cyyol, tu'n njyeta. ");
INSERT INTO mamNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Oj wula te cawel, inayena, jxin Sma'n tu'n Dios te cawel, cchic'ajaxel cywitz cykil xjal, tisen oj tcub koptz'aj jun tken k'ancyok cykilca twitz cya'j. ");
INSERT INTO mamNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero nejl, at nim q'uixc'aj tu'n tiy'x wu'na, bix kej xjal te ja'lewe chin elel cyxoo'n. ");
INSERT INTO mamNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yal cyej xjal at twitz tx'otx' oj ch'itk wul meltz'aja, inayena, jxin Sma'n tu'n Dios tu'n ntena cyuya xjal, mi'n tz'oc cyc'u'j ti'j alcyej at tu'n tbaj, tisenx kej xjal at twitz tx'otx' tuj ttyem Noé min e labtke ti'j alcyej at tu'n tbaj cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Min e cyocsla at tu'n tcub jun nim castiwa cyibaj, sino nuk ex cyk'ij nchi waa'n, bix nchi c'an, bix nchi maje, tisex cyten. Pero nuk tisen tii' tej tpon jk'ij tej cyocx Noé tuj barc, bix ntzajtltzen jun nintzaj jbal cyibaj bix e baj cykilca xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jax ju'x e baj mas yaj tuj ttyem Lot. Nchi waa'n bix nchi c'an ke xjal tisex cyten. Nchi lok'on bix nchi q'ueyen. Nchi awan bix nchi binchan jaa', tisex cyten. ");
INSERT INTO mamNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Jax ju'x e baj tej tpon jk'ij tej cyetz Lot tuj tnom te Sodoma, bix e tzaj twitz cya'j k'ak' tuya jun wik polvos azufre tbi. E cub tisen jbal tibaj tnom, bix e baj cykilca xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ju'xsen nuk q'uelex cyk'ij xjal oj wul meltz'aja twitz tx'otx'. Bixsen cwel castiwa cyibaj. ");
INSERT INTO mamNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tuj tzunj k'ij oj wul meltz'aja, mi'n chi labta ti'j tik'ch at te cyey. Ka te'wexe twi' cyjay oj wul meltz'aja, mi'n chi cu'tza te clolte cyk'inemala. Jax ju'x ka nchi ak'anana tuj cycojbila, jax mi'n cub cybisena ti'j tu'n cyajtz meltz'aja cyjay te tzyulte cyk'inemala. ");
INSERT INTO mamNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mi'n chi oca tisen t-xu'l Lot. Tcy'ixuj e cyaj tk'o'nxuj tk'inemalxuj tuj Sodoma, bix ju' tzunj e cyma'xuj ti'j. ");
INSERT INTO mamNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Alj xjal nuk n-oc tc'u'j ti' tchunk'lal twitz tx'otx', mlay tcaman jtchunk'lal tzin tk'o'n Dios. Pero ja tzunj xjal yaa'n nukxix n-oc tak' tchunk'lal twitz tx'otx' te, sino ju' nxi' lpe ti'j tajbil Dios, ccamaltzen jtchunk'lal tzin tk'o'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Cxe'l nkba'na cyey, tuj tzunj k'ij oj wul meltz'aja, at ca'ba xjal nchi wutan junx twi' jun wetbil. Junx cjawel k'i'n, pero cyjel juntl tu'n tk'oj tcastiwa. ");
INSERT INTO mamNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","At ca'ba xuuj nchi tz̈ee'n junx tuj jun jaa'. Junx cjawel k'i'n, pero cyjel juntl. ");
INSERT INTO mamNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","At ca'ba xinak nchi ak'anan junx tuj cjo'n. Junx cjawel k'i'n, pero cyjel juntl—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Oc cykanen t-xnak'atzxin texin: —Taat, ¿jaa'tzen c'uleley?—tz̈ikexin. Aj ttzak'be'n Jesús cyexin: —Tisen cytzki'n c'utz jaa' tcwa' jun xumlalbaj cyimne, cuma chic'aj tuj cywitz, jaxse ju'x weya oj wula. Cchic'ajaxel jaa' chin ulela, tu'ntzen mintii' il ti'j tu'n toc cykanena jaa'—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bix e xi' tkba'n Jesús juntl techel cye t-xnak'atzxin, tu'n t-xi' tyeec'anxin cye tu'n mi'n baj cyc'u'j ti' Dios tu'n ttzaj tonenxin ejee' oj t-xi' cykanen texin, bix tu'n mi'n cyaj cyk'o'n tu'n toc ke cyc'u'j ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","E xi' tkba'nxin: —At junxin juez e cawen tuj jun tnom. Mintii' tajxin Dios, bix jax mintii' lastim cye xjal texin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tuj xsunj tnom at junxuj mebe xuuj. Nim maj e ponxuj tuya juez, bix n-oc tkba'nxuj texin: “Taat, kbanx ch'in tej xinak lu o tz'alk'an wi'ja tu'n tajtz tk'o'n,” tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mintey' e tocsla juez jaxuj. Pero at jun k'ij e xi' tkba'nxin: “Amale mint tz'oc nbi'na Dios, bix amale minttii' lastim cye xjal weya, ");
INSERT INTO mamNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero cxe'l wonena ja viuda lu, tu'ntzen mi'n nuk tz'octz tenxuj wi'ja,” tz̈i juez. ");
INSERT INTO mamNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","C'oquel cyc'u'ja ti'j tyol jjuez yaa'n ba'n. ");
INSERT INTO mamNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Katzen jaj xin juez e tbi tkanbil jxuj xuuj, ¿mimpa tz'oc tbi'n Dios ke t-xjal nchi cubsan cywitz texin te k'ij bix te koniyan tu'n cyclet twitzj ka'? ¿C'oquelpa Dios tisenj xin juez tcy'i tz'oc tbi'n viuda? ");
INSERT INTO mamNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","¡Min! Cxe'l nkba'na cyey, yaa'n tuya cubsaj witzbaj ctzaal tonen Dios ke t-xjal cywitzj xjal nchi binchan ka' cyi'j. Pero oj wul meltz'aja twitz tx'otx', ¿at-xpa xjal n-oc ke cyc'u'j ti' Dios?—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bix e xi' tkba'n Jesús jun techel cyej xjal oc ke tc'u'j cyi'jx tu'nj jiquen ete' tuj cywitz, bix el cyiiq'uetl ke niy'tl xjal. E xi' tkba'nxin: ");
INSERT INTO mamNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—At ca'ba xinak ocxke tuj tja Dios te na'l Dios. Junxin tej cloj fariseo cyxolxin, bix juntlxin chmol chojentj te gobierno cyxolxin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","E jaw we' jxin fariseo bix e na'nxin Dios ti'jxxin. E xi' tkba'nxin: “Kman Dios, nxi' nk'o'na chjonte tey yaa'n jun aj il kena tisen juntl wik xjal. Yaa'n jun alak' kena. Mintii' ka' nbint wu'na jmintii' nbyan tuj ley. Yaa'n ju' kena tisen aj pajlel. Yaa'n ju' kena tisenj chmol chojentj tcub chixa. ");
INSERT INTO mamNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Weya, ncub npa'na weyaj ca'ba maj tuj smant. Bix nchin k'ona tlajan pa' ti' cykilca tzin ncamana te tja Dios,” tz̈i fariseo te Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yal tzunj xin chmol chojentj, tu'n tch'ixewxin ex we'xin na'l Dios cyi'jxe xjal tuj tja Dios. Min e jaw tcye'yentlxin jawne tuj na'j Dios, tisex tten cyu'nxin, sino nuk oc tpju'nxin ttzi t-xuuc'xin tu'n tbisxin, bix e xi' tkba'nxin: “Dios, tzajxit tk'o'na tk'ak'bil tc'u'ja wibaja, cuma jun aj il kena,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Cxe'l nkba'na cyey, ja tzunj xin chmol chojentj e xi'xin tjaxin ya otk najset tilxin tu'n Dios, tu'nj otk txi' tkba'nxin te Dios aj ilxin. Pero ja tzunj xin fariseo, min e tocsla Dios jaxin, cuma alcyej xjal njaw tnimsan tiib, c'oquel te ch'in. Ja tzunj xjal n-oc tk'on tiib te ch'in, c'oquel te jawnex—tz̈i Jesús cyej xjal e jaw cynimsan cyiib. ");
INSERT INTO mamNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","At juntl e baj tuj juntl k'ij. E pon cyii'n ke xjal ke cyẍlak twitz Jesús, tu'ntzen tcub tk'o'nxin tk'abxin cyibaj. Pero tej t-xi' cycye'yen t-xnak'atz Jesús jlu, e xi' cykba'nxin cye ke cyman nee' cytxu nee' tu'n mi'n chi oc ten yaalte texin ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero e xi' tkba'n Jesús cye t-xnak'atzxin: —Mi'n tz'oc cymayo'na tu'n mi'n chi tzaj ke nee' wuyena, cuma kej nee'wa jun cyanem te cmolte alcye cxe'l k'o'n cye, bix nuk ka ju' tanem jun xjal tisen ja nee'wa, ba'ntzen tocx tuj tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cxe'l nkba'na cyey, alcyej xjal yaa'n ju' tanem tisen tanem jun nee' tu'n tiik'ente alcyej tzin tk'o'n Dios, mlay tz'ocx tuj tcawbil Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","At junxin xjal crinsipal cyxol judío oc tkanenxin te Jesús: —Xnak'tzal ba'n, ¿alcye cbinel wu'na tu'n ncamana nchunk'lala te junx maj?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","E xi' tkba'n Jesús texin: —¿Tikentzen nchin oca tk'o'na te ba'n? Min-al te jun ba'n, nuk ja te Dios ba'n. ");
INSERT INTO mamNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yaltzen ti'j tkanbila, ttzki'na jley e cyaj tk'o'n Dios. Mi'n chi jyona juntl xuuj te pajbaj. Mi'n chi byona xjal. Mi'n chi alk'ana. Mi'n chi ẍtak'ena. Chi nimala twitz cymana bix cytxuy—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aj ttzak'be'n jxin xjal: —Cykilcaj lu o japan wu'na ntzajlenxe jatxe cwal kena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tej toc tbi'n Jesús tyol jxin xjal, aj ttzak'be'n Jesús texin: —At-x juntl mina'x tbint tu'na. Q'ueyex tik'ch tey, bix k'onx twi' cye mebe. Ju'tzen ctemeltzen k'inemal te tey tuj cya'j. Oj tbint ju'wa tu'na, c'oquel lpey wi'ja—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tej tbinte xinj ju'wa, bix e tzaj tbisxin, cuma k'ina xsunxin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tej t-xi' tcye'yen Jesús otk bisenxin, e xi' tkba'n Jesús cye t-xnak'atzxin: —Cyiwxsen tu'n tocx jun k'ina tuj tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas cyiw tu'n tocx jun k'ina tuj tcawbil Dios twitzj tu'n tex jun tz̈ej tuj tẍyo'p bak—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Toc cybi'n jlu, e xi' cykba'n t-xnak'atzxin: —Ka ju' ttena, ¿titzen tten tu'n tclet jun xjal?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","E xi' tkba'n Jesús: —Yal cye xjal, mlay bint cyu'nx tu'n cyocx tuj tcawbil Dios. Pero jatzen te Dios, cykilca ba'n tbint tu'n—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bix e xi' tkba'n Pedro te Jesús: —Taat, ttzki'na o cyaj kk'o'n keya tik'ch keya tu'n kxi' lpey ti'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Aj ttzak'be'n Jesús cye t-xnak'atzxin: —Tzinen cxe'l nkba'na cyey, alj xjal mas taj tcawbil Dios twitzj tja, bix ka cye tman, bix ka cye titz'en, bix ka te t-xu'l, bix ka cye tcwal, ");
INSERT INTO mamNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ck'ojeltzen te nim t-xel tuj jtyem te ja'lewe, bix tuj jtyem tzul, ctiik'eltzen tchunk'lal te junx maj—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bix e xi' tii'n Jesús ke cablaaj t-xnak'atzxin jaa' e temakexin cyjunalxxin, bix e xi' tkba'nxin cyexin: —Cybintz nyola. Ko xe'l tuj tnom te Jerusalén, cuma ma pon tumel tu'n nnimenteya jtz'i'ben jatxe ootxa cyu'n tyolel Dios ti'j Sma'n tu'n Dios te cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chin k'ojel tzuna tuj cyk'ab xjal yaa'n judío, bix chin oquel jubena cyu'n tuya cyyol, bix chi yasel wi'ja, bix c'oquex cytzuuben tuj nwitza. ");
INSERT INTO mamNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Cxe'l cyk'o'n tz'u'n wi'ja, bix chin byetela cyu'n. Pero te toxen k'ij ncyimlena, oj njaw itz'jtla juntl maj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero min e cyocsla t-xnak'atzxin ka cykilca lu tu'n tbaj ti' Jesús. Oc cybi'nxin, pero mix e'la cyniy'xin ti'j ti japenina j-e xi' tkba'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tejtzen tpon lk'e Jesús ttxa'n tnom te Jericó, attzen jun xjal mos̈ k'ukc'a ttzii' be. Nkanen pwak cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tej toc tbi'n mos̈ nim xjal nlabt tuj be, e xi' tkanen: —¿Tiken at nim xjal ja'lewe? ¿Ti nbaj?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Oc cykba'n xjal texin: —Jaj xin Jesús te Nazaret tzul—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tej tbintexin ju'wa, e jawxsen s̈-inxin: —¡Jesús, tiy'jil David o tzaj tsma'n Dios, k'ontz lastim weya!—tz̈ixin. Nimxsen oc tenxin s̈-ilte tbi Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ejee' tzunj xjal nejl twitz Jesús, tej cypon lk'exin ti' mos̈, bix oc ilenkexin ti' mos̈ tu'n twe'xin ts̈-inxin, pero tzinx k'olbenxxin ti' Jesús: —¡Tiy'jil David, k'ontz lastim weya!—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tej toc tbi'n Jesús ja mos̈, bix e we'xin, bix e xi' tkba'nxin cye xjal tu'n t-xi' k'i'n mos̈ twitzxin. Tej tpon mos̈ twitzxin, e xi' tkba'n Jesús te mos̈: ");
INSERT INTO mamNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ti taja tu'n tbint wu'na ti'ja?—tz̈i Jesús. Aj ttzak'be'n mos̈: —Taat, k'ontz weya tu'n ncye'yena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","E xi' tkba'n Jesús texin: —Cxe'l nk'o'na tey tu'n cyjket tbak' twitza. Tu'nj n-oc ke tc'u'ja wi'ja, ba'n tcye'yena—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tzinx yolen Jesús tej cyjket tbak' twitz mos̈, bix e xi' lpexin ti' Jesús, bix e jawxsen tnimsa'nxin tbi Dios. Cykilcaxsen xjal, tej t-xi' cycye'yen jlu, e xi' cyk'o'n chjonte te Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bix ocx Jesús tuj tnom te Jericó, bix iy'xin betel tuj tnom. ");
INSERT INTO mamNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tujtzen tnom najle junxin xjal Zaqueo tbi. Nejenelxin cye ke chmol chojentj, bix k'inaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tej xi'nin Jesús tuj be, e tajbexin tu'n toc tcye'yenxin al tzunj Jesús, pero mix e tilexin tu'n tnimal xjal, bix cuma ch'in twe'xin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ju' tzunj bixsen iy' nejlxin tuj ajkelbil cywitz xjal, bix e jawxin twi' jun tzee' sicomoro tbi tu'n tcu'tz tcye'yenxin tii'n Jesús, cuma el tniy'xin ti'j tu'n tex Jesús t-xee' jtzee'. ");
INSERT INTO mamNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tejtzen tcana Jesús nka t-xee' jtzee' jaa' tjaxe Zaqueo, e jaw tcye'yenxin, bix e xi' tkba'nxin: —Zaqueo, nix tcu'tza, cuma il ti'j chin pomel posadayina tjay ja'lewe—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tej tbinte Zaqueo ju'wa, e cu'tzxin tuj ajkelbil, bix e tiik'xin Jesús tuj tjaxin tuya cykil tc'u'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pero tej toc cycye'yen xjal ju'wa, cykilcaxsen xjal e jaw yolen, cuma yaa'n ba'n tuj cywitz. E cykba: —Ma tz'ocx Jesús posadayil tuj tja jun aj il—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mas yaj, e cub we' Zaqueo, bix e xi' tkba'nxin te Kaaw cywitz xjal: —Taat, cxe'l nk'o'na jun niy'jan te cykilca at wuyena cye mebe, bix cyej xjal o tz'el wii'na pwak cye tisen alk'al, cxe'l nk'o'na cyaja maj t-xel—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aj ttzak'be'n Jesús texin bix cye xjal: —Te ja k'ij ja'lewe ma clet ja xjal lu, cuma tisen oc ke tc'u'j Abraham ti' Dios, jaxse ju'x ma tz'oc ke tc'u'j ja xjal lu ti' Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Il ti'j q'uelel cyni'ya ti'j o chin u'la te jyol cyej xjal o che'x tzpet, tu'ntzen cyclet—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tuj cywitz kej xjal n-oc cybi'n alcyej e xi' tkba'n Jesús, ya tu'n ttzyet tcawbil Dios tu'n Jesús, cuma ya ch'itk tpon Jesús Jerusalén. Min el cyniy' ti'j il ti'j tu'n taj nejlxin te mitkna'x tocxin te cawel. Ju' tzunj e xi' tkba'nxin jun tumel cye. ");
INSERT INTO mamNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","E xi' tkba'nxin: —At junxin xjal nintzaj. Ja tzunxin e xi' tuj jun tnom nakch, tu'ntzen tk'oj texin tu'n jxin rey tibaj cykilca tnom tu'n tocxin te cawel tuj ttanemxin tej tpon meltz'ajxin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tej mitkna'x tajxin, e xi' ttxco'nxin laaj t-ak'analxin, bix e cyaj tk'o'nxin junelne pwak te juun, bix e xi' tkba'nxin cyexin: “Ja pwak ma cyaj nk'o'na cyey, chi ak'ananxa ti'j tu'n cycamana mas,” tz̈ixin, bix ajxin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yal tzunkej xjal te ttanemxin, el cyiiq'uen jaxin, bix e xi' cysma'nxin ke cysanjelxin te rey te kbalte cyjulu: “Kcy'iya tu'n tcawen ja xjal lu kibaja,” tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero e k'oj texin tu'n tocxin te cawel tibaj ttanemxin, bix tej tpon meltz'ajxin, e xi' ttxco'nxin kej laaj t-ak'analxin otk cyaj tk'o'nxin pwak cye, tu'ntzen tbintexin jte' pwak otk tcaman jaca juun. ");
INSERT INTO mamNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ul jtneel t-ak'analxin, bix e xi' tkba'nxin te cawel: “Taat, jpwak e cyaj tk'o'na weya, ma japan tuj laaj,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","E xi' tkba'n cawel texin: “Jay jun ba'n ak'anal. Cuma ba'n ma bint tu'na ti'j ch'in e cyaj nk'o'na tey, ju' tzunj cxe'l nk'o'na tey tu'n tcawena tibaj laaj tnom,” tz̈i cawel. ");
INSERT INTO mamNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bix ul tcab t-ak'analxin twitzxin, bix e xi' tkba'n te cawel: “Taat, jpwak e cyaj tk'o'na weya, ma japan tuj jwe',” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jax e xi' tkba'n cawel texin: “Cuma ba'n ma bint tu'na ti'j ch'in e cyaj nk'o'na tey, ju' tzunj cxe'l nk'o'na tey tu'n tcawena tibaj jwe' tnom,” tz̈i cawel. ");
INSERT INTO mamNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Bix ul juntl twitzxin, bix e xi' tkba'n te cawel, “Taat, lu jpwak e cyaj tk'o'na weya. Bi'x e cub nẍpo'na tuj jun su'tj. ");
INSERT INTO mamNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Min in ak'anana ti' tpwaka tu'n ttz̈'iy, cuma at ttz̈i wi'ja jac'a otk txi' tz'ak, cuma tey cyiw tnaabla. Nuk taja tu'n ttz̈'iy tpwaka. Ntz̈'iy tpwaka nuk tu'n cyak'mal xjal, bix njtx'ona tuj j-e cu'x tawa'n juntl,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bix aj ttzak'be'nxin te: “Tey jun ak'anal yaa'n ba'n. Jtey tyol c'ajbel tu'n tchic'ajax at tpalta. Ka tuj twitza inayena jun xjal at il ti'j tu'n ttz̈'iy npwaka, bix tu'n ncamana tu'n cyak'mal juntl wik xjal, ");
INSERT INTO mamNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿tikentzen min e xi' tk'o'na npwaka tuj banco, tu'ntzen ttz̈'iy tuj tk'ab juntl xjal? Nuket e bint tu'na ju'wa, otetle ttz̈'iy tuya tal tej wul meltz'aja,” tz̈i cawel. ");
INSERT INTO mamNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bix e xi' tkba'n cawel cyej xjal ete'c'a twitzxin: “Cyimel jpwak tej xjal lu, bix cyk'onx tej xjal e caman laaj e japana tu'n,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","E xi' cykba'n te cawel: “Taat, pero ya ma japan tuj laaj tu'n,” tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aj ttzak'be'n cawel: “Cxe'l nkba'na cyey, jxjal e caman ti'j e k'oj te, mastl ck'ojel te, pero ja tzunj xjal mintii' e tcama, ti'j e k'oj te, q'uelel k'i'ntl te. ");
INSERT INTO mamNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yaltzen cyej xjal el cyxoo'n inayena bix cycy'i tu'n ncawena cyibaj, cyii'ntzke tzalu bix cybyo'nc'ake nwitza,” tz̈i cawel—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tej tbaj tkba'n Jesús kej yol lu, bix exxin tuj Jericó, tu'ntzen tponxin Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tujtzen be at ca'ba coc' tnom Betfagé tbi bix Betania tbi juntl. Ete'c t-xee' jwitz Olivos tbi. Tej tponxin cytxa'nj niy' tnoma, e xi' tkba'nxin te ca'ba t-xnak'atzxin: ");
INSERT INTO mamNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Waja tu'n cyxi'y tuj ni' tnom lu. Oj cypona, c'oquel cycye'yena yo'lc'a jun bur. Jatzen jun burja min-al xjal o jax ke tibaj. Cypjumeltzen, bix cyii'ntz. ");
INSERT INTO mamNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ka at xjal ma tz'oc kanente cyey: “¿Titzen n-ela cypju'na jjil bur?” ka tz̈ike ju'wa, bix cxe'l cykba'na: “Ja jilja c'ajbel te Kaawa,” tz̈i cybela—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bix e xi' kej ca'ba t-xnak'atzxin, bix oc noj jbur yo'lc'a cywitz, tisenx otk tkba Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tej tel cypju'nxin, bix oc noj ke taaw bur cyi'jxin, bix e xi' cykanen cyexin: —¿Titzen n-ela cypju'na jjil bur?—tz̈ike. ");
INSERT INTO mamNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","E xi' cykba'nxin: —Ja jilja c'ajbel te Kaawa—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bix e xi' cyii'nxin bur twitz Jesús, bix e jax cyk'o'nxin cycapẍeyenxin tuj tzalti'jjil te jun k'ukbil, bix e jax cyk'o'nxin Jesús tibajjil. ");
INSERT INTO mamNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bix e xi' bet bur, bix e baj cub cyliy'pa xjal cycapẍeyen tuj tbe bur tuya Jesús, tisex tten oj n-ocx jun cawel. ");
INSERT INTO mamNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tej tpon lk'e Jesús nka tibaj tnom te Jerusalén, tejtzen cubnenx tcubxin tibaj tnom tc'u'j jwitz te Olivos, cykilca kej xjal lepchec ti'jxin bix ak' najke nimsaljawte tbi Dios tu'nj cytzalajebl. Otk cyil jjawnex tipemal e xi' tyeec'an Jesús, bix tuya nim s̈itz̈'bil ");
INSERT INTO mamNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","e xi' cykba'n: —¡Tzajxit nim xtalbil tibaj ja kcawel sma'n tu'n Dios lu! ¡Chjonte te Dios! ¡At-xit tzalajebl tuj cya'j, bix jawxit nimset tbi Dios!—tz̈i ke xjal tuya nim s̈itz̈'bil. ");
INSERT INTO mamNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Cyxoltzen tnimal xjal tocxe cabxin fariseo, ejee'j xin oc ke cyc'u'j te nimlte ley. E xi' cykba'nxin te Jesús: —Taat Xnak'tzal, k'umenx cyej xjala tu'n mi'n chi cub ten s̈-il ka jay Jcawel sma'n tu'n Dios—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aj ttzak'be'n Jesús cyexin: —Cxe'l nkba'na cyey, ka c'oquel cymayo'na tu'n tk'umj cyu'n xjal ma tzul Jcawel sma'n tu'n Dios, ejee'tzen xak chi jawel yolel te kbalte, cuma il ti'j tu'n tk'umj tpocbal—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tejtzen tpon lk'e Jesús ttxa'n tnom te Jerusalén, oc tcye'yenxin ti' tnom, bix ak'xin ook'el. ");
INSERT INTO mamNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Bix e xi' tkba'nxin: —Key aj Jerusalén, nuket tz'el cyni'ya ti'j alcyej tu'n tbint cyu'na tu'n cytena tuj ttz̈yal. Tex ja k'ij ja'lewe matketle nxi' nk'o'na cyey tu'n cytena tuj ttz̈yal nuket nchi ocslana wi'ja, pero min tz'el cyni'ya ti'j al kena. ");
INSERT INTO mamNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nuket tz'el cyni'ya ti'j, cuma tzul jun k'ij oj cyul te k'ojlel cyi'ja kej xjal n-el cyiiq'uen ejee'y. C'oquel cysut'en cyiib ke soldado ti'j cytanema, tu'ntzen mlay chi el oka. ");
INSERT INTO mamNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ejee'tzen chi cwel xitente cytanema, bix pjel cybyo'n cykilca xjal tuj. Mi nuket jun xak bix cyaj tibaj juntl. Pjel ju'wa cuma te ja k'ij ja'lewe min xcyocslay tej sul Dios te onlte cyey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tej tpon Jesús tuj Jerusalén, ocxxin tuj tja Dios, bix etz tlojo'nxin kej xjal ete'cx q'ueyel tuj. ");
INSERT INTO mamNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","E xi' tkba'nxin cye: —Tz'i'ben tuj tyol Dios cyjulu: “Il ti'j tu'n tajben njaya te naablte nbi'ya,” tz̈i Dios. Pero cyey, ma tz'oc cyk'o'na te jun cyja alak'—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jaca k'ij ocx Jesús tuj tja Dios te xnak'tzal cye xjal. Pero ejee' tzunj xin nejenel cye pala cyuya tx'olbal ley bix ke nejenel te tnom e cyajbe tu'n tbyet-xin, bix oc cyipenxin ti'j tu'n ti ctemela tu'n tbyet. ");
INSERT INTO mamNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero min e cnet ttxolan cyu'nxin ti tten tu'n ttzyet cyu'nxin, cuma cykilcatl te xjal toc ebil texin, bix ba'n tyolxin tuj cywitz. ");
INSERT INTO mamNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Te jun k'ij ocx Jesús tuj tja Dios te k'olte xnak'tzbil cye xjal bix te k'umlte jba'n tpocbalel tcawbil Dios. Bix e pon kej pala mas nintzaj, cyuyax tx'olbal ley bix kej nejenel cye xjal te tnom, ");
INSERT INTO mamNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bix e xi' cykba'nxin te Jesús: —Kbantz keya, ¿ti tey toclena tu'n tbinchana cykilcaj nbint tu'na tuj tja Dios? ¿Bix al e k'onte toclena tu'n tbint jlu tu'na?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aj ttzak'be'n Jesús cyexin: —Jax ju'x weya cxe'l nkanena cyey. Cykbantz weya, ");
INSERT INTO mamNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","tej t-xi' tk'umen Juan Bautista tzul Jscy'o'n tu'n Dios bix e cu'x ke xjal tuj a' tu'nxin, ejee'j xjal e cyajbe tu'n tul cyil tuj cyc'u'j bix tu'n binne cyten tej tulxin, ¿al e k'onte toclen Juan tu'n tbint jlu tu'nxin? ¿Japa Dios, ma jaxxin?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bix ak' kej xin pala bix kej xin tx'olbal ley yolel cyxolx ti tten tu'n taj cytzak'be'nxin: —E tkbaxne jxin Juan Bautista ja Jesús Jscy'o'n tu'n Dios. Katzen ma txi' kkba'n te Dios taak'en Juan Bautista, ctkba'tzen Jesús ke: “Ka ju'wa, ¿tikentzen min e cyocslay tyol?” tz̈i tbel ke. ");
INSERT INTO mamNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero ka ma txi' kkba'n yaa'n te Dios taak'en e bint tu'n Juan, sino e tk'umexin nuk texxin tyolxin, ka ko tz̈i ju'wa, ko cweltzen tu'n xak cyu'n xjal, cuma tuj cywitz xjal, tyolel Diosxin—tz̈ikexin cyxolxxin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ju' tzunj e xi' cykba'nxin te Jesús: —Mintii' tumel kuyena ka te Dios taak'en e bint tu'n Juan Bautista, bix ka min—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Bix e xi' tkba'n Jesús cyexin: —Ka cycy'iy txi' cykba'na al e tzaj k'onte toclen Juan Bautista, jax mlay txi' nkba'na cyey al e tzaj k'onte weya woclen—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Bix e xi' tkba'n Jesús jun tumel cye xjal: —At junxin xjal e cu'x tawa'nxin uva tuj ttx'otx'xin. Bix e cub tninc'u'nxin cyuya ke t-ak'analxin tu'n t-xi' cycye'yen ti'j tawalxin, niy'jantzen twitz awal te cye bix niy'jantzen texin. Bix e xi'xin tuj jun tnom nakch, bix e tenxin nim tyem. ");
INSERT INTO mamNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tejtzen tpon tumel tu'n t-xilj uva, e xi' tsma'nxin jun tsanjelxin cyuya t-ak'analxin, te k'ilte niy'jan texin. Pero tej tpon tsanjelxin, bix oc cypju'n ke t-ak'analxin, bix aj cysma'nxin mintii' ch'in k'i'n tu'n. ");
INSERT INTO mamNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bix e xi' tsma'n taaw tx'otx' juntl tsanjelxin cyuya. Tej tpon sanjel, jax ju'x e baja oc pjet cyu'nxin bix e baj yaset, bix aj mintii' ch'in k'i'n tu'n. ");
INSERT INTO mamNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bix e xi' tsma'n taaw tx'otx' juntl te toxen, pero jax ju'x e baj cyyasen ke t-ak'analxin, bix el cylojo'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","E xi' tkba'n taaw tx'otx': “¿Ti pjel weya? Cxe'lne nsma'na o'cxc'a junx ncwala n-oc tak' weya. Kape cyniman ja ncwala oj tpon,” tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero tej t-xi' cycye'yen ke ak'anal tcwalxin, e xi' cykba'nxin cyxolxxin: “Lu jk'a tcwal jxin taaw tx'otx' tzule. Tele tek'a cyjela ja tx'otx'a te tkabk'a. Ko kbya'c'ak'a, tu'ntzen tcyaj te ke,” tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bix ex cyii'nxin tuj cojbil, bix e cub cybyo'nxin—tz̈i Jesús. Bix e xi' tkba'ntl Jesús cye xjal: —¿Ti tse' taaw tx'otx' ke t-ak'anal? ");
INSERT INTO mamNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cxe'l nkba'na cyey, tzulxin bix chi cwel tbyo'nxin kej ak'anala bix cninc'ulxin ti'j cyuya cabtl xjal—tz̈i Jesús. Tejtzen toc cybi'n xjal tyol Jesús, eltzen cyniy' cyi'j t-ak'anal taaw tx'otx' jun cyechel nejenel cye xjal cyxol judío el cyiiq'uen Jesús, bix e xi' cykba'n: —¡Min! Mlay tz'el cyiiq'uen Jsma'n tu'n Dios ju'wa—tz̈i ke xjal tuj tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Oc tcye'yen Jesús ejee', bix e xi' tkba'nxin: —Tzin cykba'na mlay tu'n tel iiq'uet Jscy'o'n tu'n Dios, pero ka ju'wa, ¿tikentzen tzin tkba'n tyol Dios ti'j Scy'o'n tu'n Dios cyjulu: “Jxak el cyiiq'uen ke binchal jaa', c'oquel xak tej xak mas nintzaj te t-xee' jaa',” tz̈i tyol Dios? ");
INSERT INTO mamNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jatzen xak kbalte ti pjel cye xjal. Alj xjal ncub tz'ak twi' jxak lu, bi'x cwel buchj tu'n, bix oj ttzaj tz'ak jxak lu tibaj jun xjal, bi'x cwel patz'ex—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tex jk'ij, e cyajbe ke tx'olbal ley bix kej pala mas nintzaj te tzyulte Jesús, cuma el cyniy' ti'j tumel cyi'j t-ak'anal jxin taaw tx'otx' e cub cybyo'n jk'a tcwalxin, cyi'jx toca ti japenina ja yola. Pero min e cub cytzyu'n jaxin, cuma at cytz̈i xjal cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pero e jyonkexin tumel ti tten tu'n tcub tz'ak Jesús tuj cyk'abxin. E xi' cysma'nxin ke cyxelxin te xkelbilte te Jesús ti' tyol, tisenc'a e cyajbe tu'n cybinte alcye tnaablxin. Oc cyipen tu'n tcub tz'ak Jesús tuj tyol tu'nj tkbantexin ka' ti'j Roma, tu'ntzen ba'n t-xi' cyii'n jaxin twitz gobernador te kbalte ka yaa'n ba'n tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","E xi' cykanenxin: —Xnak'tzal, ktzki'na jxnak'tzbil tzin tk'o'na jaxxix yol, bix nuk tuj tumel tzin tk'umena. Mintii' tey tzin tyeec'a pabl cye xjal. Judíole, aj Romale, mintii' cytz̈i ti'ja te kbalte cye cykilca xjal ti taj Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ju' tzunj, kbantz keya, ¿tajpa Dios tu'n t-xi' kk'o'n te cawel te Roma jchojentj tzin tkanen ke, bix ka min?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","El tniy' Jesús ti'j nuk e cyajbe tu'n tcub tz'ak tuj tyolxin, tu'ntzen ttzaj tk'oj jxin gobernador oj taj ttzak'be'nxin tu'n yaa'n il ti'j tu'n t-xi' cychjo'n judío chojentj te Roma, bix ka tu'n ttzaj cyk'oj judío oj t-xi' tkba'nxin jtajbil Dios tu'n t-xi' cychjo'n judío chojentj te Roma. E xi' tkba'nxin cye: ");
INSERT INTO mamNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Cyyeec'atz jun pwak weya. ¿Ale tzunj witzbaj tcub twitz ja pwaka, bix ale biybaj toc tjak' witzbaja?—tz̈ixin. Aj cytzak'be'nxin: —Te cawel te Roma—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","E xi' tkba'n Jesús cyexin: —Ka ju' ttena, cyk'onx te cawel te Roma alcyej te, bix cyk'onx te Dios alcyej te Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ju'tzen e baj min e bint cyu'nxin tu'n tcub tz'ak Jesús tuj cyxkelbilxin cywitz xjal. E jaw klee'kexin, bix min ak'tlkexin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mas yaj e pon tuya Jesús juntl cloj xjal, saduceo tbi cycloj. E cykba juntl clojxin lu mlay chi jatz itz'j cyimne juntl maj tuj cyamecy, tisen tzunj e tkba Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","E xi' cykanexin texin: —Xnak'tzal, e cyaj ttz'i'ben Moisés ja ley lu: “Ka ma cyim jun xinak, bix ka min-al tal t-xu'l, il ti'j tu'n tmaje jun ttzicy bix ka jun titz'en tuya t-xu'l, tu'ntzen titz'j jun tiy'jil, tu'ntzen mi'n naj tiy'jil,” tz̈i tley Moisés. ");
INSERT INTO mamNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Attzen jun maj at jun cloj te wuuk xinak cyitz'en cyiib. E maje cytzicy tuya jun xuuj, pero e cyimxin, bix min-al tcwalxin e cyaj. ");
INSERT INTO mamNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bix e maje tneel titz'enxin tuya t-xu'lxin, tisen tzin tkba'n tley Moisés, pero jax ju'x e cyimxin, bix min-al tcwalxin e cyaj. ");
INSERT INTO mamNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ju'x e baj te toxen. Cykilcaj wuuk e maje tuya junx cyxu'lxin, bix cykilcakexin e cyimkexin, bix minxn-al jun cycwalxin e tzaj ti' xuuj. ");
INSERT INTO mamNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lepchxetzen tej tbajtl te xuuj. ");
INSERT INTO mamNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ojtzen cyjatz itz'j ke cyimne juntl maj tuj cyamecy, ¿altzen cyxolj wuuk xinak c'oquel te tchmil ja xuuj? ¿Yaa'mpatzen il ti'j tu'n cyoc cykilcaj wuuk xinak te tchmilxuj, cuma tchmilbaxuj ejee'?—tz̈i ke saduceo, tu'n tcub cyyeec'an at pajbaj tuj cya'j ka ma chi jatz itz'j ke cyimne tuj cyamecy juntl maj. ");
INSERT INTO mamNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aj ttzak'be'n Jesús cyexin: —Twitz tx'otx' at najle'n. ");
INSERT INTO mamNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero cyxolj xjal ck'ojel cye tu'n cyjatz itz'j tuj cyamecy juntl maj, bix min-altltzen te cmajebel. ");
INSERT INTO mamNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ya mintii'tl il ti'j tu'n cyitz'j nee', cuma ke xjal ya mi'n chi cyimtl. Chi oquel tisen ke tsanjel Dios tuj cya'j min chi cyim. Mlay chi cyim xjal, cuma jchunk'lal ck'ojel cye tisen tchunk'lal Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tuj cywitza, oj cycyim xjal, cyimneke te junx maj. Pero yaa'n ju'wa. C'oquel cyc'u'ja ti'j e cyaj ttz'i'ben Moisés jun xnak'tzbil cyi'j xjal o cyim. Tej tyolen Dios tuj jun c'ul ch'i'x tuya Moisés, ja tzunxin e kbante cyjulu: “Inayena Tdios Abraham bix Tdios Isaac bix Tdios Jacob,” tz̈i Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nukettzen cyimnen kej lu te junx maj tisen tzin cykba'na, minttzele e tkba Dios te Moisés ka jaxin Cydios, cuma texin nuk Cydios kej xjal i'tz jaxin. Tuj twitz Dios, luke i'tz kej xjal o chi cyim—tz̈i Jesús cye saduceo. ");
INSERT INTO mamNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","At juun cyxol tx'olbal ley e xi' cykba'n: —Xnak'tzal, ba'n ma yolena—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tej tbaj ttzak'be'n Jesús cye saduceo, min-al juntl e tnimsa tiib tu'n tbaj t-xkelentl te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Bix e xi' tkba'n Jesús cye tx'olbal ley: —Inayen tzuna c'oquel nkanen te cyey. ¿Tikentzen e kbaj Jscy'o'n tu'n Dios te cawel tcwal jrey David? ");
INSERT INTO mamNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","C'oquel cyc'u'ja ti'j jax David e kbante ka ja Scy'o'n tu'n Dios Taawxin. Tuj u'j te Salmos tzin tkba'nxin: “E xi' tkba'n Dios te Waawiya: ‘Kequey tuj nmank'aba te tneel xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tcyaja tzalu hasta ojxe cyocx k'ojlel ti'ja tjak' tkena wu'na,’ tz̈i Dios te Waawiya,” tz̈i David. ");
INSERT INTO mamNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Cykbantz weya, tej t-xi' tkba'n David ka Taawxin Jscy'o'n tu'n Dios, ¿tiken c'oquela kk'umen ka tcwal David Jscy'o'n tu'n Dios?—tz̈i Jesús. Bix min ak'lkexin tu'n. ");
INSERT INTO mamNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bix e xi' tkba'nxin cye t-xnak'atzxin cywitz cykilca xjal: ");
INSERT INTO mamNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Mi'n txi' cyii'na cynaabla tisen nbint cyu'n tx'olbal ley. Cyaj tu'n cyiy' cyxol xjal tuya cyxbalen jawnex te yec'bil jawnexsenke, bix oj nchi bet tuj plaza, cyaj tu'n cyoc k'olbet tujxix tumel. Cyaj ejee' chi oquex nejl tuj k'ukbil mas jawnex tuj camon jaa', bix tiy' cyuj nink'ij nchi jyonxin kej k'ukbil te nimbil ti' mes. ");
INSERT INTO mamNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pero ejee', nchi kanen nim manbil cypwak cye viuda, tu'ntzen ka min xchjet cyu'n viuda, n-eltzen cyii'ntl cyjaxuj. Pero amale minttii' lastim cye viuda cyu'nxin, bix nchi na'nxin Dios nim tyem cywitz xjal, tu'ntzen nim nchi ajbenxin te Dios tuj cywitzxin. Ejee' tzunj tx'olbal ley, ck'ojel mas castiwa cye tu'n Dios cywitzj cye niy'tl aj il—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bix oc ten Jesús cyey'lte, bix e tilxin ncu'x cyk'o'n k'ina cyoybil tuj tcublel pwak tuj tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ju'x e tilxin tej tcu'x tk'o'n junxuj viuda mebe ca'ba centavo tuj tcublel pwak. ");
INSERT INTO mamNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bix e xi' tkba'nxin cye t-xnak'atzxin: —Tuj cywitza yaa'n nim ma cu'x tk'o'n ja xuuj viuda, pero cxe'l nkba'na cyey ma cu'x tk'o'nxuj mas cywitzj cykilca kej k'ina, ");
INSERT INTO mamNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","cuma nuk ch'in n-el cyii'nxin ti' nimxsen at cyuyaxin ncu'x cyk'o'nxin, pero ja tzunj xuuj lu ma cu'x tk'o'n tuya cykil tc'u'jxuj jmanc'bil k'i'n tu'nxuj tu'n titz'jxuj—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yaj ch'intl ak' ke t-xnak'atzxin yolel ti'j nintzaj tja Dios. E xi' cykba'nxin: —Cyecaxsen tcye'ncj tja Dios lu. Binne tuya ttx'otx'el nmak xak bix tbanel, bix cyecaxsen tuya tik'ch techel toc twitz xak, bix e bint tu'n cyoybil xjal—tz̈i ke t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Pero e xi' tkba'n Jesús cyexin: —Cykilcaj n-oc cycye'yena, tzul jun k'ij tu'n tbaj xitj. Mi nuket jun xak tej lu cyjel tibaj juntl—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bix e xi' cykanenxin te Jesús: —Taat Xnak'tzal, cykilca kej lu ma tkbay keya ti'j ti pjel jun k'ij, ¿jtojtzen pjel? ¿Bix alcye techel tzul te yec'bil oj ch'itk tu'n tbaj?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aj ttzak'be'n Jesús ti'j alcyej tu'n tbaj cyuj k'ij tzul: —Cyc'ojlanx cyiiba cywitz kej xjal chi ul tzpetsal cyey tuj cyocslabla ti'j jaxxix tyol Dios, cuma cyuj jk'ij chi ul, tzul nim xjal te kbalte ka ejee' Jscy'o'n tu'n Dios. “Ch'ixc'a tu'n tbaj twitz tx'otx',” tz̈i cybel. Mi'n che'x lpey cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cyuj jk'ij chi ul c'oquel nim k'oj twitz tx'otx' tnom tuya tnom, bix chi jawel meltz'aj xjal k'ojlel ti' cygobierno. Oj cybinte at k'oj, mi'n chi jaw sey'paja tu'nj at k'oj, cuma il ti'j at k'oj te mitkna'x wula. Pero kej k'oj lu yaa'nja te yec'bil ch'ixc'a tpon manc'bil k'ij—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bix e xi' tkba'ntl Jesús cye t-xnak'atzxin: —Cyuj jk'ij chi ul, chi jawel nmak tnom te k'ojlel cyuya juntl nmak tnom, bix ju' pjel tuj cykilca twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bix q'uiyela nim xcyaklajnab cyiw, bix tuj nim lugar tzul weyaj bix yabel. Bix cwel ttz̈i twitz tx'otx', bix twitz cya'j cchic'ajaxel jawnex sey'pajlenel. ");
INSERT INTO mamNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero oj mintkna'x tbaj cykilcaj lu, tu'nj lepcheckey wi'ja chi tzyetela bix chi yasjela cyu'n kej xjal nchi k'ojl wi'ja. Chi xe'l k'i'na cyu'n tuj xkela cyuj camon jaa', bix chi xe'la tuj tzee'. Bix chi xe'l txqueta cywitz cawel bix cywitz gobernador nuk wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pero oj tbint cykilcaj q'uixc'aj lu cyey, c'ajbeltzen tu'n tk'umj nbi'ya. ");
INSERT INTO mamNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ju' tzunj mi'n chi labta cyi'jxa, ti'j ti tten tu'n cyclon cyiiba tu'n cytzakpeta. ");
INSERT INTO mamNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Jaca maj oj cyyolena wi'ja cywitz cawel, inayenxa cxe'l onenta cynaabla. Amale c'oquelet cyc'u'j ti'j tu'n tcub cyyeec'an yaa'n jaxxix cyyola wi'ja, pero mlay tz'el cyii'n tipemal cyyola. Mlay maket cyyola cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pero yal te cyey, chi xe'l q'ueyeta tuj cyk'ab cawel. Hasta cyexa cymana bix cytzicya bix cyitz'ena bix ke te cyjay bix ke cyuyey cxe'l cyq'ueyen ejee'y tuj cyk'ab cawel, bix juun cyey chi cwel byeta. ");
INSERT INTO mamNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Cykilca xjal q'uelel cyiiq'uen ejee'y tu'nj cyk'on cyiiba wuyena. ");
INSERT INTO mamNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero yal te cychunk'lala te junx maj, min-al ba'n toc ipan ti'j. Mi nuket jun ttzmal cywi'y cnaal. ");
INSERT INTO mamNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ka ma tziy'x q'uixc'aj cyu'na wi'ja bix ka min chin cyaj cycye'yena, chi oquela tuj cychunk'lala te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yaltzen ti'j cykanbila ti'j jtoj tu'n tcub xitj tja Dios, oj t-xi' cycye'yena cysut'en cyiib soldado ti'j tnom te Jerusalén, q'ueleltzen cyni'ya ti'j otk pon tumel tu'n tcub xitj. ");
INSERT INTO mamNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Oj tpon tzunj k'ij, chi elxit ok kej xjal te departamento te Judea cyxol witz tu'n cyclet, bix chi etzxit kej xjal tuj Jerusalén. Kej xjal najl ttxa'n tnom, mi'ntet chi ocx tuj tnom tu'n cyclet, ");
INSERT INTO mamNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","cuma oj tpon tzunj k'ij, cwel castiwa tibaj tnom te Jerusalén, tu'ntzen tbaj tisenj e cykba tyolel Dios jatxe ootxa. ");
INSERT INTO mamNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Oj tpon tzunj k'ij, lastim kej xuuj at cyal tuj cyc'u'j bix kej xuuj nch'u'n cyal cyi'j, cuma q'uiyel nim q'uixc'aj tuj tnom bix nim cwel castiwa cyibaj aj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Chi cwel byet cyu'n soldado tuya cyspada, bix chi xe'l k'i'n te pres cyuj cabtl tnom, bix c'oquel Jerusalén tjak' cycawbil kej xjal yaa'n judío bix min nchi niman Dios, hasta ojxe tpon jk'ij tu'n twe' cycawbil. ");
INSERT INTO mamNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Cyujtzen manc'bil k'ij c-yeec'altzen twitz cya'j jbajx bina ju'wa. Bix tuj tiy' twitz tx'otx' q'uiyel sey'pajlenel cyuj tnom, bix mlay cnet cyu'n tnom ti tten tu'n twe', cuma pjel nim tk'ajk'ajel mar oj toctz punntz'aj mar twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Q'uelel cyanem xjal tu'nj ttz̈i ti pjel twitz tx'otx' cyi'j, cuma entera twitz clich'pajel cya'j tisen xlok'laj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bix oj tbaj cykilcaj lu, cyla' xjal inayena, Jsma'n tu'n Dios cye xjal, oj ncu'tza tuj jun muj tuya nim wipemala bix nchin txakakanxsena. ");
INSERT INTO mamNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Oj tak' chic'ajaxel cykil kej yec'bil lu, cyocsla'y at tu'n wula bix chi ayona wi'ja tuya cykil cyc'u'ja, cuma q'uelel cyni'ya ti'j ch'ixc'a tpon jk'ij tu'n cycleta—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bix e xi' tkba'n Jesús jun techel cyexin: —Cycye'nc ke tzee'. Cycye'nc jc'ul higuera bix ka juntl wik tzee'. ");
INSERT INTO mamNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Oj tak' xulel tzee', q'ueleltzen cyni'ya ti'j ch'ixc'a toc jbalel. ");
INSERT INTO mamNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jaxse ju'x oj wula. Oj cyak' chic'ajaxel kej yec'bil ma txi' nkba'na cyey, q'ueleltzen cyni'ya ti'j ch'ixc'a tul tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","C'oquel cyc'u'ja ti'j ti cxe'l nkba'na cyey. Kej xjal cyla' cykilca kej yec'bil ma txi' nkba'na cyey, min otk chi cyim oj tak' tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jma txi' nkba'na pjel. Cya'j bix twitz tx'otx' cwel xitj, pero nyola mlay naj. ");
INSERT INTO mamNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ju' tzunj k'o'nc cyipena ti'j tu'n binne cytena. Mi'ntet txi' tz'ak tipen cynaabla tu'nj achbil te twitz tx'otx' bix tu'n k'e'n bix tu'nj nuk nchi labta ti'j ti tten tu'n cyitz'ja. Ka ma tz'oc cyc'u'ja nuk cyi'j lu, yaa'ntzen binne cytena oj ya nulq'uetl jmanc'bil k'ij. ");
INSERT INTO mamNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tisen jun jil nuk ch'innch'e oj ttzyet tu'n c'o'bil, ju'tzen pjel tuj cykilca twitz tx'otx' cyej xjal min tz'oc cyc'u'j ti'j ka at tulel manc'bil k'ij. Ch'innch'e oj tul manc'bil k'ij oj yaa'n binne cyten. ");
INSERT INTO mamNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ju' tzunj k'o'nc cyipena ti'j tu'n i'tzkey, tu'ntzen binne cytena tuj jmanc'bil k'ij. Bix cykanenx te Dios tu'n tiy'x jq'uixc'aj tzul, tu'ntzen mintii' cych'ixewa nwitza, inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jaca k'ij e xi' tk'o'n Jesús t-xnak'tzbilxin tuj tja Dios, pero te koniyan e xi'xin tc'u'j jwitz te Olivos te wutal. ");
INSERT INTO mamNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yaltzen cye cykilca xjal, e jaw we'ke jya'x tu'ntzen cypon tuj tja Dios te ebilte Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ch'itk tul canan jnink'ij te Pascua, jaj nink'ij oj nchi waa'n xjal te Israel pan mintii' tk'anel n-ocx tuj, tu'n mi'n jaw tz̈'iy. ");
INSERT INTO mamNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bix e baj cychmon cyiib kej xin tneel pala bix ke tx'olbal ley, te ninc'ulte ti tten tu'n tbyet Jesús cyu'nxin, cuma nim xjal otk tz'oc lpe ti' Jesús, bix at ttz̈i tu'n ttzaj cyk'oj xjal cyi'jxin ka ma chi byonxin ja Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jax ju'x ocx Satanás, taaw il, tuj tanem Judas Iscariote, junxin te cyej cablaaj t-xnak'atz Jesús, cuma e tajbe Judas txi' tq'ueyen Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Bix e xi'xin yolel cyuya tneel pala bix cyuyaj xin capitán cye c'ojlal tja Dios ti'j ti tten tu'n t-xi' tk'o'nxin Jesús tuj cyk'ab. ");
INSERT INTO mamNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bix e jaw tzalajkexin, bix e xi' cykba'nxin texin tu'n t-xi' cyk'o'nxin pwak texin tu'n tonenxin cyexin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","E cyaj tk'o'nxin tyolxin tu'n tonenxin cyexin, bix ak'xin cye'yel, tu'ntzen t-xi' tk'o'nxin Jesús tuj cyk'abxin tej tten Jesús tjunal. ");
INSERT INTO mamNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bix e pon jk'ij te nink'ij oj n-etz cyii'n xjal cykilca tk'anel pan tuj cyja, jax jk'ij at il ti'j tu'n cybyet carnel tu'n tiy'set cynink'ij. ");
INSERT INTO mamNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bix e xi' tsma'n Jesús ja Pedro tuya Juan, bix e xi' tkba'nxin cyexin: —Cyucxeney bix cybincham jwaabj te xjan k'ij, tu'ntzen ba'n t-xi' kwaa'n—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bix e xi' cykanenxin texin: —¿Jaa' taja tu'n tbint waabj ku'na?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aj ttzak'be'n Jesús cyexin: —Oj cyocxa tuj tnom, cyla'y jun xinak, jun ẍok' a' k'i'n tu'nxin. Chi xe'la ti'jxin, bix oj tocxxin tuj tjaxin, bix chi ocx lpey ti'jxin, ");
INSERT INTO mamNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","bix cykbanx te taaw jaa' cyjulu: “Ma tzaj tsma'n kxnak'tzala ejoo'ya te kanlte tey: ‘¿Alcyej cwart tu'n nwaa'na cyuya nxnak'atza, tu'ntzen tiy'set Pascua ku'na?’ tz̈i kxnak'tzala,” tz̈i cybela. ");
INSERT INTO mamNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Oj tbinte taaw jaa' ju'wa, ctzaaltzen tyeec'anxin jun nim cwart cyey tuj tcab cxo'len. Tuj tzunj cwart at nim k'ukbil tuj bix jun mes. Jatztzen cybinchama waabj—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bix aj Pedro tuya Juan, bix cykilca e tkba Jesús jax e'la. Bix e bint jwaabj tej nink'ij te Pascua cyu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bix tej tpon hora te waabl, e cub ke Jesús ti' mes cyuya t-xelxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Bix e xi' tkba'nxin cyexin: —Nim o wajbe'ya tu'n wiy'sana ja Pascua lu cyuyey, jatzen manc'bil Pascuaja te mitkna'x nbyeta. ");
INSERT INTO mamNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cxe'l nkba'na cyey, mlay chin iy'santla ja nink'ij lu cyuyey hasta ojxe tjapan ti japenina tuj tcawbil Dios—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bix e jaw tii'nxin jvaso nojne tuya vino otk cub cyk'o'n t-xnak'atzxin te cyiy'sablxin nink'ij, tisex tten cyu'n xjal, bix e xi' tk'o'nxin chjonte te Dios ti'j, bix e xi' tkba'nxin cye t-xnak'atzxin: —Cyc'anx cykilcakey ja vino lu. ");
INSERT INTO mamNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cxe'l nkba'na cyey, mlay chin c'antla jvino te Pascua te mitkna'x tul tcawbil Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bix e jaw tii'nxin jun pan, bix e xi' tk'o'nxin chjonte te Dios ti'j, bix ak'xin piẍlc'ate, bix e xi' tk'o'nxin cye t-xnak'atzxin, bix e xi' tkba'nxin: —Ja pan lu jun techel nxumlala, cuma cxe'l oyet nxumlala te colbil cyey. Cywaa'nx ja pan cykilca maj ju'wa te nabl te weya—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ju'x e jaw tii'nxin vino tej tbaj cywaa'n, bix e xi' tkba'nxin: —Ja vino lu techel ntz̈'quela, cuma cxe'l oyet ntz̈'quela te Dios te cyey. Tu'nj ntz̈'quela q'uelel tz̈itj, ctemeltzen jun ac'aj ttrat Dios cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero c'oquel cyc'u'ja ti'j ja lu. Jxjal cxe'l q'ueyente weya tuj cyk'ab kej xjal nchi k'oj wi'ja, lu xjal at wuyena tzalu ti' mes. ");
INSERT INTO mamNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Il ti'j tu'n ncyima, cuma ju' o tkba Dios, ¡pero ay xsunj xjal cxe'l q'ueyente weya tuj cyamecy!—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tej cybinte t-xnak'atzxin ju'wa, e jaw klee'kexin, bix ak'kexin kanlte cyxolxxin alcye cyexin tu'n t-xi' q'ueyente Jesús tu'n tcubxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bix ju'x ak'kexin k'ojlel cyxolxxin ti'j alcye cyexin mas jawnex. ");
INSERT INTO mamNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Bix e xi' tkba'n Jesús cyexin: —Cyxol cawel te twitz tx'otx', nchi cawen nuk tu'n cyajben xjal cye. Bix kej xjal jawnex nchi jyon tu'n cykbante xjal ka nim o chi onen cyi' xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero yal cyey, mi'n cybinchay ju'wa, sino chi ajbenx cyey cyuyey. Jxjal najben cye cabtl, jatzen xjalja mas jawnex. Ka ejee'y jun cawel, cyk'o'nc cyipena ti'j tu'n cyajbena cye cabtl. ");
INSERT INTO mamNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Oj nwaa'n jun xjal ti' mes, ¿alcyej mas jawnex tuj cywitz xjal? ¿Japa jxjal nwaa'n, bix ma jaj xjal najben te? ¿Yaa'mpa jaj nwaa'n? Pero c'oquel cyc'u'ja ti'j ka inayena, cyxnak'tzala, nchin ajbena cyey. ");
INSERT INTO mamNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pero jaxte cpomel tumel chi cawela. Ejee' tzuna kej min el ok wi'ja tej cyjaw yolen cykilca xjal wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ju' tzunj, cxe'l nk'o'na cyey tu'n cycawena wuyena. Ma tzaj tk'o'n Nmana weya tu'n ncawena, bix cxe'l nk'o'ntla cyey ");
INSERT INTO mamNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tu'n cyoca te jawnex tuj ncawbila. Ck'ojel cyey tu'n cycawena cyibaj jcablaaj cloj tiy'jil Israel—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Bix e xi' tkba'n Jesús te Pedro: —Simón, Simón, c'oquel tc'u'ja ti'j cxe'l nkba'na tey. O tz'oc tkanen Satanás te Dios tu'n toca tuj niy'bebl cyuyaj niy'tl nxnak'atza. Bix taj taaw il tu'n mi'n chi e'la ba'n tuj niy'bebl, tisen tz'is oj n-el mu'pet tuj triwa. ");
INSERT INTO mamNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bix oj toca tuj xkelbil, ctzpetela, Simón. Pero o chin cubsana nwitza te Dios tu'n mi'n cyaj tcye'yena tocslabla. Oj tmeltz'aja tuya Dios, ctzaal tonena cyi'j niy'tl nxnak'atza tu'n cycywix tuj cyocslabl—tz̈i Jesús te Pedro. ");
INSERT INTO mamNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aj ttzak'be'n Pedro te Jesús: —Taat, lu kena lu tu'n nxi' lpeya ti'ja, seya tuj tzee' tocxey bix ka tu'n ncyima junx tuyey—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","E xi' tkba'n Jesús texin: —Pedro, cxe'l nkba'na tey, te ja koniyan ja'lewe, te mitkna'x took' coo', tu'n ttz̈i ti'ja otktzen txi' tkba'na oxe maj min ttzki'na nwitza—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bix e xi' tkba'n Jesús cye t-xnak'atzxin: —Tej t-xi' nsma'na ejee'y nejl tu'n cypocba'na tcawbil Dios bix tej t-xi' nkba'na cyey tu'n mi'n txi' cyii'na pwak bix cypay bix jun ch'ixpubl cyxaaba, ¿atpa ti e paltex cyey?—tz̈i Jesús. —Mintii', cuma onen ke xjal ki'ja—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Bix e xi' tkba'nxin cyexin: —Pero yal cyuj k'ij chi ul, cycy'itl xjal tu'n cyonen cyi'ja tisen nejl. Ju' tzunj, ka at cypwaka, cyii'nx, bix cyii'nx cypay. Bix ka mintii' cyspadey, cyq'ueyenx cycapẍeyena tu'ntzen t-xi' cylok'o'na jun cyspadey, tu'n cyclonte cyiiba. ");
INSERT INTO mamNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nchin yolena ju'wa tu'nj pjel wi'ja. Tzin tkba'n tyol Dios: “Tuj cywitz xjal c'oquel jxin Sma'n tu'n Dios te tajlal ka' xjal,” tz̈i tyol Dios. Ilxsen ti'j tu'n tjapan baj ja yol lu, bix ja'lewe ma pon tumel tu'n tjapan baj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tuj cywitz t-xnak'atzxin ch'itk tpon tumel tu'n cyk'ojxin cyuya xjal. Ju' tzunj e xi' cykba'n t-xnak'atzxin texin: —Taat, cye'yenx. Lu naj ca'ba spadawe at tzalu—tz̈ikexin. Pero e xi' tkba'n Jesús cyexin: —Min tz'el cyni'ya ti'j. Mi'n ko yolentl ti' spada—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bix etz Jesús, bix e xi'xin tc'u'j jwitz te Olivos, tisenx tzin tse'nxin jaca koniyan, bix e xi' ke t-xnak'atzxin tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tej tponxin, e xi' tkba'nxin cyexin: —Cykanenx te Dios tu'n mi'n cyaj cyk'o'na cyocslabla wi'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bix el lk'e Jesús cyi'jxin ca'ba oxe cuerdas, bix e cub majexin, bix ak'xin na'l Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","E xi' tkba'nxin te Tmanxin: —Taat, ka yaa'n il ti'j tu'n tiy'x ja q'uixc'aj lu wu'na, k'imal wi'ja. Pero yaa'n te weya jwajbil waja tu'n tbint, sino jaj o cub tninc'u'na tu'n tbint—tz̈i Jesús te Tmanxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bix ul jlet jun tsanjel Dios tuj cya'j twitzxin, bix oc tnimsa'n tc'u'jxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nimxsen bis oc texin, bix e na'ntlxin Dios tuyaxsen cykil tc'u'jxin. Bix e tzaj a' ti'jxin tisen tz̈iy' el tx'ut ti'jxin e cub twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tejtzen tbaj na'nxin Dios, bix e jaw we'xin, bix e xi'xin cyuya t-xnak'atzxin. Tej tponxin, nchi wutanxin tu'n cybisxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","E xi' tkba'nxin cyexin: —¿Tikentzen nchi wutana? Chi we'wey bix cykanenx te Dios tu'n mi'n chin cyaj cyk'o'na—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tzinx yolen Jesús cyuya t-xnak'atzxin tej cypon nim xjal. E xi' lpe ke xjal ti' Judas, jaj xin te tcablajan t-xnak'atz Jesús. E pon lk'e Judas ti' Jesús, bix el ttz'u'benxin twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bix e xi' tkba'n Jesús texin: —Judas, ma tzula k'olbel weya tu'n tel ttz'u'bena nwitza. ¿Tepa tq'ueybila inayena tu'nj n-el ttz'u'bena nwitza?—tz̈i Jesús te Judas. ");
INSERT INTO mamNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tejtzen tel cyniy' t-xnak'atz Jesús ti'j at tu'n ttzyet Jesús cyu'n xjal, e xi'tzen cykba'nxin te Jesús. —Taat, ¿tajpey tu'n kk'ojla cyi'j xjal lu tuya kspadiya?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bix ak' junxin t-xnak'atz Jesús buul tuya tspadaxin ti' t-ak'anal jxin tneel pala, bi'x el jtẍquinxin te tmank'abxin. Nuk yo'lectl. ");
INSERT INTO mamNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero e xi' tkba'n Jesús: —Mi'n cybinchatla ju'wa—tz̈i Jesús, bix e xi' tk'a'ctlxin jaa' e'la tx'omet. ");
INSERT INTO mamNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bix e xi' tkba'n Jesús cye tneel pala bix cye capitán c'ojlal te tja Dios bix cye xjal nejenel, ejee'j otk chi pon tzyul texin: —¿Alak'pa kena, tu'ntzen at il ti'j tu'n cyula tuya cyspadiya bix cytzee'y te tzyul weya? ");
INSERT INTO mamNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jaca k'ij ma chin tena cyxola tuj nintzaj tja Dios, pero min in tzyeta cyu'na. Pero ya ja'lewe ma pon tumel tu'n tbint ka' wi'ja tu'n taaw il, bix ma tzaj tk'o'n tipemal cyey tu'n ntzyeta cyu'na—tz̈i Jesús cyej xjal tzyul texin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bix e xi' cytzyu'nxin ja Jesús bix e pon cyii'nxin tuj tja tneel pala cyxol judío. E xi' lpe Pedro cyi'jxin, pero nakch ch'in. ");
INSERT INTO mamNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ti'jxe tja tneel pala e cub cyk'o'nxin k'ak' nakch ch'in twitz pe'n, bix oc kekexin ti' k'ak', bix jax ju'x te Pedro oc kexin ti' k'ak' cyxolxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Cyxol tzunj xin k'uklec ti' k'ak' attzen juntxin tk'opaj jxin taaw jaa'. Tej tlontetxin Pedro, cyiw ocx tcye'yentxin tuj twitzxin, bix e xi' tkba'ntxin: —Jaan tej xin lu tuya Jesús—tz̈itxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero tcy'i Pedro jtyoltxin ju'wa. E xi' tkba'nxin: —Txin, pero min ntzki'na twitzxin—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Te jun rato, ocx tcye'yen juntl xjal tuj twitz Pedro, bix e xi' tkba'nxin: —Jaan tey lepchec ti' Jesús—tz̈ixin. Pero e xi' tkba'n Pedro: —Xinak, yaa'n jaan kenwa—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Te juntl hora, e xi' tkba'n juntl xjal: —Jaxte jaan tej xjal lu tuya Jesús, cuma te cytanem cyiib te Galileake—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero e xi' tkba'n Pedro: —Xinak, min tz'el nni'ya ti'j titzen tyola—tz̈ixin. Tzinx yolen Pedro tej took' coo'. ");
INSERT INTO mamNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bix aj tcye'yen Kaaw ja Pedro, bix ul tyol Jesús tuj tc'u'j Pedro. Otk txi' tkba'n Jesús: “Te mitkna'x took' coo', otktzen txi' tkba'na oxe maj min ttzki'na nwitza,” otk txi' tkba'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bix ex Pedro bix ok' xsunxin nim. ");
INSERT INTO mamNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yal tzunkej xin otk cytzuy Jesús, oc cyxmuccha'nxin bix oc cypju'nxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Oc cymaksi'nxin twitzxin, bix e xi' cykanenxin texin: —Kbantz keya, ¿alj xjal kxola s-oc pjunte tey?—tz̈ikexin, ");
INSERT INTO mamNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","bix mas oc cyxmuccha'nxin jaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tej kskix, e chmet ke xjal nejenel bix kej xin tneel pala bix ke tx'olbal ley, bix e xi' cyii'n jxin c'ojlal Jesús ja Jesús cywitzxin. Bix e xi' cykba'nxin texin: ");
INSERT INTO mamNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Kbantz keya, ¿japa tey Jscy'o'n tu'n Dios te cawel?—tz̈ikexin, cuma e cyajbexin tu'n tchic'ajax nk'ojl Jesús ti'j cawel te Roma. —Bix aj ttzak'be'n Jesús: —Ka ma txi' nkba'na cyey inayena Jscy'o'n tu'n Dios, mi'n chin cyocslay. ");
INSERT INTO mamNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bix ka ma txi' nkanena cyey ti'j ti toc tu'n tyol Dios ti'j Scy'o'n tu'n Dios, cycy'iy tzaj cykba'na, cuma cycy'iy cyk'umey inayena Jscy'o'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero cxe'l nkba'na cyey, tbajlenxitzen niy' jlu wi'ja, chin cwel keya tuj tmank'ab jjawnex Dios, inayena, Jsma'n tu'n Dios tu'n ntena cyuya xjal—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bix e xi' cykba'nxin cykilcakexin: —¿Tzimpa tkba'na ka jay mero Tcwal Dios?—tz̈ikexin. Bix e xi' tkba'n Jesús cyexin: —Ja tzunj yol lu, ma scy'et cyu'na wi'ja, pero mi'n tz'oc nkba'na cyey ka ma chi tzpeta—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tejtzen cybintexin ju'wa, e xi' cykba'nxin: —¿Alcyetltzen mas il ti'j tu'n kbintetl mastl ti'jxin? Ma tz'oc kbi'n jaxxin nk'umente Tcwal Diosxin—tz̈ikexin, cuma tuj cywitz jun il te junx maj oj t-xi' tkba'n jun xjal ka junxxin tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bix cykilcaj xjal otk chi chmet, e jaw we', bix e xi' cyii'nxin Jesús twitz Pilato, jxin gobernador. ");
INSERT INTO mamNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bix twitz Pilato ak'kexin xool yol ti' Jesús. E xi' cykba'nxin: —Ma tzyet ja xjal lu ku'na, cuma ma txi' t-xitenxin cynaabl ke kxjala. O tkbaxin cye xjal yaa'n il ti'j tu'n t-xi' kchjo'na kchojentja te cawel te Roma. Tzin tkba'nxin ka jaxxin jun rey scy'o'n tu'n Dios te cawel—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bix e xi' tkanen Pilato te Jesús: —¿Japa tey rey cye xjal judío?—tz̈ixin. Bix aj ttzak'be'n Jesús texin: —Jay ma scy'onte ja yol rey cye judío, yaa'n inayena—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bix e xi' tkba'n Pilato cyej xin tneel pala bix te cykilca xjal: —Mintii' til ja xjal lu ncnet wu'na—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero cycy'i xjal e we'ke cyyolen ti'jxin. E xi' cykba'nxin: —Tu'nj t-xnak'tzbilxin, nchi jaw ke xjal ti' gobierno. Tneel e xnak'tzanxin tuj Galilea, bix mas yaj e xnak'tzanxin tuj Judea, bix yal ja'lewe o tzulxin tzalu tuj Jerusalén—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tej tbinte Pilato ju'wa, e xi' tkanenxin cye xjal ka te Galilea Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tej tbintexin ka e ten Jesús tjak' tcawbil Galilea, e xi' tsma'nxin ja Jesús te Herodes, jxin gobernador te Galilea, cuma otk tzul Herodes tuj Jerusalén te nink'ij. ");
INSERT INTO mamNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tej tpon cyii'nxin Jesús twitz Herodes, e jaw tzalaj Herodes, cuma otk tz'el k'ij tu'n tajxin tilxin twitz Jesús, tu'nj nim tpocbal tik'ch otk bint tu'n Jesús, bix e tajbexin tu'n tcub tyeec'an Jesús ti ba'n tu'n twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nim e xi' tkanenxin te Jesús ti'j ti ba'n tu'n, pero min ak' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Cyuyax xsunkej xin tneel pala bix ke tx'olbal ley e pon twitz Herodes, bix nim e jaw cys̈i'nxin ẍtak'bil yol ti' Jesús twitz Herodes. ");
INSERT INTO mamNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bix ak' Herodes cyuya tsoldadoxin iic'belte Jesús bix te xmucchalte. Nuk te cyxmucchbilxin oc cyk'o'nxin jun t-xbalen rey ti'j. Bix e xi' tsma'n Herodes ja Jesús juntl maj tuya Pilato te tyec'bilxin el tniy'xin ti'j at mas tipemal Pilato twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ju' tzunj, te xsunj k'ij, e cyaj Pilato ba'n tuya Herodes, bixsen e cub cymojbitlxin cyyolxin, cuma nejl at ch'in k'oj cyxolxin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","E tzajtzen ttxco'n Pilato kej xin tneel pala bix kej niy'tl xjal nejenel, tuya nimc'atl xjal, ");
INSERT INTO mamNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","bix e xi' tkba'nxin cyexin: —Ma tzul cyii'na ja xjal lu nwitza bix ma tzaj cykba'na nkba'nxin cye xjal tu'n cyk'ojl ti' gobierno te Roma. Pero jey', ma chin jyon tilxin cywitza, pero mintii' tilxin ma cnet wu'na, tisenj tzin cyk'umena. ");
INSERT INTO mamNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jax ju'x te Herodes, mintii' til ja xjal lu ncnet tu'nxin. Matzen tzaj tsma'nxin juntl maj wuyena. Cycye'yenc, mintii' il o bint tu'n ja xinak lu tu'n tcyim. ");
INSERT INTO mamNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ju' tzunj nuk tz'u'n cxe'l ti'j cyu'n soldado, bix oj tel tuj tz'u'n, cxe'l ntzakpi'na—tz̈i Pilato, ");
INSERT INTO mamNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","cuma at jun ley jaca jnabk'i tuj nink'ij te Pascua n-el tzakpet jun pres. ");
INSERT INTO mamNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero e jaw cys̈i'n xjal: —¡Min! ¡Kaja tu'n tcubxin! Ja te Barrabás tzakpintz keya—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ja tzunj xin Barrabás tocx tuj tzee' tu'nj otk baj tbyo'nxin cab aj Roma tuj Jerusalén tuj jun k'oj ti' gobierno te Roma. ");
INSERT INTO mamNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ju' tzunj e tajbe Pilato tu'n tel ttzakpi'n Jesús, yaa'n Barrabás, bix juntl maj e xi' tkba'nxin cye xjal tu'n tel ttzakpi'nxin Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero e jaw cys̈i'n xjal: —¡E tjaw twitz cruz! ¡E tjaw twitz cruz!—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bix e xi' tkba'n Pilato te toxen maj cye xjal: —¿Tikentzen cyaja tu'n tbyet ja xjal lu? ¿Alcye ka' o bint tu'nxin? Mintii' tka'yel j-o bint tu'nxin ma cnet wu'na tu'n tcyimxin. Ju' tzunj nuk tz'u'n cxe'l ti'jxin bix q'uelex ntzakpi'n xina—tz̈i Pilato. ");
INSERT INTO mamNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero minx e cykey xjal tyol Pilato, bix e jaw cys̈i'n juntl maj tu'nx tbyet Jesús twitz cruz, hasta tejxe cycaman tibaj tyol Pilato. ");
INSERT INTO mamNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ju' tzunj e xi' tkba'n Pilato tu'n tbyet-xin tisenj alcye cyaj xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","El ttzakpi'n Pilato Barrabás, tisenj e cyajbe xjal, jxin pres tu'nj otk k'ojxin ti' gobierno bix otk byonxin xjal. Pero yal te Jesús, e tcuyax Pilato cyyol xjal tu'n tbyet-xin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bix ex cyii'n ke soldado jaxin, bix jax Jesús e xi' kitente jtzee' cruz jaa' tu'n tcu'xe awet, tu'n tjawxin twitz. Pero e baj tipenxin, bix e cub cymaku'n soldado junxin xjal tzajninxin tuj cojbil tu'n tponxin tuj tnom, bix e jaw cyk'o'nxin cruz ti' tkul jxjal. Jxin xjal Simón tbixin, jun aj tnom te Cirenexin, bix e xi' tkitenxin cruz, bix oc lpexin ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nimxsen xjal oc lpe ti' Jesús cyuya nim xuuj. Tzinxsen n-oc cytz'ajan xuuj ti' cyin tu'n tak' tcastiwa Jesús ti' cyanemxuj, bix nchi ok'xuj tisex nbaj cyexuj oj ncyim jun xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero aj tcye'yen Jesús cyexuj, bix e xi' tkba'nxin: —Key xuuj te Jerusalén, mi'n chi ok'a wi'ja, sino chi ok'a cyi'jxa bix ti' cyala, ");
INSERT INTO mamNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","cuma tzul jun k'ij te nim q'uixc'aj te cyey bix te cyala. Tuj tzunj k'ij tzul, cxe'l cykba'n xjal: “Mas ba'n ke cyej xuuj mintii' cyal bix ke cyej xuuj bajx chi alena bix ke cyej xuuj min-al nch'u'n ti' cyin, cywitzj ke cyej xuuj at cyal,” tz̈i cybel. ");
INSERT INTO mamNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bix cxe'l cykba'n xjal cye witz: “Chi aaltz tz'aka kibaja,” bix cye bu'j: “Ko cyewacxa, tu'n kcleta cywitz kej xjal o chi ul te byolte keya,” tz̈i cybel. ");
INSERT INTO mamNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jaxte tzul q'uixc'aj cyi'ja, cuma ka ma tz'ocx cha'x tzee' tuj k'ak', ¿yaa'ntzen loj tzkij tzee' il ti'j c'oquex? Jtzin nkba'na, ka ma cub ncastiwiya mintii' wila, ¿yaa'ntzen loj cyey at nim cyila?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tuyax ca'ba binchal il e xi' cyii'n ke soldado, tu'n cybyet junx tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tej cyponxin t-xee' jun linaj Tbakel Wi'ybaj tbi, e xi' cyk'o'nxin clavos tuj tk'ab bix tuj tken Jesús twitz cruz, bix jax ju'x e tematl ca'ba binchal il twitz cycruz, jun e jaw tuj tmank'ab Jesús, bix juntl tuj tneẍ. ");
INSERT INTO mamNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Maatkxsen ncub cyk'o'n soldado Jesús twitz cruz, e xi' tkba'nxin te Dios: —Taat, najsanc'a cyil kej soldado lu ncub cybyo'n inayena, cuma min tz'el cyniy' ti'j alcyej ncub cybyo'n—tz̈i Jesús. Bix e cub cypa'n soldado t-xbalen Jesús cyxolxxin. E cub cyk'o'nxin suerte ti'j tu'n al ccamal ti' juun. ");
INSERT INTO mamNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yaltzen cye tnimal xjal, nuk oc cycye'yen ti' Jesús. Nim xjal cyxolxin, cyuya kej nejenel cye judío, oc cychmuccha'nxin ti'jxin. E xi' cykba'nxin: —Ja xjal lu o tcol nim xjal. La'tzen ka jac'a tcol te tiib ja'lewe. Ka jaxxix jaxin Jscy'o'n tu'n Dios, q'ueleltzen tco'pan tiibxin twitz cruz—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jax ju'x ke soldado oc cyxmuccha'n ja Jesús. E pon lk'ekexin ti'jxin twitz cruz, bix e xi' cykba'nxin: —Tcu'tza, ko kc'a'x ch'in c'a vino tzalu—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bix e xi' cykba'ntlxin: —Ka jay cawel cyibaj judío, clomtzen tiiba—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bix e jaw cyk'o'n soldado cab letra tuj twi' Jesús tzin tkba'n te oxe yol junx ta': “Ja xjal lu cawel cye xjal judío,” tz̈i letra tuj yol te griego bix te latín bix te hebreo. ");
INSERT INTO mamNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jax ju'x cyej xin aj il e jaw twitz cruz tuya Jesús, at junxin oc t-xmuccha'nxin ja Jesús. —Ka jay Jscy'o'n tu'n Dios, clomtzen tiiba, bix kuyaxa—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ja tzunj juntlxin aj il tjaw twitz cruz oc ilenxin ti'j xin oc xmucchante Jesús. E xi' tkba'nxin: —¡C'ola! ¿Mimpatii' tnaabla twitz Dios, aj jaana at tu'n tcyim? ");
INSERT INTO mamNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ke, ma k'oj kcastiwa tu'nj ka' o bint ku'n, pero ja xjal lu, mintii' ka' o bint tu'n—tz̈i juntlxin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bix e xi' tkba'n jxin min oc t-xmuccha'n te Jesús: —Jesús, oj toca tuj tcawbila, tak'xita weya tu'n woca tjak' tcawbila—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Bix aj ttzak'be'n Jesús texin: —Cxe'l nkba'na tey, tex k'ij ja'lewe cpomela wuyena tuj lugar te tzalajebl Paraíso tbi—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tejtzen tpon chil k'ij, bix e cub jpet jun nintzaj klolj entera twitz tx'otx', bix e ten klolj oxe hora. ");
INSERT INTO mamNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Oc klolj twitz k'ij. Bix tuyax jnintzaj xbalen tjaw tuj nintzaj tja Dios te maksibl twitzj jawnex xjan cwart jaa' u'la Dios, bi'x e cub rotj tmij. ");
INSERT INTO mamNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yal te Jesús, e jaw ts̈i'nxin te Tmanxin: —Taat, cxe'l wokxenena wanema tuj tk'aba—tz̈i Jesús. Bix tej t-xi' tkba'nxin ju'wa, ncyimtlxin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yal tzunj xin capitán cye soldado e jaw k'onte Jesús twitz cruz, tej toc tcye'yenxin cykilcaj otk baj, e xi' tkba'nxin: —Jaxte mintii' til ja xjal lu—tz̈ixin, bix e jaw nimset tbi Dios tu'nj tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yal tzunkej xjal otk chi chmet te cyey'lte tej tjaw Jesús twitz cruz, tej t-xi' cycye'yen otk cyim Jesús, bix ajke, bix ak' ke xjal tz'ajlecte ttzii' cyxuuc' tisex tten oj ncyim jun xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero ja tzunkej tuya Jesús bix kej xuuj otk chi tzaj lpe ti'j Jesús te Jerusalén tuj Galilea, e cyaj tenke, nakch ch'in, te cyey'lte ti pjel ti'j. ");
INSERT INTO mamNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Cyxol tzunkej tuya Jesús at junxin xjal José tbi. Tocx José cyxolj xin nejenel e cawen cyxol judío. Jun ba'n xjalxin bix jiquenxin twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Min otk tz'ocxxin cyxol niy'tl xjal nejenel tej tcub cyninc'u'n jun ka' ti' Jesús. Jatz itz'jaxin tuj tnom te Arimatea, jun tnom cyxol judío. Bix oc ten ti' tanemxin tu'n tul tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jatzen José e xi' tuya Pilato te kanlte t-xumlal Jesús, tu'n tocx tk'o'nxin tuj tjayel. ");
INSERT INTO mamNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","E tcuya gobernador, bix e cub tii'n José t-xumlal Jesús twitz cruz, bix oc tbalk'i'nxin jun xbalen sak ti'j. Bix ocx tk'o'nxin tuj jun tjayel anem twitz xak. Ac'aj. Mitkna'x tocx cyimne tuj. ");
INSERT INTO mamNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tej k'ij oj nbaj cybincha'n xjal tik'ch cye tu'n mi'n chi ak'ananxin te juntl k'ij, jatzen k'ij te ajlabl. Ch'itk tex k'ij, bix attzen tu'n cyxi' cyii'n xjal k'ij te ajlabl. ");
INSERT INTO mamNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yal tzunkej xuuj otk tzaj tuya Jesús tuj Galilea, bix ocx lpekexuj ti' José tuj jul tocx tuj xak, bix oc cycye'yenxuj ti e tse José t-xumlal Jesús tej tocx. ");
INSERT INTO mamNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bix e pon meltz'ajkexuj tuj tnom, tu'n cybinchanxuj c'oc'sbil cye xjal, tu'ntzen toc cysu'nxuj ti' t-xumlal Jesús tbajlenxitl k'ij te ajlabl. Pero tneel ajlankexuj tuj k'ij te ajlabl, tisen tzin tkba'n cyley. ");
INSERT INTO mamNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tejtzen tpon tneel k'ij te smant, jya'xsen e xi' kej xuuj te Galilea tuj lugar jaa' tocxe t-xumlal Jesús. E pon cyii'nxuj jc'o'csbil cye xjal otk bint cyu'nxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tej cyponxuj, yalj xak oc te tlemel tjayel Jesús ya mintii'tl tcub. ");
INSERT INTO mamNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bix ocxkexuj tuj jul, pero yalj t-xumlal Kaaw Jesús min e cnet cyu'nxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Min el cyniy'xuj ti'j tiken mintii'tl t-xumlalxin tocx. Pero nuk tisen tii' tej cyul jlet ca'ba xinak wa'c'ake cytxlajxuj. Toc cyxbalen cyi'j nkoptz'aj bix ntxakakan. ");
INSERT INTO mamNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","E jawxsen sey'paj ke xuuj cyi'j, bix e cub cyyut'en cyiibxuj. Bix oc yolen ke tsanjel Dios tuj cya'j cyi'jxuj: —¿Tiken nchi jyona ti' jun xjal i'tz cyxol cyimne? ");
INSERT INTO mamNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Min-altl te Jesús tzalu, cuma ma jaw itz'j juntl maj. ¿Na'mpa cyu'na ti e tkba Jesús tej ttenxin tuj Galilea? ");
INSERT INTO mamNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","E tkbaxin nejl: “Il ti'j tu'n nk'oja tuj cyk'ab aj il, inayena, jxin Sma'n tu'n Dios tu'n ntena cyuya xjal, bix tu'n njawa twitz cruz tu'n ncyima. Pero te toxen k'ij il ti'j tu'n njaw itz'ja tuj mukbil,” tz̈i Jesús—e cykba ca'ba tsanjel Dios cye xuuj. ");
INSERT INTO mamNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bix ul tuj cyc'u'jxuj kej tyol Jesús lu, ");
INSERT INTO mamNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","bix aj meltz'ajkexuj ttzii' tjayelxin tu'n tbaj cykba'nxuj cyej junlaaj t-xnak'atz Jesús bix te niy'tl xjal ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kej xuj xuuj e xi' kbalte tpocbal cye t-xel Jesús, ejee' tzunj xuj lu: María Magdalena, bix Juana, bix María, ttxu Jacobo, tuya cabtlxuj cyuyaxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero tej cyak'xuj kbalte, min e cyocsla t-xnak'atz Jesús cyyolxuj. Tuj cywitzxin, nuk otk jaw cyjlo'nxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yal te Pedro, e tajbexin tu'n tcyaj tuj tzinen cyyolxuj, bix e xi' ajkelenxin jaa' otk tz'ocxe maket Jesús. Tej tponxin, bix ocx tcye'yenxin tuj jul. Pero nuk jaj xbalen oc balk'et ti'jxin e tilxin, ko'lecx tuj jul. Min-al Jesús. Bix elxin ttzii' jul, bix e xi'xin tuj juntl lugar tu'n ttenxin tjunalxin, te bislc'ate ti'j ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tex k'ij, xi'nin ca'ba xjal tuj tnom te Emaús, te oxe ajlabl ta' tuya Jerusalén. Ejee'n tzunxin cyxol kej otk tz'oc ebinte cyyol xuuj ti'j min-al Jesús tuj tjayel. ");
INSERT INTO mamNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nimxsen e yolenke tuj be ti'j cykilcaj matkx baj ti'j Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bix tej ttzyu'n tyol jilj cyu'n nchi bet, jax Jesús e pon cytxlaj, bix e xi' cyjunen cyiib. ");
INSERT INTO mamNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero amale oquet cycye'yen jaxin, pero min el cyniy' ti'j alcyexin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Bix e xi' tkba'n Jesús cye: —¿Ali'j nchi labtey?—tz̈i Jesús. Bix e we'ke tuj be, chic'aj otk tzaj cybis cywitz. ");
INSERT INTO mamNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bix e xi' tkba'n jun cye, Cleofas tbi: —Cyxoltzen cykilcaj xjal o chi ul tuj Jerusalén, nuk o'cx jay min o tz'oc tbi'na ti e baj ca'baje—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Bix e xi' tkba'n Jesús cye: —¿Ti e baj? Bix aj cytzak'be'n: —Oc cybincha'n jun ka' ti' junxin aj Nazaret Jesús tbi. Jaxin jun tyolel Dios, bix jawnex tbinchbenxin bix tyolxin. E ten t-xtalbil Dios tibajxin, bix elxin ba'n cywitz cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero kej xin tneel pala bix kej xjal nejenel e xi' cyk'o'nxin jaxin tuj tk'ab jwikxitl gobierno ncawen kibaj, tu'n tbyet-xin, bix e cub byet-xin twitz cruz tisen jun binchal ka'. ");
INSERT INTO mamNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jun lastim jlu, cuma otk tz'oc ke kc'u'ja ti'jxin tu'n cyclet xjal te Israel tuj cyk'ab Roma tu'nxin. Pero ya ma baj tilel, cuma e cyimxin ca'baje. ");
INSERT INTO mamNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero at jun ma baj. Te klax jatxe may' xi' cab xuuj kxola jaa' ocxe maket Jesús, bix tej ẍi pon meltz'ajxuj kbalte, xko jaw klee'ya ti' cyyolxuj. ");
INSERT INTO mamNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","S-aj cykba'n keya mintii' t-xumlal Jesús xcnet cyu'nxuj, bix otk chi ul jlet cab tsanjel Dios tuj cya'j cywitzxuj jaa' e maketaxin, bixsen xcykba tsanjel Dios cyexuj ka i'tz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ju' tzunj at juun kxola ẍi x-aj tuj tjayel Jesús, bix tej s-oc cycye'yen ju'x tten tisej xcykba xuuj. Bix yal te t-xumlal Jesús, min xcnetl cyu'n tuj tjayelxin—tz̈i ke ca'ba betel te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Bix e xi' tkba'n Jesús cye: —Key xjal yaa'n i'tz cynaabla, min o tz'el cyni'ya ti'j cykilca e cykba tyolel Dios ootxa. ");
INSERT INTO mamNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mimpa na'n cyu'na il ti'j tu'n tiy'x q'uixc'aj tu'nj Scy'o'n tu'n Dios? Yaa'n nuk tu'n toc te Cawel, sino tuj tneel tu'n tiy'x q'uixc'aj tu'n, e cykba tyolel Dios—tz̈i Jesús cye. ");
INSERT INTO mamNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bix ak' Jesús tx'olbalte cye ti'j cykilca tz'i'ben tuj tyol Dios ti'jxin. E cub ttx'olba'nxin ti e cub tz'i'ben Moisés ti'jxin bix jax ju'x ti e cub cytz'i'ben ke tyolel Dios. ");
INSERT INTO mamNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tej cyponxin tuj tnom te Emaús, otketle txi' Jesús txucl, ");
INSERT INTO mamNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","pero e cubsan kej ca'ba xjal cywitz texin tu'n mi'n txi' lk'exin mas. E xi' cykba'n: —Tcyaja kuyena tzalu, cuma ya kaletl. Ch'ix tex k'ij—tz̈ikexin. E tcuya Jesús, bix e cyajxin cyuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tejtzen cycub ke ttxa'n mes te waa'l, e jaw tii'n Jesús jun pan, bix e xi' tk'o'nxin chjonte te Dios ti'j. Bix e cub tpiẍenxin pan, bix e xi' tk'o'nxin cye tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tej tbint tu'nxin ju'wa, bixsen el cyniy' jca'ba xjal ti'j alcyexin, ka ja Jesús. Bix te jun ni' rato e cub naj Jesús cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bix ak'ke cyca'bel yolel cyxolx: —Jaxte ja xjal lu ja Jesús. ¿Ti min s-el kniy' ti'j ka ju'wa tej tcub ttx'olba'nxin tyol Dios ke tuj be, cuma xjawxsen noj kc'u'j tuya nim tzalajebl ti'j tyolxin?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ju' tzunj, te jun ni' rato nchi jaw we'tl cyca'bel ti' mes bix e tzyet cybe tu'n cypon meltz'aj Jerusalén, tu'ntzen t-xi' cyk'umen cyej junlaaj t-xnak'atz Jesús ka i'tzxin. Tej cypon, e cnet ke t-xnak'atz Jesús cychmon cyiib cyuya cabtl cyuya. ");
INSERT INTO mamNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kej otk chi chmet e xi' cykba'n cyej ca'ba aj Emaús: —¡At jun jawnex tpocbal Jesús! ¡Ma jatz itz'j Kaaw tuj cyamecy! Jaxte, cuma sul jlet twitz Simón—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bix ak' kej ca'ba xjal te Emaús kbalte ti otk baj cyexin tuj be, bix ju'tzen e'la cyniy'xin ti'j ka jaxin Jesús tej tcub tpiẍenxin pan te cyexin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tzinx chi yolenxin ti'j cykilca otk baj tej k'ij tej tul jlet jax Jesús wa'lc'a cyxolxin. Bix e xi' tkba'nxin cyexin: —Chi tenxita tuj ttz̈yal—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero e jawxsen sey'pajkexin, cuma tuj cywitzxin nuk tanem Jesús otk tzul jlet cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bix e xi' tkba'n Jesús cyexin: —¿Tiken ma chi jaw sey'paja? ¿Ti min cyocslay ka i'tz kena? ");
INSERT INTO mamNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cycye'yenc ke nk'aba bix ke nkena, tu'ntzen tel cyni'ya ti'j ka inayena. Cymaco'nc nxumlala, tu'ntzen tel cyni'ya wi'ja yaa'n nuk jun anem kena, cuma cytzki'na jun anem mintii' tchu'l bix mintii' tbakel, tisenj weya—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tej tbaj tkba'nxin jlu, bix oc tyeec'anxin cyexin tc'oblil clavos e xi' cyuj tk'abxin bix tkenxin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nim e jaw klee'kexin, bix e xi' cykanenxin cyxolx: —¿Jaxpate ka ja xjal jlu Jesús?—tz̈ikexin, bix e jaw tzalajkexin cuma kape jaxin. Bix e xi' tkba'n Jesús cyexin: —¿Atpa ch'in waabj tzalu?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ju' tzunj e xi' cyk'o'nxin ch'in quis̈ t-xoo'n tuya ch'in ta'l xii' texin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","E xi' tii'nxin bix e xi' tchyo'nxin quis̈ bix e xi' tc'a'nxin ta'l xii' cywitzxin, tu'ntzen tcub tyeec'anxin yaa'n jun anemxin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tbajlenxitl tzunj lu, e xi' tkba'n Jesús cyexin: —J-o baj wi'ja, jaj e xi' nkba'na cyey nejl at tu'n tbaj wi'ja. J-o baj wi'ja, jaj e cub tz'i'bet wi'ja tuj tyol Dios tu'n Moisés, bix cyu'n tyolel Dios, bix tuj Salmos, bix il ti'j tu'n tpon baj cykilca—tz̈i Jesús, ");
INSERT INTO mamNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","bix ak'xin tx'olbalte cyexin ti'j ti e tkba tyol Dios ti'jxin, tu'ntzen tel cyniy'xin ti'j. ");
INSERT INTO mamNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tu'n tpon baj twi' tyolxin, e xi' tkba'nxin: —Ju'tzen ttena. E cub tz'i'bet tuj tyol Dios il ti'j tu'n tiy'x q'uixc'aj tu'nj Scy'o'n tu'n Dios, bix il ti'j tu'n tcyimxin, bix il ti'j tu'n tjatz itz'jxin juntl maj tuj cyamecy te toxen k'ij. ");
INSERT INTO mamNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bix yal ja'lewe, il ti'j tu'n tk'umj tuj cykilca twitz tx'otx' tu'n tcyaj cyk'o'n xjal cyil, tu'ntzen tnajset cyil. Cwel tnajsa'n Dios cyil tu'nj o bint wu'na. Cytzyunx tkbaj tpocbalel colbil cye xjal wu'na tzalu tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","O cyila ti o baj bix ma tz'el cyni'ya ti'j ma txi' nkba'na cyey. Ju' tzunj il ti'j cxe'l cyk'umena j-o cyila bix e cybiy—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Te juntl k'ij mas yaj, e xi' tkba'n Jesús cye t-xnak'atzxin: —Cybi'ntz, ctzaal nsma'na Espíritu Santo te onl cyey, tisenj e tkba Nmana tu'n tk'oj cyey. Jatzen cyey, chi tenxa tzalu tuj Jerusalén te ayolte cyipemala tzul tuj cya'j—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bix e xi' tii'nxin ke t-xnak'atzxin nka ttxa'n tnom te Betania, bix e jaw tk'o'nxin ke tk'abxin twitz cya'j bix e xi' tkanenxin t-xtalbil Dios cyibaj t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tzinx kanenxin xtalbil tej tel tpa'n tiibxin cyi'jxin bix e jaw k'i'nxin tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bix e jaw cynimsa'n t-xnak'atzxin tbixin bix aj meltz'ajkexin Jerusalén. Nim e jaw tzalajkexin. ");
INSERT INTO mamNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bix ocxkexin jaca k'ij tuj jnintzaj tja Dios tu'n tjaw cynimsa'nxin tbi Dios.");
INSERT INTO mamNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tej mitkna'x tbint twitz tx'otx', ya atlj Yol I'tz te Dios. Junx ta' Jyol I'tz tuya Dios, bix jax Diosxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tuj tneel at-xin tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tu'nxin e binte twitz cya'j bix twitz tx'otx'. Tu'nxin e binne cykilca at. ");
INSERT INTO mamNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ti'jxin e tzaa' itz'j tchunk'lal cykilca, bix jaxin e k'onte cye xjal tu'n tel cyniy' ti'j jaxxix yol. ");
INSERT INTO mamNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jaxin tisen spi'yen nkoptz'aj tu'n tnaj klolj cyxol xjal. Pero min e cyocsla xjal t-xnak'tzbilxin. Nuk e cyajbe tu'n cycyaj tuj klolj. ");
INSERT INTO mamNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ultzen junxin xjal Juan Bautista tbi. Ja tzunj xjal lu sma'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jtaak'en Juan tu'n tk'umen cye xjal otk tzul spi'yen cyxol, tu'ntzen cyocslan cykil xjal ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yaa'n ja Juan spi'yen. Nuk o'cx ajbenxin tu'n tk'umenxin ti'j spi'yen. ");
INSERT INTO mamNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jspi'yen jaxxix, jaj ul jlet cyxol xjal tej tk'umente Juan, bix jaj nyeec'an alcyej jaxxix te cykilca wik xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pero amale e tzajet Jyol I'tz te Dios twitz tx'otx', bix amale tu'nxet-xin e binne twitz tx'otx', pero el cyiiq'uen xjal jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ulxin cyxol ttanemxin, pero mi nuket ejee' e cyiik' jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero kej xjal e cyiik' jaxin, ejee'j xjal oc ke cyc'u'j ti'jxin, e xi' tk'o'nxin cyoclen tu'n cyoc te tcwal Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ocke te tcwal Dios yaa'n tu'nj cyiy'jil, bix yaa'n tu'nj xjalke, bix yaa'n tu'nj cyex cyajbil. Nuk o'cx tu'nj e tzaj tk'o'n Dios tu'n cyoc te tcwal. ");
INSERT INTO mamNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jyol I'tz oc te xjal, bix e najan kxol. Bix e kil ti tten tchunk'lalxin. Min-al juntl xjal tisen jaxin. E xi' tii'nxin tnaablxin jawnex, cuma Tcwal Diosxin. Nuk jaj ba'n e tbinchaxin cye xjal, bix nuk jaj jaxxix e tkbaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ti'j tzunj xjal lu e yolena Juan Bautista cye xjal. E xi' tk'umen Juan cyjulu: “Ja tzunj xjal lu e xi' nk'umena nejl: ‘Jtzul lepchexe wi'ja, mas jawnex nwitza. Amale nejlet in itz'ja twitzxin, pero at-xxin tej mitkna'x witz'ja,’ ntz̈iya,” tz̈i Juan. ");
INSERT INTO mamNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nuk jaj ba'n tzin tk'o'nxin ke, cuma nuk jaj ba'n o kiik' cykilca ko' ti'jxin. Mintii' tbajlel t-xtalbilxin ntzaj tk'o'nxin ke. ");
INSERT INTO mamNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tu'n Moisés e tzaj tk'o'n Dios ley te ke, pero tu'n Jesucristo e tzaj tk'o'nxin xtalbil te ke bix tu'n tel kniy' ti'j ti tten jaxxix yol. ");
INSERT INTO mamNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Min-al xjal o til twitz Dios. Nuk o'cx Tcwal Dios at ttxlaj Dios o tilxin, bix o tzaj tyeec'an te ke ti tten Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","At junxin xjal e k'umen cye xjal: “Ma pon tumel tu'n tul jxin Sma'n tu'n Dios, ja Cristo,” tz̈ixin. Jatzen Juan Bautista e k'umente. At jun k'ij e pon juun pala bix juun xjal cyxol Leví tuya Juan Bautista. Otk chi tzaj cysma'n judío tuj Jerusalén. Bix e xi' cykanen te Juan: —¿Alcye tzuna?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bix aj ttzak'be'n Juan tuya jun yol jiquen. Min e cub tewenxin. E xi' tkba'nxin: —Yaa'n inayena Cristo, Jscy'o'n tu'n Dios te cawel—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bix e xi' cykanenxin texin juntl maj: —Ka yaa'n jay Jscy'o'n tu'n Dios, ¿japatzen tey ktzan tyolel Dios Elías?—tz̈ikexin. Aj ttzak'be'n Juan cyexin: —Yaa'n inayen wej tyolel Dios Elías—tz̈ixin. Bix e xi' cykanenxin: —¿Japa tey jjawnex tyolel Dios e tkba Moisés at tulel?—tz̈ikexin. —Min—tz̈i Juan. ");
INSERT INTO mamNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bix e xi' cykba'nxin texin: —Kbantz keya alcye tzuna, tu'ntzen t-xi' ktx'olba'na cyej xjal e tzaj cysma'n ejoo'ya tuyey. ¿Alcyey cxe'l kkba'na? ¿Alcye tzuna tuj twitza?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Bix aj ttzak'be'n Juan: —Nuk jun sanjel kena. Inayena jxjal e tkba tyolel Dios Isaías at tulel jaa' min-al xjal najl. Weya waak'en tu'n t-xi' nk'umena cye xjal: “Tzul Jcawel kxol. Cybinchanx cybey twitz Dios, tu'ntzen binne cytena oj tulxin, tisen e tkba ktzan Isaías.” ");
INSERT INTO mamNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kej xjal e tzaj sma'n, fariseoke, ejee'x judío cyiw xsunkexin tuj cyleyxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","E xi' cykba'nxin te Juan: —Katzen yaa'n jay Jscy'o'n tu'n Dios, bix yaa'n Elías, bix jax yaa'n jnintzaj tyolel Dios at tu'n tul, ¿tikentzen nchi cu'xa xjal tuj a' tu'na? Mintii' toclena—tz̈i ke fariseo. ");
INSERT INTO mamNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Bix aj ttzak'be'n Juan: —Inayena nuk jun xjal tu'n cycu'x xjal tuj a' wu'na. Pero cyxola at jun jawnexsen xjal, bix min tz'el cyni'ya ti'j at cyxola. ");
INSERT INTO mamNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ja tzunj xjala, jatzen xjalja at tulel lepchexe wi'ja pero mas jawnex nwitza. Jxjal at cyxola, mintlpetii' woclena tu'n tel npju'na tak'el t-xaab—tz̈i Juan. ");
INSERT INTO mamNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","E baj jyol lu ttxa'n tnom te Betania, te ocne ttzii' nima' Jordán, jaa' nchi cu'xa xjal tuj a' tu'n Juan. ");
INSERT INTO mamNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Te juntl k'ij, oc tcye'yen Juan tpon lk'e Jesús ti'jxin, bix e xi' tkba'nxin: —Lu tzunj Carnel tzula te chojbil il ma tak' Dios, tu'n tel tii'n cyil xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ja tzunj xjal lu e xi' nk'umena: “Lepchexe wi'ja tzul jun xjal mas jawnex nwitza, cuma atlxin tej mitkna'x wul itz'ja,” ntz̈iya. ");
INSERT INTO mamNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nejl, min ntzki'na twitz. Pero amale mint el nni'ya ti'j alcyexin, pero in ula tu'n cycu'x xjal tuj a' wu'na, tu'ntzen tel cyniy' xjal te Israel ti'j ya at tu'n tulxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Pero el nni'ya ti'j jaxin Jscy'o'n tu'n Dios tej toc ncye'yena tcu'tz Espíritu Santo tuj cya'j tisen jun cucu' bix e cyaj ten Espíritu Santo tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Min el nni'ya ti'j ka jaxin Jscy'o'n tu'n Dios. Pero ja Dios e tzaj kbante weya tu'n cycu'x xjal tuj a' wu'na, e tzaj tkba'n weya: “Oj toc tcye'yena tcu'tz Espíritu Santo tibaj junxin xjal bix jax cyjela ten tuyaxin, jatzen xjalja ctzaal tk'o'n Espíritu Santo cye xjal,” tz̈i Dios weya, bixsen el nni'ya ti'j alcyexin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Bix ju'x e baj ti'jxin, bix e wila. Ju' tzunj tzin nk'umena ka jaxin Tcwal Dios—tz̈i Juan cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Te juntl k'ij, e ten Juan juntl maj ttzii' nima', cyuyax ca'ba xjal lepch ti' t-xnak'tzbilxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bix iy' Jesús cyi'jxin. Cyiw oc tcye'yen Juan ti' Jesús, bix e xi' tkba'nxin: —Lu tzunj Carnel te chojbil il ma tak' Dios ni'ya—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tejtzen cybinte kej ca'ba t-xnak'atzxin tyolxin, oc lpeke ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bix aj tcye'yen Jesús, bix tej tlontexin oc lpekexin ti'jxin, e xi' tkba'nxin cyexin: —¿Ti cyaja?—tz̈ixin. —Taat Xnak'tzal, ¿jaa' najley?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Bix e xi' tkba'nxin cyexin: —Ko'tzen. Cxe'l nyeec'ana cyey jaa' nchin posadayina—tz̈ixin. Ju' tzunj, e xi'kexin tuyaxin, bix e xi' cycye'yenxin jaa' nposadayinaxin. Bix ex cyk'ijxin tuyaxin, cuma mitkna'x tpon chil k'ij tej cyponxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Cyxol tzunkej ca'ba xjal otk cybi tyol Juan bix oc lpeke ti'j Jesús, jaj xin titz'en Simón Pedro, Andrés tbi. ");
INSERT INTO mamNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jtneel e bint tu'nxin, jaj tu'n t-xi'xin tuya ttzicyxin Simón, bix e xi' tkba'nxin te: —Ma cnet Jscy'o'n tu'n Dios ku'na—tz̈ixin te ttzicyxin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bix e xi' tii'n Andrés ttzicy tuya Jesús. Ocx tcye'yen Jesús tuj twitz Simón, bix e xi' tkba'nxin te: —Jay Simón tbiy, tcwal Jonás. Pero c'oquel nk'o'na tbiy Sefas, cuma c'oquela tisen jun cyiw xak te junx maj—tz̈i Jesús. E tkbaxin ju'wa, cuma japenina jyol Sefas bix Pedro “cyiw xak.” ");
INSERT INTO mamNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Te juntl k'ij, e tajbe Jesús tu'n t-xi' tuj departamento te Galilea. Pero mitkna'x ttzyet tbexin, tej toc noj jxin Felipe twitzxin, bix e xi' tkba'n Jesús texin: —Lpe'c'a wi'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ja tzunj xin Felipe aj tnomxin te Betsaida tuj Galilea, jaxj ttanem Andrés bix Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","E xi' Felipe jyol tej xin Natanael. Tejtzen tcnet tu'nxin, e xi' tkba'nxin: —Jxin jawnex xjal e ttz'iben Moisés tuj ley bix e cykba tyolel Dios at tulel, ma tz'oc nojxin kwitza. Jatzen Jesús te Nazaret, tcwal jxin José—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Bix e xi' tkba'n Natanael te Felipe: —Yaa'n Nazaret jun nintzaj tnom. ¿Ti tten tu'n tetz jun ba'n tuj ja tnoma?—tz̈i Natanael. Bix e xi' tkba'n Felipe: —Ko'tzen, tu'ntzen toc tcye'yena jxjala—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tejtzen tlonte Jesús tpon lk'e Natanael ti'jxin, e xi' tkba'n Jesús: —Lu jun aj Israel tzula tuya jun tnaabl jiquen, cuma mintii' ẍtak'bil tuj tanem—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Bix e xi' tkba'n Natanael te Jesús: —¿Titzen ttzki'natla ka jiquen nnaabla?—tz̈i Natanael. Bix aj ttzak'be'n Jesús: —Tej mitkna'x ttzaj ttxco'n Felipe jay, otk wila jay tej tocxa tjak' tken higo—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tej tbinte Natanael ja yol lu, e xi' tkba'nxin te Jesús: —Taat Xnak'tzal, jaxte jay Tcwal Dios. Jay Cawel kibaja ejoo'ya xjal te Israel—tz̈i Natanael. ");
INSERT INTO mamNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Bix aj ttzak'be'n Jesús te Natanael: —¡Nim nchin tzalaja ti'ja! Ma chin tocslay nuk tu'nj xi' nkba'na xwila jay tjak' tken higo. Pero ctla'y nim yec'bil mas jawnex twitzj lu. ");
INSERT INTO mamNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jaxxix cxe'l nkba'na cykilca cyey, la' alcye jun k'ij cyla'y oj tjket cya'j, bix cyla'y oj cyjax bix oj cycu'tz tsanjel Dios tuj cya'j wi'ja, inayena, jxjal Sma'n tu'n Dios—tz̈i Jesús cye ac'aj t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tetzen toxen k'ij tbajlen yolen Jesús tuya Natanael, attzen jun mejoblenel tuj tnom te Caná, tuj departamento te Galilea. Bix jaan ttxu Jesús ajben tuj mejoblenel. ");
INSERT INTO mamNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jax ju'x e pon Jesús cyuya ke t-xnak'atzxin tuj jmejoblenel, cuma otk chi tzaj txquet-xin. ");
INSERT INTO mamNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tuj tzunj mejoblenel, e cub baj vino. Bix e xi' tkba'n ttxu Jesús texin: —At jun il ti'j. Mintii'tl vino—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Bix e xi' tkba'n Jesús texuj: —¿Tikentzen nbaj tc'u'ja ti'j lu, naa? Mina'x tpon hora te tu'n tchic'ajax wipemala. Oj tpon tumel, Dios kbalte—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Bix e xi' tkba'nxuj cyej niy'tl xjal nchi ajben: —Oj tpon hora, alcyej ctkba' Jesús cyey, cybinchama—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tuj tzunj jaa' at wukak chcan xak cytx'otx'el. Tuj jaca juun e xi' wink'an ẍok' a' tuj. Otk cub k'o'n tuj jaa' tu'n cyajben tuj mejoblenel te tx'ajbil cyk'ab xjal tisex tten cyxol judío. ");
INSERT INTO mamNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Bix e xi' tkba'n Jesús cyej xjal ajben tuj mejoblenel: —Cynojsanx kej chcanne tuya a'—tz̈i Jesús. Bix e cycuyaxin, bix e baj noj ke chcan tuya a' cyu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bix e xi' tkba'n Jesús cyexin: —Cyii'nctz ch'in a' ja'lewe, bix cyii'nxa te tneel calpul—tz̈ixin. E cycuyaxin, bix e xi' cyii'nxin te tneel calpul. ");
INSERT INTO mamNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Amale otket cyil jcabtlxin jaa' otk tzaa' a', pero min ttzki'n jxin tneel calpul. Bix oc tniy'be'nxin j-a' k'i'n cyu'n tuyaxin ya otk tz'octl te vino. Bix ba'nxsen e'la jvino tuj twitzxin. Ju' tzunj, e tzaj ttxco'nxin j-ac'aj chmilbaj, ");
INSERT INTO mamNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","bix e xi' tkba'nxin te: —Cykilca xjal nejl nxi' cyk'o'n vino ba'n cye xjal. Mas yaj, ojtzen t-xi' cyc'a'n xjal nim, min tz'el cyniy' xjal ti'j ka ba'n vino tzin cyc'a'n bix ka yaa'n ba'n, bix nxi' cyk'o'nx jvino yaa'n ba'nxix. Pero tey, yaa'n nejl ma tzaj tk'o'na jvino tbanelxix keya, sino texa yaj—tz̈i tneel calpul te chmilbaj tuj mejoblenel. ");
INSERT INTO mamNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ja tzunja e bint tu'n Jesús, tneel maj e tyeec'axin tipemalxin. E tbinchaxin tneel tyec'bilxin tuj tnom te Caná, tuj departamento te Galilea, bix e cyocsla ke t-xnak'atzxin ka jaxin Scy'o'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tbajlenxitltzen jlu, e xi' Jesús tuj tnom te Capernaum, tuyax ttxuxin, cyuyax titz'enxin, bix cyuyax t-xnak'atzxin, bix e tenkexin tuj ja tnoma cab k'ij. ");
INSERT INTO mamNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Bix at tu'n tpon tumel tu'n tiy' iy'set jnink'ij te Pascua, jk'ij tej tul tuj cyc'u'j judío etz tco'pan Dios ke xjal te Israel tuj tk'ab Egipto. Ju' tzunj, e xi' Jesús tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tej tponxin, e xi'xin tuj jnin tja Dios. Tuj tapya ti' tja Dios ocx ten kej xjal nchi q'ueyen wacẍ bix carnel bix cucu', kej jil nchi ajben te cyoybil judío te Dios. Bix xsunkej k'uklecke ti' cymes kej xjal ncub cych'ixpu'n pwak te Roma tuya pwak te tja Dios, cuma nuk pwak te tja Dios ajben tuj tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ka'xsen el jlu tuj twitz Jesús, bix e xi' tbincha'nxin jun charyon te cyjaj, bix etz tlojo'nxin cykilca ke q'ueyel alimaj cyuyax ke cycarnel bix cywacẍ tuj tja Dios. Bix e cub ttz̈itexin cypwak ch'ixpul twitz pwak, bix e jaw tpac'tz'enxin cymes. ");
INSERT INTO mamNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Bix e xi' tkba'nxin cyej xjal nchi q'ueyen cucu': —¡Cyii'nx kej cucu' lu! Mi'n tz'oc cyk'o'na tja Nmana tisen jun q'ueybil—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tej cylonte t-xnak'atz Jesús ti e bint tu'nxin tuj tja Dios, ultzen tuj cyc'u'jxin ti e tkba tyol Dios. Tz̈i cyjulu: “E xi' tkba'n Tcwal Dios te Tman: ‘Cuma waja tu'n tajben tjay nuk tu'n tjaw cynimsa'n xjal tbiy, chin cweltzen cybyo'n xjal ti'j,’ tz̈i Tcwal Dios.” ");
INSERT INTO mamNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yaltzen kej nejenel cye judío, tej cylonte ti otk baj te Jesús, e xi' cykanenxin texin: —¿Jaa' ma tzaa' k'o'n tu'n tcawena tibaj tja Dios ju'wa? K'ontz jun yec'bil keya, tu'ntzen tel kni'ya ti'j at toclena—tz̈i ke judío. ");
INSERT INTO mamNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Bix aj ttzak'be'n Jesús cyexin: —Ka ma cub cyxitena ja tja Dios lu, cjaweltzen nbincha'na juntl maj tuj oxe k'ij—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ju' tzunj, e xi' cykba'n judío texin: —Ak'anan ke binchal jaa' cya'wnak jnabk'i tuya wukak e binne ja tja Dios lu. ¿Ti tten tu'n tjaw tbincha'ntey nuk oxe k'ij?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Min el cyniy'xin ti'j e yolen Jesús ti'j t-xumlal tisen tja Dios. Min e yolenxin ti'j nin tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pero yal kej t-xnak'atz Jesús, tej tjatz itz'j Jesús juntl maj tuj cyamecy mas yaj, e tzaj cyna'nxin ti otk tkbaxin ti'j tu'n tbinchaj tja Dios, bix el jax tyol Dios bix tyolxin tuj cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Entonces, e ten Jesús tuj Jerusalén te iy'sal nink'ij te Pascua. Bix tuj cywitz nim xjal, jaxin Jscy'o'n tu'n Dios, cuma e cyil jnim tipemalxin e xi' tyeec'anxin. ");
INSERT INTO mamNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ttzki'n Jesús min oc ke cyc'u'j xjal ti'jxin, cuma el tniy'xin ti'j ti iy' tuj cyc'u'j cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mintii' il ti'j tu'n tkbaj texin ti tten tnaabl jun xjal, cuma ttzki'nxin alcyej at tuj tanem jaca juun xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Attzen junxin xjal Nicodemo tbi. Cyxol fariseoxin, kej xjal cyiw tuj cyley judío. Bix tocxxin te nejenel te cycloja judío nchi cawen tuj cyley judío. ");
INSERT INTO mamNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","At jun koniyan e pon Nicodemo tuya Jesús te yolel. E xi' tkba'nxin te Jesús: —Taat Xnak'tzal, ntzki'na ka sma'na tu'n Dios te xnak'tzal keya, cuma nuket min tzaj tonen Dios jay, mlayettzenle bint cykilcaj nbint tu'na—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Bix e xi' tkba'n Jesús texin: —Min tz'el tni'ya ti'j tcawbil Dios. Cxe'l nkba'na tey, nuket min ma tzaj tk'o'n Dios tu'n titz'j jun xjal tuya jun ac'aj chunk'lal, mlaytzen tz'ocx ja xjala tuj tcawbil Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Bix e xi' tkanen Nicodemo te Jesús: —¿Ti tten tu'n titz'j jun xjal tijtl juntl maj? ¿Jac'apatzen tz'ocx juntl maj tuj tc'u'j ttxu, tu'ntzen titz'jtl?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aj ttzak'be'n Jesús: —Jax wu'na. Mlay tz'ocx jun xjal tuj tcawbil Dios nuk o'cxj titz'jlen tu'n ttxu, sino c'oquex oj titz'j tuya jun ac'aj tchunk'lal k'o'n tu'n Espíritu Santo. ");
INSERT INTO mamNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jn-itz'j ti' jun xjal, jax nuk xjalx. Pero jn-itz'j tu'n Espíritu Santo, jun ac'aj wikan tchunk'lal. ");
INSERT INTO mamNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ju' tzunj, mi'n jaw klee'y oj nxi' nkba'na tey il ti'j tu'n titz'ja tuya jun ac'aj tchunk'lala k'o'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mi'n tz'el t-xoo'na ja yol lu nuk tu'nj min tz'el tni'ya ti'j. Min chic'aj cyk'i'k, pero nxi' nuk jaak'ch, bix ntbi'na tk'ajk'ajel, amale mint tz'el tni'ya ti'j jaa' n-itz'ja bix jaa' npona baj. Jax ju'x jaca juun xjal k'o'n jun tchunk'lal ac'aj tu'n Espíritu Santo. Amale mint tz'el tni'ya ti'j, pero chi itz'jel juntl maj—tz̈i Jesús te Nicodemo. ");
INSERT INTO mamNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Bix e xi' tkba'n Nicodemo te Jesús: —¿Ti tten tu'n titz'j jun xjal tuya jun ac'aj tchunk'lal?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Bix aj ttzak'be'n Jesús texin: —Jay jun jawnex xnak'tzal cyxol Israel. ¿Titzen tten min tz'el tni'ya ti'j? ");
INSERT INTO mamNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cxe'l nkba'na tey, cykilcaj tzin nkba'na tey, jaxxixte, pero ejee'y judío cycy'iy. ");
INSERT INTO mamNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ka mlay tz'el cyni'ya ti'j nyola ti'j tu'n cyitz'j xjal juntl maj twitz tx'otx' tuya jun ac'aj cychunk'lal, ¿titzen tten tu'n tel cyni'ya ti'j ka ma txi' nkba'na cyey ti'j ti cbinel tu'n Dios tuj cya'j? ");
INSERT INTO mamNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Min-al jun xjal ba'n t-xi' tk'umen cyey ti nbaj tuj cya'j, cuma min-al o japan tuj cya'j. Nuk o'cx jxjal o cu'tz tuj cya'j ba'n t-xi' tk'umen tii'n tuj cya'j, inayen tzuna, Jsma'n tu'n Dios tu'n ntena cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bix ma chin ula tu'n njaw k'o'na cywitz xjal. Tisenj e jaw tk'o'n Moisés techel lbaj te xcbil tuj jlugar mintii' najbil tuj, tu'ntzen cyclet xjal, jax ju'x weya. Ilxsen ti'j tu'n njaw k'o'na, ");
INSERT INTO mamNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tu'ntzen cyiik'ente cykilca xjal cychunk'lal te junx maj n-oc ke cyc'u'j wi'ja, inayena, jxjal Sma'n tu'n Dios—tz̈i Jesús te Nicodemo. ");
INSERT INTO mamNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nimxsen oc cyak' cykil xjal te Dios, bix ju' tzunj e tzaj tk'o'nxin jaj junx Tcwalxin cye xjal. Ju' tzunj, alcyej xjal ma tz'ocslan ti'j Tcwalxin, ck'ojeltzen tchunk'lal te junx maj, bix mi'n txi' tuj cyamecy te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Min e tzaj tsma'n Dios Tcwal twitz tx'otx' te k'ol castiwa cye xjal, sino e tzaj tsma'nxin tu'n cyclet xjal tuj castiwa tu'n Tcwalxin. ");
INSERT INTO mamNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Alcyej xjal ma tz'ocslan ti'j Tcwalxin, mlay cub castiwa tibaj. Pero kej xjal min chi ocslan ti'j, ck'ojeltzen cycastiwa, cuma n-el cyxoo'n jjunx Tcwal Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ck'ojeltzen cycastiwa tu'nj cycy'i jxjal ul k'ol spi'yen cye. Min e jaw tzalajke ti'j spi'yen sma'n tu'n Dios, cuma mas e cyajbe jcyil twitzj jaxxix yol ul tii'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kej xjal nchi binchan ka' n-el cyiiq'uen jspi'yen. Cycy'i tu'n cyul nka ti' spi'yen, cuma cycy'i tu'n tchic'ajax ti'j jka' nbint cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero kej xjal nchi oc lpe ti'j jiquen, nchi jyon jjaxxix yol, cuma cyaj tu'n tel ba'n cybinchben tuj twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tbajlenxitltzen jlu tuj Jerusalén, bix iy' Jesús tuj tnom cyuyax t-xnak'atzxin, bix e bet-xin cyuyaxin cab k'ij tuj departamento te Judea. Nchi cu'x xjal tuj a' cyu'n t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jax ju'x e ten Juan Bautista tuj Judea nchi bautizarj xjal tuj a' tu'nxin. E tenxin tuj tnom te Enón, nka ta' tnom te Salim, cuma at nim a' tuj Enón. Bix nchi ponxetzen xjal tuyaxin tu'n cycu'x tuj a' tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tzinx chi cu'x xjal tuj a' tu'nxin, cuma mitkna'x tocx k'o'nxin tuj tzee'. ");
INSERT INTO mamNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tu'nj e bautizarj ke xjal tuj a' cyu'n t-xnak'atz Jesús, ju' tzunj e jaw jun k'oj cyxol ke judío bix kej t-xnak'atz Juan. Yaa'n ba'n tuj cywitz t-xnak'atz Juan tu'n cycu'x xjal tuj a' cyu'n t-xnak'atz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ju' tzunj e pon lk'e ke t-xnak'atz Juan ti' Juan, bix e xi' cykba'n texin: —Taat Xnak'tzal, jxjal e ten tuyey jlajxe nima' te Jordán bix e xi' tk'o'na jun ba'n te te tej tjaw tnimsa'na tbi, nchi cu'x xjal tuj a' tu'n, bix cykilca xjal ncyaj cyk'o'n jay tu'n cyaj tuyaxin. Yaa'n tumel jlu—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Bix aj ttzak'be'n Juan: —Mi'n chi labta ti'j ch'in woclena. Mlay tu'n tten mas woclena twitzj o k'oj tu'n Dios weya tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yaa'n jawnex kena tisenj xjal nchi yolena ti'j. Ejee'xa tstiwa e xi' nk'umena: “Yaa'n inayena Jscy'o'n tu'n Dios. Nuk jun sanjel kena sma'n tu'n Dios tu'n binne cyten xjal oj tulxin,” ntz̈iya. ");
INSERT INTO mamNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tisen jun mejoblenel. Yaa'n jxjal t-amiwa chmilbaj cmajebel tuya xuuj, sino ja te chmilbaj. Jtaak'en jun t-amiwa chmilbaj, nuk ja tej tu'n tninc'un tunwen, bix c'ayoltzen ti toc tu'n chmilbaj, ka ma tz'el ba'n taak'en tuj twitz chmilbaj. Katzen ma tkba chmilbaj ma tz'el taak'en ba'n, cjaweltzen tzalaj jt-amiwa chmilbaj. Ju' tzunj weya nuk tisen jun tuya chmilbaj kena. Ju' tzunj, nimxsen nchin tzalaja tu'n nim xjal nchi pon tuya Jesús, cuma ba'n ma tz'el waak'ena, tisen taak'en jun xjal tuj mejoblenel. ");
INSERT INTO mamNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tumel tu'n cypon xjal tuya Jesús, cuma il ti'j tu'n tjaw nimset tipemal Jesús, bix tu'n tcub jweya wipemal cubne—tz̈i Juan. ");
INSERT INTO mamNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jxjal ma tzaj tuj cya'j, mas jawnex twitz cykilca xjal. Kej xjal, nchi itz'j twitz tx'otx', bix te twitz tx'otx' cynaabl. Ba'n chi tx'olban nuk ti'j ti tten jnbaj twitz tx'otx'. Pero jxjal ma tzaj tuj cya'j, ");
INSERT INTO mamNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ttzki'n ti tten tuj cya'j, bix ntx'olban j-o til bix o tbi. Pero min-al xjal taj tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero ja tzunkej xjal ma cyocsla tyolxin, tzin cyyeec'an jax ma cyocsla jtzin tkba'n Dios, ");
INSERT INTO mamNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","cuma jxjal e tzaj tsma'n Dios, tex Dios tyol ntk'umen. At tipemalxin tu'n tyolenxin j-e tkba Dios, cuma o txi' tk'o'n Dios Espíritu Santo texin te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","N-oc tak' Tcwal Dios te Tman, bix o txi' tk'o'n Dios cykilca at tuj tk'abxin tu'n tcawenxin tibaj. ");
INSERT INTO mamNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Alcyej xjal ma tz'ocslan ti'j Tcwal Dios, attzen tchunk'lal te junx maj. Pero kej xjal cycy'i tz'oc cybi'n Tcwal Dios, mlay k'oj cychunk'lal te junx maj. Nuk o'cx chi cyjel ten tuj castiwa tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","E pontzen tpocbal cyuya fariseo nche'x lpe xjal mas ti'j t-xnak'tzbil Jesús twitzj t-xnak'tzbil Juan Bautista, bix mas e cu'x ke xjal tuj a tu'n Jesús twitzj tu'n Juan, ");
INSERT INTO mamNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","amale yaa'nt tu'n Jesús e cu'x ke xjal tuj a'. Nuk cyu'n t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tejtzen tbinte Jesús otk cybi fariseo jlu, etzxin tuj Judea, bix e xi'xin juntl maj tuj Galilea. ");
INSERT INTO mamNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tu'ntzen tponxin Galilea, il ti'j tu'n tiy'xin tuj departamento te Samaria. ");
INSERT INTO mamNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bix e ponxin tuj jun tnom te Samaria, Sicar tbi. Tcub Sicar nka ta' jtx'otx' otk txi' tk'o'n Jacob te José, tcwalxin, jatxe ootxa. ");
INSERT INTO mamNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ti'jxetzen tnom ta' jpozo otk cyaj tbincha'n Jacob. Bix tu'nj otk sict Jesús tuj be, e cub kexin ttzii' pozo. Otk pon chil k'ij. ");
INSERT INTO mamNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Bix ultzen junxuj xuuj aj Samaria ti' pozo te k'iljatz a'. Bix e xi' tkba'n Jesús texuj: —K'ontz ch'in a' weya—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Otk cyajxin tjunalxin, cuma otk che'x t-xnak'atzxin tuj Sicar te lok'ol waabj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Bixsen e jaw klee' tzunj xuuj aj Samaria ti'j tkanbil Jesús, bix e xi' tkanenxuj texin: —¿Titzen tten ntzaj tkanena tu'n wajbena tey tuya jun tc'ay? Jay jun xjal judío, bix jun xuuj aj Samaria kena—tz̈i tzunxuj, cuma el tniy'xuj ti'j kej xjal te Samaria mintii' ajbenke tuj cywitz judío. ");
INSERT INTO mamNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Bix aj ttzak'be'n Jesús texuj: —Ma txi' nkanena ch'in nc'aya tey, pero nuket s-el tni'ya ti'j taj Dios tzaj tk'o'n xtalbil tey, bix nuket s-el tni'ya wi'ja alcye kena, matle tzaj tkanena a' weya, bix matle txi' nk'o'na j-a' tzin tk'o'n tchunk'lala—tz̈i Jesús texuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","E xi' tkba'nxuj texin: —Taat, mintii' k'iljawtzte a' tu'na, bix nakch tcu'xa te a' tuj jul. ¿Ti tten tu'n ttzaj tk'o'na a' weya ctk'a' nchunk'lala? ¿Japatzen tey mas jawnex twitzj kiy'jila Jacob? ");
INSERT INTO mamNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","J-a' tuj ja pozo lu ajben te Jacob cyuya tcwalxin, bix nimte te cyc'a' cywacẍ. Bix o cyaj tk'o'nxin ja pozowe te keya. ¿Japa tey mas jawnex twitzxin, tu'n ttzaj tk'o'na jun a' mas ba'n weya?—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Bix aj ttzak'be'n Jesús texuj: —Ka nuk jax j-a' lu nchi c'an xjal ti'j, n-ocx tak' a' cye. ");
INSERT INTO mamNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero alcyej xjal cxe'l c'ante j-a' cxe'l nk'o'na te, mlay tzaj tak' a' te juntl maj. J-a' cxe'l nk'o'na te, c'oqueltzen te jun twi' a' tuj tanem mintii' tbajlel twi'. I'tz, bix ja tzunja tu'n tk'onte tchunk'lal xjal te junx maj—tz̈i Jesús te xuuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Bix e xi' tkba'nxuj te Jesús: —Taat, k'ontz j-a' lu weya, tu'ntzen mintii'tl tak' a' wi'ja, bix tu'n mintii'tl il ti'j tu'n wula maa tzalu te k'ilte a'—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","E xi' tkba'nxin texuj: —Cutxey tjay, kbanx te tchmila tu'n ttzaj tzalu, bix ctzaal meltz'aja tuyaxin—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Mintii' nchmila—tz̈ixuj. Bix e xi' tkba'n Jesús texuj: —Jax tu'na mintii' tchmila, ");
INSERT INTO mamNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","cuma o tz'el tpa'n tiiba ti' jwe' tchmila, bix jxinak at tuyey ja'lewe yaa'n tchmila. Ju' tzunj, ba'n ma tkbay mintii' tchmila—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","E xi' tkba'nxuj texin: —Taat, ¿ti tten at tumel tuyey wi'ja? Tuj nwitza jay jun tyolel Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","At jun nkanbila tey. Ke kiy'jila e na'nke Dios tzalu twi' ja witz lu. Pero ejee'y judío tzin cykba'na il ti'j tu'n tjaw knimsa'na ejoo'ya aj Samaria tbi Dios nuk tuj Jerusalén. ¿Ti toc tu'na ti'j ti taj Dios?—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","E xi' tkba'n Jesús texuj: —Naa, k'o'nc tc'u'ja ti'j cxe'l nkba'na tey. Tzul jun k'ij tu'n mi'n jaw cynimsa'ntl xjal tbi Kman Dios mi nuk twi'j witz jatzewe bix mi nuk tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ejee'y aj Samaria njaw cynimsa'na jmin tz'el cyni'ya ti'j, bix ju' tzunj mlay tz'itz'j colbil cye xjal cyxola. Pero ejoo'ya judío n-el kni'ya ti'j jnjaw knimsa'na, cuma te keya o tz'itz'ja jcolbil cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero yaa'n il ti'j jaa' tu'n tjaw cynimsa'na Dios. Tzul jun k'ij, bix ya ma tzyet tu'n tul, kej xjal cyaj chi na'n Kman Dios tuya jun jaxxix cyanem, cbinel cyu'n yaa'n nuk tuj jun lugar, sino tuj cyanem tuya cykil cyc'u'j. Taj Kman Dios tu'n tjaw cynimsa'n tbixin ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaa'n jun xumlalbaj Dios. Ju' tzunj, ka cyaj xjal chi na'n Dios, il ti'j tu'n cyna'n jaxin yaa'n nuk tuya cyxumlal, sino tuya cyanem, bix tuya jun cyanem jaxxix—tz̈i Jesús te xuuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Bix e xi' tkba'nxuj texin: —Ntzki'na tzul Cristo, jaj xjal Scy'o'n tu'n Dios. Oj tulxin, ctzaal ttx'olba'nxin cykilca keya—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","E xi' tkba'n Jesús texuj: —Inayena, jxjal nyolen tuyey, inayenja Scy'o'n tu'n Dios kena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Te tzunj hora, e pon meltz'aj ke t-xnak'atz Jesús. Tej t-xi' cycye'yenxin nyolen Jesús tuya jun xuuj, e jaw klee'kexin. Pero min-al e xi' kanente texin ti tajxin bix tu'n tiken e yolenxin tuyaj xuuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yal te xuuj, e xi'xuj tuj tnom. Tu'n nim e jaw klee'xuj, el tuj tc'u'jxuj tu'n t-xi' tii'nxuj twicy'ilxuj. Bix e xi' tkba'nxuj cye xinak tuj tnom: ");
INSERT INTO mamNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—¡Ko'tzen! Ti'jxe tnom at jun xjal ma tzaj tkba'n weya cykilcaj o nbinchaya witz'jlena. ¿Ti toc cyu'na? ¿Yaa'mpale xjalja lu Jscy'o'n tu'n Dios?—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ju' tzunj etz nim xjal tuj tnom tu'ntzen cypon tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Maatktzen nchi ul aj Sicar, bix e yolen ke t-xnak'atz Jesús tuyaxin. Bix e xi' cykba'nxin texin: —Waa'na, Taat. ");
INSERT INTO mamNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero e xi' tkba'nxin cyexin: —Ya ma txi' nwaa'na jun nwaya min tz'el cyni'ya ti'j—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ju' tzunj ak' ke t-xnak'atzxin kanlte cyxolx: —¿Atpale jun xjal ma tzul k'olte twa?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","E xi' tkba'n Jesús cyexin: —Min. Yaa'n jwaabj tu'n t-xi' nwaa'na nchin yolena ti'j. Weya nwa, jaj ak'untl k'o'n weya tu'n Dios e tzaj tsma'n inayena, bix tu'n tbint jtajbilxin wu'na. ");
INSERT INTO mamNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","At juntl cxe'l nkba'na cyey. Cyxola at jun yol tzin tkba'n: “At-x cyajatl xjaw tu'n tchmet twitz awal.” Pero cxe'l nkba'na cyey, c'oquel cyc'u'ja ti'j twitz awal lu ata. Ma knax awal, bix matzen pon tumel tu'n tchmet. ");
INSERT INTO mamNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yaa'n yaj, sino ja'lewe. Yaltzen ke cyey n-oc cyipena ti'j tu'n tjaw cychmo'na ja awal lu, cjaweltzen cychmo'na jun awal yaa'n nuk te jun rato, sino jun awal mi'n pon baj twi'. Bix tujx k'ij ja'lewe chi tzalajela ejee'y chmol awal junx wuyena, inayenja awaal. ");
INSERT INTO mamNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kxol ejoo' judío at jun yol tzin tkba'n: “Ncub tawa'n jun xjal, pero junxitl cjawel chmonte.” Q'uelel jax ja yol lu ja'lewe, ");
INSERT INTO mamNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","cuma ma txi' nsma'na cyey tu'n tjaw cychmo'na jun awal min ma chi ak'anana ti'j. Junxitl xjal xcub awante, pero ejee'y te chmolte—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bix ju' e baj. Nim xjal aj Samaria te tnom te Sicar ocslan ti' Jesús. Ocslanke tu'n tyol jxuuj oc kbante cye: “Ma tzaj tk'umenxin weya cykilcaj o nbinchaya witz'jlena.” ");
INSERT INTO mamNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tejtzen cypon xjal te Sicar cyuya Jesús, e cubsanke cywitzxin texin tu'n tcyaj tenxin cyuyaxin. Bix e tcuyaxin, bix e tenxin tuj Sicar ca'ba k'ij. ");
INSERT INTO mamNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bix nimc'atl xjal ocslan ti'jxin tu'nx tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bix e xi' cykba'nxin te xuuj: —Yaa'n nuk tu'nj tey tyol nko ocslana, cuma ejoo'xa ma ko ebinte tyol jxjal e yolen tuyey, bix ktzki'na jaxin jjaxxix Clol cye cykil xjal—tz̈ikexin texuj. ");
INSERT INTO mamNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tbajlenxitltzen ca'ba k'ij, etztzen Jesús tuj Samaria bix e xi'xin tuj Galilea. ");
INSERT INTO mamNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tuj Judea otk tz'el cyiiq'uen fariseo jaxin. Ju' tzunj, e xi'xin tuj Galilea, cuma e tkbaxin jun kbalte tyol Dios te tex tnom yaa'n nimxix n-oc cybi'n xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tejtzen tponxin tuj Galilea, e jaw tzalaj ke xjal ti'jxin, cuma otk cyil cykilcaj otk bint tu'nxin tuj nink'ij tej cyten tuj Jerusalén, cuma ejee'x otk che'x tuj nink'ij. ");
INSERT INTO mamNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bixsen e xi'xin juntl maj tuj tnom te Caná tuj Galilea, jtnom jaa' otk cub tch'ixpu'nxin a' te vino. Tujtzen tnom te Capernaum, otktzen yaabt tcwal junxin cawel. ");
INSERT INTO mamNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tej tbinte tzunj xjal ka otk tz'etz Jesús tuj Judea bix otk tzul tuj Galilea, e xi'xin tuya Jesús tuj Caná, bix e cubsanxin twitzxin te tu'n t-xi' tuj ttanemxin tu'n tco'pante Jesús tcwalxin tuj tyabel, cuma ch'itk tcyim tcwalxin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ju' tzunj, e xi' tkba'n Jesús texin: —Jey', ¿chi ocslalpa key judío wi'ja ma nuk o'cx ka ma txi' nyeec'ana nim wipemala cyey?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","E xi' tkba'n cawel te Jesús: —Taat, najsama, pero waja txi' naja, cuma ya ch'ix tcyim ncwala—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","E xi' tkba'n Jesús texin: —Ba'n taja. Ma k'anj tcwala—tz̈i. Oc ke tc'u'j cawel ti' tyol Jesús, bix e tzyet tbexin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bix e tzaj c'ulbajxin cyu'n t-ak'analxin tuj be, bix e xi' cykba'nxin texin: —Taat, ma k'anj tcwala. ");
INSERT INTO mamNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Bix e xi' tkanenxin cyexin: —¿Ni' hora tk'anj ncwala?—tz̈ixin. —E k'anj ewe jun hora tibaj chil k'ij—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ultzen tuj tc'u'jxin jatzen horaj tej tkbante Jesús texin: “Ma k'anj tcwala.” Ju' tzunj, e tocslaxin Jesús ka Scy'o'nxin tu'n Dios, cyuyax ke te tjaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ja tzunja e bint tu'nxin, te tcab maj e xi' tyeec'an Jesús tipemal tuj Galilea tej tetz tuj Judea. ");
INSERT INTO mamNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mas yaj, attzen jun nink'ij cye judío. Ju' tzunj, e xi' Jesús tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nkatzen ttzii' jtapya tocsen ti' tnom te Jerusalén jaa' nchi pona xjal q'ueylecxte carnel, tocxsen jun tx'ajbil cye xjal tuj tapya. Betesda tbi tx'ajbil tuj cyyol judío. Bix ttzii'tzen tx'ajbil tcub jwe' pach nuk te pa'tbil, bix tu'n cyxmuun xjal cyuj tu'n k'ij. ");
INSERT INTO mamNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Cyujtzen pach cotz'lecx nim xjal yaab cyuj, ke mos̈, ke cox, bix kej xjal mintii' cyipen. Nchi ayontzen xjal tu'n tyucch a' tuj tx'ajbil. ");
INSERT INTO mamNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tuj cywitz xjal, at maj e cu'tz jun tsanjel Dios tuj cya'j bix e yucch a' tuj tx'ajbil tu'n, tu'n tk'onte tipemal a'. Jtneel xjal e cu'x tuj a' tej tyucch a', e k'anen ti'j alcyej yabel ni'k'an. ");
INSERT INTO mamNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tuj tzunj lugar e ten junxin xjal otk tz'oc jun tyabel ti'jxin winakoxlaaj jnabk'i. ");
INSERT INTO mamNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tej tlonte Jesús ja yaab, el tniy'xin ti'j otk tz'el nim k'ij tyabtlenxin. Bix e xi' tkba'nxin te yaab: —¿Tajpey tu'n tco'pja tuj tyabela?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Taat, waja, pero min-al jun wuyena ntzaj onente weya, tu'n ncu'x k'o'na nejl tuj a' oj tjaw yucch. N-oc wipena ti'j tu'n npona tneel tuj a', pero jaca maj ncu'x nejl juntl xjal nwitza—tz̈i yaab. ");
INSERT INTO mamNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","E xi' tkba'n Jesús te: —Wey'tztzen, k'inwe tpopa, bix beta—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tejtzen t-xi' tkba'n Jesús ju'wa, tzin nk'anjtl yaab, tzin jaw tii'ntlxin tpopxin, bix nxi' betlxin. Pero e k'anj yaab tuj k'ij te ajlabl, jk'ij xjan tu'n mi'n ak'anan ke xjal judío. ");
INSERT INTO mamNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ju' tzunj, e xi' cykba'n kej judío cyiw ete' tuj cyley tej yaab otk k'anj: —Jk'ij te ajlabl ja'lewe. Yaa'n k'o'n tu'n ley tu'n t-xi' tii'na tpopa—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero aj ttzak'be'n yaab cyexin: —Nuk s-oc nbi'na tyol jxjal xk'anen weya ja'lewe. Jaj xjala s-aj kbante weya tu'n tjaw nbalk'i'na npopa bix tu'n nbeta—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ju' tzunj, e xi' cykanenxin texin: —¿Alcyej xjal s-aj kbante tey tu'n tjaw tbalk'i'na tpopa bix tu'n tbeta?—tz̈ikexin ");
INSERT INTO mamNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero jxjal otk k'anj, mintii' tumel tuya alcye otk k'anen te, cuma tej njaw tbalk'i'nxin tpopxin, otk tz'el lk'e Jesús ti'j tx'ajbil cyxol nim xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ch'intzen tbajlen, e xi' Jesús tuj tja Dios tu'n tcnet jxin xjal otk k'anj tu'nxin, bix e xi' tkba'nxin te: —Jey', ma cyaj t-xumlala ba'n. Pero at-x juntl cxe'l nkba'na tey. Mi'ntzen tbinchatla mas il, tu'n mi'n txi'y tuj jun il mas ka' twitzj jnejl—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tej tel tniy'xin ti'j ka ja Jesús otk k'anen texin, e xi'xin cyuya nejenel cye judío, bix e xi' tk'umenxin cye ka tu'n Jesús otk k'anjxin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yal kej judío, cuma e k'ane Jesús cye xjal tuj k'ij te ajlabl, ju' tzunj e k'ojl ke judío ti'jxin, bix e cyajbe tu'n tcub cybyo'n jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tejtzen tbinte Jesús min el ba'n j-e bint tu'nxin tuj cywitz nejenel cye judío, e xi' tkba'nxin cyexin: —Bajx cyja' tk'o'n Nmana Dios tu'n mi'n tc'ojla twitz tx'otx' cykil k'ij. Bix jax ju'x weya, ilxsen ti'j tu'n wak'anana tuya Nmana—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tej cybinte judío tyol Jesús, masxsen e cyajbexin tu'n tcub cybyo'nxin, cuma yaa'n nuk o'cx el t-xoo'nxin k'ij te ajlabl tuj cywitzxin, sino jax ju'x e tkbaxin ka Diosxin, cuma e tkbaxin ka Dios Tmanxin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","E xi' tkba'nxin cyexin: —Cyk'o'ncxix cyc'u'ja ti'j cxe'l nkba'na cyey. Alcyej nbint wu'na, yaa'n nuk waja tu'n tbint. N-oc ncye'yena, inayena, Tcwal Dios, ti'j ti nbint tu'n Nmana, tu'ntzen junx ta' waak'ena tuya taak'en Nmana. Alcyej nbint tu'n Nmana, n-oc wipena ti'j tu'n tbint wu'na tisenx nbint tu'n Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","N-oc wak'a te Nmana. Ju' tzunj, ntzaj tyeec'an weya cykilcaj tzin tbincha'n. Ma chin k'anen jun xjal mintii' tipen t-xumlal, pero ctzaal tyeec'antl Nmana ak'untl mas jawnex twitzj lu tu'n tbint wu'na, tu'ntzen cyjaw klee'y ti'j. ");
INSERT INTO mamNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tisen tzunj, cjawel itz'j ke cyimne tuj cyamecy wu'na. Tisenx njatz itz'j cyimne tu'n Nmana tuj cyamecy bix nxi' tk'o'n cychunk'lal, jax ju'x weya, inayena Tcwal, cxe'l nk'o'na cychunk'lal xjal. Bix inayena kbalte alcyej xjal ck'ojel cychunk'lal, ");
INSERT INTO mamNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","cuma yaa'n Nmana kbalte alcyej xjal ck'ojel cycastiwa, sino o k'oj tu'n Nmana weya tu'n nkbante alcyej xjal ck'ojel cychunk'lal bix alcyej xjal ck'ojel cycastiwa, ");
INSERT INTO mamNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tu'ntzen cyniman cykil xjal inayena tisenxsen nchi niman Kman Dios. Alcyej xjal min tz'oc tbi'n inayena, jax min tz'oc tbi'n Nmana, cuma sma'n kena tu'n Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Jaxxix cxe'l nkba'na cyey, kej xjal c'oquel cybi'n nyola bix chi ocslal ti' Dios, j-e tzaj tsma'n inayena, attzen cychunk'lal te junx maj, bix mlay che'x tuj castiwa, sino ma chi clet tuj cyamecy te junx maj, tu'ntzen cypon tuj cychunk'lal tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cybi'ncxix nyola. Tzul jun k'ij, bix ya ma tzyet tu'n tul, kej xjal at tuj be te cyamecy te junx maj, c'oquel cybi'n nyola, bix kej cxe'l cybi'n, chi oqueltzen tuj cychunk'lal tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ba'n txi' nk'o'na cychunk'lal, cuma ma tzaj tk'o'n Nmana wipemala tu'n t-xi' nk'o'na. Tisenx ntzaj chunk'lal ti'j Nmana Dios, jax at chunk'lal wuyena, inayena Tcwal. ");
INSERT INTO mamNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Bix cuma in oca te xjal, ju' tzunj ma tzaj tk'o'n Nmana woclena te kbalte alcye kej xjal chi xe'l tuj castiwa bix alcye kej xjal chi oquel tuj cychunk'lal tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mi'n baj cyc'u'ja ti'j nxi' nkba'na cyey. Tzul jun k'ij cykilca xjal o chi cyim c'oquel cybi'n oj ntxco'na cyi'j, ");
INSERT INTO mamNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bix il ti'j chi jawetz tuj cyamecy. Kej xjal o chi binchan ba'n, chi jawetz tu'n tk'oj cychunk'lal, bix kej xjal o chi binchan ka', chi jawetz tu'n tk'oj cycastiwa. ");
INSERT INTO mamNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Pero yaa'n wu'nxwe cxe'l nkba'na alcye kej xjal ck'ojel cycastiwa. N-oc nc'u'ja ti'j ti taj Nmana, tu'ntzen ba'n txi' nkba'na ti pjel cye xjal. Ju' tzunj, tuj tumelxix jnxi' nkba'na, cuma yaa'n weya wajbil. Jaj tajbil Nmana e tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nuket nuk inayena nxi' nkba'na ka junx waak'ena tuya taak'en Dios, tujtzen kley mintii'tle il ti'j tu'n cyocslana nyola. ");
INSERT INTO mamNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero at juntl xjal tstiwa wi'ja. Jatzen Nmana. Bix ntzki'na ilxsen ti'j tu'n cyocslana ti'j tyol, cuma jaxxix tyol. ");
INSERT INTO mamNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","At juntl. Tuj cywitza najben Juan Bautista te jun tstiwa ka sma'n kena tu'n Dios. O txi' cysma'na cysanjela tuyaxin, bix o cyiik'a tyolxin wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Te weya, mintii' il ti'j tu'n tajben tyol jun xjal tu'n tcywix yol wi'ja ka sma'n kena tu'n Dios. Pero ma chin yolena ti' Juan tu'n tajben tyolxin cyey, tu'ntzen cycleta. ");
INSERT INTO mamNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jaxte ajben Juan tisen jun jul tzaj, te cyeybil tuj be. Bix jun rato ba'n e'la tuj cywitza tu'n cybinteya j-e tk'umexin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","J-e tk'ume Juan nim e tyeec'a ka junx weya waak'en tuya taak'en Dios, pero jnbint wu'na mas tzin tyeec'an twitzj tyol Juan. J-ak'untl ma tzaj tk'o'n Nmana weya tu'n tbint wu'na, tisenj tej nk'aneya jxjal mintii' tipen, tzin tkba'n ma tzaj tsma'n Nmana inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bix jax Nmana o tzaj tyeec'an sma'n kena tu'nxin. Pero min o txi' cybi'na tk'ajk'ajel twi'xin bix min o cyajbey tu'n tel cyni'ya ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Min ma tz'ocx tyolxin tuj cyanema tu'n n-el cyiiq'uena tyol jxjal ma tzaj tsma'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Njaw cys̈i'na ootxa tyol Dios, cuma tuj cywitza ck'ojel cychunk'lala te junx maj nuk tu'nj nchi cye'yena tuj. Pero jtaak'en tyol Dios yaa'n tu'n tk'onte cychunk'lala. Nuk jaj tu'n ncneta cyu'na. ");
INSERT INTO mamNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero cycy'iy tu'n cyocslana wi'ja, tu'ntzen tten cychunk'lala te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ma txi' nkba'na yaa'n tu'n waja tu'n wela ba'n tuj cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma txi' nkba'na cuma ntzki'na tiken cycy'iy nyola. Jaj cuma min n-oc tak' Dios cyey. ");
INSERT INTO mamNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ma chin tzaja cyxola te t-xel Nmana, pero cycy'iy tu'n cyocslana wi'ja. Pero oj cyul juntl wik nuk cyu'nx cyiib, chi ocslala cyi'j tuya cykil cyc'u'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Cycy'iy tu'n cyocslana wi'ja, cuma nuk cyaja ejee'y nejenel cye judío tu'n tjaw nimset cybiy cyu'n xjal. Mintii' cyajbila tu'n cyela ba'n twitzj jun Dios at. ");
INSERT INTO mamNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Pero mintii' il ti'j tu'n t-xi' nkba'na te Nmana at cyila, cuma jax tley Moisés tzin kbante min tz'oc cybi'na, amale tujet cywitza chi cletela tu'nj cynimbila ti' tley Moisés. ");
INSERT INTO mamNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nuket ocslankey tyol Moisés, jax otle chi ocslana wi'ja, cuma j-e cyaj ttz'i'ben Moisés, nbya'ntzen wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero cuma ma tz'el cyxoo'na j-e cyaj ttz'i'ben Moisés, ¿titzen tten tu'n cyocslantey jnxi' nkba'na cyey?—tz̈i Jesús cye judío. ");
INSERT INTO mamNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yajxitltzen, bix iy'x Jesús tuj tnijabel a' te Galilea, bix juntl tbi Tiberias. ");
INSERT INTO mamNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cyuj tzunkej k'ij, tbet-xin nimxsen cyajlal xjal oc lpe ti'jxin, tu'ntzen toc cycye'yen jjawnex tipemalxin tej tco'pantexin kej yaab tuj cyyabel. ");
INSERT INTO mamNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Bix oc lpe ke xjal cnol texin tu'n cyken ttziyela a'. Tejtzen tiy'paxin jlajxe a', e tajbe tzunxin tu'n ttenxin tjunalxin. Ju' tzunj e jaxxin twi' jun witz cyuya t-xnak'atzxin, bix e cub kexin cyuya. ");
INSERT INTO mamNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ch'itktzen tpon jjawnex cynink'ij judío te Pascua. ");
INSERT INTO mamNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tejtzen tten Jesús tc'u'j witz, oc tcye'yenxin, bix e tilxin nimxsen xjal otk k'on vwelt ti' a' tu'n tcnet-xin cyu'n. Ju' tzunj, e xi' tkba'nxin te Felipe: —¿Ti tten tu'n tcnet waabj, tu'ntzen cywaa'n kej xjal nchi ul wi'ja?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","E xi' tkba'nxin ju'wa nuk tu'n tchic'ajax ka at tocslabl Felipe ti'jxin, cuma ttzki'ntlxin alcye tu'n tbint tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aj ttzak'be'n Felipe texin: —Taat, mlay tu'n tlek'et waabj ku'n. Mitle tu'n xcnet ca'ba syent pwak te denario ku'n, mlayx canan tu'n t-xi' klok'o'n waabj te cykilca xjal, tu'ntzen t-xi' twa jaca juun xjal bix nuk ch'inee' at—tz̈i Felipe. ");
INSERT INTO mamNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","At juntlxin t-xnak'atz Jesús, Andrés tbi, titz'en Simón Pedro, bix e xi' tkba'nxin te Jesús: ");
INSERT INTO mamNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Taat, lu jk'a ma tzul tii'nk'a jwe' pan te cebada tuya ca'ba quis̈. Pero, ¿ti tten tu'n tcanan jlu cye nimc'a xjal?—tz̈i Andrés. ");
INSERT INTO mamNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tejtzen cypon baj xjal ti'jxin, e xi' tkba'n Jesús cye t-xnak'atz: —Cykbanx cye xjal tu'n cycub ke—tz̈ixin. Tc'u'jtzen witz at jun chk'ajlaj toc, bix e cub ke ke xjal tuj tz̈'im. Atle jwe' mil xinak otk pon. ");
INSERT INTO mamNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bix e tzaj ttzyu'n Jesús ke pan, bix e xi' tk'o'nxin chjonte te Dios ti'j, bix e xi' tk'o'nxin pan cye t-xnak'atzxin, tu'ntzen t-xi' cypa'nxin cyxol xjal otk chi cub ke. Bix ju'x e xi' tk'o'nxin ke quis̈. Jax nimc'a otk tz'e'la te cykilca xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tejtzen cybaj noj ke xjal, e xi' tkba'nxin cye t-xnak'atzxin: —Cychmonwe ttx'akan cywa xjal min xbaj cyu'n, tu'ntzen mintii' q'uelex xe't—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bix e jaw cychmo'nxin ttx'akan pan otk cyaj cyu'n xjal ti'j jwe' pan te cebada, bix e noj cablaaj chi'l. ");
INSERT INTO mamNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yaltzen ke xjal, tej cylonte jjawnex tipemal Jesús, e cykbaxin: —Tzinente ja xjal lu jtyolel Dios at tu'n tul twitz tx'otx'—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tejtzen tel tniy' Jesús ti'j e cyajbe xjal tu'n ttzyet-xin, tu'ntzen t-xi' cyii'n jaxin tisen cycawelxin, mas e jax lk'exin twi' witz, tu'n ttenxin tjunalxin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tejtzen tex k'ij, e cu'x ke t-xnak'atz Jesús ttzii' tnijabel a' te Galilea. ");
INSERT INTO mamNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bix ocxkexin tuj cychocxin, bix ak' i'yexkexin tuj a' tu'n cyponxin tuj tnom te Capernaum. Otk cub klolj tej cyocxxin tuj choc, pero mitkna'x tpon Jesús cyuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bix nimxsen oc punntz'aj a', cuma nuk tisen tii' tej ttzaj jun nintzaj cyk'i'k tibaj a'. ");
INSERT INTO mamNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nimxsen oc cyipenxin ti'j tu'n cyiy'xxin tuj tnijabel a'. Otktzen chi iy'xxin ca'ba ajlabl tej toc cycye'yenxin ja Jesús. Nbet-xin tibaj a', bix tzajne e tzaj lk'exin ti' cychocxin. Tej cylontexin jaxin, e jawxsen sey'pajkexin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero e xi' tkba'nxin cyexin: —Inayen weja. Mi'n tzaj ntz̈iya cyi'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tej tel cyniy'xin ti'j ka ja Jesús, e jawxsen tzalajkexin, bix e tzaj cytxco'nxin tu'n tocxxin tuj choc. Bix tujx naj e cub k'o'n cychocxin ttzii' a' jaa' tu'n cyponaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Te juntl k'ij, min e cnet Jesús cyu'n kej xjal otk chi cyaj ttzii' tnijabel a' jaa' otk k'oja cywa tu'nxin. Ultzen tuj cyc'u'jxin nuk junx choc otk ten ttzii' a', bix e cyilxin min otk tz'ocxin tuj ja choca tej cyiy' t-xnak'atzxin. Min el cyniy'xin ti'j ti tten tej tiy'xxin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Maatkxsen ete'xin jaa' otk chi waa'naxin tej t-xi' tk'o'n Cawel kxol chjonte te Dios, attzen juuntl choc e tzaj tuj tnom te Tiberio. ");
INSERT INTO mamNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ju' tzunj, tej cylontexin min-alx Jesús cyuya t-xnak'atzxin, ocxkexin cyuj choc, tu'ntzen cyponxin tuj Capernaum te jyolte Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tejtzen tcnet-xin cyu'nxin jlajxe a', e xi' cykanenxin texin: —Taat Xnak'tzal, ¿jtoo tzula tzalu?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aj ttzak'be'nxin cyexin: —Jaxxix cxe'l nkba'na cyey, tej t-xi' nyeec'ana wipemala ewe, nuk tu'n tel cyni'ya ti'j sma'n kena tu'n Dios, pero min ma tz'el cyni'ya ti'j techel. Nchi jyona wi'ja cuma cyaja nuk o'cx tu'n tnoj cyc'u'ja tisen ke alimaj. ");
INSERT INTO mamNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mi'n tz'oc cyipena nuk ti'j cyway nbaj tipen. Jax ju'x c'oquel cyipena ti'j tu'n tcnet jwaabj tzin tk'o'n cychunk'lala mlay baj. Jatzen waabja cxe'l nk'o'na cyey, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal. Tu'n wipemala o cyila, ma tzaj tyeec'an Kman Dios scy'o'n kena tu'n t-xi' nk'o'na jwaabj te cychunk'lala mlay baj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bix e xi' cykba'nxin texin: —¿Alcyej ak'untl taj Dios tu'n tbint ku'na, tu'n ttzalaj Dios ki'ja?—tz̈ikexin ");
INSERT INTO mamNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Bix aj ttzak'be'nxin cyexin: —J-ak'untl taj Dios tu'n tbint cyu'na, jaj tu'n cyocslana ti'j ma tzaj tsma'nxin inayen tzuna—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","E xi' cykba'nxin texin: —Ka jay sma'n tu'n Dios, k'ontz jun yec'bil jawnex, tu'ntzen kocslana ti' tyola. ¿Ti cbinel tu'na, tu'ntzen tchic'ajax ka jaxxix tyola? ");
INSERT INTO mamNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jma bint tu'na, yaa'n jawnex tisenj e bint tu'n Moisés tej t-xi' cywaa'n kxe'chel jwaabj e cu'tz twitz cya'j jaca k'ij tuj jlugar jaa' mintii' cynajbil xjal tuj. “E tzaj tk'o'n Dios waabj te tuj cya'j cye,” tz̈i tyol Dios—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ju' tzunj e xi' tkba'n Jesús cyexin: —Jaxxix cxe'l nkba'na cyey, yaa'n ja Moisés e tzaj k'onte waabj te twitz cya'j cyexin, sino ja te Nmana. Bix tzinx tk'o'nxin ja'lewe, pero jaj waabj ntk'o'n cychunk'lala mlay baj, ");
INSERT INTO mamNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","cuma tej waabj tzin tk'o'n Dios ntzaj tuj cya'j, bix c'ajbel tu'n tk'onte chunk'lal te junx maj cye xjal—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tej cybinte ke xjal kej tyolxin lu, e xi' cykba'nxin texin: —Taat, k'ontzne ja jawnex waabj lu keya jaca k'ij—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Bix e xi' tkba'n Jesús cyexin: —Inayenja jwaabj tzin tk'o'n chunk'lal te junx maj. Alcye kej xjal chi tzaal wuyena, mintii'tl tak' weyaj cye, bix jax alcye kej xjal chi ocslal wi'ja, ya mintii'tl ccyajbe'. ");
INSERT INTO mamNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jatzen cyey, nim maj ma txi' nk'o'na nxnak'tzbila cyey, bix amale matet cyila wipemala, pero min chi ocslana wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tuj nk'aba ma tak'a Nmana cykil kej xjal at tu'n cyclet. Bix mi nuket jun xjal, oj tul wuyena tu'n tclet, q'uelelet nxoo'na. ");
INSERT INTO mamNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mlay che'x nxoo'na, cuma ma chin cu'tza tuj cya'j yaa'n tu'n nbinchana weya wajbil, sino tu'n nbinchana tajbil Nmana ma tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jtajbil Nmana ma tzaj tsma'n inayena, jaj tu'n mi'n cyaj mi nuket jun xjal tuj cyamecy kej xjal ma tzaj tk'o'nxin tuj nk'aba tu'n cyclet. Taj Nmana tu'n cyjaw itz'j cykilca tuj cyamecy wu'na juntl maj tuj manc'bil k'ij. ");
INSERT INTO mamNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jtaj Nmana, jaj tu'n tten cychunk'lal te junx maj jaca juun xjal ma tz'el tniy' ti'j alcye kena bix ma tz'ocslan wi'ja. Kej xjal nbint cyu'n ju'wa, inayena cjawetz itz'jsa'ncye tuj cyamecy tuj manc'bil k'ij—tz̈i Jesús cye kej judío nchi k'ojl ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tejtzen cybinte ke judío tyol Jesús, el ka' tyolxin tuj cywitzxin, cuma otk txi' tkba'nxin: “Inayena jwaabj e cu'tz tuj cya'j.” ");
INSERT INTO mamNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","E xi' cykba'nxin cyxolxxin: —¿Yaa'mpatzen jaj xjal lu nuk Jesús, tcwal jxin José? Ktzki'n twitz tmanxin bix twitz ttxuxin María. ¿Titzen tten nxi' tkba'nxin ka e cu'tzxin tuj cya'j?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Bix e xi' tkba'n Jesús cyexin: —¿Tikentzen nchi jaw yolena wi'ja cyxolxa ju'wa? ");
INSERT INTO mamNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jaxte ma tzaj tsma'n Nmana inayena. Yaa'n tu'nj nchi yolena ju'wa chi ocslala wi'ja, sino tu'nj oj ttzaj tk'o'n Nmana jun tajbil tuj cyanema tu'n cyocslana wi'ja. Bix tuj manc'bil k'ij cjawetz witz'jsa'na tuj cyamecy kej xjal ma chi ocslan wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jaxte at xjal chi ocslal wi'ja, cuma tuj tyol Dios e cykba tyolel Dios cyjulu: “C'oquel tk'o'n Dios cye xjal, tu'n tel cyniy' ti'j,” tz̈i tyol Dios. Kej xjal cybi' jtzin tkba'n Nmana bix chi ocslal ti'j tyol, jax chi ocslal wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Min tzin nkba'na o til jun xjal twitz Nmana, cuma mi nuk jun xjal o til twitzxin. Nuk jaj xjal sma'n tu'n Dios o til twitzxin, inayen tzuna. ");
INSERT INTO mamNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jaxxix cxe'l nkba'na cyey, alcyej xjal ma tz'ocslan wi'ja, at tchunk'lal te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inayenja jwaabj tzin tk'o'n chunk'lal te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yal tej waabj e cu'tz twitz cya'j, e xi' cywaa'n ke cyxe'chela, pero e cyimke. ");
INSERT INTO mamNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero jwaabj nchin yolen weya ti'j, e cu'tz tuj cya'j, bix oj twaa'n jun xjal ti'j, mi'n cyim. ");
INSERT INTO mamNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Bix ja waabj i'tz lu e cu'tz tuj cya'j bix ntk'o'n chunk'lal cye xjal, inayen tzuna. Alcyej xjal cwaa'l ti'j jwaabj lu, attzen tchunk'lal te junx maj. Bix jwaabj cxe'l nk'o'na tu'n tten cychunk'lal xjal, jatzen nxumlalja—tz̈i Jesús cye judío. ");
INSERT INTO mamNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tejtzen cybinte judío tyol Jesús ti'j t-xumlal, ak'kexin k'ojlel cyxolxxin ti'j ti japenina ja yol lu. E baj cykanenxin: —¿Ti tten tu'n ttzaj tk'o'n jxin lu t-xumlal ke, tu'n t-xi' kchyo'n?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ju' tzunj, e xi' tkba'n Jesús cyexin: —Jaxxix cxe'l nkba'na cyey, ka min ma txi' cywaa'na nchu'la, bix ka min ma txi' cyc'a'na ntz̈q'uela, mlay ten cychunk'lala, cuma inayena jxjal sma'n tu'n Dios tu'n nk'onteya cychunk'lal xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Alcyej xjal cxe'l twaa'n nchu'la bix cxe'l tc'a'n ntz̈q'uela, attzen tchunk'lal te junx maj, bix cjawel witz'jsa'na tuj cyamecy tuj manc'bil k'ij. ");
INSERT INTO mamNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ntk'o'n chunk'lal, cuma jwaabj jaxxix ja nchu'la bix ntz̈q'uela. ");
INSERT INTO mamNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Alcyej xjal cxe'l waa'nte nchu'la bix cxe'l c'ante ntz̈q'uela, c'oqueltzen junx wuyena, bix jax chin oquela junx tuya. ");
INSERT INTO mamNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","O tzaj itz'j cykil chunk'lal ti'j Nmana i'tz, bix cuma junx kena tuya Nmana e tzaj tsma'n inayena, ju' tzunj at chunk'lal wuyena tu'n t-xi' nk'o'na cye xjal. Bix tisenj at chunk'lal wuyena tu'nj ti'jxxin o chin tza'ya, jax ctemel tchunk'lal jxjal cwaa'l wi'ja, cuma otktzen tz'oc wuyena. ");
INSERT INTO mamNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Key xjal, inayena ja waabj o cu'tz tuj cya'j. Jwaabj e xi' cywaa'n cyxe'chela yaa'n jwaabj jaxxix te tuj cya'j, cuma e tiinkexin bix e cyimkexin. Pero ja waabj jaxxix lu, alcyej xjal cwaa'l ti'j, attzen tchunk'lal te junx maj—tz̈i Jesús ");
INSERT INTO mamNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","tej t-xi' t-xnak'tza'nxin cye xjal tuj camon jaa' te xnak'tzbil ti' tyol Dios tuj tnom te Capernaum. ");
INSERT INTO mamNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kej xjal e bet tuya Jesús, tej cybinte kej yol lu, at nim xjal cyxolxin e xi' cykba'n: —Yaa'n tumel kej yol lu. Mlay tu'n kocslan cyi'j—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pero el tniy' Jesús ti'j e jaw yolen kej xjal e xi' lpe ti'jxin ti'j tyolxin, bix e xi' tkba'nxin cyexin: —¿N-elpa cyiiq'uena ja yol lu tu'n t-xi' cywaa'na nxumlala cuma ka' tuj cywitza? ");
INSERT INTO mamNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Katzen yaa'n telniy' tuj cywitza ja'lewe, ¿ti toc cyu'na nuket cyila oj njaxa jaa' in tiina nejl bix min-atl nxumlala? Tuj cywitza, jac'a nxumlala cxe'l cywaa'na, pero min ma tz'el cyni'ya ti'j nyola. ");
INSERT INTO mamNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tu'n tcnet cychunk'lala, ja nyola c'oquel te cyway. ");
INSERT INTO mamNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero at juun cyxola mi'n cyiik' cychunk'lal, cuma n-el cyxoo'n nyola—tz̈i Jesús. E xi' tkba'nxin ju'wa cuma ttzki'nxin jatxe tej cyak' oquel lpe xjal ti'jxin alcyej min e cyocsla jaxin. Bix jax ju'x ttzki'nxin alcyej cyxol t-xnak'atzxin at tu'n t-xi' tq'ueyen jaxin tuj cyk'ab kej xjal at tu'n tcub cybyo'n jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tu'n tpon baj tyolxin, e xi' tkba'nxin cyjulu: —Ma txi' nkba'na cyey, min-al jun xjal c'ocslal wi'ja ka min ma tzaj tk'o'n Nmana te xjal tu'n tocslan wi'ja—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Cuma otk txi' tk'umen Jesús kej yol lu cye xjal, ju' tzunj nim xjal e cyaj cycye'yen jaxin, bix mintl e betkexin tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ju' tzunj, e xi' tkba'nxin cyej cablaaj t-xnak'atzxin: —Yaj cyey, ¿jax cyajpey cyaj cycye'yena inayena?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bix aj ttzak'be'n Simón Pedro texin: —Taat, mi'n cyaj kcye'yena. Min-al juntl tu'n kxi'ya tuya. Nuk jay nxi' tii'na kej yol ntk'o'n kchunk'lala te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","N-el kni'ya ti'j ka jay jjawnex xjal scy'o'n tu'n Dios, bix ma ko ocslana ti'ja—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Bix aj ttzak'be'n Jesús cye t-xnak'atzxin: —Inayen weja ma scy'onte cyey cablaaj cybaja tu'n cyoca te nxnak'atza. Pero at jun cyey ma tz'oc tnaabl tisen jun biman—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jyol lu e xi' tkba'nxin ti'j Judas, tcwal Simón Iscariote, cuma ja Judas tu'n t-xi' q'ueyente texin. ¡Pero cyimel niy', jaanxin cyxol kej cablaaj t-xnak'atz Jesús! ");
INSERT INTO mamNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tbajlenxitltzen jlu, e cyaj ten Jesús tuj Galilea, bix iy'xin te kbalte tcawbil Dios cyuj tnom. Min e tajbexin tu'n tiy'xin tuj Judea, cuma e cyajbe nejenel cye judío tu'n tcub cybyo'n jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pero ch'itk tpon jun jawnex nink'ij cye xjal judío, jk'ij tu'n cyten xjal jun smant cyuj ni' pach. ");
INSERT INTO mamNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ju' tzunj, e xi' cykba'n titz'enxin texin: —Ctex tzalu, ju' txi'y Judea, tu'ntzen toc cycye'yen kej xjal nchi oc lpe ti'ja jatzewe ti nbint tu'na. ");
INSERT INTO mamNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ka taja tz'oca te jun cawel, mi'n txi' tyeec'ana tipemala nuk cyxol kej xjal tzalu yaa'n nintzaj. Oj tyeec'ana tipemala, yeec'anx tiiba twitz cykil xjal, yaa'n nuk cywitz ca'ba oxe yalx xjal tzalu—tz̈i ke titz'enxin, tu'n toc cyxmuccha'nxin jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Amale titz'et-xin ejee'xin, pero min e cyocslaxin ka jaxin Jscy'o'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ju' tzunj, e xi' tkba'n Jesús cyexin: —Mina'x tpon jk'ij tu'n woca te nintzaj cyibaj xjal. Pero cyey, cykil k'ij ba'n tu'n cyyeec'ana jawnex key cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mlay tz'el cyiiq'uen xjal ejee'y. Pero weya, cycy'i xjal inayena, cuma wu'na nchic'ajaxa jka' nbint cyu'n. ");
INSERT INTO mamNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ejee'xa nche'xa tuj nink'ij. Weya, mi'n chixa tuj nink'ij cyuyey, cuma mina'x tpon tumel tu'n njawa—tz̈i Jesús cye titz'en. ");
INSERT INTO mamNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tej t-xi' tkba'n Jesús kej yol lu, bix e cyajxin tuj Galilea. ");
INSERT INTO mamNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero mas yaj, cyxi'lenxitltzen titz'enxin tuj nink'ij, yal texxin e xi'xin, pero yaa'n cywitz xjal, sino tjunalxin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tejtzen cypon aj Galilea tuj Jerusalén pero min-al Jesús cyxolxin, e jyon ke judío ti'jxin, bix e xi' cykanenxin: —¿Jaa' ta' jxjal Jesús?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Cyxol kej xjal otk chi pon tuj nink'ij, at nim yol ti' Jesús cyu'n, pero tuj ewjel. At juun e xi' kbante: “Jun ba'n xjalxin.” Pero at juuntl e xi' kbante: “Jaxin jun tzpetsal xjal.” ");
INSERT INTO mamNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero nuk tuj ewjel e yolen ke xjal, cuma at cytz̈i nejenel cye judío cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Otk tz'ex niy'jan nink'ij tej tocx Jesús tuj nin tja Dios. Bix ak'xin xnak'tzal cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tej cybinte nejenel cye judío t-xnak'tzbilxin, e jaw klee'kexin, bix e xi' cykba'nxin: —¿Ti tten nimxsen ba'n tu'nj xjal lu? Bix min o xnak'tzet cyu'n maystro escuela—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ju' tzunj, e xi' tkba'n Jesús cyexin: —Jxnak'tzbil nxi' nk'o'na cyey, yaa'n weya nyola, sino tyol Nmana e tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kej xjal cyaj tz'oc cybi'n tajbil Dios, q'ueleltzen cyniy' ti'j nxnak'tzbila, ka te Dios, bix ka nuk wexwe nyol. ");
INSERT INTO mamNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nuket nxi' nk'o'na wexa nyola cyey, wajattzen loya tu'n tjaw nimset nbi'ya cyu'n xjal. Pero yaa'n ju'wa, cuma waja tu'n tjaw nimset Nmana e tzaj tsma'n inayena. Ju' tzunj, jun jaxxix xnak'tzal kena, yaa'n jun xnak'tzal min tz'ajben, tisenj cyey tzin cykba'n. ");
INSERT INTO mamNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ejee'xa kej xjal tzpetsal xjal. E tak' te Moisés tley Dios cyey. Pero mi nuket jun cyey n-oc ebinte ley te Moisés. Ka ma cykbay n-oc cybi'na, ¿ti tten cyaja tu'n tcub cybyo'na inayena?—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bixsen e jaw cys̈i'n xjal texin: —¡Njaw tuj twi'y! ¿Alcye xjal taj tu'n tcub byo'na tu'n?—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Bix aj ttzak'be'n Jesús cyexin: —Nuk jun maj e cub nco'pana jun yaab tuj tyabel tuj k'ij te ajlabl, bix ka'xsen o tz'e'la tuj cywitza. ");
INSERT INTO mamNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero c'oquel cyc'u'ja ti'j ti toc tu'n Moisés tu'n tonen cyi' xjal. E tak' te Moisés jley cyey tu'n tcpet tchu'l ttz'albil jaca juun ẍlak xinak. Bix yaa'n nuk Moisés e tzaj k'onte ja ley lu, sino ak' ke tneel cyxe'chela binchal jlu. C'oquel cyc'u'ja ti'j, ka k'ij te ajlabl oj npon twajxakan k'ij titz'jlen jun ẍlak, cpeteltzen cyu'na tu'n cycuyana tuya ley, amale k'ijet te ajlabl. ");
INSERT INTO mamNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Katzen ju' nbint cyu'na tuj k'ij te ajlabl tu'ntzen cynimana tley Moisés, ¿tikentzen njaw cyk'oja wi'ja tu'nj ul tnaabl cykilca t-xumlal jun yaab wu'na tuj k'ij te ajlabl? ");
INSERT INTO mamNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tuj cywitza in binchana jun il, pero mi'n chi kbana ka ka' j-e bint wu'na, sino c'oquel cyc'u'ja ti'j tu'n tel cyni'ya ti'j ka jiquen waak'ena twitz ley—tz̈i Jesús cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Cuma otk yolen Jesús cyiw cye xjal, ju' tzunj at juun aj Jerusalén e xi' cykba'n: —¿Yaa'mpa ja xinak lu nchi jyon xjal ti'j tu'n tcub cybyo'n? ");
INSERT INTO mamNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pero lux nyolen cyuya xjal bix min-al jun nejenel cye xjal ma txi' tkbante texin tu'n twe'xin tyolxin. ¿Japale xjal jlu Scy'o'n tu'n Dios te Cawel tuj cywitz nejenel? ");
INSERT INTO mamNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero n-el kniy' ti'j yaa'n jaxin Jscy'o'n tu'n Dios, cuma ktzki'n jaa' itz'jaxin bix alcye ke tmanxin. Yal tej xjal Scy'o'n tu'n Dios, oj tulxin, min-al ttzki'n jaa' ctzaalaxin bix alcye tmanxin—tz̈i ke aj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Maatktzen at Jesús tuj tja Dios, e tbixin tej t-xi' cykba'n aj Jerusalén ka yaa'n jaxin jCristo. Ju' tzunj, e jaw ts̈i'nxin: —¿Tzimpa cykba'na alcye kena bix jaa' in itz'ja bix alcye kej nmana? Pero mintii' tumel cyuyey. Yaa'n wu'nxa ma chin tzaja, tisenj tzin cykba'na. At jun e tzaj tsma'n inayena, pero cycy'iy jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Weya, ntzki'na twitzxin, cuma in tiina tuyaxin bix e tzaj tsma'nxin inayena tzalu—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tejtzen cybinte nejenel cye judío kej yol lu, oc cyipen ti'j tu'n tcub cytzyu'n ja Jesús. Pero mixbe cyu'n, cuma mitkna'x tpon tumel e tkba Dios tu'n tcyimxin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero cyxol xjal otk chi pon tuj Jerusalén, at nim e xi' tocsla'n ka jaxin Scy'o'nxin tu'n Dios, ja Cristo. Bix e xi' cykba'n cyej xjal min ocslante: —Ka yaa'n Jscy'o'n tu'n Dios jxjal lu tuj cywitza, oj tul jxjal nchi ayona ti'j, ¿ba'mpale cbinchal mas twitzj ya ma bint tu'n ja xjal lu?—tz̈i ke xjal ocslal. ");
INSERT INTO mamNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tej cybinte kej fariseo nchi yolen xjal ti'j Jesús Jscy'o'n tu'n Dios, e xi' cysma'n aj fariseo bix ke nejenel cye pala cab tc'ojlal tja Dios te tzyulte texin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ju' tzunj, e xi' tkba'nxin cyexin: —Nuk ch'intl chin temela cyxola, cuma chin aal meltz'aja tuya Nmana j-e tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chi jyola wi'ja, pero mlay chin cneta cyu'na, cuma mlay chi pona jaa' chin temela—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ju' tzunj, e xi' cykba'n nejenel cye judío cyxolx: —¿Jaa' tumel cxe'la jxjal lu, tu'ntzen mi'n cnet ku'n? ¿Cxe'lpaxin cyxol kej judío o chi el tz̈itj cyuj cytanem xjal yaa'n judío? ¿Jac'apa txi' tk'o'nxin t-xnak'tzbil te cyej xjal yaa'n judío? ");
INSERT INTO mamNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ti japenina ja yol: “Chi jyola wi'ja, pero mlay chin cneta cyu'na, cuma mlay chi pona jaa' chin temela”?—tz̈i ke judío. ");
INSERT INTO mamNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tujtzen manc'bil k'ij te nink'ij, jk'ij mas xjan, e cub we' Jesús, bix e jaw ts̈i'nxin: —Alcyej xjal at tak' a' te, tzajxit wuyena, bix cxe'l nk'o'na tc'a. ");
INSERT INTO mamNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Alcyej xjal c'ocslal wi'ja, j-a' cxe'l nk'o'na, c'oqueltzen te jun nima' tuj tanem ctk'a' tchunk'lal te junx maj, tisen tzin tkba'n ootxa tyol Dios—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Pero ja yol lu ti'j a' e xi' tkba'nxin ti'j Espíritu Santo, cuma at tu'n tk'oj Espíritu Santo te cyej xjal ocslan ti'jxin, cuma mitkna'x tk'oj Espíritu Santo cye ocslal, cuma mitkna'x tjatz itz'j Jesús tuj cyamecy bix mitkna'x tjaxxin tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tej cybinte xjal ti otk tkba Jesús tuj nink'ij, at juun e xi' cykba'n: —Jatzen xjal jlu jjawnex tyolel Dios e tkba Moisés at tu'n tul—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","At juuntl e xi' cykba'n: —Jatzen xjal jlu jmero Scy'o'n tu'n Dios—tz̈ikexin. Pero at juuntl e xi' cykba'n: —Min. Mlay tz'itz'j Jscy'o'n tu'n Dios maa tuj Galilea. ");
INSERT INTO mamNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Yaa'mpatzen tzin tkba'n tyol Dios ka ti'j tiy'jil David tuj ttanem David, jtnom te Belén, q'uitz'jel Jscy'o'n tu'n Dios?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ju'tzen tten e jaw jun k'oj cyxol xjal tu'n tlaj alcye Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","At juun e cyajbe tu'n ttzaj cytzyu'n jaxin, pero min-al jun cye e tzyunte, tu'n tocx cyk'o'n jaxin tuj tzee'. ");
INSERT INTO mamNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yaltzen ke c'ojlal tja Dios, e pon meltz'ajke cyuya nejenel cye pala bix cyuya ke fariseo. Min-al Jesús k'i'n cyu'nxin. Ju' tzunj, e xi' cykba'nxin cye c'ojlal tja Dios: —¿Tikentzen min tzaj cyii'na?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bix aj cytzak'be'n c'ojlal tja Dios: —Min xknimsaya kc'u'ja tu'n xtzyet ku'na, cuma min-al jun xjal o yolen tuya tipemal tisen ja xjal lu—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ju' tzunj, e xi' cykba'n fariseo cye c'ojlal tja Dios: —¿Ju'xpa cyey ma chi tzpeta tu'nxin? ");
INSERT INTO mamNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Atpa jun keya kxola, ejoo'ya nejenel cye xjal bix ejoo'ya aj fariseo, ma ko ocslana ti'jxin? Min. ");
INSERT INTO mamNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kej tnimal xjal lu min cytzki'n ley tisen ejoo'ya. Min chi ajben. ¡Cubxit tsbubl Dios cyibaj!—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pero at jun aj fariseo cyxolxin yaa'n junx cyuya niy'tl fariseo. Nicodemo tbixin, jaj xin e pon tuya Jesús jun koniyan. E xi' tkba'n Nicodemo cye fariseo: ");
INSERT INTO mamNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Tuj kley, yaa'n tumel tu'n tcub kk'o'n tcastiwa jun xjal ka mitkna'x kbinte tyol tu'n tco'pan tiib, bix ka mitkna'x kcye'yen tbinchben, tu'n tel kniy' ti'j ka yaa'n ba'n—tz̈i Nicodemo. ");
INSERT INTO mamNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bix aj cytzak'be'nxin te Nicodemo: —Nyolena tisen junx ta' tnaabla cyuyaj yalx xjal te Galilea. C'oquel tc'u'ja ti'j tyol Dios, tu'n tel tni'ya ti'j min-al jun tyolel Dios nitz'j tuj Galilea—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tejtzen tbaj nink'ij, cykilca xjal ajke cyja. ");
INSERT INTO mamNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yaltzen te Jesús, e xi' tc'u'j jwitz Olivos tbi. ");
INSERT INTO mamNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Te juntl k'ij, tej kskix, ocx Jesús juntl maj tuj tja Dios tuj Jerusalén. Bix nim xjal e pon tuyaxin. E cubtzen kexin, bix ak'xin xnak'tzal cye. ");
INSERT INTO mamNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Maatktzen nxnak'tzanxin, e pon ke tx'olbal ley cyuya ke fariseo twitzxin. Matkx tjaw tzyet jun xuuj aj paj cyu'nxin tej nbinchan jyaa'n ba'n, bix ul cyii'nxin jaxuj, bix e cub cywa'baxin cyxol xjal tuj tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bix e xi' cykba'nxin te Jesús: —Xnak'tzal, ja xuuj lu jun aj paj. Xtzyet ku'na tej toc kcye'yena nwutanxuj tuya jun xinak yaa'n tchmilxuj. ");
INSERT INTO mamNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Taat, e cyaj tkba'n Moisés tuj ley, ka at jun xuuj aj paj, iltzen ti'j tu'n tcub byet-xuj tu'n xak. Yaltzen tey, ¿ti toc tu'na ti'j lu?—tz̈ikexin texin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pero e xi' cykba'nxin jlu nuk tu'n tcub cyk'o'nxin jun c'o'bil tuj tbexin, tu'n tcub tz'akxin tuj tyolxin, tu'ntzen tcnet tilxin cyu'nxin. Mintii' aj ttzak'be'nxin cyexin. Nuk e cub pch'exin, bix ak'xin tz'iblc'ate twitz tx'otx' tu'n twi' tk'abxin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero tej t-xi' cykanenxin texin juntl maj, e jaw tcye'yenxin, bix e xi' tkba'nxin: —Ka at jun cyxola mintii' til tuj twitz, ba'ntzen toc t-xoo'n tneel xak ti'jxuj—tz̈i Jesús, ");
INSERT INTO mamNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","bix e cub pch'exin te tz'iblc'ate juntl maj twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tejtzen cybintexin tyol Jesús, e tzaj cych'ixewxin, bix ak' elex juun cyexin. Nejl, ex kej nejenel mas nintzaj, bix manc'biltzen ex baj ke fariseo. Nuk ja Jesús e cyaj ten tuya xuuj cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Bix e jaw we' Jesús, bix e xi' tkanenxin te xuuj: —Naa, ¿tii'n ma che'x ke kbal tila? ¿Mimpanal ma cyaj tu'n toc cyxoo'n xak ti'ja?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Min-al, taat—tz̈ixuj. Bix e xi' tkba'n Jesús texuj: —Jax ju'x weya, mlay cub nk'o'na tcastiwey. Cutxey, bix mi'n binchantla il juntl maj—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Juntl maj e yolen Jesús cyuya aj fariseo. E xi' tkba'nxin cyexin: —Inayena tisen spi'yen cye xjal. Kej xjal ma chi oc lpe wi'ja, mlay chi bet tuj klolj, sino chi temel tuj spi'yen. At cychunk'lal te junx maj—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ju' tzunj, e xi' cykba'n fariseo texin: —Mintii' c'ajbel tyola, cuma jax tey nyolena te tstiwa ti'jxa. Min-al juntl tu'n tcyiwsante tyola—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pero aj ttzak'be'n Jesús cyexin: —Jax at tajbel nyola. Jaxxix nyola ti'j alcye kena, cuma nuk inayena ba'n wu'na jaa' tumel in tzaja bix jaa' tumel chin xe'la. Pero cyey, min-al jun cyxola ba'n tajben te tstiwa wi'ja, cuma min cytzki'na jaa' tumel in tzaja bix jaa' tumel chin xe'la. ");
INSERT INTO mamNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tzin cykba'na yaa'n inayena jxjal sma'n tu'n Dios tu'n tlaj nche'x lpey nuk ti'j cynaabl xjal, bix tzin tkba'n cynaabl xjal nuk jun aj Galilea kena. Weya, min nbint wu'na tu'n ntzpeta ju'wa tu'n nxi' lpeya ti'j cynaabl xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Oj nmlona tnaabl jun xjal, cxe'l nkba'na ti tten tuya jun yol jaxxix, cuma min chin mlona njunala, sino junx tuyax Nmana e tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tujtzen cywitza, mintii' tajbel nyola nbyan wu'na. Pero c'oquel cyc'u'ja ti'j cyleya. O tz'ibj ka at ca'ba xjal junx ta' cyyol, jaxxixtzen cyyol. ");
INSERT INTO mamNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ju' tzunj, jaxxix ta' nyola ti'j alcye kena, cuma yaa'n nuk inayena tstiwa wi'ja, sino jax Nmana e tzaj tsma'n inayena tstiwa wi'ja—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ju' tzunj, e xi' cykba'nxin texin: —¿Jaa' ta' tmana, tu'ntzen tajben te tstiwa ti'ja?—tz̈ikexin. Aj ttzak'be'n Jesús: —Min tz'el cyni'ya ti'j alcye kena bix alcye Nmana. Nuket ma tz'el cyni'ya ti'j alcye kena, jax cytzki'ntla Nmana—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kej yol lu e xi' tkba'nxin tuj tja Dios jaa' e cyk'a xjal cyoybil te tja Dios. Pero min-al e tzaj tzyunte texin, cuma mitkna'x tpon jk'ij tu'n tcubxin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Bix juntl maj e xi' tkba'nxin cye fariseo: —Chin aal tzuna. Bix oj waja, chi jyola wi'ja, inayena, Colbil cyey, pero chi cymeela bix min najset cyila. Jaa' tumel chin pomela, mlay chi pona—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ju' tzunj, e xi' cykba'n judío cyxolxxin: —¿Tu'nxpaxin cwel tbyo'n tiibxin? Cuma ma txi' tkba'nxin: “Jaa' tumel chin pomela, mlay chi pona”—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Bix e xi' tkba'nxin cyexin: —Ejee'y nche'x lpey ti'j naabl te twitz tx'otx'. Inayena at nnaabla te tuj cya'j, yaa'n te twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Cuma at cynaabla te twitz tx'otx', ju' tzunj chi cymeela tjak' cyila, cuma ka min ma cyocslay ti'j ma txi' nkba'na ti'j alcye kena, chi cymeela min najset cyila—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Alcye tzuna?—tz̈ikexin E xi' tkba'n Jesús cyexin: —Ma txi' nkba'na alcye kena jatxe tuj tneel. ¿Tikentzen min cyocslay nyola? ");
INSERT INTO mamNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","At nim cyka'yela ba'n t-xi' nkba'na cyi'ja, pero waja txi' nk'umena nuk tyol j-e tzaj tsma'n inayena. Jaxxix tyolxin, bix j-e nbi'ya texin, ja tzunj yol nchin yolena cye xjal—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero min el cyniy'xin ti'j e yolen Jesús ti'j Dios, Jtmanxin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ju' tzunj e xi' tkba'nxin cyexin: —Oj njaw cyk'o'na twitz cruz, q'ueleltzen cyni'ya ti'j ka inayena jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal. Bix q'uelel cyni'ya ti'j ka jnxi' nkba'na cye xjal, yaa'n jweya wajbila, sino nxi' nkba'na nuk alcyej e tyeec'an Nmana weya. ");
INSERT INTO mamNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bix Nmana e tzaj tsma'n inayena at-xin wuyena. Min ma chin cyaj tcye'yenxin, sino ntzalaj wi'ja, cuma nuk nchin binchana tajbilxin—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tej t-xi' tkba'n Jesús kej yol lu, nim xjal e cykba ka ocslalke ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ju' tzunj, e xi' tkba'nxin cyej judío otk chi ocslan ti'jxin: —Ka cyaja tu'n cyxi' lpey wi'ja, c'oqueltzen cybi'na nyola. ");
INSERT INTO mamNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Bix q'uelel cyni'ya ti'j ka jaxxix nxnak'tzbila, bix tu'n tzunj nxnak'tzbila, chi tzakpetela—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bix e xi' cykba'n kej judío te Jesús: —Tchman kiy'jila Abraham ko'ya, bix bajx o ko tema tjak' cycawbil juntl wik xjal. ¿Titzen tten nxi' tkba'na at jun il ti'j tu'n ktzakpeta?—tz̈i ke judío. ");
INSERT INTO mamNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Aj ttzak'be'n Jesús cyexin: —Jaxxix cxe'l nkba'na cyey, alj nbinchan il, attzen tuj tk'ab il. ");
INSERT INTO mamNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","C'oquel cycwenta ti'j jun techel. Tuj jun jaa', jun maan mlay cyjel te junx maj tuj jaa'. Pero tcwal taaw jaa', at toclen tu'n tcyaj tuj jaa' te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jmaan mintii' toclen ntechla'n ejee'y xjal ete'y tuj tk'ab il. Nuk inayena, Tcwal Dios, ba'n tel ntzakpi'na ejee'y tuj tk'ab il. ");
INSERT INTO mamNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jax cyu'na tiy'jil Abrahamkey. Pero yaa'n t-xjal Dioskey, cuma cycy'iy nyola bix ju' tzunj cyaja tu'n ncub cybyo'na. ");
INSERT INTO mamNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pero jyol nxi' nkba'na cyey bix cycy'iy, jatzen yolj ma tzaj tk'o'n Nmana weya. Yaltzen cyey cyyol, nxi' cykba'na jaj ma cybiy te cyey cyman—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","E xi' cykba'nxin texin: —Keya kman, ja kiy'jila Abraham—tz̈ikexin. E xi' tkba'n Jesús cyexin: —Ka tcwal Abrahamkey, cybinchamna j-e bint tu'n Abraham. ");
INSERT INTO mamNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero min nche'x lpey ti'j tbinchben Abraham. Nuk o'cx n-oc cyipena tu'n ncub cybyo'na, inayena, jxjal ma txi' nkba'na jjaxxix yol cyey, jaj yol ma nbi'ya te Dios. Min e bint tu'n Abraham ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","At juntl cymana, jatztzen nche'x lpey ti'j tnaabl—tz̈ixin. E xi' cykba'nxin texin: —Jaxte t-xe'chel Abraham ko'ya. Yaa'n sicy'bel cwal ko'ya. Bix tcwal Dios ko'ya—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","E xi' tkba'n Jesús cyexin: —Nuket Dios cymana, n-octle wak'a cyey, cuma ti' Dios ma chin tzaja. Yaa'n wu'nx wiiba ma chin tzaja, sino jaxin e tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tikentzen min tz'el cyni'ya ti'j nyola? Min tz'el cyni'ya ti'j cuma cycy'iy tz'oc cybi'na nyola. ");
INSERT INTO mamNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Cyey cyman, ja taaw il. Cyaja tu'n cyxi' lpey ti'j ti tajxin. Jaxin jun byol xjal jatxe tcublen itz'j twitz tx'otx'. O tz'el tpa'n tiibxin ti'j jaxxix yol, cuma tcy'ixin jjaxxix. Oj nẍtak'enxin, nuk nxi' lpexin ti'j texxin tnaablxin. Ẍtak'xin, bix jaxin cyman kej xjal ẍtak'. ");
INSERT INTO mamNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero weya, jaxxix yol tzin nkba'na, bix ju' tzunj cycy'iy nyola. ");
INSERT INTO mamNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Atpa jun cyey o tz'ebinta mi nuket jun ẍtak' nyola? Min-al. Ju' tzunj, ¿tikentzen cycy'iy tu'n cyocslana nyola oj nxi' nkba'na jaxxix yol cyey? ");
INSERT INTO mamNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kej xjal te Dios, nxi'tzen cybi'n tyol Dios. Ju' tzunj, nchic'ajax yaa'n t-xjal Dioskey, cuma min nxi' cybi'na tyol Dios—tz̈i Jesús cye judío. ");
INSERT INTO mamNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bix e xi' cykba'nxin texin: —Jax ku'na jay jun xjal nk'ojla ti' Dios tisen ke aj Samaria, bix njaw tuj twi'y—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aj ttzak'be'n Jesús: —Min njawwe tuj nwi', sino nchin nimana Nmana. Pero cyey, nchi xmucchana wi'ja nuk tu'nj nchin nimana Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pero min n-oc wipena tu'n woca te jawnex. At juntl xjal ctzaal tk'o'n weya tu'n woca te jawnex, bix ctkba' ka ba'n nchin e'leya tuj twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jaxxix cxe'l nkba'na cyey, kej xjal cxe'l cyniman nyola, ck'ojel cye jun cychunk'lal tu'n mi'n chi cyim—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","E xi' cykba'n judío texin: —Tzinenxsen njaw tuj twi'y. E cyim Abraham kaape ootxa, bix jax ju'x ke tyolel Dios o chi cyim. Pero tey, tzin tkba'na ka ma txi' tniman jun xjal tyola, mlay cyim. ");
INSERT INTO mamNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Japa tey mas jawnex twitzj tneel kiy'jila Abraham e cyim? ¿Bix japa tey mas jawnex cywitzj tyolel Dios e cyim? ¿Titzen tten njaw tniman tiiba ju'wa?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aj ttzak'be'n Jesús: —Ka ma jaw nnimana wiiba, nuk wajxe nchin yolena. Pero jax Nmana njaw nimsante weya, Cydiosa tuj cywitza. ");
INSERT INTO mamNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Min cytzki'na Dios. Pero weya, ntzki'na jaxin. Nuket t-xi' nkba'na min ntzki'na jaxin, ẍtak'tzen kenle tisenj ejee'y. Pero ntzki'na jaxin, bix n-oc nbi'na tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yaltzen te Abraham, tej tel tniy'xin ti'j at tu'n ntzaja, e tajbexin tu'n ntzaja, bix e tilxin tej ntzaja, bix e jaw tzalajxin wi'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ju' tzunj, e xi' cykba'n judío texin: —¿Tzimpa tkba'na e tena junx tuya Abraham twitz tx'otx' kaape ootxa? At-x nim jnabk'i tu'n tpona cya'wnak tuya laaj jnabk'i. ¿Ti tten nxi' tkba'na o tila Abraham?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","E xi' tkba'n Jesús cyexin: —Jaxxix cxe'l nkba'na cyey, tej mitkna'x titz'j Abraham, inayena at—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tejtzen cyebinte judío ja yol lu, el cyniy'xin ti'j oc tk'on tiibxin te junx tuya Dios. Ju' tzunj, e jaw cytzyu'nxin xak tu'n toc cyxoo'nxin ti'jxin. Pero e xi' tewenx tiibxin cyxol xjal, bix etzxin tuj tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tejtzen tetz Jesús tuj nintzaj tja Dios, tcub junxin xjal mos̈. Mos̈xin titz'jlenxin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bix e xi' cykanen t-xnak'atz Jesús te: —Taat Xnak'tzal, ¿alcye e binchan il, ti'j itz'j ja xjal lu mos̈? ¿Japa mos̈, bix ka ejee' tmanxin?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aj ttzak'be'n Jesús: —Min ul itz'jxin mos̈ tu'n tlaj jun tilxin. Jax ju'x ke tmanxin, min ul itz'j cycwal mos̈ tu'n tlaj jun cyil. Ul itz'j ja xjal lu mos̈ tu'ntzen tyeec'aj tipemal Dios oj tbint. ");
INSERT INTO mamNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bix ma pon tumel. Iltzen ti'j tu'n tbint ku'n j-ak'untl o k'oj ke tu'n Nmana e tzaj tsma'n inayena. Bix il ti'j tu'n kak'anan ti' taak'en Nmana tuj tyem te ja'lewe, cuma oj tul tyem te koniyan, otktzen pon baj twi' tyem tu'n kak'anan. ");
INSERT INTO mamNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ti'j lux kena ntiina twitz tx'otx', il ti'j chin k'ola spi'yen cye xjal—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tej tkbante Jesús jlu, e cub ttzubanxin twitz tx'otx', bix e cub tbincha'nxin ch'in xook'l tuya ta'l ttzixin, bix oc tsu'nxin xook'l cyi' tbak' twitz mos̈. ");
INSERT INTO mamNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Bix e xi' tkba'nxin te mos̈: —Cutxey txjol twitza tuj jtx'ajbil Siloé tbi, jatzen japeninaj O Tzaj K'o'n—tz̈ixin. Bix e tcuya mos̈, bix el ttxjo'nxin twitzxin tuj tx'ajbil. Bix e bint twitzxin tu'n tcye'yenxin, bix e ponxin tjaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bix e xi' cykba'n ke tvesint-xin bix kej xjal otk cyil jaxin tej tkanenxin pwak: —¿Yaa'mpa ja xjal jlu mos̈ ncub ke twitz tja Dios te kanl pwak?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","At juuntl e xi' cykba'n: —Ja tzunxin. Pero at juuntl e xi' cykba'n: —Min, yaa'n jaxin, sino nuk jun xjal ju' tcye'nc tisenj mos̈—tz̈ikexin. Pero e xi' tkba'n jmos̈ otk k'anj: —Inayen weja. ");
INSERT INTO mamNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ju' tzunj, e xi' cykba'nxin texin: —¿Ti xbina twitza, ti'j lutle ncye'yena?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aj ttzak'be'nxin: —At junxin xjal Jesús tbi. Ja tzunxin xcub binchante ch'in xook'l, bix s-oc tsu'nxin xook'l ti' nwitza, bix s-aj tkba'nxin weya tu'n tel ntxjo'na nwitza tuj tx'ajbil te Siloé. Ẍin pona tuj tx'ajbil, bix s-el ntxjo'na nwitza, bix xcyaj nwitza ba'n—tz̈ixin cye tvesint-xin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bix e xi' cykba'nxin texin: —¿Jaa'tzen ta' jxjal xk'anente tey?—tz̈ikexin. —Mintii' tumel wuyena jaa' ta'—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Entonces, e xi' cyii'nxin ja xjal otk ten mos̈ cywitz fariseo. ");
INSERT INTO mamNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tuj k'ij te ajlabl tej tbinchante Jesús xook'l bix e k'anj xjal mos̈. ");
INSERT INTO mamNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ju' tzunj e xi' cykanen fariseo te mos̈: —¿Ti tten xk'anja, tu'n tcye'yena? ¿Ti xbaj tey?—tz̈ikexin. Bix e xi' tkba'nxin cye fariseo: —S-oc tsu'n Jesús xook'l ti' nwitza, bix s-el ntxjo'na nwitza, bix ncyajtltzen ba'n—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ju' tzunj, e xi' cykba'n juun fariseo cyxolx: —Yaa'n sma'n tu'n Dios ja xjal lu, cuma ma binchanxin xook'l tuj k'ij yaa'n ba'n te ak'untl. Min tniman jley tej k'ij te ajlabl—tz̈ikexin. Pero at juuntl cyxolxin e xi' cykba'nxin: —Yaa'n tumel cyyola. ¿Ti tten ba'n tk'ane jun aj il mos̈?—tz̈ikexin. Bix ju' tzunj e tzaj jun k'oj cyxolxin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Manc'biltzen, e xi' cykanenxin te mos̈: —Tzin tkba'na ma k'anen jxin lu cyi'j twitza. Ju' tzunj, ctzaal tkba'na alcyexin tuj twitza—tz̈ikexin. —Jaxin jun tyolel Dios—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero cycy'i nejenel cye judío tyolxin ka otk tenxin mos̈ bix ka otk k'anjxin. Ju' tzunj, e cytxocxin tmanxin tuya ttxuxin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bix e xi' cykanenxin cye tmanxin: —¿Japa tzunj xjal lu cycwala? ¿Jaxpa mos̈pa tej titz'j? Katzen mos̈xin, ¿titzen tten sul tnaabl twitzxin?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bix aj cytzak'be'n tmanxin cye fariseo: —Jaxte kcwala, bix jaxte mos̈xin tej titz'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero min tz'el kni'ya ti'j ti tten sul tnaabl twitzxin ja'lewe, bix mintii' tumel kuyena alcye xjal s-oc tk'anen ke tbak' twitzxin. Cykanenx texin, cuma ma xjaltlxin. Jaxxin kbalte—tz̈i ke tmanxin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","E yolen ke tmanxin ju'wa cuma at cytz̈i nejenel cye judío cyi'jxin, cuma otk cykba judío ka at jun xjal ma kbante Jscy'o'n tu'n Dios ja Jesús, n-etztzen lejetl tuj camon jaa' te xnak'tzbil tyol Dios, tu'n mi'ntl tz'ocx tentl. ");
INSERT INTO mamNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tu'n cytz̈i cyi'jxin, ju' tzunj e xi' cykba'nxin: “Ma xjaltlxin. Cykanenx texin.” ");
INSERT INTO mamNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tejtzen tel cyniy' fariseo ti'j cycy'i tman mos̈ e yolenke, juntl maj e tzaj cytxco'nxin jxin otk ten mos̈, bix e xi' cykba'nxin texin: —Kbantz ka ma k'anja tu'n Dios, pero yaa'n tu'n Jesús, cuma ktzki'na jun aj il teja—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bix aj ttzak'be'nxin cyexin: —Mintii' woclena tu'n t-xi' nkba'na ka aj ilxin bix ka min. Pero ntzki'na ja lu. Mos̈ kena nejl. Pero ja'lewe, ba'ntl chin cye'yena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pero min el ba'n tyolxin tuj cywitzxin. Ju' tzunj e xi' cykanenxin texin: —¿Ti xtbincha Jesús ti'ja? ¿Ti xbint tu'nxin, tu'ntzen tcye'yena?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aj ttzak'be'nxin cyexin: —Ya ma txi' nkba'na cyey, pero cycy'iy tu'n cyocslantey nyola ti'j Jesús. Ka cycy'iy nyola, ¿tikentzen ntzaa' cykanena weya juntl maj? ¿Cyajpey tu'n cyxi' lpey ti'jxin?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tej cybintexin ja yol lu, e tzaj cyk'ojxin, bix e xi' cykba'nxin texin: —Tey, nxi' lpey ti'jxin, pero keya, nko'x lpeya ti' Moisés. ");
INSERT INTO mamNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ba'n ku'na o cyaj tk'o'n Dios tyol te Moisés. Yal tej xjal lu, mintii' tumel jaa' e tzaa'—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aj ttzak'be'nxin cyexin: —Jey', ¿titzen tten mintii' cynaabla? Ma tzaj tk'o'n Jesús weya tu'n ncye'yena, pero tzinx cykba'na min tz'el cyniy' ti'j jaa' e tzaa'xin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cykilca ko' ktzki'n min tak' te Dios tipemal cyej xjal aj il, sino nk'onxin tipemalxin tej xjal nniman jaxin bix nbinchan tajbilxin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jatxe tej tbint twitz tx'otx', bajx kbi'ya o k'anj jun xjal mos̈ titz'jlen tu'n juntl xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nuket min e tzaj ja xjal lu ti' Dios, mlayettzele k'anen wi'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bix e xi' cykba'nxin texin: —¿Ti tten ntx'olbana keya? Nuk jun aj iltey, cuma ul itz'ja mos̈a. Te ja'lewe, mintii'tl toclena tu'n tocxa tuj tja Dios bix tzalu tuj camon jaa'—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tejtzen tbinte Jesús otk tz'etz cylojo'n fariseo ja mos̈ tuj tja Dios bix tuj camon jaa', e jyonxin ti'j mos̈, bix e xi' tkba'nxin te: —¿Mapa tz'ocslaney ti'j ma tzul jxjal Sma'n tu'n Dios kxol?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Taat, kbantz weya alcyexin, tu'ntzen wocslana ti'jxin—tz̈i mos̈. ");
INSERT INTO mamNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","E xi' tkba'n Jesús te: —Ma tila jaxin. Jaxj xjal nyolen tuyey ja'lecuwe. Inayena—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tej tbintexin jlu, e cub majexin tu'n t-xi' tyeec'anxin tnimbilxin, bix e xi' tkba'nxin: —Taat, chin ocslala ti'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mas yaj ch'intl, e xi' tkba'n Jesús cye xjal: —In tzaja twitz tx'otx' tu'n tcyaj tuj tzinen alcye kej xjal chi cyjel mos̈. Kej xjal ma tz'el cyniy' ti'j ka mos̈ cynaabl, cjketeltzen cynaabl. Pero kej xjal n-el cyniy' ti'j tuj cywitz, cyjeltzen cynaabl mos̈—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Cyxoltzen xjal at cab fariseo. Tej cybinte fariseo tyol Jesús cyi'j mos̈, e xi' cykanenxin texin: —¿Jaxpa ju'x ko'ya, mos̈pa ko'ya tuj twitza?—tẍikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Nuket mos̈key, mintii'tle cyila. Pero tzin cykba'na: “Mintii' il ti'j tu'n tk'oj xnak'tzbil keya, cuma ma tz'el kni'ya ti'j cykilca,” tz̈ikey. Ju' tzunj, chi cyjela tuj cyila—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Bix e xi' tkba'ntl Jesús cye fariseo: —Jaxxix cxe'l nkba'na cyey, ejee'y yaa'n cylel jaxxix cye xjal. C'oquel cyc'u'ja ti'j jun techel. Alcye cylel tcy'i tz'ocx ttzii' cypenwen carnel, sino ju' n-ocx twi' penwen, jatzen xjalja yaa'n jaxxix cylel, sino jun alak'. ");
INSERT INTO mamNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero jcylel n-ocx ttzii' penwen tuj tumel, nyeec'antzen ka jaxxix jun cylel cye carnel. ");
INSERT INTO mamNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Oj npon jcylel jaxxix ttzii' penwen te klax, jxjal nc'ojlan ke carnel te koniyan ttzki'n twitzxin, bix njkon ttzii' penwen, tu'ntzen tocx jxin cylel. Bix cytzki'n carnel twi' cycylel. Bix nchi tzaj ttxco'n cylel teeylex juun carnel alcye cybijil, bix nche'x tii'nxin tuj penwen. ");
INSERT INTO mamNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","N-etz tii'nxin kej carnel at te texin, bix nbet-xin nejl cywitzjil. Bix nchi oc lpejil ti'jxin, cuma cytzki'njil twi'xin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero jun wikxitl xjal, mlay chi oc lpejil ti'j, sino chi elel okjil ti'j, cuma min cytzki'njil twi' junxitl xjal—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Pero tej t-xi' tkba'n Jesús ja techel lu cye fariseo, min el cyniy'xin ti'j ti elpenina. ");
INSERT INTO mamNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ju' tzunj, e xi' tkba'nxin juntl yol cyexin: —Jaxxix cxe'l nkba'na cyey, inayena jjaxxix cylel. ");
INSERT INTO mamNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Cykilca kej xjal ul nejl nwitza te k'umlte jaxxix cylel ejee', alak'ke. Pero min oc cybi'n ncarnela cyyol. ");
INSERT INTO mamNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Junx ttzii' penwen at, bix inayen tzunja junx ttzii' penwen. Alcye ma tz'octz wu'na, cc'ojleteltzen, bix ck'ojel te tu'n tex, tu'n tcnet twa. ");
INSERT INTO mamNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yaltzen te alak', tzul nuk tu'n talk'an, bix te byol, bix tu'n t-xi' cykilca tuj il. Pero weya, in ula tu'n tten cychunk'lal, bix tu'n tnoj cychunk'lal tuyaj ba'n. ");
INSERT INTO mamNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Inayena jcylel ba'n. Jun cylel ba'n ctk'a' tiib tu'n tcyim tu'n cyclet carnel. ");
INSERT INTO mamNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero jxjal yaa'n cylel, bix yaa'n cyaaw carnel, sino nuk jun tmaan cylel, oj tlonte jun xo'j, mi'n tc'ojla ke carnel, sino cyjel tcye'yen ke carnel tu'n tel ok. Bix c'ulel tzul xo'j te tzyul ke carnel, bix chi elel tz̈itjjil. ");
INSERT INTO mamNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cuma mintii' tc'u'j cyi' carnel, n-el ok, cuma nuk jun maan. ");
INSERT INTO mamNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Pero inayena, jcylel ba'n kena. Ntzki'na ke ncarnela, bix cytzki'n ncarnela inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ntzki'na ke ncarnela tisen Nmana ttzki'n inayena, bix cytzki'n ncarnela inayena tisen ntzki'na Nmana. Bix cnk'a' wiiba tu'n ncyima tu'n cyclet ncarnela. ");
INSERT INTO mamNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Bix juuntl carnel ete' cyuj juuntl tnom at tu'n cyoc te ncarnela. Il ti'j tu'n ttzaj wii'na tuj penwen. Oj cytzaj ntxco'na, c'oqueltzen cybi'n nwi'ya, bix chi oquel te junx cyuya ncarnela tzalu, bix junx cycylel chin oquela. ");
INSERT INTO mamNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bix cuma cnk'a' wiiba tu'n ncyima tu'n cyclet carnel, ju' tzunj n-oc wak'a te Nmana. Bix chin cymeela tu'n njaw itz'ja juntl maj. ");
INSERT INTO mamNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Min-al ba'n tel k'inte nchunk'lala. Oj tpon tumel tu'n ncyima, tu'nj weya wajbil chin cymeela. At wipemala tu'n ncyima, bix at wipemala tu'n njaw itz'ja juntl maj. Bix cbinel wu'na cuma ju' taj Nmana—tz̈i Jesús cye fariseo. ");
INSERT INTO mamNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tejtzen cybinte judío kej yol lu, juntl maj e jaw jun k'oj cyxolxin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","At nim xjal e xi' cykba'n: —Ma tz'oc jun biman ti'j, bix njaw tuj twi'xin. ¿Tiken nxi' cybi'na tyolxin?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero juuntl xjal e xi' cykba'n: —Min. Mlay yolen jun xjal tuj tumel ju'wa ka ma jaw tuj twi'. Bix at juntl. Mlay bint tu'n jun xjal tu'n tjket twitz jun mos̈ ka ma tz'oc jun biman ti'j—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yajc'atltzen bix e pon juntl nink'ij, ja tnink'ij nin tja Dios tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Otk pon tyem te ncub che'w. Bix nbet Jesús tuj jtwitz pe'n Salomón tbi. ");
INSERT INTO mamNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tej t-xi' cycye'yen judío e ten Jesús tuj tja Dios, e jaw cychmon cyiibxin ti'jxin, bix e xi' cykba'nxin texin: —¿Jtojtzen tkbay tuj tzinen ka jay jxjal Scy'o'n tu'n Dios?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aj ttzak'be'n Jesús cyexin: —Nim maj e xi' nkba'na cyey, pero cycy'iy tu'n cyocslana ti' nyola ti'j alcye kena. Jax ju'x kej o bint wu'na tuya tipemal Nmana, tzin cykba'n alcye kena. ");
INSERT INTO mamNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero cycy'iy cyocslay wi'ja, cuma yaa'nkey ncarnela. ");
INSERT INTO mamNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","N-oc cybi'n ncarnela nwi'ya, bix ntzki'na ejee', bix nchi oc lpe wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Bix nxi' nk'o'na cychunk'lal te junx maj. Mi'n chi cyaj tuj cyamecy. Bix min-al ba'n cyel k'inte tuj nk'aba. ");
INSERT INTO mamNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","O tzaj tk'o'n Nmana ejee' weya, bix at mas tipemal Nmana cywitz cykilca. Ju' tzunj, min-al ba'n cyel k'inte tuj tk'ab Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Inayena tuya Nmana, junx ko'ya—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tej cybinte judío tyol Jesús ka junx tuya Dios, juntl maj e jaw cyii'nxin xak tu'n toc cyxoo'nxin ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tej tel tniy'xin ti'j e cyajbexin tu'n tcubxin, e xi' tkba'nxin cyexin: —Nim nbinchbena ba'n o bint wu'na cywitza tu'n tipemal Nmana, te yec'bil junx ko'ya tuya Nmana. ¿Alcyetzen nbinchbena tzin tyeec'an min e bint tu'n tipemal Nmana, tu'ntzen toc cyxoo'na xak wi'ja?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aj cytzak'be'n judío texin: —Mlay tz'oc kxoo'na xak ti'ja tu'n tlaj jba'n o bint tu'na. Pero il ti'j tu'n tcyima tu'n tlaj ncub t-xmuccha'na Dios, cuma tzin tkba'na Diostey, amale nuket jun xjaltey—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aj ttzak'be'n Jesús cyexin: —¿Mimpa tzul tuj cyc'u'ja at maj dios cybi xjal tuj tyol Dios? Tzin tkba'n Dios tuj cyleya: “Dioskey.” ");
INSERT INTO mamNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","E tkba Dios ju'wa cye cycawel aj Israel cuma ajbenke tisen t-xel Dios cyxol xjal tu'n cyk'umen tyolxin. Oc tk'o'n Dios cybi te dios, bix ktzki'n mlay tzpet tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ju' tzunj, ka dios kej xjal nuk xjal te twitz tx'otx'ke, ¿tikentzen tzin cykba'na nchin xmucchana Dios oj nxi' nkba'na Tcwal Dios kena? ¿Tikentzen nchi jaw yolena ti'j xjal e tscy'o Dios bix e tzaj tsma'n Dios tzalu twitz tx'otx' tu'n tbint taak'en Dios tu'nxin? ");
INSERT INTO mamNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ka ja ak'untl nbint wu'na mi'n tzin tyeec'an ka sma'n kena tu'n Nmana, ba'ntzen tu'n wel cyxoo'na. ");
INSERT INTO mamNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero ka jnbint wu'na nyeec'an Tcwal Dios kena, amale cycy'iyet nyola, pero tu'nj taak'en Dios nbint wu'na, il ti'j tu'n cyocslana ti'j junx kena tuya Nmana—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ju' tzunj, te juntl maj oc cyipenxin ti'j tu'n tcub cytzyu'n jaxin, pero el lk'exin cyi'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Bix e xi'xin juntl maj jlajxe nima' te Jordán, tu'n tcyajxin tuj lugar jaa' otk tzak'a Juan Bautista tu'n cycu'x xjal tuj a' tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bix nim xjal e pon tuyaxin, bix e xi' cykba'nxin: —Amale mint e bint jun ak'untl te nim tipemal tu'n Juan, te yec'bil tyolel Dios jaxin, pero o tz'el jaxxix cykilcaj e tkbaxin ti'j xjal lu—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bix nim xjal ocslan ti'j Jesús jatzewe ka jaxin jCristo. ");
INSERT INTO mamNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","E yebttzen junxin xjal Lázaro tbi tuj tnom te Betania, nka ti' Jerusalén. Jun tuya Jesús Lázaro, bix cyitz'en Marta bix María jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ja tzunj xuj María, jaxj María otk cub tsu'n c'oc'sbil tibaj tken Cawel kxol, bix otk tz'el tsu'nxuj ti' tken Jesús tuya ttzmal twi'xuj. ");
INSERT INTO mamNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tejtzen tyebt Lázaro, e xi' cysma'n ke ttzicyxin jun sanjel kbalte te Jesús: —Taat, jxjal n-oc tak' tey nim ma yebt, bix ma tz̈'itz̈'exin—tz̈i sanjel. ");
INSERT INTO mamNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tej tbinte Jesús tyol sanjel, e xi' tkba'nxin: —Jt-xi'len ja yabel lu yaa'n tu'n t-xi' tii'n Lázaro tuj cyamecy, sino tu'n tchic'ajax tipemal Dios, tu'ntzen tjaw nimset nbi'ya, inayena Tcwal Dios—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nim oc cyak' Marta bix María bix Lázaro te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ju' tzunj, tej tbintexin ka yaab Lázaro, e tcuyaxin tu'n t-xi'xin cyey'lte. Pero nejl, e cyajxin ca'batl k'ij tuj lugar jaa' e tenaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bix tej tpon tumel tu'n t-xi'xin, e xi' tkba'nxin cye t-xnak'atzxin: —Ko'tzen juntl maj tuj Judea—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bix aj cytzak'be'n t-xnak'atzxin: —Taat Xnak'tzal, ma bint ca'ba oxe k'ij oc cyipen judío jatzewe ti'j tu'n tcub cybyo'n jay tuya xak. ¿Tikentzen taja t-xi'y juntl maj tuj ja tnoma?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Bix aj ttzak'be'nxin cyexin: —Il ti'j tu'n nxi'ya, cuma mina'x tpon baj waak'ena. Cyxol xjal at jun yol tzin tkba'n: “Tuj jun k'ij at cablaaj hora te spi'yen. Ka ma bet jun xjal te k'ij, mlay cub tz'ak, cuma at spi'yen. ");
INSERT INTO mamNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero ka ma bet jun xjal te koniyan, cjawel tz'ak tuj klolj,” tz̈i yol. Jax ju'x weya. Mina'x tpon baj tyem tu'n tbint waak'ena, bix mi'n ko ak'anan tuya ttz̈i ki'j, tisen oj nchi bet xjal tuj klolj—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bix e xi' tkba'ntlxin: —Jkuya Lázaro nwutan. Pero ma chixa tu'n tjaw nc'asena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Taat, ka ma wutanxin, jatzen jun yec'bil ba'n, cuma tzultzen tnaablxin—tz̈ikexin, ");
INSERT INTO mamNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","cuma min el cyniy' t-xnak'atzxin ti'j ka otk yolenxin ti'j tcyamecy Lázaro. Tuj cywitzxin, nyolenxin ti'j najlan Lázaro. ");
INSERT INTO mamNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Cuma min el cyniy'xin ti'j, ju' tzunj e xi' tkba'nxin cyexin tuj tzinen: —Ma cyim Lázaro. ");
INSERT INTO mamNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bix ba'n tuj nwitza min in pona nejl tu'n nco'pana jaxin tuj yabel, cuma mas ba'n te cyey tu'n tcywix cyocslabla wi'ja oj toc cycye'yena jun mas jawnex twitzj tu'n nco'pana jun yaab tuj yabel. Ko'tzen jaa' ta'xin—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pero tu'n ttz̈i cyi'j, cycy'i t-xnak'atzxin tu'n cyxi'. Pero bix e xi' tkba'n Tomás cye niy'tl t-xnak'atz Jesús: —Ka taj Jesús tu'n tcub byet, jax ju'x ke. Ko'tzen, tu'ntzen kcyim tuyaxin—tz̈i Tomás, jxjal Yoẍ tbi cyu'n xjal. Bix e xi'kexin cykilcakexin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tejtzen cyponxin tuj Betania, e tbitzen Jesús cyaja k'ij tcyajlen Lázaro tuj tjayel anem twitz xak. ");
INSERT INTO mamNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Cuma ta' Betania nuk jun ajlabl ti' Jerusalén, ");
INSERT INTO mamNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ju' tzunj e xi' nim xjal judío cyuya Marta bix María, te yec'bil tk'ak'bil cyc'u'jxin cyi'jxuj, cuma otk cyim cyitz'enxuj. ");
INSERT INTO mamNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tejtzen tbinte Marta otk tzul Jesús tuj ttanemxuj, etzxuj tuj tjaxuj te clulte Jesús tuj be. Yal te María, e cyaj tuj cyjaxuj. ");
INSERT INTO mamNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tej tpon Marta tuya Jesús, e xi' tkba'nxuj texin: —Taat, nuket e tena tzalu, minttzele e cyim nxibena. ");
INSERT INTO mamNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero amale mint ula, pero ba'nx wu'na alcyej cxe'l tkanena te Dios, ctzaal tk'o'n Dios tey—tz̈i Marta. ");
INSERT INTO mamNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","E xi' tkba'n Jesús texuj: —Cjawel itz'j t-xibena juntl maj tuj cyamecy—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Bix e xi' tkba'n Marta texin: —Ntzki'na oj tpon tumel tu'n tjaw itz'j cykil xjal tuj manc'bil k'ij, jax cjawel itz'j nxibena tuj cyamecy—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Bix e xi' tkba'nxin texuj: —Inayena k'olte cye xjal tu'n cyjaw itz'j tuj cyamecy, bix inayena k'olte cychunk'lal xjal te junx maj. Ka c'ocslal jun xjal wi'ja, amale ncyimet, pero wu'na cjawel itz'j tuj cyamecy juntl maj. ");
INSERT INTO mamNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Cykilca kej xjal i'tz, ka ma chi ocslan wi'ja, mlay chi cyaj tuj jcyamecy te junx maj. ¿Tocsla'pa te ja lu?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aj ttzak'be'n Marta texin: —Tzin, taat. Ya ma txi' wocsla'na jay jxjal Scy'o'n tu'n Dios te Cawel. Jay Tcwal Dios at tulel twitz tx'otx', bix tu'na chi jawel itz'j xjal tuj cyamecy juntl maj—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tej tbaj tkba'n Marta ja yol lu, e xi'xuj tjaxuj te txcolte titz'enxuj. E xi' tkba'nxuj te María, pero yaa'n cywitz judío: —Ma tzul jjawnex Xnak'tzal tuj tnom, bix taj yolen tuyey—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tej tbinte María ka otk txcon Jesús ti'jxuj, tujxse naj e jaw we'xuj, bix e tzyet tbexuj tu'n tponxuj tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mitkna'x tul Jesús tuj tmij tnom, sino at-xxin ttxa'n tnom jaa' otk pona Marta tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pero mitkx n-exa María tjunal, cuma kej nejenel cye judío ete' tuj tjaxuj tu'n tcywix tc'u'jxuj, tej t-xi' cycye'yenxin otk jaw we' María bix e xi'xuj tuj ajkelbil, bix oc lpekexin ti'jxuj, cuma tuj cywitzxin xi'ninxuj tuj camposant te ook'el. ");
INSERT INTO mamNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pero e xi'xuj tuya Jesús. Tej tpon María tuya Jesús, bix e tilxuj jaxin, bix e cub mutzk'ajxuj t-xee' tkenxin, bix e xi' tkba'nxuj texin: —Taat, nuket e tena tzalu, minttzele e cyim nxibena—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tej tlonte Jesús nchi s̈-in María cyuya nejenel cye judío, e tzajtzen tbisxin, bix e tzaj tk'ojxin ti'j nchi cyim xjal tu'n tlaj il. ");
INSERT INTO mamNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Bix e xi' tkanenxin cye xjal: —¿Jaa' tumel e cu'xa cymaku'na jaxin?—tz̈i Jesús. —Taat, ko'tzen, tu'n t-xi' kyeec'ana tey—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Bix e jaw ok' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ju' tzunj, e xi' cykba'n judío cyxolx: —Nimxsen oc tak' Lázaro texin—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero at juun cyxol e xi' cykba'n: —Jxin lu e xi' tk'anen jun xjal mos̈. ¿Titzen tten min oc tipenxin ti'j tu'n mint e cyim ja tuyaxin lu?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ju' tzunj, juntl maj e tzaj tk'oj Jesús, cuma min oc ke cyc'u'jxin ti'jxin. Tejtzen cyponxin tuj camposant, tocx anem tuj jun jul twitz xak, bix tocx jun xak paatz' ttzii' tjayel anem. ");
INSERT INTO mamNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ju' tzunj, e xi' tkba'n Jesús cye xjal: —Cyimel xak—tz̈ixin. Bix e xi' tkba'n Marta, taneb jxjal otk cyim: —Taat, yaa'n tumel, cuma q'ueletz nim t-xewel anem. Ma bint cyaja k'ij tcyimlenxin—tz̈i Marta. ");
INSERT INTO mamNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Bix e xi' tkba'n Jesús texuj: —¿Tikentzen mintii' n-oc ke tc'u'ja wi'ja? ¿Mimpa txi' nkba'na tey, ka ma tz'ocslana wi'ja, tla'y tipemal Dios?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tejtzen tel cyii'n xjal xak twitz tjayel anem, e jaw tcye'yen Jesús twitz cya'j, bix e xi' tkba'nxin te Dios: —Taat Nmana, nxi' nk'o'na chjonte tey, cuma e tzaj tbi'na nkanbila tej t-xi' nkanena tey wipemala tu'n tjaw witz'jsa'na ja xjal lu. ");
INSERT INTO mamNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Weya, ntzki'na ntzaj tbi'na nyola jaca maj oj nxi' nna'na tey. Pero tzin nk'o'na chjonte tey ja'lewe, tu'ntzen tel cyniy' kej xjal lu ti'j ka jay e tzaj tsma'na inayena twitz tx'otx'—tz̈i Jesús te Tmanxin cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tej tbaj nna'n Jesús Dios, cyiwxix e jaw ts̈i'nxin: —¡Lázaro, ctetza!—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Bix n-etztl jcyimne. Balk'i'n tk'abxin bix tkenxin tuya jun tz̈omj, bix potzen twitzxin. Bix e xi' tkba'n Jesús cye xjal: —Cyco'pamel t-xbalenxin, tu'ntzen tbet-xin—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kej xjal judío otk chi ul tuj camposant tuya María, tej cylontexin ti otk bint tu'n Jesús, e cyocslaxin ka tu'n Dios jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero at juuntl e xi' cyuya fariseo tu'n t-xi' cykba'n cyexin ti otk tbincha Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tejtzen cybinte fariseo tpocbal e jaw titz'jsa'n Jesús jun xjal tuj cyamecy, oc cychmon cyiibxin cyuyaj nejenel cye pala, bix e xi' cykba'nxin: —¿Ti pjel ke? Nimxsen nbint tu'n ja xjal lu tuya nim tipemal. ");
INSERT INTO mamNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ka ma txi' tzakpet-xin tu'n tcub cyi'j xjal tu'nxin, cykilcatzen xjal chi ocslal ti'jxin, bix c'oquelxin te cawel. Bix ctzaal tk'oj gobierno te Roma ki'j, bix q'uelel tii'n kcawbil tuj tja Dios bix kxol ejoo' judío—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Attzen junxin pala cyxol, Caifás tbi, jxjal mas nintzaj cyxol pala tej tcub byet Jesús, bix e xi' tkba'nxin: —¿Tikentzen min tz'el cyni'ya ti'j alcye tu'n tbint ku'n ti'j ja xjal lu? ");
INSERT INTO mamNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Mimpa tz'el cyni'ya ti'j ka mas ba'n te cyey tu'n tcyim jun xjal te cyxel cykilca xjal, twitzj tu'n cyxi' xjal tuj il?—tz̈i Caifás. ");
INSERT INTO mamNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Min el tniy' tneel pala ti'j ka k'i'n tyol Dios tu'nxin, pero cuma tneel oylxte chojbil ilxin, ajbenxin te Dios tu'n tkbantexin alcyej wik chojbil cyil xjal at tu'n toyet tujx jnabk'i, jaj tu'n tcyim Jesús te cyxel judío, ");
INSERT INTO mamNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","bix yaa'n nuk te cyxel judío, sino te cyxel cykilca xjal te twitz tx'otx', tu'ntzen cyoc te junx tnom cykilca kej xjal cyuj juntl tnom cyaj tu'n cyoc te tcwal Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tej t-xi' tkba'n Caifás ju'wa, tex k'ij oc cyk'on cyiib nejenel cye judío tu'n tcub cybyo'n ja Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ju' tzunj, mintl e bet Jesús cyxol nejenel cye judío, sino el lk'exin cyi'j. E ponxin tuj jun tnom Efraín tbi, nka ti'j tx'otx' mintii' cynajbil xjal tuj. Tuj Efraín e tenxin cyuya t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tejtzen ch'itk tul nink'ij te Pascua, kej k'ij xjan cye judío, etz nim xjal cyuj tnom tu'n cyponxin tuj Jerusalén, te k'olte chojbil cyilxin, tu'n cycyajxin sak nejl twitz nink'ij, tisenx cye judío cycostumbre. ");
INSERT INTO mamNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bix tuj Jerusalén e jyonkexin ti' Jesús. Bix tej cychmonte cyiibxin tuj nintzaj tja Dios, e xi' cykanenxin cyxolxxin: —¿Titzen toc cyu'na? ¿Tzulpale Jesús tuj nink'ij tuj ja jnabk'i lu?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","E yolenkexin ju'wa cuma otk tz'etz jun yol cyu'n fariseo bix kej nejenel cye pala, ka ma tbi jun xjal jaa' ta' Jesús, ya tu'n tpon naj cywitzxin te kbalte jaa' tumel, tu'ntzen tcub cytzyu'nxin jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cuma ch'itk tpon nink'ij te Pascua, ju' tzunj e tzyet tbe Jesús tu'n tponxin tuj Jerusalén. At-x wukak k'ij tu'n ttzyet nink'ij tej tponxin tuj Betania, jtnom jaa' najle Lázaro, jxjal otk jaw titz'jsa'nxin tuj cyamecy. ");
INSERT INTO mamNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bix tu'n cyk'onte aj tnom chjonte te Jesús, iy' cyiy'sa'nxin jun tnink'ijxin. Bix oc ten Marta cyxol kej xjal ajbel cye xjal nchi waa'n. Bix at Lázaro cyxol kej xjal k'uklc'a ttxa'n mes tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Yal te María, tu'n t-xi' tyeec'an María tanem texin, e tzaj tii'nxuj jun lmet nojne tuya c'oc'sbil cyi' xjal nardo tbi, wi'yelxsen, bix yaa'n smo'n tuya a'. Bix e cub tko'nxuj c'oc'sbil ti' tkenxin, bix e baj tsu'nxuj tuya ttzmal twi'xuj. Bix e noj jaa' tuya tc'o'cjel. ");
INSERT INTO mamNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bix tocxsen Judas Iscariote tunwen, jun t-xnak'atz Jesús, tcwal Simón. Bix jatzen Judas tu'n t-xi' q'ueyente Jesús tuj cyk'ab byol xjal. E tkbatzen Judas: ");
INSERT INTO mamNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Tikentzen min xi' q'ueyet ja c'oc'sbil lu? Nuket xi' q'ueyet, matle tz'oc twi' te oxe syent pwak te denario, bixetle xi' cyej xjal mebe—tz̈i Judas. ");
INSERT INTO mamNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero mintii' tanemxin cye mebe. E xi' tkba'nxin ju'wa cuma alak'xin. Ajbenxin te c'ojlal jcajon te pwak te Jesús cyuya ke t-xnak'atzxin, bix at maj el tii'nxin cyoybil xjal e cu'x cyk'o'n tuj tcublel pwak. ");
INSERT INTO mamNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Bix e xi' tkba'n Jesús te Judas: —Mi'n tz'oc tena yaa'l xuuj. Yaa'n nuk tajx ma cyaj tclo'nxuj jc'oc'sbil tu'n tcub tko'nxuj cyibaj nkena. Jma bint weya najben tu'n tbaj bint nxumlala tu'n nmaketa. ");
INSERT INTO mamNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ka taja txi' tyeec'ana tanema cye mebe, attzen mebe cyxola cykil k'ij. Pero weya, nuk ch'intl chin temela cyxola—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yal cyej txkentl xjal judío otk chi chmet te iy'sal nink'ij, tej cybinte e ten Jesús tuj Betania, e tzajkexin te cyey'lte Jesús, bix yaa'n nuk tu'n toc cycye'yen ja Jesús, sino jax jux' tu'n toc cycye'yen ja Lázaro, cuma otk jaw itz'j tuj cyamecy tu'n Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pero yal kej nejenel cye pala, e tzaj cychmon cyiibxin tu'n tbaj cyninc'u'nxin ti tten tu'n tcub byet yaa'n nuk ja Jesús, sino tuyax Lázaro, ");
INSERT INTO mamNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","cuma tu'n tlaj e jaw itz'j Lázaro tuj cyamecy, nim xjal judío el lk'e tjak' cycawbil pala tu'n cyocslan ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yal te nink'ij te Pascua, nimxsen xjal otk chi pon tuj Jerusalén te iy'sal nink'ij. Tetzen juntl k'ij toclen tk'on María c'oc'sbil ti' Jesús, e pon tpocbal tu'n t-xi' Jesús tuj Jerusalén. Tejtzen cybinte tnimal xjal tu'n t-xi' Jesús, ");
INSERT INTO mamNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","el cytx'omen tk'ab xa'j, bix etzkexin tuj Jerusalén te clulte texin. Bix ak'kexin s̈-il: —¡Jawnexsen Cawel kxol! ¡Cy'iwla'nxit jxjal tzul te t-xel Dios! ¡Ma tzul jmero Cawel kxol ejoo' aj Israel!—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yal te Jesús tuj Betania, e tzaj ttzyu'nxin jun tal bur, bix e jaxxin tibajjil. Ju' tzunj jax e'la jyol tuj tyol Dios tzin tkba'n: ");
INSERT INTO mamNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mi'n tzaj ttz̈i cyi'ja, key xjal te Jerusalén, cuma tzul Cycawela tjax tibaj jun tal bur,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yal ke t-xnak'atz Jesús, min el cyniy'xin ti'j nyolen kej yol lu ti'j Jesús. Pero mas yaj, tej taj k'i'nxin tuj cya'j, ul tuj cyc'u'jxin ti otk baj, bix el cyniy'xin ti'j otk tz'el tyol Dios jax. ");
INSERT INTO mamNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kej xjal otk ten tuyaxin tej tetz ttxco'nxin Lázaro tuj mukbil bix e jaw titz'jsa'nxin tuj cyamecy juntl maj, otk txi' cyk'umen cye xjal tuj Jerusalén ti otk bint tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ti'j tzunj tpocbal tipemalxin otk tz'etz tnimal xjal tuj Jerusalén te clulte texin. ");
INSERT INTO mamNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bix cuma e jaw cynimsa'n xjal tbi Jesús, ju' tzunj e xi' cykba'n fariseo cyxolx: —Mintii' tz'ajben jma baj kninc'u'n ti'j Jesús, tu'n tul cyii'n xjal jaxin kwitz. Cycye'yenc. Cykil xjal ma che'x lpe ti'jxin—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Cyxoltzen xjal e pon tuj Jerusalén te nimal Dios tuj nink'ij, attzen cab xjal griego. ");
INSERT INTO mamNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","E pon lk'e kej griego lu ti' Felipe, jxjal aj Betsaida tuj departamento te Galilea. Bix e xi' cykba'nxin te Felipe: —Taat, kaja tu'n kyolena tuya Jesús—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ju' tzunj, e xi' Felipe tu'n t-xi' tkba'n te Andrés, bix e xi'kexin kbalte te Jesús ti cyaj kej xjal griego. ");
INSERT INTO mamNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Bix e xi' tkba'n Jesús cyexin: —Ma pon tumel tu'n tbint wu'na jk'o'n weya tu'n tbint wu'na, inayena, jxjal Sma'n tu'n Dios tu'n ntena cyuya xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cxe'l nkba'na jun techel cyey. Jaxxix cxe'l nkba'na cyey, jun iyaj te triwa, ka min ma cu'x maku'n tuj tx'otx' tu'n tcyim, ju'x cwel ten iyaj tjunal. Mlay jatz pok'ch. Pero ka ma cyim, nim twitz c'oquel. Jaxse ju'x weya, il ti'j tu'n ncyima, tu'ntzen t-xi' nk'o'na cychunk'lal xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jax ju'x cye xjal. Al tzunj xjal min ma cyaj tcye'yen tchunk'lal, sino nuk o'cx ma tz'oc tc'u'j tu'n tten tchunk'lal te twitz tx'otx', mlay caman tchunk'lal te junx maj tzin nk'o'na. Pero ja tzunj xjal cyjel tcye'yen tchunk'lal te jun rato, ccamaltzen tchunk'lal te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ka taj jun xjal tz'ajben weya bix yaa'n nuk tz'oc tc'u'j ti'j tchunk'lal, iltzen ti'j tu'n tiy'x q'uixc'aj tu'n wi'ja, ojxe tcyim ka at il ti'j, tisenxj ma wak' wiiba tu'n ncyima. Kej xjal chi ajbel weya ju'wa, chi temeltzen jaa' chin xe'la, bix cxe'l tk'o'n Nmana tu'n cyoc te jawnex. ");
INSERT INTO mamNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Pero weya, ma pon tumel tu'n ncyima. Bix yaa'n tuj ttz̈yal ta' wanema. ¿Ti cxe'l nkba'na? ¿Cxe'lpa nkba'na: “Taat Nmana, najsama. Chin tcla'y, tu'ntzen mi'n pon hora tu'n ncyima,” ntz̈ipaya? Pero mlay txi' nkanena jlu, cuma in ula tu'n ncyima. ");
INSERT INTO mamNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taat, bint-xit jtajbila wu'na, tu'ntzen tjaw nimset tbiy—tz̈i Jesús. Bixsen e tzaj tyol Dios tuj cya'j, bix tz̈i cyjulu: —Tu'nj ma bint tu'na, ya ma jaw nimset nbi'ya. Bix juntl maj ctzaal nk'o'na tu'n tajbena tu'n tjaw nimset nbi'ya—tz̈i twi' Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kej tnimal xjal e ten ti'j Jesús, tej cybinte tk'ajk'ajel, e xi' cykba'n otk k'ajt jun k'ancyok. Pero at juuntl e xi' cykba'n otk yolen jun ángel tuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tu'n tel cyniy' xjal ti'j, e xi' tkba'n Jesús: —Ja yol e tzaj tuj cya'j najben te jun techel, yaa'n te weya, sino te cyey, tu'ntzen cyocslana wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ma pon tumel tu'n ncyima, bix tu'nj ncyamecya, cyjel tuj tzinen alcye c'oquel te cawel tibaj twitz tx'otx'. Ma pon tumel tu'n tetz lojo'n taaw il ncawen ja'lewe. ");
INSERT INTO mamNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bix weya, ojtzen njaw k'o'na tibaj twitz tx'otx', jatzen tumelja te cykil xjal tu'n cyclet tjak' tcawbil taaw il—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","E yolenxin ti'j tu'n tjawxin tibaj twitz tx'otx' tu'ntzen tel cyniy' xjal ti'j at tu'n tjawxin twitz jun cruz tu'n tcyimxin. ");
INSERT INTO mamNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bix e xi' cykba'n xjal texin: —O kbi'ya tzin tkba'n tley Dios, oj tul jxjal Scy'o'n tu'n Dios, cyjeltzen te junx maj. Mi'n cyim. Pero tzin tkba'na: “Il ti'j tu'n tcyim jxjal Sma'n tu'n Dios twitz cruz,” tz̈iy. Jey', ¿alcye tzuna? ¿Titzen tten cymeela twitz cruz oj tzin tkba'n tyol Dios mlay cyim Jscy'o'n tu'n Dios?—tz̈i ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Bix aj ttzak'be'nxin cyexin: —Cycy'iy tz'el cyni'ya ti'j. Cycy'iy nxnak'tzbila. Pero nuk ch'intl ctemel nxnak'tzbila cyxola. Mi'n chin cyaja tzalu. Ju' tzunj, c'oquel cyipena ti'j tu'n tajben nxnak'tzbila cyey jooc'tzen at-x, tu'ntzen mi'n chi beta tuj klolj. Kej xjal nchi bet tuj klolj, chi tzpeteltzen. ");
INSERT INTO mamNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ma pon tumel tu'n waja. Chi ocslana wi'ja loj lux kena ntiina, tu'ntzen cyoca junx wuyena—tz̈ixin cye xjal. Tej tbaj tkba'nxin kej yol lu, el lk'exin cyi'jxin, tu'n tewente tiibxin cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Amale otket tyeec'axin nimxsen tipemalxin cye xjal judío, pero min ocslanke ti'jxin ka jaxin Cristo. ");
INSERT INTO mamNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ju' tzunj, jax e'la tyol Isaías, jtyolel Dios te ootxa. Tz̈i Isaías cyjulu: “Kman Kaaw, min e cyajbe ke xjal tey tyol tej t-xi' kk'umena, bix min ocslanke tej t-xi' cycye'yen tipemala,” tz̈i Isaías. ");
INSERT INTO mamNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bix cuma el cyiiq'uen xjal tyol Cawel kxol, ju' tzunj e xi' tkba'ntl Isaías: ");
INSERT INTO mamNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“O cyaj tk'o'n Kaaw ejee' tu'n tcub mutz'ba'n cynaabl, bix tu'n mi'ntl tz'ajben cyanem tu'n cyiik'ente tyola. Ju' tzunj, mlay tz'el cyniy' xjal ti'j, tu'ntzen mi'n cyaj cyk'o'n cyil, tu'ntzen cyclet,” tz̈i Isaías. ");
INSERT INTO mamNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tej tyolen Isaías ju'wa, e yolenxin ti'j Scy'o'n tu'n Dios, cuma otk tilxin tej tjaw tii'n Dios ja Isaías tuj cya'j jun maj. Bix jax e yolen Isaías jun maj ti'j Jscy'o'n tu'n Dios tu'n tiy'x nim q'uixc'aj tu'n twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Amale el ch'ixc'at yaa'n cykilca nejenel cye xjal el cyxoo'n Jscy'o'n tu'n Dios, pero at nim cyxol ocslan ti'jxin ka jaxin Cristo. Pero at cytz̈i fariseo cyi'jxin, bix cycy'ixin tu'n cyetz lojo'nxin cyxol xjal judío. Ju' tzunj min e cykbaxin cywitz xjal ka lepcheckexin ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mas e cyajbexin tu'n cyelxin ba'n cywitz xjal twitzj tu'n cyelxin ba'n twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jyol e tk'ume Jesús cye xjal tej tten twitz tx'otx', ju'tzen cyjulu: “Alcyej xjal cxe'l tocsla'n ti'j nyola, yaa'n o'cx wi'ja n-ocslan, sino jax n-ocslan ti'j tyol Nmana e tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bix oj n-el tniy' jun xjal wi'ja, jax n-el tniy' ti Nmana e tzaj tsma'n inayena, cuma junx ko'ya. ");
INSERT INTO mamNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ma chin ula twitz tx'otx' tisen spi'yen. Kej xjal ma chi ocslan wi'ja, mi'n chi cyaj tuj klolj. ");
INSERT INTO mamNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kej xjal ma chi ebinte nyola pero min cyocsla, cwel cycastiwa, pero yaa'n wu'na cwel castiwa cyibaj, cuma min in ula twitz tx'otx tu'n t-xi' nk'o'na cycastiwa xjal, sino tu'n t-xi' nk'o'na cycolbil xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","At juntl ctkba' at cyil xjal. Kej xjal q'uelel cyiiq'uen inayena bix cycy'i nyola, tuj manc'bil k'ij j-e xi' nkba'na c'ajbel tu'n tcyaj tuj tzinen at cyil. ");
INSERT INTO mamNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","C'ajbel nyola ju'wa, cuma yaa'n wexwe nyol tzin nkba'na, sino tyol Nmana e tzaj tsma'n inayena. Ma tzaj tkba'n Nmana weya alcye tu'n t-xi' nkba'na. ");
INSERT INTO mamNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bix ja yol ma tzaj tkba'n Nmana weya, jaj tu'n t-xi' nk'o'na cychunk'lal xjal. Ju' tzunj, nxi' nk'umena cye xjal nuk o'cx tisenj ma tzaj tkba'n Nmana weya,” tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tetzen tneel k'ij te Pascua, e cub ke Jesús cyuya t-xnak'atzxin te koniyan te waa'l. El tniy'xin ti'j otk pon tumel tu'n tcyimxin bix tu'n tiy'xin twitz tx'otx' tu'n tponxin tuya Tmanxin. Tuya cykil tc'u'jxin otk tz'oc cyak' kej xjal lepchec ti'jxin texin. Kej xjal lepchec ti'jxin tu'n cycyaj cyxol xjal twitz tx'otx', bix ya otk pon tumel tu'n tyeec'anxin te junx maj tk'ak'bil tc'u'jxin cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bix otk cu'x tk'o'n taaw il tuj tanem Judas Iscariote, tcwal Simón, jun tajbil tu'n tq'ueyen Judas ja Jesús tuj cyk'ab kej xjal e cyajbe tu'n tcubxin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Bix el tniy'xin ti'j otk tzaj tk'o'n Tmanxin tipemalxin tibaj cykilca at, bix otk tzajxin tuya Dios bix at tu'n tpon meltz'ajxin tuya Dios juntl maj. ");
INSERT INTO mamNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pero amale elet tniy'xin ti'j at cykilca tuj tk'abxin, pero e jaw we'xin tej nchi waa'nxin, bix el tii'nxin t-xbalenxin, bix oc tẍpo'nxin jun toalla tcy'itzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bix e cu'x tko'nxin a' tuj jun jo's̈, bix ak'xin txjol cyken t-xnak'atzxin. Bix el tsu'nxin cykenxin tuyaj toalla otk tz'oc tẍpo'nxin tcy'itzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tej tponxin twitz Simón Pedro, e xi' tkba'n Pedro texin: —Taat, ¿wepaya nkena q'uelel ttxjo'na? Yaa'n tumel—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Bix aj ttzak'be'nxin: —Ja'lewe min tz'el tni'ya ti'j tiken nchin txjona cykena. Pero tuj juntl rato q'uelel tni'ya ti'j ja techel lu—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bix e xi' tkba'n Pedro texin: —Te junx maj cxe'l nkba'na tey, mlayx tz'el ttxjo'na nkena—tz̈i Pedro. —Ka min ma tz'el ntxjo'na tkena, mintzentii' tmunela weya—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ju' tzunj, e xi' tkba'n Pedro: —Taat, ka ju' tten, waja tu'n tel ttxjo'na yaa'n nuk nkena, sino jax ke nk'aba tuyax nwi'ya—tz̈i Simón Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","E xi' tkba'n Jesús te Pedro: —Jun xjal, ka ma txjon tiib, mintii'tzen il ti'j tu'n ttxjon tiib juntl maj. Nuk o'cx tu'n ttxjet tken. Q'uelel ntxjo'na nuk cykena, cuma sak cyxumlala. Pero at jun cyxola yaa'n sak—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ttzki'nxin alcyej t-xnak'atzxin tu'n t-xi' k'onte texin tuj cyk'ab byol xjal. Ju' tzunj otk txi' tkba'nxin: “At jun cyxola yaa'n sak.” ");
INSERT INTO mamNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tejtzen tbaj txjet cyken t-xnak'atzxin tu'nxin, oc tk'o'nxin t-xbalenxin, bix e cub kexin ti' mes. Bix e xi' tkba'nxin cye t-xnak'atzxin: —¿Mapa tz'el cyni'ya ti'j ti elpenina jma bint wu'na cyi'ja? ");
INSERT INTO mamNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tzin cykba'na inayena Xnak'tzal cyey bix Cawel cyxola, bix jax cyu'na, cuma ju' ttena. ");
INSERT INTO mamNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Katzen ma tz'el ntxjo'na cykena, amale Cawelet kena cyxola bix Cyxnak'tzala kena, ju' tzunj il ti'j tu'n cyajbena cyxolxa ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ma txi' nyeec'ana cyey jun yec'bil ti tten tu'n cyajbena cye juntl, tu'ntzen tbint cyu'na tisenx ma bint wu'na. ");
INSERT INTO mamNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jaxxix cxe'l nkba'na cyey, yaa'n ejee'y mas jawnex nwitza, cuma jun ak'anal yaa'n mas jawnex twitz tpatrón, bix jxjal ma tzaj sma'n yaa'n mas jawnex twitzj xjal e tzaj smante jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pero ma tz'el ntxjo'na cykena te jun techel ti tten tu'n cyajbena cye juntl. Ka ju' chi ajbela cye juntl, attzen cytzalajebla. ");
INSERT INTO mamNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pero yaa'n cykilcakey chi temela tuj cytzalajebla. Tej tjaw nscy'o'na ejee'y tu'n cyoca te nxela, el nni'ya ti'j at jun yaa'n tu'n tel ba'n. Pero tocx ja xjal lu cyxola tu'ntzen tel jax tyol Dios. Tzin tkba'n tyol Dios cyjulu: “Cyxol kej xjal chi waa'l wuyena, at jun cjawel tken tu'n toc t-xjo'n inayena,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","At jun cyxola cbinchal jun ka' wi'ja. Bix tzin nkba'na jlu cyey te mitkna'x tbint, tu'ntzen mi'n baj cyc'u'ja wi'ja oj tbint tu'nxin ju'wa, sino c'oquel ke cyc'u'ja wi'ja Jscy'o'n tu'n Dios inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jaxxix cxe'l nkba'na cyey, chi oquela te nxela, bix alcye c'oquel tbi'n cyyola oj t-xi' nsma'na ejee'y, jax n-oc tbi'n weya. Bix alcye c'ocslal wi'ja, jax n-ocslan ti'j Nmana e tzaj tsma'n inayena—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tej tbaj tkba'nxin kej yol lu, e tzaj jun nintzaj bisbajil ti'jxin, bix e xi' tkba'nxin tuj tzinen: —Jaxxix cxe'l nkba'na cyey, at jun cyxola cxe'l tq'ueyen inayena tuj cyk'ab kej xjal cyaj tu'n ncuba—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tej t-xi' tkba'n Jesús at jun t-xnak'atzxin tu'n tq'ueyen jaxin, nimxsen e jaw sey'pajkexin, bix ak'kexin cyey'lte tuj cywitzxin. Mintey' tumel cyuyaxin alcyej tocx cyxolxin e yolen Jesús ti'j. ");
INSERT INTO mamNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Toctzen ttxlaj Jesús jun t-xnak'atzxin nim oc tak' texin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Bix oc tch'iquen Simón Pedro ti'j jxin toc ttxlaj Jesús, te yec'bil e tajbe tu'n tyolen tuya, bix e xi' tkanen Pedro te: —¿Mapa tbiy alcyej nyolen Jesús ti'j? Kbantz keya—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ju' tzunj, jt-xnak'atz Jesús toc ttxlajxin e xi' tkanen texin: —Taat, ¿alcyetzen? ");
INSERT INTO mamNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Alcye tzunj cxe'l nk'o'na pan te, oj tcu'x nmu'na. Ja tzunja—tz̈i Jesús. Bix e cu'x tmu'nxin jun piẍ pan, bix e xi' tk'o'nxin te Judas, tcwal Simón Iscariote. ");
INSERT INTO mamNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pero tej t-xi' toyenxin te Judas, bi'x oc Judas tuj tk'ab taaw il. Bix e xi' tkba'n Jesús te: —J-at tu'n tbint tu'na, bincham tuj ajkelbil—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero cyxol kej niy'tl t-xnak'atzxin k'ukl ti' mes, min-al el cyniy' ti'j tiken e xi' tkba'nxin kej yol lu te Judas Iscariote. ");
INSERT INTO mamNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Cuma ajben Judas te c'ojlal cypwak Jesús, ju' tzunj tuj cywitz juun t-xnak'atzxin e tajbexin tu'n t-xi' Judas te lok'ol jwaabj te nink'ij, bix ka tu'n t-xi' tk'o'n Judas jun onbil cyej xjal mebe. ");
INSERT INTO mamNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tejtzen t-xi' ttzyu'n Judas jpan otk txi' tk'o'n Jesús, n-etztl Judas. Bix otk cub klolj. ");
INSERT INTO mamNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tej tetz, e xi' tkba'n Jesús cye t-xnak'atzxin: —Ya ma pon tumel tu'n tbint wu'na jma tzaj k'o'n weya tu'n tbint, bix tu'n tjaw nimset tbi Nmana tu'nj cbinel wu'na, inayena, jxjal Sma'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bix ka ma jaw nnimsa'na tbi Dios tu'nj at tu'n tbint wu'na, jax ctzaal tyeec'an Dios tnimbil weya. Bix ch'ixc'a tpon tumel tu'n tjaw nimset nbi'ya tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Key wuya nim n-oc cyak'a weya, cxe'l ntx'olba'na cyey tuj tzinen ti japenina nyola. Nuk ch'intl chin temela cyuyey. Bix cyaja tu'n cyxi'y wuyena, pero mlay che'xa wuyena. Tisen e xi' nkba'na cye nejenel cye judío, jax cxe'l nkba'na cyey ja'lewe, mlay che'xa jaa' chin xe'la. ");
INSERT INTO mamNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Cxe'l nk'o'na cyey jun ac'aj ley. C'oquel cyak' cyiiba cyey. Tisen ma tz'oc cyak'a weya, ju'x cyii'nx tu'n toc cyak' cyiiba cyey. ");
INSERT INTO mamNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ka ma tz'oc cyak' cyiiba cyey ju'wa, tu'n tzunj jlu q'uelel cyniy' cykil xjal ti'j ka nxnak'atzkey—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","E xi' tkba'ntzen Simón Pedro texin: —Taat, ¿jaa'tzen cxe'ley?—tz̈i Pedro. —Mlay tz'oc lpey wi'ja ja'lewe jaa' chin xe'la. Pero la' alcye jun k'ij c'oquel lpey wi'ja—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","E xi' tkba'n Pedro texin: —Taat, waja tu'n woc lpeya ti'ja ja'lewe. Ka at il ti'j, chin cymeela tu'n woc lpeya ti'ja—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aj ttzak'be'n Jesús te Pedro: —¿Jaxpa tu'na ccymela tu'n toc lpeya wi'ja? Jaxxix cxe'l nkba'na tey, te mitkna'x kskix, oj took' jun coo', tu'n ttz̈i ti'ja otktzen tkbay oxe maj min ttzki'na nwitza—tz̈ixin te Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tu'n tcywix cyc'u'j t-xnak'atz Jesús, e xi' tkba'nxin cyexin: —Nim nchi bisena ti'j ti pjel, pero mi'n tzaj ttz̈i cyi'ja. C'oquel ke cyc'u'ja ti' Dios bix jax ju'x wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tuj tnajbil Nmana at nim lugar te cyey. Nuket mintii', matle txi' nkba'na cyey. Pero tneelxix, il ti'j tu'n nneja jkolte najbil cywitza. ");
INSERT INTO mamNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bix ka ma chin aja jkolte cynajbila, jax chin ul meltz'aja juntl maj, bix cxe'l nchmo'na ejee'y, cuma waja tu'n cytena junx wuyena. ");
INSERT INTO mamNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yal tzunj be ctzyetel wu'na, n-el cyni'ya ti'j alcyej be—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","E xi' tkba'n Tomás texin: —Taat, min ktzki'na jaa' cxe'ley. ¿Titzen tten q'uelel kni'ya ti'j alcyej be ctzyetel tu'na?—tz̈i Tomás. ");
INSERT INTO mamNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aj ttzak'be'nxin: —Inayen weja jbe. Inayen weja jjaxxix. Inayenja k'ol cychunk'lala te junx maj. Nuk wu'na at cyoclena tu'n cypona tuya Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nuket el cyni'ya ti'j alcye kena bix alcyej il ti'j tu'n tbint wu'na, jaxettzenle ma tz'el cyni'ya ti'j Nmana bix ti tajxin. Pero te ja'lewe q'uelel cyni'ya ti'jxin, bix q'uelel cyni'ya ti'j ya ma cyila jaxin—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","E xi' tkba'n Felipe texin: —Taat, yeec'antz Tmana keya, tu'n toc kcye'yena. Oj toc kcye'yena jaxin, mintii'tl kaja—tz̈i Felipe. ");
INSERT INTO mamNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","E xi' tkba'n Jesús te Felipe: —Nim k'ij ma chin tena cyuyey, Felipe. ¿Mimpana'x tel tni'ya ti'j alcye kena? Ka ma tz'oc cycye'yena inayena, jax ma tz'oc cycye'yena Nmana, cuma inayen weja jyec'bil ti tten Nmana. ¿Tikentzen ntzaj tkanena weya: “Yeec'antz Tmana keya”? tz̈iy. ");
INSERT INTO mamNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mimpa tocslay ka junx kena tuya Nmana bix junx ta' Nmana wuyena? Kej yol nxi' nkba'na te cyey nxnak'atza, yaa'n wexwe nyol, sino tyol Nmana at wuyena. Bix jnbint wu'na, yaa'n tu'n wexwe wipemal, sino tu'n tipemal Nmana—tz̈i Jesús te Felipe. ");
INSERT INTO mamNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bix e xi' tkba'ntlxin cye t-xnak'atzxin: —Cyocslama nyola ka junx kena tuya Nmana bix junx ta' Nmana wuyena. Pero ka cycy'iy tu'n cyocslana wi'ja tu'nj nyola, chi ocslana wi'ja tu'n wipemala ma txi' nyeec'ana cyey. ");
INSERT INTO mamNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jaxxix cxe'l nkba'na cyey, ka ma tz'oc ke cyc'u'ja wi'ja, j-ak'untl ma bint wu'na tuya tipemal Nmana, jax cbinel cyu'na. Bix jun ak'untl mas jawnex mina'x tbint wu'na cbinel cyu'na, cuma weya, chin aala tuya Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bix oj waja, alcyej cxe'l cykanena te Nmana, ka junx cykanbila tuya wajbila, cbinel wu'na, cuma waja tu'n tjaw nimset tbi Nmana tu'nj nbint wu'na, inayena Tcwal. ");
INSERT INTO mamNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jax wu'na. Alcyej cxe'l cykanena, ka junx cykanbila tuya wajbila, cbinel wu'na. ");
INSERT INTO mamNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ka ma tz'oc wak'a cyey, chi nimala nyola. ");
INSERT INTO mamNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Bixsen cxe'l nkanena te Nmana tu'n ttzaj tsma'nxin juntl Onlte cyey. Ctzaal tsma'nxin, bix ctemel cyuyey te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ja Espíritu Santo ja tzunja Onlte cyey, bix cxe'l t-xnak'tza'n alcyej jaxxix cyey. Pero kej xjal te twitz tx'otx', mlay k'oj Espíritu Santo cye, cuma cycy'i jaxin, bix n-el cyiiq'uen jaxin. Pero cyey, cytzki'na jaxin, cuma at-xin cyuyey. Bix mas yaj ctemelxin tuj cyanema. ");
INSERT INTO mamNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi'n chi cyaja cyjunala. Jax ju'x weya, chin ultla cyuyey. ");
INSERT INTO mamNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nuk ch'intl chin temela twitz tx'otx', bix mlay chin oc cycye'yentl xjal te twitz tx'otx'. Pero cyey, chin oquel cycye'yena juntl maj oj njaw itz'ja tuj cyamecy. Bix cuma chin jawel itz'ja juntl maj, jax ju'x cyey, chi jawel itz'ja juntl maj. ");
INSERT INTO mamNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bix oj njaw itz'ja tuj cyamecy, q'uelel cyni'ya ti'j ka junx kena tuya Nmana, bix junx kena cyuyey, bix junx ete'y wuyena. ");
INSERT INTO mamNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ka ma tz'oc cybi'na nyola, n-octzen wak'a cyey. Bix ka ma tz'oc wak'a cyey, c'oqueltzen cyak'a te Nmana. Bix jax ju'x weya, c'oquel cyak'a weya, bix chin temela cyuyey tu'nj Espíritu Santo—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Bix e xi' tkanen Judas texin, yaa'n Judas Iscariote: —Taat, ¿ti ma baj? Ka at tu'n tco'pana ktanem, ¿tikentzen ctzaal tyeec'an tiiba nuk kwitza, bix yaa'n cywitz cykil xjal?—tz̈i Judas. ");
INSERT INTO mamNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aj ttzak'be'n Jesús: —Mintii' nmojbabla cyuyaj xjal cycy'i tu'n toc cybi'n nyola. Alcye kej xjal ma tz'oc wak'a cye, n-octzen cybi'n nyola. Bix c'oquel cyak' te Nmana, bix junx tuya Nmana ko temela cyuyaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pero alcye kej xjal min tz'oc wak'a cye, jax mi'n tz'oc cybi'n nyola, bix mi'n chin tena cyuya. Kej yol lu ma txi' nkba'na cyey, yaa'n wexwe nyola, sino tyol Nmana e tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tej ntena tzalu cyxola, nim nxnak'tzbila ma cyaj nk'o'na cyuyey. ");
INSERT INTO mamNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bix oj tul J-onlte cyey, cxe'l ttx'olba'n cykilca te cyey, tu'ntzen tcyaj tuj tzinen jma txi' nxnak'tza'na cyey. Ctzaal tsma'n Nmana Espíritu Santo te nxela, bix tu'n tzul cykilca nyola tuj cyc'u'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Cxe'l nk'o'na cyey tu'n tten cyanema tuj ttz̈yal. Cyxol xjal te twitz tx'otx', n-oc cyipen ti'j tu'n cyten tuj txubtx, pero mintii' jaa' tu'n toc ke cyc'u'j. Pero weya, tuya wipemala nxi' nk'o'na cyey tu'n cycyaja tuj txubtx. Ju' tzunj, mi'n baj cyc'u'ja. Mi'n tzaj ttz̈i ti pjel cyi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jatxe may' xi' nkba'na cyey: “Chin xe'la, bix chin ul meltz'aja,” ntz̈iya. Nuket oc wak'a cyey tuya cykil cyc'u'ja, matle chi jaw tzalaja tej xi' nkba'na chin xe'la tuya Nmana, cuma te weya, jun nin xtalbil tu'n ntena tuya Nmana, cuma mas jawnex Nmana nwitza. ");
INSERT INTO mamNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ma txi' nkba'na cyey te mitkna'x tbaj ti pjel wi'ja, tu'ntzen tcywix cyocslabla wi'ja oj tbaj. ");
INSERT INTO mamNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yaa'n nimtlxix chin yolela cyuyey, cuma ch'ix tpon tumel tu'n tul taaw il, jxjal ncawen tibaj twitz tx'otx' ja'lewe. Taj tu'n tpon baj nk'ija, pero mintii' tipemal wibaja. ");
INSERT INTO mamNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero amale minttii' tipemal taaw twitz tx'otx' wibaja, pero chin oquela tjak' jctbincha wi'ja, tu'n nnimana tyol Nmana, tu'ntzen tel cyniy' cykil xjal ti'j n-oc tak' Nmana weya. Chi we'wetzen cyey. Ko'tzen tzalu—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Tej cyetz Jesús, e xi' tkba'ntlxin cye t-xnak'atzxin: —Cxe'l nkba'na jun techel cyey. Inayena tisen jun jaxxix tken lo'pj te uva. Bix Nmana taaw tken uva. ");
INSERT INTO mamNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bix ejee'y tisen kej tk'ab toc wi'ja. Kej tk'ab uva toc wi'ja, ka min ma cyak' twitz, q'ueleltzen ttx'oman Nmana wi'ja. Pero kej tk'ab at twitz, q'uelel tii'n Nmana ttzkijil cyi'j, tu'ntzen toc mas twitz. ");
INSERT INTO mamNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ejee'y tisen kej tk'ab ba'n, cuma ma chi cyaja sak tu'nj yol ma txi' nkba'na cyey. ");
INSERT INTO mamNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cyk'o'nc cyipena ti'j tu'n cytena junx wuyena, tu'ntzen ntena junx cyuyey. Jun tk'ab lo'pj, ka yaa'n toc ti' tken, mlay tak' twitz. Bix jax ju'x cyey, mintii' ba'n cbinel cyu'na ka min ma chi cyaja junx wuyena. ");
INSERT INTO mamNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Inayen weja tken uva. Cyey, tk'ab uvakey. Ka junx chi temela wuyena, tu'ntzen junx ntena cyuyey, nim cbinel cyu'na. Pero ka ma chi e'lkey wi'ja, mintii' cbinel cyu'na. ");
INSERT INTO mamNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Alcyej xjal yaa'n toc wi'ja, ju'tzen ctemela tisen jun tk'ab lo'pj ka min tak' twitz. Nuk q'uelex xe't tk'ab, bix ctzki'l. Bix c'ajbel nuk tu'n tocx cyk'o'n xjal tuj k'ak', tu'ntzen tbaj tz'ey'. ");
INSERT INTO mamNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ka junxkey wuyena, bix ka ma cyaj nyola tuj cyanema, alcyej ma txi' cykanena te Nmana, ctzaal tk'o'nxin cyey. ");
INSERT INTO mamNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Oj t-xi' cyyeec'ana ka nche'x lpey wi'ja tu'nj nim cbinel cyu'na, cjaweltzen nimset tbi Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tisen ma tz'oc wak'a te Nmana, ju'xse weya, ma tz'oc cyak'a weya. Ju' tzunj, mi'n chi e'lkey ti'j tk'ak'bil nc'u'ja cyi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ka ma cybiy nyola, ju'tzen chi yeec'ala n-oc wak'a cyey, tisenx ma txi' nyeec'ana n-oc tak' Nmana weya tu'nj e nbiya tyol. ");
INSERT INTO mamNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ka ma tz'oc cybi'na kej yol lu ma txi' nkba'na cyey, chi tzalajela tisen weya nchin tzalaj. Waja tu'n tten jun cytzalajebla jawnex. ");
INSERT INTO mamNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Cxe'l nk'o'na juntl yol cyey. C'oquel cyak' cyuyey cyey, tisen ma tz'oc cyak'a weya. ");
INSERT INTO mamNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mlay txi' tyeec'an jun xjal jun tk'ak'bil tc'u'j mas jawnex twitzj tu'n t-xi' tk'on tiib tu'n tcyim, tu'n tclet jun tuya tu'n. ");
INSERT INTO mamNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Cyey, wuyakey ka ma cybiy nyola. ");
INSERT INTO mamNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi'n tz'oc nk'o'ntla cybiy nuk ak'anal, cuma min tz'el tniy' jun ak'anal ti'j ti niy' tuj tc'u'j tpatrón. C'oquel nk'o'ntla cybiy wuyena, cuma cykilca ma tzaj tkba'n Nmana weya, ma txi' nkba'na cyey, tu'ntzen tel cyni'ya ti'j ti niy' tuj tc'u'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yaa'n ejee'y e kbante tu'n cyak'anana junx wuyena, sino inayena e jaw scy'onte cyey, bix ma txi' nk'o'na cyaak'ena, jaj tu'n cyxi'y kbalte cye xjal tu'n cyocslan wi'ja. Jaj ak'untl lu tisen jun awal mlay cub baj. Bix cuma ma txi' nk'o'na ja cyaak'ena lu, ju' tzunj alcyej cxe'l cykanena te Nmana, ctzaal tk'o'nxin cyey. ");
INSERT INTO mamNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Juntl maj cxe'l nkba'na cyey, tu'n cybintey nyola, c'oquel cyak' cyiiba cyey. ");
INSERT INTO mamNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kej xjal ete' tjak' tcawbil taaw twitz tx'otx', q'uelel cyiiq'uen ejee'y. Bix oj cyel cyiiq'uen ejee'y, q'uelel cyni'ya ti'j o tz'el cyiiq'uen inayena nejl cywitza. ");
INSERT INTO mamNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nuket junx cynaabla tuyaj cynaabl xjal te twitz tx'otx', n-oqueltzele cyak'a cye, cuma junxseke cyuyey. Pero yaa'n junx cynaabla tuya cynaabl xjal te twitz tx'otx'. Ma jaw nscy'o'nkey tu'n tel cypa'n cyiiba cyi'j. Ju' tzunj, q'uelel cyiiq'uen ejee'y. ");
INSERT INTO mamNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","C'oquel cyc'u'ja ti'j jun yol xi' nkba'na cyey nejl. Yaa'n jun ak'anal mas jawnex twitzj tpatrón. Ju' tzunj, ka ma chi k'ojl xjal wi'ja, jax chi k'ojlel cyi'ja. Pero jax at juun o cybi nyola. Jax ju'x cyey, at juun c'oquel cybi'n cyyola. ");
INSERT INTO mamNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kej xjal cycy'i jweya nyol, chi yajlal cyi'ja nuk tu'n tlaj lepcheckey wi'ja. Bix cycy'i inayena cuma cycy'i Dios e tzaj tsma'n inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kej xjal te twitz tx'otx', nuket min in tzaja tu'n t-xi' nxnak'tza'na alcye kena, minttzenle el cyxoo'n inayena. Pero in tzaja, bix ju' tzunj mlaytl txi' cykba'n min tz'el cyniy' ti'j, cuma o tz'oc cybi'n nyola, bix cycy'i. ");
INSERT INTO mamNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Alcyej ma tz'el tiiq'uen inayena, jax n-el tiiq'uen Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nuket min in tzaja cyxol xjal te twitz tx'otx' bix e xi' nyeec'ana wipemala, minttzenle e xi' cyxoo'n nyec'bila. Min-al juntl o binchan jma bint wu'na cyxol. Pero amale e xi't cycye'yen nbinchbena, pero cycy'i inayena. Tejtzen t-xi' cycye'yen inayena, jax ju'x e xi' cycye'yen Nmana. Ju' tzunj, tej tel cyiiq'uen inayena, jax el cyiiq'uen Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Amale e cyilet wipemala, pero el cyxoo'n inayena. Ju'tzen ma tz'el jax jun yol tz'i'ben tuj ley te Dios e k'oj cye. Tz̈i cyjulu: “Amale c'oquelet cycye'yen wipemala, pero q'uelel cyiiq'uen inayena,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Cxe'l nsma'na Onlte cyey. At tuya Nmana. Ja Espíritu Santo, bix ju' ctzaal tuya Nmana. Jtaak'en tu'n tchic'ajax alcyej jaxxix. Oj tul, c'ak'analtzen tuj cyanem xjal tu'n tcyaj tuj tzinen alcye kena. ");
INSERT INTO mamNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jax ju'x cyey, chi k'umela cye xjal wi'ja, cuma o chi tena wuyena jatxe tej wak'a ak'anal—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Bix e xi' tkba'ntl Jesús cye t-xnak'atzxin: —Ma txi' nkba'na cyey q'uelel cyiiq'uen xjal ejee'y bix ma txi' nkba'na cyey tzul Espíritu Santo te onlte cyey, tu'ntzen mi'n cyaj cyk'o'na cyocslabla wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Q'ueletz cylojo'n xjal ejee'y cyuj camon jaa' te xnak'tzbil ti' tyol Dios. Jax wu'na, tzul jun k'ij cwel cybyo'n xjal ejee'y cuma tuj cywitz nchi onen ti' Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Cbinel cyu'n ju'wa cuma cycy'i tz'el cyniy' ti'j Nmana bix wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ma txi' nkba'na cykilcaj lu cyey, tu'ntzen tul nyola tuj cyc'u'ja oj tpon k'ij tu'n cyk'ojl xjal cyi'ja. Min e xi' nkba'na jtumel lu cyey nejl, cuma mitkna'x tpon k'ij tu'n waja. ");
INSERT INTO mamNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero ja'le chin xe'la tuya Dios e tzaj tsma'n inayena. Pero jey', min-al jun cyey ma tzaj tkanena weya: “¿Jaa' ma txa'y?” ");
INSERT INTO mamNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Min nchi bisena wi'ja, sino nuk nchi bisena ma noj tuj cyanema tuya bisbajil tu'nj nyola cyey. ");
INSERT INTO mamNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero jaxxix cxe'l nkba'na cyey, mas ba'n te cyey tu'n nxi'ya. Ka min ma chin aja, mlaytzen tzul Onel cyuyey. Pero ka ma chixa, ctzaaltzen nsma'na cyuyey. ");
INSERT INTO mamNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bix oj tul, cxe'l tyeec'an cye xjal te twitz tx'otx' at cyil, bix ti tten tu'n t-xi' cyii'n cychunk'lal jiquen twitz Dios, bix cwel cycastiwa ka min ma chi oc jiquen twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","At cyil, cuma min ma chi ocslan wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bix cuma chin pomela tuya Nmana, ya mi'n cyitla inayena. Pero c'ak'analtzen Onlte cyey te nxela tu'n t-xi' tyeec'an cye xjal ti tten tu'n t-xi' cyii'n cychunk'lal jiquen twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bix cuma o tkba Dios at tu'n tcub tcastiwa taaw twitz tx'otx', ju' tzunj cxe'l tyeec'an Espíritu Santo cye xjal jax cwel cycastiwa cykilca aj il. ");
INSERT INTO mamNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","At nimtl waja tu'n t-xi' nkba'na cyey, pero mlay chi camana tu'n tel cyni'ya ti'j ja'lewe. ");
INSERT INTO mamNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero n-el tniy' Espíritu Santo ti'j cykilca jaxxix, bix oj tul, cxe'ltzen tonen ejee'y, tu'ntzen tel cyni'ya ti'j jaxxix yol. Yaa'n tex tyol cxe'l tkba'n, sino cxe'l tk'o'n jyol ma tzaj tkba'n Nmana te. Bix cxe'l tyeec'an cyey ti pjel mas yaj. ");
INSERT INTO mamNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Cjawel tnimsa'n nbi'ya, cuma weya nyol cxe'l ttx'olba'n cyey, tu'n tcyaj tuj tzinen cykilcaj ma txi' nkba'na cyey. ");
INSERT INTO mamNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Junx nnaabla tuya tnaabl Nmana. Ju' tzunj, tumel tu'n t-xi' nkba'na cyey cxe'l ttx'olba'n Espíritu Santo ti elpenina jma txi' nkba'na cyey, cuma junx ta' nyola tuya tyol Nmana. ");
INSERT INTO mamNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nuk ch'intl chin temela cyuyey, bix mlay cyitla inayena. Pero tuj juntl rato c'oquel cycye'yena inayena juntl maj—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yal kej t-xnak'atzxin, cuma min el cyniy'xin ti'j tyolxin, ju' tzunj at juun e xi' cykanenxin cyxolxxin: —Yaa'n telniy' kej yol lu ma tzaj tkba'n taat ke. ¿Tikentzen tzin tkba'naxin ju'wa: “Nuk ch'intl chin temela cyuyey, bix mlay cyitla inayena. Pero tuj juntl rato c'oquel cycye'yena inayena juntl maj,” tz̈ixin? ¿Bix tiken tzin tkba'naxin ju'wa: “Chin pomela tuya Nmana,” tz̈ixin? ");
INSERT INTO mamNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ti japenina ja yol “nuk ch'intl chin temela cyuyey”? ¿Ti tten tu'n tel kniy' ti'j tyolxin?—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Eltzen tniy' Jesús ti'j e cyajbe t-xnak'atzxin tu'n t-xi' cykanenxin texin tu'n tcyaj tyolxin mas tuj tzinen. Ju' tzunj, e xi' tkba'nxin cyexin: —¿Tikentzen nchi kanena cyxola ti japenina nyola tej xi' nkba'na cyey: “Nuk ch'intl chin temela cyuyey, bix mlay cyitla inayena. Pero tuj juntl rato c'oquel cycye'yena inayena juntl maj”? ");
INSERT INTO mamNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jaxxix cxe'l nkba'na cyey, tuj jun rato chi jawel ook'a tu'n ncyamecya, bix chi tzalajel kej xjal te twitz tx'otx'. Cnool cyanema tuya nim bisbajil, pero c'oquel cybisa te tzalajebl. ");
INSERT INTO mamNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jbisbajil tzul cyi'ja tisen tchyonel tal jun xuuj. Oj tpon tumel tu'n talenxuj, nbisenxuj, cuma nim q'uixc'aj q'uiyel tu'nxuj. Pero oj titz'j talxuj, mi'ntl tzul tuj tc'u'jxuj iy'x q'uixc'aj tu'nxuj, cuma ctzalajelxuj ti'j ma tz'itz'j talxuj twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jax ju'x cyey, il ti'j tu'n tiy'x q'uixc'aj cyu'na ja'lewe. Pero chi wila'ya juntl maj, bix cnool cyanema tuya tzalajebl, bix min-al q'uelel tii'n cytzalajebla tuj cyanema. ");
INSERT INTO mamNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tuj tzunj k'ij te cytzalajebla, q'uelel cyni'ya ti'j, bix mlay cykanetla weya ti japenina nyola. Jaxxix cxe'l nkba'na cyey, alcyej cxe'l cykanena te Nmana, ctzaal tk'o'nxin cyey, ka junx ta' cykanbila tuyaj wajbila. ");
INSERT INTO mamNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nejl, min ma txi' cykanena texin tuya jun cynaabla junx ta' tuya wajbila. Cykanenx, tu'ntzen tk'ontexin cykanbila, tu'n tnoj cyanema tuya tzalajebl. ");
INSERT INTO mamNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kej yol ma txi' nkba'na cyey, e'wen ch'in ta'. Pero tzul jun k'ij oj t-xi' nkba'na cyey tujxix tzinen ti tten Nmana, bix q'uelel cyni'ya ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tuj tzunj k'ij oj tel cyni'ya ti'j Nmana, cxe'l cykanena wajbila te Nmana. Bix ctk'a'xin cykanbila, yaa'n nuk cuma cxe'l nkanena texin te cyxela, ");
INSERT INTO mamNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","sino cuma jax texin at tk'ak'bil tc'u'j cyi'ja. N-oc cyak'a texin cuma ma tz'oc wak'a cyey, bix ma chi ocslana ti'j nyola ka tuya Dios in tzaja. ");
INSERT INTO mamNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","In tzaja tuya Nmana, bix in ula twitz tx'otx'. Pero ya cyjel nk'o'na twitz tx'otx', bix chin aala tu'n npona tuya Nmana juntl maj—tz̈i Jesús cyexin. ");
INSERT INTO mamNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","E xi' cykba'n t-xnak'atzxin texin: —Jey', ja'lewe nyolena tuj tzinen bix yaa'n tuj ewjel. ");
INSERT INTO mamNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bix ktzki'na at cykil tumel tuyey. N-el tni'ya ti'j ti niy' tuj cyc'u'j xjal, tu'ntzen mintii' il ti'j tu'n t-xi' tkanena ti cyaj tu'n tel cyniy' ti'j. Ju' tzunj, nxi' kocsla'na ma tzaja tuya Dios—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","E xi' tkba'n Jesús cyexin: —¿Jaxpa cyu'na nchi ocslana wi'ja? ");
INSERT INTO mamNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Jey', ch'ixc'a tpon hora tu'n tcyaj cycye'yena inayena. Chi elel tz̈itja. Teeylex juun cyey cxe'l tii'n tbe. Pero yaa'n njunala chin cyjela, cuma at Nmana wuyena. ");
INSERT INTO mamNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kej yol lu ma txi' nkba'na cyey tu'n cyocslana wi'ja, tu'ntzen cytena tuj ttz̈yal. Twitz tx'otx' c'oquel nim pena cyi'ja, pero mi'n baj cyc'u'ja, cuma inayena chin camal tibaj twitz tx'otx'—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tejtzen tbaj tkba'n Jesús cye t-xnak'atzxin, e jaw tcye'yen twitz cya'j, bix e xi' tkba'nxin te Tmanxin: —Taat, ma pon hora tu'n ncyima, inayena, Tcwala. K'ontz weya tu'n tbint ncyamecya wu'na, tu'ntzen tjaw nimset tbiy tu'nj ncyamecya. ");
INSERT INTO mamNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Chin tonentza tu'n ncyima, cuma tuj ncwenta ma tzaj tk'o'na cykil xjal. Te weya ma tzaj tk'o'na j-ak'untl tu'n t-xi' nk'o'na cye xjal cychunk'lal te junx maj, bix nuk wu'na chi cletel kej xjal ma tzaj tk'o'na weya tu'n t-xi' nk'o'na cychunk'lal. ");
INSERT INTO mamNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","At cychunk'lal xjal te junx maj nuk tu'nj cyocslabl ti'j o'cx jay jaxxix Dios bix wi'ja, inayena Jesucristo, jxjal ma tzaj tsma'na cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma bint wu'na j-ak'untl e tzaj tk'o'na weya tu'n tbint twitz tx'otx', bix tu'nj jlu, ma jaw nnimsa'na tbiy. ");
INSERT INTO mamNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bix cuma ma bint waak'ena twitz tx'otx', ju' tzunj k'ontz weya tu'n woca te jawnex juntl maj, tisenx tej ntena tuj tneel tuyey tej mitkna'x tbint twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yal kej xin nxnak'atza etz tscy'o'na cyxol xjal tuj twitz tx'otx', ma txi' nyeec'ana cyexin ti tten tnaabla. T-xjalke xina, bix e tzaj tk'o'na ejee' weya, bix ma chi ocslan ti' tyola. ");
INSERT INTO mamNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma tz'el cyniy'xin ti'j kej yol ma txi' nkba'na bix jwipemala ma txi' nyeec'ana tuyey e tzaa'. ");
INSERT INTO mamNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ma txi' nkba'na cyexin nuk jyol e tzaj tk'o'na weya, bix ma txi' cyocsla'nxin, bix ma tz'el cyniy'xin ti'j tuyey in tzaa'ya, bix jax tey e tzaj tsma'na inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Chin cubsal nwitza tey nuk cyi'j nxnak'atza ma chi jaw tscy'o'na, cuma tey t-xjalke xina. Yaa'n cyi'j xjal te twitz tx'otx' chin cubsal nwitza tey ja'lewe. ");
INSERT INTO mamNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tey t-xjalke xina, cuma cykilcaj xjal at te weya, jax at te tey. Jax cykilcaj xjal at te tey, attzen te weya. Bix cyu'nj nchi ocslan wi'ja, ma jaw nimset nbi'ya. ");
INSERT INTO mamNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Taat, ma pon tumel tu'n tcyaj nk'o'na twitz tx'otx', tu'n npona tuyey. Pero kej nxnak'atza, chi cyjel tzalu twitz tx'otx'. O chi tzaj tk'o'n xina weya. K'ontz tc'ojlabla cyexin, tu'ntzen junx ctemel cynaablxin, tisenx junx ko'. ");
INSERT INTO mamNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tej nbeta tzalu twitz tx'otx' cyuyaj nxnak'atza e tzaj tk'o'na weya, e xi' nxnak'tza'na cyexin tu'n cyoc lpexin ti' tyola. Min-al cyexin ma txi' tuj il. Nuk jaj xjal at tu'n t-xi' tuj castiwa ma tz'oc tuj tk'ab il, tu'ntzen tel jax tyol Dios te ootxa. ");
INSERT INTO mamNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pero ya ma pon tumel tu'n npona tuyey. Pero jooc'tzen nchin tena twitz tx'otx', nchin cubsana nwitza tey cyi'jxin. K'ontz cyexin tu'n tnoj cyanemxin tuya jun jawnex cytzalajeblxin, tisen at ntzalajebla. ");
INSERT INTO mamNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma txi' nk'o'na tyola cyexin. Ju' tzunj q'uelel cyiiq'uen kej xjal te twitz tx'otx' ejee'xin, cuma yaa'n junx cynaablxin tuyaj cynaabl xjal te twitz tx'otx', tisen weya yaa'n junx nnaabla tuyaj cynaabl xjal te twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Min chin cubsana nwitza tey tu'n tetz tii'na ejee'xin cyxol kej xjal q'uelel cyiiq'uen ejee'xin, sino tu'n tc'ojlana ejee'xin tu'n mi'n chi cub tz'akxin tuj tk'ab taaw il. ");
INSERT INTO mamNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yaa'n junx cynaablxin tuyaj cynaabl xjal te twitz tx'otx', tisenx weya yaa'n junx nnaabla tuyaj cynaabl xjal te twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pa'melkexin te tey, tu'n cyajbenxin tu'n cyk'umenxin jaxxix tyola, cuma nuk tey tyola jaxxix. ");
INSERT INTO mamNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tisenj tej ttzaj tsma'na inayena twitz tx'otx' tu'n nk'umena tyola, ju'x xsunj cxe'l nsma'na ejee'xin cyxol cykilca xjal tu'n cyk'umen jyol jaxxix. ");
INSERT INTO mamNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma txi' nk'on wiiba tu'n tbint tajbila wu'na, te jun techel cyexin ti tten tu'n cyajbenxin tuya cykil cyc'u'jxin tuj taak'ena. ");
INSERT INTO mamNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Taat, yaa'n nuk cyi'j nxnak'atza cxe'l ncubsa'na nwitza tey, sino cyuyaj cykilca kej xjal chi ocslal wi'ja oj t-xi' cyk'umenxin npocbala. ");
INSERT INTO mamNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nxi' ncubsa'na nwitza tey tu'n cyoc te junx cykilca kej xjal chi ocslal wi'ja. Taat Nmana, tisenx junx ta'y wuyena bix junx kena tuyey, chi ocxit junx cykilca ocslal tu'nj chi oc junx kuya, cuma oj toc cycye'yen kej xjal yaa'n ocslal ka junxke, q'ueleltzen jax tuj cywitz ma tzaj tsma'na inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tisenx ma tzaj tk'o'na tnaabla weya, jax ma txi' nk'o'na tnaabla cye, tu'ntzen junx ten cynaabl, tisenx junx ko'. ");
INSERT INTO mamNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ma txi' nk'o'na cye tu'n junx ctemel nnaabla cyuya, tisenx junx ko', tu'ntzen junx ten cynaabl tuya jun cymojbabl cyiib tz'aklxix, tu'ntzen tel cyniy' xjal yaa'n ocslal ti'j e tzaj tsma'na inayena, bix ti'j ma tz'oc cyak' tey tisenx n-oc wak'a tey. ");
INSERT INTO mamNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Taat, kej ocslal wi'ja ctzaal tk'o'na weya, waja tu'n cyten wuyena jaa' chin pomela, tu'ntzen t-xi' cycye'yen jjawnex wipemala ma tzaj tk'o'na. Cxe'l ncubsa'na nwitza tey ju'wa, cuma ma tz'oc wak'a tey jatxe tej mitkna'x tbint twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taat, jiquentey te junx maj. Min cytzki'n kej xjal te twitz tx'otx' ti tten tnaabla. Pero weya, n-el nni'ya ti'ja. Bix kej xjal lepchecke wi'ja ma tz'el cyniy' ti'j e tzaj tsma'na inayena. ");
INSERT INTO mamNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma txi' nyeec'ana cyexin ti tten tnaabla, bix cxe'l nyeec'antla, cuma waja tu'n toc cyak' cyuya cye tisenj n-oc wak'a tey. Bix waja tu'n woca junx cyuya—tz̈i Jesús te Tmanxin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tejtzen tbaj na'n Jesús Dios, etzxin tuj Jerusalén tuya t-xnak'atzxin, bix e ponkexin jlajxe jnima' Cedrón tbi. Bix ocxkexin tuj jun awal te lo'pj. ");
INSERT INTO mamNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yaltzen te Judas, otk txi' te q'ueylte Jesús. Ttzki'nxin jaa' e tena Jesús, cuma nim maj otk tz'oc cychmon cyiib Jesús cyuya t-xnak'atz tuj awal lu tu'n cywutanxin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ju' tzunj, te tzunj koniyan e pon Judas tuj awal cyuya nimxsen soldado te Roma bix cyuyaj c'ojlal tja Dios otk txi' cysma'n kej nejenel cye pala bix kej xjal fariseo. E xi' cyii'nxin lampara bix tzaj bix cymacbilxin te k'oj. ");
INSERT INTO mamNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Eltzen tniy' Jesús ti'j otk pon tumel tu'n tbint tcyamecyxin tu'nxin. Ju' tzunj, e pon lk'exin cywitz soldado, bix e xi' tkba'nxin cyexin: —¿Al tzin cyjyo'na?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Nko jyona Jesús, aj Nazaret—tz̈ikexin. Bix e xi' tkba'nxin cyexin: —Inayena jxjal nchi jyona ti'j—tz̈ixin. Bix at Judas, jq'ueyl texin, cywitz c'ojlal tja Dios bix soldado. ");
INSERT INTO mamNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tejtzen t-xi' tkba'n Jesús “inayena” cye soldado, el lk'ekexin bi'x e pjiy' tz'akkexin twitz tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ju' tzunj e xi' tkanen Jesús juntl maj cyexin: —¿Al tzin cyjyo'na?—tz̈ixin. —Nko jyona Jesús, aj Nazaret—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Bix aj ttzak'be'n Jesús: —Ma txi' nkba'na cyey ka inayena jxjal nchi jyona ti'j. Katzen inayena, cytzakpinxna ke nxnak'atza tu'n cyex libre—tz̈ixin, ");
INSERT INTO mamNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","tu'ntzen tjapan baj jyol otk txi' tkba'nxin te Dios: “Min-al nxnak'atza e tzaj tk'o'na tuj nk'aba ma txi' tuj il.” ");
INSERT INTO mamNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yaltzen te Simón Pedro, k'i'n jun machet tu'nxin tcu'x tuj tjayel. Tej tlontexin tu'n ttzyet Jesús, e jatz tii'nxin tmachet-xin, bix e xi' tjubacxin tmachet-xin ti' twi' jxin Malco, bix el jun tẍquinxin te tmank'abxin. T-xel jxin pala mas jawnex ja Malco. ");
INSERT INTO mamNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pero e xi' tkba'n Jesús te Pedro: —K'onc'ax tmacheta tuj tjayel. Ja q'uixc'aj ma tzaj tk'o'n Nmana weya tu'n tiy'x wu'na, q'uiyex wu'na—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Bix e xi' tzyet Jesús tu'n capitán bix ke soldado bix kej judío c'ojlal tja Dios, bix oc cyẍpo'nxin tk'abxin tzalti'jxexin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bix e xi' cyii'nxin jaxin tuj tja Anás. E ponkexin tuya Anás nejl, cuma at nim tipemal tyol Anás tibaj jtneel pala, cuma tjii'xin tneel pala. ");
INSERT INTO mamNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás jaj xin tneel pala otk txi' tkba'n cye judío ka mas ba'n tu'n tcyim jun xjal te cyxel cykil xjal. ");
INSERT INTO mamNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Tejtzen t-xi' cyii'n soldado ja Jesús, e xi' lpe Simón Pedro ti' Jesús, pero nakch ch'in. Bix at juntl t-xnak'atz Jesús e xi' lpe ti' Jesús. Ttzki'n Caifás twitz t-xnak'atz Jesús, bix ju' tzunj e tcuyaxin tu'n tocx ja t-xnak'atz Jesús lu tuj tjaxin tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero min ocx Pedro tunwen. Nuk e cyaj ten ti'jxe tlemel jaa'. Ju' tzunj, jt-xnak'atz Jesús otk tz'oc tunwen cuma ttzki'n tneel pala twitz, etz tuj jaa' tu'n tkanen tej txin c'ojlal ttzii' jaa' tu'n tocx Pedro tunwen, bix e tcuyatxin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Bix e xi' tkanen jtxin c'ojlal ttzii' jaa' te Pedro: —¿Yaa'mpatey juntl cyxol t-xnak'atz ja xjal at tunwen?—tz̈itxin. —Yaa'n t-xnak'atzxin kenwa—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Attzen che'w, bix otk cub cyk'o'n t-ak'anal taaw jaa' bix ke c'ojlal tja Dios jun k'ak'. Wa'leckexin ti' k'ak' nchi mek'en cyiibxin. Tuyax Pedro ocx cyxolxin te mek'l tiibxin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yal te Anás, e xi' tkanen te Jesús cyi'j t-xnak'atz bix ti'j t-xnak'tzbil. ");
INSERT INTO mamNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Bix aj ttzak'be'n Jesús: —Cywitz cykil xjal ma txi' nkba'na. Cyuj camon jaa' ma txi' nk'o'na nxnak'tzbila, bix ma txi' nk'umena tyol Dios tuj nintzaj tja Dios, jaa' n-oca cychmon cyiib cykil judío. Mintii' ma txi' nkba'na tuj ewjel. ");
INSERT INTO mamNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tikentzen ntzaj tkanena weya? At nim tstiwa ma cybi nyola. Kanenx cyexin, tixix tten tuj cyleya. Ba'n cyu'n alcyej ma txi' nk'umena cye xjal—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tejtzen t-xi' tkba'nxin jlu, oc tloka jun c'ojlal tja Dios twitzxin, bix e xi' tkba'nxin texin: —Mi'n tz'oc t-xmuccha'na jawnex pala—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aj ttzak'be'n Jesús te c'ojlal: —Ka min ma chin yolena tuj tumel, kbantz weya ti tten ma chin tzpeta. Pero ka tuj tumel nyola, ¿tikentzen n-oc tloka nwitza?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mix e caman Anás ti' Jesús. Ju' tzunj e xi' tsma'nxin ja Jesús tuya Caifás, tneel pala. Ẍpo'nx Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jatzen Simón Pedro, luxxin wa'lecx ti' k'ak' tu'n tmek't-xin. Bix e xi' cykba'n niy'tl xjal toc ti' k'ak' texin: —¿Jaanpatey lepchec ti' ja xjal lu?—tz̈ikexin. Pero tcy'i Pedro jcyyolxin ju'wa, bix e xi' tkba'nxin: —Yaa'n jaan kenwa—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Attzen cyxol xjal junxin t-ak'anal tneel pala, titz'en jxin xjal otk tz'el ttx'oman Pedro tẍquin. E xi' tkba'n tzunxin te Pedro: —¿Yaa'mpa ja tey xwila t-xol tken awal tuya Jesús?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pero juntl maj e cubx tewen Pedro tu'n min e tk'umexin. Tzinxix xi'c'a tkba'nxin ju'wa tej took' coo'. ");
INSERT INTO mamNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tejtzen tbaj tkanen Caifás te Jesús, e xi' cyii'n judío ja Jesús twitz pe'n te tja gobernador. Mitkna'x tul k'ij. Tej cypon judío tja gobernador aj Roma, min ocxke tunwen, cuma tuj cyley ka' tu'n tocx jun xjal judío tuj tja jun xjal yaa'n judío. Eltzen cyniy' k'ilte Jesús ti'j ka ma chi ocx tuj tja jun xjal yaa'n judío, otktzen chucj, bix mlaytltzen txi' cywaa'n jwaabj te Pascua. ");
INSERT INTO mamNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ju' tzunj, etz Pilato, ja gobernador, tuj tja, bix e xi' tkanenxin cye judío: —¿Alcye til ja xjal lu tuj cywitza?—tz̈i gobernador. ");
INSERT INTO mamNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aj cytzak'be'nxin texin: —Nuket yaa'n binchal ka' jxjal lu, mintle ma tzul kii'na twitza tu'n tcub tk'o'na tcastiwaxin—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","E xi' tkba'n Pilato cyexin: —Ka cycy'iy tu'n ttzaj cykba'na weya tuj tzinen alcyej tilxin, cyii'nxa, bix cyk'onx tcastiwaxin tisenj tzin tkba'n tuj cyexa cyleya—tz̈i gobernador cye judío. Aj cytzak'be'nxin texin: —Jxin lu, il ti'j tu'n tcyim. Pero judío ko'ya, bix yaa'n k'o'n keya tu'n ley te Roma tu'n tcub kbyo'na jun binchal ka'—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tejtzen t-xi' cykba'n judío e cyajbe tu'n tcub cybyo'n kej aj Roma ja Jesús, el jax tyol Jesús otk txi' tkba'n nejl, jaj tcyimlel twitz cruz. ");
INSERT INTO mamNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Cuma e cyajbe judío tu'n tbyet Jesús tu'n gobierno te Roma, ju' tzunj ocx Pilato tuj tja bix e xi' ttxco'nxin Jesús tu'n tpon twitzxin. Bix e xi' tkanenxin: —¿Jaxpa cyu'n kej xjal lu ka ja tey jcawel cyibaj judío?—tz̈i Pilato. ");
INSERT INTO mamNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Aj ttzak'be'n Jesús: —¿Tzimpa kanena weya cuma taja tz'el tni'ya ti'j ka nchin k'ojla ti'ja, bix ka cuma ma chi jaw yolen nejenel cye judío wi'ja?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aj ttzak'be'n Pilato: —Yaa'n jun aj judío kena, bix mintii' il ti'j tuj nwitza ti nchi yolena ejee'y judío ti'j jun cawel cyxola. Jmas il ti'j tuj nwitza, jaj tiken njawe cyk'oj ttanema ti'ja. ¿Tikentzen ma tzula cyii'n kej tneel pala nwitza tu'n tcub nk'o'na tcastiwey?—tz̈i Pilato. ");
INSERT INTO mamNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aj ttzak'be'n Jesús: —Ma tzaj tkanena weya ka inayena jun cawel. At jun ncawbila, pero yaa'n cyu'n xjal te twitz tx'otx' ma k'oj weya tu'n ncawena. Nuket te twitz tx'otx' ncawbila, matle chi k'oj kej xjal lepchec wi'ja, tu'ntzen mi'n nxi' k'o'na tuj cyk'ab nejenel cye judío. Pero yaa'n te twitz tx'otx' jncawbila ma tzaj k'o'n weya—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Cuma e yolen Jesús ti'j tcawbilxin, ju' tzunj e xi' tkba'n Pilato texin: —Jey', jun cawel tzuna—tz̈ixin. Aj ttzak'be'n Jesús: —Ju' tzuna. Ma chin ula twitz tx'otx' bix ma chin ul itz'ja tu'n woca te cawel. In ula tu'n t-xi' nk'umena jyol jaxxix. Kej xjal cyaj jaxxix yol, chi oquel lpeke wi'ja—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bix e xi' tkba'n Pilato: —Tuj nwitza, min cnet jjaxxix yol twitz tx'otx'—tz̈ixin. Tej tbaj tyol Pilato tuya Jesús, etz Pilato juntl maj tu'n tyolen cyuya judío. Bix e xi' tkba'nxin cyexin: —Mintii' jun til jxjal lu ma cnet wu'na. ");
INSERT INTO mamNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero at jun costumbre cyxola. Tzin tkba'n costumbre tu'n tel ntzakpi'na jun aj judío tuj tzee' jaca nink'ij te Pascua. ¿Cyajpey tu'n tex ntzakpi'na jxin xjal lu Cycawel ejee'y judío?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pero bix e jaw cys̈i'n xjal: —¡Yaa'n jxin lu tu'n tetz ttzakpi'na! ¡Tzokpimax jaj xin Barrabás keya!—tz̈i ke xjal. Bix ja Barrabás, jun k'ojlel ti' gobierno te Roma. ");
INSERT INTO mamNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tejtzen cycy'i judío tu'n tetz ttzakpi'n Pilato ja Jesús, e xi' tkba'n Pilato cye soldado tu'n t-xi' cyk'o'nxin tz'u'n toc xcbil twi' ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tej cybaj k'onxin tz'u'n ti'jxin, e baj cybincha'nxin jun pasbil te ch'i'x, bix e cub cycutz'enxin tuj twi'xin, bix oc cyk'o'nxin jun t-xbalen cawel, ");
INSERT INTO mamNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","bix e cub majekexin twitzxin te xmucchal texin, bix e xi' cykba'nxin: “¡Axsen cycawel xjal judío!” bix oc cylokaxin twitzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tbajlenxetzen Jesús tuj tz'u'n, etz Pilato juntl maj, bix e xi' tkba'nxin cye judío: —Q'ueletz wii'na ja xjal lu. Nim castiwa k'o'n texin, tisen cyaja. Pero waja tz'el cyni'ya ti'j mintii' tilxin ma cnet wu'na—tz̈i Pilato. ");
INSERT INTO mamNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bix etz Jesús cywitz xjal, tjax jpasbil te ch'i'x tuj twi'xin, bix toc t-xbalenxin xbalen rey. Bix e xi' tkba'n Pilato cye judío: —Jey', cycye'yenx ja xjal lu. ¿Japale jun cawel jlu?—tz̈i Pilato. ");
INSERT INTO mamNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pero tej toc cycye'yen kej nejenel cye pala bix kej c'ojlal tja Dios ja Jesús, min e cub cyi'j tu'n Pilato, sino e jaw cys̈i'nxin: —¡K'onwexin twitz cruz! ¡K'onwexin twitz cruz!—tz̈ikexin. Bix e xi' tkba'n Pilato cyexin: —Min. Ka cyaja jaw cyk'o'na twitz cruz, cyii'nxa ejee'x cyey, cuma tuj nwitza mintii' tilxin—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aj cytzak'be'n ke judío: —Pero at tilxin. Tzin tkba'n kleya il ti'j tu'n tcyimxin, cuma ma txi' tkba'nxin Tcwal Diosxin—tz̈i ke judío. ");
INSERT INTO mamNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tejtzen tbinte Pilato yol lu ti'j Tcwal Diosxin, nim ttz̈i e tzaj ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bix ocxxin juntl maj tuj tjaxin, bix e xi' tkanenxin te Jesús: —¿Japa tey te twitz tx'otx', bix ka ma tzaja te juntl lugar?—tz̈ixin. Pero mintii' ak' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ju' tzunj e xi' tkba'n Pilato te Jesús: —¿Mimpa tzaj ttzak'be'na inayena? ¿Mimpa tz'el tni'ya ti'j at wipemala tu'n t-xi' ntzakpi'na jay, bix at wipemala tu'n tcyima twitz cruz?—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Aj ttzak'be'n Jesús: —Nuket min otk tzaj tk'o'n Dios toclena tu'n tcawena cyxol xjal, minttzeletii' tipemala wibaja. Jnxi' tbincha'na wi'ja, nbinchana nuk o'cx cuma ma k'oj tey tu'n tcawena. Pero jxin tneel pala, oc tk'on tiibxin tu'n ttzaj tk'o'nxin inayena tuj tk'aba. Ju' tzunj, at mas tilxin twitzj jtey til—tz̈i Jesús te Pilato. ");
INSERT INTO mamNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tej tbinte Pilato kej yol lu, nim e tajbexin tu'n tel ttzakpi'nxin Jesús. Pero tej t-xi' tkba'nxin cye judío at tel-lel ttzakpi'nxin, e jaw cys̈i'nxin: —Ka ma txi' ttzakpi'na ja xjal lu, cxe'l kkba'na te rey tuj Roma ka yaa'n junx tey tuya gobierno te Roma, cuma taja tz'el ttzakpi'na jun xjal njaw tii'n tiib ti'j rey tu'n toc te t-xel gobierno—tz̈i ke judío. ");
INSERT INTO mamNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tej tbinte Pilato kej yol lu, e tzaj ttz̈i rey ti'jxin, bix e tcuyaxin jcyajbil judío. Etz tii'nxin Jesús cywitzxin, bix e cub kexin tuj k'ukbil te xkelte tuj jun lugar Xak Xi'nen Tuj tbi, bix ka Gabata tbi tuj cyyol judío. ");
INSERT INTO mamNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jatzen k'ij lu, jk'ij oj nbaj cybincha'n judío tik'ch cye te tajbel te juntl k'ij te ajlabl tuj nink'ij te Pascua. Bix otk tz'oc Jesús tuj xkelbil te kak tajlal hora. Tej tcub ke Pilato, e xi' tkba'nxin cye judío: —Jey', lu jxjal lu tzin cykba'na cycawela—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bix e jaw cys̈i'nxin: —¡Byo'nc'axin! ¡Byo'nc'axin! ¡K'onwexin twitz cruz!—tz̈ikexin. Bix e xi' tkba'n Pilato cyexin: —¿Jaxpa cyu'na? ¿Cyajpey tu'n tjaw nk'o'na cycawela twitz cruz?—tz̈ixin. Bix aj cytzak'be'n nejenel cye pala texin: —Nuk rey te Roma ncawen kibaja. Min-al juntl—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tej cyyolen judío ju'wa, e xi' tk'o'n Pilato ja Jesús tuj cyk'abxin, tu'ntzen tbyet. ");
INSERT INTO mamNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bixsen ex cyii'n soldado ja Jesús ti'jxe tnom. Jaxse Jesús e xi' kitente tcruz. E xi'kexin tuj jlugar Tbakel Wi'ybaj tbi, bix ka Gólgota tbi tuj cyyol judío. ");
INSERT INTO mamNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tej cyponxin, e jaw cyk'o'nxin jaxin twitz cruz, cyuyaj ca'batl xinak ttxlajxin. Jatzen Jesús tmij. ");
INSERT INTO mamNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bix tibaj twi'xin e jaw cyk'o'nxin cab letra otk cub ttz'i'ben Pilato twitz jun tzlom, tu'n tchic'ajax alcye tilxin. Tz̈i cyjulu: “Jesús, aj Nazaret, Cycawel Judío.” ");
INSERT INTO mamNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nim judío e jaw cys̈i'n kej yol lu, cuma jlugar jaa' otk jawa k'o'n Jesús twitz cruz, nka ttxa'n tnom, bix tz'i'ben tuj yol hebreo bix tuj yol latín bix tuj yol griego. ");
INSERT INTO mamNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pero min el ba'n ja letra lu tuj cywitz nejenel cye pala cye xjal judío. Ju' tzunj, e cubsankexin cywitzxin te Pilato: —Najsama, kaja tu'n tcub tch'ixbe'na jletra. Yaa'n tumel ja yol “Cycawel Judío.” Mas tumel tu'n toc ja yol “Ja xjal lu oc tk'on tiib te Cycawel Judío”—tz̈ikexin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Aj ttzak'be'n Pilato: —Mlay tu'n tch'ixpet yol. Cyjel jma cub ntz'i'bena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tej tjaw cypjo'n soldado Jesús twitz cruz, e xi' cytzyu'nxin t-xbalenxin, bix e cub cypa'nxin tu'n tel te cyaja, jun te jaca juun soldado. Jax ju'x e xi' cytzyu'nxin jun t-xbalenxin te nim twe'. Mintii' tz'isbilte, sino te junx plaj cujlec ti'jxin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ju' tzunj, e xi' cykba'nxin cyxolxxin: —Mi'n cub krotan tzunj t-xbalenxin, sino nuk tu'n tcub kk'o'n suerte ti'j kla' la' alcye jun ke ccamal ti'j—tz̈ikexin. E baj jlu, tu'ntzen tel jax jtyol Dios tzin tkba'n cyjulu: “Cwel cypa'n xjal nxbalena cyxolx, bix cwel cyk'o'n suerte ti'j tu'n al ccamal ti' nxbalena,” tz̈i tyol Dios jatxe ootxa. ");
INSERT INTO mamNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pero amale oquet ten ke soldado yajlal Jesús, pero ete' nka ti' cruz cyaja xuuj lepchec ti'jxin. Tocxse ttxuxin, bix titz'en ttxuxin, bix María, t-xu'l jxin Cleofas, bix xsunj xuj María Magdalena. ");
INSERT INTO mamNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jax at nka jt-xnak'atzxin nim oc tak' texin. Tej tlontexin ttxuxin, bix tuyax t-xnak'atzxin, e xi' tkba'nxin te ttxuxin: —Naa, ja xjal lu c'oquel tisen tala te nxela te c'ojlaltey—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bix e xi' tkba'nxin tej t-xnak'atzxin nim oc tak' texin: —Ja xuuj lu c'oquel tisen ttxuy—tz̈ixin. Bix tex hora e xi' tii'n tzunj t-xnak'atzxin ja María tuj tja te c'ojlal texuj. ");
INSERT INTO mamNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mas yaj, tej tel tniy' Jesús ti'j otk bint cykilca tu'nxin tu'n tel jax tyol Dios, e xi' tkba'nxin: —At tak' a' wi'ja—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Attzen cyxol soldado jun vaso nojne tuya jun wik vino tx'om ch'in. Bix e cu'x cymu'nxin jun bu's̈ tuj vino, bix oc cyk'o'nxin bu's̈ twi' tk'ab jun wik c'ul hisopo tbi, bix e jax cyk'o'nxin tuj ttzixin tu'n tetz ttz'u'benxin vino tuj bu's̈. ");
INSERT INTO mamNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tej t-xi' tc'a'nxin vino, e xi' tkba'nxin: —Ma bint cykilca waak'ena—tz̈ixin, bix e cu'tz tunntz'aj twi'xin cubne, bix otk txi' tokxenenxin tanemxin tuj tk'ab Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Te tzunj k'ij tej tjaw Jesús twitz cruz, jatzen k'ij te binchal tik'ch cye judío tu'n mi'n chi ak'anan te juntl k'ij te ajlabl. Bix ja tzunj k'ij te ajlabl jun k'ij te ajlabl mas jawnex, cuma tuj nink'ij te xjan smant. Bix tuj cyley nejenel cye judío, ka'xsen tu'n tjawe jun xjal twitz cruz tuj k'ij te ajlabl. Ju' tzunj, e cubsankexin cywitzxin te Pilato tu'n tbaj cytoken soldado cyken kej oxe xjal tjaw twitz cruz, tu'ntzen mi'n jatztl cyxew, bix tu'n tcu'tz cyii'n soldado cyxumlalxin cyimne twitz cruz. ");
INSERT INTO mamNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","E tcuya Pilato, bix e pon cab soldado, bix e baj cytokenxin ke tken tneel aj il tjaw ttxlaj Jesús. Tbajlen cytokenxin tken tneel aj il, e baj cytokenxin ke tken juntl al il tjaw twitz cruz tuya Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero tej cyponxin ti'j Jesús, e cyilxin ya otk cyimxin. Ju' tzunj, min e baj cytokenxin ke tkenxin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero at jun soldado ocx t-xyu'n tlans ttxa'n t-xuuc'xin, bix etz tz̈iy' tuya a' tuj. ");
INSERT INTO mamNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Inayena, jtz'i'bel tej u'j lu, ncub ntz'i'bena jma chin cye'yena ti'j. Inayena jun tstiwa jaxxix ti'j ti e baj, bix nxi' nkba'na cykilca tuya jaxxix yol, tu'ntzen cyocslana ti'j ja Jesús Jscy'o'n tu'n Dios, ");
INSERT INTO mamNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","cuma ma tz'el jax j-e tkba tyol Dios. Tz̈i tyol Dios cyjulu: “Mi nuket jun tbakel Jscy'o'n tu'n Dios cwel toket,” tz̈i tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bix at juntl tyol Dios tzin tkba'n cyjulu: “C'oquel cycye'yen kej xjal judío jxjal e jaw cypjo'n,” tz̈i tyol Dios ti'j Scy'o'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Attzen junxin xjal José tbi, jun aj tnom te Arimatea. Lepchecxin ti'j tyol Jesús, pero min otk tyeec'a tiibxin, cuma at cytz̈i nejenel cye judío ti'jxin. Tcyimlenxitzen Jesús, e pon José twitz Pilato te kanl te Pilato tu'n ttzaj tk'o'n t-xumlal Jesús te. E tcuya Pilato, bix e pon José jaa' ta' t-xumlal Jesús tu'n t-xi' tii'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jaan Nicodemo e xi' tuya José, jatzenj Nicodemo otk pon tuya Jesús jun koniyan. Ul tii'nxin nim c'oc'sbil cyi' xjal te c'oc'sbel te Jesús, mirra tbi jun wik c'oc'sbil, bix áloes tbi juntl. Setenta libros talen c'oc'sbil, bix smo'n cyca'bel wik. ");
INSERT INTO mamNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bix oc cybalk'i'nxin xbalen ti' t-xumlal Jesús tuya c'oc'sbil ti'j, tisex tten cyxol judío oj nmaket jun cyimne. ");
INSERT INTO mamNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nkatzen lugar jaa' otk jawa Jesús twitz cruz, at jun awal te lo'pj, bix cyxol cyken lo'pj at jun ac'aj tjayel anem twitz xak. Mitkna'x tocx cyimne tuj. ");
INSERT INTO mamNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bix cyeca nka ta' ja mukbil lu, tu'ntzen at-x tyem tu'n tmaket naj t-xumlal Jesús, cuma ch'itk toc jk'ij te ajlabl, bix xjantzen tu'n cymakunxin cyimne tuj k'ij te ajlabl. ");
INSERT INTO mamNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Texlen k'ij te ajlabl, tej tpon tneel k'ij te smant, te mitkna'x tul k'ij, e tzaj jxuj María Magdalena ti' tjayel Jesús twitz xak. Bix tej toc tcye'yenxuj, otk tz'el k'i'n xak tlemel twitz tjayel anem. ");
INSERT INTO mamNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tuj twitzxuj, otk tz'el cyii'n nejenel cye judío t-xumlal Jesús. Ju' tzunj, ajtz kelenxuj cyuya Simón Pedro bix jjuntl t-xnak'atz Jesús, jatzenj t-xnak'atzxin nim oc tak' texin, bix e xi' tkba'nxuj cyexin: —Ma tz'etz k'i'n t-xumlal Jesús tuj tjayel, bix mintii' tumel jaa' ma pona cyk'o'n—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tej tbinte Pedro tpocbal min-al Jesús tuj tjayel, extzen tuyaj juntl t-xnak'atz Jesús, bix e xi'kexin ttzii' tjayel. ");
INSERT INTO mamNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Junx ajkelenkexin cyca'bel tuj be, pero tuya mas ajkelbil ajkelen jjuntl t-xnak'atz Jesús, bix e pon ttzii' tjayel Jesús nejl twitz Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Bix e cub mutzexin tu'n tocx tcye'yenxin tuj jul, bix e tilxin nuk ejee'tl t-xbalen Jesús oc balk'et ti'j ete'cx, pero min ocxxin tuj jul. ");
INSERT INTO mamNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Bix lepchxe e pon Pedro ti'jxin, bix ocxxin tuj jul, bix oc tcye'yenxin ke xbalen otk cyaj tuj jul. ");
INSERT INTO mamNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Bix jxbalen otk tz'oc balk'et ti' twi' Jesús, yaa'n junx tcub cyuya niy'tl xbalen, sino tcub tuj juntl lugar tuj jul, bix baltz'i'n. ");
INSERT INTO mamNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yal te juntl t-xnak'atzxin, jaj otk pon nejl ttzii' tjayel cyimne, jax ocxin tuj jul. Tej tlontexin tcub t-xbalen Jesús tuj tumel bix mintii'tl xumlalbaj, eltzen tniy'xin ti'j otk jaw itz'j Jesús juntl maj tuj cyamecy. ");
INSERT INTO mamNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","El cyniy'xin ti'j jlu tu'nj toc cycye'yenxin t-xbalen Jesús. Yaa'n tyol Dios te ootxa e kbante cyexin, cuma mitkna'x tel cyniy'xin ti'j e tkba tyol Dios ka ilxix ti'j tu'n tjatz itz'jxin juntl maj tuj cyamecy. ");
INSERT INTO mamNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tej tel cyniy'xin ti'j otk jatz itz'jxin tuj cyamecy, e pon meltz'ajkexin tuj cyposadaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Yaltzen te María Magdalena, e ponxuj ttzii' tjayel Jesús juntl maj, bix nim oo'kxuj. Bix e cub mutzexuj, tu'n tocx tcye'yenxuj tuj jul. ");
INSERT INTO mamNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bix e tilxuj ca'ba tsanjel Dios tuj cya'j toc cyxbalen sak cyi'j. K'uklecxkexin jaa' ocxe ten t-xumlal Jesús. Junxin tocx jaa' a ten twi' Jesús, bix juntlxin tocx jaa' a ten ke tkenxin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bix etz cykba'nxin texuj: —Naa, ¿tikentzen noo'ka?—tz̈ikexin. Bix aj ttzak'be'nxuj: —Nchin oo'ka cuma ma tz'ex cyii'n xjal t-xumlal Jcawel weya, bix mintii' tumel wuyena jaa' ma pona cyk'o'n—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tej t-xi' tkba'nxuj jlu, ajtz meltz'aj twitzxuj, bix e tilxuj wa'lec jun xinak, pero min el tniy'xuj ti'j ka ja Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Bix e tzaj yolen tuyaxuj: —Naa, ¿tikentzen noo'ka? ¿Altzen tzin tjyo'na?—tz̈ixin. Tujtzen twitz María Magdalena, c'ojlal cyken lo'pj jaxin. Ju' tzunj, e xi' tkba'nxuj texin: —Taat, ka jay jxjal ma tz'aj tii'na t-xumlal Jesús, kbantz weya jaa' ma pona tk'o'na, tu'ntzen tcu'x nmaku'na—tz̈ixuj. ");
INSERT INTO mamNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Bix e xi' yolen Jesús texuj: —¡María! Tej t-xi' tkba'nxin tbixuj, el tniy'xuj ti'j ka Jesúsxin, bix te junx maj oc tcye'yenxuj ti'jxin, bix e xi' tkba'nxuj: —¡Taat!—tz̈ixuj tuj yol hebreo. ");
INSERT INTO mamNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","E xi' tkba'n Jesús texuj: —Mlay chin cyaja tzalu. Mina'x njaxa tuya Nmana, pero il ti'j chin jawela. Ju' tzunj, mi'n cub ttzyu'na inayena, sino cutxey cyuya ke hermano nxnak'atza, bix kbanx cyexin ka chin pomela tuya Nmana bix Cymanxin, tuya Ndiosa bix Cydiosxin—tz̈ixin te María. ");
INSERT INTO mamNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","E tcuyaxuj, bix e xi'xuj kbalte cye t-xnak'atzxin: —Ma wila Cawel kxol—tz̈ixuj, bix ak'xuj kbalte cyexin ti otk tkba Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jax jtneel k'ij te smant, tej tex k'ij, oc cychmon cyiib t-xnak'atz Jesús. Etz cylomo'nxin jaa' tuya tal, cuma at cytz̈i nejenel cye judío cyi'jxin. Ch'innch'e tul jlet Jesús cyxolxin, bix e xi' tkba'nxin cyexin: —Chi tenxita tuj ttz̈yal—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tej t-xi' tkba'nxin jlu, e xi' tyeec'anxin ke is̈jnin cyuj tk'abxin bix ttxlaj t-xuuc'xin. Tej tel cyniy'xin ti'j ka ja Cawel cyxolxin, nim e jaw tzalajkexin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Bix juntl maj e xi' tkba'nxin cyexin: —Chi tenxita tuj ttz̈yal. Tisenx ma tzaj tsma'n Nmana inayena tu'n nk'umena tyol cye xjal, jax inayena cxe'l nsma'na ejee'y—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tej t-xi' tkba'nxin at t-xi'lel tsma'nxin ejee' te t-xelxin, e xi' t-xupanxin t-xewxin cyi'jxin, te jun techel tu'n tcu'tz tk'o'nxin Espíritu Santo, bix e xi' tkba'nxin: —Oj tul Espíritu Santo, ccyiik'ela jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ejee'y kbalte ti pjel cye ocslal wi'ja. Jcykba'y ba'n tu'n tbint cyu'n ocslal, ba'ntzen. Bix jcykba'y yaa'n ba'n tu'n tbint cyu'n xjal, jax yaa'n ba'n—tz̈i Jesús cye t-xnak'atzxin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yal tej Tomás, bix ka Yoẍ tbi, min otk tenxin cyxol niy'tl t-xnak'atz Jesús tej tul jlet Jesús cyxolxin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ju' tzunj, e xi' cykba'n niy'tl t-xnak'atzxin texin: —Ma kila Cawel kxol—tz̈ikexin. Pero aj ttzak'be'n Tomás cyexin: —Chin ocslala cyyola nuk o'cx ka ma wila jaa' ocxa clavos cyuj tk'abxin, bix ka ma tz'ocx nk'o'na twi' nk'aba tuj tocxlen clavos, bix ka ma tz'ocx nk'o'na nk'aba tuj t-xuuc'xin—tz̈i Tomás. ");
INSERT INTO mamNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tetzen juntl tneel k'ij te smant, juntl maj oc cychmon cyiib ke t-xnak'atz Jesús, lmo'ntl ke tlemel jaa' tuya tal. Ja maj lu at Tomás cyxolxin. Bix juntl maj ul jlet Jesús cyxolxin, bix e xi' tkba'nxin: —Chi tenxita tuj ttz̈yal—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bix e xi' tkba'nxin te Tomás: —Cye'yenc j-is̈jnin cyi' nk'aba, bix k'o'nctz twi' tk'aba tzalu cyuj nk'aba. Bix k'o'nctz tk'aba tuj nxuuc'a, tu'ntzen mi'ntl baj tc'u'ja i'tz kena, tu'n tocslana ti'j ka inayena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aj ttzak'be'n Tomás: —Taat, jay Cawel wibaja bix Ndiosa—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","E xi' tkba'n Jesús texin: —Ma tz'ocslana ti'j in jaw itz'ja tuj cyamecy nuk cuma ma chin tila. Pero mas ba'n ka ma tz'ocslan jun xjal wi'ja, amale mint ma chin cyil—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Key xjal, ma cub ntz'i'bena ch'in ti'j ti e bint tu'n Jesús. At nimtl e bint tu'nxin cywitz t-xnak'atzxin tu'n t-xi' tyeec'anxin tipemalxin, pero yaa'n tz'i'ben tuj ja u'j lu. ");
INSERT INTO mamNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero ma cub ntz'i'bena kej tbinchbenxin lu, tu'ntzen cyocslana ka jxjal Scy'o'n tu'n Dios ja Jesús, bix Tcwal Diosxin, bix tu'n toc ke cyc'u'ja ti'jxin, tu'ntzen tten cychunk'lala te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tul-len jlet Jesús cyxol t-xnak'atzxin, bix e cub tyeec'an tiibxin juntl maj cywitz juun t-xnak'atzxin ttzii' tnijabel a' Tiberias. Ju'tzen tten e cub tyeec'anxin tiibxin. ");
INSERT INTO mamNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Oc cychmon cyiib Simón Pedro tuyax Tomás ja yoẍ, tuyax Natanael, aj Caná tuj departamento te Galilea, cyuyax tcwal jxin Zebedeo, bix cyuyax ca'batl t-xnak'atz Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","E xi' tkba'n Simón Pedro cyexin: —Weya, ma chixa tzyul quis̈—tz̈ixin. —Jax ju'x keya, ma ko'xa tuyey—tz̈ikexin. Exkexin, bix ocxkexin tuj jun choc, bix e baj ak'bil cyu'nxin tuj tnijabel a', pero mi nuket jun quis̈ e tzyet cyu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tej kskix, lu Jesús wa'lc'a ttzii' a'. Pero min el cyniy' t-xnak'atzxin ti'j ka jaxin. ");
INSERT INTO mamNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ju' tzunj, e xi' tkba'nxin cyexin: —Jey', key k'a, ¿atpa quis̈ xtzyet cyu'na?—tz̈ixin. —Mintii', taat. ");
INSERT INTO mamNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ju' tzunj, e xi' tkba'nxin cyexin: —Cyxoo'nxsa cyxiy'pay tuj a' tuj mank'ab te choc, bix ctzyetel quis̈ cyu'na—tz̈ixin. E cycuyaxin, bix tej cyak'xin tu'n tjatz cyii'nxin cyxiy'paxin tuj choc, ya min e bint cyu'nxin tu'nj nimxsen tajlal quis̈. ");
INSERT INTO mamNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ja tzunj xin t-xnak'atz Jesús oc tak' te, tej tlontexin tipemal tyol jxjal ttzii' a', e xi' tkba'nxin te Pedro: —¡Jaja Cawel kxol!—tz̈ixin. Tej tel tniy' Pedro ti'j ka ja Cawel cyxol, oc tẍpo'nxin t-xbalenxin ti'jxin, cuma otk tz'el tii'nxin tu'n tak'ananxin, bix e cu'xxin tuj a'. ");
INSERT INTO mamNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","E cub t-xoo'n tiibxin tuj a' cuma yaa'n nakch ta' choc ttzii' tx'otx', sino nuk jun syent vara ta'. Yal kej niy'tl t-xnak'atzxin, e tzajkexin tuj choc, kitentzen cyxiy'paxin nojne cyuya quis̈. ");
INSERT INTO mamNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tej cyi'yelxin twitz tx'otx', e cyilxin otk cub pek'ch jun k'ak' tuya txal k'a'l, bix ntxeet quis̈ tibaj, tuyax waabj. ");
INSERT INTO mamNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","E xi' tkba'n Jesús cyexin: —Cyii'ntza ca'ba oxe quis̈ xtzyet cyu'na jatxe may'—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ocxtzen Simón Pedro tuj a', bix e tzaj tkitenxin xiy'pa, tu'ntzen ti'yel ttzii' a'. Nojne xiy'pa cyuya nmak quis̈. At jun syent tuya cya'wnak tuya oxlaaj quis̈. Pero amale nimet, pero min e cub rotj xiy'pa. ");
INSERT INTO mamNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Bix e xi' tkba'n Jesús cyexin: —Chi tzaja, bix chi waa'na—tz̈ixin. E cycuyaxin, bix min-al e xi' tkanen texin alcyexin, cuma el cyniy'xin ti'j ka ja Cawel cyexin. ");
INSERT INTO mamNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","E xi' ttzyu'n Jesús jwaabj, bix e xi' tk'o'nxin cyexin, bix jax e xi' tk'o'nxin quis̈ cyexin. ");
INSERT INTO mamNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tej t-xi' tk'o'n Jesús waabj cye t-xnak'atz, toxentzen maj e cub tyeec'an tiibxin cywitzxin tjatzlen itz'jxin tuj cyamecy juntl maj. ");
INSERT INTO mamNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tejtzen cybaj waa'nxin, e xi' tkba'n Jesús te Simón Pedro: —Simón, tcwal Jonás, ¿n-ocpa wak'a tey mas twitzj taak'ena te tzyul quis̈?—tz̈ixin. —Tzin, taat. Tzki'n tu'na n-oc tak'a weya—tz̈i Pedro. E xi' tkba'nxin te Pedro: —Ka ju' tten, c'ojlanx kej xjal lepchec wi'ja, tisenj jun cylel nc'ojlan ke tal carnel—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Juntl maj e xi' tkanenxin te Pedro: —Simón, tcwal Jonás, ¿n-ocpa wak'a tey?—tz̈ixin. Aj ttzak'be'n Pedro: —Tzin, taat. Tzki'n tu'na n-oc tak'a weya—tz̈i Pedro. —C'ojlanx kej xjal lepchec wi'ja—tz̈i Jesús. ");
INSERT INTO mamNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Bix te toxen maj e xi' tkanenxin te Pedro: —Simón, tcwal Jonás, ¿n-ocpa wak'a tey?—tz̈ixin. Cuma otk tzaj tkanenxin toxen maj: “¿N-ocpa wak'a tey?” ju' tzunj e tzaj tbis Pedro, bix e xi' tkba'n te Jesús: —Taat, tzki'n tu'na cykilca. Tzki'n tu'na n-oc tak'a weya—tz̈i Pedro. Bix e xi' tkba'n Jesús te Pedro: —C'ojlanx kej xjal lepchec wi'ja. ");
INSERT INTO mamNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jaxxix cxe'l nkba'na tey, tej cwalx tey, e tbincha tey tajbila. N-oc tẍpo'na t-xbalena tcy'itza, tu'ntzen t-xi'y nuk jaa'xja taja. Pero oj ttiina, juntl xjal c'oquel ẍponte tey, bix cxe'l tii'n jay jaa' tcy'iy tu'n t-xi'y. Bix cxe'l tnukpi'na tk'aba—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E xi' tkba'nxin jlu tu'n tyeec'anxin ti tten tu'n tcyim Pedro, bix at tjawlel tnimsa'n Pedro tbi Dios tu'n tcyamecy. Tej tkbantexin jlu, e xi' tkba'ntlxin te Pedro: —Ttzaja wuyena—tz̈ixin. ");
INSERT INTO mamNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","E tcuya Pedro, bix tej nchi etz lk'ekexin cyi' niy'tl t-xnak'atzxin, ajtz tcye'yen Pedro ti'j, bix e til lepchec cyi'jxin jt-xnak'atzxin oc tak' te Jesús, jatzenj t-xnak'atzxin otk cub ttxlaj Jesús tej cywaa'nxin manc'bil maj tuyaxin, bix otk txi' tkanen texin: “Taat, ¿alcyej kxola cxe'l tq'ueyen jay tuj cyk'ab byol xjal?” ");
INSERT INTO mamNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bix tej tlonte Pedro ja t-xnak'atzxin lu toc lpe cyi'jxin, e xi' tkba'nxin te Jesús: —Taat, yaj tzunj t-xnak'atza lu, ¿ti pjel texin oj ttiinxin?—tz̈i Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","E xi' tkba'n Jesús texin: —Ka waja tu'n tcyajxin i'tz hasta ojxe wul meltz'aja, mintii' tey taj te. Tey, il ti'j tu'n t-xi' lpey wi'ja—tz̈ixin te Pedro. ");
INSERT INTO mamNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Cuma otk txi' tkba'nxin ja yol lu, ju' tzunj tuj cywitz ocslal mas yaj, yaa'n tu'n tcyim ja t-xnak'atzxin lu. Pero yaa'n ju'wa, cuma min e xi' tkba'n Jesús te Pedro tu'n mi'n tcyim ja juntl t-xnak'atzxin. Nuk o'cx e xi' tkba'nxin: “Ka waja tu'n tcyajxin i'tz hasta ojxe wul meltz'aja, mintii' tey taj te.” ");
INSERT INTO mamNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Inayena jt-xnak'atzxin e wila cykilcaj e baj, bix e cub ntz'i'bena ti e baj. Bix ntzki'na jaxxix yol cykilcaj ma cub ntz'i'bena. ");
INSERT INTO mamNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","At nimtl e bint tu'n Jesús min ma cub ntz'i'bena. Nuket ma cub ntz'i'bena cykilcaj tbinchbenxin, tuj nwitza mlayle bint tu'n tcnet lugar twitz tx'otx' tu'n cyten libro tu'n tcub tz'i'bet cykilca. O'cx nyolja.");
INSERT INTO mamNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Key xjal n-oc tak' Dios cyey, Inayen Lucas. Ncub ntz'i'ben tcab u'j cyey. J-u'j e xi' ntz'i'ben cyey tneel, e xi' nkba'n cyey cykilj e baj te Jesús bix cykilj e baj t-xnak'tza'nxin cye xjal, jatxe tej ttzaj tzyet t-xnak'tzanxin tneel k'ij, ");
INSERT INTO mamNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tejxe tjaxxin tuj cya'j. Tuj tzunj libro lu cxe'ltzen nkba'n cyey ti e baj cyej xin oc lpe ti'j Jesús tej tajlenxitlxin tuj cya'j. Tej ttenxin twitz tx'otx', nuk e tyeec'axin cyej t-xnak'atzxin otk baj tjyo'nxin tu'n cycyajxin te t-xel Jesús. E baj tninc'u'n Jesús ejee'xin tuya tonbil Espíritu Santo tu'n ti ctemela jtaak'enxin otk tzaj tzyet. ");
INSERT INTO mamNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Bix tej tjatz itz'jxin tej tcyimlenxitlxin, bix e xi'xin jaa'j ete' ke t-xnak'atzxin, bix e pon Jesús i'tz cyi'jxin, bix nim maj e cub tyeec'axin techlalxin ka i'tzxin. Bix e tenxin cyuya ke t-xnak'atzxin cya'wnak k'ij bix e baj tyeec'anxin ti tten tcawbil Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","At jun k'ij tej mintkna'n t-xi' Jesús tuj cya'j bix e xi' tkba'nxin cye t-xnak'atzxin: —Mi' chi exa tuj tnom te Jerusalén. Cyyo'm cabtl k'ij tzalu, ojxe tul Espíritu Santo tzinen o tzaj kbet cyey, ka tu'n ttzaj chk'et Espíritu Santo tu'n tten cyuyey, otzen txi' nkba'n cyey nejl. ");
INSERT INTO mamNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","N-ultzen tuj cyc'u'ja tej xin Juan Bautista e cu'x tk'o'nxin ke xjal tuj a' kej e cyajbe cymeltz'aj tuya Dios. Pero tujtzen cabtl k'ij attzen juntl ch'ixbe'n c'oquel. Tzultzen Espíritu Santo te k'olte mas cyipemala tu'n t-xi' cyii'na jcyaak'ena cyjel nk'o'na—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Juntltzen k'ij tbajlenxitl ju'wa, tej toc cychmon cyiib t-xnak'atz Jesús tuyaxin, ttxa'n Jerusalén, twi' jun witz Olivos tbi, bix e xi' cykanenxin: —Taat, keya ejoo'ya xjal te judío lu ko'ya eto'cx tjak' cycawbil jxjal tzajninxa. Jey', ¿mapatzen pon tumel tu'n kel tco'pana tjak' cycawbil bix tu'ntzen ja tey cawen?—tz̈i tzunkexin te Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Bix aj ttzak'be'n Jesús: —Yaa'n ilxixte ti'j tu'n cybinte cyey jntzaj cykanena. Nuk o'cxc'ate Kman Dios itzkil te ja, cuma nuk ja texin at tajwalel te scy'olte jtoj pjel tik'ch jilel. ");
INSERT INTO mamNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jcyey il ti'j tu'n cybinte ja tej tzul cyey cyipemal ojtzen tul Espíritu Santo najal cyuyey bixsen ckebel cyc'u'ja oj cyak'a yol we. Chi xe'la tz̈itpul we nuk jak'ch tumel, tzalu tuj tnom te Jerusalén, tuj ttx'otx' Judea, tuj ttx'otx' Samaria, bixsen cyuj tx'otx' mas nakch twitz tx'otx'. Chi oquela te nxel—tz̈i Jesús cye t-xnak'atz. ");
INSERT INTO mamNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","T-xi'len tkba'nxitltzen Jesús ja lu, bix ak' jawexxin tuj cya'j, maatkxsen nchi cye'yenx t-xnak'atzxin ti'jxin. Cwa tcyaj bajxin tuj jun muj. Minx e cyilxin jaxin. ");
INSERT INTO mamNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Maatkxsen n-el jac'ch cyanemxin ti'j tjaxlen Jesús tuj cya'j, tjaw jlet ca'baxin tsanjel Dios cytxlajxin sc'apenxsen cyi'jxin. ");
INSERT INTO mamNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bix e xi' cykba'nxin cye t-xnak'tzal Jesús: —Ke cyey xjal aj Galilea, ¿tikentzen nim nchi cye'yenxa tuj cya'j? Tej xin Jesús lu ma cyaj tk'o'n texin ejee'y. Ma tz'aj k'i'n texin tuj cya'j. Ma cyila ma jaxxin, bix la' alcye jun k'ij tzul meltz'aj texin twitz tx'otx'. Tisenx ma jaxxin ju'x oj tulxin—tz̈i ke tsanjel Dios cyexin. ");
INSERT INTO mamNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Entonces bix e xi' ke t-xel Jesús twi' jwitz Olivos, bix ajtz meltz'ajkexin tuj Jerusalén te jun kilómetro ta'. ");
INSERT INTO mamNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tejtzen cyponxin tuj tnom, bix e jaxkexin tuj tcab cxo'len jaa' jaa'j ta' cyposadaxin. Bixsen oc cyk'o'nxin te tajlal kej xin Pedro, Jacobo, juntl tbixin Santiago, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo, tcwal jxin Alfeo, jxin Simón, junxin otk ten nejl tej cloj e tajbe tk'ojl tuya Roma, bixsen Judas, juntl tbixin Tadeo, tcwal Jacobo, yaa'nte Judas Iscariote. ");
INSERT INTO mamNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jatztzen oca cychmon cyiibxin jaca k'ij tu'n toc cyk'on cyiibxin te na'l Dios te junx maj bix cyjunen cyiibxin. Cyuya cab xuuj e pon cyuyaxin te na'l Dios cyuyaxin, cyxoltzen xuuj tocxa jxuj María, ttxu Jesús, bixsen ke titz'en Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Cabtltzen k'ij mas yaj tuj jun wikxitl lugar bix oc cychmon cyiib jun syent tuya wink'an xjal otk tz'ocslante Jesús, bixsen e cub we' Pedro cyxol xjal te yolel cyuya. ");
INSERT INTO mamNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Bix e xi' tkba'n Pedro cyjulu: —Key ocslal wuya, tej e cu'x tz'i'bet tuj tyol Dios at-xe tyem ox bintte. E cyaj tkba'n Espíritu Santo tuya tyol ktzan David ti jilel tbinlel tu'n Judas Iscariote. Bix yaltzen ja'lewe ox bintte ju'wa. Cykil ko' itzkilte ti tten tonen bix ti tten tcub nej Judas cywitz jxjal e tzyunte Jesús tu'n tbyet-xin. ");
INSERT INTO mamNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tej xin Judas lu ja te xinja jun kuya, cuma jax e scy'et-xin tu'n Jesús tu'ntzen tbint jkaak'en, tu'n tchic'ajax jba'n tpocbalj yol te co'pbil. ");
INSERT INTO mamNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero bix e xi' tq'ueyen Judas ja Jesús tuj ewjel. Mas yaj, ya ktzki'ntltzen keya, bix e xi' Judas tuj jun lugar jaa' e tzaa' t-xoo'n tiibxin lenchl e ponxin twitz tx'otx'. Tcubtzen tz'akxin, bi'x el tzac'ch ttzoo'nxin bix etz baj tuj tc'u'jxin ti'jxe. Ju'tzen tten tcyimxin. Yajc'atltzen bixsen e cylok'tl ke pala cyibaj xjal judío ja tx'otx'a tuyaj pwak e tcama Judas ti'j t-xi'len tq'ueyenxin ja Jesús tuj ewjel. ");
INSERT INTO mamNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yaltzen ke xjal te Jerusalén, tej toc cybi'n xjal ja ila, bixsen oc cyk'o'n xjal tbi ja tx'otx'a te Acéldama, jatzen elpenina “Jtx'otx' Tlok'aj Pwak Byol Xjal” tuj cyyol xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tuj Salmos at jun yol nbya'n cyjulu: “E tcyajtzen tk'o'n tja bix min-al juntl ba'n tocx najan tuj.” Bix juntl tzin tkba'n cyjulu: “Jun wikxitltzen xjal e tk'in tej taak'en tocsen,” tz̈i tyol Dios, tu'ntzen telniy' ka tu'n tcyim Judas bix tu'n tcyaj taak'enxin otk tz'oc nejl. ");
INSERT INTO mamNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ju' tzunj ctzaal kjyo'n jun xjal te t-xel Judas, jaj junxin xjal e bet kuya junx tuya Jesús tej tbautizarjxin tu'n Juan Bautista bix tejxe taj k'i'nxin tuj cya'j. Jatzen xjalaja cwel ten kbalte tyol Dios kuya ka o jatz itz'jte Kman Jesús—tz̈i Pedro cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Entonces cyxoltzen xjal bix etz cyscy'o'nxin ca'ba xjal. Jatzen José bixsen Matías. Jatzen José at maj n-ocxin te Barsabás bix at maj n-ocxin te Justo. ");
INSERT INTO mamNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bix ak'kexin na'l Dios cyjulu: —Taat, ja tey itzkilte tii'n tanem cykil xjal. Nuksama, yeec'antz tzuna keya al jun cyej xjal lu taja ");
INSERT INTO mamNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","te t-xel Judas, tu'n tbint jtaak'en Judas ma cyaj tk'o'n tej t-xi' tjyo'n til bix o cyim, o txi' tuj k'ak' ja tzunja o tiik'—tz̈itzen ke xjal te Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tejtzen cybaj na'nxin Dios, bixsen ak'kexin kẍal ti' cysuertexin la' altzen jun cyexin tu'n tcaman te t-xel Judas. Jatzen Matías e caman, ja tzunxin ocx tuj taak'en Jesús tuyaj junlajajtlxin. ");
INSERT INTO mamNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tcublen bajxitl tzunj cya'wnak tuya lajaj k'ij at-xsen cye xjal judío cycostumbre tu'n t-xi' cyk'o'n cab twitz cyawal te Dios, bixsen tziy' jun cynink'ij xjal. Ja tzunj nink'ija Pentecostés tbi. Tejtzen tpon tumel ja nink'ij te Pentecostés, jatzen junx n-oc cychmon cyiib t-xel Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tejtzen cychmon cyiibxin, ch'innch'e t-xi' cybi'nxin tjaw jun tij k'ajtlenel tzajninxe tuj cya'j. E k'ajt-xsen tisen jun tij cyk'i'k njitx'itx'in. E k'ajk'ajaxsen tuj cykil lugar jaa' ete'c'axin. ");
INSERT INTO mamNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bix e cub jlet nim techlal tisen taak' xjal, bix tisen tken k'ak', bix e baj cub paxke bix e cub tenke tibaja jaca juun xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ju'tzen tten toc Espíritu Santo tuya jaca juun xjal. Bix oc tk'o'n cyipemal xjal, bix ak'ke yolel tuj jun wikxitl yol la' alcye oc tk'o'n Espíritu Santo cye tu'n t-xi' cyyolen. ");
INSERT INTO mamNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tu'ntzen tiy'set jk'ij te nink'ij, nimxsen xjal judío otk pon tuj Jerusalén. Te cykil twitz tx'otx' otk chi baj tzaa' xjal, bix tec'alex yolen juun wik xjal e baj tzaj te nakch. ");
INSERT INTO mamNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tejtzen toc cybi'n jxjal tex tnom bix xsun kej xjal te nakch, cybinte tzunj tij k'ajtlenel, bix oc cychmon cyiib xjal junx. Tejtzen toc cybi'n xjal cyyol t-xel Jesús nchi kban tyol Dios tuj jcye xjal cyyol, bix e baj jaw klee' ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Min e bint cybisen xjal ti'j, bix e xi' tkba'n cab te cabtl: —¿Tikentzenle nimxsen yol ba'n cyu'n? Pero nuk te tnom Galilea ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Pero tikentzenle ju'wa? Lu ke nchi yolen kuya tuj ke kyol te jaca juunke. ");
INSERT INTO mamNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Bix nim ke kyol. Kxol at xjal te ttx'otx' Partia, te ttx'otx' Media, ttx'otx' Elam, te Mesopotamia, te Judea, te Capadocia, te Ponto, te Asia, ");
INSERT INTO mamNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","te Frigia, te Panfilia, te Egipto, cye tnom tuj ttx'otx' Africa mas nakch twitz Cirene, bixsen te Roma. Kxol at ke judío cuma jax itz'ja ko' tzalu, bix at ke nuk o tz'oc kk'on kiib te judío. ");
INSERT INTO mamNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ju'nawa, pero mi'n tz'el tuj kc'u'j tu'n cyxi' kna' kej xjal te Creta bix xsun kej xjal te Arabia, ¡Tiẍtate ti'j, ja te cxe'l kc'u'j ti'j ba'n tbinchben Dios nkbet ke tuj kyol!—tz̈itzen cykilca xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Pero e jawxsen klee' ke xjal minxsentii' ba'n t-xi' cybisen ti'j bix ak'ke kanlte cyxolelex: —¿Titzen elpenina ja lu? ¿Titzen nbaj?—tz̈itzen ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero attzen cab xjal oc ten xmucchalec cyej xin t-xel Jesús kbal tyol Dios. Tz̈i tzunkexin cyjulu: —Cuma ma txi' cyc'a'n k'e'n—tz̈itzen ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tejtzen toc cybi'n jcablajajxin t-xel Jesús tyol, bix e jaw we'kexin. Cyxolx xsunxin ak'a Pedro yolel cyiw cye xjal bixsen cyej xjal xmucchal: —Ke cyey xjal te ntanem judío, bix xsunkey xjal najl tuj Jerusalén, cybimc'atzen ti jilel cxe'l nkba'n cyey. ");
INSERT INTO mamNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Keya yaa'n bola ko'ka tisenj cyey tuj cywitz. Cybisenxa ti'j, maa beljaj tajlal hora ja'lewe, bix cykil xjal itzkilte min-alte jun n-ak' c'al k'e'n te jya'x. ");
INSERT INTO mamNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yaa'n ju' tewa. Ja te ja lu e cyaj tk'umen Dios jatxe tyem tu'n tbint tu'n. Ba'n cyu'na o tzaj tk'umen Dios tu'n tyolel Joel cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“La' alcye jun k'ij tzul nchk'o'n Espíritu Santo tu'n tten cyuya tiẍte xjalel ti'j, tu'ntzen cxe'l cyk'umen ke cycy'aala bixsen ke cymeela nyola cye xjal. Bix ke xjal c'oquel cycye'yen tuj cywitziy' ti jilel waj txi' nyeec'an cye, cyele cwal, cyele tij. ");
INSERT INTO mamNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jaxxix wu'n cyuj tzunj k'ij chi ul, cxe'ltzen nchk'o'n Espíritu Santo te cykil kej xjal ma tz'oc ebinte we bix chin cybi' aljxele ti'j, xuujle, xinakle. Bix cykba' la' alcyej we cxe'l nkba'n cye. ");
INSERT INTO mamNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Bix cyuj tzunj manc'bil k'ij cxe'ltzen nyeec'an ke techlal tuya nim sey'pajlenel twitz cya'j, bix ka'c'axsen pjel twitz tx'otx'. Nimxsen tz̈iy' q'uelel, nimxsen k'ak' bix nimxsen sib. ");
INSERT INTO mamNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kloljxsen c'oquela k'ij bix cyakxsen c'oquela xjaw tisen tz̈iy'. Bix yajxitltzen oj tpon k'ij tu'n tak' Taaw twitz tx'otx' te ninc'ul cykil xjal, jatzen k'ij oj t-xi' tyeec'an Dios nintzaj tipemal. ");
INSERT INTO mamNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pero jaca juun xjal ma txi' kanente najsbil ti' til te Dios cco'pjeltzen tuj il tzul,” tz̈itzen Dios tu'n Joel jatxe nejl. ");
INSERT INTO mamNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Cybimc'atzen nyol, key te ntanem Israel. Jesús te Nazaret jatzen jun xjalj o tzaj tchk'o'n Dios twitz tx'otx'. Bix cywitz tzuna toc tajwalelxin tu'n Dios tuya nim techlal tipemalxin, tisenxj o cyila. ");
INSERT INTO mamNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero tisenx tcublen tuj twitz Dios jatxe nejl, ja tzunj xin Jesús lu oc k'o'n tuj cyk'aba, bix tejtzen tpon tumel, ejee' tzuna e cub byonte texin cyu'nj xjal min tz'oc tak' Dios cye. Ejee'tzen xjal e jaw k'onte texin twitz cruz. ");
INSERT INTO mamNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero amale e byetet-xin, o jatz titz'jsa'n Dios jaxin. O tco'pan Dios jaxin tuj cyamecy, cuma yaa'n tumel tu'n toc ten cyamecy c'ojlalte Jesús tisen jun pres. ");
INSERT INTO mamNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ja tzunj tpocbala e cyaj ttz'i'ben jxin David nejl tuj Salmos. Tz̈i tzunj xin Scy'o'n tu'n Dios cyjulu, tz̈i David: “Ntzki'nwe ka cykil tyem at Dios wuya. Jatzen weya wuyaj at tuya nk'aba tuj nmank'aba te onl weya. Ju' tzunj mintii'wa ttz̈i wi'j. ");
INSERT INTO mamNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ju' tzunj axsen ttz̈yal ta'we wanem. Cxe'ltzen nkba'n ch'in ti'j ttz̈yal ta' wanem, jaj cuma ntzki'ntl oj ncyim, chin jawetz itz'jtlwe juntl maj. ");
INSERT INTO mamNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Dios nman, ntzki'nwe mlay cyaj tk'o'n wey wanem cyxol cyimne, bix jax mlay tcuyey tu'n tcub k'ey nxumlal, cuma inayena sant tcwala. ");
INSERT INTO mamNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ctzaal tmeltz'u'n wey nchunk'lal juntl maj. Bix chin pomel meltz'ajwe twitza bixsen chin temela tuj tbanel tu'na,” tz̈itzen Tcwal Dios, tz̈i David tcyaj tkba'n at-xe k'ij. ");
INSERT INTO mamNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ke cyey te ntanem, min e yolen jxin kxe'chel David ti'jxxin, cuma cykilte ko' itzkilte ka e cyimte David bix e mket-xin, bix jax lu'x tjayelxin at-x tuj tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yaltzen te David e yolen texin ti'j cpjel mas yaj, bix ttzki'ntexin ka otk tkbate Dios tuyaxix jun tyol jax, bix ka ja jun t-xe'chel David tscy'etlel tu'n Dios te cawel te junx maj. ");
INSERT INTO mamNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ti'j tzunj t-xe'chel David e tkbatzen David alcyej k'ij tul-lelxin, bix jaxsen xinj e tkba David tu'n tjatz itz'j tuj tx'otx', bix mintii' tu'n tcyaj tanemxin cyxol cyimne, bix tu'n mi'n cu'x k'ey t-xumlalxin. ");
INSERT INTO mamNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jatzen Scy'o'n tu'n Dios ja Jesús, e jatz titz'jsa'nxin juntl maj tu'n Dios. Cykilxsen ko' te tstiwa ti'j. ");
INSERT INTO mamNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yaltzen ja'lewe o tz'aj k'i'nxin tuj cya'j, jaa' o tz'oca tajwalelxin te cawel junx tuya Dios tibaj cykil twitz tx'otx'. Bix jax o tz'oc tk'o'nte Kman Dios Espíritu Santo te Jesús tisenx e tkbaxin tuj tneel, bix tu'ntzen ttzaj tchk'o'n Jesús Espíritu Santo twitz cykil twitz tx'otx'. Ja tzunja ma bint tu'n Dios ja'lewe, bix xsunj ma cyila bix ma cybiy ejee'tzen techlal J-espíritu Santo ma tzaj tk'o'n te kcotz. ");
INSERT INTO mamNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ba'n, tzinenx ti'j yaa'nte David aj k'i'n tuj cya'j, sino ja te Jesús. Jax David e kbante cyjulu: “Jax Kman Dios e kbante te Waaw: ‘Keca tuj nmank'ab tisen tneel xjal, ");
INSERT INTO mamNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ojxe nxcye cyibaj taj k'oja,’ tz̈i Dios te Tcwal,” tz̈i ktzan David. ");
INSERT INTO mamNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ju' tzunj cyjel nk'o'n tuj chic'aj cyey, ejee'y te Israel, jxin Jesús nko yolen ti'j, jatzente xinj jaxxix Scy'o'n tu'n Dios. Otzen tz'oc tk'o'n Dios jaxin te Kaaw. Bix jax xsun ja xjal lu cyey e cybiya twitz cruz—tz̈itzen Pedro cye xjal judío. ");
INSERT INTO mamNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tejtzen cybinte xjal jtyol Pedro, bixsen e cyna' xjal tchyonel, cuma el cyniy' xjal ti' cyka'yel, bix e xi' cykba'n xjal te Pedro bix tej cabtl t-xel Jesús: —Key ktanem, ¿titzen ko temela ya tu'ntzen kco'pja?—tz̈itzen ke judío. ");
INSERT INTO mamNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pero bix aj ttzak'be'n Pedro: —Cyjel cyk'o'na cyila, bix chi xe'la tuj a' tu'ntzen t-xi' cyyeec'ana ka ma chi meltz'aja, bix ya cyk'ontltzen cyiiba tuyaj xin Scy'o'n tu'n Dios, jaj xin Jesús. Ju'tzen ctemela tu'n tnajset cyila bix cyiik'a tzuna t-xtalbil Dios, ja Espíritu Santo. ");
INSERT INTO mamNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jatzen jun tyol Dios o cyaj te cyey, bix te cycwala, bixsen te cyej xjal chi itz'jel la' alcye jun k'ij, te cykilj xjal ttxca' Dios—tz̈i Pedro cye xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jayle tzunja e tyole Pedro, bix at-x nimtl tyolxin. E tkbaxin tu'n il ti'j tel cypa'n cyiib xjal cyi'j xjal judío cycy'i tu'n cyiik'ente Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","At-xsen nim xjal oc ocslante tyol Pedro bix e bautizarj. Tex xsunj k'ija atle oxe mil xjal e bautizarj. ");
INSERT INTO mamNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bix oc cysmon cyiib xjal cyuya nimtl ocslal tu'n toc cyk'on cyiib nuk te ebil cyxnak'atz t-xel Jesús. E ten ke xjal tuj ttz̈yal tuya cabtl. E waa'nke bix e na'nke Dios junx, bix e cub cypa'n tik'ch cye. ");
INSERT INTO mamNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bix cykilxsen ke xjal te Jerusalén e jaw klee' cuma nimxsen tajwalel techlal cyaak'en t-xel Jesús e bint. ");
INSERT INTO mamNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bix cykilca kej xjal oc ocslante Jesús oc cychmon cyiib jaca k'ij junx. Ojtzen n-oc cycye'yen jun xjal tuj tcyajlal, e cub cypa'ncye xjal tik'ch cye cyxol. ");
INSERT INTO mamNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","E xi' cyq'ueyen tibaj cytx'otx' bix tik'chtl cye at. Tuya tzunj twi' e cyiik', bix ajben cye te onlec cyej ocslal mebe tuya alcye tcyajlal ete'. ");
INSERT INTO mamNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jacaxsen k'ij e chmetke xjal te na'l Dios tuj nintzaj tja Dios. E waa'nke xjal junx cyja bix nchi tzalajxsen xjal bix junx e'la cyanem. ");
INSERT INTO mamNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bix nim e xi' cyk'o'n chjonte te Dios, cuma nimxsen cyanem ti' Dios. Bix nimel ke xjal cywitz ocslal. Jacaxsen k'ij oc mas nim xjal ocslalte tyol Jesús. Ju'tzen tten ttz̈'iy cybet ke ocslal tu'n Kman Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Attzen jun k'ij ca'ba tzunxin t-xel Jesús, ja Pedro tuya Juan, bix e xi'kexin tuj nintzaj tja Dios te oxe tajlal hora te kale, texj hora oj nchi pon xjal judío te na'l Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ch'itktzen cypon cananxin ta' tja Dios, t-xi' cycye'yenxin cab xjal k'i'n juntl xjal cox cyu'n, xi'ninke tuj tja Dios. Pero jxjal cox ju'x tten ttzajlen itz'ja, bix nak'lx tu'n t-xi' k'it ttzii' jtja Dios. Oc cyk'o'n xjal tbi Cyeca Ttzi'yen, bixsen ncub kej xin xjal cox ttzii' tja Dios te kanl pwak tcotzxin cye xjal nchi ocx ttzi'yen. ");
INSERT INTO mamNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tejtzen tak' twitzj xin cox cyi' Pedro tuya Juan, ya ch'itk cyocxxin tuj tja Dios bix e xi' tkanenxin jun pwak tcotzxin. ");
INSERT INTO mamNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Cyiwc'a oc cycye'yen t-xel Jesús jaxin, bix e xi' tkba'n Pedro texin: —Ko tcye'c'a—tz̈i Pedro texin. ");
INSERT INTO mamNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Bixsen ocxix tk'o'n jxin cox tc'u'jxin cyi'jxin. Tujtzen twitzxin, ch'in pwak tu'n toc texin. ");
INSERT INTO mamNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero bix e xi' tkba'n Pedro: —Pwak mintii'ke k'i'n ku'n, mitetpe plata bix mitetpe oro. Yaa'n k'ina ko'ya. Keya k'i'n ku'n nuk ja tej keya kipemal o tz'oc tk'o'n Jesús Kajwalela. Tuya tzunja c'oquela konena jay. Tu'n tajwalel Jesús te Nazaret, jxin Scy'o'n tu'n Dios, cxe'ltzen nkba'n tey tu'n tjaw we'y bix tu'n tiy' beta—tz̈i Pedro texin. ");
INSERT INTO mamNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bix e tzaj ttzyu'n Pedro tk'abxin te tmank'abxin bix e jaw tii'n Pedro jaxin. Tujx naj tcywix ke tkenxin bix ke tmopxin. ");
INSERT INTO mamNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Bix e jaw lipenxin tej tjaw we'xin, bix ak'xin betel. Axsen e'la tuj twitzxin tjaw lipenxin bix tiy' bet-xin. Tzinxsen na'nxin Dios. Ju'tzen tten tocxxin tuj tja Dios tuya Pedro bix Juan. ");
INSERT INTO mamNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Cykil xsunj xjal tcub oc cyeyente jxin cox nbet-xin bix nk'o'nxin chjonte te Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nimxsen e jaw klee' ke xjal toc cycye'yen xjal jaj xin cox ncubxix ten ttzii' Cyeca Ttzi'yen te kanl tcotzxin. ");
INSERT INTO mamNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tejtzen cybaj na'nxin Dios, bixsen etzkexin twitz pe'n Salomón tbi. Yal tzunj xin otk tzul tnaabl, minxsen elxin cyi' Pedro tuya Juan. Yal cye xjal, tzinxsen chi klee' xjal, bix binxsen toc cychmon cyiib xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tejtzen toc cychmon cyiib xjal cyi' Pedro, bix e xi' tkba'n Pedro: —Key te ntanem te Israel, ¿tu'n tikentzen nimxsen nchi klee'y? ¿Tikentzen nim nchi klee'y oj nko oc cycye'yena jac'a xsunj nuk ku'n keya ma tzula tnaabl jxin coxa? Min bet texin tu'n jun keya kipemal, bix yaa'n nuk tu'nj nko na'na Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yaa'n ju' tewa. Tej ma baja tu'n Dioste, jaj xin Tdios Abraham, Tdios jxin kiy'jil Isaac, tej xin kiy'jil Jacob, bixsen cykil ke kiy'jil. Ja te Dios ma binchan te ja lu tu'ntzen t-xi' tyeec'anxin ka o jax tk'o'nxin Tcwalxin mas jawnex bix o txi' tk'o'nxin nim tipemal Tcwalxin. Jatzen Tcwal xinj Jesús, jaxj xin cyey e xi' cyk'o'n tej xin cawel Pilato tu'ntzen tbyet-xin, bix jaxj xin cyey el cyxoo'n, amale otket cub te Pilato tuj twitz tu'n tex ttzakpi'nxin Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jaj xin Scy'o'n tu'n Dios te cawel, jaj xin Jesús ba'n tanem, min e cycuyey. Pero tzunj xin byol xjal Barrabás, jatzen xin e cycuyey tu'n tetz tzakpet-xin. ");
INSERT INTO mamNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ju' tzunj ejee'y e byonte tej xin xjal tbeyel jchunk'lal te junx maj. Pero o jatz titz'jsa'n Dios jaxin. O kila o jatz itz'jxin. Ejoo'ya tstiwa. ");
INSERT INTO mamNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Bix lu tzunj xin xjal cox nejl lu, bix cytzki'na twitzxin, matzen tz'oc ke tc'u'jxin ti' tbi jxin Jesús, bix tu'ntzen tipemal tbi Jesús ma tzula tnaablxin. Tu'nj a tanemxin ti' Jesús, ju'tzen ma tzula tnaabl xina tisenxj tten n-oc cycye'yena. ");
INSERT INTO mamNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ke cyey te ntanem, weya ntzki'na ka minxix otk tz'el cyni'ya ti'j tuya ke cycawela ka ja Jesús Scy'o'nxix tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero amale otket cybinchey ka', yal te Dios max bint texin tu'n ti jilel tajxin, cuma at-xe k'ij cyyolbil-lente ke tyolel Dios ka tu'n tiy'x q'uixc'aj bix tu'n tcyim jxin Scy'o'n tu'n Dios. Jax o tz'e'la tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pero amale otket bint cyu'na cuma min cytzki'na ka jaxin Tcwal Dios, pero cyu'nx cyey. Ju' tzunj chi meltz'aja cycyaj meltz'aj tuya Dios, tu'ntzen tnajset cyila, ");
INSERT INTO mamNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","bix tu'ntzen tajtz tmeltz'u'n Dios jxin Jesús, Scy'o'n tu'n Dios, jaxj xin otk k'oj te cyey. ");
INSERT INTO mamNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero te lwewa naj ctemelxte Jesús tuj cya'j, ojxetzen tpon jk'ij te tu'n tbaj tninc'u'n Jesús cykilca nbaj twitz tx'otx', jaj e tkba Dios cye ke tyolel at-xe tyem. ");
INSERT INTO mamNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Cxe'ltzen nkba'n cyey tu'ntzen cymeltz'aja. C'ulelcaxixna tuj cyc'u'ja ti e tkba jxin kxe'chel Moisés: “Jatzente Kman Dios q'ueletz scy'o'nte jun tyolelxin tisenj weya cyxola ejee'y te Israel. Ja tzunxin c'oquel cybi'na bix cycuyey tyolxin. ");
INSERT INTO mamNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Al tzunj min ma tz'oc ebinte texin, junxsen maj q'uelel pax cyi'j te Dios t-xjal,” tz̈i Moisés tcyaj tkba'n—tz̈i Pedro cye xjal, tu'ntzen tel cyniy' xjal ti'j ka ti' Jesús nyolena Moisés tej tkbante xinj ju'wa. ");
INSERT INTO mamNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bix e xi' tkba'ntl Pedro: —Ju'xsen tten cyyolen cykil tyolel Dios, jatxe tuyaj xin tyolel Dios Samuel o tzaj bet tyem nyolj ti'j ti tten Jesús tzalu twitz tx'otx'a, tejxe taj Jesús tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ke cyey te ntanem, tisenx cyey bix tisenx keya, jatza e'la itz'j ko' cyi'j kej xin kxe'chel ootxa e yolen tej tyol Diosa. Ke cyey bix ko keya ejoo' tzunj cotzl tej tyol Dios e cyaj tk'o'n cyuya ootxa. Ju'tzen tten tcyajlen tkba'n Dios tyol tej xin itz'jsal kxe'chel, jxin Abraham: “Cykil ke tnom twitz tx'otx' cy'iwla'n chi temela tu'n jun cyey itz'j cyxol ke t-xe'chela,” tz̈i Dios te Abraham. ");
INSERT INTO mamNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ejee'y te Israel tneel tnom o tscy'o Dios tu'n tcy'iwlet tu'nj xin xjal, ba'n tcyaj cyk'o'na cyila. Ju' tzunj, cubsanx cywitza—tz̈i Pedro cye aj judío tuj nin tja Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro tuya Juan nchi yolenxxin cyuya xjal, tej cyul kej pala cye xjal judío cyẍklun cyiibxin tuyaj xin cycawel ke c'ojlal tuj nintzaj tja Dios, bix xsun kej xin tej cloj saduceo, ejee'xsen xinj min el jax tuj cywitz ka nchi jatz itz'jtl cyimne juntl maj. ");
INSERT INTO mamNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Otkxsen chi tzaj k'ojlxin cuma nchi xnak'tzan Pedro tuya Juan cye xjal, bix tuj cywitzxin otk tz'el cyipemalxin bix cuma nchi xnak'tzantzen Juan tuya Pedro ka cykil xjal cjawetz itz'j tisenx otk tyeec'an Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bixsen e cytzuyxin Pedro tuya Juan, bix ocx k'o'nkexin tuj tzee' texe juntl k'ij, cuma ya kaletl bix mintii'tl tyem tu'n t-xi' niq'uet ti' cyilxin, bixsen e cyaj t-xke stis texa juntl k'ij. ");
INSERT INTO mamNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero amale ju'te, nimxsen xjal cyxolj otk tz'oc ebinte tyol Pedro jax e'la tuj cywitz. Nukxix xinakc'a atle jwe' mil ocslal. ");
INSERT INTO mamNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tetzen juntl k'ij bix oc cychmon cyiibxin tuj Jerusalén ke cycawel xjal te judío, bix ke nintzaj tij, bix kej xin nmak tx'olbal ley, ");
INSERT INTO mamNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","tuyaj xin Anás, nintzaj tneel pala, tuyaxe cabtl te tjaxin, jaantzen Caifás, juntlxin Juan, bixsen Alejandro. ");
INSERT INTO mamNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bixsen e cykanenxin tu'n cypon Pedro tuya Juan cywitzxin tuyaxe jxin cox otk tzul tnaabl, bix e xi' cykanenxin cye Pedro: —¿Titzen tten toc cyk'anena ja xjal lu? ¿Altzen o tzaj k'onte cyipemala? ¿Altzen cyey o tz'oc k'onte cyajwalel tu'n toc cyk'a'nena jxjal lu?—tz̈itzen ke pala. ");
INSERT INTO mamNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pero te Pedro nimxsen tipemalxin tu'n Espíritu Santo, bix aj ttzak'be'nxin: —Key nin cawel bix xsun kej nintzaj xjal te Israel, ");
INSERT INTO mamNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kane nchi kanena keya ti'j ba'n ma tz'oc kbincha'na ti'j coxa, tu'ntzen cybintey ti tten tul tnaablxin, ");
INSERT INTO mamNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","chin ttzakpi' tzuna tu'n t-xi' ntx'olba'n cyey bix te cykil xjal te Israel, tej xin xjal lu o k'anj texin tu'n tipemal Jesús te Nazaret, jxin Scy'o'n tu'n Dios, jaxj xin cyey e cybiy twitz cruz, bix jaxj xin e jatz titz'jsa'n Dios tuj cyamecy. Tu'ntzen tajwalel bix tipemal jxin Jesús lu jxin xjala wa'lc'a kuyena cywitza ya ba'ntlxin. ");
INSERT INTO mamNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ti'j tzunj xin Jesús lu nyolena tyol Dios nbya'n tu'n cyjulu: “Ja tzunj xak ex cyxoo'n xjal binchal jaa', ja tzunja ma tzul meltz'aj tu'n toc te mas nintzaj xak te t-xee' jaa'.” Ejee'y tisen binchal jaa', bix ja xak mas nintzaj, jatzen Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tuj cykil twitz tx'otx', min-al juntl tisen Jesús ba'n kco'pj tu'n. Junx biybaj tjak' cya'j twitz cykil twitz tx'otx' o tz'oc tk'o'n Dios tajwalel te co'pl xjal, ja Jesús—tz̈i Pedro cye nintzaj xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tejtzen toc cybi'n nin cawel cyiw cyc'u'j Pedro tuya Juan nchi yolen, e jawxsen klee' ke xjal, cuma oc cycye'yen xjal ejee'xin nuk tisen yalx xjalkexin. Min otk chi xa'cx tuj scwela bixsen el cyniy' ke cawel ti'j Pedro bix Juan ka ejee'xin otk chi bet tuya Jesús, bix ju' tzunj nim ba'n cyu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bix cuma wa'lc'a tzunj xin otk tzul tnaabl, ju' tzunj mix e bina cyyolenxin ka' yol cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Entonces bix ex chk'etkexin tuj juntl cwart, bixsen e cyaj ke nin cawel te yolel cyjunalxxin. ");
INSERT INTO mamNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tz̈i tzunkexin cyjulu cyxolxxin: —¿Titzen kbincha cyuyaj xjal lu? Cykilxsen xjal te Jerusalén itzkilte ka ma tzul tnaabl xjal cox cyu'n. Mlay kewen. ");
INSERT INTO mamNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero jax mitetpe tu'n kcuyante tu'n t-xi' itz̈en cyxnak'atz cyxol xjal. Entonces tu'ntzen tbaj twi', chi oqueltzen ksiy'pu'n tu'ntzen te ja'lewe bix ma txi' bet tyem ya mi'n chi yolentl ti' Jesús te juntl xjal—tz̈itzen ke cawel. ");
INSERT INTO mamNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bixsen etz cytxco'nxin Pedro tuya Juan juntl maj, bix e xi' cykba'nxin: —Matzen txi' kkba'na cyey ya mintzentii'tl tu'n cyyolena bix tu'n cyxnak'tzana xjal ti'j Jesús—tz̈i tzunkexin. ");
INSERT INTO mamNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero bix aj ttzak'be'n Pedro tuya Juan: —¿Titzen cyey nxi' cybisen ti'j? Altzen cye mas jiquen twitz Dios, ¿japaj tu'n toc kbi'na ejee'y, bix ma jaj tu'n toc kbi'na Dios? ");
INSERT INTO mamNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yaltzen keya, mlay cyaj kk'o'na ti'jxe ti jilel o tz'oc kbi'na bix o tz'oc kcye'yena, cuma ju' toc tu'n Kman Dios—tz̈i Pedro tuya Juan. ");
INSERT INTO mamNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pero bix oc meltz'aj ke cawel te siy'pulec cyexin juntl maj tu'nx mi'n chi cub tenxin tz̈itpulte tpocbal Jesús. Yajc'atltzen bixsen e tzakpetkexin. Min e cub kexin tuj castiwa tu'n mintii' il baj, cuma cykilxsen xjal nchi k'on chjonte te Dios ti'j tik'ch otk baj. ");
INSERT INTO mamNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jxin xjal otk tzul tnaabl k'i'nxin mas te cya'wnak jnabk'i tej tiy' bet-xin tneel maj. ");
INSERT INTO mamNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tzinxix nchi tzakpet-xin, bix e xi' Juan tuya Pedro jaa' ta' jcabtlxin t-xel Jesús, bixsen e baj cykba'nxin tik'ch toc cyu'n tajwil na'l Dios bix ke tij xjal cyexin. ");
INSERT INTO mamNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tejtzen tbaj cybi'nxin, bixsen el cyniy'xin ti'j ka tu'n cyak'xin xnak'tzal cye xjal tjak' tc'ojlabatz ke cawel, bixsen ak'kexin te na'l Dios cyjulu: —Taat, jay Kaawa, ja tey e cub binchante cya'j, bix twitz tx'otx', bix mar, bix tik'ch at. ");
INSERT INTO mamNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jay e kbante tu'n Espíritu Santo tu'n tyol kxe'chela David tyolela: “¿Tikentzen n-oca cyk'on cyiib te nintzaj cykil tnom twitz tx'otx'? ¿Tikentzen nuk tik'ch nbaj cyniq'uen xjal ti' Dios? Mintii' q'uelela. ");
INSERT INTO mamNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ke nmak cawel twitz tx'otx' bixsen ke cawel cyuj tnom matzen tzak' oquel cychmon cyiib tu'n cyoc k'ojlxin ti' Dios bixsen ti'j xin Scy'o'n tu'n Dios te cawel twitz tx'otx',” tz̈i tzuna te tyolela David. ");
INSERT INTO mamNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bix jax ju'tzen nbaj. Tuj tnom lu, ja tzunj xin cawel Herodes bix xsunj xin cawel Poncio Pilato matzen tz'oc cymojban cyiibxin cyuya kej xjal judío bix xsun kej xjal yaa'n judío tu'n cyoc k'ojlxin ti'j xin sant Tcwala, jxin e tsicy'a te cawel. ");
INSERT INTO mamNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Cykil o baj cybincha'n, ja tzunja e tkbay ti jilel tu'n tbaj. ");
INSERT INTO mamNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bix ju'x nbaja. Kman Dios, cye'nctza ti nbaj ki'ja. Nko baj siy'pu'na tu'n nko tz̈itpuna tyola. Keectzen tc'u'ja ki'ja tu'ntzen mi'n tzaj ttz̈i ki'ja oj t-xi' kyolena tyola. ");
INSERT INTO mamNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nuksama, tu'ntzen tipemala tzula cynaabl yaab tu'n toc cybi'n xjal tyola. K'ontza mas tipena keya tu'n tcub kbincha'na mas techlala cywitz xjal, tu'n tipemal Tcwala Jesús—ju'tzen tten cyna'n t-xel Jesús te Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tejtzen cybaj na'nxin Dios, bixsen e tzaj yucch jaa' jaa'j cychmona cyiibxin. Bix oc nim cyipemalxin tu'n Espíritu Santo tu'ntzen k'uklxix cyc'u'jxin oj t-xi' cykba'nxin tyol Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yaltzen cye ocslal, cykilxsenke cychmon cyiib tuya cykil cyanem. Min-alxsen jun e kbante ka nuk cye tik'ch cye, sino e baj cypa'ncye xjal tuya juntl wik la' ti tcyajlalel ete'. ");
INSERT INTO mamNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yaltzen ke t-xel Jesús, tuyaxsen nim cyipemalxin t-xi' cykba'nxin ti tten tjatz itz'j Jesús tuj cyamecy. Bix enterax ke ocslal e ten tjak' t-xtalbil Dios bix tuj ttz̈yal. ");
INSERT INTO mamNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Minxsen-al jun ocslal e ten tuj tcyajlal, cuma alcyej at cytx'otx' bix ma at juntl cyja, bix e xi' cyq'ueyen, bix e tzaj cyii'n twi'. ");
INSERT INTO mamNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Cye t-xel Jesús, tu'n tcub cypa'nxin cywitz mebe la' ti' tcyajlalel ete'. ");
INSERT INTO mamNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tisen tzunj junxin xjal José tbi, jaxsen xinj n-oc tbi cyu'n t-xel Jesús te Bernabé, jatzen elpeninaj “nimsal cyanem xjal.” Jatz elnina itz'jxin cyxol xjal levita. Jatzen itz'jaxin tuj jun lugar Chipre tbi. Jatztzen najlaxin Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ja tzunj xin José e xi' q'ueyente jun ttx'otx'xin, bix e xi' tk'o'nxin twi' cye t-xel Jesús tu'n tajben cyexin. ");
INSERT INTO mamNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero attzen junxin xjal min e cub tpa'nxin tik'ch texin tuya cykil tc'u'jxin. Ananías tbixin, bixsen t-xu'lxin Safira tbixuj. Bixsen e xi' cyq'ueyenxin jun cytx'otx'xin cyca'belxin. ");
INSERT INTO mamNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bixsen e cub cyniq'uenxin tuya t-xu'lxin tu'n tcyaj cyii'nxin jun tkiy' ti'j twi' cytx'otx'xin, bixsen e cub cyu'nxin tu'n t-xi' cykba'nxin cye t-xel Jesús ka cykil twi' tx'otx' toclel cyk'o'nxin cyexin. Entonces bixsen e xi' Ananías k'olte tej jun tkiy' twi' tx'otx', bix e xi' tk'o'nxin cye t-xel Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pero bix e xi' tkba'n Pedro te Ananías: —¿Tu'n tikentzen ncwa' tc'u'n tey juntl tkiy' twi' jtx'otx'a te tey? Jma tzaj tk'o'na keya nuk tisenc'a cykil twi' tx'otx' ma tzaj tk'o'na keya. Yaltzen tey matzen ẍtak'ena twitz Espíritu Santo. ¿Tu'n tiken ma tz'oca tbi'na ti jilel ma tz'oc tk'o'n taaw il Satanás tey? ");
INSERT INTO mamNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mintii'xix te il ti'j tu'n t-xi' tq'ueyena ttx'otx'a. Bix ka taja t-xi' tq'ueyena, ja tey taaw. Te tey, bixet t-xi' tc'u'na cykil twi' ttx'otx'a, cuma tey. ¿Pero tu'n tikentzen xcwa' tbisena ti'j tu'n tcub tyajla'na ejoo'ya cyjulu? Pero jaxxix min ma ẍtak'en tey twitz xjal, sino twitz Dios—tz̈i Pedro te Ananías. ");
INSERT INTO mamNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tejtzen toc tbi'n Ananías kej yol ju'wa, bix e cub tz'akxin cyimnetlxin twitz tx'otx'. Cykilxsen xjal oc ebinte ti otk baj te Ananías, bixsen oc ttz̈i cyi' xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yajc'atltzen bix ul cabk'a xjal tuya jun sábana, bix iy'x cymaksi'nk'a t-xumlal cyimne tuya, bix iy' cyii'nk'a te mukbil. ");
INSERT INTO mamNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Otktzen bint oxe hora tej tocpan jxuj Safira, t-xu'l jxin cyimne. Mintii' tumel tuyaxuj ti otk baj. ");
INSERT INTO mamNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bix e xi' tkanen Pedro texuj: —Kbantz we, jpwak ma tzaj cyk'o'na keya, ¿cykilpa twi' jtx'otx' ja lu?—tz̈i Pedro. —Jaxte cykilte twi' tx'otx'—tz̈i Safira. ");
INSERT INTO mamNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Entonces bix e xi' tkba'n Pedro: —¿Titzen tten ma chi ẍtak'ena twitz Dios? Yaltzen ja'lewe, ebin xsunj alj tzul beta. Lu tzajne tzaj nkayena ejee'j k'a xjal ẍi cu'x mkunte tchmila. Bix ju'x tey, ejeexk'a chi xe'l k'inte tey tuj mukbil—tz̈i Pedro texuj. ");
INSERT INTO mamNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tzinxix nxi' baj tkbante Pedro ju'wa, tzin ncub tz'ak Safira t-xee' tken Pedro cyimnentlxuj. Tejtzen cyocpan jk'a xjal, cyimnenxuj toc cycye'yenk'a. Jax bix etz cyii'nk'a jaxuj te mukbil, bix e cu'xxuj ttxlaj tchmilxuj. ");
INSERT INTO mamNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Cykil xsunj xjal te tja Dios, bix cykilkej ebin tej ju'wa bix xsun kej oc cyeyente tcyamecy Ananías bixsen t-xu'lxin Safira tu'n cyẍtak'bil, nimxsen ttz̈i e cub cyi'j xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nimxsen techlal bixsen k'anj ke xjal e bint cyu'n t-xel Jesús cyxol xjal. Bixsen ke cye ocslal jaca k'ij nchi chmet tuj nintzaj tja Dios, twitz tpe'n tunwen Salomón tbi. ");
INSERT INTO mamNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yal tzun kej xjal yaa'n ocslal, tej tcyim Ananías tuya Safira cywitz t-xel Jesús, bix e tzaj ttz̈i cyi' xjal kej xin t-xel Jesús, pero nim oc cybi'n xjal ejee'xin. Pero chebe ak'ke xjal ebil cyyolxin, bix oc ke xjal ocslal. ");
INSERT INTO mamNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pero mixsen jtoo ju'wa. Nimxsen xjal ak' ebilec tyol Jesús, xuujle, xinakle. ");
INSERT INTO mamNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tu'ntzen nim techlal e bint cyu'n t-xel Jesús, nimxsen tpocbal el, hasta etz cyii'n xjal ke cyyaab tuj be twitz wetbil, twitz pop, tu'ntzen oj tiy' bet Pedro tuj be, amatzen nuk t-xlequemal Pedro tziy' cyibaj yaab, tu'n tul cynaabl. ");
INSERT INTO mamNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jax ju'x cyuj nim tnom ttxlaj Jerusalén, nimxsen xjal ul Jerusalén, k'i'ntzen ke yaab cyu'n, bix xsun kej otk tz'oc biman cyi'j. Cykilxsenke ul cynaabl. ");
INSERT INTO mamNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pero tejtzen toc cycye'yen nimxsen xjal lepchec cyi' t-xel Jesús, bixsen oc chi'l jxin tneel cawel cyibaj pala tuj nintzaj tja Dios, bix xsun kej xin at tuyaxin, bix kej xin saduceo. ");
INSERT INTO mamNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tu'ntzen tchi'lel cyc'u'jxin bix ex cysma'nxin tu'n cytzyet ke t-xel Jesús, bix ocxkexin tuj tzee' cywitz xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero tejtzen tcub klolj, bix e pon jun tsanjel Dios e tzaj tuj cya'j, bix el tjko'nxin tlemel tzee', bix etzkexin, bixsen e xi' tkba'n tsanjel Dios cye t-xel Jesús: ");
INSERT INTO mamNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Cyix cyxi'y. Cyocxsen tuj nintzaj tja Dios, bix mi'n baj cyc'u'ja tu'n cyk'umenxsen ti ttenj ac'aj chunk'lal tuya Dios, bix ti elpenina—tz̈i tsanjel Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tejtzen toc cybi'n t-xel Jesús, tetzen klaxc'a, bix ocxkexin tuj nintzaj tja Dios, bix ak'kexin xnak'tzalec cye xjal. Jooc'tzen nbaj, tchmonte tneel pala tiib cyuya nintzaj consejo te ni'c'ul cyley tuj cyreligión judío tujx jjaa' jaa' n-oca cychmon cyiibxin. Bixsen e tzaj cytxco'nxin kej xin nintzaj tij cyxol xjal judío. Tejtzen tbaj cychmon cyiibxin, bix e xi' ik'bajkexin tuj tzee' tu'n cypon jxin t-xel Jesús cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Entonces bixsen e xi' ke cypolicía nintzaj xjal te k'il cyexin, pero tej cypon policía, min-altlkexin tuj tzee'. Bixsen ajtzkexin te kbalte cyuya pala cyuya consejo. ");
INSERT INTO mamNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Bix e xi' cykba'nxin cye cawel: —Kej tlemel tzee' jaa' ete'cxa kej pres jpu'nte, bix ke c'ojlal nchi c'ojlan cyexin pe'n. Pero tejtzen tocx kjko'na tzee', min-altl tocx tunwen—tz̈itzen ke policía cye cawel. ");
INSERT INTO mamNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tejtzen toc tbi'n jxin cawel cyibaj c'ojlal tja Dios bixsen tneel pala, e jaw klee'kexin, bix ak'kexin kanlte te cyeeylexxin ti otk baj, bix ti tten oj tel tpocbal. ");
INSERT INTO mamNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pero lwewa ul naj jun xjal bix ocx kbet cyexin: —¡Cycye'yentz! Kej xjal ocx cyk'o'na tuj tzee', lu ke nchi xnak'tzan ja'lecuwe tuj nintzaj tja Dios—tz̈i tzunj xjal cye ke cawel. ");
INSERT INTO mamNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Toctzen cybi'n xin jcawel cyibaj c'ojlal tja Dios ju'wa, ja tzunj xin cawel cyuya cabtl c'ojlal bix e xi'kexin jaa' ete' t-xel Jesús, tu'ntzen cytzaj k'i'nxin cywitz nintzaj cawel. Pero min ocxix tenke c'ojlal yajlalte cyexin, cuma cytz̈i xjal cyi' c'ojlal. ");
INSERT INTO mamNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tejtzen cyul k'i'nxin, bix e cub wabatkexin cywitz consejo. Bixsen e xi' tkanen tneel pala cyexin: ");
INSERT INTO mamNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Cyiw o txi' kkba'na cyey tu'n mi'n chi yolena ti' Jesús. ¿Pero titzen ma cybinchey? ¡Jun wikxitl ma cybinchey! Ma tz'ex baj ttz̈itpuj tyol Jesús cyu'na tuj cykil Jerusalén. Yaa'ntzen o'cx ma tz'oca cyu'na, sino cyaj tzuna tz'oc cyk'o'na te kiketzen cyimlen jxjal Jesús—tz̈itzen tneel pala cye t-xel Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pero bix aj ttzak'be'n Pedro tuyaj cabtlxin t-xel Jesús: —May'te, taat, ma bint ke ku'n ti jilel o cykbay keya. Pero keya te ke, ja tej tyol Dios mas il ti'j twitz cyyol xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ja Dios, jaj xin Cydios kej xin ootxa kxe'chel, jatzen xinj e jatz itz'jsante Jesús tuj tcyamecy. Pero ejee'tzen cyey xjal, ejee'tzen cyey e binchante tu'n tcubxin, bix e cubxxin cyu'na twitz cruz tisen jun nuk yalx xjal byol. ");
INSERT INTO mamNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pero tej xin Jesús oc cycye'yena tisen jun byol, jatzente xjalj o jax tii'n Dios tuj cya'j. O cub kexin tuj tmank'ab Dios, bix o tz'oc nim tajwalelxin tu'n Dios. O tz'ocxin te mas nintzaj cawel cye xjal, bix co'pl xjal, tu'ntzen ba'n cyco'pj xjal te Israel tuj cyil. Bix ka ma chi etza tuj cyila, chi co'pjel cyey tuj cyila. ");
INSERT INTO mamNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Keya jaxxix ke kyol, bix ba'n tu'n Espíritu Santo kyola, cuma la' alj ma tz'oc ebinte tyol Dios, ntzaj tk'o'nte Dios Espíritu Santo te cycotz—tz̈itzen ke t-xel Jesús cye cawel. ");
INSERT INTO mamNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tejtzen toc cybi'n ke cawel tuj consejo kej yola, bix e tzaj k'ojlkexin nim. Tu'ntzen tchi'lel cyc'u'jxin cyajxin e cub cybyo'nxin ke t-xel Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero cyxoltzen nintzaj consejo at jun tij xjal tej cloj fariseo, kej xin nimal tuj tley Moisés. Jxin xjal Gamaliel tbixin. Gamaliel tx'olbal leyxin, bix ebi'n xsunxin cyu'n xjal. Ja tzunj xin Gamaliel bix e jaw we'xin cyxol ke tuyaxin, bix e xi' tkanenxin tu'n tyolenxin. Bix e xi' tkba'nxin tu'n cyetz k'i'n t-xel Jesús jun tkiy' tu'ntzen mi'n tz'oc cybi'nxin ti' tyol Gamaliel. ");
INSERT INTO mamNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Entonces bixsen e xi' tkba'n Gamaliel cyej cabtlxin tuyaxin: —Key te ntanem Israel, cxe'lxix cycye'yena ti chi temeley cyuyaj xjal lu. ");
INSERT INTO mamNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tzulc'axna tuj cyc'u'ja ma bint cab tyem jxin Teudas ocxin te nintzaj xjal, bix oc meltz'ajxin k'ojlel ti' gobierno tuya cyaja syent xjal. Pero cwax tbyet Teudas. Yal tzun kej oc lpe ti'j, bix el tz̈itjke, bix e baj twi'. ");
INSERT INTO mamNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ju'x e baj tuyaj xin Judas tuj Galilea. Te tzun kej k'ij tej njaw tumel tajlal xjal tu'n gobierno, bixsen oc k'ojlkexin ti' gobierno cyuya ke tuyaxin. Pero cwax tcubxin bix cykilca kej xjal oc lpe ti'jxin el tz̈itj. ");
INSERT INTO mamNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ch'innch'etzen ju'x pjel te ja lu. Ju' tzunj cxe'l nkba'n cyey tu'n mi'n chi cub cybyo'na, cuma ka yaa'n te Dios cyaak'en, ka nuk cyex, cykil pjel twi', tisen e baj cyej xjal ma txi' nkba'n cyey. ");
INSERT INTO mamNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero ka jax te Dios cyaak'en ncub bint, mlayx bint cyu'na tu'n tcub cybajsa'na. Cyk'o'ncxix cyc'u'ja ti'j mi'n tz'oc cyk'on cyiiba te k'ojlel ti' Dios—tz̈itzen Gamaliel cye ke nintzaj consejo te stis. ");
INSERT INTO mamNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Cykil xsunkexin oc ebin tej tyol Gamaliel. Entonces bixsen e tzaj cytxco'nxin ke t-xel Jesús juntl maj, bixsen el k'i'nke cyi'jxin, bixsen e xi' nim tz'u'n cyi'jxin. Bix juntl maj e xi' kbet cyexin tu'n mi'n chi yolenxin mas ti'j Jesús. Yajc'atltzen bix ex tzakpetkexin. ");
INSERT INTO mamNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Entonces bix etz ke t-xel Jesús cywitz nintzaj consejo te stis cyxol xjal judío. Axsen ttz̈yal cuma otk tcuya Dios tu'n tiy'x cawbil cyu'nxin nuk ti'jc'a Jesús. Ba'nxsen e'la tuj cywitzxin. ");
INSERT INTO mamNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bix min oc cybi'nxin cyyol cawel, sino jaca k'ij iy'kexin ttzii' cyja xjal, bixsen tuj nin tja Dios e kbankexin ti'j ti tten Jesús, jxin Scy'o'n tu'n Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yaltzen tajlal ocslal, tz̈'iynax ttz̈'iy. Pero maatkxsen txolen ttz̈'iy, attzen jun yol e jaw. Attzen ocslal judío cye chi yolen tuj cyyol xjal griego, bix atl judío ba'n yolen tuj hebreo. Cyxol jca'ba cloj xjal at nim viuda. Ejee' tzunj xuuj viuda bix e baj paax cywa jaca k'ij. Pero ejee' tzunj viuda aj griego octzen cykanbil xjal ka yaa'n ju'x tken cywa n-etz tisenx kej xuuj aj hebreo. Ju' tzunj e jaw jun k'oj. ");
INSERT INTO mamNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Entonces bixsen oc chmet cykil ocslal tu'nj cablajaj xin t-xel Jesús, bix e xi' cykba'nxin: —Cyajtzen cyey ejoo' keya ko xe'l ninc'unte cyey cyk'oj. Pero yaa'n ba'n tu'n tcyaj kk'o'na kxnak'atza nuk tu'n ejoo'ya ko xe'l pa'n te cyway. ");
INSERT INTO mamNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ju' tzunj, key ocslal, cyjyonxa wuuk xinak cyxola te ninc'ulte cyey. Ja tzunj wuuk xjala c'oquelxix ke cyc'u'j xjal cyi'j bix c'oquelxix cybi'n xjal ejee', bix cbinelxix cyu'n, bix ejee'j ebilte Espíritu Santo. Ojtzen tcnet wuuk xjal tisenj nxi' kkba'na cyey, ejoo'tzen keya ko oquel wa'bencye ti'j ja ak'untla te pa'lte cyway. ");
INSERT INTO mamNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yaltzen keya, cxe'lx kii'nke kaak'en te na'l Dios bix te kbalte tyol Dios—tz̈itzen ke t-xel Jesús cye ocslal. ");
INSERT INTO mamNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Cykilxsen ke ocslal oc ebinte ju'wa. Bix etz scy'et ja wuuk xjal lu: Esteban, junxin xjal axsen tanemxin ti' Dios, bix nuk ebilxxin ti' Espíritu Santo, ju'x jxin Felipe, jxin Prócoro, jxin Niconor, jxin Timón, jxin Parmenas, bixsen Nicolás, jun xjal te Antioquía nejl ocslalxin ti' cyreligión judío, pero ya otk tz'ocslanxin Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Cykil tzun kej xin lu e pon cywitz t-xel Jesús bix e baj na't Dios cyibajxin, bixsen oc cyajwalelxin tu'nj tcublen cyk'ab t-xel Jesús cyibajxin. ");
INSERT INTO mamNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ju'tzen tten tbinlen ke ocslal te Dios, bix xi'ne e xi' tz̈'iy. Tyol Dios e xi' tz̈'iy cyxol xjal, bix jawnexsen e jaw tken tajlal ocslal tuj Jerusalén, bix nimxsen pala cye judío e cub cych'ixbe'n cynaabl tu'n oc ke cyc'u'jxin ti' Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ja tzunj xin Esteban nimxsen tipemal Dios at tuyaxin, bix nim xtalbil tibajxin, bix jax nimxsen techlal tipemal Dios e bint tu'nxin cyxol xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero attzen cabxin oc ten cyakwusalecte Esteban, bix e k'ojlke tuya Esteban. Ejee' tzunj xin oc k'ojl ti' Esteban, te jun camon jaa' te xnak'tzabl tyol Dioskexin jaa'j e chmeta kej xjal otk chi tzakpet tuj ak'untl tjak' tcawbil Roma. Jatzen otk chi tzaa'xin tuj tnom te Cirene, Alejandría, bix Cilicia, bixsen tuj ttx'otx' Asia, tu'n cyponxin tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ejee' tzunj xin lu e k'ojlkexin tuya Esteban, pero mix e xcyebake ti'jxin, cuma texin e yolenxin tuya tonbil Espíritu Santo. ");
INSERT INTO mamNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Entonces tu'ntzen tchi'lel cyc'u'jxin, bixsen oc cychjo'nxin tuj ewjel cabtl xjal tu'ntzen tbaj bint ẍtak'bil ti' Esteban tisen ka otk tz'oc cybi'nxin tyol Esteban ka' ti' Moisés bixsen ti' Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ju'tzen tten tbaj cyxtz'imenxin cywitz xjal bixsen ke tij xjal bixsen ke tx'olbal ley. Bixsen e cytzuyxin ja Esteban, bix e xi' k'i'nxin cywitz ke nintzaj cyconsejo judío. ");
INSERT INTO mamNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bixsen e pon kej xin ẍtak' tstiwa, bix e cykbaxin ka min cyaj tyolen ka' yol Esteban tibaj tja Dios bixsen ti' tyol Moisés. ");
INSERT INTO mamNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bixsen oc tyol Esteban te cysakchbilxin. Tz̈i tzunkexin cyjulu: —O tz'oc kbi'na tyol xjal lu ka jxin Jesús te Nazaret cwel t-xitenxin nin tja Dios bix ctch'ixbe'xin jcostumbre o cyaj tk'o'n Moisés—tz̈itzen ke ẍtak' cye cawel. ");
INSERT INTO mamNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yaltzen ke cawel, bixsen ke cykil kej xjal k'ukl, occa cycye'yen xjal ja Esteban. Pero tej toc cycye'yenxin twitzxin, nkoptz'ajxsen twitzxin tisenxsen twitz jun tsanjel Dios tuj cya'j. ");
INSERT INTO mamNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Entonces ja tzunj xin pala nintzaj cycawel cyibaj mas pala cyxol xjal judío e xi' kanente te Esteban: —¿Jaxpa ka ma tz'oc meltz'aja ti' tley Moisés? Jatzen cykanbil xjal jti'ja, ¿jaxpa?—tz̈i tajwil na'l Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Bix aj ttzak'be'n Esteban: —Cybintza, taat, key te ntanem, cybintz ch'ina jun rato. Wajtzen txi' ntx'olba'n ch'in ti'j nbint tu'n Dios ti' kloq'uel bix cyi' kxe'chel ootxa, bix ti'j ox chi cub tzpet kloq'uel tuj taj Dios bint. Tneelxsen cxe'l nkba'n ti'j jxin kxe'chel Abraham. Tej i'tzx Abraham tuj ttx'otx' Mesopotamia, ja tzunj xin nintzaj Kdios el jlet twitz Abraham tisen cyey cytzki'ntla. ");
INSERT INTO mamNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Bix e xi' tkba'n Dios te Abraham: “Abraham, k'onj ttx'otx'a bixsen alkch te tjay, bix ctexsen tzalu, bix lpetztzen wi'j tuj tx'otx' cxe'l nyeec'an tey,” tz̈i Dios te Abraham. ");
INSERT INTO mamNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Bix etz Abraham tuj ttx'otx' Mesopotamia, juntl tbi Caldea. Pero tejtzen tponxin tuj Harán, bix e cyajxin cab k'ij jatzewe. Cwa tcyim tmanxin tuj tnom Harán. Mas yajtl, bixsen iy'tii' Dios jaxin tuj ttx'otx' Canaán, jaa' tcwa' Israel ja'lewe, jaa'j najla ko'we. ");
INSERT INTO mamNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yaltzen ja'lewe, ketltzen, pero tej k'ij tej tul Abraham, pero mi nuketpe jun bara oc tetzen Abraham. Mitkx n-oca tk'o'n Dios texin. Pero otk txi' tkba'n Dios texin tu'n tcub tcmo'nxin, bix la' altzen cye k'ij tetzen ke tchmanxin tu'n cyeke tisen cycotz. Bix e tkba te Dios ja lu jatxe tej min-alte Abraham tcwal. ");
INSERT INTO mamNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Bix jax e xi' tk'o'n Dios juntl tumel te Abraham: “Kej tey t-xe'chel chi najalcye tuj juntl tx'otx'. Cyaja syent jnabk'i chi najal tey tloq'uel jatzewe. Chi ak'analcye, pero mintii' chojbilcye. Chi ak'anal nuk cotz. Tetzen t-xel twi' cyc'u'j, jatzen cyiik'el jnimxsen ka' c'oquel cybinchen xjal cyi'j. ");
INSERT INTO mamNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero cwax oj cyetz jatzewe, bix chi altz meltz'aj tuj ja tx'otx' lu juntl maj, tu'n cyajben we. Yal tzun kej xjal c'oquel binchen tej ka' cyi'j tcwala, inayenxsenwe chin cwel k'onte il cyibaj,” ju'tzen toc tu'n Dios te Abraham tej tpon Abraham tuj tx'otx' otk tz'oc oyet texin. ");
INSERT INTO mamNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bix tu'ntzen tcyaj kej yola tuj chic'aj, bixsen e cub bint jun tyol Dios tuya Abraham. Jatzen cyyolxin e cub bint, jatzen Abraham cyuya ke t-xe'chel, ke xjal te Israel, cyocleltzen te t-xjal Dios. Yaltzen te Abraham, cyuya ke tcwal, t-xi'leltzen tyeec'anxin techlal tyolxin, teltzen keset ttz'umel twi' cytz'albil jxjal xinak. Ju' tzunj tej titz'j tcwal Abraham, Isaac, bix el tkesenxin ttz'umel twi' ttz'albil Isaac te wajxak k'ij titz'jlen. Jaxsen ju'x te Isaac tuya tcwal Jacob, bix ju'x e tse Jacob tuyaj cablaaj tcwalxin. Ejee' tzunj cablajajxin tcwal Jacob e cub itz'jsante jcablajaj cloj xjal te Israel, tisen cyey cytzki'ntla. ");
INSERT INTO mamNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jatzen jun xin cyxol jcablajajxin itz'jsalcatej, jxin José. Otkx tzaj texin te co'pl t-xjalxin tuj weyaj. Pero yaa'ntzen telniy'xin ka ju' xina, sino el xoo'nxin. Yaltzen ke ttzicyxin tzinxsen nk'ak'en cyanemxin tuya tchi'lel cyc'u'j, bix e xi' q'ueyet-xin cye xjal te Egipto tu'n tak'ananxin nuk cotz. E bint cyu'nxin ju'wa cuma jaxin achen tu'n cymanxin cywitzxin. Ju'tzele tewa. Pero atte Dios tuya José. ");
INSERT INTO mamNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Pero cwax tco'pjxin tuj il, bix e tak' Dios nim tu'n tiy' tilbilxin ti'j, bix e tak' Dios texin tu'n tten t-xtalbil cawel te Egipto ti'jxin, bix ocxin te tcab cawel tibaj cykil ttx'otx' Egipto tu'n nin cawel. Bix oc tk'o'n cawel tajwalelxin tu'n tcawenxin tibaj tja cawel. ");
INSERT INTO mamNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Entonces bixsen e tzaj weyaj tibaj cykil ttx'otx' Egipto. Jaxsen tyemj tul weyaj tibaj Canaán, jaa'j najla ttzicy José, ke kchman ootxa. Cyiwxsen cychunk'lalxin tu'n weyaj. Min e cnet cywaxin. ");
INSERT INTO mamNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero tejtzen tbintte Jacob tumel ka at triwa tuj Egipto, bixsen e xi' tchk'o'nxin ke tcwalxin te lok'olte. Ju'tzen tten cyxi'len ke ootxa xjal te tneel maj cykenxin te lok'ol waabj tuj Egipto. Jatztzen e pona cnet José cyu'nxin. Pero min el cyniy'xin ti' José. ");
INSERT INTO mamNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Eltzen cabtl xjaw, bix e baj cywaxin tuj Canaán. Iltzen ti'j tu'n cyxi'xin Egipto juntl maj. Entonces bix e xi'kexin te tcab maj. Te tzunj juntl maja, bixsen e tyeec'a tiib José cye ttzicy. Bix te xsunja maj lu tej tel tniy' cawel ti' José te jaa'xin, bixsen el tniy'xin ti'j jaa' elnina itz'j José. ");
INSERT INTO mamNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Bix ajtz meltz'aj ke ttzicy José Egipto tu'n cyponxin tuj Canaán. K'i'ntzen jun txoquen José cyu'nxin tu'n cyxi'xin cykilke te cyjaxin najal tuj Egipto. Tejtzen cyul meltz'ajxin te toxen maj, bixsen e xi'kexin cykilcakexin, atle ama nuk oxc'al tuya olajaj xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ju'tzen tten tpomlen Jacob najal Egipto, bix jatztzen e cyma' xina. Bix tujtzen Egipto e cyma' José, bixsen ke ttzicyxin, ejee'tzen kxe'chel te ootxa. ");
INSERT INTO mamNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tejtzen cybaj cyimxin, bix aj k'it cyxumlalxin mas yaj tuj ktanem. Tzalutzen moku'nakexin tuj cyjayelxin otk tlok' Abraham. Otk tz'el tlok'o'nxin te junxin xjal Hamor tbixin, tej tnom te Siquem, tisen cyey cytzki'ntla. ");
INSERT INTO mamNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ke ootxa xjal e najankexin nim tyem tuj Egipto. Bix e tz̈itpajkexin, bix tij e tz̈'iy xsunkexin. Pero cwax tpon tyem tu'n tbintj otk toye Dios te Abraham, tu'nx cyaj meltz'aj ke kchman ootxa tujx ke ktx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pero tuj xsunj tyem lu attzen junxin cawel tibaj Egipto, junxin cawel min ul José tuj tc'u'jxin, bix min oc tbi'nxin tyol José. ");
INSERT INTO mamNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ja tzunj xin cawel lu nimxsen e baj tyajla'nxin bix nimxsen tcyajlal i'ya ke kchman tu'nxin. Bix oc tlomo'nxin ke xjal tu'n tcyaj cycye'yen ke cycwal xinak, tu'ntzen cycyim ke nee' ac'aj xinak txolen cyitz'j. ");
INSERT INTO mamNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tuj tzunj tyem lu tej titz'j Moisés. Jun nee' cwal na'n twitz Dios, bix nee' cyeca xsunxin, bix el ewet-xin tunwen cyu'n tmanxin te oxe xjaw. ");
INSERT INTO mamNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pero cwa tpon jk'ij tu'n ya mixben tcub ewetl nee' cwal, bix e pon jk'ij tu'n tcyaj cyeyet. Pero jatltzen tmeel cawel tibaj Egipto iy' k'inte, bix oc tz̈'is̈entxin nee' tisen jun taltxin. ");
INSERT INTO mamNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ju'tzen tten t-xnak'tzetlen Moisés tuya tik'ch ba'n tu'n Egipto. Bix tejtzen tocxin ma xjal, axsen jun yolenxin, bix nimxsen e bint tu'nxin. ");
INSERT INTO mamNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Attzen jun k'ij ya nukxix n-elactlxin twi' cya'wnak jnabk'i, bix ul tuj tc'u'j Moisés tu'n t-xi'xin k'olbelcye te ttanemxin, ke te Israel, jatzex najlake Egipto. ");
INSERT INTO mamNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pero tejtzen tponxin tuj lugar, bix oc tcye'yenxin nimxsen il ni'ya cabtl te ttanemxin tu'n junxin te Egipto. Toctzen tcye'yenxin, bix e tzaj k'ojlxin, bix e cub tbyo'nxin jxin aj Egipto. ");
INSERT INTO mamNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Jatzen tuj twitz Moisés tel-leltzen cyniy' te ttanemxin ti'j ka tu'nxin tel-leltzen tco'pan Dios ke te ttanemxin tuj cyk'ab aj Egipto. Pero min el ba'n tuj cywitz aj Israel. ");
INSERT INTO mamNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tetzen juntl k'ij bix e xi' Moisés k'olbelcye xjal te Israel juntl maj. Pero te tzunja juntl maj lu, bix oc tcye'yenxin ca'ba te ttanemxin nchi k'ojl cyil cyiibx cyiib. Taj tzunxin e cub tpa'nxin ejee', bix e xi' tkba'nxin cye cyjulu: “Key taat, mixben cyk'ojl cyey cyjulu, cuma te cytanem cyiiba. ¡Mi'n chi k'ojla mas!” tz̈i Moisés t-xi' tkba'n cyexin. ");
INSERT INTO mamNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pero tzunj juntlxin toc pjulec tej juntlxin, bix ex tlomo'nxin ja Moisés, bix oc tkba'nxin te Moisés: “¿Al tey ma tz'oc k'onte te cawel keya kibaja? ");
INSERT INTO mamNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Tajpey chin cub tbyo'na tisenj e tsey jxjal aj Egipto ewe?” tz̈ixin te Moisés. ");
INSERT INTO mamNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Toctzen tbi'n Moisés ju'wa, bix el tniy'xin ti'j ka otk tz'el niy' ti'jxin ka jaxin otk cub byon tej xin aj Egipto. Bix el okxin. Bix e ponxin tuj ttx'otx' Madián. Jaxsen e temaxin jtisen jun te nakch xjal. Bix e majexin tuya jun xuuj te Madián, bix itz'j ca'ba tcwalxin. ");
INSERT INTO mamNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Exsen cya'wnak jnabk'i. Attzen jun k'ij ncylen Moisés tuj chk'ajlaj nka ta'j witz Sinaí, tej t-xi' tcye'yenxin jun wi' ch'i'x njulen tuya k'ak'. Bix e jaw jlet jun tisenc'a jun tsanjel Dios tuj tken k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tejtzen toc tcye'yen Moisés, e jawxsen klee'xin, bix e xi' lk'exin te cyey'lecte nka tu'n tocxix tcye'yenxin tixix tten. Pero tujtzen tken k'ak' etza tyol Dios. Tz̈i tyol cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Inayenwe Jcydios ke cychmana, Tdios Abraham, Tdios Isaac, bixsen Tdios Jacob,” tz̈itzen tyol Dios. Tejtzen toc tbi'n Moisés tuj twi' Dios, bix e jaw lu'lenxin tu'n ttz̈i. Ya min ocxix tcye'yentlxin tken k'ak'. ");
INSERT INTO mamNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pero te Dios, bix ak'x texin yolel: “K'imal ke t-xaaba tu'n ttzaj tyeec'ana mas tanema we tuj ja lugar lu, cuma ja tx'otx' jaa' tcwa'y xjan tx'otx' teja. ");
INSERT INTO mamNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Cxe'l nkba'n tey ma tz'oc ncye'yen ti' tka'yel ete' nxjal te Israel tuj cyk'ab xjal te Egipto. O nbi tzinxsen nchi kanen xtalbil, bix matzen chin tzaj te co'plcye. Pero tuya tonbila chi co'pjela. Quixtetzen. Matzen txi' nsma'na Egipto,” tz̈i Dios te Moisés—tz̈i Esteban cye cawel tuj consejo. ");
INSERT INTO mamNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Bix ak'x Esteban kbalte: —Key taat, ja xsunj xin Moisés lu el cyxoo'n xjal te Israel tuya cyyol cyjulu: “¿Altzen ma tz'oc k'onte tey te cawel keya kibaj?” tz̈i tzunkexin. Bix jaj xsunj Moisés lu e cyaj tk'o'n Dios tajwalel te cawel bix te co'pel cye xjal te Israel tuj tk'ab cawel te Egipto. Ja te Dios e yolen tu'n tyol tsanjel tuj tken k'ak' tuj ch'i'x. ");
INSERT INTO mamNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jatzen Moisésj etz k'inte cye kchman ootxa tuj ttx'otx' Egipto. Cytzki'ntltzen cyey ja Moisésj e binchan tej techlal bix nim sey'pajlenel tuj Egipto, bixsen ttzii' Cyak Mar. Bix jaxsen xinj oc c'ojlancye aj Israel te cya'wnak jnabk'i tuj tzkij tx'otx'. ");
INSERT INTO mamNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Bix jaxsen Moisésj e xi' kbante cye xjal te Israel: “La' alcye jun k'ij q'ueletz tscy'o'n Dios jun nintzaj xjal yec'l be cyxol aj Israel te kbalte tyol Dios cye xjal, tisenj ma chin etz tscy'o'n weya Dios,” tz̈i Moisés. ");
INSERT INTO mamNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jaxsen Moisésj el xoo'n cyu'n xjal, jajxsen xinj ajben te yolel cyxol xjal tuya Dios tej cychmet xjal t-xee' jwitz te Sinaí. Nuktzen tu'nc'a Moisés e binne cyyolen kchman tuya Dios, bix nuk tu'nc'a Moisés e tzaa' tk'o'n Dios ke tley cye xjal. Kej yol lu ejee'tzen yol jte cychunk'lal xjal tuya Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nuket bix oc cybi'n ke ootxa xjal ke ja yola, bixitle e tzaj tk'o'n Dios cychunk'lal te junx maj, pero bix el cyxoo'n. Min e cybi, bix el cyxoo'n Moisés. Yaltzen tuj cyanem e cyajbex tu'n cyaj meltz'aj tujx cychunk'lal te ootxa tuj Egipto. ");
INSERT INTO mamNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Pero min oc cybi'n ja Moisés, sino oc cykanbil twitz Aarón, ttzicy Moisés: “Taat, min ktzki'na ti ma baj te Moisés, jxin etz k'inte keya tuj Egipto. Jatzen tey, keya kuya kbincha'c'atzen cab kdios tu'ntzen t-xi' k'inte ke,” tz̈itzen ke ootxa xjal te Aarón. ");
INSERT INTO mamNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Entonces bixsen e cub cybincha'n xjal junjil wacẍ nukxsen oro ttx'otx'eljil, bixsen oc ten ke xjal patlc'a alimaj te cyoybil twitz. Bix axsen ttz̈yal ta' cyc'u'j xjal ti'j otk bint cyu'n xjal tuya cyk'ab. ");
INSERT INTO mamNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Entonces bix el tpa'n tiib Dios cyi' xjal, bix e cyaj tcye'yen Dios ejee' xjal la' ti jilel e cyajbe tcub bint cyu'n. Bixsen e na'nke xjal ke che'w tuj cya'j. Ootxa tyol Dios nyolen tuj libro te Amós ti'j e baj. Tz̈i Dios cyjulu tuj u'j te Amós: “¡Xjal te Israel! ¿Tepatzen we jkej jil alimaj e tzaj cyoyena we tej cytena tuj tzkij tx'otx' cya'wnak jnabk'i? ¡Min! Ju' tten cyu'na, pero tuj cyanema, min. ");
INSERT INTO mamNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Te t-xelj tu'n cyoc tena na'l we, bix oc tenkey na'l tdios k'ij Moloc tbi, bix e na'nkey dios twitz jun dios che'w, dios te Renfán. Ejee'tzen cyey cydios ajben cyey. E na'nkey dios twitz kej diosa nuk tu'n cyk'aba. Ju' tzunj ma chi ex wii'na tuj cytx'otx'a. Matzen che'x nchk'o'na tuj jun tx'otx' nakch, mas nakch ti' tx'otx' te Babilonia,” tz̈i Dios cyej xjal te Israel, kej min oc cybi'n Dios, tz̈i tyolel Dios Amós at-xe jnabk'i—tz̈itzen Esteban cye judío tuj Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Bix ak'x Esteban yolel: —Yaltzen ja'lewe c'aaltzen ntzak'be'n cabtl yol ti'j yol wi'ja ti'j nin tja Dios. Cytzki'ntltzen cyey ke kchman ootxa e ten jun tja Dios puro xbalen, jaa' e tema Dios, jaa'xja che'xaxin ti'j tuj tzkij tx'otx' bix tziy' cyii'nxin Dios cyuyaxin. Ja xbalen tcublel Dios e bint cyu'nxin tisenxj otk tkba Dios te Moisés, bix tisenc'axj otk tz'oc tcye'yen Moisés twi' jwitz te Sinaí. ");
INSERT INTO mamNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ja xbalen tja Dios, bix e xi' cyii'n ootxa xjal tuj ttx'otx' Canaán. Tuya cycawelxin Josué bixsen e cub cychmo'nxin tuj Canaán. Tuyatzen tonbil Dios e xcyebakexin cyibaj xjal ka' te Canaán. Cykilxsen tyem, jatxe tuj ttyem Moisés tejxe tpon baj ttyem cawel David, ke ootxa xjal e tenx cyexin tjayel Dios cyxol. Mintii' cyexin nin tja Dios cyuya. ");
INSERT INTO mamNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Pero nimxsen t-xtalbil David tuya Dios, bix e xi' tkanenxin xtalbil te Dios tu'ntzen tjaw tbincha'nxin jun jaa' te tja Dios jaa' tu'n kocxa na'nke Dios ejoo' t-xe'chel Jacob. ");
INSERT INTO mamNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bix e xi' tcuyan Dios tyol David, pero yaa'n ja David, sino ja tcwalxin Salomón. ");
INSERT INTO mamNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Perotzen cyey tuj cywitz, ¿jatztzen najla Dios tuj jun jaa' tbinchben xjal? ¡Min! Tej xin jawnexsen, tej xin binchal twitz tx'otx', jxin Dios, yaa'n tuj jun jaa' najla texin. Cybintzney tyol ktzan Isaías, tyolel Kman Dios. Tz̈itzen Dios tu'n tyolelxin Isaías cyjulu: ");
INSERT INTO mamNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Maan tuj cya'j nchin tzaa' cawen twitz tx'otx'. Bix ka ja cya'j te we nuk jun nk'a'j, yal te twitz tx'otx' nuk tu'n tcub we'we nken tibaj. Yaltzen cyey ejee'y xjal, ¿titzen tten tu'n tjaw cybincha'na jun jaa' te nnajbila bix ma tu'n wajlana tuj? ");
INSERT INTO mamNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Yaa'mpatzen inayena in cub binchan tej cykilj at twitz tx'otx'a?” tz̈i Dios cye ootxa xjal at-xe tyem, tz̈i Isaías tcyaj tkba'n—tz̈i Esteban. ");
INSERT INTO mamNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Bix oc ttz'aktza'n Esteban tuya manc'bil tyol te colbil tiibxin: —Entonces, key taat, alj toc chilsalec tc'u'j Dios ejee' cyey. Tisenc'ax kej cyey cychman ootxa e cub cykipan cyiib twitz Espíritu Santo tej tcub cykipan cyiib twitz Moisés, ju'xsen ke cyey cyiw xsun key tuya cyanema, tisenc'ax kej min cytzki'n twitz Dios. ¡Ju'x ke cyey tisen ke kchman ootxa xjal! ");
INSERT INTO mamNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Pero alcyej tyolel Dios min oc cyyasen ke ootxa xjal? ¡Mi nuket jun cye! ¡Cykilcake minx e cybi! Bix xsun kej e kbante ka alcye jun k'ij tul-lel kuya junxin Scy'o'n tu'n Dios, junxin nuk jaj ba'n tcublel tbinchenxin, ja tzun kej kbalte e cub byetke. Bix yaltzen ja'lewe, otzen tzul jxin e kbaj, pero o txi' cyq'ueyen xina, bix o cub cybyo'n xina. ");
INSERT INTO mamNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ejee'y xjal o tz'oc k'o'n tley Dios cyey tu'n tsanjel Dios, pero minx oc cybi'na, ejee' xsuna o cub byo'nte jxin xjal Scy'o'n tu'n Dios—tz̈itzen Esteban tcyaj tk'o'n tuj chic'aj cywitz nintzaj consejo. ");
INSERT INTO mamNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tejtzen toc cybi'n pala cyibaj judío kej tyol Esteban, e tzajxsen tij k'ojlkexin. E jawxsen kitx'itx'in t-xee' twitz cyexin ti' Esteban yec'bil cyk'ojxin. ");
INSERT INTO mamNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero te Esteban maans texin tnaabl. Tujxsen tnoj tanemxin tu'n tipemal Espíritu Santo. Bix e xi' tcye'yenxin tuj cya'j. E til tzunxin tilbil Dios tzinxsen ntxililin, bixsen Jesús wa'lc'axin tuj tmank'ab Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Toctzen tcye'yen Esteban, tz̈i tzunxin cyjulu: —Q'uelelc'a cyni'ya ti'j, lu cya'j jakl tuj nwitza, lu Jesús, jxjal Sma'n tu'n Dios tu'n tten cyuya xjal, wa'lc'a tuj tmank'ab Dios—tz̈i Esteban. ");
INSERT INTO mamNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero cycy'i nintzaj cawel e cybi ke tyol Esteban ka at Jesús tuya Dios, bix oc cymaksi'nxin cyẍquinxin, bix ak'kexin s̈-il, bix e xi'kexin tibaj Esteban. ");
INSERT INTO mamNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bix ex kitet-xin ttxa'n tnom te Jerusalén, bix nbajtzen cyxoo'nxin tuya xak. Tu'ntzen at mas cyipen jxin xool xak, bix el cyi'jxin, tu'nx tbaj Esteban. Bixsen e cyaj cyk'o'nxin cyi'jxin twitz junxin xjal Saulo tbixin. ");
INSERT INTO mamNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Maatkxsen nbaj xoo'nxin cyu'n kej xjal cymoj consejo, bix e xi' tkba'n Esteban te Jesús tuj cya'j: —Nuksama, Taat Jesús, k'inxsen wanem tuj cya'j—tz̈i Esteban. ");
INSERT INTO mamNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bix e cub mejtz'ajxin, ns̈-inxin txi' tkba'nxin te Dios: —Nuksama, mi'n tz'oc tk'o'na cybinchben jxjala te tajlal—tz̈i Esteban. T-xi'len bajxitltzen tkbante Esteban, bix e cyimxin tuj ttz̈yal. ");
INSERT INTO mamNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Te xsunj k'ij tej tbyet Esteban, bix e tzaj tzyet jun tij k'oj cyi' ocslal tuj Jerusalén. Ju' tzunj nimxsen ocslal el tz̈itj cyuj juntl lugar ti'jxe Jerusalén, bix e baj ponke tuj Judea bix tuj Samaria. Pero cykil ke t-xel Jesús jax e cyja'kexin tuj tnom te Jerusalén. ");
INSERT INTO mamNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Attzen cabtl xjal n-oc tak' Dios cye, bix e xi'kexin jaa'j cyimneca Esteban. Chebexsen e cu'x maket-xin. Nimxsen ok'kexin ti' tcyamecy Esteban. ");
INSERT INTO mamNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Cyxoltzen k'ojlel cyi' ocslal tocxe junxin xjal nintzaj xjal, Saulo tbixin. Jaan tzunxin oc ten k'ojlel nim cyi' xjal ocslal. Ocxxin tuj jaca juun jaa', bix ocxxin tunwen nuk ka ma cnet jun ocslal tu'nxin, xuujle, xinakle, bix etz tii'nxin tu'n cyocx tuj tzee'. ");
INSERT INTO mamNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tu'n tzunj otk baj bix tu'n tzunj cyel-len tz̈itj ocslal, bixsen el tz̈itj mas tyol Dios, cuma kej xjal otk chi el tz̈itj, tzinx nchi yolen xjal tyol Dios jaa'xja nchi i'ya xjal ti'j. ");
INSERT INTO mamNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ju'xsen e xa' Felipe, jun onl cye xjal cyxol ocslal, tuj Samaria, bixsen ak'xin yolel ti'j jxin Scy'o'n tu'n Dios, jatzen Jesús. ");
INSERT INTO mamNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bix jax ju'x te Felipe nimxsen techel e bint tu'nxin, bix nimxsen xjal oc cyeyente, bix oc ebinte tyolxin, bix tu'nxsen tbi'nc, oca we' cyc'u'j xjal ti' tyol Felipe. ");
INSERT INTO mamNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bix e xi' tyeec'an Felipe tipemal Jesús cyibaj biman toc cyi' xjal, bix e baj pjetz ke biman cyi' xjal. Tejtzen cyel biman cyi' xjal, elxsen cywi'jil. Bix at xjal mintii' tanem t-xumlal bix nim cox, bix ul cynaabl xjal tu'n tipemal Jesús tu'n tyol Felipe. ");
INSERT INTO mamNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tu'n tzunja cykilxsen ke xjal te Samaria axsen e cyja' cyc'u'j. ");
INSERT INTO mamNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tuj tzunj tnom te Samaria najla junxin chmambaj Simón tbixin. Nimxsen tyem otk tz'ex tu'nxin t-xnak'tzanxin ti' chmambaj bix e baj tyajla'nxin ke xjal. Cykil maj oc ten cyc'u'j xjal ti' tyolxin, bix e sey'paj ke xjal tu'nxin tuya ke ba'n tbinchbenxin, bix e jaw tniman tiibxin ka jaxin jun ba'nxsen xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Cykilxsen xjal, nmak xjal-le, ajnintz xjal-le, ocxsen cybi'n xjal jaxin ti' ttz̈yal tyolxin, bix nchi yolentzen xjal: “Tej xin Simón at-xsen texin nintzaj tipemal, bix juntl Dios looxin,” tz̈itzen ke xjal. ");
INSERT INTO mamNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Axsen otk tz'e'la tuj cywitz xjal, lepchx ke xjal ti'j junx maj. ");
INSERT INTO mamNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero yal te Felipe, oc cybi'n xjal tyol Felipe ti'j tcawbil Dios tuj cyanem xjal bix ti'j Scy'o'n tu'n Dios, jxin Jesús. Bix tejtzen tak' Felipe yolel bix k'anel, nimxsen xjal oc te ocslal, bix e jaw a' cywi', xuujle, xinakle. ");
INSERT INTO mamNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Bix jaan Simón e cub ti'j, bix e bautizarjxin. Tu'nxsen cykil tc'u'jxin toc tcye'yenxin kej techlal bix tik'ch e bint tu'n Felipe. E jawxsen klee' Simón cuma j-oc tcye'yenxin jax, yaa'n yajla'n tisenj texin e bint tu'n. ");
INSERT INTO mamNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jooc'tzen ete'xcye t-xel Jesús tuj Jerusalén, cybintexin txolen cyocslan xjal te Samaria. Ke cyej xjal te Samaria, yaa'n judíoke cye xjal. Bix e xi' chk'et Pedro tuya Juan te cyey'lte. ");
INSERT INTO mamNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bix e pon ke Juan tuya Pedro tuj Samaria. Tejtzen cyponxin, toctzen cycye'yenxin ti nbaj, bix e cykanexin te Dios tu'n cyiik'ente xjal te Samaria Espíritu Santo, tisenx kej xjal ocslal judío otk cyiik' Espíritu Santo tuj cyanem. ");
INSERT INTO mamNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","E na'nkexin Dios, cuma mitkx n-ocxa Espíritu Santo tuj cyanem xjal te Samaria. Otk cyiik'cye jawsaj a' te techlal ka otk chi ocslan ti' Jesús. Pero te Espíritu Santo mitkna'x cyiik'ente. ");
INSERT INTO mamNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Entonces bix ak'ke t-xel Jesús k'olc'a cyk'ab cyibaj ocslal. Tuya tzunj cyajwalelxin, e cyiik'a xjal Espíritu Santo tisenx cyej xjal judío. ");
INSERT INTO mamNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tejtzen toc tcye'yen jxin Simón ke techlal tul cyibaj ocslal, tej cyiik'ente ocslal Espíritu Santo cyu'n t-xel Jesús, bixsen e tajbete Simón ju'wa. Bix e xi' toyenxin pwak te Juan tuya Pedro. ");
INSERT INTO mamNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Tz̈i tzunxin cyjulu: —Nuksamkey, cyk'ontz cyipemala we, tu'ntzen oj tcub nk'o'n nk'ab cyibaj xjal, jaxsen cycyiik'el Espíritu Santo—tz̈i Simón te Pedro tuya Juan. ");
INSERT INTO mamNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pero bix aj ttzak'be'n Pedro: —¡Cutxa tuj infierno tuya tpwaka! Jtey ma tz'oc tcye'yena, te Dios teja. Yaa'n ba'n tu'n tlek'ette tu'n pwak. ");
INSERT INTO mamNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tey mintii' tumel tu'n toca tajlal ja tajwalel Dios. Min tz'el tni'ya ti'j ti nbaj tzalu. Tnaabla bix tanema yaa'n jiquen twitz Dios. ");
INSERT INTO mamNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Jtey toclen ja'lewe, ja tej tu'n tmeltz'aj tc'u'ja ti'j taja tlok'ontey tipemal Dios. Tzin tk'o'n Dios te jun xjal ti jilel taj, pero yaa'n tu'n pwak. Na'm Dios, tu'ntzen kape jac'a najset ka' tbisa tuj tc'u'ja. ");
INSERT INTO mamNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Jac'a tej k'i'nx tey tanem tu'n tisenx tanem chmambaj, bix pres tzuna tu'nj ila—tz̈i Pedro te Simón. ");
INSERT INTO mamNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Bix aj ttz'ak'be'n Simón: —Nuksama, na'm ch'in Dios wi'j, tu'ntzen min chixa tuj k'ak' tisenj toc tu'na—tz̈i Simón tej ttz'ak'be'n, cuma tcy'ixin e xi'xin tuj cawbil tu'n tbinchbenxin. ");
INSERT INTO mamNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tbajlentzen cykba'nxin ti' txolen tyol Dio