﻿USE sofia;
DROP TABLE IF EXISTS sofia.mamC_vpl;
CREATE TABLE mamC_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mamC_vpl WRITE;
INSERT INTO mamC_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Atzin te luꞌn atzin tajlal t-xeꞌchil Jesucrist, a tzajnin tiꞌj qtzan David ex tiꞌj qtzan Abraham: ");
INSERT INTO mamC_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ante Abraham, ttata Isaac, a ttata Jacob, a ttata Judá junx kyukꞌa ttziky ex titzꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ante Judá tukꞌa Tamar, ayeꞌ kytata Fares tukꞌa Zara. Ante Fares ttata Esrom, a ttata Aram, ");
INSERT INTO mamC_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","a ttata Aminadab, a ttata Naasón, a ttata Salmón. ");
INSERT INTO mamC_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ante Salmón tukꞌa Rahab, ayeꞌ ttata Booz, ex ante Booz tukꞌa Rut, ayeꞌ ttata Obed, a ttata Isaí. ");
INSERT INTO mamC_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ante Isaí, ttata David, a nmaq kawiltaq. Ante David ttata Salomón, a taljo t-xuꞌjlbꞌin Urías. ");
INSERT INTO mamC_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ante Salomón ttata Roboam, a ttata Abías, a ttata Asa, ");
INSERT INTO mamC_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","a ttata Josafat, a ttata Joram, a ttata Uzías, ");
INSERT INTO mamC_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","a ttata Jotam, a ttata Acaz, a ttata Ezequías, ");
INSERT INTO mamC_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","a ttata Manasés, a ttata Amón, a ttata Josías, ");
INSERT INTO mamC_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","a ttata Jeconías kyukꞌa txqantl titzꞌin, a teꞌ kyxi jtzꞌoꞌn aj Israel tzmax toj txꞌotxꞌ te Babilonia. ");
INSERT INTO mamC_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Axsa toj Babilonia ante Jeconías ok te ttata Salatiel, a ttata Zorobabel, ");
INSERT INTO mamC_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","a ttata Abiud, a ttata Eliaquim, a ttata Azor, ");
INSERT INTO mamC_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","a ttata Sadoc, a ttata Akim, a ttata Eliud, ");
INSERT INTO mamC_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","a ttata Eleazar, a ttata Matán, a ttata Jacob, ");
INSERT INTO mamC_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","a ttata Jse, a tchmil Mariy, a tnana Jesús, a ok tbꞌi te Crist, a skꞌoꞌnxix tuꞌn Dios tuꞌn tok te Kolil. ");
INSERT INTO mamC_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ikytziꞌn, attaq kyajlajaj tyajil tzajnin tiꞌj Abraham tzmaxiꞌ tej tul itzꞌje David; ex kyajlajaj tyajil tzajnin tiꞌj David, tej kyxi jtzꞌoꞌn aj Israel tzmax toj txꞌotxꞌ te Babilonia. Ex attaq kyajlajaj tyajil tzajnin, atxix teꞌ kyxi jtzꞌoꞌnxjal toj Babilonia tzmax tej tul itzꞌje Crist. ");
INSERT INTO mamC_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Atzin titzꞌjlin Jesucrist ikytziꞌn kyjaluꞌn: Ante Mariy, a tnana, otaq bꞌant tiꞌj, tuꞌn tmeje tukꞌa Jse. Me tej naꞌmtaqx kykubꞌ kẍe junx, bꞌeꞌx ok tzꞌaq tal Mariy, noq tuꞌn tipin Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Me ante Jse, a tuꞌn toktaq te tchmil, tej tok tkaꞌyin qa otaq tzꞌok tzꞌaq tal Mariy, kubꞌ t-ximin tuꞌn tkubꞌ tpaꞌn tibꞌ tukꞌa, quꞌn jun ichin tzꞌaqle, ex kubꞌ t-ximin qa noq otaq skꞌon Mariy tal. Me tkyꞌeꞌtaq tuꞌn tel tqanil kywutzxjal, tuꞌntzintla mi kubꞌ kybꞌinchinxjal mibꞌin tiꞌj Mariy; qalaꞌ kubꞌ t-ximin tuꞌn chebꞌetaq tuꞌn tkubꞌ tpaꞌn tibꞌ tukꞌa toj ewajil. ");
INSERT INTO mamC_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ex tzmataq nximin tiꞌjjo lo, ok tyekꞌin jun t-angel qAjaw tibꞌ te toj wutzikyꞌ, ex xi tqꞌmaꞌn te: Jse, ay tyajil qtzan nmaq kawil David. Mi xobꞌa tuꞌn tjaw mejey tukꞌa Mariy, quꞌn atzin tal k-itzꞌjil nya tkꞌwal jun ichin, qalaꞌ tuꞌn Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Quꞌn k-itzꞌjil jun tal qꞌa, ex k-okil tqꞌoꞌn tbꞌi Jesús. K-okil tbꞌi ikyjo, quꞌn kchi kletil xjal toj il tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","O bꞌaj tkyaqiljo lo, noq tuꞌn tjapiꞌn yol tzaj tqꞌmaꞌn qAjaw tuꞌn yolil Tyol Dios ojtxe, tej tqꞌma: ");
INSERT INTO mamC_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jun tal txin, a naꞌmxtaq tlonte ichin, ex tzul itzꞌje jun tal tal qꞌa. Ex k-okil juntl tbꞌi Emanuel, a ntqꞌmaꞌn qa Dios qukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tej tjaw sakꞌpaj Jse toj twatl, kubꞌ tbꞌinchin tzeꞌnkuxjo otaq tqꞌma t-angel qAjaw te, ex bꞌeꞌx xi tkꞌleꞌn Mariy te t-xuꞌjil. ");
INSERT INTO mamC_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Me mix i kubꞌe kẍe junx, tzmaxiꞌ tej tul itzꞌje tnejil tal, a qꞌa, a otaqxi tzꞌok tzꞌaq. Ex ok tqꞌoꞌn tbꞌi Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Antza itzꞌje Jesús tojjo tal tnam Belén, toj txꞌotxꞌ te Judey, tej toktaq Herodes te nmaq kawil tojjo txꞌotxꞌ anetziꞌn. I kanin tojjo tnam Jerusalén junjun ichin aj nabꞌlqe, tzajninqe toj tjawitz qꞌij, ");
INSERT INTO mamC_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ex xi kyqanin: ¿Jaꞌtzin taꞌ nmaq kawil kye xjal aj Judiy, a ma tzꞌitzꞌje? Quꞌn ma qliꞌy tcheꞌw te tqanil tojjo qtxꞌotxꞌa toj tjawitz qꞌij, ex ma qo tzaja tzaluꞌn tuꞌn qkꞌulin twutz. ");
INSERT INTO mamC_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Atzaj teꞌ tbꞌinte Herodes, a nmaq kawil, bꞌeꞌx najx tnabꞌl kyukꞌa tkyaqilxjal toj Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tuꞌnpetziꞌn, bꞌeꞌx i tzaj ttxkoꞌn kykyaqil kynejil pale exqetziꞌn xnaqꞌtzil tiꞌj tkawbꞌil aj Judiy, ex xi tqanin kye: ¿Jaꞌtzin tuꞌn titzꞌjetaq Crist? ");
INSERT INTO mamC_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aye nejinel kyxol aj Judiy xi kytzaqꞌwin: Toj tnam Belén toj txꞌotxꞌ Judey, chi chiꞌ. Quꞌn ikytziꞌn kyij ttzꞌibꞌin yolil Tyol Dios ojtxe. Chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ante Belén, toj ttxꞌotxꞌ Judá, nya tal muꞌẍ tnam te kyxol tkyaqil nmaq tnam kye aj Judiy. Quꞌn toja, k-elitze jun tnejil, a k-okil kaꞌyinte Ntanima, ayeꞌ aj Israel, tzeꞌnku jun kyikꞌlel. ");
INSERT INTO mamC_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tuꞌnpetziꞌn, i tzaj ttxkoꞌnte Herodes toj ewajil aye aj nabꞌl, ex xi tqanin alkyexix qꞌij, tej kylonte cheꞌw. ");
INSERT INTO mamC_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ex bꞌeꞌxsin i xi tchqꞌoꞌn tzmax Belén, ex xi tqꞌmaꞌn kye: Ku kyxiꞌy antza, ex kyxjelinxa wen tiꞌjjo tal neꞌẍ. Ajtzin knet kyuꞌn, kysmaꞌntza tqanil weꞌy, tuꞌntzin ex ikyx wejiꞌy tuꞌn nxiꞌy kꞌulil twutz. ");
INSERT INTO mamC_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tuꞌntziꞌn tyol Herodes, bꞌeꞌx i xiꞌ aj nabꞌl. Atzin teꞌ cheꞌw, a kyli toj tjawitz qꞌij, nejnintaq kywutz ex tzmaxi weꞌ, tej tkanin tibꞌajjo ja, jaꞌ taꞌtaqjo tal kꞌwal. ");
INSERT INTO mamC_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tej kylonte aj nabꞌljo cheꞌw tkubꞌ weꞌ, bꞌeꞌxsin i jaw tzalaj nimxix. ");
INSERT INTO mamC_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Atzaj teꞌ kyokx tuja, kyli tal kꞌwal tukꞌax tnana, a Mariy, ex bꞌeꞌx i kubꞌ meje kꞌulil twutz. Ex xi kyoyin qꞌanpwaq, exsin storak ex jun kꞌokꞌjsbꞌil, mir tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tbꞌajlinxiꞌ ikyjo, tzaj tyekꞌin Dios kye toj kywutzikyꞌ, tuꞌn mi chi meltzꞌaj jaꞌ taꞌtaq Herodes. Tuꞌnpetziꞌn, tojxi junxil bꞌe i ajtz meltzꞌaj, tej kyajtz. ");
INSERT INTO mamC_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tej kyajtz aj nabꞌl, jun t-angel qAjaw ok tyekꞌin tibꞌ toj twutzikyꞌ Jse, ex xi tqꞌmaꞌn te: Kux jaw weꞌksa. Chlentzjiy tal qꞌa tukꞌax tnana, ex kux cheꞌxa toj txꞌotxꞌ Egipto, ex tenkja antza, tzmaxiꞌ aj t-xi nqꞌmaꞌn tey. Quꞌn kjyol Herodes tiꞌjjo tal qꞌa, tuꞌn tkubꞌ bꞌyet. ");
INSERT INTO mamC_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tuꞌnpetziꞌn, bꞌeꞌx jaw weꞌ Jse, ex xi tchleꞌn tal kꞌwal tukꞌa toj qnikyꞌin tukꞌaxjo tnana, tuꞌn kyxiꞌ Egipto. ");
INSERT INTO mamC_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Antza i tene, tzmaxiꞌ tej tkyim Herodes. Bꞌant ikyjo, noq tuꞌn tjapiꞌn a tqꞌma qAjaw tuꞌn yolil Tyol Dios ojtxe. Chiꞌ kyjaluꞌn: Tzmax Egipto, ktzajil ntxkon weꞌ nkꞌwalch. ");
INSERT INTO mamC_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tej tel tnikyꞌ Herodes te, qa otaq kubꞌ sbꞌuꞌn kyuꞌn aj nabꞌl, bꞌeꞌx tzaj tqꞌoj kyiꞌj. Ex bꞌeꞌx ex tqꞌoꞌn jun tkawbꞌil, tuꞌn kykubꞌ bꞌyetjo jniꞌ kꞌwal, a naꞌmtaq kyjapin te kabꞌe abꞌqꞌe, ayeꞌ iteꞌtaq toj Belén ex kykyaqil kojbꞌil tiꞌjile, tzeꞌnku otaq kyqꞌma aj nabꞌl, qa otaq tzꞌitzꞌje jun nmaq kawil antza. ");
INSERT INTO mamC_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Quꞌn ikytzin japin bꞌajjo, a kubꞌ ttzꞌibꞌin Jeremías, a yolil Tyol Dios ojtxe. Chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bꞌijte jun tqꞌajqꞌojil wibꞌaj toj Ramá, tzeꞌnku jun oqꞌil tukꞌa nimx bꞌisbꞌajil. Nyakuj kyoqꞌil kykyaqil txubꞌaj aj Israel junx kyukꞌa kyimnin ex kyukꞌa itzꞌqe, nchi oqꞌ kyiꞌj kyal, ayeꞌ i kubꞌ bꞌyoꞌn, ex mix aꞌl nchewsin teꞌ kykꞌuꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Me teꞌ otaqxi kyim Herodes, jun t-angel qAjaw ok toj twutzikyꞌ Jse, tej atxtaq toj txꞌotxꞌ Egipto, ex tqꞌma: ");
INSERT INTO mamC_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","¡Weꞌksa! Ex qꞌinxjiy tal kꞌwal tukꞌiy tukꞌax tnana. Ku tmeltzꞌaja toj txꞌotxꞌ te Israel, quꞌn ma chi kyimjo aye kyajtaq tuꞌn tkubꞌ kybꞌyoꞌn tal kꞌwal. ");
INSERT INTO mamC_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ex bꞌeꞌx jaw weꞌks Jse; xi tiꞌn tal kꞌwal tukꞌa tukꞌax tnana tzmax toj txꞌotxꞌ te Israel. ");
INSERT INTO mamC_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Me teꞌ tbꞌinte Jse, qa ataq Arquelao, a tkꞌwal qtzan Herodes, toktaq te kawil te t-xel qtzan ttata toj txꞌotxꞌ te Judey, mix xaꞌyil, quꞌn bꞌeꞌx xobꞌ tuꞌn t-xiꞌ antza. Me toj juntl wutzikyꞌ ok qꞌmaꞌne te, tuꞌn t-xiꞌ toj txꞌotxꞌ te Galiley. ");
INSERT INTO mamC_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Atzaj teꞌ tkanin antza, bꞌeꞌx i xiꞌ najal toj tnam Nazaret toj txꞌotxꞌ te Galiley, tuꞌntzin tjapin bꞌajjo a kyqꞌma yolil Tyol Dios ojtxe, qa tuꞌn toktaq tbꞌi Jesús, Aj Nazaret. ");
INSERT INTO mamC_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tbꞌajlinxiꞌ ilaꞌ abꞌqꞌe, ul Juan, a Jawsil Aꞌ, tojjo tzqij txꞌotxꞌ, jaꞌ ntiꞌ kynajbꞌilxjal toj, tojx ttxꞌotxꞌ Judey. Me bꞌeꞌx i xiꞌ nim xjal bꞌilte, quꞌn nyolintaq Juan tiꞌj Tyol Dios, ");
INSERT INTO mamC_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ex ntqꞌmaꞌntaq: Ku tajtz tiꞌj kyanmiꞌn, quꞌn a Tkawbꞌil Dios toj kyaꞌj kyja tul laqꞌe. ");
INSERT INTO mamC_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Anteꞌ Juan luꞌn a kubꞌ ttzꞌibꞌin Isaías, a yolil Tyol Dios ojtxe, tej tqꞌmante kyjaluꞌn: Ex bꞌijte tqꞌajqꞌojil twiꞌ jun aꞌla kujxix wen tojjo tzqij txꞌotxꞌ, jaꞌ ntiꞌye kynajbꞌilxjal toj. Chiꞌ kyjaluꞌn: Kybꞌinchima kyibꞌa twutzjo tAjaw Tkyaqil. Kyqꞌonx kyanmiꞌn te, quꞌn chꞌix tul tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Atzin t-xbꞌalin Juan noq tsmal jun wiq txuk, kamey tbꞌi, tukꞌa tkꞌalbꞌil tal ttxꞌaqin tzꞌuꞌn, tzeꞌnku kyxbꞌalin yaj. Ex atzin twa n-oktaq, noq txuk tzeꞌnqekuꞌ txanin, ex taꞌl aq toj kꞌul. ");
INSERT INTO mamC_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ex nimxjal toj tnam te Jerusalén ncheꞌxtaq bꞌilte, exqetziꞌn toj txꞌotxꞌ te Judey ex tkꞌatz Nim Aꞌ Jordán. ");
INSERT INTO mamC_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Me ayetziꞌn jatz kypaꞌn kyil twutz Dios, bꞌeꞌx i kux tqꞌoꞌn Juan toj nim aꞌ, te jawsbꞌil aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Me atzaj teꞌ tok tkaꞌyin Juan nimtaq xjal kyxol Parisey ex Sadusey nchi ultaq, tuꞌn kykuꞌx toj aꞌ te jawsbꞌil aꞌ, bꞌeꞌx xi tqꞌmaꞌn kye: Ntiꞌx kyeꞌ kyajbꞌin, ikyqexjiꞌy tzeꞌnku jun chꞌuq maꞌ kan. ¿Ma noqtzin tuꞌn aj kykuꞌxa toj aꞌ, ok kchi kletiliꞌy te tkawbꞌil Dios kujxix wen, a chꞌix tul kanin kyibꞌaja? ");
INSERT INTO mamC_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Quꞌn ojtzqiꞌn kyuꞌn kykyaqilxjal, qa axjo kybꞌinchbꞌiꞌn nyekꞌinte qa naꞌm tajtz tiꞌj kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","¿Tzeꞌntzin tten nkubꞌ kybꞌisintza, qa aku chi kleta noq tuꞌn Judiyqiꞌy, a tyajil qtzan Abraham, ex nya tuꞌn tajtz tiꞌj kyanmiꞌn? Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy, noqpetzin at kolbꞌiltz ikyjo, majqexpetla kyeꞌ abꞌj luꞌn, aku chi ok tqꞌoꞌn Dios te tyajil Abraham, tuꞌn kyklet. ");
INSERT INTO mamC_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tuꞌnpetziꞌn, chꞌix tul tkawbꞌil Dios kujxix kyibꞌaj kykyaqiljo ayeꞌ kykyꞌeꞌ tuꞌn tajtz tiꞌj kyanmin, ikyxjo tzeꞌnku tajaw jun wiꞌ tze kjawil ttxꞌemin, qa ntiꞌ twutz n-el. Ex a tze, a ntiꞌ tajbꞌin, k-okix toj qꞌaqꞌ; ikyxtzin kchi tenbꞌilajiꞌy, qa mi s-ajtz tiꞌj kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Me metzin weꞌ nchi kux nqꞌoꞌnxjal toj aꞌ, te jawsbꞌil aꞌ, te jun yekꞌbꞌil qa ma tzꞌajtz tiꞌj kyanmin. Me ante tzul wiꞌjxiꞌy nya noq oꞌkx tuꞌn kykuꞌxxjal tuꞌn toj aꞌ, te jawsbꞌil aꞌ, qalaꞌ kxel tqꞌoꞌn Xewbꞌaj Xjan toj kyanmin te jun majx te patbꞌil jniꞌ il toj. Quꞌn at nimxixtl tipin tzeꞌnku weꞌ, nipela at wokliꞌn tuꞌn woka te taqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Quꞌn luꞌ Kawil kkawil kyibꞌaj xjal tzeꞌnku jun aj triyil, a qꞌiꞌn ma nim tze toj tqꞌobꞌ te xtulbꞌil triy. Ex k-elix tpaꞌn kykyaqilxjal wen kyxoljo nya wen, ikyxjo tzeꞌnku jun xjal aj t-xtulin triy, ex k-elil tpaꞌn paj tiꞌj. Ex kchi xel tkꞌleꞌn nimil toj kyaꞌj tzeꞌnku tuꞌn tkux tkꞌuꞌn triy toj ttxꞌutxꞌ. Me ayetziꞌn nya nimil, ikyxjo tzeꞌnku paj, ok kchi kꞌwel tpatin tukꞌa qꞌaqꞌ, a mixla k-yupjilx. ");
INSERT INTO mamC_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kyojjo qꞌij anetziꞌn, etz Jesús toj txꞌotxꞌ te Galiley, tuꞌn tpon ttzi Nim Aꞌ Jordán, tuꞌn tkuꞌx toj aꞌ te jawsbꞌil aꞌ tuꞌn Juan tojxjo nim aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Me tkyꞌeꞌtaq Juan tuꞌn tkuꞌx Jesús toj aꞌ, te jawsbꞌil aꞌ, ex xi tqꞌmaꞌn te: Ayintla weꞌ tuꞌn nkux tqꞌoꞌn toj nim aꞌ te jawsbꞌil aꞌ, te jun yekꞌbꞌil qa ayiꞌn ma tzꞌajtz tiꞌj wanmiꞌn. Me atzin teꞌ, ntiꞌ te til. ¿Qalatziꞌn taja tuꞌn tkuꞌxa toj aꞌ? ");
INSERT INTO mamC_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Me ante Jesús xi tqꞌmaꞌn te: Qbꞌinchinku jaꞌlin, quꞌn ilxix tiꞌj tuꞌn tbꞌant quꞌn, tzeꞌnkuxjo tkyaqiljo taj qMan. Ex bꞌeꞌx xi ttziyin Juan. ");
INSERT INTO mamC_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Atzaj teꞌ tjatz Jesús toj aꞌ, bꞌeꞌx xi jaqpaj kyaꞌj, ex xi tkaꞌyin T-xew Dios, a Xewbꞌaj Xjan, kyjaꞌtaq tkuꞌtz tzeꞌnku jun palom, ex kubꞌ ten tibꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ex qꞌajqꞌojin jun yol toj kyaꞌj. Chiꞌ kyjaluꞌn: Axixpen wejiꞌy Nkꞌwal kꞌuꞌjlin wuꞌn, a o jaw nskꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tbꞌajlinxiꞌ ikyjo, xiꞌ Jesús tuꞌn tkujil Xewbꞌaj Xjan tzma tojjo tzqij txꞌotxꞌ, jaꞌ ntiꞌye kynajbꞌilxjal toj, tuꞌn tok toj joybꞌil tiꞌj tuꞌn tajaw il, quꞌn tjoy tajaw il ttxolil, tuꞌn tel tikyꞌin Jesús tkawbꞌil tMan. ");
INSERT INTO mamC_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Otaq kubꞌ tpaꞌn Jesús waꞌyaj kaꞌwnaq qꞌij ex kaꞌwnaq qnikyꞌin, tuꞌn tnaꞌn Dios. Tuꞌnpetziꞌn, tzaj waꞌyaj tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tej tok tkaꞌyin tajaw il ikyjo, tzaj laqꞌe tkꞌatz, tuꞌn tok tnikyꞌbꞌin toklin, exsin xi tqꞌmaꞌn te: Qa Kꞌwaꞌlbꞌajxixtza te Dios, qꞌmanxa kye abꞌj lo, tuꞌn kyok te wabꞌj, quꞌn manyor waꞌyajx tiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Me xi ttzaqꞌwin Jesús: Kyij tzꞌibꞌin toj Tyol Dios, qa nya noq oꞌkx tuꞌn wabꞌj k-anqꞌile texjal; qalaꞌ ex tuꞌn tkyaqiljo yol, a n-etz toj ttzi Dios. ");
INSERT INTO mamC_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx xi tiꞌn tajaw il Jesús toj xjan tnam te Jerusalén. Jax tkꞌleꞌn tzmax toj tjuchꞌiljo tnejil ja te naꞌbꞌl Dios, a nimxix tweꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ex xi tqꞌmaꞌn te: Qa Kꞌwaꞌlbꞌajxixtza te Dios, xoꞌnkuxsin tibꞌtza, tuꞌn tkupin tzmax twutz txꞌotxꞌ, quꞌn ikytziꞌn ntqꞌmaꞌn Tyol Dios kyjaluꞌn: Kchi tzajil tsmaꞌn Dios t-angel te kloltiy. Ex kjawil qꞌiꞌn kyuꞌn toj kyqꞌobꞌ, tuꞌntzintla mi kyꞌixbꞌiꞌy twiꞌ abꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Me xi ttzaqꞌwin Jesús: Ex ikyxjo ntqꞌmaꞌn toj Tyol Dios kyjaluꞌn: Mi tzꞌok tqꞌonjiy qAjaw, a tDiosa toj joybꞌil tiꞌjch. ");
INSERT INTO mamC_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ex juntl majl, xi tiꞌn tajaw il Jesús tibꞌaj jun wutz, ma nimxix tweꞌ, ex xi tyekꞌin tajaw il tkyaqil tnam twutz txꞌotxꞌ te, ex tkyaqiljo qꞌinimil toj. ");
INSERT INTO mamC_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Exsin xi tqꞌmaꞌntz: Kxel nqꞌoꞌn tkyaqiljo jniꞌ chiꞌ tey, qa ma kubꞌ mejeꞌy kꞌulil nwutza. ");
INSERT INTO mamC_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Me ante Jesús xi ttzaqꞌwin: Laqꞌexa nkꞌatza, ay, satanás, a tajaw il, quꞌn ikytzin ntqꞌmaꞌn toj Tyol Dios: Kꞌuliꞌn oꞌkx twutz qAjaw, a tDiosa, ex noq te, tuꞌn tajbꞌiniych. ");
INSERT INTO mamC_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx el tpaꞌn tajaw il tibꞌ tiꞌj Jesús. Ex bꞌeꞌx i ul junjun angel mojilte. ");
INSERT INTO mamC_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tej tbꞌinte Jesús, qa otaq kux jpuꞌn Juan, a Jawsil Aꞌ, toj tze, bꞌeꞌx xiꞌ toj txꞌotxꞌ Galiley. ");
INSERT INTO mamC_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Me mix kyjaye tene toj tnam Nazaret, qalaꞌ bꞌeꞌx xiꞌ toj juntl tnam toj txꞌotxꞌ te Galiley, Capernaum tbꞌi, jun tnam nqayin taꞌ ttzi nijabꞌ, toj txꞌotxꞌ, a xi qꞌon kye tyajil qtzan Zabulón ex te qtzan Neftalí, ayeꞌ tkꞌwal qtzan Israel. ");
INSERT INTO mamC_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Bꞌajjo ikyjo, noq tuꞌn tjapin bꞌajjo a kubꞌ ttzꞌibꞌin Isaías, a yolil Tyol Dios ojtxe, tej tqꞌma: ");
INSERT INTO mamC_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ay, ttxꞌotxꞌ Zabulón, ex te Neftalí, a tkꞌatz Nim Aꞌ Jordán, ex jniꞌqe iteꞌk ttziyile ttxuyil aꞌ tojx txꞌotxꞌ te Galiley, jaꞌ najleqe xjal nya Judiyqe. ");
INSERT INTO mamC_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ayeꞌ xjal tojjo txꞌotxꞌ lo iteꞌtaq toj qxopin toj kyanmin, me o kyli jun nim tqan tzaj. Ex ayeꞌ najleqe tojjo txꞌotxꞌ, a ikyꞌin kyuꞌnxjal ex te kyiminch, quꞌn nyakuj ntiꞌtaq kyoklin. Me atziꞌn jaꞌlin, ma kyli jun nim spikyꞌin, ex jun tqan tzaj, a tzunx nqopinx. ");
INSERT INTO mamC_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Atxixsiꞌn ttzaj xkye taqꞌin Jesús, tuꞌn tyolin Tyol Dios, ex xi tqꞌmaꞌn: Ku tajtz tiꞌj kyanmiꞌn, ex ku kymeltzꞌaja tukꞌa qMan Dios, quꞌn a Tkawbꞌil Dios toj kyaꞌj ma tzaj laqꞌe. ");
INSERT INTO mamC_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nbꞌettaq Jesús ttzi Nijabꞌ te Galiley, tej t-xi tkaꞌyin kabꞌe kyiẍil, kyitzꞌin kyibꞌ. Ataqtziꞌn jun, Simun, a toktaq juntl tbꞌi Pegr, junx tukꞌa titzꞌin, Andrés. Tzmataq nkux kyqꞌoꞌn kypa toj aꞌ te tzuybꞌil kyiẍ, ");
INSERT INTO mamC_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","xi tqꞌmaꞌn Jesús kye: Chi lipeka wiꞌja. Quꞌn ayetzin kyeꞌ nchi chmoꞌn kyiẍ jaꞌlin, me kchi xel nxnaqꞌtziꞌn tzeꞌn tten tuꞌn tbꞌant kychmoꞌn xjal tuꞌn kyklet. ");
INSERT INTO mamC_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jun paqx, kyij kytzaqpiꞌn kypa te tzuybꞌil kyiẍ, ex i xi lipe tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tej kyxi laqꞌe chꞌintl, i xi tkaꞌyin Jesús kabꞌetl xjal kyitzꞌin kyibꞌ, ayeꞌ Jacob, a toktaq juntl tbꞌi Santyaw, tukꞌax titzꞌin, Juan, tkꞌwalqe Zebedey. Iteꞌkxtaq toj jun bark tukꞌax kytata nchi slepintaq kypa te tzuybꞌil kyiẍ. I tzaj ttxkoꞌn Jesús, ");
INSERT INTO mamC_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ex bꞌeꞌx kyij kytzaqpiꞌn kybark tukꞌax kytata, ex bꞌeꞌx i ok lipe tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nbꞌettaq Jesús toj tkyaqil txꞌotxꞌ te Galiley, ex nxnaqꞌtzintaq kyojile junjun tnam antza kyojjo muꞌẍ ja te kynaꞌbꞌl aj Judiy Dios. Nyolintaq Tbꞌanil Tqanil tiꞌj Tkawbꞌil Dios, ex nqꞌanintaq tkyaqil wiq yabꞌil, a otaq tzꞌok lemtzꞌaj kyiꞌjxjal. ");
INSERT INTO mamC_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","El tqanil Jesús toj tkyaqil txꞌotxꞌ te Siria, ex i bꞌaj tzaj kyiꞌnxjal kyyabꞌ tukꞌa noq tiꞌchaqku yabꞌil, ex noq tiꞌchaqku kyixkꞌoj, exqetziꞌn tzyuꞌntaq kyanmin tuꞌn taqꞌnil tajaw il, exqetziꞌn ntzajtaq nluꞌlin kyiꞌj, ex jniꞌ qe kox; ex bꞌeꞌx i el weꞌ tuꞌn Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nimx txqan xjal ok lipe tiꞌj Jesús toj txꞌotxꞌ te Galiley, te txꞌotxꞌ Decápolis, te Jerusalén, te tkyaqil txꞌotxꞌ te Judey, ex kyoj txꞌotxꞌ jlajxi Nim Aꞌ Jordán. ");
INSERT INTO mamC_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tej tok tkaꞌyin Jesús txqan xjal otaq chmet tiꞌj, bꞌeꞌx jax twiꞌ wutz, ex kubꞌ qe antza. Me awotziꞌn, a t-xnaqꞌtzbꞌin, bꞌeꞌx o xi laqꞌeꞌy tkꞌatz, ex ok qtxolin qibꞌa tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ex ok ten Jesús xnaqꞌtzil, ex tqꞌma: ");
INSERT INTO mamC_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Kyꞌiwlinqexixjo ayeꞌ nkynaꞌn toj kyanmin qa atx taj toj kychwinqil, quꞌn at kyoklin tiꞌj Tkawbꞌil Dios toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kyꞌiwlinqexixjo ayeꞌ nkynaꞌn bꞌis toj kyanmin, quꞌn axte Dios ktzajil qꞌuqbꞌin te kykꞌuꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kyꞌiwlinqexixjo ayeꞌ o tzꞌajtz tiꞌj kyanmin, quꞌn kchi najal tojjo txꞌotxꞌ, a o tzaj ttziyin Dios kye. ");
INSERT INTO mamC_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kyꞌiwlinqexixjo ayeꞌ kyajxix tuꞌn kybꞌinchin a taj qMan Dios, quꞌn axte Dios ktzajil oninkye tuꞌn tbꞌant kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kyꞌiwlinqexixjo ayeꞌ nqꞌaqꞌin kykꞌuꞌj kyiꞌjjo txqantl, quꞌn axte Dios ktzajil qꞌaqꞌin tkꞌuꞌj kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kyꞌiwlinqexixjo ayeꞌ o txjet il toj kyanmin, quꞌn ok kylaꞌbꞌil Dios toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kyꞌiwlinqexixjo ayeꞌ tok tilil kyuꞌn, tuꞌn kymujbꞌin texjal kyibꞌ kyxolile, quꞌn axte Dios k-okil qꞌonte kybꞌi te kꞌwalbꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kyꞌiwlinqexixjo ayeꞌ n-ikyꞌx yajbꞌil kyuꞌn, noq tuꞌn nkubꞌ kybꞌinchin a tzꞌaqle, a tzeꞌnku taj Dios, quꞌn at kyoklin tiꞌj Tkawbꞌil Dios toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kyꞌiwlinqexix kyeꞌ, qa ma chi xoꞌnxjal yol kyiꞌja, ex qa ma tzikyꞌx yajbꞌil kyuꞌn, ex tkyaqil nya bꞌaꞌn, a kjawil bꞌant kyuꞌnxjal kyiꞌja, noq tuꞌn npaja. ");
INSERT INTO mamC_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Qa ma tzikyꞌx kyuꞌn, chi tzeꞌjixa, ex chi tzalajxa, quꞌn ktzajil tqꞌoꞌn Dios nim t-xel kyeꞌy toj kyaꞌj, tzeꞌnku xi tqꞌoꞌn kye yolil Tyol Dios ojtxe, tuꞌn nim ikyꞌx kyuꞌn tzeꞌnkuꞌ kyeꞌ jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ayetzin kyeꞌ ma chi oka tzeꞌnku atzꞌin te twutz txꞌotxꞌ, tuꞌn mi naje toj il. Quꞌn qa ma tzꞌel naj tpitzꞌmejil atzꞌin, nlay bꞌant tuꞌn tel pitzꞌmejix juntl majl, quꞌn ntiꞌxla tajbꞌin, qalaꞌ noq tuꞌn tex xoꞌyit, ex tuꞌn kyjax weꞌxjal tibꞌaj. Tuꞌntzintzjo, kykaꞌyinkxix kyibꞌa, tuꞌn mi naje a at toj kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ex ma chi oka tzeꞌnku spikyꞌin te twutz txꞌotxꞌ, tzeꞌnku jun tnam tokx twiꞌ wutz nlay bꞌant tewit. ");
INSERT INTO mamC_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ex nlay bꞌant tuꞌn tok txqet jun tzaj, exsin tuꞌn tokx ewitl tjaqꞌ jun kax; qalaꞌ il tiꞌj tuꞌn tjax tibꞌaj xtankoꞌl, tuꞌntzin tspikyꞌemix tkyaqil tuja tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ikytzin kyejiꞌy, kyyekꞌima kynimbꞌila kywutzxjal, tzeꞌnku spikyꞌin, tuꞌntzin aj tok kykaꞌyin xjaljo kybꞌinchbꞌiꞌn tbꞌanilx, ex kjawil kynimsin tbꞌi qMan Dios toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mi kubꞌ kyximiꞌn qa ma chin ula yupil teꞌ tkawbꞌil Moisés exqetziꞌn kyxnaqꞌtzbꞌin yolil Tyol Dios ojtxe. Quꞌn nya ma chin ula yupilte tkyaqiljo luꞌn, qalaꞌ tuꞌn tjapin wuꞌn tkyaqil t-xilin. ");
INSERT INTO mamC_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Twutzxix kxel nqꞌmaꞌn kyeꞌy, nlay najjo kawbꞌil lo, nipela jun tal netzꞌ yol tiꞌj, ajxi tjapin bꞌaj tkyaqil t-xim Dios, ex ajxi tikyꞌ kyaꞌj ex txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tuꞌnpetziꞌn, altzin kye jun ma tzikyꞌ tibꞌajjo kawbꞌil, exla qa noq jun tal muꞌẍ yol toj twutz, mo qa ma txi tqꞌmaꞌnj kye txqantl, tuꞌn mi kubꞌ nimite chꞌin, ex tal muꞌẍ k-esbꞌajila toj kyaꞌj. Me anteꞌ, a japin bꞌaj tuꞌn tkyaqilx, ex qa ma txi tqꞌmaꞌn kye txqantl qa il tiꞌj tuꞌn tjapin bꞌaj tkyaqil, ex aj tkanin toj Tkawbꞌil Dios toj kyaꞌj, k-okil qꞌoꞌn te nim toklin. ");
INSERT INTO mamC_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy, mi chi oka tzeꞌnku kye Parisey exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil, a oꞌkx kyajjo tuꞌn tjapin kyuꞌn kywutzxjal, me noq tukꞌa tkaꞌmin kykꞌuꞌj nkubꞌ kybꞌinchine. Quꞌn qa mix japin kyuꞌn tukꞌa tkyaqil kyanmiꞌn, mi chi okxa toj Tkawbꞌil Dios toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Quꞌn bꞌiꞌn kyuꞌn tiꞌ qꞌumj kye ojtxe qxeꞌchil: Mi chi bꞌiyiꞌn, quꞌn qa ma bꞌiyin, at til twutz kawbꞌil te twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Me metzin weꞌ kxel nqꞌmaꞌn kyeꞌy, ankyeꞌ noqx qꞌoj kxel taqꞌnin tukꞌa tukꞌa, at til twutz kawbꞌil. Ex ankyeꞌ k-okil lipin yisol tukꞌa, at til twutz tnejil kawbꞌil. Ex ankyeꞌ kxel tqꞌmaꞌn te tukꞌa: Ntiꞌ tnabꞌl, kxeꞌl toj qꞌaqꞌ te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tuꞌnpetziꞌn, qa taja tuꞌn t-xiꞌy qꞌol jun toyaja toj ja te naꞌbꞌl Dios, ex aj tpon, me qa akux s-ul toj tkꞌuꞌja, qa at jun tqꞌoja tukꞌa jun tukꞌiy, ");
INSERT INTO mamC_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mi txiꞌy qꞌol toyaja nej; qalaꞌ nej, ku txiꞌy kubꞌsil twutza te tukꞌiy, tuꞌn tkubꞌ tnajsin tila. Ex ajtzin kykyija toj wen tukꞌa, kuxpin txiꞌtza qꞌol toyaja. ");
INSERT INTO mamC_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ikytziꞌn, qa at jun taj tuꞌn t-xiꞌ patil tey twutz kawil, qꞌonka tilil, tuꞌn tkyija toj wen tukꞌa axsa toj bꞌe, tuꞌntzin mi txi qꞌiꞌn tuꞌn twutz kawil. Quꞌn qa mina, kxel qꞌoꞌn toj kyqꞌobꞌ xqꞌuqil, tuꞌn tkux jpuꞌn toj tze. ");
INSERT INTO mamC_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Twutzxix kxel nqꞌmaꞌn tey, nlay tzꞌetza antza tzmaxiꞌ aj tchjet tkyaqil tkꞌasa. ");
INSERT INTO mamC_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","O kybꞌiꞌy ajo qꞌumle kye ojtxe qxeꞌchil: Mi chi kyꞌaꞌjiꞌnch. ");
INSERT INTO mamC_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Me metzin weꞌ kxel nqꞌmaꞌn kyeꞌy, ankyeꞌ qa ma txi tkaꞌyin jun qya, ex qa ma pon tkꞌuꞌj tiꞌj, ma bꞌinchin aj pajil tukꞌa toj tanmin twutz Dios. ");
INSERT INTO mamC_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tuꞌnpetziꞌn, wenitla tuꞌn tjatz kyiꞌn toj kyanmiꞌn tkyaqiljo, a nxi qꞌiꞌn kyeꞌy toj il. Ikytziꞌn, noqit qa tuꞌn tpaj kywutza aku chi kubꞌ tzꞌaqiy toj il, kyimitza, ex kyxomixa najchaq. Quꞌn wenitla tuꞌn tnaj jun tnej kyxmilila, tzeꞌnku tuꞌn kyxiꞌ kyxmilila tkyaqil toj qꞌaqꞌ te jun majx, aj kykyima. ");
INSERT INTO mamC_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ex qa noq tuꞌn kyman qꞌobꞌa, aku chi kubꞌ tzꞌaqiy toj il, kytxꞌemimila, ex kyxomixa najchaq. Quꞌn wenitla tuꞌn tnaj jun tnej kyxmilila, tzeꞌnku tuꞌn kyxiꞌ kyxmilila tkyaqil toj qꞌaqꞌ te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ex ikyx o qꞌumle ojtxe: Qa at jun xkubꞌ tpaꞌn tibꞌ tukꞌa t-xuꞌjil, il tiꞌj nej tuꞌn tbꞌant jun uꞌj kyxol, qa o chi paꞌyit. ");
INSERT INTO mamC_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Me metzin weꞌ kxel nqꞌmaꞌn, qa at jun ichin xkubꞌ tpaꞌn tibꞌ tukꞌa t-xuꞌjil noq kukxjo, ex nya tuꞌn ma kubꞌ tzꞌaq t-xuꞌjil toj kyꞌaꞌjin, tuꞌn tpaj k-okileꞌ t-xuꞌjil te aj kyꞌaꞌjil, aj tok meje tukꞌa juntl ichin. Ex ankyeꞌ ichin, k-okil meje tukꞌa qya, a otaq tzꞌel lajoꞌn, ex ikyxjo, k-okil aj kyꞌaꞌjil, quꞌn twutz Dios, nya ma paꞌyitjo qya tukꞌa tnejil tchmil. ");
INSERT INTO mamC_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ex ikyxjo, o kybꞌiꞌy a qꞌumle kye ojtxe qxeꞌchil, qa il tiꞌj tuꞌn tbꞌajx kyyola, aj qa ma tzaj kytxkoꞌn tbꞌi Dios toj. ");
INSERT INTO mamC_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Me metzin weꞌ kxel nqꞌmaꞌn: Mi tzaj kytxkoꞌn tbꞌi jun aꞌla mo tbꞌi jun tiꞌ toj kyyola; tzeꞌnku tbꞌi kyaꞌj, quꞌn atzin tqꞌuqbꞌil Diosjo; ");
INSERT INTO mamC_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","mo tbꞌi txꞌotxꞌ, quꞌn ax Dios nkawin tibꞌaj; exjo tbꞌi tnam Jerusalén, quꞌn atzin Ttanim Diosjo, a Nmaq Kawil. ");
INSERT INTO mamC_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ex mi kubꞌ kyqꞌmaꞌn jun kyyola, tiꞌj tsaqil kywiꞌy, quꞌn nlay saqix mo qꞌaqix jun tsmal kywiꞌy kyuꞌnxa. ");
INSERT INTO mamC_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Qalaꞌ chi yolinxa twutzx qa twutzx, ex qa mina, minax. Quꞌn atziꞌn nkubꞌ kyqꞌmaꞌn tbꞌi aꞌlchaqku kye toj kyyola, tuꞌn tajaw iljo ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Bꞌiꞌn kyuꞌn qa qꞌumle ojtxe, qa ma tzꞌetz jun kywutza tuꞌn jun xjal, il tiꞌj tuꞌn tetzjo texjal; ex qa ma tzꞌetz kysteꞌy tuꞌn jun xjal, ex il tiꞌj tuꞌn tetzjo texjal kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Me metzin weꞌ kxel nqꞌmaꞌn kyeꞌy, qa at jun xjal s-ok lipin kyiꞌja, mi tzꞌok kyqꞌoꞌn t-xel, expe qa ma tzꞌok laqtzꞌin jun plaj kytziꞌy, kymeltzꞌinxjiꞌy jun plajtl. ");
INSERT INTO mamC_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ex qa at jun s-ok tstzꞌiꞌminte tkamiẍ kyiꞌja, ex chex qꞌiꞌn twutz kawil tuꞌn tpajjo ikyjo, kyqꞌonxa te, expe qa majxjo kychaketa kykotpinxa. ");
INSERT INTO mamC_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ex qa ma tzꞌok qꞌoꞌn il kyiꞌja, tuꞌn t-xi kyiqin jun iqtz toj nikyꞌjin ajlabꞌ, majx kyiqinxa toj juntl ajlabꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chi oka soꞌj tukꞌa tkyaqil, ex mi chi oka nya soꞌj tukꞌa xjal, a ntiꞌ at te. ");
INSERT INTO mamC_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ex ikyxjo, bꞌiꞌn kyuꞌn tzeꞌn qꞌumle kyuꞌnxjal ojtxe: Kykꞌuꞌjlinqekjiꞌy kyukꞌiy, ex kyiꞌjlinqemiljiꞌy ayeꞌ nchi jaw, tuꞌn kyqꞌoj kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Me metzin weꞌ kxel nqꞌmaꞌn: Tenx tqꞌaqꞌbꞌil kykꞌuꞌja kyiꞌjjo nchi qꞌojin kyiꞌja; ex chi naꞌn Dios kyiꞌjjo nchi yasin kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Quꞌn kꞌwalbꞌajqexixa te kytatiꞌy, a at toj kyaꞌj. Quꞌn ate ntzaj qꞌonte qꞌij kyibꞌajjo wen ex kyibꞌajjo mina; ex n-etz qꞌonte jbꞌal kyibꞌajjo o chi nimin tiꞌj exqetziꞌn bꞌinchil il. ");
INSERT INTO mamC_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Quꞌn qa oꞌkqex nchi ok kykꞌuꞌjlinjiꞌy aye kꞌuꞌjlinqiꞌy kyuꞌn, ¿Ma atpela jun oyaj kyeꞌy toj kyaꞌj? Quꞌn ikypen kye peyil pwaq ex jniꞌ aj il nbꞌant kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ex qa oꞌkqex ẍi ok kyqꞌolbꞌinjiꞌy aye nimil, ¿Tiꞌtzin chꞌin wen nbꞌant kyuꞌn ikyjo? Quꞌn ikypen kye xjaljo nbꞌant kyuꞌn, ayeꞌ nya ojtzqiꞌn Dios kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tuꞌnpetziꞌn, chi okxa tzꞌaqle, tzeꞌnkuꞌ te kyTatiꞌy toj kyaꞌj tzꞌaqlexix teꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kykaꞌyink kyibꞌa; mi kubꞌ kyyekꞌiꞌn kynimbꞌila kywutzxjal, noq tuꞌn kyjawku kaꞌylaj kyiꞌja. Quꞌn qa ma kubꞌ kybꞌinchiꞌn ikyjo, nlay tzaj qꞌoꞌn jun oyaj kyeꞌy tuꞌn qMan at toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tuꞌnpetziꞌn, aj qa ma chi oniꞌn kyiꞌjjo ntiꞌx chꞌin at kye, mi kubꞌ kybꞌinchiꞌn noq tuꞌn telku kyqanila kyxolilexjal, tzeꞌnku nbꞌant kyuꞌn xmiletzꞌ, ayeꞌ nimsil kyibꞌ, kyojileꞌ ja te kꞌulbꞌil ex kyxolileꞌ tnam, noq tuꞌn tkubꞌ kyyolinku xjal qa tbꞌanilqex. Twutzx kxel nqꞌmaꞌn kyeꞌy, qa kyinxla chꞌin chojbꞌiljo ktzajil qꞌoꞌn tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Qalaꞌ, aj t-xi kyqꞌoꞌn jun onbꞌil kye yaj, kyqꞌonxa toj ewajil, tuꞌntzin mix aꞌl jun aku lonte, mixpela jun kyukꞌaxixa kbꞌilte. Quꞌn a te qMan Dios, a nkaꞌyin kyiꞌja toj ewajil, ktzajil qꞌonte t-xel kyeꞌy tiꞌjjo lo. ");
INSERT INTO mamC_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ex aj kynaꞌn Dios, mi chi oka tzeꞌn kye xmiletzꞌ, a waꞌlqenaj nchi naꞌn Dios toj ja te kꞌulbꞌil ex toj xkyꞌich bꞌe toj tnam, noq tuꞌn kyokku kaꞌyin kyuꞌnxjal, ex tuꞌn kyjaw nimsin. Me twutzxix kxel nqꞌmaꞌn kyeꞌy, qa tiꞌjjo ikyjo, kyinxla chꞌin chojbꞌiljo tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Qalaꞌ, aj kynaꞌn Dios, ku kyokxa tuja, ex kyjpumitz kyjaꞌy. Exsin kux chi naꞌntza Dios kyjunala toj ewajil, quꞌn ate Dios nkaꞌyin kyiꞌja toj ewajil, ex ax ktzajil qꞌoꞌnte chojbꞌil kyeꞌy tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ex aj kyok ten naꞌl Dios, nya noq tiꞌchaqku kchi okil ten qꞌmalte, tzeꞌnku nbꞌant kyuꞌnxjal, a nya ojtzqiꞌn Dios kyuꞌn. Quꞌn toj kywutz, nyakuj noq tuꞌn ikyjo, kchi tzajil bꞌiꞌn tuꞌn Dios; qalaꞌ tukꞌax jun jteꞌ yol, me qa nkynaꞌn toj kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mitzin chi oka tzeꞌnqekuꞌ xjal xmiletzꞌ anetziꞌn, quꞌn noqtzin chi oktza tzeꞌnqe nya nimil. Quꞌn ex ojtzqiꞌnl te kyMan tuꞌn, naꞌmxtaq txi kyqaniꞌn alkye ntiꞌ kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tuꞌnpetziꞌn, iky chi naꞌla Diosjiꞌy kyjaluꞌn: Ay qMan Dios, ate toj kyaꞌj, noqit tzꞌel kynikyꞌxjal qa xjanxixjo tbꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Noqit tkuꞌtzjo Tkawbꞌila tzaluꞌn twutz txꞌotxꞌ, tuꞌntzintla tbꞌantjo tajbꞌila tzaluꞌn, tzeꞌnkuxjo nbꞌant toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Qꞌontzjiy qwaꞌy nimxix te qꞌij jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ex najsimjiy qila, a o bꞌant quꞌn, tzeꞌnku qeꞌ, nkubꞌ qnajsiꞌn kyilxjal nchi bꞌinchin mibꞌin qiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mi ttziyiy tuꞌn qkubꞌ tzꞌaqa toj jun joybꞌil, aj ttzaj qiꞌja; qalaꞌ qo tkloma toj tqꞌobꞌ tajaw il. Quꞌn tex te tkyaqil Tkawbꞌil, ex nimx te tipin, ex jniꞌ tqoptzꞌajiyila jaꞌlin, ex te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Quꞌn qa ma kubꞌ kynajsiꞌn kyiljo nchi ok lipin kyiꞌja, ex ikyxjo te qMan Dios, a at toj kyaꞌj, kꞌwel tnajsin kyila. ");
INSERT INTO mamC_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Me qa mix kubꞌ kynajsiꞌn kyiljo nchi ok lipin kyiꞌja, ex ikyxjo te qMan Dios, mi kubꞌ tnajsin kyila. ");
INSERT INTO mamC_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ajtzin tkubꞌ kypaꞌn waꞌyaj tuꞌn kynaꞌn Diosa, mi kubꞌ kyyekꞌiꞌn qa nqꞌaqꞌin kykꞌuꞌja, ex mi chi jaw bꞌisiꞌn, tzeꞌnku nbꞌant kyuꞌn xmiletzꞌ, ayeꞌ nimsil kyibꞌ, noq tuꞌn telku kynikyꞌtzajil qa nchi paꞌn waꞌyaj. Twutzx kxel nqꞌmaꞌn kyeꞌy, qa oꞌkx chꞌin chojbꞌiljo tiꞌjjo lo. ");
INSERT INTO mamC_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Qalaꞌ, aj kypaꞌn waꞌyaj tuꞌn kynaꞌn Dios, kybꞌinchim kyibꞌa, kytxjomil kywutza, ex chi tzeꞌjiꞌy, ");
INSERT INTO mamC_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tuꞌntzin mi tzꞌele kynikyꞌxjal kyeꞌy, qa nchi paꞌn waꞌyaj; qalaꞌ oꞌkx kyMaꞌn, ex ax ktzajil qꞌonte chojbꞌil kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mi kubꞌ kychmoꞌnjiꞌy kyqꞌinimila tzaluꞌn twutz txꞌotxꞌ, a jaꞌ taꞌye pokꞌ tuꞌn tyuchꞌj, ex jaꞌ aku tzꞌoke jun tiꞌ kyiꞌj, ex a jaꞌ aku chi okxi ileqꞌ elqꞌilte. ");
INSERT INTO mamC_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Qalaꞌ kychmomjiꞌy kyqꞌinimila toj kyaꞌj, noq tuꞌn kybꞌinchbꞌiꞌn bꞌaꞌn, tzeꞌnku taj Dios, quꞌn nlaypen kubꞌ pokꞌix teꞌ, nlay qꞌayj, ex nlay tzꞌex tuꞌn ileqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Quꞌn jaꞌ taꞌyex kyqꞌinimila, axsa kxele lipeye kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ajo kywutza tzeꞌnku jun tzaj te kyxmilila ex te kyanmiꞌn. Qa wen kywutza, at spikyꞌin toj kyanmiꞌn tuꞌn tel kynikyꞌa tiꞌj tkyaqiljo wen. ");
INSERT INTO mamC_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Me qatzin ma txi kyqꞌoꞌn ambꞌil te kywutza noq tuꞌn kykaꞌyiꞌn tiꞌjjo nya wen, ex ikyxjo ok k-okil kyanmiꞌn te nya wen, ex toj qxopin. Mi qe kykꞌuꞌja tiꞌj jun kyanmiꞌn nya wen, quꞌn kchi kꞌwel sbꞌuꞌn tuꞌn, tuꞌn kyxi qꞌiꞌn toj manyor qxopin. ");
INSERT INTO mamC_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mix aꞌl jun aku tzꞌajbꞌin te kabꞌe tajaw aqꞌuntl. Quꞌn k-elil tiꞌjliꞌn tnejil, ex k-okil tkꞌuꞌjliꞌn tkabꞌ; mo k-okilj tzꞌaqle tukꞌa tnejil, me bꞌeꞌx aku tzꞌel tiꞌjlinljo tkabꞌ. Nlayx bꞌant tuꞌn tokin te Dios ex te pwaq. ");
INSERT INTO mamC_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy, mi chi bꞌisiꞌn tiꞌj tzeꞌn tten tuꞌn kyanqꞌiꞌn: Qa tiꞌj kywaꞌy mo tiꞌj kykꞌwaꞌy, mo tiꞌj kyxbꞌaliꞌn. ¿Ankye nej; a kywaꞌy mo a kychwinqilja? ¿Ex atzin kyxbꞌaliꞌn mo a kyxmililja? ");
INSERT INTO mamC_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Quꞌn kykaꞌyinqektzinjiꞌy tal pichꞌ nchi lipin twutz kyaꞌj; mi nchi awan, mi nchi kꞌuꞌn kyawal. ¿Ma tzuꞌntzin nchi kyim? Mina, quꞌn a kyMaꞌn, a at toj kyaꞌj, kꞌaꞌchilkye. ¿Ma nyatzin aye kyeꞌ nim kyoklin tzeꞌnqekuꞌ tal pichꞌ? ");
INSERT INTO mamC_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Quꞌn mixpetzin tuꞌn chi ja meljtza, ¿Ma akutzin txi nimix toj kychwinqiltza nipela jun or? ");
INSERT INTO mamC_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Ex tiquꞌn tzunx chi bꞌisinxa tiꞌj kyxbꞌaliꞌn? Kykaꞌyinktziꞌn tzeꞌn nchi chꞌiyeꞌ jniꞌ t-xmakil kꞌul. Mina nchi aqꞌnin, ex mina nchi chubꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Me kxel nqꞌmaꞌn kyeꞌy, qa a qtzan nmaq kawil Salomón ojtxe, tukꞌa tkyaqil tqꞌinimil, s-ok tktxuꞌn tibꞌ tukꞌa t-xbꞌalin tbꞌanilx wen, me mix kanine tqoptzꞌajiyil t-xbꞌalin, tzeꞌn kaꞌyiꞌn jun tal t-xmakil kꞌul. ");
INSERT INTO mamC_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Qatzin qa nchi ok tktxuꞌn Diostzjo tal t-xmakil kꞌul ikyjo, a loqe tzunx nchi milinx toj kojbꞌil jaꞌlin, me meljo nchiꞌj bꞌeꞌx kchi kꞌwel bꞌolj tuꞌn qꞌaqꞌ; ¿Yajxsila kyetza? ¿Nyapela kchi okil ktxuꞌn kyeꞌ tuꞌn Dios? Quꞌn qa noq oꞌkxtza nchi bꞌisiniꞌy tiꞌjjo tkyaqiljo lo, antza nyekꞌine qa noq tal chꞌin kynimbꞌila. ");
INSERT INTO mamC_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tuꞌntziꞌn, mi chi bꞌisiꞌn, ex mi kyqꞌmaꞌy: ¿Tiꞌ kxel qwaꞌn, mo qa tiꞌ kxel qkꞌwaꞌn, mo qa tzeꞌn tten qxbꞌalin tuꞌn tok? qa chi chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Quꞌn ayetzin kyeꞌ txqantl xjal, a nya nimil, nimx nchi jaw melj kyeꞌ tiꞌj tkyaqiljo lo. Me metziꞌn kyetza, at jun kyeꞌ kyMan toj kyaꞌj, a ojtzqiꞌn tuꞌn alkye atx taj kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tuꞌnpetziꞌn, kyjyomtziꞌn Tkawbꞌil qMan toj kyaꞌj te tnejil, ex kybꞌinchinkujiꞌy a tzꞌaqle toj twutz, ex okpetzin ktzajil kykꞌmoꞌntza tkyaqiljo txqantl. ");
INSERT INTO mamC_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mi chi bꞌisin kyeꞌ tiꞌjjo nchiꞌj, quꞌn nchiꞌjxi teꞌ, ex tex teꞌ tkyaqiljo kbꞌajil toj. Quꞌn toj jun qꞌij nimku aku bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mi chi oka kawil kyibꞌaj kynimbꞌil txqantl, tuꞌntzintla mi kawine Dios kyibꞌaja. ");
INSERT INTO mamC_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Quꞌn kchi okila toj xjelbꞌil tuꞌn nchi kawiꞌn kyibꞌaj txqantl. Atziꞌn nukꞌbꞌil lo ikytziꞌn tzeꞌn nchi miloꞌn kyiꞌj txqantl. Tuꞌntziꞌn, jniꞌx malbꞌil k-okil kyqꞌoꞌn kyiꞌj txqantl, ikyxjo k-okil kyiꞌja tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Nya wen tuꞌn tyolbꞌiꞌn tiꞌj juntl, quꞌn ikytziꞌn tzeꞌnku jun xjal tokx jun ma tij tze toj twutz, exsin tajtz tuꞌn tetz tiꞌn jun tal netzꞌ tzꞌis toj twutz juntl tukꞌa. ¿Tzeꞌntzin tten tuꞌn t-xi tqꞌmaꞌn te termana: Yoꞌnkutzin nej, tuꞌn tetz wiꞌn tzꞌis toj twutza, ex mi naꞌnl te tuꞌn, qa at jun ma tij tze tokx toj twutza? ");
INSERT INTO mamC_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Xmiletzꞌa. Il tiꞌj tuꞌn tetz tiꞌnjiy te nej a ma tij tze tokx toj twutza, tuꞌntzin tlontejiy tal netzꞌ tzꞌis tokx toj twutz termana. ");
INSERT INTO mamC_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Bꞌaꞌnqexa noq txi kyqꞌonjiꞌy tumil, a tzꞌaqle twutz Dios, kye xjal, ayeꞌ noqx nchi yasin tiꞌj Tbꞌanil Tqanil, quꞌn okla k-elil kyiꞌjlin kyyola, mo tzeꞌnqekuꞌ jun kuch nipela tuꞌn t-xiꞌ jun qꞌinimil kye, noq aku bꞌaj kywaꞌbꞌin. Ex aku chi tzaj meltzꞌaj kyiꞌja tzeꞌnku jun txꞌuꞌj txꞌyan. ");
INSERT INTO mamC_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Qa ma txi kyqaniꞌn, ktzajil tqꞌoꞌn Dios; qa ma chi jyoꞌn tiꞌjjo t-xilin tajbꞌil qMan, ex knetil kyuꞌn; ex qa ma txi kyqꞌolbꞌiꞌn toj kynaꞌj Diosa, ex ktzajil ttzaqꞌwin kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Quꞌn alkye nqanin jun tiꞌ, ok kꞌmetil tuꞌn; ex alkye njyoꞌnxix, ok knetil tuꞌn; ex alkye nqꞌolbꞌin, ex ok ktzajil tzaqꞌwin. ");
INSERT INTO mamC_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Quꞌn ¿Ma akutzin txi kyqꞌoꞌn kyeꞌ jun abꞌj te jun kykꞌwala, qa ma tqanin twa? ");
INSERT INTO mamC_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Mo txi kyqꞌoꞌn jun kan te, qa ma tqanin jun tchiꞌ kyiẍ? ¡Mina! ");
INSERT INTO mamC_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Quꞌn exla qa aj ilqiꞌy, me tililx tiꞌj kxel kyqꞌoꞌn jun tbꞌanil tiꞌ te kykꞌwala. ¿Yajtzilaꞌ te kyMaꞌn at toj kyaꞌj? ¿Ma nlaypela tzaj tqꞌoꞌn jun tbꞌanil tiꞌ kyeꞌ, ayeꞌ nchi qanin tiꞌj? ");
INSERT INTO mamC_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tuꞌnpetziꞌn, kybꞌinchinkujiꞌy kyukꞌa txqantl, a tzeꞌnku kyaja tuꞌn tkubꞌ kybꞌinchin txqantl kyukꞌiy. Quꞌn a nukꞌbꞌil lo, ikyx t-xilin tojjo ojtxe kawbꞌil ex jniꞌ kyyol yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ku kyokxa tojjo tal tjpel bꞌe tal muchꞌ te chwinqil. Quꞌn atzin ma tij tjpeljo ma tij bꞌe, tbꞌanilx wen toj kywutzxjal, ex ma nintz nbꞌaj bꞌet toj; me atzin bꞌe anetziꞌn nqox tiꞌn toj najin. ");
INSERT INTO mamC_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Me atzin tal muchꞌ tjpel exsin bꞌe tal muchꞌ nqox tiꞌn toj chwinqil te jun majx, ex nya ilaꞌ taj tuꞌn tbꞌet toj. ");
INSERT INTO mamC_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kykaꞌyimtzin kyibꞌa kyejo sbꞌul yol, ayeꞌ n-ok kyqꞌoꞌn kyibꞌ te yolil Tyol Dios. N-ok kyqꞌoꞌn kyibꞌ te nimil ex tal mutxin xjal wen, tzeꞌnku jun tal rit; me toj kyanmin manyor xoꞌjqex. ");
INSERT INTO mamC_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Me noq tiꞌjjo kybꞌinchbꞌin k-elile kynikyꞌa kye, quꞌn ikytziꞌn tzeꞌnku jun tze, n-el tnikyꞌtzajil noq tiꞌjjo twutz. Quꞌn nlay tzꞌel jun uv tiꞌj tqan txꞌiꞌx; ex nlay tzꞌel jun iw noq tiꞌj jun tqan kꞌul. ");
INSERT INTO mamC_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ikytziꞌn tzeꞌn jun tze, qa tbꞌanilx tze, ex tbꞌanilqe twutz chi elil te lobꞌj. Ex qa mina, nlay chi el twutz tbꞌanil. ");
INSERT INTO mamC_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Quꞌn jun tze wen, nlay tzꞌel twutz nya wen. Ex jun tze nya wen, nlay tzꞌel twutz wen. ");
INSERT INTO mamC_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Quꞌn tkyaqiljo tze, qa nya wen twutz s-el, kjawil txꞌemit, ex k-okix toj qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tuꞌnpetziꞌn, noq tiꞌjjo kybꞌinchbꞌin, k-elile kynikyꞌa kye qa wen xjalqe mo minaj. ");
INSERT INTO mamC_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Quꞌn nya kykyaqiljo nkyqꞌmaꞌn weꞌy: WAjaw, wAjaw, kchi okix toj Tkawbꞌil Dios toj kyaꞌj. Qalaꞌ okqexjo, ayeꞌ nkubꞌ kybꞌinchin a tajbꞌil nMaꞌn, a at toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Quꞌn aj tpon qꞌij te paꞌbꞌin twutz Dios, nimxjal kqꞌmalte weꞌy: WAjaw, wAjaw, ma qo yolin qe tiꞌj tbꞌiy, ex tukꞌa tipin tbꞌiy, i bꞌaj ex taqꞌnil tajaw il toj kyanminxjal quꞌn; ex noq tukꞌa tipin tbꞌiy, bꞌanteꞌ nim techil tipiꞌn quꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ex oktzin kxel nqꞌmantza kye: Nya weqiꞌy. Chi laqꞌexa nkꞌatza, quꞌn bꞌinchil ilqiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tuꞌnpetziꞌn, kykyaqiljo nchi bꞌin nyola, ex nkubꞌ kybꞌinchin tzeꞌnku nxi nqꞌmaꞌn, ikyqetziꞌn tzeꞌnku jun xjal at tnabꞌl, a kux tqꞌoꞌn abꞌj te tqꞌuqil tja, tej tjaw tbꞌinchin. ");
INSERT INTO mamC_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tej ttzaj jbꞌal, chꞌiy nim aꞌ tiꞌjile, ex tzaj txqan kyqꞌiqꞌ tiꞌj. Me mix yekchix, quꞌn tuꞌn tjaw tqꞌuqil abꞌj kujxix. ");
INSERT INTO mamC_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Me ayetziꞌn nchi bꞌin tiꞌj nyola, ex mi nkubꞌ kybꞌinchin tzeꞌnku nxi nqꞌmaꞌn, ikyqetziꞌn tzeꞌnku jun xjal ntiꞌ tnabꞌl, a jaw tbꞌinchin tja tibꞌaj tzꞌawin. ");
INSERT INTO mamC_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ex tej ttzaj txqan jbꞌal, chꞌiy nim aꞌ tiꞌjile, ex tzaj txqan kyqꞌiqꞌ tiꞌj. Bꞌeꞌx ikyꞌ pakꞌchaj, quꞌn bꞌeꞌx el yulj tzꞌawin tjaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tbꞌajlinxitzin tyolin Jesúsjo ikyjo, bꞌeꞌx i jaw kaꞌylaj xjal tiꞌjjo t-xnaqꞌtzbꞌil, ");
INSERT INTO mamC_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","quꞌn atzin t-xnaqꞌtzbꞌil tbꞌanilxix tukꞌa tkyaqil toklin Dios, ex mikyxiꞌ tzeꞌn kyxnaqꞌtzbꞌil xnaqꞌtzil tiꞌj ojtxe tkawbꞌil Judiy. ");
INSERT INTO mamC_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tej tmeltzꞌaj Jesús twiꞌ wutz, nimx txqan xjal ok lipe tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Me tzaj laqꞌe jun ichin tkꞌatz Jesús, yabꞌtaq tuꞌn jun txꞌaꞌk, a noq n-el lemimin. Ex kubꞌ meje twutz Jesús, ex xi tqꞌmaꞌn: WAjaw, qa taja, bꞌaꞌn tuꞌn nkubꞌ tqꞌaniꞌn tukꞌa nyabꞌila. ");
INSERT INTO mamC_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Noq ok tmikoꞌn Jesús, ex xi tqꞌmaꞌn te: Waja. ¡Bꞌeꞌx ma qꞌanita jaꞌlin! Noq tej t-xi tqꞌmaꞌn Jesúsjo yol ikyjo, bꞌeꞌx qꞌanitkux te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ex xi tqꞌmaꞌntl Jesús te: Bꞌiꞌnkuy. Mi txi tqꞌmaꞌn te aꞌla. Qalaꞌ ku txiꞌy, ex yekꞌinx tibꞌa te kypale aj Judiy, ex qꞌonxa jun oyaj te aqꞌbꞌil chjonte, tuꞌn ma tzul Dios tey, a tzeꞌnkuxjo kubꞌ ttzꞌibꞌin Moisés ojtxe, tuꞌntzin kybꞌin texjal qa ma qꞌanita. ");
INSERT INTO mamC_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tej tokx Jesús toj tnam Capernaum, tzaj laqꞌe jun ichin, nejinel kye xoꞌl qꞌaqꞌ; tukꞌa kubꞌsbꞌil twutz, ");
INSERT INTO mamC_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","xi tqꞌmaꞌn kyjaluꞌn: WAjaw, noq samiꞌy. At jun weꞌ waqꞌnil tkubꞌ twiꞌ watbꞌil. Mi nyekjl, ex nim kyixkꞌoj n-ikyꞌx tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Xi tqꞌmaꞌn Jesús te: Kꞌaꞌ chinka qꞌanilte. ");
INSERT INTO mamC_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ex xi ttzaqꞌwin nejinel: WAjaw, ntiꞌx weꞌ woklin, tuꞌn tokxa toj njaꞌy. Qalaꞌ noq qꞌmaꞌnx jun Tyola, ex bꞌeꞌx kweꞌbꞌil weꞌ waqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Quꞌn ikyqinx wejiꞌy at weꞌ kawilwe, me ex iteꞌ xoꞌl qꞌaqꞌ iteꞌkx tjaqꞌ nkawbꞌila. Qatzin ma txi nqꞌmaꞌn te jun kyjaluꞌn: Kux txiꞌy, ex bꞌeꞌxsin kxeltz; ex qa: Kux tzaja, qa nchijiꞌy te juntl, ex bꞌeꞌx ktzajil. Ex qa: Bꞌinchinkujiy luꞌn, qa nchijiꞌy te waqꞌnila, ex bꞌeꞌx kꞌwel tbꞌinchin. Ikytziꞌn, n-el nikyꞌjiꞌy tiꞌja, qa aku qꞌanj noq tuꞌn Tyola. ");
INSERT INTO mamC_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tej tbꞌinte Jesúsjo ikyjo, bꞌeꞌx jaw kaꞌylaj, ex xi tqꞌmaꞌn kye lipajqe tiꞌj kyjaluꞌn: Twutzxix kxel nqꞌmaꞌn kyeꞌy; bꞌajxi nbꞌintiꞌy jun xjal kyxol kykyaqil aj Israel iky tnimbꞌiljo tzeꞌnku tnimbꞌiljo ichin lo. ");
INSERT INTO mamC_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn qa nimjo xjal nya Judiy, ktzajil toj tjawitz qꞌij ex toj telix, ex kchi kꞌwel qe waꞌl tukꞌa Abraham, tukꞌa Isaac ex Jacob toj nintz qꞌij toj Tkawbꞌil Dios toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Me ayetzin kyeꞌ, a mi nxi kynimin, exla qa Judiy, a tuꞌntaq kyten tojjo nintz qꞌij, ok chi xel xoꞌyit toj manyor qxopinx, a jaꞌ kchi oqꞌile, ex kchi juꞌchꞌile kyste tuꞌn nim kyixkꞌoj. ");
INSERT INTO mamC_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ex xi tqꞌmaꞌn Jesús te nejinel: Kux tzꞌaja tjay. Quꞌn tzeꞌnkuxsiꞌn ma txi tnimiꞌn, ikyx kbꞌantiljo. Ex atzin tej qꞌa, jun paqx qꞌanit. ");
INSERT INTO mamC_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ex bꞌeꞌx i xiꞌ Jesús tzma tja Pegr. Tej tkanin Jesús tja Pegr, ok tkaꞌyin tnana t-xuꞌjil Pegr kuẍletaq tibꞌaj watbꞌil tuꞌn kyaq. ");
INSERT INTO mamC_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ok tmikoꞌn Jesús tqꞌobꞌ, ex bꞌeꞌx ul Dios te, ex njawku weꞌ, ex n-ok tenku bꞌinchil chꞌin tiꞌ kye. ");
INSERT INTO mamC_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tej qok yupj, ax txqan xjal i ul qꞌanil kyyabꞌ, ayeꞌ tzyuꞌnqetaq tuꞌn taqꞌnil tajaw il. Ex junchꞌinx Tyol xi tqꞌmaꞌn kye taqꞌnil tajaw il, ex bꞌeꞌx i bꞌaj ex toj kyanmin, ex nimku txqantl yabꞌ bꞌeꞌx i bꞌaj qꞌanit tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","O bꞌantjo luꞌn tuꞌn tjapiꞌn yol, a kubꞌ tyolin yolil Tyol Dios ojtxe, a Isaías, tej tqꞌmante: Ate tzaj mojinqe toj sikytlin. Ex a el qꞌinte jniꞌ yabꞌil qiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tej tok tkaꞌyin Jesús txqan xjal otaq tzꞌok chmet tiꞌjile, xi tqꞌmaꞌn kye t-xnaqꞌtzbꞌin, tuꞌn kyikyꞌx tukꞌa tjlajxi nijabꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Antza, xi laqꞌe jun xnaqꞌtzil tiꞌj ojtxe tkawbꞌil Judiy tkꞌatz, ex xi tqꞌmaꞌn te: Xnaqꞌtzil, waja tuꞌn nxi lipeꞌy tiꞌja, jaꞌchaqx txiyitza, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Xi ttzaqꞌwin Jesús te: ¿Ma twutzxixsin tey qa aku txi lipeꞌy wiꞌja? Me majx kxel nqꞌmaꞌn tey: At kye wech kyjul te kynajbꞌil; ex at kye pichꞌ kypaqbꞌil. Me metzin weꞌ, a Tkꞌwal Ichin, nipe jaꞌ tuꞌn nxi qꞌejeye chꞌin, ntiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Attaq juntl otaq tzꞌok lipe, me bꞌeꞌx xi tqꞌmaꞌn te Jesús: Taa, qꞌontza ambꞌil weꞌy quꞌn atzin ntatiy ma tijin. ¿Nlaypela chin kubꞌ tayoꞌn chꞌin tzmaxi tuꞌn tkyim, ex tuꞌn tkux nmuquꞌn? Exsintla ẍinx lipetza tiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Me xi ttzaqꞌwin Jesús: Lipeka wiꞌja jaꞌlin. Chi tenku kyeꞌ, a kyimninqe toj kynimbꞌil, kꞌaꞌ kux kymuquꞌn kyeꞌ kyibꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tbꞌajlinxiꞌ ikyjo, okx Jesús toj bark, ex o xi lipeꞌy tiꞌj, a awoꞌy t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Me n-okku ten txqan qꞌankyaq tukꞌa txqan kyqꞌiqꞌ toj nijabꞌ; bꞌeꞌx bꞌaj okx piqꞌj txqan aꞌ tzma toj bark. Exsin otaq tzikyꞌ ktan Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Me awotzin qe, a t-xnaqꞌtzbꞌin, bꞌeꞌx o xiꞌy kꞌasilte tuꞌn qxobꞌila, ex xi qqꞌmaꞌn te: ¡QAjaw, qo tkloma! Chꞌix qxi mulqꞌaj toj aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ex tzaj ttzaqꞌwin Jesús qeꞌy: ¿Tiquꞌn nchi tzaj xobꞌa? Noqxla tal chꞌin kye kynimbꞌil wiꞌja. Tej tbꞌaj tqꞌmaꞌn ikyjo, jaw weꞌks Jesús, ex nxiku tqꞌmaꞌn te kyqꞌiqꞌ ex te aꞌ, tuꞌn kykubꞌ qen. Ex texjo paq, bꞌeꞌx bꞌaj kubꞌ nume tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bꞌeꞌx o jaw kaꞌylajxa tiꞌj, ex o bꞌaj jaw yoliꞌn qxolxa: ¿Alxsila kyeꞌ xjal ikyjo; a ajin kyqꞌiqꞌ ex aꞌ ma chi kubꞌ niminte? ");
INSERT INTO mamC_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tej tpon Jesús tjlajxi aꞌ toj txꞌotxꞌ te Gadara, i etz kabꞌe ichin kyoj muqbꞌil kyimnin, tokxtaq taqꞌnil tajaw il toj kyanmin. Nchi bꞌaj oktaq lipin kyiꞌjxjal; tuꞌntziꞌn, mixtaq aꞌlx n-ikyꞌ tojjo bꞌe antza. I tzaj laqꞌe tkꞌatz Jesús, ");
INSERT INTO mamC_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","exsin i jaw ẍchꞌintz kyjaluꞌn: Ay Jesús, Tkꞌwal Dios. ¿Tiꞌ taja qiꞌja? ¿Ma tzula yajil qeꞌy, ex naꞌm tpon tqꞌijil paꞌbꞌin? ");
INSERT INTO mamC_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nqayintaq nbꞌaj wane txqan kuch. ");
INSERT INTO mamC_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ayetziꞌn taqꞌnil tajaw il i jaw kubꞌsin kywutz te Jesús kyjaluꞌn: Qa ma qo etz tlajoꞌn toj kyanminjo xjal lo, tziyintza qeꞌy, tuꞌn qokxa kyoj kyanmin kuch. ");
INSERT INTO mamC_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ex xi ttzaqꞌwin Jesús kyjaluꞌn: Kux cheꞌxtza, chi Jesús kye. Bꞌeꞌxsin i bꞌajetz toj kyanmin ichin, ex i bꞌaj okx kyoj kyanmin kuch. Me ayetziꞌn tal kuch bꞌeꞌx i bꞌaj xiꞌ tolil kyibꞌ twiꞌ xaq, ex nqayinkutaql toke jun tij nijabꞌ. Bꞌeꞌx i bꞌaj jiqꞌwe antza. ");
INSERT INTO mamC_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Me ayetziꞌn nchi bꞌaj kyikꞌlentaq kuch, bꞌeꞌx i kubꞌ toj bꞌe tuꞌn kyxobꞌil. Tej kykanin toj tnam, i ok ten qꞌmalte kyexjal tiꞌ otaq bꞌaj kyiꞌjjo kuch ex kyiꞌjjo ichin, ayeꞌ tzyuꞌnqetaq kyuꞌn taqꞌnil tajaw il. ");
INSERT INTO mamC_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tuꞌntziꞌn ikyjo, kykyaqiljo jniꞌ xjal toj tnam, bꞌeꞌx i bꞌaj tzaj lolte Jesús. Tej tok kykaꞌyin ikyjo, i kubꞌsin kywutz te Jesús, tuꞌn tikyꞌ jaꞌ taꞌyetaq. ");
INSERT INTO mamC_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tbꞌajlinxiꞌ ikyjo, okx Jesús toj bark, ex ikyꞌx tjlajxi nijabꞌ, ex kanin toj ttanim. ");
INSERT INTO mamC_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Antza, pon kyiqin jun ichin, a noq otaq tzꞌok kꞌolpaj kuẍletaq tibꞌaj tkuẍbꞌil. Tej t-xi tkaꞌyin Jesús qa qꞌuqlektaq kykꞌuꞌj tiꞌj tuꞌn tqꞌanj, xi tqꞌmaꞌn te yabꞌ: Ay, nkꞌwal, nimsinx tkꞌuꞌja, quꞌn ayetziꞌn tila ma chi kubꞌ najsit jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iteꞌtaq junjun xnaqꞌtzil tiꞌj ojtxe kawbꞌil antza. Tej tok kybꞌiꞌn ikyjo, kubꞌ kyximin: Tzeꞌntzin tten n-el tzaqpaj ttzi ichin ikyjo. Noq nxoꞌn teꞌ yol tiꞌj Dios tuꞌn tyol. ");
INSERT INTO mamC_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Me ante Jesús bꞌeꞌx el tnikyꞌ tiꞌjjo nkubꞌ kyximintaq, ex xi tqꞌmaꞌn kye: ¿Tzeꞌn tten n-okxjo nya bꞌaꞌn toj kynabꞌla? ");
INSERT INTO mamC_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ankye junx tzꞌele, tuꞌn t-xi qꞌmet; tuꞌn tkubꞌ najsit til jun xjal, a tzeꞌnkuljo tuꞌn t-xi qꞌmet: Weꞌksa, ex kux bꞌeta? ¿Ma nyapela a te kujxixjo a tuꞌn tnajsit til jun xjal? ");
INSERT INTO mamC_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Me mi xi kynimiꞌn qa ikyjo. Me atzin jaꞌlin, kxel nyekꞌiꞌn kywutza qa ayiꞌn weꞌ, a Tkꞌwal Ichin, at wokliꞌn tzaluꞌn twutz txꞌotxꞌ, tuꞌn tkubꞌ nnajsiꞌn kyilxjal te jun majx. Tuꞌnpetziꞌn, xi tqꞌmaꞌn te yabꞌ: ¡Weꞌksa! ¡Qꞌinxjiy tkuẍbꞌila, ex kux tzꞌaja tjay! ");
INSERT INTO mamC_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Texjo paq, bꞌeꞌx jaw weꞌks tej yabꞌ, ex bꞌeꞌx aj tja. ");
INSERT INTO mamC_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tej tok kykaꞌyinxjal ikyjo, bꞌeꞌx i bꞌaj jaw kaꞌylaj. Ex jaw kynimsin tbꞌi Dios, tuꞌn tok kykaꞌyin, qa otaq tzaj qꞌoꞌn kyoklinxjal tuꞌn kyqꞌanit yabꞌ kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tej tikyꞌ Jesús antza, in xi tkaꞌyiꞌn ayiꞌn, Matey, qꞌuqleqintaqa toj jun tal ja te peybꞌil pwaq tuꞌn tajbꞌin kye aj Rom, a nchi kawintaq kyibꞌaj aj Israel. Tzaj tqꞌmaꞌn Jesús weꞌy: Lipeka wiꞌjach. Ex bꞌeꞌx in ikyꞌ lipeꞌy tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Juntl maj, nwaꞌntaq Jesús toj njaꞌy junx kyukꞌa txqantl t-xnaqꞌtzbꞌin. Ex ilaꞌku peyil pwaq exqetziꞌn junjun aj il iteꞌtaq antza, ex o ok qeꞌy tiꞌj meẍ junx tukꞌa Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Atzaj teꞌ tok kykaꞌyin Parisey ikyjo, i bꞌaj jaw qanlaj kyxolile, ex xi kyqanin qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin: ¿Tzeꞌntzin toke ikyjo? A kyxnaqꞌtzila nwaꞌn kyukꞌa aj peyil pwaq, ex kyukꞌa noq tiꞌchaqku maꞌ xjal aj il, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Me tej tbꞌinte Jesús ikyjo, xi tqꞌmaꞌn kye: Ayetziꞌn bꞌaꞌnqe ntiꞌ kye tajbꞌin qꞌanil kye; meqetziꞌn yabꞌqe, atpen kyeꞌ tajbꞌin kye. ");
INSERT INTO mamC_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tuꞌnpetziꞌn, kux cheꞌxa, ex noqit tzꞌel kynikyꞌa te t-xilinjo yol lo toj Tuꞌjil Tyol Dios: Atzin wajiꞌy, tuꞌn tten tqꞌaqꞌbꞌil kykꞌuꞌja kyxolxa, ex nya noq tuꞌn kyok teꞌn patil kychibꞌjil aluꞌmj te chojbꞌil kyila. Tuꞌnpetziꞌn, chi Jesús, nya ma chin tzaj weꞌ txkol kye xjal nbꞌaj kubꞌ kybꞌisin qa bꞌaꞌn kyten; qalaꞌ ayin wejiꞌy ma chin tzaj txkolkye, ayeꞌ bꞌinchil ilqe, ex tuꞌn tkubꞌ najsit kyil. ");
INSERT INTO mamC_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jun maj, i pon t-xnaqꞌtzbꞌin Juan, a Jawsil Aꞌ, tkꞌatz Jesús, ex xi kyqanin te: ¿Tzeꞌntzin tten qeꞌ exqetziꞌn Parisey noqx nqo paꞌnkuy waꞌyaj tuꞌn qnaꞌn Dios, ex ayetzin kyeꞌ t-xnaqꞌtzbꞌiꞌn mina? ");
INSERT INTO mamC_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Xi ttzaqꞌwin Jesús: ¿Bꞌispela aku chi tene kyeꞌ xjal, a txokenjqe toj jun mejebꞌlin, exsin at chmilbꞌaj kyxol? Quꞌn toj jun mejebꞌlin, nim tzaljbꞌil at, ex nim waꞌn nbꞌaj bꞌaj. Ikyqetzin wejiꞌy nxnaqꞌtzbꞌin, quꞌn loqiꞌn intin kyxol. Me pon kanin jun qꞌij, jaꞌ tuꞌn wele naja, ayiꞌn a ikyx tzeꞌnku chmilbꞌaj kyxol. Ajtzin tjapin kaninjo qꞌij anetziꞌn, okpetzile kꞌwel kypaꞌntz waꞌyaj tuꞌn kynaꞌn Dios wen. ");
INSERT INTO mamC_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ex tiꞌjjo lo kxel nqꞌmaꞌn kabꞌe tumil kyeꞌy: Tnejil, qa kyaja tuꞌn tkubꞌ kyslepiꞌn jun xbꞌalin ttxꞌaqin, nlay kubꞌ kyqꞌoꞌn jun slepbꞌilte saq, quꞌn ajtzin tkuꞌx txjetjo saq, bꞌeꞌx k-okil jukꞌpaj, exsin bꞌeꞌx k-elix laqj txqantljo ttxꞌaqin. ");
INSERT INTO mamC_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ex tkabꞌ, tzeꞌn aj tkux bꞌinchit vin; nlay kuꞌx bꞌinchit toj jun ttxꞌaqin tzꞌuꞌn, quꞌn ajtzin tloqlin, bꞌeꞌx aku tzꞌex laqj, ex noq aku chi kubꞌ najx kykabꞌil. Tuꞌntzintzjo, il tiꞌj tuꞌn tkux bꞌinchit vin toj jun saq tzꞌuꞌn, tuꞌntzin mi chi kubꞌ naje kykabꞌil. Ikytziꞌn wejiꞌy nxnaqꞌtzbꞌil, nlay bꞌant tuꞌn tok smet tukꞌa juntl tumil. ");
INSERT INTO mamC_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tzmataq nyolin Jesús kyiꞌjjo luꞌn, tej tkanin jun nejinel kyxol aj Judiy. Kubꞌ meje twutz, ex xi tqꞌmaꞌn te: Ma kyim jun nkꞌwala txin. Me qa ma tzaja, ex qa ma kubꞌ tqꞌoꞌn tqꞌobꞌa tibꞌaj, kjawil anqꞌin juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jaw weꞌks Jesús, ex bꞌeꞌx i xiꞌ junx qukꞌiy, awoꞌy t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Me toj bꞌe attaq jun qya, otaq bꞌant kabꞌlajaj abꞌqꞌe tyabꞌtlin tuꞌn kyyabꞌil. Tzaj laqꞌe tiꞌjxi Jesús, ex ok tmikoꞌn ttxaꞌn t-xbꞌalin, ");
INSERT INTO mamC_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","quꞌn kubꞌ tbꞌisin, qa noq tuꞌn tok tmikoꞌn ttxaꞌn t-xbꞌalin, bꞌeꞌx k-elil weꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aj meltzꞌaj Jesús tiꞌjxi, atzin teꞌ tlon teꞌ qya, xi tqꞌmaꞌn te: Nkꞌwal, noq tuꞌn tnimbꞌila wiꞌja, ma qꞌanita jaꞌlin. Texjo paq, bꞌeꞌx weꞌ tej qya. ");
INSERT INTO mamC_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tej tokx Jesús toj tja nejinel, ok tkaꞌyin noql nchi bꞌaj chinbꞌin kyej chinbꞌil tiꞌj kyimnin, ex nchi bꞌaj oqꞌjo jniꞌ xjal tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xi tqꞌmaꞌn Jesús kye: Ku kybꞌaj exa peꞌn. Quꞌn a tal txin lo nya ma kyim, qalaꞌ noq nktan. Me noqx i bꞌaj jaw tzeꞌnxjal tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Me bꞌeꞌx i bꞌajetz tlajoꞌn xjal peꞌn. Atzaj teꞌ tokpin Jesús tuja, ex jaw ttzyuꞌn tqꞌobꞌjo tal txin, ex bꞌeꞌx jaw weꞌks. ");
INSERT INTO mamC_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tuꞌnpetziꞌn, bꞌeꞌx el tqanil toj tkyaqil txꞌotxꞌ antza, tiꞌ otaq bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tej tetz Jesús antza, ok lipe kabꞌe moẍ tiꞌj, nchi ẍchꞌin wen: Ay Tyajil qtzan nmaq kawil David, qꞌaqꞌintz tkꞌuꞌja qiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Atzin tej tokx Jesús toj jun ja, i tzaj laqꞌe moẍ tkꞌatz, ex xi tqanin kye: ¿Oktzin kxel kynimiꞌn, qa aku tzul Dios kyeꞌy wuꞌn? Ex tzaj kytzaqꞌwin: Ok, Tata, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ex ok tmikoꞌn Jesús kywutz, ex xi tqꞌmaꞌn kye: Tzeꞌnkuxsintzjo kynimbꞌila, ikyxsin kbꞌajiltzjo. ");
INSERT INTO mamC_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ex bꞌeꞌx i kaꞌyin kywutz. Me xi toqxeninxix Jesús kye kyjaluꞌn: Me mi kubꞌ kyyolin kyeꞌ kywutzxjal. ");
INSERT INTO mamC_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Me mix tpaꞌyix kykꞌuꞌj, quꞌn noq teꞌ kyetz antza, nkubꞌku kyyolin kyexjal toj tkyaqiljo txꞌotxꞌ antza, qa a Jesús otaq qꞌaninkye. ");
INSERT INTO mamC_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nchi etzkutaqjo ayej moẍqetaq, tej tul qꞌiꞌn juntl ichin, a mibꞌin yolin te Jesús, quꞌn tokxtaq jun taqꞌnil tajaw il toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ex ikyxjo, ex bꞌeꞌx etz tlajoꞌn Jesús taqꞌnil tajaw il toj tanmin, ex bꞌeꞌx bꞌantkux tej xjal tyolin. Jotxjo jniꞌ xjal bꞌeꞌx i bꞌaj jaw kaꞌylajx kywutz ikyjo, ex kyqꞌma: Bꞌajxpetzin qlaꞌyix toj tkyaqil txꞌotxꞌ te Israel jun tiꞌ tzeꞌnku lo. ");
INSERT INTO mamC_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Me ayetzin kyeꞌ Parisey, bꞌeꞌx jaw kyikyꞌin kyeꞌ, ex kyqꞌma: Axte tajaw il ma tzaj qꞌonte toklin ichin lo, tuꞌn kyetz taqꞌnil tuꞌn toj kyanminxjal, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nxnaqꞌtzintaq Jesús tiꞌj Tkawbꞌil Dios ex tiꞌj Tbꞌanil Tqanil kyojile jniꞌ muꞌẍ ja te kynabꞌl Judiy Dios. Kyojile jniꞌ tnam ex kojbꞌil nqꞌanintaq tkyaqil wiq yabꞌil kyiꞌj xjal ex tkyaqil wiq kyixkꞌoj. ");
INSERT INTO mamC_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tzaj qꞌaqꞌinx tkꞌuꞌj Jesús tiꞌj kyten xjal, quꞌn ikyqe tzeꞌn jun chꞌuq rit, mix aꞌl kyikꞌlelkye, ex ntiꞌ tumil kybꞌe, tzeꞌn tuꞌn kyxaꞌye. ");
INSERT INTO mamC_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tuꞌnpetziꞌn, tzaj tqꞌmaꞌn Jesús qeꞌy, awoꞌy t-xnaqꞌtzbꞌin: Kxel nqꞌmaꞌn qa atziꞌn kytenxjal lo twutz Dios, ikytziꞌn tzeꞌn tqan awal, ex nya ilaꞌ aqꞌnil tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tuꞌnpetziꞌn, kyqanixa te qMan Dios, a tAjaw awal, tuꞌn kytzaj tsmaꞌn aqꞌnil tiꞌj awal. ");
INSERT INTO mamC_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","O tzaj ttxkoꞌn Jesús, a awoꞌy kabꞌlajaj t-xnaqꞌtzbꞌin, ex tzaj tqꞌoꞌn qokliꞌn tuꞌn kyetz qlajoꞌn taqꞌnil tajaw il toj kyanminxjal, ex tuꞌn tkubꞌ qqꞌaniꞌn tkyaqil wiq yabꞌil ex kyixkꞌoj. ");
INSERT INTO mamC_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ex atzin qbꞌiꞌy kabꞌlajaj t-xnaqꞌtzbꞌin: Tnejil Simun, a Pegr tbꞌi; ex Andrés, a titzꞌin; Santyaw ex Juan, kyitzꞌin kyibꞌ, ayeꞌ tkꞌwal Zebedey; ");
INSERT INTO mamC_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Lip; Bartolomey; Tmas; ex ayiꞌn, Matey, a peyil pwaqtaq; Jacob, a tkꞌwal Alpey; Tadey; ");
INSERT INTO mamC_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simun, a toktaqljo qꞌolbꞌin te te Celote; ex Judas Iscariot, a ok meltzꞌaj kꞌayil te Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ex bꞌeꞌx o xi tsmaꞌn Jesús tukꞌa jun nukꞌbꞌil kyjaluꞌn: Mi cheꞌxa toj kytanim nya aj Judiyqe; ex mi chi okxa toj kytanim aj Samaria. ");
INSERT INTO mamC_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Qalaꞌ antza kꞌaꞌ cheꞌxiꞌy kyxol aj Judiy, quꞌn najnin iteꞌ tzeꞌnku rit toj kꞌul ntiꞌ kyikꞌlelkye. ");
INSERT INTO mamC_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ku kyxiꞌy yolil Tbꞌanil Tqanil Tkawbꞌil Dios at toj kyaꞌj, a ma tzaj laqꞌe jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kyqꞌaninqekujiꞌy yabꞌ; kꞌaꞌ chi jaw kyanqꞌsiꞌn kyimnin juntl majl; kyqꞌaninqekujiꞌy yabꞌqe tuꞌn nim txꞌaꞌk; ex kylajomilqexjiꞌy taqꞌnil tajaw il toj kyanminxjal. Noq ma txi oyitjo kyokliꞌn lo noq kukxjo, ex mi txi kyqanin twiꞌ kykꞌuꞌja tiꞌjjo kbꞌantil kyuꞌn tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mi txi kyiꞌn qꞌanpwaq, saqpwaq mo tzeꞌn juntl pwaq toj kybꞌeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ex mi txi kyiꞌn jun tal kychuꞌẍa; ex mi txi kyiꞌn kyxbꞌaliꞌn te txꞌixpil kyiꞌja; nixpe juntl muj kyxjabꞌa, ex nipe jun kytzeꞌy. Nya tiquꞌnil, quꞌn jun aqꞌnil il tiꞌj tuꞌn ttzaj qꞌoꞌn twa. ");
INSERT INTO mamC_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aj kykaniꞌn toj jun tnam mo jun tal kojbꞌil, kyjyoma tja jun xjal wen, tuꞌn tok qe kykꞌuꞌja tiꞌj. Ex ku kynajaꞌn tukꞌa toj tja, ajxi tpon qꞌij tuꞌn kyikyꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aj kykaniꞌn tja, chi qꞌolbꞌiꞌn tukꞌa mutxbꞌil kyeꞌ najleqe antza tukꞌa tnukꞌbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Qa ikytaqku kyaj xjaljo, bꞌaꞌntzintz; me qa mina, ex qa bꞌeꞌxtaqku xja kyikyꞌin, me atzin a kyajtaqa kyukꞌa, noq ma tzꞌel naj. ");
INSERT INTO mamC_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Exsin qa bꞌeꞌx ẍi jaw lipin kyiꞌja, ex qa mi xkubꞌ kybꞌiꞌn kyyola, ku kyetza tojjo ja mo tojjo tnam anetziꞌn. Kychtomila quq tiꞌj kyqaꞌn te jun yekꞌbꞌil kye, qa kykyꞌeꞌx tiꞌj Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Twutzxix kxel nqꞌmaꞌn kyeꞌy, qa toj tqꞌijil paꞌbꞌin twutz Dios, kujxixtljo tkawbꞌil Dios ktzajil kyibꞌaj, tzeꞌnku tzaj kyibꞌajjo xjal ojtxe kyojjo tnam Sodoma ex Gomorra, tej kybꞌaj tuꞌn qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","¡Kaꞌn! Kchi xel nsmaꞌn tzeꞌnqekuꞌ rit kyxol xoꞌj. Me chi okxixa ẍtij tzeꞌnku jun kan, ex bꞌuninxix tzeꞌnku jun tal palom. ");
INSERT INTO mamC_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bꞌaꞌnqexa, quꞌn kchi xeꞌl qꞌoꞌn kyuꞌn toj kyqꞌobꞌ kawil, ex kchi okil lipin kyiꞌja kyojjo muꞌẍ ja te kynaꞌbꞌlxjal Dios. ");
INSERT INTO mamC_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ex okpe kchi xel qꞌiꞌn kywutz nejinel ex nmaq kawil, noq tuꞌn npaja, quꞌn ikytzin k-elile kynikyꞌtzajiljiꞌy kyuꞌn nejinel ex kyuꞌn jniꞌ nya nimil, qa nimilqiꞌy wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Me ajtzin kyxi qꞌoꞌn toj kyqꞌobꞌ aj kawil, mina chi jaw bꞌisiꞌn tiꞌ kxel kyqꞌmaꞌn, ex tzeꞌn tuꞌn tbꞌant kyyoliꞌn. Quꞌn ajtzin kyok ten yolil, ax Dios ktzajil qꞌoꞌnte ttxolil kyyola. ");
INSERT INTO mamC_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Quꞌn nyaqe kyeꞌ kchi yolil, qalaꞌ ate Xewbꞌaj Xjan, a T-xew kyMaꞌn, k-yolil kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Quꞌn kyxol xjal nya nimil, ayex itzꞌinbꞌaj kchi kꞌwel bꞌyonte itzikybꞌaj, mo ayeꞌ itzikybꞌaj kyiꞌj itzꞌinbꞌaj. Ayex chi xel qꞌonte kykꞌwal toj kyimin, ex ikyqex kꞌwalbꞌajjo ayex chi okil meltzꞌaj kyiꞌj kytata, ex chi xel kyqꞌoꞌn tuꞌn kykyim. ");
INSERT INTO mamC_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ex chi elil iꞌjliꞌn kyuꞌnxjal, noq tuꞌn tpajjo nimilqiꞌy wiꞌja. Me ankye teꞌ kweꞌbꞌil twutz tkyaqiljo lo, ajxi tjapin bꞌaj tkyaqil, okpin kletil teꞌ te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Me ajtzin kyok weꞌxjal lajol kyeꞌy toj jun tnam, liweyx cheꞌxa toj juntl. Quꞌn twutzxix kxel nqꞌmaꞌn kyeꞌy, naꞌmtaqx kyelpin bꞌaj kykyaqil tnam toj Israel tuꞌn kybꞌetintiꞌy, aj wula juntl majl, ayiꞌn Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Quꞌn a nxnaqꞌtzin tibꞌ nlay jawjo toklin tibꞌajjo nxnaqꞌtzinte. Ex nlay jaw toklin aqꞌnil tibꞌaj tajaw aqꞌuntl. ");
INSERT INTO mamC_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Quꞌn qa ma tzikyꞌx te xnaqꞌtzil tuꞌn ¿Tzeꞌntzin tteꞌntz tuꞌn mi tzikyꞌxa kyuꞌn nchi xnaqꞌtzin kyibꞌ? Ex ikyxjo te aqꞌnil tukꞌa tajaw aqꞌuntl. Xi nqꞌmaꞌn ikyjo, quꞌn ikyqintzin wejiꞌy tzeꞌnku jun manbꞌaj toj ja. Quꞌn mape tzꞌok kyqꞌmaꞌn kyexjal weꞌy qa tajaw ilqiꞌn, a Beelzebú; ¿Yajtzilaꞌ kyetza? ");
INSERT INTO mamC_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tuꞌnpetziꞌn, mi chi tzaj xobꞌ kyeꞌ. Quꞌn ntiꞌ jun tiꞌ aku tzꞌewit te jun majx, a mit tzꞌel tnikyꞌtzajil. Ex ntiꞌ jun tiꞌ ewin, a mit tzꞌel tqanil. ");
INSERT INTO mamC_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Atziꞌn kxel nqꞌmaꞌn kyeꞌy, kyqꞌmanxa kye kykyaqil. Ex ankyeꞌ noq kxel njaskꞌiꞌn kyeꞌy jaꞌlin, kyẍchꞌinxa tzmax toj twiꞌ ja, tuꞌntzin tbꞌijte kyuꞌn kykyaqilxjal. ");
INSERT INTO mamC_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ex mi chi xobꞌa kye aku kubꞌ bꞌyonte kyxmilila, quꞌn me kye kyanmin nlay kyim kyuꞌn. Qalaꞌ kxel nqꞌmaꞌn kyeꞌy, antza chi xobꞌa kyeꞌ te Dios, quꞌn nya noq kyxmilila aku kyim tuꞌn, qalaꞌ ikytzin majx kyanmiꞌn. Ex nya noq oꞌkxjo, qalaꞌ ikytzin ajxi kykyim tuꞌn, aku cheꞌx tqꞌoꞌn toj qꞌaqꞌ te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Jteꞌtzila kywiꞌ kabꞌe tal pichꞌ? ¿Nyapela noq jun tal muꞌẍ pwaq? Me kxel nqꞌmaꞌn kyeꞌy, nixpela jun tal pichꞌ aku kyim, qa nya taj qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","¿Yajtzilaꞌ kyeꞌ? Quꞌn nimxixtl kyokliꞌn tzeꞌnqekuꞌ pichꞌ; ex noq tuꞌn tqꞌaqꞌbꞌil tkꞌuꞌj Dios majqexpe tsmal kywiꞌy chebꞌe ajlanqe tuꞌn. Tuꞌnpetziꞌn, mi chi xobꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ankye teꞌ mi kubꞌ tewin kywutzxjal, qa nimil wiꞌja, ex ikyx wejiꞌy mi kubꞌ wewiꞌn twutz nMaꞌn, a at toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Me anteꞌ kꞌwel ewinte kywutzxjal qa ojtzqiꞌnqiꞌn tuꞌn, ex ikyx wejiꞌy, kꞌwel wewiꞌn twutz nMaꞌn, a at toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","¿Tzeꞌntzintz toj kywutza? ¿Ma man chin kꞌuꞌl wetza noq tuꞌn kytzalajxjal tzaluꞌn twutz txꞌotxꞌ? ¡Me twutzxix kxel nqꞌmaꞌn kyeꞌy, aj qa mina! Qalaꞌ ma chin kꞌuꞌl weꞌ noq tuꞌn nqꞌoꞌn qꞌoj kyxolxjal. ");
INSERT INTO mamC_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Quꞌn ma chin ula qꞌol paꞌbꞌl kyxolxjal tzeꞌnku tzꞌibꞌin toj Tuꞌjil Tyol Dios: Jun kꞌwalbꞌaj ichin kjyol qꞌoj tiꞌjx tman, ex jun kꞌwalbꞌaj qya kjyol qꞌoj tiꞌjx ttxu. Ex ilibꞌj tiꞌj ilibꞌilte. ");
INSERT INTO mamC_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ikytziꞌn, teyile junjun at qꞌoj kyiꞌj tojx tja. ");
INSERT INTO mamC_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Quꞌn ankye teꞌ k-okil tkꞌuꞌjlin ttata ex tnana nimxixtl tzeꞌnku weꞌ, ntiꞌ toklin tuꞌn tok te weꞌy. Ex ankye teꞌ k-okil tkꞌuꞌjlin tkꞌwal qꞌa mo qa txin nimxixtl tzeꞌnku weꞌ, ntiꞌ toklin tuꞌn tok te weꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ex alkye tkyꞌeꞌ tuꞌn t-xi lipe wiꞌja toj tkyaqil, exla qa tuꞌn tkyim tzeꞌnqekuꞌ xjal xi kyiqin kycruz te kyimin, ntiꞌ toklin tuꞌn tok te weꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ankye teꞌ k-okil tkꞌuꞌjlin tchwinqil tzaluꞌn twutz txꞌotxꞌ, ok knajil teꞌ te jun majx. Me ankye teꞌ k-elil tiꞌjlin tkyaqiljo achbꞌil te twutz txꞌotxꞌ noq tuꞌn npaja, okpin knetil teꞌ tchwinqil tuꞌn te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ex ankyeꞌ ok kꞌwel xkꞌamin kyeꞌy, ayiꞌn chin kꞌwel t-xkꞌaꞌmin. Ex ankyejo ma kꞌmon weꞌy, a Dios ma kꞌmet tuꞌn, a saj smaꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ex ankye teꞌ kꞌwel t-xkꞌaꞌmin jun yolil Tyol Dios, quꞌn ax Dios saj smaꞌnte, ok ktzajil ttzyuꞌn jun oyaj toj kyaꞌj, tzeꞌnku jun oyaj ntzaj qꞌoꞌn te jun yolil Tyol Dios. Ex ankyeꞌ kꞌwel t-xkꞌaꞌmin jun ichin wen, ok ktzajil ttzyuꞌn jun oyaj toj kyaꞌj, a ikyxjo tzeꞌnku oyaj ktzajil qꞌoꞌn te ichin wen. ");
INSERT INTO mamC_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ex ankye teꞌ kxel qꞌonte jun tal vas cheꞌwe te jun tal kꞌwal, noq tuꞌn ma tzꞌok lipe wiꞌja, ex twutzxix kxel nqꞌmaꞌn kyeꞌy, at jun oyaj tiꞌjjo lo te jun majx toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tej tbꞌaj tnikꞌuꞌn Jesús qeꞌy, awoꞌy kabꞌlajaj t-xnaqꞌtzbꞌin, bꞌeꞌx xiꞌ kyojjo tnam toj txꞌotxꞌ te Galiley xnaqꞌtzil ex yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tkuꞌxtaq Juan, a Jawsil Aꞌ, toj tze, me tej tbꞌin teꞌ jniꞌtaqjo nbꞌant tuꞌn Crist, bꞌeꞌx i xi tchqꞌoꞌn kabꞌe t-xnaqꞌtzbꞌin lolte. ");
INSERT INTO mamC_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tej kykanin tukꞌa, xi kyqanin te: ¿Atzinjiy a Crist, a attaq tulil, mo qa at juntl, tuꞌn tkubꞌ qyoꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Xi ttzaqꞌwin Jesús: Kux cheꞌxa, ex kyqꞌmanxa te Juan ajo ma kyliꞌy, exsiꞌn ma kybꞌiꞌy, ikyxjo tzeꞌnku kyij tzꞌibꞌit wiꞌja toj Tuꞌjil Tyol Dios. Chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aye moẍtaq ma chi kꞌant kywutz, aye koxtaq ma chi bꞌet, exqetziꞌn yabꞌqetaq tuꞌn nim txꞌaꞌk, ma chi qꞌanit; exqetziꞌn ẍoꞌrqetaq, ma chi bꞌin; exqetziꞌn otaq chi kyim, ma chi jaw anqꞌin juntl majl. Ex jniꞌ kye yaj ma pon Tbꞌanil Tqanil kolbꞌil kye. ");
INSERT INTO mamC_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kyꞌiwlinqexixjo a mi njawje kykꞌuꞌj wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tej kymeltzꞌajjo t-xnaqꞌtzbꞌin Juan, bꞌeꞌx ok ten Jesús yolil tiꞌj Juan kyukꞌaxjal. Xi tqꞌmaꞌn kye kyjaluꞌn: Tej kyxiꞌy lolte Juan toj tzqij txꞌotxꞌ, ¿Tiꞌtaqtzin wiq ichin kyajtaqa tuꞌn kylontiꞌy? ¿Ma noqpe jun ichin kabꞌe tkꞌuꞌj, tzeꞌnku jun ajlaj meltzꞌaje tuꞌn kyqꞌiqꞌ? ");
INSERT INTO mamC_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Qa mina, ¿Tiꞌtaqtzin kyajtza tuꞌn kylontiꞌy? ¿Moj qa jun ichin manyor tbꞌanilx t-xbꞌalin tok? ¿Ma mitzin bꞌiꞌn kyuꞌn qa aye xjal, tbꞌanilx kyxbꞌalin tok, antza iteꞌye kyeꞌ toj kyja nmaq kawil? ");
INSERT INTO mamC_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Tzeꞌntzintz tiꞌtzin chi txaꞌjtza lolte? ¿Bꞌalaqa jun yolil Tyol Dios? ¡Ikytziꞌn! Me ante Juan nimxixtl toklin kyibꞌajjo yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Quꞌn ikytzin tqꞌmaꞌn Dios tiꞌj toj Tuꞌjil Tyol kyjaluꞌn: Kxel nchqꞌoꞌn weꞌ nsan twutza qꞌmalte tqanil tulila, tuꞌn tkubꞌ kybꞌinchinxjal kyibꞌ twutza. ");
INSERT INTO mamC_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Twutzxix kxel nqꞌmaꞌn, qa kyxol kykyaqilxjal twutz txꞌotxꞌ, mix aꞌl jun nimxixtl toklin tzeꞌnku te Juan, a Jawsil Aꞌ. Me ankye teꞌ, a noq tal chꞌin toklin toj Tkawbꞌil Dios toj kyaꞌj, nimxixtl toklin tzeꞌnku te Juan. ");
INSERT INTO mamC_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Quꞌn tukꞌaxiꞌ tulil Juan, a Jawsil Aꞌ, ex tzmax tzaluꞌn, nimxjal tok tilil kyuꞌn, tuꞌn tchꞌiy Tkawbꞌil Dios, a tzajnin toj kyaꞌj. Ex nimxjal tok tilil kyuꞌn, tuꞌn tkubꞌ bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tkyaqiljo jniꞌ t-xilin kyxnaqꞌtzbꞌil yolil Tyol Dios ojtxe exsin ojtxe kawbꞌil, noq jun tqanil tiꞌjjo Tkawbꞌil Dios, a tuꞌntaq tul, tzeꞌnku ma tzul Juan chikyꞌbꞌilte. ");
INSERT INTO mamC_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Qa kyaja tuꞌn t-xi kynimiꞌn, kxel nqꞌmaꞌn kyeꞌy qa a Juan, a Elías, a iltaq tiꞌj tuꞌn tul, tzeꞌnku qꞌumj toj Tuꞌjil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Qa at kywiꞌy te bꞌilte, kybꞌinkujiꞌy tkyaqiljo nxi nqꞌmaꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kꞌwel nqꞌoꞌn jun techil tzeꞌnqe xjal jaꞌlin: Ikyqetziꞌn tzeꞌnqekuꞌ tal kꞌwal nchi kubꞌ qe saqchal toj kꞌaybꞌil. Ex nxi kyẍchꞌin te kyukꞌa, tuꞌn kysaqchaꞌn junx, ex nxi kyqꞌmaꞌn: ");
INSERT INTO mamC_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ma qo chinbꞌiꞌn kyukꞌa xux, tuꞌntzintla qsaqchan, ex tuꞌn kytzalaja, ex tuꞌn kybꞌixiꞌn, me mi ẍi bꞌixiꞌn. Tuꞌnpetziꞌn, ma txi qbꞌitziꞌn bꞌitz te bꞌisbꞌajil, tuꞌntzintla qsaqchan, ex tuꞌn kyoqꞌa, me mix aꞌl s-oqꞌ. ¿Tiꞌxsin kyajtza? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ikytzin kyejiꞌy, chi Jesús. Quꞌn tej tul Juan, a mix waꞌn ex mix kꞌwane kyukꞌa txqantl, tuꞌn ikyjo kyqꞌmaꞌy tiꞌj, qa attaq taqꞌnil tajaw il toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ex ma chin ula, ayiꞌn Tkꞌwal Ichin jaꞌlin, a nchin waꞌn ex nchin kꞌwan kyukꞌa noq tiꞌchaqku xjal, me nkyqꞌmaꞌnla wiꞌja qa loꞌlqin weꞌ, ex jun kyukꞌa peyil pwaq ex kyukꞌa aj il. Ex ayetzin kyeꞌ, ¿Tiꞌxsila kyajtza? Kxel nqꞌmaꞌn qa atzin k-elile kynikyꞌa tiꞌjjo nabꞌl ntzaj tuꞌn Dios tiꞌjjo qbꞌinchbꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tbꞌajlinxiꞌ ikyjo, ok ten Jesús kawil kyeꞌ xjal kyojjo tnam, a jaꞌ otaq kubꞌ tbꞌinchin nimku yekꞌbꞌil tipin, quꞌn aye xjal antza kykyꞌeꞌxtaq tuꞌn tajtz tiꞌj kyanmin, ex tuꞌn ttxꞌixpit kychwinqil. Xi tqꞌmaꞌn kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","¡Ay! Nimx bꞌisbꞌajil kyeꞌy, a ayiꞌy aj tnam Corazín exsin aj Betsaida. Noqit kyojjo tnam Tiro ex Sidón ma chi bꞌant teꞌ yekꞌbꞌil wipiꞌn, a ma chi bꞌant kyxola, ojtxetla tzꞌajtz tiꞌj kyanminxjal, ex matla kubꞌ kyyekꞌin jun txꞌixpibꞌl toj kychwinqil, noq tuꞌn tok kyqꞌoꞌn kyxbꞌalin te bꞌisbꞌajil, noq tuꞌn tpaj kyil, ex tuꞌn tjaw kychtoꞌn tzaꞌj toj kywiꞌ, te jun yekꞌbꞌil qa ma tzꞌajtz tiꞌj kyanmin. ");
INSERT INTO mamC_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Twutzxix kxel nqꞌmaꞌn kyeꞌy, toj tqꞌijil paꞌbꞌin twutz Dios, kujxixtl kye tkawbꞌil Dios tzul kyibꞌaj, tzeꞌnkuj kye aj Tiro ex Sidón. ");
INSERT INTO mamC_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ikyxjo kyeꞌ aj tnam Capernaum; ¿Chila, qa chi japin kyeꞌ toj kyaꞌj? ¡Me mina! Quꞌn ayexixpe kyeꞌ kchi xeꞌl tojjo ma tij jul, a jaꞌla taꞌye t-xele. Quꞌn noqit tojjo tnam Sodoma ma bꞌant teꞌ jniꞌ yekꞌbꞌil wipiꞌn, a ma bꞌant kyxola, mipetla xyuchꞌj te tnam anetziꞌn; atxpetla teꞌ jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ex kxel nqꞌmaꞌn kyeꞌy, qa toj tqꞌijil paꞌbꞌin twutz Dios, kujxixtl kyeꞌ tkawbꞌil Dios tzul kyibꞌaj, tzeꞌnkuj kye xjal tojjo txꞌotxꞌ te Sodoma. ");
INSERT INTO mamC_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kyojjo qꞌij anetziꞌn, xi tqꞌmaꞌn Jesús kyjaluꞌn: Taa, Ay tAjaw kyaꞌj ex Ay tAjaw txꞌotxꞌ; loqiꞌn nchin nimsin Tbꞌiy jaꞌlin, quꞌn tuꞌn ma kubꞌ tewin tejiy t-xilin tumil kolbꞌil kyeꞌ xjal, a ẍtijqe ex nim kynabꞌl toj kywutz, exsin ma kubꞌ tchikyꞌbꞌintza kywutzjo xjal, a qꞌoꞌnk kyoklin te ntiꞌ bꞌaꞌn kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ikytziꞌn Tata, quꞌn ikytzin tejiy taj. ");
INSERT INTO mamC_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Quꞌn ma tzaj tqꞌoꞌn nMaꞌn tkyaqil weꞌy. Ex mix aꞌl jun ojtzqil weꞌy, qalaꞌ oꞌkx nMaꞌn, quꞌn ayiꞌn Tkꞌwal. Ex mix aꞌl jun ojtzqil te nMaꞌn, qalaꞌ oꞌkqinxa. Ex alqe wajiꞌy tuꞌn t-xi nyekꞌiꞌn nMaꞌn, kxel nyekꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tuꞌnpetziꞌn, ku kytzaja wukꞌiy, ayiꞌy sikytlin iteꞌy, ex ayiꞌy ma chi yajxa tojjo kychwinqila. Ex kxel nqꞌoꞌn ajlabꞌl kyeꞌy te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kykꞌmonxjiꞌy nnukꞌbꞌila kxel nqꞌoꞌn kyeꞌy; ex kykaꞌyimila wiꞌja, quꞌn manyor wenqinxa ex manyor cheꞌwxjo wanmiꞌn. Ex ktenbꞌil ajlabꞌl toj kychwinqila te jun majx wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Quꞌn ajo nnukꞌbꞌila kxel nqꞌoꞌn kyeꞌy nya kujxix tuꞌn tbꞌant kyuꞌn, ex ajo iqtz kxel nqꞌoꞌn tuꞌn tjapin bꞌaj kyuꞌn, nyaxix al. ");
INSERT INTO mamC_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kyojjo qꞌij anetziꞌn, toj jun qꞌij te ajlabꞌl, nqo bꞌettaqa tukꞌa Jesús toj jun bꞌe n-extaq toj triy. Tzaj qꞌaqꞌin qkꞌuꞌja, o ok teꞌn xbꞌoqil triy, exsin el qxqꞌuchin te qwaꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Atzaj teꞌ tok kykaꞌyin Parisey ikyjo, xi kyqꞌmaꞌn te Jesús: Kaꞌyinqektzinjiy t-xnaqꞌtzbꞌiꞌn, a nchi bꞌinchin jun tiꞌ, a nya wen tuꞌn tkubꞌ bꞌinchit toj qꞌij te ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Me xi ttzaqꞌwin Jesús: ¿Ma naꞌmtzin tkux kyuꞌjin kyejiꞌy bꞌant jun maj tuꞌn qtzan David, a nimx toklin, tej ttzaj waꞌyaj tiꞌj kyukꞌa tukꞌa? ");
INSERT INTO mamC_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bꞌeꞌx i okx toj ojtxe tja Dios, exsin i etz tiꞌn wabꞌj, a otaq chi kubꞌ kyꞌiwlit te oyaj twutz Dios. Ex i xi twaꞌn, exsin xi tqꞌoꞌntz kye tukꞌa, a ntiꞌtaq kyoklin tiꞌj tuꞌn t-xi kywaꞌn, qalaꞌ oꞌkqextaq pale. ");
INSERT INTO mamC_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mo ¿Ma naꞌmtzin tkux kyuꞌjiꞌn toj ojtxe tkawbꞌil Moisés, qa aye pale toj tnejil ja te kꞌulbꞌil, mi nchi ajlantaq toj qꞌij te ajlabꞌl, qalaꞌ nchi aqꞌnintaq? ¿Ma i bꞌinchintzintz il tuꞌn ikyjo? ");
INSERT INTO mamC_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy, qa atx juntl tumil nimxixtl toklin tzeꞌnku tumil tiꞌjjo tnejil ja te kꞌulbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Noq naꞌm tel kynikyꞌa te, a tiꞌ ntqꞌmaꞌn Tuꞌjil Tyol Dios: Atzin wajiꞌy, tuꞌn tten kyqꞌaqꞌbꞌil kykꞌuꞌja kyxolxa, ex nya noq tuꞌn kyok teꞌn patil kychibꞌjil aluꞌmj te chojbꞌil kyila. Quꞌn noqit ma tzꞌel kynikyꞌa te, mitla nchi bꞌaj yolbꞌiꞌn kyiꞌj nxnaqꞌtzbꞌiꞌn, ayeꞌ mi nchi bꞌinchin il. ");
INSERT INTO mamC_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tzeꞌnku nteꞌn, ayiꞌn Tkꞌwal Ichin, chqꞌonqintza tuꞌn Dios kyxola; ex ayiꞌn at wokliꞌn tibꞌajjo qꞌij te ajlabꞌl, ex ayiꞌn kchin qꞌmalte qa wen tuꞌn tkubꞌ bꞌinchit jun tiꞌ mo qa minaj. ");
INSERT INTO mamC_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bꞌeꞌx ikyꞌ Jesús antza, ex okx toj jun muꞌẍ ja te naꞌbꞌl Dios, ");
INSERT INTO mamC_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","jaꞌ attaq jun ichin ntiꞌtaq tanmin jun tqꞌobꞌ. Me tzunxtaq njoyle tumil kyuꞌn junjun tzeꞌn tten tuꞌn tjaw stzꞌimin jun tiꞌ tiꞌj Jesús, ex tuꞌn tkubꞌ tzꞌaq toj jun il kyuꞌn. Xi kyqanin te Jesús: ¿Tziyintzin toj ojtxe kawbꞌil, tuꞌn tqꞌanit jun xjal tojjo qꞌij te ajlabꞌl? ");
INSERT INTO mamC_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Xi ttzaqꞌwin Jesús: Ankye jun kyeꞌ, qa akux xi tzꞌaq jun trit toj jun jul toj jun qꞌij te ajlabꞌl, ¿Ma nlaypela aku jatz kyiꞌn? ¿Ma atpela kyila tiꞌjjo ikyjo? ");
INSERT INTO mamC_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Ma nyatzin nimxixtl toklin jun ichin twutz jun rit? Tuꞌnpetziꞌn, bꞌaꞌn tuꞌn tkubꞌ qbꞌinchin qejiꞌy a bꞌaꞌn toj tqꞌijil ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ex xi tqꞌmaꞌn Jesús te yabꞌ: Nuqpinx tqꞌobꞌa. Bꞌeꞌx nuqpajkux tqꞌobꞌjo tal yabꞌ, ex bꞌeꞌx bꞌant tzeꞌnkuxjo juntl. ");
INSERT INTO mamC_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Me ayetzin kyeꞌ Parisey, bꞌeꞌx i ok ten jyol tumil tzeꞌn tuꞌn tkubꞌe kybꞌyoꞌne Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tej tbꞌinte Jesús ikyjo, bꞌeꞌx ikyꞌ antza, ex i xi lipe txqan xjal tiꞌj. Ex nqꞌaninxi kyiꞌj yabꞌ toj bꞌe. ");
INSERT INTO mamC_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ex xi tqꞌmaꞌnxix Jesús, tuꞌn mi chi yoline tiꞌj kywutzxjal. ");
INSERT INTO mamC_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nyatzin tiqeꞌ ikyjo noq tuꞌn tjapinkuꞌ Tyol Dios, a kyij ttzꞌibꞌin yolil Tyol Dios ojtxe, a Isaías, tej tqꞌma: ");
INSERT INTO mamC_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Atzin wejiꞌy waqꞌnil, a skꞌoꞌnxix, ex kꞌuꞌjlinxix wuꞌn, ex nchin tzalaja tiꞌj. Kꞌwel nqꞌoꞌn nXewa toj tanmin. Ex ok k-yolil tiꞌj Nkawbꞌila toj tkyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mi qꞌojle, ex mi jaw ẍchꞌin, tuꞌntzintla mix aꞌl kxel bꞌinte tqꞌajqꞌojil twiꞌ kyoj tbꞌeyil tnam. ");
INSERT INTO mamC_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ex mi chi el tikyꞌin ayejo numjninqe. Tuꞌnpetziꞌn, mi kubꞌ twaqꞌin jun tal tqan ptzꞌan tal kox, ex mi kubꞌ tyupin jun tal ttzaj yaj, a noqx tal chꞌin nsbꞌen, tzmaxiꞌ aj t-xi tqꞌoꞌn kyoklin, aj tkubꞌ tqꞌoꞌn Tkawbꞌil, a tzꞌaqlexix. ");
INSERT INTO mamC_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ex tojjo qꞌij anetziꞌn, tkyaqil xjal twutz txꞌotxꞌ kqebꞌil kykꞌuꞌj tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kyojjo qꞌij anetziꞌn, xi kyiꞌnxjal jun ichin twutz Jesús, a tokxtaq jun taqꞌnil tajaw il toj tanmin; ex otaq chi jpet twutz, ex mibꞌintaq yolin. Me bꞌeꞌx el weꞌ tuꞌn Jesús, quꞌn bꞌeꞌx bꞌant tkaꞌyin, ex bꞌant tyolin. ");
INSERT INTO mamC_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kykyaqilxjal bꞌaj jaw kaꞌylaj, ex i jaw yolin kyxolx: ¿Apela tyajil Davidjo lo, a skꞌoꞌnxix tuꞌn Dios te Kolil? ");
INSERT INTO mamC_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Me tej kybꞌinte Pariseyjo ikyjo, ex kyqꞌma: Mina, chi chiꞌ. Nchi etz teꞌ xjal taqꞌnil tajaw il tuꞌn, quꞌn tuꞌn a te Beelzebú, a tajaw il, o txi qꞌonte tipin. ");
INSERT INTO mamC_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Me bꞌeꞌx el tnikyꞌ Jesús te kyyol, ex xi tqꞌmaꞌn kye: Qa paꞌn kyten xjal toj jun nim tnam, ex qa kyajqꞌoj kyibꞌ, noqx aku chi kubꞌ naj tuꞌn qꞌoj. Ex ikyxjo toj jun muꞌẍ tnam, mo toj jun ja xjal. Qa kyajqꞌoj kyibꞌ, nlay chi el wen. ");
INSERT INTO mamC_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ikytzin taꞌye te satanásjo, a tajaw il. Qa ax s-etz lajonte tibꞌ toj kyanminxjal, ax n-ok meltzꞌaj tiꞌjx ikyjo, ex atzin tkawbꞌil nlay chꞌiy. ¿Ma man kubꞌ numjjo tipintz? ");
INSERT INTO mamC_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ex noqit ikyjo tzeꞌnku nkyqꞌmaꞌn, qa tuꞌn tipin Beelzebú nchi etze taqꞌnil tajaw il toj kyanminxjal wuꞌn, ¿Altzila kye ntzaj qꞌoꞌnte kyipin aye lipcheqek kyiꞌja, tuꞌn tetz taqꞌnil tajaw il toj kyanminxjal kyuꞌn, qa nya ax Dios? Tuꞌnpetziꞌn, ayexjo kyukꞌiy kchi qꞌmalte qa nya toj tumil kyyola tiꞌjjo lo. ");
INSERT INTO mamC_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Me metzin weꞌ noq tuꞌn tipin Xewbꞌaj Xjan, a T-xew Dios, nchi etze taqꞌnil tajaw il wuꞌn toj kyanminxjal; atzin jun yekꞌbꞌiljo qa ma tzul Tkawbꞌil Dios kyxola. ");
INSERT INTO mamC_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ex at juntl tumil: Qa at jun ileqꞌ taj tuꞌn telqꞌin toj tja jun xjal nim tipin, ¿Ma akutzin bꞌant telqꞌin, qa nya nej, xkubꞌ tkꞌloꞌn tajaw ja? Ikytzin te tajaw iljo tzeꞌnku tajaw ja, quꞌn a nim tipin. Me ma chin kanbꞌin tiꞌj, quꞌn ma chi etz nlajoꞌn taqꞌnil toj kyanminxjal. ");
INSERT INTO mamC_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ankyeꞌ nya wukꞌiy taꞌ, noq njaw, tuꞌn tqꞌoj wiꞌja. Ex ankyeꞌ tkyꞌeꞌ mojin wukꞌiy tuꞌn tjaw chmet twutz awal, kyja n-ok tene chtolte. ");
INSERT INTO mamC_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy: Kykyaqiljo wiq il, ex jniꞌ noq tiꞌchaqku tiꞌ nkyqꞌmaꞌnxjal aku najsit. Me qa ma tzꞌok kyyisoꞌn Xewbꞌaj Xjan, nlaypen kubꞌ najsit te il anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ikytziꞌn, qa at jun xyolbꞌin wiꞌja, a ayiꞌn Tkꞌwal Ichin, aku najsit teꞌ til. Me qa at jun xyolbꞌin tiꞌj Xewbꞌaj Xjan, nlayxpen najsit teꞌ til tzaluꞌn twutz txꞌotxꞌ ex toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ikyqetzin kyejiꞌy tzeꞌnku jun tze. Qa ma tzꞌok kaꞌyit wen, tbꞌanil k-elile twutz wen. Ex qa mina, nya tbꞌanil twutz k-elil. Tuꞌnpetziꞌn, k-elile tnikyꞌtzajil tiꞌjjo tze, noq tuꞌnjo twutz. ");
INSERT INTO mamC_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ayetzin kyeꞌ manyor tyajil kanqiꞌy; ntiꞌx kyajbꞌiꞌn. ¿Ma akutzin bꞌant kyyoliꞌn jun yol toj tumil, a ayekuy nya wenqe? Quꞌn atziꞌn nya bꞌaꞌn at toj kyanmiꞌn, atzin nkyqꞌmanjiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Me anteꞌ xjal, a tbꞌanil tanmin, tbꞌanilxjo ntqꞌmaꞌn, quꞌn toj tanmin njatze tkyaqiljo wen. Ex anteꞌ xjal, a nya wen tanmin, tkyaqiljo ntqꞌmaꞌn nya wen. ");
INSERT INTO mamC_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy; qa toj tqꞌijil paꞌbꞌin twutz Dios, teyile junjun k-okil toj xjelbꞌil tiꞌj tkyaqiljo yol nkyqꞌmaꞌn jaꞌlin, a nya wen. ");
INSERT INTO mamC_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Quꞌn noq tiꞌjjo bꞌaꞌn kyyola, kchi tzaqpajiliꞌy tjaqꞌ tkawbꞌil Dios kujxix wen; me qatzin qa mina, ok kychjaꞌbꞌilxa tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tbꞌajlinxiꞌ ikyjo, xi kyqanin junjun Parisey, exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil te Jesús: Xnaqꞌtzil, qaja tuꞌn qlontiꞌy jun techil tipiꞌn, a tbꞌanilxix. ");
INSERT INTO mamC_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","I xi ttzaqꞌwin Jesús: Ayetziꞌn xjal nya wenqe ex aj il nchi qanin jun techil wipiꞌn. Me nlay txi yekꞌiꞌt kye; qalaꞌ oꞌkxjo techil tiꞌjjo bꞌaj tiꞌj Jonás, a yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Quꞌn luꞌtziꞌn te Jonás ten oxe qꞌij ex oxe qnikyꞌin toj tkꞌuꞌj jun tij kyiẍ; ex ikyx wejiꞌy, ayiꞌn Tkꞌwal Ichin, chin kꞌwelix muquꞌn toj txꞌotxꞌ oxe qꞌij ex oxe qnikyꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ex ikyqex kyeꞌ xjal toj tnam Nínive kyojjo qꞌij te Jonás kchi jawil weꞌks toj tqꞌijil paꞌbꞌin, aj kyokxjal toj xjelbꞌil twutz Dios, ayeꞌ iteꞌ kyojjo qꞌij jaꞌlin, tuꞌn kykubꞌ tzꞌaq toj kyil kyuꞌn. Quꞌn ayetziꞌn xjal toj Nínive bꞌeꞌx ajtz tiꞌj kyanmin, tej t-xi tqꞌmaꞌn Jonás Tbꞌanil Tqanil Dios kye. Ex ajo Tbꞌanil Tqanil wiꞌja jaꞌlin nimxixtl toklin tzeꞌnku toj tqꞌijil Jonás. ");
INSERT INTO mamC_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ok kjawil weꞌks ajo qya, a nmaq kawil tzajnin te najchaq te twutz txꞌotxꞌ, tuꞌn kykubꞌ tzꞌaqxjal toj kyil tuꞌn, ayeꞌ iteꞌ kyojjo qꞌij jaꞌlin. Quꞌn ajo qya anetziꞌn bꞌeꞌx xiꞌ bꞌilte tnabꞌlxix qtzan Salomón. Me ajo t-xilin naꞌbꞌl wiꞌja jaꞌlin, nimxixtl toklin tzeꞌnku te Salomón. ");
INSERT INTO mamC_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aj tetz jun taqꞌnil tajaw il toj tanmin jun xjal, a nya nimil, bꞌeꞌx nxiku jyolte tojjo tzqij txꞌotxꞌ, jaꞌ tuꞌn ttene. Exsin qa mix xjyet tuꞌn, kꞌwel t-ximin: ");
INSERT INTO mamC_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kchin meltzꞌajil weꞌ juntl majl tojjo njaꞌy, jaꞌ ẍin etziꞌych. Ex ajtzin tkanin juntl majl tkꞌatzjo xjal, knetiljo xjal tuꞌn, tzeꞌnku jun ja, mix aꞌl najalte, ex chebꞌe misoꞌn ex nikꞌuꞌn wen. ");
INSERT INTO mamC_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Bꞌeꞌxsin k-okixtz toj tanmin xjal me nya tjunalx jaꞌlin; qalaꞌ kyukꞌa wuql tukꞌa xininqexix toj il tzeꞌnku a. Ex kykyaqilx kchi najal toj tanminjo xjal jaꞌlin. Atzaj xjal noqx kyja kxeꞌlix toj il tzeꞌnkuꞌ ttentaq te tnejil. Ikytzin kbꞌajiljo kyukꞌa xjal jaꞌlin, a nya nimilqe. ");
INSERT INTO mamC_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tzmataq nyolin Jesús kyukꞌaxjal, tej kykanin tnana kyukꞌax titzꞌin. I kubꞌ weꞌ twiꞌ peꞌn, me kyajtaq tuꞌn kyyolin tukꞌa Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bꞌeꞌx xi qꞌmaꞌn te Jesús: Lu tnaniy exqetziꞌn titzꞌiꞌn iteꞌ peꞌn, ex kyaj tuꞌn kyyolin tukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Me ante Jesús xi tqꞌmaꞌn te a xi qꞌmante ikyjo: ¿Ankyeqe weꞌ nnana, ex ankyeqe weꞌ witzꞌin? ");
INSERT INTO mamC_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","I tzaj tyekꞌin tukꞌa tqꞌobꞌ qibꞌaja, a awoꞌy t-xnaqꞌtzbꞌin, ex xi tqꞌmaꞌn: Ayetzin wejiꞌy nnana ex witzꞌin lo. ");
INSERT INTO mamC_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ayeꞌ chi kꞌwel bꞌinchin teꞌ taj nMaꞌn, a at toj kyaꞌj, ayetzin wejiꞌy witzꞌin, ex wanebꞌ ex nnaniy. ");
INSERT INTO mamC_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ax qꞌijjo tetz Jesús tojjo ja, ex kubꞌ qe ttzi nijabꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tej tok tkaꞌyin kypon txqan xjal tkꞌatz, bꞌeꞌx okx toj jun tal bark, ex kubꞌ qe toj. Ayetzin kyeꞌ jniꞌ xjal i bꞌaj kyij ten ttzi aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ok ten xnaqꞌtzil nimku tumil noq kyukꞌa techil, ex tqꞌma: Jun maj, xiꞌ jun xjal awal triy. ");
INSERT INTO mamC_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Atzin teꞌ tok tchtoꞌn, at pon chitj toj bꞌe. I tzaj pichꞌ, ex bꞌeꞌx jaw kyskꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ex at pon chitj kyxol abꞌj, me quꞌn tuꞌn ntiꞌxix twutz txꞌotxꞌ antza, liwey ul twiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Me atzaj teꞌ tok qꞌijil, bꞌeꞌx jaw tzqij, quꞌn nya nim xaꞌye tlokꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ex at pon chitj kyxol txꞌiꞌx. Me atzin txꞌiꞌx jun paqx tchꞌiy; atzin te triy noq jaw xkyꞌiꞌsix. ");
INSERT INTO mamC_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Me anteꞌ pon chitj toj tbꞌanil txꞌotxꞌ, tbꞌanilx ele toj. At junjun tqan el jweꞌ kꞌal twutz, ex junjuntl el ox kꞌal, ex junjuntl el lajaj toj kaꞌwnaq. ");
INSERT INTO mamC_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ankye taj tuꞌn tkubꞌ tbꞌiꞌn nyola, in tkubꞌ tbꞌiꞌntz, tuꞌntzintla tkubꞌ tbꞌinchin. ");
INSERT INTO mamC_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","O ul laqꞌeꞌy awoꞌy, a t-xnaqꞌtzbꞌin, tkꞌatz, ex xi qqaniꞌn te: ¿Tiquꞌn nyoliꞌn kyukꞌaxjal noq kyukꞌa techil? ");
INSERT INTO mamC_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tzaj ttzaqꞌwin Jesús qeꞌy: Ma tzaj tyekꞌin Diosjo tumil kyeꞌy, tuꞌn tel kynikyꞌa tiꞌjjo a ewintaq ojtxe tiꞌjjo Tkawbꞌil Dios, a at toj kyaꞌj; quꞌn metziꞌn kyexjal nlay tzꞌel kynikyꞌ te. ");
INSERT INTO mamC_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tuꞌnpetziꞌn, ankyeꞌ xjal at tnimbꞌil wiꞌja, ktzajil qꞌoꞌn txqantl, tuꞌntzin tchꞌiyxixjo tnimbꞌil. Ex ankyeꞌ xjal noq nkaꞌmin tkꞌuꞌj tiꞌj tnimbꞌil, kyjaꞌpe k-elil qꞌiꞌne teꞌ chꞌin at. ");
INSERT INTO mamC_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tuꞌnpetziꞌn, nchin yoliꞌn kyukꞌa techil kyukꞌaxjal. Quꞌn nchi kaꞌyin kywutz, me mi n-el kynikyꞌ weꞌy. Ex ntbꞌiꞌn kyẍkyin, me mi n-okx toj kywiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Quꞌn ikytzin kbꞌajiljo tzeꞌn tqꞌma Isaías, a yolil Tyol Dios ojtxe, tej tqꞌma: Mix tuꞌn tzꞌok kybꞌin, mi n-okx toj kywiꞌ. Mix tuꞌn tzꞌok kykaꞌyin, mi n-el kynikyꞌ te. ");
INSERT INTO mamC_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Quꞌn noqx ma tzꞌok naj kynabꞌljo xjal luꞌn; jpuꞌnqe kyẍkyin, tuꞌn mi tzꞌokx toj kywiꞌ, jpuꞌnqe kywutz, tuꞌn mi tzꞌele kynikyꞌ te tbꞌanil. Tuꞌntzin ikyjo, mi nchi tzaj laqꞌe nkꞌatza, tuꞌn kykubꞌ nqꞌaninch. ");
INSERT INTO mamC_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Me kyꞌiwlinqexix kyeꞌ, tuꞌn nchi kaꞌyiꞌn kywutza, ex n-el kynikyꞌa te; ex nchi bꞌin kyẍkyiꞌn, ex n-okx toj kywiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Quꞌn twutzxix kxel nqꞌmaꞌn kyeꞌy, qa nimjo yolil Tyol Dios ojtxe, ex nim xjal wen kyajtaq tuꞌn kylon teꞌ a kyeꞌ ma kyli jaꞌlin, ex tuꞌn kybꞌin teꞌ a kyeꞌ ma kybꞌi jaꞌlin, me mix bꞌaje ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kybꞌintzjiꞌy tiꞌ t-xilin tiꞌjjo jun xjal xiꞌ awal. ");
INSERT INTO mamC_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Quꞌn ayetziꞌn nxi kybꞌiꞌn Tbꞌanil Tqanil tiꞌj Tkawbꞌil Dios, me mi n-el kynikyꞌ te, ikyqetziꞌn tzeꞌnku ijaj i kubꞌ tzꞌaq toj bꞌe. Jun paqx tzul tajaw il, tzeꞌnku jun pichꞌ, ex k-elil tiꞌn Tbꞌanil Tqanil, a kux awet toj kyanmin. ");
INSERT INTO mamC_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ex atzin ijaj, a kubꞌ tzꞌaq kyxol abꞌj, ikyqetziꞌn tzeꞌnqe xjal jun paqx nxi kynimin Tyol Dios ex tukꞌa tzaljbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Me quꞌn tuꞌn ntiꞌxix kykꞌuꞌj tiꞌj, mi nchi kujix toj kynimbꞌil. Qa akux saj jun tiꞌ toj kychwinqil, mo qa akux ẍi ok lipinxjal kyiꞌj noq tuꞌn tpajjo nyola, bꞌeꞌx kchi kꞌwel tzꞌaq toj kynimbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Atzin ijajjo pon tzꞌaq toj txꞌiꞌx, ikytziꞌn tzeꞌn jun xjal n-ok tbꞌiꞌn nyola. Me oꞌkx nchi bꞌisin tiꞌj tkyaqiljo tkubꞌ twutz txꞌotxꞌ. Ex kyaj tuꞌn tten tkyaqil tiꞌchaqku tiꞌ kye ex jniꞌ kyqꞌinmil. Tuꞌntzintzjo anetziꞌn, n-el naje kynimbꞌil tiꞌj Dios, ikyxsin tzeꞌnku triy njaw chꞌiy toj txꞌiꞌx. Noq n-el xkyꞌiꞌsix ex ntiꞌ toj n-el. ");
INSERT INTO mamC_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Me atziꞌn ijaj, a kux awet toj tbꞌanil txꞌotxꞌ, ikytziꞌn tzeꞌnqe xjal nxi kynimin nyola, ex nkubꞌ kybꞌinchin tzeꞌnku nqꞌmaꞌn. Nchi chꞌiy toj kynimbꞌil, tzeꞌnku triy, a s-el jweꞌ kꞌal twutz junjun, ex junjuntl el ox kꞌal, ex junjuntl el lajaj toj kaꞌwnaq. ");
INSERT INTO mamC_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ex xi tqꞌmaꞌn Jesús juntl techil. Chiꞌ kyjaluꞌn: A Tkawbꞌil Dios, a at toj kyaꞌj, ikytziꞌn tzeꞌnku jun ichin xiꞌ awal triy toj ttxꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tej tok bꞌaj, bꞌeꞌx ajtz. Me tej qok yupj, ul jun ajqꞌoj, ex xi tchtoꞌntl jun wiq kꞌul toj triy, ex bꞌeꞌx oq. ");
INSERT INTO mamC_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Me atzaj teꞌ chꞌiy triy, ex tbꞌaj weꞌje tunin, antza ele tnikyꞌtzajiltz qa attaq juntl wiq kꞌul toj. ");
INSERT INTO mamC_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ayetziꞌn taqꞌniljo tajaw awal bꞌeꞌx i xiꞌ qꞌmalte, ex xi kyqꞌmaꞌn: Tata, ¿Mixsin ja tskꞌoꞌn toj tijaja, tej tok tawaꞌn? Quꞌn ¿Jaꞌtzin saje jun wiq kꞌul toj ikyjo tzeꞌnku triy? ");
INSERT INTO mamC_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Atzin te tajaw aqꞌuntl xi tqꞌmaꞌn: Atla jun ajqꞌoj xkubꞌ bꞌinchin teꞌ ikyjo wiꞌja. Xi kyqꞌmaꞌn taqꞌnil te: ¿Mej qa ma qoꞌxa xbꞌoqil teꞌ maꞌ kꞌul toj triy? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Me ante tajaw aqꞌuntl xi tqꞌmaꞌn: Mina, quꞌn qa ma jatz xbꞌoqitjo nya wen kꞌul jaꞌlin, aku jatz lipe triy tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Qalaꞌ kyqꞌonkja ax tzqijkuj junx tukꞌa triy, tzmaxi kꞌaꞌ jatz skꞌetjo, aj tjaw joyit. Atzin te triy kxel kꞌuꞌyit teꞌ toj txꞌutxꞌ. Atzin teꞌ maꞌ kꞌul, kjawil kꞌlet, exsin kꞌwel patit tuꞌn qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ex kubꞌ tqꞌoꞌn Jesús juntl techil kyjaluꞌn: A Tkawbꞌil Dios toj kyaꞌj, ikytziꞌn t-xilin tzeꞌnku jun tal twutz mistas, aj tkux tawaꞌn jun xjal toj txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Quꞌn twutzxix a tal netzꞌxix kywutzjo txqantl twutz ijaj, me ajtzin tchꞌiy, jun tijx n-oke kywutzjo txqantl. Chꞌime njapin tzeꞌnku jun tze, a jaꞌ n-okxi kybꞌinchin pichꞌ kypaqbꞌil kyxol tqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ex kubꞌ tqꞌoꞌn Jesús juntl techil kyjaluꞌn: A Tkawbꞌil Dios toj kyaꞌj, ikytziꞌn tzeꞌnkuꞌ ttxꞌamil wabꞌj, a nkux tqꞌoꞌn jun qya toj oxe malbꞌil jarin. Ex ajtzin tbꞌaj tsmoꞌn, tkyaqiljo tqꞌotjil wabꞌj ktxꞌamixil, ex nchꞌiy wen. ");
INSERT INTO mamC_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Bꞌaj tqꞌmaꞌn Jesús tkyaqiljo lo kyexjal, noq kyukꞌa techil. Quꞌn ntiꞌtaq jun tiꞌ bꞌaj tqꞌmaꞌn, qa nya tukꞌa techil. ");
INSERT INTO mamC_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bꞌajjo ikyjo, tuꞌntzin tjapiꞌn a qꞌumj tuꞌn yolil Tyol Dios ojtxe, tej tkubꞌ ttzꞌibꞌin: Kchin yolila noq kyukꞌa techil. Ex kxel nqꞌmaꞌn nimku tiꞌ, a ewintaq, atxix teꞌ tkubꞌku tbꞌinchin Dios twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx i aj tchqꞌoꞌn Jesús xjal kyja. Ex okx tuja, a jaꞌ o tzaja laqꞌeꞌy tkꞌatz, a awoꞌy t-xnaqꞌtzbꞌin, ex xi qqꞌmaꞌn te: Chikyꞌbꞌintzjiy techil tiꞌjjo kꞌul nya wen toj triy. ");
INSERT INTO mamC_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ex tzaj ttzaqꞌwin Jesús qeꞌy: Atziꞌn awal triy, ayin wejiꞌy, a Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ante txꞌotxꞌ ayetziꞌn xjal tkyaqil. Atzin triy, ayetziꞌn nimil tiꞌj Tyol Dios. Ex atziꞌn kꞌul, ayetziꞌn xjal nya nimil, ayeꞌ ncheꞌx lipe tiꞌj tajaw il. ");
INSERT INTO mamC_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ex atzin te ajqꞌoj, a xi chtonte tyajil kꞌul toj triy, ax tajaw il. Atzin teꞌ joꞌj triy, atzin teꞌ aj tbꞌaj twutz txꞌotxꞌ te jun majx. Ex ayetziꞌn aqꞌnil mo joꞌl triy, ayetziꞌn t-angel Dios. ");
INSERT INTO mamC_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ikytziꞌn tzeꞌn kꞌul aj tjaw noq tuꞌn tokx toj qꞌaqꞌ tuꞌn ttzꞌeꞌy, ikytzin kbꞌajiljo, aj tbꞌaj tkyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ex ayiꞌn, a Tkꞌwal Ichin, chi xel nchqꞌoꞌn n-angela, tuꞌn kyetz xbꞌoqitjo toj Tkawbꞌil Dios kykyaqiljo nchi bꞌinchin il, ex ayeꞌ nchi xmoxin kyiꞌj junjuntl tuꞌn tkubꞌ kybꞌinchin il. ");
INSERT INTO mamC_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ex kchi okix toj jun patbꞌil ma tij, ja njuline qꞌaqꞌ wen, ex antza okx chi juꞌchꞌilx kyste tuꞌn kyixkꞌoj, a mix kbꞌajilx. ");
INSERT INTO mamC_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Me ayetzin kyeꞌ, a kubꞌ kybꞌinchin tzeꞌnkuxjo ntqꞌmaꞌn Dios, ok kchi qoptzꞌajiyil kye tzeꞌnku tqan qꞌij toj Tkawbꞌil Dios, a kyTata. Ankyeꞌ at tẍkyiꞌn tuꞌn tok tbꞌiꞌn, in tok tbꞌiꞌn, ex in tkubꞌ tbꞌinchin tzeꞌnkuxjo ntqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","A Tkawbꞌil Dios, a at toj kyaꞌj, ikytziꞌn tzeꞌnku jun qꞌinimil ewin toj jun txꞌotxꞌ. Jun ichin, qa ma knetjo qꞌinimil tuꞌn, bꞌeꞌx aku meltzꞌaj ewilte axsa. Maꞌx tzeꞌjix tiꞌj wen, ex noq tuꞌn ttzyetkuꞌ txꞌotxꞌ tuꞌn anetziꞌn, kbꞌaj xel tkꞌayin tkyaqiljo at te, tuꞌn ttzaj tlaqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ex ikyxjo, a Tkawbꞌil Dios, a at toj kyaꞌj, tzeꞌnku jun kꞌayil njyoꞌn tiꞌj jun tal abꞌj tbꞌanilxix. ");
INSERT INTO mamC_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ajtzin tknet jun tuꞌn, a wiꞌyilxix wen, kbꞌaj xel tkꞌayin tkyaqiljo at te, noq tuꞌn tlaqꞌetku tal abꞌj tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ex ikyxjo, a Tkawbꞌil Dios, a at toj kyaꞌj, tzeꞌnku jun pa te tzuybꞌil kyiẍ. Aj t-xi xoꞌyit toj aꞌ, tkyaqil wiq kyiẍ ntzyet tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ajtzin tnoj, aye kyiẍil kjawitz kyiꞌn tzma ttzi aꞌ. Antza, kchi kꞌwele qeye skꞌol teꞌ kyiẍ. Ayetziꞌn wen, kchi xel kꞌuꞌyit toj chiꞌl; ex ayetziꞌn mina, chi xel kyxoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ikytzin kbꞌajiljo, aj tjapin bꞌaj tkyaqil twutz txꞌotxꞌ. Kchi elitz t-angel Dios paꞌl kyeꞌ nya wenqe kyiꞌjjo a wen. ");
INSERT INTO mamC_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ayetziꞌn nya wenqe kchi xel xoꞌyit toj jun tij kꞌachbꞌil qꞌaqꞌ, a mixla kbꞌajilx, jaꞌ kchi oqꞌile, ex kchi juꞌchꞌile kyste tuꞌn kyixkꞌoj. ");
INSERT INTO mamC_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tzaj tqanin Jesús qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin: ¿Tzuntzin n-el kynikyꞌa tiꞌj tkyaqiljo lo? chiꞌ. Exsin xi qtzaqꞌwiꞌn: Tzun, qAjaw, qo chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ex tzaj tqꞌmaꞌnl Jesús qeꞌy: Tuꞌnpetziꞌn, jun xnaqꞌtzil tiꞌj ojtxe kawbꞌil, aj qa ma txi lipe tiꞌjjo Tkawbꞌil Dios, a at toj kyaꞌj, k-okil tzeꞌnku jun tajaw ja, a at kabꞌe wiq tqꞌinimil, jun ojtxe qꞌinimil ex jun akꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tej kybꞌaj tqꞌmaꞌn Jesús kykyaqiljo techil, bꞌeꞌx xiꞌ ");
INSERT INTO mamC_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","tzma toj ttanim. Antza xi xkye tuꞌn t-xnaqꞌtzin kyoj muꞌẍ ja te kꞌulbꞌil. Ex tkyaqilxjal bꞌaj jaw kaꞌylaj, ex kyqꞌma: ¿Jaꞌtzila xbꞌaje t-xnaqꞌtzin xjaljo tkyaqiljo bꞌaꞌn tuꞌn? ¿Ex tzeꞌntzin tten nbꞌantjo tbꞌanil techil tipin tuꞌn ikyjo? ");
INSERT INTO mamC_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ma nyapetzila a ttata, a jsol tzꞌlan? ¿Ma nya tnana, a Mariy? ¿Ma nyaqetzin titzꞌin Santyaw, Jse, Simun, ex Judas? ");
INSERT INTO mamC_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ma nyaqetzin tanebꞌjo najleqe qxol? ¿Jaꞌtzin xbꞌante tkyaqiljo luꞌn tuꞌn? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Quꞌn tuꞌn kyojtzqiꞌntaq, mix xi kynimine. Me xi tqꞌmaꞌn Jesús kye: Jaꞌchaqx taꞌ jun yolil Tyol Dios twutz txꞌotxꞌ, nxi qꞌoꞌnx toklin. Me qa tojx ttxꞌotxꞌ ex tojx tja ntiꞌx toklin. ");
INSERT INTO mamC_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nya nimku yekꞌbꞌil tipin bꞌant kyxol t-xjalil, quꞌn tuꞌn mix xi kynimine Tyol. ");
INSERT INTO mamC_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kyojjo qꞌij anetziꞌn, bꞌijte tqanil Jesús tuꞌn Herodes, a tnejil kawil toj txꞌotxꞌ te Galiley. ");
INSERT INTO mamC_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Herodes kye taqꞌnil: Ala te Juan luꞌn, ma jatz anqꞌin kyxol kyimnin. Quꞌn tiꞌjkutziꞌn, tbꞌanilx tipin tuꞌn tbꞌant txqan tbꞌanil techil tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Otaq kux tjpuꞌn Herodes Juan toj tze, kꞌloꞌntaq wen tukꞌa kxbꞌil, noq tuꞌn tpaj Herodías, a t-xuꞌjil, a t-xuꞌjlbꞌin Lip, a titzꞌin, ");
INSERT INTO mamC_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","quꞌn tuꞌn xi tqꞌmaꞌn Juan te Herodes: Nya wen tuꞌn tok mejeꞌy tukꞌa t-xuꞌjil titzꞌiꞌnch. ");
INSERT INTO mamC_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tuꞌnpetziꞌn, tajtaq Herodes tuꞌn tkubꞌ tbꞌyoꞌn Juan, me tzaj t-xobꞌil kyexjal, quꞌn tuꞌn otaq tzꞌok kyqꞌonxjal Juan te yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tej tel tabꞌqꞌe Herodes, kubꞌ ikyꞌsit jun nintz qꞌij, ex atzin tal Herodías etz bꞌixil kywutz kykyaqiljo txokenj. ");
INSERT INTO mamC_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ex bꞌeꞌx pon tkꞌuꞌj Herodes tiꞌj, ex kubꞌ tqꞌmaꞌn tbꞌi Dios tiꞌj tyol: Qanintza weꞌy noq alkye taja, chiꞌ te txin. ");
INSERT INTO mamC_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Me a tnana xi qꞌmante te, tiꞌtaqjo tuꞌn t-xi tqanin: Qꞌontzjiy twiꞌ Juan, a Jawsil Aꞌ, weꞌy toj jun laq jaꞌlinxix. ");
INSERT INTO mamC_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tej tbꞌinte Herodes ikyjo, bꞌeꞌx jaw bꞌisin. Me quꞌn tuꞌn otaq kubꞌ tqꞌmaꞌn tbꞌi Dios tiꞌj tyol, ex kywutz kykyaqiljo txokenj, qa akutaq txi tqꞌoꞌn noq alkyetaqjo tajjo txin, kubꞌ t-ximin qa iltaq tiꞌj tuꞌn tbꞌajjo tyol. ");
INSERT INTO mamC_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ex bꞌeꞌx xi tqꞌmaꞌn, tuꞌn tel kꞌuẍpit twiꞌ Juan toj tze. ");
INSERT INTO mamC_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Exsin xi tqꞌoꞌntz twiꞌ Juan toj jun laq te txin, tzeꞌnkuxtaq otaq tqanin. Ex anteꞌ txin bꞌeꞌx xi tqꞌoꞌn te tnana. ");
INSERT INTO mamC_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Me ayetziꞌn t-xnaqꞌtzbꞌin Juan i pon, ex xi kyiꞌn t-xmilil, tuꞌn tkux muqet. Ex bꞌeꞌx i xiꞌ qꞌmalte te Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tej tbꞌiꞌnte Jesús ikyjo, bꞌeꞌx o okxa toj jun bark toj ewajil, tuꞌn qkaniꞌn toj jun najbꞌil ja ntiꞌyetaq xjal. Me bꞌeꞌx kybꞌin texjal tojile junjun tnam, ex bꞌeꞌx bꞌaj xi lipe qiꞌja tuꞌn kyqan, quꞌn kyajtaq tuꞌn kynej qwutza. ");
INSERT INTO mamC_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tej tetz Jesús toj bark, xi tkaꞌyin txqan xjal attaq, ex bꞌeꞌx tzaj qꞌaqꞌin tkꞌuꞌj kyiꞌj, ex bꞌeꞌx i bꞌaj tqꞌanin junjun, a yabꞌqetaq. ");
INSERT INTO mamC_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tej chꞌixtaq qok yupj, awotziꞌn, a t-xnaqꞌtzbꞌin, o tzaj laqꞌeꞌy tkꞌatz, ex xi qqꞌmaꞌn te: Ma qoqixte jaꞌlin, ex mix aꞌl jun najle tzaluꞌn. Qꞌmanxa kye jniꞌ xjal tuꞌn kybꞌaj xiꞌ toj junjun kojbꞌil, tuꞌn kyxiꞌ jyol kywa, qape at kꞌaẍjil. ");
INSERT INTO mamC_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Me tzaj tqꞌmaꞌn Jesús qeꞌy: Nya il tiꞌj tuꞌn kyxiꞌ jyol jun tiꞌ. Qalaꞌ kyqꞌonxa kywa. ");
INSERT INTO mamC_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Me atzin qeꞌ xi qqꞌmaꞌn: Ntiꞌ qe wabꞌj qꞌiꞌn quꞌn. Noq tal jweꞌ wabꞌj, ex kabꞌe tal netzꞌ kyiẍ. ");
INSERT INTO mamC_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Me tzaj tqꞌmaꞌn Jesús qeꞌy: Kyiꞌnqetza tzaluꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ex xi tqꞌmaꞌn kye jniꞌ xjal, tuꞌn kybꞌaj kubꞌ qe tibꞌaj kꞌul. Ex i jaw ttzyuꞌn jweꞌ tal wabꞌj exqetziꞌn kabꞌe tal kyiẍ, ex jaw tkaꞌyin twutz kyaꞌj, ex xi tqꞌoꞌn chjonte te Dios kyiꞌj. Ex i bꞌaj tpiẍiꞌn tal wabꞌj, ex tzaj tqꞌoꞌn qeꞌy, ex xi qsipiꞌn kyexjal. ");
INSERT INTO mamC_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kykyaqilxjal i bꞌaj waꞌn, ex bꞌaj noj kykꞌuꞌj wen. Atzaj teꞌ kybꞌaj waꞌn, jaw qskꞌoꞌn jniꞌ tbꞌuchil, ex jaw noj kabꞌlajaj chiꞌl. ");
INSERT INTO mamC_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ayetziꞌn i waꞌn, jweꞌ mil ichin, me nya telqetziꞌn qya exqetziꞌn kꞌwal i ok te tajlal. ");
INSERT INTO mamC_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tbꞌajlinxiꞌ ikyjo, o jax tchqꞌoꞌn Jesús awoꞌy, a t-xnaqꞌtzbꞌin, toj bark, tuꞌn qikyꞌxa tjlajxi nijabꞌ. Otaq qo neja tuꞌn qikyꞌxa jlajxi; kyij Jesús qꞌolbꞌil kyexjal. ");
INSERT INTO mamC_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tej kybꞌaj tqꞌolbꞌin Jesús xjal, jax twiꞌ jun wutz naꞌl Dios tjunalx. Tej qok yupj, ex tjunalxtaq Jesús at. ");
INSERT INTO mamC_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Me noqx nnikyꞌjinku nijabꞌ tuꞌn bark, tej ttzaj txqan kyqꞌiqꞌ, ex bꞌeꞌx okx piqꞌj txqan aꞌ toj. ");
INSERT INTO mamC_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tej chꞌixtaq qsqix, tzaj laqꞌe Jesús qkꞌatza; nbꞌet tibꞌaj aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tej t-xi qkaꞌyiꞌn te nbꞌettaq tibꞌaj aꞌ, bꞌeꞌx o jaw ẍchꞌin wen tuꞌn qxobꞌila: Jun ma tij klelin, qo chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Me jun paqx tzaj tqꞌmaꞌn Jesús qeꞌy: ¡Kykujsinx kykꞌuꞌja! ¡Ayin wejiꞌy! Mi chi xobꞌach. ");
INSERT INTO mamC_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Me ante Pegr xi ttzaqꞌwin: WAjaw, qa ajiy, qꞌmantza tuꞌn nxiꞌy tkꞌatza tibꞌaj aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ku tzaja, chi Jesús. Ex jun paqx, tkuꞌtz Pegr toj bark, ex xi bꞌet tibꞌaj aꞌ, tuꞌn tpon tkꞌatz Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Me atzaj teꞌ tnaꞌnte txqan tipin kyqꞌiqꞌ, bꞌeꞌx tzaj xobꞌ, ex kyjaꞌtaq txi mulqꞌaj toj aꞌ. Bꞌeꞌx jaw ẍchꞌin tuꞌn t-xobꞌil: Chin tkloma, wAjawch. ");
INSERT INTO mamC_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ex jun paqx jaw tjkꞌuꞌn Jesús tukꞌa tqꞌobꞌ, ex xi tqꞌmaꞌn te: Ay, noq tal chꞌin tnimbꞌila wiꞌja. ¿Tiquꞌn xjaw kaꞌmin tkꞌuꞌja? ");
INSERT INTO mamC_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Me atzaj teꞌ kyjax toj bark, bꞌeꞌx kubꞌ qen tej kyqꞌiqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ex awotzin qe, a otokxtaqa toj bark, bꞌeꞌx o kubꞌ mejey twutz Jesús, ex o nimsin tbꞌi kyjaluꞌn: Twutzxix Tkꞌwal Diosx te. ");
INSERT INTO mamC_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Me atzaj teꞌ qjlajinxa tjlajxi nijabꞌ, o pon toj txꞌotxꞌ te Genesaret. ");
INSERT INTO mamC_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ex ayetziꞌn xjal antza, bꞌeꞌx el kynikyꞌ te Jesús. Bꞌeꞌx el tqanil toj tkyaqil txꞌotxꞌ, ex bꞌeꞌx i bꞌaj xi kyinxjal kyyabꞌ te, tuꞌn kykubꞌ tqꞌanin. ");
INSERT INTO mamC_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ex i kubꞌsin kywutz te, tuꞌn t-xi ttziyin Jesús, noq tuꞌn tok kymekoꞌnxjal iꞌchaqxitla noq tal ttxaꞌn t-xbꞌalintz. Ex kykyaqiljo, ayeꞌ i ok mekonte ttxaꞌn t-xbꞌalin, bꞌeꞌx bꞌajel weꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","I tzaj laqꞌe junjun Parisey, junx kyukꞌa junjun xnaqꞌtzil tiꞌj ojtxe kawbꞌil tkꞌatz Jesús, aye otaq chi kanin Jerusalén. Ex xi kyqanin te: ");
INSERT INTO mamC_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Tzeꞌntzin kyten kyeꞌ t-xnaqꞌtzbꞌiꞌn mi nkubꞌ kynimin a kyij yekꞌin qe kyuꞌn qtzan qtaꞌẍ? Quꞌn mi njapin techil kyuꞌn, a tzeꞌnku nbꞌanttaq kyuꞌn qtzan qtaꞌẍ, tzeꞌnku qe, a tuꞌn tel kytxjon kyqꞌobꞌ tukꞌa tumil, aj kyaqꞌe waꞌl. ");
INSERT INTO mamC_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ex xi tqanin Jesús kye: Ex ikyxjo kyeꞌ. ¿Tiquꞌn n-el kyiꞌjlinjiꞌy Tkawbꞌil Dios, noq tuꞌn kyokku lipeꞌy tiꞌjjo xnaqꞌtzbꞌil xkyij kyqꞌoꞌn qtzan qtaꞌẍ? ");
INSERT INTO mamC_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Quꞌn chte Diosjo kyjaluꞌn: Kyniminku kytatiy, ex kynaniy, ex ankye teꞌ k-elil tzaqpaj ttzi te ttata ex te tnana, il tiꞌj tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Me ayetzin kyeꞌ nchi qꞌmante, qa bꞌaꞌn tuꞌn t-xi qqꞌmaꞌn te qtata mo te qnana kyjaluꞌn: Matla txi nmojiꞌn, noqit nya tkyaqiljo at weꞌy jaꞌlin, ma txi nqꞌoꞌn te Dios, tuꞌn tajbꞌin te, aj nkyima. Tuꞌnpetziꞌn, ntiꞌx tuꞌn nmojiꞌn tiꞌja, exla qa at tajbꞌin teꞌy. Ex bꞌaꞌnjo lo toj kywutza. ");
INSERT INTO mamC_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Quꞌn qa ikyjo, nlayxpen bꞌanttz tuꞌn tmojin tiꞌj ttata ex tiꞌj tnana, chi chijiꞌy. Quꞌn ma kyij kytzaqpinjiꞌy Tkawbꞌil Dios, noq tuꞌn kyxi lipekuy tiꞌjjo kyeꞌ kyxnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Xmiletzꞌqiꞌy. Quꞌn twutzx tej tyol qtzan yolil Tyol Dios te, a Isaías, tej tyolin tiꞌj kyxmiletzꞌila: ");
INSERT INTO mamC_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ayetziꞌn xjal tzaluꞌn, nchin kubꞌ kynimiꞌn, me noq tukꞌa kytzi. Me atzin kyanmin najchaq taꞌ wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ntiꞌx tajbꞌiꞌn a nchi kꞌulin nwutza, quꞌn noqx tiꞌjjo kyxnaqꞌtzbꞌilxjal lipcheqeke. ");
INSERT INTO mamC_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","I xi ttxkoꞌn Jesús jniꞌ xjal tkꞌatz, ex xi tqꞌmaꞌn kye: Chin kybꞌintziꞌn, ex tzꞌelku kynikyꞌa te: ");
INSERT INTO mamC_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nya teꞌ tiꞌchaqku tiꞌ nbꞌaj tuꞌn jun xjal, nxi qꞌonte toj il, qalaꞌ ikytzin a teꞌ n-etz toj ttzi. ");
INSERT INTO mamC_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tuꞌnpetziꞌn, bꞌeꞌx o bꞌaj tzaj laqꞌeꞌy, a awoꞌy t-xnaqꞌtzbꞌin tkꞌatz, ex xi qqꞌmaꞌn te: ¿Ma man tzꞌel tnikyꞌa te, qa bꞌeꞌx saj kyqꞌoj Parisey, tej xkybꞌin teꞌ a xbꞌaj tqꞌmaꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Me ante Jesús tzaj ttzaqꞌwin qeꞌy: Tkyaqil kyxnaqꞌtzbꞌil Parisey ikyjo tzeꞌnku jun wiꞌ kꞌul, a qa nya nTatiꞌy tokx toj kyaꞌj, xkux awante. Okla kjawitz xbꞌoqit te jun majx tukꞌa tkyaqil tlokꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ex chi tenkuj, quꞌn jpuꞌn kynabꞌl. Nchi kubꞌ nej kywutz junjun ikyx kyten tzeꞌnku aye. Ikyqetziꞌn tzeꞌn kabꞌe moẍ nxi kyxkoꞌn kyibꞌ; me qa aku ẍi ex twiꞌ xaq, kykabꞌilx kchi xeꞌl tolpaj. ");
INSERT INTO mamC_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Me ante Pegr xi tqꞌmaꞌn te Jesús: Chikyꞌbꞌintza qeꞌy tiꞌjjo xbꞌaj tqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tzaj ttzaqꞌwin Jesús qeꞌy: Ex ikyx kyejiꞌy, ¿Mi s-el pjet toj kynabꞌla? ");
INSERT INTO mamC_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ma mitzin n-el kynikyꞌa te, qa tkyaqiljo nbꞌaj tuꞌn jun xjal, toj tkꞌuꞌj kupine, ex majx k-elil tiꞌj? ");
INSERT INTO mamC_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Me atziꞌn n-etz toj ttzi, toj tanminx ntzaje anqꞌine. Apente iljo, ");
INSERT INTO mamC_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","quꞌn toj tanminxjal ntzaje jniꞌ t-xim nya bꞌaꞌn, jniꞌ bꞌiꞌyin, jniꞌ kyꞌaꞌjin, ex jniꞌ aj pajil, jniꞌ elqꞌin, jniꞌ sbꞌubꞌl, exsin tkyaqil yasin, ");
INSERT INTO mamC_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","tuꞌn kxel toj najin te jun majx. Me teꞌ, tuꞌn kywaꞌnxjal, a noq tuꞌn mi tzꞌele txjet tqꞌobꞌ jun xjal tzeꞌnku kye, aj txi waꞌl, ntiꞌ te najin noq tuꞌn tpajjo ikyjo, quꞌn noq xnaqꞌtzbꞌil kye qtzan qtaꞌẍ. ");
INSERT INTO mamC_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tej tetz Jesús antza, bꞌeꞌx xiꞌ toj txꞌotxꞌ te Tiro ex te Sidón. ");
INSERT INTO mamC_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ex attaq jun qya aj Canaán najletaq tojjo txꞌotxꞌ antza, a nya Judiytaq. Tzaj laqꞌe tkꞌatz Jesús, ex nẍchꞌintaq wen: Tata, ay Tyajil qtzan nmaq kawil David, qꞌaqꞌintz tkꞌuꞌja wiꞌja; at jun wala, at jun taqꞌnil tajaw il toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Me mix xi ttzaqꞌwin Jesús jun tyol. Tuꞌnpetziꞌn, o tzaj laqꞌeꞌy, a awoꞌy t-xnaqꞌtzbꞌin tkꞌatz, ex o kubꞌsin qwutza te: Qalaꞌ, qꞌmanxa te qya tuꞌn taj tja, quꞌn luꞌ tzunx nẍchꞌinx wen, ex luꞌtz lipchek qiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Xi tqꞌmaꞌn Jesús te: Ma chin tzaj tchqꞌon weꞌ Dios noq kyukꞌa xjal aj Judiy, ayeꞌ najnin iteꞌye tzeꞌnku jun chꞌuq rit. ");
INSERT INTO mamC_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Me anteꞌ qya kubꞌ meje twutz Jesús, ex xi tqꞌmaꞌn: ¡Tata, chin tonima! ");
INSERT INTO mamC_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Me ante Jesús xi tqꞌmaꞌn te: Yonkuy nej, tuꞌn kyxi nmojinjiꞌy nxjalila, quꞌn nya wen tuꞌn tel kywaꞌ tal kꞌwal, exsin tuꞌn t-xiꞌ kye chit, quꞌn nej tuꞌn kybꞌaj waꞌn tal kꞌwal, exsin kxel xiljo kye chittz. Ikyqintzin wejiꞌy kyukꞌa nxjalila; nej chi okil nkaꞌyiꞌn, ex kxel nqꞌoꞌnjiꞌy a ntiꞌ at kye. ");
INSERT INTO mamC_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ex xi ttzaqꞌwin qya: Ikyx te tten, Tata. Me kaꞌnqetzin kyejiꞌy tal chit nchi waꞌn kye tjaqꞌ meẍ tiꞌjjo tbꞌuchil wabꞌj nbꞌajel tzꞌaq kyuꞌn kyajaw. Ikyqintzintlaꞌ wejiꞌy, qꞌontz chꞌin weꞌ tiꞌjjo nxi tqꞌoꞌn kye t-xjalila. ");
INSERT INTO mamC_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tuꞌntziꞌn tyoljo qya ikyjo, xi ttzaqꞌwin Jesús te: Ay qya, nimxixjo tnimbꞌila wiꞌja. Kxel nqꞌoꞌn tzeꞌnku taja. Atzaj taljo qya, jun paqx tel weꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tej tetz Jesús antza, pon tzma ttzi Nijabꞌ te Galiley. Ex bꞌeꞌx jax twiꞌ jun wutz, ex kubꞌ qe antza. ");
INSERT INTO mamC_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ex nimxjal bꞌaj chmet jaꞌ taꞌyetaq. Ex qꞌimila junjun kox kyuꞌn, junjun moẍ, ex ilaꞌkul mibꞌintaq chi bꞌet ex mibꞌintaq chi yolin, ex nimku txqantl yabꞌ bꞌaj xi qꞌiꞌn twutz Jesús. Ex bꞌeꞌx i kubꞌ tqꞌanin. ");
INSERT INTO mamC_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ex ayetziꞌn xjal bꞌeꞌx i bꞌaj jaw kaꞌylaj, tej tok kykaꞌyin tbꞌant kyyoliꞌn a mibꞌintaq chi yolin; ex otaq bꞌant kybꞌetjo a mibꞌintaq chi bꞌet; ex otaq jqet kyẍkyin a mibꞌintaq chi bꞌin; ex otaq chi el weꞌ kox, ex otaq kꞌant kywutzjo moẍqetaq. Jotxjo jniꞌ xjal i bꞌaj ok ten nimsil tbꞌi Dios, a kyDios aj Israel. ");
INSERT INTO mamC_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","O tzaj ttxkoꞌn Jesús a awoꞌy t-xnaqꞌtzbꞌin, ex tzaj tqꞌmaꞌn qeꞌy: Nchyoꞌn nkꞌuꞌja kyiꞌjjo xjal lo, quꞌn ma bꞌant-xi oxe qꞌij kytenbꞌile qukꞌa, ex ntiꞌx chꞌin o txi kywaꞌn. Ex nkyꞌeꞌy tuꞌn kyaj nchqꞌoꞌn kyja kukxjo, quꞌn aku chi kubꞌ numj toj bꞌe tuꞌn waꞌyaj. ");
INSERT INTO mamC_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ex xi qqꞌmaꞌn: ¿Me jaꞌ aku tzaje kywa txqan xjal quꞌn? Mix yaꞌ ntiꞌx jun xjal najle tzaluꞌn, qo chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Me tzaj tqanin Jesús qeꞌy: ¿Jteꞌ wabꞌj qꞌiꞌn kyuꞌn? Noq tal wuq, ex jun tal jteꞌbꞌin netzꞌ kyiẍ, qo chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ex xi tqꞌmaꞌn Jesús kye jniꞌ xjal, tuꞌn kybꞌaj kubꞌ qe twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ex i jaw ttzyuꞌn wuq wabꞌj, exqetziꞌn tal netzꞌ kyiẍ, ex xi tqꞌoꞌn chjonte te Dios kyiꞌj, i kubꞌ tpiẍin, ex tzaj tqꞌoꞌn qeꞌy, tuꞌn t-xi qsipiꞌn kye jniꞌ xjal. ");
INSERT INTO mamC_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kykyaqilxjal noqx jniꞌ i bꞌaj waꞌn. Tej kybꞌaj waꞌn, jaw chmetjo jniꞌ tbꞌuchil wabꞌj tkyaqil, ex atzin tej tbꞌaj chmet, bꞌant wuq chiꞌl. ");
INSERT INTO mamC_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ayetziꞌn ichin, ayeꞌ i bꞌaj waꞌn, kyaje mil, me mix ok ajletjo qya exqetziꞌn kꞌwal. ");
INSERT INTO mamC_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx i aj tchqꞌoꞌn Jesúsjo xjal kyja, ex bꞌeꞌx o okxa toj bark, tuꞌn kyxiꞌy toj txꞌotxꞌ te Magadán. ");
INSERT INTO mamC_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Juntl majl, i bꞌaj pon chmet Parisey kaꞌyil tiꞌj Jesús junx kyukꞌa junjun Sadusey. Noq tuꞌn tkubꞌ tzꞌaq kyuꞌn toj til, xi kyqanin te, tuꞌn tkubꞌ tbꞌinchin jun tbꞌanil techil tipin twutz kyaꞌj, tuꞌn tyekꞌin qa te Dios tzajnin. ");
INSERT INTO mamC_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Me xi ttzaqꞌwin Jesús kye: ¿Tzeꞌntzin tten n-el kynikyꞌa tiꞌjjo qꞌij? Quꞌn qa manyor chikyꞌx twutz kyaꞌj qale, nkyqꞌmaꞌn qa tbꞌanilx qꞌij nchiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ex qa qlixje, nya wen k-elixe qꞌij jaꞌlin, chi chijiꞌy, quꞌn manyor chikyꞌx twutz kyaꞌj, ex manyor qꞌaq mujilx. Qa n-el kynikyꞌa tiꞌjjo techil te twutz kyaꞌj, ¿Tzeꞌntzin tten mi n-el kynikyꞌtza tiꞌjjo tzeꞌntzin t-xilin techiljo tqꞌijil jaꞌlin? ");
INSERT INTO mamC_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ayeꞌ xjal tzaluꞌn manyor aj ilqex ex aj pajilqe. Nkyqanin tuꞌn tkubꞌ nbꞌinchiꞌn jun tbꞌanil techil wipiꞌn kywutz, me mixla kbꞌantil; oꞌkxjo tzeꞌn bꞌaj tiꞌj qtzan Jonás ojtxe. Ex bꞌeꞌx i kyij ttzaqpiꞌn antza. ");
INSERT INTO mamC_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tej qjlajinxa tjlajxi nijabꞌ, bꞌeꞌx el naj toj qkꞌuꞌja tuꞌn t-xi qiꞌn qwaꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tzaj tqꞌmaꞌn Jesús qeꞌy: Bꞌaꞌnqexa. Kykaꞌyink kyibꞌa noq cheꞌxa tiꞌjjo ttxꞌamsbꞌil kywa Parisey ex Sadusey. ");
INSERT INTO mamC_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Me bꞌeꞌx o bꞌaj jaw yolin awoꞌy t-xnaqꞌtzbꞌin qxolxa, ex qqꞌmaꞌy: Ma tzaj tqꞌmaꞌn qe, tuꞌn tok qkaꞌyin qibꞌ, bꞌalaqa tuꞌn mi saj qiꞌn qwa; yaj qa saj kyqꞌoꞌnku Parisey qwa, exsin qa tiꞌku xi kyqꞌoꞌn toj. ");
INSERT INTO mamC_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ex bꞌeꞌx el tnikyꞌ Jesús teꞌ qbꞌisa, ex tzaj tqꞌmaꞌn qeꞌy: ¿Tiquꞌn nkubꞌ kybꞌisiꞌn qa ntiꞌ kywaꞌy qꞌiꞌn? Ntiꞌxla chꞌin kyeꞌ tqꞌuqbꞌil kykꞌuꞌj wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Naꞌmxsin tel kynikyꞌa te. ¿Ma mitzin naꞌn kyuꞌn kyiꞌj jweꞌ wabꞌj, ayej i kubꞌ nsipiꞌn kyxoljo jweꞌ mil xjal? ¿Jteꞌn chiꞌl jaw chmet, tej kybꞌaj waꞌnxjal? ");
INSERT INTO mamC_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ex ¿Ma mitzin naꞌn kyuꞌn kyiꞌjjo wuq wabꞌj, ayej i kubꞌ nsipiꞌn kyxoljo kyaje mil xjal? ¿Jteꞌxsin chiꞌljo jaw chmet, tej kybꞌaj waꞌnxjal? ");
INSERT INTO mamC_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Yajtzin qetz, ma nlan qo waꞌntz wuꞌn qkyaqilx? Qalaꞌ nya tiꞌjjo wabꞌj te twutz txꞌotxꞌ nchin yoline weꞌ, tej xi nqꞌmaꞌn: Kykaꞌyink kyibꞌa tiꞌjjo ttxꞌamsbꞌil kywa Parisey ex Sadusey. ");
INSERT INTO mamC_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tzmaxitzin el qnikyꞌjiꞌy tiꞌj, qa mi nyolintaq Jesús tiꞌjjo juntl txꞌamsbꞌil wabꞌj, qalaꞌ tiꞌjjo kyxnaqꞌtzbꞌil Parisey exqetziꞌn Sadusey. ");
INSERT INTO mamC_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Atzaj teꞌ qkaniꞌn toj txꞌotxꞌ te Cesarea te Filipo, tzaj tqanin Jesús qeꞌy: ¿Ankyeqiꞌn, a Tkꞌwal Ichin, toj kywutzjo xjal? ");
INSERT INTO mamC_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Xi qtzaqꞌwiꞌn: At junjun nqꞌmante qa ajiy qtzan Juan, a Jawsil Aꞌ, ma jaw anqꞌintl, ex junjuntl nqꞌmante qa ajiy Elías, moj qa ajiy Jeremías, mo juntl yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","¿Yajtzin kye toj kywutz? ¿Ankyeqiꞌn? chi Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Xi ttzaqꞌwin Pegr: Atejiy Crist, a Tkꞌwaljo Dios itzꞌ te jun majx, a skꞌoꞌnxix tuꞌn, tuꞌn tul tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Xi ttzaqꞌwin Jesús: Kyꞌiwlinxix te, ay Simun, a tkꞌwal Jonás; quꞌn mix aꞌl jun xjal saj qꞌmante tey, qalaꞌ a nMaꞌn, a at toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ex kxel nqꞌmaꞌn tey, qa a tbꞌiy Pegr, a abꞌj tzꞌelpine. Ex tibꞌajjo abꞌj lo kjawile nbꞌinchiꞌn Ntanima. Ex nlayx kubꞌ tiꞌj tuꞌn tkyaqil tipin kyimin. ");
INSERT INTO mamC_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ex kxel woqxeninjiꞌy Nxnaqtzbꞌila tey nyakutlaj jun tal tal tjpel ja, tuꞌntzintla noq tiꞌj ktqꞌmaꞌbꞌila, tzꞌele kynikyꞌxjal tiꞌjjo Tbꞌanil Tqanil Tkawbꞌil Dios. Ex qa ma kotpitjo xjal tuꞌn toj kyil, noq tuꞌn ktqꞌmaꞌbꞌila tzaluꞌn twutz txꞌotxꞌ, ex aj kyok toj paꞌbꞌin twutz Dios toj kyaꞌj, kchi kotpajil te jun majx. Ex qa mi xi kynimin a ktqꞌmaꞌbꞌila, ma chi kꞌlet tuꞌn kyil tzaluꞌn twutz txꞌotxꞌ, ex aj kyok toj paꞌbꞌin twutz Dios toj kyaꞌj, chi xel toj najin te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ex xi toqxenin Jesús qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin, tuꞌn mi qo ok teꞌn qꞌmalte kye jniꞌ xjal, qa ataq Jesúsjo Crist, a Kolil, quꞌn naꞌmxtaq tul tqꞌijil. ");
INSERT INTO mamC_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Axsa, oke ten Jesús xnaqꞌtzil qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin, qa iltaq tiꞌj tuꞌn t-xiꞌ toj Jerusalén, ex iltaq tiꞌj tuꞌn tikyꞌx tuꞌn antza kyuꞌn kynejil xjal ex kyuꞌn kynejil pale junx kyukꞌa xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Ex tzaj tqꞌmaꞌn qeꞌy, qa iltaq tiꞌj tuꞌn tkubꞌ bꞌyoꞌn kyuꞌn. Me toj toxin qꞌij, bꞌeꞌxtaq tuꞌn tjatz anqꞌin juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Me bꞌeꞌx ex telsin Pegr tjunalx, ex ok tentz qꞌol tumil te Jesús: WAjaw, nlay taqꞌ te Diosjo ikyjo. Nlay bꞌajte ikyjo tiꞌjach. ");
INSERT INTO mamC_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Me bꞌeꞌx ajtz meltzꞌaj Jesús tiꞌj Pegr, ex xi tqꞌmaꞌn te: ¡Pegr! Ayetziꞌn tyola ikyjo, tyol tajaw il, quꞌn a taj tajaw iljo tuꞌn tbꞌantjo kyaj xjal, ex nya a taj Dios. ¡Laqꞌemila nkꞌatza, tajaw il! Quꞌn ma tzꞌoka te jun tolsbꞌil, tuꞌn nkubꞌ tzꞌaqach. ");
INSERT INTO mamC_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tbꞌajlinxiꞌ ikyjo, tzaj tqꞌmaꞌn Jesús qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin: Ankye jun taj tuꞌn tok te nxnaqꞌtzbꞌiꞌn, il tiꞌj tuꞌn tel tiꞌn toj tkꞌuꞌj tkyaqil tajbꞌil, ex tuꞌn t-xi tqꞌoꞌn tibꞌ, tuꞌn t-xi lipe wiꞌja toj tkyaqil, exla qa ma kyim twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ikytziꞌn, ankyeꞌ taj noq tuꞌn tkubꞌ tbꞌinchin tajbꞌil tzaluꞌn twutz txꞌotxꞌ, kxeꞌl toj najin te jun majx. Ex ankyeꞌ kꞌwel ttzyuꞌn tibꞌ tiꞌj tkyaqiljo at tajbꞌin kyexjal tzaluꞌn twutz txꞌotxꞌ, noq tuꞌn npaja, ktenbꞌil tchwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Quꞌn ¿tiꞌxsila tajbꞌin tuꞌn tkanbꞌit tkyaqiljo ajbꞌil tzaluꞌn twutz txꞌotxꞌ, exsin tuꞌn tnaj tanmin? ¿Ma akutzin tzꞌok tkyaqil tqꞌinimil te klol tanmin? ");
INSERT INTO mamC_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Quꞌn tzul kanin jun qꞌij tuꞌn wula, ayiꞌn Tkꞌwal Ichin, tukꞌa tkyaqil tqoptzꞌajiyil nMaꞌn ex kyukꞌa jniꞌ angel. Ex kxel nqꞌoꞌn chojbꞌil teyile junjun, tzeꞌnkuxjo ntqanin kybꞌinchbꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Twutzxix kxel nqꞌmaꞌn kyeꞌy, at junjun iteꞌ tzaluꞌn wukꞌiy, mi kyli kyimin, tzmaxiꞌ aj kylonte aj wula, a ayiꞌn Tkꞌwal Ichin, kawil tibꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tbꞌajlinxiꞌ qaq qꞌij, xi tkꞌleꞌn Jesús Pegr tukꞌa Santyaw ex Juan, a kyitzꞌin kyibꞌ, exsin i xiꞌtz tzma twiꞌ jun ma tij wutz. ");
INSERT INTO mamC_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Antza kywutzxjo t-xnaqꞌtzbꞌin, txꞌixpit kaꞌyin Jesús. Ox qoptzꞌajx wen tzeꞌnku qꞌij, exsin t-xbꞌalin manyor sjanin wen, tzeꞌnku tqan tzaj ntilkꞌaj wen. ");
INSERT INTO mamC_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Texjo paq anetziꞌn, xi kykaꞌyin Moisés ex Elías nchi yolintaq tukꞌa Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Xi tqꞌmante Pegr te Jesús: WAjaw, tbꞌanilx teꞌ otoꞌ tzaluꞌn. Qa taja tuꞌn tkubꞌ nbꞌinchiꞌn oxe tal pach; jun te, ex jun te Moisés, ex jun te Elías. ");
INSERT INTO mamC_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tzmataq nyolin Pegr, tej tkubꞌ juktzꞌaj jun muj ntilkꞌaj wen kyibꞌaj. Ex tojjo muj etz yolin jun tqꞌajqꞌojil, ex tqꞌma: Axixpen wejiꞌy Nkꞌwal lo kꞌuꞌjlinxix wuꞌn, a o jaw nskꞌoꞌn. ¡Kybꞌinkujiꞌy Tyol! ");
INSERT INTO mamC_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tej kybꞌin teꞌ t-xnaqꞌtzbꞌin ikyjo, bꞌeꞌx i bꞌaj kubꞌ mutzqꞌaj twutz txꞌotxꞌ tuꞌn kyxobꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Me tzaj laqꞌe Jesús kykꞌatz, ex i ok tyekin, ex xi tqꞌmaꞌn kye: Chi weꞌksa. Mi chi xobꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Atzaj teꞌ kyjaw kaꞌyin oꞌkxtaql Jesús attaql, mixtaq aꞌl juntl at tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kyjaꞌtaq kykuꞌtz twiꞌ wutz, xi tqꞌmaꞌnxix Jesús kye: Mix aꞌl qe kxele kyqꞌmaꞌnjiꞌy, a ma kyliꞌy, tzmaxiꞌ aj njatz anqꞌiꞌn, a ayiꞌn Tkꞌwal Ichin, kyxol kyimnin, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Me xi kyqanin t-xnaqꞌtzbꞌin te Jesús: ¿Tzeꞌntzin ttentz nkyqꞌmaꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil, qa ataq Elías tuꞌn tul nej twutza? ¿Nyapela tiꞌjjo lo nchi yolinetaq, a ma qliꞌy? ");
INSERT INTO mamC_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Me xi ttzaqꞌwin Jesús: Twutzx teꞌ. Ate Elías tuꞌntaq tul nej, tuꞌntzintla noq bꞌinchil kytenxjal, aj wula. ");
INSERT INTO mamC_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Me kxel nqꞌmaꞌn kyeꞌy, o tzul te Elías, me mi s-el kynikyꞌxjal te. Ex ma tzikyꞌx tuꞌn, tzeꞌnkuxtaq kyajxjal tiꞌj. Exsin ikyx wejiꞌy, a ayiꞌn Tkꞌwal Ichin, nimx kkyꞌelix wuꞌn toj kyqꞌobꞌxjal. ");
INSERT INTO mamC_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bꞌeꞌxsin el kynikyꞌtzjo t-xnaqꞌtzbꞌin te, qa tiꞌjtaq Juan, a Jawsil Aꞌ, nyoline Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tej kymeltzꞌaj twiꞌ wutz, i pon jaꞌ iteꞌtaq txqan xjal. Ex tzaj laqꞌe jun ichin tkꞌatz Jesús, ex kubꞌ meje twutz, ex xi tqꞌmaꞌn te: ");
INSERT INTO mamC_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tata, qꞌaqꞌintz tkꞌuꞌja tiꞌj nkꞌwala. Quꞌn atku ntzaj luꞌlin tiꞌj, tuꞌn jun taqꞌnil tajaw il, ex nimx kyixkꞌoj ma tzikyꞌx tuꞌn. Ilaꞌku maj o txi lankꞌaj tuꞌn toj qꞌaqꞌ ex toj aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma tzul win wetza kywutz t-xnaqꞌtzbꞌiꞌn, me mi ma qꞌanit-x kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Me tzaj ttzaqꞌwin Jesús qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin: ¡Ay! tal xjal ntiꞌx kynimbꞌila, ex ntiꞌx kyumila. ¿Jteꞌxsin qꞌij nkubꞌlin teꞌn kyxola? ¿Ex jteꞌxsin qꞌij kkyꞌelix wuꞌn kyukꞌiy? Kyintzinjiꞌy qꞌa tzaluꞌn, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bꞌeꞌxsin ok tilin Jesúsjo taqꞌnil tajaw il, ex bꞌeꞌx etz tlajoꞌn toj tanminjo qꞌa, ex texjo tqan tel weꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Atzaj teꞌ tok qchmon qibꞌa qjunalxa, exsin xi qqanintza te Jesús: ¿Tiquꞌn mi xbꞌant qe qlajoꞌn teꞌ taqꞌnil tajaw il toj tanminjo qꞌa? ");
INSERT INTO mamC_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tzaj ttzaqꞌwin Jesús: Quꞌn tuꞌntziꞌn noq chꞌin kynimbꞌila wiꞌja. Twutzxix kxel nqꞌmaꞌn kyeꞌy, noqit at kynimbꞌila wiꞌja iꞌchaqxpetla kyintzjo tzeꞌnku jun tal twutz mistas, akutla txi kyqꞌmaꞌn te wutz lo: Ku tela tzaluꞌn, ex ku txiꞌy tzachiꞌn. Ex bꞌeꞌxitla aku tzikyꞌ. Quꞌn ntiꞌxitla jun tiꞌ nlay bꞌant kyuꞌn, noqit at kynimbꞌila wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Me aye wiq taqꞌnil tajaw il lo nlay chi ex noq tuꞌn kukxjo, qalaꞌ il tiꞌj tuꞌn tkubꞌ kypaꞌn waꞌyaj toj naꞌj Dios. ");
INSERT INTO mamC_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Qikyꞌlinxiꞌy antza, ex nqo bꞌettaqa junx toj txꞌotxꞌ te Galiley, tzaj tqꞌmaꞌn Jesús qeꞌy: Ayiꞌn, a Tkꞌwal Ichin, kchin xel kꞌayiꞌn kyexjal ");
INSERT INTO mamC_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","tuꞌn nkubꞌ bꞌyoꞌn. Me tbꞌajlinxi oxe qꞌij nkyimliꞌn, kchin jawil anqꞌiꞌn juntl majla kyxol kyimnin. Tej qbꞌintiy tqanil ikyjo, bꞌeꞌx o jaw bꞌisiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Atzaj teꞌ qkaniꞌn junx tukꞌa Jesús toj tnam Capernaum, ayetziꞌn peyil pwaq te ja te naꞌbꞌl Dios i tzaj laqꞌe tkꞌatz Pegr, ex xi kyqanin te: ¿Ma mitzin nchojiꞌn t-xnaqꞌtzila pwaq te mojbꞌil toj qja te naꞌbꞌl Dios? ");
INSERT INTO mamC_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tzun, chi Pegr. Atzaj teꞌ tokx Pegr tuja, jaꞌ taꞌtaq Jesús, ok tyolin Jesús nej, ex xi tqanin te: Ay Simun, ¿Tiꞌtzin chꞌin te ntqꞌmaꞌn? Aye kawil tzaluꞌn twutz txꞌotxꞌ kukx nchi peyin pwaq te mojbꞌil. ¿Me altzila kye qe nchi chojin? ¿Ayepelaꞌ kykꞌwalku, mo qa ayeꞌ noq xjalqexa? ");
INSERT INTO mamC_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Xi ttzaqꞌwin Pegr: Ayeꞌ jniꞌ noq xjalqexa, chi Pegr. Ex xi tqꞌmaꞌn Jesús te: ¡Ikytziꞌn! Quꞌn ayetziꞌn kꞌwalbꞌaj ntiꞌ kykꞌas twutz kawil. Ikytzintlaꞌ qetz ntiꞌtla tuꞌn qchojinqe pwaq te mojbꞌil tiꞌj ja te naꞌbꞌl Dios, quꞌn Tkꞌwal Diosqo. ");
INSERT INTO mamC_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Me noq tuꞌn mi tzajeku kyqꞌoj, okla qo chojil. Tuꞌnpetziꞌn, ku txiꞌy toj nijabꞌ. Kꞌaꞌ kux t-xonjiꞌy bꞌaq te tzuybꞌil kyiẍ. Atzin tnejil kyiẍ ktzyetil tuꞌn, kꞌaꞌ kux tjyoꞌn toj ttzi, ex kjyetil jun pwaq tuꞌn antza. Kꞌaꞌ txi tiꞌn te chojbꞌil te weꞌ ex tey, quꞌn atzin pwaq kꞌaꞌ tzꞌajbꞌin te qkabꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tojxjo maj anetziꞌn, o tzaj laqꞌeꞌy, a awoꞌy t-xnaqꞌtzbꞌin, tkꞌatz Jesús, ex xi qqaniꞌn te: ¿Ankyexixtl nim toklin toj Tkawbꞌil Dios toj kyaꞌj? ");
INSERT INTO mamC_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tzaj ttxkoꞌn Jesús jun tal kꞌwal, ex kubꞌ twaꞌbꞌin qxola, ");
INSERT INTO mamC_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ex tzaj tqꞌmaꞌn: Twutzxix kxel nqꞌmaꞌn kyeꞌy, qa mi s-ok kyanmiꞌn tzeꞌn tanminjo tal kꞌwal lo, a manyor tal mutxin, nlayxpen chi okxtza toj Tkawbꞌil Dios toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tuꞌnpetziꞌn, atzin te nim tokliꞌn toj Tkawbꞌil Dios, a kꞌwel tmutxsin tibꞌ tzeꞌnku tal kꞌwal lo. ");
INSERT INTO mamC_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tuꞌnpetziꞌn, ankye kxel kꞌmonte jun tal kꞌwal tzeꞌnku lo, noq tuꞌn tnimbꞌil tiꞌj nbꞌiꞌy, nyakuj ayiꞌn kchin xel tkꞌmoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Noq alkye jun xjal ntjyoꞌn tumil tzeꞌn tten, tuꞌn tel tpaꞌn jun tal kꞌwal tibꞌ tiꞌj tnimbꞌil wiꞌja, junxpetla tzꞌele te te, tuꞌn tok kꞌlet jun ma tij abꞌj te chebꞌl triy tiꞌj tqul, ex tuꞌn t-xi t-xoꞌn tibꞌ toj aꞌ, tuꞌn tkyim te jun majx, tzeꞌnkuljo tuꞌn tokx toj paꞌbꞌin twutz Dios tukꞌaꞌ til ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ay! Ntiꞌx kyajbꞌin xjal aj il twutz txꞌotxꞌ, a ipbꞌilxix iteꞌke tuꞌn kykubꞌ tzꞌaq txqantl toj il. Kxel nqꞌmaꞌn kyeꞌy, kukx at te iljo tzaluꞌn twutz txꞌotxꞌ, me nim bꞌisbꞌajil texjal, a tzunx nlabꞌte kyiꞌjjo txqantl, tuꞌn kykubꞌ tzꞌaq toj il. ");
INSERT INTO mamC_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tuꞌnpetziꞌn, qa noq tuꞌn tpaj jun tqꞌobꞌa mo jun tqan, aku kubꞌ tzꞌaqiy toj il, bꞌantla tuꞌn tel ttxꞌemiꞌn, ex qꞌimila toj tkꞌuꞌja te jun majx. Quꞌn wenitla tuꞌn tokxa toj kyaꞌj noq tukꞌa jun tqꞌobꞌa mo jun tqan, tzeꞌnkul teꞌ, tuꞌn t-xiꞌy kyukꞌa kykabꞌil toj qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ex qa noq tuꞌn tpaj tbꞌaqꞌ twutza aku kubꞌ tzꞌaqiy toj il, qꞌimitza, ex qꞌimila toj tkꞌuꞌja te jun majx. Quꞌn bꞌantla tuꞌn tokxa toj kyaꞌj noq tukꞌa jun twutza, tzeꞌnkul teꞌ, tuꞌn txiꞌy kyukꞌa kykabꞌil toj qꞌaqꞌ, a mixla k-yupjilx. ");
INSERT INTO mamC_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mi chi el kyikyꞌinjiꞌy tal muchꞌqe lo. Quꞌn twutzx kxel nqꞌmaꞌn kyeꞌy, loqe ky-angel majx iteꞌ yolil kyiꞌj twutz nMaꞌn toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ex ayiꞌn, a Tkꞌwal Ichin, skꞌoꞌnxix tuꞌn Dios, ma chin ula kolil kyiꞌjjo tal kꞌwal, ex kyiꞌjjo a otaq chi naj toj il. ");
INSERT INTO mamC_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Tzeꞌntzin chꞌin kye toj kywutz? Qa at jun xjal at jweꞌ kꞌal trit, ex qa ma kyij naj jun, ¿Ma nyapela kchi kyjel tqꞌoꞌn bꞌeljajlajaj toj jweꞌ kꞌal twiꞌ wutz, exsin kxeꞌltz jyol teꞌ a otaq kyij naj? ");
INSERT INTO mamC_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Exsin qa aku xknet tuꞌn, twutzxix kxel nqꞌmaꞌn kyeꞌy, maꞌxla tzalajx tiꞌjjo jun tzeꞌnqekuljo bꞌeljajlajaj toj jweꞌ kꞌal, a mi ẍi kyij naj. ");
INSERT INTO mamC_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ikytziꞌn te kyTatajiꞌy, a at toj kyaꞌj. Nya taj tuꞌn tnaj jun kyeꞌ, exla qa jun tal muchꞌ kꞌwal tzeꞌnku lo. ");
INSERT INTO mamC_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Qa ma kubꞌ tbꞌinchin jun nimil jun tiꞌ tiꞌja, a nya bꞌaꞌn, ku txiꞌy yolil tukꞌa tjunalx. Qꞌmanxa te, tiꞌ xbꞌajte tiꞌja. Qatzin qa ma kubꞌ tbꞌiꞌntz, atpenl kymujbꞌil kyibꞌtza tukꞌa juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Me qatzin qa mi xkubꞌ tbꞌiꞌnxtz, kꞌleꞌnx juntl tukꞌiy mo kabꞌetl, tuꞌntzin kyok te tstiyil, quꞌn ikyxjo ntqꞌmaꞌn toj Tuꞌjil Tyol Dios, qa il tiꞌj tuꞌn kyok kabꞌe mo oxe tstiyil, tuꞌntzin kywutzku kbꞌajileꞌ yol. ");
INSERT INTO mamC_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Qatzin ikyxl xbꞌantjo tuꞌn, qꞌmaꞌnxa te tkyaqil Ttanim Dios. Ex qa mi xkubꞌ tbꞌiꞌnx kyyol tkyaqil Ttanim Dios, kyqꞌonka tzeꞌnku jun nya nimil, mo tzeꞌnku jun peyil pwaq, a iꞌjlemil kyuꞌnxjal. ");
INSERT INTO mamC_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ex twutzxix kxel nqꞌmaꞌn kyeꞌy, qa ma kotpitjo xjal tuꞌn toj kyil, noq tuꞌn ktqꞌmaꞌbꞌila tzaluꞌn twutz txꞌotxꞌ, ex aj kyok toj paꞌbꞌin twutz Dios toj kyaꞌj, kchi kotpajil te jun majx. Ex qa mi xi kynimin a ktqꞌmaꞌbꞌila, ma chi kꞌlet tuꞌn kyil tzaluꞌn twutz txꞌotxꞌ, ex aj kyok toj paꞌbꞌin twutz Dios toj kyaꞌj, kchi xel toj najin te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ex ikyxjo kxel nqꞌmaꞌn kyeꞌy, qa at kabꞌe kye tzaluꞌn twutz txꞌotxꞌ, xbꞌant tiꞌj tuꞌn, tuꞌn t-xi kyqanin te nTatiꞌy toj naꞌj Dios jun tiꞌ, aꞌlchaqx kye kyajtza, ex ktzajil qꞌoꞌn kyeꞌy tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Quꞌn jaꞌ nkychmome kabꞌe mo oxej kyibꞌ tiꞌj tumil nbꞌiꞌy, loqiꞌn intin kyxol, chi Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Atzin te Pegr xi laqꞌe, ex xi tqanin te Jesús: WAjaw, ¿Jteꞌ maj kꞌwel nnajsin til jun wukꞌiy, qa ma kubꞌ tbꞌinchin jun nya wen wiꞌja? ¿Ma noqpela wuq maj? ");
INSERT INTO mamC_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Me xi ttzaqꞌwin Jesús te: Nya noq oꞌkxjo wuq maj, qalaꞌ wuq majjo lajaj toj jun mutxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tuꞌnpetziꞌn, a Tkawbꞌil Dios toj kyaꞌj, ikytziꞌn tzeꞌnku jun kawil tajtaq tuꞌn tpeyin kykꞌas taqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Atzaj teꞌ tok ten bꞌinchilte lo, attaq jun, ma ninxtaq txqan tkꞌas. ");
INSERT INTO mamC_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Me ntiꞌtaqx tumil tzeꞌn tten tuꞌn tchjet tuꞌn. Atziꞌn kubꞌ tbꞌisin tajaw kꞌas, tuꞌn t-xi kꞌayit te aqꞌnil te jun majx kyexjal, me tukꞌax t-xuꞌjil ex kyukꞌax tkꞌwal ex tkyaqiljo jniꞌ attaq te, tuꞌntzintla tchjetjo tkꞌas. ");
INSERT INTO mamC_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Me atziꞌn aqꞌnil kubꞌ meje twutz kawil, ex ja kubꞌsin twutz te: Tata, qꞌaqꞌintz tkꞌuꞌja wiꞌja. Ok chjetil weꞌ wuꞌn tkyaqilx, noq tuꞌn chebꞌeku. ");
INSERT INTO mamC_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bꞌeꞌx tzaj qꞌaqꞌin tkꞌuꞌj kawil tiꞌj, ex bꞌeꞌx kubꞌ tnajsin tkꞌas te jun majx; ex bꞌeꞌx xi ttzaqpiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Me aꞌkxtaq tetzjo aqꞌnil, tej tel knet jun tukꞌa tuꞌn, a kꞌasbꞌinintaq twutz noq jun tal jteꞌbꞌin pwaq. Me tzaj ttzyuꞌn tukꞌa tqul, ex ok tẍpoꞌn, ex xi tqꞌmaꞌn te: Chjomjiy tkꞌasa weꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Me antej kꞌasbꞌine kubꞌ meje, ex ja kubꞌsin twutz te: Qꞌaqꞌintz tkꞌuꞌja wiꞌja. Ok chjetil weꞌ wuꞌn tkyaqilx, noq tuꞌn chebꞌeku. ");
INSERT INTO mamC_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Me mix ttziye ikyjo. Bꞌeꞌx xiku tiꞌn, tuꞌn tkux jpet toj tze, tzmaxi tuꞌn tjatzjo, ajxi tchjet tuꞌn tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tej tok kykaꞌyin txqantl aqꞌnil ikyjo, bꞌeꞌx tzaj chyoꞌn kyanmin tiꞌj. Bꞌeꞌx i xiꞌ qꞌmalte te kawil tkyaqiljo otaq bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bꞌeꞌxsin xi tqꞌmaꞌn kawil, tuꞌn ttzaj txketjo tnejil aqꞌnil, ex xi tqꞌmaꞌn te: Ay aqꞌnil manyor aj ilxa. Ma kubꞌ nnajsin weꞌ tkyaqil tkꞌasa, noq tuꞌn xkubꞌ mejey nwutza. ");
INSERT INTO mamC_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ikytzintla tejiy matla tzaj qꞌaqꞌin tkꞌuꞌja tiꞌj tukꞌiy, tzeꞌnku weꞌ saj qꞌaqꞌin nkꞌuꞌja tiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bꞌeꞌx tzajx txqan tqꞌojjo kawil tiꞌj, ex xi tqꞌmaꞌn, tuꞌn t-xi qꞌoꞌn toj kyqꞌobꞌjo xqꞌuqil tze, ex tuꞌn tbꞌaj bꞌyoꞌn, ex tzmaxi tuꞌn tjatzjo, aj tchjet tkꞌas tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Atzaj teꞌ tbꞌaj yolin Jesús tiꞌjjo techil lo, xi tqꞌmaꞌn: Ikytziꞌn kchi tenbꞌilajiꞌy tuꞌn nTatiꞌy toj kyaꞌj, qa mina xkubꞌ kynajsiꞌn til jun kyukꞌiy tukꞌa tkyaqil kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tej tbꞌaj tqꞌmaꞌn Jesúsjo yol lo, bꞌeꞌx etz toj txꞌotxꞌ Galiley, tuꞌn tkanin toj txꞌotxꞌ Judey, jlajxi Nim Aꞌ Jordán. ");
INSERT INTO mamC_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nimku xjal ok lipe tiꞌj, ex antza i qꞌanite nim yabꞌ tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ex at junjun Parisey tzaj laqꞌe tkꞌatz Jesús, noq tuꞌn tkubꞌ tzꞌaq kyuꞌn toj til. Xi kyqanin te: ¿Wenpetzila tuꞌn tkubꞌ tpaꞌn jun ichin tibꞌ tukꞌa t-xuꞌjil, qa noq tiꞌ s-etza til? ");
INSERT INTO mamC_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Xi ttzaqꞌwin Jesús: ¿Ma naꞌmxsin tkux kyuꞌjiꞌn toj Tuꞌjil Tyol Dios, qa te tnejil, kubꞌ tbꞌinchin Dios ichin ex qya? ");
INSERT INTO mamC_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ex ikyxjo tqꞌma: Tuꞌnpetziꞌn, kyjel ttzaqpiꞌn te ichin ttata ex tnana, noq tuꞌn tok meje tukꞌa t-xuꞌjil. Ex kykabꞌilx kchi okil te junchꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nya kabꞌel kyten, qalaꞌ junchꞌin. Tuꞌnpetziꞌn, nlay tzꞌel tpaꞌn te xjaljo, a s-ok tmujbꞌin Dios. ");
INSERT INTO mamC_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Xi kyqanin juntl majl: ¿Tzeꞌntzin tten te Moiséstz ttziye, tuꞌn t-xiꞌ jun uꞌj te qya, jaꞌ ntqꞌmaꞌne qa o paꞌyit tukꞌa tchmil? ");
INSERT INTO mamC_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Xi ttzaqꞌwin Jesús: Noq tuꞌn tpajjo manyor kujx kyanmiꞌn ja xi ttziyin Moisés, tuꞌn tkubꞌ tpaꞌn ichin tibꞌ tukꞌa t-xuꞌjil. Me me teꞌ te tnejil, nya iky teꞌ tten. ");
INSERT INTO mamC_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy, qa ma kubꞌ tpaꞌn ichin tibꞌ tukꞌa t-xuꞌjil, qa nya noq tuꞌn tpaj kyꞌaꞌjin tuꞌn qya, exsin qa ma tzꞌok meje tukꞌa juntl, ma tzꞌok aj kyꞌaꞌjil. Ex ankye k-okil meje tukꞌa qya, a o tzꞌel lajoꞌn tuꞌn tchmil, ex ikyxjo, k-okil aj kyꞌaꞌjil. ");
INSERT INTO mamC_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Me awotzin qeꞌ, a t-xnaqꞌtzbꞌin xi qqꞌmaꞌn: Qa iky tten jun ichin tukꞌa t-xuꞌjiltz, bꞌaꞌnpetlatz tuꞌn mi mejeye ichin. ");
INSERT INTO mamC_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Me ante Jesús tzaj tqꞌmaꞌn qeꞌy: Nya tkyaqilx ma tzaj qꞌoꞌn toklin tuꞌn mi mejeye; qalaꞌ oꞌkqexjo ma tzaj tqꞌoꞌn Dios kyoklin ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Quꞌn ilaꞌku tumil, tiquꞌn nlay meje jun ichin: At junjun, titzꞌjlinxjo ikyjo; at junjuntl noq kyuꞌnxjal; ex at junjuntl ma txi kyqꞌoꞌn kyibꞌ, tuꞌn mi chi mejeye noq tuꞌn tpajjo ma txi kyqꞌoꞌnx kyibꞌ tukꞌa tkyaqil kyanmin toj aqꞌuntl te Tkawbꞌil Dios, a at toj kyaꞌj. Qa at jun aku bꞌantjo ikyjo tuꞌn, bꞌaꞌn tuꞌn tkubꞌ tbꞌinchin. ");
INSERT INTO mamC_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tbꞌajlinxiꞌ ikyjo, i bꞌaj tzaj kyiꞌnxjal junjun tal kꞌwal tkꞌatz Jesús, tuꞌn tkubꞌ tqꞌoꞌn tqꞌobꞌ kyibꞌaj tuꞌn kykubꞌ tkyꞌiwlin, ex tuꞌn tnaꞌn Dios kyiꞌj. Me awotzin qeꞌ, a t-xnaqꞌtzbꞌin, o ok teꞌn yisol kyeꞌ, a i tzaj qꞌiꞌn kyeꞌ tal kꞌwal. ");
INSERT INTO mamC_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Me tzaj tqꞌmaꞌn Jesús qeꞌy: Kytzaqpinqetzjiꞌy tal kꞌwal, tuꞌn kybꞌaj tzaj laqꞌe nkꞌatza. Mi chi kubꞌ kymeqoꞌn, quꞌn kykyaqiljo kꞌwel kymutxsin kyibꞌ tzeꞌnqe tal kꞌwal lo, ayepen kye kchi okixjo toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tej tbꞌaj tkyꞌiwlin Jesúsjo tal kꞌwal, bꞌeꞌx ex tojjo txꞌotxꞌ antza. ");
INSERT INTO mamC_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tej t-xiꞌ Jesús qukꞌiy, ul kanin jun kuꞌxin tkꞌatz, ex xi tqanin te: Ay, xnaqꞌtzil wenxixa, ¿Tiꞌn kꞌwel nbꞌinchiꞌn, tuꞌn nkanbꞌintejiy chwinqil te jun majx? ");
INSERT INTO mamC_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Xi ttzaqꞌwin Jesús: ¿Tiquꞌn ntzaj tqꞌmaꞌn qa wenqiꞌn? Ntiꞌx jun te xjal wen tzaluꞌn twutz txꞌotxꞌ, qalaꞌ oꞌkx te Dios. Me qa taja tuꞌn tten tchwinqila te jun majx, niminqekutzinjiy ojtxe kawbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ex xi ttzaqꞌwin qꞌinin: ¿Me ankyeqe kawbꞌil? Xi tqꞌmaꞌn Jesús te: Mi bꞌiyin. Mi kyꞌaꞌjin. Mi tzꞌelqꞌin. Mi jaw bꞌant yol tiꞌj jun aꞌla noq kukxjo. ");
INSERT INTO mamC_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Niminkujiy ttatiy ex tnaniy. Ex kꞌuꞌjlinqekjiy tukꞌiy tzeꞌnkuxjo ntkꞌuꞌjlin te tibꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Xi tqꞌmaꞌn kuꞌxin: Tkyaqilx teꞌ anetziꞌn o bꞌant wuꞌn. ¿Tiꞌtzin atx taj tuꞌn tkubꞌ nbꞌinchiꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Xi tqꞌmaꞌn Jesús te: Qa taja tuꞌn toka tzꞌaqlexix, ku txiꞌy, ex kꞌayinxjiy jniꞌ at tey, ex oyinxjiy tpwaqa kye yaj. Ikytzin ktenbꞌile tqꞌinimiljiy toj kyaꞌj. Exsin lipektza wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Me atzaj teꞌ tbꞌinte kuꞌxin ikyjo, jaw bꞌisinx, quꞌn tuꞌn manyor qꞌininxtaq; ex bꞌeꞌx aj tja. ");
INSERT INTO mamC_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ante Jesús tzaj tqꞌmaꞌn qeꞌy: Twutzxix kxel nqꞌmaꞌn kyeꞌy: Kujx teꞌ, tuꞌn tokx jun qꞌinin toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kxel nqꞌmaꞌn juntl majl kyeꞌy: Jun paqxla aku tzꞌex jun chej toj toyajil jun bꞌaq te slepbꞌil bꞌuꞌẍ, tzeꞌnkul teꞌ tuꞌn tokx jun qꞌinin toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Atzaj teꞌ qbꞌintiy ikyjo, bꞌeꞌx o jaw kaꞌylaja, ex xi qqaniꞌn te: Qa nlay chi okx qꞌinin toj kyaꞌj, ¿Yajtzilaꞌ qetza? ¿Altzila kye k-okixtz? ");
INSERT INTO mamC_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","O tzaj tkaꞌyiꞌn Jesús, ex tzaj tqꞌmaꞌn qeꞌy: Nlay bꞌant tuꞌn kyklet-xjal kyuꞌnx kyibꞌx. Me mete Dios kbꞌantil teꞌ tuꞌn tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Me xi tqꞌmaꞌn Pegr te: Ma kyij qtzaqpiꞌn qeꞌ tkyaqiljo attaq qeꞌy, ex ma qo ok lipeꞌy tiꞌja. ¿Tiꞌtzila qetza qkanbꞌe? ");
INSERT INTO mamC_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Xi tqꞌmaꞌn Jesús: Twutzxix kxel nqꞌmaꞌn kyeꞌy, toj tqꞌijil, a jaꞌ ktxꞌixpitile tkyaqil, aj nkubꞌ qey ayiꞌn, a Tkꞌwal Ichin, tibꞌaj nqꞌuqbꞌila, tukꞌa tkyaqil nqoptzꞌajiyila, ex ayetzin kyeꞌ, tuꞌn ma chi ok lipeꞌy wiꞌja, ex kchi kꞌwel qey kyibꞌaj kabꞌlajaj qꞌuqbꞌil, tuꞌn kykawiꞌn kyibꞌaj kabꞌlajaj chꞌuq xjal te tyajil Israel. ");
INSERT INTO mamC_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ex kykyaqilxjo jniꞌ ma kyij kytzaqpiꞌn kyja, kyitzꞌin, kyanebꞌ, kytata, kynana, kyxuꞌjil, mo kykꞌwal, mo qa kytxꞌotxꞌj, noq tuꞌn npaja, okpin kykanbꞌil kyeꞌ jweꞌ kꞌal maj kyxel tibꞌaj tkyaqiljo anetziꞌn, ex jun chwinqil te jun majx toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Me nimx jaꞌlin iteꞌk te tnejil tzaluꞌn twutz txꞌotxꞌ, me kchi kyjel te tchꞌibꞌil, qa ntiꞌ kynimbꞌil. Ex nimx ntiꞌ kyoklin tzaluꞌn twutz txꞌotxꞌ jaꞌlin, me kchi okil te tnejil noq tuꞌn kynimbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Xi tqꞌmaꞌn Jesús: A Tkawbꞌil Dios toj kyaꞌj, ikytziꞌn tzeꞌnku jun tajaw aqꞌuntl; xiꞌ qlixje wen toj plas jyol taqꞌnil, tuꞌn kyxiꞌ aqꞌnil toj tqan uv. ");
INSERT INTO mamC_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","I kyijku bꞌant kyukꞌa, tuꞌn t-xi chjet jun pwaq twiꞌ kykꞌuꞌj junjun qꞌij, exsin i xi tchqꞌoꞌntz tzma toj ttxꞌotxꞌ, tuꞌn kyaqꞌnin. ");
INSERT INTO mamC_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tej t-xiꞌ tajaw aqꞌuntl juntl majl, otaq tzꞌok bꞌeljaj or te qlixje, ex i ok tkaꞌyin txqantl xjal iteꞌtaq toj plas, ntiꞌtaq kyaqꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xi tqꞌmaꞌn kye: Ikyqex kyejiꞌy, ku kyxiꞌy aqꞌnil toj tqan wawala, ex kxel nchjoꞌn twiꞌ kykꞌuꞌja toj tumil tzꞌaqle. ");
INSERT INTO mamC_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ex bꞌeꞌx i xiꞌ kyej xjal aqꞌnil. Ante tajaw aqꞌuntl xiꞌ juntl majl, te tok nikyꞌjin qꞌij, ex teꞌ tok oxe or te qale, ex i bꞌaj xi tchqꞌoꞌn txqantl aqꞌnil toj aqꞌuntl. ");
INSERT INTO mamC_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Atzaj teꞌ tok jweꞌ or te qale, xiꞌ juntl majl toj plas. I knet junjuntl tuꞌn antza, ntiꞌ kyaqꞌin, ex xi tqꞌmaꞌn kye: ¿Tiquꞌn iteꞌy tzaluꞌn, a ma tzꞌex qꞌij, ex ntiꞌ chꞌin ma chi aqꞌniꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Me ankyeꞌ xjal xi kyqꞌmaꞌn: Quꞌn mix aꞌl jun ma tzaj qꞌmante qaqꞌiꞌn. Ex xi tqꞌmaꞌn ichin kye: Ku kyxiꞌy aqꞌnil toj wawala, ex kꞌaꞌ txi nchjoꞌn twiꞌ kykꞌuꞌja toj tumil tzꞌaqle. ");
INSERT INTO mamC_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Atzaj teꞌ qok yupj, xi tqꞌmaꞌn tajaw aqꞌuntl te nejinel kye aqꞌnil: Txkonqetzjiy aqꞌnil jaꞌlin, ex chjonxa twiꞌ kykꞌuꞌj. Antza xi xkyeye kyukꞌa i pon qalexi, tuꞌn tpon bꞌaj kyukꞌa i bꞌaj kanin qlixje. ");
INSERT INTO mamC_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","I bꞌaj tzaj laqꞌe aye, a oꞌkx jun or i aqꞌnin, ex teyile junjun xi ttzyuꞌn jun pwaq te twiꞌ kykꞌuꞌj, nyakutlaj otaq tzꞌex kyqꞌij tuꞌn kyaqꞌnin. ");
INSERT INTO mamC_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tej kybꞌaj pon chojbꞌaj kyeꞌ, a bꞌeꞌx i bꞌaj okx aqꞌnin qlixje, kubꞌ kybꞌisin qa nimxixtaq chꞌintl kypwaq tuꞌn ttzaj kytzyuꞌn, quꞌn tuꞌn bꞌeꞌx i okx aqꞌnil liwey. ");
INSERT INTO mamC_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Me atzaj teꞌ tok kykaꞌyin kyinxljo tzeꞌnqekul kyeꞌ, ayeꞌ i ok aqꞌnil yaj, bꞌeꞌx i bꞌaj ja yolin kyxolile, ex xi kyqanin te tajaw aqꞌuntl: ");
INSERT INTO mamC_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","¿Tiꞌn quꞌn kyinx kyeꞌ ẍi bꞌaj ok aqꞌnil yaj twiꞌ kykꞌuꞌj s-ex tzeꞌnkuljo qe, exsin bꞌeꞌx xqo ok qeꞌ qlixje, ex ma tzikyꞌx aqꞌuntl ex tqan qꞌij quꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Me ante tajaw aqꞌuntl xi ttzaqꞌwin: Ay, wukꞌa, me ntiꞌ jun weꞌ nya bꞌaꞌn ma kubꞌ nbꞌinchiꞌn kyiꞌja. Quꞌn ma qo kyijku kyukꞌiy, tuꞌn kyaqꞌniꞌn wukꞌiy tuꞌn jun tal pwaq jun qꞌij. ");
INSERT INTO mamC_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Qalaꞌ kytzyuꞌnxjiꞌy kypwaqa, ex kux chi ajxiy, quꞌn waja tuꞌn kyok nchjoꞌnjiꞌy ayeꞌ yaj ẍi ul aqꞌnil kyinxjo tzeꞌnku kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ma ntiꞌtzin weꞌ woklin tiꞌj npwaqa, tuꞌn tkubꞌ nbꞌinchiꞌn noq alqe wajiꞌy? ¿Mo qa nloꞌchj kyeꞌ kykꞌuꞌj, tuꞌn soꞌjqiꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ex xi tqꞌmaꞌn Jesús: Quꞌn ikytziꞌn, ayetziꞌn ntiꞌ kyoklin kywutzxjal tzaluꞌn twutz txꞌotxꞌ, kchi okil te tnejil. Ex ayetziꞌn iteꞌk te tnejil jaꞌlin, kchi okil te tchꞌibꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tej t-xiꞌ Jesús toj tbꞌe tzma Jerusalén, o xi tkꞌleꞌn a awoꞌy kabꞌlajaj t-xnaqꞌtzbꞌin qjunalxa, ex tzaj tqꞌmaꞌn qeꞌy: ");
INSERT INTO mamC_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ikytziꞌn tzeꞌnku n-ok kykaꞌyiꞌn, chꞌix qjapin Jerusalén, a jaꞌ ayiꞌn, a Tkꞌwal Ichin, kchin xel kꞌayiꞌn kyeꞌ kynejil kypale Judiy exsin kyeꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Kyqꞌmaꞌbꞌil qa ayiꞌn at npaja, noq tuꞌn nkubꞌ bꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kchin kxel kyqꞌoꞌn toj kyqꞌobꞌjo nya aj Judiy, tuꞌn wok xmayiꞌn kyuꞌn, tuꞌn wok kylankꞌiꞌn, ex kchin kꞌwel kybꞌyoꞌn twutz cruz. Me toj toxin qꞌij, kchin jawil anqꞌiꞌntla. ");
INSERT INTO mamC_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tbꞌajlinxiꞌ ikyjo, tzaj laqꞌe tnana Santyaw ex Juan, ayeꞌ tkꞌwal Zebedey, tkꞌatz Jesús junx kyukꞌa tal, ex i kubꞌ meje twutz, ex xi tqanin jun bꞌaꞌn kyiꞌj tal. ");
INSERT INTO mamC_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Xi tqanin Jesús te: ¿Tiꞌtzin tajach? Ante qya xi ttzaqꞌwin: Wajatlaꞌy, tuꞌn kykubꞌ tqꞌuqbꞌin wala toj Tkawbꞌila toj tman qꞌobꞌa ex juntl toj tẍnayaja kawil tukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Me ante Jesús xi ttzaqꞌwin: Mi n-el kynikyꞌa teꞌ ntzaj kyqaniꞌn weꞌy. ¿Ma akutzin tzikyꞌx kyeꞌ kyuꞌn, tkyaqiljo jniꞌ kkyꞌelix wuꞌn? Ex xi kyqꞌmaꞌn Santyaw tukꞌax Juan te: Ok kkyꞌelix qe quꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Xi ttzaqꞌwinl Jesús kye: Twutzx teꞌ, akula tzikyꞌx kye kyuꞌn tzeꞌnku weꞌ kkyꞌelix wuꞌn, me atzin tuꞌn tkubꞌ qe jun kyeꞌ toj nman qꞌobꞌa ex juntl toj nẍnayaja kawil wukꞌiy, nyaqin weꞌ tiꞌj teꞌ; qalaꞌ a nMaꞌn, quꞌn oꞌkxte ojtzqilte ex bꞌilte alqe kxele tqꞌoꞌne. ");
INSERT INTO mamC_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Atzaj teꞌ qbꞌintiy, awoꞌy lajajtl t-xnaqꞌtzbꞌin ikyjo, bꞌeꞌx tzaj qqꞌoja kyiꞌjjo kabꞌel kyitzꞌin kyibꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Me o xi ttxkoꞌn Jesús, ex tzaj tqꞌmaꞌn qeꞌy: Ojtzqiꞌnl kyeꞌ kyuꞌn tzeꞌn kytenxjal nya nimil; quꞌn ayetziꞌn tnejil kawil, qa tiꞌx jun tiꞌ, manyor txꞌuꞌjqex tukꞌa kykawbꞌil, quꞌn nyakuj etzinqe kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Me atzin kyxola, nya iky teꞌ. Qalaꞌ ankye teꞌ taj tuꞌn tok te nim toklin kyxola, il tiꞌj tuꞌn tajbꞌin kye txqantl. ");
INSERT INTO mamC_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ex ankye taj tuꞌn tok te tnejil, il tiꞌj tuꞌn tok tzeꞌnku jun aqꞌnil te jun majx kye txqantl. ");
INSERT INTO mamC_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Quꞌn ikytziꞌn tzeꞌnku weꞌ, ayiꞌn, a Tkꞌwal Ichin, mi ẍin ul weꞌ tuꞌn kyajbꞌinxjal weꞌy; qalaꞌ ayin weꞌ tuꞌn wajbꞌiꞌn kye txqantl, ex tuꞌn t-xi nqꞌoꞌn nchwinqila te kyxel, tuꞌn kyklet te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Atzaj teꞌ kyjaꞌtaq qetza tukꞌa Jesús toj tnam Jericó, nimku xjal ok lipe qiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ex attaq kabꞌe moẍ qꞌuqleqetaq ttzi bꞌe. Tej kybꞌinte tikyꞌ Jesús antza, i jaw ẍchꞌin: Tata, ay tyajil qtzan nmaq kawil David, qꞌaqꞌintz tkꞌuꞌja qiꞌja, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Me bꞌeꞌx i ok iꞌlin kyuꞌn jniꞌ xjal, tuꞌn nchi ẍchꞌin. Me ayetzin kyeꞌ moẍ, noqx kyja i jawe ẍchꞌin kujxix: Tata, ay tyajil qtzan nmaq kawil David, qꞌaqꞌintz tkꞌuꞌja qiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Bꞌeꞌx kubꞌ weꞌ Jesús, i tzaj ttxkoꞌn moẍ, ex xi tqanin kye: ¿Tiꞌn kyaja tuꞌn tok nbꞌinchiꞌn kyiꞌja? ");
INSERT INTO mamC_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tzaj kytzaqꞌwin moẍ te: Ay, Tata, qaja tuꞌn kykaꞌyiꞌn qwutza, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bꞌeꞌx tzaj qꞌaqꞌin tkꞌuꞌj Jesús kyiꞌj, ex ok tmikoꞌn kywutz. Ex texjo paq, tjqet kyej moẍ kywutz, ex bꞌeꞌx i ok lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tej qkaniꞌn tukꞌa Jesús nqayin tkꞌatz Jerusalén, o poꞌn ttxaꞌn jun kojbꞌil Betfagé tbꞌi, nqayin t-xe wutz Olivos. Xi tchqꞌoꞌn Jesús kabꞌe qxola, ");
INSERT INTO mamC_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ex xi tqꞌmaꞌn kye: Ku kyxiꞌy tojjo tal kojbꞌil jlajxi. Antza kjyetila jun tal bur kyuꞌn, kꞌloꞌn tukꞌa tal tal. ¡Kypjumila, exsin kyintza tzaluꞌn! ");
INSERT INTO mamC_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ex qa at jun saj qaninte jun tiꞌ kyeꞌy: At tajbꞌin te qAjaw, me jaꞌlinx tzul quꞌn, chichkujiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bꞌajjo ikyjo, quꞌn iltaq tiꞌj tuꞌn tjapin yol kyij ttzꞌibꞌin yolil Tyol Dios ojtxe, tej tqꞌma: ");
INSERT INTO mamC_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kyqꞌmanxa kye xjal toj tnam Sion: Kykaꞌyinxjiꞌy Nmaq kyKawila tzul; mutxin tten, ex qꞌuqlekx tibꞌaj jun tal bur, kꞌleꞌn tal tal. ");
INSERT INTO mamC_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ayetziꞌn t-xnaqꞌtzbꞌin kubꞌ kybꞌinchin tzeꞌnku xi tqꞌmaꞌn Jesús kye. ");
INSERT INTO mamC_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tzaj kyiꞌn bur tukꞌaxjo tal tal, bꞌaj jax kyqꞌoꞌn kytxoꞌw tibꞌaj, exsin jax qe Jesús tibꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ex bꞌaj kubꞌ kylikyꞌin xjal kytxoꞌw toj tbꞌe, ex txqantl tzaj toqinte t-xaq tze, a palma tbꞌi, ex bꞌaj kubꞌ kylikyꞌin toj tbꞌe tuꞌn kytzaljbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ex ayetziꞌn jniꞌ xjal nejninqetaq exqetziꞌn lipcheqektaq tiꞌj, i ok ten ẍchꞌil: Nimxit tbꞌiy, ay Tyajil qtzan nmaq kawil David. Kyꞌiwlinxita a ay ma tzula toj tbꞌi tAjaw Tkyaqil. Nimxitjo toklin tbꞌiy toj tnajbꞌila. ");
INSERT INTO mamC_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Atzaj teꞌ tokx Jesús toj Jerusalén, bꞌeꞌx i bꞌaj jaw najxjal, ex nimx qꞌmante: ¿Ankye teꞌ xjal lo? ");
INSERT INTO mamC_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Me xi kytzaqꞌwin txqantl: Antej yolil Tyol Dios, a Jesús aj Nazaret, toj txꞌotxꞌ te Galiley. ");
INSERT INTO mamC_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tbꞌajlinxiꞌ ikyjo, okx Jesús toj tnejil ja te naꞌbꞌl Dios, ex i bꞌajetz tlajoꞌn kykyaqiljo jniꞌqe nchi bꞌaj kꞌayintaq exqetziꞌn nchi bꞌaj loqꞌintaq antza. Ex i bꞌaj jaw tpichꞌkin jniꞌ kymeẍjo jniꞌqe nchi bꞌaj txꞌexbꞌintaq kypwaqxjal, ex kykꞌaybꞌiljo jniꞌqe nchi bꞌaj kꞌayintaq palom. ");
INSERT INTO mamC_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ex xi tqꞌmaꞌn kye: Tzꞌibꞌinl teꞌ toj Tuꞌjil Tyol Dios: Atzin njaꞌy k-okil te ja te naꞌbꞌl Dios, me ayetzin kyeꞌ ma tzꞌok kyqꞌoꞌn te kyja ileqꞌch. ");
INSERT INTO mamC_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ex tojxjo tnejil ja te naꞌbꞌl Dios, i bꞌaj tzaj laqꞌe junjun moẍ ex kox tkꞌatz Jesús, ex bꞌeꞌx i bꞌaj kubꞌ tqꞌanin. ");
INSERT INTO mamC_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Me tej tok kykaꞌyiꞌn nejinel kyxol pale, exqetziꞌn jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil, a jniꞌ nimku techil tipin Jesús otaq bꞌant, ex teꞌ tok kybꞌiꞌn jniꞌqe kꞌwal nchi ẍchꞌin toj tnejil ja te naꞌbꞌl Dios: Nimxit tbꞌiy, ay Tyajil qtzan nmaq kawil David, bꞌeꞌx tzaj kyqꞌoj, ");
INSERT INTO mamC_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ex xi kyqꞌmaꞌn te Jesús: ¿Ma tzuntzin tbꞌiꞌnjiy nkyqꞌmaꞌn maꞌ kꞌwal tiꞌja? chi chiꞌ. Xi ttzaqꞌwin Jesús: Tzuntzin. ¿Ma naꞌmxsin tkux kyuꞌjiꞌn toj Tuꞌjil Tyol Dios, a ntqꞌmaꞌn tiꞌjjo lo kyjaluꞌn: Ma tzaj tqꞌmaꞌn, tuꞌn tjaw nimsin tbꞌiy, tuꞌn kybꞌitzjo tal kꞌwal, majxpe kyuꞌn tzma qe nchi miꞌẍin? ");
INSERT INTO mamC_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ex bꞌeꞌx ex Jesús, i bꞌaj kyij ttzaqpiꞌn, ex xiꞌ toj kojbꞌil Betania, jaꞌ ikyꞌxi qnikyꞌin tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Toj juntl qlixje, kyjaꞌtaq qxiꞌy Jerusalén, tzaj waꞌyaj tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ok tkaꞌyin jun tqan iw ttzi bꞌe, ex bꞌeꞌx xiꞌ t-xe tqan. Me ntiꞌx jun twutzjo tze knet tuꞌn, noq txqan t-xaq. Tuꞌntziꞌn ikyjo, xi tqꞌmaꞌn te tqan iw: Mixla jtojx tuꞌn tel twutza te kyloꞌxjal. Ex antej tqan iw jun paqx jaw tzqij. ");
INSERT INTO mamC_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Atzaj teꞌ tok qkaꞌyiꞌn noq tzqijl tej tze, xi qqaniꞌn te Jesús: ¿Tzeꞌntzin tten teꞌ tze jun paqx xjaw tzqij? qo chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tzaj ttzaqꞌwin Jesús: Twutzxix kxel nqꞌmaꞌn kyeꞌy, noqit at-xix kynimbꞌila, ex noqit mi njawje kykꞌuꞌja, nya noq oꞌkxjo luꞌn aku bꞌant kyuꞌn, tzeꞌnku xbꞌant wuꞌn tiꞌjjo tqan iw, qalaꞌ noqit txi kyqꞌmaꞌn te wutz luꞌn: Ku tela tzaluꞌn, ex ku txiꞌy toj ttxuyil aꞌ, ex akula tzikyꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Quꞌn tkyaqiljo kxel kyqanin toj naꞌj Dios tukꞌa kynimbꞌila, ok ktzajil qꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tej tokx Jesús toj tnejil ja te naꞌbꞌl Dios, i pon laqꞌe kynejil pale exqetziꞌn kynejinel kyxolxjal aj Judiy, a tzmataq nxnaqꞌtzintaq. Xi kyqanin te: ¿Tiꞌn tokiy tuꞌn tbꞌinchinjiy jniꞌ lo, a nkubꞌ tbꞌinchiꞌn? ¿Ex ankye saj qꞌoꞌnte tokliꞌn? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Xi ttzaqꞌwin Jesús: Ex ikyx wejiꞌy, kxel nqaniꞌn jun nxjelbꞌitza kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ankye tzaj chqꞌoꞌnte qtzan Juan tuꞌn kykuꞌxxjal tuꞌn toj aꞌ te jawsbꞌil aꞌ? ¿Apela Dios, mo noq ayexjal? Bꞌeꞌx i bꞌaj jaw yolin kyxolx, ex kyqꞌma: Qa ma txi qqꞌmaꞌn a Dios, bꞌeꞌx ktzajil tqꞌmaꞌn qe, ¿Tin quꞌn mi nxi kynimintza? chilaꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ex qa ma txi qqꞌmaꞌn qa xjal, at qxobꞌil. ¿Ma nyatzin kykyaqil xjaltz qꞌmante qa a Juan jun yolil Tyol Dios? ");
INSERT INTO mamC_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tuꞌnpetziꞌn, xi kyqꞌmaꞌn: Mi bꞌiꞌn qe quꞌn, chi chiꞌ. I xi ttzaqꞌwin Jesús: Exsin ikyx wejiꞌy, nlay txi nqꞌmaꞌn weꞌ, alkye saj qꞌoꞌnte wokliꞌn tuꞌn tkubꞌ nbꞌinchiꞌn tkyaqiljo lo. ");
INSERT INTO mamC_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Xi tqꞌmaꞌn Jesús: ¿Tzeꞌntzin chꞌin kyeꞌ toj kywutz? Attaq jun ichin attaq kabꞌe tkꞌwal. Xi tqꞌmaꞌn te jun: Nkꞌwal, maꞌ txiꞌy aqꞌnil jaꞌlin toj tqan uvch. ");
INSERT INTO mamC_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Me mina, chi kꞌwal. Me jun paqx tja tmeltzꞌin tnabꞌl, ex bꞌeꞌx xiꞌl aqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Atzaj teꞌ t-xiꞌ lol teꞌ juntl, ex ikyx xi tqꞌmaꞌn te: Kutzin tata. Kꞌaꞌ chiꞌn chinaj teꞌ, exsin mix xaꞌyiltz. ");
INSERT INTO mamC_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ankyeꞌ kubꞌ nimin teꞌ tajtaq manbꞌaj kyxoljo kabꞌe kꞌwal lo? Xi kyqꞌmaꞌn: A tnejil, chi chiꞌ. Xi tqꞌmaꞌn Jesús kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy; ayepe kyeꞌ peyiltaq pwaq, ayeꞌ iꞌjlin kyuꞌnxjal, exqetziꞌn aj kyꞌaꞌjilqetaq kchi okix toj Tkawbꞌil Dios toj kyaꞌj, tuꞌn kynimbꞌil. ¿Yajtzin kyetza? ");
INSERT INTO mamC_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Quꞌn tej tul Juan, a Jawsil Aꞌ, qꞌmalte tumil kyeꞌy tzeꞌn tuꞌn kybꞌetiꞌy tzꞌaqle, me mix xi kynimiꞌn. Me ayetzinl kyeꞌ, aye peyil pwaq exqetziꞌn aj kyꞌaꞌjil ma txi kynimin. Me qalatzin kyeꞌ, nixpela tuꞌn ma kyliꞌy tkyaqiljo lo, me mi s-ajtz koꞌpjx kyanmiꞌn tuꞌn txi kynimiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ex xi tqꞌmaꞌn Jesús: Kybꞌinkujiꞌy juntl techil lo: Attaq jun tajaw txꞌotxꞌ ok tawin tqan uv. Ok tqꞌoꞌn jun chꞌlaj tiꞌjile, kubꞌ tbꞌinchin jun bꞌinchbꞌil taꞌl uv, ex jaw twaꞌbꞌin jun xkyaqꞌte te tzajbꞌilte. I kyij bꞌant kyukꞌa jteꞌbꞌin aqꞌnil tuꞌn kymanin tiꞌj, exsin xiꞌtz toj jun tbꞌe najchaq wen. ");
INSERT INTO mamC_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Me atzaj teꞌ tpon tqꞌijil, jaꞌ tuꞌn tok chmete twutz awal, i xi tchqꞌoꞌn junjun taqꞌnil qanil teꞌ manbꞌil ttxꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Me ayetziꞌn manil txꞌotxꞌ i ok lipin kyiꞌjjo taqꞌnil tajaw txꞌotxꞌ. Jun teꞌ noq bꞌaj kylankꞌin, jun teꞌ bꞌeꞌx kyim, ex jun teꞌ noqx techx kyꞌixbꞌe tuꞌn abꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tuꞌn ikyjo, bꞌeꞌx i xi tchqꞌoꞌn txqantl taqꞌnil tzeꞌnku te tnejil. Me ikyx bꞌajjo kyiꞌj, tzeꞌnkuꞌ bꞌaj kyiꞌjjo tnejil kyuꞌn manil txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Me kubꞌ tbꞌisin tajaw txꞌotxꞌ tuꞌn t-xi tchqꞌoꞌn a tkꞌwalkuxix, quꞌn kubꞌ t-ximin, nyapela kꞌwel kynimin nkꞌwalach. ");
INSERT INTO mamC_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Me atzaj teꞌ t-xi kykaꞌyiꞌn manil txꞌotxꞌ, teꞌ ttzaj kꞌwalbꞌaj, bꞌeꞌx i bꞌaj ja yolin kyxolile: Ate luꞌn kyjel te tajaw txꞌotxꞌ. Qalaꞌ qbꞌyonku, tuꞌntzin qkyij te tajaw, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bꞌeꞌx tzaj kytzyuꞌn, ex kyiꞌn tzma ttxaꞌn txꞌotxꞌ tuꞌn tkubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tuꞌntzintzjo, xi tqanin Jesús kye: ¿Yajtzilaꞌ? Aj tuljo tajaw txꞌotxꞌ, ¿Tiꞌtzila kbꞌajil kyiꞌjjo manil txꞌotxꞌ? ");
INSERT INTO mamC_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ex xi kytzaqꞌwin: Bꞌalaqa kchi kꞌwel tbꞌyoꞌn te jun majx. Ex bꞌalaqa kxel tqꞌoꞌn ttxꞌotxꞌ te kymajin txqantl taqꞌnil, ayeꞌ chi chojil manbꞌil txꞌotxꞌ tojxix tqꞌijil. ");
INSERT INTO mamC_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ex xi ttzaqꞌwin Jesús kye: ¿Ma naꞌmtzin tkux kyuꞌjiꞌn toj Tuꞌjil Tyol Dios, jaꞌ ntqꞌmaꞌne kyjaluꞌn: A abꞌj, a xi kyxoꞌn bꞌinchil ja, a nyakuj ntiꞌtaq tajbꞌin, me axixpente abꞌjjo ma tzꞌokin te tqꞌuqil tẍkyin ja, a nimxix toklin. Atziꞌn tbꞌanilxjo ma tzaj tqꞌoꞌn tAjaw Tkyaqil qe, ex ma qo jaw kaꞌylajx tiꞌj? ");
INSERT INTO mamC_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tuꞌnpetziꞌn kxel nqꞌmaꞌn kyeꞌy, k-elil qꞌiꞌn Tkawbꞌil Dios kyeꞌy, ex kxel tqꞌoꞌn kyexjal, ayeꞌ kꞌwel kyyekꞌiꞌn tiꞌj Tkawbꞌil Dios toj kychwinqil. ");
INSERT INTO mamC_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ex atzin abꞌj jun techil wiꞌja. Ankye teꞌ kꞌwel t-xoꞌn tibꞌ tibꞌajjo abꞌj, tuꞌn tyuchꞌj tuꞌn; axte kꞌwel tyuchꞌin tibꞌ tibꞌaj. Ex qa a abꞌj xkubꞌ tzꞌaq tibꞌaj jun aꞌla te kawbꞌil kujxix, bꞌeꞌx kꞌwel quqix te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Me atzaj teꞌ kybꞌinte kynejil pale exqetziꞌn Parisey, jniꞌ techil bꞌaj kubꞌ tqꞌoꞌn Jesús, ex qa kyiꞌjxtaq nyoline, ");
INSERT INTO mamC_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","oktaq kytzyuꞌn toj kywutz. Me bꞌeꞌx i tzaj xobꞌ kyexjal, quꞌn tuꞌn otaq tzꞌel kynikyꞌxjal te qa a Jesús jun yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ok tenl Jesús yolil juntl majl tukꞌa techil, ex xi tqꞌmaꞌn: ");
INSERT INTO mamC_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Atzin Tkawbꞌil Dios toj kyaꞌj, ikytziꞌn tzeꞌnku jun nmaq kawil kubꞌ tikyꞌsin jun nintz qꞌij, tej tmeje tkꞌwal. ");
INSERT INTO mamC_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","I xi tsmaꞌn taqꞌnil txkolkye txqan txokenj. Me ayetzin kyeꞌ xjal luꞌn, mix i tzaje. ");
INSERT INTO mamC_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","I xi tsmaꞌn txqantl taqꞌnil, ex xi tqꞌmaꞌn kye: Kyqꞌmanxa kyeꞌ txokenj, tuꞌn kytzaj jaꞌlinxix, quꞌn ma bꞌant te wabꞌj: Ma chi kubꞌ nbꞌyoꞌn nwakixa, ex ayeꞌ waliꞌn tbꞌanilqex. Ex jotx noqx tkubꞌ tkyaqil. Kux chi tzaja toj mejebꞌlin, chichkujiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Me ayetzin kyeꞌ txokenj, mix xi kytziyine tuꞌn kyxiꞌ toj mejebꞌlin. Jun teꞌ bꞌeꞌx xiꞌ lol ttxꞌotxꞌ; juntl bꞌeꞌx xiꞌ lol tkꞌaẍjil. ");
INSERT INTO mamC_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ayetziꞌn txqantl i bꞌaj ok ten bꞌyol kye taqꞌnil nmaq kawil, ex majxpe i kubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Me bꞌeꞌx tzajx tqꞌoj nmaq kawil, ex bꞌeꞌx bꞌaj xi tchqꞌoꞌn xoꞌl qꞌaqꞌ bꞌyol kyeꞌ bꞌiyil, ex majx ok qꞌoꞌn tqꞌaqꞌiljo kytanim. ");
INSERT INTO mamC_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tbꞌajlinxiꞌ ikyjo, xi tqꞌmaꞌn kye taqꞌnil: Tkyaqilx noq tkubꞌl. Me ayetzin kyeꞌ txokenj kykyꞌeꞌ tuꞌn kytzaj. ");
INSERT INTO mamC_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ku kyxiꞌ toj xkyꞌich bꞌe, ex kyojileꞌ jniꞌ nim bꞌe toj tnam, ex kytxkonqetza aꞌlchaqx kye xjaltz jaꞌlin, tuꞌn kytzaj toj mejebꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bꞌeꞌxsin i bꞌaj xiꞌ aqꞌniltz chmol kyeꞌ jniꞌ xjal kyojile jniꞌ nim bꞌe, tzeꞌnchaqextz, exla qa wen, mo minaj, tzmaxitzin noj teꞌ ma tij ja kyuꞌn xjal. ");
INSERT INTO mamC_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Me atzaj teꞌ tokx te nmaq kawil kaꞌyil kye txokenj, ok kyim tiꞌj jun ichin, a tokxtaq, ntiꞌtaq t-xbꞌalin iteꞌk tzeꞌnku toj jun mejebꞌlin, tzeꞌnqeku kyeꞌ txqantl. ");
INSERT INTO mamC_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ex xi tqꞌmaꞌn te: Wukꞌa, ¿Tzeꞌn tten s-oktza tzaluꞌn, kyukꞌa t-xbꞌalin ikyjo? chiꞌ. Me ante xjal mix xaꞌye yekche, noq tuꞌn t-xobꞌil te nmaq kawil. ");
INSERT INTO mamC_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bꞌeꞌx xi tqꞌmaꞌn kawil kye aqꞌnil nchi bꞌaj bꞌinchintaq meẍ te wabꞌl: Kykꞌlonqekuy tqan ex tqꞌobꞌ, ex kyqꞌomixa tzma toj qxopin peꞌn, a jaꞌ okx k-oqꞌile, ex kchi juꞌchꞌile tste tuꞌn nim kyixkꞌoj. ");
INSERT INTO mamC_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Quꞌn nimxte txokenj tojjo kolbꞌil, me noqx jteꞌbꞌin kjawil skꞌet, chi Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ayetziꞌn Parisey i jaw yolin kyxolx tzeꞌnxtaq jun tumil tuꞌn tkubꞌ tzꞌaq Jesús kyuꞌn toj til. ");
INSERT INTO mamC_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tuꞌnpetziꞌn, xi kychqꞌoꞌn junjun kyukꞌa, junx kyukꞌa junjun xjal, ayeꞌ lipcheqektaq tiꞌj Herodes, exsin xi kyqꞌmaꞌntz te Jesús: Ay, xnaqꞌtzil, noq samiꞌy, bꞌiꞌn qe quꞌn, qa nyolin te twutzxix, ex nxnaqꞌtziꞌn noq tiꞌjjo tbꞌeyil chwinqil tuꞌn qxiꞌ tukꞌa qMan Dios. Ex nya noq lipcheka tiꞌjjo nkyqꞌmanxjal, ex mi nchi kubꞌ tniminjiy aye nim kyoklin, quꞌn toj twutza, junx kyoklinxjal kykyaqil. ");
INSERT INTO mamC_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tuꞌnpetziꞌn, ¿Tzeꞌntzin chꞌin te toj twutz? ¿Wenpela tuꞌn t-xi qchjonjiꞌy kꞌaybꞌil te kawil te Rom, mo minaj? Xi kyqanin ikyjo quꞌn kykyꞌeꞌtaq Parisey tuꞌn t-xi chjet kꞌaybꞌil, me ayetziꞌn kyukꞌa Herodes, kyajtaq. Ikytziꞌn, iltaq tiꞌj tuꞌn tkubꞌ tzꞌaq Jesús kyuꞌn toj til kywutzjo jun chꞌuq xjal lo. ");
INSERT INTO mamC_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ex bꞌeꞌx el te Jesús tnikyꞌ tiꞌjjo kybꞌis, qa nya bꞌaꞌntaq. Tuꞌntziꞌn, xi tqꞌmaꞌn kyjaluꞌn: ¡Xmiletzꞌ! N-el we nikyꞌa te kyaja. Kyaja tuꞌn nkubꞌ tzꞌaqa tiꞌjjo nxnaqꞌtzbꞌila. ");
INSERT INTO mamC_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kyyekꞌintzin jun pwaq weꞌy, a n-ajbꞌin te chojbꞌil kꞌaybꞌil te kawil te Rom. Ex tzaj kyiꞌn jun pwaq. ");
INSERT INTO mamC_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Atzaj teꞌ tok tkaꞌyin Jesús, xi tqanin kye: ¿An qwutzbꞌiyiljo lo, ex an qbꞌi tzꞌibꞌink twutz? ");
INSERT INTO mamC_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Xi kytzꞌaqwinxjal: Te nmaq kawil te Rom, chi chiꞌ. Ex xi tqꞌmaꞌn Jesús kye: Tuꞌnpetziꞌn, kyqꞌoꞌnx kyejiꞌy a ntqanin nmaq kawil te Rom, ex kyqꞌoꞌnxjiꞌy a te Dios ntqanin. ");
INSERT INTO mamC_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tej kybꞌinte ikyjo, noq i bꞌaj jaw kaꞌylaj, ex bꞌeꞌx kyij kytzaqpiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tojxjo qꞌij anetziꞌn, at junjun Sadusey ul kanin tkꞌatz Jesús tukꞌa jun kyxjelbꞌitz. Toj kywutz nlay chi jatz anqꞌintl juntl majl kyimnin. Tuꞌnpetziꞌn, xi kyqanin te Jesús: ");
INSERT INTO mamC_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kyij tyolin Moisés, qa ma kyim jun ichin, ex qa ntiꞌ jun tkꞌwal xkyij tukꞌa t-xuꞌjil, il tiꞌj tuꞌn tjaw meje tukꞌa titzꞌin mo tukꞌa ttziky qtzan tchmil, tuꞌntzin aj tuljo tnejil kyal, te tkꞌwaljo qtzan tchmil tuꞌn toke. ");
INSERT INTO mamC_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Quꞌn ikytzin qejiꞌy qxol, attaq wuq ichin kyitzꞌimile kyibꞌ. Atziꞌn kytziky knet t-xuꞌjil, me ntiꞌ jun tkꞌwal kyij, teꞌ tkyim. Atzin t-xuꞌjil kyij, bꞌeꞌx jaw meje tukꞌa titzꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Me ikyxl bꞌajjo tukꞌa tkabꞌ; ntiꞌ jun tkꞌwal kyij, teꞌ tkyim. Ikyxljo tukꞌa toxin. Kywuqilx i ok meje tukꞌa, me ntiꞌ jun kykꞌwal kyij, teꞌ kykyim. ");
INSERT INTO mamC_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ex bꞌeꞌx kyimljo qya. ");
INSERT INTO mamC_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Me atzin jaꞌlin, ¿Tzeꞌntzila tteꞌn tuꞌn kyjaw anqꞌintl kyimnin? Quꞌn, qa ikyjo, aj kyjaw itzꞌje juntl majl, ¿Tiꞌtzila kbꞌajiltz? ¿Altzila kye k-okil te tchmiljo qya kyxoljo wuq ichin, quꞌn kykyaqilx i ok meje tukꞌa? ");
INSERT INTO mamC_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Xi ttzaqꞌwin Jesús kye: Najninx iteꞌ kyeꞌ. ¿Naꞌmxsin tel kynikyꞌa te Tyol Dios, ex te jniꞌ tipin? ");
INSERT INTO mamC_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ajtzin kybꞌaj jaw itzꞌje juntl majljo kyimnin, mikyxil teꞌ chwinqil tzeꞌnku luꞌn. Ayetziꞌn ichin exqetziꞌn qya mina chi bꞌaj jaw meje juntl majl. Iky kchi bꞌaj okileꞌ tzeꞌnqekuꞌ angel toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Me tiꞌjtziꞌn tuꞌn kyjatz anqꞌintl kyimnin, ¿Ma naꞌmtzin tkux kyuꞌjiꞌn, a aku Dios qꞌmante kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ayin wejiꞌy tDios Abraham, te Isaac ex te Jacob? Mix tqꞌma qa ayintaq wejiꞌy, qalaꞌ ayin wejiꞌych. Ikytziꞌn, ate Dios nya kyDios kyimnin, qalaꞌ kyDios itzꞌ, exla qa o chi kyim tzaluꞌn twutz txꞌotxꞌ, quꞌn toj twutz Dios, itzꞌqe kykyaqilx. ");
INSERT INTO mamC_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Atzaj teꞌ kybꞌinte xjaljo ikyjo, kykyaqilx i bꞌaj jaw kaꞌylaj tiꞌjjo t-xnaqꞌtzbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Atzaj teꞌ tok kybꞌiꞌn Parisey, qa otaq kubꞌ kyiꞌj Sadusey tuꞌn Jesús, jaw kychmoꞌn kyibꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Me attaq jun kyxol xnaqꞌtzil tiꞌj ojtxe kawbꞌil, tajtaq tuꞌn tkubꞌ tzꞌaq toj til tuꞌn. Xi tqanin te: ");
INSERT INTO mamC_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Xnaqꞌtzil, ¿Ankyeꞌ tkawbꞌil Dios nimxixtl toklin txoljo txqantl? ");
INSERT INTO mamC_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Xi ttzaqꞌwin Jesús: An tnejiljo luꞌn: Kꞌuꞌjlinkxixa Dios tukꞌa tkyaqil tanmiꞌn, ex tukꞌa tkyaqil tkꞌuꞌja, ex tukꞌa tkyaqil tnabꞌla. ");
INSERT INTO mamC_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Atzin tnejil kawbꞌiljo ex nimxix toklin. ");
INSERT INTO mamC_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ex atzin tkabꞌ chꞌime ikyxjo tzeꞌnku tnejil, tuꞌn tok tkꞌuꞌjlin t-xjalila, tzeꞌnkux n-ok tkꞌuꞌjlin tibꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ayetzin kabꞌe kawbꞌiljo lo, ayetziꞌn tqꞌuqil tkyaqil t-xilin kawbꞌil ex jniꞌ t-xilin kyxnaqꞌtzbꞌil yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Chꞌuqleqextaq Parisey, ");
INSERT INTO mamC_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","xi tqanin Jesús kye: ¿Tiꞌtzin chꞌin kye nkyximiꞌn tiꞌjjo Crist, a Kolil? ¿Jaꞌtzila tzajnin tyajil? Tyajil David, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tuꞌnpetziꞌn, xi ttzaqꞌwin Jesús: A qa ikyjo, ¿Tzeꞌntzin tten te Davidtz, tuꞌn tipin Xewbꞌaj Xjan, ok tqꞌoꞌn te tAjaw, exsiꞌn naꞌmtaq tul itzꞌje Crist, a Tajaw Tkyakil? Quꞌn ikytzin tqꞌma Davidjo: ");
INSERT INTO mamC_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Xi tqꞌmaꞌn qMan Dios te wAjawa: Qekuy toj nman qꞌobꞌa kawil wukꞌiy, ex kꞌwel kyiꞌjjo tajqꞌoja wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Twutzx teꞌ qa a Crist tyajil David. ¿Me tzeꞌntzin ttentz o yolin te David tiꞌj Crist, a naꞌmtaq titzꞌje, ex ok tqꞌoꞌn te tAjaw? ");
INSERT INTO mamC_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ex mix aꞌl jun bꞌant ttzaqꞌwin teꞌ yol lo. Atxixsiꞌn, mix aꞌl juntl ul toj tkꞌuꞌj tuꞌn tokx tlimoꞌn tibꞌ qanil juntl tiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tbꞌajlinxiꞌ ikyjo, ok ten Jesús yolil kyukꞌaxjal ex qukꞌiy, a awoꞌy t-xnaqꞌtzbꞌin. Chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ayetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey n-ok kyqꞌoꞌn kyibꞌ, tuꞌn tel pjet, ex tuꞌn kyxnaqꞌtzin tiꞌj tkawbꞌil Moisés. ");
INSERT INTO mamC_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tuꞌnpetziꞌn, kyniminqekuy, ex kybꞌinchinkuy tkyaqiljo ktzajil kyqꞌmaꞌn kyeꞌy. Me mi kubꞌ kybꞌinchinjiꞌy a nbꞌant kyuꞌn, quꞌn xmiletzꞌqe; nkyqꞌmaꞌn tumil tzeꞌn tuꞌn toke, me junxil nkubꞌ kybꞌinchin. ");
INSERT INTO mamC_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ax txqan nukꞌbꞌil nbꞌaj xi kyqꞌoꞌn, manyor kujqex wen, ikytziꞌn tzeꞌn junjun tij iqtz, a mix aꞌl aku kyꞌisje tuꞌn. Noq iteꞌk qꞌmalte kyexjal, tuꞌn tjaw kyiqin, me ayetzin kyetz noqittzin aku jaw kyonin chꞌin, iꞌchaqxpetla noq jun twiꞌ kyqꞌobꞌ xi aqꞌle tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tkyaqilxjo jniꞌ nbꞌant kyuꞌn, noq tuꞌn kyjawku iqin kyuꞌnxjal. Ex kyajxix tzꞌok kyqꞌoꞌn tiꞌj kyplaj mo tiꞌj kyqꞌobꞌ junjun tnej Tyol Dios tzꞌibꞌink twutz tzꞌuꞌn ma nmaq twutz, me noq tuꞌn kynimsin kyibꞌ kywutzxjal. Ex nbꞌaj ok kyqꞌoꞌn kyxbꞌalin manyor xqerx wen, noq tuꞌn kyokku kaꞌyin kyuꞌnxjal. ");
INSERT INTO mamC_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ex kyaj tuꞌn kyok qe kyiꞌj tnejil meẍ te wabꞌl toj kyjaxjal ex kyoj muꞌẍ ja te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ex kyaj tuꞌn tkubꞌ kymutxbꞌinxjal kywiꞌ kywutz, aj kyok qꞌolbꞌin noq jaꞌ toj bꞌe, ex tuꞌn kyok qꞌolbꞌin te xnaqꞌtzil. ");
INSERT INTO mamC_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Me metzin kyeꞌ, mi chi tiliꞌn tuꞌn tok qꞌoꞌn kybꞌiy te xnaqꞌtzil kyuꞌnxjal te kynimsbꞌil kyibꞌa. Quꞌn junx kyokliꞌn, quꞌn junchꞌin kyMaꞌn, ex junxchꞌin Xnaqꞌtzil kyeꞌy, a ayiꞌn, a Crist. ");
INSERT INTO mamC_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ex mi tzꞌok kyqꞌoꞌn toklin jun aꞌla te manbꞌaj tzaluꞌn twutz txꞌotxꞌ, quꞌn oꞌkx te Manbꞌajjo junchꞌin at toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ex mi chi tiliꞌn tuꞌn tok qꞌoꞌn kyokliꞌn te nejinel, quꞌn ayin weꞌ Crist, nejinel kywutza. ");
INSERT INTO mamC_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ex ankye teꞌ nim toklin kyxola, il tiꞌj tuꞌn tajbꞌin kye txqantl. ");
INSERT INTO mamC_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Quꞌn ankye teꞌ kjawil tnimsin tibꞌ, kꞌwel mutxsin teꞌ tuꞌn Dios kywutzxjal. Me anteꞌ kꞌwel tmutxsin tibꞌ, poꞌn qꞌij jaꞌ kjawile nimsin teꞌ tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey xmiletzꞌ. Quꞌn n-ok kyjpunjiꞌy kynabꞌljo xjal, tuꞌn mi chi okxa tojjo Tkawbꞌil Dios toj kyaꞌj, ex ayeku kyeꞌ mi chi okxa. Ex mi nkytziyiꞌn tuꞌn kyokxjo ayeꞌ kyaj tuꞌn kyokx. ");
INSERT INTO mamC_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey xmiletzꞌ. Quꞌn n-el kyinjiꞌy kyja tal qya, a o kyim kychmil, ex noq tuꞌn kyjaw niminkuy kyuꞌnxjal, nchi naꞌnnaja Dios kyiꞌj nimxix tqan, tuꞌn tmojin ex tuꞌn tkolin kyiꞌj, ex otaq tzꞌel kyiꞌn tal kyja. Tuꞌn ikyjo nimxix tkawbꞌil Dios kꞌwel kyibꞌaja kujxix wen. ");
INSERT INTO mamC_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey xmiletzꞌ. Quꞌn nchi bꞌaj bꞌetjiꞌy tkyaqil twutz txꞌotxꞌ xmoxil kyexjal tuꞌn kynimin kyukꞌiy tiꞌjjo kynimbꞌila. Ex ajtzin tkubꞌ jun xjal kyuꞌn, ma txi kyqꞌoꞌn toj il, tuꞌn t-xiꞌ toj qꞌaqꞌ te jun majx tzeꞌnku kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy xkol moẍ. Quꞌn nkyqꞌmaꞌn qa at jun xjal xkubꞌ tqꞌmaꞌn jun tyol, exsin ma kubꞌ tqꞌmaꞌn tbꞌi tnejil ja te naꞌbꞌl Dios tiꞌj, nyaxix il tiꞌj tuꞌn tjapin bꞌaj tyol tzeꞌnkux tqꞌma. Me qa ma kubꞌ tqꞌmaꞌn jun tyol, exsin xkubꞌ tqꞌmaꞌn tbꞌi qꞌanpwaq toj tnejil ja te naꞌbꞌl Dios tiꞌj, ilxixpen teꞌ tiꞌj tuꞌn tjapin bꞌaj, chi chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ntiꞌ kynabꞌla, ex moẍqiꞌy! ¿Ankyeꞌ nimxixtl toklin? ¿Apela qꞌanpwaq, mo qa a tnejil ja te naꞌbꞌl Dios, a s-ok qꞌonte toklin pwaq te xjanxix toj taqꞌin Dios? ");
INSERT INTO mamC_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ex nkyqꞌmaꞌn, qa ma kubꞌ tqꞌmaꞌn jun tyol, exsin ma kubꞌ tqꞌmaꞌn tbꞌi t-altar Dios toj tnejil ja te naꞌbꞌl Dios tiꞌj, nyaxix il tiꞌj tuꞌn tjapin tyol. Me qa at jun kubꞌ tqꞌmaꞌn jun tyol, exsin xkubꞌ tqꞌmaꞌn tbꞌi oyaj, a tkubꞌ tibꞌaj t-altar Dios tiꞌj, axixpente yoljo, il tiꞌj tuꞌn tjapin, chi chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ntiꞌ kynabꞌla, ex moẍqiꞌy! ¿Ankyeꞌ nimxixtl toklin? ¿Ma apela oyaj, mo qa a t-altar Dios, a s-ok qꞌonte oyaj te xjanxix twutz? Kxel nqꞌmaꞌn qa junx kyoklin kykabꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Quꞌn alkye ma kubꞌ tqꞌmaꞌn tbꞌi t-altar Dios toj tnejil ja te naꞌbꞌl Dios tiꞌj tyol, nya noq tiꞌj tbꞌi t-altar ma kubꞌe tqꞌmaꞌne tyol, qalaꞌ majx tiꞌj tkyaqiljo tkubꞌ tibꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ex ankyeꞌ kꞌwel tqꞌmaꞌn tbꞌi tnejil ja te naꞌbꞌl Dios tiꞌj tyol, nya noq tiꞌjjo tnejil ja te naꞌbꞌl Dios ma kubꞌe tqꞌmaꞌne, qalaꞌ majx tiꞌj Dios, a najle toj. ");
INSERT INTO mamC_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ex alkye ma kubꞌ tqꞌmaꞌn jun tyol tiꞌj kyaꞌj, nya noq tiꞌj kyaꞌj ma kubꞌe tqꞌmaꞌne, qalaꞌ majx tiꞌj tkyaqil tqꞌuqbꞌil Dios, ex tiꞌjku Dios, a qꞌuqle toj. ");
INSERT INTO mamC_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey xmiletzꞌ. Quꞌn nxi kyqꞌoꞌn twutz tlajajin tnej menta, anís, ex kominis, tzeꞌnkuꞌ ntqꞌmaꞌn toj ojtxe kawbꞌil. Me mi n-ok kybꞌinjiꞌy xnaqꞌtzbꞌil, a nimxixtl toklin toj kawbꞌil: A tuꞌn kynajaꞌn tzꞌaqle, ex tuꞌn tten tqꞌaqꞌbꞌil kykꞌuꞌja kyiꞌj txqantl, ex tuꞌn tten kynimbꞌila tiꞌj Dios. Atzin tuꞌn tkubꞌ kybꞌinchinjiꞌy, ex tuꞌn mi kyij kytzaqpinjiꞌy txqantl. ");
INSERT INTO mamC_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ayiꞌy xkol moẍ, quꞌn ikytzin nbꞌantjo kyuꞌn tzeꞌnku tuꞌn tel xkꞌamit jun tal netzꞌ us toj kꞌwabꞌj, me mi nkynaꞌn aj t-xi kykꞌulpinjiꞌy jun ma tij chej. Quꞌn kyaja tuꞌn tjapiꞌn tal netzꞌ tnukꞌbꞌil kawbꞌil kyuꞌn, me atzin a nimxixtl toklin toj kawbꞌil, mi nkubꞌ kybꞌinchiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey xmiletzꞌ. Quꞌn ikyqetzinjiꞌy tzeꞌnku jun tkꞌwel kꞌwabꞌj ex jun laq, a chebꞌe txjoꞌn tiꞌj, me atzin tojxi, manyor tzꞌil: Nojnin tukꞌa jniꞌ kyelaqꞌa ex tukꞌa jniꞌ kyachbꞌila. ");
INSERT INTO mamC_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ayiꞌy Parisey moẍqiꞌy, kytxjonktzjiꞌy tojxi tkꞌwel kꞌwabꞌj nej ex tojxi laq. Quꞌn ikytzin kyjela saqixjo tiꞌjxi. ");
INSERT INTO mamC_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey xmiletzꞌ. Quꞌn ikyqejiꞌy tzeꞌnku jun tja kyimnin tbꞌanilx tkaꞌyajtzjo tiꞌjxi, me atziꞌn tojxi nojnin tukꞌa tbꞌaqil kyimnin ex manyor tzuꞌjx. ");
INSERT INTO mamC_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ikyqetzinjiꞌy, quꞌn tbꞌanilx nbꞌant kyuꞌn kywutzxjal, me toj kyanmiꞌn, nojnin taꞌye tukꞌa ttzꞌilil ex tkyaqil wiq il. ");
INSERT INTO mamC_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey xmiletzꞌ. Quꞌn chebꞌe njaw kybꞌinchiꞌn kyja qtzan yolil Tyol Dios, ayeꞌ i kꞌmonte Tyol ojtxe, ex nbꞌaj kubꞌ kytxoliꞌn t-xmakil kꞌul tiꞌjile kyjulil qtzan wen xjal. ");
INSERT INTO mamC_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ex nkyqꞌmaꞌn: Noqit otaq qo itzꞌje tojjo kyqꞌijil qtzan qchman ojtxe, nyajinqotla xqo mojin tuꞌn kybꞌyetjo yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Antza aku tzꞌele kynikyꞌa kye qa antza tzajnin kyyajila kyiꞌjjo ayeꞌ ẍi kubꞌ bꞌyonkye yolil Tyol Dios ojtxe, quꞌn ayexa nchi qꞌmante. ");
INSERT INTO mamC_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ex qa kykyꞌeꞌy tuꞌn kyok lipeꞌy wiꞌja, in tjapin bꞌaj kyuꞌn, tzeꞌnkuxjo kyij yekꞌin kyeꞌy kyuꞌn qtzan kychmaꞌn ojtxe, aye bꞌyol xjal. Me bꞌiꞌnku kyuꞌn qa japin jun qꞌij, tuꞌn tul kawbꞌil kyibꞌaja kujxix wen tiꞌj tkyaqiljo lo. ");
INSERT INTO mamC_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Maꞌ kan, ex maꞌ tyajil qꞌantinqiꞌy! ¿Tzeꞌntzin tten tuꞌn kyel oqa twutzjo kawbꞌil tzul, a qꞌaqꞌ, a tzunx njulinx wen? ");
INSERT INTO mamC_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tuꞌnpetziꞌn, kchi tzajil nsmaꞌn weꞌ yolil Tyol Dios, exqetziꞌn aj nabꞌl, ex xnaqꞌtzil. Me kchi kꞌwel kybꞌyoꞌn junjun, ex kchi jawil kypejkꞌiꞌn junjuntl twutz cruz tuꞌn kykyim, ex kchi bꞌajil kybꞌyoꞌn junjuntl toj ja te naꞌbꞌl Dios, exsin kchi okil teꞌn lajolkye tojile junjun tnam. ");
INSERT INTO mamC_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Me ktzajil tkawbꞌil Dios kyibꞌaja kujxix wen, noq tuꞌn tpaj kychkyꞌeljo qtzan xjal tzꞌaqleqe, ayeꞌ i kubꞌ bꞌyoꞌn atxix tiꞌj Abel, a tzꞌaqle, ex Zakariy, a tkꞌwal Berequías, a kubꞌ kybꞌyoꞌn, ayiꞌy Judiy, tojx tnejil ja te naꞌbꞌl Dios ex twutz t-altar qMan. ");
INSERT INTO mamC_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Twutzxix kxel nqꞌmaꞌn kyeꞌy, noq tuꞌn tpaj tkyaqiljo lo, kꞌwel tzꞌaq tkawbꞌil Dios kujxix wen kyibꞌajjo xjal jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ex chi Jesúsjo kyjaluꞌn kyeꞌ xjal te Jerusalén: ¡Ay! Jerusalén, Jerusalén, ay bꞌiyil kyiꞌj yolil Tyol Dios, ex nchi ok kyxoꞌnjiꞌy tsan qMan tukꞌa abꞌj; jteꞌlixla majxla ẍin bꞌaj labꞌtiꞌy kyiꞌja, tuꞌn kytzaj laqꞌeꞌy nkꞌatza, tzeꞌnku jun ttxu ekyꞌ nchi kubꞌ tpaqin tal tal tjaqꞌ t-xikyꞌ, me mi xkytziyiy ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kykaꞌyinktzinjiꞌy kynajbꞌila kyjel naj te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Twutzxix kxel nqꞌmaꞌn kyeꞌy, texjo qꞌij jaꞌlin, mixla chin kylaꞌbꞌilxa jun majla, qa nya ajxi tpon tqꞌijil aj kyqꞌmantiꞌy: Kyꞌiwlinxix teꞌ, a tzul toj tbꞌi qAjaw. ");
INSERT INTO mamC_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tej tetz Jesús toj tnejil ja te naꞌbꞌl Dios, kyjaꞌtaq t-xiꞌ, bꞌeꞌx o tzaj laqꞌeꞌy, a awoꞌy t-xnaqꞌtzbꞌin tkꞌatz, ex xi qqꞌmaꞌn te: Kanqex kyejiꞌy junjun tij ja te naꞌbꞌl Dios, tbꞌanilqex wen, qo chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tzaj ttzaqꞌwin Jesús qeꞌy: Tbꞌanilqex kye junjun tij ja nchi ok kykaꞌyiꞌn, me twutzxix kxel nqꞌmaꞌn kyeꞌy, qa tkyaqilx kchi kꞌwel yuchꞌj, ex ntiꞌx jun abꞌj kyjel tibꞌaj juntl, aj tpon tqꞌijil. ");
INSERT INTO mamC_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx o xiꞌy tzma twiꞌ wutz Olivos. Tej tkubꞌ qe Jesús, bꞌeꞌx o xi laqꞌeꞌy tkꞌatz qjunalxa, ex xi qqaniꞌn te: QAjaw, qꞌmantza qeꞌy. ¿Jtojtzila bꞌaꞌn tbꞌajjo ikyjo? ¿Ex tiꞌtzila techil kqlaꞌbꞌila, aj chꞌixtaq tula, ex a chꞌixtaq tjapin bꞌaj tkyaqil twutz txꞌotxꞌ? ");
INSERT INTO mamC_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tzaj tqꞌmaꞌn Jesús: Kykaꞌyink kyibꞌa, tuꞌn mix aꞌl jun kubꞌ sbꞌun kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Quꞌn ma nintz te tzul tiꞌj nbꞌiꞌy, ex ok kyqꞌmaꞌbꞌil: Ayiꞌn weꞌ Crist, chichkulaꞌ. Ex ma nintzxjal kꞌwel kysbꞌuꞌn, tuꞌn kyxi lipe kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aj tok kybꞌiꞌn tqanil qꞌoj ex aj kybꞌaj ok qꞌoj kyojile junjuntl tnam najchaq, mi chi tzaj xobꞌa, quꞌn ikytzin ilx tiꞌj tuꞌn tbꞌajjo ikyjo. Me naꞌmtaqx tpon qꞌij tuꞌn tjapin bꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Quꞌn il tiꞌj tuꞌn tok qꞌoj kyxolile junjun chꞌuq xjal, ex kyojile junjun ma tij tnam. Ex waꞌyaj tzul, ex jniꞌ yabꞌil ex kyaqnajnabꞌ noq jaꞌchaqku. ");
INSERT INTO mamC_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Me tkyaqiljo kbꞌajil ikyjo, ikytziꞌn tzeꞌnku tnejil tchyoꞌn tkꞌuꞌj jun qya tukꞌa tal. ");
INSERT INTO mamC_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Quꞌn ex kchi xel qꞌoꞌn toj kyqꞌobꞌ kawil, tuꞌn kybꞌaj jubꞌchiꞌn kyuꞌn, ex okpe kchi kꞌwel bꞌyoꞌn junjun kyeꞌ kyuꞌn. Ex kykyaqilxjal kchi elil ikyꞌin kyeꞌ tuꞌn npaja. ");
INSERT INTO mamC_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kyojjo qꞌij anetziꞌn, nimxte kyjel ttzaqpiꞌn kynimbꞌil, ex kbꞌajil kyikyꞌin kyibꞌ, ex kchi bꞌaj okil meltzꞌaj kyiꞌjx. ");
INSERT INTO mamC_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ex kchi ul xjal sbꞌul, a kbꞌaj okil kyqꞌoꞌn kyibꞌ qa chqꞌonqe tuꞌn Dios. Ex nimxxjal kꞌwel kysbꞌuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Noq tuꞌn tpajjo ikyjo, ex tuꞌn nimku il kbꞌantil, nimxlaxjal k-elil tqꞌaqꞌbꞌil tkꞌuꞌj tiꞌj juntl. ");
INSERT INTO mamC_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Me ankye teꞌ kweꞌbꞌilx wen, ajxi tpon tqꞌijil, apente kletiljo. ");
INSERT INTO mamC_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aj telpin bꞌaj tyolajtzjo Tbꞌanil Tqanil Tkawbꞌil Dios tkyaqil twutz txꞌotxꞌ, tuꞌntzin ntiꞌx jun chꞌuqxjal, a mit tzꞌel tnikyꞌ tiꞌj. Atzin qꞌijjo japin bꞌaj tqꞌijil tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tuꞌnpetziꞌn, k-okil kykaꞌyiꞌn tzeꞌnkuꞌ kubꞌ ttzꞌibꞌin Daniel, a yolil Tyol Dios ojtxe, tiꞌj jun ichin, a kꞌwel tbꞌinchin tkyaqil, me tixqex toj Najbꞌil Xjanxix toj tnejil ja te kynaꞌbꞌl Judiy Dios (aj tkux kyujinjiꞌy luꞌn, tzꞌelku kynikyꞌa te). ");
INSERT INTO mamC_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aj tok kykaꞌyiꞌn jniꞌjo lo, tkyaqilxjal iteꞌ toj txꞌotxꞌ te Judey, bꞌeꞌx chi xel oq toj kꞌul. ");
INSERT INTO mamC_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ex atzin xjal, a tokxtaq twiꞌja, nlay taqꞌ ambꞌil tuꞌn tkuꞌtz qꞌilte jun tiꞌ te tuja. ");
INSERT INTO mamC_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ex ikyxljo, a tzmataq n-aqꞌnin toj ttxꞌotxꞌ, mi taqꞌ ambꞌil tuꞌn tul qꞌilkye t-xbꞌalin tja. ");
INSERT INTO mamC_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ayexjo tal qya, ayeꞌ chꞌixtaq kykubꞌ tzꞌaq, ex ayeꞌ tzmataq nbꞌaj miꞌẍin kyal! ");
INSERT INTO mamC_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chi naꞌn Dios, noqit nya toj jbꞌalilku, mo tojku jun qꞌij te ajlabꞌl kubꞌ tzꞌaqe ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Quꞌn nimkux jun kyixkꞌoj kkyꞌelix kyuꞌnxjal, a bꞌajxi kylaꞌye tukꞌaxjo tzajlin xkye twutz txꞌotxꞌ, ex mixla kqlaꞌbꞌil juntl majl, aj tjapin bꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Quꞌn noqit mi tzꞌajtz tajsin Dios kyiꞌjjo qꞌij anetziꞌn, mixitla aꞌlx jun aku kyij anqꞌin. Me ok ajitz tajsin Dios, noq tuꞌn tqꞌaqꞌbꞌil tkꞌuꞌj kyiꞌjjo o chi jaw tskꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Qa at jun saj qꞌmante kyeꞌy kyojjo qꞌij anetziꞌn: Lu Crist lo, mo qa: Luꞌ at tzachiꞌn, qa chiꞌ, mi txi kynimiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Quꞌn chi ul sbꞌul k-okil kyqꞌoꞌn kyibꞌ te Crist, mo te jun xjal tzeꞌnku jun yolil Tyol Dios ojtxe. Ex okpe kꞌwel kybꞌinchin nim techil kyipin, noq tuꞌn kysbꞌetkuxjal kyuꞌn. Ex okpela k-okil kynikyꞌin tuꞌn kykubꞌjo skꞌoꞌnqe tuꞌn Dios, me nlay chi kubꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tuꞌnpetziꞌn, ma txi nqꞌmaꞌn kyeꞌy naꞌmtaq tuꞌn tul kanin ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ex qa ma tzaj qꞌmaꞌn kyeꞌy: Lu at toj kꞌul, qa chiꞌ, mi cheꞌxa lolte. Ex qa ma tzaj kyqꞌmaꞌn: Ku kytzaja. Lu at tuja, qa chiꞌ, mi txi kynimiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Quꞌn ikytzin k-ikyꞌile tzeꞌnku jun xloqꞌlin kyaꞌj qꞌanchaꞌl toj tkyaqil twutz kyaꞌj; ktzajil qoptzꞌaj toj tjawitz qꞌij ex toj telix qꞌij. Ex tkyaqil xjal kxel kaꞌyin weꞌy, ayiꞌn, a Tkꞌwal Ichin, aj wula. ");
INSERT INTO mamC_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jun paqx k-elil tqanil, ikyxjo tzeꞌnku tqanil jun kyimnin n-el kyxol kꞌutz. ");
INSERT INTO mamC_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Noqx aj kybꞌajjo qꞌij ikyjo te yajbꞌil, k-okil qloljix twutz qꞌij, ex mi kꞌantl yaye. Ex jniꞌ qeꞌ cheꞌw kchi kꞌwelitz tzꞌaq twutz txꞌotxꞌ. Ex tkyaqiljo jniꞌ at twutz kyaꞌj okx chi luꞌlilx. ");
INSERT INTO mamC_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ex kylaꞌbꞌila twutz kyaꞌj a techiljo ayiꞌn Tkꞌwal Ichin, aj wula. Tkyaqil xjal twutz txꞌotxꞌ kchi bꞌaj jawil oqꞌ, aj nxi kykaꞌyin a ayiꞌn Tkꞌwal Ichin, aj ntzaja toj muj twutz kyaꞌj tukꞌa tkyaqil wipiꞌn ex jniꞌ nqoptzꞌajiyila. ");
INSERT INTO mamC_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ex tukꞌa tkyaqil tqꞌajqꞌojil chun, kchi tzajil nsmaꞌn n-angela, tuꞌn kyok chmetjo jniꞌ skꞌoꞌnqe wuꞌn toj tkyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kykaꞌyinkjiꞌy techil tiꞌj tqan iw: Aj ttzaj xulin tal tqꞌobꞌ, ex aj tzaj poqꞌle t-xaq, antza k-elile kynikyꞌa te, qa chꞌix tul kanin tqꞌijil. ");
INSERT INTO mamC_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ikyxsintzjo, aj tok kykaꞌyiꞌn tkyaqiljo luꞌn, tzꞌelku kynikyꞌa te, qa chꞌix tpon tqꞌijil tuꞌn wula juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Twutzxix kxel nqꞌmaꞌn kyeꞌy, a naꞌmxtaq kybꞌaj kyimxjal, a iteꞌ tojjo tqꞌijil jaꞌlin, aj t-xi xkyejo jniꞌ luꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A kyaꞌj ex txꞌotxꞌ ok kchi bꞌajil, me mex weꞌ Nyol nlayx chi kyijx kyeꞌ, tuꞌn mi chi japin bꞌaje. ");
INSERT INTO mamC_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Me alkye qꞌij ex alkye or chin ula, mix aꞌl teꞌ bꞌilte, mixpe aye angel toj kyaꞌj, mixpe ayinkuy, a Kꞌwalbꞌaj te Dios; qalaꞌ oꞌkx te nMan bꞌilte. ");
INSERT INTO mamC_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Quꞌn ikytziꞌn tzeꞌnkuj bꞌaj kyojjo qꞌij te Noé, ex ikytzin kbꞌajiljo, aj wula, ayiꞌn Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Quꞌn ikytziꞌn tzeꞌnqej qꞌij, tej naꞌmtaq ttzaj qꞌaqabꞌil; kykyaqil xjal twutz txꞌotxꞌ nchi bꞌaj waꞌntaq, ex nchi bꞌaj txꞌujtetaq, ex nchi bꞌaj mejetaq, ex nchi bꞌaj xi kyqꞌoꞌntaq kykꞌwal toj mejebꞌlin, tzmaxi teꞌ kyokx Noé toj ma tij bark. ");
INSERT INTO mamC_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Me ntiꞌx bꞌiꞌn kyuꞌn, teꞌ ttzaj qꞌaqabꞌil kyibꞌaj, ex bꞌeꞌx bꞌajxi mulqꞌaj toj aꞌ kykyaqilx. Ikytzin kbꞌajiljo, aj wula ayiꞌn, a Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tojjo qꞌij anetziꞌn, kabꞌe ichin nchi aqꞌnintaq toj kytxꞌotxꞌ. Jun teꞌ kxel qꞌiꞌn, ex jun teꞌ kyjel. ");
INSERT INTO mamC_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ex kabꞌe qya nchi cheꞌn junx tiꞌj kyka. Ex ikyxjo, jun teꞌ kxel qꞌiꞌn, ex jun teꞌ kyjel. ");
INSERT INTO mamC_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kyutzꞌlinku kyibꞌa toj kynimbꞌila. Quꞌn mi bꞌiꞌn kyuꞌn alkye or kchin ula, a ayiꞌn kyAjawiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tzꞌeltzin kynikyꞌa te: Noqit bꞌiꞌn tuꞌn jun tajaw ja, jniꞌ or tuꞌn tkanin ileqꞌ qnikyꞌin, matla kubꞌ tutzꞌlin tibꞌ, tuꞌn mi tzꞌokxi ileqꞌ elqꞌil toj tja. ");
INSERT INTO mamC_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tuꞌntzintzjo ikyjo, kybꞌinchinku kyibꞌa, quꞌn ntiꞌkux toj kynabꞌla aj wula, ayiꞌn Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","¿Ankye teꞌ aqꞌnil tzꞌaqle ex sakꞌ? Ok kyjel qꞌoꞌn teꞌ tuꞌn tajaw ja, aj t-xiꞌ toj jun tbꞌe, te nejinel kyxoljo txqantl, tuꞌn t-xi tqꞌoꞌn kywa noqx aj tpoꞌn ambꞌil te wabꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kyꞌiwlinxix teꞌ aqꞌnil, qa nbꞌinchintaq tiꞌjjo taqꞌin toj tumil, aj tuljo tajaw ja. ");
INSERT INTO mamC_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Twutzxix kxel nqꞌmaꞌn kyeꞌy, bꞌeꞌx kxel tqꞌoꞌn tajaw ja toklin te nejinel tibꞌaj tkyaqiljo at te. ");
INSERT INTO mamC_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Me qa nya wenjo aqꞌnil, exsin qa chiꞌ kyjaluꞌn toj tanmin: Yajla tzul tajaw ja. ");
INSERT INTO mamC_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Exsin tzꞌok tentz bꞌyol kyeꞌ tukꞌa, ex tzꞌok tukꞌlin tibꞌ loꞌl ex txꞌujtil kyukꞌa txꞌujtinel. ");
INSERT INTO mamC_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Me ntiꞌkux toj tnabꞌl, tej tpon tajaw ja, quꞌn ntiꞌxtaq bꞌiꞌn tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ex kꞌwel kawin kujxix wen, majx kxel smaꞌn toj qꞌaqꞌ te jun majx, junx kyukꞌa xmiletzꞌ, jaꞌ k-oqꞌile, ex kchi juꞌchꞌile tste tuꞌn kyixkꞌoj. ");
INSERT INTO mamC_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kyojjo qꞌij anetziꞌn, a Tkawbꞌil Dios toj kyaꞌj, ikyxjo tzeꞌnku lajaj txin, i xiꞌ toj jun mejebꞌlin. Xi kynojsin kytzaj tukꞌa aseyt, tej kyxiꞌ yolte qꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kyxoljo txin, attaq jweꞌ ntiꞌ kynabꞌl, ex ayetziꞌn jweꞌtl manyor ẍtijqe. ");
INSERT INTO mamC_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ayetziꞌn ntiꞌ kynabꞌl xi kyiꞌn kytzaj, me mi xi kyiꞌne chꞌintl kyaseyt. ");
INSERT INTO mamC_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Me ayetziꞌn ẍtij, xi kynojsinl tkꞌwel kyaseyt, ex xi kyiꞌn junx tukꞌa kytzaj. ");
INSERT INTO mamC_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Me mix jaꞌ pone tej qꞌa liwey, ex bꞌeꞌx bꞌaj tzaj kywatl kykyaqilx, ex bꞌeꞌx i xiꞌ ktal. ");
INSERT INTO mamC_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Me atzaj teꞌ tnikyꞌjin aqꞌwil, xi kybꞌiꞌn jun aꞌla tjaw ẍchꞌin: ¡Luꞌ qꞌa tzul! ¡Ku kytzaja kꞌlelte! chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","I bꞌaj jaw weꞌksjo txin kykyaqilx, ex i bꞌaj ok ten txqol kytzaj. ");
INSERT INTO mamC_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Me ayetzin kyeꞌ jweꞌtl ntiꞌ kynabꞌl xi kyqꞌmaꞌn kye ẍtij: Kyqꞌontz chꞌin qeꞌ qaseyt tiꞌjjo kyeꞌ, quꞌn chꞌix tkubꞌ yupj qtzaja, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Me ayetzin kye txin ẍtij xi kyqꞌmaꞌn kye: ¡Mina! Quꞌn nlaypela kanin qe. ¿Yajtzilaꞌ tuꞌn t-xi qqꞌoꞌntza chꞌin kyeꞌ? Qalaꞌ ku kyxiꞌy jaꞌ nkꞌayajtze, ex kꞌaꞌ tzaj kylaqꞌoꞌn chꞌintla. ");
INSERT INTO mamC_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Me noqx ncheꞌxku kyej jweꞌ txin, a ntiꞌ kynabꞌl, laqꞌol kyaseyt, teꞌ tkaniꞌn qꞌa. Ayetzin kyeꞌ jweꞌ txin, quꞌn mix ele bꞌete kyeꞌ, bꞌeꞌx i okx tuja toj mejebꞌlin, ex bꞌeꞌx etz kyjpuꞌn ja. ");
INSERT INTO mamC_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Maꞌytaq chꞌintl, tej kykanin kyej jweꞌ, ex i okx qꞌolbꞌin: Tata, tata, jqonkxjiy ja qeꞌy, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Me atziꞌn xi tqꞌmaꞌn tajaw ja kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy, ntiꞌ kyokliꞌn tuꞌn kyoktza, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Jesús kye: Noq tzaj kywatla toj kynimbꞌila, quꞌn mi bꞌiꞌn kyuꞌn tiꞌ qꞌijil mo alkye or chin ula, ayiꞌn Tkꞌwal Ichin, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ex ikyxjo, a Tkawbꞌil Dios toj kyaꞌj, tzeꞌnku jun xjal, tuꞌntaq t-xiꞌ toj jun tbꞌe najchaq. I tzaj ttxkoꞌn taqꞌnil, ex xi toqxenin tpwaq kye. ");
INSERT INTO mamC_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Te jun, xi tqꞌoꞌn jweꞌ mil; te juntl kabꞌe mil, ex te juntl, noq jun mil, teyile junjun xi tqꞌoꞌn tzeꞌnkux kynabꞌl. Ex bꞌeꞌxsin xiꞌtz toj tbꞌe. ");
INSERT INTO mamC_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Me ante aqꞌnil, a xi ttzyuꞌn jweꞌ mil pwaq, bꞌeꞌx kubꞌ tqꞌoꞌn tkꞌaẍjil, tuꞌn tchꞌiy pwaq. Ex bꞌeꞌx tkanbꞌe jweꞌtl mil. ");
INSERT INTO mamC_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ex ikyx tene tuꞌn, a xi ttzyuꞌn kabꞌe mil; ex tkanbꞌe jun kabꞌetl tibꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Me anteꞌ xi tzyuꞌnte jun mil, bꞌeꞌx xiꞌ ewil teꞌ tpwaq tajaw toj jun jul, ex kux tmiquꞌn toj txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tbꞌajlinxiꞌ jun jteꞌbꞌin abꞌqꞌe, meltzꞌajljo xjal, a kyajawjo aqꞌnil, ex bꞌaj xi tqanin tpwaq teyile junjun tukꞌaxjo taꞌl. ");
INSERT INTO mamC_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nejxix xi xkye tukꞌaꞌ xi tzyuꞌnte jweꞌ mil, ex xi tqꞌoꞌn jweꞌ mil te tajaw tukꞌaxjo juntl jweꞌ miltl, a otaq kanbꞌit tuꞌn. Ex xi tqꞌmaꞌn te: Taa, jweꞌ mil tzaj tqꞌoꞌn weꞌy. Me luꞌ juntl jweꞌ miltl, ma nkanbꞌiy tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Me antej tajaw pwaq xi tqꞌmaꞌn: Chjontiy. Jun aqꞌnil, a tbꞌanilx wen ex tzꞌaqlexix. Atzin jaꞌlin, quꞌn tuꞌn nimx xbꞌant tuꞌn tukꞌa tal chꞌin, nimxixtl kxel nqꞌoꞌn tey. Ku toktza ex ku ttzalaja wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Atzaj teꞌ tkanin juntl aqꞌnil, a xi ttzyuꞌn teꞌ kabꞌe mil pwaq, xi tqꞌmaꞌn: Taa, kabꞌe mil tzaj tqꞌoꞌn weꞌy. Me luꞌ juntl kabꞌe miltl lo, ma nkanbꞌiy tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Xi tqꞌmaꞌn tajaw pwaq te: Chjontiy. Jun aqꞌnil, a tbꞌanilx wen ex tzꞌaqlexix. Atzin jaꞌlin, quꞌn tuꞌn nimx xbꞌant tuꞌn tukꞌa tal chꞌin, nimxixtl kxel nqꞌoꞌn tey. Ku toktza ex ku ttzalaja wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Atzaj teꞌ tkanin aqꞌnil, a xi tzyuꞌnte jun mil, xi tqꞌmaꞌn te tajaw: Taa, bꞌiꞌn wuꞌn qa ay jun xjal kuj, ex qa njyet jun tpwaqa noq tuꞌn taqꞌnbꞌin juntl, ex at tey, me mi n-aqꞌniꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tuꞌnpetziꞌn, bꞌeꞌx in tzaj xobꞌa tey, qa xnajku pwaq wuꞌn. Tuꞌnpetziꞌn bꞌeꞌx xkux nmiquꞌn toj txꞌotxꞌ. Ex luꞌ tpwaqa lo. ");
INSERT INTO mamC_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Atzin xi tqꞌmaꞌn tajaw pwaq te: Jun aqꞌnil, a nya bꞌaꞌn, ex manyor kyꞌajxa. Qa bꞌiꞌntaq tuꞌn, qa at npwaqa noq tuꞌn taqꞌnbꞌin juntl, ex qa at weꞌy, tuꞌn mi nchin aqꞌniꞌn; ");
INSERT INTO mamC_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","tuꞌnpetziꞌn, noqit bꞌeꞌx s-okx tqꞌonjiy npwaqa toj nim ja te kꞌuꞌbꞌl pwaq, tuꞌntzintla, tej ẍin ula jaꞌlin, matla tzꞌetz wiꞌn weꞌ npwaq, ex matla tkanbꞌe manbꞌilte. ");
INSERT INTO mamC_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ex xi tqꞌmaꞌn kyeꞌ iteꞌtaq antza: Kyimiljiꞌy ajo mil pwaq te, ex kyqꞌonxa te a at lajaj mil tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Quꞌn ankyeꞌ at nim te, ex kyjaꞌ kxele txqantl teꞌ, tuꞌn mi bꞌajix. Me anteꞌ, a ntiꞌ at te, majxpeꞌ tal chꞌinl at te, k-elil qꞌiyit. ");
INSERT INTO mamC_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ex atziꞌn aqꞌnil ntiꞌ tajbꞌin, kyqꞌomixa tzma peꞌn toj qxopin kyukꞌa jniꞌ nya nimil, a jaꞌ kchi oqꞌile ex jaꞌ kchi juꞌchꞌile kyste tuꞌn kyixkꞌoj. ");
INSERT INTO mamC_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ok tenl Jesús qꞌmalte: Aj wula, a ayiꞌn Tkꞌwal Ichin, kchin ula tukꞌa nim nqoptzꞌajiyila ex kyukꞌa kykyaqil n-angela wukꞌiy. Ex kchin kꞌwel qeꞌy tibꞌaj nqꞌuqbꞌila kawil kyibꞌaj kykyaqil tukꞌa tkyaqil nqoptzꞌajiyila. ");
INSERT INTO mamC_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ex tkyaqil xjal toj tkyaqil twutz txꞌotxꞌ kchi ul chmet nwutza, ex kchi elil npaꞌnjiꞌy xjal jun tukꞌa juntl, tzeꞌnku jun kyikꞌlel nchi el tpaꞌn rit kyxol chiv. ");
INSERT INTO mamC_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kchi kꞌwel nqꞌoꞌnjiꞌy aye wen xjal, ayeꞌ tzeꞌnqekuꞌ rit, toj nman qꞌobꞌa, ex ayetziꞌn nya wen, ayeꞌ tzeꞌnqekuꞌ chiv, toj nẍnayaja. ");
INSERT INTO mamC_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ex kxel nqꞌmaꞌn ayiꞌn, a Nmaq Kawil, kye ayeꞌ iteꞌ toj nman qꞌobꞌa: Ku kytzaja, ayiꞌy ma chi kubꞌ kyꞌiwliꞌn tuꞌn nMaꞌn. Kyetzinxjiꞌy kyokliꞌn tiꞌjjo tbꞌanilxix Tkawbꞌil nMaꞌn, a bꞌinchin te kyeꞌy, atxix teꞌ tkubꞌku xkye twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Quꞌn tej ttzaj qꞌaqꞌin nkꞌuꞌja, tzaj kyqꞌoꞌn nwaꞌy. Ex tej ttzaj kꞌwaj wiꞌja, tzaj kyqꞌoꞌn nkꞌwaꞌy. Tej woka bꞌetin xjal, tzaj kyqꞌoꞌn nwatbꞌila. ");
INSERT INTO mamC_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ex tej tel bꞌaj nxbꞌaliꞌn, ma chin ok kyktxuꞌn. Ex tej nyabꞌtiꞌy, chi txaꞌja qꞌolbꞌil weꞌy. Ex tej nkuꞌxa toj tze, chi txaꞌja lol weꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ex ayetziꞌn tzꞌaqleqe kchi xel qaninte te: QAjaw, ¿Jtojetzin xqliꞌy ay tukꞌa waꞌyaj, ex ma txi qqꞌoꞌn twaꞌy? ¿Jtojetzin xqliꞌy ay tukꞌa kꞌwaj, ex ma txi qqꞌoꞌn tkꞌwaꞌy? ");
INSERT INTO mamC_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jtojetzin xqliꞌy ay ma tzꞌoka te bꞌetin xjal, ex matla txi qqꞌoꞌn twatbꞌila; ex jaꞌtzin xqlaꞌyiꞌy ay ntiꞌt t-xbꞌaliꞌn tok, ex matla txi qqꞌoꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ex jtojetzin xqliꞌy tuꞌn tyabꞌtiy mo qa tkuxa toj tze, ex o xtajatlaꞌy loltiꞌy? ");
INSERT INTO mamC_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Twutzxix kxel nqꞌmaꞌn ayiꞌn, a nmaq kawil, kyeꞌy: Ex okxix kxel nqꞌmaꞌn kyeꞌy, tkyaqilxjo xkubꞌ kybꞌinchiꞌn tiꞌj jun tal yaj mo tiꞌj jun aꞌla, a kꞌuꞌjlinkxix wuꞌn, toj twutz Dios, wiꞌja s-oke kybꞌinchiniꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ex ikyxjo kxel nqꞌmaꞌn kye iteꞌ toj nẍnayaja: Ku kyela nkꞌatza, quꞌn ma chi kyija tjaqꞌ tqanbꞌil nMaꞌn. Ku kyxiꞌy toj qꞌaqꞌ, a mixla k-yupjilx, bꞌinchinl te kawbꞌil kujxix te tajaw il exqetziꞌn jniꞌ taqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Quꞌn tej tqꞌaqꞌin nkꞌuꞌja, mix tzaje kyqꞌoꞌn nwaꞌy. Ex tej ttzaj kꞌwaj wiꞌja, mix tzaje kyqꞌoꞌn nkꞌwaꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tej woka bꞌetin xjal, mix tzaja kyqꞌoꞌn nwatbꞌila. Ex tej tel bꞌaj nxbꞌaliꞌn, mix in oka kyktxuꞌn. Ex tej nyabꞌtiꞌy, mix i xtajiꞌy qꞌolbꞌil weꞌy. Ex tej nkuꞌxa toj tze, mix i xtajiꞌy lol weꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tuꞌnpetziꞌn, kxel kyqanin: Tata, ¿Jtojetzin xqlontiꞌy tukꞌa waꞌyaj mo qa tukꞌa kꞌwaj, ex tzeꞌn jun bꞌetin xjal, mo qa ntiꞌ t-xbꞌalinja, ex qa yabꞌja mo qa toj tze, ex mix qo mojiꞌn tiꞌja? ");
INSERT INTO mamC_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Me kxel ntzaqꞌwiꞌn: Okxix kxel nqꞌmaꞌn kyeꞌy, tkyaqilxjo mi s-ok kybꞌinchiꞌn kyiꞌjjo tal yaj, mo tiꞌj jun aꞌlaj, ayeꞌ kꞌuꞌjlinqexix wuꞌn; toj twutz Dios, wiꞌja mi s-oke kybꞌinchiniꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ayetziꞌn xjal luꞌn kchi xeꞌl toj najin te jun majx. Me ayetziꞌn tzꞌaqleqe, kchi xeꞌl toj tkabꞌ kychwinqil, a nlayx bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tbꞌajlinxiꞌ tyolin Jesúsjo yol lo, tzaj tqꞌmaꞌn qeꞌy, awoꞌy t-xnaqꞌtzbꞌin: ");
INSERT INTO mamC_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ikytziꞌn tzeꞌnku bꞌiꞌn kyuꞌn, noq kabꞌe qꞌij chꞌintl, tuꞌn tbꞌajjo nintz qꞌij te Xjan Qꞌij, ex ayintzin weꞌ, a Tkꞌwal Ichin, kchin xel qꞌoꞌn toj kyqꞌobꞌxjal, tuꞌn nkubꞌ kybꞌyoꞌn twutz cruz, chi Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kyojjo qꞌij anetziꞌn, aye kynejil pale exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil ex jniꞌ nejinel kyxol aj Judiy ma bꞌaj kychmoꞌn kyibꞌ tojjo tja tnejilxix pale, a Caifás tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ex ma bꞌaj kyjyoꞌn tumil, tzeꞌn tuꞌn ttzyet Jesús kyuꞌn tukꞌa sbꞌubꞌl, ex tuꞌn tkubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Me bꞌaj kyyolin, qa nya toj nintz qꞌij te Xjan Qꞌij, tuꞌntzintla mi bꞌaj jaw tiljxjal kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Attaq Jesús tojjo kojbꞌil Betania toj tja Simun, jun xjal otaq tzꞌel weꞌ tuꞌn txꞌaꞌk. ");
INSERT INTO mamC_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Antza, tzaj laqꞌe jun qya qꞌiꞌntaq jun tal ẍunk tuꞌn, bꞌinchin tuꞌn jun wiq abꞌj tbꞌanilx wen, ex nojnin tukꞌa jun wiq jupsbꞌil manyor wiꞌyil wen, nardo tbꞌi. Tzmataq qꞌuqle Jesús tiꞌj meẍ, tej tok tsuꞌn qya jupsbꞌil tiꞌj twiꞌ Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Me atzaj teꞌ xi qkaꞌyiꞌn, a awoꞌy t-xnaqꞌtzbꞌin, bꞌeꞌx tzaj qqꞌoja, ex o jaw yolbꞌiꞌn tiꞌj, ex xi qqꞌmaꞌn: ¿Tiꞌtzila qe ma txi tyajin qya qꞌanbꞌil anetziꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Noqit noq xi tkꞌayin, matla wiꞌyin, ex atzintlaꞌ pwaq matla txiꞌ te mojbꞌil kye yaj. ");
INSERT INTO mamC_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Atzaj teꞌ tok tbꞌiꞌn Jesús ikyjo, bꞌeꞌx tzaj tqꞌmaꞌn qeꞌy: ¿Tin qe n-ok kyilinjiꞌy qya lo? Quꞌn atzin ma tbꞌinchin wiꞌja tbꞌanilx wen. ");
INSERT INTO mamC_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Quꞌn bꞌapeꞌ kye yaj loqe kye iteꞌ axsa kyxola, me metzin weꞌ, mi chin tenl weꞌ kyukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Quꞌn atziꞌn ma jax tqoꞌn jupsbꞌil wiꞌbꞌaja, noq tuꞌn tbꞌaj tbꞌinchin nxmilila, aj tkux muqet. ");
INSERT INTO mamC_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Twutzxix kxel nqꞌmaꞌn kyeꞌy, jaꞌchaqx kubꞌ yolit teꞌ Tbꞌanil Tqanil wiꞌja tkyaqil twutz txꞌotxꞌ, ex kꞌwel yolitjo ma kubꞌ tbꞌinchin qya wiꞌja te jun naꞌbꞌl tejo qya lo. ");
INSERT INTO mamC_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tbꞌajlinxiꞌ ikyjo, atzin Judas Iscariot, jun t-xnaqꞌtzbꞌin Jesús, bꞌeꞌx xiꞌ kyukꞌa kynejil pale, ");
INSERT INTO mamC_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ex xi tqanin kye: ¿Jteꞌ aku tzaj kyqꞌoꞌn weꞌy, tuꞌn t-xi nqꞌoꞌn Jesús toj kyqꞌobꞌa? Kꞌaꞌ txi qqꞌoꞌn lajaj toj kaꞌwnaq saqpwaq, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Oktzin ten Judas jyol tumil, tzeꞌn tten tuꞌn t-xi tqꞌoꞌn toj kyqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tojjo tnejil qꞌij te Waꞌj Pan, a waꞌj pan ntiꞌ txꞌamsbꞌilte nxiꞌ, o xi laqꞌeꞌy tkꞌatz Jesús, ex xi qqaniꞌn te: ¿Jaꞌtzin tajiy tuꞌn tkubꞌ qbꞌinchinjiꞌy wabꞌj te ikyꞌsbꞌil Xjan Qꞌij? ");
INSERT INTO mamC_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ex tzaj ttzaqꞌwin Jesús: Ku kyxiꞌy toj tnam toj tja jun ichin, ex kyqꞌmanxa te: Chiꞌ xnaqꞌtziljo kyjaluꞌn: Chꞌix tpon or tuꞌn nkyima. Tuꞌnpetziꞌn, waja tuꞌn tkubꞌ ikyꞌsit Xjan Qꞌij toj tjay junx kyukꞌa nxnaqꞌtzbꞌiꞌn chichkujiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ex kubꞌ kybꞌinchin junjun qxola, a awoꞌy t-xnaqꞌtzbꞌin, tzeꞌnkuxjo tzaj tqꞌmaꞌn. Ex kubꞌ kybꞌinchin wabꞌj te Xjan Qꞌij. ");
INSERT INTO mamC_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Atzaj teꞌ qok yupj, kubꞌ qe Jesús tiꞌj meẍ qukꞌiy, a awoꞌy t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ex tzmataq nqo waꞌn, tzaj tqꞌmaꞌn Jesús qeꞌy: Twutzxix kxel nqꞌmaꞌn kyeꞌy, at jun kyeꞌ kxel qꞌoꞌn weꞌy toj kyqꞌobꞌxjal, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tuꞌntziꞌn ikyjo, bꞌeꞌx o bꞌaj jaw bꞌisiꞌn, ex junjunku o ok ten qanilte: WAjaw, ¿Meqa ayiꞌn? qo chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ex tzaj ttzaqꞌwin Jesús qeꞌy: Atziꞌn jun, a nkux tmulin twa junx wukꞌiy; atzin kxel qꞌoꞌn wejiꞌy toj kyqꞌobꞌxjal. ");
INSERT INTO mamC_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Okx kbꞌajilx wiꞌja, ayiꞌn Tkꞌwal Ichin, tzeꞌn ntqꞌmaꞌn Tyol Dios, tuꞌn nxi kꞌayiꞌn. Me atzin kxel kꞌayin weꞌy, noqxpet mi s-ul itzꞌje twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Bꞌeꞌx jaw yolin Judas, a tuꞌntaq t-xi kꞌayinte, ex xi tqꞌmaꞌn: Xnaqꞌtzil, ¿Mej qa ayiꞌn? Xi ttzaqꞌwin Jesús te: Axa ma qꞌmante. ");
INSERT INTO mamC_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nqo waꞌntaqa, tej tjaw ttzyuꞌn Jesús jun pan, ex xi tqꞌoꞌn chjonte te Dios tiꞌj; ex kubꞌ tpiẍin, ex xi tsipin qeꞌy, awoꞌy t-xnaqꞌtzbꞌin, ex tzaj tqꞌmaꞌn: Kywanxjiꞌy lo, quꞌn atzin nxmililjiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ex tzaj ttzyuꞌn jun tkꞌwel kꞌwabꞌj tukꞌa vin, ex xi tqꞌoꞌn chjonte te Dios tiꞌj; xi tqꞌoꞌn qeꞌy, ex tzaj tqꞌmaꞌn: Chi kꞌwaꞌn tojjo tkꞌwel kꞌwabꞌj lo kykyaqilxa, ");
INSERT INTO mamC_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","quꞌn atziꞌn nchkyꞌeljiꞌy, jun akꞌaj tumil, a bꞌantnin tiꞌj tuꞌn Dios, tuꞌn kykyijxjal toj wen tukꞌa. Quꞌn a nchkyꞌela k-elil chitj te chojbꞌil kyilxjal. ");
INSERT INTO mamC_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Me kxel nqꞌmaꞌn kyeꞌy, mi chin kꞌwaꞌntla tiꞌjjo kꞌwabꞌj luꞌn tzmaxiꞌ aj qkꞌwan junx kyukꞌiy tzma toj Tkawbꞌil nMaꞌn toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tej tbꞌaj qbꞌitziꞌn jun bꞌitz, bꞌeꞌx o xiꞌy twiꞌ wutz Olivos. ");
INSERT INTO mamC_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Teꞌ qkaniꞌn antza, tzaj tqꞌmaꞌn Jesús qeꞌy: Tojjo qnikyꞌin luꞌn, jotqexa k-elil tqꞌuqbꞌil kykꞌuꞌja wiꞌja, tzeꞌnkuxjo ntqꞌmaꞌn toj Tuꞌjil Tyol Dios: Kꞌwel nbꞌyonjiꞌy kyikꞌlel, ex ayetziꞌn rit kchi bꞌajelil tilj, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Me ajtzin njaw anqꞌiꞌntla, kchin kꞌwel neja kywutza toj Galiley. ");
INSERT INTO mamC_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Me ante Pegr xi ttzaqꞌwin: Ex qa kykyaqilx s-el kyiꞌn tqꞌuqbꞌil kykꞌuꞌj tiꞌja, me mina weꞌ, chi Pegrjo. ");
INSERT INTO mamC_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Me xi tqꞌmaꞌn Jesús te: Twutzxix kxel nqꞌmaꞌn teꞌy, tojxjo qnikyꞌin lo, a naꞌmtaqx toqꞌ tman ekyꞌ, otaq chin kubꞌ tewiꞌn oxe maj kywutzxjal, ex kxel tqꞌmaꞌn kye qa nya ojtzqiꞌnqiꞌn tuꞌnch. ");
INSERT INTO mamC_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ex xi tqꞌmaꞌn Pegr: Exla qa ma chin kyim weꞌ tukꞌiy, me nlayx kubꞌ wewiꞌn. Ex ikyxjo qqꞌmaꞌy qkyaqila. ");
INSERT INTO mamC_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx xiꞌ Jesús qukꞌiy toj jun najbꞌil, Getsemaní tbꞌi. Tej qkaniꞌn antza, tzaj tqꞌmaꞌn Jesús qeꞌy: Ku kykyij qeꞌy tzaluꞌn. Ma chinka naꞌl Dios tzachiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Oꞌkqex Pegr i xi tkꞌleꞌn exqetziꞌn tkꞌwal Zebedey, a Juan ex Santyaw, ex tzaj txqan bꞌis toj tanmin ex txqan tzqij tzibꞌaj, ");
INSERT INTO mamC_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ex xi tqꞌmaꞌn kye: Ma tzajx txqan bꞌis toj wanmiꞌn, nyakutzaj chin kyimila. Chi tenkjtziꞌn tzaluꞌn, me noq tzaj kywatla. ");
INSERT INTO mamC_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Xi laqꞌe Jesús najchaq chꞌintl kykꞌatz, ex kubꞌ mutxe twutz txꞌotxꞌ naꞌl Dios, ex chiꞌ kyjaluꞌn: NMaꞌn, chin tklomila te tkyaqil jniꞌ kkyꞌelix wuꞌn; me noqit nya a tzeꞌnku waja, qalaꞌ atla tzeꞌnkuxjo taja. ");
INSERT INTO mamC_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Bꞌeꞌx meltzꞌaj kykꞌatz oxe t-xnaqꞌtzbꞌin. Atzaj teꞌ tul kykꞌatz, xi tqꞌmaꞌn te Pegr: ¿Ma mitzin s-elx jun or kywatla wukꞌiy? ");
INSERT INTO mamC_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kyimil kywatla, ex kux chi bꞌaj naꞌn Dios, tuꞌn mina chi kubꞌ tzꞌaqa toj tqꞌobꞌ tajaw il, quꞌn kyaja tuꞌn tkubꞌ kybꞌinchinjiꞌy a taj Dios, me alkyetz kuj n-ele te kyeꞌy tuꞌn tbꞌant. ");
INSERT INTO mamC_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xiꞌ toj tkabꞌ majin naꞌl Dios. Chiꞌ kyjaluꞌn: Ay nMaꞌn, qa ntiꞌx tumil tuꞌn mi tzikyꞌx xiꞌ luꞌn wuꞌn, bꞌinchimtzinjiy a taja wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tej tmeltzꞌaj juntl majl kykꞌatzjo t-xnaqꞌtzbꞌin, ex ikyxljo, nchi ktantaql, teꞌ kyel knetl tuꞌn, quꞌn mix kypaꞌyix watl. ");
INSERT INTO mamC_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ex bꞌeꞌx i kyij ttzaqpiꞌn, ex bꞌeꞌx xiꞌ toj tox majin naꞌl Dios. Ex ayex tyoljo i xi tqꞌmaꞌn toj tnaꞌj Dios. ");
INSERT INTO mamC_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Atzaj teꞌ tmeltzꞌaj jaꞌ iteꞌye oxe t-xnaqꞌtzbꞌin, xi tqꞌmaꞌn kye: ¿Ma tzunxsin nchi ktaꞌn, ex nchi ajlaꞌn? Ma pon or tuꞌn nxi qꞌoꞌn ayiꞌn, a Tkꞌwal Ichin, toj kyqꞌobꞌ aj il. ");
INSERT INTO mamC_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Kux chi jaw weꞌksa! ¡Qoꞌqe! Quꞌn luꞌ tzul a kxel kꞌayin weꞌy. ");
INSERT INTO mamC_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tzmataq nyolin Jesús, teꞌ tul Judas, a jun t-xnaqꞌtzbꞌin. Ex lipcheqektaq txqan xjal tiꞌj, qꞌimile jniꞌ kykxbꞌil, a at kyste te bꞌiꞌybꞌil, ex jniꞌ kytze te kybꞌujbꞌil. Aye xjal luꞌn otaq chi tzaj kychqꞌoꞌn kynejil pale ex kyuꞌn nejinel kyxol aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Otaq bꞌaj tqꞌmaꞌn Judas kye, tzeꞌn ttxolil tuꞌn tel tnikyꞌtzajil: Ankyeꞌ k-okil nmaꞌtziꞌn, atziꞌn. Bꞌeꞌx kꞌaꞌ tzꞌok kytzyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tuꞌnpetziꞌn, tzaj laqꞌexix tkꞌatz Jesús, ex xi tqꞌmaꞌn: Chin qꞌolbꞌiꞌn, Xnaqꞌtzil, chiꞌ. Exsin el tmaꞌtzin Judas Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Xi tqꞌmaꞌn Jesús te: ¡Ay wukꞌa! Ankye ma tzula bꞌinchilte, ¡Bꞌinchinkutziꞌn! Bꞌeꞌxsin i tzaj laqꞌe txqantl, ex ok kytzyuꞌn Jesús, ex el qititin kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Me attaq jun tukꞌa Jesús jatz tiꞌn tkxbꞌil toj tja, ex el tjaspin tẍkyin jun taqꞌnil tnejilxix pale. ");
INSERT INTO mamC_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Me xi tqꞌmaꞌn Jesús: Qꞌonkux tkxbꞌila toj tkubꞌil. Quꞌn kykyaqilxjo nchi bꞌujin tukꞌa kxbꞌil, ex tukꞌa kxbꞌil kchi kyimile. ");
INSERT INTO mamC_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ma mitzin bꞌiꞌn tuꞌn, noqit waja txi nqaniꞌn te nMaꞌn, tuꞌn ttzaj tsmaꞌn jun kabꞌlajaj chꞌuq angel klol weꞌ, jaꞌlinxitla tzaj tqꞌoꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Me qa ma kubꞌ nbꞌinchiꞌn ikyjo, ¿Tzeꞌntzin ttentz tuꞌn tjapiꞌn a tzꞌibꞌiꞌn toj Tuꞌjil Tyol Dios, qa iltaq tiꞌj tuꞌn tbꞌaj tkyaqiljo ikyjo? ");
INSERT INTO mamC_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ex bꞌeꞌx xi tqanin Jesús kye jniꞌ xjal: ¿Tiquꞌn ma chi ula tukꞌa kykxbꞌila ex jniꞌ kytzeꞌy, tuꞌn nxi qititiꞌn kyuꞌn nyakuj jun ileqꞌqiꞌn toj kywutza? ¿Ma nyatzin nchin xnaqꞌtziꞌn kyxola toj tnejil ja te naꞌbꞌl Dios tkyaqil qꞌij? ¿Tiquꞌn mix in ele qititintza kyuꞌn antza? ");
INSERT INTO mamC_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","¡Me nya tiquꞌnil! Quꞌn tkyaqiljo lo bꞌantninl tiꞌj tuꞌn tjapiꞌn tzeꞌnku kyyoleꞌ yolil Tyol Dios ojtxe, ex i kubꞌ tzꞌibꞌin tojjo Tuꞌjil Tyol Dios. Ex bꞌeꞌx kyij qtzaqpiꞌn, a awoꞌy t-xnaqꞌtzbꞌin, tjunalx. Bꞌeꞌx o bꞌaj kubꞌe toj bꞌe. ");
INSERT INTO mamC_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Me ayetziꞌn i xi tzyuꞌnte Jesús twutz Caifás, a kynejilxix pale, a jaꞌ otaq tzꞌoke kychmoꞌne kyibꞌjo jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn nejinel kyxol aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Me najchaq lipchexitaq Pegr tzma tpeꞌn tja kynejilxix pale, a jaꞌ otaq tzꞌokxi Jesús, ex kyij qe antza kyxol xoꞌl qꞌaqꞌ yolte tiꞌtaq kbꞌajil tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ayetziꞌn kynejil pale exqetziꞌn kynejilxjal, ex kykyaqilxjo txqantl kawil nchi bꞌaj jyontaq tumil exla qa nya twutz, tzeꞌn tten tuꞌn tkubꞌtaq tzꞌaq toj jun til, tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Me mix ja knete jun til kyuꞌn, exla qa ma nintzxjal o tzaj patilte. Me tbꞌajlinxiꞌ ikyjo, i kaninxpen kabꞌetz qꞌmalte: ");
INSERT INTO mamC_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Atzin ichin lo o tqꞌma, qa tuꞌntaq tkubꞌ tyuchꞌin tnejil ja te qnaꞌbꞌl Dios, ex toj oxe qꞌij noq bꞌantninl t-xel tuꞌnch. ");
INSERT INTO mamC_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Me anteꞌ tnejilxix pale jaw weꞌks, ex xi tqanin te Jesús: ¿Tiquꞌn mi ntzaj ttzaqꞌwiꞌn chꞌin? ¿Tiꞌxsiꞌn nkyqꞌmaꞌnxjal tiꞌja? ");
INSERT INTO mamC_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Me ntiꞌx te Jesús xi ttzaqꞌwin. Me xi tqꞌmaꞌn tnejilxix pale te: Twutz Dios itzꞌ ex tiꞌj tbꞌi, kxel nqaniꞌn teꞌy tuꞌn ttzaj tqꞌmaꞌn, qa twutzxix qa ajiy Crist, a Tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Xi ttzaqꞌwin Jesús: Ikytziꞌn tzeꞌnku ma tqꞌmay. Ex ikyx wejiꞌy kxel nqꞌmaꞌn: Ok kylaꞌbꞌila a ayiꞌn Tkꞌwal Ichin, aj nkubꞌ qeꞌy toj tman qꞌobꞌjo Dios, a nimxix tipin, ex aj nmeltzꞌaja toj muj toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Teꞌ tqꞌmante ikyjo, noqx el kyimjo kynejilxix pale, ex bꞌeꞌx xi lipin laqil kye t-xbꞌalin tuꞌn tqꞌoj, ex tqꞌma: Ayetziꞌn tyoljo maꞌ ichin luꞌn noq nxoꞌn yol tiꞌj Dios. ¿Tiqeꞌ txqantl tstiyil qe? A ayekuy ma chi bꞌin teꞌ tyol, a nya wenqe. ");
INSERT INTO mamC_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Mo tzeꞌn chꞌin kyeꞌ toj kywutz? Ex atzin kyexjal xi kytzaqꞌwin: Axte at tpaj tiꞌjx, ex toj tilx tuꞌn tkyim, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tuꞌnpetziꞌn, bꞌeꞌx bꞌaj joꞌkx kytzuꞌbꞌin toj twutz, ex bꞌaj kybꞌyoꞌn. Ex junjuntl bꞌaj okx tzꞌajchinte toj twutz, ");
INSERT INTO mamC_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ex xi kyqanin te: Qa ajiy Crist, a skꞌoꞌnxix tuꞌn Dios, pontzin tiꞌj, ankyeꞌ s-ok tzꞌajchintiy. ");
INSERT INTO mamC_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ex qꞌuqletaq Pegr twiꞌ peꞌn, tej t-xi laqꞌe jun txin tkꞌatz, a bꞌinchil wabꞌj. Ex xi tqꞌmaꞌn te: Ex ikyx tejiy; ajintaq te nbꞌettaq tukꞌa Jesús aj Galiley. ");
INSERT INTO mamC_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Me bꞌeꞌx kubꞌ tewin Pegr twutz tkyaqil, ex xi tqꞌmaꞌn: Ntiꞌ bꞌiꞌn wuꞌn tiꞌ qiꞌjil nyoliniych. ");
INSERT INTO mamC_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ex bꞌeꞌx xi laqꞌe twutz tjpel ja, jaꞌ iwle tuꞌn juntl. Ex xi tqꞌmaꞌn kye txqantl: Ex ikyx teꞌ luꞌn nbꞌettaq tukꞌa Jesús aj Nazaretch. ");
INSERT INTO mamC_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ex bꞌeꞌx kubꞌ tewin Pegr juntl majl: Twutzx Dios kxel nqꞌmaꞌn, mi ojtzqiꞌn wejiꞌy ichin anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Me matxitaq chꞌintl, jniꞌ iteꞌtaq antza i xi laqꞌe tkꞌatz Pegr, ex xi kyqꞌmaꞌn te: Ex ikyx tejiy ajin te kyukꞌa, quꞌn noq tiꞌjjo yoliꞌn n-ele qnikyꞌa tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Me oktzin ten Pegr qꞌol qanbꞌil tibꞌajx, ex xi tqꞌmaꞌn: Twutz Dios, mi ojtzqiꞌnx wejiꞌy ichin wuꞌn anetziꞌn. Ex njawku oqꞌ ekyꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ex bꞌeꞌx ul julkꞌaj toj tkꞌuꞌj Pegr tiꞌj tqꞌma Jesús te: A naꞌmxtaq toqꞌ ekyꞌ, ok kchin kꞌwel tewiꞌn oxe maj. Ex bꞌeꞌx etz Pegr antza, ex ox tzꞌoqꞌx wen. ");
INSERT INTO mamC_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Atzaj teꞌ qsqix, kykyaqiljo kynejil pale ex jniꞌ nejinel kye Judiy i bꞌaj kyij bꞌant, tuꞌn tkubꞌ bꞌyet Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ex bꞌeꞌx bꞌaj kyjtzꞌoꞌn, ex xi kyiꞌn, ex xi kyqꞌoꞌn toj tqꞌobꞌ Pilat, aj kawil. ");
INSERT INTO mamC_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ante Judas, a xi kꞌayinte, tej tok tkaꞌyin tkyij bꞌant tiꞌj tuꞌn tkyim Jesús, ulx toj tkꞌuꞌj, ex bꞌeꞌx aj tmeltzꞌin aj lajaj toj kaꞌwnaq saqpwaq tzaj ttzyuꞌn kye kynejil pale exsin kynejilxjal aj Judiy, ");
INSERT INTO mamC_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ex xi tqꞌmaꞌn: Ma chin bꞌinchiꞌn il, tuꞌn xi nkꞌayiꞌn jun xjal, a ntiꞌ til. Me ankyexjal xi kytzaqꞌwin: ¿Yajtzin qeꞌ? ¿Tiꞌn qeꞌ qaj tiꞌj teꞌ? Kꞌaꞌ tli tejiy. ");
INSERT INTO mamC_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Me ante Judas bꞌeꞌx xi t-xoꞌn pwaq toj tnejil ja te naꞌbꞌl Dios, ex bꞌeꞌx xiꞌ, ex bꞌeꞌx jaw tjtzꞌoꞌn tqul te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ayetzin kyeꞌ kynejil pale, jaw kyiꞌn pwaq, ex kyqꞌma: Mi kux mujbꞌit teꞌ pwaq luꞌn toj kꞌuꞌbꞌl oyaj toj tja Dios, quꞌn ma tzꞌokin te loqꞌbꞌil jun chwinqil, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tuꞌnpetziꞌn, bꞌeꞌx kyij bꞌant, tuꞌn tlaqꞌet jun txꞌotxꞌ, toktaq tbꞌi te Ttxꞌotxꞌil Bꞌinchil Kꞌwil, tuꞌn pwaq anetziꞌn, jaꞌ tuꞌn kybꞌaj kux muqetjo jniꞌ bꞌetin xjal toj Jerusalén, aj kykyim. ");
INSERT INTO mamC_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tuꞌnpetziꞌn, bꞌeꞌx kyijx tbꞌi txꞌotxꞌ anetziꞌn: Ttxꞌotxꞌil Chikyꞌ; ax tbꞌi tok jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ikytziꞌn japine bꞌajjo yol, a kyij ttzꞌibꞌin Jeremías, a yolil Tyol Dios ojtxe, tej tqꞌma: Tzaj kytzyuꞌn lajaj toj kaꞌwnaq saqpwaq, a twiꞌ ok kyqꞌoꞌn aj Israel. ");
INSERT INTO mamC_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tuꞌntzintzjo lo, tzaj kylaqꞌoꞌn jun txꞌotxꞌ, a ttxꞌotxꞌil bꞌinchil kꞌwil, tzeꞌnkuxjo tqꞌma tAjaw Tkyaqilch. ");
INSERT INTO mamC_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Xi qꞌiꞌn Jesús twutz Pilat, a aj kawil, exsin xi tqanin te: ¿Atzinjiy a nmaq kawil kye Judiych? Axa ma qꞌmante, chi Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ayetzin kyeꞌ kynejil pale exqetziꞌn jniꞌ nejinel kyxolx Judiy i ok ten stzꞌimil tiꞌj. Me ntiꞌ te Jesús xi ttzaqꞌwin. ");
INSERT INTO mamC_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Pilat te: ¿Ma mitzin ntbꞌinjiy tkyaqiljo nkyqꞌmaꞌnxjal tiꞌja? ");
INSERT INTO mamC_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Me ntiꞌ jun te Jesús tyol xi ttzaqꞌwin. Ex noqx jaw kaꞌylaj Pilat. ");
INSERT INTO mamC_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Me ante Pilat, a aj kawil, aj tikyꞌ junjun Xjan Qꞌij, kukx nxi ttzaqpiꞌntaq jun xjal, a tkuꞌxtaq toj tze. Me nejtaq nxi tqanin alkye kyajxjal tuꞌn t-xi tzaqpet. ");
INSERT INTO mamC_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Me kyojjo qꞌij anetziꞌn, attaq jun xjal tkuꞌxtaq toj tze, nimxtaq tyolajtz, Barrabás tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Atzaj teꞌ tok kychmoꞌnxjal kyibꞌ, xi tqanin Pilat kye: ¿Ankyeꞌ kyaja tuꞌn t-xi ntzaqpiꞌn: A Barrabás, mo a Jesúsj, a tok tbꞌi te Crist? chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Xi tqanin kyexjal, quꞌn otaq tzꞌel tnikyꞌ te, qa noq tuꞌn tlochꞌj kykꞌuꞌj kynejil pale, otaq txi kyqꞌoꞌne Jesús tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Me tzmataq tokx Pilat toj tkawbꞌil, tej t-xi tsmaꞌn t-xuꞌjil tqanil te: Mi tzꞌok tqꞌoꞌn tibꞌa tiꞌj Jesús, a tzꞌaqle, quꞌn ma tzꞌok jun nwutzikyꞌa atximay qnikyꞌin, me tixqex wen, noq tuꞌn tpajjo ichin anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Me ayetzin kyeꞌ kynejil pale exqetziꞌn nejinel kye aj Judiy, i bꞌaj kyxmoxin jniꞌ xjal, tuꞌn t-xi kyqanin tuꞌn t-xi ttzaqpiꞌn Barrabás, ex tuꞌn tkubꞌ bꞌyoꞌn Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Me xi tqanin Pilat kye: ¿Ankyeꞌ kyaja kyxoljo kabꞌe, tuꞌn t-xi ntzaqpiꞌn? A Barrabás, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ex xi tqanin Pilat kye: ¿Tzeꞌntzin k-okile Jesústz wuꞌn, a tok tbꞌi Crist? Xi kytzaqꞌwin kykyaqilx: Pejkꞌinka twutz cruz, tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xi tqanin Pilat kye: ¿Tiquꞌn? ¿Tiꞌxsiꞌn nya wen ma tbꞌinche? Me i jaw ẍchꞌinxjal juntl majl: Pejkꞌinka twutz cruz, tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tej tok tkaꞌyin Pilat, ntiꞌxtaq tumil tuꞌn tcheꞌwx kywiꞌxjal, qalaꞌ noqx kyjaꞌtaq txiꞌ toj il, xi tqanin chꞌin aꞌ, tuꞌn ttzaj qꞌiꞌn, exsin el ttxjoꞌn tqꞌobꞌtz kywutzxjal te jun yekꞌbꞌil qa nya ajintaq tiꞌj Jesús, exsin xi tqꞌmaꞌntz: ¡Ntiꞌx weꞌ npaj tiꞌj tkyimliꞌn xjal lo, quꞌn ntiꞌx til! ¡Kyukꞌaxlaꞌy taꞌye luꞌn! ");
INSERT INTO mamC_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ex kykyaqilxjal xi kytzaqꞌwin: Kꞌaꞌ qliꞌy kyukꞌax qkꞌwala, quꞌn awoꞌy at qpaj tiꞌjjo tkyimlin. ");
INSERT INTO mamC_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Bꞌeꞌxsin xi ttzaqpiꞌn Pilattz a Barrabás, ex xi tqꞌmaꞌn tuꞌn ttzyet tjubꞌchajtz Jesús, ex xi tqꞌoꞌn, tuꞌn tok kypejkꞌin twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tbꞌajlinxiꞌ ikyjo, ayetziꞌn xoꞌl qꞌaqꞌ te kawil, xi kyiꞌn Jesús toj ja te kawbꞌil, ex ok kychmoꞌn tkyaqil chꞌuq xoꞌl qꞌaqꞌ tiꞌjile. ");
INSERT INTO mamC_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ex bꞌeꞌx el kyiꞌn t-xbꞌalin, ex ok kyqꞌoꞌn juntl xbꞌalin tiꞌj, kyaq kaꞌyin, tzeꞌnku kyxbꞌalin jun nmaq kawil. ");
INSERT INTO mamC_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jax kysiꞌpin jun tqan txꞌiꞌx toj twiꞌ tukꞌax ttxꞌiꞌxil. Ex xi kyqꞌoꞌn jun tze toj tman qꞌobꞌ tzeꞌnkuꞌ kyvar nmaq kawil. Exsin i kubꞌ meje twutz, me noq tuꞌn kyxmayin tiꞌj, ex xi kyqꞌmaꞌn te: Nimxit tbꞌiy, ay nmaq kawil kye aj Judiy, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ex bꞌaj ok kytzuꞌbꞌin tiꞌj, ex axjo ttze el kyiꞌn, tuꞌn tkux kyjemin toj twiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tej kybꞌaj xmayin tiꞌj, el kyiꞌn t-xbꞌalin, a ok kyqꞌoꞌn, ex ok kyqꞌoꞌnljo axjo t-xbꞌalintaq toktaq, ex bꞌeꞌxsin xi kyiꞌntz, tuꞌn tjaw pejkꞌin twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tej kyetz antza, jyet jun ichin kyuꞌn aj Cirene, Simun tbꞌi, ex ok kyqꞌoꞌn il tij tuꞌn t-xi tiqin tcruz Jesús, ");
INSERT INTO mamC_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","tuꞌn tpon tzma toj jun najbꞌil Gólgota tbꞌi, atzin tzꞌelpineꞌ bꞌibꞌaj ikyjo: Jaꞌ taꞌ tbꞌaqil twiꞌ kyimnin. ");
INSERT INTO mamC_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Antza xi kyqꞌoꞌne vin te tkꞌwa Jesús smaꞌnkux tukꞌa taꞌl kꞌul manyor kꞌax wen, tuꞌn mi tnaꞌye kyixkꞌoj. Me atzaj teꞌ tkubꞌ tnikyꞌbꞌin Jesús, mix xaꞌye tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Atzaj teꞌ tbꞌaj kypejkꞌin twutz cruz, ayetziꞌn xoꞌl qꞌaqꞌ i bꞌaj ok ten saqchal tiꞌjjo t-xbꞌalin Jesús; ex bꞌaj jaw kyxoꞌn kyxol, ex ankye tuꞌn tkanbꞌin tiꞌj. Quꞌn iltaq tiꞌj tuꞌn tjapiꞌn a kubꞌ ttzꞌibꞌin yolil Tyol Dios ojtxe: Kubꞌ kysipin nxbꞌaliꞌn kyxol, ex i bꞌaj saqchan tiꞌjch. ");
INSERT INTO mamC_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ex bꞌeꞌx i bꞌaj kubꞌ qe xqꞌuqilte. ");
INSERT INTO mamC_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ok kypejkꞌin jun tzꞌlan tibꞌaj twiꞌ, jaꞌ tzꞌibꞌinke tiquꞌnil kubꞌ kybꞌyoꞌne. Chiꞌ kyjaluꞌn: Ate Jesúsjo, a Nmaq Kawil kye aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ex i jaw pejkꞌinl kabꞌe ileqꞌ tukꞌa twutz cruz, jun toj tman qꞌobꞌ ex jun toj tẍnayaj. ");
INSERT INTO mamC_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ex jniꞌqe xjal nchi bꞌaj ikyꞌxtaq antza, noqx nchi bꞌaj yasintaq tiꞌj, ex noqx nja kyyekin tiꞌj kywiꞌ te kyxmaybꞌil tiꞌj, ");
INSERT INTO mamC_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ex nxi kyqꞌmaꞌntaq: ¿Nyakutzin atejiy nqꞌmante tuꞌn tjaw yuchꞌin teꞌ tnejil ja te naꞌbꞌl Dios, exsin tuꞌn tbꞌant juntl tuꞌn toj oxe qꞌij? Klomiltzin tibꞌa jaꞌlin, ex qꞌinkutz tibꞌa twutz cruz, qa twutzxix qa ajiy Tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ex ikyxjo, nchi bꞌaj xmayintaqjo jniꞌ kynejil pale exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil junx kyukꞌa nejinel kyxol aj Judiy, ex nkubꞌ kyqꞌmaꞌntaq twutz Jesús, me noq tuꞌn tok tbꞌiꞌn: ");
INSERT INTO mamC_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","¿Tzeꞌn tten nbꞌaj klettaq junjuntl xjal tuꞌn, me antetz, mix klet-x tuꞌnx tibꞌ? ¿Ma nyaꞌtziꞌn nmaq kawil qibꞌaj, a awo aj Israel? In tkuꞌtz twutz cruz jaꞌlin, tuꞌn t-xi qnimin. ");
INSERT INTO mamC_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Quꞌn qꞌuqletzila tkꞌuꞌjtz tiꞌj Dios. In tklettz tuꞌn Dios jaꞌlin, qa twutzx qa taj Dios tiꞌj. ¿Ma nyatzin axtz qꞌmante, qa Tkꞌwal Dios? ");
INSERT INTO mamC_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ex majqexpe ileqꞌ, ayeꞌ pejkꞌinqektaq tukꞌa twutz cruz, i bꞌaj xmayintaq tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Teꞌ tok kabꞌlaj qꞌij, ex tzmaxi toj oxe or te qale, bꞌeꞌx ok yupj twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ax orjo jaw ẍchꞌin Jesús kujxix wen, ex tqꞌma: Eli, Eli, ¿Lama sabactani? Atzin tzꞌelpineꞌ yol lo, NMan Dios, nMan Dios, ¿Tiꞌxsin quꞌn ma chin kyij ttzaqpiꞌn? ");
INSERT INTO mamC_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ayetziꞌn junjun iteꞌtaq antza ok kybꞌiꞌn, ex kyqꞌma: Lu nqꞌolbꞌin tiꞌj Elías, a yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ex jun paqx el rinin jun jyolte chꞌin bꞌuꞌẍ. Kux tmulin toj vin txꞌam, ex ok tkꞌloꞌn tiꞌj twiꞌ jun ptzꞌan, tuꞌn t-xi tkꞌwaꞌn Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Me ayetzin kyeꞌ txqantl xi kyqꞌmaꞌn: Ex tenkuj. Jekytzin tzul Elías klolte. ");
INSERT INTO mamC_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ex jaw ẍchꞌin Jesús juntl majl kujxix wen, teꞌ tel kyim. ");
INSERT INTO mamC_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Atzin xbꞌalin tokxtaq tojjo tnejil ja te naꞌbꞌl Dios, bꞌeꞌx kubꞌ laqj te kabꞌe; tzaj xkye tiꞌjjo ttxaꞌn jawl, tuꞌn tkꞌuꞌl kanin tiꞌjjo juntl ttxaꞌn. Ex tzaj luꞌlin txꞌotxꞌ, ex jniꞌ abꞌj bꞌeꞌx bꞌaj kubꞌ kaꞌmin, ");
INSERT INTO mamC_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","exqetziꞌn jniꞌ kyja kyimnin bꞌeꞌx bꞌaj xi pax, ex ma nintzx nimil tiꞌj Dios, bꞌeꞌx i bꞌaj jatz anqꞌintl. ");
INSERT INTO mamC_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jniꞌqe, a otaq chi etz toj muqbꞌilkye, tej tjawlin xi anqꞌin Jesús, bꞌeꞌx i bꞌaj xiꞌ tojjo xjan tnam Jerusalén, jaꞌ i oke kaꞌyin kyuꞌn nimkuxjal. ");
INSERT INTO mamC_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ajo kynejinel xoꞌl qꞌaqꞌ aj Rom, exqetziꞌn nchi xqꞌuqintaq tiꞌj Jesús, tej kynaꞌnte kyaqnajnabꞌ ex tkyaqiltaqjo nbꞌaj, tzajxix nim kyxobꞌil, ex kyqꞌma: Twutzx tetz Tkꞌwal Diostaq teꞌ ichin lo. ");
INSERT INTO mamC_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ex iteꞌtaq txqan qya antza nchi kaꞌyintztaq najchaq, ayeꞌ i ok lipe tiꞌj Jesús, atxix toj txꞌotxꞌ te Galiley, ex aye nchi mojintaq tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ex kyxoljo qya anetziꞌn, attaq Mariy, aj Xleꞌn; exsin Mariy, a tnanataq Santyaw ex Jse; exsin kynana tkꞌwal Zebedey. ");
INSERT INTO mamC_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tej qok yupj, kanin Jse aj Arimatey, jun ichin qꞌinin, a otaq tzꞌok lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Xiꞌ Jse tukꞌa Pilat qanil t-xmilil Jesús, ex xi tqꞌmaꞌn Pilat, tuꞌn t-xi kyqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kuꞌtz tiꞌn Jse t-xmilil Jesús, ex kubꞌ tbꞌaltzꞌin toj jun iqbꞌil tbꞌanilx wen. ");
INSERT INTO mamC_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ex attaq jun jul aꞌkxtaq tbꞌaj tbꞌinchin twutz piky tuꞌntaq tajbꞌin te. Antza okxi tqꞌoꞌn t-xmilil Jesús, ex ok tjpuꞌn tukꞌa jun ma tij abꞌj, ex bꞌeꞌx aj. ");
INSERT INTO mamC_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Me ante Mariy, aj Xleꞌn, tukꞌaxjo juntl Mariy i kyij qe ttzi jul. ");
INSERT INTO mamC_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Toj junxil qꞌij, a tojjo qꞌij te ajlabꞌl, ayetziꞌn kynejil pale kyukꞌaxjo jniꞌ Parisey i bꞌaj xiꞌ qꞌolbꞌilte Pilat. ");
INSERT INTO mamC_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ex xi kyqꞌmaꞌn te: Tata, noq samiꞌy; ma tzul julkꞌaj toj qkꞌuꞌja, qa aj maꞌ sbꞌul xjal tqꞌma, tej naꞌmtaq tkyim, qa oxe qꞌijtaq tkyimlin, aj tjatz anqꞌin juntl majl kyxol kyimnin. ");
INSERT INTO mamC_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tuꞌnpetziꞌn, aj tjapin oxe qꞌij, kyjpunkxixjiꞌy ttzi jul wen, quꞌn noq chi uljo t-xnaqꞌtzbꞌin qnikyꞌin elqꞌil teꞌ t-xmilil, tuꞌn tkubꞌ kyqꞌmaꞌntz kyexjal, qa ma jatz anqꞌintl juntl majl. Quꞌn apen sbꞌubꞌljo nimxixtl tzeꞌnku tnejil. ");
INSERT INTO mamC_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Me ante Pilat xi tqꞌmaꞌn: Ex iteꞌ kyxoꞌl qꞌaqꞌa. Kyqꞌoꞌnqekja te xqꞌuqilte. Ku kyxiꞌy ex noqit tzeꞌn tzꞌoka chꞌintl tuꞌn tjpet-xix. ");
INSERT INTO mamC_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bꞌeꞌxsin i xiꞌtz, jpulte wen, ex ok kyqꞌoꞌn juntl jupbꞌilte, tuꞌn mi yekꞌjex. Ex kyij kyoqxenin kye xoꞌl qꞌaqꞌ, tuꞌn mi chi ikyꞌ ktaneꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tbꞌajlinxiꞌ qꞌij te ajlabꞌl, kyjaꞌtaq qsqix toj tnejil qꞌij te seman, ate Mariy, aj Xleꞌn, tukꞌaxjo juntl Mariy, i xiꞌ tzma ttzi jul lolte. ");
INSERT INTO mamC_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Texjo tqan ttzaj kyaqnajnabꞌ kujxix. Ox luꞌlinx txꞌotxꞌ, quꞌn jun t-angel tAjaw Tkyaqil kuꞌtz toj kyaꞌj, ex ul ttzi jul. El tiꞌn ma tij abꞌj, a toktaq te jupbꞌilte, ex kubꞌ qe tibꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Me ante angel tzunxtaq nqoptzꞌajx tzeꞌnku xloqꞌlin kyaꞌj, ex tok jun t-xbꞌalin manyor sjaninx wen, tzeꞌnku ttxa cheꞌw. ");
INSERT INTO mamC_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Atzaj teꞌ tok kykaꞌyin xoꞌl qꞌaqꞌ, bꞌeꞌx i jaw luꞌlin, ex bꞌeꞌx i el kyim tuꞌn kyxobꞌil. ");
INSERT INTO mamC_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Xi tqꞌmaꞌn angel kyeꞌ qya: Mi chi xobꞌa. Bꞌiꞌn weꞌ wuꞌn, qa nchi jyoꞌn tiꞌj Jesús, a jaw pejkꞌin twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Me ntiꞌ tetz tzaluꞌn jaꞌlin. Qalaꞌ ma jaw anqꞌintl, tzeꞌnkuxjo tqꞌma. Ku kytzaja lolte jaꞌ kubꞌe qꞌoꞌne. ");
INSERT INTO mamC_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ex jun paqx ku kyxiꞌy qꞌmalte kyeꞌ t-xnaqꞌtzbꞌin, qa ma jaw anqꞌintl kyxol kyimnin, ex ok knejil kywutza toj txꞌotxꞌ te Galiley. Ex antza k-okile kykaꞌyiꞌn. Ataqtzin tuꞌn t-xi nqꞌmaꞌnjiꞌy kyeꞌy. Atzin jaꞌlin, ¡Ma kybꞌiꞌy! ");
INSERT INTO mamC_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ayen kyej qya jun paqx i etz rinin ttzi jul tuꞌn kyxobꞌil ex tuꞌn kytzaljbꞌil. Nchi ajqelin wen tuꞌn kyxiꞌ qꞌmalte kye txqantl. ");
INSERT INTO mamC_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tzunxtaq nchi rinin wen, tej tkubꞌ tyekꞌin Jesús tibꞌ kywutz, ex i ok tqꞌolbꞌin. Ex i xi laqꞌe tkꞌatz, i tzaj kychleꞌn tqan, ex i kꞌulin twutz. ");
INSERT INTO mamC_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ex xi tqꞌmaꞌn Jesús kye: Mi chi xobꞌa. Ku kyxiꞌy qꞌmalte kye txqantl, ayej lipcheqektaq wiꞌja, tuꞌn kyxiꞌ tzmax toj txꞌotxꞌ te Galiley. Antza kchin okile kykaꞌyiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nchi bꞌettaqjo qya, tej kypon xoꞌl qꞌaqꞌ toj tnam, ex i ok ten qꞌmalte kye kynejil pale tkyaqiljo otaq bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tuꞌnpetziꞌn, aye kynejil pale bꞌeꞌx ok kychmoꞌn kyibꞌ kyukꞌa nejinel kyxol aj Judiy, tuꞌn tkyij bꞌant kyuꞌn, tuꞌn mi tzꞌele tqanil. Ex xi kyqꞌoꞌn nim pwaq kye xoꞌl qꞌaqꞌ, ");
INSERT INTO mamC_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tuꞌn mi kubꞌ kyyoline; qalaꞌ tuꞌn t-xi kyqꞌmaꞌn kyjaluꞌn: Toj qnikyꞌin, tej s-aj chꞌin qwatla, bꞌeꞌx ẍi uljo t-xnaqꞌtzbꞌin, ex ma txi kyelqꞌin t-xmilil Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ex qa ma tzꞌel tqanil toj twiꞌ aj kawil tiꞌjjo lo, ok kxmoxitil quꞌn, tuꞌntzin ntiꞌ tuꞌn tbꞌaj kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ex ayetzin kyeꞌ xoꞌl qꞌaqꞌ xi kytzyuꞌn pwaq, ex kubꞌ kybꞌinchin tzeꞌnkuxjo xi qꞌmaꞌn kye. Ex atzin tqaniljo nimin kyuꞌn aj Judiy tzmax toj tqꞌijil jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Awotzin qe, a junlajaj t-xnaqꞌtzbꞌin, bꞌeꞌx o xiꞌy toj txꞌotxꞌ Galiley tzma twiꞌ wutz, a jaꞌ xi tqꞌmaꞌne Jesús. ");
INSERT INTO mamC_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tej tok qkaꞌyiꞌn Jesús, o kꞌuliꞌn twutz, me attaq junjun qxola attaq kabꞌe kykꞌuꞌj tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ex tzaj laqꞌe Jesús qkꞌatza, ex tzaj tqꞌmaꞌn qeꞌy: Ma tzaj tqꞌoꞌn qMan Dios tkyaqil toklin weꞌy toj kyaꞌj ex twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tuꞌnpetziꞌn, ku kyxiꞌy kyukꞌaxjal toj tkyaqil twutz txꞌotxꞌ xnaqꞌtzilkye, tuꞌn kyok te nxnaqꞌtzbꞌiꞌn. Ex kyqꞌonqekuxa toj aꞌ, te jawsbꞌil aꞌ, toj tbꞌi Manbꞌaj, ex toj tbꞌi Kꞌwalbꞌaj, ex toj tbꞌi Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ex kyxnaqꞌtzinqexa tuꞌn tkubꞌ kynimiꞌn tkyaqiljo ma txi nqꞌmaꞌn kyeꞌy. Twutzxix kxel nqꞌmaꞌn kyeꞌy, loqiꞌn intin kyukꞌiy tzaluꞌn twutz txꞌotxꞌ, tzmaxi aj tjapin bꞌaj tkyaqil.");
INSERT INTO mamC_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","A uꞌj luꞌn nyolin tiꞌjjo Tbꞌanil Tqanil Jesucrist, a Tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tqꞌma Dios te Tkꞌwal tojjo uꞌj, a kubꞌ ttzꞌibꞌin jun yolil Tyol Dios ojtxe, Isaías tbꞌi. Chiꞌ kyjaluꞌn: Kxel nchqꞌoꞌn twutz txꞌotxꞌ. Me nej kxel nchqꞌoꞌn jun nsaꞌn qꞌmal tqanila, ex tuꞌn tkubꞌ kybꞌinchinxjal kyibꞌ twutza. ");
INSERT INTO mamC_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","K-yoliljo nsaꞌn tojjo tzqij txꞌotxꞌ, jaꞌ ntiꞌ kynajbꞌilxjal toj. Chkuꞌ kyjaluꞌn: Kybꞌinchin kyteꞌn twutz qAjaw; kyqꞌoꞌnx kyanmiꞌn te jikyinxix wen. ");
INSERT INTO mamC_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bꞌajxsiꞌn aj yol qꞌumj. Ul te Juan tojjo tzqij txꞌotxꞌ, a jaꞌ ntiꞌ kynajbꞌilxjal toj; nim xjal xiꞌ lolte, ex bꞌeꞌx i bꞌaj kuꞌx toj aꞌ, te jawsbꞌil aꞌ, quꞌn xi tqꞌmaꞌn Juan kye: Ilx tiꞌj tuꞌn kybꞌinchinte kyteꞌn twutz Dios, tuꞌn kykuxa toj aꞌ te jawsbꞌil aꞌ, ex tuꞌntzin tkubꞌ tnajsin Dios kyila. ");
INSERT INTO mamC_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nim xjal aj Judey exsin jniꞌ aj Jerusalén i bꞌajetz bꞌil teꞌ tyol Juan. Bꞌaj kubꞌ kypaꞌn kyil, ex i kux tqꞌoꞌn Juan toj jun nim aꞌ, Jordán tbꞌi, te jawsbꞌil aꞌ. Atzin teꞌ kyjatz toj aꞌ, kubꞌ kyyekꞌiꞌn kynimbꞌil tiꞌj Dios. ");
INSERT INTO mamC_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Atzin t-xbꞌalin Juan noq tsmal txuk, tukꞌa jun tkꞌalbꞌil tzꞌuꞌn, tzeꞌnku kyxbꞌalin yaj. Atzin twa n-oktaq noq txuk tzeꞌnqekuꞌ txanin, ex taꞌl aq toj kꞌul. ");
INSERT INTO mamC_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ex ntqꞌmaꞌntaq Juan: Loqin weꞌ nchin yolin kyxola tiꞌj Tyol Dios. Me atx juntl tetz lipchetz wiꞌja nimxixtl toklin tzeꞌnku weꞌ. Bꞌinchil Tkyaqil ex nimxjo tkawbꞌil. Ayintzin weꞌ ntiꞌx wokliꞌn nipe tuꞌn woka te taqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ma chi kuꞌxa toj aꞌ wuꞌn, te jawsbꞌil aꞌ, me anteꞌ tzul nya noq oꞌkx tuꞌn kykuꞌxa toj aꞌ tuꞌn, te jawsbꞌil aꞌ, qalaꞌ kxel tqꞌoꞌn Xewbꞌaj Xjan toj kyanmiꞌn te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kyojjo qꞌij anetziꞌn, tzuntaq nchi kux tqꞌoꞌn Juan xjal toj Nim Aꞌ Jordan te jawsbꞌil aꞌ, teꞌ tpon Jesús kykꞌatz, tzajnin toj tnam Nazaret, toj ttxꞌotxꞌ Galiley. Bꞌeꞌxsin kux tqꞌoꞌn Juan Jesús toj Nim Aꞌ Jordán te jawsbꞌil aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Texjo paq, teꞌ tjatz Jesús toj aꞌ, xi tkaꞌyin kyaꞌj, teꞌ t-xi jaqpaj, ex xi tkaꞌyin Xewbꞌaj Xjan, teꞌ ttzaj toj kyaꞌj tibꞌaj, tzeꞌnku jun palom. ");
INSERT INTO mamC_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ex qꞌajqꞌojin jun yol toj kyaꞌj, ex tqꞌma: Axixpen te nkꞌwala, kꞌuꞌjlinxix wuꞌn, a o jaw nskꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx xiꞌ Jesús tuꞌn tkujiljo Xewbꞌaj Xjan tojjo tzqij txꞌotxꞌ, jaꞌ ntiꞌye kynajbꞌilxjal toj. ");
INSERT INTO mamC_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kaꞌwnaq qꞌij ten antza kyukꞌa toj kꞌul txuk. Tjoy tajaw il ttxolil, tzeꞌn tuꞌn tel tikyꞌin Jesús tkawbꞌil tMan, me mix kubꞌe tiꞌj. Tbꞌajlinxiꞌ ikyjo, i ul t-angel Dios mojil te Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tuꞌn jniꞌ t-xnaqꞌtzbꞌil Juan, bꞌeꞌx tzaj tqꞌojjo kawil, ex bꞌeꞌx kux tjpuꞌn toj tze. Tkuꞌxlinxi Juan toj tze, xiꞌ Jesús toj Galiley qꞌmal teꞌ Tbꞌanil Tqanil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Chi Jesúsjo kyjaluꞌn: Ma tzul kanin tqꞌijil, jaꞌ tuꞌn tkawine Dios kyxola. Tuꞌntzintzjo, kybꞌinchinku kyibꞌa, kytzaqpinkjiꞌy jniꞌ nya bꞌaꞌn, ex kyniminxjiꞌy Tbꞌanil Tqanil. ");
INSERT INTO mamC_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nbꞌettaq Jesús ttziyile Nijabꞌ te Galiley, teꞌ t-xi tkaꞌyin Simun tukꞌaxjo titzꞌin, Andrés. Nxi kyxoꞌntaq kypa toj aꞌ te tzuybꞌil kyiẍ, quꞌn kyiẍilqetaq. ");
INSERT INTO mamC_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Xi tqꞌmaꞌn Jesús kye: Chi lipeka wiꞌja. Quꞌn ayetzin kyeꞌ nchi chmoꞌn kyiẍ jaꞌlin, me kchi xel nxnaqꞌtziꞌn tzeꞌn tten tuꞌn tbꞌant kychmoꞌn xjal, tuꞌn kyklet. ");
INSERT INTO mamC_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tej kybꞌinte ikyjo, bꞌeꞌx kyij kytzaqpiꞌn kytzuybꞌil kyiẍ, ex i xi lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Me noqtaq chꞌin otaq txi kybꞌetin, teꞌ kyxi tkaꞌyin kabꞌetl ichin, Santyaw ex Juan, kyitzꞌin kyibꞌ. Ex attaq kytata Zebedey kyukꞌa, ex kyukꞌa taqꞌnil. Iteꞌkxtaq toj jun bark; nchi bꞌinchintaq kypa te tzuybꞌil kyiẍ. ");
INSERT INTO mamC_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bꞌeꞌxsin i xi tqꞌolbꞌin Jesústz, tuꞌn kyxiꞌ tukꞌa, ex noq teꞌ kybꞌin teꞌ ikyjo, bꞌeꞌx kyij kytzaqpiꞌn kytata toj bark kyukꞌax taqꞌnil, exsin i xiꞌtz tukꞌa Jesús tzma tojjo jun tnam, Capernaum tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tej kykanin Capernaum, okx Jesús qꞌol jun xnaqꞌtzbꞌil toj jun qꞌij te ajlabꞌl toj jun muꞌẍ ja te kynaꞌbꞌl Dios aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Atziꞌn t-xnaqꞌtzbꞌil ok, tkyaqil xjal bꞌeꞌx jaw kaꞌylaj tuꞌn, quꞌn bꞌajxitaq kybꞌiꞌye jun xnaqꞌtzbꞌil ikyjo, quꞌn nya noq tiꞌchaqku tyol bꞌaj tqꞌmaꞌn, tzeꞌnkutaqjo nbꞌaj kubꞌ kyxnaqꞌtzin xnaqꞌtzilkye. Quꞌn ntiꞌtaq kawbꞌil tuꞌn; qalatziꞌn te Jesús noq tiꞌj tkawbꞌil Dios yoline. ");
INSERT INTO mamC_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tojjo ja te naꞌbꞌl Dios anetziꞌn, attaq jun ichin tokxtaq jun taqꞌnil tajaw il toj tanmin. Tej tbꞌin teꞌ jniꞌ tyol Jesús, bꞌeꞌx jaw ẍchꞌin. Chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ay Jesús aj Nazaret. ¿Tiꞌxsin s-ula lolte qxola? Noqx ma tzula yuchꞌil qeꞌy. Wojtzqiꞌn te, ex bꞌiꞌn weꞌ wuꞌn; a tejiy Tkꞌwal Dios, xjanxix toklin. ");
INSERT INTO mamC_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Oktzin tyisoꞌn Jesúsjo taqꞌnil tajaw il kyjaluꞌn: Mi chꞌotjiꞌy. Kux tzꞌetza toj tanminjo xjal lo, ex tzaqpinkja. ");
INSERT INTO mamC_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Atziꞌn taqꞌnil tajaw il tbꞌinche tuꞌn tjaw luꞌlin ichin, ex bꞌeꞌx ex toj tanmin, me ox latꞌinx teꞌ tex. ");
INSERT INTO mamC_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kykyaqilxjo jniꞌ xjal bꞌaj jaw kaꞌylaj, ex i bꞌaj jaw yolin kyxolile. Chi chiꞌ kyjaluꞌn: ¿Titziꞌn ikyjo? A xnaqꞌtzbꞌil luꞌn bꞌajxi qlaꞌye juntl ikyjo, a ajin qeꞌ taqꞌnil tajaw il ma cheꞌx niminte. ");
INSERT INTO mamC_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ex jun paqx tel tqanil Jesús toj tkyaqil Galiley. ");
INSERT INTO mamC_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tej tetz Jesús tukꞌa Santyaw ex Juan tojjo muꞌẍ ja te naꞌbꞌl Dios, bꞌeꞌx i xiꞌ tja Simun ex Andrés. ");
INSERT INTO mamC_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tej kykanin, kuẍlekxtaqjo tnana t-xuꞌjil Simun twiꞌ watbꞌil, yabꞌtaq tuꞌn kyaq. Ok kyqꞌmaꞌn t-xnaqꞌtzbꞌin te Jesús, qa yabꞌtaqjo qya, ");
INSERT INTO mamC_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ex bꞌeꞌx tzaj laqꞌe tkꞌatz. Jaw tiꞌn tukꞌa tqꞌobꞌ tuꞌn tjaw weꞌ. Texjo paq, bꞌeꞌx ul Dios te, ex bꞌeꞌx ok ten bꞌinchil chꞌin tiꞌ kye. ");
INSERT INTO mamC_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tej qok yupj, nimx txqan yabꞌ ex jniꞌ tzyuꞌnqetaq tuꞌn taqꞌnil tajaw il bꞌaj xi qꞌin twutz Jesús, tuꞌn kybꞌaj kubꞌ tqꞌanin. ");
INSERT INTO mamC_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bꞌaj pon chmet txqan xjal ttzi ja, ");
INSERT INTO mamC_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ex bꞌaj kubꞌ tqꞌanin Jesúsjo jniꞌ yabꞌ exqetziꞌn jniꞌ tzyuꞌnqetaq kyuꞌn taqꞌnil tajaw il. Ex mix ttziye tuꞌn kyyolin taqꞌnil tajaw il, quꞌn kyojtzqiꞌntaql alkye Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Qlixje wen, sjuminxtaq chꞌintl, teꞌ tjaw weꞌks Jesús, tuꞌn t-xiꞌ tjunalx naꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Me bꞌeꞌx i xiꞌ Simun kyukꞌa tukꞌa jyolte Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Atzaj teꞌ tjyet kyuꞌn, xi kyqꞌmaꞌn te: Tkyaqil xjal njyon tiꞌja, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Xi ttzaqꞌwin Jesús kye: Qoꞌqe toj junjuntl tnam qꞌmal Tyol Dios, quꞌn tuꞌnpetziꞌn ẍin tzaja weꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Exsin Jesús bꞌetil kyukꞌa toj tkyaqil tnam te Galiley kyojileꞌ muꞌẍ ja te kynaꞌbꞌl Judiy Dios, qꞌmal Tyol Dios ex lajolkye taqꞌnil tajaw il toj kyanmin xjal. ");
INSERT INTO mamC_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tzaj laqꞌe jun ichin tkꞌatz Jesús yabꞌtaq tuꞌn jun txꞌaꞌk, a noqx n-el lemimin. Kubꞌ meje xjal twutz, ex xi tqꞌmaꞌn te: Qa taja, bꞌaꞌn tuꞌn nkubꞌ tqꞌaniꞌn tukꞌa nyabꞌila. ");
INSERT INTO mamC_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tzaj qꞌaqꞌin tkꞌuꞌj Jesús tiꞌj. Noq ok tmikoꞌn, ex xi tqꞌmaꞌn te: Waja. ¡Bꞌeꞌx ma qꞌanita jaꞌlin! ");
INSERT INTO mamC_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Texjo paq anetziꞌn, bꞌeꞌx qꞌanitkux te jun majx, ex bꞌeꞌx el qolpajjo txꞌaꞌk tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Me bꞌeꞌx aj tchqꞌoꞌn Jesús, me nej xiꞌ toqxenin te kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Bꞌiꞌnkuy. Mi txi tqꞌmaꞌn te aꞌla. Qalaꞌ ku txiꞌy, ex yekꞌinx tibꞌa te kypale aj Judiy, ex qꞌonxa jun oyaj te aqꞌbꞌil chjonte, tuꞌn ma tzul Dios tey, a tzeꞌnkuxjo kubꞌ ttzꞌibꞌin Moisés ojtxe, tuꞌntzin kybꞌin texjal qa ma qꞌanita. ");
INSERT INTO mamC_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Me mix tpakux teꞌ ichin tkꞌuꞌj ikyjo, qalaꞌ bꞌeꞌx ok ten qꞌmalte kye jniꞌ xjal. Tuꞌntzin tpajjo ikyjo, mix okxi Jesús kyoj tnam, quꞌn noqit okx, bꞌeꞌxitla ok tzaqpaj txqan xjal tiꞌj. Bꞌeꞌx tjoy Jesús ttxolil tbꞌe kytxanile tnam, me mix tuꞌnxj jyet-x kyuꞌnxjal, ex i bꞌaj ok lipe tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tbꞌajlinxiꞌ jun jteꞌ qꞌij, teꞌ tmeltzꞌaj juntl majl Jesús kyukꞌa t-xnaqꞌtzbꞌin, ex el tqanil, qa attaq toj jun ja toj tnam Capernaum. ");
INSERT INTO mamC_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ul chmet txqan xjal lolte, me a mix bꞌante kyten tuja; noq twutz ja i bꞌaj oke tene txqan. Ante Jesús nyolintaq teꞌ tiꞌj Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Me tzmataq nyolin, teꞌ kypon kyaje ichin iqintaq jun yabꞌ kyuꞌn twiꞌ jun tkuẍbꞌil. Atzin yabꞌ noq otaq tzꞌok kꞌolpaj. ");
INSERT INTO mamC_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Me mix bꞌante kyokx kyxolxjal. Tuꞌnpetziꞌn, jyet jun ttxolil kyuꞌn, ex i jax tibꞌajxi ja. Exsin jaw kypoꞌqꞌin toj twiꞌ ja, noq tuꞌn tkuꞌxkuꞌ yabꞌ tzma tkꞌatz Jesús, quꞌn qꞌuqlektaq kykꞌuꞌj tiꞌj, tuꞌn tqꞌanit kyyabꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tej kyok tkaꞌyin Jesúsjo tqꞌuqbꞌil kykꞌuꞌj tiꞌj, bꞌeꞌxsin xi tqꞌmaꞌn te yabꞌ: Nkꞌwal, ayetzin tila ma chi kubꞌ najsit jaꞌlin, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Qꞌuqejqetaqjo xnaqꞌtzil tiꞌj ojtxe kawbꞌil, tej tok kybꞌiꞌn ikyjo, kubꞌ kyximin: ");
INSERT INTO mamC_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Tzeꞌntzin tten n-el tzaqpajjo ttzi ikyjo? ¿Nyaꞌpela noq nxoꞌn yol tiꞌj Dios? Quꞌn oꞌkx te Dios aku kubꞌ najsinte kyilxjal. ");
INSERT INTO mamC_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Me ante Jesús, bꞌeꞌx el tnikyꞌ te tiꞌtaqjo nkybꞌisin xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Bꞌeꞌx xi tqanin kye: ¿Tinquꞌn nkubꞌ kybꞌisinjiꞌy ikyjo? ");
INSERT INTO mamC_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ankye junx tzꞌele; tuꞌn t-xi qꞌmet tuꞌn tkubꞌ najsit til jun xjal, a tzeꞌnkuljo tuꞌn t-xi qꞌmet: Weꞌksa, ex kux bꞌeta? ¿Ma nyapela ate kujxixtljo a tuꞌn tnajsit til jun xjal? ");
INSERT INTO mamC_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Me mi nxi kynimiꞌn qa at wokliꞌn tiꞌjjo lo. Me atzin jaꞌlin, kxel nyekꞌiꞌn kywutza qa ayin weꞌ, a Tkꞌwal Ichin, at wokliꞌn tzaluꞌn twutz txꞌotxꞌ, tuꞌn tkubꞌ nnajsiꞌn kyilxjal te jun majx. Tuꞌnpetziꞌn, xi tqꞌmaꞌn te yabꞌ: ");
INSERT INTO mamC_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kxel nqꞌmaꞌn teꞌy, ¡Weꞌksa! Qꞌinxjiy tkuẍbꞌila, ex kux tzꞌaja tjay. ");
INSERT INTO mamC_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Antej yabꞌ, texjo paq ja weꞌks, etz tiꞌn iqbꞌilte, exsin etz kywutzileꞌ jniꞌ xjal. Tuꞌnxsiꞌn ikyjo, bꞌeꞌx jaw kaꞌylajx kywutzjo xjal tkyaqil. Exsin i bꞌaj ja nimsin tbꞌi Dios kykyaqilx, ex kyqꞌma: Bꞌajxpen qlaꞌyix teꞌ ikyjo, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Xiꞌ juntl majl Jesús ttzi Nijabꞌ te Galiley. Ayetziꞌn jniꞌ xjal bꞌaj tzaj laqꞌe tkꞌatz, ex toktaq Jesús xnaqꞌtzilkye. Tbꞌajlinxiꞌ ikyjo, ikyꞌ Jesús antza. ");
INSERT INTO mamC_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nbꞌettaq, exsin xi tkaꞌyin jun ichin, Matey tbꞌi, a tkꞌwal Alpey, qꞌuqletaq twiꞌ meẍ peyil pwaq te kꞌaybꞌil tuꞌn tajbꞌin kye aj Rom, ayeꞌ nchi kawintaq kyibꞌaj aj Israel. Xi tqꞌmaꞌn Jesús te: Lipeka wiꞌja, chiꞌ. Ex kutzin, chi Matey. Ex bꞌeꞌx ikyꞌ lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Me jun maj nwaꞌntaq Jesús tja Matey kyukꞌa txqantl xjal peyil pwaq te kꞌaybꞌil te Rom, junx kyukꞌa nim xjal aj il qꞌuqejqetaq tiꞌj meẍ junx tukꞌa Jesús, ex kyukꞌa t-xnaqꞌtzbꞌin, quꞌn ma nintzxtaq txqan xjal lipchektaq tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tej tok kykaꞌyin Parisey exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil nwaꞌntaq Jesús kyxolxjo xjal anetziꞌn, xi kyqanin kye t-xnaqꞌtzbꞌin: ¿Tzeꞌntzin toke ikyjo, a kyxnaqꞌtzila nwaꞌn kyukꞌa xjal peyil pwaq, ex kyukꞌa noq tiꞌchaqku maꞌ xjal, a ntiꞌ tajbꞌin? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tej tbꞌinte Jesúsjo anetziꞌn, xi tqꞌmaꞌn kye: Ayetziꞌn bꞌaꞌnqe ntiꞌ kye tajbꞌin qꞌanil kye; meqetziꞌn yabꞌqe, atpen kyeꞌ tajbꞌin kye. Tuꞌnpetzintzjo, nya ma chin tzaj weꞌ txkol kye xjal nbꞌaj kubꞌ kybꞌisin qa bꞌaꞌn kyten; qalaꞌ ayin wejiꞌy ma chin tzaj txkolkye ayeꞌ bꞌinchil ilqe. Tuꞌnpetziꞌn, ma chin ula kyxol. ");
INSERT INTO mamC_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jun maj, aye t-xnaqꞌtzbꞌin Juan, a Jawsil Aꞌ, kubꞌ kypaꞌn waꞌyaj, ex ikyqex kye kyxnaqꞌtzbꞌin Parisey. I tzajtzin junjun xjal te Jesús, ex xi kyqꞌmaꞌn: ¿Tinquꞌn nkubꞌ kypaꞌn kye t-xnaqꞌtzbꞌin Juan waꞌyaj exqetziꞌn kyxnaqꞌtzbꞌin Parisey, tuꞌn kynaꞌn Dios, ex ayetziꞌn te mina? ");
INSERT INTO mamC_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","I xi ttzaqꞌwin Jesús: ¿Ma akutzin kubꞌ kypaꞌn kyeꞌ txokenj toj jun mejebꞌlin waꞌyaj, a qa at chmilbꞌaj kyxol? Nlay, quꞌn nim tzaljbꞌil at, ex nim waꞌn nbꞌaj bꞌaj. Ikyqetziꞌn wejiꞌy nxnaqꞌtzbꞌin, quꞌn loqiꞌn intin kyxol. ");
INSERT INTO mamC_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Me pon kanin jun qꞌij, jaꞌ tuꞌn wele naja, a ayiꞌn, a ikyxjo tzeꞌnku chmilbꞌaj kyxol. Ajtzin tjapin kaninjo qꞌij anetziꞌn, okpetzila kꞌwel kypaꞌntz waꞌyaj, tuꞌn kynaꞌn Dios wen. ");
INSERT INTO mamC_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ex waja tuꞌn t-xi nqꞌmaꞌn kabꞌe tumil kyeꞌy: Tnejil, qa kyaja tuꞌn tkubꞌ kyslepiꞌn jun xbꞌalin ttxꞌaqin, nlay kubꞌ kyqꞌoꞌn jun slepbꞌilte saq, quꞌn ajtzin tkuꞌx txjetjo saq, bꞌeꞌx k-okil jukꞌpaj, exsin bꞌeꞌx k-elix laqj txqantljo ttxꞌaqin. ");
INSERT INTO mamC_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ex tkabꞌ, tzeꞌn aj tkux bꞌinchit vin; nlay kuꞌx bꞌinchit toj jun ttxꞌaqin tzꞌuꞌn, quꞌn ajtzin tloqlin, bꞌeꞌx aku tzꞌex laqj, ex noq aku chi kubꞌ najx kykabꞌil. Tuꞌntzintzjo, il tiꞌj tuꞌn tkux bꞌinchit vin toj jun saq tzꞌuꞌn. Ikytziꞌn wejiꞌy nxnaqꞌtzbꞌil, nlay bꞌant tuꞌn tok smet tukꞌa juntl tumil. ");
INSERT INTO mamC_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jun maj toj jun qꞌij te ajlabꞌl nchi bꞌettaq t-xnaqꞌtzbꞌin Jesús toj jun bꞌe n-ex txol triy. Atzaj teꞌ kyikyꞌ antza, ayetziꞌn t-xnaqꞌtzbꞌin i ok ten xbꞌoqil triy te kywa. ");
INSERT INTO mamC_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tej kylonte Pariseyjo ikyjo, xi kyqanin te Jesús: ¡Bꞌiꞌnkutziꞌn! Tojjo qꞌij te ajlabꞌl, jaꞌ mix aꞌl jun tuꞌn tja aqꞌnin, ¿Me tiquꞌnqe t-xnaqꞌtzbꞌiꞌn nchi xbꞌoqin triy? ");
INSERT INTO mamC_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Xi tqꞌmaꞌn Jesús kye: ¿Ma naꞌmtzin tkux kyuꞌjin kyejiꞌy bꞌant jun maj tuꞌn qtzan David, a nimx toklin, tej ttzaj waꞌyaj tiꞌj kyukꞌa tukꞌa? ");
INSERT INTO mamC_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Xi kywaꞌn kypan pale aj Judiy, exsin nyataq tuꞌn tkubꞌ kybꞌinchiꞌn anetziꞌn. Me kubꞌ kybꞌinchin, tej ataq Abyatar toktaq te kynejilxix kypale aj Judiy. Okx David toj ojtxe tja Dios, etz tiꞌn a pan xjan, a n-ajbꞌin te kywa pale, ex xi twaꞌn David, ex xi tqꞌoꞌn kye tukꞌa, tuꞌn t-xi kywaꞌn. Qa ikytzjo tukꞌa David ojtxe, ¿Tiꞌn tkyꞌitz tuꞌn kyxbꞌoqin nxnaqꞌtzbꞌiꞌn triy? ");
INSERT INTO mamC_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ex xi tqꞌmaꞌntl Jesús kyjaluꞌn: Atziꞌn qꞌij te ajlabꞌl ma kubꞌ bꞌinchit tuꞌn tajbꞌin kyexjal, ex nya qexjal tuꞌn kyajbꞌin te. ");
INSERT INTO mamC_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tzeꞌn nteꞌn, ayiꞌn Tkꞌwal Ichin chqꞌoꞌnqintza tuꞌn Dios kyxola, ex ayiꞌn at wokliꞌn tibꞌajjo qꞌij te ajlabꞌl, ex ayiꞌn kchin qꞌmalte qa wen tuꞌn tkubꞌ bꞌinchit jun tiꞌ mo qa minaj. ");
INSERT INTO mamC_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Toj juntl qꞌij te ajlabꞌl, okx Jesús toj jun muꞌẍ ja te naꞌbꞌl Dios. Me attaq jun ichin ntiꞌtaq tanmin tqꞌobꞌ, teꞌ tokpin naꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ex attaq junjun nchi bꞌaj ẍlukꞌintaq tiꞌj Jesús, qa tuꞌntaq tkubꞌ tqꞌanin yabꞌ toj jun qꞌij te ajlabꞌl, noq tuꞌn kystzꞌimin tiꞌj qa otaq kubꞌ tzꞌaq toj til, quꞌn nya wentaq toj kywutz tuꞌn tkubꞌ bꞌinchit jun tiꞌ toj qꞌij te ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Xitzin tqꞌmaꞌn Jesús te ichin: ¡Weꞌksa, ex weꞌkuy kywutzxjal! ");
INSERT INTO mamC_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tbꞌajlinxiꞌ ikyjo, xi tqanin Jesús kye: ¿Tiꞌtzin tqꞌmaꞌn kawbꞌil tiꞌjjo qꞌij te ajlabꞌl? ¿Ma tzuntzin ntqꞌmaꞌn tuꞌn tkubꞌ bꞌinchitjo nya wen, mo a wen; tuꞌn tklet tchwinqil jun xjal, mo tuꞌn tok kaꞌyitj tuꞌn tkubꞌ kyim? Me ayetzin kyetz noq i bꞌajel kyim. Ntiꞌx xi kytzaqꞌwin. ");
INSERT INTO mamC_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","I xi tkaꞌyin Jesús tiꞌjile; tzaj tqꞌoj, ex jaw bꞌisin tuꞌn tkujil kyanminxjal. Ex xi tqꞌmaꞌn Jesús te ichin, tuꞌn t-xi tnuqpin tqꞌobꞌ. Noqx teꞌ t-xi tnuqpin, ex texjo paq, ul tanmin tqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tulninxi Dios te, bꞌeꞌx i etzjo Parisey, ex ok kychmoꞌn kyibꞌ tukꞌa juntl chꞌuq xjal lipcheqetaq tiꞌjjo tkawbꞌil Herodes, ex nkyjyoꞌntaq tumil tzeꞌn tuꞌn tbꞌaje Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tbꞌajlinxiꞌ ikyjo, xiꞌ Jesús kyukꞌa t-xnaqꞌtzbꞌin ttzi Nijabꞌ te Galiley. Ex i bꞌaj ok lipe txqan xjal aj Galiley tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tej tbꞌijte kyuꞌn jniꞌ xjal tiꞌjjo jniꞌ nbꞌaj bꞌanttaq tuꞌn, nimx bꞌaj ul lolte tzeꞌnqekuꞌ aj Judey, aj Jerusalén, aj Idumey, jniꞌ qeꞌ najleqetaq tjlajxiꞌ Nim Aꞌ Jordán, exqe aj Tiro ex aj Sidón. ");
INSERT INTO mamC_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tuꞌntzin ikyjo, xi tqꞌmaꞌn Jesús kye t-xnaqꞌtzbꞌin, tuꞌn noqx tkubꞌl jun bark kyuꞌn ttzi nijabꞌ, tuꞌn t-xi toj, ex tuꞌn tokx laqꞌe chꞌin tojxi aꞌ, tuꞌn mina tzꞌok jitzꞌletaq kyxol xjal. ");
INSERT INTO mamC_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Quꞌn nimxtaq txqan yabꞌ otaq chi bꞌaj tqꞌanin; noq tuꞌn aj kybꞌaj ok tmikontaq, bꞌeꞌx bꞌaj ul Dios kye. Tuꞌntzin ikyjo, kykyaqilxjo jniꞌ yabꞌ kyajtaq tuꞌn kypon kanin tkꞌatz. ");
INSERT INTO mamC_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aj tiwletaq Jesús kyuꞌnxjal, ayeꞌ tokxtaq taqꞌnil tajaw il toj kyanmin, bꞌeꞌx nchi kubꞌ meje twutz, exsin nchi jaw ẍchꞌin kyjaluꞌn: Atejiy Tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Me ante Jesús xi tqꞌmaꞌn kye kujxix wen, tuꞌn mi kubꞌe kyqꞌmaꞌne kywutzxjal alkyetaq t-xilin toklin. ");
INSERT INTO mamC_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tbꞌajlinxiꞌ ikyjo, jax Jesús twiꞌ jun wutz, ex i tzaj ttxkoꞌn a aye tajqetaq. ");
INSERT INTO mamC_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kyxoltziꞌn xjal anetziꞌn, i jaw tskꞌoꞌn kabꞌlajaj ichin, tuꞌn kyxi tkꞌleꞌn qꞌmalte Tyol Dios kyojile jniꞌ najbꞌil. Ex xi tqꞌoꞌn kyoklin te tsanjil. ");
INSERT INTO mamC_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xi tqꞌoꞌn kawbꞌil kye, tuꞌn tetz kylajoꞌn taqꞌnil tajaw il toj kyanmin xjal. ");
INSERT INTO mamC_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Atziꞌn kybꞌi kabꞌlajaj ichin, ayeꞌ i jaw tskꞌoꞌn: Simun, me ok tqꞌoꞌn Jesús juntl tbꞌi te Pegr. ");
INSERT INTO mamC_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ayetzin kabꞌel, Santyaw ex Juan, kyitzꞌin kyibꞌ, kꞌwalbꞌajqe te Zebedey, ok tqꞌoꞌn juntl kybꞌi te Kꞌwalbꞌaj te Qꞌankyaq. ");
INSERT INTO mamC_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ayetzin txqantl: Andrés; Lip; Bartolomey; Matey; Tmas, ante Santyaw, a tkꞌwal Alpey; tukꞌax Tadey; ex Simun, a toktaqljo qꞌolbꞌite te Celote; ");
INSERT INTO mamC_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","exsin Judas Iscariot, a ok meltzꞌaj tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tbꞌajlinxiꞌ ikyjo, i okx kyukꞌa t-xnaqꞌtzbꞌin toj jun ja, jaꞌ pon chmetl txqantl xjal, a mix bꞌante kywaꞌn kyxol. ");
INSERT INTO mamC_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Atziꞌn teꞌ tel tqanil toj kywiꞌ t-xjalil, jniꞌxtaqjo nbꞌaj bꞌant tuꞌn Jesús, bꞌeꞌx i xiꞌ tnana exqetziꞌn titzꞌin kꞌlelte, tuꞌn tmeltzꞌaj tja, quꞌn otaq tzꞌok kyqꞌoꞌn, aj qa otaq tzaj toj twiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ex ikyjo kyqꞌmaꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil, a i tzaj toj Jerusalén, qa tzyuꞌntaq tuꞌn tajaw il, ex qa tuꞌn tkawbꞌil tajaw il nchi exetaqjo taqꞌnil tajaw il tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Teꞌ tbꞌinte Jesúsjo ikyjo, i tzaj ttxkoꞌn, ex kubꞌ tqꞌmaꞌn jun techil kye: ¿Tzeꞌntzin tteꞌn tajaw il tuꞌn tbꞌant tlajonte tibꞌ, ex tuꞌn tok meltzꞌaj tiꞌjx? ");
INSERT INTO mamC_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Qa jun tnam xjal paꞌmile kyten, ex kyajqꞌoj kyibꞌ, noqx aku chi kubꞌ kyimx tuꞌn qꞌoj. ");
INSERT INTO mamC_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ex ikyxjo, toj jun ja xjal, aj qa kyajqꞌoj kyibꞌ, nlay chi el wen. ");
INSERT INTO mamC_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ikytzin taꞌye te tajaw iljo, qa ma tzꞌok meltzꞌaj tiꞌjx, nlay tzꞌel wen. ");
INSERT INTO mamC_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Atx juntl tumil: Qa taj jun ileqꞌ tzꞌokx elqꞌil toj tja jun xjal nim tipin, nlay bꞌant telqꞌin, qa mi xkubꞌ kꞌlet tajaw ja nej. Ikytzin toke tajaw iljo tzeꞌnku tajaw ja lo, quꞌn a tajaw jniꞌ xjal aye tzyuꞌnqe tuꞌn. Me ayin weꞌ ma chin kanbꞌin tiꞌj tajaw il. Tuꞌnpetziꞌn, nchi ex nlajonjiꞌy taqꞌnil toj kyanmin xjal. ");
INSERT INTO mamC_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Twutzxix kxel nqꞌmaꞌn kyeꞌy, kꞌwel tnajsin Dios kyiljo jniꞌ xjal, a nbꞌaj kubꞌ kybꞌinchin nya wen, ex jniꞌ xoꞌj yol. ");
INSERT INTO mamC_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Me aye nchi xoꞌn yol tiꞌj Xewbꞌaj Xjan nlay kubꞌ tnajsinx Dios kyil; ma kyijx te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tqꞌma Jesús ikyjo, noq tuꞌn nxi kyqꞌmaꞌn te, qa tzyuꞌntaq tuꞌn tajaw il, ex qa nya tuꞌn Xewbꞌaj Xjan nbꞌaj kubꞌ tbꞌinchintaq tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tej tkanin tnana Jesús kyukꞌa titzꞌin jaꞌ taꞌtaq, i bꞌaj kyij weꞌ peꞌn; noqtzin xi kyqꞌmaꞌn kyexjal, tuꞌn tetz kytxkoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Me ayetziꞌn xjal qꞌuqleqetaq tiꞌjile xi kyqꞌmaꞌn te: Luꞌ tnaniy exqetziꞌn titzꞌin iteꞌ peꞌn; ma chi ul jyol tey, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tzaj ttzaqꞌwin Jesús kye: ¿Ankye nnaniy exqetziꞌn witzꞌiꞌn? ");
INSERT INTO mamC_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I xi tkaꞌyin jniꞌ xjal qꞌuqejqetaq tiꞌjile, exsin xi tqꞌmaꞌn kye: Ayetzin wejiꞌy nnana ex witzꞌin lo, a aye nchi kubꞌ bꞌinchin teꞌ a taj Dios, ");
INSERT INTO mamC_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","quꞌn kykyaqiljo a nkubꞌ bꞌinchin teꞌ a taj Dios, ayetzin wejiꞌy witzꞌin, ex wanebꞌ ex nnaniy. ");
INSERT INTO mamC_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Juntl majl, ok ten Jesús xnaqꞌtzil ttzi Nijabꞌ te Galiley. Pon chmet txqan xjal tuꞌn kybꞌin tiꞌjjo t-xnaqꞌtzbꞌil. Me bꞌeꞌx jax Jesús toj jun bark tuꞌn t-xi laqꞌe chꞌintl tojjo nijabꞌ, quꞌn nimxxjal pon chmet. Tej tokx laqꞌe Jesús axsi, i kyije tene txqantl xjal ttzi nijabꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Exsin ok tentz xnaqꞌtzil noq tukꞌa techil tiꞌchaqku tiꞌ; ok ten yolil tiꞌj jun awal exsin tqꞌma: ");
INSERT INTO mamC_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Kybꞌinkutzinjiꞌy kxel nqꞌmaꞌn kyeꞌy: Jun maj, xiꞌ jun xjal awal triy. ");
INSERT INTO mamC_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Atzin teꞌ tok tchtoꞌn, at pon chitj toj bꞌe. I tzaj pichꞌ, ex bꞌeꞌx jaw kyskꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ex at pon chitj kyxol abꞌj, me quꞌn tuꞌn ntiꞌxix twutz txꞌotxꞌ antza, liwey ul twiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Me atzaj teꞌ ttzaj qꞌijil, bꞌeꞌx jaw tzqij, tuꞌn nya nim xaꞌye tlokꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ex at pon chitj kyxol txꞌiꞌx. Me atzin txꞌiꞌx jun paqx tchꞌiy; atzin te triy noq jaw xkyꞌiꞌsix. ");
INSERT INTO mamC_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Anteꞌ pon chitj toj tbꞌanil txꞌotxꞌ, tbꞌanilx ele toj. At tqan el lajaj toj kaꞌwnaq twutz, ex junjuntl el ox kꞌal, ex junjuntl jun jweꞌ kꞌal. ");
INSERT INTO mamC_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tqꞌma Jesús: Ankye taj tuꞌn tkubꞌ tbꞌiꞌn nyola, in tkubꞌ tbꞌiꞌntz, tuꞌntzintla tkubꞌ tbꞌinchin. ");
INSERT INTO mamC_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tbꞌajlinxitziꞌn t-xnaqꞌtzbꞌil, bꞌeꞌx i bꞌajel tiljo txqan xjal. Me atx junjuntl kyij kyukꞌa t-xnaqꞌtzbꞌin, a bꞌaj xi kyqanin te Jesús: ¿Tzeꞌntzin tzꞌeleꞌ yol, a xbꞌaj tyolin? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Xitzin tqꞌmaꞌntz kye: Ma tzaj tqꞌoꞌn Dios jun tumil kyeꞌy, tuꞌn tel kynikyꞌa te tiꞌjjo nbꞌaj bꞌant kyxolxjal twutz txꞌotxꞌ. Loqiꞌn nchin yolin noq tukꞌa techil, noq te ewil teꞌ nyola kyeꞌ a mina nxi kynimin. ");
INSERT INTO mamC_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ayetziꞌn mina nchex niminte nyola, nchin kyloꞌn, me mina n-el kynikyꞌ weꞌy. Ex nchin ok kybꞌiꞌn, me mina n-okx toj kywiꞌ. Mina njaw kytxꞌixpin kynabꞌl, tuꞌn t-xi kynimin Dios, ex tuꞌn tkubꞌ nnajsiꞌn kyil. ");
INSERT INTO mamC_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Xi tqꞌmaꞌn Jesús: ¿Minatzin n-el kynikyꞌa te techil nkubꞌ nqꞌoꞌn tiꞌj awal triy? ¿Tzeꞌntzila ttentz, aj tel kynikyꞌa te txqantl techil? ");
INSERT INTO mamC_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Atzin teꞌ awal triy ikytziꞌn tzeꞌnku yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Attziꞌn xjal kuj tzeꞌnku txꞌotxꞌ toj bꞌe. Mina nchex awle ijaj toj. Ayetzin xjal n-ok kybꞌiꞌn Tyol Dios, ex nkubꞌ kykujsin kyanmin te, ex ajtzin ttzaj tajaw il tzeꞌnku pichꞌ, n-el tiꞌn Tyol Dios toj kyanmin. ");
INSERT INTO mamC_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Attziꞌn xjal tzeꞌnku txꞌotxꞌ txol abꞌj, mix chꞌiyxix tlokꞌ triy toj, ikyqetziꞌn tzeꞌnqe xjal jun paqx nxi kynimin Tyol Dios ex tukꞌa tzaljbꞌil. Me quꞌn tuꞌn ntiꞌxix kykꞌuꞌj tiꞌj, mi nchi kujix toj kynimbꞌil. Qa akux saj jun tiꞌ toj kychwinqil, mo qa akux ẍi ok lipinxjal kyiꞌj noq tuꞌn tpajjo nyola, bꞌeꞌx kchi kꞌwel tzꞌaq toj kynimbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ex atl tzeꞌnku txꞌotxꞌ nim tqan txꞌiꞌx toj. Nbꞌaj kubꞌ kybꞌiꞌn Tyol Dios, ");
INSERT INTO mamC_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","me oꞌkxtza nchi bꞌisine tiꞌj tkyaqiljo tkubꞌ twutz txꞌotxꞌ. Ex kyaj tuꞌn tten tkyaqil tiꞌchaqku tiꞌ kye ex jniꞌ kyqꞌinimil. Tuꞌntzintzjo anetziꞌn, n-el naje kynimbꞌil tiꞌj Dios. Ikyxsin tzeꞌnku triy njaw chꞌiy toj txꞌiꞌx. Noq n-el xkyꞌiꞌsix ex ntiꞌ toj n-el. ");
INSERT INTO mamC_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Atziꞌn xjal tzeꞌnku tbꞌanil txꞌotxꞌ nkubꞌ kybꞌiꞌn Tyol Dios, ex nbꞌaj kubꞌ kybꞌinchin tzeꞌnku ntqꞌmaꞌn, ikyqetziꞌn tzeꞌnku triy; n-el lajaj toj kaꞌwnaq twutz, junjuntl ox kꞌal ex junjuntl te jweꞌ kꞌal. ");
INSERT INTO mamC_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Atx juntl techil kꞌwel nqꞌoꞌn. ¿Ma tzuntzin n-ajbꞌin jun tzaj kyeꞌy, aj tokx tjaqꞌ jun kax mo tjaqꞌ jun watbꞌilj? ¿Ma nyatzin tuꞌn tkubꞌ tibꞌaj jun tkubꞌil tuꞌn tkꞌant toj kyjaꞌy? ");
INSERT INTO mamC_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ntiꞌx jun te tiꞌ mina tzꞌel tqanil, qalaꞌ ikytzin ilx tiꞌj tuꞌn tkubꞌ chikyꞌbꞌit. Ikytzin te Diosjo Tyol; te tnejil, mina n-eltaq kynikyꞌa te. Me atzin jaꞌlin, loqiꞌn nchin xnaqꞌtzin kyiꞌja, tuꞌn tel txꞌole toj kynabꞌla tzeꞌnku tqan tzaj. Tuꞌntzin ikyjo, ntiꞌx jun tiꞌ aku bꞌant tuꞌn tewit. ");
INSERT INTO mamC_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aꞌltziꞌn taj tuꞌn tok tbꞌiꞌn nyola, in tok tbꞌiꞌntz, exsin in tkubꞌ tbꞌinchiꞌntz. ");
INSERT INTO mamC_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Xi tqꞌmaꞌntl Jesús kye: Tuꞌnpetziꞌn, kykaꞌyinktzin kyibꞌa. Quꞌn tkyaqiljo, a nim n-ok tilil Tyol Dios tuꞌn, kyja kxele qꞌoyit txqantl tnaꞌbꞌl, tuꞌn tel tnikyꞌ tiꞌj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Me alkye teꞌ ntiꞌ n-ok tqꞌoꞌn tilil, majxpe ajo tnabꞌl, a tbꞌanilx toj twutz, me a ntiꞌ tumil, k-elil qꞌiyit te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ex xi tqꞌmaꞌn Jesús juntl t-xnaqꞌtzbꞌil tiꞌjjo Tkawbꞌil Dios. Chiꞌ kyjaluꞌn: Atzin nbꞌant tuꞌn Dios twutz txꞌotxꞌ ikytziꞌn tzeꞌnku jun ichin ok tchtoꞌn ttriy. Aj tbꞌaj tchtoꞌn, tiꞌchaqx txiꞌtz bꞌinchilte. ");
INSERT INTO mamC_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Exla qa nktan mo itzꞌj, n-ex junjun qnikyꞌin ex junjun qꞌij, anteꞌ ijaj n-ulxixe teꞌ twiꞌ, ex nchꞌiyxi. Mina n-el tnikyꞌ te tzeꞌn nchꞌiye ex tzeꞌn n-ele twutz, ");
INSERT INTO mamC_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","qalaꞌ tuꞌnx tibꞌ n-ul twiꞌ ex nchꞌiy, ex n-el twutz. ");
INSERT INTO mamC_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ajtzin tzqijtz, njaw tchmoꞌn ex njaw tkꞌuꞌn. Ikytzin tten Tyol Diosjo toj tanmin jun xjal. ");
INSERT INTO mamC_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Xi tqꞌmaꞌntl Jesús kye: ¿Tzeꞌnxsilaꞌ Tkawbꞌil qMan Dios, ex anqukꞌa aku tzꞌoke qmujbꞌine? ");
INSERT INTO mamC_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ikytziꞌn tzeꞌnku jun tal twutz mistas, tal netzꞌ, a nkux awet toj txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tal netzꞌxix kywutzjo txqantl twutz ijaj, me ajtzin tchꞌiy, jun tijx n-oke kywutzjo txqantl. Ex ma tij nchi oke tqꞌobꞌ, a jaꞌ n-okxi kybꞌinchin pichꞌ kypaqbꞌil kyxol tqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ikytziꞌn nchi bꞌaj kubꞌe t-xnaqꞌtzintaqjo t-xnaqꞌtzbꞌil tukꞌa techil tiꞌchaqku tiꞌ. Noqtaq nbꞌaj kubꞌ tyolin tuꞌn tbꞌajel kynikyꞌxjal te. ");
INSERT INTO mamC_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Noq tukꞌa techil nyolinetaq Jesús kyexjal. Me atziꞌn nchi kyijtaq kyjunalx kyukꞌa t-xnaqꞌtzbꞌin n-ok tentz qꞌmalte kye tzeꞌntaq kyxilin. ");
INSERT INTO mamC_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Teꞌ qok yupj texjo qꞌij anetziꞌn, xi tqꞌmaꞌn Jesús kyeꞌ t-xnaqꞌtzbꞌin: Qo ikyꞌx tjlajxi nijabꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bꞌeꞌx i bꞌaj kyij kytzaqpiꞌn t-xnaqꞌtzbꞌin jniꞌ xjal attaq, exsin i jax tukꞌa Jesús toj bark, ex i xiꞌ. Me bꞌeꞌx i xi lipe jniꞌ xjal kyiꞌj toj junjuntl bark. ");
INSERT INTO mamC_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Atzaj teꞌ kyxiꞌ, ok ten qꞌankyaq tinil qoptzꞌajiyil tukꞌa txqan kyqꞌiqꞌ; jniꞌ nijabꞌ ox lipin, ex okx chitj toj bark. ");
INSERT INTO mamC_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Me ante Jesús nktantaq tiꞌjxi bark, kuẍletaq twiꞌ tibꞌaj jun qꞌuqbꞌil. Okx kꞌasin Jesús kyuꞌn t-xnaqꞌtzbꞌin, exsin xi kyqꞌmaꞌn te: ¡Xnaqꞌtzil! ¿Minatzin ntzaj qꞌaqꞌin tkꞌuꞌja qiꞌj? Chꞌix qxi mulqꞌaj toj aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jaw weꞌ Jesús, ex xi tqꞌmaꞌn te kyqꞌiqꞌ ex te aꞌ: ¡Noqx tenkuy, ex numekuy! Bꞌeꞌx kubꞌ nume te kyqꞌiqꞌ, ex tkyaqilx bꞌeꞌx kubꞌ qen. ");
INSERT INTO mamC_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tbꞌajlinxiꞌ ikyjo, xi tqꞌmaꞌn Jesús kye t-xnaqꞌtzbꞌin: ¿Tinquꞌn ẍi tzaj xobꞌa te ikyjo? ¿Naꞌmxsin tten kynimbꞌila wiꞌja? ");
INSERT INTO mamC_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Me naꞌmxtaq tel kyxobꞌil, i bꞌaj ja yolin kyxolile: ¿Alxsila kye xjal ikyjo? A ajin kyqꞌiqꞌ ex aꞌ ma kubꞌ niminte. ");
INSERT INTO mamC_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tej kykanin tjlajxi nijabꞌ toj ttxꞌotxꞌjo jun tnam Gerasa tbꞌi, ");
INSERT INTO mamC_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","kuꞌtz Jesús kyukꞌa t-xnaqꞌtzbꞌin toj bark. Noqx teꞌ kykuꞌtz, tzaj laqꞌe jun ichin kykꞌatz, tzajnin toj muqbꞌil kyimnin, tokxtaq nimku taqꞌnil tajaw il toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Atzin ichin otaq najan tojjo muqbꞌil kyimnin kyuꞌn taqꞌnil tajaw il. Kujxtaq teꞌ ichin anetziꞌn; mixtaq aꞌl nxkye tiꞌj, tuꞌn tkubꞌ kꞌloꞌn tukꞌa kxbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ilaꞌ maj i kubꞌ kꞌloꞌn tqan ex tqꞌobꞌ tukꞌa kxbꞌil, me bꞌeꞌxtaq nbꞌaj kubꞌ tlaqin, ex mix aꞌlxtaq nxkye tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nbꞌettaq kykyaqil qꞌij ex kykyaqil qnikyꞌin kywiꞌyile wutz ex tojile muqbꞌil kyimnin. Nẍchꞌin wen, ex n-ok tlankꞌintaq tibꞌ tukꞌa abꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tetziꞌn tiwle Jesús tuꞌn, xi rinin tkꞌatz, ex kubꞌ meje twutz. ");
INSERT INTO mamC_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jaw ẍchꞌin, ex tqꞌma: ¿Tiꞌn taja wukꞌiy? Ay Jesús Tkꞌwal Dios, a nimx toklin tkawbꞌil. Chin kubꞌsil nwutza tey, tuꞌn mina chin kubꞌ tyajinxa. ");
INSERT INTO mamC_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ja yolin ichin ikyjo, quꞌn tuꞌn t-xi tqꞌmaꞌn Jesús, tuꞌn kyexjo taqꞌnil tajaw il toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Xi tqanin Jesús te ichin. ¿Titzin tetza tbꞌi? Xi ttzaqꞌwin ichin: Atzin nbꞌiy Nimku, quꞌn ilaꞌ qbꞌaja najle toj tanmin ichin lo. ");
INSERT INTO mamC_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ex i kubꞌsin kywutz te Jesús, tuꞌn mina chi exetaq tlajoꞌn toj ttxꞌotxꞌ Gerasa, quꞌn noq tuꞌn kykyꞌeꞌtaq cheꞌx antza. ");
INSERT INTO mamC_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","13","Nqayintaq tkꞌatzjo wutz antza, attaq bꞌalaqa kabꞌe mil kuch nchi waꞌntaq kꞌul. Ja yolin ichin kyuꞌn taqꞌnil tajaw il: Qo tqꞌonxa toj kyanmin kuch, chi chiꞌ. Xi ttziyin Jesús ikyjo; bꞌeꞌxsin i etz toj tanmin ichin. Ayetzin kyej kuch bꞌeꞌx i xi tilj kyeꞌ kubꞌl, ex atzaj teꞌ kykupin, bꞌeꞌxsin xi kyxoꞌn kyibꞌtz tojjo nijabꞌ, ex atzintza, bꞌeꞌx i jiqꞌwe. ");
INSERT INTO mamC_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Atzaj teꞌ tiwle lo kyuꞌnxjal, a nchi kyikꞌlentaq kyiꞌj kuch, bꞌeꞌxsin i kubꞌtz toj bꞌe yolilte kyeꞌ xjal, a iteꞌtaq toj tnam ex kyoj jniꞌ kojbꞌil. Bꞌeꞌxsin i bꞌajetz kyej xjal lolte, qa twutzxtaqjo a otaq kybꞌi. ");
INSERT INTO mamC_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ex atziꞌn teꞌ kykanin tkꞌatz Jesús, iwlej ichin kyuꞌn, aj otaq chi etz taqꞌnil tajaw il toj tanmin. Atzaj ichin anetziꞌn qꞌuqletaq t-xe tqan Jesús; iteꞌktaq t-xbꞌalin, ex otaq tzul spikyꞌeꞌ toj twutz. Tuꞌn ikyjo, bꞌeꞌx tzaj kyej xjal kyxobꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jniꞌqexjo i lonte a bꞌaj tiꞌjjo ichin ex kyiꞌj kuch, ex i ok ten qꞌmalte kye txqantl xjal. ");
INSERT INTO mamC_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tuꞌn tpajjo jniꞌ otaq bꞌaj, i ok ten xjal kubꞌsin kywutz te, tuꞌn tex tojjo tnam antza. ");
INSERT INTO mamC_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Teꞌ tmeltzꞌaj Jesús kyukꞌa t-xnaqꞌtzbꞌin toj bark, atzaj ichin, a tzyuꞌntaq kyuꞌn taqꞌnil tajaw il, xi tqanin, tuꞌn t-xi tkꞌleꞌn Jesús tukꞌa, quꞌn otaq tzꞌel wen. ");
INSERT INTO mamC_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Me mi xi ttziyine Jesús; oꞌkx xi tqꞌmaꞌn te: Kux tzꞌajxiy tjay kyukꞌa t-xjalila, ex qꞌmanxa kye jniꞌ xbꞌaj tiꞌja, ex tzeꞌn tten saj qꞌaqꞌin tkꞌuꞌj Dios tiꞌja, tuꞌn tel weꞌy. ");
INSERT INTO mamC_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bꞌeꞌx xiꞌ ichin, ex ok ten qꞌmalte kyxolile jniꞌ xjal kye tnam te Decápolis tkyaqiljo a otaq tbꞌinchin Jesús tiꞌj. Tkyaqiljo jniꞌ xjal bꞌeꞌxtaq nbꞌajel kyim tuꞌn ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Teꞌ tjlajintz Jesús tjlajtzaqtz nijabꞌ kyukꞌa t-xnaqꞌtzbꞌin toj bark, ul chmet txqan xjal tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Waꞌltaq ttzi nijabꞌ, teꞌ tpon jun kynejiljo kawil te jun muꞌẍ ja te naꞌbꞌl Dios, Jayr tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kubꞌ meje twutz, ex ja kubꞌsin twutz te: Ajo nkꞌwala txin luꞌ nkyim. Ku tzaja qꞌol tqꞌobꞌa tibꞌaj, tuꞌn mina kyime, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bꞌeꞌxsin xi lipe Jesús lolte. Xi lipe txqan xjal tiꞌj, me tzunxtaq nbꞌaj kylimon kyibꞌ tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kyxoltzin xjal, attaq jun qya otaq bꞌant-xiꞌ kabꞌlajaj abꞌqꞌe tyabꞌtlin tuꞌn kyyabꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Otaqx bꞌaj tyajiꞌn tibꞌ kyukꞌa qꞌanil, ex otaq bꞌaj tyupin jniꞌ attaq te te twiꞌ tqꞌanbꞌil, me minataq n-el weꞌ; noq kyjaꞌ nxayetaq toj il. ");
INSERT INTO mamC_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Tetziꞌn tok tbꞌiꞌn nimx yabꞌ otaq bꞌaj qꞌanit tuꞌn Jesús, kubꞌ tbꞌisin: Noqit aku chin pon kaniꞌn mikolte ttxaꞌn t-xbꞌalin, tuꞌn tul Dios weꞌy, chiꞌ. Atzaj teꞌ tpon kanin, exsin ok tmikoꞌn t-xbꞌalin, ");
INSERT INTO mamC_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","texjo paq, bꞌeꞌx tnaꞌn qa otaq tzꞌel weꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Teꞌ tnaꞌnte Jesús otaq weꞌ jun xjal tuꞌn, aj meltzꞌaj tiꞌj, ex i ok tkaꞌyin jniꞌ xjal lipcheqektaq tiꞌjile, ex xi tqanin kye: ¿Ankyeꞌ s-ok mikonte nxbꞌaliꞌn? chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Me ayetzin t-xnaqꞌtzbꞌin i xi tzaqꞌwinte: ¡Kaꞌyinktziꞌn! Jniꞌxsiꞌn txqan xjal ntlimoꞌn tibꞌ tiꞌja, exsin ntzaj tqaniꞌn, ¿Alkye s-ok mikontiy? ");
INSERT INTO mamC_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mix qeyix tkꞌuꞌj ikyjo. Nkaꞌylajtaq wen tiꞌjile aꞌltaq kyeꞌ otaq tzꞌok mikonte. ");
INSERT INTO mamC_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Me atziꞌn qya nluꞌlin wen tuꞌn t-xobꞌil, tuꞌn nqanlajtaq Jesús alkye otaq tzꞌok mikonte, bꞌeꞌx kubꞌ meje twutz, ex xi tqꞌmaꞌn tkyaqiljo jniꞌ otaq bꞌaj tiꞌj, qa otaq weꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Jesús te: Nkꞌwal, tuꞌn tnimbꞌila wiꞌja ma tzꞌel weꞌy. Kux tzꞌajxiy jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tzunxtaq nyolin Jesús tukꞌa qya, teꞌ kykanin junjun xjal iteꞌtaq tja Jayr qꞌmalte te: Tata, ma kyim tkꞌwala. Mi tzꞌok ila tiꞌj xnaqꞌtzil. Mi txi tkꞌleꞌnla tjay jaꞌlin, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Me mina, chi Jesúsjo. Xi tqꞌmaꞌn te Jayr: Mina tzaj xobꞌa, noq qek tkꞌuꞌja wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ex bꞌeꞌx i xiꞌ Jesús tja Jayr tukꞌa Pegr, tukꞌa Santyaw ex Juan, kyitzꞌin kyibꞌ, ex mix tqyaꞌye tuꞌn kyxi lipe txqantl xjal kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Teꞌ kykanin ja, i bꞌaj ok tkaꞌyin jniꞌ xjal nchi bꞌaj labꞌintaq, ex nchi bꞌaj oqꞌ wen tiꞌj kyimnin. ");
INSERT INTO mamC_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Xi tqꞌmaꞌn Jesús kye: ¿Tiquꞌn nchi labꞌin, ex nchi bꞌaj oqꞌa wen? Noq nktan teꞌ txin luꞌn, nya ma kyim, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Noqx i bꞌaj jaw tzeꞌn jniꞌ xjal tiꞌjjo tyol Jesús ikyjo. Bꞌeꞌx i bꞌajetz tlajoꞌn kykyaqil tuja, exsin i okx tkꞌleꞌn Jayr tukꞌa t-xuꞌjil exqetziꞌn oxe t-xnaqꞌtzbꞌin jaꞌ tokxitaq kyimnin. ");
INSERT INTO mamC_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jaw tiꞌn tukꞌa tqꞌobꞌ, exsin xi tqꞌmaꞌn te: Talita cum. (Atziꞌn n-ele ikyjo: Txin, kxel nqꞌmaꞌn teꞌy, ¡Weꞌksa!) ");
INSERT INTO mamC_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Noqx teꞌ t-xi tqꞌmaꞌn ikyjo te txin, bꞌeꞌx jaw weꞌks, ex el bꞌet, quꞌn te kabꞌlajaj abꞌqꞌetaqjo txin, a otaq kyim. Jotxjo jniꞌ xjal bꞌeꞌx i bꞌaj jaw kaꞌylaj, tuꞌn kylonte ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Me ante Jesús xi toqxeninxix kye, tuꞌn mix aꞌl qe txi kyqꞌmaꞌne a otaq bꞌant tiꞌjjo txin. Ex xi tqꞌmaꞌn kye, tuꞌn t-xi kyqꞌoꞌn twa. ");
INSERT INTO mamC_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Teꞌ taj Jesús tja Jayr kyukꞌa t-xnaqꞌtzbꞌin tuꞌn kykanin tojx Nazaret, ");
INSERT INTO mamC_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ex teꞌ tkꞌul kanin jun qꞌij te ajlabꞌl, xiꞌ tojjo muꞌẍ ja te naꞌbꞌl Dios, ex ok ten xnaqꞌtzil teꞌ Tyol Dios te tkyaqil xjal. Teꞌ tok kybꞌiꞌnxjal ikyjo, noq i bꞌaj jaw kaꞌylaj, ex i ja qanlaj kyxolile: ¿Jaꞌtzila xbꞌaj t-xnaqꞌtzin xjal tibꞌ luꞌn, tuꞌn tbꞌaj bꞌant jniꞌ tiꞌchaqku tiꞌ tuꞌn? ¿Jaꞌtzila saje tbꞌiꞌne txqan tumil ikyjo? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ma nyapetzilaꞌ a jsol tzꞌlan, aj tal Mariy ex kytziky Santyaw, Jse, Judas ex Simun? ¿Ma nyaqetzin tanebꞌjo najleqe qxol? chi chiꞌ. Tuꞌn kyojtzqiꞌntaq, mix xaye kynimine. ");
INSERT INTO mamC_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Me xi tqꞌmaꞌn Jesús kye: Jaꞌchaqx taꞌ jun yolil Tyol Dios twutz txꞌotxꞌ, nxi qꞌoꞌnx toklin. Me qa tojx ttxꞌotxꞌ, ex kyxol t-xjalil, ex tojx tja, ntiꞌx toklin. ");
INSERT INTO mamC_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tuꞌn ntiꞌtaq kynimbꞌiljo t-xjalil tiꞌj, nya niml bꞌant tuꞌn, noq jteꞌbꞌinl yabꞌ kubꞌ tqꞌoꞌn tqꞌobꞌ kyibꞌaj, ex i kubꞌ tqꞌanin; me oꞌkqexjo attaq kynimbꞌil tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ex noq jaw kaꞌylaj tuꞌn, tuꞌn mix xaye nimine kyuꞌn jniꞌ t-xjalil. Bꞌeꞌxsin xiꞌtz xnaqꞌtzil kyojjo najbꞌil nqayin tkꞌatz Nazaret. ");
INSERT INTO mamC_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I tzaj ttxkoꞌn kabꞌlajaj t-xnaqꞌtzbꞌin, tuꞌn kyxiꞌ yolil teꞌ Tyol Dios, ex xi tqꞌoꞌn kyoklin kyibꞌajjo taqꞌnil tajaw il, a iteꞌkxtaq toj kyanminxjal; ex i xi tchqꞌoꞌn kakabꞌchaq kybꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Me nej xi tqꞌmaꞌn kye: Mina txi kyiꞌn jun tiꞌ, tuꞌn tajbꞌin toj kybꞌeꞌy; qalaꞌ noq jun tal kytzeꞌy. Ex mipe txi kyiꞌn kyeꞌ kychꞌuꞌẍ, kywaꞌy ex kypwaqa. ");
INSERT INTO mamC_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bꞌaꞌn tuꞌn tok kyqꞌoꞌn kyxjabꞌa, me mi txi kyiꞌn kyxbꞌaliꞌn te txꞌixpil kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Quꞌn aj kykaniꞌn qꞌmal Tyol Dios toj jun najbꞌil, kꞌaꞌ chi kyija toj jun ja, ajxi kyikyꞌa toj juntl najbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Me metziꞌn, aj qa at jun najbꞌil, a jaꞌ kykyꞌeꞌyexjal kyiꞌja, bꞌeꞌx liwey chi etza antza. Me bꞌeꞌx kꞌaꞌ tzꞌel kychtoꞌn quq tiꞌj kyqaꞌn kywutzjo xjal tojjo tnam anetziꞌn, tuꞌn tajbꞌin te techil kye, qa mina xkubꞌ kybꞌiꞌn Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","I xitziꞌn t-xnaqꞌtzbꞌin yolil teꞌ Tyol Dios kyxol xjal, tuꞌn tjaw kytxꞌixpin kyibꞌ, tuꞌn tkubꞌ kynimin Tyol Dios, ex tuꞌn t-xi kyqꞌoꞌn kyanmin te. ");
INSERT INTO mamC_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nimx xjal bꞌaj exjo taqꞌnil tajaw il toj kyanmin, ex bꞌaj ul Dios kye kyuꞌn, noq tukꞌa chꞌin aseyt. ");
INSERT INTO mamC_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Atziꞌn Herodes, a tnejil kawil, tbꞌinte tqanil Jesús, ex jniꞌ otaq bꞌaj bꞌant tuꞌn kyojile kykyaqil najbꞌil. Otaq jaw yolbꞌil tiꞌj kyuꞌnxjal: Junjun qꞌmante qa ataq Juan, a Jawsil Aꞌ, otaq jaw anqꞌin juntl majl, quꞌn tuꞌn nimxjo nbꞌant tuꞌn, ex tbꞌanilx wen. ");
INSERT INTO mamC_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","At junjuntl qꞌmante: A Elías, a yolil Tyol Dios. Ex junjuntl qꞌmante: Jun yolil Tyol Dios tzeꞌnkuj yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Atzin teꞌ tok tbꞌiꞌn Herodes ikyjo, tqꞌma: Antej Juan, aj el wiꞌn twiꞌ, ex ma jaw anqꞌin juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Otaq kux tjpuꞌn Herodes Juan toj tze, noq tuꞌn tpaj Herodías, a t-xuꞌjiltaq Lip, a titzꞌinx, quꞌn otaq jaw meje tukꞌa Herodías. Noq tuꞌn tpajjo, xi tqꞌmaꞌn Juan te Herodes, qa nya wentaq tuꞌn tok t-xuꞌjlin t-xuꞌjil titzꞌin. Tuꞌn tpajjo ikyjo, tzaj tqꞌoj Herodías tiꞌj Juan, ex noq tuꞌn tpaj, kux tjpuꞌn Herodes Juan toj tze, ex kubꞌ tkꞌloꞌn wen tukꞌa kxbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tajtaq Herodías tuꞌn tkubꞌ bꞌyet Juan, me mina ntentaq tumil toj twutz, tzeꞌn tuꞌn ttene, ");
INSERT INTO mamC_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","quꞌn nxobꞌtaq Herodes tiꞌj Juan, quꞌn tuꞌn wentaq ex xjantaq, ex nyolintaq Tyol Dios. Tuꞌntziꞌn, mina nttziyintaq Herodes tuꞌn tkubꞌ bꞌyet, quꞌn tajtaq bꞌin wen tiꞌjjo tyol Juan. Tuꞌntziꞌn ikyjo, ntiꞌtaq tumil toj twutz Herodías tzeꞌn tuꞌn ttene. ");
INSERT INTO mamC_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Me japin kanin jun qꞌij, jaꞌ tuꞌn tkubꞌe bꞌyoꞌne Juan, noq tpajlin kubꞌ ikyꞌsit tabꞌqꞌe Herodes. I tzaj ttxkoꞌn Herodesjo jniꞌ tkawil, jniꞌ kynejil xqꞌuqil tnam ex jniꞌqexjo a nim kyoklin toj Galiley, exsin kubꞌ tqꞌoꞌntz chnabꞌ, xi tqꞌoꞌn kywa ex kykꞌwaꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nchi bꞌaj waꞌntaq ex nchi bꞌaj txꞌujtetaq, teꞌ tokpin jun txin tal Herodías, exsin ok tentz bꞌixil kyxol. Me jotqex bꞌeꞌx pon kykꞌuꞌj tiꞌj, quꞌn tbꞌanilxnaj bꞌant tuꞌn. Tuꞌntziꞌn ikyjo, xi tqꞌmaꞌn Herodes te: Qanintzin weꞌy tiꞌxjo taja, ex kꞌaꞌ txi nqꞌoꞌn, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ex kubꞌ tqꞌmaꞌn tbꞌi Dios tiꞌj tyol kabꞌe maj, tej t-xi tqꞌmaꞌn te txin: Kxel nqꞌmaꞌn tey, qa aku txi nqꞌoꞌn noq tiꞌx taja, exla qa nikyꞌjin txꞌotxꞌ, a tokx tjaqꞌ nkawbꞌila, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tej tbꞌin teꞌ txin ikyjo, etz qanilte te tnana: ¿Tiꞌn kxel nqaniꞌn? chiꞌ. Xi ttzaqꞌwin tnana: Qaninxjiy twiꞌ Juan, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Xi rinin txin qꞌmalte te Herodes: Waja tuꞌn ttzaj tqꞌoꞌn jaꞌlinxix a twiꞌ Juan, a Jawsil Aꞌ, weꞌy toj jun laq. ");
INSERT INTO mamC_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Teꞌ t-xi tqanin txin ikyjo te Herodes, bꞌeꞌx jaw bꞌisin, quꞌn otaq kubꞌ tqꞌmaꞌn tyol tiꞌj tbꞌi Dios kywutz txqan xjal, tuꞌn t-xi tqꞌoꞌn tiꞌxtaq tajjo txin. Tuꞌnpetziꞌn, mix kubꞌe tzyuꞌne tibꞌ, tuꞌn t-xi tqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bꞌeꞌx xi tchqꞌoꞌnkux jun xqꞌuqil tnam, tuꞌn tel ttxꞌemin twiꞌ Juan, ex tuꞌn ttzaj tiꞌn. Teꞌ tkanin toj tze, bꞌeꞌx el ttxꞌemin twiꞌ Juan, ");
INSERT INTO mamC_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","exsin xi tiꞌn toj jun laq. Xi tqꞌoꞌn te txin, tuꞌn t-xi tiꞌn te tnana. ");
INSERT INTO mamC_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Atzaj teꞌ kybꞌin teꞌ t-xnaqꞌtzbꞌin Juan qa otaq kyim, bꞌeꞌx i xtaꞌj qꞌilte t-xmilil, tuꞌn tkux muqet. ");
INSERT INTO mamC_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tbꞌajlinxiꞌ ikyjo, teꞌ kybꞌaj meltzꞌaj t-xnaqꞌtzbꞌin, bꞌaj ok kychmoꞌn kyibꞌ kykyaqilx tukꞌa Jesús, ex bꞌaj i ok ten qꞌmalte jniꞌ otaq bꞌaj bꞌant kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Xi tqꞌmaꞌn Jesús kye: Qoqechꞌin ajlal toj jun najbꞌil jaꞌ ntiꞌye xjal. Quꞌn atziꞌn jaꞌ iteꞌyetaq nimxtaq xjal nbꞌaj kanin kykꞌatz, ex mixpe tuꞌn tbꞌant kywaꞌn kyxolxjal. ");
INSERT INTO mamC_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bꞌeꞌxsin xiꞌ Jesús kyukꞌa t-xnaqꞌtzbꞌin toj jun bark toj jun najbꞌil jaꞌ ntiꞌyetaq xjal. ");
INSERT INTO mamC_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Me nimx xjal te ilaꞌku tnam el kynikyꞌ kyiꞌj, ex xi kykaꞌyin, tej kyxiꞌ jaꞌ tajtaq Jesús exqetziꞌn t-xnaqꞌtzbꞌin tuꞌn kykanin. Bꞌeꞌxsin i bꞌaj xi tiljtz antza, ex nej i bꞌaj pon. ");
INSERT INTO mamC_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Noqx teꞌ tkuꞌtz Jesús toj bark, i xi tkaꞌyin txqan xjal, ex bꞌeꞌx tzaj qꞌaqꞌin tkꞌuꞌj kyiꞌj, quꞌn ikyqetaqjo tzeꞌnku txqan rit ntiꞌ kyikꞌlel kyiꞌj. Tuꞌnpetziꞌn, ok ten xnaqꞌtzilkye. ");
INSERT INTO mamC_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Teꞌ qok yupj, xi kyqꞌmaꞌn t-xnaqꞌtzbꞌin te: Ma qoqixte. Chqꞌonqexjiy xjal tuꞌn kyxiꞌ tojile najbꞌil ex kyojile muchꞌ tnam, tuꞌn kyxiꞌ laqꞌol kywa, quꞌn ntiꞌ bꞌaꞌn txi kywaꞌn tzaluꞌn, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ante Jesús xi ttzaqꞌwin kye: Kyqꞌoꞌnxa kywa. Xitzin kytzaqꞌwin t-xnaqꞌtzbꞌin: ¿Tajtzin tuꞌn qxiꞌy laqꞌol wabꞌj kye, ex tuꞌn tkubꞌ yupit txqan qpwaq te twiꞌ? ");
INSERT INTO mamC_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Me i xi ttzaqꞌwin Jesús: ¿Jteꞌn wabꞌj at? Ku kyxiꞌtziꞌn lolte, chiꞌ. Teꞌ kymeltzꞌaj, xi kyqꞌmaꞌn te: Noq jweꞌchꞌin, ex kabꞌe tal netzꞌ kyiẍ. ");
INSERT INTO mamC_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Xi tqꞌmaꞌn kye jniꞌ xjal tuꞌn kybꞌaj kubꞌ qe twiꞌ txaꞌx kꞌul toj junjun chꞌuq. ");
INSERT INTO mamC_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","I kubꞌtzin qe junjun chꞌuq te junjun jweꞌ kꞌal ex junjuntl te lajaj toj ox kꞌal, ");
INSERT INTO mamC_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","exsin i jaw ttzyuꞌn Jesúsjo jweꞌ wabꞌj exqetziꞌn kabꞌe tal kyiẍ. Jax kaꞌyin toj kyaꞌj, ex xi tqꞌoꞌn chjonte te Dios, ex bꞌaj xi tsipin kye t-xnaqꞌtzbꞌin, tuꞌn tbꞌaj kubꞌ kysipin kye jniꞌ xjal. ");
INSERT INTO mamC_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Elpin kanin te tkyaqil, ex noqx jniꞌ bꞌaj noj. ");
INSERT INTO mamC_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Teꞌ kybꞌaj waꞌn kykyaqilx, exsin bꞌaj jaw kychmoꞌn jniꞌ tbꞌuchil wabꞌj, kabꞌlajaj chiꞌl bꞌant. ");
INSERT INTO mamC_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Atziꞌn kybꞌajjo ichin bꞌaj waꞌn, jweꞌ mil. ");
INSERT INTO mamC_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tbꞌajlinxiꞌ ikyjo, i jax tchqꞌoꞌn Jesús t-xnaqꞌtzbꞌin toj bark, ex xi tqꞌmaꞌn kye, tuꞌn kyikyꞌx tjlajxi nijabꞌ, tuꞌn kykanintaq tojjo juntl tnam, Betsaida, me ataq tajjo tuꞌn kynej twutz. Bꞌeꞌx i xiꞌ, ex ante Jesús kyij qꞌolbꞌil kyeꞌ jniꞌ xjal. ");
INSERT INTO mamC_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Teꞌ kybꞌaj kykyij tqꞌolbꞌin, bꞌeꞌx xiꞌkux naꞌl Dios twiꞌ jun wutz. ");
INSERT INTO mamC_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Teꞌ qok sjumeꞌ, ayetziꞌn t-xnaqꞌtzbꞌin chꞌixtaq kykanin nikyꞌjin nijabꞌ. Me ante Jesús kyij tjunalx ttzi aꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Chebꞌe nchi bꞌet, teꞌ kyxi tkaꞌyin, quꞌn kyjaꞌtaq ntzaje kyqꞌiqꞌ tumil kybꞌe. Qnuminx wen, teꞌ t-xi bꞌet Jesús tibꞌaj aꞌ, nyakuj tuꞌn tnej kywutz. ");
INSERT INTO mamC_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Teꞌ tiwle kyuꞌn t-xnaqꞌtzbꞌin, bꞌeꞌx i xobꞌx kykyaqilx, ex ox chi ẍchꞌinx wen, quꞌn kubꞌ kybꞌisin qa jun klelin. Me bꞌeꞌx xi tqꞌmaꞌn Jesús kye: ¡Kykujsinx kykꞌuꞌja! ¡Ayin wejiꞌy! ¡Mi chi xobꞌa! chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jax Jesús toj bark kykꞌatz, ex bꞌeꞌx kubꞌ qen te kyqꞌiqꞌ. Ayetzin t-xnaqꞌtzbꞌin noq i bꞌaj jaw kaꞌylaj, ");
INSERT INTO mamC_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","quꞌn ex naꞌmtaq tel kynikyꞌ te, tiꞌ bꞌant tuꞌn kyiꞌj wabꞌj ex kyiꞌj kyiẍ, ex tzeꞌn tten tbꞌant tkyaqiljo ikyjo tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tkanin Jesús kyukꞌa t-xnaqꞌtzbꞌin toj jun najbꞌil, Genesaret tbꞌi. Teꞌ kykanin, ok kykꞌloꞌn bark ttzi nijabꞌ tiꞌj jun tze. ");
INSERT INTO mamC_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Noqx teꞌ kykutz toj bark, bꞌeꞌx el tnikyꞌtzajil Jesús kyuꞌnxjal, ");
INSERT INTO mamC_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ex bꞌeꞌx i ok ten rinil qꞌmalte tqanil, ex bꞌaj pon kyiqin jniꞌ kyyabꞌ twiꞌ iqbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bꞌettzin Jesús antza kyojile najbꞌil ex kyojile tnam. Ayetzin xjal bꞌaj xi kyiꞌn kyyabꞌ toj tbꞌe Jesús, ex tzunxtaq nchi bꞌaj kubꞌsin kywutz te, tuꞌn kyok tmikoꞌn iꞌchaqx oꞌkxtaqjo ttxaꞌn t-xbꞌalin, quꞌn ayetziꞌn i bꞌaj ok mikonte bꞌeꞌx i bꞌajel weꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","I tzaj laqꞌe junjun Parisey, junx kyukꞌa junjun xnaqꞌtzil tiꞌj ojtxe kawbꞌil tkꞌatz Jesús, aye otaq chi kanin Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Teꞌ tok kykaꞌyin junjun t-xnaqꞌtzbꞌin Jesús, qa mix i txꞌajine, teꞌ kyok ten waꞌl, tzeꞌnku ntenetaq kyuꞌn Parisey exqetziꞌn jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil; tuꞌntzin ikyjo, i bꞌaj ok ten yolbꞌilkye. ");
INSERT INTO mamC_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Quꞌn ayetziꞌn Parisey exqetziꞌn xjal antza lipcheqektaq tiꞌjjo xnaqꞌtzbꞌil, a kyij yekꞌin kye kyuꞌn qtzan kytaꞌẍ, nlayxtaq chi waꞌn qa mina ẍi txꞌajin nej toj jun tumil tzeꞌnkuxjo nbꞌanttaq kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ex tzeꞌnku nchi meltzꞌaj loqꞌil, nlay cheꞌx waꞌl, qa mina ẍi txꞌajin. Ex atx txqantl, tzeꞌnku tuꞌn tbꞌaj ja txjet jniꞌ tkꞌwel kykꞌwaꞌ, jniꞌ kyxar, jniꞌ kylaq kxbꞌil ex jniꞌ kywatbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tuꞌnpetziꞌn, xi kyqanin Parisey exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil te Jesús: ¿Titzin quꞌn mina nkubꞌ kynimin t-xnaqꞌtzbꞌiꞌn a jniꞌ kyij yekꞌin qe ojtxe kyuꞌn qtzan qtaꞌẍ? Quꞌn mina nchi txꞌajin tzeꞌn nchi waꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","I xi ttzaqꞌwin Jesús: Twutzx tej tqꞌma yolil Tyol Dios, a Isaías ojtxe, tiꞌjjo kyxmiletzꞌila, teꞌ tqꞌma: A ayiꞌy nchin nkubꞌ kynaꞌn, me noq tukꞌa kytziꞌy. Me atzin kyanmiꞌn tzunx nloꞌchj wen. ");
INSERT INTO mamC_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ntiꞌx tajbꞌin nchin kubꞌ kynaꞌn ikyjo, quꞌn antza tiꞌjjo t-xnaqꞌtzbꞌil ichin lipcheqekiy. ");
INSERT INTO mamC_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ma kyij kytzaqpinjiꞌy tkawbꞌil Dios, noq tuꞌn tkubꞌ kybꞌinchinkujiꞌy a kye kyajbꞌil, ");
INSERT INTO mamC_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ex tuꞌn mina tzꞌel naje toj kykꞌuꞌja, ma kyij kytzaqpinjiꞌy te Dios. ");
INSERT INTO mamC_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Quꞌn tqꞌma Dios tuꞌn tsan, a Moisés: Kyniminku kytatiy ex kynaniy, chiꞌ, ex ankye teꞌ k-elil tzaqpaj ttzi te ttata ex te tnana, il tiꞌj tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Me ankyeꞌ nkyqꞌmaꞌn, qa at jun manbꞌaj mo jun txubꞌaj xkanin qanil jun tiꞌ te tkꞌwal mo te tal, bꞌaꞌn tuꞌn t-xi tqꞌmaꞌn kꞌwalbꞌaj te: Mina. Nlay txi nqꞌoꞌn kyeꞌy, quꞌn jotxjo jniꞌ at weꞌy corban, atzin n-ele kxel nqꞌoꞌn te Dios, aj nkyima. ");
INSERT INTO mamC_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ex nkyqꞌmaꞌn: Aꞌltziꞌn kqꞌmalte ikyjo, ntiꞌl il tiꞌj tuꞌn tmojin tiꞌj ttata mo tiꞌj tnana. ");
INSERT INTO mamC_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ikytziꞌn ma bꞌajel kyikyꞌinejiꞌy a Tkawbꞌil Dios, tuꞌn tpajjo kyij yekꞌiꞌn kyeꞌy kyuꞌn qtzan kytaꞌẍa. Ex nimx txqantl nbꞌaj kubꞌ kybꞌinchiꞌn tzeꞌnqeku lo. ");
INSERT INTO mamC_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","I xi ttxkoꞌn Jesús jniꞌ xjal tkꞌatz, ex xi tqꞌmaꞌn kye: Chin kybꞌintziꞌn, ex tzꞌelku kynikyꞌa te: ");
INSERT INTO mamC_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nya teꞌ tiꞌchaqku tiꞌ nbꞌaj tuꞌn jun xjal, nxi qꞌonte toj il, qalaꞌ ikytzin a teꞌ n-etz toj ttzi, quꞌn toj tanmin njatze. ");
INSERT INTO mamC_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Alkye taj tuꞌn tok tbꞌiꞌn in tok tbꞌiꞌntz, exsin in tkubꞌ tbꞌinchiꞌntz. ");
INSERT INTO mamC_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tbꞌajlinxitziꞌn ikyjo, el tpaꞌn Jesús tibꞌ kyukꞌa t-xnaqꞌtzbꞌin, exsin i okx toj jun ja antza. Xi kyqanin t-xnaqꞌtzbꞌin tiꞌjjo bꞌaj tqꞌmaꞌn, ex tiꞌtaq tzꞌelpine. ");
INSERT INTO mamC_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Xi tqꞌmaꞌn kye: Ex ikyx kyejiꞌy, ¿Mi s-el pjet toj kynabꞌla? ¿Ma mitzin n-el kynikyꞌa te qa tkyaqiljo nbꞌaj tuꞌn jun xjal, nlay txi tiꞌn toj il, ");
INSERT INTO mamC_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","quꞌn toj tkꞌuꞌj nbꞌaj kupine, ex nya toj tanmin, ex tqanku n-exl? (Antza ntqꞌmaꞌne qa a jniꞌ nxi tnikyꞌbꞌin jun xjal, ntiꞌ tkyꞌi.) ");
INSERT INTO mamC_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Me a nbꞌajetz toj ttzi, apente iljo, ");
INSERT INTO mamC_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","quꞌn tuꞌn toj tanmin nbꞌaj tzaj anqꞌine. Ex toj tanminxjal nbꞌaj tzaj anqꞌine jniꞌ nya wen ex tuꞌn tbꞌaj kubꞌ bꞌinchit: Tzeꞌnku aj pajil, tzeꞌn elqꞌin, jniꞌ bꞌiꞌyin, ");
INSERT INTO mamC_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tzeꞌnku tkyaqil kyꞌaꞌjin, ex tuꞌn tpon tkꞌuꞌj jun xjal tiꞌjjo at te juntl, ex jniꞌ sbꞌubꞌl, ex tkyaqil tzeqbꞌil, ex jniꞌ loꞌchj kꞌuꞌjbꞌaj, ex jniꞌ iqj yol, ex jniꞌ kynimsil kyibꞌxjal, exqetziꞌn ntiꞌ kynabꞌl. ");
INSERT INTO mamC_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tkyaqilxjo jniꞌ tiꞌchaqku tiꞌ, a nya wen, nbꞌaj kubꞌ kybꞌinchin, ex tuꞌn anetziꞌn nchi bꞌinchine il, quꞌn tuꞌn toj kyanmin nbꞌaj tzaj anqꞌine jniꞌ ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bꞌeꞌxsin xiꞌ Jesús toj jun najbꞌil najchaq, Tiro, tbꞌi. Okx toj jun ja kyukꞌa t-xnaqꞌtzbꞌin; tkyꞌeꞌtaq tuꞌn tiwle tuꞌn aꞌla, me mix bꞌante tewin, ");
INSERT INTO mamC_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","quꞌn el tqanil toj twiꞌ jun qya aj Sirofenisia, jun qya nya Judiy. Me atziꞌn qya attaq jun ttxin tokxtaq jun taqꞌnil tajaw il toj tanmin. Teꞌ tkanin, kubꞌ meje twutz Jesús, ex kubꞌsin twutz te, tuꞌn tex tlajoꞌn taqꞌnil tajaw il toj tanmin tal. ");
INSERT INTO mamC_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Me ante Jesús xi tqꞌmaꞌn te: Yonkuy nej, tuꞌn kyxi nmojinjiꞌy nxjalila, quꞌn nya wen tuꞌn tel kywa tal kꞌwal, exsin tuꞌn t-xiꞌ kye chit, quꞌn noqit tuꞌn kybꞌaj waꞌn tal kꞌwal nej, exsin kxel xiljo kye chittz. Ikyqintzin wejiꞌy kyukꞌa nxjalila; nej kchi okil nkaꞌyiꞌn, ex kxel nqꞌoꞌnjiꞌy kyeꞌ a ntiꞌ at kye. ");
INSERT INTO mamC_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ex xi ttzaqꞌwin qya: Ikyx te tten, Tata. Me kaꞌntzin kye tal chit nchi waꞌn kye tjaqꞌ meẍ tiꞌjjo tbꞌuchil wabꞌj nbꞌajel tzꞌaq kyuꞌn kyajaw. Ikyqintzintla wejiꞌy, qꞌontz chꞌin weꞌ tiꞌjjo nxi tqꞌoꞌn kye t-xjalila. ");
INSERT INTO mamC_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tuꞌntziꞌn tyoljo qya ikyjo, xi ttzaqꞌwin Jesús te: At nim tnimbꞌila wiꞌja, tuꞌn ẍin tzaj ttzaqꞌwin ikyjo. Kux tzꞌajxiy tjay. Atzin taqꞌnil tajaw il ma tzꞌex toj tanmin tala. ");
INSERT INTO mamC_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Atzin teꞌ tkanin qya tja, kuẍletaqjo tal twiꞌ twatbꞌil, quꞌn otaq tzꞌexjo taqꞌnil tajaw il toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Etz Jesús tojjo txꞌotxꞌ, jaꞌ i ponin kyukꞌa t-xnaqꞌtzbꞌin, ex i ikyꞌku tojjo najbꞌil Sidón, tuꞌn kykanin juntl majl toj ttxꞌotxꞌ Decápolis, ttzi Nijabꞌ te Galiley. ");
INSERT INTO mamC_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tej tkanin antza, qꞌiꞌn jun xjal ẍonẍ ex xtiq twutz, ex xi kyqꞌmaꞌn a iqilte te Jesús, tuꞌn tkubꞌ tqꞌoꞌn tqꞌobꞌ tibꞌaj tuꞌn tel weꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ex kypaꞌn Jesús kyibꞌ kyjunalx tukꞌaꞌ xjal, jaꞌ mixtaq aꞌl at, exsin i okx tqꞌoꞌn twiꞌ tqꞌobꞌ kyoj tẍkyin, ex i ok takꞌsin twiꞌ tqꞌobꞌ tukꞌa taꞌl ttzi. Ok tmikoꞌn taqꞌjo xjal, ");
INSERT INTO mamC_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ex jaw kaꞌyin twutz kyaꞌj, ex jaw t-xew. Xi tqꞌmaꞌn te ichin: Efata. Atziꞌn n-ele, ku kyxi jaqliych. ");
INSERT INTO mamC_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Texjo tqan, bꞌeꞌx i jqet tẍkyin ẍonẍ, ex bꞌeꞌx bꞌant tyolin. ");
INSERT INTO mamC_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Teꞌ kyul kykꞌatzjo xjal, xixix toqxenin Jesús kye, tuꞌn mix aꞌl qe, tuꞌn t-xi kyqꞌmaꞌn a otaq bꞌant tiꞌjjo ẍonẍ ex xtiq. Me teꞌ t-xi tqꞌmaꞌn ikyjo kyexjal, noqx kyjaꞌ i ok tenil qꞌmalte tqanil. ");
INSERT INTO mamC_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Otaq chi bꞌaj jaw kaꞌylaj tuꞌn ikyjo, ex kyqꞌma: Tkyaqilx tbꞌanilx nbꞌaj bꞌant tuꞌn. A ajinqe ẍonẍ nbꞌaj bꞌant kybꞌiꞌn, ex xtiq nbꞌaj bꞌant kyyolin tuꞌn, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jun qꞌij ok kychmoꞌn txqan xjal kyibꞌ kyukꞌa, ex ntiꞌtaq tuꞌn t-xi kywaꞌn. I xi ttxkoꞌn Jesúsjo t-xnaqꞌtzbꞌin, exsin xi tqꞌmaꞌn kye: ");
INSERT INTO mamC_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Nchyoꞌn nkꞌuꞌja kyiꞌjjo xjal lo, quꞌn ma bꞌant-xi oxe qꞌij kytenbꞌile qukꞌa, ex ntiꞌx chꞌin o txi kywaꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Qa ma chi aj nchqꞌoꞌn kyja kukxjo, aku chi bꞌaj kubꞌ numj toj bꞌe tuꞌn waꞌyaj, quꞌn at junjun najchaq saje. ");
INSERT INTO mamC_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Xi kytzaqꞌwin t-xnaqꞌtzbꞌin: ¿Me jaꞌn bꞌaꞌn tuꞌn ttzaje kywa txqan xjal? Mix yaꞌ tuꞌn ntiꞌx jun xjal najle tzaluꞌn, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Xi tqanin Jesús kye: ¿Jteꞌn wabꞌj qꞌiꞌn kyuꞌn? Noq tal wuq, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Xi tqꞌmaꞌn Jesús kye jniꞌ xjal, tuꞌn kybꞌaj kubꞌ qe, ex i jaw ttzyuꞌn wabꞌj toj tqꞌobꞌ. Xi tqꞌoꞌn chjonte te Dios kyiꞌj, bꞌaj kubꞌ tpiẍin, exsin ok ten sipilte kye t-xnaqꞌtzbꞌin, tuꞌn tbꞌaj kubꞌ kysipin kyxoljo jniꞌ xjal. ");
INSERT INTO mamC_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ex qꞌiꞌntaq junjun tal netzꞌ kyiẍ kyuꞌn. Ex ikyxljo xi tqꞌoꞌn chjonte kyiꞌj te Dios, ex xi tsipin kye t-xnaqꞌtzbꞌin, tuꞌn tbꞌaj kubꞌ kysipin kyxolxjo jniꞌ xjal. ");
INSERT INTO mamC_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Noqx jniꞌ i bꞌaj waꞌn kykyaqilx. Atziꞌn teꞌ tbꞌaj jaw chmetjo jniꞌ tbꞌuchil, bꞌant wuq chiꞌl. ");
INSERT INTO mamC_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ayetziꞌn xjal, a i bꞌaj waꞌn, chꞌime kyaje mil kybꞌaj kykyaqilx. Ex bꞌeꞌx i bꞌaj aj tchqꞌoꞌn, tuꞌn kybꞌaj aj kyja kykyaqil. ");
INSERT INTO mamC_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bꞌeꞌxsin xiꞌkux kyukꞌa t-xnaqꞌtzbꞌin toj jun bark, tuꞌn kykanin tojjo jun najbꞌil Dalmanuta tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","I pon chmet Parisey tkꞌatz Jesús, ex i ok ten yolil tukꞌa. Ex noq tuꞌn tkubꞌ tzꞌaq kyuꞌn toj til, xi kyqanin te, tuꞌn tkubꞌ tbꞌinchin jun tbꞌanil techil tipin twutz kyaꞌj, tuꞌn tyekꞌin qa te Dios tzajnin. ");
INSERT INTO mamC_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tzaj tbꞌis Jesús tuꞌn ikyjo, ex xi tqꞌmaꞌn kye: ¿Tiꞌtzila quꞌn ntzaj kyqanin xjal techil jun tiꞌ, tuꞌn tkubꞌ nbꞌinchiꞌn? Twutzxix kxel nqꞌmaꞌn kyeꞌy; mixla juntl techil kꞌwel nqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bꞌeꞌx i kyij ttzaqpiꞌn antza, ex bꞌeꞌx okx toj bark kyukꞌa t-xnaqꞌtzbꞌin, tuꞌn kyjlajinx tjlajxiꞌ nijabꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mi naꞌn kywa t-xnaqꞌtzbꞌin tuꞌn t-xi kyiqin; oꞌkx junchꞌintaq kywa tokx toj bark. ");
INSERT INTO mamC_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Xi tqꞌmaꞌn Jesús kye: Bꞌaꞌnx chi kaꞌyin kyibꞌa noq cheꞌxa tiꞌjjo txꞌamsbꞌil kywa Parisey ex txꞌamsbꞌil twa Herodes. ");
INSERT INTO mamC_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","I ok ten t-xnaqꞌtzbꞌin yolil kyxolx tiꞌj kywa. ");
INSERT INTO mamC_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Me i bꞌijte tuꞌn Jesús, exsin xi tqꞌmaꞌn kye: ¿Tiquꞌn nchi bꞌisiꞌn qa ntiꞌ kywaꞌy iqin? ¿Naꞌmxsin tel kynikyꞌa te? ¿Jpuꞌnxsin kynabꞌla te jun majx? ");
INSERT INTO mamC_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿A iteꞌ kywutza, me mina nkyloꞌn? ¿Iteꞌ kyẍkyiꞌn, me mina nkybꞌiꞌn? ¿Minatzin naꞌn kyuꞌn? ");
INSERT INTO mamC_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tej tbꞌaj nsipinjiꞌy jweꞌ wabꞌj kyxol jweꞌ mil ichin, ¿Jteꞌn chiꞌljo tbꞌuchil jaw kychmoꞌn? Xi kytzaqꞌwin t-xnaqꞌtzbꞌin: Kabꞌlajaj, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ex tej tbꞌaj nsipinjiꞌy wuq wabꞌj kyxoljo kyaje mil, ¿Jteꞌn chiꞌljo tbꞌuchil jaw kychmoꞌn? Xi kytzaqꞌwin juntl majl: Wuq. ");
INSERT INTO mamC_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Me yajtzin qetz, mi n-el kynikyꞌa te. ¿Ma nlan kanin jun wabꞌj qxol? ");
INSERT INTO mamC_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tbꞌajlinxiꞌ ikyjo, i kanin tojjo jun najbꞌil, Betsaida. Teꞌ kykanin, pon qꞌiꞌn jun moẍ tkꞌatz Jesús. I kubꞌsin kywutzjo qꞌilte te, tuꞌn tkubꞌ tqꞌoꞌn tqꞌobꞌ tibꞌaj, tuꞌn tkubꞌ tqꞌanin, ");
INSERT INTO mamC_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ex bꞌeꞌx xi t-xkoꞌn Jesúsjo moẍ ttxanxi tnam. Teꞌ kykanin antza, i ok takꞌsin twutzjo moẍ tukꞌa taꞌl ttzi, ex kubꞌ tqꞌoꞌn tqꞌobꞌ tibꞌaj, ex xi tqanin te qa otaq tli jun tiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bꞌeꞌx i jqet chꞌin twutzjo moẍ, ex tqꞌma: Ma bꞌant chꞌin we nkaꞌyin, me noq chꞌin, quꞌn ayetziꞌn ichin ncheꞌx nkaꞌyiꞌn nyakuj tzeqe nchi bꞌet. ");
INSERT INTO mamC_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Teꞌ kyok tmikoꞌn Jesús juntl majl twutzjo moẍ, bꞌeꞌx el spikyꞌeꞌ kyiꞌj twutz, ex bꞌeꞌx bꞌant tkaꞌyin wen. Texjo tqan, bꞌeꞌx ul Dios te ichin. ");
INSERT INTO mamC_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bꞌeꞌxsin aj tchqꞌoꞌn Jesús tuꞌn taj tja, me nej xi tqꞌmaꞌn te: Mina meltzꞌajla toj tnam, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx i xiꞌ Jesús kyukꞌa t-xnaqꞌtzbꞌin kyojjo muchꞌ najbꞌil toj tnam te Cesarea Filipo. Nchi bꞌaj bꞌettaq, teꞌ t-xi tqanin Jesús kye: ¿Ankyeqiꞌn toj kywutzjo jniꞌ xjal? chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xi kytzaqꞌwin t-xnaqꞌtzbꞌin kyjaluꞌn: At junjun nqꞌmaꞌnte qa ajiy qtzan Juan, a Jawsil Aꞌ; at junjuntl nqꞌmaꞌnte qa ajiy Elías, a yolil Tyol Dios. Ex at junjuntl nqꞌmaꞌnte qa ajiy jun yolil Tyol Dios jaw itzꞌje juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","¿Yajtzin kye toj kywutz? ¿Ankyeqiꞌn? chi Jesúsjo. Xi ttzaqꞌwin Pegr: A tejiy Crist, a skꞌoꞌnxix tuꞌn Dios, tuꞌn tul tzaluꞌn twutz txꞌotxꞌ, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Xi tqꞌmaꞌn Jesús kye, tuꞌn mina chi ok tene qꞌmalte kye jniꞌ xjal. ");
INSERT INTO mamC_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ok tenl Jesús xnaqꞌtzil kye t-xnaqꞌtzbꞌin. Xi tqꞌmaꞌn kye: Ayiꞌn, a Tkꞌwal Ichin, a skꞌoꞌnxix tuꞌn Dios, nimx kykyꞌelix wuꞌn, ex ok kchin elil iꞌjliꞌn kyuꞌn kynejilxjal ex kyuꞌn kynejil pale junx kyukꞌa tkyaqil xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Kchin kꞌwel bꞌyoꞌn kyuꞌn, me toj toxin qꞌij kchin jawil anqꞌintla juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tej tbꞌaj tyolin Jesús, ex teꞌ tbꞌinte Pegr ikyjo, bꞌeꞌx ex tkꞌleꞌn najchaq chꞌintl, exsin ok ten yisolte tuꞌn tqꞌma, qa tuꞌntaq tbꞌajjo jniꞌ ikyjo tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ajtz meltzꞌaj Jesús kaꞌyil kyiꞌjjo t-xnaqꞌtzbꞌin, exsin ok ten yisolte Pegr: ¡Pegr! Ayetziꞌn tyola ikyjo, tyol tajaw il, quꞌn a taj tajaw iljo tuꞌn tbꞌantjo kyaj xjal, ex nya a taj Dios. ¡Ay, tajaw il, laqꞌemila nkꞌatza! chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bꞌeꞌxsin i xi ttxkoꞌn Jesús t-xnaqꞌtzbꞌin exsin jniꞌ xjal, ex xi tqꞌmaꞌn kye: Ankye jun taj tuꞌn tok te nxnaqꞌtzbꞌiꞌn, il tiꞌj tuꞌn tel tiꞌn toj tkꞌuꞌj tkyaqil tajbꞌil, ex tuꞌn t-xi tqꞌoꞌn tibꞌ, tuꞌn t-xi lipe wiꞌja toj tkyaqil, exla qa ma kyim twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ikytziꞌn, alkye taj noq tuꞌn tkubꞌ tbꞌinchin tajbꞌil tzaluꞌn twutz txꞌotxꞌ, kxeꞌl toj najin te jun majx. Ex alkye kꞌwel tzyuꞌn tibꞌ tiꞌj tkyaqiljo at tajbꞌin kyexjal tzaluꞌn twutz txꞌotxꞌ, noq tuꞌn npaja ex tuꞌn tpajjo Tbꞌanil Tqanil kolbꞌil, ktenbꞌil tchwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Quꞌn tiꞌxsila tajbꞌin tuꞌn tkanbꞌit tkyaqiljo ajbꞌil tzaluꞌn twutz txꞌotxꞌ, exsin tuꞌn tnaj tanmin? ¿Ma akutzin tzꞌok tkyaqil tqꞌinimil te klol tanmin? ");
INSERT INTO mamC_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ma akutzin klet tchwinqil noq tuꞌn pwaq? ");
INSERT INTO mamC_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ikytziꞌn, aj qa at jun saj txꞌixwe wiꞌja ex tiꞌjjo nyola kywutzjo jniꞌ xjal aj il, ex ikyx wejiꞌy, ayiꞌn Tkꞌwal Ichin, ex ok kchin tzajil txꞌixwe weꞌ te, aj wula tukꞌa nkawbꞌila ex tukꞌa tkyaqil tqoptzꞌajiyil nMaꞌn junx kyukꞌa jniꞌ xjan angel. ");
INSERT INTO mamC_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ex xi tqꞌmaꞌnl Jesús kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy; at junjun iteꞌ tzaluꞌn wukꞌiy, mi kyli kyimin, tzmaxi aj kylonte nimku tipin Tkawbꞌil Dios tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tbꞌajlinxiꞌ qaq qꞌij, i xi tkleꞌn Jesús oxe t-xnaqꞌtzbꞌin tukꞌa, a Pegr, Santyaw exsin Juan, ex i kanin twiꞌ jun wutz. Kywutzx t-xnaqꞌtzbꞌin, txꞌixpitjo kaꞌyin. ");
INSERT INTO mamC_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ex t-xbꞌalin ox qoptzꞌajx wen, manyor sjaninx tzeꞌnku jun bꞌuꞌẍ, a aꞌkxtaq tbꞌaj txjet. ");
INSERT INTO mamC_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iwletzin Jesús kyuꞌn t-xnaqꞌtzbꞌin nchi yolintaq kyukꞌa Elías ex Moisés. ");
INSERT INTO mamC_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Bꞌeꞌx i xobꞌxjo t-xnaqꞌtzbꞌin, teꞌ kylonte ikyjo. Ante Pegr ntiꞌl tumil jyet tuꞌn; oꞌkx xi tqꞌmaꞌn te Jesús: ¡Xnaqꞌtzil! Tbꞌanilx teꞌ otoꞌ tzaluꞌn. Kꞌaꞌ kubꞌ qbꞌinchiꞌn oxe tal pach; jun te, ex jun te Moisés, ex jun te Elías. ");
INSERT INTO mamC_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Texjo paq, tej tkubꞌ juktzꞌaj jun muj kyibꞌaj. Ex tojjo muj etz yolin jun tqꞌajqꞌojil, ex tqꞌma: Axixpen wejiꞌy Nkꞌwal lo kꞌuꞌjlinxix wuꞌn. ¡Kybꞌinkujiꞌy Tyol! ");
INSERT INTO mamC_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Atzaj teꞌ t-xi kykaꞌyin t-xnaqꞌtzbꞌin kyiꞌjile, mix aꞌl kyli, oꞌkxl Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Teꞌ kymeltzꞌaj twiꞌ wutz, xi toqxeninxix Jesús kyeꞌ kyjaluꞌn: Mix alqe kxele kyqꞌmaꞌnjiꞌy a ma kyliy, tzmaxi aj njatz anqꞌin, a ayiꞌn Tkꞌwal Ichin, kyxol kyimnin, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ex mix al qe txi kyqꞌmaꞌne; noq kyij ten kyxolx, me nchi yolintaq tzeꞌn tzꞌelpineꞌ yol, a tuꞌn tjaw anqꞌin juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Xi kyqanin te Jesús: ¿Tzeꞌntzin ttentz nkyqꞌmaꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil, qa ataq Elías tuꞌn tul nej twutza? ¿Nyapela tiꞌjjo lo nchi yolinetaq, a ma qliꞌy? ");
INSERT INTO mamC_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I xi ttzaqꞌwin Jesús: Twutzx teꞌ. Ate Elías tuꞌntaq tul nej, tuꞌntzintla noq bꞌinchil kytenxjal, aj wula. Me ntqꞌmaꞌntl Tuꞌjil Tyol Dios qa nimx tuꞌn tikyꞌx tuꞌn Tkꞌwal Ichin, ex qa tuꞌn tel ikyꞌin kyuꞌn xjal. ");
INSERT INTO mamC_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ex kxel nqꞌmaꞌn kyeꞌy, o tzul te Elías, quꞌn ate Juan, a Jawsil Aꞌ, ul te t-xel. Ex kubꞌ kybꞌinchinxjal tiꞌj tzeꞌnkuxtaq kyaj, ikyxjo tzeꞌnku ntqꞌmaꞌn Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kykꞌulinxi twiꞌ wutz kyukꞌa oxe t-xnaqꞌtzbꞌin kykꞌatzjo txqantl, ayeꞌ nchi yolintaql kyukꞌa xnaqꞌtzil tiꞌj ojtxe kawbꞌil, ex attaql txqan xjal kyiꞌjile. ");
INSERT INTO mamC_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Teꞌ tiwle kyuꞌnxjal, chꞌixtaq tkanin kykꞌatz, i jaw kaꞌylaj, ex bꞌeꞌx i el rinin qꞌolbꞌilte Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Xitzin tqanin Jesús kyexjal: ¿Tiꞌtzin nkyyoliꞌn kyukꞌa nxnaqꞌtzbꞌiꞌn? ");
INSERT INTO mamC_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tzajtzin ttzaqꞌwin jun ichin kyxoljo txqan xjal: Xnaqꞌtzil, ma tzaj wiꞌn nkꞌwala twutza, tuꞌn tkubꞌ tqꞌaniꞌn, quꞌn mina nbꞌant tyolin, tuꞌn tzyuꞌn tuꞌn jun taqꞌnil tajaw il. ");
INSERT INTO mamC_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Noq ja taꞌ, aj ttzaj tiꞌj, ex bꞌeꞌx nkubꞌ tzꞌaq tuꞌn, ex nbꞌaj n-etz plut toj ttzi, tzunx nchi juꞌchꞌin tste, ex bꞌeꞌx n-el ttxꞌiꞌlin tibꞌ. Ma txi ntqꞌmaꞌn kye t-xnaqꞌtzbꞌiꞌn, tuꞌn tex kylajoꞌn taqꞌnil tajaw il toj tanmin, me mina n-ex kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Xi tqꞌmaꞌn Jesús kye t-xnaqꞌtzbꞌin: Ntiꞌxsin kynimbꞌila tiꞌj Dios. ¿Jteꞌxsin qꞌij nkubꞌlin ten kyxola, ex naꞌmxsin tok qeꞌ kykꞌuꞌja wiꞌja? ¿Jteꞌxsila qꞌij kkyꞌelixjo ikyjo wuꞌn? Qꞌintzinjiy qꞌa, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xitzin kyiꞌntz. Atzin teꞌ tiwle Jesús tuꞌn taqꞌnil tajaw il, tzaj kyimin tiꞌjjo qꞌa ex jaw luꞌlin. Kubꞌ tzꞌaq, ex jaw ttolin tibꞌ twutz txꞌotxꞌ, ex bꞌajetz plut toj ttzi. ");
INSERT INTO mamC_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Xitzin tqanin Jesús teꞌ ttata: ¿Jteꞌxitzin qꞌij ttzyetlin tuꞌn ikyjo? chiꞌ. Xi ttzaqꞌwiꞌn ttata: Atxixjo te muchꞌxtaq. ");
INSERT INTO mamC_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ilaꞌ maj o txiꞌxi tzꞌaq toj qꞌaqꞌ ex toj aꞌ tuꞌn tkyim. Qa aku bꞌant jun tiꞌ tuꞌn tiꞌj, qꞌaqꞌintzin tkꞌuꞌja qiꞌja; qꞌaninkutzin chꞌin. ");
INSERT INTO mamC_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Xi tqꞌmaꞌn Jesús te: Atzin ntzaj tqꞌmaꞌn weꞌy, qa aku bꞌant jun tiꞌ wuꞌn tiꞌj tkꞌwala. Kaꞌn. Bꞌinkutziꞌn. Qa at jun xjal at tnimbꞌil wiꞌja, tkyaqilx aku bꞌant wuꞌn tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Atzin ttata qꞌa jaw ẍchꞌin, ex xi tqꞌmaꞌn: Qꞌuqle weꞌ nkꞌuꞌj tiꞌja. Me chin tmojintza tuꞌn tok qexix wen. ");
INSERT INTO mamC_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Teꞌ tok tkaꞌyin Jesús nimx xjal nbꞌaj rinin tuꞌn kykanin tkꞌatz, xi tqꞌmaꞌn te taqꞌnil tajaw il: Noq tuꞌn tpaja, mina nbꞌant tbꞌiꞌn ex tyolin qꞌa. Kxel nqꞌmaꞌn teꞌy, tuꞌn tetza toj tanmin, ex tuꞌn mina tzꞌokx majla. ");
INSERT INTO mamC_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Atzin taqꞌnil tajaw il jaw ẍchꞌin wen, ex tbꞌinche tuꞌn ttzaj junl majl kyimin tiꞌjjo qꞌa, ex bꞌeꞌx etzkux toj tanmin, ex kyij tqꞌoꞌn tzeꞌnku jun kyimnin. Nimxl xjal qꞌmante qa otaq tzꞌel kyim te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Me ante Jesús jaw t-xkoꞌn ex kubꞌ twaꞌbꞌin. ");
INSERT INTO mamC_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tetziꞌn tokx Jesús kyukꞌa t-xnaqꞌtzbꞌin toj jun ja kyjunalx, xi kyqanin t-xnaqꞌtzbꞌin te: ¿Tzeꞌntzin tten mi xbꞌant qe qlajon teꞌ taqꞌnil tajaw il toj tanminjo qꞌa? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","I xi ttzaqꞌwin Jesús: Atzin taqꞌnil tajaw il ikyjo, nbꞌant tlajet noq tukꞌa naꞌj Dios. ");
INSERT INTO mamC_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kyikyꞌlinxi antza, i ikyꞌku toj Galiley. Tkyꞌeꞌtaq Jesús tuꞌn tel tqanil, ");
INSERT INTO mamC_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","quꞌn nchex t-xnaqꞌtzintaqjo t-xnaqꞌtzbꞌin. Ex nxitaq tqꞌmaꞌn kye: Ayintziꞌn Tkꞌwal Ichin, skꞌoꞌnqiꞌn tuꞌn Dios, kchin xel qꞌoꞌn kyeꞌ xjal, tuꞌn nkubꞌ kybꞌyoꞌn, chiꞌ. Aj nkyima, me toj toxin qꞌij, kchin jawitz anqꞌin juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Minataq n-el kynikyꞌ te tiꞌtaq tzꞌelpine yol ikyjo, quꞌn nchi xobꞌtaq tuꞌn t-xi kyqanin. ");
INSERT INTO mamC_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kykaninxitzin toj Capernaum; i okx toj jun ja, ex xi tqanin Jesús kye: ¿Titziꞌn nkyyolintaqa toj bꞌe? ");
INSERT INTO mamC_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Me noq i bꞌaj kubꞌ mutxe tuꞌn kytxꞌixew, quꞌn otaq bꞌaj kubꞌ kyyolintaq alkye nimxtaq toklin kyxol. ");
INSERT INTO mamC_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kubꞌ qe Jesús, ex i xi ttxkoꞌn t-xnaqꞌtzbꞌin tkꞌatz, exsin xi tqꞌmaꞌn kye: Alkye taj tuꞌn tok te tnejil kyxol xjal, ilx tiꞌj tuꞌn tok te tchꞌibꞌil, ex tuꞌn tajbꞌin kye txqantl. ");
INSERT INTO mamC_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tzaj ttxkoꞌn Jesús jun tal kꞌwal, ex kubꞌ twaꞌbꞌin kyxolx, ex jaw tchleꞌn. Xi tqꞌmaꞌn kye: ");
INSERT INTO mamC_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Alkye kxel kꞌmonte jun tal kꞌwal tzeꞌnku lo, noq tuꞌn tnimbꞌil tiꞌj nbꞌiꞌy, nya noq oꞌkxjo kꞌwal kxel tkꞌmoꞌn, qalaꞌ majqinxa; ex atziꞌn xjal kxel kꞌmon weꞌy, nya noq oꞌkqinxa kchin xel tkꞌmoꞌn, qalaꞌ majxjo Dios, a tzaj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Xi tqꞌmaꞌn Juan te Jesús: Xnaqꞌtzil, o qli qeꞌ jun xjal, a nchi etzjo jniꞌ taqꞌnil tajaw il toj kyanminxjal tuꞌn, noq toj tumil tbꞌiy, me nya jun qukꞌa. Tuꞌnpetzintzjo, kyij qqꞌmaꞌn teꞌ, tuꞌn mina kubꞌ tbꞌinchintaqljo ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Me ante Jesús xi tqꞌmaꞌn kye: ¡Mina txi kyqꞌmaꞌn kye ikyjo! Quꞌn alkyeꞌ nkubꞌ tbꞌinchin jun tiꞌ wen nimx toklin tiꞌj nbꞌiꞌy, nya ajqꞌoj wiꞌja, ex nlay jaw yolbꞌin wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Quꞌn atziꞌn luꞌn nya qiꞌjbꞌinxi taꞌ, qukꞌa taꞌ teꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aꞌlchaqx kye jun xjaltz tzaj qꞌoꞌnte chꞌin tiꞌ kyeꞌy, iꞌchaqx noq jun tal pulbꞌil aꞌ, quꞌn tuꞌn weqiꞌy, twutzxix kxel nqꞌmaꞌn, ok ktzajil chjon teꞌ tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Alkye jun xjal tjoy ttxolil tzeꞌn tten, tuꞌn tkubꞌ tzꞌaq jun muchꞌ kꞌwal tiꞌj tnimbꞌil wiꞌja, wenpetla te te, tuꞌn tok tkꞌloꞌn jun abꞌj te chebꞌl triy tiꞌj tqul, exsintla xi t-xoꞌn tibꞌ toj aꞌ, tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Qa noq tuꞌn tpaj jun tqꞌobꞌa mo jun tqan, aku kubꞌ tzꞌaqiy toj il, bꞌantla tuꞌn tel ttxꞌemin, exsin tuꞌn tokxa toj kyaꞌj tukꞌa junchꞌin tqꞌobꞌa, tzeꞌnkuljo tuꞌn t-xiꞌy toj qꞌaqꞌ tukꞌa kykabꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Toj qꞌaqꞌ, aye ẍchuqꞌ mina nchi kyim, ex mina nyupjjo qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ikyxjo qa tuꞌn tpaj tqan, aku kubꞌ tzꞌaqiy toj il, bꞌantla tuꞌn tel ttxꞌemin, exsin tuꞌn tokxa toj kyaꞌj noq tukꞌa junchꞌin tqan, tzeꞌnkuljo tuꞌn t-xiꞌy toj qꞌaqꞌ tukꞌa kykabꞌilx, ");
INSERT INTO mamC_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","quꞌn toj qꞌaqꞌ, aye ẍchuqꞌ mina nchi kyim ex mina nyupjjo qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ikyxjo qa noq tuꞌn tpaj twutza, aku kubꞌ tzꞌaqiy toj il, wenitla tuꞌn tetz tiꞌn, exsin tuꞌn tokxa toj kyaꞌj jaꞌ nkawine Dios, tukꞌa junchꞌin twutza, tzeꞌnkuljo tuꞌn t-xiꞌy toj qꞌaqꞌ tukꞌa kykabꞌilx, ");
INSERT INTO mamC_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","quꞌn toj qꞌaqꞌ, aye ẍchuqꞌ mina nchi kyim, ex mina nyupjjo qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","N-ajbꞌin te atzꞌin tiꞌj chibꞌj, tuꞌn mi junxiyixe. Ikyqexsin qeꞌ, kkyꞌelix tiꞌchaqku tiꞌ quꞌn, tuꞌn mina qox toj il. ");
INSERT INTO mamC_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nimx n-ajbꞌine atzꞌin te aqꞌbꞌil ttxutxjil qchiꞌ. Me tzꞌelit naj tpitzꞌmejil, ntiꞌ aku tzꞌajbꞌine qe. Tzꞌelit tnaj tpitzꞌmejil, ikyxjo tzeꞌnku jun xjal tzꞌel naj twenil kywutzx xjal ex twutz Dios. Tuꞌnpetzintzjo, tentzin kywenila kykyaqilxa, tuꞌntzin tten tzaljbꞌil kyxola. ");
INSERT INTO mamC_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Etz Jesús kyukꞌa t-xnaqꞌtzbꞌin tojjo tnam Capernaum, exsin i xiꞌ tojjo txꞌotxꞌ te Judey, ex i xiꞌ tojjo txꞌotxꞌ tjlajxi Nim Aꞌ Jordán. Pon chmet txqan xjal tiꞌjile antza, ex ok ten xnaqꞌtzilkye tzeꞌnkuxtaqjo ntenetaq tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kyxoltziꞌn xjal, i kanin junjun Parisey, tuꞌn t-xi kyqanin jun tumil, tzeꞌn tten tuꞌn tkubꞌ tzꞌaq toj til tiꞌjjo t-xnaqꞌtzbꞌil. Chi chiꞌ kyjaluꞌn: ¿Wenpetzila, tuꞌn tkubꞌ tpaꞌn jun ichin tibꞌ tukꞌa t-xuꞌjil? ");
INSERT INTO mamC_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","I xi ttzaqꞌwin: ¿Tiꞌtzin kyij ttzꞌibꞌin Moisés kyeꞌy toj Ojtxe Kawbꞌil? ");
INSERT INTO mamC_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Xi kytzaqꞌwin: Ttziye te Moisés, tuꞌn tkubꞌ bꞌinchit jun uꞌj te kypaꞌbꞌlxjal kyibꞌ. Ikytzin n-aje kychqꞌoꞌne ichin kyxuꞌjil tja kytata. ");
INSERT INTO mamC_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Xi tqꞌmaꞌn Jesús: Tzaj tqꞌoꞌn Moisésjo kawbꞌil ikyjo, quꞌn tuꞌn tkujil kyanmiꞌn, tuꞌn kykyꞌeꞌy kubꞌ kyniminjiꞌy tkawbꞌil Dios kyij tqꞌoꞌn te tnejil. ");
INSERT INTO mamC_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Quꞌn tnejilxix, kubꞌ tbꞌinchin Dios jun ichin ex jun qya. ");
INSERT INTO mamC_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tuꞌnpetziꞌn, kyjel ttzaqpiꞌn te ichin ttata ex tnana, noq tuꞌn tok meje tukꞌa t-xuꞌjil. ");
INSERT INTO mamC_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ex kykabꞌilx kchi okil te junchꞌin. ");
INSERT INTO mamC_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tuꞌnpetziꞌn, nlay tzꞌel tpaꞌn te xjaljo, a s-ok tmujbꞌin Dios. ");
INSERT INTO mamC_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Telninxitzin bꞌajjo t-xnaqꞌtzbꞌil, i xiꞌ toj jun ja. Atzaj teꞌ kykanin, xi kyqanin t-xnaqꞌtzbꞌin juntl majl te tiꞌjxjo t-xnaqꞌtzbꞌil kyiꞌj paꞌl kyibꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Xi tqꞌmaꞌn Jesús kye: Qa at jun ichin xkubꞌ tpaꞌn tibꞌ tukꞌa t-xuꞌjil, exsin qa ma jaw meje tukꞌa juntl qya, aj kyꞌaꞌjiljo ichin ikyjo twutz tnejil t-xuꞌjil. ");
INSERT INTO mamC_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ex ikyxjo jun qya, qa ma kubꞌ tpaꞌn tibꞌ tukꞌa tchmil, ex qa ma jaw meje tukꞌa juntl ichin, aj kyꞌaꞌjiljo qya ikyjo twutz tnejil tchmil. ");
INSERT INTO mamC_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","I bꞌaj tzaj kyiꞌnxjal junjun tal kꞌwal tkꞌatz Jesús, tuꞌn tkubꞌ tqꞌoꞌn tqꞌobꞌ kyibꞌaj, tuꞌn kykubꞌ tkyꞌiwlin. Me ayetziꞌn t-xnaqꞌtzbꞌin bꞌeꞌx i ok ten yisol kyeꞌ nchi bꞌaj kanintaq. ");
INSERT INTO mamC_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tej kyok tkaꞌyin Jesús ikyjo, bꞌeꞌx tzaj tqꞌoj kyiꞌj t-xnaqꞌtzbꞌin, ex xi tqꞌmaꞌn kye: Kytzaqpinqetzjiꞌy tal kꞌwal, tuꞌn kybꞌaj tzaj laqꞌe nkꞌatza. Mi chi kubꞌ kymeqoꞌn, quꞌn kykyaqiljo kꞌwel kymutxsin kyibꞌ tzeꞌnqeꞌ tal kꞌwal lo, ayepen kye kchi okixjo toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Twutzxix kxel nqꞌmaꞌn kyeꞌy; qa ntiꞌ tqꞌuqbꞌil kykꞌuꞌja wiꞌja tzeꞌnku jun kꞌwal, nlay bꞌant tkawin Dios toj kychwinqila. ");
INSERT INTO mamC_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I jaw tchleꞌn kꞌwal, ex i kubꞌ tkyꞌiwlin tukꞌa tqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Teꞌ t-xiꞌ Jesús kyukꞌa t-xnaqꞌtzbꞌin, pon rinin jun ichin tkꞌatz, exsin kubꞌ meje twutz, ex xi tqanin te: Ay, xnaqꞌtzil wenxix, ¿Tiꞌn kꞌwel nbꞌinchiꞌn, tuꞌn nkanbꞌintejiꞌy chwinqil te jun majx? ");
INSERT INTO mamC_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Xi ttzaqꞌwin Jesús: ¿Tiquꞌn ntzaj tqꞌmaꞌn qa wenqiꞌn? Ntiꞌx jun te xjal wen tzaluꞌn twutz txꞌotxꞌ, qalaꞌ oꞌkx te Dios. ");
INSERT INTO mamC_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿On chi tbꞌijiy tkawbꞌil Dios? Mi bꞌiyiꞌn. Mi kyꞌaꞌjiꞌn. Mi tzꞌelqꞌiꞌn. Mi jaw bꞌant yol tiꞌj jun aꞌla noq tuꞌn kukxjo. Niminkujiy ttatiy ex tnaniy. ");
INSERT INTO mamC_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Xi tqꞌmaꞌn ichin te Jesús: Xnaqꞌtzil, kykyaqilxjo anetziꞌn, o bꞌaj bꞌant wuꞌn atxix toj nqꞌayila. ");
INSERT INTO mamC_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Xi tkaꞌyin Jesús tukꞌa tqꞌaqꞌbꞌil tkꞌuꞌj, ex xi ttzaqꞌwin: Noq junchꞌintl tuꞌn tbꞌant tuꞌn: Kux txiꞌy kꞌayil teꞌ tkyaqiljo jniꞌ at teꞌy, ex oyinxjiy jniꞌ tpwaqa kye yaj. Ikytzin ktenbꞌila tqꞌinimiljiy toj kyaꞌj. Exsin ku tzajtza lipeka wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tej tbꞌin teꞌ qꞌinin ikyjo, bꞌeꞌx jaw bꞌisin, quꞌn manyor qꞌininxtaq. ");
INSERT INTO mamC_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Teꞌ tajjo qꞌinin tja, jaw kaꞌylaj Jesús tiꞌjile, exsin xi tqꞌmaꞌntz kye t-xnaqꞌtzbꞌin: Kujx teꞌ luꞌn kye qꞌinin, tuꞌn kyokx toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ex ikyqexjo t-xnaqꞌtzbꞌin, bꞌeꞌx i jaw kaꞌylaj, teꞌ kybꞌin teꞌ ikyjo. Xi tqꞌmaꞌn Jesús kye: Nkꞌwal, kujx teꞌ tuꞌn tokx jun xjal toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kxel nqꞌmaꞌn juntl majl kyeꞌy: Jun paqxla aku tzꞌex jun chej toj toyajil jun bꞌaq te slepbꞌil bꞌuꞌẍ, tzeꞌnkul teꞌ tuꞌn tokx jun qꞌinin toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ayetzin t-xnaqꞌtzbꞌin, teꞌ kybꞌin teꞌ ikyjo, i jaw kaꞌylajxixtl, ex i jaw qanlaj kyxolilex: Qa nlay chi okx qꞌinin toj kyaꞌj, ¿Yajtzila qetz? ¿Altzila kye k-okixtz? ");
INSERT INTO mamC_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","I ok tkaꞌyin Jesús, ex i xi ttzaqꞌwin: Nlay bꞌant tuꞌn kyklet-xjal kyuꞌnx kyibꞌx. Me mete Dios kbꞌantil teꞌ tuꞌn tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ok ten Pegr qꞌmalte te Jesús: Ma kyij qtzaqpinqejiꞌy tkyaqiljo jniꞌ attaq qeꞌy, ex loqoꞌy lipcheqok tiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Xi ttzaqꞌwin Jesús: Twutzxix kxel nqꞌmaꞌn kyeꞌy, aꞌlchaqx kye kyij ttzaqpiꞌn jniꞌ tja, ttziky, titzꞌin, tnana, ttata, tkꞌwal, jniꞌ ttxꞌotxꞌ ex tkyaqil jniꞌ at te, noq tuꞌn npaja ex tuꞌn tpajjo nyola, ");
INSERT INTO mamC_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nimx t-xel ktzajil tqꞌoꞌn Dios te twutzxjo txꞌotxꞌ luꞌn, tzeꞌnku tja, ttziky, titzꞌin, tnana, tkꞌwal, jniꞌ ttxꞌotxꞌ, exla qa tukꞌa yajbꞌil tzaluꞌn twutz txꞌotxꞌ. Me tojtziꞌn juntl tchwinqil, ok tkanbꞌe tchwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Me nimx jaꞌlin iteꞌk te tnejil tzaluꞌn twutz txꞌotxꞌ, me chi kyjel te tchꞌibꞌil, qa ntiꞌ kynimbꞌil. Ex nimx ntiꞌ kyoklin tzaluꞌn twutz txꞌotxꞌ jaꞌlin, me kchi okil te tnejil noq tuꞌn kynimbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kyjaꞌtaq kyjax Jesús kyukꞌa t-xnaqꞌtzbꞌin tzma Jerusalén; nejnin Jesús kywutzjo t-xnaqꞌtzbꞌin, ex aye t-xnaqꞌtzbꞌin tzaj tchewil kyiꞌj, quꞌn bꞌeꞌx kynabꞌle tiꞌ tuꞌntaq tbꞌaj tiꞌj Jesús antza. Ex ayetzin xjal lipcheqextaq kyiꞌj, bꞌeꞌx i tzaj xobꞌ tuꞌn ikyjo. Ajtz meltzꞌaj Jesús, ex i tzaj ttxkoꞌn t-xnaqꞌtzbꞌin kyjunalx, ex ok ten qꞌmalte kye: ");
INSERT INTO mamC_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ikytziꞌn tzeꞌnku n-ok kykaꞌyiꞌn, chꞌix qjapin Jerusalén, a jaꞌ ayiꞌn, a Tkꞌwal Ichin, kchin xel kꞌayiꞌn kyeꞌ kynejil kypale Judiy exsin kyeꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Kyqꞌmaꞌbꞌil qa ayiꞌn at npaja, noq tuꞌn nkubꞌ bꞌyokuy kyuꞌn aj il. ");
INSERT INTO mamC_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kchin okil kyxmayiꞌn, kbꞌajil kytzubꞌin wiꞌja, kchin okil kylankꞌiꞌn, exsin kchin kꞌwel kybꞌyoꞌn. Me toj toxin qꞌij, kchin jawil anqꞌiꞌntla. Ikytzin bꞌaj tyolin Jesúsjo kywutz t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Atzin te Santyaw exsin Juan, kꞌwalbꞌajqe te Zebedey, i xi laqꞌe tkꞌatz Jesús, exsin xi kyqꞌmaꞌn te: Xnaqꞌtzil, qaja tuꞌn tbꞌinchiꞌn jun bꞌaꞌn qiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","I xi ttzaqꞌwin Jesús: ¿Tiꞌtzin kyaja tuꞌn tkubꞌ nbꞌinchiꞌn kyiꞌja? ");
INSERT INTO mamC_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Xi kyqꞌmaꞌn: Qꞌontza qokliꞌn, tuꞌn qkubꞌ qeꞌy toj Tkawbꞌila toj tman qꞌobꞌa ex juntl toj tẍnayaja kawil tukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","I xi ttzaqꞌwin Jesús: Mina n-el kynikyꞌa tiꞌjjo ntzaj kyqaniꞌn weꞌy. ¿Ma akutzin tzikyꞌx kyeꞌ kyuꞌn tkyaqiljo jniꞌ kkyꞌelix wuꞌn? ¿Ex ma akutzin kypa kyeꞌ tkyaqil yajbꞌil kkyꞌelix wuꞌn? ");
INSERT INTO mamC_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Xi kytzaqꞌwintz: Ok kkyꞌelix qe quꞌn. Xi ttzaqꞌwinl Jesús kye: Twutzx teꞌ, akula tzikyꞌx kye kyuꞌn tzeꞌnku weꞌ kkyꞌelix wuꞌn, ");
INSERT INTO mamC_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","me atziꞌn tuꞌn tkubꞌ qe jun kyeꞌ toj nman qꞌobꞌa ex juntl toj nẍnayaja kawil wukꞌiy, nyaqin weꞌ tiꞌj teꞌ; qalaꞌ a nMaꞌn, quꞌn oꞌkx teꞌ ojtzqilte ex bꞌilte alqe kxele tqꞌoꞌne. ");
INSERT INTO mamC_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Atzaj teꞌ tok kybꞌiꞌn lajajtl t-xnaqꞌtzbꞌin ikyjo, bꞌeꞌx tzaj kyqꞌoj kyiꞌj Santyaw ex Juan. ");
INSERT INTO mamC_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Me i xi ttxkoꞌn Jesús kykyaqilx, ex xi tqꞌmaꞌn kye: Ojtzqiꞌnl kyeꞌ kyuꞌn tzeꞌn kytenxjal nya nimil; quꞌn ayetziꞌn tnejil kawil, qa tiꞌx jun tiꞌ, manyor txꞌuꞌjqex tukꞌa kykawbꞌil, quꞌn nyakuj etzinqe kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Me atzin kyxola, nya iky teꞌ. Qalaꞌ ankye teꞌ taj tuꞌn tok te nim toklin kyxola, il tiꞌj tuꞌn tajbꞌin kye txqantl. ");
INSERT INTO mamC_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ex ankye taj tuꞌn tok te tnejil, il tiꞌj tuꞌn tok tzeꞌnku jun aqꞌnil te jun majx kye txqantl. ");
INSERT INTO mamC_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Quꞌn kaꞌntzinjiy weꞌ, a ayiꞌn Tkꞌwal Ichin; mi ẍin ul weꞌ tuꞌn kyajbꞌinxjal weꞌy; qalaꞌ ayin weꞌ tuꞌn wajbꞌiꞌn kye txqantl, ex tuꞌn t-xi nqꞌoꞌn nchwinqila te kyxel, tuꞌn kyklet te jun majx. ");
INSERT INTO mamC_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tej kyxiꞌ Jerusalén, iltaq tiꞌj tuꞌn kyikyꞌ tojjo jun tnam, Jericó. Teꞌ kyex ttxanxi tnam, lipcheqektaq txqan xjal kyiꞌj. Ex attaq jun moẍ qꞌuqle ttzi bꞌe, Bartimey tbꞌi, tkꞌwal Timey, nmoꞌntaq. ");
INSERT INTO mamC_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Teꞌ tbꞌiꞌnte qa ataq Jesús aj Nazaret, bꞌeꞌx ok ten ẍchꞌil: Jesús, tyajil David, qꞌaqꞌintz tkꞌuꞌja wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bꞌeꞌx ok kyyisoꞌnxjal, tuꞌn tkubꞌ qen, me noqx kyjaꞌ jawe ẍchꞌine: Tyajil David, qꞌaqꞌintz tkꞌuꞌja wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Teꞌ tbꞌinte Jesúsjo ikyjo, bꞌeꞌx kubꞌ weꞌ, ex tqꞌma: ¡Kyqꞌolbꞌintza! Ex bꞌeꞌxsin tzaj kyqꞌolbꞌintz moẍ, ex xi kyqꞌmaꞌn te: Qe tkꞌuꞌja. ¡Weꞌksa! Luꞌy nqꞌolbꞌajtz. ");
INSERT INTO mamC_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bꞌeꞌxsin kyij t-xoꞌnkuxjo t-xbꞌalin, jun paqx tjaw tꞌikypaj, ex xi tiꞌn tibꞌ, tuꞌn tkanin tkꞌatz Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Xi tqanin Jesús te: ¿Tiꞌ taja tuꞌn tkubꞌ nbꞌinchiꞌn tiꞌja? Xi ttzaqꞌwin: Xnaqꞌtzil, waja tuꞌn kykaꞌyin nwutza. ");
INSERT INTO mamC_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Xi tqꞌmaꞌn Jesús te: Kux tzꞌaja, noq tuꞌn tnimbꞌila wiꞌja ma chi kaꞌyin twutza. Texjo paq, kykaꞌyin twutz, ex bꞌeꞌx ok lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tkanin Jesús kyukꞌa t-xnaqꞌtzbꞌin kyojjo kabꞌe muchꞌ tnam Betfagé ex Betania, nqayin t-xe wutz Olivos. Teꞌ chꞌixtaq kykanin toj Jerusalén, i xi tchqꞌoꞌn kabꞌe t-xnaqꞌtzbꞌin, tuꞌn kyxiꞌ toj jun kybꞌe. ");
INSERT INTO mamC_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Xi tqꞌmaꞌn kye: Ku kyxiꞌy tojjo tal kojbꞌil jlajxi. Ajtzin kyokxa ttxaꞌn tnam, ok knetil jun tal bur kyuꞌn, kꞌloꞌn, me mix jun xjal o chejinxi tibꞌaj. ¡Kypjumila, exsin kyintza tzaluꞌn! ");
INSERT INTO mamC_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Qa at jun aꞌla saj qaninte kyeꞌy. ¿Tiquꞌnil n-el kypjuꞌn? qa chiꞌ. At k-okile te qAjaw, chichkujiꞌy, me jaꞌlinx tzꞌajtz qqꞌoꞌntla. ");
INSERT INTO mamC_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","I xiꞌ, ex atzaj kykanin, kꞌloꞌntaqjo tal bur ttzi bꞌe nqayin tkꞌatz jun ja, exsin tzaj kypjuꞌntz. ");
INSERT INTO mamC_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Me xi kyqanin jun chꞌuq xjal kye, a iteꞌtaq antza: ¿Titziꞌn nbꞌaj kyeꞌy? ¿Ti qe n-el kypjunjiꞌy tal bur? ");
INSERT INTO mamC_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Xi kyqꞌmaꞌntz tzeꞌnkuxjo otaq txi tqꞌmaꞌn Jesús kye. Bꞌeꞌxsin tzaj kytzaqpiꞌntz. Exsin tzaj kyiꞌntzjo tal bur. ");
INSERT INTO mamC_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Atzaj teꞌ tul tkꞌatz Jesús, bꞌaj jax kyqꞌoꞌn kytxoꞌw tibꞌaj, exsin jax qe Jesús tibꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bꞌaj kubꞌ kylikyꞌin jniꞌ xjal kytxoꞌw toj tbꞌe, ex ayetziꞌn txqantl bꞌaj tzaj kytoqin t-xaq tze, tuꞌn tkubꞌ kychtoꞌn toj tbꞌe. ");
INSERT INTO mamC_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","I bꞌaj kubꞌ nejjo txqan xjal twutz, ex txqantl bꞌaj ok lipe; kykyaqilxtaq nchi bꞌaj bꞌitzin wen, ex kyqꞌmaꞌntaq: Qo bꞌitzin tiꞌj tbꞌi a tzul tiꞌj tbꞌi tAjaw Tkyaqil, quꞌn kyꞌiwlinxix. ");
INSERT INTO mamC_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kyꞌiwlinxixa, a ma tzul kaniꞌn, ay tyajil David, tuꞌn tkawiꞌn qxola. Nimxitjo toklin tbꞌiy toj tnajbꞌila. ");
INSERT INTO mamC_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","I oꞌkx Jesús toj Jerusalén kyukꞌa t-xnaqꞌtzbꞌin, ex xiꞌ tojjo tnejil ja te naꞌbꞌl Dios. Bꞌaj tkaꞌyin tiꞌchaq tokxtaq toj. Bꞌeꞌxsin xiꞌtz juntl majl kyukꞌa t-xnaqꞌtzbꞌin tzma Betania, quꞌn otaq qoqix, teꞌ tok kykaꞌyin. ");
INSERT INTO mamC_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Toj junxil qꞌij, teꞌ kyjaꞌtaq kyikyꞌx tojjo Betania, otaq tzaj waꞌyaj tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tli jun tqan iw najchaq, ẍqiyin wen. Xiꞌ lolte kyukꞌa t-xnaqꞌtzbꞌin, qa attaq twutz. Me teꞌ kykanin, ntiꞌ twutz, noq t-xaq attaq, quꞌn nyataq tqꞌijjo tuꞌn twutzin. ");
INSERT INTO mamC_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tuꞌntzin ikyjo, qanbꞌin tiꞌj, ex xi tqꞌmaꞌn te tqan iw: Mixla jtojx tuꞌn tel twutza te kyloꞌxjal. Kybꞌi t-xnaqꞌtzbꞌin ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Atzaj teꞌ tkanin Jesús juntl majl kyukꞌa t-xnaqꞌtzbꞌin Jerusalén, okx tojjo tnejil ja te naꞌbꞌl Dios. Bꞌajetz tlajoꞌn jniꞌ xjal nchi bꞌaj kꞌayintaq, ex nchi bꞌaj loqꞌintaq toj. Bꞌaj jaw tpichꞌkin jniꞌ kymeẍjo nchi bꞌaj txꞌexbꞌintaq pwaq, jniꞌ kyqꞌuqiljo nchi bꞌaj kꞌayintaq palom, a aye nchi bꞌaj ajbꞌintaq te aqꞌbꞌil chjonte te Dios. ");
INSERT INTO mamC_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ex mix ttziye tuꞌn kyokx juntl majljo kꞌayil. ");
INSERT INTO mamC_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Exsin ok ten xnaqꞌtzil: Tzꞌibꞌinl teꞌ toj Tuꞌjil Tyol Dios: Atzin njaꞌy k-okil te ja te naꞌbꞌl Dios te tkyaqil xjal; me ayetzinl kyeꞌ, ma chi ok qꞌonte te kyja ileqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Teꞌ tok kybꞌiꞌn kynejil kypale aj Judiy ikyjo exqetziꞌn jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil, bꞌeꞌxsin i ok ten jyol ttxolil tzeꞌn tuꞌn tkubꞌe kybꞌyoꞌne, quꞌn otaqx tzꞌok kyxobꞌil te, quꞌn nimxxjal otaq tzꞌok lipe tiꞌjjo t-xnaqꞌtzbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Atzin teꞌ qok yupj, bꞌeꞌx meltzꞌaj Jesús kyukꞌa t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Toj junxil qlixje, ikyꞌ Jesús kyukꞌa t-xnaqꞌtzbꞌin tkꞌatzjo tqan iw, ex ok kykaꞌyin otaq jaw tzqij. ");
INSERT INTO mamC_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ante Pegr, teꞌ tok tkaꞌyin, tzaj tnaꞌn tiꞌjjo tqꞌma Jesús tiꞌjjo tqan iw, ex xi tqꞌmaꞌn: Aj Xnaqꞌtzil, ¡Kaꞌn! Ma tzqij tej tqan iw, aj kyij tqꞌoꞌn qanbꞌil tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Xi ttzaqꞌwin Jesús: Tenxix kynimbꞌila tiꞌj Dios, ex tiꞌjjo jniꞌ nbꞌaj bꞌant tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Twutzxix kxel nqꞌmaꞌn kyeꞌy, qa at jun xjal at-xix tnimbꞌil, ex nya njawje, qa ma txi tqꞌmaꞌn te wutz luꞌn, Ku tela tzaluꞌn, ex ku txiꞌy toj ttxuyil aꞌ, qa at-xix tqꞌuqbꞌil tkꞌuꞌj, ok kbꞌantil. ");
INSERT INTO mamC_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy, aj t-xi kyqanin jun tiꞌ toj naꞌj Dios, ten kynimbꞌila tuꞌn ttzaj tqꞌoꞌn, ex ok ktzajil kykꞌmoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ex aj kyok ten naꞌl Dios, kynajsinkuy til jun xjal, qa at xbꞌajte kyiꞌja, tuꞌntzin tkubꞌ tnajsin Diosjo kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Qatzin qa mina xkubꞌ kynajsiꞌn til jun xjal, ex nlay kubꞌ najsin kyeꞌ tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tbꞌajlinxiꞌ ikyjo, kykanin juntl majl Jerusalén, ex i ok ten bꞌetejil tpeꞌn tnejil ja te naꞌbꞌl Dios. I tzaj laqꞌe kynejil pale kyukꞌa xnaqꞌtzil tiꞌj ojtxe kawbꞌil, junx kyukꞌa jniꞌ nejinel kyxolxjal, ");
INSERT INTO mamC_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ex xi kyqanin te: ¿Tiꞌn tokiy tuꞌn tbꞌinchintejiy jniꞌ lo, a nkubꞌ tbꞌinchiꞌn? ¿Ex ankye saj qꞌoꞌnte tokliꞌn? ");
INSERT INTO mamC_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","I xi ttzaqꞌwin Jesús: Ex ikyx wejiꞌy, kxel nqaniꞌn jun nxjelbꞌitza kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Xitzin tqanintz: ¿Ankye tzaj chqꞌoꞌnte qtzan Juan tuꞌn kykuꞌxxjal tuꞌn toj aꞌ te jawsbꞌil aꞌ? ¿Apela Dios, mo noq ayexjal? ¡Kytzaqꞌwintziꞌn! ");
INSERT INTO mamC_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bꞌeꞌxsin bꞌaj ok tentz yolil kyxolile, ex kyqꞌma: Qa ma txi qqꞌmaꞌn a Dios, bꞌeꞌx ktzajil tqꞌmaꞌn qe, ¿Tin quꞌn mi xi kynimintza? chilaꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ex qa ma txi qqꞌmaꞌn qa xjal, at qxobꞌil. ¿Ma nyatzin kykyaqil xjaltz qꞌmante qa a Juan jun yolil Tyol Dios? ");
INSERT INTO mamC_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mix jyetil tumil kyuꞌn, tiꞌ tuꞌn t-xi kytzaqꞌwin. Oꞌkx xi kyqꞌmaꞌn te: Nya bꞌiꞌn qe quꞌn. I xi ttzaqꞌwin Jesús: Exsin ikyx wejiꞌy, nlay txi nqꞌmaꞌn weꞌ, alkye saj qꞌoꞌnte wokliꞌn tuꞌn tkubꞌ nbꞌinchiꞌn tkyaqiljo lo. ");
INSERT INTO mamC_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kubꞌ tqꞌoꞌn Jesús jun techil tiꞌj jun ichin tajaw txꞌotxꞌ: Jun ichin ok tawin tqan uv. Ok tchꞌlajin tiꞌjile, ex bꞌeꞌx jaw twaꞌbꞌin jun xkyaqꞌte toj te tzajbꞌilte. Exsin xi tqꞌoꞌntz te kymajin aqꞌnil, ex bꞌeꞌx xiꞌ najchaq. ");
INSERT INTO mamC_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Teꞌ tul kanin tqꞌij awal, tzaj tchqꞌoꞌn jun taqꞌnil qanil teꞌ twutz awal te manbꞌil ttxꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Me ayetzin manil, teꞌ tkanin taqꞌnil, bꞌaj kylankꞌin, ex kukxjo aj kychqꞌoꞌne. ");
INSERT INTO mamC_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Toj juntl majl tzaj tchqꞌoꞌn juntl taqꞌnil, ex ikyxjo, bꞌeꞌx kyꞌixbꞌe twiꞌ, noqx jniꞌ bꞌaj kyyisoꞌn, ex kukxljo, aj kychqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tzaj tchqꞌoꞌn juntl taqꞌnil; noqx teꞌ tkanin, bꞌeꞌx kubꞌ kybꞌyoꞌn. I tzaj tchqꞌoꞌnl txqantl. Me ikyx bꞌajjo kyiꞌj: At kyꞌixbꞌe, ex at bꞌeꞌx bꞌaj kubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Noq jun tkꞌwal kyij, tuꞌn ttzaj tchqꞌoꞌn, a kꞌuꞌjlinxixtaq tuꞌn. Quꞌn kubꞌ tbꞌisin: Nyapela kꞌwel kynimin nkꞌwala. ");
INSERT INTO mamC_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Atzin teꞌ t-xi kykaꞌyin manil txꞌotxꞌ teꞌ ttzajjo kꞌwalbꞌaj, bꞌeꞌx i bꞌaj ja yolin kyxolile: Ate luꞌn kyjel te tajaw txꞌotxꞌ. Tuꞌnpetzintzjo, qbꞌyoꞌnku, tuꞌntzin qkyij te tajaw. ");
INSERT INTO mamC_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bꞌeꞌxsin tzaj kytzyuꞌn, exsin kubꞌ kybꞌyoꞌn, ex i xtaꞌj xoꞌlte ttxanxi txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Tiꞌtzila kbꞌajil te tajaw txꞌotxꞌ kyiꞌjjo manil, toj kywutza, aj tul? ¿Nyapela bꞌeꞌx kchi kꞌwel tbꞌyoꞌn, ex kxel tqꞌoꞌn ttxꞌotxꞌ te kymajin txqantl? ");
INSERT INTO mamC_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Naꞌmtzin tel kynikyꞌa te ntqꞌmaꞌn Tyol Dios? A abꞌj, a xi kyxoꞌn bꞌinchil ja, a nyakuj ntiꞌtaq tajbꞌin, me axixpente abꞌjjo ma tzꞌokin te tqꞌuqil tẍkyin ja, a nimxix toklin. ");
INSERT INTO mamC_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Atzin tbꞌanilxjo ma tzaj tqꞌoꞌn tAjaw Tkyaqil qe, ex ma qo jaw kaꞌylajx tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tetziꞌn tkubꞌ tyolin Jesús ikyjo, bꞌeꞌxtaq xi qꞌiꞌn toj tze kyuꞌn kynejil Judiy, quꞌn bꞌeꞌx el kynikyꞌ te techil, qa kyiꞌjtaq nyoline. Me bꞌeꞌx kyij kytzaqpiꞌn, tuꞌn kyxobꞌil kye xjal. ");
INSERT INTO mamC_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ayetzin kynejil Judiy i xi kychqꞌoꞌn junjun Parisey ex junjuntljo aye lipcheqetaq tiꞌj Herodes, tuꞌn kyxiꞌ qanil jun kyxjelbꞌitz te Jesús, noq tuꞌn tkubꞌ tzꞌaq kyuꞌn tiꞌjjo t-xnaqꞌtzbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Teꞌ kykanin, xi kyqanin: Ay, xnaqꞌtzil, noq samiy, bꞌiꞌn qe quꞌn, qa nyolin te twutzxix, ex nxnaqꞌtziꞌn noq tiꞌjjo tbꞌeyil chwinqil tuꞌn qxiꞌ tukꞌa qMan Dios. Ex nya noq lipcheka tiꞌjjo nkyqꞌmaꞌnxjal, ex mi nchi kubꞌ tniminjiy aye nim kyoklin, quꞌn toj twutza, junx kyoklinxjal kykyaqil. Tuꞌnpetziꞌn, ¿Wenpela tuꞌn t-xi qchjonjiꞌy kꞌaybꞌil te kawil te Rom, mo minaj? Xi kyqanin ikyjo quꞌn kykyꞌeꞌtaq Parisey tuꞌn t-xi chjet kꞌaybꞌil, me ayetzin kyukꞌa Herodes, kyajtaq. Ikytzin iltaq tiꞌj tuꞌn tkubꞌ tzꞌaq Jesús kyuꞌn toj til kywutzjo jun chꞌuq xjal lo. Tuꞌnpetziꞌn, xi kyqꞌmaꞌn te: ¿Okpela kxel qchjoꞌntza, mo minaj? ");
INSERT INTO mamC_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Me tojtzqiꞌntaq te Jesúsjo kyxmiletzꞌil tiꞌjjo xi kyqanin, ex xi tqꞌmaꞌn kye: N-el we nikyꞌ te tiꞌjjo kyaja. Kyaja tuꞌn nkubꞌ tzꞌaqa tiꞌjjo nxnaqꞌtzbꞌila. Kyyekꞌintziꞌn jun pwaq weꞌy, tuꞌn tok nkaꞌyiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Xi kyyekꞌin te, ex xi tqanin Jesús kye: ¿An qwutzbꞌiyiljo lo, ex an qbꞌi tzꞌibꞌink twutz? Xi kytzaqꞌwinxjal: Te nmaq kawil te Rom, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","I xi ttzaqꞌwin Jesús: Tuꞌnpetziꞌn, kyqꞌoꞌnx kyejiꞌy a ntqanin nmaq kawil te Rom, ex kyqꞌoꞌnxjiꞌy a te Dios ntqanin. Tetziꞌn kyxi ttzaqꞌwin ikyjo, noqx i bꞌaj jaw kaꞌylaj. ");
INSERT INTO mamC_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Attaq jun chꞌuq Sadusey nbꞌaj xnaqꞌtzintaq, qa aj tkyim jun xjal, minataq njaw itzꞌje juntl majl. I tzaj tkꞌatz Jesús, ex xi kyqꞌmaꞌn te: ");
INSERT INTO mamC_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Xnaqꞌtzil, kyij ttzꞌibꞌin Moisés toj Tyol Dios, qa aj tkyim jun ichin, ex qa ntiꞌ jun tkꞌwal kyij tukꞌa t-xuꞌjil, il tiꞌj tuꞌn tjaw meje tukꞌaxjo ttziky mo titzꞌin qtzan tchmil, quꞌn tuꞌntzin aj tuljo tnejil tal, te tkꞌwaljo qtzan tchmil tuꞌn toke. ");
INSERT INTO mamC_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jun maj, attaq wuq ichin kyitzꞌimila kyibꞌ. Atzin kytziky knet t-xuꞌjil, me ntiꞌx jun tkꞌwal kyij, teꞌ tkyim. ");
INSERT INTO mamC_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Atzintzjo tkabꞌ jaw meje tukꞌa t-xuꞌjil kyij, me ikyxljo, ntiꞌ jun tkꞌwal kyij, teꞌ tkyim. Ex ikyxl bꞌajjo tiꞌjjo toxin, ");
INSERT INTO mamC_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ex ikyx bꞌajjo kyiꞌjjo txqantl. Ex bꞌeꞌx kyimljo qya. ");
INSERT INTO mamC_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Atziꞌn jaꞌlin, at jun qxjela teꞌy: ¿Tzeꞌntzila tteꞌn tuꞌn kyjaw anqꞌintl kyimnin? Quꞌn, qa ikyjo, aj kyjaw itzꞌje juntl majl, ¿Tiꞌtzila kbꞌajiltz? ¿Altzila kye k-okil te tchmiljo qya kyxoljo wuq ichin, quꞌn kykyaqilx i ok meje tukꞌa? ");
INSERT INTO mamC_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","I xi ttzaqꞌwin Jesús: Najninx iteꞌya kyeꞌ. ¿Naꞌmxsin tel kynikyꞌa te Tyol Dios, ex te jniꞌ tipin? ");
INSERT INTO mamC_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ajtzin kybꞌaj jaw itzꞌje juntl majljo kyimnin, mikyxil teꞌ chwinqil tzeꞌnku luꞌn. Ayetzin ichin exqetziꞌn qya mina chi bꞌaj jaw meje juntl majl. Iky kchi bꞌaj okileꞌ tzeꞌnqeku angel toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tiꞌjtzintzjo aj kyjatz itzꞌje juntl majl kyimnin, ¿Ma naꞌmtzin tkux kyuꞌjinjiꞌy Tyol Dios, a kyij ttzꞌibꞌin Moisés, tej tyolin Dios tukꞌa tojjo tqan txꞌiꞌx, a nkꞌanttaq? Chiꞌ kyjaluꞌn: Ayin wejiꞌy tDios Abraham, te Isaac ex te Jacob. Mix tqꞌma qa ayintaq wejiꞌy, qalaꞌ ayin wejiꞌych. ");
INSERT INTO mamC_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ikytziꞌn, ate Dios nya kyDios kyimnin, qalaꞌ kyDios itzꞌ, exla qa o chi kyim tzaluꞌn twutz txꞌotxꞌ, quꞌn toj twutz Dios, itzꞌqe kykyaqilx. Tuꞌnpetziꞌn, najninx iteꞌy. ");
INSERT INTO mamC_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Teꞌ tok tbꞌiꞌn jun xnaqꞌtzil tiꞌj ojtxe kawbꞌil ikyjo, tuꞌn toj tumil i xi ttzaqꞌwine Jesús, xi laqꞌe tkꞌatz ex xi tqanin: ¿Ankyeꞌ tkawbꞌil Dios nimxix toklin kyxoljo txqantl? ");
INSERT INTO mamC_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Xi ttzaqꞌwin Jesús: An tnejiljo luꞌn: Kybꞌinkuxixsiꞌn, tyajil Israel. Oꞌkx Diosjo junchꞌin, a tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tuꞌnpetzintzjo, kꞌuꞌjlinkxixa tukꞌa tkyaqil tanmiꞌn ex tukꞌa tkyaqil tnabꞌla ex tukꞌa tkyaqil tipiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Atzin tkabꞌtz: Kꞌuꞌjlink t-xjalila tzeꞌnkux ay. Ntiꞌx juntl tkawbꞌil nim toklin tzeꞌnqe luꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ante xnaqꞌtzil tiꞌj ojtxe kawbꞌil xi tqꞌmaꞌn: Xnaqꞌtzil, twutzxjo ikyjo tzeꞌn ntzaj tqꞌmaꞌn; junchꞌinx te Dios, tAjaw Tkyaqil; ntiꞌ juntl. ");
INSERT INTO mamC_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tuꞌn tok qkꞌuꞌjlin Dios tukꞌa tkyaqil qanmin, tkyaqil qnabꞌl, ex tkyaqil qipin, ex tuꞌn kyok qkꞌuꞌjlin qxjalil tzeꞌnkux awo; axixjo luꞌn nim toklin tzeꞌnqekuꞌ oyaj ex chojbꞌil nchi kubꞌ patit twiꞌ t-altar Dios. ");
INSERT INTO mamC_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Teꞌ tok tbꞌiꞌn Jesús, teꞌ otaq txi ttzaqꞌwin xnaqꞌtzil tiꞌj ojtxe kawbꞌil toj tumil, xi tqꞌmaꞌn te: Noq chꞌintl tuꞌn tel te tnikyꞌ teꞌ Tkawbꞌil Dios. Tbꞌajlinxiꞌ ikyjo, mix aꞌl juntl el t-xobꞌil, tuꞌn t-xi tqanin juntl t-xjelbꞌitz te Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Teꞌ nxnaqꞌtzintaq Jesús toj tnejil ja te naꞌbꞌl Dios, xi tqanin jun t-xjelbꞌitz kye xnaqꞌtzil tiꞌj ojtxe kawbꞌil: ¿Tzeꞌntzin tten kyqꞌmaꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil, qa tyajil David te Crist, a Kolil, a at toklin tuꞌn Dios? ");
INSERT INTO mamC_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ax David qꞌmante jun maj tuꞌn Xewbꞌaj Xjan: Xi tqꞌmaꞌn Dios te wAjawa: Qekuy toj nman qꞌobꞌa kawil wukꞌiy, ex kꞌwel kyiꞌjjo tajqꞌoja wuꞌnch. ");
INSERT INTO mamC_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Twutzx teꞌ qa a David t-xeꞌchil Crist. ¿Me tzeꞌntzin ttentz o yolin te David tiꞌj Crist, a naꞌmtaq titzꞌje, ex ok tqꞌoꞌn te tAjaw? Tbꞌanilx ele t-xnaqꞌtzbꞌin toj kywutzjo jniꞌ xjal. ");
INSERT INTO mamC_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nxnaqꞌtzintaq Jesús kye jniꞌ xjal, ex xi tqꞌmaꞌn: Kykaꞌyink kyibꞌa, tuꞌn mina chi ok lipeꞌy kyiꞌjjo xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Nbꞌaj kubꞌ kyyekꞌin kyibꞌ te tnejinel tnam, ex nbꞌaj ok kyqꞌoꞌn kyxbꞌalin tbꞌanilx, manyor xqerx wen, noq tuꞌn kyokku kaꞌyin kyuꞌnxjal. Ex kyajxix, tuꞌn kyok qꞌolbꞌit wen jaꞌchaq nchi bꞌete. ");
INSERT INTO mamC_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kyajxix tuꞌn kyokx qe te tnejil kyojjo ja te naꞌbꞌl Dios ex toj jun waꞌn toj jun nintz qꞌij. ");
INSERT INTO mamC_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Me nbꞌajel kyelqꞌin kyja qya mebꞌeqe, a o chi kyim kychmil, ex tkyaqiljo jniꞌ at kye, ex tuꞌn mina tzꞌel kynikyꞌtzajil, nchi ok tennaj naꞌl Dios nimx tqan. Tuꞌntzin ikyjo, okx kychjaꞌbꞌilx toj qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Qꞌuqletaq Jesús jun maj tkꞌatz jun tkubꞌil oyaj pwaq, tokxtaq toj tnejil ja te naꞌbꞌl Dios, nkaꞌyintaq kyiꞌjjo jniꞌ xjal tzeꞌn nbꞌaj kux kyqꞌoꞌntaq kyoyaj. Ex ayetzin qꞌinin, nimx pwaq bꞌaj kux kyqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ex kanin jun qya, a otaq kyim tchmil, yajxix wen. Kux tqꞌoꞌn kabꞌe tal netzꞌ pwaq. ");
INSERT INTO mamC_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","I tzaj ttxkoꞌn Jesúsjo t-xnaqꞌtzbꞌin, ex xi tqꞌmaꞌn kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy; ajo tal qya lo, nim chꞌintljo toyaj ma kux tqꞌoꞌn kywutzjo txqantl, ");
INSERT INTO mamC_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","quꞌn jotxjo xjal, a ma kux qꞌonte toyaj, a t-xkyijlbꞌin; qalatzinl teꞌ tal yaj, a ma kux tqꞌoꞌn, a attaq tajbꞌin te tuꞌn tanqꞌin. ");
INSERT INTO mamC_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tetz Jesús toj tnejil ja te naꞌbꞌl Dios, bꞌeꞌx xi tqꞌmaꞌn jun t-xnaqꞌtzbꞌin te: Xnaqꞌtzil, ayex kye junjun tij abꞌj ex junjun tij ja tbꞌanilqex wen. ");
INSERT INTO mamC_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Xi tqꞌmaꞌn Jesús te: Tbꞌanilqex kye junjun tij ja nchi ok tkaꞌyiꞌn, me twutzxix kxel nqꞌmaꞌn tey, qa tkyaqilx kchi kꞌwel yuchꞌj, ex ntiꞌx jun abꞌj kyjel tibꞌaj juntl, aj tpon tqꞌijil. ");
INSERT INTO mamC_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx xiꞌ Jesús kyukꞌa t-xnaqꞌtzbꞌin twiꞌ wutz Olivos, xinin twutzjo tnejil ja te naꞌbꞌl Dios. Teꞌ kykanin, kubꞌ qe Jesús, me ayetzin Pegr, Santyaw, Juan exsin Andrés, xi kyqanin kyjunalx: ");
INSERT INTO mamC_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","¿Jtojtzin bꞌaꞌn tbꞌajjo ikyjo, ex tiꞌchaqtzin txqantl kbꞌajil, aj chꞌixtaq tkꞌul kaniꞌn ikyjo? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","I xi ttzaqꞌwin Jesús: Kykaꞌyink kyibꞌa tuꞌn mix aꞌl kubꞌ sbꞌun kyeꞌy, ");
INSERT INTO mamC_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","quꞌn ilaꞌxte tzul, ex k-okil kyqꞌoꞌn kyibꞌ tzeꞌn ayiꞌn. Chichkuꞌ kyjaluꞌn: Ayin weꞌ Crist, ex nimx xjal kbꞌaj kꞌwel kyuꞌn, tuꞌn kybꞌaj ok lipe kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aj tok kybꞌiꞌn tqanil jniꞌ qꞌoj n-ok tzaluꞌn mo tzachiꞌn, mina chi jaw xobꞌa, quꞌn atziꞌn jniꞌ anetziꞌn ilx tiꞌj tuꞌn tbꞌaj. Me naꞌmtaqtzin tul kanin teꞌ qꞌij, a jaꞌ tuꞌn tbꞌaje twutz txꞌotxꞌ tkyaqilx. ");
INSERT INTO mamC_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ilx tiꞌj tuꞌn kykꞌul kaniꞌn qꞌij, jaꞌ tuꞌn toke qꞌoj tuꞌn junjun nim tnam tukꞌa junjuntl; ex tzul kyaqnajnabꞌ ex nintz waꞌyaj noq jaꞌchaqku tkyaqil twutz txꞌotxꞌ. Tkyaqiljo ikyjo, ikyjo tzeꞌnku tnejil tchyoꞌn tkꞌuꞌj jun qya tukꞌa tal. ");
INSERT INTO mamC_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Bꞌaꞌnx chi kaꞌyin kyibꞌa, quꞌn kchi bꞌaj xel qꞌoꞌn toj kyqꞌobꞌjo kawil ex kchi bꞌajil lankꞌiꞌn toj muꞌẍ ja te naꞌbꞌl Dios. Kchi bꞌaj pon qꞌiꞌn kywutz nmaq kawil ex kywutz muchꞌ kawil, noq tuꞌn npaja. Antza kꞌwele kychikyꞌbꞌiꞌn nqanila kywutz. ");
INSERT INTO mamC_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Me tuꞌn tbꞌajjo tkyaqil twutz txꞌotxꞌ, il tiꞌj nej tuꞌn tbꞌaj yolitjo nyola te kolbꞌil kyexjal toj kykyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Me mina chi jaw bꞌisin kyeꞌ, aj kyxi qꞌiꞌn kywutzjo nmaq kawil, ex tiꞌ tuꞌn txi kyqꞌmaꞌn kye, quꞌn nyaqe kyeꞌ kchi yolil, qalaꞌ ikytzin ate Xewbꞌaj Xjan k-yolil kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kyojjo qꞌij anetziꞌn, iteꞌ itzikybꞌaj kchi bꞌaj xel kykꞌayin kyitzꞌin kye kawil, tuꞌn kybꞌaj kubꞌ bꞌyoꞌn; ex iteꞌ manbꞌaj kchi bꞌaj kxel kykꞌayin kykꞌwal, ex ikyqexl kꞌwalbꞌajjo, kchi bꞌaj xel kykꞌayin kytata, tuꞌn kybꞌaj kubꞌ bꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kykyaqilxjo xjal nya nimilqe kchi bꞌaj okil ikyꞌin kyuꞌn noqx tuꞌn npaja, me ankye teꞌ mina tzꞌel tiꞌn tnimbꞌil wiꞌja, ajxi tjapin bꞌaj tqꞌijil, apente kkletiljo. ");
INSERT INTO mamC_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ajtzin t-xi kykaꞌyinjiꞌy ajo ichin, a kꞌwel tbꞌinchin a tixqex toj najbꞌil xjanxix (aj tkux kyuꞌjinjiꞌy luꞌn, tzꞌelku kynikyꞌa te). Ajtzin tok kykaꞌyin xjaljo tkyaqiljo lo, ayeꞌ iteꞌ toj txꞌotxꞌ te Judey, bꞌeꞌx kchi xel oq toj kꞌul. ");
INSERT INTO mamC_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ex atzin xjal, a tokxtaq twiꞌja, nlay taqꞌ ambꞌil tuꞌn tkuꞌtz qꞌilte jun tiꞌ te tuja. ");
INSERT INTO mamC_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ex ikyxljo, a tzmataq n-aqꞌnin toj ttxꞌotxꞌ, mi taqꞌ ambꞌil tuꞌn tul qꞌilkye t-xbꞌalin tja. ");
INSERT INTO mamC_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ayexjo tal qya, ayeꞌ chꞌixtaq kykubꞌ tzꞌaq, ex ayeꞌ tzmataq nbꞌaj miꞌẍin kyal! ");
INSERT INTO mamC_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chi naꞌn Diosa, noqit nya toj jbꞌalilku, mo tojku jun qꞌij te ajlabꞌl kubꞌ tzꞌaqe ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Quꞌn nimkux jun kyixkꞌoj kkyꞌelix kyuꞌn, a bꞌajxi kylaꞌy tukꞌaxjo tzajlin xkye twutz txꞌotxꞌ, ex mixla kqlaꞌbꞌil juntl majl, aj tjapin bꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Quꞌn noqit mi tzꞌajtz tajsin Dios kyiꞌjjo qꞌij anetziꞌn, mixitla aꞌlx jun aku kyij anqꞌin. Me ok ajitz tajsin Dios noq tuꞌn tqꞌaqꞌbꞌil tkꞌuꞌj kyiꞌjjo o chi jaw tskꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Qa at jun saj qꞌmaꞌnte kyeꞌy kyojjo qꞌij anetziꞌn: Lu Crist lo, mo qa luꞌ at tzachiꞌn, qa chiꞌ, mi txi kynimiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Quꞌn chi ul sbꞌul k-okil kyqꞌoꞌn kyibꞌ te Crist, mo te jun xjal tzeꞌnku jun yolil Tyol Dios ojtxe. Ex okpe kꞌwel kybꞌinchin nim techil kyipin, noq tuꞌn kysbꞌetkuxjal kyuꞌn. Ex okpela k-okil kynikyꞌin tuꞌn kykubꞌjo skꞌoꞌnqe tuꞌn Dios, me nlay chi kubꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kykaꞌyink kyibꞌa. Tuꞌnpetziꞌn, ma txi nqꞌmaꞌn kyeꞌy naꞌmtaq tuꞌn tul kanin ikyjo. ");
INSERT INTO mamC_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Noqx aj kybꞌaj ikyꞌjo qꞌij te yajbꞌil, k-okil qlolqex twutz qꞌij, ex mi kꞌantl yaye. ");
INSERT INTO mamC_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ex jniꞌ qeꞌ cheꞌw kchi kꞌwelitz tzꞌaq twutz txꞌotxꞌ. Ex tkyaqiljo jniꞌ at twutz kyaꞌj okx kchi luꞌlilx. ");
INSERT INTO mamC_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Exsin kchin xel kykaꞌyintza, aj ntzaja toj muj twutz kyaꞌj tukꞌa tkyaqil wipiꞌn ex jniꞌ nqoptzꞌajiyila, ayiꞌn a Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ajtzin nkꞌula twutz txꞌotxꞌ, kchi tzajil nsmaꞌn n-angela, tuꞌn kyok chmetjo jniꞌ skꞌoꞌnqe wuꞌn toj tkyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kykaꞌyinkjiꞌy techil tiꞌj tqan iw: Aj ttzaj xulin tal tqꞌobꞌ, ex aj tzaj poqꞌle t-xaq, antza k-elile kynikyꞌa te, qa chꞌix tul kanin qꞌijil. ");
INSERT INTO mamC_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ikyxsintzjo, aj tok kykaꞌyiꞌn tkyaqiljo luꞌn, tzꞌelku kynikyꞌa te, qa chꞌix tpon tqꞌijil tuꞌn wula juntl majl. ");
INSERT INTO mamC_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Twutzxix kxel nqꞌmaꞌn kyeꞌy, a naꞌmxtaq kybꞌaj kyimxjal, a iteꞌ tojjo tqꞌijil jaꞌlin, aj t-xi xkyejo jniꞌ luꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A kyaꞌj ex txꞌotxꞌ ok kchi bꞌajil, me mex weꞌ nyol nlayx chi kyij xkyeꞌ, tuꞌn mi chi japin bꞌaje. ");
INSERT INTO mamC_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Me alkye qꞌij ex alkye or chin ula, mix aꞌl teꞌ bꞌilte, mixpe aye angel toj kyaꞌj, mixpe ayinkuy, a Kꞌwalbꞌaj te Dios; qalaꞌ oꞌkx te nMan bꞌilte. ");
INSERT INTO mamC_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tuꞌnpetziꞌn kyimil kywatla toj kynimbꞌila, ex kykaꞌyink kyibꞌa, quꞌn nya bꞌiꞌn kyuꞌn jtoj bꞌaꞌn nmeltzꞌaja. ");
INSERT INTO mamC_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ikyx te luꞌn tzeꞌnku jun ichin kyjaꞌ t-xi toj jun tbꞌe toj junxil tnam najchaq. Kyjel kyqꞌmaꞌn kye taqꞌnil tuꞌn tok kykaꞌyin tja; ex kyjel tqꞌoꞌn taqꞌin junjun, kyjel tqꞌmaꞌn te xqꞌuqil tja, tuꞌn telsin twatl, ex tuꞌn tok tkaꞌyin tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ikyqexsin kyejiꞌy bꞌant-x kyteꞌn, ex bꞌaꞌnx chi kaꞌyin kyibꞌa, quꞌn nya bꞌiꞌn kyuꞌn jtoj bꞌaꞌn wula, qa noq aj qok yupj, mo nikyꞌjin aqꞌwilj, mo aj toqꞌ ekyꞌ, mo nqo el sqixkuj. Tuꞌnpetzintzjo, ilx tiꞌj tuꞌn tkubꞌ kybꞌinchin kyteꞌn, quꞌn ntiꞌ nqanila aj wula. ");
INSERT INTO mamC_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","¿Yajtzin qa nchin ulkuy, ex nya bꞌinchin kyteꞌn? ");
INSERT INTO mamC_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tuꞌnpetziꞌn, nxi nqꞌmaꞌn kyeꞌy, ex nya noq kyekuy ex majx kye jniꞌ xjal tkyaqil twutz txꞌotxꞌ: ¡Kybꞌinchim kyteꞌn! ");
INSERT INTO mamC_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Atxtaql kabꞌe qꞌij, tuꞌn tkubꞌ ikyꞌsit nintz qꞌij te Xjan Qꞌij, a jaꞌ nchi waꞌnxjal pan, a ntiꞌ txꞌamsbꞌilte. Ayetzin kynejil pale aj Judiy exqetziꞌn xnaqꞌtzil teꞌ jniꞌ kawbꞌil nkyjyoꞌntaq jun ttxolil toj ewajil, tuꞌn ttzyet Jesús, ex tuꞌn tkubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bꞌaj kubꞌ kyyolin kyxolilex: Mina kubꞌ qbꞌinchin toj nintz qꞌij te Waꞌj Pan, quꞌn tuꞌn mina bꞌaj jaw tiljexjal qiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Attaq Jesús tojjo kojbꞌil Betania, ex kanin tja jun xjal, Simun tbꞌi. Atzin Simun otaq tzꞌel weꞌ te jun yabꞌil tzeꞌnku txꞌaꞌk, lepra tbꞌi. Antza, tzaj laqꞌe jun qya qꞌiꞌntaq jun tal ẍunk tuꞌn, bꞌinchin tuꞌn jun wiq abꞌj tbꞌanilx wen, ex nojnin tukꞌa jun wiq jupsbꞌil manyor wiꞌyil wen, nardo tbꞌi. Teꞌ tkanin, ex jaw tjqoꞌn ẍunk, exsin jax tqoꞌn jupsbꞌil toj twiꞌ Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Atzaj teꞌ tok kykaꞌyin junjun xjal ikyjo, bꞌeꞌx bꞌaj tzaj kyqꞌoj tiꞌjjo qya, exsin ok ten yolbꞌil tiꞌj: ¿Tiꞌtzila qe ma kubꞌ tyajin qya qꞌanbꞌil anetziꞌn? ");
INSERT INTO mamC_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","¿Noqxitzin noq chꞌin twiꞌ? Qalaꞌ noqxpet ma txi tkꞌayin tuꞌn jweꞌlajaj kꞌal pwaq ex atzintlaꞌ pwaq xi oyit kye yaj. ");
INSERT INTO mamC_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Xi tqꞌmaꞌn Jesús kye: ¡Tenkuj! ¡Tin qe n-ok kyiliꞌn! Atzin ma tbꞌinchin wiꞌja, tbꞌanilx wen. ");
INSERT INTO mamC_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Quꞌn bꞌapeꞌ kye yaj kukx kyeꞌ kytenku kyxola, bꞌaꞌn kyxi kymojiꞌn alkye qꞌij kyaja, qalatzin weꞌ nya axsi chin kꞌwel teniy kyxola. ");
INSERT INTO mamC_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Atziꞌn ma kubꞌ tbꞌinchiꞌn qya wiꞌja, tbꞌanilx, quꞌn naꞌmxtaq nkyima te s-ok tqꞌoꞌn qꞌanbꞌil wiꞌja, a tzeꞌn n-ok kyiꞌj kyimnin tzeꞌn chi kux muqet. ");
INSERT INTO mamC_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Twutzxix kxel nqꞌmaꞌn kyeꞌy, jaꞌchaqx kubꞌeꞌ yolite nyola twutz txꞌotxꞌ, ex kꞌwel yolitjo a ma bꞌant tuꞌn qya wiꞌja, ex kꞌwel naꞌyit. ");
INSERT INTO mamC_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kyxoljo kabꞌlajaj t-xnaqꞌtzbꞌin Jesús, oꞌkx jun aj meltzꞌaj tiꞌj, a Judas Iscariot tbꞌi. Xiꞌ Judas lol kyeꞌ kynejil kypale aj Judiy, tuꞌntzin t-xi tqꞌoꞌn Jesús toj kyqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Teꞌ kybꞌinte kynejil pale ikyjo, ox chi tzalajx wen, exsin bꞌeꞌx xi kysuqin pwaq te Judas. Bꞌeꞌxsin okku tentz jyol ttxolil, tzeꞌn tten tuꞌn tel jyet Jesús tuꞌn, tuꞌntzin t-xi tqꞌoꞌn kye pale. ");
INSERT INTO mamC_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tojjo nintz qꞌij te Waꞌj Pan, ilxtaq tiꞌj nchi waꞌn aj Judiy pan, a nya txꞌamsin, ex nkubꞌ kybꞌyoꞌn jun tal tal rit. Tojtzin tnejil qꞌij, xi kyqanin t-xnaqꞌtzbꞌin Jesús te: ¿Jaꞌtzin tajiy tuꞌn qxiꞌy bꞌinchilte wabꞌj te ikyꞌsbꞌil Waꞌj Pan? ");
INSERT INTO mamC_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bꞌeꞌxsin i xi ttxkoꞌn kabꞌe t-xnaqꞌtzbꞌin, ex xi tqꞌmaꞌn kye: Ku kyxiꞌy toj tnam. Ex aj kylontiy jun ichin iqin jun ẍoqꞌ aꞌ tuꞌn, bꞌeꞌx kꞌaꞌ chi ok lipey tiꞌj, ex tojjo ja, jaꞌ k-okixe, ");
INSERT INTO mamC_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","axsa kꞌaꞌ chi okxiy, exsin kꞌaꞌ txi kyqaniꞌn te tajaw ja, ¿Ankye ja, jaꞌ kchin waliy kyukꞌa nxnaqꞌtzbꞌiꞌn? chitzin xnaqꞌtziljo. ");
INSERT INTO mamC_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ktzajil tyekꞌin jun ja kyeꞌy, chebꞌex bꞌinchin wen tibꞌajxi juntl. Kꞌaꞌ kubꞌ kybꞌinchinjiꞌy qwa antza. ");
INSERT INTO mamC_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bꞌeꞌxsin i xiꞌkuxjo t-xnaqꞌtzbꞌin. Teꞌ kykanin toj tnam, ikyx bꞌajjo tzeꞌnku bꞌaj tqꞌmaꞌn Jesús kye. Kyij kybꞌinchin wabꞌj, exsin i xiꞌ juntl majl jaꞌ iteꞌyetaq Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tetzinj qok yupj, xiꞌ Jesús kyukꞌa kabꞌlajaj t-xnaqꞌtzbꞌin jaꞌ otaq bꞌante wabꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tej kykanin, bꞌeꞌx i ok ten waꞌl. Me nchi bꞌaj waꞌntaq, teꞌ t-xi tqꞌmaꞌn Jesús kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy, at jun kyeꞌ, a luꞌ nwaꞌn wukꞌiy k-okil meltzꞌaj wiꞌja, ex kchin xel tkꞌayiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tej kybꞌin teꞌ ikyjo, bꞌeꞌx i jaw bꞌisin kykyaqilx, exsin junjunku ok ten qanilte te: ¿Me qa ayiꞌn? chi chiꞌ junjun. ");
INSERT INTO mamC_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","I xi ttzaqꞌwin: Jun kyeꞌ, a luꞌ nwaꞌn junx wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ayiꞌn Tkꞌwal Ichin, ok kbꞌajilx wiꞌja tzeꞌn ntqꞌmaꞌn Tyol Dios, tuꞌn nxi kꞌayiꞌn, me atziꞌn kxel kꞌayin weꞌ, wenxpetla noqit mina s-ul itzꞌje twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nchi bꞌaj waꞌntaq, teꞌ tjaw ttzyuꞌn Jesús jun pan, ex xi tqꞌoꞌn chjonte te Dios tiꞌj, exsin xi tsipin kye t-xnaqꞌtzbꞌin, me nej xi tqꞌmaꞌn: Kywanxjiꞌy pan luꞌn, quꞌn atziꞌn nxmililjiꞌy. ");
INSERT INTO mamC_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Teꞌ tbꞌajxi waꞌn, jaw tiꞌn jun tkꞌwel vin, xi tqꞌoꞌn chjonte te Dios tiꞌj, ex xi tsipin kye, tuꞌn t-xi kykꞌwaꞌn, ");
INSERT INTO mamC_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ex xi tqꞌmaꞌn kye: Atziꞌn vin kxel nqꞌoꞌn kyeꞌy tuꞌn t-xi kykꞌwaꞌn, atziꞌn nchkyꞌeljiꞌy, a akꞌaj tumil, a bꞌantnin tiꞌj tuꞌn Dios, tuꞌn kykyijxjal toj wen tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Twutzxix kxel nqꞌmaꞌn kyeꞌy, mi chin kꞌwantla tiꞌjjo kꞌwabꞌj luꞌn, tzmaxiꞌ aj qkꞌwan junx kyukꞌiy tzma toj Tkawbꞌil nMaꞌn toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","I bꞌaj bꞌitzin jun bꞌitz nej kyukꞌa t-xnaqꞌtzbꞌin, exsin i xiꞌ twiꞌ wutz Olivos. ");
INSERT INTO mamC_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Teꞌ kykanin antza, xi tqꞌmaꞌn Jesús kye: Kykyaqilxa k-elil kyiꞌn tqꞌuqbꞌil kykꞌuꞌja wiꞌja, quꞌn ikytzin ntqꞌmaꞌn Tyol Dios toj Tuꞌjil: Kꞌwel nbꞌyonjiꞌy kyikꞌlel, ex ayetzin rit kchi bꞌajelil tilj, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Me ajtzin njaw itzꞌjiꞌy juntl majl, nej chin pon kaniꞌn kywutza toj Galiley. ");
INSERT INTO mamC_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Me ante Pegr xi ttzaqꞌwin: Ex qa kykyaqilx s-el kyiꞌn tqꞌuqbꞌil kykꞌuꞌj tiꞌja, me mina weꞌ, chi Pegrjo. ");
INSERT INTO mamC_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Xi tqꞌmaꞌn Jesús te Pegr: Twutzxix kxel nqꞌmaꞌn teꞌy, tojxjo qnikyꞌin lo, a naꞌmtaqx toqꞌ tman ekyꞌ, otaq chin kubꞌ tewiꞌn oxe maj kywutzxjal, ex kxel tqꞌmaꞌn kye qa nya ojtzqiꞌnqiꞌn tuꞌnch. ");
INSERT INTO mamC_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Me mina, chi Pegr. Ex qa ma chin kyima tukꞌiy, me nlay kubꞌ wewiꞌn, chiꞌ. Ex ikyxljo, kyqꞌmaꞌn txqantl t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bꞌeꞌx xiꞌ Jesús kyukꞌa t-xnaqꞌtzbꞌin tojjo najbꞌil Getsemaní. Teꞌ kykanin antza, xi tqꞌmaꞌn kye: Ku kykyij qeꞌy tzaluꞌn. Ma chin weꞌ naꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Me i xi tkꞌleꞌn oxe tukꞌa; a Pegr, Santyaw exsin Juan. Tzajx txqan bꞌis toj tanmin, ");
INSERT INTO mamC_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ex xi tqꞌmaꞌn kye: Ma tzajx jun tij bꞌis toj wanmiꞌn, nya tzaj chin kyimila, chiꞌ. Ku kykyija tzaluꞌn, me noq tzaj kywatla. ");
INSERT INTO mamC_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","El laqꞌe chꞌintl kykꞌatz, kubꞌ mutxe twutz txꞌotxꞌ, ex xi tqanin te Dios noqit tzeꞌn tten mina tzikyꞌxi kyixkꞌoj tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chiꞌ kyjaluꞌn toj tnaꞌj Dios: Ay nMan, tkyaqilx te nbꞌant tuꞌn. Chin tklomila teꞌ tkyaqil jniꞌ kkyꞌelix wuꞌn. Me waja tuꞌn tkubꞌ tbꞌinchinjiy a taja wiꞌja, ex nya weꞌ waj. ");
INSERT INTO mamC_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bꞌeꞌx meltzꞌaj kykꞌatz oxe t-xnaqꞌtzbꞌin. Atzaj teꞌ tul kykꞌatz, xi tqꞌmaꞌn te Pegr: Simun, ¿Ma tzuntzin nktan? ¿Ma mixsin s-el jun orjo twatla? ");
INSERT INTO mamC_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kyimil kywatla, ex kux chi bꞌaj naꞌn Diosa, tuꞌn mina chi kubꞌ tzꞌaqa toj tqꞌobꞌ tajaw il, quꞌn kyaja tuꞌn tkubꞌ kybꞌinchinjiꞌy a taj Dios, me alkyetz kuj n-ele te kyeꞌy tuꞌn tbꞌant. ");
INSERT INTO mamC_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Xiꞌ juntl majl naꞌl Dios, ex ikyxl tnaꞌj Diosjo kubꞌ tqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Teꞌ tmeltzꞌaj juntl majl kykꞌatzjo t-xnaqꞌtzbꞌin, ex ikyxljo, nchi ktantaql teꞌ kyel knetl tuꞌn. Ex mix tene tumil kyyol te, quꞌn mix kypaꞌyix watl. ");
INSERT INTO mamC_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Xiꞌ juntl majl te tox majin, ex teꞌ tmeltzꞌaj juntl majl, ex ikyxljo, nchi bꞌaj ktantaql. Xi tqꞌmaꞌn kye: ¿Ma tzunxsin nchi ktaꞌn, ex nchi ajlaꞌn? ¡Kukxjo jaꞌlin! Ma pon or tuꞌn nxi qꞌoꞌn toj kyqꞌobꞌ aj il, ayiꞌn, a Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Kux chi jaw weꞌksa! ¡Qoqe! ¡Quꞌn luꞌ tzul a kxel kꞌayin weꞌy! ");
INSERT INTO mamC_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tzmataq nyolin Jesús, teꞌ tul Judas, a jun t-xnaqꞌtzbꞌin. Ex lipcheqektaq txqan xjal tiꞌj, qꞌimile jniꞌ kykxbꞌil, a at kyste te bꞌiꞌybꞌil, ex jniꞌ kytze te kybꞌujbꞌil. Aye xjal luꞌn otaq chi tzaj kychqꞌoꞌn kynejil pale, exqetziꞌn xnaqꞌtzil tiꞌjjo ojtxe kawbꞌil, ex kyuꞌn nejinel kyxol aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Otaq bꞌaj tqꞌmaꞌn Judas kye, tzeꞌn ttxolil tuꞌn tel tnikyꞌtzajil: Ankye k-okil nmaꞌtzin, atzintzjo. Bꞌeꞌx kꞌaꞌ tzꞌok kytzyuꞌn, tuꞌn t-xi kyiꞌn, ex tuꞌn tkux jpet toj tze. ");
INSERT INTO mamC_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Teꞌ tkanin Judas tkꞌatz Jesús, ex xi tqꞌmaꞌn te: ¡Xnaqꞌtzil! Ex el tmaꞌtzin. ");
INSERT INTO mamC_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Noqxsin iteꞌkl xjaltz tzyulte, tuꞌn tkux kyqꞌoꞌn toj tze. ");
INSERT INTO mamC_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Me attaq jun xjal, teꞌ tok tkaꞌyin txi qꞌiꞌn Jesús, bꞌeꞌx jatz tiꞌnku tkxbꞌil tuꞌn tel tjaspin tẍkyin jun taqꞌniljo tnejilxix kypale aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Xi tqꞌmaꞌn Jesús kye jniꞌ xjal: ¿Tiquꞌn ma chi ula tzaluꞌn kyukꞌa jniꞌ kykxbꞌila ex jniꞌ kytzeꞌy wiꞌja nyakuj ileqꞌqiꞌn toj kywutza? ");
INSERT INTO mamC_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","¿Tzeꞌn tten tzma jaꞌlin ẍin ok kytzyuꞌn, ex qa kukx nchin xnaqꞌtzinjiꞌy tojjo tnejil ja te naꞌbꞌl Dios kyxola? Me nya tiquꞌnil, quꞌn ikytzin tuꞌn tbꞌajxjo tzeꞌnku ntqꞌmaꞌn Tyol Dios wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Te tok kykaꞌyin t-xnaqꞌtzbꞌin teꞌ ttzyet, bꞌeꞌx i bꞌaj kubꞌ toj bꞌe, exsin kyij kytzaqpiꞌntz tjunalx. ");
INSERT INTO mamC_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Me at jun qꞌa ok lipe tiꞌj Jesús, noq jun iqbꞌil toktaq te ttxoꞌw. Ex ikyxjo, ex ajin tzyet kyuꞌnxjal, ");
INSERT INTO mamC_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","me bꞌeꞌx kyij ttzaqpiꞌn iqbꞌil, ex kubꞌ toj bꞌe ẍbꞌiꞌq. ");
INSERT INTO mamC_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pon qꞌiꞌn Jesús twutzjo kynejilxix pale. Ex bꞌaj pon chmetjo txqantl kynejil kypale aj Judiy, jniꞌ nmaq xjal exqetziꞌn jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Najchaq lipchexitaq Pegr tiꞌj Jesús. Atzaj teꞌ tkanin tpeꞌn tja tnejilxix pale, axsa kyja qeye xqꞌnel qꞌaqꞌ kyxoljo xqꞌuqil tnejil ja te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ayetziꞌn kynejil pale exqetziꞌn kawil, tzunx nkyjyoꞌntaq til Jesús tzeꞌn tten tuꞌn tbꞌaj, me mix ja njyetetaq tumil kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","At junjun noq tiꞌchaqku bꞌaj ja bꞌant tuꞌn tiꞌj, me ayeꞌ txqantl, mina nkytziyintaq. ");
INSERT INTO mamC_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","At junjun bꞌaj jaw kytxꞌixpin teꞌ tyol Jesús, ex kyqꞌma: ");
INSERT INTO mamC_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","O qbꞌintexi qeꞌ ntqꞌmaꞌn kyjaluꞌn: Kꞌwel nyuchꞌinjiꞌy tnejil ja te naꞌbꞌl Dios, a kybꞌinchbꞌin ichin, exsin toj oxe qꞌij kbꞌantile juntl wuꞌn, me nya kybꞌinchbꞌin ichin. ");
INSERT INTO mamC_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Me mix tuꞌn ikyjo, mix ja nchi kyijetaq toj wen tiꞌjjo kyyol. ");
INSERT INTO mamC_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Atzin kynejilxix pale jaw weꞌ kyxoljo jniꞌ xjal, ex xi tqanin te Jesús: ¿Ntiꞌxsin chꞌin tzaj ttzaqꞌwiꞌn? ¿Tiꞌxsin kyqꞌmaꞌnxjal tiꞌja? ");
INSERT INTO mamC_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Me mix xi ttzaqꞌwine Jesús; noq bꞌant mutxe. Xi tqaninxix juntl majljo kynejilxix pale te: ¿Atzinjiy Crist, a Klol kyeꞌ aj Judiy, a tkꞌwal Dios kyꞌiwlinxix tbꞌi? ");
INSERT INTO mamC_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Xi ttzaqꞌwin Jesús: ¡Ayiꞌn! Ex oktzin kchin kylaꞌbꞌila ayiꞌn Tkꞌwal Ichin, aj wok qeꞌy ttxlaj Dios, a nimxix tipin, toj tman qꞌobꞌ, ex ikyxjo aj ntzaja toj muj, aj nmeltzꞌaja juntl majl twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Teꞌ tqꞌmante ikyjo, noqx el kyimjo kynejilxix pale, ex bꞌeꞌx xi lipin laqil kye t-xbꞌalin tuꞌn tqꞌoj, ex tqꞌma: ¿Tiꞌ qe txqantl tstiyil qe? ");
INSERT INTO mamC_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ma kybꞌintejiꞌy xoꞌj yol tuꞌn tiꞌj Dios. ¿Tzeꞌn kyeꞌ toj kywutz? Kykyaqilx bꞌaj qꞌmante qa axtaq at tpaj, ex qa toj tiltaq tuꞌn tkubꞌ bꞌyet. ");
INSERT INTO mamC_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bꞌeꞌxsin i bꞌaj ok ten tzubꞌil tiꞌj, bꞌaj ok kymaqsiꞌn twutz, ex bꞌaj ok kytzꞌajchin, exsin xi kyqꞌmaꞌn te: Qa ajiy tkꞌwal Dios, kanintziꞌn tiꞌj alkye s-ok tzꞌajchin teꞌy, chi chiꞌ. Ex ikyqexjo xqꞌuqil tnejil ja te naꞌbꞌl Dios bꞌaj okx kytzꞌajchin toj twutz. ");
INSERT INTO mamC_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Attaq Pegr twiꞌ peꞌn, tjaqꞌ ja, teꞌ tpon laqꞌe jun txin tkꞌatz, taqꞌnilxjo tnejilxix pale. ");
INSERT INTO mamC_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nxqꞌnentaq Pegr tiꞌj qꞌaqꞌ, teꞌ tiwle tuꞌn. Ok kyimxix tiꞌj Pegr, exsin xi tqꞌmaꞌn te: ¡Ex ikyx tejiy ajintaq te nbꞌet tukꞌa Jesús aj Nazaret! chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Me bꞌeꞌx kubꞌ tewin, ex xi tqꞌma: Nya wojtzqiꞌn weꞌ Jesús, ex ntiꞌ bꞌiꞌn wuꞌn tiꞌ qiꞌjil nyoliniych. Ex bꞌeꞌx etz peꞌn, ex n-oqꞌku tman ekyꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ok kyim jun majljo txin tiꞌj Pegr, ex xi tqꞌmaꞌn kye txqantl xjal: ¡Ax juntl teꞌ lo! chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mina, chi Pegr, ex kubꞌ tewin juntl majl. Ikyxjo, teꞌ t-xi kyqꞌmaꞌn txqantl xjal juntl majl te: Ajin teꞌ tukꞌa Jesús, quꞌn aj Galiley te, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Xi tqꞌmaꞌn Pegr kye: ¡Twutzx Dios kxel nqꞌmaꞌn kyeꞌy! ¡Nya wojtzqiꞌn wejiꞌy ichin, a nchi yoliꞌn tiꞌj! ");
INSERT INTO mamC_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Teꞌ t-xi tqꞌmaꞌn Pegrjo ikyjo, njawku oqꞌ tman ekyꞌ te tkabꞌ majin. Bꞌeꞌx ok ten oqꞌil, quꞌn bꞌeꞌx ul julkꞌaj tyol Jesús toj tkꞌuꞌj, tej t-xi tqꞌmaꞌn: Naꞌmtaq toqꞌ ekyꞌ te tkabꞌ majin, aj nkubꞌ tewiꞌn oxe maj. ");
INSERT INTO mamC_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Atzaj teꞌ qsqix, bꞌaj ok kychmoꞌn kynejil pale kyibꞌ kykyaqilx kyukꞌa xnaqꞌtzil tiꞌj ojtxe kawbꞌil, kyukꞌa jniꞌ nmaq xjal ex kyukꞌa jniꞌ nmaq kawil. Xi kyjtzꞌoꞌn Jesús wen, ex xi qꞌiꞌn twutz Pilat. ");
INSERT INTO mamC_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Teꞌ tkanin, xi tqanin Pilat te: ¿Atzinjiy nmaq kawil kye Judiy? Axa ma qꞌmante, chi Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ayetzin kynejil pale nimx ja bꞌant kyuꞌn tiꞌj Jesús twutz Pilat. ");
INSERT INTO mamC_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xi tqanin juntl majl Pilat te: ¿Ntiꞌxsin chꞌin ntqꞌmaꞌn? ¡Bꞌinqexsin jniꞌxsin nkyqꞌmaꞌn tiꞌja! ");
INSERT INTO mamC_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Noq jaw kaꞌylaj Pilat, tuꞌn mix xi ttzaqꞌwine Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Me ante Pilat, a aj kawil, aj tikyꞌ junjun Xjan Qꞌij, kukx nxi ttzaqpiꞌntaq jun xjal, a tkuꞌxtaq toj tze. Me nejtaq nxi tqanin alkye kyajxjal tuꞌn t-xi tzaqpet. ");
INSERT INTO mamC_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Attaqtzin jun ichin, Barrabás tbꞌi, tkuꞌxtaq toj tze, kyukꞌa jteꞌl tukꞌa, kybꞌiybꞌin toj jun qꞌoj bꞌaj kyiꞌj kawil te Rom. ");
INSERT INTO mamC_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","I bꞌaj xitzin tiljo jniꞌ xjal qꞌmalte te Pilat, ex i ok ten qꞌmalte te, tuꞌn tjatz ttzaqpiꞌn jun xjal tzeꞌnkuxtaqjo ntene kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","I xi ttzaqꞌwin Pilat: ¿Kyajtziꞌn tuꞌn t-xi ntzaqpinjiꞌy Jesús, a nmaq kawil kye Judiy? ");
INSERT INTO mamC_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Quꞌn el tnikyꞌ te qa noqtaq tuꞌn tloꞌchj kykꞌuꞌjjo kynejil pale otaq txi kyine. ");
INSERT INTO mamC_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","I bꞌaj ok ten kynejil pale qꞌmalte kye jniꞌ xjal, tuꞌn t-xi kyqanin te Pilat, tuꞌn t-xi tzaqpet Barrabás. ");
INSERT INTO mamC_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Xitzin tqanin Pilat kye: ¿Titzin kyajtza tuꞌn tok nbꞌinchiꞌn tiꞌjjo ichin luꞌn, a tok tbꞌi kyuꞌn te nmaq kawil kye Judiy? ");
INSERT INTO mamC_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jotqex i bꞌaj jaw ẍchꞌin: ¡Pejkꞌinka twutz cruz tuꞌn tkyim! chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Xi tqanin juntl majl Pilat: ¿Tinquꞌn? ¿Tiꞌxsiꞌn nya wen ma tbꞌinche? chiꞌ. Xi kytzaqꞌwin juntl majl kujxix wen. ¡Pejkꞌinka twutz cruz tuꞌn tkyim! ");
INSERT INTO mamC_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tkyꞌeꞌtaq Pilat tuꞌn ttzaj kyqꞌoj xjal tukꞌa. Tuꞌnpetziꞌn, bꞌeꞌx xi ttzaqpiꞌn Barrabás, ex bꞌeꞌx xi tqꞌoꞌn Jesús kye xqꞌuqil te aj Rom, tuꞌn tok kypejkꞌin twutz cruz tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xi kyiꞌn xqꞌuqil te aj Rom twiꞌ tpeꞌn kawbꞌil, ex bꞌaj ok kychmoꞌn jniꞌ kybꞌaj. ");
INSERT INTO mamC_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ok kyqꞌoꞌn jun xbꞌalin tiꞌj, kyaq kaꞌyin, tzeꞌn t-xbꞌalin jun kawil, noq tuꞌn tok kyxmayinku. Bꞌaj kubꞌ kyxpatxꞌiꞌn tqan txꞌiꞌx, ex ok kymujbꞌin ttxaꞌn. Jax kyqꞌoꞌn toj twiꞌ nyakuj jun toj twiꞌ nmaq kawil, ");
INSERT INTO mamC_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","exsin i bꞌaj ok tentz ẍchꞌil tiꞌj: Nimxit tbꞌiꞌy, ay nmaq kawil kye aj Judiy, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","I bꞌaj ok ten jemil toj twiꞌ Jesús tukꞌa tze, bꞌaj ok kytzubꞌin tiꞌj, ex bꞌaj kubꞌ meje twutz, nyakutlaj nchi kꞌulenaj twutz. ");
INSERT INTO mamC_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kybꞌajlinxi xmayin tiꞌj, el kyiꞌn xbꞌalin, a ok kyqꞌoꞌn, exsin ok kyqꞌoꞌn a t-xbꞌalin toktaq, exsin etz kyiꞌn tpeꞌn ja te kawbꞌil, a jaꞌ tuꞌn tok kypejkꞌin twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Attaq jun ichin aj Cirene, Simun tbꞌi, ttata Lejantr ex Ruf, n-ikyꞌkutaq antza tzajnin toj tbꞌe. Teꞌ tok kykꞌulbꞌin, ok kyqꞌoꞌn il tiꞌj tuꞌn t-xi tiqin tcruz Jesús. ");
INSERT INTO mamC_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pon kyin toj jun najbꞌil Gólgota tbꞌi, atzin tzꞌelpine bꞌibꞌaj ikyjo: Ja taꞌ tbꞌaqil twiꞌ kyimnin. ");
INSERT INTO mamC_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Xi kyqꞌoꞌn vin smaꞌnx tukꞌa taꞌl mir te, tuꞌn mina tnaꞌyeku kyixkꞌoj. Me mix xi tkꞌwaꞌne. ");
INSERT INTO mamC_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bꞌeꞌxsin jaw kypejkꞌiꞌn xqꞌuqil te Rom twutz cruz, ex bꞌaj kubꞌ kypaꞌn t-xbꞌalin Jesús kywutz. Me nej, i bꞌaj saqchan tiꞌj alkyetaq tuꞌn tkanbꞌinte, tuꞌn t-xi tiꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bꞌeljaj or te qlixje teꞌ tjaw kyqꞌoꞌn Jesús twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ok kypejkꞌin jun tzꞌlan tibꞌajxi twiꞌ, me nej ok kytzꞌibꞌin twutz kyjaluꞌn: Ate Jesúsjo, a Nmaq Kawil kye aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Junx tukꞌa Jesús jaw kyqꞌoꞌn kabꞌe ileqꞌ twutz cruz, jun toj tman qꞌobꞌ ex juntl toj tẍnayaj. ");
INSERT INTO mamC_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ikytzin japin bꞌajjo Tyol Dios tiꞌj Jesús, a ntqꞌmaꞌ: Ok qꞌoꞌn tzeꞌnku jun ileqꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ex jniꞌqe xjal nchi bꞌaj ikyꞌxtaq antza, noqx nchi bꞌaj yasintaq tiꞌj, ex noqx nja kyyekin tiꞌj kywiꞌ te kyxmaybꞌil tiꞌj, ex kyqꞌma: ¡Nyakutzin atejiy nqꞌmante tuꞌn tjaw tyuchꞌiꞌn tnejil ja te naꞌbꞌl Dios, exsin tuꞌn tbꞌant juntl tuꞌn toj oxe qꞌij! ");
INSERT INTO mamC_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Klomiltzin tibꞌa jaꞌlin, ex qꞌinkutz tibꞌa twutz cruz, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ikyx nbꞌaj kyqꞌmaꞌntaqjo jniꞌ kynejil pale exqetziꞌn jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Nbꞌaj kubꞌ kyqꞌmaꞌntaq kyxolile: ¿Tzeꞌn tten nbꞌaj klettaq junjuntl xjal tuꞌn, me antetz, mi nbꞌant tklonte tibꞌ? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","In tkuꞌtz twutz cruz jaꞌlin, tuꞌn tok qkaꞌyin, ex tuꞌn t-xi qnimin, qa twutzxix qa a Crist, a Kolil ex nmaq kawil te aj Israel. Ex ikyqexljo yoꞌlqekstaq tukꞌa twutz cruz, noqx nchi yasin, ex noqx nchi bꞌaj xmayintaq tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Teꞌ tok kabꞌlaj qꞌij, ex tzmaxi toj oxe or te qale, bꞌeꞌx ok yupj twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ax orjo jaw ẍchꞌin Jesús kujxix wen, ex tqꞌma: Eloi, Eloi, lama sabactani. Atzin tzꞌelpine ikyjo: ¡NMan Dios! ¡NMan Dios! ¿Tiꞌxsin quꞌn ma chin kyij ttzaqpiꞌn? ");
INSERT INTO mamC_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","At junjun bꞌaj bꞌinte, kyxolxjo iteꞌxtaq axsa ex bꞌaj kyqꞌma: Kybꞌinxsiꞌn, luꞌ nqꞌolbꞌin tiꞌj Elías, a yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ex jun paqx el rinin jun jyolte chꞌin bꞌuꞌẍ. Kux tmulin toj vin txꞌam, ex ok tkꞌloꞌn tiꞌj twiꞌ jun ptzꞌan, tuꞌn t-xi tkꞌwaꞌn Jesús. Bꞌaj xi kyqꞌmaꞌn xjal te: ¡Ax tenkuj! Jekytzin tzul Elías qꞌilte, tuꞌn tkuꞌtz twutz tcruz. ");
INSERT INTO mamC_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jaw ẍchꞌin Jesús kujxix, ex bꞌeꞌx el kyim. ");
INSERT INTO mamC_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Atzin xbꞌalin tokxtaq tojjo tnejil ja te naꞌbꞌl Dios, bꞌeꞌx kubꞌ laqj te kabꞌe; tzaj xkye tiꞌjjo ttxaꞌn jawl, tuꞌn tkꞌul kanin tiꞌjjo juntl ttxaꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Atzin kynejineljo xqꞌuqil te Rom, waꞌltaq twutz Jesús, teꞌ tok tkaꞌyin otaq tzꞌel kyim, tqꞌma kyjaluꞌn: Twutzx tetz Tkꞌwal Diostaq teꞌ ichin lo. ");
INSERT INTO mamC_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Najchaq nchi bꞌaj kaꞌyintztaq junjun qya; kyxol atetaq Mariy, aj Xleꞌn, ex Salomé, exsin Mariy, tnana jun Santyaw kyitzꞌin kyibꞌ tukꞌa Jse. ");
INSERT INTO mamC_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ayetziꞌn qya, ayeꞌ i bꞌaj bꞌet tukꞌa Jesús teꞌ nbꞌettaq toj Galiley, ex i mojin tukꞌa, me nya oꞌkqexjo, ex iteꞌxtaq txqantl ncheꞌxtaq tukꞌa Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Atzaj teꞌ qok yupj tojjo qꞌij anetziꞌn, jotxtaq xjal tuꞌn tbꞌanttaq kyten te junxil qꞌij, a qꞌij te ajlabꞌl, a jaꞌ mix aꞌltaq tuꞌn taqꞌnin. ");
INSERT INTO mamC_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ante Jse aj Arimatey, jun xjal nimxixtaq toklin kyxol kawil ex nyoꞌntaq tiꞌjjo Tkawbꞌil Dios, el tiꞌn tchewil tiꞌj, exsin xiꞌ tukꞌa Pilat, a kawil, qanil teꞌ t-xmilil Jesús, tuꞌn tel tiꞌn twutz cruz, ex tuꞌn t-xi muqbꞌaj toj jul. ");
INSERT INTO mamC_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Teꞌ tbꞌinte Pilat qa otaq kyim Jesús, bꞌeꞌx jaw kaꞌylaj, exsin xi ttxkoꞌn kynejiljo kawil xqꞌuqil, tuꞌn t-xi tqanin te qa otaq kyim. ");
INSERT INTO mamC_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Teꞌ tbꞌaj tqꞌmaꞌn tkyaqil te Pilat, bꞌeꞌxsin xi ttziyin te Jse, tuꞌn tel tiꞌn, ex tuꞌn tokx tmuquꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tzaj tlaqꞌoꞌn Jse jun iqbꞌil tbꞌanilx wen, kutz tiꞌn t-xmilil Jesús twutz cruz, bꞌaj tptzoꞌn wen tojjo iqbꞌil, exsin okx tqꞌoꞌn toj jun jul, kyij tjpuꞌn tukꞌa jun ma tij abꞌj. ");
INSERT INTO mamC_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ayetzin Mariy, aj Xleꞌn, exsin Mariy, tnana Jse, nchi kaꞌyintaq jaꞌ okxi muquꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tbꞌajlinxiꞌ qꞌij te ajlabꞌl, i xiꞌ Mariy, aj Xleꞌn, exsin Mariy, a tnana Santyaw tukꞌax Salomé, laqꞌol qꞌanbꞌil te jupsbꞌil teꞌ t-xmilil Jesús, tzeꞌntaqjo nchi tene kyimnin kyuꞌn, tuꞌn mi chi tzuwixe. ");
INSERT INTO mamC_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Qlixje wen, teꞌ kyxiꞌ, jun tnejil qꞌij te seman, jaꞌ okx muqet Jesús noqxix njawilku qꞌij, ");
INSERT INTO mamC_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ex chꞌixtaq kypon ttzi jul, teꞌ kyja yolin: ¿Altzila kye k-elil qꞌinte abꞌj ttzi jul? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Me te kypon ttzi jul, nyataqltza tkubꞌe a ma tij abꞌj ttzi jul, jaꞌ okxi, qalaꞌ najchaqtaql taꞌye. ");
INSERT INTO mamC_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","I okx toj jul, me atzaj teꞌ kyokpin, kyli jun qꞌa qꞌuqletaq tok t-xbꞌalin sjanin wen kupinin tzma t-xe tqan. Teꞌ kylonte, bꞌeꞌx i xobꞌx te. ");
INSERT INTO mamC_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Atzin qꞌa bꞌeꞌx xi yolinku kye: Mina chi xobꞌa weꞌy. ¿Atzin nkyjyoꞌnjiꞌy Jesús aj Nazaret, a ja pejkꞌit twutz cruz? O jaw itzꞌje teꞌ; ntiꞌl tzaluꞌn jaꞌlin. Kykaꞌyinkutzinjiꞌy jaꞌ kubꞌe qꞌoꞌne. ");
INSERT INTO mamC_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ku kyxiꞌtziꞌn kyukꞌa t-xnaqꞌtzbꞌin, exsin kꞌaꞌ txi kyqꞌmaꞌn kye ex te Pegr. Chichkujiꞌy kye kyjaluꞌn: Nej kanin Jesús kywutza tzma Galiley, tuꞌntzin tbꞌajjo aj kyij tqꞌmaꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ayetzintzjo qya, bꞌeꞌx i etz toj jul, me nchi bꞌaj luꞌlintaq wen tuꞌn kyxobꞌil, ex bꞌeꞌx i aj, me mix alqe xi kyqꞌmaꞌn tuꞌn kyxobꞌil. ");
INSERT INTO mamC_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Qsqixlinxi te tnejil qꞌij te seman, teꞌ tjaw itzꞌje Jesús. Nej kubꞌ tyekꞌin tibꞌ twutz Mariy, aj Xleꞌn, a otaq tzꞌetz tlajoꞌn wuq taqꞌnil tajaw il toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Me ante qya bꞌeꞌx xiꞌku qꞌmalte kyeꞌ nchi bꞌaj bꞌisintaq ex nchi bꞌaj oqꞌtaq tiꞌj, quꞌn i bꞌaj bꞌet tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Atzin teꞌ tok kybꞌiꞌn te qya, qa otaq jatz anqꞌin Jesús, ex qa otaq tli, mi xi kynimine. ");
INSERT INTO mamC_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tbꞌajlinxiꞌ ikyjo, nchi bꞌettaqjo kabꞌe t-xnaqꞌtzbꞌin, teꞌ tok tyekꞌin tibꞌ kywutz, me mikyxiꞌ tzeꞌn te tok tyekꞌin tibꞌ te qya. ");
INSERT INTO mamC_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Teꞌ kykanin kyukꞌa txqantl kyukꞌa, bꞌaj ok ten qꞌmalte qa otaq kyli. Me mix xaye kynimineꞌ txqantl. ");
INSERT INTO mamC_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yajxi chꞌintl, teꞌ tokpin kykꞌatz, txolejqetaqjo junlajaj t-xnaqꞌtzbꞌin tiꞌjjo meẍ toj jun ja. Noqx jniꞌ i bꞌaj tyisoꞌn, quꞌn mix xi kynimine ayeꞌ i qꞌmante qa otaq jaw anqꞌin juntl majl, ");
INSERT INTO mamC_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","exsin xi tqꞌmaꞌn kye: Ku kyxiꞌy tkyaqil twutz txꞌotxꞌ qꞌmal teꞌ Tbꞌanil Tqanil kolbꞌil kye xjal. ");
INSERT INTO mamC_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ankyeꞌ xjal kxel niminte ex qa ma kuꞌx toj aꞌ te jawsbꞌil aꞌ, ok kletil teꞌ. Me atziꞌn mina txi tnimin, ok kxeꞌl toj najin. ");
INSERT INTO mamC_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ayetziꞌn chi xel niminte tbꞌanilx kbꞌantil kyuꞌn, tzeꞌnku tuꞌn kylajoꞌn taqꞌnil tajaw il toj kyanminxjal, tuꞌn kyyolin toj junxil yol, ");
INSERT INTO mamC_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ex qa ma chi jaw kytzyuꞌn kan, mina chi txꞌaꞌn kyiꞌj; ex qa ma txi kynikyꞌbꞌin qꞌanbꞌil te kyimin, nlay chi kyim tuꞌn; ex aj tkubꞌ kyqꞌoꞌn kyqꞌobꞌ kyibꞌaj yabꞌ, bꞌeꞌx kchi bꞌajel weꞌ kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Teꞌ tbꞌaj tqꞌmaꞌn ikyjo, bꞌeꞌx aj toj kyaꞌj. Teꞌ tjapin, ok qe ttxlaj Dios toj tman qꞌobꞌ kawil tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ayetziꞌn t-xnaqꞌtzbꞌin bꞌeꞌx i xiꞌku qꞌmal teꞌ Tyol Dios te kolbꞌil kyexjal kyojile jniꞌ najbꞌil. Tbꞌanilx bꞌaj bꞌant kyuꞌn, quꞌn ax Dios kubꞌ yekꞌinte tiꞌchaqku tiꞌ te yekꞌbꞌilte qa twutzxtaqjo nbꞌaj kyqꞌmaꞌntaq.");
INSERT INTO mamC_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ma kubꞌ ntzꞌibꞌinjiꞌy luꞌn ay Tyople, kꞌuꞌjlinxix wuꞌn: Ilaꞌ o bꞌaj tzꞌibꞌinte tkyaqiljo jniꞌ o bꞌaj qxol, ");
INSERT INTO mamC_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ex tzeꞌnkuxjo o bꞌaj yekꞌin qe kyuꞌn i lontexix, ex kyij oqxeninxix kye, tuꞌn kyxiꞌ qꞌmalte tzeꞌnxix toke. ");
INSERT INTO mamC_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ex ikyxjo weꞌ, chebꞌexix o bꞌaj nqaniꞌn tzeꞌnxix tzaje xkyeye, tuꞌntziꞌn kyjel ntzꞌibꞌiꞌn ex kyjel nikꞌuꞌnxixa tey, ");
INSERT INTO mamC_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tuꞌntzin telxix tnikyꞌa te o bꞌaj xnaqꞌtzin tey. ");
INSERT INTO mamC_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Teꞌ attaq Herodes kawil toj Judey, attaq jun chꞌuq pale tzajnin tiꞌj tyajiljo jun qtzan pale Abías, ex tojjo chꞌuq anetziꞌn tokxtaq jun pale, Zakariy tbꞌi. Ataqtzin t-xuꞌjil Zakariy, Lisabet tbꞌi, tzajnin tiꞌj tyajiljo qtzan tnejil pale Aarón. ");
INSERT INTO mamC_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kykabꞌilx tbꞌanil xjalqe; ntiꞌxtaq chꞌin bꞌaꞌn tok qꞌmet kyiꞌj qa nya wenqe, quꞌn noqx niminkutaqjo tkawbꞌil Dios kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Noq tij xjalqel, ntiꞌx jun kyal otaq tzul, quꞌn mitaq n-alinxjo t-xuꞌjil. ");
INSERT INTO mamC_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pon jun qꞌij kye chꞌuq pale a tzajninqe tiꞌjjo qtzan Abías tuꞌn kyokx naꞌl Dios, ex patil pon tojjo nim ja te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Me ataqtziꞌn ntene kyuꞌn nej nbꞌaj kyjyoꞌn kyxolx, alkye jun tuꞌn tokx tojjo tnejil ja te nabꞌl Dios, a jaꞌ nkubꞌe patittaq pon; me a Zakariy tzyet tuꞌn tokx. ");
INSERT INTO mamC_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Teꞌ tokx Zakariy naꞌl Dios ex patil pon, kykyaqiljo jniꞌ xjal i bꞌaj kyij naꞌl Dios peꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nnaꞌntaq Dios, ex npatintaq pon, ntiꞌxtaq toj tnabꞌl, me atzaj tok tkaꞌyin noq waꞌl jun t-angel Dios ttxlajjo meẍ, jaꞌ nbꞌaj kubꞌ patittaqjo jniꞌ pon. ");
INSERT INTO mamC_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Teꞌ tlonte Zakariy angel, noq jaw kaꞌylaj, ex bꞌeꞌx tzaj xobꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Me bꞌeꞌx xi tqꞌmaꞌn angel te: ¡Zakariy! Mina tzaj xobꞌa, quꞌn atziꞌn tnaꞌj Diosa, ma tzaj ttzaqꞌwin Dios. Atzin t-xuꞌjila tzul jun tal, ex atzin tbꞌi k-okil tqꞌoꞌn, Juan. ");
INSERT INTO mamC_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Okx ktzalajilxa tiꞌj, ex nya oꞌkxa; quꞌn nimx txqantl ktzalajil tiꞌj, aj tul itzꞌje. ");
INSERT INTO mamC_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Quꞌn nimx k-ajbꞌila tkꞌwala te Dios. Nya txꞌujtinel, ex naꞌmxtaq tul itzꞌje, noq nojninl tanmin tuꞌn Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nimx aj Judiy kꞌwel kybꞌinchin kyten twutz Dios tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A kꞌwel nej twutzjo Kolil tukꞌa nim tipin ex tukꞌa Xewbꞌaj Xjan, tzeꞌnkuj Elías, a yolil Tyol Dios ojtxe, tuꞌn tkubꞌ kyxmoxin manbꞌaj kyibꞌ kyukꞌa kꞌwalbꞌaj, ex ikyqex kꞌwalbꞌaj kyukꞌa manbꞌaj; ex aye xjal, a mina nkubꞌ kybꞌinchin a taj Dios, tuꞌn tel kynikyꞌ tiꞌj, ikyxjo tzeꞌnqeku a nkubꞌ kybꞌinchin wen, tuꞌntzintla noq bꞌantnintl kyten aj tul Kolil. ");
INSERT INTO mamC_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Xi tqꞌmaꞌn Zakariy te angel: ¿Tiꞌn ktzajil tqꞌoꞌn weꞌy tuꞌn t-xi niminjiꞌy tyola? Quꞌn noq taꞌẍqinla ex ikyx nxuꞌjiljiꞌy, ¿Exsin tuꞌn tul jun nkꞌwala jaꞌlin? ");
INSERT INTO mamC_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Xi ttzaqꞌwin angel te: ¡Ayiꞌn Gabriel! Nchin ajbꞌiꞌn te Dios. Ma chin tzaj tchqꞌoꞌn yolil tukꞌiy, ex qꞌmalte tqaniljo luꞌn tey. ");
INSERT INTO mamC_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Me tuꞌn mina xi tniminjiy a xi nqꞌmaꞌn tey, mina bꞌantl tyoliꞌn jaꞌlin, tzmaxi ajxi tjapin tqꞌijjo, a ma txi nqꞌmaꞌn tey. ");
INSERT INTO mamC_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Me ayetziꞌn jniꞌ xjal nchi bꞌaj naꞌntaq Dios peꞌn otaq chi bꞌaj jaw qanlaj kyxolile, quꞌn tuꞌn nqꞌaltex n-etztaq Zakariy toj ja te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Atzaj teꞌ tetz, mix bꞌantil tyolin kyukꞌa jniꞌ xjal, noq tqꞌobꞌqe i xi tyekin, tuꞌn tyekꞌinte jun tiꞌ. Tuꞌntziꞌn ikyjo, bꞌeꞌx el kynikyꞌjo jniꞌ xjal te, qa attaq jun otaq tli, quꞌn kukx xaꞌye mix bꞌantil tyolin. ");
INSERT INTO mamC_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Teꞌ kyjapin bꞌajjo qꞌij tuꞌn taqꞌnin tojjo nim ja te naꞌbꞌl Dios, bꞌeꞌx aj tja. ");
INSERT INTO mamC_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tbꞌajlinxiꞌ ikyjo, n-okku tzꞌaq taljo t-xuꞌjil. Teꞌ tok tzꞌaq tal, ex jweꞌ xjaw mix etz bꞌete toj tja, ex tqꞌma: ");
INSERT INTO mamC_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma qꞌaqꞌin tkꞌuꞌj Dios wiꞌja jaꞌlin, tuꞌn mina chi yolbꞌine xjal wiꞌja, tuꞌn ntiꞌx jun wala otaq tzul, chi Lisabetjo. ");
INSERT INTO mamC_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tbꞌajlinxiꞌ qaq xjaw toklin tzꞌaq tal Lisabet, teꞌ t-xi tchqꞌoꞌn Dios angel Gabriel tzma Nazaret, jun tnam toj txꞌotxꞌ te Galiley, ");
INSERT INTO mamC_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","tuꞌn t-xiꞌ yolil tukꞌa jun txin, a naꞌmtaq tlonte jun ichin. Atzin txin, Mariy tbꞌi. Otaq ja yolin tuꞌn tja meje tukꞌa jun ichin, Jse tbꞌi, tzajnin tiꞌj tyajil qtzan nmaq kawil David. ");
INSERT INTO mamC_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Teꞌ tkanin Gabriel, xi tqꞌmaꞌn teꞌ txin: Ma chin tzaja qꞌolbꞌil tey, Mariy. Ax Dios tukꞌiy ex kyꞌiwlinxixa tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Teꞌ tbꞌinte tyol angel ikyjo, noq el kyim tuꞌn, exsin kubꞌ tbꞌisin tiquꞌnil xi tqꞌmaꞌn angeljo te ikyjo. ");
INSERT INTO mamC_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Xi tqꞌmaꞌn angel te: Mina ja xobꞌa Mariy. Ntzalaj Dios tiꞌja, ");
INSERT INTO mamC_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ex k-okil tzꞌaq jun tala jaꞌlin. Ex ajtzin tul itzꞌje, k-okil tqꞌoꞌn tbꞌi Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tbꞌanil ichinx ex k-okil qꞌoꞌn tbꞌi te Tkꞌwaljo Dios nimx toklin. Ex ax Dios k-okil qꞌonte te kawil, tzeꞌnku qtzan t-xeꞌchil, a David, ");
INSERT INTO mamC_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tuꞌn tkawin kyibꞌaj aj Judiy te jun majx, quꞌn a tkawbꞌil nlay bꞌajx. ");
INSERT INTO mamC_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Xi ttzaqꞌwin Mariy te angel: ¿Tzeꞌn tten tuꞌn tok tzꞌaq wala, ex bꞌajxi chin kubꞌ kẍeyiy tukꞌa jun ichin? chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Xi tqꞌmaꞌn angel te: A t-xlekemil Xewbꞌaj Xjan kꞌwel tibꞌaja tzeꞌn t-xlekemil muj, ex noq tuꞌn tipin Dios, a nimxix toklin, k-okil tzꞌaq tala. Tuꞌntziꞌn ikyjo, a tala tzul itzꞌje xjanxix ex k-okil tbꞌi te Tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ex ikyxjo t-xjalila Lisabet, ntiꞌtaql bꞌisin tuꞌn, tuꞌn tul jun tal, quꞌn noq tijl. Me atzin jaꞌlin, tzul itzꞌje jun tal, quꞌn o bꞌant qaq xjaw toklin tzꞌaq, ");
INSERT INTO mamC_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","quꞌn ntiꞌx te Dios nlayit bꞌant tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Xi tqꞌmaꞌn Mariy: Noq bꞌiꞌnku we wuꞌn tzeꞌn taj Dios wukꞌiy. Qa ikyjo tzeꞌn ma tqꞌmay, bꞌaꞌnla. Ex bꞌeꞌx xiꞌ angel. ");
INSERT INTO mamC_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tbꞌajlinxiꞌ ikyjo, xi tajqelin Mariy tibꞌ, tuꞌn t-xiꞌ toj jun tnam attaq txol wutz te Judey. ");
INSERT INTO mamC_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Teꞌ tkanin, okx toj tja Zakariy, ex qꞌolbꞌin te Lisabet. ");
INSERT INTO mamC_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Teꞌ tbꞌiꞌnte Lisabet teꞌ tqꞌolbꞌin Mariy te, atziꞌn tal bꞌeꞌx jaw yekj toj tkꞌuꞌj. Ex nojnin tanmin Lisabet tuꞌn Xewbꞌaj Xjan, ex xi tqꞌmaꞌn kuj wen te Mariy: A te kyꞌiwlinxix kyxol jniꞌ qya twutz txꞌotxꞌ, ex ikyxjo tala tzul itzꞌje. ");
INSERT INTO mamC_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ex atzin we noq jun tal qyaqinxiꞌy, ¿Exsin tuꞌn wul qꞌolbꞌaja tuꞌn tnana Klol weꞌy? ");
INSERT INTO mamC_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Quꞌn noqx teꞌ xqꞌolbꞌin weꞌy, bꞌeꞌx xjaw yekjo wala tuꞌn tzaljbꞌil toj nkꞌuꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kyꞌiwlinxix te, tuꞌn xi tnimiꞌn qa tuꞌn tbꞌajjo jniꞌ saj tqꞌmaꞌn Dios, a tAjaw Tkyaqil, tey. ");
INSERT INTO mamC_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tqꞌma Mariy: Kjawil nnimsiꞌn tukꞌa tkyaqil wanmiꞌn tbꞌi wAjawa. ");
INSERT INTO mamC_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ex tzunx ntzalajx wanmiꞌn tiꞌj Dios, a Klol weꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ntiꞌxtaq wokliꞌn, me atziꞌn jaꞌlin, ma chin tzaj tkaꞌyiꞌn Dios. Oꞌkqinxa nimxix wokliꞌn kyxoljo jniꞌ xjal jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Quꞌn a Dios nimxix toklin, tbꞌanilx ma tzaj tqꞌoꞌn weꞌy. Xjanxixjo tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Atx te Dios tqꞌaqꞌbꞌil tkꞌuꞌj kyiꞌjjo nchi kubꞌ niminte. ");
INSERT INTO mamC_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tukꞌa tkyaqil tipin, nchi el tiꞌn nimsil kyibꞌ toj kytxꞌixew, ex n-ok tyupiꞌn kybꞌis. ");
INSERT INTO mamC_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","N-el tiꞌn kyoklin nmaq kawil, ex nxi tqꞌoꞌn kye a ntiꞌ kyoklin. ");
INSERT INTO mamC_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ayetziꞌn at waꞌyaj kyiꞌj, nxi tqꞌoꞌn kywa. Ex n-el tiꞌn kyeꞌ a noqx nbꞌaj kyyajin. ");
INSERT INTO mamC_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mi ẍi el najjo aj Judiy toj tkꞌuꞌj. Ma chi tzaj tmojin tukꞌa tqꞌaqꞌbꞌil tkꞌuꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ikytzin tqꞌma ojtxe kye qtzan qyajil Abraham ex kye txqantl kchi ul itzꞌje. ");
INSERT INTO mamC_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kyij Mariy oxe xjaw tja Lisabet. Teꞌ kybꞌajjo oxe xjaw, bꞌeꞌx aj tja. ");
INSERT INTO mamC_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Teꞌ tjapin qꞌij tuꞌn tkubꞌ tzꞌaq Lisabet, ul jun kyal qꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Teꞌ tok kybꞌiꞌn jniꞌ t-xjalil, ex jniꞌ xjal, a at iteꞌke te, i xtaꞌj qꞌolbꞌilte, quꞌn otaq qꞌaqꞌin tkꞌuꞌj Dios tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Teꞌ tbꞌaj wajxaq qꞌij tulin itzꞌje, ul aqꞌbꞌaj techiljo qꞌa, tzeꞌn nchi tenetaqjo jniꞌ kykꞌwal aj Judiy, a qꞌaqetaq. Atziꞌn teꞌ tuꞌntaq tok tbꞌi, Zakariytaq tbꞌi tuꞌntaq tok qꞌoꞌn, tzeꞌnkuxjo tbꞌi ttata. ");
INSERT INTO mamC_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Me mix ttziye tnana, quꞌn Juan tbꞌi k-okilch. ");
INSERT INTO mamC_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Xi kyqꞌmaꞌn xjal te: ¿Tiquꞌn ikyjo? ¿Ma attzin jun kyeꞌ iky tbꞌi? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Xi kyqanin noq tukꞌa techil te ttata tiꞌtaq tbꞌi tuꞌn tok. ");
INSERT INTO mamC_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xi tqanin ttata jun tzꞌlan, jaꞌ tuꞌn tkubꞌ tzꞌibꞌite tbꞌi. Atzaj teꞌ tzaj ttzyuꞌn, kubꞌ ttzꞌibꞌin, Juan tbꞌi. Teꞌ tok kybꞌiꞌn jniꞌ xjal ikyjo, jotx bꞌeꞌx i bꞌaj jaw kaꞌylaj. ");
INSERT INTO mamC_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ex tbꞌajlinxiꞌ ikyjo, bꞌeꞌx bꞌantl tyolin Zakariy, exsin ok ten nimsil tbꞌi Dios. ");
INSERT INTO mamC_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jotxjo jniꞌ xjal antza, junx kyukꞌa tkyaqiljo najleqe tojjo jniꞌ najbꞌil kyxol wutz te Judey, i bꞌaj jaw kaꞌylaj tiꞌjjo jniꞌ otaq bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tkyaqilxjo jniꞌ otaq bꞌaj bꞌinte ikyjo, bꞌaj jaw yolin toj kyanmin ex kyqꞌma: ¿Titzila kbꞌantil tuꞌn kꞌwal? Quꞌn nimx toklin ma tzaj tqꞌoꞌn Dios, a tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariy, a ttata neꞌẍ, noj tanmin tuꞌn Xewbꞌaj Xjan, ex ok ten yolil tuꞌn, ex chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kyꞌiwlinxixjo tbꞌi Dios te Israel, a tAjaw Tkyaqil, quꞌn ma tzul klol teꞌ Ttanim. ");
INSERT INTO mamC_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ma tzaj tqꞌoꞌn jun Klolqe, a nimx toklin, tzajnin tiꞌj tyajiljo qtzan nmaq kawil David, a kubꞌ niminte. ");
INSERT INTO mamC_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Atziꞌn luꞌn a qꞌumj ojtxe kyuꞌn xjan yolil Tyol Dios, tej kyqꞌma: ");
INSERT INTO mamC_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","A tuꞌn tel klonqe kye qajqꞌoj ex kye aye kykyꞌeꞌx qiꞌj; ");
INSERT INTO mamC_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tuꞌn ttzaj qꞌaqꞌin tkꞌuꞌj kyiꞌjjo qyajil, ex tuꞌn mina tzꞌel naje toj tkꞌuꞌj, a tumil xjanxix bꞌant tiꞌj tuꞌn; tuꞌn kykyij Ttanim toj wen tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ex atziꞌn bꞌant tiꞌj tuꞌn, ex tqꞌma te Abraham, a qxeꞌchil kyjaluꞌn, ");
INSERT INTO mamC_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tuꞌn qel tkloꞌn kye qajqꞌoj, ex tuꞌn qajbꞌin te tukꞌa tkyaqil qanmin; ");
INSERT INTO mamC_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tuꞌn tkubꞌ qbꞌinchin qten jikyinxix toj tkyaqil qchwinqil twutz. ");
INSERT INTO mamC_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Atziꞌn te, mil: Yolil Tyol Dios teꞌ tbꞌi k-okil, a Dios nimxix toklin. Quꞌn ay kꞌwel nej twutzjo Kolil qꞌmalte tuꞌn tkubꞌ kybꞌinchinxjal kyibꞌ twutz. ");
INSERT INTO mamC_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kꞌwel tnajsin Dios kyila, ex kchi kletila tuꞌn, chkujiy kye. ");
INSERT INTO mamC_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Quꞌn a Dios tukꞌa tqꞌaqꞌbꞌil tkꞌuꞌj qiꞌj, ktzajil tqꞌoꞌn jun tzaj toj kyaꞌj tzeꞌnku tqan qꞌij, ");
INSERT INTO mamC_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tuꞌn tkꞌant toj kychwinqiljo ayeꞌ nchi bꞌet toj najin, ex tuꞌn tkubꞌ nej qwutz toj tbꞌeyil bꞌaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Atziꞌn kꞌwal nchꞌiyxixtaq tweꞌ ex tnabꞌl, exsin najan tojjo najbꞌil, jaꞌ mixtaq aꞌl najle toj, tzmaxi tpon qꞌij, jaꞌ tuꞌn tkubꞌ tyekꞌine tibꞌ kyxol aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kyojtziꞌn qꞌij ayeꞌ, tqꞌma nmaq kawil toj Rom, Augusto tbꞌi, tuꞌn tjaw ajlet kybꞌajjo jniꞌ xjal tkyaqil twutz txꞌotxꞌ, ex tuꞌn kybꞌaj tzꞌibꞌit. ");
INSERT INTO mamC_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ajo tajlal lo tnejil maj tuꞌn tel tqanil jniꞌ xjal at twutz txꞌotxꞌ. Ataq Sirenio toktaq te kawil toj Siria. ");
INSERT INTO mamC_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jotxjo jniꞌ xjal ok il kyiꞌj tuꞌn kyxiꞌ tzꞌibꞌil kybꞌi tojjo kytanim. ");
INSERT INTO mamC_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tuꞌntziꞌn, bꞌeꞌx etz Jse tojjo tnam te Nazaret toj ttxꞌotxꞌ Galiley, tuꞌn t-xiꞌ tzma Belén toj txꞌotxꞌ te Judey, jaꞌ itzꞌje qtzan nmaq kawil David, quꞌn tiꞌj tyajil David tzajnin. ");
INSERT INTO mamC_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Xiꞌ tzꞌibꞌil tbꞌi junx tukꞌa Mariy, a tuꞌn tmejetaq tukꞌa, ex chꞌixtaq tul tal. ");
INSERT INTO mamC_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Iteꞌxtaq Belén, teꞌ tjapin kaniꞌn qꞌij, jaꞌ tuꞌn tkubꞌ tzꞌaqe Mariy, ");
INSERT INTO mamC_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ex antza itzꞌje tnejil tal. Teꞌ tulku itzꞌje, bꞌaj tptzoꞌn toj tan, exsin kubꞌ tkuẍbꞌin toj twabꞌl chej, quꞌn ntiꞌtaq jun ja, jaꞌ tuꞌn tkubꞌe tkuẍbꞌine. ");
INSERT INTO mamC_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Me nqayin tkꞌatz Belén, iteꞌtaq junjun kyikꞌlel nchi bꞌaj xqꞌuqintaq kyiꞌj kyrit qnikyꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ntiꞌkux toj kynabꞌl, teꞌ tkubꞌ qoptzꞌaj kyiꞌjile tuꞌn tspikyꞌemil tipin Dios, exsin pon jun t-angel Dios kykꞌatz. Tuꞌn ikyjo, bꞌeꞌx i xobꞌxjo kyikꞌlel. ");
INSERT INTO mamC_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Me xi tqꞌmaꞌn angel kye: Mina chi tzaj xobꞌa weꞌy, quꞌn atx jun tqanil ma chin tzaja qꞌmalte kyeꞌy, me a tbꞌanilx wen, ex te tzaljbꞌilx te tkyaqilx xjal. ");
INSERT INTO mamC_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tojjo ttanim David, ma tzꞌitzꞌje jun Kolil jaꞌlin, a Crist, ex a tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tuꞌn tel kynikyꞌa te, ok kjyetil jun neꞌẍ kyuꞌn ptzoꞌnkux toj tan ex kuẍleku toj twabꞌl chej toj jun kyja aluꞌmj. ");
INSERT INTO mamC_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tzunxtaq nyolinjo angel, teꞌ kyul nimku angel kykꞌatz; nchi bꞌaj nimsintaq tbꞌi Dios kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Noqit nkꞌant tqoptzꞌajiyil Dios toj kyaꞌj, ex jun tzaljbꞌil kyxolxjal toj tkyaqil twutz txꞌotxꞌ, a nkubꞌ kybꞌinchin taj Dios. ");
INSERT INTO mamC_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Teꞌ kyaj angel toj kyaꞌj, ayetziꞌn kyikꞌlel i bꞌaj jaw yolin kyxolile ex kyqꞌma: Qoꞌqe Belén lol teꞌ ma bꞌaj, a ma tzaj tqꞌmaꞌn Dios qe. ");
INSERT INTO mamC_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bꞌeꞌxsin i xiꞌ. Atzaj teꞌ kykanin, attaq Mariy exsin Jse, tukꞌa neꞌẍ kuẍlekutaq toj twabꞌl chej. ");
INSERT INTO mamC_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Teꞌ kylonte, i ok ten qꞌmalte tkyaqiljo jniꞌ tqꞌma angel kye. ");
INSERT INTO mamC_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jotqexjo aye nchi bꞌaj bꞌintaq, bꞌeꞌx i el kyim tuꞌn kyqꞌma kyikꞌlel. ");
INSERT INTO mamC_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ante Mariy mix jaw yoline; noq kubꞌ tbꞌisin tkyaqiljo nkyqꞌmaꞌntaq. ");
INSERT INTO mamC_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ayetzin kye kyikꞌlel, ox chi tzalajx, exsin nchi bꞌaj nimsintaq tbꞌi Dios teꞌ kyajtz, quꞌn otaq kybꞌi ex kyli a tzaj qꞌmaꞌn kye. ");
INSERT INTO mamC_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Atzaj teꞌ tbꞌaj wajxaq qꞌij titzꞌjlin neꞌẍ, bꞌeꞌx ul aqꞌbꞌaj techil tiꞌj, tzeꞌnkuxtaqjo ntene, exsin tuꞌn tok tbꞌi. Atziꞌn tbꞌi ok qꞌoꞌn Jesús, quꞌn ikyxtaq tbꞌi tuꞌn tok, a xi tqꞌmaꞌn angel te Mariy, te naꞌmxtaq tok tzꞌaq tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tbꞌajlinxiꞌ ikyjo, tjapin kanin qꞌij, jaꞌ tuꞌn kyxiꞌye txjol tiꞌj nana, tuꞌn tsaqix tuꞌn titzꞌjlin neꞌẍ, tzeꞌnku ntenetaq toj tkawbꞌil Dios. Ex xi kyiꞌn neꞌẍ tzma Jerusalén, tuꞌn t-xi kyqꞌoꞌn toj tqꞌobꞌ Dios. ");
INSERT INTO mamC_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kubꞌ kybꞌinchiꞌn ikyjo quꞌn ikyxtaqjo tzꞌibꞌin toj tkawbꞌil Dios: Tkyaqiljo tnejil kꞌwal qa qꞌa, il tiꞌj tuꞌn t-xi kyqꞌoꞌn toj tqꞌobꞌ Dios. ");
INSERT INTO mamC_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","I xtaꞌj qꞌol chjonte te Dios tukꞌa jun oyaj tzeꞌnku ntqꞌmaꞌn tkawbꞌil Dios; jun muj xlukꞌekꞌ mo kabꞌe tal palomj. ");
INSERT INTO mamC_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kyojjo qꞌij anetziꞌn, najletaq jun ichin Jerusalén, Simeón tbꞌi, nnaꞌntaq Dios ex nyoꞌntaq tiꞌjjo Klolkye aj Judiy tuꞌn tul, ex attaq Xewbꞌaj Xjan tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Atziꞌn Xewbꞌaj Xjan qꞌmaꞌnte te Simeón, tuꞌn tzmaxitaq tuꞌn tkyimjo, aj tlon teꞌ Kolil, a Crist, a tuꞌntaq tul tsmaꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ax Xewbꞌaj Xjan xi qꞌinte Simeón tojjo tnejil ja te naꞌbꞌl Dios, jaꞌ iteꞌtaq Jse ex Mariy tukꞌaxjo kyneꞌẍ, tuꞌn tjapin kyuꞌn a tzꞌibꞌin toj tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tzaj tchleꞌn Simeón tal neꞌẍ, exsin jaw naꞌn Dios: ");
INSERT INTO mamC_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","WAjaw, a tzaj tqꞌmay ma bꞌajx jaꞌlin. Bꞌaꞌn tuꞌn nkyim weꞌ jaꞌlin tukꞌa tzaljbꞌil, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Quꞌn ma nli wejiꞌy Kolil, ");
INSERT INTO mamC_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","a kkolil kyiꞌjjo jniꞌ xjal chi xel niminte tkyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ajo neꞌẍ lo jun tzaj kkꞌantil toj kychwinqiljo jniꞌ xjal, aye mina nxi kynimin Tyola, tuꞌn tel kynikyꞌ tiꞌja. Ex a k-okil te nimsbꞌil tbꞌiy kyxol tkyaqil aj Israel. ");
INSERT INTO mamC_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Teꞌ kybꞌinte Jse ex Mariy a tqꞌma Simeón, noq i el kyim, ");
INSERT INTO mamC_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","exsin i xi tkyꞌiwlin Simeón kyoxelx. Xi tqꞌmaꞌn te tnana Jesús: Atziꞌn neꞌẍ luꞌn ma tzaj tqꞌoꞌn Dios kyxol aj Judiy, tuꞌn tel wen junjun ex junjun mina. A k-ajbꞌil te techiljo a taj Dios kyukꞌaxjal, me nya tkyaqilx kxel niminte. ");
INSERT INTO mamC_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ex antza k-elile tnikyꞌtzajil tbꞌis tanmin junjun, quꞌn junjun kchi xel lipe tiꞌj ex junjun mina. Me te tey, nana, jun kyꞌixbꞌajil te tanmiꞌn tuꞌn bꞌisbꞌajil, aj tok tkaꞌyiꞌn, aj tel ikyꞌin kyuꞌnxjal. ");
INSERT INTO mamC_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ex attaq jun tal bꞌiꞌẍ antza, Ana tbꞌi, tkꞌwaltaq Fanuel tzajnin tiꞌj qtzan Aser, nyolintaq tiꞌj tbꞌi Dios. Txinxtaq wen, teꞌ tok meje tukꞌa tchmil, ex noq wuq abꞌqꞌe i ten junx, teꞌ tkyij mebꞌe, quꞌn bꞌeꞌx kyim tchmil. ");
INSERT INTO mamC_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kyaje toj jweꞌ kꞌal abꞌqꞌetaq Ana, ex noqtaq tojjo tnejil ja te naꞌbꞌl Dios tokxitaq. Minaxtaq n-etz chꞌin qnikyꞌin ex qꞌijl noqx nnaꞌnku Dios, ex nimku maj nkubꞌ tpaꞌn waꞌyaj toj naꞌj Dios. ");
INSERT INTO mamC_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ikyxjo teꞌ t-xtaꞌj aqꞌbꞌajjo tal neꞌẍ Jesús toj nim ja te naꞌbꞌl Dios, ex bꞌeꞌx xtaꞌj qꞌol chjonte te Dios, ex yolil tiꞌjjo neꞌẍ kye jniꞌ xjal aj Jerusalén, ayeꞌ nchi bꞌaj yontaq tiꞌjjo Kolil. ");
INSERT INTO mamC_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Teꞌ tbꞌaj bꞌant kyuꞌn tzeꞌntaqjo ntqꞌmaꞌn tkawbꞌil Dios, bꞌeꞌx i meltzꞌaj juntl majl tojxjo kytanim, a Nazaret te Galiley. ");
INSERT INTO mamC_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Atziꞌn kꞌwal nchꞌiyxixe tweꞌ ex nchꞌiyxixe tnabꞌl, quꞌn nimtaq tqꞌaqꞌbꞌil tkꞌuꞌj Dios tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ayetziꞌn ttata Jesús ncheꞌxtaq tkyaqil abꞌqꞌe Jerusalén ikyꞌsil teꞌ nintz qꞌij, a nkubꞌ kyikyꞌsintaq aj Judiy, teꞌ kyetz toj Egipto. ");
INSERT INTO mamC_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Teꞌ tel Jesús kabꞌlajaj abꞌqꞌe, i xtaꞌj kykyaqilx Jerusalén tzeꞌnxtaq ntene kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Teꞌ kybꞌajjo qꞌij anetziꞌn, bꞌeꞌx i bꞌaj ajtz kyja. Ante Jesús mix iwle kyuꞌn ttata, teꞌ tkyij Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ikyla te kye qa ajintaq Jesús lipchek kyiꞌj kyxoljo jniꞌ xjal. Me atzaj teꞌ tok kykaꞌyin, ex tbꞌaj kyjyoꞌn kyxoljo jniꞌ xjal ex kyxoljo jniꞌ aye kyojtzqiꞌntaq, ntiꞌl; exsin jun qꞌij otaq txi kybꞌetin. ");
INSERT INTO mamC_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Teꞌ mix ja jyete kyuꞌn, bꞌeꞌx i meltzꞌaj jyolte tzma Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Otaqxi bꞌant oxe qꞌij kyjoybꞌin tiꞌj, teꞌ tjyet kyuꞌn, tokxtaq tojjo tnejil ja te naꞌbꞌl Dios, kyxoljo jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil nbꞌintaq tiꞌjjo jniꞌ kyyol, ex nbꞌaj xi tqanintaq junjun tiꞌ kye. Ex ikyqextaqjo xnaqꞌtzil tiꞌj ojtxe kawbꞌil ex nbꞌaj xi kyqanintaq junjun tiꞌ te. ");
INSERT INTO mamC_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ayetziꞌn nchi bꞌaj bꞌintaq tiꞌj, noq i bꞌajel kyim, quꞌn tbꞌanilxtaq tumil toj twutz tuꞌn ttzaqꞌwin a jniꞌ nbꞌaj xi kyqanintaq nmaq xnaqꞌtzil tiꞌj ojtxe kawbꞌil te. ");
INSERT INTO mamC_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Teꞌ tiwle tuꞌn Jse ex Mariy, noq i jaw kaꞌylaj tiꞌj, ex xi tqꞌmaꞌn tnana te: ¡Wal! ¿Tiquꞌn tuꞌn qiꞌja ikyjo? Loqoꞌy tzunx nqo bꞌisin wen tiꞌja tuꞌn tjyete. ");
INSERT INTO mamC_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","I xi ttzaqꞌwin Jesús. ¿Tiquꞌn nchi jyon wiꞌja? ¿Ma nya bꞌiꞌn kyuꞌn qa ilxix tiꞌj tuꞌn nteꞌn toj taqꞌin nMaꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Me mix oke kybꞌiꞌne Jse ex Mariyjo ikyjo. ");
INSERT INTO mamC_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bꞌeꞌx aj kykꞌleꞌn, ex i kubꞌ tnimin. Bꞌeꞌx xiꞌ kyukꞌa tzma Nazaret, quꞌn antza najleqetaq, ex atziꞌn tnana nbꞌisintaq tjunalx toj tanmin tiꞌjjo ikyjo. ");
INSERT INTO mamC_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Me ante Jesús nchꞌiyxixe tweꞌ ex tnabꞌl. Ntzalajtaq Dios tiꞌj ex jniꞌ xjal. ");
INSERT INTO mamC_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nkawintaq te Poncio Pilat toj txꞌotxꞌ te Judey tojjo jweꞌlajaj abꞌqꞌe tjaqꞌ tkawbꞌiljo nmaq kawil toj Rom, Tiberio tbꞌi. Atzinte Herodes tzuntaq nkawin teꞌ toj Galiley; atziꞌn titzꞌin, a Lip tbꞌi, tzuntaq nkawin teꞌ kyoj txꞌotxꞌ te Iturey ex toj Traconit. Ex kawiltaq teꞌ Lisanias toj Abilinia. ");
INSERT INTO mamC_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ayetaqtziꞌn kye Anás tukꞌa Caifás nmaq paleqetaq kyeꞌ kyxol aj Judiy. Tojjo ambꞌil anetziꞌn ex tojjo jun txꞌotxꞌ jaꞌ ntiꞌyetaq kynajbꞌilxjal, kubꞌ toqxenin Dios Tyol te Juan, a tkꞌwal Zakariy. ");
INSERT INTO mamC_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tuꞌnpetziꞌn, ate Juan ikyꞌ teꞌ kyojile jniꞌ najbꞌil, a iteꞌtaq nqayin tkꞌatzjo nim aꞌ Jordán tbꞌi, ex tqꞌma kyexjal qa iltaq tiꞌj tuꞌn tajtz tiꞌj kyanmin toj tkyaqil nya bꞌaꞌn toj kychwinqil, ex tuꞌn kykuꞌx toj aꞌ te jawsbꞌil aꞌ, te jun yekꞌbꞌil qa otaq najsit kyil tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iky bꞌajjo tzeꞌnkuxjo otaq ttzꞌibꞌe qtzan Isaías, a yolil Tyol Dios ojtxe. Chiꞌ kyjaluꞌn: Ex bꞌijte tqꞌajqꞌojil twiꞌ jun aꞌla kujxix wen toj tzqij txꞌotxꞌ, jaꞌ ntiꞌ kynajbꞌilxjal toj, a xi tqꞌmaꞌn kyjaluꞌn: Kybꞌinchim kyteꞌn twutz qAjaw; kyqꞌoꞌnx kyanmiꞌn teꞌ jikyinxix wen. ");
INSERT INTO mamC_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tkyaqiljo a nya bꞌaꞌn toj kychwinqila, il tiꞌj tuꞌn ttxꞌixpit; ikyxjo tzeꞌnku jun bꞌe, a tuꞌn tjikyimixjo, a ma txlaẍ taꞌye, ex tuꞌn tnojsitjo jniꞌ jul at toj, ex tuꞌn tbꞌaj jaw pixkꞌitjo ma tij jawnin, aj tul jun nimx toklin. Ikytziꞌn, il tiꞌj tuꞌn qbꞌinchinte tkyaqil, tuꞌntzin bꞌantnin qten, aj tul qAjaw. ");
INSERT INTO mamC_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Quꞌn kykyaqilx kyexjal kchi kaꞌyil tiꞌjjo tkolbꞌil qMan Dios, a ktzajil tsmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Atzaj teꞌ kyetzxjal tuꞌn kykuꞌx toj aꞌ te jawsbꞌil aꞌ tuꞌn Juan, xi tqꞌmaꞌn kye kyjaluꞌn: Ntiꞌx kyeꞌ kyajbꞌin, ikyqexjiy tzeꞌnku jun chꞌuq maꞌ kan. ¿Ma noqtzin tuꞌnjo jawsbꞌil aꞌ, aku chi kleta toj tyabꞌ twiꞌ Dios kujxix wen, a chꞌix tul kanin? ");
INSERT INTO mamC_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Quꞌn ojtzqiꞌn kyuꞌn kykyaqilxjal, qa axjo kybꞌinchbꞌiꞌn nyekꞌinte qa naꞌm tajtz tiꞌj kyanmiꞌn. ¿Tzeꞌntzin tten nkubꞌ kyximiꞌn kyxola, qa aku chi kleta noq tuꞌn Judiyqiꞌy, a tyajil qtzan Abraham, ex nya tuꞌn tajtz tiꞌj kyanmiꞌn? Tunpetziꞌn, kxel nqꞌmaꞌn kyeꞌy, noqpetzin at kolbꞌiltz ikyjo, majqexpetla kyeꞌ abꞌj luꞌn, aku chi ok tqꞌoꞌn Dios te tyajil Abraham, tuꞌn kyklet. ");
INSERT INTO mamC_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tuꞌnpetziꞌn, chꞌix tul tkawbꞌil Dios kujxix kyibꞌaj kykyaqiljo, ayeꞌ kykyꞌeꞌ tuꞌn tajtz tiꞌj kyanmin, ikyxjo tzeꞌnku tajaw jun wiꞌ tze kjawil ttxꞌemin, qa ntiꞌ twutz n-el. Ex a tze, a ntiꞌ tajbꞌin, k-okix toj qꞌaqꞌ; ikyxsin kchi tenbꞌilajiꞌy qa mi s-ajtz tiꞌj kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ayetzin kyej xjaltz antza xi kyqanin te kyjaluꞌn: ¿Tiꞌtzin aku kubꞌ qbꞌinchintza? ");
INSERT INTO mamC_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Xitzin ttzaqꞌwin Juantz: Ankye teꞌ at kabꞌe t-xbꞌalin, il tiꞌj tuꞌn t-xi tqꞌoꞌn jun teꞌ a ntiꞌ at te; ex ankye teꞌ at twa, il tiꞌj tuꞌn t-xi tqꞌoꞌn chꞌin teꞌ a ntiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ex i tzaj laqꞌe junjun kyej xjal, tuꞌn kykuꞌx toj aꞌ te jawsbꞌil aꞌ. Ayetzin xjal anetziꞌn, a peyil pwaqqetaq toj tkawbꞌil Rom. Me nej xi kyqanin te Juan kyjaluꞌn: Ay xnaqꞌtzil, ¿Yajtzin qeꞌ? ¿Tiꞌn qeꞌ kꞌwel qbꞌinchin? ");
INSERT INTO mamC_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Xitzin ttzaqꞌwin Juan: Mi tzꞌel kypeyin chꞌintla tibꞌajjo qꞌmaꞌntz kyeꞌy, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ex iteꞌ junjuntl xoꞌl qꞌaqꞌ i xi qaninte te kyjaluꞌn: ¿Yajtzin qetza? ¿Tiꞌn qeꞌ kꞌwel qbꞌinchin? Xi tqꞌmaꞌn kye kyjaluꞌn: Ikyxjo kyeꞌ, mina tzꞌok kyxobꞌtzin jun aꞌla, ex mina txi kypatiꞌn jun aꞌla, a ntiꞌ tbꞌinchbꞌin nya bꞌaꞌn, ex mina tzꞌel kyiꞌn jun tiꞌ te jun aꞌla; qalaꞌ qe kykꞌuꞌja tiꞌjjo twiꞌ kykꞌuꞌja n-etz. ");
INSERT INTO mamC_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jotqex kyej xjal tzuntaq chi ayon kyeꞌ, ex tzuntaq chi ximin kyeꞌ toj kynabꞌl, qa ataq te Juan a Crist, a Kolil, a otaq tzaj qꞌoꞌn toklin tuꞌnx Dios. ");
INSERT INTO mamC_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Me atzin te Juan xi qꞌmante kye kyjaluꞌn: Me metzin weꞌ, nchi kux nqꞌoꞌn xjol toj aꞌ te jawsbꞌil aꞌ, te jun yekꞌbꞌil qa ma tzꞌajtz tiꞌj kyanmin. Me ante tzul wiꞌjxiy nya noq oꞌkx tuꞌn kykuꞌxxjal tuꞌn toj aꞌ, qalaꞌ kxel tqꞌoꞌn Xewbꞌaj Xjan toj kyanmin te jun majx te patbꞌil jniꞌ il toj. Quꞌn at nimxixtl tipin tzeꞌnku weꞌ, ex ntiꞌ we woklin nipe tuꞌn woka te taqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Quꞌn luꞌ Kawil kkawil kyibꞌaj xjal tzeꞌnku jun aj triyil, a qꞌiꞌn ma nim tze toj tqꞌobꞌ te xtulbꞌil triy. Ex k-elix tpaꞌn kykyaqilxjal wen kyxoljo nya wen, ikyxjo tzeꞌnku jun xjal, aj t-xtulin triy, ex k-elil tpaꞌn paj tiꞌj. Ex kchi xel tkꞌleꞌn nimil toj kyaꞌj tzeꞌnku tuꞌn tkux tkꞌuꞌn triy toj ttxꞌutxꞌ. Me ayetzin nya nimil, ikyxjo tzeꞌnku paj, ok kchi kꞌwel tpatin tukꞌa qꞌaqꞌ, a mixla k-yupjilx. ");
INSERT INTO mamC_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nimku tumil bꞌaj tqꞌmaꞌn Juan kyexjal, tej tqꞌmetj Tbꞌanil Tqanil. ");
INSERT INTO mamC_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ex majxpe teꞌ aj kawil, Herodes tbꞌi, xi tmiyoꞌn Juan, a Jawsil Aꞌ, quꞌn tuꞌn otaq tzꞌok t-xuꞌjlin Herodías, a t-xuꞌjil Lip, a titzꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nya wen ele ikyjo toj twutz Herodes; bꞌeꞌx xi tqꞌmaꞌn tuꞌn tkux jpet Juan toj tze. Tuꞌntzin ikyjo, bꞌeꞌx chmet nim til twutz Dios. ");
INSERT INTO mamC_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ikytzin bꞌajjo, tej naꞌmxtaq tuꞌn tkuꞌx Juan toj tze. Tej nchi kuꞌxtaq tqꞌoꞌn Juan xjal toj aꞌ te jawsbꞌil aꞌ, ikyxl te Jesús bꞌeꞌx kuꞌx toj aꞌ tuꞌn, te jawsbꞌil aꞌ. Ex tzuntaqtzin nnaꞌnxi Jesús Dios, jun paqx xi jaqpajjo kyaꞌj, ");
INSERT INTO mamC_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ex atziꞌn Xewbꞌaj Xjan kꞌul kanin tibꞌaj, ex iky kaꞌyiꞌn tzeꞌnku jun palom. Ex qꞌajqꞌojin jun yol toj kyaꞌj, ex tqꞌma: Axixpen te nkꞌwala, kꞌuꞌjlinxix wuꞌn, a o jaw nskꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bꞌalaqa lajaj toj kaꞌwnaq te Jesús tabꞌqꞌe, tej t-xi t-xikybꞌiꞌn tkyaqil taqꞌin. Qꞌumlaj qa kꞌwalbꞌaj te Jse, tzeꞌnkuxtaqjo tqanil kyxolxjal. Atzin te Jse kꞌwalbꞌajtaqpen teꞌ te Elí. ");
INSERT INTO mamC_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ataqtzin teꞌ Elí, kꞌwalbꞌajtaq teꞌ te Matat, a tkꞌwaltaq Leví, a tkꞌwaltaq Melkí, a tkꞌwaltaq Jana, a tkꞌwaltaq Jse. ");
INSERT INTO mamC_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Atzin te Jse tkꞌwaltaql te Matatías, a tkꞌwaltaq Amós, a tkꞌwaltaq Nahum, a tkꞌwaltaq Esli, a tkꞌwaltaq Nagai. ");
INSERT INTO mamC_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ataqtzin te Nagai kꞌwalbꞌajtaq teꞌ te Maat, a tkꞌwaltaq Matatías, a tkꞌwaltaq Semei, a tkꞌwaltaq Josec, a tkꞌwaltaq Judá. ");
INSERT INTO mamC_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ataqtzin te Judá kꞌwalbꞌajtaq teꞌ te Joanán, a tkꞌwaltaq Resa, a tkꞌwaltaq Zorobabel, a tkꞌwaltaq Salatiel, a tkꞌwaltaq Neri. ");
INSERT INTO mamC_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ataqtzin te Neri kꞌwalbꞌajtaql teꞌ te Melkí, a tkꞌwaltaq Adi, a tkꞌwaltaq Cosam, a tkꞌwaltaq Elmadam, a tkꞌwaltaq Er. ");
INSERT INTO mamC_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ataqtzin te Er kꞌwalbꞌajtaqtzinl teꞌ te Josué, a tkꞌwaltaq Eliezer, a tkꞌwaltaq Jorim, a tkꞌwaltaq Matat, ");
INSERT INTO mamC_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a tkꞌwaltaq Leví, a tkꞌwaltaq Simeón, a tkꞌwaltaq Judá, a tkꞌwaltaq Jse, a tkꞌwaltaq Jonam, a tkꞌwaltaq Eliaquim. ");
INSERT INTO mamC_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ataqtzin te Eliaquim kꞌwalbꞌajtaql teꞌ te Melea, a tkꞌwaltaq Mena, a tkꞌwaltaq Matata, a tkꞌwaltaq Natán. ");
INSERT INTO mamC_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ataqtzin te Natán kꞌwalbꞌajtaql teꞌ te David, a tkꞌwaltaq Isaí, a tkꞌwaltaq Obed, a tkꞌwaltaq Booz, a tkꞌwaltaq Sala, a tkꞌwaltaq Naasón. ");
INSERT INTO mamC_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ataqtzin te Naasón kꞌwalbꞌajtaql teꞌ te Aminadab, a tkꞌwaltaq Admin, a tkꞌwaltaq Arni, a tkꞌwaltaq Esrom, a tkꞌwaltaq Fares, a tkꞌwaltaq Judá. ");
INSERT INTO mamC_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ataqtzin te Judá kꞌwalbꞌajtaqtzin teꞌ te Jacob, a tkꞌwaltaq Isaac, a tkꞌwaltaq Abraham, a tkꞌwaltaq Taré, a tkꞌwaltaq Nacor, ");
INSERT INTO mamC_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","a tkꞌwaltaq Serug, a tkꞌwaltaq Ragau, a tkꞌwaltaq Peleg, a tkꞌwaltaq Heber, a tkꞌwaltaq Sala. ");
INSERT INTO mamC_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ataqtzin te Sala kꞌwalbꞌajtaqtzin teꞌ te Cainán, a tkꞌwaltaq Arfaxad, a tkꞌwaltaq Sem, a tkꞌwaltaq Noé, a tkꞌwaltaq Lamec, ");
INSERT INTO mamC_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a tkꞌwaltaq Matusalén, a tkꞌwaltaq Enoc, a tkꞌwaltaq Jared, a tkꞌwaltaq Mahalaleel, a tkꞌwaltaq Cainán. ");
INSERT INTO mamC_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ataqtzin te Cainán kꞌwalbꞌajtaqtzin teꞌ te Enós, a tkꞌwaltaq Set, a tkꞌwaltaq Adán. Ataqtzin te Adán tzajnin te Dios. ");
INSERT INTO mamC_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nojnintaq tanmin Jesús tuꞌn Xewbꞌaj Xjan, tej tmeltzꞌaj ttzi Nim Aꞌ Jordán, exsin xiꞌ tuꞌn tkujil Xewbꞌaj Xjan, tzmax tojjo tzqij txꞌotxꞌ jaꞌ ntiꞌye kynajbꞌilxjal toj. ");
INSERT INTO mamC_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kaꞌwnaq qꞌij ten Jesús antza, ex antza oke toj joybꞌil tiꞌj tuꞌn tajaw il, tjoy ttxolil tuꞌn tel tikyꞌin tkawbꞌil tMan. Kyojtziꞌn qꞌij anetziꞌn, ntiꞌx chꞌin xi twaꞌn. Tuꞌntziꞌn ikyjo, bꞌeꞌx tzaj waꞌyaj tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ante tajaw il xi tqꞌmaꞌn te kyjaluꞌn: Qa kꞌwalbꞌajxixtza te Dios, qꞌmanxa kye abꞌj lo, tuꞌn kyok te wabꞌj, quꞌn manyor waꞌyajx tiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Me xi ttzaqꞌwin Jesús: Kyij tzꞌibꞌin toj Tyol Dios, qa nya noq oꞌkx tuꞌn wabꞌj k-anqꞌile texjal. ");
INSERT INTO mamC_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx xiꞌ Jesús tuꞌn tkujil tajaw il twiꞌ jun ma tij wutz, ex jun paqx xi tyekꞌiꞌn kykyaqiljo tnam iteꞌkutaq twutz txꞌotxꞌ, ");
INSERT INTO mamC_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","exsin xi tqꞌmaꞌntz kyjaluꞌn: Kxel nqꞌoꞌn tkyaqiljo kyoklin jniꞌ tnam tzaluꞌn twutz txꞌotxꞌ, tuꞌn tkawiꞌn kyibꞌaj, junx tukꞌa tkyaqil kynimsbꞌil kyibꞌ. Quꞌn weꞌy o tzaje qꞌoꞌneꞌ luꞌn, ex noq alqe wajiꞌy tuꞌn t-xi nqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Me qa ma kubꞌ mejeꞌy kꞌulil nwutza, tkyaqil kxel nqꞌoꞌn tey, chiꞌ tajaw il. ");
INSERT INTO mamC_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Tzꞌibꞌin taꞌ toj Tyol Dios kyjaluꞌn: Kꞌuliꞌn oꞌkx twutz qAjaw, a tDiosa, ex noq te, tuꞌn tajbꞌiniych. ");
INSERT INTO mamC_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tbꞌajlinxiꞌ ikyjo; bꞌeꞌx xiꞌ Jesús juntl majl tuꞌn tkujil tajaw il tzma toj tnam te Jerusalén. Jax tkꞌleꞌn tzmax toj tjuchꞌiljo tnejil ja te naꞌbꞌl Dios, a nimxix tweꞌ, exsin xi tqꞌmaꞌntz te kyjaluꞌn: Qa Kꞌwalbꞌajxixtza te Dios, xoꞌnkuxsin tibꞌtza, tuꞌn tkupiꞌn tzmax twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Quꞌn ikytzin ntqꞌmaꞌn Tyol Dios kyjaluꞌn: Kchi tzajil tsmaꞌn Dios t-angel te kloltiy. ");
INSERT INTO mamC_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ex kjawil qꞌiꞌn kyuꞌn toj kyqꞌobꞌ, tuꞌntzintla mi kyꞌixbꞌiy twiꞌ abꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Me ikyxjo ntqꞌmaꞌn toj Tyol Dios kyjaluꞌn, chi Jesús: Mi tzꞌok tqꞌonjiy qAjaw, a tDiosa toj joybꞌil tiꞌjch. ");
INSERT INTO mamC_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tej mix jyetil tumil tuꞌn tajaw il, tuꞌn tok tqꞌoꞌntaq Jesús toj joybꞌil tiꞌj, bꞌeꞌxsin el tlaqꞌwin jun jteꞌbꞌin qꞌij tibꞌtz tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nojnintaq te Jesús tuꞌn tipin Xewbꞌaj Xjan, tej tmeltzꞌaj toj ttxꞌotxꞌ Galiley, ex nimxtaq nyolajtz tqanil toj kykyaqiljo tnam iteꞌtaq tiꞌjileꞌ txꞌotxꞌ anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Xnaqꞌtzin te Jesús kyojile muꞌẍ ja te kynaꞌbꞌl Judiy Dios tojile junjun najbꞌil, ex tkyaqil xjal i jaw nimsin teꞌ tbꞌi Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Xiꞌ te Jesús tojjo tnam Nazaret, a jaꞌ jawe chꞌiye. Tzeꞌnkuxtaqjo n-oke tuꞌn, okx tojjo muꞌẍ ja te kynaꞌbꞌl Judiy Dios toj tqꞌijil ajlabꞌl, ex jawtzin weꞌtz uꞌjil teꞌ Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Xi qꞌoꞌn tuꞌj Isaías te, aj yolil Tyol Dios. Atzaj teꞌ tjaw tjqoꞌn Jesús, antza jatze jyete jun tnej yol tuꞌn, tzꞌibꞌinku kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nojninqin weꞌ tukꞌa Xewbꞌaj Xjan, a T-xew tAjaw Tkyaqil. Quꞌn ma chin el tpaꞌn, tuꞌn nxiꞌy yolil Tbꞌanil Tqanil kye yaj; ex tuꞌn nxiꞌy qꞌmal teꞌ tzaqpibꞌl kyeꞌ jpunqekux toj tze, a ntiꞌ tumil tuꞌn kyten antza; ex tuꞌn tqꞌanit kywutzjo moẍ, ex tuꞌn nxiꞌy qꞌuqbꞌil kykꞌuꞌjjo a ntiꞌ kyipin; ");
INSERT INTO mamC_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ex tuꞌn tqꞌmetjo tqꞌijil kolbꞌil tuꞌn t-xtalbꞌil tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tbꞌajlinxitziꞌn ikyjo, bꞌeꞌx kubꞌ tjpuꞌn Jesúsjo uꞌj, exsin xi tqꞌoꞌntz teꞌ mojil tojjo muꞌẍ ja te kynaꞌbꞌl Judiy Dios, ex bꞌeꞌx kubꞌ qe. Kykyaqilxjo iteꞌtaq antza, noqx otaq chi ok kyim tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Xitzin t-xikybꞌintz tuꞌn tyolin, ex tqꞌma kyjaluꞌn: Kywutzxa ex texjo qꞌij luꞌn, ma japin bꞌajjo a xjaw wuꞌjiꞌn toj Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kykyaqilx xjal wentaq nkyyolin tiꞌj Jesús, ex nchi jawtaq kaꞌylaj, quꞌn tbꞌanilxtaq t-xiliꞌn tumil Tyol. Nchi bꞌaj jawtaq qanlaj kyxol kyjaluꞌn: ¿Ma nyatzin tej tkꞌwal Jse lo? ");
INSERT INTO mamC_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","I xitzin ttzaqꞌwin Jesús: Tuꞌn kyxima ikyjo, bꞌalaqa aku tzaj kyqꞌmaꞌn jun yol weꞌy kyjaluꞌn: Jun qꞌanil aku kubꞌ tqꞌaꞌnin tibꞌ jaꞌchaqx taꞌyitz. Ikytziꞌn, akula tzaj kyqꞌmaꞌn weꞌy, tuꞌn tkubꞌ nbꞌinchiꞌn tzaluꞌn tkyaqiljo techil wipiꞌn xbꞌant wuꞌn tzma toj tnam Capernaum, tuꞌn tel kynikyꞌa wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Me xi tqꞌmaꞌnl Jesús kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy, qa mix aꞌlx jun yolil Tyol Dios, aku kubꞌ wutzlin tojx ttanim. ");
INSERT INTO mamC_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Quꞌn toj kywutza wen xjalqiꞌy, noq tuꞌn tzajninqiꞌy te qtzan Israel. Me twutzxix kxel nqꞌmaꞌn kyeꞌy, kyojjo qꞌij, tej tten Elías tzaluꞌn toj ttxꞌotxꞌ Israel, nimxtaq qya otaq bꞌaj kyim kychmil exla qa tzajninqetaq te Israel, ikyxjo tzeꞌnku te Elías. Oxe abꞌqꞌe tukꞌa nikyꞌjin mix tzaje jbꞌal. Tuꞌntziꞌn ikyjo, tkyaqil twutz txꞌotxꞌ nimx waꞌyaj tzaj. ");
INSERT INTO mamC_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Me exla qa nimx waꞌyaj tzaj toj txꞌotxꞌ te Israel, mix xaye tchqꞌoꞌne Dios Elías qanil twa te jun mebꞌe qya tzaluꞌn toj Israel, qalaꞌ antza xi chqꞌoꞌnil tukꞌa jun qya otaq kyim tchmil, tojjo tnam Sarepta, nqayin taꞌtaql teꞌ tkꞌatzjo tnam Sidón tojjo txꞌotxꞌ te amaqꞌ xjal. ¿Tiquꞌnil? ");
INSERT INTO mamC_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ex ikyxjo, ilaꞌtaq qxjalil yabꞌ tuꞌn txꞌaꞌk, aj noqtaq n-el lemimin, me mix jun kubꞌ tqꞌaniꞌn Elisey, a yolil Tyol Dios ojtxe, qalaꞌ oꞌkxjo jun bꞌetin xjal, Naamán tbꞌi, a tzajnintaq toj ttxꞌotxꞌ Siria. Ex ikyxjo nya qxjalil. Bꞌalaqa nya oꞌkqox nqo ok tkꞌuꞌjlin Dios. ");
INSERT INTO mamC_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tej tbꞌij teꞌ luꞌn kyuꞌn xjal iteꞌkxtaq tojjo ja te kynaꞌbꞌl Judiy Dios, nimx i jaw qꞌojle. ");
INSERT INTO mamC_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tuꞌntziꞌn ikyjo, bꞌeꞌxsin i bꞌaj jaw weꞌks, exsin tuꞌn tex kylajoꞌntaq Jesús. Xitzin kyiꞌntz twiꞌ jun tij wutz, jaꞌ bꞌinchinkutaqjo kytanim, tuꞌntziꞌn ttzajtaq kyxoꞌn tzmantza. ");
INSERT INTO mamC_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Me atzin te Jesús, ex kyxolile ex bꞌeꞌx xiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Bꞌeꞌx xiꞌ Jesús toj Capernaum, jun tnam toj txꞌotxꞌ te Galiley. Antza oke tene xnaqꞌtzil kyexjal toj jun qꞌij te ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ex bꞌeꞌx i jaw kaꞌylaj kyeꞌ xjal tiꞌjjo t-xnaqꞌtzbꞌil, quꞌn nimxtaq kyokliꞌn Tyol. ");
INSERT INTO mamC_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Me tojtaqtziꞌn jun muꞌẍ ja te kynaꞌbꞌl Dios aj Judiy, attaq jun ichin tzyuꞌntaq tuꞌn jun taqꞌnil tajaw il. Jaw ẍchꞌin, ex tqꞌma kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ay Jesús aj Nazaret, ¿Tiꞌxsin s-ula lolte qxola? Noq ma tzula yuchꞌil qeꞌy. Wojtzqiꞌn te, ex bꞌiꞌn weꞌ wuꞌn, a tejiy Tkꞌwal Dios, xjanxix toklin. ");
INSERT INTO mamC_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Oktzin tyisoꞌn Jesúsjo taqꞌnil tajaw il kyjaluꞌn: Mi chꞌotjiy. Kux tzꞌetza toj tanminjo xjal lo, ex tzaqpinkja. Atzin tej ichin bꞌeꞌx kubꞌ tlankꞌin taqꞌnil tajaw il twutz txꞌotxꞌ ex twutz kykyaqilxjal, tej tkyij ttzaqpiꞌn; ex ntiꞌx chꞌin kyij kyꞌixbꞌe te. ");
INSERT INTO mamC_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kykyaqiljo xjal i bꞌaj jaw kaꞌylaj, ex i bꞌaj jaw yolin kyxolx kyjaluꞌn: ¿Anqeqe kyeꞌ xnaqꞌtzbꞌil ikyjo, a nimxix tkawbꞌil ex nimxix toklin? Nchi etz tlajoꞌn taqꞌnil tajaw il toj kyanminxjal, ex bꞌeꞌx nchi bꞌajetz. ");
INSERT INTO mamC_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ajo toklin ex Tyol Jesús, nimx ikyꞌeꞌ tqanil kyxolileꞌ tkyaqil tnam tiꞌjile Capernaum. ");
INSERT INTO mamC_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tbꞌajlinxiꞌ ikyjo; jaw weꞌ, ex etz Jesús toj muꞌẍ ja te kynaꞌbꞌl Judiy Dios. Bꞌeꞌx xiꞌ, ex okx toj tja Simun. Ataqtziꞌn tnana t-xuꞌjil Simun yabꞌtaq tuꞌn txqan kyaq. Tuꞌntziꞌn, i kubꞌsin kywutz te Jesús, tuꞌntaq tkubꞌ tqꞌanin. ");
INSERT INTO mamC_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kubꞌ kꞌweꞌ Jesús, tuꞌn tok tkaꞌyinj yabꞌ, exsin xi tqꞌmaꞌntz teꞌ nim kyaq, tuꞌn teltaq tpaꞌn tibꞌ tiꞌjjo qya. Texjo paq anetziꞌn, bꞌeꞌx xi chewx kyaq, ex bꞌeꞌx jaw weꞌks tej qya, ex n-ok tentz bꞌinchil chꞌin tiꞌ kye. ");
INSERT INTO mamC_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Atzaj teꞌ qqoqix, tuꞌn otaq kybꞌinte, ex otaq tzꞌok kykaꞌyiꞌn xjal jniꞌ otaq bꞌant tuꞌn Jesús, kykyaqilx xjal attaq yabꞌ kyja ex noq tiꞌchaqku kyyabꞌil, i bꞌaj xi kyiꞌn tkꞌatz Jesús, tuꞌn kybꞌaj kubꞌtaq tqꞌanin. I kubꞌ tqꞌoꞌn tqꞌobꞌ tibꞌajile junjun, ex bꞌeꞌx i qꞌanit. ");
INSERT INTO mamC_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nimku yabꞌil bꞌaj qꞌanit, ex nimx taqꞌnil tajaw il bꞌajetz tlajoꞌn toj kyanminxjal. Aye taqꞌnil tajaw il i bꞌaj jaw ẍchꞌin, ex kyqꞌma kyjaluꞌn: ¡Axixa Tkꞌwal Dios! Me bꞌeꞌx nchi bꞌaj ok tmiyoꞌntaq Jesús, ex mina nchi kubꞌtaq twutzlin tuꞌn kyjawtaq yolin, quꞌn bꞌintaq kyuꞌn, qa axtaq Jesúsjo Tkꞌwal Dios, a Crist. ");
INSERT INTO mamC_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Atziꞌn tej qsqix, bꞌeꞌx ex Jesús toj tnam, tuꞌn t-xiꞌ toj jun txꞌotxꞌ, a ntiꞌ kynajbꞌilxjal toj. Me bꞌeꞌx i ok tenxjal jyolte, ex jyet kyuꞌn jaꞌtaqjo taꞌye, quꞌn kyajtaq tuꞌn tten Jesús kyukꞌa te jun majx. ");
INSERT INTO mamC_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Me atzin te Jesús xi tqꞌmaꞌn kye: ¡Mina! Quꞌn il tiꞌj tuꞌn t-xi nqꞌmaꞌnjiꞌy Tbꞌanil Tqanil tiꞌj Tkawbꞌil Dios kyoj kykyaqil txqantl tnam, quꞌn apen wiljiꞌy ẍin tzaj chqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ikytzin nkubꞌetaq tyolin Jesúsjo Tyol Dios kyojileꞌ muꞌẍ ja te kynaꞌbꞌl Judiy Dios, tojx ttxꞌotxꞌ Judey. ");
INSERT INTO mamC_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jun maj, tej attaq Jesús ttzi jun ma tij nijabꞌ, Genesaret tbꞌi, nimku xjal pon kychmoꞌn kyibꞌ tkꞌatz, ex ok jitzꞌle kyuꞌn, quꞌn kyajtaq tuꞌn tkubꞌ kybꞌiꞌn Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","I xi tkaꞌyin Jesús kabꞌe bark toj tzꞌawin ttzi nijabꞌ. Ntiꞌtaq xjal tokx kyoj, quꞌn ayetaqtziꞌn kyiẍil otaq chi kuꞌtz txjol kyeꞌ kypa te kyiẍbꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ex bꞌeꞌx jax Jesús toj jun bark, a tetaq Simun, ex kubꞌsin twutz te, tuꞌn t-xi tlimoꞌntaq chꞌintljo bark tojxi aꞌ. Ex bꞌeꞌx kubꞌ qe Jesús toj bark, ex tojxsiꞌn aꞌ, ok tentz xnaqꞌtzil kyeꞌ xjal. ");
INSERT INTO mamC_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tbꞌajlinxitzin yolin, xitzin tqꞌmaꞌn te Simun kyjaluꞌn: Qꞌinkxsinjiy bark jaꞌ nim t-xe nijabꞌ, exsin kyxoꞌnkuxjiꞌy kypaꞌy te tzuybꞌil kyiẍ. ");
INSERT INTO mamC_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Me atzin te Simun xi ttzaqꞌwin: ¡Ay Xnaqꞌtzil! Ma tzꞌelkux aqꞌwil quꞌn, tuꞌn qaqꞌniꞌn, exsin ntiꞌx kyiẍtz ma tzyet quꞌn. Me tuꞌn Tyola saj tqꞌmaꞌn, chi kꞌwelix nxoꞌnjiꞌy npaꞌy te kyiẍbꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Atzaj teꞌ tkux kyxoꞌn kypa toj aꞌ, nimx kyiẍ tzyet kyuꞌn. Ayetzin kyej pa noqx tuꞌn kybꞌajeltaq laqj tuꞌn kyiẍ. ");
INSERT INTO mamC_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tuꞌntziꞌn ikyjo, bꞌaj xi kyyekꞌin kyqꞌobꞌ kyeꞌ kyukꞌa, ayeꞌ tajawtaqjo juntl bark, tuꞌntzin kyxiꞌtaql kyeꞌ mojilkye. Ex jun paqx i xiꞌ, ex kykabꞌilx kyej bark i jaw noj kyukꞌa nimku kyiẍ; noqtaq chꞌinl kyaj tuꞌn kyxi yuqꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tej tok tkaꞌyin Simun Pegrjo ikyjo, bꞌeꞌx kubꞌ meje twutz Jesús, exsin xi tqꞌmaꞌntz te: Tata, chin ttzaqpinkja, quꞌn jun aj ilqin weꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Xi tqꞌmaꞌn Pegrjo ikyjo, quꞌn nimxtaq kyxobꞌil junx kyukꞌa Jacob ex Juan, ayeꞌ tkꞌwal Zebedey, ex tukꞌaqetaq Simun, tuꞌn nimx kyiẍ otaq tzyet kyuꞌn. Me ante Jesús xi tqꞌmaꞌn te Simun: Mina jaw xobꞌa, quꞌn texjo paq jaꞌlin, k-okila te chmol xjal, tuꞌn kyklet toj il, ex nya te chmol kyiẍ, tzeꞌnku jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ex bꞌeꞌx xi kyiꞌn bark ttzi txꞌotxꞌ. Ex antza kyije kytzaqpiꞌn tkyaqiljo qꞌiꞌntaq kyuꞌn, exsin i bꞌaj xi lipetz tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jun qꞌij, attaq Jesús toj jun tnam, kanin jun ichin tkꞌatz, ex otaqx yajx tuꞌn jun txꞌaꞌk noqx n-el lemimin. Atzaj teꞌ tok tkaꞌyin Jesús, kubꞌ meje, exsin kubꞌ t-xoꞌn twutz tzmax twutz txꞌotxꞌ. Jaw kubꞌsin twutz kyjaluꞌn: Ay wAjaw, qa taja, bꞌaꞌn tuꞌn nkubꞌ tqꞌaniꞌn tukꞌa nyabꞌila. ");
INSERT INTO mamC_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Noq ok tmekoꞌn Jesús, ex xi tqꞌmaꞌntz te: Waja. Bꞌeꞌx ma qꞌanita jaꞌlin. Texjo paq anetziꞌn, bꞌeꞌx qꞌanitkux te jun majx. ");
INSERT INTO mamC_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Exsin xi toqxeninxix Jesús te: Mi txi tqꞌmaꞌn te aꞌla. Qalaꞌ ku txiꞌy, ex yekꞌinx tibꞌa te kypale aj Judiy, ex qꞌonxa jun oyaj te aqꞌbꞌil chjonte, tuꞌn ma tzul Dios tey, a tzeꞌnkuxjo kubꞌ ttzꞌibꞌin Moisés ojtxe, tuꞌntzin kybꞌin texjal qa ma qꞌanita. ");
INSERT INTO mamC_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Me mix tuꞌn ikyjo, nimx n-ikyꞌtaqljo tqanil Jesús, ex nimxtaq xjal nbꞌaj ok chmoꞌn kyibꞌ tiꞌj, tuꞌn tbꞌaj ok kybꞌiꞌntaqjo Tyol, ex tuꞌn kybꞌaj kubꞌ tqꞌanintaqjo kyyabꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Me ataqtzin te Jesús, bꞌeꞌxtaq n-el tpaꞌn teꞌ tibꞌ kyiꞌj, ex nxiꞌtaq teꞌ naꞌl Dios jaꞌ mixtaq aꞌl jun at. ");
INSERT INTO mamC_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","18","Toj jun qꞌij, tzuntaq nchi kubꞌ t-xnaqꞌtzin Jesús xjal, ex attaqjo tipin Dios tukꞌa, tuꞌn kyqꞌanittaqjo yabꞌ. Me antza, attaq junjun Parisey exqetziꞌn xnaqꞌtzil tiꞌjjo ojtxe kawbꞌil tzajninqetaq toj junjun kojbꞌil, iteꞌkutaq toj ttxꞌotxꞌ Galiley, Judey, ex Jerusalén. Qꞌuqleqetaq tkꞌatz Jesús toj jun ja, tej kykanin junjun ichin iqintaq jun yabꞌ kyuꞌn twiꞌ tkuẍbꞌil. Ex ataqtzin teꞌ yabꞌ noq otaq tzꞌok kꞌolpaj. Kyajtaqjo xjal tuꞌn tokx kyiꞌn twutz Jesús, me mibꞌintaq tokx. ");
INSERT INTO mamC_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tuꞌntzin mix jyete tumil kyuꞌn tzeꞌn tuꞌn tokxi kyinetaq, tuꞌn tpajjo nimxtaq xjal at; tuꞌntziꞌn ikyjo, bꞌeꞌx i bꞌaj jax tibꞌajxi ja, ex jaw kypoꞌqꞌin xkꞌoꞌn antza, ex kux tuninin yabꞌ kyuꞌn tukꞌax tkuẍbꞌil, ex kupin kyiꞌntz twutz Jesús ex kywutz txqan xjal. ");
INSERT INTO mamC_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tuꞌn ikyjo, ex tej tok tkaꞌyin Jesúsjo kynimbꞌil, xi tqꞌmaꞌn te yabꞌ kyjaluꞌn: Ay wukꞌa, ayetzin tila ma chi kubꞌ najsit jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Me ayetzin kyeꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn jniꞌ Parisey, bꞌeꞌx i ok ten kyeꞌ ximilte kyjaluꞌn: ¿Tzeꞌntzin tten n-el tzaqpaj ttzi ichin ikyjo? quꞌn noq nxoꞌn yol tiꞌj Dios tuꞌn maꞌ tyolch. Quꞌn oꞌkx te Dios aku bꞌant najsin te til jun xjal. ");
INSERT INTO mamC_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Me ante Jesús bꞌeꞌx el tnikyꞌ tiꞌj tiꞌtaq nkyxime, ex xi tqanin kye: ¿Tiquꞌn nkubꞌ kyximinjiꞌy ikyjo? ");
INSERT INTO mamC_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ankye junx tzꞌele tuꞌn t-xi qꞌmet, tuꞌn tkubꞌ najsit til jun xjal, a tzeꞌnkuljo tuꞌn t-xi qꞌmet: Weꞌksa, ex kux bꞌeta? ¿Ma nyapela a te kujxixjo a tuꞌn tnajsit til jun xjal? ");
INSERT INTO mamC_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Me mi nxi kynimiꞌn qa ikyjo. Me atzin jaꞌlin, kxel nyekꞌiꞌn kywutza qa ayin weꞌ, a Tkꞌwal Ichin, at wokliꞌn tzaluꞌn twutz txꞌotxꞌ, tuꞌn tkubꞌ nnajsiꞌn kyilxjal te jun majx. Tuꞌnpetziꞌn, xi tqꞌmaꞌn te yabꞌ: Kxel nqꞌmaꞌn tey, ¡Weꞌksa! ¡Qꞌinxjiy tkuẍbꞌila, ex kux tzꞌaja tjay! ");
INSERT INTO mamC_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ex jun paqx jaw weꞌ tej yabꞌ kywutz kykyaqilxjal, ex jaw tchmoꞌn tkuẍbꞌil, ex bꞌeꞌx aj tja nnimsin tbꞌi Dios wen. ");
INSERT INTO mamC_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kykyaqilxjal i jaw kaꞌylaj, ex jaw kynimsin tbꞌi Dios, exsin tukꞌa txqan kyxobꞌil bꞌaj kubꞌ kyqꞌmaꞌn kyxolx: Tzmaxpen xqliyx jun tiꞌ te kaꞌybꞌajil, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tbꞌajlinxiꞌ ikyjo; bꞌeꞌx etzku Jesús toj ja. Tej tbꞌet, ex iwle jun ichin tuꞌn, peyil pwaqtaq te kꞌaybꞌil te Rom, ex ataqtziꞌn tbꞌi ichin, Leví. Ex antza qꞌuqletaq tojjo najbꞌil, jaꞌ npeyintaq kꞌaybꞌil. Exsin xi tqꞌmaꞌn Jesústz te kyjaluꞌn: Lipeka wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jun paqx jaw weꞌ Leví, ex kyij ttzaqpiꞌn tkyaqil, ex bꞌeꞌx ikyꞌ lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tbꞌajlinxiꞌ ikyjo, atzin te Leví kubꞌ tbꞌinchin jun tbꞌanil waꞌn tiꞌj Jesús, ex ilaꞌku tukꞌa Leví, nchi bꞌaj peyintaq kꞌaybꞌil te Rom, junx kyukꞌa junjunl xjal, qꞌuqleqetaq kyukꞌa tiꞌj meẍ. ");
INSERT INTO mamC_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Me ayetzin kyeꞌ Parisey exqetziꞌn xnaqꞌtzil tiꞌjjo ojtxe kawbꞌil ex kyukꞌaxtaq kyibꞌ i bꞌaj jaw yolbꞌin kyiꞌj t-xnaqꞌtzbꞌin Jesús kyjaluꞌn: ¿Tiꞌquꞌnil majqex kyeꞌ nchi bꞌaj waꞌn, ex nchi bꞌaj kꞌwan kyukꞌa maꞌ peyil kꞌaybꞌil ex jniꞌ bꞌinchil il? ");
INSERT INTO mamC_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","I xitzin ttzaqꞌwin Jesús kyjaluꞌn: Ayetziꞌn bꞌaꞌnqe ntiꞌ kye tajbꞌin qꞌanil kye; me meqetziꞌn yabꞌqe, atpen kyeꞌ tajbꞌin kye. ");
INSERT INTO mamC_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tuꞌnpetziꞌn, nya ma chin tzaj weꞌ txkol kye xjal nbꞌaj kubꞌ kybꞌisin qa bꞌaꞌn kyten; qalaꞌ ayin wejiꞌy ma chin tzaj txkolkye ayeꞌ bꞌinchil ilqe, tuꞌn tajtz tiꞌj kyanmin. Tuꞌnpetziꞌn, ma chin ula kyxol. ");
INSERT INTO mamC_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Me ayetzin kyeꞌ Parisey exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil xi kyqꞌmaꞌn te Jesús: Ayetziꞌn t-xnaqꞌtzbꞌin Juan, a Jawsil Aꞌ, exqetziꞌn Parisey, nimx nbꞌaj kubꞌ kypaꞌn waꞌyaj tuꞌn kynaꞌn Dios, me ayetzin kye t-xnaqꞌtzbꞌiꞌn, kukxjo nchi bꞌaj waꞌn ex nchi bꞌaj kꞌwan. ");
INSERT INTO mamC_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","I xitzin ttzaqꞌwin Jesús kyjaluꞌn: ¿Ma akutzin kubꞌ kywutzlin kyeꞌ, tuꞌn tkubꞌ kypaꞌn txokenj waꞌyaj toj jun mejebꞌlin, qa axsa taꞌye chmilbꞌaj kyxol? Ikytzin iteꞌye wejiꞌy nxnaqꞌtzibꞌin, quꞌn loqiꞌn ntin kyxol. ");
INSERT INTO mamC_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Me pon kanin jun qꞌij, jaꞌ tuꞌn wele najiꞌy, a ayiꞌn, a ikyxjo tzeꞌnku chmilbꞌaj kyxol. Ajtzin tjapin kaninjo qꞌij anetziꞌn, okpetzila kꞌwel kypaꞌntz waꞌyaj, tuꞌn kynaꞌn Dios wen. ");
INSERT INTO mamC_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ex kubꞌ tqꞌmaꞌnl Jesús oxe techil kyjaluꞌn: Tnejil, mix aꞌlx aku tzꞌel ttajkꞌin chꞌin bꞌuꞌẍ tiꞌj jun saq xbꞌalin, tuꞌn tok te slepbꞌilte junl xbꞌalin noql ttxꞌaqin. Qa ma kubꞌ tbꞌinchin ikyjo, nkubꞌ tyajiꞌn saq bꞌuꞌẍ, exsin nya wen kkaꞌyile tukꞌaljo ttxꞌaqin xbꞌalin. ");
INSERT INTO mamC_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ex tkabꞌ, tzeꞌn aj tkux bꞌinchit vin; nlay kuꞌx bꞌinchit toj jun ttxꞌaqin tzꞌuꞌn, quꞌn ajtzin tloqlin, bꞌeꞌx aku tzꞌex laqj, ex noq aku chi kubꞌ najx kykabꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tuꞌntziꞌn, il tiꞌj tuꞌn tkux bꞌinchit vin toj jun saq tzꞌuꞌn. Ikytziꞌn wejiꞌy nxnaqꞌtzbꞌil, nlay bꞌant tuꞌn tok smet tukꞌa juntl tumil. ");
INSERT INTO mamC_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ex toxin: Aꞌlchaqx jun aꞌla, nxi tkꞌwaꞌn jun wiq vin, nlay ttziye, tuꞌn t-xi tkꞌwaꞌn junl wiq kꞌwabꞌj, a saq, quꞌn naqꞌle tiꞌjjo tkꞌwaꞌ, a tbꞌanilx toj twutz. Ikytzin kyejiꞌy naqꞌleqe kyeꞌ tiꞌjjo ojtxe tumil. Tuꞌnpetziꞌn kykyꞌeꞌy tuꞌn kyxi lipey tiꞌj nxnaqꞌtzbꞌila, a saq, exla qa wenxixtl tzeꞌnku ojtxe. ");
INSERT INTO mamC_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Toj jun qꞌij te ajlabꞌl, nchi bꞌettaq Jesús kyxol awal. Me ayetaqtziꞌn t-xnaqꞌtzbꞌin nbꞌaj jawtaq kyxbꞌoqin triy, ex nbꞌaj kubꞌ kyxqꞌuchintaq toj kyqꞌobꞌ, exsin bꞌaj xi kywaꞌntz. ");
INSERT INTO mamC_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iteꞌtaq junjun Parisey antza, exsin bꞌaj xi kyqanintz kye kyjaluꞌn: ¿Tiquꞌnil nkubꞌ kybꞌinchinjiꞌy jun tiꞌ, a nya qꞌoꞌn tuꞌn tkubꞌ bꞌinchit kyojjo qꞌij te ajlabꞌl, jaꞌ mix aꞌl jun tuꞌn tja aqꞌnin? ");
INSERT INTO mamC_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","I xitzin ttzaqꞌwin Jesús kyjaluꞌn: ¿Ma naꞌmtzin tkux kyuꞌjin kyejiꞌy bꞌant jun maj tuꞌn qtzan David, a nimx toklin, tej ttzaj waꞌyaj tiꞌj kyukꞌa tukꞌa? ");
INSERT INTO mamC_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bꞌeꞌx okx toj ojtxe tja Dios, exsin i etz tiꞌn wabꞌj, a otaq chi kubꞌ kyꞌiwlit te oyaj twutz Dios. Ex i xi twaꞌn, exsin xi tqꞌoꞌntz kyeꞌ tukꞌa, a ntiꞌtaq kyoklin tiꞌj tuꞌn t-xi kywaꞌn, qalaꞌ oꞌkqextaq pale. ");
INSERT INTO mamC_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Exsin xi tqꞌmaꞌnltz: Tzeꞌnku nteꞌn, ayiꞌn Tkꞌwal Ichin, chqꞌonqintza tuꞌn Dios kyxola; ex ayiꞌn at woklin tibꞌajjo qꞌij te ajlabꞌl, ex ayiꞌn chin qꞌmalte qa wen tuꞌn tkubꞌ bꞌinchit jun tiꞌ mo qa minaj. ");
INSERT INTO mamC_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tojtzin juntl qꞌij te ajlabꞌl, okx Jesús toj jun muꞌẍ ja te naꞌbꞌl Dios. Tokpinxi, ok ten xnaqꞌtzil kyeꞌ xjal. Tojxtaqtziꞌn kꞌulbꞌil, attaq jun ichin, a ntiꞌtaq tanmin tman tqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ex ayetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn jniꞌ Parisey nchi bꞌaj ẍlukꞌintaq tiꞌj Jesús, qa tuꞌntaq tkubꞌ tqꞌanin yabꞌ toj jun qꞌij te ajlabꞌl, noq tuꞌn kystzꞌimin tiꞌj qa otaq kubꞌ tzꞌaq toj til, quꞌn nya wentaq toj kywutz tuꞌn tkubꞌ bꞌinchit jun tiꞌ toj qꞌij te ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Me ataqtzin te Jesús tojtzqiꞌntaql teꞌ kyxim, exsin xi tqꞌmaꞌntz teꞌ yabꞌ: ¡Weꞌksa, ex weꞌkuy kywutzxjal! Atzin tej ichin bꞌeꞌx jaw weꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Atzin te Jesús xi tqꞌmaꞌn kyeꞌ xjal kyjaluꞌn: At jun weꞌ tuꞌn t-xi nqanin kyeꞌy: ¿Ma tzuntzin ntqꞌmaꞌn tuꞌn tkubꞌ bꞌinchitjo nya wen, mo a wenj; tuꞌn tklet tchwinqil jun xjal, mo tuꞌn tok kaꞌyitj tuꞌn tkubꞌ kyim? ");
INSERT INTO mamC_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tbꞌajlinxi tqꞌmaꞌn ikyjo, bꞌeꞌx xi tkaꞌyinku toj kywutzxjal iteꞌtaq tiꞌjile, exsin xi tqꞌmaꞌntz te ichin, yabꞌtaqjo tqꞌobꞌ: Nuqpinx tqꞌobꞌa. Atzin tej ichin kubꞌ tbꞌinchin tzeꞌnku otaq txi qꞌmaꞌn te, ex texjo tqan, bꞌeꞌx el weꞌ tyabꞌil tqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Me ayetzin kyej txqan xjal nimx txqan kyqꞌoj tzaj; i jaw yolbꞌin tiꞌjlbꞌinxi Jesús, exsin i ok tentz jyolte tumil tiꞌtaq tuꞌn tkubꞌ kybꞌinchin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kyojjo qꞌij anetziꞌn, bꞌeꞌx jax Jesús twiꞌ jun wutz naꞌl Dios, ex elkux aqꞌwil tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Atzaj teꞌ qsqix, kykyaqiljo lipcheqetaq tiꞌj i tzaj ttxkoꞌn, exsin i jaw tjyoꞌntz kabꞌlajaj ichin kyxolx, tuꞌn kyok te t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Atzin kybꞌi junjun ichin i jaw tskꞌoꞌn: Simun, a ok tqꞌoꞌn juntl tbꞌi te Pegr; majxljo Andrés, a titzꞌin; Santyaw; Juan; Lip; Bartolomey; ");
INSERT INTO mamC_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","majqexl Matey; Tmas; Santyaw, a tkꞌwal Alpey; Simun, a toktaqljo qꞌolbꞌinte te Celote; ");
INSERT INTO mamC_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","majqexl Judas, a titzꞌin Santyaw; exsin Judas Iscariot, a ok meltzꞌaj tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kuꞌtz Jesús kyukꞌa t-xnaqꞌtzbꞌin twiꞌ wutz, exsin kubꞌ weꞌ Jesús toj jun chqꞌajlaj. Antza otaq bꞌaj chmete nimku xjal, ayeꞌ otaq chi bꞌaj ok lipe tiꞌj, junx kyukꞌa a otaq chi bꞌaj tzajxi tzmax toj ttxꞌotxꞌ Judey, Jerusalén exqetziꞌn najleqetaq toj mlaj toj ttxꞌotxꞌ Tiro, ex otaq chi pon chmetljo najal te Sidón. Otaq chi pon chmetjo xjal antza, noq tuꞌn toktaq kybꞌiꞌn Tyol, ex tuꞌn tkubꞌ qꞌanitjo yabꞌqetaq. ");
INSERT INTO mamC_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Majqexpekyej xjal i qꞌanit, ayeꞌ nimxtaq n-ikyꞌx kyuꞌn, noq kyuꞌn taqꞌnil tajaw il. ");
INSERT INTO mamC_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ikytaqtziꞌn kykyaqilxjo xjal kyajtaq tuꞌn tok kymekoꞌn Jesús, quꞌn nimxtaq tipin, tuꞌn kyqꞌanitjo kykyaqilxjal yabꞌqetaq. ");
INSERT INTO mamC_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jawtzin tiꞌn Jesús twutz, exsin xi tkaꞌyintz toj kywutz t-xnaqꞌtzbꞌin, exsin xi tqꞌmaꞌn kye kyjaluꞌn: Kyꞌiwlinqexix kyeꞌ, a ayiꞌy yajqiꞌy jaꞌlin, quꞌn at kyokliꞌn tiꞌjjo Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kyꞌiwlinqexix kyeꞌ, a ayiꞌy at waꞌyaj kyiꞌja jaꞌlin, quꞌn tzul jun qꞌij tuꞌn kynoja. Kyꞌiwlinqexix kyeꞌ, a ayiꞌy nchi bꞌaj oqꞌa jaꞌlin, quꞌn tzul jun qꞌij, jaꞌ kchi tzeꞌjilxa. ");
INSERT INTO mamC_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kyꞌiwlinqexix kyeꞌ, aj kyel ikyꞌiꞌn kyuꞌnxjal, aj kyex lajoꞌn, ex aj kyok yisoꞌn kyuꞌn, aj tel iꞌjliꞌn kybꞌiꞌy, noqx tuꞌn npaja, ayiꞌn a Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Qa ma tzikyꞌx kyuꞌn, chi tzeꞌjixa, ex chi tzalajxa, quꞌn ktzajil tqꞌoꞌn Dios nim t-xel kyeꞌy toj kyaꞌj, tzeꞌnku xi tqꞌoꞌn kye yolil Tyol Dios ojtxe, tuꞌn nim sikyꞌx kyuꞌn, tzeꞌnkuxjo kye jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Me bꞌisbꞌajilxla kyeꞌy, a ayiꞌy qꞌininqiꞌy; ntiꞌx kyeꞌ tzaljbꞌil tuꞌn tkubꞌ kyyoꞌn, quꞌn loqe kyeꞌ noqx nchi tzalaj jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ex bꞌisbꞌajilxla kyeꞌy, a ayiꞌy noqx nchi loꞌnkuy jaꞌlin, quꞌn tzul jun qꞌij kyibꞌaja te nim waꞌyaj. Ex bꞌisbꞌajilxla kyeꞌy, loqiꞌy noqx nchi tzeꞌja jaꞌlin, quꞌn okxla kchi oqꞌila, ex kchi labꞌila. ");
INSERT INTO mamC_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ex bꞌisbꞌajilxla kyeꞌy, a ayiꞌy njaw nimsin kybꞌiy kyuꞌnxjal qa wenqiꞌy, quꞌn ikyx jawe kynimsin xjaljo kybꞌi aye ok kyqꞌoꞌn kyibꞌ te yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Me atzin kyetza, a loqiꞌy nchin kubꞌ kybꞌiꞌn, kxel nqꞌmaꞌn: Kykꞌuꞌjlinqektzinjiꞌy kyajqꞌoja; kybꞌinchinktziꞌn jun wen kye nchi el ikyꞌin kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kyqaninxa kyꞌiwbꞌil kyibꞌajjo nchi qanbꞌin kyiꞌja. Chi naꞌn Diosa kyiꞌjjo nchi ok yison kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Qa at jun s-ok laqtzꞌin te jun plaj kytziꞌy, kymeltzꞌinxjiꞌy juntl plaj. Ex qa at jun nlabꞌte tuꞌn t-xi tiꞌn tchaketa, majx kykotpinxjiꞌy kykamiẍa tukꞌa te jun majx. ");
INSERT INTO mamC_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Qa at jun saj qanin te jun tiꞌ kyeꞌy, kyqꞌonxa; ex qa at jun s-el elqꞌin te jun tiꞌ kyeꞌy, mi txi kyqanintla. ");
INSERT INTO mamC_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tuꞌnpetziꞌn, kukxittzin kubꞌ kybꞌinchinjiꞌy kyukꞌa txqantl, tzeꞌnku kyaja tuꞌn tkubꞌ bꞌinchit kye. ");
INSERT INTO mamC_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Quꞌn qa oꞌkx ẍi ok kykꞌuꞌjlinjiꞌy ayeꞌ nchi ok kꞌuꞌjlin kyeꞌy, ¿Tiꞌtzin jun tbꞌaniltz nkubꞌ kybꞌinchiꞌn ikyjo? Quꞌn ikypen kye bꞌinchil iljo nbꞌant kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ex qa ma tzꞌok kybꞌinchiꞌn jun wen noq kyiꞌjku xjal nchi ok bꞌinchin teꞌ wen kyiꞌja, ¿Tiꞌtzin jun tbꞌaniltz nkubꞌ kybꞌinchiꞌn ikyjo? Quꞌn ikypen kye bꞌinchil iljo nbꞌant kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ex qa ma txi kyqꞌoꞌn jun txꞌex kyexjal noq tuꞌn ttzaj qꞌoꞌnku chꞌin taꞌl kyeꞌy, ¿Tiꞌtzin jun tbꞌaniltz nkubꞌ kybꞌinchiꞌn ikyjo? Quꞌn ikypen kye aj iljo nbꞌant kyuꞌn, quꞌn nchi bꞌaj jaw txon kyxolile, ex nkubꞌ kyyoꞌn, tuꞌn ttzaj qꞌoꞌn kyinxljo te manbꞌilte. ");
INSERT INTO mamC_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tuꞌnpetziꞌn, il tiꞌj tuꞌn tok kykꞌuꞌjlin kyeꞌ kyajqꞌoj, ex tuꞌn tkubꞌ kybꞌinchinjiꞌy wen. Kyqꞌonxa txꞌex ex mina bꞌaj kubꞌ kyyoꞌn, tuꞌn tbꞌaj tzaj qꞌoꞌn manbꞌilte. Ikytzin ktzajile nim t-xeljo kyeꞌy, ex ikytzin kchi okilejiꞌy te tbꞌanil tkꞌwal Dios, nimxix tbꞌi. Qo ok tzeꞌnku te qMan, quꞌn ntzaj pax teꞌ tanmin kyiꞌjjo mibꞌin chi qꞌon chjonte ex kyiꞌjjo nya wen xjalqe. ");
INSERT INTO mamC_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tzaj qꞌaqꞌintzin kyeꞌ kykꞌuꞌj kyiꞌj xjal, tzeꞌnku ntzaj qꞌaqꞌin te qMan Dios tkꞌuꞌj kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mi chi oka kawil kyibꞌaj kynimbꞌil txqantl, tuꞌntzintla mi kawine Dios kyibꞌaja. Ex mi chi yolbꞌiꞌn kyiꞌj txqantl, tuꞌn mi yolbꞌin Dios kyiꞌja, aj kyxiꞌy toj paꞌbꞌin. Kynajsinkuy kyil txqantl tukꞌa tkyaqil kyanmiꞌn, ex ikytziꞌn kꞌwele tnajsinte Diosjo kyila. ");
INSERT INTO mamC_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ku kyoka soꞌj kyukꞌa kykyaqil, ex axte Dios k-okil soꞌj kyukꞌiy. Ex ktzajil tqꞌoꞌn Dios t-xel kyeꞌy tzꞌaqlexix, ex nojninxix, ex chꞌuqin wen. Quꞌn axla malbꞌiljo k-okil tqꞌoꞌn Dios kyiꞌja, tzeꞌnkuxjo s-ok kyqꞌoꞌn kyiꞌj txqantl. ");
INSERT INTO mamC_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kubꞌtzin tyolin Jesús jun techil kywutz kyjaluꞌn, tuꞌn mi cheꞌxe lipe kyiꞌjjo xnaqꞌtzbꞌil nya wen: ¿Ma akutzin bꞌant tuꞌn tkubꞌ nej jun moẍ, yekꞌil teꞌ tbꞌe juntl moẍ? ¿Ma nyapetzila kykabꞌilx aku chi kux lankꞌaj toj xaq? ");
INSERT INTO mamC_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ex mix aꞌl jun xnaqꞌtzbꞌin aku tzꞌok nimxixtl toklin tzeꞌnku xnaqꞌtzilte. Qalaꞌ tzmaxi aj tjapin bꞌaj xnaqꞌtzbꞌil tuꞌn, okpin japin toklintz tzeꞌnxjo te xnaqꞌtzilte. ");
INSERT INTO mamC_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mi chi oktza tzeꞌnqeku xnaqꞌtzil, a at jun il nbꞌant tuꞌn, bꞌalaqa tzeꞌnku jun ma tij tze toj twutz, exsin taj tuꞌn tmojin, tuꞌn tetz jun tal netzꞌ tzꞌis toj twutz tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Tzeꞌntzin tten tuꞌn t-xi tqꞌmaꞌn te termana, Yonkutzin nej, tuꞌn tetz wiꞌn tzꞌis toj twutza, ex mi ntnaꞌn qa ma tijjo te tokx? ¡Xmiletzꞌqiꞌy! Ntiꞌ kynabꞌla ikyjo. Il tiꞌj nej tuꞌn tetz te ma tij tze toj twutz, tuꞌntzintla tbꞌant tkaꞌyiꞌn, tuꞌn tetz tiꞌn ajo tal netzꞌ tzꞌis, a at toj twutz termana. ");
INSERT INTO mamC_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nya tuꞌn kyxi lipeꞌy kyiꞌjjo xnaqꞌtzil, a nya wen, quꞌn noq tiꞌjjo kybꞌinchbꞌin k-elile kynikyꞌa kyiꞌj. Quꞌn ikytziꞌn tzeꞌnku jun tze, a nya wen, nlay tzꞌel twutz, a wen te lobꞌj. Ex ikyxjo, jun tze, a tbꞌanil, nlay tzꞌel twutz, a nya wen. ");
INSERT INTO mamC_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ikyxjo tzeꞌnku jun tze, n-el tnikyꞌtzajil noq tuꞌnjo twutz. Quꞌn nlay tzꞌel twutz iw tiꞌj txꞌiꞌx; ex nlay tzꞌel twutz uv tiꞌj saqtxꞌiꞌx. ");
INSERT INTO mamC_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ikytzin jun tbꞌanil xjaljo, tbꞌanil tanmin, a jaꞌ n-anqꞌine tbꞌinchbꞌin wen. Me atzin xjal nya wen, ex nya wen tanmin, a jaꞌ n-anqꞌineꞌ tbꞌinchbꞌin nya wen. Tzeꞌnkuxsiꞌn at toj kyanmin, qa jun tbꞌanil mo jun nya wenj, ikyxsin chi yoliꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Tiquꞌnil ntzaj kyqꞌmaꞌn weꞌy, wAjaw, wAjaw, exsin mina nkubꞌ kybꞌinchinjiꞌy a nxi nqꞌmaꞌn kyeꞌy? ");
INSERT INTO mamC_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kxel nqꞌmaꞌn jun tumil kyeꞌy tzeꞌntzin t-xilin jun aꞌla ktzajil lipe wiꞌja, a nkubꞌ tbꞌinchin a nxi nqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ikytziꞌn tzeꞌnku jun ichin, kjawil tbꞌinchin jun tja; tnejilxix kꞌwelix tlakuꞌn tqꞌuqil, exsin kꞌwel tbꞌinchintz tibꞌaj abꞌj. Tej ttzaj nim jbꞌal, jaw chꞌiy nim aꞌ ex pon peqꞌj aꞌ tiꞌjjo ja, me mix jawe yekche, quꞌn bꞌinchinku tibꞌaj abꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Me atzin teꞌ nchin kubꞌ tbꞌiꞌn, me mina nchin kubꞌ tnimiꞌn, ikytzin kbꞌajileꞌ tzeꞌnku jun ichin, a nkubꞌ tbꞌinchin tja tibꞌaj tzꞌawin, exsin mix jawe tbꞌinchineꞌ tqꞌuqil. Teꞌ ttzaj nim jbꞌal, jaw chꞌiy nim aꞌ, ex pon peqꞌj aꞌ tiꞌjjo ja, ex jun paqx jaw yuchꞌj te jun majx. ");
INSERT INTO mamC_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tbꞌajlinxi tyolin Jesúsjo jniꞌ tyol kyexjal, a nchi bꞌintaq tiꞌj, bꞌeꞌxsin xiꞌtz toj tnam te Capernaum. ");
INSERT INTO mamC_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ex tojjo tnam anetziꞌn ataqtza najle jun xjal nejinel kyibꞌaj xoꞌl qꞌaqꞌ, ex atzin tej xjal anetziꞌn yabꞌtaqjo jun taqꞌnil, a tajxixtaq tiꞌj, me chꞌixtaq tkyim. ");
INSERT INTO mamC_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Atzaj teꞌ tbꞌintej nejinel jun tqanil Jesús, bꞌeꞌxsin i xi tchqꞌoꞌntz jun jteꞌbꞌin xjal, a attaq kyoklin kyxol Judiy, tuꞌntzintla kykubꞌsin kywutz te Jesús tuꞌn tkanin qꞌanil teꞌ taqꞌnil, a chꞌixtaq tkyim. ");
INSERT INTO mamC_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","I kubꞌsin kywutz nimxix te Jesús, tej kypon kanin tkꞌatz, exsin xi kyqꞌmaꞌntz te kyjaluꞌn: Taa, nimsinx tkꞌuꞌja, atla qajiꞌy noqit aku txiꞌy qukꞌiy, exsin tuꞌn tkubꞌ tqꞌaninjiy ajo jun taqꞌniljo jun tbꞌanil nejinel. ");
INSERT INTO mamC_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tbꞌanilxjo nejinel anetziꞌn, ex at toklin tuꞌn tkubꞌ tbꞌinchiꞌn, quꞌn tajxix tiꞌj qtanim, ex o kubꞌ tbꞌinchin jun ja te qnabꞌl Dios, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bꞌeꞌxsin xi lipe te Jesús kyiꞌjjo xjal anetziꞌn. Atzaj teꞌ chꞌixtaq kypon kanin, bꞌeꞌxsin i ul oybꞌaj kyuꞌn jun jteꞌbꞌin tukꞌa nejinel, tuꞌn t-xi kyqꞌmaꞌn jun kyyol te Jesús. Chi chiꞌ kyjaluꞌn: Taa, nya ilxix tiꞌj tuꞌn tula tzma tja nejinel, quꞌn tuꞌn ntiꞌ weꞌ woklin tuꞌn toktza toj njaych. ");
INSERT INTO mamC_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tuꞌnpetziꞌn, mina ẍinka tkꞌatza, quꞌn tuꞌn nya bꞌaꞌnqiꞌn, ex ntiꞌ wokliꞌn twutza, me oꞌkx qꞌmantz jun jteꞌ tyola, ex noq tuꞌn tyola ok kqꞌanitil weꞌ waqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Quꞌn ikyqinx wejiꞌy at weꞌ kawilwe, me ex iteꞌ xoꞌl qꞌaqꞌ iteꞌkx tjaqꞌ nkawbꞌila. Qatzin ma txi nqꞌmaꞌn te jun kyjaluꞌn: Kux txiꞌy, ex bꞌeꞌxsin kxeꞌltz; ex qa: Ku tzaja, qa nchijiꞌy te juntl, ex bꞌeꞌx ktzajil. Ex qa: Bꞌinchinkujiꞌy luꞌn, qa nchijiꞌy te waqꞌnila, ex bꞌeꞌx kꞌwel tbꞌinchin. Ikytziꞌn, n-el nnikyꞌjiꞌy tiꞌja, qa aku qꞌanj noq tuꞌn Tyola. ");
INSERT INTO mamC_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tej tbꞌinte Jesúsjo ikyjo, bꞌeꞌx jaw kaꞌylaj, ex bꞌeꞌx tzaj meltzꞌaj, exsin tzaj tqꞌmaꞌntz kyeꞌ xjal, a lipcheqetaq tiꞌj. Chiꞌ kyjaluꞌn: Twutzxix kxel nqꞌmaꞌn kyeꞌy, naꞌmx nbꞌintiꞌy jun ichin kyxol aj Israel, a atit nim tnimbꞌil tzeꞌnku tnimbꞌiljo ichin lo, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Otaq qꞌanit tej taqꞌnil kawil, tej kymeltzꞌajjo xjal, ayej i xi chqꞌoꞌn tuꞌn nejinel txkolte Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tbꞌajlinxitziꞌn ikyjo, xiꞌ Jesús tojjo jun tnam, Naín tbꞌi. Aye t-xnaqꞌtzbꞌin ex jun chꞌuq xjal xi lipe tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Atzaj teꞌ tkanin nqayin ttxaꞌn tnam, oktzin tkꞌulbꞌin tibꞌ kyukꞌa txqan xjal, a iqintaq jun kyimnin kyuꞌn, a tuꞌntaq kyxiꞌ muqulte. Ajo kyimnin anetziꞌn, albꞌajtaq te jun mebꞌe qya, ex oꞌkxtaq taljo qya anetziꞌn. Tuꞌn ikyjo nimxtaqjo xjal te aj tnam lipcheqektaq tiꞌj te nimsil tkꞌuꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Atzaj teꞌ tiwleꞌ mebꞌe qya tuꞌn Jesús, a tAjaw Tkyaqil, bꞌeꞌx tzaj qꞌaqꞌin tkꞌuꞌj tiꞌj, exsin xi tqꞌmaꞌntz te kyjaluꞌn: Ay qya, mina tzꞌoꞌqꞌ te. ");
INSERT INTO mamC_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Texjo paq anetziꞌn, bꞌeꞌx ok laqꞌe Jesús tkꞌatz kyimnin. Ok tmekoꞌnjo tzꞌlan jaꞌ iqintaq. Tuꞌn ikyjo, bꞌeꞌx i kubꞌ weꞌ kyej xjal, a iteꞌkxtaq tjaqꞌ. Xitzin tqꞌmaꞌn Jesústz tej kyimnin kyjaluꞌn: Ay qꞌa, kxel nqꞌmaꞌn tey: ¡Qeksa! ");
INSERT INTO mamC_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bꞌeꞌxsin jaw qe tej kyimnintaq, exsin ok tentz yolil. Tuꞌn ikyjo, bꞌeꞌxsin xi qꞌoꞌntz te tnana tuꞌn Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jotqexjo xjal, a iteꞌtaq antza, bꞌeꞌx tzaj kyxobꞌil, tej tiwleꞌ a otaq bꞌaj. Tuꞌntziꞌn, bꞌeꞌx ok ten nimsil teꞌ tbꞌi qMan Dios. Chi chiꞌ kyjaluꞌn: Luꞌ jun nmaq yolil Tyol Dios ma jaw anqꞌin qxol, ex: Luꞌ te Dios ma tzul klol teꞌ Ttanim, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jotxjo a otaq bꞌant tuꞌn Jesús, bꞌeꞌx bꞌijte teꞌ toj tkyaqil tnam te Judey exsin kyojjo txꞌotxꞌ, a nqayin iteꞌk tkꞌatz. ");
INSERT INTO mamC_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tkyaqiljo lo bꞌijte tuꞌn Juan, a Jawsil Aꞌ, quꞌn tuꞌn bꞌeꞌx xi qꞌmaꞌn te kyuꞌnj t-xnaqꞌtzbꞌin. I tzajtzin ttxkoꞌn kabꞌe, ");
INSERT INTO mamC_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","exsin xi tchqꞌoꞌntz qanilte te Jesús kyjaluꞌn: ¿Atzinjiꞌy a Crist, a attaq tulil, mo qa at juntl, tuꞌn tkubꞌ qyoꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Atzaj teꞌ kykanin ichin tkꞌatz Jesús, a i xi chqꞌoꞌn tuꞌn Juan, xitzin kyqanintz kyjaluꞌn: Ma qo tzaj chqꞌoꞌn qeꞌ tuꞌn Juan, a Jawsil Aꞌ, tuꞌn t-xi qqaniꞌn tey, aj qa ajiy, a il tiꞌj tuꞌn tul kanin, mo qa qo ayolja tiꞌj juntl aꞌla. ");
INSERT INTO mamC_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Texjo paq anetziꞌn, nimku yabꞌil i qꞌanit tuꞌn Jesús, ex nimku kyixkꞌoj, a jun paqx n-el lemimin; ex nim taqꞌnil tajaw il, bꞌajetz toj kyanminxjal; ex nimku moẍqetaq i jqet kywutz tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tbꞌajlinxitziꞌn ikyjo, xitzin ttzaqꞌwiꞌn kyqanbꞌitzjo ichin, a i xi tchqꞌoꞌn Juan. Chiꞌ kyjaluꞌn: Kux cheꞌxa, ex kyqꞌmanxa te Juan ajo ma kyliꞌy, exsiꞌn ma kybꞌiꞌy, ikyxjo tzeꞌnku kyij tzꞌibꞌit wiꞌja toj Tuꞌjil Tyol Dios. Chiꞌ kyjaluꞌn: Aye moẍtaq ma chi kꞌant kywutz, aye koxtaq ma chi bꞌet, exqetziꞌn yabꞌqetaq tuꞌn nim txꞌaꞌk, ma chi qꞌanit; exqetziꞌn ẍoꞌrtaq, ma chi bꞌin; exqetziꞌn otaq chi kyim, ma chi jaw anqꞌin juntl majl. Ex jniꞌ qeꞌ yaj ma pon tqanil Tbꞌanil Tqanil kolbꞌil kye. ");
INSERT INTO mamC_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ex kyꞌiwlinqexixjo a mi njawje kykꞌuꞌj wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tej kymeltzꞌajjo t-xnaqꞌtzbꞌin Juan, bꞌeꞌx ok ten Jesús yolil tiꞌj Juan kyukꞌaxjal. Xi tqꞌmaꞌn kye kyjaluꞌn: Tej kyxiꞌy lolte Juan toj tzqij txꞌotxꞌ, ¿Tiꞌtaqtzin wiq ichin kyajtaqa tuꞌn kylontiꞌy? ¿Ma noqpe jun ichin kabꞌe tkꞌuꞌj, tzeꞌnku jun ajlaj meltzꞌaje tuꞌn kyqꞌiqꞌ? ");
INSERT INTO mamC_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Qa mina, ¿Tiꞌtaqtzin kyajtza tuꞌn kylontiꞌy? ¿Moj qa jun ichin manyor tbꞌanilx t-xbꞌalin tok? Me bꞌiꞌn kyeꞌ kyuꞌn, qa toj kyja nmaq kawil najleqe kyeꞌ ichin, a tbꞌanilx kyxbꞌalin tok, ex nimx nchi achin tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Me tiꞌtzin chi txaꞌjtza lolte? ¿Bꞌalaqa jun yolil Tyol Dios? ¡Ikytziꞌn! Me ante Juan nimxixtl toklin kyibꞌaj tkyaqil yolil Tyol Dios, aye i kꞌmonte Tyol ojtxe. ");
INSERT INTO mamC_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Quꞌn ikytzin tqꞌma Diosjo tiꞌj toj Tuꞌjil Tyol kyjaluꞌn: Kxel nchqꞌoꞌn weꞌ nsan twutza qꞌmalte tqanil tulila, tuꞌn tkubꞌ kybꞌinchinxjal kyibꞌ twutza. ");
INSERT INTO mamC_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Twutzxix kxel nqꞌmaꞌn, qa kyxol tkyaqilxjal twutz txꞌotxꞌ, mix aꞌl jun nimxixtl toklin tzeꞌnku te Juan, a Jawsil Aꞌ. Me ajo a noq tal chꞌin toklin toj Tkawbꞌil Dios toj kyaꞌj, nimxixtl toklin tzeꞌnku te Juan. ");
INSERT INTO mamC_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jotqexjo xjal, a otaq kybꞌi tyol Juan ex majqexpe kyej xjal, a peyil pwaqqe te Rom, xi kytziyin te Juan tuꞌn kykuꞌx toj aꞌ te jawsbꞌil aꞌ, ex xi kyqꞌoꞌn chjonte te Dios, quꞌn el kynikyꞌ te qa tzꞌaqlexix te Dios. ");
INSERT INTO mamC_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Me ayeqetzin kyej Parisey exqetziꞌn jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil, mix kytziye kyeꞌ tuꞌn kykuꞌx toj aꞌ te jawsbꞌil aꞌ tuꞌn Juan. Tuꞌn ikyjo bꞌeꞌxsin el kyikyꞌin a tajtaq Dios kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kꞌwel nqꞌoꞌn jun techil tzeꞌnqe xjal jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ikyqetziꞌn tzeꞌnqeku tal kꞌwal nchi kubꞌ qe saqchal toj kꞌaybꞌil. Ex nxi kyẍchꞌin te kyukꞌa, tuꞌn kysaqchaꞌn junx, ex nxi kyqꞌmaꞌn: Ma qo chinbꞌiꞌn kyukꞌa xux, tuꞌntzintla qsaqchan, ex tuꞌn kytzalaja ex tuꞌn kybꞌixiꞌn, me mi ẍi bꞌixiꞌn. Tuꞌnpetziꞌn, ma txi qbꞌitziꞌn bꞌitz te bꞌisbꞌajil, tuꞌntzintla qsaqchan, ex tuꞌn kyoqꞌa, me mix aꞌl s-oqꞌ. ¿Tiꞌxsin kyajtza? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ikytzin kyejiꞌy, chi Jesús. Quꞌn tej tul Juan, a mix waꞌn pan ex mix kꞌwan vin kyukꞌa txqantl, ex xi kyqꞌmaꞌn qa attaq taqꞌnil tajaw il toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ex ma chin ula, ayiꞌn Tkꞌwal Ichin jaꞌlin, a nchin waꞌn ex nchin kꞌwan kyukꞌa noq tiꞌchaqku xjal, me nkyqꞌmaꞌnla wiꞌja qa loꞌlqiꞌn, ex jun kyukꞌa peyil pwaq ex kyukꞌa aj il. Ex ayetzin kye, ¿Tiꞌxsila kyajtza? ");
INSERT INTO mamC_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kxel nqꞌmaꞌn qa atzin k-elile kynikyꞌa tiꞌjjo naꞌbꞌl ntzaj tuꞌn Dios tiꞌjjo qbꞌinchbꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tbꞌajlinxiꞌ ikyjo, jun Parisey kubꞌsin twutz tuꞌn t-xiꞌ Jesús waꞌl junx tukꞌa toj tja. Kutzin, chi Jesúsjo. Atzaj teꞌ tkanin, ok qe tiꞌj meẍ. Qꞌuqletaq te Jesús, ");
INSERT INTO mamC_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","tej tpon kanin jun qya, a bꞌinchil il, a axsa najletaq tojjo tnam anetziꞌn. Ex otaq tbꞌi tej qya anetziꞌn qa otaq pon kanin Jesús waꞌl toj tja Parisey. Tuꞌn ikyjo, xi tiꞌn jun ẍunk nojnin tukꞌa jun wiq aꞌ kꞌokꞌjxix wen; ajo ẍunk bꞌinchin tukꞌa jun wiq abꞌj tbꞌanilx wen. ");
INSERT INTO mamC_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pon laqꞌe tej qya kykꞌatz tqan Jesús, ok ten oqꞌil ex kyukꞌa taꞌl twutz, oktzin tentz txjolkye tqan Jesús. Atzaj teꞌ kybꞌaj txjet, bꞌeꞌxsin ok tentz tzqijsilkye kyukꞌa tsmal twiꞌ, ex i el tmaꞌtzin tqan, exsin ok tqoꞌn aꞌ kꞌokꞌjsbꞌil kyiꞌj, a qꞌiꞌntaq tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Atzaj teꞌ tiwle lo tuꞌn Parisey, a xi txkonte Jesús, ul jun t-xim kyjaluꞌn toj tanmin: A noqxit jun yolil Tyol Dios teꞌ ichin lo, matla kaninte tiꞌj tzeꞌn taꞌye tchwinqiljo qya, a luꞌ n-ok tzyunte, quꞌn ajo qya lo, jun bꞌinchil il teꞌ, chtej Parisey. ");
INSERT INTO mamC_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Atziꞌn te Jesús bꞌeꞌx kanin teꞌ tiꞌj t-xim Parisey. Tuꞌntziꞌn, iky xi tqꞌmaꞌn kyjaluꞌn: Ay Simun, at jun weꞌ tuꞌn t-xi nqꞌmaꞌn tey. Atzin te Parisey xi ttzaqꞌwin kyjaluꞌn: Kutzin, Xnaqꞌtzil. Qꞌmantza. ");
INSERT INTO mamC_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Xitzin tqꞌmaꞌn Jesús kyjaluꞌn: Iteꞌtaq kabꞌe xjal, a attaq kykꞌas tukꞌa jun ichin, a bꞌaꞌntaq qꞌon pwaq txꞌex. Attaqtzin teꞌ jun jweꞌ syent pwaqtaq teꞌ ttxꞌex. Ataqtzil teꞌ juntl lajaj toj ox kꞌaltaq teꞌ ttxꞌex. ");
INSERT INTO mamC_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Me quꞌn tuꞌn mix jaꞌ nchjetetaqjo kykꞌas, bꞌeꞌx kubꞌ najsiꞌn kykꞌas tuꞌnjo ichin, a tajaw pwaqtaq. Kutzin. Qꞌmantzintza weꞌy jaꞌlin, chi Jesúsjo te Parisey. Kyxoljo kabꞌe kꞌasbꞌine lo, ¿Altzila kyeꞌ k-okil kꞌuꞌjlinte chꞌintljo tajaw kꞌas? ");
INSERT INTO mamC_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Xitzin ttzaqꞌwin Simun kyjaluꞌn: Toj nwutza, bꞌalaqa a ichin, a nimxixtaq chꞌintljo tkꞌas. Twutzx teꞌ, chi Jesúsjo. Ikypen teꞌ tzeꞌnku ma tzaj tqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Xitzin kaꞌyin Jesús toj twutzjo qya, exsin xi tqꞌmaꞌntz te Simun kyjaluꞌn: ¿Man tzꞌiwle qya lo tuꞌn, a ma chi el ttxjoꞌn nqaꞌn tukꞌa taꞌl twutz, ex ma chi el tsuꞌn kyukꞌa tsmal twiꞌ tuꞌntzintla kytzqijtz? Me metziꞌn te, ma chin tzaj ttxkoꞌn tuꞌn woktza toj tjay, me ntiꞌ chꞌin aꞌ saj tqꞌoꞌn te txꞌajbꞌilkye nqaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ex mi ẍin el tmaꞌtziꞌn te qꞌolbꞌil weꞌy, tzeꞌnku ntene qxol; qalatzin teꞌ qya lo, noqx teꞌ ẍin oktza, bꞌeꞌx s-ok ten maꞌtzilkye nqaꞌn, ex naꞌmx tuꞌn tkubꞌ qen jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ex ntiꞌ te aseyt ma jax tqꞌoꞌn toj nwiꞌy, a tzeꞌnkuxjo nbꞌinchajtz, me metzin teꞌ qya lo, at teꞌ aꞌ, a kꞌokꞌjxix wen ma tzꞌok tqoꞌn kyiꞌj nqaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn tey, qa noq tuꞌn nim tkꞌuꞌjjo qya wiꞌja, ma chi kubꞌ najsit nimku til. Me atzin teꞌ xjal, a nya nim til toj twutz, ex nya nim tkꞌuꞌj wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tbꞌajlinxi tqꞌmaꞌn ikyjo, xitzin tqꞌmaꞌnltz teꞌ qya kyjaluꞌn: ¡Ay, qya! Ma chi najsit te til jaꞌlin wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ayetzin kyej txqantl xjal, a otaq chi pon txkoꞌntl waꞌl junx tukꞌa Jesús, i ok ten kyeꞌ qanilte kyxolx kyjaluꞌn: ¿Ankye teꞌ xjal lo, a nimsil tibꞌ? ¿Majqexjo kyilxjal nchi kubꞌ tnajsin? ");
INSERT INTO mamC_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Me atzin te Jesús, bꞌeꞌx xi kyiml teꞌ tiꞌj qya anetziꞌn, exsin xi tqꞌmaꞌnltz kyjaluꞌn: ¡Ay qya! Noq tuꞌnjo tnimbꞌila wiꞌja, ma kletiy. Atziꞌn jaꞌlin toj tzaljbꞌil kux meltzꞌaja, chi Jesúsjo te. ");
INSERT INTO mamC_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tbꞌajlinxiꞌ ikyjo, bꞌaj bꞌet Jesús tojile ilaꞌ tnam ex tojile ilaꞌ kojbꞌil, tuꞌn tqꞌmet, ex tuꞌn tchikyꞌbꞌitjo Tkawbꞌil qMan Dios. Majqex kyeꞌ kabꞌlajaj t-xnaqꞌtzbꞌin, lipcheqektaq tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ex iteꞌtaq jun jteꞌbꞌin qya lipcheqektaq tiꞌj, ayej a otaq chi qꞌanit tuꞌn Jesús kyeꞌ taqꞌnil tajaw il ex teꞌ ilaꞌkul yabꞌil. Kyxoljo qya anetziꞌn tokxtaq Mariy, aj Xleꞌn tbꞌi nqꞌolbꞌajtztaq, exsin otaq chi etzjo wuq taqꞌnil tajaw il toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ex majxjo Juana, a t-xuꞌjil Cuza, aj mojiltaq tukꞌa Herodes, majx Susana exsin txqantl qya, ayej nchi mojintaq tukꞌa Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nimkuxjal i pon kychmoꞌn kyibꞌ tkꞌatz Jesús, ayej i bꞌaj tzaj tojile junjun tnam, quꞌn kyajtaqjo xjal anetziꞌn tuꞌn tiwle Jesús kyuꞌn. Oktzin ten Jesús yolil tiꞌjjo jun techil, a ntqꞌmaꞌn kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Jun maj, attaq jun xjal ex, awal triy. Atzaj teꞌ t-xi tchtoꞌn tijaj, ilaꞌku ijaj i pon tzꞌaq toj bꞌe. Tuꞌntziꞌn, bꞌeꞌx i bꞌaj kywaꞌbꞌinxjal, ex bꞌeꞌx jaw kywaꞌn pichꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ex ilaꞌkul ijaj i pon tzꞌaq kyxol abꞌj. Ulpin kyeꞌ kywiꞌ, me liweyxix i jaw tzqij, quꞌn tuꞌn ntiꞌtaq takꞌiljo txꞌotxꞌ anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Atx txqantl ijaj pon chitj kyxol txꞌiꞌx; ex ul kyeꞌ kywiꞌ. Me noq i jaw xkyꞌiꞌsix, quꞌn tuꞌn bꞌeꞌx i xi bꞌaj kyxoljo kꞌul, a at kytxꞌiꞌxil. ");
INSERT INTO mamC_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Me at txqantl pon chitj tojjo tbꞌanil txꞌotxꞌ. Tbꞌanilpen chꞌiꞌye teꞌ, ex nimxjo twutz kyij, bꞌalaqa junjunchaq jweꞌ kꞌal twutzjo junjun ijaj. Tbꞌajlinxitzin tqꞌmaꞌn Jesúsjo techil lo, jawtzin yolin juntl majl kujxix wen. Chiꞌ kyjaluꞌn: Ankye taj tuꞌn tkubꞌ tbꞌiꞌn nyola, in tkubꞌ tbꞌiꞌntz, tuꞌntzintla tkubꞌ tbꞌinchin. ");
INSERT INTO mamC_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Me ayetzin kyej t-xnaqꞌtzbꞌin Jesús, bꞌeꞌxkux xi kyqanin kyeꞌ, tzeꞌn tzꞌelpineꞌ techil, a otaq bꞌaj tyolin kyxol. ");
INSERT INTO mamC_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ajo techil, iky tzꞌelpine teꞌ kyjaluꞌn, chi Jesúsjo: Ajo tumil, a ewintaq tiꞌjxi Tkawbꞌil qMan Dios, o tzꞌel kynikyꞌa te, quꞌn tuꞌn aku Dios o tzaj yekꞌinte kyeꞌy. Me ayetzin kyeꞌ txqantl, a naꞌmx tel kynikyꞌ te, il tiꞌj tuꞌn nyoliꞌn kye kyukꞌa techil, tuꞌntzintla aj nbꞌaj yoliꞌn, ajo otaq kyli, me mina s-el kynikyꞌ te; exsiꞌn ajo otaq kybꞌi, mi n-okx toj kywiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ajo techil, a ma bꞌaj qꞌmet, antza nyoline teꞌ tiꞌjjo Tyol qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Atziꞌn ijaj, a xpon chitj toj bꞌe, antza nyoline teꞌ kyiꞌjjo xjal, a nchi bꞌin tiꞌj Tyol qMan Dios, me liwey n-ul kanin tajaw il najsilte toj kyanmin, tuꞌntzintla mina txi kynimin, ex mina chi klet. ");
INSERT INTO mamC_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Atzin teꞌ ijaj, a xpon chitj kyxol abꞌj, antza nyoline teꞌ kyiꞌjjo xjal, a nchi bꞌin tiꞌj Tyol qMan Dios. Nxi kynimin tukꞌa tkyaqil kyajbꞌil, me ajo kynimbꞌil ntiꞌxix tkujil, ex noq te jteꞌbꞌin qꞌij, tuꞌntziꞌn bꞌeꞌx nchi jaw tzꞌaq toj kynimbꞌil, tzeꞌnku ntzaj jun mibꞌin toj kychwinqil. ");
INSERT INTO mamC_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Atzin teꞌ ijaj, a xpon chitj kyxol txꞌiꞌx, antza nyoline teꞌ kyiꞌjjo xjal, a nchi bꞌin tiꞌjjo Tyol qMan Dios, me liwey nchi tzaj numj toj kynimbꞌil tuꞌnjo t-xim kyanmin nya jikyin. Atku tuꞌn tpajjo qꞌinimil, ex atku noq tuꞌn tpajjo achbꞌil, a at twutz txꞌotxꞌ, tuꞌntziꞌn mina nchi wutzin toj kychwinqil. ");
INSERT INTO mamC_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Me atzin teꞌ ijaj, a xpon chitj toj tbꞌanil txꞌotxꞌ, antza nyoline teꞌ kyiꞌjjo xjal, a tbꞌanilxjo kyanmin ex at-xixjo kyajbꞌil tuꞌn kybꞌin ex tuꞌn tkubꞌ kybꞌinchiꞌn a ntqꞌmaꞌn Tyol qMan Dios. Tuꞌntziꞌn, jikyinxix iteꞌye toj kynimbꞌil, ex tbꞌanilxjo kywutz n-el toj kychwinqil, chi Jesúsjo kye. ");
INSERT INTO mamC_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yolin Jesús tiꞌjjo juntl techil lo: Mix aꞌl jun te xjal aku tzꞌok txqonte jun tzaj, tuꞌntzintla at spikyꞌin tuja, exsin liwey tuꞌn tkubꞌ tmaqsiꞌnl, mo tuꞌn tokx tqꞌoꞌnl tjaqꞌ jun watbꞌil. Qalaꞌ k-okil txqet jun te tzaj, exsin tuꞌn tjax qꞌoyit twiꞌ jun xtankoꞌl, tuꞌntzintla spikyꞌin te kyeꞌ, a nchi okxik tuja. Ex ikyxjo ajo nyola nlay bꞌant tuꞌn tmaqet. ");
INSERT INTO mamC_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ntiꞌx jun te tiꞌ mina tzꞌel tqanil, qalaꞌ ikytzin ilx tiꞌj tuꞌn tkubꞌ chikyꞌbꞌit. Ikytzin Tyol Dios; te tnejil mina n-eltaq kynikyꞌa te, me atzin jaꞌlin loqiꞌn nchin xnaqꞌtzin kyiꞌja, tuꞌn tel ẍtileꞌ toj kynabꞌla tzeꞌnku tqan tzaj. Tuꞌntzin ikyjo, ntiꞌx jun tiꞌ aku bꞌant tuꞌn tewit. ");
INSERT INTO mamC_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tuꞌnpetziꞌn, kykaꞌyinktzin kyibꞌa. Quꞌn tkyaqiljo, a nim n-ok tilil Tyol Dios tuꞌn, kyja kxela qꞌoyit txqantl tnabꞌl, tuꞌn tel tnikyꞌ tiꞌj tkyaqil. Me ankye teꞌ ntiꞌ n-ok tqꞌoꞌn tilil, majxpe ajo tnabꞌl, a tbꞌanilx toj twutz, me a ntiꞌ tumil, k-elil qꞌiyit te jun majx. ");
INSERT INTO mamC_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tzuntaq nyolin Jesús ikyjo, tej tpon kanin tnana exqetziꞌn titzꞌin antza, me mix i pon laqꞌeyexix tkꞌatz, quꞌn tuꞌn ma nintzxtaq xjal at. ");
INSERT INTO mamC_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tuꞌntziꞌn, noq xi qꞌmaꞌn te kyjaluꞌn: Lu tej tnaniy exqetziꞌn titzꞌin iteꞌ peꞌn, ex kyaj tuꞌn kyyolin tukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Atzin te Jesús xi ttzaqꞌwin kyjaluꞌn: A wejiꞌy nnana ex aye wejiꞌy witzꞌin ayeꞌ nchi bꞌin, ex nkubꞌ kybꞌinchin a ntqꞌmaꞌn Tyol qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jun majjo ikyjo, okx Jesús exqetziꞌn t-xnaqꞌtzbꞌin toj jun bark, exsin xi tqꞌmaꞌn kye kyjaluꞌn: Qo ikyꞌx tzma tjlajxi nijabꞌ, chiꞌ. Ex bꞌeꞌxsin i xiꞌtz. ");
INSERT INTO mamC_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ex tzmataq nchi bꞌet tibꞌaj aꞌ, bꞌeꞌx ikyꞌ ktan Jesús. Ex bꞌeꞌx ok ten txqan kyqꞌiqꞌ jumil tibꞌajileꞌ nijabꞌ anetziꞌn, ex atzin tej bark kyjaꞌtaq tnoj teꞌ tuꞌn aꞌ. Ex tuꞌn ikyjo, chꞌixtaq t-xi mulqꞌaj toj nijabꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tuꞌntziꞌn, bꞌeꞌx okx kꞌasin kyuꞌn t-xnaqꞌtzbꞌin, ex xi kyqꞌmaꞌn te kyjaluꞌn: ¡Xnaqꞌtzil! ¡Xnaqꞌtzil! Chꞌix qxi mulqꞌaj. Bꞌeꞌx jaw weꞌks Jesús, exsin xi tmiyoꞌntz kyqꞌiqꞌ exsiꞌn tipin aꞌ, a tzunxtaq jaw mayiyin, ex noq tuꞌnjo tyol, bꞌeꞌx i kubꞌ qen, ex jotx kubꞌ nume. ");
INSERT INTO mamC_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tbꞌajlinxitziꞌn ikyjo, xitzin tqꞌmaꞌn Jesús kyeꞌ t-xnaqꞌtzbꞌin kyjaluꞌn: ¿Jaꞌtzin saqꞌekuꞌ kynimbꞌila? Ayetzin kyej t-xnaqꞌtzbꞌin otaq chi xobꞌ, ex i jaw kaꞌylaj. Tuꞌntziꞌn, jaw qanlaj kyxolx kyjaluꞌn: ¿Alxsila kye xjal ikyjo? A ajin kyqꞌiqꞌ ex aꞌ ma kubꞌ niminte. ");
INSERT INTO mamC_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","I pontzin tojjo txꞌotxꞌ te Gerasa, a at tjlajxi nijabꞌ, ttxlaj Galiley. ");
INSERT INTO mamC_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Noqxix nkuꞌtzku Jesús toj bark, tej tpon laqꞌe jun ichin tkꞌatz, a antza etza kyxolxjal toj tnam. Atziꞌn ichin anetziꞌn, iteꞌtaq taqꞌnil tajaw il toj tanmin ilaꞌxitaq abꞌqꞌe. Minataq nchi ok tqꞌoꞌnjo t-xbꞌalin, ex nya toj jun ja najletaq; qalaꞌ antza n-anqꞌinetaq toj muqbꞌil kyimnin. ");
INSERT INTO mamC_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Atzaj teꞌ tiwle Jesús tuꞌn, bꞌeꞌx kubꞌ meje twutz, exsin jaw ẍchꞌintz kujxix wen kyjaluꞌn: ¿Tiꞌ taja wiꞌja, ay Jesús, a Tkꞌwaljo Dios nimxix toklin? Chin kubꞌsil nwutza tey, tuꞌn mina chin kubꞌ tyajinxa. ");
INSERT INTO mamC_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tqꞌma xjaljo yol lo, quꞌn bꞌijte Jesús tej t-xi tqꞌmaꞌn kyej taqꞌnil tajaw il, qa iltaq tiꞌj tuꞌn kyetz toj tanminjo xjal anetziꞌn. Ojtxetaq ttzyetla kyuꞌn taqꞌnil tajaw il. Mix tuꞌn otaq chi kꞌletjo tqꞌobꞌ exqetziꞌn tqan kyukꞌa kxbꞌil kyuꞌnxjal, tuꞌntzintla mina tzaqpaje. Me bꞌeꞌx nchi laqjtaqjo kxbꞌil tuꞌn, tuꞌn kyipin taqꞌnil tajaw il. Ex ayejo taqꞌnil tajaw il nxi qꞌintetaq tojjo txꞌotxꞌ jaꞌ ntiꞌye kynajbꞌilxjal. ");
INSERT INTO mamC_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Xitzin tqanin Jesús tej ichin kyjaluꞌn: ¿Titzin tetza tbꞌi? Tzajtzin ttzaqꞌwin tej ichin kyjaluꞌn: Ilaꞌku weꞌ nbꞌi. Xi tqꞌmaꞌn ikyjo quꞌn tuꞌn nimxtaq taqꞌnil tajaw il otaq chi okx toj tanmin. ");
INSERT INTO mamC_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ayeꞌ taqꞌnil tajaw il lo, i kubꞌsin kywutz te Jesús, tuꞌntzintla mina chi xi xoꞌne toj ma tij jul, a jaꞌla taꞌyile t-xela. ");
INSERT INTO mamC_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Me quꞌn tuꞌn iteꞌtaq txqan kuch nchi waꞌntaq twiꞌ wutz, xitzin kyqaniꞌn taqꞌnil tajaw il te Jesús, tuꞌntzintla t-xi tqꞌoꞌn ambꞌil kye, tuꞌn kyokx kyojjo kye kuch. Xitzin tqꞌoꞌn Jesús ambꞌil kye. ");
INSERT INTO mamC_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Texjo or anetziꞌn, bꞌeꞌx i etz kyej taqꞌnil tajaw il toj tanminjo ichin anetziꞌn, ex bꞌeꞌxsin i okxtz kyojileꞌ kuch, a iteꞌtaq. Ayetzin kyej kuch bꞌeꞌx i xi tilj kyeꞌ kubꞌl, ex atzaj teꞌ kykupin, bꞌeꞌxsin xi kyxoꞌn kyibꞌtz tojjo nijabꞌ, ex antza bꞌeꞌx i jiqꞌwe. ");
INSERT INTO mamC_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Atzaj teꞌ tiwle lo kyuꞌnxjal, a nchi kyikꞌlentaq kyiꞌj kuch, bꞌeꞌxsin i kubꞌtz toj bꞌe yolilte kyeꞌ xjal, a iteꞌtaq toj tnam ex kyojjo jniꞌ kojbꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bꞌeꞌxsin i bꞌajetz kyej xjal lolte qa twutzxtaqjo otaq kybꞌi. Ex atziꞌn teꞌ kykanin tkꞌatz Jesús, iwleꞌ ichin kyuꞌn, aj otaq chi etz taqꞌnil tajaw il toj tanmin. Atzaj ichin anetziꞌn qꞌuqletaq t-xe tqan Jesús; iteꞌktaq t-xbꞌalin, ex otaq tzul spikyꞌeꞌ toj twutz. Tuꞌn ikyjo, bꞌeꞌx tzaj kyej xjal kyxobꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bꞌeꞌx tzyet tej lo tqꞌumle kyuꞌnj xjal i lonte, tzeꞌn tten tqꞌanitj ichin anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tej tbꞌijtej lo kyuꞌnxjal, a iteꞌtaq tojjo txꞌotxꞌ te Gerasa, nimx kyxobꞌil tzaj. Tuꞌn ikyjo, kykyaqilx i xiꞌ kubꞌsil kywutz te Jesús, tuꞌntzintla tex tojjo kytanim. Okxsin Jesús toj bark, ex bꞌeꞌx ikyꞌ antza. ");
INSERT INTO mamC_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Me naꞌmtaq tikyꞌ, atzin te ichin, a otaq chi etz taqꞌnil tajaw il toj tanmin, kubꞌsin teꞌ twutz, tuꞌn t-xi lipe tiꞌj Jesús, me mix ttziye te Jesús. Tzajtzin qꞌmaꞌntz te kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Kux meltzꞌaja tjay, ex qꞌmanxjiy tkyaqiljo a ma tbꞌinche Dios tiꞌja. Kutzin, chtej ichin. Bꞌeꞌxsin xiꞌtz, exsin ok tentz yolilte te kykyaqil xjal, a najleqetaq toj tnam, jotxjo a otaq tbꞌinche Jesús tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Atzaj teꞌ tmeltzꞌaj Jesús tjlajxi nijabꞌ, tzuntaq chi yonxjal tiꞌj, ex tzaj kykꞌmoꞌn tukꞌa tzaljbꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tzuntaq nbꞌajjo ikyjo, tej tpon kanin jun ichin tkꞌatz Jesús, Jayr tbꞌi, nejinel tojjo muꞌẍ ja te kynaꞌbꞌl Dios aj Judiy. Atzin tej ichin anetziꞌn bꞌeꞌx kubꞌ meje t-xe tqan Jesús, exsin kubꞌsin twutz, tuꞌntzintla t-xiꞌ Jesús tzmax tja, ");
INSERT INTO mamC_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","quꞌn tuꞌn chꞌixtaq tkyimjo jun tkꞌwal txin, a junchꞌinxtaq, bꞌalaqa te kabꞌlajaj tabꞌqꞌe. Tzmataq nbꞌet Jesús, tuꞌn tkanin tja Jayr, tej tok jitzꞌle kyxolxjal, quꞌn tuꞌn nimxtaq xjal lipcheqetaq tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kyxoljo xjal, a lipcheqetaq tiꞌj Jesús, attaq jun qya, a otaq bꞌant-xiꞌ kabꞌlajaj abꞌqꞌe ttzyetlin tukꞌa kyyabꞌilqya, ex mix jaꞌ nqenetaq. Ex tuꞌn ikyjo, otaq xbꞌaj tyajiꞌn tibꞌ kyukꞌa qꞌanil, ex otaq bꞌaj tyupin jniꞌ attaq te, te twiꞌ tqꞌanbꞌil, me mix aꞌltaq otaq qꞌaninte. ");
INSERT INTO mamC_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tzaj lipexi tej qya lo tiꞌjxi Jesús, exsin ok ttzyuꞌn ttxaꞌn t-xbꞌalin. Ex noq tuꞌn ikyjo, bꞌeꞌx qeꞌn tyabꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Xitzin tqanin Jesús kyjaluꞌn: ¿Ankyeꞌ ma tzꞌok mekoꞌn weꞌy? chiꞌ. Quꞌn tuꞌn mix aꞌl xi tzaqꞌwinte, xitzin tqꞌmaꞌn Pegr kyjaluꞌn: Taa, mix aꞌlte ma tzꞌok tzyunte, qalaꞌ tuꞌn nim xjal lipche; tuꞌntziꞌn, bꞌeꞌx nchi ok aqꞌle tiꞌja, expe bꞌeꞌx nxi limoꞌn kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Me kubꞌ tqꞌmaꞌnl Jesús kabꞌel tyol. Chiꞌ kyjaluꞌn: Ma tzꞌel nnikyꞌa te, qa at jun aꞌla ma tzꞌok tzyun weꞌy, quꞌn noq tuꞌn wipiꞌn ma qꞌaniteꞌ xjal anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kubꞌtzin t-ximin tej qya, a qa nlay tzꞌewittaq. Tuꞌn ikyjo, bꞌeꞌx tzaj laqꞌe tkꞌatz Jesús luꞌlin wen tuꞌn t-xobꞌil, ex bꞌeꞌx kubꞌ meje t-xe tqan. Kubꞌtzin tpaꞌntz kyxolxjal tiquꞌnil ok ttzyuꞌn t-xbꞌalin Jesús, ex kubꞌ tqꞌmaꞌntz, qa bꞌeꞌx qꞌanitku texjo paq anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Xitzin tqꞌmaꞌn Jesús tej qya kyjaluꞌn: Nkꞌwal, axjo tnimbꞌila ma kubꞌ qꞌanin tey. Kuxsin txiꞌtza jaꞌlin tukꞌa tzaljbꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tzunxtaq yolin Jesús ikyjo, tej tul kanin jun xjal qꞌolte jun tqanil te Jayr, aj nejinel tojjo muꞌẍ ja te kynaꞌbꞌl Dios Judiy, exsin xi tqꞌmaꞌn kyjaluꞌn: Taa, ma kyim te tkꞌwal. Mi tzꞌok ila tiꞌj xnaqꞌtzil jaꞌlin. Mi txi tkꞌleꞌnla tjay. ");
INSERT INTO mamC_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Me bꞌeꞌx bꞌij teꞌ lo tuꞌn Jesús, exsin xi tqꞌmaꞌntz te Jayr kyjaluꞌn: Mina tzaj xobꞌa, oꞌkx qe tkꞌuꞌja wiꞌja, ex ok kqꞌanitil te tkꞌwal, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Atzaj teꞌ tkanin Jesús tja Jayr, mix ttziye tuꞌn kyokx kykyaqil xjal tukꞌa; qalaꞌ oꞌkxjo ttata ex tnanaj txin tukꞌax Pegr tukꞌa Santyaw exsin Juan. ");
INSERT INTO mamC_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tej kyokx tuja, kykyaqilxjal tzuntaq nchi oqꞌ tuꞌn bꞌisbꞌajil tiꞌjjo tal txin, a otaq kyim. Me atzin te Jesús xi qꞌmante kye kyjaluꞌn: Mina chi oqꞌ kyeꞌ, quꞌn nya ma kyim tetxin, qalaꞌ luꞌ noq nktan. ");
INSERT INTO mamC_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Noqx i bꞌaj jaw tzeꞌn jniꞌ xjal tiꞌjjo tyol Jesús ikyjo, quꞌn tuꞌn otaq tzꞌiwleꞌ txin kyuꞌn, a qa otaq kyim. ");
INSERT INTO mamC_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Me atzin te Jesús, xiꞌ teꞌ tzyulte tqꞌobꞌjo txin, exsin jaw tiꞌn tqꞌajqꞌojil twiꞌ. Chiꞌ kyjaluꞌn: ¡Weꞌksa, txin! ");
INSERT INTO mamC_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bꞌeꞌxsin jaw anqꞌin juntl majl tej txin, ex texjo paq anetziꞌn bꞌeꞌx jaw weꞌks. Xitzin tqꞌmaꞌn Jesús tuꞌn t-xi qꞌoꞌn twa. ");
INSERT INTO mamC_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bꞌeꞌx i jaw kaꞌylaj kyej ttata kꞌwal tuꞌn ikyjo, me bꞌeꞌx xi qꞌmaꞌn kye tuꞌn Jesús, tuꞌn mix alqeye, tuꞌn t-xi kyqꞌmaꞌne tkyaqilxjo otaq bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","I ok tchmoꞌn Jesúsjo kabꞌlajaj t-xnaqꞌtzbꞌin, exsin xi tqꞌoꞌn kyoklin te kawil, ex xi tqꞌoꞌn kyipin tuꞌn kyetzjo jniꞌ tkyaqil wiq taqꞌnil tajaw il toj kyanminxjal kyuꞌn, exsiꞌn jniꞌqe yabꞌ tuꞌn kyqꞌanit. ");
INSERT INTO mamC_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Exsin i xi chqꞌoꞌntz tuꞌn Jesús tuꞌn kyxiꞌ yolil teꞌ Tkawbꞌil qMan Dios, ex tuꞌn kyqꞌanin kyiꞌjjo jniꞌ yabꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Chiꞌ kyjaluꞌn: Ntiꞌ chꞌin kyeꞌ tuꞌn t-xi kyiꞌn, a il tiꞌj tuꞌn tajbꞌin toj kybꞌeꞌy; mina txi kyiꞌn kye kytze, kychꞌuꞌẍa ex wabꞌj, ex mina txi kyiꞌn kyeꞌ pwaq, nipe jun xbꞌalin te txꞌixpil kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ex aꞌlchaqx kye jatz jaꞌ chi pon kaniniꞌy ajlal, axsa chi tenkuy, tzmaxi kꞌaꞌ chi etzjiꞌy toj, ajxi kyxiꞌy toj junxil tnam, chi Jesús kye. ");
INSERT INTO mamC_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Me metziꞌn, aj qa at jun tnam, a jaꞌ kykyꞌeꞌyexjal kyiꞌja, bꞌeꞌx kꞌaꞌ chi etza antza. Me bꞌeꞌx kꞌaꞌ tzꞌel kychtoꞌn quq tiꞌj kyqaꞌn kywutzjo xjal tojjo tnam anetziꞌn, tuꞌn tajbꞌin te techil kye, tuꞌn mina xkubꞌ kybꞌiꞌn Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bꞌeꞌxsin i xiꞌ kyej t-xnaqꞌtzbꞌin Jesús tojile junjun kojbꞌil, qꞌmal teꞌ Tbꞌanil Tqanil kolbꞌil kyexjal, ex tuꞌn kyqꞌanitjo jniꞌ yabꞌ kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jotxjo a nyolajtztaq tiꞌj Jesús, ex tiꞌj tkyaqiljo nbꞌanttaq tuꞌn. Bꞌeꞌx bꞌijte teꞌ tuꞌn Herodes, a nmaq kawiltaq, me mix elexix tnikyꞌ te, quꞌn ilaꞌtaq nqꞌmante a qa ataq Juan, a Jawsil Aꞌ, otaq jatz itzꞌje juntl majl. ");
INSERT INTO mamC_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ex iteꞌtaqtl nchi qꞌmante a qa ataqj Elías, a yolil Tyol Dios, otaq tzul juntl majl. Me iteꞌtaq nchi qꞌmante a qa jun qtzan yolil Tyol Diosjo otaq jaw anqꞌin juntl majl. ");
INSERT INTO mamC_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Me atzin te Herodes iky teꞌ tqꞌma kyjaluꞌn: Nyatel te Juan, a Jawsil Aꞌ, quꞌn ayinku weꞌ in xi qꞌmante, tuꞌn tel txꞌemit teꞌ twiꞌ. ¿Me altzila kyeꞌ xjaltz, a nimku nqꞌumlajtz tiꞌj? Tuꞌn ikyjo, ok tqꞌoꞌn Herodes tilil, tuꞌntzintla tiwle Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Atzaj teꞌ kymeltzꞌajjo t-xnaqꞌtzbꞌin Jesús, bꞌeꞌx i ok ten qꞌmalte te Jesús jniꞌ otaq bꞌaj kybꞌinchin. Bꞌeꞌxsin i xi qꞌiꞌntz kyjunalx, tuꞌn kypon kanin tojjo jun najbꞌil, Betsaida tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Me atzaj teꞌ kybꞌinte txqantl xjal, qa otaq cheꞌx Jesús kyukꞌa t-xnaqꞌtzbꞌin tzma Betsaida, bꞌeꞌxsin i xi lipetz kyiꞌj. I kubꞌ tziyin tuꞌn Jesús tej kykanin; xi chikyꞌbꞌin Tkawbꞌil qMan Dios kye, ex i kubꞌ tqꞌanin jniꞌ yabꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Atzaj teꞌ kyjaꞌtaq qok yupj, bꞌeꞌxsin i xi laqꞌe kabꞌlajaj t-xnaqꞌtzbꞌin tkꞌatz Jesús, exsin xi kyqꞌmaꞌn te kyjaluꞌn: Chqꞌonqexjiy xjal lo kyojileꞌ jniꞌ kojbꞌil a nqayin iteꞌ, tuꞌntzintla kyjyon kywa, ex tuꞌn kyjyon teꞌ jaꞌ tuꞌn kyktane, quꞌn tuꞌn ntiꞌx chꞌin te at tzaluꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Xitzin ttzaqꞌwin Jesús: Kyqꞌonxa kywa. Me ayetzintljo t-xnaqꞌtzbꞌin xi kytzaqꞌwin kyjaluꞌn: Ntiꞌ qe wabꞌj qꞌiꞌn quꞌn, oꞌkxjo jweꞌ tal wabꞌj exsin kabꞌe tal netzꞌ kyiẍ. ¿Ma man qoꞌxtza laqꞌolte txqantl wabꞌj te tkyaqiljo xjal lo? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Attaq jun jweꞌ mil ichin antza. Me chi Jesúsjo kye t-xnaqꞌtzbꞌin kyjaluꞌn: Kyqꞌmanxa kyexjal tuꞌn tok kychmoꞌn kyibꞌ toj chꞌuqin, lajaj toj ox kꞌal tuꞌn tten toj junjun chꞌuq, ex tuꞌn kykubꞌ qe. ");
INSERT INTO mamC_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jotx xjal i bꞌaj kubꞌ qe, tzeꞌnxjo xi qꞌmaꞌn kye kyuꞌnjo t-xnaqꞌtzbꞌin Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Texjo paq anetziꞌn, i jaw ttzyuꞌn Jesúsjo jweꞌ tal wabꞌj exqetziꞌn kabꞌe tal netzꞌ kyiẍ, jaw tiꞌn twutz jawl, exsin xi tqꞌoꞌn chjonte te Dios kyiꞌj. Atzaj teꞌ tbꞌaj naꞌn Dios, bꞌeꞌxsin i kubꞌ tpiẍin tal wabꞌj, exsin i xi tqꞌoꞌntz kyeꞌ t-xnaqꞌtzbꞌin, tuꞌntzintla tkubꞌ kysipin kye tkyaqilxjal. ");
INSERT INTO mamC_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jotxjo xjal bꞌaj noj kykꞌuꞌj, quꞌn tuꞌn nimx kywa bꞌaj. Me atzaj teꞌ kybꞌaj waꞌn, kabꞌlajaj chiꞌljo tbꞌuchil wabꞌj chmet. ");
INSERT INTO mamC_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jun majjo ikyjo, tjunalxtaq Jesús at kyukꞌa t-xnaqꞌtzbꞌin; naꞌn Dios nej, exsin xi tqanin kyeꞌ t-xnaqꞌtzbꞌin. Chiꞌ kyjaluꞌn: ¿Ankyeqiꞌn toj kywutzjo jniꞌ xjal? ");
INSERT INTO mamC_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Xitzin kytzaqꞌwin t-xnaqꞌtzbꞌin kyjaluꞌn: At junjun nqꞌmaꞌnte qa ajiy qtzan Juan, a Jawsil Aꞌ; at junjuntl nqꞌmaꞌnte qa ajiy Elías, a yolil Tyol Dios ojtxe. Ex at junjuntl nqꞌmaꞌnte qa ajiy jun yolil Tyol Dios jaw itzꞌje juntl majl. ");
INSERT INTO mamC_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","¿Yajtzin kye toj kywutz? ¿Ankyeqiꞌn? Ate Pegr xi tzaqꞌwinte kyjaluꞌn: A tejiy Crist, a skꞌoꞌnxix tuꞌn Dios, tuꞌn tul tzaluꞌn twutz txꞌotxꞌ, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tbꞌajlinxiꞌ ikyjo, xi oqxeninxix kye tuꞌn Jesús, tuꞌn mix alqeye tuꞌn t-xi kyqꞌmaꞌne qa ate Jesúsjo Crist. ");
INSERT INTO mamC_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Xi tqꞌmaꞌn kye t-xnaqꞌtzbꞌin kyjaluꞌn: Ayiꞌn, a Tkꞌwal Ichin, ilxix tiꞌj tuꞌn tikyꞌx nim yajbꞌil wuꞌn, ex ok kchin elil iꞌjliꞌn kyuꞌn kynejilxjal ex kyuꞌn kynejil pale junx kyukꞌa tkyaqil xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Ok kchin kꞌwel bꞌyoꞌn kyuꞌn, me toj toxin qꞌij ok kchin jawitz anqꞌintla juntl majl. ");
INSERT INTO mamC_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xitzin tqꞌmaꞌn kye kykyaqilx: Ankye jun taj tuꞌn tok te nxnaqꞌtzbꞌiꞌn, il tiꞌj tuꞌn tel tiꞌn toj tkꞌuꞌj tkyaqil tajbꞌil, ex tuꞌn t-xi tqꞌoꞌn tibꞌ tuꞌn t-xi lipe wiꞌja tkyaqil qꞌij, exla qa ma kyim twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ikytziꞌn, alkye taj noq tuꞌn tkubꞌ tbꞌinchin tajbꞌil tzaluꞌn twutz txꞌotxꞌ, kxeꞌl toj najin te jun majx. Ex alkye kꞌwel ttzyuꞌn tibꞌ tiꞌj tkyaqiljo at tajbꞌin kyexjal tzaluꞌn twutz txꞌotxꞌ, noq tuꞌn npaja, ktenbꞌil tchwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Quꞌn tiꞌxsila tajbꞌin tuꞌn tkanbꞌit tkyaqiljo ajbꞌil tzaluꞌn twutz txꞌotxꞌ, exsin tuꞌn tnaj tanmin? ");
INSERT INTO mamC_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tuꞌnpetziꞌn, qa at jun saj txꞌixwe wiꞌja ex tiꞌjjo nyola, ex ikyx wejiꞌy, ayiꞌn Tkꞌwal Ichin, ex ok kchin tzajil txꞌixwe weꞌ te, aj wula tukꞌa nkawbꞌila ex tukꞌa tqoptzꞌajiyil nMaꞌn junx kyukꞌa jniꞌ xjan angel. ");
INSERT INTO mamC_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Twutzxix kxel nqꞌmaꞌn kyeꞌy, at junjun iteꞌ tzaluꞌn wukꞌiy, mi kyli kyimin, tzmaxi aj kylonte Tkawbꞌil Dios tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Otaqxi bꞌaj wajxaq qꞌij, tej tjax Jesús naꞌl Dios twiꞌ jun wutz; lipcheqektaq Pegr, Santyaw ex Juan tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tzmataq nnaꞌn te Jesús Dios, tej ttxꞌixpit tkaꞌybꞌil twutz, exsin ajo t-xbꞌalin ox qoptzꞌajx wen. ");
INSERT INTO mamC_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Texjo paq anetziꞌn, i kubꞌ kyyekꞌin kyibꞌ kabꞌe ichin nchi yolintaq tukꞌa Jesús, a Moisés ex Elías. ");
INSERT INTO mamC_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tzunxtaq nqoptzꞌaj kyiꞌjile ichin anetziꞌn, tej kyok ten yolil tiꞌjjo tkyimlin Jesús, a tuꞌntaq tbꞌaj toj Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nimxtaq te Pegr twatl at, exqetziꞌn tukꞌa. Me mix ikyꞌe ktane; tuꞌntziꞌn iwle tqoptzꞌajiyil Jesús kyuꞌn, exsin kyspikyꞌimiljo kabꞌe ichin, a iteꞌtaq tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Atzaj teꞌ kyjaꞌtaq tel kypaꞌn kyibꞌjo kabꞌe ichin tiꞌj Jesús, xitzin tqꞌmaꞌn Pegr kyjaluꞌn: ¡Ay Xnaqꞌtzil, tbꞌanilx teꞌ tuꞌn otoꞌ tzaluꞌn! Kꞌaꞌ kubꞌ qbꞌinchiꞌn oxe tal pach; jun te, ex jun te Moisés, ex jun te Elías. Me mix ele te Pegr tnikyꞌ tiꞌjjo a otaq txi tqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tzmataq nyolin Pegr, tej tkubꞌ juktzꞌaj jun muj kyibꞌaj. Tuꞌntziꞌn, nimx kyxobꞌil tzaj. ");
INSERT INTO mamC_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tojjo muj anetziꞌn, etz yolin jun tqꞌajqꞌojil, ex tqꞌma: Axixpen wejiꞌy Nkꞌwal lo, skꞌoꞌnxix wuꞌn. Kybꞌinkujiꞌy Tyol. ");
INSERT INTO mamC_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tej tbꞌaj kybꞌiꞌn yol, a etz qꞌmaꞌn toj muj, iwle Jesús kyuꞌn, ex kyli qa tjunalxtaq waꞌl. Ntiꞌ chꞌin i jaw yolin, ex mix aꞌl qe xi kyqꞌmaꞌne tiꞌjjo otaq kyli. ");
INSERT INTO mamC_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tojxi junxil qꞌij i meltzꞌaj twiꞌ wutz. Atzaj teꞌ kykuꞌtzku, nimx xjal i bꞌajetz kꞌlulte Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kyxoljo xjal anetziꞌn, attaq jun te ichin jaw yolin kujxix wen. Chiꞌ kyjaluꞌn: Ay Xnaqꞌtzil, bꞌinchim t-xtalbꞌila, qꞌaninkujiy tal nkꞌwala lo, noq tuꞌn oꞌkx wejiꞌy tal nkꞌwal junchꞌin: ");
INSERT INTO mamC_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jun taqꞌnil tajaw il ma bꞌinchin tiꞌjjo tal nkꞌwala; tuꞌntziꞌn, tzunx nẍchꞌinx wen, ex n-etz plut toj ttzi tzeꞌnku ntzaj kyimin tiꞌj. Tuꞌn ikyjo, nimx ma kyꞌixbꞌe tal nkꞌwala tuꞌn, ex ntiꞌx tumil tuꞌn ttzaqpaj. ");
INSERT INTO mamC_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nimx ma chin kubꞌsin nwutza kye t-xnaqꞌtzbꞌiꞌn, tuꞌntzintla tetz kyiꞌn taqꞌnil tajaw il, me naꞌmx tetz kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Xitzin ttzaqꞌwin Jesús kye t-xnaqꞌtzbꞌin kyjaluꞌn: Ayiꞌy xjal ntiꞌ kynimbꞌila, ex ntiꞌ kyumila. ¿Jteꞌxsin qꞌij nkubꞌlin teꞌn kyxola? ¿Ex jteꞌxsin qꞌij kkyꞌelix wuꞌn kyukꞌiy? Kyintzinjiꞌy qꞌa tzaluꞌnch. ");
INSERT INTO mamC_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Atzaj teꞌ t-xi laqꞌe tal kꞌwal tkꞌatz Jesús, bꞌeꞌx pon tolpaj juntl majl tuꞌn tipin taqꞌnil tajaw il, ex bꞌeꞌx tzaj jun majljo kyimin tiꞌj. Me ante Jesús bꞌeꞌx xi tmiyoꞌn tipin taqꞌnil tajaw il. Tuꞌntziꞌn, bꞌeꞌx qꞌanit tej kꞌwal anetziꞌn, exsin xi qꞌoꞌntz te ttata. ");
INSERT INTO mamC_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jotx i bꞌaj jaw kaꞌylaj tuꞌn tipin qMan Dios antza. Tzunxtaq nchi labꞌtexjal antza tiꞌjjo a nbꞌanttaq tuꞌn Jesús, xitzin tqꞌmaꞌn Jesús kye t-xnaqꞌtzbꞌin kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Kybꞌinkutzinjiꞌy a kxel nqꞌmaꞌn kyeꞌy, ex mina tuꞌn tel naj toj kykꞌuꞌja: Ayin wejiꞌy, a Tkꞌwal Ichin, me ok kchin xel qꞌoꞌn toj kyqꞌobꞌxjal tuꞌn nkyima, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Me mix ele kynikyꞌjo t-xnaqꞌtzbꞌin teꞌ a otaq bꞌaj tqꞌmaꞌn Jesús kye, quꞌn tuꞌn axtaq te Dios otaq tzꞌok jpunte kynabꞌl, tuꞌn minataq tzꞌele kynikyꞌ te. Ex nimx kyxobꞌil tzaj tuꞌn t-xi kyqanin juntl majl, tzeꞌn chi elpineꞌ yol anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Texjo paq anetziꞌn, bꞌeꞌx i ok ten kyej t-xnaqꞌtzbꞌin Jesús chꞌotjil kyxolile, quꞌn kyajtaq tuꞌn kybꞌinte alkyexixjo nimxixtl toklin kyxol. ");
INSERT INTO mamC_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Me atzaj teꞌ tel tnikyꞌ Jesús tiꞌjjo nbꞌajtaq kyxol, tzaj tkꞌleꞌn jun kꞌwal, exsin kubꞌ twaꞌbꞌintz kyxol, ");
INSERT INTO mamC_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","exsin xi tqꞌmaꞌn kye: Ankye jun kxel kꞌmonte jun tal qꞌa tzeꞌnku lo noq tuꞌn tnimbꞌil tiꞌj nbꞌiꞌy, nya oꞌkxjo tal qꞌa kxel tkꞌmoꞌn, qalaꞌ ayiꞌn. Ex alkyeꞌ kxel kꞌmon weꞌy, nya oꞌkqinxa chin xel tkꞌmoꞌn, qalaꞌ majxjo Dios, a saj chqꞌon weꞌy. Tuꞌnpetziꞌn, alkye nya nim chꞌin toklin kyxola toj kywutza, apente nimxix toklin, chiꞌ Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Atzin te Juan xi tqꞌmaꞌnl kyjaluꞌn: Xnaqꞌtzil, o qli qeꞌ jun xjal, a nchi etzjo jniꞌ taqꞌnil tajaw il toj kyanminxjal tuꞌn, noq toj tumil tbꞌiy. Me o txi qmiyoꞌn tuꞌn mina kubꞌ tbꞌinchintl, quꞌn tuꞌn nya qukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Mina txi kymiyoꞌn kyeꞌ, quꞌn atziꞌn luꞌn nya qiꞌjbꞌinxi taꞌ, qukꞌa taꞌ teꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Atzaj teꞌ chꞌixtaq tul kanin qꞌij, jaꞌ tuꞌn taje Jesús toj kyaꞌj, okxix tilil tuꞌn, tuꞌn tkanin tzmax Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Me nej i xi tnejsin kabꞌe t-xnaqꞌtzbꞌin tzma tojjo jun kojbꞌil te Samaria, tuꞌntzintla tjyet jun ja kyuꞌn, jaꞌ tuꞌntaq tktane Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Me ayetzin kyej xjal aj Samaria, mix kytziye tuꞌn tkyij Jesús antza, quꞌn tuꞌn otaq kybꞌi qa kyjaꞌtaq t-xiꞌ Jesús tzma Jerusalén, ex nimtaq qꞌoj kyxol aj Samaria kyukꞌa aj Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Atzaj teꞌ kybꞌin teꞌ kabꞌe t-xnaqꞌtzbꞌin Jesús, a Santyaw ex Juan, tiꞌtaq kybꞌis aj Samaria, xitzin kyqꞌmaꞌn te Jesús: ¿Taa, me qa aku ttziya te, tuꞌn t-xi qqꞌmaꞌn tuꞌn tkuꞌtz qꞌaqꞌ toj kyaꞌj, tuꞌntzintla kykyimjo maꞌ xjal kykyaqil? ");
INSERT INTO mamC_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tej tbꞌinte Jesús kyyoljo t-xnaqꞌtzbꞌin, bꞌeꞌx aj meltzꞌaj, exsin i xi tmiyoꞌn. Chiꞌ kyjaluꞌn: Mina n-el kyeꞌ kynikyꞌ te, jaꞌ tzajniꞌn tbꞌis kyanmiꞌn, a nya bꞌaꞌn, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Quꞌn ayiꞌn, a Tkꞌwal Ichin, mi ẍin ula yuchꞌil kychwinqilxjal, qalaꞌ tuꞌn kyklet. Noqx teꞌ tbꞌaj tqꞌmaꞌn ikyjo, bꞌeꞌx i xiꞌ toj junxil kojbꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tzuntaq chi bꞌet, tej tjaw yolin jun ichin, exsin xi tqꞌmaꞌn te Jesús kyjaluꞌn: Taa, wajx weꞌ tuꞌn wok lipe tiꞌja, jaꞌchaqx txaꞌyetza. ");
INSERT INTO mamC_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: ¿Ma twutzxixsin tey qa aku txi lipey wiꞌja? Me majx kxel nqꞌmaꞌn tey: At kye wech kyjul te kynajbꞌil; ex at kye pichꞌ kypaqbꞌil. Me metzin weꞌ, a Tkꞌwal Ichin, nipe jaꞌ tuꞌn nxi qꞌejeye chꞌiꞌn, ntiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ex xi tqꞌmaꞌn Jesús te juntl: Lipeka wiꞌjach. Me ante xjal xi ttzaqꞌwin: Me ntiꞌ ambꞌil wiꞌja jaꞌlin, quꞌn ma tijin ntatiy. Wajatlaꞌy nej tuꞌn tkubꞌ nyoꞌn ajxi tkyim, ex tuꞌn tkuꞌx nmuquꞌn, tzmaxitzintla ẍinx lipejiꞌy tiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Me xi ttzaqꞌwin Jesús: Lipeka wiꞌja jaꞌlin. Ex tzaqpinqekjiꞌy kyimninqe toj kynimbꞌil, tuꞌn tkux kymuquꞌn kyibꞌ. Me ante, ku txiꞌy qꞌmalte Tbꞌanil Tqanil kolbꞌil, a tzajnin toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Me atx juntlte xi qꞌmante kyjaluꞌn: Taa, waj weꞌ tuꞌn wok lipe tiꞌja, me nej ma chinka qꞌmalte nqanila kyeꞌ iteꞌ toj njaꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Mina, quꞌn alkye teꞌ k-okil ttzyuꞌn ttzꞌutzꞌ wakx tuꞌn taqꞌnin, exsin oꞌkxsa nkyimexi tiꞌjxi, ntiꞌ te xjal lo tajbꞌin tuꞌn taqꞌin toj Tkawbꞌil Diosch. ");
INSERT INTO mamC_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tbꞌajlinxitzin tkyaqiljo lo, jaw tskꞌoꞌn Jesús, a tAjaw Tkyaqil, kabꞌlajaj toj jun mutxꞌ xjal. I xi tsmaꞌn kakabꞌile kybꞌaj, tuꞌn kyxiꞌ nej twutz toj kykyaqil tnam ex toj kykyaqil najbꞌil, jaꞌ tuꞌntaq tpone Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Xi tqꞌmaꞌn Jesús kye kyjaluꞌn: Twutzx tetz nimx te xjal tuꞌn kynimin, tzeꞌnku nim twutz awal ma bꞌant tuꞌn tjaw chmet; me noqtzin tuꞌn nya ilaꞌqel kye aqꞌnil iteꞌ. Tuꞌnpetziꞌn, kyqaninxa te tajaw aqꞌuntl, tuꞌn ttzaj tsmaꞌn txqantl aqꞌnil te chmol teꞌ twutz awal. ");
INSERT INTO mamC_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kuxsin cheꞌxtza, ex kykaꞌyink kyibꞌa, quꞌn ma chex nchqꞌoꞌn tzeꞌnqekuꞌ tal rit kyxol txqan xoꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mina txi kyiꞌn kyeꞌ kychuꞌẍ nixpe tkubꞌil kypwaqa, nixpe kyxjabꞌa. Ex minape chi kubꞌ teꞌn qꞌolbꞌilte jun aꞌla toj bꞌe, qalaꞌ tuꞌn tok kyqꞌoꞌn tilil kyaqꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ajtzin kyokxa tuja, kchi qꞌolbꞌila kye iteꞌkx toj tukꞌa tnukꞌbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ikytziꞌn, qa aye xjal iteꞌkx tuja at kyoklin tiꞌjjo nukꞌbꞌil lo, ok kbꞌantil; metzin qa mina, nlay bꞌanttz. ");
INSERT INTO mamC_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Axsa kꞌaꞌ chi kyijiꞌy tojjo ja anetziꞌn; kꞌaꞌ txi kywaꞌn, ex kꞌaꞌ txi kykꞌwanjiꞌy a ktzajil qꞌoꞌn kyeꞌy, quꞌn at te aqꞌnil toklin tuꞌn tchjet twiꞌ tkꞌuꞌj. Mina cheꞌx kyeꞌ kyojileꞌ txqantl ja. ");
INSERT INTO mamC_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ajtzin kyokxa toj jun tnam, ex qa ma chi kubꞌ tziyiꞌn kyuꞌnxjal antza, wen tuꞌn t-xi kywanjiꞌy a ktzajil qꞌoꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ex kyqꞌaninqekujiꞌy yabꞌ, a iteꞌ antza, exsin kyqꞌmanxa kyjaluꞌn: Ajo Tkawbꞌil qMan Dios, luꞌ ma tzul laqꞌe kykꞌatza, chichkujiꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ex qatzin qa mi ẍi kubꞌ tziyin kyuꞌn, ex qa mi xkubꞌ kybꞌiꞌn kyyola, ku kyetza tojjo bꞌe, ex kyqꞌmanxa: ");
INSERT INTO mamC_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Majxpe quq tiꞌj qqaꞌn k-elil qchtoꞌn te jun yekꞌbꞌil kyiꞌja, qa kykyꞌeꞌy tiꞌj Tyol Dios. Me bꞌiꞌnkuxix kyuꞌn, a Tkawbꞌil Dios ma tzul laqꞌe kykꞌatza. ");
INSERT INTO mamC_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Twutzxix kxel nqꞌmaꞌn kyeꞌy, toj tqꞌijil paꞌbꞌin twutz Dios, kujxixla tkawbꞌil Dios ktzajil kyibꞌaj, a tzeꞌnku kye xjal ojtxe kyojjo tnam Sodoma, a i bꞌaj tuꞌn qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","I kubꞌ tqꞌmaꞌn Jesús jun jteꞌbꞌin tyol kyiꞌjjo xjal mibꞌin chi nimin, a najleqe kyojjo tnam. Chiꞌ kyjaluꞌn: ¡Ay! Nimx bꞌisbꞌajil kyeꞌy, a ayiꞌy aj tnam Corazín exsin aj Betsaida. Quꞌn noqit kyojjo tnam Tiro ex Sidón ma bꞌant te yekꞌbꞌil wipiꞌn, tzeꞌnku ma bꞌant kyxola, ojtxetla tzꞌajtz tiꞌj kyanminxjal, ex matla kubꞌ kyyekꞌin jun txꞌixpibꞌl toj kychwinqil, noq tuꞌn tok kyqꞌoꞌn kyxbꞌalin te bꞌisbꞌajil, ex tuꞌn tjaw kychtoꞌn tzaꞌj toj kywiꞌ, tzeꞌnkuxjo nbꞌant kyuꞌnxjal tzaluꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Twutzxix kxel nqꞌmaꞌn kyeꞌy, toj tqꞌijil paꞌbꞌin twutz Dios, kujxixtl kye tkawbꞌil Dios ktzajil kyibꞌaj, tzeꞌnku kye aj Tiro ex Sidón. ");
INSERT INTO mamC_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ikyxjo kye aj tnam Capernaum; ¿Chila, qa chi japiꞌn toj kyaꞌj? ¡Me mina! Quꞌn ayexixpe kyeꞌ kchi xeꞌl tojjo ma tij jul, a jaꞌla taꞌyile t-xela, chi Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Xi yolinl Jesús kyeꞌ t-xnaqꞌtzbꞌin. Chi kyjaluꞌn: Ayetziꞌn xjal, a kchi kꞌwel bꞌinte kyyola, a nyola nkubꞌ kybꞌiꞌn. Ex ayetzin kyeꞌ xjal, a kchi elil ikyꞌin kyeꞌy, ayin weꞌ nchi el kyikyꞌin. Ex alkyeꞌ k-elil ikyꞌin weꞌy, majxpe te Dios n-el kyikyꞌin, a saj chqꞌon weꞌy, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tzunx nchi tzalajx kyej kabꞌlajaj toj jun mutxꞌ xjal, tej kymeltzꞌaj. Chi chiꞌ kyjaluꞌn: Taa, majqexpe kyeꞌ taqꞌnil tajaw il nqo kubꞌ nimiꞌn kyuꞌn, tzeꞌnku nqo yoliꞌn toj tumil tbꞌiy. ");
INSERT INTO mamC_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chi Jesús kyjaluꞌn: Twutzx teꞌ, nlonte weꞌ tajaw il, tej ttzaj lankꞌaj toj kyaꞌj ikyjo tzeꞌnkuꞌ jun qꞌankyaq. ");
INSERT INTO mamC_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","O txi nqꞌoꞌn weꞌ kyipiꞌn tuꞌn kyjax weꞌy kyibꞌaj kan ex kyibꞌaj txuk, a at kytxꞌaꞌbꞌl tiꞌj kyje, ex tuꞌn tkubꞌ kyiꞌjjo jniꞌ kyipin ajqꞌoj kyuꞌn. Ex ayetzin kyeꞌ, ntiꞌx chꞌin kchi kyꞌixbꞌila kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Me mina chi jaw tzalaja noq tuꞌn nchi kubꞌ nimiꞌn kyuꞌn taqꞌnil tajaw il; qalaꞌ chi tzalaj kyeꞌ, quꞌn tuꞌn luꞌ kyeꞌ kybꞌi noq tzꞌibꞌinl toj kyaꞌj toj kyajlal jniꞌ nimil, chi Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Texjo paq anetziꞌn, jaw tzalajxix Jesús tuꞌn Xewbꞌaj Xjan, exsin tqꞌma kyjaluꞌn: Taa, ay tAjaw kyaꞌj ex ay tAjaw txꞌotxꞌ; loqiꞌn nchin nimsin Tbꞌiy jaꞌlin, quꞌn tuꞌn ma kubꞌ tewin tejiy t-xilin tumil kolbꞌil kyeꞌ xjal a ẍtijqe ex nim kynabꞌl toj kywutz, exsin ma kubꞌ tchikyꞌbꞌintza kywutzjo xjal, a qꞌoꞌnk kyoklin te ntiꞌ bꞌaꞌn kyuꞌn. Ikytziꞌn Tata, quꞌn ikytaqkuxla tajiy. ");
INSERT INTO mamC_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Quꞌn ma tzaj tqꞌoꞌn nMaꞌn weꞌy tkyaqil. Ex mix aꞌl jun ojtzqil weꞌy, qalaꞌ oꞌkx nMaꞌn, quꞌn ayiꞌn Tkꞌwal. Ex mix aꞌl jun ojtzqil te nMaꞌn, qalaꞌ oꞌkqinxa. Ex alkye jun xjal waja tuꞌn t-xi nyekꞌiꞌn nMaꞌn te, kxel nyekꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Xi meltzꞌaj Jesús kyukꞌa t-xnaqꞌtzbꞌin, ex noq kyeku xi tqꞌmaꞌne kyjaluꞌn: Kyꞌiwlinqexix kyeꞌ, ayiꞌy, a n-ok kykaꞌyiꞌn jotxjo, a loqiꞌy nchi kaꞌyin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Twutzxjo kxel nqꞌmaꞌn kyeꞌy, qa ilaꞌ qtzan yolil Tyol Dios, ex qa ilaꞌ qtzan nmaq kawil kyibꞌaj tnam kyajtaq tuꞌn tok kykaꞌyin a loqiꞌy nchi kaꞌyin tiꞌj jaꞌlin, me mina xkylonte. Ex kyajtaq tuꞌn tok kybꞌiꞌn ajo nchi bꞌiꞌn tiꞌj jaꞌlin, ex ikyxjo mina xkybꞌi, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Attaq jun xnaqꞌtzil tiꞌj ojtxe kawbꞌil xi laqꞌe yolil tkꞌatz Jesús, me noq tuꞌn tkubꞌ tzꞌaq tuꞌn toj til tuꞌn tyol. Xitzin tqanintz kyjaluꞌn: Xnaqꞌtzil, ¿Tiꞌtzin weꞌ tuꞌn tkubꞌ nbꞌinchiꞌn, tuꞌn nkanbꞌintejiꞌy chwinqil te jun majx? ");
INSERT INTO mamC_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: ¿Titziꞌn o kubꞌ tzꞌibꞌit toj kawbꞌil? ¿Titzin tetza nkux tuꞌjin? ");
INSERT INTO mamC_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Atzin tej xnaqꞌtzil xi ttzaqꞌwin kyjaluꞌn: Chixix te uꞌjjo kyjaluꞌn: Kꞌuꞌjlinkxix te tDios, a tAjaw Tkyaqil, tukꞌa tkyaqil tanmiꞌn, tukꞌa tkyaqiljo tajbꞌila, tukꞌa tkyaqil tipiꞌn ex tukꞌa tkyaqil tnabꞌla; exsin kꞌuꞌjlink te t-xjalil tzeꞌnkuxjo n-ok tkꞌuꞌjlin te tibꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Xitzin tqꞌmaꞌnl Jesús kyjaluꞌn: Ikyxixpetzin toka, chi Jesúsjo. Qatzin ma bꞌanttz tuꞌn ikyjo, okpetzin ktenbꞌil tchwinqiltza te jun majx, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Atzin tej xnaqꞌtzil nya wen eꞌle te te, tuꞌn mix xkyeye tyolin tiꞌj Jesús. Tuꞌntziꞌn, xi tqanin juntl majl kyjaluꞌn: ¿Me altzin kye qe wetza nxjalil? chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Jun maj, at jun ichin tzajninxtaq toj tnam Jerusalén, ex tuꞌntaq tpon kanin toj tnam Jericó. Tzuntaq nbꞌet, tej tok tzyuꞌn kyuꞌn txqan ileqꞌ. Noqx techx bꞌaj bꞌyoꞌn, exsin el qꞌiꞌn jotxjo jniꞌ qꞌiꞌntaq tuꞌn exsin jniꞌ t-xbꞌalin. Atzaj teꞌ chꞌixtaqx tel kyimj ichin anetziꞌn, bꞌeꞌxsin i oq kyej ileqꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Noqxla tzeꞌn tten, n-ikyꞌtaqku jun pale tojjo bꞌe anetziꞌn. Atzaj teꞌ tiwlej ichin tuꞌn, a otaq kyꞌixbꞌe kyuꞌn ileqꞌ, liweyxix xi ttxalpin tibꞌ ex mix kubꞌ weꞌyexix chꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ex at jun nmaq nimil tiꞌj kynimbꞌil aj Judiy ikyꞌ tojjo bꞌe anetziꞌn. Me ex ikyxjo, bꞌeꞌx xi ttxalpin tibꞌ ttxlaj bꞌe, tej tiwlej ichin tuꞌn, aj otaq bꞌaj bꞌyoꞌn kyuꞌn ileqꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ex attaq juntl ichin, a aj Samaria, jun kyxol xjal manyor ikyꞌin kyuꞌn aj Judiy, a tzuntaq nbꞌet tojxjo bꞌe anetziꞌn. Ajo ichin anetziꞌn, bꞌeꞌx tzaj chyoꞌnx tanmin tiꞌjjo xjal, a otaq kyꞌixbꞌe kyuꞌn ileqꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ok laqꞌe tkꞌatzjo xjal kyꞌixbꞌine, jatz tiꞌn t-aseyt exsin vin te qꞌanbꞌil, exsin ok tentz suꞌlte tiꞌjileꞌ jniꞌ tkyꞌixlbꞌin xjal. Atzaj teꞌ tbꞌaj tsuꞌn, ok tqꞌoꞌn bꞌuꞌẍ te potzbꞌilte, exsin jax tqꞌoꞌntz tibꞌajjo tchej. Xi tiꞌn toj jun ja, jaꞌ ntzaje qꞌoꞌn qkuẍbꞌil, exsin axsa kubꞌe tene kaꞌyilte. ");
INSERT INTO mamC_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tojtzin juntl qꞌijltz, jatz tiꞌn tej ichin aj Samaria kabꞌe pwaq, exsin xi tqꞌoꞌntz teꞌ tajawjo ja, jaꞌ kuẍletaqjo yabꞌ, exsin xi tqꞌmaꞌntz kyjaluꞌn: Bꞌaꞌnx te kaꞌyin tiꞌjjo ichin lo, qatzin atl tetza pwaq xbꞌaj tuꞌn te kaꞌybꞌinte, we txi nchjoꞌn weꞌ, aj nmeltzꞌaja. ");
INSERT INTO mamC_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kutzintz jaꞌlin, chi Jesús. ¿Altzin kye ichintz kyxoljo oxe, aku tzꞌok tqꞌoꞌn te t-xjaliljo ichin, aj kyꞌixbꞌe kyuꞌn ileqꞌ? ");
INSERT INTO mamC_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Atzin tej xnaqꞌtzil tiꞌj ojtxe kawbꞌil xi tqꞌmaꞌn te Jesús kyjaluꞌn: Aj tzaj chyoꞌn tkꞌuꞌj tiꞌj xjal, a otaq kyꞌixbꞌe. Xitzin tqꞌmaꞌnl Jesús te kyjaluꞌn: ¡Kuxsin txiꞌtza! exsin bꞌinchinkutza tzeꞌn oke tuꞌn xjal, a tzaj chyoꞌn tkꞌuꞌj tiꞌjjo juntl. ");
INSERT INTO mamC_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Atzin te Jesús bꞌeꞌx xi tiꞌnl teꞌ tbꞌe, exsin pon kanin toj jun kojbꞌil, jaꞌ najletaq jun qya, Mart tbꞌi. Kꞌamle Jesús tojjo ja anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Me atzin te Mart, attaq jun teꞌ ttziky, Mariy tbꞌi. Bꞌeꞌx kubꞌ qe te Mariy t-xe tqan Jesús, bꞌilte jniꞌ Tyol. ");
INSERT INTO mamC_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Atzin te Mart nim jaw labꞌte teꞌ, quꞌn tuꞌn nimxtaq taqꞌin at. Tuꞌntziꞌn, xi laqꞌe tkꞌatz Jesús, exsin xi tqꞌmaꞌntz kyjaluꞌn: Taa, ¿Ntiꞌxsin chꞌin npon tbꞌisa, tuꞌn njunalxa ma chin kyij tqꞌoꞌn ntzikya tiꞌjjo txqan aqꞌuntl lo? ¡Qꞌmanx chꞌin te, tuꞌn tmojin wukꞌiy! ");
INSERT INTO mamC_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Me atzin te Jesús xi ttzaqꞌwin kyjaluꞌn: Ay, Mart, ¿Man jaw bꞌisin te, ex man jaw bꞌajxte tkꞌuꞌj tuꞌn ma nintzx taqꞌin? ");
INSERT INTO mamC_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","¿Me tiqunil? Quꞌn junchꞌinte ilxix tiꞌj tuꞌn tkubꞌ bꞌinchit. Atzin nkubꞌ tbꞌinchin Mariy, atzin te ilxix tiꞌjjo tuꞌn tkubꞌ bꞌinchit, quꞌn mix aꞌlx jun aꞌla k-elil qꞌinte te. ");
INSERT INTO mamC_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jun maj, nnaꞌntaq Jesús Dios. Atzaj teꞌ tbꞌaj naꞌn Dios, at jun t-xnaqꞌtzbꞌin xi qꞌmante te kyjaluꞌn: Taa, qo t-xnaqꞌtzintza tuꞌn tbꞌant qnaꞌn Diosa, ikyjo tzeꞌnku oke tuꞌn Juan, tej kyxi t-xnaqꞌtzin jniꞌ t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chi Jesúsjo kyjaluꞌn: Ajtzin kyok ten kyeꞌ naꞌl Dios, chichkujiꞌy kyjaluꞌn: Ay qMan Dios, noqit tzꞌel kynikyꞌxjal qa xjanxixjo tbꞌiy. Noqit kuꞌtzjo Tkawbꞌila tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Qꞌontzjiy qwaꞌy nimxix te qꞌij jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ex najsinkujiy qila, ikyxjo tzeꞌnku qeꞌ, nkubꞌ qnajsiꞌn kyilxjal, a nchi bꞌinchin mibꞌin qiꞌja. Mi ttziyiy tuꞌn qkubꞌ tzꞌaqa toj jun joybꞌil, aj ttzaj qiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ex xi tqꞌmaꞌnl Jesús kyjaluꞌn: Qqꞌaknajtzin kyjaluꞌn: Atit jun kyeꞌ, at jun tukꞌa pon kanin nikyꞌjin aqꞌwil, exsintla xi tqꞌmaꞌntz kyjaluꞌn: Ay wukꞌa, qꞌontzin oxe tal wabꞌj ntxꞌexa, ");
INSERT INTO mamC_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","noq tuꞌn at jun weꞌ wukꞌa tzajnin toj tbꞌe, ex luꞌ ma kanin njaꞌy. Me ntiꞌx chꞌin weꞌ at we, a tuꞌn t-xi nqꞌoꞌn te. ");
INSERT INTO mamC_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bꞌalaqa a xjal, a tokx tuja, ktzajil tqꞌmaꞌn: Mitzin chin tyajiy nej. Ma jpet weꞌ nja, ex loqo qeꞌ ma qo kux kẍe kyukꞌa qalaꞌ. Me bꞌaꞌpetziꞌn, nlay chin jaw weꞌks weꞌ qꞌolte chꞌin tiꞌ tey. ");
INSERT INTO mamC_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kxel nqꞌmaꞌn kyeꞌy, exla qa mi xjaw weꞌks, noq tuꞌn kyukꞌa kyibꞌ, me noq tuꞌn tzunxix nlabꞌte wen, kjawil weꞌks qꞌolte noq alkye ntqanin. ");
INSERT INTO mamC_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy: Kyqaninxa, ex ktzajil tqꞌoꞌn Dios; kyjyoma t-xilin tajbꞌil qMan, ex knetil kyuꞌn; kyqꞌolbꞌinxa toj kynaꞌj Diosa, ex ktzajil ttzaqꞌwin kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Quꞌn alkye nqanin jun tiꞌ, ok kꞌmetil tuꞌn; ex alkye njyoꞌnxix, ok knetil tuꞌn; ex alkye nqꞌolbꞌin, ex ok ktzajil tzaqꞌwin. ");
INSERT INTO mamC_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Ma attzin jun kyeꞌ, a ayiꞌy manbꞌajqiꞌy, aku txi qꞌonte jun kan te jun kykꞌwala, aj ttzaj tqanin jun tchiꞌ kyiẍ? ¿Mo akupela txi tqꞌoꞌn jun manbꞌaj abꞌj te jun tkꞌwal, aj qa ma tzaj tqanin kꞌwal jun twa pan? ");
INSERT INTO mamC_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Mo qa aku txi tqꞌoꞌn jun sichil, qa ma tzaj tqanin jun tchiꞌ jos? ¡Nlayla! chi Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Noqpe oꞌkx kyejiꞌy tbꞌanilxix kyaj te kykꞌwala, exla qa nya wenqiꞌy. ¿Yajtzin te Diostz, a at toj kyaꞌj? ¿Ma nlaypetzila tzaj tqꞌoꞌn teꞌ Xewbꞌaj Xjan qe, qa ma txi qqanin te? ");
INSERT INTO mamC_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Attaq jun xjal, minataql nbꞌant tyolin, tuꞌn otaq tzꞌokx jun taqꞌnil tajaw il toj tanmin. Me atzaj teꞌ tetz qꞌiꞌn toj tanmin tuꞌn Jesús, bꞌeꞌx bꞌantl tej xjal tyolin. Tuꞌnpetziꞌn, nimx i jaw kaꞌylajxjal tuꞌn ikyjo. ");
INSERT INTO mamC_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Me iteꞌ junjun xjal i qꞌmante kyjaluꞌn: Nchi etz teꞌ xjal taqꞌnil tajaw il tuꞌn, quꞌn tuꞌn a te Beelzebú, a tajaw il, o txi qꞌonte tipin, chi chi xjaljo tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Me iteꞌl txqantl xjal xi kyqanin te Jesús, tuꞌn tkubꞌ tbꞌinchin jun yekꞌbꞌil tipin toj kyaꞌj. Xi kyqanin ikyjo, quꞌn kyajtaqjo xjal tuꞌn tel kynikyꞌ te, a qa antza tzajniꞌn tipin Jesús toj kyaꞌj mo minaj. ");
INSERT INTO mamC_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Me bꞌiꞌntaq te Jesús tuꞌn, tiꞌtaqjo nkybꞌisin xjal. Tuꞌntziꞌn, xi tqꞌmaꞌn kye kyjaluꞌn: Qa paꞌn kytenxjal toj jun nim tnam, ex qa kyajqꞌoj kyibꞌ, noqx aku chi kubꞌ naj tuꞌn qꞌoj. Ex ikyxjo toj jun ja xjal; qa kyajqꞌoj kyibꞌ, nlay chi el wen. ");
INSERT INTO mamC_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ikytzin taꞌye te satanásjo, a tajaw il. Qa ma tzꞌetz tlajoꞌn tibꞌ tuꞌnx tibꞌx kyoj kyanminxjal, paꞌnla ttentz tiꞌjx, ex atzin tkawbꞌil nlay chꞌiy. ¿Ma man kubꞌ numjjo tipintz? Nxi nqꞌmaꞌn weꞌ ikyjo, quꞌn loqiꞌy nchi yolin kyxoliliꞌy aj qa noq tuꞌn tipin Beelzebú, a tajaw il, nchi etz nlajonjiꞌy taqꞌnil. ¿Ma akutzin tzꞌok meltzꞌaj tajaw iltz kyiꞌjxjo taqꞌnil? ");
INSERT INTO mamC_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ex noqit ikyjo tzeꞌnku nkyqꞌmaꞌn, qa tuꞌn tipin Beelzebú nchi etza taqꞌnil tajaw il toj kyanminxjal wuꞌn, ¿Yajqetzin kyeꞌ, a lipcheqek kyiꞌja? ¿Ankye kye tzaj qꞌoꞌnte kyipin tuꞌn tetz kylajoꞌn taqꞌnil tajaw il toj kyanminxjal, qa nya ax Dios? Tuꞌnpetziꞌn, ayexjo kyukꞌiy kchi qꞌmalte qa nya toj tumil kyyola tiꞌjjo lo. ");
INSERT INTO mamC_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Me metziꞌn, qa a te Dios ntzaj qꞌonte weꞌ wipin, tuꞌn kyetzjo taqꞌnil tajaw il wuꞌn toj kyanmin xjal, tzꞌelkutzin kynikyꞌtza te, a qa ma tzuljo Tkawbꞌil Dios kyxola. ");
INSERT INTO mamC_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Qa at jun xjal nimxix tipin, a at kxbꞌil te kolbꞌilte kywutz ileqꞌ, exsin tzunxix nxqꞌuqintz tiꞌj tja, nlay tzꞌex qꞌiꞌn a at toj, ex ntiꞌxla aku bꞌajte. ");
INSERT INTO mamC_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Me tzulittzin juntl xjal, a nimxixtl tipin tzeꞌnku tnejil, bꞌeꞌx aku kubꞌ tuꞌnljo xjal anetziꞌn. Bꞌeꞌx aku chi el qꞌiꞌn jniꞌ qꞌuqle tkꞌuꞌj tiꞌj te kolbꞌil tibꞌ, ex a xjal anetziꞌn kqꞌmalte tzeꞌn aku chi oke jniꞌ at toj tja. ");
INSERT INTO mamC_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ankye jun xjal nya taj tuꞌn tqꞌoꞌn te tibꞌ wukꞌiy, nqꞌojin wiꞌja. Ex ankye jun xjal mi n-onin wukꞌiy tuꞌn tel kynikyꞌxjal tiꞌj Kolbꞌil, noq nbꞌaj tchitin, tzeꞌnku jun aqꞌnil kyꞌaj, a tkyꞌeꞌ tuꞌn tmojin tuꞌn tjaw chmet twutz awal. ");
INSERT INTO mamC_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aj tetz jun taqꞌnil tajaw il toj tanmin jun xjal, a nya nimil, bꞌeꞌx nxiku jyolte tojjo tzqij txꞌotxꞌ, jaꞌ tuꞌn ttene. Exsin qa mi xjyet tuꞌn, kꞌwel t-ximin: Kchin meltzꞌajil weꞌ juntl majl tojjo njaꞌy, jaꞌ ẍin etziy. ");
INSERT INTO mamC_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ex ajtzin tkanin juntl majl tkꞌatzjo xjal, knetiljo xjal tuꞌn, tzeꞌnku jun ja, a ntiꞌ at toj, ex chebꞌe misoꞌn, ex nikꞌuꞌnxix wen. ");
INSERT INTO mamC_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Bꞌeꞌxsin k-okixtz toj tanmin xjal, me nya tjunalx jaꞌlin; qalaꞌ kyukꞌa wuql tukꞌa xininqexix toj il tzeꞌnku a. Ex kykyaqilx chi najal toj tanminjo xjal jaꞌlin. Atzaj xjal noqx kyja kxeꞌlix toj il tzeꞌnkuꞌ ttentaq te tnejil. ");
INSERT INTO mamC_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tzuntaq nyolin Jesús ikyjo, tej tjaw ẍchꞌin jun qya kyxolxjal. Chiꞌ kyjaluꞌn: ¡Kyꞌiwlinxix teꞌ qya, a xkubꞌ alintiy ex xjaw chꞌiysintiy! ");
INSERT INTO mamC_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Ikypen teꞌ, me nimxixtl teꞌ tkyꞌiwbꞌil qMan kyibꞌajjo a nkubꞌ kybꞌiꞌn Tyol Dios, exsin nkubꞌ kynimin, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Me ayetzin kyeꞌ xjal, tzuntaq nchmet-xi kyeꞌ kybꞌaj tiꞌjile Jesús. Ex ante Jesús ok ten qꞌmalte kyjaluꞌn: Ayetzin xjal kyojjo tqꞌijil jaꞌlin, manyor aj ilqe. Nkyqanin jun techil wipiꞌn, me mi txi nyekꞌiꞌn jun techil, qalaꞌ oꞌkx jun techil tzeꞌnku te Jonás. ");
INSERT INTO mamC_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Quꞌn ikytziꞌn te Jonás ok teꞌ te jun yekꞌbꞌil kyxol xjal te Nínive, ex ikyx wejiꞌy, a Tkꞌwal Ichin, ok kchin okila te jun yekꞌbꞌil kyeꞌ xjal tojjo tqꞌijil jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Toj tqꞌijil paꞌbꞌin, ok kchi okil tkyaqil xjal atxix t-xe tnejil toj paꞌbꞌin twutz Dios, junx kyukꞌa ayeꞌ loqe nchi anqꞌin kyojjo tqꞌijil jaꞌlin. Ok kjawil weꞌksjo qya, a nmaq kawil tzajnin te najchaq te twutz txꞌotxꞌ, tuꞌn kykubꞌ tzꞌaqxjal toj kyil tuꞌn, ayeꞌ iteꞌ kyojjo qꞌij jaꞌlin. Quꞌn ajo qya anetziꞌn bꞌeꞌx xiꞌ bꞌilte tnabꞌlxix qtzan Salomón. Me ajo t-xilin nabꞌl wiꞌja jaꞌlin, nimxixtl toklin tzeꞌnku te Salomón. ");
INSERT INTO mamC_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ex ikyqex kyeꞌ xjal toj tnam Nínive kyojjo qꞌij te Jonás kchi jawil weꞌks toj tqꞌijil paꞌbꞌin, aj kyokxjal toj xjelbꞌil twutz Dios, ayeꞌ iteꞌ kyojjo qꞌij jaꞌlin, tuꞌn kykubꞌ tzꞌaq toj kyil kyuꞌn. Quꞌn ayetzinxjal toj Nínive bꞌeꞌx ajtz tiꞌj kyanmin, tej t-xi tqꞌmaꞌn Jonás Tbꞌanil Tqanil Dios kye. Ex ajo Tbꞌanil Tqanil wiꞌja jaꞌlin nimxixtl toklin tzeꞌnku toj tqꞌijil Jonás. ");
INSERT INTO mamC_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Xi tqꞌmaꞌnl Jesús kyjaluꞌn: Mix aꞌl jun xjal aku tzꞌok txqonte jun tzaj, exsin bꞌeꞌx kxel tewiꞌntz, mo tuꞌn tkuꞌx tjaqꞌ jun kax; qalaꞌ tuꞌn tkubꞌ qꞌoyit jawnin twiꞌ jun xtankoꞌl, tuꞌntzin tspikyꞌbꞌajtz tkyaqil toj ja. ");
INSERT INTO mamC_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ajo kywutza tzeꞌnku jun tzaj te kyxmilila ex te kyanmiꞌn. Qa wen kywutza, at spikyꞌin toj kyanmiꞌn tuꞌn tel kynikyꞌa tiꞌj tkyaqiljo wen. Me qatzin ma txi kyqꞌoꞌn ambꞌil te kywutza noq tuꞌn tkaꞌyin tiꞌjjo nya wen, ex ikyx ok k-okil kyanmiꞌn te nya wen, ex toj qxopin. ");
INSERT INTO mamC_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kykaꞌyinktzin kyibꞌa tuꞌn mi qe kykꞌuꞌja tiꞌj jun kyanmiꞌn nya wen, quꞌn kchi kꞌwel sbꞌuꞌn tuꞌn, tuꞌn kyxi tiꞌn toj manyor qxopin. ");
INSERT INTO mamC_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Qatzin toj spikyꞌin taꞌye kyximbꞌitza exsin tkyaqiljo kychwinqila, ex ntiꞌ chꞌin qxopin toj; okpen k-elil kynikyꞌtza tiꞌj tkyaqiljo nya wen, tzeꞌnku tuꞌn kybꞌeta toj jun tqan tzaj. ");
INSERT INTO mamC_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Atzaj teꞌ tkubꞌ qen Jesús tuꞌn tyolin, bꞌeꞌx xi txkoꞌn waꞌl tuꞌn jun Parisey. Atzaj teꞌ tkanin tzma tja Parisey, okxsintz tuja, exsin ok qetz waꞌl tiꞌj meẍ. ");
INSERT INTO mamC_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Me atzin tej Parisey noqx jaw kaꞌylaj teꞌ, quꞌn tuꞌn mix i ele ttxjoꞌn te Jesús tqꞌobꞌ, tzeꞌnku nbꞌanttaq kyuꞌn, teꞌ tok ten waꞌl. ");
INSERT INTO mamC_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Xitzin tqꞌmaꞌn qAjaw te kyjaluꞌn: Atzin kyeꞌ, a ayiꞌy Parisey, tbꞌanilx kykaꞌyajtza kywutzxjal, tzeꞌnku jun vas ex jun laq manyor txjonx tiꞌj, me atzin tojxi, manyor tzuꞌjx. Ikytzin kyejiꞌy toj kyanmiꞌn; nojnin iteꞌya tuꞌn nknet kyuꞌn tuꞌn kyelqꞌbꞌiꞌn, ex tuꞌn kybꞌinchbꞌiꞌn nya bꞌaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ntiꞌ kynabꞌla! ¿Ma miꞌtzin bꞌiꞌn kyuꞌn, qa ikyqejiꞌy tzeꞌnku jun vas? Il tiꞌj tuꞌn tel txjetjo tojxi tzeꞌnkuxjo tiꞌjxi. Junchꞌin tumil at, quꞌn junchꞌinte xkubꞌ bꞌinchin teꞌ a qꞌanchaꞌl, exsin nya qꞌanchaꞌl, ex kykabꞌil il tiꞌj tuꞌn tel txjet. ");
INSERT INTO mamC_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tuꞌnpetziꞌn, tnejilxix, kyqꞌonxsinjiꞌy oyaj te mojbꞌil tukꞌa jun kyanmiꞌn txjonxix, ex noq tuꞌn ikyjo, tkyaqilx kychwinqila ok k-elil saqix. ");
INSERT INTO mamC_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy Parisey. Quꞌn nxi kyqꞌoꞌn twutz Dios tlajajin tnej tal menta, tal rud ex tkyaqil wiq itzaj, tzeꞌnkuxjo ntqꞌmaꞌn toj ojtxe kawbꞌil. Me mi nxi kyqꞌoꞌn ambꞌil tiꞌjjo xnaqꞌtzbꞌil, a nimxixtl toklin toj kawbꞌil: A tuꞌn kynajaꞌn tzꞌaqle, ex tukꞌa tqꞌaqꞌbꞌil kykꞌuꞌja tiꞌj Dios. Atzin tuꞌn tbꞌantjo kyuꞌn, ex tuꞌn mi kyij kytzapinjiꞌy txqantl. ");
INSERT INTO mamC_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy Parisey. Quꞌn oꞌkx kyajiꞌy tuꞌn kykubꞌ qeꞌy kyibꞌajjo meẍ tbꞌanilqex wen, aj kyxiꞌy toj muꞌẍ ja te naꞌbꞌl Dios. Ex kyaj tuꞌn kyqꞌolbꞌinxjal kyeꞌy tukꞌa kymutxbꞌil kyibꞌ kyojile bꞌe. ");
INSERT INTO mamC_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bꞌisbꞌajilxla kyeꞌy, ayiꞌy Parisey. Quꞌn aye xjal mi naꞌn kyuꞌn tiꞌjjo kyanmiꞌn, a nya wen. Quꞌn ikyqexixjiꞌy tzeꞌnqeku kyjulil kyimnin, a nya qꞌanchaꞌlqe, a tzunx nchi bꞌetjexjal kyibꞌaj. Me mina n-el kynikyꞌ te, quꞌn tuꞌn nya qꞌanchaꞌlqe. ");
INSERT INTO mamC_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","At jun te xnaqꞌtzil tiꞌj kawbꞌil, xi tzaqꞌwinte Jesús. Chiꞌ kyjaluꞌn: Xnaqꞌtzil, ex majqox qeꞌ ma qo ok tyisoꞌn, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Me atzin te Jesús xi ttzaqꞌwin kyjaluꞌn: Ex bꞌisbꞌajilxla kyeꞌy, a ayiꞌy xnaqꞌtzil tiꞌj ojtxe kawbꞌil, quꞌn nxi kyqꞌoꞌn nimku nukꞌbꞌil, a kujxix wen, kyibꞌajxjal, nyakuj jun iqtz, a nlay kyꞌisje kyuꞌn. Ex ayenajtzin kyetza, nipe jun tal twiꞌ kyqꞌobꞌa n-ok aqꞌle tiꞌjjo iqtz anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ex bꞌisbꞌajilxla kyeꞌy, a tuꞌn njaw kybꞌinchinljiꞌy kyja kyimnin, a yolil Tyol Dios, aye i kꞌmonte Tyol ojtxe. ¿Ma nyatzin ayexjo ojtxe kychmaꞌn i kubꞌ bꞌyonkye? ");
INSERT INTO mamC_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tuꞌnpetziꞌn, ikyx kyximjiꞌy, ex ikyx kyaqꞌnbꞌinjiꞌy tzeꞌnqe bꞌyol xjal ojtxe, quꞌn aye kychmaꞌn i kubꞌ bꞌyoꞌnkye, ex ayetzinl kyetza njaw kybꞌinchiꞌn kyja te jun nabꞌlkye. ");
INSERT INTO mamC_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tuꞌnpetziꞌn, bꞌeꞌx tqꞌma te Dios, a nimx t-xilin tnabꞌl. Chiꞌ kyjaluꞌn: Ok kchi xel nchqꞌoꞌn weꞌ nyolila exqetziꞌn nxnaqꞌtzbꞌiꞌn. Me iteꞌ junjun kye kchi kꞌwel bꞌyoꞌn, ex iteꞌ junjuntl ok ktzyetil kylajche. ");
INSERT INTO mamC_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Me ayetzin kyeꞌ xjal, a loqe nchi anqꞌin jaꞌlin, ok kꞌwel tzꞌaq tkawbꞌil Dios kujxix kyibꞌaj tuꞌn tpaj kychkyꞌeljo jniꞌ yolil Tyol Dios ojtxe, atxix t-xe tnejil, ");
INSERT INTO mamC_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tzeꞌnku qtzan Abel ex qtzan Zakariy, a kubꞌ bꞌyoꞌn tojx tnejil ja te naꞌbꞌl Dios ex twutz t-altar. Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy, aj qa kchi okila toj paꞌbꞌin twutz Dios tiꞌj kykyimliꞌn qtzan xjal lo, ktzajil tqꞌoꞌn Dios kujxix tkawbꞌil kyibꞌaja te chojbꞌil, a ayiꞌy iteꞌ tojjo tqꞌijil jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ex bꞌisbꞌajilxla kyeꞌy, a ayiꞌy xnaqꞌtzil tiꞌj ojtxe kawbꞌil, tuꞌn a ma kubꞌ kyetzinjiꞌy tumiljo tzeꞌn tuꞌn tela kynikyꞌxjal tiꞌj Dios. Me majqexpe kyeꞌ, mi n-el kynikyꞌ te tumil, ex nchi ok kymeqoꞌnjiꞌy txqantl, a kyaj tuꞌn tel kynikyꞌ tiꞌj Dios. ");
INSERT INTO mamC_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Atzaj teꞌ tbꞌaj tqꞌmaꞌn Jesúsjo jniꞌ yol lo, ayetzaj jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey nimx kyqꞌoj tzaj. Tuꞌntziꞌn, bꞌeꞌx i ok ten qanilte noq tiꞌchaqku tiꞌ, ");
INSERT INTO mamC_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","quꞌn kyajtaqjo xjal anetziꞌn, tuꞌn tkubꞌ tzꞌaq Jesús kyuꞌn toj til kyuꞌnxjo tyol. ");
INSERT INTO mamC_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kyojjo qꞌij anetziꞌn, jaw kychmoꞌn jun jteꞌ milxla xjalla, noqx jaw kylimoꞌn kyibꞌ, junjun tukꞌa juntl. Ex ok ten Jesús yolil kyeꞌ t-xnaqꞌtzbꞌin. Chiꞌ kyjaluꞌn: Kyklom kyeꞌ kyibꞌ teꞌ kytxꞌamil xjal Parisey, a kyxmiletzꞌil, a chebꞌe n-el lemimin kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Quꞌn ntiꞌ jun tiꞌ toj ewajil taꞌye, a nlay tzꞌel tqanil. Ex ntiꞌ jun tiꞌ ewin taꞌye, a nlay tzꞌetz toj qꞌanchaꞌl. ");
INSERT INTO mamC_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tuꞌnpetziꞌn, jotxjo kyeꞌ, a o bꞌaj kyqꞌmaꞌn toj ewajil, ok kbꞌijtajil teꞌ toj tqan qꞌijil. Ex jotxjo, a o bꞌaj kyjaskꞌiꞌn tuja, exsin ewinnaj taꞌye kyuꞌn, ok ktzajil ẍchꞌiꞌn teꞌ tzmax toj twiꞌ ja, tuꞌn tbꞌijte kyuꞌnxjal. ");
INSERT INTO mamC_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Tuꞌnpetziꞌn, nxi nqꞌmaꞌn kyeꞌy, ayiꞌy wukꞌa, tuꞌn mina chi tzaj xobꞌa kyeꞌ xjal, a aku chi kubꞌ bꞌyoꞌn kyuꞌn. Quꞌn ntiꞌl aku bꞌant kyuꞌn, aj tkyimjo kyxmilila. ");
INSERT INTO mamC_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Me ok kxel nqꞌmaꞌn weꞌ kyeꞌy, alqe tuꞌn kytzaja xobꞌiꞌy. Chi xobꞌtziꞌn teꞌ, a at toklin tuꞌn kykyimxjal tuꞌn, ex at toklin tuꞌn kyxi qꞌoꞌnxjal tuꞌn toj qꞌaqꞌ te jun majx, aj tkyimjo kyxmilil. Twutzx te, antza chi xobꞌa kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kanqetzin kyeꞌ tal pichꞌ. ¿Ma nyatzin jweꞌ kyeꞌ tal kybꞌaj nkꞌayajtz tuꞌn kabꞌe tal pwaq? Me iꞌchaqx nya tal wiꞌyilqetz, mix aꞌlx junte n-el naj toj tkꞌuꞌj qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","¿Yajtziljo kyetza? Majqexpeꞌ jniꞌ tsmal kywiꞌy ajlaꞌnqemile tuꞌn Dios. Tuꞌnpetziꞌn, mina chi tzaj xobꞌ kyeꞌ, quꞌn tuꞌn nimxixtl kyeꞌ kyoklin kywutzjo txqan tal pichꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kxel nqꞌmaꞌn kyeꞌy jaꞌlin, chi Jesúsjo, ankye te mi kubꞌ tewin kywutzxjal, qa nimil wiꞌja, a ayiꞌn Tkꞌwal Ichin, ex ikyx wejiꞌy mi kubꞌ wewiꞌn twutz t-angel nMaꞌn, a at toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Me anteꞌ kꞌwel ewinte kywutzxjal qa ojtzqiꞌnqiꞌn tuꞌn, ex ikyx wejiꞌy, kꞌwel wewiꞌn twutz t-angel nMaꞌn, a at toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ex qa at jun xjal xjaw yolbꞌin wiꞌja, a ayiꞌn Tkꞌwal Ichin, okpe kꞌwel najsin teꞌ til tuꞌn Dios, qa ma tzꞌajtz tiꞌj tanmin tiꞌjjo til. Me anteꞌ, a k-elil ikyꞌin te Xewbꞌaj Xjan, nlayxpen kubꞌ najsit teꞌ til. ");
INSERT INTO mamC_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mina chi jaw bꞌisiꞌn, aj kyxi qꞌiꞌn tojjo muꞌẍ ja te kynabꞌl Judiy Dios, mo kywutzjo muchꞌ kawil mo kywutzjo nmaq kawil. Ex mi chi jaw luꞌliꞌn tiꞌj tiꞌ yol tuꞌn t-xi kyqꞌmaꞌn te kolbꞌil kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Quꞌn aj tpon kaniꞌn ambꞌil, a jaꞌ tuꞌn kyyoliniy, ate Xewbꞌaj Xjan ok ktzajil qꞌmante kyeꞌy tiꞌ tuꞌn t-xi kyqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","At junte xjal kyxoljo xjal, xi qꞌmante te Jesús kyjaluꞌn: Xnaqꞌtzil, qꞌmanxa te ntzikya tuꞌn ttzaj tyekꞌin alkye weꞌ wetzbꞌil, a at wokliꞌn tiꞌj, tiꞌjjo tqꞌinimil qtzan ntatiy. ");
INSERT INTO mamC_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Ay wukꞌa, ¿Ankye weꞌ ma tzꞌok qꞌonwe te kawil kyxola, tuꞌn tkubꞌ npaꞌnjiꞌy, a at kyeꞌy? ");
INSERT INTO mamC_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ex xi tqꞌmaꞌnl kyjaluꞌn: Kykaꞌyink kyibꞌa; mi pon kyeꞌ kykꞌuꞌj tiꞌj qꞌinimil, quꞌn nya tzmaxi ktenbꞌil kyejiꞌy kychwinqil, qa ma ten kyqꞌinimila. ");
INSERT INTO mamC_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ex kubꞌ tyolin Jesús jun techil kye. Chiꞌ kyjaluꞌn: Attaq jun xjal qꞌinin; nimxjo twutz tawal ttxꞌotxꞌ chmet. ");
INSERT INTO mamC_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Oktzin ten qꞌinintz ximil: ¿Tzeꞌntzin k-okile wuꞌn jaꞌlin? Quꞌn mix jaꞌ tuꞌn tokxi nkꞌuꞌnjiꞌy twutz wawala, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ex kubꞌ t-ximinl kyjaluꞌn: Ma tzul toj nnabꞌla tiꞌ tuꞌn tkubꞌ nbꞌinchiꞌn, chiꞌ. Ok chi kꞌwel nxitinjiꞌy jniꞌ ntxꞌutxꞌa, exsin ma tijqe chꞌintl kchi kꞌwel nbꞌinchiꞌn, tuꞌntzintla kykux bꞌajjo jniꞌxjo kywutz wawala kyoj, exsin jotxjo jniꞌ at weꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ex kxel nqꞌmaꞌn te wanmiꞌn kyjaluꞌn: Ay qꞌaye, nimx te tiꞌ ma kꞌuꞌyit te, te nimku abꞌqꞌe. Atziꞌn jaꞌlin, kuxsin tzꞌajlantza, kuxsin waꞌntza, kuxsin txꞌuꞌjte chꞌintza ex kuxsin tzalajtza. ");
INSERT INTO mamC_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Me atzin te Dios tzaj tqꞌmaꞌn tej qꞌinin kyjaluꞌn: Ay ntiꞌ tnabꞌla, texjo qnikyꞌin lo, ok kkyimila. ¿Anqe kyjele tqꞌonejiy a ma bꞌaj kꞌuꞌyit tuꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ikytzin tchwinqil jun qꞌinin, a noqx n-ok ten chmol txqan tqꞌinimil noqx te teku; me toj tanmin twutz Dios, manyor tal yajx. ");
INSERT INTO mamC_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tbꞌajlinxiꞌ ikyjo, tej t-xi tqꞌmaꞌnl Jesús kye t-xnaqꞌtzbꞌin, chiꞌ kyjaluꞌn: Kxel nqꞌmaꞌn kyeꞌy: Mina chi jaw melj kyeꞌ tiꞌjjo wabꞌj, a tuꞌn t-xi kywaꞌn, ex mina chi jaw melja tiꞌjjo kyxbꞌaliꞌn tuꞌn tok. ");
INSERT INTO mamC_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","¿Ma nya nimxixtl toklin kychwinqila tzeꞌnkuꞌ wabꞌj, exsin nyapela nimxixtl teꞌ kyxmilila tajbꞌin tzeꞌnkuꞌ kyxbꞌaliꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kykaꞌyinktzin kyejiꞌy kychwinqil joj: Mina nchi awan, ex mina nchi chmon twutz kyawal. Ntiꞌ jun kykꞌubꞌl te tkubꞌil kywa, ex ntiꞌ jun kytxꞌutxꞌ. Me ate Dios nxi qꞌonte kywa. ¿Yajtziljo kyetza? ¿Ma nyapela nimxtl kyeꞌ kyoklin kywutzjo jniꞌ joj? ");
INSERT INTO mamC_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Quꞌn mixpetzin tuꞌn chi ja meljtza, ¿Ma akutzin txi nimix toj kychwinqila nipela jun qꞌij? ");
INSERT INTO mamC_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Qatzin nlay bꞌant tuꞌn t-xi laqꞌe chꞌintljo kychwinqila kyuꞌn, ¿Tiꞌtzin quꞌniltz nchi jaw melja, tuꞌn tbꞌantjo a txqantl kyuꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kykaꞌyinktziꞌn tzeꞌn nchi chꞌiyeꞌ jniꞌ t-xmakil kꞌul. Mina nchi aqꞌnin ex mina nchi chubꞌin. Me kxel nqꞌmaꞌn kyeꞌy, qa a qtzan nmaq kawil Salomón ojtxe, tukꞌa tkyaqil tqꞌinimil, s-ok tktxuꞌn tibꞌ tukꞌa t-xbꞌalin tbꞌanilx wen; me mix kanine tqoptzꞌajiyil t-xbꞌalin, tzeꞌn kaꞌyiꞌn jun tal t-xmakil kꞌul. ");
INSERT INTO mamC_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Qatzin qa nchi ok tktxuꞌn Diostzjo tal t-xmakil kꞌul ikyjo, a loqe tzunx nchi milinx toj kojbꞌil jaꞌlin, me meljo nchiꞌj, bꞌeꞌx kchi kꞌwel bꞌolj tuꞌn qꞌaqꞌ; ¿Yajxsila kyetza? ¿Nyapela kchi okil ktxuꞌn kyeꞌ tuꞌn Dios? Quꞌn qa noq oꞌkxtza nchi bꞌisiniy tiꞌjjo tkyaqiljo lo, atzin nyekꞌine qa noq tal chꞌin kynimbꞌila. ");
INSERT INTO mamC_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tuꞌnpetziꞌn, mina chi jaw melj kyeꞌ noq tiꞌjjo tiꞌ tuꞌn t-xi kywaꞌn, ex noq tiꞌjjo tiꞌ tuꞌn t-xi kykꞌwaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Quꞌn ayetzin kyeꞌ txqantl xjal, a nya nimil, toj tkyaqil twutz txꞌotxꞌ, nimx nchi jaw melj kyeꞌ tiꞌj tkyaqiljo lo. Me metziꞌn kyetza, at jun kyeꞌ kyMan, a ojtzqiꞌn tuꞌn alkye atx taj kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kyjyomtziꞌn Tkawbꞌil qMan Dios, ex ok ktzajil tqꞌoꞌn tkyaqiljo at tajbꞌin kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mina chi tzaj xobꞌa. Nchin kaꞌyin kyiꞌja, quꞌn tal nritqiꞌy, a nya ilaꞌ tal kybꞌaja. Me noq tuꞌnjo twenil Manbꞌaj, a at toj kyaꞌj, nimx ntzalaj tuꞌn t-xi tqꞌoꞌn kyokliꞌn tojjo Tkawbꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kykꞌayinxjiꞌy tkyaqil at kyeꞌy, ex kyqꞌonxa kyeꞌ jniꞌ yaj. Ikytziꞌn kchmetila kyqꞌinimiljiꞌy twutz Dios toj kyaꞌj, a nlay bꞌaj. Tzꞌok tilil kyuꞌn tuꞌn tkubꞌ kybꞌinchinjiꞌy a taj Dios tzaluꞌn twutz txꞌotxꞌ, quꞌn atzin k-okiljo te kyqꞌinimila, a kꞌwel tkꞌuꞌn Dios toj kyaꞌj, a jaꞌ nlay tzꞌokxi ileqꞌ elqꞌil, ex nlay bꞌajjo qꞌinimil anetziꞌn tuꞌn pokꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Quꞌn jaꞌ taꞌyex kyqꞌinimila, axsa kxel lipeye kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kybꞌinchimtzin kyibꞌtza, ex kyktxunktzin kyibꞌtza, ex tukꞌa kytzaja nkꞌant wen. ");
INSERT INTO mamC_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Chi oka tzeꞌnqekuꞌ taqꞌnil jun xjal, a loqe nchi ayon tuꞌn toktz jqetjo tjpel ja, aj tmeltzꞌajjo tajaw aqꞌuntl toj jun mejebꞌlin. Jun paqx k-okitz jqon ja te, noq aj tok twokꞌchin. ");
INSERT INTO mamC_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jun tzaljbꞌilx teꞌ kyeꞌ taqꞌniljo xjal, aj qa itzꞌqe, ex qa nchi ayon, aj tpoꞌn tajaw aqꞌuntl. Kxel nkujsin kyeꞌy, aj qa bꞌeꞌx aku txi qꞌmaꞌn kyeꞌ tal aqꞌnil anetziꞌn tuꞌn tajaw aqꞌuntl, tuꞌn kyok qe waꞌl tiꞌj meẍ, ex axla tajaw aqꞌuntl aku txi sipinte kywa. ");
INSERT INTO mamC_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jun tzaljbꞌilx te kyeꞌ aqꞌnil, a qa itzꞌqe aj kyel jyet tuꞌn tajaw aqꞌuntl, jniꞌchaqxla ortz kanin, exla qa nikyꞌjin aqꞌwil mo chꞌixtaq qsqixj. ");
INSERT INTO mamC_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ex bꞌinkuxjo lo kyuꞌn, chi Jesúsjo: A noqit bꞌiꞌn te tajaw ja tuꞌn, jniꞌxix or kanin ileqꞌ elqꞌil toj tja, akula kubꞌ ten xqꞌuqilte, ex nlayla ttziye tuꞌn tetz elqꞌin toj tja. ");
INSERT INTO mamC_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ikytziꞌn kyetza jaꞌlin, kyxqꞌuqinkutzin kyetza kyibꞌ, quꞌn noqx kynabꞌinkuxa aj wula ayiꞌn, a Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Xitzin tqanin Pegr kyjaluꞌn: Taa, ¿Ma noqtzin qeꞌy ma tzaj tqꞌmanejiy techil lo, mo te tkyaqilxj? ");
INSERT INTO mamC_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chitzin Jesúsjo, a tAjaw Tkyaqil, kyjaluꞌn: ¿Ankye te kaꞌyil aqꞌuntl, a qꞌuqle tkꞌuꞌj tajaw aqꞌuntl tiꞌj, quꞌn tuꞌn njapin bꞌajxix taqꞌin? ¿Nyapela atz kyjel qꞌoꞌn nejinel kyibꞌajjo txqantl aqꞌnil, tuꞌn t-xi qꞌoyit kywa toj tumilxix? ");
INSERT INTO mamC_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nim tzaljbꞌilx teꞌ aqꞌnil te, a qa tzun nbꞌinchin tukꞌa tumil, aj tel jyet tuꞌn tajaw aqꞌuntl. ");
INSERT INTO mamC_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Twutzxix kxel nqꞌmaꞌn kyeꞌy, chi Jesúsjo, kxel tqꞌoꞌn tajaw ja toklin te nejinel tibꞌaj tkyaqiljo at te. ");
INSERT INTO mamC_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Metzin qa ajo aqꞌnil ma tzꞌok te nya wen, xkubꞌ t-ximin toj tanmin: Yajla tzul te tajaw ja, qa chiꞌ, ex k-okil ten yisol kyeꞌ txqantl aqꞌnil, ayeꞌ ichin ex qya, exsin qa bꞌeꞌx s-ok tentz waꞌl ex kꞌwal ex majxpe k-okil ten txꞌujtil. ");
INSERT INTO mamC_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Exsin noqx tnabꞌinkuxtz, aj tul kaniꞌn tajaw aqꞌuntl, quꞌn tuꞌn ntiꞌtaqx chꞌin bꞌiꞌn tuꞌn, tiꞌ qꞌijil ex jniꞌtaq or tuꞌn tul. Tuꞌnpetziꞌn, bꞌeꞌx kꞌwel kawin kujxix, ex bꞌeꞌx kxel xoꞌn te jun majx junx kyukꞌa xjal aj il, a mibꞌin chi nimin. ");
INSERT INTO mamC_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Atzin tej aqꞌnil, a n-el tnikyꞌ te, tiꞌxixjo taj tajaw aqꞌuntl, me mina nkubꞌ tbꞌinchin tibꞌ, ex mibꞌin nimin, ok kbꞌajil jikytzꞌin ilaꞌ maj. ");
INSERT INTO mamC_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Me atziꞌn teꞌ aqꞌnil, a nkubꞌ tbꞌinchin jun tiꞌla a at tilil, me nkubꞌ tbꞌinchin quꞌn tuꞌn mina n-el tnikyꞌ te, a qa nya bꞌaꞌn, ok kbꞌajil kawin, me nyala chꞌintl kxel jikytzꞌin teꞌ. Tuꞌnpetziꞌn, alkye teꞌ ma tzaj qꞌoꞌn chꞌintl te, ex nim chꞌintl teꞌ ktzajil tqanin Dios te. Ex alkye teꞌ ma nintz xi oqxenin, ex ma nintzx teꞌ ktzajil qanin te, chi Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ma chin ula tzaluꞌn twutz txꞌotxꞌ, tzeꞌnku jun qꞌaqꞌ njulin wen te kolbꞌil ex te joybꞌil qꞌoj kyxolxjal. ¡Me atla wajiꞌy noqit nkꞌant jaꞌlin! ");
INSERT INTO mamC_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nimx kyixkꞌoj kkyꞌelix wuꞌn, ex nimx bꞌis nnaꞌn jaꞌlin tzmax aj tjapin bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Tzeꞌntzintz toj kywutza? ¿Ma man chin kꞌuꞌl wetza noq tuꞌn kytzalajxjal tzaluꞌn twutz txꞌotxꞌ? Me twutzxix kxel nqꞌmaꞌn kyeꞌy, qa ¡Mina! Qalaꞌ ma chin kꞌuꞌl weꞌ noq tuꞌn tpaꞌyit kynabꞌlxjal. ");
INSERT INTO mamC_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tuꞌnpetziꞌn, texjo qꞌij jaꞌlin, nya junx t-xilin kynabꞌl jweꞌ xjal, a najleqe toj junx ja, quꞌn tuꞌn oxe mikyxil kynabꞌljo tzeꞌnqeku kabꞌel. Ex ayetzin kyeꞌ kabꞌel mikyxi chi nabꞌliꞌn tzeꞌnqeku oxel. ");
INSERT INTO mamC_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Okpe k-elil tiꞌjlin te manbꞌaj tkꞌwal, ex ikyx te kꞌwalbꞌajjo tiꞌj tman. Ex okpe k-elil tiꞌjlin tetxin ttxu, ex ikyx te txubꞌajjo tiꞌj tal. Ex okpe k-elil tiꞌjlinte ilibꞌj ilibꞌilte, ex ikyx te ilibꞌiljo tiꞌj tlibꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ex xi tqꞌmaꞌnl Jesús kyexjal kyjaluꞌn: Luꞌ jbꞌal tzul, chi chijiꞌy, tzeꞌnku nxi kykaꞌyiꞌn, aj qa ma tzaj qxope twutz kyaꞌj tuꞌn muj tumiljo jaꞌ n-exe qꞌij. Ex ikyx nbꞌajjo; bꞌeꞌx ntzaj jbꞌal. ");
INSERT INTO mamC_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ex nimx kyaq ktzajil jaꞌlin, chi chijiꞌy, aj qa antza saja kyqꞌiqꞌ kubꞌl. Ex ikyx te nbꞌajjo; nimx kyaq ntzaj. ");
INSERT INTO mamC_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Xmiletzꞌqiꞌy ikyjo! Quꞌn tuꞌn n-el kynikyꞌa tiꞌj tiꞌ tzul kyuꞌnjo techil, a nkyloꞌn twutz kyaꞌj exsin nkyloꞌn twutz txꞌotxꞌ. ¿Tzeꞌntzin tten mi n-el kynikyꞌtza kyiꞌjjo techil nbꞌant wuꞌn kyiꞌjjo tqꞌijil jaꞌlin? ");
INSERT INTO mamC_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Tiquꞌn mina nkubꞌ kyximin kyxolxa, alkyexixjo bꞌaꞌn tuꞌn tkubꞌ bꞌinchit? ");
INSERT INTO mamC_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Quꞌn qa ma txi qꞌiꞌn jun kyxola tuꞌn jun tajqꞌoj twutz kawil, i tok tilil tuꞌn, tuꞌn tkyij toj wen tukꞌa patilte, a naꞌmxtaq kykanin. Quꞌn qa mina, bꞌeꞌxsin kpomil qꞌintz tzmax twutz kawil, ex bꞌeꞌxsin kxel qꞌontz toj kyqꞌobꞌ xqꞌuqil tnam tuꞌnj kawil, tuꞌntzin tkuꞌx toj tze. ");
INSERT INTO mamC_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ok kxel nqꞌmaꞌn kyeꞌy, nlay jatz toj tze, aj qa mina xchjet tkꞌas tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Texjo qꞌij anetziꞌn, iteꞌ junjun xjal i pon kanin lol Jesús. Xitzin kyqꞌmaꞌn te, a qa iteꞌtaq junjun xjal aj Galiley otaq chi kubꞌ bꞌyoꞌn tuꞌn Pilat, ex qa otaq txi smoꞌn kychkyꞌel tukꞌa kychkyꞌel aluꞌmj, a otaq chi kubꞌ kybꞌyoꞌnj xjal anetziꞌn te chojbꞌil il twutz Dios. ");
INSERT INTO mamC_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Xitzin tqꞌmaꞌn Jesús kye kyjaluꞌn: ¿Ma man txi kynimin kyeꞌ, qa iky ma tzikyꞌ kyiꞌjjo ichin aj Galiley lo, tuꞌnpelaꞌ nimx chꞌintl kyil, tzeꞌnkuqeljo txqantl xjal teꞌ tnam anetziꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ok kxel nqꞌmaꞌn kyeꞌy, qa mina, chi Jesúsjo. Quꞌn ikyqex kyejiꞌy, ok chi kyimil kyeꞌ, qa mina s-ajtz tiꞌj kyanmiꞌn tukꞌa Dios. ");
INSERT INTO mamC_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yajqetzin kye wajxaqlajaj ichin toj tnam te Siloé, ayej i kyim, tej ttzaj yuchꞌj jun ja, a jun tijxtaq tweꞌ, kyibꞌaj. ¿Tzeꞌntzinla chꞌin kyeꞌ toj kywutz? ¿Ma tuꞌnpetzilaꞌ nimxixtl kyil tzeꞌnqekuljo txqantl xjal, ayeꞌ najleqetaq toj Jerusalén? ");
INSERT INTO mamC_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Twutzx kxel nqꞌmaꞌn kyeꞌy, qa mina, chi Jesúsjo. Quꞌn ikyqex kyejiꞌy, ex ok chi kyimil kyeꞌ, qa mina s-ajtz tiꞌj kyanmiꞌn tukꞌa Dios. ");
INSERT INTO mamC_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kubꞌ tyolin Jesúsjo techil lo kywutzxjal. Chiꞌ kyjaluꞌn: Jun ichin kux tawaꞌn jun tqan iw kyxol tawal. Atzaj teꞌ t-xiꞌ jyol jun twutz te tloꞌ, ntiꞌ knet tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tuꞌnpetziꞌn, xi tqꞌmaꞌntz te xqꞌuqil awal kyjaluꞌn: Oxe abꞌqꞌe ma jawil wuꞌn, a kukx nchin uljiꞌy jyolte jun nloꞌy tiꞌjjo tze lo, me mix jun n-el jyet wuꞌn. Tuꞌnpetziꞌn, txꞌeminksa. ¿Quꞌn tiꞌqe tkubꞌ te tzqijsil txꞌotxꞌ? ");
INSERT INTO mamC_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Xitzin ttzaqꞌwin tej ichin, a tzuntaq nxqꞌuqin tiꞌj awal. Chiꞌ kyjaluꞌn: Taa, qꞌonk juntl abꞌqꞌela; kꞌaꞌ jaw waqꞌnin weꞌ tiꞌjile, ex kꞌaꞌ tzꞌok nqꞌoꞌn weꞌ tzꞌis t-xe tqan. ");
INSERT INTO mamC_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Qapetla iky aku tzꞌele twutzjo; qatzin qa minatz, kꞌaꞌ jaw ttxꞌemintza. ");
INSERT INTO mamC_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jun majjo ikyjo, toj jun qꞌij te ajlabꞌl, otaq tzꞌok ten Jesús xnaqꞌtzil toj jun muꞌẍ ja te kynaꞌbꞌl Judiy Dios. ");
INSERT INTO mamC_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ex antza, taꞌtaq jun qya, a otaqxi bꞌaj wajxaqlajaj abꞌqꞌe tyabꞌtlin. Otaq tzaj kꞌolpaj tiꞌj tuꞌn jun taqꞌnil tajaw il, ex ntiꞌxtaq tumil tuꞌn tjikyimix tzkyel tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Atzaj teꞌ tiwle tuꞌn Jesús, bꞌeꞌxsin tzaj ttxkoꞌn, exsin xi qꞌmaꞌn te kyjaluꞌn: Ay qya, ma tzaqpaj te tojjo yabꞌil anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Bꞌeꞌxsin i kubꞌ tqꞌoꞌn Jesús tqꞌobꞌ tibꞌaj, ex texjo paq anetziꞌn, bꞌeꞌx jikyimix tej qya tzkyel tiꞌj, ex bꞌeꞌxsin ok tentz nimsil tbꞌi Dios. ");
INSERT INTO mamC_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Atzin tej kynejil xqꞌuqil muꞌẍ ja te kynaꞌbꞌl Judiy Dios bꞌeꞌx tzaj teꞌ tqꞌoj, quꞌn tuꞌn toj jun qꞌij te ajlabꞌl, kubꞌe tqꞌanin Jesúsjo qya. Xitzin tqꞌmaꞌn kyexjal kyjaluꞌn: Qaq qꞌij qꞌoꞌntz tuꞌn qaqꞌnin. Tuꞌnpetziꞌn, chi ul kyeꞌ qꞌanil kyibꞌa kyojjo qꞌij anetziꞌn, ex nya toj jun qꞌij te ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Xitzin ttzaqꞌwin Jesús, a tAjaw Tkyaqil, kyjaluꞌn: Xmiletzꞌqe kyeꞌ. ¿Ma ntiꞌnajtzin jun kyeꞌ n-el tzaqpinte jun twakix mo jun tchej toj qꞌij te ajlabꞌl, tuꞌn t-xi qꞌiyit kꞌwal aꞌ? ");
INSERT INTO mamC_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Yajtzin teꞌ qyatz lo, a tzajnintzx tyajil tiꞌj qtzan Abraham, exsin wajxaqlajajtaq abꞌqꞌe otaq tzꞌok xkye yabꞌil tiꞌj tuꞌn tajaw il? ¿Ma nyapetzila iltaq teꞌ tiꞌj, tuꞌn tel tzaqpet tjaqꞌ tyabꞌil toj qꞌij te ajlabꞌl? ");
INSERT INTO mamC_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bꞌeꞌx i jaw txꞌixwe kyej tajqꞌoj Jesús, tej tbꞌaj tyolin Jesúsjo tyol kye. Ayetzin kyeꞌ txqantl xjal, a iteꞌtaq antza, bꞌeꞌx i jaw tzalaj kyeꞌ, tej kylon teꞌ tbꞌinchbꞌin Jesús, a nimxix kyoklin. ");
INSERT INTO mamC_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Xi tqꞌmaꞌnl Jesús kyjaluꞌn: ¿Tzeꞌnxsilaꞌ Tkawbꞌil qMan Dios, ex anqukꞌa aku tzꞌoke qmujbꞌine? ");
INSERT INTO mamC_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ikytziꞌn tzeꞌnku jun tal twutz mistas, aj tkux tawin jun xjal toj txꞌotxꞌ. Ex ajtzin tchꞌiytz, kyinx njapine tweꞌ tzeꞌnku jun ma tij pujin tze, a jaꞌ n-okxi kybꞌinchin pichꞌ kypaqbꞌil kyxol tqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Xi tqꞌmaꞌn Jesús juntl majl kyjaluꞌn: ¿Anqukꞌa aku tzꞌok qmujbꞌineꞌ Tkawbꞌil qMan Dios? ");
INSERT INTO mamC_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Quꞌn iky te Diosjo Tkawbꞌil tzeꞌnkuꞌ ttxꞌamil wabꞌj, a nkux tqꞌoꞌn jun qya toj oxe malbꞌil jarin. Ex ajtzin tbꞌaj tsmoꞌn, tkyaqiljo tqꞌotjil wabꞌj ktxꞌamixil, ex nchꞌiy wen. ");
INSERT INTO mamC_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tej t-xiꞌ Jesús tzma Jerusalén, ikyꞌ xnaqꞌtzil kyexjal kyojile jniꞌ tnam ex kyojile jniꞌ kojbꞌil, a nqayintaq iteꞌke ttxlajile tbꞌe. ");
INSERT INTO mamC_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","At jun xjal xi qaninte te. Chiꞌ kyjaluꞌn: Taa, ¿Me nyala ilaꞌ te kkletil? Xitzin ttzaqꞌwin Jesús kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Kyqꞌonk kyeꞌ tilil tuꞌn kyokxa tojjo tal tjpel ja tal muchꞌ te chwinqil. Ex twutzx kxel nqꞌmaꞌn kyeꞌy, qa nimx xjal k-okil tilil kyuꞌn, tuꞌn kyokx, me nlay chi okx. ");
INSERT INTO mamC_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Quꞌn pon kanin jun te qꞌij, jaꞌ tuꞌn tjpete ja wuꞌn, a ayiꞌn tajaw ja. Me ayetzin kyetza, a kchi kyjela peꞌn, oktzin k-okix kyqꞌolbꞌin, ex chi chilajiꞌy kyjaluꞌn: Taa, jqonkxa ja qeꞌy. Me atzin weꞌ k-elitz ntzaqꞌwin kyjaluꞌn: Nya bꞌiꞌn wuꞌn jaꞌ tzajninqe kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Me ayetzin kyetza okla kchi okil teꞌn qꞌmalte kyjaluꞌn: Taa, ¿Ma nyatzin ma qo waꞌn, ex ma qo kꞌwaꞌn junx tukꞌiy? Ex ma qo bꞌaj t-xnaqꞌtziꞌn kyojjo jniꞌ bꞌe, a iteꞌ toj qtanima. ");
INSERT INTO mamC_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Me metzin weꞌ, a ayiꞌn tajaw ja, a k-elitz ntzaqꞌwiꞌn kyjaluꞌn: Ma txi nqꞌmaꞌn kyeꞌy, qa nya bꞌiꞌn wuꞌn jaꞌ tzajninqiꞌy. Tuꞌnpetziꞌn, kypaꞌmil kyibꞌa wiꞌja, ayiꞌy, bꞌinchil il. ");
INSERT INTO mamC_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aj kybꞌintejiꞌy jniꞌ yol lo, okxpetzin kchi oqꞌiltza, ex okxpetzin kchi juꞌchꞌil kystetza tuꞌn nimx kyixkꞌoj, quꞌn oꞌkqex Abraham, Isaac, Jacob ex kykyaqiljo jniꞌ yolil Tyol Dios ojtxe, ok kchi kylabꞌila tojjo Tkawbꞌil qMan Dios. Me ayetzin kyetza axsa kchi kyjela tzaqpiniy peꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iteꞌ xjal kyjaꞌ kchi tzajile jawnix, kumnix, elnix ex oknix, ex ok kchi ul, tuꞌntzin kyoq qetz waꞌl tiꞌj meẍ tojjo Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kyojjo qꞌij anetziꞌn, iteꞌ junjunkye, a njaw kynimsin kyibꞌ jaꞌlin, me nlay tzaj qꞌoꞌnljo kyoklin te tnejil. Ex iteꞌ junjuntl, a nyakuj ntiꞌ kyoklin jaꞌlin, me nimxix kyoklin ktzajil qꞌoꞌn kyojjo qꞌij anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ex texjo paq anetziꞌn i pon kanin jun jteꞌbꞌin Parisey tkꞌatz Jesús, exsin xi kyqꞌmaꞌn kyjaluꞌn: Kux tzꞌexa tojjo tnam lo, quꞌn taj Herodes tuꞌn tkubꞌ bꞌyoꞌn tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Kux cheꞌxa, ex kꞌaꞌ txi kyqꞌmaꞌn te Herodes, a sbꞌulxix tnam, qa jaꞌlin ex nchiꞌj ok kchi elitz taqꞌnil tajaw il wuꞌn toj kyanminxjal, ex qa ok kchi kꞌwel nqꞌaniꞌn yabꞌ. Ex kabꞌjxi japin bꞌaj wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Me twutzxix, qa il tiꞌj tuꞌn t-xi wiꞌn wibꞌa, quꞌn tuꞌn il tiꞌj tuꞌn nkaniꞌn nchiꞌj mo kabꞌj tzma Jerusalén, quꞌn nlay kyim jun te xjal, a tok toklin te yolil Tyol Dios, toj junxil tnam. ");
INSERT INTO mamC_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ex chi Jesúsjo kyjaluꞌn kyiꞌjxjal te Jerusalén: ¡Ay! Jerusalén, Jerusalén, ay bꞌiyil kyiꞌj yolil Tyol Dios, ex nchi ok kyxoꞌnjiꞌy tsan qMan tukꞌa abꞌj; jteꞌlixla majxla ẍin bꞌaj labꞌtiy kyiꞌja, tuꞌn kytzaj laqꞌey nkꞌatza, tzeꞌnku jun ttxu ekyꞌ nchi kubꞌ tpaqin tal tal tjaqꞌ t-xikyꞌ, me mi xkytziyiy ikyjo. ");
INSERT INTO mamC_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kykaꞌyinktzinjiꞌy kynajbꞌila kyjel naj te jun majx. Twutzxix kxel nqꞌmaꞌn kyeꞌy, texjo qꞌij jaꞌlin, mixla chin kylaꞌbꞌilix jun majla, qa nya ajxi tpon tqꞌijil aj kyqꞌmantiy: Kyꞌiwlinxix teꞌ, a tzul toj tbꞌi qAjaw. ");
INSERT INTO mamC_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Toj jun qꞌij te ajlabꞌl, okx Jesús waꞌl toj tja jun xjal nejinel kyxol Parisey. Me iteꞌtaql txqantl Parisey nchi kaꞌyin tiꞌj, tiꞌtaqjo tuꞌn tkubꞌ tbꞌinchin toj tqꞌijil ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ex antza taꞌyetaql jun xjal, a yabꞌtaq tuꞌn malil. ");
INSERT INTO mamC_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Xitzin tqanin Jesús kyeꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil junx kyukꞌa jniꞌ Parisey. Chiꞌ kyjaluꞌn: ¿Bꞌaꞌnpela toj kywutza, tuꞌn tkubꞌ qꞌanit jun yabꞌ toj qꞌij te ajlabꞌl, mo minaj? ");
INSERT INTO mamC_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Me ayetzin kyej xjal anetziꞌn, noq i kubꞌ mutxe tuꞌn. Atzin te Jesús bꞌeꞌx tzaj ttzyuꞌn yabꞌ, ex bꞌeꞌx kubꞌ tqꞌanin. Atzaj teꞌ tqꞌanit, xi tqꞌmaꞌn Jesús te tuꞌn taj tja. ");
INSERT INTO mamC_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ex xi tqꞌmaꞌn kye Parisey kyjaluꞌn: ¿Altzin jun kyeꞌ, a nya bꞌeꞌxkux aku jatz qꞌinte jun tkꞌwal mo jun twakix, a kuxit tzꞌaq toj jun jul, exla qa toj qꞌij te ajlabꞌl? ");
INSERT INTO mamC_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ex mix aꞌlx jun tzaj tzaqꞌwinte jun tyol. ");
INSERT INTO mamC_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tlonte te Jesús, qa ataq kyajjo jniꞌ txokenj, tuꞌn kykubꞌ qe kyibꞌajjo tbꞌanil qꞌuqbꞌil, a iteꞌkutaq kyiꞌjile meẍ te wabꞌl. Tuꞌntziꞌn, xi tqꞌoꞌn jun tumil kye, tuꞌn mi kynimsinxjal kyibꞌ: ");
INSERT INTO mamC_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Aj qa at jun xi txkontiy toj jun nintz qꞌij te mejebꞌlin, nya bꞌaꞌn tuꞌn tkubꞌ qey tibꞌaj jun tbꞌanil qꞌuqbꞌil, quꞌn yajtzaj qa xpon kaninku juntl txokenj, a nim chꞌintl toklin tzeꞌnku te, ");
INSERT INTO mamC_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ex atziꞌn xjal, a xtxokin kyiꞌja kykabꞌila, aku tzaj qꞌmante tey kyjaluꞌn: ¡Weꞌksa! Qꞌonx tqꞌuqila teljo juntl lo chitjo tey. Ex tukꞌatzin ttxꞌixewtza, bꞌeꞌx aku txiꞌy qebꞌil twiꞌ qꞌuqbꞌil, a at tzma tiꞌjxi. ");
INSERT INTO mamC_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Qalaꞌ qa ma txi txkon tuꞌn jun aꞌla, antza we kubꞌe qe te kyibꞌajjo qꞌuqbꞌil, a iteꞌku tzma tiꞌjxi, quꞌn tuꞌntzin aj tuljo a xi txkontiy, aku tzaj qꞌmaꞌn tey kyjaluꞌn: Ay wukꞌa, ku tikyꞌtz te qebꞌil kyibꞌajjo tbꞌanil qꞌuqbꞌil loch. Ikytzin kjawil nimsinjiꞌy kywutzjo jniꞌ txqantl xjal, a kchi okil qe tukꞌiy tiꞌj meẍ. ");
INSERT INTO mamC_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Quꞌn ankye teꞌ kjawil tnimsin tibꞌ til tibꞌx, ntiꞌ chꞌin teꞌ toklin aku tzaj qꞌoꞌn toj kyaꞌj. Me metzin teꞌ xjal, a n-ok tqꞌoꞌn tibꞌ te ntiꞌ toklin, apente xjaljo ok kjawil nimsin. ");
INSERT INTO mamC_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ex ikyx xi tqꞌmaꞌn Jesúsjo te Parisey, a xi txkonte, tuꞌn t-xiꞌ tja. Chiꞌ kyjaluꞌn: Aj tbꞌaj jun nim waꞌn toj tjay, mina chi tzaj ttxkoꞌnjiy jniꞌ tukꞌiy, ex mina qeꞌ jniꞌ ttzikya ex titzꞌiꞌn ex qeꞌ jniꞌ xjal, a at tlonte tibꞌa kyukꞌa, exqetziꞌn jniꞌ t-xjalila tiꞌjiliy, a qꞌininqe. Quꞌn aye xjal lo, bꞌeꞌx aku txi txkoꞌnla waꞌl kyukꞌa, tuꞌntzin bꞌeꞌx kchjetiljo wabꞌj, a otaq txi toyiꞌn kye. ");
INSERT INTO mamC_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mikyxi tzꞌoka tuꞌn; qalaꞌ aj tkubꞌ tikyꞌsin te jun nintz qꞌij toj tjay, txkonqetz tejiy jniꞌ qe xjal yaj, jniꞌ qe xjal, ayeꞌ mi nbꞌantl kybꞌet, jniꞌ qe kox exqetziꞌn moẍ. ");
INSERT INTO mamC_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tuꞌn ikyjo, nimx tzeꞌjbꞌil ktenbꞌil tey, quꞌn exla qa nlay bꞌant tchjetjo wabꞌj, a kxel toyin kye xjal anetziꞌn, me nimxix tumil t-xel ok ktzajil qꞌoꞌn tey tuꞌn Dios tojjo qꞌij, jaꞌ kchi jawitze anqꞌin juntl majljo xjal, a tzꞌaqleqe. ");
INSERT INTO mamC_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tej kybꞌij teꞌ yol lo kyuꞌn xjal, a qꞌuqleqetaq tiꞌj meẍ, at junte, xi qꞌmaꞌnte te Jesús kyjaluꞌn: ¡Kyꞌiwlinxla teꞌ xjal, a ok k-okil qe waꞌl tiꞌjjo meẍ, a ok ktenbꞌil toj Tkawbꞌil qMan Dios! ");
INSERT INTO mamC_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Jun ichin kubꞌ tbꞌisin tuꞌn tkubꞌ bꞌinchit jun nim waꞌn toj tja, exsin xi tqꞌoꞌn txokbꞌil kyiꞌj nimku xjal. ");
INSERT INTO mamC_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Atzaj teꞌ tpon or tuꞌn tbꞌaj waꞌn, xitzin tchqꞌoꞌn jun taqꞌnil txkol kyeꞌ jniꞌ xjal, a otaq chi txket. Chiꞌ kyjaluꞌn: Kux chi tzaja jaꞌlin, quꞌn luꞌ te wabꞌj ma bꞌant, chichkujiꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Me kykyaqilxjo txokenj i qꞌmante qa ntiꞌtaq ambꞌil kyiꞌj tuꞌn kykanin tojjo nintz waꞌn. Atzin teꞌ tnejil iky tqꞌma kyjaluꞌn: Chjonte te, me nlay chin kaniꞌn, tzmaxix ma nloqꞌa chꞌin ntxꞌotxꞌa, ex il tiꞌj tuꞌn nxiꞌy lolte; noqx cheꞌwx tkꞌuꞌja wiꞌja, chichkujiꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Atzin teꞌ juntl iky teꞌ tqꞌma kyjaluꞌn: Nlay chin kanin weꞌ, quꞌn ma nloqꞌa jweꞌ muj nwakixa te kjol, ex ma chink chꞌin lolkye qa bꞌaꞌn chi kjon; noqx cheꞌwx tkꞌuꞌja wiꞌja, chichkujiꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iky teꞌ juntl tqꞌma kyjaluꞌn: Tzmaxix ma chin jaw meje weꞌ. Tuꞌntziꞌn, nlay chin pon kanin weꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tej tmeltzꞌaj aqꞌnil, a xi chqꞌoꞌn, bꞌeꞌxsin ok tentz qꞌmalte teꞌ tajaw ja jotxjo jniꞌ tzaj qꞌmaꞌn te. Tuꞌn ikyjo, bꞌeꞌx tzaj tej tajaw ja tqꞌoj, exsin xi tqꞌmaꞌnltz tej taqꞌnil kyjaluꞌn: Liweyxix kux txiꞌy toj tnam ex txkonqetzjiy jniꞌ qeꞌ xjal yaj, jniꞌ qeꞌ xjal, a mi nbꞌant kybꞌet, jniꞌ qeꞌ xjal moẍ exqetziꞌn jniꞌ xjal kox, a iteꞌ kyojileꞌ nim bꞌe ex kyojileꞌ muchꞌ bꞌe, a iteꞌ antza. ");
INSERT INTO mamC_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tmeltzꞌajxitziꞌn aqꞌnil, iky xi tqꞌmaꞌn te tajaw ja kyjaluꞌn: Taa, ma chin meltzꞌaj weꞌ jaꞌ ẍin xi tchqꞌoniy, ex iky xkubꞌ nbꞌinchinjiꞌy tzeꞌn saj tqꞌmaꞌn, me naꞌmx tok noj te meẍ tiꞌjile. ");
INSERT INTO mamC_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Xitzin tqꞌmaꞌnljo tajaw ja teꞌ taqꞌnil kyjaluꞌn: Kux txitla kyojjo jniꞌ nim bꞌe ex kyojjo jniꞌ tqꞌobꞌ bꞌe, ex qꞌmanxa kyeꞌ xjal, qa il tiꞌj tuꞌn kyoktz, quꞌn waj weꞌ tuꞌn tnoj njaꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Quꞌn twutzxix kxel nqꞌmaꞌn kyeꞌy, qa mix jun teꞌ xjal kyxoljo ẍi txket wuꞌn te tnejil, ok kchi waꞌl tiꞌjjo wabꞌj, a ma bꞌant wuꞌnch, chi Jesúsjo kyexjal. ");
INSERT INTO mamC_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nimku xjal ok lipe tiꞌj Jesús, ex ajtz meltzꞌaj tiꞌjxi, ex xi tqꞌmaꞌn kye kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Qa at jun xjal taj tuꞌn tok lipe wiꞌja, me nya kꞌuꞌjlinkqiꞌn tuꞌn tukꞌa tkyaqil tanmin, qalaꞌ oꞌkxtza toka tkꞌuꞌj tiꞌj tman, tiꞌj ttxu, tiꞌj t-xuꞌjil, kyiꞌjqe tkꞌwal, kyiꞌjqe ttziky ichin ex qya, kyiꞌjqe titzꞌin ichin ex qya, mo qa axsa qꞌuqle tkꞌuꞌj tiꞌjx; nlay tzꞌokjo xjal anetziꞌn te nxnaqꞌtzbꞌiꞌn, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ex alkye jun xjal mi xi tqꞌoꞌn tibꞌ tuꞌn t-xi lipe wiꞌja toj tkyaqil, exla qa ma kyim tzeꞌnqeku xjal, ayeꞌ xi kyiqin kycruz tuꞌn kykyim, ntiꞌ toklin tuꞌn tok te weꞌy, chi Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Qa at jun kyeꞌ taj tuꞌn tjaw tbꞌinchin jun ja, a ma tijxix tweꞌ, ¿Ma nyapela nej kꞌwel qe ximilte jniꞌ pwaq kbꞌajil tuꞌn, exsin kꞌwel tnabꞌlintz qa ok kkanilxixjo tpwaq at? ");
INSERT INTO mamC_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Me me qa oꞌkxjo tqꞌuqil ja xbꞌant, exsin mina xjapin bꞌantjo jniꞌ txqantl, jotxjo jniꞌ xjal, a nchi kaꞌyink tiꞌjjo aqꞌuntl anetziꞌn, noqx kchi jawil xmayinx tiꞌjjo xjal luꞌn, tuꞌn mina xjapin bꞌaj taqꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Chi chilaꞌ kyjaluꞌn: Ax teꞌ xjal chiꞌ, ma tzyetnajjo tbꞌinchajtz tja, me mina xjapin bꞌaj tuꞌn, chi chilaꞌ. Ikytziꞌn, il tiꞌj tuꞌn tkubꞌ kyximiꞌn wen qa tuꞌn kyxi lipey wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ex ikyxjo, qa at jun nmaq kawil tibꞌaj jun ma tij tnam, taj tuꞌn tjyon qꞌoj tukꞌa juntl nmaq kawil, ¿Ma nyapetzila nej kꞌwel qe ximilte, aj qa tukꞌa lajaj mil xoꞌl qꞌaqꞌ, aku xkye tiꞌjljo tajqꞌoj, a lipche winqin mil xoꞌl qꞌaqꞌ tiꞌj? ");
INSERT INTO mamC_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Exsin aj tkubꞌ tnabꞌlin qa nlay xkye tiꞌjjo tajqꞌoj, bꞌeꞌx aku chex tchqꞌoꞌn jteꞌbꞌin tsan qꞌmalte te tajqꞌoj, a naꞌmtaq chꞌintl kyul kanin, tuꞌn tel kynikyꞌ tiꞌ kyaj tuꞌn tchewxjo qꞌoj. ");
INSERT INTO mamC_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tuꞌnpetziꞌn, qa at jun kyeꞌ tkyꞌeꞌ tuꞌn tkyij ttzaqpiꞌn tkyaqil at te, nlayxpetzin tzꞌok teꞌ te nxnaqꞌtzbꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tbꞌanilx te atzꞌin. Me qa ma tzꞌel najjo tpitzꞌmejiltz, ntiꞌlxla tajbꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Quꞌn qa ntiꞌ aku tzꞌokine atzꞌin, nlay tzꞌokin te txꞌotxꞌ, ex nlay tzꞌokin te tzꞌis. Oꞌkxjo noq tuꞌn t-xi xoꞌyit. Ankyeꞌ iteꞌ tẍkyin, in tok tbꞌiꞌn nyola, ex in tkubꞌ tbꞌinchin. ");
INSERT INTO mamC_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jotqexjo jniꞌ xjal, a nya wenqe kywutz txqantl, junx kyukꞌaꞌ ayeꞌ nchi peyin pwaq tuꞌn tajbꞌin kye aj Rom, i xi laqꞌe bꞌil teꞌ Tyol Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tuꞌn ikyjo, nimx i jaw yolbꞌin Parisey tiꞌj Jesús junx kyukꞌa xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Chi chiꞌ kyjaluꞌn: Ajo maꞌ xjal lo, nchi tkꞌmoꞌn jniꞌ xjal aj il, exsin nwaꞌntz kyukꞌa, chi chiꞌ kyxolile. ");
INSERT INTO mamC_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tuꞌnpetziꞌn, kubꞌ tyolin Jesúsjo jun techil lo kyexjal. Chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Altzin jun kyeꞌ, a atit jun jweꞌ kꞌal trit exsin txi najit juntz, ¿Ma nyapetzila nej kchi okil tchmoꞌn bꞌeljajlajaj toj jweꞌ kꞌal trit, tuꞌn kywaꞌn junx toj chqꞌajlaj, exsin kxeꞌltz jyol teꞌ tal trit, a otaq txi naj? ¿Ex ma nyapetzila tzmaxi kmeltzꞌajiljo aj tjyet tuꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ex ajtzin tjyettz tuꞌn, nimx kjawil tzalaj, ex kjawix tqꞌoꞌn tiꞌj tqul. ");
INSERT INTO mamC_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Exsin aj tkanintz tja, bꞌeꞌx aku chi tzaj ttxkoꞌn jniꞌ tukꞌa exqetziꞌn jniꞌ t-xjalil tiꞌjile, ex okla kxel tqꞌmaꞌn kyjaluꞌn: Chi tzalaja wukꞌiy, quꞌn ma knet tej tal nrita, a otaq txi naj. ");
INSERT INTO mamC_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Noq jun techil teꞌ lo, chi Jesúsjo. Me kxel nqꞌmaꞌn kyeꞌy, qa nimxixtl teꞌ tzaljbꞌil kbꞌajil toj kyaꞌj tiꞌj jun aj il qa ma nimin, tzeꞌnkuljo kyiꞌjjo bꞌeljajlajaj toj jweꞌ kꞌal xjal, a bꞌaꞌn kyten toj kywutz. ");
INSERT INTO mamC_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Lu juntl techil lo, chi Jesúsjo: Qa at jun qya, a atit lajaj tpwaq a saqpwaq, txi najit jun, ¿Ma nyapetzila bꞌeꞌx aku jaw ttxqoꞌn ttzaj? ¿Ex ma nyapetzila bꞌeꞌx k-okil ten misolte toj tja, ex chebꞌe k-okil ten jyol teꞌ tpwaq? ");
INSERT INTO mamC_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Exsin aj tjyettz tuꞌn, ok chi tzajil ttxkoꞌn jniꞌ tukꞌa exqetziꞌn jniꞌ t-xjalil tiꞌjile, ex ikyla aku txi tqꞌmaꞌn kye kyjaluꞌn: Chi tzalaja junx wukꞌiy, quꞌn tuꞌn ma jyet tej npwaqa, a otaq txi naj. ");
INSERT INTO mamC_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Oktzin kxel nqꞌmaꞌntza kyeꞌy, chi Jesúsjo, qa ikyx teꞌ toj kyaꞌj; nimx te tzaljbꞌil nten kyxol t-angel Dios, tiꞌj jun aj il qa ma nimin. ");
INSERT INTO mamC_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ex at juntl tyol Jesús bꞌaj tqꞌmaꞌn. Chiꞌ kyjaluꞌn: At jun xjal attaq kabꞌe tkꞌwal. ");
INSERT INTO mamC_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Atzin teꞌ muchꞌtaq chꞌintl iky xi tqꞌmaꞌn te tman kyjaluꞌn: Taa, qꞌontzinjiy weꞌ wetzbꞌil, a at wokliꞌn tiꞌj, chiꞌ. Kubꞌtzin tpaꞌn manbꞌajtz jotxjo jniꞌ tqꞌinimil kyxoljo tkꞌwal. ");
INSERT INTO mamC_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nyataq ilaꞌ qꞌij otaq tzikyꞌ, tej t-xi tkꞌayin tej itzꞌinbꞌaj ajo tetzbꞌil, a otaq tzaj qꞌoꞌn, exsin bꞌeꞌx xiꞌtz toj junxil nmaq tnam najchaq wen. Ex antza bꞌaje tyajineꞌ jotxjo jniꞌ pwaq, a otaq tzaj qꞌoꞌn te, tej t-xi tkꞌayin tetzbꞌil, quꞌn noqx ok ten achil tojjo nya bꞌaꞌn te twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Me atzaj teꞌ tel bꞌajjo tpwaq, ul kanin nim waꞌyaj tojjo tkyaqil nmaq tnam anetziꞌn. Tuꞌnpetziꞌn, nimx waꞌyaj ikyꞌx tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Xiꞌtzintz jyol jun taqꞌin tukꞌa jun ichin, a antza najletaq tojjo tnam anetziꞌn. Tzaj qꞌoꞌn tetz taqꞌin me noq te kyikꞌlel kyiꞌj kuch. Bꞌeꞌxsin xi chqꞌoꞌntz tzmax toj kojbꞌil, jaꞌ iteꞌyetaqjo kuch. ");
INSERT INTO mamC_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tzunxtaqx npon tkꞌuꞌj tiꞌjjo kykꞌwaꞌ kuch n-ok, quꞌn tuꞌn tzunxtaqx nqꞌaqꞌin tkꞌuꞌj wen, me mix aꞌlxtaq jun xjal ntzaj qꞌonte chꞌin twa. ");
INSERT INTO mamC_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Bꞌeꞌxpetzin ul julkꞌajxtz toj tkꞌuꞌj, ex chiꞌ kyjaluꞌn: ¿Jteꞌxsin aqꞌnil at toj tja nmaꞌn, a mina nbꞌajxjo kywa? Ex ayintzinl wetza chꞌix wel kyima tuꞌn waꞌyaj tzaluꞌn kyxol kuch. ");
INSERT INTO mamC_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tunpetziꞌn, ok chin ajil meltzꞌajla toj tja nmaꞌn, ex kxel nqꞌmaꞌn te kyjaluꞌn, aj npon kaniꞌn: Taa, ma chin bꞌinchinx weꞌ il twutz Dios ex ikyxjo twutza; ");
INSERT INTO mamC_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ntiꞌl weꞌ woklin tuꞌn wokla te tkꞌwala; qalaꞌ iky chin tqꞌonkejiꞌy tzeꞌnku jun taqꞌnila. ");
INSERT INTO mamC_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bꞌeꞌxkux kubꞌ bꞌe tuꞌn, tuꞌn tpon kanin juntl majl toj tja tman. Me naꞌmxtaq tuꞌn tpon kanin, tej tiwle tuꞌn tman. Bꞌeꞌx tzaj qꞌaqꞌin tej manbꞌaj tkꞌuꞌj tiꞌj. Tuꞌntziꞌn, bꞌeꞌx xi rinin kꞌlelte; ok tchleꞌn, exsin el tmaꞌtzin. ");
INSERT INTO mamC_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Atzin tej kꞌwalbꞌaj iky xi tqꞌmaꞌn kyjaluꞌn: Taa, ma chin bꞌinchinx weꞌ il twutz Dios ex ikyxjo twutza; ntiꞌl we woklin tuꞌn wokla te tkꞌwala. ");
INSERT INTO mamC_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Me atzin tej manbꞌaj bꞌeꞌx xi tqꞌmaꞌnkye taqꞌnil kyjaluꞌn: Jun paqx kyinktzjiꞌy a tbꞌanil xbꞌalin, ex kyqꞌonka tiꞌj. Ex kyqꞌonka jun xmilqꞌobꞌaj tbꞌanilx wen tiꞌj twiꞌ tqꞌobꞌ, ex kyqꞌonqekjiꞌy t-xjabꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ex kyintzjiꞌy tal wakx, a maꞌ qꞌeꞌsxix, exsin kybꞌyonkutza. Okxpetzin qo waꞌlxte, ex ok qo ikyꞌsil nintz qꞌij, ");
INSERT INTO mamC_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","quꞌn atzin nkꞌwala lo, kyimnintaq toklin quꞌn, me ma jaw itzꞌje juntl majl. Otaq txi naj, me atzin jaꞌlin, ma jyetl quꞌn. Bꞌeꞌxsin ok tentz ikyꞌsil nintz qꞌij. ");
INSERT INTO mamC_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ataqtzin tej itzikybꞌaj, attaq teꞌ toj kojbꞌil. Atzaj teꞌ tmeltzꞌaj, exsin ul kanin nqayin tkꞌatz ja, xi tbꞌiꞌn tqꞌajqꞌojil chnabꞌ, ex tbꞌi qa tzuntaq nchi bꞌixin xjal tuja. ");
INSERT INTO mamC_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tzajtzin tqꞌolbꞌintz jun taqꞌnil ttata, exsin xi tqanin tiꞌtaqjo nbꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Iky xi tqꞌmaꞌn aqꞌnil te kyjaluꞌn: Qalaꞌ a tej titzꞌin ma tzul, ex quꞌn tuꞌn bꞌaꞌn s-ula, bꞌeꞌx saj tqꞌmaꞌn ttatiy, tuꞌn tkubꞌ bꞌyetjo a ma qꞌeꞌs tal wakx. ");
INSERT INTO mamC_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Bꞌeꞌxpetzin tzajx tej itzikybꞌaj tqꞌoj tuꞌn ikyjo, ex mixtaq ttziye tuꞌn tokx tuja. Tuꞌnpetziꞌn, bꞌeꞌx etzjo ttata kubꞌsil twutz te, tuꞌn tokx. ");
INSERT INTO mamC_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Iky xi tqꞌmaꞌn te ttata kyjaluꞌn: Mi n-el nnikyꞌa te. Bꞌiꞌn te tuꞌn, jteꞌxitzin abꞌqꞌe o chin ajbꞌiꞌn tey, ex mix jun maj o chin jawa nim twutza. Ex ntiꞌx chꞌin o tzaj tqꞌoꞌn weꞌy iꞌchaqpetla jun tal tal chivtz, tuꞌn wikyꞌsiꞌn nintz qꞌij kyukꞌa wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Qalatziljo, ma kubꞌ tbꞌyonjiy ma qꞌeꞌs tal wakx te ikyꞌsbꞌil, teꞌ tulin tkꞌwala, a ma bꞌaj tyajinxjo tpwaqa kyukꞌa tkyꞌaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Xitzin ttzaqꞌwin manbꞌaj kyjaluꞌn: Ay nkꞌwal, luꞌ te majx at wukꞌiy, ex te tejiy jotxjo jniꞌ at weꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Me il tiꞌj tuꞌn tkubꞌ ikyꞌsit jun nintz qꞌij jaꞌlin, ex bꞌaꞌn tuꞌn qtzalaj, quꞌn tuꞌn ma jaw anqꞌin juntl majljo titzꞌiꞌn, a kyimnintaq toklin quꞌn; otaq txi naj, me ma jyetl jaꞌlin, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kubꞌ tqꞌmaꞌn Jesús jun techil kye t-xnaqꞌtzbꞌin kyjaluꞌn: Attaq jun xjal n-aqꞌnintaq te kaꞌyilte taqꞌin jun qꞌinin. Me bꞌeꞌx xtaj patbꞌaj kyuꞌnxjal teꞌ tajaw aqꞌuntl, quꞌn tuꞌn otaq tzꞌok ten yajil teꞌ tqꞌinimil tajaw aqꞌuntl. ");
INSERT INTO mamC_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tzajtzin txkoꞌn tej kaꞌyil, exsin xi qꞌmaꞌntz te kyjaluꞌn tuꞌn tajaw aqꞌuntl: ¿Tzeꞌntzin tzꞌelpine a ma bꞌaj kyqꞌmaꞌnxjal weꞌy tiꞌja? Qꞌonqetzjiy jniꞌ uꞌj nchi ajbꞌin tuꞌn, ex qꞌmantza tzeꞌn taꞌye jniꞌ aqꞌuntl, quꞌn atziꞌn jaꞌlin nlay tzꞌokla teꞌ kaꞌyilte waqꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bꞌeꞌx kubꞌ mutxe tej kaꞌyil aqꞌuntl ximilte. Chiꞌ kyjaluꞌn toj tnabꞌl: ¿Tiꞌtzila wetza kꞌwel nbꞌinchiꞌn jaꞌlin, qa ma tzꞌel qꞌin waqꞌiꞌn lo tuꞌn tajaw aqꞌuntl? Ntiꞌ weꞌ wipin tuꞌn taqꞌnit txꞌotxꞌ, ex bꞌeꞌx aku chin tzaj txꞌixwiꞌy tuꞌn nxiꞌy moꞌl. ");
INSERT INTO mamC_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Me ma tzul wetza jun tumil toj nnabꞌl: Ok chin jyol weꞌ kyiꞌj txqan wukꞌiy, tuꞌntzintla nkubꞌ wutzliꞌn kyuꞌn toj kyja, aj qa mataqx tzꞌel qꞌiꞌn waqꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","I tzajtzin ttxkoꞌn tej kaꞌyil aqꞌuntl jotqexjo jniꞌ xjal, a attaq kykꞌas teꞌ tajaw aqꞌuntl; junjunku i txokle tuꞌn. Iky xi tqaniꞌn teꞌ tnejil kyjaluꞌn: ¿Jteꞌtzin te tkꞌas te tajaw aqꞌuntl? ");
INSERT INTO mamC_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bꞌapetzin wetza, jun jweꞌ kꞌal ma tij ẍoqꞌ aseyt weꞌ nkꞌas, chiꞌ. Twutzx, chtej kaꞌyiltaq aqꞌuntl, quꞌn ikyxjo tzꞌibꞌin toj uꞌjch. Qekuy jaꞌlin, exsin bꞌinchinkul juntl tuꞌja, nya jun jweꞌ kꞌal tkꞌasa kꞌwelix tqꞌon, qalaꞌ noq lajaj toj ox kꞌal. ");
INSERT INTO mamC_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Xitzin tqaniltz te juntl kꞌasbꞌinel. Chiꞌ kyjaluꞌn: ¿Yajtziꞌn te, jteꞌtzin te tkꞌas? Atziꞌn weꞌ jun jweꞌ kꞌal milon triy weꞌ nkꞌas, chiꞌ, te txi ttzaqꞌwin. Luꞌ te tuꞌjil tkꞌas lo, chtej kaꞌyiltaq aqꞌuntl. Me txꞌixpinksa, oꞌkx jun mutxꞌ ktzajil tchjoꞌn, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tej tbꞌinte ex ok tkaꞌyin tajaw aqꞌuntl, bꞌeꞌx el tnikyꞌ te qa manyor ẍtijxtaq tnabꞌljo xjal, tuꞌn tnabꞌlin jun tiꞌ, a tuꞌn tkubꞌ tbꞌinchin. Noqtzin tuꞌntz, chi Jesúsjo, aye xjal nya nimil, manyor ẍtijqex tiꞌj kyaqꞌin tzaluꞌn twutz txꞌotxꞌ tzeꞌnqekuxljo nimil. ");
INSERT INTO mamC_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jun tumil kxel nqꞌmaꞌn kyeꞌy, chi Jesús. Bꞌaꞌn tuꞌn tokiꞌn qꞌinimil kyuꞌn, a at tzaluꞌn twutz txꞌotxꞌ, a jun paqx k-ikyꞌil, te mojbꞌil kye txqantl toj tbꞌi qAjaw. Quꞌn ajtzin kykyima, atitla jun qꞌolbꞌil kyeꞌy te jun majx toj kyaꞌj tuꞌn Dios, noq tuꞌn mojbꞌil, a xi kyqꞌoꞌn kye txqantl ojtxe toj tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Quꞌn qa tukꞌa tumil njapin bꞌaj jun xjal toj jun tiꞌ tal muchꞌ, ex ikyxjo tukꞌa tumil kjapin bꞌajjo toj jun tiꞌ, a nimxix toklin. Tuꞌnpetziꞌn, aku tzꞌok qe qkꞌuꞌj tiꞌj. Qalaꞌ atzinl teꞌ nya bꞌaꞌn tbꞌinchbꞌin toj jun tiꞌ tal netzꞌ, ex nya bꞌaꞌn kꞌwel tbꞌinchine toj jun tiꞌ, a nimxix toklin. ");
INSERT INTO mamC_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tuꞌnpetziꞌn, qa nya bꞌaꞌnjo xkubꞌ kybꞌinchiꞌn tukꞌa qꞌinimil, a at tzaluꞌn twutzjo txꞌotxꞌ, ¿Me altzin kye jun aku tzꞌok qe tkꞌuꞌjtz kyiꞌja, tuꞌn ttzaj qꞌoꞌn qꞌinimil kyeꞌy, a nlayx bꞌaj? ");
INSERT INTO mamC_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Exsin qa nya bꞌaꞌn kybꞌinchbꞌiꞌn tukꞌa qꞌinimil, a oqxenin kyeꞌy, ¿Altzin kye jun aꞌla aku tzaj qꞌonte kyqꞌinimila? ");
INSERT INTO mamC_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mix aꞌl jun aqꞌnil aku tzꞌajbꞌin te kabꞌe tajaw aqꞌuntl. Quꞌn k-elil tiꞌjlin tnejil, ex k-okil tkꞌuꞌjlin tkabꞌ; mo k-okilj tzꞌaqle tukꞌa tnejil, me bꞌeꞌx aku tzꞌel tiꞌjliꞌnljo tkabꞌ. Nlayx bꞌant tuꞌn tokin te Dios ex te pwaq. ");
INSERT INTO mamC_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Noqx i jaw xmayin kyej Parisey tiꞌj Jesús, tej tok kybꞌiꞌn yol lo, quꞌn tuꞌn oꞌkxtaqtza qꞌuqle kykꞌuꞌj tiꞌj kypwaq. ");
INSERT INTO mamC_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Jesús kye kyjaluꞌn: Kyajnaj kyeꞌ tuꞌn tok kyqꞌoꞌn kyibꞌa te tbꞌanil xjal kywutzjo txqantl, me ojtzqiꞌn kyeꞌ kyanmin tuꞌn Dios; quꞌn tkyaqil, a manyor wenxix kywutzxjal, bꞌeꞌx n-el iꞌjlin teꞌ tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ojtxe, a naꞌmxtaq tul Juan, a Jawsil Aꞌ, oꞌkx yekꞌinte Diosjo t-xilin tajbꞌil noq tuꞌn ojtxe kawbꞌil, a xqꞌumlaj tuꞌn Moisés ex kyuꞌn yolil Tyol Dios. Me tej tul Juan, ok ten tyolajtzjo Tbꞌanil Tqanil Tkawbꞌil Dios, ex atzin jaꞌlin tkyaqilx kyexjal n-ok tilil kyuꞌn tzeꞌnx tuꞌn kyokxi toj. ");
INSERT INTO mamC_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Me kxel nqꞌmaꞌn kyeꞌy. Jun paqx aku naj te kyaꞌj exsiꞌn jniꞌ txꞌotxꞌ, me mexjo kawbꞌil, a xi ttziyin Dios ojtxe, nipe jun tal tẍkyin yol, a tzꞌibꞌinku, nlayx tziyajtzx teꞌ, tuꞌn mi japin bꞌaje. ");
INSERT INTO mamC_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kxel nqꞌoꞌn jun yekꞌbꞌil tiꞌjjo lo: Quꞌn qa at jun ichin ma kubꞌ tpaꞌn tibꞌ tukꞌa t-xuꞌjil, exsin qa ma tzꞌok meje tukꞌa juntl qya, ma kyꞌaꞌjiꞌn ichin anetziꞌn. Exsin qa at juntltz s-ok meje tukꞌa jun qya, a o kubꞌ tpaꞌn tibꞌ tukꞌa tchmil, ex ikyxjo, ma kyꞌaꞌjintl teꞌ, chi Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Attaq jun xjal qꞌinin, tbꞌanilqextaqjo t-xbꞌalin nchi ok, exsin twiꞌ wiꞌyilqetaq. Tkyaqil qꞌij tzuntaq n-ikyꞌsin nintz qꞌij, ex tbꞌanilxtaq waꞌn nbꞌaj toj tja. ");
INSERT INTO mamC_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ex ikyxjo, attaq juntl ichin yaj, Lázaro tbꞌi, a otaqx tzꞌel bꞌoꞌlin tiꞌj tukꞌa txqan txꞌaꞌk. Twutz txꞌotxꞌ nkubꞌe qeyetaq, ex axixtza ttzi tja qꞌinin qanil mojbꞌil kye xjal. ");
INSERT INTO mamC_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tajtaq teꞌ tal yaj anetziꞌn, tuꞌn tnoj tkꞌuꞌj tuꞌn jniꞌ tbꞌuchil wabꞌj, a n-eliktaq tzꞌaq tibꞌaj tmeẍ qꞌinin, me mi xi tqꞌoꞌne jun tiꞌ te, ex majqexpeꞌ ttxꞌyan qꞌinin nchi pon laqꞌetaq leqꞌil teꞌ taꞌljo txꞌaꞌk. ");
INSERT INTO mamC_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ul kanin jun te qꞌij, ex bꞌeꞌx kyim te Lázaro. Xitzin qꞌiꞌntz kyuꞌn t-angel Dios tzmax toj kyaꞌj, jaꞌ taꞌyetaq Abraham. Ex ikyxjo bꞌeꞌx kyim te qꞌinin me noq kux muquꞌn teꞌ toj txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tzunxtaqx yajlajtz te qꞌinin tojjo qꞌaqꞌ, jaꞌ nchi pon kanine nya nimil najal. I jawtzin tiꞌn twutz jawl, jax tkaꞌyin tzmax toj kyaꞌj, exsin iwle Abraham tuꞌn, ex majx Lázaro qꞌuqlek tkꞌatz. ");
INSERT INTO mamC_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bꞌeꞌxpetzin jaw ẍchꞌintz, ex chiꞌ kyjaluꞌn: ¡Ay, Tata Abraham, qꞌaqꞌintzin teꞌ tkꞌuꞌj wiꞌja! Smaꞌntzin te Lázaro nkꞌatza, ex qꞌmanxsin te, tuꞌn tkux takꞌsin twiꞌ tqꞌobꞌ toj aꞌ, exsin tuꞌn tkubꞌ tqꞌoꞌntz tibꞌaj waqꞌa tuꞌntzintla t-xi chewx, quꞌn loqiꞌn ma chin tzaj bꞌant-x tojjo qꞌaqꞌ lo. ");
INSERT INTO mamC_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tzajtzin ttzaqꞌwin Abrahamtz kyjaluꞌn: ¡Ay nkꞌwal! Naꞌntzinjiy tchwinqila, tej naꞌmxtaq tkyima; noqx toj tbꞌanilx xteniy. Me metziꞌn te Lázaro, nya toj tbꞌanil s-anqꞌine teꞌ. Tuꞌnpetziꞌn, nqꞌuqbꞌajtz te Lázaro tkꞌuꞌj tzaluꞌn jaꞌlin, ex atziljo te, luꞌ te tzunx n-ikyꞌx yajbꞌil tuꞌn tzachiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ex nya noq oꞌkx teꞌ, qalaꞌ at jun tij xaq, a jun tijx t-xe tkuꞌx qxol. Tuꞌnpetziꞌn, mix tuꞌn kyajku kyeꞌ, a iteꞌ tzaluꞌn tuꞌn kyikyꞌx tzachiꞌn, nlay chi ikyꞌx. Ex nlay bꞌant tuꞌn kyikyꞌtzjo a iteꞌ tzachiꞌn tzaluꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Xitzin ttzaqꞌwinljo qꞌinintz kyjaluꞌn: Ay, Tata Abraham, okx chin kubꞌsil weꞌ nwutz tey; chqꞌonsin te Lázaro tzmax tja ntatiy, ");
INSERT INTO mamC_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","quꞌn iteꞌx jweꞌl weꞌ witzꞌin. Maꞌtzintla yolin Lázarotz kyukꞌa, tuꞌntzintla mi chi tzaje tzaluꞌn, tojjo najbꞌil te nimx kyixkꞌoj. ");
INSERT INTO mamC_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tzajtzin ttzaqꞌwinl Abraham: Nya il tiꞌj tuꞌn t-xi qꞌumbꞌaj kye, quꞌn tzꞌibꞌin taꞌ tuꞌn Moisés, ex kyuꞌn kyyol yolil Tyol Dios. Tuꞌnpetziꞌn, bꞌaꞌn tuꞌn t-xi kynimiꞌn yol anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Xitzin ttzaqꞌwinl qꞌinintz kyjaluꞌn: Ay, Tata Abraham, aku txi kynimin kyetz, me tzmaxi noqit aku jaw anqꞌin jun kyimnin, exsintla xiꞌtz yolil kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tzajtzin ttzaqꞌwin Abrahamtz: Qa kykyꞌeꞌ tuꞌn t-xi kynimiꞌn jniꞌ tzꞌibꞌin taꞌye tuꞌn Moisés ex kyuꞌn yolil Tyol Dios, mixla tuꞌn jatz anqꞌin jun kyimnin, nlay txi kyinimiꞌn a kxel qꞌmaꞌn kye. ");
INSERT INTO mamC_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Xi tqꞌmaꞌn Jesús kye t-xnaqꞌtzbꞌin kyjaluꞌn: Kxel nqꞌmaꞌn kyeꞌy, kukx at te iljo tzaluꞌn twutz txꞌotxꞌ, me bꞌisbꞌajilxla teꞌ xjal, a kchi kꞌwel tzꞌaqjo txqantl toj il tuꞌn tpaj. ");
INSERT INTO mamC_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bꞌaꞌntla tuꞌn tok tkꞌloꞌn jun ma tij abꞌj te chebꞌl triy tiꞌj tqul, ex tuꞌn t-xi t-xoꞌn tibꞌ toj ttxuyil aꞌ tuꞌn tkyim, tzeꞌnku tuꞌn tokx toj paꞌbꞌin twutz Dios tukꞌa til, a tuꞌn tjaw tzꞌaq jun neꞌẍ nimil toj il tuꞌn tpaj. ");
INSERT INTO mamC_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kykaꞌyinktzin kyibꞌa, chi Jesúsjo. Aj qa ma tzꞌok tbꞌinchin jun tukꞌiy jun nya bꞌaꞌn tiꞌja, ku txiꞌy yolil tukꞌa, tuꞌn tajtz tiꞌj tanmin. Me kꞌwel tnajsiꞌn til, a qa ma ttxꞌixpe tnabꞌl exsiꞌn tbꞌinchbꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Expela qa wuq maj xbꞌinchin il tiꞌja toj jun qꞌij, me qatzin ma tzul wuq majltz qꞌmalte tey kyjaluꞌn: Noqx cheꞌwx tkꞌuꞌja wiꞌja kyuꞌn nbꞌinchbꞌiꞌn nya bꞌaꞌn tiꞌja, me nlay chi kubꞌ nbꞌinchiꞌntla chitjo, il tiꞌj tuꞌn kykubꞌ tnajsiꞌn til. ");
INSERT INTO mamC_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Chi chiꞌ t-xnaqꞌtzbꞌin te Jesús, a tAjaw Tkyaqil, kyjaluꞌn: Taa, qꞌontza txqantl qnimbꞌila. ");
INSERT INTO mamC_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chi tAjaw Tkyaqiljo kyjaluꞌn, tej ttzaj ttzaqꞌwin: Noqit at-xix kyeꞌ kynimbꞌil, iꞌchaqxpetla kyiꞌn tzeꞌnku jun tal twutz mistas, aku txi kyqꞌmaꞌn teꞌ tqan txꞌiꞌx wech lo, kyjaluꞌn: Xbꞌoqinktz tibꞌa tzaluꞌn, exsin awankux tibꞌtza tzmax toj ttxuyil aꞌ, ex akula chi kubꞌ nimiꞌn tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","A qa at jun kyeꞌ, a atit jun taqꞌnil, a lu ma meltzꞌaj kjol mo kyikꞌlel wakx toj chqꞌajlaj, ¿Ma akutzin txi tqꞌmaꞌn te kyjaluꞌn: Kux tzꞌoktza, ex kux kubꞌ qey waꞌl? ");
INSERT INTO mamC_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nlay txi tqꞌmaꞌn ikyjo. Ikyla aku txi tqꞌmaꞌn kyjaluꞌn: Bꞌinchim tibꞌa, tuꞌn tkubꞌ tbꞌinchiꞌn nwaꞌy te qale, ex tenkuy nkꞌatza tuꞌntzintla ttzaj tseꞌnjiy jotxjo jniꞌ k-ajbꞌil weꞌy. Ajxitzin nbꞌaj waꞌntza ex nbꞌaj kꞌwantza, kꞌaꞌpen txiꞌ tetza waꞌl ex kꞌwal. ");
INSERT INTO mamC_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ex nixpe chꞌin chjonte aku txi tqꞌoꞌn teꞌ aqꞌnil anetziꞌn, tuꞌn otaq kubꞌ tbꞌinchin jotxjo jniꞌ otaq txi tqꞌmaꞌn te. ");
INSERT INTO mamC_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ex ikytzin kyejiꞌy, aj tjapin bꞌajjo jniꞌ kxel qꞌmaꞌn kyeꞌy tuꞌn qMan Dios, iky kxel kyqꞌmaꞌnjiꞌy kyexjal kyjaluꞌn: Awoqejiꞌy aqꞌnil, a ntiꞌ qokliꞌn, quꞌn tuꞌn oꞌkx aqꞌuntljo ma bꞌant quꞌn, ajo saj qꞌmaꞌn qeꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tej kyjaꞌtaq t-xiꞌ Jesús toj tnam te Jerusalén, antza bꞌete tojjo bꞌe tkuꞌx kyxol tnam te Samaria ex Galiley. ");
INSERT INTO mamC_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Atzaj teꞌ tkanin toj jun kojbꞌil, bꞌeꞌx i tzaj laqꞌe lajaj ichin tkꞌatz, ayeꞌ yabꞌqetaq tuꞌn txꞌaꞌk, a noq n-el lemimin. Najchaq i tzaje weꞌye, ");
INSERT INTO mamC_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","exsin i jaw ẍchꞌintz kyjaluꞌn: ¡Jesús! Ay Xnaqꞌtzil, qꞌaqꞌintzin teꞌ tkꞌuꞌj qiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Atzaj teꞌ kyiwle tuꞌn Jesús, iky xi qꞌmaꞌn kye kyjaluꞌn: Kux cheꞌxa, exsin kyyekꞌinx kyibꞌtza kye pale. Tzuntaq nchi bꞌetjo ichin anetziꞌn, tej kykubꞌ qꞌanin. ");
INSERT INTO mamC_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tej tnaꞌnte jun, qa otaq kubꞌ qꞌanin, bꞌeꞌx aj meltzꞌaj, ex jaw tnimsiꞌn tbꞌi qMan Dios tukꞌa tqꞌajqꞌojil twiꞌ kujxix wen. ");
INSERT INTO mamC_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kubꞌ meje, ex kupiꞌn twiꞌ tzmax twutz txꞌotxꞌ, tej t-xi tqꞌoꞌn chjonte te Jesús. Teꞌ aj Samariataq te ichin anetziꞌn, a ikyꞌin kyuꞌn aj Israel. ");
INSERT INTO mamC_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chi Jesús kyjaluꞌn: ¿Ma nyatzin lajajtaq kyej ichin kybꞌaj ẍi qꞌanit? ¿Jatzila iteꞌyiljo bꞌeljajl? ");
INSERT INTO mamC_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mix aꞌl juntl te xmeltzꞌaj nimsil tbꞌi Dios, qalaꞌ oꞌkxl teꞌ bꞌetin xjal lo. ");
INSERT INTO mamC_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Xitzin tqꞌmaꞌn Jesús teꞌ bꞌetin xjal kyjaluꞌn: Kux jaw weꞌksa, ex kux txiꞌy. Axjo tnimbꞌila ma kubꞌ qꞌanintiy. ");
INSERT INTO mamC_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Xi kyqanin Parisey te Jesús jtojtaq tuꞌn tul kaniꞌn Tkawbꞌil qMan Dios. Xitzin ttzaqꞌwin Jesús kye kyjaluꞌn: Nlay qꞌanchaꞌlix teꞌ Tkawbꞌil qMan Dios, aj tul kanin. ");
INSERT INTO mamC_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mix aꞌl jun teꞌ kqꞌmalte kyjaluꞌn: Luꞌ lo, chitjo, mo luꞌ chiꞌn, chitljo; quꞌn ajo Tkawbꞌil qMan Dios luꞌ noql at toj kyanmin nimil. ");
INSERT INTO mamC_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Xitzin tqꞌmaꞌn Jesús kye t-xnaqꞌtzbꞌin kyjaluꞌn: Pon kanin jun te qꞌij, jaꞌ kyajiꞌy tuꞌn wok kykaꞌyiꞌn, a ayiꞌn Tkꞌwal Ichin, iꞌchaqxpetla noq jun qꞌijtz, chichkulajiꞌy, me nlayx kylontiꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iteꞌ junjun kchi qꞌmalte kyjaluꞌn: Lu at tzaluꞌn, mo lu at tzachiꞌn, qa chiꞌ. Me ayetzin kyeꞌ mina cheꞌxa lolte, ex mina chi ok lipey kyiꞌjjo kchi qꞌmalte ikyjo. ");
INSERT INTO mamC_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Quꞌn ajtzin wul juntl majl weꞌ, a ayiꞌn Tkꞌwal Ichin, ikytzin wuliljiꞌy tzeꞌnku xloqꞌlin kyaꞌj, a qa ma jaw qoptzꞌaj toj jun plaj t-xe kyaꞌj, ex bꞌeꞌx npon qoptzꞌaj tojjo juntl. ");
INSERT INTO mamC_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Me nej, k-ikyꞌix nim yajbꞌil wuꞌn, ex tuꞌn wel iꞌjliꞌn kyuꞌnxjal, a loqe nchi najan kyojjo qꞌij jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Iky kbꞌajiljo tojjo qꞌij, aj wul juntl majla, chi Jesúsjo, tzeꞌnku ikyꞌ kyojjo qꞌij, tej tten Noé ojtxe. ");
INSERT INTO mamC_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mi xi kyqꞌoꞌn ambꞌil te Dios, qalaꞌ nchi waꞌntaq kyexjal aj ilqe; nchi kꞌwantaq; nchi jaw mejetaq, ex nxi kyqꞌoꞌntaq kyal toj mejebꞌlin, tzmaxi tej tokx Noé toj ma tij bark tuꞌn kyklet. Ayetzin kyej txqantl xjal jotx i kyim tuꞌn qꞌaqabꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ex ikyx bꞌajjo tej tnajan Lot: Noq oꞌkxtaqtza otaq tzꞌok bꞌaje kyexjal kywutz tiꞌj kywa, tiꞌj kykꞌwaꞌ; noq oꞌkxtaq kyajjo tuꞌn kyloqꞌin ex tuꞌn kykꞌayin; tuꞌn kyawan ex tuꞌn kybꞌinchin kyja. ");
INSERT INTO mamC_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Me atzaj teꞌ tetz Lot toj tnam te Sodoma, bꞌeꞌx tzaj chitj qꞌaqꞌ toj kyaꞌj tukꞌa nimx tkꞌokꞌjil tzꞌeꞌnaq, ex bꞌeꞌx i bꞌaj kyim kykyaqilx. ");
INSERT INTO mamC_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ex ikyxsin te kbꞌajiljo, aj wul juntl majla, a ayiꞌn Tkꞌwal Ichin, chi Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tojjo qꞌij anetziꞌn, a qa at jun xjal tokxtaq twiꞌja, nlay bꞌant tuꞌn tkuꞌtz tuja qꞌil teꞌ jniꞌ at te. Exsin qa attaq juntl, a tzunxtaq n-aqꞌnin toj ttxꞌotxꞌ, ex nlay bꞌant tuꞌn tajtz meltzꞌaj tja. ");
INSERT INTO mamC_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kynaꞌntzinjiꞌy jniꞌ ikyꞌ tiꞌj t-xuꞌjil Lot. ");
INSERT INTO mamC_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Quꞌn ankye te taj noq tuꞌn ttzalaj toj tchwinqil tzaluꞌn twutz txꞌotxꞌ, ok knajil teꞌ te jun majx. Ex ankye te mi s-ok tilil tuꞌn tiꞌjjo tkyaqil te twutz txꞌotxꞌ noq tuꞌn npaja, ok knetil teꞌ tchwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Twutzxix kxel nqꞌmaꞌn kyeꞌy, chi Jesúsjo, qa tojtaq qnikyꞌin ẍin uliꞌy, exla qa kabꞌetaq xjal junx kuẍle tibꞌaj jun watbꞌil, junchꞌin teꞌ kxel qꞌiꞌn; atzin teꞌ juntl, axsa kyjele qꞌoꞌne teꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Exla qa kabꞌe qya junx nchi cheꞌn, junchꞌin teꞌ kxel qꞌiꞌn; atzin teꞌ juntl, axsa kyjele qꞌoꞌne teꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Exla qa kabꞌe ichin junx nchi aqꞌnin toj kyaqꞌnin; junchꞌin teꞌ kxel qꞌiꞌn; atzin teꞌ juntl, axsa kyjele qꞌoꞌne teꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Xitzin qanintz te Jesús kyjaluꞌn: Taa, ¿Jaꞌtzila kbꞌajile ikyjo? Ikytzin xi ttzaqꞌwin Jesúsjo kyjaluꞌn: Ok k-elil kynikyꞌa te jaꞌ kbꞌajile, ikyxjo tzeꞌnqeku kꞌutz n-el kynikyꞌ te jaꞌ taꞌ jun kyimnin. ");
INSERT INTO mamC_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kubꞌ tyolin Jesús jun techil lo kywutz t-xnaqꞌtzbꞌin, tuꞌntzintla tel kynikyꞌ teꞌ, qa il tiꞌj tuꞌn kukx tuꞌn kynaꞌn Diosjo junjun qꞌij, ex nya tuꞌn kykubꞌ numj. ");
INSERT INTO mamC_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Chiꞌ kyjaluꞌn: Toj jun tnam attaq jun kawil, a mina ntzajx tchewil Dios tiꞌj, ex ntiꞌxtaq chꞌin kyiwle jniꞌ xjal te. ");
INSERT INTO mamC_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ex tojxjo tnam anetziꞌn, attaql jun tal mebꞌe qya, a otaq kyim tchmil, a attaq tqꞌoj tukꞌa juntl xjal. Tuꞌntziꞌn, xiꞌ tukꞌa aj kawil, tuꞌntla tkubꞌ qꞌoꞌn jun tumil kyxol, a toj tumilxix. ");
INSERT INTO mamC_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ilaꞌxitaq qꞌij otaq tzikyꞌ, ex mix jaꞌxitaq n-oke bꞌiꞌnnaj tal mebꞌe qya. Me chebꞌe kubꞌ mutxe tej kawil bꞌisilte kyjaluꞌn: Exla qa mina ntzaj weꞌ tchewil Dios wiꞌj, exla qa ntiꞌx chꞌin kyiwle jniꞌ xjal weꞌy, ");
INSERT INTO mamC_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","me kꞌwel nbꞌiꞌnjiꞌy maꞌ mebꞌe qya lo, quꞌn tuꞌn noqx ma tzꞌok ten labꞌtil wiꞌja tuꞌn tkubꞌ nnikꞌuꞌnjiꞌy kyten. Ok kchin kolila tiꞌj, tuꞌntzintla mina tzul juntl majltz tzaluꞌn bꞌajsilte nkꞌuꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Atzin te qAjaw ikyl teꞌ tqꞌma kyjaluꞌn: Ikytzin tqꞌmaꞌ aj kawil nya wen. ");
INSERT INTO mamC_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","A qa ikyjo ntqꞌmaꞌn, ¿Ma nyapetzila aku kolin te Diostz kyiꞌjjo jniꞌ, a o chi jaw tskꞌoꞌn, a qa ma chi kubꞌsin kywutz qꞌijl ex qnikyꞌin? ¿Okpetzila kxel qꞌmaꞌn kye, tuꞌn kykubꞌ ten ayolte nim tqan, tzeꞌnkuꞌ tenaj tal mebꞌe qya? ");
INSERT INTO mamC_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mina, quꞌn ok kxel nqꞌmaꞌn kyeꞌy, chi Jesúsjo, a qa liweyxix kchi elil kloꞌn kyej xjal, a skꞌoꞌnqe. Me aj wul juntl majla, a ayiꞌn Tkꞌwal Ichin, ¿Akupela chi jyet-xjal wuꞌn tzaluꞌn twutz txꞌotxꞌ, a at kynimbꞌil tzeꞌnku tnimbꞌiljo tal mebꞌe qya? ");
INSERT INTO mamC_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ex kubꞌ tyolinl Jesúsjo juntl techil lo kyiꞌj junjuntl xjal, a tzuntaq n-ok kyqꞌoꞌn kyibꞌ te tbꞌanilx, me tzuntaq nchi el kyikyꞌiꞌn jniꞌ txqantl. Chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kabꞌe ichin i xiꞌ naꞌl Dios tojjo tnejil ja te nabꞌl Dios: Pariseytaq teꞌ jun; ante juntl peyil pwaqtaq teꞌ te tnam Rom. ");
INSERT INTO mamC_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Atzin te Parisey waꞌltaq teꞌ, tej tok ten naꞌl Dios noq te nimsbꞌil tibꞌ, ex chiꞌ kyjaluꞌn: Ay Taa, ok kxel nqꞌoꞌn chjonte tey, quꞌn tuꞌn mikyxiqin wejiꞌy tzeꞌnqeku txqantl xjal, a maꞌ ileqꞌqe, nya ma wen xjalqe, maꞌ aj kyꞌaꞌjilqe. Ex nya ikyqin wejiꞌy tzeꞌnkuꞌ maꞌ peyil pwaq lo tok ntxlaja. ");
INSERT INTO mamC_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kabꞌe maj nkubꞌ npaꞌn weꞌ wayꞌaj toj junjun seman, tuꞌn naꞌn Diosa, ex nxi nqꞌoꞌn tey ajo tlajajin tiꞌj tkyaqiljo jniꞌ nkanebꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Me atzin tej peyil pwaq najchaq chꞌintl tzaje weꞌye teꞌ, ex mixpe jaw kaꞌyin chꞌin twutz kyaꞌj, qalaꞌ noq ok ten qꞌajtzil ttzi tkꞌuꞌj te bꞌisbꞌajil, exsin iky tqꞌmaꞌ kyjaluꞌn: Ay Taa, qꞌaqꞌintzin teꞌ tkꞌuꞌj wiꞌja, a ayiꞌn aj ilqiꞌn, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kxel nqꞌmaꞌn kyeꞌy, chi Jesúsjo, qa tej taj meltzꞌajjo peyil pwaq tja, otaq kubꞌ najsit til tuꞌn Dios. Me metzil tej Parisey mix kubꞌ najsin teꞌ til; quꞌn qa at jun xjal njaw tnimsin tibꞌ, ok kꞌwel mutxsin teꞌ. Me atzil teꞌ, a kꞌwel tmutxsin tibꞌ, ok kjawil nimsin teꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ex bꞌaj xi kyiꞌn xjaljo junjun tal kꞌwal tkꞌatz Jesús, tuꞌn tkubꞌ tqꞌoꞌn tqꞌobꞌ kyibꞌaj, tuꞌn kykubꞌ tkyꞌiwlin. Me ayetzin t-xnaqꞌtzbꞌin bꞌeꞌx i ok ten yisol kyeꞌ nchi bꞌaj kanintaq. ");
INSERT INTO mamC_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","I tzajtzin ttxkoꞌn Jesús t-xnaqtzbꞌin, exsin xi tqꞌmaꞌn kye kyjaluꞌn: Kytzaqpinqetzjiꞌy tal kꞌwal, tuꞌn kybꞌaj tzaj laqꞌe nkꞌatza. Mi chi kubꞌ kymeqoꞌn, quꞌn kykyaqiljo kꞌwel kymutxsin kyibꞌ tzeꞌnqe tal kꞌwal lo, ayepen kye kchi okixjo toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Twutzxix kxel nqꞌmaꞌn kyeꞌy; qa ntiꞌ tqꞌuqbꞌil kykꞌuꞌja wiꞌja tzeꞌnku jun kꞌwal, nlay bꞌant tkawin Dios toj kychwinqila. ");
INSERT INTO mamC_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jun maj, jun kawil xi tqanin te Jesús kyjaluꞌn: Ay, xnaqꞌtzil wenxix, ¿Tiꞌn kꞌwel nbꞌinchiꞌn, tuꞌn nkanbꞌintejiꞌy chwinqil te jun majx? ");
INSERT INTO mamC_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Xi ttzaqꞌwin Jesús: ¿Tiquꞌn ntzaj tqꞌmaꞌn weꞌy qa wenqiꞌn? Ntiꞌx jun te xjal wen tzaluꞌn twutz txꞌotxꞌ, qalaꞌ oꞌkx te Dios. ");
INSERT INTO mamC_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Me qa taja tuꞌn tten jun tchwinqila te jun majx, niminqekutzinjiy ojtxe kawbꞌil: Mina kyꞌaꞌjiꞌn, mi bꞌiyiꞌn, mi tzꞌelqꞌiꞌn, mi nikyꞌin yola kyiꞌj txqantl, niminkutzin ttatiy ex tnaniy. ");
INSERT INTO mamC_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Iky xi ttzaqꞌwin ichin kyjaluꞌn: Tkyaqiljo lo bꞌeꞌx japin bꞌaj teꞌ wuꞌn, atxixj tej ẍin ntzaja toj nqꞌayila. ");
INSERT INTO mamC_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tej tbꞌinte Jesúsjo yol lo, xitzin ttzaqꞌwin kyjaluꞌn: Me atx juntl tiꞌ, a naꞌmx tbꞌant tuꞌn: Kꞌayinxjiy jotxjo jniꞌ at tey, exsin oyinxjiy tpwaqtza kye jniꞌ yaj. Qa ma bꞌantjo luꞌn tuꞌn, okpetzin ktenbꞌil tqꞌinimiltza toj kyaꞌj. Exsin ku tzajtza lipeka wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bꞌeꞌx bꞌisinx tej ichin, tej kyok tbꞌiꞌn yol lo, quꞌn tuꞌn manyor qꞌininxtaq. ");
INSERT INTO mamC_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Me bꞌeꞌx el tnikyꞌ Jesús te, qa otaq jaw bꞌisin. Tuꞌnpetziꞌn iky xi qꞌmaꞌn kyjaluꞌn: Kujx tetz, tuꞌn tokx jun qꞌinin toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kxel nqꞌmaꞌn juntl majl kyeꞌy: Akula jun paqx tuꞌn tex jun chej toj toyajil jun bꞌaq te slepbꞌil bꞌuꞌẍ, tzeꞌnku jun qꞌinin tuꞌn tokx toj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Me atzaj teꞌ kybꞌinte xjaljo yol lo, bꞌeꞌx xi kyqanin te Jesús kyjaluꞌn: Qa nlay chi okx qꞌinin toj kyaꞌj, ¿Yajtzila qetza? ¿Altzila kye k-okixtz? ");
INSERT INTO mamC_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Xi ttzaqꞌwin Jesús kyjaluꞌn: Nlay bꞌant tuꞌn kyklet-xjal kyuꞌnx kyibꞌx. Me mete Dios kbꞌantil teꞌ tuꞌn tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chi Pegr kyjaluꞌn: Ay Taa, ma kyij qtzaqpinqejiꞌy tkyaqiljo jniꞌ attaq qeꞌy, ex loqoꞌy lipcheqok tiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Twutzxix kxel nqꞌmaꞌn kyeꞌy, a qa at jun xjal ma kyij ttzaqpiꞌn tja, exqe ttata, ex t-xuꞌjil, exqe titzꞌin, exqe ttziky, exqe tkꞌwal, noq tuꞌn tpaj Tkawbꞌil qMan Dios, ");
INSERT INTO mamC_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ajo xjal anetziꞌn, nimx teꞌ ktzajil qꞌoꞌn te te t-xel tzaluꞌn twutz txꞌotxꞌ, exsin ktzajil qꞌoꞌn tchwinqil te jun majx toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","I tzaj ttxkoꞌn Jesús oꞌkqexjo kabꞌlajaj t-xnaqꞌtzbꞌin, exsin xi tqꞌmaꞌn kye kyjaluꞌn: Kyjaꞌ qxiꞌ jaꞌlin tzmax Jerusalén. Antza japine bꞌajjo jotxjo jniꞌ xbꞌaj kytzꞌibꞌin yolil Tyol Dios wiꞌja, a ayiꞌn Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Antza ok kchin xela qꞌoniꞌy toj kyqꞌobꞌ nya Judiy; ok kchi jawil xmayin wiꞌja, ok kchin okil yisoꞌn kyuꞌn, exsin ok k-okix tzubꞌin toj nwutza kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ok kchin bꞌajil laqtzꞌiꞌn kyuꞌn, exsin kchin kꞌwel bꞌyoꞌntza. Me ok kchin jawitz anqꞌiꞌn juntl majla toj toxin qꞌij. ");
INSERT INTO mamC_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ayetziꞌn t-xnaqꞌtzbꞌin ntiꞌx chꞌin el kynikyꞌ tiꞌjjo otaq bꞌaj qꞌmaꞌn kye, quꞌn tuꞌn ntiꞌxtaq chꞌin ojtzqiꞌn kyuꞌn tiꞌtaqjo nyolajtz. Tuꞌnpetziꞌn, minataq n-el kynikyꞌ te. ");
INSERT INTO mamC_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Atzaj teꞌ chꞌixtaq tkanin Jesús toj tnam Jericó, attaq jun moẍ qꞌuqle ttxlaj bꞌe, ex tzuntaq nqanin tmobꞌitz. ");
INSERT INTO mamC_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Atzaj teꞌ tok tbꞌiꞌn, qa attaq nimxku xjal n-ikyꞌik antza, xitzin tqanintz tiꞌtaqjo nbꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Xitzin qꞌmaꞌn te, qa ataq Jesús, a te aj Nazaret, tuꞌn tikyꞌ antza. ");
INSERT INTO mamC_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jawtzin ẍchꞌiꞌntz kyjaluꞌn: ¡Ay Jesús, tkꞌwal qtzan nmaq kawil David; qꞌaqꞌintzin tkꞌuꞌja wiꞌja! ");
INSERT INTO mamC_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ayetzin kyej xjal, a nejninqetaq twutz Jesús, bꞌeꞌx i ok ten miyolte, tuꞌntzintla mina tzꞌok tenil ẍchꞌil. Me noqx kyja jawe ẍchꞌin tej moẍ kujxix wen: Ay Jesús, tkꞌwal qtzan nmaq kawil David, qꞌaqꞌintz tkꞌuꞌja wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bꞌeꞌx kubꞌ weꞌ Jesús, exsin xi tqꞌmaꞌn, tuꞌn ttzaj qꞌinj moẍ jaꞌ taꞌyetaq. Tejtzin tpon qꞌiꞌn moẍ nqayin tkꞌatz, xitzin tqanin te kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Titzin taja tuꞌn tok nbꞌinchiꞌn tiꞌja? chi Jesús. Xi ttzaqꞌwin moẍ kyjaluꞌn: Ay Tata, waj weꞌ tuꞌn kykaꞌyiꞌn nwutzach. ");
INSERT INTO mamC_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Xi ttzaqꞌwin Jesús kyjaluꞌn: ¡Ma chi jqet te twutz jaꞌlin! Axjo tnimbꞌila ma kubꞌ qꞌanintiy. ");
INSERT INTO mamC_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Texjo paq anetziꞌn, bꞌeꞌx i jqet tej moẍ twutz, ex bꞌeꞌxsin ok lipe tiꞌj Jesús, ex jaw tnimsin tbꞌi qMan Dios. Ex jotqexjo xjal, a i lon teꞌ lo; majqex kyeꞌ i jaw nimsinte tbꞌi qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tej tokx Jesús toj tnam Jericó, bꞌeꞌxkux ok ten bꞌetejil toj tnam. ");
INSERT INTO mamC_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tojjo tnam anetziꞌn, antza najletaq jun ichin aj Judiy, qꞌinin wen, Zakey tbꞌi, nejineltaq kyxoljo jniꞌ peyil pwaq, a tuꞌn tajbꞌin kye aj kawil toj tnam Rom. ");
INSERT INTO mamC_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tajtaq tej ichin anetziꞌn tuꞌn tlonte Jesús, me mixtaq jaꞌ nbꞌante, quꞌn tuꞌn tal muchꞌtaq tweꞌ, exsin nimxtaq texjal lipche tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tuꞌnpetziꞌn, bꞌeꞌx el rinin, tuꞌntzintla tnej chꞌintl, ex bꞌeꞌx jax toj twiꞌ jun wiq tze, sicómoro tbꞌi, tuꞌntzintla tiwle Jesús tuꞌn, quꞌn antza tuꞌn tikyꞌetaq. ");
INSERT INTO mamC_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Atzaj teꞌ tikyꞌ Jesús antza, bꞌeꞌx jaw kaꞌyin jawl, jaꞌ tokxitaq Zakey, ex xi tqꞌmaꞌn kyjaluꞌn: Kux tkuꞌtza Zakey, quꞌn il tiꞌj tuꞌn nkyija toj tjay jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jun paqx kuꞌtz te Zakey, ex bꞌeꞌx xi tkꞌmoꞌn Jesús tukꞌa tkyaqil tanmin. ");
INSERT INTO mamC_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tej kylonte xjaljo lo, bꞌeꞌx i ok ten yolbꞌil tiꞌj Jesús. Chi chiꞌ kyjaluꞌn: ¿Titzila quꞌn ma tzꞌokx Jesús qanil twatbꞌil, tuꞌn tkyij toj tja jun xjal aj il? ");
INSERT INTO mamC_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Me ante Zakey, tej nchi waꞌntaq, bꞌeꞌx jaw weꞌks teꞌ, exsin xi tqꞌmaꞌn te tAjaw Tkyaqil kyjaluꞌn: Kaꞌyintziꞌn, wAjaw, nikyꞌjiꞌn nqꞌinimila ok kxel nqꞌoꞌn kye yaj, exsin qa at jun wetza tiꞌ o tzꞌel welqꞌin te jun aꞌla, kyaje maj ok k-ajil nmeltzꞌinlta t-xel. ");
INSERT INTO mamC_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chi Jesúsjo kyjaluꞌn: Mapetzin tzul kolbꞌiltz tojjo ja lo jaꞌlinxix, quꞌn noq tuꞌn tnimbꞌil wiꞌja nyekꞌine qa twutzxix tyajil Abraham tejo ichin lo. ");
INSERT INTO mamC_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Quꞌn ma chin ul weꞌ, a ayiꞌn Tkꞌwal Ichin, jyol kyeꞌ ex klol kyeꞌ, a ayeꞌ otaq chi naj toj il. ");
INSERT INTO mamC_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tzuntaq nchi bꞌin kyexjal tiꞌj Tyol Jesús. Tej chꞌixtaq tpon kanin Jesús Jerusalén, kubꞌ tyolinljo jun techil lo, quꞌn tzuntaq nchi ximinxjal qa chꞌixtaq tul kaniꞌn Tkawbꞌil qMan Dios twutz txꞌotxꞌ, ex bꞌiꞌntaq kyuꞌn qa iltaq tiꞌj tuꞌn tkawin Kolil te jun majx toj tnam Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Jesús kyjaluꞌn: At jun nmaq xjal xiꞌ toj junxil tnam najchaq, tuꞌntzintla tok qꞌoꞌn toklin te nmaq kawil, me iltaq tiꞌj tuꞌn tmeltzꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","I tzaj ttxkoꞌnj nmaq xjal anetziꞌn, lajaj taqꞌnil tej naꞌmxtaq t-xiꞌ, exsin nimx tpwaqtz xi tqꞌoꞌn teyile junjun, ex xi tqꞌmaꞌn kye kyjaluꞌn: Kyqꞌonku chꞌin kyeꞌ tal kykꞌaẍjil tukꞌa pwaq lo, aꞌkxitla n-alin aj wula. ");
INSERT INTO mamC_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Me ikyꞌintaq twutzjo xjal lo, kyuꞌnxjo t-xjalil. Tuꞌnpetziꞌn, bꞌeꞌx i xi smaꞌn jun jteꞌbꞌin xjal qꞌmalte tiꞌjbꞌinxe. Ikytaq kyyoljo kyjaluꞌn: Qkyꞌeꞌ qeꞌ tuꞌn tokjo ichin lo te kawil qibꞌaja. ");
INSERT INTO mamC_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Me bꞌeꞌx tzaj qꞌoꞌnx tetz toklin te nmaq kawil, ex bꞌeꞌx ajtz tuꞌn tul kanin toj ttanim. Atzaj teꞌ tul, bꞌeꞌx i tzaj ttxkoꞌn ayej aqꞌnil, a jaꞌ otaq txi tqꞌoꞌne pwaq, tuꞌntzintla tbꞌinte jteꞌn otaq tkanbꞌe junjun. ");
INSERT INTO mamC_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Uljo tnejil aqꞌnil, ex xi tqꞌmaꞌn kyjaluꞌn: Ay Taa, atzin te tpwaq lajaj maj ma tzꞌalin te. ");
INSERT INTO mamC_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kutzin chtej nmaq kawil te aqꞌnil. Jun tbꞌanil aqꞌnil te, quꞌn tuꞌn toj tumil ma tzꞌaqꞌniniy tojjo chꞌin taqꞌin xi nqꞌoꞌn. Tuꞌnpetziꞌn, ok k-okil nqꞌoꞌn tokliꞌn te kawil kyibꞌaj lajaj tnam. ");
INSERT INTO mamC_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tej tul kanin juntl, iky xi tqꞌmaꞌn kyjaluꞌn: Taa, atzin te tpwaq jweꞌ maj ma tzꞌalin teꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ex ikyx teꞌ xi qꞌmaꞌnte: Ok k-okil te te kawil kyibꞌaj jweꞌ tnam, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Me atzin teꞌ juntl iky te tqꞌma kyjaluꞌn: Taa, luꞌ te tal pwaq lo. Chebꞌex xkubꞌ nkꞌuꞌn toj jun tal suꞌtj; ");
INSERT INTO mamC_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","quꞌn tuꞌn bꞌeꞌx saj nxobꞌila tey, quꞌn kuj xjal te. Njaw tiꞌnjiy, a nyay nkubꞌ qꞌonte, ex njaw tchmonjiy twutz awal, a nyay nkux awante. ");
INSERT INTO mamC_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Atzin tej nmaq kawil xi tqꞌmaꞌn kyjaluꞌn: Ay jun aqꞌnil nya wen. Ayexjo tyola kchi okil wuꞌn te kawiltiy. Qa bꞌiꞌntaq tetza tuꞌn, qa kuj xjalqin weꞌ, ex qa njaw winjiꞌy a nyaqiꞌn ẍin kubꞌ qꞌonte, ex qa njaw nchmoꞌnjiꞌy, a nyaqiꞌn ẍin kux awante, ");
INSERT INTO mamC_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Tiꞌtzin quꞌntz mina xi tiꞌn we npwaq tojjo nmaq ja te kꞌuꞌbꞌl pwaq, exsintla saj tmeltzꞌintza weꞌy tukꞌaxjo jniꞌ manbꞌilte, tej ẍin meltzꞌaja njaꞌy? ");
INSERT INTO mamC_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Xitzin tqꞌmaꞌnltz kyeꞌ xjal, a iteꞌtaq antza kyjaluꞌn: Kyimiljiꞌy pwaq te, exsin kyqꞌonxsa te aqꞌnil, a lajaj maj s-aliꞌn npwaqa tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ayetzin kyej xjal xi kyqꞌmaꞌn kyjaluꞌn: Taa, me lajaj maj teꞌ pwaq at tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chi kawiljo kyjaluꞌn: Ok kxel nqꞌmaꞌn kyeꞌy, alkyeꞌ xjal, a at nim at te, ok kxeꞌl txqantl te te; atzin teꞌ xjal, a nya nim at te, majxpe k-elil qꞌiyitjo chꞌin netzꞌ at te. ");
INSERT INTO mamC_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ex ikyqexjo wajqꞌoja, a kykyꞌeꞌtaq tuꞌn woka te nmaq kawil, kux chi tzaj kyiꞌn tzaluꞌn, ex kybꞌyonqekuy nwutzxa. ");
INSERT INTO mamC_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tej tbꞌaj tqꞌmaꞌn Jesús tkyaqiljo lo, kubꞌ nej kywutz t-xnaqꞌtzbꞌin, tuꞌn kykanin toj tnam te Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Atzaj teꞌ kykanin nqayin kykꞌatz tnam te Betfagé ex Betania, nqayin t-xe wutz, a Olivos tbꞌi; i xitzin tchqꞌoꞌntz kabꞌe t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Chiꞌ kyjaluꞌn kye: Kux cheꞌxa tojjo tal kojbꞌil jlajxi. Antza ok knetile jun tal bur kyuꞌn, kꞌloꞌn, me mix jun xjal o chejinxi tibꞌaj. Kypjumila, exsin kyintza tzaluꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Qa at jun aꞌla saj qaninte kyeꞌy: ¿Tiquꞌnil n-el kypjuꞌn? qa chiꞌ. At k-okile te qAjaw, chichkujiꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","I xiꞌtzin kyej t-xnaqꞌtzbꞌin antza, exsin el knetj tal bur kyuꞌn, tzeꞌnkuxjo otaq txi qꞌmaꞌn kye tuꞌn Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tzuntaq nchi pjun tiꞌjjo tal bur, tej ttzaj qanin kye kyuꞌn tajaw: ¿Tiquꞌn n-el kypjuꞌnjiꞌy tal bur? ");
INSERT INTO mamC_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Xitzin kytzaqꞌwintz kyjaluꞌn: Quꞌn tuꞌn at k-okile te qAjaw, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tzajtzin kyiꞌntzjo tal bur, jaꞌtaqjo taꞌye Jesús. Jax kyqꞌoꞌn jniꞌ kytxoꞌw tibꞌaj, exsin jax qe Jesústz tibꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tej t-xi xkye tbꞌe Jesús, bꞌeꞌx i ok ten kyexjal likyꞌilte jniꞌ kytxoꞌw tojile tbꞌe. ");
INSERT INTO mamC_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tej chꞌixtaq kypon kanin tuꞌn kyxi pichꞌkaj t-xe Wutz Olivos, jotqexjo jniꞌ xjal, a lipcheqetaq tiꞌj, ox chi ẍchꞌinx tuꞌn kytzaljbꞌil, ex i nimsin tbꞌi qMan Dios, tuꞌn otaq kylon teꞌ jotxjo jniꞌ tbꞌinchbꞌin Jesús, a noqx nchi jaw kaꞌylajxjal tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iky kyqꞌmaꞌ kyjaluꞌn: ¡Kyꞌiwlinxitjo a Nmaq Kawil, a luꞌ ma tzul tiꞌj tbꞌi tAjaw Tkyaqil! Noqit jun nukꞌbꞌil toj kyaꞌj, ex nimxitjo toklin tbꞌiy toj tnajbꞌila. ");
INSERT INTO mamC_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ayeqetziꞌn junjun Parisey, a iteꞌtaq kyxolxjal, xi kyqꞌmaꞌn te Jesús kyjaluꞌn: Ay Xnaqꞌtzil, miyonqexjiy xjal, a noq nchi ẍchꞌin tiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Me atzin te Jesús iky xi ttzaqꞌwiꞌn kyjaluꞌn: Kxel nqꞌmaꞌn kyeꞌy, a qa mina ẍi jaw ẍchꞌin xjal lo, ayela kye abꞌj ok chi jawil ẍchꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tej chꞌixtaq tkanin Jesús toj tnam Jerusalén, atzaj teꞌ tiwlej tnam tuꞌn, bꞌeꞌx jaw oqꞌ tiꞌj, ");
INSERT INTO mamC_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ex chiꞌ kyjaluꞌn: Ayiꞌy xjal tojjo tnam chiꞌ, noqit aku tzꞌel kyeꞌ kynikyꞌ tiꞌj tojjo qꞌij jaꞌlin, alkye tuꞌn tul qꞌinte tnukꞌbꞌil Dios kyxolaliy; nlayla bꞌant ikyjo, quꞌn ewin taꞌye, ex nlay tzꞌel kynikyꞌa te. ");
INSERT INTO mamC_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tzulx jun te tqꞌijil, a nim bꞌisbꞌajil. Ayejo jniꞌ kyajqꞌoja ok kjawil kybꞌinchin kybꞌe tiꞌjile kytanima; ok k-okil kytxolbꞌin kyibꞌ kyiꞌjiliy, exsin ok kchi okil lipin kyiꞌja toj tkyaqil kytxlaja. ");
INSERT INTO mamC_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ex kchi kꞌwel yuchꞌiꞌn kytanima kyuꞌn te jun majx. Ex kchi kꞌwel bꞌyoꞌn jniꞌ kyxjalila iteꞌ toj; ntiꞌx jun abꞌj kyjel tibꞌaj juntl; quꞌn tuꞌn mina s-el kynikyꞌa teꞌ tqꞌijil Dios, tej nteꞌn kyxola. ");
INSERT INTO mamC_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tbꞌajlinxitziꞌn ikyjo, okx Jesús tojjo tnejil ja te nabꞌl Dios, exsin ok ten lajol kyeꞌ jniꞌ xjal, a tzuntaq nchi kꞌayin. ");
INSERT INTO mamC_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Chiꞌ kyjaluꞌn: Tzꞌibꞌinl teꞌ toj Tuꞌjil Tyol Dios: Atzin njaꞌy k-okil te ja te naꞌbꞌl Dios, me ayetzin kyeꞌ ma tzꞌok kyqꞌoꞌn te kyja ileqꞌch. ");
INSERT INTO mamC_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kykyaqil qꞌij o xnaqꞌtzin te Jesús tojjo tnejil ja te nabꞌl Dios. Me ayetzin kyej jniꞌ kynejil pale, jniꞌqetaqjo xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn jniꞌ nejinel toj tnam, tzuntaq nchi jyon kyeꞌ tumil tzeꞌntaq tuꞌn tkubꞌe kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Me mix jyete tumil kyuꞌn tzeꞌn tuꞌn tkubꞌe bꞌyete, quꞌn tuꞌn kykyaqilx xjal tzunxixtaq nchi bꞌin tiꞌjjo ntqꞌmaꞌntaq Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jun maj, tej tzuntaq nxnaqꞌtzin Jesús kyexjal toj tnejil ja te naꞌbꞌl Dios, ex tzuntaq nxi tchikyꞌbꞌiꞌn Tbꞌanil Tqanil kolbꞌil; i pon kanin kynejil pale exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil, junx kyukꞌa jniꞌ nejinel kyxolxjal, ");
INSERT INTO mamC_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ex xi kyqꞌmaꞌn te Jesús kyjaluꞌn: ¿Tiꞌn tokiy tuꞌn ntbꞌinchinjiy jniꞌ lo, a nkubꞌ tbꞌinchiꞌn? ¿Ex ankye saj qꞌoꞌnte tokliꞌnch? ");
INSERT INTO mamC_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Ex ikyx wejiꞌy, kxel nqanin jun nxjelbꞌitza kyeꞌy. ¡Kytzaqꞌwintza! ");
INSERT INTO mamC_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ankye tzaj chqꞌoꞌnte qtzan Juan tuꞌn kykuꞌxxjal tuꞌn toj aꞌ te jawsbꞌil aꞌ? ¿Apela Dios, mo noq ayexjal? ");
INSERT INTO mamC_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tej kybꞌinte ikyjo, bꞌeꞌxsin ok tentz chꞌotjil kyxolx. Chi chiꞌ kyjaluꞌn: Qa ma txi qqꞌmaꞌn, qa Dios saj chqꞌonte ¿Tiꞌtzin quꞌntz mina xi kynimiꞌn? chilaꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ex nlay txi qqꞌmaꞌn qa noq aye xjal ẍi tzaj chqꞌonte qtzan Juan, quꞌn qa ma txi qqꞌmaꞌn ikyjo, bꞌeꞌx aku qo kubꞌ kybꞌyoꞌnxjal tukꞌa abꞌj, quꞌn tuꞌn kykyaqiljo maꞌ xjal lo i xi niminte qa ate Juan jun yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tuꞌnpetziꞌn, tzaj kytzaqꞌwin kyjaluꞌn: Nya bꞌiꞌn qe quꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Xitzin tqꞌmaꞌnl Jesústz: Exsin ikyx wejiꞌy, nlay txi nqꞌmaꞌn weꞌ, alkye saj qꞌoꞌnte wokliꞌn tuꞌn tkubꞌ nbꞌinchiꞌn tkyaqiljo lo. ");
INSERT INTO mamC_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tbꞌajlinxitziꞌn ikyjo, ok ten Jesús yolil teꞌ jun techil lo kyexjal: At jun xjalch, kux tawaꞌn txqan tqan uv toj ttxꞌotxꞌ, exsin bꞌeꞌx xi tqꞌoꞌn ttxꞌotxꞌ te kymajin xjal, exsin xiꞌtz toj jun tbꞌe najchaq wen. ");
INSERT INTO mamC_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Atzaj teꞌ tpon tqꞌijil tuꞌn tok chmet twutz awal, tzaj tchqꞌoꞌn jun taqꞌnil qanil teꞌ manbꞌil txꞌotxꞌ kye manil. Me ayetzin kyej manil txꞌotxꞌ noq ok ten kyꞌixsbꞌilte tal taqꞌnil, ex ntiꞌ chꞌin xi qꞌoꞌn te, tej taj meltzꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tuꞌn ikyjo, bꞌeꞌx tzaj tchqꞌoꞌn tej tajaw txꞌotxꞌ juntl taqꞌnil, me ikyx bꞌajjo tiꞌj; noqx techx bꞌaj yisoꞌn, bꞌaj bꞌyoꞌn, ex ntiꞌ chꞌin xi qꞌoꞌn te, tej taj meltzꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tzaj chqꞌoꞌn juntl, me ikyx ikyꞌjo tiꞌj, noqx techx bꞌaj kybꞌyoꞌn, ex bꞌeꞌx aj kylajoꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","¿Titzila kꞌwel nbꞌinchintza? chtej tajaw txꞌotxꞌ: Bꞌaꞌn qa ok kxel nsmaꞌn wejiꞌy nkꞌwala, a kꞌuꞌjlinxix wuꞌn; nyapela aku kubꞌ nimin teꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Me atzaj teꞌ t-xi kykaꞌyin manil txꞌotxꞌ, teꞌ ttzaj kꞌwalbꞌaj, bꞌaj kubꞌ kyyolin manil kyxolx: Ate luꞌn kyjel te tajaw txꞌotxꞌ. Qoꞌqe, ex qbꞌyonku, tuꞌn qkyij te tajaw. ");
INSERT INTO mamC_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ikytziꞌn, tzaj kytzyuꞌn, ex kyiꞌn tzma ttxaꞌn txꞌotxꞌ, ex kubꞌ kybꞌyoꞌn. ¿Tzeꞌntzin chꞌin kyeꞌ toj kywutz? ¿Tiꞌtzila kbꞌajil teꞌ tajaw txꞌotxꞌ kyiꞌjjo manil anetziꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ok kxeꞌl kykꞌatzjo manil txꞌotxꞌ, ex ok kchi kꞌwel tbꞌyoꞌn, ex ok kxel tqꞌoꞌn ttxꞌotxꞌ kye junxil, chi Jesúsjo. Tej kybꞌinte Pariseyjo lo, jun paqx ma tzꞌel kynikyꞌ te, ex kyqꞌma kyjaluꞌn: ¡Nlaynajpetzila bꞌaj te ikyjo! ");
INSERT INTO mamC_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Atzin te Jesús, bꞌeꞌx xi kyim toj kywutz, ex xi tqꞌmaꞌn kyjaluꞌn: Qa nlay, ¿Tzeꞌntzin tzꞌelpineꞌ a ntqꞌmaꞌn toj Tuꞌjil Tyol Dios? Chiꞌ kyjaluꞌn: A abꞌj, a xi kyxoꞌn bꞌinchil ja, a nyakuj ntiꞌtaq tajbꞌin; me axixpente abꞌjjo ma tzꞌokin te tqꞌuqil tẍkyin ja, a nimxix toklin. ");
INSERT INTO mamC_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ex atzin abꞌj jun techil wiꞌja. Ankye teꞌ kꞌwel t-xoꞌn tibꞌ tibꞌajjo abꞌj, tuꞌn tyuchꞌj tuꞌn; axte kꞌwel tyuchꞌin tibꞌ tibꞌaj. Ex qa a abꞌj xkubꞌ tzꞌaq tibꞌaj jun aꞌla te kawbꞌil kujxix, bꞌeꞌx kꞌwel quqix te jun majx. ");
INSERT INTO mamC_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ayetzin kyej kynejil pale exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil, texjo paq anetziꞌn kyajtaq tuꞌn tok kytzyuꞌn Jesús, quꞌn tuꞌn bꞌeꞌx kanin toj kynabꞌl, qa kyiꞌjtaq nyolineꞌ techil, a kubꞌ tyolin Jesús. Me bꞌeꞌx tzaj kyxobꞌil kyexjal. ");
INSERT INTO mamC_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","I ok ten Parisey jyolte tumil, tzeꞌn tuꞌn tkubꞌe tzꞌaqetaq Jesús toj til kyuꞌn. Tuꞌnpetziꞌn, i xi kychqꞌoꞌn jun jteꞌbꞌin xjal bꞌilte tyol Jesús. Ayejo xjal anetziꞌn ok kyqꞌoꞌn kyibꞌ te tbꞌanil, me oꞌkxtaq kyajjo tuꞌn tkubꞌ tzꞌaq Jesús kyuꞌn tuꞌnxjo tyol. ");
INSERT INTO mamC_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Xi kyqanin te Jesús kyjaluꞌn: Ay, xnaqꞌtzil, noq samiy; bꞌiꞌn qe quꞌn, qa nyolin teꞌ twutzxix, ex qa nxnaqꞌtziꞌn oꞌkx tiꞌjjo tbꞌeyil chwinqil, a tuꞌn qxiꞌ tukꞌa qMan Dios. Ex mina njaw ttxꞌixpiꞌn, noq tuꞌn kytziꞌxjal, ex mina nchi kubꞌ tniminjiy aye nim kyoklin, quꞌn ntiꞌ jun xjal nim toklin tibꞌaj juntl toj twutza. ");
INSERT INTO mamC_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tuꞌnpetziꞌn, ¿Tzeꞌntzin chꞌin te toj twutz? ¿Wenpela tuꞌn t-xi qchjonjiꞌy kꞌaybꞌil te kawil aj Rom, mo minaj? ");
INSERT INTO mamC_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ex bꞌeꞌx el te Jesús tnikyꞌ te, qa nya bꞌaꞌntaqjo kyximxjal anetziꞌn. Tuꞌnpetziꞌn, xi ttzaqꞌwin kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kyyekꞌintza jun pwaq weꞌy. Tej t-xi ttzyuꞌn, xi tqanin kye: ¿An qwutzbꞌiyiljo lo, ex an qbꞌi tzꞌibꞌink twutz? Xitzin kytzaqꞌwintz kyjaluꞌn: Twutzbꞌiyil ex tbꞌi nmaq kawil te Rom tok tiꞌj, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chi Jesúsjo kyjaluꞌn: Tuꞌnpetziꞌn, kyqꞌoꞌnx kyejiꞌy a ntqanin nmaq kawil te Rom, ex kyqꞌoꞌnxsinjiꞌy a te Dios ntqanin. ");
INSERT INTO mamC_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mix jyete tumil kyuꞌn, tzeꞌn tuꞌn tkubꞌe tzꞌaqetaq Jesús kyuꞌnx tyol kywutzxjal. Tuꞌnpetziꞌn, bꞌeꞌx i kubꞌ qen, ex i jaw kaꞌylaj, tuꞌn tumil tyol Jesús, tej tok ten tzaqꞌwil teꞌ jniꞌ kyyol. ");
INSERT INTO mamC_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tbꞌajlinxiꞌ ikyjo, i pon kanin junjun xjal Sadusey kybꞌi lolte Jesús. Aye xjal anetziꞌn minataq nxi kynimin, qa nchi jaw anqꞌin juntl majljo kyimnin. Tuꞌnpetziꞌn, xi kyqanin te Jesús kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Xnaqꞌtzil, at jun te yol kyij ttzꞌibꞌin Moisés qeꞌy toj Tuꞌjil Tyol Dios, a ntqꞌmaꞌn kyjaluꞌn: Kyij tyolin Moisés, qa aj tkyim jun ichin, ex qa ntiꞌ jun tkꞌwal xkyij tukꞌa t-xuꞌjil, il tiꞌj tuꞌn tjaw meje tukꞌa titzꞌin mo tukꞌa ttziky qtzan tchmil, quꞌn tuꞌntzin aj tuljo tnejil kyal, te tkꞌwaljo qtzan tchmil tuꞌn toke, tuꞌn mi naje etzbꞌil kyxol t-xjalil qtzan tchmil. ");
INSERT INTO mamC_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Atziꞌn jaꞌlin, chi chiꞌ, jun maj, attaq wuq ichin kyitzꞌimile kyibꞌ. Atziꞌn kytziky knet t-xuꞌjil, me ntiꞌ jun tkꞌwal kyij, teꞌ tkyim. ");
INSERT INTO mamC_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Atzintzjo tkabꞌ jaw meje tukꞌa t-xuꞌjil kyij, me ikyxljo, ntiꞌ jun tkꞌwal kyij, teꞌ tkyim. Ex ikyxl bꞌajjo tukꞌa toxin. Ex kykyaqiljo wuq i ok meje tukꞌa, me ntiꞌ jun kykꞌwal kyij, teꞌ kykyim. ");
INSERT INTO mamC_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kykyimlinxiꞌ, ex bꞌeꞌx kyimjo qya. ");
INSERT INTO mamC_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Me atzin jaꞌlin, ¿Tzeꞌntzila tteꞌn tuꞌn tjaw anqꞌintl kyimnin? Quꞌn, qa ikyjo, aj kyjaw itzꞌje juntl majl, ¿Tiꞌtzila kbꞌajiltz? ¿Altzila kye k-okil te tchmiljo qya kyxoljo wuq ichin, quꞌn kykyaqilx i ok meje tukꞌa? ");
INSERT INTO mamC_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Xitzin ttzaqꞌwin Jesús kyjaluꞌn: Twutzjo txꞌotxꞌ lo, nchi jaw meje kye ichin exqetziꞌn qya. ");
INSERT INTO mamC_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Me ayetzin kyeꞌ, a ktzajil qꞌoꞌn kyoklin tuꞌn kyjatz itzꞌje juntl majl toj tkabꞌ chwinqil te toj kyaꞌj, nlay chi jaw mejel kyeꞌ, exla qa ichin exla qa qyaqe, ");
INSERT INTO mamC_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","quꞌn tuꞌn nlay chi kyimtl; qalaꞌ iky kchi okileꞌ tzeꞌnqekuꞌ angel, ex ok kchi okil te tkꞌwal Dios, tuꞌn otaq chi jatz anqꞌintl kyxol kyimnin. ");
INSERT INTO mamC_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tiꞌjjo lo, majxpe te Moisés kyij tzꞌibꞌinte, tej ttzaj tyekꞌin Dios tibꞌ toj tqan txꞌiꞌx, a nkꞌanttaq ojtxe. Tuꞌn ikyjo, bꞌiꞌn quꞌn qa nchi jatz anqꞌin kyimnin, quꞌn axte Dios qꞌmante kyjaluꞌn: Ayin wejiꞌy tDios Abraham, te Isaac ex te Jacob. Mix tqꞌma qa ayintaq wejiꞌy, qalaꞌ ayin wejiꞌych. ");
INSERT INTO mamC_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ikytziꞌn, ate Dios nya kyDios kyimnin, qalaꞌ kyDios itzꞌ, exla qa o chi kyim tzaluꞌn twutz txꞌotxꞌ, quꞌn toj twutz Dios, itzꞌqe kykyaqilx. ");
INSERT INTO mamC_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iteꞌ junjun xnaqꞌtzil tiꞌj ojtxe kawbꞌil xi qꞌmante te Jesús kyjaluꞌn: Ay Xnaqꞌtzil, bꞌaꞌn te tumil tyol. ");
INSERT INTO mamC_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ex texjo or anetziꞌn ntiꞌl okx kylimon kyibꞌ tuꞌn kyqanin te Jesús juntl tiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Xitzin tqaninl Jesús kye: ¿Tiꞌquꞌnil nkyqꞌmaꞌn xjal, qa t-xeꞌchil Crist te David, a nmaq kawil ojtxe? ");
INSERT INTO mamC_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Me atzin te David, iky te tqꞌma kyjaluꞌn toj uꞌj te Bꞌitzbꞌil: Xi tqꞌmaꞌn qMan Dios te wAjawa: Qekuy toj nman qꞌobꞌa kawil wukꞌiy, ");
INSERT INTO mamC_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ex kꞌwel kyiꞌjjo tajqꞌoja wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Twutzx teꞌ qa ate Crist tyajil qtzan David. ¿Me tzeꞌntzin ttentz o yolin te David tiꞌj Crist, a naꞌmtaq titzꞌje, ex ok tqꞌoꞌn te tAjaw? ");
INSERT INTO mamC_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jotxtaq xjal antza nchi bꞌintaq tiꞌj Jesús, tej t-xi tqꞌmaꞌn kye t-xnaqꞌtzbꞌin kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Kykaꞌyink kyeꞌ kyibꞌ kyeꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil. Quꞌn axix kyajjo tuꞌn kybꞌet tojjo ma xqer xbꞌalin, tuꞌn kykaꞌyinxjal kyiꞌj qa wenqe, ex kyaj tuꞌn kyqꞌolbꞌinxjal kye tukꞌa kymutxbꞌil kyibꞌ kyojileꞌ bꞌe. Tzunxix nkyjyoꞌn kyqꞌuqil, a tnejilxix iteꞌku toj muꞌẍ ja te naꞌbꞌl Dios, exsiꞌn tzeꞌnku ncheꞌx waꞌl toj nintz qꞌij te wabꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ex kukx n-el kyiꞌn kyja tal qya, a o kyim kychmil, ex nimxix tqan nchi naꞌn Dios, me noqtzintla tuꞌn mina tzꞌele tnikyꞌtzajil kybꞌinchbꞌin, a nya wen, kywutzxjal. Me ayetziꞌn xjal lo, nimxixtl tkawbꞌil qMan ktzajil kyibꞌaj, a kujxix wen, chi Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tzuntaq nkaꞌyin Jesús kyiꞌjjo xjal, a qꞌininqetaq, tej nkuꞌxtaq kyqꞌoꞌn kyoyaj tojjo tkubꞌil pwaq toj tja Dios. ");
INSERT INTO mamC_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ex ok tkaꞌyin Jesús jun tal qya yajxix, a kyimnin tchmil, tej tkux tqꞌoꞌn kabꞌe tal netzꞌ pwaq te toyaj. ");
INSERT INTO mamC_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chitzin Jesúsjo kyjaluꞌn: Twutzxix kxel nqꞌmaꞌn kyeꞌy; ajo tal qya lo, nim chꞌintljo toyaj ma kux tqꞌoꞌn kywutzjo txqantl. ");
INSERT INTO mamC_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Quꞌn jotxjo xjal, a ma kux qꞌonte toyaj, a kyoyajjo ma kux kyqꞌoꞌn, a t-xkyijlbꞌin; qalatzinl teꞌ tal yaj, a ma kux tqꞌoꞌn, a attaq tajbꞌin te tuꞌn tanqꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iteꞌtaq junjun kyexjal nchi yolintaq tiꞌjjo tnejil ja te naꞌbꞌl Dios, quꞌn ponixtaq chi kaꞌyin kyuꞌn abꞌj, a iteꞌktaq te bꞌinchbꞌilte, ex kyuꞌn jniꞌ oyaj, a xi kyqꞌoꞌnxjal te pitxbꞌilte. Chi Jesúsjo kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tzul jun te qꞌij, ex tojjo qꞌij anetziꞌn, jotxjo lo, a n-ok kykaꞌyiꞌn, tkyaqilx bꞌeꞌx kꞌwel yuchꞌin, ex ntiꞌx jun te abꞌj kyjel tibꞌaj juntl, aj tjapin tqꞌijil. ");
INSERT INTO mamC_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Xitzin kyqanin t-xnaqꞌtzbꞌin te kyjaluꞌn: Ay Xnaqꞌtzil, ¿Jtojtzila bꞌaꞌn tbꞌajjo ikyjo? ¿Altzila kye techil, tuꞌn tok qkaꞌyiꞌn, noq tuꞌn tel qnikyꞌa te, qa chꞌixtaq tul kanin tkyaqiljo lo? ");
INSERT INTO mamC_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chi Jesúsjo kyjaluꞌn: Kykaꞌyink kyibꞌa quꞌn noq chi kubꞌ sbꞌuꞌn. Quꞌn ilaꞌx tzul, ex ok k-okil kyqꞌoꞌn kyibꞌ tzeꞌnku ayiꞌn. Iky ktzajil tqꞌmaꞌn junjun kyjaluꞌn: Ayin weꞌ Tkꞌwal Diosqiꞌn, ex apente qꞌijjo ma tzul kanin jaꞌlin, tuꞌn tjapin bꞌaj kykyaqil, chichkulaꞌ. Me ayetzin kyeꞌ ntiꞌx tuꞌn kyxi lipey kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ajtzin t-xi kybꞌiꞌn kyeꞌ tqanil jniꞌ qꞌoj, ex aj kyjaw tzaqpaj xjal tuꞌn kyjyon qꞌoj kyxolile, mina chi jaw xobꞌa, quꞌn tuꞌn nej kbꞌajiljo jniꞌ lo kyxolxjal. Me naꞌmtaqx tpon tqꞌijil tuꞌn tjapin bꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ok tenl Jesús qꞌmalte kyjaluꞌn: Quꞌn ilxix tiꞌj nej tuꞌn kyqꞌojin junjun chꞌuq xjal tukꞌa junjuntl, ex junjun ma tij tnam kqꞌojlil tukꞌa juntl. ");
INSERT INTO mamC_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nimx kyaqnajnabꞌ, a kujxix kchi tzajil, junx kyukꞌa nimx waꞌyaj ex nimx yabꞌil, a noq jaꞌchaqku. Ex nim techil kylabꞌila twutz kyaꞌj, a bꞌeꞌx akux chi tzaj xobꞌxa kye. ");
INSERT INTO mamC_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Me naꞌmxtaq txi xkyeꞌ lo, aye kyeꞌ nej kchi okil tzyuꞌn kyuꞌnxjal, ex ktzyetil kylajchiy. Ok kchi xel qꞌiꞌn tojjo muꞌẍ ja te kynaꞌbꞌl Dios Judiy, tuꞌn kykawita. Ex ok kchi kꞌwelix qꞌoꞌn toj tze, ex ok kchi xel patiꞌn kyuꞌnxjal kywutz nmaq kawil ex kywutzjo txqantl nejinel noq tuꞌn npaja. ");
INSERT INTO mamC_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Me tojjo lo k-ajbꞌil te kyeꞌy te jun yekꞌbꞌil qa ojtzqiꞌnqiꞌn kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Me ntiꞌ tuꞌn kyok ten bꞌisilte jaꞌlin, tiꞌ tuꞌn t-xi kyqꞌmaꞌn te kolbꞌil kyeꞌy, aj tpon qꞌij anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Quꞌn tuꞌn ayin weꞌ kchin xel qꞌonte kyyola, a nimxixjo kynabꞌl, a mix aꞌlx jun kyajqꞌoja aku tzikyꞌx kyuꞌn, ex mix aꞌlx aku xkye tyolin kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Toj tkyaqiljo lo, atkula maj ayex kytatiy, ex kyitzꞌiꞌn, mo ayex kyxjalila mo jniꞌ kyukꞌiy kchi okil meltzꞌaj kyiꞌja, tuꞌn kyxi kꞌayita. Iteꞌla junjun kyeꞌ ok kchi kꞌwel bꞌyoꞌn kyuꞌn, ");
INSERT INTO mamC_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ex ok kchi okil ikyꞌiꞌn kyuꞌn kykyaqilxjal, noq tuꞌn tpajjo kynimbꞌila wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Me mixpela jun tal tsmal kywiꞌy knajil. ");
INSERT INTO mamC_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Chi weꞌkuxixa toj kynimbꞌila, tuꞌntzintla kykleta! ");
INSERT INTO mamC_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ajtzin t-xi kykaꞌyinjiꞌy tnam Jerusalén, aj tok kytxolbꞌin xoꞌl qꞌaqꞌ kyibꞌ tiꞌjile, bꞌiꞌnkutzintz kyuꞌn, qa chꞌixtaq tkubꞌ yuchꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tuꞌnpetziꞌn, jniꞌ xjal, ayeꞌ iteꞌ toj txꞌotxꞌ Judey, il tiꞌj tuꞌn kyex oq toj kꞌul. Ex ayetzin kyeꞌ, a iteꞌ toj tnam te Jerusalén, il tiꞌj tuꞌn kyetz oq. Ex ayetzin xjal iteꞌtaq toj kojbꞌil, mi tuꞌn kymeltzꞌaj toj tnam. ");
INSERT INTO mamC_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Quꞌn kyojjo qꞌij lo, ok kꞌwel nimitjo kawbꞌil kyibꞌajxjal, a kujxix wen, a tzꞌibꞌin taꞌye toj Tuꞌjil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ayex kyeꞌ tal qya, a chꞌixtaq kykubꞌ tzꞌaq, ex ayeꞌ tzmataq nbꞌaj miꞌẍin kyal, quꞌn tuꞌn nimx kyixkꞌoj tzul tojjo tnam anetziꞌn tuꞌnjo kawbꞌil ktzajil, kujxix wen, kyibꞌajjo jniꞌ xjal antza! ");
INSERT INTO mamC_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Iteꞌ junjun kye kkyimil tuꞌn kxbꞌil, a kabꞌe tste. Ex iteꞌ junjuntl kchi xel xoꞌn toj tze tojile tkyaqil twutz txꞌotxꞌ. Atzin teꞌ tnam Jerusalén, noqx techx kbꞌajil waꞌbꞌin teꞌ kyuꞌnxjal aj il, ex tzmaxi aj tjapin bꞌajjo ambꞌil, a xi tqꞌmaꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Iteꞌ techil ok kchi okil tiꞌj qꞌij ex tiꞌj yaye ex kyiꞌj cheꞌw. Ex atzin teꞌ twutz txꞌotxꞌ noqx kchi jawil najx kyexjal, ex nim kyxobꞌil ktzajil, quꞌn tuꞌn okx ktinilxjo ttxuyil aꞌ, aj tok ten puljil. ");
INSERT INTO mamC_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bꞌeꞌx kchi tzajil numtzꞌaj xjal tuꞌn kyxobꞌil, aj kyok ten bꞌisil, tiꞌ kkyꞌelix tibꞌaj tkyaqil twutz txꞌotxꞌ. Quꞌn majqexpe kye kykyaqil nchi qoptzꞌaj toj kyaꞌj exsin jniꞌ iteꞌ antza okx kchi luꞌlilx. ");
INSERT INTO mamC_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aj tul kanin tkyaqiljo lo, okpetzin kchin iwliltza, a ayiꞌn Tkꞌwal Ichin, aj ntzaja toj muj twutz kyaꞌj tukꞌa tkyaqil wipiꞌn ex jniꞌ nqoptzꞌajiyila. ");
INSERT INTO mamC_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aj t-xi xkyeꞌ jotxjo lo, qexix kykꞌuꞌja, ex kybꞌinchinku kyibꞌa, quꞌn chꞌixtaqtzin tkanin tqꞌijil kolbꞌil. ");
INSERT INTO mamC_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ex kubꞌ tqꞌmaꞌn Jesúsjo juntl techil lo: Kykaꞌyinka jun tqan iw mo qa aꞌlchaqx kye juntl tzetz. ");
INSERT INTO mamC_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aj tok kykaꞌyin aj ttzaj poqꞌle jniꞌ t-xaq, oktzin k-elil kynikyꞌtza te, qa chꞌixtaq tul kanin qꞌijil. ");
INSERT INTO mamC_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ikyxsin tteꞌn lo, aj tok kykaꞌyiꞌn aj tjapin bꞌajjo jniꞌ techil, tzꞌelkutzin kynikyꞌtza te, qa chꞌixtaq tul laqꞌeꞌ Tkawbꞌil qMan Dios kykꞌatza. ");
INSERT INTO mamC_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Twutzxix kxel nqꞌmaꞌn kyeꞌy, a qa tzul kanin jotxjo lo, a naꞌmtaq kykyimxjal, a iteꞌ tojjo tqꞌijil lo. ");
INSERT INTO mamC_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A kyaꞌj ex txꞌotxꞌ ok kchi bꞌajil, me mex weꞌ nyol nlayx chi kyij xkyeꞌ, tuꞌn mi chi japin bꞌaje. ");
INSERT INTO mamC_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kykaꞌyink kyeꞌ kyibꞌ, ex mina txi kychꞌuẍsin kyanmiꞌn tuꞌnjo jniꞌ achbꞌil at twutz txꞌotxꞌ tzeꞌnkuꞌ txꞌujtin, ex jniꞌ bꞌis tojjo kychwinqila jaꞌlin, quꞌn nyajqa njapinkutaq tqꞌijiljo lo, exsin nya bꞌinchin kyeꞌ kyten, bꞌeꞌx aku chi naja, ");
INSERT INTO mamC_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","tzeꞌnku jun txuk nkyij tjaqꞌ jun tzuybꞌil txuk. Quꞌn kykyaqilxjal, a najleqe toj tkyaqil twutz txꞌotxꞌ, mi naꞌbꞌinx kyuꞌn, aj kykyij tjaqꞌ tkawbꞌil Dios, a kujxix wen. ");
INSERT INTO mamC_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tuꞌnpetziꞌn, kybꞌinchinkutzin kyeꞌ kyibꞌ, ex chi naꞌn Diosa tkyaqil qꞌij, tuꞌntzintla kytzaqpaja toj tkyaqiljo kbꞌajil kyibꞌaj txqantl, ex tuꞌntzinlta kypon kaniꞌn nwutza, a ayiꞌn Tkꞌwal Ichin, tukꞌa tqꞌuqbꞌil kykꞌuꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Qꞌijl nxnaqꞌtzintaq te Jesús tojjo tnejil ja te naꞌbꞌl Dios. Atziꞌn tzeꞌnkuꞌ qnikyꞌin, antza nkyijetaq twiꞌ Wutz Olivos. ");
INSERT INTO mamC_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ex qlixjexix, nbꞌaj xiꞌtaqxjal bꞌil teꞌ tyol tojjo tnejil ja te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chꞌixtaq tul kanin nintz qꞌij te Waꞌj Pan, a jaꞌ n-ikyꞌsite Xjan Qꞌij, tuꞌn kywaꞌnxjal pan, a ntiꞌ txꞌamsbꞌilte. ");
INSERT INTO mamC_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ayeꞌ kynejil pale exqetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil nchi jyontaq tumil, tzeꞌn tten, tuꞌn tkyimetaq Jesús kyuꞌn, quꞌn tuꞌn attaq kyxobꞌil kyiꞌjxjal tuꞌn kyxi lipe tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Okxsin tajaw il toj tanmin Judas, a Iscariot tbꞌi nqꞌolbꞌajtz, ex toktaq te tkabꞌlajajin t-xnaqꞌtzbꞌin Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xiꞌ teꞌ xjal lo yolil kyukꞌa kynejil pale ex kyukꞌa kynejil xqꞌuqil teꞌ tnejil ja te naꞌbꞌl Dios, tuꞌntzintla kykyij toj wen, tzeꞌn tten tuꞌn t-xi qꞌoꞌyit Jesús toj kyqꞌobꞌjo xjal anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nimx i jaw tzalajjo xjal anetziꞌn, ex xi kytziyin, tuꞌn t-xi kyqꞌoꞌn pwaq te Judas. ");
INSERT INTO mamC_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Xi ttziyin te Judas ikyjo, ex jun paqx, ok ten jyol tumil tzeꞌn tuꞌn t-xi qꞌoꞌyit Jesús toj kyqꞌobꞌ pale, me atlaꞌ toj ewajil, tuꞌn mi kylixjal. ");
INSERT INTO mamC_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ultzin kanin qꞌij te Waꞌj Pan, a jaꞌ n-ikyꞌsite Xjan Qꞌij, tuꞌn kywaꞌnxjal pan, a ntiꞌ txꞌamsbꞌilte tkuꞌx, ex jaꞌ tuꞌn tkubꞌe bꞌyete jun tal rit te ikyꞌsbꞌilte. ");
INSERT INTO mamC_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","I xiꞌtzin chqꞌoꞌn Pegr exsin Juan tuꞌn Jesús, ex xi tqꞌmaꞌn kye kyjaluꞌn: Kux cheꞌx kyeꞌ bꞌinchilte wabꞌj te Xjan Qꞌij. ");
INSERT INTO mamC_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ayetzin kyetz xi kyqaniꞌn kyjaluꞌn: ¿Jaꞌtzin tajiy tuꞌn tkubꞌ qbꞌinchinjiꞌy wabꞌj? ");
INSERT INTO mamC_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Xi ttzaqꞌwin Jesúsjo kyjaluꞌn: Aj kyokxa toj tnam, ok k-okil kykꞌulbꞌiꞌn jun ichin, a qꞌiꞌn jun ẍoqꞌ aꞌ tuꞌn. Bꞌeꞌx kꞌaꞌ chex lipeꞌy tiꞌj tzma tja, jaꞌ k-okixi. ");
INSERT INTO mamC_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ex kꞌaꞌ txi kyqꞌmaꞌn te tajaw ja kyjaluꞌn: Chitzin Xnaqꞌtziljo kyjaluꞌn: ¿Altzin kyeꞌ ja ktzajil tqꞌoꞌn, a jaꞌ tuꞌn nwaniy junx kyukꞌa nxnaqꞌtzbꞌiꞌn tuꞌn tikyꞌsit Xjan Qꞌij quꞌn, chichkujiꞌy? ");
INSERT INTO mamC_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ktzajil tyekꞌin jun ja kyeꞌy, chebꞌex bꞌinchin wen tibꞌajxi juntl. Kꞌaꞌ kubꞌ kybꞌinchinjiꞌy qwa antza. ");
INSERT INTO mamC_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bꞌeꞌxsin i xiꞌ, ex jyet kyuꞌn tzeꞌnkuxjo otaq txi qꞌmaꞌn kye, tuꞌn Jesús. Oktzin ten bꞌinchil teꞌ wabꞌj te ikyꞌsbꞌilte Xjan Qꞌij. ");
INSERT INTO mamC_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Atzaj teꞌ tkanin or, oktzin qe Jesús tiꞌj meẍ junx kyukꞌa t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chi Jesús kye kyjaluꞌn: Jteꞌla majxla o kubꞌ nbꞌisiꞌn tuꞌn nwaꞌn junx kyukꞌiy, tuꞌntzintla tkubꞌ ikyꞌsitjo Xjan Qꞌij, a naꞌmxtaq nkyima. ");
INSERT INTO mamC_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Quꞌn twutzx kxel nqꞌmaꞌn kyeꞌy, qa nlay kubꞌ wikyꞌsiꞌn juntl majla tzmaxi chin waꞌl juntl majljiꞌy tiꞌj, aj tjapin bꞌaj t-xilin Xjan Qꞌij tzma toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ex jaw ttzyuꞌn Jesús jun tkꞌwel vin. Atzaj teꞌ tbꞌaj qꞌon chjonte te Dios tiꞌj, xi tqꞌmaꞌ kyjaluꞌn: Kytzyunxjiꞌy lo, exsin kysipinxa kyxoliliy; ");
INSERT INTO mamC_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","quꞌn twutzx kxel nqꞌmaꞌn kyeꞌy, qa nlay txi nkꞌwaꞌn juntl majljiꞌy kꞌwabꞌj lo, tzmaxiꞌ aj qkꞌwan junx kyukꞌiy tzma toj Tkawbꞌil qMaꞌn toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ex jaw ttzyuꞌn jun pan. Atzaj teꞌ tbꞌaj qꞌon chjonte te Dios tiꞌj, kubꞌ tpiẍin, exsin xi tqꞌoꞌntz kye. Chiꞌ kyjaluꞌn: Atzin wejiꞌy nxmilil lo, a kxel qꞌoꞌn tuꞌn tkyim, noq tuꞌn kykleta. Kybꞌinchim kyejiꞌy lo, noq te naꞌbꞌl weꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ikyx kubꞌ tbꞌinchin Jesúsjo tukꞌa kꞌwabꞌj, kybꞌajlinxiꞌ waꞌn. Chiꞌ kyjaluꞌn: Ajo kꞌwabꞌj lo, atzin jun akꞌaj tumiljo, a bꞌantnin tiꞌj tuꞌn Dios, tuꞌn kykyijxjal toj wen tukꞌa. Ajo nchkyꞌela, a k-elil chitj te kolbꞌil kyeꞌy, atzin k-okiljo te kujsbꞌilte yol anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Me ajo xjal, a kxel kꞌayin weꞌy, lu qꞌuqlik junx wukꞌiy tiꞌj meẍ. ");
INSERT INTO mamC_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Twutzxix teꞌ, qa kchin xel qꞌoꞌn weꞌ, a ayiꞌn Tkꞌwal Ichin, toj kyqꞌobꞌxjal, tzeꞌnkuxjo tzꞌibꞌiꞌn taꞌye toj Tuꞌjil Tyol Dios; me bꞌisbꞌajilxla teꞌ ichin, a kxel qꞌon weꞌy toj kyqꞌobꞌxjal. ");
INSERT INTO mamC_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ayetziꞌn t-xnaqꞌtzbꞌin bꞌeꞌx i ok ten qanilte kyxolx, alkyeꞌ kxel qꞌonte Jesús toj kyqꞌobꞌxjal. ");
INSERT INTO mamC_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nim chꞌin chꞌotjin tzaj kyxoljo t-xnaqꞌtzbꞌin Jesús, quꞌn kyajtaq tuꞌn kybꞌinte alkyexix nim toklin kyxol. ");
INSERT INTO mamC_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chi Jesúsjo kye kyjaluꞌn: Aye nmaq kawil, a nya nimil, toj nmaq tnam, nchi kawin nyakuj tajaw tnamqe, ex n-ok kyqꞌoꞌn kyibꞌ te tbꞌanil xjalqe. ");
INSERT INTO mamC_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Me ayetzin kyeꞌ, mina chi ok kyeꞌ ikyjo. Quꞌn alkyeꞌ nim chꞌintl toklin kyxola, il tiꞌj tuꞌn tok tqꞌoꞌn tibꞌ nyakutlaj jun kuꞌxin. Ex alkye teꞌ, a ktzajil qꞌoꞌn toklin te nejinel kyxol txqantl, il tiꞌj tuꞌn tok tqꞌoꞌn teꞌ tibꞌ te aqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Me altzila kyeꞌ nim chꞌintl toklintz? ¿Apetzilaꞌ a k-okil qe waꞌl tiꞌj meẍ, mo a nsipin wabꞌj? ¿Ma nyapetzila a te nim chꞌin toklin toj kywutza, a k-okil qe waꞌl tiꞌj meẍ? Me metzin weꞌ, a te nim tokliꞌn a n-ajbꞌin kye txqantl tzeꞌnku weꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ayetzin kyeꞌ kukx o chi ten kyeꞌ wukꞌiy toj tkyaqiljo yajbꞌil, a o tzikyꞌx wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tuꞌnpetziꞌn, kxel nqꞌoꞌn weꞌ kyokliꞌn toj nkawbꞌila, tzeꞌnkuxjo ma tzaj qꞌoꞌn weꞌ woklin toj Tkawbꞌil nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ex kxel nqꞌoꞌn kyokliꞌn tuꞌn kywaꞌn ex tuꞌn kykꞌwaꞌn wukꞌiy tojjo Kawbꞌil anetziꞌn. Ex kchi kꞌwel qeꞌy toj qꞌuqbꞌil tuꞌntzin kykawiꞌn wukꞌiy kyibꞌajjo kabꞌlajaj chꞌuq xjal, a tzajnin tiꞌj te qtzan qxeꞌchil Israel. ");
INSERT INTO mamC_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ex ikyl tqꞌma tAjaw Tkyaqiljo kyjaluꞌn: Simun, Simun, bꞌintza: Ma qanajtz teꞌ tuꞌn tajaw il, tuꞌn tyekajtza wen, tzeꞌnkuꞌ tuꞌn t-xtulit triy. ");
INSERT INTO mamC_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Me ayin weꞌ ma chin kubꞌsin nwutz tiꞌja te Dios, tuꞌntzintla mina kubꞌ numja toj tnimbꞌila. Ex ajtzin tmeltzꞌaj juntl majla toj tnimbꞌila, wetzin mojintltza kyukꞌa tukꞌiy, tuꞌn kyweꞌxix wen toj kynimbꞌil, chi Jesús te Pegr. ");
INSERT INTO mamC_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Me atzin te Pegr xi ttzaqꞌwin kyjaluꞌn: Ay Taa, loqiꞌn lo, qꞌoꞌnx weꞌ wibꞌ tuꞌn nteꞌn junx tukꞌiy toj tkyaqil, qa toj tze expe qa ma chin kyima tukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Xi ttzaqꞌwin Jesús kyjaluꞌn: Ay Pegr, twutzxix kxel nqꞌmaꞌn tey, texjo qnikyꞌin lo, a naꞌmtaqx toqꞌ tman ekyꞌ, kchin kꞌwel tewiꞌn oxe maj kywutzxjal, ex kxel tqꞌmaꞌn, qa nya ojtzqiꞌnqiꞌn tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ex xi tqanin Jesús kye kyjaluꞌn: ¿Ma attzin jun tiꞌla mix kanine kyeꞌy, tej kyxi nsmaꞌn jun maj, a ntiꞌ kypaꞌy, ntiꞌ kychꞌuꞌẍa te tkꞌwel kypwaqa ex ntiꞌ kyxjabꞌa xiꞌ? Mix tiꞌ, chi chiꞌ, tej t-xi kytzaqꞌwin. ");
INSERT INTO mamC_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ex xi tqꞌmaꞌntl Jesús kyjaluꞌn: Me metziꞌn jaꞌlin, ankye teꞌ at tpa, bꞌaꞌn tuꞌn t-xi tiꞌn, ex bꞌaꞌn tuꞌn t-xi tiꞌn tchꞌuꞌẍ, qa at. Exsin qa at juntz, a ntiꞌ tkxbꞌil, a kabꞌe tste, bꞌaꞌn tuꞌn t-xi tkꞌayin jun tal tkamiẍ, mo jun ttxoꞌw, exsin tuꞌn ttzaj tlaqꞌoꞌn juntz. ");
INSERT INTO mamC_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Quꞌn twutzxix kxel nqꞌmaꞌn kyeꞌy, qa il tiꞌj tuꞌn tjapin bꞌaj wiꞌja a tzꞌibꞌin taꞌ toj Tuꞌjil Tyol Dios, a iky ntqꞌmaꞌn kyjaluꞌn: Ex kxel qꞌoyit junx kyukꞌa a nya wen xjalqe. Oc japin bꞌajx teꞌ jotxjo jniꞌ tzꞌibꞌin wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chi chiljo t-xnaqꞌtzbꞌin kyjaluꞌn: Taa, loqe kabꞌe kxbꞌil lo, a kabꞌe kyste. Xi ttzaqꞌwin Jesús kyjaluꞌn: Kukxjo jaꞌlin, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Etzin Jesús, exsin xiꞌ twiꞌ Wutz Olivos, tzeꞌnxtaqjo n-oketaq tuꞌn; ex bꞌeꞌx bꞌaj ikyꞌ lipeꞌ jniꞌ t-xnaqꞌtzbꞌin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Atzaj teꞌ kykanin, iky xi tqꞌmaꞌn kye kyjaluꞌn: Kux chi naꞌnqiꞌy Dios, tuꞌntzintla mina chi kubꞌ tzꞌaqa toj tqꞌobꞌ tajaw il. ");
INSERT INTO mamC_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bꞌeꞌx el tlaqwin te Jesús tibꞌ kyiꞌj t-xnaqꞌtzbꞌin, bꞌalaqa jun mo kabꞌe echj xi laqꞌeye. Kubꞌ meje, exsin ok tentz naꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Chiꞌ kyjaluꞌn: NMaꞌn, chin tklomila teꞌ tkyaqil jniꞌ kkyꞌelix wuꞌn; me noqit nya a tzeꞌnku waja, qalaꞌ atla tzeꞌnkuxjo taja. ");
INSERT INTO mamC_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tzmataq nyolin, jun paqx tzaj jun angel toj kyaꞌj qꞌolte tipin. ");
INSERT INTO mamC_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nimx jaw bꞌisin Jesús tuꞌn nimxtaqjo kyixkꞌoj tuꞌn tikyꞌx tuꞌn. Me tuꞌn ikyjo, jaw tiꞌnxix tqꞌajqꞌojil twiꞌ tuꞌn tnaꞌn Dios. Tuꞌnpetziꞌn, ox txꞌuljinx aꞌ tiꞌj, nchi kubꞌik tzꞌaq twutz txꞌotxꞌ, ex ikytaq chi kaꞌyin tzeꞌnku chikyꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tbꞌajlinxitzin naꞌn Dios, jawtzin weꞌkstz, exsin aj meltzꞌaj kykꞌatzjo t-xnaqꞌtzbꞌin, me noqtaql nchi ktanl kyeꞌ tuꞌn bꞌisbꞌajil, tej kyel jyet. ");
INSERT INTO mamC_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chi Jesúsjo kye kyjaluꞌn: ¿Tiquꞌnil nchi ktaꞌn? Kux chi jaw weꞌksa, ex kux chi naꞌn Dios, tuꞌntzin mina chi kubꞌ tzꞌaqiꞌy toj tqꞌobꞌ tajaw il. ");
INSERT INTO mamC_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tzunxtaq nyolin Jesús kyukꞌa t-xnaqꞌtzbꞌin, tej kypon tilj txqan xjal. Ataq Judas, a attaq toklin kyxol kabꞌlajaj t-xnaqꞌtzbꞌin, nejnin kywutz. Ok laqꞌe maꞌtzil te Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Me atzin te Jesús iky xi tqꞌmaꞌn te kyjaluꞌn: Ay Judas, ¿Ma noqtzin tuꞌn jun maꞌtzj ok chin xele tqꞌoꞌniy toj kyqꞌobꞌxjal, a ayiꞌn Tkꞌwal Ichin? ");
INSERT INTO mamC_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ayetaqtzin kyeꞌ, a iteꞌtaq tukꞌa Jesús, tej tok kykaꞌyin, ex tok kybꞌiꞌn a nbꞌajtaq, xi kyqanin kyjaluꞌn: Taa, ¿Oktzin kchi okil qtxꞌeꞌmiꞌn tuꞌn qkxbꞌila, tuꞌn tkleta? ");
INSERT INTO mamC_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Me at jun te, a mix kubꞌ tyoꞌne, qalaꞌ bꞌeꞌx xi lipin txꞌemil teꞌ taqꞌnil tnejil pale. Bꞌeꞌx el tjaspiꞌn tẍkyin, a at toj tman qꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Me ante Jesús xi tqꞌmaꞌn kyjaluꞌn: Kukxjo, chi tenku xjaljo. Ok tmekoꞌn te Jesús tẍkyinj aqꞌnil anetziꞌn, ex bꞌeꞌx qꞌanit tej xjal te jun majx. ");
INSERT INTO mamC_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Xitzin tqꞌmaꞌn Jesús kye kynejil pale, kye xqꞌuqil tnejil ja te naꞌbꞌl Dios, ex kye nejinel kyexjal; aye xjal lo, a ayetaqtziꞌn otaq chi ul tzyulte Jesús. Chiꞌ kyjaluꞌn: ¿Tiquꞌnil ma chi ula tzyul weꞌy, qꞌimila kykxbꞌila ex kytzeꞌy, nyakuj iky ma chin ele wejiꞌy te kyeꞌy tzeꞌnku jun ileqꞌ? ");
INSERT INTO mamC_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kykyaqil qꞌij o chin ten weꞌ kyukꞌiy tojjo tnejil ja te naꞌbꞌl Dios, me mix jun maj ẍin ok kytzyuꞌn. Me mapen kanin kyeꞌ kyqꞌijil, tuꞌn tkubꞌ kybꞌinchinjiꞌy a kyaja, quꞌn atziꞌn tqꞌijiljo, tuꞌn tkawin tajaw qlolj. ");
INSERT INTO mamC_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ok tzyuꞌn Jesús kyuꞌn, exsin xi kyiꞌntz tzma tja kynejil pale. Atzin te Pegr, najchaq xi lipeye teꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Atzaj teꞌ kykanin, bꞌeꞌx kubꞌ kykchoꞌn kyqꞌaqꞌ nkyꞌaj peꞌn, exsin i ok txoletz tiꞌj. Ex majx te Pegr tokxtaq kyxol. ");
INSERT INTO mamC_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Me jun paqx, el tnikyꞌtzajil Pegr tuꞌn jun txin, a n-aqꞌnintaq tojjo ja anetziꞌn. Ok kyim wen tiꞌj Pegr, tej qꞌuqlektaq tiꞌj qꞌaqꞌ, exsin chitzjo kyjaluꞌn: Ex majx teꞌ luꞌn attaq tukꞌa Jesúsch. ");
INSERT INTO mamC_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Me bꞌeꞌx kubꞌ tewin te Pegr. Chiꞌ kyjaluꞌn: Ay txin, nyax wojtzqiꞌn wejiꞌy ichin anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aꞌkxtaqku teꞌ ikyjo, tej tiwle juntl majl Pegr tuꞌn juntl xjal, a iky tqꞌmaꞌ kyjaluꞌn: Ex majx te at kyxoljo xjal anetziꞌn. Me ante Pegr chiꞌ kyjaluꞌn: Me mina, nyaqin wejiꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bꞌalaqa otaq tzikyꞌ jun or ikyjo, tej tjaw tiꞌn tibꞌ juntl xjal, a chiꞌ kyjaluꞌn: Twutzxpen teꞌ, ajin teꞌ xjal lo attaq tukꞌa Jesús, quꞌn ex aj Galiley te luꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Xi ttzaqꞌwin Pegr kyjaluꞌn: ¡Mina! Mi wojtzqiꞌn weꞌ, ex ntiꞌx n-el nnikyꞌa te, tiꞌ qiꞌjil nyoliniy. Jun paqx, naꞌmtaqxpe tbꞌaj yolin te Pegr, tej tjaw oqꞌ te tman ekyꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tzaj meltzꞌaj te tAjaw Tkyaqil, exsin xi kyimtz toj twutz Pegr. Bꞌeꞌxpen i ul julkꞌaj tej tyol Jesús toj tkꞌuꞌj Pegr, aj otaq chex tqꞌmaꞌn te kyjaluꞌn: A naꞌmxtaq toqꞌ tman ekyꞌ, ok kchin kꞌwel tewiꞌn oxe maj. ");
INSERT INTO mamC_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bꞌeꞌx etz tiꞌn te Pegr tibꞌ kyxol xjal, exsin ok tentz oqꞌil wen. ");
INSERT INTO mamC_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ayetzin kyej xjal, a tzuntaq nchi xqꞌuqin tiꞌj Jesús, noqxtaq nchi jaw xmayin tiꞌj, exsin n-oktaq kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ok kymaqsiꞌn twutz Jesús, exsin xi kyqanin te kyjaluꞌn: Kanintzin tiꞌj. ¿Ankye s-ok bꞌyoꞌntiych? ");
INSERT INTO mamC_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nimku txqantl yol te xmaybꞌil i bꞌaj ok ten qꞌmalte te. ");
INSERT INTO mamC_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Atzaj teꞌ qsqix, i ok kychmoꞌn kye tnejil Judiy kyibꞌ, junx kyukꞌa kynejil pale, exqetziꞌn jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil, exsin xi kyiꞌntz Jesús twutz. Atzaj teꞌ kykanin, xitzin kyqanintz te kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Qꞌmantza qeꞌy, ¿Aj qa ajiy Crist, a at toklin tuꞌn Dios? Chi Jesús kye kyjaluꞌn tej t-xi ttzaqꞌwin: Qa ayiꞌn, qa nchijiꞌy, nlay chinx kynimiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ex qatzin ma txi nqanintza jun nxjelbꞌitza kyeꞌy, nlay chin tzaj kytzaqꞌwiꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Me texjo qꞌij lo, toj tman qꞌobꞌ qMan Dios, a nimxix tipin; ok kchin kꞌwel qeyiꞌy kawil tukꞌa, a ayiꞌn Tkꞌwal Ichin. ");
INSERT INTO mamC_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tej kybꞌinte ikyjo, kykyaqilx xi qaninte te kyjaluꞌn: ¿Apela tejitza kꞌwalbꞌaj te Dios? Xi ttzaqꞌwin Jesús kye kyjaluꞌn: Twutzx teꞌ, ayinqin wejiꞌy, ikyxjo tzeꞌnku ma tzaj kyqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chi chiljo kyjaluꞌn: ¿Me tiꞌ til txqantl tstiyiltz te qe? A tojx ttzi ma chi bꞌajetza jniꞌ xoꞌj yol tuꞌn tiꞌj Dios, a ma chi qbꞌi, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","I jaw weꞌ kykyaqilx, exsin xi kyiꞌn Jesús tzmax twutz Pilat. ");
INSERT INTO mamC_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Twutz Jesús i bꞌaj ok ten stzꞌimilte jniꞌ yol tiꞌj. Chi chiꞌ kyjaluꞌn: Ma tzꞌel jyetjo ichin quꞌn lo, a tokxix tilil tuꞌn, tzeꞌn tuꞌn kyjawe naje qxjalila. Tok qꞌmalte kyexjal, qa nya il tiꞌj tuꞌn t-xi kychjoꞌn kꞌaybꞌil teꞌ nmaq kawil, ex tzunxix ntzaj tqꞌmaꞌn, qa aku a Crist, a skꞌoꞌnxix tuꞌn Dios, ex qa nmaq kawil. ");
INSERT INTO mamC_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Xitzin tqanin Pilat te Jesús kyjaluꞌn: ¿An tejiy nmaq kawil kye Judiy? Ayiꞌn, ikyxjo tzeꞌnku ma tzaj tqꞌmaꞌn, chi Jesúsjo. ");
INSERT INTO mamC_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Xitzin tqꞌmaꞌn Pilat kyeꞌ kynejil pale, ex kyeꞌ jniꞌ xjal, a iteꞌtaq antza. Chiꞌ kyjaluꞌn: Qa oꞌkxjo lo, ntiꞌ jun teꞌ ichin til ma knettz wuꞌn, chi Pilatjo. ");
INSERT INTO mamC_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Me noqx jaw kyinx kyibꞌ, tej kybꞌin teꞌ ikyjo, ex xi kyqꞌmaꞌn kyjaluꞌn: Me noqx ma chi jaw najx kyexjal tojjo tnam lo kyuꞌnjo jniꞌ t-xnaqꞌtzbꞌil. Antza tzaje xkyeye tuꞌn toj txꞌotxꞌ te Galiley, exsin luꞌltz lajoꞌn tuꞌn tojjo txꞌotxꞌ lo te Judey. ");
INSERT INTO mamC_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tej tbꞌinte Pilatjo yol lo, xitzin tqanintz, qa aj Galileytaq Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Atzaj teꞌ t-xi qꞌmaꞌn te qa te Galileytaq, bꞌeꞌxsin xi tsmaꞌntz Jesús tzma twutz Herodes, a nmaq kawiltaq toj tnam te Galiley, quꞌn kyojjo qꞌij anetziꞌn, ataqtza taꞌye Herodes toj tnam te Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bꞌeꞌx jaw tzalaj te Herodes, tej tiwle Jesús tuꞌn, quꞌn ilaꞌxi maj tajtaq tuꞌn tlonte, quꞌn tuꞌn nimku tqanil otaq tbꞌi tiꞌj Jesús, ex tajtaq tuꞌn tlonte jun techil tipin. ");
INSERT INTO mamC_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nimx ok ten qanilte te, me atzin te Jesús ntiꞌx chꞌin teꞌ xi ttzaqꞌwin. ");
INSERT INTO mamC_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ex majqextaq kyeꞌ jniꞌ kynejil pale, exqetziꞌn jniꞌ xnaqꞌtzil tiꞌj ojtxe kawil iteꞌtaq antza; tzunx nchi labꞌtextaq wen tuꞌn t-xi kypatin Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tuꞌn ikyjo, bꞌeꞌx ok xmayin te Jesús tuꞌn Herodes, ex kyuꞌn xoꞌl qꞌaqꞌ, a iteꞌtaq xqꞌuqilte. Exsin ok qꞌoꞌn t-xbꞌalin, a tzunxtaq qopinx wen, nyakutlaj nmaq kawil. Kubꞌ kybꞌinchin ikyjo, noq te kyxmaybꞌil tiꞌj. Tbꞌajlinxitziꞌn ikyjo, bꞌeꞌx tzaj smaꞌntl Jesús tuꞌn Herodes twutzl Pilat. ");
INSERT INTO mamC_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Texjo qꞌij anetziꞌn bꞌeꞌx ok tukꞌlin Pilat tibꞌ tukꞌa Herodes, quꞌn kyajqꞌojtaq kyibꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","I ok tchmoꞌn te Pilat jotqexjo jniꞌ kynejil pale, jniꞌqe kawil exsin tkyaqil xjal, ");
INSERT INTO mamC_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","exsin xi tqꞌmaꞌn kye kyjaluꞌn: Ayiꞌy ma chi ul qꞌinte ichin lo nwutza, exsin nkyqꞌmaꞌn, qa ma jaw naj kyxjalila tuꞌn. Me kywutza, ma bꞌaj nqaniꞌn te tiꞌjjo ma bꞌaj kyqꞌmaꞌn tiꞌj, me ntiꞌ jun wetza til ma tzꞌel jyet wuꞌn, ");
INSERT INTO mamC_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ex ikyx te Herodesjo, ntiꞌ tilx xjyet tuꞌn. Quꞌn tzeꞌn ttentz saj tmeltzꞌintl. Kan lo, ntiꞌ tetz il ma bꞌant tuꞌn, a atit kyimin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ok kꞌwel nqꞌmaꞌn tuꞌn tjubꞌchit tetz, me bꞌeꞌx kxel ntzaqpiꞌn, aj tbꞌaj jubꞌchit. ");
INSERT INTO mamC_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Toj nintz qꞌij, iltaq tiꞌj tuꞌn t-xi tzaqpet jun xjal, a tkuꞌxtaq toj tze. ");
INSERT INTO mamC_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Me kykyaqilx xjal i jaw ẍchꞌin junx: ¡Ntiꞌpen teꞌ ikyjo! ¡A te Barrabás tuꞌn t-xi tzaqpet! ");
INSERT INTO mamC_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Atzin te Barrabás otaq kux qꞌoꞌn teꞌ toj tze noq tuꞌn tpaj tjoybꞌin qꞌoj tiꞌj kawil, ex tuꞌn otaq kubꞌ tbꞌyoꞌn jun xjal. ");
INSERT INTO mamC_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Xi yolinl juntl majl Pilat kye, quꞌn tuꞌn tajtaq tuꞌn t-xi ttzaqpiꞌn Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Me noqx jaw kyiꞌn kyexjal tqꞌajqꞌojil kywiꞌ: ¡Pejkꞌinksa twutz cruz tuꞌn tkyim! ¡Pejkꞌinksa twutz cruz tuꞌn tkyim! chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Toj tox majin, xi tqꞌmaꞌn Pilat kye kyjaluꞌn: Qalaꞌ, ¿Tiꞌxixsin iltz ma bꞌant tuꞌn? Ntiꞌx wetza til ma jyet wuꞌn, a atit kyimin tiꞌj. Ok kꞌwel jubꞌchit tetz, me bꞌeꞌx kxel ntzaqpiꞌn, aj tbꞌaj jubꞌchit. ");
INSERT INTO mamC_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Noq i bꞌaj jaw tiljx kyexjal tuꞌn kyẍchꞌin. Nchi qanlaj tiꞌj tuꞌn tkubꞌ bꞌyoꞌn Jesús twutz cruz. Nimx i ẍchꞌin tzmaxi kubꞌ qeꞌn, tej ttzaj tziyiꞌn a nkyqanintaq. ");
INSERT INTO mamC_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Xi ttziyinx te Pilatjo, a ntzaj qanin te: ");
INSERT INTO mamC_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jatztzin ttzaqpiꞌn Pilatjo Barrabás, a ichin tkuꞌxtaq toj tze noq tuꞌn tpaj tbꞌujbꞌin ex tbꞌiꞌybꞌin, ikyxjo tzeꞌnku nkyqanintaqxjal, exsin kubꞌ tbꞌinchin tukꞌa Jesús tzeꞌnkuxjo nkyqanintaq. ");
INSERT INTO mamC_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Atzaj teꞌ t-xi qꞌiꞌn Jesús tuꞌn tjaw pejkꞌit twutz cruz, bꞌeꞌx ok kytzyuꞌn jun ichin aj Sirene, Simun tbꞌi, tzajnintaqjo ichin anetziꞌn toj kojbꞌil. Jaw kyqꞌoꞌn cruz tibꞌaj, tuꞌntzintla t-xi tiqin, ex tuꞌntla tok lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma nintz texjal i ok lipe tiꞌj Jesús, ex ma nintz teqya ox chi oqꞌx, ex ox chi weqinx, tuꞌn kybꞌisbꞌin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Xi kaꞌyin Jesús kyiꞌj, ex xi tqꞌmaꞌn kye kyjaluꞌn: Ayiꞌy qya te Jerusalén, mina chi oqꞌ kyeꞌ wiꞌja, qalaꞌ chi oqꞌx kyeꞌ kyiꞌjxa, exsin kyiꞌj kyala. ");
INSERT INTO mamC_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Quꞌn tzul kanin te tqꞌijil, aj kyqꞌumle yol lo: Kyꞌiwlinqexix kyeꞌ qya, a mibꞌin chi alin, ayeꞌ ntiꞌ jun kyal s-ok, ex ntiꞌ jun kꞌwal xmiꞌẍin kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tzmaxipetzin kchi okil ten kye xjaljo ẍchꞌilte kye wutz kyjaluꞌn: Ayiꞌy wuutz, kux kytzaj tilje qibꞌaja; ex iky kxel kyqꞌmaꞌnjo kyeꞌ muchꞌila wutz kyjaluꞌn: Qo tewinx qe. ");
INSERT INTO mamC_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Quꞌn qa iky nbꞌant kyuꞌn xjal wiꞌja jaꞌlin, a ayiꞌn ntiꞌ wila, ¿Yajtzil tetzjo kyiꞌj xjal toj Jerusalén jniꞌlixla kbꞌantile kyuꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","I xi qꞌiꞌn kabꞌetl aj il, tuꞌntzintla kyjaw pejkꞌin twutz cruz junx tukꞌa Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Atzaj teꞌ kykanin twiꞌ wutz Tbꞌaqil Twiꞌ Kyimnin tbꞌi, jaw pejkꞌin Jesús twutz cruz exqetziꞌn kabꞌe aj il, jun toj tman qꞌobꞌ, ex juntl toj tẍnayaj. ");
INSERT INTO mamC_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Naꞌn Jesús Dios, tej tjaw qꞌoꞌn twutz cruz, ex chiꞌ kyjaluꞌn: Ay nMaan, najsima kyil, quꞌn tuꞌn mina n-el kynikyꞌ tiꞌjjo nkubꞌ kybꞌinchin. Ayetzin kyej xjal a xoꞌl qꞌaqꞌqetaq i bꞌaj saqchan kyxol tzeꞌn tuꞌn tsipe teꞌ t-xbꞌalin Jesús kyxolile. ");
INSERT INTO mamC_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tzuntaq nchi kaꞌyin kyexjal tiꞌtaqjo nbꞌaj; ayetzin kyej kawilqetaq, noq nchi jaw xmayintaq kyeꞌ tiꞌj Jesús. Chi chiꞌ kyjaluꞌn: Qa ilaꞌ xjal o klet tuꞌn; klomtzin tibꞌtza tilx tibꞌa jaꞌlin, a qa twutzx, qa Kolila, a Crist, a skꞌoꞌnxix tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Majqexpe kyeꞌ xoꞌl qꞌaqꞌ i ok ten xmayil tiꞌj Jesús. Nchex laqꞌetaq tkꞌatz, exsin nxitaq kyqꞌoꞌn txꞌam vin te tkꞌwaꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Chi chiꞌ kyjaluꞌn: A qa axixtza nmaq kawil kyibꞌaj xjal Judiy, klomtzin tibꞌtza tilx tibꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ex attaq jun yol tzꞌibꞌink tibꞌajxi twiꞌ, a ikytaq ntqꞌmaꞌn kyjaluꞌn: Ate Jesúsjo, a Nmaq Kawil kye aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Atzin teꞌ jun bꞌinchil il, a yoꞌbꞌinkstaq twutz cruz, tzuntaq nxmayintaq teꞌ tiꞌj Jesús kyjaluꞌn: A qa axixjiy Crist, a Kolil, a skꞌoꞌnxix tuꞌn Dios, klomtzin tibꞌtza tilx tibꞌa, ex majqoxpe qeꞌ, qo tkloma. ");
INSERT INTO mamC_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tzajtzin ttzaqꞌwin teꞌ juntl aj il te tukꞌa kyjaluꞌn: ¿Ma ntiꞌxsin chꞌin tchewil Dios ntzaj tiꞌja? ¿Ma minatzin nkubꞌ tnabꞌlin, qa ikyx kawbꞌiljo ma kubꞌ qꞌoꞌn tey, tzeꞌnkuꞌ te xjal lo? ");
INSERT INTO mamC_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bꞌape qetz, nqqaninku qe quꞌn luqin qchjoꞌn tiꞌj tkyaqiljo nya bꞌaꞌn o bꞌant quꞌn. Qalatzin teꞌ ichin lo ntiꞌ teꞌ il ma bꞌant tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tzaj tqꞌmaꞌnljo xjal kabꞌel tyol kyjaluꞌn: Ay wAjaw, wexsin chin tzaj tnaꞌn chꞌin we, aj t-xi xkyeꞌ Tkawbꞌila. ");
INSERT INTO mamC_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Xi ttzaqꞌwin Jesús kyjaluꞌn: Twutzxix kxel nqꞌmaꞌn tey, qa bꞌeꞌxku jaꞌlin ok ktenbꞌila wukꞌiy toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Teꞌ tok kabꞌlaj qꞌij, ex tzmaxi toj oxe or te qale, bꞌeꞌx ok yupj twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mix qopinil te qꞌij, ex bꞌeꞌx kubꞌ laqjjo ma tij xbꞌalin toj nikyꞌjin, a tokxtaq te paꞌbꞌl toj tnejil ja te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jaw tiꞌnxix te Jesús tqꞌajqꞌojil twiꞌ. Chiꞌ kyjaluꞌn: Ay Taa, toj tqꞌobꞌa kxel woqxenin weꞌ wanim. Tej tbꞌaj tqꞌmaꞌn tyol ikyjo, bꞌeꞌx el kyim. ");
INSERT INTO mamC_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Atzaj teꞌ tlonte kawil kyxol xoꞌl qꞌaqꞌ aj Rom tkyaqiljo otaq bꞌaj, jaw tnimsin tbꞌi Dios, ex chiꞌ kyjaluꞌn: Twutzxpentetz, ntiꞌtaq teꞌ ichin til lo. ");
INSERT INTO mamC_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jotxjo jniꞌ xjal iteꞌtaq antza, a kyli jniꞌ otaq bꞌaj, ox tzꞌok kyqꞌajtzin ttzi kykꞌuꞌj te bꞌisbꞌajil, tej kyajtz. ");
INSERT INTO mamC_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Me ayetzin kye xjal, a ojtzqiꞌntaq Jesús kyuꞌn, exqetziꞌn jniꞌ qya, a i tzaj lipe tiꞌj tzmax toj txꞌotxꞌ te Galiley, najchaq chꞌintl i kyije tene kyeꞌ kaꞌyil tiꞌjjo jniꞌ nbꞌajtaq antza. ");
INSERT INTO mamC_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Toj tnam te Arimatey te txꞌotxꞌ te Judey, attaq jun tbꞌanil ichin, Jse tbꞌi. Tzꞌaqlexixtaqjo xjal anetziꞌn, exsin toktaq te tajlaljo jun chꞌuq kykawil aj Judiy. Tkyꞌeꞌtaq te Jse tiꞌjjo nbꞌanttaq kyuꞌn jniꞌ tukꞌa, quꞌn tuꞌn tzuntaq nyon tiꞌj Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tuꞌnpetziꞌn, xiꞌ jyolte Pilat, exsin xi tqanintz t-xmilil Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Atzaj teꞌ tkuꞌtz t-xmilil Jesús twutz cruz, kux tbꞌalqꞌin toj jun iqbꞌil tbꞌanilx wen, exsin okx tqꞌoꞌntz toj jun tjulil kyimnin, a likuꞌnkxtaq twutz piky, a ntiꞌtaq kyimnin otaq tzꞌokx toj. ");
INSERT INTO mamC_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tkyaqiljo lo kubꞌ tbꞌinchin Jse liwey, quꞌn ntiꞌtaql ambꞌil, quꞌn chꞌixtaq tok qaq or te qale. Quꞌn tojjo or anetziꞌn, iltaq tiꞌj tuꞌn t-xi tzaqpet aqꞌuntl, tuꞌn t-xi xkyejo qꞌij te ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ayetzin kyej qya, a otaq chi tzaj lipe tiꞌj Jesús tzmax Galiley, i pon kanin tzmax ttzi jul, ex ok kykaꞌyin tzeꞌn oke t-xmilil Jesús, tej tkyij muquꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Atzaj teꞌ kypon kanin kyja, i ok ten bꞌinchil teꞌ jniꞌ qꞌanbꞌil, a n-ajbꞌin te kꞌokꞌjsbꞌil t-xmilil jun kyimnin, exsin qꞌanbꞌil, a tuꞌn tok suꞌyit tiꞌj, tuꞌn mi tzuwixe. Me bꞌeꞌx i ajlantz tojjo qꞌij te ajlabꞌl, tzeꞌnxjo nqꞌumlajtz toj Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Toj tnejil qꞌij te seman, qlixjexix wen, i ul kanin kyej qya ttzi jul. Tzaj kyiꞌn jniꞌ qꞌanbꞌil te kꞌokꞌjsbꞌil, a otaq bꞌaj kybꞌinchin. ");
INSERT INTO mamC_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Atzaj teꞌ kyul kanin, txulinx kywutz tiꞌj, qa otaq txi yekꞌj tej abꞌj, a kyij qꞌoꞌn te jupbꞌilte ttzi jul. ");
INSERT INTO mamC_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","I okx toj jul, me ntiꞌ t-xmilil qAjaw Jesús jyet kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bꞌeꞌx i jaw xobꞌ, ex ntiꞌ tumil jyet kyuꞌn tiꞌtaqjo tuꞌn tkubꞌ kybꞌinchinl. Ex jun paqx, kyli kabꞌe ichin, a waꞌlqetaq kykꞌatz, a tzunxtaq tilkꞌajjo kyxbꞌalin. ");
INSERT INTO mamC_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bꞌeꞌx tzaj txqan kyxobꞌil, ex i kubꞌ mukꞌe tzmax twiꞌ txꞌotxꞌ. Me ayetzin kyej ichin, a waꞌlqetaq antza, iky tzaj kyqꞌmaꞌn kyjaluꞌn: ¿Titzin quꞌn nchi jyoꞌn kyxol kyimnin tiꞌjjo a itzꞌ? ");
INSERT INTO mamC_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nyatza taꞌye tzaluꞌn, qalaꞌ ma jaw anqꞌin juntl majl. Kynaꞌntzinjiꞌy jniꞌ yol xbꞌaj tqꞌmaꞌn kyeꞌy tiꞌjjo lo, tej atxtaq toj txꞌotxꞌ te Galiley: ");
INSERT INTO mamC_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Qa iltaq tiꞌj tuꞌn t-xi qꞌoꞌn Jesús, a Tkꞌwal Ichin, toj kyqꞌobꞌ bꞌinchil il, ex tuꞌn tjaw pejkꞌin twutz tcruz; me toj toxin qꞌij, iltaq tiꞌj tuꞌn tjatz anqꞌin juntl majl. ");
INSERT INTO mamC_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bꞌeꞌxpetziꞌn, i ul julkꞌajjo tyol Jesús toj kykꞌuꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ex atzaj teꞌ kyaj meltzꞌaj ttzi jul, bꞌeꞌx i ok ten qꞌmalte jniꞌxjo otaq kybꞌi, exsin otaq kyli kyeꞌ junlajaj t-xnaqꞌtzbꞌin Jesús, ex kye kykyaqil xjal. ");
INSERT INTO mamC_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ate Mariy, aj Xleꞌn; Juana; Mariy, a tnana Santyaw; exqetzintljo txqantl qya, ayetzin i xi qꞌinte tqaniljo kyeꞌ t-xnaqꞌtzbꞌin Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Me kykyꞌeꞌtaq kye t-xnaqꞌtzbꞌin tuꞌn t-xi kynimin, quꞌn toj kynabꞌl nyakuj noq toj kywiꞌtaqjo qya otaq tzꞌokx. ");
INSERT INTO mamC_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Me atzin te Pegr, bꞌeꞌxkux tzaj rinin teꞌ, tuꞌn tul kanin tzma ttzi jul. Atziꞌn teꞌ tokx tkaꞌyin, oꞌkqexjo iqbꞌil iteꞌkutaq. Bꞌeꞌxsin aj meltzꞌajtz tja, ex noqx jaw kaꞌylaj tiꞌj tkyaqilj lo. ");
INSERT INTO mamC_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tojxjo qꞌij anetziꞌn, iteꞌtaq kabꞌe nimil tiꞌj Jesús kyjaꞌtaq kyxiꞌ toj jun tnam, Emaús tbꞌi, bꞌalaqa chꞌime oxe ajlabꞌtaq taꞌye tkꞌatz tnam te Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tzuntaq nchi yolin tiꞌj tkyaqiljo otaq bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Toktaq kyyol, ex tzuntaq nchi chꞌotj kyxolx, atzin te Jesús chebꞌe ok laqꞌe teꞌ kykꞌatz, ex xi lipe kytxlaj. ");
INSERT INTO mamC_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Me exla qa iwle Jesús kyuꞌn, me atla jun tiꞌ, a mix taqꞌe tuꞌn tel kynikyꞌ te, alkyetaqjo nbꞌettaq kytxlaj. ");
INSERT INTO mamC_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Xitzin tqanin Jesús kye: ¿Tiꞌtzin kyeꞌ nkubꞌ kyyolin toj bꞌe? ¿Ex tiꞌtzin quꞌnil nchi bꞌisin kyeꞌ? ");
INSERT INTO mamC_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tzajtzin ttzaqꞌwin teꞌ jun, a Cleofas tbꞌi: Bꞌalaqa oꞌkx chꞌin te kyxoljo bꞌetin xjal toj tnam te Jerusalén, a nya bꞌiꞌn tuꞌn tiꞌchaqjo ma bꞌaj tojjo tnam anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Xitzin tqanin Jesús: ¿Tiꞌchaqtzin ma bꞌajtz? Chi chiꞌ kyjaluꞌn: At jun te ma bꞌaj tiꞌj jun aj Nazaret, a Jesús tbꞌi. Nimxtaq tipin tbꞌinchbꞌin exqetziꞌn jniꞌ tyol twutz Dios ex twutz tkyaqil xjal. ");
INSERT INTO mamC_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Me aye kynejil pale exqetziꞌn jniꞌ kawil ẍi qꞌmante tuꞌn tjaw pejkꞌit twutz cruz, exsin tuꞌn tkubꞌ bꞌyettz. ");
INSERT INTO mamC_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Qꞌuqlexixtaq qeꞌ qkꞌuꞌj, qapetzin ataq tetz, tuꞌn tkolin kyiꞌjjo aj Israel. Me ma bꞌant-xi oxe qꞌij teꞌ lo tbꞌajlin, exsin ntiꞌltz ma qliꞌy. ");
INSERT INTO mamC_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ex mape qo jaw xobꞌ qe jaꞌlin kyuꞌn junjun qya, a iteꞌ qukꞌiy. Chi txaꞌj qlixjexix ttzi jul, a jaꞌ okxi muqet. ");
INSERT INTO mamC_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ex bꞌeꞌx ẍi ajtz meltzꞌaj, quꞌn tuꞌn ntiꞌ t-xmilil xknet kyuꞌn. Me atzin jaꞌlin, tzun nchi yolin tiꞌj, qa ma chi iwle kabꞌe t-angel Dios kyuꞌn, ex ma tzaj qꞌmaꞌn kye, qa itzꞌ te Jesús. ");
INSERT INTO mamC_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ex iteꞌ junjuntl qeꞌ qukꞌa, a chi txaꞌj ttzi jul anetziꞌn, ex ikyx s-iwle kyuꞌn, tzeꞌnku otaq bꞌaj qꞌmaꞌn kye kyuꞌn qya. Ex ikyxjo mina s-iwle Jesús kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chitzin Jesús kye kyjaluꞌn: Ntiꞌxla kyeꞌ kynabꞌl, ex yajx nxi kyniminjiꞌy tkyaqiljo, a xbꞌaj kyqꞌmaꞌn yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ma nyatzin iltaq tiꞌj tuꞌn tikyꞌx tuꞌn Kolil, a Crist nej, a naꞌmxtaq tjaw nimsin? ");
INSERT INTO mamC_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tbꞌajlinxiꞌ ikyjo, oktzin ten Jesús chikyꞌbꞌilte kye jotxjo jniꞌ ntqꞌmaꞌn toj Tuꞌjil Tyol Dios, ayeꞌ jniꞌ yol, a nchi yolin tiꞌjjo tchwinqil; tzajx xkye tuꞌn kyojjo tuꞌj Moisés, exsin toj kyuꞌjjo jniꞌ txqantl yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Atzaj teꞌ kykanin tojjo tnam, a jaꞌ tuꞌntaq kyxiꞌye, majx tqanku xiꞌl te Jesús, nyakutzintlaj najchaq chꞌintl tuꞌn tpone. ");
INSERT INTO mamC_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Me ayetzin kyej xjal, ox chi labꞌtex tuꞌn tkyij Jesús kyukꞌa. Chi chiꞌ kyjaluꞌn: Ku tkyija qukꞌiy, quꞌn tuꞌn ma qoqix jaꞌlin; noq kyja qok yupjte. Bꞌeꞌxsin okx Jesús tuja, tuꞌn tkyij kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tetziꞌn kyok qetz tiꞌj meẍ, jawtzin ttzyuꞌn Jesús jun wabꞌj, exsin xi tqꞌoꞌn chjonte te Dios tiꞌj. Bꞌeꞌx kubꞌ tpiẍin, exsin xi tqꞌoꞌntz kye. ");
INSERT INTO mamC_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tzmaxipetzin jqet kywutzjo tuꞌn tel kynikyꞌ tiꞌj Jesús, me texjo paq anetziꞌn, bꞌeꞌx kubꞌ naj te Jesús kywutz. ");
INSERT INTO mamC_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ex i jaw yolin kyxolx: ¿Ma nyatzin twutzx, qa ma qnaꞌ jun nim tzaljbꞌil toj bꞌe, tej s-ok ten chikyꞌbꞌil teꞌ t-xilin yol, a nyolajtz tiꞌj toj Tuꞌjil Tyol Dios? ");
INSERT INTO mamC_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ntiꞌ chꞌin kubꞌ kyayoꞌn. Bꞌeꞌxkux kubꞌ bꞌe kyuꞌn, tuꞌn kymeltzꞌajl toj Jerusalén. Ex antza chꞌuqleqetaqjo junlajaj t-xnaqꞌtzbꞌin Jesús, junx kyukꞌa txqantl kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Xi kyqꞌmaꞌn kye kyjaluꞌn: Twutzxix tetz qa ma jatz anqꞌin juntl majl te qAjaw, ex qa ma tzꞌok tyekꞌin tibꞌ te Simun. ");
INSERT INTO mamC_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kykaꞌbꞌiltzintz i ok ten txolbꞌilte tiꞌjtaqjo otaq tzikyꞌ kyiꞌj toj bꞌe, ex kyqꞌma tzeꞌn tten el kynikyꞌ te Jesús, tzmaxiꞌ teꞌ tkubꞌ tpiẍinj wabꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tzunxtaq nchi yolin tiꞌjjo otaq tzikyꞌ kyiꞌj, tej tkubꞌ weꞌ Jesús kyxol, exsin qꞌolbꞌin kye. Chiꞌ kyjaluꞌn: Qexit kykꞌuꞌja, ex tzalajxit kyanmiꞌn, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Me ayetzin kyetz nimx kyxobꞌil tzaj, quꞌn kubꞌ kybꞌisin qa noq jun klelin otaq kyli. ");
INSERT INTO mamC_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Me atzin te Jesús iky xi tqꞌmaꞌn kye kyjaluꞌn: ¿Titzin quꞌn ma chi jaw xobꞌa? ¿Ex tiꞌtzin quꞌn ma jaw kaꞌmin kyanmiꞌn? ");
INSERT INTO mamC_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kykaꞌyintziꞌn nqꞌobꞌa ex kykaꞌyinkuy nqaꞌn. Ayinqinx wejiꞌy. Chin kytzyuꞌnka ex chin kykaꞌyinka, quꞌn jun klelin ntiꞌ teꞌ tchibꞌjil ex tbꞌaqil, tzeꞌnku ma kyliꞌy wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tej tbꞌaj tqꞌmaꞌn ikyjo, bꞌeꞌxsin i xi tyekꞌintzjo tqꞌobꞌ exqetziꞌn tqan. ");
INSERT INTO mamC_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nimx i jaw kaꞌylaj, ex nimx tzeꞌjbꞌil kynaꞌ. Tuꞌn ikyjo, mix jaꞌ nxi kynimine tkyaqil, qa ataq Jesúsjo. Tuꞌnpetziꞌn, chi Jesúsjo kye kyjaluꞌn: ¿Ntiꞌtzin chꞌin wabꞌj kyukꞌiy tzaluꞌn te nwaꞌy? ");
INSERT INTO mamC_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Xitzin qꞌoꞌn chꞌin kyiẍ te, a tzqꞌajsin toj qꞌaqꞌ, ");
INSERT INTO mamC_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ex xi ttzyuꞌn, exsin xi tchyoꞌntz kywutz. ");
INSERT INTO mamC_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Xitzin tqꞌmaꞌnl kyjaluꞌn: Atziꞌn ma tzikyꞌ toj nchwinqila jaꞌlin, atzaj bꞌaj nqꞌmaꞌn kyeꞌy tej intintaqxa kyukꞌiy: Qa iltaq tiꞌj tuꞌn tbꞌajjo jniꞌ tzꞌibꞌin wiꞌja toj tkawbꞌil Moisés, kyoj kyuꞌj yolil Tyol Dios, ex kyojjo jniꞌ Uꞌj te Bꞌitz. ");
INSERT INTO mamC_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kubꞌsin tyolin Jesúsjo lo, tuꞌntzintla tel kynikyꞌjo t-xnaqꞌtzbꞌin tiꞌjjo jniꞌ tzꞌibꞌin toj Tuꞌjil Tyol Dios ");
INSERT INTO mamC_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Chiꞌ kyjaluꞌn: Tzꞌibꞌin taꞌ teꞌ, qa iltaq tiꞌj tuꞌn nkyima, ayiꞌn Crist, me toj toxin qꞌij, iltaq tiꞌj tuꞌn njatz anqꞌiꞌn juntl majl kyxol kyimnin. ");
INSERT INTO mamC_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ex qa toj tumil nbꞌiꞌy, il tiꞌj tuꞌn t-xi yolit kyeꞌ jniꞌ xjal, a iteꞌ toj tkyaqil twutz txꞌotxꞌ, qa il tiꞌj tuꞌn tajtz tiꞌj kyanminxjal tukꞌa Dios, tuꞌntzintla tkubꞌ nnajsiꞌn jniꞌ kyil. Antza tuꞌn ttzaj xkye tqꞌumle yol lo toj txꞌotxꞌ te Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aye kyeꞌ aku chi ok te kujsil teꞌ tkyaqiljo lo. ");
INSERT INTO mamC_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ayinku weꞌ aku chin tzaj smaꞌn teꞌ a saj tziyin kyeꞌy tuꞌn nMaꞌn. Me il tiꞌj, tuꞌn kykyija tzaluꞌn tojjo tnam te Jerusalén, ex tzmaxi aku chi exjiꞌy, aj kykꞌmoꞌntejiꞌy tipin, a ktzajil toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tbꞌajlinxitziꞌn lo, i tzaj tkleꞌn Jesús najchaq chꞌintl tkꞌatz tnam, tzmax toj Betania. I jawtzin tiꞌn Jesús tqꞌobꞌ twutz kyaꞌj, exsin i kubꞌ tkyꞌiwliꞌntz. ");
INSERT INTO mamC_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ex tzmataq nkyꞌiwlin, bꞌeꞌxsin el tpaꞌn tibꞌtz kyiꞌj, ex texjo paq anetziꞌn, bꞌeꞌx xi qꞌiꞌn toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tej kybꞌaj kꞌulin twutz, bꞌeꞌxsin i meltzꞌajtz toj tnam te Jerusalén, me ox chi tzalajx wen. ");
INSERT INTO mamC_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Axsintza, i kubꞌe tene tkyaqil qꞌij toj tnejil ja te naꞌbꞌl Dios, ex nimx i qꞌoꞌn chjonte te.");
INSERT INTO mamC_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Te tnejil, teꞌ naꞌmxtaq tkubꞌ bꞌinchit tkyaqil, noql attaqjo Tkꞌwal Dios, ax tbꞌi, a Yol. Atziꞌn Yol lo junx ate tukꞌa Dios, ex ax Diosjo. ");
INSERT INTO mamC_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Atzin Yol lo at junx tukꞌa Dios te tnejil. ");
INSERT INTO mamC_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Noq tuꞌn teꞌ Yol bꞌante tuꞌn Dios tkyaqil. Noqit nya Yol bꞌinchin teꞌ tkyaqil, ntiꞌtla te at. ");
INSERT INTO mamC_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tuꞌn teꞌ Yol at tkyaqil chwinqil, ex atziꞌn chwinqil n-el spikyꞌe te jun yekꞌbꞌil tiꞌj Dios toj kynabꞌlxjal. ");
INSERT INTO mamC_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ex tzunx nqoptzꞌajxjo spikyꞌin toj kyanminxjal, a o noj tuꞌn qxopin tuꞌn il, me atzin qxopin nlay yupjxjo spikyꞌin tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","At jun ichin tzaj chqꞌoꞌn tuꞌn Dios, atzin tbꞌi Juan. ");
INSERT INTO mamC_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Atziꞌn ichin ul qꞌmal tqanil Jesús, ex nkubꞌ tyolin kywutzxjal qa ax Jesúsjo a spikyꞌin, ex qa il tiꞌj tuꞌn kyxi lipe tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nya ate Juan spikyꞌin, noq ul chikyꞌbꞌil teꞌ tqanil. ");
INSERT INTO mamC_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ataqtziꞌn spikyꞌin lo a twutzxix, a chꞌix tkubꞌ tyekꞌin tibꞌ tzaluꞌn twutz txꞌotxꞌ, qꞌol teꞌ tspikyꞌimil Dios kye kykyaqil xjal. ");
INSERT INTO mamC_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ataqtziꞌn Yol atx teꞌ ojtxe, quꞌn a kubꞌ bꞌinchin teꞌ tkyaqil twutz txꞌotxꞌ. Me mix ele kynikyꞌxjal te. ");
INSERT INTO mamC_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Atzin tAjaw tkyaqiljo twutz txꞌotxꞌ, quꞌn a Bꞌinchilte. Me atzaj teꞌ tul, mix kubꞌe nimin kyuꞌn t-xjalil, aye aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Me ayetzinl kyeꞌ, a i xi niminte, bꞌeꞌx ok tqꞌoꞌnku kyoklin te tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Quꞌn bꞌeꞌx i itzꞌje juntl majl tuꞌn Dios, ex nya kyuꞌn xjal mo noq tuꞌn t-xim jun ichin. ");
INSERT INTO mamC_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Atziꞌn Yol ok te xjal, najan qxol, ex awoqoxixa o lonte nim t-xilin toklin; a toklin akuxixjo Tkꞌwal qMan Dios, nimxix t-xtalbꞌil ex twutzxtaqjo Tyol. ");
INSERT INTO mamC_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Kubꞌ tyolin Juan, a Jawsil Aꞌ, tiꞌj Jesús kywutz xjal, ex iky tqꞌmaꞌ kyjaluꞌn: Ayetziꞌn, a tzuntaq chi bꞌiꞌn wiꞌja, tej tbꞌaj nqꞌmaꞌn kyeꞌy: Aj lipchetz wiꞌja, nimx teꞌ toklin nwutza, quꞌn noql at teꞌ, tej naꞌmtaq wul itzꞌjiꞌy, nchijiꞌy kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Quꞌn tuꞌn qkyaqilx ma qo kꞌmonte nimx tkyꞌiwbꞌil qAjaw, noq tuꞌn nim t-xtalbꞌil qiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Atziꞌn ojtxe tkawbꞌil Dios, a ul qꞌoꞌn te Moisés, a nlay bꞌant tuꞌn tjapin quꞌn. Me atzin jaꞌlin, ma tzaj tqꞌoꞌn Jesucrist Tqanil twutzxix tiꞌj jun najsbꞌil qil ex tiꞌj jniꞌ t-xtalbꞌil qMan. ");
INSERT INTO mamC_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mix aꞌlx o tli jun maj twutz Dios, me ma tzaj tchqꞌoꞌn Tkꞌwal, tuꞌn tyekꞌin te qe, tzeꞌn t-xilin tten, quꞌn ax Diosjo. ");
INSERT INTO mamC_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ayetaqtziꞌn xjal Judiy iteꞌ toj tnam Jerusalén, i tzaj kychqꞌoꞌn junjun pale ex junjun aj Leví, xjelilte ankyetaqjo Juan. ");
INSERT INTO mamC_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","I xitzin ttzaqꞌwin; ntiꞌx kubꞌ tewin, ex twutzxix xi tqꞌmaꞌn: Nyaqin wejiꞌy a Crist, a at toklin tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nxiku kyqanin juntl majl te: ¿Tzeꞌntzin ttentz? ¿Me qa atejiy Elías? I xi ttzaqꞌwin Juan. Nyaqin wejiꞌy. ¿Me qa atejiy Tsan Dios, a attaq tulil? Ex xi tqꞌmaꞌnl Juan: Mina. ");
INSERT INTO mamC_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Xitzin kyqaniltz te: ¿Me ankye tetza? Qꞌmantza qeꞌy, tuꞌntzin t-xi qiꞌn tqanil kyeꞌ a saj chqꞌoꞌn qeꞌy. ¿Ankye tetza toj twutza? ");
INSERT INTO mamC_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","I xitzin ttzaqꞌwin Juan: Ayin wejiꞌy tqꞌajqꞌojil wibꞌaj, a kyij ttzꞌibꞌin Isaías, a yolil Tyol Dios ojtxe, tej tqꞌma: Ex bꞌijte tqꞌajqꞌojil twiꞌ jun aꞌla kujxix wen tojjo tzqij txꞌotxꞌ, jaꞌ ntiꞌye kynajbꞌilxjal toj, a chiꞌ kyjaluꞌn: Kybꞌinchim kyteꞌn twutz qAjaw, quꞌn chꞌix tul tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ex ayetziꞌn i xi chqꞌoꞌn kyuꞌn Parisey tuꞌn kyyolin tukꞌa Juan xi kyqanin te: ");
INSERT INTO mamC_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Qa nya tejiy Crist mo Elías mo jun yolil Tyol Dios, ¿Ankye saj qꞌonte tokliꞌn tuꞌn kykux tqꞌoꞌnxjal toj aꞌ, te jawsbꞌil aꞌ? ");
INSERT INTO mamC_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","I xi ttzaqꞌwin Juan: Ma chi kuꞌxxjal toj aꞌ wuꞌn, te jawsbꞌil aꞌ, me at juntl kyxola, a mi ojtzqiꞌn kyuꞌn, ");
INSERT INTO mamC_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","a lipchetz wiꞌja, a nimxix toklin. Ntiꞌ wokliꞌn nixpe tuꞌn woka te taqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tkyaqiljo ikyjo; bꞌaj tojjo txꞌotxꞌ Betania, a at tjlajxiꞌ Nim Aꞌ Jordán, jaꞌ nchi kuxe tqꞌoꞌn Juan xjal toj aꞌ te jawsbꞌil aꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Toj junxil qꞌij, xi tkaꞌyin Juan Jesús kyjataq ttzaj laqꞌe tkꞌatz, ex xi tqꞌmaꞌn Juan kyexjal: Kykaꞌyinxa. Kyja tzaj laqꞌeꞌ tal Tal Trit Dios, a k-elil qꞌinte kyilxjal toj tkyaqil twutz txꞌotxꞌ, tzeꞌnqeku tal tal rit, a kubꞌ kybꞌyoꞌnxjal, atxix ojtxe te chojbꞌil kyil. ");
INSERT INTO mamC_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Quꞌn atzin o txi nqꞌmaꞌnjiꞌy kyeꞌy, qa at juntl, a iltaq tiꞌj tuꞌn tul, ex qa attaql teꞌ nim toklin nwutza, quꞌn noql at teꞌ, tej naꞌmtaq wul itzꞌjiꞌy, nchijiꞌy kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ex nya wojtzqiꞌnl weꞌ twutz, me nchi kux nqꞌoꞌn xjal toj aꞌ te jawsbꞌil aꞌ, tuꞌntzin tel kynikyꞌ aj Israel te, tzeꞌnku tzaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Quꞌn nliꞌy Xewbꞌaj Xjan, tej tkuꞌtz toj kyaꞌj tzeꞌnku jun palom, ex kubꞌ weꞌ tibꞌaj Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Naꞌmx tel nnikyꞌa te ankye te Crist, me akux Dios, a tzaj chqꞌoꞌn we, tuꞌn kykuꞌxxjal toj aꞌ, te jawsbꞌil aꞌ, o tzaj tqꞌmaꞌn wey nej: Qa ma tlijiy Xewbꞌaj Xjan tuꞌn tkuꞌtz, ex tuꞌn tkubꞌ ten tibꞌaj jun xjal, axixsinte xjaljo at toklin tuꞌn tkux qꞌoꞌnte Xewbꞌaj Xjan toj kyanminxjal te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma nliꞌy, ex ayinkuxixa ẍin lonte qa a Jesúsjo Tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Toj junxil qꞌij, attaq Juan kyukꞌa kabꞌe t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tej t-xi kykaꞌyin nbꞌet Jesús, xi tqꞌmaꞌn Juan kye: Kykaꞌyinxa atzin ichin chiꞌ, atzin tal Tal Trit Diosjo. ");
INSERT INTO mamC_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tej kybꞌinte t-xnaqꞌtzbꞌin Juan yol ikyjo, bꞌeꞌx i xi lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ajtz meltzꞌaj Jesús kaꞌyil tiꞌjxi, xi tkaꞌyin lipcheqe tiꞌj, ex xi tqanin kye: ¿Tiꞌtzin nkyjyoꞌnch? Jun paqx xi kytzaqꞌwin: Ay Xnaqꞌtzil. ¿Jaꞌtzin taꞌ te tja? ");
INSERT INTO mamC_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Xi tqꞌmaꞌn Jesús kye: Ku kytzaja loltech. Ex bꞌeꞌx i xi lipe kaꞌyilte jaꞌ najle Jesús. Ex tej kykanin, bꞌeꞌx i kyij ten tukꞌa tzmaxi tex qꞌij, quꞌn otaq qoqix kye; quꞌn otaq tzꞌok kyaje or te qale. ");
INSERT INTO mamC_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kyxoljo kabꞌe ichin anetziꞌn, a Andrésjo jun, a titzꞌin Simun. ");
INSERT INTO mamC_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jun paqx, xiꞌ Andrés jyolte Simun. Tetziꞌn tknet tuꞌn, xi tqꞌmaꞌn te: Ma jyet Crist quꞌn, a skꞌoꞌnxix tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bꞌeꞌxsin xi kꞌleꞌn Simun tuꞌn Andrés tkꞌatz Jesús. Tetziꞌn tok kaꞌyin teꞌ tuꞌn Jesús, xi tqꞌmaꞌn te: Simun, ay tkꞌwal Jonás. Me atzin jaꞌlin k-okil nqꞌoꞌn juntl tbꞌiy, a Cefas, a ntqꞌmaꞌ, abꞌj toj qyol, mo Pegr. ");
INSERT INTO mamC_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Toj junxil qꞌij, kubꞌ t-ximin Jesús tuꞌn t-xiꞌ toj txꞌotxꞌ te Galiley. Antza oke tkꞌulbꞌin Lip, ex xi tqꞌmaꞌn te: Lipeka wiꞌjach. ");
INSERT INTO mamC_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Antza najle te Lip toj Betsaida, axjo ttanim Andrés tukꞌa Pegr. ");
INSERT INTO mamC_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ex xiꞌ te Lip jyol Natanael. Tej tel jyet tuꞌn, xi tqꞌmaꞌn te: O jyet qeꞌ Crist quꞌn, aj tzeꞌnku kyij ttzꞌibꞌin Moisés exqetziꞌn jniꞌ yolil Tyol Dios toj Tuꞌjil Tyol: Jesús aj Nazaret tbꞌi, a tkꞌwal Jse. ");
INSERT INTO mamC_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Bꞌeꞌx xi tqꞌmaꞌn Natanael te Lip: ¿Ma akupela tzꞌetz jun nmaq xjal tojjo muchꞌ tnam Nazaret? Ex xi ttzaqꞌwin Lip: Ku tzaja wukꞌiy; k-elil tnikyꞌa te. ");
INSERT INTO mamC_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tej t-xi tkaꞌyin Jesús chꞌixtaq tpon Natanael tkꞌatz, ex ok tqꞌmaꞌn tiꞌj: Lu jun xjal lo, jun aj Israel tukꞌa tkyaqil tanmin, mina njawje tkꞌuꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tej tbꞌinte Natanael ikyjo, xi tqanin te Jesús kyjaluꞌn: ¿Tzeꞌntzin tten el tnikyꞌa wiꞌja? Xi tqꞌmaꞌn Jesús te: Quꞌn ma nliꞌy tokxtaqa t-xe tqan iw, tej naꞌmtaq tok kꞌulbꞌin tuꞌn Lip. ");
INSERT INTO mamC_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Xitzin ttzaqꞌwin Natanael te Jesús: Ay Xnaqꞌtzil, Tkꞌwal Dios te, ex Nmaq Kawil kye aj Israel. ");
INSERT INTO mamC_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Xi ttzaqꞌwin Jesús: ¿Ma man txi tnimiꞌn noq tuꞌn t-xi nqꞌmaꞌn tey, qa o tzꞌiwliy wuꞌn t-xe tqan iw? Me tzaluꞌn ok tlaꞌbꞌila txqantl tiꞌ, a nimixixtl tzeꞌnku lo. ");
INSERT INTO mamC_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Me twutzxix kxel nqꞌmaꞌn tey: Tkyaqil t-xilin kyaꞌj ktzajil nyekꞌin teꞌy, nyakuj aye t-angel Dios nchi jax ex nchi kuꞌtz nkꞌatza, ayiꞌn Tkꞌwal Ichin, noq tuꞌn tkujsit nyola. ");
INSERT INTO mamC_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tbꞌajlinxiꞌ oxe qꞌij, bꞌaj jun mejebꞌlin toj tnam Caná, toj ttxꞌotxꞌ Galiley, ex antza taꞌyetaqjo tnana Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ex ikyx te Jesúsjo kyukꞌa t-xnaqꞌtzbꞌin i tzaj txkoꞌn toj mejebꞌlin. ");
INSERT INTO mamC_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ex tej tel bꞌajjo vin, xitzin tqꞌmaꞌn tnana Jesús te: Ma tzꞌel bꞌaj tej vinch. ");
INSERT INTO mamC_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Me xi ttzaqꞌwin Jesús: Ay qya, ¿Tiꞌ qaj tiꞌjjo lo? Quꞌn naꞌmx tpoꞌn ambꞌil tuꞌn t-xi xkye waqꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Me bꞌeꞌx xi tqꞌmaꞌn tnana kyeꞌ nchi sipintaq: Kybꞌinchinkuy tkyaqil a tzeꞌnkuxjo ktzajil tqꞌmaꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ex attaq qaq ma tij ẍoqꞌ tkubꞌil aꞌ, abꞌj julsinqe, ex nchi ajbꞌin te kytxꞌajbꞌil xjal Judiy, tzeꞌnkuxtaqjo ojtxe tumil kyuꞌn. Teyile junjun nkux bꞌaj junjun winqin ẍoqꞌ aꞌ toj. ");
INSERT INTO mamC_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Bꞌeꞌx xi tqꞌmaꞌn Jesús kyeꞌ nchi sipintaq: Kynojsinqekuxjiꞌy ẍoqꞌ tukꞌa aꞌ. Ex i bꞌaj noj kyuꞌn wen. ");
INSERT INTO mamC_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ex xi tqꞌmaꞌnl kye: Kypluꞌnktz chꞌin, ex kyinxa te tnejil nukꞌil. Ex kubꞌ kybꞌinchin ikyjo. ");
INSERT INTO mamC_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ex atzin teꞌ tnejil nukꞌil kubꞌ nikyꞌbꞌin teꞌ aꞌ, a otaq tzꞌok te vin, ntiꞌ bꞌiꞌn tuꞌn jaꞌ otaq tzaje, me ayetzin kye sipil bꞌintaql kye kyuꞌn, quꞌn o kyli kyeꞌ jaꞌ otaq chi meltzꞌaje kyeꞌ qꞌaꞌyil. Ex atzinj tnejil nukꞌil te mejebꞌlin, tzaj ttxkoꞌn chmilbꞌaj, a tzmataq njaw meje, ");
INSERT INTO mamC_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ex xi tqꞌmaꞌn te: Kykyaqil xjal nxi kysipin nej a tbꞌanilx vin; ex ajtzin kybꞌaj kꞌwaꞌn txokenj toj jun mejebꞌlin, nxi kysipin vin, a nya wiyil, tuꞌntzin mi kynaꞌye ttxutxjil. Me atzin te, ma kubꞌ tkꞌuꞌn tejiy vin tbꞌanilxix, tuꞌn tokin tzmax tzaluꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Atzin lo tnejil techil tipin Jesúsjo bꞌant toj najbꞌil Caná toj ttxꞌotxꞌ Galiley, ex tuꞌnjo lo xi tyekꞌineꞌ nim toklin kyeꞌ t-xnaqꞌtzbꞌin. Ex tuꞌn ikyjo, bꞌeꞌx xi kynimin qa Tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tbꞌajlinxitziꞌn ikyjo, bꞌeꞌx xiꞌ Jesús tojjo tnam Capernaum, tukꞌa tnana, kyukꞌa titzꞌin ex t-xnaqꞌtzbꞌin. Antza i tene jun jteꞌbꞌin qꞌij. ");
INSERT INTO mamC_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tej chꞌixtaq tkꞌul kaniꞌn nintz qꞌij te Waꞌj Pan kye Judiy, jax Jesús tojjo tnam Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ex okx tojjo tnejil ja te naꞌbꞌl Dios, jaꞌ ate junjun sbꞌul nchi bꞌaj kꞌayin aluꞌmj te chojbꞌil kyilxjal, tzeꞌnku wakx, rit ex palom. Ex ikyxjo, ok tkaꞌyin aye xjal nya wen qꞌuqejqe txꞌexbꞌil pwaq. ");
INSERT INTO mamC_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tej tok tkaꞌyiꞌn tkyaqiljo ikyjo; kubꞌ tbꞌinchin jun asyal te poqꞌchbꞌil, ex i bꞌajetz tlajoꞌn xjal iteꞌ toj tja Dios, tukꞌa jniꞌ kykꞌaẍjil, kywakix ex kyrit. Ex ja ttolpin kymeẍjo txꞌexbꞌil pwaq, ex bꞌaj kubꞌ chitjjo pwaq twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ex xi tqꞌmaꞌn kyeꞌ nchi bꞌaj kꞌayin palom: Kyimetza kykyaqiljo lo tzma peꞌn. ¿Ma mitzin nchi txꞌixweꞌy tuꞌn ma tzꞌok kyqꞌoꞌn tja nMaꞌn te jun kꞌaybꞌil? ");
INSERT INTO mamC_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bꞌeꞌxsin tzaj kynaꞌntz t-xnaqꞌtzbꞌin, aj tzꞌibꞌin toj Tuꞌjil Tyol Dios: Ay, Dios, Nimxix nchin xkyꞌaqiꞌn tiꞌj Tjaych. ");
INSERT INTO mamC_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bꞌeꞌxsin xi kyqꞌmaꞌn Judiy te: ¿Tiꞌtzin jun yekꞌbꞌil kꞌwel tqꞌoꞌn qwutza, qa at tokliꞌn tuꞌn tkubꞌ tbꞌinchinjiꞌy lo? ");
INSERT INTO mamC_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","I xi ttzaqꞌwin: Kyyuchꞌinkutzinjiꞌy tnejil ja te naꞌbꞌl Dios lo, ex toj oxe qꞌij otaq japin bꞌantl wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Xi kyqꞌmaꞌn Judiy te: Taj qaq toj ox kꞌal abꞌqꞌe tuꞌn tjapin bꞌajjo ja lo. ¿Ma akutzin japinte tuꞌn, toj oxe qꞌij? ");
INSERT INTO mamC_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mix ele kynikyꞌ tiꞌj t-xilin tyol, quꞌn mi nyolin tiꞌj jun ja twutz txꞌotxꞌ; qalaꞌ tiꞌjjo t-xmilil. ");
INSERT INTO mamC_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Me yajxi, tej tjaw anqꞌin Jesús juntl majl kyxol kyimnin, ul julkꞌaj toj qkꞌuꞌja, a awoꞌy t-xnaqꞌtzbꞌin, tiꞌjjo yol lo, a otaq tzaj tqꞌmaꞌn qeꞌy. Ex tuꞌn ikyjo, xi qnimiꞌn a Tuꞌjil Tyol Dios ex tkyaqil tyol Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kyojjo qꞌij te Waꞌj Pan lo, kubꞌ tbꞌinchin Jesús nim techil tipin, ex nimxjal i nimin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Me mix oke qe tkꞌuꞌj kyiꞌj, quꞌn el tnikyꞌ tiꞌj kynabꞌl kykyaqilx. ");
INSERT INTO mamC_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nya il tiꞌj tuꞌn t-xi tqꞌmaꞌn jun aꞌla te, tzeꞌn tten jun xjal, quꞌn ojtzqiꞌn tuꞌn, tzeꞌn t-xilin kyxim toj kyanmin. ");
INSERT INTO mamC_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","At jun ichin, Nicodem tbꞌi, jun Parisey nejinel kyxol aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kanin Nicodem tkꞌatz Jesús toj qnikyꞌin, ex xi tqꞌmaꞌn te: Xnaqꞌtzil, bꞌinqe quꞌn qa a Dios saj chqꞌoꞌntiꞌy te xnaqꞌtzil qeꞌy; quꞌn mix aꞌl jun xjal aku tzaj yekꞌinte tipin tukꞌa nim techil tzeꞌnku nbꞌant tuꞌn, qa nya qMan tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Xi ttzaqꞌwin Jesús: Twutzxix kxel nqꞌmaꞌn teꞌy: Ankye teꞌ mi tzꞌitzꞌje juntl majl, nlayx tzꞌel tnikyꞌ tiꞌjjo Tkawbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Bꞌeꞌx xi tqaninku Nicodem te: ¿Tzeꞌntzin tten ikyjo; jun xjal ma tijin tuꞌn titzꞌje juntl majl? ¿Ma akutzin tzꞌokx toj tkꞌuꞌj ttxu, tuꞌntzintla titzꞌje tkabꞌ majin? ");
INSERT INTO mamC_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Xi ttzaqꞌwin Jesús te: Twutzxix kxel nqꞌmaꞌn tey, qa nlayx tzꞌokx jun xjal toj Tkawbꞌil Dios, qa mina s-itzꞌje te twutz txꞌotxꞌ ex tuꞌn Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ankye teꞌ ma tzꞌitzꞌje kyuꞌn manbꞌaj, at tchwinqil te twutz txꞌotxꞌ. Ex ankye te ma tzꞌitzꞌje tkabꞌ majin tuꞌn Xewbꞌaj Xjan, at chwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mi jaw kaꞌmin tkꞌuꞌja tiꞌjjo ma txi nqꞌmaꞌn tey: Tkyaqilx tetz il tiꞌj tuꞌn tjaw itzꞌje tkabꞌ majin. ");
INSERT INTO mamC_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Quꞌn ikyxjo tzeꞌnku te kyqꞌiqꞌ njumin wen, me mina nqloꞌn jaꞌ ntzaje ex tzeꞌn txiꞌ, ex ikyqetzin kyeꞌ aye nchi itzꞌje tuꞌn Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Xi tqanin juntl majl te Jesús: ¿Tzeꞌntzin ttxoliljo ikyjo? ");
INSERT INTO mamC_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Xi ttzaqꞌwin Jesús: Ay Nicodem, jun tnejil xnaqꞌtzila kyxol aj Israel, exsin ¿Mi n-el tnikyꞌa tiꞌjjo lo? ");
INSERT INTO mamC_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Twutzxix kxel nqꞌmaꞌn tey, anqejiꞌy nqyolin, a bꞌiꞌn quꞌn. Ex anqejiꞌy nkubꞌ qchikyꞌbꞌin a o qliꞌy. Me ayetzin kye mi nxi kyniminjiꞌy a nxi qqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ex qa mina xi tniminjiy a xbꞌaj nqꞌmaꞌn tey tiꞌjjo kyqꞌiqꞌ te twutz txꞌotxꞌ, ¿Tzeꞌntzin ttentz tuꞌn t-xi tniminjiꞌy, a kxel nqꞌmaꞌn tiꞌjjo te toj kyaꞌj? ");
INSERT INTO mamC_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Quꞌn mix aꞌl jun tetz o jax toj kyaꞌj qꞌil tqanil; qalaꞌ oꞌkqinx we, a ayiꞌn Tkꞌwal Ichin, ẍin kuꞌtz tzaluꞌn twutz txꞌotxꞌ, quꞌn toj kyaꞌj intinetaqa ojtxe. ");
INSERT INTO mamC_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Quꞌn ikytziꞌn tzeꞌnku te Moisés jax tyobꞌin toj tzqij txꞌotxꞌ jun twutzbꞌiyil kan tiꞌj jun tze, te jun qꞌanbꞌil kyexjal; ikytzin wejiꞌy, a ayiꞌn Tkꞌwal Ichin, kchin jawil yobꞌiꞌn twutz jun cruz, ");
INSERT INTO mamC_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tuꞌntzin tkyaqiljo kchi nimil wiꞌja mi chi naj; qalaꞌ ktenbꞌil kychwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Quꞌn nimxix tqꞌaqꞌbꞌil tkꞌuꞌj Dios kyiꞌjxjal tzaluꞌn twutz txꞌotxꞌ, ma chin tzaj tchqꞌoꞌn, a ayiꞌn Tkꞌwal junchꞌin, tuꞌntzin kykyaqiljo a kchi nimil wiꞌja nlay chi naj, qalaꞌ ktenbꞌil kychwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Quꞌn atzin t-xim Diosjo lo, nya tuꞌn nkawiꞌn kujxix wen kyibꞌajxjal; qalaꞌ tuꞌn kyklet tkyaqilxjal wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Quꞌn ankye teꞌ knimil wiꞌja, nlay naj teꞌ. Me ankye teꞌ tkyꞌeꞌ tuꞌn tnimin, at tkawbꞌil Dios tibꞌaj, a kujxix wen, noq tuꞌn ma chin el tiꞌjliꞌn, ex tuꞌn mi xi lipe wiꞌja, a ayiꞌn Tkꞌwal Dios, a oꞌkxjo junchꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Axixsin t-xilin tkyaqiljo lo: Ma chin kanin tzaluꞌn twutz txꞌotxꞌ te jun spikyꞌin kyexjal. Me ayetzin xjal kykyꞌeꞌ tiꞌjjo spikyꞌin; qalaꞌ tok tilil kyuꞌn tuꞌn kykyij toj qxopin, quꞌn nya wenjo kybꞌinchbꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Quꞌn tkyaqilxjo nchi bꞌinchin nya wen, n-el kyiꞌjlin spikyꞌin, ex kykyꞌeꞌ tuꞌn kytzaj laqꞌe tkꞌatz, tuꞌntzin mi tzꞌele tnikyꞌtzajiljo kybꞌinchbꞌin nya wen. ");
INSERT INTO mamC_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Me ayetzin kye nchi bꞌet tojjo Yol twutzxix, nchi tzaj laqꞌe tkꞌatz spikyꞌin, tuꞌntzin tel tnikyꞌtzajil qa a Dios at kyukꞌa toj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tbꞌajlinxitzin yolin ikyjo, bꞌeꞌx xiꞌ Jesús qukꞌiy, a awoꞌy t-xnaqꞌtzbꞌin, toj txꞌotxꞌ Judey. Kubꞌ ten qukꞌiy antza, ex i kuꞌxxjal tuꞌn toj aꞌ te jawsbꞌil aꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ex ikyx te Juan n-aqꞌnin toj junxil txꞌotxꞌ, Enón tbꞌi, nqayin tkꞌatzjo tnam Salim. Nchi kux tqꞌoꞌn teꞌ xjal toj aꞌ te jawsbꞌil aꞌ, quꞌn nim aꞌ attaq antza. ");
INSERT INTO mamC_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","O bꞌajjo ikyjo, a teꞌ naꞌmx tkuꞌx Juan toj tze. ");
INSERT INTO mamC_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jawtzin anqꞌin jun yol kyxol t-xnaqꞌtzbꞌin Juan, a Jawsil Aꞌ, kyukꞌa junjun kyxol aj Judiy, kyiꞌjjo a nbꞌant kyuꞌn ojtxe, tuꞌn kyel wen twutz Dios. ");
INSERT INTO mamC_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","I ul t-xnaqꞌtzbꞌin Juan tukꞌa, ex xi kyqꞌmaꞌn te: ¡Xnaqꞌtzil, kaꞌyinxa! A xjal at tukꞌiy jlajxi Nim Aꞌ Jordán, aj tqꞌmay qeꞌy qa wen; nimxjal nchi kuꞌx tqꞌoꞌn toj aꞌ te jawsbꞌil aꞌ, ex tkyaqilxjal ma cheꞌx lipe tiꞌj. Ajo lo nya wen toj qwutza. ");
INSERT INTO mamC_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Me i tzaj ttzaqꞌwin Juan: Mix aꞌl junte at toklin tuꞌnx tibꞌx; qalaꞌ oꞌkx Dios ntzaj qꞌon teꞌ toklin. ");
INSERT INTO mamC_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Quꞌn ayeku kyeꞌ i bꞌinte, tej t-xi nqꞌmaꞌn kyeꞌy, qa nyaqin wejiꞌy a Crist; qalaꞌ noq jun taqꞌnil ul nej twutz. ");
INSERT INTO mamC_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Te weꞌy, ikyxjo lo tzeꞌnku jun mojil tukꞌa chmilbꞌaj toj jun mejebꞌlin: Tkyaqil xjal ma chi ok tzeꞌnku jun xuꞌjbꞌaj. Nchin tzalaja, aj t-xi lipexjal tiꞌj Jesús, tzeꞌnkujo mojil ntzalaj aj t-xi lipe xuꞌjlbꞌaj tiꞌj tchmil. Tuꞌnpetziꞌn, tzunx nchin tzalaja tuꞌn nxi nbꞌiꞌn tqanil, qa tkyaqilxjal ma txi lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Quꞌn te weꞌy, tbꞌanilx tuꞌn tchꞌiy toklin Jesús, exla qa kyja tkubꞌ bꞌaj we woklin. ");
INSERT INTO mamC_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","A Jesús tzaj toj kyaꞌj, ex at toklin tibꞌaj tkyaqil; ayintzin weꞌ te twutz txꞌotxꞌ, ex oꞌkx nchin yoliꞌn tiꞌjjo te twutz txꞌotxꞌ. Qalaꞌ atzin teꞌ a ntzaj toj kyaꞌj at te toklin tibꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Quꞌn ate Jesús tzaj tiꞌn tqanil tiꞌjjo tkyaqil a o tli ex o tbꞌi toj kyaꞌj, me mix aꞌlx jun nxi niminte. ");
INSERT INTO mamC_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Me qa at jun xi tnimin, a ntkujsin qa twutzxixjo Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Quꞌn atzin a tzaj chqꞌoꞌn tuꞌn Dios oꞌkxtza nyoline Tyol qMan, quꞌn ax Dios saj tqꞌoꞌn T-xew tibꞌaj te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nimxix nqꞌaqꞌin tkꞌuꞌj qMan Dios tiꞌj Tkꞌwal, ex o tzaj tqꞌoꞌn toklin tibꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ankye te kxel nimin teꞌ Tkꞌwal Dios, at jun tchwinqil te jun majx; me atziꞌnl te, a tkyꞌeꞌ txi tnimin, ntiꞌ teꞌ toklin tiꞌjjo chwinqil anetziꞌn, qalaꞌ ktzajil tqꞌoꞌn Dios tkawbꞌil kujxix tibꞌaj, a nlay bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pon tqanil kyukꞌa Parisey, qa nimxtaql te Jesús xjal lipchek tiꞌj, ex nimxtaql xjal nchi kuꞌx toj aꞌ tuꞌn, te jawsbꞌil aꞌ, tzeꞌnku te Juan. ");
INSERT INTO mamC_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Me nya aku te Jesús kuꞌx qꞌoꞌn kyexjal toj aꞌ, qalaꞌ awo keꞌ, a t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tej tbꞌinte Jesús tqanil ikyjo, bꞌeꞌx etz toj ttxꞌotxꞌ Judey, ex bꞌeꞌx xiꞌ majl Galiley. ");
INSERT INTO mamC_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Me ilx tiꞌj nej tuꞌn tikyꞌ toj ttxꞌotxꞌ Samaria. ");
INSERT INTO mamC_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pon kanin Jesús toj tnam Sicar toj ttxꞌotxꞌ Samaria, nqayin tkꞌatzjo txꞌotxꞌ, a o kyij tqꞌoꞌn qtzan Jacob ojtxe te Jse, a tkꞌwal. ");
INSERT INTO mamC_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Antza taꞌyetaq jun xoch, a toktaq tbꞌi: T-xoch Jacob. Ex tzajnin Jesús toj tbꞌe, otaq sikyte. Kubꞌ qe ajlal ttzi xoch; bꞌalaqa otaq tzꞌok kabꞌlaj. ");
INSERT INTO mamC_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ntiꞌqotaqa awoꞌy t-xnaqꞌtzbꞌin antza, quꞌn otaq qoꞌxa toj tnam laqꞌol chꞌin qwaꞌy. Ex ultzin jun qya aj Samaria qꞌaꞌyil toj xoch, ex xi tqꞌmaꞌn Jesús te: Qꞌontza chꞌin nkꞌwaꞌy cheꞌwe. ");
INSERT INTO mamC_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Me atzin teꞌ qya xi tqꞌmaꞌn te: ¿Tiꞌtzin quꞌn ntzaj tqaniꞌn tkꞌwaꞌy cheꞌwe weꞌy? Quꞌn aj Judiy te, ex ayintzin weꞌ jun qya aj Samaria (quꞌn kyojjo qꞌij anetziꞌn nimxtaq qꞌoj at kyxol aj Judiy ex aj Samaria). ");
INSERT INTO mamC_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ex xi ttzaqꞌwin Jesús: Noqit o tzꞌel tnikyꞌa tiꞌjjo a tzaj tqꞌoꞌn Dios, ex noqit aku tzꞌel tnikyꞌa wiꞌja, a nxi nqaniꞌn nkꞌwaꞌy cheꞌwe tey, atla te saj qanin te weꞌy, ex matla txi nqꞌoꞌn weꞌ cheꞌwe itzꞌ tey. ");
INSERT INTO mamC_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Xi ttzaqꞌwin teꞌ qya: Ay Tata, noqittzin at pulbꞌilte tuꞌn, quꞌn ma tij te xoch t-xe. ¿Jaꞌtzin ktzajile cheꞌwe tuꞌn, a itzꞌ, tuꞌn tzaj tqꞌoꞌn weꞌy? ");
INSERT INTO mamC_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ankyenaj te? ¿Ma nimxixnajtzinl te toklin tzeꞌnku qtzan qxjalil Jacob, a xkyij qꞌon teꞌ xoch lo, jaꞌ xkꞌwaꞌne kyukꞌa jniꞌ tkꞌwal majqexjo talin? ");
INSERT INTO mamC_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Xi ttzaqꞌwiꞌn Jesús: Kykyaqiljo nchi bꞌaj kꞌwan tiꞌjjo cheꞌwe lo, ktzajil majl kꞌwaj kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Me ankye teꞌ kxel kꞌwan teꞌ cheꞌwe kxel nqꞌoꞌn, nlaypen tzaj jun majl teꞌ kꞌwaj tiꞌj. Quꞌn atziꞌn cheꞌwe kxel nqꞌoꞌn te, kpuljil toj tanmin, tzeꞌnkuꞌ xlokꞌ aꞌ, tuꞌn tten tchwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tuꞌnpetziꞌn, xi tqꞌmaꞌntljo qya te: Ay Tata, qꞌoꞌntzinjiy cheꞌwe weꞌy, tuꞌntzintla mina tzajitl kꞌwaj wiꞌja, ex tuꞌntzintla mi chin tzajitla qꞌaꞌyil tzmax tzaluꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ex xi ttzaqꞌwin Jesús te: Ku txiꞌy qꞌolbꞌil teꞌ tchmila; ex ku kytzaja tzaluꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tzajtzin ttzaqꞌwin qya: Ntiꞌ weꞌ nchmil. Ex xi tqꞌmaꞌn Jesús te: Twutzx te ma tzaj tqꞌmaꞌn qa ntiꞌ tchmila. ");
INSERT INTO mamC_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Quꞌn jweꞌ tchmila o tzikyꞌ, ex atziꞌn mujle tukꞌiy jaꞌlin nya tchmilkuy. Twutzx te ma tzaj tqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tej tbꞌinte qya ikyjo, xi tqꞌma: Ay Tata, ma tzꞌel we nnikyꞌ te, qa atejiy jun yolil Tyol Dios, tzeꞌnku ojtxe. ");
INSERT INTO mamC_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Qa ikyjo, at jun nxjela teꞌy: Ayetziꞌn qxeꞌchila aj Samaria i kꞌulin te Dios twiꞌ wutz lo; me ayetzin kyeꞌ aj Judiy nkyqꞌmaꞌn qa noq oꞌkx toj Jerusalén aku qo kꞌuline. ");
INSERT INTO mamC_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Xitzin tqꞌmaꞌn Jesús te: Ay qya, noqit aku chinx tnimiꞌn, quꞌn tzul kanin jun qꞌij, jaꞌ tuꞌn kykꞌuliniy twutz qMan Dios, nya noq oꞌkx twiꞌ wutz lo, ex nya noq toj Jerusalén; qalaꞌ toj tkyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ayetzin kyeꞌ aj Samaria, mi n-el kynikyꞌa te alqe nchi kꞌuliniy. Me metzin qeꞌ, a awoꞌy aj Judiy, ma tzꞌel qe qnikyꞌ te alqe nqo kꞌuliniy, quꞌn antza tzajnin teꞌ tkolbꞌil qMan noqx kyuꞌn aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Me ma pon kanin jun qꞌij, ex atzin qꞌijjo jaꞌlin, ex ayetziꞌn a kxel kyqꞌoꞌn kyibꞌ twutz qMan tukꞌa tkyaqil kyanmin, ayexixsin kye kchi kꞌuliljo tukꞌa tumil, exla qa noq jaꞌchaqku iteꞌye, quꞌn ikytzin te Diosjo taj. ");
INSERT INTO mamC_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Quꞌn ate Dios nya qꞌanchaꞌl teꞌ, exla at toj tkyaqil tchꞌiꞌysbꞌin. ¿Ma akutzin qo kꞌulin twutz noq tukꞌa qtzi? Qalaꞌ tukꞌa tkyaqil qanmin, ex tukꞌa jun qnimbꞌil twutzxix. ");
INSERT INTO mamC_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Xitzin tqꞌmaꞌn qya te: Bꞌiꞌn weꞌ wuꞌn qa tzul Kolil, a Crist. Ex aj tul, okla ktzajil tchikyꞌbꞌin tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Xitzin tqꞌmaꞌn Jesús te: Ayin wejiꞌy Crist, a nchin yoliꞌn tukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tzmataq nyolin, tej qmeltzꞌaja. Bꞌeꞌx o jaw kaꞌylaja tuꞌn nyolin Jesús tukꞌa jun qya. Me mix aꞌl jun qeꞌ ten tipin tuꞌn t-xi qaninte te, tiꞌ taj, mo tiquꞌn nyolin tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ex jun paqx kyij ttzaqpiꞌn tej qya tẍoqꞌ, ex bꞌeꞌx xi rinin tzmax toj tnam qꞌmalte kyexjal. ");
INSERT INTO mamC_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Tej tkanin, xi tqꞌmaꞌn kye: Ku kytzaja lolte jun xjal, a ma bꞌaj tqꞌmaꞌn tkyaqiljo nya wen o bꞌant wuꞌn ojtxe. ¿Nyapela Cristjo, a at tulil? ");
INSERT INTO mamC_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ex jun paqx i bꞌajetzxjal toj tnam, ex i xiꞌ jaꞌ taꞌye Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tzmataq nchi bꞌaj ulxjal, awotzin qeꞌ t-xnaqꞌtzbꞌin, o kubꞌsin qwutza te: Xnaqꞌtzil, ku tzaja waꞌl jun twaꞌy nej, qo chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Me ante Jesús tzaj tqꞌmaꞌn qeꞌy: At jun weꞌ nwa, a mi ojtzqiꞌn kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Awotzin qeꞌ o ok teꞌn qanilte qxolilixa: ¿Ma atpela jun aꞌla ma tzaj qꞌinte twa? ");
INSERT INTO mamC_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Atzin te Jesús tzaj tqꞌmaꞌn qeꞌy: Axixsin wejiꞌy nwa, noq tuꞌn tkubꞌ nbꞌinchiꞌn tajbꞌiljo a saj chqꞌoꞌn weꞌy, ex tuꞌn tjapin bꞌajjo taqꞌin wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Xi qkaꞌyiꞌn kumnix kyjaꞌ tzaje laqꞌe txqan xjal tokx kyxbꞌalin sjanin wen, ex tzaj tqꞌmaꞌn Jesús qeꞌy: ¿Ma nyapela kyaje xjaw tuꞌn tjaw awal? Me kxel nqꞌmaꞌn kyeꞌy: Kykaꞌyinxa kumnix, quꞌn ma kubꞌ sjaneꞌ awal jaꞌlin tuꞌn tjaw chmet. ");
INSERT INTO mamC_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mi nchin yolin weꞌ tiꞌjjo awal te twutz txꞌotxꞌ, qalaꞌ kyiꞌjjo xjal tuꞌn kynimin, ex tuꞌn tten kychwinqil te jun majx. Ayetzin kye, a nchi aqꞌniꞌn tiꞌjjo aqꞌuntl lo, ktzajil kytzyuꞌn kye twiꞌ kykꞌuꞌj, junx kyukꞌa a ẍi ex xikyꞌbꞌinte aqꞌuntl. ");
INSERT INTO mamC_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Quꞌn twutzxixjo jun yol nkyqꞌmaꞌnxjal kyjaluꞌn: Junxilte nkux awante, ex junxilte njaw chmon teꞌ twutz, me junx twiꞌ kykꞌuꞌj ktzajil kytzyuꞌn tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ma chex nchqꞌoꞌn kye tuꞌn kyxiꞌy chmol twutz awal kyxolxjal, a jaꞌ mi ẍi aqꞌniniꞌy tiꞌj, quꞌn junxilte xkux awante Tyol Dios kye. Me tzunx nchi tzalaj kyeꞌ tiꞌjjo kyaqꞌnbꞌin, quꞌn noqit ntiꞌ kjol ex awal, ntiꞌtla kyeꞌ tuꞌn tja kychmoꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nim aj Samaria i nimin tiꞌj Jesús, noq tuꞌn tyoljo qya, tej t-xi tqꞌmaꞌn kye, qa o bꞌaj tqꞌmaꞌn Jesús tkyaqiljo nya wen o bꞌant tuꞌn ojtxe. ");
INSERT INTO mamC_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Atziꞌn tej kyul aj Samaria tkꞌatz Jesús, i ok ten kubꞌsil kywutz te, tuꞌn tkyij ten kyukꞌa. Ex axsa kyije ten kabꞌe qꞌij kyxol. ");
INSERT INTO mamC_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ex nimxjal i nimin, tej kybꞌin teꞌ Tyol. ");
INSERT INTO mamC_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tuꞌnpetziꞌn, xi kyqꞌmaꞌn te qya: Atzin jaꞌlin mapen txi qniminx qe nya noq tuꞌn saj tqꞌmaꞌn qeꞌy; qalaꞌ awokuxix qe ma qo ok bꞌinte te, ex ma tzꞌel qnikyꞌa te, qa twutzxix ate Cristjo, a Kolil te tkyaqilxjal twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tbꞌajlinxiꞌ kabꞌe qꞌij, etz Jesús toj ttxꞌotxꞌ Samaria, ex xiꞌ toj ttxꞌotxꞌ Galiley. ");
INSERT INTO mamC_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Me aku Jesús tzaj qꞌmaꞌnte qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin, qa jun yolil Tyol Dios nlay tzꞌok kꞌuꞌjlin kyuꞌn t-xjalil. ");
INSERT INTO mamC_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Me tej tponl Jesús toj Galiley, kubꞌ kywutzliꞌn aye najleqe antza, quꞌn otaq kyli tbꞌinchbꞌin tipin tzma Jerusalén toj nintz qꞌij te Waꞌj Pan, quꞌn ajinqetaq iteꞌ antza. ");
INSERT INTO mamC_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ul meltzꞌaj jun majl Jesús toj tnam Caná, toj ttxꞌotxꞌ Galiley, jaꞌ o txꞌixpit aꞌ te vin tuꞌn. Ex tkꞌatz Caná at juntl tnam, Capernaum tbꞌi. Antza taꞌye jun xjal nim toklin, te taqꞌnil nmaq kawil, ex at jun tkꞌwal iltaq taꞌ tuꞌn yabꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Atzin te tok tbꞌiꞌn teꞌ aqꞌnil qa o tzꞌajtz Jesús Judey, tuꞌn tpon kanin toj Galiley, bꞌeꞌx xiꞌ lolte, ex kubꞌsin twutz te, tuꞌn t-xiꞌ qꞌanil teꞌ tkꞌwal tzma tja, quꞌn chꞌixtaq tkyim. ");
INSERT INTO mamC_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Atzin te Jesús xi tqꞌmaꞌn te: Nlayx txi kynimin kye, qa ntiꞌ jun techil wipiꞌn tuꞌn tbꞌant. ");
INSERT INTO mamC_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Me atzin tej aqꞌnil jun paqx xi tqꞌmaꞌn te: Ay Tata, ku tzaja jaꞌlinxix; chꞌix tkyim weꞌ nkꞌwal. ");
INSERT INTO mamC_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Xitzin tqꞌmaꞌn Jesús te: Kux tzꞌaja tjaꞌy. Lu te tkꞌwal itzꞌ. Ma tzul Dios te. Ex bꞌeꞌx xi tnimin tej ichin tyol Jesús, ex bꞌeꞌx aj. ");
INSERT INTO mamC_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ex chꞌixtaq tkanin tja, i etzjo taqꞌnil kꞌlulte, ex xi kyqꞌmaꞌn te: Lu tej tkꞌwala; ma tzul Dios te. ");
INSERT INTO mamC_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Atzin teꞌ ichin xi tqanin kyeꞌ taqꞌnil jniꞌ or tchewx kyaq tiꞌj. Ewe tikyꞌlinxi kabꞌlaj, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bꞌeꞌxsin pon kanin toj tnabꞌljo ttataꞌ kꞌwal, qa ax orjo ttzaj tqꞌmaꞌn Jesús te, qa ma tzul Dios te tkꞌwal. Tuꞌn ikyjo, bꞌeꞌx xi tnimin tej ichin kyukꞌa kykyaqil najleqe toj tja. ");
INSERT INTO mamC_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Atzin lo tkabꞌ techil tipin bꞌant tuꞌn Jesús, tej tajtz Judey, ex pon kaninl Galiley. ");
INSERT INTO mamC_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tbꞌajlinxitziꞌn ikyjo, tzmataq nchi ikyꞌsin aj Judiy jun nintz qꞌij toj Jerusalén, aj meltzꞌaj Jesús antza. ");
INSERT INTO mamC_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Toj Jerusalén, at jun tkubꞌil aꞌ ma tij, tkubꞌ tkꞌatz jun ma tij tjpel ja, Tjpel Tja Rit tbꞌi. Ajo aꞌ tok tbꞌi: Betzata toj kyyol aj Judiy. Attaq jweꞌ tqan ja anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Antza kuẍejqe txqan yabꞌ: Moẍ, kox, ex junjun noq o tzꞌel kyim t-xmilil. Nchi ayoꞌn tiꞌj, tuꞌn tja yekj aꞌ toj tkubꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Quꞌn chitzin qa attaq jun t-angel Dios nkꞌuꞌltaq ttzi tkubꞌil aꞌ junjun maj, te yekilte. Noq aj t-xi yekjjo aꞌ, ankye te nxi t-xoꞌn tibꞌ tnejil, bꞌeꞌx tzul Dios te aꞌlchaqx kye yabꞌiltz tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","At jun ichin ttzi tkubꞌil aꞌ, o bꞌant-xi wajxaqlajaj toj kaꞌwnaq abꞌqꞌe tyabꞌtlin. ");
INSERT INTO mamC_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tej tiwle tuꞌn Jesús kuẍle, ex el tnikyꞌ te qa ojtxe tkubꞌlin yabꞌte, xi tqanin te: ¿Tajtzin tuꞌn tqꞌanita? ");
INSERT INTO mamC_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tzajtzin ttzaqꞌwiꞌn yabꞌ: Ay Tata, mix aꞌl jun mojil weꞌ, tuꞌn nkuꞌxa toj tkubꞌil aꞌ, aj tjaw yekj. Ajtzin tjaw yekjjo aꞌ, waja tuꞌn t-xi nxoꞌn wibꞌa toj, me junxil nxi t-xoꞌn tibꞌ nej. ");
INSERT INTO mamC_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ante Jesús xi tqꞌmaꞌn te: Kux jaw weꞌksa, qꞌinqeksjiy tkuẍila, ex kux bꞌeta. ");
INSERT INTO mamC_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Texjo paq, ex ul Dios te ichin; jaw tiꞌn tkuẍil, ex bꞌeꞌx ok ten bꞌetil. Ataqtziꞌn qꞌij ikyjo, te ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tuꞌnpetziꞌn, xi kyqꞌmaꞌn Judiy te ichin otaq qꞌanit: Qꞌij te ajlabꞌl te jaꞌlin. Nya wen teꞌ toj kawbꞌil, tuꞌn tkubꞌ qbꞌinchin jun tiꞌ, ex tuꞌn tjaw tiqiꞌn tkuẍila. ");
INSERT INTO mamC_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","I xi ttzaqꞌwiꞌn ichin: Ajo xjal, a xkubꞌ qꞌanin weꞌy, saj qꞌmante weꞌy, tuꞌn t-xi wiqiꞌn nkuẍila, ex tuꞌn nbꞌeta. ");
INSERT INTO mamC_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ayetzin kyeꞌ Judiy xi kyqanin te: ¿Ankye xqꞌmante teꞌy, tuꞌn t-xi tiqin tkuẍila, ex tuꞌn tbꞌeta? ");
INSERT INTO mamC_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Me ante ichin mi bꞌiꞌn tuꞌn ankye o kubꞌ qꞌaninte, tuꞌn nimx txqan xjal at, ex otaq tzikyꞌ Jesús antza. ");
INSERT INTO mamC_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yajxi, el jyetjo ichin tuꞌn Jesús tojjo tnejil ja te naꞌbꞌl Dios, ex xi tqꞌmaꞌn te: Kaꞌyinktziꞌn. Ma tzul Dios teꞌy. Mitzin bꞌinchintla il, tuꞌntzin mi tzaje juntl tiꞌ tiꞌja kujxix wen. ");
INSERT INTO mamC_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ex antza ele tnikyꞌ te, qa a Jesús otaq qꞌaninte, ex xi tqꞌmaꞌn tqanil kye aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tuꞌntzin ikyjo, tzaj kyqꞌoj tiꞌj Jesús, ex kyajtaq tuꞌn tkubꞌ kybꞌyoꞌn, quꞌn tuꞌn nchi kubꞌ tqꞌanin xjal toj qꞌij te ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tuꞌntziꞌn ikyjo, xi tqꞌmaꞌn Jesús kye: Te nMaꞌn kukx o tzꞌaqꞌnin teꞌ tzmax tzaluꞌn, ex ikyx wejiꞌy nchin aqꞌniꞌn, exla qa qꞌij te ajlabꞌl mo minaj. ");
INSERT INTO mamC_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tuꞌntzin tpajjo ikyjo, nimx tzaj kyqꞌojxjal tiꞌj, tuꞌn tkubꞌ kybꞌyoꞌn, nya noq tuꞌn tkubꞌ tqꞌanin jun xjal toj qꞌij te ajlabꞌl, qalaꞌ tuꞌn tyol, ok tqꞌon tibꞌ te Dios, teꞌ t-xi tqꞌmaꞌn qa aku Dios te ttata. ");
INSERT INTO mamC_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Jesús kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy, qa ayiꞌn Tkꞌwal Dios, nlay bꞌant tuꞌn nbꞌinchiꞌn jun tiꞌ noq wuꞌnx wibꞌxa; qalaꞌ oꞌkx nkubꞌ nbꞌinchinjiꞌy a n-ok nkaꞌyiꞌn te nMaꞌn. Quꞌn tkyaqilxjo nbꞌant tuꞌn nMaꞌn, ex ikyxjo nbꞌant wuꞌn, ayiꞌn Tkꞌwal. ");
INSERT INTO mamC_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nimxix nchin ok tkꞌuꞌjliꞌn tuꞌn nMan Dios, quꞌn ayin weꞌ Tkꞌwal; ex ntzaj tyekꞌin weꞌy tkyaqiljo nbꞌant tuꞌn. Ex okpe ktzajil tyekꞌin nimxixtl techil wipiꞌn, tzeꞌnku xbꞌant wuꞌn tiꞌjjo kox lo, noqx tuꞌn kyjaw kaꞌylaja tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Quꞌn ikyjo tzeꞌnkuꞌ te Dios, nchi jaw anqꞌin kyimnin tuꞌn, tuꞌn t-xi tqꞌoꞌn kychwinqil, exsin ikyx wejiꞌy, a ayiꞌn Tkꞌwal Dios, aku txi nqꞌoꞌn chwinqil noq alqe wajiꞌy tuꞌn t-xi nqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ex nya te Dios tuꞌn tkawin toj qꞌij te paꞌbꞌin; qalaꞌ tzaj tqꞌoꞌn Dios wokliꞌn tuꞌn nkawiꞌn tibꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kubꞌ tbꞌinchin Dios ikyjo, tuꞌntzintla tjaw nimsiꞌn nbꞌiꞌy kyuꞌnxjal, ikyxjo tzeꞌnkuxjo njaw nimsin tbꞌi qMan kyuꞌn. Quꞌn ankye te mi xjaw nimsin te tbꞌi Kꞌwalbꞌaj, ex mina xja tnimsin tbꞌi qMan, a tzaj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Twutzxix kxel nqꞌmaꞌn kyeꞌy: Ankye teꞌ nkubꞌ tbꞌin nyola tukꞌa tkyaqil tanmin, ex kꞌwel tnimin a saj chqꞌon weꞌy, atpen teꞌ tchwinqil te jun majx. Ex nlay txi qꞌoꞌn toj najin, quꞌn o txꞌixpit tanmin te kyime tuꞌn tok te chwinqil. ");
INSERT INTO mamC_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Twutzxix kxel nqꞌmaꞌn kyeꞌy, ma pon kanin jun qꞌij ex atzin qꞌijjo jaꞌlin, tuꞌn kybꞌinte a kyimninqe toj kyanmin tqꞌajqꞌojil nwiꞌy, ayiꞌn Tkꞌwal Dios. Ex ayetziꞌn kchi kꞌwel niminte nyola, okpin kchi anqꞌil kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Quꞌn atzin qMan Dios, at teꞌ tchwinqil tuꞌnx tibꞌx, ex aku ttxuyil chwinqil. Ex ikyxjo, o tzaj tqꞌoꞌn wokliꞌn, a ayiꞌn Tkꞌwal, tuꞌn tten nchwinqila wuꞌnx wibꞌxa. ");
INSERT INTO mamC_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ex nya noq oꞌkx Tkꞌwal Diosqiꞌn; qalaꞌ Tkꞌwal Ichin. Ex tuꞌn ikyjo, ma tzaj tqꞌoꞌn wokliꞌn tuꞌn nkawiꞌn tibꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mi chi jaw kaꞌylaja tiꞌj tkyaqiljo lo, quꞌn pon kanin jun qꞌij nimxixtl tzeꞌnku lo, aj kybꞌinte tkyaqil kyimnin muquꞌnqekux toj txꞌotxꞌ, tqꞌajqꞌojil nwiꞌy, ");
INSERT INTO mamC_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ex kchi jaw anqꞌintl. Ayeꞌ wen kybꞌinchbꞌin, kchi jawil anqꞌin, tuꞌn tten kychwinqil te jun majx. Ex ayetziꞌn nya wen kybꞌinchbꞌin, ex kchi jawil anqꞌin kye, tuꞌn kyxiꞌ toj najin te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ex nlay bꞌant jun weꞌ tiꞌ wuꞌn wuꞌnx wibꞌxa. Ex aj nkawiꞌn, mi chin kawin weꞌ wuꞌnx wibꞌxa. Quꞌn nkyꞌeꞌy tuꞌn tkubꞌ nbꞌinchiꞌn tzeꞌnkuxjo waja, qalaꞌ tzeꞌnkuxjo taj qMan, a tzaj chqꞌoꞌn weꞌy. Tuꞌnpetziꞌn, aj nkawiꞌn, tzꞌaqlexix weꞌ nkawbꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Quꞌn qa ma chin kujsiꞌn nyola wiꞌjxa, ntiꞌla tajbꞌin nyola tuꞌn tok te kujsil weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Me at juntl nkujsinte tyol wiꞌja, a Juan Jawsil Aꞌ. Ex bꞌiꞌn we wuꞌn a ntqꞌmaꞌn wiꞌja twutzxix, ex at tajbꞌin te kujsil weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ex ayekuy i xtaꞌj qanilte te Juan qa wenqe nyola; ex atziꞌn tzaj ttzaqꞌwin kyeꞌy qa twutzxix teꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","35","O yolin Juan bꞌaꞌn wiꞌja, quꞌn ate Juan tzeꞌnku jun tzaj, a nqoptzꞌaj tukꞌa jun yol twutzxix wiꞌja kywutzxjal. Ex ma chi tzalaja jun jteꞌbꞌin qꞌij tiꞌjjo tyol. Qꞌuqle kykꞌuꞌja tiꞌjjo t-xnaqꞌtzbꞌil Juan, ex ntzaj nnaꞌn kyeꞌy, noq tuꞌn kykleta. Me mi qꞌuqle nkꞌuꞌja tiꞌjjo jun xjal, exla qa Juan, nyakuj qa il tiꞌj tuꞌn tkujsitjo nyola tuꞌn jun xjal. ");
INSERT INTO mamC_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Quꞌn at jun weꞌ kujsilwe nimxixtl toklin tzeꞌnku te Juan, quꞌn tkyaqiljo techil wipiꞌn a nbꞌant wuꞌn, ikyxjo tzeꞌnku tzaj toqxenin qMan weꞌy; atziꞌn nkujsin teꞌ qa a Dios saj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ex ikyx te qMan Diosjo, a tzaj chqꞌon weꞌy, ntzaj tqꞌoꞌn kujsil weꞌy qa twutzxix nyola, me naꞌmx kybꞌintiꞌy nipela jun maj tqꞌajqꞌojil twiꞌ, ex naꞌm kylontiy tzeꞌn iky kaꞌyin. ");
INSERT INTO mamC_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ex naꞌmx tkyijjo Tyol toj kyanmiꞌn, quꞌn naꞌmx kynimiꞌn wiꞌja, a ayinkuy ẍin tzaj tchqꞌoꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Quꞌn chebꞌex nkux kyxpichꞌinjiꞌy Tyol Dios, quꞌn toj kywutza antza kknetila kychwinqila te jun majx, me mi n-el kynikyꞌa te, qa antza nyolineꞌ Tyol Dios wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Quꞌn ayetzin kye kykyꞌeꞌy tuꞌn kyxi lipeꞌy wiꞌja, tuꞌn kyten kychwinqila te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nlay kubꞌ nwutzlinjiꞌy nimsbꞌil weꞌy ntzaj kyuꞌnxjal, ");
INSERT INTO mamC_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","quꞌn ojtzqiꞌnqiꞌy wuꞌn, ex ojtzqiꞌn wuꞌn qa nya kꞌuꞌjlin Dios kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ma chin tzaj chqꞌoꞌn weꞌ tuꞌn nMaꞌn, me mi ẍin kubꞌ kywutzliꞌn; qatzin ma pon kanin juntl kyxola tuꞌnx tibꞌx ex nya chqꞌoꞌn tuꞌn Dios, atzin kyejiꞌy nkubꞌ kywutzlin. ");
INSERT INTO mamC_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ma attzin tumil tuꞌn kykleta, qa noq kyaja tuꞌn kyela wen kywutzxjal, ex nya twutz qMan Dios, a junchꞌin? ");
INSERT INTO mamC_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma qe kykꞌuꞌja tiꞌjjo t-xnaqꞌtzbꞌil Moisés tuꞌn kykleta, quꞌn toj kywutza qa ayiꞌn weꞌ nchinx patin kyeꞌy twutz Dios. Me mina, quꞌn atzin kpatil kyeꞌ toj paꞌbꞌin twutz Dios, aku Moisés, quꞌn mi njapin bꞌajjo t-xilin t-xnaqꞌtzbꞌil kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Quꞌn noqit ma txi kynimin kyeꞌ tkyaqiljo kubꞌ ttzꞌibꞌin Moisés, matla txi kynimin kye nyola, quꞌn wiꞌjxa xyoline Moisés. ");
INSERT INTO mamC_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Me mi nxi kyniminjiꞌy a xkyij ttzꞌibꞌiꞌn Moisés. ¿Tzeꞌntzin ttentz tuꞌn t-xi kynimiꞌn a xi nqꞌmaꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tbꞌajlinxitziꞌn ikyjo; bꞌeꞌx ikyꞌx Jesús tjlajxi Nijabꞌ te Galiley, ex axjo Tiberias tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nimku xjal lipchex tiꞌj, quꞌn o bꞌaj kykaꞌyiꞌn yekꞌbꞌil teꞌ tipin o bꞌant, tej kybꞌaj qꞌanj yabꞌ tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ex bꞌeꞌx jax twiꞌ wutz, ex antza kubꞌe qe qukꞌiy, a awoꞌy t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chꞌixtaq tul kaniꞌn nintz qꞌij te Xjan Qꞌij, a n-ikyꞌ kyuꞌn aj Judiy, te naꞌbꞌlte kyelintz ojtxe toj Egipto. ");
INSERT INTO mamC_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Atzaj teꞌ t-xi tkaꞌyin Jesús, nimxtaqxjal o tzꞌok lipe tiꞌj, xi tqꞌmaꞌn te Lip: ¿Jaꞌtzin ktzajile qlaqꞌon kywa txqan xjal lo? ");
INSERT INTO mamC_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Xi tqꞌmaꞌn Jesús ikyjo, noq tuꞌn tnikyꞌbꞌajtz Lip tiꞌ ktqꞌmaꞌ tiꞌjjo lo, quꞌn bꞌintaql te Jesús tuꞌn, tiꞌ tuꞌn tkubꞌ tbꞌinchin. ");
INSERT INTO mamC_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Xitzin ttzaqꞌwin Lip: ¿Ma attzin qpwaq tuꞌn t-xi loqꞌbꞌaj txqan wabꞌj, tuꞌn txiꞌ tal kyinchaqjo kye? ");
INSERT INTO mamC_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Xitzin tqꞌmaꞌnljo junl t-xnaqꞌtzbꞌin, Andrés tbꞌi, a titzꞌin Simun Pegr: ");
INSERT INTO mamC_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Lu jun qꞌa lo, qꞌin jweꞌ wabꞌj tuꞌn, junxte nmaq triy, ex qꞌiꞌn kabꞌe tal netzꞌ kyiẍ tuꞌn, me ¿Ma akutzin kanin kyxoljo txqan xjal lo? ");
INSERT INTO mamC_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tzaj ttzaqꞌwin Jesús qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin: Kyqꞌmaꞌnxa kyeꞌ, tuꞌn kybꞌaj kubꞌ qe kykyaqil, quꞌn attaq tal kꞌul antza. Bꞌeꞌxsin i kubꞌ qeꞌ xjal, bꞌalaqa jun jweꞌ mil ichin. ");
INSERT INTO mamC_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","I jaw ttzyuꞌn Jesúsjo wabꞌj, ex xi tqꞌoꞌn chjonte te Dios tiꞌj. Tbꞌajlinxi naꞌn Dios, tzaj tqꞌoꞌn qeꞌy, ex xi qsipiꞌn kyxoljo a qꞌuqejqetaq. Ex ikyx kubꞌ tbꞌinchin kyukꞌa tal kyiẍ; ex tzaj tqꞌoꞌn qeꞌy tuꞌn t-xi qsipiꞌn, noq jniꞌ tuꞌn tbꞌaj kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Atzaj teꞌ kybꞌaj noj wen, tzaj tqꞌmaꞌn Jesús qeꞌy: Kychmoꞌnksjiꞌy tbꞌuchil, a ma kyij, tuꞌntzin ntiꞌx chꞌin tuꞌn tkubꞌ naj. ");
INSERT INTO mamC_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Atzaj teꞌ tjaw bꞌaj quꞌn, i noj kabꞌlajaj chiꞌl tiꞌjjo tbꞌuchil jweꞌ wabꞌj kybꞌajlin xi waꞌn kykyaqil xjal. ");
INSERT INTO mamC_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tej tok kykaꞌyin tkyaqil xjal techil tipin Jesús, xi kyqꞌmaꞌn: Twutzxpentetz qa a ichin lo, a yolil Tyol Dios, a iltaq tiꞌj tuꞌn tul klolqe. ");
INSERT INTO mamC_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Me liwey el tnikyꞌ Jesús tiꞌj kyximxjal, qa kyajtaq tuꞌn tok kyqꞌoꞌn te nmaq kawil kyibꞌaj te jun majx. Tuꞌntziꞌn ikyjo, bꞌeꞌx el tpaꞌn tibꞌ Jesús kyiꞌj, ex bꞌeꞌx jax twiꞌ wutz tjunalx. ");
INSERT INTO mamC_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Atzaj teꞌ qok yupj, bꞌeꞌx o kuꞌxa, a awoꞌy t-xnaqꞌtzbꞌin, ttzi nijabꞌ, ");
INSERT INTO mamC_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ex antza o okxa qeꞌy toj jun bark, tuꞌn qpon kaniꞌn jlajxi tzma toj tnam Capernaum. Ex otaq qo ok qxopexix wen, ex naꞌmtaq tmeltzꞌaj Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bꞌeꞌx tzaj jun nim kyqꞌiqꞌ xupil te aꞌ, tuꞌn tja pulj tiꞌj bark. ");
INSERT INTO mamC_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tzmataq jun ajlabꞌ tukꞌa nikyꞌjin qxilin bꞌeta tibꞌaj nijabꞌ, tej t-xi qkaꞌyiꞌn Jesús, nbꞌettaq tibꞌaj aꞌ, tuꞌn tpon kanin tkꞌatz bark; ex bꞌeꞌx o jaw xobꞌa te, quꞌn mix ele qnikyꞌa tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tzaj tqꞌmaꞌn Jesús qeꞌy: Mina chi jaw xobꞌa. Ayin wejiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ex bꞌeꞌx tzaj qkꞌmoꞌn Jesús tukꞌa tzaljbꞌil tuꞌn tokx toj bark, ex jun paqx o poꞌn tjlajxi aꞌ, jaꞌ iltaq tiꞌj tuꞌn qpon kaniꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Toj junxil qꞌij, ayetzin xjal otaq chi kyij tjlajxi nijabꞌ, tzaj kynaꞌnl qa noq junchꞌin bark attaq qnikyꞌin iqil kyexjal, a jaꞌ o xiyiy, ex nyajin Jesús okx qukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ex ax qꞌijjo i kanin junjun bark, a tzajninqe toj tnam Tiberias, nchi pon kanin ttzi txꞌotxꞌ, nqayin jaꞌ o qo bꞌaj waꞌniꞌy, tej t-xi tqꞌoꞌn Jesús chjonte kyiꞌj wabꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tej tbꞌaj kykaꞌyin qa ntiꞌtaq Jesús, ex ntiꞌqotaqla, bꞌeꞌx i okxkux kyoj bark tuꞌn kypon kanin jyolte toj tnam Capernaum. ");
INSERT INTO mamC_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tej kyjlajinxjo xjal, jyet Jesús kyuꞌn, ex xi kyqꞌmaꞌn te: ¿Xnaqꞌtzil, jtojetzin tkanliꞌn tzaluꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","I xi ttzaqꞌwin Jesús: Twutzxix kxel nqꞌmaꞌn kyeꞌy, qa nchi jyoꞌn wiꞌja noq tuꞌn noj kykꞌuꞌja wuꞌn, ex nya tuꞌn ma tzꞌel kynikyꞌa tiꞌjjo t-xilin techil wipiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tuꞌnpetziꞌn, mi tzꞌok tilil kyuꞌn tiꞌjjo wabꞌj te twutz txꞌotxꞌ, a kbꞌajil; qalaꞌ tzꞌokx tilil kyuꞌn tiꞌjjo wabꞌj te kyanmiꞌn, a kolbꞌil te jun majx. Quꞌn a Dios saj smaꞌn weꞌy, a ayiꞌn Tkꞌwal Ichin, tuꞌn nqꞌoꞌn chwinqil kyeꞌy, tzeꞌnku jun oyaj te jun majx. Quꞌn noq tuꞌn techil wipiꞌn, nyekꞌine qa ayiꞌn Tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Xi kyqanin xjal te: ¿Tiꞌtzin tuꞌn tkubꞌ qbꞌinchiꞌn tuꞌn ttzalaj Dios qiꞌja, ex tuꞌn tzaj tqꞌoꞌnjo oyaj anetziꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ex i xi ttzaqꞌwin: Atziꞌn taj Diosjo tuꞌn tkubꞌ kybꞌinchiꞌn, noq tuꞌn kynimiꞌn wiꞌja, a ayiꞌn ẍin tzaj smaꞌn tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Xitzin kyqꞌmaꞌntz te Jesús: Qa twutzxix qa ma tzaj smaꞌn tuꞌn Dios, ¿Tiꞌtzin jun techiltz ktzajil tyekꞌiꞌn qeꞌy, noq tuꞌn qlontiꞌy, ex tuꞌn t-xi qnimintza? ¿Tiꞌtzin chꞌin ma bꞌanttz tuꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Qalatziꞌn kye qtzan qtaꞌẍ ojtxe i waꞌn tiꞌjjo wabꞌj, a maná, a xiꞌ tqꞌoꞌn Moisés tojjo tzqij txꞌotxꞌ, ikyxtaqjo tzeꞌnkuꞌ ntqꞌmaꞌn Tuꞌjil Tyol Dios: Xi tqꞌoꞌn kywa, aj kuꞌtz toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Xi ttzaqꞌwin Jesús kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy, nya te Moisés saj qꞌoꞌnte wabꞌj te toj kyaꞌj, qalaꞌ aku te nMaꞌn. Ikytzin wejiꞌy, ma chin tzaj tchqꞌoꞌn weꞌ te jun wabꞌj, a twutzxix te toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Quꞌn atziꞌn wabꞌj, a maná, xi tqꞌoꞌn chwinqil kye xjal aj Judiy ojtxe, noq te jteꞌbꞌin qꞌij; me anteꞌ saj smaꞌn tuꞌn Dios, apente wabꞌjjo, a ayiꞌn, a ktzajil tqꞌoꞌn chwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Xitzin kyqanintz te Jesús: Ay Tata, qꞌontzjiy wabꞌj qeꞌy junjun qꞌij, a xkuꞌtz toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Bꞌeꞌx xi tqꞌmaꞌn Jesús kye: Ayin wejiꞌy a Wabꞌj, a qꞌolte chwinqil. Ankye teꞌ ma tzaj lipey wiꞌja nlayxpen tzaj te waꞌyaj tiꞌj; ex ankye teꞌ knimil wiꞌja, ex nlayxpen tzaj te kꞌwaj tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Me ma txi nqꞌmaꞌn kyeꞌy, me mi nchinx kynimiꞌn, exla qa ma chin kyliꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Quꞌn tkyaqiljo o tzaj tqꞌoꞌn qMan Dios weꞌy, ktzajil lipe wiꞌja; ex ajo ktzajil lipe wiꞌja, nlayx chi ex nlajoꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Quꞌn nya ma chin tzaj weꞌ toj kyaꞌj, tuꞌn tkubꞌ nbꞌinchiꞌn noqx alkye waja; qalaꞌ oꞌkx tuꞌn tkubꞌ nbꞌinchiꞌn a tajjo Dios, a saj smaꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ex atziꞌn taj nManjiꞌy, a saj smaꞌn weꞌy, tuꞌn mi naje jun xjal, ayeꞌ ma chi tzaj tqꞌoꞌn weꞌy; qalaꞌ tuꞌn kyjaw anqꞌin wuꞌn, aj tjapin bꞌaj tqꞌijil tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Quꞌn atzin taj nManjiꞌy, tuꞌn kykyaqilxjo ma chi tzaj lipe wiꞌja, ayiꞌn Tkꞌwal Dios, ex nqe kykꞌuꞌj wiꞌja toj tkyaqil, atpen kye kychwinqil te jun majx, ex kchi jawil anqꞌin wuꞌn, aj tjapin bꞌaj tqꞌijil tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Junjun aj Judiy i ok ten yolbꞌil tiꞌj Jesús, tuꞌn otaq tqꞌma qa aku wabꞌj ma kuꞌtz toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Exsin i ok tentz yolbꞌilte kyxolile: ¿Nyapela a Jesúsjo lo, aj tkꞌwal Jse? Ex ojtzqiꞌn ttata quꞌn, tukꞌaxjo tnana. ¿Tzeꞌntzin ttentz ntqꞌmaꞌn qa toj kyaꞌj ma kuꞌtze? ");
INSERT INTO mamC_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Bꞌeꞌxsin i xi ttzaqꞌwiꞌn Jesús: Kytzaqpinxa tuꞌn kyyolbꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mix aꞌl jun aku tzaj lipe wiꞌja, qa nya nMaꞌn saj qꞌmante. Ex qa ma qe kykꞌuꞌj wiꞌja, kchi jawil anqꞌin wuꞌn, aj tjapin bꞌaj tqꞌijil tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Quꞌn kyojjo uꞌj kyij kytzꞌibꞌiꞌn yolil Tyol Dios ojtxe, ntqꞌmaꞌn kyjaluꞌn: Chi xel t-xnaqꞌtzin Dios kykyaqilch. Tuꞌnpetziꞌn, kxel nqꞌmaꞌn kyeꞌy qa kykyaqiljo ma tzaj xnaqꞌtzin tuꞌn Dios, ex qa ma kubꞌ kybꞌiꞌn tukꞌa tkyaqil kyanmin, okpin kchi tzajil lipe kyeꞌ wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mix aꞌl jun o tli twutz qMan Dios, qalaꞌ oꞌkqinxa, ayiꞌn, a ẍin tzaj tsmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Twutzxix kxel nqꞌmaꞌn kyeꞌy, ankye kxel nimin weꞌy, atpen te chwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ayin wejiꞌy a wabꞌj, a qꞌol teꞌ chwinqil anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ayetziꞌn qtzan kytaꞌẍa ojtxe, i bꞌaj waꞌn tiꞌjjo wabꞌj, a maná, a tzaj smaꞌn tuꞌn Dios toj tzqij txꞌotxꞌ te qꞌol chwinqil te twutz txꞌotxꞌ; me kykyaqilx bꞌeꞌx i bꞌaj kyim. ");
INSERT INTO mamC_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Me metzin weꞌ, ayin wejiꞌy, a wabꞌj xkuꞌtz toj kyaꞌj. Ankye qe kchi waꞌl tiꞌj, nlayxpin chi kyim kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ayin wejiꞌy wabꞌj itzꞌ, a kuꞌtz toj kyaꞌj te qꞌol te kychwinqilxjal. Ankye teꞌ kxel waꞌnte, k-anqꞌil teꞌ te jun majx. Atzin wabꞌj kxel nqꞌoꞌn, aku nchibꞌjila, a kxel nqꞌoꞌn te qꞌol chwinqil tkyaqilxjal twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Me junjun kyxol aj Judiy i ok ten yolbꞌilte kyxolile: ¿Tzeꞌntzin tten tuꞌn t-xi tqꞌoꞌn xjal lo tchibꞌjil tuꞌn t-xi qwaꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Atzin te Jesús xi tqꞌmaꞌn kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy, qa mi xi kywaꞌnjiꞌy nchibꞌjila, a ayiꞌn Tkꞌwal Ichin, ex qa mi xi kykꞌwaꞌnjiꞌy nchkyꞌela, ntiꞌ t-xilin kychwinqila tzaluꞌn twutz txꞌotxꞌ, ex ntiꞌ kyokliꞌn tiꞌjjo chwinqil te jun majx toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ikytziꞌn, alkye te kxel waꞌn teꞌ nchibꞌjila ex kxel kꞌwan teꞌ nchkyꞌela, at teꞌ tbꞌanil tchwinqil te jun majx; ex kjawil anqꞌintl wuꞌn, aj tjapin bꞌaj tqꞌijil tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Quꞌn ajo nchibꞌjila, ante wabꞌjjo, a twutzxix, ex ajo nchkyꞌela, ex ikyxjo, ante kꞌwabꞌjjo, a twutzxix. ");
INSERT INTO mamC_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ankye te kxel waꞌn teꞌ nchibꞌjila, ex kxel kꞌwaꞌn teꞌ nchkyꞌela, ante ma tzꞌok tmujbꞌin tibꞌjo wukꞌiy, ex ayiꞌn ma tzꞌok nmujbꞌin wibꞌa tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Quꞌn ajo wipiꞌn ex ajo nchwinqila tzajninqe tuꞌn qMan Dios itzꞌ, a saj smaꞌn weꞌy. Ikytzin wejiꞌy, alkye teꞌ kwaꞌl wiꞌja, at chwinqil te jun majx wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ayin wejiꞌy wabꞌj, a twutzxix, a kuꞌtz toj kyaꞌj te qꞌol chwinqil te jun majx. Mikyxiꞌ tzeꞌnku te maná, a qꞌol chwinqil te twutz txꞌotxꞌ, a xi kywaꞌn qtzan qtaꞌẍ. Quꞌn ayetzin qtaꞌẍ, exla qa i waꞌn tiꞌj, me bꞌeꞌx i bꞌaj kyim. Me ankye te kwaꞌl tiꞌjjo wabꞌj lo, atpen teꞌ chwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tkyaqilxjo lo bꞌaj tqꞌmaꞌn Jesús, tej tbꞌaj xnaqꞌtzin tojjo ja te naꞌbꞌl Dios toj tnam Capernaum. ");
INSERT INTO mamC_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Atzin tej qbꞌintejiꞌy xnaqꞌtzbꞌil lo, ilaꞌku lipcheqetaq tiꞌj xi kyqꞌmaꞌn: Kujxix teꞌ yol luꞌn, tuꞌn t-xi qnimin. ¿Ma atpela jun aku txi bꞌinte? ");
INSERT INTO mamC_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ex liwey el tnikyꞌ Jesús, qa ayex o chi ok ten chꞌotjil tiꞌj, ex xi tqanin kye: ¿Nyapela wenjo nxnaqꞌtzbꞌila toj kywutza? ");
INSERT INTO mamC_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bꞌalaqa tuꞌn n-ok kykaꞌyiꞌn nyakuj jun xjalqiꞌn te twutz txꞌotxꞌ. ¿Me tiꞌtzila kyqꞌmaꞌy, aj nxi kykaꞌyiꞌn, aj njaxa toj kyaꞌj, ayiꞌn Tkꞌwal Ichin, qꞌuqleqinkxa toj nqꞌuqbꞌila, a jaꞌ intinetaqa te tnejil? ¿Akupela txi kyqꞌmaꞌn qa nya wenjo nxnaqꞌtzbꞌila? ");
INSERT INTO mamC_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ajo Xewbꞌaj Xjan ntzaj tqꞌon teꞌ chwinqil te jun majx; atzin teꞌ qxmilil te twutz txꞌotxꞌ teꞌ, ex ntiꞌ tajbꞌin tiꞌjjo chwinqil anetziꞌn. Ex ikyxjo, ayejo nxnaqꞌtzbꞌila twutzxix, quꞌn tzajninqe tiꞌjjo Xewbꞌaj Xjan. Qa ma qe kykꞌuꞌja kyiꞌj, at kychwinqila te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Me at junjun kyxola, a mi nxi kynimin. Xi tqꞌmaꞌn ikyjo, quꞌn ojtzqiꞌntaq tuꞌn atxix teꞌ tzaj xkye taqꞌin, alkye mi chex niminte, ex alkye tuꞌn t-xi kꞌayinte toj kyqꞌobꞌ tajqꞌoj. ");
INSERT INTO mamC_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ex xi tqꞌmaꞌnl: Tuꞌnpetziꞌn, o txi nqꞌmaꞌn kyeꞌy, qa mix aꞌl jun aku tzaj lipe wiꞌja, qa nya nMaꞌn saj qꞌmante. ");
INSERT INTO mamC_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ex tej tbꞌaj tqꞌmaꞌn Jesús tkyaqiljo ikyjo, ilaꞌku lipcheqetaq tiꞌj el kypaꞌn kyibꞌ tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tuꞌnpetziꞌn, tzaj tqanin Jesús qeꞌy, a awoꞌy kabꞌlajaj t-xnaqꞌtzbꞌin: ¿Yajtziꞌn kyeꞌ, majqexpela kye kchi xel lipe kyiꞌj? ");
INSERT INTO mamC_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Me ante Pegr xi ttzaqꞌwin: Tata, ¿Altzin qiꞌj qo xela lipeꞌy? Quꞌn noq oꞌkx te at t-xnaqꞌtzbꞌil, a ntzaj tqꞌoꞌn qchwinqila te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ex ma txi qnimiꞌn, ex ma tzꞌel qnikyꞌa te, qa a tejiy Crist, a xjanxix, a Tkꞌwal Dios itzꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tzaj ttzaqꞌwin Jesús: ¿Ma nyatzin ayiꞌn o chin jaw skꞌoꞌnte kabꞌlajaj kybꞌaja? Me atziꞌn jaꞌlin, at jun kyeꞌ ma txi tqꞌoꞌn ambꞌil te tajaw il, tuꞌn tokx toj tanmin tuꞌn tbꞌinchin il wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tqꞌma Jesúsjo ikyjo, quꞌn ataqtza nyoline tiꞌj Judas Iscariot, a tkꞌwal Simun, quꞌn ataq Judas tuꞌn t-xi kꞌayinte Jesús toj kyqꞌobꞌ tajqꞌoj, exla qa attaq toklin qxola, a awoꞌy kabꞌlajaj t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tbꞌajlinxiꞌ tkyaqiljo ikyjo, nbꞌettaq Jesús toj ttxꞌotxꞌ Galiley; quꞌn tkyꞌeꞌtaq tuꞌn tkyij ten toj ttxꞌotxꞌ Judey, quꞌn at junjun kyxol aj Judiy kyajtaq tuꞌn tkubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Chꞌixtaq tul kanin nintz qꞌij kye aj Judiy, a jaꞌ nchi najan toj tal pach toj kꞌul, noq te jun naꞌbꞌl tiꞌjjo tej kyten qtzan qtaꞌẍ toj tzqij txꞌotxꞌ ojtxe. ");
INSERT INTO mamC_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Antza toj Galiley, bꞌeꞌx i jaw xmayin titzꞌin Jesús tiꞌj, ex xi kyqꞌmaꞌn kyjaluꞌn: Mi kyij ten te tzaluꞌn; qalaꞌ ku txiꞌy toj ttxꞌotxꞌ Judey, tuꞌntzin tok kykaꞌyin a lipcheqek tiꞌja tkyaqiljo nbꞌant tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Quꞌn qa taja tuꞌn tok kaꞌyin tuꞌn kykyaqilxjal tiꞌjjo nbꞌant tuꞌn, mi kubꞌ tewin tibꞌa tzaluꞌn toj Galiley; qalaꞌ qꞌimix tibꞌa, ex yekꞌinkuy kywutz kykyaqilxjal. ");
INSERT INTO mamC_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Xitzin kyqꞌmaꞌn titzꞌin te ikyjo, quꞌn naꞌmxtaq txi kynimiꞌn t-xilin t-xnaqꞌtzbꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Atzin te Jesús xi tqꞌmaꞌn kye: Naꞌmx tpon kanin weꞌ ambꞌil we. Me metzin kyeꞌ, tkyaqil qꞌij wen te kyeꞌy tuꞌn kyxiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Quꞌn nlay chi el ikyꞌin kyeꞌ kyuꞌnxjal. Me metzin weꞌ, nchin el ikyꞌin kyuꞌn, quꞌn nxi nqꞌmaꞌnjiꞌy kykyaqil kybꞌinchbꞌin nya wen. ");
INSERT INTO mamC_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tuꞌnpetziꞌn, kux cheꞌx kyeꞌ toj nintz qꞌij. Mina weꞌ, quꞌn naꞌm tjapin bꞌaj tqꞌijil ambꞌil te weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tbꞌajlinxiꞌ tqꞌmaꞌn Jesús ikyjo; axsa kubꞌe tene toj ttxꞌotxꞌ Galiley. ");
INSERT INTO mamC_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kyjawlinxitzin bꞌaj titzꞌin tzma toj nintz qꞌij, ex ikyx te Jesúsjo bꞌeꞌx xiꞌ, me nya kywutzxjal, qalaꞌ toj ewajil. ");
INSERT INTO mamC_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ex i ok ten aj Judiy jyolte Jesús toj nintz qꞌij, ex xi kyqꞌmaꞌn: ¿Jaꞌtzila taꞌ tej ichin? ");
INSERT INTO mamC_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ex kykyaqil xjal antza i ok ten yolil tiꞌj; attaq junjun nqꞌmante: Ajo ichin wen, chi chiꞌ. Ex attaq junjuntl nqꞌmante: ¡Mina! Quꞌn nya wen teꞌ ichin a, quꞌn noq tok sbꞌul kyexjalch. ");
INSERT INTO mamC_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Me mix aꞌl jun xi tkujsin tyol tiꞌj kywutzxjal, noq tuꞌn kyxobꞌil kye kynejil aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tzmataq nikyꞌjin nintz qꞌij, teꞌ tokx Jesús toj tnejil ja te naꞌbꞌl Dios, ex ok ten xnaqꞌtzil. ");
INSERT INTO mamC_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ex nimx aj Judiy jaw kaꞌylaj tiꞌj t-xnaqꞌtzbꞌil, ex kyqꞌma: ¿Tzeꞌntzin tten nimx tumil toj tnabꞌl ichin lo, ex ntiꞌ o tzꞌokx toj xnaqꞌtzbꞌil? ");
INSERT INTO mamC_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","I xi ttzaqꞌwin Jesús: Ajo xnaqꞌtzbꞌil ma txi nqꞌoꞌn, nya wekuy; qalaꞌ te Dios, a tzaj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Alkye te taj tuꞌn tkubꞌ tbꞌinchin a taj Dios, atzin te k-elil tnikyꞌjo tiꞌj, qa te Dios nxnaqꞌtzbꞌila, mo qa ayinxa nchin kubꞌ ximinte. ");
INSERT INTO mamC_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Alkye jun xjal nyolin tuꞌnx tibꞌ, ntjyoꞌn tuꞌn tjaw nimsin kyuꞌnxjal. Me anteꞌ xjal taj tuꞌn tjaw nimsin toklin tuꞌn a saj chqꞌonte, ante twutzxix tyoljo, ex nya sbꞌul. ");
INSERT INTO mamC_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Qalatzin kyeꞌ nchi yolin tiꞌj, tuꞌn tjapin bꞌaj tkawbꞌil Moisés kyuꞌn, me mix aꞌl jun kyeꞌ ma japin tuꞌn. Quꞌn noqit ma japin kyuꞌn, mitla n-ok tilil kyuꞌn tuꞌn nkubꞌ kybꞌyoꞌntza. ");
INSERT INTO mamC_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Xitzin kytzaqꞌwinxjal: ¿Qape yabꞌ te? ¿Ankye taj tuꞌn tkubꞌ bꞌyontiy? ");
INSERT INTO mamC_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ex xi tqꞌmaꞌn Jesús kye: ¿Ma noq tuꞌn tqꞌanit jun xjal wuꞌn toj qꞌij te ajlabꞌl, ma chi jaw labꞌtey tiꞌj? ");
INSERT INTO mamC_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kxel nyekꞌiꞌn jun tiꞌ kyeꞌy: Ate Moisés kyij qꞌmante kyeꞌy tuꞌn tok qitit kyechiljo tal qꞌa toj twajxaqin qꞌij titzꞌjlin. Ex qa toj qꞌij te ajlabꞌl xjapine ikyjo, me nkubꞌ kybꞌinchiꞌn, noq tuꞌn tjapin tkawbꞌil Moisés kyuꞌn (me nya tuꞌn Moisés tzajniꞌn tumil lo, qalaꞌ tuꞌn Abraham exqetziꞌn txqantl qtzan qtaꞌẍ). ");
INSERT INTO mamC_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Me atziꞌn jaꞌlin, qa nchi aqꞌniꞌn toj jun qꞌij te ajlabꞌl noq tuꞌn tjapin bꞌaj tkawbꞌil Moisés tiꞌjjo tuꞌn tqitit tal netzꞌ techil tiꞌjjo t-xmilil jun tal qꞌa, ¿Tiquꞌntzin nchi qꞌojleꞌy wiꞌja, noq tuꞌn xqꞌanit tkyaqil t-xmilil jun xjal wuꞌn toj qꞌij te ajlabꞌl? ");
INSERT INTO mamC_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mi chi kawiꞌn wibꞌaja noq tuꞌn n-ok kykaꞌyiꞌn; qalaꞌ chi kawiꞌn tukꞌa jun tumil tzꞌaqlexix. ");
INSERT INTO mamC_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Attaq junjun xjal najleqe tojx Jerusalén i ok ten qanilte kyxol: ¿Nyapetzilaꞌ ichin lo a nchi jyoꞌnxjal tiꞌj, tuꞌn tkubꞌ kybꞌyoꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Luꞌtzin nyolin kywutzxjal kykyaqil, exsin ntiꞌ chꞌin nxi kyqꞌmaꞌn te. ¿Nyapela ma txi kynimin aj kawil qa axix Cristjo lo, a at toklin tuꞌn Dios? ");
INSERT INTO mamC_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Me metziꞌn qeꞌ bꞌiꞌn quꞌn jaꞌ tzajnin ichin lo; me aj tul teꞌ Crist, chitzin qa mix aꞌl teꞌ bꞌilte jaꞌ tumil ktzajila, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Atzaj teꞌ tbꞌinte Jesús ikyjo tzmataq nxnaqꞌtzin tojjo tnejil ja te naꞌbꞌl Dios, xi tqꞌmaꞌn tukꞌa tqꞌajqꞌojil twiꞌ kujxix wen: Bꞌalaqa ojtzqiꞌnqiꞌn kyuꞌn, ex bꞌiꞌn kyuꞌn jaꞌ ẍin tzajiꞌy. Me nya wuꞌnx wibꞌ weꞌ ẍin saj; qalaꞌ ma chin tzaj chqꞌoꞌn weꞌ tuꞌn jun, a mi ojtzqiꞌn kyuꞌn, a twutzxix Tyol. ");
INSERT INTO mamC_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Noq oꞌkqinx we ojtzqilte, quꞌn atzin intinetaqa tukꞌa toj kyaꞌj, ex atziꞌn jaꞌlin ma chin tzaj chqꞌon tuꞌn, tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tuꞌntziꞌn tyol Jesús ikyjo, kyajtaq tuꞌn tok kytzyuꞌn, ex tuꞌn tkux kyqꞌoꞌn toj tze; me mix aꞌl jun aqꞌpin tqꞌobꞌ tiꞌj, quꞌn naꞌmx tpon kanin tqꞌijil, tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Me nimxxjal i nimin tiꞌj, ex kyqꞌma: Ax twutz ate Cristjo. ¿Ma akupela bꞌant nim techil tipin juntl, tzeꞌnku teꞌ ichin lo? ");
INSERT INTO mamC_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Atzaj teꞌ kybꞌinte Parisey kyyolxjal nkyqꞌmaꞌn tiꞌj Jesús, i jaw labꞌte tiꞌj, ex i kyij toj wen kyukꞌa kynejil pale, tuꞌn tkux kyjpuꞌn toj tze. Bꞌaj xi kychqꞌoꞌn xqꞌuqil teꞌ tnejil ja te naꞌbꞌl Dios, tuꞌn tok kytzyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Me tzunxtaq yolin te Jesús, ex tqꞌma: Noq jun jteꞌbꞌin qꞌij kchin tenbꞌiltla kyxola, quꞌn kchin ajil meltzꞌaja tkꞌatzjo a saj chqꞌon weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ok chi jyola wiꞌja, me nlay chin kneta kyuꞌn, quꞌn nlay cheꞌxa jaꞌ kchin tenbꞌiliy. ");
INSERT INTO mamC_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tuꞌntzin ikyjo, i ok ten Judiy qanilte kyxolx: ¿Jaꞌtzila kxela qa nlay knet quꞌn? ¿Mej qa antza kanin kyxol aj Judiy, noq jaꞌchaqku najleqe kyojile tnam kyxol amaqꞌ xjal, moj qa ma txiꞌ xnaqꞌtzil kye xjal nya Judiy? ");
INSERT INTO mamC_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tzeꞌntzila t-xilin tyol, a saj tqꞌmaꞌn qe, qa kqo jyol tiꞌj, ex nlay knet quꞌn, ex qa nlay qox jaꞌ ktenbꞌile? ");
INSERT INTO mamC_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Toj bꞌajsbꞌil qꞌij, atzin qꞌijjo nimxixtaq toklin toj nintz qꞌij, jaw weꞌ Jesús, ex xi tqꞌmaꞌn tukꞌa tqꞌajqꞌojil twiꞌ kujxix wen: Qa iteꞌ junjun at kꞌwaj kyiꞌj toj kyanmin, ku kytzaja wukꞌiy, ex chi kꞌwaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Alkyejo knimil wiꞌja, k-anqꞌil jun xlokꞌ aꞌ itzꞌ tojxi tanmin, ikyxjo tzeꞌnku nyolin toj Tuꞌjil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Atzin tzꞌelpineꞌ tyol Jesús ikyjo: Ayetziꞌn kchi xel niminte, iltaq tiꞌj tuꞌn t-xi kykꞌmoꞌn Xewbꞌaj Xjan toj kyanmin, tzeꞌnku jun xlokꞌ aꞌ te chewsbꞌilkye. Quꞌn naꞌmtaq tul Xewbꞌaj Xjan, quꞌn naꞌmxtaq taj Jesús toj tqoptzꞌajiyil kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tej tbꞌaj kybꞌiꞌn tyol, attaq junjun kyxol xjal kyqꞌma: Twutzxix qa ajo ichin lo atzin yolil Tyol Dios, a iltaq tiꞌj tuꞌn tul. ");
INSERT INTO mamC_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Me attaq junjuntl nqꞌmante kyjaluꞌn: Mina. Qalaꞌ aku te Cristjo, a skꞌoꞌnxix tuꞌn Dios te Klolqe. Me attaq junjuntl nqꞌmante: ¿Tzeꞌntzin tten ikyjo, quꞌn aj Galiley te xjal lo? ¿Ma tojtzin txꞌotxꞌ Galiley ktzajile te Crist? ");
INSERT INTO mamC_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Quꞌn ntqꞌmaꞌn toj Tuꞌjil Tyol Dios, qa t-xeꞌchil David te Crist, ex qa iltaq tiꞌj tuꞌn titzꞌje tojxjo tnam Belén, a ttanim David. ");
INSERT INTO mamC_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tuꞌntziꞌn ikyjo, bꞌeꞌx bꞌaj kubꞌ kypaꞌnxjal kyibꞌ noq tuꞌn tpaj Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Attaq junjun a kyaj tuꞌn t-xi kyiꞌn toj tze, me mix aꞌl jun ok tzyunte. ");
INSERT INTO mamC_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ayetzin xqꞌuqil te tnejil ja te naꞌbꞌl Dios, i meltzꞌaj jaꞌ iteꞌyetaq Parisey exqetziꞌn kynejil pale, ex xi kyqanin kyeꞌ. ¿Tiquꞌn mi saj kyinjiꞌy ichin, a xi qqꞌmaꞌn kyeꞌy? ");
INSERT INTO mamC_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Xitzin kytzaqꞌwin xqꞌuqil: Quꞌn tuꞌn bꞌajxi qbꞌiꞌy txqan yol tbꞌanilqex tzeꞌnku tyoljo xjal lo. ");
INSERT INTO mamC_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ayetzin kye Parisey xi kytzaqꞌwin: ¿Majqex kye ma txi kyqꞌoꞌn kyibꞌ tuꞌn kykubꞌ sbꞌuꞌn tuꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ma attzin jun qnejil mo jun Parisey o nimin tiꞌj? ");
INSERT INTO mamC_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Me oꞌkqexjo maꞌ xjal, a mi n-el kynikyꞌ te Tuꞌjil Tyol Dios; bꞌaꞌn tuꞌn kyxiꞌ toj najin te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Me attaq jun Parisey, Nicodem tbꞌi, a xtaꞌj yolil tukꞌa Jesús toj qnikyꞌin, ex xi tqꞌmaꞌn: ");
INSERT INTO mamC_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","¿Ma nyatzin ntqꞌmaꞌn toj qkawbꞌil nlay txi qqꞌmaꞌn tiꞌj jun xjal qa nya wen, a naꞌmxtaq qbꞌinte nej tiꞌtzin t-xilin t-xnaqꞌtzbꞌil? ");
INSERT INTO mamC_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","I jaw yasin tiꞌj Nicodem, ex xi kyqꞌmaꞌn: ¿Mej qa aj Galiley teja? Kaꞌyinkuxa toj Tuꞌjil Tyol Dios, ex k-elil tnikyꞌa te qa mix tiꞌx jun yolil Tyol Dios k-elitz antza toj txꞌotxꞌ Galiley. ");
INSERT INTO mamC_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tbꞌajlinxiꞌ ikyjo; bꞌeꞌx i bꞌaj aj junjun kyja. ");
INSERT INTO mamC_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ex ikyxjo te Jesús bꞌeꞌx xiꞌ twiꞌ wutz Olivos. ");
INSERT INTO mamC_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tej qel sqix toj junxil qꞌij, meltzꞌaj jun majl tojjo tnejil ja te naꞌbꞌl Dios. Bꞌaj pon chmetlxjal tkꞌatz, kubꞌ qe kyxol, ex ok ten majl xnaqꞌtzilkye. ");
INSERT INTO mamC_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ayetziꞌn xnaqꞌtzil tiꞌj ojtxe kawbꞌil exqetziꞌn Parisey xi kyiꞌn jun qya, a knet kyuꞌn tzmataq nchi kyꞌaꞌjin. Kubꞌ kywaꞌbꞌin kyxol tkyaqilxjal, ayeꞌ iteꞌtaq antza, ");
INSERT INTO mamC_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","exsin xi kyqꞌmaꞌn te Jesús: Ay Aj xnaqꞌtzil, anteꞌ qya lo tzmataq n-ok tilil kyꞌaꞌjin tuꞌn, tej s-el qkꞌulbꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tojjo tkawbꞌil Moisés ntqꞌmaꞌn qe tuꞌn tok xoyit tuꞌn abꞌj tuꞌn tkyim jun qya tzeꞌnku lo. ¿Yajtzin te? ¿Tiꞌn teꞌ ktqꞌmabꞌil tiꞌj? ");
INSERT INTO mamC_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","O txi kyqꞌmaꞌn ikyjo, noq tuꞌn tkubꞌ tzꞌaq toj jun til kyuꞌn. Me bꞌeꞌx kubꞌ mukꞌe Jesús twutz txꞌotxꞌ, ex ok ten tzꞌibꞌil tukꞌa twiꞌ tqꞌobꞌ toj quq. ");
INSERT INTO mamC_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Me noq tuꞌn tzunx nchi labꞌte tiꞌj Jesús, jaw weꞌks, ex xi tqꞌmaꞌn kye: Ankye jun kyeꞌ a ntiꞌx jun til, bꞌaꞌn tuꞌn tok t-xoꞌn tnejil abꞌj tiꞌjjo qya lo. ");
INSERT INTO mamC_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ex kubꞌ mukꞌe juntl majl, ex ok tenl tzꞌibꞌil toj quq. ");
INSERT INTO mamC_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Atzaj teꞌ tok kybꞌiꞌn ikyjo, bꞌeꞌx kynaꞌn toj kyanmin qa aj ilqe, ex junjunku i bꞌajeꞌtz; nejxix i bꞌajeꞌtzjo xjal o chi tijin, ex bꞌajeꞌtz lipe kykyaqil. Atzaj teꞌ kybꞌajeꞌtz kykyaqil, tjunalx Jesús kyij ten tukꞌa qya. ");
INSERT INTO mamC_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jaw weꞌks Jesús, ex mix aꞌl jun xjal attaq, qalaꞌ oꞌkxtaqjo tal qya otaq kyij weꞌ. Xi tqꞌmaꞌn Jesús te: Qya, ¿Nteꞌtziꞌn a kyajtaq tuꞌn tkubꞌ bꞌyoꞌn kyuꞌn? ¿Ma ntiꞌtzin jun xkubꞌ bꞌyontiy? ");
INSERT INTO mamC_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Xi ttzaqꞌwin tej qya: Mina, Tata; mix aꞌl jun. Tuꞌntziꞌn, xi tqꞌmaꞌn Jesús te: Ex ikyqinx wejiꞌy. Nlay txi nqꞌmaꞌn tuꞌn tkyima. Qalaꞌ, kux txiꞌy. Mi kubꞌ tbꞌinchin jun majljiy il lo. ");
INSERT INTO mamC_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yajxi chꞌintl, yolin Jesús kyxolxjal, ex xi tqꞌmaꞌn: Ayin wejiꞌy Tzaj te tkyaqil xjal twutz txꞌotxꞌ. Ankye teꞌ k-okil lipe wiꞌja, atpen te tzaj toj tchwinqil, ex nlayx bꞌet toj qxopin. ");
INSERT INTO mamC_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Atzaj teꞌ kybꞌinte Parisey tyol ikyjo, xi kyqꞌmaꞌn te: Axa ma kujsinte tyola tiꞌjxa. ¿Nyapela noq nlaꞌjiꞌn? Tuꞌnpetziꞌn, nlayx txi qbꞌiꞌn tyola. ");
INSERT INTO mamC_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","I xi ttzaqꞌwin Jesús: Ax twutz weꞌ nyol, exla qa ayinxa ma chin kujsinte wiꞌjxa. Quꞌn toj kyaꞌj ẍin tzaja weꞌ, ex axsa kchin ajiliꞌy. ¿Ma akutzin chi kubꞌ sbꞌuꞌn tuꞌn jun te toj kyaꞌj? Qalatzin kyeꞌ ¿Ma bꞌinajtzin kye kyuꞌn ikyjo? ");
INSERT INTO mamC_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nchi kawiꞌn wiꞌja tukꞌa jun tumil noq te twutz txꞌotxꞌ. Me metzin weꞌ, mina kubꞌ nbꞌinchiꞌn ikyjo. ");
INSERT INTO mamC_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Qalaꞌ kchin kawila tukꞌa t-xilin tumil tzꞌaqlexix, a tzajnin te nMaꞌn. Quꞌn nya njunalx weꞌ kchin kawil; qalaꞌ ajin nMaꞌn wukꞌiy, a tzaj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Quꞌn tzꞌibꞌin toj kawbꞌil, a nimin kyuꞌn, qa il tiꞌj kabꞌe xjal tuꞌn tmeje kyyol noq tuꞌn tkujsinte jun tiꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ikytziꞌn, kabꞌe qe qbꞌaj: Ayinx wejiꞌy jun kujsilte wiꞌjxa, ex atzin juntl, a nMaꞌn, a tzaj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Xi kyqanin te: ¿Jaꞌtzin taꞌye tMantza? I xi ttzaqꞌwin Jesús: Mipe n-el kyetza kynikyꞌ wiꞌja. ¿Yajtzilaꞌ te nMaꞌn? Noqit aku tzꞌel kynikyꞌa wiꞌja, ex matla tzꞌel kynikyꞌa te nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Xi tqꞌmaꞌn Jesús tkyaqiljo lo, a tzmataq nxnaqꞌtzin tojjo tnejil ja te naꞌbꞌl Dios, nqayin tkꞌatzjo kꞌuꞌbꞌl pwaq te oyaj. Mix aꞌl jun aqꞌpin tqꞌobꞌ tiꞌj, quꞌn naꞌmxtaq tpon kanin tqꞌijil tuꞌn tkyim. ");
INSERT INTO mamC_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yajxi chꞌintl, xi tqꞌmaꞌntl Jesús kye: Kchin ajil weꞌ; ex kchi jyola wiꞌja, me mi chin kneta kyuꞌn, quꞌn jaꞌ ma chinkiy, ntiꞌx tumil tuꞌn kyxiꞌy: Qalaꞌ axsa kchi kyimila kyeꞌ tjaqꞌ tqanbꞌil kyila. ");
INSERT INTO mamC_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayetzin kye Judiy xi kyqꞌmaꞌn kyxolx: ¿Ma okpetzila kꞌwel tbꞌyoꞌn tibꞌ tuꞌnx tibꞌx, tuꞌn tqꞌmaꞌn qa nlay qox, jaꞌ tumil kxele? ");
INSERT INTO mamC_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Xitzin tqꞌmaꞌn Jesús kye: Ayetzin kyeꞌ te kumnixqe kyeꞌ, te twutz txꞌotxꞌ; me metzin weꞌ te jawnixqin weꞌ, a toj kyaꞌj. Ikytzin te twutz txꞌotxꞌ kyokliꞌn; qalatzin weꞌ, nya te twutz txꞌotxꞌqin weꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tuꞌnpetziꞌn, kxel nqꞌmaꞌn, qa mina ẍinx kynimiꞌn qa ayinjiꞌy, a xi nqꞌmaꞌn kyeꞌy, kchi kyimila tjaqꞌ tqanbꞌil kyila. ");
INSERT INTO mamC_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bꞌeꞌxsin xi kyqanin te: ¿Ankyenaj tetza? Xi ttzaqꞌwin Jesús: ¿Ma nyatzin o txi nqꞌmaꞌn kyeꞌy te tnejil? ");
INSERT INTO mamC_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","At nimku tuꞌn nkawiꞌn tiꞌj. Ex twutzxix nyola, quꞌn oꞌkx nyolinjiꞌy tzeꞌnku tzaj tqꞌmaꞌn nMaꞌn, a tzaj chqꞌoꞌn weꞌy, tuꞌn t-xi nqꞌmaꞌn Tyol te tkyaqil xjal twutz txꞌotxꞌ, quꞌn tekuxix s-ok nbꞌiniꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Me mix ele kynikyꞌ te, qa nyolintaq Jesús tiꞌj qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Jesús kye: Ajtzin njaw kyyoꞌbꞌiꞌn a ayiꞌn Tkꞌwal Ichin twutz kyaꞌj, tzmaxitzin k-elil kynikyꞌjiꞌy te, qa ayin wejiꞌy, a tzeꞌnkuxjo xi nqꞌmaꞌn, ex qa oꞌkx nkubꞌ nbꞌinchinjiꞌy tzeꞌnku tzaj t-xnaqꞌtzin nMaꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Quꞌn a tzaj chqꞌon weꞌy, kukx atjo wukꞌiy. Mi ma chin kyij ttzaqpiꞌn njunalxa, quꞌn kukx nkubꞌ nbꞌinchinjiꞌy a ntzalaj tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tej tbꞌaj tqꞌmaꞌn Jesúsjo ikyjo, nimxjal i nimin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Xi tqꞌmaꞌn Jesús kyeꞌ Judiy, aye otaq chi ok lipe tiꞌj: Qa ma chi weꞌxixa toj tkyaqiljo o txi nqꞌmaꞌn kyeꞌy, okpin kchi okil kye twutzxix te nxnaqꞌtzbꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ex k-elilxix kynikyꞌa tiꞌjjo a twutzxix, ex atzin twutzxix ktzaqpil kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Xitzin kytzaqꞌwin kyjaluꞌn: Tyajil Abrahamqo qe. Bꞌajx txaye qkꞌayinqe qibꞌ te taqꞌnil jun aꞌla. ¿Tzeꞌntzin toke tyola ikyjo tuꞌn qtzaqpeta? ");
INSERT INTO mamC_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Xitzin tqꞌmaꞌn Jesús kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy: Kykyaqilxjo nchi bꞌinchin il, ma txi kykꞌayin kye kyibꞌ tuꞌn kyok te taqꞌnil il. ");
INSERT INTO mamC_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jun aqꞌnil ntiꞌ toklin tuꞌn tok tajlal jun chꞌuq xjal toj kyja. Me metzin te kꞌwalbꞌaj at teꞌ toklin toj ja te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tuꞌnpetziꞌn, qa ma chi tzaqpeta tuꞌn kꞌwalbꞌaj, twutzxix ma chi tzaqpeta te jun majx, quꞌn at te kꞌwalbꞌaj toklin tuꞌn kytzaqpet-xjal tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Bꞌiꞌn weꞌ wuꞌn qa tyajil Abrahamqe kyeꞌ, me ¿Tiquꞌniltz n-ok tilil kyuꞌn tuꞌn nkubꞌ kybꞌyoꞌn? ¿Tinquꞌn mi nxi kyniminjiꞌy nyola? ");
INSERT INTO mamC_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ma chin yoliꞌn tiꞌjjo ma tzaj tyekꞌin nMaꞌn weꞌy. Me metzin kye, atzin kubꞌ kybꞌinchinjiꞌy a tzeꞌnku ntzaj tqꞌmaꞌn kymaꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Xitzin kyqꞌmaꞌn Judiy te: A qejiꞌy qman, a Abraham. Xi ttzaqꞌwin Jesús kye: Noqit ax twutz qa tkꞌwal Abrahamqe kyeꞌ, tzuntla nkubꞌ kybꞌinchiꞌn a tzeꞌnkuꞌ xbꞌant tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Qalatzin weꞌ, ma txi nqꞌmaꞌn wejiꞌy a twutzxix kyeꞌy, a tzaj t-xnaqꞌtzin Dios weꞌy. ¿Tiquꞌn kyajtza tuꞌn nkubꞌ kybꞌyoꞌn? Quꞌn te Abraham ntiꞌx chꞌin teꞌ xkubꞌ tbꞌinchin ikyjo. ");
INSERT INTO mamC_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Qalatzin kyeꞌ ayejiꞌy nkubꞌ kybꞌinchin tzeꞌnku nkubꞌ tbꞌinchin kymaꞌn. Tuꞌnpetziꞌn xi kyqꞌmaꞌn te: Nya sikyꞌaj kꞌwalqo qe tzeꞌnku te. Junchꞌin qe qMan at, a aku Dios. ");
INSERT INTO mamC_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Xi tqꞌmaꞌn Jesús kye: Noqit twutzxix kyeꞌy qa tkꞌwal Diosqiꞌy, matla chin ok kykꞌuꞌjlintza, quꞌn tkꞌatz Dios ẍin tzajiꞌy. Quꞌn mi ẍin ula wunx wibꞌa tzaluꞌn, qalaꞌ a Dios saj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tiquꞌn mi npon nyola toj kynabꞌla? Quꞌn mi nxi kybꞌinjiꞌy tkyaqiljo nxi nqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Atzin kyejiꞌy kytata a tajaw il. Tuꞌnpetziꞌn, ma chi oka te te, ex noq oꞌkx kyaja tuꞌn tkubꞌ kybꞌinchiꞌn tzeꞌnkuxjo taj. Quꞌn ate tajaw il o tzꞌok bꞌyol chwinqil atxix te tnejil. Mi n-ok lipe tiꞌjjo twutzxix, quꞌn ntiꞌ jun yol twutzxix tukꞌa. Quꞌn noqx nikyꞌin yol, quꞌn aku tajaw il o tzꞌok te ttxuyiljo jniꞌ sbꞌubꞌl. ");
INSERT INTO mamC_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Me metzin weꞌ nxi nqꞌmanjiꞌy a twutzxix, me mi nxi kynimiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ankye jun kye aku tzaj qꞌmante, qa at jun il o bꞌant wuꞌn? Qatzin twutzxjo nyola, ¿Tiꞌ quꞌntz mi nxi kynimintza? ");
INSERT INTO mamC_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Quꞌn ayetzin kye xjal te Diosqe, nkubꞌ kybꞌiꞌn kyeꞌ Tyol; me ayetzin kyeꞌ nya te Diosqiꞌy. Tuꞌntziꞌn, kykyꞌeꞌy tuꞌn tkubꞌ kybꞌiꞌn Tyol, chi Jesúsjo kye. ");
INSERT INTO mamC_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tuꞌnpetziꞌn, xi kyqꞌmaꞌn Judiy te: Twutzxla qe qyol, a nxi qqꞌmaꞌn tey, qa sikyꞌaja, exsin qa tokx jun taqꞌnil tajaw il toj tanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","I xi ttzaqꞌwin Jesús: Ntiꞌ jun taqꞌnil tajaw il toj wanmiꞌn; qalaꞌ oꞌkx waja tuꞌn tkubꞌ nbꞌinchiꞌn tuꞌn tjaw nimsin tbꞌi nMaꞌn. Me metzin kye, oꞌkx kyajiꞌy tuꞌn wel kyiꞌjliꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Me mi ẍin ula noq tuꞌn njaw kynimsiꞌn; me metzin te Dios, taj teꞌ tuꞌn njaw nimsita. Ex aku kkawil kyibꞌaja, ayiꞌy nchi el iꞌjlin weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Twutzxix kxel nqꞌmaꞌn kyeꞌy, ankye te kꞌwel nimin weꞌy, nlayxpen kyim teꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Xi kytzaqꞌwin Judiy: Tzmaxpin jaꞌlin, kxel qnimiꞌn qa at jun taqꞌnil tajaw il toj tanmiꞌn. Quꞌn ate Abraham exqetziꞌn nimku yolil Tyol Dios, a nimxix kyoklin ojtxe, bꞌeꞌx i kyim. Anajtzin te ntqꞌmaꞌn, ankye teꞌ kꞌwel nimin weꞌy nlayx chi kyim, chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ma nimxixnajtzintl te toklin tzeꞌnku qtzan qtaꞌẍa Abraham junx kyukꞌa jniꞌ yolil Tyol Dios ojtxe, a o chi kyim? ¿Ankyenaj tetza toj twutza? ");
INSERT INTO mamC_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","I xi ttzaqꞌwin Jesús: Qa ma jaw nimsin wibꞌa wuꞌnx wibꞌxa, ntiꞌla tajbꞌin nyola. Me an wejiꞌy ma jaw nimsinwe a nMaꞌn, a axjo nkyqꞌmaꞌn qa kyDiosa. ");
INSERT INTO mamC_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Me nya ojtzqiꞌn kyuꞌn. Me metzin weꞌ wojtzqiꞌn weꞌ. Qa ma txi nqꞌmaꞌn kyeꞌy qa mi wojtzqiꞌn, jun nikyꞌil yolqintlaꞌy tzeꞌnku kyeꞌ. Me twutzxix wojtzqiꞌn weꞌ ex nkubꞌ nbꞌinjiꞌy Tyol. ");
INSERT INTO mamC_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Me ante Abraham, a qtzan kytaꞌẍa, nimx o jaw tzalaj tuꞌn tlontetaq wulila. Ex o tli noq tuꞌnjo tnimbꞌil, ex o noj tukꞌa tzaljbꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Xi kyqꞌmaꞌn Judiy te: Naꞌmx tjapin te lajaj toj ox kꞌal abꞌqꞌe, exsin ¿Tqꞌmaꞌnnaja qa o tliꞌy Abraham? ");
INSERT INTO mamC_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","I xi ttzaqꞌwin Jesús: Twutzxix kxel nqꞌmaꞌn kyeꞌy: Tej naꞌmxtaq tul itzꞌje Abraham, ayin weꞌ intintaq. ");
INSERT INTO mamC_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tuꞌnpetziꞌn, bꞌaj jaw kytzyuꞌn abꞌj, tuꞌn tok kyxoꞌn tiꞌj Jesús, me bꞌeꞌx ewin, ex etz toj tnejil ja te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tej kyjaꞌtaq tikyꞌx Jesús toj jun bꞌe, xi tkaꞌyin jun ichin moẍ toj titzꞌjlin. ");
INSERT INTO mamC_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Xi qqaniꞌn, a awoꞌy t-xnaqꞌtzbꞌin: Ay Aj Xnaqꞌtzil, ¿Tiꞌtzila quꞌnil s-itzꞌje ichin moẍ lo; tuꞌnpela kyiljo ttata, mo qa tuꞌnx til? ");
INSERT INTO mamC_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","O tzaj ttzaqꞌwiꞌn Jesús: Nya tuꞌn kyil ttata, ex nya tuꞌnxjo til; qalaꞌ ma tzꞌitzꞌje moẍ, noq tuꞌn tyekꞌiꞌn tipin qMan Dios tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A naꞌmx tex qꞌij, ilx tiꞌj tuꞌn tkubꞌ qbꞌinchin taqꞌin a tzaj chqꞌon weꞌy, quꞌn tzul kanin qnikyꞌin, aj nkyima, a jaꞌ mix aꞌl jun aku bꞌant taqꞌnin. ");
INSERT INTO mamC_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Loqin intiꞌnx tzaluꞌn, ayin weꞌ tzaj kye kykyaqil xjal twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Atzaj teꞌ tbꞌaj tqꞌmaꞌn ikyjo, kubꞌ ttzubꞌin twutz txꞌotxꞌ, ex kubꞌ tbꞌinchin chꞌin xoqꞌl tuꞌn taꞌl ttzi, ex ok tsuꞌn kyiꞌj twutzjo moẍ, ");
INSERT INTO mamC_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ex xi tqꞌmaꞌn te: Kux txiꞌy txjol kye twutza tojjo tkubꞌil aꞌ, Siloé tbꞌi (atzin tzꞌelpineꞌ: Chqꞌoꞌn). Ex bꞌeꞌxsin xiꞌ moẍ txjol twutz. Atzaj teꞌ tmeltzꞌaj, otaq bꞌant tkaꞌyin. ");
INSERT INTO mamC_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ayetziꞌn t-xjalil najleqetaq nqayin tkꞌatz tja exqetziꞌn jniꞌ ojtzqilte, tej nmoꞌntaq, i jaw yolin kyxolx: ¿Ma nyapetzilaꞌ xjal lo a moẍtaq, a nkubꞌ qe qanil tmobꞌitz? ");
INSERT INTO mamC_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Attaq junjun nkyqꞌmante: Atziꞌn. Ex junjuntl nkyqꞌmaꞌntaq: Nya teꞌ, bꞌaꞌnxi chꞌime ikyx kaꞌyiꞌn. Me axjo ichin nqꞌmante: Ikytziꞌn. Ayin wejiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bꞌeꞌxsin xi kyqanin te: Tzeꞌntzin tten ma bꞌant tkaꞌyiꞌn, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Exsin i xi ttzaqꞌwin kye: Atzin ichin, a Jesús tbꞌi, xkubꞌ tbꞌinchin chꞌin xoqꞌl, exsin s-ok tsuꞌn kyiꞌj nwutza, ex tzaj tqꞌmaꞌn weꞌy: Ku t-xiꞌy ttzi tkubꞌil aꞌ, Siloé tbꞌi, ex txjomil twutzach. Kutzin, nchijiꞌy. Ẍinka. Atzaj teꞌ s-el ntxjon nwutza, bꞌeꞌx bꞌant nkaꞌyiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bꞌeꞌxsin xi kyqanin te: ¿Jaꞌtzin taꞌye ichin anetziꞌn? Ex xi tqꞌmaꞌn kye: Mi bꞌiꞌn wuꞌnch. ");
INSERT INTO mamC_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tuꞌnpetziꞌn, bꞌeꞌx xi kyiꞌn kywutzjo Parisey ajo ichin, a moẍtaq, ");
INSERT INTO mamC_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","quꞌn toj jun qꞌij te ajlabꞌl, kubꞌ tbꞌinchin Jesúsjo xoqꞌl, ex kubꞌ tqꞌaniꞌn moẍ. ");
INSERT INTO mamC_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ayetzin Parisey ok tentl qanilte teꞌ ichin: ¿Tzeꞌn tten otaq chi kaꞌyin twutz? Ante ichin xi tqꞌmaꞌn: Ok tsuꞌn xoqꞌl kyiꞌj nwutza, ex el ntxjoꞌn. Atziꞌn jaꞌlin, ma bꞌant nkaꞌyiꞌnch. ");
INSERT INTO mamC_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","At junjun Parisey xi kyqꞌma: Ajo ichin kubꞌ tbꞌinchin ikyjo, nya te Dios teꞌ, quꞌn mina nkubꞌ tnimin qꞌij te ajlabꞌl. Me attaq junjunltl xi kyqꞌmaꞌn: ¿Tzeꞌntzin tten ikyjo? ¿Akupela bꞌant tbꞌinchin jun yekꞌbꞌil tipin nimx kyoklin, qa aj il? Tuꞌntzin ikyjo, mix mejeye kyyol, ex bꞌeꞌx bꞌaj kubꞌ kypaꞌn kyibꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bꞌeꞌx xi kyqanin majl teꞌ moẍtaq: ¿Yajtzin te? ¿Tiꞌtzin te ntqꞌmaꞌn tiꞌjjo ichin, ax jqonte twutza? I xi ttzaqꞌwin tej ichin: Bꞌa we wuꞌn jun yolil Tyol Dios teꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Me ayetzin kye Judiy kykyꞌeꞌtaq tuꞌn txi kynimiꞌn, qa ataqjo a moẍtaq otaq bꞌant tkaꞌyin, tzmaxix xi kyniminxjo, teꞌ kytzaj kytxkoꞌn ttataꞌ a moẍtaq. ");
INSERT INTO mamC_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Xi kyqanin kye: ¿Atzin kykꞌwaljiꞌy lo, a nkyqꞌmaꞌn qa moẍtaq te titzꞌje? ¿Tzeꞌntzin ttentz ma bꞌant tkaꞌyin? ");
INSERT INTO mamC_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Me atzin kye ttata xi kytzaqꞌwin: Ojtzqiꞌn qe quꞌn, qa a qkꞌwaljiꞌy, a moẍ te titzꞌje. ");
INSERT INTO mamC_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Me mi bꞌiꞌn qe quꞌn tzeꞌn tten ẍi jqet twutz, ex alkye xkubꞌ qꞌaninte. Kyqaninxa te; quꞌn ma bꞌet tabꞌqꞌe, ex ax kqꞌolte tqanil. ");
INSERT INTO mamC_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Xi kyqꞌmaꞌn ttata ikyjo noq tuꞌn kyxobꞌil kye aj Judiy, quꞌn bꞌiꞌntaq kyuꞌn, qa otaq chi kyij aj Judiy toj wen, tuꞌn tex lajet jun aꞌla toj ja te naꞌbꞌl Dios, qa ma txi kyqꞌmaꞌn qa axix Jesúsjo a Crist. ");
INSERT INTO mamC_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tuꞌnpetziꞌn, xi kyqꞌmaꞌn ttata: Kyqaninxa te; quꞌn ma bꞌet tabꞌqꞌe, ex ax kqꞌolte tqanil. ");
INSERT INTO mamC_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ayetziꞌn Judiy tzaj kytxkoꞌn juntl majljo ichin moẍtaq, ex xi kyqꞌmaꞌn te: Qꞌmantza qeꞌy twutz Dios. ¿Tiꞌn bꞌaj tiꞌja? Quꞌn bꞌiꞌn qe quꞌn qa ajo ichin anetziꞌn aj il teꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ante ichin xi ttzaqꞌwin: Qa aj il mo qa minaj; oꞌkx wejiꞌy bꞌiꞌn wuꞌn qa moẍqintaqa. Atziꞌn jaꞌlin ma bꞌant nkaꞌyiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Xi kyqanin majljo Parisey te: ¿Tzeꞌntzin s-okiy tuꞌn? ¿Tiꞌtzin xbꞌant tuꞌn, tuꞌn tjqet twutza? ");
INSERT INTO mamC_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","I xi ttzaqꞌwin: Ma txi nqꞌmaꞌn kyeꞌy ilaꞌ maj, me mi n-okx toj kywiꞌy. ¿Tiquꞌn kyaja tuꞌn t-xi nqꞌmaꞌntla juntl majl? ¿Bꞌalaqa kyaja tuꞌn kyok lipey tiꞌj? ");
INSERT INTO mamC_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bꞌeꞌxsin i bꞌaj ok tentz yisolte, ex xi kyqꞌmaꞌn te: Ma txi lipey tiꞌjjo maꞌ ichin anetziꞌn; me metzin qe, axsa qo xela lipe qe tiꞌjjo t-xnaqꞌtzbꞌil Moisés. ");
INSERT INTO mamC_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Quꞌn bꞌiꞌn qe quꞌn, aku te Dios o yolin tukꞌa Moisés; me ante ichin anetziꞌn, ntiꞌx chꞌin bꞌiꞌn quꞌn jaꞌ tzajnin. ");
INSERT INTO mamC_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Me atzin teꞌ ichin xi ttzaqꞌwin kye: ¿Tzeꞌnxsin tteꞌn ikyjo? Mi bꞌin kyuꞌn jaꞌ tzajnin ichin, ex ma jqet nwutza tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","¿Nyapela bꞌin kyuꞌn, qa mi nchi tzaj tbꞌin Diosjo aj il? Qalaꞌ nchi tzaj tbꞌiꞌn aye nchi kꞌulin te, exqetziꞌn nkubꞌ kybꞌinchin a taj. ");
INSERT INTO mamC_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Quꞌn bꞌajx qbꞌiye tqanil tzmax tzaluꞌn tiꞌj jun xjal, tuꞌn tjqet twutz jun xjal tuꞌn, a moẍ teꞌ titzꞌje. ");
INSERT INTO mamC_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Qa nya te Diosjo ichin lo, ¿Ma akupetla tzul Dios weꞌy tuꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tuꞌnpetziꞌn xi kytzaqꞌwin te: Ntiꞌ te tajbꞌiꞌn tuꞌn tyolin qukꞌiy ikyjo, quꞌn manyor aj ilx te atxix teꞌ titzꞌjiy. ¿Ex tajnaja tuꞌn qkubꞌ t-xnaqꞌtziꞌn? Ex bꞌeꞌx etz kylajoꞌn toj ja te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Atzaj teꞌ tbꞌinte Jesús, qa otaq tzꞌex lajoꞌn tej ichin toj ja te naꞌbꞌl Dios, el tkꞌulbꞌin tibꞌ tukꞌa, ex xi tqanin te: ¿Niminxsiꞌn Tkꞌwal Ichin tuꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Atzin te ichin xi tqꞌmaꞌn te: Tata, qꞌmaꞌntza weꞌy ankye, tuꞌntzintla nnimiꞌn tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Xi ttzaqꞌwin Jesús te: O tlixiy, ex ayintzinjiꞌy, a nchin yoliꞌn tukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bꞌeꞌxsin kubꞌ meje ichin twutz Jesús, ex xi tqꞌmaꞌn te: Ma txi nnimiꞌn, wAjaw. ");
INSERT INTO mamC_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Bꞌeꞌx xi tqꞌmaꞌn Jesús: Ma chin ula tzaluꞌn twutz txꞌotxꞌ, tuꞌn nkawiꞌn tukꞌa tumil, tuꞌntzintla ayejo moẍqe toj kyanmin, tuꞌn tbꞌant kykaꞌyin; ex ayetziꞌn njaw kynimsin kyibꞌ, tuꞌn kyok moẍ toj kyanmin. ");
INSERT INTO mamC_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ayetziꞌn junjun Parisey iteꞌtaq tukꞌa Jesús. Tej kybꞌinte ikyjo, xi kyqanin te: ¿Mej qa majqox qe moẍqo toj twutza? ");
INSERT INTO mamC_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","I xi ttzaqꞌwin Jesús: Noqpetzin ma tzꞌel kyetz kynikyꞌ tiꞌj qa moẍqiꞌy toj kyanmiꞌn, matla kubꞌ najsit kyetza kyil. Me tuꞌn njaw kynimsin kyibꞌa, ex noq tuꞌn kyqꞌmaꞌn qa n-el kynikyꞌa te tkyaqil, at kye kypaj tuꞌn kyila. ");
INSERT INTO mamC_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Xi tqꞌmaꞌn Jesús kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy, alkye jun mi tzꞌokx toj tjpel chꞌlaj kye rit, ex qa noq s-okx tlimoꞌn tibꞌ toj jun plaj, ileqꞌ teꞌ, mo jun bꞌyol xjal tuꞌn telqꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Me atzin teꞌ n-okx toj tjpel chꞌlaj kye rit, atzin te bꞌaꞌn kyikꞌleljo, ex nchi ok tkaꞌyin trit. ");
INSERT INTO mamC_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Atzin teꞌ xqꞌuqil chꞌlaj n-okx tjqoꞌn tjpel, tuꞌntzin tokxjo kyikꞌlel, tuꞌn kytzaj ttxkoꞌn trit. Kxel kybꞌiꞌn tqꞌajqꞌojil twiꞌ, ex chi tzajil tqꞌolbꞌin tukꞌa kybꞌi, ex kchi elitz tiꞌn toj chꞌlaj. ");
INSERT INTO mamC_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ajtzin kyetz bꞌaj tuꞌn, kꞌwel nej kywutz, exsin kchi okil lipe rit tiꞌj, quꞌn n-el kynikyꞌ te tqꞌajqꞌojil twiꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Me nlayx chi ok lipe tiꞌj juntl, a nya kyikꞌlel; qalaꞌ bꞌeꞌx kchi elil oq, quꞌn nya ojtzqiꞌn tqꞌajqꞌojil twiꞌ juntl, a nya kyikꞌlel. ");
INSERT INTO mamC_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kubꞌ tqꞌoꞌn Jesúsjo techil lo kywutzxjal, me mix ele kynikyꞌ te, tiꞌtaq tzꞌelpineꞌ tyol ikyjo. ");
INSERT INTO mamC_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tuꞌnpetziꞌn, xi tqꞌmaꞌntl Jesús kye: Twutzxix kxel nqꞌmaꞌn kyeꞌy, ayin wejiꞌy Tjpel Chꞌlaj, a jaꞌ nchi okxi rit. ");
INSERT INTO mamC_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kykyaqilxjo ẍi ul nej nwutza ileqꞌqe kyeꞌ, mo bꞌyol xjalqe tuꞌn kyelqꞌin; me ayetzin kye rit mix ẍi kybꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me metzin weꞌ, ayin weꞌ tjpel chꞌlaj. Noq wuꞌn, aku chi okxixjal toj kolbꞌil, tzeꞌnku kye rit a nchi okx ex nchi etz wuꞌn, exsin njyet kywa. ");
INSERT INTO mamC_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Me anteꞌ ileqꞌ noq n-ul teꞌ tuꞌn telqꞌin, ex bꞌiyil, ex yuchꞌil. Me metzin weꞌ, ma chin ula tuꞌn tten kychwinqilxjal toj tzaljbꞌil tzaluꞌn twutz txꞌotxꞌ ex toj kyaꞌj te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ayin weꞌ Tbꞌanil Kyikꞌlel. Jun kyikꞌlel tbꞌanil kxel tqꞌoꞌn teꞌ tchwinqil tuꞌn tkyim, noq tuꞌn kykletjo trit. ");
INSERT INTO mamC_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Me anteꞌ a n-aqꞌnin noq tuꞌn tchjet twiꞌ tkꞌuꞌj, ajtzin t-xi tkaꞌyin aj ttzaj xoꞌj, bꞌeꞌx chi kyjel ttzaqpiꞌn rit, ex bꞌeꞌx k-elil oq, quꞌn nya te kyikꞌleljo, ex nya teqeku rit. Tuꞌnpetziꞌn, xi tqꞌoꞌn ambꞌil te xoꞌj tuꞌn tokx kyxol rit, tuꞌn kybꞌaj junjun, ex tuꞌn tbꞌajel tiljjo txqantl. ");
INSERT INTO mamC_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Quꞌn anteꞌ ichin bꞌeꞌx k-elil oq, quꞌn noq oꞌkx nkubꞌ t-ximiꞌn twiꞌ tkꞌuꞌj, ex nya tuꞌn kykletjo rit tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ayin weꞌ Tbꞌanil Kyikꞌlel. Ikytziꞌn tzeꞌnku te nMaꞌn ojtzqiꞌnqiꞌn tuꞌn, ex ojtzqiꞌn nMaꞌn wuꞌn; ikytzin wejiꞌy ojtzqiꞌnqe we nrit, ex ojtzqiꞌnqiꞌn kyuꞌn. Ok kxel nqꞌoꞌn weꞌ nchwinqil noq tuꞌn kypaj. ");
INSERT INTO mamC_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ex iteꞌ txqantl weꞌ nrit, a nya iteꞌ tojjo chꞌlaj lo. Me ilxix tiꞌj tuꞌn kytzaj wiꞌn, ex kchin kꞌwel nimin kyuꞌn. Junx chꞌuq rit k-elile, ex junchꞌin kyikꞌlel. ");
INSERT INTO mamC_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nimx tqꞌaqꞌbꞌil tkꞌuꞌj nMan wiꞌja, quꞌn kxel nqꞌoꞌn we nchwinqil tuꞌn tkyim, exsin tuꞌn tjaw anqꞌin juntl majl kyxol kyimnin. ");
INSERT INTO mamC_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mix aꞌl jun aku tzꞌel qꞌinte nchwinqila; qalaꞌ ayinx weꞌ kchin xel qꞌoꞌnte wibꞌa wunx wibꞌxa. Quꞌn at we woklin tuꞌn t-xi nqꞌoꞌn wibꞌa tuꞌn nkyima, ex tuꞌn njaw anqꞌintla wuꞌnx wibꞌa. Quꞌn atzin ma tzaj tqꞌmaꞌn nManjiꞌy weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Atzaj teꞌ kybꞌinte Judiy jniꞌ yol ikyjo, mix mejeye kyyol tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","At junjun qꞌmante: ¿Tiquꞌn nxi kybꞌinjiꞌy xjal lo? ¿Nyapela at jun taqꞌnil tajaw il tokx toj tanmin, mo qa ma tzꞌel txꞌuꞌj twiꞌ? ");
INSERT INTO mamC_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Me junjuntl qꞌmante: Mina, quꞌn ¿Ma akutzin yolin jun xjal, a at jun taqꞌnil tajaw il toj tanmin ikyjo? ¿Akutzin bꞌant kykaꞌyin moẍ tuꞌn jun taqꞌnil tajaw il? ");
INSERT INTO mamC_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jbꞌalilkutaq antza, ex toj Jerusalén n-ikyꞌsittaq jun nintz qꞌij tuꞌn tzaj kynaꞌn tbꞌantliꞌn tnejil ja te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nbꞌettaq Jesús twutzjo ja anetziꞌn, a nim telimitz, a tok tbꞌi: Te Salomón. ");
INSERT INTO mamC_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ok kychmoꞌn junjun aj Judiy kyibꞌ tiꞌjile, ex xi kyqanin te: ¿Ma kukxsin ktenbꞌiljiy qxola tuꞌn tja kaꞌmin qkꞌuꞌja tiꞌja? Qa axixjiꞌy Crist, a tuꞌntaq tul te Kolil, qꞌmantza qeꞌy te jun majx jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","I xi ttzaqꞌwin Jesús: ¿Ma nyatzin o txi nqꞌmaꞌn kyeꞌy? Me mi nchinx kynimiꞌn. Tkyaqilxjo nbꞌant wuꞌn noq tuꞌn tipin nMan, atzin nyekꞌin teꞌ qa ayinjiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Me mi nxi kynimiꞌn, quꞌn naꞌm kyoka te nrita, tzeꞌnkuxjo xi nqꞌmaꞌn kyeꞌy te tnejil. ");
INSERT INTO mamC_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Quꞌn noqit o chi oka te nrita, matla txi kybꞌiꞌn tqꞌajqꞌojil nwiꞌy. Quꞌn wojtzqiꞌnqejiꞌy weꞌ, ex nchi ok lipe wiꞌja toj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ex kxel nqꞌoꞌn kychwinqil te jun majx, ex nlayx chi kyij naj. Ex mix aꞌlx aku tzꞌel qꞌinkye toj nqꞌobꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ma chi tzaj tqꞌoꞌn nMaꞌn weꞌy, a nimxix toklin tibꞌaj tkyaqil. Quꞌn tkyaqiljo a ma tzaj lipe wiꞌja teqe nMaꞌn, ex mix aꞌlx aku tzꞌel qꞌinkye toj tqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Quꞌn junxchꞌin qeꞌ qteꞌn tukꞌa nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tuꞌntzin ikyjo, bꞌeꞌx bꞌaj jaw kyiꞌn Judiy abꞌj tuꞌn tkubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Me ante Jesús xi tqꞌmaꞌn kye: Nimku techil tbꞌanilxix ma kubꞌ nbꞌinchiꞌn kywutza, noq tuꞌn tipin nMaꞌn. Kyxol tkyaqiljo luꞌn, ¿Ankye jun nya wen toj kywutza, tuꞌn wok kyxoꞌn tuꞌn abꞌj? ");
INSERT INTO mamC_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Xi kytzaqꞌwin Judiy te: Nlay tzꞌok qxoꞌn te tuꞌn abꞌj noq tuꞌn wen nbꞌant tuꞌn; qalaꞌ noq tuꞌn nxoꞌn yol tiꞌj Dios tuꞌn tyola, a noq jun tal ichin tzeꞌnku qeꞌ. ¿Me ma tzꞌok tqꞌoꞌnnaj tibꞌa te Dios? ");
INSERT INTO mamC_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Xi tqꞌmaꞌn Jesús kye: ¿Ma miꞌtzin nkux kyuꞌjiꞌn toj Tuꞌjil Tyol Dios, a jaꞌ tzꞌibꞌine kyiꞌj junjun xjal, tej t-xi tqꞌmaꞌn Dios kye, qa diosqe? ");
INSERT INTO mamC_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Atziꞌn jaꞌlin, bꞌiꞌn quꞌn, a tzꞌibꞌiꞌn toj Tuꞌjil qMan, tzꞌaqlexix ex ntiꞌ tkyꞌi. Quꞌn qa ax Dios ok qꞌoꞌnte kybꞌi te diosqe, a ayeꞌ i xiꞌ kꞌmoꞌnte Tyol ojtxe, ");
INSERT INTO mamC_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Tiꞌtzin quꞌntz ma tzaj kyqꞌmaꞌn weꞌy, qa nchin xoꞌn yol tiꞌj Dios, noq tuꞌn xi nqꞌmaꞌn qa ayiꞌn Tkꞌwal Dios? Quꞌn ax Dios el paꞌn weꞌy tuꞌn ntzaj tchqꞌoꞌn tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Qa mi xkubꞌ nbꞌinchiꞌn tkyaqil techil wipiꞌn tzeꞌnkuxjo nbꞌant tuꞌn nMaꞌn, nlayx chinx kynimiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Me exla qa mi ẍinx kynimiꞌn, me antza k-elile kynikyꞌa te te jun majx, noq kyuꞌn jniꞌ nbꞌinchbꞌiꞌn bꞌaꞌn, qa a qMan Dios mujle tibꞌ wukꞌiy, ex qa ayiꞌn mujleqin tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Antza tuꞌn toketaq kytzyuꞌn juntl majl, me chebꞌe el tzaqpaj toj kyqꞌobꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tbꞌajlinxiꞌ ikyjo, meltzꞌaj Jesús tjlajxi Nim Aꞌ Jordán. Antza kyije ten tojjo txꞌotxꞌ, a jaꞌ nchi kuxa tqꞌoꞌntaq Juan xjal toj aꞌ te jawsbꞌil aꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nimku xjal i xtaꞌj lolte Jesús, ex kyqꞌma: Exla qa ntiꞌ te Juan techil xbꞌant tuꞌn a nim tipin, me tkyaqilxjo o tqꞌma tiꞌjjo ichin lo twutzxix. ");
INSERT INTO mamC_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nimx xjal i nimin tiꞌj Jesús tojjo txꞌotxꞌ anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Attaq jun ichin aj Betania, Lázaro tbꞌi, yabꞌtaq. Junxtaq iteꞌ kyukꞌa tanebꞌ, Mariy tukꞌax titzꞌin Mart. ");
INSERT INTO mamC_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Anteꞌ Mariy luꞌn, a kubꞌ qꞌoꞌnte jupsbꞌil kyibꞌaj tqan qAjaw, ex ok ttzqijsin tukꞌa tsmal twiꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ayetziꞌn kabꞌe qya lo xi kysmaꞌn tqanil te Jesús: Tata, ajo tukꞌiy Lázaro, a kꞌuꞌjlin tuꞌn, ma yabꞌte, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tej tbꞌinte Jesús ikyjo, tzaj tqꞌmaꞌn: Ajo yabꞌil anetziꞌn nlay japin bꞌaj teꞌ te kyimin; qalaꞌ noq tuꞌn tyekꞌiꞌn tipin tqoptzꞌajiyil Dios, ex tuꞌn tjaw nimsit nbꞌiꞌy, ayiꞌn Tkꞌwal. ");
INSERT INTO mamC_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Exla qa kꞌuꞌjlinxix Mart kyukꞌax ttziky, ");
INSERT INTO mamC_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","me tej tbꞌinte Jesús, qa yabꞌtaq Lázaro, axsa kyije tenl kabꞌe qꞌij, a jaꞌ taꞌyetaq. ");
INSERT INTO mamC_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tbꞌajlinxiꞌ ikyjo, tzaj tqꞌmaꞌn qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin: Qo meltzꞌaj majl toj ttxꞌotxꞌ Judey. ");
INSERT INTO mamC_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Awotzin qeꞌ xi qqꞌmaꞌn te: Xnaqꞌtzil, ¿Ma nyatzin itzqeyin qajlintz antza, ex kyajtaqxjal tuꞌn tkubꞌ bꞌyoꞌn kyuꞌn tukꞌa abꞌj? ¿Tiquꞌnil taja tuꞌn tmeltzꞌaja antza? ");
INSERT INTO mamC_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tzaj tqꞌmaꞌn Jesús qeꞌy: Ajo tspikyꞌin qꞌij oꞌkx nweꞌ te kabꞌlajaj or. Qa nqo bꞌet tqan qꞌijil, nlay qo jaw takpaj, quꞌn nqo kaꞌyin toj tqan qꞌij, a nkꞌant twutzjo txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Me qa nqo bꞌet toj qnikyꞌin, qo jawil takpaj, quꞌn nya qꞌanchaꞌljo qbꞌe. Tuꞌnpetziꞌn qa nqo bꞌinchin tzeꞌnku taj qMan, ntiꞌ aku tzꞌok bꞌajqe. ");
INSERT INTO mamC_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tbꞌajlinxitzin tyolin ikyjo, tzaj tqꞌmaꞌnl qeꞌy: Ajo qukꞌa Lázaro, a kꞌuꞌjlin quꞌn, ma ktan. Me ma chiꞌn kꞌasilte. ");
INSERT INTO mamC_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Awotzin qeꞌ xi qqꞌmaꞌn te: Tata, qa ma ktan, bꞌalaqa ma chewx yabꞌil tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Me atzin tzꞌelpineꞌ tyol Jesús ikyjo, qa otaq kyim. Me awotzin qe, kubꞌ qximiꞌn qa nyolintaq tiꞌjjo watl te qxmilil. ");
INSERT INTO mamC_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tuꞌnpetziꞌn, tzajxix tqꞌmaꞌn Jesús qeꞌy: Ma kyim te Lázaroch. ");
INSERT INTO mamC_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nim ma chin jaw tzalaja tuꞌn ntiꞌqintaqa antza, quꞌn wenxix te kyeꞌy, tuꞌn nxi kynimiꞌn tukꞌa tkyaqil kyanmiꞌn. Me qoqe lolte. ");
INSERT INTO mamC_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ante Tmas, a Kwaꞌch tbꞌi tok, tzaj tqꞌmaꞌn qeꞌy: Qoqe qkyaqilx, tuꞌntla qkyim junx tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Atzaj teꞌ qkaniꞌn, pon qkꞌulbꞌiꞌn qa otaq bꞌant kyaje qꞌij tkubꞌlinx muqet Lázaro. ");
INSERT INTO mamC_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ajo tnam Betania nqayin taꞌ tkꞌatz Jerusalén, bꞌalaqa noq nikyꞌjin ajlabꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tuꞌn nqayin taꞌ, nim xjal Judiy otaq kanin qꞌolbꞌilkye Mart tukꞌa Mariy, tuꞌn tchewsit kyanmin tiꞌjjo tkyimlin kyxibꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tej tbꞌinte Mart, qa chꞌixtaq tpon kanin Jesús kyja, bꞌeꞌx etz kꞌlelte; me atzin te Mariy kyij ten tuja. ");
INSERT INTO mamC_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tej tkanin tkꞌatz Jesús, xi tqꞌmaꞌn Mart te: Tata, noqit attaqa tzaluꞌn, mitla xkyim weꞌ nxibꞌin, ");
INSERT INTO mamC_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","quꞌn bꞌiꞌn weꞌ wuꞌn qa ntzaj tqꞌoꞌn Diosjo tkyaqilx nxi tqaniꞌn te. ");
INSERT INTO mamC_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Xi tqꞌmaꞌn Jesús te: Kjawil anqꞌintl te t-xibꞌinch. ");
INSERT INTO mamC_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Xi ttzaqꞌwin Mart te: Ikytziꞌn. Bꞌiꞌn weꞌ wuꞌn qa ok kjawil anqꞌintl tojjo tqꞌijil, a jaꞌ tuꞌn kyjaw anqꞌintl kyimnin, aj tjapin bꞌaj tkyaqil tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Bꞌeꞌx xi tqꞌmaꞌn Jesús te: Ayiꞌn weꞌ Qꞌol chwinqil, ex wuꞌn weꞌ kchi jawil anqꞌinxjal kyxol kyimnin. Ankye teꞌ knimil wiꞌja, exla qa ma kyim t-xmilil, me kjawil anqꞌintl wuꞌn, tuꞌn tten jun chwinqil a nlay bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Quꞌn kykyaqilxjo nchi nimin wiꞌja, ex nchi bꞌet tzeꞌnku waja, nlayxpe chi najx kye te jun majx. ¿Yajtziꞌn te, Mart? ¿Man txi tniminjiꞌy luꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Xi tqꞌmaꞌn Mart te: Ikytziꞌn Tata, ma txi nnimin weꞌ, a tejiy Crist, a Tkꞌwal qMan Dios, a iltaq tiꞌj tuꞌn tul tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tbꞌajlinxiꞌ tyolin ikyjo, bꞌeꞌx aj Mart qꞌolbꞌil te Mariy, ex xi tjaskꞌin te: Lu Xnaqꞌtzil at tzaluꞌn, ex luy ntxokle tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Atzaj teꞌ tbꞌinte Mariy, jun paqx jaw weꞌ, ex xiꞌ ajqelin lolte Jesús, ");
INSERT INTO mamC_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","quꞌn naꞌmxtaq tokx Jesús toj tnam. Axtaqtza taꞌye ttxaꞌn tnam, jaꞌ oke tkꞌulbꞌin Mart. ");
INSERT INTO mamC_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Atzaj teꞌ tok kaꞌyin Mariy kyuꞌn qꞌuqbꞌil kykꞌuꞌj iteꞌtaq tuja, tej tex ajqelin, bꞌeꞌx bꞌaj xi lipe tiꞌj, quꞌn kubꞌ kyximin qa tuꞌntaq t-xiꞌ oqꞌil tibꞌajjo muqbꞌin te Lázaro. ");
INSERT INTO mamC_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Atzaj teꞌ tkanin Mariy tkꞌatz Jesús, bꞌeꞌx kubꞌ meje t-xe tqan, ex xi tqꞌmaꞌn: Tata, noqit attaqa tzaluꞌn, mitla xkyim weꞌ nxibꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Atzin te Jesús, tej tok tkaꞌyin n-oqꞌ Mariy kyukꞌaxjo jniꞌ Judiy, a otaq chi kanin tukꞌa, bꞌeꞌx tzaj tbꞌis, ex tzaj chyoꞌn tanmin, ");
INSERT INTO mamC_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ex xi tqanin kye: Jaꞌtzin xkuxa kymuquꞌnch. Xi kyqꞌmaꞌn te: Tata, ku tzaja lolte. ");
INSERT INTO mamC_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ex jaw oqꞌ Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Xi kyqꞌmaꞌn Judiy kyxolile: Kykaꞌyinktziꞌn. Chebꞌex kꞌuꞌjlintaq Lázaro tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Me at junjuntl nkyqꞌmaꞌntaq: A ma jqet kywutz moẍ tuꞌnx xjal lo, ¿Ma mipetla xbꞌant jun tiꞌ tuꞌn, tuꞌn mi kyime Lázaro? ");
INSERT INTO mamC_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Atzin te Jesús, bꞌeꞌx tzaj chyoꞌn juntl majl tanmin, ex bꞌeꞌx tzaj laqꞌe ttzi jul, a jaꞌ tokxitaq kyimnin, jpuꞌntaq tukꞌa jun ma tij abꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Xi tqꞌmaꞌn Jesús kyexjal: Kyimiljiꞌy abꞌj. Atzin te Mart; a tanebꞌjo kyimnin, xi tqꞌmaꞌn te: Tata, mala tzuwix, quꞌn ma bꞌant kyaje qꞌij tkyimlin. ");
INSERT INTO mamC_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Me ante Jesús xi tqꞌmaꞌn te: ¿Ma nyatzin ma txi nqꞌmaꞌn teꞌy, qa ma txi tnimiꞌn, okpin ktlabꞌil te nimxix tipin Dios? ");
INSERT INTO mamC_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Eltzin qꞌiꞌn abꞌj, ex ante Jesús jax tkaꞌyiꞌn tzmax toj kyaꞌj, ex tqꞌma: Tata, nxi nqꞌoꞌn chjonte teꞌy, tuꞌn ma chin tzaj tbꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Bꞌiꞌn we wuꞌn, qa kukx nchin tzaj tbꞌinjiꞌy, me ma txi nqꞌmanjiꞌy luꞌn teꞌy, noq tuꞌn kypajjo xjal txolcheqek wiꞌja, tuꞌntzin txi kynimin qa ate ma tzaj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tbꞌajlinxiꞌ tqꞌmaꞌn ikyjo, xi tqꞌolbꞌin tukꞌa tqꞌajqꞌojil twiꞌ kujxix wen: Lázaro, ku tetza antza. ");
INSERT INTO mamC_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ex atzin tej kyimnin bꞌeꞌx etz, bꞌaltzꞌinqektaqjo tqꞌobꞌ kyukꞌa tqan toj t-xbꞌalin kyimnin, ex ptzoꞌntaq twutz tukꞌa suꞌtj. Bꞌeꞌx xi tqꞌmaꞌn Jesús kye: Kypoqꞌimila, ex kytzaqpinxa. ");
INSERT INTO mamC_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tuꞌntziꞌn ikyjo, nimx Judiy, ayej o chex lipe tiꞌj Mariy, ex ok kykaꞌyiꞌn bꞌant tuꞌn Jesús, i nimin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Me attaq junjuntl kyxol bꞌeꞌx i xiꞌ qꞌmalte kye Parisey tiꞌ otaq kubꞌ tbꞌinchin Jesús tukꞌa Lázaro. ");
INSERT INTO mamC_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tuꞌnpetziꞌn, aye Parisey exqetziꞌn kynejinel pale, bꞌeꞌx ok kychmoꞌn kyibꞌ kyukꞌa jniꞌ Judiy aj kawil. I ok ten yolil kyxol: ¿Tiꞌtzin kbꞌantil quꞌn tiꞌjjo maꞌ xjal lo? Nimku techil nbꞌant tuꞌn, tuꞌn kykaꞌylajxjal tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Qa ma kyij qqꞌoꞌn kukxjo, tkyaqilxlaxjal knimil tiꞌj. Ex ayetziꞌn aj kawil toj Rom, kchi tzajil qibꞌaj qꞌil qoklin toj tja Dios, ex tuꞌn tkubꞌ kyyuchꞌin qtanim. ");
INSERT INTO mamC_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Me attaq jun kyxol, a Caifás tbꞌi, toktaq te kynejilxix pale tojjo abꞌqꞌe anetziꞌn, ex xi tqꞌmaꞌn kye: Ntiꞌx kye kynabꞌl. ");
INSERT INTO mamC_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Ma mixsin n-el kynikyꞌa tiꞌj, qa wenxitla te qe, tuꞌn tkyim jun ichin te qxel, tzeꞌnku tuꞌn tkubꞌ yuchꞌj kykyaqil qtanim? ");
INSERT INTO mamC_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Me ante Caifás nya tuꞌnx tibꞌxtaq nyolin; qalaꞌ tuꞌn Dios. Quꞌn tuꞌn toktaq te tnejilxix pale, tzaj tqꞌoꞌn Dios tqanil te, qa iltaq tiꞌj tuꞌn tkyim Jesús te kyxel xjal aj Judiy, ");
INSERT INTO mamC_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","junx kyukꞌaꞌ a kchi nimil tiꞌj toj tkyaqil twutz txꞌotxꞌ, tuꞌn kymujbꞌin te kyibꞌ toj kynimbꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tuꞌnpetziꞌn, ax qꞌijjo anetziꞌn, bꞌeꞌx i kyij aj kawil toj wen, tuꞌn tkubꞌ kybꞌyoꞌn Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tuꞌnpetziꞌn, mix tenil Jesús kyxol Judiy; qalaꞌ bꞌeꞌx etz tojjo ttxꞌotxꞌ Judey, ex bꞌeꞌx xiꞌ ttxaꞌn tzqij txꞌotxꞌ toj jun tnam, Efraín tbꞌi. Axsa kyije tene junx qukꞌiy, a awoꞌy t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nyataq ilaꞌ qꞌij tuꞌn tul kanin Xjan Qꞌij kye Judiy. Tuꞌnpetziꞌn, nimku xjal aj Judiy bꞌeꞌx i xiꞌ toj Jerusalén, tuꞌn kybꞌinchin kyten tzeꞌnkuxtaqjo nbꞌant kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tkyaqilxjal nchi jyoꞌntaq tiꞌj Jesús toj tnejil ja te naꞌbꞌl Dios, ex nxi kyqanintaq kyxolx: ¿Tzeꞌntzin kye toj kywutz? ¿Jawilpela toj nintz qꞌij mo minaj? ");
INSERT INTO mamC_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Quꞌn ayetziꞌn Parisey exqetziꞌn kynejinel pale otaq kubꞌ kyqꞌoꞌn jun kykawbꞌil, qa attaq jun xbꞌinte jaꞌ taꞌtaq Jesús, ilx tiꞌj tuꞌn tzaj kyiꞌn tqanil, tuꞌntzintla tok kytzyuꞌn, tuꞌn tkuꞌx toj tze. ");
INSERT INTO mamC_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Noq qaq qꞌijtaq tuꞌn tpon kanin nintz qꞌij te Xjan Qꞌij. Bꞌeꞌx xiꞌ Jesús toj kojbꞌil Betania, a jaꞌ najletaq Lázaro, a otaq jaw anqꞌintl tuꞌn Jesús toj kyime. ");
INSERT INTO mamC_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Antza kubꞌe kybꞌinchin jun wabꞌj te aqꞌbꞌil chjonte te Jesús. Ate Mart nsipintaq wabꞌj, ex ajin te Lázaro qꞌuqlektaq waꞌl kyukꞌa tiꞌj meẍ. ");
INSERT INTO mamC_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ante Mariy tzaj tiꞌn jun tkꞌwel qꞌanbꞌil, nardo tbꞌi, a jun wiq jupsbꞌil tbꞌanilxix wen ex wiyilxix. Ex kubꞌ tqꞌoꞌn tkyaqil kyibꞌajjo tqan Jesús, ex jun paqx ok tzqijsin tukꞌa tsmal twiꞌ. Ex tkyaqil toj ja kubꞌ juptzꞌaj tuꞌn tbꞌanil tkꞌokꞌjil. ");
INSERT INTO mamC_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Me attaq jun t-xnaqꞌtzbꞌin Jesús antza, a Judas Iscariot tbꞌi, a tuꞌntaq t-xi kꞌayinte toj kyqꞌobꞌ tajqꞌoj. Xi tqꞌmaꞌn te Jesús: ");
INSERT INTO mamC_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Tiquꞌnil mi xi kꞌayitjo jupsbꞌil lo, a wiyilxix wen, tuꞌn kyxi qmojin tal yajqe? ");
INSERT INTO mamC_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Me ante Judas nya nbꞌinsintaq kyiꞌjjo yaj, qalaꞌ kubꞌ tqꞌmaꞌn ikyjo quꞌn ileqꞌtaq. Quꞌn ate Judas toktaq toklin te chmol pwaq qxola, ex tzuntaq jatz telqꞌin chꞌin tiꞌjjo a chmoꞌntaq tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Xi tqꞌmaꞌn Jesús te: Tenkuj. Quꞌn ma kubꞌ tkꞌuꞌn luꞌn tzmax jaꞌlin, tuꞌn tbꞌant nteꞌn te muqbꞌil weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Quꞌn atzin kye yaj, axsi kchi kꞌwele ten kyxola, ex bꞌaꞌn tuꞌn kyxi kymojiꞌn noq tiꞌ qꞌijil. Qalatziꞌn weꞌ, nya kukx kchin kꞌwel ten wejiꞌy kyxola. ");
INSERT INTO mamC_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nimx Judiy i bꞌinte qa antza taꞌye Jesús toj tnam Betania, ex bꞌeꞌx i bꞌaj xiꞌ antza lolte Jesús tukꞌax Lázaro, a otaq jaw anqꞌintl tuꞌn Jesús kyxol kyimnin. ");
INSERT INTO mamC_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ayetziꞌn kynejinel pale bꞌeꞌx i kyij toj wen tuꞌn tkubꞌ bꞌyet Jesús majx Lázaro tukꞌa, ");
INSERT INTO mamC_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","quꞌn noq tuꞌn tpaj Lázaro, nimx Judiy otaq tzꞌel kypaꞌn kyibꞌ kyiꞌj, noq tuꞌn kyxi lipe tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nimkutaq xjal otaq txiꞌ ikyꞌsil Xjan Qꞌij toj Jerusalén. Toj junxil qꞌij, ok kybꞌin qa tuꞌntaq tkanin Jesús antza. ");
INSERT INTO mamC_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tuꞌnpetziꞌn, i ok ten txꞌemil txqan t-xaq tze, palma tbꞌi, exsin i bꞌajetz kꞌlelte Jesús, ex i bꞌaj ẍchꞌin kyjaluꞌn: Nimxit tbꞌi qMan Dios. Kyꞌiwlinxitjo a tzul kanin toj Tbꞌi qAjaw. Kyꞌiwlinxitjo a nmaq kawil tibꞌaj Israel. ");
INSERT INTO mamC_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","El jyet jun tal bur tuꞌn Jesús, ex bꞌeꞌx jax qe tibꞌaj, tzeꞌnkuxtaqjo ntqꞌmaꞌn toj Tuꞌjil Tyol Dios: ");
INSERT INTO mamC_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mi chi jaw xobꞌa, ayiꞌy najleqe toj tnam Sion. ¡Kykaꞌyinxa! Luꞌ kyNmaq Kawila tzul qꞌuqlekx chejil tibꞌaj jun tal bur. ");
INSERT INTO mamC_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Te tnejil, mix ele qnikyꞌa tiꞌj tkyaqiljo lo, a awoꞌy t-xnaqꞌtzbꞌin; me yajxi, tej tjax Jesús toj kyaꞌj, bꞌeꞌx bꞌaj ul julkꞌaj toj qkꞌuꞌja tkyaqiljo tzꞌibꞌintaq tiꞌj toj Tuꞌjil Tyol Dios, ex ikyxixsin otaq bꞌajjo. ");
INSERT INTO mamC_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Me ayeqetziꞌn xjal iteꞌtaq tukꞌa Jesús, tej ttzaj tqꞌolbꞌin Lázaro toj jul, ex tej tjaw anqꞌintl tuꞌn, tzunx nchi yolintaq tiꞌj kyukꞌa txqantl. ");
INSERT INTO mamC_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tuꞌntziꞌn ikyjo, i bꞌajetz xjal toj tnam kꞌlelte Jesús, quꞌn otaq tzꞌok kybꞌiꞌn techil tipin tbꞌanilxix tiꞌj Lázaro. ");
INSERT INTO mamC_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ex mix ele wenjo luꞌn toj kywutz Parisey. Bꞌaj kubꞌ kyyolin kyxolx: ¡Kaꞌn! Ntiꞌx jun aku bꞌant quꞌn tiꞌj, quꞌn kykaꞌyinxsiꞌn; kykyaqilxjal ma txi lipe tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kyxoljo xjal a otaq chi kanin ikyꞌsil nintz qꞌij toj Jerusalén, attaq junjun xjal aj Grecia. ");
INSERT INTO mamC_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ex attaq jun qukꞌiy, a awoꞌy t-xnaqꞌtzbꞌin Jesús, Lip tbꞌi, tzajnin toj tnam Betsaida toj ttxꞌotxꞌ Galiley. Aye aj Grecia i tzaj laqꞌe tkꞌatz Lip, ex i kubꞌsin kywutz te: Tata, noq same, qajatlaꞌy tuꞌn qyoliꞌn tukꞌa Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Bꞌeꞌxsin xiꞌ Lip, ex xi tqꞌmaꞌn te Andrés, ex kykabꞌilx i xiꞌ qꞌmalte te Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Xi tqꞌmaꞌn Jesús kye: Chꞌix tul kanin nqꞌijila, ayiꞌn, a Tkꞌwal Ichin, tuꞌn nkyima, tuꞌn njaw anqꞌiꞌn, ex tuꞌn njaxa toj kyaꞌj tukꞌa tkyaqil nqoptzꞌajiyila. ");
INSERT INTO mamC_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Quꞌn twutzxix kxel nqꞌmaꞌn kyeꞌy, ikytzin wejiꞌy tzeꞌnku jun twutz triy. Qa mix xkux miqet toj txꞌotxꞌ, nlay chꞌiy, qalaꞌ oꞌkxjo tal junchꞌin ex ntiꞌ tajbꞌin. Me qa ma kux miqet toj txꞌotxꞌ tuꞌn tkyim, ok chmetil txqantl twutz. ");
INSERT INTO mamC_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ankye teꞌ taj noq tuꞌn tok tkꞌuꞌjlin tchwinqil tzaluꞌn twutz txꞌotxꞌ, ok kꞌwel najsin tkyaqil. Me ankye teꞌ kxel qꞌonte tibꞌ toj tqꞌobꞌ Dios, ex mi n-ok tilil tuꞌn tiꞌjjo tchwinqil tzaluꞌn twutz txꞌotxꞌ, apente kkanbꞌil jun tchwinqiljo, a nlay bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ex ankye jun n-ok tilil tuꞌn, tuꞌn tajbꞌin weꞌy, bꞌaꞌn tuꞌn tok lipe wiꞌja, tuꞌn tten junx wukꞌiy toj tkyaqil. Ex ankye te n-ajbꞌin weꞌy, apente kjawil nimsiꞌn tuꞌn nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Atziꞌn jaꞌlin, nimx nchyoꞌn wanmiꞌn tuꞌn nbꞌisa. ¿Tiꞌtzila kxel nqꞌmaꞌn? ¿Ma okpela kxel nqꞌmaꞌn: Tata, chin tkloma, tuꞌn mi tzꞌikyxe wuꞌn tkyaqilxjo kbꞌajil wiꞌja? ¡Mina! Quꞌn tuꞌnpen teꞌ luꞌn ẍin uliy. Qalaꞌ kxel nqꞌmaꞌn: ");
INSERT INTO mamC_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, nimsinks tbꞌiy wiꞌja. Tekuxjo xi tqꞌmaꞌn yol anetziꞌn, bꞌijte jun tqꞌajqꞌojil wibꞌaj toj kyaꞌj, a tqꞌma: O jaw nnimsiꞌn nbꞌiy, ex kjawil nnimsiꞌn juntl majla. ");
INSERT INTO mamC_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ayetziꞌn xjal iteꞌtaq tkꞌatz, te kybꞌinte yol luꞌn, xi kyqꞌmaꞌn kyxolile, qa noq jun qꞌankyaq jaw tinin. Me junjuntl qꞌmante qa jun angel tzaj yolin tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Jesús kye: Nya noq te qꞌuqbꞌil nkꞌuꞌja saje yolin teꞌ tqꞌajqꞌojil wiꞌbꞌaj; qalaꞌ te qꞌuqbꞌil kykꞌuꞌja wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Quꞌn atzin jaꞌlin, chꞌixxix tul kanin tqꞌijil te kykyaqil xjal twutz txꞌotxꞌ, tuꞌn kyok toj paꞌbꞌin twutz Dios, ex ilxix tiꞌj tuꞌn tex lajet tajaw il, quꞌn twutzxix kxel nqꞌmaꞌn kyeꞌy, qa kꞌwel tiꞌj wuꞌn te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Quꞌn ajtzin njaw qꞌoꞌn twutz tze tzaluꞌn twutz txꞌotxꞌ, ktzajil nchmoꞌn kykyaqil xjal wuꞌnx wibꞌxa. ");
INSERT INTO mamC_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tukꞌa yol anetziꞌn; nyekꞌin Jesús tzeꞌn tumil tuꞌn tkyime. ");
INSERT INTO mamC_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Xi kytzaqꞌwin xjal: ¿Ma nyatzin tzun ntqꞌmaꞌn toj Tuꞌjil Tyol Dios, qa ate Crist il tiꞌj tuꞌn tten te jun majx? ¿Tzeꞌntzin ttentz ntqꞌmaꞌntza, qa ajo Tkꞌwal Ichin il tiꞌj tuꞌn tjaw twutz cruz tuꞌn tkyim? ¿Tzeꞌntzin tzꞌelpineꞌ Tkꞌwal Ichin? ");
INSERT INTO mamC_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Xi tqꞌmaꞌn Jesús kye: Ayin weꞌ spikyꞌin loqiꞌn intiꞌnx kyxola. Me noq te jun paql intiꞌn kyukꞌiy. Tuꞌnpetziꞌn, chi lipeka tiꞌjjo spikyꞌin, tuꞌntzin mi chi kyijiꞌy toj qxopin. Quꞌn ankye teꞌ nbꞌet toj qxopin, ntiꞌ bꞌiꞌn tuꞌn jaꞌtzin t-xiye. ");
INSERT INTO mamC_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tuꞌnpetziꞌn, kyniminxjiꞌy spikyꞌin, a luꞌ atx chꞌintl kyukꞌiy, tuꞌntzin kyoka te jun xjal aj spikyꞌin. Tbꞌajlinxiꞌ tqꞌmaꞌn Jesús ikyjo, bꞌeꞌx el tewin tibꞌ kywutz. ");
INSERT INTO mamC_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mix tuꞌn nimx techil tipin Jesús o bꞌant tuꞌn kywutzxjal, me mix i niminix tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tukꞌajo lo, japin bꞌajjo tyol Isaías, a yolil Tyol Dios ojtxe, tej tkubꞌ ttzꞌibꞌin: Tata, ¿Ankye ma txi niminte Tbꞌanil Tqanil tiꞌja, a ma txi qqꞌmaꞌn? ¿Altzila qe xaye tyekꞌin tAjaw Tkyaqil toklin Tkawbꞌil kyibꞌaj? ");
INSERT INTO mamC_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Exla qa ikyjo, nlayx txi kynimin, quꞌn atx juntl yol kyij ttzꞌibꞌin Isaías kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Quꞌn ax Dios s-ok moẍsinte kywutz, ex s-ok chꞌuẍsinte kyanmin, tuꞌntzin mi tzꞌele kynikyꞌ te tuꞌn kywutz. Ex tuꞌn mi kybꞌiye tuꞌn kyanmin. Ex ntiꞌx ma chi meltzꞌaj wukꞌiy, tuꞌn kykubꞌ nqꞌaniꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kyij ttzꞌibꞌin Isaías ikyjo, quꞌn otaq tli nimx toklin Jesús, exsin nyolintaq tiꞌj, a naꞌmtaq tul kanin Jesús twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Me kyxol tkyaqiljo luꞌn, attaq junjun Judiy i nimin tiꞌj Jesús, ex majxpe junjun nejinel kyxol. Me mix kubꞌe kychikybꞌin kywutzxjal noq tuꞌnjo kyxobꞌil kye Parisey, tuꞌn mi chi exe lajoꞌn tiꞌjjo kyoklin tojjo ja te kynaꞌbꞌl Dios aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Quꞌn wenxixtaq toj kywutz, tuꞌn kyja nimsin kyuꞌnxjal tzaluꞌn twutz txꞌotxꞌ, tzeꞌnku tuꞌn kyja nimsin tuꞌn Dios toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Xi tqꞌmaꞌn Jesús tukꞌa tqꞌajqꞌojil twiꞌ: Ankye te knimil wiꞌja, nya oꞌkqinxa kchin xel tnimin; qalaꞌ aku nMaꞌn, a tzaj chqꞌon weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ex ankye te ma chin tliꞌy, ex ma tli Dios, a tzaj chqꞌon weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Quꞌn ayin wejiꞌy tspikyꞌin Dios, a ma tzul tzaluꞌn twutz txꞌotxꞌ, tuꞌntzin alkye knimil wiꞌja nlayxpen kyijx teꞌ toj qxopin. ");
INSERT INTO mamC_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Me qa at jun ma bꞌinte nyola, ex mi xi tnimin, ok najil teꞌ; me nya npaja, quꞌn nya ma chin ula tuꞌn nkawiꞌn kyibꞌaj kykyaqil xjal, qalaꞌ noq tuꞌn kyklet wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ex ankye k-elil ikyꞌin weꞌy, ex mi xi tbꞌin nyola, at jun kkawil tibꞌaj; ayexjo yol, a o cheꞌx nqꞌmaꞌn. Ex ayexsin kchi kawiljo tiꞌj toj paꞌbꞌin twutz Dios, aj tjapin bꞌaj tqꞌijil tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Quꞌn ayejo nyola ex tkyaqil nxnaqꞌtzbꞌila nya weqekuy; qalaꞌ te nMaꞌn, a tzaj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bꞌiꞌn weꞌ wuꞌn qa ayejo Tyol Dios ma chi tzaj tqꞌmaꞌn, ayetzin ttxuyil chwinqiljo te jun majx. Tuꞌnpetziꞌn, oꞌkx nxi nqꞌmaꞌnjiꞌy tzeꞌnkuxjo ma tzaj nikꞌuꞌn weꞌy tuꞌn nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Atzin teꞌ tjapin kanin tqꞌijil nintz qꞌij te Waꞌj Pan, bꞌiꞌntaq tuꞌn Jesús, qa iltaq tiꞌj tuꞌn tkyim, ex tuꞌn taj tukꞌa tMan toj kyaꞌj. Kukx nkꞌuꞌjlintaqjo kyiꞌjjo aye otaq chi ok lipe tiꞌj tzaluꞌn twutz txꞌotxꞌ. Me atzin jaꞌlin, tajtaq tuꞌn t-xi tyekꞌin tkyaqil t-xilin tqꞌaqꞌbꞌil tkꞌuꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ex kyjaꞌtaq qxiꞌy waꞌl, otaq kuꞌx tajaw il toj tanmin Judas, tkꞌwal jun xjal, Simun tbꞌi, tuꞌn t-xiꞌ kꞌayilte Jesús toj kyqꞌobꞌ tajqꞌoj. ");
INSERT INTO mamC_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Me bꞌintaql te Jesús tuꞌn, qa tukꞌa Dios otaq tzaje, ex iltaq tiꞌj tuꞌn taj tukꞌa juntl majl, ex ax Dios o tzaj qꞌonte toklin tibꞌaj tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tuꞌnpetziꞌn, a tzmataq nqo waꞌn, ja weꞌks tiꞌj meẍ, el tiꞌn ttxoꞌw, ex ok tbꞌaltzꞌin jun bꞌuꞌẍ tiꞌj tkꞌuꞌj, ");
INSERT INTO mamC_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ex kux tqoꞌn aꞌ toj jun txꞌajbꞌil, ex ok ten txjol qqaꞌn, a awoꞌy t-xnaqꞌtzbꞌin, ex i el ttzqijsin tuꞌn bꞌuꞌẍ, a otaq tzꞌok tbꞌaltzꞌin tiꞌj tkꞌuꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Me atzaj teꞌ tpon kanin tuꞌn kyel txjet tqan Simun Pegr, xi tqꞌmaꞌn Pegr te: WAjaw, ¿Ma attzin we woklin tuꞌn tel ttxjoꞌn nqaꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Xi ttzaqꞌwin Jesús te: Nlay tzꞌel tnikyꞌa tiꞌjjo nbꞌant wuꞌn jaꞌlin, me yajxi, k-elil tnikyꞌa te. ");
INSERT INTO mamC_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Me ante Pegr xi tqꞌmaꞌn: Nlayx ntziyiꞌy jun maj tuꞌn tel ttxjoꞌn nqaꞌn. Xi ttzaqꞌwin Jesús: Qa mi s-el ntxjoꞌn tqan, ntiꞌxpen toklintza wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Xitzin tqꞌmaꞌn Pegr te: WAjaw, qa ikytzjo, nya noq oꞌkqex nqaꞌn, qalaꞌ txjonqemila nqꞌobꞌa majx tukꞌa nwiꞌy, tuꞌntzintla at-xix woklintza tukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Me ante Jesús xi tqꞌmaꞌn te: Ankye te tzmax bꞌaj txjet, nya il tiꞌj tuꞌn tel txjet juntl majl, qalaꞌ oꞌkqexjo tqan, tuꞌntzin tsaqix tkyaqil. Me tzeꞌnku kyeꞌ ma chi saqix kyeꞌ, exla qa nya kykyaqilxa. ");
INSERT INTO mamC_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Xi tqꞌmaꞌn ikyjo: Nya kykyaqilxa ma chi saqixa, quꞌn bꞌiꞌntaq tuꞌn, alkye tuꞌn t-xi kꞌayinte toj kyqꞌobꞌ aj il. ");
INSERT INTO mamC_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tbꞌajlinxiꞌ ttxjoꞌn qqaꞌn, ok tqꞌoꞌn Jesús ttxoꞌw, ex ok qe juntl majl tiꞌj meẍ, ex tzaj tqꞌmaꞌn qeꞌy: ¿Man tzꞌel kynikyꞌa tiꞌjjo xbꞌant wuꞌn kyxola? ");
INSERT INTO mamC_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Quꞌn n-ok kyqꞌoꞌn nbꞌiꞌy te Xnaqꞌtzil ex te kyAjawa. Twutzx kye kyuꞌn, quꞌn ayintzinjiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Exsin qa ayinjiꞌy Xnaqꞌtzil ex kyAjawa, a ma tzꞌel ntxjoꞌn kyqaꞌn, ikyqexsin kyejiꞌy, bꞌaꞌntla tuꞌn tel kytxjoꞌn kyqaꞌn jun tukꞌa juntl. ");
INSERT INTO mamC_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ma kubꞌ nqꞌoꞌn jun yekꞌbꞌil, tuꞌntzin tkubꞌ kybꞌinchiꞌn tzeꞌnkuxjo ma kubꞌ nbꞌinchiꞌn kywutza. ");
INSERT INTO mamC_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Twutzxix kxel nqꞌmaꞌn kyeꞌy, mix aꞌl junte aqꞌnil nimxtl toklin tzeꞌnku te tajaw aqꞌuntl; ex mix aꞌl junte, a chqꞌoꞌn nimxtl toklin tzeꞌnku saj chqꞌonte. ");
INSERT INTO mamC_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Qa ma tzꞌel kynikyꞌa te tkyaqiljo lo, ex qa ma kubꞌ kybꞌinchiꞌn ikyjo, at tkyꞌiwbꞌil Dios kyibꞌaja te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mi nchin yoliꞌn kyiꞌja kykyaqila. Quꞌn ojtzqiꞌn wuꞌn ankye qe o chi jaw nskꞌoꞌn. Me ilxix tiꞌj tuꞌn tbꞌajjo tzeꞌnku ntqꞌmaꞌn toj Tuꞌjil Tyol Dios: Ankye jun nwaꞌn wukꞌiy, kjawil meltzꞌaj wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nxi nqꞌmanjiꞌy luꞌn kyeꞌy, a naꞌmxtaq tbꞌaj, tuꞌntzin aj tbꞌajjo ikyjo, kxel kynimin qa ayin wejiꞌy junx nteꞌn tukꞌa nMaꞌn, a loqin nchin yoliꞌn kyukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Twutzxix kxel nqꞌmaꞌn kyeꞌy: Ankye te kxel kꞌmoꞌn teꞌ a kxel nchqꞌoꞌn, ayiꞌn chin xel tkꞌmoꞌn. Ex ankye te kxel kꞌmoꞌn weꞌy, a nMaꞌn kxel tkꞌmoꞌn, a tzaj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tbꞌajlinxiꞌ tqꞌmaꞌn Jesús tkyaqiljo lo, tzaj chyoꞌn tanmin tuꞌn tbꞌis, ex tzaj tqꞌmaꞌn qeꞌy: Twutzxix kxel nqꞌmaꞌn kyeꞌy. At jun kyeꞌ k-okil meltzꞌaj wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Me awotzin qeꞌ, a awoꞌy t-xnaqꞌtzbꞌin noqx o jaw kaꞌylaja toj qwutza, ex mix ele qnikyꞌa te alqiꞌj nyolinetaq. ");
INSERT INTO mamC_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Me ayintaq weꞌ intiꞌn antza, nchin waꞌntaqa ttxlaj Jesús. Nimx tqꞌaqꞌbꞌil tkꞌuꞌj wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tuꞌnpetziꞌn, xi tyekꞌin Simun Pegr tqꞌobꞌ te jun techil, tuꞌn t-xi nqaniꞌn te Jesús alqiꞌj nyolineꞌtaq. ");
INSERT INTO mamC_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tuꞌnpetziꞌn, in xi laqꞌexixa tkꞌatz, ex xi nqaniꞌn te: WAjaw, ¿Altzila kye? ");
INSERT INTO mamC_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tzaj ttzaqꞌwin Jesús: Kꞌwelix wakꞌsin chꞌin pan, ex anqe kxel nqꞌoniꞌy, atziꞌn. Ikytziꞌn, kux takꞌsin jun piẍ pan toj laq, exsin xi tqꞌoꞌn te Judas Iscariot, a tkꞌwal Simun. ");
INSERT INTO mamC_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tbꞌajlinxiꞌ twaꞌn Judas, bꞌeꞌx okx tajaw il toj tanmin. Tuꞌnpetziꞌn, xi tqꞌmaꞌn Jesús te: Atzin tuꞌn tkubꞌ tbꞌinchiꞌn, bꞌinchinkutziꞌn jaꞌlinxix. ");
INSERT INTO mamC_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Me nipe tuꞌn ikyjo, mix ele qnikyꞌa te, tiquꞌn xi tqꞌmaꞌn ikyjo. ");
INSERT INTO mamC_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Quꞌn ataq Judas qꞌilte chꞌuꞌẍ tkꞌwel pwaq, at junjunqe kubꞌ ximinte, qa xi tqꞌmaꞌn tuꞌntaq txiꞌ Judas laqꞌolte chꞌin qwaꞌy tuꞌn tajbꞌin toj nintz qꞌij, moj qa tuꞌn t-xiꞌ qꞌol chꞌin pwaq kye tal yaj. ");
INSERT INTO mamC_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tbꞌajlinxiꞌ twaꞌn Judas pan, bꞌeꞌx ex toj qnikyꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Telintzxi Judas, tzaj tqꞌmaꞌnl Jesús qeꞌy, awoꞌy t-xnaqꞌtzbꞌin: Chꞌix nkyim weꞌ jaꞌlin, a ayiꞌn Tkꞌwal Ichin, tuꞌntzin tnimsit tbꞌi nMan Dios. ");
INSERT INTO mamC_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma japin bꞌaj tajbꞌil nMaꞌn wuꞌn tzaluꞌn twutz txꞌotxꞌ, noq tuꞌn tnimsit tbꞌi. Tuꞌnpetziꞌn, ktzajil tqꞌoꞌn wokliꞌn liwey, tuꞌn nteꞌn tukꞌa toj kyaꞌj tukꞌa tkyaqil nqoptzꞌajiyila. ");
INSERT INTO mamC_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nimxix tqꞌaqꞌbꞌil nkꞌuꞌja kyiꞌja. Nya nim tqan chin tenbꞌiltla kyukꞌiy jaꞌlin. Ok chi jyola wiꞌja, me ikytziꞌn tzeꞌnku xi nqꞌmaꞌn kye aj Judiy, ex kxel nqꞌmaꞌn kyeꞌy jaꞌlin, nlayx cheꞌxa jaꞌ kchin xeliy. ");
INSERT INTO mamC_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tuꞌnpetziꞌn, kxel nqꞌoꞌn jun akꞌaj nukꞌbꞌil kyeꞌy: Tuꞌn kykꞌuꞌjlin te kyibꞌa jun tukꞌa juntl, ikytziꞌn tzeꞌnku ma chi ok nkꞌuꞌjliꞌn. Ikytzin kyejiꞌy, kykꞌuꞌjlink kyibꞌa kyxolxa. ");
INSERT INTO mamC_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Qa ma tzꞌok kykꞌuꞌjliꞌn kyibꞌa kyxolxa, kykyaqilx xjal k-elil kynikyꞌ kyiꞌja, qa nxnaqꞌtzbꞌinqiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Xi tqanin Simun Pegr te Jesús: WAjaw, ¿Jaꞌtzin kxela te? Xi ttzaqꞌwin Jesús: A jaꞌ kchin xeliꞌy, nlayx txi lipey wiꞌja jaꞌlinxix, me ok kxel lipey wiꞌja yajxi chꞌintl. ");
INSERT INTO mamC_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Me ante Pegr xi tqꞌmaꞌn: WAjaw, ¿Tiquꞌnil nlay chinx lipeꞌy tiꞌja jaꞌlin? ¿Ma nyatzin ma bꞌant weꞌ nteꞌn tuꞌn t-xi nqꞌoꞌn nchwinqila, tuꞌn nkyima tuꞌn tpaja? ");
INSERT INTO mamC_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Xi ttzaqꞌwin Jesús: ¿Ma ax twutz, ma bꞌant te tteꞌn tuꞌn tkyima tuꞌn npaja? Me twutzxix kxel nqꞌmaꞌn tey, qa naꞌmxtaq toqꞌ tman ekyꞌ, kchin kꞌwel tewiꞌn oxe maj kywutzxjal, ex kxel tqꞌmaꞌn, qa nya ojtzqiꞌnqiꞌn tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Mina chi jaw bꞌisiꞌn. Qe kykꞌuꞌja tiꞌj Dios, ex qe kykꞌuꞌja wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Quꞌn toj tja nMaꞌn at nimku najbꞌil, jaꞌ tuꞌn qnajane; noqit ntiꞌ, matla txi nqꞌmaꞌn kyeꞌy. Tuꞌnpetziꞌn, ma chinka bꞌinchil jun kynajbꞌila. ");
INSERT INTO mamC_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ex nya noq oꞌkx tuꞌn ma chinka bꞌinchilte kynajbꞌila; qalaꞌ ok chin ula juntl majl kꞌlel kyeꞌy, tuꞌntzin kyteꞌn junx wukꞌiy te jun majx toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ex ojtzqiꞌn bꞌe kyuꞌn, jaꞌ kchin xeliꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Xi tqꞌmaꞌn Tmas te Jesús: Ay wAjaw, mi bꞌiꞌn qe quꞌn jaꞌ kxeliy, ¿Tzeꞌntzin ttentz tuꞌn tel qnikyꞌa tiꞌjjo bꞌe? ");
INSERT INTO mamC_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Xi ttzaqꞌwin Jesús: Ayin wejiꞌy Bꞌe, ex ayin wejiꞌy Twutzxix, ex ayiꞌn wejiꞌy Chwinqil. Quꞌn noq wuꞌn aku chi kaninxjal tkꞌatz nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Qa ma tzꞌel kynikyꞌa wiꞌja, ex ok k-elil kynikyꞌa tiꞌj nMaꞌn. Ex ma tzꞌel kynikyꞌa tiꞌj jaꞌlin, quꞌn kukx nchin ok kykaꞌyinjiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Lip: Ay wAjaw; yekꞌintzin Manbꞌaj qeꞌy. Tukꞌaxjo lo, bꞌeꞌxpen k-elil qnikyꞌtza te. ");
INSERT INTO mamC_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Xi ttzaqꞌwin Jesús: Ay Lip, ¿Jtojetziꞌn nkubꞌlin ten kyukꞌiy, ex naꞌmx tel tnikyꞌa weꞌy? Quꞌn alkye ma tzꞌok kaꞌyin weꞌy, ma tzꞌok tkaꞌyin nMaꞌn. Tuꞌnpetziꞌn, ¿Tiquꞌn tzaj tqaniꞌn weꞌy, tuꞌn t-xi nyekꞌiꞌn Manbꞌaj teꞌy? ");
INSERT INTO mamC_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ma miꞌtzin nxi tnimiꞌn, qa mujleqiꞌn tukꞌa nMaꞌn, ex mujle nMaꞌn wukꞌiy? Tuꞌnpetziꞌn, tkyaqiljo jniꞌ yol nxi nqꞌmaꞌn, nya wekuy, qalaꞌ te nMaꞌn, a najle wukꞌiy, ex aku n-aqꞌnin wukꞌiy tuꞌn tbꞌantjo jniꞌ tajbꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kyniminkuy qa ayiꞌn intin tukꞌa nMaꞌn, ex a nMaꞌn najle wukꞌiy. Exsin qa minatz, ¿Ma nlayxsiꞌn txi kynimiꞌn tuꞌn tkyaqilxjo nbꞌant wuꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ex twutzxix kxel nqꞌmaꞌn kyeꞌy, ankye te knimil wiꞌja ok kbꞌantil tkyaqil tuꞌn, tzeꞌnku nbꞌant wuꞌn, ex okpela kbꞌantil nimxixtl tuꞌn, tzeꞌnku nbꞌant jaꞌlin, quꞌn ma chinka tukꞌa nMaꞌn toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ikytziꞌn, tkyaqiljo kxel kyqaniꞌn tiꞌj tumil nbꞌiꞌy, ok kbꞌantil wuꞌn, tuꞌntzin t-xi nyekꞌiꞌn qa nimxix tbꞌi nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kꞌwel nbꞌinchiꞌn tiꞌchaqx txi kyqanintza tiꞌj tumil nbꞌiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ex xi tqꞌmaꞌnl Jesús: Qa ma chin ok kykꞌuꞌjliꞌn, kyniminkutzinjiꞌy jniꞌ nnukꞌbꞌila. ");
INSERT INTO mamC_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ex kchin kubꞌsin nwutza te qMan, tuꞌn ttzaj tchqꞌoꞌn juntl Onil kyeꞌy, ex Qꞌuqbꞌil kykꞌuꞌja, a Xewbꞌaj Xjan, a twutzxix, tuꞌn tten kyukꞌiy te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ayetzin xjal te twutz txꞌotxꞌ nlay txi kykꞌmoꞌn, quꞌn mi nchi jyoꞌn tiꞌj, ex mi n-el kynikyꞌ te. Me metzin kye, ma tzꞌel kye kynikyꞌ tiꞌj, quꞌn loqin intin kyxola jaꞌlin, ex ktzajil tqꞌoꞌn Dios toj kyanmiꞌn, tuꞌn tten te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nlay chi kyij ntzaqpiꞌn kye; qalaꞌ kchin ul meltzꞌaj weꞌ, tuꞌn nteꞌn kyukꞌiy te jun majx, noq tuꞌn Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nya ilaꞌ qꞌijl tuꞌn nkyima. Mi chin ok kykaꞌyintl xjala, me metzin kye, kchin okil kykaꞌyintla, aj ul nmeltzꞌaja kyukꞌiy, a otaq chin jaw anqꞌintla juntl majl kyxol kyimnin. Ex noq tuꞌn akꞌaj nchwinqila, ktenbꞌil kye kychwinqil a nlay bꞌaj, quꞌn itzꞌqin weꞌ te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aj tjapin kaniꞌn qꞌij anetziꞌn, apentza k-elile kye kynikyꞌ te qa twutzxixjo nyola, qa mujleqiꞌn tukꞌa nMaꞌn, ex qa mujleqiꞌy wukꞌiy, ex ayiꞌn kyukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ankye teꞌ ma tzꞌel tnikyꞌ te, ex kꞌwel tnimin jniꞌ nnukꞌbꞌila, antza k-elile tnikyꞌtzajil, qa twutzxix tzun nchin ok tkꞌuꞌjliꞌn. Ex ankye te nchin ok tkꞌuꞌjliꞌn, ex ate nMaꞌn k-okil kꞌuꞌjlinte, ex ikyx wejiꞌy kxel nyekꞌin teꞌ tkyaqil wajbꞌila. ");
INSERT INTO mamC_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tej t-xi tqꞌmaꞌn Jesús ikyjo, xi tqanin Judas te (a junxil Judas, nya Iscariot): Tata, ¿Tiquꞌn noq te qekuy ktzajil tyekꞌin tibꞌa, ex nya te kykyaqil xjal? ");
INSERT INTO mamC_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Xi ttzaqꞌwin Jesús: Ankye te nkꞌuꞌjlin weꞌy, ex nkubꞌ tbꞌiꞌn tkyaqiljo xi nqꞌmaꞌn, okpen k-okil kꞌuꞌjlin teꞌ tuꞌn nMaꞌn, ex ayin weꞌ tukꞌax nMaꞌn qo ul qeꞌ najal tukꞌa te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ex ankye teꞌ mi n-ok kꞌuꞌjlin weꞌy, ex mi nkubꞌ tbꞌiꞌn jniꞌ nnukꞌbꞌila, a xi nqꞌmaꞌn. Ex kykyaqiljo yol ncheꞌx nqꞌmaꞌn, nya wekuy, qalaꞌ te nMaꞌn, a tzaj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nxi nqꞌmaꞌn tkyaqiljo lo a loqiꞌn intinx kyukꞌiy tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Me atzin Xewbꞌaj Xjan, a ktzajil tchqꞌoꞌn nMaꞌn toj tumil nbꞌiꞌy te Onil kyeꞌy ex te Qꞌuqbꞌil kykꞌuꞌja, ok ktzajil t-xnaqꞌtzin tkyaqil, ex ktzajil tnaꞌn kyeꞌy tkyaqiljo o bꞌaj nqꞌmaꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kyjel nqꞌoꞌn jun etzbꞌil kyeꞌy, a nnukꞌbꞌila toj kyanmiꞌn. Me nya ikyjo tzeꞌnku nukꞌbꞌil te twutz txꞌotxꞌ, a njapin bꞌaj liwey. Ikytziꞌn, mi jaw tukꞌpaj kyanmiꞌn, ex mi chi tzaj xobꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ma tzꞌok kybꞌiꞌn weꞌy, tej t-xi nqꞌmaꞌn, qa ma chinka, ex kchin ul meltzꞌaja tuꞌn nteꞌn kyukꞌiy juntl majl. Noqit qa twutzx kꞌuꞌjlinqiꞌn kyuꞌn, matla chi jaw tzalaja, aj kybꞌintiꞌy qa ma chiꞌn tukꞌa nMaꞌn, quꞌn ate nimxixtl toklin nwutza. ");
INSERT INTO mamC_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ma txi nnejsinjiꞌy tqanil kyeꞌy lo, quꞌn tuꞌntzin aj tjapin, okpin kxel kynimintza qa twutzxjo o bꞌaj nqꞌmaꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nya nimtl tqan tuꞌn nyoliꞌn kyukꞌiy, quꞌn chꞌix tul kanin tajaw il, a kawil tzaluꞌn twutz txꞌotxꞌ, bꞌinchil tajbꞌil wiꞌja, exla qa ntiꞌ toklin tuꞌn tkubꞌ wiꞌja tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Me ok kbꞌajiljo ikyjo tuꞌn nkyima, tuꞌn tel kynikyꞌxjal te, qa kꞌuꞌjlin nMaꞌn wuꞌn, ex nkubꞌ nbꞌinchiꞌn tkyaqiljo ntzaj tqꞌmaꞌn weꞌy. ¡Kujqexa! ¡Qo ikyꞌ tzaluꞌn! ");
INSERT INTO mamC_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Tbꞌajlinxiꞌ ikyjo, tzaj tqꞌmaꞌn Jesús qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin: Ayin weꞌ tzeꞌnku jun tqan uv twutzxix, ex atzin nMaꞌn tzeꞌnku jun aqꞌnil tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","N-el ttxꞌemin tkyaqiljo tqꞌobꞌ, a ntiꞌ twutz n-el. Ex tkyaqiljo tqꞌobꞌ, a at twutz n-el, k-elitz ttxꞌemin jniꞌ ttzqijlin kyxolile, tuꞌntzin twutzin nimxix. ");
INSERT INTO mamC_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Me atzin kye ma chi saqixa tuꞌn nxnaqꞌtzbꞌila ẍi ex nqꞌoꞌn, ikyxjo tzeꞌnku jun tqꞌobꞌ lobꞌj ma tzꞌel bꞌaj tzqijlin. ");
INSERT INTO mamC_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ikytzin kyejiꞌy, kukx kymujbꞌin kyibꞌjiꞌy wukꞌiy tzeꞌnku weꞌ kukx nmujbꞌin wibꞌjiꞌy kyukꞌiy. Quꞌn jun tqꞌobꞌ tze, nlay tzꞌel twutz tuꞌnx tibꞌx, a qa nya mujlek tiꞌjjo tqan. Ikytzin kyejiꞌy, nlayx tzꞌelx kye kywutz toj kychwinqila, qa nya mujleqeka wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ayin weꞌ tqan uv; ayetzin kye tqꞌobꞌ. Ankye te mujlek wiꞌja, ex mujleqinka tukꞌa, nimxpen teꞌ twutz n-el. Quꞌn ntiꞌx kye aku bꞌant kyuꞌn kyjunalxa. ");
INSERT INTO mamC_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ankye te tkyꞌeꞌ tuꞌn tok tmujbꞌin tibꞌ wukꞌiy, okpin k-elix xoyit teꞌ, tuꞌn ttzqij kyukꞌa txqantl tqꞌobꞌ tze, a tzqij tuꞌn kyxi chmet, ex tuꞌn kytzꞌeꞌy tuꞌn qꞌaqꞌ te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Qa kukx kymujbꞌin kyibꞌjiꞌy wukꞌiy, ex qa mi s-el najjo nxnaqꞌtzbꞌiꞌn toj kykꞌuꞌja, kyqanintza noq alkye kyaja, ex ok ktzajil qꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Qa nimxix kywutza s-el te nimsbꞌil tbꞌi nMaꞌn, antza k-elile tnikyꞌtzajil qa twutzxix nxnaqꞌtzbꞌinqiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tzun nchi ok nkꞌuꞌjlin kyeꞌ, ikytziꞌn tzeꞌnku te nMaꞌn nchin ok tkꞌuꞌjliꞌn. Kukx chi lipekjiꞌy tiꞌjjo tqꞌaqꞌbꞌil nkꞌuꞌja, a at kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Qa ma kubꞌ kyniminjiꞌy jniꞌ nnukꞌbꞌila, okpin kchi okil lipetza tiꞌjjo tqꞌaqꞌbꞌil nkꞌuꞌja, a at kyiꞌja, ikytziꞌn tzeꞌnku weꞌ nkubꞌ nniminjiꞌy tnukꞌbꞌil nMaꞌn, ex loqin lipcheqink tiꞌjjo tqꞌaqꞌbꞌil tkꞌuꞌj, a at wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nxi nyoliꞌn ikyjo, tuꞌntzin kyjaw tzalaja wukꞌiy, ex tuꞌntzin kynoja tuꞌn ntzaljbꞌila. ");
INSERT INTO mamC_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Atzin nnukꞌbꞌiljiꞌy lo, tuꞌn kykꞌuꞌjlin te kyibꞌa kyxolxa, tzeꞌnku we nchi ok nkꞌuꞌjliꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ex ante qkꞌuꞌjbꞌiljo nimxix toklin, tuꞌn t-xi qqꞌoꞌn qchwinqil noq tuꞌn tpaj qukꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Me ayetzin kye ma chi oka te wukꞌiy, qa ma kubꞌ kybꞌinchiꞌn tzeꞌnkuxjo ma txi nqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi chi ok nqꞌoꞌnl kye jaꞌlin te waqꞌnila, quꞌn mi bꞌinte aqꞌnil tuꞌn, tiꞌ kꞌwel tbꞌinchin tajaw aqꞌuntl. Qalaꞌ kchi okil nqꞌolbꞌin kye te wukꞌiy, quꞌn ma txi nyekꞌiꞌn kyeꞌy kykyaqiljo ma tzaj tqꞌmaꞌn nMaꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Quꞌn nyaqe kyeꞌ ẍi jaw skꞌoꞌn weꞌy; qalaꞌ ayin weꞌ ẍin jaw skꞌoꞌn kyeꞌy. Tuꞌnpetziꞌn, kxel woqxenin kyeꞌy, tuꞌn kyxiꞌy, ex tuꞌn tel kywutza nimxix toj kychwinqila, ex atzin kywutza, tuꞌn tten te jun majx. Ikytziꞌn, ktzajile tqꞌoꞌn nManjiꞌy tkyaqiljo kxel kyqaniꞌn toj tumil nbꞌiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Atzin kxel nqꞌmanjiꞌy juntl majl kyeꞌy, tuꞌn kykꞌuꞌjlin te kyibꞌa kyxolxa. ");
INSERT INTO mamC_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ex tzaj tqꞌmaꞌnl Jesús qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin: Qa ma chi el ikyꞌiꞌn kyuꞌnxjal tzaluꞌn twutz txꞌotxꞌ, bꞌiꞌnku kyuꞌn qa ayiꞌn nej ma chin el kyikyꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Noqit iteꞌkuxa toj il, matla chi ok kꞌuꞌjliꞌn kyuꞌn txqantl, tzeꞌnkuxjo n-ok kykꞌuꞌjlinxjal kyibꞌ kyxolx. Me noq tuꞌn ayiꞌn ẍin jaw skꞌoꞌn kyeꞌy kyxolxjal tzaluꞌn twutz txꞌotxꞌ. Tuꞌnpetziꞌn, kchi elil ikyꞌin kyuꞌn, quꞌn nyatza iteyiy kyxol. ");
INSERT INTO mamC_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mi tzꞌel najx toj kykꞌuꞌja, a xi nqꞌmaꞌn kyeꞌy: Mix aꞌl jun te aqꞌnil nimx toklin tzeꞌnku te tajaw aqꞌuntl. Quꞌn qa ma chi ok lipinxjal wiꞌja, ex ikyx kyejiꞌy, kchi okil lipin kyiꞌja. Me qa ma kubꞌ kynimiꞌn nxnaqꞌtzbꞌila, ex ikyxjo kye, ok kꞌwel kybꞌiꞌn kyxnaqꞌtzbꞌila. ");
INSERT INTO mamC_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tkyaqiljo luꞌn k-okil kybꞌinchin kyiꞌja noq tuꞌn npaja, quꞌn mi ojtzqiꞌn a saj chqꞌoꞌn weꞌy kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ntiꞌtla kypajxjal noqit mi ẍin ula qꞌmalte kye qa at kyil. Me tuꞌn ma chin ula qꞌmalte Tbꞌanil Tqanil kye, ntiꞌ kykolbꞌil kyibꞌ tiꞌjjo kyil. ");
INSERT INTO mamC_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ex noq tuꞌn nchin el kyikyꞌiꞌn, nyekꞌin qa n-el kyikyꞌin nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ex ntiꞌxitla kypaj, noqit ntiꞌx jun tiꞌ ma bꞌant wuꞌn kyxol, a mix aꞌl juntl aku bꞌant tuꞌn. Me exla qa ma kyli tkyaqiljo xbꞌant wuꞌn, me n-ok tilil kyuꞌn tuꞌn wel kyikyꞌiꞌn, ex ma tzꞌel kyikyꞌin nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Me ma bꞌajjo ikyjo noq tuꞌn tjapiꞌn a yol tzꞌibꞌin tojjo Tuꞌjil Tyol Dios, a bꞌiꞌn kyuꞌn, tej tqꞌma: Kchin elil kyikyꞌin noq kukxjoch. ");
INSERT INTO mamC_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Me ajtzin tuljo Xewbꞌaj Xjan, a Onil, ex Qꞌuqbꞌil kykꞌuꞌja, ktzajil tqꞌmaꞌnjo twutzxix wiꞌja, quꞌn tkꞌatz Dios ktzajile. ");
INSERT INTO mamC_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ex ikyx kyejiꞌy, kchi yolil kyeꞌ twutzxix wiꞌja, quꞌn o chi teꞌn wukꞌiy atxix tej saj xkye. ");
INSERT INTO mamC_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Tkyaqiljo nbꞌaj xi nqꞌmaꞌn kyeꞌy, tuꞌn mi chi numja toj kynimbꞌila wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Quꞌn kchi elitz lajoꞌn kyojjo ja te naꞌbꞌl Dios. Expe tzul kanin jun qꞌij, tuꞌn kykubꞌ bꞌyoꞌn kyuꞌn, quꞌn toj kywutz nyakuj nchi ajbꞌin te Dios tuꞌn ikyjo. ");
INSERT INTO mamC_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ok kꞌwel kybꞌinchiꞌn ikyjo, quꞌn mi ojtzqiꞌnqiꞌn kyuꞌn, ex mi ojtzqiꞌn nMaꞌn kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Xi nqꞌmanjiꞌy luꞌn, tuꞌntzin aj tkaniꞌn tqꞌijil, tzul julkꞌaj toj kykꞌuꞌja, qa otaq bꞌaj nqꞌmaꞌn kyeꞌy ikyjo. Mix kubꞌe nqꞌmanjiꞌy luꞌn ojtxe, quꞌn intinxtaqa kyukꞌiy chewsil kykꞌuꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Me atziꞌn jaꞌlin, ma chinka, tuꞌntzin nteꞌn tukꞌa a saj chqꞌoꞌn weꞌy. Ex mix aꞌl jun kye ntzaj qaninte weꞌy, jaꞌ ma chinkiy. ");
INSERT INTO mamC_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Qalaꞌ noqx ma chi jaw bꞌisiꞌn tuꞌn xi nqꞌmaꞌn tkyaqiljo luꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Me twutzxixjo ma txi nqꞌmaꞌn kyeꞌy, qa wenxix te kyeꞌy tuꞌn nxiꞌy, quꞌn qa mi ẍinka, nlay tzuljo Xewbꞌaj Xjan onil kyeꞌy, ex qꞌuqbꞌil kykꞌuꞌja. Me aj qa ma chinka, ok ktzajil nchqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ajtzin tkꞌuꞌl, kꞌwel tiꞌj kynabꞌlxjal tuꞌn, qa aj ilqe, ex qa at jun tumil tuꞌn kyokxjal tzꞌaqle, ex qa kykyaqilxjal il tiꞌj tuꞌn kyok toj paꞌbꞌin twutz Dios. ");
INSERT INTO mamC_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Quꞌn aj ilqe kyexjal, noq tuꞌn mi ẍinx kynimin. ");
INSERT INTO mamC_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ex k-elil kynikyꞌ tiꞌjjo tumil tuꞌn kyokxjal tzꞌaqle, noq tuꞌn aj waja tkꞌatz nMaꞌn. Exla qa mi ẍin ok kykaꞌyintla, me aj njaw anqꞌiꞌn kyxol kyimnin, k-okil te jun yekꞌbꞌil, qa ayin weꞌ tzꞌaqlexix. ");
INSERT INTO mamC_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ex k-elil kynikyꞌ tiꞌjjo kujxix tkawbꞌil Dios, quꞌn otaq kubꞌ tiꞌj tajaw il wuꞌn, a nkawin tzaluꞌn twutz txꞌotxꞌ, ex kxeꞌl toj najin te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Atx nimxku tuꞌn t-xi nqꞌmaꞌn kyeꞌy, me nlay tzꞌel kynikyꞌa te jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Me aj tul Xewbꞌaj Xjan, ok ktzajil t-xnaqꞌtzin kyeꞌy kykyaqiljo a twutzxix, quꞌn nlay yolin tuꞌnx tibꞌx; qalaꞌ oꞌkx ktzajil tqꞌmaꞌn kykyaqiljo n-ok tbꞌiꞌn weꞌy. Atziꞌn ktzajil tqꞌman kyeꞌy tiꞌ kbꞌajil. ");
INSERT INTO mamC_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ex ok chin jawil nimsiꞌn tuꞌn, quꞌn kxel tkꞌmoꞌn tkyaqiljo at weꞌy toj kyaꞌj, ex atzin ok kꞌwel tchikyꞌbꞌiꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Quꞌn tkyaqiljo at te nMaꞌn, ex we wejiꞌy. Tuꞌnpetziꞌn xi nqꞌmaꞌn, qa a Xewbꞌaj Xjan kxel tkꞌmoꞌn a at weꞌy, tuꞌn t-xi tchikyꞌbꞌin kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ex xi tqꞌmaꞌnl Jesús qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin: Noq te jun paqkutl, mi chin ok kykaꞌyintla, quꞌn ma chin aj we jaꞌ taꞌ nMaꞌn; me yajxi chꞌintl, ok chin okil kykaꞌyintla. ");
INSERT INTO mamC_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tuꞌnpetziꞌn, attaq junjun qxola i bꞌaj jaw qanlaj kyxolx: ¿Tzeꞌntzila tzꞌeleꞌ ikyjo, a ntzaj tqꞌmaꞌn qe: Noq te jun paqkutl, mi qlitl, ex yajxi chꞌintl, k-okil qkaꞌyintl? ¿Ex tiꞌtziꞌn xtqꞌma qe, a ma chin aj we, jaꞌ taꞌ nMaꞌnch? ");
INSERT INTO mamC_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Me ok tentl qe labꞌtil, ex qqꞌmaꞌy: ¿Tzeꞌnxsila tzꞌelpineꞌ, noq te jun paqkutl? qo chijiꞌy. Nlayx tzꞌelx qnikyꞌ te tiꞌ qiꞌjil nyoline. ");
INSERT INTO mamC_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Bꞌeꞌx el tnikyꞌ Jesús te, qa qajtaqa tuꞌn txi qqaniꞌn te tiꞌj tkyaqiljo luꞌn. Tuꞌnpetziꞌn, tzaj tqꞌmaꞌn: ¿Ma tzuntzin nchi labꞌtiꞌy tiꞌjjo yol, a xi nqꞌmaꞌn, qa noq te jun paqkutl, mi chin ok kykaꞌyintla, ex yajxi chꞌintl kchin okil kykaꞌyintla? ");
INSERT INTO mamC_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Twutzxix kxel nqꞌmaꞌn kyeꞌy, qa kchi oqꞌila, ex kchi bꞌisila. Me ante jniꞌ xjal te twutz txꞌotxꞌ okxla kchi tzalajilx. Me metziꞌn kyeꞌ, exla qa kchi bꞌisila jaꞌlin, me atzin kybꞌisa ktxꞌixpitil te tzaljbꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ikytziꞌn tzeꞌnku jun qya, aj tjapin tqꞌij tuꞌn titzꞌje tal, tzun njaw bꞌisin tuꞌn tkyixkꞌojil. Me titzꞌjlinxi neꞌẍ, bꞌeꞌx el najjo kyixkꞌoj toj tkꞌuꞌj, tuꞌn ttzaljbꞌil tiꞌjjo tal, a otaq tzꞌitzꞌje tzaluꞌn twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ikytzin kyejiꞌy jaꞌlin, chi jawil bꞌisiꞌn; me chin ultla lol kyeꞌy juntl majl. Bꞌeꞌxpen knojil kyanmintza tukꞌa tzaljbꞌil, a mix aꞌlx aku tzꞌel qꞌinte. ");
INSERT INTO mamC_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tojtziꞌn qꞌij anetziꞌn, mi tzaj kyqanintla jun tiꞌ weꞌy, qalaꞌ teku nMaꞌn kxele kyqaniꞌn. Ex ok ktzajil tqꞌoꞌn tkyaqiljo ok kxel kyqaniꞌn toj tumil nbꞌiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tzmax tzaluꞌn, ntiꞌ jun tiꞌ o txi kyqaniꞌn noq toj tumil nbꞌiꞌy. Me atziꞌn jaꞌlin, kyqaninxa, ex ok ktzajil tqꞌoꞌn, tuꞌntzin kynoja tukꞌa tzaljbꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ma txi nqꞌmaꞌn tkyaqiljo luꞌn kyeꞌy, noq kyuꞌnjo techil. Me tojjo qꞌij anetziꞌn, mi chin yolintla kyukꞌa techil; qalaꞌ ayinkuxixa chin xel nikꞌunte kyeꞌy tiꞌjjo nMaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tojjo qꞌij anetziꞌn, kxel kyqaniꞌn jun tiꞌ toj tumil nbꞌiꞌy, me nya il tiꞌj tuꞌn nkubꞌsin nwutza te nMaꞌn, tuꞌn t-xi tqꞌoꞌn kyeꞌy, ");
INSERT INTO mamC_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","quꞌn axte nMaꞌn kꞌuꞌjlil kyeꞌy, noq tuꞌn nchin ok kykꞌuꞌjliꞌn, ex ma txi kynimiꞌn qa tukꞌa Dios ma chin tzajiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Quꞌn antza ẍin etziy tukꞌa nMaꞌn, ex ma chin ula tzaluꞌn twutz txꞌotxꞌ. Atziꞌn jaꞌlin, kyjel ntzaqpiꞌn twutz txꞌotxꞌ, tuꞌn waj meltzꞌajla tkꞌatz nMaꞌn toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tuꞌnpetziꞌn, xi qqꞌmaꞌn awoꞌy t-xnaqtzbꞌin te: Bꞌapetzintz jaꞌlin. Akupetzintza ma tzaj nikꞌunte qeꞌy, ex nya tukꞌa techil. ");
INSERT INTO mamC_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","¿Mapen tzꞌel qnikyꞌtza te jaꞌlin, qa ntiꞌ jun tiꞌ mi n-el tnikyꞌa te, ex nyapen il tiꞌjtz tuꞌn ttzaj tqꞌmaꞌn jun aꞌla jun tumil teꞌy? Atziꞌn jaꞌlin, ma tzꞌel qnikyꞌa te, qa tukꞌa Dios sajiy. ");
INSERT INTO mamC_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tzaj ttzaqꞌwin Jesús: Tuꞌnpetziꞌn, ¿Ma man txi kynimintza? ");
INSERT INTO mamC_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Me kxel nqꞌmaꞌn kyeꞌy, atzin qꞌijjo jaꞌlin, a tuꞌn kybꞌajel tilje, ex teyile junjun kxel tiꞌn tbꞌe, ex chin kyjel kytzaqpiꞌn njunalxa. Me nya njunalxa chin kyjel, quꞌn ajin nMaꞌn kukx atjo wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tkyaqilxjo lo ma txi nqꞌmaꞌn kyeꞌy, tuꞌntzin tknetjo nukꞌbꞌil kyuꞌn. Tzaluꞌn twutz txꞌotxꞌ nimx kkyꞌelix kyuꞌn. Me kyintz kyipiꞌn, quꞌn ma kubꞌ tiꞌj tkyaqiljo twutz txꞌotxꞌ wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tbꞌajlinxitzin tyolin Jesúsjo ikyjo, jaw kaꞌyin twutz kyaꞌj, ex tqꞌma: Tata, ma pon nqꞌijila tuꞌn nkyima: Nimsinksa nbꞌiꞌy toj nkyimliꞌn, ayiꞌn Tkꞌwala, tuꞌntzin tjaw nnimsiꞌn tbꞌiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Quꞌn ma tzaj tqꞌoꞌn wokliꞌn, ayiꞌn Tkꞌwala, tibꞌaj tkyaqilxjal, tuꞌn t-xi nqꞌoꞌn kychwinqil te jun majx kykyaqilxjo, a ma chi tzaj tqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ex atzin chwinqiljo, tuꞌn tel kynikyꞌxjal teꞌy, qa akuy Dios twutzxix, ex tuꞌn tel kynikyꞌ weꞌy, ayiꞌn Jesucrist, a saj tchqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma jaw nnimsiꞌn tbꞌiꞌy tzaluꞌn twutz txꞌotxꞌ, noq tuꞌn xkubꞌ nbꞌinchiꞌn tkyaqiljo ẍin tzaj tchqꞌoꞌn bꞌinchilte. ");
INSERT INTO mamC_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Atziꞌn jaꞌlin, chꞌix nmeltzꞌaja tukꞌiy toj kyaꞌj. Qꞌontziꞌn wokliꞌn tkꞌatza, tzeꞌnkuxjo wokliꞌn, a attaq tukꞌiy atxix te tnejil. ");
INSERT INTO mamC_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ex ayetziꞌn ẍi etz tiꞌn kyxolxjal tzaluꞌn twutz txꞌotxꞌ, tuꞌn kytzaj tqꞌoꞌn weꞌy, ma kubꞌ nchikyꞌbꞌiꞌn kywutz, ankye te. Ex teqetaqa, me ma chi tzaj tqꞌoꞌn weꞌy, ex ma kubꞌ kynimiꞌn Tyola. ");
INSERT INTO mamC_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Atzin jaꞌlin, ma kybꞌi qa tkyaqiljo ma tzaj tqꞌoꞌn weꞌy tukꞌiy ntzaja. ");
INSERT INTO mamC_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Quꞌn ma txi nqꞌonjiꞌy tqanil, a saj tqꞌoꞌn weꞌy, ex ma txi kynimin, ex ma tzꞌel kynikyꞌ te, qa twutzxix tukꞌiy ẍin tzajiꞌy, ex qa ay saj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nchin kubꞌsin nwutza teꞌy kyiꞌj, ex nya kyiꞌj kykyaqilxjal twutz txꞌotxꞌ; qalaꞌ noq kyiꞌjjo ma chi tzaj tqꞌoꞌn weꞌy, quꞌn teqiy. ");
INSERT INTO mamC_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tkyaqiljo at weꞌy, te tejiy; ex tkyaqil at teꞌy, we wejiꞌy. Ex ma jaw nimsiꞌn nbꞌiy tzaluꞌn twutz txꞌotxꞌ noq tuꞌn ikyjo. ");
INSERT INTO mamC_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi chin kyij teꞌn weꞌ tzaluꞌn twutz txꞌotxꞌ, me metzin kyetz axsa chi kyjele tene tzaluꞌn. Me metzin weꞌ, ma chin aj weꞌ, tuꞌn nteꞌn tukꞌiy. Ay Tata xjanxix, tuꞌnpetziꞌn, klomqetziꞌn tukꞌa tkyaqil tipiꞌn, a aye ẍi tzaj tqꞌoꞌn weꞌy, tuꞌntzintla kukx kymujbꞌin kyibꞌjo tzeꞌnku qe tukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Quꞌn atziꞌn intintaqa kyukꞌa tzaluꞌn twutz txꞌotxꞌ; tzuntaq nchi ok nxqꞌuqiꞌn, ex nchi el nkloꞌn tukꞌa tipiꞌn, kykyaqiljo ma chi tzaj tqꞌoꞌn weꞌy. Ex noq junchꞌin ma tzꞌel naj, me noq tuꞌn tjapin bꞌajjo tzꞌibꞌin toj Tuꞌjil Tyola. ");
INSERT INTO mamC_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Atzin jaꞌlin, kyjaꞌ waja, a jaꞌ taꞌy. Ma txi nqꞌmanjiꞌy jniꞌ lo, a loqin intinx chꞌintl tzaluꞌn twutz txꞌotxꞌ, tuꞌntzintla kynoj tukꞌa tzaljbꞌil tzeꞌnku weꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ex ma txi nqꞌmaꞌn Tyola kye, tuꞌn t-xi kychikyꞌbꞌin. Me noq ma chi el ikyꞌin kyuꞌnxjal, quꞌn nya kyukꞌaxjal iteꞌye, tzeꞌnku weꞌ, nya te twutz txꞌotxꞌqin weꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi nxi nqaniꞌn teꞌy, tuꞌn kyel tiꞌn kyxoljo xjal bꞌinchil il tzaluꞌn twutz txꞌotxꞌ; qalaꞌ noq tuꞌn kyel tkloꞌn te tajaw il. ");
INSERT INTO mamC_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Quꞌn nya te twutz txꞌotxꞌqin weꞌ, ex ikyqex kyeꞌ, nya te twutz txꞌotxꞌqe. ");
INSERT INTO mamC_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xjansinqekuy tiꞌja tuꞌn Tyola toj kyanmin, tuꞌn kyokin teꞌy, quꞌn a Tyola twutzxix. ");
INSERT INTO mamC_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ikyxjo tzeꞌnku ma chin tzaj tchqꞌoꞌn kyxolxjal tzaluꞌn twutz txꞌotxꞌ, ex ikyx kchi xel nchqꞌonjiꞌy kyxolxjal qꞌmalte Tyola. ");
INSERT INTO mamC_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ex noq tuꞌn kypaj, ma tzꞌel npaꞌn we wibꞌ wuꞌnx wibꞌxa, tuꞌn wajbꞌiꞌn teꞌy; ikyxintla kyetz tuꞌn tel kypaꞌn kyibꞌ noq tuꞌn Tyola twutzxix, tuꞌn kyajbꞌin teꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nya noq kyiꞌj nxnaqꞌtzbꞌiꞌn nchin kubꞌsin nwutza teꞌy, qalaꞌ ikyxjo kyiꞌjjo kchi nimil kyuꞌn, aj t-xi kyqꞌmaꞌn Tbꞌanil Tqanil kye. ");
INSERT INTO mamC_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nchin kubꞌsin nwutza teꞌy, tuꞌn kytzaj tmojiꞌn, tuꞌntzintla junx kyanmin toj tkyaqil, ex junx kyteꞌn toj kymujbꞌil kyibꞌ qukꞌa, tzeꞌnku we mujle wibꞌa tukꞌiy, ex a te wukꞌiy. Nxi nqaninjiꞌy luꞌn teꞌy, tuꞌntzin tel kynikyꞌxjal te, qa ay saj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ma txi nqꞌoꞌn t-xilin tumila kye, ikyxjo tzeꞌnku ma tzaj tqꞌoꞌn weꞌy, tuꞌntzintla junx kyten tzeꞌnku qe, junx qten. ");
INSERT INTO mamC_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Noqit aku chi ten wukꞌiy, ex a te wukꞌiy, tuꞌntzintla kyok tzꞌaqle junx kykyaqil. Quꞌn ikytziꞌn k-elile kynikyꞌ xjaljo te, qa ay saj chqꞌoꞌn weꞌy, ex qa kꞌuꞌjlinqexix tuꞌn, tzeꞌnku kꞌuꞌjlinqiꞌn tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata, ma chi tzaj tqꞌoꞌn weꞌy, ex wajatlaꞌy tuꞌn kyten wukꞌiy, a jaꞌ kchin tenbꞌiliy, tuꞌn tok kykaꞌyiꞌn tqoptzꞌajiyil wokliꞌn, a otaq tzaj tqꞌoꞌn. Quꞌn nimxix o chin ok tkꞌuꞌjliꞌn, atxix te naꞌmtaq tbꞌant twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ay Tata tzꞌaqlexix, mi ojtzqiꞌn kyuꞌnxjal tzaluꞌn twutz txꞌotxꞌ; me metzin weꞌ wojtzqiꞌn te. Ex ayetziꞌn wukꞌiy ma tzꞌel kynikyꞌ te, qa ay saj chqꞌoꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma txi nyekꞌiꞌn kye ankye te. Ex kukx kxel nyekꞌinjiꞌy, tuꞌntzin a tqꞌaqꞌbꞌil tkꞌuꞌja at wukꞌiy ktenbꞌil kyukꞌa, ex ikyx wejiꞌy kchin tenbꞌila kyukꞌa te jun majx. ");
INSERT INTO mamC_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tej tbꞌaj naꞌn Jesús Dios, bꞌeꞌx o etza tukꞌa, tuꞌn qxiꞌy tjlajxi xlokꞌ aꞌ, Cedrón tbꞌi. Antza taꞌtaq jun chꞌlaj te awbꞌil tqan lobꞌj, jaꞌ o ok xiꞌy tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ex ikyx te Judasjo, a tuꞌntaq txi kꞌayinte Jesús, tojtzqiꞌntaql teꞌ, quꞌn ilaꞌku maj otaq tzꞌok qchmoꞌn qibꞌa antza. ");
INSERT INTO mamC_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tuꞌnpetziꞌn, kanin Judas tukꞌa jun chꞌuq xoꞌl qꞌaqꞌ, ex junjun xqꞌuqil tnejil ja te naꞌbꞌl Dios, a chqꞌoꞌnqe kyuꞌn kynejil pale exqetziꞌn Parisey; qꞌimile kytze, chꞌut twiꞌ, ex kymachet; ex qꞌimile kytzaj ex kykandil njulin wen. ");
INSERT INTO mamC_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Me ojtzqiꞌntaql te Jesús tuꞌn, tkyaqiljo tuꞌntaq tbꞌaj. Tuꞌnpetziꞌn, etz laqꞌe kꞌlulkye, ex xi tqanin kye: ¿Ankye nkyjyoꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ajin te Judas kyukꞌa, a otaq txi kꞌayinte. Tuꞌnpetziꞌn xi kytzaqꞌwin: A Jesús aj Nazaret, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Xi ttzaqꞌwin Jesús kye: ¡Ayin wejiꞌy! Jun paqx, bꞌaj xi pakꞌchaj kyiꞌjxi, ex i bꞌaj kubꞌ lankꞌaj twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Xi tqanin juntl majl Jesús kye: ¿Ankye nkyjyoꞌnch? Xi kytzaqꞌwin juntl majl: A Jesús aj Nazaret. ");
INSERT INTO mamC_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Xi tqꞌmaꞌntl Jesús kye: Ma txi nqꞌmaꞌn kyeꞌy, ¡Ayin wejiꞌy! Qa nchi jyoꞌn wiꞌja, tzaqpiꞌnqexjiy txqantl, tuꞌn kyaj. ");
INSERT INTO mamC_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","O bꞌajjo ikyjo, noq tuꞌn tjapiꞌn tyol Jesús, a akxtaq tbꞌaj tqꞌmaꞌn kyjaluꞌn: Kykyaqilxjo ma chi tzaj tqꞌoꞌn weꞌy, ntiꞌ jun ma naj. ");
INSERT INTO mamC_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Me ante Simun Pegr, qꞌiꞌntaq jun tmachet. Jatz tiꞌn, ex el ttxꞌemin tẍkyin jun taqꞌnil tnejil pale toj tman qꞌobꞌ. Ajo ichin luꞌn, Malco tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Me ante Jesús xi tqꞌmaꞌn te Pegr: Qꞌonkuxjiy tmacheta toj tja. ¿Ma miꞌtzin nxi tnimiꞌn, qa il tiꞌj tuꞌn tikyꞌx kyixkꞌoj wuꞌn, a ma bꞌant tiꞌj tuꞌn nMaꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tbꞌajlinxiꞌ ikyjo, aye xoꞌl qꞌaqꞌ tukꞌa kynejil, exqetziꞌn xqꞌuqil tnejil ja te naꞌbꞌl Dios, bꞌeꞌx ok kytzyuꞌn Jesús, tuꞌn tkuꞌx toj tze, ex kubꞌ kykꞌloꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ex jun paqx xi kyiꞌn tzma tja Anás. Ante Anás ttata t-xuꞌjil Caifás, a toktaq te tnejinel kypale aj Judiy tojjo abꞌqꞌe anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Axte Caifásjo lo, a otaq qꞌmante kye aj Judiy, qa wentaq kye tuꞌn tkyimtaq jun ichin te kyxel tkyaqil kyxjalil. ");
INSERT INTO mamC_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Tej tikyꞌ qꞌiꞌn Jesús, xi lipe Pegr tiꞌj junx wukꞌiy, a juntl t-xnaqꞌtzbꞌin Jesús. Ex ojtzqiꞌnqintaqa tuꞌn tnejil pale; bꞌeꞌx in okx tzaqpiꞌn tukꞌa Jesús tzma tuja. ");
INSERT INTO mamC_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Me ante Pegr axsa kyije ten tiꞌjxi tjpel ja. Tuꞌnpetziꞌn, bꞌeꞌx in etza, ex in yoliꞌn tukꞌa txin, a xqꞌuqil tjpel ja, ex okx nkꞌleꞌn Pegr tzma tuja. ");
INSERT INTO mamC_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Me ante txin, a xqꞌuqil tjpel ja, xi tqanin te Pegr: ¿Ma nyapela ajin jun t-xnaqꞌtzbꞌin xjal lo? Xi ttzaqꞌwin Pegr: Mina, nyaqin wejiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Me tuꞌn attaq nim cheꞌw; ayetzin aqꞌnil exqetziꞌn xqꞌuqil ja te naꞌbꞌl Dios otaq kubꞌ kykchoꞌn jun qꞌaqꞌ, ex waꞌlqetaq tiꞌj nchi bꞌaj xqꞌnentaq. Ex ikyxl te Pegrjo nxqꞌnentaql kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ex atziꞌn tnejilxix pale ok ten qanilte te Jesús, ankyeqe te t-xnaqꞌtzbꞌin ex tiꞌtzin xi t-xnaqꞌtzin kye. ");
INSERT INTO mamC_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Xi ttzaqꞌwin Jesús: O chin yolin weꞌ kywutz tkyaqilxjal, ex kukx o chin xnaqꞌtzinjiꞌy kyojjo muchꞌ ja te kynaꞌbꞌl Judiy Dios, ex toj tnejil tja qMan, jaꞌ nchi chmete aj Judiy. Tuꞌnpetziꞌn, ntiꞌx jun we tiꞌ o txi nqꞌmaꞌn toj ewajil. ");
INSERT INTO mamC_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tiquꞌn ntzaj tqaniꞌn weꞌy? Qaninxa kye, a o chi bꞌin wiꞌja. Ayetziꞌn kchi qꞌmal teꞌ tiꞌ o bꞌaj nxnaqtziꞌn, ex bꞌiꞌn kyuꞌn alkye o bꞌaj nqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Atzaj teꞌ tbꞌaj tqꞌmaꞌn Jesús ikyjo, attaq jun xqꞌuqil ja te naꞌbꞌl Dios antza, okx ttzꞌajchin toj twutz, ex xi tqꞌmaꞌn te: ¿Ma ikytzin ma txi ttzaqꞌwinjiy te tnejil pale? ");
INSERT INTO mamC_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Xi ttzaqꞌwin Jesús: Qa at jun yol xi nqꞌmaꞌn nya wen, qꞌmantza ankye nya wen. Mej qa twutzxjo nxi nqꞌmaꞌn ¿Tiquꞌn chin ok tbꞌyoꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kꞌloꞌnxtaql te Jesús, tej t-xi tsmaꞌn Anás Jesús twutz Caifás, a tnejil pale, quꞌn otaq kubꞌ kykꞌloꞌn, ex mix ele kytzaqpiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ex tzunxtaq xqꞌnen Pegr tiꞌj qꞌaqꞌ, xitzin kyqꞌmaꞌn juntl majl te: ¿Nyapela ajin te jun t-xnaqꞌtzbꞌin ichin lo? Kubꞌ tewin Pegr, ex xi tqꞌmaꞌn: Mina, nyaqin wejiꞌych. ");
INSERT INTO mamC_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tuꞌnpetziꞌn, xi tqanin jun aqꞌnil te tnejil pale, a attaq kylonte kyibꞌ tukꞌa ichin, a otaq tzꞌel txꞌemin tẍkyin tuꞌn Pegr: ¿Ma nyatzin o nliꞌy toj chꞌlaj te awbꞌil tqan lobꞌj tukꞌa? ");
INSERT INTO mamC_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ex kubꞌ tewin Pegr toj tox majin. Texjo paq anetziꞌn, jaw oqꞌ tman ekyꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Etz kyiꞌn Jesús toj tja Caifás, tuꞌn tkanin toj ja te kawbꞌil kye aj Rom. Ex chꞌixtaq qel sqix, ex ayetziꞌn aj Judiy mix i okxi tojjo ja te kawbꞌil, quꞌn noqit i okx, bꞌeꞌxitla ẍi tzꞌilix twutzjo kykawbꞌil, ex ntiꞌtla kyoklin tuꞌn kywaꞌn tiꞌjjo wabꞌj te Xjan Qꞌij, quꞌn toj kywutz, jun iljo tuꞌn kyten toj kyjaxjal nya Judiy. ");
INSERT INTO mamC_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tuꞌnpetziꞌn, bꞌeꞌx etz Pilat yolil kyukꞌa; ex xi tqꞌmaꞌn kye: ¿Ankye tiljo xjal lo toj kywutza? ");
INSERT INTO mamC_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Xi kytzaqꞌwin te: Noqit nya jun bꞌinchil il, mitla saj qiꞌn twutza. ");
INSERT INTO mamC_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Pilat kye: ¿Ma ntiꞌtzin kye kykawbꞌil? Kyimixa kyukꞌiy, ex kykawinkuy tzeꞌnkuxjo ntqꞌmaꞌn kykawbꞌila. Xi kytzaqꞌwin aj Judiy: Me ntiꞌ qe qoklin, awoꞌy aj Judiy, tuꞌn tkubꞌ qbꞌyoꞌn jun aꞌla. ");
INSERT INTO mamC_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ikytziꞌn, o japin bꞌajjo a otaq bꞌaj tqꞌmaꞌn Jesús, qa iltaq tiꞌj tuꞌn tkyim twutz cruz, quꞌn ikytaqtzin tumiljo tuꞌn tkyim jun aj il toj kykawil aj Rom. ");
INSERT INTO mamC_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Okx juntl majl Pilat toj ja te kawbꞌil, ex okx ttxkoꞌn Jesús, ex xi tqanin te: ¿Atzin tejiy nmaq kawil kye aj Judiy? ");
INSERT INTO mamC_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Xi ttzaqꞌwin Jesús te: ¿Ma akutzin ma tzaj qanin te weꞌy, mo at juntlj ma qꞌmante tey ikyjo? ");
INSERT INTO mamC_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Xi ttzaqꞌwin Pilat te Jesús: ¿Mejqa aj Judiyqin weja tzeꞌnku kyeꞌ? A ayeku t-xjalila exqetziꞌn kynejil pale ma chi tzaj qꞌintiy nwutza. ¿Tiꞌtzin ma kubꞌ tbꞌinchiꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Xi ttzaqꞌwin Jesús te: Atziꞌn nkawbꞌila nya tzaluꞌn te twutz txꞌotxꞌ. Quꞌn noqit ikyjo, ayetzintla nxnaqꞌtzbꞌiꞌn matla chi qꞌojin, tuꞌn mi chin tzaj qꞌiniy kywutz aj Judiy; me tuꞌn nya te tzaluꞌn we nkawbꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tuꞌnpetziꞌn, xi ttzaqꞌwin Pilat: ¿Aj kawiltzin tetza toj twutza? Xi ttzaqꞌwin Jesús: Ayin weꞌ nmaq kawil tzeꞌnkuxjo ntqꞌmaꞌn. Quꞌn ma chin itzꞌje weꞌ tzaluꞌn twutz txꞌotxꞌ, tuꞌn t-xi nqꞌmanjiꞌy tkyaqil twutzxix. Kykyaqilxjo xjal, a kꞌwel nimin teꞌ twutzxix, ok kxel kybꞌiꞌn kykyaqiljo a nxi nqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Xi ttzaqꞌwin Pilat: ¿Tiꞌtziꞌn a twutzxix? Tbꞌajlinxiꞌ tqaniꞌn ikyjo, etz Pilat juntl majl yolil kyukꞌa Judiy, ex tqꞌma: Ntiꞌx jun tiljo ichin ma knet wuꞌn lo. ");
INSERT INTO mamC_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Me naqꞌleqiꞌy, tuꞌn t-xi ntzaqpiꞌn jun xjal jpuꞌnkux toj tze, noq tuꞌn tikyꞌsit nintz qꞌij kyuꞌn te Xjan Qꞌij. ¿Kyajtzintza tuꞌn t-xi ntzaqpinjiꞌy a nmaq kawil kyeꞌy? ");
INSERT INTO mamC_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tuꞌntziꞌn, kykyaqilx i ok ten ẍchꞌil juntl majl: ¡Mina teꞌ! Qalaꞌ tzaqpinxa Barrabás. Ex atzin te Barrabás jun toj kꞌul xjaltaq teꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tuꞌnpetziꞌn, etz tzyuꞌn Pilat Jesús, ex xi tqꞌmaꞌn tuꞌn tok bꞌyet. ");
INSERT INTO mamC_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ayetziꞌn xoꞌl qꞌaqꞌ kubꞌ kyxpatxꞌiꞌn txꞌiꞌx, ex jax kyqꞌoꞌn toj twiꞌ Jesús tzeꞌnku jun toj twiꞌ nmaq kawil. Ex ok kyktxuꞌn tukꞌa jun xbꞌalin kyaq kaꞌyin, tzeꞌnkuxjo kye nmaq kawil, me noq te xmaybꞌil tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ex i bꞌaj xi laqꞌe tkꞌatz, ex xi kyqꞌmaꞌn te: ¡Nimxit tbꞌiꞌy, ay, nmaq kawil kye aj Judiy! Exsin bꞌaj okx kytzꞌajchin toj twutz. ");
INSERT INTO mamC_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ex etz juntl majl Pilat toj ja te kawbꞌil, ex xi tqꞌmaꞌn kye Judiy: Kykaꞌyintza, ma tzꞌetz wiꞌn tzaluꞌn, tuꞌntzin tel kynikyꞌa te; qa ntiꞌ jun til ma knet wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Atzaj teꞌ tetz Jesús tukꞌaꞌ toj twiꞌ, exsin t-xbꞌalin otaq tzꞌok qꞌoꞌn, a kyaq kaꞌyin, xi tqꞌmaꞌn Pilat kye: Lu ichin lo. ");
INSERT INTO mamC_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Atzaj teꞌ tok kykaꞌyiꞌn kynejil pale exqetziꞌn xqꞌuqil tja Dios ikyjo, bꞌeꞌx i ok ten ẍchꞌil: ¡Pejkꞌinksa twutz cruz! ¡Pejkꞌinksa twutz cruz tuꞌn tkyim! chi chiꞌ. Xi tqꞌmaꞌn Pilat kye: ¡Kutzin! Kyinxa, ex kypejkꞌinksa twutz cruz, quꞌn ntiꞌ jun til ma knet wuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Xi tzaqꞌwin Pilat kyuꞌn aj Judiy: ¡Mina! Quꞌn at jun qe qkawbꞌil; ex atziꞌn nqꞌmaꞌn qa il tiꞌj tuꞌn tkyim, quꞌn ma tzꞌok tqꞌoꞌn tibꞌ te Tkꞌwal Dios, me tzeꞌnku ntiꞌ qe qoklin tuꞌn tkubꞌ qbꞌyoꞌn jun aj il; qalaꞌ oꞌkqex kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Noq teꞌ tok tbꞌiꞌn Pilat ikyjo, bꞌeꞌx tzaj txqantl t-xobꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Okx juntl majl Pilat toj ja te kawbꞌil, exsin xi tqanin juntl majl te Jesús: ¿Jaꞌxixsin tumil tzajnintza? Me ntiꞌx te Jesús xi ttzaqꞌwin. ");
INSERT INTO mamC_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tuꞌnpetziꞌn, xi tqꞌmaꞌn Pilat te: ¿Tiquꞌn mi nchin tzaj ttzaqꞌwiꞌn? ¿Ma mitzin bꞌiꞌn tuꞌn, qa at wokliꞌn tibꞌaja, tuꞌn tjaw pejkꞌita twutz cruz, mo tuꞌn t-xi ntzaqpiꞌn? ");
INSERT INTO mamC_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Xi ttzaqꞌwin Jesús te: Ntiꞌxitla te tokliꞌn wibꞌaja, noqit nya Dios saj qꞌonte teꞌy. Tuꞌnpetziꞌn, a xjal saj qꞌon weꞌy toj tqꞌobꞌa ma nimxixtl teꞌ til tzeꞌnku te. ");
INSERT INTO mamC_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Texjo paq anetziꞌn, ok ten Pilat jyol tumil tzeꞌn tuꞌn t-xi tzaqpete Jesús. Me ayetziꞌn Judiy i ok ten ẍchꞌilte: Qa ma txi ttzaqpiꞌn, nya wen k-elile toj twutz nmaq kawil, a César. Quꞌn alkye tzꞌok tqꞌoꞌn tibꞌ te nmaq kawil ajqꞌoj tiꞌjjo César, a manyor nmaq kawil toj Rom. ");
INSERT INTO mamC_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Atzaj teꞌ tok tbꞌin Pilat ikyjo, xi tqꞌmaꞌn kye, tuꞌn tetz kyiꞌn Jesús tzma peꞌn toj jun kol ja bꞌinchin toj tuꞌn abꞌj, a Gabata n-ele toj kyyol aj Judiy, ex antza kubꞌ qeꞌ tojjo qꞌuqbꞌil te kawbꞌil. ");
INSERT INTO mamC_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ajo qꞌij, a naꞌmtaq chꞌintl tuꞌn tjapin kanin nintz qꞌij te Xjan Qꞌij, ex bꞌalaqa tzmataq kabꞌlaj or. Xi tqꞌmaꞌn Pilat kye Judiy: Lu kynmaq kawila lo. ");
INSERT INTO mamC_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Me ayetzin Judiy xi kyẍchꞌiꞌn: ¡Kyimkuj! ¡Kyimkuj! ¡Pejkꞌinksa twutz cruz! Xi tqꞌmaꞌn Pilat kye: ¿Mej qa ayin weja, tuꞌn njaw pejkꞌinte kynmaq kawila twutz cruz? Me ayetzin kyeꞌ kynejinel pale xi kytzaqꞌwin: ¿Mejqa at juntl qeja qnmaq kawil? Qalaꞌ oꞌkx César, a nmaq kawilxix toj Rom. ");
INSERT INTO mamC_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tuꞌntzin ikyjo, bꞌeꞌx xi tqꞌoꞌn Pilat Jesús toj kyqꞌobꞌ xoꞌl qꞌaqꞌ, tuꞌn tjaw pejkꞌit twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ex bꞌeꞌxsin etz kyiꞌn Jesús iqin tcruz, tuꞌn tkanin toj jun tal txꞌotxꞌ, a Tbꞌaqil twiꞌ kyimnin tbꞌi, a Gólgota tbꞌi toj kyyol aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Antza jaw kypejkꞌin twutz cruz junx kyukꞌa kabꞌe ichin tukꞌa, junjun toj junjun plaj, ex ante Jesús toj nikyꞌjin. ");
INSERT INTO mamC_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ante Pilat xi tqꞌmaꞌn tuꞌn kypejkꞌit jun tzꞌlan tibꞌaj twiꞌ, tukꞌa jun yol tzꞌibꞌink tiꞌj, a ntqꞌmaꞌn: Jesús aj Nazaret, a Nmaq Kawil kye aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nimx Judiy bꞌaj ok uꞌjin teꞌ a yol, tzꞌibꞌink twutz tzꞌlan, quꞌn atziꞌn tal txꞌotxꞌ, a jaꞌ jawe qꞌoꞌne Jesús twutz cruz, nqayintaq taꞌ tkꞌatz tnam, ex atzin yol tzꞌibꞌink twutz tzꞌlan toj oxe yol: Ebrey, Latín ex Griego. ");
INSERT INTO mamC_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tuꞌnpetziꞌn, i aj ajqelin kynejil pale aj Judiy qꞌmalte te Pilat kyjaluꞌn: Mina tzꞌok ttzꞌibꞌiꞌn, qa ax twutzx nmaq kawil kye aj Judiy; qalaꞌ qa ok tqꞌoꞌn tibꞌ nyakuj nmaq kawilch. ");
INSERT INTO mamC_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Me ante Pilat xi tqꞌmaꞌn: ¡Mina! Quꞌn a ma kubꞌ ntzꞌibꞌiꞌn, nlay jaw ntxꞌixpiꞌn; qalaꞌ kyijkuj kukxjo. ");
INSERT INTO mamC_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tbꞌajlinxiꞌ kypejkꞌin xoꞌl qꞌaqꞌ Jesús twutz cruz, bꞌaj jaw kychmoꞌn t-xbꞌalin, ex bꞌaj kubꞌ kysipin kyxol te kyaje elnin, junjun te junjun xoꞌl qꞌaqꞌ. Me atx juntl kamiẍj kyij, a ntiꞌ slepinte; qalaꞌ junx chinbꞌinte tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ayetziꞌn xoꞌl qꞌaqꞌ, i jaw yolin kyxolx: Yajtzintlaꞌ mi kubꞌ qlaqin. Wenitla tuꞌn qsaqchan tiꞌj, ankye kkanbꞌilte. Ikytzin japin bꞌajjo a tzꞌibꞌin toj Tuꞌjil Tyol Dios kyjaluꞌn: Bꞌaj kubꞌ kysipin nxbꞌaliꞌn kyxol, ex i bꞌaj saqchan tiꞌjch. Ikyxixsin bꞌantjo kyuꞌn xoꞌl qꞌaqꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ayetziꞌn tnana Jesús tukꞌaxjo titzꞌin; ex tukꞌa Mariy, a t-xuꞌjil Cleofas; tukꞌax Mariy aj Xleꞌn, waꞌlqetaq t-xe tqan cruz, a jaꞌ jawe pejkꞌin Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tej tok tkaꞌyin Jesús tnana waꞌltaq junx wukꞌiy, a ayiꞌn jun t-xnaqꞌtzbꞌin, a kꞌuꞌjlinxixtaq tuꞌn, xi tqꞌmaꞌn te tnana: Qya, atzin jaꞌlin, ma tzꞌokjo luꞌn te tala. ");
INSERT INTO mamC_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ex ikyxjo tzaj tqꞌmaꞌnl weꞌy: Ajo qya lo ma tzꞌok te tnaniy. Ex atxixsiꞌn, bꞌeꞌx tzaj nkꞌmoꞌn tnana toj njaꞌy tuꞌn tok nkaꞌyiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tbꞌajlinxiꞌ ikyjo, xi tqꞌmaꞌn Jesús: At kꞌwaj wiꞌja. Xi tqꞌmaꞌn ikyjo tuꞌntzin tjapin bꞌajjo tzꞌibꞌin toj Tuꞌjil Tyol Dios, quꞌn bꞌiꞌntaq tuꞌn qa il tiꞌj tuꞌn tjapin bꞌajjo tkyaqil otaq tqꞌma Dios. ");
INSERT INTO mamC_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Attaq jun xar tkubꞌ antza, nojnin tukꞌa jun wiq vin txꞌamxix wen. Kux kymulin jun bꞌuꞌẍ toj, exsin ok kykꞌloꞌntz tiꞌj jun tqꞌobꞌ tze, tuꞌn tjapin tzma toj ttzi Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Xi ttzꞌubꞌin, ex tqꞌma: Ma japin bꞌaj kykyaqilx jaꞌlin. Tzaj tmutxbꞌiꞌn twiꞌ, ex bꞌeꞌx el kyim. ");
INSERT INTO mamC_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Atzin qꞌij anetziꞌn, atxtaq jun qꞌij tuꞌn tjapin kaninjo qꞌij te ajlabꞌl, jaꞌ iltaq tiꞌj tuꞌn tkubꞌ kybꞌinchin tkyaqil, tuꞌn kyikyꞌsin Judiy Xjan Qꞌij. Kykyꞌeꞌtaq tuꞌn tkyij ten kyxmililjo xjal twutz cruz toj qꞌij te ajlabꞌl, quꞌn atzin qꞌij te ajlabꞌl lo, nimxix toklin te kye. Tuꞌnpetziꞌn, bꞌeꞌx i xiꞌ qꞌmalte te Pilat, tuꞌn tok waqꞌit kykuxjo xjal iteꞌkxtaq twutz cruz, tuꞌn kykyim liwey, ex tuꞌn teljo kyxmilil antza. ");
INSERT INTO mamC_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tuꞌnpetziꞌn, bꞌeꞌx i xiꞌ chqꞌoꞌn xoꞌl qꞌaqꞌ bꞌinchilte. Nej, kubꞌ kywaqꞌin tkuxjo tnejil, ex ikyxjo tkabꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Me atzaj teꞌ kyxi laqꞌe tkꞌatz Jesús, ok kykaꞌyin qa otaq tzꞌel kyim. Tuꞌnpetziꞌn, mix oke kywaqꞌine tkux Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Me atzin jun xoꞌl qꞌaqꞌ jun paqx okx t-xyuꞌn toj t-xukꞌ Jesús tukꞌa jun tbꞌujbꞌil, chꞌut twiꞌ, ex jun paqx, etz ulbꞌin chikyꞌ tukꞌa aꞌ toj. ");
INSERT INTO mamC_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ex ayinku weꞌ in lonte. Tuꞌnpetziꞌn, xi nqꞌmaꞌn twutzxix, quꞌn ankye ma lonte, twutzxix te tyol, tuꞌntzin majqex kye, tuꞌn kyxi niminte. ");
INSERT INTO mamC_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tkyaqiljo lo o bꞌaj, noqx tuꞌn tjapin bꞌaj tkyaqiljo ntqꞌmaꞌn Tuꞌjil Tyol Dios kyjaluꞌn: Ntiꞌx jun tbꞌaqil tuꞌn tok waqꞌit. ");
INSERT INTO mamC_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ex toj juntl tnej Tuꞌjil Tyol Dios ntqꞌmaꞌn: K-okil kykaꞌyiꞌn aj tok kyxyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tbꞌajlinxiꞌ ikyjo, attaq jun ichin, Jse aj Arimatey, xi tqanin ambꞌil te Pilat, tuꞌn t-xi tiꞌn t-xmilil Jesús. Atzin teꞌ Jse lipchek toj tanmin tiꞌj t-xnaqꞌtzbꞌil Jesús; me tkyꞌeꞌtaq tuꞌn tel tqanil, noq tuꞌn t-xobꞌil kye Judiy. Ante Pilat xi tqꞌoꞌn ambꞌil te Jse, tuꞌn t-xi tiꞌn t-xmilil Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ikyx te Nicodemjo; a xtaꞌj yolil tukꞌa Jesús toj qnikyꞌin, pon tiꞌn bꞌalaqa qaq alme qꞌanbꞌil te jupsbꞌil, smaꞌn tten tukꞌa mir ex áloe. ");
INSERT INTO mamC_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ikytziꞌn, ate Jse tukꞌa Nicodem, xi kyiꞌn t-xmilil Jesús, ex kubꞌ kybꞌaltzꞌin toj iqbꞌil tukꞌa qꞌanbꞌil te jupsbꞌil, ikyxjo tzeꞌnkuꞌ kyxnaqꞌtzbꞌin aj Judiy, aj tkux muqet jun kyimnin. ");
INSERT INTO mamC_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tojjo txꞌotxꞌ, a jaꞌ jawe qꞌoꞌn Jesús twutz cruz, attaq juntl chꞌlaj te awbꞌil tqan lobꞌj. Ex tojtaqjo chꞌlaj, attaq jun tjul kyimnin otaq bꞌant, a jaꞌ ntiꞌtaq jun kyimnin otaq kuꞌx toj. ");
INSERT INTO mamC_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ex antza kux kyqꞌoꞌne t-xmilil Jesús, quꞌn nqayin taꞌtaqjo jul, ex chꞌixtaq t-xi xkyeꞌ qꞌij te ajlabꞌl, jaꞌ mix aꞌl jun bꞌaꞌn tuꞌn tbꞌinchin jun tiꞌ. ");
INSERT INTO mamC_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Toj tnejil qꞌij te seman, xiꞌ Mariy aj Xleꞌn ttzi jul, a naꞌmtaqx chꞌintl qel sqix. Xi tkaꞌyin qa otaq tzꞌel te abꞌj, a toktaq te jupil ttzi jul. ");
INSERT INTO mamC_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Atzaj teꞌ tok tkaꞌyin qa otaq jqet, bꞌeꞌx xi rinin a jaꞌ otoꞌtaqa, junx tukꞌa Simun Pegr, a ayiꞌn t-xnaqꞌtzbꞌin Jesús kꞌuꞌjlinqinxixa tuꞌn. Tzaj tqꞌmaꞌn Mariy qeꞌy: O tzꞌex qꞌiꞌn t-xmilil qAjaw toj jul, ex ntiꞌ bꞌiꞌn quꞌn jax kubꞌe qꞌoꞌne. ");
INSERT INTO mamC_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tuꞌnpetziꞌn, bꞌeꞌx o xiꞌy tukꞌa Pegr, exsin o pon kaniꞌn tzma ttzi jul. ");
INSERT INTO mamC_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Junx nqo rinintaqa, me nej in kaniꞌn chꞌintl weꞌ ttzi jul tzeꞌnkuꞌ te Pegr. ");
INSERT INTO mamC_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ex in kubꞌ kꞌweꞌy kaꞌyilte, ex ok nkaꞌyinjiꞌy bꞌuꞌẍ, a jaꞌ bꞌaltzꞌinkutaq. Me mix in okxiꞌy toj jul. ");
INSERT INTO mamC_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tej tkanin Simun Pegr nkꞌatza, jun paqx okx toj jul; ex ikyxjo, ok tkaꞌyin iteꞌkutaqjo bꞌuꞌẍ, a jaꞌ bꞌaltzꞌinkutaq. ");
INSERT INTO mamC_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ex majx tliꞌ a bꞌuꞌẍ toktaq te potzbꞌil twiꞌ Jesús, nya junx iteꞌkutaq kyukꞌaꞌ bꞌuꞌẍ aye ajbꞌin te bꞌaltzꞌbꞌilte; qalaꞌ tjunalxtaq tkubꞌ, chebꞌex paqtzin wen. ");
INSERT INTO mamC_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ex ikyx wejiꞌy, a ayiꞌn in kanin nej, in okxa, ex ok nkaꞌyiꞌn tiꞌjjo otaq bꞌaj, ex bꞌeꞌx xi nnimiꞌn qa ntiꞌtaq antza. ");
INSERT INTO mamC_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Quꞌn naꞌmtaq tel qnikyꞌa te a ntqꞌmaꞌn toj Tuꞌjil Tyol Dios, qa iltaq tiꞌj tuꞌn tjaw anqꞌintl Jesús kyxol kyimnin. ");
INSERT INTO mamC_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tuꞌnpetziꞌn, bꞌeꞌx o aja qjay. ");
INSERT INTO mamC_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Me ante Mariy aj Xleꞌn bꞌeꞌx kyij peꞌn tzma ttzi jul. N-oqꞌ wen, me tzmataq n-oqꞌ, kubꞌ kꞌweꞌ tuꞌn tokx tkaꞌyin tojxi jul. ");
INSERT INTO mamC_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ex xi tkaꞌyin kabꞌe angel, sjanin kyxbꞌalin tok, ex qꞌuqleqetaq jaꞌ okxi qꞌoꞌn t-xmilil Jesús, jun, jaꞌ tkubꞌetaq twiꞌ Jesús, ex juntl jaꞌ iteꞌkutaq tqan. ");
INSERT INTO mamC_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Xi kyqanin angel te: ¿Qya, tiquꞌn n-oqꞌa? Xi ttzaqꞌwin Mariy: Tuꞌntziꞌn ma txi qꞌiꞌn wAjawa, ex ntiꞌ bꞌiꞌn wuꞌn jaꞌ ma kubꞌe qꞌoꞌne. ");
INSERT INTO mamC_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Noqx nbꞌajkutaq tqꞌmaꞌn luꞌn, ajtz meltzꞌaj twutz, ex tli waꞌltaq Jesús tkꞌatz, me mix ele tnikyꞌ te qa a Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Xi tqanin Jesús te: Qya, ¿Tiquꞌn n-oqꞌa? ¿Altzin kye ntjyoꞌn? Kubꞌ t-ximin Mariy qa ataqjo xqꞌuqil chꞌlaj te tqan lobꞌj, ex xi tqꞌmaꞌn te: Tata, qa ay o txi qꞌinte, qꞌmaꞌntza weꞌy, jaꞌ xkubꞌe tqꞌoniy, tuꞌn nxiꞌy jyolte. ");
INSERT INTO mamC_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Me ante Jesús xi tqꞌmaꞌn te: ¡Mariy! Atzin teꞌ qya xi meltzꞌaj, ex xi tqꞌmaꞌn toj kyyol aj Judiy: ¡Raboni! Atzin tzꞌelpine, Xnaqꞌtzil toj qyol. ");
INSERT INTO mamC_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Xi tqꞌmaꞌn Jesús te: Mi tzalaja noq tuꞌn ma chin tliꞌy, ex ma chin ok tmekoꞌn qa ayinjiꞌy, quꞌn naꞌmx njaxa tukꞌa nMaꞌn. Quꞌn aj njaxa toj kyaꞌj, tzul jun tzaljbꞌil nimxix te teꞌy, aj tul Xewbꞌaj Xjan toj tanmiꞌn te jun majx. Me kux txiꞌy, ex qꞌmaꞌnxa tqanil kye nxnaqꞌtzbꞌiꞌn, a kꞌuꞌjlinqexix wuꞌn. Chkujiy kyjaluꞌn: Kchin jawixa tkꞌatz Dios, a nMaꞌn ex kyMaꞌn. Ex ma chin kaniꞌn tukꞌa nDiosa, a axjo kyDiosa. ");
INSERT INTO mamC_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ikytziꞌn, bꞌeꞌx xiꞌ Mariy, aj Xleꞌn qꞌmalte qeꞌy, a awoꞌy t-xnaqꞌtzbꞌin, ex tzaj tqꞌmaꞌn: Ma nli weꞌ qAjaw. Ex tzaj tqꞌmaꞌn qeꞌy tkyaqiljo otaq bꞌaj tqꞌmaꞌn Jesús te. ");
INSERT INTO mamC_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ax qꞌijjo, a tnejil qꞌij te seman, toj qnikyꞌin ok qchmoꞌn qibꞌa junx, ex otaq tzꞌetz qjpuꞌn ja, tuꞌn qxobꞌila kye nejinel kye aj Judiy. Jun paqx kubꞌ weꞌ Jesús qxola, ex tzaj tqꞌmaꞌn qeꞌy: Qexit kykꞌuꞌja, ex tzalajxit kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tej tbꞌaj tqꞌmaꞌn ikyjo, i tzaj tyekꞌin tqꞌobꞌ qeꞌy exsiꞌn t-xukꞌ. Ex bꞌeꞌx o jaw tzalajxa, teꞌ tok qkaꞌyiꞌn qAjaw. ");
INSERT INTO mamC_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Liwey tzaj tqꞌmaꞌn Jesús juntl majl qeꞌy: Qexit kykꞌuꞌja, ex tzalajxit kyanmiꞌn. Ikytziꞌn tzeꞌnku weꞌ, ma chin tzaj tchqꞌoꞌn nMaꞌn bꞌinchil tajbꞌil, ex ikyx kyejiꞌy, kchi xel nchqꞌoꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tej tbꞌaj tqꞌmaꞌn ikyjo, xi t-xupin qibꞌaja, ex tzaj tqꞌmaꞌn qeꞌy: Kykꞌmoꞌnxa Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kxel nqꞌoꞌn kyokliꞌn tuꞌn kytzaj kykꞌmoꞌn xjal toj nkawbꞌila. Ikytziꞌn, ankye te kꞌwel kyqꞌmaꞌn qa ma najsit til, ok kꞌwel najsit te til te jun majx. Ex ankye teꞌ mi kubꞌ kyqꞌmaꞌn qa ma najsit til, kukx kyjel ten teꞌ tjaqꞌ til. ");
INSERT INTO mamC_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Me ante Tmas, a jun t-xnaqꞌtzbꞌin Jesús, a toktaq tbꞌi, Kwaꞌch, ntiꞌtaq teꞌ, teꞌ tul Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Atzaj teꞌ t-xi qqꞌmaꞌn te qa otaq qliꞌy qAjaw, tzaj tqꞌmaꞌn qeꞌy: Qa mix nliꞌy tkyꞌixlbꞌin tqꞌobꞌ, ex qa mi s-okx nlimoꞌn twiꞌ nqꞌobꞌa kyojjo jaꞌ okxi kxbꞌil; ex qa mi s-okx nqꞌoꞌn nqꞌobꞌa toj tẍutil t-xukꞌ, nlayx txi nnimiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tbꞌajlinxiꞌ wajxaq qꞌij, ok qchmoꞌn qibꞌa toj jun ja. Tojjo qꞌij anetziꞌn, attaq Tmas qukꞌiy. Exla qa jpuꞌntaq ja, jun paqx kubꞌ weꞌ Jesús qxola, ex o ok tqꞌolbꞌiꞌn, ex tqꞌma: Qexit kykꞌuꞌja, ex tzalajxit kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ex jun paqx xi tqꞌmaꞌn te Tmas: Qꞌomix twiꞌ tqꞌobꞌa tzaluꞌn, ex kaꞌyinqetzjiy nqꞌobꞌa. Ex nuqpinxjiy tqꞌobꞌa, ex qꞌomixa toj nxukꞌa. Mi jawje tkꞌuꞌja; qalaꞌ tzꞌokxa jun nimil twutzxix. ");
INSERT INTO mamC_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tuꞌnpetziꞌn, xi ttzaqꞌwin Tmas te: Ay wAjaw, ex nDiosa. ");
INSERT INTO mamC_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Xi tqꞌmaꞌn Jesús te: Tmas, ¿Man txi tnimiꞌn noq tuꞌn ma chin tliꞌy? Me kyꞌiwlinqexix kyeꞌ, a mi ẍin kyliꞌy, me ma txi kynimin. ");
INSERT INTO mamC_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ex kubꞌ tbꞌinchin Jesús nimku techil tipin qwutza, tuꞌn qkaꞌylaja kyiꞌj, a ntiꞌ kubꞌ tzꞌibꞌit tojjo uꞌj lo. ");
INSERT INTO mamC_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Me ayetziꞌn tzꞌibꞌinqe tzaluꞌn, noq tuꞌn t-xi kynimiꞌn qa a Jesúsjo a Crist, a Tkꞌwal Dios. Quꞌn qa ma txi kynimiꞌn ikyjo, ktenbꞌil kychwinqila, a nlay bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tbꞌajlinxiꞌ tkyaqiljo lo, tzaj tyekꞌin juntl majl Jesús tibꞌ qwutza, a awoꞌy t-xnaqꞌtzbꞌin, ttzij Nijabꞌ Tiberias. Kubꞌ tbꞌinchin toj jun tumil kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Junxtaq iteꞌ Simun Pegr; Tmas, aj toktaq tbꞌi, Kwaꞌch; tukꞌax Natanael, aj Caná te Galiley; ex majqoxa tkꞌwal Zebedey; ex kyukꞌal kabꞌe t-xnaqꞌtzbꞌin. ");
INSERT INTO mamC_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tzaj tqꞌmaꞌn Simun Pegr qeꞌy: Ma chinka kyiẍilch. Ex xi qtzaqꞌwin te: Ikyqox qejiꞌy, ma qoxa tukꞌiy. Bꞌeꞌx o xiꞌy, ex o jaxa toj jun bark. Me tojjo qnikyꞌin, ntiꞌxtaq jun kyiẍ otaq tzyet. ");
INSERT INTO mamC_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Me atzaj teꞌ chꞌixtaq qel sqix, kubꞌ tyekꞌin Jesús tibꞌ ttzi nijabꞌ, me mix ele qnikyꞌa te qa ataq Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tuꞌnpetziꞌn, tzaj tqꞌmaꞌn qeꞌy: Qꞌaa, ¿Ntiꞌxsin jun kyiẍ ma tzyet kyuꞌn? Xi qtzaqꞌwiꞌn: Ntiꞌ, qo chijiꞌy. ");
INSERT INTO mamC_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tzaj tqꞌmaꞌnl Jesús qeꞌy: Xoꞌnkuxjiꞌy kypaꞌy toj juntl ttxlaj bark, toj kyman qꞌobꞌa, ex kchi tzyetil kyiẍ. Ikytzin kubꞌ qbꞌinchinjiꞌy. Tbꞌajlinxiꞌ ikyjo, mix jatza pa quꞌn toj aꞌ, tuꞌn talil txqan kyiẍ tkuxtaq toj. ");
INSERT INTO mamC_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Me ayin weꞌ in xi qꞌmaꞌnte te Pegr: Ate qAjawjo, nchijiꞌy. Noqx teꞌ tok tbꞌiꞌn Pegr ikyjo, qa a qAjaw, bꞌeꞌx ok tqꞌoꞌn t-xbꞌalin, a otaq tzꞌel tiꞌn, ex bꞌeꞌx xi t-xoꞌn tibꞌ toj aꞌ, tuꞌn tkanin tkꞌatz Jesús. ");
INSERT INTO mamC_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Awotzin qeꞌ o kaniꞌn tzma ttzi aꞌ tukꞌa bark qititin tel pa tuꞌn bark nojnin kyukꞌa kyiẍ. Nya najchaqtaq otoꞌy ttzi nijabꞌ, bꞌalaqa noq kyaje ech. ");
INSERT INTO mamC_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Atzaj teꞌ qkuꞌtza twiꞌ txꞌotxꞌ, knet jun qꞌaqꞌ quꞌn, otaq kubꞌ poꞌnj, tokxtaq jun kyiẍ tibꞌaj tukꞌa jun wabꞌj. ");
INSERT INTO mamC_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tzaj tqꞌmaꞌn Jesús qeꞌy: Kyintza junjun kyiẍ tiꞌjjo tzma xjatz kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ante Simun Pegr jax toj bark ex tzaj qititinljo pa tuꞌn, tzma ttzi tzꞌawin. Ante pa nojnintaq kyukꞌa txqan kyiẍ ma nmaq wen, oxlajaj toj wajxaq kꞌal kybꞌaj. Exla qa ma nintz kybꞌaj, me mix laqje pa kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tuꞌnpetziꞌn, tzaj tqꞌmaꞌn Jesús qeꞌy: Ku kytzaja waꞌl te qlixjech. Mix jun qxola xi qaninte te: ¿Ankyetaq? quꞌn bꞌiꞌn quꞌn qa a qAjaw. ");
INSERT INTO mamC_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ex jun paqx tzaj laqꞌe Jesús qkꞌatza, ex jaw ttzyuꞌn wabꞌj toj tqꞌobꞌ, exsin tzaj tqꞌoꞌntz qeꞌy, ex ikyx oke kyiẍjo tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Atzin toxin majjo kubꞌ tyekꞌin Jesús tibꞌ qwutza, a awoꞌy t-xnaqꞌtzbꞌin, a otaqxi jaw anqꞌin kyxol kyimnin. ");
INSERT INTO mamC_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Qbꞌajlinxi waꞌn te qlixje, xi tqanin Jesús te Simun Pegr: Simun, ay tkꞌwal Juan, ¿Tzuntzin nchin ok tkꞌuꞌjliꞌn nimxixtl tzeꞌnku tkyaqiljo te twutz txꞌotxꞌ? Atzin te Pegr xi ttzaqꞌwin te: Ikytziꞌn wAjaw, ojtzqiꞌn tuꞌn qa nimx waja tiꞌja. Xi tqꞌmaꞌn Jesús te: Kaꞌyinqektzinjiy tal neꞌẍ nimil, tzeꞌnku jun kyikꞌlel kyiꞌj tal tal trit. ");
INSERT INTO mamC_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Xi tqanin juntl majl Jesús te Pegr: Simun, ay tkꞌwal Juan, ¿Tzuntzin nchin ok tkꞌuꞌjliꞌn? Xi ttzaqꞌwinl Pegr: Ikytziꞌn wAjaw, ojtzqiꞌn tuꞌn qa nimx waja tiꞌja. Xi tqꞌmaꞌn Jesús te: Kaꞌyinqektzinjiy nimil, tzeꞌnku jun kyikꞌlel kyiꞌj trit. ");
INSERT INTO mamC_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Toj tox majintl xi tqanin te Pegr: Simun, ay tkꞌwal Juan, ¿Twutzxixsin, qa taja wiꞌja? Ante Pegr bꞌeꞌx jaw bꞌisin, tuꞌn otaq xi tqanin Jesús oxe maj te, qa n-ok tkꞌuꞌjlin. Ex xi tqꞌmaꞌn: WAjaw, a te ojtzqilte tkyaqil, ex ojtzqiꞌn tuꞌn qa wajxixa tiꞌja. Xi tqꞌmaꞌn Jesús te: Kaꞌyinqektzinjiy nimil, tzeꞌnku jun kyikꞌlel kyiꞌj trit. ");
INSERT INTO mamC_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ay Pegr, kxel nkujsin teꞌy, qa tej qꞌaxtaqa, tzun n-ok tkꞌloꞌntaq tkꞌuꞌja tuꞌnx tibꞌxa, tuꞌn t-xiꞌy noq jaꞌ tajiy tuꞌn t-xiꞌy. Me ajtzin ttijiꞌn, kxel kꞌloꞌn kyuꞌnxjal tuꞌn t-xiꞌy toj tze, ex kxel tjajin tqꞌobꞌa tuꞌn tkyima. ");
INSERT INTO mamC_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tej t-xi tqꞌmaꞌn Jesús ikyjo, xi tyekꞌin jun tumil tzeꞌn tuꞌn tkyime Pegr, ex tzeꞌn tuꞌn tjawe tnimsin tbꞌi Dios, aj tel tjajin tqꞌobꞌ twutz jun cruz. Tbꞌajlinxiꞌ ikyjo, xi tqꞌmaꞌnl te: Lipeka wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Atzaj teꞌ tajtz meltzꞌaj Pegr, xi tkaꞌyin qa lipcheqintztaqa tiꞌjxi Jesús, quꞌn kꞌuꞌjlinqinxixtaqa tuꞌn. Ex ayinxjiꞌy, a intintaq ttxlaj Jesús, tej t-xi nqaniꞌn te: WAjaw, ¿Ankye kxel qꞌontiy toj kyqꞌobꞌxjal? ");
INSERT INTO mamC_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Atzaj teꞌ wok kaꞌyiꞌn tuꞌn Pegr, xi tqanin te Jesús: WAjaw, ¿Yajtzin teꞌ lo? ¿Tiꞌtzila teꞌ kbꞌajil tiꞌj? ");
INSERT INTO mamC_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Xi ttzaqꞌwin Jesús: Qa waja tuꞌn tteꞌn, aj xi nmeltzꞌaja, ¿Tiꞌn te taj tiꞌj? Qalaꞌ lipek te wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tuꞌnpetziꞌn, jun paqx el tqanil kyxoljo nimil, qa ayiꞌn nyataq tuꞌn nkyima. Me atzin te Jesús, mix tqꞌmaye ikyjo, qa mitaq tuꞌn nkyima. Qalaꞌ o tqꞌma qa tiꞌtaq te Pegr taj tiꞌj, qa intinxtaqa, aj tul Jesús mo minaj. ");
INSERT INTO mamC_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ex ayinxjiꞌy jun t-xnaqꞌtzbꞌin Jesús, a ma nliꞌy tkyaqiljo o bꞌaj, ex nxi nqꞌoꞌn tqanil tiꞌj, ex bꞌiꞌn wuꞌn qa twutzxixjo tkyaqiljo ma kyij ntzꞌibꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nimku txqantl tiꞌ o bꞌant tuꞌn Jesús tibꞌaj tkyaqiljo, a ma kyij ntzꞌibꞌiꞌn tojjo uꞌj lo. Noqit kubꞌ tzꞌibꞌit junjun tbꞌinchbꞌin Jesús kyojjo nimku uꞌj, minatla xbꞌant tkꞌuꞌyitjo uꞌj toj tkyaqil twutz txꞌotxꞌ.");
INSERT INTO mamC_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ma kubꞌ ntzꞌibꞌinjiꞌy luꞌn, ay Tyople, kꞌuꞌjlinxix wuꞌn: Toj tnejil wuꞌja, kubꞌ ntzꞌibꞌiꞌn tiꞌj tkyaqiljo o bꞌant ex t-xnaqꞌtze Jesús, atxix tej tzaj xkye taqꞌin, ");
INSERT INTO mamC_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ex pon bꞌaj, tej tjaw Jesús twutz kyaꞌj. Me nej, i jaw tskꞌoꞌn tsanjil, ex xi tqꞌoꞌn tumil kye tuꞌn Xewbꞌaj Xjan, a tiꞌtaqjo tuꞌn tkubꞌ kybꞌinchin toj tumil. ");
INSERT INTO mamC_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tkyimlinxitzin Jesús, jaw anqꞌin juntl majl, ex xi tyekꞌin tibꞌ, ex ten kyukꞌa toj kaꞌwnaq qꞌij, tuꞌntzin tel kynikyꞌ qa twutzxix itzꞌtaq; ex yolin kyukꞌa tiꞌjjo Tkawbꞌil qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tej atxtaq Jesús kyukꞌa t-xnaqꞌtzbꞌin, xi tqꞌmaꞌn kye, tuꞌn mina chi ikyꞌ toj Jerusalén. Chiꞌ kyjaluꞌn: Kyyonkuy ajxi tbꞌantjo a tzaj tqꞌmaꞌn nMaꞌn kyeꞌy, ex ax xi nqꞌmanjiꞌy kyeꞌy: ");
INSERT INTO mamC_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Twutzxix qa i kux tqꞌoꞌn Juan xjal toj aꞌ te jawsbꞌil aꞌ; me ayetzin kyeꞌ, toj jteꞌbꞌin qꞌij, mina chi kuꞌx kyeꞌ toj aꞌ, qalaꞌ kꞌwelix te Xewbꞌaj Xjan toj kyanmiꞌn te jun majx, chi Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ayetzaj chꞌuqleqetaq tukꞌa Jesús, xi kyqanin te: QAjaw, ¿Okpetzila ktzajil ttziyiꞌn jaꞌlin tuꞌn t-xi xkye Tkawbꞌil Dios qxol, a tuꞌn qetz tjaqꞌ kykawbꞌil aj Rom, ex tuꞌn ttzaj tqꞌoꞌn qoklin juntl majl, tuꞌn qkawin tzaluꞌn toj qtanim tzeꞌnku kye qtzan qtata ojtxe? ");
INSERT INTO mamC_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Xi ttzaqꞌwin Jesús kye: Ntiꞌ kyeꞌ kyaj tuꞌn kybꞌintiꞌy tiꞌ qꞌijil mo jtoj kꞌwel tbꞌinchin te Diosjo, quꞌn oꞌkxte at toklin tiꞌj jtoj bꞌaꞌn tkubꞌ bꞌinchit. ");
INSERT INTO mamC_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Me metzin kyeꞌ, aj tul Xewbꞌaj Xjan toj kyanmiꞌn, kxel tqꞌoꞌn kyipiꞌn, tuꞌn kyxiꞌy yolil wiꞌja, a t-xilin Tkawbꞌil Dios, toj Jerusalén, toj tkyaqil Judey ex Samaria ex toj tkyaqiljo najchaq txꞌotxꞌ, chi Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tej tbꞌaj yolin, tzuntaq nchi kaꞌyintaq tsanjil tiꞌj, jaw qꞌiꞌn Jesús twutz kyaꞌj, ex tuꞌn muj, mix iwle kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tzuntaqtzin nchi kaꞌyin tzeꞌn tten xjaw qꞌiꞌn Jesús twutz kyaꞌj, tej tkubꞌ kyyekꞌin kyibꞌ kabꞌe ichin toktaq kyxbꞌalin sjanin wen, ");
INSERT INTO mamC_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ex xi kyqꞌmaꞌn: Ayiꞌy aj Galiley, ¿Tiquꞌn nxi kykaꞌyiꞌn twutz kyaꞌj? Axte Jesúsjo, a ten kyukꞌiy, ex ma txi qꞌiꞌn toj kyaꞌj, ikytzin tzule juntl majljo, tzeꞌnku ma kyliꞌy, teꞌ xiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tbꞌajlinxitzin ikyjo, i meltzꞌaj tsanjil Jesús twiꞌ wutz Olivos, tuꞌn kyul toj tnam Jerusalén, nya najchaq tzaj kybꞌetin, noqla jun nikyꞌjin ajlabꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tej kykanin Jerusalén, i jax tojjo ja, a otaq tzaj qꞌoꞌn te kymajin. Iteꞌtaq Pegr, Juan, Santyaw, Andrés, Lip, Tmas, Bartolomey, Matey, Santyaw, a tkꞌwal Alpey; Simun, a tok qꞌolbꞌilte te Celote, a tajqꞌojtaqjo kawil te Rom; ex Judas, a titzꞌin Santyaw. ");
INSERT INTO mamC_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kykyaqilx n-ok kychmoꞌntaq kyibꞌ, tuꞌn kynaꞌn Dios kyukꞌa titzꞌin Jesús, tukꞌa Mariy, a tnana; ex kyukꞌa txqantl qya. Ex nimxtaq kykꞌuꞌjbꞌil kyibꞌ kyxolx. ");
INSERT INTO mamC_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ok kychmoꞌn kyibꞌ nimil kyojjo qꞌij anetziꞌn, bꞌala qaq kꞌal kybꞌaj. Ja weꞌks Pegr, ex xi tqꞌmaꞌn: ");
INSERT INTO mamC_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ayiꞌy nxjalil, ilxix tiꞌj tuꞌn tbꞌajjo a kubꞌ tyolin David toj Tuꞌjil Tyol Dios tuꞌn Xewbꞌaj Xjan tiꞌj Judas, aj nejnintaq kywutzjo tajqꞌoj Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ante Judas qukꞌataq, ex attaq toklin tojjo qaqꞌin, chi Pegr. ");
INSERT INTO mamC_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Me atziꞌn te Judas tzaj tlaqꞌoꞌn jun ttxꞌotxꞌ tukꞌaj pwaq, a tzaj ttzyuꞌn, tej t-xi tkꞌayin Jesús. Ex bꞌeꞌx tzaj tzꞌaq Judas twutz txꞌotxꞌ, ex bꞌeꞌx el poqꞌle tkꞌuꞌj, ex bꞌeꞌx etz qiꞌyj t-xqintxa. ");
INSERT INTO mamC_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tej kybꞌinte aj Jerusalén ikyjo, ok kyqꞌoꞌn tbꞌij txꞌotxꞌ anetziꞌn: Acéldama, atzin tzꞌelpineꞌ toj qyol, Ttxꞌotxꞌil Chikyꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Juntl majl yolin Pegr tiꞌj Judas, ex tqꞌma: Quꞌn nyolin toj Tuꞌjil Bꞌitz, tuꞌn tkyij tzaqpajjo tnajbꞌil, ex mix aꞌl tuꞌn tnajan toj tja. Ex toj juntl Bꞌitz chiꞌ kyjaluꞌn, chi Pegr: Ex junxitl tuꞌn tten tojjo toklinch. ");
INSERT INTO mamC_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Atzin jaꞌlin, iteꞌxjal tzaluꞌn, ayeꞌ o chi ten qukꞌa tkyaqil qꞌij; ");
INSERT INTO mamC_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tzaj xkye atxix tej tkuꞌx Jesús toj aꞌ, te jawsbꞌil aꞌ tuꞌn Juan, ex pon bꞌaj, tej tjaw qꞌiꞌn twutz kyaꞌj. Tuꞌnpetziꞌn, il tiꞌj tuꞌn tjaw skꞌet juntl qxol tuꞌn tok te t-xel Judas, tuꞌn tten junx qukꞌa, tuꞌntzin tyolin tiꞌj Jesús, qa ma jaw anqꞌin juntl majl, chi Pegr. ");
INSERT INTO mamC_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jawtzin skꞌoꞌn kabꞌe ichin, Jse Barsabás, mo Just tbꞌi; junx tukꞌa Matías. ");
INSERT INTO mamC_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tej kyskꞌetjo aye kabꞌe, i naꞌn Dios kyjaluꞌn: Noq samiy, qAjaw, ate ojtzqilte kyanmin kykyaqil xjal. Yekꞌintziꞌn alkye taja, ");
INSERT INTO mamC_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tuꞌn tok te t-xel Judas, a toktaq te tsanjil Jesús, me bꞌeꞌx s-el tiꞌn tibꞌ tuꞌn til. Tuꞌntziꞌn, bꞌeꞌx xi qꞌoꞌn Judas tojjo najbꞌil te chojbꞌil il. ");
INSERT INTO mamC_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Atziꞌn techiljo sikyꞌbꞌil atza kubꞌe tzꞌaqe tiꞌj Matías. Tuꞌntziꞌn, ok te tajlal tsanjil Jesús, junx kyukꞌa txqantl. ");
INSERT INTO mamC_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tej tjapin kanin nintz qꞌij Pentecostés, kykyaqil qe nimil chꞌuqleqetaq junx. ");
INSERT INTO mamC_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Noq kynaꞌbꞌinkuxi tqꞌajqꞌojil jun tiꞌ tzaj toj kyaꞌj nyakuj tzeꞌn nim kyqꞌiqꞌ, ex kubꞌ noj tuja, jaꞌ iteꞌtaq. ");
INSERT INTO mamC_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ex kyli jun techil tzeꞌnku taqꞌ qꞌaqꞌ njulin tibꞌaj junjunkye. ");
INSERT INTO mamC_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ex kykyaqil kux nojsin kyanmin tuꞌn Xewbꞌaj Xjan, ex i ok ten yolil, me toj junxil yol, tzeꞌnku tqꞌma Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kyojjo qꞌij anetziꞌn, otaq chi kanin Judiy toj Jerusalén, tuꞌn tkubꞌ nimitjo a tzꞌibꞌin toj Tuꞌjil Tyol Dios tiꞌjjo qꞌij te Pentecostés; ayetziꞌn Judiy, i tzaj toj tkyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bꞌeꞌx ok kychmoꞌnxjal kyibꞌ, teꞌ kybꞌinte chꞌotjin, ex kykyaqilx bꞌeꞌx jaw naj kynabꞌl, quꞌn junjun xjal ok bꞌinte tyol nyolajtz tuꞌn junjun nimil. ");
INSERT INTO mamC_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ex bꞌeꞌx jaw kꞌant kywutz, ex jaw yolin kyxolx: ¿Me nyan te Galiley qe xjal nchi yolin? ");
INSERT INTO mamC_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Tzeꞌntzin tten ikyjo, a n-el qnikyꞌ tiꞌj tyol junjun toj qyol? ");
INSERT INTO mamC_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tzaluꞌn at xjal te tnam Partia, te Media, te Elam, te Mesopotamia, te Judey, te Capadocia, te Ponto ex te txꞌotxꞌ Asia, ");
INSERT INTO mamC_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","te Frigia, te Panfilia, te Egipto, ex te txqantl txꞌotxꞌ te Libia nqayin tkꞌatz Cirene. Ex iteꞌ junjun ẍi tzaj te Rom: ");
INSERT INTO mamC_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","At junjun Judiyqe, a kyitzꞌjlinx, ex junjun i ok te Judiy noq tuꞌn kynimbꞌil. Ex iteꞌ ẍi tzaj te Creta ex te Arabia. Ex qkyaqilx nqbꞌiꞌn kyyol tojxjo qyol atzin nkyqꞌmaꞌn tiꞌjjo tbꞌinchbꞌin Dios. ");
INSERT INTO mamC_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kykyaqilx jaw kaꞌylaj, ex jaw naj kynabꞌl, ex xi kyqanin kyxolile: ¿Tzeꞌntzin tzꞌelpine luꞌn? ");
INSERT INTO mamC_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Me at junjun noq bꞌaj jaw xmayin, ex kyqꞌma: Tuꞌntziꞌn ma chi txꞌujte, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jawtzin weꞌks Pegr junx kyukꞌa junlajajtl tsanjil, ex tukꞌaxix tajqꞌojil twiꞌ wen, xi tqꞌmaꞌn: Ayiꞌy nxjalil, aj Judiy, ex kykyaqila najleqiꞌy toj Jerusalén, bꞌiꞌnku kyuꞌn ex kybꞌinkuxixa wen a kxel nqꞌmaꞌn kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nya nchi txꞌujte kyeꞌ xjal lo, tzeꞌnku ma kyqꞌmaꞌy. Tzmape bꞌeljaj or te qlixje ma tzꞌok jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mikyxi teꞌ ante nbꞌaj jaꞌlin, aj tyole Joel, a yolil Tyol qMan Dios ojtxe, tej tqꞌmante: ");
INSERT INTO mamC_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Chi Diosjo kyjaluꞌn: Aj kyxi xkye qꞌij te chꞌixtaq tuꞌn nkaniꞌn, kxel nqꞌoꞌn Xewbꞌaj Xjan tibꞌaj tkyaqil xjal. Ok chi yolil kykꞌwala txin ex qꞌa wiꞌja. Ok k-elil kyeꞌ kuꞌxin qꞌa kynikyꞌ tiꞌjjo kbꞌantil tuꞌn Dios. Ex ok k-okil kywutzikyꞌjo ichin, a ma chi tijin, tuꞌn Dios, tiꞌjjo kbꞌajil. ");
INSERT INTO mamC_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ex kxel nqꞌoꞌn Xewbꞌaj Xjan kyojjo qꞌij anetziꞌn toj kyanmin waqꞌnila qya ex ichin, ex kchi yolil wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ktzajil nyekꞌin nim techil toj kyaꞌj; ex twutz txꞌotxꞌ k-iwlil chikyꞌ, qꞌaqꞌ, ex sibꞌ, noq tuꞌn qꞌoj. ");
INSERT INTO mamC_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Atzin twutz kyaꞌj, ok k-okil naj tqan qꞌij, ex k-elil kyaqix twutz yaye, ikyx tzeꞌnku chikyꞌ; chꞌixtaqtzin tul kanin qꞌij te tulil juntl majl qAjaw. Nimx tokliꞌn qꞌij anetziꞌn te bꞌisbꞌajil, ex ok kqoptzꞌajil tipin Dios. ");
INSERT INTO mamC_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Me ayetzin kyeꞌ kꞌwel kynimiꞌn Tyol qAjaw, ok chi kletil kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ayiꞌy nxjalil, aj Judiy, chi Pegrjo, kybꞌintzinjiꞌy a kxel nqꞌmaꞌn kyeꞌy, quꞌn bꞌiꞌnxix kyuꞌn qa a Jesús aj Nazaret, jun ichin, a ma tzaj tyekꞌin kyeꞌy, qa bꞌaꞌn ele twutz Dios, tuꞌn nimxix tbꞌinchbꞌin, ex tuꞌn ilaꞌ techil bꞌant tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","24","Me atzaj teꞌ t-xi qꞌoꞌn kyeꞌy, bꞌeꞌx ok kytzyuꞌn, ex xi kyqꞌoꞌn kye ichin aj il te Rom, tuꞌn tkubꞌ kybꞌyoꞌn twutz cruz. Tkyaqiljo lo bꞌant tzeꞌnkuxjo t-xim Dios otaq bꞌaj, ex ikyxjo, ilxix tiꞌj tuꞌntaq tbꞌant. A ayiꞌy kubꞌ bꞌyoꞌnte Jesús, me jaw anqꞌin juntl majl tuꞌn Dios. Tuꞌn ikyjo, bꞌeꞌx tzaqpaj tjaqꞌ kyimin ex ntiꞌl toklin kyimin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Bꞌiꞌn quꞌn, chi Pegr, quꞌn atzin David, a nmaq kawil te Israel ojtxe, kyij ttzꞌibꞌin tiꞌj Jesús toj Tuꞌjil Tyol Dios, ex tqꞌma kyjaluꞌn: Kukx n-ok nkaꞌyinjiꞌy Ay qAjaw, ata nwutza. Tuꞌnpetziꞌn, nlay chin jaw tzꞌaqa, quꞌn luꞌy at toj nman qꞌobꞌa tuꞌn tkoliꞌn wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tuꞌn ikyjo, tzunx nchin tzalaja, ex nchin bꞌitziꞌn tukꞌa tzeꞌjbꞌil. Ex qꞌuqle nkꞌuꞌja tiꞌja tukꞌa tkyaqil nchwinqila, ");
INSERT INTO mamC_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","quꞌn nlay chin kyij tqꞌon te jun majx toj tjulil kyimnin; ex nlay ttziyiy tuꞌn tel puqꞌj nchibꞌjila, ayiꞌn taqꞌnila. ");
INSERT INTO mamC_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O tzaj tyekꞌiꞌn weꞌy tzeꞌn tuꞌn nbꞌetiꞌy toj tumil, ex chin tenbꞌila toj tzaljbꞌil, quꞌn tuꞌn ktenbꞌila nwutza, chi David tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ayiꞌy nxjalil, chi Pegr, kyqꞌontza ambꞌil weꞌy, tuꞌn t-xi nqꞌmaꞌn kyeꞌy; twutzxix qa a qxeꞌchil David kyim, ex kux muqet, ex lu muqbꞌilte; atx qxol jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Me atzin David jun yolil Tyol Dios, chi Pegr. Bꞌiꞌntaq tuꞌn qa otaq tzaj tqꞌmaꞌn Dios, qa jun t-xkachmanbꞌaj tuꞌn tok te nmaq kawil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tuꞌn ikyjo, mix yoline David tiꞌjx, qalaꞌ tiꞌj Crist, a Kolil, a tuꞌntaq tjaw anqꞌin juntl majl. Ex tqꞌma qa atziꞌn Kolil minataq tuꞌn tkyij toj tjulil kyimnin, ex qa minataq tuꞌn tel puqꞌj t-xmilil, ");
INSERT INTO mamC_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","quꞌn ate qMan Dios jaw anqꞌsinte juntl majl Jesús, a Kolil; ex awotziꞌn o lonte, ex nqo yolin tiꞌj jaꞌlin qa itzꞌ te jun majx, chi Pegr. ");
INSERT INTO mamC_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jaw qꞌiꞌnte Jesús, tuꞌn tjapin tukꞌa qMan Dios tuꞌn tkawin junx tukꞌa. Tzaj tkꞌmoꞌn Xewbꞌaj Xjan, a otaq tzaj tqꞌmaꞌn Dios. Axsiꞌn a o tzaj tsipin qeꞌy, ex loqiꞌy nchi kaꞌyin ex nchi bꞌiꞌn tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nya te David jaw twutz kyaꞌj, quꞌn ikytzin tqꞌma kyjaluꞌn: Xi tqꞌmaꞌn qMan Dios te wAjawa: Qekuy toj nman qꞌobꞌa kawil wukꞌiy, ");
INSERT INTO mamC_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tzmaxiꞌ aj tkubꞌ kyiꞌjjo tajqꞌoja wuꞌn, chi Dios. ");
INSERT INTO mamC_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ayiꞌy Judiy, ayiꞌy nxjalil, chi Pegr, bꞌinkuxix kyuꞌn. Ax Jesúsjo, aj kubꞌ kybꞌyoꞌn twutz cruz, jaw anqꞌin juntl majl tuꞌn qMan Dios, tuꞌn tok qꞌoꞌn te qAjaw ex te Crist, a Kolil qiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tej kybꞌintej xjal chꞌuqleqetaq antza tiꞌjjo a yolajtz, nimxix i jaw bꞌisin, ex xi kyqanin te Pegr, a tsanjil Jesús, junx kyukꞌa txqantl: Ayiꞌy nxjalil, ¿Tzeꞌn k-okila luꞌn quꞌn? ");
INSERT INTO mamC_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Xi ttzaqꞌwin Pegr: Kux chi meltzꞌaja, ex kytxꞌixpinks kynabꞌla, tuꞌn kybꞌeta toj tumil twutz Dios, ex kux chi kuꞌxa toj aꞌ, te jawsbꞌil aꞌ teyile junjun tiꞌj tbꞌi Jesucrist, tuꞌntzin tkubꞌ najsin kyila tuꞌn qMan, ex tuꞌn ttzaj qꞌoꞌn Xewbꞌaj Xjan kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tzaj ttziyin Dios Xewbꞌaj Xjan ex jun najsbꞌil kyila te kyeꞌy, ex te kykꞌwala ex te kykyaqiljo iteꞌ najchaq; a yol luꞌn te kykyaqilxjo ayeꞌ taj qMan Dios tuꞌn kytxket, ex tuꞌn kynimin Tyol. ");
INSERT INTO mamC_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yolintzin Pegr kyukꞌa yol luꞌn ex txqantl, ex xi tqꞌmaꞌn jun tumil kyjaluꞌn: Kypaꞌmil kyibꞌa kyiꞌjjo xjal aj il, tuꞌntzintla kykleta. ");
INSERT INTO mamC_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ikytzin bꞌajjo, ayetziꞌn kubꞌ kynimin tyol Pegr, bꞌeꞌx i kuꞌx toj aꞌ te jawsbꞌil aꞌ. Tojjo qꞌij anetziꞌn, bꞌalaqa oxe mil xjal ok kychmoꞌn kyibꞌ kyukꞌa txqantl nimil. ");
INSERT INTO mamC_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kykyaqilxix qꞌiꞌntaq kyibꞌ tuꞌn tkubꞌ bꞌinchitjo kyyol tsanjil. Ex nkymojin kyibꞌ kyxolilex, i naꞌn Dios, ex ok kychmoꞌn kyibꞌ tuꞌn tkubꞌ ikyꞌsitjo Xjan Wabꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jaw kaꞌylaj kykyaqilx, tuꞌn nim techil ex nim kybꞌinchbꞌin tsanjil otaq bꞌant, tuꞌn tyekꞌit tipin Dios. ");
INSERT INTO mamC_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ayeꞌ otaq chi nimin chmoꞌnxixtaq kyibꞌ junx, ex kubꞌ kypaꞌn jniꞌ at kye kyxolilex. ");
INSERT INTO mamC_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Xi kykꞌayin kytxꞌotxꞌ ex tkyaqiljo attaq kye, ex kubꞌ kypaꞌn kypwaq kyxolilex, tzeꞌnkuxjo, a attaq tajbꞌin kye. ");
INSERT INTO mamC_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tkyaqil qꞌij n-ok kychmoꞌntaq kyibꞌ toj tnejil ja te naꞌbꞌl Dios. Ex tojile kyja, jaꞌ nkubꞌe ikyꞌsittaqjo Xjan Wabꞌj, ex tuꞌn kywaꞌn junx tukꞌa tzaljbꞌil ex tmutxbꞌil kyanmin. ");
INSERT INTO mamC_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nchi nimsintaq tbꞌi qMan Dios, ex noq tuꞌn nbꞌanttaq kyuꞌn, bꞌaꞌn ele twutz tkyaqilx xjal. Tkyaqil qꞌij nchi nimintaq txqantl xjal tuꞌn qMan Dios. Tuꞌntziꞌn ikyjo, nchmetiktaq kybꞌaj. ");
INSERT INTO mamC_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jun qꞌij, i xtaꞌj Pegr ex Juan toj tnejil ja te naꞌbꞌl Dios, teꞌ tok oxe or te qale, quꞌn antaq orjo te naꞌbꞌl Dios. ");
INSERT INTO mamC_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tojjo ja anetziꞌn, attaq jun ichin kox te titzꞌjlin. Tzuntaq nxi qꞌiꞌn kykyaqil qꞌij ex nkubꞌtaq qꞌoꞌn ttxlaj jun nim ttzi ja, Ponix tbꞌi, tuꞌn tqanin tmobꞌitz kyeꞌ xjal nchi okxtaq. ");
INSERT INTO mamC_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tej tlontej kox, teꞌ kykanin Pegr ex Juan antza, xi tqanin jun tmobꞌitz kye. ");
INSERT INTO mamC_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tej tiwle kox tuꞌn Pegr, xi tqꞌmaꞌn te: Qo tkaꞌyitza. ");
INSERT INTO mamC_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Atzin tej kox xi kaꞌyin, kubꞌ tbꞌiꞌn, ex kubꞌ tnabꞌlin qa attaq tuꞌn t-xi qꞌoꞌn te. ");
INSERT INTO mamC_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Me ante Pegr xi tqꞌmaꞌn: Ntiꞌ weꞌ npwaq; me kxel nqꞌoꞌn tey a at weꞌy. Tiꞌj tipin tbꞌi tAjaw Tkyaqil, a Jesucrist aj Nazaret, weꞌksa ex kux bꞌeta. ");
INSERT INTO mamC_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tej tqꞌmaꞌnte Pegr ikyjo, ok ttzyuꞌn tman qꞌobꞌjo kox, ex jaw tjkꞌuꞌn. Ex bꞌeꞌxsin ul kyanmin tqantz, ");
INSERT INTO mamC_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ex jaw lipin tej kox ex ok ten bꞌetil. Bꞌeꞌxsin okxtz toj tnejil ja te naꞌbꞌl Dios, me nya xkoꞌn. Ex ok ten tꞌikypajil, ex nimsil tbꞌi qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kykyaqilxjo lonte tej tbꞌet, ex tej tnimsin tbꞌi Dios, ");
INSERT INTO mamC_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bꞌeꞌx i jaw kaꞌylaj, ex bꞌeꞌx i jaw xobꞌ tiꞌjjo otaq bꞌaj tiꞌj kox, quꞌn tuꞌn ojtzqiꞌntaq kyuꞌn qa axjo ichin, a koxtaq, a qꞌuqletaq twutz nim ttzi ja, Ponix tbꞌi, a nqanintaq tmobꞌitz. ");
INSERT INTO mamC_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Atziꞌn ichin otaq qꞌanit, bꞌeꞌx ok tzoje tiꞌj Pegr ex Juan. Kykyaqil xjal jaw kaꞌylaj, ex i xi rinin tuꞌn kykanin tojjo twutz ja, Salomón tbꞌi, jaꞌ taꞌtaqjo ichin, junx tukꞌa Pegr ex Juan. ");
INSERT INTO mamC_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tej tlonte Pegr ikyjo, xi tqꞌmaꞌn kye: ¿Tiquꞌn nchi jaw kaꞌylaj kyeꞌ, ayiꞌy nxjalil, aj Israel? ¿Tiquꞌn nqo tzaj kykaꞌyiꞌn? ¿Ma awotzin qeꞌ quꞌnx qibꞌa, ma qo kubꞌ qꞌanin teꞌ ichin lo? ¿Ma tuꞌntzin qipiꞌn mo tuꞌn qwenila twutz Dios, ma bꞌant tbꞌetjo ichin lo? ");
INSERT INTO mamC_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ate Dios, a tDios Abraham, Isaac, Jacob ex kykyaqil qe ojtxe qxeꞌchil, a o tzaj qꞌonte nimxix toklin Jesús, a taqꞌnil. Ayiꞌy xi qꞌonte kye kawil te Rom, ex mix kytziyiꞌy tuꞌn t-xi tzaqpet, tej tqꞌmante Pilat. ");
INSERT INTO mamC_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Me tuꞌn tchꞌuẍil kyanmiꞌn, kykyꞌetaqa tuꞌn t-xi kyqaniꞌn tuꞌn ttzaqpaj Jesús, a xjan ex wenxix, me kyja xi kyqaniꞌn tuꞌn ttzaqpaj jun bꞌyol xjal. ");
INSERT INTO mamC_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ex ikytzin kubꞌe kybꞌyoꞌnejiy Jesús, a tAjaw chwinqil; me jaw anqꞌin juntl majl tuꞌn Dios. Ex twutzxixjo anetziꞌn, quꞌn o qliꞌy, ex bꞌiꞌn quꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Noq tuꞌn qnimbꞌila tiꞌj tipin tbꞌi Jesús, ma qꞌanit teꞌ ichin, a n-ok kykaꞌyiꞌn ex kyojtzqiꞌn. Axjo qnimbꞌila tiꞌj Jesús, atzin ma kubꞌ qꞌanin teꞌ te jun majx, ikyx tzeꞌnku ayiꞌy kykyaqilxa loqiꞌy nchi kaꞌyin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ayiꞌy nxjalil, chi Pegrjo, bꞌiꞌn wuꞌn qa ayiꞌy, junx kyukꞌa kynejila, a kawil aj Israel, i kubꞌ bꞌyoꞌnte Jesús; me mix ele kynikyꞌa te, qa ataq Tkꞌwal qMan Diosjo kubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ayiꞌy kubꞌ bꞌinchinte il; me tuꞌn ikyjo, ate Dios japin bꞌaj Tyol, a otaq tqꞌma ojtxe, noq kyuꞌn kykyaqil yolil Tyol, qa iltaq tiꞌj, tuꞌn tkyim Crist, a Kolil kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tuꞌnpetziꞌn, kymeltzꞌintz kyibꞌa, ex kybꞌinchinku kyteꞌn twutz Dios, tuꞌntzin tnajsit kyila, ");
INSERT INTO mamC_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ex tuꞌn ttzaj tsmaꞌn qMan Dios kyꞌiwbꞌil kyeꞌy noq tuꞌn Jesús, a atxix ojtxe ok qꞌoꞌn te Kolil kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Il tiꞌj, chi Pegr, tuꞌn tten Jesús toj kyaꞌj jaꞌlin, ex kmeltzꞌajil tzmaxi tojjo qꞌij, aj tkubꞌ tnikꞌuꞌn tkyaqil, ikyxjo tzeꞌnkuj tqꞌma, aj kyqꞌma xjan yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ex majxte Moisés qꞌmante kye ojtxe qxeꞌchil kyjaluꞌn: Atziꞌn tAjaw Tkyaqil, a kyDiosa, kjawil qꞌiꞌnte jun yolil Tyol Dios kyxola tzeꞌnku weꞌ. Kyniminkuy tkyaqiljo kxel tqꞌmaꞌn, ");
INSERT INTO mamC_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","quꞌn tkyaqiljo a mina nkubꞌ nimin teꞌ yolil anetziꞌn, bꞌeꞌx kꞌwel yuchꞌin kyxolxjal, chi Moisésjo. ");
INSERT INTO mamC_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ex kykyaqiljo yolil Tyol Dios, chi Pegr, tzaj xkye tukꞌa Samuel, ex jniꞌ txqantl, i yolin kyiꞌjjo qꞌij te jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ex ayetzin kyeꞌ o chi kyija toj wen tukꞌa Dios, ex tuꞌn ikyjo, etzilqiꞌy tiꞌj tkyaqiljo tqꞌma qMan Dios kyuꞌnjo yolil Tyol ojtxe. Ex ikyxjo, at kyokliꞌn tiꞌjjo kyij bꞌant tiꞌj tuꞌn Dios kyukꞌa ojtxe qxeꞌchil, quꞌn ikytziꞌn tqꞌma Dios te Abraham: Kchi kyꞌiwlitiljo kykyaqil xjal twutz txꞌotxꞌ noq tuꞌn xkachmanbꞌaj, kchi elil anqꞌin tiꞌj tyajila. ");
INSERT INTO mamC_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tej tjaw anqꞌin juntl majl Jesús tuꞌn Dios, chi Pegr, tnejil tzaj tsmaꞌn te kyeꞌy, ayiꞌy aj Judiyqiꞌy, tuꞌn kykyꞌiwlita, ex tuꞌn ttzaqpaj junjun kyeꞌ toj til. ");
INSERT INTO mamC_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tzunxtaq nyolin Pegr ex Juan kyukꞌa xjal, tej kykanin pale, junx tukꞌa kawil kye xqꞌuqil tnejil ja te naꞌbꞌl Dios, ex junx kyukꞌa jun chꞌuq Sadusey. ");
INSERT INTO mamC_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nchi qꞌojletaq, quꞌn tuꞌn nchi xnaqꞌtzintaq Pegr ex Juan kyexjal, me nya tzeꞌnku kyajtaq, quꞌn kyqꞌma Pegr ex Juan qa twutzxix jaw anqꞌin juntl majl Jesús; ex tuꞌntzin, kyij yekꞌin qa kykyaqil kyimnin chi jawitz anqꞌin juntl majl. ");
INSERT INTO mamC_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","I ok kytzyuꞌn, ex bꞌeꞌx i kux kyqꞌoꞌn toj tze, ex tojxi juntl qꞌij i jatz qꞌiꞌn, quꞌn tuꞌn otaq qoqix. ");
INSERT INTO mamC_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Me nimku kyxoljo aye i bꞌinte Tbꞌanil Tqanil kolbꞌil, bꞌeꞌx i nimin; quꞌn atziꞌn kybꞌaj oꞌkqexjo ichin, bꞌalaqa jweꞌ mil. ");
INSERT INTO mamC_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Toj junxil qꞌij ok kychmoꞌn kyibꞌ toj Jerusalén aye kawil, junx kyukꞌa nim kyoklin kyxol Judiy ex jniꞌ xnaqꞌtzil tiꞌj ojtxe kawbꞌil, ");
INSERT INTO mamC_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","exsiꞌn tnejilxix pale, Anás tbꞌi; junx tukꞌa Caifás, Juan, Lejantr ex ilaꞌ ichin t-xjalil Anás. ");
INSERT INTO mamC_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ayetziꞌn ichin lo i qꞌmante, tuꞌn kytzaj qꞌiꞌn Pegr ex Juan, tuꞌn kykubꞌ qꞌoꞌn kyxol, ex xi kyqanin kye: ¿Tiꞌn kyeꞌ kyoklin mo an tiꞌj qbꞌi nkubꞌ kybꞌinchin kyejiꞌy ikyjo? chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nojnin tanmin Pegr tukꞌa Xewbꞌaj Xjan, ex i xi ttzaqꞌwin: Noq sameqiꞌy, tnejil kawil toj tnam, exqetziꞌn nim kyokliꞌn; ");
INSERT INTO mamC_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ma tzaj kyqaniꞌn tiꞌjjo bꞌaꞌn xbꞌant quꞌn tiꞌj jun yabꞌ, tuꞌn tel kynikyꞌa tzeꞌn xqꞌanite. Kutzin. ");
INSERT INTO mamC_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kꞌaꞌ txi qqꞌmaꞌn kyeꞌy tuꞌntzin tel kynikyꞌ kykyaqilxjal aj Israel, qa oꞌkx tiꞌj tipin tbꞌi Jesucrist te Nazaret ma qꞌanit teꞌ ichin lo waꞌl kywutza. Atzin Jesús, axj kubꞌ kybꞌyoꞌn twutz cruz, ma jaw anqꞌin juntl majl tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ex ayiꞌy ikyqejiꞌy tzeꞌnku bꞌinchil ja, a nxi kyxoꞌn jun abꞌj nya wen toj kywutza, me axixpete abꞌjjo ma tzꞌokin te tqꞌuqil tẍkyin, a nimxix toklin toj aqꞌuntl. Atzin Jesúsjo a abꞌj s-el kyikyꞌiꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Me nim n-ajbꞌin Jesús te qe, quꞌn oꞌkx te Jesús Kolil, ex mix aꞌl qukꞌa aku jyete kolbꞌil te qe, quꞌn ntiꞌ toklin juntl bꞌibꞌaj tzaluꞌn twutz txꞌotxꞌ, a o tzaj qꞌmaꞌn tuꞌn Dios, a jaꞌ aku qo klete, chi Pegr. ");
INSERT INTO mamC_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mix jawe xobꞌe Pegr ex Juan, tej kyyolin kywutz kawil. Tej kylonte kawil ikyjo, bꞌeꞌx i jaw kaꞌylaj, quꞌn ayetzaj ichin nya aj uꞌjilqe, ex ntiꞌxixtaq bꞌaꞌn kyuꞌn. Me el kynikyꞌjo kawil te, qa t-xnaqꞌtzbꞌinqetaq Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ex majxjo ichin anetziꞌn, a otaq qꞌanit, attaq kyukꞌa; tuꞌntziꞌn, ntiꞌtaq tumil tuꞌn kyjaw xoꞌn yol kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tuꞌntziꞌn, xi kyqꞌmaꞌn, tuꞌn tex Pegr ex Juan tojjo chmobꞌl. Ayetzaj i kyij, ok ten chꞌotjil kyxolelix. ");
INSERT INTO mamC_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Chi chiꞌ kyjaluꞌn: ¿Tiꞌn k-okil qbꞌinchin kyiꞌjjo xjal lo? Bꞌiꞌn kyuꞌn kykyaqil aj Jerusalén, ma lonte tiꞌjjo ma bꞌant kyuꞌn, ex nlay kubꞌ qewin qa ma qꞌanitjo ichin. ");
INSERT INTO mamC_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Me tuꞌn mina tzꞌele tqaniljo lo kyxolxjal, kchi okil qxobꞌtzin, tuꞌntzin mina chi yolinil tiꞌj tbꞌi Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tej kybꞌaj chꞌotj, i okx txkoꞌn juntl majl Pegr, Juan exjo ichin, aj otaq qꞌanit, ex xi qꞌmaꞌn kye, tuꞌn mina chi yolin, ex mina chi xnaqꞌtzin tiꞌj tbꞌi Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Me xi ttzaqꞌwin Pegr ex Juan kyjaluꞌn: Kybꞌisinkuy qa wenxix twutz Dios, qa ayiꞌy tuꞌn kykubꞌ nimit, ex nya Dios, ");
INSERT INTO mamC_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","quꞌn nlay bꞌant tuꞌn mina qo yoliꞌn tiꞌjjo a o qbꞌiꞌy ex o qliꞌy. ");
INSERT INTO mamC_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","I ok xobꞌtzin juntl majl kyuꞌn kawil, me bꞌeꞌx i xi tzaqpiꞌn, quꞌn tuꞌn mix jyete kyil. Kykyaqil xjal nchi nimsintaq tbꞌi Dios tiꞌjjo otaq bꞌaj, ");
INSERT INTO mamC_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","quꞌn atziꞌn ichin qꞌanit otaq tzikyꞌ tibꞌaj kaꞌwnaq abꞌqꞌe. ");
INSERT INTO mamC_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tej kytzaqpaj Pegr ex Juan, i xiꞌ, ex ok kychmoꞌn kyibꞌ kyukꞌa nimil, ex xi kyqꞌmaꞌn tkyaqiljo otaq bꞌaj kyqꞌmaꞌn kynejil pale ex qe nim kyoklin kyxol aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tbꞌajlinxi kybꞌiꞌn tkyaqiljo nimil, i ok ten naꞌl Dios junx, ex kyqꞌma: Ay, tAjaw Tkyaqil, a te kubꞌ bꞌinchinte kyaꞌj ex txꞌotxꞌ ex ttxuyil aꞌ ex jniꞌ tiꞌchaqkul; ");
INSERT INTO mamC_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ay qꞌmante tuꞌn Xewbꞌaj Xjan, ex tzꞌibꞌiꞌn tuꞌn taqꞌnila David kyjaluꞌn: ¿Tiquꞌn ma chi jaw tiljjo tnam aj il? ¿Ex tiquꞌn nkubꞌ kyximin kyxim ntiꞌ tnabꞌl? ");
INSERT INTO mamC_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ayeꞌ nmaq kawil twutz txꞌotxꞌ i qꞌojin, ex i ok kychmoꞌn kyibꞌ, tuꞌn kyximin tiꞌtaqjo tuꞌntaq tbꞌant kyuꞌn tiꞌjjo qMan Dios, ex tiꞌjjo Crist, a qꞌoꞌntz te Kolil. ");
INSERT INTO mamC_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Twutzx teꞌ, chi chiꞌ, qa i ok kychmoꞌn Herodes ex Poncio Pilat kyibꞌ tzaluꞌn toj Jerusalén, junx kyukꞌa aj Israel ex kyukꞌa nya aj Israel, tuꞌn kyjyon qꞌoj tiꞌj xjan taqꞌnila Jesús, aj jaw tskꞌoꞌn te Kolil. ");
INSERT INTO mamC_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ikypetziꞌn, kubꞌ kybꞌinchin tkyaqiljo a otaq tqꞌmay qa iltaq tiꞌj tuꞌn tbꞌaj. ");
INSERT INTO mamC_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ay, qAjaw, chi chiꞌ, atzin jaꞌlin, bꞌintzinjiy tiꞌjjo ma kyqꞌma qiꞌja, ex qꞌontza tumil qeꞌy, awoꞌy taqꞌnila, tuꞌn mina qo xobꞌiꞌy, aj qyoliꞌn tiꞌj Tyola. ");
INSERT INTO mamC_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ex noqit tuꞌn tipiꞌn chi qꞌanit yabꞌ, ex tuꞌn tbꞌant nim techil tiꞌj tipin tbꞌi xjan taqꞌnila, Jesús, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tej kybꞌaj naꞌn Dios, bꞌeꞌx tzaj luꞌlinj txꞌotxꞌ jaꞌ chꞌuqleqetaq, ex kykyaqilx noj kyanmin tuꞌn Xewbꞌaj Xjan, ex i xiꞌ yolil Tyol Dios tukꞌa tkyaqil kyanmin. ");
INSERT INTO mamC_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nimku kybꞌajjo nimil, ex kykyaqilx n-oktaq kymujbꞌin kyibꞌ, ex junxtaq kybꞌis toj kynimbꞌil. Mix aꞌl jun qꞌmante, qa noq te te, aku tzꞌokineꞌ a jniꞌ attaq te, qalaꞌ tkyaqil at toklin tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ex ayetziꞌn tsanjil nchi yolintaq tiꞌjjo tjawlintz anqꞌin Jesús juntl majl, a tAjaw Tkyaqil, quꞌn tuꞌn otaq kyli. Ex nimxix kubꞌ kyꞌiwlin kykyaqilx tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ntiꞌtaq jun yaj kyxol, quꞌn ayetziꞌn attaq kytxꞌotxꞌ ex kyja, bꞌeꞌxtaq nxi kykꞌayin. ");
INSERT INTO mamC_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Atziꞌn pwaq nxi kyqꞌoꞌntaq kye tsanjil, tuꞌn tkubꞌ sipit teyile junjun, qa attaq tajbꞌin kye. ");
INSERT INTO mamC_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ikytzin bꞌajjo tiꞌjjo jun ichin, Jse tbꞌi, tzajnintaq toj txꞌotxꞌ Chipre, ex attaq toklin kyxol t-xjalil qtzan Leví. Atzin te Jse ok qꞌoꞌn juntl tbꞌi kyuꞌn tsanjil, Bernabé, atzin tzꞌelpineꞌ, aj qꞌuqbꞌil kꞌuꞌjbꞌaj. ");
INSERT INTO mamC_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Attaq te Jse ttxꞌotxꞌ, ex bꞌeꞌx xi tkꞌayin; atzin pwaq xi tqꞌoꞌn kye tsanjil. ");
INSERT INTO mamC_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Me attaq jun ichin, Ananías tbꞌi, junx tukꞌa t-xuꞌjil, Safira, xi kykꞌayin jun tnej kytxꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","I yolin, ex i kyij toj wen tuꞌn tkyij kyiꞌn chꞌin pwaq, a tzaj kytzyuꞌn te twiꞌ kytxꞌotxꞌ. Me atziꞌn txqantl xi tqꞌoꞌn Ananías kye tsanjil. ");
INSERT INTO mamC_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Xi tqꞌmaꞌn Pegr te: Ay Ananías, ¿Tiquꞌn xi ttziyin tuꞌn tokx tajaw il toj tanmin, tuꞌn xkyij ttzyuꞌnjiy chꞌin pwaq, a saj qꞌoꞌn tey, tej xi kꞌayit ttxꞌotxꞌa? Tuꞌntziꞌn, ma nikyꞌin yol te Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ma nyatzin tetaqa txꞌotxꞌ? ¿Exsin teꞌ xi tkꞌayiꞌn, ma nyatzin tetaqtza tkyaqil pwaq? ¿Tiquꞌn xkubꞌ tewin qeꞌy? ¿Ex tiquꞌnil xkubꞌ t-ximin tuꞌn tkubꞌ bꞌinchitjo ikyjo, noq te yekꞌbꞌil tibꞌa, qa jun tbꞌanil nimila? Me tojjo lo, nya kye ichin ma nikyꞌiniy yol, qalaꞌ te Dios. ");
INSERT INTO mamC_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tej tbꞌaj tbꞌiꞌn Ananías ikyjo, bꞌeꞌx kyim, ex kykyaqiljo i bꞌinte bꞌeꞌx tzaj kyxobꞌil. ");
INSERT INTO mamC_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tbꞌajlinxiꞌ ikyjo, i tzaj ilaꞌ kuꞌxin qꞌa kubꞌ kyptzoꞌn kyimnin, ex xi kyiꞌn, tuꞌn tkux muqet. ");
INSERT INTO mamC_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Otaqla bꞌaj oxe or ikyjo, tej tokxjo t-xuꞌjil Ananías jaꞌ iteꞌtaq tsanjil. Me ntiꞌtaq bꞌiꞌn tuꞌn, tiꞌ otaq bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Xi tqanin Pegr te: ¡Qꞌmantziꞌn weꞌy! ¿Qa oꞌkx twiꞌ txꞌotxꞌjo s-ok, a ma txi kykꞌayiꞌn? Xi ttzaqꞌwin Safira: Twutzx, oꞌkx teꞌ twiꞌ s-ok, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Xi tqꞌmaꞌn Pegr te: ¿Tiquꞌnil xbꞌant tiꞌj kyuꞌn, tuꞌn tok kyyekiꞌn Xewbꞌaj Xjan? Loqeꞌ chi txaꞌj muqil tiꞌj qtzan tchmila chi ul, ex atzin jaꞌlin ma cheꞌx muqul tey. ");
INSERT INTO mamC_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Texjo or anetziꞌn, bꞌeꞌx kyim Safira t-xe tqan Pegr. Tej kyokxjo kuꞌxin qꞌa, noq kyimnel. Tej tiwle, bꞌeꞌxsin xi kyiꞌntz, tuꞌn tkux muqet ttxlajjo qtzan tchmil. ");
INSERT INTO mamC_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ex kykyaqil nimil ex jniꞌ xjal, aye i bꞌinte, bꞌeꞌx i xobꞌ tuꞌn ikyjo. ");
INSERT INTO mamC_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Noq kyuꞌn tsanjil i bꞌante nim techil te yekꞌbꞌil tipin Dios kyxol xjal. Ex kykyaqil nimil ok kychmoꞌn kyibꞌ toj tnejil ja te naꞌbꞌl Dios twiꞌ peꞌn, Salomón tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kyxoljo txqantl, attaq txqan kyxobꞌil tuꞌn tok kymujbꞌin kyibꞌ kyukꞌa nimil, me i tzalaj tiꞌjjo nbꞌanttaq kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tuꞌntziꞌn, chmet kybꞌaj, quꞌn ilaꞌ ichin ex qya kubꞌ kynimin Tyol tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ex nchi bꞌajxi kyiꞌntaq yabꞌ kyoj bꞌe kyibꞌaj tal kypop ex kyibꞌaj iqbꞌil kye yabꞌ, tuꞌntzintla aj tikyꞌ Pegr, iꞌchaqtla oꞌkx t-xlekemil aku pontaq kanin kyibꞌaj junjun yabꞌ, tuꞌn kykubꞌ qꞌanit. ");
INSERT INTO mamC_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ex at txqan xjal tzaj kyojjo tnam nqayin, tuꞌn kyul kanin toj Jerusalén. Tzaj kyiꞌn kyyabꞌ exqetziꞌn xjal tzyuꞌnqetaq kyuꞌn taqꞌnil tajaw il. Ex kykyaqilx bꞌeꞌx i qꞌanit. ");
INSERT INTO mamC_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aj tnejilxix pale, junx kyukꞌa jun chꞌuq Sadusey, bꞌeꞌx i jaw xkyꞌaqlin kyiꞌjjo tsanjil. ");
INSERT INTO mamC_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ex tuꞌntziꞌn, bꞌeꞌx i ok tzyuꞌn, ex bꞌeꞌx i kuꞌx tjpuꞌn toj ttze te tnam. ");
INSERT INTO mamC_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Me toj qnikyꞌin, ul jun t-angel tAjaw Tkyaqil jqolte tjpel tze tuꞌn kyetz, ex xi tqꞌmaꞌn kye: ");
INSERT INTO mamC_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Kux cheꞌxa toj tnejil ja te naꞌbꞌl Dios, tuꞌn t-xi kyqꞌmaꞌn kye xjal antza tiꞌjjo tkyaqil t-xilin akꞌaj chwinqil. ");
INSERT INTO mamC_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Toj junxil qꞌij qlixjexix, i okx toj tnejil ja te nabꞌl Dios tuꞌn t-xnaqꞌtzit tkyaqiljo a otaq kybꞌi, tzeꞌn tzaj tqꞌmaꞌn angel. Tzuntaq nchi xnaqꞌtzin tsanjil, atzin tej tnejilxix pale exqetziꞌn iteꞌtaq tukꞌa, i tzaj kytxkoꞌn nim kyoklin kyxol aj Israel, tuꞌn tok kychmoꞌn kyibꞌ toj Sanedrín, a tnejilxix chmobꞌl kyxol aj Judiy. Tej kychmet, bꞌeꞌx xi kysmaꞌn xqꞌuqil, tuꞌn kyxi iqꞌbꞌajjo tsanjil, a iteꞌkuxtaq toj tze. ");
INSERT INTO mamC_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Me tej kykanin antza, mix i jyetil. Tuꞌntziꞌn, bꞌeꞌx i meltzꞌaj tukꞌa tqanil, ");
INSERT INTO mamC_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ex kyqꞌma: Tej xqo kaniꞌn, chebꞌe jpuꞌn te tze, ex ayetzin kyeꞌ xqꞌuqil waꞌlqe kyeꞌ ttzi. Me tej s-okx qjqoꞌn, mix aꞌltaq jun tokx. ");
INSERT INTO mamC_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tej tbꞌinte tnejilxix pale, exsin tnejil xqꞌuqil ja te naꞌbꞌl Dios, exqetziꞌn nmaq pale, i jaw chꞌotj kyxolx, ex kyqꞌma: ¿Tzeꞌntzila kpon bꞌajile lo? ");
INSERT INTO mamC_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tzuntaqtzin nchi yolin, tej tkanin jun xjal, ex xi tqꞌmaꞌn kye: ¡Ayetzaj ẍi kux kyqꞌoꞌn toj tze, loqe kyeꞌ nchi xnaqꞌtzin kye xjal toj tnejil ja te naꞌbꞌl Dios! ");
INSERT INTO mamC_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ayetzin kyej xqꞌuqil, junx tukꞌa kynejil, bꞌeꞌx i xtaꞌj tzyulkye tsanjil, tuꞌn kyul toj Sanedrín. Me chebꞌe i tzaj qꞌiꞌn, quꞌn tuꞌn attaq kyxobꞌil xqꞌuqil tuꞌn kyok xoꞌn tuꞌn abꞌj kyuꞌnxjal. ");
INSERT INTO mamC_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tej kykanin toj Sanedrín, antej tnejilxix pale xi tqꞌmaꞌn kye tsanjil: ");
INSERT INTO mamC_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","¿Ma nya otaq txi qqꞌmaꞌn kujxix wen kyeꞌy, tuꞌn mina chi xnaqꞌtzinila tiꞌjjo ichin Jesús? ¿Me titziꞌn ma kubꞌ kybꞌinchiꞌn? Ma bꞌaj kyyoliꞌn kyxol kykyaqil xjal te Jerusalén a xnaqꞌtzbꞌil. Ex kyaja tuꞌn tok kyqꞌoꞌn te qpaja a tkyimliꞌn ichin anetziꞌn, chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Xi ttzaqꞌwin Pegr exqetziꞌn txqantl tsanjil: Ate qMan Dios ilxix tiꞌj tuꞌn tkubꞌ qnimiꞌn, ex nya aye ichin. ");
INSERT INTO mamC_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","A qMan Dios, a kyDios ojtxe qxeꞌchil jatz anqꞌsinte juntl majl Jesús, aj kubꞌ kybꞌyoꞌn twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","O jaw tiꞌn qMan Dios, ex o txi qꞌoꞌn toklin tuꞌn tkawin junx tukꞌa, ex o tzꞌok qꞌoꞌn te Tnejil ex te Kolil, tuꞌntzin tajtz tiꞌj qanim, qkyaqil awo aj Israel, ex tuꞌn tkubꞌ tnajsin qil. ");
INSERT INTO mamC_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tkyaqiljo lo o qliꞌy, ex nqo yoliꞌn tiꞌj, junx tukꞌa Xewbꞌaj Xjan, a o tzaj tqꞌoꞌn qMan Dios kyeꞌ nchi kubꞌ niminte, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tej kybꞌinte ikyjo, bꞌeꞌx i jaw txꞌuꞌjin, ex kubꞌ kybꞌisin tuꞌn kykubꞌ bꞌyet. ");
INSERT INTO mamC_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Me kyxoljo kawil, attaq jun Parisey, Gamaliel tbꞌi, a toktaq te xnaqꞌtzil tiꞌj ojtxe kawbꞌil, ex nimtaq toklin kyuꞌnxjal. Jaw weꞌks, ex xi tqꞌmaꞌn, tuꞌn kyex qꞌiꞌn jun paqjo tsanjil. ");
INSERT INTO mamC_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tbꞌajlinxiꞌ ikyjo, xi tqꞌmaꞌn kye txqantl kawil: Ayiꞌy nxjalil, aj Israel, kynabꞌlinkuy tiꞌjjo kꞌwel kybꞌinchiꞌn kyiꞌjjo ichin lo. ");
INSERT INTO mamC_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kynaꞌntza, aj bꞌaj tiꞌj Teudas atxix ojtxe, tej tqꞌma kujxix wen qa ataq nimxtaq toklin, ex kyaje syent ichin i ok lipe tiꞌj. Me tej tkubꞌ bꞌyoꞌn, bꞌeꞌx el kylaqꞌwin, ex xiꞌ kysipin kyibꞌjo lipcheqetaq tiꞌj, ex ikytzin pon bꞌaje tkyaqil tbꞌis Teudas. ");
INSERT INTO mamC_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tbꞌajlinxiꞌ ikyjo, chi Gamaliel, jaw tiꞌn tibꞌ jun ichin te Galiley, Judas tbꞌi, toj kyqꞌijil aj tzꞌibꞌil kybꞌixjal, ex kubꞌ kykꞌuꞌj ilaꞌ xjal, tuꞌn kyok lipe tiꞌj. Me ex ikyxjo, bꞌeꞌx kubꞌ bꞌyoꞌn; ayetziꞌn lipcheqetaq ex bꞌeꞌx xi kysipin kyibꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tuꞌnpetziꞌn, chi Gamaliel, kxel nqꞌoꞌn jun tumil kyeꞌy, tuꞌn kyxi kytzaqpinjiꞌy xjal lo, ex mina tzꞌokx kylimoꞌn kyibꞌa kyxol, quꞌn noqx kꞌwel najjo nbꞌant kyuꞌn, qa noq tnabꞌl ichin. ");
INSERT INTO mamC_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Me qa tuꞌn qMan Diosjo lo, nlay chi kanbꞌiꞌn kyiꞌj. Qalaꞌ bꞌaꞌnqexi, quꞌn noq chi jyoꞌn qꞌoj tukꞌa Dios. Ayetzaj xjal kubꞌ kynimiꞌn chꞌin tumil tzaj qꞌmaꞌn kye tuꞌn Gamaliel. ");
INSERT INTO mamC_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","I tzajtzin qꞌolbꞌiꞌn tsanjil, ok jubꞌchin, ex xi qꞌmaꞌn kye, tuꞌn ntiꞌxl tuꞌn kyyolin tiꞌj tumil tbꞌi Jesús. Tbꞌajlinxitzin ikyjo, i xi tzaqpiꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","I etztzin tsanjil kywutz kawil, ex i tzalaj, quꞌn ttziye Dios tuꞌn tikyꞌx kyuꞌn, noq tuꞌn tpajjo kynimbꞌil tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Me nya tuꞌn ikyjo, mix i yoliniltl, qalaꞌ kykyaqil qꞌij, i xnaqꞌtzin, ex i yolin toj tnejil ja te naꞌbꞌl Dios ex kyojile junjun ja, tiꞌjjo Tbꞌanil Tqanil kolbꞌil tiꞌj Jesús, a Crist. ");
INSERT INTO mamC_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kyojjo qꞌij anetziꞌn, liwey i chꞌiy kybꞌajjo nimil. Tuꞌntzintzjo, ayetzaj nchi yolintaq griego jaw wulj kyiꞌjjo nchi yolintaq ebrey, ex kyqꞌma qa minataq ntzaj qꞌoꞌnxix kyokliꞌn qya mebꞌe, ayeꞌ iteꞌtaq kyxol, tzeꞌnku nkubꞌ paꞌntaqjo mojbꞌil, a ntzaj qꞌoꞌn kyuꞌn tsanjil te junjun qꞌij. ");
INSERT INTO mamC_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ok chmoꞌn kykyaqil nimil kyuꞌn kabꞌlajaj tsanjil, ex kyqꞌma: Nya wen tuꞌn tkyij qtzaqpiꞌn tuꞌn qyolin tiꞌj Tyol qMan Dios, exsin oꞌkxtza tuꞌn qkubꞌe tena sipil teꞌ tkyaqiljo n-ajbꞌin kye mebꞌe qya anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tuꞌnpetziꞌn, ayiꞌy werman, kyskꞌoꞌnksa kyxolxa wuq ichin bꞌaꞌn kychwinqil, tzꞌaqle kynabꞌl, ex nojnin kyanmin tukꞌa Xewbꞌaj Xjan, tuꞌntzin t-xi qqꞌoꞌn kyoklin, tuꞌn kyaqꞌnin tiꞌjjo aqꞌuntl lo. ");
INSERT INTO mamC_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Qalaꞌ, awotzintla qeꞌ tuꞌn qnaꞌn Dios, ex tuꞌn qyoliꞌn tiꞌjjo Tyol, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kykyaqilx i kyij toj wen tiꞌjjo tumil, ex jaw skꞌoꞌn Esteban, jun ichin nojnin tanmin tukꞌa Xewbꞌaj Xjan ex nim tnimbꞌil; junx tukꞌa Lip; Prócoro; Nicanor; Timón; Parmenas; ex Nicolás, a tzajnin te Antyokiy. A ichin lo, otaq nimin tiꞌj kynimbꞌil Judiy, me nya jun Judiy te titzꞌjlin. ");
INSERT INTO mamC_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tej kybꞌaj skꞌoꞌn wuq ichin kyxol nimil, bꞌeꞌx i xi qꞌiꞌn jaꞌ iteꞌtaq tsanjil. Tej kykanin antza, kubꞌ kyqꞌoꞌn tsanjil kyqꞌobꞌ kyibꞌaj, ex i naꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tuꞌnpetziꞌn tkyaqiljo lo, liwey chꞌiy tyolajtzjo Tyol Dios. Tuꞌntziꞌn, chmet txqantl kybꞌajjo nimil toj Jerusalén; ex nimku pale Judiy xi kynimiꞌn nimbꞌil. ");
INSERT INTO mamC_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nkubꞌ tbꞌinchintaq Esteban techil tipin Dios kyxolxjal, quꞌn tuꞌn nojnintaq tanmin tuꞌnxjo tipin ex tkyꞌiwbꞌil Dios. ");
INSERT INTO mamC_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Iteꞌtaq junjun xjal toj ja te naꞌbꞌl Dios, Tzaqpiꞌntaq tbꞌi, junx kyukꞌa jteꞌbꞌintl te aj Cirene, ex te Alejandría, ex te Cilicia, ex te aj txꞌotxꞌ te Asia. Ayetzaj xjal, i ok ten chꞌotjil tukꞌa Esteban, ");
INSERT INTO mamC_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","me mix i xkyeye kyyolin, quꞌn ante Esteban nyolintaq teꞌ toj tumil, ex tukꞌa tnabꞌl, a ntzajtaq tqꞌoꞌn Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tuꞌn mix xkyeye kyyolin, i chjet jun jteꞌbꞌin xjal kyuꞌn, ayeꞌ nya wenqetaq, tuꞌn tkubꞌ kysbꞌuꞌn, ex tuꞌn t-xi kyqꞌmaꞌn qa otaq kybꞌi paꞌj yol tuꞌn Esteban tiꞌj Moisés ex tiꞌj Dios. ");
INSERT INTO mamC_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ikytzin oke kyuꞌn, tuꞌn tjaw tiljxjal. Ex ayeꞌ nim kyoklin, junx kyukꞌa xnaqꞌtzil tiꞌj ojtxe kawbꞌil i xi tꞌilpaj tzyulte Esteban. Tej ttzyet kyuꞌn, bꞌeꞌx xi kyiꞌn twutz Sanedrín, ");
INSERT INTO mamC_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ex i ok kyjyoꞌn xjal iqil yolqe, ayej kyqꞌma: A ichin lo minax nkubꞌ qen tuꞌn t-xoꞌn yol tiꞌjjo xjan qja te naꞌbꞌl Dios ex tiꞌjjo kawbꞌil. ");
INSERT INTO mamC_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","O qbꞌi qeꞌ, tej tqꞌma qa ok kꞌwel tyuchꞌin Jesús te Nazaret tnejil qja te qnaꞌbꞌl Dios, ex kjawil ttxꞌixpin tzeꞌn nqo anqꞌina tzeꞌnkux tzaj tqꞌmaꞌn Moisés. ");
INSERT INTO mamC_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ayetzaj kawil exqetziꞌn kykyaqiljo qꞌuqleqetaq antza toj Sanedrín, tej tok kykaꞌyin twutz Esteban tukꞌa jun tzaljbꞌil, ex el kynikyꞌ qa ikytaq twutzjo tzeꞌnku jun angel. ");
INSERT INTO mamC_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Atzin teꞌ tnejilxix pale xi tqanin te Esteban, qa twutzxixtaqjo otaq qꞌumle tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Xi ttzaqꞌwin Esteban kyjaluꞌn: Ayiꞌy nxjalil, ex noq sameqiꞌy tata, kybꞌinkuy nyola. A qMan Dios, a nimxix toklin, xi tyekꞌin tibꞌ te ojtxe qxeꞌchil Abraham, tej najletaq toj txꞌotxꞌ te Mesopotamia, atxix tej naꞌmtaq t-xiꞌ najal toj txꞌotxꞌ te Harán, ");
INSERT INTO mamC_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ex tqꞌma Dios kyjaluꞌn: Tzaqpinkj ttxꞌotxꞌa exqetziꞌn t-xjalila, ex kux txiꞌy tzmax tojjo txꞌotxꞌ, a kxel nyekꞌin tey, chi Diosjo. ");
INSERT INTO mamC_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Bꞌeꞌxsin etz Abraham tojjo txꞌotxꞌ te Caldey, tuꞌn t-xiꞌ najal toj Harán. Antza kyime ttata, ex a Dios ul qꞌiꞌnte Abraham tojjo txꞌotxꞌ lo, Canaán tbꞌi, ja najleqiꞌy jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Me tojjo txꞌotxꞌ lo, mix xi qꞌoꞌne chꞌin ttxꞌotxꞌ, iꞌchaqpetla noq chꞌin netzꞌ, jaꞌ tuꞌn tkubꞌe weꞌ, quꞌn nya te te Abrahamjo txꞌotxꞌ lo, qalaꞌ xi ttziyin Dios, tuꞌn t-xi tqꞌoꞌn kye tyajil, me tzmaxitaqjo aj tkyim. Ex naꞌmtaqpe kyul te Abraham tkꞌwal, tej tyolajtzjo lo. ");
INSERT INTO mamC_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ex tqꞌma Dios te Abraham, qa tuꞌntaq kynajan tyajil tzeꞌnku qe bꞌetin xjal toj jun txꞌotxꞌ nya ojtzqiꞌn kyuꞌn, ex qa tuꞌn kyok te aqꞌnil, me ntiꞌ twiꞌ kykꞌuꞌj; ex tojjo kyaje syent abꞌqꞌe, tuꞌntaq kybꞌaj yisoꞌn, ex nimxtaq yajbꞌil tuꞌn tikyꞌx kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Me ex tqꞌma Dios te Abraham kyjaluꞌn: Ok chi kꞌwel nkawiꞌn weꞌ xjal, a k-okil qꞌonkye tyajila te aqꞌnil, a nya chjoꞌn twiꞌ kykꞌuꞌj. Tbꞌajlinxiꞌ ikyjo, ok chi elitz tyajila antza, ex chi ajbꞌil weꞌy tojjo txꞌotxꞌ lo, chi Dios. ");
INSERT INTO mamC_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","9","Tej tkyij bꞌant tiꞌjjo yol luꞌn, chi Esteban, xi tqꞌmaꞌn Dios te Abraham, tuꞌn tok qitit kyechiljo qꞌa tiꞌj kytzꞌumil, te jun techil qa te teqetaq Dios. Tuꞌnpetziꞌn, tojxi twajxaqin qꞌij titzꞌjlin tkꞌwal Abraham, Isaac tbꞌi, ex bꞌeꞌx kubꞌ qitin ttzꞌumil te techil tuꞌn ttata. Ex ikyx bꞌantjo tuꞌn Isaac tukꞌa tkꞌwal, Jacob tbꞌi. Ex ikyx bꞌantjo tuꞌn Jacob kyukꞌa kabꞌlajaj tkꞌwal qꞌa, ayej i ok te qxeꞌchil awo, a o tokx kyojjo kabꞌlajaj chꞌuq xjal te Israel. Me lajajtaqjo tkꞌwal Jacob, a nchi xkyꞌaqlintaq tiꞌj kyitzꞌin, Jse tbꞌi, tuꞌn kꞌuꞌjlinxixtaq tuꞌn manbꞌaj, ex bꞌeꞌx xi kꞌayin kye xjal aj Egiptoqetaq. Me attaq tkyꞌiwbꞌil Dios tibꞌaj Jse. ");
INSERT INTO mamC_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tuꞌnpetziꞌn, bꞌeꞌx tzaqpaj toj tkyaqil bꞌisbꞌajil, ex tzaj qꞌoꞌn tumil tnabꞌl. Tuꞌntziꞌn, ok kꞌuꞌjlin tuꞌn Faraón, a tnejil kawil toj Egipto, ex ok qꞌoꞌn te tkabꞌ kawil toj tkyaqil Egipto ex tojjo nmaq ja kye kawil. ");
INSERT INTO mamC_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tbꞌajlinxi ikyjo, ul nim waꞌyaj ex nim yajbꞌil toj tkyaqil Egipto ex tzaluꞌn toj Canaán, jaꞌ najleqetaq ojtxe qxjalil, ex ntiꞌtaq kywa. ");
INSERT INTO mamC_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Me atzaj teꞌ tbꞌinte Jacob, qa attaq triy toj Egipto, bꞌeꞌx i xi tchqꞌoꞌn qe tkꞌwal, aye qxeꞌchil, antza. Me toj tnejil kybꞌe tzma Egipto, i yolin tukꞌa Jse, me mix ele kynikyꞌ te, qa ataqjo kyitzꞌin. ");
INSERT INTO mamC_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tej kyxtaꞌj toj tkabꞌ majin, xi tqꞌmaꞌn Jse: Ayiꞌn weꞌ kyitzꞌiꞌn. Tzmaxitziꞌn, el tnikyꞌ Faraón alkyetaq t-xjalil Jse. ");
INSERT INTO mamC_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tbꞌajlinxitziꞌn ikyjo, xi tqꞌmaꞌn Jse tuꞌn tul kanin Jacob, a ttata, toj Egipto, junx kyukꞌa kykyaqil t-xjalil. Atziꞌn kybꞌaj xtaꞌj, jweꞌlajaj toj jun mutxꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ikytzin bꞌajjo, bꞌeꞌx xiꞌ Jacob najal toj Egipto, ex antza kyime; ex ikyqexjo tkꞌwal, aye ojtxe qxeꞌchil, antza i kyime. ");
INSERT INTO mamC_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tej tkyim Jacob, tzaj qꞌiꞌn t-xmilil toj txꞌotxꞌ te Siquem, ex okx muquꞌn antza toj jun tjulil kyimnin, a otaq tloqꞌ Abraham tukꞌa nim pwaq kye tkꞌwal Hamor. ");
INSERT INTO mamC_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tbꞌajlinxitziꞌn ilaꞌ abꞌqꞌe, otaq chꞌiy kybꞌaj aj Israel, a tyajil Jacob, toj txꞌotxꞌ te Egipto, tej chꞌixtaq tul kanin tqꞌijiljo, a jaꞌ tuꞌntaq ttzaj tqꞌoꞌn Dios txꞌotxꞌ kye tyajil Abraham, a tzeꞌn otaq tqꞌma. ");
INSERT INTO mamC_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ex kyojjo qꞌij anetziꞌn, xi xkye tkawbꞌil jun kawil toj Egipto, me nyataq bꞌiꞌn jun tqanil tuꞌn tiꞌj Jse. ");
INSERT INTO mamC_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Atej kawil anetziꞌn i kubꞌ tsbꞌuꞌn, ex i ok tyisoꞌn ojtxe qxeꞌchil, quꞌn nim kybꞌaj. Ex xi tqꞌmaꞌn kye tuꞌn tkyij kykoliꞌn kyneꞌẍ, a aye qꞌa, tuꞌn kykyim, a aꞌkxtaq kyitzꞌje. ");
INSERT INTO mamC_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tojjo kawbꞌil anetziꞌn itzꞌje Moisés, chi Esteban. Tbꞌanilx ele qꞌa anetziꞌn twutz Dios, ex jaw chꞌiy oxe xjaw toj tja ttata. ");
INSERT INTO mamC_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Atzaj teꞌ tuꞌntaq tkyij tkoliꞌn, bꞌeꞌx jaw qꞌiꞌn tuꞌn jun qya, tkꞌwal Faraón, ex jaw chꞌiysin nyakuj tzeꞌnku jun albꞌaj. ");
INSERT INTO mamC_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ikytzin xnaqꞌtzajtz Moisésjo toj tkyaqil tumil kyxol aj Egipto, ex japin te jun ichin nim toklin kyuꞌn tyol ex kyuꞌn tbꞌinchbꞌin. ");
INSERT INTO mamC_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tej tjapin Moisés te kaꞌwnaq abꞌqꞌe, kubꞌ tbꞌisin tuꞌn t-xi qꞌolbꞌil kyeꞌ t-xjalil, ayej tyajil Jacob. ");
INSERT INTO mamC_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tej t-xiꞌ, ok tkaꞌyin jun bꞌujbꞌil tuꞌn jun aj Egipto tiꞌj jun t-xjalil Moisés. Bꞌeꞌx okx tlimoꞌn Moisés tibꞌ te kolil, ex bꞌeꞌx kubꞌ tbꞌyoꞌn aj Egipto. ");
INSERT INTO mamC_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tuꞌn bꞌant tuꞌn, kubꞌ tbꞌisin Moisés qa akutaq tzꞌel kynikyꞌjo t-xjalil te, qa attaq toklin tuꞌn Dios tuꞌn kytzaqpajjo t-xjalil tjaqꞌ tkawbꞌil aj Egipto. Me mix ele kynikyꞌ te. ");
INSERT INTO mamC_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tojxi junxil qꞌij, ok tkaꞌyin Moisés kabꞌe aj Israel nchi bꞌujintaq, ex i el tpaꞌn, ex tqꞌma: Kyxjalil kyeꞌ kyibꞌ. ¿Titzin quꞌn nchi bꞌujintza? ");
INSERT INTO mamC_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Me atzin tej nbꞌujintaq tiꞌj tukꞌa, bꞌeꞌx etz limoꞌn Moisés tuꞌn, ex tqꞌma: ¿Ankyenaj te s-ok qꞌonte te nim toklin ex te kawil qxola? ");
INSERT INTO mamC_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ma taja tuꞌn nkubꞌ tbꞌyoꞌn tzeꞌnkuj tkubꞌ tbꞌyoꞌnjiy jun aj Egipto ewe? ");
INSERT INTO mamC_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tej tbꞌinte Moisésjo ikyjo, bꞌeꞌx tzaj xobꞌ, quꞌn kyjaꞌtaq tel tqanil, ex bꞌeꞌx oq, ex xiꞌ toj txꞌotxꞌ te Madián. Antza, najan tzeꞌnku jun bꞌetin xjal, ex ok meje tukꞌa jun qya, ex itzꞌje kabꞌe tkꞌwal. ");
INSERT INTO mamC_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Tbꞌajlinxiꞌ kaꞌwnaq abꞌqꞌe antza, tej tok tyekꞌin jun angel tibꞌ toj tqꞌaqꞌil tqan txꞌiꞌx tzunxtaq nkꞌant wen, tojjo jun tzqij txꞌotxꞌ ja ntiꞌ najbꞌil, a at tkꞌatzjo wutz, Sinaí tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bꞌeꞌx jaw kaꞌylaj te Moisés tiꞌjjo otaq tlonte, quꞌn tuꞌn mix jaꞌ nkubꞌe bꞌajetaqjo tqan txꞌiꞌx tuꞌn qꞌaqꞌ. Atzaj teꞌ tok laqꞌe tuꞌn tlontexix wen, xi tbꞌiꞌn tqꞌajqꞌojil twiꞌ tAjaw Tkyaqil. Chi kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ayin weꞌ kyDios ojtxe t-xjalila, ex ayin weꞌ tDios Abraham, te Isaac, ex te Jacob. Bꞌeꞌxsin ok ten Moisés luꞌlil tuꞌn t-xobꞌil, ex mix jaw kaꞌyin. ");
INSERT INTO mamC_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Xitzin tqꞌmaꞌn tAjaw Tkyaqil te kyjaluꞌn: Qꞌinqemil t-xjabꞌa, quꞌn atzin txꞌotxꞌ luꞌn xjanxix wen. ");
INSERT INTO mamC_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Twutzxix ma nliꞌy nya bꞌaꞌn ma tzikyꞌx tuꞌn Ntanima tzachiꞌn toj Egipto. Tzunx nchi latꞌinx tzeꞌn ncheꞌx nbꞌiꞌn; tuꞌnpetziꞌn, ma chin kꞌula kolil kyiꞌj. Atzin jaꞌlin, kxel nchqꞌoꞌn tzma Egipto kolil Ntanima, chi Diosjo te Moisés. ");
INSERT INTO mamC_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ax te Moisésjo, a el kyikyꞌin ojtxe qxjalil, a aye iteꞌxtaq toj Egipto, ex otaq tzaj qꞌmaꞌn te: ¿Ankyenaj te s-ok qꞌonte te nim toklin ex te kawil qxola? Exla qa otaq tzꞌel iꞌjlin kyuꞌn aj Israel, chi Esteban, me ate Dios, tuꞌn angel, a ok tyekꞌin tibꞌ toj tqꞌaqꞌil tqan txꞌiꞌx, xi chqꞌonte Moisés, tuꞌn tok te nimxix toklin, ex te tzaqpilkye aj Israel toj Egipto. ");
INSERT INTO mamC_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ex ate Moisés etz qꞌinkye ojtxe qxjalil toj txꞌotxꞌ Egipto, ex tuꞌn bꞌant nim techil tipin Dios tojjo txꞌotxꞌ anetziꞌn, ex toj ttxuyil aꞌ, Chikyꞌ tbꞌi, ex tojjo tzqij txꞌotxꞌ, jaꞌ ntiꞌ najbꞌil. Jotxjo luꞌn bꞌant toj kaꞌwnaq abꞌqꞌe. ");
INSERT INTO mamC_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ex ax Moisés xi qꞌmante kye aj Israel kyjaluꞌn: Axte qMan Dios k-elitz qꞌinte jun yolil Tyol Dios kyxola tzeꞌnku weꞌ. Il tiꞌj tuꞌn tkubꞌ kynimiꞌn tkyaqil tyol. ");
INSERT INTO mamC_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ex axte Moisésjo ten kyukꞌa aj Israel, aye ojtxe qxjalil, tojjo tzqij txꞌotxꞌ jaꞌ ntiꞌ najbꞌil; ex tukꞌa angel, a yolin tukꞌa twiꞌ wutz Sinaí; ex ax tzaj kꞌmonte te Dios, ayeꞌ yol te chwinqil, tuꞌntziꞌn tzaj tqꞌmaꞌn qe. Tuꞌntziꞌn ikyjo, ax Moisésjo nim toklin. ");
INSERT INTO mamC_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Me mix kubꞌ kynimin kye ojtxe qxjalil, qalaꞌ bꞌeꞌx el kyiꞌjlin, ex kyajtaq tuꞌn kyaj meltzꞌaj toj Egipto. ");
INSERT INTO mamC_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ex tej tkyij ten Moisés twiꞌ wutz Sinaí yolil tukꞌa Dios, bꞌeꞌx xi kyqꞌmaꞌn te Aarón: Bꞌinchinkuy txqan qdiosa, tuꞌn tmojin qukꞌiy, quꞌn nya bꞌiꞌn quꞌn, tiꞌ ma bꞌajte Moisés, a s-etz qꞌinqeꞌy toj Egipto. ");
INSERT INTO mamC_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tuꞌnpetziꞌn, chi Esteban, kubꞌ kybꞌinchin jun twutzbꞌiyil ikyjo tzeꞌnku wakx, tuꞌn tok te kydios. Kubꞌ kybꞌyoꞌn aluꞌmj te aqꞌbꞌil chjonte, ex kubꞌ kyikyꞌsin jun nintz qꞌij tiꞌj tumil tbꞌij kydios, a ayex i kubꞌ bꞌinchinte. ");
INSERT INTO mamC_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tuꞌnpetziꞌn, bꞌeꞌx el tlaqꞌbꞌin te Dios tibꞌ kyiꞌj, ex xi tqꞌoꞌn ambꞌil kye, tuꞌn kykꞌulin kywutz qe cheꞌw te twutz kyaꞌj, quꞌn ikytziꞌn tzꞌibꞌin tojjo uꞌj kye yolil Tyol Dios: Ayiꞌy aj Israel, twutzxix qa kubꞌ kybꞌyoꞌn aluꞌmj te chojbꞌil kyila, ex tuꞌn t-xi kyqꞌoꞌn oyaj toj kaꞌwnaq abꞌqꞌe, tej kybꞌeta toj tzqij txꞌotxꞌ. Me ntiꞌ tajbꞌin, quꞌn nya te weꞌy tzaje kyqꞌoꞌniꞌy tkyaqiljo luꞌn, ");
INSERT INTO mamC_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","qalaꞌ kye kydiosa, a kubꞌ kybꞌinchiꞌn. Ex ikyꞌ kyiqiꞌn tqꞌuqiljo kydiosa, Moloc tbꞌi, tej kybꞌeta toj tzqij txꞌotxꞌ. Ex i kꞌuliꞌn twutz tcheꞌw juntl kydiosa, Refán tbꞌi, ayetzin kydiosjiꞌy, a ayexi i kubꞌ bꞌinchinte tuꞌn kykꞌuliꞌn kywutz. Tuꞌnpetziꞌn, kchi xel nxoꞌn toj junxil txꞌotxꞌ najchaq wen, a lu at tzma tiꞌjxi Babilonia. ");
INSERT INTO mamC_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ayetziꞌn ojtxe qxjalil, kyojjo qꞌij anetziꞌn, tkubꞌtaqjo jun ja te naꞌbꞌl Dios kyuꞌn, a xbꞌalin tten, a iqintaq kyuꞌn, tej kyok ten bꞌetil tojjo tzqij txꞌotxꞌ jaꞌ ntiꞌ najbꞌil. Atziꞌn ja, kubꞌ bꞌinchin tzeꞌnkuxjo tzaj tqꞌmaꞌn Dios te Moisés tuꞌn tkubꞌ bꞌinchit, tzeꞌnkuxjo a otaq tzꞌiwle tuꞌn Moisés twiꞌ wutz Sinaí. ");
INSERT INTO mamC_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tzaj kytzyuꞌn ojtxe qxjalil, a ojtxe ja te naꞌbꞌl Dios, a iqintaq kyuꞌn, ex ayetziꞌn i ul tukꞌa Josué, tzaj kyiꞌn kyukꞌa, tej tkanbꞌitjo txꞌotxꞌ lo, Canaán tbꞌi, a kytxꞌotxꞌjo txqantl xjal aj il, ayej xi xoꞌn kywutzjo qxjalil, tuꞌn Dios. Ikytzin bꞌajjo, teꞌ naꞌmxtaq titzꞌje David. ");
INSERT INTO mamC_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Atziꞌn teꞌ tok David te nmaq kawil, bꞌaꞌn ele twutz Dios, ex tajtaq tuꞌn tkubꞌ tbꞌinchin jun najbꞌil, jaꞌ tuꞌntaq tnajane qMan Dios te jun majx. ");
INSERT INTO mamC_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Me nya David kubꞌ bꞌinchin teꞌ tnejil ja te naꞌbꞌl Dios, qalaꞌ a tkꞌwal, Salomón tbꞌi, ");
INSERT INTO mamC_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","exla qa nyatza najle te qMan Dios, a nimxix toklin, kyojjo ja, a bꞌinchin kyuꞌnxjal; quꞌn ikytziꞌn tqꞌma jun yolil Tyol Dios kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","A wejiꞌy nqꞌuqil kyaꞌj, ex atzin txꞌotxꞌ kykubꞌil nqaꞌn, ex ayin weꞌ Bꞌinchilte tkyaqiljo lo. Tuꞌnpetziꞌn, ¿Tzeꞌntzin tten njaꞌy kꞌwel kybꞌinchiꞌn; ex ankyeꞌ nnajbꞌila te ajlabꞌl ktzajil kyqꞌoꞌn? chi tAjaw Tkyaqiljo. ");
INSERT INTO mamC_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Me ayetzin kyeꞌ, kukxjo mi n-okx toj kywiꞌy. Mina nxi kybꞌiꞌn, ex ntiꞌ nimbꞌil toj kyanmiꞌn; quꞌn noqx nchi qꞌojliꞌy tiꞌj Xewbꞌaj Xjan ikyqexjiꞌy tzeꞌnku ojtxe qxjalil. ");
INSERT INTO mamC_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tkyaqilx yolil Tyol Dios ojtxe, ayeꞌ i yolin tiꞌjjo tulil Jesús, a xjanxix, i ok yisoꞌn kyuꞌn ojtxe qxjalil, ex ayeꞌ i kubꞌ bꞌyon kye. Me ayetzin kyeꞌ, mix ele kynikyꞌa te, qa nya tumiljo anetziꞌn, quꞌn atzin teꞌ tul Jesús, i ok meltzꞌaja tiꞌj, ex bꞌeꞌx kubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","¿Me tzeꞌnx tten, ayiꞌy aj Israel? Ayeꞌ ojtxe qxeꞌchil tzaj tzyuꞌnte tkawbꞌil Dios noq kyuꞌn qe angel, me ayetzin kyeꞌ mina nkubꞌ kynimiꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tej kybꞌinte xjaljo yol lo, bꞌeꞌx jaw kyikyꞌin, ex ox chi juꞌchꞌinx kyste, tuꞌn kyqꞌoj tiꞌj Esteban. ");
INSERT INTO mamC_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Me ante Esteban, quꞌn nojnintaq teꞌ tanmin tukꞌa Xewbꞌaj Xjan, xi tkaꞌyin toj kyaꞌj, ex tli tqoptzꞌajiyil Dios, junx tukꞌa Jesús, waꞌltaq toj tman qꞌobꞌ Dios. ");
INSERT INTO mamC_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tbꞌajlinxiꞌ ikyjo, tqꞌma: ¡Kykaꞌyintza! Loqiꞌn nchin kaꞌyin kyiꞌjjo kyaꞌj jaqleqe, ex tiꞌjjo Klolqe Jesús, a Tkꞌwal Ichin, at toj tman qꞌobꞌ qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Me ayetzin kyej xjal, bꞌeꞌx ok kymaqsiꞌn kyẍkyin, ex bꞌeꞌx i jaw ẍchꞌin kujxix wen, ex ok tilj tiꞌj Esteban. ");
INSERT INTO mamC_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Exsin qꞌiꞌn Esteban tiꞌjxi tnam, ex ok xoꞌn tuꞌn abꞌj. Ex ayetzin ok bꞌyonte, kyij kyoqxeniꞌn tal kykamiẍ tukꞌa jun kuꞌxin, Saulo tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tzmataq n-ok xoꞌn Esteban tuꞌn abꞌj, me bꞌeꞌx jaw naꞌn Dios kyjaluꞌn: Tzyuꞌnxa wanmiꞌn Ay, wAjaw Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ex bꞌeꞌxsin kubꞌ meje Esteban, ex jaw ẍchꞌin kujxix wen, ex tqꞌma: ¡Ay, wAjaw, najsinkujiy il nbꞌant kyuꞌn xjal lo! Tej tbꞌaj tqꞌmaꞌn ikyjo, bꞌeꞌx el kyim. ");
INSERT INTO mamC_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Nmojintaq te Saulo antza tukꞌa tumil, tzeꞌn tuꞌn tkyime Esteban. Iteꞌ junjun nimil i kyij muqulte, ex ox chi oqꞌxix wen tiꞌj. Tojxjo qꞌij anetziꞌn, xi xkye jun joybꞌil qꞌoj tiꞌj Ttanim Dios, a attaq toj Jerusalén. Kykyaqilx nimil xi kysipin kyibꞌ toj tkyaqil txꞌotxꞌ te Judey ex Samaria. Oꞌkqex tsanjil i kyij toj Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Atzin te Saulo ok ten jyolkye nimil, ex n-okxtaq kyojileꞌ ja, tuꞌn kyetz qꞌiꞌn ichin ex qya, tuꞌn kykux qꞌoꞌn toj tze. ");
INSERT INTO mamC_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Me ayetzin kyej tuꞌntaq kyex toj Jerusalén, bꞌeꞌx ok ten qꞌmalte Tyol Dios te kolbꞌil, jaꞌchaqjo nchi bꞌete. ");
INSERT INTO mamC_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Atziꞌn jun kyukꞌa, a Lip tbꞌi, bꞌeꞌx xiꞌ tojjo tnejil tnam toj txꞌotxꞌ te Samaria, ex ok ten yolil tiꞌj Crist. ");
INSERT INTO mamC_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ok kychmoꞌnxjal kyibꞌ, ex kykyaqilx i bꞌinxix wen tiꞌjjo tqꞌma Lip, quꞌn ok kykaꞌyin nim techil tipin Dios bꞌant tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","At txqan xjal attaq taqꞌnil tajaw il toj kyanmin, bꞌeꞌx i qꞌanit, ex ayetzaj taqꞌnil tajaw il tzunxtaq chi ẍchꞌin wen, tej kyetz. Ex ikyxjo, nimxtaq xjal otaq tzꞌel kyim tanmin kyqan ex kyqꞌobꞌ, junx kyukꞌa kox, bꞌeꞌx i qꞌanit. ");
INSERT INTO mamC_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tuꞌn ikyjo, nim tzaljbꞌil ten toj kyanmin xjal teꞌ tnam anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Me attaq jun ichin yuẍtaq antza, Simun tbꞌi. Otaq sbꞌun kyiꞌjxjal te Samaria, ex otaq tzꞌok tqꞌoꞌn tibꞌ te jun xjal nim toklin. ");
INSERT INTO mamC_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aye ichin, aye qya, ex majqex kꞌwal nchi bꞌinxix wen tiꞌtaqjo ntqꞌmaꞌn Simun, ex kykyaqilx qꞌmante: Apen tej luꞌn nqꞌumle Nimxix Tipin Dios Tukꞌa, chi chi xjaljo. ");
INSERT INTO mamC_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ex nkubꞌ nimintaq, quꞌn tuꞌn ttyuẍbꞌin otaq sbꞌun kyiꞌj toj ilaꞌ abꞌqꞌe. ");
INSERT INTO mamC_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Me xi kynimiꞌn yol te Tbꞌanil Tqanil tqꞌma Lip tiꞌjjo Tkawbꞌil Dios ex tiꞌj Jesucrist, ex i kuꞌx ichin ex qya toj aꞌ, te jawsbꞌil aꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ex majx Simun nimin, ex kuꞌx toj aꞌ te jawsbꞌil aꞌ. Ok lipe tiꞌj Lip, ex bꞌeꞌx jaw kaꞌylaj kyiꞌjjo nim techil tipin Dios tli. ");
INSERT INTO mamC_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tej kybꞌinte tsanjil, a iteꞌtaq toj Jerusalén, qa otaq chi nimin aj Samaria Tyol Dios, bꞌeꞌxsin xi smaꞌn Pegr ex Juan antza. ");
INSERT INTO mamC_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tej kykanin, i naꞌn Dios kyiꞌj nimil te aj Samaria, tuꞌn t-xi kykꞌmoꞌn Xewbꞌaj Xjan toj kyanmin, ");
INSERT INTO mamC_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","quꞌn naꞌmtaq t-xi tqꞌoꞌn Dios a Xewbꞌaj Xjan kye; noq oꞌkx i kuꞌx toj aꞌ te jawsbꞌil aꞌ tiꞌj tbꞌi Jesús, a tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kubꞌtzin kyqꞌoꞌn Pegr ex Juan kyqꞌobꞌ kyibꞌajxjal aj Samaria; ikytziꞌn, bꞌeꞌx okx Xewbꞌaj Xjan toj kyanmin. ");
INSERT INTO mamC_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tli Simun, a yuẍtaq, tyekꞌbꞌil tibꞌ Xewbꞌaj Xjan, tej tkubꞌ kyqꞌoꞌn tsanjil kyqꞌobꞌ kyibꞌajxjal. Tuꞌntziꞌn ikyjo, xi tsuqin pwaq te chojbꞌil kye tsanjil, ");
INSERT INTO mamC_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ex tqꞌma: ¡Ex ikyxjo weꞌ; kyqꞌontza wokliꞌn, tuꞌntzintla, aj tkubꞌ nqꞌoꞌn nqꞌobꞌa tibꞌaj aꞌlchaqx kye xjaltz, kxel nqꞌoꞌn Xewbꞌaj Xjan toj kyanmin! ");
INSERT INTO mamC_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Me xitzin ttzaqꞌwin Pegr kyjaluꞌn: Knajila junx tukꞌa tpwaqa, quꞌn ma kubꞌ tbꞌisiꞌn tuꞌn tlaqꞌetjo toyaj Dios tukꞌa tpwaqa. ");
INSERT INTO mamC_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ntiꞌ te toklin tuꞌn t-xi tkꞌmoꞌn toyaj Dios, quꞌn nya jikyin taꞌye tanmiꞌn twutz qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tzaqpinkjiy nya bꞌaꞌn tumil tbꞌisa, ex kubꞌsin twutza te Dios, qapetla aku kubꞌ tnajsin tila tuꞌn t-xima ikyjo, ");
INSERT INTO mamC_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","quꞌn n-ok nkaꞌyiꞌn qa nchyoꞌnxix tkꞌuꞌja qiꞌja, ex a il tzyultiy, chi Pegr. ");
INSERT INTO mamC_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Xitzin ttzaqꞌwin Simun kyjaluꞌn: Kux chi naꞌn Diosa wiꞌja, tuꞌntzintla mi tzikyꞌe wiꞌja tkyaqiljo ma bꞌaj kyqꞌmaꞌn weꞌy. ");
INSERT INTO mamC_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tej tbꞌaj kyqꞌmaꞌn tsanjil Tyol Dios junx tukꞌaꞌ otaq tzikyꞌx kyiꞌj, oktzin tentz qꞌmalte Tbꞌanil Tqanil toj tkyaqil txꞌotxꞌ te Samaria. Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx i meltzꞌaj Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Otaq bꞌajjo ikyjo, jun t-angel tAjaw Tkyaqil xi tqꞌmaꞌn te Lip kyjaluꞌn: Bꞌinchinku tibꞌa, ex kux txiꞌy kubꞌl tojjo bꞌe nxiꞌ Jerusalén, tuꞌn tkanin toj tnam Gaza, chi angel. N-ikyꞌxjo bꞌe anetziꞌn toj txꞌotxꞌ ntiꞌ najbꞌil toj. ");
INSERT INTO mamC_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bꞌajtzin tbꞌinchin Liptz tibꞌ, ex bꞌeꞌx xiꞌ, ex ok tkꞌulbꞌin tibꞌ toj bꞌe tukꞌa jun ichin te Etiopía, jun aj kawiljo ichin anetziꞌn, kꞌuꞌl pwaq te jun qya, a nmaq kawil te Etiopía. ");
INSERT INTO mamC_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Otaq meltzꞌaj kꞌulil twutz Dios toj Jerusalén, ex otaq tzꞌajtz tuꞌn tkanin toj ttanim. Qꞌuqletaq toj tkarwaj, ex n-uꞌjintaq jun uꞌj tzꞌibꞌin tuꞌn Isaías, a yolil Tyol Dios ojtxe. ");
INSERT INTO mamC_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Xi tqꞌmaꞌn Xewbꞌaj Xjan te Lip kyjaluꞌn: Kux txiꞌy, ex laqꞌeka tkꞌatzjo karwaj. ");
INSERT INTO mamC_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tej tok laqꞌe Lip, xi tbꞌiꞌn tqꞌajqꞌojil twiꞌ ichin aj Etiopía, a tzuntaq n-uꞌjin jun uꞌj, a tzꞌibꞌin tuꞌn Isaías, a yolil Tyol Dios ojtxe. Xitzin tqanin Lip te: ¿Tzuntzin el tnikyꞌa tiꞌjjo ntuꞌjiꞌn? ");
INSERT INTO mamC_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tzajtzin ttzaqꞌwin aj Etiopía: ¿Tzeꞌn tten aj tel nnikyꞌa te, ex mix aꞌl ntzaj chikyꞌbꞌinte weꞌy? Xi tqꞌmaꞌn, tuꞌn tjax Lip toj tkarwaj, ex tuꞌn tkubꞌ qe junx tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Atziꞌn Tyol Dios, a ntuꞌjintaq ikytaq ntqꞌmaꞌn kyjaluꞌn: Xi qꞌiꞌn ikyjo tzeꞌnku jun tal rit nxi bꞌiybꞌaj; ex noq nkubꞌ tayoꞌn tzeꞌnku jun tal tal rit, tzeꞌn n-el mitzet tsmal. Ex xi ttziyin tiꞌchaqjo tuꞌn tikyꞌx tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kubꞌ mutxe, ex nya toj tumiljo kubꞌ bꞌinchin tiꞌj. ¿Me ankye aku yolin kyiꞌjjo tkꞌwal? Ntiꞌ, quꞌn bꞌeꞌx jatz xbꞌoqin tchwinqil toj txꞌotxꞌ, chi Isaías. ");
INSERT INTO mamC_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Xitzin tqanin aj Etiopía te Lip: Bꞌinchima xtalbꞌil. Qꞌmantziꞌn weꞌy; ¿Anqiꞌj nyolineꞌ ojtxe yolil tojjo yol luꞌn; ma tiꞌjxpela moj qa tiꞌj junxilj? ");
INSERT INTO mamC_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Xitzin tchikyꞌbꞌin Lip jaꞌxjo tzaje xkye tuꞌjit Tyol Dios tuꞌn aj Etiopía, exsin xi tqꞌmaꞌn Tbꞌanil Tqanil tiꞌj Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tbꞌajlinxiꞌ ikyjo, tej kypon kanin toj jun txꞌotxꞌ jaꞌ attaq aꞌ, xitzin tqꞌmaꞌn tej aj Etiopía kyjaluꞌn: Atpe te aꞌ tzaluꞌn. ¿Atpela tkyꞌi tuꞌn nkuꞌxa toj aꞌ te jawsbꞌil aꞌ? ");
INSERT INTO mamC_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Xi tqꞌmaꞌn Lip kyjaluꞌn: ¡Bꞌaꞌn! Qa ma kubꞌ tnimin Tyol qMan Dios tukꞌa tkyaqil tanmiꞌn. Xitzin ttzaqꞌwin aj Etiopía: Ma tzꞌel nnikyꞌa te. Tuꞌnpetziꞌn, ma txi nnimiꞌn, qa ate Jesús Tkꞌwal qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Xitzin tqꞌmaꞌn tuꞌn tkubꞌ weꞌ karwaj. I kuꞌx toj aꞌ kykabꞌilx, te jawsbꞌil aꞌ tuꞌn Lip. ");
INSERT INTO mamC_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tej kyjatz toj aꞌ, bꞌeꞌx xi qꞌiꞌn te Lip tuꞌn Xewbꞌaj Xjan. Antej aj Etiopía mix tlonte juntl majl, me nojnin tanmin tuꞌn tzaljbꞌil, xi tiꞌn tbꞌe. ");
INSERT INTO mamC_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Noq tnaꞌbꞌinku Lip, noq atl toj tnam te Azoto. Ikyꞌxsin tojileꞌ junjun tnam qꞌmalte Tbꞌanil Tqanil, ex ikytziꞌn, kanine toj tnam te Cesarea. ");
INSERT INTO mamC_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ikytaqtzin nbꞌajjo, me atzinte Saulo tzunxtaq njyon teꞌ tumil, tzeꞌn tuꞌn kykyime nimil tiꞌj tAjaw Tkyaqil. Tuꞌnpetziꞌn, xtaꞌj tukꞌa tnejilxix pale, ");
INSERT INTO mamC_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ex xi tqanin jun uꞌj tuꞌntzintla at toklin, aj t-xiꞌ kyojjo ja te naꞌbꞌl Dios toj tnam te Damasco, jyolkye ichin ex qya nimil, tuꞌn kytzaj tiꞌn, ex tuꞌn kyokx tqꞌoꞌn toj tze toj Jerusalén. Ex bꞌeꞌx xiꞌ antza. ");
INSERT INTO mamC_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Me tej nqayintaq taꞌ tkꞌatz Damasco, xi tkaꞌyin jun tqoptzꞌajiyil tzaj, tzaj toj kyaꞌj, ex noq tnaꞌbꞌinkux noq attaql tiꞌjile. ");
INSERT INTO mamC_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tuꞌntziꞌn, bꞌeꞌx kubꞌ lankꞌaj Saulo twutz txꞌotxꞌ, ex xi tbꞌiꞌn jun tqꞌajqꞌojil twiꞌ jun aꞌla tqꞌma kyjaluꞌn: Saulo, Saulo, ¿Tiꞌn wila ma chin el tikyꞌiꞌn? ");
INSERT INTO mamC_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Xitzin tqanin Saulo: ¿Ankye te, Tata? Tzajtzin ttzaqꞌwin: Ayin wejiꞌy, Jesús; ayinxjiꞌy, a ma chin el tikyꞌiꞌn. Axa n-ok qꞌoꞌnte jun mibꞌin tiꞌjxa, ikyx tzeꞌnku jun wakx nkjoꞌn, aj tok twaꞌbꞌiꞌn jun ma juchꞌ kxbꞌil, ex aj qa nya tumiljo nbꞌant tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tuꞌn ikyjo, bꞌeꞌx jaw luꞌlin Saulo, ex tukꞌa txqan t-xobꞌil, xi tqanin kyjaluꞌn: Tata, ¿Titzin te taj tuꞌn tkubꞌ nbꞌinchiꞌn? Ex tzaj ttzaqꞌwin Jesús te: Kux jaw weꞌksa, ex kux txiꞌy toj Damasco. Antza ktzajil qꞌmaꞌne tey, tiꞌ tuꞌn tkubꞌ tbꞌinchiꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ayetzin kyej nchi bꞌettaq tukꞌa Saulo, bꞌeꞌx i xobꞌx kyeꞌ, quꞌn tuꞌn otaq kybꞌi tqꞌajqꞌojil twiꞌ jun aꞌla, me ntiꞌ jun otaq kyli. ");
INSERT INTO mamC_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tbꞌajlinxiꞌ ikyjo, jaw weꞌks Saulo, me atzaj teꞌ tjaw tjqoꞌn twutz, mix bꞌantil tkaꞌyin. Tuꞌn ikyjo, noq xi xkoꞌn, ex xi qꞌiꞌn toj Damasco. ");
INSERT INTO mamC_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Antza tene oxe qꞌij, me mix kaꞌyine, mix waꞌne, ex ntiꞌ chꞌin tkꞌwaꞌ bꞌaj. ");
INSERT INTO mamC_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tojx Damasco, najletaq jun nimil, Ananías tbꞌi, a otaq tzꞌok jun twutzikyꞌ tuꞌn tAjaw Tkyaqil, a qꞌmante te: ¡Ananías! Tzajtzin ttzaqꞌwin Ananías: Loqiꞌn lo, wAjaw. ");
INSERT INTO mamC_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Xitzin tqꞌmaꞌn tAjaw Tkyaqil te: Kux jaw weꞌksa, ex kux txiꞌy tojjo bꞌe, Jikyin tbꞌi, ex qanixa toj tja Judas tiꞌj jun ichin, Saulo tbꞌi, te aj tnam Tarso. Lu nnaꞌn Dios, ");
INSERT INTO mamC_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ex ma tzꞌiwliy tuꞌn toj twutzikyꞌ, qa ma tzꞌokxa, ex qa ma chi kubꞌ tqꞌoꞌn tqꞌobꞌa tibꞌaj, tuꞌn tkaꞌyin juntl majl. ");
INSERT INTO mamC_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tej tbꞌinte Ananías ikyjo, tqꞌma: WAjaw, ilaꞌ o yolin tiꞌjjo ichin anetziꞌn, ex tiꞌjjo tkyaqil nya bꞌaꞌn o bꞌant tuꞌn toj Jerusalén, a xjan Ttanima. ");
INSERT INTO mamC_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ex atziꞌn jaꞌlin, ma tzul tzaluꞌn tukꞌa toklin qꞌoꞌntz kyuꞌn kynejil pale, tuꞌn kyxi qꞌiꞌn toj tze kykyaqilxjo nchi naꞌn tiꞌj tbꞌiy. ");
INSERT INTO mamC_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Me ante tAjaw Tkyaqil xi tqꞌmaꞌn: Kux txiꞌy, quꞌn ma skꞌetjo ichin wuꞌn, tuꞌn tyolin wiꞌja kye xjal te junxil txꞌotxꞌ, kye nmaq kawil, exsin kyeꞌ aj Israel. ");
INSERT INTO mamC_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ok kxel nyekꞌin te, tkyaqiljo qa nimx tuꞌn tikyꞌx tuꞌn, noq tuꞌn npaja. ");
INSERT INTO mamC_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Xitzin Ananíastz tojjo ja, jaꞌ taꞌyetaq Saulo. Tej tokx, i kubꞌ tqꞌoꞌn tqꞌobꞌ tibꞌaj, ex xi tqꞌmaꞌn: Ay, werman Saulo, ate Jesús, a tAjaw Tkyaqil, aj s-ok tyekꞌin tibꞌ tey toj bꞌe, teꞌ tuꞌntaq ttzaja; atzin saj chqꞌoꞌn wejiꞌy, tuꞌn tbꞌant tkaꞌyin juntl majla, ex tuꞌn tnoj tanmiꞌn tukꞌa Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Texjo or anetziꞌn, bꞌeꞌx el jolpaj muj tiꞌj twutz Saulo, ikyjo tzeꞌnku tmuꞌpil ixiꞌn. Tuꞌntzin ikyjo, bꞌeꞌx bꞌantl tkaꞌyin, bꞌeꞌx jaw weꞌks, ex kuꞌx toj jun aꞌ, te jawsbꞌil aꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tbꞌajlinxiꞌ ikyjo, ok ten waꞌl, ex ul tipin; ex kyij ten jun jteꞌbꞌin qꞌij kyukꞌa nimil najleqetaq toj Damasco. ");
INSERT INTO mamC_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Bꞌeꞌx xi t-xikyꞌbꞌin Saulo, tuꞌn tyolin kyojile ja te naꞌbꞌl Dios, ex tqꞌma qa a Crist, Tkꞌwal Dios. ");
INSERT INTO mamC_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kykyaqiljo i bꞌinte, bꞌeꞌx i jaw kaꞌylaj, ex kyqꞌma: ¿Ma nya antej luꞌn, a nbꞌettaq ikyꞌil kye nimil toj Jerusalén, ex kyiꞌjjo nchi yolintaq tiꞌj tbꞌi Jesús? Ex ¿Ma nya axjo ul tzaluꞌn tzyulkye nimil ex qꞌolkye toj kyqꞌobꞌ kynejil pale? ");
INSERT INTO mamC_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Me ante Saulo, njaw tinxix tibꞌ tuꞌn tyolin, ex tukꞌa tkyaqil tipin tqꞌma qa a Jesúsjo Crist, a Kolil. Tuꞌnpetziꞌn, bꞌeꞌx i jaw naj Judiy tuꞌn, a najleqetaq toj Damasco. ");
INSERT INTO mamC_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tbꞌajlinxiꞌ ilaꞌ qꞌij, i kyij bꞌant Judiy, tuꞌn tkubꞌ bꞌyet Saulo, ");
INSERT INTO mamC_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","me bꞌeꞌx kanin te Saulo tiꞌj. Ayetzin bꞌiyil nkubꞌtaq kyyoꞌn qꞌijl ex qnikyꞌin ttxanila tnam, tuꞌn tkubꞌ bꞌyet. ");
INSERT INTO mamC_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Me ayetzin nimil kux kyqꞌoꞌn Saulo toj jun ma tij chiꞌl, ex toj qnikyꞌin, kutz kyqꞌoꞌn tibꞌaj tape, a bꞌinchinkstaq tiꞌjile tnam. Ikytzin tene Saulo, tej ttzaqpaj. Ex xiꞌ Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Atziꞌn tej tkanin Saulo antza, tajtaq tuꞌn tok tchmoꞌn tibꞌ kyukꞌa nimil, me kykyaqil attaq kyxobꞌil te, ex mix xi kynimin qa otaq tzꞌok te nimil. ");
INSERT INTO mamC_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Me a Bernabé xi qꞌinte, ex xiꞌ tukꞌa tzmax kywutz tsanjil. Xi tqꞌmaꞌn kye qa otaq tzꞌiwle tAjaw Tkyaqil tuꞌn Saulo toj bꞌe, ex qa otaq chi yolin, ex qa otaq yolin Saulo tiꞌj Jesús tukꞌa tkyaqil tipin toj Damasco. ");
INSERT INTO mamC_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","29","Ikytziꞌn, bꞌeꞌx kyij Saulo toj Jerusalén junx kyukꞌa tsanjil. Yolin, ex chꞌotj Saulo kyukꞌa Judiy, ayej griego kyyol, tiꞌj tAjaw Tkyaqil tukꞌa tkyaqil tipin. Me ayetzin kyej Judiy kyajtaq tuꞌn tkubꞌ kybꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Atziꞌn tej tel kynikyꞌ nimil tiꞌjjo tuꞌntaq tikyꞌx tiꞌj Saulo, bꞌeꞌxsin xi kyintz toj tnam Cesarea, ex antzintza, xi smaꞌn, tuꞌn tkanin tzma toj tnam Tarso. ");
INSERT INTO mamC_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tuꞌn ntiꞌtaq tqꞌoj Saulo kyiꞌj, chꞌiyjo Ttanim Dios toj tkyaqil txꞌotxꞌ te Judey, Galiley ex Samaria. Nimx i tzalaj, ex chꞌiyjo kynimbꞌil, ex najleqetaq tukꞌa kymutxbꞌil kyibꞌ twutz qMan Dios, quꞌn tuꞌn nimintaq kyuꞌn, ex attaq tchewil Dios kyiꞌj. Tuꞌn ikyjo, ex tukꞌa tmojbꞌil Xewbꞌaj Xjan, chꞌiye kybꞌaj. ");
INSERT INTO mamC_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Atzin te Pegr tzuntaq nbꞌet teꞌ qꞌolbꞌil kye nimil, ex xtaꞌj lol kyeꞌ najleqetaq toj tnam Lida. ");
INSERT INTO mamC_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Antza el jyete jun ichin tuꞌn, Eneas tbꞌi, a otaq bꞌaj wajxaq abꞌqꞌe tkubꞌlin tzyet tuꞌn jun yabꞌil. Tuꞌntziꞌn, kuẍletaq twiꞌ jun watbꞌil, ex minataq njaw yekj. ");
INSERT INTO mamC_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Xitzin tqꞌmaꞌn Pegr te kyjaluꞌn: Eneas, ate Jesucrist kꞌwel qꞌanin tey. Kux jaw weꞌksa, ex chmoꞌnks tal tkuẍbꞌila. Bꞌeꞌxsin jaw weꞌks Eneas, ");
INSERT INTO mamC_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ex kykyaqilxjo najleqetaq toj Lida ex toj tnam Sarón kyli, tej tjaw weꞌks. Tuꞌnpetziꞌn, bꞌeꞌx i nimin tiꞌj tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kyojjo qꞌij anetziꞌn, attaq jun qya nimil toj tnam te Jope, Tabita tbꞌi; atzin toj griego, Dorcas tzꞌelpine. Atzaj qya anetziꞌn oꞌkxtaq taqꞌiꞌn tuꞌn tbꞌinchin jun bꞌaꞌn, ex tuꞌn tmojin kyukꞌa yaj. ");
INSERT INTO mamC_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Me bꞌeꞌx yabꞌte, ex bꞌeꞌx kyim. Atzaj teꞌ tbꞌaj txjoꞌn tiꞌj, kubꞌ qꞌoꞌn toj jun ja te tkabꞌ kol. ");
INSERT INTO mamC_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tej kybꞌinte nimil qa antza taꞌyetaq Pegr toj Lida, ex quꞌn tuꞌn nqayintaq iteꞌye, xi kychqꞌoꞌn kabꞌe ichin qꞌmalte te: Liwey ku tzaja qukꞌiy toj Jope, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bꞌeꞌxsin xiꞌ Pegr kyukꞌa. Atzaj teꞌ tkanin, bꞌeꞌx jax kꞌleꞌn tojjo ja, jaꞌ taꞌyetaq t-xmilil Dorcas. Ex bꞌeꞌx xi laqꞌe. Ilaꞌ mebꞌe qya nchi oqꞌ wen, ex xi kyyekꞌin jniꞌ xbꞌalin ex txoꞌwbꞌaj, a otaq chi bꞌant tuꞌn Dorcas, teꞌ itzꞌtaq. ");
INSERT INTO mamC_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Me bꞌeꞌx i etz tchqꞌoꞌn Pegr kykyaqilx peꞌn. Kubꞌtzin meje, ex naꞌn Dios. Xitzin tkaꞌyintzjo kyimnin ex tqꞌma: Weꞌksa, Tabita. I jawtzin tjqoꞌn tej qya twutz. Atzaj teꞌ tiwle Pegr, bꞌeꞌx jaw qe. ");
INSERT INTO mamC_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jaw ttzyuꞌn Pegr tqꞌobꞌ, ex jaw tjkꞌuꞌn. I xi tqꞌolbꞌin mebꞌe qya junx kyukꞌa txqantl nimil, ex xi tqꞌmaꞌn: Lu Tabita lo; ex itzꞌl. ");
INSERT INTO mamC_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","El tqaniljo lo toj tkyaqil tnam te Jope, ex nimx txqan xjal nimin tiꞌj tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Atzin te Pegr, ilaꞌ qꞌijl kyij teꞌ toj tnam toj tja jun bꞌinchil tzꞌuꞌn, Simun tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Attaq jun ichin toj tnam te Cesarea, Cornelio tbꞌi, nejinel kywutz jun chꞌuq xoꞌl qꞌaqꞌ, Italiano tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wenxixtaqjo ichin anetziꞌn, junx tukꞌa t-xuꞌjil ex kyukꞌa tkꞌwal; bꞌaꞌntaq chi kꞌulin twutz Dios, me naꞌmtaq kynimin Tbꞌanil Tqanil tiꞌj Jesús. Exsin nimtaq pwaq nxi tqꞌoꞌn te mojbꞌil kye Judiy, ex kukxtaq nnaꞌn Diosjo. ");
INSERT INTO mamC_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jun maj, bꞌalaqa otaq tzꞌok oxe or te qale, ok jun twutzikyꞌ. Tlixixjo jun t-angel Dios n-okxtaq tojjo ja, jaꞌ taꞌyetaq, ex ntqꞌmaꞌntaq kyjaluꞌn: ¡Cornelio! ");
INSERT INTO mamC_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Atzin te Cornelio xi kyim tiꞌjjo angel, ex tukꞌa nim t-xobꞌil, xi tqanin: ¿Tiꞌn te taj, Tata? Xitzin ttzaqꞌwin angel kyjaluꞌn: O tzaj tbꞌiꞌn Dios tkubꞌsbꞌil twutza, ex ma tli mojbꞌil, a ma txi tqꞌoꞌn kye yaj. ");
INSERT INTO mamC_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tuꞌnpetziꞌn, chqꞌonxa jun aꞌla toj tnam te Jope, tuꞌn ttzaj Simun, a ojtzqiꞌn tukꞌa juntl tbꞌi, Pegr. ");
INSERT INTO mamC_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Luꞌ at tkꞌatz ttxuyil aꞌ toj tja Simun, jun bꞌinchil tzꞌuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Atzin teꞌ t-xiꞌ angel, a otaq bꞌaj yolin tukꞌa, tzaj ttxkoꞌn Cornelio kabꞌe taqꞌnil ex jun xoꞌl qꞌaqꞌ wenxix, ex qꞌuqle tkꞌuꞌj kyiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Atzin teꞌ tbꞌaj tqꞌmaꞌn tkyaqil tiꞌjjo otaq bꞌaj, bꞌeꞌx i xi tchqꞌoꞌn tzma Jope. ");
INSERT INTO mamC_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Toj junxil qꞌij, bꞌalaqa otaq tzꞌok kabꞌlaj, tzuntaq nchi bꞌetjo aye xjal, ex teꞌ chꞌixtaq kykanin tzma Jope, jax te Pegr naꞌl Dios tzma twiꞌ ja. ");
INSERT INTO mamC_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Attaq waꞌyaj tiꞌj, ex tajtaq tuꞌn twaꞌn. Me tzunxtaq nbꞌinchajtztaq twa, texjo tok jun twutzikyꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Xi tkaꞌyin, tej t-xi jaqle kyaꞌj, ex kutz likyꞌikyꞌin twutz txꞌotxꞌ ikyjo tzeꞌnku jun iqbꞌil, xmoꞌnqetaq kyibꞌjo ttxaꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tojjo iqbꞌil anetziꞌn, attaq ilaꞌ wiq txuk kyukꞌa kyaje kyqan, junx kyukꞌa kan, exqe txuk bꞌaꞌn chi lipin. ");
INSERT INTO mamC_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ex xi tbꞌiꞌn tqꞌajqꞌojil twiꞌ jun aꞌla, a tzaj tqꞌmaꞌn: Weꞌksa, Pegr. Bꞌyoꞌnqekujiy txuk lo, ex chyoꞌnqexa. ");
INSERT INTO mamC_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Xi ttzaqꞌwin Pegr: ¡Mina wAjaw! Mix jun majx o chin chyoꞌn weꞌ tiꞌjjo chibꞌj, a mi ntziyajtz tuꞌn tchyoꞌljtz qxola, quꞌn ikytzin ntqꞌmaꞌn kawbꞌil te Tuꞌjil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yolin juntl majljo tqꞌajqꞌojil twiꞌ jun aꞌla, ex tqꞌma: Me ante jaꞌlin, wen tchyoꞌljtzjo, a nya wentaq tchyoꞌljtz ojtxe, quꞌn ate Dios o qꞌmante qa wen. Tuꞌnpetziꞌn, mina tzꞌok tqꞌoꞌn te nya wen. ");
INSERT INTO mamC_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxe maj bꞌaj yolin ikyjo. Tbꞌajlinxitziꞌn ikyjo, bꞌeꞌx jax likyꞌikyꞌin tej iqbꞌil toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bꞌeꞌxsin jaw bꞌisin Pegr, ex kubꞌ t-ximin tzeꞌntzila tzꞌelpineꞌ wutzikyꞌ anetziꞌn. Tzuntaqtzin bꞌisin, tej kykaniꞌn ichin ttzija, ayeꞌ xi tchqꞌoꞌn Cornelio. Tzuntaq nchi qanlaj tiꞌj tja Simun. ");
INSERT INTO mamC_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tej kykanin, kujxix xi kyqanin qa antza taꞌyetaq Simun, a ojtzqiꞌntaq tukꞌa juntl tbꞌi, Pegr. ");
INSERT INTO mamC_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Me tzunxtaq nbꞌisin Pegr tiꞌjjo twutzikyꞌ, tzaj tqꞌmaꞌn Xewbꞌaj Xjan te kyjaluꞌn: ¡Kaꞌyinxa! Oxe ichin nchi jyon tiꞌja. ");
INSERT INTO mamC_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Weꞌksa, kux kuꞌxa, ex kux txiꞌy kyukꞌa; ex mina ja kaꞌmin tkꞌuꞌja, quꞌn ayin weꞌ ẍin tzaj chqꞌonkye. ");
INSERT INTO mamC_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bꞌeꞌxsin kuꞌtz Pegr, ex xi tqꞌmaꞌn kye ichin: Ayin wejiꞌy a nchin kyjyoꞌn. ¿Titzin ẍi ula lolte? ");
INSERT INTO mamC_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Xitzin kytzaqꞌwin: Ma qo ula tiꞌj tbꞌi Cornelio, jun nejinel kywutz xoꞌl qꞌaqꞌ, jun ichin tzꞌaqlexix, at tchewil Dios tiꞌj, ex kꞌuꞌjlinxix kyuꞌn kykyaqil aj Judiy. Jun t-angel Dios qꞌmante te, qa iltaq tiꞌj tuꞌn t-xi txketa, tuꞌntzintla t-xiy tzma tja, tuꞌn tok tbꞌiꞌn, tiꞌ tuꞌn t-xi tqꞌmaꞌn te. ");
INSERT INTO mamC_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","I okxsin qꞌiꞌntz tuꞌn Pegr tuja, ex antza i kyije tojjo qnikyꞌin anetziꞌn. Toj junxil qꞌij, xiꞌ Pegr kyukꞌa, ex xi lipe jun jteꞌbꞌinl nimil, ayeꞌ najleqetaq toj Jope. ");
INSERT INTO mamC_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tojxi tkabꞌ qꞌij, i kanin toj Cesarea, jaꞌ nyontaq Cornelio kyiꞌj, junx tukꞌa jun chꞌuq t-xjalil ex qeꞌ tukꞌa, ayeꞌ otaq chi tzaj ttxkoꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tej tkanin Pegr, etz Cornelio qꞌolbꞌilte, ex bꞌeꞌx kubꞌ meje, tuꞌn tkꞌulin twutz. ");
INSERT INTO mamC_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Me ante Pegr xi tqꞌman te, tuꞌn tjaw weꞌks. Chiꞌ kyjaluꞌn: Weꞌksa, quꞌn ex ichinqin weꞌ tzeꞌnkuxjo ay. ");
INSERT INTO mamC_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nchi yolintaq, tej kyokx tuja, ex xi tkaꞌyin Pegr txqan xjal chꞌuqleqetaq. ");
INSERT INTO mamC_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Xi tqꞌmaꞌn Pegr kye: Bꞌiꞌn kyeꞌ kyuꞌn, qa nya wen toj qkawbꞌila awoꞌy Judiyqoꞌy, tuꞌn tok qmujbꞌin qibꞌa kyukꞌa xjal nya Judiyqe, tzeꞌnku ayiꞌy, ex nya wen tuꞌn qokxa toj kyja. Me ante Dios ma tzaj xnaqꞌtzinte weꞌy toj jun wutzikyꞌ, qa nya bꞌaꞌn tuꞌn tel wikyꞌiꞌn jun aꞌla, mo tuꞌn tok nqꞌoꞌn te nya wen. ");
INSERT INTO mamC_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tuꞌnpetziꞌn, noqx teꞌ saj qꞌmaꞌn weꞌy tuꞌn wula, bꞌeꞌx ẍin tzaja, ex mi xjaw kaꞌmin nkꞌuꞌja. Wajtzintza tuꞌn nbꞌintiꞌy, tiquꞌn ẍin tzaj kytxkoꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Xi ttzaqꞌwin Cornelio: Ma bꞌajxi kyaje qꞌij, bꞌalaqa ikyx orjo tzeꞌn jaꞌlin, loqintaq weꞌ intiꞌn toj njaꞌy. Nchin paꞌntaqa waꞌyaj, te naꞌj Dios te qale, tej tok tyekꞌin jun ichin tibꞌ nwutza, a toktaq jun t-xbꞌalin tzunx tilkꞌajx wen. ");
INSERT INTO mamC_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Tzaj tqꞌmaꞌn weꞌy: ¡Cornelio! Ma tzaj bꞌiꞌn tkubꞌsil twutza tuꞌn Dios, ex ma tzaj naꞌn tkyaqiljo tmojbꞌila kye yaj. ");
INSERT INTO mamC_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Chqꞌonxa jun aꞌla toj tnam te Jope, tuꞌn ttzaj Simun, a Pegrjo, juntl tbꞌi. Luꞌ at toj tja jun bꞌinchil tzꞌuꞌn, Simun tbꞌi, a luꞌ najle ttzi ttxuyil aꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tuꞌnpetziꞌn, chi Cornelio, bꞌeꞌxkux ẍi ex nchqꞌoꞌnjiꞌy oxe ichin te jyoltiy, ex luꞌy ma tzul tukꞌa twenila. Loqotzintz otoꞌ twutz Dios jaꞌlin qkyaqilx, ex qaja tuꞌn qbꞌintiꞌy tkyaqiljo ma tzaj tqꞌmaꞌn Dios tey, a tuꞌn ttzaj tqꞌmaꞌn qeꞌy. ");
INSERT INTO mamC_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Oktzin ten Pegr yolil, ex tqꞌma: Mapetzin tzꞌelxix nnikyꞌtza te jaꞌlin, qa mujbꞌin kytenxjal tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tuꞌnpetziꞌn, n-ok qꞌoꞌn te nimil toj aꞌlchaqx wiq xjaltz, ex nya noq oꞌkx kyxol aj Judiy, qalaꞌ alkyeꞌ njaw nimsinte Dios, ex qa wenjo tbꞌinchbꞌin. ");
INSERT INTO mamC_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bꞌiꞌntzintz kyuꞌn, qa nyolin Dios kye aj Israel, ex tqꞌma jun yol te tbꞌanil tuꞌn Jesucrist, a tAjaw kykyaqil xjal. ");
INSERT INTO mamC_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Me bꞌiꞌn kyeꞌ kyuꞌn, tiꞌ xbꞌaj toj tkyaqil kytxꞌotxꞌ Judiy. Tzaj xkye toj txꞌotxꞌ te Galiley, tej tbꞌajlinxi tqꞌma Juan, qa iltaq tiꞌj tuꞌn kykuꞌxxjal toj aꞌ te jawsbꞌil aꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ex bꞌiꞌn kyeꞌ kyuꞌn, qa xi qꞌoꞌn nim ipbꞌil te Jesús te Nazaret, ex qa nojsit tanmin tuꞌn Xewbꞌaj Xjan. Ex qa ma bꞌet Jesús bꞌinchil bꞌaꞌn, ex i qꞌanit kykyaqiljo xjal, a n-ikyꞌxtaq nya bꞌaꞌn kyuꞌn tjaqꞌ tkawbꞌil tajaw il. I bꞌantjo luꞌn tuꞌn, quꞌn tuꞌn attaq Dios tukꞌa. ");
INSERT INTO mamC_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ex ma qliꞌy tkyaqiljo xbꞌant tuꞌn Jesús toj txꞌotxꞌ te Judey ex toj Jerusalén. Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx jaw yoꞌbꞌin ex kubꞌ bꞌyoꞌn twutz cruz. ");
INSERT INTO mamC_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Me a Dios jatz anqꞌsinte juntl majl toj toxin qꞌij, ex ax kubꞌ yekꞌinte qxola. ");
INSERT INTO mamC_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Me tej tjatz anqꞌin, mix kubꞌe tyekꞌin tibꞌ kyxol kykyaqil xjal toj tnam, qalaꞌ noq qxola, a awoꞌy nej jaw skꞌoꞌn tuꞌn Dios, tuꞌn qlontiꞌy, ex tuꞌn qqꞌmaꞌn tiꞌjjo tuꞌntaq tbꞌaj. Ma qo waꞌn, ex ma qo kꞌwaꞌn tukꞌa, tej tjaw anqꞌin juntl majl. Tuꞌn ikyjo, bꞌiꞌn quꞌn qa twutzxix itzꞌl. ");
INSERT INTO mamC_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ex atzintz xi chqꞌoꞌn qeꞌy qꞌmalte Tyol kyexjal, qa a Dios ma tzꞌok qꞌoꞌnte te kawil kyxol kykyaqil xjal itzꞌ ex kyimninqe. ");
INSERT INTO mamC_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Me kykyaqiljo yolil Tyol Dios ojtxe otaq chi yolin tiꞌj Jesús, ex otaq kyqꞌma qa aye kchi nimil tiꞌj, ok kꞌwel najsin kyil tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tzunxtaq nyolin Pegr, tej tul Xewbꞌaj Xjan toj kyanminjo xjal, ayeꞌ i txokin tiꞌj Pegr exqetziꞌn kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ayetzin kyej nimil aj Judiyqe, a otaq chi kanin tukꞌa Pegr, bꞌeꞌx jaw kaꞌylaj, tuꞌn otaq tzꞌokx Xewbꞌaj Xjan toj kyanminj xjal, a nya Judiyqe. ");
INSERT INTO mamC_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Xitzin kybꞌiꞌntz, tej kyjaw yolin toj junxil yol, ex i nimsin tbꞌi Dios. ");
INSERT INTO mamC_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tuꞌnpetziꞌn, tzaj tqꞌmaꞌn Pegr kyjaluꞌn: ¿Ma akutzin tzꞌel qiꞌn kyoklin, tuꞌn kykuꞌxjo nimil lo te jawsbꞌil aꞌ, a ma txi kykꞌmoꞌn Xewbꞌaj Xjan ikyxjo tzeꞌnku qe? ");
INSERT INTO mamC_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ex xi tqꞌmaꞌn, tuꞌn kykuꞌx toj aꞌ te jawsbꞌil aꞌ tiꞌj tumil tbꞌi Jesucrist. Tbꞌajlinxiꞌ ikyjo, kubꞌsin kywutz te Pegr, tuꞌn tkyij jun jteꞌbꞌintl qꞌij kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aye tsanjil exqe nimil, a iteꞌtaq toj txꞌotxꞌ te Judey, kybꞌi tqanil qa otaq chi nimiꞌn nya Judiyqe tiꞌj Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Tuꞌnpetziꞌn, tej tmeltzꞌaj juntl majl Pegr toj Jerusalén, jaw yolbꞌil tiꞌj, kyuꞌn jun jteꞌbꞌin nimil aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Xi kyqanin: ¿Tiquꞌn txaꞌja qꞌolbꞌil kyeꞌ xjal, a nya Judiyqe, ex tiquꞌn xwaꞌn kyukꞌa? ¿Ma nyatzin bꞌiꞌn tuꞌn, qa nya wenjo anetziꞌn toj qkawbꞌil? ");
INSERT INTO mamC_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Me atzin te Pegr xi tqꞌmaꞌn kye tzeꞌnxix tzaje xkyeye a otaq bꞌaj. Chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Loqintaq weꞌ intin toj tnam te Jope, chi Pegrjo, ex tzuntaq nchin naꞌn weꞌ Dios, tej tok jun nwutzikyꞌa. Nliꞌy ikyxixtaqjo tzeꞌnku jun iqbꞌil xmoꞌnqetaqjo kyaje ttxaꞌn, ex tzaj likyꞌikyꞌin twutz kyaꞌj, ex tuꞌntaq tkꞌuꞌl jaꞌ intintaqa. ");
INSERT INTO mamC_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Me ok nkaꞌyinxixa tiꞌtaqjo at toj, ex nliꞌy ilaꞌtaq wiq txuk kyukꞌa kyaje kyqan, junx kyukꞌa kan, exqe txuk bꞌaꞌn chi lipin. ");
INSERT INTO mamC_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ex xi nbꞌiꞌn tqꞌajqꞌojil twiꞌ jun aꞌla, a tzaj qꞌmante weꞌy: Weꞌksa, Pegr. Bꞌyoꞌnqekujiy txuk lo, ex kux chex tchyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Xitzin ntzaqꞌwiꞌn: Mina, wAjaw, quꞌn naꞌmx tokx toj ntziꞌy jun tiꞌla, a nya wen tchyoꞌljtz qxola, tzeꞌn kyij ttzꞌibꞌin tojxjo ojtxe qkawbꞌila. ");
INSERT INTO mamC_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tzaj qꞌmaꞌn juntl majl weꞌy toj kyaꞌj kyjaluꞌn: Mina tzꞌok tqꞌoꞌn te nya wen, quꞌn ate Dios o qꞌmante qa wen. ");
INSERT INTO mamC_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Oxe maj yolin ikyjo, chi Pegr. Tbꞌajlinxiꞌ ikyjo, bꞌeꞌx jax likyꞌikyꞌin juntl majljo iqbꞌil toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Texjo or anetziꞌn, pon kanin oxe ichin xi chqꞌoꞌn toj tnam Cesarea jyol weꞌy tojjo ja, jaꞌ intintaqa junx kyukꞌa wukꞌiy. ");
INSERT INTO mamC_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ex ate Xewbꞌaj Xjan tzaj qꞌmaꞌnte weꞌy, tuꞌn mina jaw kaꞌmin wanmiꞌn, ex tuꞌn nxiꞌy kyukꞌa. Ex i xiꞌtzin qaql nimil wukꞌiy, aye loqe lo. Qkyaqilxa o okxa toj tja jun ichin, ");
INSERT INTO mamC_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","a tzaj qꞌmante qeꞌy tzeꞌn tten, tej tlonte jun angel waꞌltaq, ex tqꞌma te kyjaluꞌn: Chqꞌonxa jun aꞌla toj tnam te Jope, tuꞌntzin ttzaj Simun, ojtzqiꞌn tukꞌa juntl tbꞌi, Pegr. ");
INSERT INTO mamC_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Atzin ktzajil qꞌmante tey tzeꞌn kkletiliy, junx kyukꞌa tkꞌwala ex t-xuꞌjila. ");
INSERT INTO mamC_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Atzaj teꞌ wok teꞌn yolil kye, chi Pegr, bꞌeꞌx tyekꞌeku Xewbꞌaj Xjan, qa bꞌeꞌx okx toj kyanmin, ikyxjo tzeꞌnku tyekꞌe qxol te tnejil. ");
INSERT INTO mamC_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Bꞌeꞌxsin ultz toj nkꞌuꞌja tiꞌjjo otaq tqꞌma tAjaw Tkyaqil: Twutzxix ma jawsin te Juan aꞌ, te jawsbꞌil aꞌ, me ayetzin kyeꞌ, nya noq oꞌkx chi kꞌwelix kyeꞌ toj aꞌ, qalaꞌ ex kꞌwelix te Xewbꞌaj Xjan toj kyanmiꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Quꞌn tuꞌntziꞌn, chi Pegr, ma txi tqꞌoꞌn te qMan Dios Xewbꞌaj Xjan kye, ikyxjo tzeꞌnku tzaj qꞌoꞌn qe, a awo o qo nimin tiꞌj Jesucrist, a tAjaw Tkyaqil. ¿Tinajtzin wetza woklin, tuꞌn tel wiꞌjlinjiꞌy, a tbꞌinchbꞌin Dios, ex tuꞌn mina kubꞌ nniminjiꞌy kyoklin xjal, a nya aj Judiyqe, a otaq tzaj tqꞌoꞌn Dios? ");
INSERT INTO mamC_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tej kybꞌinte nimil aj Jerusalén jniꞌ yol lo, mix i jawe yolinil, ex i nimsin tbꞌi Dios ex kyqꞌma: Ikytziꞌn, majqex kyeꞌ nya aj Judiyqe, ma txi qꞌoꞌn ambꞌil kye tuꞌn Dios, tuꞌn kytxꞌixpin kynabꞌl, ex tuꞌn tknet chwinqil kyuꞌn te jun majx. ");
INSERT INTO mamC_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Otaqxi kyim Esteban ikyjo, tej t-xi xkye joybꞌil qꞌoj kyiꞌj nimil. Tuꞌnpetziꞌn, ilaꞌ bꞌeꞌx oq tuꞌn kykanin toj txꞌotxꞌ Fenicia, Chipre, ex Antyokiy. Antza, i yoline kye xjal Judiy, tiꞌjjo Tbꞌanil Tqanil kolbꞌil, me mix i yoline kyukꞌa aj nya Judiy. ");
INSERT INTO mamC_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Me metziꞌn, i kanin ilaꞌ nimil te Chipre ex te Cirene toj tnam te Antyokiy, ex i yolin kyeꞌ xjal, a nya Judiyqe, ex kyqꞌma yol te Tbꞌanil Tqanil tiꞌj Jesús, a tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Attaq tipin tAjaw Tkyaqil kyukꞌa. Tuꞌnpetziꞌn, txqan xjal kyij kytzaqpiꞌn ojtxe kynimbꞌil, ex i nimin tiꞌjjo Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ayetzin kyeꞌ Ttanim Dios toj Jerusalén, tej kybꞌin teꞌ tqanil lo, xi kychqꞌoꞌn Bernabé tzmax Antyokiy. ");
INSERT INTO mamC_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Tej tkanin Bernabé antza, el tnikyꞌ teꞌ tkyꞌiwbꞌil Dios, a otaq tzaj tqꞌoꞌn kyibꞌajjo otaq chi nimin, ex ox tzalajx wen. Xi tqꞌmaꞌn jun tumil kye kykyaqilx, quꞌn tuꞌn tbꞌanilxtaq te Bernabé, ex nojnintaq tanmin tukꞌa Xewbꞌaj Xjan ex nimtaq tnimbꞌil. Tuꞌn ikyjo, xi tqꞌmaꞌn, tuꞌn kybꞌet jikyin wen toj kychwinqil, ex tuꞌn kynimin tukꞌa tkyaqil kyanmin tiꞌj tAjaw Tkyaqil. Tuꞌnpetziꞌn, at txqan xjal nimin tiꞌj qAjaw. ");
INSERT INTO mamC_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tbꞌajlinxiꞌ ikyjo, xtaꞌj Bernabé tzma Tarso jyolte Saulo. ");
INSERT INTO mamC_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Atziꞌn, tej tjyet, bꞌeꞌx tzaj tkꞌleꞌn, tuꞌn kyul toj Antyokiy. Antza, i tene junku abꞌqꞌe tukꞌa Ttanim Dios, ex i xnaqꞌtzin kye txqan xjal. Ex antza toj Antyokiy, xi xkye kyqꞌolbꞌajtzjo jniꞌ nimil te taqꞌnil Crist. ");
INSERT INTO mamC_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kyojjo qꞌij anetziꞌn, jun jteꞌbꞌin yolil Tyol Dios i xiꞌ toj Jerusalén tzma Antyokiy. ");
INSERT INTO mamC_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kyxol, attaq jun, Agabo tbꞌi, ja weꞌ yolil noq tuꞌn Xewbꞌaj Xjan, qa tuꞌntaq ttzaj nim waꞌyaj toj tkyaqil txꞌotxꞌ te Israel. Me ikyxixsin bꞌajjo toj tkawbꞌil Claudio, tej toktaq te tnejilxix kawil te Rom. ");
INSERT INTO mamC_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tuꞌn tqanil ikyjo, ayetzaj nimil te Antyokiy kubꞌ kybꞌisin tuꞌn tjaw chmet tmojbꞌil junjunkye, tzeꞌnkux attaq kye, tuꞌn t-xi smet te Ttanim Dios najleqetaq toj Judey. ");
INSERT INTO mamC_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ikytzin bꞌantjo kyuꞌn, ex noq te Bernabé ex Saulo xi smaꞌne mojbꞌil kye nejinel toj Ttanim Dios toj Jerusalén, tuꞌn t-xi kysipin kye nimil antza. ");
INSERT INTO mamC_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kyojjo qꞌij anetziꞌn, xi xkye joybꞌil qꞌoj tuꞌn Herodes, a kawil, kyiꞌj nimil. ");
INSERT INTO mamC_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Xi tqꞌmaꞌn, tuꞌn tkubꞌ bꞌyet Santyaw, a ttziky Juan, tukꞌa jun kxbꞌil, a kabꞌe tste. ");
INSERT INTO mamC_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Atzaj teꞌ tel tnikyꞌ qa wenxix otaq tzꞌele lo toj kywutz Judiy, ex bꞌeꞌx xi tqꞌmaꞌn, tuꞌn tok tzyet Pegr. Atzin bꞌajjo toj tqꞌijil nintz qꞌij te Waꞌj Pan, ntiꞌ txꞌamsbꞌilte tkuꞌx. ");
INSERT INTO mamC_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Atzaj teꞌ ttzyet Pegr, kux qꞌoꞌn toj tze tuꞌn Herodes, jaꞌ xqꞌuqete kyuꞌn kyaje chꞌuq xoꞌl qꞌaqꞌ, a kyajkyajchaq kybꞌaj tojile junjun chꞌuq. Otaq kubꞌ tbꞌisin Herodes tuꞌn tkubꞌ bꞌyettaq kywutz Judiy, aj tbꞌajtaq nintz qꞌij te Waꞌj Pan. ");
INSERT INTO mamC_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tkuꞌxtaqtzin Pegr toj tze, ex xqꞌuqin wen. Me atzin te Ttanim Dios mix i sikyte kyeꞌ, tuꞌn kynaꞌn Dios tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tzunxtaq chi naꞌn kye nimil Dios tojjo qnikyꞌin anetziꞌn, ante Pegr nktantaq teꞌ kyxol kabꞌe xoꞌl qꞌaqꞌ, kꞌloꞌntaq tukꞌa kabꞌe kxbꞌil, ex xqꞌuqintaq kyuꞌn ilaꞌ xoꞌl qꞌaqꞌ iteꞌtaq ttzi tze, quꞌn tuꞌn tajtaq Herodes tuꞌn t-xi tyekꞌin kye Judiy toj junxil qꞌij. ");
INSERT INTO mamC_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Texjo or anetziꞌn, kubꞌ tyekꞌin tibꞌ jun t-angel Dios, ex tuꞌntziꞌn, bꞌeꞌx kubꞌ noj tojjo tze tuꞌn spikyꞌin. Ok tyekin angel ttxlaj Pegr, tuꞌn tjaw sakꞌpaj, ex xi tqꞌmaꞌn: Weꞌksa jaꞌlin. Ex bꞌeꞌx i el tzꞌaqjo kxbꞌil iteꞌktaq kyiꞌj tqꞌobꞌ Pegr, ");
INSERT INTO mamC_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ex xi tqꞌmaꞌnl angel te: Qꞌonk t-xbꞌalin exqetziꞌn t-xjabꞌa. Ikytzin kubꞌ tbꞌinchin Pegrjo. Bꞌaltzꞌink ttxoꞌwa tiꞌja, ex lipetza wiꞌja, chi angeljo. ");
INSERT INTO mamC_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bꞌeꞌxsin xi lipe Pegr tiꞌj angel, me mix ele tnikyꞌ te, qa twutzxjo nkubꞌtaq tbꞌinchin angel mo minaj, quꞌn ikytaqjo lo te te, tzeꞌnku jun twutzikyꞌ n-ok. ");
INSERT INTO mamC_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Me i ikyꞌx twutz tnejil chꞌuq xoꞌl qꞌaqꞌ, ex liwey twutz tkabꞌ. Ex atziꞌn tej kykanin twutz tjpel tze, a kxbꞌiltaq ex a attaq ttzi bꞌe, bꞌeꞌx xi jaqle tilx tibꞌ. I exsintz, ex tej otaq txi kybꞌetin jun jteꞌbꞌin ech, bꞌeꞌx el tpaꞌn angel tibꞌ tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Eltzin tnikyꞌ Pegr te, qa nya jun twutzikyꞌ, ex tqꞌma: Mapetzin tzꞌelxix nnikyꞌtza te jaꞌlin, qa aj tAjaw Tkyaqil s-aj chqꞌoꞌnte jun t-angel te klol weꞌy toj tqꞌobꞌ Herodes, ex te tkyaqiljo a kyajtaq Judiy tuꞌn tkubꞌ kybꞌinchin wiꞌja. ");
INSERT INTO mamC_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tej tel tnikyꞌ Pegr te qa otaq tzaqpaj, bꞌeꞌx xiꞌ toj tja Mariy, a tnana Juan, a Marksjo juntl tbꞌi. Antza chꞌuqleqetaq txqan xjal, tzunxtaq nchi naꞌn Dios tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ok twokꞌchin tjpel ja, jaꞌ iteꞌtaq, ex etz jun txin, Rode tbꞌi, lolte alkyetaqjo nwokꞌchintaq. ");
INSERT INTO mamC_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Atzaj tel tnikyꞌ teꞌ tqꞌajqꞌojil twiꞌ Pegr, nimx ja tzalaj, ex tuꞌn ttzaljbꞌil, mix oktze tjqoꞌne ja, qalaꞌ kyja oktze rininil tuja, tuꞌn t-xi tqꞌmaꞌn qa ataq Pegrjo nwokꞌchin. ");
INSERT INTO mamC_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Xitzin kyqꞌmaꞌn te: ¿Nya ma tzaj toj twiꞌy? Me atzin tetxin xi tqꞌmaꞌn juntl majl qa twutzxix. Ayetzin kyetz xi kyqꞌmaꞌn: Nya te Pegrjo; a teꞌ t-angel. ");
INSERT INTO mamC_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tzuntaq nchi yolin ikyjo, atzin te Pegr tzunxtaq wokꞌchin teꞌ. Atzaj teꞌ toktz jqoꞌn tjpel ja, ex tej kylonte, bꞌeꞌx i xobꞌx. ");
INSERT INTO mamC_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Me atzin te Pegr, xi tyekꞌin kyukꞌa tqꞌobꞌ tuꞌn mina chi chꞌotje, ex xi tqꞌmaꞌn kye tzeꞌn tten otaq tzꞌetz toj tze tuꞌn tAjaw Tkyaqil. Ex xi tqꞌmaꞌnl: Kyqꞌmanxjiꞌy lo te Santyaw ex kye txqantl nimil. Bꞌeꞌxsin extz, ex xiꞌ toj junxil najbꞌil. ");
INSERT INTO mamC_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Atzaj teꞌ qsqix, nim labꞌil jaw kyxol xoꞌl qꞌaqꞌ, quꞌn mix ele kynikyꞌ tiꞌjjo otaq tzikyꞌx tiꞌj Pegr. ");
INSERT INTO mamC_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Tzaj tqꞌmaꞌn Herodes tuꞌn ttzyet tjoyle; me quꞌn tuꞌn mix jyete, bꞌeꞌx ok qꞌoꞌn te kypaj xoꞌl qꞌaqꞌ, ex tqꞌma tuꞌn kykubꞌ bꞌyet. Tbꞌajlinxiꞌ ikyjo, ex Herodes toj txꞌotxꞌ Judey, ex bꞌeꞌx xiꞌ najal toj Cesarea. ");
INSERT INTO mamC_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tzuntaq qꞌojle Herodes kyukꞌa xjal te Tiro ex te Sidón. Tuꞌnpetziꞌn, i kyij toj wen tuꞌn kyxiꞌ yolil tukꞌa Herodes, me ntiꞌtaq tumil tzeꞌn tuꞌn kyyoline. Tuꞌn ikyjo, nej i yolin tukꞌa Blast, jun kawil tkꞌatz tnejil kawil Herodes; ex noq tuꞌn Blast, xi kyqanin, tuꞌn mina chi qꞌojine, quꞌn attaq kyoklin tiꞌjjo awal njaw toj txꞌotxꞌ tjaqꞌ tkawbꞌil Herodes. ");
INSERT INTO mamC_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","I txkettzintz tuꞌn Herodes. Atzaj teꞌ tkanin qꞌij anetziꞌn tuꞌn kychmet, ok tqꞌoꞌn Herodes jun t-xbꞌalin tbꞌanilxix wen. Kubꞌ qe toj tqꞌuqil, jaꞌ nkawinetaq, ex ok ten yolil. ");
INSERT INTO mamC_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tzuntaq nyolin, tej kyok ten xjal ẍchꞌil, me noq tuꞌn tkubꞌ tkꞌuꞌj, ex kyqꞌma: Nya ichin teꞌ nyolin, qalaꞌ jun dios, chi chiꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Texjo or anetziꞌn, jun t-angel tAjaw Tkyaqil kubꞌ tbꞌinchin, tuꞌn tyabꞌte Herodes, quꞌn tuꞌn xi ttziyin tuꞌn tok qꞌoꞌn te jun dios. Bꞌeꞌx kyim tukꞌa nim kyixkꞌoj, ikyjo tzeꞌnku nchyoꞌljtz jun aꞌla kyuꞌn ẍchuqꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Me metzin teꞌ Tyol Dios tzunxtaq nchꞌiy teꞌ tyolajtz toj tkyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tej kybꞌaj aqꞌnin Bernabé ex Saulo, bꞌeꞌx i ajtz toj Jerusalén, tuꞌn kykanin toj Antyokiy. Ex otaq t-xi kykleꞌn Juan kyukꞌa, a Marksjo, juntl tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kyxoljo Ttanim Dios toj Antyokiy, iteꞌtaq yolil Tyol Dios ex xnaqꞌtzil. Bernabétaqjo jun; junx tukꞌa Simun, Qꞌaqeyin juntl tbꞌi; ex Lucio te Cirene; Manaén, aj otaq jaw chꞌiy junx tukꞌa Herodes, a kawin toj txꞌotxꞌ te Galiley; exsin Saulo. ");
INSERT INTO mamC_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jun maj, tzuntaq nchi paꞌn waꞌyaj, quꞌn tuꞌn otaq tzꞌok jun kynaꞌj Dios; atzin te Xewbꞌaj Xjan tqꞌma: Kyskꞌoꞌnqemetza Bernabé tukꞌa Saulo, tuꞌn kyaqꞌnin tojjo aqꞌuntl, jaꞌ ma chi tzaje ntxkoꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tej kybꞌaj naꞌn Dios, ex kybꞌaj paꞌn waꞌyaj, kubꞌ kyqꞌoꞌn nimil kyqꞌobꞌ kyibꞌaj Bernabé ex Saulo, noq tuꞌn kyxi oqxeniꞌn toj tqꞌobꞌ qMan Dios, exsin i xi chqꞌoꞌntz toj tbꞌi qAjaw. ");
INSERT INTO mamC_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","I xitzin chqꞌoꞌn Bernabé ex Saulo tuꞌn Xewbꞌaj Xjan tzma Seleucia, ex antza i xiꞌ toj bark tuꞌn kykanin tojjo txꞌotxꞌ tkuꞌx toj aꞌ, Chipre tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Atzaj teꞌ kykanin toj jun tnam te Chipre, Salamina tbꞌi, a at ttzi ttxuyil aꞌ, bꞌeꞌx i ok ten yolil tiꞌj Tyol Dios kyojileꞌ ja te naꞌbꞌl Dios kye Judiy. Majxtaq Juan, a Marks juntl tbꞌi, nbꞌet mojil kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Elpin bꞌajjo tnam kyuꞌn, tuꞌn kybꞌetsinte, ex i kanin toj tnam Pafos. Antza, el jyete jun yuẍ aj Judiy, Barjesús tbꞌi, a tbꞌanilxtaq txalpin yol. Tzuntaq ntyolin qa noq tiꞌjtaq tbꞌi Dios nyoline. ");
INSERT INTO mamC_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Antza taꞌyetaqjo yuẍ anetziꞌn tukꞌa nmaq kawil Sergio Pabl tbꞌi, jun ichin manyor ẍtijxtaq. Xi tchqꞌoꞌn nmaq kawil qꞌolbꞌilte Bernabé ex Saulo, quꞌn tajtaq tuꞌn tbꞌinte Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Me atzin tej yuẍ, a Elimas tbꞌi toj yol griego, bꞌeꞌx i kubꞌ tmeqoꞌn, quꞌn tajtaq, tuꞌn mina t-xi tnimin nmaq kawil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Atzin te Saulo, a Pabljo juntl tbꞌi, nojnintaq tanmin tukꞌa Xewbꞌaj Xjan, xi kyimxix toj twutz yuẍ, ");
INSERT INTO mamC_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ex xi tqꞌmaꞌn: ¡Ay, txalpil yol, ma najxa, kꞌwalbꞌaja te tajaw il, ex ajqꞌoja tiꞌj tkyaqil bꞌaꞌn! ¿Tiquꞌn mina nkyij ttzaqpiꞌn, tuꞌn tnajsin tnabꞌljo nmaq kawil, a taj tuꞌn tbꞌet tojjo tbꞌeyil Dios jikyin wen? ");
INSERT INTO mamC_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Atziꞌn jaꞌlin, ok kꞌwel kawin tuꞌn tAjaw Tkyaqil. Ok kyjela moẍ, ex nlay tlontejiy tspikyꞌemil qꞌij toj ilaꞌ qꞌij. Texixjo or anetziꞌn, bꞌeꞌx kyij Elimas moẍ, ex jyon tiꞌj jun aꞌla, tuꞌn t-xi xkoꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tej tok tkaꞌyin nmaq kawiljo ikyjo, bꞌeꞌx nimin, ex jaw kaꞌylaj twutz tiꞌjjo xnaqꞌtzbꞌil tiꞌj tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ex Pabl toj Pafos toj bark kyukꞌa tukꞌa, tuꞌn kykanin tzma Perge tojjo txꞌotxꞌ te Panfilia. Me atzin te Juan Marks, bꞌeꞌx meltzꞌaj teꞌ, tuꞌn tpon toj Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","I ex Perge, tuꞌn kykanin tzma tojjo juntl Antyokiy, jun tnam toj txꞌotxꞌ te Pisidia. Tojjo qꞌij te ajlabꞌl, tojjo tnam anetziꞌn, i okx toj ja te naꞌbꞌl Dios, ex i kubꞌ qe. ");
INSERT INTO mamC_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kybꞌajlinxi uꞌjitjo uꞌj te kawbꞌil exsin uꞌj kyij tzꞌibꞌin kyuꞌn yolil Tyol Dios ojtxe, i xi txkoꞌn Pabl ex Bernabé kyuꞌn qeꞌ tnejil kawil toj ja te naꞌbꞌl Dios, ex xi kyqꞌmaꞌn: Ayiꞌy nxjalil, qa at jun tumil kyuꞌn kyexjal, tuꞌn kynimsin kykꞌuꞌj, kyqꞌmantza jaꞌlin. ");
INSERT INTO mamC_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jawtzin weꞌks Pabl, ex xi tyekꞌin tukꞌa tqꞌobꞌ, tuꞌn mi chi chꞌotje, ex tqꞌma: Kybꞌintza, ayiꞌy nxjalil, ex majqexa ayiꞌy nya Judiyqiꞌy, a at tchewil Dios kyiꞌja. ");
INSERT INTO mamC_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","A kyDios tnam te Israel, xjaw skꞌoꞌn kyeꞌ ojtxe qxeꞌchil. Ma chi ok tmujbꞌin, tuꞌn kyok te bꞌetin xjal, a ma nintz kybꞌaj, teꞌ iteꞌxtaq toj txꞌotxꞌ te Egipto. Ex ax, tukꞌa tkyaqil tipin, s-etz qꞌinkye tojjo txꞌotxꞌ anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tojjo kaꞌwnaq abꞌqꞌe, nya bꞌaꞌn bꞌant kyuꞌn aj Israel tojjo tzqij txꞌotxꞌ, jaꞌ ntiꞌye kynajbꞌilxjal; me tkyaqiljo lo, ma tzikyꞌx tuꞌn Dios. ");
INSERT INTO mamC_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ex ma kubꞌ tyuchꞌin wuq ma tij chꞌuq xjal toj txꞌotxꞌ te Canaán, tuꞌntzin t-xi qꞌoꞌn txꞌotxꞌ anetziꞌn kye ojtxe qxeꞌchil. ");
INSERT INTO mamC_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kykyaqiljo lo, bꞌaj bꞌalaqa toj 450 abꞌqꞌe. Tbꞌajlinxitziꞌn ikyjo, chi Pabl, i jaw tskꞌoꞌn nejinel kyxol, ex atzin Samuel, a yolil Tyol Dios, pon kanin te tchꞌibꞌil. ");
INSERT INTO mamC_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Me xitzin kyqanin aj Israel jun nmaq kawil, ex tuꞌn kykubꞌ kawin tuꞌn. Ex tzajtzin tqꞌoꞌn Dios Saúl, a kꞌwalbꞌaj te Cis, tzajnin tojjo jun chꞌuq aj Israel, Benjamín tbꞌi, tuꞌn tok te nmaq kawil kyxol toj kaꞌwnaq abꞌqꞌe. ");
INSERT INTO mamC_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kybꞌajlinxi abꞌqꞌe anetziꞌn, el qꞌiꞌn Saúl tojjo toklin tuꞌn Dios, ex ok qꞌoꞌn juntl t-xel, David tbꞌi, ex tqꞌma: Ma jyet David wuꞌn, tkꞌwal Isaí, chi Dios, a jun ichin tbꞌanilx ma tzꞌele weꞌy, ex nimjo taj tuꞌn tkubꞌ tbꞌinchin tkyaqiljo waja. ");
INSERT INTO mamC_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ex ax David, ojtxe t-xeꞌchil Jesús, chi Pabljo, a tzaj tchqꞌoꞌn qMan Dios, tuꞌn tkꞌuꞌl kolil qiꞌj, awo aj Israel. Ikyxjo tzeꞌnku otaq tzaj qꞌmaꞌn kyuꞌn yolil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Naꞌmxtaq t-xi xkye taqꞌin Jesús tzaluꞌn twutz txꞌotxꞌ, otaq tzꞌok ten Juan yolil tiꞌjjo Tbꞌanil Tqanil kye xjal te Israel, ex ikyx tqꞌma qa iltaq tiꞌj tuꞌn kymeltzꞌaj tukꞌa Dios, ex tuꞌn kykuꞌx toj aꞌ te jawsbꞌil aꞌ, noq te jun yekꞌbꞌil, qa otaq txꞌixpit kynabꞌl. ");
INSERT INTO mamC_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Me atzaj teꞌ chꞌixtaq tkyim Juan, tqꞌma kyjaluꞌn: Nyaqin wejiꞌy Kolil, a tzeꞌnku kyeꞌ nkubꞌ kybꞌisin. Quꞌn at juntl tetz lipchetz wiꞌja, ex nimxixtl toklin nwutza, nipila at chꞌin wokliꞌn tuꞌn woka te taqꞌnil. ");
INSERT INTO mamC_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ayiꞌy nxjalil, chi Pabl, a tzajninqiꞌy tiꞌj tyajil Abraham, ex ayiꞌy nya Judiy, a bꞌetin xjalqiꞌy, ex at tchewil Dios kyiꞌja; a Tbꞌanil Tqanil kolbꞌil lo te kye kyejiꞌy. ");
INSERT INTO mamC_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Me ayetzin kyeꞌ najleqetaq toj Jerusalén, ex ayeꞌ nmaq kawil kyxol, nya bꞌiꞌntaq kyeꞌ kyuꞌn alkyetaqjo Jesús, ex mi n-eltaq kynikyꞌ te kyyoljo yolil Tyol Dios, a n-uꞌjit toj ja te naꞌbꞌl Dios tojile junjun qꞌij te ajlabꞌl. Ikytziꞌn, ayex kye nchi bꞌinchin il, ex nxi kyqꞌmaꞌn tuꞌn tkubꞌ kybꞌyoꞌn. Me atziꞌn lo n-ajbꞌin noq tuꞌn tkubꞌ nimitjo yol tzꞌibꞌin toj Tuꞌjil Tyol Dios kyuꞌn yolil Tyol. ");
INSERT INTO mamC_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Exla qa ntiꞌ til jyet kyuꞌn, tuꞌn tkubꞌ bꞌyet Jesús, xi kyqanin te Pilat tuꞌn tkubꞌ bꞌyoꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tkyimlinxi Jesús, chi Pabljo, ex aꞌkxtaq tbꞌaj tkyaqiljo, a otaq yolajtz tiꞌj toj Tuꞌjil Tyol Dios, kutz qꞌiꞌn twutz cruz, ex kux muquꞌn toj tjulil kyimnin. ");
INSERT INTO mamC_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Me ate qMan Dios, jatz anqꞌsintlte juntl majl. ");
INSERT INTO mamC_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ex kyoj ilaꞌ qꞌij, kubꞌ tyekꞌin Jesús tibꞌ kyxoljo otaq chi ok lipe tiꞌj, tej t-xiꞌ toj tbꞌe toj txꞌotxꞌ te Galiley, tuꞌn tkanin toj Jerusalén, jaꞌ kyime. Ex atzin jaꞌlin, ayetzaj i ok lipe tiꞌj, ayetziꞌn nchi yolin tiꞌj Jesús kyexjal. ");
INSERT INTO mamC_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ikytziꞌn, chi Pabl, awotzin qeꞌ nqo qꞌmante Tbꞌanil Tqanil kyeꞌy, qa a t-xilin yol otaq tqꞌma qMan Dios kyeꞌ ojtxe qxjalil, naꞌmtaq tbꞌant. ");
INSERT INTO mamC_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Me atzin jaꞌlin, ma tzaj qꞌoꞌn jun oybꞌil tiꞌj jun akꞌaj chwinqil qe, a awo tzajninqo kyiꞌj. Atzin t-xilin yol lo, ma kubꞌ tbꞌinchin tzmaxiꞌ teꞌ xjatz anqꞌin juntl majl, tzeꞌnkuxjo tzꞌibꞌin toj tkabꞌ Bꞌitz te Tuꞌjil Tyol Dios: Axix te nkꞌwala, quꞌn jaꞌlin ma txi nqꞌoꞌn tchwinqila twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Otaq tqꞌma Dios, qa tuꞌn tjatz anqꞌintl juntl majl, tuꞌntzintla mina tzꞌel puqꞌjjo t-xmilil, ikytziꞌn tzeꞌnku tqꞌma toj Tuꞌjil Tyol Dios: Ok chi japin bꞌajjo xjan yol, a twutzxix, a nqꞌmay te David. ");
INSERT INTO mamC_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tuꞌnpetziꞌn, qꞌumle toj junxil tnej Tuꞌjil: Ay, Dios, nlayla ttziyiy, tuꞌn tel puqꞌjjo t-xmilil xjan taqꞌnila, a kꞌuꞌjlinxix wen. ");
INSERT INTO mamC_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Me atzin yol lo, nya tiꞌjx David nyolajtza, chi Pabl. Twutzx tetz, ma tzꞌajbꞌin te David kye t-xjalil, tzeꞌnxjo tzaj tqꞌmaꞌn Dios te. Ex qa otaqxi kyim, jax tanmin toj kyaꞌj, junx kyukꞌa ojtxe t-xjalil. Me atzin t-xmilil bꞌeꞌx el puqꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Me atzin teꞌ t-xmilil Jesús, a jatz anqꞌin juntl majl tuꞌn Dios; mix ele puqꞌj teꞌ, quꞌn nya te kyimin teꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ikypetziꞌn nxjalil, il tiꞌj tuꞌn kybꞌintiꞌy, qa noq tuꞌn Jesús, a itzꞌl, at najsbꞌil il. ");
INSERT INTO mamC_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ex noq tuꞌn Jesús, kykyaqiljo kchi nimil tiꞌj, ok kchi kletil te tkyaqiljo il ntiꞌ chojbꞌilte tjaqꞌ tkawbꞌil Moisés. ");
INSERT INTO mamC_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kykaꞌyink kyibꞌa, tuꞌn mi kubꞌe tzꞌaqe kyibꞌaja a kyij kytzꞌibꞌin yolil Tyol Dios kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Kybꞌinkuy, ayiꞌy bꞌaꞌn chi ikyꞌin. Kux chi jaw kaꞌylaja, ex kux chi oqꞌa, quꞌn kyojjo qꞌij lo, nimx kawbꞌil kꞌwel nbꞌinchiꞌn, a nlayla txi kynimin, qa junxil xi qꞌmaꞌnte kyeꞌy, chi Pabl kye xjal antza. ");
INSERT INTO mamC_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tej tex Pabl kyukꞌa tukꞌa toj ja te kynaꞌbꞌl Dios aj Judiy, ayetzin kye Judiyqe, noq tuꞌn kynimbꞌil ex nya te kyitzꞌjlin, xi kyqanin tuꞌn tyolajtz kye tojjo juntl qꞌij te ajlabꞌl tiꞌjjo Tbꞌanil Tqanil, a otaq bꞌaj qꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Otaq xi tzꞌel bꞌaj kychmobꞌl kyibꞌ toj ja te naꞌbꞌl Dios, txqankux Judiy exqetziꞌn Judiyqe noq tuꞌn kynimbꞌil, i xi lipe tiꞌj Pabl ex Bernabé. Ex tzaj qꞌmaꞌn jun tumil kye, tuꞌn kyten jikyinxix wen tojjo txokbꞌil otaq tzaj qꞌmaꞌn kye tojjo Tbꞌanil Tqanil te tqꞌaqꞌbꞌil tkꞌuꞌj Dios. ");
INSERT INTO mamC_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Toj junxil qꞌij te ajlabꞌl, bꞌalaqa kykyaqil xjal te toj tnam, ok kychmoꞌn kyibꞌ, tuꞌn tok kybꞌiꞌn Tbꞌanil Tqanil. ");
INSERT INTO mamC_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Me atzaj teꞌ tok kykaꞌyin aj Judiyjo txqan xjal, bꞌeꞌx i ja xkyꞌaqlin, ex bꞌeꞌxsin i ok tentz yolbꞌil, ex yasil tiꞌj Pabl ex Bernabé. ");
INSERT INTO mamC_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tuꞌntzin ikyjo, jaw kyiꞌn kyibꞌ tuꞌn kyyolin, ex xi kyqꞌmaꞌn: Iltaq tiꞌj, chi chi Pabl ex Bernabé, tuꞌn qyoliꞌn nej kyukꞌiy, ayiꞌy aj Judiy, tiꞌj Tyol Dios. Me tuꞌn ma tzꞌel kyikyꞌin, ex nkubꞌ kynabꞌlin qa ntiꞌ kyokliꞌn tiꞌjjo chwinqil te jun majx, antza qo xelitza kyukꞌaꞌ a nya Judiyqe. ");
INSERT INTO mamC_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Quꞌn ikytziꞌn, ma tzaj qꞌmaꞌn qeꞌy tuꞌn Dios toj Tuꞌjil Tyol Dios kyjaluꞌn: Ma kubꞌ nqꞌoꞌn tzeꞌnku jun tzaj kyxol tkyaqil xjal, a nya Judiy, te twutz txꞌotxꞌ, tuꞌntzin t-xi tiꞌn Nkolbꞌila kyexjal, ex tuꞌn tkanin kyojjo kynajbꞌil, exla qa najchaq toj tkyaqil twutz txꞌotxꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Atzaj teꞌ kybꞌin teꞌ nya Judiyqe, bꞌeꞌx i jaw tzalaj, ex i ok ten qꞌmalte qa tbꞌanilxtaqjo Tyol tAjaw Tkyaqil. Ex i nimin kykyaqilxjo, a otaq tzaj qꞌoꞌn kyoklin tuꞌn Dios, tuꞌn kykꞌmonte kychwinqil te jun majx. ");
INSERT INTO mamC_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ikytzin qꞌmeteꞌ Tyol tAjaw Tkyaqil tojjo tkyaqil txꞌotxꞌ anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Me ayetzin kyeꞌ Judiy i yolin kyukꞌa jteꞌbꞌin qya nya Judiyqe, aye nchi kanintaq toj ja te naꞌbꞌl Dios, ex nimtaq kyoklin, junx kyukꞌa ichin nejinel toj tnam. Ok ten tzpetsil kynaꞌbꞌlxjal, tuꞌn kyjyoꞌn qꞌoj kyiꞌj Pabl ex Bernabé, ex tuꞌn kyex lajettaq tojjo txꞌotxꞌ anetziꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Me ayetzin kyej Pabl ex Bernabé el kychtoꞌn quq tiꞌj kyqan, te yekꞌbꞌil qa nya wenjo nbꞌanttaq kyuꞌnxjal. Ex bꞌeꞌxsin i xiꞌ tzma Iconio. ");
INSERT INTO mamC_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Me ayetzin kyeꞌ nimil nojnintaq kyeꞌ kyanmin tukꞌa tzaljbꞌil ex tukꞌa Xewbꞌaj Xjan. ");
INSERT INTO mamC_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tej kykanin toj Iconio, junx i okx Pabl tukꞌa Bernabé toj ja te kynaꞌbꞌl Dios aj Judiy, ex i ok ten yolil toj tumilxix. Tuꞌntziꞌn, nimku xjal i nimin, aye Judiy ex qe nya Judiy. ");
INSERT INTO mamC_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Me ayetzin kye Judiy, ayeꞌ kykyꞌeꞌtaq tuꞌn kynimin, bꞌeꞌx i ok ten kyeꞌ tzpetsilte kynabꞌljo nya Judiyqe, tuꞌntzintla tkubꞌ kyximin nya bꞌaꞌn kyiꞌj nimil. ");
INSERT INTO mamC_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tuꞌnpetziꞌn, nim qꞌij i kyij Pabl ex Bernabé, aye tsanjil, antza. I yolin jikyin wen tiꞌjjo tkꞌuꞌjbꞌil Dios, quꞌn tuꞌn qꞌuqletaq kykꞌuꞌj tiꞌj tAjaw Tkyaqil. Tuꞌnpetziꞌn, i tzaj mojin tiꞌjjo nkyqꞌmaꞌntaq tuꞌn tAjaw Tkyaqil, ex tzaj qꞌoꞌn kyoklin, tuꞌn tbꞌant techil tipin Dios kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Me ayetzin kyexjal te toj tnam, paꞌntaq iteꞌye. Jteꞌbꞌin teꞌ nchi mojintaq kyukꞌa Judiy, ex txqantl kyukꞌa tsanjil. ");
INSERT INTO mamC_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tuꞌnpetziꞌn, i kyij toj wen a xjal Judiy exqetziꞌn nya Judiy, junx kyukꞌa kawil toj tnam, tuꞌn kyok yiset Pabl ex Bernabé, ex tuꞌn kyok xoyit tukꞌa abꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Me atzaj teꞌ kybꞌiꞌnte Pabl ex Bernabé, bꞌeꞌx i okx tzma Listra ex Derbe, tnamqe toj txꞌotxꞌ te Licaonia, ex kyojjo najbꞌil iteꞌtaq kyiꞌjile. ");
INSERT INTO mamC_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Antza, i yoline tiꞌjjo Tbꞌanil Tqanil. ");
INSERT INTO mamC_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Toj Listra, attaq jun ichin mibꞌintaq bꞌet. Mix jaꞌ otaq bꞌete, quꞌn tuꞌn koxtaq te titzꞌjlin. Qꞌuqletaqjo ichin, ");
INSERT INTO mamC_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ex nbꞌiꞌntaq tiꞌjjo ntqꞌmaꞌntaq Pabl. Ok kyim Pabl tiꞌj, ex el tnikyꞌtzajil qa nimtaq tnimbꞌil tuꞌn tqꞌanit. ");
INSERT INTO mamC_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Xitzin tqꞌmaꞌn Pabl qꞌajqꞌoj wen kyjaluꞌn: ¡Weꞌksa, ex weꞌkuxixa jikyin wen! Jaw tꞌikypajjo ichin, ex ok ten bꞌetil. ");
INSERT INTO mamC_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Atzaj teꞌ tok kykaꞌyiꞌn a otaq bꞌant tuꞌn Pabl, bꞌeꞌx i ok ten kye xjal ẍchꞌil tojjo yol kye xjal te Licaonia, ex kyqꞌma: Diosqe kyeꞌ, a iky qeꞌ tzeꞌnku ichin, a loqe ma chi kꞌuꞌl qxol. ");
INSERT INTO mamC_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ok qꞌoꞌn Bernabé kyuꞌn tzeꞌnku kydios, Zeus tbꞌi, ex ante Pabl, ok qꞌoꞌn tzeꞌnku kydios, Hermes tbꞌi, quꞌn tuꞌn ataqxixsin nyoliꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Atzin ja te naꞌbꞌl Zeus attaq ttxaꞌn tnam, ex atzin tpale i tzaj tiꞌn tman wakx ex jun pkꞌoj t-xmakil kꞌul. Ex atzin pale, junx kyukꞌa kykyaqil xjal, kyajtaq tuꞌn tkubꞌ kybꞌyoꞌn tman wakx, ex kyajtaq tuꞌn kykꞌulin kywutz Pabl ex Bernabé, aye tsanjil. ");
INSERT INTO mamC_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Me tej tel kynikyꞌ Bernabé ex Pabl ikyjo, bꞌeꞌx i kubꞌ kylaqin kyxbꞌalin te yekꞌbꞌilte, qa nya wentaqjo nbꞌant. Ex bꞌeꞌx i okx kyxol xjal, ex i jaw yolin kujxix wen ex kyqꞌma: ");
INSERT INTO mamC_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ayiꞌy xjal, ¿Tiquꞌnil nkubꞌ kybꞌinchinjiꞌy lo? Ichinqo qeꞌ tzeꞌnku kyeꞌ. Ex ma qo ula qꞌmalte kyeꞌy, tuꞌn tkyij kytzaqpinjiꞌy a nbꞌant kyuꞌn, quꞌn ntiꞌx tajbꞌin twutzjo Dios, a nimxix toklin. Tuꞌntzintzjo, kytxꞌixpinks kynabꞌla tukꞌa Dios itzꞌ, a kubꞌ bꞌinchinte kyaꞌj, txꞌotxꞌ, ex ttxuyil aꞌ, ex tkyaqiljo at kyoj. ");
INSERT INTO mamC_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Exla qa kyoj junxil qꞌij te ojtxe, ma tzaj ttziyin te Dios, tuꞌn t-xi tiꞌn teyile junjun tumil tbꞌe nya wen. ");
INSERT INTO mamC_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Me mina xkyij ttzaqpiꞌn te Dios tuꞌn tyekꞌin te tibꞌ, noq tuꞌn tbꞌanil nbꞌanttaq tuꞌn. Quꞌn atzin nxi qꞌonte jbꞌal kyibꞌaja, exsin tbꞌanil awal, ex a ntzaj qꞌonte tkyaqil tuꞌntzintla kywaꞌn, ex tuꞌn kytzalaja. ");
INSERT INTO mamC_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Me mixla tuꞌn qꞌumle tkyaqiljo lo, oxpe chi miyetkuxjal, tuꞌn kybꞌiyin kyiꞌjjo tman wakx, tuꞌn kyok te oyaj, ajtaq kykꞌulin kywutz tsanjil. ");
INSERT INTO mamC_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tojxjo ambꞌil anetziꞌn, i kanin jun jteꞌbꞌin Judiy te Antyokiy ex te Iconio. Aye txꞌixpin teꞌ kynabꞌl xjal tiꞌjjo nkubꞌ kybꞌinchin. Ex noq tuꞌn kypaj, i ok xoꞌn Pabl tukꞌa abꞌj, ex kubꞌtzin kybꞌisin qa otaq kyim kyuꞌn. Xi jukikin tzma ttxaꞌn tnam. ");
INSERT INTO mamC_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Me atzaj teꞌ tok kychmoꞌn nimil kyibꞌ tiꞌjile Pabl, bꞌeꞌx jaw weꞌ, ex okx juntl majl toj tnam. Ex toj junxil qꞌij, xiꞌ tukꞌa Bernabé tzma Derbe. ");
INSERT INTO mamC_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tbꞌajlinxitziꞌn ikyjo, i yolin tiꞌjjo Tbꞌanil Tqanil toj Derbe. Antza, kubꞌe kykꞌuꞌj txqan xjal, ex bꞌeꞌx i nimin. I meltzꞌajtzin Pabl ex Bernabé toj txꞌotxꞌ Listra, toj Iconio ex toj Antyokiy. ");
INSERT INTO mamC_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ex kyojjo najbꞌil anetziꞌn, i nimsin kykꞌuꞌj nimil, ex xi kyqꞌmaꞌn kye, tuꞌn kyok lipe jikyin wen tojjo kynimbꞌil. Ex kubꞌ qꞌmaꞌn kyxol, qa il tiꞌj tuꞌn tikyꞌx nya bꞌaꞌn kyuꞌn, qa kyajtaq tuꞌn tkawin qMan Dios toj kyanmin ex toj kychwinqil, ex qa kyajtaq tuꞌn kykanin tukꞌa Dios toj kyaꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ex jaw skꞌoꞌn tojjo Ttanim Dios, ilaꞌ ichin tuꞌn kyok te tnejil kyxol nimil, ex tej kybꞌaj paꞌn waꞌyaj te naꞌj Dios, bꞌeꞌx xi oqxenin toj tqꞌobꞌ tAjaw Tkyaqil, ayeꞌ otaq chi nimin. ");
INSERT INTO mamC_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tej kyikyꞌ toj txꞌotxꞌ te Pisidia, i kanin toj txꞌotxꞌ te Panfilia. ");
INSERT INTO mamC_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","I yolin antza tiꞌjjo Tbꞌanil Tqanil Jesús toj tnam Perge. Tbꞌajlinxiꞌ ikyjo, i xtaꞌj tzmax Atalia. ");
INSERT INTO mamC_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Antza, i xiꞌ toj bark tuꞌn kykanin tzma Antyokiy, jaꞌ otaq chex oqxenine toj tqꞌobꞌ Dios, a nkꞌuꞌjlintaq kyiꞌj, ex tojjo aqꞌuntl, a otaq japin bꞌaj kyuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tej kykanin tzma Antyokiy, ok kychmoꞌn Ttanim Dios, ex xi kyyolin tkyaqiljo otaq bꞌant tuꞌn Dios kyukꞌa, ex quꞌn tuꞌn otaq txi qꞌoꞌn kyoklin, a nya Judiyqetaq, tuꞌn kynimin. ");
INSERT INTO mamC_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Atzin te Pabl ex Bernabé, ilaꞌ qꞌij i kyij ten kyeꞌ kyukꞌaꞌ nimil antza. ");
INSERT INTO mamC_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tojjo ambꞌil anetziꞌn, jun jteꞌbꞌin xjal otaq cheꞌx toj txꞌotxꞌ te Judey, tuꞌn kykanin toj tnam Antyokiy, ex xi kyxikybꞌin jun xnaqꞌtzbꞌil kye nimil, ex kyqꞌma qa nlay chi klet, qa mina s-ok kyqitin jun kyechil tiꞌj kytzꞌumil, tzeꞌnkuxjo otaq tqꞌma Moisés toj Tuꞌjil Tyol Dios. ");
INSERT INTO mamC_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Me atzin te Pabl ex Bernabé nimku i jaw chꞌotj kyukꞌaxjal. Me atzaj teꞌ tjapin bꞌajjo yol, bꞌeꞌx i xi chqꞌoꞌn Pabl ex Bernabé, junx kyukꞌa junjun nimil, tuꞌn kyxiꞌ tzma Jerusalén tuꞌn kyyolin kyukꞌa tsanjil exqe nejinel toj Ttanim Dios, tiꞌj tkyaqiljo a otaq kyij ttzꞌibꞌin Moisés. ");
INSERT INTO mamC_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Otaqtzin chex chqꞌoꞌn ikyjo tuꞌn Ttanim Dios toj Antyokiy; atzaj teꞌ kyikyꞌ toj txꞌotxꞌ te Fenicia ex Samaria, xi kyqꞌmaꞌn kye nimil anetziꞌn, qa otaq kyij kytzaqpiꞌn aye nya Judiy a nbꞌanttaq kyuꞌn, tuꞌn kyok lipe tiꞌj qMan Dios. Tuꞌnjo tqanil ikyjo, bꞌeꞌx i ja tzalaj tkyaqil nimil. ");
INSERT INTO mamC_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tej kykanin Pabl ex Bernabé toj Jerusalén, i kꞌmet tukꞌa tzaljbꞌil kyuꞌn tsanjil, junx kyukꞌa jniꞌ nejinel ex tkyaqil Ttanim Dios. Xitzin kyyolintz tkyaqiljo otaq bꞌant kyuꞌn, noq tiꞌj tbꞌi Dios. ");
INSERT INTO mamC_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Me kyxol Ttanim Dios antza, iteꞌtaq jun chꞌuq Parisey, a otaq chi nimin. Jaw weꞌks, ex kyqꞌma kyjaluꞌn: Il tiꞌj tuꞌn tok kyqitiꞌn jun kyechiljo nimil, a nya Judiyqe ikyxjo tzeꞌnku qeꞌ; quꞌn ikytzin knimitiljo tkyaqil tkawbꞌil Moisés tibꞌaj qchwinqil, a awo aj Judiyqo. ");
INSERT INTO mamC_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Oktzin kychmoꞌn kyibꞌjo tsanjil exqetziꞌn jniꞌ nejinel, noq tuꞌn kyximin tiꞌj tkyaqiljo ikyjo. ");
INSERT INTO mamC_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ilaꞌ or bꞌaj chꞌotj. Atzaj teꞌ tjapin bꞌaj kyyol, jawtzin weꞌks Pegr, ex tqꞌma: Ayiꞌy werman, bꞌin kyeꞌ kyuꞌn, qa atxix ojtxe, o chin skꞌeta tuꞌn qMan Dios kyxola, tuꞌn tqꞌmetjo Tbꞌanil Tqanil kolbꞌil kye xjal nya Judiyqe, tuꞌntla kynimin. ");
INSERT INTO mamC_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ex tuꞌn tojtzqiꞌntaq te Dios kyanmin, xi tqꞌoꞌn kyoklin, ex xi tqꞌoꞌn Xewbꞌaj Xjan toj kyanmin te jun techil qa o chi nimin tiꞌj, ex qa nya il tiꞌj jun techil tiꞌj kytzꞌumil, ikyxjo tzeꞌnku qeꞌ, awo aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tuꞌntzintzjo, junx qten kyukꞌa twutz Dios, quꞌn o txꞌixpit kychwinqil noq tuꞌn kynimbꞌil, ikyxjo tzeꞌnku qe. ");
INSERT INTO mamC_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Tiquꞌntzin njaw kynimsin kyeꞌ kyibꞌ twutz Dios, tuꞌn t-xi kyqꞌmaꞌn kye nimil nya Judiyqe, qa il tiꞌj tuꞌn tkubꞌ nimit tkyaqil tkawbꞌil Moisés tibꞌajjo kychwinqil xjal, ex naꞌmx tbꞌantqe qniminte, exqetziꞌn ojtxe qxeꞌchil? Noq ma tzꞌok kytzꞌaqtzin kyejiꞌy mikyxi te Diosjo ntqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Awotzinqe nxi qnimin qa kloꞌnqo toj il nya tukꞌa juntl tiꞌ, chi Pegr, qalaꞌ noq tuꞌn t-xtalbꞌil qAjaw Jesús, ikyxjo tzeꞌnku kye nimil nya Judiy. ");
INSERT INTO mamC_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tbꞌajlinxiꞌ ikyjo, kykyaqilx kubꞌ numle, exsin kubꞌ kybꞌiꞌn kyyol Bernabé ex Pabl, a nchi yolintaq tiꞌj tkyaqiljo tbꞌanil techil exqetziꞌn nim kyoklin, a otaq bꞌant kyuꞌn kyxoljo aj nya Judiyqe, me noq tuꞌn attaq Dios kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Atzaj teꞌ tjapin bꞌaj kyyol, jawtzin yolin Santyaw ex tqꞌma: Chin kybꞌintza, werman. ");
INSERT INTO mamC_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ma tzaj tqꞌmaꞌn Pegr qe, tzeꞌn tten xi tqꞌoꞌn Dios kyoklin ayeꞌ nya Judiyqe exqotzintz, tuꞌn qok qkyaqilx te Ttanim Dios. ");
INSERT INTO mamC_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","A qmujbꞌil qibꞌ kyukꞌa nya Judiyqe, bꞌeꞌx qꞌumle toj Tuꞌjil Tyol Dios kyuꞌn yolil Tyol. Chiꞌ kyjaluꞌn: ");
INSERT INTO mamC_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Tbꞌajlinxitziꞌn luꞌn, chin ul juntl majla nikꞌulte tkawbꞌil tyajil David, a nmaq kawil ojtxe, a ma tzꞌel xitj, tuꞌntzin tel wen juntl majltz, ");
INSERT INTO mamC_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tuꞌntzintla kykyaqilxjo Judiy ex nya Judiyqe, a at kyoklin noq tiꞌj tumil nbꞌiy, nchi jyon wiꞌja, a ayiꞌn tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ate tAjaw Tkyaqil qꞌman teꞌ jniꞌxjo luꞌn, atxix ojtxe. ");
INSERT INTO mamC_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Tzuntzin nkubꞌ nbꞌisintza, chi Santyawjo, qa nya il tiꞌj tuꞌn tkubꞌ kybꞌinchin aye nya Judiyqe tkyaqiljo nbꞌant quꞌn, a awo Judiyqo. ");
INSERT INTO mamC_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Me tuꞌntzin ntiꞌ qꞌoj kyxoljo nimil Judiy ex nya Judiy, noq tuꞌn qbꞌinchbꞌin qxolx, iltzin tiꞌj tuꞌn t-xi tzꞌibꞌit jun uꞌj kyeꞌ nya Judiy, tuꞌn mina t-xi kychyoꞌn kychibꞌjiljo aluꞌmj, a nchi kubꞌ bꞌyet te chojbꞌil il kywutzjo txqantl kydiosxjal; ex tuꞌn mina txi kychyoꞌn kychibꞌjiljo aluꞌmj, a nchi jaw kyim, mo nchi jaw kyjtzꞌoꞌn kyibꞌ; ex tuꞌn mina tkubꞌ kytzqꞌajsiꞌn chikyꞌ te kychiꞌ; ex nya wen tuꞌn kykubꞌ kẍe kyukꞌa junxil qya, qa nya kyxuꞌjil. Tzuntzin nxi nqꞌmaꞌntza ikyjo, quꞌn tkyaqiljo lo, manyor tzꞌilx toj qwutz awo Judiyqo. Me nya taj qMan Dios, tuꞌn tkux ikyꞌbꞌil qxol awo nimilqo, noq tuꞌn nya junxjo qbꞌinchbꞌin qxolx. ");
INSERT INTO mamC_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Me toj nwutza nya tuꞌn tel ikyꞌit tkawbꞌil Moisés, quꞌn toj tkyaqil tnam, nimku Judiy at, a o tzꞌel kynikyꞌ te tkyaqil tkawbꞌil Moisés, ex kyajxix tuꞌn tkubꞌ nimit tkyaqil; quꞌn atxix ojtxe nchi qꞌumlaj tiꞌj tkawbꞌil Moisés kyojileꞌ tkyaqil ja te nabꞌl Dios, tzeꞌnku nkubꞌ ikyꞌsitjo qꞌij te ajlabꞌl. ");
INSERT INTO mamC_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jaw kyskꞌoꞌn kye tsanjil exqe nejinel toj Ttanim Dios, jun jteꞌ ichin kyxol nimil, ex tuꞌn kyxi chqꞌet tzma toj tnam te Antyokiy. I xitzin chqꞌoꞌn kabꞌe nejinel kyxol, a Silas ex Judas, a Barsabásjo juntl tbꞌi, tuꞌn kyxiꞌ junx tukꞌa Pabl ex Bernabé. ");
INSERT INTO mamC_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ex kye xi qꞌoꞌne jun uꞌj, a iky ntqꞌmaꞌn kyjaluꞌn: Kchi xel qqꞌolbꞌiꞌn ayiꞌy erman, kꞌuꞌjlinqe quꞌn: Awoqejiꞌy tsanjil Jesús exqetziꞌn nejinel toj Ttanim Dios toj Jerusalén, nxi qtzꞌibꞌiꞌn kyeꞌy, a ayiꞌy nya Judiyqiꞌy ex najleqiꞌy toj Antyokiy, Siria ex Cilicia. ");
INSERT INTO mamC_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bꞌiꞌn quꞌn, qa ilaꞌ xjal o chi kanin kyxola, me nya awoꞌy o qox chqꞌonkye, ex qa ma jawje kykꞌuꞌja tuꞌn kyyol, ex tuꞌntziꞌn, o chi jaw naja. ");
INSERT INTO mamC_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Tuꞌnpetziꞌn, ma qo kyija toj wen, tuꞌn kyxi chqꞌet jun jteꞌbꞌin qxola, tuꞌn kykanin kyukꞌiy, junx kyukꞌa qerman Bernabé ex Pabl, a kꞌuꞌjlinqexix quꞌn, ");
INSERT INTO mamC_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","quꞌn ayetzin kye o txi kyqꞌoꞌn kyibꞌ te kyimin, noq tiꞌj tbꞌi Jesucrist, a tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ex ma chex qchqꞌoꞌn Judas ex Silas, ayetzin chi yoliljo kyukꞌiy, tuꞌn t-xi kychikyꞌbꞌin tkyaqiljo ma bꞌaj qqꞌmaꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Bꞌaꞌn ma tzꞌele te Xewbꞌaj Xjan ex te qeꞌy, tuꞌn mina xkubꞌ kyniminjiꞌy tkyaqiljo tkawbꞌil Moisés, a tzeꞌnku nbꞌant quꞌn, a awoꞌy Judiyqoꞌy, qalaꞌ oꞌkxjo luꞌn: ");
INSERT INTO mamC_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tuꞌn mina t-xi kychyoꞌn kychibꞌjiljo aluꞌmj, a nchi kubꞌ bꞌyet te chojbꞌil il kywutzjo txqantl kydiosxjal; ex tuꞌn mina t-xi kychyoꞌn kychibꞌjiljo aluꞌmj, a njaw kyjtzꞌoꞌn kyibꞌ; ex tuꞌn mina chi tzqꞌajsiꞌn tiꞌjjo chikyꞌ te kychiꞌy; ex nya wen tuꞌn kykubꞌ kẍeꞌy kyukꞌa junxil qya, qa nya kyxuꞌjila. Qa ma kubꞌ kytzyuꞌn kyibꞌa te tkyaqiljo lo, tbꞌanilxsin kybꞌinchbꞌintza ikyjo. Kykaꞌyinktzin kyibꞌtza. ");
INSERT INTO mamC_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Atzaj teꞌ kybꞌaj yolin, ex tej tbꞌaj kytzꞌibꞌin uꞌj, bꞌeꞌxsin i xiꞌtz toj Antyokiy. Atzaj teꞌ kykanin, oktzin kychmoꞌn Ttanim Dios, ex xi kyqꞌoꞌn uꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Atzaj teꞌ tjaw kyuꞌjiꞌn nimil toj Antyokiy, bꞌeꞌx i jaw tzalaj nimxix, quꞌn tuꞌn qꞌuqbꞌil kꞌuꞌjbꞌaj tzꞌibꞌin toj, qa nya il tiꞌj tuꞌn kybꞌinchin tiꞌj tkyaqiltaqjo nbꞌant kyuꞌn aj Judiy. ");
INSERT INTO mamC_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ayetzin kye Judas ex Silas, a qꞌoꞌntztaq kyoklin tuꞌn qMan Dios te qꞌmal teꞌ Tyol, i nimsin kykꞌuꞌjjo nimil tuꞌn kyyol, ex xi kyqꞌmaꞌn, tzeꞌn tuꞌn tjaw kyin kyibꞌ tojjo kynimbꞌil. ");
INSERT INTO mamC_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tbꞌajlinxiꞌ jun jteꞌbꞌin qꞌij ikyjo, bꞌeꞌxsin i meltzꞌajtz toj Ttanim Dios toj Jerusalén, ex kyij kyqꞌoꞌn jun qꞌolbꞌil te nukꞌbꞌil ex toj tbꞌanilxix. ");
INSERT INTO mamC_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Me bꞌeꞌx kyij Silas antza. ");
INSERT INTO mamC_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ex atzin te Pabl ex Bernabé axsa i kyije kyeꞌ toj Antyokiy, ex junx kyukꞌa txqantl, i xnaqꞌtzin, ex i qꞌumlaj tiꞌj Tyol tAjaw Tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tbꞌajlinxi jteꞌbꞌin qꞌij, xi tqꞌmaꞌn Pabl te Bernabé kyjaluꞌn: Qoꞌ juntl majl qꞌolbꞌil kyeꞌ erman toj tkyaqil tnam, jaꞌ o qꞌmete Tyol tAjaw Tkyaqil, tuꞌntzin tel qnikyꞌ te tzeꞌn iteꞌye. ");
INSERT INTO mamC_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Kutzin, chte Bernabé. Me tajtaq Bernabé tuꞌn t-xiꞌ Juan, a Marksjo juntl tbꞌi, kyukꞌa. ");
INSERT INTO mamC_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Me nya bꞌaꞌn ele luꞌn toj twutz Pabl, quꞌn tuꞌn otaq tzꞌel tpaꞌn te Marks tibꞌ kyiꞌj, tej iteꞌtaq toj txꞌotxꞌ te Panfilia, ex tkyꞌeꞌtaq tuꞌn tten kyukꞌa toj taqꞌin Dios. ");
INSERT INTO mamC_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nimx xaꞌyeꞌ chꞌotjin lo. Tuꞌntziꞌn, bꞌeꞌx el kypaꞌn kyibꞌ; atzin te Bernabé xi kꞌlente Marks, ex bꞌeꞌx i xiꞌ toj txꞌotxꞌ te Chipre. ");
INSERT INTO mamC_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Atzin te Pabl jaw tskꞌoꞌn Silas, ex xi oqxenin toj tqꞌaqꞌbꞌil tkꞌuꞌj tAjaw Tkyaqil kyuꞌn txqantl nimil. ");
INSERT INTO mamC_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Atzaj teꞌ kyikyꞌx toj txꞌotxꞌ Siria ex Cilicia, i nimsin kykꞌuꞌjjo nimil toj Ttanim Dios, a iteꞌtaq antza. ");
INSERT INTO mamC_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Kanin Pabl kyojjo tnam te Derbe ex Listra. Antza, el knete jun nimil tuꞌn, Timotey tbꞌi, albꞌaj te jun nimil qya aj Judiy. Me atzin ttata nya aj Judiy, qalaꞌ te aj Grecia. ");
INSERT INTO mamC_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tkyaqil qeꞌ nimil toj Listra ex te Iconio wentaqjo kyyol tiꞌj. ");
INSERT INTO mamC_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Tajtaq Pabl tuꞌn tok lipe Timotey tiꞌj, me nejtaq tuꞌn tok tqitin techil tiꞌj ttzꞌumil, tuꞌntzintla mina ja kyikyꞌin aj Judiy a najleqetaq antza, exsintla tuꞌn tkubꞌ nimitjo a otaq tzꞌibꞌit toj Tuꞌjil Tyol Dios. Kubꞌ bꞌinchin ikyjo tukꞌa Timotey, quꞌn kykyaqil bꞌiltetaq qa antza jawe chꞌiye tjaqꞌ tkawbꞌil Moisés, quꞌn a tnana jun aj Judiy, me naꞌmtaq tok techil, quꞌn nya Judiytaqjo ttata. ");
INSERT INTO mamC_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Toj kykyaqiljo tnam, jaꞌ nchi ikyꞌetaq, xi kyqꞌmaꞌn kye nimil jotxjo tumil, a otaq tzaj kyqꞌmaꞌn tsanjil, exqetziꞌn jniꞌ nejinel toj Ttanim Dios toj Jerusalén. ");
INSERT INTO mamC_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tuꞌntziꞌn, nimsit kynimbꞌiljo Ttanim Dios, ex tuꞌn tchꞌiye kybꞌajjo nimil junjun qꞌij. ");
INSERT INTO mamC_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Me atzin te Xewbꞌaj Xjan mix ttziye tuꞌn tqꞌmetjo Tbꞌanil Tqanil tojjo txꞌotxꞌ te Asia. Tuꞌntziꞌn, antza i ikyꞌe toj txꞌotxꞌ te Frigia ex te Galacia, ");
INSERT INTO mamC_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","tuꞌn kykanin tzma ttxaꞌn txꞌotxꞌ te Misia. Antza, kubꞌe kynaꞌbꞌlin, tuꞌn kyokx toj txꞌotxꞌ te Bitinia, me juntl majl, mix ttziye Xewbꞌaj Xjan, a T-xew Jesús. ");
INSERT INTO mamC_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tuꞌntziꞌn, majx tqanku ikyꞌx toj Misia, tuꞌn kykuꞌx ttzi ttxuyil aꞌ tojjo tnam, Troas tbꞌi. ");
INSERT INTO mamC_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Antza, oke jun twutzikyꞌ Pabl tojjo qnikyꞌin. Toj twutzikyꞌ, tli waꞌltaq jun ichin aj Macedonia, ex nkubꞌsintaq twutz, ex tqꞌma: Ku tzaja tzaluꞌn toj Macedonia, ex qo tmojintza. ");
INSERT INTO mamC_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Tuꞌn tzaj twutzikyꞌ Pabl ok, bꞌeꞌxsin kubꞌ qbꞌinchin qibꞌtza, tuꞌn qxiꞌy tzma Macedonia, quꞌn el qnikyꞌa tiꞌj, qa ataq qMan Dios ntxokintaq qiꞌja, tuꞌn tqꞌmetjo Tbꞌanil Tqanil antza. ");
INSERT INTO mamC_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","12","Tojjo tnam te Troas, o okxa toj jun bark, exsin o bꞌettza toj ttxuyil aꞌ, tuꞌn qkaniꞌn toj muchꞌ txꞌotxꞌ, Samotracia tbꞌi. Ex tojxi juntl qꞌij, o kaniꞌn toj Neápolis. Antza, o xiyiꞌy tuꞌn qkaniꞌn toj tnam Filipos, a tnam luꞌn, a etzin kyuꞌn aj Rom, ex atzin jun tnamjo nim toklin toj tkyaqil txꞌotxꞌ te Macedonia. Ilaꞌ qꞌij o teꞌn antza. ");
INSERT INTO mamC_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Toj jun qꞌij te ajlabꞌl, o exa ttxaꞌn tnam tzma ttzi jun aꞌ n-ajqelin, quꞌn kubꞌ qbꞌisiꞌn qa antza nchi naꞌne jun chꞌuq Judiy Dios. Bꞌeꞌxsin o kubꞌ qeꞌy, ex o yoliꞌn tiꞌj Tbꞌanil Tqanil kyeꞌ qya, a otaq chi chmet antza. ");
INSERT INTO mamC_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lidiataq teꞌ jun tbꞌi, te aj Tiatira, ex jun kꞌayiltaq tbꞌanil xbꞌalin, a wiꞌyilxix. Ajo qya lo, a bꞌaꞌnxixtaq kꞌulin twutz Dios, ex nbꞌintaq tiꞌjjo nyolajtztaq. Ok tyekin Dios tanmin, tuꞌn tok tbꞌiꞌnxixjo, a nqꞌumletaq tuꞌn Pabl. ");
INSERT INTO mamC_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kuꞌx toj aꞌ te jawsbꞌil aꞌ, junx kyukꞌa kykyaqiljo a iteꞌtaq toj tja. Tbꞌajlinxitziꞌn ikyjo, kubꞌsin twutz qeꞌy, ex tqꞌma: Qa matxixix txi kynimiꞌn, qa bꞌaꞌnxix nteꞌn twutz tAjaw Tkyaqil, kuxsin chi tzajtza, tuꞌn kyteꞌn qukꞌiy toj njaꞌy. Ox kubꞌsinx twutz qeꞌy; tuꞌntziꞌn, xi qtziyiꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Bꞌaj jun maj, kyjaꞌtaq qxiꞌy tzma ttzi aꞌ, jaꞌ nkubꞌ naꞌyetaq Dios, ok qkꞌulbꞌiꞌn jun kuꞌxin qya, a nkanintaq tnabꞌl tiꞌjjo naꞌmxtaq tul kanin, quꞌn tzyuꞌntaq tanmin tuꞌn taqꞌnil tajaw il. Jun aqꞌniltaqjo kuꞌxin qya luꞌn, ex nimtaq kypwaqjo tajaw nkykanbꞌin noq tuꞌn nbꞌanttaq tuꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Bꞌeꞌxsin ok lipe kuꞌxin qya qiꞌja, ex jaw ẍchꞌin, ex tqꞌma: Nchi ajbꞌinxixjo ichin lo te Dios nimxix toklin, ex nchi yekꞌin tumil kolbꞌil kyeꞌy. ");
INSERT INTO mamC_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ilaꞌ qꞌij tqꞌma ikyjo; otaq bꞌaj tkꞌuꞌj Pabl tiꞌj. Tzaj meltzꞌaj, ex tqꞌma te taqꞌnil tajaw il, a tokxtaq toj tanmin; chiꞌ kyjaluꞌn: Noq tiꞌj tbꞌi Jesucrist kxel nqꞌmaꞌn tey, tuꞌn tetza toj tanminjo kuꞌxin qya. Ex texjo paq anetziꞌn, bꞌeꞌx etz. ");
INSERT INTO mamC_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Me atzaj teꞌ tel kynikyꞌ tajaw kuꞌxin qya, qa nlay kykanbꞌe txqantl pwaq tuꞌn, bꞌeꞌxsin ok kytzyuꞌntz Pabl ex Silas, ");
INSERT INTO mamC_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ex bꞌeꞌx xi qꞌiꞌn jaꞌ iteꞌtaq kawil, ex xi kyqꞌmaꞌn: Aye ichin aj Judiy lo, ma chi ok ten najsil kyeꞌ xjal tojjo qtanim, ");
INSERT INTO mamC_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ex nchi xnaqꞌtzin tiꞌjjo a nlay qtziye, ex nlay kubꞌ qbꞌinchin, quꞌn aj te Romqo. ");
INSERT INTO mamC_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tuꞌntzin ikyjo, bꞌeꞌx jaw tiljxjal kyiꞌj, exsin tzaj kyqꞌmaꞌn kawil, tuꞌn teljo kyxbꞌalin, ex tuꞌn kyok jubꞌin tuꞌn tze. ");
INSERT INTO mamC_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ilaꞌ maj bꞌaj jubꞌin. Tbꞌajlinxitziꞌn ikyjo, i kux qꞌoꞌn toj tze, exsin xi qꞌmantz teꞌ xqꞌuqil tze, tuꞌn kyxqꞌuqit wen. ");
INSERT INTO mamC_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tej tbꞌinte xqꞌuqil ikyjo, bꞌeꞌxsin i okx qꞌoꞌntz tzma txeje, ex kubꞌ yiqꞌoꞌn kyqan, tuꞌn mina chi jaw yekj. ");
INSERT INTO mamC_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Me otaqla tzꞌok nikyꞌjin aqꞌwil ikyjo, tzmataq nnaꞌn Pabl Dios junx tukꞌa Silas, ex nchi bꞌitzintaq bꞌitz te Dios. Ayetzin kye txqantl xjal, a iteꞌkuxtaq toj tze, tzuntaq nchi bꞌin kyeꞌ. ");
INSERT INTO mamC_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Me noq kynaꞌbꞌinkux, teꞌ ttzaj jun kyaqnajnabꞌ kuj wen, a bꞌeꞌx tzaj luꞌlin tqꞌuqil tze tuꞌn. Bꞌeꞌx i okx jaqpajjo tjpel, ex bꞌeꞌx i el tzꞌaqjo kxbꞌil, a iteꞌktaq te kꞌalbꞌil kyej iteꞌkuxtaq toj tze. ");
INSERT INTO mamC_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Atzaj teꞌ ttzaj sakꞌpajjo xqꞌuqil tze, exsin ok tkaꞌyintz qa otaq chi jaqpajjo tjpel, bꞌeꞌxsin jatz tiꞌn jun kxbꞌil te bꞌiybꞌil tibꞌ, quꞌn kubꞌ tnaꞌbꞌlin qa otaq chi oqjo xjal tkyaqil. ");
INSERT INTO mamC_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Me bꞌeꞌx jaw ẍchꞌin Pabl, ex tqꞌma: Mi kubꞌ tbꞌyoꞌn te tibꞌ. Loqo qeꞌ otoꞌ qkyaqilxa tzaluꞌn. ");
INSERT INTO mamC_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Xitzin tqanin tej xqꞌuqil tze jun tzaj. Ex okx ajqelin wen, ex tukꞌa txqan t-xobꞌil, kubꞌ meje twutz Pabl ex Silas, tuꞌn t-xi chjonte kye. ");
INSERT INTO mamC_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tbꞌajlinxitziꞌn ikyjo, xi qꞌmaꞌn kye, tuꞌn kyetz, ex xi qanin kye kyjaluꞌn: Ayiꞌy tata, ¿Tiꞌtzila chꞌin weꞌ, aku kubꞌ nbꞌinchiꞌn, tuꞌn nkleta? ");
INSERT INTO mamC_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Xitzin ttzaqꞌwin Pabl ex Silas: Niminxa Jesucrist, a tAjaw Tkyaqil; ikytzin kkletilejiy kyukꞌa kykyaqil t-xjalila. ");
INSERT INTO mamC_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","34","Ax orjo anetziꞌn, ok tenjo xqꞌuqil tze qꞌanilte kykyꞌixlbꞌin Pabl ex Silas, ayej otaq chi bꞌaj jubꞌin. Tbꞌajlinxitziꞌn ikyjo, bꞌeꞌx i xi kꞌleꞌn, tuꞌn xqꞌuqil tze, tuꞌn kykanin toj tja. Antza, i yoline Pabl ex Silas tukꞌa xqꞌuqil tze ex kyeꞌ iteꞌtaq toj tja, tiꞌjjo Tbꞌanil Tqanil. Tej tbꞌaj kybꞌiꞌn, bꞌeꞌx i jaw nimin kykyaqilx, ex bꞌeꞌx i etz peꞌn tuꞌn kykuꞌx toj aꞌ te jawsbꞌil aꞌ. Tej tbꞌajjo ikyjo, i okxsin kꞌleꞌntz tuja, ex xi qꞌoꞌn kywa. Ex bꞌeꞌx jaw tzalaj kykyaqilx, tuꞌn otaq chi nimin tiꞌj qMan Dios. ");
INSERT INTO mamC_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Qlixje wen, xi chqꞌoꞌn jun jteꞌ xqꞌuqil tnam kyuꞌn kawil, tuꞌn kyxiꞌ tukꞌa xqꞌuqil tze, ex tuꞌn t-xi qꞌmet te, qa tuꞌntaq ttzaqpaj Pabl ex Silas. ");
INSERT INTO