﻿USE sofia;
DROP TABLE IF EXISTS sofia.malc_vpl;
CREATE TABLE malc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES malc_vpl WRITE;
INSERT INTO malc_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ആദിയിൽ ദൈവം ആകാശവും ഭൂമിയും സൃഷ്ടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ഭൂമി രൂപരഹിതവും ശൂന്യവുമായിരുന്നു; വെള്ളം നിറഞ്ഞ ഭൂതലത്തിന്മേൽ അന്ധകാരം വ്യാപിച്ചിരുന്നു. ദൈവത്തിന്റെ ആത്മാവ് വെള്ളത്തിനുമീതേ വ്യാപരിച്ചുകൊണ്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","“പ്രകാശം ഉണ്ടാകട്ടെ,” ദൈവം അരുളിച്ചെയ്തു; പ്രകാശം ഉണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","പ്രകാശം നല്ലത് എന്നു ദൈവം കണ്ടു; അവിടന്നു പ്രകാശവും അന്ധകാരവുംതമ്മിൽ വേർതിരിച്ചു; ");
INSERT INTO malc_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ദൈവം പ്രകാശത്തെ “പകൽ” എന്നും അന്ധകാരത്തെ “രാത്രി” എന്നും വിളിച്ചു. സന്ധ്യകഴിഞ്ഞു, ഉഷസ്സുമായി—ഒന്നാംദിവസം. ");
INSERT INTO malc_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","“വെള്ളങ്ങളുടെ മധ്യേ ഒരു വിതാനം ഉണ്ടാകട്ടെ,” ദൈവം അരുളിച്ചെയ്തു; “വെള്ളവും വെള്ളവുംതമ്മിൽ വേർപിരിയട്ടെ” എന്നും കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","അങ്ങനെ ദൈവം ഒരു വിതാനം ഉണ്ടാക്കി, വിതാനത്തിനു താഴെയുള്ള വെള്ളവും മുകളിലുള്ള വെള്ളവുംതമ്മിൽ വേർതിരിയട്ടെ എന്നു കൽപ്പിച്ചു; അത് അങ്ങനെതന്നെ സംഭവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","വിതാനത്തെ ദൈവം “ആകാശം” എന്നു വിളിച്ചു. സന്ധ്യകഴിഞ്ഞു, ഉഷസ്സുമായി—രണ്ടാംദിവസം. ");
INSERT INTO malc_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","“ആകാശത്തിനുതാഴെയുള്ള വെള്ളം ഒരു സ്ഥലത്തു കൂടിച്ചേർന്ന് ഉണങ്ങിയ നിലം ഉണ്ടാകട്ടെ,” ദൈവം അരുളിച്ചെയ്തു; അങ്ങനെ സംഭവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ഉണങ്ങിയ നിലത്തിനു ദൈവം “കര” എന്നും വെള്ളത്തിന്റെ ശേഖരത്തിനു “സമുദ്രം” എന്നും പേരുവിളിച്ചു; നല്ലത് എന്നു ദൈവം കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","“ഭൂമിയിൽ സസ്യജാലങ്ങൾ മുളയ്ക്കട്ടെ: ഭൂമിയിൽനിന്ന് വിത്തുള്ള സസ്യങ്ങളും അതതുതരം വിത്തുള്ള ഫലം കായ്ക്കുന്ന വൃക്ഷങ്ങളും മുളച്ചുവരട്ടെ,” ദൈവം അരുളിച്ചെയ്തു; അങ്ങനെ സംഭവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ഭൂമി അതതുതരം വിത്തുള്ള സസ്യജാലങ്ങളും അതതുതരം വിത്തുള്ള ഫലം കായ്ക്കുന്ന വൃക്ഷങ്ങളും മുളപ്പിച്ചു. നല്ലത് എന്നു ദൈവം കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","സന്ധ്യകഴിഞ്ഞു, ഉഷസ്സുമായി—മൂന്നാംദിവസം. ");
INSERT INTO malc_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","“പകലും രാത്രിയുംതമ്മിൽ വേർതിരിക്കാൻ ആകാശവിതാനത്തിൽ പ്രകാശങ്ങൾ ഉണ്ടാകട്ടെ; ഋതുക്കൾ, ദിവസങ്ങൾ, സംവത്സരങ്ങൾ എന്നിവയെ തിരിച്ചറിയാനുള്ള ചിഹ്നങ്ങളായി ആ പ്രകാശങ്ങൾ മാറട്ടെ; ");
INSERT INTO malc_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ഭൂമിയെ പ്രകാശിപ്പിക്കാൻ ആകാശവിതാനത്തിൽ അവ പ്രകാശസ്രോതസ്സുകളായിരിക്കട്ടെ,” ദൈവം കൽപ്പിച്ചു; അങ്ങനെ സംഭവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","പകലിന്റെ അധിപതിയായി വലുപ്പം കൂടിയ പ്രകാശവും രാത്രിയുടെ അധിപതിയായി വലുപ്പം കുറഞ്ഞ പ്രകാശവും—ഇങ്ങനെ രണ്ടു വലിയ പ്രകാശത്തെ ദൈവം ഉണ്ടാക്കി. അവിടന്നു നക്ഷത്രങ്ങളെയും സൃഷ്ടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","ദൈവം ആകാശവിതാനത്തിൽ ഈ പ്രകാശങ്ങളെ സ്ഥാപിച്ചത് ഭൂമിയെ പ്രകാശിപ്പിക്കാനും പകലിന്റെയും രാത്രിയുടെയും അധിപതികളായിരിക്കാനും പ്രകാശവും ഇരുളുംതമ്മിൽ വേർതിരിക്കാനുമായിരുന്നു. നല്ലത് എന്നു ദൈവം കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","സന്ധ്യകഴിഞ്ഞു, ഉഷസ്സുമായി—നാലാംദിവസം. ");
INSERT INTO malc_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","“ജലത്തിൽ ജീവജന്തുക്കൾ പെരുകട്ടെ എന്നും ഭൂമിക്കുമീതേ ആകാശവിതാനത്തിൽ പക്ഷികൾ പറക്കട്ടെ,” എന്നും ദൈവം അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","അങ്ങനെ ദൈവം വലിയ സമുദ്രജീവികളെയും വെള്ളത്തിൽ കൂട്ടമായി ജീവിക്കുകയും സഞ്ചരിക്കുകയും ചെയ്യുന്ന അതതുതരം ജന്തുക്കളെയും സൃഷ്ടിച്ചു, കൂടാതെ അതതുതരം പക്ഷികളെയും സൃഷ്ടിച്ചു; നല്ലത് എന്നു ദൈവം കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ദൈവം അവയെ അനുഗ്രഹിച്ചുകൊണ്ട്, “നിങ്ങൾ വർധിച്ചു പെരുകി സമുദ്രജലത്തിൽ നിറയട്ടെ; ഭൂമിയിൽ പക്ഷികളും വർധിച്ചുവരട്ടെ,” എന്നും കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","സന്ധ്യകഴിഞ്ഞു, ഉഷസ്സുമായി—അഞ്ചാംദിവസം. ");
INSERT INTO malc_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","“ഭൂമിയിൽ അതതുതരം ജീവജന്തുക്കൾ ഉണ്ടാകട്ടെ: കന്നുകാലികൾ, ഇഴജന്തുക്കൾ, വന്യമൃഗങ്ങൾ എന്നിവ അതതിന്റെ വർഗമനുസരിച്ച് ഉണ്ടാകട്ടെ,” ദൈവം കൽപ്പിച്ചു; അങ്ങനെതന്നെ സംഭവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ഇപ്രകാരം ദൈവം അതതുതരം വന്യമൃഗങ്ങളെയും അതതുതരം കന്നുകാലികളെയും ഭൂമിയിൽ ഇഴയുന്ന അതതുതരം ഇഴജന്തുക്കളെയും ഉണ്ടാക്കി; നല്ലത് എന്നു ദൈവം കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","അതിനുശേഷം, “നമുക്ക് നമ്മുടെ സ്വരൂപത്തിലും നമ്മുടെ സാദൃശ്യത്തിലും മനുഷ്യനെ നിർമിക്കാം എന്നു ദൈവം കൽപ്പിച്ചു. അവർ സമുദ്രത്തിലെ മത്സ്യങ്ങൾക്കും ആകാശത്തിലെ പക്ഷികൾക്കും കന്നുകാലികൾക്കും സകലവന്യജീവികൾക്കും ഭൂമിയിൽ ഇഴയുന്ന സകല ഇഴജന്തുക്കൾക്കും അധിപതികളാകട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ഇങ്ങനെ, ദൈവം തന്റെ സ്വരൂപത്തിൽ മനുഷ്യനെ സൃഷ്ടിച്ചു; അവിടന്നു ദൈവസ്വരൂപത്തിൽ അവരെ സൃഷ്ടിച്ചു; പുരുഷനും സ്ത്രീയുമായി അവരെ സൃഷ്ടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ദൈവം അവരെ അനുഗ്രഹിച്ചു; “നിങ്ങൾ സന്താനസമൃദ്ധിയുള്ളവരായി പെരുകി ഭൂമിയിൽ നിറഞ്ഞ് അതിനെ അധീനമാക്കുക; സമുദ്രത്തിലെ മത്സ്യങ്ങളുടെമേലും ആകാശത്തിലെ പക്ഷികളുടെമേലും ഭൂമിയിൽ ചരിക്കുന്ന സകലജീവികളുടെമേലും അധിപതികളാകുക” എന്ന് അവരോടു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","“ഭൂമിയിലെങ്ങും വിത്തുള്ള സകലസസ്യങ്ങളും വിത്തോടുകൂടിയ ഫലം കായ്ക്കുന്ന സകലവൃക്ഷങ്ങളും ഞാൻ നിങ്ങൾക്കു നൽകുന്നു; അവ നിങ്ങൾക്ക് ആഹാരമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ഭൂമിയിലെ സകലജീവികൾക്കും ആകാശത്തിലെ എല്ലാ പക്ഷികൾക്കും കരയിൽ സഞ്ചരിക്കുന്ന സകലജന്തുക്കൾക്കും—ജീവശ്വാസമുള്ള എല്ലാറ്റിനും—ഞാൻ പച്ചസസ്യങ്ങളെല്ലാം ആഹാരമായി നൽകുന്നു” എന്നു ദൈവം അരുളിച്ചെയ്തു; അപ്രകാരം സംഭവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","അവിടന്നു നിർമിച്ചതൊക്കെയും ദൈവം നിരീക്ഷിച്ചു; അവയെല്ലാം വളരെ നല്ലതെന്ന് അവിടന്നു കണ്ടു. സന്ധ്യകഴിഞ്ഞു, ഉഷസ്സുമായി—ആറാംദിവസം. ");
INSERT INTO malc_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ഇങ്ങനെ, ആകാശവും ഭൂമിയും അവയിലുള്ള സകലത്തിന്റെയും സൃഷ്ടി പൂർത്തിയായി. ");
INSERT INTO malc_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ദൈവം ചെയ്തുകൊണ്ടിരുന്ന സകലപ്രവൃത്തിയും ഏഴാംദിവസമായപ്പോഴേക്കും പൂർത്തീകരിച്ചു; അതിനുശേഷം തന്റെ സകലപ്രവൃത്തിയിൽനിന്നും ഏഴാംദിവസം ദൈവം വിശ്രമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","സൃഷ്ടിസംബന്ധമായി അവിടന്നു ചെയ്ത സകലപ്രവൃത്തികളിൽനിന്നും സ്വസ്ഥനായതിനാൽ ഏഴാംദിവസത്തെ ദൈവം അനുഗ്രഹിച്ചു വിശുദ്ധീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","ആകാശത്തിന്റെയും ഭൂമിയുടെയും ഉൽപ്പത്തിവിവരം ഇപ്രകാരമാണ്: യഹോവയായ ദൈവം ആകാശവും ഭൂമിയും സൃഷ്ടിച്ച അവസരത്തിൽ വയലിലെ ചെടികളും സസ്യങ്ങളും അന്നുവരെ ഭൂമിയിൽ മുളച്ചിരുന്നില്ല; യഹോവയായ ദൈവം ഭൂമിയിൽ മഴ അയച്ചിരുന്നില്ല, മണ്ണിൽ അധ്വാനിക്കാൻ മനുഷ്യനും ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ഭൂമിയിൽനിന്ന് ഉറവ പൊങ്ങിയായിരുന്നു ഭൂതലം മുഴുവൻ നനഞ്ഞിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","യഹോവയായ ദൈവം നിലത്തെ പൊടികൊണ്ടു മനുഷ്യനെ മെനഞ്ഞു, അവന്റെ മൂക്കിൽ ജീവശ്വാസം ഊതി; അങ്ങനെ മനുഷ്യൻ ജീവനുള്ളവനായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","യഹോവയായ ദൈവം കിഴക്ക് ഏദെനിൽ ഒരു തോട്ടം നട്ടുണ്ടാക്കി, അവിടന്ന് മെനഞ്ഞെടുത്ത മനുഷ്യനെ അതിൽ ആക്കി. ");
INSERT INTO malc_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","മനോഹരവും ഭക്ഷ്യയോഗ്യവുമായ എല്ലാത്തരം വൃക്ഷങ്ങളും യഹോവയായ ദൈവം നിലത്തുനിന്നു മുളപ്പിച്ചു. തോട്ടത്തിന്റെ നടുവിൽ ജീവവൃക്ഷവും നന്മതിന്മകളെക്കുറിച്ചുള്ള അറിവിന്റെ വൃക്ഷവും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ഏദെനിൽനിന്ന് ഒഴുകിയ ഒരു നദി തോട്ടം നനച്ചു. ആ നദി അവിടെനിന്ന് നാലു ശാഖയായി പിരിഞ്ഞൊഴുകി. ");
INSERT INTO malc_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ഒന്നാമത്തേതിനു പീശോൻ എന്നു പേര്; അതു ഹവീലാദേശം മുഴുവൻ ചുറ്റുന്നു, അവിടെ തങ്കം ഉണ്ട്. ");
INSERT INTO malc_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ആ ദേശത്തെ തങ്കം അതിവിശിഷ്ടമാണ്; ഗുല്ഗുലുവും ഗോമേദകരത്നവും അവിടെയുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","രണ്ടാമത്തെ നദിയുടെ പേര് ഗീഹോൻ; അതു കൂശ് ദേശംമുഴുവനും ചുറ്റിയൊഴുകുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","മൂന്നാമത്തെ നദിയുടെ പേര് ടൈഗ്രീസ്; അത് അശ്ശൂരിൽനിന്നു കിഴക്കോട്ട് ഒഴുകുന്നു. നാലാമത്തെ നദി യൂഫ്രട്ടീസ്. ");
INSERT INTO malc_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","യഹോവയായ ദൈവം ഏദെൻതോട്ടത്തിൽ അധ്വാനിക്കുന്നതിനും അതിനെ സംരക്ഷിക്കുന്നതിനുമായി മനുഷ്യനെ അവിടെ തോട്ടത്തിൽ ആക്കി. ");
INSERT INTO malc_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","യഹോവയായ ദൈവം മനുഷ്യനോട് അരുളിച്ചെയ്തത്: “നിനക്കു തോട്ടത്തിലെ ഏതു വൃക്ഷത്തിന്റെയും ഫലം ഇഷ്ടംപോലെ ഭക്ഷിക്കാം; ");
INSERT INTO malc_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","എന്നാൽ നന്മതിന്മകളെക്കുറിച്ചുള്ള അറിവുനൽകുന്ന വൃക്ഷത്തിന്റെ ഫലം ഭക്ഷിക്കരുത്, ഭക്ഷിക്കുന്ന നാളിൽ നീ മരിക്കും, നിശ്ചയം!” ");
INSERT INTO malc_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","അതിനുശേഷം യഹോവയായ ദൈവം: “മനുഷ്യൻ ഏകനായിരിക്കുന്നതു നല്ലതല്ല, അവന് അനുയോജ്യമായ ഒരു തുണയെ ഞാൻ നിർമിക്കും,” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","യഹോവയായ ദൈവം നിലത്തുനിന്നു നിർമിച്ച എല്ലാ വന്യമൃഗങ്ങളെയും ആകാശത്തിലെ സകലപക്ഷികളെയും മനുഷ്യന്റെ മുമ്പിൽ അവൻ അവയ്ക്ക് എന്തു പേരിടുമെന്നു കാണാൻ വരുത്തി. ഓരോ ജീവിയെയും മനുഷ്യൻ വിളിച്ചത് അതിന് പേരായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","അങ്ങനെ മനുഷ്യൻ എല്ലാ കന്നുകാലികൾക്കും ആകാശത്തിലെ പക്ഷികൾക്കും സകലവന്യമൃഗങ്ങൾക്കും പേരിട്ടു. എന്നാൽ ആദാമിന് അനുയോജ്യമായ ഒരു പങ്കാളിയെ കണ്ടെത്തിയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","അതുകൊണ്ട് യഹോവയായ ദൈവം മനുഷ്യനെ ഒരു ഗാഢനിദ്രയിലാക്കി; അവൻ ഉറങ്ങിയപ്പോൾ അവിടന്ന് അവന്റെ വാരിയെല്ലുകളിൽ ഒന്നെടുത്തശേഷം എടുത്തയിടം മാംസംകൊണ്ടു നികത്തി. ");
INSERT INTO malc_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","പിന്നെ യഹോവയായ ദൈവം, മനുഷ്യനിൽ നിന്നെടുത്ത വാരിയെല്ലുകൊണ്ട് ഒരു സ്ത്രീയെ ഉണ്ടാക്കി, അവളെ മനുഷ്യന്റെ അടുക്കലേക്ക് ആനയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","അപ്പോൾ മനുഷ്യൻ ഇപ്രകാരം പറഞ്ഞു: “ഇത് എന്റെ അസ്ഥിയിൽനിന്നുള്ള അസ്ഥിയും എന്റെ മാംസത്തിൽനിന്നുള്ള മാംസവും ആകുന്നു; നരനിൽനിന്ന് എടുത്തിരിക്കുകയാൽ ഇവൾക്കു ‘നാരി’ എന്നു പേരാകും.” ");
INSERT INTO malc_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ഈ കാരണത്താൽ ഒരു പുരുഷൻ തന്റെ മാതാപിതാക്കളെ വിട്ടുപിരിഞ്ഞ് തന്റെ ഭാര്യയോടു സംയോജിക്കും; അവർ ഒരു ശരീരമായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","അവരിരുവരും—ആദാമും ഭാര്യയും—നഗ്നരായിരുന്നു; എങ്കിലും അവർക്കു ലജ്ജ തോന്നിയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","യഹോവയായ ദൈവം സൃഷ്ടിച്ച സകലവന്യജീവികളിലുംവെച്ച് പാമ്പ് സൂത്രശാലിയായിരുന്നു. “തോട്ടത്തിലെ ഏതെങ്കിലും വൃക്ഷത്തിന്റെ ഫലം നിങ്ങൾ കഴിക്കരുത് എന്നു ദൈവം വാസ്തവമായി കൽപ്പിച്ചിട്ടുണ്ടോ?” എന്നു പാമ്പു സ്ത്രീയോടു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","“തോട്ടത്തിലെ വൃക്ഷങ്ങളുടെ ഫലം ഞങ്ങൾക്കു ഭക്ഷിക്കാം. ");
INSERT INTO malc_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","എന്നാൽ ‘തോട്ടത്തിന്റെ മധ്യത്തിലുള്ള വൃക്ഷത്തിന്റെ ഫലം നിങ്ങൾ കഴിക്കരുത്, അതു തൊടുകപോലുമരുത്; അങ്ങനെചെയ്താൽ നിങ്ങൾ മരിക്കും’ എന്നു ദൈവം കൽപ്പിച്ചിട്ടുണ്ട്,” സ്ത്രീ ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","“നിങ്ങൾ മരിക്കുകയില്ല, നിശ്ചയം! ");
INSERT INTO malc_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","അതു കഴിക്കുന്ന നാളിൽ നിങ്ങളുടെ കണ്ണുകൾ തുറന്ന് നിങ്ങൾ നന്മതിന്മകൾ അറിയുന്നവരായി, ദൈവത്തെപ്പോലെയാകും, എന്നു ദൈവം അറിയുന്നു,” പാമ്പ് സ്ത്രീയോട് പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ആ വൃക്ഷത്തിന്റെ ഫലം ഭക്ഷിക്കാൻ നല്ലതും കാഴ്ചയ്ക്കു മനോഹരവും ജ്ഞാനംനേടാൻ അഭികാമ്യവുമെന്നു കണ്ട് സ്ത്രീ അതു പറിച്ചു ഭക്ഷിച്ചു, തന്നോടൊപ്പം ഉണ്ടായിരുന്ന ഭർത്താവിനും കൊടുത്തു, അദ്ദേഹവും ഭക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ഉടൻതന്നെ ഇരുവരുടെയും കണ്ണുകൾ തുറന്നു. തങ്ങൾ നഗ്നരെന്ന് അവർ അറിഞ്ഞു; അതുകൊണ്ട് അവർ അത്തിയില കൂട്ടിത്തുന്നി ഉടയാടയുണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ഒരു ദിവസം ഇളങ്കാറ്റു വീശിക്കൊണ്ടിരുന്നപ്പോൾ, യഹോവയായ ദൈവം തോട്ടത്തിൽ നടക്കുന്ന ശബ്ദം ആദാമും അദ്ദേഹത്തിന്റെ ഭാര്യയും കേട്ടു; യഹോവയായ ദൈവം കാണാതിരിക്കാൻ അവർ തോട്ടത്തിലെ മരങ്ങൾക്കിടയിൽ ഒളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","അപ്പോൾ യഹോവയായ ദൈവം മനുഷ്യനെ വിളിച്ചു, “നീ എവിടെ?” ");
INSERT INTO malc_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","അതിന് ആദാം, “തോട്ടത്തിൽ അവിടത്തെ ശബ്ദം ഞാൻ കേട്ടു; ഞാൻ നഗ്നനാകുകയാൽ ഭയപ്പെട്ടു, ഒളിച്ചു” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","അപ്പോൾ ദൈവം, “നീ നഗ്നനെന്നു നിന്നോട് ആർ പറഞ്ഞു? തിന്നരുതെന്നു ഞാൻ നിന്നോടു കൽപ്പിച്ച വൃക്ഷത്തിൽനിന്നു നീ ഭക്ഷിച്ചോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ഉത്തരമായി ആദാം, “എന്നോടുകൂടെ ഇരിക്കേണ്ടതിന് അങ്ങു നൽകിയ സ്ത്രീ വൃക്ഷഫലം തന്നു; ഞാൻ തിന്നുകയും ചെയ്തു” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","അതിനു യഹോവയായ ദൈവം സ്ത്രീയോട്, “നീ ഈ ചെയ്തത് എന്ത്?” എന്നു ചോദിച്ചു. “പാമ്പ് എന്നെ വഞ്ചിച്ചു, ഞാൻ തിന്നുകയും ചെയ്തു,” സ്ത്രീ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","അപ്പോൾ യഹോവയായ ദൈവം പാമ്പിനോട്: “ഇതു ചെയ്തതുകൊണ്ടു, “സകലകന്നുകാലികളെക്കാളും വന്യമൃഗങ്ങളെക്കാളും നീ ശപിക്കപ്പെട്ടിരിക്കുന്നു. നീ ഉരസ്സുകൊണ്ടു ഗമിക്കുകയും നിന്റെ ആയുഷ്കാലമൊക്കെയും പൊടിതിന്നുകയും ചെയ്യും” എന്നും ");
INSERT INTO malc_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","“ഞാൻ നിനക്കും സ്ത്രീക്കും തമ്മിലും നിന്റെ സന്തതിക്കും അവളുടെ സന്തതിക്കും തമ്മിലും ശത്രുത ഉണ്ടാക്കും; അവൻ നിന്റെ തല തകർക്കും; നീ അവന്റെ കുതികാൽ തകർക്കും” എന്നും കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ദൈവം സ്ത്രീയോട് അരുളിച്ചെയ്തത്: “ഞാൻ നിന്റെ ഗർഭകാലം വേദനയുള്ളതാക്കും; അതിവേദനയോടെ നീ മക്കളെ പ്രസവിക്കും. നിന്റെ അഭിലാഷം നിന്റെ ഭർത്താവിനോടാകും, അവൻ നിന്നെ ഭരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","യഹോവ ആദാമിനോട് അരുളിച്ചെയ്തത്: “നീ നിന്റെ ഭാര്യയുടെ വാക്കു കേൾക്കുകയും ‘തിന്നരുത്’ എന്നു ഞാൻ കൽപ്പിച്ച വൃക്ഷത്തിന്റെ ഫലം തിന്നുകയും ചെയ്തതുകൊണ്ട്, “നീ നിമിത്തം ഭൂമി ശപിക്കപ്പെട്ടിരിക്കുന്നു; നിന്റെ ആയുഷ്കാലം മുഴുവൻ കഷ്ടതയോടെ അതിൽനിന്ന് ഉപജീവനംകഴിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ഭൂമി നിനക്കായി മുള്ളും ഞെരിഞ്ഞിലും മുളപ്പിക്കും, നീ വയലിലെ സസ്യങ്ങൾ ഭക്ഷിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","മണ്ണിൽനിന്ന് നിന്നെ എടുത്തു; മണ്ണിലേക്കു മടങ്ങുംവരെ നിന്റെ നെറ്റിയിലെ വിയർപ്പുകൊണ്ട് നീ ആഹാരം കഴിക്കും; നീ പൊടിയാകുന്നു, പൊടിയിലേക്കു നീ തിരികെച്ചേരും.” ");
INSERT INTO malc_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ആദാം തന്റെ ഭാര്യയ്ക്കു ഹവ്വാ എന്നു പേരിട്ടു; കാരണം അവൾ ജീവനുള്ളവർക്കെല്ലാം മാതാവാണല്ലോ. ");
INSERT INTO malc_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","യഹോവയായ ദൈവം ആദാമിനും അവന്റെ ഭാര്യയ്ക്കും തുകൽകൊണ്ടു വസ്ത്രമുണ്ടാക്കി അവരെ ധരിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","അതിനുശേഷം യഹോവയായ ദൈവം അരുളിച്ചെയ്തു: “ഇതാ മനുഷ്യൻ നന്മതിന്മകൾ അറിയുന്നവനായി, നമ്മിൽ ഒരുവനെപ്പോലെ ആയിത്തീർന്നിരിക്കുന്നു. അവൻ കൈനീട്ടി ജീവവൃക്ഷത്തിന്റെ ഫലംകൂടി പറിച്ചുതിന്ന് എന്നേക്കും ജീവിക്കാൻ അനുവദിച്ചുകൂടാ.” ");
INSERT INTO malc_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","മനുഷ്യനെ എടുത്തിരുന്ന മണ്ണിൽ അധ്വാനിക്കേണ്ടതിന് യഹോവയായ ദൈവം അവനെ ഏദെൻതോട്ടത്തിൽനിന്നു പുറത്താക്കി. ");
INSERT INTO malc_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","മനുഷ്യനെ പുറത്താക്കിയശേഷം ദൈവം, ജീവവൃക്ഷത്തിലേക്കുള്ള വഴി കാക്കുന്നതിന് ഏദെൻതോട്ടത്തിനു കിഴക്ക് കെരൂബുകളെ കാവൽ നിർത്തുകയും എല്ലാ വശത്തേക്കും തിരിയുന്നതും തീ ജ്വലിക്കുന്നതുമായ ഒരു വാൾ സ്ഥാപിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ഇതിനുശേഷം ആദാം തന്റെ ഭാര്യയായ ഹവ്വായെ അറിഞ്ഞു. അവൾ ഗർഭംധരിച്ച് കയീന് ജന്മംനൽകി. “യഹോവ സഹായിച്ചതിനാൽ എനിക്കൊരു പുരുഷപ്രജ ലഭിച്ചു,” എന്ന് അവൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ഹവ്വാ വീണ്ടും ഗർഭംധരിച്ച് കയീന്റെ സഹോദരനായ ഹാബേലിനെ പ്രസവിച്ചു. ഹാബേൽ ആട്ടിടയനും കയീൻ നിലത്ത് പണിയെടുക്കുന്നവനും ആയിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","വിളവെടുപ്പിന്റെ സമയമായപ്പോൾ കയീൻ വയലിലെ വിളവിൽനിന്ന് ഒരംശം യഹോവയ്ക്കു യാഗമായി കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ഹാബേലോ, തന്റെ ആട്ടിൻപറ്റത്തിലെ കടിഞ്ഞൂലുകളിൽനിന്ന് മേൽത്തരം ആടുകളെ യാഗത്തിനു കൊണ്ടുവന്നു. യഹോവ ഹാബേലിലും അവന്റെ യാഗത്തിലും സംപ്രീതനായി; ");
INSERT INTO malc_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","എന്നാൽ, കയീനിലും അവന്റെ യാഗാർപ്പണത്തിലും പ്രസാദിച്ചില്ല. കയീൻ ഇതിൽ വളരെ കുപിതനായി; അവന്റെ മുഖം മ്ലാനമായി. ");
INSERT INTO malc_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","യഹോവ കയീനോട്: “നീ കോപിക്കുന്നതെന്തിന്? നിന്റെ മുഖം മ്ലാനമാകുന്നതും എന്തിന്? എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","നന്മയായതു പ്രവർത്തിക്കുന്നെങ്കിൽ നീ അംഗീകരിക്കപ്പെടുകയില്ലയോ? എന്നാൽ നന്മയായതു പ്രവർത്തിക്കാതിരുന്നാൽ പാപം നിന്റെ വാതിൽക്കൽ കിടക്കുന്നു, അതു നിന്നെ അധീനനാക്കാൻ ആഗ്രഹിക്കുന്നു, നീയോ അതിനെ കീഴടക്കണം” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ഒരു ദിവസം കയീൻ തന്റെ സഹോദരനായ ഹാബേലിനോട്, “നമുക്കു വയലിലേക്കു പോകാം” എന്നു പറഞ്ഞു. അവർ വയലിൽ ആയിരുന്നപ്പോൾ കയീൻ സഹോദരനായ ഹാബേലിനെ ആക്രമിച്ചു കൊലപ്പെടുത്തി. ");
INSERT INTO malc_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","അപ്പോൾ യഹോവ കയീനോട്, “നിന്റെ സഹോദരൻ ഹാബേൽ എവിടെ?” എന്നു ചോദിച്ചു. “എനിക്കറിഞ്ഞുകൂടാ, ഞാൻ എന്റെ സഹോദരന്റെ കാവൽക്കാരനോ?” എന്നു പ്രതിവചിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","അപ്പോൾ യഹോവ അരുളിച്ചെയ്തത്: “നീ ഈ ചെയ്തത് എന്ത്? നോക്കൂ! നിന്റെ സഹോദരന്റെ രക്തം ഭൂമിയിൽനിന്ന് എന്നോടു നിലവിളിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ഇപ്പോൾ നീ ശാപഗ്രസ്തനായി; നിന്റെ കൈയിൽനിന്ന് നിന്റെ സഹോദരന്റെ രക്തം ഏറ്റുവാങ്ങാൻ വായ് തുറന്ന ദേശത്തുനിന്നു നീ പുറത്താക്കപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","നീ നിലത്തു കൃഷി ചെയ്താൽ ഇനിയൊരിക്കലും അതു നിനക്കു പുഷ്ടിയോടെ വിളവുനൽകുകയില്ല. നീ ഭൂമുഖത്തു ലക്ഷ്യമില്ലാതെ അലഞ്ഞുതിരിയുന്ന അഭയാർഥിയുമായിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","അതിന് കയീൻ യഹോവയോട്: “എന്റെ ശിക്ഷ എനിക്കു വഹിക്കാവുന്നതിലും അധികമാണ്! ");
INSERT INTO malc_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ഇന്ന് ഈ ദേശത്തുനിന്ന് അങ്ങ് എന്നെ ആട്ടിപ്പായിക്കുന്നു; അങ്ങയുടെ സന്നിധിയിൽനിന്ന് ഇനി ഞാൻ ഒളിച്ചുകഴിയേണ്ടതായി വരും; ഞാൻ ഭൂമുഖത്ത് അലഞ്ഞുതിരിയുന്ന അഭയാർഥിയാകും. എന്നെ ആരെങ്കിലും കണ്ടെത്തിയാൽ അവൻ എന്നെ കൊന്നുകളയും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","യഹോവ അതിനു മറുപടിയായി: “അങ്ങനെയല്ല, ആരെങ്കിലും കയീനെ വധിച്ചാൽ അവനോടുള്ള പ്രതികാരം ഏഴുമടങ്ങായിരിക്കും” എന്ന് അരുളിച്ചെയ്തു. കയീനെ കണ്ടെത്തുന്ന ആരും അവനെ വധിക്കാതിരിക്കേണ്ടതിന് യഹോവ അവന്റെമേൽ ഒരടയാളം വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","കയീൻ യഹോവയുടെ സന്നിധിയിൽനിന്നു പുറപ്പെട്ടുപോയി ഏദെനു കിഴക്കുള്ള നോദ് ദേശത്തു ചെന്നു താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","കയീൻ തന്റെ ഭാര്യയെ അറിഞ്ഞു. അവൾ ഗർഭിണിയായി, ഹാനോക്കിനെ പ്രസവിച്ചു. അക്കാലത്ത് കയീൻ ഒരു പട്ടണം പണിതു. അതിന് അയാൾ തന്റെ മകനായ ഹാനോക്കിന്റെ പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ഹാനോക്കിന് ഈരാദ് ജനിച്ചു. ഈരാദിൽനിന്ന് മെഹൂയയേൽ ജനിച്ചു; മെഹൂയയേലിൽനിന്ന് മെഥൂശയേൽ ജനിച്ചു; മെഥൂശയേലിൽനിന്ന് ലാമെക്ക് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ലാമെക്ക് രണ്ടുസ്ത്രീകളെ വിവാഹംചെയ്തു; ഒരുവൾക്ക് ആദാ എന്നും മറ്റവൾക്കു സില്ല എന്നും പേരായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ആദാ യാബാലിനെ പ്രസവിച്ചു; അയാൾ കൂടാരങ്ങളിൽ പാർക്കുന്നവർക്കും കന്നുകാലികളെ പരിപാലിക്കുന്നവർക്കും പിതാവായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","അദ്ദേഹത്തിന്റെ സഹോദരന്റെ പേര് യൂബാൽ എന്നായിരുന്നു. യൂബാൽ കിന്നരം വായിക്കുകയും ഓടക്കുഴൽ ഊതുകയും ചെയ്യുന്ന എല്ലാവർക്കും പിതാവായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","സില്ലയ്ക്ക് തൂബാൽ-കയീൻ എന്നൊരു മകൻ ഉണ്ടായിരുന്നു; അയാൾ വെങ്കലവും ഇരുമ്പുംകൊണ്ടുള്ള എല്ലാത്തരം ഉപകരണങ്ങളും വാർത്തുണ്ടാക്കിയിരുന്നു. തൂബാൽ-കയീന് നയമാ എന്നു പേരുള്ള ഒരു സഹോദരിയുണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ലാമെക്ക് തന്റെ ഭാര്യമാരോടു പറഞ്ഞു: “ആദയേ, സില്ലയേ, എന്റെ വാക്കു ശ്രദ്ധിക്കുക; ലാമെക്കിന്റെ ഭാര്യമാരേ, എന്റെ വാക്കു കേൾക്കുക. എന്നെ മുറിവേൽപ്പിച്ചതിനു ഞാൻ ഒരു മനുഷ്യനെ കൊന്നിരിക്കുന്നു, എന്നെ മുറിപ്പെടുത്തിയതിന് ഒരു യുവാവിനെത്തന്നെ. ");
INSERT INTO malc_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","കയീനുവേണ്ടി ഏഴുമടങ്ങു പ്രതികാരം നടത്തുമെങ്കിൽ, ലാമെക്കിനുവേണ്ടി എഴുപത്തിയേഴു മടങ്ങായിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ആദാം വീണ്ടും തന്റെ ഭാര്യയെ അറിഞ്ഞു. അവൾ ഒരു മകനെ പ്രസവിച്ചു; അവന് ശേത്ത് എന്നു പേരിട്ടു. “കയീൻ ഹാബേലിനെ വധിച്ചതുകൊണ്ട് അവനു പകരമായി ദൈവം എനിക്കു മറ്റൊരു ശിശുവിനെ തന്നിരിക്കുന്നു” എന്ന് അവൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ശേത്തിനും ഒരു മകൻ ജനിച്ചു. അവന് ഏനോശ് എന്നു പേരിട്ടു. അക്കാലത്ത് മനുഷ്യർ യഹോവയുടെനാമത്തിലുള്ള ആരാധന തുടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ആദാമിന്റെ വംശപാരമ്പര്യരേഖ ഇപ്രകാരമാണ്: ദൈവം മനുഷ്യനെ സൃഷ്ടിച്ചപ്പോൾ, തന്റെ സാദൃശ്യത്തിലാണ് അവിടന്ന് മനുഷ്യരെ മെനഞ്ഞത്; ");
INSERT INTO malc_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ദൈവം പുരുഷനും സ്ത്രീയുമായി അവരെ സൃഷ്ടിച്ചു; അവരെ സൃഷ്ടിച്ച ദിവസം അവിടന്ന് അവരെ അനുഗ്രഹിച്ച് അവർക്ക് “ആദാം,” എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ആദാമിനു 130 വയസ്സായപ്പോൾ തന്റെ സാദൃശ്യത്തിലും സ്വരൂപത്തിലും ഒരു മകൻ ജനിച്ചു; അവന് അദ്ദേഹം ശേത്ത് എന്ന് പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ശേത്ത് ജനിച്ചതിനുശേഷം ആദാം 800 വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് വേറെ പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ആദാമിന്റെ ആയുസ്സ് ആകെ 930 വർഷമായിരുന്നു; പിന്നെ അദ്ദേഹം മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ശേത്തിനു 105 വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് ഏനോശ് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ഏനോശിന് ജന്മംനൽകിയതിനുശേഷം ശേത്ത് 807 വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് വേറെ പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ശേത്തിന്റെ ആയുസ്സ് ആകെ 912 വർഷമായിരുന്നു. പിന്നെ അദ്ദേഹം മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ഏനോശിനു തൊണ്ണൂറു വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് കേനാൻ ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","കേനാന് ജന്മംനൽകിയതിനുശേഷം ഏനോശ് 815 വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് വേറെ പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ഏനോശിന്റെ ആയുസ്സ് 905 വർഷമായിരുന്നു; പിന്നെ അദ്ദേഹം മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","കേനാന് എഴുപതു വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് മഹലലേൽ ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","മഹലലേലിന് ജന്മംനൽകിയതിനുശേഷം കേനാൻ 840 വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് വേറെ പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","കേനാന്റെ ആയുസ്സ് 910 വർഷമായിരുന്നു; പിന്നെ അദ്ദേഹം മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","മഹലലേലിന് അറുപത്തഞ്ച് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് യാരെദ് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","യാരെദിന് ജന്മംനൽകിയതിനുശേഷം മഹലലേൽ 830 വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് വേറെ പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","മഹലലേലിന്റെ ആയുസ്സ് 895 വർഷമായിരുന്നു; പിന്നെ അദ്ദേഹം മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","യാരെദിനു 162 വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് ഹാനോക്ക് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ഹാനോക്കിന് ജന്മംനൽകിയതിനുശേഷം യാരെദ് 800 വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് വേറെ പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","യാരെദിന്റെ ആയുസ്സ് ആകെ 962 വർഷമായിരുന്നു; പിന്നെ അദ്ദേഹം മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ഹാനോക്കിന് അറുപത്തഞ്ച് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് മെഥൂശെലാഹ് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","മെഥൂശെലാഹിന് ജന്മംനൽകിയതിനുശേഷം ഹാനോക്ക് 300 വർഷം ദൈവമുമ്പാകെ വിശ്വസ്തനായി ജീവിച്ചു. ഈ സമയം അദ്ദേഹത്തിൽനിന്ന് വേറെ പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ഹാനോക്കിന്റെ ആയുസ്സ് 365 വർഷമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ഹാനോക്ക് ദൈവമുമ്പാകെ വിശ്വസ്തനായി ജീവിച്ചു; ഒരു ദിവസം ദൈവം അദ്ദേഹത്തെ തന്റെ അടുത്തേക്കെടുത്തതിനാൽ കാണാതെയായി. ");
INSERT INTO malc_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","മെഥൂശെലാഹിനു 187 വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് ലാമെക്ക് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ലാമെക്കിന് ജന്മംനൽകിയതിനുശേഷം മെഥൂശെലാഹ് 782 വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് വേറെ പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","മെഥൂശെലാഹിന്റെ ആയുസ്സ് ആകെ 969 വർഷമായിരുന്നു, പിന്നെ അദ്ദേഹം മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ലാമെക്കിനു 182 വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് ഒരു മകൻ ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","“യഹോവ ശപിച്ച ഭൂമിയിൽ നമുക്കു നേരിട്ട കഠിനപ്രയത്നത്തിലും നമ്മുടെ കൈകളുടെ ക്ലേശകരമായ അധ്വാനത്തിലും ഇവൻ നമ്മെ ആശ്വസിപ്പിക്കും” എന്നു പറഞ്ഞ് ലാമെക്ക് തന്റെ മകനു നോഹ എന്ന് പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","നോഹയ്ക്ക് ജന്മംനൽകിയതിനുശേഷം ലാമെക്ക് 595 വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് വേറെ പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ലാമെക്കിന്റെ ആയുസ്സ് 777 വർഷമായിരുന്നു; പിന്നെ അദ്ദേഹം മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","നോഹയ്ക്കു 500 വയസ്സായതിനുശേഷം, ശേം, ഹാം, യാഫെത്ത് എന്നീ പുത്രന്മാർ അദ്ദേഹത്തിന് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","മനുഷ്യർ ഭൂമിയിൽ പെരുകിത്തുടങ്ങി. അവർക്കു പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ദൈവത്തിന്റെ പുത്രന്മാർ മനുഷ്യരുടെ പുത്രിമാരെ സൗന്ദര്യവതികൾ എന്നുകണ്ട് തങ്ങൾക്ക് ഇഷ്ടമുള്ളവരെ വിവാഹംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","അപ്പോൾ യഹോവ, “എന്റെ ആത്മാവ് മനുഷ്യനോട് എന്നേക്കും വാദിച്ചുകൊണ്ടിരിക്കുകയില്ല; മനുഷ്യൻ നശ്വരൻ തന്നെയല്ലോ; അവന്റെ ആയുസ്സ് 120 വർഷമാകും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ഈ കാലഘട്ടത്തിലും ഇതിനുശേഷവും ഭൂമിയിൽ മല്ലന്മാർ ഉണ്ടായിരുന്നു. ദൈവത്തിന്റെ പുത്രന്മാർ മനുഷ്യരുടെ പുത്രിമാരെ അറിഞ്ഞു; അവർക്ക് മക്കൾ ജനിച്ചു. ഇവരായിരുന്നു പൗരാണികകാലത്തെ പ്രഖ്യാത പുരുഷന്മാർ എന്നറിയപ്പെട്ട വീരന്മാർ. ");
INSERT INTO malc_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ഭൂമിയിൽ മനുഷ്യന്റെ ദുഷ്ടത വളരെയധികം വർധിച്ചിരിക്കുന്നെന്നും അവന്റെ ഹൃദയവിചാരങ്ങൾ എപ്പോഴും തിന്മനിറഞ്ഞതെന്നും യഹോവ കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ഭൂമിയിൽ മനുഷ്യനെ സൃഷ്ടിച്ചതുകൊണ്ട് യഹോവ ദുഃഖിച്ചു; അവിടത്തെ ഹൃദയം അത്യന്തം വേദനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","“ഞാൻ സൃഷ്ടിച്ച മനുഷ്യവംശത്തെ—മനുഷ്യരെയും മൃഗങ്ങളെയും നിലത്ത് ഇഴയുന്ന ജന്തുക്കളെയും ആകാശത്തിലെ പക്ഷികളെയും—ഭൂമുഖത്തുനിന്നു തുടച്ചുനീക്കും; അവയെ ഉണ്ടാക്കിയതിൽ ഞാൻ ദുഃഖിക്കുന്നു” എന്ന് യഹോവ അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","എന്നാൽ നോഹയ്ക്കു യഹോവയുടെ കൃപ ലഭിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","നോഹയെക്കുറിച്ചുള്ള വിവരണം ഇപ്രകാരമായിരുന്നു: നോഹ തന്റെ സമകാലീനരായ ആളുകൾക്കിടയിൽ നീതിമാനും നിഷ്കളങ്കനുമായിരുന്നു; അദ്ദേഹം ദൈവമുമ്പാകെ വിശ്വസ്തനായി ജീവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","നോഹയ്ക്ക് ശേം, ഹാം, യാഫെത്ത് എന്നീ മൂന്നുപുത്രന്മാർ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","എന്നാൽ, ഭൂമി ദൈവത്തിന്റെ ദൃഷ്ടിയിൽ അഴിമതിയുള്ളതും അക്രമം നിറഞ്ഞതുമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ഭൂമിയിൽ അഴിമതി എത്രമാത്രം പെരുകിയിരിക്കുന്നെന്നും ഭൂമിയിലെ സകലമനുഷ്യരും അധാർമികത തങ്ങളുടെ ജീവിതശൈലിയാക്കി മാറ്റിയിരിക്കുന്നെന്നും ദൈവം കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","അതുകൊണ്ട് ദൈവം നോഹയോട് അരുളിച്ചെയ്തു, “ഞാൻ സകലമനുഷ്യരെയും നശിപ്പിക്കാൻ തീരുമാനിച്ചിരിക്കുന്നു; അവർനിമിത്തം ഭൂമിയിൽ അക്രമം നിറഞ്ഞിരിക്കുന്നു! ഞാൻ അവരെയും ഭൂമിയെയും നശിപ്പിക്കും! നിശ്ചയം. ");
INSERT INTO malc_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ആകയാൽ നിനക്കുവേണ്ടി ഗോഫർമരംകൊണ്ട് ഒരു പെട്ടകം ഉണ്ടാക്കണം; അതിൽ അറകൾ നിർമിച്ച് വെള്ളം കയറാത്തവിധം അതിന്റെ അകത്തും പുറത്തും കീൽ തേക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","നീ പെട്ടകം നിർമിക്കേണ്ടത് ഇനി പറയുന്ന കണക്കുകൾപ്രകാരം ആയിരിക്കണം, അതിന് നീളം മുന്നൂറ് മുഴവും വീതി അൻപതു മുഴവും ഉയരം മുപ്പത് മുഴവും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","പെട്ടകത്തിന് ഒരു മേൽക്കൂര ഉണ്ടാക്കണം, മേൽക്കൂരയ്ക്കുതാഴേ ഒരുമുഴം അകലത്തിൽ പെട്ടകത്തിനുചുറ്റും കിളിവാതിൽ ഉണ്ടാക്കണം. പെട്ടകത്തിന്റെ വശത്ത് ഒരു വാതിൽ വെക്കണം, ഒരു കീഴ്ത്തട്ടും ഇടത്തട്ടും മേൽത്തട്ടും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ആകാശത്തിനുകീഴേ ജീവനുള്ള സകലതിനെയും, ജീവശ്വാസമുള്ള ജന്തുക്കളെ എല്ലാറ്റിനെയും, നശിപ്പിക്കാൻ ഞാൻ ഭൂമിയിൽ ഒരു പ്രളയം വരുത്തും. ");
INSERT INTO malc_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","എന്നാൽ, എന്റെ ഉടമ്പടി ഞാൻ നിന്നോട് ഉറപ്പിക്കും; നീ പെട്ടകത്തിൽ പ്രവേശിക്കണം; നിന്നോടൊപ്പം നിന്റെ പുത്രന്മാരും നിന്റെ ഭാര്യയും നിന്റെ പുത്രന്മാരുടെ ഭാര്യമാരും ഉണ്ടാകണം. ");
INSERT INTO malc_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","സകലജീവികളിൽനിന്നും ആണും പെണ്ണുമായി ഈരണ്ടിനെ—അവയും നിന്നോടൊപ്പം ജീവനോടിരിക്കേണ്ടതിന്—നീ പെട്ടകത്തിനുള്ളിലേക്കു കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","എല്ലാത്തരം പക്ഷികളിലും എല്ലാത്തരം മൃഗങ്ങളിലും നിലത്തുകൂടി ഇഴയുന്ന എല്ലാത്തരം ജന്തുക്കളിലുംനിന്നും ഈരണ്ടെണ്ണം—ജീവനോടെ സൂക്ഷിക്കപ്പെടേണ്ടതിനു—നിന്റെ അടുക്കൽ വരേണ്ടതാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","നിനക്കും അവയ്ക്കും വേണ്ടുന്ന സകലവിധ ഭക്ഷണസാധനങ്ങളും നീ ശേഖരിച്ചുവെക്കണം. അത് നിനക്കും അവയ്ക്കും ഭക്ഷണമായിരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ദൈവം കൽപ്പിച്ചതുപോലെതന്നെ നോഹ ചെയ്തു—അതേ, അദ്ദേഹം ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","സകലതും ക്രമീകരിക്കപ്പെട്ടതിനുശേഷം, യഹോവ നോഹയോട് അരുളിച്ചെയ്തത്: “ഞാൻ നിന്നെ ഈ തലമുറയിൽ നീതിമാനായി കണ്ടിരിക്കുന്നു; അതുകൊണ്ടു നീയും നിന്റെ കുടുംബം മുഴുവനും പെട്ടകത്തിനുള്ളിലേക്കു പ്രവേശിക്കുക. ");
INSERT INTO malc_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ശുദ്ധിയുള്ള മൃഗങ്ങളിൽനിന്ന് ആണും പെണ്ണുമായി ഏഴുജോടിയെയും ശുദ്ധിയില്ലാത്ത മൃഗങ്ങളിൽനിന്ന് ആണും പെണ്ണുമായി ഓരോ ജോടിയെയും ");
INSERT INTO malc_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","പക്ഷികളുടെ ഓരോ ജാതിയിൽനിന്നും പൂവനും പിടയുമായി ഏഴുജോടിയെയും, പ്രളയശേഷം ഭൂമിയിൽ ഈവക ജീവനോടെ ശേഷിക്കേണ്ടതിനു നീ ചേർത്തുകൊള്ളണം; ");
INSERT INTO malc_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ഏഴുദിവസം കഴിഞ്ഞ്, ഞാൻ ഭൂമിയിൽ നാൽപ്പതുപകലും നാൽപ്പതുരാവും മഴപെയ്യിക്കുകയും ഞാൻ നിർമിച്ച സകലജീവികളെയും ഭൂമുഖത്തുനിന്നു തുടച്ചുനീക്കുകയും ചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","യഹോവ തന്നോടു കൽപ്പിച്ചതുപോലെതന്നെയെല്ലാം നോഹ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ഭൂമിയിൽ പ്രളയം ഉണ്ടായപ്പോൾ നോഹയ്ക്ക് 600 വയസ്സായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","നോഹയും തന്റെ ഭാര്യയും നോഹയുടെ പുത്രന്മാരും അവരുടെ ഭാര്യമാരും പ്രളയത്തിൽനിന്നു രക്ഷപ്പെടുന്നതിനായി പെട്ടകത്തിൽ പ്രവേശിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ശുദ്ധിയുള്ളവയും അല്ലാത്തവയുമായ മൃഗങ്ങളിൽനിന്ന്, പക്ഷികളും എല്ലാ ഇഴജന്തുക്കളും, ");
INSERT INTO malc_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ആണും പെണ്ണുമായി ദൈവം കൽപ്പിച്ചതുപോലെ നോഹയുടെ അടുക്കൽവന്ന് പെട്ടകത്തിനുള്ളിൽ കടന്നു. ");
INSERT INTO malc_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ഏഴുദിവസം കഴിഞ്ഞപ്പോൾ ഭൂമിയിൽ പ്രളയം ആരംഭിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","നോഹയുടെ ആയുസ്സിന്റെ അറുനൂറാംവർഷം, രണ്ടാംമാസം, പതിനേഴാംതീയതിതന്നെ ആഴിയുടെ ഉറവുകൾ തുറക്കപ്പെട്ടു, ആകാശത്തിന്റെ കിളിവാതിലുകളും തുറക്കപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","നാൽപ്പതുപകലും നാൽപ്പതുരാവും ഭൂമിയിൽ മഴ പെയ്തുകൊണ്ടേയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ഭൂമിയിൽ മഴ പെയ്യാൻ തുടങ്ങിയ ആ ദിവസംതന്നെ നോഹ തന്റെ പുത്രന്മാരായ ശേം, ഹാം, യാഫെത്ത് എന്നിവരോടും ഭാര്യയോടും പുത്രന്മാരുടെ ഭാര്യമാരോടുംകൂടെ പെട്ടകത്തിൽ പ്രവേശിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","അവരോടൊപ്പം എല്ലാത്തരം വന്യമൃഗങ്ങളും കന്നുകാലികളും ഇഴജന്തുക്കളും പക്ഷികളും ചിറകുള്ള സകലതും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ജീവശ്വാസമുള്ള സമസ്തജന്തുക്കളുടെയും ഇണകൾ നോഹയുടെ അടുക്കൽവന്നു പെട്ടകത്തിൽ കയറി. ");
INSERT INTO malc_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ദൈവം നോഹയോടു കൽപ്പിച്ചതനുസരിച്ച്, ആണും പെണ്ണുമായിട്ടാണ് സകലജീവികളും പെട്ടകത്തിൽവന്നു കയറിയത്. അതിനുശേഷം യഹോവ അവരെ ഉള്ളിലാക്കി വാതിൽ അടച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","നാൽപ്പതു ദിവസത്തേക്കു ഭൂമിയിൽ പ്രളയം തുടർന്നു; വെള്ളം പെരുകിയപ്പോൾ പെട്ടകം ഭൂമിയിൽനിന്ന് ഉയർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","വെള്ളം ഭൂമിയിൽ അത്യധികം പെരുകി, പെട്ടകം വെള്ളത്തിനുമീതേ ഒഴുകിനീങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ആകാശത്തിനു കീഴിലുള്ള ഉയർന്ന പർവതങ്ങളെയൊക്കെയും മൂടുംവിധം ഭൂമിയിൽ വെള്ളം പൊങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","പർവതങ്ങൾക്കുമേൽ പതിനഞ്ചുമുഴത്തിലധികം ജലനിരപ്പുയർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","പക്ഷികൾ, കന്നുകാലികൾ, വന്യജീവികൾ, ഇഴജന്തുക്കൾ, മനുഷ്യവർഗം മുഴുവനും, ഇങ്ങനെ സകലഭൂചരജീവികളും നശിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","മൂക്കിൽ ജീവശ്വാസമുള്ളവയായി, കരയിൽ അവശേഷിച്ചിരുന്നവയെല്ലാം ചത്തൊടുങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ഭൂമുഖത്തു ജീവനോടെ ഉണ്ടായിരുന്നവയെല്ലാം നിർമാർജനം ചെയ്യപ്പെട്ടു; മനുഷ്യരെയും മൃഗങ്ങളെയും നിലത്തിഴയുന്ന ജീവികളെയും ആകാശത്തിലെ പക്ഷികളെയും—ഇങ്ങനെ സകലതിനെയും പ്രളയം തുടച്ചുനീക്കി. നോഹയും അദ്ദേഹത്തോടുകൂടെ പെട്ടകത്തിലുണ്ടായിരുന്നവരുംമാത്രം അവശേഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","പ്രളയം ഭൂമിയിൽ നൂറ്റി അൻപതു ദിവസത്തേക്കു തുടർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ദൈവം നോഹയെയും അദ്ദേഹത്തോടുകൂടെ പെട്ടകത്തിൽ ഉണ്ടായിരുന്ന സകലവന്യജീവികളെയും കന്നുകാലികളെയും ഓർത്തു; അവിടന്നു ഭൂമിയുടെമേൽ ഒരു കാറ്റ് അടിപ്പിച്ചു; വെള്ളം പിൻവാങ്ങാൻ തുടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ആഴിയുടെ ഉറവുകളും ആകാശത്തിന്റെ കിളിവാതിലുകളും അടഞ്ഞു; ആകാശത്തിൽനിന്നുള്ള ജലപാതവും നിലച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","വെള്ളം ഭൂമിയിൽനിന്ന് ക്രമേണ ഇറങ്ങിത്തുടങ്ങി. നൂറ്റി അൻപതു ദിവസം കഴിഞ്ഞപ്പോൾ വെള്ളം വലിഞ്ഞ്, ");
INSERT INTO malc_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ഏഴാംമാസം പതിനേഴാംതീയതി, പെട്ടകം അരാരാത്ത് പർവതത്തിൽ ഉറച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","പത്താംമാസംവരെ വെള്ളം കുറഞ്ഞുകൊണ്ടേയിരുന്നു; പത്താംമാസം ഒന്നാംതീയതി പർവതശിഖരങ്ങൾ ദൃശ്യമായി. ");
INSERT INTO malc_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","നാൽപ്പതുദിവസംകൂടി കഴിഞ്ഞപ്പോൾ, നോഹ, പെട്ടകത്തിൽ താൻ ഉണ്ടാക്കിയിരുന്ന ജനാല തുറന്ന് ");
INSERT INTO malc_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ഒരു കാക്കയെ പുറത്തേക്കയച്ചു; ഭൂമിയിൽ വെള്ളം വറ്റുന്നതുവരെയും അതു വരികയും പോകുകയും ചെയ്തുകൊണ്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ഭൂമിയുടെ പ്രതലത്തിൽനിന്ന് വെള്ളം വലിഞ്ഞിട്ടുണ്ടോ എന്നറിയാൻ ഒരു പ്രാവിനെയും അദ്ദേഹം പുറത്തേക്കയച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","എന്നാൽ ഭൂമിയിൽ എങ്ങും വെള്ളമായിരുന്നതുകൊണ്ട് കാലുകുത്താൻ ഇടം കാണാതെ അതു പെട്ടകത്തിൽ നോഹയുടെ അടുക്കൽ മടങ്ങിയെത്തി. അദ്ദേഹം കൈനീട്ടി അതിനെ പിടിച്ച് പെട്ടകത്തിനുള്ളിൽ തന്റെ അടുക്കൽ ആക്കി. ");
INSERT INTO malc_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ഏഴുദിവസംകൂടി കാത്തിരുന്നതിനുശേഷം നോഹ പ്രാവിനെ വീണ്ടും പെട്ടകത്തിൽനിന്ന് പുറത്തേക്ക് അയച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","പ്രാവു വൈകുന്നേരം തിരിച്ചെത്തിയപ്പോൾ, അതിന്റെ ചുണ്ടിൽ അതാ ഒരു പച്ച ഒലിവില! വെള്ളം ഭൂമിയിൽനിന്ന് വലിഞ്ഞിരിക്കുന്നു എന്ന് അപ്പോൾ നോഹയ്ക്ക് മനസ്സിലായി. ");
INSERT INTO malc_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","അദ്ദേഹം ഏഴുദിവസംകൂടി കാത്തിരുന്നു; പ്രാവിനെ വീണ്ടും പുറത്തേക്ക് അയച്ചു. എന്നാൽ ഇത്തവണ അത് അദ്ദേഹത്തിന്റെ അടുക്കൽ മടങ്ങിവന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","നോഹയുടെ അറുനൂറ്റിയൊന്നാംവർഷം ഒന്നാംമാസം ഒന്നാംദിവസം ആയപ്പോൾ വെള്ളം ഭൂമിയുടെ പ്രതലത്തിൽനിന്ന് വറ്റിപ്പോയിരുന്നു. അതിനുശേഷം നോഹ പെട്ടകത്തിന്റെ മൂടി നീക്കി. നിലം ഉണങ്ങിയിരിക്കുന്നതായി കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","രണ്ടാംമാസം ഇരുപത്തിയേഴാംതീയതി ഭൂമി പൂർണമായും ഉണങ്ങിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ഇതിനുശേഷം ദൈവം നോഹയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“നീയും നിന്റെ ഭാര്യയും നിന്റെ പുത്രന്മാരും അവരുടെ ഭാര്യമാരും പെട്ടകത്തിൽനിന്ന് പുറത്തുവരിക. ");
INSERT INTO malc_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","നിന്നോടൊപ്പമുള്ള എല്ലാവിധ ജീവികളെയും—പക്ഷികളെയും മൃഗങ്ങളെയും നിലത്തിഴയുന്ന എല്ലാ ഇഴജന്തുക്കളെയും—പുറത്തുകൊണ്ടുവരിക; അവ ഭൂമിയിൽ പെറ്റുപെരുകി, എണ്ണത്തിൽ വർധിക്കട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","അങ്ങനെ നോഹ തന്റെ പുത്രന്മാരോടും ഭാര്യയോടും പുത്രന്മാരുടെ ഭാര്യമാരോടുംകൂടെ പുറത്തുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","എല്ലാ മൃഗങ്ങളും എല്ലാ ഇഴജന്തുക്കളും എല്ലാ പക്ഷികളും—ഭൂചരജീവികളൊക്കെയും—ജോടിജോടിയായി പെട്ടകത്തിൽനിന്നു പുറത്തേക്കുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","പിന്നീട് നോഹ യഹോവയ്ക്ക് ഒരു യാഗപീഠം പണിതു; അദ്ദേഹം അതിന്മേൽ ശുദ്ധിയുള്ള എല്ലാ മൃഗങ്ങളിലും ശുദ്ധിയുള്ള എല്ലാ പക്ഷികളിലും ചിലതിനെ ഹോമയാഗങ്ങളായി അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","അതിന്റെ ഹൃദ്യമായ സൗരഭ്യം ആസ്വദിച്ചുകൊണ്ട് യഹോവ ഹൃദയത്തിൽ അരുളിച്ചെയ്തു: “മനുഷ്യന്റെ ഹൃദയനിരൂപണങ്ങളെല്ലാം ബാല്യംമുതൽ ദോഷപൂർണമെങ്കിലും ഞാൻ ഇനിയൊരിക്കലും മനുഷ്യവംശം നിമിത്തം ഭൂമിയെ ശപിക്കുകയില്ല. ഇപ്പോൾ ചെയ്തതുപോലെ ഞാൻ ഇനിയൊരിക്കലും സകലജീവികളെയും നശിപ്പിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“ഭൂമിയുള്ള കാലംവരെ വിതയും കൊയ്ത്തും ശീതവും ഉഷ്ണവും വേനലും വർഷവും പകലും രാത്രിയും ഒരിക്കലും നിലയ്ക്കുകയില്ല.” ");
INSERT INTO malc_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ദൈവം നോഹയെയും അദ്ദേഹത്തിന്റെ പുത്രന്മാരെയും അനുഗ്രഹിച്ച്, അവരോട് അരുളിച്ചെയ്തു: “നിങ്ങൾ സന്താനസമൃദ്ധിയുള്ളവരായി എണ്ണത്തിൽ വർധിച്ച് ഭൂമിയിൽ നിറയുക. ");
INSERT INTO malc_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ഭൂമിയിലെ സകലമൃഗങ്ങൾക്കും ആകാശത്തിലെ സകലപക്ഷികൾക്കും സകലഭൂചരജന്തുക്കൾക്കും സമുദ്രത്തിലെ സകലമത്സ്യങ്ങൾക്കും നിങ്ങളെക്കുറിച്ചുള്ള പേടിയും നടുക്കവും ഉണ്ടാകും. ഞാൻ അവയെ നിങ്ങളുടെ കൈയിൽ ഏൽപ്പിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ജീവനോടെ ചരിക്കുന്ന സകലതും നിങ്ങൾക്ക് ആഹാരമായിരിക്കും. ഞാൻ നിങ്ങൾക്കു പച്ചസസ്യങ്ങൾ നൽകിയതുപോലെ ഇപ്പോൾ സകലതും നിങ്ങൾക്കു തരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“എന്നാൽ, ജീവരക്തത്തോടുകൂടി ഒന്നിന്റെയും മാംസം നിങ്ങൾ ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","നിങ്ങളുടെ ജീവരക്തത്തിനു ഞാൻ കണക്കുചോദിക്കും; ഓരോ മൃഗത്തോടും ഞാൻ കണക്ക് ആവശ്യപ്പെടും; ഓരോ മനുഷ്യനോടും അവന്റെ സുഹൃത്തിന്റെ ജീവരക്തത്തിനു കണക്കുചോദിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“മനുഷ്യന്റെ രക്തം ആരെങ്കിലും ചൊരിഞ്ഞാൽ അവന്റെ രക്തം മനുഷ്യൻ ചൊരിയിക്കും. ദൈവം തന്റെ സ്വരൂപത്തിലാണല്ലോ മനുഷ്യനെ നിർമിച്ചത്. ");
INSERT INTO malc_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","നിങ്ങളോ, സന്താനസമൃദ്ധിയുള്ളവരായി എണ്ണത്തിൽ പെരുകുക; ഭൂമിയിൽ നിറഞ്ഞു വർധിച്ചുവരിക.” ");
INSERT INTO malc_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ഇതിനുശേഷം ദൈവം നോഹയോടും പുത്രന്മാരോടും അരുളിച്ചെയ്തത്: ");
INSERT INTO malc_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ഇപ്പോൾ നിങ്ങളോടും നിങ്ങൾക്കുശേഷം നിങ്ങളുടെ സന്തതിപരമ്പരയോടും ");
INSERT INTO malc_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","നിങ്ങളോടുകൂടെ ഉണ്ടായിരുന്ന സകലജീവജന്തുക്കളോടും—പക്ഷികൾ, കന്നുകാലികൾ, വന്യമൃഗങ്ങൾ, എന്നിങ്ങനെ നിങ്ങളോടുകൂടെ പെട്ടകത്തിൽനിന്നു പുറത്തു വന്ന ഭൂമിയിലെ സകലജീവികളോടും—ഞാൻ ഉടമ്പടിചെയ്യുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ഇനി ഒരിക്കലും പ്രളയജലത്താൽ എല്ലാ ജീവജാലങ്ങളും നശിക്കുകയില്ല, ഭൂമിയെ നശിപ്പിക്കാൻ ഇനിയൊരിക്കലും പ്രളയം ഉണ്ടാകുകയില്ല എന്നു ഞാൻ നിങ്ങളോട് ഉടമ്പടിചെയ്യുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ദൈവം പിന്നെയും അരുളിച്ചെയ്തു: “എനിക്കും നിങ്ങൾക്കും നിങ്ങളോടുകൂടെ സകലജീവികൾക്കും മധ്യേ, വരുംതലമുറകൾക്കെല്ലാറ്റിനുംവേണ്ടി ഞാൻ ചെയ്യുന്ന ഉടമ്പടിയുടെ ചിഹ്നമാണിത്, ");
INSERT INTO malc_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ഞാൻ മേഘങ്ങളിൽ എന്റെ വില്ല് സ്ഥാപിക്കുന്നു, അത് എനിക്കും ഭൂമിക്കുംതമ്മിലുള്ള ഉടമ്പടിയുടെ ചിഹ്നമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ഞാൻ ഭൂമിക്കുമീതേ മേഘങ്ങളെ വരുത്തുകയും മേഘങ്ങളിൽ മഴവില്ലു പ്രത്യക്ഷപ്പെടുകയും ചെയ്യുമ്പോൾ ");
INSERT INTO malc_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","നിങ്ങളോടും സകലവിധ ജീവികളോടുമുള്ള എന്റെ ഉടമ്പടി ഞാൻ ഓർക്കും. സമസ്തജീവജാലങ്ങളെയും നശിപ്പിക്കുന്ന പ്രളയം ഇനിയൊരിക്കലും ഉണ്ടാകുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","മേഘങ്ങളിൽ വില്ല് പ്രത്യക്ഷപ്പെടുമ്പോഴെല്ലാം ഞാൻ അതു കാണുകയും ദൈവവും ഭൂമിയിലെ സകലജീവികളുമായുള്ള ശാശ്വതമായ ഉടമ്പടി ഓർക്കുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","“എനിക്കും ഭൂമിയിലെ സകലജീവജാലങ്ങൾക്കും മധ്യേ ഞാൻ ചെയ്യുന്ന ഉടമ്പടിയുടെ ചിഹ്നം ഇതായിരിക്കും,” എന്നും ദൈവം നോഹയോട് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","പെട്ടകത്തിൽനിന്നു പുറത്തു വന്നവരായ നോഹയുടെ പുത്രന്മാർ ശേം, ഹാം, യാഫെത്ത് എന്നിവരായിരുന്നു; ഹാം കനാന്റെ പിതാവായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","നോഹയ്ക്ക് ഈ മൂന്ന് പുത്രന്മാരാണ് ഉണ്ടായിരുന്നത്; ഇവരിൽനിന്നാണ് ഭൂമി ജനങ്ങളെക്കൊണ്ടു നിറഞ്ഞത്. ");
INSERT INTO malc_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","കർഷകനായ നോഹ ഒരു മുന്തിരിത്തോപ്പു നട്ടുപിടിപ്പിക്കാൻ തുടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","നോഹ അതിൽനിന്നുള്ള വീഞ്ഞുകുടിച്ച് ലഹരിക്കടിമപ്പെട്ടു തന്റെ കൂടാരത്തിനുള്ളിൽ, വിവസ്ത്രനായിക്കിടന്നു. ");
INSERT INTO malc_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","കനാന്റെ പിതാവായ ഹാം പിതാവിന്റെ നഗ്നത കണ്ടിട്ട് പുറത്തുചെന്ന് രണ്ടു സഹോദരന്മാരെയും അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ശേമും യാഫെത്തും ഒരു വസ്ത്രം എടുത്ത് തങ്ങളുടെ തോളിൽ ഇട്ടുകൊണ്ട് പിറകോട്ടു നടന്നുചെന്ന് പിതാവിന്റെ നഗ്നത മറച്ചു. അവർ മുഖം തിരിച്ചു പിടിച്ചിരുന്നതിനാൽ പിതാവിന്റെ നഗ്നത കണ്ടില്ല. ");
INSERT INTO malc_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","നോഹ ലഹരി വിട്ട് ഉണർന്നപ്പോൾ തന്റെ ഇളയമകനായ ഹാം തന്നോടു ചെയ്തത് അറിഞ്ഞ്, ");
INSERT INTO malc_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","അദ്ദേഹം, “കനാൻ ശപിക്കപ്പെട്ടവൻ, അവൻ തന്റെ സഹോദരന്മാർക്ക് അധമദാസനായിത്തീരും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","“ശേമിന്റെ ദൈവമായ യഹോവ വാഴ്ത്തപ്പെട്ടവൻ. കനാൻ അവന്റെ അടിമയായിത്തീരട്ടെ, ");
INSERT INTO malc_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ദൈവം യാഫെത്തിന്റെ ദേശം വിശാലമാക്കട്ടെ, യാഫെത്ത് ശേമിന്റെ കൂടാരങ്ങളിൽ പാർക്കട്ടെ, കനാൻ അവന്റെ അടിമയായിത്തീരട്ടെ,” എന്നും പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","പ്രളയത്തിനുശേഷം നോഹ 350 വർഷം ജീവിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","നോഹയുടെ ആയുസ്സ് ആകെ 950 വർഷമായിരുന്നു; പിന്നെ അദ്ദേഹം മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","നോഹയുടെ പുത്രന്മാരായ ശേം, ഹാം, യാഫെത്ത് എന്നിവരുടെ വംശാവലി സംബന്ധിച്ച വിവരം: പ്രളയത്തിനുശേഷം അവർക്കു പുത്രന്മാരുണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","യാഫെത്തിന്റെ പുത്രന്മാർ: ഗോമെർ, മാഗോഗ്, മാദായി, യാവാൻ, തൂബാൽ, മേശെക്ക്, തീരാസ്. ");
INSERT INTO malc_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ഗോമെരിന്റെ പുത്രന്മാർ: അശ്കേനസ്, രീഫത്ത്, തോഗർമാ. ");
INSERT INTO malc_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","യാവാന്റെ പുത്രന്മാർ: എലീശാ, തർശീശ്, കിത്ത്യർ, ദോദാന്യർ. ");
INSERT INTO malc_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ഇവരിൽനിന്ന് കടലോരത്തും ദ്വീപുകളിലുമുള്ള ജനങ്ങൾ ഉത്ഭവിച്ചു. അവർ അതതുദേശങ്ങളിൽ അവരവരുടെ ഭാഷ സംസാരിച്ച് വിവിധഗോത്രങ്ങളും ജനതകളുമായി താമസിച്ചുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ഹാമിന്റെ പുത്രന്മാർ: കൂശ്, ഈജിപ്റ്റ്, പൂത്ത്, കനാൻ. ");
INSERT INTO malc_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","കൂശിന്റെ പുത്രന്മാർ: സേബ, ഹവീലാ, സബ്താ, രാമാ, സബ്തെക്കാ. രാമായുടെ പുത്രന്മാർ: ശേബാ, ദേദാൻ. ");
INSERT INTO malc_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","കൂശ് നിമ്രോദിന്റെ പിതാവായിരുന്നു. നിമ്രോദ് ഭൂമിയിൽ ആദ്യത്തെ മല്ലനായ പോരാളിയായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","അദ്ദേഹം യഹോവയുടെമുമ്പാകെ ശക്തനായൊരു നായാട്ടുവീരനായിരുന്നു. അതുകൊണ്ടാണ്, “യഹോവയുടെ സന്നിധിയിൽ, നിമ്രോദിനെപ്പോലെ നായാട്ടുവീരൻ” എന്നു ചൊല്ലുണ്ടായത്. ");
INSERT INTO malc_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","അയാളുടെ രാജ്യത്തിന്റെ പ്രഥമകേന്ദ്രങ്ങൾ ശിനാർ ദേശത്തു ബാബേൽ, ഏരെക്, അക്കാദ്, കൽനെ എന്നിവയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","അയാൾ അവിടെനിന്ന് അശ്ശൂരിലേക്കു തന്റെ രാജ്യം വിസ്തൃതമാക്കി, അവിടെ നിനവേ, രെഹോബോത്ത് പട്ടണം, കാലഹ്, ");
INSERT INTO malc_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","നിനവേക്കും കാലഹിനും മധ്യേയുള്ള മഹാനഗരമായ രേസെൻ എന്നീ പട്ടണങ്ങളും പണിതു. ");
INSERT INTO malc_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ലൂദീം, അനാമീം, ലെഹാബീം, നഫ്തൂഹീം, ");
INSERT INTO malc_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","പത്രൂസീം, കസ്ളൂഹീം (ഇവരിൽനിന്നാണ് ഫെലിസ്ത്യർ ഉത്ഭവിച്ചത്), കഫ്തോരീം എന്നീ വംശങ്ങളുടെ ഉത്ഭവം ഈജിപ്റ്റിൽനിന്നായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","കനാന്റെ പുത്രന്മാർ: ആദ്യജാതനായ സീദോൻ, ഹിത്യർ, ");
INSERT INTO malc_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","യെബൂസ്യർ, അമോര്യർ, ഗിർഗ്ഗശ്യർ, ");
INSERT INTO malc_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ഹിവ്യർ, അർഖ്യർ, സീന്യർ, ");
INSERT INTO malc_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","അർവാദ്യർ, സെമാര്യർ, ഹമാത്യർ. പിൽക്കാലത്ത് കനാന്യവംശങ്ങൾ ചിതറിപ്പോകുകയും ");
INSERT INTO malc_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","കനാന്റെ അതിരുകൾ സീദോൻമുതൽ ഗെരാർവഴിയായി ഗസ്സാവരെയും സൊദോം, ഗൊമോറാ, ആദ്മാ, സെബോയീം എന്നിവ വഴിയായി ലാശാവരെയുമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ഇവരാണ് തങ്ങളുടെ പ്രദേശങ്ങളിലും രാജ്യങ്ങളിലും കുലങ്ങളും ഭാഷകളും അനുസരിച്ചു ചിതറിത്താമസിച്ചിരുന്ന ഹാമിൻപുത്രന്മാർ. ");
INSERT INTO malc_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","യാഫെത്തിന്റെ മൂത്തസഹോദരനായ ശേമിനും പുത്രന്മാർ ജനിച്ചു; ഏബെരിന്റെ പുത്രന്മാർക്കെല്ലാവർക്കും പൂർവപിതാവ് ശേം ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ശേമിന്റെ പുത്രന്മാർ: ഏലാം, അശ്ശൂർ, അർപ്പക്ഷാദ്, ലൂദ്, അരാം. ");
INSERT INTO malc_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","അരാമിന്റെ പുത്രന്മാർ: ഊസ്, ഹൂൾ, ഗേഥെർ, മേശെക്ക്. ");
INSERT INTO malc_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","അർപ്പക്ഷാദ് ശേലഹിന്റെ പിതാവും ശേലഹ് ഏബെരിന്റെ പിതാവുമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ഏബെരിനു രണ്ടു പുത്രന്മാർ ജനിച്ചു: ഒരുവന്റെ പേര് പേലെഗ് എന്നായിരുന്നു; കാരണം, അവന്റെ കാലത്തായിരുന്നു ഭൂവാസികൾ വിഭജിക്കപ്പെട്ടത്. അവന്റെ സഹോദരന്റെ പേര് യോക്താൻ എന്നായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","യോക്താന്റെ പുത്രന്മാർ: അല്മോദാദ്, ശാലെഫ്, ഹസർമാവെത്ത്, യാരഹ്, ");
INSERT INTO malc_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ഹദോരാം, ഊസാൽ, ദിക്ലാ, ");
INSERT INTO malc_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ഓബാൽ, അബീമായേൽ, ശേബാ, ");
INSERT INTO malc_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ഓഫീർ, ഹവീലാ, യോബാബ് ഇവരെല്ലാവരും യോക്താന്റെ പുത്രന്മാർ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","അവർ അധിവസിച്ചിരുന്ന പ്രദേശം മേശാമുതൽ കിഴക്കൻ മലമ്പ്രദേശമായ സേഫാർവരെ വ്യാപിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","കുലങ്ങളും ഭാഷകളും അനുസരിച്ച് തങ്ങളുടെ പ്രദേശങ്ങളിലും രാജ്യങ്ങളിലും താമസിച്ചിരുന്ന ശേമ്യപുത്രന്മാർ ഇവരായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ദേശവും കുലവും അനുസരിച്ച് നോഹയുടെ പുത്രന്മാരുടെ വംശാവലി ഇവയാണ്. ഇവരിൽനിന്നാണ് പ്രളയത്തിനുശേഷം ഭൂമിയിൽ ജനതകൾ വ്യാപിച്ചത്. ");
INSERT INTO malc_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ലോകംമുഴുവനും ഒരേ ഭാഷയും ഒരേ സംസാരരീതിയും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","മനുഷ്യർ പൂർവദിക്കിലേക്കു നീങ്ങിയപ്പോൾ ശിനാർ ദേശത്ത് ഒരു സമതലഭൂമി കണ്ടെത്തുകയും അവിടെ സ്ഥിരവാസം ആരംഭിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","“വരൂ, നമുക്ക് ഇഷ്ടികയുണ്ടാക്കി ശരിക്കും ചുട്ടെടുക്കാം,” അവർ പരസ്പരം പറഞ്ഞു. അവർ കല്ലിനുപകരം ഇഷ്ടികയും കുമ്മായത്തിനു പകരം പശമണ്ണും ഉപയോഗിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","പിന്നെ അവർ, “വരിക, നാം ഭൂതലത്തിലെല്ലാം ചിതറിപ്പോകാതിരിക്കാൻ നമുക്ക് ഒരു പട്ടണവും നാം പ്രസിദ്ധരായിത്തീരേണ്ടതിന് ആകാശംവരെ എത്തുന്ന ഒരു ഗോപുരവും നിർമിക്കാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","എന്നാൽ, മനുഷ്യർ പണിതുകൊണ്ടിരുന്ന പട്ടണവും ഗോപുരവും കാണാൻ യഹോവ ഇറങ്ങിവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","അപ്പോൾ യഹോവ: “ഒരേ ഭാഷ സംസാരിക്കുന്ന ഒരേ ജനതയായ ഇവർ ഇങ്ങനെ പ്രവർത്തിച്ചുതുടങ്ങിയെങ്കിൽ അവർ ആസൂത്രണം ചെയ്യുന്ന ഒരു കാര്യവും അവർക്ക് അസാധ്യമാകുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","വരിക, നമുക്ക് ഇറങ്ങിച്ചെന്ന്, അവർ ആശയവിനിമയം ചെയ്യുന്നത് പരസ്പരം മനസ്സിലാക്കാതിരിക്കേണ്ടതിന് അവരുടെ ഭാഷ കലക്കിക്കളയാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","അങ്ങനെ യഹോവ അവരെ അവിടെനിന്ന് ഭൂമിയിൽ എല്ലായിടത്തുമായി ചിതറിച്ചു; അവർ പട്ടണനിർമാണം ഉപേക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","യഹോവ ഭൂമിയിലുള്ള സകലമനുഷ്യരുടെയും ഭാഷ അവിടെവെച്ചു കലക്കിക്കളഞ്ഞതുകൊണ്ട് ആ പട്ടണത്തിന് ബാബേൽ എന്നു പേരായി. അവിടെനിന്നു യഹോവ അവരെ ഭൂതലത്തിൽ എല്ലായിടത്തുമായി ചിതറിച്ചുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ശേമിന്റെ വംശപാരമ്പര്യം ഇപ്രകാരമാണ്: പ്രളയം കഴിഞ്ഞു രണ്ടു വർഷമായപ്പോൾ, അതായതു ശേമിനു നൂറ് വയസ്സായപ്പോൾ, അദ്ദേഹത്തിന് അർപ്പക്ഷാദ് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","അർപ്പക്ഷാദിന് ജന്മംനൽകിയതിനുശേഷം ശേം അഞ്ഞൂറ് വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","അർപ്പക്ഷാദിനു മുപ്പത്തിയഞ്ച് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് ശേലഹ് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ശേലഹിന് ജന്മംനൽകിയതിനുശേഷം അർപ്പക്ഷാദ് നാനൂറ്റിമൂന്ന് വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ശേലഹിനു മുപ്പത് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് ഏബെർ ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ഏബെരിന് ജന്മംനൽകിയതിനുശേഷം ശേലഹ് നാനൂറ്റിമൂന്ന് വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ഏബെരിനു മുപ്പത്തിനാല് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് പേലെഗ് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","പേലെഗിന് ജന്മംനൽകിയതിനുശേഷം ഏബെർ നാനൂറ്റിമുപ്പത് വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","പേലെഗിനു മുപ്പത് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് രെയൂ ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","രെയൂവിന് ജന്മംനൽകിയതിനുശേഷം പേലെഗ് ഇരുനൂറ്റി ഒൻപത് വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","രെയൂവിനു മുപ്പത്തിരണ്ട് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് ശെരൂഗ് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ശെരൂഗിന് ജന്മംനൽകിയതിനുശേഷം രെയൂ ഇരുനൂറ്റിയേഴ് വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ശെരൂഗിനു മുപ്പത് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് നാഹോർ ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","നാഹോരിന് ജന്മംനൽകിയതിനുശേഷം ശെരൂഗ് ഇരുനൂറ് വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","നാഹോരിന് ഇരുപത്തിയൊൻപത് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് തേരഹ് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","തേരഹിന് ജന്മംനൽകിയതിനുശേഷം നാഹോർ നൂറ്റി പത്തൊൻപത് വർഷം ജീവിച്ചിരുന്നു; അദ്ദേഹത്തിൽനിന്ന് പുത്രന്മാരും പുത്രിമാരും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","തേരഹിനു എഴുപത് വയസ്സായപ്പോൾ അദ്ദേഹത്തിന് അബ്രാമും നാഹോരും ഹാരാനും ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","തേരഹിന്റെ വംശപാരമ്പര്യം ഇപ്രകാരമാണ്: തേരഹിൽനിന്നാണ് അബ്രാമും നാഹോരും ഹാരാനും ജനിച്ചത്. ഹാരാനിൽനിന്ന് ലോത്ത് ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ഹാരാൻ തന്റെ ജന്മദേശമായ കൽദയരുടെ പട്ടണമായ ഊരിൽവെച്ച് തന്റെ പിതാവായ തേരഹ് ജീവിച്ചിരിക്കുമ്പോൾത്തന്നെ മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","അബ്രാമും നാഹോരും വിവാഹിതരായി. അബ്രാമിന്റെ ഭാര്യയുടെ പേര് സാറായി എന്നും നാഹോരിന്റെ ഭാര്യയുടെ പേര് മിൽക്കാ എന്നും ആയിരുന്നു. (സാറായി ഹാരാന്റെ മകളായിരുന്നു; അവളുടെ സഹോദരിമാരായിരുന്നു മിൽക്കയും യിസ്കയും.) ");
INSERT INTO malc_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","സാറായി വന്ധ്യയായിരുന്നു; അവൾക്കു കുട്ടികൾ ഇല്ലായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","തേരഹ് തന്റെ പുത്രനായ അബ്രാമിനെയും ഹാരാന്റെ പുത്രനും തന്റെ പൗത്രനുമായ ലോത്തിനെയും അബ്രാമിന്റെ ഭാര്യയും തന്റെ മരുമകളുമായ സാറായിയെയുംകൂട്ടിക്കൊണ്ട് കനാൻദേശത്തേക്കു പോകുന്നതിനു കൽദയരുടെ പട്ടണമായ ഊരിൽനിന്ന് യാത്രപുറപ്പെട്ടു; എന്നാൽ അവർ ഹാരാനിൽ എത്തി അവിടെ താമസമാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","തേരഹിന്റെ ആയുസ്സ് ഇരുനൂറ്റിയഞ്ച് വർഷം ആയിരുന്നു. തേരഹ് ഹാരാനിൽവെച്ചു മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","യഹോവ അബ്രാമിനോട് അരുളിച്ചെയ്തത്: “നിന്റെ ദേശത്തെയും നിന്റെ ബന്ധുക്കളെയും നിന്റെ പിതൃഭവനക്കാരെയും വിട്ട്, ഞാൻ നിനക്ക് അവകാശമായി തരാനിരിക്കുന്ന ദേശത്തേക്കു പോകുക. ");
INSERT INTO malc_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“ഞാൻ നിന്നെ വലിയൊരു ജനതയാക്കും; ഞാൻ നിന്നെ അനുഗ്രഹിക്കും; നിന്റെ നാമം ഞാൻ ശ്രേഷ്ഠമാക്കും. നീ ഒരു അനുഗ്രഹമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","നിന്നെ അനുഗ്രഹിക്കുന്നവരെ ഞാൻ അനുഗ്രഹിക്കും; നിന്നെ ശപിക്കുന്നവരെ ഞാൻ ശപിക്കും; ഭൂമിയിലെ സകലവംശങ്ങളും നിന്നിലൂടെ അനുഗ്രഹിക്കപ്പെടും.” ");
INSERT INTO malc_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","അങ്ങനെ യഹോവ തന്നോടു കൽപ്പിച്ചതനുസരിച്ച് അബ്രാം പുറപ്പെട്ടു; ലോത്തും അദ്ദേഹത്തോടുകൂടെ പോയി. ഹാരാനിൽനിന്നു പുറപ്പെടുമ്പോൾ അബ്രാമിന് എഴുപത്തഞ്ച് വയസ്സായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","അദ്ദേഹം തന്റെ ഭാര്യയായ സാറായിയെയും സഹോദരന്റെ പുത്രനായ ലോത്തിനെയും തങ്ങൾ ഹാരാനിൽവെച്ചു നേടിയ സകലസ്വത്തും ഹാരാനിൽവെച്ച് തങ്ങൾ സമ്പാദിച്ച സേവകരെയും കൂട്ടി കനാൻദേശത്തേക്കു യാത്രതിരിച്ചു; അവർ കനാൻദേശത്ത് എത്തിച്ചേരുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","അബ്രാം ആ ദേശത്തുകൂടി ശേഖേമിലെ മോരേയിലുള്ള മഹാവൃക്ഷംവരെയും യാത്രചെയ്തു. അക്കാലത്ത് കനാന്യരായിരുന്നു ആ ദേശത്തുണ്ടായിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","യഹോവ അബ്രാമിനു പ്രത്യക്ഷനായി, “ഞാൻ ഈ ദേശം നിന്റെ സന്തതിക്കു നൽകും” എന്ന് അരുളിച്ചെയ്തു. അതിനുശേഷം അദ്ദേഹം തനിക്കു പ്രത്യക്ഷനായ യഹോവയ്ക്ക് അവിടെ ഒരു യാഗപീഠം പണിതു. ");
INSERT INTO malc_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","അവിടെനിന്ന് അബ്രാം ബേഥേലിനു കിഴക്കുള്ള മലമ്പ്രദേശത്തേക്കു പോയി. അവിടെ തന്റെ കൂടാരം അടിച്ചു; ആ സ്ഥലത്തിന്റെ പടിഞ്ഞാറുവശത്തു ബേഥേലും കിഴക്കുവശത്തു ഹായിയും ആയിരുന്നു. അവിടെ അദ്ദേഹം യഹോവയ്ക്ക് ഒരു യാഗപീഠം പണിത് യഹോവയെ ആരാധിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","അബ്രാം പിന്നെയും ദക്ഷിണദിക്ക് ലക്ഷ്യമാക്കി തന്റെ പ്രയാണം തുടർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ആ സമയത്ത് കനാൻദേശത്ത് ക്ഷാമം ഉണ്ടായി; ക്ഷാമം രൂക്ഷമായിരുന്നതുകൊണ്ട് കുറച്ചുകാലം താമസിക്കുന്നതിനായി അബ്രാം ഈജിപ്റ്റിലേക്കു പോയി. ");
INSERT INTO malc_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ഈജിപ്റ്റിൽ പ്രവേശിക്കാറായപ്പോൾ അദ്ദേഹം ഭാര്യയായ സാറായിയോടു പറഞ്ഞു: “നീ എത്ര സുന്ദരിയെന്നു ഞാൻ അറിയുന്നു, ");
INSERT INTO malc_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ഈജിപ്റ്റുകാർ നിന്നെ കാണുമ്പോൾ, ‘ഇവൾ അവന്റെ ഭാര്യയാകുന്നു’ എന്നു പറഞ്ഞ് എന്നെ കൊല്ലുകയും നിന്നെ സ്വന്തമാക്കുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","അതുകൊണ്ട് നീ എന്റെ സഹോദരി എന്നു പറയണം, അപ്പോൾ നീ നിമിത്തം അവർ എന്നോടു നന്നായി പെരുമാറുകയും എന്റെ ജീവൻ നഷ്ടപ്പെടാതിരിക്കുകയും ചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","അബ്രാം ഈജിപ്റ്റിൽ എത്തി, സാറായി അതിസുന്ദരി എന്ന് ഈജിപ്റ്റുകാർ കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ഫറവോന്റെ ഉദ്യോഗസ്ഥന്മാർ അവളെ കണ്ടിട്ട് ഫറവോനോട് അവളെപ്പറ്റി പ്രശംസിച്ചു സംസാരിക്കുകയും അവളെ രാജകൊട്ടാരത്തിലേക്കു കൂട്ടിക്കൊണ്ടുപോകുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","അവൾനിമിത്തം ഫറവോൻ അബ്രാമിനോടു ദയാപൂർവം പെരുമാറി. അങ്ങനെ അബ്രാമിന് ആടുമാടുകൾ, ആൺകഴുതകൾ, പെൺകഴുതകൾ, ദാസീദാസന്മാർ, ഒട്ടകങ്ങൾ എന്നിവയെല്ലാം ഫറവോൻ നൽകി. ");
INSERT INTO malc_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","എന്നാൽ, യഹോവ അബ്രാമിന്റെ ഭാര്യയായ സാറായിനിമിത്തം ഫറവോനെയും അദ്ദേഹത്തിന്റെ ഭവനക്കാരെയും മഹാരോഗങ്ങളാൽ പീഡിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","അപ്പോൾ ഫറവോൻ അബ്രാമിനെ ആളയച്ചുവരുത്തി, “നീ എന്നോട് ഈ ചെയ്തതെന്ത്? ഇവൾ നിന്റെ ഭാര്യയാണെന്ന് എന്തുകൊണ്ട് എന്നോടു പറയാതിരുന്നു? ");
INSERT INTO malc_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‘ഇവൾ എന്റെ സഹോദരിയാണ്’ എന്നു നീ പറഞ്ഞതെന്തിന്? ഞാൻ അവളെ ഭാര്യയായി സ്വീകരിക്കാൻ സംഗതിയായല്ലോ? ഇപ്പോൾ ഇതാ നിന്റെ ഭാര്യ, ഇവളെ കൂട്ടിക്കൊണ്ടു പൊയ്ക്കൊള്ളൂ!” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","പിന്നെ ഫറവോൻ തന്റെ ആളുകൾക്ക് അബ്രാമിനെ സംബന്ധിച്ച് ആജ്ഞ നൽകുകയും അവർ അദ്ദേഹത്തെ ഭാര്യയോടും അദ്ദേഹത്തിന്റെ സകലസമ്പത്തോടുംകൂടെ യാത്രയാക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","അബ്രാം ഭാര്യയോടുകൂടെ, തനിക്കുള്ള സകലവുമായി ഈജിപ്റ്റിൽനിന്ന് ദക്ഷിണദിക്കിലേക്ക് യാത്രചെയ്തു. ലോത്തും അദ്ദേഹത്തെ അനുഗമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","കന്നുകാലികൾ, വെള്ളി, സ്വർണം എന്നിവയിൽ അബ്രാം മഹാസമ്പന്നനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","അദ്ദേഹം തെക്കേദേശത്തുനിന്നു പല സ്ഥലങ്ങളിലൂടെ യാത്രചെയ്ത് ബേഥേൽവരെയും ബേഥേലിനും ഹായിക്കും മധ്യേ താൻ മുമ്പ് കൂടാരം അടിച്ചിരുന്നതും ");
INSERT INTO malc_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ആദ്യം യാഗപീഠം പണിതിരുന്നതുമായ സ്ഥലംവരെയും ചെന്നു. അവിടെ അബ്രാം യഹോവയെ ആരാധിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","അബ്രാമിനോടുകൂടെ യാത്രചെയ്തിരുന്ന ലോത്തിനും ആടുമാടുകളും കൂടാരങ്ങളും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","അവർ ഒരുമിച്ചു താമസിച്ചാൽ ദേശത്തിന് അവരെ പോറ്റാൻ സാധിക്കുകയില്ല എന്ന നിലയിലായി; ഒരുമിച്ചു ജീവിക്കാൻ കഴിയാത്തവിധം അത്രയധികമായിരുന്നു അവരുടെ സമ്പത്ത്. ");
INSERT INTO malc_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","അബ്രാമിന്റെ കന്നുകാലികളുടെ ഇടയന്മാരും ലോത്തിന്റെ കന്നുകാലികളുടെ ഇടയന്മാരുംതമ്മിൽ കലഹമുണ്ടായി. അക്കാലത്ത് കനാന്യരും പെരിസ്യരും ആ ദേശത്തു താമസിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","അതുകൊണ്ട് അബ്രാം ലോത്തിനോട്: “നിനക്കും എനിക്കുംതമ്മിലോ നിന്റെയും എന്റെയും ഇടയന്മാർതമ്മിലോ ഒരു വഴക്കും ഉണ്ടാകരുത്; നാം അടുത്ത ബന്ധുക്കളല്ലേ! ");
INSERT INTO malc_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ദേശംമുഴുവനും നിന്റെ മുമ്പിൽ ഇല്ലയോ? നമുക്കു വേർപിരിയാം. നീ ഇടത്തോട്ടു പോകുന്നെങ്കിൽ ഞാൻ വലത്തോട്ടു പൊയ്ക്കൊള്ളാം; അതല്ല, നീ വലത്തോട്ടെങ്കിൽ ഞാൻ ഇടത്തോട്ടു പൊയ്ക്കൊള്ളാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ലോത്ത് ചുറ്റും നോക്കി; സോവാറിനുനേരേയുള്ള യോർദാൻ സമഭൂമി മുഴുവൻ ജലസമൃദ്ധിയുള്ളതെന്നു കണ്ടു. ആ പ്രദേശം യഹോവയുടെ തോട്ടംപോലെയും ഈജിപ്റ്റുദേശംപോലെയും ആയിരുന്നു. (ഇത് യഹോവ സൊദോമിനെയും ഗൊമോറായെയും നശിപ്പിക്കുന്നതിനുമുമ്പായിരുന്നു.) ");
INSERT INTO malc_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ലോത്ത് യോർദാൻ സമഭൂമി മുഴുവൻ തനിക്കായി തെരഞ്ഞെടുത്തു; പിന്നെ അദ്ദേഹം കിഴക്കോട്ടു യാത്രതിരിച്ചു; അങ്ങനെ അവരിരുവരുംതമ്മിൽ പിരിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","അബ്രാം കനാൻദേശത്തു താമസിച്ചു; ലോത്ത് സമതലനഗരങ്ങളുടെ ഇടയിൽ താമസിച്ചു; സൊദോമിനു സമീപംവരെ കൂടാരം മാറ്റി അടിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","എന്നാൽ, സൊദോമിലെ ആളുകൾ ദുഷ്ടന്മാരും യഹോവയുടെമുമ്പാകെ മഹാപാപികളും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ലോത്ത് അബ്രാമിനെ വിട്ടുപോയശേഷം യഹോവ അബ്രാമിനോട്: “നീ ഇരിക്കുന്ന സ്ഥലത്തുനിന്നു കണ്ണുകളുയർത്തി വടക്കോട്ടും തെക്കോട്ടും കിഴക്കോട്ടും പടിഞ്ഞാറോട്ടും നോക്കുക. ");
INSERT INTO malc_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","നീ കാണുന്ന ഭൂമിയെല്ലാം ഞാൻ നിനക്കും നിന്റെ സന്തതിക്കും എന്നെന്നേക്കുമായി തരും. ");
INSERT INTO malc_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ഞാൻ നിന്റെ സന്തതിയെ നിലത്തെ പൊടിപോലെയാക്കും; മൺതരികളെ എണ്ണാൻ കഴിയുമെങ്കിൽ നിന്റെ സന്തതിയെയും എണ്ണാൻ കഴിയും. ");
INSERT INTO malc_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","നീ ചെന്ന് ദേശത്തിന്റെ എല്ലാദിക്കുകളിലൂടെയും സഞ്ചരിക്കുക, അതു ഞാൻ നിനക്കു തരും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","അപ്പോൾ അബ്രാം തന്റെ കൂടാരം നീക്കി ഹെബ്രോനിൽ മമ്രേയിലെ മഹാവൃക്ഷങ്ങൾക്കരികെ ചെന്നു താമസിച്ചു; അവിടെ അദ്ദേഹം യഹോവയ്ക്ക് ഒരു യാഗപീഠം പണിതു. ");
INSERT INTO malc_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ഈ കാലഘട്ടത്തിൽ ശിനാർരാജാവായ അമ്രാഫെൽ, എലാസാർ രാജാവായ അര്യോക്ക്, ഏലാംരാജാവായ കെദൊർലായോമർ, ഗോയീംരാജാവായ തീദാൽ എന്നിവർ, ");
INSERT INTO malc_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","സൊദോംരാജാവായ ബേരാ, ഗൊമോറാരാജാവായ ബിർശാ, ആദ്മാരാജാവായ ശിനാബ്, സെബോയീം രാജാവായ ശെമേബെർ, ബേലയിലെ, അതായത്, സോവാറിലെ, രാജാവ് എന്നിവരോടു യുദ്ധംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ഒടുവിൽ പറഞ്ഞ രാജാക്കന്മാരെല്ലാവരും ഇപ്പോൾ ഉപ്പുകടൽ എന്നറിയപ്പെടുന്ന സിദ്ദീംതാഴ്വരയിൽ ഒരുമിച്ചുകൂടി. ");
INSERT INTO malc_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","കാരണം അവർ പന്ത്രണ്ടുവർഷം ഏലാംരാജാവായ കെദൊർലായോമരിന്റെ അധീനതയിലായിരുന്നു; എന്നാൽ, പതിമ്മൂന്നാംവർഷം അവർ മത്സരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","പതിന്നാലാംവർഷം കെദൊർലായോമരും അദ്ദേഹത്തോടു സഖ്യമുള്ള രാജാക്കന്മാരും ഒത്തുചേർന്ന് അസ്തെരോത്ത് കർന്നയീമിലെ രെഫായീകളെയും ഹാമിലെ സൂസ്യരെയും ശാവേഹ്-കിര്യാത്തയീമിലെ ഏമ്യരെയും ");
INSERT INTO malc_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","മലമ്പ്രദേശമായ സേയീരിലെ ഹോര്യരെയും മരുഭൂമിക്കു സമീപമുള്ള ഏൽ-പാരാൻവരെ തോൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","പിന്നെ അവർ പിന്തിരിഞ്ഞ് ഏൻ-മിശ്പാത്തിൽ, അതായത്, കാദേശിൽ, എത്തി അമാലേക്യരുടെ എല്ലാ അധീനപ്രദേശവും ഹസെസോൻ-താമാരിൽ താമസിച്ചിരുന്ന അമോര്യരെയും പിടിച്ചടക്കി. ");
INSERT INTO malc_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","അപ്പോൾ സൊദോംരാജാവും ഗൊമോറാരാജാവും ആദ്മാരാജാവും സെബോയീംരാജാവും ബേല, അതായത്, സോവാറിലെ രാജാവും യുദ്ധത്തിനു പുറപ്പെട്ട് സിദ്ദീംതാഴ്വരയിൽ അണിനിരന്നു. ");
INSERT INTO malc_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ഏലാംരാജാവായ കെദൊർലായോമർ, ഗോയീംരാജാവായ തീദാൽ, ശിനാർരാജാവായ അമ്രാഫെൽ, എലാസാർ രാജാവായ അര്യോക്ക് എന്നിവർക്കെതിരേ യുദ്ധത്തിനു തയ്യാറായി; നാലു രാജാക്കന്മാർ അഞ്ചു രാജാക്കന്മാർക്കെതിരേ. ");
INSERT INTO malc_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","സിദ്ദീംതാഴ്വരയിൽ എല്ലായിടത്തും പശ നിറഞ്ഞ കുഴികൾ ഉണ്ടായിരുന്നു. സൊദോംരാജാവും ഗൊമോറാരാജാവും ഓടിപ്പോയപ്പോൾ അവരുടെ ആളുകളിൽ കുറെപ്പേർ അവയിൽ വീണു; ശേഷിച്ചവർ മലകളിലേക്ക് ഓടിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ആ നാലു രാജാക്കന്മാർ സൊദോമിലും ഗൊമോറായിലും ഉണ്ടായിരുന്നവരുടെ സമ്പത്തും എല്ലാ ഭക്ഷണസാധനങ്ങളും പിടിച്ചെടുത്തുകൊണ്ട് അവിടം വിട്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","അവർ, സൊദോമിൽ താമസിച്ചിരുന്ന, അബ്രാമിന്റെ സഹോദരപുത്രനായ ലോത്തിനെ അദ്ദേഹത്തിന്റെ സകലസമ്പത്തോടുംകൂടി പിടിച്ചുകൊണ്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","രക്ഷപ്പെട്ടവരിൽ ഒരുത്തൻ ചെന്ന് എബ്രായനായ അബ്രാമിനെ ഇക്കാര്യം അറിയിച്ചു. അപ്പോൾ അബ്രാം താമസിച്ചിരുന്നത് എസ്കോലിന്റെയും ആനേരിന്റെയും സഹോദരനും അമോര്യനുമായ മമ്രേയുടെ മഹാവൃക്ഷങ്ങൾക്കു സമീപം ആയിരുന്നു; അവരെല്ലാവരും അബ്രാമിനോടു സഖ്യം സ്ഥാപിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","തന്റെ സഹോദരപുത്രനെ ബന്ദിയാക്കിക്കൊണ്ടുപോയിരിക്കുന്നു എന്നു കേട്ടപ്പോൾ അബ്രാം തന്റെ വീട്ടിൽ ജനിച്ചു വളർന്ന അഭ്യാസികളായ മുന്നൂറ്റി പതിനെട്ട് പേരെ കൂട്ടിക്കൊണ്ട് ദാൻവരെ പിൻതുടർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","രാത്രിയിൽ അബ്രാം തന്റെ ആളുകളെ പല സംഘങ്ങളാക്കി; ദമസ്കോസിന്റെ വടക്ക്, ഹോബാവരെ അവരെ പിൻതുടർന്ന് നിശ്ശേഷം തോൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","അപഹരിക്കപ്പെട്ട സകലസമ്പത്തും അദ്ദേഹം തിരികെ പിടിക്കുകയും തന്റെ സഹോദരപുത്രനായ ലോത്തിനെയും അദ്ദേഹത്തിന്റെ സമ്പാദ്യവും സ്ത്രീകളെയും മറ്റ് ആളുകളെയും മടക്കിക്കൊണ്ടുവരികയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","കെദൊർലായോമരിനെയും അദ്ദേഹത്തോടു സഖ്യം പുലർത്തിയിരുന്ന രാജാക്കന്മാരെയും തോൽപ്പിച്ചിട്ട് അബ്രാം തിരിച്ചെത്തിയപ്പോൾ സൊദോംരാജാവ് രാജതാഴ്വര എന്ന ശാവേതാഴ്വരയിൽ അദ്ദേഹത്തെ എതിരേൽക്കാൻ ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ശാലേംരാജാവായ മൽക്കീസേദെക്ക് അപ്പവും വീഞ്ഞും കൊണ്ടുചെന്നു; അദ്ദേഹം പരമോന്നതനായ ദൈവത്തിന്റെ പുരോഹിതനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","അബ്രാമിനെ അനുഗ്രഹിച്ചുകൊണ്ട് അദ്ദേഹം പറഞ്ഞു: “ആകാശത്തിന്റെയും ഭൂമിയുടെയും സ്രഷ്ടാവായ, പരമോന്നതനായ ദൈവത്താൽ അബ്രാം അനുഗ്രഹിക്കപ്പെടുമാറാകട്ടെ. ");
INSERT INTO malc_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","നിന്റെ ശത്രുക്കളെ നിന്റെ കൈയിൽ ഏൽപ്പിച്ചുതന്ന പരമോന്നതനായ ദൈവം വാഴ്ത്തപ്പെടട്ടെ.” പിന്നെ അബ്രാം എല്ലാറ്റിന്റെയും ദശാംശം അദ്ദേഹത്തിന് കാഴ്ചയർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","സൊദോംരാജാവ് അബ്രാമിനോട്, “ആളുകളെ എനിക്കു തരിക, വസ്തുവകകൾ നീ എടുത്തുകൊള്ളുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","എന്നാൽ അബ്രാം സൊദോംരാജാവിനോടു പറഞ്ഞു: “ ‘ഞാൻ അബ്രാമിനെ ധനികനാക്കി’ എന്ന് അങ്ങേക്ക് ഒരിക്കലും പറയാനിടവരരുത്. അതിനുവേണ്ടി അങ്ങേക്കുള്ളതൊന്നും, ഒരു ചരടോ ചെരിപ്പിന്റെ വാറോപോലും, ഞാൻ സ്വീകരിക്കുകയില്ല എന്ന് ആകാശത്തിന്റെയും ഭൂമിയുടെയും സ്രഷ്ടാവായ, പരമോന്നതദൈവമായ യഹോവയിലേക്കു കൈ ഉയർത്തി ശപഥംചെയ്തിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","എന്റെ ആളുകൾ ഭക്ഷിച്ചതും എന്നോടുകൂടെ പോന്ന പുരുഷന്മാരുമായ ആനേർ, എസ്കോൽ, മമ്രേ എന്നിവർക്ക് അവകാശപ്പെട്ട പങ്കും ഒഴികെ മറ്റൊന്നും ഞാൻ സ്വീകരിക്കുകയില്ല. അവർ തങ്ങളുടെ വീതം എടുത്തുകൊള്ളട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","കുറച്ച് നാളുകൾക്കുശേഷം ഒരു ദർശനത്തിൽ അബ്രാമിനു യഹോവയുടെ അരുളപ്പാടുണ്ടായി: “അബ്രാമേ, ഭയപ്പെടരുത്, ഞാൻ നിന്റെ പരിച, നിന്റെ അതിമഹത്തായ പ്രതിഫലം.” ");
INSERT INTO malc_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","അതിന് അബ്രാം, “കർത്താവായ യഹോവേ, അങ്ങ് എനിക്കെന്തു നൽകും? ഞാൻ മക്കളില്ലാത്തവനാണ്; എന്റെ സ്വത്തിന് അവകാശി ദമസ്കോസുകാരനായ എലീയേസറാണ്. ");
INSERT INTO malc_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","അവിടന്ന് എനിക്കു മക്കളെ തന്നിട്ടില്ല; അതുകൊണ്ട് എന്റെ വീട്ടിലുള്ള ഒരു ദാസൻ എന്റെ അനന്തരാവകാശി ആയിത്തീരും.” ");
INSERT INTO malc_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","അപ്പോൾ അദ്ദേഹത്തോട് യഹോവ അരുളിച്ചെയ്തു: “ഇവൻ നിന്റെ അനന്തരാവകാശി ആകുകയില്ല; പിന്നെയോ, നിന്നിൽനിന്നു ജനിക്കുന്നവൻതന്നെ നിന്റെ അനന്തരാവകാശി ആയിത്തീരും.” ");
INSERT INTO malc_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","യഹോവ അവനെ പുറത്തേക്കു കൂട്ടിക്കൊണ്ടുപോയി: “നീ ആകാശത്തേക്കു നോക്കുക, നിനക്കു നക്ഷത്രങ്ങളെ എണ്ണാൻ കഴിയുമെങ്കിൽ എണ്ണുക” എന്നു കൽപ്പിച്ചു. പിന്നെ അവിടന്ന് അവനോട്, “നിന്റെ സന്തതി ഇങ്ങനെ അസംഖ്യമാകും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","അബ്രാം യഹോവയിൽ വിശ്വസിച്ചു, അതുനിമിത്തം യഹോവ അദ്ദേഹത്തെ നീതിമാനായി കണക്കാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","അവിടന്ന് അബ്രാമിനോട് പിന്നെയും അരുളിച്ചെയ്തത്: “ഈ ദേശം നിനക്ക് അവകാശമായി നൽകേണ്ടതിനു കൽദയരുടെ പട്ടണമായ ഊരിൽനിന്ന് നിന്നെ കൊണ്ടുവന്ന യഹോവ ഞാൻ ആകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","അതിന് അബ്രാം, “കർത്താവായ യഹോവേ, അതു ഞാൻ അവകാശമാക്കുമെന്ന് എനിക്കെങ്ങനെ അറിയാൻ കഴിയും?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","യഹോവ അബ്രാമിനോട്: “നീ മൂന്നുവയസ്സുള്ള ഒരു പശുക്കിടാവിനെയും മൂന്നുവയസ്സുള്ള ഒരു പെണ്ണാടിനെയും മൂന്നുവയസ്സുള്ള ഒരു ആട്ടുകൊറ്റനെയും അവയോടൊപ്പം ഒരു കുറുപ്രാവിനെയും ഒരു പ്രാവിൻകുഞ്ഞിനെയും എന്റെ അടുക്കൽ കൊണ്ടുവരിക” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","അബ്രാം ഇവയെ എല്ലാറ്റിനെയും യഹോവയുടെ അടുക്കൽ കൊണ്ടുവന്ന് നടുവേ പിളർന്ന് ഭാഗങ്ങൾ നേർക്കുനേരേ വെച്ചു. എന്നാൽ പക്ഷികളെ അദ്ദേഹം രണ്ടായി പിളർന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","അപ്പോൾ ആ ഉടലുകൾ തിന്നുന്നതിനായി ഇരപിടിയൻപക്ഷികൾ ഇറങ്ങിവന്നു; അബ്രാം അവയെ ആട്ടിക്കളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","സൂര്യൻ അസ്തമിച്ചുകൊണ്ടിരുന്നപ്പോൾ അബ്രാം ഗാഢനിദ്രയിലേക്കു വഴുതിവീണു. ഭീതിപ്പെടുത്തുന്ന ഒരു കൂരിരുട്ട് അവന്റെമേൽ വന്നു. ");
INSERT INTO malc_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","അപ്പോൾ യഹോവ അദ്ദേഹത്തോട്: “നിന്റെ പിൻഗാമികൾ സ്വന്തമല്ലാത്ത ഒരു ദേശത്ത് പ്രവാസികൾ ആയിരിക്കുകയും നാനൂറുവർഷം അവർ അവിടെ അടിമകളായി പീഡനം സഹിക്കുകയും ചെയ്യുമെന്ന് നീ നിശ്ചയമായും അറിയണം. ");
INSERT INTO malc_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","എന്നാൽ, അവർ അടിമകളായി സേവിക്കുന്ന രാജ്യത്തെ ഞാൻ ശിക്ഷിക്കും; അതിനുശേഷം അവർ ആ ദേശം വിട്ടുപോരുന്നതു വളരെ സമ്പത്തോടുംകൂടെ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","നീയോ, സമാധാനത്തോടെ നിന്റെ പിതാക്കന്മാരോടു ചേരും; നല്ല വാർധക്യത്തിൽ അടക്കപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","നിന്റെ സന്തതികളുടെ നാലാംതലമുറ ഇവിടെ മടങ്ങിയെത്തും; അമോര്യരുടെ പാപം ഇതുവരെയും അതിന്റെ പരമകാഷ്ഠയിൽ എത്തിയിട്ടില്ലല്ലോ” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","സൂര്യൻ അസ്തമിച്ച് അന്ധകാരം വ്യാപിച്ചപ്പോൾ ജ്വലിക്കുന്ന പന്തത്തോടുകൂടിയതും പുകയുന്നതുമായ ഒരു തീച്ചൂള പ്രത്യക്ഷപ്പെട്ടു, അത് ആ ഭാഗങ്ങളുടെ മധ്യേകൂടി കടന്നുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","യഹോവ ആ ദിവസം അബ്രാമിനോട് ഒരു ഉടമ്പടിചെയ്തു. അവിടന്ന് ഇപ്രകാരം അരുളിച്ചെയ്തു. “ഞാൻ നിന്റെ സന്തതിക്ക് ഈജിപ്റ്റിലെ തോടുമുതൽ മഹാനദിയായ യൂഫ്രട്ടീസുവരെയുള്ള ദേശം തരും. ");
INSERT INTO malc_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","കേന്യർ, കെനിസ്യർ, കദ്മോന്യർ, ");
INSERT INTO malc_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ഹിത്യർ, പെരിസ്യർ, രെഫായീമ്യർ, ");
INSERT INTO malc_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","അമോര്യർ, കനാന്യർ, ഗിർഗ്ഗശ്യർ, യെബൂസ്യർ എന്നിവരുടെ ദേശംതന്നെ തന്നിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","അബ്രാമിന്റെ ഭാര്യയായ സാറായിക്കു മക്കൾ ജനിച്ചിരുന്നില്ല; അവൾക്കു ഹാഗാർ എന്നു പേരുള്ള ഈജിപ്റ്റുകാരിയായ ഒരു ദാസി ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","സാറായി അബ്രാമിനോട്, “യഹോവ എന്റെ ഗർഭം അടച്ചിരിക്കുന്നു. എന്റെ ദാസിയുടെ അടുക്കൽ ചെല്ലുക; അവളിലൂടെ ഒരുപക്ഷേ എനിക്ക് മക്കൾ ഉണ്ടായേക്കാം” എന്നു പറഞ്ഞു. സാറായിയുടെ നിർദേശം അബ്രാം അംഗീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","അങ്ങനെ അബ്രാമിന്റെ ഭാര്യ സാറായി തന്റെ ഈജിപ്റ്റുകാരി ദാസി ഹാഗാറിനെ അദ്ദേഹത്തിനു ഭാര്യയായി കൊടുത്തു. ഇതു സംഭവിച്ചത് അബ്രാം കനാനിൽ താമസം ആരംഭിച്ചു പത്തുവർഷം കഴിഞ്ഞപ്പോഴാണ്. ");
INSERT INTO malc_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","അദ്ദേഹം ഹാഗാറിന്റെ അടുക്കൽ ചെന്നു. അവൾ ഗർഭിണിയായിത്തീർന്നു. താൻ ഗർഭവതിയായിരിക്കുന്നു എന്നറിഞ്ഞതുമുതൽ ഹാഗാർ തന്റെ യജമാനത്തിയായ സാറായിയോട് അവജ്ഞയോടെ പെരുമാറാൻതുടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","അപ്പോൾ സാറായി അബ്രാമിനോട്, “ഞാൻ സഹിക്കുന്ന ഈ അന്യായത്തിന് അങ്ങാണ് ഉത്തരവാദി. ഞാൻ എന്റെ ദാസിയെ അങ്ങയുടെ കരങ്ങളിൽ ഏൽപ്പിച്ചു. ഇപ്പോഴിതാ, അവൾ ഗർഭവതിയാണെന്നറിഞ്ഞതുമുതൽ എന്നെ ആദരിക്കുന്നില്ല. യഹോവ അങ്ങേക്കും എനിക്കും മധ്യേ ന്യായംവിധിക്കട്ടെ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","അപ്പോൾ അബ്രാം, “നിന്റെ ദാസി നിന്റെ കൈകളിൽത്തന്നെ. നിനക്ക് ഏറ്റവും ഉചിതമെന്നു തോന്നുന്നത് അവളോടു ചെയ്യുക” എന്നു പറഞ്ഞു. അപ്പോൾ സാറായി ഹാഗാറിനോട് നിർദയമായി പെരുമാറി; അതുകൊണ്ട് അവൾ സാറായിയെ വിട്ട് ഓടിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","യഹോവയുടെ ദൂതൻ മരുഭൂമിയിലെ ഒരു നീരുറവിനടുത്തുവെച്ച് ഹാഗാറിനെ കണ്ടു; ആ നീരുറവ ശൂരിലേക്കുള്ള പാതയുടെ അരികത്തായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ദൂതൻ അവളോട്, “സാറായിയുടെ ദാസിയായ ഹാഗാറേ, നീ എവിടെനിന്നു വരുന്നു? എവിടേക്കു പോകുന്നു?” എന്നു ചോദിച്ചു. അതിന് ഹാഗാർ, “ഞാൻ എന്റെ യജമാനത്തിയുടെ അടുക്കൽനിന്ന് ഓടിപ്പോകുന്നു” എന്നു മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","അപ്പോൾ യഹോവയുടെ ദൂതൻ അവളോട്: “നീ യജമാനത്തിയുടെ അടുത്തേക്കു മടങ്ങിച്ചെന്ന് അവൾക്കു കീഴടങ്ങിയിരിക്കുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ദൂതൻ തുടർന്നു, “ഞാൻ നിന്റെ സന്തതിയെ, എണ്ണിത്തിട്ടപ്പെടുത്താൻ കഴിയാത്തവിധം അത്യധികം വർധിപ്പിക്കും” എന്നും പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","യഹോവയുടെ ദൂതൻ അവളോടു വീണ്ടും പറഞ്ഞത്: “ഇപ്പോൾ നീ ഗർഭവതിയാണ്. നീ ഒരു മകനെ പ്രസവിക്കും. നീ അവന് യിശ്മായേൽ എന്നു പേരിടണം; യഹോവ നിന്റെ സങ്കടം കേട്ടിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","അവൻ കാട്ടുകഴുതയെപ്പോലുള്ള ഒരു മനുഷ്യൻ ആയിരിക്കും. അവന്റെ കൈ എല്ലാവർക്കും വിരോധമായിരിക്കും; എല്ലാവരുടെയും കൈ അവനും വിരോധമായിരിക്കും; അവൻ തന്റെ സകലസഹോദരങ്ങളോടും ശത്രുതയിൽ ജീവിക്കും.” ");
INSERT INTO malc_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","അതിനുശേഷം തന്നോടു സംസാരിച്ച യഹോവയ്ക്ക് അവൾ “എന്നെ കാണുന്ന ദൈവമാണ് അങ്ങ്,” എന്നു പേരിട്ടു; “എന്നെ കാണുന്ന ദൈവത്തെ ഇപ്പോൾ ഞാനും കണ്ടിരിക്കുന്നു,” എന്ന് അവൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","അതുകൊണ്ട് ആ നീരുറവയ്ക്ക് ബേർ-ലഹയീ-രോയീ എന്നു പേരുണ്ടായി. അതു കാദേശിനും ബേരെദിനും മധ്യേ ഇപ്പോഴും ഉണ്ട്. ");
INSERT INTO malc_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ഇതിനുശേഷം ഹാഗാർ അബ്രാമിന് ഒരു മകനെ പ്രസവിച്ചു. ഹാഗാറിൽ തനിക്കുണ്ടായ മകന് അബ്രാം യിശ്മായേൽ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ഹാഗാർ അബ്രാമിനു യിശ്മായേലിനെ പ്രസവിച്ചപ്പോൾ അബ്രാമിന് എൺപത്തിയാറു വയസ്സായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","അബ്രാമിനു തൊണ്ണൂറ്റിയൊൻപതു വയസ്സായപ്പോൾ യഹോവ പ്രത്യക്ഷനായി അദ്ദേഹത്തോട്: “ഞാൻ ആകുന്നു സർവശക്തനായ ദൈവം; നീ എന്റെമുമ്പാകെ നടക്കുക; നിഷ്കളങ്കനായിരിക്കുക. ");
INSERT INTO malc_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","എനിക്കും നിനക്കും തമ്മിലുള്ള ഉടമ്പടി ഞാൻ ഉറപ്പിക്കുകയും നിന്നെ അത്യധികമായി വർധിപ്പിക്കുകയും ചെയ്യും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","അബ്രാം സാഷ്ടാംഗം വീണു; ദൈവം അദ്ദേഹത്തോട് അരുളിച്ചെയ്തു, ");
INSERT INTO malc_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“നിന്നോടുള്ള എന്റെ ഉടമ്പടി: നീ അനേകം ജനതകൾക്കു പിതാവായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ഇനിയൊരിക്കലും നീ അബ്രാം എന്നു വിളിക്കപ്പെടുകയില്ല, നിന്റെ പേര് അബ്രാഹാം എന്നായിരിക്കും; ഞാൻ നിന്നെ അനേകം ജനതകൾക്കു പിതാവാക്കിയിരിക്കുന്നു: ");
INSERT INTO malc_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ഞാൻ നിന്നെ സന്താനപുഷ്ടിയുള്ളവനാക്കും. നിന്നിൽനിന്ന് ജനതകൾ ഉത്ഭവിക്കും. രാജാക്കന്മാരും നിന്നിൽനിന്ന് ഉത്ഭവിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","എനിക്കും നിനക്കും നിനക്കുശേഷം നിന്റെ സന്തതിക്കും മധ്യേ ഞാൻ എന്റെ ഉടമ്പടി ശാശ്വത ഉടമ്പടിയായി സ്ഥാപിക്കും; അതനുസരിച്ച് ഞാൻ നിന്റെയും നിനക്കുശേഷം തലമുറയായി നിന്റെ സന്തതിയുടെയും ദൈവമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","നീ ഇപ്പോൾ പ്രവാസിയായി പാർക്കുന്ന കനാൻദേശം മുഴുവൻ നിനക്കും നിനക്കുശേഷം നിന്റെ പിൻഗാമികൾക്കും ശാശ്വതാവകാശമായി നൽകും; ഞാൻ അവരുടെ ദൈവവും ആയിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ദൈവം അബ്രാഹാമിനോട് വീണ്ടും അരുളിച്ചെയ്തു: “നീ ചെയ്യേണ്ടതെന്തെന്നാൽ, നീയും നിനക്കുശേഷം തലമുറതലമുറയായി നിന്റെ സന്തതിയും എന്റെ ഉടമ്പടി പാലിക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","നീയും നിനക്കുശേഷം നിന്റെ സന്തതിയും പാലിക്കേണ്ടതിന് ഞാൻ നിന്നോടു ചെയ്യുന്ന ഉടമ്പടി ഇതാണ്: നിങ്ങളിൽ പുരുഷന്മാരെല്ലാം പരിച്ഛേദനം ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","നിങ്ങൾ ഏൽക്കുന്ന പരിച്ഛേദനം എനിക്കും നിനക്കും മധ്യേയുള്ള ഉടമ്പടിയുടെ ചിഹ്നമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","തലമുറതോറും നിന്റെ ഭവനത്തിൽ ജനിച്ചവരും അന്യദേശക്കാരിൽനിന്ന് നീ വിലയ്ക്കു വാങ്ങിയവർക്ക് ജനിച്ച നിന്റെ സ്വന്തം മക്കളല്ലാത്തവരും ഉൾപ്പെടെ, നിങ്ങളുടെ കൂട്ടത്തിലുള്ള എട്ടുദിവസം പ്രായമായ എല്ലാ പുരുഷപ്രജയും പരിച്ഛേദനം ഏൽക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","നിന്റെ ഭവനത്തിൽ ജനിച്ചവരാകട്ടെ, നിന്റെ പണം കൊടുത്തു വാങ്ങിയവരാകട്ടെ, അവരെല്ലാവരും പരിച്ഛേദനം ഏറ്റിരിക്കേണ്ടതാണ്. നിങ്ങളുടെ ശരീരത്തിലുള്ള എന്റെ ഉടമ്പടി ശാശ്വത ഉടമ്പടി ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","പരിച്ഛേദനം ഏറ്റിട്ടില്ലാത്ത—ശരീരത്തിൽ പരിച്ഛേദനം ഏറ്റിട്ടില്ലാത്ത—ഏതൊരു പുരുഷപ്രജയും തന്റെ ജനത്തിന്റെ ഇടയിൽനിന്ന് നീക്കംചെയ്യപ്പെടണം; അവൻ എന്റെ ഉടമ്പടി ലംഘിച്ചിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ദൈവം പിന്നെയും അബ്രാഹാമിനോടു കൽപ്പിച്ചു: “നിന്റെ ഭാര്യയായ സാറായിയെ ഇനിയൊരിക്കലും ‘സാറായി’ എന്നു വിളിക്കരുത്; അവളുടെ പേര് ‘സാറാ’ എന്നായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ഞാൻ അവളെ അനുഗ്രഹിക്കും; അവളിൽ നിനക്കൊരു മകനെ നൽകും. അവൾ അനേകം ജനതകൾക്കു മാതാവായിത്തീരും. അതേ, ഞാൻ അവളെ സമൃദ്ധമായി അനുഗ്രഹിക്കും; ജനങ്ങളുടെ രാജാക്കന്മാർ അവളിൽനിന്ന് ഉത്ഭവിക്കും.” ");
INSERT INTO malc_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","അപ്പോൾ അബ്രാഹാം കമിഴ്ന്നുവീണു; അദ്ദേഹം ചിരിച്ചുകൊണ്ടു ഹൃദയത്തിൽ പറഞ്ഞു, “നൂറു വയസ്സായ മനുഷ്യനു മകൻ ജനിക്കുമോ? തൊണ്ണൂറാം വയസ്സിൽ സാറാ പ്രസവിക്കുമോ?” ");
INSERT INTO malc_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","അബ്രാഹാം ദൈവത്തോട്: “അവിടത്തെ അനുഗ്രഹത്താൽ യിശ്മായേൽ ജീവിച്ചിരുന്നാൽ മതി” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","അപ്പോൾ ദൈവം അരുളിച്ചെയ്തത്: “അങ്ങനെയല്ല, നിന്റെ ഭാര്യയായ സാറാ നിനക്കൊരു മകനെ പ്രസവിക്കും; അവന് യിസ്ഹാക്ക് എന്നു നാമകരണം ചെയ്യണം. ഞാൻ അവനോടും അവനുശേഷം അവന്റെ സന്തതികളോടുമായി എന്റെ ഉടമ്പടി ശാശ്വത ഉടമ്പടിയായി ഉറപ്പിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","യിശ്മായേലിനെ സംബന്ധിച്ച്, ഞാൻ നിന്റെ അപേക്ഷ കേട്ടിരിക്കുന്നു; നിശ്ചയമായും ഞാൻ അവനെ അനുഗ്രഹിക്കും; അവനെ സന്താനസമൃദ്ധിയുള്ളവനാക്കി അവന്റെ സംഖ്യ അത്യധികമായി വർധിപ്പിക്കും. അവൻ പന്ത്രണ്ടു പ്രഭുക്കന്മാരുടെ പിതാവായിത്തീരും; അവനെ ഒരു വലിയ ജനതയാക്കും. ");
INSERT INTO malc_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","എന്നാൽ അടുത്തവർഷം, ഇതേ സമയത്ത് സാറാ നിനക്കു പ്രസവിക്കുന്ന മകൻ യിസ്ഹാക്കുമായിട്ടാണ് ഞാൻ എന്റെ ഉടമ്പടി സ്ഥിരപ്പെടുത്തുന്നത്.” ");
INSERT INTO malc_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ഇതു സംസാരിച്ചുതീർന്നപ്പോൾ ദൈവം അബ്രാഹാമിനെവിട്ട് ആരോഹണംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ആ ദിവസംതന്നെ അബ്രാഹാം തന്റെ മകനായ യിശ്മായേലിനെയും തന്റെ ഭവനത്തിൽ ജനിച്ചവരും വിലയ്ക്കു വാങ്ങിയവരുമായി, തന്റെ ഭവനത്തിൽ ഉണ്ടായിരുന്ന സകലപുരുഷപ്രജകളെയും കൂട്ടിക്കൊണ്ടുപോയി, ദൈവം തന്നോടു കൽപ്പിച്ചതിൻപ്രകാരം, അവർക്കു പരിച്ഛേദനം നടത്തി. ");
INSERT INTO malc_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","പരിച്ഛേദനം ഏൽക്കുമ്പോൾ അബ്രാഹാമിനു തൊണ്ണൂറ്റിയൊൻപതു വയസ്സായിരുന്നു; ");
INSERT INTO malc_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","അദ്ദേഹത്തിന്റെ മകൻ യിശ്മായേലിന് അപ്പോൾ പതിമ്മൂന്നുവയസ്സും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","അബ്രാഹാമും അദ്ദേഹത്തിന്റെ മകനായ യിശ്മായേലും പരിച്ഛേദനം ഏറ്റത് ഒരേദിവസമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","അബ്രാഹാമിന്റെ വീട്ടിൽ ജനിച്ചവരും വിദേശിയോടു വാങ്ങിയവരും ഉൾപ്പെടെ അബ്രാഹാമിന്റെ വീട്ടിൽ ഉണ്ടായിരുന്ന, എല്ലാ പുരുഷപ്രജകളും അദ്ദേഹത്തോടുകൂടെ പരിച്ഛേദനം ഏറ്റു. ");
INSERT INTO malc_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ഒരു ദിവസം വെയിലുറച്ചപ്പോൾ അബ്രാഹാം തന്റെ കൂടാരവാതിൽക്കൽ ഇരിക്കുകയായിരുന്നു, അപ്പോൾ യഹോവ അബ്രാഹാമിനു മമ്രേയുടെ മഹാവൃക്ഷങ്ങൾക്കരികെ പ്രത്യക്ഷനായി. ");
INSERT INTO malc_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","അദ്ദേഹം തലയുയർത്തിനോക്കിയപ്പോൾ മൂന്നുപുരുഷന്മാർ അടുക്കൽ നിൽക്കുന്നതു കണ്ടു; അവരെ കണ്ടമാത്രയിൽ, അദ്ദേഹം കൂടാരവാതിൽക്കൽനിന്ന് തിടുക്കത്തിൽ ചെന്ന് സാഷ്ടാംഗം വീണുവണങ്ങി അവരെ എതിരേറ്റു. ");
INSERT INTO malc_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“എന്റെ കർത്താവേ, അങ്ങേക്ക് കൃപയുണ്ടെങ്കിൽ അടിയനോടൊപ്പം കുറച്ചു സമയം ചെലവഴിക്കണേ. ");
INSERT INTO malc_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ഞാൻ കുറച്ചുവെള്ളം കൊണ്ടുവരട്ടെ, നിങ്ങൾക്ക് എല്ലാവർക്കും കാലുകഴുകി ഈ മരത്തിന്റെ തണലിൽ വിശ്രമിക്കാമല്ലോ. ");
INSERT INTO malc_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ഞാൻ നിങ്ങൾക്കു കഴിക്കാൻ എന്തെങ്കിലും കൊണ്ടുവരാം, വിശപ്പടക്കിയശേഷം നിങ്ങൾക്കു യാത്ര തുടരാം. അവിടന്ന് അടിയന്റെ അടുക്കൽ വന്നതാണല്ലോ” എന്ന് അബ്രാഹാം പറഞ്ഞു. അതിനുത്തരമായി അവർ, “വളരെ നന്ന്, നീ പറഞ്ഞതുപോലെ ചെയ്യുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","അബ്രാഹാം വേഗത്തിൽ കൂടാരത്തിനുള്ളിൽ സാറായുടെ അടുത്തെത്തി. “നീ പെട്ടെന്ന് മൂന്നു സേയാ നേർത്ത മാവെടുത്തു കുഴച്ച് കുറച്ച് അപ്പം ചുടുക,” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","പിന്നെ അബ്രാഹാം ഓടിച്ചെന്ന് കാലിക്കൂട്ടത്തിൽനിന്ന് ഇളപ്പമായ നല്ലൊരു കാളക്കിടാവിനെ പിടിച്ച് ഒരു ദാസനെ ഏൽപ്പിച്ചു. അവൻ വേഗത്തിൽ അതിനെ പാകംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","പിന്നെ അബ്രാഹാം കുറെ വെണ്ണയും പാലും പാകംചെയ്ത കാളയിറച്ചിയും കൊണ്ടുവന്ന് അവരുടെമുമ്പിൽ വെച്ചു. അവർ ഭക്ഷണം കഴിച്ചുകൊണ്ടിരുന്നപ്പോൾ അദ്ദേഹം അവർക്കു സമീപം ഒരു മരത്തണലിൽ അവരെ ശുശ്രൂഷിക്കാനായി നിന്നു. ");
INSERT INTO malc_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“നിന്റെ ഭാര്യയായ സാറാ എവിടെ?” അവർ ചോദിച്ചു. “കൂടാരത്തിലുണ്ട്” അദ്ദേഹം മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","അപ്പോൾ അവരിലൊരാൾ, “അടുത്തവർഷം ഇതേസമയം ഞാൻ നിന്റെ അടുക്കൽ മടങ്ങിവരും; അപ്പോൾ നിന്റെ ഭാര്യയായ സാറായ്ക്ക് ഒരു മകൻ ഉണ്ടായിരിക്കും” എന്നു പറഞ്ഞു. സാറാ പിന്നിൽ കൂടാരവാതിൽക്കൽനിന്ന് ഇതു ശ്രദ്ധിക്കുകയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","അബ്രാഹാമും സാറായും വൃദ്ധരും വളരെ പ്രായമായവരും ആയിരുന്നു. സാറായ്ക്കു ഗർഭധാരണത്തിനുള്ള പ്രായവും കഴിഞ്ഞുപോയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","“ഞാൻ വൃദ്ധയായി, എന്റെ ഭർത്താവും വൃദ്ധനായിരിക്കുന്നു; ഇനി ഈ സൗഭാഗ്യം എനിക്കുണ്ടാകുമോ?” സാറാ ചിരിച്ചുകൊണ്ട് ആത്മഗതംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","അപ്പോൾ യഹോവ അബ്രാഹാമിനോട്, “വൃദ്ധയായ എനിക്കു കുട്ടിയുണ്ടാകുമോ എന്നു പറഞ്ഞു സാറാ ചിരിച്ചതെന്ത്? ");
INSERT INTO malc_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","യഹോവയ്ക്ക് അസാധ്യമായ കാര്യം ഉണ്ടോ? അടുത്തവർഷം നിശ്ചിതസമയം ഞാൻ നിന്റെ അടുക്കൽ മടങ്ങിവരും, അപ്പോൾ സാറായ്ക്ക് ഒരു മകൻ ഉണ്ടായിരിക്കും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","സാറാ ഭയന്നുപോയി, അതുകൊണ്ട് അവൾ, “ഞാൻ ചിരിച്ചില്ല” എന്നു മാറ്റിപ്പറഞ്ഞു. എന്നാൽ അവിടന്ന്, “അല്ല, നീ ചിരിച്ചു” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ആ പുരുഷന്മാർ അവിടെനിന്നു പുറപ്പെട്ടു. അവർ താഴേ സൊദോമിലേക്കു തിരിഞ്ഞു. അബ്രാഹാം അവരെ യാത്രയയയ്ക്കാൻ അവരോടുകൂടെ നടന്നു. ");
INSERT INTO malc_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","അപ്പോൾ യഹോവ: “ഞാൻ ചെയ്യാൻപോകുന്നത് അബ്രാഹാമിൽനിന്ന് മറച്ചുവെക്കുമോ? ");
INSERT INTO malc_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","അബ്രാഹാമിന്റെ വംശം നിശ്ചയമായും ശ്രേഷ്ഠവും പ്രബലവുമായ ഒരു രാഷ്ട്രമായിത്തീരും; ഭൂമിയിലെ സകലരാഷ്ട്രങ്ങളും അവനിലൂടെ അനുഗ്രഹിക്കപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","അബ്രാഹാം നീതിയും ന്യായവും പ്രവർത്തിച്ചുകൊണ്ട്, തന്റെ മക്കളെയും തന്റെ കാലശേഷമുള്ള ഭവനക്കാരെയും ദൈവത്തിന്റെ വഴികളിൽ നടക്കാൻ പ്രേരിപ്പിക്കേണ്ടതിനു ഞാൻ അവനെ തെരഞ്ഞെടുത്തിരിക്കുന്നു. അങ്ങനെ, യഹോവ അബ്രാഹാമിനു നൽകിയ വാഗ്ദാനം അദ്ദേഹത്തിന് നിറവേറ്റിക്കൊടുക്കാൻ സംഗതിയാകും.” ");
INSERT INTO malc_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","പിന്നെ യഹോവ അരുളിച്ചെയ്തു: “സൊദോമിന്റെയും ഗൊമോറായുടെയും പാപം ഘോരമായതും അവർക്കു വിരോധമായുള്ള നിലവിളി വലിയതുമാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","എന്റെ അടുക്കൽ എത്തിയിരിക്കുന്ന നിലവിളിക്കു തക്കവണ്ണം അവരുടെ പ്രവൃത്തി ദോഷപൂർണമാണോ എന്നുനോക്കി മനസ്സിലാക്കാൻ ഞാൻ ഇറങ്ങിച്ചെല്ലും.” ");
INSERT INTO malc_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ആ പുരുഷന്മാർ തിരിഞ്ഞ് സൊദോമിലേക്കു പോയി. എന്നാൽ, അബ്രാഹാം യഹോവയുടെ സന്നിധിയിൽത്തന്നെ നിലകൊണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","പിന്നെ അബ്രാഹാം അടുത്തുചെന്ന്, “അവിടന്നു നീതിമാന്മാരെ ദുഷ്ടന്മാരോടുകൂടെ തുടച്ചുനീക്കുമോ? എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","നീതിമാന്മാരായ അൻപതുപേർ നഗരത്തിൽ ഉണ്ടെങ്കിൽ എന്താണു ചെയ്യുക? അങ്ങ് ആ നഗരത്തെ വാസ്തവമായി നശിപ്പിക്കുമോ? അതിലുള്ള അൻപതു നീതിമാന്മാർ നിമിത്തം ആ സ്ഥലത്തെ അങ്ങ് രക്ഷിക്കുകയില്ലയോ? ");
INSERT INTO malc_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","നീതിമാന്മാരെയും ദുഷ്ടന്മാരെയും ഒരുപോലെ കണക്കാക്കുന്നതും ദുഷ്ടന്മാരോടൊപ്പം നീതിമാന്മാരെ സംഹരിക്കുന്നതും അവിടത്തേക്ക് ഉചിതമല്ലല്ലോ! അങ്ങനെ വരരുതേ. സർവഭൂമിയുടെയും ന്യായാധിപതി നീതി പ്രവർത്തിക്കാതിരിക്കുമോ?” ");
INSERT INTO malc_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","അതിനു യഹോവ: “അൻപതു നീതിമാന്മാരെ സൊദോം പട്ടണത്തിനുള്ളിൽ കാണുന്നെങ്കിൽ അവർക്കുവേണ്ടി ഞാൻ ആ സ്ഥലം മുഴുവൻ രക്ഷിക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","അബ്രാഹാം വീണ്ടും ചോദിച്ചു: “വെറും പൊടിയും ചാരവും ആയ ഞാൻ കർത്താവിനോട് സംസാരിക്കാൻ തുനിഞ്ഞല്ലോ! ");
INSERT INTO malc_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","അൻപതു നീതിമാന്മാരിൽ അഞ്ചുപേർ കുറഞ്ഞാൽ ആ അഞ്ചുപേർ നിമിത്തം അങ്ങു നഗരത്തെ മുഴുവൻ നശിപ്പിക്കുമോ?” “അവിടെ നാൽപ്പത്തിയഞ്ചുപേരെ കാണുന്നെങ്കിൽ, ഞാൻ അതിനെ നശിപ്പിക്കുകയില്ല,” അവിടന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","വീണ്ടും അദ്ദേഹം ദൈവത്തോടു ചോദിച്ചു, “നാൽപ്പതുപേരേ ഉള്ളെങ്കിലോ?” “ആ നാൽപ്പതുപേർക്കുവേണ്ടി ഞാൻ അങ്ങനെ ചെയ്യുകയില്ല,” അവിടന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","അദ്ദേഹം വീണ്ടും: “കർത്താവു കോപിക്കരുതേ, അടിയൻ സംസാരിക്കട്ടെ; അവിടെ കേവലം മുപ്പതുപേരെ ഉള്ളൂ എന്നുവരികിലോ?” എന്നു ചോദിച്ചു. അതിനു യഹോവ: “മുപ്പതുപേരെ കാണുന്നെങ്കിൽ ഞാൻ അങ്ങനെ പ്രവർത്തിക്കുകയില്ല” എന്നു മറുപടികൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","“കർത്താവിനോടു സംസാരിക്കാൻ എനിക്കു ധൈര്യം ഉണ്ടായിരിക്കുന്ന സ്ഥിതിക്ക്, ഇരുപതുപേർമാത്രമേ അവിടെ ഉള്ളൂ എങ്കിലോ?” അബ്രാഹാം ചോദിച്ചു. “ഇരുപതുപേർക്കുവേണ്ടി, ഞാൻ നശിപ്പിക്കുകയില്ല” അവിടന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","അപ്പോൾ അബ്രാഹാം ചോദിച്ചു, “കർത്താവേ, കോപിക്കരുതേ, അടിയൻ ഒരിക്കൽക്കൂടിമാത്രം ചോദിക്കട്ടെ, പത്തുപേരേ അവിടെ ഉള്ളൂ എങ്കിലോ?” “പത്തുപേർക്കുവേണ്ടി ഞാൻ അതിനെ നശിപ്പിക്കാതിരിക്കും,” അവിടന്നു മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","യഹോവ അബ്രാഹാമിനോടു സംസാരിച്ചതിനുശേഷം അവിടം വിട്ടുപോയി; അബ്രാഹാമും വീട്ടിലേക്കു മടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ആ രണ്ടു ദൂതന്മാർ സന്ധ്യക്കു സൊദോമിൽ എത്തി; ലോത്ത് നഗരകവാടത്തിൽ ഇരിക്കുകയായിരുന്നു. അവരെ കണ്ടപ്പോൾ അദ്ദേഹം എഴുന്നേറ്റു നിലംവരെ കുനിഞ്ഞു നമസ്കരിച്ചുകൊണ്ട് എതിരേറ്റു. ");
INSERT INTO malc_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","പിന്നെ ലോത്ത്, “യജമാനന്മാരേ, ദയവായി അടിയന്റെ വീട്ടിലേക്കു വന്നാലും; കാലുകൾ കഴുകി രാത്രിയിൽ വിശ്രമിച്ചിട്ട് അതിരാവിലെ നിങ്ങൾക്കു യാത്ര തുടരാമല്ലോ” എന്നു പറഞ്ഞു. “വേണ്ടാ, ഞങ്ങൾ തെരുവീഥിയിൽ രാത്രി ചെലവഴിച്ചുകൊള്ളാം,” അവർ മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","എന്നാൽ ലോത്ത് വളരെ നിർബന്ധിച്ചതുകൊണ്ട് അവർ അദ്ദേഹത്തോടൊപ്പം പോയി വീട്ടിൽ പ്രവേശിച്ചു. അദ്ദേഹം അവർക്കുവേണ്ടി പുളിപ്പില്ലാത്ത അപ്പം ചുട്ടു വിരുന്നൊരുക്കി; അവർ ഭക്ഷണം കഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","അവർ ഉറങ്ങാൻ കിടക്കുന്നതിനുമുമ്പ് സൊദോം നഗരത്തിന്റെ എല്ലാ ഭാഗത്തുനിന്നുമുള്ള പുരുഷന്മാർ—യുവാക്കന്മാരും വൃദ്ധന്മാരും—എല്ലാവരുംകൂടി ആ വീട് വളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","അവർ ലോത്തിനെ വിളിച്ച് “ഇന്നു രാത്രി നിന്റെ അടുക്കൽ വന്ന പുരുഷന്മാർ എവിടെ? അവരെ പുറത്ത്, ഞങ്ങളുടെ അടുത്തേക്കു കൊണ്ടുവരൂ; ഞങ്ങൾ അവരുമായി ലൈംഗികവേഴ്ച നടത്തട്ടെ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ലോത്ത് അവരോടു സംസാരിക്കാൻ പുറത്തേക്കു ചെന്നു, കതകടച്ചിട്ട് അവരോട്, ");
INSERT INTO malc_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“എന്റെ സ്നേഹിതരേ, അതു പാടില്ല; ഈ അധർമം പ്രവർത്തിക്കരുതേ. ");
INSERT INTO malc_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","പുരുഷനോടൊപ്പം കിടക്കപങ്കിട്ടിട്ടില്ലാത്ത രണ്ടു പുത്രിമാർ എനിക്കുണ്ട്. ഞാൻ അവരെ നിങ്ങളുടെ അടുക്കൽ കൊണ്ടുവരാം, നിങ്ങളുടെ ഇഷ്ടംപോലെ അവരോടു പെരുമാറിക്കൊള്ളുക. എന്നാൽ, ഈ പുരുഷന്മാരോട് ഒന്നും ചെയ്യരുതേ; അവർ എന്റെ ഭവനത്തിൽ അഭയംതേടി വന്നവരാണ്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","അതിന് അവർ: “ഞങ്ങളെ തടയാതെ മാറിനിൽക്കൂ. ഇയാൾ ഇവിടെ പ്രവാസിയായി വന്നു; ഇപ്പോൾ ഇതാ ന്യായാധിപൻ ചമയുന്നു! ഞങ്ങൾ അവരോടു ചെയ്യുന്നതിലും അധികം ദോഷം നിന്നോടു ചെയ്യും” എന്നു പറഞ്ഞു. അവർ ലോത്തിനെ ഞെരുക്കിക്കൊണ്ട് വാതിൽ തകർക്കാൻ മുന്നോട്ടടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","എന്നാൽ, അകത്തുണ്ടായിരുന്ന ആ പുരുഷന്മാർ കൈ പുറത്തേക്കു നീട്ടി ലോത്തിനെ വീടിനുള്ളിലേക്കു വലിച്ചുകയറ്റിയിട്ട് കതകടച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","പിന്നെ അവർ വീടിന്റെ വാതിൽക്കൽ ഉണ്ടായിരുന്ന ആബാലവൃദ്ധം പുരുഷന്മാർക്ക് അന്ധത പിടിപ്പിച്ചു, അവർക്കു വാതിൽ കണ്ടെത്താൻ കഴിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ആ രണ്ടു പുരുഷന്മാർ ലോത്തിനോട്, “നിന്റെ സ്വന്തക്കാരായി—മരുമക്കളോ പുത്രന്മാരോ പുത്രിമാരോ മറ്റാരെങ്കിലുമോ ഈ നഗരത്തിൽ ഉണ്ടോ? അവരെല്ലാവരുമായി ഇവിടെനിന്ന് ഓടി രക്ഷപ്പെടുക; ");
INSERT INTO malc_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ഞങ്ങൾ ഈ സ്ഥലം നശിപ്പിക്കാൻ പോകുകയാണ്. ഇതിലെ ജനങ്ങൾക്കെതിരായി യഹോവയോടുള്ള മുറവിളി വളരെ വലുതാണ്. ആകയാൽ ഇതിനെ നശിപ്പിക്കാൻ അവിടന്നു ഞങ്ങളെ അയച്ചിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","അങ്ങനെ ലോത്ത് തന്റെ പുത്രിമാർക്കു വിവാഹനിശ്ചയം ചെയ്തിരുന്നവരായ മരുമക്കളുടെ അടുക്കൽച്ചെന്ന് അവരോടു സംസാരിച്ചു. “നിങ്ങൾ വേഗത്തിൽ ഈ സ്ഥലത്തുനിന്ന് രക്ഷപ്പെടുക, യഹോവ ഈ നഗരത്തെ നശിപ്പിക്കാൻ തുടങ്ങുന്നു!” എന്നു പറഞ്ഞു. എന്നാൽ അദ്ദേഹം തമാശ പറയുന്നെന്നു മരുമക്കൾ ചിന്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ഉഷസ്സായപ്പോൾ ആ ദൂതന്മാർ ലോത്തിനെ നിർബന്ധിച്ചുകൊണ്ടു “വേഗം, നിന്റെ ഭാര്യയെയും രണ്ടു പുത്രിമാരെയും കൂട്ടിക്കൊണ്ടുപോകുക, അല്ലെങ്കിൽ നഗരത്തോടൊപ്പം നിങ്ങൾ നശിച്ചുപോകും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ലോത്ത് മടിച്ചുനിന്നപ്പോൾ—യഹോവയ്ക്ക് അവരോടു കരുണയുണ്ടായി—ആ പുരുഷന്മാർ അദ്ദേഹത്തെയും ഭാര്യയെയും രണ്ടു പുത്രിമാരെയും കൈക്കുപിടിച്ചു നഗരത്തിനു പുറത്തേക്കു കൊണ്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","അവരെ പുറത്തുകൊണ്ടുവന്നശേഷം അവരിൽ ഒരാൾ, “പ്രാണരക്ഷയ്ക്കായി ഓടിപ്പോകുക, തിരിഞ്ഞുനോക്കരുത്, സമഭൂമിയിൽ ഒരിടത്തും തങ്ങരുത്. മലകളിലേക്ക് ഓടുക, അല്ലെങ്കിൽ നിങ്ങൾ നിശ്ശേഷം നശിച്ചുപോകും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","എന്നാൽ ലോത്ത് അവരോട്, “കർത്താവേ, ദയവായി അങ്ങനെ ചെയ്യരുതേ! ");
INSERT INTO malc_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","അങ്ങേക്ക് അടിയനോടു കൃപതോന്നിയല്ലോ. എന്റെ ജീവനെ രക്ഷിച്ചതിലൂടെ അവിടന്നു വലിയ കരുണകാണിച്ചിരിക്കുന്നു. എനിക്കു മലകളിലേക്ക് ഓടിരക്ഷപ്പെടാൻ നിവൃത്തിയില്ല; ഈ വിപത്ത് എന്നെ മൂടിക്കളയും, ഞാൻ മരിച്ചുപോകുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ഇതാ, ഓടിച്ചെന്നെത്താൻ കഴിയുംവിധം സമീപത്തായി ഒരു ചെറിയ പട്ടണമുണ്ടല്ലോ! അതിലേക്ക് ഓടിപ്പോകാൻ എന്നെ അനുവദിക്കണമേ; അതു തീരെ ചെറിയതുമാണ്; എങ്കിൽ എന്റെ ജീവൻ രക്ഷപ്പെടും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","അവിടന്നു ലോത്തിനോട്, “വളരെ നന്ന്, ഈ അപേക്ഷയും ഞാൻ അനുവദിച്ചുതരും, നീ പറയുന്ന പട്ടണം ഞാൻ നശിപ്പിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","എന്നാൽ, പെട്ടെന്ന് അവിടേക്ക് ഓടുക, നീ അവിടെ എത്തുന്നതുവരെ എനിക്കൊന്നും ചെയ്യാൻ നിർവാഹമില്ല” എന്നു പറഞ്ഞു. അതുകൊണ്ട് ആ പട്ടണത്തിനു സോവാർ എന്നു പേരായി. ");
INSERT INTO malc_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ലോത്ത് സോവാരിൽ എത്തിയപ്പോഴേക്കും സൂര്യൻ ഉദിച്ചുകഴിഞ്ഞിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","അപ്പോൾ യഹോവ സൊദോമിന്റെയും ഗൊമോറായുടെയുംമേൽ ആകാശത്തുനിന്ന്—യഹോവയുടെ സന്നിധിയിൽനിന്നുതന്നെ—ആളിക്കത്തുന്ന ഗന്ധകം വർഷിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ഇപ്രകാരം അവിടന്ന് ആ സമഭൂമിയെ നിശ്ശേഷമായി—ആ നഗരങ്ങളെയും അവയിൽ താമസിച്ചിരുന്ന സകലരെയും ദേശത്തെ സസ്യാദികളെയും നശിപ്പിച്ചുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","എന്നാൽ, ലോത്തിന്റെ ഭാര്യ അവന്റെ പിറകെ ഓടുന്നതിനിടയിൽ പിറകോട്ടു നോക്കി, അവൾ ഉപ്പുതൂണായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","പിറ്റേന്ന് അതിരാവിലെ അബ്രാഹാം എഴുന്നേറ്റ്, താൻ യഹോവയുടെ സന്നിധിയിൽ നിന്നിരുന്ന സ്ഥലത്തു ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","അദ്ദേഹം സൊദോമിനും ഗൊമോറായ്ക്കും സമഭൂമിയിലെ സകലപ്രദേശങ്ങൾക്കും നേരേ നോക്കി, തീച്ചൂളയിൽനിന്നെന്നപോലെ ആ ദേശത്തുനിന്നു പുക ഉയരുന്നതു കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ഇങ്ങനെ ദൈവം സമഭൂമിയിലെ നഗരങ്ങളെ നശിപ്പിച്ചപ്പോൾ, അബ്രാഹാമിനെ ഓർത്തു. ലോത്തു ജീവിച്ചിരുന്ന നഗരങ്ങളെ നശിപ്പിച്ചപ്പോൾ അവിടന്ന് ആ മഹാവിപത്തിൽനിന്നും ലോത്തിനെ രക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ലോത്തും അദ്ദേഹത്തിന്റെ രണ്ടു പുത്രിമാരും സോവാർ വിട്ട് പർവതത്തിൽച്ചെന്നു താമസം ഉറപ്പിച്ചു; സോവാരിൽ താമസിക്കാൻ അയാൾക്കു ഭയമായിരുന്നു. ലോത്തും രണ്ടു പുത്രിമാരും ഒരു ഗുഹയിൽ താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ഒരു ദിവസം, മൂത്തമകൾ ഇളയവളോട്, “നമ്മുടെ അപ്പൻ വൃദ്ധനാണ്, നാട്ടുനടപ്പനുസരിച്ച് നമ്മുടെ അടുക്കൽ വരാൻ ദേശത്തെങ്ങും ഒരു പുരുഷനുമില്ല. ");
INSERT INTO malc_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","അതിനാൽ വരിക. നമുക്ക് അപ്പനെ വീഞ്ഞുകുടിപ്പിച്ച് അദ്ദേഹത്തോടൊപ്പം കിടക്കപങ്കിടാം, അങ്ങനെ പിതാവിന്റെ വംശപരമ്പര നിലനിർത്താം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","അന്നുരാത്രി അവർ അപ്പനെ വീഞ്ഞുകുടിപ്പിച്ചു. മൂത്തമകൾ അകത്തുചെന്ന് അയാളോടുകൂടെ കിടക്കപങ്കിട്ടു. അവൾ വന്നു കിടന്നതോ എഴുന്നേറ്റുപോയതോ അയാൾ അറിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","അടുത്തദിവസം മൂത്തമകൾ ഇളയവളോട്: “കഴിഞ്ഞരാത്രി ഞാൻ അപ്പന്റെകൂടെ കിടന്നു; ഈ രാത്രിയും നമുക്ക് അദ്ദേഹത്തെ വീഞ്ഞുകുടിപ്പിക്കാം, പിന്നെ നീ ചെന്ന് അദ്ദേഹത്തോടുകൂടെ കിടക്കുക, അങ്ങനെ നമുക്ക് അപ്പനിലൂടെ വംശപരമ്പര നിലനിർത്താം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","അങ്ങനെ അവർ ആ രാത്രിയിലും അപ്പനെ വീഞ്ഞു കുടിപ്പിച്ചിട്ട് ഇളയവൾ ചെന്ന് അയാളുടെകൂടെ കിടന്നു. അവൾ വന്നു കിടന്നതോ എഴുന്നേറ്റുപോയതോ അയാൾ അറിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ലോത്തിന്റെ പുത്രിമാർ ഇരുവരും ഈ വിധത്തിൽ തങ്ങളുടെ പിതാവിനാൽ ഗർഭവതികളായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","മൂത്തമകൾക്ക് ഒരു മകൻ ജനിച്ചു; അവൾ അവന് മോവാബ് എന്നു പേരിട്ടു. അവനത്രേ ഇന്നത്തെ മോവാബ്യരുടെ പിതാവ്. ");
INSERT INTO malc_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ഇളയമകൾക്കും ഒരു മകൻ ഉണ്ടായി. അവൾ അവന് ബെൻ-അമ്മീ എന്നു പേരിട്ടു; അവൻ ഇന്നുള്ള അമ്മോന്യരുടെ പിതാവ്. ");
INSERT INTO malc_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","പിന്നെ അബ്രാഹാം തെക്കേ ദേശത്തേക്കു പോയി; അവിടെ കാദേശിനും ശൂരിനും മധ്യേ താമസിച്ചു. ഇതിനുശേഷം അദ്ദേഹം ഗെരാരിലേക്കുപോയി, അവിടെ പ്രവാസിയായി താമസിക്കുമ്പോൾ ");
INSERT INTO malc_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","അബ്രാഹാം തന്റെ ഭാര്യയായ സാറായെക്കുറിച്ച്; “അവൾ എന്റെ സഹോദരി” എന്നു പ്രസ്താവിച്ചു. അപ്പോൾ ഗെരാർരാജാവായ അബീമെലെക്ക് ആളയച്ച് സാറയെ കൂട്ടിക്കൊണ്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","എന്നാൽ, ഒരു രാത്രിയിൽ ദൈവം സ്വപ്നത്തിൽ അബീമെലെക്കിന്റെ അടുക്കൽവന്ന് അവനോട്: “നീ സ്വന്തമാക്കിയിരിക്കുന്ന സ്ത്രീനിമിത്തം നീ മരിക്കും; അവൾ വിവാഹിതയാണ്” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","അബീമെലെക്ക് അവളുടെ അടുക്കൽ ചെന്നിരുന്നില്ല. അദ്ദേഹം ദൈവത്തോട്; “കർത്താവേ, അവിടന്ന് കുറ്റം ചെയ്യാത്ത ഒരു ജനതയെ നശിപ്പിക്കുമോ? ");
INSERT INTO malc_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‘അവൾ എന്റെ സഹോദരി’ എന്ന് അയാൾ എന്നോടു പറഞ്ഞില്ലയോ? ‘അയാൾ എന്റെ സഹോദരൻ’ എന്ന് അവളും പറഞ്ഞിരുന്നല്ലോ! ശുദ്ധമനസ്സാക്ഷിയോടും നിർമലമായ കൈകളോടുംകൂടി ഞാൻ ഇതു ചെയ്തിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","അപ്പോൾ ദൈവം സ്വപ്നത്തിൽ അദ്ദേഹത്തോട്: “നീ ശുദ്ധമനസ്സാക്ഷിയോടെ ഇതു ചെയ്തു എന്നു ഞാൻ അറിയുന്നു, അതുകൊണ്ടാണ് എനിക്കെതിരേ പാപംചെയ്യാതിരിക്കാൻ ഞാൻ നിന്നെ തടഞ്ഞത്; അവളെ തൊടാൻ ഞാൻ നിന്നെ അനുവദിക്കാതിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","നീ ഇപ്പോൾ ആ മനുഷ്യന് അവന്റെ ഭാര്യയെ തിരിച്ചുകൊടുക്കുക; അവൻ ഒരു പ്രവാചകനാണ്; അവൻ നിനക്കുവേണ്ടി പ്രാർഥിക്കും; അങ്ങനെ നീ ജീവിച്ചിരിക്കുകയും ചെയ്യും. അവളെ തിരികെക്കൊടുക്കാതിരുന്നാലോ, നീയും നിനക്കുള്ള സകലരും മരിക്കുമെന്ന് നിശ്ചയമായും അറിഞ്ഞുകൊള്ളുക” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","പിറ്റേന്ന് അതിരാവിലെ അബീമെലെക്ക് തന്റെ എല്ലാ ഉദ്യോഗസ്ഥന്മാരെയും വിളിച്ചുകൂട്ടി, സംഭവിച്ചതെല്ലാം അവരെ പറഞ്ഞുകേൾപ്പിച്ചു; അവർ ഭയന്നുവിറച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","പിന്നെ അബീമെലെക്ക് അബ്രാഹാമിനെ അകത്തേക്കു വിളിച്ച്, “നീ ഞങ്ങളോട് ഈ ചെയ്തത് എന്താണ്? നീ എന്റെയും എന്റെ രാജ്യത്തിന്റെയുംമേൽ ഇത്രവലിയ അപരാധം വരുത്താൻ ഞാൻ നിന്നോട് എന്തു ദോഷം ചെയ്തു? ചെയ്യരുതാത്ത കാര്യങ്ങളത്രേ നീ എന്നോടു ചെയ്തിരിക്കുന്നത്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","“ഇങ്ങനെ പ്രവർത്തിക്കാനുള്ള കാരണം എന്താണ്?” എന്ന് അബീമെലെക്ക് അബ്രാഹാമിനോട് ആരാഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","അതിന് അബ്രാഹാം ഇങ്ങനെ മറുപടി പറഞ്ഞു: “ ‘ഈ സ്ഥലത്തു നിശ്ചയമായും ദൈവഭയം തീരെയില്ല എന്നും എന്റെ ഭാര്യ നിമിത്തം അവർ എന്നെ കൊല്ലുമെന്നും’ ഞാൻ വിചാരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","തന്നെയുമല്ല, അവൾ വാസ്തവത്തിൽ എന്റെ സഹോദരിയാണ്; ഞങ്ങൾ രണ്ടുപേരുടെയും പിതാവ് ഒന്നാണ്, എന്നാൽ ഒരമ്മയിൽനിന്നു ജനിച്ചവരുമല്ല; അവൾ എന്റെ ഭാര്യയായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","എന്നാൽ, എന്റെ പിതൃഭവനം വിട്ടു ദേശാടനം ചെയ്യാൻ ദൈവം എന്നോട് കൽപ്പിച്ചപ്പോൾ, ഞാൻ അവളോട്: ‘നാം ചെല്ലുന്നേടത്തെല്ലാം “അദ്ദേഹം എന്റെ സഹോദരൻ” എന്നു നീ പറയണം, അങ്ങനെയാണു നിനക്ക് എന്നോടുള്ള സ്നേഹം വെളിപ്പെടുത്തേണ്ടത്’ എന്നു പറഞ്ഞിരുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","പിന്നെ അബീമെലെക്ക് ആടുമാടുകളെയും ദാസീദാസന്മാരെയും കൊണ്ടുവന്ന് അബ്രാഹാമിനു കൊടുത്തു; അദ്ദേഹത്തിന്റെ ഭാര്യയായ സാറയെയും തിരികെ ഏൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","അബീമെലെക്ക് അബ്രാഹാമിനോട്, “എന്റെ ദേശം നിന്റെ മുമ്പാകെ ഇരിക്കുന്നു; നിനക്ക് ഇഷ്ടമുള്ളേടത്തു താമസിച്ചുകൊൾക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","പിന്നെ അദ്ദേഹം സാറായോട്, “ഞാൻ നിന്റെ സഹോദരന് ആയിരം ശേക്കേൽ വെള്ളി കൊടുക്കുന്നു, ഇതു ഞാൻ നിന്നോടുചെയ്ത കുറ്റത്തിനു നഷ്ടപരിഹാരമായി നിന്നോടുകൂടെയുള്ളവരെ സാക്ഷിയാക്കി നൽകുന്നതാണ്; നീ തികച്ചും കുറ്റവിമുക്തനാക്കപ്പെട്ടിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","അപ്പോൾ അബ്രാഹാം ദൈവത്തോടു പ്രാർഥിച്ചു; ദൈവം അബീമെലെക്കിനെയും അദ്ദേഹത്തിന്റെ ഭാര്യയെയും വെപ്പാട്ടിമാരെയും സൗഖ്യമാക്കി. അവർക്കു കുട്ടികൾ ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","അബ്രാഹാമിന്റെ ഭാര്യയായ സാറനിമിത്തം യഹോവ അബീമെലെക്കിന്റെ ഭവനത്തിൽ എല്ലാ സ്ത്രീകളുടെയും ഗർഭം അടച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ഇതിനുശേഷം യഹോവ, അവിടന്ന് അരുളിച്ചെയ്തിരുന്നതുപോലെ സാറയെ സന്ദർശിച്ചു; അവൾക്ക് അവിടന്നു നൽകിയിരുന്ന വാഗ്ദാനം നിറവേറ്റി. ");
INSERT INTO malc_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","അബ്രാഹാമിന്, വാർധക്യത്തിൽ, ദൈവം വാഗ്ദാനംചെയ്തിരുന്ന സമയത്തുതന്നെ, സാറാ ഗർഭിണിയായി ഒരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","അബ്രാഹാം, സാറാ തനിക്കു പ്രസവിച്ച മകന് യിസ്ഹാക്ക് എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ദൈവം തന്നോടു കൽപ്പിച്ചിരുന്നതുപോലെ അബ്രാഹാം, തന്റെ മകനായ യിസ്ഹാക്കിനെ എട്ടാംദിവസം പരിച്ഛേദനം ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","അബ്രാഹാമിനു നൂറു വയസ്സായപ്പോഴാണ് അദ്ദേഹത്തിന്റെ മകനായ യിസ്ഹാക്കു ജനിക്കുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","സാറ പറഞ്ഞു: “ദൈവം എനിക്കു ചിരിക്കാൻ വകയുണ്ടാക്കിയിരിക്കുന്നു. ഇതെക്കുറിച്ചു കേൾക്കുന്നവരെല്ലാവരും എന്നോടൊപ്പം ചിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","സാറ കുഞ്ഞുങ്ങളെ മുലയൂട്ടുമെന്ന് ആരെങ്കിലും അബ്രാഹാമിനോടു പറയുമായിരുന്നോ? എന്നിട്ടും അദ്ദേഹത്തിന്റെ വാർധക്യത്തിൽ ഞാൻ അദ്ദേഹത്തിന് ഒരു മകനെ പ്രസവിച്ചിരിക്കുന്നു” എന്ന് അവൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","പൈതൽ വളർന്നു, മുലകുടി മാറ്റാനുള്ള സമയവും അടുത്തു; യിസ്ഹാക്കിന്റെ മുലകുടിമാറ്റിയ ദിവസം അബ്രാഹാം വലിയൊരു വിരുന്നു നടത്തി. ");
INSERT INTO malc_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ഈജിപ്റ്റുകാരിയായ ഹാഗാറിൽ അബ്രാഹാമിനു ജനിച്ച മകൻ, തന്റെ മകനായ യിസ്ഹാക്കിനെ പരിഹസിക്കുന്നതായി സാറാ കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","അവൾ അബ്രാഹാമിനോട്, “ആ ദാസിയുടെ മകൻ എന്റെ മകൻ യിസ്ഹാക്കുമായി ഒരിക്കലും ഓഹരി പങ്കിടാതിരിക്കേണ്ടതിന് ആ ദാസിയെയും അവളുടെ മകനെയും പുറത്താക്കിക്കളയണം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","യിശ്മായേൽ തന്റെ മകൻ ആയതുകൊണ്ട്, ഈ കാര്യം അബ്രാഹാമിനെ വളരെയധികം അസ്വസ്ഥനാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","എന്നാൽ ദൈവം അബ്രാഹാമിനോടു പറഞ്ഞു, “ബാലനെയും ദാസിയെയും സംബന്ധിച്ച് വ്യാകുലപ്പെടരുത്. സാറ നിന്നോടു പറയുന്നതെന്തും ശ്രദ്ധയോടെ കേൾക്കുക. കാരണം, ‘യിസ്ഹാക്കിൽനിന്നു ജനിക്കുന്നവൻ നിന്റെ സന്തതി എന്നു വിളിക്കപ്പെടും.’ ");
INSERT INTO malc_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ദാസിയുടെ മകനെയും ഞാൻ ഒരു ജനതയാക്കിത്തീർക്കും; കാരണം അവൻ ഉത്ഭവിച്ചതും നിന്നിൽനിന്നാണല്ലോ.” ");
INSERT INTO malc_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","പിറ്റേദിവസം അതിരാവിലെ അബ്രാഹാം എഴുന്നേറ്റ്, കുറെ ഭക്ഷണവും ഒരു തുകൽക്കുടം നിറയെ വെള്ളവും എടുത്തു ഹാഗാറിനു കൊടുത്തു. അദ്ദേഹം അത് അവളുടെ തോളിൽ വെച്ചുകൊടുത്തിട്ട് അവളെയും കുട്ടിയെയും പറഞ്ഞയച്ചു. അവൾ യാത്രചെയ്ത് ബേർ-ശേബാ മരുഭൂമിയിലെത്തി അലഞ്ഞുനടന്നു. ");
INSERT INTO malc_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","കുടത്തിലെ വെള്ളം തീർന്നപ്പോൾ അവൾ ബാലനെ ഒരു കുറ്റിച്ചെടിയുടെ ചുവട്ടിലാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","പിന്നെ അവൾ പോയി, ഏകദേശം ഒരു അമ്പിൻപാട് അകലെ ഇരുന്നു. “ബാലൻ മരിക്കുന്നത് എനിക്കു കാണാൻ വയ്യ” എന്നു പറഞ്ഞുകൊണ്ട് അവനെതിരേ ഇരുന്ന് ഉറക്കെ കരഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ദൈവം കുട്ടിയുടെ കരച്ചിൽ കേട്ടു; ദൈവദൂതൻ ആകാശത്തുനിന്ന് ഹാഗാറിനെ വിളിച്ച് അവളോട്, “ഹാഗാറേ, നിനക്കെന്തുപറ്റി? ഭയപ്പെടേണ്ട, ബാലൻ കിടക്കുന്നിടത്തുനിന്നുള്ള അവന്റെ നിലവിളി ദൈവം കേട്ടിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","നീ ചെന്ന് ബാലനെ താങ്ങി എഴുന്നേൽപ്പിച്ചുകൊൾക; ഞാൻ അവനെ വലിയൊരു ജനതയാക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","പിന്നെ ദൈവം അവളുടെ കണ്ണ് തുറന്നു; അവളൊരു നീരുറവ കണ്ടു. അവൾ ചെന്നു കുടത്തിൽ വെള്ളം നിറച്ചുകൊണ്ടുവന്നു ബാലനു കുടിക്കാൻ കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ബാലന്റെ വളർച്ചയിൽ ദൈവം അവനോടുകൂടെ ഉണ്ടായിരുന്നു. അവൻ മരുഭൂമിയിൽ താമസിച്ചു മുതിർന്നപ്പോൾ ഒരു വില്ലാളിയായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","പാരാൻ മരുഭൂമിയിൽ താമസിച്ചിരുന്നകാലത്ത് അവന്റെ അമ്മ ഈജിപ്റ്റിൽനിന്ന് അവന് ഒരു ഭാര്യയെ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ആ കാലത്ത് അബീമെലെക്കും അയാളുടെ സൈന്യാധിപനായ ഫിക്കോലും അബ്രാഹാമിനോട്, “നീ ചെയ്യുന്ന എല്ലാ കാര്യങ്ങളിലും ദൈവം നിന്നോടുകൂടെയുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","നീ എന്നോടോ എന്റെ മക്കളോടോ എന്റെ പിൻഗാമികളോടോ വ്യാജം പ്രവർത്തിക്കുകയില്ലെന്ന് ഇപ്പോൾ ഇവിടെ ദൈവമുമ്പാകെ എന്നോടു ശപഥംചെയ്യണം. ഞാൻ നിന്നോടു കരുണ കാണിച്ചതുപോലെതന്നെ നീ എന്നോടും നീ പ്രവാസിയായി വന്നുപാർക്കുന്ന ഈ ദേശത്തോടും കരുണ കാണിക്കുകയും വേണം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","അതിന് അബ്രാഹാം, “ഞാൻ അങ്ങനെതന്നെ ശപഥംചെയ്യുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","പിന്നെ അബ്രാഹാം അബീമെലെക്കിനോട്, അങ്ങയുടെ വേലക്കാർ എന്റെ വേലക്കാരിൽനിന്നും ഒരു കിണർ കൈവശപ്പെടുത്തിയതായി പരാതിപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","അതിന് അബീമെലെക്ക്, “ആരാണ് ഇതു ചെയ്തതെന്ന് എനിക്ക് അറിഞ്ഞുകൂടാ. താങ്കൾ എന്നോടു പറഞ്ഞില്ലല്ലോ, ഇന്നാണു ഞാൻ ഇതിനെക്കുറിച്ചു കേൾക്കുന്നത്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","പിന്നെ അബ്രാഹാം ആടുമാടുകളെ കൊണ്ടുവന്ന് അബീമെലെക്കിനു കൊടുത്തു. അവർ ഇരുവരും ഒരു കരാറിലേർപ്പെടുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","അബ്രാഹാം ആട്ടിൻപറ്റത്തിൽനിന്ന് ഏഴു പെണ്ണാട്ടിൻകുട്ടികളെ വേർതിരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","അബീമെലെക്ക് അബ്രാഹാമിനോട്, “ഈ ഏഴ് പെണ്ണാട്ടിൻകുട്ടികളെ വേർതിരിച്ചതുകൊണ്ടു നീ എന്താണ് ഉദ്ദേശിക്കുന്നത്” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","“ഈ കിണർ ഞാനാണു കുഴിപ്പിച്ചത് എന്നതിനു സാക്ഷിയായി ഈ ഏഴു പെണ്ണാട്ടിൻകുട്ടികളെ എന്റെ കൈയിൽനിന്ന് വാങ്ങണം” അബ്രാഹാം മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ആ സ്ഥലത്തുവെച്ച് അങ്ങനെ അവർ ഇരുവരും ശപഥംചെയ്തതുകൊണ്ട് അതിന് ബേർ-ശേബാ എന്നു പേരുണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ബേർ-ശേബയിൽവെച്ചു സഖ്യം ചെയ്തതിനുശേഷം അബീമെലെക്കും അദ്ദേഹത്തിന്റെ സൈന്യാധിപനായ ഫിക്കോലും ഫെലിസ്ത്യരുടെ ദേശത്തേക്കു മടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","അബ്രാഹാം ബേർ-ശേബയിൽ ഒരു പിചുലവൃക്ഷം നട്ടു; അവിടെവെച്ച് അദ്ദേഹം നിത്യദൈവമായ യഹോവയുടെ നാമത്തിൽ ആരാധന നടത്തി. ");
INSERT INTO malc_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","അബ്രാഹാം ഫെലിസ്ത്യരുടെ ദേശത്ത് കുറെക്കാലം പ്രവാസിയായി താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","കുറെക്കാലം കഴിഞ്ഞു ദൈവം അബ്രാഹാമിനെ പരീക്ഷിച്ചു. അവിടന്ന് അദ്ദേഹത്തെ, “അബ്രാഹാമേ” എന്നു വിളിച്ചു. “ഞാൻ ഇതാ” അദ്ദേഹം ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","അപ്പോൾ ദൈവം “നിന്റെ മകനെ, നീ സ്നേഹിക്കുന്ന, നിന്റെ ഏകപുത്രനായ യിസ്ഹാക്കിനെ കൂട്ടിക്കൊണ്ട് മോരിയാദേശത്തേക്കു പോകുക. അവിടെ ഞാൻ നിന്നോടു കൽപ്പിക്കുന്ന മലയിൽ അവനെ ഹോമയാഗമായി അർപ്പിക്കുക” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","അബ്രാഹാം പിറ്റേന്ന് അതിരാവിലെ എഴുന്നേറ്റ് കഴുതയ്ക്കു കോപ്പിട്ടു. ദാസന്മാരിൽ രണ്ടുപേരെയും തന്റെ മകനായ യിസ്ഹാക്കിനെയുംകൂട്ടി ഹോമയാഗത്തിനുവേണ്ട വിറകും കീറിയെടുത്ത്, ദൈവം തന്നോടു നിർദേശിച്ച സ്ഥലത്തേക്കു യാത്രയായി. ");
INSERT INTO malc_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","മൂന്നാംദിവസം അബ്രാഹാം തലയുയർത്തിനോക്കിയപ്പോൾ ആ സ്ഥലം ദൂരെയായി കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","അദ്ദേഹം വേലക്കാരോട്: “ഞാനും ബാലനും ആ സ്ഥലത്തുചെന്ന് ആരാധന നടത്തി തിരിച്ചെത്തുന്നതുവരെ നിങ്ങൾ കഴുതയുമായി ഇവിടെ താമസിക്കുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","അബ്രാഹാം ഹോമയാഗത്തിനുള്ള വിറക് എടുത്ത് തന്റെ മകനായ യിസ്ഹാക്കിന്റെ ചുമലിൽവെച്ചു; താൻതന്നെ തീയും കത്തിയും എടുത്തു. ഇരുവരും ഒരുമിച്ചു നടന്നു. ");
INSERT INTO malc_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","യിസ്ഹാക്ക് തന്റെ പിതാവായ അബ്രാഹാമിനെ “അപ്പാ” എന്നു വിളിച്ചു. “എന്താകുന്നു, മകനേ,” അബ്രാഹാം ചോദിച്ചു. “തീയും വിറകും ഉണ്ട്; എന്നാൽ ഹോമയാഗത്തിനുള്ള ആട്ടിൻകുട്ടി എവിടെ?” യിസ്ഹാക്ക് ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","അതിന് അബ്രാഹാം: “ഹോമയാഗത്തിനുള്ള ആട്ടിൻകുട്ടിയെ ദൈവംതന്നെ കരുതും, മകനേ” എന്ന് ഉത്തരം പറഞ്ഞു. ഇരുവരും ഒരുമിച്ചു മുന്നോട്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ദൈവം നിർദേശിച്ച സ്ഥലത്തെത്തിയപ്പോൾ അബ്രാഹാം അവിടെ ഒരു യാഗപീഠം ഉണ്ടാക്കി; അതിന്മേൽ വിറകടുക്കി. തന്റെ മകനായ യിസ്ഹാക്കിനെ കെട്ടി യാഗപീഠത്തിന്മേൽ വിറകിനുമീതേ കിടത്തി. ");
INSERT INTO malc_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","പിന്നെ അബ്രാഹാം കൈനീട്ടി തന്റെ മകനെ അറക്കാൻ കത്തിയെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","എന്നാൽ യഹോവയുടെ ദൂതൻ ആകാശത്തുനിന്ന്, “അബ്രാഹാമേ, അബ്രാഹാമേ,” എന്നു വിളിച്ചു. “ഞാൻ ഇതാ.” അദ്ദേഹം വിളികേട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ദൂതൻ അരുളിച്ചെയ്തു: “ബാലന്റെമേൽ കൈവെക്കരുത്. അവന് ഒരു ദോഷവും ചെയ്യരുത്. നിന്റെ മകനെ, നിനക്കുള്ള ഒരേയൊരു മകനെ എനിക്കു തരാൻ മടിക്കാതിരുന്നതുകൊണ്ടു, നീ ദൈവത്തെ ഭയപ്പെടുന്നു എന്നു ഞാൻ ഇപ്പോൾ അറിയുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","അബ്രാഹാം തലയുയർത്തിനോക്കി; തന്റെ പിന്നിൽ കൊമ്പ് കുറ്റിക്കാട്ടിൽ ഉടക്കിക്കിടക്കുന്ന ഒരു ആട്ടുകൊറ്റനെ കണ്ടു. അബ്രാഹാം ചെന്ന് ആട്ടുകൊറ്റനെ എടുത്ത്, തന്റെ പുത്രനു പകരം ഹോമയാഗം അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","അബ്രാഹാം ആ സ്ഥലത്തിന് “യഹോവയിരേ” എന്നു പേരിട്ടു. ജനം “യഹോവയുടെ പർവതത്തിൽ അവിടന്ന് കരുതിക്കൊള്ളും” എന്നത് ഒരു പഴഞ്ചൊല്ലായി ഇന്നുവരെയും പറഞ്ഞുപോരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","യഹോവയുടെ ദൂതൻ ആകാശത്തുനിന്ന് അബ്രാഹാമിനെ രണ്ടാമതും വിളിച്ച്, ഇപ്രകാരം അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“നീ ഇക്കാര്യം ചെയ്യുകയും നിന്റെ പുത്രനെ, നിന്റെ ഒരേയൊരു പുത്രനെത്തന്നെ, തരാൻ മടിക്കാതിരിക്കുകയും ചെയ്തതുകൊണ്ട്, ");
INSERT INTO malc_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ഞാൻ നിശ്ചയമായും നിന്നെ അത്യന്തം അനുഗ്രഹിക്കും. നിന്റെ സന്തതിപരമ്പരകളെ ആകാശത്തിലെ നക്ഷത്രങ്ങൾപോലെയും കടൽക്കരയിലെ മണൽപോലെയും അസംഖ്യമാക്കിത്തീർക്കും; നിന്റെ സന്തതി അവരുടെ ശത്രുക്കളുടെ നഗരങ്ങൾ കൈവശമാക്കും; ");
INSERT INTO malc_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","നീ എന്നെ അനുസരിച്ചതുകൊണ്ട് നിന്റെ സന്തതിയിലൂടെ ഭൂമിയിലെ സകലരാഷ്ട്രങ്ങളും അനുഗ്രഹിക്കപ്പെടും എന്നു ഞാൻ എന്നെക്കൊണ്ടുതന്നെ ശപഥം ചെയ്യുന്നെന്ന് യഹോവ അരുളിച്ചെയ്യുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ഇതിനുശേഷം അബ്രാഹാം തന്റെ ദാസന്മാരുടെ അടുക്കൽ തിരിച്ചെത്തി; അവർ എല്ലാവരും ബേർ-ശേബയിലേക്കു മടങ്ങി. അബ്രാഹാം ബേർ-ശേബയിൽ താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","“കുറച്ചുനാളുകൾക്കുശേഷം മിൽക്കാ, തന്റെ സഹോദരനായ നാഹോരിന്റെ ഭാര്യ മക്കളെ പ്രസവിച്ചിരിക്കുന്നു എന്നവിവരം അബ്രാഹാമിനു ലഭിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","അവർ: ആദ്യജാതനായ ഊസ്, അവന്റെ അനുജനായ ബൂസ്, കെമൂവേൽ (അരാമിന്റെ പിതാവ്), ");
INSERT INTO malc_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","കേശെദ്, ഹസോ, പിൽദാശ്, യിദലാഫ്, ബെഥൂവേൽ എന്നിവരാണ്.” ");
INSERT INTO malc_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ബെഥൂവേൽ റിബേക്കയുടെ പിതാവായിരുന്നു. അബ്രാഹാമിന്റെ സഹോദരനായ നാഹോരിന് മിൽക്കാ ഈ എട്ടുപുത്രന്മാരെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","രെയൂമാ എന്നു പേരുള്ള അവന്റെ വെപ്പാട്ടിക്കും പുത്രന്മാർ ജനിച്ചു; അവർ തേബഹ്, ഗഹാം, തഹശ്, മയഖാ എന്നിവരാണ്. ");
INSERT INTO malc_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","സാറ നൂറ്റിഇരുപത്തിയേഴു വയസ്സുവരെ ജീവിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","അവൾ കനാൻദേശത്തെ ഹെബ്രോൻ എന്ന കിര്യത്ത്-അർബയിൽവെച്ചു മരിച്ചു. അബ്രാഹാം സാറായെക്കുറിച്ചു വിലപിക്കാനും കരയാനും പോയി. ");
INSERT INTO malc_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","പിന്നെ അബ്രാഹാം ഭാര്യയുടെ മൃതദേഹത്തിന്റെ അടുക്കൽനിന്ന് എഴുന്നേറ്റ് ഹിത്യരോടു സംസാരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","അദ്ദേഹം അവരോട്: “ഞാൻ നിങ്ങളുടെ ഇടയിൽ അന്യനും പ്രവാസിയും ആകുന്നു. എന്റെ മരിച്ചവളെ അടക്കേണ്ടതിന് എനിക്കിവിടെ ശ്മശാനത്തിനുള്ള കുറെ സ്ഥലം വിലയ്ക്കു തരണം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ഹിത്യർ അബ്രാഹാമിനോട്, ");
INSERT INTO malc_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“പ്രഭോ, ഞങ്ങളുടെ വാക്കു ശ്രദ്ധിച്ചാലും. അങ്ങു ഞങ്ങളുടെ ഇടയിൽ ദൈവത്തിന്റെ ഒരു പ്രഭുവാണ്; ഞങ്ങളുടെ ഏറ്റവും നല്ല കല്ലറകളിൽ ഒന്നിൽ അങ്ങയുടെ മരിച്ചവളെ അടക്കംചെയ്യുക; മരിച്ചവളെ സംസ്കരിക്കാൻ ഞങ്ങളിൽ ആരും കല്ലറ തരാതിരിക്കുകയില്ല” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","അപ്പോൾ അബ്രാഹാം എഴുന്നേറ്റ്, ദേശവാസികളായ ഹിത്യരെ വണങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","അവരോടു പറഞ്ഞു: “എന്റെ മരിച്ചവളെ അടക്കാൻ നിങ്ങൾ എന്നെ അനുവദിക്കുന്നെങ്കിൽ, എന്റെ വാക്കുകേട്ട് എനിക്കുവേണ്ടി സോഹരിന്റെ മകനായ എഫ്രോനോട്, ");
INSERT INTO malc_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","അദ്ദേഹത്തിന്റെ വയലിന്റെ അരികിലുള്ളതും അദ്ദേഹത്തിന്റെ സ്വന്തവുമായ മക്പേലാ ഗുഹ എനിക്കു വിലയ്ക്കു തരേണമെന്നു പറയണം. നിങ്ങളുടെ ഇടയിൽ, എനിക്ക് സ്വന്തമായി ഒരു ശ്മശാനഭൂമി ലഭിക്കാൻ, അതിന്റെ മുഴുവൻ വിലയും വാങ്ങിക്കൊണ്ട് എനിക്കു തരണമെന്ന് അപേക്ഷിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ഹിത്യനായ എഫ്രോൻ സ്വജനങ്ങൾക്കിടയിൽ ഇരിക്കുകയായിരുന്നു. അദ്ദേഹം തന്റെ നഗരത്തിന്റെ കവാടത്തിൽ എത്തിയിരുന്ന സകലഹിത്യരും കേൾക്കെ അബ്രാഹാമിനോട്: ");
INSERT INTO malc_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“പ്രഭോ, അങ്ങനെയല്ല, എന്റെ വാക്കു കേട്ടാലും; ഞാൻ ആ പുരയിടം അങ്ങേക്കു തരുന്നു; അതിലുള്ള ഗുഹയും തരുന്നു. എന്റെ ജനങ്ങളുടെ മുന്നിൽവെച്ചു ഞാൻ അത് അങ്ങേക്കു തരികയാണ്. താങ്കളുടെ മരിച്ചവളെ അടക്കിക്കൊള്ളുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","അബ്രാഹാം വീണ്ടും ആ ദേശവാസികളെ വണങ്ങിയിട്ട് ");
INSERT INTO malc_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","അവർ കേൾക്കെ എഫ്രോനോട്, “ദയവുചെയ്ത് എന്റെ വാക്കു ശ്രദ്ധിക്കുക, ഞാൻ വയലിന്റെ വില തീർത്തുതരും. അത് എന്റെ പക്കൽനിന്ന് സ്വീകരിക്കണം; അപ്പോൾ എനിക്ക് എന്റെ മരിച്ചവളെ അവിടെ അടക്കുകയും ചെയ്യാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","എഫ്രോൻ അബ്രാഹാമിനോട്: ");
INSERT INTO malc_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“പ്രഭോ, ഞാൻ പറയുന്നതു ശ്രദ്ധിച്ചാലും; ആ സ്ഥലത്തിനു നാനൂറു ശേക്കേൽ വെള്ളി വിലയുണ്ട്, എന്നാൽ എനിക്കും താങ്കൾക്കും മധ്യേ അതെന്തുള്ളൂ? അങ്ങയുടെ മരിച്ചവളെ അടക്കിക്കൊണ്ടാലും” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","എഫ്രോന്റെ നിർദേശങ്ങൾ അബ്രാഹാം അംഗീകരിച്ചു. ഹിത്യർ കേൾക്കെ എഫ്രോൻ പറഞ്ഞ വിലയായ നാനൂറു ശേക്കേൽ വെള്ളി—കച്ചവടക്കാരുടെ ഇടയിൽ നിലവിലുള്ള തൂക്കം അനുസരിച്ച്—അബ്രാഹാം അദ്ദേഹത്തിനു തൂക്കിക്കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","അങ്ങനെ മമ്രേക്കടുത്തു മക്പേലയിൽ സ്ഥിതിചെയ്യുന്ന എഫ്രോന്റെ പുരയിടം—പുരയിടവും അതിലുള്ള ഗുഹയും പുരയിടത്തിന്റെ അതിരിനകത്തുള്ള സകലവൃക്ഷങ്ങളും— ");
INSERT INTO malc_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","നഗരകവാടത്തിൽ എത്തിയിരുന്ന എല്ലാ ഹിത്യരുടെയും മുമ്പാകെ, നിയമപ്രകാരം അബ്രാഹാമിന് അവകാശപ്പെട്ട സ്വത്തായി നൽകപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","അതിനുശേഷം അബ്രാഹാം തന്റെ ഭാര്യയായ സാറയെ, കനാൻദേശത്ത് ഹെബ്രോനിലെ മമ്രേയ്ക്കു സമീപം മക്പേലായിലുള്ള ഗുഹയിൽ അടക്കംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ഇങ്ങനെ ഹിത്യർ ആ പുരയിടവും അതിലെ ഗുഹയും ഒരു ശ്മശാനസ്ഥലമെന്നനിലയിൽ, അബ്രാഹാമിനു നിയമപ്രകാരം കൈമാറ്റംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","അബ്രാഹാം വൃദ്ധനായി വളരെ പ്രായാധിക്യത്തിലെത്തി. യഹോവ അബ്രാഹാമിനെ എല്ലാറ്റിലും അനുഗ്രഹിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","അബ്രാഹാം തന്റെ വസ്തുവകകളുടെയെല്ലാം ചുമതല വഹിച്ചിരുന്ന ഏറ്റവും പ്രധാനിയായ ദാസനോട്: “നിന്റെ കൈ എന്റെ തുടയിൻകീഴിൽ വെക്കുക. ");
INSERT INTO malc_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ഞാൻ ഇപ്പോൾ കനാന്യരുടെ മധ്യേ പാർക്കുന്നു. നീ എന്റെ മകനു ഭാര്യയായി ഈ കനാന്യപുത്രിമാരിൽ ഒരുവളെ എടുക്കാതെ, ");
INSERT INTO malc_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","എന്റെ സ്വദേശത്ത്, സ്വജനങ്ങളുടെ അടുക്കൽ ചെന്ന് എന്റെ മകനായ യിസ്ഹാക്കിനു ഭാര്യയെ തെരഞ്ഞെടുക്കുമെന്ന് സ്വർഗത്തിനും ഭൂമിക്കും ദൈവമായ യഹോവയുടെ നാമത്തിൽ ശപഥംചെയ്യുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ദാസൻ അദ്ദേഹത്തോട്: “ആ സ്ത്രീക്ക് എന്നോടൊപ്പം ഈ ദേശത്തേക്കു വരുന്നതിനു സമ്മതമില്ലെങ്കിലോ? അപ്പോൾ ഞാൻ അങ്ങു വിട്ടുപോന്ന ദേശത്തേക്ക് അങ്ങയുടെ മകനെ കൂട്ടിക്കൊണ്ടുപോകണമോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","അതിന് അബ്രാഹാം മറുപടി പറഞ്ഞത്, “നീ എന്റെ പുത്രനെ ആ ദേശത്തേക്കു കൊണ്ടുപോകാൻ പാടില്ല. ");
INSERT INTO malc_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","എന്നെ എന്റെ പിതൃഭവനത്തിൽനിന്നും സ്വദേശത്തുനിന്നും കൂട്ടിക്കൊണ്ടുവരികയും എന്നോടു സംസാരിക്കുകയും ‘ഞാൻ ഈ ദേശം നിന്റെ സന്തതിക്കു തരും’ എന്ന് ആണയിട്ടു വാഗ്ദാനം നൽകുകയും ചെയ്ത, സ്വർഗത്തിന്റെ ദൈവമായ യഹോവ, അവിടത്തെ ദൂതനെ നിനക്കുമുമ്പായി അയയ്ക്കും; അങ്ങനെ അവിടെനിന്ന് എന്റെ മകനു ഭാര്യയെ എടുക്കാൻ നിനക്കു സാധിക്കുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","സ്ത്രീ നിന്നോടുകൂടെ ഇങ്ങോട്ടുവരുന്നതിനു വിസമ്മതിക്കുന്നെങ്കിൽ എന്നോടുള്ള ഈ ശപഥത്തിൽനിന്ന് നീ ഒഴിഞ്ഞിരിക്കും. എന്നാൽ എന്റെ മകനെ ഒരിക്കലും അവിടേക്കു കൊണ്ടുപോകരുത്.” ");
INSERT INTO malc_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ആ ദാസൻ തന്റെ കൈ യജമാനനായ അബ്രാഹാമിന്റെ തുടയിൻകീഴിൽ വെച്ച്, ഇക്കാര്യം സംബന്ധിച്ച് അദ്ദേഹത്തോടു ശപഥംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","പിന്നെ ആ ദാസൻ യജമാനന്റെ എല്ലാവിധ വിശിഷ്ടവസ്തുക്കളും ശേഖരിച്ച്, അദ്ദേഹത്തിന്റെ പത്ത് ഒട്ടകങ്ങളുമായി പുറപ്പെട്ടു. അബ്രാഹാമിന്റെ ദാസൻ അരാം-നെഹറയിമിലേക്കു യാത്രതിരിച്ച് നാഹോരിന്റെ പട്ടണത്തിൽ എത്തി. ");
INSERT INTO malc_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","പട്ടണത്തിനു പുറത്തുള്ള കിണറ്റിനരികെ അദ്ദേഹം ഒട്ടകങ്ങളെ നിർത്തി; അപ്പോൾ സ്ത്രീകൾ വെള്ളം കോരാൻ പുറത്തേക്കു പോകുന്ന സന്ധ്യയോടടുത്ത സമയമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","പിന്നെ അദ്ദേഹം പ്രാർഥിച്ചു: “എന്റെ യജമാനനായ അബ്രാഹാമിന്റെ ദൈവമായ യഹോവേ, എന്റെ യജമാനനായ അബ്രാഹാമിനോടു കരുണതോന്നി ഇന്ന് എനിക്കു വിജയം തരണമേ. ");
INSERT INTO malc_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ഇതാ, ഞാൻ ഇവിടെ ഈ കിണറ്റിനരികെ നിൽക്കുന്നു; പട്ടണവാസികളുടെ പുത്രിമാർ വെള്ളം കോരാൻ വരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ഞാൻ ഒരു പെൺകുട്ടിയോട്, ‘നിന്റെ കുടം ചരിച്ച് എനിക്കു കുടിക്കാൻ തരണം’ എന്നു പറയുമ്പോൾ അവൾ, ‘കുടിച്ചുകൊള്ളൂ, ഞാൻ നിങ്ങളുടെ ഒട്ടകങ്ങൾക്കും വെള്ളം തരാം’ എന്നു പറയുന്നെങ്കിൽ അവൾതന്നെ ആയിരിക്കട്ടെ അവിടത്തെ ദാസനായ യിസ്ഹാക്കിനുവേണ്ടി അവിടന്നു തെരഞ്ഞെടുത്തവൾ. എന്റെ യജമാനനോട് അങ്ങു കരുണ കാണിച്ചെന്ന് ഞാൻ ഇതിനാൽ ഗ്രഹിച്ചുകൊള്ളാം.” ");
INSERT INTO malc_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","അബ്രാഹാമിന്റെ ദാസൻ പ്രാർഥിച്ചുതീരുന്നതിനുമുമ്പ് റിബേക്കാ തോളിൽ കുടവുമായി വന്നു. അവൾ അബ്രാഹാമിന്റെ സഹോദരനായ നാഹോരിന്റെ ഭാര്യയായ മിൽക്കായുടെ മകനായ ബെഥൂവേലിന്റെ മകളായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ആ പെൺകുട്ടി അതീവസുന്ദരിയും കന്യകയും പുരുഷസ്പർശമേൽക്കാത്തവളും ആയിരുന്നു. അവൾ കിണറ്റിലേക്ക് ഇറങ്ങിച്ചെന്നു കുടം നിറച്ചു കയറിവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ആ ദാസൻ തിടുക്കത്തിൽ അവളുടെ അടുത്തേക്കുചെന്ന്, “ദയവായി നിന്റെ കുടത്തിൽനിന്ന്, കുറച്ചുവെള്ളം എനിക്കു കുടിക്കാൻ തരണം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“പ്രഭോ, കുടിച്ചാലും” എന്നു പറഞ്ഞുകൊണ്ട് അവൾ പെട്ടെന്ന് കുടം കൈകളിൽ താഴ്ത്തി അയാൾക്കു കുടിക്കാൻ കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","അദ്ദേഹത്തിനു കുടിക്കാൻ കൊടുത്തതിനുശേഷം അവൾ, “ഞാൻ അങ്ങയുടെ ഒട്ടകങ്ങൾക്കും കുടിക്കാൻ വെള്ളം വേണ്ടുവോളം കോരിക്കൊടുക്കാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","അവൾ കുടത്തിലെ വെള്ളം പെട്ടെന്നു തൊട്ടിയിലേക്ക് ഒഴിച്ചിട്ട് വെള്ളം കോരാൻ വീണ്ടും കിണറ്റിലേക്ക് ഓടിയിറങ്ങി; അദ്ദേഹത്തിന്റെ ഒട്ടകങ്ങൾക്കെല്ലാം വെള്ളം കോരിക്കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","യഹോവ, തന്റെ യാത്ര വിജയകരമാക്കിയോ എന്നു ഗ്രഹിക്കേണ്ടതിന് ആ ദാസൻ ഒന്നും ഉരിയാടാതെ, അവളെ സൂക്ഷ്മമായി ശ്രദ്ധിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ഒട്ടകങ്ങൾ വെള്ളം കുടിച്ചുകഴിഞ്ഞപ്പോൾ അയാൾ ഒരു ബെക്കാ തൂക്കമുള്ള ഒരു സ്വർണമൂക്കുത്തിയും പത്തുശേക്കേൽ തൂക്കമുള്ള രണ്ടു സ്വർണവളയും പുറത്തെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“നീ ആരുടെ മകളാണ്? ഞങ്ങൾക്കു രാപാർക്കാൻ നിന്റെ പിതാവിന്റെ ഭവനത്തിൽ ഇടമുണ്ടോ? എന്നോടു ദയവായി പറയുക” അയാൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","അവൾ അയാളോട്: “നാഹോരിനു മിൽക്കാ പ്രസവിച്ച മകനായ ബെഥൂവേലിന്റെ മകളാണു ഞാൻ” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","“ഞങ്ങളുടെ വീട്ടിൽ ധാരാളം വൈക്കോലും തീറ്റയും ഉണ്ട്, നിങ്ങൾക്കു രാത്രി കഴിച്ചുകൂട്ടാൻ ഇടവും ഉണ്ട്,” അവൾ കൂട്ടിച്ചേർത്തു. ");
INSERT INTO malc_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","അപ്പോൾ അയാൾ കുനിഞ്ഞ് യഹോവയെ നമസ്കരിച്ചുകൊണ്ട്, ");
INSERT INTO malc_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“എന്റെ യജമാനനായ അബ്രാഹാമിന്റെ ദൈവമായ യഹോവ വാഴ്ത്തപ്പെട്ടവൻ, എന്റെ യജമാനനോടുള്ള അവിടത്തെ ദയയും വിശ്വസ്തതയും അവിടന്ന് ഉപേക്ഷിച്ചിട്ടില്ല. യഹോവ എന്റെ യാത്രയിൽ എന്റെ യജമാനന്റെ സഹോദരന്മാരുടെ വീട്ടിലേക്ക് എന്നെ നയിച്ചല്ലോ!” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ആ പെൺകുട്ടി ഓടിച്ചെന്ന് തന്റെ അമ്മയുടെ ഭവനത്തിലുള്ളവരോട് ഈ കാര്യങ്ങൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","റിബേക്കയ്ക്ക് ലാബാൻ എന്നു പേരുള്ള ഒരു സഹോദരൻ ഉണ്ടായിരുന്നു. സഹോദരിയുടെ മൂക്കുത്തിയും കൈയിൽ വളയും കാണുകയും ആ മനുഷ്യൻ റിബേക്കയോടു പറഞ്ഞകാര്യം അവളിൽനിന്ന് കേൾക്കുകയും ചെയ്തനിമിഷംതന്നെ അവൻ തിടുക്കത്തിൽ നീരുറവയുടെ അടുക്കൽ നിന്നിരുന്ന ആ മനുഷ്യന്റെ അടുത്തേക്കുപോയി. അദ്ദേഹം, അവിടെ കിണറ്റിൻകരയിൽ ഒട്ടകങ്ങളുടെ അടുക്കൽ നിൽക്കുന്നതു കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“യഹോവയാൽ അനുഗ്രഹിക്കപ്പെട്ടവനേ, അകത്തുവരിക, എന്തിനു പുറത്തു നിൽക്കുന്നു? ഞാൻ ഭവനവും ഒട്ടകങ്ങൾക്കു സ്ഥലവും ഒരുക്കിയിരിക്കുന്നു,” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","അങ്ങനെ ആ മനുഷ്യൻ ഭവനത്തിലേക്കു ചെന്നു; ഒട്ടകങ്ങളുടെ ഭാരം ഇറക്കിവെച്ചു. അവയ്ക്കു വൈക്കോലും തീറ്റയും കൊണ്ടുവന്നു; അദ്ദേഹത്തിനും അദ്ദേഹത്തിന്റെ ആളുകൾക്കും കാൽകഴുകാൻ വെള്ളവും കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","അതിനുശേഷം അദ്ദേഹത്തിനു ഭക്ഷണം വിളമ്പി. എന്നാൽ, “നിങ്ങളോടു പറയാനുള്ളതു പറയുന്നതിനുമുമ്പ് ഞാൻ ആഹാരം കഴിക്കുകയില്ല” എന്ന് അദ്ദേഹം പറഞ്ഞു. “എങ്കിൽ ഞങ്ങളോടു പറയൂ” ലാബാൻ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","അപ്പോൾ അദ്ദേഹം പറഞ്ഞു: “ഞാൻ അബ്രാഹാമിന്റെ ദാസൻ. ");
INSERT INTO malc_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","എന്റെ യജമാനനെ യഹോവ സമൃദ്ധമായി അനുഗ്രഹിച്ചു. അദ്ദേഹം മഹാധനികനായിത്തീർന്നു. അവിടന്ന് അദ്ദേഹത്തിന് ആട്, മാട്, വെള്ളി, സ്വർണം, ദാസീദാസന്മാർ, ഒട്ടകങ്ങൾ, കഴുതകൾ എന്നിവയൊക്കെയും നൽകി. ");
INSERT INTO malc_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","എന്റെ യജമാനന്റെ ഭാര്യയായ സാറ വാർധക്യത്തിൽ അദ്ദേഹത്തിന് ഒരു മകനെ പ്രസവിച്ചു; തനിക്കുള്ള സകലസമ്പത്തും അദ്ദേഹം അവനു കൊടുത്തിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ഞാൻ കനാന്യരുടെ ദേശത്തു പാർക്കുന്നു, ‘എന്നാൽ നീ എന്റെ മകനു ഭാര്യയായി കനാന്യപുത്രിമാരിൽനിന്ന് ഒരുവളെ തെരഞ്ഞെടുക്കാതെ, ");
INSERT INTO malc_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","എന്റെ പിതാവിന്റെ കുടുംബത്തിലേക്കും സ്വന്തവംശത്തിലേക്കും ചെന്ന് എന്റെ മകന് ഒരു ഭാര്യയെ എടുക്കണം’ എന്ന് എന്റെ യജമാനൻ എന്നെക്കൊണ്ടു ശപഥംചെയ്യിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“അപ്പോൾ ഞാൻ യജമാനനോട്, ‘സ്ത്രീക്ക് എന്റെകൂടെ വരുന്നതിനു സമ്മതമല്ലെങ്കിലോ?’ എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“അതിന് അദ്ദേഹം മറുപടി പറഞ്ഞത്: ‘ഞാൻ യഹോവയുടെ സന്നിധിയിൽ വിശ്വസ്തതയോടെ ജീവിക്കുന്നു, അവിടന്നു തന്റെ ദൂതനെ നിന്റെകൂടെ അയച്ച് നിന്റെ യാത്ര സഫലമാക്കും; അങ്ങനെ എന്റെ സ്വന്തവംശത്തിൽനിന്നും എന്റെ പിതാവിന്റെ കുടുംബത്തിൽനിന്നും എന്റെ മകനുവേണ്ടി ഒരു ഭാര്യയെ എടുക്കാൻ നിനക്കു സാധിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","നീ എന്റെ വംശക്കാരുടെ അടുക്കൽ ചെന്നുകഴിയുമ്പോൾ എന്നോടുള്ള ശപഥത്തിൽനിന്ന് ഒഴിവുള്ളവനാകും; അവർ അവളെ നിന്റെ പക്കൽ ഏൽപ്പിക്കാൻ വിസമ്മതിക്കുന്നെങ്കിലും നീ എന്നോടുള്ള പ്രതിജ്ഞയിൽനിന്ന് ഒഴിവുള്ളവനായിരിക്കും.’ ");
INSERT INTO malc_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“ഇന്നു ഞാൻ നീരുറവയിൽ എത്തിയപ്പോൾ ദൈവത്തോടു പ്രാർഥിച്ചു: ‘എന്റെ യജമാനനായ അബ്രാഹാമിന്റെ ദൈവമായ യഹോവേ, തിരുഹിതമെങ്കിൽ എന്റെ ഈ യാത്ര സഫലമാക്കണേ. ");
INSERT INTO malc_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ഇതാ, ഞാൻ ഈ നീരുറവയ്ക്കരികെ നിൽക്കുന്നു; ഒരു കന്യക വെള്ളം കോരാൻ വരികയും ഞാൻ അവളോട്, “നിന്റെ കുടത്തിൽനിന്ന് എനിക്കു കുറച്ചുവെള്ളം തരണം” എന്നു പറയുകയും ചെയ്യുമ്പോൾ, ");
INSERT INTO malc_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","അവൾ എന്നോട്, “കുടിച്ചുകൊള്ളൂ, ഞാൻ നിന്റെ ഒട്ടകങ്ങൾക്കുംകൂടി വെള്ളം കോരാം” എന്നു പറയുന്നെങ്കിൽ എന്റെ യജമാനന്റെ മകനുവേണ്ടി യഹോവ തെരഞ്ഞെടുത്തിട്ടുള്ളവൾ അവൾതന്നെ ആയിരിക്കണേ.’ ");
INSERT INTO malc_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“ഞാൻ എന്റെ ഹൃദയത്തിൽ ഇങ്ങനെ പ്രാർഥിച്ചുതീരുന്നതിനുമുമ്പ് റിബേക്ക തോളിൽ കുടവുമായി വന്നു. അവൾ നീരുറവയിലേക്ക് ഇറങ്ങിച്ചെന്ന് വെള്ളം കോരി; ‘എനിക്കൽപ്പം കുടിക്കാൻ തരൂ’ എന്നു ഞാൻ അവളോടു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“അവൾ ഉടൻതന്നെ തോളിൽനിന്ന് കുടം താഴ്ത്തി, ‘കുടിച്ചുകൊള്ളുക, ഞാൻ നിങ്ങളുടെ ഒട്ടകങ്ങൾക്കും വെള്ളം തരാം’ എന്നു പറഞ്ഞു. ഞാൻ കുടിച്ചു, എന്റെ ഒട്ടകങ്ങൾക്കും അവൾ വെള്ളം കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“ ‘നീ ആരുടെ മകളാണ്?’ എന്നു ഞാൻ അവളോടു ചോദിച്ചു. “ ‘ഞാൻ നാഹോരിനു മിൽക്കാ പ്രസവിച്ച മകനായ ബെഥൂവേലിന്റെ മകൾ’ എന്ന് അവൾ പറഞ്ഞു. “അപ്പോൾ ഞാൻ അവളുടെ മൂക്കിൽ മൂക്കുത്തിയും കൈകളിൽ വളയും അണിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","പിന്നെ ഞാൻ കുനിഞ്ഞ് യഹോവയെ നമസ്കരിച്ചു; എന്റെ യജമാനന്റെ മകന് യജമാനന്റെ സഹോദരന്റെ പുത്രിയെ ഭാര്യയായി ലഭിക്കാൻ തക്കവണ്ണം എന്നെ നേർവഴിക്കു നടത്തിയ എന്റെ യജമാനനായ അബ്രാഹാമിന്റെ ദൈവമായ യഹോവയെ ഞാൻ സ്തുതിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","നിങ്ങൾ, ഇനി, എന്റെ യജമാനനോടു കരുണയും വിശ്വസ്തതയും കാണിക്കുമോ എന്ന് എന്നോടു ദയവായി പറയണം; അല്ലാത്തപക്ഷം അതും പറയണം, ഏതു വഴിക്കു തിരിയണമെന്ന് എനിക്ക് മനസ്സിലാക്കാമല്ലോ!” ");
INSERT INTO malc_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","അതിനു ലാബാനും ബെഥൂവേലും, “ഇത് യഹോവയിൽനിന്നുള്ളത്; ഇതിനെക്കുറിച്ച് ഗുണമോ ദോഷമോ ഞങ്ങൾക്കു പറയാൻ ഇല്ല. ");
INSERT INTO malc_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","റിബേക്ക ഇതാ, നിന്റെ മുമ്പിൽ; അവളെ കൂട്ടിക്കൊണ്ടു പൊയ്ക്കൊള്ളൂ; യഹോവ അരുളിച്ചെയ്തതുപോലെ അവൾ നിന്റെ യജമാനന്റെ മകനു ഭാര്യയായിത്തീരട്ടെ” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","അബ്രാഹാമിന്റെ ദാസൻ അവരുടെ വാക്കുകേട്ട്, സാഷ്ടാംഗം വീണു യഹോവയെ നമസ്കരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","പിന്നെ അദ്ദേഹം സ്വർണാഭരണങ്ങളും വെള്ളിയാഭരണങ്ങളും വസ്ത്രങ്ങളും എടുത്തു റിബേക്കയ്ക്കു കൊടുത്തു; അവളുടെ സഹോദരനും അമ്മയ്ക്കും അയാൾ വിലയേറിയ സമ്മാനങ്ങൾ നൽകി. ");
INSERT INTO malc_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","അതിനുശേഷം അദ്ദേഹവും കൂടെയുള്ളവരും ഭക്ഷിക്കുകയും പാനംചെയ്യുകയും ആ രാത്രി അവിടെ ചെലവഴിക്കുകയും ചെയ്തു. അവർ രാവിലെ എഴുന്നേറ്റു. “എന്നെ എന്റെ യജമാനന്റെ അടുത്തേക്കു യാത്രയയച്ചാലും” എന്ന് അദ്ദേഹം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","എന്നാൽ പെൺകുട്ടിയുടെ സഹോദരനും അമ്മയും, “അവൾ പത്തുദിവസം ഞങ്ങളുടെകൂടെ നിൽക്കട്ടെ, അതു കഴിഞ്ഞ് നിങ്ങൾക്കു പോകാം” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","അപ്പോൾ അദ്ദേഹം അവരോട്: “എന്നെ താമസിപ്പിക്കരുത്, യഹോവ എന്റെ യാത്ര സഫലമാക്കിയിരിക്കുന്നു! എന്റെ യജമാനന്റെ അടുക്കൽ ചെല്ലേണ്ടതിന് എന്നെ യാത്രയാക്കിയാലും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","“നമുക്കു പെൺകുട്ടിയെ വിളിച്ച് അവളോടു ചോദിക്കാം” അവർ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","അവർ റിബേക്കയെ വിളിച്ച് “നീ ഇദ്ദേഹത്തോടുകൂടെ പോകുന്നോ?” എന്നു ചോദിച്ചു. “ഞാൻ പോകുന്നു” അവൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","അവർ തങ്ങളുടെ സഹോദരിയായ റിബേക്കയെ അവളുടെ ശുശ്രൂഷക്കാരിയോടും അബ്രാഹാമിന്റെ ദാസനോടും അദ്ദേഹത്തിന്റെ ആളുകളോടുംകൂടെ യാത്രയാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","അവർ റിബേക്കയെ അനുഗ്രഹിച്ചു പറഞ്ഞു: “നമ്മുടെ സഹോദരീ, നീ വർധിക്കട്ടെ, ആയിരമായിരമായിത്തന്നെ; നിന്റെ സന്താനങ്ങൾ അവരുടെ വൈരികളുടെ പട്ടണങ്ങൾ കൈവശമാക്കട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ഇതിനുശേഷം റിബേക്കയും അവളുടെ ദാസിമാരും ഒരുങ്ങി തങ്ങളുടെ ഒട്ടകങ്ങളിന്മേൽ കയറി ആ പുരുഷനോടൊപ്പം യാത്രയായി. അങ്ങനെ ആ ദാസൻ റിബേക്കയെയുംകൂട്ടി യാത്രപുറപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ഇതിനിടയിൽ യിസ്ഹാക്ക് ബേർ-ലഹയീ-രോയീയിൽനിന്ന് വന്നു; അദ്ദേഹം തെക്കേദേശത്താണു താമസിച്ചിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ഒരു ദിവസം സന്ധ്യക്ക് യിസ്ഹാക്ക് ധ്യാനിക്കുന്നതിനു വയലിലേക്കുപോയി; തലയുയർത്തിനോക്കിയപ്പോൾ ഒട്ടകങ്ങൾ അടുത്തു വരുന്നതായി കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","റിബേക്കയും തല ഉയർത്തിനോക്കി, യിസ്ഹാക്കിനെ കണ്ടു. അവൾ ഒട്ടകപ്പുറത്തുനിന്നു താഴെയിറങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ദാസനോട്, “നമ്മെ വരവേൽക്കാൻ വരുന്ന ആ മനുഷ്യൻ ആരാണ്?” എന്നു ചോദിച്ചു. “അദ്ദേഹമാണ് എന്റെ യജമാനൻ” ദാസൻ ഉത്തരം പറഞ്ഞു. അവൾ മൂടുപടം എടുത്ത് തന്നെത്തന്നെ മറച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ദാസൻ താൻ ചെയ്ത എല്ലാക്കാര്യങ്ങളും യിസ്ഹാക്കിനെ അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","യിസ്ഹാക്ക് അവളെ തന്റെ അമ്മയായ സാറയുടെ കൂടാരത്തിൽ കൂട്ടിക്കൊണ്ടുപോയി; അവൻ റിബേക്കയെ വിവാഹംചെയ്തു. റിബേക്ക യിസ്ഹാക്കിന്റെ ഭാര്യയായിത്തീർന്നു; അയാൾ അവളെ സ്നേഹിച്ചു; അങ്ങനെ അമ്മയുടെ മരണശേഷം യിസ്ഹാക്കിനു സാന്ത്വനം ലഭിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","അബ്രാഹാം മറ്റൊരു ഭാര്യയെ സ്വീകരിച്ചു; അവളുടെ പേരു കെതൂറാ എന്നായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","അവൾ അബ്രാഹാമിനു സിമ്രാൻ, യൊക്ശാൻ, മെദാൻ, മിദ്യാൻ, യിശ്ബാക്ക്, ശൂവഹ് എന്നിവരെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ശേബയും ദെദാനും യൊക്ശയുടെ മക്കളായിരുന്നു. ദേദാന്റെ പിൻഗാമികളാണ് അശ്ശൂരീം, ലെത്തൂശീം, ലെയുമ്മീം എന്നിവർ. ");
INSERT INTO malc_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","മിദ്യാന്റെ പുത്രന്മാർ ഏഫാ, ഏഫെർ, ഹാനോക്ക്, അബീദാ, എൽദായാ എന്നിവരാണ്. ഇവരെല്ലാം കെതൂറായിലൂടെ ലഭിച്ച പിൻഗാമികളായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","അബ്രാഹാം തനിക്കുള്ളതെല്ലാം യിസ്ഹാക്കിനു വിട്ടുകൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","അദ്ദേഹം, ജീവിച്ചിരിക്കുമ്പോൾത്തന്നെ വെപ്പാട്ടികളുടെ പുത്രന്മാർക്കു ദാനങ്ങൾ നൽകി. അവരെ തന്റെ മകനായ യിസ്ഹാക്കിന്റെ അടുക്കൽനിന്ന് ദൂരെ കിഴക്കൻ പ്രദേശത്തേക്കയച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","അബ്രാഹാം നൂറ്റിയെഴുപത്തഞ്ചു വർഷം ജീവിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","വയോധികനും കാലസമ്പൂർണനുമായിത്തീർന്ന അബ്രാഹാം തികഞ്ഞ വാർധക്യത്തിൽ മരിച്ചു തന്റെ ജനത്തോടു ചേർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","അദ്ദേഹത്തിന്റെ പുത്രന്മാരായ യിസ്ഹാക്കും യിശ്മായേലുംകൂടി, ഹിത്യനായ സോഹരിന്റെ മകനായ എഫ്രോന്റെ പുരയിടത്തിൽ മമ്രേയ്ക്കു സമീപമുള്ള മക്പേലാഗുഹയിൽ അദ്ദേഹത്തെ അടക്കംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ഈ ശ്മശാനഭൂമി അബ്രാഹാം ഹിത്യരോടു വിലയ്ക്കു വാങ്ങിയതായിരുന്നു. അവിടെ അബ്രാഹാം തന്റെ ഭാര്യയായ സാറയോടൊപ്പം അടക്കംചെയ്യപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","അബ്രാഹാമിന്റെ മരണത്തിനുശേഷം അദ്ദേഹത്തിന്റെ പുത്രനായ യിസ്ഹാക്കിനെ ദൈവം അനുഗ്രഹിച്ചു; യിസ്ഹാക്ക് ആ കാലത്ത് ബേർ-ലഹയീ-രോയീലായിരുന്നു താമസിച്ചിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ഈജിപ്റ്റുകാരിയും സാറയുടെ ദാസിയുമായ ഹാഗാർ അബ്രാഹാമിനു പ്രസവിച്ച മകനായ യിശ്മായേലിനെ സംബന്ധിച്ച വിവരണം ഇതാണ്: ");
INSERT INTO malc_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","യിശ്മായേലിന്റെ പുത്രന്മാരുടെ പേരുകൾ അവരുടെ ജനനക്രമം അനുസരിച്ച്: യിശ്മായേലിന്റെ ആദ്യജാതനായ നെബായോത്ത്, കേദാർ, അദ്ബെയേൽ, മിബ്ശാം, ");
INSERT INTO malc_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","മിശ്മാ, ദൂമാ, മസ്സാ, ");
INSERT INTO malc_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ഹദദ്, തേമാ, യെതൂർ, നാഫീശ്, കേദെമാ. ");
INSERT INTO malc_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ഇവരാണ് യിശ്മായേലിന്റെ പുത്രന്മാർ; തങ്ങളുടെ അധിനിവേശപ്രദേശങ്ങളും പാളയങ്ങളും അനുസരിച്ചു പന്ത്രണ്ടു ഗോത്രാധികാരികളുടെയും പേരുകൾ ഇവതന്നെ. ");
INSERT INTO malc_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","യിശ്മായേൽ ആകെ നൂറ്റിമുപ്പത്തിയേഴു വർഷം ജീവിച്ചിരുന്നു. അദ്ദേഹം പ്രാണനെ വിട്ടു മരിച്ചു; സ്വന്തജനത്തോടു ചേർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","യിശ്മായേലിന്റെ പിൻഗാമികൾ അശ്ശൂരിലേക്കുള്ള വഴിയിൽ, ഈജിപ്റ്റിന്റെ അതിരിനോടുചേർന്ന് ഹവീലാമുതൽ ശൂർവരെയുള്ള പ്രദേശത്തു സ്ഥിരതാമസമാക്കിയിരിക്കുന്നു. അവർ തങ്ങളുടെ സകലസഹോദരന്മാരോടും ശത്രുതപുലർത്തിക്കൊണ്ട് ജീവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","അബ്രാഹാമിന്റെ മകനായ യിസ്ഹാക്കിനെ സംബന്ധിച്ച വിവരണം: യിസ്ഹാക്ക് അബ്രാഹാമിന്റെ മകൻ. ");
INSERT INTO malc_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","യിസ്ഹാക്കിനു നാൽപ്പതു വയസ്സായപ്പോൾ അദ്ദേഹം പദ്ദൻ-അരാമിൽ നിന്നുള്ള ബെഥൂവേലിന്റെ പുത്രിയും അരാമ്യനായ ലാബാന്റെ സഹോദരിയുമായ റിബേക്കയെ വിവാഹംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","യിസ്ഹാക്കിന്റെ ഭാര്യ വന്ധ്യയായിരുന്നതുകൊണ്ട് അദ്ദേഹം അവൾക്കുവേണ്ടി യഹോവയോടു പ്രാർഥിച്ചു. യഹോവ അദ്ദേഹത്തിന്റെ പ്രാർഥന കേട്ടു; യിസ്ഹാക്കിന്റെ ഭാര്യയായ റിബേക്കാ ഗർഭവതിയായി. ");
INSERT INTO malc_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","അവളുടെ ഉള്ളിൽ കുട്ടികൾതമ്മിൽ തിക്കി. അപ്പോൾ അവൾ, “എന്തുകൊണ്ടാണ് എനിക്ക് ഇങ്ങനെയൊക്കെ സംഭവിക്കുന്നത്?” എന്നു പറഞ്ഞുകൊണ്ട് യഹോവയോടു ചോദിക്കാൻ പോയി. ");
INSERT INTO malc_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","യഹോവ അവളോട്: “നിന്റെ ഉദരത്തിൽ രണ്ടു ജനതകളാണുള്ളത്. നിന്റെ ഉള്ളിൽനിന്നുതന്നെ രണ്ടു ജനസമൂഹങ്ങൾ വേർതിരിക്കപ്പെടും; ഒരു ജനസമൂഹം മറ്റതിനെക്കാൾ പ്രബലമായിരിക്കും. മൂത്തവൻ ഇളയവനെ സേവിക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","അവളുടെ പ്രസവകാലം സമീപിച്ചു. അവളുടെ ഉദരത്തിൽ ഇരട്ട ആൺകുട്ടികൾ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ആദ്യം പിറന്നവൻ ചെമപ്പു നിറമുള്ളവനായിരുന്നു. അവന്റെ ദേഹം രോമക്കുപ്പായംപോലെ ആയിരുന്നു; അതുകൊണ്ട്, അവർ അവന് ഏശാവ് എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","അതിന്റെശേഷം അവന്റെ സഹോദരൻ പിറന്നു; അവൻ ഏശാവിന്റെ കുതികാലിൽ പിടിച്ചുകൊണ്ടാണു പുറത്തുവന്നത്. അതുകൊണ്ട് അവന് യാക്കോബ് എന്നു പേരിട്ടു. റിബേക്ക ഇവരെ പ്രസവിച്ചപ്പോൾ യിസ്ഹാക്കിന് അറുപതു വയസ്സായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ബാലന്മാർ വളർന്നു; ഏശാവ് വെളിമ്പ്രദേശങ്ങളിൽ ജീവിക്കുന്നവനും സമർഥനായൊരു നായാട്ടുകാരനും ആയിത്തീർന്നു. യാക്കോബാകട്ടെ, കൂടാരങ്ങളിൽ പാർക്കുന്നവനും ശാന്തനും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","നായാട്ടുമാംസത്തിലുള്ള രുചിമൂലം യിസ്ഹാക്ക് ഏശാവിനെ സ്നേഹിച്ചു; റിബേക്കയോ, യാക്കോബിനെ സ്നേഹിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ഒരിക്കൽ യാക്കോബ് പായസം പാകപ്പെടുത്തിക്കൊണ്ടിരുന്നപ്പോൾ ഏശാവ് വെളിമ്പ്രദേശത്തുനിന്ന് വല്ലാതെ വിശന്നു കയറിവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","അവൻ യാക്കോബിനോട്, “വേഗമാകട്ടെ, ആ ചെമന്ന പായസത്തിൽ കുറച്ച് എനിക്കു തരൂ, വല്ലാതെ വിശക്കുന്നു” എന്നു പറഞ്ഞു. ഇക്കാരണത്താലാണ് അവന് ഏദോം എന്നും പേരായത്. ");
INSERT INTO malc_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","അതിന് യാക്കോബ്, “ഒന്നാമത് നിന്റെ ജന്മാവകാശം എനിക്കു വിലയ്ക്കു തരൂ” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","“ഞാനാണെങ്കിൽ ഇതാ മരിക്കാൻ തുടങ്ങുകയാണ്. ഈ ജന്മാവകാശംകൊണ്ട് എനിക്കെന്തു പ്രയോജനം?” ഏശാവു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","എന്നാൽ യാക്കോബ്, “ആദ്യം എന്നോടു ശപഥംചെയ്യൂ” എന്നു പറഞ്ഞു. അപ്പോൾ അവൻ തന്റെ ജന്മാവകാശം യാക്കോബിനു വിൽക്കുന്നെന്ന് അവനോടു ശപഥംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","അതിനുശേഷം യാക്കോബ് ഏശാവിന് കുറെ അപ്പവും കുറച്ചു പയറുപായസവും കൊടുത്തു. അവൻ തിന്നുകയും കുടിക്കുകയും ചെയ്തതിനുശേഷം എഴുന്നേറ്റ് സ്ഥലംവിട്ടു. അങ്ങനെ ഏശാവ് തന്റെ ജന്മാവകാശത്തോട് അനാദരവുകാട്ടി. ");
INSERT INTO malc_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","അബ്രാഹാമിന്റെ കാലത്തുണ്ടായ ക്ഷാമത്തിനുപുറമേ, ദേശത്തു പിന്നെയും ക്ഷാമം ഉണ്ടായി. യിസ്ഹാക്ക് ഗെരാരിൽ ഫെലിസ്ത്യരുടെ രാജാവായ അബീമെലെക്കിന്റെ അടുക്കൽ ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","യഹോവ യിസ്ഹാക്കിനു പ്രത്യക്ഷനായി അദ്ദേഹത്തോട് “നീ ഈജിപ്റ്റിലേക്ക് പോകരുത്; ഞാൻ നിന്നോടു പാർക്കാൻ പറയുന്ന ദേശത്തുതന്നെ പാർക്കുക. ");
INSERT INTO malc_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","കുറെ കാലത്തേക്ക് ഈ ദേശത്തുതന്നെ ഒരു പ്രവാസിയെപ്പോലെ താമസിക്കുക; ഞാൻ നിന്നോടുകൂടെയിരിക്കുകയും നിന്നെ അനുഗ്രഹിക്കുകയും ചെയ്യും. ഈ ദേശങ്ങളെല്ലാം ഞാൻ നിനക്കും നിന്റെ പിൻഗാമികൾക്കും തരും; അങ്ങനെ, നിന്റെ പിതാവായ അബ്രാഹാമിനോടു ചെയ്ത ശപഥം ഞാൻ ഉറപ്പാക്കും. ");
INSERT INTO malc_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","5","അബ്രാഹാം എന്നെ അനുസരിക്കുകയും എന്റെ കൽപ്പനകളും ഉത്തരവുകളും നിയമങ്ങളും പാലിക്കുകയും ചെയ്തതുകൊണ്ട്, ഞാൻ നിന്റെ സന്തതിപരമ്പരയെ ആകാശത്തിലെ നക്ഷത്രങ്ങളെപ്പോലെ അസംഖ്യമായി വർധിപ്പിച്ച് ഈ ദേശങ്ങളെല്ലാം അവർക്കു കൊടുക്കും; നിന്റെ സന്തതി മുഖാന്തരം ഭൂമിയിലെ സകലജനതകളും അനുഗ്രഹിക്കപ്പെടും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","അതുകൊണ്ട് യിസ്ഹാക്ക് ഗെരാരിൽ താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ആ സ്ഥലത്തെ ആളുകൾ അദ്ദേഹത്തോട് തന്റെ ഭാര്യയെക്കുറിച്ചു ചോദിച്ചപ്പോൾ “അവൾ എന്റെ സഹോദരിയാകുന്നു” എന്ന് അദ്ദേഹം പറഞ്ഞു. “അവൾ എന്റെ ഭാര്യയാകുന്നു” എന്നു പറയാൻ അദ്ദേഹത്തിനു ഭയമായിരുന്നു. “റിബേക്ക സുന്ദരിയായതുകൊണ്ട് അവൾക്കുവേണ്ടി ഈ സ്ഥലത്തുള്ള പുരുഷന്മാർ എന്നെ കൊന്നുകളയും” എന്ന് അദ്ദേഹം ചിന്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","യിസ്ഹാക്ക് അവിടെ താമസം തുടങ്ങിയിട്ട് ഏറെക്കാലം ആയിരുന്നു. ഒരിക്കൽ ഫെലിസ്ത്യരാജാവായ അബീമെലെക്ക് ഒരു ജനാലയിലൂടെ താഴേക്കു നോക്കിയപ്പോൾ യിസ്ഹാക്ക് തന്റെ ഭാര്യയായ റിബേക്കയെ ലാളിക്കുന്നതു കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","അബീമെലെക്ക് യിസ്ഹാക്കിനെ ആളയച്ചുവരുത്തി, അദ്ദേഹത്തോട്, “അവൾ വാസ്തവത്തിൽ നിന്റെ ഭാര്യതന്നെ! ‘അവൾ എന്റെ സഹോദരി’ എന്നു നീ പറഞ്ഞതെന്തിന്?” എന്നു ചോദിച്ചു. അതിനു യിസ്ഹാക്ക്, “അവൾനിമിത്തം എനിക്കു ജീവഹാനി നേരിട്ടേക്കുമെന്നു ഞാൻ ഭയപ്പെട്ടതുകൊണ്ടാണ്” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","അപ്പോൾ അബീമെലെക്ക്, “നീ ഞങ്ങളോട് ഈ ചെയ്തതെന്ത്? ജനങ്ങളിൽ ആരെങ്കിലും നിന്റെ ഭാര്യയോടൊപ്പം കിടക്കപങ്കിട്ടിരുന്നെങ്കിൽ, നീ ഞങ്ങളുടെ തലയിൽ അപരാധം വരുത്തിവെക്കുമായിരുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","പിന്നെ അബീമെലെക്ക്, “ഈ മനുഷ്യനെയോ ഇദ്ദേഹത്തിന്റെ ഭാര്യയെയോ തൊടുന്നവന് മരണശിക്ഷ ലഭിക്കും” എന്ന് സകലജനത്തോടും കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","യിസ്ഹാക്ക് ആ ദേശത്ത് കൃഷിയിറക്കി; യഹോവ അദ്ദേഹത്തെ അനുഗ്രഹിച്ചതുകൊണ്ട് ആ വർഷം നൂറുമടങ്ങ് വിളവുണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","അദ്ദേഹം ധനികനായിത്തീർന്നു; മഹാധനവാനായിത്തീരത്തക്കവണ്ണം അദ്ദേഹത്തിന്റെ സമ്പത്തു വർധിച്ചുകൊണ്ടേയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","അദ്ദേഹത്തിന് ധാരാളം ആട്ടിൻപറ്റങ്ങളും കന്നുകാലികളും ദാസീദാസന്മാരും ഉണ്ടായിരുന്നു. അതുകൊണ്ട് ഫെലിസ്ത്യർക്ക് അദ്ദേഹത്തോട് അസൂയതോന്നി. ");
INSERT INTO malc_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","അതുകൊണ്ട്, അദ്ദേഹത്തിന്റെ പിതാവായ അബ്രാഹാമിന്റെ കാലത്തു പിതാവിന്റെ ദാസന്മാർ കുഴിച്ചിരുന്ന കിണറുകളെല്ലാം ഫെലിസ്ത്യർ മണ്ണിട്ടു നികത്തിക്കളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","പിന്നെ അബീമെലെക്ക് യിസ്ഹാക്കിനോട്, “ഞങ്ങളെ വിട്ടുപോകുക, നിങ്ങൾ ഞങ്ങളെക്കാൾ പ്രബലരായിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","അങ്ങനെ യിസ്ഹാക്ക് അവിടം വിട്ടുപോയി ഗെരാർ താഴ്വരയിൽ താമസം ഉറപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","അദ്ദേഹത്തിന്റെ പിതാവായ അബ്രാഹാമിന്റെ കാലത്തു കുഴിപ്പിച്ചിരുന്നതും അബ്രാഹാമിന്റെ മരണശേഷം ഫെലിസ്ത്യർ മൂടിക്കളഞ്ഞതുമായ കിണറുകൾ യിസ്ഹാക്ക് വീണ്ടും കുഴിപ്പിച്ച്, അവയ്ക്ക് തന്റെ പിതാവ് ഇട്ടിരുന്ന അതേ പേരുകൾതന്നെ വീണ്ടും നൽകി. ");
INSERT INTO malc_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","യിസ്ഹാക്കിന്റെ ദാസന്മാരും ഈ താഴ്വരയിൽ ശുദ്ധജലമുള്ള ഒരു കിണർ കുഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","എന്നാൽ, ഗെരാരിലെ കന്നുകാലികളുടെ ഇടയന്മാർ യിസ്ഹാക്കിന്റെ കന്നുകാലികളുടെ ഇടയന്മാരോട് “ഈ വെള്ളം ഞങ്ങൾക്കുള്ളതാണ്” എന്നു പറഞ്ഞ് വഴക്കിട്ടു. അവർ തന്നോടു ശണ്ഠകൂടിയതുകൊണ്ട് യിസ്ഹാക്ക് ആ കിണറിന് ഏശെക്ക് എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","പിന്നെ അവർ മറ്റൊരു കിണർ കുഴിച്ചു; എന്നാൽ അതിനെ സംബന്ധിച്ചും അവർ വഴക്കുണ്ടാക്കി; അതുകൊണ്ട് അദ്ദേഹം അതിനു സിത്നാ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","അദ്ദേഹം അവിടെനിന്നും നീങ്ങി മറ്റൊരു കിണർ കുഴിപ്പിച്ചു; അതിന്റെപേരിൽ ആരും ശണ്ഠയുണ്ടാക്കിയില്ല. “യഹോവ ഇപ്പോൾ നമുക്ക് ആവശ്യമുള്ള സ്ഥലം തന്നിരിക്കുന്നു, നമ്മൾ ദേശത്ത് അഭിവൃദ്ധിപ്പെടും” എന്നു പറഞ്ഞുകൊണ്ട് അദ്ദേഹം ആ കിണറിന് രെഹോബോത്ത് എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","അവിടെനിന്നും അദ്ദേഹം ബേർ-ശേബയിലേക്കു പോയി. ");
INSERT INTO malc_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","അന്നുരാത്രി യഹോവ അദ്ദേഹത്തിനു പ്രത്യക്ഷനായി ഇങ്ങനെ അരുളിച്ചെയ്തു: “ഞാൻ നിന്റെ പിതാവായ അബ്രാഹാമിന്റെ ദൈവമാകുന്നു. ഭയപ്പെടരുത്, ഞാൻ നിന്നോടുകൂടെയുണ്ട്. എന്റെ ദാസനായ അബ്രാഹാംനിമിത്തം ഞാൻ നിന്നെ അനുഗ്രഹിക്കുകയും നിന്റെ പിൻഗാമികളുടെ എണ്ണം വർധിപ്പിക്കുകയും ചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","യിസ്ഹാക്ക് അവിടെ ഒരു യാഗപീഠം പണിത് യഹോവയെ ആരാധിച്ചു. അവിടെ അദ്ദേഹം തന്റെ കൂടാരം ഉറപ്പിക്കുകയും ദാസന്മാർ ഒരു കിണർ കുഴിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ഇതേസമയം അബീമെലെക്ക് തന്റെ ഉപദേഷ്ടാവായ അഹൂസ്സത്തിനെയും സൈന്യാധിപനായ ഫിക്കോലിനെയും കൂട്ടിക്കൊണ്ട് ഗെരാരിൽനിന്ന് യിസ്ഹാക്കിന്റെ അടുത്തെത്തി. ");
INSERT INTO malc_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","യിസ്ഹാക്ക് അവരോട്, “നിങ്ങൾ എന്തിനാണ് എന്റെ അടുക്കൽ എത്തിയത്? എന്നോടുള്ള പകനിമിത്തം നിങ്ങൾ എന്നെ ദൂരേക്ക് അയച്ചതല്ലയോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","അതിന് അവർ ഉത്തരം പറഞ്ഞത്: “യഹോവ നിന്നോടുകൂടെയുണ്ട് എന്നു ഞങ്ങൾ സ്പഷ്ടമായി കണ്ടിരിക്കുന്നു. അതുകൊണ്ടു ഞങ്ങളും നീയുംതമ്മിൽ ‘ശപഥംചെയ്ത് ഒരു സമാധാനയുടമ്പടി ഉറപ്പിക്കേണ്ടതാണ്’ എന്നു ഞങ്ങൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ഞങ്ങൾ നിനക്ക് ഒരു ദോഷവും ചെയ്തിട്ടില്ല; നിന്നോട് എപ്പോഴും നന്നായി വർത്തിക്കുകയും സമാധാനത്തോടെ നിന്നെ യാത്രയാക്കുകയും ചെയ്തു. അതുപോലെ നീ ഞങ്ങൾക്കും ദോഷമൊന്നും ചെയ്യുകയില്ലെന്ന് നമുക്കുതമ്മിൽ ഒരു ഉടമ്പടി ചെയ്യാം. നീയോ, ഇപ്പോൾ യഹോവയാൽ അനുഗ്രഹിക്കപ്പെട്ടുമിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","യിസ്ഹാക്ക് അവർക്കുവേണ്ടി ഒരു വിരുന്നൊരുക്കി; അവർ ഭക്ഷിച്ചു, പാനംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","പിറ്റേന്ന് അതിരാവിലെ അവർ പരസ്പരം ശപഥംചെയ്തു. പിന്നെ യിസ്ഹാക്ക് അവരെ യാത്രയാക്കി. അവർ സമാധാനത്തോടെ അദ്ദേഹത്തെ വിട്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","അന്ന്, യിസ്ഹാക്കിന്റെ ദാസന്മാർ വന്ന് “ഞങ്ങൾ വെള്ളം കണ്ടെത്തിയിരിക്കുന്നു” എന്ന് തങ്ങൾ കുഴിച്ചുകൊണ്ടിരുന്ന കിണറിനെക്കുറിച്ച് അദ്ദേഹത്തോടു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","അദ്ദേഹം അതിനു ശിബാ എന്നു പേരിട്ടു; അതുകൊണ്ട് ഈ ദിവസംവരെയും ആ പട്ടണത്തിന്റെ പേര് ബേർ-ശേബാ എന്നാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ഏശാവിനു നാൽപ്പതു വയസ്സായപ്പോൾ ഹിത്യനായ ബേരിയുടെ മകൾ യെഹൂദീത്തിനെയും ഹിത്യനായ ഏലോമിന്റെ മകൾ ബാസമത്തിനെയും വിവാഹംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","അവർ യിസ്ഹാക്കിന്റെയും റിബേക്കയുടെയും ജീവിതം ദുരിതപൂർണമാക്കിത്തീർത്തു. ");
INSERT INTO malc_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","യിസ്ഹാക്ക് വൃദ്ധനായി; അദ്ദേഹത്തിന്റെ കണ്ണുകൾ മങ്ങി: കാഴ്ച തീരെ ഇല്ലാതായി. അദ്ദേഹം മൂത്തമകനായ ഏശാവിനെ “എന്റെ മോനേ,” എന്നു വിളിച്ചു. “ഞാൻ ഇതാ” എന്ന് അവൻ ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","യിസ്ഹാക്ക് അവനോട്, “ഇതാ ഞാൻ വൃദ്ധനായിരിക്കുന്നു, എന്റെ മരണദിവസം എനിക്ക് അറിഞ്ഞുകൂടാ. ");
INSERT INTO malc_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","നീ ഇപ്പോൾ നിന്റെ ആയുധങ്ങളായ ആവനാഴിയും വില്ലും എടുത്ത് വെളിമ്പ്രദേശത്തേക്കു ചെന്ന് എനിക്കുവേണ്ടി വേട്ടയാടുക. ");
INSERT INTO malc_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","എനിക്ക് ഇഷ്ടവും രുചികരവുമായ ഭക്ഷണം ഉണ്ടാക്കി എന്റെ അടുക്കൽ കൊണ്ടുവരിക; ഞാൻ അതു ഭക്ഷിച്ച് മരിക്കുന്നതിനുമുമ്പ് നിന്നെ അനുഗ്രഹിക്കാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","യിസ്ഹാക്ക് തന്റെ മകനായ ഏശാവിനോടു സംസാരിക്കുന്നത് റിബേക്ക കേട്ടു. ഏശാവു വേട്ടയാടിക്കൊണ്ടുവരാൻ വെളിമ്പ്രദേശത്തേക്കു പോയപ്പോൾ. ");
INSERT INTO malc_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","റിബേക്ക തന്റെ മകനായ യാക്കോബിനോട് പറഞ്ഞു: “ഇതാ, നിന്റെ അപ്പൻ നിന്റെ സഹോദരനായ ഏശാവിനോട്, ");
INSERT INTO malc_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘വേട്ടയിറച്ചി കൊണ്ടുവന്നു രുചികരമായ ഭക്ഷണം തയ്യാറാക്കിത്തരിക, ഞാൻ മരിക്കുന്നതിനുമുമ്പ് യഹോവയുടെ സന്നിധിയിൽ ഞാൻ നിന്നെ അനുഗ്രഹിക്കാം’ എന്നു പറയുന്നതു ഞാൻ കേട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","അതുകൊണ്ട് മകനേ, ഇപ്പോൾ നീ ശ്രദ്ധിച്ചുകേട്ട് ഞാൻ പറയുന്നതുപോലെ ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","നീ ആട്ടിൻപറ്റത്തിലേക്കു ചെന്ന് നല്ല രണ്ട് ആട്ടിൻകുട്ടികളെ കൊണ്ടുവരണം. ഞാൻ അതുകൊണ്ട് നിന്റെ അപ്പന് ഇഷ്ടപ്പെടുന്നവിധത്തിൽ സ്വാദിഷ്ഠമായ ഭക്ഷണം തയ്യാറാക്കാം. ");
INSERT INTO malc_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","നീ അതു കൊണ്ടുപോയി നിന്റെ അപ്പനു ഭക്ഷിക്കാൻ കൊടുക്കണം; അപ്പൻ അതു തിന്ന് മരണത്തിനുമുമ്പ് നിന്നെ അനുഗ്രഹിക്കും.” ");
INSERT INTO malc_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","എന്നാൽ, യാക്കോബ് തന്റെ അമ്മയായ റിബേക്കയോട്: “എന്റെ സഹോദരനായ ഏശാവ് രോമം ഉള്ളവനും ഞാൻ രോമം ഇല്ലാത്തവനുമാണ്. ");
INSERT INTO malc_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","അപ്പൻ എന്നെ തൊട്ടുനോക്കിയാൽ എന്തുചെയ്യും? ഞാൻ അദ്ദേഹത്തെ കബളിപ്പിക്കുകയാണെന്നു വരും. അതെനിക്ക് അനുഗ്രഹത്തിനുപകരം ശാപത്തിനു കാരണമാകും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","അവന്റെ അമ്മ അവനോട്, “എന്റെ മകനേ, ആ ശാപം എന്റെമേൽ വന്നുകൊള്ളട്ടെ; ഞാൻ പറയുന്നതു ചെയ്യുക, നീ ചെന്ന് ആട്ടിൻകുട്ടികളെ കൊണ്ടുവരിക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","അങ്ങനെ അവൻ പോയി, അവയെ അമ്മയുടെ അടുക്കൽ കൊണ്ടുവന്നു. അവൾ അവന്റെ അപ്പന് ഇഷ്ടപ്പെടുന്നതരത്തിൽ രുചിയുള്ള ഭക്ഷണം തയ്യാറാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","പിന്നെ റിബേക്ക മൂത്തമകൻ ഏശാവിന്റേതായി വീട്ടിൽ സൂക്ഷിച്ചുവെച്ചിരുന്ന ഏറ്റവും നല്ല വസ്ത്രം എടുത്ത് ഇളയമകൻ യാക്കോബിനെ ധരിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","അവന്റെ കൈകളും രോമമില്ലാത്ത കഴുത്തും അവൾ ആട്ടിൻകുട്ടിയുടെ തുകൽകൊണ്ടു മറച്ചു; ");
INSERT INTO malc_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","പിന്നെ താൻ ഉണ്ടാക്കിയിരുന്ന രുചികരമായ ഭക്ഷണവും അപ്പവും ഇളയമകനായ യാക്കോബിനെ ഏൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","അങ്ങനെ അവൻ അപ്പന്റെ അടുക്കൽച്ചെന്ന്, “അപ്പാ” എന്നു വിളിച്ചു. അദ്ദേഹം “മോനേ” എന്നു വിളികേട്ടിട്ട്, “അതാരാകുന്നു?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","യാക്കോബ് തന്റെ അപ്പനോട്, “ഞാൻ അങ്ങയുടെ ആദ്യജാതനായ ഏശാവാണ്. എന്നോടു പറഞ്ഞതുപോലെ ഞാൻ ചെയ്തിരിക്കുന്നു. എഴുന്നേറ്റിരുന്ന് ഞാൻ കൊണ്ടുവന്ന വേട്ടയിറച്ചിയിൽനിന്ന് ഭക്ഷിച്ച് എന്നെ അനുഗ്രഹിക്കുക.” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","യിസ്ഹാക്ക് തന്റെ മകനോട്, “മോനേ, നിനക്ക് ഇത്ര വേഗത്തിൽ ഇതു കിട്ടിയതെങ്ങനെ?” എന്നു ചോദിച്ചു. “അങ്ങയുടെ ദൈവമായ യഹോവ അതിനെ എന്റെമുമ്പിൽ എത്തിച്ചു,” എന്ന് അവൻ മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","അപ്പോൾ യിസ്ഹാക്ക് യാക്കോബിനോട്: “മോനേ, അടുത്തുവരൂ, നീ എന്റെ മകനായ ഏശാവുതന്നെയോ എന്നു ഞാൻ തൊട്ടുനോക്കട്ടെ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","യാക്കോബ് തന്റെ പിതാവായ യിസ്ഹാക്കിന്റെ അടുത്തേക്കുചെന്നു. അദ്ദേഹം അവനെ തൊട്ടുകൊണ്ട്: “ശബ്ദം യാക്കോബിന്റേത്; എന്നാൽ, കൈകൾ ഏശാവിന്റേത്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","അവന്റെ കൈകൾ ഏശാവിന്റെ കൈകൾപോലെ രോമം നിറഞ്ഞതായിരുന്നതുകൊണ്ട്, അദ്ദേഹം അവനെ തിരിച്ചറിഞ്ഞില്ല; അങ്ങനെ യിസ്ഹാക്ക് യാക്കോബിനെ അനുഗ്രഹിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“നീ എന്റെ മകനായ ഏശാവുതന്നെയോ?” എന്ന് അദ്ദേഹം ചോദിച്ചു. “ഞാൻതന്നെ” അവൻ ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","“മോനേ, നിന്റെ വേട്ടയിറച്ചിയിൽ കുറെ എനിക്കു തരൂ, ഞാൻ ഭക്ഷിച്ച് നിന്നെ അനുഗ്രഹിക്കട്ടെ,” അദ്ദേഹം പറഞ്ഞു. യാക്കോബ് അത് പിതാവിന്റെ അടുക്കൽ കൊണ്ടുചെന്നു, അദ്ദേഹം അതു ഭക്ഷിച്ചു. അവൻ വീഞ്ഞും കൊണ്ടുചെന്നു. അതും അദ്ദേഹം പാനംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","പിന്നെ അവന്റെ പിതാവായ യിസ്ഹാക്ക് അവനോട്: “മോനേ, അടുത്തുവന്ന് എന്നെ ചുംബിക്കൂ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","അവൻ അടുത്തുചെന്ന് അദ്ദേഹത്തെ ചുംബിച്ചു. അവന്റെ വസ്ത്രം മണത്തുനോക്കി യിസ്ഹാക്ക് അവനെ അനുഗ്രഹിച്ചുകൊണ്ടു പറഞ്ഞു: “ഹാ, എന്റെ മകന്റെ സുഗന്ധം യഹോവ അനുഗ്രഹിച്ച വയലിന്റെ സുഗന്ധംപോലെ. ");
INSERT INTO malc_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ദൈവം നിനക്ക് ആകാശത്തിന്റെ മഞ്ഞും ഭൂമിയുടെ പുഷ്ടിയും ധാന്യത്തിന്റെയും പുതുവീഞ്ഞിന്റെയും സമൃദ്ധിയും നൽകട്ടെ. ");
INSERT INTO malc_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","രാഷ്ട്രങ്ങൾ നിന്നെ സേവിക്കുകയും ജനതകൾ നിന്നെ വണങ്ങുകയും ചെയ്യട്ടെ. നിന്റെ സഹോദരന്മാർക്കു നീ പ്രഭുവായിരിക്കട്ടെ; നിന്റെ അമ്മയുടെ പുത്രന്മാർ നിന്നെ നമിക്കട്ടെ. നിന്നെ ശപിക്കുന്നവർ ശപിക്കപ്പെടട്ടെ; നിന്നെ അനുഗ്രഹിക്കുന്നവർ അനുഗ്രഹിക്കപ്പെടട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","യിസ്ഹാക്ക് യാക്കോബിനെ അനുഗ്രഹിച്ചുകഴിഞ്ഞപ്പോൾ അവൻ തന്റെ പിതാവിന്റെ മുമ്പിൽനിന്ന് കഷ്ടിച്ച് പുറത്തുപോയി. ഉടൻതന്നെ അവന്റെ സഹോദരനായ ഏശാവ് വേട്ടകഴിഞ്ഞ് മടങ്ങിയെത്തി. ");
INSERT INTO malc_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","അവനും രുചികരമായ ഭക്ഷണം തയ്യാറാക്കി അപ്പന്റെ അടുക്കൽ കൊണ്ടുവന്നു. അവൻ അപ്പനോട്, “അപ്പാ, എഴുന്നേറ്റിരുന്ന് ഞാൻ കൊണ്ടുവന്ന വേട്ടയിറച്ചിയിൽനിന്നു ഭക്ഷിച്ച്, എന്നെ അനുഗ്രഹിക്കണമേ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","അവന്റെ പിതാവായ യിസ്ഹാക്ക് അവനോട്: “നീ ആരാണ്?” എന്നു ചോദിച്ചു. “ഞാൻ അങ്ങയുടെ മകൻ, അങ്ങയുടെ ആദ്യജാതനായ ഏശാവ്,” അവൻ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","യിസ്ഹാക്ക് സംഭ്രമിച്ച് നടുങ്ങിപ്പോയി, അദ്ദേഹം പറഞ്ഞു: “അങ്ങനെയെങ്കിൽ എനിക്ക് വേട്ടയിറച്ചി കൊണ്ടുവന്നു തന്നതാരായിരുന്നു? നീ വരുന്നതിനു തൊട്ടുമുമ്പ് ഞാൻ അതു തിന്നുകയും അവനെ അനുഗ്രഹിക്കുകയും ചെയ്തു, അതേ, അവൻ വാസ്തവമായി അനുഗ്രഹിക്കപ്പെട്ടിരിക്കും!” ");
INSERT INTO malc_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","പിതാവിന്റെ വാക്കുകൾ കേട്ട് ഏശാവ് അതീവദുഃഖത്തോടെ ഉറക്കെക്കരഞ്ഞു. “അപ്പാ, എന്നെ, എന്നെക്കൂടി അനുഗ്രഹിക്കണമേ,” അവൻ അപേക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","എന്നാൽ യിസ്ഹാക്ക്, “നിന്റെ സഹോദരൻ ഉപായത്തിൽവന്നു നിനക്കുള്ള അനുഗ്രഹം തട്ടിയെടുത്തു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","അതിന് ഏശാവ്: “അവന് യാക്കോബ് എന്നു പേരിട്ടിരിക്കുന്നതു ശരിതന്നെയല്ലോ! രണ്ടുപ്രാവശ്യവും അവൻ എന്നെ ചതിച്ചു. നേരത്തേ അവൻ എന്റെ ജ്യേഷ്ഠാവകാശം അപഹരിച്ചു, ഇപ്പോഴിതാ, എനിക്കുള്ള അനുഗ്രഹവും തട്ടിയെടുത്തിരിക്കുന്നു!” എന്നു പറഞ്ഞു. പിന്നെ അവൻ: “അങ്ങ്, എനിക്ക് ഒരനുഗ്രഹംപോലും കരുതിവെച്ചിട്ടില്ലയോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","യിസ്ഹാക്ക് ഏശാവിനോട്: “ഞാൻ അവനെ നിനക്കു പ്രഭുവാക്കി: അവന്റെ സഹോദരന്മാരെയെല്ലാം അവന്റെ സേവകരാക്കി; ധാന്യവും വീഞ്ഞും അവനു നൽകി. ഇനി, മകനേ, നിനക്കുവേണ്ടി എനിക്കെന്തു ചെയ്യാൻ കഴിയും?” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ഏശാവ് അപ്പനോട്: “അപ്പാ, അങ്ങേക്ക് ഒറ്റ അനുഗ്രഹമേ ഉള്ളോ? എന്നെയുംകൂടെ അനുഗ്രഹിക്കണമേ, അപ്പാ” എന്നു പറഞ്ഞ് ഉറക്കെ കരഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","അതിനുത്തരമായി അവന്റെ അപ്പനായ യിസ്ഹാക്ക് അവനോട്: “നിന്റെ വാസം ഭൂമിയുടെ സമൃദ്ധിയിൽനിന്നും മീതേ ആകാശത്തിൽനിന്നുള്ള മഞ്ഞിൽനിന്നും അകലെയായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","നീ വാൾകൊണ്ട് ഉപജീവനം നടത്തും; നീ നിന്റെ സഹോദരനെ സേവിക്കും. എന്നാൽ നീ അസ്വസ്ഥനായിത്തീരുമ്പോൾ അവന്റെ നുകം നിന്റെ ചുമലിൽനിന്ന് നീ കുടഞ്ഞുകളയും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","യാക്കോബിനെ തന്റെ പിതാവ് അനുഗ്രഹിച്ചതുകൊണ്ട് ഏശാവിന് യാക്കോബിനോടു പകയുണ്ടായി. “എന്റെ പിതാവിനെച്ചൊല്ലി വിലപിക്കേണ്ട ദിവസങ്ങൾ അടുത്തുവരുന്നു, അതിനുശേഷം ഞാൻ എന്റെ സഹോദരൻ യാക്കോബിനെ കൊല്ലും,” അവൻ വിദ്വേഷത്തോടെ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ഏശാവിന്റെ വാക്കുകളെക്കുറിച്ചു റിബേക്കയ്ക്ക് അറിവുകിട്ടിയപ്പോൾ അവൾ തന്റെ ഇളയമകനായ യാക്കോബിനെ ആളയച്ചുവരുത്തി അവനോട്, “നിന്റെ സഹോദരനായ ഏശാവ് നിന്നെ കൊന്നു പകവീട്ടാൻ ആഗ്രഹിക്കുകയാണ്. ");
INSERT INTO malc_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","അതുകൊണ്ട് മകനേ, ഞാൻ പറയുന്നതു കേൾക്കുക, ഹാരാനിൽ എന്റെ സഹോദരനായ ലാബാന്റെ അടുത്തേക്ക് ഓടിപ്പോകുക. ");
INSERT INTO malc_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","നിന്റെ സഹോദരന്റെ ക്രോധം ശമിക്കുന്നതുവരെ കുറെക്കാലം അവിടെ താമസിക്കുക. ");
INSERT INTO malc_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","നിന്റെ സഹോദരന് നിന്നോടുള്ള കോപം ശമിക്കുകയും നീ അവനോടു ചെയ്തത് മറക്കുകയും ചെയ്യട്ടെ. അപ്പോൾ ഞാൻ ആളയച്ച് നിന്നെ മടക്കിവരുത്താം. നിങ്ങൾ രണ്ടുപേരെയും എനിക്ക് ഒരേദിവസം നഷ്ടമാകുന്നതെന്തിന്?” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","പിന്നെ റിബേക്ക യിസ്ഹാക്കിനോട്, “ഈ ഹിത്യസ്ത്രീകൾനിമിത്തം എനിക്കു ജീവിതം മടുത്തു. ഈ നാട്ടുകാരികളായ ഇവരെപ്പോലെയുള്ള ഹിത്യസ്ത്രീകളിൽനിന്ന് ഒരുവളെ യാക്കോബ് വിവാഹംചെയ്താൽ പിന്നെ ഞാൻ എന്തിനു ജീവിക്കണം?” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ഇതിനുശേഷം യിസ്ഹാക്ക് യാക്കോബിനെ വിളിച്ച് അനുഗ്രഹിച്ചു; പിന്നെ അവനോട് ആജ്ഞാപിച്ചു: “കനാന്യസ്ത്രീകളിൽ ആരെയും നീ വിവാഹംചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ഉടൻതന്നെ പദ്ദൻ-അരാമിൽ നിന്റെ അമ്മയുടെ പിതാവായ ബെഥൂവേലിന്റെ വീട്ടിലേക്കു പോകണം; അവിടെ നിന്റെ അമ്മയുടെ സഹോദരനായ ലാബാന്റെ പെൺമക്കളിൽ ഒരുവളെ ഭാര്യയായി സ്വീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","സർവശക്തനായ ദൈവം നിന്നെ അനുഗ്രഹിച്ച് ഒരു വലിയ ജനസമൂഹമായിത്തീരുംവിധം സന്താനപുഷ്ടിയുള്ളവനാക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ദൈവം അബ്രാഹാമിനു നൽകിയിട്ടുള്ളതും നീ ഇപ്പോൾ പ്രവാസിയായി പാർക്കുന്നതുമായ ദേശം നീ അവകാശമാക്കേണ്ടതിന് അവിടന്ന് അബ്രാഹാമിനു നൽകിയ അനുഗ്രഹം നിനക്കും നിന്റെ സന്തതികൾക്കും നൽകുമാറാകട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","തുടർന്ന് യിസ്ഹാക്ക് യാക്കോബിനെ പറഞ്ഞയച്ചു. അവൻ പദ്ദൻ-അരാമിൽ, യാക്കോബിന്റെയും ഏശാവിന്റെയും അമ്മയായ റിബേക്കയുടെ സഹോദരനും അരാമ്യനായ ബെഥൂവേലിന്റെ മകനുമായ ലാബാന്റെ അടുത്തേക്കുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","യിസ്ഹാക്ക് യാക്കോബിനെ അനുഗ്രഹിച്ചെന്നും പദ്ദൻ-അരാമിൽനിന്ന് ഒരുവളെ ഭാര്യയായി സ്വീകരിക്കാൻ അവനെ അവിടേക്ക് അയച്ചെന്നും ഏശാവ് അറിഞ്ഞു. അവനെ അനുഗ്രഹിക്കുമ്പോൾ “നീ കനാന്യസ്ത്രീകളിൽ ആരെയും വിവാഹംചെയ്യരുത്,” എന്നു കൽപ്പിച്ചിരുന്നെന്നും ");
INSERT INTO malc_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","യാക്കോബ് തന്റെ അമ്മയപ്പന്മാരുടെ വാക്കനുസരിച്ചാണ് പദ്ദൻ-അരാമിലേക്കു പോയിരിക്കുന്നതെന്നും അവൻ ഗ്രഹിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","കനാന്യസ്ത്രീകൾ തന്റെ പിതാവായ യിസ്ഹാക്കിന് ഇഷ്ടമുള്ളവരല്ലെന്ന് ഏശാവ് മനസ്സിലാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","അതുകൊണ്ട് ഏശാവ് യിശ്മായേലിന്റെ അടുക്കൽ ചെന്നു നേരത്തേ തനിക്കുണ്ടായിരുന്ന ഭാര്യമാർ കൂടാതെ അബ്രാഹാമിന്റെ മകനായ യിശ്മായേലിന്റെ മകളും നെബായോത്തിന്റെ സഹോദരിയുമായ മഹലത്തിനെയും വിവാഹംകഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","യാക്കോബ് ബേർ-ശേബ വിട്ട് ഹാരാനിലേക്കു യാത്രയായി. ");
INSERT INTO malc_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","അദ്ദേഹം ഒരു സ്ഥലത്തെത്തിയപ്പോൾ, സൂര്യൻ അസ്തമിച്ചിരുന്നതുകൊണ്ട് അവിടെ രാത്രി കഴിച്ചുകൂട്ടി. അവിടെ ഉണ്ടായിരുന്ന കല്ലുകളിൽ ഒന്നെടുത്ത് തലയിണയായി വെച്ച് കിടന്നുറങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","അദ്ദേഹം ഒരു സ്വപ്നംകണ്ടു: ഭൂമിയിൽ വെച്ചിട്ടുള്ള ഒരു കോവണി. അത് സ്വർഗത്തോളം എത്തുന്നു! അതിലൂടെ ദൈവദൂതന്മാർ കയറുകയും ഇറങ്ങുകയും ചെയ്യുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","അതിനുമീതേ യഹോവ നിന്നു. അവിടന്ന് ഇങ്ങനെ അരുളിച്ചെയ്തു: “ഞാൻ നിന്റെ പിതാവായ അബ്രാഹാമിന്റെയും യിസ്ഹാക്കിന്റെയും ദൈവമായ യഹോവ ആകുന്നു. നീ ഇപ്പോൾ കിടക്കുന്ന സ്ഥലം ഞാൻ നിനക്കും നിന്റെ സന്തതിക്കും തരും. ");
INSERT INTO malc_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","നിന്റെ സന്തതികൾ ഭൂമിയിലെ പൊടിപോലെ അസംഖ്യമായിത്തീരും; നീ പടിഞ്ഞാറോട്ടും കിഴക്കോട്ടും വടക്കോട്ടും തെക്കോട്ടും വ്യാപിക്കും. നിന്നിലൂടെയും നിന്റെ സന്തതിയിലൂടെയും ഭൂമിയിലെ സകലവംശങ്ങളും അനുഗ്രഹിക്കപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ഞാൻ നിന്നോടുകൂടെയുണ്ട്; നീ പോകുന്നിടത്തെല്ലാം ഞാൻ നിന്നെ കാത്തുകൊള്ളും; ഞാൻ നിന്നെ ഈ ദേശത്തേക്കു മടക്കിവരുത്തും. ഞാൻ നിന്നെ കൈവിടാതെ നിന്നോടുചെയ്ത വാഗ്ദത്തം നിറവേറ്റും.” ");
INSERT INTO malc_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","യാക്കോബ് ഉറക്കത്തിൽനിന്ന് ഉണർന്നു, “യഹോവ നിശ്ചയമായും ഈ സ്ഥലത്തുണ്ട്; ഞാനോ, അത് അറിഞ്ഞിരുന്നില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","അദ്ദേഹം ഭയപ്പെട്ട്, “ഈ സ്ഥലം എത്ര ഭയങ്കരം! ഇതു ദൈവഭവനമല്ലാതെ മറ്റൊന്നല്ല; ഇതു സ്വർഗത്തിന്റെ കവാടംതന്നെ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","പിറ്റേന്ന് അതിരാവിലെ യാക്കോബ്, താൻ തലയിണയായി വെച്ചിരുന്ന കല്ല് എടുത്ത് തൂണായി നാട്ടിനിർത്തി അതിനുമീതേ എണ്ണ ഒഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","അദ്ദേഹം ആ സ്ഥലത്തിനു ബേഥേൽ എന്നു പേരിട്ടു; ലൂസ് എന്ന പേരിലായിരുന്നു ആ പട്ടണം അറിയപ്പെട്ടിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ഇതിനുശേഷം യാക്കോബ് ഒരു നേർച്ച നേർന്നു: “ദൈവം എന്നോടുകൂടെയിരിക്കുകയും ഞാൻ പോകുന്ന ഈ യാത്രയിൽ എന്നെ കാത്തുകൊള്ളുകയും ഭക്ഷിക്കാൻ ആഹാരവും ധരിക്കാൻ വസ്ത്രവും നൽകുകയും ");
INSERT INTO malc_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","എന്റെ പിതാവിന്റെ ഭവനത്തിൽ സുരക്ഷിതമായി എന്നെ മടക്കിവരുത്തുകയും ചെയ്യുമെങ്കിൽ യഹോവ എന്റെ ദൈവമായിരിക്കും; ");
INSERT INTO malc_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ഞാൻ തൂണായി നാട്ടിയ കല്ല് ദൈവത്തിന്റെ ഭവനമായിത്തീരും; അവിടന്ന് എനിക്കു നൽകുന്ന എല്ലാറ്റിന്റെയും പത്തിലൊന്ന് ഞാൻ അവിടത്തേക്കു നൽകും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","യാക്കോബ് യാത്രതുടർന്ന് പൂർവദേശത്തെ ജനങ്ങളുടെ അടുത്തെത്തി. ");
INSERT INTO malc_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","അവിടെ വെളിമ്പ്രദേശത്ത് അയാൾ ഒരു കിണർ കണ്ടു: ആട്ടിൻപറ്റങ്ങൾക്ക് അതിൽനിന്ന് വെള്ളം കൊടുത്തിരുന്നതുകൊണ്ട് അതിനു സമീപം മൂന്ന് ആട്ടിൻപറ്റം കിടക്കുന്നുണ്ടായിരുന്നു. കിണറ്റിന്റെ വായ്ക്കൽ വെച്ചിരുന്ന കല്ല് വളരെ വലുതായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ആട്ടിൻപറ്റങ്ങൾ വന്നുകൂടുമ്പോൾ ഇടയന്മാർ കിണറ്റിന്റെ വായ്ക്കൽനിന്ന് കല്ല് ഉരുട്ടി നീക്കുകയും ആടുകൾക്ക് വെള്ളം കൊടുക്കുകയും ചെയ്യും. പിന്നെ കല്ല് കിണറിന്റെ വായ്ക്കൽ അതിന്റെ സ്ഥാനത്തു വെക്കും. ");
INSERT INTO malc_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","യാക്കോബ് ആട്ടിടയന്മാരോട്, “സഹോദരന്മാരേ, നിങ്ങൾ എവിടെനിന്നുള്ളവർ?” എന്നു ചോദിച്ചു. “ഞങ്ങൾ ഹാരാനിൽനിന്നുള്ളവർ” അവർ മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","അദ്ദേഹം അവരോട്, “നിങ്ങൾ നാഹോരിന്റെ പൗത്രനായ ലാബാനെ അറിയുമോ?” എന്നു ചോദിച്ചു. “ഞങ്ങൾ അറിയും,” അവർ ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“അദ്ദേഹം സുഖമായിരിക്കുന്നോ?” യാക്കോബ് അവരോട് അന്വേഷിച്ചു. “അദ്ദേഹം സുഖമായിരിക്കുന്നു. അതാ, അദ്ദേഹത്തിന്റെ മകൾ റാഹേൽ ആടുകളുമായി വരുന്നു,” അവർ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","“നോക്കൂ, പകലിനിയും വളരെയുണ്ടല്ലോ; ആട്ടിൻപറ്റങ്ങളെ കൂട്ടിച്ചേർക്കാൻ നേരമായിട്ടില്ല. ആടുകൾക്ക് വെള്ളം കൊടുത്തിട്ട് മേച്ചിൽപ്പുറത്തേക്കു കൊണ്ടുപോകുക,” യാക്കോബ് അവരോടു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“എല്ലാ കൂട്ടങ്ങളും വന്നുചേരുകയും കിണറ്റിന്റെ വായ്ക്കൽനിന്ന് കല്ലു മാറ്റുകയും വേണം. അപ്പോൾ ഞങ്ങൾ ആടുകൾക്ക് വെള്ളം കൊടുക്കും. അല്ലാതെ, തിരിച്ചുപോകാൻ സാധ്യമല്ല,” അവർ മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ഇങ്ങനെ യാക്കോബ് അവരുമായി സംസാരിച്ചുകൊണ്ടിരിക്കുമ്പോൾ റാഹേൽ തന്റെ അപ്പന്റെ ആടുകളുമായി അവിടെ എത്തി; അവളായിരുന്നു അതിനെ മേയിച്ചിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","തന്റെ അമ്മാവനായ ലാബാന്റെ മകളായ റാഹേലിനെയും ലാബാന്റെ ആടുകളെയും കണ്ടപ്പോൾ യാക്കോബ് അടുത്തുചെന്ന് കിണറ്റിന്റെ വായ്ക്കൽനിന്ന് കല്ല് ഉരുട്ടിമാറ്റിയിട്ട് അമ്മാവന്റെ ആടുകൾക്ക് വെള്ളം കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","പിന്നെ യാക്കോബ് റാഹേലിനെ ചുംബിച്ച് ഉച്ചത്തിൽ കരഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","താൻ അവളുടെ പിതാവിന്റെ ബന്ധുവും റിബേക്കയുടെ മകനുമാണെന്ന് യാക്കോബ് അവളോടു പറഞ്ഞു. അവൾ ഓടിച്ചെന്ന് വിവരം പിതാവിനെ അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ലാബാൻ തന്റെ സഹോദരിയുടെ മകനായ യാക്കോബിനെക്കുറിച്ചു കേട്ടയുടനെ അദ്ദേഹത്തെ എതിരേൽക്കാൻ ഓടിച്ചെന്നു. ലാബാൻ യാക്കോബിനെ കെട്ടിപ്പിടിച്ചു ചുംബിച്ച് വീട്ടിൽ കൊണ്ടുവന്നു. അവിടെവെച്ച് യാക്കോബ് എല്ലാക്കാര്യങ്ങളും ലാബാനോടു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","അപ്പോൾ ലാബാൻ യാക്കോബിനോട്, “നീ എന്റെ സ്വന്തം മാംസവും രക്തവും ആകുന്നു” എന്നു പറഞ്ഞു. യാക്കോബ് ലാബാനോടുകൂടെ ഒരുമാസം താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","അതിനുശേഷം ലാബാൻ യാക്കോബിനോട്, “നീ എന്റെ ബന്ധുവായതുകൊണ്ട് എനിക്കുവേണ്ടി പ്രതിഫലം കൂടാതെ ജോലി ചെയ്യണമെന്നുണ്ടോ? നിനക്ക് എന്തു പ്രതിഫലം വേണമെന്നു പറയൂ” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ലാബാനു രണ്ടു പെൺമക്കൾ ഉണ്ടായിരുന്നു; മൂത്തവളുടെ പേര് ലേയാ എന്നും ഇളയവളുടെ പേര് റാഹേൽ എന്നും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ലേയയുടെ കണ്ണുകൾ ശോഭകുറഞ്ഞതായിരുന്നു; എന്നാൽ, റാഹേൽ ആകാരഭംഗിയുള്ളവളും സുന്ദരിയുമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","യാക്കോബ് റാഹേലിനെ സ്നേഹിച്ചിരുന്നതുകൊണ്ട്, “അങ്ങയുടെ ഇളയ മകളായ റാഹേലിനുവേണ്ടി ഞാൻ ഏഴുവർഷം അങ്ങയെ സേവിക്കാം” എന്ന് അദ്ദേഹം ലാബാനോടു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","“അവളെ മറ്റൊരു പുരുഷനു കൊടുക്കുന്നതിനെക്കാൾ നിനക്കു തരുന്നതാണു നല്ലത്; എന്റെകൂടെ ഇവിടെ താമസിക്കുക” എന്നായിരുന്നു ലാബാന്റെ മറുപടി. ");
INSERT INTO malc_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","അങ്ങനെ യാക്കോബ് റാഹേലിനെ നേടുന്നതിനുവേണ്ടി ഏഴുവർഷം സേവിച്ചു. എന്നാൽ, അവളോടുള്ള സ്നേഹംനിമിത്തം ആ ഏഴുവർഷം അദ്ദേഹത്തിന് അൽപ്പകാലംമാത്രമായി അനുഭവപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","പിന്നെ യാക്കോബ് ലാബാനോട്, “ഇനി എനിക്ക് എന്റെ ഭാര്യയെ തരിക, എന്റെ കാലാവധി തികച്ചിരിക്കുന്നു, ഞാൻ അവളെ അറിയട്ടെ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ലാബാൻ ദേശവാസികളെ എല്ലാവരെയും വിളിച്ചുകൂട്ടി ഒരു വിരുന്നു നടത്തി. ");
INSERT INTO malc_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","രാത്രിയിൽ അദ്ദേഹം തന്റെ മകൾ ലേയയെ കൊണ്ടുചെന്ന് യാക്കോബിന്റെ അടുക്കൽ ആക്കി. യാക്കോബ് അവളെ അറിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ലാബാൻ തന്റെ വേലക്കാരിയായ സിൽപ്പയെ മകൾക്കു ദാസിയായി വിട്ടുകൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","നേരം പുലർന്നപ്പോൾ, അതു ലേയാ ആയിരുന്നെന്നു ഗ്രഹിച്ചിട്ട് യാക്കോബ് ലാബാനോട്, “താങ്കൾ എന്നോട് ചെയ്തതെന്ത്? ഞാൻ റാഹേലിനുവേണ്ടി അല്ലയോ അങ്ങയെ സേവിച്ചത്? എന്നെ കബളിപ്പിച്ചത് എന്തിന്?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","അതിനു ലാബാൻ: “മൂത്തവൾക്കു മുമ്പായി ഇളയവളുടെ വിവാഹം നടത്തുന്ന സമ്പ്രദായം ഇവിടെ ഞങ്ങൾക്കില്ല. ");
INSERT INTO malc_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ഇവളുടെ വിവാഹവാരം പൂർത്തിയാക്കുക, മറ്റൊരു ഏഴുവർഷത്തെ പ്രയത്നത്തിനു പ്രതിഫലമായി ഇളയവളെയും ഞങ്ങൾ നിനക്കു തരാം.” ");
INSERT INTO malc_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","യാക്കോബ് അങ്ങനെതന്നെ ചെയ്തു. അദ്ദേഹം ലേയായോടൊത്തുള്ള വിവാഹവാരം പൂർത്തീകരിച്ചു. പിന്നീട് ലാബാൻ തന്റെ മകളായ റാഹേലിനെയും യാക്കോബിന് ഭാര്യയായി നൽകി. ");
INSERT INTO malc_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ലാബാൻ തന്റെ വേലക്കാരിയായ ബിൽഹയെ മകളായ റാഹേലിനു ദാസിയായി കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","യാക്കോബ് റാഹേലിനെ അറിഞ്ഞു. അദ്ദേഹം ലേയയെക്കാൾ കൂടുതലായി റാഹേലിനെ സ്നേഹിച്ചു; ലാബാനുവേണ്ടി അദ്ദേഹം മറ്റൊരു ഏഴുവർഷംകൂടി പണിയെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ലേയാ അവഗണിക്കപ്പെടുന്നു എന്നുകണ്ട് യഹോവ അവളുടെ ഗർഭം തുറന്നു; റാഹേലോ, വന്ധ്യയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ലേയാ ഗർഭംധരിച്ച് ഒരു മകനെ പ്രസവിച്ചു. “ഇത് യഹോവ എന്റെ സങ്കടം കണ്ടതുകൊണ്ടാണ്; എന്റെ ഭർത്താവു നിശ്ചയമായും ഇപ്പോൾ എന്നെ സ്നേഹിക്കും,” എന്നു പറഞ്ഞുകൊണ്ട് അവൾ അവന് രൂബേൻ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","അവൾ വീണ്ടും ഗർഭംധരിച്ച് ഒരു മകനെ പ്രസവിച്ചു. “എന്നോടു സ്നേഹമില്ല എന്ന് യഹോവ കേട്ടിരിക്കുന്നു; അതുകൊണ്ട് അവിടന്ന് ഇവനെയും എനിക്കു തന്നു” എന്നു പറഞ്ഞ് അവൾ അവന് ശിമെയോൻ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","അവൾ പിന്നെയും ഗർഭംധരിച്ചു, ഒരു മകനെ പ്രസവിച്ചു. “എന്റെ ഭർത്താവിനു ഞാൻ മൂന്നു പുത്രന്മാരെ പ്രസവിച്ചിരിക്കുകയാൽ അദ്ദേഹം എന്നോടു പറ്റിച്ചേരും” എന്ന് അവൾ പറഞ്ഞു. അവൾ അവന് ലേവി എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","അവൾ വീണ്ടും ഗർഭിണിയായി, ഒരു മകനെ പ്രസവിച്ചു. “ഇപ്പോൾ ഞാൻ യഹോവയെ വാഴ്ത്തുന്നു” എന്നു പറഞ്ഞ് അവൾ അവന് യെഹൂദാ എന്നു പേരിട്ടു. പിന്നെ അവൾക്കു കുട്ടികൾ ജനിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","താൻ യാക്കോബിനു മക്കളെ പ്രസവിക്കുന്നില്ല എന്നുകണ്ടപ്പോൾ റാഹേലിന് സഹോദരിയോട് അസൂയയുണ്ടായി. അതുകൊണ്ട് അവൾ യാക്കോബിനോട്, “എനിക്കു കുട്ടികളെ തരിക, അല്ലെങ്കിൽ ഞാൻ മരിച്ചുപോകും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","യാക്കോബ് കോപിച്ചുകൊണ്ട് അവളോട്, “നിനക്കു കുട്ടികളെ തരാതിരിക്കുന്ന ദൈവത്തിന്റെ സ്ഥാനത്തോ ഞാൻ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","അപ്പോൾ അവൾ, “ഇതാ എന്റെ ദാസിയായ ബിൽഹാ, അവളുടെയടുക്കൽ ചെല്ലുക; അവൾ എനിക്കായി കുട്ടികളെ പ്രസവിക്കയും അവളിലൂടെ എനിക്കു കുടുംബം കെട്ടിപ്പടുക്കാൻ സാധിക്കയും ചെയ്യുമല്ലോ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","അതുകൊണ്ട് അവൾ തന്റെ ദാസിയായ ബിൽഹയെ യാക്കോബിനു ഭാര്യയായി കൊടുത്തു. യാക്കോബ് അവളുടെയടുത്ത് ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ബിൽഹ ഗർഭംധരിച്ച് യാക്കോബിന് ഒരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","അപ്പോൾ റാഹേൽ, “ദൈവം എന്നെ കുറ്റവിമുക്തയാക്കി, എന്റെ പ്രാർഥനകേട്ട് എനിക്ക് ഒരു മകനെ തന്നിരിക്കുന്നു” എന്നു പറഞ്ഞു. അതുകൊണ്ട് അവൾ അവന് ദാൻ എന്നു പേരുവിളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","റാഹേലിന്റെ ദാസി ബിൽഹാ വീണ്ടും ഗർഭംധരിച്ച് യാക്കോബിനു രണ്ടാമതൊരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","“എന്റെ സഹോദരിയോട് എനിക്കു കടുത്ത മത്സരം വേണ്ടിവന്നു; അതിൽ ഞാൻ വിജയിച്ചു,” എന്നു പറഞ്ഞു. അതുകൊണ്ട് അവൾ അവന് നഫ്താലി എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","തനിക്ക് ഇനി കുട്ടികൾ ഉണ്ടാകുകയില്ല എന്നുകണ്ട് ലേയാ അവളുടെ ദാസിയായ സിൽപ്പയെ യാക്കോബിന്റെ അടുക്കൽ കൊണ്ടുചെന്ന് അവന് ഭാര്യയായി കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ലേയയുടെ ദാസി സിൽപ്പ യാക്കോബിന് ഒരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","“ഞാൻ എത്ര ഭാഗ്യവതി!” എന്നു പറഞ്ഞ് അവൾ അവന് ഗാദ് എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ലേയയുടെ ദാസിയായ സിൽപ്പ യാക്കോബിനു രണ്ടാമതും ഒരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","അപ്പോൾ അവൾ, “ഞാൻ എത്ര സന്തുഷ്ട! സ്ത്രീകൾ എന്നെ സന്തുഷ്ട എന്നു വിളിക്കും” എന്നു പറഞ്ഞു. അതുകൊണ്ട് അവൾ അവന് ആശേർ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ഗോതമ്പുകൊയ്ത്തിന്റെ കാലത്ത് രൂബേൻ വയലിലേക്കുപോയി, കുറെ ദൂദായിപ്പഴം കണ്ടെത്തി. അവൻ അതു തന്റെ അമ്മയായ ലേയയ്ക്കു കൊടുത്തു. അപ്പോൾ റാഹേൽ ലേയായോട്, “നിന്റെ മകന്റെ ദൂദായിപ്പഴത്തിൽ കുറച്ച് എനിക്കു തരാമോ” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","എന്നാൽ ലേയാ അവളോട്, “നീ എന്റെ ഭർത്താവിനെ തട്ടിയെടുത്തതു പോരയോ? ഇനി എന്റെ മകന്റെ ദൂദായിപ്പഴംകൂടി എടുക്കുമോ?” എന്നു ചോദിച്ചു. “എങ്കിൽ നിന്റെ മകന്റെ ദൂദായിപ്പഴത്തിനു പ്രതിഫലമായി അദ്ദേഹം ഈ രാത്രി നിന്നോടൊത്തു കിടക്കപങ്കിടട്ടെ,” റാഹേൽ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","അന്നു വൈകുന്നേരം യാക്കോബ് വയലിൽനിന്ന് വന്നപ്പോൾ ലേയാ അദ്ദേഹത്തെ വരവേൽക്കാൻ ചെന്നു; “ഇന്ന് എന്റെ അടുക്കൽ വരണം. എന്റെ മകന്റെ ദൂദായിപ്പഴം കൊടുത്തു ഞാൻ അങ്ങയെ കൂലിക്കെടുത്തിരിക്കുന്നു.” എന്ന് അവൾ പറഞ്ഞു. ആ രാത്രിയിൽ അദ്ദേഹം അവളോടുകൂടെ കിടക്കപങ്കിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ദൈവം ലേയായുടെ അപേക്ഷ കേട്ടു; അവൾ ഗർഭിണിയായി യാക്കോബിന്റെ അഞ്ചാമത്തെ മകനെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","അപ്പോൾ ലേയാ, “എന്റെ ഭർത്താവിന് എന്റെ ദാസിയെ കൊടുത്തതുകൊണ്ട് ദൈവം എനിക്കു പ്രതിഫലം തന്നിരിക്കുന്നു” എന്നു പറഞ്ഞു. അതുകൊണ്ട് അവൾ അവന് യിസ്സാഖാർ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ലേയാ പിന്നെയും ഗർഭംധരിച്ച് യാക്കോബിന് ആറാമതൊരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","“ദൈവം എനിക്കൊരു അമൂല്യസമ്മാനം തന്നിരിക്കുന്നു. ഞാൻ എന്റെ ഭർത്താവിന് ആറു പുത്രന്മാരെ പ്രസവിച്ചതുകൊണ്ട് അദ്ദേഹം എന്നെ ഇപ്പോൾ ആദരിക്കും,” എന്നു ലേയാ പറഞ്ഞു. അതുകൊണ്ട് അവന് അവൾ സെബൂലൂൻ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","കുറെക്കാലത്തിനുശേഷം അവൾ ഒരു മകളെ പ്രസവിച്ചു; അവൾക്കു ദീനാ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","അപ്പോൾ ദൈവം റാഹേലിനെ ഓർത്തു. അവിടന്ന് അവളുടെ അപേക്ഷകേട്ട് അവളുടെ ഗർഭം തുറന്നു. ");
INSERT INTO malc_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","അവൾ ഗർഭിണിയായി ഒരു മകനെ പ്രസവിച്ചു. അപ്പോൾ അവൾ, “ദൈവം എന്റെ അപമാനം നീക്കിയിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","“യഹോവ എനിക്കു മറ്റൊരു മകനെക്കൂടി തരുമാറാകട്ടെ,” എന്നു പറഞ്ഞ് അവൾ അവന് യോസേഫ് എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","റാഹേൽ യോസേഫിനെ പ്രസവിച്ചതിനുശേഷം യാക്കോബ് ലാബാനോട്, “എനിക്ക് സ്വന്തം ദേശത്തേക്കു മടങ്ങണം; അങ്ങ് എന്നെ യാത്രയാക്കിയാലും. ");
INSERT INTO malc_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","എന്റെ ഭാര്യമാരെയും മക്കളെയും എനിക്കു തരണം; അവർക്കുവേണ്ടിയാണല്ലോ ഞാൻ അങ്ങയെ സേവിച്ചത്! ഞാൻ യാത്രയായിക്കോട്ടെ. ഞാൻ അങ്ങേക്കുവേണ്ടി എത്രമാത്രം അധ്വാനിച്ചു എന്ന് അങ്ങേക്ക് അറിയാമല്ലോ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","എന്നാൽ ലാബാൻ യാക്കോബിനോട്, “നിനക്ക് എന്നോടു പ്രീതിയുണ്ടെങ്കിൽ ദയവുചെയ്ത് ഇവിടെ താമസിക്കുക. നീ നിമിത്തം യഹോവ എന്നെ അനുഗ്രഹിച്ചെന്ന് ഞാൻ പ്രശ്നംവെച്ചതിലൂടെ സ്പഷ്ടമായി അറിഞ്ഞിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","“നിനക്ക് എന്തു ശമ്പളം വേണമെന്നു പറയുക, ഞാൻ അതു തരാം,” എന്നും ലാബാൻ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","അതിന് യാക്കോബ് അദ്ദേഹത്തോട് ഉത്തരം പറഞ്ഞത്, “ഞാൻ അങ്ങേക്കുവേണ്ടി എങ്ങനെ പണിയെടുത്തെന്നും എന്റെ മേൽനോട്ടത്തിൽ അങ്ങയുടെ ആടുമാടുകൾ എത്ര പെരുകിയെന്നും അങ്ങേക്ക് അറിയാമല്ലോ. ");
INSERT INTO malc_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ഞാൻ വരുന്നതിനുമുമ്പ് അൽപ്പംമാത്രം ഉണ്ടായിരുന്നത് ഇപ്പോൾ അത്യധികം വർധിച്ചിരിക്കുന്നു. ഞാൻ ആയിരുന്നേടത്തെല്ലാം യഹോവ അങ്ങയെ അനുഗ്രഹിച്ചിരിക്കുന്നു. എന്നാൽ, എന്റെ സ്വന്തം കുടുംബത്തിനുവേണ്ടി ഞാൻ ഇനി എപ്പോഴാണു വല്ലതും കരുതുന്നത്?” ");
INSERT INTO malc_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","“ഞാൻ നിനക്ക് എന്തു തരണം?” ലാബാൻ ചോദിച്ചു. “എനിക്ക് ഒന്നും തരേണ്ടതില്ല,” യാക്കോബ് പറഞ്ഞു. “എന്നാൽ, എനിക്കുവേണ്ടി ഒരു കാര്യം ചെയ്യുമെങ്കിൽ ഞാൻ അങ്ങയുടെ ആട്ടിൻപറ്റങ്ങളെ മേയിക്കുകയും സൂക്ഷിക്കുകയുംചെയ്യാം. ");
INSERT INTO malc_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ഇന്നു ഞാൻ അങ്ങയുടെ എല്ലാ ആട്ടിൻപറ്റങ്ങളുടെയും ഇടയിലൂടെ നടന്ന് പുള്ളിയും മറുകും ഉള്ള ചെമ്മരിയാടുകളെയും കറുപ്പുനിറമുള്ള എല്ലാ ചെമ്മരിയാട്ടിൻകുട്ടികളെയും പുള്ളിയും മറുകുമുള്ള കോലാടുകളെയും വേർതിരിക്കും; അവ എനിക്കുള്ള പ്രതിഫലമായിരിക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ഭാവിയിൽ അങ്ങ് എന്റെ പ്രതിഫലം പരിശോധിക്കുമ്പോൾ എന്റെ വിശ്വസ്തത അങ്ങേക്കു ബോധ്യമാകും. എന്റെപക്കൽ പുള്ളിയോ മറുകോ ഇല്ലാത്ത കോലാടോ കറുപ്പുനിറമില്ലാത്ത ആട്ടിൻകുട്ടിയോ കണ്ടാൽ അതിനെ മോഷ്ടിച്ചതായി കണക്കാക്കാം.” ");
INSERT INTO malc_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","അപ്പോൾ ലാബാൻ, “ഇത് എനിക്കു സമ്മതം; നീ പറഞ്ഞതുപോലെ ആകട്ടെ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ആ ദിവസംതന്നെ ലാബാൻ വരയും മറുകും ഉള്ള കോലാട്ടുകൊറ്റന്മാരെയും പുള്ളിയും മറുകും ഉള്ള പെൺകോലാടുകളെയും വെള്ളനിറമുള്ള എല്ലാറ്റിനെയും കറുപ്പുനിറമുള്ള ചെമ്മരിയാട്ടിൻകുട്ടികളെയും വേർതിരിച്ചു തന്റെ പുത്രന്മാരുടെ പക്കൽ ഏൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","പിന്നെ ലാബാൻ തനിക്കും യാക്കോബിനും മധ്യേ മൂന്നുദിവസത്തെ വഴിയകലം വെച്ചു. ലാബാന്റെ ആടുകളിൽ ശേഷിച്ചവയെ യാക്കോബ് തുടർന്നും മേയിച്ചുകൊണ്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","യാക്കോബ് പുന്നമരത്തിന്റെയും ബദാംമരത്തിന്റെയും അരിഞ്ഞിൽമരത്തിന്റെയും പച്ചക്കൊമ്പുകൾ എടുത്ത് അവയുടെ അകം വെള്ളവരയായി കാണത്തക്കവണ്ണം തൊലിയുരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","പിന്നെ അദ്ദേഹം, ഇങ്ങനെ തൊലിയുരിച്ച കൊമ്പുകൾ, ആടുകൾ വെള്ളം കുടിക്കാൻ വരുമ്പോൾ അവയ്ക്ക് നേരേ കാണത്തക്കവണ്ണം, വെള്ളം നിറയ്ക്കുന്ന തൊട്ടികളിലും പാത്തികളിലും വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ആടുകൾ വെള്ളം കുടിക്കാൻ വന്നപ്പോൾ ആ കൊമ്പുകൾക്കു മുന്നിൽവെച്ച് ഇണചേർന്നു; അവ വരയും പുള്ളിയും മറുകും ഉള്ള കുട്ടികളെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","യാക്കോബ് ആ ആട്ടിൻകുട്ടികളെ ലാബാന്റെ ആട്ടിൻപറ്റത്തിൽനിന്ന് വേർതിരിച്ചു; ശേഷമുള്ളവ ഇണചേരുമ്പോൾ ലാബാന്റെവക വരയും കറുപ്പുമുള്ള ആടുകൾക്ക് അഭിമുഖമായി നിർത്തി. ഇങ്ങനെ യാക്കോബ് തനിക്കു സ്വന്തമായി ആട്ടിൻപറ്റങ്ങളെ ഉണ്ടാക്കി; അവയെ ലാബാന്റെ കൂട്ടങ്ങളോടു ചേർത്തില്ല. ");
INSERT INTO malc_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","കരുത്തുള്ള ആടുകൾ ഇണചേരുമ്പോൾ അവ ആ മരക്കൊമ്പുകൾ കണ്ട് ചനയേൽക്കേണ്ടതിന് യാക്കോബ് അവ തൊട്ടികളിൽവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","കരുത്തുകുറഞ്ഞവയുടെ മുമ്പിൽ കൊമ്പുകൾ വെച്ചിരുന്നില്ല. ഇങ്ങനെ കരുത്തില്ലാത്തവ ലാബാനും കരുത്തുള്ളവ യാക്കോബിനും ആയിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","യാക്കോബ് ഈ വിധത്തിൽ മഹാധനികനായി. വലിയ ആട്ടിൻപറ്റങ്ങളും ധാരാളം ദാസീദാസന്മാരും ഒട്ടകങ്ങളും കഴുതകളും അദ്ദേഹത്തിനു സ്വന്തമായി. ");
INSERT INTO malc_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","“ഞങ്ങളുടെ അപ്പന്റെ സ്വന്തമായിരുന്നതെല്ലാം യാക്കോബ് എടുത്തു; അപ്പന്റെ സ്വത്തിൽനിന്ന് അദ്ദേഹം ഈ ധനമെല്ലാം സമ്പാദിച്ചിരിക്കുന്നു,” എന്നു ലാബാന്റെ പുത്രന്മാർ പറയുന്നതായി യാക്കോബ് കേട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ലാബാനു തന്നോടുള്ള മനോഭാവം പണ്ടത്തേതിൽനിന്ന് മാറിപ്പോയിരിക്കുന്നു എന്നതും യാക്കോബ് ശ്രദ്ധിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","അപ്പോൾ യഹോവ യാക്കോബിനോട്, “നിന്റെ പിതാക്കന്മാരുടെ ദേശത്തേക്കും നിന്റെ ബന്ധുക്കളുടെ അടുത്തേക്കും മടങ്ങിപ്പോകുക; ഞാൻ നിന്നോടുകൂടെ ഉണ്ടായിരിക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","യാക്കോബ് ആളയച്ച് റാഹേലിനെയും ലേയയെയും തന്റെ ആട്ടിൻപറ്റങ്ങൾ മേയുന്ന വയലിലേക്കു വിളിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","അദ്ദേഹം അവരോടു പറഞ്ഞു: “നിങ്ങളുടെ അപ്പന് എന്നോടുള്ള മനോഭാവം മാറിപ്പോയിരിക്കുന്നു എന്നു ഞാൻ കാണുന്നു; എന്നാൽ എന്റെ പിതാവിന്റെ ദൈവം ഇതുവരെയും എന്നോടുകൂടെയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","എന്റെ കഴിവു മുഴുവൻ ഉപയോഗിച്ചു ഞാൻ നിങ്ങളുടെ അപ്പനുവേണ്ടി ജോലിചെയ്തുവെന്നു നിങ്ങൾക്കറിയാമല്ലോ; ");
INSERT INTO malc_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","എന്നാൽ നിങ്ങളുടെ അപ്പൻ പത്തുപ്രാവശ്യം എന്റെ പ്രതിഫലം മാറ്റുകയും അങ്ങനെ എന്നെ കബളിപ്പിക്കുകയും ചെയ്തു. ഏതായിരുന്നാലും എനിക്കു ദോഷം ചെയ്യാൻ ദൈവം അദ്ദേഹത്തെ അനുവദിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","‘പുള്ളിയുള്ളവ നിന്റെ പ്രതിഫലമായിരിക്കട്ടെ’ എന്ന് അദ്ദേഹം പറഞ്ഞപ്പോൾ ആട്ടിൻപറ്റങ്ങളെല്ലാം പുള്ളിയുള്ള കുട്ടികളെ പ്രസവിച്ചു; ‘വരയുള്ളതെല്ലാം നിന്റെ പ്രതിഫലമായിരിക്കട്ടെ’ എന്ന് അദ്ദേഹം പറഞ്ഞപ്പോഴെല്ലാം ആട്ടിൻപറ്റങ്ങൾ വരയുള്ള കുട്ടികളെ പെറ്റു. ");
INSERT INTO malc_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","അങ്ങനെ ദൈവം നിങ്ങളുടെ അപ്പന്റെ ആട്ടിൻപറ്റത്തെ എടുത്ത് എനിക്കു തന്നിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“ആടുകൾ ചനയേൽക്കുന്ന കാലത്ത്, ഇണചേരുന്ന മുട്ടാടുകൾ വരയും പുള്ളിയും മറുകും ഉള്ളവയാണെന്ന് ഞാൻ സ്വപ്നത്തിൽ കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ദൈവത്തിന്റെ ദൂതൻ എന്നെ സ്വപ്നത്തിൽ ‘യാക്കോബേ,’ എന്നു വിളിച്ചു. ‘അടിയൻ ഇതാ’ എന്നു ഞാൻ ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","അപ്പോൾ അവിടന്ന്: ‘നീ തലയുയർത്തി നോക്കുക, ഇണചേരുന്ന മുട്ടാടുകൾ വരയും പുള്ളിയും മറുകും ഉള്ളവതന്നെ; ലാബാൻ നിന്നോടു ചെയ്തുപോന്നതെല്ലാം ഞാൻ കണ്ടിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","നീ തൂണിനെ അഭിഷേകംചെയ്തതും എന്നോടു ശപഥംചെയ്തതുമായ ബേഥേലിലെ ദൈവമാണ് ഞാൻ. നീ ഉടൻതന്നെ ഈ ദേശംവിട്ട് നിന്റെ സ്വദേശത്തേക്കു മടങ്ങിപ്പോകുക എന്ന് അരുളിച്ചെയ്തു.’ ” ");
INSERT INTO malc_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","അപ്പോൾ റാഹേലും ലേയയും ഇങ്ങനെ മറുപടി പറഞ്ഞു: “ഞങ്ങളുടെ പിതാവിന്റെ സ്വത്തിൽ ഞങ്ങൾക്ക് അവകാശപ്പെട്ട ഓഹരി ഇനി എന്തെങ്കിലും അവശേഷിക്കുന്നുണ്ടോ? ");
INSERT INTO malc_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","അദ്ദേഹം ഞങ്ങളെ പ്രവാസികളായിട്ടല്ലയോ കണക്കാക്കുന്നത്? ഞങ്ങളെ വിൽക്കുകമാത്രമല്ല, ഞങ്ങളുടെ വിലയായി ലഭിച്ചത് ഉപയോഗിച്ചുതീർക്കുകയും ചെയ്തിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ഞങ്ങളുടെ പിതാവിന്റെ പക്കൽനിന്ന് ദൈവം നീക്കംചെയ്ത സ്വത്തുക്കൾ എല്ലാം ഞങ്ങൾക്കും ഞങ്ങളുടെ കുഞ്ഞുങ്ങൾക്കും ഉള്ളതാണ്. അതുകൊണ്ട് ദൈവം അങ്ങയോട് എന്തു പറഞ്ഞിരിക്കുന്നോ അതു ചെയ്തുകൊൾക.” ");
INSERT INTO malc_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ഇതിനുശേഷം യാക്കോബ് തന്റെ കുട്ടികളെയും ഭാര്യമാരെയും ഒട്ടകങ്ങളുടെ പുറത്തു കയറ്റി; ");
INSERT INTO malc_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","തനിക്കുള്ള സകല ആടുമാടുകളും പദ്ദൻ-അരാമിൽവെച്ചു സമ്പാദിച്ച എല്ലാ വസ്തുക്കളും തനിക്കുമുമ്പേ അയച്ചു; ഇങ്ങനെ കനാൻദേശത്തു തന്റെ പിതാവായ യിസ്ഹാക്കിന്റെ അടുക്കലേക്ക് അദ്ദേഹം യാത്രപുറപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ലാബാൻ തന്റെ ആടുകളുടെ രോമം കത്രിക്കുന്നതിനു പോയിരുന്നപ്പോൾ റാഹേൽ അവളുടെ അപ്പന്റെ ഗൃഹബിംബങ്ങൾ മോഷ്ടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","യാക്കോബും താൻ ഓടിപ്പോകുന്നെന്ന് അരാമ്യനായ ലാബാനോട് അറിയിക്കാതിരുന്നതു നിമിത്തം അദ്ദേഹത്തെ കബളിപ്പിച്ചാണു പോയത്. ");
INSERT INTO malc_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","അങ്ങനെ തനിക്കുള്ള സകലവുമായി യാക്കോബ് ഓടിപ്പോയി; അദ്ദേഹം യൂഫ്രട്ടീസ് നദികടന്ന് ഗിലെയാദ് പർവതം ലക്ഷ്യമാക്കി യാത്രതുടർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","യാക്കോബ് ഓടിപ്പോയി എന്നു മൂന്നാംദിവസം ലാബാന് അറിവുലഭിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","അദ്ദേഹം തന്റെ ബന്ധുക്കളെക്കൂട്ടി ഏഴുദിവസം യാക്കോബിനെ പിൻതുടർന്നു; ഗിലെയാദിലെ മലമ്പ്രദേശത്തുവെച്ച് യാക്കോബിനൊപ്പമെത്തി. ");
INSERT INTO malc_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","എന്നാൽ, ദൈവം രാത്രിയിൽ—അരാമ്യനായ ലാബാന്റെ അടുക്കൽ—സ്വപ്നത്തിൽ വന്ന് അയാളോട്, “നീ യാക്കോബിനോടു ഗുണമോ ദോഷമോ പറയാതിരിക്കാൻ സൂക്ഷിക്കുക” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ലാബാൻ തന്റെ മുന്നിൽ കയറിയ സമയം യാക്കോബ് ഗിലെയാദിലെ മലമ്പ്രദേശത്തു കൂടാരം അടിച്ചിരുന്നു. ലാബാനും തന്റെ ബന്ധുക്കളോടൊപ്പം ഗിലെയാദ് പർവതത്തിൽ കൂടാരം അടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","പിന്നെ ലാബാൻ യാക്കോബിനോടു പറഞ്ഞു: “നീ എന്താണു ചെയ്തത്? എന്നെ കബളിപ്പിച്ച് എന്റെ പെൺമക്കളെ യുദ്ധത്തടവുകാരെപ്പോലെ കൊണ്ടുപോന്നിരിക്കുന്നു! ");
INSERT INTO malc_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","എന്തിനാണ് ഒളിച്ചോടുകയും എന്നെ വഞ്ചിക്കുകയും ചെയ്തത്? എന്നോടു നീ പറയാതിരുന്നതെന്ത്? പറഞ്ഞിരുന്നെങ്കിൽ ഞാൻ നിന്നെ തംബുരു, കിന്നരം എന്നിവയുടെ സംഗീതത്തോടുകൂടി സന്തോഷത്തോടെ യാത്രയയയ്ക്കുമായിരുന്നു? ");
INSERT INTO malc_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","എന്റെ കൊച്ചുമക്കളെയും പെൺമക്കളെയും ചുംബിച്ചു യാത്രയയയ്ക്കാനുള്ള അവസരംപോലും നീ എനിക്കു തന്നില്ല. നീ ചെയ്തത് ഭോഷത്തമാണ്. ");
INSERT INTO malc_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","നിനക്കു ദോഷം ചെയ്യാൻ എനിക്കു ശക്തിയുണ്ട്; എന്നാൽ, കഴിഞ്ഞരാത്രിയിൽ നിന്റെ അപ്പന്റെ ദൈവം ‘യാക്കോബിനോടു ഗുണമോ ദോഷമോ ഒന്നും പറയാതിരിക്കാൻ സൂക്ഷിക്കുക’ എന്ന് എന്നോടു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","നീ ഇപ്പോൾ അപ്പന്റെ വീട്ടിൽ എത്താനുള്ള മോഹംകൊണ്ടാണു പോന്നത്. ആകട്ടെ, എന്റെ ദേവന്മാരെ നീ മോഷ്ടിച്ചതെന്തിന്?” ");
INSERT INTO malc_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","അതിനുത്തരമായി യാക്കോബ് ലാബാനോടു പറഞ്ഞു: “അങ്ങു ബലം പ്രയോഗിച്ച് അങ്ങയുടെ പെൺമക്കളെ എന്റെ പക്കൽനിന്നു കൊണ്ടുപോകും എന്നു ഞാൻ ചിന്തിച്ച് ഭയപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","എന്നാൽ, അങ്ങയുടെ ദേവന്മാരെ ആരുടെയെങ്കിലും കൈവശം കണ്ടാൽ ആ വ്യക്തി ജീവിച്ചിരിക്കരുത്. അങ്ങയുടെ വസ്തുക്കളിൽ എന്തെങ്കിലും ഇവിടെ എന്റെപക്കൽ ഉണ്ടോ എന്ന് നമ്മുടെ ബന്ധുക്കളുടെമുമ്പിൽവെച്ചു പരിശോധിക്കുക; ഉണ്ടെങ്കിൽ എടുത്തുകൊള്ളുക.” എന്നാൽ, റാഹേൽ അവയെ മോഷ്ടിച്ചത് യാക്കോബ് അറിഞ്ഞിരുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ലാബാൻ യാക്കോബിന്റെ കൂടാരത്തിലും ലേയായുടെ കൂടാരത്തിലും ദാസിമാരുടെ രണ്ടുപേരുടെയും കൂടാരത്തിലും ചെന്നു; എന്നാൽ ഒന്നും കണ്ടെടുത്തില്ല. ലേയയുടെ കൂടാരത്തിൽനിന്നു പുറത്തുവന്നതിനുശേഷം അദ്ദേഹം റാഹേലിന്റെ കൂടാരത്തിലേക്കുചെന്നു. ");
INSERT INTO malc_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","റാഹേൽ ഗൃഹബിംബങ്ങളെ എടുത്ത് ഒട്ടകത്തിന്റെ ജീനിയിൽ വെച്ചിട്ട് അതിന്മേൽ ഇരിക്കുകയായിരുന്നു. ലാബാൻ കൂടാരത്തിനുള്ളിലുള്ള സകലതും പരിശോധിച്ചെങ്കിലും ഒന്നും കണ്ടെത്തിയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","റാഹേൽ തന്റെ പിതാവിനോട്, “പ്രഭോ, അങ്ങു കോപിക്കരുതേ, അടിയന് സ്ത്രീകൾക്കുള്ള പതിവു വന്നിരിക്കുന്നതിനാൽ അങ്ങയുടെ സന്നിധിയിൽ എഴുന്നേറ്റു നിൽക്കാൻ വയ്യാ” എന്നു പറഞ്ഞു. അദ്ദേഹം എല്ലായിടത്തും ഗൃഹബിംബങ്ങൾ അന്വേഷിച്ചെങ്കിലും കണ്ടെത്തിയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","യാക്കോബ് കോപിഷ്ഠനായി; അദ്ദേഹം ലാബാനോടു കയർത്തു: “എന്താണ് എന്റെ കുറ്റം? എന്നെ വേട്ടയാടാൻ ഞാൻ ചെയ്ത അപരാധം എന്ത്? ");
INSERT INTO malc_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","താങ്കൾ എന്റെ വസ്തുവകകളെല്ലാം അരിച്ചുപെറുക്കി നോക്കിയല്ലോ! താങ്കളുടെ വീട്ടിലെ ഏതെങ്കിലും സാധനം കണ്ടെടുത്തോ? എങ്കിൽ അത് ഇവിടെ താങ്കളുടെയും എന്റെയും ബന്ധുക്കളുടെയും മുമ്പാകെ വെക്കുക; അവർ നമുക്കു രണ്ടുപേർക്കും മധ്യേ ന്യായംവിധിക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“കഴിഞ്ഞ ഇരുപതുവർഷം ഞാൻ താങ്കളുടെകൂടെ ജീവിച്ചു; താങ്കളുടെ ചെമ്മരിയാടുകൾക്കോ കോലാടുകൾക്കോ ഗർഭനാശം സംഭവിച്ചില്ല; ആട്ടിൻപറ്റങ്ങളിൽനിന്ന് ആട്ടുകൊറ്റന്മാരെ ഞാൻ തിന്നിട്ടുമില്ല. ");
INSERT INTO malc_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","വന്യജന്തുക്കൾ കീറിക്കളഞ്ഞവയെ ഞാൻ താങ്കളുടെ അടുക്കൽ എത്തിച്ചില്ല; നഷ്ടം ഞാൻതന്നെ സഹിച്ചു. പകലാകട്ടെ രാത്രിയാകട്ടെ, മോഷ്ടിക്കപ്പെട്ട സകലതിന്റെയും വില താങ്കൾ എന്നോട് ആവശ്യപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","എന്റെ സ്ഥിതി ഇതായിരുന്നു: പകലിൽ അത്യുഷ്ണവും രാത്രിയിൽ അതിശൈത്യവും എന്നെ ക്ഷയിപ്പിച്ചു; എന്റെ കണ്ണുകൾക്ക് ഉറക്കം ഇല്ലാതെയായി. ");
INSERT INTO malc_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ഞാൻ താങ്കളുടെ വീട്ടിൽ ചെലവഴിച്ച ഇരുപതുവർഷവും സ്ഥിതി ഇതുതന്നെ ആയിരുന്നു. താങ്കളുടെ രണ്ടു പുത്രിമാർക്കുവേണ്ടി പതിന്നാലു വർഷവും താങ്കളുടെ ആട്ടിൻപറ്റങ്ങൾക്കുവേണ്ടി ആറു വർഷവും ഞാൻ താങ്കളെ സേവിച്ചു; താങ്കൾ പത്തുപ്രാവശ്യം എന്റെ പ്രതിഫലം മാറ്റി. ");
INSERT INTO malc_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","എന്റെ പിതാവിന്റെ ദൈവം—അതേ, അബ്രാഹാമിന്റെ ദൈവവും യിസ്ഹാക്കിന്റെ ഭയവുമായവൻ—എന്നോടുകൂടെ ഇല്ലായിരുന്നെങ്കിൽ താങ്കൾ എന്നെ വെറുംകൈയോടെ അയച്ചുകളയുമായിരുന്നു. എന്നാൽ ദൈവം എന്റെ കഷ്ടപ്പാടും എന്റെ കൈകളുടെ അത്യധ്വാനവും കാണുകയും കഴിഞ്ഞരാത്രിയിൽ താങ്കളെ ശാസിക്കുകയും ചെയ്തിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","അതിനു ലാബാൻ യാക്കോബിനോട്: “ഈ സ്ത്രീകൾ എന്റെ പുത്രിമാർ; ഈ പുത്രന്മാർ എന്റെ പുത്രന്മാർ; ഈ ആട്ടിൻപറ്റം എന്റെ ആട്ടിൻപറ്റം. നീ കാണുന്നതെല്ലാം എന്റേത്. എന്റെ പുത്രിമാരോടോ അവർ പ്രസവിച്ച പുത്രന്മാരോടോ ഞാൻ എന്തു ചെയ്യാനാണ്? ");
INSERT INTO malc_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ഇപ്പോൾ വരിക, ഞാനും നീയുംതമ്മിൽ ഒരു ഉടമ്പടി ചെയ്യാം; അത് എനിക്കും നിനക്കും മധ്യേ സാക്ഷിയായിരിക്കട്ടെ” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","അങ്ങനെ യാക്കോബ് ഒരു കല്ല് എടുത്തു തൂണാക്കി നാട്ടി. ");
INSERT INTO malc_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","അദ്ദേഹം തന്റെ ബന്ധുക്കളോട്: “കുറെ കല്ലുകൾ ശേഖരിക്കുക” എന്നു പറഞ്ഞു. അവർ കല്ലുകൾ ശേഖരിച്ച് ഒരു കൂമ്പാരമായി കൂട്ടി; അതിനുശേഷം അവർ അതിനരികിൽ ഇരുന്ന് ആഹാരം കഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ലാബാൻ അതിന് യെഗർ-സാഹദൂഥാ എന്നും യാക്കോബ്, ഗലേദ് എന്നും പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","പിന്നെ ലാബാൻ: “ഈ കൂമ്പാരം ഇന്ന് എനിക്കും നിനക്കും മധ്യേ ഒരു സാക്ഷിയാണ്” എന്നു പറഞ്ഞു. ഇക്കാരണത്താൽ അതിനു ഗലേദ് എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","“നമ്മൾ പരസ്പരം അകലെ ആയിരിക്കുമ്പോൾ യഹോവ എനിക്കും നിനക്കും മധ്യേ കാവൽനിൽക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","നീ എന്റെ പുത്രിമാരോട് ക്രൂരമായി പെരുമാറുകയോ ഇവരെക്കൂടാതെ മറ്റു ഭാര്യമാരെ സ്വീകരിക്കുകയോ ചെയ്താൽ, നമ്മോടുകൂടെ ആരും ഇല്ലെങ്കിൽപോലും, ദൈവം നിനക്കും എനിക്കും മധ്യേ സാക്ഷിയാകുന്നു എന്ന് ഓർത്തുകൊള്ളുക” എന്നും ലാബാൻ പറഞ്ഞു. അതുകൊണ്ട് ആ കൂമ്പാരത്തിനു മിസ്പാ എന്നും പേരുണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ലാബാൻ വീണ്ടും യാക്കോബിനോടു പറഞ്ഞു: “ഇതാ, ഈ കൂമ്പാരം! ഇതാ, നിനക്കും എനിക്കും മധ്യേ ഞാൻ നാട്ടിയ തൂൺ! ");
INSERT INTO malc_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","നിനക്കു ദോഷം ചെയ്യാൻ ഈ കൂമ്പാരത്തിന് അപ്പുറത്തേക്കു ഞാൻ വരികയില്ല എന്നതിനും എനിക്കു ദോഷം ചെയ്യാൻ ഈ കൂമ്പാരത്തിനും തൂണിനും ഇപ്പുറത്തേക്കു നീ വരികയില്ല എന്നതിനും ഈ കൂമ്പാരം സാക്ഷി! ഈ തൂണും സാക്ഷി! ");
INSERT INTO malc_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","അബ്രാഹാമിന്റെ ദൈവവും നാഹോരിന്റെ ദൈവവും അവരുടെ പിതാവിന്റെ ദൈവവുമായവൻ നമുക്കുമധ്യേ ന്യായംവിധിക്കട്ടെ.” അപ്പോൾ യാക്കോബ് തന്റെ പിതാവായ യിസ്ഹാക്കിന്റെ ഭയമായവന്റെ നാമത്തിൽ ശപഥംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","അദ്ദേഹം ആ മലയിൽ ഒരു യാഗം അർപ്പിക്കുകയും വിരുന്നിനു സഹോദരന്മാരെ ക്ഷണിക്കുകയും ചെയ്തു. ഭക്ഷണത്തിനുശേഷം എല്ലാവരും ആ രാത്രി അവിടെത്തന്നെ താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","പിറ്റേന്ന് അതിരാവിലെ ലാബാൻ തന്റെ പേരക്കിടാങ്ങളെയും പെൺമക്കളെയും ചുംബിക്കുകയും അനുഗ്രഹിക്കുകയും ചെയ്തു. പിന്നെ അദ്ദേഹം അവിടംവിട്ട് സ്വദേശത്തേക്കു മടങ്ങിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","യാക്കോബ് യാത്രതുടർന്നു; ദൈവദൂതന്മാർ അദ്ദേഹത്തെ എതിരേറ്റു. ");
INSERT INTO malc_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","യാക്കോബ് അവരെ കണ്ടപ്പോൾ അദ്ദേഹം, “ഇതു ദൈവത്തിന്റെ സേന” എന്നു പറഞ്ഞ് ആ സ്ഥലത്തിനു മഹനയീം എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ഏദോം രാജ്യത്ത്, സേയീർദേശത്ത് തന്റെ സഹോദരനായ ഏശാവിന്റെ അടുത്തേക്കു യാക്കോബ് തനിക്കുമുമ്പേ സന്ദേശവാഹകരെ അയച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","അദ്ദേഹം അവർക്ക് ഈ വിധം നിർദേശംനൽകി: “നിങ്ങൾ എന്റെ യജമാനനായ ഏശാവിനോട് പറയേണ്ടത് ഇതാണ്: ‘ഞാൻ ലാബാന്റെകൂടെ താമസിക്കുകയായിരുന്നു; ഈ സമയംവരെയും അവിടെ താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","എനിക്കു കന്നുകാലികളും കഴുതകളും ചെമ്മരിയാടുകളും കോലാടുകളും ദാസീദാസന്മാരും ഉണ്ട്. അങ്ങേക്ക് എന്നോടു കൃപയുണ്ടാകണം, അതിനുവേണ്ടിയാണ് ഞാൻ ഇപ്പോൾ ഈ സന്ദേശം അയയ്ക്കുന്നത് എന്ന് അങ്ങയുടെ ദാസനായ യാക്കോബ് അറിയിക്കുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","സന്ദേശവാഹകന്മാർ യാക്കോബിന്റെ അടുക്കൽ തിരിച്ചെത്തി അദ്ദേഹത്തോട്: “ഞങ്ങൾ അങ്ങയുടെ സഹോദരനായ ഏശാവിന്റെ അടുക്കൽ ചെന്നു, അദ്ദേഹം ഇതാ അങ്ങയെ എതിരേൽക്കാൻ വരുന്നു; നാനൂറ് ആളുകളും അദ്ദേഹത്തോടൊപ്പമുണ്ട്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","യാക്കോബിന് മഹാഭയവും സംഭ്രമവും ഉണ്ടായി. യാക്കോബ് തന്നോടുകൂടെയുണ്ടായിരുന്ന ആളുകളെയും ആടുമാടുകളെയും ഒട്ടകങ്ങളെയും രണ്ടു സംഘങ്ങളായി വിഭജിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“ഏശാവു വന്ന് ഒരു സംഘത്തെ ആക്രമിച്ചാൽ മറ്റേ സംഘത്തിനു രക്ഷപ്പെടാമല്ലോ” എന്ന് അദ്ദേഹം ചിന്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","പിന്നെ യാക്കോബ് പ്രാർഥിച്ചു: “എന്റെ പിതാവായ അബ്രാഹാമിന്റെ ദൈവമേ, എന്റെ പിതാവായ യിസ്ഹാക്കിന്റെ ദൈവമേ, യഹോവേ, അവിടന്ന് എന്നോട്, ‘നിന്റെ നാട്ടിലേക്കും നിന്റെ ബന്ധുക്കളുടെ അടുത്തേക്കും മടങ്ങിപ്പോകുക; ഞാൻ നിന്നെ വർധിപ്പിക്കും’ എന്ന് അരുളിച്ചെയ്തല്ലോ! ");
INSERT INTO malc_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","അവിടത്തെ ദാസനോട് അവിടന്നു കാണിച്ച ദയയ്ക്കും വിശ്വസ്തതയ്ക്കും ഈയുള്ളവൻ അയോഗ്യനാണ്. ഒരു വടിയോടുകൂടിമാത്രമല്ലോ ഞാൻ ഈ യോർദാൻ കടന്നത്, എന്നാൽ ഇപ്പോൾ ഇതാ ഞാൻ രണ്ടു സംഘങ്ങളായി വർധിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","എന്റെ സഹോദരനായ ഏശാവിന്റെ കൈയിൽനിന്ന് എന്നെ രക്ഷിക്കണമേ എന്നു ഞാൻ പ്രാർഥിക്കുന്നു. അദ്ദേഹം വന്ന് മക്കളോടുകൂടെ അമ്മയെയും നശിപ്പിക്കുമെന്നു ഞാൻ ഭയപ്പെടുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","എങ്കിലും ‘ഞാൻ നിന്നെ നിശ്ചയമായും വർധിപ്പിക്കയും നിന്റെ സന്തതികളെ കടൽക്കരയിലെ എണ്ണിക്കൂടാത്ത മണൽപോലെ ആക്കിത്തീർക്കുകയും ചെയ്യും’ എന്ന് അവിടന്ന് അരുളിച്ചെയ്തല്ലോ.” ");
INSERT INTO malc_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","യാക്കോബ് ആ രാത്രി അവിടെ ചെലവഴിച്ചു; സഹോദരനായ ഏശാവിനുവേണ്ടി, തനിക്കുള്ളതിൽനിന്ന് ഒരു സമ്മാനം തെരഞ്ഞെടുത്തു: ");
INSERT INTO malc_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ഇരുനൂറു പെൺകോലാടുകൾ, ഇരുപതു കോലാട്ടുകൊറ്റന്മാർ, ഇരുനൂറ് ചെമ്മരിയാടുകൾ, ഇരുപത് ചെമ്മരിയാട്ടുകൊറ്റന്മാർ. ");
INSERT INTO malc_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","കറവയുള്ള മുപ്പതു പെൺഒട്ടകങ്ങളും അവയുടെ കുട്ടികളും, നാൽപ്പതു പശുക്കളും പത്തു കാളകളും, ഇരുപതു പെൺകഴുതകളും പത്ത് ആൺകഴുതകളും—ഇത്രയുമായിരുന്നു സമ്മാനമായി തെരഞ്ഞെടുത്തത്. ");
INSERT INTO malc_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","അദ്ദേഹം അവയെ ഓരോ കൂട്ടമായിത്തിരിച്ച് ഓരോകൂട്ടത്തിന്റെയും ചുമതല ഓരോ ദാസന്മാരെ ഏൽപ്പിച്ചു. ഇതിനുശേഷം യാക്കോബ് അവരോട്: “നിങ്ങൾ എനിക്കുമുമ്പായി പൊയ്ക്കൊള്ളൂ, കൂട്ടങ്ങൾക്കു മധ്യേ അകലം ഇടണം” എന്നു നിർദേശിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ഏറ്റവും മുന്നിൽ പോകുന്നവന് അയാൾ നിർദേശം കൊടുത്തു: “എന്റെ സഹോദരനായ ഏശാവ് നിന്നെ കാണുകയും നിന്നോട്: ‘നീ ആരുടെ ദാസൻ? നീ എവിടേക്കു പോകുന്നു? നിന്റെ മുമ്പിൽ പോകുന്ന ഈ മൃഗങ്ങൾ ആരുടെ വക?’ എന്നു ചോദിക്കുകയും ചെയ്യുമ്പോൾ, ");
INSERT INTO malc_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","‘ഇവയെല്ലാം അങ്ങയുടെ ദാസനായ യാക്കോബിന്റെ വകയാണ്. ഇവ യജമാനനായ ഏശാവിനുവേണ്ടി അയച്ചിരിക്കുന്ന സമ്മാനം: അതാ, അദ്ദേഹം ഞങ്ങളുടെ പിന്നാലെ വരുന്നു’ എന്നു നീ പറയണം.” ");
INSERT INTO malc_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","രണ്ടാമനും മൂന്നാമനും കന്നുകാലിക്കൂട്ടങ്ങളെ പിൻതുടർന്നിരുന്ന മറ്റെല്ലാവർക്കും അദ്ദേഹം നിർദേശം കൊടുത്തു: “ഏശാവിനെ കാണുമ്പോൾ നിങ്ങൾ എല്ലാവരും ഇതുതന്നെ പറയണം. ");
INSERT INTO malc_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘അങ്ങയുടെ ദാസനായ യാക്കോബ് ഞങ്ങളുടെ പിന്നാലെ വരുന്നുണ്ട്’ എന്നു നിങ്ങൾ നിശ്ചയമായും പറയണം. ‘ഞാൻ മുമ്പേ അയയ്ക്കുന്ന ഈ സമ്മാനങ്ങൾകൊണ്ട് അദ്ദേഹത്തെ സാമാധാനപ്പെടുത്തും; പിന്നീട്, എന്നെ കാണുമ്പോൾ ഒരുപക്ഷേ അദ്ദേഹം സ്വീകരിക്കും’ ” എന്ന് യാക്കോബ് ചിന്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","അങ്ങനെ യാക്കോബിന്റെ സമ്മാനങ്ങൾ അദ്ദേഹത്തിനു മുമ്പായി നീങ്ങി. എന്നാൽ യാക്കോബ് പാളയത്തിൽത്തന്നെ രാത്രി ചെലവഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ആ രാത്രിയിൽ യാക്കോബ് എഴുന്നേറ്റ് തന്റെ രണ്ടു ഭാര്യമാരെയും രണ്ടു ദാസിമാരെയും പതിനൊന്നു പുത്രന്മാരെയും കൂട്ടിക്കൊണ്ട് യാബ്ബോക്കുകടവു കടന്നു. ");
INSERT INTO malc_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","അവരെ നദിക്കക്കരെ എത്തിച്ചതിനുശേഷം തനിക്കുള്ള സകലതും അക്കരെയെത്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","പിന്നീട് യാക്കോബ് തനിയേ ശേഷിച്ചു. ഒരു പുരുഷൻ പുലർച്ചയാകുന്നതുവരെ അദ്ദേഹത്തോടു മൽപ്പിടിത്തം നടത്തി. ");
INSERT INTO malc_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","യാക്കോബിനെ തോൽപ്പിക്കാൻ തനിക്കു സാധിക്കുന്നില്ല എന്നു കണ്ടിട്ട് ആ പുരുഷൻ അദ്ദേഹത്തിന്റെ അരക്കെട്ടിന്റെ തട്ടം തൊട്ടു. അങ്ങനെ മൽപ്പിടിത്തത്തിനിടയിൽ യാക്കോബിന്റെ അരക്കെട്ടിന്റെ തട്ടം ഉളുക്കിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","അപ്പോൾ ആ പുരുഷൻ, “എന്നെ പോകാൻ അനുവദിക്കൂ, നേരം പുലരുന്നു” എന്നു പറഞ്ഞു. അതിന് യാക്കോബ്, “അങ്ങ് എന്നെ അനുഗ്രഹിച്ചല്ലാതെ ഞാൻ അങ്ങയെ വിടുകയില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ആ പുരുഷൻ അദ്ദേഹത്തോട്, “നിന്റെ പേര് എന്ത്?” എന്നു ചോദിച്ചു. “യാക്കോബ്” അദ്ദേഹം ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","അപ്പോൾ ആ പുരുഷൻ, “ഇന്നുമുതൽ നിന്റെ പേര് യാക്കോബ് എന്നല്ല, ഇസ്രായേൽ എന്നായിരിക്കും; എന്തുകൊണ്ടെന്നാൽ നീ ദൈവത്തോടും മനുഷ്യരോടും പൊരുതി ജയിച്ചിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","“ദയവുചെയ്ത് അങ്ങയുടെ പേര് എന്നോടു പറഞ്ഞാലും” യാക്കോബ് അപേക്ഷിച്ചു. “നീ എന്തിനാണ് എന്റെ പേരു ചോദിക്കുന്നത്?” അദ്ദേഹം ചോദിച്ചു. പിന്നെ ആ പുരുഷൻ അവിടെവെച്ച് യാക്കോബിനെ അനുഗ്രഹിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","“ഞാൻ ദൈവത്തെ അഭിമുഖമായി കണ്ടു; എന്നിട്ടും എന്റെ ജീവൻ നഷ്ടപ്പെടാതിരിക്കുന്നു,” എന്നു പറഞ്ഞുകൊണ്ട് യാക്കോബ് ആ സ്ഥലത്തിനു പെനീയേൽ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","യാക്കോബ് പെനീയേൽ കടന്നപ്പോൾ സൂര്യൻ ഉദിച്ചുകഴിഞ്ഞിരുന്നു; ഇടുപ്പിന്റെ ഉളുക്കു നിമിത്തം അദ്ദേഹം മുടന്തിയാണു നടന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","യാക്കോബിന്റെ ഇടുപ്പിലെ തട്ടം അദ്ദേഹം സ്പർശിച്ചതുകൊണ്ട് ഇസ്രായേല്യർ ഇന്നുവരെയും ഇടുപ്പിനോടു ചേർന്നുള്ള സ്നായു ഭക്ഷിക്കാറില്ല. ");
INSERT INTO malc_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","യാക്കോബ് തലയുയർത്തിനോക്കി; അതാ, ഏശാവ് തന്റെ നാനൂറ് ആളുകളുമായി വരുന്നു. യാക്കോബ് കുട്ടികളെ വീതിച്ച് ലേയയെയും റാഹേലിനെയും രണ്ടു ദാസിമാരെയും ഏൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ദാസികളെയും അവരുടെ കുട്ടികളെയും മുന്നിലും ലേയയെയും അവളുടെ കുട്ടികളെയും അവർക്കു തൊട്ടുപിന്നിലും റാഹേലിനെയും യോസേഫിനെയും ഏറ്റവും പിറകിലും നിർത്തി. ");
INSERT INTO malc_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","പിന്നെ അദ്ദേഹം മുമ്പോട്ടുചെന്ന്, സഹോദരന്റെ സമീപമെത്തിയപ്പോൾ ഏഴുപ്രാവശ്യം സാഷ്ടാംഗം വീണുവണങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","എന്നാൽ ഏശാവ് യാക്കോബിനെ വരവേൽക്കുന്നതിനായി ഓടിവന്ന് അദ്ദേഹത്തെ ആലിംഗനംചെയ്തു; കഴുത്തിൽ കെട്ടിപ്പിടിച്ച് അദ്ദേഹത്തെ ചുംബിച്ചു; ഇരുവരും കരഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ഇതിനുശേഷം ഏശാവു ചുറ്റും നോക്കി സ്ത്രീകളെയും കുട്ടികളെയും കണ്ടിട്ട്. “നിന്റെ കൂടെയുള്ള ഇവർ ആരാണ്?” അദ്ദേഹം ചോദിച്ചു. “അങ്ങയുടെ ദാസന് ദൈവം കരുണതോന്നി നൽകിയ കുട്ടികളാണ് ഇവർ,” യാക്കോബ് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ഇതിനെത്തുടർന്ന് ദാസിമാരും അവരുടെ കുട്ടികളും വന്ന് അദ്ദേഹത്തെ വണങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","അതിനുശേഷം ലേയയും അവളുടെ കുട്ടികളും വന്നു വണങ്ങി. ഏറ്റവും ഒടുവിലായി യോസേഫും റാഹേലും വന്നു, അവരും വണങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","“ഞാൻ വഴിയിൽവെച്ച് കണ്ട ഈ പറ്റങ്ങൾ എല്ലാം എന്തിന്?” ഏശാവു ചോദിച്ചു. അതിന് യാക്കോബ്, “എന്റെ യജമാനനേ, അങ്ങയുടെ പ്രീതിക്കുവേണ്ടിയുള്ള എന്റെ ഉപഹാരമാണ്.” ");
INSERT INTO malc_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","അതിന് ഏശാവ്, “എന്റെ സഹോദരാ, എനിക്ക് ഇപ്പോൾത്തന്നെ ധാരാളമുണ്ട്. നിനക്കുള്ളതു നിനക്കായിത്തന്നെ സൂക്ഷിക്കുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","അപ്പോൾ യാക്കോബ്: “ദയവായി അങ്ങനെ പറയരുതേ; അങ്ങേക്ക് എന്നോടു പ്രീതിയുണ്ടെങ്കിൽ ഈ സമ്മാനം സ്വീകരിക്കണം. അങ്ങ് എന്നെ കൃപയോടെ സ്വീകരിച്ചല്ലോ, അങ്ങയുടെ മുഖം കാണുന്നത് ദൈവത്തിന്റെ മുഖം കാണുന്നതുപോലെയാണ്. ");
INSERT INTO malc_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ഞാൻ കൊണ്ടുവന്നിരിക്കുന്ന സമ്മാനം ദയവായി ഏറ്റുവാങ്ങണം; ദൈവത്തിന്റെ കരുണയാൽ എനിക്കു വേണ്ടുവോളമുണ്ട്” എന്നു പറഞ്ഞു. യാക്കോബ് നിർബന്ധിച്ചതിനാൽ ഏശാവ് അതു സ്വീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","പിന്നെ ഏശാവ്: “നമുക്കു മുന്നോട്ടു നീങ്ങാം, ഞാൻ നിന്റെകൂടെ വരാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","എന്നാൽ യാക്കോബ് അദ്ദേഹത്തോടു പറഞ്ഞു: “മക്കൾ തീരെ ഇളപ്പമാണെന്നും കുട്ടികളുള്ള ആടുകളെയും കിടാക്കളുള്ള പശുക്കളെയും ഞാൻ കരുതലോടെ പരിപാലിക്കേണ്ടതാണെന്നും യജമാനന് അറിയാമല്ലോ. വേഗം നടത്തിയാൽ ഒറ്റദിവസംകൊണ്ട് മൃഗങ്ങളെല്ലാം ചത്തുപോകും. ");
INSERT INTO malc_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","അതുകൊണ്ട് യജമാനൻ അടിയനുമുമ്പായി പോയാലും; കുഞ്ഞുങ്ങളുടെയും കന്നുകാലികളുടെയും നടപ്പിനൊത്ത് സാവകാശം നടന്ന് അടിയൻ സേയീരിൽ യജമാനന്റെ അടുക്കൽ വന്നുകൊള്ളാം.” ");
INSERT INTO malc_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","“എന്നാൽ ഞാൻ എന്റെ ആളുകളിൽ ചിലരെ നിങ്ങളുടെകൂടെ നിർത്താം” ഏശാവു പറഞ്ഞു. “അതിന്റെ ആവശ്യം എന്ത്?” യാക്കോബ് ചോദിച്ചു; “അടിയനോട് യജമാനനു കരുണയുണ്ടായാൽമാത്രം മതി.” ");
INSERT INTO malc_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","അങ്ങനെ ഏശാവ് അന്നേദിവസംതന്നെ തിരികെ സേയീരിലേക്കു യാത്രയായി. ");
INSERT INTO malc_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","യാക്കോബാകട്ടെ, സൂക്കോത്തിലേക്കു പോയി. അവിടെ അദ്ദേഹം തനിക്കായിത്തന്നെ ഒരു പാർപ്പിടം പണിയുകയും കന്നുകാലികൾക്ക് തൊഴുത്തുകൾ ഉണ്ടാക്കുകയും ചെയ്തു. അതുകൊണ്ടാണ് ആ സ്ഥലത്തിനു സൂക്കോത്ത് എന്നു പേരുണ്ടായത്. ");
INSERT INTO malc_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","യാക്കോബ് പദ്ദൻ-അരാമിൽനിന്ന് പോന്നതിനുശേഷം കനാനിലെ ശേഖേം പട്ടണത്തിൽ സുരക്ഷിതനായി എത്തി, പട്ടണത്തിനരികെ കൂടാരം അടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","യാക്കോബ്, താൻ കൂടാരമടിച്ച സ്ഥലം ശേഖേമിന്റെ പിതാവായ ഹാമോരിന്റെ പുത്രന്മാരോടു നൂറു വെള്ളിക്കാശിനു വിലയ്ക്കുവാങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","അവിടെ അദ്ദേഹം ഒരു യാഗപീഠം പണിത് അതിന് ഏൽ-എലോഹേ-ഇസ്രായേൽ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","യാക്കോബിനു ലേയാ പ്രസവിച്ച മകളായ ദീനാ ആ നാട്ടിലെ യുവതികളെ സന്ദർശിക്കാൻ ഇറങ്ങിത്തിരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ദേശത്തെ ഭരണാധികാരിയും ഹിവ്യനായ ഹാമോരിന്റെ മകനുമായ ശേഖേം അവളെ കണ്ടു; അവൻ അവളെ പിടിച്ചുകൊണ്ടുപോയി അവളുമായി കിടക്കപങ്കിട്ടു; അവളെ മാനഭംഗപ്പെടുത്തി. ");
INSERT INTO malc_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","അവന്റെ ഹൃദയം യാക്കോബിന്റെ മകളായ ദീനായിലേക്ക് ആകർഷിക്കപ്പെട്ടു; അവൻ ആ പെൺകുട്ടിയെ സ്നേഹിക്കുകയും അവളോട് ആർദ്രമായി സംസാരിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","“ഈ പെൺകുട്ടിയെ എനിക്കു ഭാര്യയായി എടുക്കണം,” ശേഖേം തന്റെ പിതാവായ ഹാമോരിനോട് അപേക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","തന്റെ പുത്രിയായ ദീനായെ ശേഖേം മാനഭംഗപ്പെടുത്തി എന്നവിവരം യാക്കോബ് കേട്ടു; ആ സമയം അദ്ദേഹത്തിന്റെ പുത്രന്മാർ കന്നുകാലികളുമായി വയലിൽ ആയിരുന്നു; അവർ വീട്ടിൽ എത്തുന്നതുവരെ യാക്കോബ് മൗനംപാലിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ഈ സമയം ശേഖേമിന്റെ പിതാവായ ഹാമോർ യാക്കോബിനോടു സംസാരിക്കാൻ അദ്ദേഹത്തിന്റെ അടുക്കൽ ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","അതിനിടയ്ക്ക് വിവരം അറിഞ്ഞയുടൻ യാക്കോബിന്റെ പുത്രന്മാർ വയലിൽനിന്ന് തിരിച്ചെത്തി. ശേഖേം യാക്കോബിന്റെ പുത്രിയോടൊപ്പം കിടക്കപങ്കിട്ട് അരുതാത്തതു ചെയ്ത്, ഇസ്രായേലിൽ വഷളത്തം പ്രവർത്തിച്ചതുകൊണ്ട് അവർ കോപവും ക്രോധവും നിറഞ്ഞവരായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","എന്നാൽ ഹാമോർ അവരോടു പറഞ്ഞു: “നിങ്ങളുടെ പുത്രിയിലേക്ക് എന്റെ പുത്രനായ ശേഖേമിന്റെ ഹൃദയം ആകൃഷ്ടമായിരിക്കുന്നു. ദയവുചെയ്ത് അവളെ അവനു ഭാര്യയായി കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","നിങ്ങൾ ഞങ്ങളുമായി മിശ്രവിവാഹബന്ധത്തിൽ ഏർപ്പെട്ടാലും! നിങ്ങളുടെ പുത്രിമാരെ ഞങ്ങൾക്കു തരികയും ഞങ്ങളുടെ പുത്രിമാരെ നിങ്ങൾക്ക് എടുക്കുകയും ചെയ്യാം. ");
INSERT INTO malc_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ഞങ്ങളോടൊപ്പം പാർക്കുക. ദേശം നിങ്ങളുടെ മുന്നിൽ തുറന്നുകിടക്കുന്നു; അതിൽ താമസിച്ച്, തൊഴിൽചെയ്ത് സ്വത്തു സമ്പാദിക്കുക.” ");
INSERT INTO malc_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","പിന്നെ ശേഖേം ദീനായുടെ പിതാവിനോടും സഹോദരന്മാരോടുമായി പറഞ്ഞു: “നിങ്ങൾക്ക് എന്നോടു പ്രീതിയുണ്ടാകണം, നിങ്ങൾ ചോദിക്കുന്നതെന്തും ഞാൻ തരാം. ");
INSERT INTO malc_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","സ്ത്രീധനമായോ വിവാഹസമ്മാനമായോ എത്ര അധികം നിങ്ങൾ ആവശ്യപ്പെട്ടാലും ഞാൻ നിങ്ങൾക്കു തന്നുകൊള്ളാം. പെൺകുട്ടിയെ എനിക്കു ഭാര്യയായി തന്നാൽമാത്രംമതി.” ");
INSERT INTO malc_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","തങ്ങളുടെ സഹോദരിയായ ദീനായെ മാനഭംഗപ്പെടുത്തിയതുകൊണ്ട് യാക്കോബിന്റെ പുത്രന്മാർ ശേഖേമിനോടും അവന്റെ പിതാവായ ഹാമോരിനോടും മറുപടി പറഞ്ഞത് കാപട്യത്തോടെ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","അവർ അവരോടു പറഞ്ഞു: “അങ്ങനെ ഒരു കാര്യം ചെയ്യാൻ ഞങ്ങൾക്കു സാധ്യമല്ല. പരിച്ഛേദനം ഏൽക്കാത്ത ഒരു വ്യക്തിക്ക് ഞങ്ങളുടെ സഹോദരിയെ നൽകാൻ ഞങ്ങൾ തയ്യാറല്ല; ഞങ്ങൾക്ക് അതു അപമാനമാണ്; ");
INSERT INTO malc_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ഒരേയൊരു വ്യവസ്ഥയിൽ ഞങ്ങൾ സമ്മതിക്കാം, അതായത്, നിങ്ങളുടെ സകലപുരുഷന്മാരും ഞങ്ങളെപ്പോലെ പരിച്ഛേദനം ഏൽക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","അപ്പോൾ ഞങ്ങളുടെ പുത്രിമാരെ നിങ്ങൾക്കു തരികയും നിങ്ങളുടെ പുത്രിമാരെ ഞങ്ങൾക്കായി സ്വീകരിക്കുകയും ചെയ്യാം. ഞങ്ങൾ നിങ്ങളോടൊപ്പം താമസിച്ച് ഒരു ജനമായിത്തീരാം. ");
INSERT INTO malc_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","എന്നാൽ, നിങ്ങൾ പരിച്ഛേദനം ഏൽക്കാൻ വിസമ്മതിക്കുന്നപക്ഷം ഞങ്ങൾ ഞങ്ങളുടെ സഹോദരിയെയും കൂട്ടിക്കൊണ്ട് ഇവിടെനിന്നു പോകും.” ");
INSERT INTO malc_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","അവരുടെ ഈ നിർദേശം ഹാമോരിനും അദ്ദേഹത്തിന്റെ പുത്രനായ ശേഖേമിനും നല്ലതെന്നു തോന്നി. ");
INSERT INTO malc_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","തന്റെ പിതൃഭവനത്തിലുള്ള എല്ലാവരെക്കാളും ഏറെ ആദരിക്കപ്പെട്ടിരുന്ന ആ ചെറുപ്പക്കാരൻ, യാക്കോബിന്റെ പുത്രിയെ അതിയായി ആഗ്രഹിച്ചിരുന്നതുകൊണ്ട്, അവർ പറഞ്ഞതനുസരിച്ച് ഉടൻതന്നെ പ്രവർത്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ഹാമോരും അദ്ദേഹത്തിന്റെ പുത്രനായ ശേഖേമും നഗരകവാടത്തിൽ ചെന്നു പട്ടണത്തിലെ പുരുഷന്മാരോടു സംസാരിച്ചു: ");
INSERT INTO malc_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ഈ പുരുഷന്മാർ നമ്മുടെ സുഹൃത്തുക്കളാണ്,” അവർ പറഞ്ഞു. “ഇവർ നമ്മുടെ ദേശത്തു താമസിക്കുകയും തൊഴിൽ ചെയ്യുകയുംചെയ്യട്ടെ. നമ്മുടെ ദേശത്ത് ഇവർക്കു വേണ്ടുവോളം സ്ഥലമുണ്ട്. നമുക്ക് അവരുടെ പുത്രിമാരെയും അവർക്കു നമ്മുടെ പുത്രിമാരെയും വിവാഹംചെയ്യാം. ");
INSERT INTO malc_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","എന്നാൽ അവരെപ്പോലെതന്നെ നമ്മുടെ പുരുഷന്മാരും പരിച്ഛേദനം ഏൽക്കണം എന്ന വ്യവസ്ഥ പാലിച്ചാൽമാത്രമേ അവർ നമ്മോടുചേർന്ന് ഒരേ ജനമായി ജീവിക്കാൻ സമ്മതിക്കുകയുള്ളൂ. ");
INSERT INTO malc_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","അവരുടെ കന്നുകാലികളും അവരുടെ സ്വത്തും അവർക്കുള്ള മറ്റെല്ലാ മൃഗങ്ങളും നമ്മുടേതായിത്തീരുകയില്ലയോ? ആകയാൽ അവർ പറയുന്നതു നമുക്കു സമ്മതിക്കാം; അവർ നമ്മുടെ ഇടയിൽ സ്ഥിരതാമസമാക്കിക്കൊള്ളും.” ");
INSERT INTO malc_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","നഗരകവാടത്തിൽനിന്ന് പുറത്തേക്കുപോയ സകലപുരുഷന്മാരും ഹാമോരിന്റെയും അദ്ദേഹത്തിന്റെ പുത്രനായ ശേഖേമിന്റെയും നിർദേശം സമ്മതിച്ചു; നഗരത്തിലെ സകലപുരുഷന്മാരും പരിച്ഛേദനം ഏറ്റു. ");
INSERT INTO malc_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","മൂന്നുദിവസത്തിനുശേഷം, അവർ എല്ലാവരും വേദനയോടെ ഇരിക്കുമ്പോൾ യാക്കോബിന്റെ പുത്രന്മാരിൽ രണ്ടുപേർ—ദീനായുടെ സഹോദരന്മാരായ ശിമെയോനും ലേവിയും—തങ്ങളുടെ വാളുമായിച്ചെന്ന്, നിർഭയമായിരുന്ന നഗരത്തെ ആക്രമിച്ച് സകലപുരുഷന്മാരെയും കൊന്നുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","അവർ ഹാമോരിനെയും അദ്ദേഹത്തിന്റെ പുത്രനായ ശേഖേമിനെയും വാളിനിരയാക്കി; ശേഖേമിന്റെ വീട്ടിൽനിന്ന് ദീനായെ മോചിപ്പിച്ചു കൊണ്ടുപോന്നു. ");
INSERT INTO malc_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","പിന്നെ യാക്കോബിന്റെ പുത്രന്മാർ കൊല്ലപ്പെട്ടവരുടെ ഇടയിൽ ചെന്ന്, തങ്ങളുടെ സഹോദരിയെ കളങ്കപ്പെടുത്തിയവരുടെ നഗരം കൊള്ളയടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","അവരുടെ ആട്ടിൻപറ്റങ്ങളെയും കന്നുകാലികളെയും കഴുതകളെയും നഗരത്തിലും വയലിലും ഉണ്ടായിരുന്ന സകലവസ്തുക്കളെയും അവർ കൊള്ളയടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","അവരുടെ സർവസമ്പത്തും എടുത്ത്; അവരുടെ സ്ത്രീകളെയും കുട്ടികളെയും പിടിച്ചുകൊണ്ട് പോകുകയും ചെയ്തു; അങ്ങനെ വീടുകളിൽ ഉണ്ടായിരുന്ന സകലതും അവർ കൊള്ളയടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","അപ്പോൾ യാക്കോബ് ശിമെയോനോടും ലേവിയോടും പറഞ്ഞു: “ഈ ദേശവാസികളായ കനാന്യരുടെയും പെരിസ്യരുടെയും ഇടയിൽ നിങ്ങൾ എന്നെ നാറ്റിച്ച് എനിക്ക് ഉപദ്രവം വരുത്തിയിരിക്കുന്നു. നമ്മൾ എണ്ണത്തിൽ കുറവുള്ളവരാണ്; അവർ എനിക്കെതിരേ സംഘടിച്ച് എന്നെ ആക്രമിച്ചാൽ ഞാനും എന്റെ കുടുംബവും നശിച്ചുപോകും.” ");
INSERT INTO malc_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","എന്നാൽ അവർ പ്രത്യുത്തരമായി: “അവൻ ഞങ്ങളുടെ സഹോദരിയോട് ഒരു ഗണികയോടെന്നപോലെ പെരുമാറണമായിരുന്നോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ഈ സംഭവത്തിനുശേഷം ദൈവം യാക്കോബിനോട്: “നീ ബേഥേലിലേക്കുപോയി അവിടെ സ്ഥിരതാമസം തുടങ്ങുകയും നിന്റെ സഹോദരനായ ഏശാവിന്റെ അടുക്കൽനിന്ന് നീ ഓടിപ്പോയപ്പോൾ നിനക്കു പ്രത്യക്ഷനായ ദൈവത്തിന് അവിടെ ഒരു യാഗപീഠം പണിയുകയും വേണം” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","അതിൻപ്രകാരം യാക്കോബ് തന്റെ കുടുംബത്തിലുള്ളവരോടും കൂടെയുള്ള മറ്റെല്ലാവരോടുമായി, “നിങ്ങളുടെ പക്കലുള്ള അന്യദേവന്മാരെ ഉപേക്ഷിച്ച് നിങ്ങളെത്തന്നെ ശുദ്ധീകരിക്കുകയും പുതിയ വസ്ത്രം ധരിക്കുകയുംചെയ്യുക. ");
INSERT INTO malc_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","നമുക്ക് ബേഥേലിലേക്കു പോകാം; എന്റെ കഷ്ടദിവസത്തിൽ എനിക്ക് ഉത്തരമരുളുകയും ഞാൻ പോയ സ്ഥലങ്ങളിലെല്ലാം എന്നോടുകൂടെയിരിക്കുകയും ചെയ്ത ദൈവത്തിനു ഞാൻ അവിടെ ഒരു യാഗപീഠം പണിയും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","അപ്പോൾ അവർ തങ്ങൾക്കുണ്ടായിരുന്ന സകല അന്യദേവന്മാരെയും കർണാഭരണങ്ങളെയും യാക്കോബിനെ ഏൽപ്പിച്ചു; യാക്കോബ് അവ ശേഖേമിലെ കരുവേലകത്തിന്റെ ചുവട്ടിൽ കുഴിച്ചിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","പിന്നെ അവർ യാത്രപുറപ്പെട്ടു; അവർക്കു ചുറ്റുമുള്ള എല്ലാ പട്ടണങ്ങളിന്മേലും ദൈവത്തെക്കുറിച്ചുള്ള ഭീതി പരന്നതുനിമിത്തം ആരും അവരെ പിൻതുടർന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","യാക്കോബും അദ്ദേഹത്തിന്റെകൂടെ ഉണ്ടായിരുന്നവർ എല്ലാവരും കനാൻദേശത്തിലെ ലൂസിൽ (അതായതു, ബേഥേലിൽ) എത്തിച്ചേർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","അവിടെ അദ്ദേഹം ഒരു യാഗപീഠം പണിതു; അദ്ദേഹം തന്റെ സഹോദരന്റെ അടുക്കൽനിന്ന് ഓടിപ്പോയപ്പോൾ ദൈവം അദ്ദേഹത്തിനു പ്രത്യക്ഷനായത് അവിടെവെച്ചായിരുന്നതുകൊണ്ട് ആ സ്ഥലത്തിന് അദ്ദേഹം ഏൽ-ബേഥേൽ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ഇതിനുശേഷം റിബേക്കയുടെ പരിചാരികയായ ദെബോറാ മരിച്ചു, ബേഥേലിനു താഴെയുള്ള കരുവേലകത്തിന്റെ കീഴിൽ അവളെ അടക്കംചെയ്തു. അതുകൊണ്ട് ആ മരത്തിന് അല്ലോൻ-ബാഖൂത്ത് എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","യാക്കോബ് പദ്ദൻ-അരാമിൽനിന്ന് മടങ്ങിയെത്തിയതിനുശേഷം ദൈവം വീണ്ടും അദ്ദേഹത്തിനു പ്രത്യക്ഷനാകുകയും അദ്ദേഹത്തെ അനുഗ്രഹിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ദൈവം അദ്ദേഹത്തോട്: “നിന്റെ പേരു യാക്കോബ് എന്നാണ്; എന്നാൽ ഇനിയൊരിക്കലും നീ യാക്കോബ് എന്നു വിളിക്കപ്പെടുകയില്ല; നിന്റെ പേര് ഇസ്രായേൽ എന്നായിരിക്കും.” അങ്ങനെ ദൈവം അദ്ദേഹത്തിന് ഇസ്രായേൽ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ദൈവം പിന്നെയും അദ്ദേഹത്തോട്: “ഞാൻ ആകുന്നു സർവശക്തനായ ദൈവം; നീ സന്താനപുഷ്ടിയുള്ളവനായി എണ്ണത്തിൽ വർധിച്ചുവരിക. ഒരു ജനത, അതേ ജനതകളുടെ സമൂഹംതന്നെ നിന്നിൽനിന്ന് ഉത്ഭവിക്കും; നിന്റെ സന്തതികളിൽനിന്ന് രാജാക്കന്മാർ ഉത്ഭവിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ഞാൻ അബ്രാഹാമിനും യിസ്ഹാക്കിനും കൊടുത്ത ദേശം നിനക്കു തരുന്നു; നിന്റെ കാലശേഷം ഈ ദേശം ഞാൻ നിന്റെ സന്തതികൾക്കു കൊടുക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ഇതിനുശേഷം, അദ്ദേഹത്തോടു സംസാരിച്ച സ്ഥലത്തുനിന്നു ദൈവം ആരോഹണംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","തന്നോടു ദൈവം സംസാരിച്ച സ്ഥലത്ത് യാക്കോബ് ഒരു കൽത്തൂൺ നാട്ടി അതിന്മേൽ ഒരു പാനീയയാഗം പകർന്നു; അദ്ദേഹം അതിന്മേൽ എണ്ണയും ഒഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","തന്നോടു ദൈവം സംഭാഷണം നടത്തിയ സ്ഥലത്തിന് യാക്കോബ് ബേഥേൽ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","പിന്നെ അവർ ബേഥേലിൽനിന്ന് മുന്നോട്ടു പ്രയാണംചെയ്തു. അവർ എഫ്രാത്തിൽ എത്താറായപ്പോൾ റാഹേലിനു പ്രസവസമയം അടുത്തു; അവൾ കഠിനവേദനയിലായി. ");
INSERT INTO malc_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","പ്രസവവേദന അതികഠിനമായപ്പോൾ സൂതികർമിണി അവളോട്, “ഭയപ്പെടരുത്, നിനക്ക് ഇതാ, മറ്റൊരുമകൻ ജനിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","എന്നാൽ അവൾ മരിക്കുകയായിരുന്നു, ജീവൻ പോകുമ്പോൾ തന്റെ മകന് അവൾ ബെനോനി എന്നു പേരിട്ടു. അവന്റെ അപ്പനാകട്ടെ, അവന് ബെന്യാമീൻ എന്നു പേരുനൽകി. ");
INSERT INTO malc_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","അങ്ങനെ റാഹേൽ മരിച്ചു. എഫ്രാത്തിലേക്കുള്ള വഴിയരികെ (അതായതു, ബേത്ലഹേമിൽ) അവളെ സംസ്കരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","അവളുടെ ശവകുടീരത്തിനുമീതേയായി യാക്കോബ് ഒരു സ്തൂപം സ്ഥാപിച്ചു, അത് ഇന്നുവരെയും റാഹേലിന്റെ കല്ലറയുടെ ചിഹ്നമായിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ഇസ്രായേൽ വീണ്ടും യാത്രചെയ്ത് മിഗ്ദൽ-ഏദെർഗോപുരത്തിന് അപ്പുറം കൂടാരം അടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ഇസ്രായേൽ ആ ദേശത്തു താമസിച്ചിരുന്നകാലത്ത് രൂബേൻ ചെന്ന് അപ്പന്റെ വെപ്പാട്ടിയായ ബിൽഹായോടൊപ്പം കിടക്കപങ്കിട്ടു; അതേപ്പറ്റി ഇസ്രായേൽ കേട്ടു. യാക്കോബിനു പന്ത്രണ്ടു പുത്രന്മാർ ഉണ്ടായിരുന്നു: ");
INSERT INTO malc_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ലേയയുടെ പുത്രന്മാർ: യാക്കോബിന്റെ ആദ്യജാതനായ രൂബേൻ, ശിമെയോൻ, ലേവി, യെഹൂദാ, യിസ്സാഖാർ, സെബൂലൂൻ, ");
INSERT INTO malc_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","റാഹേലിന്റെ പുത്രന്മാർ: യോസേഫും ബെന്യാമീനും, ");
INSERT INTO malc_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","റാഹേലിന്റെ ദാസിയായ ബിൽഹായുടെ പുത്രന്മാർ: ദാനും നഫ്താലിയും, ");
INSERT INTO malc_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ലേയയുടെ ദാസിയായ സിൽപ്പയുടെ പുത്രന്മാർ: ഗാദും ആശേരും. ഇവരായിരുന്നു യാക്കോബിനു പദ്ദൻ-അരാമിൽവെച്ചു ജനിച്ച പുത്രന്മാർ. ");
INSERT INTO malc_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","യാക്കോബ് കിര്യത്ത്-അർബക്കു സമീപമുള്ള മമ്രേയിൽ, അതായത്, അബ്രാഹാമും യിസ്ഹാക്കും താമസിച്ചിരുന്ന ഹെബ്രോനിൽ, തന്റെ ഭവനത്തിൽ, പിതാവിന്റെ അടുക്കൽ എത്തി. ");
INSERT INTO malc_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","യിസ്ഹാക്ക് നൂറ്റി എൺപതുവർഷം ജീവിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","പിന്നെ അദ്ദേഹം അന്ത്യശ്വാസം വലിച്ചു. അങ്ങനെ അദ്ദേഹം കാലസമ്പൂർണനായി മരിച്ച് തന്റെ ജനത്തോടു ചേർന്നു. അദ്ദേഹത്തിന്റെ പുത്രന്മാരായ ഏശാവും യാക്കോബുംകൂടി അദ്ദേഹത്തെ അടക്കംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ഏദോം എന്ന ഏശാവിനെ സംബന്ധിച്ച വിവരണം ഇതാണ്: ");
INSERT INTO malc_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ഏശാവ് രണ്ട് കനാന്യസ്ത്രീകളെ വിവാഹംചെയ്തു: ഹിത്യനായ ഏലോന്റെ പുത്രി ആദായും അനായുടെ പുത്രിയും ഹിവ്യനായ സിബെയോന്റെ കൊച്ചുമകളുമായ ഒഹൊലീബാമയുമാണവർ. ");
INSERT INTO malc_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","കൂടാതെ, യിശ്മായേലിന്റെ മകളും നെബായോത്തിന്റെ സഹോദരിയുമായ ബാസമത്തിനെയും ഭാര്യയായി സ്വീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ആദാ ഏശാവിന് എലീഫാസിനെയും ബാസമത്ത് രെയൂവേലിനെയും ");
INSERT INTO malc_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ഒഹൊലീബാമ യെയൂശ്, യലാം, കോരഹ് എന്നിവരെയും പ്രസവിച്ചു. ഇവരാണ് ഏശാവിനു കനാനിൽവെച്ചു ജനിച്ച പുത്രന്മാർ. ");
INSERT INTO malc_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ഏശാവു തന്റെ ഭാര്യമാരെയും പുത്രന്മാരെയും പുത്രിമാരെയും കുടുംബത്തിലുള്ള സകല അംഗങ്ങളെയും ആടുമാടുകളെയും തനിക്കുള്ള മറ്റു മൃഗങ്ങളെയും കനാനിൽവെച്ചു സമ്പാദിച്ച സകലവസ്തുക്കളും കൂട്ടിക്കൊണ്ട് തന്റെ സഹോദരനായ യാക്കോബിന്റെ അടുക്കൽനിന്ന് കുറച്ച് അകലെയുള്ള ഒരു ദേശത്തേക്കു യാത്രയായി. ");
INSERT INTO malc_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","അവർക്ക് ഒരുമിച്ചു ജീവിക്കാൻ സാധ്യമല്ലാത്തവിധം അത്യധികമായ സ്വത്തുക്കൾ ഉണ്ടായിരുന്നു; അവരുടെ ആടുമാടുകൾനിമിത്തം, അവർ ജീവിച്ചിരുന്ന ദേശത്തിന് അവരെ പോറ്റാൻ കഴിയാതെയായി. ");
INSERT INTO malc_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","അതുകൊണ്ട് ഏദോം എന്നു പേരുള്ള ഏശാവ് മലമ്പ്രദേശമായ സേയീരിൽ താമസം ഉറപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","മലമ്പ്രദേശമായ സേയീരിലെ ഏദോമ്യരുടെ പിതാവായ ഏശാവിന്റെ വംശപാരമ്പര്യം ഇതാണ്. ");
INSERT INTO malc_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ഏശാവിന്റെ പുത്രന്മാരുടെ പേരുകൾ: ഏശാവിന്റെ ഭാര്യയായ ആദായുടെ മകൻ എലീഫാസ്; മറ്റൊരു ഭാര്യയായ ബാസമത്തിന്റെ മകനായ രെയൂവേൽ. ");
INSERT INTO malc_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","എലീഫാസിന്റെ പുത്രന്മാർ: തേമാൻ, ഓമാർ, സെഫോ, ഗഥാം, കെനസ്. ");
INSERT INTO malc_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ഏശാവിന്റെ മകനായ എലീഫാസിന് തിമ്ന എന്നു പേരുള്ള ഒരു വെപ്പാട്ടി ഉണ്ടായിരുന്നു; അവൾ എലീഫാസിന് അമാലേക്കിനെ പ്രസവിച്ചു. ഇവരായിരുന്നു ഏശാവിന്റെ ഭാര്യയായ ആദായുടെ പൗത്രന്മാർ. ");
INSERT INTO malc_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","രെയൂവേലിന്റെ പുത്രന്മാർ: നഹത്ത്, സേരഹ്, ശമ്മാ, മിസ്സാ. ഇവരായിരുന്നു ഏശാവിന്റെ ഭാര്യയായ ബാസമത്തിന്റെ പൗത്രന്മാർ. ");
INSERT INTO malc_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ഏശാവിന്റെ ഭാര്യയും സിബെയോന്റെ കൊച്ചുമകളും അനായുടെ മകളുമായ ഒഹൊലീബാമ ഏശാവിനു പ്രസവിച്ച പുത്രന്മാർ: യെയൂശ്, യലാം, കോരഹ്. ");
INSERT INTO malc_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ഏശാവിന്റെ പിൻഗാമികളിൽ പ്രധാനികൾ ഇവരാണ്: ഏശാവിന്റെ ആദ്യജാതനായ എലീഫാസിന്റെ പുത്രന്മാർ: പ്രധാനികളായ തേമാൻ, ഓമാർ, സെഫോ, കെനസ്, ");
INSERT INTO malc_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","കോരഹ്, ഗത്ഥാം, അമാലേക്ക്. ഏദോമിൽവെച്ച് എലീഫാസിൽനിന്ന് ഉത്ഭവിച്ച പ്രധാനികൾ ഇവരായിരുന്നു; ഇവർ ആദായുടെ പൗത്രന്മാരാണ്. ");
INSERT INTO malc_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ഏശാവിന്റെ മകനായ രെയൂവേലിന്റെ പുത്രന്മാർ: പ്രധാനികളായ നഹത്ത്, സേരഹ്, ശമ്മാ, മിസ്സാ. ഏദോമിൽവെച്ച് രെയൂവേലിൽനിന്ന് ഉത്ഭവിച്ച പ്രധാനികൾ ഇവരാകുന്നു. ഇവർ ഏശാവിന്റെ ഭാര്യയായ ബാസമത്തിന്റെ പൗത്രന്മാരാണ്. ");
INSERT INTO malc_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ഏശാവിന്റെ ഭാര്യയായ ഒഹൊലീബാമയുടെ പുത്രന്മാർ: പ്രധാനികളായ യെയൂശ്, യലാം, കോരഹ്, ഏശാവിന്റെ ഭാര്യയും അനായുടെ മകളുമായ ഒഹൊലീബാമയിൽനിന്നു ജനിച്ച പ്രധാനികൾ ഇവരത്രേ. ");
INSERT INTO malc_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ഏദോം എന്ന ഏശാവിന്റെ പുത്രന്മാർ ഇവരാകുന്നു; അവരുടെ പ്രധാനികളും ഇവരാണ്. ");
INSERT INTO malc_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ഹോര്യനായ സേയീരിന്റെ പുത്രന്മാരായി ആ പ്രദേശത്തു ജീവിച്ചിരുന്നവർ ഇവരാകുന്നു: ലോതാൻ, ശോബാൽ, സിബെയോൻ, അനാ, ");
INSERT INTO malc_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ദീശോൻ, ഏസെർ, ദീശാൻ. ഏദോമിലെ സേയീരിന്റെ പുത്രന്മാരായ ഇവർ ഹോര്യരുടെ പ്രധാനികൾ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ലോതാന്റെ പുത്രന്മാർ: ഹോരി, ഹോമാം; തിമ്നാ ലോതാന്റെ സഹോദരി ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ശോബാലിന്റെ പുത്രന്മാർ: അല്വാൻ, മനഹത്ത്, ഏബാൽ, ശെഫോ, ഓനാം. ");
INSERT INTO malc_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","സിബെയോന്റെ പുത്രന്മാർ: അയ്യാ, അനാ. തന്റെ പിതാവായ സിബെയോന്റെ കഴുതകളെ മേയിക്കുമ്പോൾ മരുഭൂമിയിൽ ചൂടുള്ള നീരുറവകൾ കണ്ടെത്തിയത് ഇതേ അനാ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","അനാവിന്റെ മക്കൾ: മകൻ ദീശോനും മകൾ ഒഹൊലീബാമയും. ");
INSERT INTO malc_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ദീശോന്റെ പുത്രന്മാർ: ഹെമ്ദാൻ, എശ്ബാൻ, യിത്രാൻ, കെരാൻ. ");
INSERT INTO malc_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ഏസെരിന്റെ പുത്രന്മാർ: ബിൽഹാൻ, സാവാൻ, അക്കാൻ. ");
INSERT INTO malc_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ദീശോന്റെ പുത്രന്മാർ: ഊസ്, അരാൻ. ");
INSERT INTO malc_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ഹോര്യപ്രധാനികൾ ഇവരായിരുന്നു: ലോതാൻ, ശോബാൽ, സിബെയോൻ, അനാ, ");
INSERT INTO malc_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ദീശോൻ, ഏസെർ, ദീശാൻ. ഇവർ സേയീർദേശത്ത് തങ്ങളുടെ വിഭാഗങ്ങൾ അനുസരിച്ച് ഹോര്യപ്രധാനികൾ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ഇസ്രായേലിൽ രാജഭരണം വരുന്നതിനുമുമ്പ് ഏദോമിൽ ഭരണം നടത്തിയിരുന്ന രാജാക്കന്മാർ ഇവരാണ്: ");
INSERT INTO malc_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ബെയോരിന്റെ മകനായ ബേല ഏദോമിലെ രാജാവായി. അദ്ദേഹത്തിന്റെ നഗരത്തിനു ദിൻഹാബാഹ് എന്നു പേരുണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ബേലയുടെ മരണശേഷം ബൊസ്രാക്കാരനായ സേരഹിന്റെ മകൻ യോബാബ് രാജാവിന്റെ അനന്തരാവകാശിയായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","യോബാബിന്റെ മരണശേഷം തേമാന്യരുടെ ദേശത്തുനിന്നുള്ള ഹൂശാം രാജാവായി. ");
INSERT INTO malc_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ഹൂശാമിന്റെ മരണശേഷം ബേദാദിന്റെ മകനും മോവാബുദേശത്തുവെച്ച് മിദ്യാനെ തോൽപ്പിച്ചവനുമായ ഹദദ് രാജാവായി. അദ്ദേഹത്തിന്റെ നഗരത്തിന് അവീത്ത് എന്നു പേരായി. ");
INSERT INTO malc_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ഹദദിന്റെ മരണശേഷം മസ്രേക്കക്കാരനായ സമ്ളാ അദ്ദേഹത്തിനുപകരം രാജാവായി. ");
INSERT INTO malc_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","സമ്ളാ മരിച്ചപ്പോൾ നദീതീരത്തുള്ള രെഹോബോത്തിലെ നിവാസിയായ ശാവൂൽ രാജാവായി. ");
INSERT INTO malc_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ശാവൂലിന്റെ മരണശേഷം അക്ബോരിന്റെ മകനായ ബാൽ-ഹാനാൻ രാജാവായി. ");
INSERT INTO malc_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","അക്ബോരിന്റെ മകനായ ബാൽ-ഹാനാൻ മരിച്ചശേഷം ഹദദ് രാജാവായി. അദ്ദേഹത്തിന്റെ നഗരത്തിനു പാവൂ എന്നു പേരിട്ടു. അദ്ദേഹത്തിന്റെ ഭാര്യയുടെ പേര് മെഹേതബേൽ എന്നായിരുന്നു; അവൾ മേ-സാഹാബിന്റെ മകളായ മത്രേദിന്റെ മകൾ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ഏശാവിൽനിന്ന് ഉത്ഭവിച്ച പ്രഭുക്കന്മാരുടെ വംശങ്ങളും പ്രദേശങ്ങളും അനുസരിച്ചുള്ള പേരുകൾ ഇവയാകുന്നു: തിമ്നാ, അല്വാ, യെഥേത്ത്, ");
INSERT INTO malc_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ഒഹൊലീബാമാ, ഏലാ, പീനോൻ, ");
INSERT INTO malc_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","കെനസ്, തേമാൻ, മിബ്സാർ, ");
INSERT INTO malc_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","മഗ്ദീയേൽ, ഈരാം. തങ്ങൾ കൈവശപ്പെടുത്തിയ ദേശത്ത്, തങ്ങളുടെ വാസസ്ഥലങ്ങളുടെ അടിസ്ഥാനത്തിൽ ഇവരായിരുന്നു ഏദോമ്യപ്രഭുക്കന്മാർ. ഏശാവുതന്നെ ആയിരുന്നു ഏദോമ്യരുടെ പിതാവ്. ");
INSERT INTO malc_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","യാക്കോബ്, തന്റെ പിതാവു പ്രവാസിയായി താമസിച്ചിരുന്ന കനാൻദേശത്തു താമസമുറപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","യാക്കോബിന്റെ വംശപാരമ്പര്യം സംബന്ധിച്ചുള്ള വിവരണം ഇപ്രകാരം ആകുന്നു: പതിനേഴുവയസ്സുള്ള ചെറുപ്പക്കാരനായ യോസേഫ് ഒരിക്കൽ തന്റെ സഹോദരന്മാരോടുകൂടെ ആടുകളെ മേയിക്കുകയായിരുന്നു. അവൻ, തന്റെ പിതാവിന്റെ ഭാര്യമാരായ ബിൽഹായുടെയും സിൽപ്പയുടെയും പുത്രന്മാരായ തന്റെ സഹോദരന്മാർ ചെയ്യരുതാത്ത ഒരു കാര്യം പിതാവിനെ അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","തന്റെ വാർധക്യത്തിൽ തനിക്കു ജനിച്ച പുത്രനായതുകൊണ്ട് ഇസ്രായേൽ യോസേഫിനെ മറ്റു പുത്രന്മാരെക്കാൾ അധികമായി സ്നേഹിച്ചു. അതുകൊണ്ട് അദ്ദേഹം അവനു വളരെ മനോഹരമായ ഒരു കുപ്പായം ഉണ്ടാക്കിക്കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","തങ്ങളുടെ പിതാവ് എല്ലാവരെക്കാളും അധികമായി യോസേഫിനെ സ്നേഹിക്കുന്നെന്നു സഹോദരന്മാർ കണ്ടിട്ട് അവർ അവനെ വെറുത്തു; അവനോടു ദയാപൂർവം സംസാരിക്കാൻപോലും അവർക്കു കഴിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ഒരു ദിവസം യോസേഫ് ഒരു സ്വപ്നംകണ്ടു; അവൻ അതു തന്റെ സഹോദരന്മാരെ അറിയിച്ചു; അപ്പോൾ അവർ അവനെ ഏറ്റവുമധികം വെറുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","യോസേഫ് അവരോട്: “ഞാൻ കണ്ട സ്വപ്നം കേൾക്കുക: ");
INSERT INTO malc_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","നമ്മൾ എല്ലാവരുംകൂടി വയലിൽ കറ്റ കെട്ടിക്കൊണ്ടിരിക്കുകയായിരുന്നു; പെട്ടെന്ന് എന്റെ കറ്റ എഴുന്നേറ്റു നിവർന്നുനിന്നു; നിങ്ങളുടെ കറ്റകൾ ചുറ്റുംനിന്ന് എന്റെ കറ്റയെ നമസ്കരിച്ചു.” ");
INSERT INTO malc_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","യോസേഫിന്റെ സഹോദരന്മാർ അവനോട്, “ഞങ്ങളുടെമേൽ ഭരണം നടത്താനാണോ നിന്റെ ഭാവം? നീ വാസ്തവമായി ഞങ്ങളെ ഭരിക്കുമോ?” എന്നു ചോദിച്ചു, അവന്റെ സ്വപ്നവും വാക്കുകളും നിമിത്തം അവർ അവനെ പൂർവാധികം വെറുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","അവൻ മറ്റൊരു സ്വപ്നംകണ്ടു; അതും സഹോദരന്മാരെ അറിയിച്ചു: “ശ്രദ്ധിക്കുക, ഞാൻ വേറൊരു സ്വപ്നം കണ്ടിരിക്കുന്നു; ഇത്തവണ സൂര്യനും ചന്ദ്രനും പതിനൊന്നു നക്ഷത്രങ്ങളും എന്നെ താണുവണങ്ങുകയായിരുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ഇത് യോസേഫ് തന്റെ പിതാവിനെയും സഹോദരന്മാരെയും അറിയിച്ചപ്പോൾ പിതാവ് അവനെ ശാസിച്ചുകൊണ്ട്, “എന്താണു നീ കണ്ട ഈ സ്വപ്നം? നിന്റെ അമ്മയും ഞാനും നിന്റെ സഹോദരന്മാരും വന്നു നിന്നെ സാഷ്ടാംഗം നമസ്കരിക്കുമെന്നോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","അവന്റെ സഹോദരന്മാർ അവനോട് അസൂയാലുക്കളായിത്തീർന്നു; അപ്പനോ, ഇക്കാര്യം മനസ്സിൽ കരുതിവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ഒരിക്കൽ യോസേഫിന്റെ സഹോദരന്മാർ തങ്ങളുടെ പിതാവിന്റെ ആടുകളെ മേയിക്കാൻ ശേഖേമിലേക്കു പോയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","അങ്ങനെയിരിക്കെ ഒരു ദിവസം, ഇസ്രായേൽ യോസേഫിനോട്, “നിന്റെ സഹോദരന്മാർ ശേഖേമിനു സമീപം ആടുകളെ മേയിച്ചുകൊണ്ടിരിക്കുന്നെന്ന് നിനക്കറിയാമല്ലോ! വരൂ, നിന്നെ ഞാൻ അവരുടെ അടുത്തേക്കയയ്ക്കാം” എന്നു പറഞ്ഞു. “അങ്ങനെ ആകട്ടെ,” അവൻ മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","അദ്ദേഹം അവനോട്, “നീ ചെന്ന് നിന്റെ സഹോദരന്മാരും ആട്ടിൻപറ്റങ്ങളും ക്ഷേമമായിരിക്കുന്നോ എന്ന് അന്വേഷിച്ചിട്ടു മടങ്ങിവന്ന് എന്നെ വിവരം അറിയിക്കണം” എന്നു പറഞ്ഞു. പിന്നെ, അവനെ അദ്ദേഹം ഹെബ്രോൻ താഴ്വരയിൽനിന്ന് യാത്രയയച്ചു. യോസേഫ് ശേഖേമിൽ എത്തി. ");
INSERT INTO malc_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","അവൻ വയലിലൂടെ അലഞ്ഞുതിരിയുന്നതു കണ്ടിട്ട് ഒരു മനുഷ്യൻ അവനോട്, “നീ എന്താണ് അന്വേഷിക്കുന്നത്?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“ഞാൻ എന്റെ സഹോദരന്മാരെ തെരയുകയാണ്. അവർ തങ്ങളുടെ ആടുകളെ തീറ്റുന്നത് എവിടെയാണെന്നു പറഞ്ഞുതരാമോ?” യോസേഫ് ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","“അവർ ഇവിടെനിന്നു മുന്നോട്ടു പോയിട്ടുണ്ട്. ‘നമുക്കു ദോഥാനിലേക്കു പോകാം’ എന്ന് അവർ പറയുന്നതു ഞാൻ കേട്ടു,” എന്ന് ആ മനുഷ്യൻ ഉത്തരം പറഞ്ഞു. അങ്ങനെ യോസേഫ് സഹോദരന്മാരെ പിൻതുടർന്നു; ദോഥാനിൽവെച്ച് അവരെ കണ്ടെത്തുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","അവർ ദൂരെനിന്ന് അവനെ കണ്ടിട്ട്, അവൻ തങ്ങളുടെ അടുക്കൽ എത്തുന്നതിനുമുമ്പ്, അവനെ കൊല്ലുന്നതിനു ഗൂഢാലോചന നടത്തി. ");
INSERT INTO malc_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“ഇതാ, ആ സ്വപ്നക്കാരൻ വരുന്നു,” അവർ പരസ്പരം പറഞ്ഞു, ");
INSERT INTO malc_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“വരിക, നമുക്ക് അവനെ കൊന്ന് ഒരു ജലസംഭരണിയിൽ ഇട്ടുകളയാം, എന്നിട്ട് ഒരു ഹിംസ്രജന്തു അവനെ തിന്നുകളഞ്ഞു എന്നു പറയുകയും ചെയ്യാം. അപ്പോൾ അവന്റെ സ്വപ്നങ്ങൾ എന്താകുമെന്ന് നമുക്കു കാണാമല്ലോ.” ");
INSERT INTO malc_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","രൂബേൻ ഇതു കേട്ടപ്പോൾ, അയാൾ യോസേഫിനെ അവരുടെ കൈയിൽനിന്നു രക്ഷപ്പെടുത്താൻ ശ്രമിച്ചു. “നാം അവനു ജീവഹാനി വരുത്തുകയോ ");
INSERT INTO malc_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","രക്തം ചൊരിയിക്കുകയോ ചെയ്യരുത്. ഇവിടെ മരുഭൂമിയിൽ, ഇതാ, ഈ ജലസംഭരണിയിൽ അവനെ ഇട്ടുകളയുക, അവന്റെമേൽ കൈവെക്കരുത്.” രൂബേൻ ഇതു പറഞ്ഞത് യോസേഫിനെ അവരിൽനിന്ന് രക്ഷിച്ച് തന്റെ പിതാവിന്റെ അടുത്തേക്കു കൊണ്ടുപോകുന്നതിനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","യോസേഫ് തന്റെ സഹോദരന്മാരുടെ അടുത്തെത്തി. അവർ അവന്റെ മനോഹരമായ കുപ്പായം ഊരിയെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","പിന്നെ അവനെ അവർ ആ ജലസംഭരണിയിൽ തള്ളിയിട്ടു. അതൊരു വെള്ളമില്ലാത്ത പൊട്ടിയ ജലസംഭരണി ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","അവർ ഭക്ഷണം കഴിക്കാൻ ഇരുന്നു; അവർ തലയുയർത്തിനോക്കിയപ്പോൾ, യിശ്മായേല്യരുടെ ഒരു വ്യാപാരസംഘം ഗിലെയാദിൽനിന്ന് വരുന്നതു കണ്ടു. അവരുടെ ഒട്ടകങ്ങളുടെ പുറത്ത് സുഗന്ധവസ്തുക്കളും ലേപവും മീറയും നിറച്ചിരുന്നു; അവർ ആ സാധനങ്ങൾ ഈജിപ്റ്റിലേക്കു കൊണ്ടുപോകുകയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","യെഹൂദാ തന്റെ സഹോദരന്മാരോടു പറഞ്ഞു: “നാം നമ്മുടെ സഹോദരനെ കൊന്ന്, അവന്റെ രക്തം മറച്ചുവെച്ചാൽ നമുക്കെന്തു നേട്ടം? ");
INSERT INTO malc_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","വരിക, നമുക്ക് അവനെ യിശ്മായേല്യർക്കു വിൽക്കാം, അവന്റെമേൽ കൈവെക്കേണ്ടതില്ല; അവൻ നമ്മുടെ സഹോദരനും നമ്മുടെ മാംസവുമാണല്ലോ!” ഇത് അവന്റെ സഹോദരന്മാർക്കു സമ്മതമായി. ");
INSERT INTO malc_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","മിദ്യാന്യവ്യാപാരികൾ അടുത്തെത്തിയപ്പോൾ യോസേഫിന്റെ സഹോദരന്മാർ അവനെ ജലസംഭരണിയിൽനിന്നും വലിച്ചെടുത്ത് ഇരുപതുശേക്കേൽ വെള്ളിക്ക് യിശ്മായേല്യർക്ക് വിറ്റു; അവർ യോസേഫിനെ ഈജിപ്റ്റിലേക്കു കൊണ്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","രൂബേൻ മടങ്ങിയെത്തി ആ ജലസംഭരണിയിൽ നോക്കിയപ്പോൾ യോസേഫ് അതിൽ ഇല്ലെന്നു കണ്ടിട്ട് തന്റെ വസ്ത്രംകീറി. ");
INSERT INTO malc_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","അവൻ സഹോദരന്മാരുടെ അടുക്കൽ തിരിച്ചെത്തി അവരോട്: “ബാലൻ അവിടെ ഇല്ലല്ലോ! ഞാൻ ഇനി എവിടെയാണ് പോകേണ്ടത്?” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","അതിനുശേഷം അവർ യോസേഫിന്റെ കുപ്പായം എടുത്തു, ഒരു കോലാടിനെ കൊന്ന് അതിന്റെ രക്തത്തിൽ മുക്കി. ");
INSERT INTO malc_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ആ വിശേഷപ്പെട്ട അങ്കി തങ്ങളുടെ പിതാവിന്റെ അടുക്കൽ കൊണ്ടുചെന്ന്, “ഇതു ഞങ്ങൾ കണ്ടെത്തി; ഇത് അങ്ങയുടെ മകന്റെ അങ്കിതന്നെയോ എന്നു പരിശോധിച്ച് നോക്കിയാലും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","അദ്ദേഹം അതു തിരിച്ചറിഞ്ഞു. “ഇത് എന്റെ മകന്റെ കുപ്പായംതന്നെ! ഏതോ ഹിംസ്രജന്തു അവനെ തിന്നുകളഞ്ഞു; യോസേഫിനെ അതു പിച്ചിച്ചീന്തിക്കളഞ്ഞുകാണും,” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","പിന്നെ യാക്കോബ് തന്റെ വസ്ത്രംകീറി, ചാക്കുശീല ഉടുത്ത് തന്റെ മകനെച്ചൊല്ലി അനേകദിവസം വിലപിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","അദ്ദേഹത്തിന്റെ എല്ലാ പുത്രന്മാരും പുത്രിമാരും അടുത്തുവന്ന് അദ്ദേഹത്തെ ആശ്വസിപ്പിക്കാൻ ശ്രമിച്ചു; എങ്കിലും അദ്ദേഹം ആശ്വാസം കൈക്കൊള്ളാൻ വിസമ്മതിച്ചു. “കരഞ്ഞുകൊണ്ടുതന്നെ ഞാൻ പാതാളത്തിൽ എന്റെ മകന്റെ അടുക്കൽ ഇറങ്ങിച്ചെല്ലും,” എന്ന് അദ്ദേഹം പറഞ്ഞു. അങ്ങനെ യോസേഫിന്റെ പിതാവ് അവനെച്ചൊല്ലി കരഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ഇതിനിടയിൽ മിദ്യാന്യർ, യോസേഫിനെ ഈജിപ്റ്റിൽ ഫറവോന്റെ ഉദ്യോഗസ്ഥന്മാരിൽ ഒരാളും അംഗരക്ഷകരുടെ അധിപനുമായ പോത്തീഫറിനു വിറ്റു. ");
INSERT INTO malc_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ആ കാലത്ത് യെഹൂദാ തന്റെ സഹോദരന്മാരെവിട്ട് അദുല്ലാമിലുള്ള ഹീരാ എന്നു പേരായ ഒരു മനുഷ്യന്റെ അടുക്കലേക്ക് പോയി അവിടെ താമസമാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","അവിടെവെച്ച് അദ്ദേഹം ശൂവാ എന്നു പേരുള്ള ഒരു കനാന്യന്റെ മകളെ കണ്ടു. യെഹൂദാ അവളെ വിവാഹംചെയ്ത് അവളെ അറിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","അവൾ ഗർഭിണിയായി ഒരു മകനെ പ്രസവിച്ചു, ആ മകന് ഏർ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","അവൾ പിന്നെയും ഗർഭംധരിച്ച് ഒരു മകനെ പ്രസവിക്കുകയും അവന് ഓനാൻ എന്നു പേരിടുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","അവൾ വീണ്ടും ഒരു മകനെ പ്രസവിച്ചു; അവന് ശേലഹ് എന്നു പേരിട്ടു. അവൾ അവനെ പ്രസവിച്ചത് കെസീബിൽവെച്ചായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","യെഹൂദാ തന്റെ ആദ്യജാതനായ ഏരിനു ഭാര്യയായി ഒരുവളെ എടുത്തു; അവളുടെ പേര് താമാർ എന്നായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","എന്നാൽ യെഹൂദയുടെ ആദ്യജാതനായ ഏർ യഹോവയുടെ ദൃഷ്ടിയിൽ ഒരു ദുഷ്ടനായിരുന്നു. അതുകൊണ്ട് യഹോവ അവനെ കൊന്നുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","അപ്പോൾ യെഹൂദാ ഓനാനോട്, “നീ നിന്റെ സഹോദരന്റെ ഭാര്യയുടെ അടുക്കൽ ചെന്ന്, സഹോദരനുവേണ്ടി സന്തതിയെ ഉളവാക്കാൻ ഭർത്തൃസഹോദരൻ എന്നനിലയ്ക്കുള്ള ധർമം നിറവേറ്റുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","എന്നാൽ അങ്ങനെ ജനിക്കുന്ന സന്തതി തന്റേതാകുകയില്ല എന്ന് അറിഞ്ഞിട്ട്, സഹോദരനു സന്തതി ഉണ്ടാകാതിരിക്കാൻ, സഹോദരഭാര്യയോടുകൂടെ കിടക്കപങ്കിട്ടപ്പോഴെല്ലാം ഓനാൻ ബീജം നിലത്തു വീഴ്ത്തിക്കളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","അവന്റെ പ്രവൃത്തി യഹോവയുടെ ദൃഷ്ടിയിൽ ദോഷമുള്ളതായിരുന്നു; അതുകൊണ്ട് അവിടന്ന് അവനെയും കൊന്നുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","യെഹൂദാ പിന്നെ തന്റെ മരുമകളായ താമാറിനോട്, “എന്റെ മകൻ ശേലഹ് പ്രായപൂർത്തിയാകുന്നതുവരെ നീ നിന്റെ അപ്പന്റെ വീട്ടിൽപ്പോയി വിധവയായി ജീവിക്കുക” എന്നു പറഞ്ഞു. “അവനും ജ്യേഷ്ഠന്മാരെപ്പോലെ മരിച്ചുപോകും” എന്നായിരുന്നു അദ്ദേഹത്തിന്റെ ചിന്ത. അങ്ങനെ താമാർ തന്റെ പിതൃഭവനത്തിൽപോയി താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ഏറെ കാലത്തിനുശേഷം യെഹൂദയുടെ ഭാര്യ—ശൂവായുടെ മകൾ—മരിച്ചു. യെഹൂദാ ദുഃഖത്തിൽനിന്ന് മോചിതനായശേഷം തിമ്നയിൽ തന്റെ ആടുകളുടെ രോമം കത്രിക്കുന്നവരുടെ അടുത്തേക്കുപോയി; അദുല്ലാമ്യനും തന്റെ സ്നേഹിതനുമായ ഹീരാ അദ്ദേഹത്തോടൊപ്പം പോയി. ");
INSERT INTO malc_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","“തന്റെ അമ്മായിയപ്പൻ ആടുകളുടെ രോമം കത്രിക്കലിനുവേണ്ടി തിമ്നയിലേക്കു പോകുന്നു,” എന്ന് താമാരിന് അറിവുകിട്ടി. ");
INSERT INTO malc_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","അവൾ തന്റെ വൈധവ്യവസ്ത്രങ്ങൾ മാറ്റി, ആളറിയാതിരിക്കാൻ മൂടുപടംകൊണ്ട് സ്വയം മറച്ചു. അതിനുശേഷം തിമ്നയിലേക്കുള്ള വഴിയിൽ എനയീമിന്റെ പ്രവേശനകവാടത്തിൽ ചെന്നിരുന്നു; ഇതിനുകാരണം ശേലഹ് പ്രായമായിട്ടും, തന്നെ അവനു ഭാര്യയായി കൊടുത്തില്ല എന്നതായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","അവൾ മുഖം മറച്ചിരുന്നതുകൊണ്ട് യെഹൂദാ അവളെ കണ്ടപ്പോൾ അവൾ ഒരു ഗണിക ആയിരിക്കുമെന്നു കരുതി. ");
INSERT INTO malc_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","അവൾ തന്റെ മരുമകളാണെന്നുള്ളതു തിരിച്ചറിയാതെ അയാൾ വഴിവക്കിൽ അവളുടെ അടുത്തുചെന്ന്, “വരിക, ഞാൻ നിന്റെ അടുക്കൽ വരട്ടെ” എന്നു ചോദിച്ചു. “എന്റെ അടുക്കൽ വരുന്നതിന് നീ എനിക്ക് എന്തുതരും?” അവൾ ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“എന്റെ ആട്ടിൻപറ്റത്തിൽനിന്ന് ഒരു ആട്ടിൻകുട്ടിയെ ഞാൻ നിനക്കു കൊടുത്തയയ്ക്കാം,” അയാൾ മറുപടി പറഞ്ഞു. “അതു കൊടുത്തയയ്ക്കുന്നതുവരെ എനിക്ക് എന്തെങ്കിലും പണയമായിത്തരാമോ,” എന്ന് അവൾ ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","അതിന് അയാൾ, “എന്തു പണയമാണു നിനക്കുവേണ്ടത്?” എന്നു ചോദിച്ചു. “താങ്കളുടെ മുദ്രമോതിരവും അതിന്റെ ചരടും താങ്കളുടെ കൈയിൽ ഇരിക്കുന്ന വടിയും,” അവൾ ഉത്തരം പറഞ്ഞു. അയാൾ അതെല്ലാം അവൾക്കുകൊടുത്തു; എന്നിട്ട് അവളോടുകൂടെ കിടക്കപങ്കിട്ടു. അയാൾനിമിത്തം അവൾ ഗർഭംധരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","അതിനുശേഷം അവൾ തന്റെ ഭവനത്തിലേക്ക് പോയി മൂടുപടം നീക്കി വീണ്ടും തന്റെ വൈധവ്യവസ്ത്രം ധരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","യെഹൂദാ ആ സ്ത്രീയുടെ പക്കൽനിന്ന് തന്റെ പണയം തിരികെ വാങ്ങുന്നതിന് സ്നേഹിതനായ അദുല്ലാമ്യൻവശം ആട്ടിൻകുട്ടിയെ കൊടുത്തയച്ചു; എന്നാൽ അയാൾക്ക് അവളെ കണ്ടെത്താൻ കഴിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","അവൻ അവിടെ താമസിച്ചിരുന്ന ആളുകളോട്, “എനയീമിലേക്കുള്ള വഴിയുടെ അരികിൽ ഇരുന്നിരുന്ന ആ ക്ഷേത്രഗണിക എവിടെയാണ്?” എന്നു ചോദിച്ചു. “ഇവിടെ അങ്ങനെ ഒരു ക്ഷേത്രഗണിക ഉണ്ടായിരുന്നില്ലല്ലോ,” അവർ മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","അവൻ തിരികെച്ചെന്ന് യെഹൂദയോട്, “ഞാൻ അവളെ കണ്ടില്ല. തന്നെയുമല്ല, ‘ഇവിടെ ഒരു ക്ഷേത്രഗണിക ഉണ്ടായിരുന്നില്ല’ എന്ന് അവിടെ താമസിക്കുന്നവർ പറയുകയും ചെയ്തു” എന്നറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","അപ്പോൾ യെഹൂദാ, “അവൾ അത് എടുക്കട്ടെ; അല്ലെങ്കിൽ നമ്മൾ പരിഹാസപാത്രമായിത്തീരും. ഏതായാലും, ഞാൻ ഈ ആട്ടിൻകുട്ടിയെ അവൾക്കു കൊടുത്തയച്ചു, നീ അവളെ കണ്ടെത്തിയതുമില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ഏകദേശം മൂന്നുമാസം കഴിഞ്ഞ്, “നിന്റെ മരുമകളായ താമാർ വേശ്യാവൃത്തി നിമിത്തം കുറ്റക്കാരി ആയിരിക്കുന്നു. അതിന്റെ ഫലമായി അവൾ ഇപ്പോൾ ഗർഭിണിയുമാണ്” എന്ന് യെഹൂദയ്ക്ക് അറിവുകിട്ടി. “അവളെ ഇവിടെ കൊണ്ടുവന്നു ജീവനോടെ ദഹിപ്പിക്കുക,” യെഹൂദാ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","അങ്ങനെ അവളെ കൊണ്ടുവരുമ്പോൾ അവൾ തന്റെ അമ്മായിയപ്പന്, “ഈ മുദ്രയും ചരടും വടിയും ആരുടേത് എന്നു തിരിച്ചറിയുന്നോ? ഇവയുടെ ഉടമസ്ഥൻ നിമിത്തമത്രേ ഞാൻ ഗർഭിണിയായിരിക്കുന്നത്” എന്ന് ഒരു സന്ദേശം അയച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","യെഹൂദാ അവയെ തിരിച്ചറിഞ്ഞിട്ട്, “അവൾ എന്നെക്കാൾ നീതിയുള്ളവൾ; ഞാൻ അവളെ എന്റെ മകൻ ശേലഹിനു കൊടുത്തില്ലല്ലോ” എന്നു പറഞ്ഞു. അയാൾ പിന്നീട് അവളോടുകൂടെ കിടക്കപങ്കിട്ടില്ല. ");
INSERT INTO malc_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","അവളുടെ പ്രസവസമയം അടുത്തു; ഇരട്ടകളായ ആൺകുട്ടികളാണ് അവളുടെ ഉദരത്തിൽ ഉണ്ടായിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","അവൾ പ്രസവിക്കുമ്പോൾ അവരിൽ ഒരുവൻ തന്റെ കൈ പുറത്തേക്കിട്ടു; അപ്പോൾ സൂതികർമിണി ഒരു ചെമന്നചരട് എടുത്ത് അവന്റെ കൈത്തണ്ടയിൽ കെട്ടി, “ഇവൻ ഒന്നാമതു പുറത്തുവന്നു” എന്നു പറഞ്ഞു, ");
INSERT INTO malc_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","എന്നാൽ അവൻ കൈ അകത്തേക്കു വലിച്ചപ്പോൾ അവന്റെ സഹോദരൻ പുറത്തുവന്നു; “നീ നിനക്കായിത്തന്നെ ഇങ്ങനെയോ വഴിയുണ്ടാക്കിയത്!” അവൾ പറഞ്ഞു. അവന് ഫേരെസ്സ് എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","അതിനുശേഷം, കൈത്തണ്ടയിൽ ചെമന്നനൂലുണ്ടായിരുന്ന അവന്റെ സഹോദരൻ പുറത്തുവന്നു; അവന് സേരഹ് എന്ന പേരുനൽകി. ");
INSERT INTO malc_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","അങ്ങനെ യോസേഫിനെ യിശ്മായേല്യ കച്ചവടക്കാർ ഈജിപ്റ്റിലേക്കു കൊണ്ടുപോയി. അവനെ അവിടേക്കു കൊണ്ടുപോയ യിശ്മായേല്യരുടെ പക്കൽനിന്ന് ഫറവോന്റെ ഉദ്യോഗസ്ഥന്മാരിൽ ഒരുവനും അംഗരക്ഷകരുടെ അധിപനുമായ പോത്തീഫർ എന്ന ഒരു ഈജിപ്റ്റുകാരൻ വിലയ്ക്കുവാങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","യഹോവ യോസേഫിനോടുകൂടെ ഉണ്ടായിരുന്നതുകൊണ്ട് അവൻ അഭിവൃദ്ധിപ്രാപിച്ചു. അവൻ ഈജിപ്റ്റുകാരനായ യജമാനന്റെ വീട്ടിൽ ജീവിച്ചുപോന്നു. ");
INSERT INTO malc_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","യഹോവ അവനോടുകൂടെയുണ്ട് എന്നും എല്ലാ പ്രവർത്തനങ്ങളിലും അവനു വിജയം നൽകുന്നെന്നും അവന്റെ യജമാനൻ മനസ്സിലാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","പോത്തീഫർ ഇതിൽ സന്തുഷ്ടനാകുകയും യോസേഫിനെ അദ്ദേഹത്തിന്റെ പരിചാരകനാക്കുകയും ചെയ്തു. അങ്ങനെ പോത്തീഫർ തന്റെ ഗൃഹകാര്യങ്ങളുടെ അധികാരിയായി യോസേഫിനെ നിയമിക്കുകയും തനിക്കുള്ളതെല്ലാം അവനെ ഭരമേൽപ്പിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","പോത്തീഫർ യോസേഫിനെ തന്റെ ഭവനത്തിന്റെയും തന്റെ സ്വത്തുക്കളുടെയും മേലധികാരിയായി നിയമിച്ചപ്പോൾമുതൽ യഹോവ യോസേഫ് നിമിത്തം അദ്ദേഹത്തിന്റെ ഭവനത്തെ അനുഗ്രഹിച്ചു. വീട്ടിലും വയലിലും ഉണ്ടായിരുന്ന സകലത്തിന്റെമേലും യഹോവയുടെ അനുഗ്രഹം ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","അതുകൊണ്ട് പോത്തീഫർ തന്റെ സകലസ്വത്തും യോസേഫിന്റെ അധികാരത്തിൻകീഴിൽ വിട്ടുകൊടുത്തു; താൻ കഴിക്കുന്ന ആഹാരം ഒഴികെയുള്ള മറ്റൊരു കാര്യത്തിലും ഇടപെട്ടതുമില്ല. യോസേഫ് ദൃഢഗാത്രനും അതിസുന്ദരനും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","കുറെക്കാലത്തിനുശേഷം അവന്റെ യജമാനന്റെ ഭാര്യ യോസേഫിൽ ആസക്തയായി, “എന്നോടൊപ്പം കിടക്കയിലേക്കു വരിക” അവൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","യോസേഫ് ആ ക്ഷണം നിരസിച്ചു. “എന്റെ യജമാനൻ എന്നെ കാര്യവിചാരകനാക്കിയതിനുശേഷം വീട്ടിലുള്ള ഒരു കാര്യത്തിലും ഇടപെടുന്നില്ല; തന്റെ ഉടമസ്ഥതയിലുള്ളതെല്ലാം അദ്ദേഹം എന്നെ ഭരമേൽപ്പിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ഈ ഭവനത്തിൽ എന്നെക്കാൾ വലിയവനായി ആരുമില്ല. നിങ്ങൾ എന്റെ യജമാനന്റെ ഭാര്യ ആയതിനാൽ നിങ്ങളെ ഒഴികെ, മറ്റൊന്നും എനിക്കു വിട്ടുതരാതെയിരുന്നിട്ടില്ല. അങ്ങനെയിരിക്കെ, ഇത്തരം ഒരു ദുഷ്കർമം ചെയ്യാനും ദൈവത്തോടു പാപം ചെയ്യാനും എനിക്കെങ്ങനെ കഴിയും?” എന്ന് യോസേഫ് ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","അവൾ ദിവസംതോറും യോസേഫിനോടു സംസാരിച്ചെങ്കിലും അവളോടൊപ്പം കിടക്ക പങ്കിടാനോ അവളുടെ സമീപത്തു നിൽക്കാൻപോലുമോ അവൻ കൂട്ടാക്കിയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ഒരു ദിവസം യോസേഫ് തന്റെ ചുമതലയിൽപ്പെട്ട കാര്യങ്ങൾ ചെയ്യുന്നതിന് വീടിനുള്ളിലേക്കു പോയി; വീട്ടിലെ വേലക്കാർ ആരുംതന്നെ അകത്തുണ്ടായിരുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","അവൾ അവന്റെ പുറങ്കുപ്പായത്തിൽ കടന്നു പിടിച്ചിട്ട്, “എന്നോടൊപ്പം കിടക്കയിലേക്കു വരിക” എന്നു പറഞ്ഞു. എന്നാൽ അവൻ ആ പുറങ്കുപ്പായം അവളുടെ കൈയിൽ വിട്ടിട്ട് വീടിനു പുറത്തേക്ക് ഓടിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","അവൻ ഇങ്ങനെ പുറങ്കുപ്പായം അവളുടെ കൈയിൽ വിട്ടുകൊടുത്തിട്ടു വീടിനു പുറത്തേക്ക് ഓടിപ്പോയി എന്നുകണ്ടപ്പോൾ ");
INSERT INTO malc_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","അവൾ തന്റെ വീട്ടുവേലക്കാരെ വിളിച്ചു; “ഇതാ, നമ്മെ അപഹാസ്യരാക്കാനാണ് ഈ എബ്രായനെ കൊണ്ടുവന്നിരിക്കുന്നത്. എന്നോടൊപ്പം കിടക്കപങ്കിടാൻ അവൻ അകത്തു കയറിവന്നു; എന്നാൽ ഞാൻ നിലവിളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ഞാൻ സഹായത്തിനായി നിലവിളിക്കുന്നതു കേട്ടിട്ട് അവൻ തന്റെ കുപ്പായം എന്റെ അടുക്കൽ ഉപേക്ഷിച്ചിട്ട് വീടിനു പുറത്തേക്ക് ഓടിക്കളഞ്ഞു.” ");
INSERT INTO malc_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","അവന്റെ യജമാനൻ വീട്ടിൽ എത്തുന്നതുവരെ അവൾ യോസേഫിന്റെ പുറങ്കുപ്പായം തന്റെ അടുക്കൽ സൂക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","അവൾ അതേ വാക്കുകൾതന്നെ അദ്ദേഹത്തോടും പറഞ്ഞു: “അങ്ങു കൊണ്ടുവന്ന എബ്രായദാസൻ എന്നെ അപഹാസ്യയാക്കാനായി എന്റെ അടുക്കൽവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","എന്നാൽ സഹായത്തിനായി ഞാൻ നിലവിളിച്ചമാത്രയിൽത്തന്നെ അവൻ തന്റെ കുപ്പായം എന്റെ അടുക്കൽ ഉപേക്ഷിച്ചിട്ട് വീടിനു പുറത്തേക്ക് ഓടിക്കളഞ്ഞു.” ");
INSERT INTO malc_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“ഈ വിധത്തിലാണ് അങ്ങയുടെ അടിമ എന്നോടു പെരുമാറിയത്,” തന്റെ ഭാര്യ പറഞ്ഞ കഥ കേട്ടപ്പോൾ യജമാനൻ കോപംകൊണ്ടു ജ്വലിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","യോസേഫിന്റെ യജമാനൻ അവനെ പിടിച്ചു രാജാവിന്റെ തടവുകാരെ ഇടുന്ന കാരാഗൃഹത്തിലാക്കി. അങ്ങനെ യോസേഫ് കാരാഗൃഹത്തിൽ ആയിരുന്നപ്പോൾ ");
INSERT INTO malc_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","യഹോവ യോസേഫിനോടുകൂടെ ഉണ്ടായിരുന്നു; അവിടന്ന് അവനോടു കരുണ കാണിക്കുകയും ജയിലധികാരിക്ക് അവനോടു ദയ തോന്നാൻ ഇടയാക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","അതുകൊണ്ട് അധികാരി കാരാഗൃഹത്തിൽ ഉള്ള എല്ലാവരുടെയും മേൽനോട്ടം യോസേഫിനെ ഏൽപ്പിച്ചു. അവിടെ നടക്കുന്ന കാര്യങ്ങളുടെയെല്ലാം ഉത്തരവാദിത്വം അവനു നൽകി. ");
INSERT INTO malc_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","യഹോവ യോസേഫിനോടുകൂടെ ഉണ്ടായിരുന്നു; അതിനാൽ അവൻ ചെയ്ത സകലകാര്യങ്ങളിലും അവനു വിജയം ലഭിച്ചു; യോസേഫിന്റെ ചുമതലയിലുള്ള ഒരു കാര്യത്തിലും ജയിലധികാരി ശ്രദ്ധ ചെലുത്തിയതുമില്ല. ");
INSERT INTO malc_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","കുറെ കാലത്തിനുശേഷം ഈജിപ്റ്റുരാജാവിന്റെ വീഞ്ഞുകാരനും അപ്പക്കാരനും തങ്ങളുടെ യജമാനനായ ഈജിപ്റ്റുരാജാവിനെതിരേ തെറ്റുചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","പ്രധാന വീഞ്ഞുകാരനും പ്രധാന അപ്പക്കാരനും ആയ ഈ രണ്ട് ഉദ്യോഗസ്ഥന്മാരുടെ നേർക്കു ഫറവോനു കോപം ജ്വലിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","അദ്ദേഹം അവരെ അംഗരക്ഷകരുടെ അധിപന്റെ വീട്ടിൽ, യോസേഫിനെ സൂക്ഷിച്ചിരുന്ന അതേ കാരാഗൃഹത്തിൽ അടച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","അംഗരക്ഷകരുടെ അധിപൻ അവരെ യോസേഫിനെ ഏൽപ്പിക്കുകയും അവൻ അവരെ ശുശ്രൂഷിക്കുകയും ചെയ്തു. കുറെക്കാലം അവർ തടവിൽ കഴിഞ്ഞപ്പോൾ, ");
INSERT INTO malc_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","കാരാഗൃഹത്തിൽ ബന്ധിക്കപ്പെട്ടിരുന്ന അവർ ഇരുവരും—ഈജിപ്റ്റുരാജാവിന്റെ വീഞ്ഞുകാരനും അപ്പക്കാരനും—വ്യത്യസ്ത അർഥം വരുന്ന ഓരോ സ്വപ്നം ഒരേരാത്രിയിൽ കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","പിറ്റേന്നു രാവിലെ യോസേഫ് അവരുടെ അടുക്കൽ എത്തിയപ്പോൾ അവർ വിഷാദിച്ചിരിക്കുന്നതായി കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","യജമാനന്റെ ഭവനത്തിൽ തന്നോടൊപ്പം ബന്ധനത്തിൽ ആയിരുന്ന, ഫറവോന്റെ ആ ഉദ്യോഗസ്ഥന്മാരോട് അവൻ, “ഇന്നു നിങ്ങളുടെ മുഖം ഇത്ര മ്ലാനമായിരിക്കുന്നതെന്ത്?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“ഞങ്ങൾ രണ്ടുപേരും ഓരോ സ്വപ്നം കണ്ടിരിക്കുന്നു; എന്നാൽ അവയെ വ്യാഖ്യാനിക്കാൻ ആരുമില്ല,” എന്ന് അവർ ഉത്തരം പറഞ്ഞു. അപ്പോൾ യോസേഫ് അവരോട്, “വ്യാഖ്യാനം ദൈവത്തിനുള്ളതല്ലയോ? നിങ്ങളുടെ സ്വപ്നങ്ങൾ എന്നോടു പറയുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","പ്രധാന വീഞ്ഞുകാരൻ തന്റെ സ്വപ്നം യോസേഫിനെ പറഞ്ഞുകേൾപ്പിച്ചു; അവൻ ഇങ്ങനെ വിവരിച്ചു: “എന്റെ സ്വപ്നത്തിൽ ഞാൻ എന്റെമുമ്പിൽ ഒരു മുന്തിരിവള്ളി കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ആ മുന്തിരിവള്ളിക്കു മൂന്നു ശാഖകൾ ഉണ്ടായിരുന്നു. അതു തളിരിട്ടപ്പോൾത്തന്നെ പുഷ്പിക്കുകയും മുന്തിരിക്കുലകൾ പഴുത്തു പാകമാകുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ഫറവോന്റെ പാനപാത്രം എന്റെ കൈയിൽ ഉണ്ടായിരുന്നു, ഞാൻ മുന്തിരിങ്ങ എടുത്ത് ഫറവോന്റെ പാനപാത്രത്തിലേക്കു പിഴിഞ്ഞൊഴിച്ച് പാത്രം അദ്ദേഹത്തിന്റെ കൈയിൽ കൊടുത്തു.” ");
INSERT INTO malc_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","യോസേഫ് അവനോടു പറഞ്ഞു, “അതിന്റെ അർഥം ഇതാണ്: മൂന്നു ശാഖകൾ മൂന്നു ദിവസങ്ങളാണ്. ");
INSERT INTO malc_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ഫറവോൻ മൂന്നുദിവസത്തിനകം നിന്നെ ഉയർത്തി നിന്റെ പഴയ സ്ഥാനത്ത് ആക്കും; നീ ഫറവോന്റെ പാനപാത്രവാഹകൻ ആയിരുന്നപ്പോൾ ചെയ്തുപോന്നിരുന്നതുപോലെ അദ്ദേഹത്തിന്റെ പാനപാത്രം അദ്ദേഹത്തിന്റെ കൈയിൽ കൊടുക്കും. ");
INSERT INTO malc_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","എന്നാൽ നിന്റെ കാര്യങ്ങൾ ശുഭമായിത്തീരുമ്പോൾ എന്നെ ഓർക്കുകയും എന്നോടു ദയ കാണിക്കുകയും വേണം; എന്റെ കാര്യം ഫറവോനോടു പറഞ്ഞ് എന്നെ ഈ തടവറയിൽനിന്ന് മോചിപ്പിക്കേണം. ");
INSERT INTO malc_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","എബ്രായരുടെ ദേശത്തുനിന്ന് എന്നെ ബലാൽക്കാരമായി പിടിച്ചുകൊണ്ടുവന്നതാണ്; എന്നെ ഇങ്ങനെ തടവറയിൽ അടയ്ക്കാൻ തക്കവണ്ണം ഇവിടെയും ഞാൻ യാതൊന്നുംതന്നെ ചെയ്തിട്ടില്ല.” ");
INSERT INTO malc_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ശുഭസൂചകമായ വ്യാഖ്യാനമാണു യോസേഫ് നൽകിയതെന്നു കണ്ടിട്ട് പ്രധാന അപ്പക്കാരൻ യോസേഫിനോട്: “ഞാനും ഒരു സ്വപ്നംകണ്ടു: എന്റെ തലയിൽ മൂന്നുകുട്ട അപ്പം ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","മുകളിലത്തെ കുട്ടയിൽ ഫറവോനുവേണ്ടി ചുട്ടെടുത്ത എല്ലാവിധ ഭക്ഷ്യവസ്തുക്കളും ഉണ്ടായിരുന്നു. എന്നാൽ പക്ഷികൾ എന്റെ തലയിലെ ആ കുട്ടയിൽനിന്ന് അതെല്ലാം തിന്നുകയായിരുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","അപ്പോൾ യോസേഫ് അവനോട്, “അതിന്റെ അർഥം ഇതാണ്: മൂന്നുകുട്ടകൾ മൂന്നുദിവസം. ");
INSERT INTO malc_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ഫറവോൻ മൂന്നുദിവസത്തിനകം നിന്റെ തല വെട്ടിക്കളയുകയും, നിന്നെ ഒരു മരത്തിൽ തൂക്കുകയും ചെയ്യും; പക്ഷികൾ നിന്റെ മാംസം തിന്നുകയും ചെയ്യും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","മൂന്നാംദിവസം ഫറവോന്റെ ജന്മദിനം ആയിരുന്നു; അദ്ദേഹം തന്റെ എല്ലാ ഉദ്യോഗസ്ഥന്മാർക്കുമായി ഒരു വിരുന്നുസൽക്കാരം നടത്തി. ഉദ്യോഗസ്ഥന്മാരുടെ സാന്നിധ്യത്തിൽ അദ്ദേഹം പ്രധാന വീഞ്ഞുകാരനെയും പ്രധാന അപ്പക്കാരനെയും ഓർത്തു. ");
INSERT INTO malc_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","പ്രധാന വീഞ്ഞുകാരനെ അദ്ദേഹം വീണ്ടും അവന്റെ പഴയ സ്ഥാനത്തു നിയമിച്ചു; അങ്ങനെ അവന് വീണ്ടും ഫറവോന്റെ കൈയിൽ പാനപാത്രം കൊടുക്കാൻ സാധിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","എന്നാൽ പ്രധാന അപ്പക്കാരനെ, യോസേഫ് വ്യാഖ്യാനത്തിൽ അവനോട് അറിയിച്ചിരുന്നതുപോലെ ഫറവോൻ തൂക്കിക്കൊന്നു. ");
INSERT INTO malc_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","എന്നാൽ പ്രധാന വീഞ്ഞുകാരൻ യോസേഫിനെ ഓർത്തില്ല; അദ്ദേഹം യോസേഫിനെ പാടേ മറന്നുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","രണ്ടുവർഷം കഴിഞ്ഞപ്പോൾ ഫറവോൻ ഒരു സ്വപ്നംകണ്ടു: അദ്ദേഹം നൈൽനദീതീരത്തു നിൽക്കുകയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","അപ്പോൾ കാഴ്ചയ്ക്കു മോടിയുള്ളതും കൊഴുത്തതുമായ ഏഴു പശുക്കൾ നദിയിൽനിന്ന് കയറിവന്ന് ഞാങ്ങണകൾക്കിടയിൽ മേഞ്ഞുകൊണ്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","അതിനുശേഷം അവയുടെ പിന്നാലെ വിരൂപവും മെലിഞ്ഞതുമായ വേറെ ഏഴു പശുക്കൾ നദിയിൽനിന്ന് കയറിവന്നു. അവ നദീതീരത്തു നിന്നിരുന്ന പശുക്കളുടെ അരികിൽത്തന്നെ വന്നുനിന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","മെലിഞ്ഞു വിരൂപമായ പശുക്കൾ ഭംഗിയും പുഷ്ടിയുമുള്ള ഏഴു പശുക്കളെ തിന്നുകളഞ്ഞു! അപ്പോൾ ഫറവോൻ ഉണർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","അദ്ദേഹം വീണ്ടും ഉറങ്ങി. രണ്ടാമതൊരു സ്വപ്നംകണ്ടു: ഇതാ, ഒരു തണ്ടിൽ പുഷ്ടിയുള്ളതും നല്ലതുമായ ഏഴു കതിരുകൾ മുളച്ചുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","അവയ്ക്കു പിന്നാലെ, നേർത്തതും കിഴക്കൻകാറ്റേറ്റ് ഉണങ്ങിക്കരിഞ്ഞതുമായ വേറെ ഏഴു കതിരുകൾ മുളച്ചുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ആ നേർത്ത ഏഴു കതിരുകൾ ആരോഗ്യമുള്ളതും ധാന്യം നിറഞ്ഞതുമായ ഏഴു കതിരുകളെയും വിഴുങ്ങിക്കളഞ്ഞു. അപ്പോൾ ഫറവോൻ ഉണർന്നു, അതൊരു സ്വപ്നമായിരുന്നു എന്നു മനസ്സിലാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","പ്രഭാതത്തിൽ അദ്ദേഹത്തിന്റെ മനസ്സ് അസ്വസ്ഥമായിരുന്നു. അദ്ദേഹം ഈജിപ്റ്റിലെ സകലജ്യോതിഷികളെയും ജ്ഞാനികളെയും ആളയച്ചുവരുത്തി; ഫറവോൻ അവരോട് തന്റെ സ്വപ്നം പറഞ്ഞു; എന്നാൽ അതു വ്യാഖ്യാനിക്കാൻ ആർക്കും കഴിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","അപ്പോൾ പ്രധാന വീഞ്ഞുകാരൻ ഫറവോനോടു പറഞ്ഞു: “ഇന്ന് ഞാൻ എന്റെ തെറ്റ് ഓർക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ഒരിക്കൽ ഫറവോൻ തന്റെ ദാസന്മാരോടു കോപിച്ചു; അവിടന്ന് എന്നെയും പ്രധാന അപ്പക്കാരനെയും അംഗരക്ഷകരുടെ അധിപന്റെ വീട്ടിൽ തടവിലാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ഒരേരാത്രിയിൽ ഞങ്ങൾ ഇരുവരും വ്യത്യസ്ത അർഥമുള്ള ഓരോ സ്വപ്നംകണ്ടു; ");
INSERT INTO malc_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","അംഗരക്ഷകരുടെ അധിപന്റെ ദാസനായ ഒരു എബ്രായയുവാവ് അന്നു ഞങ്ങളോടുകൂടെ ഉണ്ടായിരുന്നു. ഞങ്ങൾ ഞങ്ങളുടെ സ്വപ്നങ്ങൾ അവനെ അറിയിച്ചു; അവൻ ഞങ്ങൾക്ക് അവ വ്യാഖ്യാനിച്ചുതന്നു; ഓരോരുത്തന്റെയും സ്വപ്നത്തിന്റെ അർഥവും പറഞ്ഞുതന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","അവൻ അവ ഞങ്ങൾക്കു വ്യാഖ്യാനിച്ചുതന്നതുപോലെതന്നെ സംഭവിച്ചു; എന്നെ പഴയ സ്ഥാനത്ത് ആക്കുകയും മറ്റവനെ തൂക്കിലേറ്റുകയും ചെയ്തു.” ");
INSERT INTO malc_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ഫറവോൻ യോസേഫിനുവേണ്ടി ആളയച്ചു; അവനെ കൽത്തുറുങ്കിൽനിന്ന് ഉടൻതന്നെ വരുത്തി. അവൻ ക്ഷൗരംചെയ്ത് വസ്ത്രം മാറിയതിനുശേഷം ഫറവോന്റെ സന്നിധിയിൽ വന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ഫറവോൻ യോസേഫിനോടു പറഞ്ഞു: “ഞാനൊരു സ്വപ്നംകണ്ടു, അതു വ്യാഖ്യാനിക്കാൻ ആർക്കും കഴിയുന്നില്ല. എന്നാൽ നിനക്ക് ഒരു സ്വപ്നം കേൾക്കുമ്പോൾത്തന്നെ അതു വ്യാഖ്യാനിക്കാൻ കഴിയുമെന്നു നിന്നെക്കുറിച്ചു ഞാൻ കേട്ടിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","“ഞാനല്ല, ദൈവമാണ് ഫറവോനു ശുഭകരമായ മറുപടി നൽകുന്നത്,” യോസേഫ് ഫറവോനോട് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","അപ്പോൾ ഫറവോൻ യോസേഫിനോടു പറഞ്ഞു: “ഞാൻ സ്വപ്നത്തിൽ നദീതീരത്തു നിൽക്കുകയായിരുന്നു; ");
INSERT INTO malc_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","അപ്പോൾ പുഷ്ടിയും ഭംഗിയും ഉള്ള ഏഴു പശുക്കൾ നദിയിൽനിന്ന് കയറിവന്ന്, ഞാങ്ങണകൾക്കിടയിൽ മേഞ്ഞുകൊണ്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","അവയ്ക്കു പിന്നാലെ തീരെ മെലിഞ്ഞ് വിരൂപമായ വേറെ ഏഴു പശുക്കൾ കയറിവന്നു. ഇത്രയും വിരൂപമായ പശുക്കളെ ഞാൻ ഈജിപ്റ്റുദേശത്തെങ്ങും ഇതിനുമുമ്പ് ഒരിക്കലും കണ്ടിട്ടില്ല. ");
INSERT INTO malc_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","മെലിഞ്ഞു വിരൂപമായ ആ പശുക്കൾ, ആദ്യം കയറിവന്ന പുഷ്ടിയുള്ള ഏഴു പശുക്കളെയും തിന്നുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","അവ അവയുടെ വയറ്റിൽ ചെന്നു; എന്നിട്ടും അവ അവയുടെ വയറ്റിൽ ചെന്നതിന്റെ ഒരു ലക്ഷണവും ഉണ്ടായിരുന്നില്ല. മുമ്പിലത്തെപ്പോലെതന്നെ അവ വിരൂപമായിരുന്നു. അപ്പോൾ ഞാൻ ഉണർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“പിന്നെയും എന്റെ സ്വപ്നത്തിൽ ഞാൻ ധാന്യം നിറഞ്ഞതും നല്ലതുമായ ഏഴു കതിരുകൾ ഒരേ തണ്ടിൽനിന്ന് പൊങ്ങിവന്നതായി കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","അവയ്ക്കു പിന്നാലെ കൊഴിഞ്ഞതും നേർത്തതും കിഴക്കൻകാറ്റടിച്ചു വരണ്ടുപോയതുമായ വേറെ ഏഴു കതിരുകൾ ഉയർന്നുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ആ നേർത്ത ധാന്യക്കതിരുകൾ നല്ല ഏഴു കതിരുകളെയും വിഴുങ്ങിക്കളഞ്ഞു. ഞാൻ ഇതു ജ്യോതിഷപുരോഹിതന്മാരോടു പറഞ്ഞു, എങ്കിലും എനിക്ക് അതു വിശദീകരിച്ചുതരാൻ ആർക്കും കഴിഞ്ഞില്ല.” ");
INSERT INTO malc_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ഇതു കേട്ടതിനുശേഷം യോസേഫ് ഫറവോനോട്: “ഫറവോന്റെ സ്വപ്നങ്ങൾ ഒന്നുതന്നെയാണ്. അവിടന്ന് എന്താണു ചെയ്യാൻ പോകുന്നതെന്നു ദൈവം ഫറവോനു വെളിപ്പെടുത്തിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ഏഴു നല്ല പശുക്കൾ ഏഴുവർഷങ്ങളാണ്; ഏഴു നല്ല ധാന്യക്കതിരുകളും ഏഴുവർഷങ്ങൾ; സ്വപ്നം ഒന്നുതന്നെ. ");
INSERT INTO malc_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","പിന്നാലെ കയറിവന്ന മെലിഞ്ഞു വിരൂപമായ ഏഴു പശുക്കൾ ഏഴുവർഷങ്ങളത്രേ; കിഴക്കൻകാറ്റടിച്ച് ഉണങ്ങിപ്പോയ, കൊള്ളരുതാത്ത ഏഴു ധാന്യക്കതിരുകളും ഏഴുവർഷങ്ങൾതന്നെ. അവ ക്ഷാമത്തിന്റെ ഏഴുവർഷങ്ങളാണ്. ");
INSERT INTO malc_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“വസ്തുത ഞാൻ ഫറവോനോടു പറഞ്ഞതുപോലെതന്നെ: ദൈവം താൻ ചെയ്യാൻപോകുന്നത് ഫറവോനു കാണിച്ചുതന്നിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ഈജിപ്റ്റുദേശത്തെങ്ങും മഹാസമൃദ്ധിയുടെ ഏഴുവർഷം വരാൻപോകുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","എന്നാൽ അവയ്ക്കുശേഷം ക്ഷാമത്തിന്റെ ഏഴുവർഷവും ഉണ്ടാകും. അപ്പോൾ, ഈജിപ്റ്റിൽ ഉണ്ടായിരുന്ന സമൃദ്ധി പാടേ വിസ്മരിക്കപ്പെടും; ക്ഷാമം ദേശത്തെ ക്ഷയിപ്പിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","സമൃദ്ധിയെ തുടർന്നുണ്ടാകുന്ന ക്ഷാമം അതിരൂക്ഷമായിരിക്കയാലാണ് ദേശത്തെ സമൃദ്ധി ഓർമിക്കപ്പെടാതെ പോകുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","സ്വപ്നം രണ്ടുരീതിയിൽ ഫറവോന് ഉണ്ടായതോ; ഇക്കാര്യം ദൈവത്തിൽനിന്നാകുകയാൽ ഉറപ്പാക്കപ്പെട്ടിരിക്കുന്നെന്നും ദൈവം അത് ഉടൻതന്നെ ചെയ്യാൻപോകുന്നു എന്നും കാണിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ഫറവോൻ ഇപ്പോൾ വിവേചനശക്തിയും ജ്ഞാനവും ഉള്ള ഒരുവനെ കണ്ടുപിടിച്ച് ഈജിപ്റ്റുദേശത്തിന്റെ ചുമതല ഏൽപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","സമൃദ്ധിയുടെ ഏഴുവർഷത്തിൽ ഈജിപ്റ്റിലുണ്ടാകുന്ന വിളവിന്റെ അഞ്ചിലൊന്ന് ശേഖരിക്കാൻ ഫറവോൻ അധികാരികളെ നിയോഗിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","അവർ, വരാൻപോകുന്ന നല്ല വർഷങ്ങളിലെ ഭക്ഷ്യവസ്തുക്കൾ മുഴുവൻ ശേഖരിക്കുകയും ഫറവോന്റെ ആധിപത്യത്തിൽ, ആഹാരത്തിനായി, നഗരങ്ങളിൽ സൂക്ഷിച്ചുവെക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ഈജിപ്റ്റിന്മേൽ വരാൻപോകുന്ന ക്ഷാമത്തിന്റെ ഏഴുവർഷക്കാലം ഉപയോഗിക്കേണ്ടതിന് ഇതു ദേശത്തിനുള്ള കരുതൽധാന്യമായിരിക്കേണ്ടതാണ്; അങ്ങനെയെങ്കിൽ ക്ഷാമംകൊണ്ടു ദേശം നശിച്ചുപോകാതിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ഈ നിർദേശം നല്ലതെന്ന് ഫറവോനും അദ്ദേഹത്തിന്റെ സകല ഉദ്യോഗസ്ഥന്മാർക്കും തോന്നി. ");
INSERT INTO malc_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","അതുകൊണ്ടു ഫറവോൻ അവരോട്, “ദൈവാത്മാവുള്ള ഈ മനുഷ്യനെപ്പോലെ ഒരുവനെ നമുക്കു കണ്ടെത്താൻ കഴിയുമോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","പിന്നെ ഫറവോൻ യോസേഫിനോടു പറഞ്ഞു: “ദൈവം ഇതെല്ലാം നിന്നെ അറിയിച്ചിരിക്കുന്നതുകൊണ്ട് നിന്നെപ്പോലെ വിവേചനവും ജ്ഞാനവും ഉള്ള മറ്റാരുമില്ല. ");
INSERT INTO malc_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","എന്റെ കൊട്ടാരത്തിന്റെ ചുമതല നിനക്കായിരിക്കും; എന്റെ സകലപ്രജകളും നിന്റെ ആജ്ഞകൾക്കു വിധേയരായിരിക്കും. സിംഹാസനത്തിന്റെ കാര്യത്തിൽമാത്രം ഞാൻ നിന്നെക്കാൾ ശ്രേഷ്ഠനായിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ഫറവോൻ യോസേഫിനോട്, “ഞാൻ ഇതിനാൽ നിന്നെ ഈജിപ്റ്റുദേശത്തിന്റെ മുഴുവൻ അധികാരിയായി നിയമിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","പിന്നെ ഫറവോൻ തന്റെ മുദ്രമോതിരം കൈയിൽനിന്നും ഊരി യോസേഫിന്റെ കൈയിൽ ഇട്ടു. അദ്ദേഹം യോസേഫിനെ നേർമയേറിയ നിലയങ്കി ധരിപ്പിക്കുകയും അവന്റെ കഴുത്തിൽ സ്വർണമാല അണിയിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","അതിനുശേഷം യോസേഫിനെ തന്റെ അടുത്ത അധികാരി കയറുന്ന രഥത്തിൽ കയറ്റി; “മുട്ടുകുത്തുവിൻ” എന്ന് അവന്റെ മുന്നിൽ വിളിച്ചുപറയിച്ചു. അങ്ങനെ ഫറവോൻ അദ്ദേഹത്തെ ഈജിപ്റ്റുദേശത്തിന്റെ മുഴുവനും അധികാരിയാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ഇതിനുശേഷം ഫറവോൻ യോസേഫിനോട്, “ഞാൻ ഫറവോൻ ആകുന്നു; എന്നാൽ നിന്റെ അനുവാദം കൂടാതെ ഈജിപ്റ്റിൽ എങ്ങും ആരും കൈയോ കാലോ അനക്കുകയില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ഫറവോൻ യോസേഫിനു സാപ്നത്-പനേഹ് എന്നു പേരിട്ടു; ഓനിലെ പുരോഹിതനായ പോത്തിഫേറയുടെ പുത്രിയായ ആസ്നത്തിനെ അദ്ദേഹത്തിനു ഭാര്യയായി കൊടുക്കുകയും ചെയ്തു. യോസേഫ് ഈജിപ്റ്റുദേശത്തുടനീളം സഞ്ചരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ഈജിപ്റ്റിലെ രാജാവായ ഫറവോന്റെ മുന്നിൽ യോസേഫ് നിൽക്കുമ്പോൾ യോസേഫിന് മുപ്പതുവയസ്സായിരുന്നു. യോസേഫ് ഫറവോന്റെ സന്നിധിയിൽനിന്ന് പുറപ്പെട്ടുപോയി ദേശത്തെങ്ങും സഞ്ചരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","സമൃദ്ധിയുടെ ഏഴുവർഷങ്ങളിൽ ദേശം അത്യധികം വിളവുനൽകി. ");
INSERT INTO malc_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ഈജിപ്റ്റിൽ, സമൃദ്ധിയുടെ ആ ഏഴുവർഷങ്ങളിൽ വിളഞ്ഞ ധാന്യം മുഴുവൻ യോസേഫ് ശേഖരിച്ച് നഗരങ്ങളിൽ സൂക്ഷിച്ചു. ഓരോ നഗരത്തിന്റെയും ചുറ്റുപാടുമുള്ള വയലുകളിൽ വിളഞ്ഞ ധാന്യം അദ്ദേഹം അതതു നഗരത്തിൽ സൂക്ഷിച്ചുവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","കടൽക്കരയിലെ മണൽപോലെ വളരെയധികം ധാന്യം യോസേഫ് ശേഖരിച്ചു. അളന്നു തിട്ടപ്പെടുത്താൻ അസാധ്യമായതുകൊണ്ട് അളക്കുന്നതു നിർത്തിക്കളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ക്ഷാമകാലം വരുന്നതിനുമുമ്പ് യോസേഫിന് ഓനിലെ പുരോഹിതനായ പോത്തിഫേറയുടെ മകൾ ആസ്നത്തിൽ രണ്ടു പുത്രന്മാർ ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","“എന്റെ സകലകഷ്ടതയെയും എന്റെ പിതൃഭവനത്തെയും മറക്കാൻ ദൈവം എനിക്ക് ഇടയാക്കി,” എന്നു പറഞ്ഞുകൊണ്ട് യോസേഫ് തന്റെ ആദ്യജാതനു മനശ്ശെ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","“എന്റെ യാതനയുടെ ദേശത്ത് ദൈവം എനിക്കു ഫലസമൃദ്ധി നൽകി,” എന്നു പറഞ്ഞ് അദ്ദേഹം രണ്ടാമത്തെ മകന് എഫ്രയീം എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ഈജിപ്റ്റിലെ സമൃദ്ധിയുടെ ഏഴുവർഷങ്ങൾ അവസാനിച്ചു; ");
INSERT INTO malc_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","യോസേഫ് പറഞ്ഞിരുന്നതുപോലെ ക്ഷാമത്തിന്റെ ഏഴുവർഷങ്ങൾ ആരംഭിച്ചു. എല്ലാ ദേശങ്ങളിലും ക്ഷാമമുണ്ടായി; എന്നാൽ ഈജിപ്റ്റിലെല്ലായിടത്തും ആഹാരം ലഭ്യമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ഈജിപ്റ്റിലും ക്ഷാമം അനുഭവപ്പെട്ടുതുടങ്ങിയപ്പോൾ ജനങ്ങൾ ആഹാരത്തിനുവേണ്ടി ഫറവോനോടു നിലവിളിച്ചു. അപ്പോൾ ഫറവോൻ എല്ലാ ഈജിപ്റ്റുകാരോടും, “നിങ്ങൾ യോസേഫിന്റെ അടുക്കൽ ചെന്ന് അവൻ നിങ്ങളോടു പറയുന്നതുപോലെ ചെയ്യുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ക്ഷാമം ദേശത്തെല്ലായിടത്തും വ്യാപിച്ചുകഴിഞ്ഞപ്പോൾ യോസേഫ് സംഭരണശാലകൾ തുറന്ന് ഈജിപ്റ്റുകാർക്കു ധാന്യം വിറ്റു; ഈജിപ്റ്റിൽ ക്ഷാമം രൂക്ഷമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","യോസേഫിനോടു ധാന്യം വാങ്ങാൻ എല്ലാ ദേശക്കാരും ഈജിപ്റ്റിലെത്തി; കാരണം എല്ലായിടത്തും ക്ഷാമം അതികഠിനമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ഈജിപ്റ്റിൽ ധാന്യമുണ്ടെന്നറിഞ്ഞ യാക്കോബ് തന്റെ പുത്രന്മാരോട്: “നിങ്ങൾ ഇങ്ങനെ പരസ്പരം നോക്കിനിൽക്കുന്നതെന്ത്? ");
INSERT INTO malc_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ഈജിപ്റ്റിൽ ധാന്യമുണ്ട് എന്നു ഞാൻ കേട്ടിരിക്കുന്നു. നാം മരിക്കാതെ ജീവിച്ചിരിക്കേണ്ടതിന് നിങ്ങൾ അവിടെച്ചെന്ന് നമുക്ക് ധാന്യം വാങ്ങുക” എന്നു നിർദേശിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ഈ നിർദേശത്തിനുശേഷം യോസേഫിന്റെ സഹോദരന്മാരിൽ പത്തുപേർ ഈജിപ്റ്റിൽനിന്ന് ധാന്യം വാങ്ങാൻ പോയി. ");
INSERT INTO malc_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","എന്നാൽ യാക്കോബ്, യോസേഫിന്റെ സഹോദരനായ ബെന്യാമീനെ അവരുടെകൂടെ അയച്ചില്ല; അവന് വല്ല ആപത്തും സംഭവിച്ചേക്കുമെന്ന് അദ്ദേഹം ഭയപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","കനാൻദേശത്തും ക്ഷാമം ഉണ്ടായതുകൊണ്ട്, ധാന്യം വാങ്ങാൻ പോയ മറ്റുള്ളവരുടെ കൂട്ടത്തിൽ ഇസ്രായേലിന്റെ പുത്രന്മാരും ഈജിപ്റ്റിൽ എത്തിച്ചേർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","യോസേഫ് ദേശത്തുള്ള ജനങ്ങൾക്കെല്ലാവർക്കും ധാന്യം വിൽക്കുന്ന ദേശാധിപതി ആയിരുന്നു. അതുകൊണ്ട്, യോസേഫിന്റെ സഹോദരന്മാർ വന്നപ്പോൾ അവർ അദ്ദേഹത്തെ സാഷ്ടാംഗം നമസ്കരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","സഹോദരന്മാരെ കണ്ടമാത്രയിൽ യോസേഫ് അവരെ തിരിച്ചറിഞ്ഞു; എന്നാൽ ഒരു അപരിചിതനായി നടിച്ച് അവരോടു പരുഷമായി സംസാരിച്ചു: “നിങ്ങൾ എവിടെനിന്നു വരുന്നു?” അദ്ദേഹം ചോദിച്ചു. “ഭക്ഷ്യധാന്യം വാങ്ങാൻ കനാൻദേശത്തുനിന്ന് വരുന്നു,” അവർ മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","യോസേഫ് സഹോദരന്മാരെ തിരിച്ചറിഞ്ഞെങ്കിലും അവർ അദ്ദേഹത്തെ തിരിച്ചറിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","അപ്പോൾ യോസേഫ് അവരെക്കുറിച്ചുള്ള തന്റെ സ്വപ്നങ്ങൾ ഓർമിച്ചു; അദ്ദേഹം അവരോട്, “നിങ്ങൾ ചാരന്മാർ! ഞങ്ങളുടെ ദേശത്തിന്റെ ദുർബലഭാഗം ഏതെന്നു നോക്കാനല്ലേ നിങ്ങൾ വന്നിരിക്കുന്നത്?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“അല്ല, യജമാനനേ, അങ്ങയുടെ ദാസന്മാർ ആഹാരം വാങ്ങുന്നതിനാണു വന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ഞങ്ങളെല്ലാവരും ഒരാളിന്റെ പുത്രന്മാരാണ്; അടിയങ്ങൾ സത്യസന്ധരാണ്, ചാരന്മാരല്ല” അവർ ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“അല്ലല്ല, ദേശത്തിന്റെ ദുർബലഭാഗം കണ്ടുപിടിക്കാൻതന്നെയാണ് നിങ്ങൾ വന്നിരിക്കുന്നത്,” യോസേഫ് പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","അതിന് അവർ, “അങ്ങയുടെ ഈ അടിയങ്ങൾ പന്ത്രണ്ടു സഹോദരന്മാർ ആയിരുന്നു; ഒരാളിന്റെ പുത്രന്മാർ. അദ്ദേഹം കനാൻദേശത്തു താമസിക്കുന്നു. ഏറ്റവും ഇളയവൻ ഇപ്പോൾ ഞങ്ങളുടെ പിതാവിന്റെകൂടെയുണ്ട്; ഒരാൾ മരിച്ചുപോയി” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","യോസേഫ് അവരോട്, “ഞാൻ നിങ്ങളോടു പറഞ്ഞതുപോലെ, നിങ്ങൾ ചാരന്മാർതന്നെ. ");
INSERT INTO malc_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","നിങ്ങളെ പരീക്ഷിക്കുന്നത് ഇങ്ങനെയാണ്: ‘നിങ്ങളുടെ ഏറ്റവും ഇളയ സഹോദരൻ ഇവിടെ വന്നിട്ടല്ലാതെ ഫറവോനാണെ, നിങ്ങൾ ഈ സ്ഥലത്തുനിന്നു പോകുകയില്ല.’ ");
INSERT INTO malc_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","നിങ്ങളുടെ സഹോദരനെ കൊണ്ടുവരാൻ നിങ്ങളുടെ കൂട്ടത്തിൽനിന്ന് ഒരാളെ അയയ്ക്കുക; ശേഷമുള്ളവരെ കാരാഗൃഹത്തിൽ സൂക്ഷിക്കുന്നതായിരിക്കും. നിങ്ങൾ സത്യം പറയുകയാണോ എന്ന് ഇങ്ങനെ നിങ്ങളുടെ വാക്കുകളാൽത്തന്നെ പരീക്ഷിച്ചറിയും; അല്ലെന്നുവരികിൽ, ഫറവോനാണെ, നിങ്ങൾ ചാരന്മാർതന്നെ.” ");
INSERT INTO malc_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","അദ്ദേഹം അവരെ എല്ലാവരെയും മൂന്നുദിവസത്തേക്കു തടവിലാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","മൂന്നാംദിവസം യോസേഫ് അവരോട്, “ഇതു ചെയ്യുക, എന്നാൽ നിങ്ങൾ ജീവിച്ചിരിക്കും; ഞാൻ ദൈവത്തെ ഭയപ്പെടുന്നു: ");
INSERT INTO malc_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","നിങ്ങൾ സത്യസന്ധരെങ്കിൽ നിങ്ങളിൽ ഒരു സഹോദരൻ ഇവിടെ കാരാഗൃഹത്തിൽ കഴിയട്ടെ; പട്ടിണികിടക്കുന്നവർക്കു ധാന്യവുമായി ശേഷമുള്ളവർക്കു മടങ്ങിപ്പോകാം. ");
INSERT INTO malc_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","എന്നാൽ നിങ്ങളുടെ വാക്കുകൾ സത്യമോ എന്ന് ഉറപ്പുവരുത്തേണ്ടതിനും നിങ്ങൾ മരിക്കാതിരിക്കേണ്ടതിനും നിങ്ങളുടെ ഇളയ സഹോദരനെ എന്റെ അടുക്കൽ കൊണ്ടുവന്നേ മതിയാകൂ.” അങ്ങനെതന്നെ ചെയ്യാൻ അവർ തീരുമാനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","പിന്നെ അവർ പരസ്പരം പറഞ്ഞു, “നാം നിശ്ചയമായും നമ്മുടെ സഹോദരൻനിമിത്തം ശിക്ഷിക്കപ്പെടുകയാണ്. തന്റെ പ്രാണനുവേണ്ടി നമ്മോടു കെഞ്ചിയപ്പോൾ അവൻ എത്രമാത്രം സങ്കടപ്പെട്ടിരുന്നെന്നു നാം കണ്ടതാണ്. എങ്കിലും നാം അവന്റെ അപേക്ഷ കേട്ടില്ല: നാം ഈ പ്രാണസങ്കടത്തിൽ ആകാൻ കാരണം അതുതന്നെ.” ");
INSERT INTO malc_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","അതിനു രൂബേൻ, “ബാലനു വിരോധമായി പാപം പ്രവർത്തിക്കരുതെന്നു ഞാൻ നിങ്ങളോടു പറഞ്ഞില്ലയോ? എന്നാൽ നിങ്ങൾ അതു കേട്ടില്ല. ഇപ്പോൾ നാം അവന്റെ രക്തത്തിനു കണക്കു ബോധിപ്പിച്ചേതീരൂ” എന്നു മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","യോസേഫ് ഒരു ദ്വിഭാഷിയെ നിയോഗിച്ചിരുന്നതുകൊണ്ട് തങ്ങൾ പറയുന്നത് അദ്ദേഹം മനസ്സിലാക്കുമെന്ന് അവർ തിരിച്ചറിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","യോസേഫ് അവരെവിട്ടു മാറിപ്പോയി കരഞ്ഞു. വീണ്ടും അവരുടെ അടുക്കൽ മടങ്ങിവന്ന് അവരോടു സംസാരിച്ചു. പിന്നെ അദ്ദേഹം ശിമെയോനെ അവരുടെ കൂട്ടത്തിൽനിന്ന് മാറ്റി അവരുടെ കൺമുമ്പിൽവെച്ചു ബന്ധിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","അവരുടെ ചാക്കുകളിൽ ധാന്യം നിറയ്ക്കാനും ഓരോരുത്തന്റെയും വെള്ളി അവനവന്റെ ചാക്കിൽത്തന്നെ തിരികെ നിക്ഷേപിക്കാനും അവരുടെ വഴിയാത്രയ്ക്കുള്ള വക കൊടുക്കാനും യോസേഫ് ആജ്ഞാപിച്ചു. അദ്ദേഹത്തിന്റെ ഉത്തരവുകൾ നിറവേറ്റപ്പെടുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","അതിനുശേഷം അവർ തങ്ങളുടെ കഴുതകളുടെ പുറത്ത് ധാന്യം കയറ്റി പുറപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","രാത്രി വിശ്രമത്തിനായി അവർ ഒരു വഴിയമ്പലത്തിലെത്തി. കഴുതയ്ക്കു തീറ്റികൊടുക്കാൻ അവരിൽ ഒരാൾ ചാക്കു തുറന്നു, തന്റെ വെള്ളി ചാക്കിന്റെ വായ്ക്കൽ ഇരിക്കുന്നതു കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","അവൻ സഹോദരന്മാരോട്, “എന്റെ വെള്ളി തിരികെത്തന്നിരിക്കുന്നു; ഇതാ, അതെന്റെ ചാക്കിൽത്തന്നെ ഇരിക്കുന്നു” എന്നു പറഞ്ഞു. അവരുടെ മനസ്സ് നിരാശപ്പെട്ടു. അവർ പേടിച്ചുവിറച്ചു പരസ്പരം നോക്കിക്കൊണ്ട്, “ദൈവം നമ്മോട് ഈ ചെയ്തിരിക്കുന്നതെന്ത്?” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","അവർ കനാൻദേശത്തു തങ്ങളുടെ പിതാവായ യാക്കോബിന്റെ അടുക്കൽ എത്തി തങ്ങൾക്കു സംഭവിച്ചതെല്ലാം അദ്ദേഹത്തോട് അറിയിച്ചു. അവർ ഇങ്ങനെ പറഞ്ഞു: ");
INSERT INTO malc_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ആ ദേശത്തിന്റെ അധികാരിയായ മനുഷ്യൻ ഞങ്ങളോടു വളരെ പരുഷമായി സംസാരിക്കുകയും ഞങ്ങൾ ആ ദേശത്തെ പര്യവേക്ഷണംചെയ്യാൻ ചെന്നവരെന്നഭാവേന ഞങ്ങളോടു പെരുമാറുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ഞങ്ങൾ അദ്ദേഹത്തോട്: ‘ഞങ്ങൾ സത്യസന്ധരാണ്, ചാരന്മാരല്ല. ");
INSERT INTO malc_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ഞങ്ങൾ ഒരേ പിതാവിന്റെ പുത്രന്മാരായി പന്ത്രണ്ടു സഹോദരന്മാരുണ്ടായിരുന്നു; ഒരാൾ മരിച്ചുപോയി, ഏറ്റവും ഇളയവൻ കനാനിൽ ഞങ്ങളുടെ പിതാവിന്റെകൂടെയുണ്ട്’ എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“അപ്പോൾ ദേശത്തിന്റെ അധികാരിയായ ആ മനുഷ്യൻ ഞങ്ങളോടു പറഞ്ഞു: ‘നിങ്ങൾ സത്യസന്ധരോ എന്നു ഞാൻ ഇതിനാൽ അറിയും. നിങ്ങളുടെ സഹോദരന്മാരിൽ ഒരുവനെ ഇവിടെ എന്റെ അടുക്കൽ വിട്ടിട്ട്; നിങ്ങളുടെ കുടുംബത്തിൽ പട്ടിണികിടക്കുന്നവർക്കായി ധാന്യം കൊണ്ടുപോകുക. ");
INSERT INTO malc_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","എന്നാൽ, നിങ്ങൾ ചാരന്മാരല്ല, സത്യസന്ധരാണ് എന്നു ഞാൻ മനസ്സിലാക്കേണ്ടതിന് നിങ്ങളുടെ ഏറ്റവും ഇളയ സഹോദരനെ എന്റെ അടുക്കൽ കൊണ്ടുവരണം. അപ്പോൾ ഞാൻ നിങ്ങളുടെ സഹോദരനെ നിങ്ങൾക്കു തിരികെത്തരും, അങ്ങനെ നിങ്ങൾക്കു ദേശത്തു വ്യാപാരം നടത്തുകയും ചെയ്യാം.’ ” ");
INSERT INTO malc_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","പിന്നെ അവർ തങ്ങളുടെ ചാക്കുകൾ ഒഴിച്ചപ്പോൾ ഓരോരുത്തന്റെയും പണസഞ്ചി അവനവന്റെ ചാക്കിൽ ഉള്ളതായി കണ്ടു. അവരും അവരുടെ പിതാവും പണസഞ്ചി കണ്ടു ഭയപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","അവരുടെ പിതാവായ യാക്കോബ് അവരോട്, “നിങ്ങൾ എന്നെ മക്കളില്ലാത്തവനാക്കുകയാണ്. യോസേഫ് ഇല്ലാതെയായി, ശിമെയോനും ഇല്ല; ഇപ്പോൾ ഇതാ ബെന്യാമീനെയും കൊണ്ടുപോകണമെന്ന് നിങ്ങൾ ആവശ്യപ്പെടുന്നു. എല്ലാം എനിക്ക് പ്രതികൂലമാകുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","അപ്പോൾ രൂബേൻ പിതാവിനോട്, “ഞാൻ അവനെ അങ്ങയുടെ അടുക്കൽ തിരികെ കൊണ്ടുവരുന്നില്ലെങ്കിൽ അങ്ങ് എന്റെ പുത്രന്മാരെ ഇരുവരെയും കൊന്നുകൊള്ളുക. അവനെ എന്റെ ചുമതലയിൽ ഏൽപ്പിച്ചുതരിക; ഞാൻ അവനെ തിരികെ കൊണ്ടുവന്നുകൊള്ളാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","എന്നാൽ യാക്കോബ്, “എന്റെ മകൻ നിങ്ങളുടെകൂടെ അവിടേക്ക് പോരുകയില്ല. അവന്റെ സഹോദരൻ മരിച്ചു, ഇനി ശേഷിക്കുന്നത് അവൻമാത്രം. നിങ്ങളുടെ വഴിയാത്രയിൽ അവന് എന്തെങ്കിലും ഹാനി ഭവിച്ചാൽ നിങ്ങൾ എന്റെ നരച്ചതലയെ ദുഃഖത്തോടെ പാതാളത്തിൽ ഇറക്കും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ദേശത്തു ക്ഷാമം കഠിനമായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന ധാന്യം മുഴുവൻ ഭക്ഷിച്ചുതീർന്നപ്പോൾ അവരുടെ അപ്പൻ അവരോട്, “നിങ്ങൾ മടങ്ങിച്ചെന്ന് നമുക്കുവേണ്ടി കുറെ ധാന്യംകൂടി വാങ്ങിക്കൊണ്ടുവരിക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","എന്നാൽ യെഹൂദാ അദ്ദേഹത്തോട് ഇങ്ങനെ പറഞ്ഞു: “ ‘നിങ്ങളുടെ സഹോദരൻ നിങ്ങളോടുകൂടെ ഇല്ലെങ്കിൽ നിങ്ങൾ എന്റെ മുഖം ഇനി കാണുകയില്ല’ എന്ന് ആ മനുഷ്യൻ ഞങ്ങളോടു ഗൗരവമായി താക്കീതു ചെയ്തിട്ടുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","അങ്ങ് ഞങ്ങളുടെ സഹോദരനെ ഞങ്ങളോടുകൂടെ അയയ്ക്കുമെങ്കിൽ ഞങ്ങൾ ചെന്ന് അങ്ങേക്കുവേണ്ടി ധാന്യം വാങ്ങാം. ");
INSERT INTO malc_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","എന്നാൽ അങ്ങ് അവനെ അയയ്ക്കുന്നില്ലെങ്കിൽ ഞങ്ങൾ പോകുകയില്ല; ‘നിങ്ങളുടെ സഹോദരൻ നിങ്ങളുടെ കൂടെയില്ലെങ്കിൽ നിങ്ങൾ ഇനി എന്റെ മുഖം കാണുകയില്ല’ എന്ന് അദ്ദേഹം ഞങ്ങളോടു പറഞ്ഞിട്ടുണ്ട്.” ");
INSERT INTO malc_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","“ഞങ്ങൾക്കു മറ്റൊരു സഹോദരൻ ഉണ്ട് എന്ന് ആ മനുഷ്യനോടു പറഞ്ഞ് നിങ്ങൾ എനിക്ക് ഈ പ്രയാസം വരുത്തിവെച്ചതെന്തിന്?” ഇസ്രായേൽ ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","അതിന് അവർ ഉത്തരം പറഞ്ഞത്, “ആ മനുഷ്യൻ ഞങ്ങളോടു നമ്മെക്കുറിച്ചും നമ്മുടെ കുടുംബത്തെക്കുറിച്ചും വളരെ സൂക്ഷ്മമായി ചോദിച്ചു. ‘നിങ്ങളുടെ പിതാവു ജീവിച്ചിരിക്കുന്നോ? നിങ്ങൾക്കു മറ്റൊരു സഹോദരൻ ഉണ്ടോ?’ എന്നും അദ്ദേഹം ഞങ്ങളോടു ചോദിച്ചു. ഞങ്ങൾ അദ്ദേഹത്തിന്റെ ചോദ്യങ്ങൾക്കുള്ള മറുപടി പറയുകമാത്രമേ ചെയ്തിട്ടുള്ളൂ. ‘നിങ്ങളുടെ സഹോദരനെ ഇവിടെ കൊണ്ടുവരിക’ എന്ന് അദ്ദേഹം പറയുമെന്നു ഞങ്ങൾ എങ്ങനെയാണ് അറിയുക?” ");
INSERT INTO malc_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","അപ്പോൾ യെഹൂദാ തന്റെ പിതാവായ ഇസ്രായേലിനോടു പറഞ്ഞു: “ഞങ്ങളും അങ്ങും ഞങ്ങളുടെ കുഞ്ഞുങ്ങളും മരിച്ചുപോകാതെ, ജീവിച്ചിരിക്കേണ്ടതിന് ബാലനെ എന്റെകൂടെ അയയ്ക്കുക, ഞങ്ങൾ ഉടനെതന്നെ പോകാം. ");
INSERT INTO malc_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","അവന്റെ സുരക്ഷിതത്വത്തിനു ഞാൻതന്നെ ഉറപ്പുതരുന്നു; അവനുവേണ്ടി ഞാൻ അങ്ങയോട് ഉത്തരവാദി ആയിരിക്കും. അവനെ ഞാൻ തിരികെക്കൊണ്ടുവന്ന് ഇവിടെ അങ്ങയുടെ സന്നിധിയിൽ നിർത്താത്തപക്ഷം ഞാൻ എന്റെ ആയുഷ്കാലം മുഴുവൻ അങ്ങയുടെമുമ്പാകെ അതിന്റെ ദോഷം വഹിച്ചുകൊള്ളാം. ");
INSERT INTO malc_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","നാം ഇത്രയും കാലതാമസം വരുത്താതിരുന്നെങ്കിൽ ഞങ്ങൾക്ക് ഇതിനോടകം രണ്ടുതവണ പോയിവരാൻ കഴിയുമായിരുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","അപ്പോൾ അവരുടെ പിതാവായ ഇസ്രായേൽ അവരോടു പറഞ്ഞു, “അങ്ങനെ നിർബന്ധമെങ്കിൽ ഇതു ചെയ്യുക—കുറെ സുഗന്ധപ്പശ, അൽപ്പം തേൻ, സുഗന്ധവസ്തുക്കൾ, മീറ, പിസ്താപ്പരിപ്പ്, ബദാം എന്നിങ്ങനെ—ഈ നാട്ടിലെ ഏറ്റവും നല്ല വസ്തുക്കളിൽ ചിലത് ആ മനുഷ്യനുള്ള സമ്മാനമായി നിങ്ങളുടെ സഞ്ചികളിൽ കരുതിവെക്കുക. ");
INSERT INTO malc_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","നിങ്ങളുടെ ചാക്കുകളിൽ വെച്ചിരുന്ന പണം തിരികെ കൊടുക്കേണ്ടതായതിനാൽ ഇരട്ടിത്തുകയും എടുക്കണം; ഒരുപക്ഷേ അതൊരു തെറ്റുപറ്റിയതാകാം. ");
INSERT INTO malc_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","നിങ്ങളുടെ സഹോദരനെയും കൂട്ടിക്കൊണ്ട് അദ്ദേഹത്തിന്റെ അടുത്തേക്ക് ഉടൻതന്നെ പോകുക. ");
INSERT INTO malc_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","നിങ്ങളുടെ മറ്റേ സഹോദരനെയും ബെന്യാമീനെയും നിങ്ങളോടൊപ്പം തിരികെപ്പോരാൻ അദ്ദേഹം അനുവദിക്കുംവിധം സർവശക്തനായ ദൈവം അദ്ദേഹത്തിന്റെ മുമ്പാകെ നിങ്ങളോടു കരുണ കാണിക്കുമാറാകട്ടെ. എനിക്കോ, എന്റെ മക്കൾ നഷ്ടപ്പെടുകയാണെങ്കിൽ അതും ആകട്ടെ!” ");
INSERT INTO malc_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","അങ്ങനെ അവർ സമ്മാനങ്ങളും ഇരട്ടിപ്പണവും എടുത്തു, ബെന്യാമീനെയും കൂട്ടിക്കൊണ്ട് ഈജിപ്റ്റിലേക്കു തിടുക്കത്തിൽ ചെന്ന്, യോസേഫിന്റെ മുമ്പിൽനിന്നു. ");
INSERT INTO malc_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","അവരോടുകൂടെ ബെന്യാമീൻ ഉണ്ട് എന്നു കണ്ടിട്ട് യോസേഫ് തന്റെ വീട്ടിലെ കാര്യസ്ഥനോട്, “ഈ മനുഷ്യരെ എന്റെ വീട്ടിലേക്കു കൂട്ടിക്കൊണ്ടുപോകുകയും ഒരു മൃഗത്തെ കൊന്ന് വിരുന്നൊരുക്കുകയും വേണം; അവർ ഇന്നത്തെ ഉച്ചഭക്ഷണം എന്നോടുകൂടെ കഴിക്കേണ്ടതാകുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","യോസേഫ് പറഞ്ഞതുപോലെ ആ മനുഷ്യൻ ചെയ്തു, അവരെ യോസേഫിന്റെ വീട്ടിലേക്കു കൂട്ടിക്കൊണ്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","അവരെ അദ്ദേഹത്തിന്റെ വീട്ടിലേക്കു കൊണ്ടുപോയപ്പോൾ, “നമ്മുടെ ചാക്കുകളിൽ, ഒന്നാമത്തെ പ്രാവശ്യം വെച്ചിരുന്ന പണംനിമിത്തം നമ്മെ ഇവിടെ കൊണ്ടുവന്നിരിക്കുന്നു. നമ്മെ കീഴ്പ്പെടുത്തി അടിമകളാക്കി പിടിച്ചുവെക്കാനും നമ്മുടെ കഴുതകളെ കൈവശമാക്കാനും അദ്ദേഹം ആഗ്രഹിക്കുന്നു,” എന്ന് ചിന്തിച്ച് അവർ ഭയപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","അതുകൊണ്ട്, അവർ യോസേഫിന്റെ കാര്യസ്ഥന്റെ അടുക്കൽച്ചെന്ന് വീട്ടുവാതിൽക്കൽവെച്ച് അദ്ദേഹത്തോടു സംസാരിച്ചു: ");
INSERT INTO malc_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“യജമാനനേ, ഞങ്ങൾ ഇവിടെ ഒന്നാമത്തെ തവണ വന്നത് ഭക്ഷ്യസാധനം വാങ്ങുന്നതിനാണ്. ");
INSERT INTO malc_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","എന്നാൽ ഞങ്ങൾ രാത്രി ചെലവഴിക്കുന്നതിനു തങ്ങിയ സ്ഥലത്തുവെച്ചു ഞങ്ങളുടെ ചാക്കുകൾ തുറന്നപ്പോൾ ഓരോരുത്തരുടെയും പണം അവരവരുടെ ചാക്കിന്റെ വായ്ക്കൽ കൃത്യം തൂക്കത്തിൽത്തന്നെ വെച്ചിരിക്കുന്നതായി കണ്ടു. അതു ഞങ്ങൾ തിരികെ കൊണ്ടുവന്നിട്ടുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ആഹാരം വാങ്ങുന്നതിനുള്ള കൂടുതൽ പണവും ഞങ്ങളുടെ പക്കലുണ്ട്. ഞങ്ങളുടെ പണം ഞങ്ങളുടെ ചാക്കിൽ വെച്ചത് ആരെന്നു ഞങ്ങൾക്ക് അറിഞ്ഞുകൂടാ.” ");
INSERT INTO malc_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“അതൊക്കെ ശരി, നിങ്ങൾ ഭയപ്പെടേണ്ട. നിങ്ങളുടെ ദൈവം, നിങ്ങളുടെ പിതാവിന്റെ ദൈവംതന്നെ നിങ്ങളുടെ ചാക്കുകളിൽ നിങ്ങൾക്കു നിക്ഷേപങ്ങൾ നൽകിയിരിക്കുന്നു; നിങ്ങളുടെ പണം ഞാൻ കൈപ്പറ്റിയിരുന്നു,” എന്നു പറഞ്ഞുകൊണ്ട് അദ്ദേഹം ശിമെയോനെ അവരുടെ അടുക്കൽ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ഇതിനുശേഷം കാര്യസ്ഥൻ അവരെ യോസേഫിന്റെ വീടിനുള്ളിലേക്കു കൊണ്ടുപോകുകയും അവർക്കു കാലുകഴുകാൻ വെള്ളം കൊടുക്കുകയും ചെയ്തു. അവരുടെ കഴുതകൾക്കുള്ള തീറ്റയും അദ്ദേഹം ഏർപ്പാടുചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","തങ്ങൾ ഭക്ഷണം കഴിക്കേണ്ടത് അവിടെവെച്ചാണെന്നു കേട്ടതുകൊണ്ട്, യോസേഫ് ഉച്ചയ്ക്ക് വരുമ്പോഴേക്കും അവർ സമ്മാനങ്ങൾ തയ്യാറാക്കിവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","യോസേഫ് വീട്ടിലെത്തിയപ്പോൾ, തങ്ങൾ വീടിനുള്ളിലേക്കു കൊണ്ടുവന്നിരുന്ന സമ്മാനങ്ങൾ അവർ അദ്ദേഹത്തിനു കാഴ്ചവെച്ചു; പിന്നെ അവർ അദ്ദേഹത്തെ സാഷ്ടാംഗം നമസ്കരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","അവർക്കു സുഖംതന്നെയോ എന്ന് ആരാഞ്ഞതിനുശേഷം അദ്ദേഹം അവരോട്, “നിങ്ങൾ നിങ്ങളുടെ വൃദ്ധനായ പിതാവിനെക്കുറിച്ച് എന്നോടു പറഞ്ഞിരുന്നല്ലോ! അദ്ദേഹത്തിനു സുഖമാണോ? അദ്ദേഹം ഇപ്പോഴും ജീവിച്ചിരിക്കുന്നോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","അതിന് അവർ, “അങ്ങയുടെ ദാസനായ ഞങ്ങളുടെ പിതാവ് ഇപ്പോഴും ജീവിച്ചിരിക്കുന്നു, അദ്ദേഹത്തിനു സുഖംതന്നെ” എന്നു മറുപടി പറഞ്ഞു; ഇങ്ങനെ പറഞ്ഞ് അവർ അദ്ദേഹത്തിന്റെ മുമ്പാകെ സാഷ്ടാംഗം വീണു. ");
INSERT INTO malc_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","അദ്ദേഹം ചുറ്റും നോക്കി, തന്റെ സഹോദരനും സ്വന്തം അമ്മയുടെ മകനുമായ ബെന്യാമീനെ കണ്ടിട്ട്, “നിങ്ങൾ എന്നോടു പറഞ്ഞിരുന്ന നിങ്ങളുടെ ഏറ്റവും ഇളയ സഹോദരൻ ഇതാണോ?” എന്നു ചോദിച്ചു. പിന്നെ അദ്ദേഹം, “എന്റെ മകനേ, ദൈവം നിന്നോടു കരുണകാണിക്കട്ടെ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","അനുജനെ കണ്ടപ്പോൾ യോസേഫ് വികാരാധീനനായിത്തീർന്നു; കരയാൻ ഇടം അന്വേഷിച്ചു; സ്വന്തം മുറിയിലേക്ക് തിരക്കിട്ടുകൊണ്ട് ചെന്നു കരഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","മുഖം കഴുകിയിട്ടു പുറത്തുവന്ന് തന്നെത്താൻ നിയന്ത്രിച്ചുകൊണ്ട്, “ആഹാരം വിളമ്പുക” എന്ന് ആജ്ഞാപിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","അവർ അദ്ദേഹത്തിനും സഹോദരന്മാർക്കും അദ്ദേഹത്തോടൊപ്പം ആഹാരം കഴിക്കുന്ന ഈജിപ്റ്റുകാർക്കും പ്രത്യേകം പ്രത്യേകമായി ഭക്ഷണം വിളമ്പി: കാരണം ഈജിപ്റ്റുകാർ എബ്രായരോടുകൂടെ ആഹാരം കഴിക്കുകയില്ല, അവർക്ക് അതു വെറുപ്പാണ്. ");
INSERT INTO malc_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","അദ്ദേഹത്തിന്റെ മുമ്പാകെ അവരെ മൂത്തവൻമുതൽ ഇളയവൻവരെ അവരുടെ പ്രായക്രമത്തിൽ ഇരുത്തി; അവർ വിസ്മയത്തോടെ പരസ്പരം നോക്കി. ");
INSERT INTO malc_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","യോസേഫിന്റെ മേശയിൽനിന്ന് അവർക്ക് ഓഹരി വിളമ്പിക്കൊടുത്തു. ബെന്യാമീനുള്ള ഓഹരി മറ്റുള്ളവരുടെ ഓഹരിയുടെ അഞ്ചിരട്ടിയായിരുന്നു. അവർ അദ്ദേഹത്തോടൊപ്പം യഥേഷ്ടം ഭക്ഷിച്ചുപാനംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","യോസേഫ് തന്റെ കാര്യസ്ഥനെ വിളിച്ചുപറഞ്ഞു: “ഈ പുരുഷന്മാരുടെ ചാക്കുകളിൽ അവർക്കു വഹിക്കാവുന്നത്ര ധാന്യം നിറയ്ക്കണം; ഓരോരുത്തന്റെയും പണം അവനവന്റെ ചാക്കിന്റെ വായ്ക്കൽത്തന്നെ വെച്ചേക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","പിന്നെ, ഏറ്റവും ഇളയവന്റെ ചാക്കിന്റെ വായ്ക്കൽ എന്റെ വെള്ളിപ്പാനപാത്രം അവന്റെ ധാന്യത്തിനുള്ള പണത്തോടൊപ്പം വെക്കുക.” യോസേഫ് തന്നോടു കൽപ്പിച്ചതുപോലെ അയാൾ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","പ്രഭാതമായപ്പോൾ അവരെ അവരുടെ കഴുതകളുമായി യാത്രയയച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","അവർ നഗരത്തിൽനിന്ന് ദൂരെയാകുന്നതിനുമുമ്പ് യോസേഫ് തന്റെ കാര്യസ്ഥനോട്, “പെട്ടെന്ന് ആ പുരുഷന്മാരെ പിൻതുടരുക. അവരോടൊപ്പം എത്തിക്കഴിയുമ്പോൾ നീ അവരോട്, ‘നിങ്ങൾ നന്മയ്ക്കുപകരം തിന്മ ചെയ്തതെന്തിന്? ");
INSERT INTO malc_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ഈ പാനപാത്രത്തിൽനിന്നല്ലയോ എന്റെ യജമാനൻ കുടിക്കുന്നത്? ഇതല്ലയോ ദേവപ്രശ്നംവെക്കുന്നതിന് അദ്ദേഹം ഉപയോഗിക്കുന്നത്? നിങ്ങൾ ഈ ചെയ്തത് അധാർമികമായ ഒരു കാര്യമാണ്’ എന്നു പറയുക” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","കാര്യസ്ഥൻ അവരോടൊപ്പം എത്തിക്കഴിഞ്ഞപ്പോൾ ഇതേ വാക്കുകൾ അവരോടു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","എന്നാൽ അവർ അദ്ദേഹത്തോട്, “യജമാനൻ ഇങ്ങനെയുള്ള കാര്യങ്ങൾ പറയുന്നതെന്ത്? അങ്ങയുടെ ഈ ദാസന്മാരിൽനിന്ന് അത്തരം കാര്യങ്ങൾ ഒരിക്കലും ഉണ്ടാകുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ഞങ്ങളുടെ ചാക്കുകളുടെ വായ്ക്കൽ കണ്ടെത്തിയ പണംപോലും ഞങ്ങൾ കനാൻദേശത്തുനിന്ന് അങ്ങയുടെ അടുക്കൽ മടക്കിക്കൊണ്ടുവന്നു. പിന്നെ അങ്ങയുടെ യജമാനന്റെ വീട്ടിൽനിന്ന് ഞങ്ങൾ വെള്ളിയോ സ്വർണമോ എന്തിനു മോഷ്ടിക്കണം? ");
INSERT INTO malc_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","അങ്ങയുടെ ദാസന്മാരിൽ ആരുടെയെങ്കിലും പക്കൽ അതു കണ്ടെത്തിയാൽ അവൻ മരിക്കട്ടെ; ശേഷിക്കുന്നവരായ ഞങ്ങൾ യജമാനന്റെ അടിമകൾ ആകുകയും ചെയ്യാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“കൊള്ളാം, നിങ്ങൾ പറയുന്നതുപോലെതന്നെ ആകട്ടെ. അത് ആരുടെ പക്കൽ കാണുന്നോ അവൻ എന്റെ അടിമയായിരിക്കുന്നതാണ്; ശേഷിക്കുന്ന മറ്റുള്ളവർ കുറ്റത്തിൽനിന്ന് ഒഴിഞ്ഞിരിക്കയും ചെയ്യും,” അദ്ദേഹം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","അവരിൽ ഓരോരുത്തനും പെട്ടെന്ന് അവനവന്റെ ചാക്ക് നിലത്ത് ഇറക്കിവെച്ചു തുറന്നു. ");
INSERT INTO malc_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ഏറ്റവും മൂത്തവനെമുതൽ ഏറ്റവും ഇളയവനെവരെ കാര്യസ്ഥൻ പരിശോധിച്ചു; ബെന്യാമീന്റെ ചാക്കിൽ പാനപാത്രം കണ്ടെത്തി. ");
INSERT INTO malc_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","അപ്പോൾ അവരെല്ലാവരും തങ്ങളുടെ വസ്ത്രംകീറി. പിന്നെ അവർ കഴുതകളുടെമേൽ ഭാരംകയറ്റി നഗരത്തിലേക്കു മടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","യെഹൂദയും സഹോദരന്മാരും യോസേഫിന്റെ വീട്ടിൽച്ചെന്നു. യോസേഫ് അപ്പോഴും അവിടെത്തന്നെ ഉണ്ടായിരുന്നു; അവർ അദ്ദേഹത്തിന്റെ മുമ്പാകെ സാഷ്ടാംഗം വീണു. ");
INSERT INTO malc_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","യോസേഫ് അവരോട്: “നിങ്ങൾ ഈ ചെയ്തതെന്ത്? എന്നെപ്പോലെയുള്ള ഒരുവനു ദേവപ്രശ്നംവെച്ചു കാര്യങ്ങൾ കണ്ടുപിടിക്കാൻ കഴിയുമെന്നു നിങ്ങൾക്കറിഞ്ഞുകൂടയോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","അതിന് യെഹൂദാ മറുപടി പറഞ്ഞത്, “യജമാനനോടു ഞങ്ങൾക്ക് എന്താണു പറയാൻ കഴിയുക? ഞങ്ങൾ എന്തുപറയും? ഞങ്ങളുടെ കുറ്റമില്ലായ്മ ഞങ്ങൾ എങ്ങനെയാണു തെളിയിക്കുക? അങ്ങയുടെ ദാസന്മാരുടെ കുറ്റം ദൈവം വെളിപ്പെടുത്തിയിരിക്കുന്നു. ഞങ്ങൾ ഇപ്പോൾ യജമാനന്റെ അടിമകളാണ്. ഞങ്ങളും പാനപാത്രം ആരുടെ പക്കൽ കണ്ടെത്തിയോ അവനും.” ");
INSERT INTO malc_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","“അങ്ങനെയൊരു പ്രവൃത്തി എന്നിൽനിന്ന് ഉണ്ടാകാതിരിക്കട്ടെ. ആരുടെ പക്കൽ പാനപാത്രം കണ്ടെത്തിയോ അവൻമാത്രം എന്റെ അടിമ ആയിരിക്കുന്നതാണ്; നിങ്ങളിൽ ശേഷമുള്ളവർ സമാധാനത്തോടെ നിങ്ങളുടെ അപ്പന്റെ അടുത്തേക്കു പൊയ്ക്കൊൾക,” യോസേഫ് പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","അപ്പോൾ യെഹൂദാ അദ്ദേഹത്തിന്റെ അടുത്തുചെന്ന് ഇങ്ങനെ ബോധിപ്പിച്ചു: “യജമാനനേ, തിരുവുള്ളം തോന്നി, അടിയന് യജമാനനോട് ഒരു വാക്കു പറയാൻ അനുവാദം തരണമേ. അങ്ങു ഫറവോനു സമനാണെങ്കിലും അടിയനോടു കോപിക്കരുതേ. ");
INSERT INTO malc_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","യജമാനൻ അടിയങ്ങളോട്, ‘നിങ്ങൾക്കു പിതാവോ സഹോദരന്മാരോ ഉണ്ടോ?’ എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","അപ്പോൾ ഞങ്ങൾ, ‘ഞങ്ങൾക്കു വൃദ്ധനായ ഒരു പിതാവും അദ്ദേഹത്തിനു വാർധക്യത്തിൽ ജനിച്ച, ഒരു മകനും ഉണ്ട്. അവന്റെ സഹോദരൻ മരിച്ചുപോയി; അവന്റെ മാതാവിന്റെ പുത്രന്മാരിൽ അവശേഷിക്കുന്നവൻ അവൻമാത്രമാണ്. അവന്റെ പിതാവ് അവനെ സ്നേഹിക്കുന്നു’ എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“അപ്പോൾ അങ്ങ്, ഈ ദാസന്മാരോട്, ‘എനിക്കു നേരിട്ട് അവനെ ഒന്നു കാണേണ്ടതിന് അവനെ എന്റെ അടുക്കൽ കൊണ്ടുവരിക’ എന്ന് ആജ്ഞാപിച്ചല്ലോ. ");
INSERT INTO malc_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","അപ്പോൾ ഞങ്ങൾ യജമാനനോട്: ‘ബാലന് അവന്റെ പിതാവിൽനിന്ന് വേർപിരിയാൻ വയ്യാ, വിട്ടുപോന്നാൽ പിതാവു മരിച്ചുപോകും,’ എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","അപ്പോൾ അങ്ങ് അടിയങ്ങളോട്: ‘നിങ്ങളുടെ ഏറ്റവും ഇളയ സഹോദരൻ നിങ്ങളോടുകൂടെ പോരുന്നില്ല എങ്കിൽ നിങ്ങൾ ഇനിമേൽ എന്റെ മുഖം കാണുകയില്ല’ എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ഞങ്ങൾ തിരികെ അങ്ങയുടെ ദാസനായ എന്റെ പിതാവിന്റെ അടുക്കൽ എത്തിയപ്പോൾ, അങ്ങ് പറഞ്ഞിരുന്നതെല്ലാം ഞങ്ങൾ അദ്ദേഹത്തോട് അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“അതിനുശേഷം ഞങ്ങളുടെ പിതാവ് ഞങ്ങളോട്, ‘നിങ്ങൾ മടങ്ങിച്ചെന്നു കുറെ ഭക്ഷണംകൂടി വാങ്ങുക’ എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","അതിനു ഞങ്ങൾ, ‘ഞങ്ങൾക്കു പോകാൻ സാധ്യമല്ല, ഞങ്ങളുടെ ഏറ്റവും ഇളയ സഹോദരൻ കൂടെയുണ്ടെങ്കിൽമാത്രമേ ഞങ്ങൾ പോകുകയുള്ളൂ. ഏറ്റവും ഇളയ അനുജൻ ഞങ്ങളോടൊപ്പം ഇല്ലാത്തപക്ഷം ഞങ്ങൾക്ക് അദ്ദേഹത്തിന്റെ മുഖം കാണാൻ സാധിക്കുകയില്ല’ എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“അപ്പോൾ അങ്ങയുടെ ദാസനായ എന്റെ പിതാവ് ഞങ്ങളോട്, ‘എന്റെ ഭാര്യ എനിക്കു രണ്ടു പുത്രന്മാരെ പ്രസവിച്ചു എന്നു നിങ്ങൾക്കറിയാമല്ലോ. ");
INSERT INTO malc_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","അവരിൽ ഒരാൾ എന്നിൽനിന്ന് അകലേക്ക് പോയി. “അവനെ തീർച്ചയായും ചീന്തിക്കളഞ്ഞിട്ടുണ്ട്,” എന്നു ഞാൻ ഉറച്ചു. ഇതുവരെ ഞാൻ അവനെ കണ്ടിട്ടുമില്ല. ");
INSERT INTO malc_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ഇവനെയും നിങ്ങൾ കൊണ്ടുപോകുകയും ഇവന് എന്തെങ്കിലും ദോഷം ഭവിക്കയും ചെയ്താൽ നിങ്ങൾ എന്റെ നരച്ചതലയെ, ദുഃഖത്തോടെ പാതാളത്തിൽ ഇറക്കും’ എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“അതുകൊണ്ട് ഇപ്പോൾ ബാലനെ കൂടാതെ ഞാൻ അങ്ങയുടെ ദാസനായ എന്റെ പിതാവിന്റെ അടുക്കൽ ചെന്നാൽ, അവനെ കാണാത്തതുനിമിത്തം അദ്ദേഹം മരിച്ചുപോകും; അദ്ദേഹത്തിന്റെ ജീവൻ ബാലന്റെ ജീവനോടു പറ്റിച്ചേർന്നിരിക്കുന്നു; അടിയങ്ങൾക്കു പിതാവിന്റെ നരച്ചതലയെ ദുഃഖത്തോടെ പാതാളത്തിൽ ഇറക്കാൻ ഇടയാകും. ");
INSERT INTO malc_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","‘അവനെ അങ്ങയുടെ അടുക്കൽ കൊണ്ടുവരാതിരുന്നാൽ, പിതാവേ, ഞാൻ എന്റെ ആയുഷ്കാലം മുഴുവൻ അതിന്റെ കുറ്റം വഹിച്ചുകൊള്ളാം’ എന്നു ഞാൻ ബാലന്റെ സുരക്ഷിതത്വത്തിന്, അടിയന്റെ പിതാവിന് ഉറപ്പു നൽകിയിട്ടുള്ളതാണ്. ");
INSERT INTO malc_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“അതുകൊണ്ട് ഇപ്പോൾ ബാലനെ അവന്റെ സഹോദരന്മാരോടുകൂടെ തിരികെപ്പോകാൻ ദയവായി അനുവദിക്കണം; ബാലനു പകരം അടിയൻ ഇവിടെ അടിമയായിരുന്നുകൊള്ളാം. ");
INSERT INTO malc_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ബാലൻ എന്നോടുകൂടെ ഇല്ലെങ്കിൽ ഞാൻ എങ്ങനെയാണ് എന്റെ പിതാവിന്റെ അടുക്കൽ മടങ്ങിച്ചെല്ലുന്നത്? അങ്ങനെ അരുതേ, എന്റെ പിതാവിനു വരുന്ന ദുരിതം കാണാൻ എനിക്കിടയാക്കരുതേ.” ");
INSERT INTO malc_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","അപ്പോൾ യോസേഫിനു തന്റെ ചുറ്റുംനിന്ന ഉദ്യോഗസ്ഥന്മാരുടെമുമ്പിൽ സ്വയം നിയന്ത്രിക്കാൻ കഴിയാതെയായി. “എല്ലാവരെയും എന്റെ മുന്നിൽനിന്ന് പുറത്താക്കുക,” അദ്ദേഹം വിളിച്ചുപറഞ്ഞു. അങ്ങനെ, യോസേഫ് സഹോദരന്മാർക്കു തന്നെത്തന്നെ വെളിപ്പെടുത്തിയപ്പോൾ അദ്ദേഹത്തോടൊപ്പം ആരും ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ഈജിപ്റ്റുകാർ കേൾക്കുംവിധം അദ്ദേഹം വളരെ ഉറക്കെ കരഞ്ഞു. ഫറവോന്റെ കൊട്ടാരത്തിലുള്ളവരും ഈ വാർത്ത കേട്ടു. ");
INSERT INTO malc_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","യോസേഫ് സഹോദരന്മാരോട്, “ഞാൻ യോസേഫ് ആകുന്നു! എന്റെ അപ്പൻ ഇപ്പോഴും ജീവിച്ചിരിക്കുന്നോ?” എന്നു ചോദിച്ചു. എന്നാൽ അതിന് ഉത്തരം പറയാൻ അദ്ദേഹത്തിന്റെ സഹോദരന്മാർക്കു കഴിഞ്ഞില്ല; കാരണം അദ്ദേഹത്തിന്റെ സന്നിധിയിൽ അവർ അത്ഭുതപരവശരായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ഇതിനുശേഷം യോസേഫ് സഹോദരന്മാരോട്, “എന്റെ അടുത്തേക്കു വരിക” എന്നു പറഞ്ഞു. അവർ അടുക്കൽവന്നു. അദ്ദേഹം പറഞ്ഞു, “ഞാൻ നിങ്ങളുടെ സഹോദരനായ യോസേഫ് ആണ്. നിങ്ങൾ എന്നെ ഈജിപ്റ്റിലേക്കു വിറ്റുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","എന്നാൽ ഇപ്പോൾ നിങ്ങൾ ദുഃഖിക്കരുത്; ഇവിടേക്കു വിറ്റതിൽ നിങ്ങളോടുതന്നെ കോപിക്കയുമരുത്; കാരണം, ജീവരക്ഷയ്ക്കായി ദൈവം നിങ്ങൾക്കുമുമ്പായി എന്നെ ഇവിടെ അയച്ചതാണ്. ");
INSERT INTO malc_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ദേശത്തു ക്ഷാമം തുടങ്ങിയിട്ട് ഇപ്പോൾ രണ്ടുവർഷം കഴിഞ്ഞിരിക്കുന്നു; ഉഴവും കൊയ്ത്തുമില്ലാത്ത അഞ്ചുവർഷം ഇനിയും ഉണ്ട്. ");
INSERT INTO malc_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","എന്നാൽ ഭൂമുഖത്ത് നിങ്ങൾക്കായി ഒരു ശേഷിപ്പിനെ നിലനിർത്താനും മഹത്തായ ഒരു വിടുതലിലൂടെ നിങ്ങളുടെ പ്രാണനെ രക്ഷിക്കാനുമായി ദൈവം നിങ്ങൾക്കുമുമ്പേ എന്നെ അയച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“ആകയാൽ നിങ്ങളല്ല, ദൈവമാണ് എന്നെ ഇവിടെ അയച്ചത്. അവിടന്ന് എന്നെ ഫറവോനു പിതാവും അദ്ദേഹത്തിന്റെ കുടുംബത്തിലുള്ള എല്ലാവർക്കും പ്രഭുവും ഈജിപ്റ്റുദേശത്തിലുള്ള എല്ലാവർക്കും ഭരണാധികാരിയും ആക്കിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ഇപ്പോൾ നിങ്ങൾ വേഗം എന്റെ അപ്പന്റെ അടുക്കൽ എത്തി അദ്ദേഹത്തോട് ഇങ്ങനെ പറയണം: ‘അങ്ങയുടെ മകനായ യോസേഫ് അറിയിക്കുന്നു: ദൈവം എന്നെ ഈജിപ്റ്റിന്റെ മുഴുവൻ പ്രഭുവാക്കിയിരിക്കുന്നു; അങ്ങ് എന്റെ അടുക്കലേക്കു വേഗം വരണം, ഒട്ടും താമസിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","അങ്ങും, അങ്ങയുടെ മക്കളും കൊച്ചുമക്കളും ആടുമാടുകളും സകലസ്വത്തുക്കളുമായി വന്ന് എന്റെ സമീപത്ത്, ഗോശെൻ ദേശത്തു താമസിച്ചുകൊള്ളുക. ");
INSERT INTO malc_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","അവിടെ നിങ്ങൾക്കു വേണ്ടുന്നതെല്ലാം ഞാൻ എത്തിച്ചുതന്നുകൊള്ളാം; ക്ഷാമത്തിന്റെ അഞ്ചുവർഷങ്ങൾകൂടി ഇനിയുണ്ട്. അല്ലെങ്കിൽ അങ്ങും അങ്ങയുടെ കുടുംബത്തിലുള്ളവരും അങ്ങേക്കുള്ളതെല്ലാം നശിച്ചുപോകുമല്ലോ.’ ");
INSERT INTO malc_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“നിങ്ങളോടു സംസാരിക്കുന്നതു വാസ്തവത്തിൽ ഞാൻതന്നെ എന്നു നിങ്ങളും എന്റെ സഹോദരനായ ബെന്യാമീനും നേരിട്ടു കാണുന്നല്ലോ! ");
INSERT INTO malc_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ഈജിപ്റ്റിൽ എനിക്കു നൽകിയിരിക്കുന്ന ബഹുമാനവും നിങ്ങൾ കണ്ടിരിക്കുന്ന സകലതും എന്റെ പിതാവിനെ അറിയിക്കണം; എന്റെ പിതാവിനെ എത്രയുംവേഗം ഇവിടെ കൊണ്ടുവരണം.” ");
INSERT INTO malc_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","പിന്നെ അദ്ദേഹം അനുജനായ ബെന്യാമീനെ കെട്ടിപ്പിടിച്ചു കരഞ്ഞു; ബെന്യാമീനും കരഞ്ഞുകൊണ്ട് അദ്ദേഹത്തെ ആലിംഗനംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","തന്റെ എല്ലാ സഹോദരന്മാരെയും ചുംബിച്ച് അവരെച്ചൊല്ലി അദ്ദേഹം കരഞ്ഞു. ഈ സംഭവത്തിനുശേഷം തന്റെ സഹോദരന്മാർ അദ്ദേഹവുമായി സല്ലപിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","യോസേഫിന്റെ സഹോദരന്മാർ വന്നിട്ടുണ്ട് എന്ന വാർത്ത ഫറവോന്റെ അരമനയിൽ എത്തിയപ്പോൾ അദ്ദേഹവും അദ്ദേഹത്തിന്റെ ഉദ്യോഗസ്ഥന്മാർ എല്ലാവരും ആഹ്ലാദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ഫറവോൻ യോസേഫിനോടു പറഞ്ഞു: “നിന്റെ സഹോദരന്മാരോട്, ‘നിങ്ങളുടെ മൃഗങ്ങളുടെ പുറത്തു ചുമടുകയറ്റി കനാൻദേശത്തേക്കു മടങ്ങിപ്പോകാൻ പറയുക. ");
INSERT INTO malc_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","നിങ്ങളുടെ പിതാവിനെയും നിങ്ങളുടെ കുടുംബാംഗങ്ങളെയും എന്റെ അടുക്കൽ കൊണ്ടുവരാനും പറയണം; ഈജിപ്റ്റുദേശത്തുള്ളതിൽ ഏറ്റവും നല്ല പ്രദേശം ഞാൻ നിങ്ങൾക്കു തരുമെന്നും നിങ്ങൾക്ക് ഈ ദേശത്തിന്റെ സമൃദ്ധി അനുഭവിക്കാൻ കഴിയുമെന്നും അവരെ അറിയിക്കണം.’ ");
INSERT INTO malc_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“നീ അവരോടു വീണ്ടും പറയേണ്ടത്: ‘നിങ്ങളുടെ കുഞ്ഞുങ്ങൾക്കും നിങ്ങളുടെ ഭാര്യമാർക്കുംവേണ്ടി ഈജിപ്റ്റിൽനിന്ന് ഏതാനും വാഹനങ്ങൾ കൊണ്ടുപോകുകയും പിതാവിനെ കൂട്ടിക്കൊണ്ടുപോരുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","നിങ്ങളുടെ വസ്തുവകകളെപ്പറ്റി ഒട്ടും ചിന്താഭാരപ്പെടേണ്ടതില്ല; കാരണം ഈജിപ്റ്റിൽ വിശിഷ്ടമായതൊക്കെയും നിങ്ങൾക്കുള്ളതാണ്.’ ” ");
INSERT INTO malc_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ഇസ്രായേലിന്റെ പുത്രന്മാർ അങ്ങനെതന്നെ പ്രവർത്തിച്ചു. ഫറവോൻ കൽപ്പിച്ചതുപോലെ യോസേഫ് അവർക്കു വാഹനങ്ങൾ നൽകുകയും അവരുടെ യാത്രയ്ക്കുള്ള ക്രമീകരണങ്ങൾ ചെയ്തുകൊടുക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","അവരിൽ ഓരോരുത്തർക്കും അദ്ദേഹം പുതിയ ഓരോ വസ്ത്രങ്ങൾ കൊടുത്തു. എന്നാൽ ബെന്യാമീന് അദ്ദേഹം മുന്നൂറു ശേക്കേൽ വെള്ളിയും അഞ്ചു വസ്ത്രങ്ങളും കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","പിതാവിന് അദ്ദേഹം അയച്ചുകൊടുത്തത്: പത്തു കഴുതകളുടെ പുറത്ത് കയറ്റിയ ഈജിപ്റ്റിലെ ഏറ്റവും വിശിഷ്ടമായ വസ്തുക്കളും പത്തു പെൺകഴുതകളുടെ പുറത്തു കയറ്റിയ ധാന്യവും അപ്പവും അദ്ദേഹത്തിന്റെ യാത്രയ്ക്കു വേണ്ടുന്ന മറ്റു സാമഗ്രികളും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","അങ്ങനെ അദ്ദേഹം സഹോദരന്മാരെ യാത്രയാക്കി; അവർ പുറപ്പെടുമ്പോൾ അദ്ദേഹം അവരോട്, “വഴിക്കുവെച്ചു നിങ്ങൾ കലഹിക്കരുത്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","അങ്ങനെ അവർ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെട്ട് കനാൻദേശത്ത്, തങ്ങളുടെ പിതാവായ യാക്കോബിന്റെ അടുക്കൽ എത്തിച്ചേർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","അവർ അദ്ദേഹത്തോട്, “യോസേഫ് ഇപ്പോഴും ജീവിച്ചിരിക്കുന്നു! അവൻ, ഈജിപ്റ്റുദേശത്തിന്റെ മുഴുവൻ ഭരണാധികാരിയാണ്” എന്നു പറഞ്ഞു. യാക്കോബ് സ്തംഭിച്ചിരുന്നുപോയി; അവരുടെ വാക്ക് അദ്ദേഹം വിശ്വസിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","എന്നാൽ യോസേഫ് തങ്ങളോടു പറഞ്ഞതെല്ലാം അവർ അദ്ദേഹത്തെ അറിയിക്കയും തന്നെ കൂട്ടിക്കൊണ്ടുപോകുന്നതിനു യോസേഫ് അയച്ചിരിക്കുന്ന വാഹനങ്ങൾ കാണുകയും ചെയ്തപ്പോൾ അവരുടെ പിതാവായ യാക്കോബിന് വീണ്ടും ചൈതന്യംവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","“എനിക്കുറപ്പായി! എന്റെ മകൻ യോസേഫ് ജീവനോടെയിരിക്കുന്നു. ഞാൻ മരിക്കുന്നതിനുമുമ്പേ ചെന്ന് അവനെ കാണും,” ഇസ്രായേൽ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ഇസ്രായേൽ തനിക്കുള്ള സകലവുമായി യാത്രതിരിച്ചു; ബേർ-ശേബയിൽ എത്തിയപ്പോൾ അദ്ദേഹം തന്റെ പിതാവായ യിസ്ഹാക്കിന്റെ ദൈവത്തിനു യാഗങ്ങൾ അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ദൈവം രാത്രിയിൽ, ഒരു ദർശനത്തിൽ ഇസ്രായേലിനോടു സംസാരിച്ചു; “യാക്കോബേ! യാക്കോബേ!” എന്നു വിളിച്ചു. “അടിയൻ ഇതാ” അദ്ദേഹം ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","അപ്പോൾ യഹോവ: “ഞാൻ ആകുന്നു ദൈവം; നിന്റെ പിതാവിന്റെ ദൈവംതന്നെ. ഈജിപ്റ്റിലേക്കു പോകാൻ ഭയപ്പെടരുത്, അവിടെ ഞാൻ നിന്നെ വലിയൊരു ജനതയാക്കും. ");
INSERT INTO malc_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ഞാൻ നിന്നോടുകൂടെ ഈജിപ്റ്റിലേക്കു പോരുകയും നിന്നെ വീണ്ടും മടക്കി കൊണ്ടുവരികയും ചെയ്യും. യോസേഫിന്റെ സ്വന്തം കൈകൾതന്നെ നിന്റെ കണ്ണുകൾ അടയ്ക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ഇതിനുശേഷം യാക്കോബ് ബേർ-ശേബയിൽനിന്ന് പുറപ്പെട്ടു; ഇസ്രായേലിന്റെ പുത്രന്മാർ തങ്ങളുടെ പിതാവായ യാക്കോബിനെയും തങ്ങളുടെ കുട്ടികളെയും ഭാര്യമാരെയും അവർക്കുവേണ്ടി ഫറവോൻ അയച്ചിരുന്ന വാഹനങ്ങളിൽ കയറ്റി. ");
INSERT INTO malc_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","അവർ കനാനിൽവെച്ചു സമ്പാദിച്ച തങ്ങളുടെ സകല ആടുമാടുകളും വസ്തുവകകളും കൂടെക്കൊണ്ടുപോയി. യാക്കോബും അദ്ദേഹത്തിന്റെ എല്ലാ സന്താനങ്ങളും ഈജിപ്റ്റിലേക്കു പോയി. ");
INSERT INTO malc_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","അദ്ദേഹം തന്നോടൊപ്പം പുത്രന്മാരെയും പൗത്രന്മാരെയും പുത്രിമാരെയും പൗത്രിമാരെയും—ഇങ്ങനെ സകലസന്താനങ്ങളെയും ഈജിപ്റ്റിലേക്കു കൊണ്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ഈജിപ്റ്റിലേക്കു പോയവരായ ഇസ്രായേലിന്റെ പുത്രന്മാരുടെ (യാക്കോബിന്റെയും അദ്ദേഹത്തിന്റെ പിൻഗാമികളുടെയും) പേരുകൾ ഇവയാണ്: യാക്കോബിന്റെ ആദ്യജാതനായ രൂബേൻ. ");
INSERT INTO malc_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","രൂബേന്റെ പുത്രന്മാർ: ഹാനോക്ക്, ഫല്ലൂ, ഹെസ്രോൻ, കർമി, ");
INSERT INTO malc_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ശിമെയോന്റെ പുത്രന്മാർ: യെമൂവേൽ, യാമിൻ, ഓഹദ്, യാഖീൻ, സോഹർ, ഒരു കനാന്യസ്ത്രീയുടെ മകനായ ശാവൂൽ. ");
INSERT INTO malc_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ലേവിയുടെ പുത്രന്മാർ: ഗെർശോൻ, കെഹാത്ത്, മെരാരി. ");
INSERT INTO malc_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","യെഹൂദയുടെ പുത്രന്മാർ: ഏർ, ഓനാൻ, ശേലഹ്, ഫേരെസ്, സേരഹ് (എന്നാൽ ഏരും ഓനാനും കനാൻനാട്ടിൽവെച്ചു മരിച്ചുപോയി.) ഫേരെസിന്റെ പുത്രന്മാർ: ഹെസ്രോൻ, ഹാമൂൽ. ");
INSERT INTO malc_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","യിസ്സാഖാറിന്റെ പുത്രന്മാർ: തോലാ, പൂവാ, യോബ്, ശിമ്രോൻ. ");
INSERT INTO malc_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","സെബൂലൂന്റെ പുത്രന്മാർ: സേരെദ്, ഏലോൻ, യഹ്ലെയേൽ. ");
INSERT INTO malc_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ഇവർ യാക്കോബിന്റെ പുത്രന്മാർ; ഇവരെയും യാക്കോബിന്റെ പുത്രിയായ ദീനായെയും ലേയാ പദ്ദൻ-അരാമിൽവെച്ചു പ്രസവിച്ചു. അദ്ദേഹത്തിന്റെ ഈ പുത്രന്മാരും പുത്രിമാരുംകൂടി ആകെ മുപ്പത്തിമൂന്നു പേർ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ഗാദിന്റെ പുത്രന്മാർ: സിഫ്യോൻ, ഹഗ്ഗീ, ശൂനി, എസ്ബോൻ, ഏരി, അരോദി, അരേലി. ");
INSERT INTO malc_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ആശേരിന്റെ പുത്രന്മാർ: യിമ്നാ, യിശ്വ, യിശ്‌വി, ബേരീയാ. ഇവരുടെ സഹോദരി ആയിരുന്നു സേരഹ്. ബേരീയാവിന്റെ പുത്രന്മാർ: ഹേബെർ, മൽക്കീയേൽ ");
INSERT INTO malc_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ഇവരായിരുന്നു ലാബാൻ തന്റെ മകളായ ലേയയ്ക്കു കൊടുത്ത സിൽപ്പയിൽ യാക്കോബിനു ജനിച്ച മക്കൾ—ആകെ പതിനാറുപേർ. ");
INSERT INTO malc_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","യാക്കോബിന്റെ ഭാര്യയായ റാഹേലിന്റെ പുത്രന്മാർ: യോസേഫ്, ബെന്യാമീൻ. ");
INSERT INTO malc_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ഓനിലെ പുരോഹിതനായ പോത്തിഫേറയുടെ മകളായ ആസ്നത്തിൽ യോസേഫിനു മനശ്ശെയും എഫ്രയീമും ഈജിപ്റ്റിൽവെച്ചു ജനിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ബെന്യാമീന്റെ പുത്രന്മാർ: ബേല, ബേഖെർ, അശ്ബേൽ, ഗേര, നയമാൻ, ഏഹീ, രോശ്, മുപ്പീം, ഹുപ്പീം, ആരെദ്. ");
INSERT INTO malc_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ഇവരായിരുന്നു യാക്കോബിനു റാഹേലിൽ ജനിച്ച പുത്രന്മാർ—ആകെ പതിന്നാലു പേർ. ");
INSERT INTO malc_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ദാനിന്റെ പുത്രൻ: ഹൂശീം. ");
INSERT INTO malc_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","നഫ്താലിയുടെ പുത്രന്മാർ: യഹ്സേൽ, ഗൂനി, യേസെർ, ശില്ലേം. ");
INSERT INTO malc_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ഇവരായിരുന്നു ലാബാൻ തന്റെ മകളായ റാഹേലിനു കൊടുത്തിരുന്ന ബിൽഹായിൽ യാക്കോബിനു ജനിച്ച പുത്രന്മാർ—ആകെ ഏഴുപേർ. ");
INSERT INTO malc_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","യാക്കോബിന്റെ പുത്രന്മാരുടെ ഭാര്യമാരെ കൂടാതെ അദ്ദേഹത്തിന്റെ നേരിട്ടുള്ള പിൻഗാമികളായി, അദ്ദേഹത്തോടുകൂടെ ഈജിപ്റ്റിലേക്കു പോയവർ അറുപത്തിയാറുപേർ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","യോസേഫിന് ഈജിപ്റ്റിൽവെച്ചു ജനിച്ച രണ്ടു പുത്രന്മാർ ഉൾപ്പെടെ, ഈജിപ്റ്റിലേക്കു പോയ യാക്കോബിന്റെ കുടുംബാംഗങ്ങൾ ആകെക്കൂടി എഴുപതുപേരായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ഗോശെനിലേക്കുള്ള വഴി അറിയേണ്ടതിന് യാക്കോബ് തനിക്കുമുമ്പ് യെഹൂദയെ യോസേഫിന്റെ അടുത്തേക്ക് അയച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","അവർ ഗോശെൻ പ്രദേശത്ത് എത്തിയപ്പോഴേക്കും യോസേഫ് തന്റെ രഥം തയ്യാറാക്കി, പിതാവായ ഇസ്രായേലിനെ എതിരേൽക്കാൻ ഗോശെനിൽ ചെന്നിരുന്നു. പിതാവിനെ കണ്ടപ്പോൾതന്നെ യോസേഫ് അദ്ദേഹത്തെ കെട്ടിപ്പിടിച്ച് ഏറെനേരം കരഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ഇസ്രായേൽ യോസേഫിനോട്, “ഇപ്പോൾ ഞാൻ മരിക്കാൻ ഒരുക്കമാണ്, കാരണം നീ ജീവനോടെ ഇരിക്കുന്നു എന്നു ഞാൻതന്നെ നേരിട്ടു കണ്ടിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","പിന്നെ, യോസേഫ് തന്റെ സഹോദരന്മാരോടും പിതാവിന്റെ കുടുംബത്തിലുള്ള എല്ലാവരോടുമായി പറഞ്ഞു, “ഞാൻ ചെന്ന് ഫറവോനോടു സംസാരിക്കും. അദ്ദേഹത്തോട്, ‘കനാൻദേശത്തു ജീവിച്ചിരുന്നവരായ എന്റെ സഹോദരന്മാരും പിതാവിന്റെ ഭവനത്തിലുള്ളവരും എന്റെ അടുക്കൽ വന്നിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ആ പുരുഷന്മാർ ഇടയന്മാരാണ്; അവർ ആടുമാടുകളെ മേയിക്കുന്നു; അവർ തങ്ങളോടൊപ്പം ആടുമാടുകളെയും തങ്ങൾക്കുള്ള സകലതും കൊണ്ടുവന്നിട്ടുണ്ട്’ എന്നു പറയും. ");
INSERT INTO malc_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ഫറവോൻ നിങ്ങളെ അകത്തേക്കു വിളിച്ച് ‘നിങ്ങളുടെ തൊഴിൽ എന്താണ്?’ എന്നു ചോദിക്കുമ്പോൾ ");
INSERT INTO malc_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","‘അടിയങ്ങൾ അടിയങ്ങളുടെ പിതാവിനെപ്പോലെതന്നെ ബാല്യംമുതൽ ആടുമാടുകളെ മേയിച്ചുപോരുന്നു’ എന്ന് ഉത്തരം പറയണം. അപ്പോൾ നിങ്ങൾക്കു ഗോശെൻ പ്രദേശത്തു താമസം ഉറപ്പിക്കാൻ അനുവാദം ലഭിക്കും; ഇടയന്മാരോട് ഈജിപ്റ്റുകാർക്കു വെറുപ്പാണ്.” ");
INSERT INTO malc_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","യോസേഫ് ചെന്നു ഫറവോനോട്, “എന്റെ പിതാവും സഹോദരന്മാരും തങ്ങളുടെ ആടുമാടുകളും സകലസ്വത്തുക്കളുമായി കനാൻദേശത്തുനിന്നു വന്നിരിക്കുന്നു; അവർ ഇപ്പോൾ ഗോശെനിലുണ്ട്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","അദ്ദേഹം തന്റെ സഹോദരന്മാരിൽ അഞ്ചുപേരെ തെരഞ്ഞെടുത്തു ഫറവോന്റെ മുമ്പിൽ നിർത്തി. ");
INSERT INTO malc_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ഫറവോൻ യോസേഫിന്റെ സഹോദരന്മാരോട്, “നിങ്ങളുടെ തൊഴിൽ എന്താണ്?” എന്നു ചോദിച്ചു. അതിന് അവർ, “അടിയങ്ങളും അടിയങ്ങളുടെ പിതാക്കന്മാരെപ്പോലെ ഇടയന്മാരാണ്” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","അവർ തുടർന്നു, “ഞങ്ങൾ കുറച്ചുകാലത്തേക്ക് ഇവിടെ താമസിക്കാൻ വന്നതാണ്; കനാനിൽ ക്ഷാമം അതികഠിനമായിരിക്കുന്നു; അടിയങ്ങളുടെ ആട്ടിൻപറ്റങ്ങൾക്കു മേച്ചിലില്ല. അതുകൊണ്ട് ദയവുതോന്നി അടിയങ്ങളെ ഗോശെനിൽ താമസിക്കാൻ അനുവദിക്കുമാറാകണം.” ");
INSERT INTO malc_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ഫറവോൻ യോസേഫിനോട്, “നിന്റെ പിതാവും നിന്റെ സഹോദരന്മാരും നിന്റെ അടുക്കൽ വന്നിരിക്കുന്നു, ");
INSERT INTO malc_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ഈജിപ്റ്റുദേശം നിന്റെ മുമ്പിൽ ഇരിക്കുന്നു. നിന്റെ പിതാവിനെയും സഹോദരന്മാരെയും ദേശത്തിന്റെ ഏറ്റവും നല്ലഭാഗത്തു താമസിപ്പിക്കുക. അവർ ഗോശെനിൽ താമസിക്കട്ടെ. അവരിൽ പ്രാപ്തന്മാരായവരെ എന്റെ ആടുമാടുകളുടെ ചുമതല ഏൽപ്പിക്കുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","തുടർന്ന് യോസേഫ് തന്റെ പിതാവായ യാക്കോബിനെ കൊണ്ടുവന്നു ഫറവോന്റെ മുമ്പിൽ നിർത്തി. യാക്കോബ് ഫറവോനെ അനുഗ്രഹിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","അതിനുശേഷം ഫറവോൻ യാക്കോബിനോട്, “അങ്ങേക്ക് എത്ര വയസ്സായി?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","യാക്കോബ് ഫറവോനോട്, “എന്റെ പരദേശപ്രയാണത്തിന്റെ വർഷങ്ങൾ നൂറ്റിമുപ്പതായിരിക്കുന്നു. എന്റെ വർഷങ്ങൾ ചുരുക്കവും പ്രയാസകരവുമാണ്; അവ എന്റെ പിതാക്കന്മാരുടെ പരദേശപ്രയാണവർഷങ്ങളോളം ആയിട്ടുമില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","പിന്നെ യാക്കോബ് ഫറവോനെ അനുഗ്രഹിച്ചിട്ട് അദ്ദേഹത്തിന്റെ സന്നിധിയിൽനിന്ന് പോയി. ");
INSERT INTO malc_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","യോസേഫ് തന്റെ പിതാവിനെയും സഹോദരന്മാരെയും ഈജിപ്റ്റിൽ താമസിപ്പിച്ചു; ഫറവോൻ നിർദേശിച്ചപ്രകാരം നാടിന്റെ ഏറ്റവും നല്ല പ്രദേശമായ രമെസേസ് ജില്ലയിൽ അവർക്കു ഭൂമി നൽകുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","യോസേഫ് തന്റെ പിതാവിനും സഹോദരന്മാർക്കും പിതാവിന്റെ കുടുംബത്തിൽപ്പെട്ട എല്ലാവർക്കും അവരുടെ കുഞ്ഞുങ്ങളുടെ എണ്ണമനുസരിച്ച് ആഹാരം നൽകി. ");
INSERT INTO malc_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ക്ഷാമം അതിരൂക്ഷമാകുകയാൽ ആ പ്രദേശത്തെങ്ങും ഭക്ഷണമില്ലാതായി; ഈജിപ്റ്റും കനാനും ക്ഷാമംനിമിത്തം ക്ഷയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ഈജിപ്റ്റിലും കനാനിലും ഉള്ളവർ തങ്ങൾ വാങ്ങിയ ധാന്യത്തിന്റെ വിലയായി കൊടുത്ത പണം മുഴുവൻ യോസേഫ് ശേഖരിച്ച് ഫറവോന്റെ കൊട്ടാരത്തിലേക്കു കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ഈജിപ്റ്റിലും കനാനിലും ഉള്ള ജനങ്ങളുടെ പണം തീർന്നപ്പോൾ ഈജിപ്റ്റിലുള്ളവർ എല്ലാംകൂടി യോസേഫിന്റെ അടുക്കൽവന്ന്, “ഞങ്ങൾക്കു ഭക്ഷണം തരണം, അങ്ങയുടെ കണ്മുമ്പിൽവെച്ചു ഞങ്ങൾ മരിക്കുന്നതെന്തിന്? ഞങ്ങളുടെ പണം തീർന്നുപോയിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","“എങ്കിൽ നിങ്ങളുടെ ആടുമാടുകളെ കൊണ്ടുവരിക. നിങ്ങളുടെ പണം തീർന്നുപോയിരിക്കുന്നതുകൊണ്ട് ഞാൻ നിങ്ങളുടെ ആടുമാടുകളെ വിലയായി വാങ്ങി അവയ്ക്കുപകരം ഭക്ഷണം തരാം,” എന്നു യോസേഫ് പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","അങ്ങനെ അവർ തങ്ങളുടെ ആടുമാടുകളെ യോസേഫിന്റെ അടുക്കൽ കൊണ്ടുവന്നു. അദ്ദേഹം അവരുടെ കുതിരകൾക്കും ചെമ്മരിയാടുകൾക്കും കോലാടുകൾക്കും കന്നുകാലികൾക്കും കഴുതകൾക്കും പകരം അവർക്കു ഭക്ഷണം നൽകി. അങ്ങനെ അദ്ദേഹം അവരുടെ ആടുമാടുകൾക്കു പകരമായി ഭക്ഷണം കൊടുത്ത് അവരെ ആ വർഷം പരിപാലിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","അങ്ങനെ ആ വർഷം കഴിഞ്ഞു; അവർ പിറ്റേവർഷം അദ്ദേഹത്തിന്റെ അടുക്കൽ വന്നിട്ട് ഇപ്രകാരം പറഞ്ഞു: “ഞങ്ങളുടെ പണം തീർന്നുപോകുകയും ഞങ്ങളുടെ ആടുമാടുകൾ അങ്ങയുടെ വകയായിത്തീരുകയും ചെയ്തതുകൊണ്ട് ഞങ്ങളുടെ ശരീരവും ഭൂമിയും അല്ലാതെ യജമാനനു തരാൻ മറ്റൊന്നുമില്ല. ഈ വസ്തുത യജമാനനിൽനിന്ന് മറച്ചുവെക്കാൻ ഞങ്ങൾക്കു നിവൃത്തിയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ആഹാരത്തിനു പകരമായി ഞങ്ങളെയും ഞങ്ങളുടെ ഭൂമിയെയും വാങ്ങിക്കൊള്ളുക. ഞങ്ങൾ ഞങ്ങളുടെ ഭൂമിയോടുകൂടെ ഫറവോന്റെ അടിമകളായിക്കൊള്ളാം. ഞങ്ങൾ മരിച്ചുപോകാതെ ജീവിച്ചിരിക്കേണ്ടതിനും ഭൂമി ശൂന്യമായിപ്പോകാതിരിക്കേണ്ടതിനും അങ്ങു ഞങ്ങൾക്കു വിത്തു തരണം.” ");
INSERT INTO malc_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","യോസേഫ് ഈജിപ്റ്റിലുള്ള സർവഭൂമിയും ഫറവോനുവേണ്ടി വിലയ്ക്കുവാങ്ങി. ഈജിപ്റ്റുകാർ ഒന്നടങ്കം തങ്ങളുടെ വയലുകൾ വിറ്റു; ക്ഷാമം അവർക്കു താങ്ങാവുന്നതിലും അധികം കഠിനമായിരുന്നു. അങ്ങനെ ഭൂമിയെല്ലാം ഫറവോന്റേതായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","അങ്ങനെ യോസേഫ് ഈജിപ്റ്റിന്റെ ഒരറ്റംമുതൽ മറ്റേ അറ്റംവരെയുള്ള സകല ആളുകളെയും അടിമകളാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","എന്നാൽ പുരോഹിതന്മാർക്കു ഫറവോന്റെ പക്കൽനിന്ന് ക്രമമായി ഓഹരി ലഭിച്ചിരുന്നതുകൊണ്ടും ഫറവോൻ കൊടുത്ത ഓഹരിയിൽനിന്ന് അവർക്കു വേണ്ടുന്നത്ര ആഹാരം ഉണ്ടായിരുന്നതുകൊണ്ടും യോസേഫ് അവരുടെ ഭൂമി വിലയ്ക്കു വാങ്ങിയില്ല. അക്കാരണത്താലാണ് അവർ തങ്ങളുടെ ഭൂമി വിൽക്കാതിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","യോസേഫ് ജനങ്ങളോടു പറഞ്ഞു: “ഇന്നു ഞാൻ നിങ്ങളെയും നിങ്ങളുടെ നിലങ്ങളെയും ഫറവോനുവേണ്ടി വിലയ്ക്കു വാങ്ങിയിരിക്കുകയാൽ നിങ്ങൾക്കുവേണ്ടിയുള്ള വിത്ത് ഇതാ, നിങ്ങൾക്കു നിലത്തു കൃഷി ചെയ്യാമല്ലോ. ");
INSERT INTO malc_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","എന്നാൽ വിളവുണ്ടാകുമ്പോൾ അതിന്റെ അഞ്ചിലൊന്നു ഫറവോനു കൊടുക്കണം. ശേഷിക്കുന്ന അഞ്ചിൽ നാലുഭാഗം വയലുകൾക്കുള്ള വിത്തായും നിങ്ങൾക്കും വീട്ടിലുള്ളവർക്കും നിങ്ങളുടെ കുഞ്ഞുങ്ങൾക്കുമുള്ള ആഹാരമായും സൂക്ഷിക്കാവുന്നതാണ്.” ");
INSERT INTO malc_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","“അങ്ങു ഞങ്ങളുടെ ജീവൻ രക്ഷിച്ചിരിക്കുന്നു,” അവർ പറഞ്ഞു. “യജമാനൻ ഞങ്ങളോടു കരുണ കാണിച്ചാലും; ഞങ്ങൾ ഫറവോന് അടിമകളായിരുന്നുകൊള്ളാം.” ");
INSERT INTO malc_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","വിളവിന്റെ അഞ്ചിലൊന്ന് ഫറവോനുള്ളത് എന്ന ഭൂനിയമം യോസേഫ് ഈജിപ്റ്റിൽ സ്ഥാപിതമാക്കി. അത് ഇന്നും നിലനിൽക്കുന്നു. പുരോഹിതന്മാരുടെമാത്രം ഭൂമി ഫറവോന് അധീനമാകാതിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ഇസ്രായേല്യർ ഈജിപ്റ്റിലെ ഗോശെൻ പ്രദേശത്തു സ്ഥിരതാമസമാക്കി. അവിടെ അവർ വസ്തുക്കൾ സമ്പാദിക്കുകയും ഫലപുഷ്ടിയുള്ളവരായി എണ്ണത്തിൽ വർധിച്ചുവരികയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","യാക്കോബ് ഈജിപ്റ്റിൽ പതിനേഴുവർഷം ജീവിച്ചു; അദ്ദേഹത്തിന്റെ ആയുസ്സ് നൂറ്റിനാൽപ്പത്തിയേഴു വർഷമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ഇസ്രായേലിന്റെ മരണസമയം ആസന്നമായപ്പോൾ അദ്ദേഹം തന്റെ പുത്രനായ യോസേഫിനെ ആളയച്ചുവരുത്തി, അദ്ദേഹത്തോട്, “നിനക്ക് എന്നോടു പ്രീതിയുണ്ടെങ്കിൽ, നിന്റെ കൈ എന്റെ തുടയിൻകീഴിൽ വെക്കുകയും എന്നോടു കരുണയും വിശ്വസ്തതയും പുലർത്തുമെന്നു വാക്കു തരികയും വേണം. എന്നെ ഈജിപ്റ്റിൽ അടക്കരുത്; ");
INSERT INTO malc_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","പിന്നെയോ, ഞാൻ എന്റെ പിതാക്കന്മാരോടൊപ്പം നിദ്ര പ്രാപിക്കുമ്പോൾ എന്നെ ഈജിപ്റ്റിൽനിന്ന് പുറത്തേക്കു കൊണ്ടുപോയി അവരെ അടക്കിയ സ്ഥലത്തുതന്നെ അടക്കണം” എന്നു പറഞ്ഞു. “അങ്ങു പറയുന്നതുപോലെ ഞാൻ ചെയ്യാം,” അദ്ദേഹം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","“എന്നോടു ശപഥംചെയ്യുക,” അദ്ദേഹം ആവശ്യപ്പെട്ടു. അപ്പോൾ യോസേഫ് അദ്ദേഹത്തോടു ശപഥംചെയ്തു; ഇസ്രായേൽ തന്റെ വടിയുടെ തലയ്ക്കൽ ഊന്നിനിന്നു. ");
INSERT INTO malc_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","കുറെ കാലത്തിനുശേഷം, “അങ്ങയുടെ പിതാവു രോഗിയായിരിക്കുന്നു” എന്ന് യോസേഫിന് അറിയിപ്പു കിട്ടി. അദ്ദേഹം മനശ്ശെ, എഫ്രയീം എന്നീ രണ്ടു പുത്രന്മാരെയും കൂട്ടിക്കൊണ്ടുചെന്നു. ");
INSERT INTO malc_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","“അങ്ങയുടെ പുത്രനായ യോസേഫ് അങ്ങയുടെ അടുക്കൽ വന്നിരിക്കുന്നു,” എന്ന് യാക്കോബിനെ അറിയിച്ചപ്പോൾ ഇസ്രായേൽ തനിക്കുള്ള ശക്തി സമാഹരിച്ചു കട്ടിലിൽ എഴുന്നേറ്റിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","യാക്കോബ് യോസേഫിനോടു പറഞ്ഞു, “സർവശക്തനായ ദൈവം കനാൻദേശത്തെ ലൂസിൽവെച്ച് എനിക്കു പ്രത്യക്ഷനായി എന്നെ അവിടെവെച്ച് അനുഗ്രഹിച്ചുകൊണ്ട് എന്നോട്: ");
INSERT INTO malc_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘ഞാൻ നിന്നെ സന്താനപുഷ്ടിയുള്ളവനാക്കുകയും നിന്റെ സംഖ്യ വർധിപ്പിക്കുകയും ചെയ്യും; ഞാൻ നിന്നെ ഒരു ജനസമൂഹമാക്കുകയും നിനക്കുശേഷം ഈ ദേശം നിന്റെ പിൻഗാമികൾക്കു ശാശ്വതാവകാശമായി നൽകുകയും ചെയ്യും’ എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“ഞാൻ ഇവിടെ നിന്റെ അടുക്കൽ എത്തുന്നതിനുമുമ്പ് നിനക്ക് ഈജിപ്റ്റിൽവെച്ചു ജനിച്ചവരായ നിന്റെ പുത്രന്മാരെ രണ്ടുപേരെയും എനിക്കുള്ളവരായി കണക്കാക്കും; രൂബേനും ശിമെയോനും എനിക്കുള്ളവർ ആയിരിക്കുന്നതുപോലെതന്നെ എഫ്രയീമും മനശ്ശെയും എനിക്കുള്ളവരായിരിക്കുന്നതാണ്. ");
INSERT INTO malc_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","അവർക്കുശേഷം നിനക്കു ജനിച്ച കുഞ്ഞുങ്ങൾ നിനക്കുള്ളവരായിരിക്കും; അവർ അവകാശമാക്കുന്ന ദേശത്ത് തങ്ങളുടെ സഹോദരന്മാരുടെ പേരുകളോടുചേർത്ത് അവരെ കണക്കാക്കും. ");
INSERT INTO malc_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ഞാൻ പദ്ദനിൽനിന്നു മടങ്ങുമ്പോൾ, കനാനിൽനിന്നു ഞങ്ങൾ യാത്ര തുടർന്നുകൊണ്ടിരിക്കെത്തന്നെ, എഫ്രാത്തിൽനിന്ന് അൽപ്പം അകലെ വഴിയിൽവെച്ച്, റാഹേൽ മരിച്ചു. ഞാൻ അവളെ എഫ്രാത്തിലേക്കുള്ള വഴിയുടെ അരികെ (അതായത്, ബേത്ലഹേമിൽ) അടക്കംചെയ്തു.” ");
INSERT INTO malc_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","യോസേഫിന്റെ പുത്രന്മാരെ കണ്ടിട്ട് ഇസ്രായേൽ, “ഇവർ ആരാകുന്നു?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","“ദൈവം എനിക്ക് ഇവിടെവെച്ചു നൽകിയ പുത്രന്മാരാണ് ഇവർ,” യോസേഫ് പിതാവിനോടു പറഞ്ഞു. അപ്പോൾ ഇസ്രായേൽ, “അവരെ എന്റെ അടുക്കൽ കൊണ്ടുവരിക. ഞാൻ അവരെ അനുഗ്രഹിക്കട്ടെ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","വാർധക്യംനിമിത്തം ഇസ്രായേലിന്റെ കാഴ്ച ക്ഷയിച്ചുകൊണ്ടിരുന്നു; അദ്ദേഹത്തിനു കാഴ്ച തീരെയില്ലാതായി. അതുകൊണ്ട് യോസേഫ് തന്റെ പുത്രന്മാരെ അദ്ദേഹത്തിന്റെ തൊട്ടടുത്തു കൊണ്ടുവന്നു; അദ്ദേഹത്തിന്റെ പിതാവ് അവരെ ചുംബിക്കുകയും ആലിംഗനംചെയ്യുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ഇസ്രായേൽ യോസേഫിനോട്, “നിന്റെ മുഖം വീണ്ടും കാണുമെന്നു ഞാൻ ഒരിക്കലും പ്രതീക്ഷിച്ചില്ല; ഇപ്പോൾ ഇതാ, നിന്റെ മക്കളെയും കാണാൻ ദൈവം എന്നെ അനുവദിച്ചിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","പിന്നെ യോസേഫ് അവരെ അദ്ദേഹത്തിന്റെ മടിയിൽനിന്ന് നീക്കി സാഷ്ടാംഗം നമസ്കരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","യോസേഫ് അവരെ ഇരുവരെയും പിടിച്ച്, എഫ്രയീമിനെ തന്റെ വലത്തുവശത്താക്കി ഇസ്രായേലിന്റെ ഇടത്തുകൈയുടെ നേർക്കും മനശ്ശെയെ തന്റെ ഇടത്തുവശത്താക്കി ഇസ്രായേലിന്റെ വലത്തുകൈയുടെ നേർക്കുമായി അദ്ദേഹത്തോടു ചേർത്തുനിർത്തി. ");
INSERT INTO malc_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","എഫ്രയീം ഇളയവനും മനശ്ശെ ആദ്യജാതനും ആയിരുന്നെങ്കിലും ഇസ്രായേൽ തന്റെ കൈകൾ പിണച്ച് വലങ്കൈ എഫ്രയീമിന്റെ തലയിലും ഇടങ്കൈ മനശ്ശെയുടെ തലയിലും വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ഇതിനുശേഷം അദ്ദേഹം യോസേഫിനെ അനുഗ്രഹിച്ചു പറഞ്ഞു, “എന്റെ പിതാക്കന്മാരായ അബ്രാഹാമും യിസ്ഹാക്കും ആരാധിച്ചുപോന്ന ദൈവം, ജനിച്ചനാൾമുതൽ ഇന്നുവരെയും എന്നെ കാത്തു പരിപാലിച്ച ദൈവം, ");
INSERT INTO malc_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","സർവദോഷത്തിൽനിന്നും എന്നെ വിടുവിച്ച ദൂതൻ ഈ ബാലന്മാരെ അനുഗ്രഹിക്കുമാറാകട്ടെ. ഇവർ എന്റെ പേരിലും എന്റെ പിതാക്കന്മാരായ അബ്രാഹാമിന്റെയും യിസ്ഹാക്കിന്റെയും പേരിലും അറിയപ്പെടട്ടെ, ഇവർ ഭൂമുഖത്ത് അത്യധികമായി വർധിച്ചുവരട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","പിതാവു തന്റെ വലങ്കൈ എഫ്രയീമിന്റെ തലയിൽ വെക്കുന്നതു കണ്ടിട്ടു യോസേഫിന് അപ്രീതിയുണ്ടായി; അതുകൊണ്ട് അദ്ദേഹം പിതാവിന്റെ കൈ എഫ്രയീമിന്റെ തലയിൽനിന്നു മനശ്ശെയുടെ തലയിലേക്കു മാറ്റിവെക്കാൻ ആ കൈയിൽ പിടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","യോസേഫ് അദ്ദേഹത്തോട്, “അങ്ങനെയല്ല, അപ്പാ, ഇവനാണ് ആദ്യജാതൻ; വലങ്കൈ ഇവന്റെ തലയിൽ വെക്കണം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","എന്നാൽ അദ്ദേഹത്തിന്റെ പിതാവ് അതു നിരസിച്ചുകൊണ്ട്, “എനിക്കറിയാം, മകനേ, എനിക്കറിയാം. അവനും വലിയൊരു ജനമായിത്തീരും, ഇവനും മഹാനായിത്തീരും. എങ്കിലും അവന്റെ അനുജൻ അവനെക്കാൾ ശ്രേഷ്ഠനാകും, അവന്റെ പിൻഗാമികൾ ജനതകളുടെ ഒരു സമൂഹമായിത്തീരും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","അന്ന് അദ്ദേഹം അവരെ അനുഗ്രഹിച്ചുകൊണ്ടു പറഞ്ഞു: “ദൈവം നിന്നെ എഫ്രയീമിനെയും മനശ്ശെയെയുംപോലെ ആക്കട്ടെ എന്ന് ഇസ്രായേല്യർ നിന്റെ നാമത്തിൽ ആശീർവാദം ചൊല്ലും.” ഇങ്ങനെ അദ്ദേഹം എഫ്രയീമിനെ മനശ്ശെക്കു മുന്നിലാക്കി. ");
INSERT INTO malc_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","തുടർന്ന് ഇസ്രായേൽ യോസേഫിനോട്, “ഞാൻ മരിക്കാറായിരിക്കുന്നു, എന്നാൽ ദൈവം നിങ്ങളോടുകൂടെയിരിക്കുകയും നിങ്ങളെ നിങ്ങളുടെ പിതാക്കന്മാരുടെ ദേശത്തേക്കു മടക്കിക്കൊണ്ടുപോകുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","നിന്റെ സഹോദരന്മാരെക്കാൾ കൂടുതലായി, എന്റെ വാളും വില്ലുംകൊണ്ടു ഞാൻ അമോര്യരിൽനിന്ന് പിടിച്ചെടുത്ത മലഞ്ചെരിവു ഞാൻ നിനക്കു തരുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ഇതിനുശേഷം യാക്കോബ് തന്റെ പുത്രന്മാരെ വിളിച്ച് അവരോടു പറഞ്ഞത്: “എന്റെ ചുറ്റും കൂടിനിൽക്കുക; ഭാവിയിൽ നിങ്ങൾക്ക് എന്തു സംഭവിക്കുമെന്നു ഞാൻ പറഞ്ഞുതരാം. ");
INSERT INTO malc_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“യാക്കോബിന്റെ പുത്രന്മാരേ, കൂടിവന്നു ശ്രദ്ധിക്കുക; നിങ്ങളുടെ പിതാവായ ഇസ്രായേലിന്റെ വാക്കുകൾ ശ്രദ്ധിച്ചുകേൾക്കുക. ");
INSERT INTO malc_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“രൂബേൻ എന്റെ ശക്തിയും എന്റെ പൗരുഷത്തിന്റെ ആദ്യഫലവും ആഭിജാത്യത്തിന്റെ വൈശിഷ്ട്യവും വീര്യത്തിന്റെ മഹിമയുംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","വെള്ളംപോലെ ഇളകിമറിയുന്നവനേ, നീ ശ്രേഷ്ഠനാകുകയില്ല. നിന്റെ പിതാവിന്റെ കിടക്കമേൽ നീ കയറി, എന്റെ ശയ്യയെ നീ അശുദ്ധമാക്കിയല്ലോ. ");
INSERT INTO malc_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“ശിമെയോനും ലേവിയും സഹോദരങ്ങൾ; അവരുടെ വാളുകൾ ഹിംസയുടെ ആയുധങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","എന്റെ ഉള്ളം അവരുടെ ആലോചനയിൽ കൂടാതിരിക്കട്ടെ. എന്റെ ഹൃദയം അവരുടെ കൂട്ടത്തിൽ ചേരാതിരിക്കട്ടെ. തങ്ങളുടെ ക്രോധത്തിൽ അവർ മനുഷ്യരെ കൊന്നു; ക്രൂരതയിൽ അവർ കാളകളുടെ കുതിഞരമ്പു വെട്ടി. ");
INSERT INTO malc_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","അവരുടെ ഉഗ്രകോപവും കഠിനരോഷവും ശപിക്കപ്പെടട്ടെ. അതെത്ര ഉഗ്രം! അവരുടെ ക്രോധം, അതെത്ര ക്രൂരം! അവരെ ഞാൻ യാക്കോബിൽ വിഭജിക്കുകയും ഇസ്രായേലിൽ ചിതറിക്കുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“യെഹൂദയേ, നിന്റെ സഹോദരന്മാർ നിന്നെ പുകഴ്ത്തും; നിന്റെ കൈ നിന്റെ ശത്രുക്കളുടെ കഴുത്തിന്മേൽ ഇരിക്കും; നിന്റെ പിതാവിന്റെ പുത്രന്മാർ നിന്നെ നമിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","യെഹൂദാ, ഒരു സിംഹക്കുട്ടി; എന്റെ മകനേ, നീ ഇരയുടെ അടുക്കൽനിന്ന് മടങ്ങുന്നു, സിംഹത്തെപ്പോലെ അവൻ കുനിഞ്ഞു പതുങ്ങിക്കിടക്കുന്നു. സിംഹിയെപ്പോലെ കിടക്കുന്ന അവനെ ഉണർത്താൻ ആരാണു മുതിരുക? ");
INSERT INTO malc_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","അവകാശി വരികയും ജനതകൾ അവിടത്തെ ആജ്ഞാനുവർത്തികൾ ആയിത്തീരുകയും ചെയ്യുന്നതുവരെ ചെങ്കോൽ യെഹൂദയിൽനിന്നും അധികാരദണ്ഡ് അവന്റെ പാദങ്ങൾക്കിടയിൽനിന്നും മാറിപ്പോകുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","അവൻ മുന്തിരിവള്ളിയിൽ തന്റെ കഴുതയെയും വിശിഷ്ടമുന്തിരിവള്ളിയിൽ തന്റെ കഴുതക്കുട്ടിയെയും കെട്ടും. അവൻ തന്റെ വസ്ത്രങ്ങൾ വീഞ്ഞിലും അങ്കികൾ ദ്രാക്ഷാരസത്തിലും അലക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","അവന്റെ കണ്ണുകൾ വീഞ്ഞിനെക്കാൾ കറുത്തതും പല്ലുകൾ പാലിനെക്കാൾ വെളുത്തതുമത്രേ. ");
INSERT INTO malc_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“സെബൂലൂൻ കടൽക്കരയിൽ പാർക്കും; അവൻ കപ്പലുകൾക്ക് ഒരു തുറമുഖം; അവന്റെ അതിരുകൾ സീദോൻവരെ വ്യാപിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“യിസ്സാഖാർ കുരുത്തുറ്റ കഴുത; അവൻ തീക്കുണ്ഡങ്ങൾക്കരികെ കിടക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","വിശ്രമസ്ഥലം നല്ലതെന്നും ദേശം ആനന്ദപ്രദമെന്നും അവൻ കണ്ടു; അവൻ തന്റെ തോൾ ചുമടിനു കുനിച്ചു, കഠിനവേലയ്ക്ക് തന്നെത്താൻ ഏൽപ്പിച്ചുകൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ഇസ്രായേൽഗോത്രങ്ങളിൽ ഒന്നെന്ന നിലയിൽ ദാൻ സ്വജനത്തിനു ന്യായപാലനംചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ദാൻ വഴിയരികിൽ സർപ്പവും പാതയിൽ അണലിയുംതന്നെ; അതു കുതിരയുടെ കുതികാലിൽ കടിക്കും; അങ്ങനെ കുതിരമേൽ സവാരിചെയ്യുന്നവൻ മലർന്നുവീഴും. ");
INSERT INTO malc_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“യഹോവേ, ഞാൻ അവിടത്തെ രക്ഷയ്ക്കായി കാത്തിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“ഗാദിനെ കൊള്ളസംഘം ആക്രമിക്കും; എന്നാൽ അവൻ അവരെ, അവരുടെ കുതികാലുകളിൽത്തന്നെ ആക്രമിക്കും. ");
INSERT INTO malc_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“ആശേരിന്റെ ആഹാരം പുഷ്ടിയുള്ളത്; രാജകീയ സ്വാദുഭോജ്യങ്ങൾ അവൻ പ്രദാനംചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“നഫ്താലി, മനോഹരമായ മാൻകിടാങ്ങളെ പ്രസവിക്കുന്ന സ്വതന്ത്രയായ മാൻപേട. ");
INSERT INTO malc_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“യോസേഫ് ഫലപൂർണമായ വൃക്ഷം; നീരുറവയ്ക്കരികെ നിൽക്കുന്ന ഫലസമൃദ്ധമായ വൃക്ഷംതന്നെ. അതിന്റെ ശാഖകൾ മതിലിന്മേൽ പടരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","വില്ലാളികൾ അവനെ വല്ലാതെ വിഷമിപ്പിച്ചു; അവർ എയ്ത് അവനെ ആക്രമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","അവന്റെ വില്ല് സ്ഥിരതയോടെ നിന്നു; അവന്റെ ഭുജങ്ങൾ ബലവത്തായി നിലനിന്നു; യാക്കോബിന്റെ വല്ലഭന്റെ കരത്താൽ, ഇസ്രായേലിന്റെ പാറയായ ഇടയന്റെ നാമത്താൽത്തന്നെ. ");
INSERT INTO malc_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","നിന്റെ പിതാവിന്റെ ദൈവം നിന്നെ സഹായിക്കും; സർവശക്തൻ നിന്നെ അനുഗ്രഹിക്കും. മീതേ ആകാശത്തിന്റെ അനുഗ്രഹങ്ങളാലും ആഴത്തിൽ കിടക്കുന്ന ആഴിയുടെ അനുഗ്രഹങ്ങളാലും, മുലയുടെയും ഗർഭത്തിന്റെയും അനുഗ്രഹങ്ങളാലുംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","നിന്റെ പിതാവിന്റെ അനുഗ്രഹങ്ങൾ പുരാതന പർവതങ്ങളുടെ അനുഗ്രഹങ്ങളെക്കാളും ശാശ്വതഗിരികളുടെ സമ്പത്തിനെക്കാളും വിശിഷ്ടമത്രേ. ഇവയെല്ലാം യോസേഫിന്റെ ശിരസ്സിൽ, തന്റെ സഹോദരന്മാരുടെ ഇടയിൽ പ്രഭുവായവന്റെ നെറ്റിയിൽ ആവസിക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“ബെന്യാമീൻ കടിച്ചുകീറുന്ന ചെന്നായ്; അതിരാവിലെ അവൻ ഇരയെ വിഴുങ്ങുന്നു; സന്ധ്യാസമയത്ത് അവൻ കൊള്ള പങ്കിടുന്നു.” ");
INSERT INTO malc_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ഇസ്രായേലിന്റെ പന്ത്രണ്ടു ഗോത്രങ്ങളും ഇവയാണ്; ഇങ്ങനെയായിരുന്നു ഓരോരുത്തനും അനുയോജ്യമായ അനുഗ്രഹം നൽകിക്കൊണ്ട് അവരെ അനുഗ്രഹിച്ചപ്പോൾ അവരുടെ പിതാവ് അവരോടു പറഞ്ഞത്. ");
INSERT INTO malc_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","പിന്നെ യാക്കോബ് അവർക്ക് ഈ നിർദേശങ്ങൾ നൽകി: “ഞാൻ എന്റെ ജനത്തോടു ചേരാൻ പോകുന്നു. കനാനിലെ മമ്രേയ്ക്കു സമീപമുള്ളതും ഹിത്യനായ എഫ്രോന്റെ പക്കൽനിന്നും അബ്രാഹാം വയലോടുകൂടെ ശ്മശാനസ്ഥലമായി വിലയ്ക്കു വാങ്ങിയതുമായ മക്പേലാനിലത്തിലെ ഗുഹയിൽ, ഹിത്യനായ എഫ്രോന്റെ നിലത്തിലെ ഗുഹയിൽത്തന്നെ—എന്റെ പിതാക്കന്മാരോടൊപ്പം—എന്നെ നിങ്ങൾ അടക്കംചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","അവിടെയാണ് അബ്രാഹാമിനെയും അദ്ദേഹത്തിന്റെ ഭാര്യയായ സാറയെയും അടക്കിയത്; അവിടെയാണ് യിസ്ഹാക്കിനെയും അദ്ദേഹത്തിന്റെ ഭാര്യയായ റിബേക്കയെയും അടക്കിയത്; ഞാൻ ലേയയെ അടക്കിയതും അവിടെത്തന്നെ. ");
INSERT INTO malc_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ആ വയലും അതിലെ ഗുഹയും ഹിത്യരിൽനിന്ന് വിലയ്ക്കു വാങ്ങിയതാണ്.” ");
INSERT INTO malc_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","യാക്കോബ് തന്റെ പുത്രന്മാർക്ക് നിർദേശങ്ങൾ നൽകിക്കഴിഞ്ഞപ്പോൾ കാലുകൾ കിടക്കയിൽ കയറ്റിവെച്ചിട്ട് അന്ത്യശ്വാസം വലിച്ചു; തന്റെ ജനത്തോടു ചേർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","യോസേഫ് തന്റെ പിതാവിന്റെമേൽ വീണ് അദ്ദേഹത്തെച്ചൊല്ലി കരഞ്ഞ് അദ്ദേഹത്തെ ചുംബിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","അതിനുശേഷം യോസേഫ് തനിക്കു സേവനം അനുഷ്ഠിക്കുന്ന വൈദ്യന്മാരോട്, തന്റെ പിതാവായ ഇസ്രായേലിനെ സുഗന്ധലേപനംചെയ്യാൻ കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","സുഗന്ധലേപനത്തിനുവേണ്ടുന്ന നാൽപ്പതുദിവസം മുഴുവൻ എടുത്ത് വൈദ്യന്മാർ അദ്ദേഹത്തെ സുഗന്ധലേപനംചെയ്തു. ഈജിപ്റ്റുകാർ അദ്ദേഹത്തിനുവേണ്ടി എഴുപതുദിവസം വിലപിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","വിലാപദിനങ്ങൾ സമാപിച്ചപ്പോൾ യോസേഫ് ഫറവോന്റെ രാജസഭയോട്: “നിങ്ങൾക്ക് എന്നോടു പ്രീതിയുണ്ടെങ്കിൽ എനിക്കുവേണ്ടി ഫറവോനോടു സംസാരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ഞാൻ മരിക്കാൻ പോകുന്നു, കനാൻദേശത്തു ഞാൻ എനിക്കായിത്തന്നെ കുഴിച്ച കല്ലറയിൽ എന്നെ അടക്കംചെയ്യണം എന്ന് ‘എന്റെ പിതാവ് എന്നെക്കൊണ്ട് ശപഥംചെയ്യിച്ചിട്ടുണ്ട്,’ ഇപ്പോൾ ഞാൻ പോയി എന്റെ പിതാവിനെ അടക്കം ചെയ്തിട്ടു മടങ്ങിവരാം എന്ന് അദ്ദേഹത്തോടു പറയണം.” ");
INSERT INTO malc_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","അതിനു ഫറവോൻ, “നിന്റെ പിതാവു നിന്നെക്കൊണ്ടു ശപഥംചെയ്യിച്ചിട്ടുള്ളതുപോലെ, പോയി പിതാവിനെ അടക്കംചെയ്യുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","8","അങ്ങനെ, യോസേഫ് പോയി പിതാവിനെ അടക്കംചെയ്തു. യോസേഫിന്റെ ഭവനത്തിലെ അംഗങ്ങൾക്കും അദ്ദേഹത്തിന്റെ സഹോദരന്മാർക്കും അദ്ദേഹത്തിന്റെ പിതാവിന്റെ ഭവനത്തിലുള്ളവർക്കുംപുറമേ ഫറവോന്റെ ഉദ്യോഗസ്ഥന്മാർ എല്ലാവരും അദ്ദേഹത്തിന്റെ രാജസദസ്സിലെ ഉന്നതാധികാരികളും ഈജിപ്റ്റിലെ സകലമേലുദ്യോഗസ്ഥന്മാരും അദ്ദേഹത്തെ അനുഗമിച്ചു. അവരുടെ കുഞ്ഞുങ്ങളും ആട്ടിൻപറ്റങ്ങളും കന്നുകാലികളുംമാത്രമേ ഗോശെനിൽ ശേഷിച്ചുള്ളൂ. ");
INSERT INTO malc_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","രഥങ്ങളും കുതിരക്കാരും അദ്ദേഹത്തോടുകൂടെ പോയി. അതൊരു വലിയ സമൂഹമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","അവർ യോർദാനു സമീപമുള്ള ആതാദ് മെതിക്കളത്തിൽ എത്തിയപ്പോൾ ഉച്ചത്തിൽ വളരെ സങ്കടത്തോടെ വിലപിച്ചു; അവിടെ യോസേഫ് തന്റെ പിതാവിനുവേണ്ടി ഏഴുദിവസത്തെ വിലാപകാലം ആചരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","അവിടെ താമസിച്ചിരുന്ന കനാന്യർ ആതാദ് മെതിക്കളത്തിലെ വിലാപം കണ്ടിട്ട്, “ഇത് ഈജിപ്റ്റുകാരുടെ മഹാവിലാപം” എന്നു പറഞ്ഞു. അതുകൊണ്ട് യോർദാന്നരികെയുള്ള ആ സ്ഥലത്തിന് ആബേൽ-മിസ്രായിം എന്നു പേരുണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","യാക്കോബ് തങ്ങളോടു കൽപ്പിച്ചിരുന്നതുപോലെതന്നെ അദ്ദേഹത്തിന്റെ പുത്രന്മാർ പ്രവർത്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","അവർ അദ്ദേഹത്തെ കനാൻ ദേശത്തേക്ക് എടുത്തുകൊണ്ടുപോയി, മമ്രേയ്ക്കു സമീപം അബ്രാഹാം ഹിത്യനായ എഫ്രോന്റെ പക്കൽനിന്ന് വയലോടുകൂടെ ശ്മശാനസ്ഥലമായി വാങ്ങിയ മക്പേലാനിലത്തിലെ ഗുഹയിൽ അടക്കംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","പിതാവിനെ അടക്കിയതിനുശേഷം യോസേഫ് തന്റെ സഹോദരന്മാരോടും പിതാവിന്റെ ശവമടക്കത്തിനു തന്നോടൊപ്പം പോയിരുന്ന മറ്റെല്ലാവരോടുംകൂടെ ഈജിപ്റ്റിലേക്കു മടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","യോസേഫിന്റെ സഹോദരന്മാർ, തങ്ങളുടെ പിതാവു മരിച്ചുപോയി എന്നു കണ്ടിട്ട്, “യോസേഫ് നമ്മോടു വൈരം വെച്ചുകൊണ്ട്, നാം അദ്ദേഹത്തോടു ചെയ്തിട്ടുള്ള കുറ്റങ്ങൾക്കെല്ലാം പകരംവീട്ടിയാൽ എന്താകും?” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","അതുകൊണ്ട് അവർ യോസേഫിന് ഒരു സന്ദേശം അയച്ചു: “ ‘നിന്റെ സഹോദരന്മാർ നിന്നോടു വളരെ ദോഷമായി പെരുമാറി; അവർ ചെയ്ത പാപങ്ങളും കുറ്റകൃത്യങ്ങളും ക്ഷമിക്കണമെന്നു ഞാൻ നിന്നോട് ആവശ്യപ്പെടുന്നു’ എന്നു നിങ്ങൾ യോസേഫിനോടു പറയണമെന്ന് നിന്റെ പിതാവു മരിക്കുന്നതിനുമുമ്പ് ഞങ്ങളോടു നിർദേശിച്ചിട്ടുണ്ട്. നിന്റെ പിതാവിന്റെ ദൈവത്തിന്റെ ദാസന്മാരുടെ പാപങ്ങൾ ദയവായി ക്ഷമിക്കണം.” അവരുടെ സന്ദേശം ലഭിച്ചപ്പോൾ യോസേഫ് കരഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ഇതിനുശേഷം യോസേഫിന്റെ സഹോദരന്മാർവന്ന് അദ്ദേഹത്തിന്റെ മുമ്പാകെ വീണുകിടന്ന്, “ഞങ്ങൾ അങ്ങയുടെ അടിമകൾ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","എന്നാൽ യോസേഫ് അവരോട്: “നിങ്ങൾ ഭയപ്പെടരുത്. ഞാൻ ദൈവത്തിന്റെ സ്ഥാനത്ത് ഇരിക്കുന്നോ? ");
INSERT INTO malc_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","നിങ്ങൾ എനിക്കു ദോഷം ചെയ്യാൻ ശ്രമിച്ചു; ദൈവമോ, ഇപ്പോൾ ചെയ്തുകൊണ്ടിരിക്കുന്നതുപോലെ, അതിനെ ബഹുജനത്തിന്റെ ജീവരക്ഷയ്ക്കായി ഗുണകരമാക്കിത്തീർത്തു. ");
INSERT INTO malc_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ആകയാൽ നിങ്ങൾ ഭയപ്പെടേണ്ട; ഞാൻ നിങ്ങൾക്കും നിങ്ങളുടെ കുഞ്ഞുങ്ങൾക്കും വേണ്ടുന്നതു നൽകും” എന്നു പറഞ്ഞു. അദ്ദേഹം അവർക്ക് ഉറപ്പു നൽകിക്കൊണ്ട് ആർദ്രതയോടെ അവരോടു സംസാരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","യോസേഫ് പിതാവിന്റെ കുടുംബത്തോടുകൂടെ ഈജിപ്റ്റിൽ താമസിച്ചു. അദ്ദേഹം നൂറ്റിപ്പത്തുവർഷം ജീവിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","എഫ്രയീമിന്റെ മൂന്നാംതലമുറയിലെ മക്കളെയും അദ്ദേഹം കണ്ടു. മനശ്ശെയുടെ പുത്രനായ മാഖീരിന്റെ കുഞ്ഞുങ്ങളും യോസേഫിന്റെ മടിയിൽ വളർന്നു. ");
INSERT INTO malc_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","പിന്നെ യോസേഫ് തന്റെ സഹോദരന്മാരോട്, “ഞാൻ മരിക്കാൻ തുടങ്ങുന്നു. എന്നാൽ ദൈവം നിശ്ചയമായും നിങ്ങളെ സന്ദർശിക്കുകയും നിങ്ങളെ ഈ ദേശത്തുനിന്നു പുറപ്പെടുവിച്ച് അബ്രാഹാമിനോടും യിസ്ഹാക്കിനോടും യാക്കോബിനോടും ശപഥംചെയ്ത ദേശത്തേക്കു കൊണ്ടുപോകുകയും ചെയ്യും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","“ദൈവം നിങ്ങളെ സന്ദർശിക്കുമ്പോൾ നിങ്ങൾ എന്റെ അസ്ഥികൾ ഈ സ്ഥലത്തുനിന്ന് എടുത്തുകൊണ്ടുപോകണം,” എന്നു പറഞ്ഞ് യോസേഫ് ഇസ്രായേലിന്റെ പുത്രന്മാരെക്കൊണ്ട് ശപഥംചെയ്യിച്ചു. ");
INSERT INTO malc_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","യോസേഫ് നൂറ്റിപ്പത്തു വയസ്സുള്ളവനായി മരിച്ചു. അവർ അദ്ദേഹത്തെ സുഗന്ധലേപനംചെയ്ത് ഈജിപ്റ്റിൽ ഒരു ശവപ്പെട്ടിയിൽ വെച്ചു.");
INSERT INTO malc_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","യാക്കോബിനോടുകൂടെ, കുടുംബസമേതം ഈജിപ്റ്റിൽ വന്ന ഇസ്രായേൽമക്കളുടെ പേരുകൾ ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","രൂബേൻ, ശിമെയോൻ, ലേവി, യെഹൂദാ, ");
INSERT INTO malc_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","യിസ്സാഖാർ, സെബൂലൂൻ, ബെന്യാമീൻ, ");
INSERT INTO malc_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ദാൻ, നഫ്താലി, ഗാദ്, ആശേർ. ");
INSERT INTO malc_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","യാക്കോബിൽനിന്നു ജനിച്ചവർ ആകെ എഴുപതുപേരായിരുന്നു; യോസേഫ് മുമ്പേതന്നെ ഈജിപ്റ്റിൽ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","വർഷങ്ങൾ കടന്നുപോയി, യോസേഫും സഹോദരന്മാരും ആ തലമുറ മുഴുവനും മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","എന്നാൽ അവരുടെ പിൻഗാമികളായ ഇസ്രായേല്യർ, സന്താനസമൃദ്ധിയുള്ളവരായി അത്യധികം വർധിച്ചു; അവർ പ്രബലപ്പെട്ടു. ദേശം അവരെക്കൊണ്ടു നിറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","കാലങ്ങൾ കടന്നുപോയി, യോസേഫിനെ അറിയാത്ത മറ്റൊരു രാജാവ് ഈജിപ്റ്റിന്റെ ഭരണാധിപനായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","അദ്ദേഹം തന്റെ ജനങ്ങളോട്, “ഇതാ, ഇസ്രായേല്യർ നമ്മെക്കാൾ എണ്ണത്തിൽ പെരുകി പ്രബലരായിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","നാം അവരോടു തന്ത്രപൂർവം പെരുമാറണം; അല്ലാത്തപക്ഷം അവർ ഇതിലും പെരുകുകയും ഒരു യുദ്ധം പൊട്ടിപ്പുറപ്പെടുമ്പോൾ ശത്രുക്കളോടു ചേർന്നു നമുക്കെതിരേ യുദ്ധംചെയ്യുകയും രാജ്യം വിട്ടുപോകുകയും ചെയ്യും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","അതനുസരിച്ച്, ഇസ്രായേല്യരെക്കൊണ്ടു കഠിനമായി പണിയെടുപ്പിക്കാനും അവരെ പീഡിപ്പിക്കാനുമായി ഈജിപ്റ്റുകാർ അവരുടെമേൽ മേൽനോട്ടക്കാരെ നിയമിച്ചു; അവർ ഫറവോനുവേണ്ടി പീഥോം, രമെസേസ് എന്നീ സംഭരണനഗരങ്ങൾ ഇസ്രായേല്യരെക്കൊണ്ട് പണിയിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","എന്നാൽ പീഡനം വർധിക്കുന്നതനുസരിച്ച് അവരുടെ എണ്ണം വർധിക്കുകയും അവർ എല്ലായിടത്തും പരക്കുകയും ചെയ്തു. അതുകൊണ്ട് ഈജിപ്റ്റുകാർ ഇസ്രായേല്യരെ ഭയപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ഈജിപ്റ്റുകാർ ക്രൂരമായി അവരെക്കൊണ്ടു പണിയെടുപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ഇഷ്ടികയും കളിമണ്ണുംകൊണ്ടുള്ള വേലയും വയലിലെ എല്ലാത്തരം ജോലികളും കഠിനാധ്വാനവുംകൊണ്ട് ഈജിപ്റ്റുകാർ അവരുടെ ജീവിതം കയ്‌പുള്ളതാക്കി. അവരുടെ കഠിനജോലികളിലെല്ലാം ഈജിപ്റ്റുകാർ അവരോടു ക്രൂരമായി പെരുമാറി. ");
INSERT INTO malc_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ഈജിപ്റ്റുരാജാവ് എബ്രായസൂതികർമിണികളായ ശിപ്രാ, പൂവാ എന്നിവരോട്, ");
INSERT INTO malc_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“നിങ്ങൾ എബ്രായസ്ത്രീകളെ പ്രസവവേളയിൽ പരിചരിക്കയും അവരെ പ്രസവക്കിടക്കയിൽ നിരീക്ഷിക്കുകയും ചെയ്യുമ്പോൾ കുട്ടി ആണാണെങ്കിൽ അതിനെ കൊന്നുകളയുകയും പെണ്ണാണെങ്കിൽ ജീവിക്കാൻ അനുവദിക്കുകയും ചെയ്യണം” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ആ സൂതികർമിണികൾ ദൈവത്തെ ഭയപ്പെട്ടിരുന്നതുകൊണ്ട്, ഈജിപ്റ്റുരാജാവ് തങ്ങളോടു കൽപ്പിച്ചിരുന്നതുപോലെ പ്രവർത്തിച്ചില്ല; ആൺകുട്ടികളെ അവർ ജീവനോടെ രക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ഇതറിഞ്ഞ ഈജിപ്റ്റുരാജാവ് അവരെ ആളയച്ചുവരുത്തി അവരോട്, “നിങ്ങൾ ഇങ്ങനെ ചെയ്തതെന്ത്? ആൺകുട്ടികളുടെ ജീവൻ രക്ഷിക്കുന്നത് എന്തിന്?” എന്ന് ആരാഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","സൂതികർമിണികൾ ഫറവോനോട്, “എബ്രായസ്ത്രീകൾ ഈജിപ്റ്റിലെ സ്ത്രീകളെപ്പോലെയല്ല; അവർ ചുറുചുറുക്കുള്ളവരാണ്; സൂതികർമിണികൾ എത്തുന്നതിനുമുമ്പുതന്നെ അവർ പ്രസവിച്ചുകഴിഞ്ഞിരിക്കും” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","അതുകൊണ്ടു ദൈവം ആ സൂതികർമിണികളോടു കരുണ കാണിച്ചു; ഇസ്രായേൽജനം പെരുകുകയും എണ്ണത്തിൽ പ്രബലരായിത്തീരുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","സൂതികർമിണികൾ ദൈവത്തെ ഭയപ്പെട്ടതുകൊണ്ട് അവിടന്ന് അവർക്കും കുടുംബവർധന നൽകി. ");
INSERT INTO malc_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","പിന്നെ ഫറവോൻ തന്റെ സകലജനങ്ങളോടും, “എബ്രായർക്കു ജനിക്കുന്ന എല്ലാ ആൺകുട്ടികളെയും നിങ്ങൾ നൈൽനദിയിൽ എറിഞ്ഞുകളയണം; പെൺകുട്ടികളെ ജീവിക്കാൻ അനുവദിക്കുക” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ഈ സമയം ലേവിഗോത്രത്തിൽപ്പെട്ട ഒരു പുരുഷൻ ഒരു ലേവ്യസ്ത്രീയെ വിവാഹംചെയ്തു; ");
INSERT INTO malc_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","അവൾ ഗർഭംധരിച്ച് ഒരു മകനെ പ്രസവിച്ചു. അഴകുള്ള ഒരു കുട്ടിയാണ് എന്നു കണ്ടിട്ട് അവൾ അവനെ മൂന്നുമാസം ഒളിപ്പിച്ചുവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","എന്നാൽ അവനെ ഒളിപ്പിച്ചുവെക്കാൻ ഒട്ടും കഴിയാതായപ്പോൾ അവൾ ഒരു ഞാങ്ങണപ്പെട്ടകം വാങ്ങി അതിന്മേൽ പശയും കീലും തേച്ച്, കുട്ടിയെ അതിൽ കിടത്തി, നൈൽനദീതീരത്തു ഞാങ്ങണകൾക്കിടയിൽ വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","അവന് എന്തു സംഭവിക്കുമെന്നു നോക്കിക്കൊണ്ട്, ശിശുവിന്റെ സഹോദരി കുറച്ചകലെ മാറിനിന്നു. ");
INSERT INTO malc_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ഉടനെതന്നെ ഫറവോന്റെ പുത്രി നദിയിൽ കുളിക്കാൻ വന്നു. അവളുടെ പരിചാരികമാർ നദിക്കരയിലൂടെ നടക്കുകയായിരുന്നു. അവൾ ആ പെട്ടകം ഞാങ്ങണകൾക്കിടയിൽ കണ്ടിട്ട് അതെടുക്കാൻ തന്റെ ദാസിയെ അയച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","അവൾ അതു തുറന്നപ്പോൾ കുട്ടിയെ കണ്ടു. കുട്ടി കരയുകയായിരുന്നു. അവൾക്ക് അവനോടു സഹതാപം തോന്നി. “ഇത് എബ്രായശിശുക്കളിൽ ഒന്നാണ്,” അവൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","അപ്പോൾ ആ ശിശുവിന്റെ സഹോദരി ഫറവോന്റെ പുത്രിയോട്, “നിങ്ങൾക്കുവേണ്ടി ഈ കുഞ്ഞിനെ പരിചരിക്കാൻ ഞാൻ ചെന്ന് ഒരു എബ്രായസ്ത്രീയെ കൊണ്ടുവരട്ടെയോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“ഉവ്വ്, പൊയ്ക്കൊൾക,” ഫറവോന്റെ പുത്രി മറുപടി പറഞ്ഞു. അതനുസരിച്ച് പെൺകുട്ടി ചെന്ന്, അവന്റെ അമ്മയെ കൂട്ടിക്കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ഫറവോന്റെ പുത്രി അവളോട്, “എനിക്കുവേണ്ടി ഈ കുഞ്ഞിനെ കൊണ്ടുപോയി മുലയൂട്ടിവളർത്തുക; നിന്റെ സേവനത്തിനു ഞാൻ പ്രതിഫലം തരാം” എന്നു പറഞ്ഞു. അങ്ങനെ ആ സ്ത്രീ പൈതലിനെ കൊണ്ടുപോയി വളർത്തി. ");
INSERT INTO malc_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","കുട്ടി വളർന്നപ്പോൾ, അവൾ അവനെ ഫറവോന്റെ മകളുടെ അടുക്കൽ കൊണ്ടുവന്നു; അവൻ രാജകുമാരിയുടെ മകനായിത്തീർന്നു. “ഞാൻ ഇവനെ വെള്ളത്തിൽനിന്ന് എടുത്തു,” എന്നു പറഞ്ഞ് ആ രാജകുമാരി അവന് മോശ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ചില വർഷങ്ങൾകഴിഞ്ഞ്—മോശ മുതിർന്നതിനുശേഷം—ഒരിക്കൽ തന്റെ സഹോദരന്മാരുടെ അടുക്കൽ ചെന്ന് അവരുടെ കഠിനാധ്വാനം നേരിട്ടുകണ്ടു; സ്വജനത്തിൽപ്പെട്ട ഒരു എബ്രായനെ ഒരു ഈജിപ്റ്റുകാരൻ അടിക്കുന്നത് അദ്ദേഹം കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ചുറ്റും നോക്കി ആരും ഇല്ലെന്നു കണ്ടപ്പോൾ അദ്ദേഹം ഈജിപ്റ്റുകാരനെ കൊന്നു മണലിൽ മറവുചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","അടുത്തദിവസം അദ്ദേഹം പുറത്തേക്കു പോയപ്പോൾ രണ്ട് എബ്രായർ ശണ്ഠയിടുന്നതു കണ്ടു. കുറ്റക്കാരനോട്, “നീ നിന്റെ സ്നേഹിതനെ അടിക്കുന്നതെന്ത്?” എന്ന് അദ്ദേഹം ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","“നിന്നെ ഞങ്ങളുടെ അധികാരിയും ന്യായാധിപനുമായി നിയമിച്ചതാര്? ഈജിപ്റ്റുകാരനെ കൊന്നതുപോലെ എന്നെയും കൊല്ലാമെന്നാണോ നിന്റെ വിചാരം?” അവൻ ചോദിച്ചു. അപ്പോൾ മോശ, “ഞാൻ ചെയ്തത് എല്ലാവരും അറിഞ്ഞുകാണും” എന്നു ചിന്തിച്ച് ഭയപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ഫറവോൻ ഈ കാര്യം കേട്ടപ്പോൾ മോശയെ കൊല്ലുന്നതിന് അന്വേഷിച്ചു. എന്നാൽ മോശ ഫറവോന്റെ അടുക്കൽനിന്ന് മിദ്യാനിൽ താമസിക്കാനായി ഓടിപ്പോയി; അവിടെ അദ്ദേഹം ഒരു കിണറ്റിനരികെ ഇരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","മിദ്യാനിലെ ഒരു പുരോഹിതന് ഏഴു പുത്രിമാർ ഉണ്ടായിരുന്നു; അവർ തങ്ങളുടെ പിതാവിന്റെ ആട്ടിൻപറ്റത്തിനു കുടിക്കാനുള്ള വെള്ളം കോരി തൊട്ടികളിൽ നിറയ്ക്കാൻ അവിടെ എത്തി. ");
INSERT INTO malc_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ചില ഇടയന്മാർ വന്ന് അവരെ ഓടിച്ചുകളഞ്ഞു. എന്നാൽ മോശ എഴുന്നേറ്റ് അവരെ സഹായിച്ചു. അവരുടെ ആട്ടിൻപറ്റത്തിനു വെള്ളം കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","അവർ പിതാവായ രെയൂവേലിന്റെ അടുക്കൽ മടങ്ങിയെത്തിയപ്പോൾ അദ്ദേഹം അവരോട്, “നിങ്ങൾ ഇന്ന് ഇത്രയും നേരത്തേ മടങ്ങിയെത്തിയതെങ്ങനെ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","അതിന് അവർ, “ഒരു ഈജിപ്റ്റുകാരൻ ഞങ്ങളെ ഇടയന്മാരുടെ കൈയിൽനിന്നു രക്ഷിച്ചു. അദ്ദേഹം ഞങ്ങൾക്കും ആട്ടിൻപറ്റത്തിനും വെള്ളം കോരിത്തരികയും ചെയ്തു” എന്നു മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","അപ്പോൾ അദ്ദേഹം പുത്രിമാരോട്, “അദ്ദേഹം എവിടെ? നിങ്ങൾ അദ്ദേഹത്തെ വിട്ടിട്ടുപോന്നത് എന്ത്? നിങ്ങൾ അദ്ദേഹത്തെ ഭക്ഷണത്തിനു ക്ഷണിക്കുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","മോശ ആ മനുഷ്യനോടുകൂടെ താമസിക്കാമെന്നു സമ്മതിച്ചു. അദ്ദേഹം തന്റെ മകൾ സിപ്പോറയെ മോശയ്ക്കു വിവാഹംചെയ്തുകൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","തുടർന്നു സിപ്പോറ ഒരു മകനെ പ്രസവിച്ചു. “അന്യനാട്ടിൽ ഞാനൊരു പ്രവാസിയായിത്തീർന്നിരിക്കുന്നു,” എന്നു പറഞ്ഞ് മോശ അവന് ഗെർശോം എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","വളരെ നാളുകൾക്കുശേഷം ഈജിപ്റ്റുരാജാവ് മരിച്ചു. ഇസ്രായേൽമക്കൾ തങ്ങളുടെ അടിമവേലനിമിത്തം ഞരങ്ങി നിലവിളിച്ചു. അടിമവേലനിമിത്തം അവരിൽനിന്നുയർന്ന നിലവിളി ദൈവത്തിന്റെ അടുക്കൽ എത്തി. ");
INSERT INTO malc_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ദൈവം അവരുടെ ദീനരോദനം കേട്ടു; അബ്രാഹാമിനോടും യിസ്ഹാക്കിനോടും യാക്കോബിനോടുമുള്ള തന്റെ ഉടമ്പടി അവിടന്ന് ഓർത്തു. ");
INSERT INTO malc_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ദൈവം ഇസ്രായേൽമക്കളെ കടാക്ഷിച്ചു; ദൈവം അവരെക്കുറിച്ചു ചിന്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ഈ സമയം മോശ തന്റെ അമ്മായിയപ്പനും മിദ്യാനിലെ പുരോഹിതനുമായ യിത്രോയുടെ ആട്ടിൻപറ്റത്തെ മേയിച്ചുകൊണ്ടിരിക്കുകയായിരുന്നു; ആട്ടിൻപറ്റത്തെ നയിച്ചുകൊണ്ട് അദ്ദേഹം മരുഭൂമിക്കപ്പുറം ദൈവത്തിന്റെ പർവതമായ ഹോരേബിൽ എത്തി. ");
INSERT INTO malc_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","അവിടെ യഹോവയുടെ ദൂതൻ ഒരു മുൾപ്പടർപ്പിനുള്ളിൽ അഗ്നിജ്വാലയിൽ അദ്ദേഹത്തിന് പ്രത്യക്ഷനായി. മുൾപ്പടർപ്പ് കത്തുന്നുണ്ടായിരുന്നെങ്കിലും അതു വെന്തുപോകുന്നില്ലെന്ന് മോശ കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","“മുൾപ്പടർപ്പ് വെന്തുപോകാതിരിക്കുന്ന ഈ അത്ഭുതകരമായ കാഴ്ച എന്തെന്ന് ഞാൻ അടുത്തുചെന്നു നോക്കട്ടെ,” എന്ന് മോശ തന്നോടുതന്നെ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","അതു കാണാൻ അദ്ദേഹം അടുത്തുചെല്ലുന്നത് യഹോവ കണ്ടു. ദൈവം മുൾപ്പടർപ്പിനുള്ളിൽനിന്നും അവനെ, “മോശേ! മോശേ!” എന്നു വിളിച്ചു. “അടിയൻ ഇതാ,” എന്ന് മോശ വിളികേട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","“ഇവിടേക്ക് അടുത്തുവരരുത്. നീ നിൽക്കുന്ന സ്ഥലം വിശുദ്ധഭൂമിയാകുകയാൽ നിന്റെ ചെരിപ്പ് അഴിച്ചുമാറ്റുക,” എന്നു ദൈവം കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","“ഞാൻ നിന്റെ പിതാവിന്റെ ദൈവവും അബ്രാഹാമിന്റെ ദൈവവും യിസ്ഹാക്കിന്റെ ദൈവവും യാക്കോബിന്റെ ദൈവവും ആകുന്നു,” എന്നും അവിടന്ന് അരുളിച്ചെയ്തു. അപ്പോൾ മോശ മുഖം മറച്ചു; ദൈവത്തെ നോക്കാൻ അദ്ദേഹം ഭയപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","യഹോവ ഇങ്ങനെ അരുളിച്ചെയ്തു, “ഈജിപ്റ്റിൽ എന്റെ ജനത്തിന്റെ കഷ്ടത ഞാൻ കണ്ടിരിക്കുന്നു. അടിമകളുടെ മേൽനോട്ടക്കാർ നിമിത്തമുള്ള അവരുടെ നിലവിളി ഞാൻ കേട്ടു. ഞാൻ അവരുടെ സങ്കടം അറിയുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","അതുകൊണ്ട് ഈജിപ്റ്റുകാരുടെ കൈയിൽനിന്ന് അവരെ വിടുവിക്കുന്നതിനും അവരെ ആ ദേശത്തുനിന്ന് പുറപ്പെടുവിച്ച് നല്ലതും വിശാലവുമായ ദേശത്തേക്ക്; പാലും തേനും ഒഴുകുന്ന ദേശത്തേക്ക്—കനാന്യർ, ഹിത്യർ, അമോര്യർ, പെരിസ്യർ, ഹിവ്യർ, യെബൂസ്യർ എന്നിവരുടെ സ്ഥലത്തേക്കു—കൊണ്ടുപോകുന്നതിനു ഞാൻ ഇറങ്ങിവന്നിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ഇസ്രായേൽമക്കളുടെ നിലവിളി എന്റെ അടുക്കൽ എത്തിയിരിക്കുന്നു; ഈജിപ്റ്റുകാർ അവരെ പീഡിപ്പിക്കുന്നതു ഞാൻ കാണുകയുംചെയ്തിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ആകയാൽ നീ ഇപ്പോൾ ചെല്ലുക, എന്റെ ജനമായ ഇസ്രായേൽമക്കളെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചു കൊണ്ടുവരാൻ ഞാൻ നിന്നെ ഫറവോന്റെ അടുക്കലേക്ക് അയയ്ക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","എന്നാൽ മോശ ദൈവത്തോട്, “ഫറവോന്റെ അടുക്കൽ ചെല്ലാനും ഇസ്രായേല്യരെ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുപോരാനും എനിക്ക് എന്തു യോഗ്യതയാണുള്ളത്?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","അതിനു ദൈവം, “ഞാൻ നിന്നോടുകൂടെ ഉണ്ടായിരിക്കും. നിന്നെ അയച്ചിരിക്കുന്നതു ഞാൻതന്നെ എന്നതിന് ഇത് ഒരത്ഭുതചിഹ്നമായിരിക്കും: നീ ഈ ജനത്തെ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്നതിനുശേഷം നിങ്ങൾ ഈ മലയിൽ ദൈവത്തെ ആരാധിക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","“ഞാൻ ഇസ്രായേൽമക്കളുടെ അടുത്തുചെന്ന് അവരോട്, ‘നിങ്ങളുടെ പിതാക്കന്മാരുടെ ദൈവം എന്നെ നിങ്ങളുടെ അടുത്തേക്ക് അയച്ചിരിക്കുന്നു എന്നു പറയുമ്പോൾ, അവിടത്തെ നാമം എന്ത്?’ എന്ന് അവർ എന്നോടു ചോദിച്ചാൽ, ഞാൻ അവരോട് എന്തു പറയണം?” എന്ന് മോശ ദൈവത്തോടു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ദൈവം മോശയോട്, “ഞാൻ ആകുന്നവൻ ഞാൻ ആകുന്നു. ‘ഞാൻ ആകുന്നവൻ എന്നെ നിങ്ങളുടെ അടുത്തേക്ക് അയച്ചിരിക്കുന്നു’ എന്നു നീ ഇസ്രായേൽമക്കളോടു പറയണം” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ദൈവം പിന്നെയും മോശയോട് അരുളിച്ചെയ്തു: “നീ ഇസ്രായേല്യരോട് ഇങ്ങനെ പറയണം, ‘നിങ്ങളുടെ പിതാക്കന്മാരുടെ ദൈവമായ യഹോവ—അബ്രാഹാമിന്റെ ദൈവവും യിസ്ഹാക്കിന്റെ ദൈവവും യാക്കോബിന്റെ ദൈവവും—എന്നെ നിങ്ങളുടെ അടുക്കൽ അയച്ചിരിക്കുന്നു.’ “എന്റെ ശാശ്വതനാമം ഇതാണ്, തലമുറതലമുറയായി എന്നെ ഓർക്കേണ്ടത് ഈ നാമത്താൽത്തന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“നീ ചെന്ന് ഇസ്രായേല്യ ഗോത്രത്തലവന്മാരെ വിളിച്ചുകൂട്ടി അവരോട് ഇപ്രകാരം പറയണം: ‘നിങ്ങളുടെ പിതാക്കന്മാരുടെ ദൈവമായ യഹോവ, അബ്രാഹാമിന്റെയും യിസ്ഹാക്കിന്റെയും യാക്കോബിന്റെയും ദൈവംതന്നെ, എനിക്കു പ്രത്യക്ഷനായി എന്നോട്, ഞാൻ നിങ്ങളെ സന്ദർശിക്കുകയും ഈജിപ്റ്റുകാർ നിങ്ങളോടു ചെയ്തിട്ടുള്ളതു കാണുകയുംചെയ്തിരിക്കുന്നു എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ഈജിപ്റ്റിലെ നിങ്ങളുടെ ദുരിതങ്ങളിൽനിന്ന് നിങ്ങളെ രക്ഷിച്ച് കനാന്യർ, ഹിത്യർ, അമോര്യർ, പെരിസ്യർ, ഹിവ്യർ, യെബൂസ്യർ എന്നിവരുടെ ദേശത്തേക്ക്—പാലും തേനും ഒഴുകുന്ന ദേശത്തേക്കുതന്നെ, കൊണ്ടുവരുമെന്നു ഞാൻ വാഗ്ദാനംചെയ്തിരിക്കുന്നു.’ ");
INSERT INTO malc_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ഇസ്രായേല്യ ഗോത്രത്തലവന്മാർ നിന്റെ വാക്കു കേൾക്കും. അങ്ങനെ നീയും ഇസ്രായേല്യ ഗോത്രത്തലവന്മാരും ഈജിപ്റ്റുരാജാവിന്റെ അടുക്കൽ ചെന്ന് അവനോട്, ‘എബ്രായരുടെ ദൈവമായ യഹോവ ഞങ്ങളെ സന്ദർശിച്ചു. മരുഭൂമിയിൽ മൂന്നുദിവസത്തെ ദൂരം യാത്രചെയ്തു ഞങ്ങളുടെ ദൈവമായ യഹോവയ്ക്കു യാഗം അർപ്പിക്കാൻ ഞങ്ങളെ അനുവദിക്കണമേ’ എന്നു പറയുക. ");
INSERT INTO malc_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","എന്നാൽ, ശക്തമായൊരു ഭുജത്തിന്റെ സമ്മർദത്താലല്ലാതെ, ഈജിപ്റ്റുരാജാവ് നിങ്ങളെ പോകാൻ അനുവദിക്കുകയില്ലെന്നു ഞാൻ അറിയുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ആകയാൽ ഞാൻ എന്റെ കൈ നീട്ടുകയും അവരുടെ ഇടയിൽ ചെയ്യാനിരിക്കുന്ന സകല അത്ഭുതങ്ങളാലും ഈജിപ്റ്റുകാരെ പ്രഹരിക്കുകയും ചെയ്യും. അതിനുശേഷം അവൻ നിങ്ങളെ വിട്ടയയ്ക്കും. ");
INSERT INTO malc_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“നിങ്ങൾ വിട്ടുപോരുമ്പോൾ വെറുംകൈയോടെ പോകാതിരിക്കേണ്ടതിനു ഞാൻ ഈജിപ്റ്റുകാരിൽ നിങ്ങളുടെനേർക്ക് അനുകൂലമനോഭാവം ഉളവാക്കും. ");
INSERT INTO malc_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ഓരോ സ്ത്രീയും തന്റെ അയൽക്കാരിയോടും തന്റെ ഭവനത്തിൽ വസിക്കുന്ന ഏതൊരു സ്ത്രീയോടും വെള്ളിയും സ്വർണവുംകൊണ്ടുള്ള ആഭരണങ്ങളും വസ്ത്രങ്ങളും ആവശ്യപ്പെടണം; അവ നിങ്ങൾ നിങ്ങളുടെ പുത്രന്മാരെയും പുത്രിമാരെയും അണിയിക്കണം. അങ്ങനെ നിങ്ങൾ ഈജിപ്റ്റുകാരെ കൊള്ളയടിക്കേണ്ടതാകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","അതിന് മോശ, “അവർ എന്നെ വിശ്വസിക്കുകയോ എന്റെ വാക്കു കേൾക്കുകയോ ചെയ്യാതെ ‘യഹോവ നിനക്കു പ്രത്യക്ഷനായിട്ടില്ല’ എന്നു പറയും” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","അപ്പോൾ യഹോവ അവനോട്, “നിന്റെ കൈയിലിരിക്കുന്നത് എന്ത്?” എന്നു ചോദിച്ചു. “ഒരു വടി,” അവൻ ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","“അതു നിലത്തിടുക,” എന്ന് യഹോവ കൽപ്പിച്ചു. മോശ അതു നിലത്തിട്ടു. അതൊരു പാമ്പായിത്തീർന്നു. അവൻ അതിന്റെ അടുത്തുനിന്ന് ഓടിമാറി. ");
INSERT INTO malc_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","പിന്നെ യഹോവ അവനോട്, “നീ കൈനീട്ടി അതിനെ വാലിൽ പിടിച്ച് എടുക്കുക” എന്നു കൽപ്പിച്ചു. അപ്പോൾ മോശ കൈനീട്ടി പാമ്പിനെ പിടിച്ചു; അത് അവന്റെ കൈയിൽ വീണ്ടും വടിയായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“ഇത്, അവരുടെ പിതാക്കന്മാരുടെ ദൈവമായ യഹോവ—അബ്രാഹാമിന്റെ ദൈവവും യിസ്ഹാക്കിന്റെ ദൈവവും യാക്കോബിന്റെ ദൈവവും—നിനക്കു പ്രത്യക്ഷനായിരിക്കുന്നു എന്ന് അവർ വിശ്വസിക്കേണ്ടതിനുതന്നെ,” എന്നു ദൈവം അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ഇതിനുശേഷം യഹോവ, “നിന്റെ കൈ മാറിടത്തിൽ വെക്കുക” എന്നു കൽപ്പിച്ചു. മോശ കൈ മാറിടത്തിൽ വെച്ചു; അവൻ അതു പുറത്തെടുത്തപ്പോൾ അതു ഹിമംപോലെ വെളുത്തു കുഷ്ഠം ബാധിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“നീ അതു വീണ്ടും മാറിടത്തിൽ വെക്കുക,” എന്ന് അവിടന്നു കൽപ്പിച്ചു. മോശ വീണ്ടും തന്റെ കൈ മാറിടത്തിൽ വെച്ചു. അത് അവൻ പുറത്തെടുത്തപ്പോൾ, തന്റെ മറ്റു ശരീരഭാഗങ്ങളെന്നപോലെ പൂർവസ്ഥിതിയിലായി. ");
INSERT INTO malc_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","തുടർന്ന് യഹോവ അരുളിച്ചെയ്തു, “അവർ നിന്നെ വിശ്വസിക്കാതിരിക്കുകയോ ഒന്നാമത്തെ അത്ഭുതചിഹ്നം ഗൗനിക്കാതിരിക്കുകയോ ചെയ്താൽ രണ്ടാമത്തേതിൽ വിശ്വസിച്ചേക്കും. ");
INSERT INTO malc_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","എന്നാൽ ഈ രണ്ട് അത്ഭുതചിഹ്നങ്ങളിലും അവർ വിശ്വസിക്കാതിരിക്കുകയോ നിന്റെ വാക്കു കേൾക്കാതിരിക്കുകയോ ചെയ്യുന്നെങ്കിൽ, നീ നൈൽനദിയിൽനിന്ന് വെള്ളം കോരി ഉണങ്ങിയ നിലത്ത് ഒഴിക്കണം. നീ നദിയിൽനിന്ന് എടുക്കുന്ന വെള്ളം നിലത്ത് രക്തമായിത്തീരും.” ");
INSERT INTO malc_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","മോശ യഹോവയോട്, “കർത്താവേ, അവിടത്തെ ദാസനോട് ക്ഷമിച്ചാലും; അടിയൻ മുമ്പുതന്നെയോ, അവിടന്ന് അടിയനോടു സംസാരിച്ചതിനുശേഷമോ ഒരിക്കലും വാക്ചാതുര്യമുള്ളവനായിരുന്നിട്ടില്ല. അടിയൻ വിക്കനും തടിച്ച നാവുള്ളവനും ആകുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","യഹോവ അവനോട്, “മനുഷ്യന്റെ വായ് മെനഞ്ഞതാര്? അവനെ ബധിരനോ മൂകനോ ആക്കുന്നതാര്? അവനു കാഴ്ച നൽകുന്നതോ അവനെ അന്ധനാക്കുന്നതോ ആര്? യഹോവയായ ഞാൻ അല്ലയോ? ");
INSERT INTO malc_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ഇപ്പോൾ പോകുക; ഞാൻ നിന്നെ സംസാരിക്കാൻ സഹായിക്കുകയും എന്തു പറയണമെന്നു നിനക്ക് ഉപദേശിച്ചുതരികയും ചെയ്യും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","എന്നാൽ മോശ, “അയ്യോ, കർത്താവേ, ദയവുചെയ്തു മറ്റാരെയെങ്കിലും അയയ്ക്കണമേ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","അപ്പോൾ യഹോവയുടെ കോപം മോശയ്ക്കുനേരേ ജ്വലിച്ചു; അവിടന്ന് അരുളിച്ചെയ്തു: “ലേവ്യനായ അഹരോൻ നിന്റെ സഹോദരൻ അല്ലയോ? അവനു നന്നായി സംസാരിക്കാൻ കഴിയുമെന്നു ഞാൻ അറിയുന്നു; നിന്നെ വന്നു കാണാൻ അവൻ യാത്രതിരിച്ചുകഴിഞ്ഞു; നിന്നെ കാണുമ്പോൾ അവന്റെ ഹൃദയം ആനന്ദിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","പറയേണ്ടുന്ന വാക്കുകൾ നീ അവനു പറഞ്ഞുകൊടുക്കുക. ഞാൻ നിന്റെ വായോടും അവന്റെ വായോടുംകൂടെ ഇരിക്കുകയും എന്താണു ചെയ്യേണ്ടതെന്നു നിങ്ങൾക്ക് ഉപദേശിച്ചുതരികയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","അവൻ നിനക്കുപകരം ജനത്തോടു സംസാരിക്കും; അവൻ നിന്റെ വക്താവും നീ അവനു ദൈവവും എന്ന നിലയിലാകും. ");
INSERT INTO malc_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","എന്നാൽ അത്ഭുതചിഹ്നങ്ങൾ പ്രവർത്തിക്കാൻ ഈ വടിയും നിന്റെ കൈയിൽ എടുത്തുകൊള്ളുക.” ");
INSERT INTO malc_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","പിന്നെ മോശ തന്റെ അമ്മായിയപ്പനായ യിത്രോവിന്റെ അടുക്കൽ തിരിച്ചെത്തി അദ്ദേഹത്തോട്, “ഈജിപ്റ്റിൽ എന്റെ സ്വജനങ്ങളിൽ ആരെങ്കിലും ജീവിച്ചിരിപ്പുണ്ടോ എന്ന് അന്വേഷിക്കേണ്ടതിന് അവരുടെ അടുക്കൽ പോകാൻ എന്നെ അനുവദിക്കണം” എന്നു പറഞ്ഞു. അതിനു യിത്രോ, “സമാധാനത്തോടെ പോകുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","യഹോവ മോശയോടു മിദ്യാനിൽവെച്ച്, “ഈജിപ്റ്റിലേക്കു മടങ്ങിപ്പൊയ്ക്കൊൾക; നിന്നെ വധിക്കാൻ ആഗ്രഹിച്ച പുരുഷന്മാരെല്ലാവരും മരിച്ചുപോയി” എന്ന് അരുളിച്ചെയ്തിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","അങ്ങനെ മോശ തന്റെ ഭാര്യയെയും പുത്രന്മാരെയും ഒരു കഴുതപ്പുറത്തു കയറ്റി, അവരെയും കൂട്ടി തിരികെ ഈജിപ്റ്റിലേക്കു യാത്രയായി. ദൈവത്തിന്റെ വടിയും അദ്ദേഹം കൈയിൽ എടുത്തു. ");
INSERT INTO malc_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, “നീ ഈജിപ്റ്റിൽ ചെല്ലുമ്പോൾ ഞാൻ നിന്നെ ഭരമേൽപ്പിച്ചിട്ടുള്ള സകല അത്ഭുതങ്ങളും ഫറവോന്റെ മുമ്പാകെ ചെയ്യണം. എന്നാൽ ഞാൻ അവന്റെ ഹൃദയം കഠിനമാക്കുമ്പോൾ ജനങ്ങളെ പോകാൻ അവൻ അനുവദിക്കാതിരിക്കുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","അപ്പോൾ ഫറവോനോട്, ഇപ്രകാരം പറയണം, ‘യഹോവ ഇങ്ങനെ അരുളിച്ചെയ്യുന്നു: ഇസ്രായേൽ എന്റെ പുത്രൻ, എന്റെ ആദ്യജാതൻതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","“എന്നെ ആരാധിക്കാൻ എന്റെ പുത്രനെ വിട്ടയയ്ക്കണം” എന്നു ഞാൻ നിന്നോടു പറഞ്ഞല്ലോ. എന്നാൽ നീ അവനെ പോകാൻ അനുവദിക്കുന്നില്ലെങ്കിൽ ഞാൻ നിന്റെ പുത്രനെ, നിന്റെ ആദ്യജാതനെത്തന്നെ, കൊന്നുകളയും’ എന്നുകൂടി പറയുക.” ");
INSERT INTO malc_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","വഴിമധ്യേയുള്ള ഒരു സത്രത്തിൽവെച്ച് യഹോവ മോശയെ നേരിട്ടു; അദ്ദേഹത്തെ കൊല്ലുന്നതിനു ഭാവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","എന്നാൽ സിപ്പോറാ ഒരു കൽക്കത്തിയെടുത്തു തന്റെ പുത്രന്റെ അഗ്രചർമം ഛേദിച്ച് മോശയുടെ കാൽക്കൽ ഇട്ടു. “നിശ്ചയമായും താങ്കൾ എനിക്കൊരു രക്തമണവാളൻ” എന്ന് അവൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ഇങ്ങനെ യഹോവ അവനെ വിട്ടയച്ചു. പരിച്ഛേദനത്തെ പരാമർശിച്ചുകൊണ്ടാണ് അപ്പോൾ അവൾ “രക്തമണവാളൻ” എന്നു പറഞ്ഞത്. ");
INSERT INTO malc_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","യഹോവ അഹരോനോട്, “മോശയെ കാണുന്നതിന് നീ മരുഭൂമിയിലേക്കു ചെല്ലുക” എന്നു കൽപ്പിച്ചു. അദ്ദേഹം ദൈവത്തിന്റെ പർവതത്തിൽവെച്ച് മോശയെ കണ്ട് അദ്ദേഹത്തെ ചുംബിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","യഹോവ തന്നെ ഏൽപ്പിച്ചയച്ച എല്ലാ കാര്യങ്ങളും മോശ അഹരോനെ അറിയിച്ചു; താൻ ചെയ്യണമെന്ന് യഹോവ ആജ്ഞാപിച്ചിരുന്ന എല്ലാ അത്ഭുതചിഹ്നങ്ങളെക്കുറിച്ചും അദ്ദേഹം സംസാരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","മോശയും അഹരോനും ഇസ്രായേല്യ ഗോത്രത്തലവന്മാരെ എല്ലാവരെയും കൂട്ടിവരുത്തി. ");
INSERT INTO malc_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","യഹോവ മോശയോട് അരുളിച്ചെയ്തിരുന്നതെല്ലാം അഹരോൻ അവരെ പറഞ്ഞുകേൾപ്പിച്ചു; മോശ ജനങ്ങളുടെമുമ്പാകെ ആ അത്ഭുതചിഹ്നങ്ങൾ പ്രവർത്തിക്കുകയും ");
INSERT INTO malc_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ജനങ്ങൾ വിശ്വസിക്കുകയും ചെയ്തു. യഹോവ തങ്ങളെ സന്ദർശിച്ചെന്നും അവിടന്നു തങ്ങളുടെ കഷ്ടത കണ്ടിരിക്കുന്നെന്നും ഇസ്രായേൽജനം കേട്ടപ്പോൾ അവർ കുമ്പിട്ടു നമസ്കരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","അതിനുശേഷം മോശയും അഹരോനും ഫറവോന്റെ അടുക്കൽ ചെന്ന്, “എന്റെ ജനം മരുഭൂമിയിൽ എനിക്കൊരു ഉത്സവം ആചരിക്കേണ്ടതിന് അവരെ വിട്ടയയ്ക്കുക എന്ന് ഇസ്രായേലിന്റെ ദൈവമായ യഹോവ അരുളിച്ചെയ്യുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","അതിനു ഫറവോൻ, “ഞാൻ യഹോവയെ അനുസരിക്കേണ്ടതിനും ഇസ്രായേലിനെ വിട്ടയയ്ക്കേണ്ടതിനും അവൻ ആര്? യഹോവയെ ഞാൻ അറിയുന്നില്ല, ഇസ്രായേലിനെ ഞാൻ വിട്ടയയ്ക്കുകയുമില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","അപ്പോൾ അവർ, “എബ്രായരുടെ ദൈവം ഞങ്ങൾക്കു പ്രത്യക്ഷനായിരിക്കുന്നു. ഇപ്പോൾ മരുഭൂമിയിൽ മൂന്നുദിവസത്തെ ദൂരം യാത്രചെയ്തു ഞങ്ങളുടെ ദൈവമായ യഹോവയ്ക്കു യാഗം കഴിക്കാൻ ഞങ്ങളെ അനുവദിക്കണം; അല്ലെങ്കിൽ അവിടന്നു മഹാമാരിയാലോ വാളിനാലോ ഞങ്ങളെ പീഡിപ്പിച്ചേക്കാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","എന്നാൽ ഈജിപ്റ്റുരാജാവ്, “മോശയേ, അഹരോനേ, നിങ്ങൾ ജനങ്ങളെ അവരുടെ വേലയിൽ തടസ്സപ്പെടുത്തുന്നത് എന്തിന്? നിങ്ങളുടെ ജോലിയിലേക്കു മടങ്ങിപ്പോകുക!” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ഫറവോൻ വീണ്ടും പറഞ്ഞു: “ഇതാ, ഈ ദേശത്തു ജനങ്ങൾ അസംഖ്യമായിരിക്കുന്നു, പണിയെടുക്കുന്നതിൽനിന്ന് നിങ്ങൾ അവരെ തടസ്സപ്പെടുത്തുകയാണ്.” ");
INSERT INTO malc_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ഫറവോൻ അന്നുതന്നെ ജനത്തിന്റെമേൽ ആക്കിവെച്ചിരിക്കുന്ന അടിമകളുടെ മേൽനോട്ടക്കാർക്കും അവർക്കുമീതേയുള്ള അധികാരികൾക്കും ഇപ്രകാരം കൽപ്പനകൊടുത്തു: ");
INSERT INTO malc_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“നിങ്ങൾ ഇനിമുതൽ ജനങ്ങൾക്ക് ഇഷ്ടികയുണ്ടാക്കാൻ വൈക്കോൽ കൊടുക്കരുത്; അവർതന്നെ പോയി ആവശ്യമുള്ള വൈക്കോൽ ശേഖരിക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","എന്നാൽ നേരത്തേ ഉണ്ടായിരുന്നത്രയും ഇഷ്ടിക ഉണ്ടാക്കാൻ അവരോട് ആവശ്യപ്പെടണം; എണ്ണം കുറയ്ക്കരുത്. അവർ അലസന്മാരാണ്, അതുകൊണ്ടാകുന്നു ‘ഞങ്ങൾ പോയി ഞങ്ങളുടെ ദൈവത്തിനു യാഗം കഴിക്കട്ടെ’ എന്ന് അവർ മുറവിളി കൂട്ടുന്നത്. ");
INSERT INTO malc_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","അവർക്കു ജോലി കുറെക്കൂടി കഠിനമാക്കിക്കൊടുക്കണം, അങ്ങനെ അവർ വ്യാജവാക്കുകളിൽ ശ്രദ്ധിക്കാതെ പണിയെടുത്തുകൊണ്ടേയിരിക്കട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","അടിമകളുടെ മേൽനോട്ടക്കാരും അവർക്കുമീതേയുള്ള അധികാരികളും ചെന്നു ജനത്തോടു പറഞ്ഞു: “ഫറവോൻ ഇങ്ങനെ കൽപ്പിക്കുന്നു, ‘ഞാൻ നിങ്ങൾക്ക് ഇനിമുതൽ വൈക്കോൽ തരികയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","കിട്ടുന്നേടത്തുനിന്ന് നിങ്ങൾതന്നെ വൈക്കോൽ ശേഖരിക്കണം, എങ്കിലും നിങ്ങളുടെ വേലയിൽ ഒരു കുറവും അനുവദിക്കുകയില്ല.’ ” ");
INSERT INTO malc_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","അതുകൊണ്ടു ജനങ്ങൾ വൈക്കോലിനു പകരം വൈക്കോൽക്കുറ്റി ശേഖരിക്കാൻ ഈജിപ്റ്റിൽ എല്ലായിടങ്ങളിലും ചിതറിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","അടിമകളുടെ മേൽനോട്ടക്കാർ അവരോട്, “ദിവസംതോറുമുള്ള വേല, വൈക്കോലുണ്ടായിരുന്നപ്പോൾ ചെയ്തതുപോലെതന്നെ നിങ്ങൾ ചെയ്തുതീർക്കണം” എന്നു കർശനമായി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ഫറവോന്റെ അടിമകളുടെ മേൽനോട്ടക്കാർ നിയമിച്ച ഇസ്രായേല്യരായ മേലുദ്യോഗസ്ഥന്മാരോട്, “നിങ്ങൾ മുമ്പേ ചെയ്തിരുന്നതുപോലെ ഇന്നലെയും ഇന്നും ഇഷ്ടികയുടെ അളവു തികയ്ക്കാത്തതെന്ത്?” എന്നു ചോദിച്ചുകൊണ്ട് അവരെ അടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ഇസ്രായേല്യരായ മേലുദ്യോഗസ്ഥന്മാർ ഫറവോന്റെ അടുക്കൽ ചെന്ന് അദ്ദേഹത്തോടു സങ്കടമുണർത്തിച്ചു: “അടിയങ്ങളോട് ഇങ്ങനെ ചെയ്യുന്നതെന്ത്? ");
INSERT INTO malc_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","അടിയങ്ങൾക്കു വൈക്കോൽ തരുന്നതേയില്ല, എന്നിട്ടും ‘ഇഷ്ടിക ഉണ്ടാക്കുക!’ എന്നു പറയുന്നു. ഇതാ, അടിയങ്ങളെ അടിക്കുകയും ചെയ്യുന്നു, അവിടത്തെ ജനമാണ് ഇതിൽ തെറ്റുകാർ.” ");
INSERT INTO malc_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","അതിനു ഫറവോൻ, “നിങ്ങൾ മടിയന്മാർ, അലസന്മാർ! അതുകൊണ്ടാണ്, ‘ഞങ്ങൾ പോയി യഹോവയ്ക്കു യാഗം കഴിക്കട്ടെ’ എന്നു നിങ്ങൾ എപ്പോഴും പറയുന്നത്. ");
INSERT INTO malc_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","പോയി ജോലി ചെയ്യുക. വൈക്കോൽ നിങ്ങൾക്കു തരികയേയില്ല, എന്നാലും ഇഷ്ടികയുടെ എണ്ണം കുറയുകയുമരുത്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“നിങ്ങൾ ഓരോ ദിവസവും ഉണ്ടാക്കേണ്ട ഇഷ്ടികയുടെ എണ്ണം കുറയ്ക്കരുത്,” എന്ന് ഇസ്രായേല്യരായ മേലുദ്യോഗസ്ഥന്മാരോടു കൽപ്പിച്ചപ്പോൾത്തന്നെ തങ്ങൾ പ്രയാസത്തിൽ അകപ്പെട്ടിരിക്കുന്നു എന്ന് അവർ മനസ്സിലാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","അവർ ഫറവോന്റെ അടുക്കൽനിന്ന് മടങ്ങുമ്പോൾ തങ്ങൾക്കായി കാത്തുനിന്നിരുന്ന മോശയെയും അഹരോനെയും കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","“യഹോവ നിങ്ങളെ കാണുകയും ന്യായംവിധിക്കുകയും ചെയ്യട്ടെ! നിങ്ങൾ ഫറവോന്റെയും അദ്ദേഹത്തിന്റെ വേലക്കാരുടെയും മുമ്പിൽ ഞങ്ങളെ നാറ്റിക്കുകയും ഞങ്ങളെ കൊല്ലുന്നതിന് അവരുടെ കൈയിൽ വാൾ കൊടുക്കുകയും ചെയ്തിരിക്കുകയാണ്,” എന്ന് അവർ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","അപ്പോൾ മോശ മടങ്ങിച്ചെന്ന് യഹോവയോട്, “കർത്താവേ, അവിടന്ന് ഈ ജനത്തെ കഷ്ടതയിൽ ആക്കിയതെന്ത്? ഇതിനായിട്ടാണോ അങ്ങ് എന്നെ അയച്ചത്? ");
INSERT INTO malc_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","അവിടത്തെ നാമത്തിൽ ഫറവോനോടു സംസാരിക്കാൻ ചെന്നതുമുതൽ അദ്ദേഹം ഈ ജനത്തിന്റെമേൽ കഷ്ടത വരുത്തിയിരിക്കുകയാണ്, അങ്ങ് അവിടത്തെ ജനത്തെ വിടുവിച്ചതുമില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","അപ്പോൾ യഹോവ മോശയോട്, “ഞാൻ ഫറവോനോട് എന്തു ചെയ്യുമെന്നു നീ കാണും. എന്റെ ശക്തിയുള്ള ഭുജംനിമിത്തം അവൻ അവരെ വിട്ടയയ്ക്കും; എന്റെ ബലമുള്ള കരം കണ്ടിട്ട് അവൻ അവരെ ദേശത്തുനിന്ന് ആട്ടിയോടിക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ദൈവം മോശയോടു വീണ്ടും പറഞ്ഞു: “ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ഞാൻ അബ്രാഹാമിനും യിസ്ഹാക്കിനും യാക്കോബിനും സർവശക്തനായ ദൈവമായി പ്രത്യക്ഷപ്പെട്ടു. എന്നാൽ യഹോവ എന്ന നാമത്തിൽ ഞാൻ അവർക്ക് എന്നെത്തന്നെ വെളിപ്പെടുത്തിയിട്ടില്ല. ");
INSERT INTO malc_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","അവർ പ്രവാസികളായി താമസിച്ചിരുന്ന കനാൻദേശം അവർക്കു കൊടുക്കുമെന്നു ഞാൻ അവരോട് ഉടമ്പടിചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ഈജിപ്റ്റുകാർ അടിമകളാക്കിക്കൊണ്ടിരിക്കുന്ന ഇസ്രായേൽമക്കളുടെ നിലവിളി കേൾക്കുകയും ഞാൻ എന്റെ ഉടമ്പടി ഓർക്കുകയും ചെയ്തിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“ആകയാൽ, ഇസ്രായേല്യരോട് ഇപ്രകാരം പറയുക: ‘ഞാൻ യഹോവ ആകുന്നു; ഞാൻ നിങ്ങളെ ഈജിപ്റ്റുകാരുടെ നുകത്തിൻകീഴിൽനിന്ന് വിടുവിക്കും; അവരുടെ അടിമത്തത്തിൽനിന്ന് നിങ്ങളെ സ്വതന്ത്രരാക്കും; നീട്ടിയ ഭുജത്താലും മഹാശിക്ഷാവിധികളാലും ഞാൻ നിങ്ങളെ ഉദ്ധരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ഞാൻ നിങ്ങളെ സ്വന്തജനമായി സ്വീകരിക്കുകയും ഞാൻ നിങ്ങളുടെ ദൈവം ആയിരിക്കുകയും ചെയ്യും. ഈജിപ്റ്റുകാരുടെ നുകത്തിൻകീഴിൽനിന്ന് നിങ്ങളെ വിടുവിച്ച നിങ്ങളുടെ ദൈവമായ യഹോവ ഞാൻതന്നെ എന്നു നിങ്ങൾ അപ്പോൾ മനസ്സിലാക്കും. ");
INSERT INTO malc_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","അബ്രാഹാമിനും യിസ്ഹാക്കിനും യാക്കോബിനും കൊടുക്കുമെന്നു ഞാൻ കൈ ഉയർത്തി ശപഥംചെയ്ത ദേശത്തേക്കു നിങ്ങളെ കൊണ്ടുവന്ന് അതു നിങ്ങൾക്ക് അവകാശമായിത്തരും. ഞാൻ യഹോവ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","മോശ ഇത് ഇസ്രായേൽമക്കളോടു പറഞ്ഞു: എന്നാൽ തങ്ങളെ തളർത്തുന്നരീതിയിലുള്ള ക്രൂരമായ അടിമത്തം നിമിത്തം അവർ മോശയുടെ വാക്കു ശ്രദ്ധിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ഇതിനുശേഷം യഹോവ മോശയോട്, ");
INSERT INTO malc_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“നീ ചെന്ന് ഈജിപ്റ്റിലെ രാജാവായ ഫറവോനോട്, ഇസ്രായേൽമക്കളെ അവന്റെ ദേശത്തുനിന്നു വിട്ടയയ്ക്കണമെന്നു പറയുക” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","എന്നാൽ മോശ യഹോവയോട്, “ഇസ്രായേൽമക്കൾപോലും എന്റെ വാക്കു കേൾക്കുന്നില്ല, പിന്നെ ഫറവോൻ എന്റെ വാക്കു കേൾക്കുന്നതെങ്ങനെ? ഞാൻ വാക്ചാതുര്യമുള്ളവനല്ലല്ലോ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","എന്നാൽ യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു. ഇസ്രായേൽജനത്തെ ഈജിപ്റ്റിൽനിന്ന് വിടുവിക്കേണ്ടതിന് ഇസ്രായേൽമക്കളുടെ അടുക്കലേക്കും ഈജിപ്റ്റുരാജാവായ ഫറവോന്റെ അടുക്കലേക്കും അവിടന്ന് ഞങ്ങളെ നിയോഗിച്ചയച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","അവരുടെ പിതൃഭവനങ്ങളിലെ തലവന്മാർ ഇവരായിരുന്നു: ഇസ്രായേലിന്റെ ആദ്യജാതനായ രൂബേന്റെ പുത്രന്മാർ: ഹാനോക്ക്, ഫല്ലൂ, ഹെസ്രോൻ, കർമി; ഇവയായിരുന്നു രൂബേന്റെ കുലങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ശിമെയോന്റെ പുത്രന്മാർ: യെമൂവേൽ, യാമിൻ, ഓഹദ്, യാഖീൻ, സോഹർ, ഒരു കനാന്യസ്ത്രീയുടെ മകനായ ശാവൂൽ; ഇവയായിരുന്നു ശിമെയോന്റെ കുലങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","തങ്ങളുടെ വംശപാരമ്പര്യപ്രകാരം ലേവിയുടെ പുത്രന്മാർ: ഗെർശോൻ, കെഹാത്ത്, മെരാരി. (ലേവി 137 വർഷം ജീവിച്ചിരുന്നു.) ");
INSERT INTO malc_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","കുലങ്ങളുടെ ക്രമമനുസരിച്ച് ഗെർശോന്റെ പുത്രന്മാർ ലിബ്നിയും ശിമെയിയും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","കെഹാത്തിന്റെ പുത്രന്മാർ: അമ്രാം, യിസ്ഹാർ, ഹെബ്രോൻ, ഉസ്സീയേൽ എന്നിവരായിരുന്നു. (കെഹാത്ത് 133 വർഷം ജീവിച്ചിരുന്നു.) ");
INSERT INTO malc_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","മെരാരിയുടെ പുത്രന്മാർ: മഹ്ലി, മൂശി എന്നിവരായിരുന്നു. ഇവരാണ് തങ്ങളുടെ പ്രമാണരേഖകളിൻപ്രകാരം ലേവിയുടെ കുലങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","അമ്രാം തന്റെ പിതാവിന്റെ സഹോദരിയായ യോഖേബേദിനെ വിവാഹംകഴിച്ചു; അവൾ അവന് അഹരോനെയും മോശയെയും പ്രസവിച്ചു. അമ്രാം നൂറ്റിമുപ്പത്തിയേഴു വർഷം ജീവിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","യിസ്ഹാരിന്റെ പുത്രന്മാർ: കോരഹ്, നേഫെഗ്, സിക്രി എന്നിവരായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ഉസ്സീയേലിന്റെ പുത്രന്മാർ: മീശായേൽ, എത്സാഫാൻ, സിത്രി. ");
INSERT INTO malc_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","അഹരോൻ അമ്മീനാദാബിന്റെ മകളും നഹശോന്റെ പെങ്ങളുമായ എലീശേബയെ വിവാഹംകഴിച്ചു; അവൾ അവന് നാദാബ്, അബീഹൂ, എലെയാസാർ, ഈഥാമാർ എന്നിവരെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","കോരഹിന്റെ പുത്രന്മാർ: അസ്സീർ, എൽക്കാനാ, അബീയാസാഫ് എന്നിവരായിരുന്നു. കോരഹിന്റെ കുലങ്ങൾ ഇവതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","അഹരോന്റെ മകനായ എലെയാസാർ ഫൂതിയേലിന്റെ പെൺമക്കളിൽ ഒരുവളെ വിവാഹംകഴിച്ചു; അവൾ അവന് ഫീനെഹാസിനെ പ്രസവിച്ചു. ഇവരായിരുന്നു ലേവ്യകുടുംബങ്ങളുടെ കുലംകുലമായുള്ള തലവന്മാർ. ");
INSERT INTO malc_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","“ഇസ്രായേല്യരെ ഗണംഗണമായി ഈജിപ്റ്റിൽനിന്ന് വിടുവിച്ചുകൊണ്ടുപോരുക” എന്ന് യഹോവ കൽപ്പിച്ചത് ഇതേ അഹരോനോടും മോശയോടും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ഇസ്രായേല്യരെ ഈജിപ്റ്റിൽനിന്ന് കൂട്ടിക്കൊണ്ടു വരുന്നതിനെപ്പറ്റി ഈജിപ്റ്റിലെ രാജാവായ ഫറവോനോടു സംസാരിച്ചവരും ഇവരായിരുന്നു—ഈ മോശയും അഹരോനും. ");
INSERT INTO malc_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","യഹോവ ഈജിപ്റ്റിൽവെച്ചു മോശയോടു സംസാരിച്ചപ്പോൾ അവിടന്ന്, ");
INSERT INTO malc_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“ഞാൻ യഹോവ ആകുന്നു, ഞാൻ നിന്നോടു കൽപ്പിക്കുന്നതെല്ലാം ഈജിപ്റ്റിലെ രാജാവായ ഫറവോനോടു പറയുക” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","എന്നാൽ മോശ യഹോവയോട്, “വാക്ചാതുര്യമില്ലാത്തവനാണു ഞാൻ; ഫറവോൻ എന്റെ വാക്കു കേൾക്കുന്നതെങ്ങനെ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","അപ്പോൾ യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “ഇതാ, ഞാൻ നിന്നെ ഫറവോനു ദൈവമാക്കിയിരിക്കുന്നു. നിന്റെ സഹോദരനായ അഹരോൻ നിനക്കു പ്രവാചകൻ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ഞാൻ നിന്നോടു കൽപ്പിക്കുന്നതെല്ലാം നീ സംസാരിക്കണം; ഇസ്രായേൽമക്കളെ അവന്റെ ദേശത്തുനിന്നു വിട്ടയയ്ക്കണമെന്നു ഫറവോനോട് നിന്റെ സഹോദരനായ അഹരോൻ പറയണം. ");
INSERT INTO malc_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","എന്നാൽ ഞാൻ ഫറവോന്റെ ഹൃദയം കഠിനമാക്കും: ഈജിപ്റ്റിൽ ഞാൻ എന്റെ ചിഹ്നങ്ങളും അത്ഭുതങ്ങളും വർധിപ്പിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","എന്നാൽ ഫറവോൻ നിന്റെ വാക്കു കേൾക്കുകയില്ല. ഞാൻ ഈജിപ്റ്റിന്മേൽ കൈവെച്ച് മഹാശിക്ഷാവിധികളോടെ എന്റെ ഗണങ്ങളെ, എന്റെ ജനമായ ഇസ്രായേൽമക്കളെ, ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ഈജിപ്റ്റിനെതിരേ കൈനീട്ടി ഇസ്രായേൽമക്കളെ അവരുടെ മധ്യേനിന്നു വിടുവിക്കുമ്പോൾ, ഞാൻ യഹോവ ആകുന്നു എന്ന് ഈജിപ്റ്റുകാർ അറിയും.” ");
INSERT INTO malc_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","മോശയും അഹരോനും യഹോവ തങ്ങളോടു കൽപ്പിച്ചിരുന്നതുപോലെ പ്രവർത്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","അവർ ഫറവോനോടു സംസാരിക്കുന്ന കാലത്ത് മോശയ്ക്ക് എൺപതും അഹരോന് എൺപത്തിമൂന്നും വയസ്സായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","യഹോവ മോശയോടും അഹരോനോടും, ");
INSERT INTO malc_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ ‘നിങ്ങൾ ഒരു അത്ഭുതം കാണിക്കുക’ എന്നു ഫറവോൻ നിങ്ങളോടു പറയുമ്പോൾ, ‘നിന്റെ വടിയെടുത്ത് ഫറവോന്റെയും അയാളുടെ ഉദ്യോഗസ്ഥന്മാരുടെയും മുമ്പാകെ നിലത്തിടുക’ എന്ന് അഹരോനോടു പറയണം, അതൊരു പാമ്പായിത്തീരും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","അങ്ങനെ മോശയും അഹരോനും ഫറവോന്റെ അടുക്കൽ എത്തി, യഹോവ കൽപ്പിച്ചതുപോലെ പ്രവർത്തിച്ചു. അഹരോൻ തന്റെ വടി ഫറവോന്റെയും അയാളുടെ ഉദ്യോഗസ്ഥരുടെയും മുമ്പാകെ നിലത്തിട്ടു, അതൊരു പാമ്പായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ഫറവോൻ ജ്ഞാനികളെയും ആഭിചാരകന്മാരെയും വരുത്തി, ഈജിപ്റ്റിലെ മാന്ത്രികന്മാരും തങ്ങളുടെ മന്ത്രവിദ്യയാൽ അതേ പ്രവൃത്തി ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ഓരോരുത്തനും അവനവന്റെ വടി നിലത്തിടുകയും അതു പാമ്പായിത്തീരുകയും ചെയ്തു. എന്നാൽ അഹരോന്റെ വടി അവരുടെ വടികളെ വിഴുങ്ങിക്കളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","എങ്കിലും അയാൾ അവരുടെ വാക്കു കേട്ടില്ല. യഹോവ അരുളിച്ചെയ്തിരുന്നതുപോലെ ഫറവോന്റെ ഹൃദയം കഠിനമായി. ");
INSERT INTO malc_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","അപ്പോൾ യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “ഫറവോന്റെ ഹൃദയം കഠിനമാണ്, ജനത്തെ വിട്ടയയ്ക്കാൻ അവനു മനസ്സില്ല. ");
INSERT INTO malc_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","രാവിലെ ഫറവോൻ വെള്ളത്തിന്റെ അടുത്തേക്കു പോകുമ്പോൾ നീ അവന്റെ അടുക്കൽ എത്തണം. അവനെ എതിരേൽക്കാൻ നൈലിന്റെ തീരത്തു കാത്തുനിൽക്കണം. പാമ്പായിത്തീർന്ന വടി കൈയിൽ എടുക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","പിന്നെ അവനോട് ഇങ്ങനെ പറയുക: ‘എബ്രായരുടെ ദൈവമായ യഹോവ താങ്കളോട് ഇങ്ങനെ പറയാൻ എന്നെ അയച്ചിരിക്കുന്നു: മരുഭൂമിയിൽ എന്നെ ആരാധിക്കേണ്ടതിന് എന്റെ ജനത്തെ വിട്ടയയ്ക്കുക. എന്നാൽ താങ്കൾ ഇതുവരെയും അതു കേട്ടില്ല. ");
INSERT INTO malc_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","യഹോവയുടെ അരുളപ്പാട് ഇപ്രകാരമാണ്: ഞാൻ യഹോവ എന്നു നീ ഇതിനാൽ അറിയും. എന്റെ കൈയിലിരിക്കുന്ന വടികൊണ്ടു ഞാൻ നൈലിനെ അടിക്കുകയും അതു രക്തമായിത്തീരുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","നൈലിലെ മത്സ്യങ്ങൾ ചത്തൊടുങ്ങും, നദിയിൽനിന്ന് ദുർഗന്ധം വമിക്കും. ഈജിപ്റ്റുകാർക്ക് അതിലെ വെള്ളം കുടിക്കാൻ സാധിക്കാതെവരും.’ ” ");
INSERT INTO malc_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “ ‘നിന്റെ വടിയെടുത്ത് ഈജിപ്റ്റിലെ വെള്ളത്തിന്മേൽ—നദികളുടെയും തോടുകളുടെയുംമേൽ, കുളങ്ങളുടെയും എല്ലാ സംഭരണികളുടെയുംമേൽ—നിന്റെ കൈനീട്ടുക എന്ന് അഹരോനോടു പറയുക. അവ രക്തമായി മാറും.’ ഈജിപ്റ്റിൽ എല്ലായിടത്തും, മരത്തൊട്ടികളിലും കൽഭരണികളിലുംപോലും, രക്തം ഉണ്ടായിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","യഹോവ കൽപ്പിച്ചതുപോലെതന്നെ മോശയും അഹരോനും ചെയ്തു. ഫറവോന്റെയും അദ്ദേഹത്തിന്റെ ഉദ്യോഗസ്ഥരുടെയും മുമ്പാകെ അഹരോൻ തന്റെ വടി ഉയർത്തി നൈൽനദിയിലെ വെള്ളത്തിൽ അടിച്ചു. വെള്ളം മുഴുവൻ രക്തമായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","നൈലിലെ മീൻ എല്ലാം ചത്തു, ഈജിപ്റ്റുകാർക്ക് ആ നദിയിലെ വെള്ളം കുടിക്കാൻ വയ്യാത്തവണ്ണം അതിൽനിന്ന് നാറ്റം വമിച്ചു. ഈജിപ്റ്റിൽ എല്ലായിടത്തും രക്തം കാണപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ഈജിപ്റ്റുകാരായ മാന്ത്രികന്മാരും തങ്ങളുടെ മന്ത്രവാദത്താൽ അതേകാര്യം ചെയ്തു. ഫറവോന്റെ ഹൃദയം കഠിനമായിത്തീർന്നു; യഹോവ അരുളിച്ചെയ്തിരുന്നതുപോലെ അയാൾ മോശയുടെയും അഹരോന്റെയും വാക്കു ശ്രദ്ധിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","പിന്നെയോ, അയാൾ തിരിഞ്ഞു തന്റെ കൊട്ടാരത്തിലേക്കു കയറിപ്പോയി, ഇതൊന്നും അവൻ ഗൗനിച്ചതേയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ഈജിപ്റ്റുകാർക്കു നൈലിലെ വെള്ളം കുടിക്കാൻ കഴിയാതിരുന്നതുകൊണ്ട് അവരെല്ലാവരും കുടിവെള്ളത്തിനുവേണ്ടി നദീതീരത്തു കുഴികളുണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","യഹോവ നൈൽനദിയെ അടിച്ചതിനുശേഷം ഏഴുദിവസം കഴിഞ്ഞിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “നീ ചെന്ന് ഫറവോനോട് ഇങ്ങനെ പറയുക, ‘യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: എന്നെ ആരാധിക്കേണ്ടതിന് എന്റെ ജനത്തെ വിട്ടയയ്ക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","നീ അവരെ വിട്ടയയ്ക്കാൻ സമ്മതിക്കുന്നില്ലെങ്കിൽ ഞാൻ ദേശത്തെല്ലായിടത്തും തവളകളുടെ ബാധ വരുത്തും. ");
INSERT INTO malc_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","നൈൽനദി തവളകളെക്കൊണ്ടു നിറയും. അവ നിന്റെ കൊട്ടാരത്തിലും ശയനമുറിയിലും കിടക്കമേലും നിന്റെ ഉദ്യോഗസ്ഥന്മാരുടെ വീടുകളിലും നിന്റെ ജനത്തിന്മേലും അടുപ്പുകളിലും മാവു കുഴയ്ക്കുന്ന പാത്രങ്ങളിലും വന്നുകയറും. ");
INSERT INTO malc_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","നിന്റെയും നിന്റെ ജനങ്ങളുടെയും നിന്റെ സകല ഉദ്യോഗസ്ഥരുടെയുംമേൽ തവളകൾ കയറും.’ ” ");
INSERT INTO malc_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","“ ‘ഈജിപ്റ്റുദേശത്ത് തവളകൾ കയറാൻ നിന്റെ കൈ വടിയോടുകൂടി തോടുകളുടെയും പുഴകളുടെയും കുളങ്ങളുടെയും മീതേ നീട്ടുക,’ എന്ന് അഹരോനോടു പറയണമെന്ന് യഹോവ മോശയോടു കൽപ്പിച്ചു.” ");
INSERT INTO malc_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","അങ്ങനെ അഹരോൻ ഈജിപ്റ്റിലെ വെള്ളത്തിനുമീതേ തന്റെ കൈ നീട്ടുകയും തവളകൾ കയറിവന്നു ദേശത്തെ മൂടുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","മന്ത്രവാദികൾ തങ്ങളുടെ മാന്ത്രികവിദ്യയാൽ അതേകാര്യം ചെയ്തു; അവരും ഈജിപ്റ്റുദേശത്തു തവളകളെ വരുത്തി. ");
INSERT INTO malc_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ഫറവോൻ മോശയെയും അഹരോനെയും ആളയച്ചുവരുത്തി അവരോട്, “എന്റെയും എന്റെ ജനങ്ങളുടെയും അടുക്കൽനിന്ന് തവളകൾ നീങ്ങിപ്പോകാൻ നിങ്ങൾ യഹോവയോട് അപേക്ഷിക്കുക; അപ്പോൾ യഹോവയ്ക്കു യാഗം കഴിക്കാൻ നിങ്ങളുടെ ജനങ്ങളെ ഞാൻ വിട്ടയയ്ക്കാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","മോശ ഫറവോനോടു പറഞ്ഞു: “നിങ്ങളെയും നിങ്ങളുടെ വീടുകളെയും വിട്ട് തവള നദിയിൽമാത്രമായി ഒതുങ്ങേണ്ടതിന് താങ്കൾക്കും സേവകർക്കും ജനത്തിനുംവേണ്ടി ഞാൻ പ്രാർഥിക്കേണ്ട സമയം ദയവായി നിശ്ചയിച്ചുതന്നാലും.” ");
INSERT INTO malc_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","“നാളെ,” ഫറവോൻ പറഞ്ഞു. അതിനുത്തരമായി മോശ പറഞ്ഞത്, “ഞങ്ങളുടെ ദൈവമായ യഹോവയ്ക്കു സദൃശനായി ആരുമില്ല എന്നു താങ്കൾ അറിയേണ്ടതിന് അത് അങ്ങനെ സംഭവിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","തവളകൾ താങ്കളെയും താങ്കളുടെ ഭവനങ്ങളെയും സേവകരെയും ജനത്തെയും വിട്ടുപോയി നൈൽനദിയിൽമാത്രം ഒതുങ്ങും.” ");
INSERT INTO malc_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","മോശയും അഹരോനും ഫറവോന്റെ അടുക്കൽനിന്ന് പോയതിനുശേഷം മോശ യഹോവയോട്, ഫറവോന്റെമേൽ അവിടന്നു വരുത്തിയിരുന്ന തവളകളെ സംബന്ധിച്ചു പ്രാർഥിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","മോശയുടെ പ്രാർഥനയനുസരിച്ച് യഹോവ പ്രവർത്തിച്ചു. തവളകൾ വീടുകളിലും മുറ്റങ്ങളിലും വയലുകളിലും ചത്തൊടുങ്ങി. ");
INSERT INTO malc_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","അവയെ കൂമ്പാരങ്ങളായി കൂട്ടി. അവയുടെ ദുർഗന്ധം ദേശമെങ്ങും നിറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","എന്നാൽ തവളകളിൽനിന്ന് ആശ്വാസംലഭിച്ചു എന്നുകണ്ടപ്പോൾ, യഹോവ അരുളിച്ചെയ്തിരുന്നതുപോലെ, ഫറവോൻ തന്റെ ഹൃദയത്തെ കഠിനമാക്കി; മോശയുടെയും അഹരോന്റെയും വാക്ക് അയാൾ കേട്ടതുമില്ല. ");
INSERT INTO malc_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ഇതിനുശേഷം യഹോവ മോശയോടു പറഞ്ഞു: “നീ അഹരോനോടു പറയുക, ‘നിന്റെ വടിയെടുത്ത് നിലത്തെ പൂഴിയിൽ അടിക്കുക.’ അപ്പോൾ അതു പേനായിത്തീർന്ന് ഈജിപ്റ്റു മുഴുവൻ വ്യാപിക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","അവർ അപ്രകാരംചെയ്തു. അഹരോൻ കൈനീട്ടി തന്റെ വടികൊണ്ട് നിലത്തെ പൂഴിയിൽ അടിച്ചു. അതു മനുഷ്യരുടെയും മൃഗങ്ങളുടെയുംമേൽ പേൻ ആയിത്തീർന്നു; ഈജിപ്റ്റിലെല്ലായിടവും നിലത്തെ പൂഴിമുഴുവനും പേൻ ആയിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","മന്ത്രവാദികളും തങ്ങളുടെ മാന്ത്രികവിദ്യയാൽ പേൻ ഉണ്ടാക്കാൻ ശ്രമിച്ചു; എന്നാൽ, അവർക്കതിനു കഴിഞ്ഞില്ല. മനുഷ്യരുടെയും മൃഗങ്ങളുടെയുംമേൽ പേൻ നിറഞ്ഞുനിന്നു. ");
INSERT INTO malc_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","അപ്പോൾ മന്ത്രവാദികൾ ഫറവോനോടു പറഞ്ഞത്, “ഇതു ദൈവത്തിന്റെ കൈവിരൽ പ്രവർത്തിക്കുന്നതാകുന്നു.” എന്നാൽ, യഹോവ അരുളിച്ചെയ്തിരുന്നതുപോലെ ഫറവോന്റെ ഹൃദയം കഠിനമായിത്തീർന്നു. അവൻ അവരെ ശ്രദ്ധിച്ചതുമില്ല. ");
INSERT INTO malc_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ഈ സംഭവത്തിനുശേഷം യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “നീ അതിരാവിലെ എഴുന്നേറ്റ് ഫറവോന്റെ മുമ്പിൽ നിൽക്കണം. അവൻ നദീതീരത്തേക്ക് പോകുമ്പോൾ, അവനോട് ഇങ്ങനെ പറയണം: ‘യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു. എന്നെ ആരാധിക്കേണ്ടതിന് എന്റെ ജനത്തെ വിട്ടയയ്ക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","നീ എന്റെ ജനത്തെ വിട്ടയയ്ക്കാതിരുന്നാൽ നിന്റെയും ഭൃത്യന്മാരുടെയും ജനത്തിന്റെയും നിന്റെ എല്ലാ ഭവനങ്ങളിലും ഞാൻ ഈച്ചകളെ അയയ്ക്കും. ഈജിപ്റ്റുകാരുടെ എല്ലാ വീടുകളും അവരുടെ ദേശവും ഈച്ചകളാൽ നിറയും. ");
INSERT INTO malc_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘എന്നാൽ എന്റെ ജനം പാർക്കുന്ന ഗോശെൻ പ്രദേശത്തെ അന്നു ഞാൻ ഒഴിവാക്കും. അവിടെ ഈച്ച ഉണ്ടായിരിക്കുകയില്ല; അങ്ങനെ യഹോവയായ ഞാൻതന്നെ ഈ ദേശത്തിന്റെ മധ്യേയുണ്ട് എന്നു നീ അറിയും. ");
INSERT INTO malc_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","എന്റെ ജനത്തെയും നിന്റെ ജനത്തെയുംതമ്മിൽ ഞാൻ വേർതിരിക്കും. ഈ അത്ഭുതചിഹ്നം നാളെത്തന്നെ സംഭവിക്കും.’ ” ");
INSERT INTO malc_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","യഹോവ അങ്ങനെതന്നെ ചെയ്തു. ഈച്ചകളുടെ കനത്ത കൂട്ടങ്ങൾ ഫറവോന്റെ കൊട്ടാരത്തിലേക്കും ഉദ്യോഗസ്ഥരുടെ വീടുകളിലേക്കും പ്രവഹിച്ചു. ഈജിപ്റ്റുദേശം മുഴുവനും ഈച്ചകളെക്കൊണ്ടു നശിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","അപ്പോൾ ഫറവോൻ മോശയെയും അഹരോനെയും ആളയച്ചുവരുത്തി. “പോകുക, നിങ്ങളുടെ ദൈവത്തിന് ഈ ദേശത്തുവെച്ചുതന്നെ യാഗം അർപ്പിക്കുക,” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","“അതു ശരിയല്ല,” മോശ പറഞ്ഞു. “ഞങ്ങളുടെ ദൈവമായ യഹോവയ്ക്കു ഞങ്ങൾ അർപ്പിക്കുന്ന യാഗം ഈജിപ്റ്റുകാർക്ക് അറപ്പു തോന്നിക്കുന്നതായിരിക്കും. അവരുടെ ദൃഷ്ടിയിൽ മ്ലേച്ഛമായ യാഗം ഞങ്ങൾ അർപ്പിച്ചാൽ അവർ ഞങ്ങളെ കല്ലെറിയുകയില്ലയോ? ");
INSERT INTO malc_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ഞങ്ങളുടെ ദൈവമായ യഹോവ ഞങ്ങളോടു കൽപ്പിക്കുന്നതുപോലെ, മരുഭൂമിയിൽ മൂന്നുദിവസത്തെ യാത്രചെയ്തു ചെന്ന് അവിടത്തേക്കു ഞങ്ങൾ യാഗം അർപ്പിക്കേണ്ടതാകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","“മരുഭൂമിയിൽവെച്ചു നിങ്ങളുടെ ദൈവമായ യഹോവയ്ക്കു യാഗം അർപ്പിക്കാൻ ഞാൻ നിങ്ങളെ വിട്ടയയ്ക്കാം, എന്നാൽ നിങ്ങൾ വളരെ അകലെപ്പോകരുത്; എനിക്കുവേണ്ടി പ്രാർഥിക്കുക,” ഫറവോൻ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","അതിന് മോശ ഉത്തരം പറഞ്ഞു: “താങ്കളെ വിട്ടുപോയിക്കഴിഞ്ഞാലുടൻതന്നെ ഞാൻ യഹോവയോട് അപേക്ഷിക്കാം, ഈച്ചകൾ നാളെ ഫറവോനെയും ഉദ്യോഗസ്ഥരെയും ജനത്തെയും വിട്ടുപോകും. എന്നാൽ യഹോവയ്ക്കു യാഗം അർപ്പിക്കാൻ ജനങ്ങളെ വിട്ടയയ്ക്കാതെ ഫറവോൻ വീണ്ടും വഞ്ചനാപരമായി പ്രവർത്തിക്കുകയില്ലെന്നത് ഉറപ്പായിരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","പിന്നെ മോശ ഫറവോന്റെ അടുക്കൽനിന്ന് പോയി യഹോവയോടു പ്രാർഥിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","മോശയുടെ അപേക്ഷയനുസരിച്ച് യഹോവ പ്രവർത്തിച്ചു: ഈച്ചകൾ ഫറവോനെയും ഉദ്യോഗസ്ഥരെയും ജനത്തെയും വിട്ടുപോയി; ഒന്നുപോലും അവശേഷിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","എന്നാൽ ഈ പ്രാവശ്യവും ഫറവോൻ തന്റെ ഹൃദയം കഠിനമാക്കി; ജനത്തെ വിട്ടയച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ഇതിനുശേഷം യഹോവ മോശയോട് അരുളിച്ചെയ്തു, നീ ഫറവോന്റെ അടുക്കൽ ചെന്ന് അവനോടു പറയുക, എബ്രായരുടെ ദൈവമായ യഹോവ, “എന്നെ ആരാധിക്കാൻ എന്റെ ജനത്തെ വിട്ടയയ്ക്കുക” എന്ന് അരുളിച്ചെയ്യുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","നീ അവരെ വിട്ടയയ്ക്കാതെ തടയുകയാണെങ്കിൽ ");
INSERT INTO malc_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","യഹോവയുടെ കൈ നിന്റെ വയലിലുള്ള ജീവജാലങ്ങളുടെമേൽ—നിന്റെ കുതിരകളുടെയും കഴുതകളുടെയും ഒട്ടകങ്ങളുടെയും കന്നുകാലികളുടെയും ചെമ്മരിയാടുകളുടെയും കോലാടുകളുടെയുംമേൽ—ഭയാനകമായ ഒരു ബാധ വരുത്തും. ");
INSERT INTO malc_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","എന്നാൽ ഇസ്രായേലിന്റെ കന്നുകാലികൾക്കും ഈജിപ്റ്റിന്റെ കന്നുകാലികൾക്കുംതമ്മിൽ യഹോവ ഒരു വ്യത്യാസം വെക്കും; ഇസ്രായേൽമക്കളുടെ കന്നുകാലികളിൽ ഒന്നും ചാകുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","യഹോവ സമയം നിശ്ചയിച്ചിട്ട് ഇപ്രകാരം അരുളിച്ചെയ്തു, “യഹോവ നാളെ ഈ ദേശത്ത് ഇതുചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","പിറ്റേന്ന് യഹോവ അങ്ങനെതന്നെ ചെയ്തു; ഈജിപ്റ്റുകാരുടെ വളർത്തുമൃഗങ്ങൾ എല്ലാം ചത്തൊടുങ്ങി, എന്നാൽ ഇസ്രായേൽമക്കളുടെ മൃഗങ്ങളൊന്നും ചത്തില്ല. ");
INSERT INTO malc_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ഇസ്രായേല്യരുടെ മൃഗങ്ങളിൽ ഒരെണ്ണംപോലും ചത്തില്ല എന്നു ഫറവോൻ നടത്തിയ അന്വേഷണത്തിൽ മനസ്സിലാക്കി. എങ്കിലും ഫറവോന്റെ ഹൃദയം കഠിനപ്പെട്ടു, അയാൾ ജനത്തെ വിട്ടയച്ചതുമില്ല. ");
INSERT INTO malc_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ഈ സംഭവത്തിനുശേഷം യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: “അടുപ്പിൽനിന്ന് കൈനിറയെ ചാരം എടുക്കണം; അതു ഫറവോന്റെ മുമ്പിൽവെച്ച് മോശ ആകാശത്തിൽ വിതറട്ടെ. ");
INSERT INTO malc_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","അത് ഈജിപ്റ്റുദേശം മുഴുവൻ ധൂളിയായി വ്യാപിച്ച്, ദേശം മുഴുവനുമുള്ള മനുഷ്യരുടെയും മൃഗങ്ങളുടെയുംമേൽ പഴുക്കുന്ന പരുക്കളായിത്തീരും.” ");
INSERT INTO malc_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","അങ്ങനെ അവർ അടുപ്പിൽനിന്ന് ചാരമെടുത്തുകൊണ്ട് ഫറവോന്റെ മുമ്പിൽനിന്നു. മോശ അത് ആകാശത്തേക്കു വിതറി; മനുഷ്യരുടെയും മൃഗങ്ങളുടെയുംമേൽ പഴുക്കുന്ന പരുക്കൾ ഉണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","മന്ത്രവാദികൾക്കു മോശയുടെമുമ്പിൽ നിൽക്കാൻ കഴിഞ്ഞില്ല; അവരുടെയും സകല ഈജിപ്റ്റുകാരുടെയുംമേൽ പരു ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","എന്നാൽ യഹോവ ഫറവോന്റെ ഹൃദയം കഠിനമാക്കി; യഹോവ മോശയോട് അരുളിച്ചെയ്തിരുന്നതുപോലെ അയാൾ മോശയുടെയും അഹരോന്റെയും വാക്കു കേട്ടില്ല. ");
INSERT INTO malc_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “അതിരാവിലെ എഴുന്നേറ്റു ഫറവോന്റെ മുമ്പിൽ ചെന്നുനിന്ന് അവനോടു പറയണം: ‘എബ്രായരുടെ ദൈവമായ യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: എന്നെ ആരാധിക്കാൻ എന്റെ ജനത്തെ വിട്ടയയ്ക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","അല്ലെങ്കിൽ ഇത്തവണ ഞാൻ എന്റെ സകലബാധകളും പൂർണശക്തിയോടെ നിന്റെയും ഉദ്യോഗസ്ഥരുടെയും ജനത്തിന്റെയും നേർക്ക് അയയ്ക്കും. സർവഭൂമിയിലും എനിക്കു തുല്യനായി ആരുമില്ല എന്നു നീ അങ്ങനെ അറിയും. ");
INSERT INTO malc_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ഇപ്പോൾത്തന്നെ എന്റെ കൈനീട്ടി നിന്നെയും നിന്റെ ജനത്തെയും ബാധയാൽ ദണ്ഡിപ്പിച്ച് ഭൂമിയിൽനിന്ന് തുടച്ചുനീക്കാമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","എന്റെ ശക്തി നിനക്കു കാണിച്ചുതരികയും എന്റെ നാമം ഭൂമിയിലെല്ലായിടത്തും ഘോഷിക്കപ്പെടുകയും വേണം എന്ന ഉദ്ദേശ്യത്തിനായിത്തന്നെ ഞാൻ നിന്നെ ഉയർത്തിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","നീ ഇപ്പോഴും എന്റെ ജനത്തിനു വിരോധമായിനിന്ന് അവരെ വിട്ടയയ്ക്കാതിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","അതുകൊണ്ടു നാളെ ഈ നേരത്ത്, ഈജിപ്റ്റിന്റെ സ്ഥാപനംമുതൽ ഇന്നുവരെ ഉണ്ടായിട്ടില്ലാത്ത ഭയങ്കരമായ കന്മഴ ഞാൻ അയയ്ക്കും. ");
INSERT INTO malc_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","നിങ്ങളുടെ കന്നുകാലികളെയും വയലിൽ നിങ്ങൾക്കുള്ള സകലതിനെയും ഒരു അഭയസ്ഥാനത്തേക്കു കൊണ്ടുവരാൻ ഇപ്പോൾ ആജ്ഞ പുറപ്പെടുവിക്കുക; അകത്തുകൊണ്ടുവരാതെ വയലിൽത്തന്നെ ആയിരിക്കുന്ന സകലമനുഷ്യരുടെയും മൃഗങ്ങളുടെയുംമേൽ ആ കന്മഴ ചൊരിയും.’ ” ");
INSERT INTO malc_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ഫറവോന്റെ ഉദ്യോഗസ്ഥന്മാരിൽ യഹോവയുടെ വചനത്തെ ഭയപ്പെട്ടവർ തങ്ങളുടെ അടിമകളെയും മൃഗങ്ങളെയും തിടുക്കത്തിൽ അകത്തുകൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","യഹോവയുടെ വചനത്തെ അവഗണിച്ചവരോ, തങ്ങളുടെ അടിമകളെയും മൃഗങ്ങളെയും വയലിൽത്തന്നെ വിട്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ഇതിനുശേഷം യഹോവ മോശയോട്, “ഈജിപ്റ്റിലെങ്ങും—മനുഷ്യരുടെയും മൃഗങ്ങളുടെയും ഈജിപ്റ്റിലെ വയലുകളിൽ വളരുന്ന സകലതിന്മേലും—കന്മഴ പെയ്യേണ്ടതിനു നിന്റെ കൈ ആകാശത്തേക്കു നീട്ടുക” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","മോശ തന്റെ വടി ആകാശത്തേക്കു നീട്ടിയപ്പോൾ യഹോവ ഇടിയും കന്മഴയും അയച്ചു, ഇടിമിന്നൽ ഭൂമിയിലേക്കു പാഞ്ഞിറങ്ങി. അങ്ങനെ യഹോവ ഈജിപ്റ്റുദേശത്തിന്മേൽ കന്മഴ പെയ്യിച്ചു; ");
INSERT INTO malc_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","കൽത്തുണ്ടുകൾ വീഴുകയും മിന്നൽ അങ്ങോട്ടും ഇങ്ങോട്ടും പായുകയും ചെയ്തു. ഈജിപ്റ്റ് ഒരു ദേശമായിത്തീർന്നതിനുശേഷം ഇപ്രകാരം തീവ്രമായ ഒരു കന്മഴ ഉണ്ടായിട്ടില്ല. ");
INSERT INTO malc_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ഈജിപ്റ്റിലുടനീളം, വയലുകളിലുള്ള സകലതിനെയും—മനുഷ്യരെയും മൃഗങ്ങളെയും കന്മഴ തകർത്തു; വയലിലെ സസ്യങ്ങളെയെല്ലാം അതു നശിപ്പിച്ചു. മരങ്ങളെ തകർത്തുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ഇസ്രായേല്യർ താമസിച്ചിരുന്ന ഗോശെനിൽമാത്രം കന്മഴ പെയ്തില്ല. ");
INSERT INTO malc_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","അപ്പോൾ ഫറവോൻ മോശയെയും അഹരോനെയും ആളയച്ചുവരുത്തി. “ഇപ്പോൾ ഞാൻ പാപം ചെയ്തുപോയി,” അയാൾ അവരോടു പറഞ്ഞു. “യഹോവ നീതിയുള്ളവൻ, എനിക്കും എന്റെ ജനത്തിനും തെറ്റുപറ്റിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","യഹോവയോടു പ്രാർഥിപ്പിൻ; ഇടിയും കന്മഴയും ഞങ്ങൾക്കു സഹിക്കാവുന്നതിൽ അപ്പുറമായിരിക്കുന്നു! ഞാൻ നിങ്ങളെ വിട്ടയച്ചേക്കാം, നിങ്ങളെ ഇനി താമസിപ്പിക്കുകയില്ല.” ");
INSERT INTO malc_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","അതിന് മോശ, “പട്ടണത്തിനു പുറത്തു കടന്നതിനുശേഷം ഞാൻ എന്റെ കൈകൾ നിവർത്തി യഹോവയോടു പ്രാർഥിക്കും. ഇടിമുഴക്കം നിലയ്ക്കും, കന്മഴ ഇനിമേൽ പെയ്യുകയില്ല; ഭൂമി യഹോവയുടേതാണെന്നു താങ്കൾ അറിയും. ");
INSERT INTO malc_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","എന്നാൽ താങ്കളും താങ്കളുടെ ഉദ്യോഗസ്ഥരും ഇപ്പോഴും യഹോവയായ ദൈവത്തെ ഭയപ്പെടുന്നില്ല എന്നു ഞാൻ മനസ്സിലാക്കുന്നു” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ചണവും യവവും നശിച്ചു. യവം കതിരിടുകയും ചണം പൂക്കുകയും ചെയ്തിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ഗോതമ്പും ചോളവും വിളയുന്നതിനു കാലതാമസം ഉണ്ടായിരുന്നതുകൊണ്ട് അവ നശിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ഇതിനെത്തുടന്ന് മോശ ഫറവോനെ വിട്ടു നഗരത്തിനു പുറത്തുകടന്നു. അദ്ദേഹം യഹോവയിലേക്കു കൈകൾ മലർത്തി; ഇടിമുഴക്കവും കന്മഴയും നിലച്ചു. പിന്നീടു ദേശത്തു മഴ പെയ്തില്ല. ");
INSERT INTO malc_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","മഴയും കന്മഴയും ഇടിയും നിന്നു എന്നുകണ്ടപ്പോൾ ഫറവോൻ വീണ്ടും പാപംചെയ്തു. അദ്ദേഹവും അദ്ദേഹത്തിന്റെ ഉദ്യോഗസ്ഥരും ഹൃദയം കഠിനമാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","അങ്ങനെ, യഹോവ മോശമുഖേന അരുളിച്ചെയ്തിരുന്നതുപോലെതന്നെ ഫറവോന്റെ ഹൃദയം കഠിനമായി. അദ്ദേഹം ഇസ്രായേൽമക്കളെ പോകാൻ അനുവദിച്ചതുമില്ല. ");
INSERT INTO malc_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “നീ ഫറവോന്റെ അടുക്കൽ ചെല്ലുക. ഞാൻ അവന്റെയും അവന്റെ ഉദ്യോഗസ്ഥരുടെയും മുന്നിൽ എന്റെ അത്ഭുതചിഹ്നങ്ങൾ പ്രവർത്തിക്കേണ്ടതിന് അവരുടെ ഹൃദയം കഠിനമാക്കിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ഞാൻ ഈജിപ്റ്റുകാരോട് എത്ര കർശനമായി പെരുമാറിയെന്നും അവരുടെ ഇടയിൽ എന്റെ അത്ഭുതചിഹ്നങ്ങൾ എങ്ങനെ പ്രവർത്തിച്ചെന്നും നിനക്കു നിന്റെ മക്കളോടും മക്കളുടെ മക്കളോടും വിവരിക്കാൻ കഴിയേണ്ടതിനും ഞാൻ യഹോവ ആകുന്നു എന്നു നിങ്ങൾ അറിയേണ്ടതിനുമാണ് ഇങ്ങനെ ചെയ്യുന്നത്.” ");
INSERT INTO malc_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","മോശയും അഹരോനും ഫറവോന്റെ അടുക്കൽ ചെന്ന് അദ്ദേഹത്തോടു പറഞ്ഞു, “എബ്രായരുടെ ദൈവമായ യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു, ‘നീ എത്രകാലം എന്റെമുമ്പിൽ നിന്നെത്തന്നെ വിനയപ്പെടുത്താതിരിക്കും? എന്റെ ജനം എന്നെ ആരാധിക്കേണ്ടതിന് അവരെ വിട്ടയയ്ക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","നീ അവരെ പോകാൻ അനുവദിക്കുന്നില്ലെങ്കിൽ ഞാൻ നാളെ നിന്റെ ദേശത്തു വെട്ടുക്കിളികളെ അയയ്ക്കും. ");
INSERT INTO malc_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","നിലം കാണാൻ കഴിയാത്തവിധം അവ ഭൂതലത്തെ മൂടും. നിന്റെ വയലുകളിലും നിലത്തും തളിർത്തുവളരുന്ന സകലവൃക്ഷങ്ങളും ഉൾപ്പെടെ, കന്മഴയിൽ നശിക്കാതെ ശേഷിച്ചിട്ടുള്ളതെല്ലാം അവ തിന്നുകളയും. ");
INSERT INTO malc_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","അവ നിന്റെയും നിന്റെ ഉദ്യോഗസ്ഥരുടെയും ഈജിപ്റ്റുകാരായ എല്ലാവരുടെയും ഭവനങ്ങളിൽ നിറയും. ആ കാഴ്ച നിന്റെ പിതാക്കന്മാരോ പൂർവികരോ ഈ ദേശത്തു താമസം ഉറപ്പിച്ച നാൾമുതൽ ഇതുവരെയും ഒരിക്കലും കണ്ടിട്ടില്ലാത്തതായിരിക്കും.’ ” പിന്നെ മോശ പിന്തിരിഞ്ഞ് ഫറവോനെ വിട്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ഫറവോന്റെ ഉദ്യോഗസ്ഥന്മാർ അദ്ദേഹത്തോട്, “ഈ മനുഷ്യൻ എത്രകാലം നമുക്ക് ഒരു കെണിയായി തുടരും? ആ ജനം ചെന്ന് അവരുടെ ദൈവമായ യഹോവയെ ആരാധിക്കേണ്ടതിന് അവരെ വിട്ടയയ്ക്കണം. ഈജിപ്റ്റു നശിച്ചുകൊണ്ടിരിക്കുകയാണെന്ന് അങ്ങ് ഇപ്പോഴും മനസ്സിലാക്കുന്നില്ലയോ?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","അപ്പോൾ മോശയെയും അഹരോനെയും ഫറവോന്റെ അടുക്കൽ തിരികെക്കൊണ്ടുവന്നു. “പൊയ്ക്കൊൾക, നിങ്ങളുടെ ദൈവമായ യഹോവയെ ആരാധിക്കുക,” അദ്ദേഹം പറഞ്ഞു. “എന്നാൽ ആരൊക്കെയാണു പോകുന്നത്?” അദ്ദേഹം ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","അതിന് മോശ മറുപടി പറഞ്ഞു, “ഞങ്ങൾ യഹോവയ്ക്ക് ഒരു ഉത്സവം ആചരിക്കേണ്ടതാകുന്നു; അതുകൊണ്ട്, ഞങ്ങൾ ഞങ്ങളുടെ ചെറുപ്പക്കാരെയും വൃദ്ധജനങ്ങളെയും ആൺമക്കളെയും പെൺമക്കളെയും ആട്ടിൻപറ്റങ്ങളെയും കന്നുകാലിക്കൂട്ടങ്ങളെയും കൂട്ടിയാണു പോകുന്നത്.” ");
INSERT INTO malc_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","അപ്പോൾ ഫറവോൻ പറഞ്ഞു, “ഞാൻ നിങ്ങളെ നിങ്ങളുടെ കുഞ്ഞുങ്ങളോടുംകൂടെ പോകാൻ അനുവദിച്ചാൽ, യഹോവ നിങ്ങളോടുകൂടെ ഇരിക്കുമാറാകട്ടെ! നിങ്ങൾ ദോഷത്തിനു തുനിഞ്ഞിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","വേണ്ടാ, പുരുഷന്മാർമാത്രം പോയി യഹോവയെ ആരാധിക്കുക; അതാണല്ലോ നിങ്ങൾ ഇതുവരെ ആവശ്യപ്പെട്ടുകൊണ്ടിരുന്നത്?” പിന്നെ മോശയെയും അഹരോനെയും ഫറവോന്റെ മുന്നിൽനിന്ന് ആട്ടിയോടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, “വെട്ടുക്കിളികൾ വന്നു ദേശത്തെ മൂടി, വയലിൽ വളരുന്നതെല്ലാം, കന്മഴ കഴിഞ്ഞു ശേഷിക്കുന്ന സകലതും തിന്നുകളയേണ്ടതിന് നിന്റെ കൈ ഈജിപ്റ്റിന്മേൽ നീട്ടുക.” ");
INSERT INTO malc_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","മോശ ഈജിപ്റ്റിനുമീതേ തന്റെ വടിനീട്ടി. യഹോവ അന്നു പകലും രാത്രിയും ദേശത്തുകൂടി ഒരു കിഴക്കൻകാറ്റ് അടിപ്പിച്ചു. നേരം പുലർന്നപ്പോൾ കിഴക്കൻകാറ്റു വെട്ടുക്കിളികളെ വരുത്തിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","അവ ഈജിപ്റ്റിനെ മുഴുവൻ ആക്രമിച്ച്, ദേശത്ത് അത്യധികമായി വ്യാപിച്ചു. അതുപോലുള്ള വെട്ടുക്കിളിശല്യം മുമ്പൊരിക്കലും ഉണ്ടായിട്ടില്ല, ഇനിയൊരിക്കലും ഉണ്ടാകുകയുമില്ല. ");
INSERT INTO malc_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","അവ ദേശംമുഴുവൻ മൂടിയതുകൊണ്ട് എല്ലായിടവും ഇരുണ്ടുപോയി. കന്മഴ ശേഷിപ്പിച്ചിരുന്നതെല്ലാം—വയലിലെ സസ്യങ്ങളും വൃക്ഷങ്ങളിലെ കായ്കളും എല്ലാം—അവ തിന്നുതീർത്തു. ഈജിപ്റ്റുദേശത്ത് ഒരിടത്തും, വൃക്ഷങ്ങളിലോ സസ്യങ്ങളിലോ പച്ചയായതൊന്നും ശേഷിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ഫറവോൻ മോശയെയും അഹരോനെയും പെട്ടെന്നു വരുത്തി അവരോടു പറഞ്ഞു: “ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവയോടും നിങ്ങളോടും പാപംചെയ്തിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","എന്റെ പാപം ഈ ഒരു പ്രാവശ്യംകൂടി ക്ഷമിക്കുക; മാരകമായ ഈ ബാധ എന്നിൽനിന്ന് അകറ്റിക്കളയാൻ നിങ്ങളുടെ ദൈവമായ യഹോവയോട് അപേക്ഷിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","മോശ ഫറവോന്റെ അടുക്കൽനിന്നുപോയി യഹോവയോടു പ്രാർഥിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","യഹോവ അതിശക്തമായ ഒരു പടിഞ്ഞാറൻ കാറ്റു വരുത്തി; അതു വെട്ടുക്കിളികളെ കൊണ്ടുപോയി ചെങ്കടലിൽ എറിഞ്ഞു. ഈജിപ്റ്റിൽ ഒരിടത്തും ഒരു വെട്ടുക്കിളിപോലും ശേഷിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","എന്നാൽ യഹോവ ഫറവോന്റെ ഹൃദയം കഠിനമാക്കി, അദ്ദേഹം ഇസ്രായേൽമക്കളെ വിട്ടയച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","അപ്പോൾ യഹോവ മോശയോട്, “സ്പർശിക്കത്തക്ക കൂരിരുൾ ഈജിപ്റ്റുദേശത്തു മൂടേണ്ടതിനു നീ ആകാശത്തേക്കു കൈനീട്ടുക” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","അതനുസരിച്ചു മോശ ആകാശത്തേക്കു കൈനീട്ടി, കനത്ത ഇരുട്ട് ഈജിപ്റ്റിനെ മൂന്നുദിവസത്തേക്കു നിശ്ശേഷം മറച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ആർക്കും ആരെയും കാണാനോ സ്വസ്ഥാനം വിട്ടുപോകാനോ കഴിയാതായി. എങ്കിലും ഇസ്രായേൽമക്കളുടെ വാസസ്ഥലങ്ങളിൽ വെളിച്ചം ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","അപ്പോൾ ഫറവോൻ മോശയെ വരുത്തി, “പോയി യഹോവയെ ആരാധിക്കുക. നിങ്ങളുടെ ഭാര്യമാരും കുട്ടികളും നിങ്ങളുടെകൂടെ പോരട്ടെ; നിങ്ങളുടെ ആട്ടിൻപറ്റങ്ങളും കന്നുകാലികളുംമാത്രം ഇവിടെ നിൽക്കട്ടെ” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","അതിന് മോശ ഉത്തരം പറഞ്ഞു: “ഞങ്ങളുടെ ദൈവമായ യഹോവയ്ക്കു യാഗങ്ങളും ഹോമയാഗങ്ങളും അർപ്പിക്കാൻ അങ്ങു ഞങ്ങളെ അനുവദിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ഞങ്ങളുടെ സകലമൃഗങ്ങളെയുംകൂടെ കൊണ്ടുപോകണം; ഒരു കുളമ്പുപോലും പിന്നിൽ ശേഷിച്ചുകൂടാ. ഞങ്ങളുടെ ദൈവമായ യഹോവയെ ആരാധിക്കുന്നതിന് അവയിൽ ചിലതിനെ ഉപയോഗിക്കേണ്ടതുണ്ട്. തന്നെയുമല്ല, യഹോവയെ ആരാധിക്കാൻ എന്താണ് ഉപയോഗിക്കേണ്ടതെന്ന് അവിടെ എത്തുന്നതുവരെ ഞങ്ങൾ അറിയുന്നുമില്ല.” ");
INSERT INTO malc_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","എന്നാൽ യഹോവ ഫറവോന്റെ ഹൃദയം കഠിനമാക്കി, അവരെ വിട്ടയയ്ക്കാൻ അയാൾക്കു സമ്മതമായിരുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ഫറവോൻ മോശയോട്, “കടന്നുപോകൂ എന്റെ മുന്നിൽനിന്ന്! ഇനി എന്റെമുമ്പിൽ വരികയേ അരുത്. എന്റെ മുഖം കാണുന്ന ദിവസം നീ മരിക്കും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","അതിന് മോശ, “താങ്കൾ പറയുന്നതുപോലെതന്നെ ആകട്ടെ. ഇനി ഒരിക്കലും ഞാൻ അങ്ങയുടെ മുഖം കാണുകയില്ല” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, “ഞാൻ ഫറവോന്റെയും ഈജിപ്റ്റിന്റെയുംമേൽ ഒരു ബാധകൂടി വരുത്തും. അതിനുശേഷം അവൻ നിങ്ങളെ ഇവിടെനിന്നു വിട്ടയയ്ക്കും; വിട്ടയയ്ക്കുമ്പോൾ നിങ്ങളെ സകലരെയും പുറത്താക്കും. ");
INSERT INTO malc_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","പുരുഷന്മാരും സ്ത്രീകളും ഒരുപോലെ തങ്ങളുടെ അയൽക്കാരോടു വെള്ളിയാഭരണങ്ങളും സ്വർണാഭരണങ്ങളും ആവശ്യപ്പെടണമെന്നു നീ ജനത്തോടു പറയണം.” ");
INSERT INTO malc_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","യഹോവ ഈജിപ്റ്റുകാർക്ക് ഇസ്രായേൽജനത്തോടു കരുണതോന്നിപ്പിച്ചു. മോശ ഈജിപ്റ്റിൽ, ഫറവോന്റെ ഉദ്യോഗസ്ഥന്മാർക്കും ഈജിപ്റ്റിലെ ജനതയ്ക്കും സമാരാധ്യനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","മോശ ഇങ്ങനെ പ്രസ്താവിച്ചു, “യഹോവ അരുളിച്ചെയ്യുന്നതെന്തെന്നാൽ: ‘അർധരാത്രിയോടടുത്ത് ഞാൻ ഈജിപ്റ്റിന്റെ മധ്യേ സഞ്ചരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","സിംഹാസനത്തിൽ ഇരിക്കുന്ന ഫറവോന്റെ ആദ്യജാതൻമുതൽ തിരികല്ലിനരികെ ഇരിക്കുന്ന ദാസിയുടെ ആദ്യജാതൻവരെ ഈജിപ്റ്റിലുള്ള സകല ആദ്യജാതന്മാരും മൃഗങ്ങളുടെ സകലകടിഞ്ഞൂലുകളും ചത്തുപോകും. ");
INSERT INTO malc_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","മുമ്പൊരിക്കലും ഉണ്ടായിട്ടില്ലാത്തതും ഇനിയൊരിക്കലും ഉണ്ടാകാത്തതുമായ വലിയ വിലാപം ഈജിപ്റ്റിൽ എല്ലായിടത്തും ഉണ്ടാകും. ");
INSERT INTO malc_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","എന്നാൽ ഇസ്രായേല്യരുടെ ഏതെങ്കിലും മനുഷ്യന്റെയോ മൃഗത്തിന്റെയോ നേർക്ക് ഒരു നായ് പോലും കുരയ്ക്കുകയില്ല.’ യഹോവ ഈജിപ്റ്റിനും ഇസ്രായേലിനും മധ്യേ ഒരു വ്യത്യാസം വെച്ചിരിക്കുന്നെന്ന് അപ്പോൾ നിങ്ങൾ മനസ്സിലാക്കും. ");
INSERT INTO malc_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","താങ്കളുടെ ഉദ്യോഗസ്ഥന്മാരായ ഇവർ എല്ലാവരും എന്റെ അടുക്കൽവന്ന് എന്റെമുമ്പാകെ വണങ്ങിക്കൊണ്ട് എന്നോട്, ‘താങ്കളും താങ്കളെ അനുഗമിക്കുന്ന സകലരുംകൂടി പോകുക!’ എന്നു പറയും. അപ്പോൾ ഞാൻ വിട്ടുപോകും.” ഇതിനുശേഷം മോശ കോപംകൊണ്ടു ജ്വലിച്ച്, ഫറവോന്റെ അടുക്കൽനിന്ന് പുറപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","യഹോവ മോശയോട്, “ഫറവോൻ നിന്റെ വാക്കു നിരസിച്ചുകളയും; അങ്ങനെ ഈജിപ്റ്റിൽ എന്റെ അത്ഭുതങ്ങൾ വർധിക്കാൻ ഇടയാകുകയും ചെയ്യും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","മോശയും അഹരോനും ഫറവോന്റെ മുമ്പാകെ ഈ അത്ഭുതങ്ങളെല്ലാം ചെയ്തെങ്കിലും യഹോവ ഫറവോന്റെ ഹൃദയത്തെ കഠിനമാക്കി. അയാൾ തന്റെ നാട്ടിൽനിന്ന് ഇസ്രായേൽജനതയെ വിട്ടയച്ചതുമില്ല. ");
INSERT INTO malc_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","യഹോവ മോശയോടും അഹരോനോടും ഈജിപ്റ്റിൽവെച്ച് ഇങ്ങനെ അരുളിച്ചെയ്തു, ");
INSERT INTO malc_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ഈമാസം നിങ്ങളുടെ വർഷത്തിന്റെ ഒന്നാംമാസമായ ആരംഭമാസം ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ഈമാസം പത്താംതീയതി ഓരോ പുരുഷനും തന്റെ കുടുംബത്തിനുവേണ്ടി, ഒരു കുടുംബത്തിന് ഒന്ന് എന്ന കണക്കിൽ, ഓരോ ആട്ടിൻകുട്ടിയെ എടുത്തുകൊള്ളണം എന്നു നിങ്ങൾ ഇസ്രായേല്യസമൂഹത്തോട് ഒന്നാകെ കൽപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ഒരാട്ടിൻകുട്ടി മുഴുവൻ ആവശ്യമില്ല എന്നു വരത്തക്കവണ്ണം ഏതെങ്കിലും കുടുംബം ചെറിയതെങ്കിൽ അവർ തങ്ങളുടെ ഏറ്റവും അടുത്തുള്ള അയൽവാസിയുമായി അവിടെയുള്ളവരുടെ എണ്ണമനുസരിച്ച് അതിനെ പങ്കുവെക്കണം. ഓരോ വ്യക്തിയും ഭക്ഷിക്കുന്നതിന്റെ അളവനുസരിച്ച് നിങ്ങൾക്ക് എത്ര ആട്ടിൻകുട്ടി ആവശ്യമുണ്ട് എന്നു നിശ്ചയിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","നിങ്ങൾ തെരഞ്ഞെടുക്കുന്ന ആട്ടിൻകുട്ടി ഒരുവർഷം പ്രായമുള്ളതും ഊനമൊന്നും ഇല്ലാത്തതുമായ ആൺ ആയിരിക്കണം; ചെമ്മരിയാടോ കോലാടോ ആകാം. ");
INSERT INTO malc_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","മാസത്തിന്റെ പതിന്നാലാംതീയതിവരെ അവയെ സംരക്ഷിക്കുകയും അന്നു സന്ധ്യാസമയത്ത് ഇസ്രായേല്യസമൂഹത്തിലെ സകലരും അവയെ അറക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","പിന്നെ അവർ അവയുടെ രക്തത്തിൽ കുറെ എടുത്ത്, തങ്ങൾ ആട്ടിൻകുട്ടിയെ ഭക്ഷിക്കുന്ന വീടിന്റെ കട്ടിളക്കാലുകളിലും കട്ടിളകളുടെ മീതേയുള്ള പടിയിലും പുരട്ടണം. ");
INSERT INTO malc_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","അവർ കയ്‌പുചീരയും പുളിപ്പില്ലാത്ത അപ്പവും കൂട്ടി തീയിൽ ചുട്ട മാംസം ആ രാത്രിയിൽത്തന്നെ ഭക്ഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","തലയും കാലുകളും ആന്തരികഭാഗങ്ങളും എല്ലാംകൂടി തീയിൽ ചുട്ടതല്ലാതെ പച്ചയായിട്ടോ, വെള്ളത്തിൽ വേവിച്ചോ ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","രാവിലത്തേക്ക് അതിൽ അൽപ്പംപോലും ശേഷിപ്പിക്കരുത്; എന്തെങ്കിലും മിച്ചംവരുന്നെങ്കിൽ അതു ചുട്ടുകളയണം. ");
INSERT INTO malc_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","നിങ്ങൾ അതു ഭക്ഷിക്കേണ്ടത് ഇപ്രകാരമാണ്: അര കെട്ടിയും കാലിൽ ചെരിപ്പിട്ടും കൈയിൽ വടിപിടിച്ചുംകൊണ്ട് തിടുക്കത്തിൽ അതു ഭക്ഷിക്കണം; അത് യഹോവയുടെ പെസഹ ആകുന്നു! ");
INSERT INTO malc_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“ആ രാത്രിയിൽത്തന്നെ ഞാൻ ഈജിപ്റ്റിൽക്കൂടി കടന്നുപോകുകയും മനുഷ്യരുടെയും മൃഗങ്ങളുടെയും എല്ലാ കടിഞ്ഞൂലുകളെയും സംഹരിക്കുകയും ചെയ്യും; ഈജിപ്റ്റിലെ സകലദേവന്മാരുടെയുംമേൽ ഞാൻ ന്യായവിധി വരുത്തും. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","നിങ്ങൾ വസിക്കുന്ന ഭവനത്തിൽ രക്തം നിങ്ങൾക്ക് ഒരു ചിഹ്നമായിരിക്കും; രക്തം കാണുമ്പോൾ ഞാൻ നിങ്ങളെ വിട്ടു കടന്നുപോകും. ഞാൻ ഈജിപ്റ്റിനെ ബാധിക്കുന്ന ബാധ നിങ്ങൾക്കു നാശകാരണമായിത്തീരുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ഈ ദിവസത്തിന്റെ സ്മരണ നിങ്ങൾ നിലനിർത്തേണ്ടതാകുന്നു; വരുംതലമുറകളിൽ നിങ്ങൾ അത് യഹോവയ്ക്കുള്ള ഉത്സവമായി ആഘോഷിക്കണം—ഇത് എന്നെന്നേക്കുമുള്ള ഒരു അനുഷ്ഠാനമാണ്. ");
INSERT INTO malc_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","നിങ്ങൾ ഏഴുദിവസം പുളിപ്പില്ലാത്ത അപ്പം ഭക്ഷിക്കണം. ഒന്നാംദിവസം നിങ്ങൾ ഭവനങ്ങളിൽനിന്ന് പുളിമാവു നീക്കംചെയ്യണം. ഒന്നാംദിവസംമുതൽ ഏഴാംദിവസംവരെ പുളിപ്പോടുകൂടിയതെന്തെങ്കിലും ഭക്ഷിക്കുന്ന ഏതൊരുവനെയും ഇസ്രായേലിൽനിന്ന് ഛേദിച്ചുകളയേണ്ടതാണ്. ");
INSERT INTO malc_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ഒന്നാംദിവസം വിശുദ്ധസഭായോഗം കൂടണം. ഏഴാംദിവസം വീണ്ടും സഭകൂടണം. അവരവർക്കുവേണ്ട ആഹാരം പാകംചെയ്യുകയല്ലാതെ മറ്റൊരു ജോലിയും ഈ ദിവസങ്ങളിൽ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“നിങ്ങൾ പുളിപ്പില്ലാത്ത അപ്പത്തിന്റെ പെരുന്നാൾ ആഘോഷിക്കണം, എന്തുകൊണ്ടെന്നാൽ, ഈ ദിവസത്തിലാണ് ഞാൻ നിങ്ങളുടെ സമൂഹത്തെ ഈജിപ്റ്റിൽനിന്ന് വിടുവിച്ചുകൊണ്ടുപോന്നത്. വരുംതലമുറകൾക്ക് എന്നെന്നേക്കുമുള്ള ഒരു അനുഷ്ഠാനമായി ഈ ദിവസം നിങ്ങൾ ആചരിക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ഒന്നാംമാസം പതിന്നാലാംതീയതി സന്ധ്യമുതൽ ഇരുപത്തിയൊന്നാംതീയതി സന്ധ്യവരെ നിങ്ങൾ പുളിപ്പില്ലാത്ത അപ്പം ഭക്ഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ഏഴുദിവസത്തേക്ക് നിങ്ങളുടെ ഭവനങ്ങളിൽ പുളിമാവ് ഉണ്ടായിരിക്കരുത്. പുളിപ്പുള്ളത് എന്തെങ്കിലും ആരെങ്കിലും ഭക്ഷിച്ചാൽ, അയാൾ വിദേശിയായാലും സ്വദേശിയായാലും, ഇസ്രായേല്യസമൂഹത്തിൽനിന്ന് അയാളെ ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","പുളിച്ചത് യാതൊന്നും ഭക്ഷിക്കരുത്. നിങ്ങളുടെ താമസസ്ഥലങ്ങളിലെല്ലാം പുളിപ്പില്ലാത്ത അപ്പം ഭക്ഷിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ഇതിനുശേഷം മോശ ഇസ്രായേലിലെ സകലഗോത്രത്തലവന്മാരെയും കൂട്ടിവരുത്തി അവരോട് ഇങ്ങനെ പ്രസ്താവിച്ചു: “നിങ്ങൾ ഉടൻതന്നെ പോയി നിങ്ങളുടെ കുടുംബങ്ങൾക്കൊത്തവണ്ണം ആട്ടിൻകുട്ടിയെ തെരഞ്ഞെടുത്ത് പെസഹാക്കുഞ്ഞാടിനെ അറക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ഈസോപ്പുചെടിയുടെ ഒരു കെട്ടെടുത്ത് കിണ്ണത്തിലെ രക്തത്തിൽ മുക്കി കട്ടിളക്കാലുകളിൽ രണ്ടിലും കട്ടിളകളുടെ മീതേയുള്ള പടിയിലും തേയ്ക്കണം. നിങ്ങളിൽ ആരും നേരംപുലരുംവരെ വീടിന്റെ വാതിലിനു പുറത്തിറങ്ങരുത്. ");
INSERT INTO malc_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","യഹോവ ഈജിപ്റ്റുകാരെ ദണ്ഡിപ്പിക്കുന്നതിനു ദേശത്തുകൂടി കടന്നുപോകുമ്പോൾ, കട്ടിളക്കാലുകളിലും കട്ടിളകളുടെ മീതേയുള്ള പടിയിലും രക്തം കാണുകയും ആ വാതിൽ ഒഴിഞ്ഞു കടന്നുപോകുകയും ചെയ്യും; നിങ്ങളെ സംഹരിക്കാൻ നിങ്ങളുടെ വീടുകളിൽ പ്രവേശിക്കുന്നതിന് അവിടന്നു സംഹാരകനെ അനുവദിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“നിങ്ങൾക്കും നിങ്ങളുടെ പിൻഗാമികൾക്കുംവേണ്ടിയുള്ള ശാശ്വതമായ നിയമമായി ഈ നിർദേശങ്ങൾ പാലിക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","യഹോവ നിങ്ങൾക്കു നൽകുമെന്നു വാഗ്ദാനംചെയ്തിരിക്കുന്ന ദേശത്തു പ്രവേശിച്ചശേഷം ഇത് അനുഷ്ഠിക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","‘ഈ അനുഷ്ഠാനംകൊണ്ട് എന്താണ് ഉദ്ദേശിക്കുന്നത്?’ എന്നു നിങ്ങളുടെ മക്കൾ നിങ്ങളോടു ചോദിക്കുമ്പോൾ, ");
INSERT INTO malc_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","‘ഈജിപ്റ്റിൽവെച്ച് ഇസ്രായേല്യരുടെ ഭവനങ്ങളെ വിട്ടു കടന്നുപോകുകയും ഈജിപ്റ്റുകാരെ ദണ്ഡിപ്പിച്ചപ്പോൾ നമ്മുടെ വീടുകളെ ഒഴിവാക്കുകയുംചെയ്ത യഹോവയ്ക്കുള്ള പെസഹായാഗമാണിത്,’ എന്നു നിങ്ങൾ അവരോടു പറയുക.” അപ്പോൾ ജനം കുമ്പിട്ട് ആരാധിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","യഹോവ മോശയോടും അഹരോനോടും കൽപ്പിച്ചിരുന്നതുപോലെതന്നെ ഇസ്രായേൽമക്കൾ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","അർധരാത്രിയിൽ യഹോവ ഈജിപ്റ്റിലെ സകലകടിഞ്ഞൂലുകളെയും— സിംഹാസനത്തിൽ ഇരുന്ന ഫറവോന്റെ ആദ്യജാതൻമുതൽ കാരാഗൃഹത്തിൽ കിടന്ന തടവുകാരന്റെ ആദ്യജാതൻവരെയുള്ള സർവ കടിഞ്ഞൂലുകളെയും സകല ആടുമാടുകളുടെ കടിഞ്ഞൂലുകളെയും—സംഹരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ഫറവോനും അയാളുടെ ഉദ്യോഗസ്ഥന്മാരെല്ലാവരും സകല ഈജിപ്റ്റുകാരും രാത്രിയിൽ ഉണർന്നെഴുന്നേറ്റു; ഈജിപ്റ്റിൽ വലിയൊരു നിലവിളി ഉണ്ടായി; ഒരാളെങ്കിലും മരിക്കാത്ത ഒരു വീടും ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ഫറവോൻ രാത്രിയിൽ മോശയെയും അഹരോനെയും ആളയച്ചുവരുത്തി, “നിങ്ങളും ഇസ്രായേല്യരും എഴുന്നേറ്റ് എന്റെ ജനത്തെ വിട്ടുപോകുക. നിങ്ങൾ അപേക്ഷിച്ചതുപോലെ പോയി യഹോവയെ ആരാധിക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","നിങ്ങൾ പറഞ്ഞതുപോലെ നിങ്ങളുടെ ആട്ടിൻപറ്റങ്ങളെയും കന്നുകാലികളെയും കൂട്ടിക്കൊണ്ടു പൊയ്ക്കൊള്ളൂ. എന്നെ അനുഗ്രഹിക്കുകയും ചെയ്യുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","എത്രയുംവേഗം ദേശം വിട്ടുപോകാൻ ഈജിപ്റ്റുകാർ ജനങ്ങളെ നിർബന്ധിച്ചു. “അല്ലാത്തപക്ഷം ഞങ്ങൾ എല്ലാവരും മരിച്ചുപോകും,” എന്ന് അവർ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","അതുകൊണ്ടു ജനം അവരുടെ കുഴച്ച മാവ് പുളിക്കുന്നതിനുമുമ്പുതന്നെ തൊട്ടികളിലെടുത്ത് അവ തുണിയിൽ പൊതിഞ്ഞു തോളിൽ കയറ്റി. ");
INSERT INTO malc_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","മോശ നിർദേശിച്ചതനുസരിച്ച് ഇസ്രായേല്യർ പ്രവർത്തിച്ചു; അവർ ഈജിപ്റ്റുകാരോടു വെള്ളിയും സ്വർണവുംകൊണ്ടുള്ള സാധനങ്ങളും വസ്ത്രങ്ങളും ആവശ്യപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ജനങ്ങളുടെനേർക്ക് ഈജിപ്റ്റുകാർക്ക് അനുകൂലഭാവം ഉണ്ടാകാൻ യഹോവ ഇടയാക്കി; അവർ തങ്ങളോട് ആവശ്യപ്പെട്ടതെല്ലാം അവർക്കു കൊടുത്തു; അങ്ങനെ അവർ ഈജിപ്റ്റുകാരെ കൊള്ളയിട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ഇസ്രായേല്യർ രമെസേസിൽനിന്ന് സൂക്കോത്തിലേക്കു കാൽനടയായി യാത്രചെയ്തു; അവർ സ്ത്രീകളെയും കുട്ടികളെയുംകൂടാതെ ഏകദേശം ആറുലക്ഷം പുരുഷന്മാരാണ് കാൽനടയായി പുറപ്പെട്ടത്. ");
INSERT INTO malc_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ഒരു സമ്മിശ്രപുരുഷാരവും ആട്ടിൻപറ്റങ്ങൾ, കന്നുകാലിക്കൂട്ടങ്ങൾ എന്നിവ അടങ്ങുന്ന വിപുലമായ മൃഗസഞ്ചയവും അവരോടുകൂടെ പോയി. ");
INSERT INTO malc_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","അവർ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന മാവുകൊണ്ടു പുളിപ്പില്ലാത്ത അപ്പം ചുട്ടു. അവരെ തിടുക്കത്തിൽ ഈജിപ്റ്റിൽനിന്ന് ഓടിച്ചുവിട്ടതുകൊണ്ട് മാവു പുളിച്ചിരുന്നില്ല. യാത്രയ്ക്കുവേണ്ട ഭക്ഷണം അവർ കരുതിയിരുന്നുമില്ല. ");
INSERT INTO malc_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ഇസ്രായേൽജനം ഈജിപ്റ്റിൽ താമസിച്ചിരുന്ന കാലഘട്ടം 430 വർഷം ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ആ 430 വർഷം തീരുന്ന ദിവസംതന്നെ യഹോവയുടെ സൈന്യം എല്ലാം ഈജിപ്റ്റ് വിട്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","അവരെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചുകൊണ്ടുപോന്നതിനാൽ യഹോവയ്ക്കു പ്രത്യേകമായി ആചരിക്കേണ്ട രാത്രിയാണ് അത്. ഇസ്രായേല്യർ എല്ലാവരും തലമുറതലമുറയായി വളരെ ജാഗ്രതയോടെ ഈ രാത്രി ആചരിക്കേണ്ടതാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: “പെസഹായ്ക്കുള്ള നിബന്ധനകൾ ഇവയാകുന്നു: “ഒരു വിദേശിയും ഇതിൽനിന്ന് ഭക്ഷിക്കാൻ പാടില്ല. ");
INSERT INTO malc_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","നീ വിലയ്ക്കു വാങ്ങിയിട്ടുള്ള ഏതൊരു അടിമയ്ക്കും അവൻ പരിച്ഛേദനം ഏറ്റതിനുശേഷം, ഇതിൽനിന്ന് ഭക്ഷിക്കാവുന്നതാണ്. ");
INSERT INTO malc_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","എന്നാൽ തൽക്കാലത്തേക്കു വന്നു താമസിക്കുന്നവനും കൂലിക്കാരനും ഇതു ഭക്ഷിക്കാൻ പാടില്ല. ");
INSERT INTO malc_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“വീടിനുള്ളിൽവെച്ചായിരിക്കണം ഇതു ഭക്ഷിക്കുന്നത്; മാംസത്തിൽ അൽപ്പംപോലും വീടിനു പുറത്തേക്കു കൊണ്ടുപോകരുത്; അതിൽ ഒരസ്ഥിയും ഒടിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ഇസ്രായേല്യസമൂഹം ഒന്നാകെ ഇത് ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“നിങ്ങളുടെ ഇടയിൽ വന്നുതാമസിക്കുന്ന വിദേശി യഹോവയുടെ പെസഹ ആചരിക്കാൻ ആഗ്രഹിക്കുന്നെങ്കിൽ തന്റെ കുടുംബത്തിലുള്ള സകലപുരുഷന്മാർക്കും പരിച്ഛേദനം നടത്തിയിരിക്കണം; പിന്നെ അവന്, സ്വദേശത്തു ജനിച്ച ഒരുവനെപ്പോലെ ഇതിൽ പങ്കെടുക്കാം. പരിച്ഛേദനമേൽക്കാത്ത യാതൊരു പുരുഷനും ഇതു ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","സ്വദേശിക്കും നിങ്ങളുടെ ഇടയിൽ വന്നുപാർക്കുന്ന വിദേശിക്കും ഈ നിയമം ഒരുപോലെ ബാധകമായിരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","യഹോവ മോശയോടും അഹരോനോടും കൽപ്പിച്ചതുപോലെതന്നെ ഇസ്രായേൽമക്കൾ എല്ലാവരും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","യഹോവ ആ ദിവസംതന്നെ ഇസ്രായേല്യരെ ഗണംഗണമായി ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","യഹോവ മോശയോട്, ");
INSERT INTO malc_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“സകല ആദ്യജാതന്മാരെയും എനിക്കായി ശുദ്ധീകരിക്കുക. മനുഷ്യരുടേതാകട്ടെ, മൃഗങ്ങളുടേതാകട്ടെ, ഇസ്രായേൽമക്കളുടെ ഇടയിലുള്ള എല്ലാ കടിഞ്ഞൂലുകളും എനിക്കുള്ളതാകുന്നു” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","അപ്പോൾ മോശ ജനത്തോടു പറഞ്ഞു, “അടിമദേശമായ ഈജിപ്റ്റിൽനിന്ന് യഹോവ ശക്തമായ ഭുജത്താൽ നിങ്ങളെ വിടുവിച്ചുകൊണ്ടുപോന്നതിനാൽ നിങ്ങൾ അവിടെനിന്നു പുറപ്പെട്ട ഈ ദിവസത്തിന്റെ ഓർമ നിലനിർത്തണം. പുളിപ്പുള്ള യാതൊന്നും നിങ്ങൾ തിന്നരുത്. ");
INSERT INTO malc_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ആബീബുമാസം ഈ ദിവസത്തിലാണ് നിങ്ങൾ വിട്ടുപോന്നത്. ");
INSERT INTO malc_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","യഹോവ നിങ്ങളെ കനാന്യർ, ഹിത്യർ, അമോര്യർ, ഹിവ്യർ, യെബൂസ്യർ എന്നിവരുടെ ദേശത്ത്, പാലും തേനും ഒഴുകുന്നതും നിനക്കു തരുമെന്നു നിന്റെ പിതാക്കന്മാരോട് അവിടന്നു വാഗ്ദാനംചെയ്തതുമായ ദേശത്ത്, കൊണ്ടുചെന്നതിനുശേഷം ഈ മാസത്തിൽ നിങ്ങൾ ഈ കർമം ആചരിക്കണം: ");
INSERT INTO malc_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ഏഴുദിവസം പുളിപ്പില്ലാത്ത അപ്പം തിന്നുകയും ഏഴാംദിവസം യഹോവയ്ക്ക് ഒരു ഉത്സവം ആചരിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ആ ഏഴുദിവസവും നീ പുളിപ്പില്ലാത്ത അപ്പമാണു തിന്നേണ്ടത്; പുളിപ്പുള്ള ഒന്നുംതന്നെ നിന്റെ പക്കൽ കാണരുത്, നിന്റെ അതിരുകൾക്കുള്ളിൽ ഒരിടത്തും പുളിമാവ് അശേഷം കാണരുത്. ");
INSERT INTO malc_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","അന്നു നീ നിന്റെ മകനോട്, ഞാൻ ഈജിപ്റ്റിൽനിന്ന് പോന്ന ദിവസം യഹോവ എനിക്കുവേണ്ടി ചെയ്ത കാര്യം നിമിത്തമാണു ഞാൻ ഇങ്ങനെ ചെയ്യുന്നതെന്നു പറയണം. ");
INSERT INTO malc_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","യഹോവയുടെ ന്യായപ്രമാണം നിന്റെ അധരങ്ങളിൽ എപ്പോഴും ഉണ്ടായിരിക്കേണ്ടതിന് ഈ അനുഷ്ഠാനം നിന്റെ കൈമേൽ ഒരു ചിഹ്നവും നെറ്റിയിൽ ഒരു സ്മാരകവും ആയിരിക്കണം; യഹോവ തന്റെ ശക്തിയുള്ള കരത്താൽ നിന്നെ ഈജിപ്റ്റിൽനിന്ന് വിടുവിച്ചു കൊണ്ടുവന്നുവല്ലോ. ");
INSERT INTO malc_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","നീ ഓരോവർഷവും നിശ്ചിതസമയത്ത് ഈ അനുഷ്ഠാനം ആചരിച്ചുകൊള്ളണം. ");
INSERT INTO malc_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“യഹോവ നിന്നോടും നിന്റെ പിതാക്കന്മാരോടും ആണയിട്ടു വാഗ്ദാനം ചെയ്തിട്ടുള്ളതുപോലെ, നിന്നെ കനാന്യരുടെ ദേശത്തു കൊണ്ടുവന്ന് അവിടം നിനക്കു നൽകുമ്പോൾ ");
INSERT INTO malc_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","നീ സകലകടിഞ്ഞൂലുകളെയും യഹോവയ്ക്കു വേർതിരിക്കേണ്ടതാകുന്നു. നിന്റെ ആടുമാടുകളുടെ സകല ആൺകടിഞ്ഞൂലുകളും യഹോവയ്ക്കുള്ളതാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","കഴുതകളുടെ കടിഞ്ഞൂലുകളിൽ ഓരോന്നിനെയും ആട്ടിൻകുട്ടിയെക്കൊണ്ടു വീണ്ടെടുക്കണം. അതിനെ വീണ്ടെടുക്കുന്നില്ലെങ്കിൽ അതിന്റെ കഴുത്ത് ഒടിച്ചുകളയണം. നിന്റെ പുത്രന്മാരിൽ ആദ്യജാതന്മാരായ എല്ലാവരെയും വീണ്ടെടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“ഭാവികാലത്തു നിന്റെ മകൻ നിന്നോട്, ‘ഇതിന്റെ അർഥം എന്താകുന്നു?’ എന്നു ചോദിക്കുമ്പോൾ നീ അവനോടു പറയുക: ‘യഹോവ നമ്മെ ബലമുള്ള കൈയാൽ അടിമനാടായ ഈജിപ്റ്റിൽനിന്ന് വിടുവിച്ചുകൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","നമ്മെ വിട്ടയയ്ക്കുകയില്ല എന്നു ഫറവോൻ ശാഠ്യംപിടിച്ചപ്പോൾ യഹോവ ഈജിപ്റ്റിലെ സകലമനുഷ്യരുടെയും മൃഗങ്ങളുടെയും കടിഞ്ഞൂലുകളെയെല്ലാം കൊന്നുകളഞ്ഞു. അതുകൊണ്ടാണ് ഞാൻ കടിഞ്ഞൂലായ ആണിനെയെല്ലാം യഹോവയ്ക്ക് അർപ്പിക്കുകയും എന്റെ ആദ്യജാതന്മാരെ എല്ലാവരെയും വീണ്ടെടുക്കുകയും ചെയ്യുന്നത്.’ ");
INSERT INTO malc_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","യഹോവ തന്റെ ബലമുള്ള കരത്താൽ നമ്മെ ഈജിപ്റ്റിൽനിന്ന് വിടുവിച്ചുകൊണ്ടുവന്നു എന്നത്, നിന്റെ കൈമേൽ ഒരു ചിഹ്നവും നെറ്റിത്തടത്തിൽ ഒരു മുദ്രയും ആയിരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ഫറവോൻ ജനത്തെ വിട്ടയച്ചപ്പോൾ, ഫെലിസ്ത്യദേശത്തുകൂടിയുള്ള വഴി ദൂരം കുറഞ്ഞതായിരുന്നെങ്കിലും ദൈവം അവരെ ആ വഴിയിൽക്കൂടി നടത്തിയില്ല. “യുദ്ധം നേരിട്ടാൽ അവർക്കു മനംമാറ്റം ഉണ്ടാകുകയും അവർ ഈജിപ്റ്റിലേക്കു മടങ്ങുകയും ചെയ്തേക്കാം,” എന്നു ദൈവം കരുതി. ");
INSERT INTO malc_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ആകയാൽ ദൈവം ജനത്തെ ചെങ്കടലിനരികെയുള്ള മരുഭൂമിയിൽ വലയംചെയ്യിച്ചു. ഇസ്രായേല്യർ ഈജിപ്റ്റിൽനിന്ന് യുദ്ധസന്നദ്ധരായി പുറപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","യോസേഫിന്റെ അസ്ഥികളും മോശ എടുത്തിരുന്നു. കാരണം, “നിങ്ങളെ സഹായിക്കാൻ ദൈവം നിശ്ചയമായും വരും. അപ്പോൾ നിങ്ങൾ ഈ സ്ഥലത്തുനിന്ന് എന്റെ അസ്ഥികൾ കൊണ്ടുപോകണം” എന്ന് ഇസ്രായേലിന്റെ പുത്രന്മാരെക്കൊണ്ട് യോസേഫ് ശപഥംചെയ്യിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","അവർ സൂക്കോത്തിൽനിന്ന് പുറപ്പെട്ട് മരുഭൂമിയുടെ അരികിലുള്ള ഏഥാമിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","യഹോവ അവരെ വഴികാണിക്കാൻ പകൽസമയത്ത് ഒരു മേഘത്തൂണിലും രാത്രിയിൽ വെളിച്ചംകൊടുക്കാൻ അഗ്നിത്തൂണിലുമായി അവർക്കുമുമ്പേ സഞ്ചരിച്ചു; അങ്ങനെ അവർക്കു പകലും രാത്രിയും യാത്രചെയ്യാൻ കഴിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","പകൽ മേഘസ്തംഭവും രാത്രി അഗ്നിസ്തംഭവും ജനത്തിന്റെ മുന്നിൽനിന്ന് മാറിയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ഇതിനുശേഷം യഹോവ മോശയോട് അരുളിച്ചെയ്തത്, ");
INSERT INTO malc_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“നിങ്ങൾ തിരിഞ്ഞു മിഗ്ദോലിനും കടലിനും ഇടയ്ക്കുള്ള പീ-ഹഹീരോത്തിൽ പാളയമടിക്കണമെന്ന് ഇസ്രായേൽമക്കളോടു പറയുക. അവർ ബാൽ-സെഫോനുനേരേ എതിർവശത്തു കടലിനരികെ താവളമടിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","‘ഇസ്രായേല്യർ മരുഭൂമിയിൽ കുടുങ്ങി, വഴിയറിയാതെ ദേശത്തെല്ലാം അലഞ്ഞുതിരിയുകയാണ്’ എന്നു ഫറവോൻ ചിന്തിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ഞാൻ ഫറവോന്റെ ഹൃദയം കഠിനമാക്കുകയും അവൻ അവരെ പിൻതുടരുകയും ചെയ്യും. എന്നാൽ ഫറവോനിലൂടെയും അവന്റെ സൈന്യത്തിലൂടെയും ഞാൻ എന്നെത്തന്നെ മഹത്ത്വപ്പെടുത്തും; ഞാൻ യഹോവ എന്ന് ഈജിപ്റ്റുകാർ അറിയും.” ആകയാൽ ഇസ്രായേല്യർ അങ്ങനെ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ജനം ഓടിപ്പോയിരിക്കുന്നു എന്ന് ഈജിപ്റ്റിലെ രാജാവ് കേട്ടപ്പോൾ ഫറവോനും അദ്ദേഹത്തിന്റെ ഉദ്യോഗസ്ഥരും അവരോടുള്ള മനോഭാവം മാറ്റി, “നാം ഈ ചെയ്തതെന്ത്? നമ്മുടെ അടിമവേലയിൽനിന്ന് ഇസ്രായേല്യരെ വിട്ടയച്ചല്ലോ” എന്ന് അവർ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","അങ്ങനെ ഫറവോൻ തന്റെ രഥം സജ്ജമാക്കി, സൈന്യത്തെയും തന്നോടൊപ്പം അണിനിരത്തി. ");
INSERT INTO malc_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ഈജിപ്റ്റിലെ സകലരഥങ്ങളോടുംകൂടെ, ഏറ്റവും മികച്ച അറുനൂറു രഥങ്ങളെയും അവയിൽ എല്ലാറ്റിലും തേരാളികളെയും അദ്ദേഹം ഒരുക്കി. ");
INSERT INTO malc_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","യഹോവ ഈജിപ്റ്റുരാജാവായ ഫറവോന്റെ ഹൃദയം കഠിനമാക്കിയതുകൊണ്ട്, യുദ്ധസന്നദ്ധരായി പുറപ്പെട്ടിരുന്ന ഇസ്രായേൽജനത്തെ അയാൾ പിൻതുടർന്നു. ");
INSERT INTO malc_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ഈജിപ്റ്റുകാർ—ഫറവോന്റെ സകലകുതിരകളും രഥങ്ങളും കുതിരപ്പടയും സൈന്യവും—ഇസ്രായേല്യരെ പിൻതുടരുകയും ബാൽ-സെഫോന് എതിരേ, പീ-ഹഹീരോത്തിനടുത്ത്, കടൽക്കരയിൽ പാളയമടിച്ചിരുന്ന അവരെ മറികടക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ഫറവോൻ സമീപിച്ചപ്പോൾ ഇസ്രായേല്യർ തലയുയർത്തിനോക്കി. ഈജിപ്റ്റുകാർ അവർക്കു പിന്നാലെ വരുന്നതു കണ്ടു. ഇസ്രായേൽമക്കൾ ഭയപ്പെട്ട് യഹോവയോടു നിലവിളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","അവർ മോശയോട്, “ഈജിപ്റ്റിൽ ശവക്കുഴികൾ ഇല്ലാഞ്ഞിട്ടോ നീ ഞങ്ങളെ മരിക്കാൻ മരുഭൂമിയിൽ കൊണ്ടുവന്നത്? ഞങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചിട്ട്, നീ ഞങ്ങളോട് ഈ ചെയ്തതെന്ത്? ");
INSERT INTO malc_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","‘ഞങ്ങളെ വെറുതേവിട്ടേക്കുക, ഞങ്ങൾ ഈജിപ്റ്റുകാരെ സേവിച്ചുകൊള്ളാം’ എന്ന് ഈജിപ്റ്റിൽവെച്ചു നിന്നോടു ഞങ്ങൾ പറഞ്ഞില്ലേ? മരുഭൂമിയിൽ മരിക്കുന്നതിനെക്കാൾ ഈജിപ്റ്റുകാർക്കുവേണ്ടി പണിയെടുക്കുന്നതായിരുന്നു ഞങ്ങൾക്കു നല്ലത്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","അതിന് മോശ ജനത്തോട് ഇങ്ങനെ ഉത്തരം പറഞ്ഞു, “ഭയപ്പെടരുത്, സ്ഥിരതയോടെ നിൽക്കുക. യഹോവ ഇന്നു നിങ്ങൾക്കു നൽകുന്ന വിടുതൽ കണ്ടുകൊള്ളുക. നിങ്ങൾ ഇന്നു കാണുന്ന ഈജിപ്റ്റുകാരെ ഇനിയൊരിക്കലും കാണുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","യഹോവ നിങ്ങൾക്കുവേണ്ടി യുദ്ധംചെയ്യും; നിങ്ങൾ ശാന്തരായിരിക്കുക.” ");
INSERT INTO malc_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ഇതിനെത്തുടർന്ന് യഹോവ മോശയോട് അരുളിച്ചെയ്തത്, “നീ എന്നോടു നിലവിളിക്കുന്നതെന്ത്? മുമ്പോട്ടുപോകാൻ ജനങ്ങളോടു പറയുക. ");
INSERT INTO malc_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ഇസ്രായേൽമക്കൾക്കു സമുദ്രത്തിന്റെ ഉണങ്ങിയ നിലത്തുകൂടി പോകാൻ സാധിക്കത്തക്കവണ്ണം നിന്റെ വടി ഉയർത്തി കടലിന്മേൽ കൈനീട്ടി വെള്ളത്തെ വിഭജിക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","18","ഞാൻ ഈജിപ്റ്റുകാരുടെ ഹൃദയം കഠിനമാക്കുകയും അവർ അവരുടെ പിന്നാലെ ചെല്ലുകയും ചെയ്യും. ഫറവോനിലൂടെയും അവന്റെ സൈന്യത്തിലൂടെയും രഥങ്ങളിലൂടെയും കുതിരപ്പടയിലൂടെയും ഞാൻ മഹത്ത്വം നേടുമ്പോൾ, ഞാൻ യഹോവ എന്ന് ഈജിപ്റ്റുകാർ അറിയും.” ");
INSERT INTO malc_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ഇസ്രായേലിന്റെ സൈന്യത്തിനുമുമ്പിൽ സഞ്ചരിച്ചിരുന്ന ദൈവദൂതൻ അപ്പോൾ പിൻവാങ്ങി അവരുടെ പിന്നിൽ നടന്നു. മേഘസ്തംഭവും അവരുടെമുമ്പിൽനിന്ന് പിന്നിലേക്കു നീങ്ങി. ");
INSERT INTO malc_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","അത് ഈജിപ്റ്റിന്റെ സൈന്യത്തിനും ഇസ്രായേലിന്റെ സൈന്യത്തിനും ഇടയിൽവന്നു നിലകൊണ്ടു. രാത്രിമുഴുവൻ ഇസ്രായേല്യരുടെ സൈന്യവും ഈജിപ്റ്റുകാരുടെ സൈന്യവുംതമ്മിൽ അടുക്കാത്തവണ്ണം അത് അവരുടെ മധ്യേനിന്നു. ഈജിപ്റ്റുകാർക്ക് അതു മേഘവും അന്ധകാരവും ഇസ്രായേല്യർക്കു പ്രകാശവും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","പിന്നെ മോശ കടലിന്മേൽ കൈനീട്ടി; യഹോവ അന്നു രാത്രിമുഴുവൻ ശക്തമായ ഒരു കിഴക്കൻകാറ്റ് അടിപ്പിച്ചു. കടൽ പിൻവാങ്ങി ഉണങ്ങിയ നിലം ആയിത്തീർന്നു; വെള്ളം വേർപിരിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ഇസ്രായേല്യർ സമുദ്രത്തിൽ ഉണങ്ങിയ നിലത്തുകൂടി നടന്നു; വെള്ളം അവരുടെ വലത്തും ഇടത്തും മതിലായി നിന്നു. ");
INSERT INTO malc_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ഈജിപ്റ്റുകാർ അവരെ പിൻതുടർന്നു; ഫറവോന്റെ കുതിരകളും രഥങ്ങളും കുതിരപ്പടയുമെല്ലാം അവരെ പിൻതുടർന്നു കടലിന്റെ നടുവിലേക്കു ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","പ്രഭാതയാമത്തിൽ യഹോവ അഗ്നിമേഘസ്തംഭത്തിൽനിന്ന് താഴേക്കു നോക്കി ഈജിപ്റ്റുസൈന്യത്തിനു വിഭ്രമം വരുത്തി. ");
INSERT INTO malc_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","അവിടന്ന് അവരുടെ രഥചക്രങ്ങൾ ഇടറിപ്പോകാൻ ഇടയാക്കിയതുകൊണ്ട് അവയ്ക്കു മുന്നോട്ടുപോകാൻ പ്രയാസമായി. “നമുക്ക് ഇസ്രായേല്യരെ വിട്ട് ഓടിപ്പോകാം, യഹോവ അവർക്കുവേണ്ടി ഈജിപ്റ്റിനെതിരേ യുദ്ധംചെയ്യുന്നു,” എന്ന് അവർ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","അപ്പോൾ യഹോവ മോശയോട്, “വെള്ളം തിരിച്ചൊഴുകി ഈജിപ്റ്റുകാരെയും അവരുടെ തേരുകളും കുതിരപ്പടയും മൂടിക്കളയേണ്ടതിനു നീ കടലിന്മേൽ കൈനീട്ടുക” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","മോശ കടലിനുമീതേ കൈനീട്ടി. നേരം പുലർന്നപ്പോൾ സമുദ്രം പൂർവസ്ഥിതിയിലായി. ഈജിപ്റ്റുകാർ അതിനെതിരേ ഓടി. യഹോവ അവരെ കടലിലേക്കു തള്ളിയിട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","വെള്ളം തിരിച്ചൊഴുകി രഥങ്ങളെയും കുതിരപ്പടയെയും, ഇസ്രായേല്യരെ പിൻതുടർന്നു സമുദ്രത്തിലെത്തിയ ഫറവോന്റെ മുഴുവൻ സൈന്യത്തെയും മുക്കിക്കളഞ്ഞു. അവരിൽ ഒരുവനും ജീവനോടെ ശേഷിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","എന്നാൽ ഇസ്രായേൽമക്കൾ സമുദ്രത്തിൽ, ഉണങ്ങിയ നിലത്തുകൂടി കടന്നുപോയി. അവരുടെ വലത്തും ഇടത്തും വെള്ളം മതിലായി നിലകൊണ്ടു. ");
INSERT INTO malc_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ആ ദിവസം യഹോവ ഇസ്രായേലിനെ ഈജിപ്റ്റുകാരുടെ കൈകളിൽനിന്ന് രക്ഷിച്ചു; ഈജിപ്റ്റുകാർ കടൽക്കരയിൽ ചത്തടിഞ്ഞു കിടക്കുന്നത് ഇസ്രായേല്യർ കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","മഹാശക്തിയുള്ള യഹോവയുടെ കരം ഈജിപ്റ്റുകാർക്കെതിരായി പ്രവർത്തിക്കുന്നത് ഇസ്രായേൽമക്കൾ കണ്ടപ്പോൾ, ജനം യഹോവയെ ഭയപ്പെട്ട് യഹോവയിലും അവിടത്തെ ദാസനായ മോശയിലും വിശ്വസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ഈ സംഭവത്തിനുശേഷം മോശയും ഇസ്രായേൽമക്കളും യഹോവയ്ക്ക് ഈ ഗീതം ആലപിച്ചു: “ഞാൻ യഹോവയ്ക്കു പാടും, അവിടന്ന് പരമോന്നതനല്ലോ. അശ്വത്തെയും അശ്വാരൂഢനെയും അവിടന്ന് ആഴിയിലേക്ക് ചുഴറ്റിയെറിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“യഹോവ എന്റെ ബലവും എന്റെ ഗീതവും ആകുന്നു; അവിടന്ന് എന്റെ രക്ഷയായിരിക്കുന്നു. അവിടന്ന് എന്റെ ദൈവം, ഞാൻ അവിടത്തെ സ്തുതിക്കും. അവിടന്ന് എന്റെ പിതാവിന്റെ ദൈവം, ഞാൻ അവിടത്തെ പുകഴ്ത്തും. ");
INSERT INTO malc_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","യഹോവ യുദ്ധവീരനാകുന്നു; യഹോവ എന്നാകുന്നു അവിടത്തെ നാമം. ");
INSERT INTO malc_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ഫറവോന്റെ രഥങ്ങളെയും അയാളുടെ സൈന്യത്തെയും അവിടന്നു സമുദ്രത്തിൽ എറിഞ്ഞുകളഞ്ഞിരിക്കുന്നു. ഫറവോന്റെ സൈന്യാധിപന്മാരിൽ മികവുറ്റവർ ചെങ്കടലിൽ മുങ്ങിത്താണുപോയി. ");
INSERT INTO malc_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","അഗാധജലം അവരെ മൂടിക്കളഞ്ഞു; അവർ കല്ലുപോലെ ആഴങ്ങളിലേക്കു താണുപോയി. ");
INSERT INTO malc_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","യഹോവേ, അവിടത്തെ വലങ്കൈ അത്യന്തം ശ്രേഷ്ഠവും ബലവും ഉള്ളത്! യഹോവേ, അവിടത്തെ വലങ്കൈ ശത്രുവിനെ ചിതറിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“അവിടത്തോട് എതിർത്തവരെ അവിടത്തെ രാജകീയ പ്രഭാവത്താൽ അങ്ങ് വീഴ്ത്തിക്കളഞ്ഞു. അവിടന്നു ക്രോധാഗ്നി അയച്ചു; അതു വൈക്കോൽക്കുറ്റിപോലെ അവരെ ദഹിപ്പിച്ചുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","അവിടത്തെ ശക്തമായ ഉച്ഛ്വാസത്താൽ വെള്ളം കൂമ്പാരമായി ഉയർന്നു; ഇരച്ചുകയറുന്ന ജലപ്രവാഹങ്ങൾ മതിൽപോലെ ഉറച്ചുനിന്നു; അഗാധപ്രവാഹങ്ങൾ ആഴിയുടെ അന്തർഭാഗത്ത് ഉറഞ്ഞുപോയി. ");
INSERT INTO malc_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","‘ഞാൻ പിൻതുടരും, ഞാൻ അവരെ കീഴടക്കും,’ എന്നു ശത്രു അഹങ്കരിച്ചു. ‘കൊള്ളമുതൽ പങ്കിടും, ഞാൻതന്നെ അവരെ വിഴുങ്ങിക്കളയും, എന്റെ വാൾ ഊരിയെടുത്ത് എന്റെ കൈകൊണ്ടുതന്നെ അവരെ നശിപ്പിക്കും എന്നുംതന്നെ.’ ");
INSERT INTO malc_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","എന്നാൽ, അവിടന്നു തന്റെ ശ്വാസത്താൽ അവരെ ഊതിപ്പറപ്പിച്ചു; സമുദ്രം അവരെ മൂടിക്കളഞ്ഞു. അവർ ഈയംപോലെ ആഴിയിൽ ആഴ്ന്നുപോയി. ");
INSERT INTO malc_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","യഹോവേ, ദേവന്മാരിൽ അവിടത്തേക്കു സദൃശനായി ആരുള്ളൂ? വിശുദ്ധിയിൽ രാജപ്രൗഢിയുള്ളവൻ! തേജസ്സിൽ ഭയങ്കരൻ! അത്ഭുതങ്ങൾ പ്രവർത്തിക്കുന്നവൻ! അങ്ങേക്കു തുല്യനായി ആരുള്ളൂ? ");
INSERT INTO malc_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“അവിടന്നു വലങ്കൈ നീട്ടുകയും ഭൂമി അവരെ വിഴുങ്ങുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","അവിടന്നു വീണ്ടെടുത്ത ജനത്തെ ആർദ്രസ്നേഹത്തോടെ അങ്ങു നയിക്കും. അവിടത്തെ വിശുദ്ധനിവാസത്തിലേക്ക് അവരെ സ്വന്തം ശക്തിയാൽ അവിടന്നു വഴിനടത്തും. ");
INSERT INTO malc_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ജനതകൾ കേട്ടു വിറയ്ക്കും, ഫെലിസ്ത്യനിവാസികൾക്കു ഭീതിപിടിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ഏദോമിലെ പ്രമുഖന്മാർ ഭയന്നുവിറയ്ക്കും, മോവാബിലെ നേതാക്കന്മാർ വിറകൊള്ളും, കനാനിലെ ജനങ്ങൾ ഉരുകിപ്പോകും; ");
INSERT INTO malc_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ഭീതിയും സംഭ്രമവും അവർക്കുണ്ടാകും. യഹോവേ, അവിടത്തെ ജനം കടന്നുപോകുന്നതുവരെ അവിടന്നു വിലകൊടുത്തു വാങ്ങിയ ജനം കടന്നുപോകുന്നതുവരെ, അവിടത്തെ ഭുജബലംനിമിത്തം അവർ കല്ലുപോലെ നിശ്ചലരാകും. ");
INSERT INTO malc_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","യഹോവേ, അവിടന്ന് അവരെ അകത്തുകൊണ്ടുവന്ന് അവിടത്തെ അവകാശമായ പർവതത്തിൽ നട്ടുപിടിപ്പിക്കും. ആ സ്ഥലം, യഹോവേ, അങ്ങേക്കു വസിക്കേണ്ടതിന്, തൃക്കരം സ്ഥാപിച്ചിട്ടുള്ള വിശുദ്ധനിവാസംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“യഹോവ വാഴും എന്നും എന്നേക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ഫറവോന്റെ കുതിരകളും രഥങ്ങളും കുതിരക്കാരും കടലിന്റെ ഉള്ളിലേക്കു കടന്നപ്പോൾ യഹോവ വെള്ളം തിരികെ അവർക്കുമീതേ വരുത്തി; ഇസ്രായേല്യരോ, കടലിൽ ഉണങ്ങിയ നിലത്തുകൂടി നടന്നു. ");
INSERT INTO malc_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","അപ്പോൾ പ്രവാചികയും അഹരോന്റെ സഹോദരിയുമായ മിര്യാം കൈയിൽ ഒരു തപ്പെടുത്തു; സ്ത്രീകൾ എല്ലാവരും തപ്പുകളെടുത്തും നൃത്തംചെയ്തും അവളെ അനുഗമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","മിര്യാം അവർക്കു പാടിക്കൊടുത്തു: “യഹോവയ്ക്കു പാടുക, അവിടന്ന് പരമോന്നതനല്ലോ. അശ്വത്തെയും അശ്വാരൂഢനെയും അവിടന്ന് ആഴിയിൽ ചുഴറ്റിയെറിഞ്ഞു.” ");
INSERT INTO malc_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ഇതിനുശേഷം മോശ ഇസ്രായേലിനെ ചെങ്കടലിൽനിന്ന് മുമ്പോട്ടുകൊണ്ടുപോയി. അവർ ശൂർ മരുഭൂമിയിൽ എത്തി. വെള്ളം കണ്ടെത്താതെ അവർ മൂന്നുദിവസം മരുഭൂമിയിൽ സഞ്ചരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","അവർ മാറായിൽ എത്തി, മാറായിലെ വെള്ളം കയ്‌പുള്ളതായിരുന്നതിനാൽ അവർക്ക് അതു കുടിക്കാൻ കഴിഞ്ഞില്ല. (അതുകൊണ്ടാണ് ആ സ്ഥലത്തിനു മാറാ എന്നു പറയുന്നത്.) ");
INSERT INTO malc_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","“ഞങ്ങൾ ഇനി എന്തു കുടിക്കും?” എന്നു പറഞ്ഞുകൊണ്ട് ജനം മോശയ്ക്കു വിരോധമായി പിറുപിറുത്തു. ");
INSERT INTO malc_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","അപ്പോൾ മോശ യഹോവയോടു നിലവിളിച്ചു. യഹോവ അദ്ദേഹത്തിന് ഒരു വൃക്ഷശിഖരം കാണിച്ചുകൊടുത്തു. മോശ അതു വെള്ളത്തിൽ ഇട്ടു; വെള്ളം മധുരമുള്ളതായി. അവിടെവെച്ച് യഹോവ അവർക്കായി ഒരു കൽപ്പനയും നിയമവും ഉണ്ടാക്കി; അവിടെ യഹോവ അവരെ പരീക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","അവിടന്ന് അരുളിച്ചെയ്തു: “നിങ്ങളുടെ ദൈവമായ യഹോവയുടെ ശബ്ദം നിങ്ങൾ ശ്രദ്ധയോടെ കേൾക്കുകയും അവിടത്തെ ദൃഷ്ടിയിൽ യോഗ്യമായതു പ്രവർത്തിക്കുകയും ചെയ്യുമെങ്കിൽ, അവിടത്തെ കൽപ്പനകൾ ശ്രദ്ധിക്കുകയും സകല ഉത്തരവുകളും പാലിക്കുകയും ചെയ്യുമെങ്കിൽ, ഈജിപ്റ്റുകാരുടെമേൽ ഞാൻ വരുത്തിയ വ്യാധികളിൽ ഒന്നുപോലും നിങ്ങളുടെമേൽ വരുത്തുകയില്ല; ഞാൻ നിങ്ങളെ സൗഖ്യമാക്കുന്ന യഹോവ ആകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","പിന്നെ അവർ ഏലീമിൽ എത്തി. അവിടെ പന്ത്രണ്ടു നീരുറവകളും എഴുപത് ഈന്തപ്പനകളും ഉണ്ടായിരുന്നു; അവർ അവിടെ വെള്ളത്തിനരികെ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെട്ടതിന്റെ രണ്ടാംമാസം പതിനഞ്ചാംദിവസം ഇസ്രായേല്യസമൂഹം ഒന്നാകെ ഏലീമിൽനിന്ന് പുറപ്പെട്ട്, ഏലീമിനും സീനായിക്കും ഇടയ്ക്കു സ്ഥിതിചെയ്യുന്ന സീൻമരുഭൂമിയിൽ എത്തി. ");
INSERT INTO malc_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","മരുഭൂമിയിൽവെച്ചു ജനസമൂഹം മോശയ്ക്കും അഹരോനും എതിരേ പിറുപിറുത്തു. ");
INSERT INTO malc_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ഇസ്രായേൽമക്കൾ അവരോടു പറഞ്ഞു: “ഞങ്ങൾ ഈജിപ്റ്റിൽവെച്ച് യഹോവയുടെ കൈയാൽ മരിച്ചുപോയിരുന്നെങ്കിൽ എത്ര നന്നായിരുന്നു! അവിടെ ഞങ്ങൾ മാംസക്കലങ്ങൾക്കുചുറ്റും ഇരുന്ന് മതിയാകുംവരെ ഭക്ഷണം കഴിച്ചുവന്നു. എന്നാൽ നിങ്ങൾ, ഈ ജനസമൂഹത്തെ മുഴുവനും പട്ടിണിയിട്ടു കൊല്ലുന്നതിന്, ഈ മരുഭൂമിയിലേക്കു കൊണ്ടുവന്നിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","അപ്പോൾ യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “ഞാൻ നിങ്ങൾക്കുവേണ്ടി ആകാശത്തുനിന്ന് അപ്പം വർഷിക്കും. ജനം ഓരോ ദിവസവും പുറത്തേക്കുചെന്ന് അന്നത്തേക്കുള്ളതു ശേഖരിച്ചുകൊള്ളണം. അവർ എന്റെ ന്യായപ്രമാണം അനുസരിക്കുമോ ഇല്ലയോ എന്നു പരീക്ഷിക്കേണ്ടതിനുതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ആറാംദിവസം അവർ അകത്തുകൊണ്ടുവരുന്നതു പാകംചെയ്യണം; അതു മറ്റു ദിവസങ്ങളിൽ ശേഖരിക്കുന്നതിന്റെ ഇരട്ടി ആയിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","അതനുസരിച്ച് മോശയും അഹരോനും എല്ലാ ഇസ്രായേല്യരോടുമായി പറഞ്ഞു, “നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് വിടുവിച്ചുകൊണ്ടു വന്നതു യഹോവതന്നെ എന്നു സന്ധ്യക്കു നിങ്ങൾ മനസ്സിലാക്കും; ");
INSERT INTO malc_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","രാവിലെ നിങ്ങൾ യഹോവയുടെ മഹത്ത്വം കാണും. കാരണം, തനിക്കു വിരോധമായുള്ള നിങ്ങളുടെ പിറുപിറുപ്പ് അവിടന്നു കേട്ടിരിക്കുന്നു. നിങ്ങൾ ഞങ്ങൾക്കെതിരേ പിറുപിറുക്കാൻ ഞങ്ങൾ എന്താണ് ചെയ്തത്?” ");
INSERT INTO malc_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","മോശ പിന്നെയും പറഞ്ഞു: “നിങ്ങൾക്കു സന്ധ്യക്കു ഭക്ഷിക്കാൻ ഇറച്ചിയും രാവിലെ മതിയാകുംവരെ അപ്പവും യഹോവ തരും. അവിടന്നാണ് അങ്ങനെ ചെയ്യുന്നതെന്ന് അപ്പോൾ നിങ്ങൾ അറിയും; തനിക്കെതിരേയുള്ള നിങ്ങളുടെ പിറുപിറുപ്പ് അവിടന്നു കേട്ടിരിക്കുന്നു. ഞങ്ങൾ എന്തുള്ളൂ? നിങ്ങൾ പിറുപിറുത്തുകൊണ്ടിരിക്കുന്നതു ഞങ്ങളുടെനേരേ അല്ല, യഹോവയുടെ നേരേയാണ്.” ");
INSERT INTO malc_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","പിന്നെ മോശ അഹരോനോടു പറഞ്ഞു, “ ‘യഹോവയുടെ സന്നിധിയിലേക്കു വരിക, അവിടന്നു നിങ്ങളുടെ പിറുപിറുപ്പു കേട്ടിരിക്കുന്നു’ എന്ന് സകല ഇസ്രായേല്യസമൂഹത്തോടും പറയുക.” ");
INSERT INTO malc_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","അഹരോൻ മുഴുവൻ ഇസ്രായേല്യസമൂഹത്തോടും സംസാരിച്ചുകൊണ്ടിരുന്നപ്പോൾ അവർ മരുഭൂമിയിലേക്കു നോക്കി, അവിടെ യഹോവയുടെ തേജസ്സ് മേഘത്തിൽ പ്രത്യക്ഷപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, ");
INSERT INTO malc_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“ഞാൻ ഇസ്രായേല്യരുടെ പിറുപിറുപ്പ് കേട്ടിരിക്കുന്നു. നീ അവരോടു പറയുക, ‘നിങ്ങൾ സന്ധ്യാസമയത്ത് മാംസം ഭക്ഷിക്കുകയും പ്രഭാതത്തിൽ അപ്പം തിന്നു തൃപ്തരാകുകയും ചെയ്യും. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു എന്ന് അപ്പോൾ നിങ്ങൾ അറിയും.’ ” ");
INSERT INTO malc_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","അന്നു സന്ധ്യയായപ്പോൾ കാടകൾ വന്നു പാളയത്തെ മൂടി. പ്രഭാതമായപ്പോൾ പാളയത്തിനുചുറ്റും മഞ്ഞിന്റെ ഒരു പാളി കാണപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","മഞ്ഞു മാറിയപ്പോൾ മരുഭൂമിയിൽ, ചെതുമ്പലുകൾപോലെയുള്ള നേർത്ത ഒരു വസ്തു, ഉറച്ച മഞ്ഞുകഷണങ്ങൾക്കു തുല്യമായി നിലത്ത് എല്ലായിടത്തും കാണപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","അതുകണ്ടിട്ട് ഇസ്രായേല്യർ പരസ്പരം, “ഇത് എന്താണ്” എന്നു ചോദിച്ചു. അവർക്ക് അതെന്താണെന്ന് അറിഞ്ഞുകൂടായിരുന്നു. മോശ അവരോടു പറഞ്ഞു, “ഇതു നിങ്ങൾക്കു ഭക്ഷണമായി യഹോവ തന്നിരിക്കുന്ന അപ്പം ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","‘ഓരോരുത്തരും തനിക്ക് ആവശ്യമുള്ളത്രയും ശേഖരിച്ചുകൊള്ളണം. കൂടാരത്തിലുള്ള നിങ്ങളുടെ ആളുകൾക്ക് ഓരോരുത്തർക്കും ഓരോ ഓമെർവീതം എടുത്തുകൊള്ളണം’ എന്ന് യഹോവ കൽപ്പിച്ചിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","തങ്ങളോടു പറഞ്ഞിരുന്നതുപോലെ ഇസ്രായേല്യർ ചെയ്തു; ചിലർ കൂടുതലും ചിലർ കുറച്ചും ശേഖരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","അത് അവർ ഓമെർകൊണ്ട് അളന്നപ്പോൾ, കൂടുതൽ ശേഖരിച്ചവർക്കു കൂടുതലോ കുറച്ചു ശേഖരിച്ചവർക്കു കുറവോ കണ്ടില്ല. ഓരോരുത്തരും അവരവർക്ക് ആവശ്യമുള്ളത്രയും ശേഖരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","മോശ അവരോട്, “ആരും അതിൽനിന്ന് രാവിലെവരെ മിച്ചം വെച്ചേക്കരുത്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","എങ്കിലും അവരിൽ ചിലർ മോശ പറഞ്ഞതു കൂട്ടാക്കിയില്ല; അതിൽ ഒരു അംശം രാവിലെവരെ സൂക്ഷിച്ചുവെച്ചു. എന്നാൽ അതു പുഴുവരിച്ചു നാറി. മോശ അവരോടു കോപിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ഓരോ ദിവസവും ഓരോരുത്തരും തനിക്ക് ആവശ്യമുള്ളേടത്തോളം ശേഖരിക്കും; വെയിൽ മൂക്കുമ്പോൾ അത് ഉരുകിപ്പോകും. ");
INSERT INTO malc_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ആറാംദിവസം അവർ ഇരട്ടി ശേഖരിച്ചു—അതായത്, ഒരാൾക്ക് രണ്ട് ഓമെർ. സമൂഹത്തിലെ നേതാക്കന്മാർ വന്ന് ഇക്കാര്യം മോശയോട് അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","അദ്ദേഹം അവരോടു പറഞ്ഞു, “യഹോവ കൽപ്പിച്ചിരിക്കുന്നത് ഇതാണ്: ‘നാളെ വിശ്രമത്തിനുള്ള ദിവസവും യഹോവയ്ക്കു വിശുദ്ധ ശബ്ബത്തുദിനവും ആയിരിക്കണം. ആകയാൽ, നിങ്ങൾ ചുടാൻ ആഗ്രഹിക്കുന്നതു ചുടുകയും പുഴുങ്ങാൻ ആഗ്രഹിക്കുന്നതു പുഴുങ്ങുകയും വേണം. ശേഷിക്കുന്നത് രാവിലെവരെ സൂക്ഷിച്ചുവെച്ചേക്കണം.’ ” ");
INSERT INTO malc_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","അങ്ങനെ അവർ മോശ കൽപ്പിച്ചതുപോലെ അതു രാവിലെവരെ സൂക്ഷിച്ചു. അതിൽനിന്ന് ദുർഗന്ധം വമിച്ചതുമില്ല; പുഴുത്തതുമില്ല. ");
INSERT INTO malc_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","മോശ പറഞ്ഞു, “ഈ ദിവസം യഹോവയ്ക്കു ശബ്ബത്താകുകയാൽ അത് ഇന്നു തിന്നുകൊള്ളണം. ഇന്നു നിങ്ങൾ നിലത്ത് അതു കാണുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ആറുദിവസം നിങ്ങൾക്ക് അതു ശേഖരിക്കാം, എന്നാൽ ശബ്ബത്തായ ഏഴാംദിവസം അത് ഉണ്ടായിരിക്കുകയില്ല.” ");
INSERT INTO malc_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","എന്നിരുന്നാലും, ചില ആളുകൾ ഏഴാംദിവസം അതു ശേഖരിക്കാൻ പുറത്തേക്കുപോയി. എന്നാൽ അവർ ഒന്നും കണ്ടെത്തിയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","അപ്പോൾ യഹോവ മോശയോട് അരുളിച്ചെയ്തു, “എത്രകാലം നിങ്ങൾ എന്റെ കൽപ്പനകളും നിർദേശങ്ങളും അനുസരിക്കാതിരിക്കും? ");
INSERT INTO malc_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","യഹോവ നിങ്ങൾക്കു ശബ്ബത്തു തന്നിരിക്കുന്നെന്ന് ഓർക്കുക; അതുകൊണ്ടാണ് അവിടന്ന് ആറാംദിവസം നിങ്ങൾക്ക് രണ്ടു ദിവസത്തേക്കുള്ള അപ്പം തരുന്നത്. ഏഴാംദിവസം ഓരോരുത്തരും അവരവരുടെ സ്ഥലത്തുതന്നെ ഉണ്ടായിരിക്കണം. ആരും പുറത്തേക്കു പോകരുത്.” ");
INSERT INTO malc_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","അങ്ങനെ, ജനം ഏഴാംദിവസം വിശ്രമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ഇസ്രായേൽമക്കൾ അതിനു മന്ന എന്നു പേരിട്ടു. അതു വെളുത്ത്, കൊത്തമല്ലിയരിപോലെയുള്ളതും തേൻചേർത്തുണ്ടാക്കിയ കനംകുറഞ്ഞ ദോശയുടെ രുചിയുള്ളതും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","മോശ പറഞ്ഞു, “യഹോവ ഇങ്ങനെ കൽപ്പിച്ചിരിക്കുന്നു: ഞാൻ നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് വിടുവിച്ചുകൊണ്ടുവന്നപ്പോൾ, ‘മരുഭൂമിയിൽ നിങ്ങൾക്കു ഭക്ഷിക്കാൻ നൽകിയ അപ്പം വരുംതലമുറകൾക്കു കാണാൻ കഴിയേണ്ടതിന്, അവർക്കായി അതിൽ ഒരു ഓമെർ എടുത്തു സൂക്ഷിച്ചുവെക്കുക.’ ” ");
INSERT INTO malc_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","മോശ അഹരോനോട്, “ഒരു പാത്രമെടുത്ത് അതിൽ ഒരു ഓമെർ മന്ന ഇടണം. പിന്നെ അത്, വരാനുള്ള തലമുറകൾക്കായി യഹോവയുടെമുമ്പാകെ സൂക്ഷിച്ചുവെക്കണം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ അഹരോൻ ഉടമ്പടിയുടെ പലകയുടെമുമ്പാകെ മന്നാ സൂക്ഷിച്ചുവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ഇസ്രായേല്യർ, ജനവാസമുള്ള ദേശത്ത് എത്തുന്നതുവരെ, നാൽപ്പതുവർഷം മന്ന ഭക്ഷിച്ചു; കനാന്റെ അതിരിൽ എത്തുന്നതുവരെ അവർ മന്ന ഭക്ഷിക്കുകയുണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ഒരു ഓമെർ ഒരു ഏഫായുടെ പത്തിലൊന്നാണ്. ");
INSERT INTO malc_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","യഹോവ കൽപ്പിച്ചതനുസരിച്ച് ഇസ്രായേല്യസമൂഹം ഒന്നാകെ സീൻമരുഭൂമിയിൽനിന്ന് യാത്രതിരിച്ചു. അവർ യഹോവയുടെ കൽപ്പനപ്രകാരം പല സ്ഥലങ്ങളിലൂടെ സഞ്ചരിച്ചതിനുശേഷം രെഫീദീമിൽ എത്തി; താവളമടിച്ചു. എന്നാൽ അവിടെ ജനത്തിനു കുടിക്കാൻ വെള്ളം ഇല്ലായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","“ഞങ്ങൾക്കു കുടിക്കാൻ വെള്ളം തരൂ,” എന്നു പറഞ്ഞ് അവർ മോശയോടു കലഹിച്ചു. മോശ അവരോട്, “നിങ്ങൾ എന്തിനാണ് എന്നോടു കലഹിക്കുന്നത്? നിങ്ങൾ യഹോവയെ പരീക്ഷിക്കുന്നതെന്ത്?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","എന്നാൽ അവിടെവെച്ചു ജനത്തിനു ദാഹിക്കുകയും അവർ മോശയോടു പിറുപിറുക്കുകയും ചെയ്തു. “ഞങ്ങളും ഞങ്ങളുടെ കുഞ്ഞുങ്ങളും കന്നുകാലികളും ദാഹിച്ചു മരിക്കേണ്ടതിന് നീ ഞങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് കൂട്ടിക്കൊണ്ടുവന്നത് എന്തിന്?” അവർ ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","അപ്പോൾ മോശ യഹോവയോട്, “ഞാൻ ഈ ജനത്തിന് എന്താണു ചെയ്യേണ്ടത്? അവർ എന്നെ കല്ലെറിയാൻ പോകുന്നു” എന്നു നിലവിളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","അതിനുത്തരമായി, “നീ ജനത്തിനുമുമ്പായി നടക്കുക. ഇസ്രായേലിലെ ഏതാനും ഗോത്രത്തലവന്മാരെയും കൂടെ കൊണ്ടുപോകണം. നീ നൈൽനദിയെ അടിച്ച വടി കൈയിൽ എടുത്തുകൊള്ളണം. ");
INSERT INTO malc_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","അവിടെ ഹോരേബിലെ പാറമേൽ ഞാൻ നിന്റെ മുമ്പിൽ നിൽക്കും. നീ പാറയെ അടിക്കണം, അതിൽനിന്നു, ജനത്തിനു കുടിക്കാൻ വെള്ളം പുറപ്പെടും” എന്ന് യഹോവ മോശയോട് അരുളിച്ചെയ്തു. മോശ ഇസ്രായേല്യ ഗോത്രത്തലവന്മാർ കാൺകെ അങ്ങനെ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ഇസ്രായേല്യർ കലഹിക്കുകയും “യഹോവ ഞങ്ങളുടെ മധ്യേയുണ്ടോ ഇല്ലയോ?” എന്നു പറഞ്ഞുകൊണ്ട് യഹോവയെ പരീക്ഷിക്കുകയും ചെയ്തതുകൊണ്ട് അദ്ദേഹം ആ സ്ഥലത്തിന് മസ്സാ എന്നും മെരീബാ എന്നും പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","അമാലേക്യർ വന്ന് രെഫീദീമിൽവെച്ച് ഇസ്രായേല്യരെ ആക്രമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","മോശ യോശുവയോട്, “നമ്മുടെ പുരുഷന്മാരിൽ ചിലരെ തെരഞ്ഞെടുത്തുകൊണ്ട് അമാലേക്യരോടു പൊരുതാൻ പുറപ്പെടുക. ദൈവത്തിന്റെ വടി കൈയിൽ പിടിച്ചുകൊണ്ടു നാളെ ഞാൻ കുന്നിൻമുകളിൽ നിൽക്കും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","മോശ ആജ്ഞാപിച്ചതനുസരിച്ചു യോശുവ അമാലേക്യരോടു പോരാടി. മോശയും അഹരോനും ഹൂരും കുന്നിൻമുകളിലേക്കു പോയി. ");
INSERT INTO malc_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","മോശ തന്റെ കൈ ഉയർത്തിപ്പിടിക്കുമ്പോൾ ഇസ്രായേല്യർ ജയിക്കും; കൈ താഴ്ത്തുമ്പോൾ അമാലേക്യർ ജയിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","മോശയുടെ കൈകൾ കുഴഞ്ഞപ്പോൾ അവർ ഒരു കല്ല് അദ്ദേഹത്തിന്റെ അടുക്കൽ വെക്കുകയും അദ്ദേഹം അതിൽ ഇരിക്കുകയും ചെയ്തു. അഹരോനും ഹൂരും—ഒരാൾ ഒരുവശത്തും മറ്റേയാൾ മറ്റേവശത്തും നിന്ന്—അദ്ദേഹത്തിന്റെ കൈകളെ ഉയർത്തിപ്പിടിച്ചു; അങ്ങനെ, സൂര്യാസ്തമയംവരെ അദ്ദേഹത്തിന്റെ കൈകൾ നേരേ നിന്നു. ");
INSERT INTO malc_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","യോശുവ അമാലേക്യസൈന്യത്തെ വാൾകൊണ്ടു കീഴടക്കി. ");
INSERT INTO malc_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ഇതിനുശേഷം യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “ഞാൻ അമാലേക്യരുടെ ഓർമ ആകാശത്തിൻകീഴിൽനിന്ന് നിശ്ശേഷം മായിച്ചുകളയും. അതുകൊണ്ടു നീ അവിസ്മരണീയമായ ഒരു കാര്യം എന്ന നിലയ്ക്ക് ഇത് ഒരു ചുരുളിൽ എഴുതിവെക്കണം; യോശുവ അതു നിശ്ചയമായും കേൾക്കുകയും വേണം.” ");
INSERT INTO malc_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","മോശ ഒരു യാഗപീഠം പണിത് അതിനു “യഹോവ നിസ്സി” എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","“യഹോവയുടെ സിംഹാസനത്തിലേക്കു കൈകൾ ഉയർത്തപ്പെടുമെന്നും, യഹോവ അമാലേക്യരോടു തലമുറതലമുറയായി യുദ്ധംചെയ്യും” എന്നും അദ്ദേഹം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ദൈവം മോശയ്ക്കും തന്റെ ജനമായ ഇസ്രായേലിനുംവേണ്ടി ചെയ്ത സകലകാര്യങ്ങളും യഹോവ ഇസ്രായേലിനെ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന വിവരവും മിദ്യാനിലെ പുരോഹിതനും മോശയുടെ അമ്മായിയപ്പനുമായ യിത്രോ കേട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","മോശ തന്റെ ഭാര്യയായ സിപ്പോറയെ മടക്കി അയച്ചിരുന്നു. അദ്ദേഹത്തിന്റെ അമ്മായിയപ്പനായ യിത്രോ അവളെയും ");
INSERT INTO malc_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","അവളുടെ രണ്ട് ആൺമക്കളെയും സ്വീകരിച്ചു. “ഞാൻ അന്യദേശത്ത് പ്രവാസിയായിരിക്കുന്നു,” എന്നു പറഞ്ഞ് ഒരു മകന് മോശ ഗെർശോം എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","“എന്റെ പിതാവിന്റെ ദൈവം എന്റെ സഹായമായി, അവിടന്ന് എന്നെ ഫറവോന്റെ വാളിൽനിന്ന് രക്ഷിച്ചു,” എന്നു പറഞ്ഞുകൊണ്ട് മറ്റേമകന് അദ്ദേഹം എലീയേസർ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","മോശയുടെ അമ്മായിയപ്പനായ യിത്രോ മോശയുടെ ആൺമക്കളെയും ഭാര്യയെയും കൂട്ടിക്കൊണ്ടു മരുഭൂമിയിൽ അദ്ദേഹത്തിന്റെ അടുക്കൽ എത്തി. അവിടെ, ദൈവത്തിന്റെ പർവതത്തിനരികെ മോശ കൂടാരമടിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","“നിന്റെ അമ്മായിയപ്പനായ യിത്രോ എന്ന ഞാൻ നിന്റെ ഭാര്യയും രണ്ടു പുത്രന്മാരുമായി നിന്റെ അടുത്തേക്കു വന്നിരിക്കുന്നു,” എന്നു യിത്രോ അദ്ദേഹത്തെ അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","മോശ പുറപ്പെട്ട് അമ്മായിയപ്പനെ വണങ്ങി ചുംബിച്ച് എതിരേറ്റു. അവർ പരസ്പരം അഭിവാദനംചെയ്തശേഷം കൂടാരത്തിലേക്കു പോയി. ");
INSERT INTO malc_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","യഹോവ ഇസ്രായേലിനുവേണ്ടി ഫറവോനോടും ഈജിപ്റ്റുകാരോടും ചെയ്ത സകലകാര്യങ്ങളെക്കുറിച്ചും വഴിയിൽ അവർക്കു നേരിട്ട സകലവൈഷമ്യങ്ങളെക്കുറിച്ചും യഹോവ അവരെ വിടുവിച്ചതിനെക്കുറിച്ചും മോശ യിത്രോയെ പറഞ്ഞുകേൾപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ഈജിപ്റ്റുകാരുടെ കൈയിൽനിന്ന് ഇസ്രായേലിനെ രക്ഷപ്പെടുത്താൻ അവർക്കുവേണ്ടി യഹോവ ചെയ്ത എല്ലാ നല്ല കാര്യങ്ങളെക്കുറിച്ചും കേട്ട് യിത്രോ ആനന്ദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","അദ്ദേഹം പറഞ്ഞു, “ഈജിപ്റ്റുകാരുടെയും ഫറവോന്റെയും കൈയിൽനിന്ന് നിന്നെ വിടുവിച്ചവനും ഈജിപ്റ്റുകാരുടെ കൈയിൽനിന്ന് ജനങ്ങളെ മോചിപ്പിച്ചവനുമായ യഹോവ വാഴ്ത്തപ്പെട്ടവൻ. ");
INSERT INTO malc_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","യഹോവ സകലദേവന്മാരെക്കാളും വലിയവൻ എന്നു ഞാൻ ഇപ്പോൾ മനസ്സിലാക്കുന്നു. ഇസ്രായേലിനോടു ധിക്കാരമായി പെരുമാറിയവരോട് അവിടന്ന് ഇങ്ങനെ ചെയ്തല്ലോ!” ");
INSERT INTO malc_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","പിന്നെ, മോശയുടെ അമ്മായിയപ്പനായ യിത്രോ ദൈവത്തിന് ഒരു ഹോമയാഗവും മറ്റുയാഗങ്ങളും അർപ്പിച്ചു. അഹരോനും ഇസ്രായേലിലെ സകലഗോത്രത്തലവന്മാരും വന്ന് മോശയുടെ അമ്മായിയപ്പനോടൊപ്പം ദൈവസന്നിധിയിൽ ഭക്ഷണം കഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","പിറ്റേദിവസം മോശ ജനത്തിനു ന്യായംവിധിക്കാൻ ഇരുന്നു. പ്രഭാതംമുതൽ സന്ധ്യവരെ ജനം മോശയ്ക്കുചുറ്റും നിന്നു. ");
INSERT INTO malc_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ജനത്തിനുവേണ്ടി മോശ ചെയ്യുന്നതെല്ലാം കണ്ടിട്ട് അദ്ദേഹത്തോട് അമ്മായിയപ്പൻ ചോദിച്ചു: “നീ ജനത്തിനുവേണ്ടി ചെയ്യുന്നതെന്താണ്? ഈ ജനമെല്ലാം രാവിലെമുതൽ വൈകുന്നേരംവരെ നിന്റെ ചുറ്റും നിൽക്കുകയും നീ തനിച്ച് ന്യായവിസ്താരം നടത്തുകയും ചെയ്യുന്നതെന്തുകൊണ്ട്?” ");
INSERT INTO malc_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","മോശ അദ്ദേഹത്തോടു പറഞ്ഞു: “ദൈവഹിതം അന്വേഷിച്ചുകൊണ്ടു ജനം എന്റെ അടുക്കൽ വരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","അവർക്കു തർക്കം ഉണ്ടാകുമ്പോൾ അവർ എന്റെ അടുക്കൽവരും. ഞാൻ അവർക്കുമധ്യേ തീർപ്പുകൽപ്പിച്ച് ദൈവത്തിന്റെ ഉത്തരവുകളും നിയമങ്ങളും അവരെ അറിയിക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","അതിനു മറുപടിയായി മോശയുടെ അമ്മായിയപ്പൻ: “നീ ഈ ചെയ്യുന്നതു നന്നല്ല. ");
INSERT INTO malc_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","നീയും നിന്റെ അടുക്കൽ വരുന്ന ഈ ജനങ്ങളും തളർന്നുപോകും. ഈ ജോലി നിനക്കു വഹിക്കാവുന്നതിൽ അധികമാണ്; നിനക്കു തനിയേ ഇതു കൈകാര്യംചെയ്യുക സാധ്യമല്ല. ");
INSERT INTO malc_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ഇപ്പോൾ എന്റെ വാക്കു ശ്രദ്ധിക്കുക, ഞാൻ നിനക്ക് ഉപദേശം നൽകാം; ദൈവം നിന്നോടുകൂടെ ഇരിക്കുമാറാകട്ടെ. നീ ദൈവസന്നിധിയിൽ ജനത്തിന്റെ പ്രതിനിധി ആയി അവരുടെ വ്യവഹാരങ്ങൾ ദൈവത്തിന്റെ അടുക്കൽ കൊണ്ടുചെല്ലണം. ");
INSERT INTO malc_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","അവിടത്തെ ഉത്തരവുകളും നിയമങ്ങളും അവരെ പഠിപ്പിക്കയും ജീവിക്കേണ്ട വിധവും അനുഷ്ഠിക്കേണ്ട കർത്തവ്യങ്ങളും അവരെ പ്രബോധിപ്പിക്കുകയും ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","സകലജനത്തിൽനിന്ന് പ്രാപ്തരും ദൈവഭയമുള്ളവരും സത്യസന്ധരും ദുരാദായം വെറുക്കുന്നവരുമായ ചില പുരുഷന്മാരെ തെരഞ്ഞെടുത്ത് അവരെ ആയിരംപേർക്കും നൂറുപേർക്കും അൻപതുപേർക്കും പത്തുപേർക്കും അധിപന്മാരായി നിയമിക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","അവർ എപ്പോഴും ജനത്തിനു ന്യായംവിധിക്കട്ടെ. സങ്കീർണമായ വ്യവഹാരങ്ങൾ അവർ നിന്റെ അടുക്കൽ കൊണ്ടുവരികയും ലഘുവായ കാര്യങ്ങളിൽ അവർതന്നെ തീർപ്പുകൽപ്പിക്കുകയും ചെയ്യട്ടെ. അങ്ങനെയായാൽ നിന്റെ ജോലിഭാരം കുറയും, അങ്ങനെ അവരും അതു നിന്നോടൊപ്പം പങ്കിടുമല്ലോ! ");
INSERT INTO malc_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","നീ ഇതു ചെയ്യുകയും ദൈവം അത് അനുവദിക്കുകയും ചെയ്താൽ നിനക്കു കഠിനാധ്വാനം ഒഴിവാക്കാം, ജനമെല്ലാം സംതൃപ്തരായി വീടുകളിലേക്കു മടങ്ങുകയും ചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","മോശ അമ്മായിയപ്പന്റെ വാക്കുകൾ ശ്രദ്ധയോടെ കേട്ടു; അദ്ദേഹം പറഞ്ഞതുപോലെ എല്ലാം ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","അദ്ദേഹം സകല ഇസ്രായേലിൽനിന്നും സമർഥരായ പുരുഷന്മാരെ തെരഞ്ഞെടുത്ത് അവരെ ജനത്തിനു നായകന്മാരാക്കി. ആയിരംപേർക്കും നൂറുപേർക്കും അൻപതുപേർക്കും പത്തുപേർക്കും അധിപന്മാരായി നിയമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","അവർ എപ്പോഴും ജനത്തിനു ന്യായപാലനം നടത്തി. പ്രയാസമുള്ള വ്യവഹാരങ്ങൾ അവർ മോശയുടെമുമ്പിൽ കൊണ്ടുവന്നു. ലഘുവായവയ്ക്ക് അവർതന്നെ തീർപ്പുകൽപ്പിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","മോശ അമ്മായിയപ്പനെ യാത്രയയച്ചു; അദ്ദേഹം സ്വദേശത്തേക്കു മടങ്ങിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ഇസ്രായേല്യർ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെട്ടതിന്റെ മൂന്നാംമാസത്തിൽ—അതേദിവസം—അവർ സീനായിമരുഭൂമിയിൽ എത്തി. ");
INSERT INTO malc_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","അവർ രെഫീദീമിൽനിന്ന് യാത്രതിരിച്ച് സീനായിമരുഭൂമിയിൽ പ്രവേശിച്ചു. അവിടെ പർവതത്തിനു മുന്നിലായി ഇസ്രായേൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ഇതിനുശേഷം മോശ ദൈവത്തിന്റെ അടുത്തേക്കുചെന്നു; യഹോവ പർവതത്തിൽനിന്ന് അദ്ദേഹത്തോട് അരുളിച്ചെയ്തു: “നീ യാക്കോബ് ഗൃഹത്തോടു പറയേണ്ടതും ഇസ്രായേൽമക്കളോട് അറിയിക്കേണ്ടതും എന്തെന്നാൽ: ");
INSERT INTO malc_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘ഞാൻ ഈജിപ്റ്റിനോടു ചെയ്തതും നിങ്ങളെ കഴുകന്മാരുടെ ചിറകുകളിന്മേൽ വഹിച്ച് എന്റെ അടുക്കലേക്കു കൊണ്ടുവന്നതും നിങ്ങൾ നേരിട്ടു കണ്ടിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ഇനി, നിങ്ങൾ എന്റെ വാക്കുകേട്ട്, അനുസരിച്ച് എന്റെ ഉടമ്പടി പാലിച്ചാൽ എല്ലാ ജനതകളിലുംവെച്ച് എനിക്കുള്ള വിലപ്പെട്ട നിക്ഷേപം നിങ്ങളായിരിക്കും. കാരണം സർവഭൂമിയും എന്റേതാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","നിങ്ങൾ എനിക്കു പുരോഹിതരാജ്യവും വിശുദ്ധജനതയും ആയിരിക്കും.’ ഇസ്രായേല്യരോടു നീ പറയേണ്ടുന്ന വചനങ്ങൾ ഇവയാകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","മോശ ചെന്ന് സമുദായനേതാക്കന്മാരെ വിളിച്ചു, യഹോവ കൽപ്പിച്ച സകലവചനങ്ങളും അവരെ അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","“യഹോവ കൽപ്പിച്ചതെല്ലാം ഞങ്ങൾ ചെയ്തുകൊള്ളാം,” എന്ന് ജനമെല്ലാം ഏകസ്വരത്തിൽ ഉത്തരം പറഞ്ഞു. ജനത്തിന്റെ വാക്കു മോശ ദൈവസന്നിധിയിലെത്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, “ഞാൻ നിന്നോടു സംസാരിക്കുമ്പോൾ ജനംകേട്ട് നിന്നിൽ എപ്പോഴും വിശ്വസിക്കേണ്ടതിനു ഞാൻ ഇതാ മേഘതമസ്സിൽ നിന്റെ അടുക്കൽ വരുന്നു.” അപ്പോൾ മോശ ജനം പറഞ്ഞതു യഹോവയോട് അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, “ജനത്തിന്റെ അടുക്കൽച്ചെന്ന് അവരെ ഇന്നും നാളെയും വിശുദ്ധീകരിക്കുക. അവർ തങ്ങളുടെ വസ്ത്രങ്ങൾ അലക്കി, ");
INSERT INTO malc_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","മൂന്നാംദിവസത്തേക്ക് ഒരുങ്ങിയിരിക്കട്ടെ, അന്ന് യഹോവ സകലജനവും കാണുംവിധം സീനായിമലയിൽ ഇറങ്ങിവരും. ");
INSERT INTO malc_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","മലയുടെ ചുറ്റും ജനത്തിന് അതിരുതിരിച്ചിട്ട് അവരോടു പറയണം, ‘പർവതത്തിലേക്കു പോകുകയോ അതിന്റെ അടിവാരത്തിൽ തൊടുകയോ ചെയ്യാതിരിക്കാൻ സൂക്ഷിക്കുക. ആരെങ്കിലും പർവതത്തെ തൊട്ടാൽ അവൻ കൊല്ലപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ആരും ആ മനുഷ്യനെ സ്പർശിക്കരുത്. അയാളെ നിശ്ചയമായും കല്ലെറിഞ്ഞോ അമ്പെയ്തോ കൊല്ലണം: മനുഷ്യനായാലും മൃഗമായാലും ജീവനോടിരിക്കരുത്.’ കോലാട്ടിൻകൊമ്പിനാൽ തീർത്ത കാഹളം ദീർഘമായി ഊതുമ്പോൾമാത്രം അവർക്ക് പർവതത്തിനടുത്തേക്കു പോകാം.” ");
INSERT INTO malc_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","മോശ പർവതത്തിൽനിന്ന് ഇറങ്ങിയതിനുശേഷം ജനത്തിന്റെ അടുക്കൽ ചെന്ന് അവരെ വിശുദ്ധീകരിച്ചു. അവർ തങ്ങളുടെ വസ്ത്രം അലക്കി. ");
INSERT INTO malc_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","പിന്നെ, അദ്ദേഹം അവരോട്, “മൂന്നാംദിവസത്തേക്ക് ഒരുങ്ങിക്കൊള്ളുക. ആരും ലൈംഗികബന്ധത്തിൽ ഏർപ്പെടരുത്.” ");
INSERT INTO malc_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","മൂന്നാംദിവസം പ്രഭാതത്തിൽ പർവതത്തിനുമീതേ, കനത്ത മേഘത്തോടൊപ്പം ഇടിയും മിന്നലും തുടർന്ന് അത്യുച്ചത്തിലുള്ള കാഹളനാദവും ഉണ്ടായി. പാളയത്തിൽ ഉണ്ടായിരുന്നവർ എല്ലാവരും പേടിച്ചുവിറച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ഇതിനുശേഷം ദൈവത്തെ എതിരേൽക്കാൻ മോശ ജനത്തെ പാളയത്തിനു പുറത്തുകൊണ്ടുവന്നു. അവർ പർവതത്തിന്റെ അടിവാരത്തു നിന്നു. ");
INSERT INTO malc_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","യഹോവ സീനായിപർവതത്തിൽ, തീയിൽ, ഇറങ്ങിവന്നതുകൊണ്ട് മല പുകകൊണ്ടു മൂടി. ചൂളയിൽനിന്ന് പൊങ്ങുന്നതുപോലെ പുക ഉയർന്നുപൊങ്ങി. പർവതം വല്ലാതെ വിറച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","കാഹളത്തിന്റെ മുഴക്കം ഒന്നിനൊന്നു വർധിച്ചുകൊണ്ടിരുന്നു. അപ്പോൾ മോശ സംസാരിക്കുകയും ദൈവം ഉച്ചത്തിൽ അദ്ദേഹത്തിന് ഉത്തരം നൽകുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","യഹോവ സീനായിമലയുടെ മുകളിൽ ഇറങ്ങിവന്ന് മോശയെ പർവതാഗ്രത്തിലേക്കു വിളിച്ചു; മോശ കയറിച്ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","യഹോവ അദ്ദേഹത്തോട്, “നീ ഇറങ്ങിച്ചെന്ന്, ‘ജനം യഹോവയെ കാണാൻ തള്ളിക്കയറി, അനേകർ നശിക്കാൻ ഇടയാകരുത്,’ എന്ന് അവർക്കു മുന്നറിയിപ്പു കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","യഹോവയെ സമീപിക്കുന്ന പുരോഹിതന്മാരും തങ്ങളെത്തന്നെ വിശുദ്ധീകരിക്കണം. അല്ലാത്തപക്ഷം യഹോവ അവർക്കു ജീവഹാനി വരുത്തും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","മോശ യഹോവയോട്, “ ‘പർവതത്തിനുചുറ്റും അതിരുതിരിച്ച് അതിനെ വിശുദ്ധീകരിച്ചു വേർതിരിക്കുക,’ എന്ന് അവിടന്നുതന്നെ ഞങ്ങൾക്കു മുന്നറിയിപ്പു തന്നതുകൊണ്ട് ജനത്തിനു സീനായിമലയിൽ പ്രവേശിക്കാൻ സാധ്യമല്ല” എന്ന് ഉത്തരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","“ഇറങ്ങിച്ചെന്ന് അഹരോനെ കൂട്ടിക്കൊണ്ടുവരിക. പുരോഹിതന്മാരും ജനങ്ങളും യഹോവയുടെ അടുത്തേക്ക് അതിരുലംഘിച്ചു കടന്നുവരരുത്, വന്നാൽ യഹോവ അവർക്കു ഹാനി വരുത്തും,” അവിടന്നു മറുപടി നൽകി. ");
INSERT INTO malc_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","മോശ ഇറങ്ങിച്ചെന്ന് ജനത്തോടു സംസാരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ദൈവം ഈ വചനങ്ങൾ എല്ലാം അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“അടിമനാടായ ഈജിപ്റ്റിൽനിന്ന് നിങ്ങളെ പുറത്തുകൊണ്ടുവന്ന യഹോവയായ ഞാൻ നിങ്ങളുടെ ദൈവം ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“ഞാൻ അല്ലാതെ അന്യദേവന്മാർ നിങ്ങൾക്കുണ്ടാകരുത്. ");
INSERT INTO malc_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","നിങ്ങൾക്കായി ഒരു വിഗ്രഹവും ഉണ്ടാക്കരുത്; മീതേ ആകാശത്തിലോ താഴേ ഭൂമിയിലോ കീഴേ വെള്ളത്തിലോ ഉള്ള യാതൊന്നിന്റെയും പ്രതിമയും അരുത്. ");
INSERT INTO malc_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","അവയെ വണങ്ങുകയോ ആരാധിക്കുകയോ ചെയ്യരുത്. കാരണം, നിങ്ങളുടെ ദൈവമായ യഹോവയായ ഞാൻ തീക്ഷ്ണതയുള്ളവനാകുന്നു. എന്നെ വെറുക്കുന്ന മാതാപിതാക്കളുടെ പാപത്തിന് അവരുടെ മക്കളെ മൂന്നും നാലും തലമുറവരെ ശിക്ഷിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","എന്നാൽ എന്നെ സ്നേഹിച്ച് എന്റെ കൽപ്പനകൾ പ്രമാണിക്കുന്നവരോട് ആയിരം തലമുറവരെ ഞാൻ കരുണകാണിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","നിങ്ങളുടെ ദൈവമായ യഹോവയുടെ നാമം വൃഥാ ഉപയോഗിക്കരുത്. അവിടത്തെ നാമം വ്യർഥമായി ഉപയോഗിക്കുന്നവരെ യഹോവ ശിക്ഷിക്കാതിരിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ശബ്ബത്തുദിവസത്തെ വിശുദ്ധിയോടെ ആചരിക്കാൻ ഓർക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ആറുദിവസം അധ്വാനിച്ച് നിങ്ങളുടെ ജോലികളെല്ലാം ചെയ്യുക; ");
INSERT INTO malc_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","എന്നാൽ ഏഴാംദിവസം നിങ്ങളുടെ ദൈവമായ യഹോവയുടെ ശബ്ബത്ത് ആകുന്നു. അന്ന് നിങ്ങളോ നിങ്ങളുടെ പുത്രനോ പുത്രിയോ ദാസനോ ദാസിയോ മൃഗങ്ങളോ നിങ്ങളുടെ പട്ടണങ്ങളിൽ താമസിക്കുന്ന പ്രവാസിയോ ജോലിയൊന്നും ചെയ്യാൻ പാടില്ല; ");
INSERT INTO malc_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","എന്തുകൊണ്ടെന്നാൽ, ആറുദിവസംകൊണ്ട് യഹോവ ആകാശവും ഭൂമിയും സമുദ്രവും അവയിലുള്ള സകലതും സൃഷ്ടിച്ചിട്ട് ഏഴാംദിവസം വിശ്രമിച്ചു. ആകയാൽ യഹോവ ശബ്ബത്ത് ദിവസത്തെ അനുഗ്രഹിച്ച് അതിനെ വിശുദ്ധീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","നിങ്ങളുടെ ദൈവമായ യഹോവ നിങ്ങൾക്കു നൽകുന്ന ദേശത്തു നിങ്ങൾക്കു ദീർഘായുസ്സുണ്ടാകേണ്ടതിനു നിങ്ങളുടെ പിതാവിനെയും മാതാവിനെയും ബഹുമാനിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","കൊലപാതകം ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","വ്യഭിചാരം ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","മോഷ്ടിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","അയൽവാസിക്കു വിരോധമായി കള്ളസാക്ഷി പറയരുത്. ");
INSERT INTO malc_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","അയൽവാസിയുടെ ഭവനത്തെ മോഹിക്കരുത്. അയൽവാസിയുടെ ഭാര്യ, പരിചാരകൻ, പരിചാരിക, കാള, കഴുത ഇങ്ങനെ നിന്റെ അയൽവാസിക്കുള്ള യാതൊന്നും മോഹിക്കരുത്.” ");
INSERT INTO malc_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ഇടിയും മിന്നലും കാണുകയും കാഹളം കേൾക്കുകയും പർവതം പുകയുന്നതു കാണുകയും ചെയ്തപ്പോൾ ജനമെല്ലാം ഭയന്നുവിറച്ചു; അവർ ദൂരെ മാറിനിന്നു. ");
INSERT INTO malc_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","അവർ മോശയോട്, “അങ്ങുതന്നെ ഞങ്ങളോടു സംസാരിക്കുക, ഞങ്ങൾ കേട്ടുകൊള്ളാം; ഞങ്ങൾ മരിക്കാതിരിക്കേണ്ടതിന് ദൈവം ഞങ്ങളോടു സംസാരിക്കരുതേ” എന്നപേക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","മോശ ജനത്തോട്, “ഭയപ്പെടരുത്: നിങ്ങളിൽ ദൈവഭയം ഉളവാകുന്നതുമൂലം പാപത്തിൽനിന്ന് അകന്നു ജീവിക്കുന്നതിനും ഇങ്ങനെ നിങ്ങളെ പരീക്ഷിക്കുന്നതിനുമാണ് ദൈവം വന്നിരിക്കുന്നത്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ജനം അകലെ നിന്നു, മോശയോ ദൈവം സന്നിഹിതനായ കനത്ത ഇരുട്ടിനെ സമീപിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ഇതിനെത്തുടർന്ന് യഹോവ മോശയോട് അരുളിച്ചെയ്തു, “നീ ഇസ്രായേല്യരോട് ഇങ്ങനെ പറയുക: ‘ഞാൻ സ്വർഗത്തിൽനിന്ന് നിങ്ങളോടു സംസാരിക്കുന്നതു നിങ്ങൾതന്നെ കണ്ടിരിക്കുന്നു! ");
INSERT INTO malc_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ഞാൻ ഒഴികെ മറ്റൊരുദൈവവും നിങ്ങൾക്കുണ്ടായിരിക്കരുത്. വെള്ളികൊണ്ടോ സ്വർണംകൊണ്ടോ നിങ്ങൾക്കായി ദേവതകളെ നിർമിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘മണ്ണുകൊണ്ട് ഒരു യാഗപീഠം നിങ്ങൾ എനിക്കായി നിർമിക്കണം; അതിന്മേൽ നിങ്ങളുടെ ഹോമയാഗവസ്തുക്കൾ, സമാധാന വഴിപാടുകൾ, ചെമ്മരിയാടുകൾ, കോലാടുകൾ, കന്നുകാലികൾ എന്നിവ അർപ്പിക്കുക. എന്റെ നാമം ആദരിക്കപ്പെടാൻ ഞാൻ ഇടയാക്കുന്നിടത്തെല്ലാം വന്നു ഞാൻ നിങ്ങളെ അനുഗ്രഹിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","നിങ്ങൾ എനിക്കായി കല്ലുകൊണ്ടു യാഗപീഠം പണിയുന്നെങ്കിൽ അതു ചെത്തിയ കല്ലുകൊണ്ട് ആകരുത്; അതിന്മേൽ പണിയായുധം പ്രയോഗിച്ചാൽ നിങ്ങൾ അതിനെ അശുദ്ധമാക്കും. ");
INSERT INTO malc_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","എന്റെ യാഗപീഠത്തിന്മേൽ നിങ്ങളുടെ നഗ്നത അനാവരണം ചെയ്യാതിരിക്കേണ്ടതിന് ചവിട്ടുപടികളിലൂടെ അതിന്മേൽ കയറരുത്.’ ");
INSERT INTO malc_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“നീ അവരുടെ മുന്നിൽ വെക്കേണ്ടുന്ന നിയമങ്ങൾ ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“ഒരു എബ്രായദാസനെ നീ വിലയ്ക്കു വാങ്ങുന്നെങ്കിൽ അവൻ ആറുവർഷം നിന്നെ സേവിക്കട്ടെ. എന്നാൽ ഏഴാംവർഷം പ്രതിഫലംവാങ്ങാതെ അവനെ സ്വതന്ത്രനാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","അവൻ ഏകനായിട്ടാണു വരുന്നതെങ്കിൽ ഏകനായിത്തന്നെ പോകാവുന്നതാണ്; വരുമ്പോൾ ഭാര്യയുണ്ടെങ്കിൽ അവളും അവനോടൊപ്പം പൊയ്ക്കൊള്ളണം. ");
INSERT INTO malc_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","യജമാനൻ ഒരുവളെ അവനു ഭാര്യയായി നൽകി അവൾ അവനു പുത്രന്മാരെയോ പുത്രിമാരെയോ പ്രസവിക്കുന്നെങ്കിൽ ആ സ്ത്രീയും അവളുടെ കുട്ടികളും യജമാനന് അവകാശപ്പെട്ടിരിക്കും; ആ പുരുഷൻമാത്രം സ്വതന്ത്രനാകും. ");
INSERT INTO malc_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“എന്നാൽ ആ ദാസൻ: ‘ഞാൻ എന്റെ യജമാനനെയും എന്റെ ഭാര്യയെയും കുഞ്ഞുങ്ങളെയും സ്നേഹിക്കുന്നു; എനിക്കു സ്വതന്ത്രനായി പോകാൻ ആഗ്രഹമില്ല’ എന്നു തുറന്നുപറയുന്നെങ്കിൽ ");
INSERT INTO malc_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","യജമാനൻ അവനെ ദൈവത്തിന്റെ മുമ്പിൽ കൂട്ടിക്കൊണ്ടുപോകണം. അദ്ദേഹം അവനെ വാതിലിന്റെയോ കട്ടിളക്കാലിന്റെയോ അടുത്തുകൊണ്ടുചെന്ന് സൂചികൊണ്ട് അവന്റെ കാതു തുളയ്ക്കണം. പിന്നെ അവൻ ആജീവനാന്തം അദ്ദേഹത്തെ സേവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ഒരുവൻ തന്റെ മകളെ ദാസിയായി വിൽക്കുന്നെങ്കിൽ അവൾ ദാസന്മാർ പോകുന്നതുപോലെ സ്വതന്ത്രയായി പോകരുത്. ");
INSERT INTO malc_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","അവളെ തനിക്കായി തെരഞ്ഞെടുത്ത യജമാനന് അവളോട് ഇഷ്ടമില്ലെങ്കിൽ അദ്ദേഹം അവൾക്കു വീണ്ടെടുപ്പിനുള്ള അനുവാദം നൽകണം. അവളോടു വിശ്വാസലംഘനം നടത്തിയതുകൊണ്ട് അയാൾക്ക് അവളെ അന്യർക്ക് വിൽക്കാൻ അവകാശം ഇല്ല. ");
INSERT INTO malc_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","അദ്ദേഹം തന്റെ മകനുവേണ്ടിയാണ് അവളെ തെരഞ്ഞെടുക്കുന്നതെങ്കിൽ ഒരു മകളുടെ അവകാശങ്ങൾ അവൾക്ക് അനുവദിച്ചുകൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ആ മനുഷ്യൻ മറ്റൊരുവളെ വിവാഹംചെയ്യുന്നെങ്കിൽ ഒന്നാമത്തവൾക്കു ഭക്ഷണം, വസ്ത്രം, വൈവാഹികാവകാശം എന്നിവ കുറയ്ക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ഇവ മൂന്നും അദ്ദേഹം അവൾക്കു കൊടുക്കുന്നില്ലെങ്കിൽ, പണം കൊടുക്കാതെ അവൾക്കു സ്വതന്ത്രയായി പോകാവുന്നതാണ്. ");
INSERT INTO malc_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ആരെങ്കിലും ഒരു മനുഷ്യനെ അടിച്ചുകൊന്നാൽ അയാൾ മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","എങ്കിലും ഒരു വ്യക്തി മനഃപൂർവം ചെയ്യാതെ അങ്ങനെ സംഭവിക്കാൻ ദൈവം ഇടയാക്കിയതാണെങ്കിൽ ഞാൻ നിർദേശിക്കുന്ന സ്ഥലത്തേക്ക് ആ മനുഷ്യൻ ഓടിപ്പോകണം. ");
INSERT INTO malc_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","എന്നാൽ ഒരു വ്യക്തി കരുതിക്കൂട്ടി മറ്റൊരു വ്യക്തിയെ കൊല്ലുന്നെങ്കിൽ ആ മനുഷ്യനെ എന്റെ യാഗപീഠത്തിൽനിന്ന് പിടിച്ചുകൊണ്ടുപോയി കൊന്നുകളയണം. ");
INSERT INTO malc_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“അപ്പനെയോ അമ്മയെയോ അടിക്കുന്നവരും മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ഒരാൾ മറ്റൊരാളെ തട്ടിക്കൊണ്ടുപോയി വിൽക്കുകയോ കൈവശം വെച്ചുകൊണ്ടിരിക്കുകയോ ചെയ്താൽ ആ വ്യക്തി മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“അപ്പനെയോ അമ്മയെയോ ശപിക്കുന്നവരും മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ആളുകൾതമ്മിൽ വഴക്കുണ്ടായിട്ട് ഒരാൾ മറ്റൊരാളെ കല്ലുകൊണ്ടോ മുഷ്ടികൊണ്ടോ ഇടിച്ച് അയാൾ മരിക്കാതെ, കിടപ്പിലാകുകയും ");
INSERT INTO malc_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","പിന്നീട് എഴുന്നേറ്റ് വടി ഊന്നി വെളിയിൽ നടക്കുകയും ചെയ്താൽ ഇടിച്ച വ്യക്തിയെ ശിക്ഷിക്കേണ്ടതില്ല; എങ്കിലും ഇടിയേറ്റയാൾക്കു നഷ്ടപരിഹാരം കൊടുക്കുകയും പരിപൂർണസൗഖ്യം വരുത്താൻ വേണ്ടതു ചെയ്യുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“ആരെങ്കിലും തന്റെ ദാസനെയോ ദാസിയെയോ വടികൊണ്ട് അടിച്ചിട്ട് അതിന്റെ ഫലമായി ആ അടിമ മരിച്ചുപോയാൽ അടിച്ച വ്യക്തിയെ ശിക്ഷിക്കണം; ");
INSERT INTO malc_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","എന്നാൽ അടിമ ഒന്നോ രണ്ടോ ദിവസംകൂടി ജീവിച്ചിരുന്നാൽ ആ മനുഷ്യനെ ശിക്ഷിക്കേണ്ടതില്ല; അടിമ അവന്റെ സ്വത്താണല്ലോ! ");
INSERT INTO malc_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ആളുകൾതമ്മിൽ വഴക്കുണ്ടായിട്ട് ഒരു ഗർഭിണിക്ക് ആഘാതം ഏൽക്കുകയും മാസംതികയാതെ പ്രസവിക്കുകയും എന്നാൽ ഗുരുതരമായ പരിക്ക് ഇല്ലാതിരിക്കുകയും ചെയ്താൽ സ്ത്രീയുടെ ഭർത്താവ് ആവശ്യപ്പെടുന്നതും ന്യായാധിപന്മാർ നിശ്ചയിക്കുന്നതുമായ പിഴ അക്രമി അടയ്ക്കേണ്ടതാണ്. ");
INSERT INTO malc_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","എന്നാൽ ഗുരുതരമായ പരിക്കുണ്ടെങ്കിൽ നിങ്ങൾ ജീവനുപകരം ജീവൻ കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","കണ്ണിനുപകരം കണ്ണ്, പല്ലിനുപകരം പല്ല്, കൈക്കു പകരം കൈ, പാദത്തിനു പകരം പാദം, ");
INSERT INTO malc_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","പൊള്ളലിനു പകരം പൊള്ളൽ, മുറിവിനു പകരം മുറിവ്, ചതവിനു പകരം ചതവ് എന്നീ ക്രമത്തിൽ ശിക്ഷ നടപ്പാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ഒരു യജമാനൻ തന്റെ ദാസന്റെയോ ദാസിയുടെയോ കണ്ണ് അടിച്ചു നശിപ്പിച്ചാൽ, കണ്ണിനു നഷ്ടപരിഹാരമായി ആ ദാസനെയോ ദാസിയെയോ, സ്വാതന്ത്ര്യം കൊടുത്തു വിട്ടയയ്ക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ആ മനുഷ്യൻ ദാസന്റെയോ ദാസിയുടെയോ പല്ല് അടിച്ചുകൊഴിച്ചാൽ പല്ലിനുള്ള നഷ്ടപരിഹാരമായി ആ ദാസനെ, അഥവാ, ദാസിയെ വിട്ടയയ്ക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ഒരു കാള ഒരു പുരുഷനെയോ സ്ത്രീയെയോ കുത്തിക്കൊന്നാൽ ആ കാളയെ കല്ലെറിഞ്ഞുകൊല്ലണം; അതിന്റെ മാംസം ഭക്ഷിക്കാൻ പാടില്ല. കാളയുടെ ഉടമ ശിക്ഷ അർഹിക്കുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","എന്നാൽ ആ കാള കുത്തുന്ന സ്വഭാവമുള്ളതും ഉടമയ്ക്കു മുന്നറിയിപ്പു നൽകിയിട്ടും അയാൾ അതിനെ കെട്ടി സൂക്ഷിക്കാതിരുന്നതുമാണെങ്കിൽ, അത് ഒരു പുരുഷനെയോ സ്ത്രീയെയോ കുത്തിക്കൊന്നാൽ അതിനെ കല്ലെറിഞ്ഞുകൊല്ലണം; ഉടമയും മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","എന്നാൽ മോചനദ്രവ്യം നിശ്ചയിച്ചാൽ ആ മോചനദ്രവ്യം കൊടുത്ത് ഉടമയ്ക്കു തന്റെ ജീവൻ വീണ്ടെടുക്കാം. ");
INSERT INTO malc_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","മകനെയോ മകളെയോ കാള കുത്തിക്കൊന്നാലും ഈ നിയമം ബാധകമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ഒരു ദാസനെയോ ദാസിയെയോ കാള കുത്തിക്കൊന്നാൽ അതിന്റെ ഉടമ അടിമയുടെ ഉടമയ്ക്കു മുപ്പതു ശേക്കേൽ വെള്ളി കൊടുക്കുകയും കാളയെ കല്ലെറിഞ്ഞു കൊല്ലുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ആരെങ്കിലും ഒരു കുഴി തുറന്നുവെക്കുകയോ ഒരു കുഴി ഉണ്ടാക്കിയിട്ടു മൂടാതിരിക്കുകയോ ചെയ്തിട്ട് ഒരു കാളയോ കഴുതയോ അതിൽ വീണാൽ, ");
INSERT INTO malc_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","കുഴിയുടെ ഉടമ മൃഗത്തിന്റെ ഉടമയ്ക്കു നഷ്ടപരിഹാരം നൽകണം എന്നാൽ ചത്ത മൃഗം കുഴിയുടെ ഉടമയ്ക്ക് അവകാശപ്പെട്ടതുമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ആരുടെയെങ്കിലും കാള മറ്റൊരാളുടെ കാളയെ കുത്തിക്കൊന്നാൽ അവർ ജീവനുള്ളതിനെ വിറ്റ് ആ പണം പങ്കിട്ടെടുക്കണം; ചത്തകാളയെയും തുല്യമായി വീതിച്ചെടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","എന്നാൽ, ആ കാള കുത്തുന്ന ശീലം ഉള്ളതാണെന്ന് അറിഞ്ഞിട്ടും മൃഗത്തിന്റെ ഉടമ അതിനെ സൂക്ഷിക്കാതിരുന്നതാണെങ്കിൽ അയാൾ ചത്തമൃഗത്തെ എടുത്തുകൊണ്ട്; മൃഗത്തിനുപകരം മൃഗത്തെ കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ആരെങ്കിലും ഒരു കാളയെയോ ആടിനെയോ മോഷ്ടിച്ചു കശാപ്പു ചെയ്യുകയോ വിൽക്കുകയോ ചെയ്താൽ അയാൾ ഒരു കാളയ്ക്കു പകരം അഞ്ചു കാളയെയും ഒരു ആടിനു പകരം നാല് ആടിനെയും കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“ഒരു കള്ളൻ ഭവനഭേദനം നടത്തുമ്പോൾ അടികൊണ്ടു മരിച്ചുപോയാൽ സ്വയരക്ഷയ്ക്കായി അടിച്ചയാൾക്കു രക്തപാതകം ഇല്ല. ");
INSERT INTO malc_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","എന്നാൽ സൂര്യോദയത്തിനുശേഷമാണ് അങ്ങനെ സംഭവിക്കുന്നതെങ്കിൽ അയാൾ രക്തച്ചൊരിച്ചിൽനിമിത്തം കുറ്റക്കാരനായിരിക്കും. “മോഷ്ടാവ് തീർച്ചയായും നഷ്ടപരിഹാരം നടത്തിയിരിക്കണം, എന്നാൽ ആ വ്യക്തിക്ക് അതിനു വകയില്ലെങ്കിൽ മോഷ്ടിച്ച കുറ്റത്തിന് അയാളെ വിൽക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","മോഷ്ടിക്കപ്പെട്ട കാളയോ കഴുതയോ ആടോ ആ മനുഷ്യന്റെ കൈവശം ജീവനോടെ കാണപ്പെട്ടാൽ, അയാൾ അതിന്റെ ഇരട്ടി തിരിച്ചുകൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ആരെങ്കിലും തന്റെ മൃഗങ്ങളെ വയലിലോ മുന്തിരിത്തോപ്പിലോ മേയിക്കുമ്പോൾ അലഞ്ഞുതിരിയാൻ അനുവദിച്ചിട്ട് അവ മറ്റൊരാളുടെ വയലിൽ മേഞ്ഞാൽ അയാൾ സ്വന്തം വയലിലെയോ മുന്തിരിത്തോപ്പിലെയോ നല്ലതിനെ പകരം കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“തീപിടിച്ചിട്ട് അതു മുൾപ്പടർപ്പുകളിലേക്കു വ്യാപിച്ച്, കറ്റകളോ കൊയ്തെടുക്കാനുള്ള വിളവോ വയലോ കത്തിപ്പോയാൽ തീ വെച്ചയാൾ നഷ്ടപരിഹാരം ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ആരെങ്കിലും വെള്ളിയോ മറ്റു സാധനങ്ങളോ സൂക്ഷിച്ചുവെക്കാൻ ഒരു അയൽവാസിയെ ഏൽപ്പിച്ചിട്ട് അയാളുടെ വീട്ടിൽനിന്ന് അവ മോഷ്ടിക്കപ്പെടുകയും മോഷ്ടാവിനെ പിടികിട്ടുകയും ചെയ്താൽ മോഷ്ടാവ് അവയുടെ ഇരട്ടി മടക്കിക്കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","എന്നാൽ കള്ളനെ പിടികിട്ടിയില്ലെങ്കിൽ വീട്ടുടമ മറ്റേയാളുടെ സ്വത്ത് അപഹരിച്ചിട്ടുണ്ടോ ഇല്ലയോ എന്നു നിശ്ചയം വരുത്താൻ ആ മനുഷ്യനെ ദൈവസന്നിധിയിൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","കാണാതെപോയ കാള, കഴുത, ആട്, വസ്ത്രം എന്നിങ്ങനെയുള്ള എന്തിന്റെയെങ്കിലും കാര്യത്തിൽ ‘അതു തന്റേത്’ എന്ന് ആരെങ്കിലും അവകാശപ്പെടുന്നപക്ഷം, ഇരുകക്ഷികളും തങ്ങളുടെ കാര്യം ദൈവസന്നിധിയിൽ കൊണ്ടുവരണം; കുറ്റക്കാരെന്നു ദൈവം വിധിക്കുന്നവർ തന്റെ അയൽവാസിക്ക് ഇരട്ടി പകരം കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“ആരെങ്കിലും അയൽക്കാരെ സൂക്ഷിക്കാൻ ഏൽപ്പിച്ച കഴുതയോ കാളയോ ആടോ മറ്റ് ഏതെങ്കിലും മൃഗമോ ചാകുകയോ മുറിവേൽക്കുകയോ മോഷ്ടിക്കപ്പെടുകയോ ചെയ്യുകയും സാക്ഷി ഇല്ലാതിരിക്കുകയും ചെയ്താൽ ");
INSERT INTO malc_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","അവർതമ്മിലുള്ള തർക്കം യഹോവയുടെമുമ്പാകെ തീർക്കണം; അയൽക്കാരുടെ വസ്തുവിന്മേൽ താൻ കൈവെച്ചിട്ടില്ല എന്ന് യഹോവയുടെമുമ്പാകെ അയൽവാസി ശപഥംചെയ്യുകയുംവേണം. ഉടമ ഈ വസ്തുത അംഗീകരിക്കണം, പകരമായി ഒന്നുംതന്നെ നൽകേണ്ടതില്ല. ");
INSERT INTO malc_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","എന്നാൽ അതു തന്റെ പക്കൽനിന്നു മോഷ്ടിക്കപ്പെട്ടുവെങ്കിൽ അയാൾ ഉടമസ്ഥനു നഷ്ടപരിഹാരം കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","മൃഗത്തെ ഒരു വന്യജന്തു കടിച്ചുകീറിയെങ്കിൽ അയാൾ മൃഗത്തിന്റെ അവശിഷ്ടം അതിനു തെളിവായി കൊണ്ടുവരേണ്ടതാണ്; കടിച്ചുകീറിയതിനു പകരമായി അയാൾ ഒന്നും കൊടുക്കേണ്ടതില്ല. ");
INSERT INTO malc_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ആരെങ്കിലും അയൽക്കാരുടെ പക്കൽനിന്ന് ഒരു മൃഗത്തെ കടം വാങ്ങിയിട്ട് ഉടമയുടെ അസാന്നിധ്യത്തിൽ അതിനു മുറിവേൽക്കുകയോ അതു ചത്തുപോകുകയോ ചെയ്താൽ ആ മനുഷ്യൻ നഷ്ടപരിഹാരം കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ഉടമ മൃഗത്തോടുകൂടെ ഉണ്ടെങ്കിൽ കടംവാങ്ങിയയാൾ ഒന്നും കൊടുക്കേണ്ടതില്ല. മൃഗത്തെ കൂലിക്കു വാങ്ങിയതാണെങ്കിൽ, നഷ്ടം നികത്താൻ കൂലിയായി കൊടുത്ത പണം മതിയാകും. ");
INSERT INTO malc_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“വിവാഹനിശ്ചയം കഴിഞ്ഞിട്ടില്ലാത്ത ഒരു കന്യകയെ വശീകരിച്ച് അവളോടൊപ്പം ശാരീരികബന്ധത്തിൽ ഏർപ്പെടുന്നവൻ കന്യാധനം നൽകി അവളെ ഭാര്യയായി സ്വീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","അവളുടെ പിതാവ് അവളെ അവനു കൊടുക്കാൻ തീർത്തും വിസമ്മതിക്കുന്നെങ്കിലും, അവൻ കന്യകമാർക്കുള്ള സ്ത്രീധനം കൊടുക്കേണ്ടതാണ്. ");
INSERT INTO malc_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“ആഭിചാരകരെ ജീവിക്കാൻ അനുവദിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“മൃഗത്തോടൊപ്പം ലൈംഗികബന്ധത്തിലേർപ്പെടുന്നവർ മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“യഹോവയ്ക്കല്ലാതെ മറ്റ് ഏതെങ്കിലും ദേവനു യാഗം കഴിക്കുന്നവരെ നിശ്ശേഷം നശിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“വിദേശിയോടു മോശമായി പെരുമാറുകയോ അവരെ പീഡിപ്പിക്കുകയോ അരുത്; ഈജിപ്റ്റിൽ നിങ്ങളും പ്രവാസികൾ ആയിരുന്നല്ലോ. ");
INSERT INTO malc_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“വിധവയെയോ അനാഥരെയോ പീഡിപ്പിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","നീ പീഡിപ്പിച്ചിട്ട് അവർ എന്നോടു നിലവിളിച്ചാൽ ഞാൻ നിശ്ചയമായും അവരുടെ നിലവിളി കേൾക്കും; ");
INSERT INTO malc_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","എന്റെ ക്രോധം ജ്വലിച്ചിട്ട് ഞാൻ നിന്നെ വാളാൽ കൊന്നുകളയും; നിങ്ങളുടെ ഭാര്യമാർ വിധവകളും നിങ്ങളുടെ കുഞ്ഞുങ്ങൾ അനാഥരും ആയിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“നിങ്ങളുടെ ഇടയിലുള്ള എന്റെ ജനത്തിൽ ദരിദ്രനായ ഒരു മനുഷ്യനു പണം വായ്പ കൊടുക്കുന്നെങ്കിൽ പണവ്യാപാരിയെപ്പോലെ പെരുമാറരുത്; ആ വ്യക്തിയിൽനിന്ന് പലിശ ഈടാക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","അയൽവാസിയുടെ പുറങ്കുപ്പായം പണയമായി വാങ്ങിയാൽ, സന്ധ്യയാകുമ്പോൾ അത് അയാൾക്കു തിരിച്ചുകൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ആ പുറങ്കുപ്പായംമാത്രമാണ് ആ മനുഷ്യന്റെ ശരീരത്തിനുള്ള ഏക ആവരണം. അയാൾക്കു പുതച്ചുകൊണ്ട് ഉറങ്ങാൻ മറ്റെന്താണുള്ളത്? ആ അയൽവാസി എന്നോടു നിലവിളിക്കുമ്പോൾ ഞാൻ കേൾക്കും; ഞാൻ അനുകമ്പയുള്ളവനല്ലോ. ");
INSERT INTO malc_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ദൈവത്തെ ദുഷിക്കുകയോ നിന്റെ ജനത്തിന്റെ ഭരണകർത്താവിനെ ശപിക്കുകയോ അരുത്. ");
INSERT INTO malc_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“നിന്റെ ധാന്യശേഖരത്തിൽനിന്നും വീഞ്ഞുശേഖരത്തിൽനിന്നും ഉള്ള വഴിപാടുകൾ അർപ്പിക്കാൻ വൈകരുത്. “നിന്റെ പുത്രന്മാരിൽ ആദ്യജാതനെ എനിക്കു നൽകണം. ");
INSERT INTO malc_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","നിന്റെ കന്നുകാലികളുടെയും ആടുകളുടെയും കാര്യത്തിലും അങ്ങനെതന്നെ ചെയ്യണം. അതു തള്ളയോടുകൂടെ ഏഴുദിവസം നിന്നുകൊള്ളട്ടെ, എന്നാൽ എട്ടാംദിവസം അതിനെ എനിക്കു തരണം. ");
INSERT INTO malc_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“നിങ്ങൾ എന്റെ വിശുദ്ധജനമായിരിക്കേണ്ടവരാണ്. അതുകൊണ്ട് വന്യമൃഗങ്ങൾ കടിച്ചുകീറിയ മൃഗങ്ങളുടെ മാംസം ഭക്ഷിക്കരുത്; അതു നായ്ക്കൾക്ക് ഇട്ടുകൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“വ്യാജവാർത്ത പ്രചരിപ്പിക്കരുത്. ദുഷ്ടരായവരെ സഹായിക്കാൻ കള്ളസ്സാക്ഷിയാകരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“ദോഷം പ്രവർത്തിക്കാൻ ഭൂരിപക്ഷത്തോടു യോജിക്കരുത്. വ്യവഹാരത്തിൽ സാക്ഷ്യം പറയുമ്പോൾ ജനക്കൂട്ടത്തോടുചേർന്നു ന്യായം അട്ടിമറിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ദരിദ്രന്റെ വ്യവഹാരത്തിൽ ആ വ്യക്തിയോടു പക്ഷഭേദം കാട്ടുകയും അരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“നിന്റെ ശത്രുവിന്റെ കാളയോ കഴുതയോ അലഞ്ഞുതിരിയുന്നതായി കണ്ടാൽ നിശ്ചയമായും അതിനെ ആ മനുഷ്യന്റെ അടുക്കൽ തിരിച്ചെത്തിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","നിന്നെ വെറുക്കുന്ന ആരുടെയെങ്കിലും കഴുത അതിന്റെ ചുമടിനുകീഴിൽ വീണുകിടക്കുന്നതു കണ്ടാൽ അതിനെ ഉപേക്ഷിച്ചു പോകരുത്. അക്കാര്യത്തിൽ അവരെ നിശ്ചയമായും സഹായിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“വ്യവഹാരത്തിൽ ദരിദ്രനു നീതി നിഷേധിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","വ്യാജാരോപണത്തിൽ നിനക്കു പങ്കുണ്ടാകരുത്. നിരപരാധിയും നീതിമാനും ആയ ഒരു മനുഷ്യനെയും കൊല്ലരുത്. കുറ്റവാളിയെ ഞാൻ ശിക്ഷിക്കാതെ വിടുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“കൈക്കൂലി വാങ്ങരുത്; കൈക്കൂലി കാഴ്ചയുള്ളവരെ അന്ധരാക്കുകയും നിഷ്കളങ്കരുടെ വചനം കോട്ടിക്കളയുകയും ചെയ്യുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“പ്രവാസികളെ പീഡിപ്പിക്കരുത്; ഈജിപ്റ്റിൽ പ്രവാസികളായിരുന്ന നിങ്ങൾക്ക് ഒരു വിദേശിയുടെ ജീവിതം എങ്ങനെയെന്ന് അറിയാമല്ലോ. ");
INSERT INTO malc_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ആറുവർഷം നിന്റെ വയലിൽ വിതച്ച് വിളവു ശേഖരിച്ചുകൊൾക. ");
INSERT INTO malc_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","എന്നാൽ ഏഴാംവർഷം നിലം ഉഴാതെ തരിശായിടുക. നിന്റെ ജനത്തിലെ ദരിദ്രർ അതിൽനിന്ന് ആഹാരത്തിനുള്ളതു ശേഖരിക്കട്ടെ. അവർ ഉപേക്ഷിക്കുന്നതു കാട്ടുജന്തുക്കൾ തിന്നട്ടെ. മുന്തിരിത്തോപ്പിന്റെയും ഒലിവുതോട്ടത്തിന്റെയും കാര്യത്തിലും ഇങ്ങനെതന്നെ ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ആറുദിവസം നിന്റെ ജോലി ചെയ്യണം; എന്നാൽ നിന്റെ കാളയും കഴുതയും വിശ്രമിക്കേണ്ടതിനും, നിന്റെ ദാസിയുടെ പുത്രനും പ്രവാസിയും ഉന്മേഷം പ്രാപിക്കേണ്ടതിനും ഏഴാംദിവസം വേല ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ഞാൻ നിങ്ങളോടു കൽപ്പിച്ചിട്ടുള്ളതെല്ലാം ജാഗ്രതയോടെ ചെയ്യണം. അന്യദേവന്മാരുടെ നാമം സ്മരിക്കരുത്. അവ നിന്റെ അധരങ്ങളിൽനിന്നു കേൾക്കാൻ ഇടയാകുകയുമരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“വർഷത്തിൽ മൂന്നുപ്രാവശ്യം നിങ്ങൾ എനിക്കായി ഉത്സവം ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“പുളിപ്പില്ലാത്ത അപ്പത്തിന്റെ ഉത്സവം ആചരിക്കുക. ഞാൻ നിങ്ങളോടു കൽപ്പിച്ചതുപോലെ പുളിമാവു ചേർക്കാതെ ഉണ്ടാക്കിയ അപ്പം ഏഴുദിവസം ഭക്ഷിക്കണം. ആബീബുമാസത്തിലെ, നിശ്ചയിക്കപ്പെട്ട സമയത്തുവേണം ഇതു ഭക്ഷിക്കേണ്ടത്; ആ മാസത്തിലാണല്ലോ നിങ്ങൾ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെട്ടത്. “ആരും എന്റെ സന്നിധിയിൽ വെറുങ്കൈയോടെ വരരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“നിങ്ങളുടെ വയലിൽനിന്നുള്ള ആദ്യഫലം ശേഖരിക്കുമ്പോൾ കൊയ്ത്തുത്സവം ആചരിക്കണം. “വർഷാവസാനം നിങ്ങൾ വയലിലെ വിളവു ശേഖരിച്ചു കഴിയുമ്പോൾ കായ്-കനിപ്പെരുന്നാൾ ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“വർഷത്തിൽ മൂന്നുപ്രാവശ്യം സകലപുരുഷന്മാരും കർത്താവായ യഹോവയുടെ സന്നിധിയിൽ വരണം. ");
INSERT INTO malc_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“പുളിപ്പുള്ള യാതൊന്നിനോടുംകൂടെ എനിക്കു യാഗരക്തം അർപ്പിക്കരുത്. “എനിക്ക് അർപ്പിക്കുന്ന ഉത്സവയാഗങ്ങളുടെ മേദസ്സ് പ്രഭാതംവരെ സൂക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“നിന്റെ നിലത്തിലെ ആദ്യഫലങ്ങളിൽ ഏറ്റം മെച്ചമായവ നിന്റെ ദൈവമായ യഹോവയുടെ ആലയത്തിൽ കൊണ്ടുവരണം. “ആട്ടിൻകുട്ടിയെ അതിന്റെ തള്ളയുടെ പാലിൽ പാകംചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“വഴിയിൽ നിന്നെ സംരക്ഷിച്ച്, ഞാൻ ഒരുക്കിയിരിക്കുന്ന സ്ഥലത്തു നിന്നെ കൊണ്ടുവരാൻ ഇതാ ഞാൻ ഒരു ദൂതനെ നിനക്കുമുമ്പായി അയയ്ക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","അവനെ ശ്രദ്ധിക്കുകയും അവന്റെ വാക്കു കേൾക്കുകയും വേണം. അവനെ എതിർക്കരുത്; എന്റെ നാമം അവനിൽ ഉള്ളതുകൊണ്ട് അവൻ നിന്റെ എതിർപ്പു ക്ഷമിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","അവൻ പറയുന്നതു ശ്രദ്ധിച്ചുകേട്ട് ഞാൻ കൽപ്പിക്കുന്നതെല്ലാം പ്രവർത്തിച്ചാൽ ഞാൻ നിന്റെ ശത്രുക്കൾക്ക് ശത്രുവും നിന്റെ പ്രതിയോഗികൾക്ക് പ്രതിയോഗിയും ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","എന്റെ ദൂതൻ നിനക്കുമുമ്പായി പോകുകയും അമോര്യർ, ഹിത്യർ, പെരിസ്യർ, കനാന്യർ, ഹിവ്യർ, യെബൂസ്യർ എന്നിവരുടെ ദേശത്തേക്കു നിന്നെ കൊണ്ടുവരികയും അവരെ തുടച്ചുനീക്കുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","അവരുടെ ദേവതകൾക്കുമുന്നിൽ വണങ്ങുകയോ ആരാധിക്കുകയോ അവരുടെ ആചാരങ്ങൾ അനുവർത്തിക്കുകയോ ചെയ്യരുത്. നീ അവരെ നശിപ്പിച്ച് അവരുടെ ആചാരസ്തൂപങ്ങൾ തകർത്തുകളയണം. ");
INSERT INTO malc_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","നിന്റെ ദൈവമായ യഹോവയെ ആരാധിക്കണം; നിന്റെ ആഹാരത്തിന്മേലും വെള്ളത്തിന്മേലും അവിടത്തെ അനുഗ്രഹം ഉണ്ടായിരിക്കും. ഞാൻ നിങ്ങളുടെ ഇടയിൽനിന്ന് രോഗം നീക്കിക്കളയും. ");
INSERT INTO malc_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ഗർഭം അലസുന്നവളോ വന്ധ്യയോ നിന്റെ ദേശത്ത് ഉണ്ടായിരിക്കുകയില്ല. ഞാൻ നിനക്കു പൂർണായുഷ്കാലം തരും. ");
INSERT INTO malc_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“ഞാൻ നിനക്കുമുമ്പായി എന്റെ ഭീതി അയച്ച്, നീ നേരിടുന്ന ഓരോ ജനതയെയും പരിഭ്രാന്തരാക്കും. അങ്ങനെ ഞാൻ നിന്റെ സകലശത്രുക്കളെയും പിന്തിരിഞ്ഞോടിപ്പിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ഹിവ്യരെയും കനാന്യരെയും ഹിത്യരെയും നിന്റെ വഴിയിൽനിന്ന് ആട്ടിയോടിക്കാൻ ഞാൻ നിനക്കുമുമ്പായി കടന്നലിനെ അയയ്ക്കും. ");
INSERT INTO malc_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","എന്നാൽ ദേശം വിജനമായിത്തീർന്ന്, കാട്ടുമൃഗങ്ങളുടെ ആധിക്യം നിന്നെ ബാധിക്കുമെന്നുള്ളതുകൊണ്ട് ഞാൻ ഒരു വർഷത്തിനകം അവരെ ആട്ടിയോടിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","നീ വേണ്ടുവോളം പെരുകി ദേശം അവകാശമാക്കുമ്പോഴേക്കും ഞാൻ അവരെ കുറേശ്ശെ കുറേശ്ശെയായി നിന്റെ മുമ്പിൽനിന്ന് ആട്ടിയോടിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“ഞാൻ നിന്റെ ദേശം ചെങ്കടൽമുതൽ മെഡിറ്ററേനിയൻ കടൽവരെയും മരുഭൂമിമുതൽ യൂഫ്രട്ടീസ് നദിവരെയും ആക്കി അതിർത്തികൾ സ്ഥിരമാക്കും. ഞാൻ ദേശവാസികളെ നിനക്കു കൈമാറുകയും നീ അവരെ നിന്റെ മുമ്പിൽനിന്ന് ഓടിച്ചുകളയുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","അവരുമായോ അവരുടെ ദേവതമാരുമായോ ഒരു ഉടമ്പടിയും ഉണ്ടാക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","അവരുടെ ദേവതമാരെ ആരാധിക്കുന്നതു നിനക്കു നിശ്ചയമായും കെണി ആകുമെന്നുള്ളതുകൊണ്ട് അവരെ നിന്റെ ദേശത്തു വസിക്കാൻ അനുവദിക്കരുത്; അനുവദിച്ചാൽ അവർ നിങ്ങളെക്കൊണ്ട് എനിക്കു വിരോധമായി പാപം ചെയ്യിക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ഇതിനുശേഷം യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “നീയും അഹരോനും നാദാബും അബീഹൂവും ഇസ്രായേൽ തലവന്മാരിൽ എഴുപതുപേരും യഹോവയുടെ അടുത്തേക്കു കയറിവരിക. നിങ്ങൾ ദൂരെനിന്ന് ആരാധിക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","എന്നാൽ മോശമാത്രം യഹോവയെ സമീപിക്കട്ടെ, മറ്റുള്ളവർ അടുത്തുവരാൻ പാടില്ല. ജനം മോശയോടുകൂടെ കയറിവരികയുമരുത്.” ");
INSERT INTO malc_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","മോശ ചെന്ന് യഹോവയുടെ വചനങ്ങളും നിയമങ്ങളും ജനത്തെ അറിയിച്ചു. “യഹോവ കൽപ്പിച്ചിട്ടുള്ളതെല്ലാം ഞങ്ങൾ ചെയ്യും,” എന്ന് അവർ ഏകസ്വരത്തിൽ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","പിന്നെ, യഹോവ അരുളിച്ചെയ്തതെല്ലാം മോശ എഴുതിവെച്ചു. പിറ്റേന്ന് അതിരാവിലെ മോശ എഴുന്നേറ്റ് മലയുടെ അടിവാരത്ത് ഒരു യാഗപീഠം പണിയുകയും ഇസ്രായേൽ ഗോത്രങ്ങൾ പന്ത്രണ്ടിനെയും പ്രതിനിധാനം ചെയ്യുന്ന പന്ത്രണ്ടു കൽത്തൂണുകൾ സ്ഥാപിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","അതിനുശേഷം അദ്ദേഹം ചില ഇസ്രായേല്യയുവാക്കന്മാരെ അയച്ചു; അവർ ചെന്നു ഹോമയാഗങ്ങൾ അർപ്പിക്കുകയും യഹോവയ്ക്കു സമാധാനയാഗമായി കാളക്കിടാങ്ങളെ അർപ്പിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","മോശ രക്തത്തിൽ പകുതി പാത്രങ്ങളിൽ ആക്കി; മറ്റേപകുതി യാഗപീഠത്തിന്മേൽ തളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","പിന്നെ അദ്ദേഹം ഉടമ്പടിയുടെ പുസ്തകം എടുത്തു ജനത്തെ വായിച്ചുകേൾപ്പിച്ചു. “ഞങ്ങൾ യഹോവയെ അനുസരിക്കും; അവിടന്നു കൽപ്പിച്ചിട്ടുള്ളതെല്ലാം ചെയ്യും,” എന്നു ജനം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","മോശ രക്തം എടുത്തു ജനത്തിന്റെമേൽ തളിച്ചു. “ഈ വചനങ്ങൾ എല്ലാം അനുസരിച്ച് യഹോവ നിങ്ങളുമായി ചെയ്തിരിക്കുന്ന ഉടമ്പടിയുടെ രക്തം ഇതാകുന്നു,” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ഇതിനുശേഷം മോശയും അഹരോനും നാദാബും അബീഹൂവും ഇസ്രായേൽ തലവന്മാർ എഴുപതുപേരും ചെന്ന് ");
INSERT INTO malc_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ഇസ്രായേലിന്റെ ദൈവത്തെ കണ്ടു. അവിടത്തെ പാദങ്ങൾക്കുകീഴേ ഇന്ദ്രനീലം പതിച്ച തളംപോലെയോ സ്വച്ഛനീലാകാശംപോലെയോ എന്തോ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","എന്നാൽ ഇസ്രായേലിന്റെ ഈ നായകന്മാർക്കു തൃക്കൈയാൽ ഒന്നും ഭവിച്ചില്ല. അവർ ദൈവത്തെ കണ്ട് ഭക്ഷണപാനീയങ്ങൾ കഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","യഹോവ മോശയോട്, “നീ പർവതത്തിൽ കയറിവന്ന് ഇവിടെ കാത്തിരിക്കുക; അവരുടെ പ്രബോധനത്തിനായി നിയമവും കൽപ്പനകളും എഴുതിയിട്ടുള്ള കൽപ്പലകകൾ ഞാൻ നിങ്ങളെ പഠിപ്പിക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","മോശ സഹായിയായ യോശുവയോടുകൂടെ പുറപ്പെട്ടു. മോശ ദൈവത്തിന്റെ പർവതത്തിലേക്കു കയറിച്ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ഗോത്രത്തലവന്മാരോട് അദ്ദേഹം, “ഞങ്ങൾ നിങ്ങളുടെ അടുക്കൽ തിരിച്ചെത്തുന്നതുവരെ ഞങ്ങൾക്കായി ഇവിടെ കാത്തിരിക്കുക. അഹരോനും ഹൂരും നിങ്ങളോടുകൂടെ ഉണ്ടല്ലോ; ആർക്കെങ്കിലും ഒരു തർക്കമുണ്ടായാൽ അവരെ സമീപിക്കാവുന്നതാണ്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","മോശ പർവതത്തിലേക്കു കയറിപ്പോയി. അപ്പോൾ ഒരു മേഘം പർവതത്തെ മൂടി. ");
INSERT INTO malc_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","യഹോവയുടെ തേജസ്സ് സീനായിമലമേൽ ആവസിച്ചു. ആറുദിവസം മേഘം പർവതത്തെ മൂടിയിരുന്നു. ഏഴാംദിവസം യഹോവ മേഘത്തിനുള്ളിൽനിന്ന് മോശയെ വിളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","യഹോവയുടെ തേജസ്സ് ഇസ്രായേല്യർക്ക് പർവതത്തിന്റെ മുകളിൽ കത്തിയെരിയുന്ന തീപോലെ കാണപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","മോശ പർവതത്തിന്റെ മുകളിലേക്കു ചെന്ന് മേഘത്തിനുള്ളിൽ പ്രവേശിച്ചു. മോശ നാൽപ്പതുപകലും നാൽപ്പതുരാത്രിയും പർവതത്തിൽ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“നീ ഇസ്രായേല്യരോട് എനിക്കു കാഴ്ചദ്രവ്യം കൊണ്ടുവരാൻ പറയണം. സന്മനസ്സുള്ള ഏവനോടും നിങ്ങൾ വഴിപാടു വാങ്ങണം. ");
INSERT INTO malc_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“അവരിൽനിന്ന് വാങ്ങേണ്ടുന്ന കാഴ്ചദ്രവ്യങ്ങൾ ഇവയാണ്: “പൊന്ന്, വെള്ളി, വെങ്കലം. ");
INSERT INTO malc_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, നേർമയേറിയ ചണവസ്ത്രം, കോലാട്ടുരോമം, ");
INSERT INTO malc_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ആട്ടുകൊറ്റന്റെ ചെമപ്പിച്ച തുകൽ, തഹശുതുകൽ, ഖദിരമരം; ");
INSERT INTO malc_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","വിളക്കിനുള്ള ഒലിവെണ്ണ, അഭിഷേകതൈലത്തിനും സുഗന്ധധൂപത്തിനും വേണ്ടുന്ന സുഗന്ധദ്രവ്യങ്ങൾ, ");
INSERT INTO malc_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ഏഫോദിലും നിർണയപ്പതക്കത്തിലും പതിക്കാനുള്ള ഗോമേദകക്കല്ല്, മറ്റു രത്നങ്ങൾ എന്നിവതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“ഞാൻ അവരുടെ മധ്യേ വസിക്കേണ്ടതിനായി അവർ എനിക്ക് ഒരു വിശുദ്ധമന്ദിരം നിർമിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ഈ സമാഗമകൂടാരവും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും ഞാൻ നിനക്കു കാണിച്ചുതരാനിരിക്കുന്ന മാതൃകയനുസരിച്ചുതന്നെ ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“അവർ ഖദിരമരംകൊണ്ട് എനിക്ക് ഒരു പേടകം പണിയണം; അതിനു രണ്ടരമുഴം നീളവും ഒന്നരമുഴം വീതിയും ഒന്നരമുഴം ഉയരവും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","അതിന്റെ അകവും പുറവും തങ്കംകൊണ്ടു പൊതിയണം. അതിനുചുറ്റും തങ്കംകൊണ്ടു വാർത്തുണ്ടാക്കിയ ഒരു അരികുപാളി പിടിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","അതിന്റെ നാലു കാലിനുമായി നാലു തങ്കവളയം വാർത്തുണ്ടാക്കി, രണ്ടു വളയം ഒരുവശത്തും രണ്ടു വളയം മറ്റേവശത്തുമായി പിടിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","അതിനുശേഷം ഖദിരമരംകൊണ്ടു തണ്ടുകൾ ഉണ്ടാക്കി അവ തങ്കംകൊണ്ടു പൊതിയണം. ");
INSERT INTO malc_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","പേടകം ചുമക്കേണ്ടതിന് ആ തണ്ടുകൾ അതിന്റെ വശങ്ങളിലുള്ള വളയങ്ങളിൽ കടത്തിവെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","തണ്ടുകൾ പേടകത്തിന്റെ വളയങ്ങളിൽത്തന്നെ ഇരിക്കണം; അവ നീക്കംചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ഞാൻ നിനക്കു തരാനിരിക്കുന്ന ഉടമ്പടിയുടെ പലക പേടകത്തിൽ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“തങ്കംകൊണ്ട് രണ്ടരമുഴം നീളവും ഒന്നരമുഴം വീതിയുമുള്ള പാപനിവാരണസ്ഥാനം ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","അതിനുശേഷം പാപനിവാരണസ്ഥാനത്തിന്റെ രണ്ടറ്റത്തും അടിപ്പുപണിയായി തങ്കംകൊണ്ടു രണ്ടു കെരൂബുകൾ നിർമിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ഒരു കെരൂബ് ഒരറ്റത്തും മറ്റേ കെരൂബ് മറ്റേ അറ്റത്തും. ഇങ്ങനെ കെരൂബുകളെ പാപനിവാരണസ്ഥാനത്തിന്റെ രണ്ടറ്റത്തും അതിൽനിന്നുതന്നെ ഉള്ളതായി യോജിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","കെരൂബുകൾ മുകളിലേക്കു ചിറകുകൾ വിടർത്തി, ചിറകുകൾകൊണ്ടു പാപനിവാരണസ്ഥാനത്തെ മൂടണം; അവ പരസ്പരം അഭിമുഖമായിരിക്കണം. കെരൂബുകളുടെ മുഖം പാപനിവാരണസ്ഥാനത്തിനുനേരേ ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","പാപനിവാരണസ്ഥാനം പേടകത്തിന്റെ മുകളിൽ വെക്കണം; ഞാൻ നിനക്കു തരാൻ പോകുന്ന ഉടമ്പടിയുടെ പലക പേടകത്തിന്റെ ഉള്ളിൽ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","അവിടെ പാപനിവാരണസ്ഥാനത്തിനു മുകളിൽ ഉടമ്പടിയുടെ പേടകത്തിനുമീതേയുള്ള രണ്ടു കെരൂബുകൾക്കും മധ്യേ ഞാൻ നിനക്കു പ്രത്യക്ഷനായി, ഇസ്രായേല്യർക്കുള്ള കൽപ്പനകളെല്ലാം നിന്നോട് അരുളിച്ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ഖദിരമരംകൊണ്ടു മേശ ഉണ്ടാക്കണം; അതിനു രണ്ടുമുഴം നീളവും ഒരുമുഴം വീതിയും ഒന്നരമുഴം പൊക്കവും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","അതു തങ്കംകൊണ്ടു പൊതിയുകയും ചുറ്റും തങ്കംകൊണ്ട് ഒരു വക്ക് ഉണ്ടാക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","മേശയുടെ ചുറ്റും കൈപ്പത്തിയുടെ വീതിയുള്ള ഒരു പട്ടയും പട്ടയ്ക്കുമേൽ തങ്കംകൊണ്ടു വാർത്തുണ്ടാക്കിയ അരികുപാളിയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","മേശയ്ക്കു നാലു തങ്കവളയം ഉണ്ടാക്കണം. അത് നാലു കോണുകളിലുമുള്ള നാലു കാലുകളിൽ ഉറപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","മേശ ചുമക്കാൻ ഉപയോഗിക്കുന്ന തണ്ടുകൾ ചെലുത്താൻ തക്കവണ്ണം വളയങ്ങൾ പട്ടയോടു ചേർന്നിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","തണ്ടുകൾ ഖദിരമരംകൊണ്ടുണ്ടാക്കി തങ്കംകൊണ്ടു പൊതിയണം. അവ ഉപയോഗിച്ച് മേശ ചുമക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","അതിന്റെ തളികകളും താലങ്ങളും പാനീയയാഗങ്ങൾ പകരുന്നതിനുള്ള ഭരണികളും കിണ്ടികളും തങ്കംകൊണ്ടായിരിക്കണം നിർമിക്കേണ്ടത്. ");
INSERT INTO malc_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","മേശമേൽ നിത്യവും കാഴ്ചയപ്പം എന്റെമുമ്പിൽ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“തങ്കംകൊണ്ട് ഒരു നിലവിളക്കു നിർമിക്കണം. വിളക്കിന്റെ ചുവടും തണ്ടും പുഷ്പപുടങ്ങളും മൊട്ടുകളും പൂക്കളും ഒറ്റത്തണ്ടിൽനിന്ന് അടിച്ചുണ്ടാക്കിയതായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","നിലവിളക്കിന്റെ ഒരു വശത്തുനിന്നു മൂന്നുശാഖ, മറ്റേവശത്തുനിന്നു മൂന്നുശാഖ, ഇങ്ങനെ ആറുശാഖകൾ ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ഓരോശാഖയിൽ ഓരോമൊട്ടും ഓരോപൂവുമായി ബദാംപുഷ്പംപോലെ മൂന്നു പുഷ്പപുടവും, അതുപോലെ അടുത്തശാഖയിലും ഉണ്ടായിരിക്കണം; ഇങ്ങനെ വിളക്കിന്റെ ആറുശാഖയിലും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","നിലവിളക്കിൽ മൊട്ടുകളോടും പൂക്കളോടുംകൂടിയ ബദാംപൂക്കൾപോലുള്ള നാലു പുടങ്ങൾ വേണം. ");
INSERT INTO malc_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","നിലവിളക്കിൽനിന്നു നീണ്ടുനിൽക്കുന്ന ശാഖകളിൽ ഒന്നാമത്തെ ജോടിക്കുകീഴേ ഒരു മൊട്ട്, രണ്ടാമത്തെ ജോടിക്കുകീഴേ മറ്റൊരു മൊട്ട്, മൂന്നാമത്തെ ജോടിക്കുകീഴേ വേറൊരു മൊട്ട് എന്നിങ്ങനെ ആറു ശാഖയ്ക്കും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","മൊട്ടുകളും ശാഖകളും നിലവിളക്കിൽനിന്നുള്ള ഒറ്റഖണ്ഡമെന്നവിധത്തിൽ തങ്കംകൊണ്ട് അടിച്ചുപണിതതായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“അതിന് ഏഴ് ദീപങ്ങൾ ഉണ്ടാക്കി, മുൻവശത്തുള്ള സ്ഥലം പ്രകാശിപ്പിക്കാൻ തക്കവണ്ണം ദീപങ്ങൾ കൊളുത്തണം. ");
INSERT INTO malc_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","അതു വെടിപ്പാക്കുന്നതിനുള്ള കത്രികകളും കരിന്തിരിപ്പാത്രങ്ങളും തങ്കംകൊണ്ടുണ്ടാക്കിയതായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","നിലവിളക്കും അതിനോടുചേർന്നുള്ള എല്ലാ ഉപകരണങ്ങളും ഉണ്ടാക്കുന്നതിന് ഒരു താലന്തു തങ്കം ഉപയോഗിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","പർവതത്തിൽവെച്ച് ഞാൻ നിനക്കു കാണിച്ചുതന്ന അതേ മാതൃകപ്രകാരം സകലതും കൃത്യമായി നിർമിക്കാൻ പ്രത്യേകം ശ്രദ്ധിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“പിരിച്ച മൃദുലചണനൂൽ, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ എന്നിവകൊണ്ടുണ്ടാക്കിയ പത്തു തിരശ്ശീലകൊണ്ടു സമാഗമകൂടാരം നിർമിക്കണം; തിരശ്ശീലകളിൽ നെയ്ത്തുകാരന്റെ ചിത്രപ്പണിയായി കെരൂബുകൾ ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","എല്ലാ തിരശ്ശീലകൾക്കും ഒരേ അളവായിരിക്കണം; ഓരോ തിരശ്ശീലയ്ക്കും ഇരുപത്തെട്ടുമുഴം നീളവും നാലുമുഴം വീതിയും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","അഞ്ചു തിരശ്ശീലകളും ഒന്നോടൊന്നു തുന്നിച്ചേർക്കണം; മറ്റേ അഞ്ചു തിരശ്ശീലകളും ഒന്നോടൊന്നു തുന്നിച്ചേർക്കണം; ");
INSERT INTO malc_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ഇങ്ങനെ തുന്നിച്ചേർത്ത ഒന്നാമത്തെ വിരിയുടെ അറ്റത്തുള്ള തിരശ്ശീലയുടെ വിളുമ്പിൽ നീലനൂൽകൊണ്ടു കണ്ണികൾ ഉണ്ടാക്കണം. മറ്റേ വിരിയുടെ അറ്റത്തുള്ള തിരശ്ശീലയുടെ വിളുമ്പിലും അതുപോലെ കണ്ണികൾ ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ഒരുകൂട്ടം തിരശ്ശീലയിൽ അൻപതു കണ്ണികൾ ഉണ്ടാക്കണം. രണ്ടാമത്തെ കൂട്ടം തിരശ്ശീലയുടെ വിളുമ്പിലും അൻപതു കണ്ണികൾ ഉണ്ടാക്കണം. കണ്ണികൾ നേർക്കുനേർ ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","തങ്കംകൊണ്ട് അൻപതു കൊളുത്തും ഉണ്ടാക്കണം. സമാഗമകൂടാരം ഒന്നായിരിക്കത്തക്കവണ്ണം തിരശ്ശീലകളെ കൊളുത്തുകൊണ്ട് ഒന്നായി പിണച്ചുചേർക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“സമാഗമകൂടാരത്തിന്മേൽ മൂടുവിരിയായി, കോലാട്ടുരോമംകൊണ്ടു പതിനൊന്നു തിരശ്ശീല ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","പതിനൊന്നു തിരശ്ശീലയ്ക്കും ഒരേ അളവ് ആയിരിക്കണം. ഓരോന്നിനും മുപ്പതുമുഴം നീളവും നാലുമുഴം വീതിയും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","അഞ്ചു തിരശ്ശീല ഒരുമിച്ചും മറ്റ് ആറു തിരശ്ശീല ഒരുമിച്ചും തുന്നിച്ചേർക്കണം; ആറാമത്തെ തിരശ്ശീല കൂടാരത്തിന്റെ മുൻവശത്തു മടക്കി ഇടണം. ");
INSERT INTO malc_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","തുന്നിച്ചേർത്ത ഒന്നാമത്തെ വിരിയുടെ അറ്റത്തുള്ള തിരശ്ശീലയുടെ വിളുമ്പിൽ അൻപതു കണ്ണിയും രണ്ടാമത്തെ വിരിയുടെ അറ്റത്തുള്ള തിരശ്ശീലയുടെ വിളുമ്പിൽ അൻപതു കണ്ണിയും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","അതിനുശേഷം വെങ്കലംകൊണ്ട് അൻപതു കൊളുത്ത് ഉണ്ടാക്കണം. കൂടാരം ഒന്നായി ഇണച്ചുചേർക്കത്തക്കവണ്ണം, കൊളുത്തുകൾ കണ്ണികളിൽ ഇട്ട് ഒന്നായി യോജിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","കൂടാരതിരശ്ശീലകളിൽ മിച്ചമായി കവിഞ്ഞുകിടക്കുന്ന പകുതിഭാഗം, സമാഗമകൂടാരത്തിന്റെ പിൻവശത്തു തൂക്കിയിടണം. ");
INSERT INTO malc_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","മൂടുവിരിയുടെ നീളത്തിൽ ശേഷിപ്പുള്ള ഭാഗം, സമാഗമകൂടാരത്തെ മൂടേണ്ടതിന് ഒരുവശത്ത് ഒരുമുഴവും മറ്റേവശത്ത് ഒരുമുഴവും എന്നിങ്ങനെ രണ്ടുവശങ്ങളിലും തൂങ്ങിക്കിടക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ആട്ടുകൊറ്റന്റെ ചെമപ്പിച്ചതുകൽകൊണ്ടു കൂടാരത്തിന് ഒരു മൂടിയും അതിന്റെമീതേ തഹശുതുകൽകൊണ്ട് ഒരു പുറമൂടിയും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“സമാഗമകൂടാരത്തിനു നിവർന്നുനിൽക്കുന്ന ഖദിരമരംകൊണ്ടുള്ള പലകകൾ ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ഓരോ പലകയ്ക്കും പത്തുമുഴം നീളവും ഒന്നരമുഴം വീതിയും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","പലകകൾതമ്മിൽ ചേർന്നിരിക്കുംവിധം ഓരോ പലകയ്ക്കും രണ്ടു കുടുമകൾവീതം ഉണ്ടാക്കണം. സമാഗമകൂടാരത്തിന്റെ എല്ലാ പലകകളും ഇതേരീതിയിൽ ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","സമാഗമകൂടാരത്തിന്റെ തെക്കുവശത്ത് ഇരുപതു പലക ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ഒരു പലകയുടെ അടിയിൽ രണ്ടു കുടുമകളും അതിനു രണ്ടു ചുവടും അങ്ങനെ നാൽപ്പതു വെള്ളിച്ചുവടും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","സമാഗമകൂടാരത്തിന്റെ മറ്റേവശമായ വടക്കുവശത്ത് ഇരുപതു പലകയും ");
INSERT INTO malc_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ഒരു പലകയുടെ അടിയിൽ രണ്ടു ചുവടുകൾവീതം നാൽപ്പതു വെള്ളിച്ചുവടുകളും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","സമാഗമകൂടാരത്തിന്റെ പിൻഭാഗമായ പടിഞ്ഞാറുവശത്ത് ആറു പലകകൾ ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","സമാഗമകൂടാരത്തിന്റെ ഇരുവശത്തുമുള്ള കോണുകൾക്ക് ഈരണ്ടു പലകയും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","രണ്ടു മൂലകളിലും, താഴെമുതൽ മുകളിൽ ഒറ്റവളയംവരെ അവ ഇരട്ടപ്പലകയായിരിക്കണം. രണ്ടു പലകകളും ഇപ്രകാരം ആയിരിക്കണം. അവ രണ്ടും മൂലപ്പലകകളാണ്. ");
INSERT INTO malc_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ഇങ്ങനെ എട്ടു പലകയും ഓരോ പലകയുടെയും അടിയിൽ രണ്ടു ചുവടുവീതം പതിനാറു വെള്ളിച്ചുവടും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“ഖദിരമരംകൊണ്ടു സാക്ഷകൾ ഉണ്ടാക്കുക; സമാഗമകൂടാരത്തിന്റെ ഒരു വശത്തെ പലകയ്ക്ക് അഞ്ചു സാക്ഷയും ");
INSERT INTO malc_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","മറുവശത്തെ പലകകൾക്ക് അഞ്ചു സാക്ഷയും സമാഗമകൂടാരത്തിന്റെ പിൻഭാഗമായ പടിഞ്ഞാറുവശത്തെ പലകകൾക്ക് അഞ്ചു സാക്ഷയും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","നടുവിലുള്ള സാക്ഷ പലകകളുടെ നടുവിൽ ഒരറ്റംമുതൽ മറ്റേ അറ്റംവരെ എത്തുന്നതായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","പലകകൾ തങ്കംകൊണ്ടു പൊതിയണം; സാക്ഷ കടത്തുന്നതിന് തങ്കംകൊണ്ടു വളയങ്ങൾ ഉണ്ടാക്കണം; സാക്ഷകളും തങ്കംകൊണ്ടു പൊതിയണം. ");
INSERT INTO malc_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“പർവതത്തിൽ നിനക്കു കാണിച്ചുതന്ന മാതൃകയനുസരിച്ചു നീ സമാഗമകൂടാരം ഉയർത്തണം. ");
INSERT INTO malc_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ട് ഒരു തിരശ്ശീല ഉണ്ടാക്കണം. തിരശ്ശീലയിൽ കെരൂബുകളുടെ രൂപം ചിത്രപ്പണിയായി നെയ്ത്തുകാരൻ തുന്നിച്ചേർക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","നാലു വെള്ളിച്ചുവടുകളിൽ നിൽക്കുന്നതും തങ്കം പൊതിഞ്ഞ ഖദിരമരംകൊണ്ടുള്ള നാലു തൂണുകളുടെന്മേൽ അവ തങ്കക്കൊളുത്തുകളിൽ തൂക്കിയിടണം. ");
INSERT INTO malc_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","കൊളുത്തുകളിൽ തിരശ്ശീല തൂക്കിയിടണം; തിരശ്ശീലയ്ക്കു പിന്നിൽ ഉടമ്പടിയുടെ പേടകം വെക്കണം. തിരശ്ശീല വിശുദ്ധസ്ഥലവും അതിവിശുദ്ധസ്ഥലവുംതമ്മിൽ വേർതിരിക്കുന്നതായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","അതിവിശുദ്ധസ്ഥലത്ത്, ഉടമ്പടിയുടെ പേടകത്തിനുമീതേ പാപനിവാരണസ്ഥാനം വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","തിരശ്ശീലയ്ക്കു വെളിയിൽ, സമാഗമകൂടാരത്തിന്റെ വടക്കുഭാഗത്തു മേശയും, മേശയുടെ എതിരേ തെക്കുഭാഗത്തു നിലവിളക്കും വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“കൂടാരവാതിലിനു നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽപ്പണിയായി ഒരു മറശ്ശീലയും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ഈ മറശ്ശീലയ്ക്ക് തങ്കക്കൊളുത്തുകൾ ഉണ്ടാക്കണം; ഖദിരമരംകൊണ്ട് അഞ്ചുതൂണുകൾ ഉണ്ടാക്കി, അവ തങ്കംകൊണ്ടു പൊതിയണം. അവയ്ക്കു വെങ്കലംകൊണ്ട് അഞ്ചു ചുവടും വാർത്തുണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“ഖദിരമരംകൊണ്ട് ഒരു യാഗപീഠം ഉണ്ടാക്കണം. അത് അഞ്ചുമുഴം നീളവും അഞ്ചുമുഴം വീതിയും ഉള്ള സമചതുരമായിരിക്കണം; ഉയരം മൂന്നുമുഴമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","അതിന്റെ നാലു കോണുകളിലും ഓരോ കൊമ്പ് ഉണ്ടായിരിക്കണം; കൊമ്പുകൾ യാഗപീഠത്തിൽനിന്ന് ഒറ്റഖണ്ഡമായി ഉണ്ടാക്കിയതായിരിക്കണം, അതു വെങ്കലംകൊണ്ടു പൊതിയണം. ");
INSERT INTO malc_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","അതിന്റെ ഉപകരണങ്ങളൊക്കെയും—വെണ്ണീർ എടുക്കേണ്ട കലങ്ങൾ, ചട്ടുകങ്ങൾ, തളികകൾ, മുൾക്കരണ്ടികൾ, വറചട്ടികൾ എന്നിവ—വെങ്കലംകൊണ്ടുണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","യാഗപീഠത്തിനു വെങ്കലംകൊണ്ടു വലപ്പണിയായി ഒരു അരിപ്പയും അരിപ്പയ്ക്കുന്മേൽ നാലു കോണുകളിലുമായി നാലു വെങ്കലവളയവും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","യാഗപീഠത്തിന്റെ പകുതിവരെ എത്തുന്നവിധത്തിൽ യാഗപീഠത്തിന്റെ ചുറ്റുപടിക്കുകീഴേ അരിപ്പ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","യാഗപീഠത്തിനു ഖദിരമരംകൊണ്ടു തണ്ടുകൾ ഉണ്ടാക്കണം. അവ വെങ്കലംകൊണ്ടു പൊതിയണം. ");
INSERT INTO malc_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","വളയങ്ങളിൽ തണ്ടുകൾ ഉറപ്പിക്കണം. യാഗപീഠം വഹിച്ചുകൊണ്ടുപോകുന്നതിന് രണ്ടു ഭാഗത്തും തണ്ടുകൾ ഉണ്ടായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","യാഗപീഠം പലകകൾകൊണ്ട് അകം പൊള്ളയായി ഉണ്ടാക്കണം; പർവതത്തിൽ കാണിച്ചുതന്ന മാതൃകയനുസരിച്ചുതന്നെ അത് ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“സമാഗമകൂടാരത്തിന് ഒരു അങ്കണം ഉണ്ടാക്കണം. തെക്കുവശത്തു നൂറുമുഴം നീളത്തിൽ പിരിച്ച മൃദുലചണവസ്ത്രംകൊണ്ടുണ്ടാക്കിയ മറശ്ശീല ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","അതിന്, ഇരുപതു തൂണും അവയ്ക്ക് ഇരുപതു വെങ്കലച്ചുവടും, തൂണുകളിന്മേൽ വെള്ളിക്കൊളുത്തുകളും മേൽച്ചുറ്റുപടികളും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","വടക്കേവശത്തിനും നൂറുമുഴം നീളത്തിൽ മറശ്ശീലയും ഇരുപതു തൂണും ഇരുപതു വെങ്കലച്ചുവടും തൂണുകളിന്മേൽ വെള്ളിക്കൊളുത്തുകളും മേൽച്ചുറ്റുപടികളും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“സമാഗമകൂടാരാങ്കണത്തിന്റെ പടിഞ്ഞാറുവശത്തിന് അൻപതുമുഴം വീതിയിൽ മറശ്ശീലയും പത്തു ചുവടുകളിൽ പത്തു തൂണുകളും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","കിഴക്കു സൂര്യോദയഭാഗത്തുള്ള അങ്കണത്തിനും അൻപതുമുഴം വീതി ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","പ്രവേശനത്തിന്റെ ഒരുവശത്തു പതിനഞ്ചുമുഴം നീളമുള്ള മറശ്ശീലയും അവയ്ക്കു മൂന്നു ചുവടുകളോടുകൂടിയ മൂന്നു തൂണുകളും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","പ്രവേശനത്തിന്റെ മറ്റേഭാഗത്തു പതിനഞ്ചുമുഴം നീളമുള്ള മറശ്ശീലയും അതിനു മൂന്നു ചുവടുകളോടുകൂടിയ മൂന്നു തൂണുകളും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“സമാഗമകൂടാരാങ്കണത്തിന്റെ കവാടത്തിന്, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽപ്പണിയായി ഇരുപതുമുഴം നീളമുള്ള ഒരു മറശ്ശീലയും അതിനു നാലു തൂണുകളും നാലു ചുവടുകളും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","അങ്കണത്തിനു ചുറ്റുമുള്ള എല്ലാ തൂണുകൾക്കും വെള്ളികൊണ്ടുള്ള കൊളുത്തുകളും മേൽചുറ്റുപടികളും വെങ്കലച്ചുവടുകളും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","അങ്കണത്തിനു നൂറുമുഴം നീളവും അൻപതുമുഴം വീതിയും അഞ്ചുമുഴം ഉയരവും ഉണ്ടായിരിക്കണം. അതിനു വെങ്കലച്ചുവടുകൾവേണം. പിരിച്ച മൃദുലചണവസ്ത്രംകൊണ്ടുള്ള മറശ്ശീലയും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","സമാഗമകൂടാരത്തിൽ, അതിന്റെ കുറ്റികളും അങ്കണത്തിന്റെ കുറ്റികളും ഉൾപ്പെടെ ഏതുപയോഗത്തിനുമുള്ള എല്ലാ ഉപകരണങ്ങളും വെങ്കലംകൊണ്ടുള്ളവ ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“വിളക്കുകൾ കത്തിക്കൊണ്ടിരിക്കേണ്ടതിന് ഇടിച്ചുപിഴിഞ്ഞെടുത്ത തെളിഞ്ഞ ഒലിവെണ്ണ വിളക്കിനുവേണ്ടി നിന്റെയടുക്കൽ കൊണ്ടുവരാൻ ഇസ്രായേൽമക്കളോടു കൽപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","സമാഗമകൂടാരത്തിൽ, ഉടമ്പടിയുടെ പേടകത്തിന്റെ തിരശ്ശീലയ്ക്കു പുറത്തു സന്ധ്യമുതൽ പ്രഭാതംവരെ യഹോവയുടെ സന്നിധിയിൽ വിളക്കുകൾ കത്തിക്കൊണ്ടിരിക്കണമെന്നത്, അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാരും ശ്രദ്ധിക്കേണ്ടതാണ്. ഇത് ഇസ്രായേൽജനതയ്ക്ക് എന്നേക്കുമുള്ള അനുഷ്ഠാനമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“ഇസ്രായേൽജനത്തിന്റെ മധ്യേനിന്നു നിന്റെ സഹോദരനായ അഹരോനെയും അവന്റെ പുത്രന്മാരായ നാദാബ്, അബീഹൂ, എലെയാസാർ, ഈഥാമാർ എന്നിവരെയും എനിക്കു പൗരോഹിത്യശുശ്രൂഷ ചെയ്യേണ്ടതിനു നിന്റെ അടുക്കൽ വരുത്തുക. ");
INSERT INTO malc_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","നിന്റെ സഹോദരനായ അഹരോന്റെ മഹത്ത്വത്തിനും അലങ്കാരത്തിനുംവേണ്ടി അവനു വിശുദ്ധവസ്ത്രം നിർമിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","എനിക്കു പൗരോഹിത്യശുശ്രൂഷചെയ്യാൻ അഹരോനെ ശുദ്ധീകരിക്കേണ്ടതിന് അവനു വസ്ത്രങ്ങൾ നിർമിക്കണമെന്ന്, ഞാൻ ജ്ഞാനാത്മാവുകൊണ്ടു നിറച്ചിരിക്കുന്ന എല്ലാ വിദഗ്ദ്ധന്മാരോടും പറയുക. ");
INSERT INTO malc_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","അവർ നിർമിക്കേണ്ട വസ്ത്രങ്ങൾ ഇവയാണ്: ഒരു നിർണയപ്പതക്കം, ഏഫോദ്, നീളക്കുപ്പായം, ചിത്രത്തയ്യലുള്ള നിലയങ്കി, തലപ്പാവ്, നടുക്കെട്ട് എന്നിവതന്നെ. എനിക്കു പൗരോഹിത്യശുശ്രൂഷ ചെയ്യേണ്ടതിനു നിന്റെ സഹോദരനായ അഹരോനും അവന്റെ പുത്രന്മാർക്കുംവേണ്ടി വിശുദ്ധവസ്ത്രങ്ങൾ അവർ നിർമിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","തങ്കം, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, മൃദുലചണനൂൽ എന്നിവ അവർ ഉപയോഗിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“നെയ്ത്തുകാരന്റെ ചിത്രപ്പണിയായി തങ്കം, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ടുള്ള ഏഫോദ് നിർമിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","അതിന്റെ രണ്ടറ്റത്തോടുംചേർന്ന് അവയെത്തമ്മിൽ പിണച്ചുചേർക്കേണ്ടതിന് രണ്ടു ചുമൽക്കണ്ടം അതിന് ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","അതിന്മേലുള്ള ചിത്രപ്പണിയായ നടുക്കെട്ട്, ഏഫോദിൽനിന്നുതന്നെ ഉള്ളതായി, തങ്കം, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ട് അതേരീതിയിൽ നിർമിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“രണ്ടു ഗോമേദകക്കല്ല് എടുത്ത്, അതിൽ ഇസ്രായേൽ പുത്രന്മാരുടെ പേരുകൾ അവരുടെ ജനനക്രമത്തിൽ കൊത്തണം. ");
INSERT INTO malc_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ആറു പേരുകൾ ഒരു കല്ലിലും ശേഷിച്ച ആറു പേരുകൾ മറ്റേ കല്ലിലും കൊത്തണം. ");
INSERT INTO malc_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ഇസ്രായേൽ പുത്രന്മാരുടെ പേരുകൾ, രത്നശില്പി മുദ്ര നിർമിക്കുന്നതുപോലെ രണ്ടു കല്ലിലും കൊത്തണം. അവ തങ്കക്കസവുതടങ്ങളിൽ പതിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ഇസ്രായേൽ പുത്രന്മാരുടെ ഓർമക്കല്ലുകളായി രണ്ടു കല്ലും ഏഫോദിന്റെ ചുമൽക്കഷണങ്ങളിൽ പതിപ്പിക്കണം. യഹോവയുടെമുമ്പിൽ അവരുടെ പേരുകൾ ഒരു സ്മാരകമായി രണ്ടു ചുമലുകളിലും അഹരോൻ വഹിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","തങ്കക്കസവുതടങ്ങളും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","തങ്കംകൊണ്ടു മെടഞ്ഞ ചരടുപോലെ രണ്ടു മാല ഉണ്ടാക്കണം; മാല തടങ്ങളിൽ ബന്ധിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“തീരുമാനങ്ങൾ എടുക്കുന്നതിനായി വൈദഗ്ദ്ധ്യത്തോടെ ഒരു നിർണയപ്പതക്കം നിർമിക്കണം. ഏഫോദിന്റെ പണിപോലെ തങ്കം, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ട് അതു നിർമിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","അത് ഒരുചാൺ നീളവും ഒരുചാൺ വീതിയും ഉള്ള സമചതുരവും രണ്ടായി മടക്കാവുന്നതും ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","അതിൽ നാലുനിര രത്നങ്ങൾ പതിക്കണം. ആദ്യനിരയിൽ ചെമന്നരത്നം, പീതരത്നം, മരതകം എന്നിവയും ");
INSERT INTO malc_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","രണ്ടാമത്തെ നിരയിൽ മാണിക്യം, ഇന്ദ്രനീലക്കല്ല്, വജ്രം എന്നിവയും ");
INSERT INTO malc_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","മൂന്നാമത്തെ നിരയിൽ പത്മരാഗം, വൈഡൂര്യം, സുഗന്ധിക്കല്ല് എന്നിവയും ");
INSERT INTO malc_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","നാലാമത്തെ നിരയിൽ പുഷ്യരാഗം, ഗോമേദകം, സൂര്യകാന്തം എന്നിവയും പതിക്കണം. അവ അതതു തങ്കക്കസവുതടങ്ങളിൽ പതിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ഇസ്രായേൽ പുത്രന്മാരിൽ ഓരോരുത്തർക്കും ഓരോ കല്ലുവീതം പന്ത്രണ്ടു കല്ലുകൾ ഉണ്ടായിരിക്കണം. പന്ത്രണ്ടു ഗോത്രങ്ങളിൽ ഓരോന്നിന്റെയും പേര് ഓരോ കല്ലിലും മുദ്രക്കൊത്തായി കൊത്തിയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“നിർണയപ്പതക്കത്തിനു തങ്കംകൊണ്ടു മെടഞ്ഞ ചരടുപോലുള്ള മാലയുണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","തങ്കംകൊണ്ടു രണ്ടു വളയം ഉണ്ടാക്കി, അവ നിർണയപ്പതക്കത്തിന്റെ രണ്ടറ്റത്തും പിടിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","തങ്കംകൊണ്ടുള്ള രണ്ടു മാല നിർണയപ്പതക്കത്തിന്റെ അറ്റങ്ങളിലുള്ള രണ്ടു വളയത്തിലും കൊളുത്തണം. ");
INSERT INTO malc_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","മാലയുടെ മറ്റേ രണ്ടറ്റവും രണ്ടു തടത്തിൽ കൊളുത്തി ഏഫോദിന്റെ ചുമൽക്കഷണങ്ങളിൽ അതിന്റെ മുൻഭാഗവുമായി യോജിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","തങ്കംകൊണ്ട് വേറെ രണ്ടു വളയങ്ങൾ ഉണ്ടാക്കണം. നിർണയപ്പതക്കത്തിന്റെ മറ്റേ രണ്ടറ്റത്തും ഏഫോദിന്റെ കീഴറ്റത്തിനുനേരേ അതിന്റെ വിളുമ്പിൽ അകത്തും പിടിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","തങ്കംകൊണ്ടു വേറെ രണ്ടു വളയങ്ങളും ഉണ്ടാക്കി, ഏഫോദിന്റെ മുൻഭാഗത്ത് ചുമൽക്കണ്ടത്തിന്റെ താഴേ, അതിന്റെ ചേർപ്പിന്നരികെ ഏഫോദിന്റെ നടുക്കെട്ടിനു മുകളിലായി വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","നിർണയപ്പതക്കം ഏഫോദിന്റെ മുകൾഭാഗത്തു വരുന്നതിനും ഏഫോദിൽനിന്ന് ഇളകിപ്പോകാതെ ഉറച്ചിരിക്കേണ്ടതിനും നിർണയപ്പതക്കത്തിന്റെ വളയങ്ങളും ഏഫോദിന്റെ വളയങ്ങളും നീലച്ചരടുകൊണ്ടു ചേർത്തുകെട്ടണം. ");
INSERT INTO malc_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“അഹരോൻ വിശുദ്ധമന്ദിരത്തിൽ പ്രവേശിക്കുമ്പോൾ നിർണയപ്പതക്കത്തിൽ ഇസ്രായേൽമക്കളുടെ പേരുകൾ എപ്പോഴും യഹോവയുടെമുമ്പിൽ ഓർമയ്ക്കായി തന്റെ ഹൃദയത്തിന്മേൽ വഹിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","കൂടാതെ, നിർണയപ്പതക്കത്തിനകത്ത് ഊറീമും തുമ്മീമും വെക്കണം; അഹരോൻ യഹോവയുടെ സന്നിധിയിൽ പ്രവേശിക്കുമ്പോഴെല്ലാം അവ അവന്റെ ഹൃദയത്തിന്മേൽ ഇരിക്കും. അങ്ങനെ, ഇസ്രായേൽമക്കൾക്കുവേണ്ടി തീരുമാനങ്ങളെടുക്കാൻ സഹായകമായ മാധ്യമങ്ങൾ യഹോവയുടെമുമ്പാകെ അഹരോൻ തന്റെ ഹൃദയത്തിന്മേൽ വഹിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ഏഫോദിന്റെ അങ്കിമുഴുവനും നീലത്തുണികൊണ്ടുണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","അങ്കിയുടെ നടുവിൽ തല കടക്കുന്നതിന് ഒരു ദ്വാരം വേണം. അതു കീറിപ്പോകാതിരിക്കേണ്ടതിനു കവചത്തിനുള്ളതുപോലെ നെയ്ത്തുപണിയായ ഒരു നാട ദ്വാരത്തിന്റെ ചുറ്റിലും ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","അങ്കിയുടെ വിളുമ്പിൽ, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ എന്നിവകൊണ്ടു ചുറ്റും മാതളപ്പഴങ്ങളും അവയുടെ ഇടയിൽ ചുറ്റും തങ്കംകൊണ്ടു മണികളും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","അങ്കിയുടെ വിളുമ്പിൽ ചുറ്റും ഒരു തങ്കംകൊണ്ടുള്ള മണി, ഒരു മാതളപ്പഴം, ഒരു തങ്കംകൊണ്ടുള്ള മണി, ഒരു മാതളപ്പഴം ഈ ക്രമത്തിൽ ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","അഹരോൻ ശുശ്രൂഷചെയ്യുമ്പോൾ അതു ധരിക്കണം. യഹോവയുടെ സന്നിധിയിൽ വിശുദ്ധമന്ദിരത്തിൽ പ്രവേശിക്കുമ്പോഴും പുറത്തു വരുമ്പോഴും അതിന്റെ നാദം കേൾക്കട്ടെ; അല്ലെങ്കിൽ അവൻ മരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“തങ്കംകൊണ്ട് ഒരു നെറ്റിപ്പട്ടം ഉണ്ടാക്കി അതിൽ മുദ്ര കൊത്തണം: യഹോവയ്ക്കു വിശുദ്ധം. ");
INSERT INTO malc_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ആ നെറ്റിപ്പട്ടം തലപ്പാവിന്റെ മുൻഭാഗത്തു നീലച്ചരടു കോർത്തു കെട്ടണം. ");
INSERT INTO malc_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ഇസ്രായേൽമക്കൾ വിശുദ്ധവഴിപാടുകളിലൂടെ വിശുദ്ധീകരിക്കുന്ന എല്ലാ വിശുദ്ധവസ്തുക്കളിലും സംഭവിക്കാവുന്ന കുറ്റം അഹരോൻ വഹിക്കേണ്ടതിന് അത് അഹരോന്റെ നെറ്റിയിൽ ഇരിക്കേണം. യഹോവയുടെ പ്രസാദം അവർക്കു ലഭിക്കേണ്ടതിന് ആ പട്ടം എപ്പോഴും അഹരോന്റെ നെറ്റിയിൽ ഇരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“മൃദുലചണവസ്ത്രംകൊണ്ടുള്ള അങ്കി ചിത്രപ്പണിയായി നെയ്തുണ്ടാക്കണം. മൃദുലചണനൂൽകൊണ്ടു തലപ്പാവും ഉണ്ടാക്കണം. അരക്കെട്ടും ചിത്രത്തയ്യൽപ്പണിയായി ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","അഹരോന്റെ പുത്രന്മാർക്കു മഹത്ത്വത്തിനും അലങ്കാരത്തിനുമായി അങ്കിയും അരക്കെട്ടും ശിരോവസ്ത്രവും നിർമിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","നിന്റെ സഹോദരനായ അഹരോനെയും അവന്റെ പുത്രന്മാരെയും ഇവ ധരിപ്പിച്ചതിനുശേഷം അവർ എനിക്കു പൗരോഹിത്യശുശ്രൂഷ ചെയ്യേണ്ടതിന് അവരെ അഭിഷേകംചെയ്തു പ്രതിഷ്ഠിച്ച് ശുദ്ധീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“അവരുടെ നഗ്നത മറയ്ക്കേണ്ടതിന് അവർക്കു ചണനൂൽകൊണ്ട് അരമുതൽ തുടവരെ എത്തുന്ന അടിവസ്ത്രം ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","അഹരോനും അവന്റെ പുത്രന്മാരും വിശുദ്ധമന്ദിരത്തിൽ ശുശ്രൂഷചെയ്യാൻ സമാഗമകൂടാരത്തിൽ പ്രവേശിക്കുമ്പോഴും യാഗപീഠത്തിന്റെ അടുക്കൽ ചെല്ലുമ്പോഴും അവർ അകൃത്യം വഹിച്ചു മരിക്കാതിരിക്കേണ്ടതിന്, അവർ അതു ധരിച്ചിരിക്കണം. “ഇത് അവനും അവന്റെ പിൻഗാമികൾക്കും എന്നേക്കുമുള്ള അനുഷ്ഠാനമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“അവർ എനിക്ക് പൗരോഹിത്യശുശ്രൂഷചെയ്യാൻ അവരെ ശുദ്ധീകരിക്കേണ്ടതിന് നീ അവർക്കുവേണ്ടി ഈ കാര്യങ്ങൾ ചെയ്യണം: ഊനമില്ലാത്ത ഒരു കാളക്കിടാവിനെയും രണ്ട് ആട്ടുകൊറ്റന്മാരെയും കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","നേർത്ത ഗോതമ്പുമാവുകൊണ്ടു പുളിപ്പില്ലാത്ത അപ്പവും എണ്ണചേർത്ത പുളിപ്പില്ലാത്ത ദോശകളും എണ്ണ പുരട്ടിയ പുളിപ്പില്ലാത്ത വടകളും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","അവയെല്ലാം ഒരു കുട്ടയിലാക്കി, കാളക്കിടാവിനോടും രണ്ട് ആട്ടുകൊറ്റനോടുമൊപ്പം കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","പിന്നീട്, അഹരോനെയും പുത്രന്മാരെയും സമാഗമകൂടാരവാതിൽക്കൽ വരുത്തി, അവരെ വെള്ളത്തിൽ കഴുകണം. ");
INSERT INTO malc_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","വസ്ത്രങ്ങൾ എടുത്ത്, അഹരോനെ അടിവസ്ത്രം, ഏഫോദിന്റെ അങ്കി, ഏഫോദ്, നിർണയപ്പതക്കം ഇവ ധരിപ്പിച്ച് അവന്റെ അരയിൽ ഏഫോദിന്റെ ചിത്രത്തയ്യലുള്ള നടുക്കെട്ടു കെട്ടണം. ");
INSERT INTO malc_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","അഹരോന്റെ തലയിൽ തലപ്പാവും, തലപ്പാവിൽ വിശുദ്ധകിരീടവും ധരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","പിന്നീട്, അഭിഷേകതൈലം കൊണ്ടുവന്നു തലയിൽ ഒഴിച്ച് അവനെ അഭിഷേകംചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","അവന്റെ പുത്രന്മാരെയും കൊണ്ടുവന്ന് അവരെയും അങ്കി ധരിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","അവർക്കു ശിരോവസ്ത്രം വെക്കണം. അഹരോന്റെയും അവന്റെ പുത്രന്മാരുടെയും അരയ്ക്കു നടുക്കെട്ടു കെട്ടണം. ഒരു നിത്യ നിയമത്താൽ പൗരോഹിത്യം എന്നേക്കും അവർക്കായിരിക്കും. “ഇപ്രകാരം നീ അഹരോനെയും അവന്റെ പുത്രന്മാരെയും പ്രതിഷ്ഠിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“സമാഗമകൂടാരത്തിന്റെ മുൻവശത്തു കാളയെ കൊണ്ടുവരണം; അഹരോനും പുത്രന്മാരും അവരുടെ കൈകൾ അതിന്റെ തലയിൽ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","അതിനുശേഷം, സമാഗമകൂടാരവാതിൽക്കൽ യഹോവയുടെ സന്നിധിയിൽ കാളയെ അറക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","കാളക്കിടാവിന്റെ രക്തം കുറെ എടുത്ത് നിന്റെ വിരൽകൊണ്ടു യാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടണം. ശേഷിച്ചരക്തം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ആന്തരികാവയവങ്ങളിൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും കരളിന്മേലുള്ള കൊഴുപ്പും രണ്ടുവൃക്കയും അവയുടെ മേദസ്സും എടുത്ത് അവ മുഴുവനും യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","എന്നാൽ, കാളയുടെ മാംസവും തുകലും ചാണകവും പാളയത്തിനുപുറത്തു ദഹിപ്പിച്ചുകളയണം. ഇതു പാപശുദ്ധീകരണയാഗം. ");
INSERT INTO malc_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ഇതിനുശേഷം ഒരു ആട്ടുകൊറ്റനെ എടുക്കണം. അഹരോനും പുത്രന്മാരും ആട്ടുകൊറ്റന്റെ തലയിൽ അവരുടെ കൈകൾ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ആട്ടുകൊറ്റനെ അറത്തശേഷം, അതിന്റെ രക്തം എടുത്ത് യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ആട്ടുകൊറ്റനെ കഷണങ്ങളായി മുറിച്ച് അതിന്റെ ആന്തരികാവയവങ്ങളും കാലും കഴുകി, തല, കഷണങ്ങൾ എന്നിവയോടു ചേർത്തുവെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","അതിനുശേഷം, ആട്ടുകൊറ്റനെ മുഴുവനുമായി യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കണം. ഇതു യഹോവയ്ക്ക് അർപ്പിക്കുന്ന ഹോമയാഗം; യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“രണ്ടാമത്തെ ആട്ടുകൊറ്റനെ എടുക്കണം. അഹരോനും പുത്രന്മാരും ആട്ടുകൊറ്റന്റെ തലയിൽ കൈകൾ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","അതിനെ അറത്ത് അതിന്റെ കുറെ രക്തമെടുത്ത് അഹരോന്റെ വലതുചെവിയുടെ അറ്റത്തും അവന്റെ പുത്രന്മാരുടെ വലതുചെവിയുടെ അറ്റത്തും അവരുടെ വലതുകൈയുടെ പെരുവിരലിലും വലതുകാലിന്റെ പെരുവിരലിലും പുരട്ടണം. അതിനുശേഷം യാഗപീഠത്തിന്മേൽ ചുറ്റും രക്തം തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","പിന്നീട് യാഗപീഠത്തിന്മേലുള്ള രക്തവും അഭിഷേകതൈലവും കുറെ എടുത്ത്, അഹരോന്റെമേലും അവന്റെ വസ്ത്രങ്ങളിന്മേലും പുത്രന്മാരുടെമേലും അവരുടെ വസ്ത്രങ്ങളിന്മേലും തളിക്കണം. അങ്ങനെ, അവനും അവന്റെ വസ്ത്രങ്ങളും പുത്രന്മാരും അവരുടെ വസ്ത്രങ്ങളും ശുദ്ധീകരിക്കപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“നീ ആട്ടുകൊറ്റന്റെ മേദസ്സും തടിച്ച വാലും ആന്തരികാവയവങ്ങളിൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും കരളിന്മേലുള്ള കൊഴുപ്പും വൃക്ക രണ്ടും അവയുടെ മേദസ്സും വലതുതുടയും എടുക്കണം. ഇതു പ്രതിഷ്ഠയ്ക്കുള്ള ആട്ടുകൊറ്റൻ. ");
INSERT INTO malc_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","യഹോവയുടെ സന്നിധിയിൽ പുളിപ്പില്ലാത്ത അപ്പം വെച്ചിരിക്കുന്ന കുട്ടയിൽനിന്ന് ഒരു അടയും ഒലിവെണ്ണ പകർന്ന ഒരു വടയും ഒരു അപ്പവും എടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ഇവയെല്ലാം എടുത്ത് അഹരോന്റെയും അവന്റെ പുത്രന്മാരുടെയും കൈയിലും വെച്ചിട്ട്, യഹോവയുടെ സന്നിധിയിൽ ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","അതിനുശേഷം അവരുടെ കൈയിൽനിന്ന് അവ എടുത്ത് യാഗപീഠത്തിലുള്ള ഹോമയാഗത്തോടൊപ്പം ഹൃദ്യസുഗന്ധമായി യഹോവയ്ക്ക് അർപ്പിക്കണം. ഇതു യഹോവയുടെ സന്നിധിയിൽ അർപ്പിക്കുന്ന ദഹനയാഗംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","പിന്നീട് അഹരോന്റെ പ്രതിഷ്ഠയ്ക്കുള്ള ആട്ടുകൊറ്റന്റെ നെഞ്ചു നീ എടുത്ത് യഹോവയുടെ സന്നിധിയിൽ ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി അർപ്പിക്കണം; അതു നിന്റെ ഓഹരിയായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“അഹരോന്റെയും അവന്റെ പുത്രന്മാരുടെയും പ്രതിഷ്ഠയ്ക്കുള്ള ആട്ടുകൊറ്റനിൽ യഹോവയുടെ സന്നിധിയിൽ ഉയർത്തി അർപ്പിച്ചതും അവർക്ക് അവകാശപ്പെട്ടതുമായ നെഞ്ചും വിശിഷ്ടയാഗാർപ്പണമായ തുടയും നീ ശുദ്ധീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ഇത് ഇസ്രായേൽമക്കളുടെ പക്കൽനിന്നും അഹരോനും അവന്റെ പുത്രന്മാർക്കും നിത്യാവകാശമായിരിക്കണം. ഇത് ഇസ്രായേൽജനം നിങ്ങളുടെ സമാധാനയാഗങ്ങളിൽനിന്ന് യഹോവയ്ക്ക് അർപ്പിക്കുന്ന വിശിഷ്ടയാഗമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“അഹരോന്റെ വിശുദ്ധവസ്ത്രങ്ങൾ അവന്റെ പുത്രന്മാരുടെ അവകാശമായിരിക്കും. അവർ അതു ധരിച്ചുകൊണ്ട് അഭിഷേകവും പ്രതിഷ്ഠയും പ്രാപിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","അവന്റെ പുത്രന്മാരിൽ അവനു പകരം വിശുദ്ധമന്ദിരത്തിൽ പൗരോഹിത്യശുശ്രൂഷചെയ്യാൻ സമാഗമകൂടാരത്തിൽ പ്രവേശിക്കുന്നവൻ ഏഴുദിവസം അതു ധരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“പ്രതിഷ്ഠയ്ക്കുള്ള ആട്ടുകൊറ്റനെ എടുത്ത് അതിന്റെ മാംസം ഒരു വിശുദ്ധസ്ഥലത്തുവെച്ച് പാകംചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","അഹരോനും പുത്രന്മാരും സമാഗമകൂടാരവാതിലിൽവെച്ച് ആട്ടുകൊറ്റന്റെ മാംസവും കുട്ടയിലുള്ള അപ്പവും ഭക്ഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","അവരുടെ പ്രതിഷ്ഠയ്ക്കും വിശുദ്ധീകരണത്തിനും പ്രായശ്ചിത്തം കഴിക്കുന്ന മാംസവും അപ്പവും അവർതന്നെ ഭക്ഷിക്കണം. അവ വിശുദ്ധമാകുകയാൽ അന്യർ ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","പ്രതിഷ്ഠായാഗത്തിന്റെ മാംസത്തിലോ അപ്പത്തിലോ എന്തെങ്കിലും പ്രഭാതംവരെ ശേഷിച്ചിരുന്നാൽ അതു തീയിൽ ദഹിപ്പിച്ചുകളയണം. അതു വിശുദ്ധമാകുകയാൽ ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“അങ്ങനെ ഞാൻ നിന്നോടു കൽപ്പിച്ചതുപോലെ എല്ലാം നീ അഹരോനും അവന്റെ പുത്രന്മാർക്കുംവേണ്ടി ചെയ്യണം; അവരുടെ പ്രതിഷ്ഠാകർമം ഏഴുദിവസം നീണ്ടുനിൽക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","പ്രായശ്ചിത്തമായി, ദിനംപ്രതി ഓരോ കാളയെ പാപശുദ്ധീകരണയാഗമായിട്ട് അർപ്പിക്കണം. പ്രായശ്ചിത്തം കഴിച്ചു യാഗപീഠത്തിനും ശുദ്ധിവരുത്തുക; അതിന്റെ വിശുദ്ധീകരണത്തിനായി അഭിഷേകം ചെയ്യുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ഏഴുദിവസം യാഗപീഠത്തിനായി പ്രായശ്ചിത്തം കഴിച്ച് അതിനെ ശുദ്ധീകരിക്കണം. യാഗപീഠം അതിവിശുദ്ധമാകുകയും, അതിനെ തൊടുന്നതൊക്കെയും വിശുദ്ധമാകുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“യാഗപീഠത്തിൽ നീ ക്രമമായി അർപ്പിക്കേണ്ടത് ഇതാണ്: ദിവസംതോറും ഒരുവയസ്സു പ്രായമുള്ള രണ്ട് കുഞ്ഞാട്. ");
INSERT INTO malc_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ഒരു കുഞ്ഞാടിനെ രാവിലെയും മറ്റേ കുഞ്ഞാടിനെ വൈകുന്നേരത്തും യാഗമർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ഇടിച്ചുപിഴിഞ്ഞെടുത്ത കാൽ ഹീൻ എണ്ണ പകർന്നിട്ടുള്ള ഒരു ഓമെർ നേരിയമാവും, പാനീയയാഗമായി കാൽ ഹീൻ വീഞ്ഞും ആദ്യത്തെ കുഞ്ഞാടിനോടൊപ്പം അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","രണ്ടാമത്തെ കുഞ്ഞാടിനെ, രാവിലത്തെ ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനും ഒത്തവണ്ണം ഒരുക്കി, ഹൃദ്യസുഗന്ധമായി യഹോവയ്ക്കു ദഹനയാഗം വൈകുന്നേരത്ത് അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“സമാഗമകൂടാരവാതിൽക്കൽ യഹോവയുടെമുമ്പാകെ ഇതു നിങ്ങൾക്കു തലമുറതലമുറയായി നിരന്തരം അർപ്പിക്കേണ്ട ഹോമയാഗമായിരിക്കണം. അവിടെ ഞാൻ നിങ്ങൾക്കു പ്രത്യക്ഷനായി നിങ്ങളോടു സംസാരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","അവിടെ ഞാൻ ഇസ്രായേൽമക്കൾക്കു വെളിപ്പെടും. ആ സ്ഥലം എന്റെ തേജസ്സിനാൽ ശുദ്ധീകരിക്കപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“ഞാൻ സമാഗമകൂടാരത്തെയും യാഗപീഠത്തെയും ശുദ്ധീകരിക്കും. എനിക്കു പൗരോഹിത്യശുശ്രൂഷ ചെയ്യേണ്ടതിനു ഞാൻ അഹരോനെയും അവന്റെ പുത്രന്മാരെയും ശുദ്ധീകരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ഞാൻ ഇസ്രായേൽമക്കളുടെ മധ്യേ വസിക്കും; ഞാൻ അവർക്കു ദൈവമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","അവരുടെ മധ്യേ വസിക്കാൻ അവരെ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന അവരുടെ ദൈവമായ യഹോവ ഞാൻ ആകുന്നു എന്ന് അവർ അറിയും. ഞാൻ അവരുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“സുഗന്ധധൂപം കാട്ടുന്നതിന്, ഖദിരമരംകൊണ്ട് ഒരു ധൂപപീഠം ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","അതു സമചതുരത്തിൽ, ഒരുമുഴം നീളവും ഒരുമുഴം വീതിയുമുള്ളതും, രണ്ടുമുഴം ഉയരമുള്ളതും ആയിരിക്കണം. അതിന്റെ കൊമ്പുകൾ ധൂപപീഠത്തിൽനിന്ന് ഒറ്റഖണ്ഡമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","അതിന്റെ മേൽഭാഗവും അതിന്റെ പാർശ്വങ്ങളും കൊമ്പുകളും തങ്കംകൊണ്ടു പൊതിയണം. അതിനുചുറ്റും തങ്കംകൊണ്ട് ഒരു വക്കും ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ധൂപപീഠം ചുമക്കേണ്ടതിനുള്ള തണ്ട് ഉറപ്പിക്കാൻ അതിന്റെ വക്കിനുതാഴേ രണ്ടുവശങ്ങളിലും ഈരണ്ടു തങ്കവളയങ്ങളും ഉറപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ഖദിരമരംകൊണ്ടു തണ്ടുകൾ ഉണ്ടാക്കി, അതു തങ്കംകൊണ്ടു പൊതിയണം. ");
INSERT INTO malc_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ഞാൻ നിന്നെ സന്ദർശിക്കുന്ന ഇടമായ—പേടകത്തിന്റെ പലകയുടെ മുകളിലുള്ള പാപനിവാരണസ്ഥാനത്തിന്റെ മുൻഭാഗത്ത്—ഉടമ്പടിയുടെ പേടകത്തെ മറയ്ക്കുന്ന തിരശ്ശീലയ്ക്കുമുമ്പിൽ ധൂപപീഠം വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“അഹരോൻ എല്ലാ ദിവസവും പ്രഭാതത്തിൽ വിളക്ക് ഒരുക്കുമ്പോൾ ധൂപപീഠത്തിന്മേൽ സുഗന്ധധൂപം കാട്ടണം. ");
INSERT INTO malc_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","അഹരോൻ വൈകുന്നേരം വിളക്ക് കൊളുത്തുമ്പോഴും സുഗന്ധധൂപം കാട്ടണം, ഇതു തലമുറതലമുറയായി യഹോവയുടെമുമ്പിൽ പതിവായി അർപ്പിക്കുന്ന ധൂപം ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ധൂപപീഠത്തിന്മേൽ നിങ്ങൾ അന്യധൂപമോ ഹോമയാഗമോ ഭോജനയാഗമോ അർപ്പിക്കരുത്; അതിന്മേൽ പാനീയയാഗം ഒഴിക്കുകയുമരുത്. ");
INSERT INTO malc_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","വർഷത്തിലൊരിക്കൽ അഹരോൻ അതിന്റെ കൊമ്പുകൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കണം; പ്രായശ്ചിത്തത്തിനുള്ള പാപശുദ്ധീകരണയാഗരക്തംകൊണ്ട് അവൻ വാർഷികപ്രായശ്ചിത്തം കഴിക്കണം. ഇതു തലമുറതലമുറയായി അനുഷ്ഠിക്കണം. ഇതു യഹോവയ്ക്ക് അതിവിശുദ്ധം.” ");
INSERT INTO malc_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","യഹോവ പിന്നെയും മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ഇസ്രായേൽജനത്തിന്റെ ജനസംഖ്യ എടുക്കേണ്ടതിന് അവരെ എണ്ണുമ്പോൾ അവരിൽ ഓരോരുത്തരും താന്താങ്ങളുടെ ജീവനുവേണ്ടി യഹോവയ്ക്കു വീണ്ടെടുപ്പുവില കൊടുക്കണം; എങ്കിൽ അവരെ എണ്ണുന്നതുനിമിത്തം അവരുടെമേൽ ബാധ വരികയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","എണ്ണപ്പെടുന്നവരിൽ ഉൾപ്പെടുന്ന ഓരോരുത്തരും വിശുദ്ധമന്ദിരത്തിലെ തൂക്കമനുസരിച്ച് അരശേക്കേൽ കൊടുക്കണം. ഇരുപതു ഗേരയാണ് ഒരു ശേക്കേൽ. ഈ അരശേക്കേൽ യഹോവയ്ക്കു വഴിപാടാണ്. ");
INSERT INTO malc_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","എണ്ണപ്പെടുന്നവരിൽ ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ളവരും യഹോവയ്ക്കു വഴിപാടു കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","നിങ്ങളുടെ ജീവനുവേണ്ടിയുള്ള പ്രായശ്ചിത്തമായി നിങ്ങൾ യഹോവയ്ക്കു വഴിപാടു കൊടുക്കുമ്പോൾ ധനവാൻ അരശേക്കേലിൽ കൂടുതലോ ദരിദ്രൻ അതിൽ കുറച്ചോ കൊടുക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","നീ ഇസ്രായേൽമക്കളോടു പ്രായശ്ചിത്തദ്രവ്യം വാങ്ങി സമാഗമകൂടാരത്തിന്റെ ശുശ്രൂഷയ്ക്കായി ഉപയോഗിക്കണം. നിങ്ങളുടെ ജീവനുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കുമ്പോൾ അതു യഹോവയുടെമുമ്പാകെ ഇസ്രായേൽമക്കൾക്കുവേണ്ടി ഒരു സ്മാരകമായിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","യഹോവ പിന്നെയും മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“കഴുകേണ്ടതിന് ഒരു വെങ്കലത്തൊട്ടിയും അതിന് ഒരു വെങ്കലക്കാലും നിർമിക്കണം. സമാഗമകൂടാരത്തിനും യാഗപീഠത്തിനും മധ്യേ അതു വെച്ച്, അതിൽ വെള്ളം ഒഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","അഹരോനും അവന്റെ പുത്രന്മാരും അതിൽ കൈകാലുകൾ കഴുകണം. ");
INSERT INTO malc_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","അവർ സമാഗമകൂടാരത്തിൽ പ്രവേശിക്കുമ്പോഴും യഹോവയ്ക്കു ദഹനയാഗം കഴിക്കേണ്ടതിന് അവർ യാഗപീഠത്തിൽ ശുശ്രൂഷിക്കാൻ സമീപിക്കുമ്പോഴും തങ്ങൾ മരിക്കാതിരിക്കേണ്ടതിന് അവർ വെള്ളംകൊണ്ടു കഴുകണം. ");
INSERT INTO malc_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","അവർ മരിക്കാതിരിക്കേണ്ടതിന്, തങ്ങളുടെ കൈകാലുകൾ കഴുകണം. ഇത് അഹരോനും അവന്റെ സന്തതിക്കും തലമുറതലമുറയായി എന്നേക്കുമുള്ള ഒരു അനുഷ്ഠാനമായിരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","യഹോവ മോശയോടു പിന്നെയും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“വിശുദ്ധമന്ദിരത്തിലെ തൂക്കമനുസരിച്ചു താഴെപ്പറയുന്ന ഏറ്റവും മെച്ചമായ സുഗന്ധവർഗങ്ങൾ എടുക്കണം: അഞ്ഞൂറുശേക്കേൽ അയഞ്ഞമീറ, അതിൽ പകുതി ഇരുനൂറ്റൻപതു ശേക്കേൽ സുഗന്ധലവംഗവും ഇരുനൂറ്റൻപതു ശേക്കേൽ സൗരഭ്യമുള്ള വയമ്പും ");
INSERT INTO malc_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","അഞ്ഞൂറുശേക്കേൽ വഴനപ്പട്ടയും ഒരു ഹീൻ ഒലിവെണ്ണയും എടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ഇവ, സുഗന്ധതൈലക്കാരന്റെ യോഗവിധിപ്രകാരം ചേർത്ത് വിശുദ്ധമായ അഭിഷേകതൈലം ഉണ്ടാക്കണം; അതു വിശുദ്ധമായ അഭിഷേകതൈലം ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ഈ തൈലംകൊണ്ടു നീ സമാഗമകൂടാരവും, ഉടമ്പടിയുടെ പേടകവും ");
INSERT INTO malc_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","മേശയും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും നിലവിളക്കും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും ധൂപപീഠവും ");
INSERT INTO malc_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ഹോമയാഗപീഠവും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും തൊട്ടിയും അതിന്റെ കാലും അഭിഷേകംചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","അവ അതിവിശുദ്ധമായിരിക്കേണ്ടതിനു നീ അവയെ ശുദ്ധീകരിക്കണം; അവയെ തൊടുന്നവരെല്ലാം വിശുദ്ധരായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“എനിക്കു പൗരോഹിത്യശുശ്രൂഷ ചെയ്യേണ്ടതിനു നീ അഹരോനെയും അവന്റെ പുത്രന്മാരെയും അഭിഷേകംചെയ്തു ശുദ്ധീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","‘ഇതു തലമുറതലമുറയായി എന്റെ വിശുദ്ധഅഭിഷേകതൈലം ആയിരിക്കണം’ എന്നു നീ ഇസ്രായേൽമക്കളോടു പറയണം. ");
INSERT INTO malc_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","‘മറ്റാരുടെയും ശരീരത്തിൽ അത് ഒഴിക്കരുത്; അതേ യോഗവിധിപ്രകാരം അതുപോലെയൊന്ന് നിങ്ങൾ നിർമിക്കുകയുമരുത്. അതു വിശുദ്ധമാണ്; നിങ്ങൾ അതിനെ വിശുദ്ധമായി കരുതണം. ");
INSERT INTO malc_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","അതുപോലെയൊന്നു നിർമിക്കുകയോ മറ്റാരുടെയെങ്കിലുംമേൽ ഒഴിക്കുകയോ ചെയ്യുന്നവനെ സ്വജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം.’ ” ");
INSERT INTO malc_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","യഹോവ മോശയോടു പിന്നെയും അരുളിച്ചെയ്തു: “നീ തുല്യതൂക്കം നറുമ്പശ, ഗുൽഗുലു, ഹൽബാനപ്പശ എന്നീ സുഗന്ധവർഗങ്ങളും ശുദ്ധകുന്തിരിക്കവും എടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","സുഗന്ധതൈലക്കാരന്റെ യോഗവിധിപ്രകാരം ഉപ്പും ചേർത്തു വിശുദ്ധവും നിർമലവുമായ സുഗന്ധവർഗം ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","നീ ഇതിൽ കുറെ ഇടിച്ചു പൊടിയാക്കി, ഞാൻ നിങ്ങൾക്കു വെളിപ്പെടുന്ന സമാഗമകൂടാരത്തിലെ ഉടമ്പടിയുടെ പേടകത്തിനുമുമ്പിൽ വെക്കണം. അതു നിങ്ങൾക്ക് അതിവിശുദ്ധമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ഇതേ യോഗവിധിപ്രകാരം നിങ്ങൾക്കുവേണ്ടി സുഗന്ധവർഗം ഉണ്ടാക്കരുത്; ഇതു യഹോവയ്ക്കു വിശുദ്ധമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","സൗരഭ്യം ആസ്വദിക്കേണ്ടതിന് അതുപോലെയുള്ള സുഗന്ധവർഗം ഉണ്ടാക്കുന്നവനെ സ്വജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം.” ");
INSERT INTO malc_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","യഹോവ മോശയോടു പിന്നെയും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ഇതാ, യെഹൂദാഗോത്രത്തിൽ ഹൂരിന്റെ മകനായ ഊരിയുടെ മകൻ ബെസലേലിനെ ഞാൻ പേരുചൊല്ലി വിളിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ഞാൻ അവനെ ദൈവാത്മാവിനാൽ നിറച്ച്, എല്ലാവിധ കരകൗശലപ്പണികളിലും വൈദഗ്ദ്ധ്യവും പ്രാപ്തിയും ജ്ഞാനവും നൽകിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","സ്വർണം, വെള്ളി, വെങ്കലം എന്നിവയിൽ കലാചാതുരിയോടെ പണികൾ ചെയ്യാനും ");
INSERT INTO malc_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","രത്നങ്ങൾ വെട്ടിപ്പതിക്കാനും മരത്തിൽ കൊത്തുപണികൾ ചെയ്യാനും അങ്ങനെ സകലവിധമായ കരകൗശലപ്പണികൾ ചെയ്യാനും ഞാൻ അവനെ വിളിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","മാത്രമല്ല, ദാൻഗോത്രത്തിൽ അഹീസാമാക്കിന്റെ മകനായ ഒഹൊലീയാബിനെ ഞാൻ അവനു സഹായിയായി നിയമിച്ചിരിക്കുന്നു. “ഞാൻ നിന്നോടു കൽപ്പിച്ച എല്ലാ പണികളും ചെയ്യുന്നതിന് എല്ലാ വിദഗ്ദ്ധന്മാരുടെ ഹൃദയങ്ങളിലും ഞാൻ പ്രത്യേക കഴിവ് നൽകിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“സമാഗമകൂടാരവും ഉടമ്പടിയുടെ പേടകവും അതിന്മേലുള്ള പാപനിവാരണസ്ഥാനവും കൂടാരത്തിന്റെ എല്ലാ ഉപകരണങ്ങളും ");
INSERT INTO malc_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","മേശയും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും തങ്കംകൊണ്ടുള്ള നിലവിളക്കും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും ധൂപപീഠവും ");
INSERT INTO malc_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ഹോമയാഗപീഠവും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും വെങ്കലത്തൊട്ടിയും അതിന്റെ കാലും ");
INSERT INTO malc_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","നെയ്തെടുത്ത വിശേഷവസ്ത്രങ്ങളും പുരോഹിതനായ അഹരോന്റെ വിശുദ്ധവസ്ത്രങ്ങളും പൗരോഹിത്യശുശ്രൂഷയ്ക്കു വരുന്ന അവന്റെ പുത്രന്മാരുടെ വസ്ത്രങ്ങളും ");
INSERT INTO malc_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","അഭിഷേകതൈലവും വിശുദ്ധമന്ദിരത്തിനുള്ള സുഗന്ധധൂപവർഗവും. “ഞാൻ നിന്നോടു കൽപ്പിച്ചതുപോലെ അവർ ഉണ്ടാക്കണം.” ");
INSERT INTO malc_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","യഹോവ മോശയോടു പിന്നെയും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“നീ ഇസ്രായേൽമക്കളോട് ഇപ്രകാരം പറയണം. ‘നിങ്ങൾ എന്റെ ശബ്ബത്തുകൾ ആചരിക്കണം. ഞാൻ നിങ്ങളെ ശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു എന്നു നിങ്ങൾ അറിയേണ്ടതിന്, ഇതു തലമുറതലമുറയായി എനിക്കും നിങ്ങൾക്കും മധ്യേയുള്ള ഒരു ചിഹ്നം ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘നിങ്ങൾ ശബ്ബത്ത് ആചരിക്കണം; അതു നിങ്ങൾക്കു വിശുദ്ധമാണ്. ശബ്ബത്തിനെ അശുദ്ധമാക്കുന്നവർ മരണശിക്ഷ അനുഭവിക്കണം. ആ ദിവസത്തിൽ ഏതെങ്കിലും വേലചെയ്യുന്നവരെ സ്വജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ആറുദിവസം വേലചെയ്യണം; എന്നാൽ ഏഴാംദിവസം സ്വസ്ഥതയുടെ ശബ്ബത്ത്, അതു യഹോവയ്ക്കു വിശുദ്ധം. ശബ്ബത്തുനാളിൽ വേലചെയ്യുന്നവർ മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","അതുകൊണ്ട് ഇസ്രായേൽമക്കൾ നിത്യനിയമമായി ശബ്ബത്തിനെ തലമുറതലമുറയായി ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","അത് എനിക്കും ഇസ്രായേൽമക്കൾക്കും മധ്യേ എന്നേക്കുമുള്ള ഒരു ചിഹ്നം ആകുന്നു; ആറുദിവസംകൊണ്ട് യഹോവ ആകാശത്തെയും ഭൂമിയെയും ഉണ്ടാക്കി; ഏഴാംദിവസം യഹോവ സ്വസ്ഥനായി വിശ്രമിച്ചു.’ ” ");
INSERT INTO malc_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","അവിടന്ന് സീനായിപർവതത്തിൽവെച്ചു മോശയോട് അരുളിച്ചെയ്തശേഷം, ദൈവത്തിന്റെ വിരൽകൊണ്ട് എഴുതിയ കൽപ്പലകകളായ ഉടമ്പടിയുടെ പലക രണ്ടും അദ്ദേഹത്തിനു കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","മോശ, പർവതത്തിൽനിന്നിറങ്ങിവരാൻ താമസിക്കുന്നു എന്നു ജനം കണ്ടപ്പോൾ അവർ അഹരോനു ചുറ്റും വന്നുകൂടി, “വരിക, ഞങ്ങളുടെമുമ്പിൽ നടക്കേണ്ടതിനു ഞങ്ങൾക്കു ദേവതകളെ ഉണ്ടാക്കിത്തരിക; ഞങ്ങളെ ഈജിപ്റ്റിൽനിന്നുകൊണ്ടുവന്ന മോശ എന്ന പുരുഷന് എന്തു സംഭവിച്ചു എന്നു ഞങ്ങൾ അറിയുന്നില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","അഹരോൻ അവരോട്, “നിങ്ങളുടെ ഭാര്യമാരും പുത്രന്മാരും പുത്രിമാരും ധരിച്ചിട്ടുള്ള സ്വർണക്കുണുക്കുകൾ എടുത്ത് എന്റെ അടുക്കൽ കൊണ്ടുവരിക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","അങ്ങനെ സകലജനവും തങ്ങളുടെ സ്വർണക്കുണുക്കുകൾ എടുത്ത് അവ അഹരോന്റെ അടുക്കൽ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","അവരുടെ കൈയിൽനിന്ന് അവൻ അതു വാങ്ങി കൊത്തുളികൊണ്ട് ഒരു കാളക്കിടാവിന്റെ രൂപം വാർത്തുണ്ടാക്കി. അപ്പോൾ അവർ, “ഇസ്രായേലേ, നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചുകൊണ്ടുവന്ന നിങ്ങളുടെ ദേവൻ ഇതാ!” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ഇതു കണ്ടപ്പോൾ അഹരോൻ കാളക്കിടാവിന്റെമുമ്പിൽ ഒരു യാഗപീഠം പണിതു. “നാളെ യഹോവയ്ക്ക് ഒരു ഉത്സവം ഉണ്ട്,” എന്നു വിളിച്ചുപറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","അടുത്തദിവസം ജനം രാവിലെ എഴുന്നേറ്റു ഹോമയാഗങ്ങളും സമാധാനയാഗങ്ങളും അർപ്പിച്ചു. അതിനുശേഷം ജനം ഭക്ഷിക്കാനും കുടിക്കാനും ഇരുന്നു; വിളയാടാൻ എഴുന്നേറ്റു. ");
INSERT INTO malc_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","അപ്പോൾ യഹോവ മോശയോട് ഇപ്രകാരം കൽപ്പിച്ചു: “നീ ഇറങ്ങിച്ചെല്ലുക; നീ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചുകൊണ്ടുവന്ന ജനം തങ്ങളെത്തന്നെ വഷളാക്കിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ഞാൻ അവരോടു കൽപ്പിച്ചതിൽനിന്ന് അവർ അതിവേഗം വ്യതിചലിച്ചിരിക്കുന്നു; അവർ കാളക്കിടാവിന്റെ രൂപത്തിൽ ഒരു വിഗ്രഹത്തെ വാർത്തുണ്ടാക്കിയിരിക്കുന്നു: അവർ അതിനെ വണങ്ങി, അതിനു യാഗം കഴിച്ച്, ‘ഇസ്രായേലേ, നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചുകൊണ്ടുവന്ന നിങ്ങളുടെ ദേവൻ ഇതാ,’ എന്നു പറഞ്ഞു.” ");
INSERT INTO malc_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“ഞാൻ ഈ ജനത്തെ നോക്കി, അവർ ദുശ്ശാഠ്യമുള്ള ജനം എന്നുകണ്ടു,” എന്ന് യഹോവ മോശയോട് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","“അതുകൊണ്ട്, എന്റെ കോപം അവർക്കുനേരേ ജ്വലിച്ചു; ഞാൻ അവരെ ദഹിപ്പിച്ചു കളയേണ്ടതിന് എന്നെ വിടുക; നിന്നെ ഞാൻ വലിയൊരു ജനതയാക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","എന്നാൽ മോശ തന്റെ ദൈവമായ യഹോവയോടു കരുണയ്ക്കായി യാചിച്ചുകൊണ്ടു പറഞ്ഞത്: “യഹോവേ, അങ്ങു മഹാശക്തികൊണ്ടും കരബലംകൊണ്ടും ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന അങ്ങയുടെ ജനത്തിനു വിരോധമായി അവിടത്തെ കോപം ജ്വലിക്കുന്നത് എന്ത്? ");
INSERT INTO malc_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","‘മലകളിൽവെച്ച് അവരെ കൊന്നുകളയാനും ഭൂമുഖത്തുനിന്ന് അവരെ തുടച്ചുമാറ്റാനുംവേണ്ടി ദുഷ്ടലാക്കോടെ അവിടന്ന് അവരെ കൊണ്ടുപോയി,’ എന്ന് ഈജിപ്റ്റുകാരെക്കൊണ്ടു പറയിക്കുന്നതെന്തിന്? അങ്ങയുടെ ഉഗ്രകോപത്തിൽനിന്നും പിന്തിരിഞ്ഞ് ഈ ജനത്തിനു വരാൻപോകുന്ന മഹാനാശത്തെക്കുറിച്ച് അനുതപിക്കണമേ! ");
INSERT INTO malc_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","അവിടത്തെ ദാസന്മാരായ അബ്രാഹാമിനെയും യിസ്ഹാക്കിനെയും ഇസ്രായേലിനെയും ഓർക്കണമേ. ‘ഞാൻ നിങ്ങളുടെ സന്തതിയെ ആകാശത്തിലെ നക്ഷത്രങ്ങളെപ്പോലെ വർധിപ്പിക്കുകയും ഞാൻ വാഗ്ദാനംചെയ്ത എല്ലാ ദേശവും നിങ്ങളുടെ സന്തതിക്കു കൊടുക്കുകയും അവർ അതിനെ എന്നേക്കും അവകാശമാക്കുകയും ചെയ്യുമെന്ന് അങ്ങ് അങ്ങയെക്കൊണ്ടുതന്നെ അവരോടു സത്യം ചെയ്തല്ലോ.’ ” ");
INSERT INTO malc_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","അപ്പോൾ യഹോവ അനുതപിച്ചു: താൻ ജനത്തിന്റെമേൽ വരുത്തുമെന്നു പറഞ്ഞ മഹാനാശം വരുത്തിയതുമില്ല. ");
INSERT INTO malc_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ഇതിനുശേഷം മോശ തിരിഞ്ഞു, കൈയിൽ ഉടമ്പടിയുടെ രണ്ടു പലകയുമായി പർവതത്തിൽനിന്ന് ഇറങ്ങി. പലക അപ്പുറവും ഇപ്പുറവുമായി, രണ്ടുവശത്തും എഴുത്തുള്ളതായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","പലക ദൈവത്തിന്റെ പണിയും പലകയിൽ കൊത്തിയിരുന്ന എഴുത്തു ദൈവത്തിന്റെ എഴുത്തും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ജനത്തിന്റെ ആഘോഷശബ്ദം യോശുവ കേട്ടപ്പോൾ അദ്ദേഹം മോശയോട്: “പാളയത്തിൽ യുദ്ധഘോഷം ഉണ്ട്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","“അതു ജയിച്ച് ആർക്കുന്നവരുടെ ഘോഷമല്ല, തോറ്റവരുടെ നിലവിളിയുമല്ല; പാടുന്നവരുടെ ശബ്ദമാണു ഞാൻ കേൾക്കുന്നത്,” എന്ന് മോശ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","മോശ പാളയത്തിനു സമീപമെത്തിയപ്പോൾ കാളക്കിടാവിനെയും നൃത്തക്കാരെയും കണ്ടു, അദ്ദേഹത്തിന്റെ കോപം ജ്വലിച്ചു: അദ്ദേഹം പലക രണ്ടും കൈയിൽനിന്ന് എറിഞ്ഞുകളഞ്ഞു. അദ്ദേഹം പർവതത്തിന്റെ അടിവാരത്തിൽവെച്ച് അവ പൊട്ടിച്ചുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","അവർ ഉണ്ടാക്കിയ കാളക്കിടാവിനെ അദ്ദേഹം എടുത്ത് തീയിൽ ഇട്ടു ചുട്ട് അരച്ചു പൊടിയാക്കി, വെള്ളത്തിൽ കലക്കി ഇസ്രായേൽമക്കളെ കുടിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","മോശ അഹരോനോട്, “ഇത്രവലിയ പാപത്തിലേക്ക് ഈ ജനത്തെ നയിക്കാൻ തക്കവണ്ണം അവർ നിന്നോട് എന്തു ചെയ്തു?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","“യജമാനൻ കോപിക്കരുതേ, ഈ ജനം എത്രവരെ ദോഷത്തിലേക്കു ചായുമെന്ന് അങ്ങ് അറിയുന്നല്ലോ. ");
INSERT INTO malc_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","‘ഞങ്ങളുടെമുമ്പിൽ നടക്കേണ്ടതിനു ഞങ്ങൾക്കു ദേവതകളെ ഉണ്ടാക്കിത്തരിക. ഞങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന മോശ എന്ന പുരുഷന് എന്തു സംഭവിച്ചു എന്നു ഞങ്ങൾ അറിയുന്നില്ല,’ എന്നു ജനം എന്നോടു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","അപ്പോൾ ഞാൻ അവരോട്, ‘പൊന്നുള്ളവർ അതു പറിച്ചെടുക്കട്ടെ’ എന്നു പറഞ്ഞു. അവർ സ്വർണം എന്റെ കൈയിൽ തന്നു; ഞാൻ അതു തീയിൽ ഇട്ടു, ഈ കാളക്കിടാവ് പുറത്തുവന്നു” എന്ന് അഹരോൻ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ജനം നിയന്ത്രണംവിട്ടവരായി എന്നും അഹരോൻ അവരെ കെട്ടഴിച്ചുവിട്ടു എന്നും തന്നിമിത്തം ശത്രുക്കളുടെമുമ്പിൽ അവർ പരിഹാസ്യരായി എന്നും മോശ കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","മോശ പാളയത്തിന്റെ കവാടത്തിൽനിന്നുകൊണ്ടു “യഹോവയുടെ പക്ഷത്തുള്ളവർ എന്റെ അടുക്കൽ വരട്ടെ,” എന്നു പറഞ്ഞു. ലേവ്യർ എല്ലാവരും അദ്ദേഹത്തിന്റെ അടുക്കൽ വന്നുകൂടി. ");
INSERT INTO malc_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","അപ്പോൾ മോശ അവരോട്, “ഇസ്രായേലിന്റെ ദൈവമായ യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: ‘ഓരോരുത്തനും വാൾ അരയ്ക്കു കെട്ടട്ടെ. പാളയത്തിന്റെ കവാടംതോറും ചെന്ന് ഓരോരുത്തനും സ്വന്തം സഹോദരനെയും സ്നേഹിതനെയും അയൽവാസിയെയും കൊന്നുകളയട്ടെ.’ ” ");
INSERT INTO malc_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","മോശ കൽപ്പിച്ചതുപോലെ ലേവ്യർ ചെയ്തു; അന്നു മൂവായിരത്തോളംപേർ മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","അപ്പോൾ മോശ, “നിങ്ങൾ സ്വന്തം പുത്രന്മാർക്കും സഹോദരന്മാർക്കും എതിരേ എഴുന്നേറ്റതുകൊണ്ട് ഇന്നു നിങ്ങൾ യഹോവയ്ക്കായി വേർതിരിക്കപ്പെട്ടിരിക്കുന്നു; ഇന്നു നിങ്ങളെ അവിടന്ന് അനുഗ്രഹിച്ചിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","അടുത്തദിവസം മോശ ജനത്തോടു പറഞ്ഞത്, “നിങ്ങൾ മഹാപാപം ചെയ്തിരിക്കുന്നു. ഇപ്പോൾ ഞാൻ യഹോവയുടെ അടുക്കൽ കയറിച്ചെല്ലും. ഒരുപക്ഷേ നിങ്ങളുടെ പാപങ്ങൾക്കു പ്രായശ്ചിത്തം ചെയ്യാൻ എനിക്കു കഴിഞ്ഞേക്കും.” ");
INSERT INTO malc_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","അങ്ങനെ മോശ യഹോവയുടെ അടുക്കൽ കയറിച്ചെന്നു. “ഈ ജനം എത്ര മഹാപാപം ചെയ്തിരിക്കുന്നു! അവർ തങ്ങൾക്കുതന്നെ സ്വർണംകൊണ്ടു ദേവന്മാരെ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","എന്നാൽ, ഇപ്പോൾ അവരുടെ പാപം ക്ഷമിക്കണമേ; അല്ലെങ്കിൽ അങ്ങ് എഴുതിയ പുസ്തകത്തിൽനിന്ന് എന്റെ പേരു മായിച്ചുകളയണമേ,” എന്നപേക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","യഹോവ മോശയോട്, “എന്നോടു പാപം ചെയ്തവന്റെ പേരു ഞാൻ എന്റെ പുസ്തകത്തിൽനിന്ന് മായിച്ചുകളയും. ");
INSERT INTO malc_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ആകയാൽ, നീ പോയി ഞാൻ നിന്നോടു കൽപ്പിച്ച ദേശത്തേക്ക് ഈ ജനത്തെ കൂട്ടിക്കൊണ്ടുപോകണം; എന്റെ ദൂതൻ നിന്റെ മുമ്പിൽ നടക്കും; എന്നാൽ അവരുടെ പ്രവൃത്തികളുടെ കണക്കുചോദിക്കുമ്പോൾ അവരുടെ പാപങ്ങൾക്കു ഞാൻ അവരെ ശിക്ഷിക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","അഹരോൻ ഉണ്ടാക്കിയ കാളക്കിടാവിന്റെ കാര്യത്തിൽ അവർ ചെയ്ത പാപംനിമിത്തം യഹോവ ജനത്തെ ഒരു ബാധയാൽ ദണ്ഡിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","യഹോവ മോശയോടു പിന്നെയും അരുളിച്ചെയ്തു: “നീയും ഈജിപ്റ്റിൽനിന്ന് നീ പുറപ്പെടുവിച്ചുകൊണ്ടുവന്ന ഈ ജനവും ഈ സ്ഥലംവിട്ട്, ‘ഞാൻ നിന്റെ സന്തതിക്കു നൽകും’ എന്ന് അബ്രാഹാമിനോടും യിസ്ഹാക്കിനോടും യാക്കോബിനോടും ശപഥംചെയ്ത ദേശത്തേക്കു പോകുക. ");
INSERT INTO malc_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ഞാൻ ഒരു ദൂതനെ നിനക്കുമുമ്പായി അയയ്ക്കും, കനാന്യരെയും അമോര്യരെയും ഹിത്യരെയും പെരിസ്യരെയും ഹിവ്യരെയും യെബൂസ്യരെയും ദേശത്തുനിന്ന് ഓടിച്ചുകളയും. ");
INSERT INTO malc_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","പാലും തേനും ഒഴുകുന്ന ദേശത്തേക്കു പോകുക. വഴിയിൽവെച്ചു ഞാൻ നിങ്ങളെ നശിപ്പിക്കാതിരിക്കേണ്ടതിന് ഞാൻ നിങ്ങളോടുകൂടെ വരികയില്ല; നിങ്ങൾ ദുശ്ശാഠ്യമുള്ള ജനം ആകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ദുഃഖകരമായ ഈ വചനം കേട്ടപ്പോൾ ജനം ദുഃഖിച്ചു; ആരും ആഭരണമൊന്നും ധരിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","“നിങ്ങൾ ദുശ്ശാഠ്യമുള്ള ജനമാകുന്നു. ഞാൻ ഒരു നിമിഷമെങ്കിലും നിങ്ങളോടുകൂടെ നടന്നാൽ നിങ്ങളെ നശിപ്പിക്കാൻ ഇടയായേക്കും; ഇപ്പോൾ നിങ്ങളുടെ ആഭരണങ്ങൾ നീക്കിക്കളയുക; നിങ്ങളോട് എന്തു ചെയ്യണമെന്ന് ഞാൻ നിശ്ചയിക്കും എന്നിങ്ങനെ ഇസ്രായേൽമക്കളോടു പറയുക,” എന്ന് യഹോവ മോശയോടു കൽപ്പിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","അങ്ങനെ, ഹോരേബ് പർവതത്തിങ്കൽ തുടങ്ങി ഇസ്രായേൽമക്കൾ ആഭരണം ധരിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","പാളയത്തിനു വെളിയിൽ അകലെയായി മോശ ഒരു കൂടാരമടിച്ചിരുന്നു. അതിനു “സമാഗമകൂടാരം” എന്നു പേരിട്ടു. യഹോവയെ അന്വേഷിക്കുന്നവരെല്ലാം പാളയത്തിനുപുറത്തു സമാഗമകൂടാരത്തിലേക്കു പോയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","മോശ കൂടാരത്തിലേക്കു പോകുമ്പോഴെല്ലാം, സകലജനവും എഴുന്നേറ്റ് ഓരോരുത്തനും സ്വന്തം കൂടാരവാതിൽക്കൽ നിന്നുകൊണ്ട്, മോശ കൂടാരത്തിൽ പ്രവേശിക്കുന്നതുവരെ, അദ്ദേഹത്തെ നോക്കിക്കൊണ്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","മോശ കൂടാരത്തിൽ പ്രവേശിക്കുമ്പോൾ, മേഘസ്തംഭം ഇറങ്ങി കൂടാരവാതിൽക്കൽ നിൽക്കുകയും യഹോവ മോശയോടു സംസാരിക്കുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","മേഘസ്തംഭം കൂടാരവാതിൽക്കൽ നിൽക്കുന്നതു കാണുമ്പോഴെല്ലാം ജനം എഴുന്നേറ്റ് അവരവരുടെ കൂടാരവാതിൽക്കൽ നിന്നുകൊണ്ട് യഹോവയെ നമസ്കരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ഒരു മനുഷ്യൻ തന്റെ സ്നേഹിതനോടു സംസാരിക്കുന്നതുപോലെ യഹോവ മോശയോട് അഭിമുഖമായി സംസാരിച്ചു. അതിനുശേഷം മോശ പാളയത്തിലേക്കു മടങ്ങിപ്പോകും. എന്നാൽ അവന്റെ ശുശ്രൂഷക്കാരനും നൂന്റെ പുത്രനുമായ യോശുവ എന്ന യുവാവു കൂടാരത്തെ വിട്ടുപിരിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","മോശ യഹോവയോട് ഇപ്രകാരം സംസാരിച്ചു: “ഈ ജനത്തെ നയിക്കുക എന്ന് അങ്ങ് എന്നോടു കൽപ്പിച്ചു: എന്നാൽ, ആരെയാണ് എന്നോടുകൂടെ അയയ്ക്കുന്നത് എന്ന് അങ്ങ് എന്നെ അറിയിച്ചിട്ടില്ല. ‘ഞാൻ നിന്റെ പേരിനാൽത്തന്നെ നിന്നെ അറിഞ്ഞിരിക്കുന്നു; എനിക്കു നിന്നോടു കൃപതോന്നിയിരിക്കുന്നു,’ എന്ന് അങ്ങ് അരുളിച്ചെയ്തിട്ടുമുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","അതുകൊണ്ട്, എന്നോടു പ്രസാദമുണ്ടെങ്കിൽ അങ്ങയുടെ വഴി എന്നെ അറിയിക്കണമേ; തുടർന്നും എന്നോടു കൃപയുണ്ടാകണം. ഈ ജനത അങ്ങയുടെ ജനമാകുന്നു എന്നും ഓർക്കണമേ.” ");
INSERT INTO malc_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","യഹോവ മറുപടി നൽകി: “എന്റെ സാന്നിധ്യം നിന്നോടുകൂടെ പോരും; ഞാൻ നിനക്കു സ്വസ്ഥതനൽകും.” ");
INSERT INTO malc_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","അപ്പോൾ മോശ യഹോവയോട് ഇപ്രകാരം സംസാരിച്ചു: “അങ്ങയുടെ സാന്നിധ്യം ഞങ്ങളോടുകൂടെ പോരുന്നില്ല എങ്കിൽ ഞങ്ങളെ ഇവിടെനിന്നു പുറപ്പെടുവിക്കരുതേ. ");
INSERT INTO malc_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","അങ്ങു ഞങ്ങളോടുകൂടെ പോരുന്നില്ല എങ്കിൽ, എന്നോടും ഈ ജനത്തോടും അങ്ങേക്കു കൃപയുണ്ടെന്നു ഞങ്ങൾ അറിയുന്നതെങ്ങനെ? എന്നെയും അങ്ങയുടെ ഈ ജനത്തെയും ഭൂമുഖത്തു മറ്റു ജനങ്ങളിൽനിന്നു വ്യത്യസ്തരാക്കുന്നത് എന്താണ്?” ");
INSERT INTO malc_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","യഹോവ മോശയോടു കൽപ്പിച്ചു: “എനിക്കു നിന്നോടു കൃപതോന്നിയിരിക്കുന്നു: ഞാൻ നിന്റെ പേരിനാൽത്തന്നെ നിന്നെ അറിഞ്ഞുമിരിക്കുന്നു; അതുകൊണ്ടു നീ അപേക്ഷിച്ച ഈ കാര്യവും ഞാൻ ചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","അപ്പോൾ മോശ, “അങ്ങയുടെ തേജസ്സ് എന്നെ കാണിക്കണമേ” എന്നപേക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","യഹോവ അരുളിച്ചെയ്തു: “ഞാൻ എന്റെ നന്മമുഴുവനും നിനക്കു ദൃശ്യമാക്കും, യഹോവ എന്ന എന്റെ നാമം ഞാൻ നിന്റെ മുമ്പിൽ ഘോഷിക്കും; കൃപ ചെയ്യാൻ എനിക്കു മനസ്സുള്ളവരോടു ഞാൻ കൃപ ചെയ്യും. കരുണകാണിക്കാൻ എനിക്കു മനസ്സുള്ളവരോടു ഞാൻ കരുണകാണിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","എന്നാൽ, നിനക്ക് എന്റെ മുഖം കാണാൻ കഴിയുകയില്ല; ഒരു മനുഷ്യനും എന്നെ കണ്ടു ജീവനോടെ ഇരിക്കുകയില്ല.” ");
INSERT INTO malc_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","യഹോവ വീണ്ടും അരുളിച്ചെയ്തു: “എന്റെ സമീപത്തുള്ള ഒരു സ്ഥലം ഉണ്ട്; ആ പാറമേൽ നീ നിൽക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","എന്റെ തേജസ്സു കടന്നുപോകുമ്പോൾ ഞാൻ നിന്നെ ആ പാറയുടെ പിളർപ്പിൽ ആക്കി, ഞാൻ കടന്നുപോകുന്നതുവരെ എന്റെ കൈകൊണ്ടു നിന്നെ മറയ്ക്കും. ");
INSERT INTO malc_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","പിന്നീടു ഞാൻ എന്റെ കൈ മാറ്റും; അപ്പോൾ നീ എന്റെ പിൻഭാഗം കാണും; എന്റെ മുഖം കാണപ്പെടാവുന്നതല്ല.” ");
INSERT INTO malc_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","യഹോവ പിന്നെയും മോശയോട് അരുളിച്ചെയ്തു: “ആദ്യത്തേതുപോലെ രണ്ടു കൽപ്പലകകൾ ചെത്തി ഉണ്ടാക്കുക: നീ പൊട്ടിച്ചുകളഞ്ഞ ആദ്യത്തെ കൽപ്പലകകളിൽ ഉണ്ടായിരുന്ന വചനങ്ങൾ ഞാൻ അതിൽ എഴുതും. ");
INSERT INTO malc_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","നീ രാവിലെ ഒരുങ്ങി, സീനായിപർവതത്തിൽ കയറിവരിക; പർവതാഗ്രത്തിൽ എന്റെമുമ്പിൽ നീ നിൽക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","നിന്നോടുകൂടെ ആരും വരരുത്; പർവതത്തിൽ ആരെയും കാണരുത്; പർവതത്തിനുസമീപം ആടുമാടുകൾ മേയുകയുമരുത്.” ");
INSERT INTO malc_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","അങ്ങനെ മോശ, ആദ്യത്തേതുപോലെയുള്ള രണ്ടു കൽപ്പലകകൾ ചെത്തിയുണ്ടാക്കി, അതിരാവിലെ എഴുന്നേറ്റ് യഹോവ കൽപ്പിച്ചിരുന്നതുപോലെ സീനായിപർവതത്തിൽ കയറിച്ചെന്നു; രണ്ടു കൽപ്പലകകളും അവൻ കൈയിൽ എടുത്തിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","അപ്പോൾ യഹോവ മേഘത്തിൽ ഇറങ്ങി അവന്റെ അടുക്കൽവന്നു; യഹോവ തന്റെ നാമം ഘോഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","യഹോവ മോശയുടെമുമ്പിലൂടെ കടന്ന് ഇങ്ങനെ ഘോഷിച്ചു: “യഹോവ, യഹോവയായ ദൈവം, കരുണാമയനും ആർദ്രഹൃദയനുമാകുന്നു; ക്ഷമാശീലനും സ്നേഹസമ്പന്നനും വിശ്വസ്തതയുമുള്ളവനും ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ആയിരങ്ങളോടു കരുണ കാണിക്കുന്നവനും അകൃത്യവും അതിക്രമവും പാപവും ക്ഷമിക്കുന്നവനും കുറ്റംചെയ്തവരെ വെറുതേവിടാതെ, പിതാക്കന്മാരുടെ അകൃത്യം മക്കളുടെമേലും മക്കളുടെ മക്കളുടെമേലും, മൂന്നും നാലും തലമുറവരെ അനുഭവിപ്പിക്കുന്നവനും ആകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","അപ്പോൾത്തന്നെ മോശ നിലത്തുവീണു നമസ്കരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“കർത്താവേ, അങ്ങേക്ക് എന്നോടു കൃപയുണ്ടെങ്കിൽ, കർത്താവു ഞങ്ങളോടുകൂടെ പോരണമേ. ഇതു ദുശ്ശാഠ്യമുള്ള ജനമാകുന്നു, എങ്കിലും ഞങ്ങളുടെ അതിക്രമവും പാപവും ക്ഷമിച്ചു, ഞങ്ങളെ അവിടത്തെ അവകാശം ആക്കണമേ,” എന്നപേക്ഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","അപ്പോൾ യഹോവ: “ഞാൻ നിങ്ങളുമായി ഒരു ഉടമ്പടിചെയ്യുന്നു. ലോകത്തിലെങ്ങും ഒരു ജനതയുടെയും മധ്യത്തിൽ മുമ്പൊരിക്കലും ചെയ്തിട്ടില്ലാത്ത അത്ഭുതങ്ങൾ ഞാൻ നിന്റെ സകലജനത്തിന്റെയും മുമ്പാകെ ചെയ്യും. യഹോവയായ ഞാൻ നിങ്ങൾക്കുവേണ്ടി പ്രവർത്തിക്കാൻപോകുന്ന കാര്യങ്ങൾ എത്ര ഭയങ്കരമാണെന്നു നിങ്ങൾക്കുചുറ്റും വസിക്കുന്ന ജനം കാണും. ");
INSERT INTO malc_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ഇന്നു ഞാൻ നിന്നോടു കൽപ്പിക്കുന്നത് അനുസരിക്കുക. അമോര്യർ, കനാന്യർ, ഹിത്യർ, പെരിസ്യർ, ഹിവ്യർ, യെബൂസ്യർ എന്നിവരെ ഞാൻ നിങ്ങളുടെമുമ്പിൽനിന്ന് ഓടിച്ചുകളയും. ");
INSERT INTO malc_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","നീ ചെല്ലുന്ന ദേശത്തു പാർക്കുന്ന ജനങ്ങളുമായി യാതൊരുവിധ കരാറിലും ഏർപ്പെടാതിരിക്കാൻ സൂക്ഷിച്ചുകൊള്ളണം. അല്ലെങ്കിൽ, അതു നിനക്ക് ഒരു കെണിയായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","നിങ്ങൾ അവരുടെ ബലിപീഠങ്ങൾ തകർക്കണം; അവരുടെ ആചാരസ്തൂപങ്ങൾ ഉടച്ചുകളയണം; അവരുടെ അശേരാപ്രതിഷ്ഠകൾ വെട്ടിക്കളയണം. ");
INSERT INTO malc_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","അന്യദേവതകളെ നമസ്കരിക്കരുത്; തീക്ഷ്ണൻ എന്നു പേരുള്ള യഹോവ, തീക്ഷ്ണതയുള്ളവൻതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ദേശത്തു പാർക്കുന്ന ജനങ്ങളുമായി യാതൊരുവിധ കരാറിലും ഏർപ്പെടരുത്; അവർ തങ്ങളുടെ ദേവതകളോടു പരസംഗം ചെയ്യുകയും അവർക്കു ബലികഴിക്കുകയും ചെയ്യുമ്പോൾ അവർ നിങ്ങളെ ക്ഷണിക്കാനും നിങ്ങൾ അവരുടെ ബലികൾ ഭക്ഷിക്കാനും ഇടയാകരുത്. ");
INSERT INTO malc_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","അവരുടെ പുത്രിമാരെ നിന്റെ പുത്രന്മാർക്കു ഭാര്യമാരായി എടുക്കാനും അവരുടെ പുത്രിമാർ തങ്ങളുടെ ദേവന്മാരോടു പരസംഗം ചെയ്യാനും അവർ നിങ്ങളുടെ പുത്രന്മാരെ അങ്ങനെ ചെയ്യാൻ പ്രേരിപ്പിക്കാനും ഇടവരരുത്. ");
INSERT INTO malc_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“നിങ്ങൾക്കായി ദേവന്മാരെ വാർത്തുണ്ടാക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“പുളിപ്പില്ലാത്ത അപ്പത്തിന്റ ഉത്സവം ആചരിക്കണം. ഞാൻ നിങ്ങളോടു കൽപ്പിച്ചതുപോലെ ഏഴുദിവസം പുളിപ്പില്ലാത്ത അപ്പം ഭക്ഷിക്കണം. നീ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെട്ടുപോന്ന ആബീബ് മാസത്തിൽ നിശ്ചിതസമയത്ത് അത് ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“നിന്റെ ആടുകളുടെയും കന്നുകാലികളുടെയും കടിഞ്ഞൂലുകൾ ഉൾപ്പെടെ ആദ്യം ജനിക്കുന്നതെല്ലാം എനിക്കുള്ളതാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","എന്നാൽ കഴുതയുടെ കടിഞ്ഞൂലിനെ ആട്ടിൻകുട്ടിയെക്കൊണ്ടു വീണ്ടുകൊള്ളണം. നീ അതിനെ വീണ്ടുകൊള്ളുന്നില്ലെങ്കിൽ അതിന്റെ കഴുത്ത് ഒടിച്ചുകളയണം. നിന്റെ പുത്രന്മാരിൽ ആദ്യജാതന്മാരെ ഒക്കെയും വീണ്ടുകൊള്ളണം. “വെറുംകൈയോടെ ആരും എന്റെമുമ്പിൽ വരരുത്. ");
INSERT INTO malc_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ആറുദിവസം നീ അധ്വാനിക്കണം; ഏഴാംദിവസം സ്വസ്ഥമായിരിക്കണം; വിതകാലമോ കൊയ്ത്തുകാലമോ ആയാലും നീ വിശ്രമിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“ഗോതമ്പുകൊയ്ത്തിന്റെ ആദ്യഫലോത്സവത്തോടൊപ്പം ആഴ്ചകളുടെ പെരുന്നാളും വർഷാന്ത്യത്തിൽ കായ്-കനിപ്പെരുന്നാളും നീ ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","നിങ്ങളുടെ സകലപുരുഷന്മാരും, വർഷത്തിൽ മൂന്നുപ്രാവശ്യം ഇസ്രായേലിന്റെ ദൈവമായ, കർത്താവായ യഹോവയുടെ സന്നിധിയിൽ വരണം. ");
INSERT INTO malc_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ഞാൻ ജനതകളെ നിങ്ങളുടെമുമ്പിൽനിന്ന് നീക്കിക്കളഞ്ഞു, നിന്റെ ദേശത്തെ വിശാലമാക്കും. നിങ്ങൾ വർഷത്തിൽ മൂന്നുപ്രാവശ്യം നിങ്ങളുടെ ദൈവമായ യഹോവയുടെ സന്നിധിയിൽ നിൽക്കാൻപോകുമ്പോൾ ആരും നിങ്ങളുടെ ദേശം മോഹിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“പുളിപ്പുള്ള യാതൊന്നിനോടുംകൂടെ എനിക്കു യാഗരക്തം അർപ്പിക്കരുത്. പെസഹാപ്പെരുന്നാളിലെ യാഗം പ്രഭാതംവരെ ശേഷിപ്പിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“നിന്റെ നിലത്തിലെ ആദ്യഫലങ്ങളിൽ ഏറ്റം മെച്ചമായവ നിന്റെ ദൈവമായ യഹോവയുടെ ആലയത്തിൽ കൊണ്ടുവരണം. “ആട്ടിൻകുട്ടിയെ അതിന്റെ തള്ളയുടെ പാലിൽ പാകംചെയ്യരുത്.” ");
INSERT INTO malc_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","യഹോവ പിന്നെയും മോശയോട് അരുളിച്ചെയ്തത്, “ഈ വചനങ്ങൾ എഴുതുക; ഈ വചനങ്ങളനുസരിച്ചു ഞാൻ നിന്നോടും ഇസ്രായേലിനോടും ഒരു ഉടമ്പടി ചെയ്തിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","മോശ, ഭക്ഷണം കഴിക്കാതെയും വെള്ളം കുടിക്കാതെയും നാൽപ്പതുരാവും നാൽപ്പതുപകലും യഹോവയുടെകൂടെ ആയിരുന്നു. അവിടന്ന് ആ നിയമത്തിന്റെ വചനങ്ങളെ, പത്തുകൽപ്പനകളെത്തന്നെ, കൽപ്പലകകളിൽ എഴുതിക്കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","മോശ കൈകളിൽ കല്ലിൽ കൊത്തിയ രണ്ട് ഉടമ്പടിയുടെ പലകകളുമായി സീനായിപർവതത്തിൽനിന്ന് ഇറങ്ങിവന്നപ്പോൾ, താൻ യഹോവയോടു സംസാരിച്ചതുകൊണ്ടു തന്റെ മുഖം പ്രകാശിച്ചിരുന്നു എന്ന് അദ്ദേഹം അറിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","മോശയുടെ മുഖം പ്രകാശിക്കുന്നതു കണ്ടിട്ട് അഹരോനും എല്ലാ ഇസ്രായേൽമക്കളും അദ്ദേഹത്തെ സമീപിക്കാൻ ഭയപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","എന്നാൽ മോശ അവരെ വിളിച്ചു; അഹരോനും സഭയിലെ എല്ലാ നേതാക്കന്മാരും അദ്ദേഹത്തിന്റെ അടുക്കൽ ചെന്നു; അദ്ദേഹം അവരോടു സംസാരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","അതിനുശേഷം സകല ഇസ്രായേൽജനവും മോശയുടെ അടുക്കൽവന്നു; സീനായിപർവതത്തിൽ യഹോവ നൽകിയ എല്ലാ കൽപ്പനകളും മോശ അവരെ അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","മോശ അവരോടു സംസാരിച്ചുതീർന്നശേഷം തന്റെ മുഖത്ത് ഒരു മൂടുപടം ഇട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","എന്നാൽ, യഹോവയോടു സംസാരിക്കാൻ തിരുസന്നിധിയിലേക്കു പോയി, പുറത്തു വരുന്നതുവരെ അദ്ദേഹം മൂടുപടം മാറ്റിയിരുന്നു. തന്നോടു കൽപ്പിച്ചത് മോശ പുറത്തുവന്ന് ഇസ്രായേൽമക്കളോട് അറിയിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","മോശയുടെ മുഖം പ്രകാശിക്കുന്നതായി അവർ കണ്ടു. ഇതിനുശേഷം മോശ യഹോവയോടു സംസാരിക്കാൻ അകത്തു പോകുന്നതുവരെ അദ്ദേഹം മൂടുപടം ഇട്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","മോശ, ഇസ്രായേൽജനത്തിന്റെ സംഘത്തെ മുഴുവനും കൂട്ടിവരുത്തി. അവരോട് ഇപ്രകാരം സംസാരിച്ചു: “നിങ്ങൾ ചെയ്യണമെന്നു യഹോവ കൽപ്പിച്ചിരിക്കുന്ന വചനങ്ങൾ ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ആറുദിവസം അധ്വാനിക്കണം; എന്നാൽ, ഏഴാംദിവസം നിങ്ങൾക്ക് വിശുദ്ധമായി യഹോവയ്ക്ക് സ്വസ്ഥതയുള്ള ശബ്ബത്ത് ആയിരിക്കണം. അന്നു വേലചെയ്യുന്നവൻ മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ശബ്ബത്ത് നാളിൽ നിങ്ങളുടെ വാസസ്ഥലങ്ങളിൽ എങ്ങും തീ കത്തിക്കരുത്.” ");
INSERT INTO malc_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","മോശ ഇസ്രായേൽജനത്തിന്റെ സംഘത്തോടു പറഞ്ഞത്, “യഹോവ ഇപ്രകാരം കൽപ്പിച്ചു: ");
INSERT INTO malc_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","നിങ്ങൾക്കുള്ളവയിൽനിന്ന് യഹോവയ്ക്കു കാഴ്ചദ്രവ്യം എടുക്കണം. സന്മനസ്സുള്ളവരെല്ലാം യഹോവയ്ക്കു വഴിപാടു കൊണ്ടുവരട്ടെ. “പൊന്ന്, വെള്ളി, വെങ്കലം, ");
INSERT INTO malc_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, നേർമയേറിയ ചണവസ്ത്രം, കോലാട്ടുരോമം, ");
INSERT INTO malc_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ആട്ടുകൊറ്റന്റെ ചെമപ്പിച്ച തുകൽ, തഹശുതുകൽ, ഖദിരമരം, ");
INSERT INTO malc_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","വിളക്കിനുള്ള ഒലിവെണ്ണ, അഭിഷേകതൈലത്തിനും സുഗന്ധധൂപത്തിനും വേണ്ടുന്ന സുഗന്ധദ്രവ്യങ്ങൾ, ");
INSERT INTO malc_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ഏഫോദിലും നിർണയപ്പതക്കത്തിലും പതിക്കാനുള്ള ഗോമേദകക്കല്ല്, മറ്റു രത്നങ്ങൾ എന്നിവതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“നിങ്ങളിൽ വിദഗ്ദ്ധർ എല്ലാവരും വന്നു യഹോവ കൽപ്പിച്ചിരിക്കുന്നതെല്ലാം ഉണ്ടാക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“സമാഗമകൂടാരം; അതിന്റെ കൂടാരവും, മൂടുവിരി, കൊളുത്തുകൾ, പലകകൾ, സാക്ഷകൾ, തൂണുകൾ, ചുവടുകൾ, ");
INSERT INTO malc_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","പേടകം, അതിന്റെ തണ്ടുകൾ, പാപനിവാരണസ്ഥാനം, പേടകം മറയ്ക്കുന്ന തിരശ്ശീല, ");
INSERT INTO malc_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","മേശയും അതിന്റെ തണ്ടുകളും എല്ലാ ഉപകരണങ്ങളും കാഴ്ചയപ്പവും ");
INSERT INTO malc_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","വെളിച്ചത്തിനു വിളക്കുതണ്ടും അതിന്റെ ഉപകരണങ്ങളും, അതിന്റെ വിളക്കുകൾ, വിളക്കിനുള്ള എണ്ണ, ");
INSERT INTO malc_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ധൂപപീഠം, അതിന്റെ തണ്ടുകൾ, അഭിഷേകതൈലം, സുഗന്ധധൂപവർഗം, സമാഗമകൂടാരത്തിലേക്കുള്ള പ്രവേശനവാതിലിന്റെ മറശ്ശീല, ");
INSERT INTO malc_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ഹോമയാഗപീഠം, അതിന്റെ വെങ്കലജാലം, തണ്ടുകൾ, അതിന്റെ എല്ലാ ഉപകരണങ്ങളും, വെങ്കലത്തൊട്ടി അതിന്റെ കാൽ, ");
INSERT INTO malc_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","സമാഗമകൂടാരാങ്കണത്തിന്റെ മറശ്ശീലകൾ, അതിന്റെ തൂണുകൾ, ചുവടുകൾ, അങ്കണകവാടത്തിന്റെ മറശ്ശീല, ");
INSERT INTO malc_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","സമാഗമകൂടാരത്തിന്റെ കുറ്റികൾ, അങ്കണത്തിന്റെ കുറ്റികൾ, അവയുടെ കയറുകൾ, ");
INSERT INTO malc_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷയ്ക്കു നെയ്തെടുത്ത വിശേഷവസ്ത്രങ്ങൾ—പൗരോഹിത്യശുശ്രൂഷയ്ക്കായി ഉപയോഗിക്കുന്ന പുരോഹിതനായ അഹരോന്റെ വിശുദ്ധവസ്ത്രം, അവന്റെ പുത്രന്മാരുടെ വസ്ത്രങ്ങൾ എന്നിവതന്നെ.” ");
INSERT INTO malc_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","അപ്പോൾ ഇസ്രായേൽമക്കളുടെ സർവസംഘവും മോശയുടെമുമ്പിൽനിന്ന് പുറപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","സന്മനസ്സുള്ളവരും ഹൃദയത്തിൽ താത്പര്യം തോന്നിയവരും സമാഗമകൂടാരത്തിന്റെ വേലകൾക്കും, അതിന്റെ എല്ലാ ശുശ്രൂഷകൾക്കും വിശുദ്ധവസ്ത്രങ്ങൾക്കുംവേണ്ടി യഹോവയ്ക്കു വഴിപാടുകൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ഔദാര്യമനസ്സുള്ള എല്ലാ പുരുഷന്മാരും സ്ത്രീകളും യഹോവയ്ക്കു സ്വർണം വഴിപാടായി കൊണ്ടുവന്നു: വള, കുണുക്ക്, മോതിരം, മാല മുതലായ സ്വർണാഭരണങ്ങൾ ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, മൃദുലചണനൂൽ, കോലാട്ടുരോമം, ആട്ടുകൊറ്റന്റെ ചെമപ്പിച്ച തുകൽ, തഹശുതുകൽ എന്നിവ കൈവശമുള്ളവർ അവ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","വെള്ളിയും വെങ്കലവും യഹോവയ്ക്കു വഴിപാടായി നൽകാൻ മനസ്സുള്ളവർ അതു കൊണ്ടുവന്നു, ഏതെങ്കിലും പണിക്കുതകത്തക്കവണ്ണം ഖദിരമരം കൈവശമുള്ളവർ അതും കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","വിദഗ്ദ്ധകളായ സ്ത്രീകൾ സ്വന്തം കൈകൊണ്ടു നെയ്തെടുത്ത നീലനൂലും ഊതനൂലും ചെമപ്പുനൂലും മൃദുലചണനൂലും കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","വിദഗ്ദ്ധകളും ഉത്സാഹികളുമായ സ്ത്രീകൾ കോലാട്ടുരോമം നെയ്തെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ഏഫോദിനും നിർണയപ്പതക്കത്തിനും പതിക്കേണ്ടുന്ന മറ്റുരത്നങ്ങളും ഗോമേദകക്കല്ലുകളും പ്രമാണികൾ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","കൂടാതെ, വെളിച്ചത്തിനുള്ള ഒലിവെണ്ണയും അഭിഷേകതൈലത്തിനും സുഗന്ധധൂപത്തിനുമുള്ള പരിമളവർഗവും അവർ കൊണ്ടുവന്നു. യഹോവ മോശമുഖാന്തരം കൽപ്പിച്ച സകലപ്രവൃത്തികൾക്കും ");
INSERT INTO malc_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ഇസ്രായേൽമക്കളിൽ ഔദാര്യമനസ്സുള്ള എല്ലാ പുരുഷന്മാരും സ്ത്രീകളും യഹോവയ്ക്കു സ്വമേധാദാനങ്ങൾ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","മോശ ഇസ്രായേൽജനത്തോട് ഇപ്രകാരം പറഞ്ഞു: “നോക്കുക, യെഹൂദാഗോത്രത്തിൽ ഹൂരിന്റെ മകനായ ഊരിയുടെ മകൻ ബെസലേലിനെ യഹോവ പേരുചൊല്ലി വിളിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","യഹോവ അവനെ ദൈവാത്മാവിനാൽ നിറച്ച്, എല്ലാവിധ കരകൗശലപ്പണികളിലും വൈദഗ്ദ്ധ്യവും പ്രാപ്തിയും ജ്ഞാനവും നൽകിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","സ്വർണം, വെള്ളി, വെങ്കലം എന്നിവയിൽ കലാചാതുരിയോടെ പണികൾ ചെയ്യാനും, ");
INSERT INTO malc_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","രത്നങ്ങൾ വെട്ടിപ്പതിക്കാനും മരത്തിൽ കൊത്തുപണികൾ ചെയ്യാനും അങ്ങനെ സകലവിധമായ കരകൗശലപ്പണികൾ ചെയ്യാനും ഞാൻ അവനെ വിളിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","യഹോവ ബെസലേലിനും ദാൻഗോത്രത്തിൽ അഹീസാമാക്കിന്റെ മകനായ ഒഹൊലീയാബിനും മറ്റുള്ളവരെ അഭ്യസിപ്പിക്കാനുള്ള പ്രാപ്തിയും നൽകിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","കൊത്തുപണിക്കാരന്റെയും കരകൗശലപ്പണിക്കാരന്റെയും നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, മൃദുലചണനൂൽ എന്നിവകൊണ്ടു പണിചെയ്യുന്ന തയ്യൽക്കാരന്റെയും നെയ്ത്തുകാരന്റെയും സകലവിധ പണികളും കലാചാതുരിയോടെ ചെയ്യുന്നതിനു യഹോവ അവർക്കു വൈദഗ്ദ്ധ്യം നൽകിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ബെസലേലും ഒഹൊലീയാബും, വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷയ്ക്കു യഹോവയുടെ കൽപ്പനപ്രകാരം സകലപ്രവൃത്തിയും ചെയ്യുന്നതിനു യഹോവ വൈദഗ്ദ്ധ്യവും പ്രാപ്തിയും നൽകിയ സകലജ്ഞാനികളും, യഹോവ കൽപ്പിച്ചതനുസ്സരിച്ച് വേലചെയ്യണം.” ");
INSERT INTO malc_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","അങ്ങനെ മോശ ബെസലേലിനെയും ഒഹൊലീയാബിനെയും യഹോവ ജ്ഞാനം നൽകിയിരുന്ന എല്ലാ വിദഗ്ദ്ധരെയും ജോലിചെയ്യാൻ മനസ്സിൽ പ്രേരണ ലഭിച്ച എല്ലാവരെയും വിളിച്ചുകൂട്ടി. ");
INSERT INTO malc_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","വിശുദ്ധമന്ദിരത്തിന്റെ പണിക്കുവേണ്ടി ഇസ്രായേൽമക്കൾ കൊടുത്തിരുന്ന വഴിപാടുകൾ എല്ലാം അവർ മോശയുടെ പക്കൽനിന്നു വാങ്ങി. എന്നാൽ ജനം പിന്നെയും പ്രഭാതംതോറും സ്വമേധാദാനങ്ങളെ അദ്ദേഹത്തിന്റെ അടുക്കൽ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","അപ്പോൾ, വിശുദ്ധമന്ദിരത്തിലെ സകലജോലികളും ചെയ്തുപോന്ന വിദഗ്ദ്ധന്മാർ ജോലി നിർത്തി മോശയുടെ അടുക്കൽവന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“യഹോവ ചെയ്യാൻ കൽപ്പിച്ചിട്ടുള്ള പ്രവൃത്തികൾക്കു വേണ്ടതിലധികമായി ജനങ്ങൾ കൊണ്ടുവരുന്നു,” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","അപ്പോൾ മോശ ഒരു കൽപ്പന നൽകി, “പുരുഷന്മാരോ സ്ത്രീകളോ വിശുദ്ധമന്ദിരത്തിലേക്കു വഴിപാടായി ഇനി ഒന്നും കൊണ്ടുവരേണ്ടതില്ല” എന്നു പാളയത്തിലെങ്ങും അറിയിച്ചു. അങ്ങനെ, ജനം വഴിപാടുകൾ കൊണ്ടുവരുന്നതു നിർത്തി. ");
INSERT INTO malc_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","അവർക്കു ലഭിച്ച സാധനങ്ങൾ, എല്ലാ പണികളും ചെയ്യാൻ ആവശ്യമായതിലും അധികം ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","പണിക്കാരിൽ വൈദഗ്ദ്ധ്യമുള്ളവർ എല്ലാവരും, പിരിച്ച മൃദുലചണനൂൽ, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ എന്നിവകൊണ്ടുണ്ടാക്കിയ പത്തു തിരശ്ശീലകൊണ്ടു സമാഗമകൂടാരം ഉണ്ടാക്കി; തിരശ്ശീലകളിൽ നെയ്ത്തുകാരന്റെ ചിത്രപ്പണിയായി കെരൂബുകൾ ഉണ്ടാക്കിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","എല്ലാ തിരശ്ശീലകൾക്കും ഒരേ അളവായിരുന്നു. ഓരോ തിരശ്ശീലയ്ക്കും ഇരുപത്തെട്ടുമുഴം നീളവും നാലുമുഴം വീതിയും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","അവർ അഞ്ചു തിരശ്ശീലകളും ഒന്നോടൊന്നു തുന്നിച്ചേർത്തു; മറ്റേ അഞ്ചു തിരശ്ശീലകളും ഒന്നോടൊന്നു തുന്നിച്ചേർത്തു. ");
INSERT INTO malc_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","അതിനുശേഷം അവർ തുന്നിച്ചേർത്ത ഒന്നാമത്തെ വിരിയുടെ അറ്റത്തുള്ള തിരശ്ശീലയുടെ വിളുമ്പിൽ നീലനൂൽകൊണ്ടു കണ്ണികൾ ഉണ്ടാക്കി. മറ്റേ വിരിയുടെ അറ്റത്തുള്ള തിരശ്ശീലയുടെ വിളുമ്പിലും അതുപോലെ കണ്ണികൾ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ഒരുകൂട്ടം തിരശ്ശീലയിൽ അൻപതു കണ്ണികൾ ഉണ്ടാക്കി; രണ്ടാമത്തെ കൂട്ടം തിരശ്ശീലയുടെ വിളുമ്പിലും അൻപതു കണ്ണികൾ ഉണ്ടാക്കി. കണ്ണികൾ നേർക്കുനേർ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","അവർ തങ്കംകൊണ്ട് അൻപതു കൊളുത്തും ഉണ്ടാക്കി. കൊളുത്തുകൊണ്ടു രണ്ടു തിരശ്ശീലക്കൂട്ടവും ഒന്നോടൊന്ന് ഒരുമിച്ചുചേർത്തു. അങ്ങനെ സമാഗമകൂടാരം ഒന്നായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","സമാഗമകൂടാരത്തിന്മേൽ മൂടുവിരിയായി കോലാട്ടുരോമംകൊണ്ടു പതിനൊന്നു തിരശ്ശീല ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","പതിനൊന്നു തിരശ്ശീലയ്ക്കും ഒരേ അളവ് ആയിരുന്നു—മുപ്പതുമുഴം നീളവും നാലുമുഴം വീതിയും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","അവർ അഞ്ചു തിരശ്ശീല ഒരുമിച്ചും മറ്റ് ആറു തിരശ്ശീല ഒരുമിച്ചും തുന്നിച്ചേർത്തു. ");
INSERT INTO malc_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ഇപ്രകാരം തുന്നിച്ചേർത്ത ഒന്നാമത്തെ വിരിയുടെ അറ്റത്തുള്ള തിരശ്ശീലയുടെ വിളുമ്പിൽ അൻപതു കണ്ണിയും രണ്ടാമത്തെ വിരിയുടെ അറ്റത്തുള്ള തിരശ്ശീലയുടെ വിളുമ്പിൽ അൻപതു കണ്ണിയും അവർ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","കൂടാരം ഒന്നായി ഇണച്ചു ചേർക്കേണ്ടതിന്, അവർ വെങ്കലംകൊണ്ട് അൻപതു കൊളുത്ത് ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ആട്ടുകൊറ്റന്റെ ചെമപ്പിച്ചതുകൽകൊണ്ടു കൂടാരത്തിന് ഒരു മൂടിയും അതിന്റെമീതേ തഹശുതുകൽകൊണ്ട് ഒരു പുറമൂടിയും അവർ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","അവർ, സമാഗമകൂടാരത്തിനു നിവർന്നുനിൽക്കുന്ന ഖദിരമരംകൊണ്ടുള്ള പലകകൾ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ഓരോ പലകയ്ക്കും പത്തുമുഴം നീളവും ഒന്നരമുഴം വീതിയും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","പലകകൾതമ്മിൽ ചേർന്നിരിക്കുംവിധം ഓരോ പലകയ്ക്കും രണ്ടു കുടുമകൾവീതം ഉണ്ടാക്കി; സമാഗമകൂടാരത്തിന്റെ എല്ലാ പലകകളും ഇതേരീതിയിൽ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","അവർ സമാഗമകൂടാരത്തിന്റെ തെക്കുവശത്ത് ഇരുപതു പലക ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ഒരു പലകയുടെ അടിയിൽ രണ്ടു കുടുമകളും അതിനു രണ്ടു ചുവടും അങ്ങനെ നാൽപ്പതു വെള്ളിച്ചുവടും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","സമാഗമകൂടാരത്തിന്റെ മറ്റേവശമായ വടക്കുവശത്ത് ഇരുപതു പലകയും ");
INSERT INTO malc_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ഒരു പലകയുടെ അടിയിൽ രണ്ടു ചുവടുകൾവീതം നാൽപ്പതു വെള്ളിച്ചുവടുകളും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","സമാഗമകൂടാരത്തിന്റെ പിൻഭാഗമായ പടിഞ്ഞാറുവശത്ത് ആറു പലകകൾ അവർ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","സമാഗമകൂടാരത്തിന്റെ ഇരുവശത്തുമുള്ള കോണുകൾക്ക് ഈരണ്ടു പലകയും അവർ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","രണ്ടു മൂലകളിലും താഴെമുതൽ മുകളിൽ ഒറ്റവളയംവരെ അവ ഇരട്ടപ്പലകയായിരുന്നു. രണ്ടു പലകകളും ഇപ്രകാരം ആയിരുന്നു. അവ രണ്ടും മൂലപ്പലകകളാണ്. ");
INSERT INTO malc_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ഇങ്ങനെ എട്ടു പലകയും ഓരോ പലകയുടെയും അടിയിൽ രണ്ടു ചുവടുവീതം പതിനാറു വെള്ളിച്ചുവടും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","അവർ ഖദിരമരംകൊണ്ടു സാക്ഷകൾ ഉണ്ടാക്കി; സമാഗമകൂടാരത്തിന്റെ ഒരു വശത്തെ പലകയ്ക്ക് അഞ്ചു സാക്ഷയും ");
INSERT INTO malc_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","മറുവശത്തെ പലകകൾക്ക് അഞ്ചു സാക്ഷയും സമാഗമകൂടാരത്തിന്റെ പിൻഭാഗമായ പടിഞ്ഞാറുവശത്തെ പലകകൾക്ക് അഞ്ചു സാക്ഷയും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","നടുവിലുള്ള സാക്ഷ പലകകളുടെ നടുവിൽ ഒരറ്റംമുതൽ മറ്റേ അറ്റംവരെ എത്തുംവിധം ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","പലകകൾ അവർ തങ്കംകൊണ്ടു പൊതിഞ്ഞു: സാക്ഷ കടത്തുന്നതിന് തങ്കംകൊണ്ടു വളയങ്ങൾ ഉണ്ടാക്കി: സാക്ഷകളും അവർ തങ്കംകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ട് അവർ തിരശ്ശീല ഉണ്ടാക്കി. തിരശ്ശീലയിൽ കെരൂബുകളുടെ രൂപം ചിത്രപ്പണിയായി നെയ്ത്തുകാരൻ തുന്നിച്ചേർത്തിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","അവർ, അതിനു ഖദിരമരംകൊണ്ടു നാലുതൂണും ഉണ്ടാക്കി. അവ തങ്കംകൊണ്ടു പൊതിഞ്ഞു: അവയ്ക്കു തങ്കക്കൊളുത്തുകൾ ഉണ്ടാക്കി; വെള്ളികൊണ്ടു നാലുചുവടും വാർപ്പിച്ചുണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","കൂടാരവാതിലിനു നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽപ്പണിയായി ഒരു മറശ്ശീലയും ");
INSERT INTO malc_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","അതിന് അഞ്ചുതൂണും അവയ്ക്കു കൊളുത്തും ഉണ്ടാക്കി; അവർ തൂണുകളുടെ ചുവടുകളും മേൽച്ചുറ്റുപടികളും തങ്കംകൊണ്ടു പൊതിഞ്ഞു; അവയ്ക്ക് അഞ്ചു വെങ്കലച്ചുവടുകളും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ബെസലേൽ, ഖദിരമരംകൊണ്ടു പേടകം ഉണ്ടാക്കി; അതിനു രണ്ടരമുഴം നീളവും ഒന്നരമുഴം വീതിയും ഒന്നരമുഴം ഉയരവും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","അദ്ദേഹം അതിന്റെ അകവും പുറവും തങ്കംകൊണ്ടു പൊതിഞ്ഞു; അതിനുചുറ്റും തങ്കംകൊണ്ടു വാർത്തുണ്ടാക്കി ഒരു അരികുപാളി പിടിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","അതിന്റെ നാലു കാലിനുമായി നാലു തങ്കവളയം വാർത്തുണ്ടാക്കി, രണ്ടു വളയം ഒരുവശത്തും രണ്ടു വളയം മറ്റേവശത്തുമായി ഉറപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","പിന്നെ അദ്ദേഹം ഖദിരമരംകൊണ്ടു തണ്ടുകൾ ഉണ്ടാക്കി അവ തങ്കംകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","പേടകം ചുമക്കേണ്ടതിന് ആ തണ്ടുകൾ അതിന്റെ വശങ്ങളിലുള്ള വളയങ്ങളിൽ ഉറപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","അദ്ദേഹം തങ്കംകൊണ്ട് രണ്ടരമുഴം നീളവും ഒന്നരമുഴം വീതിയുമുള്ള പാപനിവാരണസ്ഥാനം ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","പിന്നെ അദ്ദേഹം, പാപനിവാരണസ്ഥാനത്തിന്റെ രണ്ടറ്റത്തും അടിപ്പുപണിയായി തങ്കംകൊണ്ടു രണ്ടു കെരൂബുകൾ നിർമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ഒരു കെരൂബ് ഒരറ്റത്തും മറ്റേ കെരൂബ് മറ്റേ അറ്റത്തും. ഇങ്ങനെ കെരൂബുകളെ പാപനിവാരണസ്ഥാനത്തിന്റെ രണ്ടറ്റത്തും അതിൽനിന്നുതന്നെ ഉള്ളതായി അദ്ദേഹം ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","കെരൂബുകൾ മുകളിലേക്കു ചിറകുകൾ വിടർത്തി, ചിറകുകൾകൊണ്ടു പാപനിവാരണസ്ഥാനത്തെ മൂടുകയും പരസ്പരം അഭിമുഖമായിരിക്കുകയും ചെയ്തു. കെരൂബുകളുടെ മുഖം പാപനിവാരണസ്ഥാനത്തിനുനേരേ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","അവർ ഖദിരമരംകൊണ്ടു മേശ ഉണ്ടാക്കി; അതിനു രണ്ടുമുഴം നീളവും ഒരുമുഴം വീതിയും ഒന്നരമുഴം പൊക്കവും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","അവർ അതു തങ്കംകൊണ്ടു പൊതിഞ്ഞു; ചുറ്റും തങ്കംകൊണ്ട് ഒരു വക്ക് ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","അതിനുചുറ്റും കൈപ്പത്തിയുടെ വീതിയുള്ള ഒരു പട്ടയും പട്ടയ്ക്കുമേൽ തങ്കംകൊണ്ടു വാർത്ത അരികുപാളിയും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","അവർ മേശയ്ക്കു നാലു തങ്കവളയം വാർത്തുണ്ടാക്കി. അത് നാലു കോണുകളിലുമുള്ള നാലു കാലുകളിൽ തറച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","മേശ ചുമക്കാൻ ഉപയോഗിക്കുന്ന തണ്ടുകൾ ചെലുത്താനുള്ള വളയങ്ങൾ പട്ടയോടു ചേർത്തിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","മേശ ചുമക്കേണ്ടതിനുള്ള തണ്ടുകൾ ഖദിരമരംകൊണ്ടുണ്ടാക്കി തങ്കംകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","മേശമേലുള്ള ഉപകരണങ്ങളായ തളികകളും താലങ്ങളും കിണ്ടികളും പാനീയയാഗങ്ങൾ പകരുന്നതിനുള്ള ഭരണികളും അവർ തങ്കംകൊണ്ടുണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","അവർ തങ്കംകൊണ്ട് നിലവിളക്കു നിർമിച്ചു. വിളക്കിന്റെ ചുവടും തണ്ടും പുഷ്പപുടങ്ങളും മൊട്ടുകളും പൂക്കളും ഒറ്റത്തണ്ടിൽത്തന്നെ അടിപ്പുപണിയായി ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","നിലവിളക്കിന്റെ ഒരു വശത്തുനിന്നു മൂന്നുശാഖ, മറ്റേവശത്തുനിന്നു മൂന്നുശാഖ, ഇങ്ങനെ ആറുശാഖകൾ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ഓരോശാഖയിലും ഓരോമൊട്ടും ഓരോപൂവുമായി ബദാംപുഷ്പംപോലെ മൂന്നു പുഷ്പപുടവും, അതുപോലെ അടുത്തശാഖയിലും ഉണ്ടായിരുന്നു; ഇങ്ങനെ വിളക്കിന്റെ ആറുശാഖയിലും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","നിലവിളക്കിൽ മൊട്ടുകളോടും പൂക്കളോടുംകൂടിയ ബദാംപൂക്കൾപോലുള്ള നാലു പുടങ്ങൾ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","നിലവിളക്കിൽനിന്നു നീണ്ടുനിൽക്കുന്ന ശാഖകളിൽ ഒന്നാമത്തെ ജോടിക്കുകീഴേ ഒരു മൊട്ട്, രണ്ടാമത്തെ ജോടിക്കുകീഴേ മറ്റൊരു മൊട്ട്, മൂന്നാമത്തെ ജോടിക്കുകീഴേ വേറൊരു മൊട്ട് എന്നിങ്ങനെ ആറു ശാഖയ്ക്കും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","മൊട്ടുകളും ശാഖകളും നിലവിളക്കിൽനിന്ന് ഒറ്റഖണ്ഡമെന്നവിധത്തിൽ തങ്കംകൊണ്ട് അടിപ്പുപണിയായി ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","അവർ അതിന്റെ ഏഴ് ദീപങ്ങളും അതു വെടിപ്പാക്കുന്നതിനുള്ള കത്രികകളും കരിന്തിരിപ്പാത്രങ്ങളും തങ്കംകൊണ്ടുണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","അവർ ഒരു താലന്തു തങ്കംകൊണ്ടു നിലവിളക്കും അതിനോടുചേർന്നുള്ള എല്ലാ ഉപകരണങ്ങളും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","അവർ ഖദിരമരംകൊണ്ട് ധൂപപീഠം ഉണ്ടാക്കി. അതു സമചതുരത്തിൽ ഒരുമുഴം നീളവും ഒരുമുഴം വീതിയുമുള്ളതും രണ്ടുമുഴം ഉയരമുള്ളതും ആയിരുന്നു. അതിന്റെ കൊമ്പുകൾ ധൂപപീഠത്തിൽനിന്ന് ഒരുഖണ്ഡമായിത്തന്നെ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","അവർ, അതിന്റെ മേൽഭാഗവും അതിന്റെ പാർശ്വങ്ങളും കൊമ്പുകളും തങ്കംകൊണ്ടു പൊതിഞ്ഞു; അതിനുചുറ്റും തങ്കംകൊണ്ട് ഒരു വക്കും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ധൂപപീഠം ചുമക്കേണ്ടതിനുള്ള തണ്ട് ഉറപ്പിക്കാൻ അതിന്റെ വക്കിനുതാഴേ രണ്ടുവശങ്ങളിലും ഈരണ്ടു തങ്കവളയങ്ങളും ഉറപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","അവർ ഖദിരമരംകൊണ്ടു തണ്ടുകൾ ഉണ്ടാക്കി. അതു തങ്കംകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","അവർ, സുഗന്ധതൈലക്കാരന്റെ യോഗവിധിപ്രകാരം വിശുദ്ധമായ അഭിഷേകതൈലവും ശുദ്ധമായ സുഗന്ധവർഗവും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ബെസലേൽ, ഖദിരമരംകൊണ്ടു മൂന്നുമുഴം ഉയരമുള്ള ഒരു ഹോമയാഗപീഠം ഉണ്ടാക്കി; അത് അഞ്ചുമുഴം നീളവും അഞ്ചുമുഴം വീതിയുമുള്ള സമചതുരമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","അവർ അതിന്റെ നാലു കോണുകളിലും ഓരോ കൊമ്പ് ഉണ്ടാക്കി; കൊമ്പുകൾ യാഗപീഠത്തിൽനിന്ന് ഒറ്റഖണ്ഡമായി ഉണ്ടാക്കിയിരുന്നു. അതു വെങ്കലംകൊണ്ട് പൊതിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","അതിന്റെ ഉപകരണങ്ങളൊക്കെയും—കലങ്ങൾ, ചട്ടുകങ്ങൾ, തളികകൾ, മുൾക്കരണ്ടികൾ, വറചട്ടികൾ എന്നിവ—വെങ്കലംകൊണ്ടുണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","അവർ യാഗപീഠത്തിനു വെങ്കലംകൊണ്ടു വലപ്പണിയായി ഒരു അരിപ്പ ഉണ്ടാക്കി; അതു യാഗപീഠത്തിന്റെ ചുറ്റുപടിക്കുതാഴേ അതിന്റെ പകുതിവരെ എത്തി. ");
INSERT INTO malc_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","വെങ്കലയരിപ്പയുടെ നാലു കോണുകളുടെയും അറ്റത്തു തണ്ടുചെലുത്താൻ വെങ്കലവളയം വാർത്തുണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","അവർ ഖദിരമരംകൊണ്ടു തണ്ടുകൾ ഉണ്ടാക്കി, അവ വെങ്കലംകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","യാഗപീഠം ചുമക്കേണ്ടതിന് അതിന്റെ വശങ്ങളിലുള്ള വളയങ്ങളിൽ അവർ തണ്ടുകൾ ഉറപ്പിച്ചു; അവർ യാഗപീഠം പലകകൾകൊണ്ടു പൊള്ളയായി ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","സമാഗമകൂടാരവാതിൽക്കൽ ശുശ്രൂഷ ചെയ്തുപോന്ന സ്ത്രീകളുടെ ദർപ്പണങ്ങൾ ഉപയോഗിച്ച്, അവർ വെങ്കലത്തൊട്ടിയും അതിന്റെ വെങ്കലക്കാലും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","പിന്നീട്, അവർ സമാഗമകൂടാരാങ്കണം ഉണ്ടാക്കി. തെക്കുവശത്തു നൂറുമുഴം നീളം ഉണ്ടായിരുന്നു. അവിടെ പിരിച്ച മൃദുലചണവസ്ത്രംകൊണ്ടുണ്ടാക്കിയ മറശ്ശീല തൂക്കിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","അതിന്, ഇരുപതു തൂണും അവയ്ക്ക് ഇരുപതു വെങ്കലച്ചുവടും, തൂണുകളിന്മേൽ വെള്ളിക്കൊളുത്തുകളും മേൽച്ചുറ്റുപടികളും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","വടക്കേവശത്തിനും നൂറുമുഴം നീളം ഉണ്ടായിരുന്നു. അതിന് ഇരുപതു തൂണും ഇരുപതു വെങ്കലച്ചുവടും, തൂണുകളിന്മേൽ വെള്ളിക്കൊളുത്തുകളും മേൽച്ചുറ്റുപടികളും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","പടിഞ്ഞാറുവശത്തിന് അൻപതുമുഴം വീതി ഉണ്ടായിരുന്നു. അവിടെയും മറശ്ശീല തൂക്കിയിരുന്നു. അതിനു, പത്തു തൂണുകളും പത്തു ചുവടുകളും തൂണുകളിന്മേൽ വെള്ളിക്കൊളുത്തുകളും മേൽച്ചുറ്റുപടികളും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","കിഴക്കു സൂര്യോദയഭാഗത്തിനും അൻപതുമുഴം വീതി ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","പ്രവേശനത്തിന്റെ ഒരുവശത്തു പതിനഞ്ചുമുഴം നീളമുള്ള മറശ്ശീലയും അവയ്ക്കു മൂന്നു ചുവടുകളോടുകൂടിയ മൂന്നു തൂണുകളും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","സമാഗമകൂടാരാങ്കണത്തിന്റെ പ്രവേശനത്തിന്റെ മറ്റേഭാഗത്തു പതിനഞ്ചുമുഴം നീളമുള്ള മറശ്ശീലയും, അതിനു മൂന്നു ചുവടുകളോടുകൂടിയ മൂന്നു തൂണുകളും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","അങ്കണത്തിന്റെ ചുറ്റും തൂക്കിയിരുന്ന മറശ്ശീല പിരിച്ച മൃദുലചണവസ്ത്രംകൊണ്ടുണ്ടാക്കിയതായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","തൂണുകളുടെ ചുവടുകൾ വെങ്കലംകൊണ്ടും കൊളുത്തുകളും മേൽച്ചുറ്റുപടികളും വെള്ളികൊണ്ടും ഉണ്ടാക്കിയിരുന്നു, തൂണുകളുടെ ചുവടുകൾ വെള്ളിപൊതിഞ്ഞവ ആയിരുന്നു. അങ്കണത്തിലെ തൂണുകൾക്കെല്ലാം വെള്ളികൊണ്ടുള്ള മേൽച്ചുറ്റുപടിയും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","സമാഗമകൂടാരാങ്കണത്തിന്റെ കവാടത്തിന് മറശ്ശീല നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽപ്പണി ചെയ്ത്, ഉണ്ടാക്കിയതായിരുന്നു. അതിന് ഇരുപതുമുഴം നീളവും, അങ്കണത്തിന്റെ മറശ്ശീലയുടെ വീതിക്കുസമമായി അഞ്ചുമുഴം ഉയരവും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","അതിനു നാലുതൂണും, നാലു വെങ്കലച്ചുവടുകളും ഉണ്ടായിരുന്നു. അതിന്റെ കൊളുത്തും മേൽച്ചുറ്റുപടിയും വെള്ളികൊണ്ടുണ്ടാക്കിയതും അതിന്റെ ചുവടുകൾ വെള്ളിപൊതിഞ്ഞതും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","സമാഗമകൂടാരത്തിനും കൂടാരാങ്കണത്തിനും ചുറ്റുമുള്ള കുറ്റികൾ എല്ലാം വെങ്കലംകൊണ്ടുള്ളവ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","മോശയുടെ കൽപ്പനയാൽ പുരോഹിതനായ അഹരോന്റെ പുത്രൻ ഈഥാമാരിന്റെ നിർദേശപ്രകാരം ലേവ്യർ രേഖപ്പെടുത്തിയ കണക്ക് അനുസരിച്ച്, ഉടമ്പടിയുടെ കൂടാരം എന്ന സമാഗമകൂടാരത്തിന് ഉപയോഗിച്ച സാധനസാമഗ്രികളുടെ ചെലവ്: ");
INSERT INTO malc_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","യെഹൂദാഗോത്രത്തിൽ ഹൂരിന്റെ മകനായ ഊരിയുടെ മകൻ ബെസലേൽ, യഹോവ മോശയോടു കൽപ്പിച്ചിരുന്നതെല്ലാം ചെയ്യുകയുണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ദാൻഗോത്രത്തിൽ അഹീസാമാക്കിന്റെ മകനും കൊത്തുപണിക്കാരനും ശില്പവിദഗ്ദ്ധനും നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, മൃദുലചണനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽപ്പണിചെയ്യുന്നവനുമായ ഒഹൊലീയാബ് അവനോടുകൂടെ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","വിശുദ്ധമന്ദിരത്തിന്റെ സകലപണികൾക്കുമായി വിശിഷ്ടയാഗാർപ്പണമായി ലഭിച്ചത്, വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം ആകെ 29 താലന്ത് 730 ശേക്കേൽ സ്വർണം ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ജനസംഖ്യയെടുപ്പിൽ എണ്ണപ്പെട്ടിരുന്നവരിൽനിന്നു ലഭിച്ചത് വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം 100 താലന്ത്, 1,775 ശേക്കേൽ വെള്ളി ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ഇരുപതു വയസ്സും അതിനു മുകളിലും പ്രായമുള്ളവരായി ജനസംഖ്യയെടുപ്പിൽ ഉൾപ്പെട്ട 6,03,550 പേരിൽ ഓരോരുത്തനും ഓരോ ബെക്കാ വീതം കൊടുക്കണമായിരുന്നു. വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം അത് അരശേക്കേൽ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","വിശുദ്ധമന്ദിരത്തിന്റെ 100 ചുവടുകളും മറശ്ശീലയുടെ ചുവടുകളും വാർക്കുന്നതിന്, ഒരു ചുവടിന് ഒരു താലന്തുവീതം 100 ചുവടിനു 100 താലന്തു വെള്ളി ചെലവായി. ");
INSERT INTO malc_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","തൂണുകൾക്കു കൊളുത്ത്, മേൽച്ചുറ്റുപടി ഇവ ഉണ്ടാക്കുന്നതിനും കുമിഴ് പൊതിയുന്നതിനും 1,775 ശേക്കേൽ വെള്ളി ഉപയോഗിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","വിശിഷ്ടയാഗാർപ്പണമായി ലഭിച്ച വെങ്കലം 70 താലന്ത് 2,400 ശേക്കേൽ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","സമാഗമകൂടാരത്തിന്റെ കവാടത്തിനുള്ള ചുവടുകളും വെങ്കലയാഗപീഠവും അതിന്റെ വെങ്കലജാലവും യാഗപീഠത്തിന്റെ എല്ലാ ഉപകരണങ്ങളും ");
INSERT INTO malc_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","സമാഗമകൂടാരാങ്കണത്തിന്റെ ചുറ്റുമുള്ള ചുവടുകളും അതിന്റെ കവാടത്തിനുള്ള ചുവടുകളും സമാഗമകൂടാരത്തിന്റെ കുറ്റികളും സമാഗമകൂടാരാങ്കണത്തിന്റെ കുറ്റികളും നിർമിക്കാൻ ആ വെങ്കലം ഉപയോഗിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷയ്ക്കായി നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ എന്നിവകൊണ്ടു നെയ്ത വിശേഷവസ്ത്രങ്ങൾ ഉണ്ടാക്കി; കൂടാതെ, യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ അവർ അഹരോനു വിശുദ്ധവസ്ത്രങ്ങളും ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ബെസലേൽ, തങ്കം, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ട് ഏഫോദ് ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","നെയ്ത്തുകാരന്റെ ചിത്രപ്പണിയായി നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, മൃദുലചണനൂൽ എന്നിവയുടെ ഇടയിൽ നെയ്തുചേർക്കേണ്ടതിന് അവർ തങ്കം അടിച്ചു നേരിയ തകിടാക്കി നൂലുകളായി മുറിച്ചെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ഏഫോദിന്റെ രണ്ടറ്റം തമ്മിൽ പിണച്ചുചേർക്കാവുന്നവിധത്തിൽ ചുമൽക്കണ്ടങ്ങൾ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","അതിന്മേലുള്ള ചിത്രപ്പണിയായ നടുക്കെട്ട്, യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ, ഏഫോദിൽനിന്നുതന്നെ ഉള്ളതായി തങ്കം, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ടുണ്ടാക്കിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ഇസ്രായേൽ പുത്രന്മാരുടെ പേരുകൾ രത്നശില്പി മുദ്ര നിർമിക്കുന്നതുപോലെ കൊത്തിയ ഗോമേദകക്കല്ലുകൾ അവർ തങ്കക്കസവുതടങ്ങളിൽ പതിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","യഹോവ മോശയോടു കൽപ്പിച്ചിരുന്നതുപോലെ, ഇസ്രായേൽ പുത്രന്മാരുടെ ഓർമക്കല്ലുകളായി അവ ഏഫോദിന്റെ ചുമൽക്കഷണങ്ങളിൽ പതിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","അവർ ഏഫോദിന്റെ വൈദഗ്ദ്ധ്യമാർന്ന ചിത്രപ്പണിപോലെ തങ്കം, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ എന്നിവകൊണ്ടു നിർണയപ്പതക്കം ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","അത് ഒരുചാൺ നീളവും ഒരുചാൺ വീതിയും ഉള്ള സമചതുരവും രണ്ടായി മടക്കാവുന്നതും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","അതിൽ നാലുനിര രത്നങ്ങൾ പതിച്ചു. ആദ്യനിരയിൽ ചെമന്നരത്നം, പീതരത്നം, മരതകം എന്നിവയും ");
INSERT INTO malc_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","രണ്ടാമത്തെ നിരയിൽ മാണിക്യം, ഇന്ദ്രനീലക്കല്ല്, വജ്രം എന്നിവയും ");
INSERT INTO malc_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","മൂന്നാമത്തെ നിരയിൽ പത്മരാഗം, വൈഡൂര്യം, സുഗന്ധിക്കല്ല് എന്നിവയും ");
INSERT INTO malc_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","നാലാമത്തെ നിരയിൽ പുഷ്യരാഗം, ഗോമേദകം, സൂര്യകാന്തം എന്നിവയും പതിക്കണം. അവ അതതു തങ്കക്കസവുതടങ്ങളിൽ പതിച്ചിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ഇസ്രായേൽ പുത്രന്മാരിൽ ഓരോരുത്തർക്കും ഓരോ കല്ലുവീതം പന്ത്രണ്ടു കല്ലുകൾ ഉണ്ടായിരുന്നു. പന്ത്രണ്ടു ഗോത്രങ്ങളിൽ ഓരോന്നിന്റെയും പേര് ഓരോ കല്ലിലും മുദ്രക്കൊത്തായി കൊത്തിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","നിർണയപ്പതക്കത്തിനു തങ്കംകൊണ്ടു മെടഞ്ഞ ചരടുപോലുള്ള മാലയുണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","തങ്കംകൊണ്ടു രണ്ടു കസവുതടവും രണ്ടു വളയവും ഉണ്ടാക്കി. രണ്ടു വളയവും നിർണയപ്പതക്കത്തിന്റെ രണ്ടറ്റത്തും പിടിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","തങ്കംകൊണ്ടുള്ള രണ്ടു മാല അവർ നിർണയപ്പതക്കത്തിന്റെ അറ്റങ്ങളിലുള്ള രണ്ടു വളയത്തിലും കൊളുത്തി. ");
INSERT INTO malc_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","മാലയുടെ മറ്റേ രണ്ടറ്റവും രണ്ടു തടത്തിൽ കൊളുത്തി ഏഫോദിന്റെ ചുമൽക്കഷണങ്ങളിൽ അതിന്റെ മുൻഭാഗവുമായി യോജിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","അവർ തങ്കംകൊണ്ട് വേറെ രണ്ടു വളയങ്ങൾ ഉണ്ടാക്കി. നിർണയപ്പതക്കത്തിന്റെ മറ്റേ രണ്ടറ്റത്തും ഏഫോദിന്റെ കീഴറ്റത്തിനുനേരേ അതിന്റെ വിളുമ്പിൽ അകത്തും പിടിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","അവർ തങ്കംകൊണ്ടു വേറെ രണ്ടു വളയങ്ങളും ഉണ്ടാക്കി, ഏഫോദിന്റെ മുൻഭാഗത്ത് ചുമൽക്കണ്ടത്തിന്റെ താഴേ അതിന്റെ ചേർപ്പിന്നരികെ ഏഫോദിന്റെ നടുക്കെട്ടിനു മേൽഭാഗത്തുവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","നിർണയപ്പതക്കം ഏഫോദിന്റെ മുകൾഭാഗത്തു വരുന്നതിനും ഏഫോദിൽനിന്ന് ഇളകിപ്പോകാതെ ഉറച്ചിരിക്കേണ്ടതിനും, യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ, നിർണയപ്പതക്കത്തിന്റെ വളയങ്ങളും ഏഫോദിന്റെ വളയങ്ങളും നീലച്ചരടുകൊണ്ട് അവർ ചേർത്തുകെട്ടി. ");
INSERT INTO malc_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","അവൻ ഏഫോദിന്റെ അങ്കിമുഴുവനും നീലത്തുണികൊണ്ട് നെയ്ത്തുപണിയായി ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","അങ്കിയുടെ നടുവിൽ തല കടക്കുന്നതിന് ഒരു ദ്വാരം ഉണ്ടാക്കി, ദ്വാരത്തിന്റെ വശം കീറിപ്പോകാതിരിക്കേണ്ടതിനു ദ്വാരത്തിന്റെ ചുറ്റിലും നാടയുംവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","അങ്കിയുടെ വിളുമ്പിൽ, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ, പിരിച്ച മൃദുലചണനൂൽ, എന്നിവകൊണ്ടു ചുറ്റും മാതളപ്പഴങ്ങളും ");
INSERT INTO malc_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","തങ്കംകൊണ്ടു മണികളും ഉണ്ടാക്കി; മണികൾ അങ്കിയുടെ വിളുമ്പിൽ മാതളപ്പഴങ്ങൾക്കിടയിൽ ചേർത്തുവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ, ശുശ്രൂഷയ്ക്കുള്ള അങ്കിയുടെ വിളുമ്പിൽ ചുറ്റും ഒരു മണിയും അതിനടുത്ത് ഒരു മാതളപ്പഴവും എന്നക്രമത്തിൽ ചേർത്തിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","അഹരോനും അവന്റെ പുത്രന്മാർക്കും മൃദുലചണവസ്ത്രംകൊണ്ടു നെയ്ത്തുപണിയായ അങ്കിയും ");
INSERT INTO malc_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","മൃദുലചണനൂൽകൊണ്ടു തലപ്പാവും മൃദുലചണനൂൽകൊണ്ടു ശിരോവസ്ത്രവും പിരിച്ച മൃദുലചണനൂൽകൊണ്ട് അടിവസ്ത്രവും ");
INSERT INTO malc_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","പിരിച്ച മൃദുലചണനൂൽ, നീലനൂൽ, ഊതനൂൽ, ചെമപ്പുനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽപ്പണിയായി അരക്കെട്ടും യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ ഉണ്ടാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","അവർ തങ്കംകൊണ്ടു വിശുദ്ധകിരീടമെന്ന നെറ്റിപ്പട്ടം ഉണ്ടാക്കി. അതിൽ മുദ്രക്കൊത്തായുള്ള ഒരു എഴുത്തു കൊത്തിയുണ്ടാക്കി: “യഹോവയ്ക്കു വിശുദ്ധം.” ");
INSERT INTO malc_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ, അതു തലപ്പാവിൽ കെട്ടേണ്ടതിന് അതിൽ നീലച്ചരടു കോർത്തുകെട്ടി. ");
INSERT INTO malc_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ഇങ്ങനെ, സമാഗമത്തിനുള്ള കൂടാരത്തിന്റെ പണിമുഴുവനും പൂർത്തിയായി; യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെതന്നെ ഇസ്രായേൽമക്കൾ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","അവർ സമാഗമകൂടാരം മോശയുടെ അടുക്കൽ കൊണ്ടുവന്നു: കൂടാരവും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും കൊളുത്തുകൾ, പലകകൾ, സാക്ഷകൾ, തൂണുകൾ, ചുവടുകൾ, ");
INSERT INTO malc_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ആട്ടുകൊറ്റന്റെ ചെമപ്പിച്ചതുകൽകൊണ്ടുള്ള പുറമൂടി, തഹശുതുകൽകൊണ്ടുള്ള പുറമൂടി, മറയുടെ തിരശ്ശീല, ");
INSERT INTO malc_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ഉടമ്പടിയുടെ പേടകം, അതിന്റെ തണ്ടുകൾ, പാപനിവാരണസ്ഥാനം; ");
INSERT INTO malc_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","മേശയും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും കാഴ്ചയപ്പവും ");
INSERT INTO malc_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","തങ്കംകൊണ്ടുള്ള വിളക്കുതണ്ടും അതിന്റെ നിരയിലെ ദീപങ്ങളും അതിന്റെ എല്ലാ ഉപകരണങ്ങളും, വിളക്കിനുള്ള എണ്ണ, ");
INSERT INTO malc_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","സ്വർണംകൊണ്ടുള്ള ധൂപപീഠം, അഭിഷേകതൈലം, സുഗന്ധധൂപവർഗം, കൂടാരത്തിലേക്കുള്ള പ്രവേശനവാതിലിന്റെ മറശ്ശീല, ");
INSERT INTO malc_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","വെങ്കലയാഗപീഠം, അതിന്റെ വെങ്കലജാലം, തണ്ടുകൾ, അതിന്റെ എല്ലാ ഉപകരണങ്ങളും, വെങ്കലത്തൊട്ടി അതിന്റെ കാൽ, ");
INSERT INTO malc_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","സമാഗമകൂടാരാങ്കണത്തിന്റെ മറശ്ശീലകൾ, അതിന്റെ തൂണുകൾ, ചുവടുകൾ, അങ്കണകവാടത്തിന്റെ മറശ്ശീല, കയറുകൾ, കൂടാരാങ്കണത്തിനുള്ള കുറ്റികൾ, സമാഗമത്തിനുള്ള കൂടാരത്തിന്റെ എല്ലാ ഉപകരണങ്ങളും, ");
INSERT INTO malc_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷയ്ക്കു നെയ്തെടുത്ത വിശേഷവസ്ത്രങ്ങൾ, പൗരോഹിത്യശുശ്രൂഷയ്ക്കായി ഉപയോഗിക്കുന്ന പുരോഹിതനായ അഹരോന്റെ വിശുദ്ധവസ്ത്രം, അവന്റെ പുത്രന്മാരുടെ വസ്ത്രങ്ങൾ എന്നിവതന്നെ. ");
INSERT INTO malc_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ഇങ്ങനെ, യഹോവ മോശയോടു കൽപ്പിച്ചിരുന്നതുപോലെ ഇസ്രായേൽമക്കൾ സകലപണിയും പൂർത്തിയാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","മോശ പണികൾ പരിശോധിച്ചു: യഹോവ കൽപ്പിച്ചതുപോലെതന്നെ അവർ അതു ചെയ്തിരിക്കുന്നു എന്നുകണ്ടു; മോശ അവരെ അനുഗ്രഹിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ഇതിനുശേഷം യഹോവ മോശയോട് ഇപ്രകാരം അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ഒന്നാംമാസം ഒന്നാംതീയതി, സമാഗമത്തിനുള്ള കൂടാരം നീ സ്ഥാപിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ഉടമ്പടിയുടെ പേടകം അതിനുള്ളിൽ വെക്കുകയും തിരശ്ശീലകൊണ്ടു മറയ്ക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","മേശ കൊണ്ടുവന്ന്, അതിന്റെമേൽ വെക്കേണ്ട സാധനങ്ങൾ ക്രമീകരിക്കണം. പിന്നീട്, നിലവിളക്കുകൊണ്ടുവന്ന് അതിന്റെ ദീപങ്ങൾ കത്തിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ഉടമ്പടിയുടെ പേടകത്തിനുമുമ്പിൽ തങ്കംകൊണ്ടുള്ള ധൂപപീഠം വെക്കുകയും സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ മറശ്ശീല തൂക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“സമാഗമത്തിനുള്ള കൂടാരത്തിന്റെ കവാടത്തിനു മുമ്പിൽ ഹോമയാഗപീഠം വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","സമാഗമകൂടാരത്തിനും യാഗപീഠത്തിനും മധ്യത്തിൽ തൊട്ടിവെച്ച് അതിൽ വെള്ളം ഒഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","അതിനുചുറ്റും സമാഗമകൂടാരാങ്കണം ക്രമീകരിച്ച് അങ്കണകവാടത്തിൽ മറശ്ശീല തൂക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“അഭിഷേകതൈലം എടുത്തു സമാഗമകൂടാരവും അതിലുള്ള സകലതും അഭിഷേകംചെയ്ത് അതിന്റെ സകല ഉപകരണങ്ങളെയും ശുദ്ധീകരിക്കണം; അവ വിശുദ്ധമായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ഹോമയാഗപീഠവും അതിന്റെ സകല ഉപകരണങ്ങളും അഭിഷേകംചെയ്ത് യാഗപീഠത്തെ ശുദ്ധീകരിക്കണം. യാഗപീഠം അതിവിശുദ്ധമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","തൊട്ടിയും അതിന്റെ കാലും അഭിഷേകംചെയ്തു ശുദ്ധീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“അഹരോനെയും അവന്റെ പുത്രന്മാരെയും സമാഗമകൂടാരവാതിൽക്കൽ കൊണ്ടുവന്ന് അവരെ വെള്ളംകൊണ്ടു കഴുകണം. ");
INSERT INTO malc_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","പിന്നീട് അഹരോനെ വിശുദ്ധവസ്ത്രങ്ങൾ ധരിപ്പിച്ച്, എനിക്ക് പൗരോഹിത്യശുശ്രൂഷ ചെയ്യേണ്ടതിന് അവനെ അഭിഷേകംചെയ്തു ശുദ്ധീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","അവന്റെ പുത്രന്മാരെ വരുത്തി അങ്കി ധരിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","അവരുടെ പിതാവിനെ അഭിഷേകം ചെയ്തതുപോലെ, അവർ എനിക്കു പൗരോഹിത്യശുശ്രൂഷ ചെയ്യേണ്ടതിന് അവരെയും അഭിഷേകംചെയ്യണം. അവരുടെ അഭിഷേകം തലമുറതലമുറയായി പൗരോഹിത്യത്തിനുള്ള അഭിഷേകം ആയിരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","യഹോവ കൽപ്പിച്ചതുപോലെ സകലതും മോശ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ഇങ്ങനെ, രണ്ടാംവർഷത്തിന്റെ ഒന്നാംമാസം ഒന്നാംതീയതി സമാഗമകൂടാരം സ്ഥാപിക്കപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","മോശ സമാഗമകൂടാരം സ്ഥാപിച്ചു, ചുവടുകൾ ഉറപ്പിച്ചു, പലകകൾ നിർത്തി, സാക്ഷകൾ ഉറപ്പിച്ചു, തൂണുകൾ നാട്ടി. ");
INSERT INTO malc_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ഇതിനുശേഷം യഹോവ തന്നോടു കൽപ്പിച്ചതുപോലെ അദ്ദേഹം മൂടുവിരി സമാഗമകൂടാരത്തിന്മേൽ വിരിച്ചു, അതിന്മീതേ പുറമൂടിയും വിരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","അദ്ദേഹം ഉടമ്പടിയുടെ പലക എടുത്തു പേടകത്തിൽവെച്ചു. പേടകത്തിനു തണ്ടുറപ്പിച്ചു, പേടകത്തിനുമീതേ പാപനിവാരണസ്ഥാനം വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","പിന്നീട് അദ്ദേഹം പേടകം സമാഗമകൂടാരത്തിൽ കൊണ്ടുവന്നു; യഹോവ തന്നോടു കൽപ്പിച്ചതുപോലെ മറയ്ക്കാനുള്ള തിരശ്ശീലതൂക്കി ഉടമ്പടിയുടെ പേടകം മറച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","മോശ, സമാഗമത്തിനുള്ള കൂടാരത്തിന്റെ വടക്കുവശത്തു തിരശ്ശീലയ്ക്കു പുറത്തു മേശ വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","യഹോവ തന്നോടു കൽപ്പിച്ചിരുന്നതുപോലെ, മേശയുടെമേൽ യഹോവയുടെമുമ്പാകെ അപ്പം അടുക്കിവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","സമാഗമത്തിനുള്ള കൂടാരത്തിന്റെ തെക്കുഭാഗത്തായി മേശയ്ക്കുനേരേ അദ്ദേഹം നിലവിളക്കു വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","യഹോവ തന്നോടു കൽപ്പിച്ചിരുന്നതുപോലെ അദ്ദേഹം യഹോവയുടെമുമ്പിൽ ദീപങ്ങൾ കത്തിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","മോശ സമാഗമകൂടാരത്തിൽ തിരശ്ശീലയുടെ മുൻഭാഗത്തു തങ്കംകൊണ്ടുള്ള ധൂപപീഠം വെക്കുകയും ");
INSERT INTO malc_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","യഹോവ കൽപ്പിച്ചിരുന്നതുപോലെ, അതിന്മേൽ സുഗന്ധധൂപവർഗം പുകയ്ക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","പിന്നീട് അദ്ദേഹം, സമാഗമകൂടാരത്തിന്റെ കവാടത്തിനുള്ള മറശ്ശീല തൂക്കി; ");
INSERT INTO malc_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","സമാഗമത്തിനുള്ള കൂടാരവാതിലിനു മുൻവശത്തു ഹോമയാഗപീഠം വെച്ചു. യഹോവ കൽപ്പിച്ചിരുന്നതുപോലെ അതിന്മേൽ ഹോമയാഗങ്ങളും ഭോജനയാഗങ്ങളും അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","അദ്ദേഹം സമാഗമകൂടാരത്തിനും യാഗപീഠത്തിനും മധ്യത്തിൽ തൊട്ടിവെക്കുകയും കഴുകേണ്ടതിന് അതിൽ വെള്ളമൊഴിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","മോശയും അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാരും അതിൽ തങ്ങളുടെ കൈകാലുകൾ കഴുകി. ");
INSERT INTO malc_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","യഹോവ മോശയോടു കൽപ്പിച്ചിരുന്നതുപോലെ, അവർ സമാഗമകൂടാരത്തിൽ പ്രവേശിക്കുമ്പോഴും യാഗപീഠത്തിലേക്കു ചെല്ലുമ്പോഴും കൈകാലുകൾ കഴുകിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","പിന്നീടു മോശ സമാഗമകൂടാരത്തിനും യാഗപീഠത്തിനുംചുറ്റും കൂടാരാങ്കണം ക്രമീകരിച്ചു; അങ്കണകവാടത്തിന്റെ മറശ്ശീല തൂക്കി; ഇങ്ങനെ മോശ ആ വേല പൂർത്തിയാക്കി. ");
INSERT INTO malc_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","അപ്പോൾ മേഘം സമാഗമകൂടാരത്തെ മൂടി, യഹോവയുടെ തേജസ്സു സമാഗമത്തിനുള്ള കൂടാരത്തിൽ നിറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","മേഘം സമാഗമകൂടാരത്തിന്മേൽ വസിക്കയും യഹോവയുടെ തേജസ്സു സമാഗമത്തിനുള്ള കൂടാരത്തിൽ നിറയുകയും ചെയ്തതുകൊണ്ട്, മോശയ്ക്കു സമാഗമകൂടാരത്തിനകത്തു പ്രവേശിക്കാൻ കഴിഞ്ഞില്ല. ");
INSERT INTO malc_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","തങ്ങളുടെ സകലപ്രയാണങ്ങളിലും സമാഗമകൂടാരത്തിനു മുകളിൽനിന്ന് മേഘം ഉയരുമ്പോഴൊക്കെയും ഇസ്രായേല്യർ യാത്രപുറപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","എന്നാൽ, മേഘം ഉയരാത്തപക്ഷം അതുയരുന്ന ദിവസംവരെ അവർ യാത്രപുറപ്പെടാതിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ഇസ്രായേൽമക്കളുടെ സകലപ്രയാണങ്ങളിലും എല്ലാ ഇസ്രായേല്യരും കാൺകെ, പകൽസമയത്തു സമാഗമകൂടാരത്തിന്മേൽ യഹോവയുടെ മേഘവും രാത്രിസമയത്ത് അഗ്നിയും ഉണ്ടായിരുന്നു.");
INSERT INTO malc_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","യഹോവ സമാഗമകൂടാരത്തിൽനിന്ന് മോശയെ വിളിച്ച് ഇപ്രകാരം അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ഇസ്രായേൽമക്കളോടു സംസാരിച്ച് അവരോട് ഇപ്രകാരം പറയുക: നിങ്ങളിൽ ആരെങ്കിലും യഹോവയ്ക്ക് ഒരു വഴിപാട് കൊണ്ടുവരുമ്പോൾ കന്നുകാലിക്കൂട്ടത്തിലോ ആട്ടിൻപറ്റത്തിലോനിന്നും ഒരു മൃഗത്തെ നിങ്ങളുടെ വഴിപാടായി കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘കന്നുകാലികളിൽ ഒന്നിനെ വഴിപാടായി അർപ്പിക്കുന്നെങ്കിൽ, അയാൾ ഊനമില്ലാത്ത ആണിനെ ഹോമയാഗമായി അർപ്പിക്കണം. അതു യഹോവയ്ക്കു സ്വീകാര്യമായിരിക്കാൻ അയാൾ അതിനെ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽവെച്ച് അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","അയാൾ ഹോമയാഗത്തിനുള്ള മൃഗത്തിന്റെ തലയിൽ കൈവെക്കണം; അത് അയാൾക്കുവേണ്ടി പാപപരിഹാരമായി സ്വീകരിക്കപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","യഹോവയുടെ സന്നിധിയിൽ അയാൾ കാളക്കിടാവിനെ അറക്കണം; അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാർ അതിന്റെ രക്തം സമാഗമകൂടാരത്തിന്റെ കവാടത്തിലുള്ള യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ഇതിനുശേഷം അയാൾ ഹോമയാഗമൃഗത്തെ തുകലുരിച്ചു കഷണങ്ങളായി മുറിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","പുരോഹിതനായ അഹരോന്റെ പുത്രന്മാർ യാഗപീഠത്തിൽ തീകൊളുത്തി അതിന്മേൽ വിറകടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","പിന്നെ അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാർ തലയും മേദസ്സുമുൾപ്പെടെ കഷണങ്ങൾ യാഗപീഠത്തിൽ കത്തുന്ന വിറകിനുമീതേ അടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ആന്തരികാവയവങ്ങളും കാലും അയാൾ വെള്ളത്തിൽ കഴുകണം. പുരോഹിതൻ എല്ലാ ഭാഗവും യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം. അതു യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘വഴിപാട് ആട്ടിൻപറ്റത്തിലെ ചെമ്മരിയാടോ കോലാടോ ആകുന്നെങ്കിൽ, ഊനമില്ലാത്ത ആണിനെ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","അയാൾ യാഗപീഠത്തിന്റെ വടക്കുവശത്തു യഹോവയുടെ സന്നിധിയിൽ അതിനെ അറക്കണം, അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാർ അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ഇതിനുശേഷം അയാൾ അതിനെ കഷണങ്ങളായി മുറിക്കണം. പുരോഹിതൻ തലയും മേദസ്സുമുൾപ്പെടെ അവയെ യാഗപീഠത്തിൽ കത്തുന്ന വിറകിനുമീതേ അടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ആന്തരികാവയവങ്ങളും കാലും അയാൾ വെള്ളത്തിൽ കഴുകണം. പുരോഹിതൻ എല്ലാം ഹോമയാഗമായി യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം. അതു യഹോവയ്ക്ക് ഹൃദ്യസുഗന്ധമായ ദഹനയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘യഹോവയ്ക്കുള്ള വഴിപാടായി പക്ഷിയെയാണ് ഹോമയാഗം അർപ്പിക്കുന്നതെങ്കിൽ അയാൾ ഒരു കുറുപ്രാവിനെയോ ഒരു പ്രാവിൻകുഞ്ഞിനെയോ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","പുരോഹിതൻ അതിനെ യാഗപീഠത്തിൽ കൊണ്ടുവന്നു തല പിരിച്ചുപറിച്ച് യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം. അതിന്റെ രക്തം യാഗപീഠത്തിന്റെ പാർശ്വത്തിൽ ഒഴിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","അയാൾ അതിന്റെ അന്നസഞ്ചി പപ്പുംചേർത്തു പറിച്ചെടുത്തു യാഗപീഠത്തിന്റെ അരികെ കിഴക്കുവശത്തു ചാരം ഇടുന്ന സ്ഥലത്തു കളയണം. ");
INSERT INTO malc_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","അയാൾ അതിനെ പൂർണമായി വേർപെടുത്താതെ ചിറകുകളോടുകൂടെ പിളർക്കണം. പിന്നെ പുരോഹിതൻ അതിനെ യാഗപീഠത്തിൽ എരിഞ്ഞുകൊണ്ടിരിക്കുന്ന വിറകിനുമീതേ ഹോമയാഗമായി ദഹിപ്പിക്കണം. അതു യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘ഒരാൾ യഹോവയ്ക്ക് ഒരു ഭോജനയാഗം അർപ്പിക്കുമ്പോൾ അയാളുടെ വഴിപാട് നേരിയമാവ് ആയിരിക്കണം. അയാൾ അതിന്മേൽ ഒലിവെണ്ണ ഒഴിക്കുകയും കുന്തിരിക്കം ഇടുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","അത് അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാരുടെ അടുക്കൽ കൊണ്ടുവരണം. പുരോഹിതൻ ഒരുപിടി നേരിയമാവും എണ്ണയും, കുന്തിരിക്കം മുഴുവനും എടുത്ത്, അത് ഒരു സ്മാരകഭാഗമായി യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം. അതു യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ഭോജനയാഗത്തിൽ അവശേഷിക്കുന്ന ധാന്യം അഹരോനും പുത്രന്മാർക്കും ഉള്ളതാണ്. യഹോവയ്ക്ക് അർപ്പിക്കുന്ന ദഹനയാഗങ്ങളിൽ അത് ഏറ്റവും വിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘അടുപ്പിൽ ചുട്ട ഭോജനയാഗമാണ് നിങ്ങൾ അർപ്പിക്കുന്നതെങ്കിൽ, അതു പുളിപ്പിക്കാത്ത നേരിയമാവുകൊണ്ടുള്ളതാകണം; ഒലിവെണ്ണചേർത്ത പുളിപ്പില്ലാത്ത ദോശയോ പുളിപ്പിക്കാതെ ഒലിവെണ്ണ പുരട്ടിയുണ്ടാക്കിയ വടകളോ ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","നിങ്ങളുടെ ഭോജനയാഗം അപ്പച്ചട്ടിയിൽ ചുട്ടതാണെങ്കിൽ നേരിയമാവ് പുളിപ്പിക്കാതെ എണ്ണചേർത്ത് ഉണ്ടാക്കിയതായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","അതു കഷണങ്ങളായി മുറിച്ച് അതിന്മേൽ എണ്ണ ഒഴിക്കണം; അതു ഭോജനയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","നിങ്ങളുടെ ഭോജനയാഗം ഉരുളിയിൽ പാകംചെയ്തതാണെങ്കിൽ, അതു നേരിയമാവും ഒലിവെണ്ണയും ചേർത്തുണ്ടാക്കിയതായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ഇവകൊണ്ടുണ്ടാക്കിയ ഭോജനയാഗം യഹോവയ്ക്ക് അർപ്പിക്കണം; അതു പുരോഹിതനെ ഏൽപ്പിക്കണം; അദ്ദേഹം അതു യാഗപീഠത്തിൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","അദ്ദേഹം ഭോജനയാഗത്തിൽനിന്ന് സ്മാരകഭാഗം എടുത്തു യാഗപീഠത്തിൽ യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗമായി ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ഭോജനയാഗത്തിൽ അവശേഷിക്കുന്ന ധാന്യം അഹരോനും പുത്രന്മാർക്കും ഉള്ളതാണ്. യഹോവയ്ക്ക് അർപ്പിക്കുന്ന ദഹനയാഗങ്ങളിൽ ഇത് അതിവിശുദ്ധം. ");
INSERT INTO malc_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘യഹോവയ്ക്കു നിങ്ങൾ അർപ്പിക്കുന്ന ഭോജനയാഗങ്ങളിലൊന്നിനും പുളിപ്പുണ്ടായിരിക്കരുത്; പുളിച്ച മാവോ തേനോ ഭോജനയാഗമായി അർപ്പിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","നിങ്ങൾ അവയെ ആദ്യഫലവഴിപാടായി യഹോവയ്ക്ക് അർപ്പിക്കാം. പക്ഷേ, അവയെ ഹൃദ്യസുഗന്ധമായി യാഗപീഠത്തിൽ അർപ്പിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","നിങ്ങളുടെ എല്ലാ ഭോജനയാഗത്തിനും ഉപ്പുകൊണ്ടു രുചി വരുത്തണം. നിങ്ങളുടെ ദൈവവുമായുള്ള ഉടമ്പടിയുടെ ഉപ്പു ഭോജനയാഗങ്ങളിൽനിന്നും ഒഴിവാക്കരുത്. നിങ്ങളുടെ എല്ലാ വഴിപാടുകളിലും ഉപ്പുചേർക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘നിങ്ങളുടെ ആദ്യഫലത്തിൽനിന്നും യഹോവയ്ക്ക് ഭോജനയാഗം അർപ്പിക്കുന്നെങ്കിൽ, പുതിയ കതിരുതിർത്ത മണികൾ തീയിൽ ചുട്ട്, അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","അതിന്മേൽ എണ്ണയും കുന്തിരിക്കവും ഇടണം; അത് ഒരു ഭോജനയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ഉതിർത്ത ധാന്യമണിയുടെയും എണ്ണയുടെയും ഓരോഭാഗവും മുഴുവൻ കുന്തിരിക്കവും പുരോഹിതൻ യഹോവയ്ക്ക് ഒരു സ്മാരകഭാഗമായി ദഹിപ്പിക്കണം; അത് യഹോവയ്ക്കു ഒരു ദഹനയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘ഒരാളുടെ വഴിപാട് സമാധാനയാഗമാണെങ്കിൽ, കന്നുകാലികളിൽ ഒന്നിനെ അർപ്പിക്കുമ്പോൾ, ആണായാലും പെണ്ണായാലും ഊനമില്ലാത്തതിനെ യഹോവയുടെ സന്നിധിയിൽ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","അയാൾ തന്റെ വഴിപാടുമൃഗത്തിന്റെ തലയിൽ കൈവെക്കുകയും സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ അതിനെ അറക്കുകയും ചെയ്യണം. അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാർ അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","സമാധാനയാഗത്തിൽനിന്ന്, അതിന്റെ ആന്തരികാവയവങ്ങളെ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും അതിനോടുചേർന്നുള്ള സകലമേദസ്സും ");
INSERT INTO malc_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","വൃക്കകൾ രണ്ടും അവയുടെമേൽ ഇടുപ്പിനടുത്തുള്ള മേദസ്സും വൃക്കകളോടൊപ്പം മാറ്റുന്ന കരളിന്മേലുള്ള കൊഴുപ്പും അയാൾ യഹോവയ്ക്ക് ദഹനയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","അഹരോന്റെ പുത്രന്മാർ, യാഗപീഠത്തിൽ കത്തുന്ന വിറകിന്മേലുള്ള ഹോമയാഗത്തിനുമീതേ അത് ദഹിപ്പിക്കണം. അത് യഹോവയ്ക്ക് ഹൃദ്യസുഗന്ധമായ ദഹനയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘ഒരാൾ ആട്ടിൻപറ്റത്തിൽനിന്ന് ഒന്നിനെ യഹോവയ്ക്ക് സമാധാനയാഗമായി അർപ്പിക്കുന്നെങ്കിൽ, അയാൾ ഊനമില്ലാത്ത ഒരു ആണിനെയോ പെണ്ണിനെയോ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ഒരു കുഞ്ഞാടിനെ അർപ്പിക്കുന്നെങ്കിൽ യഹോവയുടെ സന്നിധിയിൽ അതിനെ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","അയാൾ തന്റെ വഴിപാടുമൃഗത്തിന്റെ തലയിൽ കൈവെക്കുകയും സമാഗമകൂടാരത്തിന്റെമുമ്പിൽ അതിനെ അറക്കുകയും വേണം. അഹരോന്റെ പുത്രന്മാർ അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ, ചുറ്റും തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","അയാൾ സമാധാനയാഗത്തിൽനിന്ന്, അതിന്റെ മേദസ്സും നട്ടെല്ലിനോടുചേർത്തു വെട്ടിയെടുത്ത തടിച്ച വാലും ആന്തരികാവയവങ്ങളെ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും അതിനോടുചേർന്നുള്ള സകലമേദസ്സും ");
INSERT INTO malc_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","വൃക്കകൾ രണ്ടും അവയുടെമേൽ അരക്കെട്ടിനടുത്തുള്ള മേദസ്സും വൃക്കകളോടൊപ്പം മാറ്റുന്ന കരളിന്മേലുള്ള കൊഴുപ്പും നീക്കംചെയ്ത് യഹോവയ്ക്കു ദഹനയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","പുരോഹിതൻ അതു യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം; അത് യഹോവയ്ക്ക് ദഹനയാഗമാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘അയാളുടെ വഴിപാട് ഒരു കോലാടാണെങ്കിൽ, അയാൾ അത് യഹോവയുടെമുമ്പാകെ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","അയാൾ അതിന്റെ തലയിൽ കൈവെക്കുകയും സമാഗമകൂടാരത്തിന്റെമുമ്പിൽ അറക്കുകയും വേണം, അഹരോന്റെ പുത്രന്മാർ അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","അയാൾ അർപ്പിക്കുന്നതിൽനിന്ന് അതിന്റെ ആന്തരികാവയവങ്ങളെ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും അതിനോടുചേർന്നുള്ള സകലമേദസ്സും ");
INSERT INTO malc_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","വൃക്കകൾ രണ്ടും അവയുടെമേൽ അരക്കെട്ടിനടുത്തുള്ള മേദസ്സും വൃക്കകളോടൊപ്പം മാറ്റുന്ന കരളിന്മേലുള്ള കൊഴുപ്പും നീക്കംചെയ്ത് അയാൾ യഹോവയ്ക്കു ദഹനയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","പുരോഹിതൻ യാഗപീഠത്തിൽ ഹൃദ്യസുഗന്ധമായ ദഹനയാഗമായി അവയെ ദഹിപ്പിക്കണം. മേദസ്സെല്ലാം യഹോവയ്ക്കുള്ളതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘നിങ്ങൾ മേദസ്സും രക്തവും ഭക്ഷിക്കരുത്; ഇത്, നിങ്ങൾ എവിടെ താമസിച്ചാലും നിങ്ങൾക്കു തലമുറതലമുറയായി എന്നെന്നേക്കുമുള്ള നിയമം ആയിരിക്കണം.’ ” ");
INSERT INTO malc_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","യഹോവ വീണ്ടും മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ഇസ്രായേൽമക്കളോടു പറയുക: ‘ആരെങ്കിലും മനഃപൂർവമല്ലാതെ പാപംചെയ്തു യഹോവയുടെ കൽപ്പനയിൽ ചെയ്യരുതെന്നു വിലക്കിയിട്ടുള്ള ഏതെങ്കിലും ലംഘിച്ചാൽ— ");
INSERT INTO malc_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘മഹാപുരോഹിതൻ സകലജനത്തിന്മേലും കുറ്റം വരത്തക്കവിധം പാപംചെയ്യുന്നെങ്കിൽ, താൻ ചെയ്ത പാപംനിമിത്തം യഹോവയ്ക്ക് ഊനമില്ലാത്ത ഒരു കാളക്കിടാവിനെ പാപശുദ്ധീകരണയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","അദ്ദേഹം ആ കാളയെ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ യഹോവയുടെമുമ്പാകെ കൊണ്ടുവരണം. അദ്ദേഹം അതിന്റെ തലയിൽ കൈവെക്കുകയും യഹോവയുടെമുമ്പാകെ അതിനെ അറക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ഇതിനുശേഷം മഹാപുരോഹിതൻ കാളക്കിടാവിന്റെ കുറെ രക്തം എടുത്തു സമാഗമകൂടാരത്തിനകത്തു കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","അദ്ദേഹം രക്തത്തിൽ വിരൽ മുക്കി വിശുദ്ധമന്ദിരത്തിന്റെ തിരശ്ശീലയ്ക്കുമുമ്പിൽ യഹോവയുടെ സന്നിധിയിൽ ഏഴുപ്രാവശ്യം തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","പുരോഹിതൻ പിന്നെ കുറെ രക്തം യഹോവയുടെ സന്നിധിയിൽ സമാഗമകൂടാരത്തിലുള്ള സുഗന്ധധൂപപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടണം. അദ്ദേഹം കാളയുടെ ശേഷിച്ചരക്തം സമാഗമകൂടാരത്തിന്റെ കവാടത്തിലുള്ള ഹോമയാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","പാപശുദ്ധീകരണയാഗമായ കാളയുടെ മേദസ്സു മുഴുവനും—അതിന്റെ ആന്തരികാവയവങ്ങളെ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സു മുഴുവനും, ");
INSERT INTO malc_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","വൃക്കകൾ രണ്ടും അവയുടെമേൽ അരക്കെട്ടിനടുത്തുള്ള മേദസ്സും വൃക്കകളോടൊപ്പം മാറ്റുന്ന കരളിന്മേലുള്ള കൊഴുപ്പും അദ്ദേഹം നീക്കംചെയ്യണം— ");
INSERT INTO malc_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","സമാധാനയാഗമായി അർപ്പിച്ച കാളയുടെ മേദസ്സു നീക്കിയതുപോലെതന്നെ നീക്കണം. ഇതിനുശേഷം പുരോഹിതൻ അവയെ ഹോമയാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","എന്നാൽ കാളയുടെ തുകലും അതിന്റെ മാംസം മുഴുവനും തലയും കാലുകളും ആന്തരികാവയവങ്ങളും ചാണകവും ");
INSERT INTO malc_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ഇങ്ങനെ കാളയുടെ ബാക്കിഭാഗം മുഴുവനും അദ്ദേഹം പാളയത്തിനുപുറത്തു കൊണ്ടുപോയി ചാരം ഇടുന്ന, വെടിപ്പുള്ള ഒരു സ്ഥലത്ത് ചാരത്തിന്മേൽവെച്ച് വിറകിനു തീയിട്ടു ചുട്ടുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘ഇസ്രായേൽസഭ മുഴുവൻ മനഃപൂർവമല്ലാതെ പാപംചെയ്ത് യഹോവ ചെയ്യരുതെന്നു വിലക്കിയിട്ടുള്ള കൽപ്പനകൾ ഏതെങ്കിലും ലംഘിച്ചാലും ആ സംഗതി സഭ അറിയാതിരുന്നാലും അവർ കുറ്റക്കാരാണ്. ");
INSERT INTO malc_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","അവർ ചെയ്ത പാപം അവർ അറിയുമ്പോൾ സഭ ഒരു കാളക്കിടാവിനെ പാപശുദ്ധീകരണയാഗമായി സമാഗമകൂടാരത്തിനുമുമ്പിൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ഇസ്രായേല്യ തലവന്മാർ യഹോവയുടെ സന്നിധിയിൽ കാളയുടെ തലമേൽ അവരുടെ കൈവെക്കണം; യഹോവയുടെ സന്നിധിയിൽ കാളയെ അറക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","എന്നിട്ട് മഹാപുരോഹിതൻ കാളയുടെ കുറെ രക്തം സമാഗമകൂടാരത്തിൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","പുരോഹിതൻ വിരൽ രക്തത്തിൽ മുക്കി യഹോവയുടെ സന്നിധിയിൽ തിരശ്ശീലയ്ക്കുമുമ്പിൽ ഏഴുപ്രാവശ്യം തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","അദ്ദേഹം സമാഗമകൂടാരത്തിൽ യഹോവയുടെ സന്നിധിയിലുള്ള യാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ കുറെ രക്തം പുരട്ടണം. ശേഷിച്ചരക്തം മുഴുവനും സമാഗമകൂടാരത്തിന്റെ കവാടത്തിലുള്ള ഹോമയാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","അദ്ദേഹം അതിന്റെ മേദസ്സു മുഴുവനും അതിൽനിന്നും എടുത്തു യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","പാപശുദ്ധീകരണയാഗത്തിനുള്ള കാളയെക്കൊണ്ടു ചെയ്തതുപോലെതന്നെ അദ്ദേഹം ഈ കാളയെക്കൊണ്ടും ചെയ്യണം. ഈ വിധത്തിൽ പുരോഹിതൻ അവർക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കണം; എന്നാൽ അത് അവരോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","പിന്നീട് അദ്ദേഹം കാളയെ പാളയത്തിനുപുറത്തു കൊണ്ടുപോയി ആദ്യത്തെ കാളയെ ചുട്ടുകളഞ്ഞതുപോലെ അതിനെയും ചുട്ടുകളയണം. ഇതു സഭയ്ക്കുവേണ്ടിയുള്ള പാപശുദ്ധീകരണയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘ഒരു പ്രമാണി മനഃപൂർവമല്ലാതെ പാപംചെയ്ത്, തന്റെ ദൈവമായ യഹോവയുടെ കൽപ്പനയിൽ ചെയ്യരുതെന്നു വിലക്കിയിട്ടുള്ള ഏതെങ്കിലും കൽപ്പന ലംഘിച്ചാൽ അവൻ കുറ്റക്കാരനാണ്. ");
INSERT INTO malc_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","അവനു താൻ ചെയ്ത പാപം ബോധ്യമായെങ്കിൽ അവൻ ഊനമില്ലാത്ത ഒരു ആൺകോലാടിനെ വഴിപാടായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","അവൻ ആ കോലാടിന്റെ തലയിൽ കൈവെച്ചു ഹോമയാഗമൃഗത്തെ അറക്കുന്ന സ്ഥലത്ത് യഹോവയുടെമുമ്പാകെ അതിനെ അറക്കണം. അത് ഒരു പാപശുദ്ധീകരണയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","അതിനുശേഷം പുരോഹിതൻ വിരൽകൊണ്ട് കുറെ പാപശുദ്ധീകരണയാഗരക്തം എടുത്തു ഹോമയാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടണം; ശേഷിച്ചരക്തം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","അയാൾ മേദസ്സു മുഴുവനും സമാധാനയാഗത്തിന്റെ മേദസ്സുപോലെ യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം. ഈ വിധം പുരോഹിതൻ ആ മനുഷ്യന്റെ പാപത്തിനുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കണം, എന്നാൽ അത് അവനോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘ദേശത്തിലെ ജനത്തിൽ ആരെങ്കിലും മനഃപൂർവമല്ലാതെ പാപംചെയ്ത്, യഹോവയുടെ കൽപ്പനയിൽ ചെയ്യരുതെന്നു വിലക്കിയിട്ടുള്ള ഏതെങ്കിലും കൽപ്പന ലംഘിച്ചാൽ ആ മനുഷ്യൻ കുറ്റക്കാരനാണ്. ");
INSERT INTO malc_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","അയാൾക്ക് താൻ ചെയ്ത പാപം ബോധ്യപ്പെടുമ്പോൾ, ചെയ്ത പാപംനിമിത്തം ഊനമില്ലാത്ത ഒരു പെൺകോലാടിനെ വഴിപാടായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","അയാൾ പാപശുദ്ധീകരണയാഗത്തിന്റെ തലയിൽ കൈവെച്ചു ഹോമയാഗസ്ഥലത്ത് അതിനെ അറക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","അതിനുശേഷം പുരോഹിതൻ വിരൽകൊണ്ട് അതിന്റെ കുറെ രക്തം എടുത്തു ഹോമയാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടണം, ശേഷിച്ചരക്തം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","പുരോഹിതൻ സമാധാനയാഗത്തിൽനിന്നുള്ള മേദസ്സു നീക്കംചെയ്തതുപോലെ മേദസ്സു മുഴുവനും നീക്കംചെയ്ത് യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായി അതിനെ യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം. ഇങ്ങനെ പുരോഹിതൻ ആ വ്യക്തിക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കണം, എന്നാൽ അത് അയാളോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘ആരെങ്കിലും പാപശുദ്ധീകരണയാഗമായി ഒരു ആട്ടിൻകുട്ടിയെയാണ് അർപ്പിക്കുന്നതെങ്കിൽ ഊനമില്ലാത്ത പെണ്ണാടിനെ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","അയാൾ തന്റെ കൈ അതിന്റെ തലയിൽവെച്ച്, ഹോമയാഗമൃഗത്തെ അറക്കുന്ന സ്ഥലത്ത് പാപശുദ്ധീകരണയാഗത്തിനായി അറക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","അതിനുശേഷം പുരോഹിതൻ വിരൽകൊണ്ട് പാപശുദ്ധീകരണയാഗത്തിന്റെ കുറെ രക്തം എടുത്ത് ഹോമയാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടണം. ശേഷിച്ചരക്തം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","സമാധാനയാഗത്തിൽ ആട്ടിൻകുട്ടിയുടെ മേദസ്സു നീക്കംചെയ്തതുപോലെ അയാൾ മേദസ്സു മുഴുവൻ നീക്കണം. പുരോഹിതൻ യാഗപീഠത്തിൽ യഹോവയ്ക്ക് അർപ്പിക്കുന്ന ദഹനയാഗമെന്നപോലെ അതിനെ ദഹിപ്പിക്കണം. അയാൾ ചെയ്ത പാപത്തിനു പുരോഹിതൻ ഈ വിധം പ്രായശ്ചിത്തം കഴിക്കണം, എന്നാൽ അത് അയാളോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘സാക്ഷിമൊഴി നൽകാൻ പരസ്യപ്പെടുത്തിയ കൽപ്പന കേട്ടിട്ടും താൻ കണ്ടതോ അറിഞ്ഞതോ ആയ സംഗതി അറിയിക്കാതെ ആ വിധത്തിൽ പാപംചെയ്യുന്ന വ്യക്തി തന്റെ കുറ്റം വഹിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘ആചാരപരമായി അശുദ്ധമായ എന്തെങ്കിലുമോ ശുദ്ധിയില്ലാത്ത കാട്ടുമൃഗം, ശുദ്ധിയില്ലാത്ത കന്നുകാലി, മണ്ണിൽ ഇഴയുന്ന ശുദ്ധിയില്ലാത്ത ഇഴജന്തു എന്നിവയിൽ ഏതിന്റെയെങ്കിലും ശവമോ ആരെങ്കിലും അറിയാതെ സ്പർശിക്കുകയും എന്നാൽ അത് ആ മനുഷ്യൻ തിരിച്ചറിയുകയും ചെയ്താൽ അയാൾ അശുദ്ധനും കുറ്റക്കാരനുമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","അല്ലെങ്കിൽ ആരെങ്കിലും ഒരു മനുഷ്യനെ അറിയാതെ സ്പർശിക്കുകയും അങ്ങനെ ആ വ്യക്തി അശുദ്ധമായിത്തീരുകയും ചെയ്താൽ, ആ മനുഷ്യൻ അറിയാതിരുന്നാലും, പിന്നീട് അതിനെക്കുറിച്ച് അറിയുമ്പോൾ അയാൾ കുറ്റക്കാരനാകും. ");
INSERT INTO malc_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","അല്ലെങ്കിൽ ഒരാൾ അവിവേകത്തോടെ നന്മയോ തിന്മയോ ആയ എന്തെങ്കിലും കാര്യം ചെയ്യാൻ ശപഥംചെയ്യുകയോ ഏതെങ്കിലും കാര്യത്തിൽ അശ്രദ്ധമായി ആണയിടുകയോ ചെയ്താൽ, ആ മനുഷ്യൻ അതിനെക്കുറിച്ച് അറിയാതിരുന്നാലും, പിന്നീട് അതിനെക്കുറിച്ച് തിരിച്ചറിയുമ്പോൾ അയാൾ കുറ്റക്കാരനാകും. ");
INSERT INTO malc_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ആരെങ്കിലും ഇവയിൽ ഏതിലെങ്കിലും കുറ്റക്കാരാകുന്നെങ്കിൽ, അവർ ഏതിലാണു പാപം ചെയ്തതെന്ന് ഏറ്റുപറയണം. ");
INSERT INTO malc_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","താൻ ചെയ്ത പാപംനിമിത്തം യഹോവയ്ക്ക് പ്രായശ്ചിത്തമായി ആട്ടിൻപറ്റത്തിൽനിന്ന് ഒരു പെണ്ണാട്ടിൻകുട്ടിയെയോ പെൺകോലാടിനെയോ പാപശുദ്ധീകരണയാഗമായി അർപ്പിക്കണം. പുരോഹിതൻ അവരുടെ പാപത്തിന് അവർക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘ആ മനുഷ്യന് ഒരു ആട്ടിൻകുട്ടിക്കു വകയില്ലെങ്കിൽ, തന്റെ പാപത്തിന്റെ ശിക്ഷയായി രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ ഒന്നു പാപശുദ്ധീകരണയാഗമായും മറ്റേതു ഹോമയാഗമായും യഹോവയ്ക്ക് അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ആ വ്യക്തി അവയെ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരണം. പുരോഹിതൻ ആദ്യം ഒന്നിനെ പാപശുദ്ധീകരണയാഗമായി അർപ്പിക്കണം. അതിന്റെ തല കഴുത്തിൽനിന്ന് പൂർണമായി വേർപെട്ടുപോകാതെ പിരിച്ചുമുറിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","പാപശുദ്ധീകരണയാഗത്തിന്റെ കുറെ രക്തം യാഗപീഠത്തിന്റെ വശത്തു തളിക്കണം. ശേഷിച്ചരക്തം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ പിഴിഞ്ഞുകളയണം. ഇതു പാപശുദ്ധീകരണയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","പിന്നീടു പുരോഹിതൻ മറ്റേതിനെ നിർദിഷ്ടരീതിയിൽ ഹോമയാഗമായി അർപ്പിക്കണം; ഇങ്ങനെ ആ മനുഷ്യന്റെ പാപത്തിനുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യണം; എന്നാൽ അത് അവനോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘എന്നാൽ, ആ മനുഷ്യനു രണ്ടു കുറുപ്രാവിനോ രണ്ടു പ്രാവിൻകുഞ്ഞിനോ വകയില്ലെങ്കിൽ, തന്റെ പാപത്തിനുവേണ്ടി വഴിപാടായി ഒരു ഓമെർ നേരിയമാവ് പാപശുദ്ധീകരണയാഗമായി അർപ്പിക്കണം. അത് ഒരു പാപശുദ്ധീകരണയാഗമായതുകൊണ്ട് അവൻ അതിൽ ഒലിവെണ്ണയോ കുന്തിരിക്കമോ ചേർക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","അയാൾ അതിനെ പുരോഹിതന്റെയടുക്കൽ കൊണ്ടുവരണം. പുരോഹിതൻ അതിൽനിന്ന് ഒരുപിടി സ്മാരകഭാഗമായി എടുത്തു യാഗപീഠത്തിൽ യഹോവയ്ക്ക് അർപ്പിച്ച ദഹനയാഗമെന്നപോലെ ദഹിപ്പിക്കണം. ഇതു പാപശുദ്ധീകരണയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ആ മനുഷ്യൻ ചെയ്ത പാപത്തിനു പുരോഹിതൻ ഇങ്ങനെ പ്രായശ്ചിത്തം ചെയ്യണം; എന്നാൽ അവനോടു ക്ഷമിക്കും. ബാക്കിയുള്ളതു ഭോജനയാഗത്തിലെന്നപോലെ പുരോഹിതനുള്ളതായിരിക്കും.’ ” ");
INSERT INTO malc_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ഒരാൾ യഹോവയുടെ വിശുദ്ധകാര്യങ്ങളെ സംബന്ധിച്ച് മനഃപൂർവമല്ലാതെ പിഴവുപറ്റി പാപംചെയ്താൽ, ഊനമില്ലാത്തതും വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നിർദിഷ്ട ശേക്കേൽ വെള്ളി വിലയുള്ളതുമായ ഒരു ആണാടിനെ ആട്ടിൻപറ്റത്തിൽനിന്ന് പ്രായശ്ചിത്തമായി യഹോവയ്ക്ക് അർപ്പിക്കണം. ഇത് അകൃത്യയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ഇതിനോടൊപ്പം വിശുദ്ധകാര്യങ്ങളെക്കുറിച്ചു തനിക്കു പിഴവുപറ്റിയതും അതിന്റെ അഞ്ചിലൊന്നും നഷ്ടപരിഹാരമായി ആ മനുഷ്യൻ പുരോഹിതനെ ഏൽപ്പിക്കണം. പുരോഹിതൻ അകൃത്യയാഗത്തിന്റെ ആണാടിനെ അർപ്പിച്ച് അവനുവേണ്ടി പ്രായശ്ചിത്തംചെയ്യും; എന്നാൽ അത് അവനോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ആരെങ്കിലും പാപംചെയ്തു യഹോവയുടെ കൽപ്പനയിൽ ചെയ്യരുതെന്നു വിലക്കിയിട്ടുള്ള ഏതെങ്കിലും ലംഘിച്ചാൽ, ആ വ്യക്തിക്ക് അത് അറിഞ്ഞുകൂടെങ്കിലും അയാൾ കുറ്റക്കാരനാണ്; അതിന്റെ കുറ്റം അയാൾ വഹിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ആ മനുഷ്യൻ ആട്ടിൻപറ്റത്തിൽനിന്ന് ഊനമില്ലാത്തതും ന്യായമായ വിലയുള്ളതുമായ ഒരു ആണാടിനെ അകൃത്യയാഗമായി പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരണം. ഈ വിധം പുരോഹിതൻ, അയാൾ അറിയാതെ ചെയ്ത തെറ്റിന്, അവനുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കണം; എന്നാൽ അവനോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ഇത് അകൃത്യയാഗം; ആ മനുഷ്യൻ യഹോവയ്ക്കു വിരോധമായി തെറ്റുചെയ്ത കുറ്റക്കാരനായിരുന്നല്ലോ.” ");
INSERT INTO malc_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","3","“ഒരാൾ തന്റെ പക്കൽ സൂക്ഷിക്കാനേൽപ്പിച്ചതോ പണയം നൽകിയതോ മോഷ്ടിച്ചതോ ആയ സാധനം സംബന്ധിച്ചോ കളഞ്ഞുകിട്ടിയതിനെക്കുറിച്ചോ തന്റെ അയൽവാസിയെ വഞ്ചിക്കുകയോ അവരോട് കള്ളം പറയുകയോ വ്യാജമായി ആണയിടുകയോ, ഇങ്ങനെ ഏതെങ്കിലും പ്രവൃത്തിയാൽ പാപംചെയ്ത് യഹോവയോട് അവിശ്വസ്തരായിത്തീർന്നാൽ— ");
INSERT INTO malc_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ഇത്തരം ഏതെങ്കിലും പാപംചെയ്തിട്ട് അവർക്ക് കുറ്റബോധമുണ്ടാകുമ്പോൾ അയാൾ മോഷ്ടിച്ചതോ വഞ്ചിച്ചെടുത്തതോ തന്റെ പക്കൽ ഏൽപ്പിച്ചിരുന്നതോ കളഞ്ഞുകിട്ടിയതോ ");
INSERT INTO malc_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","താൻ വ്യാജമായി ആണയിട്ട് സ്വന്തമാക്കിയതോ ആയ സാധനവും അതിന്റെ വിലയുടെ അഞ്ചിലൊന്നും നഷ്ടപരിഹാരംകൂടി ചേർത്ത് അയാൾ തിരികെക്കൊടുക്കണം. തന്റെ അകൃത്യയാഗം അർപ്പിക്കുന്ന ദിവസംതന്നെ അയാൾ അത് ഉടമസ്ഥനു കൊടുത്തിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ആ വ്യക്തി അകൃത്യയാഗമായി ആട്ടിൻപറ്റത്തിൽനിന്ന് ഊനമില്ലാത്തതും നിർദിഷ്ട വിലയുള്ളതുമായ ഒരു ആണാടിനെ യഹോവയ്ക്ക് അർപ്പിക്കാൻ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ഈ വിധത്തിൽ പുരോഹിതൻ ആ മനുഷ്യനുവേണ്ടി യഹോവയുടെമുമ്പാകെ പ്രായശ്ചിത്തം ചെയ്യണം. എന്നാൽ അയാൾ ചെയ്ത കുറ്റമൊക്കെയും ക്ഷമിക്കും.” ");
INSERT INTO malc_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“അഹരോനും പുത്രന്മാർക്കും ഈ കൽപ്പന കൊടുക്കുക: ‘ഹോമയാഗത്തിന്റെ ചട്ടങ്ങൾ ഇവയാണ്: ഹോമയാഗം രാത്രിമുഴുവനും രാവിലെവരെ യാഗപീഠത്തിലെ നെരിപ്പോടിലിരിക്കണം; യാഗപീഠത്തിലെ തീ കത്തിക്കൊണ്ടിരിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","പുരോഹിതൻ പരുത്തിനൂൽവസ്ത്രവും പരുത്തിനൂൽകൊണ്ടുള്ള അടിവസ്ത്രങ്ങളും ധരിച്ചുകൊണ്ട് യാഗപീഠത്തിൽ ഹോമയാഗം ദഹിച്ചുണ്ടാകുന്ന ചാരം എടുത്തു യാഗപീഠത്തിന്റെ ഒരുവശത്തു വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","പിന്നെ അദ്ദേഹം ആ വസ്ത്രങ്ങൾ മാറി വേറെ വസ്ത്രങ്ങൾ ധരിച്ചുകൊണ്ടു പാളയത്തിനുപുറത്ത് വെടിപ്പുള്ള ഒരു സ്ഥലത്തേക്ക് ആ ചാരം കൊണ്ടുപോകണം. ");
INSERT INTO malc_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","യാഗപീഠത്തിലെ തീ കത്തിക്കൊണ്ടിരിക്കണം; അത് അണഞ്ഞുപോകരുത്. പുരോഹിതൻ പ്രഭാതംതോറും വിറകടുക്കി തീയുടെമേൽ ഹോമയാഗം ക്രമീകരിച്ചു സമാധാനയാഗത്തിന്റെ മേദസ്സ് അതിന്മേൽ ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","യാഗപീഠത്തിലെ തീ നിരന്തരമായി കത്തിക്കൊണ്ടിരിക്കണം; അത് അണഞ്ഞുപോകരുത്. ");
INSERT INTO malc_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘ഭോജനയാഗത്തിന്റെ ചട്ടങ്ങൾ ഇവയാണ്: അഹരോന്റെ പുത്രന്മാർ യഹോവയുടെ സന്നിധിയിൽ യാഗപീഠത്തിനുമുമ്പിൽ അതു കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","പുരോഹിതൻ ഒരുപിടി നേരിയമാവും ഒലിവെണ്ണയും ഭോജനയാഗത്തിനുള്ള കുന്തിരിക്കം മുഴുവനും എടുത്ത്, സ്മാരകഭാഗമായി യാഗപീഠത്തിൽ യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായി ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","അതിൽ ബാക്കിയുള്ളത് അഹരോനും പുത്രന്മാരും ഭക്ഷിക്കണം; എന്നാൽ അതു പുളിപ്പില്ലാത്തതായി വിശുദ്ധസ്ഥലത്തുവെച്ചു ഭക്ഷിക്കണം; അവർ അതു സമാഗമകൂടാരത്തിന്റെ അങ്കണത്തിൽവെച്ചു ഭക്ഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","അതു പുളിപ്പുചേർത്തു ചുടരുത്; എനിക്ക് അർപ്പിച്ച ദഹനയാഗങ്ങളിൽ ഇതു ഞാൻ അവർക്ക് ഓഹരിയായി കൊടുത്തിരിക്കുന്നു. പാപശുദ്ധീകരണയാഗവും അകൃത്യയാഗവുംപോലെതന്നെ ഇത് ഏറ്റവും വിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","അഹരോന്റെ മക്കളിൽ ഏതൊരാണിനും ദഹനയാഗങ്ങളിൽനിന്ന് ഭക്ഷിക്കാം. അത് യഹോവയ്ക്ക് അർപ്പിക്കുന്ന യാഗത്തിൽനിന്ന് അദ്ദേഹത്തിനു തലമുറതലമുറയായി എന്നെന്നേക്കുമുള്ള അവകാശമാണ്. അവയെ സ്പർശിക്കുന്നവരെല്ലാം വിശുദ്ധരായിരിക്കും.’ ” ");
INSERT INTO malc_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","യഹോവ പിന്നെയും മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“അഹരോൻ അഭിഷിക്തനാകുന്ന ദിവസം അദ്ദേഹവും പുത്രന്മാരും യഹോവയ്ക്ക് അർപ്പിക്കേണ്ട വഴിപാട് ഇതാണ്: നിരന്തരം അർപ്പിക്കേണ്ട ഭോജനയാഗത്തിനായി ഒരു ഓമെർ നേരിയമാവ്, പകുതി രാവിലെയും പകുതി വൈകുന്നേരവും അർപ്പിക്കണം ");
INSERT INTO malc_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","അത് എണ്ണചേർത്ത് അപ്പച്ചട്ടിയിൽ പാകംചെയ്യണം; നന്നായി കുഴച്ച് കഷണങ്ങളാക്കി അർപ്പിക്കണം. ഇത് യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ഭോജനയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","മഹാപുരോഹിതനായി തന്റെ പിൻതുടർച്ചക്കാരനാകേണ്ട പുത്രൻ അതു പാകംചെയ്യണം. അത് യഹോവയ്ക്കു നിത്യമായ ഓഹരി. അതു പൂർണമായി ദഹിപ്പിക്കപ്പെടണം. ");
INSERT INTO malc_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ഒരു പുരോഹിതന്റെ ഓരോ ഭോജനയാഗവും പൂർണമായി ദഹിപ്പിക്കണം; അതു ഭക്ഷിക്കാൻ അനുവാദമില്ല.” ");
INSERT INTO malc_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“അഹരോനോടും പുത്രന്മാരോടും പറയുക: ‘പാപശുദ്ധീകരണയാഗത്തിന്റെ ചട്ടങ്ങൾ ഇവയാണ്: ഹോമയാഗമൃഗത്തെ അറക്കുന്ന സ്ഥലത്തുവെച്ചു പാപശുദ്ധീകരണയാഗമൃഗത്തെയും യഹോവയുടെ സന്നിധിയിൽ അറക്കണം; അത് ഏറ്റവും വിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","അർപ്പിക്കുന്ന പുരോഹിതൻ അതു ഭക്ഷിക്കണം. സമാഗമകൂടാരത്തിന്റെ അങ്കണത്തിൽ, വിശുദ്ധസ്ഥലത്തുവെച്ച് അതു ഭക്ഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ആ മാംസത്തിൽ സ്പർശിക്കുന്നതെന്തും വിശുദ്ധമായിരിക്കും, ഒരു വസ്ത്രത്തിൽ രക്തം തെറിച്ചാൽ നിങ്ങൾ അതു വിശുദ്ധസ്ഥലത്തുവെച്ചു കഴുകണം. ");
INSERT INTO malc_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ആ മാംസം പാകംചെയ്ത മൺപാത്രം ഉടച്ചുകളയണം, എന്നാൽ അത് ഓട്ടുപാത്രത്തിലാണു പാകംചെയ്തതെങ്കിൽ, ആ പാത്രം വെള്ളത്തിൽ തേച്ചുകഴുകണം. ");
INSERT INTO malc_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ഒരു പുരോഹിതന്റെ കുടുംബത്തിലെ ഏതൊരു പുരുഷനും അതു ഭക്ഷിക്കാം; അത് ഏറ്റവും വിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","വിശുദ്ധസ്ഥലത്തു പ്രായശ്ചിത്തം കഴിക്കാനായി സമാഗമകൂടാരത്തിൽ രക്തം കൊണ്ടുവരുന്ന പാപശുദ്ധീകരണയാഗം ഭക്ഷിക്കരുത്; അതു ചുട്ടുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘അതിവിശുദ്ധമായ അകൃത്യയാഗത്തിന്റെ ചട്ടങ്ങൾ ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ഹോമയാഗമൃഗത്തെ അറക്കുന്ന സ്ഥലത്ത് അകൃത്യയാഗമൃഗത്തെയും അറക്കണം; അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ, ചുറ്റും തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","അതിന്റെ മേദസ്സു മുഴുവനും തടിച്ച വാലും ആന്തരികാവയവങ്ങളെ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും ");
INSERT INTO malc_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","വൃക്കകൾ രണ്ടും അവയുടെമേൽ അരക്കെട്ടിനടുത്തുള്ള മേദസ്സും വൃക്കകളോടൊപ്പം മാറ്റുന്ന കരളിന്മേലുള്ള കൊഴുപ്പും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","പുരോഹിതൻ അവയെ യഹോവയ്ക്കു ദഹനയാഗമായി യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം. അത് അകൃത്യയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","പുരോഹിതന്റെ കുടുംബത്തിലെ ഏതൊരു ആണിനും അതു ഭക്ഷിക്കാം; എന്നാൽ അതു വിശുദ്ധസ്ഥലത്തുവെച്ചു ഭക്ഷിക്കണം; അത് അതിവിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘പാപശുദ്ധീകരണയാഗത്തിനും അകൃത്യയാഗത്തിനും ഒരേ നിയമം ബാധകമാണ്: അവകൊണ്ടു പ്രായശ്ചിത്തം വരുത്തുന്ന പുരോഹിതനുള്ളതാണ് അത്. ");
INSERT INTO malc_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ആർക്കെങ്കിലുംവേണ്ടി ഹോമയാഗം അർപ്പിക്കുന്ന പുരോഹിതന് അതിന്റെ തുകൽ എടുക്കാം. ");
INSERT INTO malc_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","അടുപ്പിൽ ചുട്ടതോ ഉരുളിയിലോ അപ്പച്ചട്ടിയിലോ പാകംചെയ്തതോ ആയ ഭോജനയാഗം ഓരോന്നും അത് അർപ്പിക്കുന്ന പുരോഹിതനുള്ളതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ഒലിവെണ്ണ ചേർത്തതോ ചേർക്കാത്തതോ ആയ ഭോജനയാഗം ഓരോന്നും അഹരോന്റെ എല്ലാ പുത്രന്മാർക്കും തുല്യമായിട്ടുള്ളതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘ഒരാൾ യഹോവയ്ക്ക് അർപ്പിക്കുന്ന സമാധാനയാഗത്തിന്റെ ചട്ടങ്ങൾ ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘അത് ഒരു സ്തോത്രാർപ്പണമെങ്കിൽ, ആ സ്തോത്രാർപ്പണത്തോടൊപ്പം അവൻ പുളിപ്പില്ലാതെ ഒലിവെണ്ണചേർത്തുണ്ടാക്കിയ അടകളും എണ്ണ പുരട്ടിയ പുളിപ്പില്ലാത്ത വടകളും എണ്ണ ചേർത്തു കുതിർത്ത നേരിയമാവുകൊണ്ടുണ്ടാക്കിയ അടകളും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","സ്തോത്രാർപ്പണമായ സമാധാനയാഗത്തോടൊപ്പം അദ്ദേഹം പുളിപ്പിച്ച മാവുകൊണ്ടുണ്ടാക്കിയ വടകളും ഭോജനയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ആ മനുഷ്യൻ യഹോവയ്ക്കുവേണ്ടി ഓരോ ഇനത്തിൽ ഒന്നുവീതം സ്വമേധാർപ്പണമായി കൊണ്ടുവരണം; അത് സമാധാനയാഗത്തിന്റെ രക്തം യാഗപീഠത്തിനുചുറ്റും തളിക്കുന്ന പുരോഹിതനുള്ളതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","സ്തോത്രാർപ്പണമായ സമാധാനയാഗത്തിന്റെ മാംസം അത് അർപ്പിക്കുന്ന ദിവസംതന്നെ ഭക്ഷിക്കണം; അതിലൊട്ടും രാവിലെവരെ ശേഷിപ്പിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘എന്നാൽ അദ്ദേഹത്തിന്റെ യാഗം ഒരു നേർച്ചയോ സ്വമേധായാഗമോ ആണെങ്കിൽ, ആ യാഗം അർപ്പിക്കുന്ന ദിവസം അതു ഭക്ഷിക്കണം; എന്നാൽ എന്തെങ്കിലും ശേഷിച്ചാൽ അടുത്തദിവസം ഭക്ഷിക്കാവുന്നതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","യാഗമാംസത്തിൽ മൂന്നാംദിവസംവരെ അവശേഷിക്കുന്നതു ദഹിപ്പിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","സമാധാനയാഗത്തിന്റെ ഏതെങ്കിലും മാംസം മൂന്നാംദിവസം ഭക്ഷിച്ചാൽ അതു പ്രസാദകരമല്ല. അത് അർപ്പിക്കുന്നയാളുടെപേരിൽ കണക്കാക്കുകയില്ല, കാരണം അത് അശുദ്ധമായിത്തീരും; അതിന്റെ ഏതെങ്കിലും ഒരുഭാഗം ഭക്ഷിക്കുന്നയാൾ കുറ്റക്കാരനായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘ആചാരപരമായി, അശുദ്ധമായ എന്തിനെയെങ്കിലും സ്പർശിച്ചിട്ടുള്ള മാംസം ഭക്ഷിക്കരുത്; അതു തീയിലിട്ടു ചുട്ടുകളയണം. മറ്റു മാംസമാകട്ടെ, ആചാരപരമായി ശുദ്ധിയുള്ള ഏതൊരാൾക്കും ഭക്ഷിക്കാം. ");
INSERT INTO malc_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","യഹോവയ്ക്കുള്ള സമാധാനയാഗത്തിന്റെ ഏതെങ്കിലും മാംസം അശുദ്ധരായ ആരെങ്കിലും ഭക്ഷിച്ചാൽ, അവരെ അവരുടെ ജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ആരെങ്കിലുമൊരാൾ അശുദ്ധമായ എന്തെങ്കിലും—മനുഷ്യന്റെ അശുദ്ധിയോ ഒരു അശുദ്ധമൃഗമോ അശുദ്ധവും നിഷിദ്ധവുമായ എന്തെങ്കിലുമോ—സ്പർശിച്ചിട്ട്, യഹോവയ്ക്കുള്ള സമാധാനയാഗത്തിന്റെ ഏതെങ്കിലും മാംസം ഭക്ഷിച്ചാൽ, ആ വ്യക്തിയെ തന്റെ ജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം.’ ” ");
INSERT INTO malc_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ഇസ്രായേല്യരോടു പറയുക: ‘കന്നുകാലിയുടെയോ ചെമ്മരിയാടിന്റെയോ കോലാടിന്റെയോ മേദസ്സ് അൽപ്പംപോലും ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ചത്തതോ വന്യമൃഗങ്ങൾ കടിച്ചുകീറിയതോ ആയ മൃഗത്തിന്റെ മേദസ്സു മറ്റെന്തെങ്കിലും ആവശ്യത്തിന് ഉപയോഗിക്കാം, എന്നാൽ അതു ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","യഹോവയ്ക്കു ദഹനയാഗം അർപ്പിക്കാനുള്ള മൃഗത്തിന്റെ മേദസ്സു ഭക്ഷിക്കുന്നയാൾ അവരുടെ ജനത്തിൽനിന്ന് ഛേദിക്കപ്പെടണം. ");
INSERT INTO malc_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","നിങ്ങൾ എവിടെ ജീവിച്ചാലും ഒരു പക്ഷിയുടെയോ മൃഗത്തിന്റെയോ രക്തം കുടിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ആരെങ്കിലും രക്തം കുടിച്ചാൽ ആ മനുഷ്യൻ തന്റെ ജനത്തിൽനിന്ന് ഛേദിക്കപ്പെടണം.’ ” ");
INSERT INTO malc_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ഇസ്രായേല്യരോടു പറയുക: ‘യഹോവയ്ക്കു സമാധാനയാഗം കൊണ്ടുവരുന്നയാൾ അതിന്റെ ഭാഗം ആ മനുഷ്യന്റെ യാഗമായി യഹോവയ്ക്ക് അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","അയാൾ സ്വന്തം കൈയാൽ യഹോവയ്ക്കു ദഹനയാഗം കൊണ്ടുവരണം; അവൻ നെഞ്ചോടുകൂടെ മേദസ്സും കൊണ്ടുവന്ന് ഒരു വിശിഷ്ടയാഗമായി നെഞ്ച് യഹോവയുടെമുമ്പാകെ ഉയർത്തി അർപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","പുരോഹിതൻ മേദസ്സു യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം, എന്നാൽ നെഞ്ച് അഹരോനും തന്റെ പുത്രന്മാർക്കുമുള്ളതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","നിങ്ങളുടെ സമാധാനയാഗത്തിന്റെ വലതുതുട പുരോഹിതന് ഒരു സ്വമേധാദാനമായി കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","അഹരോന്റെ പുത്രന്മാരിൽ സമാധാനയാഗത്തിന്റെ രക്തവും മേദസ്സും അർപ്പിക്കുന്ന പുരോഹിതന് അവകാശപ്പെട്ടതാണ്, വലത്തെ തുട. ");
INSERT INTO malc_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ഇസ്രായേല്യരുടെ സമാധാനയാഗത്തിൽനിന്ന് ദൈവസന്നിധിയിൽ ഉയർത്തി അർപ്പിച്ച നെഞ്ചും വിശിഷ്ടയാഗാർപ്പണമായ വലതുതുടയും ഞാൻ എടുത്ത് അവയെ പുരോഹിതനായ അഹരോനും തന്റെ പുത്രന്മാർക്കും ഇസ്രായേല്യരിൽനിന്നുള്ള നിത്യാവകാശമായി കൊടുത്തിരിക്കുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","അഹരോനെയും പുത്രന്മാരെയും യഹോവയ്ക്കു പുരോഹിതന്മാരായി സമർപ്പിച്ച നാളിൽ, യഹോവയ്ക്ക് അർപ്പിച്ച ദഹനയാഗങ്ങളിൽനിന്ന് അവർക്കുള്ള ഓഹരി ഇതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","അവർ അഭിഷിക്തരായ ദിവസം, ഇസ്രായേല്യർ ഇത് അവർക്ക് അവരുടെ നിത്യാവകാശമായി എല്ലാ തലമുറകളിലും നൽകണമെന്ന് യഹോവ കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ഇവയാണ്, ദഹനയാഗം, ഭോജനയാഗം, പാപശുദ്ധീകരണയാഗം, അകൃത്യയാഗം, പ്രതിഷ്ഠായാഗം, സമാധാനയാഗം എന്നിവയുടെ ചട്ടങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","സീനായിമരുഭൂമിയിൽവെച്ച് യഹോവയ്ക്ക് അവരുടെ വഴിപാടുകൾ കൊണ്ടുവരാൻ കൽപ്പിച്ച നാളിൽ യഹോവ സീനായിമലയിൽവെച്ച് മോശയ്ക്ക് ഈ കൽപ്പനകൾ ഇസ്രായേല്യർക്കു നൽകി. ");
INSERT INTO malc_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“അഹരോനെയും പുത്രന്മാരെയും അവരോടുകൂടെ വസ്ത്രം, അഭിഷേകതൈലം, പാപശുദ്ധീകരണയാഗത്തിനുള്ള കാള, രണ്ട് ആട്ടുകൊറ്റന്മാർ, കുട്ടയിൽ പുളിപ്പില്ലാത്ത അപ്പം എന്നിവയും കൊണ്ടുവരിക; ");
INSERT INTO malc_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","മുഴുസഭയെയും സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ കൂട്ടുക.” ");
INSERT INTO malc_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","യഹോവ കൽപ്പിച്ചതുപോലെ മോശ ചെയ്തു, സഭ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ വന്നുകൂടി. ");
INSERT INTO malc_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","മോശ സഭയോടു പറഞ്ഞു: “യഹോവ ചെയ്യണമെന്ന് അരുളിച്ചെയ്തത് ഇതാണ്.” ");
INSERT INTO malc_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","പിന്നെ മോശ അഹരോനെയും പുത്രന്മാരെയും മുന്നോട്ടുകൊണ്ടുവന്ന് അവരെ വെള്ളത്തിൽ കഴുകി. ");
INSERT INTO malc_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","അദ്ദേഹം അഹരോനെ കുപ്പായം ധരിപ്പിച്ചു, അരക്കച്ച ചുറ്റിക്കെട്ടി, മേലങ്കി അണിയിച്ചു. ഏഫോദ് ധരിപ്പിച്ചു. വിദഗ്ധമായി നെയ്ത അതിന്റെ അരക്കച്ചകൊണ്ട് അദ്ദേഹം ഏഫോദ് ചേർത്തുകെട്ടി. ");
INSERT INTO malc_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","അദ്ദേഹത്തെ നിർണയപ്പതക്കം അണിയിച്ചു. നിർണയപ്പതക്കത്തിൽ ഊറീമും തുമ്മീമും വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ഇതിനുശേഷം യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ അദ്ദേഹം അഹരോന്റെ തലയിൽ തലപ്പാവുവെച്ച് അതിന്റെ മുന്നിലായി വിശുദ്ധകിരീടമായ തങ്കംകൊണ്ടുള്ള നെറ്റിപ്പട്ടം വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","പിന്നെ മോശ അഭിഷേകതൈലം എടുത്തു സമാഗമകൂടാരവും അതിനകത്തുള്ള സകലതും അഭിഷേകംചെയ്തു വിശുദ്ധീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","അദ്ദേഹം കുറെ തൈലം പീഠത്തിന്മേൽ ഏഴുപ്രാവശ്യം തളിച്ചു, യാഗപീഠവും അതിലെ എല്ലാ ഉപകരണങ്ങളും തൊട്ടിയും അതിന്റെ കാലുകളും അഭിഷേകംചെയ്തു ശുദ്ധീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","അദ്ദേഹം അഹരോന്റെ തലയിൽ അഭിഷേകതൈലം ഒഴിച്ച് അദ്ദേഹത്തെ അഭിഷേകംചെയ്തു വിശുദ്ധീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ, പിന്നീട് അദ്ദേഹം അഹരോന്റെ പുത്രന്മാരെ മുമ്പോട്ടുകൊണ്ടുവന്ന് അവരെ കുപ്പായം ധരിപ്പിച്ചു. അരക്കച്ച കെട്ടി, ശിരോവസ്ത്രവും വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ഇതിനുശേഷം മോശ പാപശുദ്ധീകരണയാഗത്തിനുള്ള കാളയെ കൊണ്ടുവന്നു, അഹരോനും പുത്രന്മാരും അവരുടെ കൈകൾ അതിന്റെ തലയിൽ വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","മോശ കാളയെ അറത്ത്, രക്തം കുറെ എടുത്ത് അദ്ദേഹത്തിന്റെ വിരൽകൊണ്ടു യാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടി, യാഗപീഠത്തെ ശുദ്ധീകരിച്ചു. ശേഷിച്ചരക്തം അദ്ദേഹം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിച്ചു. അങ്ങനെ പ്രായശ്ചിത്തം അർപ്പിക്കാൻ അദ്ദേഹം യാഗപീഠത്തെ ശുദ്ധീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","മോശ, ആന്തരികാവയവങ്ങൾക്കു ചുറ്റുമുള്ള എല്ലാ മേദസ്സും കരളിന്മേലുള്ള കൊഴുപ്പും രണ്ടുവൃക്കയും അവയുടെ മേദസ്സും എടുത്ത് യാഗപീഠത്തിൽ ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","എന്നാൽ യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ അദ്ദേഹം കാളയെ അതിന്റെ തുകൽ, മാംസം, ചാണകം എന്നിവയോടുകൂടെ പാളയത്തിനുപുറത്തു ദഹിപ്പിച്ചുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","പിന്നെ അദ്ദേഹം ഹോമയാഗത്തിനുള്ള ആട്ടുകൊറ്റനെ കൊണ്ടുവന്നു. അഹരോനും പുത്രന്മാരും ആട്ടുകൊറ്റന്റെ തലയിൽ അവരുടെ കൈകൾ വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","പിന്നെ മോശ ആട്ടുകൊറ്റനെ അറത്തു രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","അദ്ദേഹം ആട്ടുകൊറ്റനെ കഷണങ്ങളായി മുറിച്ച് തലയും കഷണങ്ങളും മേദസ്സും ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ അദ്ദേഹം ആന്തരികാവയവങ്ങളും കാലുകളും വെള്ളത്തിൽ കഴുകി ആട്ടുകൊറ്റനെ മുഴുവനുമായി യാഗപീഠത്തിന്മേൽ ദഹിപ്പിച്ചു; ഇതു യഹോവയ്ക്ക് അർപ്പിക്കുന്ന ഹോമയാഗം; യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","പിന്നെ അദ്ദേഹം പ്രതിഷ്ഠയ്ക്കുള്ള രണ്ടാമത്തെ ആട്ടുകൊറ്റനെ കൊണ്ടുവന്നു. അഹരോനും പുത്രന്മാരും ആട്ടുകൊറ്റന്റെ തലയിൽ കൈകൾ വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","മോശ ആട്ടുകൊറ്റനെ അറത്ത് അതിന്റെ കുറെ രക്തമെടുത്ത് അഹരോന്റെ വലതുചെവിയുടെ അറ്റത്തും വലതുകൈയുടെ പെരുവിരലിലും വലതുകാലിന്റെ പെരുവിരലിലും പുരട്ടി. ");
INSERT INTO malc_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","അഹരോന്റെ പുത്രന്മാരെയും മുന്നോട്ടുകൊണ്ടുവന്ന്, മോശ അവരുടെ വലതുചെവിയുടെ അറ്റത്തും വലതുകൈയുടെ പെരുവിരലിലും വലതുകാലിന്റെ പെരുവിരലിലും രക്തം പുരട്ടി. പിന്നെ അദ്ദേഹം യാഗപീഠത്തിന്മേൽ ചുറ്റും രക്തം തളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ഇതിനുശേഷം അദ്ദേഹം മേദസ്സും തടിച്ച വാലും ആന്തരികാവയവങ്ങളിലുള്ള മേദസ്സും കരളിന്മേലുള്ള കൊഴുപ്പും വൃക്ക രണ്ടും അവയുടെ മേദസ്സും വലതുതുടയും എടുത്തു. ");
INSERT INTO malc_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","പിന്നെ യഹോവയുടെ സന്നിധിയിൽ പുളിപ്പില്ലാത്ത അപ്പം വെച്ചിരുന്ന കുട്ടയിൽനിന്ന് അദ്ദേഹം ഒരു വടയും ഒലിവെണ്ണചേർത്തുണ്ടാക്കിയ ഒരു അടയും ഒരു ദോശയും എടുത്ത്, മേദസ്സിന്മേലും വലതുതുടയിന്മേലും വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","അദ്ദേഹം ഇവയെല്ലാം എടുത്ത് അഹരോന്റെയും അദ്ദേഹത്തിന്റെ പുത്രന്മാരുടെയും കൈയിലും വെച്ച്, യഹോവയുടെ സന്നിധിയിൽ ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","അതിനുശേഷം മോശ അവരുടെ കൈയിൽനിന്ന് അവ എടുത്ത് യാഗപീഠത്തിലുള്ള ഹോമയാഗത്തിന്മേൽ ദഹിപ്പിച്ചു; ഇത് ഹൃദ്യസുഗന്ധമായ പ്രതിഷ്ഠായാഗം; യഹോവയുടെ സന്നിധിയിൽ അർപ്പിക്കുന്ന ദഹനയാഗംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","പ്രതിഷ്ഠായാഗത്തിനുള്ള ആട്ടുകൊറ്റനിൽ മോശയുടെ ഓഹരിയായ നെഞ്ച് എടുത്തു യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ യഹോവയുടെ സന്നിധിയിൽ ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","പിന്നെ മോശ കുറച്ച് അഭിഷേകതൈലവും യാഗപീഠത്തിൽനിന്ന് കുറച്ച് രക്തവും എടുത്ത് അഹരോന്റെയും അദ്ദേഹത്തിന്റെ വസ്ത്രങ്ങളുടെയും അദ്ദേഹത്തിന്റെ പുത്രന്മാരുടെയും അവരുടെ വസ്ത്രങ്ങളുടെയുംമേൽ തളിച്ചു. അങ്ങനെ അദ്ദേഹം അഹരോനെയും അദ്ദേഹത്തിന്റെ വസ്ത്രങ്ങളും അദ്ദേഹത്തിന്റെ പുത്രന്മാരെയും അവരുടെ വസ്ത്രങ്ങളും വിശുദ്ധീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ഇതിനുശേഷം മോശ അഹരോനോടും പുത്രന്മാരോടും പറഞ്ഞു: “ ‘അഹരോനും പുത്രന്മാരും അതു ഭക്ഷിക്കണം’ എന്നു ഞാൻ കൽപ്പിച്ചതുപോലെ, സമാഗമകൂടാരവാതിലിൽ മാംസം പാകംചെയ്ത്, പ്രതിഷ്ഠായാഗത്തിനുള്ള കുട്ടയിലെ അപ്പത്തോടുകൂടെ അതു ഭക്ഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ശേഷിക്കുന്ന മാംസവും അപ്പവും ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","നിങ്ങളുടെ പ്രതിഷ്ഠാശുശ്രൂഷ ഏഴുദിവസമാണ്. അതു കഴിയുന്നതുവരെ, ഏഴുദിവസത്തേക്ക് സമാഗമകൂടാരത്തിന്റെ കവാടംവിട്ട് പുറത്തുപോകരുത്. ");
INSERT INTO malc_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","യഹോവ കൽപ്പിച്ചതനുസരിച്ചു നിങ്ങൾക്കുവേണ്ടിയുള്ള പ്രായശ്ചിത്തമാണ് ഇന്നു ചെയ്തത്. ");
INSERT INTO malc_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","നിങ്ങൾ മരിക്കാതിരിക്കേണ്ടതിന് ഏഴു രാവും ഏഴു പകലും യഹോവ ആവശ്യപ്പെടുന്നതെന്തും ചെയ്തുകൊണ്ട് സമാഗമകൂടാരവാതിലിൽ താമസിക്കണം; അങ്ങനെയാണ് എന്നോടു കൽപ്പിച്ചിരിക്കുന്നത്.” ");
INSERT INTO malc_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","അങ്ങനെ യഹോവ മോശമുഖാന്തരം കൽപ്പിച്ചതെല്ലാം അഹരോനും പുത്രന്മാരും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","പ്രതിഷ്ഠാശുശ്രൂഷയ്ക്കുശേഷം, എട്ടാംദിവസം മോശ അഹരോനെയും പുത്രന്മാരെയും ഇസ്രായേലിലെ ഗോത്രത്തലവന്മാരെയും വിളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","അദ്ദേഹം അഹരോനോടു പറഞ്ഞത്, “നിങ്ങളുടെ പാപശുദ്ധീകരണയാഗത്തിനായി ഊനമില്ലാത്ത ഒരു കാളക്കിടാവിനെയും നിങ്ങളുടെ ഹോമയാഗത്തിനായി ഒരു ആട്ടുകൊറ്റനെയും യഹോവയുടെമുമ്പാകെ സമർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","എന്നിട്ട് ഇസ്രായേല്യരോടു പറയണം: ‘പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു ആൺകോലാടിനെയും ഹോമയാഗത്തിനായി ഊനമില്ലാത്തതും ഒരുവയസ്സു പ്രായമുള്ളതുമായ ഒരു കാളക്കിടാവിനെയും ഒരു ആട്ടിൻകുട്ടിയെയും ");
INSERT INTO malc_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","സമാധാനയാഗത്തിനായി ഒരു കാളയെയും ഒരു ആട്ടുകൊറ്റനെയും ഒലിവെണ്ണയിൽ കുഴച്ച ഭോജനയാഗത്തോടൊപ്പം യഹോവയുടെമുമ്പാകെ യാഗം കഴിക്കാൻ എടുക്കണം. കാരണം, യഹോവ ഇന്നു നിങ്ങൾക്കു പ്രത്യക്ഷനാകും.’ ” ");
INSERT INTO malc_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","മോശ കൽപ്പിച്ചതെല്ലാം സമാഗമകൂടാരത്തിനുമുമ്പാകെ കൊണ്ടുവന്നു, സഭ മുഴുവൻ അടുത്തുവന്നു യഹോവയുടെമുമ്പിൽനിന്നു. ");
INSERT INTO malc_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","പിന്നെ മോശ പറഞ്ഞു: “യഹോവയുടെ തേജസ്സ് നിങ്ങൾക്കു പ്രത്യക്ഷമാകുന്നതുകൊണ്ട്, നിങ്ങൾ ചെയ്യണമെന്നു യഹോവ കൽപ്പിച്ചത് ഇതാണ്.” ");
INSERT INTO malc_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","മോശ അഹരോനോടു പറഞ്ഞു: “യഹോവ കൽപ്പിച്ചതുപോലെ യാഗപീഠത്തിലേക്കു വന്നു നിങ്ങൾ പാപശുദ്ധീകരണയാഗവും ഹോമയാഗവും അർപ്പിച്ച് നിനക്കും ജനത്തിനുംവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യുക; ജനത്തിനുവേണ്ടിയുള്ള വഴിപാടും യാഗവും കഴിച്ചു ജനത്തിന്നു പ്രായശ്ചിത്തം ചെയ്യുക.” ");
INSERT INTO malc_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","അങ്ങനെ അഹരോൻ യാഗപീഠത്തിലേക്കു വന്നു കാളക്കിടാവിനെ തനിക്കുവേണ്ടി പാപശുദ്ധീകരണയാഗമായി അറത്തു. ");
INSERT INTO malc_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","അദ്ദേഹത്തിന്റെ പുത്രന്മാർ രക്തം തന്റെ അടുക്കൽ കൊണ്ടുവന്നു. അദ്ദേഹം രക്തത്തിൽ വിരൽ മുക്കി യാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടി. ശേഷിച്ചരക്തം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ, അദ്ദേഹം പാപശുദ്ധീകരണയാഗത്തിൽനിന്ന് മേദസ്സും വൃക്കകളും കരളിന്മേലുള്ള കൊഴുപ്പും യാഗപീഠത്തിന്മേൽ ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","മാംസവും തുകലും പാളയത്തിനു വെളിയിൽ ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","പിന്നെ അഹരോൻ ഹോമയാഗമൃഗത്തെ അറത്തു. അദ്ദേഹത്തിന്റെ പുത്രന്മാർ രക്തം അദ്ദേഹത്തിന്റെ കൈയിൽ കൊടുക്കുകയും അദ്ദേഹം അതു യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","അവർ ഹോമയാഗമൃഗത്തെ തലയുൾപ്പെടെ കഷണംകഷണമായി അദ്ദേഹത്തിന്റെ കൈയിൽ കൊടുത്തു. അദ്ദേഹം അതു യാഗപീഠത്തിൽ ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","അദ്ദേഹം ആന്തരികാവയവങ്ങളും കാലുകളും കഴുകി അവയെ യാഗപീഠത്തിൽ ഹോമയാഗത്തിനുമീതേ ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","അഹരോൻ പിന്നീടു ജനത്തിനുവേണ്ടിയുള്ള വഴിപാടുകൊണ്ടുവന്നു. അദ്ദേഹം ജനത്തിന്റെ പാപശുദ്ധീകരണയാഗത്തിനുള്ള കോലാടിനെ എടുത്ത് അതിനെ അറത്ത് ആദ്യത്തേതിനെ ചെയ്തതുപോലെ പാപശുദ്ധീകരണയാഗമായി അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","അദ്ദേഹം ഹോമയാഗം കൊണ്ടുവന്നു നിർദിഷ്ടരീതിയിൽ അതിനെ അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","അദ്ദേഹം രാവിലത്തെ ഹോമയാഗത്തിനുപുറമേ ഭോജനയാഗവും കൊണ്ടുവന്ന് അതിൽനിന്ന് ഒരുപിടിധാന്യം എടുത്തു യാഗപീഠത്തിൽ ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","അദ്ദേഹം കാളയെയും ആട്ടുകൊറ്റനെയും ജനത്തിനുവേണ്ടിയുള്ള സമാധാനയാഗമായി അറത്തു. അഹരോന്റെ പുത്രന്മാർ രക്തം അദ്ദേഹത്തിന്റെ കൈയിൽ കൊടുത്തു. അദ്ദേഹം അതു യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","എന്നാൽ അവർ കാളയുടെയും ആട്ടുകൊറ്റന്റെയും മേദസ്സ്, തടിച്ചവാൽ, ആന്തരികാവയവങ്ങൾ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സ്, വൃക്കകൾ, കരളിന്മേലുള്ള കൊഴുപ്പ് ");
INSERT INTO malc_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","എന്നിവ നെഞ്ചിന്മേൽവെച്ചു. എന്നിട്ട് അഹരോൻ മേദസ്സു യാഗപീഠത്തിൽ ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","മോശ കൽപ്പിച്ചതുപോലെ അഹരോൻ നെഞ്ചും വലതുതുടയും യഹോവയുടെമുമ്പാകെ ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","പിന്നെ അഹരോൻ കൈകൾ ഉയർത്തി ജനത്തിനുനേരേ അവരെ അനുഗ്രഹിച്ചു. പാപശുദ്ധീകരണയാഗവും ഹോമയാഗവും സമാധാനയാഗവും അർപ്പിച്ചിട്ട് അദ്ദേഹം താഴേക്കിറങ്ങി. ");
INSERT INTO malc_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","മോശയും അഹരോനും പിന്നെ സമാഗമകൂടാരത്തിനകത്തുപോയി. അവർ പുറത്തുവന്ന് ജനത്തെ ആശീർവദിച്ചു; യഹോവയുടെ തേജസ്സ് സകലജനത്തിനും പ്രത്യക്ഷമായി. ");
INSERT INTO malc_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","യഹോവയുടെ സന്നിധിയിൽനിന്ന് തീ പുറപ്പെട്ടു ഹോമയാഗമൃഗത്തെയും യാഗപീഠത്തിന്മേലിരുന്ന മേദസ്സിനെയും ദഹിപ്പിച്ചു. അതുകണ്ടപ്പോൾ ജനമെല്ലാം ആനന്ദത്താൽ ആർത്തു സാഷ്ടാംഗം വീണു. ");
INSERT INTO malc_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","അഹരോന്റെ പുത്രന്മാരായ നാദാബും അബീഹൂവും തങ്ങളുടെ ധൂപകലശങ്ങൾ എടുത്ത് അതിൽ തീയിട്ടു സുഗന്ധദ്രവ്യവും ചേർത്തു; തങ്ങളോടു കൽപ്പിച്ചതല്ലാത്ത അന്യാഗ്നി യഹോവയുടെമുമ്പിൽ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","അപ്പോൾ യഹോവയുടെ സന്നിധിയിൽനിന്ന് തീ പുറപ്പെട്ട് അവരെ ദഹിപ്പിച്ചു, അവർ യഹോവയുടെ സന്നിധിയിൽ മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","മോശ അഹരോനോടു പറഞ്ഞു, “യഹോവ അരുളിച്ചെയ്തപ്പോൾ പറഞ്ഞതിതാണ്: “ ‘എന്നോട് അടുത്തുവരുന്നവരിലൂടെ ഞാൻ എന്റെ പരിശുദ്ധി തെളിയിക്കും; സർവജനത്തിന്റെയും മുമ്പിൽ ഞാൻ മഹത്ത്വപ്പെടും.’ ” അഹരോൻ മൗനമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","മോശ അഹരോന്റെ പിതൃസഹോദരനായ ഉസ്സീയേലിന്റെ പുത്രന്മാരായ മീശായേലിനെയും എത്സാഫാനെയും വിളിപ്പിച്ച് അവരോടു പറഞ്ഞു: “ഇവിടെ വരിക, നിങ്ങളുടെ സഹോദരന്മാരെ വിശുദ്ധമന്ദിരത്തിന്റെ മുമ്പിൽനിന്ന് പാളയത്തിനുപുറത്ത് അകലെ കൊണ്ടുപോകുക.” ");
INSERT INTO malc_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","അങ്ങനെ അവർ വന്നു, മോശ കൽപ്പിച്ചതുപോലെ അവരുടെ കുപ്പായങ്ങളോടുകൂടെ പാളയത്തിനുപുറത്തു കൊണ്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","പിന്നെ മോശ അഹരോനോടും അദ്ദേഹത്തിന്റെ പുത്രന്മാരായ എലെയാസാരോടും ഈഥാമാരോടും പറഞ്ഞു: “നിങ്ങൾ മരിക്കാതിരിക്കേണ്ടതിനും സർവസഭയുടെയുംമേൽ കോപം വരാതിരിക്കേണ്ടതിനും നിങ്ങൾ തലമുടി ചീകാതിരിക്കുകയോ വസ്ത്രം കീറുകയോ അരുത്. എന്നാൽ നിങ്ങളുടെ സഹോദരന്മാരായ ഇസ്രായേൽഗൃഹം മുഴുവനും യഹോവ തീയാൽ നശിപ്പിച്ചവരെച്ചൊല്ലി വിലപിക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","നിങ്ങൾ മരിക്കാതിരിക്കേണ്ടതിന് സമാഗമകൂടാരത്തിന്റെ കവാടം വിട്ടുപോകരുത്. കാരണം, യഹോവയുടെ അഭിഷേകതൈലം നിങ്ങളുടെമേൽ ഇരിക്കുന്നു.” അങ്ങനെ അവർ മോശ കൽപ്പിച്ചതുപോലെ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","പിന്നീടു യഹോവ അഹരോനോടു പറഞ്ഞു: ");
INSERT INTO malc_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“നിങ്ങൾ മരിക്കാതിരിക്കേണ്ടതിന്, സമാഗമകൂടാരത്തിനകത്തു പോകുമ്പോൾ ഒരിക്കലും നീയും നിന്റെ പുത്രന്മാരും വീഞ്ഞോ മദ്യമോ കുടിക്കരുത്. ഇതു വരാനുള്ള തലമുറകൾക്ക് എന്നും നിലനിൽക്കുന്ന നിയമം ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ഇങ്ങനെ നിങ്ങൾക്കു വിശുദ്ധവും സാധാരണവുംതമ്മിലും ശുദ്ധവും അശുദ്ധവുംതമ്മിലും വേർതിരിച്ചറിയാം. ");
INSERT INTO malc_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","യഹോവ മോശമുഖാന്തരം ഇസ്രായേൽമക്കൾക്കു കൊടുത്ത എല്ലാ ഉത്തരവുകളും നീ അവരെ പഠിപ്പിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","മോശ അഹരോനോടും അദ്ദേഹത്തിന്റെ ശേഷിച്ച പുത്രന്മാരായ എലെയാസാരോടും ഈഥാമാരോടും പറഞ്ഞു: “യഹോവയ്ക്കു ദഹനയാഗം അർപ്പിച്ചതിനുശേഷമുള്ള ഭോജനയാഗം എടുത്ത്, പുളിപ്പില്ലാതെ ഒരുക്കി യാഗപീഠത്തിന്റെ വശത്തുവെച്ച് ഭക്ഷിക്കുക; കാരണം അത് അതിവിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","യഹോവയ്ക്ക് അർപ്പിക്കുന്ന ദഹനയാഗങ്ങളിൽ അതു നിന്റെയും നിന്റെ പുത്രന്മാരുടെയും ഓഹരിയാണ്. അതു വിശുദ്ധസ്ഥലത്തുവെച്ചു ഭക്ഷിക്കണം. ഇങ്ങനെ എന്നോടു കൽപ്പിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","എന്നാൽ നിനക്കും നിന്റെ പുത്രന്മാർക്കും പുത്രിമാർക്കും യഹോവയുടെ സന്നിധിയിൽ ഉയർത്തി അർപ്പിച്ച നെഞ്ചും വിശിഷ്ടയാഗാർപ്പണമായ തുടയും ഭക്ഷിക്കാം. ആചാരപരമായി ശുദ്ധിയുള്ള ഒരു സ്ഥലത്തുവെച്ച് അവ ഭക്ഷിക്കണം. ഇസ്രായേല്യരുടെ സമാധാനയാഗത്തിൽ നിനക്കും നിന്റെ മക്കൾക്കും നിങ്ങളുടെ ഓഹരിയായി അവ നൽകപ്പെട്ടിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","വിശിഷ്ടയാഗാർപ്പണമായ തുടയും ഉയർത്തി അർപ്പിക്കാനുള്ള നെഞ്ചും ദഹനയാഗങ്ങളുടെ മേദസ്സോടുകൂടെ യഹോവയുടെ സന്നിധിയിൽ കൊണ്ടുവന്ന് ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി അർപ്പിക്കണം. യഹോവ കൽപ്പിച്ചതുപോലെ ഇതു നിന്റെയും നിന്റെ മക്കളുടെയും ശാശ്വതാവകാശം ആയിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","പാപശുദ്ധീകരണയാഗത്തിന്റെ കോലാടിനെക്കുറിച്ച് അന്വേഷിച്ചപ്പോൾ അതു ദഹിപ്പിച്ചുപോയി എന്നുകണ്ട് അഹരോന്റെ ശേഷിച്ച പുത്രന്മാരായ എലെയാസാരോടും ഈഥാമാരോടും മോശ കോപിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ആ പാപശുദ്ധീകരണയാഗം നിങ്ങൾ വിശുദ്ധസ്ഥലത്തുവെച്ച് ഭക്ഷിക്കാഞ്ഞതെന്ത്? അത് അതിവിശുദ്ധമല്ലോ. സഭയുടെ അകൃത്യം അകറ്റിക്കളയാനും അവർക്കുവേണ്ടി യഹോവയുടെ സന്നിധിയിൽ പ്രായശ്ചിത്തം ചെയ്യാനുമാണ് അതു നിങ്ങൾക്കു നൽകിയിരിക്കുന്നത്. ");
INSERT INTO malc_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","അതിന്റെ രക്തം വിശുദ്ധമന്ദിരത്തിൽ കൊണ്ടുവരാഞ്ഞതുകൊണ്ടു ഞാൻ കൽപ്പിച്ചതുപോലെ കോലാടിനെ നിങ്ങൾ വിശുദ്ധസ്ഥലത്തുവെച്ചു ഭക്ഷിക്കേണ്ടതായിരുന്നു.” ");
INSERT INTO malc_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","അഹരോൻ മോശയോടു മറുപടി പറഞ്ഞു: “ഇന്ന് അവർ അവരുടെ പാപശുദ്ധീകരണയാഗവും ഹോമയാഗവും യഹോവയുടെമുമ്പാകെ അർപ്പിച്ചു. എനിക്കോ ഇങ്ങനെയെല്ലാം സംഭവിച്ചു. ഇന്നു ഞാൻ പാപശുദ്ധീകരണയാഗം ഭക്ഷിച്ചിരുന്നെങ്കിൽ യഹോവ പ്രസാദിക്കുമായിരുന്നോ?” ");
INSERT INTO malc_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ഇതു കേട്ടപ്പോൾ മോശയ്ക്കു തൃപ്തിയായി. ");
INSERT INTO malc_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ഇസ്രായേല്യരോടു പറയുക: കരയിൽ ജീവിക്കുന്ന എല്ലാ മൃഗങ്ങളിലും നിങ്ങൾക്കു ഭക്ഷിക്കാവുന്നവ ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","കുളമ്പു പിളർന്നു രണ്ടായി പിരിഞ്ഞിരിക്കുന്നതും അയവിറക്കുന്നതുമായ ഏതൊരു മൃഗത്തെയും നിങ്ങൾക്കു ഭക്ഷിക്കാം. ");
INSERT INTO malc_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘ഒന്നുകിൽ അയവിറക്കുന്നവയോ അല്ലെങ്കിൽ കുളമ്പു പിളർന്നവയോ ആയിരിക്കാം ചില മൃഗങ്ങൾ. അവ നിങ്ങൾ ഭക്ഷിക്കരുത്. ഒട്ടകം അയവിറക്കുന്നെങ്കിലും കുളമ്പു പിളർന്നതല്ല; അതു നിങ്ങൾക്ക് അശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","കുഴിമുയൽ അയവിറക്കുന്നെങ്കിലും കുളമ്പു പിളർന്നതല്ല; അത് നിങ്ങൾക്ക് അശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","മുയൽ അയവിറക്കുന്നെങ്കിലും, കുളമ്പു പിളർന്നതല്ല; അതു നിങ്ങൾക്ക് അശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","പന്നിയുടെ കുളമ്പു പിരിഞ്ഞ് പൂർണമായി പിളർന്നതാണ്; എന്നാൽ അത് അയവിറക്കുന്നില്ല; അതു നിങ്ങൾക്ക് അശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","നിങ്ങൾ അവയുടെ മാംസം ഭക്ഷിക്കുകയോ അവയുടെ ശവം സ്പർശിക്കുകയോ ചെയ്യരുത്; അവ നിങ്ങൾക്ക് അശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘കടൽവെള്ളത്തിലും പുഴയിലും ജീവിക്കുന്ന എല്ലാ ജീവികളിലും ചിറകും ചെതുമ്പലും ഉള്ളവയെല്ലാം നിങ്ങൾക്കു ഭക്ഷിക്കാം. ");
INSERT INTO malc_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","എന്നാൽ കടലുകളിലും പുഴകളിലും കൂട്ടമായി ചരിക്കുന്നവയിലും വെള്ളത്തിൽ ജീവിക്കുന്ന മറ്റു ജീവികളിലും, ചിറകും ചെതുമ്പലും ഇല്ലാത്തവ നിങ്ങൾക്കു നിഷിദ്ധമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","അവ നിങ്ങൾക്ക് അറപ്പായിരിക്കണം. അവയുടെ മാംസം ഭക്ഷിക്കരുത്, അവയുടെ പിണം നിങ്ങൾക്കു നിഷിദ്ധമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","വെള്ളത്തിൽ ജീവിക്കുന്ന, ചിറകും ചെതുമ്പലുമില്ലാത്ത എന്തും നിങ്ങൾക്കു നിഷിദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘പറവകളിൽ നിങ്ങൾക്ക് നിഷിദ്ധമായിരിക്കുന്നവ ഇവയാണ്: അവ അശുദ്ധമാകുകയാൽ നിങ്ങൾ അവ ഭക്ഷിക്കരുത്: കഴുകൻ, ചെമ്പരുന്ത്, കരിമ്പരുന്ത് ");
INSERT INTO malc_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ഗൃദ്ധ്രം, ഏതിനത്തിലുംപെട്ട പരുന്ത്, ");
INSERT INTO malc_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","എല്ലാ ഇനത്തിലുംപെട്ട കാക്ക, ");
INSERT INTO malc_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ഒട്ടകപ്പക്ഷി, പുള്ള്, കടൽക്കാക്ക, എല്ലാ ഇനത്തിലുംപെട്ട കഴുകൻ, ");
INSERT INTO malc_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","നത്ത്, നീർക്കാക്ക, കൂമൻ, ");
INSERT INTO malc_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","മൂങ്ങ, വേഴാമ്പൽ, വെള്ളക്കഴുകൻ, ");
INSERT INTO malc_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","പെരിഞ്ഞാറ, ഏതിനത്തിലുംപെട്ട കൊക്ക്, കുളക്കോഴി, വവ്വാൽ. ");
INSERT INTO malc_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘ചിറകുള്ള പ്രാണികളിൽ നാലുകാലിൽ നടക്കുകയും പറക്കുകയും ചെയ്യുന്നവയെല്ലാം നിങ്ങൾക്കു നിഷിദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","നാലുകാലിൽ നടക്കുന്നെങ്കിലും നിലത്തു ചാടിനടക്കേണ്ടതിനു കാലുകളിൽ സന്ധിബന്ധമുള്ളതും ചിറകുള്ളതുമായ പ്രാണികളെ നിങ്ങൾക്കു ഭക്ഷിക്കാം. ");
INSERT INTO malc_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ഇവയിൽ ഏതിനം വെട്ടുക്കിളിയും വിട്ടിലും ചീവീടും തുള്ളനും നിങ്ങൾക്കു തിന്നാം. ");
INSERT INTO malc_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","എന്നാൽ, ചിറകും നാലു കാലുമുള്ള മറ്റെല്ലാ ജീവികളും നിങ്ങൾക്കു നിഷിദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘ഇവയാൽ നിങ്ങൾ നിങ്ങളെത്തന്നെ അശുദ്ധരാക്കും; അവയുടെ പിണം സ്പർശിക്കുന്നവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","അവയിലൊന്നിന്റെ പിണം എടുക്കുന്നവരും തങ്ങളുടെ വസ്ത്രം അലക്കണം, അവരും സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘കുളമ്പു പിരിഞ്ഞ് പൂർണമായി പിളരാത്തതും അയവിറക്കാത്തതുമായ മൃഗങ്ങളെല്ലാം നിങ്ങൾക്ക് അശുദ്ധം; അവയിലൊന്നിന്റെ പിണം തൊടുന്നവർ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","നാലുകാലിൽ നടക്കുന്ന ജീവികളിൽ ഉള്ളങ്കാൽ പതിച്ചു നടക്കുന്നവയെല്ലാം നിങ്ങൾക്ക് അശുദ്ധം; അവയിലൊന്നിന്റെ പിണം സ്പർശിക്കുന്നവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","അവയുടെ പിണം എടുക്കുന്നവർ തങ്ങളുടെ വസ്ത്രം അലക്കണം, അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ഈ മൃഗങ്ങൾ നിങ്ങൾക്ക് നിഷിദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘നിലത്തു സഞ്ചരിക്കുന്ന ജന്തുക്കളിൽ നിങ്ങൾക്ക് അശുദ്ധമായവ ഇവയാണ്: പെരുച്ചാഴി, എലി, എല്ലാ ഇനത്തിലുംപെട്ട ഉടുമ്പ്, ");
INSERT INTO malc_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","അളുങ്ക്, ഓന്ത്, പല്ലി, അരണ, തുരപ്പൻ ");
INSERT INTO malc_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","നിലത്തു സഞ്ചരിക്കുന്ന എല്ലാവകയിലും ഇവ നിങ്ങൾക്ക് അശുദ്ധമാണ്. അവയുടെ ജഡം സ്പർശിക്കുന്നവരും സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","അവയിലൊന്നു ചത്ത് എന്തിന്മേലെങ്കിലും വീണാൽ, ആ സാധനത്തിന്റെ ഉപയോഗമെന്തായാലും, അതു മരമോ വസ്ത്രമോ തുകലോ ചാക്കുശീലയോകൊണ്ട് ഉണ്ടാക്കിയതാണെങ്കിലും അശുദ്ധമായിരിക്കും. അതു വെള്ളത്തിൽ ഇടണം; അതു സന്ധ്യവരെ അശുദ്ധമായിരിക്കും, പിന്നെ അതു ശുദ്ധമാകും. ");
INSERT INTO malc_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","അവയിലൊന്ന് ഒരു മൺപാത്രത്തിൽ വീണാൽ അതിലുള്ളതെല്ലാം അശുദ്ധമായിരിക്കും, നിങ്ങൾ ആ പാത്രം ഉടച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ഭക്ഷിക്കാൻ അനുവാദമുള്ള ഏതെങ്കിലും ആഹാരത്തിൽ അങ്ങനെയുള്ള പാത്രത്തിലെ വെള്ളം വീണാൽ അത് അശുദ്ധമാകും. അതിലുള്ള ഏതു പാനീയവും അശുദ്ധമാകും. ");
INSERT INTO malc_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","അവയിലൊന്നിന്റെ പിണം എന്തിലെങ്കിലും വീണാൽ വീഴുന്നതെന്തായാലും അത് അശുദ്ധമാകും. അത് അടുപ്പായാലും പാചകപാത്രമായാലും ഉടച്ചുകളയണം. അവ അശുദ്ധമാണ്, അവയെ അശുദ്ധമായി പരിഗണിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","എന്നാൽ ഒരു ഉറവയോ ഒരു ജലസംഭരണിയോ ശുദ്ധമായിരിക്കും; ഈ പിണങ്ങളിലൊന്നു സ്പർശിക്കുന്ന വ്യക്തി അശുദ്ധനാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","നടാനുള്ള വിത്തിൽ ഒരു പിണം വീണാൽ. അത് ശുദ്ധമായിത്തന്നെയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","എന്നാൽ വിത്തിൽ വെള്ളം ഒഴിച്ചുകഴിഞ്ഞിട്ടു പിണം അതിന്മേൽ വീണാൽ അതു നിങ്ങൾക്ക് അശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘നിങ്ങൾക്കു ഭക്ഷിക്കാൻ അനുവാദമുള്ള ഒരു മൃഗം ചത്താൽ അതിന്റെ പിണം തൊടുന്നവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ആ പിണത്തിൽനിന്ന് ഭക്ഷിക്കുന്നവർ തങ്ങളുടെ വസ്ത്രം കഴുകണം. അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ആരെങ്കിലും ആ പിണം എടുത്താൽ അയാൾ തന്റെ വസ്ത്രം കഴുകണം, അയാൾ സന്ധ്യവരെ അശുദ്ധമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘നിലത്ത് ഇഴയുന്ന എല്ലാ പ്രാണികളും നിങ്ങൾക്കു നിഷിദ്ധമാണ്; അതു ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ഉരസ്സുകൊണ്ടോ നാലുകാലുകൊണ്ടോ കൂടുതൽ കാലുകൾകൊണ്ടോ നിലത്തു ചരിക്കുന്ന ഒരു പ്രാണിയെയും നിങ്ങൾ തിന്നരുത്; അവ നിങ്ങൾക്കു നിഷിദ്ധം. ");
INSERT INTO malc_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ഇങ്ങനെയുള്ള ഏതെങ്കിലും ഇഴജാതിമൂലം നിങ്ങളെത്തന്നെ അശുദ്ധരാക്കരുത്. അവ മുഖാന്തിരമോ അവയാലോ നിങ്ങളെത്തന്നെ അശുദ്ധരാക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു; ഞാൻ വിശുദ്ധനാകുകയാൽ നിങ്ങളെത്തന്നെ ശുദ്ധീകരിച്ചു വിശുദ്ധരായിരിക്കുക. നിലത്തു സഞ്ചരിക്കുന്ന ഒരു ജീവിയാലും നിങ്ങളെത്തന്നെ അശുദ്ധരാക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","നിങ്ങളുടെ ദൈവമായിരിക്കാൻ, നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന യഹോവ ഞാനാകുന്നു; ആകയാൽ, ഞാൻ വിശുദ്ധനാകുകയാൽ, നിങ്ങളും വിശുദ്ധരായിരിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘മൃഗങ്ങളെയും പറവകളെയും ജലത്തിൽ ചരിക്കുന്ന ജീവികളെയും നിലത്തു ചരിക്കുന്ന ജീവികളെയും സംബന്ധിച്ച പ്രമാണം ഇവയാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","നിങ്ങൾക്ക് ശുദ്ധവും അശുദ്ധവുംതമ്മിലും ഭക്ഷിക്കാവുന്നവയും ഭക്ഷിക്കരുതാത്തവയുമായ ജീവികൾതമ്മിലും തരംതിരിവുണ്ടായിരിക്കണം.’ ” ");
INSERT INTO malc_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ഇസ്രായേൽമക്കളോടു പറയുക: ‘ഗർഭംധരിച്ച് ഒരു മകനെ പ്രസവിക്കുന്ന സ്ത്രീ ആർത്തവകാലത്തെന്നപോലെ ഏഴുദിവസം ആചാരപരമായി അശുദ്ധയായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","എട്ടാംദിവസം കുട്ടിയെ പരിച്ഛേദനം ചെയ്യിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ഇതിനുശേഷം സ്ത്രീ രക്തസ്രാവം നിലച്ചു ശുദ്ധിയായിത്തീരുന്നതിനു മുപ്പത്തിമൂന്നു ദിവസം കാത്തിരിക്കണം. ശുദ്ധീകരണകാലം തീരുന്നതുവരെ അവൾ വിശുദ്ധമായതൊന്നും സ്പർശിക്കരുത്; വിശുദ്ധസ്ഥലത്തു പോകുകയുമരുത്. ");
INSERT INTO malc_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","അവൾ ഒരു മകളെയാണു പ്രസവിക്കുന്നതെങ്കിൽ, ആർത്തവകാലത്തെന്നപോലെ രണ്ടാഴ്ച അവൾ അശുദ്ധയായിരിക്കും. പിന്നീട് അവൾ രക്തസ്രാവം നിലച്ചു ശുദ്ധയായിത്തീരുന്നതിന് അറുപത്താറു ദിവസം കാത്തിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘മകനോ മകൾക്കോവേണ്ടിയുള്ള അവളുടെ ശുദ്ധീകരണകാലം കഴിയുമ്പോൾ, ഒരുവയസ്സുള്ള ഒരു ആട്ടിൻകുട്ടിയെ ഹോമയാഗത്തിനായും ഒരു പ്രാവിൻകുഞ്ഞിനെയോ കുറുപ്രാവിനെയോ പാപശുദ്ധീകരണയാഗത്തിനായും സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","പുരോഹിതൻ അവ യഹോവയുടെ സന്നിധിയിൽ പ്രായശ്ചിത്തമായി അർപ്പിക്കണം. അപ്പോൾ ആചാരപരമായി അവൾ രക്തസ്രാവത്തിൽനിന്ന് ശുദ്ധയാകും. “ ‘ആൺകുഞ്ഞിനെയോ പെൺകുഞ്ഞിനെയോ പ്രസവിക്കുന്ന സ്ത്രീക്കുള്ള ചട്ടങ്ങളാണിവ. ");
INSERT INTO malc_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","അവൾക്ക് ഒരാട്ടിൻകുട്ടിക്കു വകയില്ലെങ്കിൽ, രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ, ഒന്നു ഹോമയാഗത്തിനും മറ്റേതു പാപശുദ്ധീകരണയാഗത്തിനുമായി കൊണ്ടുവരണം. ഈ വിധം പുരോഹിതൻ അവൾക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യണം, എന്നാൽ അവൾ ശുദ്ധയാകും.’ ” ");
INSERT INTO malc_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ആരുടെയെങ്കിലും ത്വക്കിൽ ഗുരുതരമായ കുഷ്ഠമാകാവുന്ന വീക്കമോ ചുണങ്ങോ തെളിഞ്ഞപുള്ളിയോ ഉണ്ടെങ്കിൽ അയാളെ പുരോഹിതനായ അഹരോന്റെയോ അദ്ദേഹത്തിന്റെ പുത്രന്മാരിൽ ഒരു പുരോഹിതന്റെയോ അടുക്കൽ കൊണ്ടുപോകണം. ");
INSERT INTO malc_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","പുരോഹിതൻ അയാളുടെ ത്വക്കിന്മേലുള്ള വടു പരിശോധിക്കണം, വടുവിന്മേലുള്ള രോമം വെളുപ്പായി കാണുകയും വടു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞിരിക്കയും ചെയ്താൽ അതു കുഷ്ഠലക്ഷണം. പുരോഹിതൻ പരിശോധിച്ച് ആ വ്യക്തിയെ ആചാരപരമായി അശുദ്ധമെന്നു വിധിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","അയാളുടെ ത്വക്കിലെ വടു വെളുത്തതും ത്വക്കിനെക്കാൾ കുഴിഞ്ഞല്ലാതെയും അതിനുള്ളിലെ രോമം വെളുത്തല്ലാതെയും കണ്ടാൽ പുരോഹിതൻ ആ വ്യക്തിയെ ഏഴുദിവസം തനിച്ചു പാർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ഏഴാംദിവസം പുരോഹിതൻ അയാളെ പരിശോധിക്കണം. വടു ത്വക്കിൽ പടരാതെയും മാറ്റമില്ലാതെയുമിരിക്കുന്നെങ്കിൽ അദ്ദേഹം അയാളെ ഏഴുദിവസത്തേക്കുകൂടെ തനിച്ചു പാർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ഏഴാംദിവസം പുരോഹിതൻ ആ മനുഷ്യനെ വീണ്ടും പരിശോധിക്കണം. വടു മങ്ങിയതായും ത്വക്കിൽ പടരാതിരിക്കുന്നതായും കണ്ടാൽ, പുരോഹിതൻ അയാളെ ശുദ്ധമെന്നു പ്രഖ്യാപിക്കണം. അതു വെറും ചുണങ്ങ് അത്രേ, ആ മനുഷ്യൻ തന്റെ വസ്ത്രം കഴുകണം, അയാൾ ശുദ്ധനാവും. ");
INSERT INTO malc_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ശുദ്ധീകരണത്തിനായി അയാൾ പുരോഹിതനു തന്നെത്തന്നെ കാണിച്ചശേഷം ചുണങ്ങ് വീണ്ടും അയാളുടെ ത്വക്കിൽ പടർന്നാൽ ആ വ്യക്തി വീണ്ടും പുരോഹിതന്റെ മുമ്പാകെ വരണം. ");
INSERT INTO malc_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","പുരോഹിതൻ അയാളെ പരിശോധിക്കണം, ചുണങ്ങ് ത്വക്കിൽ പടർന്നിട്ടുണ്ടെങ്കിൽ അദ്ദേഹം അയാളെ അശുദ്ധനെന്നു വിധിക്കണം, അതു കുഷ്ഠംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ആർക്കെങ്കിലും ഗുരുതരമായ കുഷ്ഠരോഗത്തിന്റെ ലക്ഷണം കണ്ടാൽ അയാളെ പുരോഹിതന്റെയടുക്കൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","പുരോഹിതൻ അയാളെ പരിശോധിക്കണം. ത്വക്കിൽ വെളുത്ത തിണർപ്പും അതിൽ രോമവും തിണർപ്പിൽ പച്ചമാംസവുമുണ്ടെങ്കിൽ അതു പഴക്കമുള്ള കുഷ്ഠരോഗമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","പുരോഹിതൻ അയാളെ അശുദ്ധനെന്നു പ്രഖ്യാപിക്കണം. അയാൾ അശുദ്ധനാണെന്നതുകൊണ്ടു തനിച്ചു പാർപ്പിക്കേണ്ട കാര്യമില്ല. ");
INSERT INTO malc_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“രോഗബാധിതനായ മനുഷ്യന്റെ ശരീരംമുഴുവനും തലമുതൽ പാദംവരെ പുരോഹിതനു കാണാവുന്നിടമെല്ലാം രോഗം പടർന്നുമൂടിയാൽ ");
INSERT INTO malc_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","പുരോഹിതൻ അയാളെ പരിശോധിക്കണം. രോഗം അയാളുടെ ശരീരമെല്ലാം മൂടിയെങ്കിൽ അദ്ദേഹം ആ വ്യക്തിയെ ശുദ്ധനെന്നു പ്രഖ്യാപിക്കണം. സമൂലം വെളുത്തതുകൊണ്ട് അയാൾ ശുദ്ധനാണ്. ");
INSERT INTO malc_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","എന്നാൽ അയാളിൽ പച്ചമാംസം കണ്ടാൽ, അയാൾ അശുദ്ധനാകും. ");
INSERT INTO malc_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","പുരോഹിതൻ പച്ചമാംസം കാണുന്നെങ്കിൽ അദ്ദേഹം അയാളെ അശുദ്ധനെന്നു വിധിക്കണം; പച്ചമാംസം അശുദ്ധം. അയാൾക്കു ഗുരുതരമായ കുഷ്ഠരോഗമുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","പച്ചമാംസം മാറി വെളുത്താൽ അയാൾ പുരോഹിതന്റെ അടുക്കൽ പോകണം. ");
INSERT INTO malc_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","പുരോഹിതൻ അയാളെ പരിശോധിക്കണം. വടുക്കൾ വെളുപ്പായിട്ടുണ്ടെങ്കിൽ പുരോഹിതൻ രോഗം ബാധിച്ചയാൾ ശുദ്ധമെന്നു പ്രഖ്യാപിക്കണം; അയാൾ ശുദ്ധനാകും. ");
INSERT INTO malc_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ഒരാൾക്കു തന്റെ ത്വക്കിൽ ഒരു പരു ഉണ്ടായിട്ട് അതു സുഖമാവുമ്പോൾ, ");
INSERT INTO malc_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","പരു ഉണ്ടായിരുന്ന സ്ഥാനത്തു, വെളുത്ത വീക്കമോ, ചെമപ്പുകലർന്ന വെള്ളപ്പുള്ളിയോ ഉണ്ടായാൽ അയാൾ തന്നെത്തന്നെ പുരോഹിതനു കാണിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","പുരോഹിതൻ അതു പരിശോധിക്കണം. അതു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞും അതിലെ രോമം വെളുത്തതായും കണ്ടാൽ പുരോഹിതൻ അയാളെ അശുദ്ധമെന്നു വിധിക്കണം. അതു പരുവിൽനിന്നുണ്ടായ ഗുരുതരമായ കുഷ്ഠരോഗമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","എന്നാൽ, പുരോഹിതൻ പരിശോധിക്കുമ്പോൾ അതിൽ വെളുത്തരോമം ഇല്ലാതെയും അതു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞല്ലാതെയും മങ്ങിയുമിരുന്നാൽ, പുരോഹിതൻ അയാളെ ഏഴുദിവസം തനിച്ചു പാർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","അതു ത്വക്കിൽ പടരുന്നെങ്കിൽ പുരോഹിതൻ അയാളെ അശുദ്ധമെന്നു പ്രഖ്യാപിക്കണം, അതു ഗുരുതരമായ കുഷ്ഠലക്ഷണംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","എന്നാൽ ആ ഭാഗം മാറ്റമില്ലാതെയും പടരാതെയും ഇരുന്നാൽ അതു പരുവിന്റെ വെറും പാടാണ്, പുരോഹിതൻ അയാളെ ശുദ്ധമെന്നു പ്രഖ്യാപിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ഒരാൾക്കു ത്വക്കിൽ പൊള്ളൽ ഉണ്ടായിട്ടു ചെമപ്പുകലർന്ന വെളുപ്പോ വെളുപ്പുമാത്രമോ പൊള്ളലേറ്റിടത്തെ പച്ചമാംസത്തിൽ കണ്ടാൽ, ");
INSERT INTO malc_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","പുരോഹിതൻ അവിടം പരിശോധിക്കണം. അതിലെ രോമം വെളുത്തതായും ത്വക്കിനെക്കാൾ കുഴിവായും കണ്ടാൽ അതു പൊള്ളലിൽനിന്നുണ്ടായ ഗുരുതരമായ കുഷ്ഠം. പുരോഹിതൻ അയാളെ അശുദ്ധമെന്നു പ്രഖ്യാപിക്കണം; അതു ഗുരുതരമായ കുഷ്ഠംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","എന്നാൽ പുരോഹിതൻ പരിശോധിക്കുമ്പോൾ അതിൽ വെളുത്തരോമം ഇല്ലാതെയും അതു ത്വക്കിനെക്കാൾ കുഴിയാതെയും മങ്ങിയുമിരുന്നാൽ, പുരോഹിതൻ അയാളെ ഏഴുദിവസം തനിച്ചു പാർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ഏഴാംദിവസം പുരോഹിതൻ അയാളെ പരിശോധിക്കണം. അതു ത്വക്കിൽ പടരുന്നെങ്കിൽ പുരോഹിതൻ അയാളെ അശുദ്ധമെന്നു വിധിക്കണം. അതു ഗുരുതരമായ കുഷ്ഠംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","എങ്കിലും ആ ഭാഗം മാറ്റമില്ലാതെയും ത്വക്കിൽ പടരാതെയും നിറം മങ്ങിയുമിരുന്നാൽ അതു പൊള്ളലിൽനിന്നുണ്ടായ തിണർപ്പാണ്. പുരോഹിതൻ അയാളെ ശുദ്ധമെന്നു പ്രഖ്യാപിക്കണം. അതു തീപ്പൊള്ളലിന്റെ വെറും തിണർപ്പാണ്. ");
INSERT INTO malc_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ഒരു പുരുഷനോ സ്ത്രീക്കോ തലയിലോ താടിയിലോ ഒരു വടു ഉണ്ടെങ്കിൽ ");
INSERT INTO malc_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","പുരോഹിതൻ വടു പരിശോധിക്കണം. അതു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞും അതിലുള്ള രോമം മഞ്ഞളിച്ചും നേർത്തും കണ്ടാൽ പുരോഹിതൻ, ആ വ്യക്തി അശുദ്ധമായി എന്നു പ്രഖ്യാപിക്കണം; അതു തലയിലോ താടിയിലോ ഉള്ള ചിരങ്ങാണ്. ");
INSERT INTO malc_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","എന്നാൽ പുരോഹിതൻ ഈമാതിരി വടു പരിശോധിക്കുമ്പോൾ, അതു ത്വക്കിനെക്കാൾ കുഴിയാതെയും അതിൽ കറുത്തരോമം ഇല്ലാതെയും കണ്ടാൽ പുരോഹിതൻ, ബാധിക്കപ്പെട്ട വ്യക്തിയെ ഏഴുദിവസം തനിച്ചു പാർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ഏഴാംദിവസം പുരോഹിതൻ വടു പരിശോധിക്കണം. ആ ചിരങ്ങു പടരാതിരിക്കുകയും മഞ്ഞരോമം ഇല്ലാതിരിക്കുകയും ത്വക്കിനെക്കാൾ കുഴിഞ്ഞു കാണാതിരിക്കുകയും ചെയ്താൽ ");
INSERT INTO malc_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","രോഗമുള്ള ഭാഗം ഒഴികെ ആ വ്യക്തിയെ ക്ഷൗരംചെയ്യിക്കണം. പുരോഹിതൻ അയാളെ വീണ്ടും ഏഴുദിവസം തനിച്ചു പാർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ഏഴാംദിവസം പുരോഹിതൻ ചിരങ്ങു പരിശോധിക്കണം. അതു ത്വക്കിൽ പടരാതിരിക്കുകയും ത്വക്കിനെക്കാൾ കുഴിഞ്ഞു കാണാതിരിക്കുകയും ചെയ്താൽ പുരോഹിതൻ ആ വ്യക്തി ശുദ്ധമായി എന്നു പ്രഖ്യാപിക്കണം. അയാൾ തന്റെ വസ്ത്രം കഴുകണം; അങ്ങനെ ആ വ്യക്തി ആചാരപരമായി ശുദ്ധമായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","അയാളെ ശുദ്ധിയുള്ള വ്യക്തിയെന്നു പ്രഖ്യാപിച്ചശേഷം ചിരങ്ങു പടരുകയാണെങ്കിൽ, ");
INSERT INTO malc_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","പുരോഹിതൻ അയാളെ പരിശോധിക്കണം. ചിരങ്ങു ത്വക്കിൽ പടർന്നിട്ടുണ്ടെങ്കിൽ പുരോഹിതൻ മഞ്ഞരോമം നോക്കേണ്ട ആവശ്യമില്ല; ആ വ്യക്തി അശുദ്ധമായിത്തീർന്നിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","എങ്കിലും അദ്ദേഹത്തിന്റെ നിർണയത്തിൽ അതു മാറ്റമില്ലാതിരിക്കുകയും അതിൽ കറുത്തരോമം വളർന്നിരിക്കയുമാണെങ്കിൽ ചിരങ്ങു സൗഖ്യമായി. അയാൾ ശുദ്ധമാണ്. പുരോഹിതൻ അയാൾ ശുദ്ധമെന്നു പ്രഖ്യാപിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ഒരു പുരുഷനോ സ്ത്രീക്കോ ത്വക്കിൽ വെളുത്തപുള്ളി ഉണ്ടായാൽ, ");
INSERT INTO malc_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","പുരോഹിതൻ ആ വ്യക്തിയെ പരിശോധിക്കണം. പുള്ളികൾ മങ്ങിയ വെളുപ്പാണെങ്കിൽ, അതു ത്വക്കിലുണ്ടായ ഗുരുതരമല്ലാത്ത തടിപ്പാണ്. ആ വ്യക്തി ശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ഒരു പുരുഷന്റെ തലമുടി കൊഴിഞ്ഞ് കഷണ്ടിയായാൽ അയാൾ ശുദ്ധനാണ്. ");
INSERT INTO malc_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","തലയുടെ മുൻവശത്തെ മുടി കൊഴിഞ്ഞുപോയാൽ, അയാളുടേത് മുൻകഷണ്ടിയാണ്; അയാൾ ശുദ്ധനാണ്. ");
INSERT INTO malc_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","എന്നാൽ അയാളുടെ കഷണ്ടിയിൽ മുന്നിലോ പിന്നിലോ ചെമപ്പുകലർന്ന വെളുത്തപുള്ളി ഉണ്ടെങ്കിൽ അത് അയാളുടെ തലയിലോ നെറ്റിയിലോ ഉണ്ടായ ഗുരുതരമായ കുഷ്ഠം. ");
INSERT INTO malc_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","പുരോഹിതൻ അയാളെ പരിശോധിക്കണം. അയാളുടെ തലയിലോ നെറ്റിയിലോ കാണപ്പെട്ട തിണർപ്പോടുകൂടിയ വടു ഗുരുതരമായ കുഷ്ഠംപോലെ ചെമപ്പുകലർന്ന വെളുപ്പാണെങ്കിൽ, ");
INSERT INTO malc_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ആ മനുഷ്യൻ രോഗിയും അശുദ്ധനുമാണ്. പുരോഹിതൻ അയാളെ അശുദ്ധനെന്നു വിധിക്കണം. കാരണം അയാളുടെ തലയിൽ കുഷ്ഠരോഗമുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“കുഷ്ഠരോഗി കീറിയ വസ്ത്രംധരിച്ച്, തലമുടി ചീകാതെ മുഖത്തിന്റെ കീഴ്ഭാഗം മറച്ചുകൊണ്ട്, ‘അശുദ്ധം! അശുദ്ധം!’ എന്നു വിളിച്ചുപറയണം. ");
INSERT INTO malc_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","അയാൾക്കു രോഗബാധയുള്ളിടത്തോളം അയാൾ അശുദ്ധമായിരിക്കും. അയാൾ പാളയത്തിനുപുറത്തു തനിച്ചു പാർക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ഏതെങ്കിലും കമ്പിളിവസ്ത്രമോ ചണവസ്ത്രമോ ചണം അഥവാ, കമ്പിളികൊണ്ടു നെയ്തതും ");
INSERT INTO malc_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","മെടഞ്ഞതുമായ വസ്ത്രമോ തുകൽ അഥവാ, ഏതെങ്കിലും തുകലുൽപ്പന്നമോ കുഷ്ഠത്തിന്റെ വടുകൊണ്ടു മലിനമായാൽ: ");
INSERT INTO malc_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","വസ്ത്രത്തിലോ തുകലിലോ നെയ്ത്തിലോ മെടഞ്ഞതിലോ ഏതെങ്കിലും തുകൽസാധനത്തിലോ ഉള്ള വടു ഇളം പച്ചയോ ഇളം ചെമപ്പോ ആണെങ്കിൽ അതു കുഷ്ഠലക്ഷണം; അതു പുരോഹിതനെ കാണിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","പുരോഹിതൻ വടു പരിശോധിച്ച് അതു ബാധിക്കപ്പെട്ട വസ്തു ഏഴുദിവസം മാറ്റിവെക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ഏഴാംദിവസം അദ്ദേഹം അതു വീണ്ടും പരിശോധിക്കണം; വടു വസ്ത്രത്തിലോ നെയ്തതോ മെടഞ്ഞതോ ആയ സാധനത്തിലോ എന്തുപയോഗത്തിനുള്ള തുകലായാലും അതിലോ പടർന്നിട്ടുണ്ടെങ്കിൽ അതു കഠിനകുഷ്ഠം; ആ സാധനം അശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","അദ്ദേഹം—മാലിന്യമുള്ള ആ വസ്ത്രമോ നെയ്തതോ മെടഞ്ഞതോ ആയ കമ്പിളിയോ ചണമോ ഏതെങ്കിലും തുകലുൽപ്പന്നമോ—ആ വടു ഗുരുതരമായതുകൊണ്ട് ആ വസ്തു കത്തിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“എന്നാൽ പുരോഹിതൻ പരിശോധിക്കുമ്പോൾ, വസ്ത്രത്തിലോ നെയ്തതോ മെടഞ്ഞതോ ആയ സാധനത്തിലോ തുകൽസാധനത്തിലോ വടു പടർന്നിട്ടില്ലെങ്കിൽ, ");
INSERT INTO malc_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","അദ്ദേഹം അതു കഴുകാൻ കൽപ്പിക്കണം. പിന്നെ ഏഴുദിവസംകൂടെ അതു മാറ്റിവെക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ബാധിക്കപ്പെട്ട സാധനം കഴുകിയശേഷം പുരോഹിതൻ പരിശോധിക്കണം. അതു നിറംമാറാതെയും പരക്കാതെയും ഇരുന്നാൽ, അത് അശുദ്ധമാണ്. വടു ഒരുവശത്തോ മറുവശത്തോ ബാധിച്ചിട്ടുള്ളതെന്തായാലും അതിനെ കത്തിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","പുരോഹിതൻ പരിശോധിക്കുമ്പോൾ ആ സാധനം കഴുകിയശേഷം വടു മങ്ങിയിരുന്നാൽ, അദ്ദേഹം വസ്ത്രത്തിലോ തുകലിലോ നെയ്തതോ മെടഞ്ഞതോ ആയ സാധനത്തിലോനിന്ന് മലിനമായ ഭാഗം കീറിക്കളയണം. ");
INSERT INTO malc_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","എന്നാൽ, വസ്ത്രത്തിലോ നെയ്തതോ മെടഞ്ഞതോ ആയ തുണിത്തരത്തിലോ തുകൽസാധനത്തിലോ അതു പിന്നെയും കാണുന്നെങ്കിൽ, അതു പടരുന്നതാണ്. വടുവുള്ളതെന്തും തീയിൽ കത്തിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","വസ്ത്രമോ നെയ്തതോ മെടഞ്ഞതോ ആയ തുണിത്തരമോ ഏതെങ്കിലും തുകൽസാധനമോ കഴുകിയശേഷം വടു മാറിയെങ്കിൽ, വീണ്ടും കഴുകണം, അതു ശുദ്ധമാകും.” ");
INSERT INTO malc_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","കമ്പിളി വസ്ത്രത്തിലോ ചണവസ്ത്രത്തിലോ നെയ്തതോ മെടഞ്ഞതോ ആയ തുണിത്തരത്തിലോ ഏതെങ്കിലും തുകൽസാധനത്തിലോ ഉള്ള വടുകൊണ്ടുള്ള മാലിന്യം സംബന്ധിച്ച്, അവയെ ശുദ്ധമെന്നും അശുദ്ധമെന്നും പ്രഖ്യാപിക്കാനുള്ള പ്രമാണങ്ങൾ ഇവയാണ്. ");
INSERT INTO malc_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“കുഷ്ഠരോഗിയെ പുരോഹിതന്റെയടുക്കൽ കൊണ്ടുവരുമ്പോൾ ആചാരപരമായ ശുദ്ധീകരണം സംബന്ധിച്ചുള്ള പ്രമാണങ്ങൾ ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","പുരോഹിതൻ പാളയത്തിനു പുറത്തുപോയി ആ മനുഷ്യനെ പരിശോധിക്കണം. അയാളുടെ കുഷ്ഠരോഗം സുഖമായി എന്നു കണ്ടാൽ, ");
INSERT INTO malc_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ശുദ്ധീകരിക്കപ്പെടേണ്ടയാൾക്കുവേണ്ടി, ജീവനും ശുദ്ധിയുമുള്ള രണ്ടുപക്ഷികൾ, ദേവദാരുത്തടി, ചെമപ്പുനൂൽ, ഈസോപ്പ് എന്നിവ കൊണ്ടുവരാൻ പുരോഹിതൻ കൽപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","പിന്നെ പുരോഹിതൻ പക്ഷികളിലൊന്നിനെ ശുദ്ധജലം നിറഞ്ഞിരിക്കുന്ന മൺപാത്രത്തിനുമീതേവെച്ച് കൊല്ലുന്നതിനു കൽപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","പിന്നീട് അദ്ദേഹം ജീവനുള്ള പക്ഷിയെ എടുത്തു ദേവദാരുത്തടി, ചെമപ്പുനൂൽ, ഈസോപ്പ് എന്നിവയോടൊപ്പം, കൊന്ന പക്ഷിയുടെ രക്തംകലർന്ന ശുദ്ധജലത്തിൽ മുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ആ രക്തം അദ്ദേഹം കുഷ്ഠരോഗത്തിൽനിന്ന് ശുദ്ധീകരിക്കപ്പെടേണ്ട ആളിന്റെമേൽ ഏഴുപ്രാവശ്യം തളിച്ച് അയാൾ ശുദ്ധമായി എന്നു പ്രഖ്യാപിക്കണം. പിന്നെ അദ്ദേഹം ജീവനുള്ള പക്ഷിയെ തുറസ്സായസ്ഥലത്തു തുറന്നുവിടണം. ");
INSERT INTO malc_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“ശുദ്ധീകരിക്കപ്പെടേണ്ടയാൾ വസ്ത്രം കഴുകി, രോമമെല്ലാം വടിച്ചുകളഞ്ഞു വെള്ളത്തിൽ കുളിക്കണം; അപ്പോൾ ആ മനുഷ്യൻ ആചാരപരമായി ശുദ്ധമായിത്തീരും. അതിനുശേഷം അയാൾക്കു പാളയത്തിനകത്തുവരാം, എന്നാൽ ആ മനുഷ്യൻ ഏഴുദിവസം തന്റെ കൂടാരത്തിനു വെളിയിൽ കഴിയണം. ");
INSERT INTO malc_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ഏഴാംദിവസം അയാൾ രോമമെല്ലാം വടിച്ചുകളയണം; തലയും താടിയും കൺപുരികങ്ങളും ഉൾപ്പെടെ തന്റെ ശേഷിച്ച എല്ലാ രോമവും വടിച്ചുകളയണം. അയാൾ വസ്ത്രം കഴുകി വെള്ളത്തിൽ തന്നെത്താൻ കുളിക്കണം. ഇങ്ങനെ ആ മനുഷ്യൻ ആചാരപരമായി ശുദ്ധനാകും. ");
INSERT INTO malc_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“എട്ടാംദിവസം അയാൾ ഊനമില്ലാത്ത രണ്ടു കോലാട്ടിൻകുട്ടികളെയും ഒരുവയസ്സുള്ള ഊനമില്ലാത്ത ഒരു പെണ്ണാട്ടിൻകുട്ടിയെയും; ഭോജനയാഗമായി ഒലിവെണ്ണകുഴച്ച, മൂന്ന് ഓമെർ നേരിയമാവും ഒരു പാത്രം ഒലിവെണ്ണയും കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ശുദ്ധീകരണം കഴിക്കുന്ന പുരോഹിതൻ, ശുദ്ധീകരിക്കപ്പെടേണ്ട വ്യക്തിയെ അയാളുടെ വഴിപാടിനോടൊപ്പം യഹോവയുടെമുമ്പാകെ സമാഗമകൂടാരവാതിലിൽ നിർത്തണം. ");
INSERT INTO malc_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“പിന്നെ പുരോഹിതൻ കോലാട്ടിൻകുട്ടിയിൽ ഒന്നിനെ എടുത്ത് ഒലിവെണ്ണയോടൊപ്പം അകൃത്യയാഗമായി അർപ്പിക്കണം. അദ്ദേഹം അവയെ വിശിഷ്ടയാഗമായി യഹോവയുടെമുമ്പാകെ ഉയർത്തി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","പാപശുദ്ധീകരണയാഗവും ഹോമയാഗവും അറക്കുന്ന വിശുദ്ധസ്ഥലത്ത് അദ്ദേഹം ആട്ടിൻകുട്ടിയെ അറക്കണം. പാപശുദ്ധീകരണയാഗംപോലെ അകൃത്യയാഗം പുരോഹിതനുള്ളതാണ്; അത് അതിവിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","പുരോഹിതൻ അകൃത്യയാഗത്തിന്റെ കുറെ രക്തം എടുത്ത് ശുദ്ധീകരിക്കപ്പെടേണ്ട വ്യക്തിയുടെ വലതുചെവിയുടെ അറ്റത്തും വലതുകൈയിലെ തള്ളവിരലിലും വലതുകാലിന്റെ തള്ളവിരലിലും പുരട്ടണം. ");
INSERT INTO malc_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","പിന്നീടു പുരോഹിതൻ ഒലിവെണ്ണയിൽ കുറെ എടുത്തു തന്റെ ഇടത്തെ ഉള്ളംകൈയിൽ ഒഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","വലതുചൂണ്ടുവിരൽ ഉള്ളംകൈയിലെ എണ്ണയിൽ മുക്കി, അതിൽ കുറെ യഹോവയുടെമുമ്പാകെ ഏഴുപ്രാവശ്യം തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","പുരോഹിതൻ, തന്റെ ഉള്ളംകൈയിൽ ശേഷിക്കുന്ന എണ്ണ കുറെ ശുദ്ധീകരിക്കപ്പെടേണ്ട വ്യക്തിയുടെ വലതുചെവിയുടെ അറ്റത്തും വലതുകൈയിലെ തള്ളവിരലിലും വലതുകാലിന്റെ തള്ളവിരലിലും അകൃത്യയാഗത്തിന്റെ രക്തത്തിനുമീതേയും പുരട്ടണം. ");
INSERT INTO malc_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","തന്റെ ഉള്ളംകൈയിൽ ശേഷിക്കുന്ന എണ്ണ ശുദ്ധീകരിക്കപ്പെടേണ്ടയാളുടെ തലയിൽ പുരോഹിതൻ ഒഴിച്ച് അയാൾക്കുവേണ്ടി യഹോവയുടെമുമ്പാകെ പ്രായശ്ചിത്തം ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“പിന്നെ പുരോഹിതൻ പാപശുദ്ധീകരണയാഗം അർപ്പിച്ച് ശുദ്ധീകരിക്കപ്പെടേണ്ട വ്യക്തിക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യണം. അതിനുശേഷം പുരോഹിതൻ ഹോമയാഗമൃഗത്തെ അറത്തു ");
INSERT INTO malc_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ഭോജനയാഗത്തോടൊപ്പം യാഗപീഠത്തിൽ അർപ്പിച്ച് അയാൾക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യണം. എന്നാൽ ആ മനുഷ്യൻ ശുദ്ധമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“അയാൾ ദരിദ്രനും ഇവയ്ക്കു വകയില്ലാത്ത വ്യക്തിയുമാണെങ്കിൽ തനിക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യാൻ വിശിഷ്ടയാഗാർപ്പണത്തിന് അകൃത്യയാഗമായി ഒരു കോലാട്ടിൻകുട്ടിയും ഭോജനയാഗമായി ഒരു പാത്രം ഒലിവെണ്ണചേർത്ത ഒരു ഓമെർ നേർമയുള്ള മാവും ഒരു പാത്രം എണ്ണയും എടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ഒപ്പം, തന്റെ കഴിവുപോലെ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ കൊണ്ടുവരണം. അവയിലൊന്ന് പാപശുദ്ധീകരണയാഗത്തിനും മറ്റേതു ഹോമയാഗത്തിനുമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“എട്ടാംദിവസം ശുദ്ധീകരിക്കപ്പെടേണ്ടയാൾ അവ തന്റെ ശുദ്ധീകരണത്തിനായി യഹോവയുടെ സന്നിധിയിൽ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","പുരോഹിതൻ അകൃത്യയാഗത്തിനുള്ള ആട്ടിൻകുട്ടിയും ഒലിവെണ്ണയും എടുത്തു യഹോവയുടെ സന്നിധിയിൽ ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","അദ്ദേഹം അകൃത്യയാഗത്തിനുള്ള ആട്ടിൻകുട്ടിയെ അറത്ത് അതിന്റെ കുറെ രക്തം എടുത്തു ശുദ്ധീകരിക്കപ്പെടേണ്ട വ്യക്തിയുടെ വലതുചെവിയുടെ അറ്റത്തും, വലതുകൈയിലെ തള്ളവിരലിലും വലതുകാലിലെ പെരുവിരലിലും പുരട്ടണം. ");
INSERT INTO malc_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","പുരോഹിതൻ എണ്ണയിൽ കുറെ ഇടത്തെ ഉള്ളംകൈയിൽ ഒഴിച്ചു ");
INSERT INTO malc_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","തന്റെ വലതുചൂണ്ടുവിരൽകൊണ്ടു തന്റെ ഉള്ളംകൈയിലെ എണ്ണ കുറെ യഹോവയുടെമുമ്പാകെ ഏഴുപ്രാവശ്യം തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","കുറെ എണ്ണ അദ്ദേഹം, ശുദ്ധീകരിക്കപ്പെടേണ്ടയാളുടെ വലതുചെവിയുടെ അറ്റത്തും വലതുകൈയിലെ തള്ളവിരലിലും വലതുകാലിലെ പെരുവിരലിലും അകൃത്യയാഗത്തിന്റെ രക്തം പുരട്ടിയ അതേസ്ഥലങ്ങളിൽ പുരട്ടണം. ");
INSERT INTO malc_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","പുരോഹിതൻ തന്റെ ഉള്ളംകൈയിൽ ശേഷിക്കുന്ന എണ്ണ ശുദ്ധീകരിക്കപ്പെടേണ്ടയാളുടെ തലയിൽ ഒഴിച്ച് അയാൾക്കുവേണ്ടി യഹോവയുടെമുമ്പാകെ പ്രായശ്ചിത്തം ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","പിന്നെ പുരോഹിതൻ, ആ വ്യക്തിയുടെ കഴിവുപോലെ കുറുപ്രാവുകളെയും പ്രാവിൻകുഞ്ഞുങ്ങളെയും ");
INSERT INTO malc_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ഒന്നിനെ പാപശുദ്ധീകരണയാഗമായും മറ്റേതിനെ ഹോമയാഗമായും ഭോജനയാഗത്തോടുകൂടെ അർപ്പിക്കണം. ഇപ്രകാരം പുരോഹിതൻ ശുദ്ധീകരിക്കപ്പെടേണ്ടയാൾക്കുവേണ്ടി യഹോവയുടെമുമ്പാകെ പ്രായശ്ചിത്തം ചെയ്യണം.” ");
INSERT INTO malc_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ഇവ ശുദ്ധീകരണത്തിനുള്ള സാധാരണ വഴിപാടുകൾക്കു പ്രാപ്തിയില്ലാത്ത, ഗുരുതരമായ കുഷ്ഠരോഗമുള്ളവർക്കുള്ള പ്രമാണം. ");
INSERT INTO malc_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","യഹോവ മോശയോടും അഹരോനോടും ഇപ്രകാരം അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ഞാൻ നിങ്ങൾക്ക് അവകാശമായിത്തരുന്ന കനാൻദേശത്തു നിങ്ങൾ പ്രവേശിക്കുമ്പോൾ ആ ദേശത്തിലൊരു വീട്ടിൽ ഞാൻ പടരുന്ന വടു വരുത്തിയാൽ, ");
INSERT INTO malc_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","വീട്ടുടമസ്ഥൻ പുരോഹിതന്റെ അടുക്കൽവന്നു, ‘വടുപോലുള്ള ഒന്ന് എന്റെ വീട്ടിൽ കണ്ടിരിക്കുന്നു’ എന്നു പറയണം. ");
INSERT INTO malc_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","വീട്ടിലുള്ളതൊന്നും അശുദ്ധമെന്നു വിധിക്കപ്പെടാതിരിക്കാൻ, പുരോഹിതൻ വടു പരിശോധിക്കാൻ പോകുന്നതിനുമുമ്പ് വീട് ഒഴിച്ചിടാൻ കൽപ്പിക്കണം. അതിനുശേഷം പുരോഹിതൻ ചെന്നു വീട് പരിശോധിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","അദ്ദേഹം ചുമരിലെ വടു നോക്കി, അതു പച്ചയോ ചെമപ്പോ ആയി ചുമരിന്റെ പ്രതലത്തെക്കാൾ കുഴിഞ്ഞുകണ്ടാൽ, ");
INSERT INTO malc_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","പുരോഹിതൻ വീടിനു വെളിയിൽവന്ന് വീട് ഏഴുദിവസം പൂട്ടിയിടണം. ");
INSERT INTO malc_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","പുരോഹിതൻ വീട് പരിശോധിക്കാൻ ഏഴാംദിവസം തിരികെ വരണം. ചുമരിൽ വടു പടർന്നിട്ടുണ്ടെങ്കിൽ, ");
INSERT INTO malc_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","അതു ബാധിച്ചിട്ടുള്ള കല്ലുകൾ ഇളക്കിയെടുത്തു പട്ടണത്തിനുപുറത്ത് അശുദ്ധമായ ഒരിടത്ത് എറിഞ്ഞുകളയാൻ അദ്ദേഹം കൽപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","അദ്ദേഹം വീടിന്റെ അകംചുവരെല്ലാം ചുരണ്ടിക്കുകയും ചുരണ്ടിമാറ്റിയതു പട്ടണത്തിനുപുറത്ത് അശുദ്ധമായ ഒരിടത്തു കളയിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","പിന്നീട് അവർ ഇവയ്ക്കു പകരം വേറെ കല്ലു വെക്കുകയും പുതിയ കുമ്മായംകൊണ്ടു വീട് പൂശുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ആ വീട് കല്ലുകൾ മാറ്റി, ചുരണ്ടി പൂശിയതിനുശേഷം വടു വീണ്ടും പ്രത്യക്ഷപ്പെട്ടാൽ ");
INSERT INTO malc_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","പുരോഹിതൻ പോയി അതു പരിശോധിക്കണം. വടു വീട്ടിൽ പടർന്നിട്ടുണ്ടെങ്കിൽ അതു നാശകരമായ വടുവാണ്, ആ വീട് അശുദ്ധം. ");
INSERT INTO malc_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","അതിനെ ഇടിച്ചുപൊളിച്ച്, അതിന്റെ കല്ലും തടിയും കുമ്മായവുമെല്ലാം പട്ടണത്തിനുവെളിയിൽ അശുദ്ധസ്ഥലത്തു കൊണ്ടുപോയി കളയണം. ");
INSERT INTO malc_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“ആ വീട് അടച്ചിട്ടിരുന്ന കാലത്ത് അതിനകത്തു കടന്നവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ആ വീട്ടിൽവെച്ച് ആഹാരം കഴിക്കുകയോ ഉറങ്ങുകയോ ചെയ്യുന്നയാൾ തന്റെ വസ്ത്രം കഴുകണം. ");
INSERT INTO malc_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“എന്നാൽ ആ വീട് പൂശിയതിനുശേഷം പുരോഹിതൻ അതു പരിശോധിക്കാൻ വരുമ്പോൾ വടു പടർന്നിട്ടില്ലെങ്കിൽ വടു മാറിപ്പോയതുകൊണ്ട് അദ്ദേഹം അത് ശുദ്ധമെന്നു പ്രഖ്യാപിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ആ വീട് ശുദ്ധീകരിക്കാൻ അദ്ദേഹം രണ്ടുപക്ഷികൾ, ദേവദാരുത്തടി, ചെമപ്പുനൂൽ, ഈസോപ്പ് എന്നിവ എടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","അതിലൊരു പക്ഷിയെ അദ്ദേഹം മൺപാത്രത്തിലെ ശുദ്ധജലത്തിനുമീതേ അറക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","പിന്നെ അദ്ദേഹം ദേവദാരുത്തടി, ഈസോപ്പ്, ചെമപ്പുനൂൽ, ജീവനുള്ള പക്ഷി എന്നിവ എടുത്ത് കൊന്ന പക്ഷിയുടെ രക്തത്തിലും ശുദ്ധജലത്തിലും മുക്കി വീട്ടിൽ ഏഴുപ്രാവശ്യം തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","അദ്ദേഹം ആ വീടിനെ പക്ഷിയുടെ രക്തം, ശുദ്ധജലം, ജീവനുള്ള പക്ഷി, ദേവദാരുത്തടി, ഈസോപ്പ്, ചെമപ്പുനൂൽ എന്നിവകൊണ്ടു ശുദ്ധീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","പിന്നെ അദ്ദേഹം ജീവനുള്ള പക്ഷിയെ പട്ടണത്തിനുപുറത്ത് തുറസ്സായസ്ഥലത്തു തുറന്നുവിടണം. ഇങ്ങനെ അദ്ദേഹം ആ വീടിനു പ്രായശ്ചിത്തംചെയ്യും; വീട് ശുദ്ധിയുള്ളതായിത്തീരും.” ");
INSERT INTO malc_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","സകലവിധ കുഷ്ഠം, വടു, ചിരങ്ങ്, ");
INSERT INTO malc_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","വസ്ത്രത്തിലോ വീട്ടിലോ ഉള്ള വടു ");
INSERT INTO malc_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","തിണർപ്പ്, ചുണങ്ങ്, തെളിഞ്ഞപുള്ളി എന്നിവയ്ക്കുള്ള പ്രമാണങ്ങൾ ഇവയാണ്; ");
INSERT INTO malc_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ഈ രീതിയിലാണ് ഒരു വ്യക്തിയോ വസ്തുവോ ആചാരപരമായി ശുദ്ധമോ അശുദ്ധമോ എന്നു തീരുമാനിക്കുന്നത്. ഗുരുതരമായ കുഷ്ഠം, വടു എന്നിവയെക്കുറിച്ചുള്ള പ്രമാണങ്ങൾ ഇവയാണ്. ");
INSERT INTO malc_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു; ");
INSERT INTO malc_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ഇസ്രായേൽമക്കളോടു സംസാരിച്ച് അവരോടു പറയണം: ‘ഒരു പുരുഷനു ശുക്ലസ്രവമുണ്ടായാൽ, ആ സ്രവം ആചാരപരമായി അശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","അത് അവന്റെ ശരീരത്തിൽനിന്ന് നിരന്തരമായി ഒഴുകിക്കൊണ്ടിരുന്നാലും അടഞ്ഞിരുന്നാലും അത് അവനെ അശുദ്ധനാക്കും. സ്രവത്താൽ അശുദ്ധിയുണ്ടാകുന്നത് ഇപ്രകാരമാണ്: ");
INSERT INTO malc_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘സ്രവമുള്ളവൻ കിടക്കുന്ന കിടക്ക അശുദ്ധം, അവൻ ഇരിക്കുന്നതെന്തും അശുദ്ധം. ");
INSERT INTO malc_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","അവന്റെ കിടക്ക തൊടുന്ന ഏതൊരാളും വസ്ത്രം കഴുകി വെള്ളത്തിൽ കുളിക്കണം, അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","സ്രവമുള്ളവൻ ഇരുന്ന എന്തിലെങ്കിലും ഇരിക്കുന്നവർ വസ്ത്രം കഴുകി, വെള്ളത്തിൽ കുളിക്കണം, അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘സ്രവമുള്ളയാളെ തൊടുന്നവരും വസ്ത്രം കഴുകി, വെള്ളത്തിൽ കുളിക്കണം, അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘ശുദ്ധരായ ആരുടെയെങ്കിലുംമേൽ സ്രവമുള്ളവൻ തുപ്പിയാൽ, അയാൾ വസ്ത്രം കഴുകി വെള്ളത്തിൽ കുളിക്കണം, അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘സ്രവമുള്ളവൻ യാത്രചെയ്യുന്ന വാഹനവും അശുദ്ധമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","അവന്റെകീഴേയിരുന്ന എന്തിലെങ്കിലും തൊടുന്നവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. അവ എടുക്കുന്നവർ വസ്ത്രം കഴുകി വെള്ളത്തിൽ കുളിക്കണം. അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘സ്രവമുള്ളവൻ വെള്ളത്തിൽ കൈകഴുകാതെ ആരെയെങ്കിലും തൊട്ടാൽ അവർ വസ്ത്രം കഴുകി, വെള്ളത്തിൽ കുളിക്കണം. അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘ആ മനുഷ്യൻ തൊടുന്ന മൺപാത്രം ഉടയ്ക്കണം. മരസാധനങ്ങൾ വെള്ളത്തിൽ കഴുകണം. ");
INSERT INTO malc_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘ഒരു പുരുഷൻ തന്റെ സ്രവത്തിൽനിന്ന് ശുദ്ധനായാൽ, അവന്റെ ആചാരപരമായ ശുദ്ധീകരണത്തിന് അവൻ ഏഴുദിവസം എണ്ണണം. അവൻ വസ്ത്രം കഴുകി, ശുദ്ധജലത്തിൽ കുളിക്കണം. അങ്ങനെ അവൻ ശുദ്ധനാകും. ");
INSERT INTO malc_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","എട്ടാംദിവസം അവൻ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ എടുത്തുകൊണ്ട് യഹോവയുടെമുമ്പാകെ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ വന്നു പുരോഹിതന്റെ പക്കൽ അവയെ കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","പുരോഹിതൻ അവയെ, ഒന്നു പാപശുദ്ധീകരണയാഗമായും മറ്റേതു ഹോമയാഗമായും അർപ്പിക്കണം. ഇപ്രകാരം പുരോഹിതൻ അവനുവേണ്ടി യഹോവയുടെമുമ്പാകെ പ്രായശ്ചിത്തം കഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘ഒരു പുരുഷനു ശുക്ലസ്രവമുണ്ടാകുമ്പോൾ, അയാൾ ദേഹം ആസകലം വെള്ളത്തിൽ കഴുകണം, അയാൾ സന്ധ്യവരെ അശുദ്ധനായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ഏതെങ്കിലും വസ്ത്രത്തിലോ തുകലിലോ ശുക്ലം ഉണ്ടെങ്കിൽ അതു വെള്ളത്തിൽ കഴുകണം. സന്ധ്യവരെ അത് അശുദ്ധമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ഒരു പുരുഷൻ ഒരു സ്ത്രീയോടുകൂടെ കിടക്കപങ്കിടുകയും ശുക്ലസ്രവം ഉണ്ടാകുകയും ചെയ്താൽ, രണ്ടുപേരും വെള്ളത്തിൽ കുളിക്കണം, അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘ഒരു സ്ത്രീക്കു മുറപ്രകാരം രക്തസ്രാവമുണ്ടാകുമ്പോൾ, അവളുടെ മാസമുറയുടെ അശുദ്ധി ഏഴുദിവസം നീളും, അവളെ തൊടുന്നവർ ആരായാലും സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘അവളുടെ ആർത്തവകാലത്ത് അവൾ ഏതിന്മേലെങ്കിലും കിടന്നാൽ അത് അശുദ്ധമായിരിക്കും, ഏതിന്മേലെങ്കിലും അവൾ ഇരുന്നാൽ അത് അശുദ്ധമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","അവളുടെ കിടക്ക തൊടുന്നവർ തന്റെ വസ്ത്രം കഴുകി വെള്ളത്തിൽ കുളിക്കണം. അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","അവൾ ഇരുന്ന എന്തിലെങ്കിലും തൊടുന്നവർ തങ്ങളുടെ വസ്ത്രം കഴുകി വെള്ളത്തിൽ കുളിക്കണം, അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","അവളുടെ കിടക്കയോ, അവൾ ഇരുന്ന എന്തെങ്കിലുമോ ആരെങ്കിലും തൊട്ടാൽ അവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘ഒരു പുരുഷൻ അവളോടുകൂടെ കിടക്കപങ്കിടുകയും അവളുടെ ആർത്തവസ്രവം അവന്റെമേൽ ആകുകയും ചെയ്താൽ, അവൻ ഏഴുദിവസം അശുദ്ധനായിരിക്കും, അവൻ കിടക്കുന്ന കിടക്കയും അശുദ്ധമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘ഒരു സ്ത്രീക്ക് ആർത്തവകാലത്തല്ലാതെ വളരെദിവസം രക്തസ്രാവമുണ്ടാകുകയോ ആർത്തവകാലം കഴിഞ്ഞും സ്രവം തുടരുകയോ ചെയ്താൽ, സ്രവമുള്ളിടത്തോളം, ആർത്തവകാലംപോലെ അവൾ അശുദ്ധയായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","സ്രവം തുടരുന്നകാലത്ത് അവൾ കിടക്കുന്ന കിടക്ക, അവളുടെ ആർത്തവകാലത്തെ കിടക്കപോലെ, അശുദ്ധമായിരിക്കും. അവൾ ഇരിക്കുന്നതെല്ലാം, ആർത്തവകാലത്തേതുപോലെ അശുദ്ധമായിരിക്കും, ");
INSERT INTO malc_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","അവയെ തൊടുന്നവർ അശുദ്ധരായിരിക്കും; അവർ വസ്ത്രം കഴുകി വെള്ളത്തിൽ കുളിക്കണം. സന്ധ്യവരെ അവർ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘അവളുടെ സ്രവത്തിൽനിന്ന് അവൾ ശുദ്ധയായാൽ, അവൾ ഏഴുദിവസം എണ്ണണം. അതിനുശേഷം അവൾ ശുദ്ധിയുള്ളവളാകും. ");
INSERT INTO malc_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","എട്ടാംദിവസം അവൾ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ എടുത്തു സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","പുരോഹിതൻ ഒന്നിനെ പാപശുദ്ധീകരണയാഗമായും മറ്റേതിനെ ഹോമയാഗമായും അർപ്പിക്കണം. ഇപ്രകാരം പുരോഹിതൻ അവളുടെ സ്രവത്തിന്റെ അശുദ്ധിനിമിത്തം അവൾക്കുവേണ്ടി യഹോവയുടെമുമ്പാകെ പ്രായശ്ചിത്തം കഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘ഇസ്രായേൽമക്കളുടെ ഇടയിലുള്ള എന്റെ നിവാസസ്ഥാനം അശുദ്ധമാക്കി, ആ അശുദ്ധിയിൽ അവർ മരിക്കാതിരിക്കേണ്ടതിന്, നീ അവരെ അശുദ്ധിയിൽനിന്നകറ്റണം.’ ” ");
INSERT INTO malc_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","സ്രവമുള്ള ആൾക്കും ശുക്ലസ്രവത്താൽ അശുദ്ധമായ ഏതൊരാൾക്കും ");
INSERT INTO malc_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ആർത്തവകാലത്തുള്ള സ്ത്രീക്കും സ്രവമുള്ള പുരുഷനും സ്ത്രീക്കും ആചാരപരമായി അശുദ്ധയായ ഒരു സ്ത്രീയോടുകൂടെ ലൈംഗികബന്ധത്തിൽ ഏർപ്പെടുന്നവനും ഉള്ള പ്രമാണങ്ങൾ ഇവയാണ്. ");
INSERT INTO malc_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","അഹരോന്റെ രണ്ടു പുത്രന്മാരുടെ മരണശേഷം യഹോവ മോശയോട് അരുളിച്ചെയ്തു. യഹോവയുടെ സന്നിധിയിൽ അന്യാഗ്നിയുമായി അടുത്തുചെന്നതിനാലാണ് അവർ മരിച്ചുപോയത്. ");
INSERT INTO malc_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","യഹോവ മോശയോട് ഇപ്രകാരം അരുളിച്ചെയ്തു: “ഞാൻ പാപനിവാരണസ്ഥാനത്തിന്മേൽ മേഘത്തിൽ പ്രത്യക്ഷപ്പെടുമെന്നതിനാൽ, നിന്റെ സഹോദരനായ അഹരോൻ മരിക്കാതിരിക്കേണ്ടതിന്, അതിവിശുദ്ധസ്ഥലത്തു തിരശ്ശീലയ്ക്കു പിറകിൽ പേടകത്തിനുമീതേയുള്ള പാപനിവാരണസ്ഥാനത്തിനുമുമ്പിൽ ആഗ്രഹിക്കുമ്പോഴെല്ലാം വരരുതെന്ന് അയാളോടു പറയുക. ");
INSERT INTO malc_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“ഈ നിർദേശങ്ങൾ പൂർണമായി അനുസരിച്ചതിനുശേഷം മാത്രമേ അതിവിശുദ്ധസ്ഥലത്ത് അഹരോൻ പ്രവേശിക്കാൻ പാടുള്ളൂ: ആദ്യമായി പാപശുദ്ധീകരണയാഗത്തിന് ഒരു കാളക്കിടാവിനെയും ഹോമയാഗത്തിന് ഒരു ആട്ടുകൊറ്റനെയും അഹരോൻ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","അദ്ദേഹം ശരീരത്തോടുചേർത്തു പരുത്തിനൂൽകൊണ്ടുള്ള അടിവസ്ത്രവും പരുത്തിനൂൽകൊണ്ടുള്ള വിശുദ്ധമായ കുപ്പായവും ധരിച്ച്, പരുത്തിനൂൽകൊണ്ടുള്ള അരക്കച്ച ചുറ്റിക്കെട്ടി, പരുത്തിനൂൽകൊണ്ടുള്ള തലപ്പാവും ധരിച്ചിരിക്കണം. ഇവ വിശുദ്ധ വസ്ത്രങ്ങളാണ്. അതുകൊണ്ട് അദ്ദേഹം വെള്ളത്തിൽ കുളിച്ചിട്ടുവേണം ഇവ ധരിക്കാൻ. ");
INSERT INTO malc_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","അദ്ദേഹം പാപശുദ്ധീകരണയാഗത്തിന് രണ്ട് കോലാട്ടുകൊറ്റന്മാരെയും ഹോമയാഗത്തിന് ഒരു കോലാടിനെയും ഇസ്രായേൽ സഭയിൽനിന്ന് വാങ്ങണം. ");
INSERT INTO malc_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“അഹരോൻ തന്റെ പാപപരിഹാരത്തിനായി കാളയെ അർപ്പിക്കണം. ഇങ്ങനെ തനിക്കും കുടുംബത്തിനുംവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","പിന്നെ അദ്ദേഹം രണ്ടു കോലാടുകളെയും സമാഗമകൂടാരവാതിലിൽ യഹോവയുടെ സന്നിധിയിൽ നിർത്തണം. ");
INSERT INTO malc_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","അദ്ദേഹം രണ്ടു കോലാടുകൾക്കുംവേണ്ടി നറുക്ക് ഇടണം. ഒന്ന് യഹോവയ്ക്ക്; മറ്റേത് ജനത്തിന്റെ പാപം വഹിച്ചുകൊണ്ട് മരുഭൂമിയിലേക്കു പോകുന്ന ബലിയാട്. ");
INSERT INTO malc_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","യഹോവയ്ക്കു കുറിവീണ കോലാടിനെ അഹരോൻ കൊണ്ടുവന്നു പാപശുദ്ധീകരണയാഗമായി യാഗം കഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","അസസ്സേലിനു നറുക്കുവീണ കോലാടിനെ, പ്രായശ്ചിത്തം വരുത്തേണ്ടതിനും അസസ്സേലിനു മരുഭൂമിയിലേക്കു വിട്ടയയ്ക്കേണ്ടതിനുമായി, യഹോവയുടെമുമ്പാകെ ജീവനോടെ നിർത്തണം. ");
INSERT INTO malc_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“അഹരോൻ, തനിക്കും തന്റെ കുടുംബത്തിനുംവേണ്ടി പ്രായശ്ചിത്തം വരുത്താനുള്ള തന്റെ പാപശുദ്ധീകരണയാഗത്തിന്റെ കാളയെ കൊണ്ടുവന്നു, തന്റെ പാപശുദ്ധീകരണയാഗത്തിനായി അറക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","അദ്ദേഹം യഹോവയുടെ സന്നിധിയിലെ യാഗപീഠത്തിൽനിന്ന് ഒരു ധൂപകലശം നിറച്ചു കനൽക്കട്ടയും രണ്ടു കൈനിറയെ നേർമയായി പൊടിച്ച സൗരഭ്യമുള്ള ധൂപവർഗവും എടുത്ത് അവയെ തിരശ്ശീലയ്ക്കു പിറകിൽ കൊണ്ടുപോകണം. ");
INSERT INTO malc_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","അദ്ദേഹം യഹോവയുടെമുമ്പാകെ ആ കുന്തിരിക്കം തീയിൽ ഇടണം. അയാൾ മരിക്കാതിരിക്കേണ്ടതിനു കുന്തിരിക്കത്തിന്റെ പുക ഉടമ്പടിയുടെ പലകയുടെ മുകളിലുള്ള പാപനിവാരണസ്ഥാനത്തെ മറയ്ക്കും. ");
INSERT INTO malc_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","അദ്ദേഹം കാളയുടെ കുറെ രക്തം എടുത്തു തന്റെ വിരലുകൊണ്ടു പാപനിവാരണസ്ഥാനത്തിനുമുമ്പിൽ കിഴക്കുവശത്തു തളിക്കണം; പിന്നെ അതിൽ കുറെ തന്റെ വിരലുകൊണ്ടു പാപനിവാരണസ്ഥാനത്തിനുമുമ്പിൽ ഏഴുപ്രാവശ്യം തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ഇതിനുശേഷം അഹരോൻ ജനത്തിനുവേണ്ടിയുള്ള പാപശുദ്ധീകരണയാഗത്തിനായി കോലാടിനെ അറത്ത് അതിന്റെ രക്തം എടുത്തു തിരശ്ശീലയ്ക്കു പിന്നിൽ കൊണ്ടുപോയി, കാളയുടെ രക്തംകൊണ്ടു ചെയ്തതുപോലെ കോലാടിന്റെരക്തംകൊണ്ടും ചെയ്യണം. അദ്ദേഹം അതു പാപനിവാരണസ്ഥാനത്തിനുമേലും അതിനു മുന്നിലും തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ഇങ്ങനെ, അഹരോൻ ഇസ്രായേല്യരുടെ അശുദ്ധിയും മത്സരവും അവരുടെ മറ്റെല്ലാ പാപങ്ങളുംനിമിത്തം അതിവിശുദ്ധസ്ഥലത്തിനു പ്രായശ്ചിത്തം കഴിക്കണം. അവരുടെ ഇടയിൽ അവരുടെ അശുദ്ധിയുടെ നടുവിലിരിക്കുന്ന സമാഗമകൂടാരത്തിനുവേണ്ടിയും അദ്ദേഹം അങ്ങനെതന്നെ ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","അഹരോൻ അതിവിശുദ്ധസ്ഥലത്തു ചെന്നു തനിക്കുവേണ്ടിയും തന്റെ കുടുംബത്തിനുവേണ്ടിയും ഇസ്രായേൽ സഭയ്ക്കുവേണ്ടിയും പ്രായശ്ചിത്തം കഴിച്ചു പുറത്തു വരുന്നതുവരെ ആരും സമാഗമകൂടാരത്തിൽ ഉണ്ടായിരിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“ഇതിനുശേഷം അഹരോൻ പുറത്ത് യഹോവയുടെ സന്നിധിയിലുള്ള യാഗപീഠത്തിനു സമീപത്തേക്കു വന്ന് അതിനുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കണം. അദ്ദേഹം കാളയുടെ രക്തവും കോലാടിന്റെ രക്തവും കുറെ എടുത്തു യാഗപീഠത്തിന്റെ എല്ലാ കൊമ്പിലും പുരട്ടണം. ");
INSERT INTO malc_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","അതിനെ ഇസ്രായേല്യരുടെ അശുദ്ധിയിൽനിന്ന് ശുദ്ധീകരിച്ചു വിശുദ്ധമാക്കാൻ അദ്ദേഹം കുറെ രക്തം തന്റെ വിരലുകൾകൊണ്ട് ഏഴുപ്രാവശ്യം അതിൽ തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“അഹരോൻ അതിവിശുദ്ധസ്ഥലത്തിനും സമാഗമകൂടാരത്തിനും യാഗപീഠത്തിനുംവേണ്ടി പ്രായശ്ചിത്തം കഴിച്ചുതീർന്നിട്ട് ജീവനുള്ള കോലാടിനെ മുന്നോട്ടു കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","അഹരോൻ രണ്ടു കൈയും ജീവനുള്ള കോലാടിന്റെ തലയിൽവെച്ച്, ഇസ്രായേലിന്റെ സകലദുഷ്ടതയും മത്സരവും അവരുടെ എല്ലാ പാപങ്ങളും ഏറ്റുപറഞ്ഞു കോലാടിന്റെ തലയിൽ ചുമത്തണം. അദ്ദേഹം കോലാടിനെ ആ ചുമതലയ്ക്കായി നിയമിക്കപ്പെട്ട ഒരാളെ ഏൽപ്പിച്ച് മരുഭൂമിയിലേക്ക് അയയ്ക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ആ കോലാട് അവരുടെ സകലപാപവും ഒരു വിജനസ്ഥലത്തേക്ക് ചുമന്നുകൊണ്ടുപോകും; അയാൾ അതിനെ മരുഭൂമിയിൽ വിട്ടയയ്ക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“പിന്നെ അഹരോൻ സമാഗമകൂടാരത്തിനകത്തുചെന്ന് അതിവിശുദ്ധസ്ഥലത്തു പ്രവേശിക്കുന്നതിനുമുമ്പു താൻ ധരിച്ച പരുത്തിനൂൽ വസ്ത്രങ്ങളെല്ലാം അഴിക്കുകയും അവയെ അവിടെ വെക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","അദ്ദേഹം ശുദ്ധിയുള്ള സ്ഥലത്തുവെച്ച് വെള്ളത്തിൽ കുളിച്ചു തന്റെ സാധാരണ വസ്ത്രം ധരിക്കണം. പിന്നെ അഹരോൻ പുറത്തുവന്നു തനിക്കും ജനത്തിനും പ്രായശ്ചിത്തം വരുത്താൻ തനിക്കുവേണ്ടിയുള്ള ഹോമയാഗവും ജനത്തിനുവേണ്ടിയുള്ള ഹോമയാഗവും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","അയാൾ പാപശുദ്ധീകരണയാഗത്തിന്റെ മേദസ്സ് യാഗപീഠത്തിൽ ദഹിപ്പിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“അസസ്സേലിനുള്ള കോലാടിനെ കൊണ്ടുപോയി വിട്ട വ്യക്തി വസ്ത്രം കഴുകി വെള്ളത്തിൽ കുളിക്കണം; അതിനുശേഷം അവനു പാളയത്തിനകത്തുവരാം. ");
INSERT INTO malc_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","വിശുദ്ധമന്ദിരത്തിലേക്കു, പ്രായശ്ചിത്തം വരുത്താൻ, രക്തം കൊണ്ടുവന്ന പാപശുദ്ധീകരണയാഗത്തിന്റെ കാളയെയും കോലാടിനെയും പാളയത്തിനുപുറത്തു കൊണ്ടുപോകണം; അതിന്റെ തുകലും മാംസവും ചാണകവും ചുട്ടുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","അവയെ ദഹിപ്പിക്കുന്നയാൾ തന്റെ വസ്ത്രം കഴുകി വെള്ളത്തിൽ കുളിക്കണം; അതിനുശേഷം അയാൾക്കു പാളയത്തിലേക്കുവരാം. ");
INSERT INTO malc_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ഇതു നിങ്ങൾക്ക് എന്നേക്കുമുള്ള അനുഷ്ഠാനമായിരിക്കണം; ഏഴാംമാസം പത്താംതീയതി നിങ്ങളും നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പ്രവാസിയും സ്വദേശിയും ആത്മതപനംചെയ്യണം; ജോലിയൊന്നും ചെയ്യരുത്, ");
INSERT INTO malc_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","കാരണം, ഈ ദിവസം നിങ്ങളെ ശുദ്ധീകരിക്കാൻ നിങ്ങൾക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യപ്പെടും. പിന്നെ യഹോവയുടെ സന്നിധിയിൽ നിങ്ങളുടെ സകലപാപങ്ങളിൽനിന്നും നിങ്ങൾ ശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","അതു സ്വസ്ഥതയുടെ ശബ്ബത്ത് ആണ്, നിങ്ങൾ ആത്മതപനംചെയ്യണം; ഇത് എന്നേക്കുമുള്ള അനുഷ്ഠാനമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","തങ്ങളുടെ പൂർവപിതാവായ അഹരോന്റെ സ്ഥാനത്തേക്ക് അഭിഷിക്തനായി സമർപ്പിക്കപ്പെട്ട മഹാപുരോഹിതനാണ് പ്രായശ്ചിത്തം കഴിക്കേണ്ടത്. അദ്ദേഹം വിശുദ്ധമായ പരുത്തിനൂൽവസ്ത്രങ്ങൾ ധരിച്ചുകൊണ്ട് ");
INSERT INTO malc_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","അതിവിശുദ്ധസ്ഥലത്തിനും സമാഗമകൂടാരത്തിനും യാഗപീഠത്തിനും പുരോഹിതന്മാർക്കും സഭയിലെ സകലജനത്തിനുംവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“ഇതു നിങ്ങൾക്ക് എന്നേക്കുമുള്ള അനുഷ്ഠാനമായിരിക്കണം: ഇസ്രായേല്യരുടെ സകലപാപങ്ങൾക്കുംവേണ്ടി വർഷത്തിലൊരിക്കൽ പ്രായശ്ചിത്തം കഴിക്കണം.” യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ അദ്ദേഹം ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“അഹരോനോടും അദ്ദേഹത്തിന്റെ പുത്രന്മാരോടും സകല ഇസ്രായേല്യരോടും സംസാരിക്കണം. അവരോടു പറയേണ്ട ‘യഹോവയുടെ കൽപ്പന ഇതാണ്— ");
INSERT INTO malc_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","യഹോവയുടെ കൂടാരത്തിനുമുമ്പിൽ യഹോവയ്ക്കു വഴിപാടായി അർപ്പിക്കേണ്ടതിനു സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ കൊണ്ടുവരാതെ, കാളയെയോ ആട്ടിൻകുട്ടിയെയോ കോലാടിനെയോ പാളയത്തിനകത്തോ പുറത്തോ യാഗം കഴിക്കുന്ന ഏതൊരു ഇസ്രായേല്യനെയും രക്തപാതകം ചെയ്ത വ്യക്തിയായി കരുതണം; ആ മനുഷ്യൻ രക്തം ചൊരിഞ്ഞതിനാൽ, അയാളെ ജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ഇപ്പോൾ ഇസ്രായേല്യർ തുറസ്സായ സ്ഥലത്ത് അർപ്പിക്കുന്ന യാഗങ്ങൾ യഹോവയ്ക്കു സമാധാനയാഗങ്ങളായി യഹോവയുടെ സന്നിധിയിൽ പുരോഹിതന്മാരുടെ അടുക്കൽ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ കൊണ്ടുവരേണ്ടത് ആവശ്യമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","പുരോഹിതൻ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിലുള്ള യഹോവയുടെ യാഗപീഠത്തിനുനേരേ രക്തം തളിക്കുകയും മേദസ്സ് യഹോവയ്ക്കു പ്രസാദകരമായ സൗരഭ്യമായി ദഹിപ്പിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","അവർ പരസംഗമായി പിൻതുടരുന്ന കോലാടു വിഗ്രഹങ്ങൾക്ക് ഇനിയൊരിക്കലും യാഗം അർപ്പിക്കരുത്. ഇത് അവർക്കും വരാനുള്ള തലമുറകൾക്കും എന്നേക്കുമുള്ള ചട്ടമായിരിക്കണം.’ ");
INSERT INTO malc_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“അവരോടു പറയുക: ‘ഒരു ഹോമയാഗമോ വഴിപാടോ അർപ്പിക്കുന്ന ഇസ്രായേല്യരോ അവരുടെ ഇടയിൽ പാർക്കുന്ന പ്രവാസിയോ ");
INSERT INTO malc_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","യഹോവയ്ക്കു യാഗം അർപ്പിക്കാൻ അതു സമാഗമകൂടാരവാതിലിൽ കൊണ്ടുവരുന്നില്ലെങ്കിൽ ആ മനുഷ്യനെ ഇസ്രായേൽജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘ഇസ്രായേല്യരോ അവരുടെ ഇടയിൽ പാർക്കുന്ന പ്രവാസിയോ രക്തം കുടിച്ചാൽ ആ മനുഷ്യനു വിരോധമായി ഞാൻ എന്റെ മുഖംതിരിക്കുകയും അവരെ സ്വജനത്തിൽനിന്ന് ഛേദിച്ചുകളകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","കാരണം, ശരീരത്തിന്റെ ജീവൻ രക്തത്തിലാണ്. യാഗപീഠത്തിൽ നിങ്ങൾക്കുവേണ്ടി പാപപരിഹാരം വരുത്താൻ ഞാൻ അതു നിങ്ങൾക്കു നൽകിയിരിക്കുന്നു; രക്തമാണ് ഒരാളുടെ ജീവനുവേണ്ടി പാപപരിഹാരം വരുത്തുന്നത്. ");
INSERT INTO malc_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","അതുകൊണ്ട് ഞാൻ ഇസ്രായേല്യരോടു പറയുന്നു, “നിങ്ങളിലാരും നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പ്രവാസിയും രക്തം കുടിക്കരുത്.” ");
INSERT INTO malc_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘ഇസ്രായേല്യരോ നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പ്രവാസിയോ ഭക്ഷിക്കാവുന്ന ഒരു മൃഗത്തെയോ പക്ഷിയെയോ വേട്ടയാടിപ്പിടിച്ചാൽ രക്തം ഊറ്റിക്കളഞ്ഞ് മണ്ണിട്ടു മൂടണം. ");
INSERT INTO malc_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","കാരണം, സർവജീവജാലങ്ങളുടെയും ജീവൻ അതിന്റെ ജീവാധാരമായ രക്തംതന്നെ. അതുകൊണ്ടാണ് ഞാൻ ഇസ്രായേൽമക്കളോട്: “നിങ്ങൾ യാതൊരു ജീവിയുടെയും രക്തം കുടിക്കരുത്, എന്തെന്നാൽ സർവജീവികളുടെയും ജീവൻ അതിന്റെ രക്തത്തിലാണ്, അത് ഭക്ഷിക്കുന്നവനെ ഛേദിച്ചുകളയണം” എന്നു കൽപ്പിച്ചത്. ");
INSERT INTO malc_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘ചത്തതിനെയോ വന്യമൃഗങ്ങൾ കടിച്ചുകീറിയതിനെയോ ഭക്ഷിക്കുന്ന സ്വദേശിയോ പ്രവാസിയോ വസ്ത്രം കഴുകി വെള്ളത്തിൽ കുളിക്കണം. അവർ സന്ധ്യവരെ ആചാരപരമായി അശുദ്ധരായിരിക്കും; പിന്നെ അയാൾ ശുദ്ധിയുള്ളവനാകും. ");
INSERT INTO malc_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","വസ്ത്രം കഴുകാതെയും കുളിക്കാതെയുമിരുന്നാൽ, അയാൾ ആ കുറ്റം വഹിക്കണം.’ ” ");
INSERT INTO malc_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, ");
INSERT INTO malc_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ഇസ്രായേല്യരോടു സംസാരിക്കണം. അവരോട് ഇപ്രകാരം പറയുക: ‘ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","നിങ്ങൾ താമസിച്ചിരുന്ന ഈജിപ്റ്റിൽ അവർ ചെയ്തിരുന്നതുപോലെ നിങ്ങൾ ചെയ്യരുത്. ഞാൻ നിങ്ങളെ കൊണ്ടുപോകുന്ന കനാൻനാട്ടിൽ അവർ ചെയ്തുപോകുന്നതുപോലെയും നിങ്ങൾ ചെയ്യരുത്. അവരുടെ പ്രവൃത്തികൾ അനുകരിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","നിങ്ങൾ എന്റെ നിയമം അനുസരിക്കയും എന്റെ ഉത്തരവുകൾ പ്രമാണിക്കുകയും വേണം. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","എന്റെ ഉത്തരവുകളും നിയമങ്ങളും പാലിക്കുക; കാരണം അവ അനുസരിക്കുന്ന മനുഷ്യർ അവമൂലം ജീവിക്കും. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘നിങ്ങളിൽ ആരും രക്തബന്ധമുള്ളവരുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടാൻ അവരെ സമീപിക്കരുത്, ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘നിന്റെ മാതാവുമായി ലൈംഗികബന്ധത്തിലേർപ്പെട്ടു നിന്റെ പിതാവിനെ അപമാനിക്കരുത്. അവൾ നിന്റെ മാതാവല്ലോ; അവളുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്. ");
INSERT INTO malc_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘പിതാവിന്റെ ഭാര്യയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്; അതു നിന്റെ പിതാവിനെ അപമാനിക്കുന്നതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘പിതാവിന്റെ മകളോ മാതാവിന്റെ മകളോ ആയ നിന്റെ സഹോദരിയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്. അവർ വീട്ടിൽ ജനിച്ചവരോ പുറത്തുജനിച്ചവരോ ആകട്ടെ, അവരുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്. ");
INSERT INTO malc_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘നിന്റെ മകന്റെ മകളുമായോ മകളുടെ മകളുമായോ ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്; കാരണം, അതു നിന്നെത്തന്നെ അപമാനിക്കുന്നതിനു തുല്യമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘നിന്റെ പിതാവിനു ജനിച്ചവളും അയാളുടെ ഭാര്യയുടെ മകളുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്; അവൾ നിന്റെ സഹോദരിയാണല്ലോ. ");
INSERT INTO malc_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘നിന്റെ പിതാവിന്റെ സഹോദരിയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്; അവൾ പിതാവിന്റെ അടുത്ത ബന്ധുവാണല്ലോ. ");
INSERT INTO malc_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘നിന്റെ അമ്മയുടെ സഹോദരിയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്; അവൾ നിന്റെ അമ്മയുടെ അടുത്ത ബന്ധുവാണല്ലോ. ");
INSERT INTO malc_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘നിന്റെ പിതാവിന്റെ സഹോദരന്റെ ഭാര്യയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്. അങ്ങനെ നീ അദ്ദേഹത്തെ അപമാനിക്കരുത്; അവൾ നിന്റെ അമ്മായിയാണല്ലോ. ");
INSERT INTO malc_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘നിന്റെ മരുമകളുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്. അവൾ നിന്റെ മകന്റെ ഭാര്യയാണല്ലോ; അവളുമായുള്ള ലൈംഗികബന്ധം നിഷിദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘സഹോദരന്റെ ഭാര്യയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്; അതു നിന്റെ സഹോദരനെ അപമാനിക്കുന്നതിനു തുല്യമാണല്ലോ. ");
INSERT INTO malc_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘ഒരു സ്ത്രീയുമായും അവളുടെ മകളുമായും ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്. അവളുടെ മകന്റെ മകളുമായോ മകളുടെ മകളുമായോ ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്; അവർ അടുത്ത ബന്ധുക്കളാണല്ലോ. അതു ദുഷ്ടതയാണ്. ");
INSERT INTO malc_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘നിന്റെ ഭാര്യ ജീവിച്ചിരിക്കുമ്പോൾ, അവളോടുള്ള വിരോധത്തിന് അവളുടെ സഹോദരിയെ ഭാര്യയായി സ്വീകരിക്കുകയോ അവളുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടുകയോ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘ഋതുകാലത്തെ അശുദ്ധിയിൽ കഴിയുന്ന ഒരു സ്ത്രീയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്. ");
INSERT INTO malc_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘നിന്റെ അയൽവാസിയുടെ ഭാര്യയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്; അവളാൽ നിനക്ക് അശുദ്ധി വരുത്തരുത്. ");
INSERT INTO malc_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘മോലെക്കിനു യാഗമർപ്പിക്കാൻ നിന്റെ കുഞ്ഞുങ്ങളിലൊന്നിനെയും കൊടുക്കരുത്; നിന്റെ ദൈവത്തിന്റെ നാമം അശുദ്ധമാക്കരുത്; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘സ്ത്രീയോടെന്നപോലെ ഒരുവൻ പുരുഷനോടുകൂടെ ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്; അതു നിഷിദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘ഒരു മൃഗത്തോടുകൂടെ ലൈംഗികബന്ധത്തിലേർപ്പെട്ട് നിങ്ങളെത്തന്നെ അശുദ്ധരാക്കരുത്. മൃഗത്തോടുകൂടെ ലൈംഗികബന്ധത്തിലേർപ്പെടേണ്ടതിന് ഒരു സ്ത്രീയും അതിന്റെ മുമ്പിൽ നിൽക്കരുത്; അതു നികൃഷ്ടമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘ഇവയിലൊന്നിലും നിങ്ങളെത്തന്നെ അശുദ്ധരാക്കരുത്, കാരണം നിങ്ങളുടെമുമ്പിൽനിന്ന് ഞാൻ ഓടിച്ചുകളയുന്ന ജനതകൾ ഇങ്ങനെയാണ് അശുദ്ധരായിത്തീർന്നത്. ");
INSERT INTO malc_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ദേശംപോലും മലിനമായി; അതുകൊണ്ടു ഞാൻ അതിനെ അതിന്റെ പാപംനിമിത്തം ശിക്ഷിച്ചു, ദേശം അതിലെ നിവാസികളെ ഉപേക്ഷിച്ചുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","എന്നാൽ നിങ്ങൾ എന്റെ ഉത്തരവുകളും നിയമങ്ങളും പാലിക്കണം. സ്വദേശികളും നിങ്ങളുടെയിടയിൽ പാർക്കുന്ന പ്രവാസികളും ഈവക അറപ്പായതൊന്നും ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","കാരണം നിങ്ങൾക്കുമുമ്പ് ഈ ദേശത്തു താമസിച്ചിരുന്നവർ ഇവയൊക്കെ ചെയ്തു, അങ്ങനെ ദേശം മലിനമായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","നിങ്ങൾ ദേശത്തെ മലിനമാക്കിയാൽ, അതു നിങ്ങൾക്കു മുമ്പുണ്ടായിരുന്നവരെ ഉപേക്ഷിച്ചുകളഞ്ഞതുപോലെ നിങ്ങളെയും ഉപേക്ഷിച്ചുകളയും. ");
INSERT INTO malc_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘ഈ അറപ്പായ കാര്യങ്ങളിൽ ഏതെങ്കിലും ചെയ്യുന്ന വ്യക്തികളെ അവരുടെ ജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","എന്റെ ചട്ടങ്ങൾ പാലിക്കുക; നിങ്ങൾ വരുന്നതിനുമുമ്പ് നിലവിലിരുന്ന അറപ്പായ ആചാരനടപടികളിലൊന്നിലും ഏർപ്പെട്ട്, നിങ്ങളെ അവരോടൊപ്പം അശുദ്ധരാക്കരുത്. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ഇസ്രായേലിന്റെ സർവസഭയോടും സംസാരിക്കണം. അവരോട് ഇപ്രകാരം പറയുക: ‘നിങ്ങളുടെ ദൈവമായ, യഹോവയായ ഞാൻ വിശുദ്ധൻ ആകുകയാൽ നിങ്ങളും വിശുദ്ധർ ആയിരിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘നിങ്ങൾ ഓരോരുത്തരും നിങ്ങളുടെ മാതാവിനെയും പിതാവിനെയും ബഹുമാനിക്കണം; എന്റെ ശബ്ബത്തുകൾ ആചരിക്കണം. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘വിഗ്രഹങ്ങളിലേക്കു തിരിയുകയോ നിങ്ങൾക്കായി ദേവന്മാരെ വാർത്തുണ്ടാക്കുകയോ ചെയ്യരുത്; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘നിങ്ങൾ യഹോവയ്ക്ക് ഒരു സമാധാനയാഗം അർപ്പിക്കുമ്പോൾ നിങ്ങൾക്കു പ്രസാദം ലഭിക്കുമാറ് അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","അതു നിങ്ങൾ യാഗമർപ്പിക്കുന്ന ദിവസംതന്നെയോ അടുത്ത ദിവസമോ ഭക്ഷിക്കണം; മൂന്നാംദിവസത്തേക്കു ശേഷിക്കുന്നതു തീയിലിട്ടു ചുട്ടുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","അതിലെന്തെങ്കിലും മൂന്നാംദിവസം ഭക്ഷിച്ചാൽ അത് അശുദ്ധമാണ്, അതു പ്രസാദമാകുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","അതു ഭക്ഷിക്കുന്നവർ കുറ്റക്കാരായിരിക്കും. അവർ യഹോവയ്ക്കു വിശുദ്ധമായതിനെ അശുദ്ധമാക്കിയല്ലോ; അവരെ അവരുടെ ജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘നിങ്ങൾ നിങ്ങളുടെ വയലിലെ വിള കൊയ്യുമ്പോൾ നിങ്ങളുടെ വയലിന്റെ അരികുചേർത്തു കൊയ്യുകയോ കൊയ്തതിന്റെ കാലാപെറുക്കുകയോ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","നിങ്ങളുടെ മുന്തിരിത്തോപ്പിൽ വീണ്ടും പോകുകയോ വീണുപോയ മുന്തിരി പെറുക്കുകയോ ചെയ്യരുത്. അവ ദരിദ്രനും പ്രവാസിക്കുമായി വിട്ടേക്കണം. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘മോഷ്ടിക്കരുത്. “ ‘കള്ളം പറയരുത്. “ ‘പരസ്പരം വഞ്ചിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘എന്റെ നാമത്തിൽ കള്ളസത്യം ചെയ്തു നിങ്ങളുടെ ദൈവത്തിന്റെ നാമം നിന്ദിക്കരുത്. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘നിങ്ങളുടെ അയൽക്കാരെ പീഡിപ്പിക്കുകയോ വസ്തു കവർച്ചചെയ്യുകയോ അരുത്. “ ‘കൂലിക്കാരന്റെ ശമ്പളം പിറ്റേന്നു രാവിലെവരെ പിടിച്ചുവെക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘ചെകിടനെ ശപിക്കുകയോ അന്ധന്റെ മുന്നിൽ ഇടർച്ചക്കല്ലു വെക്കുകയോ ചെയ്യരുത്. നിങ്ങളുടെ ദൈവത്തെ ഭയപ്പെടണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘ന്യായം അട്ടിമറിക്കരുത്; ദരിദ്രരോടു പക്ഷഭേദമോ വലിയവരോട് ആഭിമുഖ്യമോ കാണിക്കാതെ നിങ്ങളുടെ അയൽവാസിയെ നീതിപൂർവം വിധിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘നിങ്ങളുടെ ജനത്തിനിടയിൽ അപവാദം പരത്തരുത്. “ ‘നിങ്ങളുടെ അയൽവാസിയുടെ ജീവന് അപകടം ഭവിക്കത്തക്കതൊന്നും ചെയ്യരുത്. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘നിന്റെ സഹോദരങ്ങളെ ഹൃദയത്തിൽ വെറുക്കരുത്. അവരുടെ കുറ്റത്തിൽ പങ്കാളിയാകാതിരിക്കാൻ നിങ്ങളുടെ സഹോദരങ്ങളെ നിർവ്യാജം ശാസിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘നിന്റെ ജനത്തിലാർക്കെങ്കിലും വിരോധമായി പ്രതികാരം അന്വേഷിക്കുകയോ പകവെക്കുകയോ ചെയ്യരുത്. എന്നാൽ, നീ നിന്നെ സ്നേഹിക്കുന്നതുപോലെതന്നെ നിന്റെ അയൽവാസിയെയും സ്നേഹിക്കണം. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘എന്റെ ഉത്തരവുകൾ പ്രമാണിക്കുക. “ ‘രണ്ടുതരം മൃഗങ്ങളെത്തമ്മിൽ ഇണചേർക്കരുത്. “ ‘രണ്ടുതരം വിത്തു നിന്റെ നിലത്തിൽ വിതയ്ക്കരുത്. “ ‘രണ്ടുതരം വസ്തുക്കൾ ചേർത്തു നെയ്ത വസ്ത്രം ധരിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘മറ്റൊരു പുരുഷനു വാഗ്ദാനം ചെയ്യപ്പെട്ടവളും എന്നാൽ, വീണ്ടെടുക്കപ്പെട്ടിട്ടില്ലാത്തവളും സ്വാതന്ത്ര്യം നൽകപ്പെട്ടിട്ടില്ലാത്തവളുമായ ഒരടിമസ്ത്രീയോടുകൂടെ ഒരാൾ ലൈംഗികബന്ധത്തിലേർപ്പെട്ടാൽ, അവരെ ന്യായമായി ശിക്ഷിക്കണം. എന്നാൽ, അവരെ മരണത്തിന് ഏൽപിക്കരുത്, കാരണം അവൾ സ്വതന്ത്രയായിട്ടില്ലല്ലോ. ");
INSERT INTO malc_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","എങ്കിലും ആ പുരുഷൻ സമാഗമകൂടാരവാതിലിൽ യഹോവയുടെ സന്നിധിയിൽ അകൃത്യയാഗത്തിനായി ഒരു ആട്ടുകൊറ്റനെ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","അകൃത്യയാഗത്തിന്റെ ആട്ടുകൊറ്റനെക്കൊണ്ട് അവൻ ചെയ്ത പാപത്തിനു പുരോഹിതൻ അവനുവേണ്ടി യഹോവയുടെ സന്നിധിയിൽ പാപപരിഹാരംചെയ്യണം; അങ്ങനെ അവന്റെ പാപം ക്ഷമിക്കപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘നിങ്ങൾ കനാൻദേശത്തുവന്ന് ഏതെങ്കിലും ഇനം ഫലവൃക്ഷം നടുമ്പോൾ അതിന്റെ ഫലം വിലക്കപ്പെട്ടതായി കരുതണം. മൂന്നുവർഷം അതു വിലക്കപ്പെട്ടതായി നിങ്ങൾ കരുതണം, അതു ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","നാലാംവർഷം അതിന്റെ ഫലമെല്ലാം യഹോവയ്ക്കു സ്തോത്രാർപ്പണത്തിനായി വിശുദ്ധമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","എന്നാൽ അഞ്ചാംവർഷം നിങ്ങൾക്ക് അതിന്റെ ഫലം ഭക്ഷിക്കാം. അങ്ങനെ അതിന്റെ അനുഭവം നിങ്ങൾക്കു വർധിച്ചുവരും. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘രക്തത്തോടുകൂടി മാംസം ഭക്ഷിക്കരുത്. “ ‘ദേവപ്രശ്നംവെക്കുകയോ ശകുനംനോക്കുകയോ അരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘നിങ്ങളുടെ തലയുടെ അരികു വടിക്കുകയോ താടിയുടെ അറ്റം മുറിക്കുകയോ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘മരിച്ചവർക്കുവേണ്ടി നിങ്ങളുടെ ശരീരം മുറിപ്പെടുത്തുകയോ നിങ്ങളുടെമേൽ പച്ച കുത്തുകയോ ചെയ്യരുത്. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘ദേശം വേശ്യാവൃത്തിയിലേക്കു തിരിഞ്ഞു ദുഷ്ടതകൊണ്ടു നിറയാതിരിക്കാൻ, നിന്റെ മകളെ വേശ്യാവൃത്തിക്ക് ഏൽപ്പിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘എന്റെ ശബ്ബത്തുകൾ പ്രമാണിക്കുകയും എന്റെ വിശുദ്ധമന്ദിരത്തോടു ഭയഭക്തിയുള്ളവരായിരിക്കുകയും വേണം. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘വെളിച്ചപ്പാടുകളെയോ ഭൂതസേവക്കാരെയോ അന്വേഷിക്കരുത്. കാരണം അവരാൽ നിങ്ങൾ അശുദ്ധരായിത്തീരും. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘വൃദ്ധരുടെമുമ്പാകെ എഴുന്നേൽക്കുക, നരച്ചവനോടു ബഹുമാനം കാണിക്കുക. നിങ്ങളുടെ ദൈവത്തെ ഭയത്തോടെ ബഹുമാനിക്കുക. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘ഒരു പ്രവാസി നിങ്ങളോടുകൂടെ നിങ്ങളുടെ ദേശത്തു പാർക്കുമ്പോൾ ആ മനുഷ്യനെ ചൂഷണംചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","നിങ്ങളോടുകൂടെ പാർക്കുന്ന പ്രവാസിയോട് ഒരു സ്വദേശിയോടെന്നപോലെ ഇടപെടുക; അയാളെ നിങ്ങളെപ്പോലെതന്നെ സ്നേഹിക്കുക. നിങ്ങൾ ഈജിപ്റ്റിൽ പ്രവാസികളായിരുന്നല്ലോ. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘നീളത്തിലും അളവിലും തൂക്കത്തിലും വഞ്ചന കാണിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","കൃത്യമായ മുഴക്കോലും കൃത്യമായ തുലാസും കൃത്യമായ ഏഫായും കൃത്യമായ ഹീനും ഉപയോഗിക്കുക. നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന ദൈവമായ യഹോവ ഞാൻ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘എന്റെ സകല ഉത്തരവുകളും എല്ലാ നിയമങ്ങളും പ്രമാണിച്ചു നടക്കുക; ഞാൻ യഹോവ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ഇസ്രായേൽമക്കളോടു പറയുക: ‘ഇസ്രായേല്യരോ ഇസ്രായേലിൽ പാർക്കുന്ന ഏതെങ്കിലും പ്രവാസിയോ തങ്ങളുടെ കുഞ്ഞുങ്ങളിൽ ഒന്നിനെയെങ്കിലും മോലെക്കിനു യാഗമർപ്പിച്ചാൽ ആ മനുഷ്യനെ വധിക്കണം. ദേശത്തിലെ ജനം അയാളെ കല്ലെറിയണം. ");
INSERT INTO malc_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","അയാൾ തന്റെ കുഞ്ഞുങ്ങളെ മോലെക്കിനു യാഗമർപ്പിച്ച് എന്റെ വിശുദ്ധമന്ദിരത്തെ മലിനമാക്കുകയും എന്റെ വിശുദ്ധനാമത്തെ നിന്ദിക്കുകയും ചെയ്തതുകൊണ്ടു ഞാൻ ആ മനുഷ്യനു വിരോധമായി എന്റെ മുഖംതിരിക്കുകയും അയാളെ സ്വജനത്തിൽനിന്ന് ഛേദിച്ചുകളയുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ആ മനുഷ്യൻ തന്റെ കുഞ്ഞുങ്ങളിലൊന്നിനെ മോലെക്കിനു യാഗമർപ്പിക്കുമ്പോൾ ദേശത്തിലെ ജനം അയാളെ കൊല്ലാതെ കണ്ണടച്ചുകളഞ്ഞാൽ, ");
INSERT INTO malc_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ഞാൻ ആ മനുഷ്യനും അയാളുടെ കുടുംബത്തിനും വിരോധമായി മുഖംതിരിച്ച് അയാളെയും മോലെക്കിനോടു പരസംഗം ചെയ്യുന്ന എല്ലാവരെയും അവരുടെ ജനത്തിൽനിന്ന് ഛേദിച്ചുകളയും. ");
INSERT INTO malc_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘വെളിച്ചപ്പാടുകളിലേക്കും ഭൂതസേവക്കാരിലേക്കും തിരിഞ്ഞ് അവരെ അനുഗമിക്കുന്നതിലൂടെ പരസംഗം ചെയ്യുന്നവർക്കെതിരേ ഞാൻ മുഖംതിരിക്കുകയും സ്വജനത്തിൽനിന്ന് അവരെ ഛേദിച്ചുകളയുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആയതുകൊണ്ടു നിങ്ങളെത്തന്നെ ശുദ്ധീകരിച്ച് വിശുദ്ധരായിരിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","എന്റെ ഉത്തരവുകൾ പ്രമാണിച്ചു നടക്കുക. ഞാൻ നിങ്ങളെ വിശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘പിതാവിനെയോ മാതാവിനെയോ ശപിക്കുന്നയാൾ മരണശിക്ഷ അനുഭവിക്കണം. അയാൾ തന്റെ പിതാവിനെയോ മാതാവിനെയോ ശപിച്ചതുകൊണ്ട്; ആ കുറ്റത്തിന്റെ രക്തം അയാളുടെ തലമേലിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘മറ്റൊരാളിന്റെ ഭാര്യയുമായി—തന്റെ അയൽക്കാരന്റെ ഭാര്യയുമായിത്തന്നെ—ഒരാൾ വ്യഭിചാരം ചെയ്താൽ, വ്യഭിചാരിയെയും വ്യഭിചാരിണിയെയും വധിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘ഒരാൾ തന്റെ പിതാവിന്റെ ഭാര്യയുടെകൂടെ ലൈംഗികബന്ധത്തിലേർപ്പെട്ടാൽ, അയാൾ തന്റെ പിതാവിനെ അപമാനിക്കുന്നു; അവർ ഇരുവരും മരണശിക്ഷ അനുഭവിക്കണം. അവരുടെ രക്തം അവരുടെ തലമേലിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘ഒരാൾ തന്റെ മരുമകളുടെകൂടെ ലൈംഗികബന്ധത്തിലേർപ്പെട്ടാൽ, അവരെ രണ്ടുപേരെയും കൊല്ലണം. അവരുടെ പ്രവൃത്തി നികൃഷ്ടം; അവരുടെ രക്തം അവരുടെ തലമേലിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘ഒരു പുരുഷൻ സ്ത്രീയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടുന്നതുപോലെ പുരുഷൻ പുരുഷനോടുകൂടെ കിടക്കപങ്കിട്ടാൽ, അവർ രണ്ടുപേരും അറപ്പായതു പ്രവർത്തിച്ചിരിക്കുന്നു. അവരെ കൊല്ലണം; അവരുടെ രക്തം അവരുടെ തലമേലിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘ഒരു പുരുഷൻ ഒരു സ്ത്രീയെയും അവളുടെ മാതാവിനെയും വിവാഹംകഴിച്ചാൽ, അതു ദുഷ്ടതയാണ്. നിങ്ങളുടെ മധ്യത്തിൽ ദുഷ്ടത ഇല്ലാതെയിരിക്കാൻ അയാളെയും ആ സ്ത്രീകളെയും തീയിൽ ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘ഒരു പുരുഷൻ ഒരു മൃഗവുമായി ലൈംഗികബന്ധത്തിലേർപ്പെട്ടാൽ അയാളെ കൊല്ലണം, ആ മൃഗത്തെയും കൊല്ലണം. ");
INSERT INTO malc_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘ഒരു മൃഗത്തോടൊപ്പം ലൈംഗികബന്ധത്തിലേർപ്പെടേണ്ടതിന് ഒരു സ്ത്രീ അതിനെ സമീപിച്ചാൽ ആ സ്ത്രീയെയും മൃഗത്തെയും കൊല്ലണം. അവർ മരണശിക്ഷ അനുഭവിക്കണം; അവരുടെ രക്തം അവരുടെ തലമേലിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘ഒരു പുരുഷൻ തന്റെ പിതാവിന്റെയോ മാതാവിന്റെയോ മകളായ തന്റെ സഹോദരിയെ വിവാഹംകഴിക്കുകയും അവർ പരസ്പരം ലൈംഗികബന്ധത്തിലേർപ്പെടുകയും ചെയ്താൽ അതു നിന്ദ്യം. അവരെ അവരുടെ ജനത്തിന്റെ കണ്മുന്നിൽവെച്ചുതന്നെ വധിക്കണം. അവൻ തന്റെ സഹോദരിയെ അപമാനിച്ചു, അവൻ കുറ്റക്കാരനായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘ഒരു പുരുഷൻ ഋതുമതിയായ ഒരു സ്ത്രീയോടുകൂടെ ലൈംഗികബന്ധത്തിലേർപ്പെട്ടാൽ, അവൻ അവളുടെ സ്രവത്തിന്റെ ഉറവിടം അനാവൃതമാക്കി; അവളും അത് അനാവൃതമാക്കി. അവർ രണ്ടുപേരെയും അവരുടെ ജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘നിന്റെ മാതാവിന്റെയോ പിതാവിന്റെയോ സഹോദരിയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെടരുത്, അത് അടുത്ത ബന്ധുക്കാരിയെ അപമാനിക്കലാണ്, നിങ്ങൾ ഇരുവരും കുറ്റക്കാരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘ഒരു പുരുഷൻ തന്റെ അമ്മായിയുമായി ലൈംഗികബന്ധത്തിലേർപ്പെട്ടാൽ അവൻ തന്റെ ഇളയപ്പനെ അപമാനിച്ചു. അവർ കുറ്റക്കാരായിരിക്കും. അവർ സന്താനരഹിതരായി മരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘ഒരു പുരുഷൻ തന്റെ സഹോദരന്റെ ഭാര്യയെ വിവാഹംകഴിക്കുന്നെങ്കിൽ, അത് ഒരു മലിനപ്രവൃത്തി; അയാൾ തന്റെ സഹോദരനെ അപമാനിച്ചു. അവർ സന്തതിയില്ലാത്തവർ ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘നിങ്ങൾക്കു വസിക്കാനായി ഞാൻ നിങ്ങളെ കൊണ്ടുപോകുന്ന ദേശം നിങ്ങളെ ഉപേക്ഷിക്കാതിരിക്കേണ്ടതിന് എന്റെ എല്ലാ ഉത്തരവുകളും നിയമങ്ങളും പാലിച്ച് അവ അനുവർത്തിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ഞാൻ നിങ്ങളുടെമുമ്പിൽനിന്ന് ഓടിച്ചുകളയുന്ന ജനതയുടെ ആചാരരീതികൾ അനുസരിച്ചു ജീവിക്കരുത്. അവർ ഇവയൊക്കെ ചെയ്തതുകൊണ്ടു ഞാൻ അവരെ കഠിനമായി വെറുക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","എന്നാൽ ഞാൻ നിങ്ങളോടു പറയുന്നു, “നിങ്ങൾ അവരുടെ ദേശം കൈവശമാക്കും; പാലും തേനും ഒഴുകുന്ന ആ ദേശം ഞാൻ നിങ്ങൾക്ക് അവകാശമായിത്തരും.” ജനതകളിൽനിന്നു നിങ്ങളെ വേർതിരിച്ച ദൈവമായ യഹോവ ഞാൻ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘നിങ്ങൾ അതുകൊണ്ടു ശുദ്ധവും അശുദ്ധവുമായ മൃഗങ്ങൾതമ്മിലും ശുദ്ധവും അശുദ്ധവുമായ പക്ഷികൾതമ്മിലും വേർതിരിക്കണം. നിങ്ങൾക്ക് അശുദ്ധമായി ഞാൻ മാറ്റിയിട്ടുള്ള ഏതൊരു മൃഗത്താലോ പക്ഷിയാലോ നിലത്തു ചരിക്കുന്ന യാതൊന്നിനാലുമോ നിങ്ങളെത്തന്നെ അശുദ്ധരാക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","യഹോവയായ ഞാൻ വിശുദ്ധനായതുകൊണ്ടു നിങ്ങൾ എനിക്കു വിശുദ്ധരായിരിക്കണം. എനിക്കു സ്വന്തമായിരിക്കേണ്ടതിനു നിങ്ങളെ ഞാൻ ഇതര ജനതകളിൽനിന്ന് വേർതിരിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘നിങ്ങളുടെ ഇടയിൽ വെളിച്ചപ്പാടുകളോ ഭൂതസേവക്കാരോ ആയ സ്ത്രീപുരുഷന്മാർ ഉണ്ടെങ്കിൽ അവർ മരണശിക്ഷ അനുഭവിക്കണം. നിങ്ങൾ അവരെ കല്ലെറിയണം; അവരുടെ രക്തം അവരുടെ തലമേലിരിക്കും.’ ” ");
INSERT INTO malc_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാരോടു സംസാരിക്കുക. അവരോട് ഇപ്രകാരം പറയുക: ‘പുരോഹിതൻ തന്റെ ജനത്തിൽ ആരുടെയെങ്കിലും ശവത്തിൽ സ്പർശിച്ച് സ്വയം അശുദ്ധമാക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","3","എന്നാൽ തന്റെ മാതാവ്, പിതാവ്, മകൻ, മകൾ, സഹോദരൻ, കന്യകയായ സഹോദരി—അവൾക്ക് ഭർത്താവ് ഇല്ലാത്തതിനാൽ അദ്ദേഹത്തെ ആശ്രയിച്ചാണല്ലോ കഴിയുന്നത്— എന്നിങ്ങനെയുള്ള അടുത്ത ബന്ധുക്കളാൽ അദ്ദേഹത്തിന് ആചാരപരമായി അശുദ്ധനാകാം. ");
INSERT INTO malc_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","അയാൾ വിവാഹത്താൽ ബന്ധുക്കളായിത്തീർന്ന ആളുകൾക്കുവേണ്ടി സ്വയം അശുദ്ധനാകരുത്, അങ്ങനെ സ്വയം മാലിന്യമേൽക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘പുരോഹിതൻ തലമുണ്ഡനം ചെയ്യുകയോ താടിയുടെ വക്കുകൾ വടിക്കുകയോ ശരീരത്തിൽ മുറിവുണ്ടാക്കുകയോ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","അവർ തങ്ങളുടെ ദൈവത്തിന്റെ നാമം അശുദ്ധമാക്കാതെ തങ്ങളുടെ ദൈവത്തിനു വിശുദ്ധരായിരിക്കണം. തങ്ങളുടെ ദൈവത്തിന്റെ ഭോജനമായ യഹോവയുടെ ദഹനയാഗങ്ങൾ അർപ്പിക്കുന്നവരായതുകൊണ്ട് അവർ വിശുദ്ധരായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘അവർ, വേശ്യാവൃത്തിയാൽ മലിനയായവളോ ഭർത്താവിൽനിന്ന് വേർപെട്ടവളോ ആയ സ്ത്രീയെ വിവാഹംകഴിക്കരുത്. കാരണം പുരോഹിതന്മാർ ദൈവത്തിനു വിശുദ്ധരാകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","നിങ്ങൾ ഓരോരുത്തരും അവരെ വിശുദ്ധരായി പരിഗണിക്കണം, കാരണം പുരോഹിതന്മാർ നിങ്ങളുടെ ദൈവത്തിനു ഭോജനം അർപ്പിക്കുന്നവരാണ്. നിങ്ങളെ വിശുദ്ധീകരിക്കുന്ന യഹോവയായ ഞാൻ വിശുദ്ധൻ ആകുകയാൽ നിങ്ങൾ അവരെ വിശുദ്ധരായി കണക്കാക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘ഒരു പുരോഹിതന്റെ മകൾ വേശ്യയായി സ്വയം മലിനയാക്കിയാൽ, അവൾ അവളുടെ പിതാവിനെ അപമാനിക്കുന്നു, അവളെ തീയിൽ ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘തന്റെ സഹോദരന്മാരുടെ ഇടയിൽനിന്ന് തലയിൽ അഭിഷേകതൈലം ഒഴിക്കപ്പെട്ടവനും, പൗരോഹിത്യവസ്ത്രങ്ങൾ ധരിക്കാൻ സമർപ്പിക്കപ്പെട്ടവനുമായ മഹാപുരോഹിതൻ തന്റെ തലമുടി ചീകാതിരിക്കുകയോ വസ്ത്രം കീറുകയോ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ഒരു ശവശരീരം ഉള്ളിടത്ത് അദ്ദേഹം പ്രവേശിക്കരുത്. തന്റെ പിതാവിനുവേണ്ടിയോ മാതാവിനുവേണ്ടിയോപോലും അദ്ദേഹം സ്വയം അശുദ്ധനാകരുത്. ");
INSERT INTO malc_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","തന്റെ ദൈവത്തിന്റെ അഭിഷേകതൈലത്താൽ അദ്ദേഹം പ്രതിഷ്ഠിക്കപ്പെട്ടിരിക്കുകയാൽ അദ്ദേഹം തന്റെ ദൈവത്തിന്റെ വിശുദ്ധമന്ദിരം വിട്ടുപോകുകയോ അതിന്റെ വിശുദ്ധി നഷ്ടപ്പെടുത്തുകയോ ചെയ്യരുത്. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘അദ്ദേഹം വിവാഹംകഴിക്കുന്ന സ്ത്രീ കന്യകയായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","അദ്ദേഹം ഒരു വിധവയെയോ ഉപേക്ഷിക്കപ്പെട്ടവളെയോ വേശ്യാവൃത്തിയാൽ അശുദ്ധമാക്കപ്പെട്ടവളെയോ വിവാഹംകഴിക്കരുത്. സ്വജനത്തിലുള്ള ഒരു കന്യകയെമാത്രമേ വിവാഹംകഴിക്കാവൂ. ");
INSERT INTO malc_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ഇങ്ങനെയായാൽ അദ്ദേഹം തന്റെ സന്തതിയെ തന്റെ ജനത്തിനിടയിൽ അശുദ്ധമാക്കുകയില്ല; അവനെ വിശുദ്ധീകരിക്കുന്ന യഹോവ ഞാൻ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“അഹരോനോടു പറയുക: ‘നിന്റെ സന്തതിപരമ്പരയിൽ വികലാംഗർ ആരും ഒരുനാളും, അവരുടെ ദൈവത്തിന്റെ ഭോജനം അർപ്പിക്കാൻ അടുത്തുവരരുത്. ");
INSERT INTO malc_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","അന്ധൻ, മുടന്തൻ, വിരൂപി, വൈകല്യമുള്ളവൻ, ");
INSERT INTO malc_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","കാലൊടിഞ്ഞവൻ, കൈയൊടിഞ്ഞവൻ, ");
INSERT INTO malc_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","കൂനൻ, കുള്ളൻ, കാഴ്ചയ്ക്കു ന്യൂനതയുള്ളവൻ, ചൊറിയുള്ളവൻ, ചുണങ്ങുള്ളവൻ, ഷണ്ഡൻ എന്നിങ്ങനെയുള്ളവരാരും അടുത്തുവരരുത്. ");
INSERT INTO malc_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","പുരോഹിതനായ അഹരോന്റെ പുത്രന്മാരിൽ ഊനമുള്ളവൻ യഹോവയ്ക്കു ദഹനയാഗം അർപ്പിക്കാൻ അടുത്തുവരരുത്. അവന് ഒരു ഊനമുണ്ട്; തന്റെ ദൈവത്തിനു ഭോജനം അർപ്പിക്കാൻ അവൻ അടുത്തുവരരുത്. ");
INSERT INTO malc_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","തന്റെ ദൈവത്തിന്റെ അതിവിശുദ്ധഭോജനവും വിശുദ്ധഭോജനവും അയാൾക്കു ഭക്ഷിക്കാം, ");
INSERT INTO malc_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","എങ്കിലും അയാൾ ഊനമുള്ളവൻ ആകുകകൊണ്ട് തിരശ്ശീലയ്ക്കടുത്തു പോകുകയോ യാഗപീഠത്തെ സമീപിക്കുകയോ ചെയ്ത് എന്റെ വിശുദ്ധമന്ദിരത്തിന്റെ വിശുദ്ധി നഷ്ടപ്പെടുത്തരുത്. അവരെ വിശുദ്ധീകരിക്കുന്ന യഹോവ ഞാൻ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","അങ്ങനെ മോശ ഇത് അഹരോനോടും പുത്രന്മാരോടും സകല ഇസ്രായേല്യരോടും പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ഇസ്രായേല്യർ എനിക്കു ശുദ്ധീകരിക്കുന്ന വിശുദ്ധയാഗങ്ങളെ, ബഹുമാനത്തോടെ കൈകാര്യം ചെയ്യണമെന്നും, അങ്ങനെ അവർ എന്റെ വിശുദ്ധനാമത്തെ അശുദ്ധമാക്കരുതെന്നും അഹരോനോടും അവന്റെ പുത്രന്മാരോടും പറയുക. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“അവരോടു പറയുക: ‘നിങ്ങളുടെ വരുംതലമുറകളിൽ, നിങ്ങളുടെ സന്തതിപരമ്പരയിൽ ആരെങ്കിലും ആചാരപരമായി അശുദ്ധരായിരിക്കുമ്പോൾ, ഇസ്രായേല്യർ യഹോവയ്ക്കു വിശുദ്ധീകരിച്ച വഴിപാടുകളുടെ അടുക്കൽ വരികയാണെങ്കിൽ, അയാളെ എന്റെ സന്നിധിയിൽനിന്ന് ഛേദിച്ചുകളയണം. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘അഹരോന്റെ സന്തതിയിൽ ആർക്കെങ്കിലും കുഷ്ഠമോ ശുക്ലസ്രവമോ ഉണ്ടെങ്കിൽ, ആ മനുഷ്യൻ ശുദ്ധമാകുന്നതുവരെ വിശുദ്ധവസ്തുക്കൾ ഭക്ഷിക്കരുത്. ശവത്തെയോ ബീജസ്ഖലനമുള്ളവനെയോ സ്പർശിക്കുന്നവൻ അശുദ്ധനാകും. ");
INSERT INTO malc_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","അശുദ്ധമായ ഏതെങ്കിലും ഇഴജന്തുവിനെ സ്പർശിക്കുന്നവർ, ആചാരപരമായി അശുദ്ധനായ ഒരു മനുഷ്യനെ സ്പർശിക്കുന്നവർ, ഏതെങ്കിലും മാലിന്യത്തെ സ്പർശിക്കുന്നവർ; അശുദ്ധി എന്തുതന്നെയായാലും, ഇങ്ങനെയുള്ളവർ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ഇവ ഏതെങ്കിലും സ്പർശിക്കുന്നവർ സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. അവർ വെള്ളത്തിൽ കുളിച്ചിട്ടല്ലാതെ വിശുദ്ധവസ്തുക്കൾ ഒന്നും ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","സൂര്യൻ അസ്തമിക്കുമ്പോൾ അവർ ശുദ്ധരാകും. അതിനുശേഷം അവർക്ക് വിശുദ്ധവസ്തുക്കൾ ഭക്ഷിക്കാം. അത് അവരുടെ ആഹാരമല്ലോ. ");
INSERT INTO malc_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ചത്തതോ വന്യമൃഗങ്ങൾ കടിച്ചുകീറിയതോ ആയ ഒന്നും ഭക്ഷിച്ച് അവർ അശുദ്ധരാകരുത്. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘പുരോഹിതന്മാർ അവ അശ്രദ്ധയോടെ കൈകാര്യം ചെയ്തു കുറ്റക്കാരായി മരിക്കാതിരിക്കാൻ എന്റെ ശുശ്രൂഷ ഗൗരവത്തോടെ ചെയ്യണം. ഞാൻ അവരെ വിശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘പുരോഹിതകുടുംബത്തിന് അന്യരായ ഒരാളും വിശുദ്ധവസ്തുക്കളിൽനിന്ന് ഭക്ഷിക്കരുത്, പുരോഹിതന്റെ അതിഥിയോ കൂലിക്കാരനോ അതു തിന്നരുത്. ");
INSERT INTO malc_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","എന്നാൽ ഒരു പുരോഹിതൻ ഒരു അടിമയെ പണം കൊടുത്തു വാങ്ങുകയോ തന്റെ വീട്ടിൽ ഒരു അടിമ ജനിക്കുകയോ ചെയ്താൽ ആ അടിമയ്ക്ക് അവന്റെ ആഹാരം ഭക്ഷിക്കാം. ");
INSERT INTO malc_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ഒരു പുരോഹിതന്റെ മകൾ പുരോഹിതനല്ലാത്ത ഒരാളെ വിവാഹംകഴിച്ചാൽ അവൾ വിശുദ്ധമായ ഓഹരിയിൽനിന്ന് ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","എന്നാൽ ഒരു പുരോഹിതന്റെ മകൾ കുഞ്ഞുങ്ങളില്ലാതെ വിധവയാകുകയോ ഉപേക്ഷിക്കപ്പെടുകയോ ചെയ്തിട്ട്, അവളുടെ യൗവനകാലത്തിലെന്നപോലെ അവളുടെ പിതാവിന്റെ വീട്ടിലേക്കു മടങ്ങിവന്നാൽ, അവൾക്ക് അവളുടെ പിതാവിന്റെ ആഹാരം ഭക്ഷിക്കാം. എങ്കിലും ഒരു പുരോഹിതകുടുംബത്തിനു പുറത്തുനിന്നുള്ള ആരും അതിൽനിന്നും ഭക്ഷിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘ഒരാൾ അബദ്ധത്തിൽ വിശുദ്ധയാഗം ഭക്ഷിച്ചുപോയാൽ അയാൾ ഭക്ഷിച്ച യാഗവസ്തുവും അതിന്റെ വിലയുടെ അഞ്ചിലൊന്നുംകൂട്ടി പുരോഹിതനു നഷ്ടപരിഹാരം ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ഇസ്രായേല്യർ യഹോവയ്ക്ക് അർപ്പിക്കുന്ന വിശുദ്ധവസ്തുക്കൾ—അനുവദനീയമല്ലാത്ത വ്യക്തികൾക്ക് ഭക്ഷിക്കാൻ നൽകുന്നതുമൂലം—പുരോഹിതന്മാർ അശുദ്ധമാക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ഈ അകൃത്യത്തിന്റെ കുറ്റം അവരുടെമേൽ വരികയും നഷ്ടപരിഹാരം നൽകേണ്ടിവരികയും ചെയ്യും. ഞാൻ അവരെ വിശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“അഹരോനോടും അവന്റെ പുത്രന്മാരോടും സകല ഇസ്രായേല്യരോടും സംസാരിക്കുക. അവരോട് ഇപ്രകാരം പറയുക: ‘നിങ്ങളിലൊരാൾ—ഇസ്രായേല്യരോ ഇസ്രായേലിൽ പാർക്കുന്ന പ്രവാസിയോ—നേർച്ചയായോ സ്വമേധാദാനമായോ യഹോവയ്ക്ക് ഒരു ഹോമയാഗം കൊണ്ടുവരുന്നെങ്കിൽ, ");
INSERT INTO malc_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","അതു നിങ്ങളുടെ പേർക്കു സ്വീകാര്യമായിരിക്കാൻ, മാടുകളിൽനിന്നോ ചെമ്മരിയാടുകളിൽനിന്നോ കോലാടുകളിൽനിന്നോ ഊനമില്ലാത്ത ഒരു ആണിനെ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ഊനമുള്ള ഒന്നിനെയും കൊണ്ടുവരരുത്. അതിനാൽ നിങ്ങൾക്കു പ്രസാദം ലഭിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ഒരു പ്രത്യേക നേർച്ച നിറവേറ്റാനോ സ്വമേധാദാനം അർപ്പിക്കാനോ കാലിക്കൂട്ടത്തിൽനിന്നാകട്ടെ ആട്ടിൻപറ്റത്തിൽനിന്നാകട്ടെ, ഒരാൾ ഒരു സമാധാനയാഗം യഹോവയ്ക്ക് അർപ്പിക്കുമ്പോൾ, അതു സ്വീകാര്യമായിരിക്കാൻ ഊനമോ കളങ്കമോ ഇല്ലാത്തതായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","കുരുടുള്ളതോ മുറിവേറ്റതോ അംഗഭംഗം വന്നതോ അരിമ്പാറയുള്ളതോ പഴുത്തു സ്രവം ഒലിക്കുന്ന ചുണങ്ങുള്ളതോ ആയ ഒന്നും യഹോവയ്ക്ക് അർപ്പിക്കരുത്. ഇവയിലൊന്നും യഹോവയ്ക്കു ദഹനയാഗമായി യാഗപീഠത്തിൽ അർപ്പിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","എങ്കിലും വിരൂപമായതോ കുറുകിയതോ ആയ ഒരു കാളയെയോ ആണാടിനെയോ സ്വമേധാദാനമായി അർപ്പിക്കാം; എന്നാൽ അത് ഒരു നേർച്ചയുടെ നിർവഹണമായി സ്വീകാര്യമല്ല. ");
INSERT INTO malc_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","വൃഷണങ്ങൾ തകർന്നതോ ചതച്ചതോ കീറിയതോ മുറിച്ചതോ ആയ മൃഗത്തെ നിങ്ങൾ യഹോവയ്ക്ക് അർപ്പിക്കരുത്. നിങ്ങളുടെ സ്വന്തം ദേശത്ത് ഇതു ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ഇങ്ങനെയുള്ള മൃഗങ്ങളെ ഒരു പ്രവാസിയുടെ കൈയിൽനിന്ന് സ്വീകരിച്ചു നിങ്ങളുടെ ദൈവത്തിനു ഭോജനമായി അർപ്പിക്കരുത്. അവ വിരൂപവും അംഗഹീനമുള്ളതും ആയതുകൊണ്ട് അവയാൽ നിങ്ങൾക്കു പ്രസാദം ലഭിക്കുകയില്ല.’ ” ");
INSERT INTO malc_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ഒരു കന്നുകുട്ടിയോ ആട്ടിൻകുട്ടിയോ കോലാടോ പിറന്നാൽ അത് ഏഴുദിവസം തള്ളയോടുകൂടെ ആയിരിക്കണം. എട്ടാംദിവസംമുതൽ യഹോവയ്ക്ക് ഒരു ദഹനയാഗമായി സ്വീകാര്യമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ഒരു പശുവിനെയോ ഒരു ആടിനെയോ കൊല്ലുന്നദിവസംതന്നെ അതിന്റെ കുട്ടിയെയും കൊല്ലരുത്. ");
INSERT INTO malc_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“നിങ്ങൾ യഹോവയ്ക്ക് ഒരു സ്തോത്രയാഗം അർപ്പിക്കുമ്പോൾ നിങ്ങളുടെ പേർക്കു സ്വീകാര്യമാകുന്നവിധം അർപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","അന്നുതന്നെ അതു ഭക്ഷിക്കണം. പ്രഭാതംവരെ അതിൽ അൽപ്പംപോലും ശേഷിപ്പിക്കരുത്. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“എന്റെ കൽപ്പനകൾ പ്രമാണിച്ച് അവയെ അനുസരിക്കുക. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","എന്റെ വിശുദ്ധനാമത്തെ നിങ്ങൾ അശുദ്ധമാക്കരുത്. ഇസ്രായേൽമക്കളുടെ മധ്യേ ഞാൻ വിശുദ്ധീകരിക്കപ്പെടണം. ഞാൻ നിങ്ങളെ വിശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","നിങ്ങളുടെ ദൈവമായിരിക്കാൻ നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന ഞാൻ യഹോവ ആകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ഇസ്രായേൽമക്കളോടു സംസാരിച്ച് അവരോട് ഇപ്രകാരം പറയുക: ‘സ്ഥാപിക്കപ്പെട്ട എന്റെ ഉത്സവങ്ങൾ, വിശുദ്ധസഭായോഗങ്ങളായി നിങ്ങൾ വിളംബരം ചെയ്യേണ്ട യഹോവയുടെ ഉത്സവങ്ങൾ, ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘നിങ്ങൾക്കു ജോലിചെയ്യാൻ ആറുദിവസമുണ്ട്, എന്നാൽ ഏഴാംദിവസം വിശ്രമത്തിനുള്ള ശബ്ബത്താണ്. വിശുദ്ധസഭായോഗത്തിനുള്ള ദിവസം. നിങ്ങൾ എവിടെ താമസിച്ചാലും നിങ്ങൾ ജോലിയൊന്നും ചെയ്യരുത്; അതു യഹോവയുടെ ശബ്ബത്താണ്. ");
INSERT INTO malc_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘നിശ്ചയിക്കപ്പെട്ട സമയത്ത് വിശുദ്ധസഭായോഗം വിളിച്ചുകൂട്ടേണ്ടുന്ന യഹോവയുടെ ഉത്സവങ്ങൾ ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","യഹോവയുടെ പെസഹ ഒന്നാംമാസം പതിന്നാലാംതീയതി സന്ധ്യക്ക് ആരംഭിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ആ മാസം പതിനഞ്ചാംതീയതി യഹോവയ്ക്കു പുളിപ്പില്ലാത്ത അപ്പത്തിന്റെ പെരുന്നാൾ ആരംഭിക്കും, നിങ്ങൾ ഏഴുദിവസം പുളിപ്പില്ലാത്ത അപ്പം ഭക്ഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ഒന്നാംദിവസം വിശുദ്ധസഭായോഗം കൂടണം, അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ഏഴുദിവസം യഹോവയ്ക്കു ദഹനയാഗം അർപ്പിക്കണം. ഏഴാംദിവസം വിശുദ്ധസഭായോഗം കൂടണം, അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്.’ ” ");
INSERT INTO malc_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ഇസ്രായേല്യരോടു സംസാരിക്കുക. അവരോട് ഇപ്രകാരം പറയുക: ‘ഞാൻ നിങ്ങൾക്കു തരുന്ന ദേശത്തു നിങ്ങൾ പ്രവേശിച്ചു വിളവെടുക്കുമ്പോൾ, നിങ്ങൾ കൊയ്യുന്ന ആദ്യധാന്യത്തിന്റെ കറ്റ പുരോഹിതന്റെയടുക്കൽ കൊണ്ടുവരിക. ");
INSERT INTO malc_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","നിങ്ങളുടെപേർക്ക് അതു സ്വീകാര്യമാകാൻ അദ്ദേഹം കറ്റ യഹോവയുടെ സന്നിധിയിൽ ഉയർത്തി അർപ്പിക്കണം. ശബ്ബത്തിന്റെ പിറ്റേദിവസം പുരോഹിതൻ അത് ഉയർത്തണം. ");
INSERT INTO malc_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","നിങ്ങൾ കറ്റ ദൈവസന്നിധിയിൽ ഉയർത്തി അർപ്പിക്കുന്ന ദിവസം, ഒരുവയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഒരു ആട്ടിൻകുട്ടിയെ ദഹനയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","അതോടൊപ്പം അതിന്റെ ധാന്യവഴിപാടായി യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗമായ ഒലിവെണ്ണചേർത്ത് രണ്ട് ഓമെർ നേർമയുള്ള മാവും അതിന്റെ പാനീയയാഗമായ കാൽ ഹീൻ വീഞ്ഞും യഹോവയ്ക്കു ദഹനയാഗം കഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ഈ യാഗം നിങ്ങളുടെ ദൈവത്തിനു കൊണ്ടുവരുന്നതുവരെ അപ്പമോ വറുത്തതോ പുതിയ ധാന്യമോ ഭക്ഷിക്കരുത്. ഇതു നിങ്ങൾ പാർക്കുന്നിടത്തൊക്കെയും എല്ലാ തലമുറകളിലും എന്നേക്കുമുള്ള പ്രമാണമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘നിങ്ങൾ വിശിഷ്ടയാഗാർപ്പണത്തിനു കറ്റ കൊണ്ടുവന്ന ശബ്ബത്തിന്റെ പിറ്റേദിവസംമുതൽ ഏഴു പൂർണ ആഴ്ചകൾ എണ്ണണം. ");
INSERT INTO malc_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ഏഴാമത്തെ ശബ്ബത്തിന്റെ പിറ്റേദിവസംവരെ അൻപതു ദിവസം എണ്ണുക, പിന്നെ യഹോവയ്ക്കു പുതിയ ഭോജനയാഗം അർപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","നിങ്ങൾ എവിടെ താമസിച്ചാലും ആ വാസസ്ഥലങ്ങളിൽനിന്ന് രണ്ട് ഓമെർ നേർമയുള്ള മാവിലുണ്ടാക്കിയ രണ്ട് അപ്പം യഹോവയ്ക്ക് ആദ്യഫലങ്ങളുടെ വിശിഷ്ടയാഗാർപ്പണമായി കൊണ്ടുവരണം. അത് പുളിപ്പിച്ചു ചുട്ടതായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ഈ അപ്പത്തോടൊപ്പം ഒരുവയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഏഴ് ആണാട്ടിൻകുട്ടിയും ഒരു കാളക്കിടാവും രണ്ട് ആട്ടുകൊറ്റനും കൊണ്ടുവരണം. അവയുടെ ഭോജനയാഗവും പാനീയയാഗവുംകൂടെ ചേർത്ത് അവ യഹോവയ്ക്ക് ഒരു ദഹനയാഗമായിരിക്കും; യഹോവയ്ക്കു പ്രസാദകരമായ ഹൃദ്യസുഗന്ധമായ ദഹനയാഗംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","പിന്നെ ഒരു ആൺകോലാടിനെ പാപശുദ്ധീകരണയാഗമായും ഒരുവയസ്സു പ്രായമുള്ള രണ്ട് ആട്ടിൻകുട്ടികളെ സമാധാനയാഗമായും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","പുരോഹിതൻ ആദ്യഫലത്തിന്റെ അപ്പത്തോടുകൂടെ ആ രണ്ട് ആട്ടിൻകുട്ടികളെയും യഹോവയുടെ സന്നിധിയിൽ ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി അർപ്പിക്കണം. അവ പുരോഹിതന്മാർക്കുവേണ്ടി യഹോവയ്ക്ക് അർപ്പിക്കുന്ന വിശുദ്ധയാഗം. ");
INSERT INTO malc_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ആ ദിവസംതന്നെ നിങ്ങൾ വിശുദ്ധസഭായോഗം വിളംബരം ചെയ്യണം. അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. ഇതു നിങ്ങൾ പാർക്കുന്നിടത്തൊക്കെയും വരാനുള്ള തലമുറകൾക്ക് എന്നേക്കുമുള്ള നിയമം ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘നിങ്ങളുടെ നിലത്തിലെ വിള ശേഖരിക്കുമ്പോൾ, അരികുചേർത്തു കൊയ്യുകയോ കൊയ്തതിന്റെ കാലാപെറുക്കുകയോ ചെയ്യരുത്. അവ ദരിദ്രനും നിങ്ങളുടെ മധ്യേ പാർക്കുന്ന പ്രവാസിക്കും വിടണം. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, ");
INSERT INTO malc_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ഇസ്രായേല്യരോടു പറയുക: ‘ഏഴാംമാസത്തിന്റെ ഒന്നാംദിവസം നിങ്ങൾക്കു കാഹളം മുഴക്കിക്കൊണ്ടു സ്മാരകോത്സവം ആചരിക്കുന്ന വിശുദ്ധസഭായോഗമുള്ള വിശ്രമത്തിനുള്ള ശബ്ബത്തായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. എന്നാൽ യഹോവയ്ക്ക് ഒരു ദഹനയാഗം അർപ്പിക്കുക.’ ” ");
INSERT INTO malc_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ഏഴാംമാസം പത്താംതീയതി പാപപരിഹാരദിനമാണ്. അന്ന് വിശുദ്ധസഭായോഗം ചേരുകയും ആത്മതപനം ചെയ്യുകയും, യഹോവയ്ക്ക് ഒരു ദഹനയാഗം അർപ്പിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","നിങ്ങളുടെ ദൈവമായ യഹോവയുടെമുമ്പാകെ നിങ്ങൾക്കുവേണ്ടി പാപപരിഹാരം വരുത്തുന്ന ദിനമായതുകൊണ്ട് ഒരു ജോലിയും ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","അന്ന് ആത്മതപനം ചെയ്യാത്തവരെ തങ്ങളുടെ ജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","അന്ന് ആരെങ്കിലും എന്തെങ്കിലും ജോലിചെയ്താൽ അവരെ അവരുടെ ജനത്തിൽനിന്ന് ഞാൻ നശിപ്പിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","നിങ്ങൾ യാതൊരു ജോലിയും ചെയ്യരുത്. ഇതു നിങ്ങൾ പാർക്കുന്നിടത്തൊക്കെയും വരാനുള്ള തലമുറകൾക്ക് എന്നേക്കുമുള്ള നിയമം ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","അതു വിശ്രമത്തിന്റെ ശബ്ബത്താണ്, നിങ്ങൾ ആത്മതപനംചെയ്യണം. ആ മാസം ഒൻപതാംദിവസം സന്ധ്യമുതൽ പിറ്റേന്ന് സന്ധ്യവരെ നിങ്ങൾ നിങ്ങളുടെ ശബ്ബത്ത് ആചരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, ");
INSERT INTO malc_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ഇസ്രായേല്യരോടു പറയുക: ‘ഏഴാംമാസം പതിനഞ്ചാംതീയതി യഹോവയുടെ കൂടാരപ്പെരുന്നാൾ ആരംഭിക്കും; അത് ഏഴുദിവസം നീണ്ടുനിൽക്കും. ");
INSERT INTO malc_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ഒന്നാംദിവസം വിശുദ്ധ സഭായോഗമാണ്; അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ഏഴുദിവസം യഹോവയ്ക്കു ദഹനയാഗങ്ങൾ അർപ്പിക്കുക. എട്ടാംദിവസം വിശുദ്ധസഭായോഗം ചേരുകയും യഹോവയ്ക്ക് ഒരു ദഹനയാഗം അർപ്പിക്കുകയുംചെയ്യുക. അതു സമാപനസഭായോഗമാണ്; ആ ദിവസം സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘ഓരോ ദിവസത്തേക്കും വേണ്ടുന്ന ഹോമയാഗങ്ങൾ, ധാന്യവഴിപാടുകൾ, യാഗങ്ങൾ, പാനീയയാഗങ്ങൾ എന്നിവ യഹോവയ്ക്കു ദഹനയാഗമായി അർപ്പിക്കുന്നതിനു കൊണ്ടുവരാൻ വിശുദ്ധ സഭായോഗംചേരുന്നതിനു നിങ്ങൾ വിളംബരം ചെയ്യേണ്ട യഹോവയുടെ സ്ഥാപിക്കപ്പെട്ട ഉത്സവങ്ങളാണിവ. ");
INSERT INTO malc_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ഈ വഴിപാടുകൾ, യഹോവയുടെ ശബ്ബത്തുകൾക്കും നിങ്ങളുടെ കാഴ്ചകൾക്കും നിങ്ങൾ നേർന്ന നേർച്ചകൾക്കും നിങ്ങൾ യഹോവയ്ക്കു സ്വമനസ്സാലെ കൊടുക്കുന്ന എല്ലാ വഴിപാടുകൾക്കുംപുറമേയാണ്.) ");
INSERT INTO malc_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘അതുകൊണ്ട് ഏഴാംമാസം പതിനഞ്ചാംദിവസം തുടങ്ങി, നിങ്ങൾ നിലത്തിലെ വിളവെല്ലാം ശേഖരിച്ചതിനുശേഷം ഏഴുദിവസം യഹോവയ്ക്ക് ഉത്സവം ആഘോഷിക്കുക; ഒന്നാംദിവസം വിശ്രമത്തിനുള്ള ശബ്ബത്താണ്; എട്ടാംദിവസവും വിശ്രമത്തിനുള്ള ശബ്ബത്താണ്. ");
INSERT INTO malc_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ഒന്നാംദിവസം വൃക്ഷങ്ങളിൽനിന്ന് മേൽത്തരമായ ഫലവും കുരുത്തോലയും ഇലയുള്ള ശിഖരങ്ങളും ആറ്റലരിയും (വെള്ളിലമരം) എടുത്തുകൊണ്ട് ഏഴുദിവസം നിങ്ങളുടെ ദൈവമായ യഹോവയുടെ സന്നിധിയിൽ ആനന്ദിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ഓരോവർഷവും ഇതു യഹോവയ്ക്ക് ഒരു ഉത്സവമായി ഏഴുദിവസം ആഘോഷിക്കണം. ഇതു വരാനുള്ള തലമുറകൾക്ക് എന്നേക്കുമുള്ള ഒരു അനുഷ്ഠാനമായിരിക്കണം ഇത് ഏഴാംമാസത്തിൽ ആഘോഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ഏഴുദിവസം കൂടാരങ്ങളിൽ പാർക്കണം; എല്ലാ സ്വദേശീയരായ ഇസ്രായേല്യരും കൂടാരങ്ങളിൽ പാർക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","അങ്ങനെ ഞാൻ ഇസ്രായേല്യരെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചുകൊണ്ടുവന്നപ്പോൾ ഞാൻ അവരെ കൂടാരങ്ങളിൽ പാർപ്പിച്ചു എന്നു നിങ്ങളുടെ സന്തതികൾ അറിയും. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ഇപ്രകാരം മോശ യഹോവയുടെ സ്ഥാപിക്കപ്പെട്ട ഉത്സവങ്ങൾ ഇസ്രായേൽമക്കളോട് അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“വിളക്കുകൾ നിരന്തരം കത്തിക്കൊണ്ടിരിക്കേണ്ടതിന് ഇടിച്ചുപിഴിഞ്ഞെടുത്ത തെളിഞ്ഞ ഒലിവെണ്ണ വിളക്കിനുവേണ്ടി നിന്റെയടുക്കൽ കൊണ്ടുവരാൻ ഇസ്രായേൽമക്കളോടു കൽപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","സമാഗമകൂടാരത്തിൽ ഉടമ്പടിയുടെ പേടകത്തിന്റെ തിരശ്ശീലയ്ക്കു പുറത്തു സന്ധ്യമുതൽ പ്രഭാതംവരെ വിളക്കുകൾ കത്തേണ്ടതിന്, യഹോവയുടെ സന്നിധിയിൽ അഹരോൻ അവ നിരന്തരം ഒരുക്കിവെക്കണം. ഇതു വരുന്ന തലമുറകളിലേക്ക് എന്നേക്കുമുള്ള അനുഷ്ഠാനമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","യഹോവയുടെമുമ്പാകെ തങ്കനിലവിളക്കിന്മേലുള്ള വിളക്കുകൾ നിരന്തരം ഒരുക്കിവെക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“നേർമയുള്ള മാവ് എടുത്ത് ഒരു അപ്പത്തിനു രണ്ട് ഓമെർവീതം ഉപയോഗിച്ചു പന്ത്രണ്ട് അപ്പം ചുടണം. ");
INSERT INTO malc_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","യഹോവയുടെമുമ്പാകെയുള്ള തങ്കംകൊണ്ടുള്ള മേശമേൽ ഒരു വരിയിൽ ആറുവീതം രണ്ട് അടുക്കായി അവ വെക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ഓരോ അടുക്കിന്മേലും ശുദ്ധമായ കുന്തിരിക്കം വെക്കണം, സ്മാരകഭാഗമായി അപ്പത്തെ പ്രതിനിധീകരിക്കാനും യഹോവയ്ക്കു ദഹനയാഗമായിരിക്കാനുംവേണ്ടിയാണിത്. ");
INSERT INTO malc_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ഇസ്രായേല്യർക്കുവേണ്ടി ഒരു നിത്യ ഉടമ്പടിയായി ശബ്ബത്തുതോറും ഈ അപ്പം യഹോവയുടെമുമ്പാകെ ക്രമമായി അടുക്കിവെക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","അത് അഹരോനും പുത്രന്മാർക്കുമുള്ളതാണ്; യഹോവയ്ക്ക് അർപ്പിക്കുന്ന ദഹനയാഗങ്ങളിൽ അതിവിശുദ്ധമാണ് ഈ അപ്പം. അത് അവർക്കു ശാശ്വതാവകാശമായുള്ളതാകുകയാൽ അവർ അതു ശുദ്ധിയുള്ള ഒരു സ്ഥലത്തുവെച്ചു ഭക്ഷിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ഒരു ഇസ്രായേല്യസ്ത്രീയുടെയും ഒരു ഈജിപ്റ്റുകാരന്റെയും മകനായ ഒരുവൻ ഇസ്രായേൽമക്കളുടെ ഇടയിൽ ചെന്നു. അവനും ഒരു ഇസ്രായേല്യനുമായി ശണ്ഠകൂടി. ");
INSERT INTO malc_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ഇസ്രായേല്യസ്ത്രീയുടെ മകൻ തിരുനാമം ദുഷിച്ചു ശപിച്ചു; അതുകൊണ്ട് അവർ അവനെ മോശയുടെ അടുക്കൽ കൊണ്ടുവന്നു. അവന്റെ അമ്മ ദാൻഗോത്രത്തിലെ ദിബ്രിയുടെ മകളായ ശെലോമീത്ത് ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","യഹോവയുടെഹിതം വ്യക്തമാകുന്നതുവരെ അവർ അവനെ തടവിൽവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","പിന്നെ യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ദൈവദൂഷണക്കാരനെ പാളയത്തിനുപുറത്തു കൊണ്ടുപോകുക; അവനെ കേട്ടവരെല്ലാവരും അവരുടെ കൈകൾ അവന്റെ തലമേൽ വെക്കണം, പിന്നീട് സഭമുഴുവനും അവനെ കല്ലെറിയണം. ");
INSERT INTO malc_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ഇസ്രായേൽമക്കളോടു പറയുക: ‘ആരെങ്കിലും തന്റെ ദൈവത്തെ ശപിച്ചാൽ അവൻ കുറ്റക്കാരനാകും; ");
INSERT INTO malc_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","യഹോവയുടെ നാമം ദുഷിക്കുന്ന വ്യക്തിയെ കൊല്ലണം. സഭമുഴുവനും ആ മനുഷ്യനെ കല്ലെറിയണം. പ്രവാസിയായാലും സ്വദേശിയായാലും യഹോവയുടെ നാമം ദുഷിക്കുന്നവർ മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘ഒരു മനുഷ്യനെ കൊല്ലുന്നവൻ മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ഒരാളുടെ മൃഗത്തെ കൊല്ലുന്നവൻ മൃഗത്തിനുപകരം മൃഗത്തെ കൊടുക്കണം—ജീവനുപകരം ജീവൻ. ");
INSERT INTO malc_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ഒരാൾ തന്റെ അയൽവാസിയെ മുറിവേൽപ്പിച്ചാൽ, അയാൾ ചെയ്തപ്രകാരംതന്നെ ആ മനുഷ്യനോടു ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ഒടിവിനു പകരം ഒടിവ്, കണ്ണിനുപകരം കണ്ണ്, പല്ലിനുപകരം പല്ല്. ഒരാൾ മറ്റേയാളെ എങ്ങനെ മുറിപ്പെടുത്തിയോ അങ്ങനെതന്നെ അയാളെയും മുറിപ്പെടുത്തണം. ");
INSERT INTO malc_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ഒരു മൃഗത്തെ കൊല്ലുന്നവൻ നഷ്ടപരിഹാരം കൊടുക്കണം; എന്നാൽ ഒരു മനുഷ്യനെ കൊല്ലുന്നവൻ മരണശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","പ്രവാസിക്കും സ്വദേശിക്കും ഒരേ നിയമംതന്നെയായിരിക്കണം. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ദൈവദൂഷണക്കാരനെ പാളയത്തിനുപുറത്തു കൊണ്ടുപോയി കല്ലെറിയണമെന്ന് മോശ ഇസ്രായേൽമക്കളോടു കൽപ്പിച്ചിരുന്നു. യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ ഇസ്രായേൽമക്കൾ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","സീനായിപർവതത്തിൽവെച്ചു യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ഇസ്രായേൽമക്കളോടു സംസാരിക്കണം. അവരോട് ഇപ്രകാരം പറയുക: ‘ഞാൻ നിങ്ങൾക്കു നൽകാൻപോകുന്ന ദേശത്തു നിങ്ങൾ പ്രവേശിക്കുമ്പോൾ ആ ദേശം യഹോവയ്ക്ക് ഒരു ശബ്ബത്ത് ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ആറുവർഷം നിങ്ങളുടെ നിലങ്ങൾ വിതയ്ക്കുക, ആറുവർഷം നിങ്ങളുടെ മുന്തിരിത്തോപ്പുകൾ വെട്ടിയൊരുക്കി അവയുടെ ഫലം ശേഖരിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","എന്നാൽ ഏഴാംവർഷം ദേശത്തിനു വിശ്രമത്തിന്റെ ശബ്ബത്ത്, യഹോവയ്ക്ക് ഒരു ശബ്ബത്ത് ആയിരിക്കണം. നിങ്ങളുടെ നിലം വിതയ്ക്കുകയോ മുന്തിരിത്തോപ്പു വെട്ടിയൊരുക്കുകയോ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","താനേ വളരുന്നതു കൊയ്യുകയോ പരിപാലിക്കാത്ത മുന്തിരിവള്ളിയിൽനിന്ന് മുന്തിരിങ്ങ ശേഖരിക്കുകയോ ചെയ്യരുത്. ദേശത്തിനു വിശ്രമത്തിന്റെ ഒരുവർഷം ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ശബ്ബത്തുവർഷം ദേശം നൽകുന്ന വിളവെന്താണോ അതു നിങ്ങൾക്ക് ആഹാരമായിരിക്കും. നിങ്ങൾക്കും നിങ്ങളുടെ ദാസന്മാർക്കും ദാസികൾക്കും കൂലിക്കാർക്കും നിങ്ങളുടെ ഇടയിൽ താൽക്കാലികമായി പാർക്കുന്നവർക്കും, ");
INSERT INTO malc_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","നിങ്ങളുടെ കന്നുകാലികൾക്കും കാട്ടുമൃഗങ്ങൾക്കുംതന്നെ. ദേശം എന്തുൽപ്പാദിപ്പിക്കുന്നോ അതു ഭക്ഷിക്കാം. ");
INSERT INTO malc_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘ഏഴു ശബ്ബത്തുവർഷമായി ഏഴുപ്രാവശ്യം ഏഴുവർഷം എണ്ണുക; ഏഴു ശബ്ബത്തുവർഷം നാൽപ്പത്തൊൻപതു വർഷമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ഏഴാംമാസം പത്താംതീയതി എല്ലായിടവും കാഹളം ധ്വനിപ്പിക്കണം—നിങ്ങളുടെ ദേശത്തെല്ലായിടത്തും പാപപരിഹാരദിനത്തിൽ കാഹളം ധ്വനിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","അൻപതാംവർഷം വിശുദ്ധമായി വേർതിരിച്ചു ദേശത്തിലങ്ങോളമിങ്ങോളം സകലനിവാസികൾക്കും സ്വാതന്ത്ര്യം വിളംബരംചെയ്യുക. അതു നിങ്ങൾക്ക് അൻപതാംവാർഷികോത്സവം ആയിരിക്കും; നിങ്ങളോരോരുത്തരും തങ്ങളുടെ അവകാശത്തിലേക്കും തങ്ങളുടെ ഗോത്രത്തിലേക്കും മടങ്ങിപ്പോകണം. ");
INSERT INTO malc_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","അൻപതാംവർഷം നിങ്ങൾക്ക് വാർഷികോത്സവം ആയിരിക്കും; വിതയ്ക്കുകയോ താനേ വളരുന്നതു കൊയ്യുകയോ പരിചരിക്കാത്ത മുന്തിരിയിൽനിന്ന് ഫലം ശേഖരിക്കുകയോ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","കാരണം അത് അൻപതാംവാർഷികോത്സവമാണ്; അതു നിങ്ങൾക്കു വിശുദ്ധമായിരിക്കണം; വയലിൽനിന്ന് നേരിട്ട് എടുക്കുന്നതുമാത്രം ഭക്ഷിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘ഈ അൻപതാംവാർഷികോത്സവത്തിൽ ഓരോരുത്തരും അവരവരുടെ അവകാശത്തിലേക്കു മടങ്ങിപ്പോകേണ്ടതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘നിങ്ങൾ കൂട്ടുകാരിൽ ആർക്കെങ്കിലും നിലം വിൽക്കുകയോ അവരിൽനിന്നു വാങ്ങുകയോ ചെയ്യുമ്പോൾ പരസ്പരം കബളിപ്പിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","അൻപതാംവാർഷികോത്സവത്തിനുശേഷമുള്ള വർഷങ്ങളുടെ എണ്ണത്തിന്റെ അടിസ്ഥാനത്തിൽ നിങ്ങൾ കൂട്ടുകാരിൽനിന്നു വാങ്ങണം. അയാൾ വിളക്കൊയ്ത്തിനു ശേഷിച്ചിട്ടുള്ള വർഷങ്ങളുടെ എണ്ണത്തിന്റെ അടിസ്ഥാനത്തിൽ നിങ്ങൾക്കു വിൽക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","വർഷം കൂടിയിരുന്നാൽ നിങ്ങൾ വില കൂട്ടണം, വർഷം കുറവായിരുന്നാൽ വില കുറയ്ക്കണം; കാരണം ഓരോരുത്തരും വാസ്തവത്തിൽ വിൽക്കുന്നതു വിളവുകളാണ്. ");
INSERT INTO malc_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","പരസ്പരം കബളിപ്പിക്കരുത്; ദൈവത്തെ ഭയപ്പെടുക. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘എന്റെ ഉത്തരവുകൾ പ്രമാണിച്ച് എന്റെ നിയമങ്ങൾ അനുസരിക്കാൻ ശ്രദ്ധിക്കുക, അങ്ങനെയായാൽ നിങ്ങൾക്കു ദേശത്തു സുരക്ഷിതരായി ജീവിക്കാൻ സാധിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","അപ്പോൾ ഭൂമി അതിന്റെ ഫലംതരും; നിങ്ങൾ സുഭിക്ഷമായി ഭക്ഷിച്ചു സുരക്ഷിതരായി അവിടെ ജീവിക്കാനും കഴിയും. ");
INSERT INTO malc_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“നടാതെയും കൊയ്യാതെയുമിരുന്നാൽ ഏഴാംവർഷം ഞങ്ങൾ എന്തു ഭക്ഷിക്കും?” എന്നു നിങ്ങൾ ചോദിച്ചേക്കാം. ");
INSERT INTO malc_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","മൂന്നുവർഷത്തേക്കു മതിയായതു ഭൂമിയിൽനിന്ന് കിട്ടത്തക്കവിധം ഞാൻ ആറാംവർഷം ഒരു അനുഗ്രഹം അയയ്ക്കും. ");
INSERT INTO malc_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","എട്ടാംവർഷം നിങ്ങൾ നടുമ്പോഴും തുടർന്നുള്ള ഒൻപതാംവർഷത്തെ വിളവെടുപ്പുവരെയും നിങ്ങൾ പഴയ വിളവുകൊണ്ട് ഉപജീവനംകഴിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘ഭൂമി എന്റേതാണ്, നിങ്ങൾ അന്യരും കുടികിടപ്പുകാരുമായി ദേശത്തുതാമസിക്കുന്നതുകൊണ്ടു ഭൂമി എന്നെന്നേക്കുമായി വിൽക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","നിങ്ങൾ സ്വന്തമാക്കുന്ന ദേശത്ത് എല്ലായിടത്തും നിങ്ങൾ കൈവശം വെച്ചിരിക്കുന്ന ഭൂമി വീണ്ടെടുക്കാനുള്ള അവകാശം ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘നിങ്ങളുടെ സഹോദരങ്ങൾ ദരിദ്രരായി തങ്ങളുടെ വസ്തുവിൽ കുറെ വിൽക്കുന്നെങ്കിൽ അവരുടെ ഏറ്റവും അടുത്ത ബന്ധു തങ്ങളുടെ സഹോദരങ്ങൾ വിറ്റതു വീണ്ടെടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","എങ്കിലും, ഒരു മനുഷ്യനു തനിക്കുവേണ്ടി അതു വീണ്ടെടുക്കാൻ ആരുമില്ലാതിരിക്കുകയും അയാൾതന്നെ അതു വീണ്ടെടുക്കാനാവശ്യമായതു ശേഖരിക്കുകയും ചെയ്താൽ ");
INSERT INTO malc_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","അയാൾ വിറ്റതിനുശേഷമുള്ള വർഷങ്ങളുടെ വില നിശ്ചയിച്ചു, ബാക്കി ആ മനുഷ്യൻ വിറ്റയാൾക്കു മടക്കിക്കൊടുക്കണം; പിന്നീടു തന്റെ സ്വന്തം വസ്തുവിലേക്ക് അയാൾക്കു മടങ്ങിപ്പോകാം. ");
INSERT INTO malc_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","എന്നാൽ മടക്കിക്കൊടുക്കാനുള്ള വക സ്വരൂപിക്കാൻ അയാൾക്കു കഴിയുന്നില്ലെങ്കിൽ, ആ മനുഷ്യൻ വിറ്റത് അൻപതാംവാർഷികോത്സവംവരെ വാങ്ങിയ ആളിന്റെ കൈവശം ഇരിക്കും. അത് അൻപതാംവാർഷികോത്സവത്തിൽ മടക്കിക്കൊടുക്കും; പിന്നീട് അയാൾക്കു തന്റെ സ്വന്ത വസ്തുവിലേക്കു മടങ്ങിപ്പോകാം. ");
INSERT INTO malc_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘ഒരു മനുഷ്യൻ മതിലുള്ള ഒരു നഗരത്തിൽ ഒരു വീട് വിറ്റാൽ വിറ്റശേഷം ഒരുവർഷം മുഴുവനും അവനു വീണ്ടെടുപ്പവകാശമുണ്ടായിരിക്കും. ആ കാലത്ത് അയാൾക്ക് അതു വീണ്ടെടുക്കാം. ");
INSERT INTO malc_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ഒരു പൂർണവർഷം കഴിയുംമുമ്പ് അതു വീണ്ടെടുക്കപ്പെടുന്നില്ലെങ്കിൽ മതിലുള്ള നഗരത്തിലെ വീട് വാങ്ങിയ ആളിനും അയാളുടെ സന്തതികൾക്കും സ്ഥിരമായിരിക്കും. അൻപതാംവാർഷികോത്സവത്തിൽ അതു തിരികെനൽകേണ്ടതില്ല. ");
INSERT INTO malc_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","എന്നാൽ മതിലുകളില്ലാത്ത ഗ്രാമങ്ങളിലെ വീടുകൾ തുറസ്സായ നിലംപോലെ കരുതണം. അവ ഏതുസമയത്തും വീണ്ടെടുക്കാം. അൻപതാംവാർഷികോത്സവത്തിൽ അത് അതിന്റെ ആദ്യ ഉടമയ്ക്കു മടക്കിക്കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘എന്നാൽ ലേവ്യരുടെ അവകാശമായ അവരുടെ പട്ടണങ്ങളിലെ വീട് വീണ്ടെടുക്കാൻ ലേവ്യർക്ക് എപ്പോഴും അവകാശമുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","അങ്ങനെ ലേവ്യർക്ക് ഏതെങ്കിലും പട്ടണത്തിൽ വിറ്റുപോയ അവരുടെ ഓഹരി വീണ്ടെടുക്കാവുന്നതാണ്, അല്ലാത്തപക്ഷം അത് അൻപതാംവാർഷികോത്സവത്തിൽ മടക്കിക്കൊടുക്കണം. കാരണം ഇസ്രായേല്യരുടെ ഇടയിൽ ലേവ്യരുടെ പട്ടണങ്ങളിൽ ഉള്ള അവരുടെ വീടുകൾ അവർക്കുള്ള അവകാശമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","എന്നാൽ അവരുടെ പട്ടണങ്ങളുടെ ചുറ്റുമുള്ള പുൽപ്പുറങ്ങൾ വിൽക്കരുത്; അത് അവരുടെ സ്ഥിരമായ കൈവശാവകാശമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘നിങ്ങളുടെ ദേശവാസികളിലൊരാൾ ദരിദ്രനായിരിക്കുകയും നിങ്ങളുടെയിടയിൽ സ്വയം ഉപജീവനത്തിനു കഴിവില്ലാതിരിക്കുകയും ചെയ്താൽ ആ മനുഷ്യനു നിങ്ങളുടെ ഇടയിൽ തുടർന്നു ജീവിക്കത്തക്കവിധം, ഒരു അന്യനെയോ പ്രവാസിയെയോ സഹായിക്കുന്നതുപോലെ അയാളെ സഹായിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","നിങ്ങളുടെ ദേശവാസി നിങ്ങളുടെ ഇടയിൽ തുടർന്നു ജീവിക്കാൻ കഴിയേണ്ടതിന് അയാളിൽനിന്ന് യാതൊരുവിധ പലിശയോ ലാഭമോ വാങ്ങരുത്. നിങ്ങളുടെ ദൈവത്തെ ഭയപ്പെടുക. ");
INSERT INTO malc_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","നിങ്ങൾ അവനു പണം പലിശയ്ക്കു കൊടുക്കുകയോ ലാഭത്തിന് ആഹാരം വിൽക്കുകയോ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ഈ കനാൻദേശം നിങ്ങൾക്കു തരികയും നിങ്ങളുടെ ദൈവമായിരിക്കുകയും ചെയ്യാൻ നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചുകൊണ്ടുവന്ന ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘നിങ്ങളുടെ ദേശവാസികളിലൊരാൾ നിങ്ങളുടെ ഇടയിൽ ദരിദ്രനായിത്തീരുകയും സ്വയം നിങ്ങൾക്കു വിൽക്കുകയുംചെയ്താൽ ഒരു അടിമയെപ്പോലെ ആ മനുഷ്യനെക്കൊണ്ടു പണിയെടുപ്പിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ഒരു കൂലിക്കാരനെപ്പോലെയോ താൽക്കാലികമായി വന്നു നിങ്ങൾക്കിടയിൽ താമസിക്കുന്നവനെപ്പോലെയോ അയാളോടു പെരുമാറണം; അയാൾ അൻപതാംവാർഷികോത്സവംവരെ നിങ്ങൾക്കു പണിയെടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","പിന്നെ അയാളെയും കുഞ്ഞുങ്ങളെയും സ്വതന്ത്രരായി വിടണം, അയാൾക്കു തന്റെ ഗോത്രത്തിലേക്കും തന്റെ പിതാക്കന്മാരുടെ അവകാശത്തിലേക്കും മടങ്ങിപ്പോകാം. ");
INSERT INTO malc_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ഇസ്രായേല്യരെല്ലാം എന്റെ സേവകരാണ്; അവരെ ഞാൻ ഈജിപ്റ്റിൽനിന്ന് പുറത്തുകൊണ്ടുവന്നു; അതുകൊണ്ട് അവരെ അടിമകളായി വിൽക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","അവരോടു ക്രൂരമായി പെരുമാറരുത്, നിങ്ങളുടെ ദൈവത്തെ ഭയപ്പെടുക. ");
INSERT INTO malc_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘നിങ്ങളുടെ അടിമകൾ—സ്ത്രീകളും പുരുഷന്മാരും—നിങ്ങൾക്കു ചുറ്റുമുള്ള ജനതകളിൽനിന്നായിരിക്കണം; അവരിൽനിന്ന് നിങ്ങൾക്ക് അടിമകളെ വാങ്ങാം. ");
INSERT INTO malc_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","നിങ്ങളുടെ ഇടയിൽവന്നു താൽക്കാലികമായി പാർക്കുന്നവരിൽ ചിലരെയും നിങ്ങളുടെ ദേശത്തു ജനിച്ച അവരുടെ ഗോത്രങ്ങളിലുള്ളവരെയും നിങ്ങൾക്കു വാങ്ങാം; അവർ നിങ്ങളുടെ സ്വത്തായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","അവരെ നിങ്ങളുടെ മക്കൾക്കുവേണ്ടി പിൻതുടർച്ചയായി ആജീവനാന്തം അടിമകളായി കൊടുക്കാം. എന്നാൽ നിങ്ങളുടെ സഹോദരങ്ങളായ ഇസ്രായേല്യരോടു ക്രൂരമായി പെരുമാറരുത്. ");
INSERT INTO malc_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘ഒരു പ്രവാസിയോ നിങ്ങളുടെ ഇടയിൽ വന്നുപാർക്കുന്നയാളോ ധനികരായിത്തീരുകയും നിങ്ങളുടെ സഹോദരങ്ങളിലൊരാൾ ദരിദ്രരായിട്ടു തങ്ങളെത്തന്നെ നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പ്രവാസിക്കോ പ്രവാസിയുടെ ഗോത്രത്തിലൊരാൾക്കോ വിൽക്കുകയുംചെയ്താൽ, ");
INSERT INTO malc_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","അവർ സ്വയം വിറ്റതിനുശേഷം അവരെ വീണ്ടെടുക്കാനുള്ള അവകാശം ഉണ്ടായിരിക്കും. അയാളുടെ ഒരു ബന്ധുവിന് ആ മനുഷ്യനെ വീണ്ടെടുക്കാം: ");
INSERT INTO malc_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","അയാളുടെ പിതൃസഹോദരനോ പിതൃസഹോദരന്റെ പുത്രനോ ആ മനുഷ്യനെ വീണ്ടെടുക്കാം; അല്ലെങ്കിൽ അയാളുടെ കുടുംബത്തിൽ അയാളുടെ അടുത്ത ബന്ധുക്കാരിൽ ഒരാൾക്ക് ആ മനുഷ്യനെ വീണ്ടെടുക്കാം; ആ വിറ്റുപോയ അടിമയ്ക്ക് ആസ്തിയുണ്ടെങ്കിൽ തന്നെത്താൻ വീണ്ടെടുക്കുകയും ചെയ്യാം. ");
INSERT INTO malc_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ആ മനുഷ്യനും അയാളെ വാങ്ങിയ ആളും കൂടെ വിറ്റവർഷംമുതൽ അൻപതാംവാർഷികോത്സവംവരെയുള്ള കാലം എണ്ണണം. ആ കാലത്തേക്ക് ഒരു കൂലിക്കാരനു കൊടുക്കുന്ന നിരക്കിന്റെ അടിസ്ഥാനത്തിലായിരിക്കണം അയാളെ സ്വാതന്ത്ര്യത്തോടെ വിട്ടയയ്ക്കുന്നതിനു നൽകുന്ന വില. ");
INSERT INTO malc_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","അനേകവർഷങ്ങൾ ബാക്കിയുണ്ടെങ്കിൽ അയാളുടെ വീണ്ടെടുപ്പിനായി, അയാൾക്കു കിട്ടിയ വിലയിൽ വലിയൊരുപങ്ക് അയാൾ മടക്കിക്കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","അൻപതാംവാർഷികോത്സവത്തിനു ചില വർഷങ്ങൾമാത്രമാണ് ബാക്കിയുള്ളതെങ്കിൽ, അതു കണക്കാക്കി അതനുസരിച്ചു തന്റെ വീണ്ടെടുപ്പുവില കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","അയാളെ വർഷംതോറും കൂലിക്കെടുക്കുന്ന ആളായി കരുതണം. അയാളെ കൈവശമാക്കിയിരിക്കുന്ന വ്യക്തി ആ മനുഷ്യനോട് ക്രൂരമായി പെരുമാറാൻ നിങ്ങൾ അനുവദിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘ഈ ഏതെങ്കിലുംരീതിയിൽ ആ മനുഷ്യൻ വീണ്ടെടുക്കപ്പെടുന്നില്ലെങ്കിൽ, അയാളെയും കുഞ്ഞുങ്ങളെയും അൻപതാംവാർഷികോത്സവത്തിൽ സ്വതന്ത്രരായി വിടണം. ");
INSERT INTO malc_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","കാരണം ഇസ്രായേൽമക്കൾ എനിക്കുള്ളവരാണ്. ഞാൻ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചുകൊണ്ടുവന്ന എന്റെ സേവകരാണ് അവർ. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘നിങ്ങൾക്കായി വിഗ്രഹങ്ങൾ ഉണ്ടാക്കുകയോ ഒരു ബിംബമോ ആചാരസ്തൂപമോ സ്ഥാപിക്കുകയോ ചെയ്യരുത്. അതിന്റെ മുമ്പിൽ വണങ്ങാനായി നിങ്ങളുടെ ദേശത്തു കൊത്തിയ കല്ലു നാട്ടുകയും ചെയ്യരുത്. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘എന്റെ ശബ്ബത്തുകൾ പ്രമാണിക്കുകയും എന്റെ വിശുദ്ധമന്ദിരത്തോടു ഭയഭക്തിയുള്ളവരായിരിക്കുകയും വേണം. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘എന്റെ ഉത്തരവുകൾ നിങ്ങൾ പാലിക്കയും എന്റെ കൽപ്പനകൾ സസൂക്ഷ്മം അനുസരിക്കയും ചെയ്യുമെങ്കിൽ, ");
INSERT INTO malc_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","തക്കസമയത്തു ഞാൻ മഴ അയയ്ക്കും; ഭൂമി അതിന്റെ വിളവും വൃക്ഷം അവയുടെ ഫലവും തരും. ");
INSERT INTO malc_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","നിങ്ങളുടെ കറ്റമെതിക്കുന്ന കാലം മുന്തിരിപ്പഴം ശേഖരിക്കുന്ന കാലംവരെയും മുന്തിരിപ്പഴം ശേഖരിക്കുന്നത് വിതയ്ക്കുന്ന കാലംവരെയും തുടരും. നിങ്ങൾക്കു വേണ്ടുംപോലെ ഭക്ഷിച്ചു സുരക്ഷിതരായി നിങ്ങളുടെ ദേശത്തുപാർക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘ഞാൻ ദേശത്തു സമാധാനം തരും. നിങ്ങൾ കിടന്നുറങ്ങും; ആരും നിങ്ങളെ ഭയപ്പെടുത്തുകയില്ല. ഞാൻ ദുഷ്ടമൃഗങ്ങളെ ദേശത്തുനിന്നു നീക്കിക്കളയും. വാൾ നിങ്ങളുടെ ദേശത്തുകൂടെ കടക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","നിങ്ങളുടെ ശത്രുക്കളെ നിങ്ങൾ തുരത്തും. അവർ നിങ്ങളുടെമുമ്പിൽ വാളിനാൽ വീഴും. ");
INSERT INTO malc_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","നിങ്ങളിൽ അഞ്ചുപേർ നൂറുപേരെ ഓടിക്കും. നിങ്ങളിൽ നൂറുപേർ പതിനായിരംപേരെ ഓടിക്കും. നിങ്ങളുടെ ശത്രുക്കൾ നിങ്ങളുടെമുമ്പിൽ വാളിനാൽ വീഴും. ");
INSERT INTO malc_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘ഞാൻ നിങ്ങളെ കടാക്ഷിച്ച് സന്താനപുഷ്ടിയുള്ളവരാക്കി എണ്ണത്തിൽ പെരുകുമാറാക്കും; നിങ്ങളോടുള്ള എന്റെ ഉടമ്പടി ഞാൻ പാലിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","നിങ്ങൾ പഴയ ധാന്യശേഖരത്തിൽനിന്നു ഭക്ഷിക്കുകയും പുതിയവയ്ക്കുവേണ്ടി പഴയത് മാറ്റിക്കളയുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ഞാൻ എന്റെ നിവാസം നിങ്ങളുടെ ഇടയിലാക്കും. ഞാൻ നിങ്ങളെ വെറുക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ഞാൻ നിങ്ങളുടെ ഇടയിൽ നടക്കുകയും നിങ്ങളുടെ ദൈവമായിരിക്കുകയും ചെയ്യും, നിങ്ങൾ എന്റെ ജനമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","നിങ്ങൾ ഇനിയും ഈജിപ്റ്റുകാരുടെ അടിമകളാകാതിരിക്കാൻ നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് പുറത്തുകൊണ്ടുവന്ന നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു ഞാൻ. നിങ്ങൾ തലയുയർത്തി നിവർന്നു നടക്കേണ്ടതിന് ഞാൻ നിങ്ങളുടെ അടിമത്തത്തിന്റെ നുകക്കൈകൾ ഒടിച്ചുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘എന്നാൽ നിങ്ങൾ എന്റെ വാക്കു കേൾക്കാതെയും ഈ കൽപ്പനകളെല്ലാം പ്രമാണിക്കാതെയും ");
INSERT INTO malc_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","എന്റെ ഉത്തരവുകൾ തള്ളിക്കളയുകയും എന്റെ നിയമങ്ങൾ വെറുക്കുകയുംചെയ്ത് എന്റെ കൽപ്പനകളെല്ലാം പ്രമാണിക്കാതെ എന്റെ ഉടമ്പടി ലംഘിച്ചാൽ, ");
INSERT INTO malc_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ഇപ്രകാരം ഞാൻ നിങ്ങളോടു ചെയ്യും: നിങ്ങളുടെ കാഴ്ച നശിപ്പിക്കുകയും ആരോഗ്യം ഇല്ലാതാക്കുകയും ചെയ്യുന്ന, പെട്ടെന്നുള്ള ഉഗ്രഭയം, മഹാവ്യാധി, ജ്വരം എന്നിവ ഞാൻ നിങ്ങളുടെമേൽ വരുത്തും. നിങ്ങൾ വെറുതേ വിത്തു വിതയ്ക്കും, അതു നിങ്ങളുടെ ശത്രുക്കൾ തിന്നുകളയും. ");
INSERT INTO malc_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","നിങ്ങളുടെ ശത്രുക്കൾ നിങ്ങളെ തോൽപ്പിക്കത്തക്കവിധം എന്റെ മുഖം നിങ്ങൾക്കു വിരോധമാക്കും; നിങ്ങളെ പകയ്ക്കുന്നവർ നിങ്ങളെ ഭരിക്കും; ആരും ഓടിക്കാതെതന്നെ നിങ്ങൾ ഓടിപ്പോകും. ");
INSERT INTO malc_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘ഇതിനെല്ലാം ശേഷവും നിങ്ങൾ എന്റെ വാക്കു കേൾക്കുന്നില്ലെങ്കിൽ, ഞാൻ നിങ്ങളുടെ പാപങ്ങൾനിമിത്തം നിങ്ങളെ ഏഴുമടങ്ങു ശിക്ഷിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","നിങ്ങളുടെ ദുശ്ശാഠ്യമുള്ള ഗർവ് ഞാൻ തകർക്കും; നിങ്ങൾക്കുമീതേയുള്ള ആകാശത്തെ ഇരുമ്പുപോലെയും കീഴേയുള്ള ഭൂമിയെ വെള്ളോടുപോലെയും ആക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","നിങ്ങളുടെ ശക്തി ഞാൻ നിഷ്ഫലമാക്കും; കാരണം നിങ്ങളുടെ മണ്ണു വിളവു തരികയില്ല, ദേശത്തിലെ വൃക്ഷങ്ങൾ അവയുടെ ഫലം തരികയുമില്ല. ");
INSERT INTO malc_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘നിങ്ങൾ എനിക്കു വിരോധമായി നടന്ന് എന്റെ വാക്കു കേൾക്കാതിരുന്നാൽ, നിങ്ങളുടെ പാപങ്ങൾക്കു തക്കവിധം നിങ്ങളുടെ ബാധകളെ ഞാൻ ഏഴിരട്ടിയാക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ഞാൻ നിങ്ങൾക്കു വിരോധമായി വന്യമൃഗങ്ങളെ അയയ്ക്കും. അവ നിങ്ങളെ കുഞ്ഞുങ്ങളില്ലാത്തവരാക്കും; നിങ്ങളുടെ കന്നുകാലികളെ നശിപ്പിക്കും; നിങ്ങളുടെ നിരത്തുകൾ വിജനമാകത്തക്കവിധം നിങ്ങളെ എണ്ണത്തിൽ കുറയ്ക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘ഇവയെല്ലാറ്റിനുശേഷവും നിങ്ങൾ എന്റെ ശിക്ഷണം സ്വീകരിക്കാതെ എന്നോടു വിരോധമായിരിക്കുന്നെങ്കിൽ, ");
INSERT INTO malc_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ഞാനും നിങ്ങളോടു വിരോധമായിരുന്ന് നിങ്ങളുടെ പാപങ്ങൾക്കു തക്കവണ്ണം നിങ്ങളെ ഏഴുമടങ്ങു പീഡിപ്പിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","എന്റെ ഉടമ്പടി ലംഘിച്ചതിനു പ്രതികാരംചെയ്യാൻ, ഞാൻ നിങ്ങളുടെമേൽ വാൾ വരുത്തും. നിങ്ങൾ നിങ്ങളുടെ നഗരങ്ങളിലേക്കു പിൻവാങ്ങുമ്പോൾ ഞാൻ നിങ്ങളുടെ ഇടയിൽ ഒരു ബാധ അയയ്ക്കും. നിങ്ങളെ ശത്രുവിന്റെ കൈയിൽ ഏൽപ്പിക്കുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ഞാൻ നിങ്ങളുടെ അപ്പത്തിന്റെ അളവു കുറയ്ക്കുമ്പോൾ പത്തു സ്ത്രീകൾ ഒരടുപ്പിൽ നിങ്ങളുടെ അപ്പം ചുടും. അവർ അൽപ്പാൽപ്പം അപ്പം തൂക്കിത്തരും. നിങ്ങൾ തിന്നും, എന്നാൽ നിങ്ങൾക്കു തൃപ്തിയാകുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘ഇതെല്ലാമായിട്ടും നിങ്ങൾ എന്റെ വാക്കു കേൾക്കാതെ എന്നോടു വിരോധമായിരുന്നാൽ, ");
INSERT INTO malc_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ഞാനും എന്റെ കോപത്തിൽ നിങ്ങൾക്കു വിരോധമായിരിക്കും. നിങ്ങളുടെ പാപങ്ങൾനിമിത്തം ഞാൻ നിങ്ങളെ ഏഴുമടങ്ങു ശിക്ഷിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","നിങ്ങളുടെ പുത്രന്മാരുടെ മാംസവും നിങ്ങളുടെ പുത്രിമാരുടെ മാംസവും നിങ്ങൾ തിന്നും. ");
INSERT INTO malc_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","നിങ്ങൾ യാഗമർപ്പിക്കുന്ന ക്ഷേത്രങ്ങൾ ഞാൻ നശിപ്പിക്കും. ധൂപപീഠങ്ങളെ വെട്ടിക്കളയുകയും നിങ്ങളുടെ ശവശരീരങ്ങൾ നിങ്ങളുടെ നിർജീവ വിഗ്രഹങ്ങളുടെമേൽ കൂമ്പാരമാക്കുകയും ചെയ്യും; ഞാൻ നിങ്ങളെ കഠിനമായി വെറുക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ഞാൻ നിങ്ങളുടെ നഗരങ്ങളെ പാഴിടങ്ങളും നിങ്ങളുടെ വിശുദ്ധമന്ദിരത്തെ ശൂന്യവുമാക്കും. നിങ്ങളുടെ യാഗങ്ങളിലെ ഹൃദ്യസുഗന്ധത്തിൽ ഞാൻ പ്രസാദിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","അവിടെ ജീവിക്കുന്ന നിങ്ങളുടെ ശത്രുക്കൾ ആശ്ചര്യപ്പെടത്തക്കവിധം ഞാൻതന്നെ നിങ്ങളുടെ ദേശത്തെ ശൂന്യമാക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ഞാൻ നിങ്ങളെ ജനതകളുടെ ഇടയിൽ ചിതറിക്കുകയും എന്റെ വാളൂരി നിങ്ങളെ തുരത്തുകയും ചെയ്യും. നിങ്ങളുടെ ദേശം ശൂന്യമായിക്കിടക്കും. നിങ്ങളുടെ നഗരങ്ങൾ പാഴിടങ്ങളായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","നിങ്ങളുടെ ദേശം നിർജനമായിക്കിടക്കുകയും നിങ്ങൾ നിങ്ങളുടെ ശത്രുരാജ്യത്തിന്റേതായിരിക്കുകയും ചെയ്യുന്ന കാലമൊക്കെയും ദേശം അതിനു ലഭിക്കാതിരുന്ന ശബ്ബത്തുവർഷങ്ങൾ ആസ്വദിക്കും; അപ്പോൾ ദേശം വിശ്രമിച്ച് അതിന്റെ ശബ്ബത്ത് ആസ്വദിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","നിങ്ങൾ അതിൽ താമസിച്ചിരുന്നകാലത്ത് നിങ്ങളുടെ ശബ്ബത്തുകളിൽ അതിനില്ലാതിരുന്ന വിശ്രമം അതു നിർജനമായിക്കിടക്കുന്ന കാലമൊക്കെയും അതിനുണ്ടാകും. ");
INSERT INTO malc_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘നിങ്ങളിൽ ശേഷിക്കുന്നവരുടെ ഹൃദയങ്ങളിൽ ശത്രുരാജ്യത്തിൽവെച്ച് ഞാൻ ഭീതിവരുത്തും; കാറ്റിൽ പറക്കുന്ന ഇലയുടെ ശബ്ദം കേൾക്കുമ്പോൾ ആരും അവരെ പിൻതുടരുന്നില്ലെങ്കിലും വാളിൽനിന്ന് ഒഴിഞ്ഞ് ഓടുന്നവരെപ്പോലെ അവർ ഓടുകയും വീഴുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ആരും അവരെ പിൻതുടരുന്നില്ലെങ്കിലും അവർ വാളിൽനിന്ന് ഓടുന്നവരെപ്പോലെ ഓടി ഒരാൾ മറ്റൊരാളുടെമേൽ തട്ടിവീഴും. ശത്രുക്കളുടെമുമ്പിൽ നിൽക്കാനുള്ള ശക്തി നിങ്ങൾക്കു ഉണ്ടാകുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ജനതകളുടെ ഇടയിൽ നിങ്ങൾ നശിക്കും, നിങ്ങളുടെ ശത്രുക്കളുടെ ദേശം നിങ്ങളെ വിഴുങ്ങിക്കളയും. ");
INSERT INTO malc_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","നിങ്ങളിൽ ശേഷിച്ചവർ ശത്രുക്കളുടെ ദേശത്ത് തങ്ങളുടെ പാപംനിമിത്തം ക്ഷയിച്ചുപോകും; അവരുടെ പിതാക്കന്മാരുടെ പാപംനിമിത്തവും അവർ ക്ഷയിച്ചുപോകും. ");
INSERT INTO malc_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","“ ‘എന്നാൽ അവർ, ഞാൻ അവരെ അവരുടെ ശത്രുക്കളുടെ രാജ്യത്തേക്ക് അയയ്ക്കത്തക്കവിധം എന്നെ അവർക്കു ശത്രുവാക്കിയ, അവരുടെ പാപങ്ങളെയും അവരുടെ പിതാക്കന്മാരുടെ പാപങ്ങളെയും—എനിക്കു വിരോധമായുള്ള അവരുടെ ദ്രോഹങ്ങളെയും എന്നോടുള്ള അവരുടെ വിരോധത്തെയും—ഏറ്റുപറയുമെങ്കിൽ, അവരുടെ പരിച്ഛേദനമില്ലാത്ത ഹൃദയങ്ങൾ താഴ്ത്തുകയും അവരുടെ പാപത്തിനുള്ള ശിക്ഷ അനുഭവിക്കുകയും ചെയ്യുമ്പോൾ, ");
INSERT INTO malc_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ഞാൻ യാക്കോബിനോടുള്ള എന്റെ ഉടമ്പടിയും യിസ്ഹാക്കിനോടുള്ള എന്റെ ഉടമ്പടിയും അബ്രാഹാമിനോടുള്ള എന്റെ ഉടമ്പടിയും ഓർക്കും; ഞാൻ ദേശത്തെ ഓർക്കും. ");
INSERT INTO malc_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ദേശം അവരാൽ പരിത്യജിക്കപ്പെട്ടിട്ട്, അത് അവരെക്കൂടാതെ വിജനമായിക്കിടന്നു ശബ്ബത്ത് അനുഭവിക്കും. എന്റെ നിയമങ്ങളെ തള്ളിക്കളയുകയും എന്റെ ഉത്തരവുകളെ വെറുക്കുകയും ചെയ്തതുകൊണ്ട് അവർ അവരുടെ പാപങ്ങളുടെ ശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ഇങ്ങനെയൊക്കെയാണെങ്കിലും അവർ അവരുടെ ശത്രുക്കളുടെ ദേശത്തായിരിക്കുമ്പോൾ ഞാൻ എന്റെ ഉടമ്പടിയും ലംഘിച്ചുകൊണ്ട്, അവരെ പൂർണമായി നശിപ്പിക്കത്തക്കവിധം അവരെ തള്ളിക്കളയുകയോ കഠിനമായി വെറുക്കുകയോ ചെയ്യുകയില്ല. ഞാൻ അവരുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","എന്നാൽ, ഞാൻ അവരുടെ ദൈവമായിരിക്കേണ്ടതിനു ജനതകൾ കാൺകെ അവരെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചുകൊണ്ടുവന്ന അവരുടെ പൂർവികന്മാരുമായുള്ള എന്റെ ഉടമ്പടി, ഞാൻ അവർക്കുവേണ്ടി ഓർക്കും. ഞാൻ യഹോവ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","യഹോവ സീനായിപർവതത്തിൽ തനിക്കും ഇസ്രായേല്യർക്കുംതമ്മിൽ മോശമുഖാന്തരം സ്ഥാപിച്ച ഉടമ്പടിയുടെ ഉത്തരവുകളും നിയമങ്ങളും പ്രമാണങ്ങളും ഇവയാണ്. ");
INSERT INTO malc_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ഇസ്രായേൽമക്കളോടു സംസാരിക്കണം. അവരോട് ഇപ്രകാരം പറയുക: ‘ഒരാൾ മറ്റൊരാളെ ആ മനുഷ്യന്റെ മൂല്യത്തിനു തക്കതായ നേർച്ച നേർന്ന് യഹോവയ്ക്കായി സമർപ്പിക്കുമ്പോൾ, ");
INSERT INTO malc_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ഇരുപതും അറുപതും വയസ്സിനിടയ്ക്കുള്ള ഒരു പുരുഷന്റെ മൂല്യം വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം അൻപതുശേക്കേൽ വെള്ളിയായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","സ്ത്രീ ആയിരുന്നാൽ അവളുടെ മൂല്യം മുപ്പതു ശേക്കേൽ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","അത് അഞ്ചും ഇരുപതും വയസ്സിനു മധ്യേയുള്ള വ്യക്തിയാണെങ്കിൽ, പുരുഷന് ഇരുപതു ശേക്കേലും, സ്ത്രീക്കു പത്തു ശേക്കേലും മൂല്യം നിശ്ചയിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ഒരുമാസംമുതൽ അഞ്ചുവയസ്സുവരെയാണു പ്രായമെങ്കിൽ ആണിന് അഞ്ചുശേക്കേൽ വെള്ളിയും പെണ്ണിനു മൂന്നു ശേക്കേൽ വെള്ളിയും മൂല്യം നിശ്ചയിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ഒരു വ്യക്തി അറുപതു വയസ്സോ അതിലധികമോ പ്രായമുള്ളയാളാണെങ്കിൽ പുരുഷനു പതിനഞ്ചു ശേക്കേലും സ്ത്രീക്ക് പത്തു ശേക്കേലും വില നിശ്ചയിക്കുക. ");
INSERT INTO malc_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","നേരുന്നയാൾ, നിശ്ചിത തുക കൊടുക്കാൻ കഴിയാത്തവിധം ദരിദ്രനെങ്കിൽ അയാൾ ആ വ്യക്തിയെ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരണം. നേരുന്നയാളുടെ പ്രാപ്തിക്കൊത്തവണ്ണം പുരോഹിതൻ മൂല്യം നിശ്ചയിക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘ആ മനുഷ്യൻ നേർന്നതു യഹോവയ്ക്ക് സ്വീകാര്യമായ ഒരു മൃഗമെങ്കിൽ, ആ മൃഗത്തെ യഹോവയ്ക്കു കൊടുക്കുന്നതിനാൽ അതു വിശുദ്ധമാകും. ");
INSERT INTO malc_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","അയാൾ അതു നല്ലതിനുപകരം ചീത്തയോ ചീത്തയായതിനു പകരം നല്ലതോ ആയി വെച്ചുമാറാൻ പാടില്ല; ഇങ്ങനെ ഒരു മൃഗത്തിനുപകരം മറ്റൊന്നു വെക്കണമെങ്കിൽ, അതും പകരം വെക്കുന്നതും വിശുദ്ധമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ഒരാൾ നേർന്നത്, യഹോവയ്ക്കു സ്വീകാര്യമല്ലാത്ത ഒരു അശുദ്ധമൃഗമെങ്കിൽ, ആ മൃഗത്തെ പുരോഹിതന്റെ അടുക്കൽ നിർത്തണം. ");
INSERT INTO malc_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","നല്ലതോ ചീത്തയോ എന്നുനോക്കി പുരോഹിതൻ അതിന്റെ ഗുണം നിർണയിക്കും. പുരോഹിതൻ അതിനു മതിക്കുന്നതു തന്നെയായിരിക്കും അതിന്റെ മൂല്യം. ");
INSERT INTO malc_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ഉടമസ്ഥൻ മൃഗത്തെ വീണ്ടുകൊള്ളാൻ ആഗ്രഹിക്കുന്നെങ്കിൽ അയാൾ അതിന്റെ മൂല്യത്തോട് അഞ്ചിലൊന്നുകൂടെ ചേർക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘ഒരാൾ തന്റെ വീട് യഹോവയ്ക്കു വിശുദ്ധമായി സമർപ്പിച്ചാൽ അതു നല്ലതോ ചീത്തയോ എന്നുനോക്കി പുരോഹിതൻ അതിന്റെ ഗുണം നിർണയിക്കും. പുരോഹിതൻ നിശ്ചയിക്കുന്ന മൂല്യം എന്തായാലും അത് അങ്ങനെതന്നെ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","തന്റെ വീട് സമർപ്പിച്ചയാൾ അതിനെ വീണ്ടുകൊള്ളുന്നെങ്കിൽ അയാൾ മൂല്യത്തോട് അഞ്ചിലൊന്നു കൂട്ടണം; വീട് വീണ്ടും അയാളുടേതാകും. ");
INSERT INTO malc_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘ഒരാൾ തന്റെ കുടുംബഭൂമിയിൽ കുറെ യഹോവയ്ക്കു സമർപ്പിക്കുന്നെങ്കിൽ, ഒരു ഹോമർ യവം വിതയ്ക്കാവുന്ന നിലത്തിന് അൻപതുശേക്കേൽ എന്ന നിരക്കിൽ, അതിനുവേണ്ടുന്ന വിത്തിന്റെ അളവനുസരിച്ചായിരിക്കണം വിലമതിക്കേണ്ടത്. ");
INSERT INTO malc_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ഒരാൾ തന്റെ നിലം അൻപതാംവാർഷികോത്സവത്തിൽ സമർപ്പിച്ചാൽ അതിനു മതിച്ചവില നിലനിൽക്കും. ");
INSERT INTO malc_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","അൻപതാംവാർഷികോത്സവത്തിനുശേഷമാണ് ഒരാൾ സമർപ്പിക്കുന്നതെങ്കിൽ അടുത്ത വാർഷികോത്സവത്തിനുശേഷിക്കുന്ന വർഷങ്ങളുടെ എണ്ണമനുസരിച്ചു പുരോഹിതൻ വില നിശ്ചയിക്കണം. അതിന്റെ മതിച്ചിരുന്ന വില കുറയ്ക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","നിലം സമർപ്പിച്ചയാൾ അതു വീണ്ടുകൊള്ളാൻ ആഗ്രഹിക്കുന്നെങ്കിൽ അയാൾ അതിന്റെ വിലയുടെ അഞ്ചിലൊന്നും കൂട്ടണം. നിലം വീണ്ടും അയാളുടേതാകും. ");
INSERT INTO malc_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","എങ്കിലും അയാൾ നിലം വീണ്ടെടുക്കാതിരിക്കുകയോ ആ മനുഷ്യൻ മറ്റൊരാൾക്ക് അതു വിൽക്കുകയോ ചെയ്തെങ്കിൽ പിന്നീടൊരിക്കലും അതു വീണ്ടെടുക്കാൻ സാധിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ആ നിലം അൻപതാംവാർഷികോത്സവത്തിൽ ഒഴിഞ്ഞുകൊടുക്കുമ്പോൾ, യഹോവയ്ക്കു സമർപ്പിതനിലംപോലെ അതു വിശുദ്ധമായിരിക്കും; അതു പുരോഹിതന്മാരുടെ വസ്തുവാകും. ");
INSERT INTO malc_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘തന്റെ കുടുംബസ്വത്തിൽ ഉൾപ്പെടാതെ ഒരാൾ സ്വന്തമായി വാങ്ങിയ ഒരു നിലം യഹോവയ്ക്കു സമർപ്പിക്കുന്നെങ്കിൽ, ");
INSERT INTO malc_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","അൻപതാംവാർഷികോത്സവംവരെയുള്ള അതിന്റെ വില പുരോഹിതൻ നിർണയിക്കണം. അയാൾ അതിന്റെ വില യഹോവയ്ക്കു വിശുദ്ധമായി, അന്നുതന്നെ കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ആ നിലം അൻപതാംവാർഷികോത്സവത്തിൽ, അതു വിറ്റ അതിന്റെ മുൻഉടമസ്ഥനു മടങ്ങിച്ചേരണം. ");
INSERT INTO malc_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","എല്ലാ വിലയും, ശേക്കേലിന് ഇരുപതു ഗേരാവെച്ച് വിശുദ്ധമന്ദിരത്തിലെ ശേക്കേൽപ്രകാരം ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘മൃഗങ്ങളുടെ കടിഞ്ഞൂൽ യഹോവയ്ക്കുള്ളതായതുകൊണ്ട്, ഒരു മൃഗത്തിന്റെ കടിഞ്ഞൂലിനെയും യഹോവയ്ക്ക് ആരും സമർപ്പിക്കരുത്; കാളയായാലും ആടായാലും, അതു യഹോവയുടേതാണ്. ");
INSERT INTO malc_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","അത് അശുദ്ധമൃഗങ്ങളിലൊന്നാണെങ്കിൽ, അതിന്റെ മതിപ്പുവിലയും അഞ്ചിലൊന്നും ചേർത്തു മടക്കിവാങ്ങാം. ആരും അതു വീണ്ടെടുക്കുന്നില്ലെങ്കിൽ അതിന്റെ മതിപ്പുവിലയ്ക്ക് അതിനെ വിൽക്കണം. ");
INSERT INTO malc_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘എന്നാൽ, മനുഷ്യനോ മൃഗമോ കുടുംബസ്വത്തോ ആയി ഒരു മനുഷ്യന്റെ ഉടമസ്ഥതയിലുള്ളതും യഹോവയ്ക്കു സമർപ്പിതവുമായ യാതൊന്നും വിൽക്കുകയോ വീണ്ടെടുക്കുകയോ അരുത്; അങ്ങനെ സമർപ്പിതമായതൊക്കെയും യഹോവയ്ക്ക് അതിവിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘മനുഷ്യനിൽനിന്ന് ഉന്മൂലനംചെയ്യാൻ വേർതിരിക്കപ്പെട്ട ആരെയും മോചനദ്രവ്യം കൊടുത്തു വീണ്ടെടുക്കരുത്; അയാളെ കൊന്നുകളയണം. ");
INSERT INTO malc_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘നിലത്തിലെ ധാന്യത്തിലായാലും വൃക്ഷങ്ങളിലെ ഫലങ്ങളിലായാലും ദേശത്തിലെ എല്ലാറ്റിന്റെയും ദശാംശം യഹോവയ്ക്കുള്ളതാണ്; അതു യഹോവയ്ക്കു വിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ഒരാൾ, അയാളുടെ ദശാംശത്തിൽ എന്തെങ്കിലും വീണ്ടെടുക്കുന്നെങ്കിൽ അതിന്റെ വിലയുടെ അഞ്ചിലൊന്നും കൂട്ടണം. ");
INSERT INTO malc_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ആടുമാടുകളുടെ മുഴുവൻ ദശാംശം—ഇടയന്റെ കോൽക്കീഴിലൂടെ കടന്നുപോകുന്ന ഓരോ പത്താമത്തെ മൃഗവും—യഹോവയ്ക്കു വിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","അവ നല്ലതോ ചീത്തയോ എന്ന് അന്വേഷിക്കേണ്ടതില്ല; അവയെ വെച്ചുമാറരുത്. അങ്ങനെചെയ്താൽ ആ മൃഗവും അതിനുപകരം വെച്ചതും വിശുദ്ധമാകും; അവയെ വീണ്ടെടുക്കാൻ പാടില്ല.’ ” ");
INSERT INTO malc_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","യഹോവ സീനായിമലയിൽവെച്ച് ഇസ്രായേൽമക്കൾക്കുവേണ്ടി മോശയ്ക്കു നൽകിയ കൽപ്പനകൾ ഇവയാണ്.");
INSERT INTO malc_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","സീനായിമരുഭൂമിയിൽ സമാഗമകൂടാരത്തിൽ യഹോവ മോശയോട് സംസാരിച്ചു. ഇസ്രായേല്യർ ഈജിപ്റ്റിൽനിന്നും പുറപ്പെട്ടതിന്റെ രണ്ടാംവർഷം രണ്ടാംമാസം ഒന്നാംതീയതി ആയിരുന്നു അത്. അവിടന്ന് ഇപ്രകാരം അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ഇസ്രായേൽസമൂഹത്തെയെല്ലാം പിതൃഭവനം തിരിച്ചും കുടുംബം തിരിച്ചും സകലപുരുഷന്മാരുടെയും പേര് പട്ടികയിൽപ്പെടുത്തി ഒരു ജനസംഖ്യയെടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","സൈന്യസേവനം ചെയ്യാൻ പ്രാപ്തിയുള്ളവരായ ഇരുപതു വയസ്സും അതിനുമേൽ പ്രായമുള്ളവരും യുദ്ധപ്രാപ്തരുമായ ഇസ്രായേൽപുരുഷന്മാരെ നീയും അഹരോനും ഗണംഗണമായി എണ്ണണം. ");
INSERT INTO malc_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ഓരോ ഗോത്രത്തിൽനിന്നും ഓരോ പിതൃഭവനത്തലവൻ നിങ്ങളെ സഹായിക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“നിങ്ങൾക്കു സഹായികളായിരിക്കേണ്ട പുരുഷന്മാർ ഇവരാണ്: “രൂബേൻഗോത്രത്തിൽ ശെദെയൂരിന്റെ പുത്രൻ എലീസൂർ; ");
INSERT INTO malc_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ശിമെയോൻ ഗോത്രത്തിൽ സൂരീശദ്ദായിയുടെ പുത്രൻ ശെലൂമിയേൽ ");
INSERT INTO malc_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","യെഹൂദാഗോത്രത്തിൽ അമ്മീനാദാബിന്റെ പുത്രൻ നഹശോൻ; ");
INSERT INTO malc_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","യിസ്സാഖാർഗോത്രത്തിൽ സൂവാരിന്റെ പുത്രൻ നെഥനയേൽ; ");
INSERT INTO malc_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","സെബൂലൂൻഗോത്രത്തിൽ ഹേലോന്റെ പുത്രൻ എലീയാബ്; ");
INSERT INTO malc_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","യോസേഫിന്റെ പുത്രന്മാരിൽ: എഫ്രയീംഗോത്രത്തിൽ അമ്മീഹൂദിന്റെ പുത്രൻ എലീശാമ; മനശ്ശെഗോത്രത്തിൽ പെദാസൂരിന്റെ പുത്രൻ ഗമാലിയേൽ; ");
INSERT INTO malc_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ബെന്യാമീൻഗോത്രത്തിൽ ഗിദെയോനിയുടെ പുത്രൻ അബീദാൻ; ");
INSERT INTO malc_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ദാൻഗോത്രത്തിൽ അമ്മീശദ്ദായിയുടെ പുത്രൻ അഹീയേസെർ; ");
INSERT INTO malc_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ആശേർഗോത്രത്തിൽ ഒക്രാന്റെ പുത്രൻ പഗീയേൽ; ");
INSERT INTO malc_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ഗാദ്ഗോത്രത്തിൽ ദെയൂവേലിന്റെ പുത്രൻ എലീയാസാഫ്; ");
INSERT INTO malc_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","നഫ്താലി ഗോത്രത്തിൽ ഏനാന്റെ പുത്രൻ അഹീരാ.” ");
INSERT INTO malc_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ഇവരായിരുന്നു ഇസ്രായേൽസമൂഹത്തിൽനിന്നും നിയമിതരായ പിതൃഭവനത്തലവന്മാർ. ഇവർ ഇസ്രായേലിൽ സഹസ്രങ്ങൾക്ക് അധിപതിമാരായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","നാമനിർദേശം ചെയ്യപ്പെട്ട ഈ പുരുഷന്മാരെ മോശയും അഹരോനും കൂട്ടിവരുത്തി. ");
INSERT INTO malc_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","തുടർന്ന് അവർ രണ്ടാംമാസം ഒന്നാംതീയതി സകല ഇസ്രായേൽസമൂഹത്തെയും വിളിച്ചുവരുത്തി. ജനങ്ങൾ ഗോത്രങ്ങളായും കുടുംബങ്ങളായും തങ്ങളുടെ വംശവിവരം അറിയിക്കുകയും ഇരുപതു വയസ്സുമുതൽ മേൽപ്പോട്ടുള്ള പുരുഷന്മാരുടെ ഓരോരുത്തരുടെയും പേര് പട്ടികയിൽ ചേർക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ അദ്ദേഹം അവരെ സീനായിമരുഭൂമിയിൽവെച്ച് എണ്ണി: ");
INSERT INTO malc_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ഇസ്രായേലിന്റെ ആദ്യജാതനായ രൂബേന്റെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","രൂബേൻഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 46,500 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ശിമെയോന്റെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ശിമെയോൻഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 59,300 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ഗാദിന്റെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ഗാദ്ഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 45,650 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","യെഹൂദയുടെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","യെഹൂദാഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 74,600 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","യിസ്സാഖാറിന്റെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","യിസ്സാഖാർ ഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 54,400 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","സെബൂലൂന്റെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","സെബൂലൂൻഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 57, 400 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","യോസേഫിന്റെ മക്കളിൽ: എഫ്രയീമിന്റെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","എഫ്രയീംഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 40,500 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","മനശ്ശെയുടെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","മനശ്ശെ ഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 32,200 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ബെന്യാമീന്റെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ബെന്യാമീന്റെ ഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 35,400 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ദാന്റെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ദാൻഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 62,700 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ആശേരിന്റെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ആശേർ ഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 41,500 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","നഫ്താലിയുടെ ഗോത്രത്തിൽനിന്നും: വംശപാരമ്പര്യം, പിതൃഭവനം, കുടുംബം, പേര് ഇവയനുസരിച്ച് ഇരുപതു വയസ്സും അതിനുമേലും പ്രായമുള്ള യുദ്ധപ്രാപ്തരായ എല്ലാ പുരുഷന്മാരുടെയും കണക്കെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","നഫ്താലിഗോത്രത്തിൽനിന്ന് ഉള്ളവർ 53,400 പേർ. ");
INSERT INTO malc_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","മോശയും അഹരോനും പിതൃഭവനത്തലവന്മാരായ പന്ത്രണ്ട് ഇസ്രായേൽ പ്രഭുക്കന്മാരുംകൂടി തങ്ങളുടെ ഗോത്രങ്ങളിൽനിന്നും എണ്ണിയ പുരുഷന്മാർ ഇവരായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ഇസ്രായേൽ സൈന്യത്തിൽ സേവനമനുഷ്ഠിക്കാൻ പ്രാപ്തരായ ഇരുപതു വയസ്സുമുതൽ മേൽപ്പോട്ടുള്ള സകല ഇസ്രായേല്യരെയും അവരുടെ കുടുംബങ്ങളായി എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","അവരുടെ ആകെ എണ്ണം 6,03,550 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ലേവിഗോത്രകുടുംബങ്ങളെ മറ്റു പിതൃഭവനക്കുടുംബങ്ങളോടൊപ്പം എണ്ണിയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","യഹോവ മോശയോട് അരുളിച്ചെയ്തിരുന്നു: ");
INSERT INTO malc_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“നീ ലേവിഗോത്രത്തെ എണ്ണുകയോ മറ്റ് ഇസ്രായേല്യരുടെ ജനസംഖ്യയെടുപ്പിൽ അവരെ ഉൾപ്പെടുത്തുകയോ ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","പകരം, ലേവ്യരെ ഉടമ്പടിയുടെ കൂടാരത്തിന്റെയും അതിന്റെ വസ്തുക്കളുടെയും ഉപകരണങ്ങളുടെയും മേൽവിചാരകരായി നിയമിക്കുക. സമാഗമകൂടാരവും അതിലെ ഉപകരണങ്ങളും അവർ ചുമക്കണം; അതു സൂക്ഷിക്കുകയും അതിനുചുറ്റും പാളയമടിച്ചു പാർക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","സമാഗമകൂടാരം പുറപ്പെടുമ്പോൾ ലേവ്യർ അത് അഴിക്കണം; സമാഗമകൂടാരം സ്ഥാപിക്കുമ്പോൾ ലേവ്യർ അത് ഉയർത്തണം. അന്യർ അതിനെ സമീപിച്ചാൽ അവർക്കു വധശിക്ഷനൽകണം. ");
INSERT INTO malc_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ഇസ്രായേല്യർ ഗണംഗണമായി അവരവരുടെ പാളയത്തിൽ, സ്വന്തം പതാകയ്ക്കു കീഴിൽ തങ്ങളുടെ കൂടാരങ്ങൾ ഉയർത്തണം. ");
INSERT INTO malc_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ഇസ്രായേൽമക്കളുടെമേൽ ദൈവകോപം വരാതിരിക്കാൻ ലേവ്യർ ഉടമ്പടിയുടെ കൂടാരത്തിനുചുറ്റും പാളയം അടിക്കണം; ലേവ്യർ ഉടമ്പടിയുടെ കൂടാരത്തിന്റെ ചുമതല വഹിക്കുകയും വേണം.” ");
INSERT INTO malc_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെയെല്ലാം ഇസ്രായേൽമക്കൾ ചെയ്തു; അപ്രകാരംതന്നെ അവർ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ഇസ്രായേൽജനം തങ്ങളുടെ ഗോത്രചിഹ്നങ്ങളുള്ള പതാകകൾക്കു കീഴിൽ സമാഗമകൂടാരത്തിനുചുറ്റും അൽപ്പം അകലെയായി പാളയമടിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","യെഹൂദാഗോത്രത്തിലുള്ളവർ സൂര്യോദയത്തിന് അഭിമുഖമായി തങ്ങളുടെ പതാകയിൻകീഴിൽ പാളയമടിക്കണം. അമ്മീനാദാബിന്റെ മകൻ നഹശോനാണ് യെഹൂദാഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 74,600. ");
INSERT INTO malc_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","യിസ്സാഖാർഗോത്രം അവർക്ക് അടുത്തായി പാളയമടിക്കും. സൂവാരിന്റെ മകൻ നെഥനയേലാണ് യിസ്സാഖാർഗോത്രാംഗങ്ങളുടെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 54,400. ");
INSERT INTO malc_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","അടുത്തത് സെബൂലൂൻ ഗോത്രമായിരിക്കും. ഹേലോന്റെ മകൻ എലീയാബാണ് സെബൂലൂൻഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 57,400. ");
INSERT INTO malc_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","യെഹൂദാ പാളയത്തിലേക്കു നിശ്ചയിക്കപ്പെട്ട പുരുഷന്മാരുടെ എണ്ണം അവരുടെ ഗണങ്ങളിൻപ്രകാരം ആകെ 1,86,400. ആദ്യം അവർ പുറപ്പെടണം. ");
INSERT INTO malc_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","രൂബേൻഗോത്രത്തിലുള്ളവർ തങ്ങളുടെ പതാകയിൻകീഴിൽ തെക്കുഭാഗത്തു പാളയമടിക്കണം. ശെദെയൂരിന്റെ മകൻ എലീസൂർ ആണ് രൂബേൻഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 46,500. ");
INSERT INTO malc_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ശിമെയോൻഗോത്രം അവർക്ക് അടുത്തായി പാളയമടിക്കും. സൂരീശദ്ദായിയുടെ മകൻ ശെലൂമിയേലാണ് ശിമെയോൻഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 59,300. ");
INSERT INTO malc_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ഗാദ്ഗോത്രമായിരിക്കും അടുത്തത്. രെയൂവേലിന്റെ മകൻ എലീയാസാഫാണ് ഗാദ്ഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 45,650. ");
INSERT INTO malc_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","രൂബേൻപാളയത്തിലേക്കു നിശ്ചയിക്കപ്പെട്ട പുരുഷന്മാർ, അവരുടെ ഗണങ്ങളിൻപ്രകാരം ആകെ 1,51,450. അവർ രണ്ടാമതായി പുറപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","പിന്നീട് പാളയങ്ങൾക്കു മധ്യത്തിലായി സമാഗമകൂടാരവും ലേവ്യരുടെ പാളയവും യാത്രപുറപ്പെടും. പാളയമടിക്കുമ്പോഴുള്ള ക്രമംപോലെ ഓരോരുത്തരും സ്വന്തം പതാകയ്ക്കു കീഴിലായി അവരവരുടെ ക്രമമനുസരിച്ചു പുറപ്പെടണം. ");
INSERT INTO malc_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","എഫ്രയീംഗണം, തങ്ങളുടെ പതാകയിൻകീഴിൽ പടിഞ്ഞാറുഭാഗത്തു പാളയമിറങ്ങണം. അമ്മീഹൂദിന്റെ മകൻ എലീശാമ ആണ് എഫ്രയീംഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 40,500. ");
INSERT INTO malc_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","മനശ്ശെഗോത്രം ആയിരിക്കും അടുത്തത്. പെദാസൂരിന്റെ മകൻ ഗമാലിയേൽ ആണ് മനശ്ശെഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 32,200. ");
INSERT INTO malc_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","അതിനുശേഷം ബെന്യാമീൻഗോത്രം വരും. ഗിദെയോനിയുടെ മകൻ അബീദാൻ ആണ് ബെന്യാമീൻഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 35,400. ");
INSERT INTO malc_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","എഫ്രയീം പാളയത്തിലേക്കു നിശ്ചയിക്കപ്പെട്ട പുരുഷന്മാർ, അവരുടെ ഗണങ്ങളിൻപ്രകാരം ആകെ 1,08,100. അവർ മൂന്നാമതായി പുറപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ദാൻഗണം വടക്ക്: തങ്ങളുടെ പതാകയിൻകീഴിൽ പാളയമടിക്കും. അമ്മീശദ്ദായിയുടെ മകൻ അഹീയേസെർ ആണ് ദാൻഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 62,700. ");
INSERT INTO malc_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","അവർക്ക് അടുത്ത് ആശേർഗോത്രം പാളയമടിക്കും. ഒക്രാന്റെ മകൻ പഗീയേൽ ആണ് ആശേർഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 41,500. ");
INSERT INTO malc_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","നഫ്താലി ഗോത്രമായിരിക്കും അടുത്തത്. ഏനാന്റെ മകൻ അഹീരാ ആണു നഫ്താലിഗോത്രത്തിന്റെ പ്രഭു. ");
INSERT INTO malc_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","അദ്ദേഹത്തിന്റെ ഗണത്തിലുള്ളവർ 53,400. ");
INSERT INTO malc_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ദാൻപാളയത്തിലേക്കു നിശ്ചയിക്കപ്പെട്ട പുരുഷന്മാർ ആകെ 1, 57, 600. തങ്ങളുടെ പതാകയിൻകീഴിൽ അവർ ഒടുവിലായി പുറപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","കുടുംബങ്ങളായി എണ്ണപ്പെട്ട ഇസ്രായേല്യർ ഇവരാണ്. ഗണംഗണമായി പാളയങ്ങളിലുള്ള പുരുഷന്മാർ ആകെ 6,03,550. ");
INSERT INTO malc_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ മറ്റ് ഇസ്രായേൽമക്കളോടൊപ്പം ലേവ്യരെ എണ്ണിയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","അങ്ങനെ യഹോവ മോശയോടു കൽപ്പിച്ചതെല്ലാം ഇസ്രായേൽമക്കൾ ചെയ്തു; അപ്രകാരമായിരുന്നു അവർ തങ്ങളുടെ പതാകകളിൻകീഴിൽ പാളയമടിച്ചത്, അങ്ങനെയായിരുന്നു ഓരോരുത്തരും തങ്ങളുടെ കുടുംബത്തോടും പിതൃഭവനത്തോടുമൊപ്പം പുറപ്പെട്ടത്. ");
INSERT INTO malc_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","സീനായിമലയിൽ യഹോവ മോശയോടു സംസാരിച്ച കാലത്ത് അഹരോന്റെയും മോശയുടെയും വംശാവലി ഇപ്രകാരമായിരുന്നു: ");
INSERT INTO malc_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","അഹരോന്റെ പുത്രന്മാരുടെ പേരുകൾ ഇവയാണ്: ആദ്യജാതനായ നാദാബ്, അബീഹൂ, എലെയാസാർ, ഈഥാമാർ. ");
INSERT INTO malc_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","പൗരോഹിത്യശുശ്രൂഷചെയ്യാൻ പ്രതിഷ്ഠിക്കപ്പെട്ടിരുന്ന അഹരോന്റെ പുത്രന്മാരായ അഭിഷിക്തപുരോഹിതന്മാരുടെ പേരുകൾ ഇവതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ഇവരിൽ നാദാബും അബീഹൂവും സീനായിമരുഭൂമിയിൽവെച്ച് യഹോവയുടെ തിരുമുമ്പാകെ അന്യാഗ്നി കൊണ്ടുവന്നതു നിമിത്തം അവിടെ വീണ് മരിച്ചുപോയിരുന്നു. അവർക്കു പുത്രന്മാരില്ലായിരുന്നു; അതുകൊണ്ട് എലെയാസാരും ഈഥാമാരുംമാത്രമാണ് തങ്ങളുടെ പിതാവായ അഹരോന്റെ കാലത്ത് പൗരോഹിത്യശുശ്രൂഷ ചെയ്തത്. ");
INSERT INTO malc_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“പുരോഹിതനായ അഹരോനെ സഹായിക്കുന്നതിനായി ലേവിഗോത്രത്തെ കൂട്ടിവരുത്തുക. ");
INSERT INTO malc_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","അവർ അദ്ദേഹത്തിനുവേണ്ടിയും സർവസമൂഹത്തിനുവേണ്ടിയും സമാഗമത്തിനുള്ള കൂടാരത്തിലെ ശുശ്രൂഷകൾ ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","സമാഗമകൂടാരത്തിലെ സകല ഉപകരണങ്ങളുടെയും സൂക്ഷിപ്പ് അവർക്കായിരിക്കണം. അവർ കൂടാരത്തിലെ വേലകൾ ചെയ്തുകൊണ്ട് ഇസ്രായേല്യരുടെ കടമകൾ നിർവഹിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ലേവ്യരെ അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാർക്കുമായി ഏൽപ്പിച്ചുകൊടുക്കുക; അദ്ദേഹത്തിനു പരിപൂർണമായി ഏൽപ്പിക്കപ്പെടേണ്ട ഇസ്രായേല്യർ അവരാണ്. ");
INSERT INTO malc_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","പൗരോഹിത്യശുശ്രൂഷചെയ്യാൻ അഹരോനെയും അദ്ദേഹത്തിന്റെ പുത്രന്മാരെയും നിയമിക്കുക; മറ്റാരെങ്കിലും വിശുദ്ധസ്ഥലത്തെ സമീപിച്ചാൽ അവർ മരണശിക്ഷ അനുഭവിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","യഹോവ മോശയോടു വീണ്ടും പറഞ്ഞു: ");
INSERT INTO malc_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“എല്ലാ ഇസ്രായേല്യസ്ത്രീകളുടെയും ആദ്യജാതന്മാർക്കു പകരമായി ഇസ്രായേല്യരിൽനിന്ന് ഞാൻ ലേവ്യരെ എടുത്തിരിക്കുന്നു. ലേവ്യർ എനിക്കുള്ളവരാകുന്നു, ");
INSERT INTO malc_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","കാരണം സകല ആദ്യജാതന്മാരും എനിക്കുള്ളവരാണ്. ഞാൻ ഈജിപ്റ്റിലെ ആദ്യജാതന്മാരെയൊക്കെയും സംഹരിച്ചപ്പോൾ ഇസ്രായേലിലുള്ള മനുഷ്യരുടെയും മൃഗങ്ങളുടെയും കടിഞ്ഞൂലുകളെ ഒക്കെയും എനിക്കായി വേർതിരിച്ചു. അവർ എനിക്കുള്ളവർ; ഞാൻ യഹോവ ആകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","യഹോവ മോശയോടു സീനായിമരുഭൂമിയിൽവെച്ചു സംസാരിച്ചു: ");
INSERT INTO malc_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ലേവ്യരെ കുടുംബമായും പിതൃഭവനമായും എണ്ണണം. ഒരുമാസംമുതൽ മേലോട്ടു പ്രായമുള്ള ആണിനെയൊക്കെയും എണ്ണണം.” ");
INSERT INTO malc_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","യഹോവ തന്നോടു കൽപ്പിച്ചതുപോലെതന്നെ മോശ അവരെ എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ലേവിയുടെ മക്കളുടെ പേരുകൾ ഇവയായിരുന്നു: ഗെർശോൻ, കെഹാത്ത്, മെരാരി. ");
INSERT INTO malc_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","കുടുംബം കുടുംബമായി ഗെർശോന്യപുത്രന്മാർ: ലിബ്നി, ശിമെയി. ");
INSERT INTO malc_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","കുടുംബം കുടുംബമായി കെഹാത്തിന്റെ പുത്രന്മാർ: അമ്രാം, യിസ്ഹാർ, ഹെബ്രോൻ, ഉസ്സീയേൽ. ");
INSERT INTO malc_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","കുടുംബം കുടുംബമായി മെരാരിയുടെ പുത്രന്മാർ: മഹ്ലി, മൂശി. പിതൃഭവനപ്രകാരം ലേവ്യകുടുംബങ്ങൾ ഇവയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ലിബ്നിയർ, ശിമ്യർ എന്നീ കുടുംബങ്ങൾ ഗെർശോനിൽനിന്നുള്ളവരായിരുന്നു; ഇവയാണ് ഗെർശോന്യകുടുംബങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ഒരുമാസവും അതിലധികവും പ്രായമുള്ള ആണുങ്ങളുടെ എണ്ണം 7,500. ");
INSERT INTO malc_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ഗെർശോന്യകുലങ്ങൾ പടിഞ്ഞാറുഭാഗത്ത് സമാഗമകൂടാരത്തിനു പിന്നിൽ പാളയമടിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ലായേലിന്റെ പുത്രൻ എലീയാസാഫ് ഗെർശോന്യ പിതൃഭവനങ്ങളുടെ പ്രഭു ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","സമാഗമകൂടാരത്തിൽ ഗെർശോന്യർ സൂക്ഷിക്കാൻ ചുമതലപ്പെട്ടിരുന്നത് സമാഗമകൂടാരം, തിരുനിവാസം, അതിന്റെ മൂടുവിരികൾ, സമാഗമകൂടാരത്തിന്റെ കവാടത്തിനുള്ള മറശ്ശീല, ");
INSERT INTO malc_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","കൂടാരാങ്കണകവാടത്തിന്റെ മറശ്ശീലകൾ, സമാഗമകൂടാരത്തെയും യാഗപീഠത്തെയും ചുറ്റി അങ്കണകവാടത്തിലുള്ള മറശ്ശീല, അതിന്റെ കയറുകൾ, അതിന്റെ ഉപയോഗത്തിനുള്ള എല്ലാ അനുബന്ധ ഉപകരണങ്ങൾ എന്നിവ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","അമ്രാമ്യർ, യിസ്ഹാര്യർ, ഹെബ്രോന്യർ, ഉസ്സീയേല്യർ എന്നീ കുലങ്ങൾ കെഹാത്തിനുള്ളവയായിരുന്നു; ഇവയായിരുന്നു കെഹാത്യ പിതൃഭവനങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ഒരുമാസവും അതിലധികവും പ്രായമുള്ള ആണുങ്ങളുടെ എണ്ണം 8,600. കെഹാത്യർക്കായിരുന്നു വിശുദ്ധമന്ദിരം സൂക്ഷിക്കുന്ന ചുമതല. ");
INSERT INTO malc_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","കെഹാത്യ പിതൃഭവനങ്ങൾ പാളയമടിച്ചിരുന്നത് സമാഗമകൂടാരത്തിന്റെ തെക്കുഭാഗത്താണ്. ");
INSERT INTO malc_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","കെഹാത്യകുടുംബങ്ങളുടെ പിതൃഭവനത്തിനു പ്രഭു ഉസ്സീയേലിന്റെ പുത്രൻ എലീസാഫാൻ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","പേടകം, മേശ, വിളക്കുതണ്ട്, യാഗപീഠങ്ങൾ, ശുശ്രൂഷയ്ക്ക് ഉപയോഗിച്ചിരുന്ന വിശുദ്ധമന്ദിരത്തിലെ ഉപകരണങ്ങൾ, മറശ്ശീല എന്നിവയും അവയുടെ ഉപയോഗത്തോടു ബന്ധപ്പെട്ട സകലതും ഈ നാലു കുലങ്ങളുടെ ചുമതലയിലായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","പുരോഹിതനായ അഹരോന്റെ പുത്രൻ എലെയാസാരായിരുന്നു ലേവ്യരുടെ പ്രധാന പ്രഭു. വിശുദ്ധമന്ദിരത്തിന്റെ സൂക്ഷിപ്പിനു ചുമതലപ്പെട്ടവരുടെ മേൽവിചാരകനായി അദ്ദേഹം നിയമിക്കപ്പെട്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","മഹ്ലീയരുടെയും മൂശ്യരുടെയും കുടുംബങ്ങൾ മെരാരിയിൽനിന്നുള്ളവയായിരുന്നു; ഇവയായിരുന്നു മെരാര്യകുടുംബങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","അവരിൽ ഒരുമാസവും അതിലധികവും പ്രായമുള്ള ആണുങ്ങൾ 6,200. ");
INSERT INTO malc_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","മെരാര്യകുടുംബങ്ങളുടെ പ്രഭു അബീഹയീലിന്റെ പുത്രൻ സൂരിയേലായിരുന്നു. സമാഗമകൂടാരത്തിന്റെ വടക്കുഭാഗത്ത് അവർ പാളയമടിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","സമാഗമകൂടാരത്തിന്റെ ചട്ടക്കൂടുകൾ, അതിന്റെ സാക്ഷകൾ, തൂണുകൾ, ചുവടുകൾ, അതിന്റെ ഉപകരണങ്ങൾ സകലതും, ");
INSERT INTO malc_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","കൂടാതെ ചുറ്റുമുള്ള അങ്കണത്തിന്റെ തൂണുകൾ, അവയുടെ ചുവടുകൾ, കൂടാരത്തിന്റെ കുറ്റികൾ, കയറുകൾ തുടങ്ങി അവയുടെ ഉപയോഗവുമായി ബന്ധപ്പെട്ട സകലതും മെരാര്യരുടെ ചുമതലയിലായിരുന്നു സൂക്ഷിച്ചിരുന്നത്. ");
INSERT INTO malc_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","മോശയും, അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാരും സമാഗമകൂടാരത്തിന്റെ കിഴക്കുഭാഗത്തേക്ക്, സൂര്യോദയത്തിനഭിമുഖമായി, സമാഗമകൂടാരത്തിന്റെമുമ്പിൽ പാളയമടിക്കണം. ഇസ്രായേല്യർക്കുവേണ്ടി അവരായിരുന്നു വിശുദ്ധമന്ദിരത്തിന്റെ സൂക്ഷിപ്പിന് ചുമതലപ്പെട്ടവർ. വിശുദ്ധമന്ദിരത്തോട് സമീപിക്കുന്ന അന്യർ മരണശിക്ഷ അനുഭവിക്കേണ്ടിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","യഹോവയുടെ കൽപ്പനപ്രകാരം മോശയും അഹരോനും കുടുംബങ്ങൾ അനുസരിച്ച് എണ്ണിയ ലേവ്യർ, ഒരുമാസമോ അതിലധികമോ പ്രായമുള്ള സകല ആണുങ്ങളുടെയും എണ്ണം 22,000 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","യഹോവ പിന്നെയും മോശയോടു കൽപ്പിച്ചു: “ഒരുമാസവും അതിലധികവും പ്രായമുള്ളവരായ ഇസ്രായേല്യരിലെ ആദ്യജാതരായ ആണുങ്ങളെ എല്ലാവരെയും എണ്ണി അവരുടെ പേരുകളുടെ ഒരു പട്ടിക തയ്യാറാക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ഇസ്രായേല്യരിലെ സകല ആദ്യജാതന്മാർക്കും പകരം ലേവ്യരെയും ഇസ്രായേല്യരുടെ കന്നുകാലികളിലെ സകലകടിഞ്ഞൂലുകൾക്കും പകരം ലേവ്യരുടെ കന്നുകാലികളെയും എനിക്കുവേണ്ടി എടുക്കുക. ഞാൻ യഹോവ ആകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","അങ്ങനെ മോശ, യഹോവ തന്നോടു കൽപ്പിച്ചതുപോലെ ഇസ്രായേല്യരിലെ സകല ആദ്യജാതന്മാരെയും എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","പട്ടികയിൽ പേരു ചേർത്ത ഒരുമാസമോ അതിലധികമോ പ്രായമുള്ള ആദ്യജാതരായ ആണുങ്ങൾ 22,273 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","യഹോവ പിന്നെയും മോശയോടു കൽപ്പിച്ചു: ");
INSERT INTO malc_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ഇസ്രായേലിലെ സകല ആദ്യജാതന്മാർക്കും പകരം ലേവ്യരെയും, അവരുടെ കന്നുകാലികൾക്കു പകരം ലേവ്യരുടെ കന്നുകാലികളെയും എടുക്കുക. ലേവ്യർ എനിക്കുള്ളവർ ആയിരിക്കണം. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ഇസ്രായേൽജനത്തിന്റെ ആദ്യജാതന്മാരിൽ ലേവ്യപുരുഷന്മാരുടെ സംഖ്യയെ കവിയുന്ന 273 പേരും, വീണ്ടെടുപ്പുവിലയായി, ");
INSERT INTO malc_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ആളാംപ്രതി അഞ്ചുശേക്കേൽ വീതം വാങ്ങുക. വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം, ശേക്കേൽ ഒന്നിന് ഇരുപതു ഗേരാവീതം വാങ്ങണം. ");
INSERT INTO malc_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ലേവ്യരുടെ എണ്ണത്തിൽ കവിഞ്ഞുള്ള ഇസ്രായേല്യരുടെ വീണ്ടെടുപ്പുവില അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാർക്കും നൽകണം.” ");
INSERT INTO malc_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","അങ്ങനെ ലേവ്യരാൽ വീണ്ടെടുക്കപ്പെട്ടവരുടെ എണ്ണത്തെ കവിയുന്നവരിൽനിന്ന് വീണ്ടെടുപ്പുവില മോശ വാങ്ങി. ");
INSERT INTO malc_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ഇസ്രായേല്യരുടെ ആദ്യജാതന്മാരിൽനിന്ന് വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം 1,365 ശേക്കേൽ വെള്ളി അദ്ദേഹം വാങ്ങി. ");
INSERT INTO malc_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","യഹോവയുടെ വചനത്താൽ തനിക്കു കൽപ്പന ലഭിച്ചതിൻപ്രകാരം മോശ വീണ്ടെടുപ്പുവില അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാർക്കും കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ലേവ്യാഗോത്രത്തിലെ കെഹാത്യരുടെ ജനസംഖ്യ പിതൃഭവനമായും കുടുംബമായും എടുക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","സമാഗമകൂടാരത്തിലെ ശുശ്രൂഷയ്ക്കു വരുന്നവരായ മുപ്പതുമുതൽ അൻപതുവരെ വയസ്സു പ്രായമുള്ള സകലപുരുഷന്മാരെയും എണ്ണുക. ");
INSERT INTO malc_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“സമാഗമകൂടാരത്തിലെ അതിവിശുദ്ധവസ്തുക്കൾ സൂക്ഷിക്കുകയാണ് കെഹാത്യരുടെ ചുമതല. ");
INSERT INTO malc_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","പാളയം യാത്ര പുറപ്പെടുമ്പോൾ അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാരും അകത്തുചെന്ന് മറശ്ശീല അഴിച്ചിറക്കി ഉടമ്പടിയുടെ പേടകം അതുകൊണ്ടു മൂടണം. ");
INSERT INTO malc_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","പിന്നെ അവർ അതു തഹശുതുകൽകൊണ്ടു മൂടണം. ഒരു നീല തുണി അതിന്മേൽ വിരിച്ച് തണ്ടുകൾ യഥാസ്ഥാനത്ത് ഇടുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“കാഴ്ചയപ്പത്തിന്റെ മേശമേൽ അവർ ഒരു നീലത്തുണി വിരിച്ച് തളികകളും പാത്രങ്ങളും കോപ്പകളും പാനീയയാഗത്തിനുള്ള ഭരണികളും അതിന്മേൽ വെക്കണം; അവിടെ നിരന്തരം ഉണ്ടാകാറുള്ള അപ്പവും അതിന്മേൽതന്നെ ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ഇവയുടെമേൽ അവർ ഒരു ചെമപ്പു തുണി വിരിക്കുകയും അതു തഹശുതുകൽകൊണ്ടു മൂടുകയും, പിന്നീട് അതിന്റെ തണ്ടുകൾ ഉറപ്പിക്കുകയും ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“അവർ ഒരു നീലത്തുണി എടുത്ത് വെളിച്ചത്തിനുള്ള വിളക്ക്, അതിന്റെ ദീപങ്ങളോടും അതിന്റെ കരിന്തിരി മുറിക്കുന്നതിനുള്ള കത്രികകളോടും അതിന്റെ പാത്രങ്ങളോടും അതിൽ ഒഴിക്കുന്ന എണ്ണയുടെ എല്ലാ ഭരണികളോടുംകൂടെ മൂടണം. ");
INSERT INTO malc_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","പിന്നെ അവർ അതും അതോടു ബന്ധപ്പെട്ട സകല ഉപകരണഭാഗങ്ങളും തഹശുതുകൽകൊണ്ടു പൊതിഞ്ഞ് ചുമക്കാനുള്ള ഒരു തണ്ടിന്മേൽ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“തങ്കയാഗപീഠത്തിന്മേൽ അവർ ഒരു നീലത്തുണി വിരിക്കുകയും തഹശുതുകൽകൊണ്ട് അതു മൂടുകയും അതിന്റെ തണ്ട് ഉറപ്പിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“അവർ വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷയ്ക്ക് ഉപയോഗിക്കുന്ന ഉപകരണങ്ങളെല്ലാം എടുത്ത്, ഒരു നീലത്തുണിയിൽ പൊതിഞ്ഞ്, തഹശുതുകൽകൊണ്ടു മൂടി, ചുമക്കാനുള്ള തണ്ടിന്മേൽ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“അവർ വെങ്കലയാഗപീഠത്തിന്മേൽനിന്ന് ചാരം നീക്കി ഒരു ഊതവർണത്തിലുള്ള ഒരു ശീല അതിന്മേൽ വിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","പിന്നെ അവർ അഗ്നികലശങ്ങൾ, മാംസം കൈകാര്യം ചെയ്യാനുള്ള മുൾക്കരണ്ടികൾ, കോരികകൾ, തളിക്കുന്നതിനുള്ള കലങ്ങൾ എന്നിവ ഉൾപ്പെടെ യാഗപീഠത്തിലെ ശുശ്രൂഷയ്ക്ക് ഉപയോഗിക്കുന്ന സകല ഉപകരണങ്ങും അതിന്മേൽ വെക്കണം. അതിന്മേൽ അവർ തഹശുതുകൽകൊണ്ടുള്ള ഒരു വിരി വിരിച്ച്, ചുമക്കാനുള്ള തണ്ടുകൾ ഉറപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാരും വിശുദ്ധ ഉപകരണങ്ങളും സകലവിശുദ്ധവസ്തുക്കളും മൂടിത്തീർന്നശേഷം, പാളയം പുറപ്പെടാൻ തയ്യാറാക്കിയിരിക്കുമ്പോൾ ചുമക്കുന്ന ജോലിക്കായി കെഹാത്യർ വരണം. എന്നാൽ അവർ മരിക്കാതിരിക്കേണ്ടതിന്, വിശുദ്ധവസ്തുക്കളെ സ്പർശിക്കരുത്. സമാഗമകൂടാരത്തിലുള്ള ഈ സാധനങ്ങളാണ് കെഹാത്യർ ചുമക്കേണ്ടത്. ");
INSERT INTO malc_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“വെളിച്ചത്തിനുള്ള എണ്ണ, സുഗന്ധധൂപവർഗം, നിരന്തരം അർപ്പിക്കുന്ന ഭോജനയാഗം, അഭിഷേകതൈലം എന്നിവയുടെ മേൽനോട്ടം പുരോഹിതനായ അഹരോന്റെ പുത്രൻ എലെയാസാർക്ക് ആയിരിക്കണം. സമാഗമകൂടാരം മുഴുവനും, അതിന്റെ വിശുദ്ധ ഉപകരണങ്ങളും വസ്തുക്കളും ഉൾപ്പെടെ അതിലുള്ള സകലതിന്റെയും ചുമതല അദ്ദേഹത്തിനായിരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“കെഹാത്യകുടുംബങ്ങളുടെ കുലങ്ങൾ ലേവ്യരിൽനിന്ന് നശിപ്പിക്കപ്പെടരുത്. ");
INSERT INTO malc_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","അതിവിശുദ്ധവസ്തുക്കളോടു സമീപിക്കുമ്പോൾ അവർ മരിക്കാതിരിക്കേണ്ടതിന് അവർക്കുവേണ്ടി ഇതു ചെയ്യുക: അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാരും വിശുദ്ധമന്ദിരത്തിൽ കടന്നുചെന്ന് ഓരോ പുരുഷനെയും അവന്റെ ജോലിയും അവൻ ചുമക്കേണ്ട വസ്തുക്കളും ഏൽപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","എന്നാൽ കെഹാത്യർ മരിക്കാതിരിക്കേണ്ടതിനു വിശുദ്ധവസ്തുക്കൾ മൂടുന്ന സമയം അവർ അകത്തുചെന്നു വിശുദ്ധവസ്തുക്കൾ നോക്കരുത്.” ");
INSERT INTO malc_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“പിതൃഭവനമായും കുടുംബമായും ഗെർശോന്യരുടെ ജനസംഖ്യയെടുക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","സമാഗമകൂടാരത്തിലെ ശുശ്രൂഷയ്ക്കു വരുന്നവരായ മുപ്പതുമുതൽ അൻപതുവരെ വയസ്സു പ്രായമുള്ള സകലപുരുഷന്മാരെയും എണ്ണുക. ");
INSERT INTO malc_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“വേലയിലും ചുമട് എടുക്കുന്നതിലും ഗെർശോന്യകുലങ്ങളുടെ ശുശ്രൂഷ ഇതാണ്: ");
INSERT INTO malc_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","കൂടാരത്തിന്റെ മറശ്ശീലകൾ, സമാഗമകൂടാരം, അതിന്റെ വിരി, തഹശുതുകൽകൊണ്ടുള്ള പുറംമൂടി, സമാഗമകൂടാരവാതിൽക്കലുള്ള മറശ്ശീലകൾ, ");
INSERT INTO malc_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","സമാഗമകൂടാരത്തെയും യാഗപീഠത്തെയും ചുറ്റിയുള്ള അങ്കണത്തിന്റെ മറശ്ശീലകൾ, അങ്കണകവാടത്തിന്റെ മറശ്ശീല, കയറുകൾ, അതിന്റെ ശുശ്രൂഷയിൽ ഉപയോഗിക്കുന്ന ഉപകരണങ്ങൾ ഇവയെല്ലാം അവർ ചുമക്കണം. ഇവകൊണ്ടു ചെയ്യേണ്ട ജോലിയൊക്കെയും ഗെർശോന്യർ ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ചുമടു ചുമക്കുന്നതോ ഇതര വേലകൾ ചെയ്യുന്നതോ ആയ അവരുടെ ശുശ്രൂഷകൾ എല്ലാം അഹരോന്റെയും പുത്രന്മാരുടെയും നിർദേശാനുസരണമായിരിക്കണം. അവർക്കുള്ള കർത്തവ്യമെല്ലാം നീ അവരെ ഏൽപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","സമാഗമകൂടാരത്തിലെ ഗെർശോന്യകുടുംബങ്ങളുടെ ശുശ്രൂഷ ഇതാണ്. പുരോഹിതനായ അഹരോന്റെ പുത്രൻ ഈഥാമാരിന്റെ നിർദേശാനുസരണം അവർ ശുശ്രൂഷചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“മെരാര്യരെ പിതൃഭവനമായും കുടുംബമായും എണ്ണുക. ");
INSERT INTO malc_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","സമാഗമകൂടാരത്തിലെ ശുശ്രൂഷയ്ക്കു വരുന്നവരായ മുപ്പതുമുതൽ അൻപതുവയസ്സുവരെ പ്രായമുള്ള സകലപുരുഷന്മാരെയും എണ്ണുക. ");
INSERT INTO malc_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","സമാഗമകൂടാരത്തിൽ അവർ ശുശ്രൂഷ നിവർത്തിക്കുമ്പോഴുള്ള അവരുടെ കർത്തവ്യം ഇതാണ്: കൂടാരത്തിന്റെ ചട്ടക്കൂട്, അതിന്റെ സാക്ഷകൾ, തൂണുകളും ചുവടുകളും, ");
INSERT INTO malc_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","അതുപോലെതന്നെ ചുറ്റുമുള്ള അങ്കണത്തിന്റെ തൂണുകളും ചുവടുകളും, കൂടാരത്തിന്റെ കുറ്റികൾ, കയറുകൾ എന്നിങ്ങനെ എല്ലാ ഉപകരണങ്ങളും അവയുടെ ഉപയോഗവുമായി ബന്ധപ്പെട്ട സകലതും അവർ ചുമക്കണം. ഓരോ പുരുഷനെയും അവൻ ചുമക്കേണ്ട സാധനങ്ങൾ പ്രത്യേകം ഏൽപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","സമാഗമകൂടാരത്തിൽ വേലചെയ്യുമ്പോൾ പുരോഹിതനായ അഹരോന്റെ പുത്രൻ ഈഥാമാരിന്റെ നിർദേശാനുസരണം മെരാര്യകുടുംബങ്ങൾ അനുഷ്ഠിക്കേണ്ട ശുശ്രൂഷ ഇതാണ്.” ");
INSERT INTO malc_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","മോശയും അഹരോനും സഭയിലെ നേതാക്കന്മാരും കെഹാത്യരെ പിതൃഭവനമായും കുടുംബമായും എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","സമാഗമകൂടാരത്തിലെ ശുശ്രൂഷയ്ക്കുവന്ന മുപ്പതുമുതൽ അൻപതുവയസ്സുവരെ പ്രായമുള്ള പുരുഷന്മാർ ");
INSERT INTO malc_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","പിതൃഭവനപ്രകാരം എണ്ണപ്പെട്ടവർ ആകെ 2,750 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","സമാഗമകൂടാരത്തിൽ ശുശ്രൂഷചെയ്തവരായി കെഹാത്യകുടുംബങ്ങളിലുള്ളവരുടെ ആകെ എണ്ണം ആയിരുന്നു ഇത്. മോശയോട് യഹോവ കൽപ്പിച്ചപ്രകാരം മോശയും അഹരോനും അവരെ എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ഗെർശോന്യരെ പിതൃഭവനമായും കുടുംബമായും എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","സമാഗമകൂടാരത്തിലെ ശുശ്രൂഷയ്ക്കുവന്ന മുപ്പതുമുതൽ അൻപതുവയസ്സുവരെ പ്രായമുള്ള, ");
INSERT INTO malc_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","പിതൃഭവനമായും കുടുംബമായും എണ്ണപ്പെട്ട പുരുഷന്മാർ ആകെ 2,630 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","സമാഗമകൂടാരത്തിൽ ശുശ്രൂഷചെയ്തവരായി ഗെർശോന്യകുടുംബങ്ങളിലുള്ളവരുടെ ആകെ എണ്ണം ആയിരുന്നു ഇത്. യഹോവയുടെ കൽപ്പനപ്രകാരം മോശയും അഹരോനും അവരെ എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","മെരാര്യരെ പിതൃഭവനമായും കുടുംബമായും എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","സമാഗമകൂടാരത്തിലെ ശുശ്രൂഷയ്ക്കുവന്ന മുപ്പതുമുതൽ അൻപതുവയസ്സുവരെ പ്രായമുള്ളവരും ");
INSERT INTO malc_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","പിതൃഭവനപ്രകാരം എണ്ണപ്പെട്ടവരുമായ പുരുഷന്മാർ ആകെ 3,200 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","മെരാര്യകുടുംബങ്ങളിൽ ഉള്ളവരുടെ ആകെ എണ്ണമായിരുന്നു ഇത്. മോശയിലൂടെ യഹോവ കൽപ്പിച്ചപ്രകാരം മോശയും അഹരോനും അവരെ എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","അങ്ങനെ മോശയും അഹരോനും ഇസ്രായേലിന്റെ പ്രഭുക്കന്മാരുംകൂടി ലേവ്യരെ മുഴുവൻ പിതൃഭവനമായും കുടുംബമായും എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","സമാഗമകൂടാരത്തിന്റെ ശുശ്രൂഷയ്ക്കും ചുമടിനും വന്നിരുന്ന മുപ്പതുമുതൽ അൻപതുവയസ്സുവരെ പ്രായമുള്ള പുരുഷന്മാർ ");
INSERT INTO malc_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ആകെ 8,580 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","യഹോവ മോശയിലൂടെ കൽപ്പിച്ചതുപോലെ, ഓരോരുത്തനെയും താന്താങ്ങളുടെ ചുമതല ഏൽപ്പിച്ചു; അവരുടെ കർത്തവ്യങ്ങളെക്കുറിച്ചു നിർദേശവും നൽകി. യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ അദ്ദേഹം അവരെ എണ്ണി. ");
INSERT INTO malc_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","യഹോവ മോശയോടു കൽപ്പിച്ചു: ");
INSERT INTO malc_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“കുഷ്ഠരോഗമോ, എന്തെങ്കിലും സ്രവമോ ഉള്ളവരെയും, മൃതശരീരംനിമിത്തം ആചാരപരമായി അശുദ്ധരായവരെയും പാളയത്തിൽനിന്ന് പുറത്താക്കാൻ ഇസ്രായേല്യരോടു കൽപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","സ്ത്രീപുരുഷഭേദമെന്യേ അവരെ പുറത്താക്കുക; അവരുടെ ഇടയിൽ ഞാൻ വസിക്കുന്ന പാളയം അവർ അശുദ്ധമാക്കാതിരിക്കാൻ പാളയത്തിൽനിന്ന് അവരെ പുറത്താക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ഇസ്രായേല്യർ അങ്ങനെ ചെയ്തു; അവർ അവരെ പാളയത്തിനു പുറത്താക്കി. യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെതന്നെ അവർ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ഇസ്രായേല്യരോടു പറയുക: ‘ഒരു പുരുഷനോ സ്ത്രീയോ ഏതിലെങ്കിലും ഒരാളോടു തെറ്റുചെയ്ത് യഹോവയോട് അവിശ്വസ്തരായാൽ ആ വ്യക്തി കുറ്റക്കാരനാണ്; ");
INSERT INTO malc_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ആ മനുഷ്യൻ താൻ ചെയ്ത പാപം ഏറ്റുപറയണം. തന്റെ തെറ്റിന് അയാൾ പൂർണ പ്രായശ്ചിത്തം ചെയ്യണം; മുതലിനോട് അഞ്ചിലൊന്നു കൂട്ടിച്ചേർത്ത്, ആരോടു ദ്രോഹം ചെയ്തോ, അയാൾക്കു കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","എന്നാൽ തെറ്റിനു പ്രായശ്ചിത്തം ചെയ്യാൻ ആ വ്യക്തിക്ക് അടുത്ത ബന്ധുക്കളാരുമില്ലെങ്കിൽ പ്രായശ്ചിത്തം യഹോവയ്ക്കുള്ളതായിരിക്കും, അത് അവന്റെ പാപപരിഹാരത്തിനുള്ള ആട്ടുകൊറ്റനോടൊപ്പം പുരോഹിതനു കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","പുരോഹിതന്റെ മുമ്പിൽ ഇസ്രായേല്യർ കൊണ്ടുവരുന്ന സകലവിശുദ്ധ സംഭാവനകളും അദ്ദേഹത്തിനുള്ളതായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ഓരോരുത്തരുടെയും വിശുദ്ധവഴിപാടുകൾ അർപ്പിക്കുന്ന വ്യക്തിയുടേതുതന്നെയായിരിക്കും; എന്നാൽ ആ വ്യക്തി പുരോഹിതനു നൽകുന്നതെന്തും പുരോഹിതനുള്ളതായിരിക്കും.’ ” ");
INSERT INTO malc_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","പിന്നെ യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ഇസ്രായേല്യരോടു സംസാരിക്കണം. അവരോട് ഇപ്രകാരം പറയുക: ‘ഒരു പുരുഷന്റെ ഭാര്യ പിഴച്ച് അവനോട് അവിശ്വസ്തയായിത്തീരുകയും; ");
INSERT INTO malc_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","പരപുരുഷനുമൊത്ത് അവൾ ലൈംഗികബന്ധത്തിലേർപ്പെടുകയും—അവൾ അശുദ്ധയെങ്കിലും പ്രവൃത്തിയിൽ പിടിക്കപ്പെടാത്തതിനാൽ അവൾക്കെതിരേ സാക്ഷിയില്ലാതിരിക്കുകയും—ഇക്കാര്യം അവളുടെ ഭർത്താവിനു മറഞ്ഞിരിക്കുകയും അവളുടെ അശുദ്ധി കണ്ടുപിടിക്കപ്പെടാതിരിക്കുകയും ");
INSERT INTO malc_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","അവനു സംശയം ജനിക്കുകയും തന്റെ ഭാര്യയെ സംശയത്തോടെ വീക്ഷിക്കുകയും ചെയ്താൽ—അല്ല, അവൾ അശുദ്ധയായിട്ടില്ല എങ്കിലും ഭർത്താവ് അവളെ സംശയിച്ചാൽ— ");
INSERT INTO malc_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","അവൻ തന്റെ ഭാര്യയെ പുരോഹിതന്റെ മുമ്പിൽ കൊണ്ടുചെല്ലണം. അവൾക്കുവേണ്ടി വഴിപാടായി അവൻ ഒരു ഓമെർ യവമാവും കൊണ്ടുചെല്ലണം. അതിന്മേൽ എണ്ണ ഒഴിക്കുകയോ കുന്തിരിക്കം ഇടുകയോ അരുത്, കാരണം അതു സംശയത്തിന്റെ ഭോജനയാഗമാണ്—അപരാധസ്മാരകമായ ഭോജനയാഗംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘പുരോഹിതൻ അവളെ കൊണ്ടുവന്ന് യഹോവയുടെമുമ്പാകെ നിർത്തണം. ");
INSERT INTO malc_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ഒരു മൺപാത്രത്തിൽ വിശുദ്ധജലം എടുത്ത് സമാഗമകൂടാരത്തിന്റെ തറയിൽനിന്നെടുത്ത പൊടി പുരോഹിതൻ ആ വെള്ളത്തിൽ ഇടണം. ");
INSERT INTO malc_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","പുരോഹിതൻ സ്ത്രീയെ യഹോവയുടെ സന്നിധിയിൽ നിർത്തി, അദ്ദേഹം അവളുടെ തല അനാവരണം ചെയ്ത്, അനുസ്മരണയാഗം, സംശയത്തിന്റെ ഭോജനയാഗംതന്നെ, അവളുടെ കൈകളിൽ വെക്കണം. ശാപകരമായ കയ്‌പുവെള്ളം പുരോഹിതൻതന്നെ അദ്ദേഹത്തിന്റെ കൈകളിൽ വഹിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","പിന്നീട് പുരോഹിതൻ സ്ത്രീയെ ശപഥംചെയ്യിച്ചു പറയേണ്ടത്: “നീ നിന്റെ ഭർത്താവുമായി വിവാഹബന്ധത്തിൽ ആയിരിക്കെ, മറ്റൊരു പുരുഷനും നിന്നോടൊത്തു ലൈംഗികബന്ധത്തിലേർപ്പെടുകയോ വഴിപിഴച്ചുപോകുകയോ ചെയ്യാതെ, നീ ശുദ്ധയായിരിക്കുന്നെങ്കിൽ, ശാപകരമായ ഈ കയ്‌പുവെള്ളം നിനക്കു ഹാനി വരുത്താതിരിക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","എന്നാൽ നീ നിന്റെ ഭർത്താവുമായി വിവാഹബന്ധത്തിൽ ആയിരിക്കെ, വഴിപിഴച്ച് നിന്റെ ഭർത്താവല്ലാത്ത അന്യപുരുഷനുമൊത്ത് ലൈംഗികബന്ധത്തിലേർപ്പെട്ട് നിന്നെത്തന്നെ അശുദ്ധയാക്കിയിരിക്കുന്നെങ്കിൽ”— ");
INSERT INTO malc_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ഇവിടെ പുരോഹിതൻ സ്ത്രീയെക്കൊണ്ടു ശപഥംചെയ്യിച്ച് ഇങ്ങനെ പറയണം—“യഹോവ നിന്റെ തുട ക്ഷയിപ്പിച്ചു നിന്റെ ഉദരം വീർപ്പിക്കുമ്പോൾ നിന്റെ ജനം നിന്നെ ശപിക്കാനും ആക്ഷേപിക്കാനും ഇടയാകട്ടെ. ");
INSERT INTO malc_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","നിന്റെ ഉദരം വീർക്കുകയും തുട ക്ഷയിക്കുകയും ചെയ്യത്തക്കവണ്ണം, ശാപത്തിന് ഉതകുന്ന ഈ ജലം നിന്റെ ശരീരത്തിൽ പ്രവേശിക്കട്ടെ.” “ ‘അപ്പോൾ സ്ത്രീ, “ആമേൻ, ആമേൻ” എന്നു പറയണം. ");
INSERT INTO malc_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘പുരോഹിതൻ ഈ ശാപങ്ങളെ ഒരു ചുരുളിൽ എഴുതി അതു കഴുകി കയ്‌പുവെള്ളത്തിലാക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ശാപകരമായ കയ്‌പുവെള്ളം സ്ത്രീയെ കുടിപ്പിക്കണം. ശാപകരമായ ഈ കയ്‌പുവെള്ളം അവളിൽ കടന്ന് കയ്പേറിയതായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","പുരോഹിതൻ അവളുടെ കൈകളിൽനിന്ന് സംശയത്തിന്റെ ഭോജനയാഗം എടുത്ത്, അത് യഹോവയുടെമുമ്പാകെ ഉയർത്തി യാഗപീഠത്തിൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","തുടർന്നു പുരോഹിതൻ ഭോജനയാഗത്തിൽ ഒരുപിടി എടുത്ത് ഒരു സ്മരണാംശമായി യാഗപീഠത്തിൽ ദഹിപ്പിക്കണം; അതിനുശേഷം, അദ്ദേഹം സ്ത്രീയെ ആ വെള്ളം കുടിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","അവൾ തന്നെത്തന്നെ അശുദ്ധയാക്കി തന്റെ ഭർത്താവിനോട് അവിശ്വസ്തയായിരുന്നെങ്കിൽ, ആ ശാപജലം അവളെ കുടിപ്പിക്കുമ്പോൾ, അത് അവളിൽ കടന്ന് കയ്‌പായിത്തീരും; അവളുടെ ഉദരം വീർക്കുകയും തുട ക്ഷയിക്കുകയും ചെയ്യും, അവൾ തന്റെ ജനത്തിനിടയിൽ ശപിക്കപ്പെട്ടവളായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","എന്നാൽ സ്ത്രീ തന്നെത്തന്നെ അശുദ്ധയാക്കാതെയും മാലിന്യം ഒഴിഞ്ഞവളായും ഇരിക്കുന്നെങ്കിൽ, അവൾ കുറ്റവിമുക്തയാകുകയും ഒരു കുഞ്ഞിനു ജന്മംനൽകുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘ഇതാണു പാതിവ്രത്യശങ്ക സംബന്ധിച്ചുള്ള നിയമം. ഒരു ഭർത്താവുമായി വിവാഹബന്ധത്തിലായിരിക്കെ വഴിപിഴച്ച് തന്നെത്താൻ അശുദ്ധയാക്കുകയോ, ");
INSERT INTO malc_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ഒരു പുരുഷൻ തന്റെ ഭാര്യയെ സംശയിക്കുകയോ ചെയ്യുമ്പോഴുള്ള നിയമം ഇതുതന്നെ. പുരോഹിതൻ അവളെ യഹോവയുടെമുമ്പിൽ നിർത്തി, ഈ നിയമങ്ങളെല്ലാം ആ സ്ത്രീയുടെമേൽ നടപ്പിൽവരുത്തണം. ");
INSERT INTO malc_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","എന്നാൽ ഭർത്താവ് അകൃത്യത്തിൽനിന്ന് വിമുക്തനായിരിക്കും, എന്നാൽ സ്ത്രീ തന്റെ അകൃത്യം വഹിക്കണം.’ ” ");
INSERT INTO malc_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","യഹോവ പിന്നെയും മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ഇസ്രായേല്യരോടു സംസാരിക്കുക. അവരോട് ഇപ്രകാരം പറയുക: ‘ഒരു പുരുഷനോ സ്ത്രീയോ വിശേഷാലുള്ള ഒരു വ്രതം—ഒരു നാസീറായി യഹോവയ്ക്കു സ്വയം വേർതിരിക്കുന്നതിനുള്ള ഒരു വ്രതം—അനുഷ്ഠിക്കാൻ ഇച്ഛിക്കുന്നെങ്കിൽ ");
INSERT INTO malc_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","വീഞ്ഞോ മദ്യമോ കുടിക്കരുത്; വീഞ്ഞിൽനിന്നോ മദ്യത്തിൽനിന്നോ ഉണ്ടാക്കിയ വിന്നാഗിരിയും ഉപയോഗിക്കരുത്. മുന്തിരിച്ചാർ കുടിക്കുകയോ പഴുത്തമുന്തിരിങ്ങയോ ഉണക്കമുന്തിരിങ്ങയോ തിന്നുകയോ അരുത്. ");
INSERT INTO malc_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","നാസീർവ്രതം അനുഷ്ഠിക്കുന്ന കാലം മുഴുവനും മുന്തിരിയിൽനിന്നുള്ള യാതൊന്നും, കുരുവോ തൊലിയോപോലും, അവർ ഭക്ഷിച്ചുകൂടാ. ");
INSERT INTO malc_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘നാസീർവ്രതകാലത്ത് ക്ഷൗരക്കത്തി തലയിൽ തൊടരുത്. യഹോവയ്ക്കായി വേർതിരിച്ചിരിക്കുന്ന നാളുകൾ തീരുന്നതുവരെ അവർ വിശുദ്ധരായിരിക്കണം; അവർ തലമുടി വളർത്തണം. ");
INSERT INTO malc_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘യഹോവയ്ക്ക് നാസീർവ്രതസ്ഥരായി വേർതിരിക്കപ്പെട്ട കാലത്ത് അവർ ശവത്തിനരികെ ചെല്ലരുത്. ");
INSERT INTO malc_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","സ്വന്തം പിതാവോ മാതാവോ സഹോദരനോ സഹോദരിയോ മരിച്ചാൽപോലും, അവർനിമിത്തം സ്വയം ആചാരപരമായി അശുദ്ധരാകരുത്. കാരണം ദൈവത്തിനായി വേർതിരിക്കപ്പെട്ടതിന്റെ ചിഹ്നം അവരുടെ ശിരസ്സിന്മേലിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","അവർ പ്രതിഷ്ഠിക്കപ്പെട്ടിരിക്കുന്ന കാലമത്രയും യഹോവയ്ക്കു സമർപ്പിതരാണ്. ");
INSERT INTO malc_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘ആരെങ്കിലും നാസീർവ്രതമുള്ളവരുടെ സാന്നിധ്യത്തിൽ പെട്ടെന്നു മരിക്കുകയും അങ്ങനെ പ്രതിഷ്ഠിക്കപ്പെട്ട തങ്ങളുടെ ശിരസ്സിനെ അശുദ്ധമാക്കുകയും ചെയ്താൽ, അവരുടെ ശുദ്ധീകരണദിവസമായ ഏഴാംദിവസത്തിൽ ശിരസ്സു ക്ഷൗരംചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","പിന്നീട് എട്ടാംദിവസം അവർ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","പുരോഹിതൻ അവയിലൊന്നിനെ പാപശുദ്ധീകരണയാഗമായിട്ടും മറ്റേതിനെ നാസീർവ്രതസ്ഥരായവർക്കുവേണ്ടി പ്രായശ്ചിത്തം വരുത്താൻ ഹോമയാഗമായിട്ടും അർപ്പിക്കണം; കാരണം അവർ ശവംനിമിത്തം കുറ്റക്കാരായി. അന്നുതന്നെ അവർ തങ്ങളുടെ ശിരസ്സു ശുദ്ധീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","പ്രതിഷ്ഠാകാലത്തേക്കായി അവർ യഹോവയ്ക്കു സ്വയം സമർപ്പിക്കയും അകൃത്യയാഗമായി ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാടിനെ കൊണ്ടുവരികയും വേണം. പ്രതിഷ്ഠാകാലത്ത് അശുദ്ധരായിത്തീർന്നതിനാൽ അവരുടെ മുമ്പിലത്തെ വ്രതദിനങ്ങൾ കണക്കിലെടുക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘നാസീർവ്രതസ്ഥർ തങ്ങളുടെ പ്രതിഷ്ഠാകാലം പൂർത്തിയാകുമ്പോഴുള്ള നിയമം ഇതാണ്: അവരെ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","അവിടെ അവർ യഹോവയ്ക്കുള്ള വഴിപാടുകൾ അർപ്പിക്കണം: ഹോമയാഗത്തിനുള്ള ഊനമില്ലാത്ത ഒരുവയസ്സായ ആൺകുഞ്ഞാട്, പാപശുദ്ധീകരണയാഗത്തിനുള്ള ഊനമില്ലാത്ത ഒരുവയസ്സായ പെൺകുഞ്ഞാട്, സമാധാനയാഗത്തിനുള്ള ഊനമില്ലാത്ത ഒരു ആട്ടുകൊറ്റൻ എന്നിവ ");
INSERT INTO malc_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","അവയുടെ ഭോജനയാഗങ്ങളോടും പാനീയയാഗങ്ങളോടും കൂടെയും ഒരു കുട്ട പുളിപ്പിക്കാതെ തയ്യാറാക്കിയ അപ്പം, നേരിയമാവിൽ ഒലിവെണ്ണചേർത്തുണ്ടാക്കിയ വടകൾ, ഒലിവെണ്ണ പുരട്ടിയ അടകൾ എന്നിവയോടുംകൂടെത്തന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘പുരോഹിതൻ അവ യഹോവയുടെ സന്നിധിയിൽ കാഴ്ചവെച്ച് പാപശുദ്ധീകരണയാഗവും ഹോമയാഗവും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","കുട്ടയിലുള്ള പുളിപ്പില്ലാത്ത അപ്പത്തോടുകൂടെ ആട്ടുകൊറ്റനെ സമാധാനയാഗമായി അതിന്റെ ഭോജനയാഗങ്ങളോടും പാനീയയാഗങ്ങളോടുംകൂടെ പുരോഹിതൻ യഹോവയ്ക്ക് അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘ഇതിനുശേഷം സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽവെച്ച്, നാസീർവ്രതസ്ഥർ തങ്ങൾ സമർപ്പിച്ച തലമുടി വടിച്ചുകളയണം. ആ തലമുടി അവർ എടുത്ത് സമാധാനയാഗത്തിന്റെ കീഴിലുള്ള തീയിലിടണം. ");
INSERT INTO malc_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘നാസീർവ്രതസ്ഥർ തങ്ങളുടെ സമർപ്പിക്കപ്പെട്ട തലമുടി വടിച്ചുകളഞ്ഞശേഷം ആട്ടുകൊറ്റന്റെ വേവിച്ച ഒരു കൈക്കുറകും കുട്ടയിൽനിന്നെടുത്ത പുളിപ്പിക്കാത്ത ഒരു വടയും ഒരു അടയും പുരോഹിതൻ അവരുടെ കൈകളിൽ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","പുരോഹിതൻ അവയെ യഹോവയുടെമുമ്പിൽ ഉയർത്തി ഒരു വിശിഷ്ടയാഗമായി അർപ്പിക്കണം; ഉയർത്തി അർപ്പിച്ച നെഞ്ചോടും വിശിഷ്ടയാഗാർപ്പണമായ തുടയും പുരോഹിതനു വിശുദ്ധമായിരിക്കണം. അതിനുശേഷം നാസീർവ്രതസ്ഥർക്കു വീഞ്ഞു കുടിക്കാം. ");
INSERT INTO malc_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘നാസീർവ്രതം അനുഷ്ഠിക്കുന്നവർക്കുള്ള പ്രമാണങ്ങൾ ഇതാണ്. തനിക്കു കൊടുക്കാൻ കഴിവുള്ളതിനുപുറമേ തന്റെ വ്രതം അനുസരിച്ചു യഹോവയ്ക്കു വഴിപാടായി കൊടുക്കേണ്ടവയാണ് ഇവ. നാസീർവ്രതപ്രമാണങ്ങൾക്കനുസൃതമായി തങ്ങൾചെയ്ത പ്രതിജ്ഞ ഓരോരുത്തരും നിറവേറ്റണം.’ ” ");
INSERT INTO malc_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“അഹരോനോടും പുത്രന്മാരോടും നീ പറയുക: ‘ഇസ്രായേൽമക്കളെ നിങ്ങൾ ഇപ്രകാരം അനുഗ്രഹിക്കണം. അവരോടു പറയേണ്ടത്: ");
INSERT INTO malc_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘യഹോവ നിങ്ങളെ അനുഗ്രഹിക്കുകയും കാക്കുകയും ചെയ്യട്ടെ; ");
INSERT INTO malc_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","യഹോവ തിരുമുഖം നിങ്ങളുടെമേൽ പ്രകാശിപ്പിക്കുകയും നിങ്ങളോടു കൃപാലുവായിരിക്കുകയും ചെയ്യട്ടെ; ");
INSERT INTO malc_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","യഹോവ തിരുമുഖം നിങ്ങളിലേക്കു തിരിച്ച് നിങ്ങൾക്കു സമാധാനം നൽകട്ടെ.’ ");
INSERT INTO malc_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“ഇപ്രകാരം അവർ ഇസ്രായേൽമക്കളുടെമേൽ എന്റെ നാമം വെക്കുകയും ഞാൻ അവരെ അനുഗ്രഹിക്കുകയും ചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","മോശ സമാഗമകൂടാരം സ്ഥാപിച്ചശേഷം, അതും അതിന്റെ സകല ഉപകരണങ്ങളും അഭിഷേകംചെയ്തു ശുദ്ധീകരിച്ചു. അദ്ദേഹം യാഗപീഠവും അതിന്റെ സകല ഉപകരണങ്ങളും അഭിഷേകംചെയ്തു ശുദ്ധീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ഇതിനുശേഷം, ഇസ്രായേൽ പ്രഭുക്കന്മാർ, എണ്ണപ്പെട്ടവരുടെ മേൽവിചാരകരായിരുന്ന ഗോത്രപ്രഭുക്കന്മാരായ പിതൃഭവനത്തലവന്മാർതന്നെ, യാഗങ്ങൾ അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","രണ്ടു പ്രഭുക്കന്മാർക്ക് ഒരു വണ്ടിയും ഓരോരുത്തർക്ക് ഓരോ കാളയും എന്ന കണക്കിന് മൂടപ്പെട്ട ആറു വണ്ടികളും പന്ത്രണ്ടു കാളകളും യഹോവയുടെമുമ്പാകെ അവർ കൊണ്ടുവന്ന് സമാഗമകൂടാരത്തിനുമുമ്പിൽ വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“അവരിൽനിന്ന് അവയെ സ്വീകരിക്കുക, സമാഗമകൂടാരത്തിലെ വേലകൾക്ക് അവ ഉപയോഗിക്കാം. ഓരോരുത്തരുടെയും ശുശ്രൂഷയ്ക്ക് ഉപയുക്തമാകുംവണ്ണം അവയെ ലേവ്യർക്കു കൊടുക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","അങ്ങനെ മോശ വണ്ടികളും കാളകളും എടുത്ത് ലേവ്യർക്കു കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","അദ്ദേഹം ഗെർശോന്യർക്ക്, അവരുടെ ശുശ്രൂഷയ്ക്ക് ആവശ്യമായിരുന്നതിൻവണ്ണം രണ്ടു വണ്ടികളും നാല് കാളകളും കൊടുത്തു; ");
INSERT INTO malc_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","അദ്ദേഹം മെരാര്യർക്ക് അവരുടെ ശുശ്രൂഷയ്ക്ക് ആവശ്യമായിരുന്നതിൻവണ്ണം നാലു വണ്ടികളും എട്ട് കാളകളും കൊടുത്തു. അവരെല്ലാവരും പുരോഹിതനായ അഹരോന്റെ പുത്രനായ ഈഥാമാരിന്റെ നേതൃത്വത്തിലായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","എന്നാൽ കെഹാത്യർക്കു മോശ ഒന്നും നൽകിയിട്ടില്ല, കാരണം അവരുടെ ശുശ്രൂഷ വിശുദ്ധമന്ദിരം സംബന്ധിച്ചുള്ളതും വിശുദ്ധവസ്തുക്കൾ തോളിൽ ചുമക്കുന്നതും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","യാഗപീഠം അഭിഷേകം ചെയ്തപ്പോൾ അതിന്റെ പ്രതിഷ്ഠയ്ക്കായി പ്രഭുക്കന്മാർ അവരുടെ വഴിപാടുകൾ കൊണ്ടുവന്ന് അവയെ യാഗപീഠത്തിനുമുമ്പിൽ കാഴ്ചവെച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","“യാഗപീഠത്തിന്റെ പ്രതിഷ്ഠയ്ക്കായി ഓരോ ദിവസവും ഓരോ പ്രഭു തന്റെ വഴിപാട് കൊണ്ടുവരണം,” എന്ന് യഹോവ മോശയോട് അരുളിച്ചെയ്തിരുന്നു. അതുകൊണ്ടാണ് അവർ ഇപ്രകാരം ചെയ്തത്. ");
INSERT INTO malc_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ഒന്നാംദിവസം തന്റെ വഴിപാട് കൊണ്ടുവന്നത് യെഹൂദാഗോത്രത്തിൽ അമ്മീനാദാബിന്റെ മകൻ നഹശോനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം, ");
INSERT INTO malc_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO malc_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു അമ്മീനാദാബിന്റെ മകനായ നഹശോന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","രണ്ടാംദിവസം യിസ്സാഖാറിന്റെ പ്രഭുവായ സൂവാരിന്റെ മകൻ നെഥനയേൽ തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","അദ്ദേഹം കൊണ്ടുവന്ന വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം, ");
INSERT INTO malc_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO malc_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു സൂവാരിന്റെ മകൻ നെഥനയേലിന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","മൂന്നാംദിവസം, സെബൂലൂൻഗോത്രജനങ്ങളുടെ പ്രഭുവായ ഹേലോന്റെ മകൻ എലീയാബ് തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം, ");
INSERT INTO malc_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO malc_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു ഹേലോന്റെ മകൻ എലീയാബിന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","നാലാംദിവസം രൂബേൻഗോത്രജനങ്ങളുടെ പ്രഭുവായ ശെദെയൂരിന്റെ മകൻ എലീസൂർ തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച, ഒരു തങ്കത്താലം, ");
INSERT INTO malc_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO malc_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു ശെദെയൂരിന്റെ മകൻ എലീസൂരിന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","അഞ്ചാംദിവസം ശിമെയോൻഗോത്രജനങ്ങളുടെ പ്രഭുവായ സൂരീശദ്ദായിയുടെ മകൻ ശെലൂമിയേൽ തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം, ");
INSERT INTO malc_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO malc_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു സൂരീശദ്ദായിയുടെ മകൻ ശെലൂമിയേലിന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ആറാംദിവസം ഗാദ്ഗോത്രജനങ്ങളുടെ പ്രഭുവായ ദെയൂവേലിന്റെ മകൻ എലീയാസാഫ് തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം, ");
INSERT INTO malc_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO malc_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു ദെയൂവേലിന്റെ മകൻ എലീയാസാഫിന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ഏഴാംദിവസം എഫ്രയീംഗോത്രജനങ്ങളുടെ പ്രഭുവായ അമ്മീഹൂദിന്റെ മകൻ എലീശാമ തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം, ");
INSERT INTO malc_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO malc_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു അമ്മീഹൂദിന്റെ മകൻ എലീശാമയുടെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","എട്ടാംദിവസം മനശ്ശെഗോത്രജനങ്ങളുടെ പ്രഭുവായ പെദാസൂരിന്റെ മകൻ ഗമാലിയേൽ തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം, ");
INSERT INTO malc_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO malc_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു പെദാസൂരിന്റെ മകൻ ഗമാലിയേലിന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ഒൻപതാംദിവസം ബെന്യാമീൻഗോത്രജനങ്ങളുടെ പ്രഭുവായ ഗിദെയോനിയുടെ മകനായ അബീദാൻ തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം; ");
INSERT INTO malc_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ; ");
INSERT INTO malc_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു ഗിദെയോനിയുടെ മകനായ അബീദാന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","പത്താംദിവസം ദാൻഗോത്രജനങ്ങളുടെ പ്രഭുവായ അമ്മീശദ്ദായിയുടെ മകനായ അഹീയേസെർ തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം; ");
INSERT INTO malc_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ; ");
INSERT INTO malc_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു അമ്മീശദ്ദായിയുടെ മകൻ അഹീയേസെരിന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","പതിനൊന്നാംദിവസം ആശേർഗോത്രജനങ്ങളുടെ പ്രഭുവായ ഒക്രാന്റെ മകൻ പഗീയേൽ തന്റെ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം; ");
INSERT INTO malc_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ; ");
INSERT INTO malc_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു ഒക്രാന്റെ മകൻ പഗീയേലിന്റെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","പന്ത്രണ്ടാംദിവസം നഫ്താലിഗോത്രജനങ്ങളുടെ പ്രഭുവായ ഏനാന്റെ മകൻ അഹീരാ വഴിപാട് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","അദ്ദേഹത്തിന്റെ വഴിപാട്: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കേൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം—ഇവ രണ്ടിലും ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത നേരിയമാവ് നിറച്ചിരുന്നു— ");
INSERT INTO malc_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","പത്തുശേക്കേൽ തൂക്കമുള്ള, സുഗന്ധധൂപവർഗം നിറച്ച ഒരു തങ്കത്താലം; ");
INSERT INTO malc_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ഹോമയാഗത്തിനായി ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാട്; ");
INSERT INTO malc_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","പാപശുദ്ധീകരണയാഗത്തിനായി ഒരു കോലാട്ടുകൊറ്റൻ; ");
INSERT INTO malc_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","സമാധാനയാഗത്തിനായി രണ്ടുകാള, അഞ്ച് ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള അഞ്ച് ആൺകുഞ്ഞാട്. ഇതായിരുന്നു ഏനാന്റെ മകൻ അഹീരായുടെ വഴിപാട്. ");
INSERT INTO malc_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","യാഗപീഠം അഭിഷേകംചെയ്ത അവസരത്തിൽ അതിന്റെ പ്രതിഷ്ഠയ്ക്കുവേണ്ടി ഇസ്രായേൽ പ്രഭുക്കന്മാർ അർപ്പിക്കേണ്ട വഴിപാടുകൾ ഇവയായിരുന്നു: പന്ത്രണ്ടു വെള്ളിത്തളികകൾ, പന്ത്രണ്ടു വെള്ളിക്കിണ്ണങ്ങൾ, പന്ത്രണ്ടു തങ്കത്താലങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ഓരോ വെള്ളിത്തളികയും നൂറ്റിമുപ്പത് ശേക്കേൽവീതവും ഓരോ വെള്ളിക്കിണ്ണവും എഴുപത് ശേക്കേൽവീതവും തൂക്കമുള്ളവയായിരുന്നു. വെള്ളിപ്പാത്രങ്ങൾക്ക് ആകെ വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം രണ്ടായിരത്തിനാനൂറു ശേക്കേൽ തൂക്കം ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","സുഗന്ധധൂപവർഗം നിറച്ച തങ്കത്താലങ്ങൾ ഓരോന്നിനും വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം പത്തുശേക്കേൽ വീതം തൂക്കം ഉണ്ടായിരുന്നു. തങ്കപ്പാത്രങ്ങൾക്ക് ആകെ നൂറ്റി ഇരുപത് ശേക്കേൽ തൂക്കം ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ഹോമയാഗത്തിനുള്ള മൃഗങ്ങൾ ആകെ: കാളക്കിടാവ് പന്ത്രണ്ട്, ആട്ടുകൊറ്റൻ പന്ത്രണ്ട്, ഒരുവയസ്സു പ്രായമുള്ള ആൺകുഞ്ഞാട് പന്ത്രണ്ട്; അവയുടെ ഭോജനയാഗം; പാപശുദ്ധീകരണയാഗത്തിനായി പന്ത്രണ്ടു കോലാട്ടുകൊറ്റൻ. ");
INSERT INTO malc_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","സമാധാനയാഗത്തിനുള്ള മൃഗങ്ങൾ ആകെ: കാള ഇരുപത്തിനാല്, ആട്ടുകൊറ്റൻ അറുപത്, കോലാട്ടുകൊറ്റൻ അറുപത്, ഒരുവയസ്സു പ്രായമുള്ള ആൺകുഞ്ഞാട് അറുപത്. യാഗപീഠം അഭിഷേകം ചെയ്തശേഷം അതിന്റെ പ്രതിഷ്ഠയ്ക്കുള്ള വഴിപാടുകൾ ഇവയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","മോശ യഹോവയുമായി സംസാരിക്കാൻ സമാഗമകൂടാരത്തിൽ പ്രവേശിച്ചപ്പോൾ, ഉടമ്പടിയുടെ പേടകത്തിന്മേലുള്ള പാപനിവാരണസ്ഥാനത്തിനു മുകളിലായി രണ്ടു കെരൂബുകളുടെ മധ്യത്തിൽനിന്ന് തന്നോടു സംസാരിക്കുന്ന ശബ്ദം കേട്ടു. അങ്ങനെ യഹോവ അദ്ദേഹവുമായി സംസാരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“അഹരോനോട് സംസാരിക്കുക. അദ്ദേഹത്തോട് ഇപ്രകാരം പറയുക: ‘നീ വിളക്കു കൊളുത്തുമ്പോൾ അവ ഏഴും വിളക്കുതണ്ടിന്റെ മുൻഭാഗത്തേക്കു വെളിച്ചം കൊടുക്കുന്ന നിലയിൽ ആയിരിക്കണം.’ ” ");
INSERT INTO malc_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","അഹരോൻ അങ്ങനെ ചെയ്തു; യഹോവ മോശയോടു കൽപ്പിച്ചിരുന്നതുപോലെതന്നെ അദ്ദേഹം വിളക്കുതണ്ടിന്റെ മുൻവശത്തു വെളിച്ചംകിട്ടത്തക്കവണ്ണം വിളക്കുകൾ വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","വിളക്കുതണ്ടുകൾ നിർമിച്ചത് ഇപ്രകാരമായിരുന്നു: അതിന്റെ ചുവടുമുതൽ പുഷ്പപുടംവരെ അടിച്ചുപരത്തിയ തങ്കംകൊണ്ടായിരുന്നു. മോശയ്ക്ക് യഹോവ കാണിച്ചുകൊടുത്ത മാതൃകപ്രകാരംതന്നെ വിളക്കുതണ്ട് നിർമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ഇസ്രായേല്യരുടെ ഇടയിൽനിന്ന് ലേവ്യരെ വേർതിരിച്ച് അവരെ ആചാരപരമായി ശുദ്ധീകരിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","അവരെ ഇപ്രകാരം വിശുദ്ധീകരിക്കുക: ശുദ്ധീകരണജലം അവരുടെമേൽ തളിക്കുക; തുടർന്ന് ശരീരംമുഴുവൻ ക്ഷൗരംചെയ്ത് വസ്ത്രം അലക്കി അവർ തങ്ങളെത്തന്നെ ശുദ്ധീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","അവർ ഒരു കാളക്കിടാവിനെ അതിന്റെ ഭോജനയാഗത്തിനുള്ള ഒലിവെണ്ണചേർത്ത് നേരിയമാവോടുകൂടി എടുക്കണം; തുടർന്നു പാപശുദ്ധീകരണയാഗത്തിനായി മറ്റൊരു കാളക്കിടാവിനെ നീയും എടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ഇതിനുശേഷം മുഴുവൻ ഇസ്രായേൽസഭയെ കൂട്ടിവരുത്തുകയും ലേവ്യരെ സമാഗമകൂടാരത്തിനു മുമ്പിലേക്ക് കൊണ്ടുവരികയും വേണം. ");
INSERT INTO malc_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ലേവ്യരെ നീ യഹോവയുടെമുമ്പാകെ കൊണ്ടുവരണം; ഇസ്രായേൽമക്കൾ അവരുടെമേൽ കൈവെക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","അഹരോൻ തന്റെ കൈ ഉയർത്തി ലേവ്യരെ, അവർ യഹോവയുടെ വേലചെയ്യാൻ ഒരുക്കമായിരിക്കേണ്ടതിന്, ഇസ്രായേല്യരുടെ ഇടയിൽനിന്ന് ഒരു വിശിഷ്ടയാഗാർപ്പണമായി യഹോവയുടെമുമ്പാകെ സമർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“ലേവ്യർ കാളകളുടെ തലമേൽ കൈവെച്ചശേഷം, ഒന്നിനെ യഹോവയ്ക്കു പാപശുദ്ധീകരണയാഗത്തിനായും മറ്റേതിനെ ലേവ്യർക്കു പ്രായശ്ചിത്തത്തിനുള്ള ഹോമയാഗത്തിനായും ഉപയോഗിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ലേവ്യരെ അഹരോന്റെയും അദ്ദേഹത്തിന്റെ പുത്രന്മാരുടെയും മുമ്പിൽ നിർത്തി നിങ്ങളുടെ കൈകൾ ഉയർത്തി അവരെ യഹോവയ്ക്ക് ഒരു വിശിഷ്ടയാഗമായി അർപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ഇപ്രകാരമാണ് നിങ്ങൾ ലേവ്യരെ മറ്റ് ഇസ്രായേൽമക്കളിൽനിന്നും വേർതിരിക്കേണ്ടത്. ലേവ്യർ എനിക്കുള്ളവർ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“ലേവ്യരെ നിങ്ങൾ ശുദ്ധീകരിക്കുകയും നിങ്ങളുടെ കൈകൾ ഉയർത്തി വിശിഷ്ടയാഗാർപ്പണമായി സമർപ്പിക്കയും ചെയ്തശേഷം അവർക്കു തങ്ങളുടെ ശുശ്രൂഷചെയ്യാൻ സമാഗമകൂടാരത്തിലേക്കു പ്രവേശിക്കാം. ");
INSERT INTO malc_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ഇസ്രായേൽമക്കളിൽനിന്ന് ലേവ്യരെ എനിക്കു പൂർണമായി നൽകിയിരിക്കുന്നു. എല്ലാ ഇസ്രായേല്യരിലുമുള്ള ആദ്യജാതന്മാർക്കു പകരം—സകല ഇസ്രായേല്യസ്ത്രീകളുടെയും ആദ്യജാതനു പകരംതന്നെ—അവരെ ഞാൻ എനിക്കായി എടുത്തിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","മനുഷ്യനാകട്ടെ, മൃഗമാകട്ടെ, ഇസ്രായേലിലുള്ള കടിഞ്ഞൂലെല്ലാം എനിക്കുള്ളതാണ്. ഈജിപ്റ്റിലുള്ള സകല ആദ്യജാതന്മാരെയും ഞാൻ സംഹരിച്ചപ്പോൾ, ഞാൻ അവരെ എനിക്കായി വേർതിരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ഇസ്രായേലിലെ സകല ആദ്യജാതന്മാർക്കും പകരമായി ലേവ്യരെ ഞാൻ എടുത്തിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ഇസ്രായേല്യർക്കുവേണ്ടി സമാഗമകൂടാരത്തിൽ വേലചെയ്യാനായും അവർ വിശുദ്ധമന്ദിരത്തോടടുക്കുമ്പോൾ യാതൊരു ബാധയും അവരുടെമേൽ വരാതിരിക്കാൻ അവർക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യാനായും ലേവ്യരെ ഞാൻ അഹരോനും അദ്ദേഹത്തിന്റെ പുത്രന്മാർക്കും ദാനം ചെയ്തിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ലേവ്യരെക്കുറിച്ചു യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെതന്നെ, മോശയും അഹരോനും ഇസ്രായേൽസഭ മുഴുവനും ലേവ്യർക്കു ചെയ്തുകൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ലേവ്യർ തങ്ങളെത്തന്നെ ശുദ്ധീകരിക്കുകയും തങ്ങളുടെ വസ്ത്രങ്ങൾ അലക്കുകയും ചെയ്തു. തുടർന്ന് അഹരോൻ തന്റെ കൈകൾ ഉയർത്തി അവരെ ഒരു വിശിഷ്ടയാഗാർപ്പണമായി യഹോവയുടെമുമ്പാകെ സമർപ്പിക്കുകയും അവരെ ശുദ്ധീകരിക്കാനായി പ്രായശ്ചിത്തം കഴിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","അതിനുശേഷം ലേവ്യർ അഹരോന്റെയും അദ്ദേഹത്തിന്റെ പുത്രന്മാരുടെയും മേൽനോട്ടത്തിനു കീഴിൽ സമാഗമകൂടാരത്തിലെ തങ്ങളുടെ വേല ചെയ്യുന്നതിനായി വന്നു. യഹോവ മോശയോടു കൽപ്പിച്ചിരുന്നതുപോലെതന്നെ അവർ ലേവ്യരെ യഹോവയ്ക്കായി വേർതിരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ലേവ്യർക്കുള്ള നിയമമാണിത്: ഇരുപത്തഞ്ചോ അതിലധികമോ വയസ്സ് പ്രായമുള്ള പുരുഷന്മാർ സമാഗമകൂടാരത്തിലെ ശുശ്രൂഷയിൽ പങ്കാളിത്തം വഹിക്കാൻ വരണം. ");
INSERT INTO malc_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","എന്നാൽ അൻപതാം വയസ്സിൽ, അവർ തങ്ങളുടെ പതിവായ ശുശ്രൂഷയിൽനിന്ന് വിരമിക്കുകയും തുടർന്ന് വേലചെയ്യാതിരിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","അവർക്കു തങ്ങളുടെ സഹോദരന്മാരെ സമാഗമകൂടാരത്തിലെ അവരുടെ കർത്തവ്യം നിർവഹിക്കുന്നതിൽ സഹായിക്കാം. പക്ഷേ, അവർ നേരിട്ടു ചുമതല വഹിക്കരുത്. ഇപ്രകാരമാണ് നിങ്ങൾ ലേവ്യർക്ക് ഉത്തരവാദിത്വങ്ങൾ ഏൽപ്പിച്ചുകൊടുക്കേണ്ടത്.” ");
INSERT INTO malc_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","അവർ ഈജിപ്റ്റിൽനിന്നും പുറത്തു വന്നശേഷം രണ്ടാംവർഷം ഒന്നാംമാസം യഹോവ സീനായിമരുഭൂമിയിൽവെച്ച് മോശയോട് അരുളിച്ചെയ്തു. അവിടന്നു കൽപ്പിച്ചത്: ");
INSERT INTO malc_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ഇസ്രായേൽജനം അതിന്റെ നിശ്ചിതസമയത്തു പെസഹ ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","അതിന്റെ നിശ്ചിതസമയമായ ഈമാസം പതിന്നാലാംതീയതി സന്ധ്യാസമയത്ത്, അതിന്റെ സകലനിയമങ്ങൾക്കും ചട്ടങ്ങൾക്കും ഒത്തവണ്ണം അത് ആചരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","അങ്ങനെ മോശ ഇസ്രായേല്യരോട് പെസഹ ആചരിക്കാൻ പറഞ്ഞു, ");
INSERT INTO malc_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ഒന്നാംമാസം പതിന്നാലാംതീയതി സന്ധ്യാസമയത്ത് സീനായിമരുഭൂമിയിൽവെച്ച് അവർ പെസഹ ആചരിച്ചു. യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെതന്നെ ഇസ്രായേല്യർ സകലതും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","എന്നാൽ അവരിൽ ചിലർക്ക്, തങ്ങൾ ശവത്താൽ, ആചാരപരമായി അശുദ്ധരായിരുന്നതിനാൽ ആ ദിവസം പെസഹ ആചരിക്കാൻ കഴിഞ്ഞില്ല. അതുകൊണ്ട് അവർ ആ ദിവസംതന്നെ മോശയുടെയും അഹരോന്റെയും അടുക്കൽവന്ന്, ");
INSERT INTO malc_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","മോശയോടു പറഞ്ഞു: “ഒരു ശവത്താൽ ഞങ്ങൾ അശുദ്ധരായിത്തീർന്നു, പക്ഷേ, മറ്റ് ഇസ്രായേല്യരോടൊപ്പം നിശ്ചിതസമയത്തുതന്നെ യഹോവയ്ക്കു വഴിപാട് അർപ്പിക്കുന്നതിൽനിന്ന് ഞങ്ങളെ ഒഴിവാക്കുന്നതെന്ത്?” ");
INSERT INTO malc_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","മോശ അവരോടു പറഞ്ഞു: “യഹോവ നിങ്ങളെക്കുറിച്ച് എന്തു കൽപ്പിക്കുന്നു എന്നു ഞാൻ കണ്ടെത്തുംവരെ നിങ്ങൾ കാത്തുനിൽക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","അപ്പോൾ യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ഇസ്രായേൽമക്കളോടു പറയുക: ‘നിങ്ങളിലോ നിങ്ങളുടെ സന്തതിയിലോ ആരെങ്കിലും ശവത്താൽ അശുദ്ധരായിരിക്കുകയോ ദൂരയാത്രയിലായിരിക്കുകയോ ചെയ്താൽ, അവർക്കും യഹോവയുടെ പെസഹ ആചരിക്കാം. ");
INSERT INTO malc_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","അവർ അത് രണ്ടാംമാസത്തിന്റെ പതിന്നാലാംതീയതി സന്ധ്യാസമയത്ത് ആചരിക്കണം. അവർ ആട്ടിൻകുട്ടിയെ പുളിപ്പില്ലാത്ത അപ്പത്തോടും കയ്‌പുചീരയോടുംകൂടെ ഭക്ഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","അവർ അതിൽ യാതൊന്നും പ്രഭാതംവരെ ശേഷിപ്പിക്കരുത്; അതിന്റെ അസ്ഥികളൊന്നും ഒടിക്കുകയും ചെയ്യരുത്. അവർ പെസഹാ ആചരിക്കുമ്പോൾ അതിന്റെ സകലചട്ടങ്ങളും അനുസരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","എന്നാൽ ആരെങ്കിലും ആചാരപരമായി ശുദ്ധമായിരിക്കുകയും യാത്രയിലല്ലാതിരിക്കുകയും ചെയ്തിട്ടും പെസഹ ആചരിക്കാതിരുന്നാൽ, ആ മനുഷ്യനെ സ്വജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. കാരണം അയാൾ നിശ്ചിതസമയത്ത് യഹോവയ്ക്കു വഴിപാട് അർപ്പിച്ചില്ല. അങ്ങനെയുള്ളവർ തങ്ങളുടെ പാപത്തിന്റെ ശിക്ഷ അനുഭവിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന ഒരു പ്രവാസിക്കു യഹോവയുടെ പെസഹ ആചരിക്കണമെങ്കിൽ അയാൾ അതു ചട്ടങ്ങൾക്കും നിയമങ്ങൾക്കും വിധേയമായി ആചരിക്കണം. പ്രവാസിക്കും സ്വദേശിക്കും ഒരേ നിയമം ആയിരിക്കണം.’ ” ");
INSERT INTO malc_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","സമാഗമകൂടാരം ഉയർത്തിയ നാളിൽ മേഘം ഉടമ്പടിയുടെ കൂടാരമായ സമാഗമകൂടാരത്തെ മൂടി. സന്ധ്യമുതൽ പ്രഭാതംവരെ സമാഗമകൂടാരത്തിന്മേലുള്ള മേഘം കാഴ്ചയ്ക്ക് അഗ്നിസമാനമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","—അത് എപ്പോഴും അപ്രകാരമായിരുന്നു—രാത്രിയിൽ മേഘം അതിനെ മൂടി, അത് അഗ്നിപോലെ കാണപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","കൂടാരത്തിനു മുകളിൽനിന്ന് മേഘം ഉയരുമ്പോഴൊക്കെയും ഇസ്രായേല്യർ യാത്രപുറപ്പെടും; മേഘം നിൽക്കുന്നിടത്തൊക്കെയും അവർ പാളയമടിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","യഹോവയുടെ കൽപ്പനപ്രകാരം ഇസ്രായേല്യർ യാത്രപുറപ്പെടുകയും അവിടത്തെ കൽപ്പനപ്രകാരം അവർ പാളയമടിക്കുകയും ചെയ്തു. മേഘം സമാഗമകൂടാരത്തിനുമുകളിൽ നിൽക്കുന്നത്രയുംകാലം അവർ പാളയത്തിൽ വസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","മേഘം ദീർഘകാലം സമാഗമകൂടാരത്തിന്മേൽ നിലകൊണ്ടപ്പോൾ, ഇസ്രായേല്യർ യാത്രപുറപ്പെടാതെ യഹോവയുടെ കൽപ്പനകൾ അനുസരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ചില അവസരങ്ങളിൽ കുറച്ചു ദിവസങ്ങളിലേക്കുമാത്രമേ മേഘം സമാഗമകൂടാരത്തിനു മുകളിലുണ്ടായിരുന്നുള്ളൂ; യഹോവയുടെ കൽപ്പനപ്രകാരം അവർ പാളയത്തിൽ കഴിയുകയും യഹോവയുടെ കൽപ്പനപ്രകാരം അവർ യാത്രപുറപ്പെടുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ചില അവസരങ്ങളിൽ സന്ധ്യമുതൽ പ്രഭാതംവരെമാത്രം മേഘം നിശ്ചലമായിരിക്കും. പ്രഭാതത്തിൽ അത് ഉയരുമ്പോൾ, അവർ യാത്രപുറപ്പെടും. പകലോ രാത്രിയോ എപ്പോൾ മേഘം പൊങ്ങുമോ അപ്പോൾ അവർ യാത്രപുറപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","സമാഗമകൂടാരത്തിന്മേൽ മേഘം രണ്ടുദിവസത്തേക്കോ ഒരു മാസത്തേക്കോ ഒരു വർഷത്തേക്കോ നിലയുറപ്പിച്ചാൽ, ഇസ്രായേല്യർ യാത്രപുറപ്പെടാതെ പാളയത്തിൽതന്നെ പാർക്കും; എന്നാൽ അത് ഉയരുമ്പോൾ അവർ യാത്രപുറപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","യഹോവയുടെ കൽപ്പനപ്രകാരം അവർ പാളയമടിക്കുകയും യഹോവയുടെ കൽപ്പനപ്രകാരം അവർ പുറപ്പെടുകയും ചെയ്യും. മോശമുഖാന്തരം ഉള്ള കൽപ്പനകൾക്കനുസൃതമായി അവർ യഹോവയുടെ ആജ്ഞ അനുസരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","യഹോവ വീണ്ടും മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“വെള്ളികൊണ്ട് അടിപ്പുപണിയായി രണ്ടു കാഹളങ്ങൾ ഉണ്ടാക്കുക; അവ സമൂഹത്തെ വിളിച്ചുകൂട്ടാനും പാളയത്തെ പുറപ്പെടുവിക്കാനും ഉപയോഗിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","അവ ഊതുമ്പോൾ സഭമുഴുവനും സമാഗമകൂടാരവാതിൽക്കൽ നിന്റെ മുമ്പിൽ കൂടിവരണം. ");
INSERT INTO malc_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ഒരു കാഹളംമാത്രമാണ് ഊതുന്നതെങ്കിൽ, ഇസ്രായേൽഗോത്രങ്ങളുടെ തലവന്മാരായ പ്രഭുക്കന്മാർ നിന്റെ മുമ്പാകെ കൂടിവരണം. ");
INSERT INTO malc_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","കാഹളധ്വനി ഒരിക്കൽ മുഴക്കിയാൽ, കിഴക്കുഭാഗത്തു പാളയമടിച്ച ഗോത്രങ്ങൾ യാത്രപുറപ്പെടണം. ");
INSERT INTO malc_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","രണ്ടാമത്തെ കാഹളധ്വനി മുഴക്കുമ്പോൾ തെക്കുഭാഗത്തുള്ള പാളയങ്ങൾ യാത്രപുറപ്പെടണം. ഇപ്രകാരം കാഹളധ്വനി മുഴക്കുന്നത് പുറപ്പാടിനുള്ള ചിഹ്നമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","സഭയെ വിളിച്ചുകൂട്ടാൻ കാഹളംമുഴക്കുമ്പോൾ, യാത്രപുറപ്പെടാനുള്ള കാഹളധ്വനി മുഴക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാരാണ് കാഹളം മുഴക്കേണ്ടത്. ഇതു നിങ്ങൾക്കും വരാനുള്ള തലമുറകൾക്കും എന്നേക്കുമുള്ള നിയമം ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","നിങ്ങളുടെ സ്വന്തം ദേശത്തു നിങ്ങളെ ഞെരുക്കുന്ന ഒരു ശത്രുവിനോടു നിങ്ങൾ യുദ്ധത്തിനുപോകുമ്പോൾ, കാഹളങ്ങൾ മുഴക്കി മുന്നറിയിപ്പുനൽകണം. അപ്പോൾ നിങ്ങളുടെ ദൈവമായ യഹോവ നിങ്ങളെ ഓർക്കുകയും നിങ്ങൾ ശത്രുക്കളിൽനിന്ന് വിടുവിക്കപ്പെടുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","നിങ്ങൾക്ക് ആനന്ദമുണ്ടാകുന്ന അവസരങ്ങളിൽ, ഉത്സവങ്ങളിലും മാസാരംഭങ്ങളിലും, ഹോമയാഗങ്ങളും സമാധാനയാഗങ്ങളും അർപ്പിക്കുമ്പോഴും നിങ്ങൾ കാഹളങ്ങൾ ഊതണം. അവ നിങ്ങളുടെ ദൈവത്തിന്റെ മുമ്പിൽ നിങ്ങൾക്ക് ഒരു സ്മാരകം ആയിരിക്കും. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","രണ്ടാംവർഷം രണ്ടാംമാസം ഇരുപതാംതീയതി മേഘം ഉടമ്പടിയുടെ കൂടാരത്തിൽനിന്ന് ഉയർന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","അങ്ങനെ ഇസ്രായേല്യർ സീനായിമരുഭൂമിയിൽനിന്ന് പുറപ്പെട്ടു; മേഘം പാരാൻ മരുഭൂമിയിൽ നിൽക്കുന്നതുവരെ അവർ പല സ്ഥലങ്ങളിലൂടെ സഞ്ചരിച്ചുകൊണ്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","മോശയിൽക്കൂടെ യഹോവ കൽപ്പിച്ചപ്രകാരം അവർ പുറപ്പെടുന്നത് ഇതാദ്യമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","യെഹൂദാപാളയത്തിലെ ഗണങ്ങൾ തങ്ങളുടെ കൊടിക്കീഴിൽ ആദ്യം പുറപ്പെട്ടു. അമ്മീനാദാബിന്റെ മകൻ നഹശോൻ അവരുടെ സൈന്യാധിപനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","അപ്രകാരംതന്നെ, സൂവാരിന്റെ മകൻ നെഥനയേൽ യിസ്സാഖാർ ഗോത്രഗണത്തിന്മേലും ");
INSERT INTO malc_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ഹേലോന്റെ മകൻ എലീയാബ് സെബൂലൂൻ ഗോത്രഗണത്തിന്മേലും നിയമിക്കപ്പെട്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ഇതിനുശേഷം സമാഗമകൂടാരം അഴിച്ചു താഴ്ത്തി; അതു വഹിച്ച് ഗെർശോന്യരും മെരാര്യരും യാത്രപുറപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","രൂബേൻതാവളത്തിലെ ഗണങ്ങൾ തങ്ങളുടെ കൊടിക്കീഴിൽ അടുത്തതായി പുറപ്പെട്ടു. ശെദെയൂരിന്റെ മകൻ എലീസൂർ അവരുടെ സൈന്യാധിപനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","സൂരീശദ്ദായിയുടെ മകൻ ശെലൂമിയേൽ ശിമെയോൻ ഗോത്രഗണത്തിന്മേലും ");
INSERT INTO malc_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ദെയൂവേലിന്റെ മകൻ എലീയാസാഫ് ഗാദ്ഗോത്രഗണത്തിന്മേലും നിയമിക്കപ്പെട്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","തുടർന്ന് കെഹാത്യർ വിശുദ്ധവസ്തുക്കളെ വഹിച്ചുകൊണ്ട് യാത്രപുറപ്പെട്ടു. അവർ അടുത്ത പാളയത്തിൽ ചെന്നുചേരുന്നതിനുമുമ്പുതന്നെ സമാഗമകൂടാരം സ്ഥാപിക്കപ്പെടേണ്ടതുണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","എഫ്രയീം പാളയത്തിലെ ഗണങ്ങൾ തങ്ങളുടെ കൊടിക്കീഴിൽ അടുത്തതായി പുറപ്പെട്ടു. അമ്മീഹൂദിന്റെ മകൻ എലീശാമ അവരുടെ സൈന്യാധിപനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","പെദാസൂരിന്റെ മകൻ ഗമാലിയേൽ മനശ്ശെഗോത്രഗണത്തിന്മേലും ");
INSERT INTO malc_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ഗിദെയോനിയുടെ മകൻ അബീദാൻ ബെന്യാമീൻഗോത്രഗണത്തിന്മേലും നിയമിക്കപ്പെട്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ഒടുവിൽ, എല്ലാ ഗണങ്ങൾക്കും പിൻപടയായി ദാൻതാവളത്തിലെ ഗണങ്ങൾ തങ്ങളുടെ കൊടിക്കീഴിൽ യാത്രപുറപ്പെട്ടു. അമ്മീശദ്ദായിയുടെ മകൻ അഹീയേസെർ അവരുടെ സൈന്യാധിപനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ഒക്രാന്റെ മകൻ പഗീയേൽ ആശേർഗോത്രഗണത്തിന്മേലും ");
INSERT INTO malc_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ഏനാന്റെ മകൻ അഹീരാ നഫ്താലിഗോത്രഗണത്തിന്മേലും നിയമിക്കപ്പെട്ടിരുന്നു, ");
INSERT INTO malc_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ഇസ്രായേല്യഗോത്രങ്ങൾ യാത്രപുറപ്പെട്ടപ്പോൾ അവരുടെ അണിനീക്കത്തിന്റെ ക്രമം ഇതായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","മോശ തന്റെ അമ്മായിയപ്പനായ രെയൂവേൽ എന്ന മിദ്യാന്റെ പുത്രനായ ഹോബാബിനോടു പറഞ്ഞു: “ ‘ഞാൻ നിങ്ങൾക്കു തരും’ എന്ന് യഹോവ പറഞ്ഞ ദേശത്തേക്കു ഞങ്ങൾ പുറപ്പെടുകയാണ്. ഞങ്ങളോടൊപ്പം വരിക, ഞങ്ങൾ താങ്കൾക്കു നന്മ ചെയ്യും. കാരണം, യഹോവ ഇസ്രായേലിനു നന്മ വാഗ്ദാനംചെയ്തിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","അദ്ദേഹം പ്രതിവചിച്ചു: “ഇല്ല, ഞാൻ വരികയില്ല; ഞാൻ എന്റെ സ്വന്തം ദേശത്തേക്കും സ്വന്തജനങ്ങളുടെ ഇടയിലേക്കും പോകുകയാണ്.” ");
INSERT INTO malc_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","എന്നാൽ മോശ പറഞ്ഞു: “ദയവായി ഞങ്ങളെ പിരിയരുതേ! മരുഭൂമിയിൽ ഞങ്ങൾ എങ്ങനെ പാളയമടിക്കണം എന്നു താങ്കൾക്കറിയാം, താങ്കൾ ഞങ്ങൾക്കു കണ്ണുകളായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","താങ്കൾ ഞങ്ങളോടൊപ്പം വന്നാൽ, യഹോവ ഞങ്ങൾക്കു നൽകുന്ന സകലനന്മയിലും താങ്കൾക്കു ഞങ്ങൾ ഓഹരി നൽകും.” ");
INSERT INTO malc_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","അങ്ങനെ അവർ യഹോവയുടെ പർവതത്തിൽനിന്ന് യാത്രപുറപ്പെട്ട് മൂന്നുദിവസം സഞ്ചരിച്ചു. അവർക്കൊരു വിശ്രമസ്ഥലം കണ്ടെത്താൻ ആ മൂന്നു ദിവസങ്ങളിൽ യഹോവയുടെ ഉടമ്പടിയുടെ പേടകം അവർക്കുമുമ്പായി പോയി. ");
INSERT INTO malc_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","അവർ പാളയത്തിൽനിന്ന് യാത്രപുറപ്പെട്ടപ്പോൾ പകൽസമയത്തു യഹോവയുടെ മേഘം അവരുടെമീതേ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","പേടകം പുറപ്പെട്ടപ്പോഴൊക്കെയും മോശ പറഞ്ഞു: “യഹോവേ, എഴുന്നേൽക്കണേ! അങ്ങയുടെ ശത്രുക്കൾ ചിതറിപ്പോകട്ടെ; അങ്ങയുടെ വൈരികൾ തിരുമുമ്പിൽനിന്ന് ഓടിപ്പോകട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","അതു നിൽക്കുമ്പോഴൊക്കെയും അദ്ദേഹം പറഞ്ഞു: “യഹോവേ, ഇസ്രായേലിന്റെ എണ്ണിക്കൂടാത്ത ആയിരങ്ങളിലേക്കു മടങ്ങിവരണമേ.” ");
INSERT INTO malc_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ഇതിനുശേഷം, യഹോവ കേൾക്കെ ജനം തങ്ങളുടെ കഷ്ടപ്പാടുകളെക്കുറിച്ചു പിറുപിറുത്തു, അതു കേട്ടപ്പോൾ അവിടത്തെ കോപം ജ്വലിച്ചു. അപ്പോൾ യഹോവയിൽനിന്നുള്ള അഗ്നി അവരുടെ ഇടയിൽ കത്തി പാളയത്തിന്റെ അതിർത്തിയിലുള്ളവരെ ദഹിപ്പിച്ചുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ഉടനെതന്നെ ജനം മോശയോടു നിലവിളിച്ചു; അദ്ദേഹം യഹോവയോടു പ്രാർഥിച്ചു, അഗ്നി കെട്ടടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","യഹോവയിൽനിന്നുള്ള അഗ്നി അവരുടെ ഇടയിൽ കത്തിയതിനാൽ ആ സ്ഥലത്തിനു തബേരാ എന്നു പേരായി. ");
INSERT INTO malc_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","അവരുടെ ഇടയിലുള്ള സമ്മിശ്രപുരുഷാരം മറ്റു ഭക്ഷണത്തിനായി കൊതിച്ചു; ഇസ്രായേൽമക്കളും തിരിഞ്ഞ് അവരോടൊപ്പം മുറവിളികൂട്ടി: “ഞങ്ങൾക്കു ഭക്ഷിക്കാൻ മാംസം ആർ തരും? ");
INSERT INTO malc_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ഈജിപ്റ്റിൽവെച്ചു വിലകൊടുക്കാതെ തിന്നിട്ടുള്ള മത്സ്യവും, വെള്ളരി, മത്തങ്ങ, ഉള്ളി, ചെമന്നുള്ളി, വെളുത്തുള്ളി എന്നിവയും ഞങ്ങൾ ഓർക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","എന്നാൽ ഇപ്പോഴാകട്ടെ, ഞങ്ങളുടെ ഭക്ഷണത്തോടുള്ള താത്പര്യംതന്നെ ഇല്ലാതായിരിക്കുന്നു; ഞങ്ങളുടെമുമ്പിൽ ഈ മന്നയല്ലാതെ മറ്റൊന്നും കാണുന്നതുമില്ല!” ");
INSERT INTO malc_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","മന്നാ വെളുത്ത്, കൊത്തമല്ലിയരിപോലെയുള്ളതും കാഴ്ചയ്ക്ക് ഗുല്ഗുലു സമാനവും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ജനം ചുറ്റിനടന്ന് അതു ശേഖരിച്ച് തിരികല്ലിൽ പൊടിച്ചോ ഉരലിൽ ഇടിച്ചോ എടുക്കും. അവർ അതു കലത്തിൽ പാകംചെയ്തെടുക്കുകയോ അപ്പമുണ്ടാക്കുകയോ ചെയ്തുവന്നു. അതിന്റെ രുചി ഒലിവെണ്ണചേർത്തുണ്ടാക്കിയ ധാന്യപ്പലഹാരംപോലെയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","രാത്രി പാളയത്തിൽ മഞ്ഞിനോടൊപ്പം മന്നയും പൊഴിയും. ");
INSERT INTO malc_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","കുടുംബങ്ങളോരോന്നും സ്വന്തം കൂടാരവാതിൽക്കലിരുന്നു നിലവിളിക്കുന്നതു മോശ കേട്ടു. യഹോവ അത്യന്തം കോപിച്ചു; മോശയ്ക്കും അനിഷ്ടമുണ്ടായി. ");
INSERT INTO malc_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","അദ്ദേഹം യഹോവയോടു ചോദിച്ചു: “അങ്ങയുടെ ദാസന്റെമേൽ അങ്ങ് ഈ ക്ലേശം വരുത്തിയതെന്തിന്? എന്നോടു കൃപ കാണിക്കാതെ ഈ ജനത്തിന്റെയെല്ലാം ഭാരം എന്റെമേൽ വെച്ചതെന്തിന്? ");
INSERT INTO malc_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ഞാനാണോ ഈ ജനത്തെയെല്ലാം ഗർഭംധരിച്ചത്? ഞാനാണോ അവരെ പ്രസവിച്ചത്? അവരുടെ പൂർവികരോട് അങ്ങ് ശപഥംചെയ്തു വാഗ്ദാനം നൽകിയ ദേശത്തേക്ക് ഒരു ധാത്രി ശിശുവിനെ വഹിക്കുന്നതുപോലെ അവരെ എന്റെ കൈകളിൽ വഹിച്ചുകൊണ്ടുപോകാൻ അങ്ങ് എന്നോട് കൽപ്പിക്കുന്നതെന്തിന്? ");
INSERT INTO malc_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ഈ ജനത്തിനെല്ലാം ഞാൻ എവിടെനിന്നു മാംസം കൊണ്ടുവരും? ‘ഞങ്ങൾക്കു തിന്നാൻ മാംസം തരിക’ എന്ന് അവർ എന്നോടു നിലവിളിച്ചുകൊണ്ടിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ഈ ജനത്തെയെല്ലാം തനിയേ പോറ്റാൻ എനിക്കു കഴിവില്ല; ഇത് എനിക്ക് അതിഭാരം ആകുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ഇപ്രകാരമാണ് അങ്ങ് എന്നോടു പ്രവർത്തിക്കുന്നതെങ്കിൽ, എന്നെ കൊന്നുകളയണമേ. എന്നോടു കനിവുതോന്നി എന്റെ അരിഷ്ടത ഞാൻ കാണാൻ അനുവദിക്കരുതേ.” ");
INSERT INTO malc_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","യഹോവ മോശയോടു പറഞ്ഞു: “ജനത്തിന്റെ ഇടയിൽ പ്രഭുക്കന്മാരും മേൽവിചാരകരുമായി അംഗീകരിക്കപ്പെട്ട ഇസ്രായേലിലെ ഗോത്രത്തലവന്മാരിൽ എഴുപതുപേരെ എന്റെ അടുക്കൽ കൊണ്ടുവരിക. അവർ വന്ന് സമാഗമകൂടാരത്തിങ്കൽ നിന്നോടൊപ്പം നിൽക്കട്ടെ. ");
INSERT INTO malc_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","അവിടെ ഞാൻ ഇറങ്ങിവന്ന് നിന്നോടു സംസാരിക്കും; നിന്റെമേലുള്ള ആത്മാവിൽ അൽപ്പം എടുത്ത് അവരുടെമേൽ പകരും. ജനത്തിന്റെ ഭാരം വഹിക്കാൻ അവർ നിന്നെ സഹായിക്കും, അങ്ങനെ നീ തനിയേ അതു വഹിക്കേണ്ടിവരികയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“ജനത്തോടു പറയുക: ‘നാളേയ്ക്കായി നിങ്ങളെത്തന്നെ ശുദ്ധീകരിക്കുക, നാളെ നിങ്ങൾ മാംസം ഭക്ഷിക്കും. “ഞങ്ങൾക്കു ഭക്ഷിക്കാൻ മാംസം ആർ തരും? ഈജിപ്റ്റിൽ ഞങ്ങൾക്ക് എത്ര നന്നായിരുന്നു!” എന്നു നിങ്ങൾ കരയുന്നത് യഹോവ കേട്ടു. ഇപ്പോൾ യഹോവ നിങ്ങൾക്കു മാംസം തരും. നിങ്ങൾ അതു തിന്നും. ");
INSERT INTO malc_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","കേവലം ഒരു ദിവസമോ രണ്ടു ദിവസമോ അഞ്ചോ പത്തോ ഇരുപതോ ദിവസമോ അല്ല; ");
INSERT INTO malc_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ഒരുമാസം മുഴുവൻ—അതു നിങ്ങളുടെ മൂക്കിലൂടെ പുറത്തുവന്ന് നിങ്ങൾക്ക് അറപ്പുണ്ടാകുന്നതുവരെ—നിങ്ങൾ തിന്നും. കാരണം നിങ്ങളുടെ മധ്യത്തിലുള്ള യഹോവയെ നിങ്ങൾ ത്യജിച്ച് “ഞങ്ങൾ ഈജിപ്റ്റിൽനിന്നും പോന്നതെന്തിന്” എന്നു പറഞ്ഞ് അവിടത്തെ മുമ്പാകെ നിലവിളിച്ചല്ലോ.’ ” ");
INSERT INTO malc_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","എന്നാൽ മോശ പറഞ്ഞു: “ഇവിടെ ആറുലക്ഷം യോദ്ധാക്കളുടെ മധ്യേ ഞാൻ നിൽക്കുന്നു, എന്നിട്ടും ‘ഞാൻ അവർക്ക് മാംസം കൊടുക്കും; അവർ ഒരുമാസം അതു ഭക്ഷിക്കും’ എന്ന് അങ്ങു പറയുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ആടുകളെയും മാടുകളെയും അവർക്കുവേണ്ടി അറത്താലും അവർക്ക് തൃപ്തിയാകുമോ? സമുദ്രത്തിലെ മത്സ്യം മുഴുവനും പിടിച്ചാലും അവർക്കു തികയുമോ?” ");
INSERT INTO malc_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","യഹോവ മോശയോടു പറഞ്ഞു: “യഹോവയുടെ കൈ കുറുകിപ്പോയോ? ഞാൻ അരുളിച്ചെയ്യുന്നത് നിവൃത്തിയാകുമോ ഇല്ലയോ എന്നു നീ ഇപ്പോൾ കാണും.” ");
INSERT INTO malc_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","അങ്ങനെ മോശ പുറത്തുചെന്ന് യഹോവ പറഞ്ഞത് ജനത്തോട് അറിയിച്ചു. എഴുപതു തലവന്മാരെ അദ്ദേഹം വിളിച്ചുകൂട്ടി കൂടാരത്തിനുചുറ്റും നിർത്തി. ");
INSERT INTO malc_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","അപ്പോൾ യഹോവ മേഘത്തിൽ ഇറങ്ങിവന്ന് മോശയോടു സംസാരിച്ചു. അദ്ദേഹത്തിന്റെമേലുണ്ടായിരുന്ന ആത്മാവിൽനിന്ന് കുറെ എടുത്ത് തലവന്മാരായ ആ എഴുപതു പുരുഷന്മാരുടെമേൽ പകർന്നു. ആത്മാവ് അവരുടെമേൽ ആവസിച്ചപ്പോൾ അവർ പ്രവചിച്ചു, പക്ഷേ, പിന്നീട് അവർ അങ്ങനെ ചെയ്തില്ല. ");
INSERT INTO malc_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","എന്നാൽ എൽദാദ്, മേദാദ് എന്ന രണ്ടുപേർ പാളയത്തിൽത്തന്നെ താമസിച്ചു. അവർ ഗോത്രത്തലവന്മാരുടെ കൂട്ടത്തിൽ എണ്ണപ്പെട്ടവരായിരുന്നെങ്കിലും കൂടാരത്തിലേക്കിറങ്ങിച്ചെന്നില്ല. എങ്കിലും ആത്മാവ് അവരുടെമേലും ആവസിച്ചു. അവർ പാളയത്തിൽവെച്ചു പ്രവചിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ഒരു യുവാവ് ഓടിച്ചെന്ന് മോശയോടു പറഞ്ഞു: “എൽദാദും മേദാദും പാളയത്തിൽ പ്രവചിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","യൗവനംമുതൽ മോശയുടെ സഹായിയായിരുന്ന നൂന്റെ മകനായ യോശുവ അപ്പോൾ പറഞ്ഞു: “എന്റെ യജമാനനായ മോശയേ, അവരെ തടയണമേ!” ");
INSERT INTO malc_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","എന്നാൽ മോശ മറുപടി പറഞ്ഞു: “എന്നെയോർത്ത് നീ അസൂയപ്പെടുന്നോ? യഹോവയുടെ സർവജനവും പ്രവാചകന്മാരാകണമെന്നും യഹോവ തന്റെ ആത്മാവിനെ അവരുടെമേൽ പകരണമെന്നുമാണു ഞാൻ ആഗ്രഹിക്കുന്നത്!” ");
INSERT INTO malc_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ഇതിനുശേഷം മോശയും ഇസ്രായേലിലെ ഗോത്രത്തലവന്മാരും പാളയത്തിലേക്കു മടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","അപ്പോൾ യഹോവയിൽനിന്ന് ഒരു കാറ്റു പുറപ്പെട്ടു; കാറ്റുമൂലം കാടപ്പക്ഷികൾ സമുദ്രത്തിൽനിന്നുവന്നു. അത് അവയെ പാളയത്തിനുചുറ്റും എല്ലായിടത്തും നിലത്തുനിന്ന് ഏകദേശം രണ്ടുമുഴം പൊക്കത്തിൽ എല്ലാ ദിശയിലേക്കും ഒരു ദിവസത്തെ വഴി ദൂരംവരെ വീഴിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ആ പകലും രാത്രിമുഴുവനും പിറ്റേന്നാൾ മുഴുവനും ജനം ഇറങ്ങിച്ചെന്ന് കാടപ്പക്ഷി ശേഖരിച്ചു. പത്തു ഹോമറിൽ കുറവ് ആരും ശേഖരിച്ചില്ല. പിന്നീട് അവയെ അവർ പാളയത്തിനു ചുറ്റിലെല്ലാം നിരത്തി. ");
INSERT INTO malc_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","എന്നാൽ മാംസം അവരുടെ പല്ലുകൾക്കിടയിൽ ഇരിക്കുമ്പോൾ, അതു ചവച്ചിറക്കുന്നതിനു മുമ്പുതന്നെ, യഹോവയുടെ കോപം ജനത്തിനുനേരേ ജ്വലിച്ചു. അതുകൊണ്ട് അവിടന്ന് അവരെ ഒരു കഠിനബാധകൊണ്ടു സംഹരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","മറ്റു ഭക്ഷണങ്ങൾക്കായി മുറവിളി കൂട്ടിയ ജനത്തെ അവിടെ അടക്കിയതിനാൽ ആ സ്ഥലത്തിന് കിബ്രോത്ത്-ഹത്താവ എന്നു പേരായി. ");
INSERT INTO malc_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","കിബ്രോത്ത്-ഹത്താവയിൽനിന്ന് ജനം ഹസേരോത്തിലേക്കു യാത്രചെയ്ത് അവിടെ കുറച്ചുനാൾ താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","മോശ ഒരു കൂശ്യസ്ത്രീയെ വിവാഹംകഴിച്ചിരുന്നതിനാൽ, കൂശ്യസ്ത്രീനിമിത്തം മിര്യാമും അഹരോനും മോശയ്ക്കു വിരോധമായി സംസാരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“മോശയിൽക്കൂടിമാത്രമേ യഹോവ സംസാരിച്ചിട്ടുള്ളോ?” അവർ ചോദിച്ചു. “അവിടന്ന് ഞങ്ങളിലൂടെയും സംസാരിച്ചിട്ടില്ലയോ?” യഹോവ ഇതു കേട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","എന്നാൽ മോശയാകട്ടെ, ഭൂതലത്തിലുള്ള സകലമനുഷ്യരിലുംവെച്ച് ഏറ്റവും സൗമ്യനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ഉടൻതന്നെ യഹോവ മോശയോടും അഹരോനോടും മിര്യാമിനോടും കൽപ്പിച്ചു: “നിങ്ങൾ മൂന്നുപേരും സമാഗമകൂടാരത്തിൽ വരിക.” അങ്ങനെ അവർ മൂന്നുപേരും കൂടാരത്തിലേക്കുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","യഹോവ ഒരു മേഘസ്തംഭത്തിൽ ഇറങ്ങിവന്നു; കൂടാരവാതിലിൽനിന്ന് അഹരോനെയും മിര്യാമിനെയും വിളിച്ചു. അവർ രണ്ടുപേരും മുമ്പോട്ടുചെന്നപ്പോൾ ");
INSERT INTO malc_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","അവിടന്ന് പറഞ്ഞു: “എന്റെ വാക്കുകൾ ശ്രദ്ധിക്കുക: “നിങ്ങളുടെ ഇടയിൽ ഒരു പ്രവാചകൻ ഉണ്ടെങ്കിൽ, യഹോവ ആകുന്ന ഞാൻ ദർശനത്തിൽ എന്നെത്തന്നെ അവർക്കു വെളിപ്പെടുത്തും. ഞാൻ സ്വപ്നത്തിൽ അവരോടു സംസാരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","എന്നാൽ എന്റെ ദാസനായ മോശയുടെ കാര്യത്തിൽ അങ്ങനെയല്ല; അവൻ എന്റെ ഭവനത്തിലൊക്കെയും വിശ്വസ്തനാണ്. ");
INSERT INTO malc_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","അവനുമായി ഞാൻ അവ്യക്തമായല്ല, സ്പഷ്ടമായും അഭിമുഖമായുമാണ് സംസാരിക്കുന്നത്; അവൻ യഹോവയുടെ രൂപം കാണും. എന്നിട്ടും എന്റെ ദാസനായ മോശയ്ക്കു വിരോധമായി സംസാരിക്കാൻ നിങ്ങൾ ഭയപ്പെടാഞ്ഞതെന്ത്?” ");
INSERT INTO malc_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","യഹോവയുടെ കോപം അവർക്കെതിരേ ജ്വലിച്ചു; അവിടന്ന് അവരെ വിട്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","മേഘം കൂടാരത്തിനുമീതേനിന്ന് ഉയർന്നപ്പോൾ, മിര്യാം ഹിമംപോലെ വെളുത്ത് കുഷ്ഠരോഗിണിയായി. അഹരോൻ അവളെ നോക്കി. അവൾ കുഷ്ഠരോഗിണി എന്നുകണ്ടു ");
INSERT INTO malc_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","അപ്പോൾത്തന്നെ അഹരോൻ മോശയോട് അപേക്ഷിച്ചു: “യജമാനനേ, ഞങ്ങൾ ഭോഷത്തമായി ചെയ്ത പാപം ഞങ്ങളോടു കണക്കിടരുതേ. ");
INSERT INTO malc_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","പാതി മാംസം അഴുകിപ്പോയനിലയിൽ അമ്മയുടെ ഉദരത്തിൽനിന്നും പുറത്തു വന്ന ചാപിള്ളപോലെ അവൾ ആകരുതേ.” ");
INSERT INTO malc_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","അപ്പോൾ മോശ യഹോവയോടു നിലവിളിച്ചു, “ദൈവമേ, അവളെ സൗഖ്യമാക്കണേ!” ");
INSERT INTO malc_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “അവളുടെ അപ്പൻ അവളുടെ മുഖത്തു തുപ്പിയിരുന്നെങ്കിൽ അവൾ ഏഴുദിവസം ലജ്ജിക്കുകയില്ലേ? ഏഴുദിവസം പാളയത്തിനുപുറത്ത് അവളെ അടച്ചിടുക; അതിനുശേഷം അവളെ തിരികെക്കൊണ്ടുവരാം.” ");
INSERT INTO malc_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","അങ്ങനെ മിര്യാമിനെ ഏഴുദിവസം പാളയത്തിനുപുറത്ത് അടച്ചിട്ടു, അവളെ തിരികെക്കൊണ്ടുവരുംവരെ ജനം യാത്രചെയ്തില്ല. ");
INSERT INTO malc_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ഇതിനുശേഷം ജനം ഹസേരോത്ത് വിട്ട് പാരാൻ മരുഭൂമിയിൽ പാളയമിറങ്ങി. ");
INSERT INTO malc_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ഞാൻ ഇസ്രായേല്യർക്കു നൽകുന്ന കനാൻദേശം പര്യവേക്ഷണംചെയ്യാൻ ചില പുരുഷന്മാരെ അയയ്ക്കുക. ഓരോ പിതൃഗോത്രത്തിൽനിന്നും അതിന്റെ പ്രഭുക്കന്മാരിൽ ഒരുവനെ അയയ്ക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","യഹോവ കൽപ്പിച്ചതുപോലെ പാരാൻ മരുഭൂമിയിൽനിന്ന് മോശ അവരെ അയച്ചു. അവർ എല്ലാവരും ഇസ്രായേല്യരുടെ പ്രഭുക്കന്മാരായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","അവരുടെ പേരുകൾ ഇവയാണ്: രൂബേൻഗോത്രത്തിൽനിന്ന്, സക്കൂറിന്റെ മകൻ ശമ്മൂവാ; ");
INSERT INTO malc_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ശിമെയോൻഗോത്രത്തിൽനിന്ന്, ഹോരിയുടെ മകൻ ശാഫാത്ത് ");
INSERT INTO malc_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","യെഹൂദാഗോത്രത്തിൽനിന്ന്, യെഫുന്നയുടെ മകൻ കാലേബ്; ");
INSERT INTO malc_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","യിസ്സാഖാർ ഗോത്രത്തിൽനിന്ന്, യോസേഫിന്റെ മകൻ യിഗാൽ; ");
INSERT INTO malc_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","എഫ്രയീംഗോത്രത്തിൽനിന്ന്, നൂന്റെ മകൻ ഹോശേയാ, ");
INSERT INTO malc_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ബെന്യാമീൻഗോത്രത്തിൽനിന്ന് രാഫൂവിന്റെ മകൻ ഫൽതി; ");
INSERT INTO malc_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","സെബൂലൂൻഗോത്രത്തിൽനിന്ന്, സോദിയുടെ മകൻ ഗദ്ദിയേൽ; ");
INSERT INTO malc_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","യോസേഫിന്റെ ഒരു ഗോത്രമായ മനശ്ശെയിൽനിന്ന് സൂസിയുടെ മകൻ ഗദ്ദി; ");
INSERT INTO malc_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ദാൻഗോത്രത്തിൽനിന്ന്, ഗെമല്ലിയുടെ മകൻ അമ്മീയേൽ; ");
INSERT INTO malc_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ആശേർ ഗോത്രത്തിൽനിന്ന് മീഖായേലിന്റെ മകൻ സെഥൂർ; ");
INSERT INTO malc_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","നഫ്താലിഗോത്രത്തിൽനിന്ന് വൊപ്‌സിയുടെ മകൻ നഹ്ബി; ");
INSERT INTO malc_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ഗാദ്ഗോത്രത്തിൽനിന്ന് മാഖിയുടെ മകൻ ഗയൂവേൽ. ");
INSERT INTO malc_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ദേശം പര്യവേക്ഷണംചെയ്യാൻ മോശ അയച്ച പുരുഷന്മാരുടെ പേരുകൾ ഇവയായിരുന്നു. മോശ നൂന്റെ മകൻ ഹോശേയായ്ക്ക് യോശുവ എന്നു പേരുനൽകി. ");
INSERT INTO malc_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","കനാൻ പര്യവേക്ഷണംചെയ്യാൻ അവരെ മോശ അയച്ചപ്പോൾ അദ്ദേഹം പറഞ്ഞു: “തെക്കേദേശത്തുകൂടെ കടന്ന് മലനാട്ടിലേക്കു ചെല്ലുക. ");
INSERT INTO malc_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ദേശം എങ്ങനെയുള്ളതെന്നും അവിടെ പാർക്കുന്ന ജനം ശക്തരോ അശക്തരോ അധികമോ ചുരുക്കമോ എന്നും നോക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","എപ്രകാരമുള്ളതാണ് അവർ പാർക്കുന്ന ദേശം? അതു നല്ലതോ ചീത്തയോ? അവർ പാർക്കുന്ന പട്ടണങ്ങൾ എപ്രകാരമുള്ളതാണ്? അവ മതിലുകളില്ലാത്തവയോ കോട്ടകെട്ടിയുറപ്പിച്ചവയോ? ");
INSERT INTO malc_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","മണ്ണ് എങ്ങനെ? വളക്കൂറുള്ളതോ ഇല്ലാത്തതോ? അതിൽ വൃക്ഷങ്ങൾ ഉണ്ടോ ഇല്ലയോ? ദേശത്തെ കുറച്ചു ഫലങ്ങൾ കൊണ്ടുവരാൻ നിങ്ങൾ പരമാവധി ശ്രമിക്കണം.” (അതു മുന്തിരിങ്ങ പഴുത്തുതുടങ്ങുന്ന കാലമായിരുന്നു.) ");
INSERT INTO malc_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","അങ്ങനെ അവർ കയറിപ്പോയി സീൻ മരുഭൂമിമുതൽ, ലെബോ-ഹമാത്തിനുനേരേ രെഹോബുവരെയുള്ള ദേശം പര്യവേക്ഷണംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","അവർ തെക്കേദേശത്തിലൂടെ കയറിച്ചെന്ന് അനാക്യരായ അഹീമാൻ, ശേശായി, തൽമായി എന്നിവർ പാർക്കുന്ന ഹെബ്രോനിൽ വന്നു. പുരാതനനഗരമായ ഹെബ്രോൻ ഈജിപ്റ്റിലെ സോവാൻപട്ടണത്തിന് ഏഴുവർഷം മുമ്പു പണിയപ്പെട്ടിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","അവർ എസ്കോൽ താഴ്വരയിൽ വന്ന്, ഒരുകുല മുന്തിരിങ്ങ മുറിച്ചെടുത്തു. അവരിൽ രണ്ടുപേർ കുറെ മാതളപ്പഴം അത്തിപ്പഴം എന്നിവയ്ക്കൊപ്പം ഒരു തണ്ടിൽ അതു ചുമന്നു. ");
INSERT INTO malc_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ഇസ്രായേല്യർ അവിടെവെച്ച് മുറിച്ചെടുത്ത മുന്തിരിക്കുലനിമിത്തം ആ സ്ഥലത്തിനു എസ്കോൽതാഴ്വര എന്നു പേരായി. ");
INSERT INTO malc_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","നാൽപ്പതു ദിവസങ്ങൾ അവർ ദേശം പര്യവേക്ഷണംചെയ്തു; അതിനുശേഷം അവർ മടങ്ങി. ");
INSERT INTO malc_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","അവർ പാരാൻമരുഭൂമിയിലെ കാദേശിൽ മോശയുടെയും അഹരോന്റെയും ഇസ്രായേൽസഭ മുഴുവന്റെയും അടുക്കൽ മടങ്ങിവന്നു. അവിടെ അവർ അവരോടും സർവസഭയോടും അവരുടെ അവലോകനവിവരം അറിയിക്കുകയും ദേശത്തിലെ ഫലങ്ങൾ അവരെ കാണിക്കുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","അവർ മോശയ്ക്കു നൽകിയ വിവരണം ഇപ്രകാരമാണ്: “അങ്ങു ഞങ്ങളെ അയച്ച ദേശത്തിലേക്കു ഞങ്ങൾ പോയി, അത് പാലും തേനും ഒഴുകുന്ന ദേശംതന്നെ! ഇതാ അതിലെ ഫലങ്ങൾ. ");
INSERT INTO malc_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","എന്നാൽ അവിടെ പാർക്കുന്ന ജനം ശക്തരും പട്ടണങ്ങൾ കോട്ടകെട്ടിയുറപ്പിച്ചതും വളരെ വലുപ്പമുള്ളതും ആകുന്നു. ഞങ്ങൾ അവിടെ അനാക്കിന്റെ മല്ലന്മാരായ സന്തതികളെ കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","അമാലേക്യർ തെക്കേദേശത്തു വസിക്കുന്നു; ഹിത്യരും യെബൂസ്യരും അമോര്യരും മലനാട്ടിൽ പാർക്കുന്നു; കനാന്യർ സമുദ്രതീരത്തും യോർദാൻകരയിലും താമസിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","അപ്പോൾ കാലേബ് ജനത്തെ മോശയുടെമുമ്പിൽ നിശ്ശബ്ദരാക്കി ഇപ്രകാരം പറഞ്ഞു: “നാം കയറിച്ചെന്ന് ദേശം കൈവശമാക്കണം, തീർച്ചയായും നമുക്കത് പിടിച്ചടക്കാൻസാധിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","എന്നാൽ അദ്ദേഹത്തോടൊപ്പംപോയ പുരുഷന്മാർ പറഞ്ഞു: “നമുക്ക് ആ ജനത്തെ ആക്രമിക്കാൻ സാധിക്കുകയില്ല; അവർ നമ്മെക്കാൾ ശക്തരാണ്.” ");
INSERT INTO malc_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","തങ്ങൾ പര്യവേക്ഷണംചെയ്ത ദേശത്തെക്കുറിച്ച് ഇസ്രായേല്യരുടെയിടയിൽ ആശാവഹമല്ലാത്ത ഒരു വാർത്ത അവർ പ്രചരിപ്പിച്ചു. അവർ പറഞ്ഞു, “ഞങ്ങൾ കണ്ട ദേശം അതിൽ പാർക്കുന്നവരെ വിഴുങ്ങിക്കളയുന്ന ദേശമാണ്. ഞങ്ങൾ അവിടെക്കണ്ട സകലരും അതികായന്മാരാണ്. ");
INSERT INTO malc_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ഞങ്ങൾ അവിടെ അനാക്കിന്റെ സന്തതികളായ മല്ലന്മാരെയും കണ്ടു. അവരുടെമുമ്പിൽ ഞങ്ങൾ വെറും വെട്ടുക്കിളികളാണെന്നു തോന്നി; അവരുടെ കാഴ്ചയിൽ ഞങ്ങൾ അങ്ങനെതന്നെ ആയിരുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ആ രാത്രി ഇസ്രായേൽസഭ മുഴുവനും ശബ്ദം ഉയർത്തി ഉച്ചത്തിൽ കരഞ്ഞു; ");
INSERT INTO malc_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","സകല ഇസ്രായേല്യരും മോശയ്ക്കും അഹരോനും എതിരായി പിറുപിറുത്തു; സർവസഭയും അവരോടു പറഞ്ഞു: “ഞങ്ങൾ ഈജിപ്റ്റിൽവെച്ചു മരിച്ചിരുന്നെങ്കിൽ! അല്ലെങ്കിൽ മരുഭൂമിയിൽത്തന്നെ ഞങ്ങൾ മരിച്ചിരുന്നെങ്കിൽ! ");
INSERT INTO malc_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ഞങ്ങൾ വാളിനാൽ വീഴാനായി യഹോവ ഞങ്ങളെ ഈ ദേശത്തേക്കു കൊണ്ടുവന്നതെന്തിന്? ഞങ്ങളുടെ ഭാര്യമാരും കുട്ടികളും കൊള്ളയായി പിടിക്കപ്പെടാൻ പോകുന്നു. ഈജിപ്റ്റിലേക്കു തിരികെപ്പോകുന്നതല്ലേ ഞങ്ങൾക്കു നല്ലത്?” ");
INSERT INTO malc_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","“നമുക്ക് ഒരു നായകനെ തെരഞ്ഞെടുത്ത് ഈജിപ്റ്റിലേക്ക് മടങ്ങിപ്പോകാം,” അവർ പരസ്പരം പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","അപ്പോൾ മോശയും അഹരോനും അവിടെ കൂടിയിരുന്ന ഇസ്രായേൽസഭയിലുണ്ടായിരുന്ന സർവരുടെയും മുമ്പിൽ കമിഴ്ന്നുവീണു. ");
INSERT INTO malc_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ദേശം പര്യവേക്ഷണംചെയ്യാൻ പോയവരിൽ നൂന്റെ മകൻ യോശുവയും യെഫുന്നയുടെ മകൻ കാലേബും തങ്ങളുടെ വസ്ത്രംകീറി ");
INSERT INTO malc_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","സർവ ഇസ്രായേൽസഭയോടും പറഞ്ഞു: “ഞങ്ങൾ സഞ്ചരിച്ച് പര്യവേക്ഷണംചെയ്ത ദേശം ഏറ്റവും നല്ലത്. ");
INSERT INTO malc_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","യഹോവ നമ്മിൽ പ്രസാദിക്കുന്നെങ്കിൽ, അവിടന്ന് പാലും തേനും ഒഴുകുന്ന ആ ദേശത്തേക്കു നമ്മെ കൊണ്ടുചെന്ന് അതു നമുക്കു തരും. ");
INSERT INTO malc_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","യഹോവയോടു മത്സരിക്കുകമാത്രം അരുത്. ആ ദേശത്തുള്ള ജനത്തെ ഭയപ്പെടരുത്, അവർ നമുക്കിരയാകും. അവരുടെ സുരക്ഷ നഷ്ടപ്പെട്ടിരിക്കുന്നു; എന്നാൽ യഹോവ നമ്മോടൊപ്പം ഉണ്ട്. അവരെ ഭയപ്പെടരുത്.” ");
INSERT INTO malc_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","എന്നാൽ യോശുവയെയും കാലേബിനെയും കല്ലെറിയണമെന്നു സർവസഭയും പറഞ്ഞു. അപ്പോൾ യഹോവയുടെ തേജസ്സ് സമാഗമകൂടാരത്തിൽ സർവ ഇസ്രായേല്യർക്കും പ്രത്യക്ഷമായി. ");
INSERT INTO malc_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “ഈ ജനം എത്രനാൾ എന്നെ നിന്ദിക്കും? ഞാൻ അവരുടെ ഇടയിൽ പ്രവർത്തിച്ച സകല അത്ഭുതചിഹ്നങ്ങളും കണ്ടിട്ടും അവർ എത്രനാൾ എന്നിൽ വിശ്വസിക്കാതിരിക്കും? ");
INSERT INTO malc_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ഞാൻ അവരെ ഒരു ബാധയാൽ ദണ്ഡിപ്പിച്ച്, സംഹരിച്ചു നശിപ്പിക്കും. എന്നാൽ ഞാൻ നിന്നെ അവരിലും വലിയതും ശക്തവുമായ ഒരു ജനതയാക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","മോശ യഹോവയോടു പറഞ്ഞു: “എന്നാൽ ഈജിപ്റ്റുകാർ അതിനെക്കുറിച്ചു കേൾക്കുമ്പോൾ എന്താണു ചിന്തിക്കുക! അവിടത്തെ ശക്തിയാൽ അങ്ങ് ഈ ജനത്തെ അവരുടെ ഇടയിൽനിന്ന് കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","അവിടന്ന് ഇപ്പോൾ ഈ ജനത്തെ നശിപ്പിച്ചാൽ, ഈജിപ്റ്റുകാർ ഈ ദേശവാസികളോട് ഇക്കാര്യം പറയും. യഹോവയായ അങ്ങ് ഈ ജനത്തോടൊപ്പം ഉണ്ടെന്നും അവർ അങ്ങയെ അഭിമുഖമായിക്കണ്ടുവെന്നും അവർ കേട്ടിട്ടുണ്ട്; കാരണം, അങ്ങയുടെ മേഘം അവരുടെ മുകളിൽ വസിക്കുന്നു, പകൽ മേഘസ്തംഭത്തിലും രാത്രി അഗ്നിസ്തംഭത്തിലും അങ്ങ് അവർക്കുമുമ്പായി പോകുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","അവിടന്ന് ഈ ജനത്തെ ഒന്നിച്ചു നശിപ്പിച്ചാൽ, അങ്ങയെക്കുറിച്ച് ഈ വർത്തമാനം കേട്ടിട്ടുള്ള ജനം പറയും: ");
INSERT INTO malc_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘യഹോവ ശപഥംചെയ്ത്, വാഗ്ദാനംകൊടുത്ത ദേശത്തേക്ക് ഈ ജനത്തെ കൊണ്ടുവരാൻ അവിടത്തേക്കു കഴിഞ്ഞില്ല; അതിനാൽ അവിടന്ന് അവരെ മരുഭൂമിയിൽവെച്ചു കൊന്നുകളഞ്ഞു.’ ");
INSERT INTO malc_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“അവിടന്ന് അരുളിച്ചെയ്തിട്ടുള്ളതുപോലെ അവിടത്തെ ശക്തി വലുതാണെന്നു വെളിപ്പെടുത്താൻ ഞാൻ അങ്ങയോടപേക്ഷിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘യഹോവ ക്ഷമാശീലനും സ്നേഹസമ്പന്നനും അകൃത്യവും ലംഘനവും ക്ഷമിക്കുന്നവനും ആകുന്നു. എങ്കിലും അവിടന്ന് കുറ്റംചെയ്തവരെ വെറുതേവിടാതെ പിതാക്കന്മാരുടെ അകൃത്യത്തിനു മക്കളെ മൂന്നും നാലും തലമുറവരെ ശിക്ഷിക്കുന്നവനും ആകുന്നു.’ ");
INSERT INTO malc_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","അങ്ങയുടെ മഹാ ദയനിമിത്തം ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെട്ട സമയംമുതൽ ഇപ്പോൾവരെ അവരോടു ക്ഷമിച്ചതുപോലെതന്നെ ഈ ജനത്തിന്റെ പാപം ക്ഷമിക്കണമേ.” ");
INSERT INTO malc_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","അതിനു യഹോവ അരുളിച്ചെയ്തു: “നീ അപേക്ഷിച്ചതുപോലെ ഞാൻ അവരോടു ക്ഷമിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","എങ്കിലും, ജീവനുള്ള ഞാൻ ശപഥംചെയ്യുന്നു, ഭൂമി മുഴുവൻ യഹോവയുടെ തേജസ്സ് നിറഞ്ഞിരിക്കുന്നു, ");
INSERT INTO malc_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","എന്റെ തേജസ്സും ഞാൻ ഈജിപ്റ്റിലും മരുഭൂമിയിലും പ്രവർത്തിച്ച അത്ഭുതചിഹ്നങ്ങളും ദർശിച്ചിട്ട് എന്നെ പത്തുപ്രാവശ്യം പരീക്ഷിക്കുകയും എന്റെ വാക്ക് അനുസരിക്കാതിരിക്കുകയും ചെയ്തവരിൽ ആരും ");
INSERT INTO malc_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","അവരുടെ പിതാക്കന്മാർക്കു ഞാൻ നൽകുമെന്നു ശപഥംചെയ്ത ദേശം കാണുകയില്ല. എന്നെ നിന്ദിച്ചവരിൽ ആരും ഒരിക്കലും അതു കാണുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","എന്നാൽ എന്റെ ദാസനായ കാലേബിനു വ്യത്യസ്തമായ ഒരു ആത്മാവുള്ളതിനാലും എന്നെ പൂർണഹൃദയത്തോടെ പിൻപറ്റുന്നതിനാലും അവൻ പോയ ദേശത്തേക്കു ഞാൻ അവനെ കൊണ്ടുപോകും; അവന്റെ സന്തതികൾ അത് അവകാശമാക്കും. ");
INSERT INTO malc_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","അമാലേക്യരും കനാന്യരും താഴ്വരയിൽ പാർക്കുന്നതിനാൽ, നാളെ നിങ്ങൾ പിന്തിരിഞ്ഞ് ചെങ്കടലിലേക്കുള്ള മാർഗത്തിലൂടെ മരുഭൂമിയിലേക്ക് യാത്രപുറപ്പെടുക.” ");
INSERT INTO malc_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ഈ ദുഷ്ടസമൂഹം എനിക്കെതിരേ എത്രത്തോളം പിറുപിറുക്കും? ഈ പിറുപിറുപ്പുകാരായ ഇസ്രായേല്യരുടെ പരാതികൾ ഞാൻ കേട്ടിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ആകയാൽ, ‘ഞാൻ കേൾക്കെ നിങ്ങൾ പിറുപിറുത്തതുപോലെതന്നെ നിങ്ങളോടു ഞാൻ ചെയ്യും; ജീവനുള്ള ഞാൻ ശപഥംചെയ്യുന്നു, എന്ന് യഹോവ അരുളിച്ചെയ്യുന്നതായി അവരോടു പറയുക. ");
INSERT INTO malc_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ഈ മരുഭൂമിയിൽ നിങ്ങളുടെ ശവങ്ങൾ വീഴും—നിങ്ങളിൽ ഇരുപതോ അതിലധികമോ വയസ്സു പ്രായമുള്ളവരായി ജനസംഖ്യയിൽ എണ്ണപ്പെട്ടവരും എനിക്കെതിരേ പിറുപിറുത്തവരുമായ ഏവരുംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","നിങ്ങളെ പാർപ്പിക്കാമെന്നു ഞാൻ കൈ ഉയർത്തി ശപഥംചെയ്ത ദേശത്ത് യെഫുന്നയുടെ മകൻ കാലേബും നൂന്റെ മകൻ യോശുവയും ഒഴികെ നിങ്ങളിൽ ഒരാൾപോലും കടക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","കൊള്ളയായിപ്പോകുമെന്നു നിങ്ങൾ പറഞ്ഞ നിങ്ങളുടെ മക്കളെ ഞാൻ അവിടെ പ്രവേശിപ്പിക്കും; നിങ്ങൾ തിരസ്കരിച്ച ദേശം അവർ അനുഭവിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","എന്നാൽ നിങ്ങളോ, നിങ്ങളുടെ ശവങ്ങൾ മരുഭൂമിയിൽ വീഴും. ");
INSERT INTO malc_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","നിങ്ങളുടെ മക്കൾ നിങ്ങളുടെ അവിശ്വസ്തതനിമിത്തം കഷ്ടതയനുഭവിച്ചുകൊണ്ട്, നിങ്ങളുടെ ശവങ്ങളിൽ അവസാനത്തേതും ഈ മരുഭൂമിയിൽ വീഴുന്നതുവരെ, ഇവിടെ നാൽപ്പതുവർഷം ഇടയന്മാരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","നിങ്ങൾ ദേശം പര്യവേക്ഷണംചെയ്ത നാൽപ്പതു ദിവസങ്ങളിൽ ഓരോന്നിനും ഓരോ വർഷം എന്ന കണക്കിനു നാൽപ്പതുവർഷം നിങ്ങളുടെ പാപങ്ങൾനിമിത്തം നിങ്ങൾ കഷ്ടത അനുഭവിക്കുകയും അങ്ങനെ നിങ്ങൾ എന്റെ എതിർപ്പ് അറിയുകയും ചെയ്യും.’ ");
INSERT INTO malc_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","യഹോവയായ ഞാൻ അരുളിച്ചെയ്യുന്നു; എനിക്കെതിരേ ഒത്തുകൂടിയ ഈ ദുഷ്ടസമൂഹത്തോടെല്ലാം ഞാൻ ഇപ്രകാരം ചെയ്യും. ഈ മരുഭൂമിയിൽ അവർ ഒടുങ്ങും; ഇവിടെ അവർ മരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","അങ്ങനെ ദേശം പര്യവേക്ഷണംചെയ്യാൻ മോശ അയച്ചവരും—മടങ്ങിവന്ന് അതിനെക്കുറിച്ച് അരുതാത്ത വർത്തമാനം പ്രചരിപ്പിച്ച് അദ്ദേഹത്തിനെതിരേ സഭമുഴുവനും പിറുപിറുക്കാൻ ഇടയാക്കിയവരുമായവർ— ");
INSERT INTO malc_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ദേശത്തെക്കുറിച്ച് അരുതാത്ത വർത്തമാനം പ്രചരിപ്പിച്ചതിന് ഉത്തരവാദികളായവരുമായ ഈ പുരുഷന്മാർ യഹോവയുടെമുമ്പാകെ ദണ്ഡിക്കപ്പെടുകയും ഒരു ബാധയാൽ സംഹരിക്കപ്പെടുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ദേശം പര്യവേക്ഷണംചെയ്യാൻ പോയ പുരുഷന്മാരിൽ നൂന്റെ മകൻ യോശുവയും യെഫുന്നയുടെ മകൻ കാലേബുംമാത്രം ജീവനോടെ ശേഷിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","മോശ ഇക്കാര്യം സകല ഇസ്രായേല്യരോടും അറിയിച്ചപ്പോൾ, അവർ അതികഠിനമായി വിലപിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","“ഞങ്ങൾ പാപംചെയ്തു; യഹോവ വാഗ്ദാനംചെയ്ത സ്ഥലത്തേക്കു കയറിച്ചെല്ലാൻ ഞങ്ങൾ തയ്യാറാണ്” എന്നു പറഞ്ഞ് അടുത്തദിവസം അതിരാവിലെ അവർ ഉയർന്ന മലമ്പ്രദേശത്തേക്കു കയറിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","എന്നാൽ മോശ പറഞ്ഞു: “നിങ്ങൾ എന്തിന് യഹോവയുടെ കൽപ്പന ലംഘിക്കുന്നു? ഇതു വിജയിക്കുകയില്ല! ");
INSERT INTO malc_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","കയറിപ്പോകരുത്; കാരണം യഹോവ നിങ്ങളോടുകൂടെയില്ല. ശത്രുക്കളുടെമുമ്പിൽ നിങ്ങൾ പരാജയപ്പെടും, ");
INSERT INTO malc_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","അമാലേക്യരും കനാന്യരും നിങ്ങളെ നേരിടും. യഹോവയിൽനിന്ന് നിങ്ങൾ പിന്തിരിഞ്ഞു പോയിരിക്കുകയാൽ, അവിടന്ന് നിങ്ങളോടുകൂടെ ഉണ്ടായിരിക്കുകയില്ല, നിങ്ങൾ വാളാൽ വീണുപോകും.” ");
INSERT INTO malc_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","എങ്കിലും മോശയോ യഹോവയുടെ ഉടമ്പടിയുടെ പേടകമോ പാളയത്തിൽനിന്നും പുറപ്പെടാതിരുന്നിട്ടും അവർ ധിക്കാരപൂർവം മലമുകളിലേക്കു കയറിച്ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","അപ്പോൾ ആ മലകളിൽ അധിവസിച്ചിരുന്ന അമാലേക്യരും കനാന്യരും ഇറങ്ങിവന്ന് ആക്രമിച്ച് ഹോർമാവരെ അവരെ സംഹരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","യഹോവ പിന്നെയും മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ഇസ്രായേല്യരോടു സംസാരിക്കുക. അവരോട് ഇപ്രകാരം പറയുക: ‘ഞാൻ നിങ്ങൾക്കു വസിക്കാൻ നൽകുന്ന ദേശത്തു പ്രവേശിച്ചശേഷം, ");
INSERT INTO malc_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","യഹോവയ്ക്കു പ്രസാദമുള്ള ഹൃദ്യസുഗന്ധമായി ആടുമാടുകളുടെ കൂട്ടത്തിൽനിന്ന് ഒരു ദഹനയാഗമോ ഹോമയാഗമോ പ്രത്യേക നേർച്ചകൾക്കുള്ള യാഗമോ സ്വമേധാദാനമോ ഉത്സവവഴിപാടോ അർപ്പിക്കുമ്പോൾ ");
INSERT INTO malc_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","വഴിപാട് കൊണ്ടുവരുന്നയാൾ കാൽ ഹീൻ ഒലിവെണ്ണചേർത്ത ഒരു ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗം യഹോവയ്ക്കു കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ഹോമയാഗത്തിനോ വഴിപാടിനോ ഉള്ള ഓരോ ആട്ടിൻകുട്ടിക്കും ഒപ്പം പാനീയയാഗമായി കാൽ ഹീൻ വീഞ്ഞ് കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘ആട്ടുകൊറ്റനായാൽ മൂന്നിലൊന്ന് ഹീൻ ഒലിവെണ്ണചേർത്ത രണ്ട് ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗവും ");
INSERT INTO malc_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","മൂന്നിലൊന്ന് ഹീൻ വീഞ്ഞ് പാനീയയാഗവും കൊണ്ടുവരണം. ഇത് യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘യഹോവയ്ക്ക് ഒരു ഹോമയാഗമായോ പ്രത്യേക നേർച്ചയ്ക്കുള്ള യാഗമായോ ഒരു സമാധാനയാഗമായോ ഒരു കാളക്കിടാവിനെ കൊണ്ടുവരുമ്പോൾ ");
INSERT INTO malc_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","അര ഹീൻ ഒലിവെണ്ണചേർത്ത മൂന്ന് ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗം കാളക്കിടാവിനോടൊപ്പം കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","അര ഹീൻ വീഞ്ഞ് പാനീയയാഗമായും കൊണ്ടുവരണം. അത് യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","കാളക്കിടാവ്, ആട്ടുകൊറ്റൻ, കുഞ്ഞാട്, കോലാട്ടിൻകുട്ടി എന്നിവയിൽ ഏതായാലും ഇപ്രകാരം ഒരുക്കപ്പെടണം. ");
INSERT INTO malc_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","നിങ്ങൾ അർപ്പിക്കുന്ന യാഗമൃഗത്തിനൊത്തവണ്ണം ഓരോന്നിനും ഇങ്ങനെതന്നെ ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘സ്വദേശിയായ ഓരോരുത്തരും യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായി ഒരു ദഹനയാഗം കൊണ്ടുവരുമ്പോൾ അവർ ഇവയെല്ലാം ഇങ്ങനെതന്നെ ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","വരാനുള്ള തലമുറകളിലും ഒരു പ്രവാസിയോ നിങ്ങളുടെ മധ്യേ പാർക്കുന്ന മറ്റാരെങ്കിലുമോ യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായി ഒരു ദഹനയാഗം കൊണ്ടുവരുമ്പോഴൊക്കെയും നിങ്ങൾ ചെയ്യുന്നതുപോലെതന്നെ അവരും ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","സഭയ്ക്കുമുഴുവൻ, നിങ്ങൾക്കും നിങ്ങളുടെ മധ്യേ പാർക്കുന്ന പ്രവാസിക്കും ഒരേ നിയമം ആയിരിക്കണം; തലമുറതലമുറയായി ഇത് ഒരു ശാശ്വതനിയമം. നിങ്ങളും പ്രവാസിയും യഹോവയുടെമുമ്പാകെ തുല്യരായിരിക്കും: ");
INSERT INTO malc_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","നിങ്ങൾക്കും നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പ്രവാസിക്കും വിധിയും നിയമവും ഒന്നുതന്നെ ആയിരിക്കും.’ ” ");
INSERT INTO malc_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ഇസ്രായേല്യരോടു സംസാരിക്കുക. അവരോട് ഇപ്രകാരം പറയുക: ‘ഞാൻ നിങ്ങളെ കൊണ്ടുപോകുന്ന ദേശത്ത് നിങ്ങൾ പ്രവേശിക്കുകയും ");
INSERT INTO malc_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ആ ദേശത്തിലെ ഭക്ഷണം നിങ്ങൾ കഴിക്കുകയും ചെയ്യുമ്പോൾ ഒരു അംശം യഹോവയ്ക്കു വഴിപാടായി നീക്കിവെക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","നിങ്ങളുടെ ആദ്യത്തെ പൊടിമാവിൽനിന്ന് ഒരു വട ഉണ്ടാക്കി അർപ്പിക്കുക. മെതിക്കളത്തിൽനിന്നുള്ള വിശിഷ്ടയാഗമായി അത് അർപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","വരുംതലമുറകളിലെല്ലാം നിങ്ങളുടെ ആദ്യത്തെ പൊടിമാവിൽനിന്ന് ഈ വിശിഷ്ടയാഗാർപ്പണം യഹോവയ്ക്ക് സമർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘യഹോവ മോശയ്ക്കു നൽകിയ ഈ കൽപ്പനകളിലേതെങ്കിലും അനുസരിക്കുന്നതിൽ നിങ്ങൾ അബദ്ധവശാൽ വീഴ്ചവരുത്തിയാൽ— ");
INSERT INTO malc_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","യഹോവ മോശയിൽക്കൂടെ അരുളിച്ചെയ്ത ആ നാളുമുതൽ തലമുറതലമുറയായി നിങ്ങൾ അനുസരിക്കാത്ത കൽപ്പനകൾ എല്ലാംതന്നെ— ");
INSERT INTO malc_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","നിങ്ങൾ അബദ്ധവശാൽ പിഴയ്ക്കുകയും സഭ അതിനെക്കുറിച്ച് അറിയാതിരിക്കുകയും ചെയ്താൽ സഭമുഴുവനും യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ഹോമയാഗമായി ഒരു കാളക്കിടാവിനെ അർപ്പിക്കണം. അതിനോടൊപ്പം വിധിപ്രകാരമുള്ള ഭോജനയാഗവും പാനീയയാഗവും, പാപശുദ്ധീകരണയാഗമായ ഒരു കോലാട്ടുകൊറ്റനോടൊപ്പം അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","പുരോഹിതൻ സകല ഇസ്രായേൽസഭയ്ക്കുംവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യണം. അത് അബദ്ധവശാലായിരുന്നതിനാൽ അവർക്കു ക്ഷമലഭിക്കും. അവരുടെ തെറ്റിനായി അവർ യഹോവയ്ക്ക് ഒരു ദഹനയാഗവും ഒരു പാപശുദ്ധീകരണയാഗവും കൊണ്ടുവരികയും ചെയ്തല്ലോ. ");
INSERT INTO malc_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","അങ്ങനെയെങ്കിൽ സകല ഇസ്രായേൽസഭയോടും അവരുടെ ഇടയിൽ പാർക്കുന്ന പ്രവാസികളോടും ക്ഷമിക്കും സർവജനങ്ങളും അബദ്ധവശാലുള്ള ആ പാപത്തിൽ ഉൾപ്പെട്ടിരുന്നല്ലോ. ");
INSERT INTO malc_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘എന്നാൽ കേവലം ഒരു വ്യക്തിമാത്രം അബദ്ധവശാൽ പാപംചെയ്താൽ, അയാൾ പാപശുദ്ധീകരണയാഗത്തിനായി ഒരുവയസ്സു പ്രായമുള്ള ഒരു പെണ്ണാടിനെ കൊണ്ടുവരണം. ");
INSERT INTO malc_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","അബദ്ധവശാൽ പാപം ചെയ്തവനുവേണ്ടി പുരോഹിതൻ യഹോവയുടെമുമ്പാകെ പ്രായശ്ചിത്തം ചെയ്യണം. അയാൾക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്തുകഴിയുമ്പോൾ അയാളോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","സ്വദേശിയായ ഇസ്രായേല്യരോ പ്രവാസിയോ ആകട്ടെ, അബദ്ധവശാൽ പാപംചെയ്യുന്ന ഏവനും നിയമം ഒന്നുതന്നെ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘സ്വദേശിയോ പ്രവാസിയോ മനഃപൂർവം പാപംചെയ്താൽ അയാൾ യഹോവയെ നിന്ദിക്കുന്നു. ആ മനുഷ്യനെ സ്വജനത്തിൽനിന്ന് ഛേദിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","യഹോവയുടെ വചനത്തോട് അവജ്ഞകാട്ടി അവിടത്തെ കൽപ്പന ലംഘിച്ചിരിക്കുകയാൽ, അയാൾ നിശ്ചയമായും ഛേദിക്കപ്പെടണം; അയാളുടെ അകൃത്യം അയാളുടെമേൽ നിൽക്കും.’ ” ");
INSERT INTO malc_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ഇസ്രായേല്യർ മരുഭൂമിയിലായിരിക്കുമ്പോൾ, ശബ്ബത്തുദിവസത്തിൽ ഒരു മനുഷ്യൻ വിറകുപെറുക്കുന്നതുകണ്ടു. ");
INSERT INTO malc_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","അയാൾ വിറകു പെറുക്കുന്നതു കണ്ടവർ അയാളെ മോശയുടെയും അഹരോന്റെയും സർവസഭയുടെയും മുമ്പാകെ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ആ മനുഷ്യനോട് എന്തുചെയ്യണമെന്നു വ്യക്തമല്ലാതിരുന്നതിനാൽ അവർ അയാളെ തടങ്കലിൽ വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","അതിനുശേഷം യഹോവ മോശയോട് അരുളിച്ചെയ്തു: “ആ മനുഷ്യൻ മരിക്കണം. സർവസഭയും അയാളെ പാളയത്തിനു പുറത്തുവെച്ചു കല്ലെറിയണം.” ");
INSERT INTO malc_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","അങ്ങനെ സഭ അയാളെ പാളയത്തിനുപുറത്തു കൊണ്ടുപോയി. യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ കല്ലെറിഞ്ഞുകൊന്നു. ");
INSERT INTO malc_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","യഹോവ മോശയോട് അരുളിച്ചെയ്തു, ");
INSERT INTO malc_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ഇസ്രായേല്യരോടു സംസാരിക്കുക അവരോട് ഇപ്രകാരം പറയുക: ‘വരുംതലമുറകളിലൊക്കെയും നിങ്ങൾ നിങ്ങളുടെ വസ്ത്രങ്ങളുടെ കോണുകളിൽ തൊങ്ങലുകൾ ഉണ്ടാക്കണം. ഓരോ തൊങ്ങലിലും ഓരോ നീലനൂൽ ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ഈ തൊങ്ങലുകളിന്മേൽ നോക്കുമ്പോൾ നിങ്ങൾ യഹോവയുടെ സകലകൽപ്പനകളും ഓർക്കാനും അങ്ങനെ നിങ്ങളുടെ ഹൃദയങ്ങളുടെയും കണ്ണുകളുടെയും മോഹങ്ങൾക്കു പിന്നാലെപോയി നിങ്ങൾതന്നെ പരസംഗം ചെയ്യാതിരിക്കാനും അവ നിങ്ങൾക്ക് ഉപകരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","അങ്ങനെ നിങ്ങൾ എന്റെ സകലകൽപ്പനകളും അനുസരിക്കാൻ ഓർക്കുകയും നിങ്ങൾ നിങ്ങളുടെ ദൈവത്തിനു വിശുദ്ധർ ആയിരിക്കുകയും ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","നിങ്ങളുടെ ദൈവമായിരിക്കേണ്ടതിനു നിങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്ന, നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു ഞാൻ. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു.’ ” ");
INSERT INTO malc_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ലേവിയുടെ മകനായ കെഹാത്തിന്റെ മകനായ യിസ്ഹാരിന്റെ മകൻ കോരഹും രൂബേന്യരിൽ ചിലരും—എലീയാബിന്റെ പുത്രന്മാരായ ദാഥാനും അബീരാമും പേലെത്തിന്റെ മകൻ ഓനും—ധിക്കാരികളായി ");
INSERT INTO malc_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","മോശയ്ക്കു വിരോധമായി എഴുന്നേറ്റു. അവരോടൊപ്പം ഇസ്രായേലിലെ ഇരുനൂറ്റി അൻപത് സഭാനായകന്മാരും ഉണ്ടായിരുന്നു. അവരെല്ലാവരും സഭയിലെ പ്രധാന അംഗങ്ങളും ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","മോശയ്ക്കും അഹരോനും എതിരേ ഒരു സംഘമായി അവർ വന്ന് അവരോടു പറഞ്ഞു: “നിങ്ങൾ വളരെ അതിരുകടക്കുന്നു! സർവസഭയും അവരിൽ ഓരോരുത്തരും യഹോവയ്ക്കു വിശുദ്ധരാണ്. അവിടന്ന് അവരോടുകൂടെയുണ്ട്. പിന്നെ യഹോവയുടെ സർവസഭയ്ക്കും മീതേ നിങ്ങൾ നിങ്ങളെത്തന്നെ ഉയർത്തുന്നതെന്ത്?” ");
INSERT INTO malc_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ആ സംഘം പറയുന്നത് മോശ കേട്ടപ്പോൾ അദ്ദേഹം കമിഴ്ന്നുവീണു. ");
INSERT INTO malc_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ഇതിനുശേഷം മോശ കോരഹിനോടും അയാളുടെ അനുയായികളോടും പറഞ്ഞു: “പ്രഭാതത്തിൽ യഹോവ, അവിടത്തേക്കുള്ളവർ ആരെന്നും വിശുദ്ധൻ ആരെന്നും കാണിക്കും; അവിടന്ന് ആ വ്യക്തിയെ തന്റെ അടുക്കൽ വരുമാറാക്കും. അവിടന്ന് തെരഞ്ഞെടുക്കുന്ന പുരുഷനെ തന്റെ അടുക്കൽ വരുമാറാക്കും. ");
INSERT INTO malc_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","കോരഹേ, നീയും നിന്റെ സകല അനുയായികളും ഇതു ചെയ്യുക: ധൂപകലശങ്ങൾ എടുത്ത് ");
INSERT INTO malc_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","നാളെ യഹോവയുടെമുമ്പാകെ അതിൽ തീ കത്തിച്ച് സുഗന്ധദ്രവ്യങ്ങൾ ഇടുക. യഹോവ തെരഞ്ഞെടുക്കുന്ന പുരുഷനായിരിക്കും വിശുദ്ധൻ. ലേവ്യരേ, നിങ്ങൾ വളരെ അതിരുകടക്കുന്നു!” ");
INSERT INTO malc_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","കോരഹിനോടു മോശ വീണ്ടും പറഞ്ഞു: “ലേവ്യരേ, നിങ്ങൾ ഇപ്പോൾ ശ്രദ്ധിക്കുക! ");
INSERT INTO malc_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ഇസ്രായേലിന്റെ ദൈവം നിങ്ങളെ ഇസ്രായേൽസഭയിലെ മറ്റുള്ളവരിൽനിന്നു വേർതിരിച്ച് യഹോവയുടെ കൂടാരത്തിൽ വേലചെയ്യാൻ അവിടത്തെ അടുക്കലേക്കു കൊണ്ടുവന്നതും സമൂഹത്തിനു ശുശ്രൂഷചെയ്യാൻ അവരുടെമുമ്പിൽ നിർത്തിയതും പോരേ? ");
INSERT INTO malc_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","അവിടന്ന് നിന്നെയും ലേവ്യരായ നിന്റെ സകലസഹോദരന്മാരെയും അവിടത്തെ അടുക്കൽ കൊണ്ടുവന്നു. എന്നാൽ ഇപ്പോൾ നിങ്ങൾ പൗരോഹിത്യംകൂടെ എടുക്കാൻ ശ്രമിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","നീയും നിന്റെ സകല അനുയായികളും സംഘം ചേർന്നിരിക്കുന്നത് യഹോവയ്ക്കു വിരോധമായിട്ടാണ്. നിങ്ങൾ അഹരോനെതിരേ പിറുപിറുക്കേണ്ടതിന് അദ്ദേഹം എന്തുള്ളൂ?” ");
INSERT INTO malc_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ഇതിനുശേഷം മോശ എലീയാബിന്റെ പുത്രന്മാരായ ദാഥാനെയും അബീരാമിനെയും വിളിക്കാൻ ആളയച്ചു. എന്നാൽ അവർ, “ഞങ്ങൾ വരികയില്ല!” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","അവർ തുടർന്നു, “മരുഭൂമിയിൽ ഞങ്ങളെ കൊല്ലേണ്ടതിന് പാലും തേനും ഒഴുകുന്ന ദേശത്തുനിന്ന് നീ ഞങ്ങളെ കൊണ്ടുവന്നതു പോരേ? ഇപ്പോൾ ഞങ്ങളുടെമേൽ കർത്തൃത്വം നടത്താനും നീ ആഗ്രഹിക്കുന്നോ! ");
INSERT INTO malc_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","അത്രയുമല്ല, നീ ഞങ്ങളെ പാലും തേനും ഒഴുകുന്ന ഒരു ദേശത്തു കൊണ്ടുവരികയോ വയലുകളോ മുന്തിരിത്തോപ്പുകളോ അവകാശമായിത്തരികയോ ചെയ്തതുമില്ല. നീ ഈ പുരുഷന്മാരെ വിഡ്ഢികളാക്കാൻ ശ്രമിക്കുകയാണോ? ഇല്ല, ഞങ്ങൾ വരികയില്ല!” ");
INSERT INTO malc_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","അപ്പോൾ മോശ അത്യന്തം കോപിച്ചു. അദ്ദേഹം യഹോവയോട്, “അവരുടെ വഴിപാട് അംഗീകരിക്കരുതേ. ഒരു കഴുതയെപ്പോലും ഞാൻ അവരിൽനിന്ന് എടുത്തിട്ടില്ല. അവരിലാരോടും ഞാൻ ഒരുതെറ്റും ചെയ്തിട്ടുമില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","മോശ കോരഹിനോട് പറഞ്ഞു: “നാളെ നീയും നിന്റെ സകല അനുയായികളും യഹോവയുടെമുമ്പാകെ വരണം—നീയും അവരും അഹരോനുംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","നിങ്ങൾ ഓരോരുത്തരും അവരവരുടെ ധൂപകലശമെടുത്ത് അതിൽ സുഗന്ധവർഗം ഇട്ട് യഹോവയുടെ സന്നിധിയിൽ കൊണ്ടുവരണം—ആകെ ഇരുനൂറ്റി അൻപത് ധൂപകലശങ്ങൾ. നീയും അഹരോനും നിങ്ങളുടെ ധൂപകലശങ്ങൾ കൊണ്ടുവരണം.” ");
INSERT INTO malc_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","അങ്ങനെ സകലപുരുഷന്മാരും അവരവരുടെ ധൂപകലശമെടുത്ത് തീ കത്തിച്ച് സുഗന്ധവർഗം ഇട്ട് മോശയോടും അഹരോനോടുംകൂടെ സമാഗമകൂടാരവാതിൽക്കൽ നിന്നു. ");
INSERT INTO malc_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ഇതിനിടയിൽ കോരഹ്, മോശയ്ക്കും അഹരോനും എതിരേ ഇസ്രായേൽസഭയെ മുഴുവനും ഇളക്കിവിട്ട്, അവരെ സമാഗമകൂടാരവാതിൽക്കൽ കൂട്ടി. അപ്പോൾ, യഹോവയുടെ തേജസ്സ് സർവസഭയ്ക്കും പ്രത്യക്ഷമായി. ");
INSERT INTO malc_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","യഹോവ മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ഇപ്പോൾത്തന്നെ ഞാൻ ഇവരെ സംഹരിക്കേണ്ടതിന് ഈ സംഘത്തിന്റെയടുത്തുനിന്നു നിങ്ങൾ ഉടൻതന്നെ മാറുക.” ");
INSERT INTO malc_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","എന്നാൽ മോശയും അഹരോനും സാഷ്ടാംഗം വീണു നിലവിളിച്ചു: “ദൈവമേ, സകലമനുഷ്യരുടെയും ആത്മാക്കളുടെ ദൈവമായുള്ളോവേ, ഒരാൾ പാപംചെയ്താൽ അവിടന്ന് മുഴുസഭയോടും കോപിക്കുമോ?” ");
INSERT INTO malc_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","അപ്പോൾ യഹോവ മോശയോടു പറഞ്ഞു: ");
INSERT INTO malc_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ ‘കോരഹ്, ദാഥാൻ, അബീരാം എന്നിവരുടെ കൂടാരങ്ങളിൽനിന്ന് മാറിനിൽക്കാൻ,’ സഭയോടു പറയുക.” ");
INSERT INTO malc_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","മോശ എഴുന്നേറ്റ് ദാഥാന്റെയും അബീരാമിന്റെയും അടുത്തേക്കുപോയി. ഇസ്രായേല്യ ഗോത്രത്തലവന്മാർ അദ്ദേഹത്തെ അനുഗമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ഉടൻതന്നെ മോശ സഭയ്ക്കു മുന്നറിയിപ്പു നൽകി: “ഇവരുടെ സകലപാപങ്ങളുംനിമിത്തം നിങ്ങൾ നശിക്കാതിരിക്കേണ്ടതിന് ഈ ദുഷ്ടമനുഷ്യരുടെ കൂടാരങ്ങളെ വിട്ടുമാറുക! ഇവർക്കുള്ള യാതൊന്നും സ്പർശിക്കരുത്.” ");
INSERT INTO malc_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","അങ്ങനെ അവർ കോരഹിന്റെയും ദാഥാന്റെയും അബീരാമിന്റെയും കൂടാരങ്ങളിൽനിന്ന് അകന്നുമാറി. ദാഥാനും അബീരാമും വെളിയിൽവന്ന് അവരുടെ ഭാര്യമാരോടും മക്കളോടും കുഞ്ഞുകുട്ടികളോടുംകൂടെ അവരുടെ കൂടാരങ്ങളുടെ വാതിൽക്കൽ നിൽക്കുകയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ഇതിനുശേഷം മോശ പറഞ്ഞത്, “ഇക്കാര്യങ്ങളെല്ലാം ചെയ്യാൻ യഹോവ എന്നെ അയച്ചു എന്നും ഞാൻ സ്വയമായി ഒന്നും ചെയ്തിട്ടില്ല എന്നും നിങ്ങൾ അറിയുന്നത് ഇപ്രകാരമായിരിക്കും: ");
INSERT INTO malc_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","എല്ലാ മനുഷ്യർക്കും സംഭവിക്കുന്നതുപോലെ ഇവർക്കു സംഭവിക്കുകയും ഇവർ സ്വാഭാവികമരണം അനുഭവിക്കുകയും ചെയ്യുന്നെങ്കിൽ യഹോവ എന്നെ അയച്ചിട്ടില്ല. ");
INSERT INTO malc_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","എന്നാൽ യഹോവ ഒരു അപൂർവകാര്യം ചെയ്ത്, ഭൂമി വായ്‌പിളർന്ന് അവർക്കുള്ള സകലത്തോടുംകൂടെ അവരെ വിഴുങ്ങി, അവർ ജീവനോടെ പാതാളത്തിലേക്കു പോയാൽ, ഈ പുരുഷന്മാർ യഹോവയോടു ധിക്കാരമായി പെരുമാറി എന്നു നിങ്ങൾ അറിയും.” ");
INSERT INTO malc_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","മോശ ഈ വാക്കുകൾ പറഞ്ഞുതീർന്നപ്പോൾ അവരുടെകീഴേയുള്ള ഭൂമി പിളർന്നുമാറി. ");
INSERT INTO malc_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ഭൂമി വായ്‌പിളർന്ന് അവരെയും അവരുടെ കുടുംബങ്ങളെയും കോരഹിന്റെ സകല അനുയായികളെയും അവരുടെ സർവ സമ്പത്തിനെയും വിഴുങ്ങിക്കളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","അവർ തങ്ങൾക്കുണ്ടായിരുന്ന സകലത്തോടുംകൂടെ ജീവനോടെ പാതാളത്തിലേക്കു താണുപോയി; ഭൂമി അവർക്കുമീതേ അടഞ്ഞു. സഭാമധ്യേനിന്നും അവർ നശിച്ചുപോയി. ");
INSERT INTO malc_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","അവരുടെ നിലവിളികേട്ട്, “ഭൂമി ഞങ്ങളെയും വിഴുങ്ങരുതേ” എന്നു പറഞ്ഞ്, ചുറ്റുംനിന്ന ഇസ്രായേല്യർ മുഴുവനും ഓടിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","യഹോവയിൽനിന്ന് അഗ്നി പുറപ്പെട്ടു. ധൂപം കാട്ടിയ 250 പുരുഷന്മാരെയും ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ഇതിനുശേഷം യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“പുരോഹിതനായ അഹരോന്റെ പുത്രൻ എലെയാസാരിനോടു പറയുക, എരിഞ്ഞുകൊണ്ടിരിക്കുന്ന അവശിഷ്ടങ്ങളുടെ ഇടയിൽനിന്ന് ധൂപകലശങ്ങൾ എടുത്ത് കനൽ ദൂരെക്കളയുക. കാരണം ധൂപകലശങ്ങൾ വിശുദ്ധമാണ്. ");
INSERT INTO malc_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","പാപംചെയ്തു സ്വന്തപ്രാണൻ നഷ്ടപ്പെടുത്തിയ ആ പുരുഷന്മാരുടെ ധൂപകലശങ്ങൾ, യാഗപീഠം പൊതിയുന്നതിന് തകിടുകളായി അടിച്ചുപരത്തുക. അവ യഹോവയുടെമുമ്പിൽ അർപ്പിക്കപ്പെട്ടതിനാൽ വിശുദ്ധമാണ്. അത് ഇസ്രായേല്യർക്ക് ഒരു ചിഹ്നമായിരിക്കട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","അങ്ങനെ പുരോഹിതനായ എലെയാസാർ, അഗ്നിക്കിരയായവർ കൊണ്ടുവന്നിരുന്ന വെങ്കലംകൊണ്ടുള്ള ധൂപകലശങ്ങൾ ശേഖരിച്ച് യാഗപീഠം പൊതിയേണ്ടതിനായി അടിച്ചുപരത്തി; യഹോവ മോശമുഖാന്തരം അദ്ദേഹത്തോടു നിർദേശിച്ചതുപോലെതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","കോരഹിനെയും അയാളുടെ അനുയായികളെയുംപോലെ ആയിത്തീരാതിരിക്കേണ്ടതിന് അഹരോന്റെ സന്തതികളിൽ ഒരുവനല്ലാതെ ആരും യഹോവയുടെമുമ്പാകെ ധൂപവർഗം കത്തിക്കാൻ മുന്നോട്ടുവരരുതെന്ന് ഇസ്രായേൽമക്കളെ ഓർമപ്പെടുത്താനായിരുന്നു ഇത്. ");
INSERT INTO malc_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","അടുത്തദിവസം ഇസ്രായേൽസമൂഹം മുഴുവനും മോശയ്ക്കും അഹരോനും എതിരായി പിറുപിറുത്തു. “നിങ്ങൾ യഹോവയുടെ ജനത്തെ കൊന്നു” എന്ന് അവർ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","എന്നാൽ സഭ മോശയ്ക്കും അഹരോനും എതിരായി സംഘടിച്ച് സമാഗമകൂടാരത്തിലേക്കടുത്തു. അപ്പോൾത്തന്നെ മേഘം അതിനെ മൂടിയിട്ട് യഹോവയുടെ തേജസ്സ് പ്രത്യക്ഷമായി. ");
INSERT INTO malc_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","അപ്പോൾ മോശയും അഹരോനും സമാഗമകൂടാരത്തിന്റെ മുമ്പിലേക്കു ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ഇപ്പോൾത്തന്നെ ഞാൻ അവരെ നശിപ്പിക്കേണ്ടതിന് ഈ സഭയിൽനിന്ന് മാറിപ്പോകുക.” അപ്പോൾ അവർ കമിഴ്ന്നുവീണു. ");
INSERT INTO malc_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ഇതിനുശേഷം മോശ അഹരോനോടു പറഞ്ഞു: “നിന്റെ ധൂപകലശമെടുത്ത് യാഗപീഠത്തിലെ അഗ്നിയോടുകൂടെ അതിൽ സുഗന്ധവർഗം ഇട്ട്, അവർക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്യാൻ വേഗത്തിൽ സഭയിലേക്കു ചെല്ലുക. യഹോവയിൽനിന്ന് കോപം പുറപ്പെട്ടിരിക്കുന്നു; ബാധ തുടങ്ങിക്കഴിഞ്ഞു.” ");
INSERT INTO malc_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ആകയാൽ അഹരോൻ മോശ പറഞ്ഞതുപോലെ ചെയ്ത് സഭാമധ്യത്തിലേക്ക് ഓടിച്ചെന്നു. ജനത്തിന്റെ ഇടയിൽ ബാധ തുടങ്ങിക്കഴിഞ്ഞിരുന്നു. എങ്കിലും അഹരോൻ ധൂപം അർപ്പിച്ച് അവർക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","അദ്ദേഹം ജീവനുള്ളവരുടെയും മരിച്ചവരുടെയും ഇടയിൽനിന്നപ്പോൾ ബാധ നിന്നു. ");
INSERT INTO malc_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","എങ്കിലും കോരഹ് നിമിത്തം മരിച്ചവരെക്കൂടാതെ 14,700 ആളുകൾ ബാധയാൽ മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ബാധ നിന്നതിനാൽ അഹരോൻ സമാഗമകൂടാരവാതിലിനു മുമ്പിൽ മോശയുടെ അടുത്തേക്കു മടങ്ങിവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","യഹോവ പിന്നെയും മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ഇസ്രായേല്യരോടു സംസാരിച്ച്, അവരുടെ ഓരോ പിതൃഭവനത്തലവന്മാരിൽനിന്നും ഓരോ വടിവീതം പന്ത്രണ്ടു വടികൾ വാങ്ങുക. ഓരോ പുരുഷന്റെയും പേര് അദ്ദേഹത്തിന്റെ വടിയിൽ എഴുതുക. ");
INSERT INTO malc_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ലേവിയുടെ വടിയിൽ അഹരോന്റെ പേരെഴുതുക; കാരണം ഓരോ പിതൃഭവനത്തലവനും ഓരോ വടി ഉണ്ടായിരിക്കണമല്ലോ. ");
INSERT INTO malc_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","സമാഗമകൂടാരത്തിൽ ഞാൻ നിങ്ങൾക്കു വെളിപ്പെടുന്ന ഉടമ്പടിയുടെ പേടകത്തിനുമുമ്പാകെ അവയെ നിങ്ങൾ വെക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ഞാൻ തെരഞ്ഞെടുക്കുന്ന പുരുഷന്റെ വടി മുളയ്ക്കുകയും നിനക്കെതിരേ സ്ഥിരമായുള്ള ഇസ്രായേല്യരുടെ ഈ പിറുപിറുപ്പ് ഞാൻ ഇല്ലാതാക്കുകയും ചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","അങ്ങനെ മോശ ഇസ്രായേല്യരോടു സംസാരിച്ചു; അവരുടെ ഓരോ പിതൃഭവനത്തലവനുംവേണ്ടി ഓരോന്നു വീതം പന്ത്രണ്ടു വടികൾ അവരുടെ പ്രഭുക്കന്മാർ അദ്ദേഹത്തിനു നൽകി. അതിൽ അഹരോന്റെ വടിയും ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","മോശ ഉടമ്പടിയുടെ കൂടാരത്തിൽ യഹോവയുടെമുമ്പാകെ വടികൾ വെച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","അടുത്തദിവസം മോശ ഉടമ്പടിയുടെ കൂടാരത്തിൽ കടന്ന് ലേവിഗൃഹത്തെ പ്രതിനിധാനം ചെയ്യുന്ന അഹരോന്റെ വടി നോക്കി; അതു മുളയ്ക്കുകമാത്രമല്ല, തളിർത്ത്, പൂത്ത്, ബദാംഫലം കായ്ച്ചിരിക്കുന്നതായി കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ഇതിനുശേഷം മോശ യഹോവയുടെ സന്നിധിയിൽനിന്ന് വടികൾ ഇസ്രായേല്യരുടെ അടുക്കൽ പുറത്തുകൊണ്ടുവന്നു. ഓരോരുത്തരും അവരവരുടെ വടി നോക്കിയെടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","യഹോവ മോശയോടു പറഞ്ഞു: “മത്സരികൾക്ക് ഒരു ചിഹ്നമായി സൂക്ഷിക്കേണ്ടതിന് അഹരോന്റെ വടി തിരികെ ഉടമ്പടിയുടെ പേടകത്തിനുമുമ്പാകെ വെക്കുക. ഇത് എനിക്കെതിരേയുള്ള അവരുടെ പിറുപിറുപ്പിന് അറുതിവരുത്തും, അങ്ങനെ അവർ മരിക്കാതെയിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","യഹോവ തന്നോടു കൽപ്പിച്ചതുപോലെതന്നെ മോശ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ഇസ്രായേല്യർ മോശയോടു പറഞ്ഞു: “ഞങ്ങൾ മരിച്ചുപോകും, ഞങ്ങൾ നശിക്കുന്നു, ഞങ്ങളെല്ലാം നശിച്ചുപോകുന്നു! ");
INSERT INTO malc_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","യഹോവയുടെ കൂടാരത്തിന്റെ സമീപത്ത് വരുന്നവർപോലും മരിക്കും. ഞങ്ങളെല്ലാവരും മരണത്തിനു വിധിക്കപ്പെട്ടവരോ?” ");
INSERT INTO malc_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","പിന്നീട് യഹോവ അഹരോനോട് അരുളിച്ചെയ്തു: “വിശുദ്ധമന്ദിരത്തിന് എതിരേയുള്ള അതിക്രമങ്ങൾക്കു നീയും നിന്റെ പുത്രന്മാരും നിന്റെ പിതൃഭവനവും ഉത്തരവാദികളായിരിക്കും. പൗരോഹിത്യം സംബന്ധിച്ചുള്ള അകൃത്യങ്ങൾക്കു നീയും നിന്റെ പുത്രന്മാരുംമാത്രം ഉത്തരവാദികളായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","നീയും നിന്റെ പുത്രന്മാരും ഉടമ്പടിയുടെ കൂടാരത്തിനുമുമ്പിൽ ശുശ്രൂഷചെയ്യുമ്പോൾ നിങ്ങളോടു ചേർന്ന് നിങ്ങളെ സഹായിക്കുന്നതിനായി നിന്റെ പിതൃഗോത്രമായ ലേവിഗോത്രത്തിലുള്ള നിന്റെ സഹോദരന്മാരെയും കൊണ്ടുവരിക. ");
INSERT INTO malc_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","നിങ്ങൾ അവർക്കു മേൽവിചാരകരായിരിക്കുകയും അവർതന്നെ കൂടാരത്തിലെ ചുമതലകൾ എല്ലാം നിർവഹിക്കുകയും വേണം. എന്നാൽ അവരും നിങ്ങളും മരിക്കാതിരിക്കേണ്ടതിനു വിശുദ്ധമന്ദിരത്തിലെ ഉപകരണങ്ങൾ, യാഗപീഠം എന്നിവയെ അവർ സമീപിക്കരുത്. ");
INSERT INTO malc_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","അവർ നിങ്ങളോടു ചേർന്ന് സമാഗമകൂടാരത്തിന്റെ പരിചരണത്തിലും കൂടാരത്തിലെ സകലവേലയ്ക്കും ഉത്തരവാദികളായിരിക്കണം; എന്നാൽ മറ്റാരും സഹായിക്കുന്നതിനായി നിങ്ങളുടെ അടുക്കൽ വരരുത്. ");
INSERT INTO malc_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“ഇസ്രായേല്യരുടെമേൽ യഹോവയുടെ ക്രോധം വീണ്ടും വരാതിരിക്കേണ്ടതിനു നിങ്ങൾ വിശുദ്ധമന്ദിരത്തിന്റെയും യാഗപീഠത്തിന്റെയും പരിചരണത്തിന്റെ ഉത്തരവാദികളായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ഇസ്രായേല്യരുടെ ഇടയിൽനിന്നും നിങ്ങളുടെ സഹോദരന്മാരായ ലേവ്യരെ ഞാൻതന്നെ തെരഞ്ഞെടുത്തിരിക്കുന്നു. സമാഗമകൂടാരത്തിലെ ശുശ്രൂഷയ്ക്കുവേണ്ടി യഹോവ അവരെ നിങ്ങൾക്കൊരു ദാനമായി നൽകിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","എന്നാൽ യാഗപീഠത്തിലും തിരശ്ശീലയ്ക്കകത്തും ഉള്ള പൗരോഹിത്യശുശ്രൂഷകൾ എല്ലാം നീയും നിന്റെ പുത്രന്മാരുംമാത്രമേ ചെയ്യാൻ പാടുള്ളൂ. പൗരോഹിത്യശുശ്രൂഷ ഞാൻ നിങ്ങൾക്ക് ഒരു ദാനമായി നൽകിയിരിക്കുന്നു. വിശുദ്ധമന്ദിരത്തോടടുക്കുന്ന മറ്റേതൊരുമനുഷ്യനും മരണശിക്ഷനൽകണം.” ");
INSERT INTO malc_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ഇതിനുശേഷം യഹോവ അഹരോനോട് അരുളിച്ചെയ്തു: “ഇസ്രായേൽമക്കൾ എനിക്കു സമർപ്പിക്കുന്ന യാഗങ്ങളുടെ ഉത്തരവാദിത്വം ഞാൻതന്നെ നിന്നെ ഭരമേൽപ്പിച്ചിരിക്കുന്നു; ഇസ്രായേല്യർ എനിക്കു തരുന്ന സകലവിശുദ്ധയാഗങ്ങളും നിനക്കും നിന്റെ പുത്രന്മാർക്കും ഓഹരിയായും ശാശ്വതാവകാശമായും തന്നിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","തീയിൽ ദഹിപ്പിക്കാത്ത അതിവിശുദ്ധയാഗങ്ങളുടെ ഭാഗം നിനക്കായിരിക്കണം. ഭോജനയാഗമോ പാപശുദ്ധീകരണയാഗമോ അകൃത്യയാഗമോ ആകട്ടെ, അതിവിശുദ്ധയാഗാർപ്പണമായി അവർ എനിക്കു കൊണ്ടുവരുന്ന സകലകാഴ്ചകളിൽനിന്നും, ആ ഭാഗം നിനക്കും നിന്റെ പുത്രന്മാർക്കും ഉള്ളതായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","അതിവിശുദ്ധമായതൊന്ന് എന്നപോലെ അതു ഭക്ഷിക്കണം; സകല ആണിനും അതു ഭക്ഷിക്കാം. നിങ്ങൾ അതിനെ വിശുദ്ധമായി കരുതണം. ");
INSERT INTO malc_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ഇതുംകൂടെ നിനക്കുള്ളതായിരിക്കും: ഇസ്രായേല്യരുടെ സകലവിശിഷ്ടയാഗാർപ്പണങ്ങളുടെയും കാഴ്ചകളിൽനിന്ന് മാറ്റിവെക്കുന്നതെല്ലാം ഞാൻ നിനക്കും നിന്റെ പുത്രന്മാർക്കും പുത്രിമാർക്കും നിങ്ങളുടെ നിത്യേനയുള്ള ഓഹരിയായിത്തന്നിരിക്കുന്നു. നിന്റെ ഭവനത്തിൽ ആചാരപരമായി വിശുദ്ധിയുള്ളവർക്കെല്ലാം അതു ഭക്ഷിക്കാം. ");
INSERT INTO malc_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“അവർ യഹോവയ്ക്ക് ആദ്യഫലമായി കൊടുക്കുന്ന ഏറ്റവും വിശിഷ്ടമായ ഒലിവെണ്ണ മുഴുവനും ഏറ്റവും വിശിഷ്ടമായ പുതുവീഞ്ഞു മുഴുവനും ധാന്യവും ഞാൻ നിനക്കു തരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","അവർ യഹോവയ്ക്കു കൊണ്ടുവരുന്ന നിലത്തിന്റെ ആദ്യഫലം സകലതും നിന്റേതായിരിക്കും. നിന്റെ ഭവനത്തിൽ വിശുദ്ധിയുള്ള എല്ലാവർക്കും അതു ഭക്ഷിക്കാം. ");
INSERT INTO malc_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ഇസ്രായേലിൽ യഹോവയ്ക്ക് അർപ്പിച്ചിരിക്കുന്ന സകലതും നിന്റേതാണ്. ");
INSERT INTO malc_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","മനുഷ്യനിലും മൃഗങ്ങളിലും യഹോവയ്ക്ക് അർപ്പിതമായ കടിഞ്ഞൂലായ ആണൊക്കെയും നിനക്കുള്ളതാണ്. എന്നാൽ മനുഷ്യന്റെ ആദ്യജാതന്മാരൊക്കെയും അശുദ്ധമൃഗങ്ങളുടെ കടിഞ്ഞൂലായ ആണിനെ ഒക്കെയും നീ വീണ്ടെടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","അവയ്ക്ക് ഒരുമാസം പ്രായമുള്ളപ്പോൾ, അവയുടെ വീണ്ടെടുപ്പുവിലയായ ഇരുപതു ഗേരയ്ക്കു സമമായ വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരമുള്ള അഞ്ചുശേക്കേൽ വെള്ളികൊണ്ട് അവയെ വീണ്ടെടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“എന്നാൽ പശുവിന്റെയോ ആടിന്റെയോ കോലാടിന്റെയോ കടിഞ്ഞൂലിനെ വീണ്ടെടുക്കരുത്; അവ വിശുദ്ധമാകുന്നു. അവയുടെ രക്തം യാഗപീഠത്തിന്മേൽ തളിക്കുകയും മേദസ്സ് യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗമായി ദഹിപ്പിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","വിശിഷ്ടയാഗാർപ്പണത്തിന്റെ നെഞ്ചും വലതുതുടയും നിന്റേതായിരിക്കുന്നതുപോലെതന്നെ അവയുടെ മാംസവും നിനക്കായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ഇസ്രായേല്യർ യഹോവയ്ക്ക് അർപ്പിക്കുന്ന വിശുദ്ധയാഗങ്ങളിൽനിന്നു മാറ്റിവെക്കുന്നതൊക്കെയും ഞാൻ നിനക്കും നിന്റെ പുത്രന്മാർക്കും പുത്രിമാർക്കും നിങ്ങളുടെ ശാശ്വതാവകാശമായിത്തരുന്നു. ഇതു നിനക്കും നിന്റെ സന്തതിക്കും യഹോവയുടെമുമ്പാകെ ശാശ്വതമായ ലവണയുടമ്പടി ആയിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","യഹോവ അഹരോനോട് അരുളിച്ചെയ്തു: “നിനക്ക് അവരുടെ ഭൂമിയിൽ ഒരു അവകാശവും അവരുടെ ഇടയിൽ യാതൊരു ഓഹരിയും ഉണ്ടായിരിക്കുകയില്ല. ഇസ്രായേൽമക്കളുടെ ഇടയിൽ ഞാൻ ആകുന്നു നിന്റെ അവകാശവും നിന്റെ ഓഹരിയും. ");
INSERT INTO malc_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“സമാഗമകൂടാരത്തിൽ ശുശ്രൂഷിക്കുമ്പോൾ ചെയ്യുന്ന വേലയ്ക്കു പകരമായി ഞാൻ ലേവ്യർക്ക് ഇസ്രായേലിലെ ദശാംശം മുഴുവനും അവകാശമായി നൽകുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ഇനിമുതൽ പുരോഹിതന്മാരും ലേവ്യരുമൊഴികെ ഇസ്രായേൽമക്കളിൽ ആരുംതന്നെ സമാഗമകൂടാരത്തിന്റെ അടുക്കൽ ചെല്ലരുത്. മറിച്ചായാൽ അവരെ കുറ്റക്കാരായി വിധിക്കുകയും മരണശിക്ഷയേൽക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","സമാഗമകൂടാരത്തിൽ വേല ചെയ്യേണ്ടതും അതിനെതിരേ ചെയ്യുന്ന നിയമലംഘനത്തിന് അകൃത്യം വഹിക്കേണ്ടതും ലേവ്യരാണ്. ഇതു വരാനുള്ള തലമുറകൾക്ക് ഒരു ശാശ്വതനിയമമായിരിക്കും. അവർക്ക് ഇസ്രായേൽമക്കളുടെ ഇടയിൽ ഒരവകാശവും ഉണ്ടായിരിക്കുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","എന്നാൽ ഇസ്രായേൽമക്കൾ യഹോവയ്ക്കു യാഗമായി അർപ്പിക്കുന്ന ദശാംശം ഞാൻ ലേവ്യർക്ക് അവകാശമായി നൽകുന്നു. അതുകൊണ്ടാണ് ‘അവർക്ക് ഇസ്രായേല്യരുടെ ഇടയിൽ ഒരവകാശവും ഉണ്ടായിരിക്കുകയില്ല,’ എന്നു ഞാൻ കൽപ്പിച്ചത്.” ");
INSERT INTO malc_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","യഹോവ പിന്നെയും മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ലേവ്യരോടു സംസാരിക്കുക. അവരോട് ഇപ്രകാരം പറയുക: ‘ഞാൻ നിങ്ങൾക്ക് അവകാശമായിത്തരുന്ന ദശാംശം ഇസ്രായേൽമക്കളിൽനിന്നു ലഭിക്കുമ്പോൾ, ആ ദശാംശത്തിന്റെ പത്തിലൊന്ന് യഹോവയ്ക്കു യാഗമായി അർപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","നിങ്ങളുടെ യാഗം മെതിക്കളത്തിൽനിന്നുള്ള ധാന്യംപോലെയും മുന്തിരിച്ചക്കിൽനിന്നുള്ള മുന്തിരിച്ചാർപോലെയും നിങ്ങൾക്കു കണക്കാക്കും. ");
INSERT INTO malc_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","നിങ്ങൾക്ക് ഇസ്രായേല്യരിൽനിന്നു ലഭിക്കുന്ന ദശാംശത്തിൽനിന്നെല്ലാം ഇപ്രകാരം നിങ്ങളും യഹോവയ്ക്ക് ഒരു യാഗം അർപ്പിക്കണം. ഈ ദശാംശങ്ങളിൽനിന്നുള്ള യഹോവയുടെ പങ്ക് നിങ്ങൾ പുരോഹിതനായ അഹരോനു കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","നിങ്ങൾക്കു നൽകപ്പെട്ട സകലത്തിൽനിന്നും ഉത്തമവും വിശുദ്ധവുമായ ഭാഗം വേണം യഹോവയ്ക്കുള്ള പങ്കായി അർപ്പിക്കേണ്ടത്.’ ");
INSERT INTO malc_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“ലേവ്യരോടു പറയുക: ‘ഉത്തമഭാഗം നിങ്ങൾ അർപ്പിക്കുമ്പോൾ, അതു മെതിക്കളത്തിന്റെയോ മുന്തിരിച്ചക്കിന്റെയോ ഫലംപോലെ നിങ്ങളുടെപേരിൽ കണക്കാക്കും. ");
INSERT INTO malc_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","അതിന്റെ ബാക്കിഭാഗം നിങ്ങൾക്കും നിങ്ങളുടെ കുടുംബാംഗങ്ങൾക്കും എവിടെവെച്ചും ഭക്ഷിക്കാം; കാരണം അതു സമാഗമകൂടാരത്തിലെ നിങ്ങളുടെ വേലയ്ക്കുള്ള കൂലിയാണ്. ");
INSERT INTO malc_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","അതിന്റെ ഉത്തമഭാഗം അർപ്പിക്കുന്നതിനാൽ ഇക്കാര്യത്തിൽ നിങ്ങൾ കുറ്റമില്ലാത്തവരായിരിക്കും. അങ്ങനെ നിങ്ങൾ ഇസ്രായേല്യരുടെ വിശുദ്ധാർപ്പണങ്ങൾ മലിനപ്പെടുത്താതിരിക്കുകയും നിങ്ങൾ മരിക്കാതിരിക്കുകയും ചെയ്യും.’ ” ");
INSERT INTO malc_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","യഹോവ പിന്നെയും മോശയോടും അഹരോനോടും അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“യഹോവ കൽപ്പിച്ച ന്യായപ്രമാണത്തിലെ ഒരു ചട്ടം ഇതാണ്: ഊനമോ കളങ്കമോ ഇല്ലാത്തതും ഒരിക്കലും നുകം വെച്ചിട്ടില്ലാത്തതുമായ ഒരു ചെമന്ന പശുക്കിടാവിനെ നിങ്ങളുടെ അടുക്കൽ കൊണ്ടുവരാൻ ഇസ്രായേല്യരോടു പറയുക. ");
INSERT INTO malc_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","അതിനെ പുരോഹിതനായ എലെയാസറിനു നൽകുക; പാളയത്തിനുപുറത്തു കൊണ്ടുപോയി, അദ്ദേഹത്തിന്റെ സാന്നിധ്യത്തിൽ അതിനെ കൊല്ലണം. ");
INSERT INTO malc_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ഇതിനുശേഷം പുരോഹിതനായ എലെയാസാർ അതിന്റെ രക്തത്തിൽ കുറെ വിരലിന്മേൽ എടുത്ത് സമാഗമകൂടാരത്തിന്റെ മുൻഭാഗത്ത് ഏഴുപ്രാവശ്യം തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","പശുക്കിടാവിനെ അതിന്റെ തുകൽ, മാംസം, രക്തം, ചാണകം എന്നിവയോടുകൂടെ അദ്ദേഹത്തിന്റെ മുമ്പിൽവെച്ചു ദഹിപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","പുരോഹിതൻ കുറച്ച് ദേവദാരുത്തടി, ഈസോപ്പ്, ചെമന്നനൂൽ എന്നിവ പശുക്കിടാവിനെ ദഹിപ്പിക്കുന്ന അഗ്നിയിൽ ഇടണം. ");
INSERT INTO malc_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","അതിനുശേഷം പുരോഹിതൻ തന്റെ വസ്ത്രം അലക്കി, വെള്ളത്തിൽ കുളിക്കണം. തുടർന്ന് അദ്ദേഹത്തിനു പാളയത്തിലേക്കുവരാം. എന്നാൽ സന്ധ്യവരെ അദ്ദേഹം ആചാരപരമായി അശുദ്ധനായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","അതിനെ ദഹിപ്പിക്കുന്ന മനുഷ്യനും തന്റെ വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കണം. ആ മനുഷ്യനും സന്ധ്യവരെ അശുദ്ധനായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ശുദ്ധിയുള്ള ഒരാൾ പശുക്കിടാവിന്റെ ചാരം ശേഖരിച്ച് പാളയത്തിനു വെളിയിൽ വെടിപ്പുള്ള ഒരു സ്ഥലത്ത് ഇടണം. ശുദ്ധീകരണജലത്തിനായി ഉപയോഗിക്കാൻ ഇസ്രായേൽസഭ അതു സൂക്ഷിക്കണം; അത് ഒരു പാപശുദ്ധീകരണയാഗം. ");
INSERT INTO malc_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","പശുക്കിടാവിന്റെ ചാരം ശേഖരിക്കുന്ന വ്യക്തിയും തന്റെ വസ്ത്രം അലക്കണം. അയാളും സന്ധ്യവരെ അശുദ്ധനായിരിക്കും. ഇസ്രായേൽമക്കൾക്കും അവരുടെ ഇടയിൽ പാർക്കുന്ന പ്രവാസികൾക്കും ഇത് ഒരു ശാശ്വത അനുഷ്ഠാനമായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“മനുഷ്യന്റെ ശവം തൊടുന്ന ഏതൊരാളും ഏഴുദിവസത്തേക്ക് അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","മൂന്നാംദിവസവും ഏഴാംദിവസവും അയാൾ ശുദ്ധീകരണജലംകൊണ്ടു സ്വയം ശുദ്ധീകരിക്കണം. അപ്പോൾ അയാൾ ശുദ്ധനാകും. എന്നാൽ മൂന്നും, ഏഴും ദിവസങ്ങളിൽ സ്വയം ശുദ്ധീകരിക്കുന്നില്ലെങ്കിൽ അയാൾ ശുദ്ധനാകുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ശവം തൊടുന്ന ആരെങ്കിലും തന്നെ വിശുദ്ധീകരിക്കുന്നതിൽ വീഴ്ചവരുത്തിയാൽ അയാൾ യഹോവയുടെ കൂടാരത്തെ മലിനമാക്കുന്നു. ആ വ്യക്തിയെ ഇസ്രായേലിൽനിന്നും ഛേദിച്ചുകളയണം. കാരണം ശുദ്ധീകരണജലം അയാളുടെമേൽ തളിക്കാതിരുന്നതുനിമിത്തം അയാൾ അശുദ്ധനാണ്; അയാളുടെ അശുദ്ധി അയാളുടെമേൽ നിലനിൽക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ഒരു വ്യക്തി കൂടാരത്തിൽവെച്ചു മരിച്ചാലുള്ള നിയമം ഇതാണ്: ആ കൂടാരത്തിൽ കടക്കുന്നവരും അതിനുള്ളിലുള്ളവരും ഏഴുദിവസം അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","അടപ്പുകൊണ്ടു മൂടിവെക്കാത്ത പാത്രമൊക്കെയും അശുദ്ധമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“വാളാൽ മരിച്ചവരെയോ സ്വാഭാവികമായി മരിച്ചവരെയോ മനുഷ്യാസ്ഥി, ശവക്കല്ലറ എന്നിവ സ്പർശിക്കുന്നവരെയോ വെളിമ്പ്രദേശത്തുവെച്ചു തൊടുന്നവർ ഏഴുദിവസത്തേക്ക് അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“അശുദ്ധനായ മനുഷ്യനുവേണ്ടി, ശുദ്ധീകരണയാഗത്തിൽ ദഹിച്ച കുറെ ചാരം എടുത്ത് ഒരു പാത്രത്തിൽ ഇട്ട് അവയുടെമേൽ ശുദ്ധജലം ഒഴിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ഇതിനുശേഷം ആചാരപരമായി ശുദ്ധിയുള്ള ഒരാൾ ഈസോപ്പുതണ്ടെടുത്ത് ആ വെള്ളത്തിൽ മുക്കി ആ കൂടാരത്തിന്മേലും സകല ഉപകരണങ്ങളിന്മേലും അവിടെ ഉണ്ടായിരുന്ന ആളുകളുടെമേലും തളിക്കണം. മനുഷ്യന്റെ അസ്ഥി, ശവക്കല്ലറ, വധിക്കപ്പെട്ട ആൾ, സ്വാഭാവികമരണം സംഭവിച്ച ആൾ എന്നിവ സ്പർശിച്ച ഏവരുടെയുംമേൽ അയാൾ ശുദ്ധീകരണജലം തളിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ശുദ്ധിയുള്ള പുരുഷൻ അശുദ്ധിയുള്ള വ്യക്തിയെ മൂന്നാംദിവസവും ഏഴാംദിവസവും തളിക്കുകയും ഏഴാംദിവസം അയാൾ ആ മനുഷ്യനെ ശുദ്ധീകരിക്കുകയും വേണം. ശുദ്ധീകരിക്കപ്പെട്ട വ്യക്തി തന്റെ വസ്ത്രങ്ങൾ അലക്കി വെള്ളത്തിൽ കുളിക്കണം. അന്നു സന്ധ്യക്ക് ആ മനുഷ്യൻ ശുദ്ധിയുള്ളതായിത്തീരും. ");
INSERT INTO malc_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","എന്നാൽ അശുദ്ധരായവർ സ്വയം ശുദ്ധീകരിക്കുന്നില്ലെങ്കിൽ, അവർ സമൂഹത്തിൽനിന്ന് ഛേദിക്കപ്പെടണം. കാരണം അവർ യഹോവയുടെ വിശുദ്ധമന്ദിരത്തെ മലിനപ്പെടുത്തിയിരിക്കുന്നു. ശുദ്ധീകരണജലം അവരുടെമേൽ തളിക്കാതിരുന്നതിനാൽ അവർ അശുദ്ധരാണ്. ");
INSERT INTO malc_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ഇത് അവർക്കൊരു ശാശ്വത അനുഷ്ഠാനമായിരിക്കണം. “ശുദ്ധീകരണജലം തളിക്കുന്ന പുരുഷനും തന്റെ വസ്ത്രം അലക്കണം. ശുദ്ധീകരണജലത്തെ തൊടുന്ന ഏതൊരാളും സന്ധ്യവരെ അശുദ്ധരായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","അശുദ്ധരായവർ തൊടുന്ന ഏതൊരു വസ്തുവും അശുദ്ധമാകും; അതിനെ തൊടുന്ന ഏതൊരാളും സന്ധ്യവരെ അശുദ്ധരായിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ഒന്നാംമാസം ഇസ്രായേൽസഭ മുഴുവനും സീൻമരുഭൂമിയിൽ എത്തി. അവർ കാദേശിൽ താമസിച്ചു. അവിടെവെച്ച് മിര്യാം മരിച്ചു. അവളെ അവർ അവിടെ അടക്കി. ");
INSERT INTO malc_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","എന്നാൽ ജനത്തിന് അവിടെ വെള്ളം ഉണ്ടായിരുന്നില്ല. അവർ മോശയ്ക്കും അഹരോനും വിരോധമായി സംഘംചേർന്നു. ");
INSERT INTO malc_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","അവർ മോശയോടു കലഹിച്ചു പറഞ്ഞു: “ഞങ്ങളുടെ സഹോദരന്മാർ യഹോവയുടെമുമ്പാകെ മരിച്ചുവീണപ്പോൾ ഞങ്ങളും മരിച്ചുപോയിരുന്നെങ്കിൽ! ");
INSERT INTO malc_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ഞങ്ങളും ഞങ്ങളുടെ കന്നുകാലികളും ഇവിടെ മരിക്കേണ്ടതിന് യഹോവയുടെ സഭയെ നീ എന്തിന് ഈ മരുഭൂമിയിൽ കൊണ്ടുവന്നു? ");
INSERT INTO malc_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ഈ നശിച്ച സ്ഥലത്തേക്കു നീ ഞങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് കൂട്ടിക്കൊണ്ടുവന്നതെന്തിന്? ഇവിടെ ധാന്യമോ അത്തിപ്പഴമോ മുന്തിരിയോ മാതളപ്പഴമോ ഇല്ല; കുടിക്കാൻ വെള്ളവുമില്ല.” ");
INSERT INTO malc_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","മോശയും അഹരോനും സഭാമധ്യത്തിൽനിന്ന് സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽചെന്നു കമിഴ്ന്നുവീണു. അപ്പോൾ യഹോവയുടെ തേജസ്സ് അവർക്കു പ്രത്യക്ഷമായി. ");
INSERT INTO malc_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“വടി എടുക്കുക, എന്നിട്ട് നീയും നിന്റെ സഹോദരൻ അഹരോനുംകൂടി സഭയെ വിളിച്ചുകൂട്ടുക. അവരുടെ കണ്മുമ്പിൽവെച്ച് പാറയോടു കൽപ്പിക്കുക, അപ്പോൾ അതിൽനിന്ന് വെള്ളം പുറപ്പെടും. ജനത്തിന് പാറയിൽനിന്ന് നീ വെള്ളം പുറപ്പെടുവിക്കും; അങ്ങനെ അവരും അവരുടെ കന്നുകാലികളും കുടിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","അങ്ങനെ മോശ, യഹോവ തന്നോടു കൽപ്പിച്ചതുപോലെതന്നെ അവിടത്തെ സന്നിധിയിൽനിന്ന് വടി എടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","തുടർന്ന് അദ്ദേഹവും അഹരോനുംകൂടി സഭയെ പാറയുടെമുമ്പിൽ വിളിച്ചുകൂട്ടി. മോശ അവരോടു പറഞ്ഞു: “മത്സരിക്കുന്നവരേ, ശ്രദ്ധിക്കുക, ഞങ്ങൾ ഈ പാറയിൽനിന്ന് നിങ്ങൾക്കു വെള്ളം പുറപ്പെടുവിക്കട്ടെ?” ");
INSERT INTO malc_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ഇതിനുശേഷം മോശ കൈ ഉയർത്തി തന്റെ വടികൊണ്ട് പാറയെ രണ്ടുതവണ അടിച്ചു. വെള്ളം പ്രവഹിച്ചു. ജനവും അവരുടെ കന്നുകാലികളും മതിയാകുവോളം കുടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","എന്നാൽ യഹോവ മോശയോടും അഹരോനോടും, “ഇസ്രായേൽജനത്തിന്റെ മുമ്പിൽ എന്നെ വിശുദ്ധീകരിക്കാൻ തക്കവണ്ണം നിങ്ങൾ എന്നിൽ വിശ്വസിക്കാതിരുന്നതുകൊണ്ട് ഞാൻ അവർക്കു കൊടുക്കുമെന്നു വാഗ്ദാനംചെയ്ത ദേശത്തേക്ക് ഈ സമൂഹത്തെ നിങ്ങൾ കൊണ്ടുപോകുകയില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ഇസ്രായേൽമക്കൾ യഹോവയോടു കലഹിക്കുകയും അവരുടെമധ്യത്തിൽ അവിടന്ന് തന്റെ വിശുദ്ധി വെളിപ്പെടുത്തുകയുംചെയ്ത മെരീബാ ജലാശയം ഇതുതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ഈ സംഭവത്തിനുശേഷം മോശ കാദേശിൽനിന്ന് ഏദോംരാജാവിന്റെ അടുക്കൽ ഈ സന്ദേശവുമായി ദൂതന്മാരെ അയച്ചു: “നിന്റെ സഹോദരനായ ഇസ്രായേൽ ബോധിപ്പിക്കുന്ന അപേക്ഷ: ഞങ്ങളുടെമേൽ വന്ന സകലദുരിതങ്ങളെക്കുറിച്ചും അങ്ങ് അറിയുന്നല്ലോ. ");
INSERT INTO malc_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ഞങ്ങളുടെ പൂർവികർ ഈജിപ്റ്റിലേക്ക് ഇറങ്ങിപ്പോയി. ഞങ്ങൾ അവിടെ അനേകവർഷങ്ങൾ താമസിച്ചു. ഈജിപ്റ്റുകാർ ഞങ്ങളോടും ഞങ്ങളുടെ പൂർവികരോടും കഠിനമായി പെരുമാറി. ");
INSERT INTO malc_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","എന്നാൽ ഞങ്ങൾ യഹോവയോടു നിലവിളിച്ചപ്പോൾ, അവിടന്ന് ഞങ്ങളുടെ പ്രാർഥനകേട്ട് ഒരു ദൂതനെ അയച്ച് ഞങ്ങളെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെടുവിച്ചു. “ഇപ്പോൾ ഞങ്ങൾ ഇവിടെ അങ്ങയുടെ അധീനതയിലുള്ള രാജ്യത്തിന്റെ അതിർത്തിനഗരമായ കാദേശിൽ എത്തിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","നിങ്ങളുടെ ദേശത്തുകൂടി കടന്നുപോകാൻ ഞങ്ങളെ അനുവദിക്കുക. ഞങ്ങൾ വയലിലോ മുന്തിരിത്തോപ്പിലോ കടക്കുകയോ കിണറ്റിൽനിന്ന് വെള്ളം കുടിക്കുകയോ ചെയ്യുകയില്ല. നിങ്ങളുടെ അതിർത്തി കടക്കുന്നതുവരെ ഇടത്തോട്ടോ വലത്തോട്ടോ തിരിയാതെ രാജപാതയിലൂടെമാത്രമേ യാത്രചെയ്യുകയുള്ളൂ.” ");
INSERT INTO malc_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","എന്നാൽ ഏദോംരാജാവിന്റെ ഉത്തരവ് ഇപ്രകാരമായിരുന്നു: “നിങ്ങൾ ഇതിലെ കടന്നുപോകരുത്. അതിനു തുനിഞ്ഞാൽ, ഞങ്ങൾ പുറപ്പെട്ടുവന്ന് വാൾകൊണ്ട് നിങ്ങളെ ആക്രമിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","അതിന് ഇസ്രായേല്യർ, “ഞങ്ങൾ പ്രധാനനിരത്തിലൂടെ പൊയ്ക്കൊള്ളാം. ഞങ്ങളോ ഞങ്ങളുടെ കന്നുകാലികളോ നിങ്ങളുടെ വെള്ളം കുടിച്ചാൽ അതിനു വിലതരാം. ഞങ്ങൾക്കു കാൽനടയായി കടന്നുപോയാൽമാത്രം മതി—മറ്റൊന്നും വേണ്ട” എന്ന മറുപടി അറിയിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","വീണ്ടും അവർ മറുപടികൊടുത്തു: “നിങ്ങൾ കടന്നുപോയിക്കൂടാ.” അപ്പോൾ ഏദോം വലിയതും ശക്തവുമായ ഒരു സൈന്യത്തോടുകൂടി അവർക്കെതിരേ പുറപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","തങ്ങളുടെ രാജ്യത്തുകൂടി കടന്നുപോകാൻ ഏദോം അവർക്ക് അനുമതി നിഷേധിച്ചതിനാൽ, ഇസ്രായേൽ അവിടെനിന്നു പിന്തിരിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ഇസ്രായേൽസഭ മുഴുവനും കാദേശിൽനിന്ന് പുറപ്പെട്ട് ഹോർ പർവതത്തിൽ എത്തി. ");
INSERT INTO malc_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ഏദോമിന്റെ അതിർത്തിയിലുള്ള ഹോർ പർവതത്തിൽവെച്ച് യഹോവ മോശയോടും അഹരോനോടും, ");
INSERT INTO malc_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“അഹരോൻ തന്റെ ജനത്തോടു ചേർക്കപ്പെടും. ഞാൻ ഇസ്രായേല്യർക്കു കൊടുക്കുന്ന ദേശത്ത് അദ്ദേഹം കടക്കുകയില്ല; കാരണം നിങ്ങൾ ഇരുവരും മെരീബയിലെ ജലാശയത്തിനരികിൽവെച്ച് എന്റെ കൽപ്പനയോടു മത്സരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","അഹരോനെയും അദ്ദേഹത്തിന്റെ പുത്രൻ എലെയാസാരെയും ഹോർ പർവതമുകളിലേക്കു കൂട്ടിക്കൊണ്ടുവരിക. ");
INSERT INTO malc_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","അഹരോന്റെ വസ്ത്രങ്ങൾ ഊരി അവന്റെ പുത്രൻ എലെയാസാരിനെ ധരിപ്പിക്കുക. കാരണം അഹരോൻ തന്റെ ജനത്തോടു ചേർക്കപ്പെടും; അദ്ദേഹം അവിടെ മരിക്കും” എന്ന് അരുളിച്ചെയ്തതു. ");
INSERT INTO malc_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","യഹോവ കൽപ്പിച്ചതുപോലെ മോശ ചെയ്തു; സർവസമൂഹത്തിന്റെയും മുമ്പാകെ അവർ ഹോർ പർവതത്തിലേക്കു കയറിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","മോശ അഹരോന്റെ വസ്ത്രങ്ങൾ ഊരി അദ്ദേഹത്തിന്റെ പുത്രൻ എലെയാസാരിനെ ധരിപ്പിച്ചു. അഹരോൻ പർവതത്തിന്റെ മുകളിൽവെച്ച് മരിച്ചു. ഇതിനുശേഷം മോശയും എലെയാസാരും പർവതത്തിൽനിന്ന് ഇറങ്ങിവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","അഹരോൻ മരിച്ചു എന്ന് സഭയെല്ലാം മനസ്സിലാക്കിയപ്പോൾ ഇസ്രായേൽഗൃഹം മുഴുവനും മുപ്പതുദിവസം അദ്ദേഹത്തെച്ചൊല്ലി വിലപിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","അഥാരീം വഴിയായി ഇസ്രായേൽ വരുന്നു എന്നു തെക്കേദേശത്തു താമസിച്ചിരുന്ന കനാന്യരാജാവായ അരാദ് കേട്ടപ്പോൾ അയാൾ ഇസ്രായേല്യരെ ആക്രമിച്ച് അവരിൽ ചിലരെ പിടിച്ചുകൊണ്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","അപ്പോൾ ഇസ്രായേൽ, “അവിടന്ന് ഈ ജനത്തെ ഞങ്ങളുടെ കൈകളിൽ ഏൽപ്പിച്ചുതരുമെങ്കിൽ ഞങ്ങൾ അവരുടെ പട്ടണങ്ങളെ ഉന്മൂലനംചെയ്യും” എന്ന് യഹോവയോട് ശപഥംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","യഹോവ ഇസ്രായേലിന്റെ അപേക്ഷ കേട്ടു കനാന്യരെ അവർക്ക് ഏൽപ്പിച്ചുകൊടുത്തു. അവർ അവരെയും അവരുടെ പട്ടണങ്ങളെയും നിശ്ശേഷം നശിപ്പിച്ചു; അങ്ങനെ ആ സ്ഥലത്തിനു ഹോർമാ എന്നു പേരായി. ");
INSERT INTO malc_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ഏദോം ചുറ്റിപ്പോകേണ്ടതിനായി അവർ ഹോർ പർവതത്തിൽനിന്ന് ചെങ്കടലിലേക്കുള്ള വഴിയിലൂടെ യാത്രചെയ്തു. എന്നാൽ വഴിമധ്യേ ജനം അക്ഷമരായി. ");
INSERT INTO malc_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","അവർ ദൈവത്തിനും മോശയ്ക്കും വിരോധമായി സംസാരിച്ച്, “മരുഭൂമിയിൽ മരിക്കേണ്ടതിനു നിങ്ങൾ ഞങ്ങളെ എന്തിന് ഈജിപ്റ്റിൽനിന്ന് കൊണ്ടുവന്നു? ഇവിടെ അപ്പവുമില്ല! വെള്ളവുമില്ല! ഈ നിസ്സാരഭക്ഷണം ഞങ്ങൾ വെറുക്കുന്നു!” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","അപ്പോൾ യഹോവ അവരുടെ ഇടയിൽ അഗ്നിസർപ്പങ്ങളെ അയച്ചു. അവ ജനത്തെ കടിച്ചു, ഇസ്രായേൽമക്കളിൽ അനേകംപേർ മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ജനം മോശയുടെ അടുക്കൽവന്ന്, “ഞങ്ങൾ യഹോവയ്ക്കും താങ്കൾക്കും എതിരായി സംസാരിച്ചതിനാൽ ഞങ്ങൾ പാപംചെയ്തു. യഹോവ സർപ്പങ്ങളെ ഞങ്ങളുടെ ഇടയിൽനിന്ന് അകറ്റേണ്ടതിനായി പ്രാർഥിക്കണമേ” എന്ന് അദ്ദേഹത്തോടു പറഞ്ഞു. അങ്ങനെ മോശ ജനത്തിനുവേണ്ടി പ്രാർഥിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","യഹോവ മോശയോട്, “ഒരു വിഷസർപ്പത്തെ ഉണ്ടാക്കി ഒരു കൊടിമരത്തിൽ ഉയർത്തുക. സർപ്പദംശനമേറ്റ ഏതൊരാളും അതിൽ നോക്കിയാൽ ജീവിക്കും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","അങ്ങനെ മോശ വെങ്കലംകൊണ്ട് ഒരു സർപ്പം ഉണ്ടാക്കി അതിനെ ഒരു കൊടിമരത്തിൽ ഉയർത്തിനിർത്തി. ഇതിനുശേഷം സർപ്പദംശനമേറ്റവർ വെങ്കലസർപ്പത്തെ നോക്കി; അവരെ മരണം കീഴടക്കിയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ഇസ്രായേൽമക്കൾ തങ്ങളുടെ യാത്രതുടർന്ന് ഓബോത്തിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","അതിനുശേഷം അവർ ഓബോത്തിൽനിന്ന് യാത്രപുറപ്പെട്ട് സൂര്യോദയത്തിനുനേരേ മോവാബിന് അഭിമുഖമായുള്ള മരുഭൂമിയിൽ ഇയ്യെ-അബാരീമിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","അവിടെനിന്ന് അവർ മുമ്പോട്ടുനീങ്ങി സേരെദ് താഴ്വരയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","അവർ അവിടെനിന്നു പുറപ്പെട്ട് അമോര്യരുടെ അതിർത്തിയിലേക്കു നീളുന്ന മരുഭൂമിയിലുള്ള അർന്നോൻനദിക്കു സമാന്തരമായി പാളയമടിച്ചു. മോവാബിന്റെയും അമോര്യരുടെയും പ്രദേശങ്ങൾക്ക് ഇടയിൽ മോവാബിന്റെ അതിർത്തിയാണ് അർന്നോൻ. ");
INSERT INTO malc_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","തന്മൂലം, “സൂഫയിലെ വാഹേബും അർന്നോൻ മലയിടുക്കുകളും ");
INSERT INTO malc_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","മോവാബിന്റെ അതിർത്തിയിലുടനീളം ചാഞ്ഞുകിടക്കുന്ന ആർപട്ടണംവരെയുള്ള മലഞ്ചെരിവുകളും” എന്ന് യഹോവയുടെ യുദ്ധപുസ്തകത്തിൽ പരാമർശിക്കപ്പെട്ടിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","അവിടെനിന്ന് അവർ ബേരിലേക്കു പുറപ്പെട്ടു. “ജനങ്ങളെ വിളിച്ചുകൂട്ടുക, ഞാൻ അവർക്കു വെള്ളം കൊടുക്കും,” എന്ന് യഹോവ മോശയോട് അരുളിച്ചെയ്ത കിണർ ഇതുതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","അപ്പോൾ ഇസ്രായേൽ ഈ ഗാനം ആലപിച്ചു: “കിണറേ, പൊങ്ങിവാ! അതിനെക്കുറിച്ചു പാടുക, ");
INSERT INTO malc_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","പ്രഭുക്കന്മാർ കുഴിച്ച കിണർ, ജനശ്രേഷ്ഠന്മാർ ചെങ്കോൽകൊണ്ടും ദണ്ഡുകൾകൊണ്ടും കുത്തിയ കിണറിനെക്കുറിച്ചുതന്നെ.” ഇതിനുശേഷം അവർ മരുഭൂമിയിൽനിന്ന് മത്ഥാനയിലേക്കും ");
INSERT INTO malc_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","മത്ഥാനയിൽനിന്ന് നഹലീയേലിലേക്കും, നഹലീയേലിൽനിന്ന് ബാമോത്തിലേക്കും, ");
INSERT INTO malc_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ബാമോത്തിൽനിന്ന് മോവാബിലെ താഴ്വരയിലേക്കും പോയി. അതു മരുഭൂമിക്ക് അഭിമുഖമായുള്ള പിസ്ഗകൊടുമുടിയുടെ താഴെയാണ്. ");
INSERT INTO malc_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","അവിടെനിന്ന് ഇസ്രായേൽ അമോര്യരുടെ രാജാവായ സീഹോന്റെ അടുക്കൽ സന്ദേശവാഹകരെ അയച്ചു പറഞ്ഞു: ");
INSERT INTO malc_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“താങ്കളുടെ രാജ്യത്തുകൂടി കടന്നുപോകാൻ ഞങ്ങളെ അനുവദിക്കണമേ. ഞങ്ങൾ വയലിലോ മുന്തിരിത്തോപ്പിലോ കടക്കുകയോ കിണറ്റിൽനിന്ന് വെള്ളം കുടിക്കുകയോ ഇല്ല. താങ്കളുടെ ഭൂപ്രദേശം കടക്കുന്നതുവരെ ഞങ്ങൾ രാജപാതയിലൂടെമാത്രം യാത്രചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","എന്നാൽ സീഹോൻ തന്റെ രാജ്യത്തിലൂടെ കടന്നുപോകാൻ ഇസ്രായേലിനെ അനുവദിച്ചില്ല. അയാൾ സൈന്യത്തെയെല്ലാം ഒന്നിച്ചുകൂട്ടി ഇസ്രായേലിനെതിരായി മരുഭൂമിയിലേക്കു പുറപ്പെട്ടു. യാഹാസിലെത്തിയപ്പോൾ അയാൾ ഇസ്രായേലിനോടു യുദ്ധംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","എന്നാൽ ഇസ്രായേൽ അയാളെ വാൾകൊണ്ടു കൊന്ന് അർന്നോൻമുതൽ യാബ്ബോക്കുവരെ അയാളുടെ ദേശം പിടിച്ചെടുത്തു. അമ്മോന്യരുടെ അതിരുവരെമാത്രമേ പിടിച്ചെടുത്തുള്ളൂ, കാരണം അവരുടെ അതിർത്തി കോട്ടകെട്ടി ബലപ്പെടുത്തിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ഹെശ്ബോനും അതിനുചുറ്റുമുള്ള സകലഗ്രാമങ്ങളുമടക്കം അമോര്യരുടെ എല്ലാ പട്ടണങ്ങളും ഇസ്രായേൽ പിടിച്ചടക്കി അവിടെ താമസമാക്കി. ");
INSERT INTO malc_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","അമോര്യരാജാവായ സീഹോന്റെ പട്ടണമായിരുന്നു ഹെശ്ബോൻ. അദ്ദേഹം മോവാബിൽ മുമ്പുണ്ടായിരുന്ന രാജാവിനോടു യുദ്ധംചെയ്ത് അർന്നോൻനദിവരെയുള്ള സകലഭൂപ്രദേശങ്ങളും പിടിച്ചടക്കിയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","അതുകൊണ്ടാണ് കവികൾ പറയുന്നത്: “ഹെശ്ബോനിലേക്കു വരിക, അതു വീണ്ടും പണിയപ്പെടട്ടെ; സീഹോന്റെ പട്ടണം പുനഃസ്ഥാപിക്കപ്പെടട്ടെ. ");
INSERT INTO malc_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“ഹെശ്ബോനിൽനിന്ന് അഗ്നി പുറപ്പെട്ടു, സീഹോന്റെ നഗരത്തിൽനിന്ന് ഒരു ജ്വാലയും. മോവാബിലെ ആർപട്ടണവും അർന്നോൻ ഗിരികളിലെ നിവാസികളെയും അതു ദഹിപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","മോവാബേ, നിനക്കു ഹാ കഷ്ടം! കെമോശ് ജനതയേ, നിങ്ങൾ നശിച്ചു! അയാൾ തന്റെ പുത്രന്മാരെ പലായിതരായും പുത്രിമാരെ അമോര്യരാജാവായ സീഹോന് അടിമകളായും കൈവിട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“എന്നാൽ ഞങ്ങളവരെ തകർത്തുകളഞ്ഞു; ദീബോൻവരെ ഹെശ്ബോന്റെ അധീനതയിലുള്ളതെല്ലാം നശിപ്പിച്ചിരിക്കുന്നു. ഞങ്ങൾ അവരെ മെദേബായിലേക്കു നീളുന്ന നോഫാവരെയും തകർത്തിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","അങ്ങനെ ഇസ്രായേൽ അമോര്യരുടെ ദേശത്തു താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","മോശ യാസേരിലേക്കു ചാരന്മാരെ അയച്ചശേഷം, അതിനുചുറ്റുമുള്ള ജനാധിവാസകേന്ദ്രങ്ങളെ ഇസ്രായേൽ പിടിച്ചെടുത്ത് അവിടെ ഉണ്ടായിരുന്ന അമോര്യരെ ഓടിച്ചുകളഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","അതിനുശേഷം അവർ തിരിഞ്ഞ് ബാശാനിലേക്കുള്ള വഴിയേ കയറിപ്പോയി. അപ്പോൾ ബാശാൻരാജാവായ ഓഗും അദ്ദേഹത്തിന്റെ സർവസൈന്യവും അവരുടെനേരേ ചെന്ന് എദ്രെയിൽവെച്ചു യുദ്ധംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","യഹോവ മോശയോട്, “അവനെ ഭയപ്പെടരുത്; ഞാൻ അവനെ അവന്റെ സർവസൈന്യത്തോടും അവന്റെ ദേശത്തോടുംകൂടി നിന്റെ കൈയിൽ ഏൽപ്പിച്ചിരിക്കുന്നു. ഹെശ്ബോനിൽ വാണിരുന്ന അമോര്യരാജാവായ സീഹോനോടു ചെയ്തതുതന്നെ നീ അവനോടും ചെയ്യുക” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","അങ്ങനെ അവർ അയാളെ അയാളുടെ പുത്രന്മാരോടും സർവസൈന്യത്തോടുംകൂടെ നിശ്ശേഷം കൊന്നൊടുക്കി, ആരും ശേഷിച്ചില്ല. അവർ അവരുടെ ദേശം കൈവശമാക്കി. ");
INSERT INTO malc_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ഈ സംഭവത്തിനുശേഷം ഇസ്രായേൽമക്കൾ മോവാബ് സമതലങ്ങളിലേക്കു യാത്രചെയ്ത് യെരീഹോവിന് അക്കരെ യോർദാൻ നദീതീരത്തു പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ഇസ്രായേൽ അമോര്യരോടു ചെയ്ത സകലതും സിപ്പോരിന്റെ മകനായ ബാലാക്ക് കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ജനം വളരെയധികം ഉണ്ടായിരുന്നതിനാൽ മോവാബ് ഭയപ്പെട്ടു. വാസ്തവത്തിൽ ഇസ്രായേൽമക്കളുടെ സാന്നിധ്യം മോവാബ്യരിൽ ഭീതിയുളവാക്കി. ");
INSERT INTO malc_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","മോവാബ്യർ മിദ്യാനിലെ തലവന്മാരോട്, “കാള വയലിലെ പുല്ലു നക്കിക്കളയുന്നതുപോലെ ഈ പടക്കൂട്ടം നമുക്കുചുറ്റുമുള്ള സകലതും നക്കിക്കളയാൻ പോകുന്നു” എന്നു പറഞ്ഞു. അന്നു മോവാബിലെ രാജാവായിരുന്ന സിപ്പോരിന്റെ മകൻ ബാലാക്ക് ");
INSERT INTO malc_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ബെയോരിന്റെ മകൻ ബിലെയാമിനെ വിളിക്കാൻ ദൂതന്മാരെ അയച്ചു. അദ്ദേഹം തന്റെ സ്വദേശത്ത്, യൂഫ്രട്ടീസ് നദിക്ക് അരികെയുള്ള പെഥോരിൽ ആയിരുന്നു. ബാലാക്ക് പറഞ്ഞു: “ഈജിപ്റ്റിൽനിന്ന് ഒരു ജനം വന്നിരിക്കുന്നു; അവർ ദേശത്തെ മൂടി എനിക്കു സമീപം പാർപ്പുറപ്പിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","അവർ എന്നിലും ശക്തന്മാരാകുകയാൽ വന്ന് ഈ ജനത്തെ ശപിക്കണമേ. എങ്കിൽ എനിക്ക് ഈ ജനത്തെ തോൽപ്പിച്ച് അവരെ ദേശത്തുനിന്ന് ഓടിച്ചുകളയാൻ കഴിഞ്ഞേക്കും. കാരണം നീ അനുഗ്രഹിക്കുന്നവർ അനുഗ്രഹിക്കപ്പെടും; നീ ശപിക്കുന്നവർ ശപിക്കപ്പെടും എന്നു ഞാൻ അറിയുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","മോവാബിലെയും മിദ്യാനിലെയും തലവന്മാർ പ്രശ്നദക്ഷിണയുമായി പുറപ്പെട്ടു. അവർ ബിലെയാമിന്റെ അടുക്കൽവന്ന് ബാലാക്ക് പറഞ്ഞ കാര്യങ്ങൾ അദ്ദേഹത്തോടു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","“രാത്രി ഇവിടെ പാർക്കുക, എങ്കിൽ യഹോവ എനിക്കു തരുന്ന മറുപടി ഞാൻ നിങ്ങളെ അറിയിക്കാം,” എന്ന് ബിലെയാം അവരോടു പറഞ്ഞു. അങ്ങനെ മോവാബ്യപ്രഭുക്കന്മാർ അദ്ദേഹത്തോടൊപ്പം താമസിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ദൈവം ബിലെയാമിന്റെ അടുക്കൽവന്ന് “നിന്നോടൊപ്പമുള്ള ഈ പുരുഷന്മാർ ആര്?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ബിലെയാം ദൈവത്തോട്, “മോവാബിലെ രാജാവായ സിപ്പോരിന്റെ മകൻ ബാലാക്ക് എനിക്ക് ഈ സന്ദേശമയച്ചു: ");
INSERT INTO malc_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘ഈജിപ്റ്റിൽനിന്നും പുറപ്പെട്ടുവന്ന ഒരു ജനം ദേശത്തെ മൂടിയിരിക്കുന്നു. ആകയാൽ വന്ന് എനിക്കുവേണ്ടി അവരെ ശപിക്കുക. അങ്ങനെയെങ്കിൽ എനിക്ക് അവരെ തോൽപ്പിച്ചോടിക്കാൻ കഴിഞ്ഞേക്കും.’ ” ");
INSERT INTO malc_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","എന്നാൽ ദൈവം ബിലെയാമിനോട്, “അവരോടൊപ്പം പോകരുത്. നീ ആ ജനത്തെ ശപിക്കരുത്, അവർ അനുഗ്രഹിക്കപ്പെട്ടവരാണ്” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","അടുത്ത പ്രഭാതത്തിൽ ബിലെയാം എഴുന്നേറ്റ് ബാലാക്കിന്റെ പ്രഭുക്കന്മാരോട്, “നിങ്ങളുടെ ദേശത്തേക്കു മടങ്ങിപ്പൊയ്ക്കൊൾക, നിങ്ങളോടൊപ്പം വരുന്നതിനു യഹോവ എന്നെ അനുവദിക്കുന്നില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","അങ്ങനെ മോവാബ്യപ്രഭുക്കന്മാർ ബാലാക്കിന്റെ അടുക്കൽ മടങ്ങിച്ചെന്ന്, “ഞങ്ങളോടൊപ്പം വരുന്നതിനു ബിലെയാം വിസമ്മതിച്ചു” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","അതിനുശേഷം ബാലാക്ക് ആദ്യത്തേതിലും മാന്യരായ വേറെ അധികം പ്രഭുക്കന്മാരെ അയച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","അവർ ബിലെയാമിന്റെ അടുക്കൽവന്നു പറഞ്ഞു, “സിപ്പോരിന്റെ മകൻ ബാലാക്ക് ഇങ്ങനെ പറയുന്നു: ‘എന്റെയടുക്കൽ വരുന്നതിന് ഒന്നും തടസ്സമാകരുത്. ");
INSERT INTO malc_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","കാരണം ഞാൻ താങ്കൾക്ക് മാന്യമായ പ്രതിഫലംനൽകും; താങ്കൾ പറയുന്നതെന്തും ചെയ്യും. വന്ന് എനിക്കുവേണ്ടി ഈ ജനത്തെ ശപിക്കുക.’ ” ");
INSERT INTO malc_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","എന്നാൽ ബിലെയാം അവരോടു പറഞ്ഞത്: “ബാലാക്ക് അദ്ദേഹത്തിന്റെ കൊട്ടാരം നിറയെ സ്വർണവും വെള്ളിയും എനിക്കു തന്നാലും യഹോവയായ എന്റെ ദൈവം കൽപ്പിക്കുന്നതിനപ്പുറം—കൂടുതലോ കുറവോ—ഒന്നും എനിക്കു ചെയ്യാൻ കഴിയുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","നിങ്ങളും ഇന്നു രാത്രി ഇവിടെ പാർക്കുക, മറ്റെന്തെങ്കിലുംകൂടി യഹോവ എന്നോടു പറയുമോ എന്നു ഞാൻ അറിയട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ആ രാത്രിയിൽ ദൈവം ബിലെയാമിന്റെ അടുക്കൽവന്ന്, “ഈ പുരുഷന്മാർ നിന്നെ വിളിക്കാൻ വന്നതിനാൽ അവരോടുകൂടെപ്പോകുക. എന്നാൽ ഞാൻ നിന്നോടു പറയുന്നതുമാത്രം ചെയ്യുക.” ");
INSERT INTO malc_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ബിലെയാം രാവിലെ എഴുന്നേറ്റ് അദ്ദേഹത്തിന്റെ കഴുതയ്ക്കു ജീനിയിട്ട് മോവാബിലെ പ്രഭുക്കന്മാരോടുകൂടെ പോയി. ");
INSERT INTO malc_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","എന്നാൽ അയാൾ പോയപ്പോൾ ദൈവം അത്യന്തം കോപിച്ചു. യഹോവയുടെ ദൂതൻ അയാളെ എതിരിടാൻ വഴിയിൽ നിന്നു. ബിലെയാം തന്റെ കഴുതപ്പുറത്ത് യാത്രചെയ്യുകയായിരുന്നു. അയാളുടെ രണ്ടു ദാസന്മാരും അയാളോടുകൂടെ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","യഹോവയുടെ ദൂതൻ കൈയിൽ ഊരിയ വാളുമേന്തി വഴിയിൽ നിൽക്കുന്നതു കണ്ട കഴുത വഴിയിൽനിന്ന് ഒരുവയലിലേക്ക് തിരിഞ്ഞു. അതിനെ വഴിയിലേക്ക് തിരിച്ചുകൊണ്ടുവരാൻ ബിലെയാം കഴുതയെ അടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","പിന്നെ യഹോവയുടെ ദൂതൻ രണ്ടു മുന്തിരിത്തോപ്പുകളുടെ ഇടയിൽ രണ്ടുവശത്തും മതിലുള്ള ഒരു ഇടുങ്ങിയ വഴിയിൽ നിന്നു. ");
INSERT INTO malc_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","കഴുത യഹോവയുടെ ദൂതനെ കണ്ടപ്പോൾ മതിലരികിലേക്ക് ഒതുങ്ങി. ബിലെയാമിന്റെ കാൽ മതിലിനിടയിൽ ഞെരുങ്ങി. അതുകൊണ്ട് അയാൾ അതിനെ വീണ്ടും അടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","പിന്നെ യഹോവയുടെ ദൂതൻ മുമ്പോട്ടുനീങ്ങി ഇടത്തോട്ടോ വലത്തോട്ടോ തിരിയാൻ ഒട്ടും ഇടമില്ലാത്ത ഒരു ഇടുങ്ങിയ സ്ഥലത്ത് നിന്നു. ");
INSERT INTO malc_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","കഴുത യഹോവയുടെ ദൂതനെ കണ്ടപ്പോൾ ബിലെയാമിന്റെ കീഴിൽ കിടന്നു. അയാൾ കോപിച്ചു തന്റെ വടികൊണ്ട് അതിനെ അടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","അപ്പോൾ യഹോവ കഴുതയുടെ വായ് തുറന്നു. അത് ബിലെയാമിനോട്, “നീ എന്നെ ഈ മൂന്നുതവണ അടിക്കാൻ ഞാൻ നിന്നോട് എന്തു ചെയ്തു?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ബിലെയാം കഴുതയോട്, “നീ എന്നെ ഒരു വിഡ്ഢിയാക്കി! എന്റെ കൈയിൽ ഒരു വാളുണ്ടായിരുന്നെങ്കിൽ ഇപ്പോൾ ഞാൻ നിന്നെ കൊല്ലുമായിരുന്നു” എന്നു മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","കഴുത ബിലെയാമിനോടു പറഞ്ഞു: “ഈ ദിവസംവരെ എപ്പോഴും യാത്രചെയ്തുവന്ന നിന്റെ കഴുതയല്ലേ ഞാൻ? ഇങ്ങനെ ഞാൻ ഇതിനുമുമ്പ് എപ്പോഴെങ്കിലും നിന്നോട് ചെയ്തിട്ടുണ്ടോ?” “ഇല്ല,” അയാൾ പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","അപ്പോൾ യഹോവ ബിലെയാമിന്റെ കണ്ണുകൾ തുറന്നു. ഊരിയ വാളുമേന്തി യഹോവയുടെ ദൂതൻ വഴിയിൽ നിൽക്കുന്നത് കണ്ടു. അയാൾ സാഷ്ടാംഗം വണങ്ങി വീണു. ");
INSERT INTO malc_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","യഹോവയുടെ ദൂതൻ അയാളോടു ചോദിച്ചു: “നീ മൂന്നുപ്രാവശ്യം നിന്റെ കഴുതയെ അടിച്ചതെന്ത്? നിന്റെ വഴി നാശകരമാകുകയാൽ നിന്നെ എതിരിടാനാണ് ഞാനിവിടെ വന്നിരിക്കുന്നത്. ");
INSERT INTO malc_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","കഴുത എന്നെക്കണ്ട് മൂന്നു തവണയും തിരിഞ്ഞുമാറിപ്പോയി. അതു തിരിഞ്ഞുമാറിയില്ലായിരുന്നെങ്കിൽ നിശ്ചയമായും ഞാൻ നിന്നെ കൊല്ലുകയും അതിനെ ജീവനോടെ ശേഷിപ്പിക്കുകയും ചെയ്യുമായിരുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ബിലെയാം യഹോവയുടെ ദൂതനോട്, “ഞാൻ പാപംചെയ്തിരിക്കുന്നു. എന്നെ എതിരിടാൻ അങ്ങ് വഴിയിൽ നിൽക്കുകയായിരുന്നു എന്നു ഞാൻ അറിഞ്ഞില്ല. അങ്ങേക്ക് അനിഷ്ടമെങ്കിൽ ഞാൻ മടങ്ങിപ്പൊയ്ക്കൊള്ളാം” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","യഹോവയുടെ ദൂതൻ ബിലെയാമിനോട്, “ആ പുരുഷന്മാരോടുകൂടെ പോകുക. എന്നാൽ ഞാൻ നിന്നോടു പറയുന്നതുമാത്രം പറയുക” എന്നു പറഞ്ഞു. അങ്ങനെ ബിലെയാം ബാലാക്കിന്റെ പ്രഭുക്കന്മാരോടുകൂടെ പോയി. ");
INSERT INTO malc_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ബിലെയാം വരുന്നു എന്നു ബാലാക്ക് കേട്ടപ്പോൾ അദ്ദേഹത്തെ എതിരേൽക്കാൻ തന്റെ രാജ്യാതിർത്തിയിൽ അർന്നോൻനദീതീരത്തുള്ള മോവാബ്യ പട്ടണത്തിലേക്കു ചെന്നു. ");
INSERT INTO malc_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ബാലാക്ക് ബിലെയാമിനോടു പറഞ്ഞു: “ഞാൻ താങ്കൾക്ക് ഒരു അടിയന്തരക്ഷണം അല്ലേ അയച്ചത്? എന്തുകൊണ്ടു താങ്കൾ എന്റെയടുക്കൽ വന്നില്ല? താങ്കൾക്കു പ്രതിഫലം നൽകാൻ തക്ക പ്രാപ്തി എനിക്കില്ലേ?” ");
INSERT INTO malc_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","“ആകട്ടെ, ഞാൻ ഇപ്പോൾ നിന്റെയടുക്കൽ വന്നല്ലോ,” ബിലെയാം മറുപടി പറഞ്ഞു. “പക്ഷേ, വെറുതേ എന്തെങ്കിലും പറയാൻ എനിക്കു കഴിയുമോ? ദൈവം എന്റെ നാവിൽ തരുന്നതുമാത്രമേ ഞാൻ സംസാരിക്കൂ.” ");
INSERT INTO malc_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","പിന്നെ ബിലെയാം ബാലാക്കിനോടുകൂടെ കിര്യത്ത്-ഹൂസോത്തിലേക്കു പോയി. ");
INSERT INTO malc_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ബാലാക്ക് കാളകളെയും ആടുകളെയും യാഗമർപ്പിച്ചു. ബിലെയാമിനും അദ്ദേഹത്തോടൊപ്പം ഉണ്ടായിരുന്ന പ്രഭുക്കന്മാർക്കും കൊടുത്തയച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","അടുത്ത പ്രഭാതത്തിൽ ബാലാക്ക് ബിലെയാമിനെ കൂട്ടിക്കൊണ്ട് ബാമോത്ത്-ബാലിലേക്കു കയറിച്ചെന്നു. അവിടെനിന്ന് അദ്ദേഹത്തിന് ഇസ്രായേൽജനത്തിന്റെ ഒരുഭാഗം കാണാമായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ബിലെയാം പറഞ്ഞു: “ഇവിടെ ഏഴു യാഗപീഠം പണിത്, ഏഴു കാള, ഏഴ് ആട്ടുകൊറ്റൻ എന്നിവ എനിക്കായി ഒരുക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ബിലെയാം പറഞ്ഞതുപോലെ ബാലാക്ക് ചെയ്തു. ബാലാക്കും ബിലെയാമും ഓരോ കാള, ഓരോ ആട്ടുകൊറ്റൻ എന്നിവ ഓരോ യാഗപീഠത്തിന്മേലും അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","പിന്നെ ബിലെയാം ബാലാക്കിനോട്: “ഞാൻ അൽപ്പം വേറിട്ടു പോകുമ്പോൾ നീ ഇവിടെ നിന്റെ ഹോമയാഗത്തിനരികെ നിൽക്കുക. പക്ഷേ, യഹോവ എന്നെ സന്ദർശിച്ചേക്കും. അവിടന്ന് എന്ത് വെളിപ്പെടുത്തുന്നോ അതു ഞാൻ അറിയിക്കാം” എന്നു പറഞ്ഞു. പിന്നെ അദ്ദേഹം ഒരു മൊട്ടക്കുന്നിലേക്കു കയറിപ്പോയി. ");
INSERT INTO malc_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ദൈവം അദ്ദേഹത്തെ സന്ദർശിച്ചു. ബിലെയാം പറഞ്ഞു: “ഞാൻ ഏഴു യാഗപീഠം ഒരുക്കി, ഓരോ യാഗപീഠത്തിന്മേലും ഓരോ കാള, ഓരോ ആട്ടുകൊറ്റൻ എന്നിവ അർപ്പിച്ചിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","യഹോവ ബിലെയാമിന്റെ നാവിൽ ഒരു ദൂത് നൽകി, “ബാലാക്കിന്റെ അടുക്കൽ മടങ്ങിച്ചെന്ന് ഈ ദൂത് അവനു നൽകുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","അങ്ങനെ അദ്ദേഹം ബാലാക്കിന്റെ അടുക്കൽ മടങ്ങിച്ചെന്നു. അദ്ദേഹം മോവാബ്യ പ്രഭുക്കന്മാരെല്ലാവരോടുംകൂടെ തന്റെ യാഗത്തിന്റെ അടുക്കൽ നിൽക്കുന്നതു കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","അപ്പോൾ ബിലെയാം തന്റെ അരുളപ്പാട് അറിയിച്ചു: “ബാലാക്ക് അരാമിൽനിന്ന് എന്നെ കൊണ്ടുവന്നു, മോവാബ് രാജാവ് പൂർവഗിരികളിൽനിന്ന് എന്നെ വരുത്തി. ‘വരിക, എനിക്കുവേണ്ടി യാക്കോബിനെ ശപിക്കുക. വരിക, ഇസ്രായേലിനെ ശപിക്കുക’ ");
INSERT INTO malc_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ദൈവം ശപിക്കാത്തവരെ ഞാൻ എങ്ങനെ ശപിക്കും? യഹോവ ശകാരിക്കാത്തവരെ ഞാൻ എങ്ങനെ ശകാരിക്കും? ");
INSERT INTO malc_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","പാറക്കെട്ടുകളിൽനിന്ന് ഞാൻ അവരെ കാണുന്നു. ഗിരികളിൽനിന്ന് ഞാൻ അവരെ ദർശിക്കുന്നു. ഇതാ, വേറിട്ടു പാർക്കുന്നൊരു ജനം. അവർ ഇതര ജനതകളുടെ കൂട്ടത്തിൽ എണ്ണപ്പെടുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","യാക്കോബിന്റെ പൊടിയെ ആർക്ക് എണ്ണാം? ഇസ്രായേലിന്റെ കാൽഭാഗത്തെ ആർക്ക് എണ്ണാം? നീതിമാന്മാർ മരിക്കുന്നതുപോലെ ഞാൻ മരിക്കട്ടെ. എന്റെ അന്ത്യവും അവരുടേതുപോലെയാകട്ടെ!” ");
INSERT INTO malc_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ബാലാക്ക് ബിലെയാമിനോട്, “താങ്കൾ എന്നോടീ ചെയ്തത് എന്താണ്? എന്റെ ശത്രുക്കളെ ശപിക്കാൻ ഞാൻ താങ്കളെ കൂട്ടിക്കൊണ്ടുവന്നു, എന്നാൽ താങ്കൾ അവരെ അനുഗ്രഹിക്കുകമാത്രമാണു ചെയ്തത്!” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","അതിനു ബിലെയാം, “യഹോവ എന്റെ നാവിൽ തന്നതു ഞാൻ പറയേണ്ടതല്ലേ?” എന്നു മറുപടി പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","പിന്നെ ബാലാക്ക് അദ്ദേഹത്തോട്, “താങ്കൾക്ക് അവരെ കാണാവുന്ന മറ്റൊരു സ്ഥലത്തേക്ക് എന്നോടൊപ്പം വരിക; അവരിൽ ഒരു ഭാഗത്തെമാത്രം അല്ലാതെ എല്ലാവരെയും താങ്കൾക്കു കാണാൻ കഴിയുകയില്ല. അവിടെനിന്ന് അവരെ എനിക്കുവേണ്ടി ശപിക്കുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","അങ്ങനെ ബാലാക്ക് ബിലെയാമിനെ പിസ്ഗാമലയുടെ മുകളിലുള്ള സോഫീം വയലിലേക്കു കൊണ്ടുപോയി. അവിടെ അയാൾ ഏഴു യാഗപീഠങ്ങൾ നിർമിച്ച് ഓരോ പീഠത്തിന്മേലും ഓരോ കാളയെയും ഓരോ ആട്ടുകൊറ്റനെയും അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ബിലെയാം ബാലാക്കിനോട്: “താങ്കളുടെ ഹോമയാഗത്തിനരികെ നിൽക്കുക. ഞാൻ അവിടെ യഹോവയെ കാണട്ടെ.” ");
INSERT INTO malc_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","യഹോവ ബിലെയാമിനെ സന്ദർശിച്ച് അദ്ദേഹത്തിന്റെ നാവിൽ ഒരു സന്ദേശം കൊടുത്തിട്ട്, “ബാലാക്കിന്റെ അടുക്കൽ മടങ്ങിച്ചെന്ന് ഈ ദൂത് അവനു നൽകുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","അങ്ങനെ ബിലെയാം അയാളുടെ അടുക്കൽ മടങ്ങിച്ചെന്നു; മോവാബ്യപ്രഭുക്കന്മാർ എല്ലാവരോടുംകൂടെ അയാൾ തന്റെ യാഗത്തിന്റെ അടുക്കൽ നിൽക്കുന്നതു കണ്ടു. ബാലാക്ക് അദ്ദേഹത്തോട്, “യഹോവയുടെ അരുളപ്പാടെന്ത്?” എന്നു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","അപ്പോൾ അദ്ദേഹം അറിയിച്ച അരുളപ്പാട് ഇപ്രകാരമായിരുന്നു: “ബാലാക്കേ, എഴുന്നേറ്റു കേൾക്കുക, ശ്രദ്ധിച്ചുകേൾക്കുക; സിപ്പോരിന്റെ പുത്രാ, എനിക്കു ചെവിതരിക. ");
INSERT INTO malc_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","വ്യാജം പറയാൻ ദൈവം മനുഷ്യനല്ല, തന്റെ മനം മാറ്റാൻ മനുഷ്യപുത്രനുമല്ല. അരുളിച്ചെയ്തിട്ട് അവിടന്നു പ്രവർത്തിക്കാതിരിക്കുമോ? വാക്കു പറഞ്ഞിട്ട് നിറവേറ്റാതിരിക്കുമോ? ");
INSERT INTO malc_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","അനുഗ്രഹിക്കാനുള്ളൊരു കൽപ്പന എനിക്കു ലഭിച്ചിരിക്കുന്നു. അവിടന്ന് അനുഗ്രഹിച്ചിരിക്കുന്നു, എനിക്കതു മാറ്റിക്കൂടാ. ");
INSERT INTO malc_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“അത്യാഹിതം യാക്കോബിൽ കാണാനില്ല. ദുരിതം ഇസ്രായേലിൽ ദർശിക്കാനുമില്ല. യഹോവയായ അവരുടെ ദൈവം അവരോടുകൂടെയുണ്ട്. രാജാവിന്റെ ഗർജനം അവരുടെ മധ്യേയുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ഈജിപ്റ്റിൽനിന്ന് ദൈവം അവരെ കൊണ്ടുവന്നു; ഒരു കാട്ടുകാളയുടെ കരുത്ത് അവർക്കുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","യാക്കോബിനെതിരേ ആഭിചാരം ഫലിക്കുകയില്ല, ഇസ്രായേലിനെതിരായി ലക്ഷണവിദ്യയുമില്ല. യാക്കോബിനെയും ഇസ്രായേലിനെയുംപറ്റി, ഇപ്പോൾ ‘ദൈവം ചെയ്തതെന്തെന്നു കാണുക!’ എന്നു പറയപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ആ ജനം സിംഹിയെപ്പോലെ ഉണരുന്നു; അവർ സിംഹത്തെപ്പോലെ എഴുന്നേൽക്കുന്നു. അവർ തന്റെ ഇരയെ വിഴുങ്ങുകയും ആ കൊലയാളികളുടെ രക്തം കുടിക്കുകയുംചെയ്യുന്നതുവരെ വിശ്രമിക്കുകയില്ല.” ");
INSERT INTO malc_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","അപ്പോൾ ബാലാക്ക് ബിലെയാമിനോട്: “അവരെ ശപിക്കുകയും വേണ്ട, അനുഗ്രഹിക്കുകയും വേണ്ട!” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ബിലെയാം മറുപടിയായി, “യഹോവ എന്തു കൽപ്പിച്ചാലും ഞാൻ അതു ചെയ്യും എന്നു ഞാൻ താങ്കളോടു പറഞ്ഞില്ലേ?” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ഇതിനുശേഷം ബാലാക്ക് ബിലെയാമിനോട്, “വരിക, ഞാൻ താങ്കളെ മറ്റൊരു സ്ഥലത്തേക്ക് കൊണ്ടുപോകാം. ഒരുപക്ഷേ അവിടെനിന്ന് എനിക്കുവേണ്ടി അവരെ ശപിക്കേണ്ടതിനു നിന്നെ അനുവദിക്കാൻ ദൈവത്തിനു പ്രസാദമായേക്കും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","അങ്ങനെ ബാലാക്ക് ബിലെയാമിനെ മരുഭൂമിക്ക് എതിരേയുള്ള പെയോർമലയുടെ മുകളിലേക്കു കൊണ്ടുപോയി. ");
INSERT INTO malc_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ബിലെയാം പറഞ്ഞു: “ഇവിടെ ഏഴു യാഗപീഠം പണിത് ഏഴു കാളകളെയും ഏഴ് ആട്ടുകൊറ്റനെയും എനിക്കായി ഒരുക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ബിലെയാം പറഞ്ഞതുപോലെ ബാലാക്ക് ചെയ്തു. ഓരോ യാഗപീഠത്തിന്മേലും ഓരോ കാളയെയും ഓരോ ആട്ടുകൊറ്റനെയും അർപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","എന്നാൽ, ഇസ്രായേലിനെ അനുഗ്രഹിക്കുന്നത് യഹോവയ്ക്കു പ്രസാദമായി എന്നു ബിലെയാം കണ്ടപ്പോൾ, മുമ്പു ചെയ്തതുപോലെ പ്രശ്നംവെക്കാൻ പോകാതെ മരുഭൂമിക്കുനേരേ തന്റെ മുഖം തിരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ഗോത്രംഗോത്രമായി ഇസ്രായേൽ പാളയമടിച്ചു പാർക്കുന്നത് ബിലെയാം നോക്കിക്കണ്ടപ്പോൾ ദൈവത്തിന്റെ ആത്മാവ് അദ്ദേഹത്തിന്റെമേൽ വന്നു, ");
INSERT INTO malc_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","അദ്ദേഹം തന്റെ അരുളപ്പാട് അറിയിച്ചു: “ബെയോരിന്റെ പുത്രൻ ബിലെയാമിന്റെ അരുളപ്പാട്, വ്യക്തമായിക്കാണുന്ന കണ്ണുള്ളവന്റെ അരുളപ്പാട്, ");
INSERT INTO malc_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ദൈവത്തിന്റെ വചനങ്ങളെ കേൾക്കുന്നവന്റെ അരുളപ്പാട്, സർവശക്തനിൽനിന്ന് ദർശനം കാണുന്നവനും, സാഷ്ടാംഗം വീഴുന്നവനും കണ്ണുകൾ തുറക്കപ്പെട്ടവനുമായവന്റെ അരുളപ്പാട്: ");
INSERT INTO malc_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“യാക്കോബേ, നിന്റെ കൂടാരങ്ങൾ, ഇസ്രായേലേ, നിന്റെ നിവാസങ്ങൾ, എത്ര മനോഹരം! ");
INSERT INTO malc_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“താഴ്വരപോലെ അവ പടർന്നുകിടക്കുന്നു. നദീതീരത്തെ ഉദ്യാനങ്ങൾപോലെ, യഹോവ നട്ട ചന്ദനവൃക്ഷങ്ങൾപോലെ, ജലാന്തികേയുള്ള ദേവദാരുക്കൾപോലെതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","അവരുടെ തൊട്ടികളിൽനിന്ന് വെള്ളം ഒഴുകും; അവരുടെ വിത്തിനു ജലസമൃദ്ധി ലഭിക്കും. “അവരുടെ രാജാവ് ആഗാഗിലും ശ്രേഷ്ഠനായിരിക്കും, അവരുടെ രാജ്യം ഉന്നതമാകും. ");
INSERT INTO malc_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“ദൈവം അവരെ ഈജിപ്റ്റിൽനിന്നും കൊണ്ടുവന്നു. കാട്ടുകാളയുടെ കരുത്ത് അവർക്കുണ്ട്. ശത്രുരാജ്യങ്ങളെ അവർ വിഴുങ്ങുന്നു. അവരുടെ അസ്ഥികളെ തകർക്കുന്നു; തങ്ങളുടെ അസ്ത്രങ്ങൾകൊണ്ട് അവരെ തുളയ്ക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ഒരു സിംഹത്തെപ്പോലെ, ഒരു സിംഹിയെപ്പോലെ, അവർ പതുങ്ങിക്കിടക്കുന്നു. ആര് അവരെ ഉണർത്തും? “നിന്നെ അനുഗ്രഹിക്കുന്നവൻ അനുഗ്രഹിക്കപ്പെടട്ടെ, നിന്നെ ശപിക്കുന്നവൻ ശപിക്കപ്പെടട്ടെ!” ");
INSERT INTO malc_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","അപ്പോൾ ബിലെയാമിനെതിരേ ബാലാക്കിന്റെ കോപം ജ്വലിച്ചു. അദ്ദേഹം തന്റെ കൈകൾ അടിച്ചുകൊണ്ടു പറഞ്ഞു: “എന്റെ ശത്രുക്കളെ ശപിക്കാനാണു ഞാൻ താങ്കളെ വിളിച്ചുവരുത്തിയത്. എന്നാൽ താങ്കൾ അവരെ ഈ മൂന്നു തവണയും അനുഗ്രഹിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","നിന്റെ സ്ഥലത്തേക്കു നീ ഓടിപ്പോകുക. മാന്യമായ പ്രതിഫലം താങ്കൾക്കു തരാമെന്നു ഞാൻ പറഞ്ഞു. എന്നാൽ യഹോവ നിനക്കു പ്രതിഫലം മുടക്കിയിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ബിലെയാം ബാലാക്കിനോട് മറുപടി പറഞ്ഞു: “താങ്കൾ എന്റെയടുക്കൽ അയച്ച ദൂതന്മാരോട്, ");
INSERT INTO malc_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ബാലാക്ക് തന്റെ കൊട്ടാരം നിറയെ സ്വർണവും വെള്ളിയും എനിക്കു തരുന്നെങ്കിലും, യഹോവയുടെ കൽപ്പനയെ മറികടന്ന്, നന്മയോ തിന്മയോ ആകട്ടെ, സ്വമേധയാ യാതൊന്നും എനിക്കു ചെയ്തുകൂടാ; മാത്രമല്ല, യഹോവ അരുളിച്ചെയ്യുന്നതുമാത്രമേ ഞാൻ പറയുകയുള്ളൂ’ എന്നു ഞാൻ പറഞ്ഞിരുന്നില്ലേ? ");
INSERT INTO malc_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ഇപ്പോൾ ഞാൻ എന്റെ ജനത്തിന്റെ അടുക്കലേക്കു മടങ്ങിപ്പോകുന്നു. എന്നാൽ വരിക, വരുംനാളുകളിൽ ഈ ജനം താങ്കളുടെ ജനങ്ങളോട് ചെയ്യാൻ പോകുന്നതെന്തെന്ന് ഞാൻ താങ്കളെ അറിയിക്കാം.” ");
INSERT INTO malc_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","പിന്നെ ബിലെയാം തന്റെ അരുളപ്പാട് അറിയിച്ചു: “ബെയോരിന്റെ പുത്രൻ ബിലെയാമിന്റെ അരുളപ്പാട്, വ്യക്തമായിക്കാണുന്ന കണ്ണുള്ളവന്റെ അരുളപ്പാട്, ");
INSERT INTO malc_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ദൈവത്തിന്റെ വചനങ്ങളെ കേൾക്കുന്നവന്റെ അരുളപ്പാട്. പരമോന്നതനിൽനിന്ന് പരിജ്ഞാനം പ്രാപിച്ചവനും സർവശക്തനിൽനിന്ന് ദർശനം കാണുന്നവനും സാഷ്ടാംഗം വീഴുന്നവനും കണ്ണുകൾ തുറക്കപ്പെട്ടവനുമായവന്റെ അരുളപ്പാട്: ");
INSERT INTO malc_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“ഞാൻ അവിടത്തെ കാണുന്നു, എന്നാൽ ഇപ്പോഴല്ല; ഞാൻ അവിടത്തെ ദർശിക്കുന്നു, എന്നാൽ സമീപത്തല്ല. യാക്കോബിൽനിന്ന് ഒരു നക്ഷത്രം ഉദിക്കും, ഇസ്രായേലിൽനിന്ന് ഒരു ചെങ്കോൽ ഉയരും. മോവാബിന്റെ നെറ്റിത്തടം അവിടന്ന് തകർക്കും, ശേത്തിന്റെ സകലപുത്രന്മാരുടെയും തലയോട്ടികളെത്തന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ഏദോം പിടിക്കപ്പെടും; സേയീരും അവന്റെ ശത്രുക്കളുടെ കൈവശമാക്കപ്പെടും, എന്നാൽ ഇസ്രായേലോ ശക്തിപ്പെടും, ");
INSERT INTO malc_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","യാക്കോബിൽനിന്ന് ഒരു ഭരണാധിപൻ വന്ന് നഗരങ്ങളിൽ ശേഷിച്ചവരെ നശിപ്പിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","പിന്നെ ബിലെയാം അമാലേക്കിനെ നോക്കി തന്റെ അരുളപ്പാട് അറിയിച്ചു: “അമാലേക്ക് രാജ്യങ്ങളിൽ ഒന്നാമനായിരുന്നു. എന്നാൽ അവരുടെ അവസാനം പരിപൂർണനാശമായിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","പിന്നെ അയാൾ കേന്യരെ നോക്കി തന്റെ അരുളപ്പാട് അറിയിച്ചു: “നിന്റെ വാസസ്ഥലം സുരക്ഷിതം; നിന്റെ കൂട് പാറയിൽ വെച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","അശ്ശൂർ നിന്നെ ബന്ദിയായി കൊണ്ടുപോകുമ്പോൾ കേന്യരായ നിങ്ങൾ നശിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","പിന്നെ അദ്ദേഹം തന്റെ അരുളപ്പാട് അറിയിച്ചു: “ഹാ! ദൈവം ഇതു ചെയ്യുമ്പോൾ ആര് ജീവനോടിരിക്കും? ");
INSERT INTO malc_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","കിത്തീം തീരങ്ങളിൽനിന്ന് കപ്പലുകൾ വരും; അശ്ശൂരിനെയും ഏബെരിനെയും അവർ അധീനമാക്കും; എന്നാൽ അവരും നശിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","പിന്നെ ബിലെയാം എഴുന്നേറ്റ് സ്വദേശത്തേക്കു മടങ്ങി. ബാലാക്ക് തന്റെ വഴിക്കുപോയി. ");
INSERT INTO malc_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ഇസ്രായേൽ ശിത്തീമിൽ പാർക്കുമ്പോൾ അവരുടെ പുരുഷന്മാർ മോവാബ്യസ്ത്രീകളുമായി ലൈംഗിക അസാന്മാർഗികതയിലേർപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","അവർ തങ്ങളുടെ ദേവന്മാർക്കുള്ള ബലികൾക്ക് അവരെ വിളിക്കുകയും. ജനം ഈ ദേവന്മാരുടെമുമ്പാകെ ഭക്ഷിക്കുകയും അവയെ വണങ്ങുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","അങ്ങനെ പെയോരിലെ ബാലിന്റെ ആരാധനയിൽ ഇസ്രായേൽ കൂട്ടുചേർന്നു. യഹോവയുടെ കോപം അവർക്കെതിരേ ജ്വലിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","യഹോവ മോശയോട്, “യഹോവയുടെ ഉഗ്രകോപം ഇസ്രായേലിനെ വിട്ടുമാറേണ്ടതിന്, ജനത്തിന്റെ നായകന്മാരെ സകലരെയും കൂട്ടി യഹോവയുടെമുമ്പാകെ അവരെ കൊന്ന് പകൽവെളിച്ചത്തിൽ പ്രദർശിപ്പിക്കുക” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","മോശ ഇസ്രായേലിന്റെ ന്യായാധിപന്മാരോട്, “നിങ്ങളുടെ പുരുഷന്മാരിൽ പെയോരിലെ ബാലിന്റെ ആരാധനയിൽ കൂട്ടുചേർന്നവരെ നിങ്ങൾതന്നെ വധിക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ഈ വിധി വന്നതിനുശേഷം, മോശയും ഇസ്രായേൽസഭ മുഴുവനും സമാഗമകൂടാരവാതിൽക്കൽ വിലപിച്ചുകൊണ്ടിരിക്കുമ്പോൾ അവരുടെ കണ്മുമ്പിൽത്തന്നെ ഒരു ഇസ്രായേല്യപുരുഷൻ ഒരു മിദ്യാന്യസ്ത്രീയെ തന്റെ കൂടാരത്തിലേക്കു കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","പുരോഹിതനായ അഹരോന്റെ മകൻ എലെയാസാരിന്റെ പുത്രൻ ഫീനെഹാസ് ഇതു കണ്ടപ്പോൾ, അദ്ദേഹം സഭയിൽനിന്ന് എഴുന്നേറ്റ് ഒരു കുന്തം കൈയിലെടുത്ത് ");
INSERT INTO malc_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ആ ഇസ്രായേല്യന്റെ പിന്നാലെ കൂടാരത്തിലേക്കുചെന്നു. അവർ ഇരുവരെയും—ഇസ്രായേല്യനെയും ആ സ്ത്രീയെയും—അവരുടെ ഉദരം തുളയുമാറ് കുന്തംകൊണ്ട് കുത്തി. അപ്പോൾ ഇസ്രായേല്യർക്കെതിരായ ബാധ ശമിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","എന്നാൽ ബാധയിൽ മരിച്ചവരുടെ എണ്ണം 24,000 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","യഹോവ മോശയോട്, ");
INSERT INTO malc_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“പുരോഹിതനായ അഹരോന്റെ പുത്രൻ എലെയാസാരിന്റെ പുത്രൻ ഫീനെഹാസ് ഇസ്രായേല്യർക്കെതിരേയുള്ള എന്റെ കോപം വിട്ടുമാറാനിടയാക്കി. അവരുടെ ഇടയിൽ എന്റെ മാനത്തിനുവേണ്ടി എന്നെപ്പോലെതന്നെ അവനും തീക്ഷ്ണത കാട്ടിയിരിക്കുകയാൽ എന്റെ തീക്ഷ്ണതയിൽ ഞാൻ അവരെ ഇല്ലായ്മചെയ്യുന്നതിൽനിന്ന് പിന്തിരിഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","അതുകൊണ്ട് ഞാൻ അവനുമായി എന്റെ സമാധാന ഉടമ്പടിചെയ്യുന്നു എന്ന് അവനോടു പറയുക. ");
INSERT INTO malc_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","അവൻ തന്റെ ദൈവത്തിനുവേണ്ടി തീക്ഷ്ണതയുള്ളവനായി ഇസ്രായേല്യർക്കുവേണ്ടി പ്രായശ്ചിത്തം ചെയ്തതിനാൽ അത് അവനും അവന്റെ സന്തതിപരമ്പരകൾക്കും സുസ്ഥിരമായ ഒരു പൗരോഹിത്യത്തിന്റെ ഉടമ്പടി ആകുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","മിദ്യാന്യസ്ത്രീയോടുകൂടി കൊല്ലപ്പെട്ട ഇസ്രായേല്യന്റെ പേര് സിമ്രി എന്നായിരുന്നു. അവൻ ശിമെയോൻ ഗോത്രത്തിലെ ഒരു കുടുംബത്തിന്റെ നായകനായിരുന്ന സാലുവിന്റെ മകനായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","കൊല്ലപ്പെട്ട മിദ്യാന്യസ്ത്രീയുടെ പേര് കോസ്ബി എന്നായിരുന്നു; അവൾ മിദ്യാന്യവംശത്തിൽപ്പെട്ട ഒരു കുടുംബത്തിന്റെ ഗോത്രത്തലവനായ സൂരിന്റെ മകളായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","യഹോവ മോശയോട്, ");
INSERT INTO malc_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","18","“പെയോരിലെ ബാലിന്റെ കാര്യത്തിലും, തൻനിമിത്തം ഉണ്ടായ ബാധയിൽ കൊല്ലപ്പെട്ട അവരുടെ സഹോദരിയും ഒരു മിദ്യാന്യപ്രഭുവിന്റെ മകളുമായ കോസ്ബിയുടെ കാര്യത്തിലും മിദ്യാന്യർ നിങ്ങളെ വഞ്ചിച്ച് നിങ്ങളോടു ശത്രുത കാട്ടിയതിനാൽ, നിങ്ങൾ അവരോടും ശത്രുത കാട്ടി അവരെ നിശ്ശേഷം നശിപ്പിക്കണം” എന്നു കൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ബാധയ്ക്കുശേഷം യഹോവ മോശയോടും പുരോഹിതനായ അഹരോന്റെ പുത്രൻ എലെയാസാരിനോടും കൽപ്പിച്ചു: ");
INSERT INTO malc_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു പ്രായമുള്ളവരും യുദ്ധപ്രാപ്തരുമായി ഇസ്രായേൽസമൂഹത്തിലാകെ ഉള്ളവരുടെ ജനസംഖ്യ പിതൃഭവനം തിരിച്ച് കണക്കാക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","യെരീഹോവിനെതിരേ യോർദാൻനദിക്കരികെയുള്ള മോവാബിന്റെ സമതലത്തിൽവെച്ച് മോശയും പുരോഹിതനായ എലെയാസാരും അവരോട് ഇപ്രകാരം പറഞ്ഞു: ");
INSERT INTO malc_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ ഇരുപതു വയസ്സുമുതൽ മേലോട്ട് പ്രായമുള്ള പുരുഷന്മാരുടെ ജനസംഖ്യയെടുക്കുക.” ഈജിപ്റ്റിൽനിന്നും പുറപ്പെട്ട ഇസ്രായേല്യർ ഇവരായിരുന്നു: ");
INSERT INTO malc_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ഇസ്രായേലിന്റെ ആദ്യജാതനായ രൂബേന്റെ സന്തതികൾ: ഹാനോക്കിലൂടെ ഹാനോക്ക്യകുടുംബം; ഫല്ലുവിലൂടെ ഫല്ലൂവ്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ഹെസ്രോനിലൂടെ ഹെസ്രോന്യകുടുംബം; കർമിയിലൂടെ കർമ്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ഇവയായിരുന്നു രൂബേന്യകുടുംബങ്ങൾ; അതിൽ എണ്ണപ്പെട്ടവർ 43,730 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ഫല്ലൂവിന്റെ പുത്രൻ എലീയാബ്. ");
INSERT INTO malc_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","എലീയാബിന്റെ പുത്രന്മാർ നെമൂവേലും ദാഥാനും അബീരാമും ആയിരുന്നു. മോശയ്ക്കും അഹരോനും എതിരേ മത്സരിച്ചവരും യഹോവയ്ക്കെതിരേ മത്സരിച്ചപ്പോൾ കോരഹിന്റെ അനുയായികളുടെ കൂട്ടത്തിലുണ്ടായിരുന്ന ഇസ്രായേല്യപ്രഭുക്കന്മാരായ ദാഥാനും അബീരാമും ഇവർതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ഭൂമി വായ്‌പിളർന്ന് കോരഹിനോടുകൂടെ അവരെ വിഴുങ്ങിക്കളഞ്ഞു. ഇരുനൂറ്റി അൻപത് പുരുഷന്മാർ അഗ്നിക്കിരയായ അവസരത്തിൽ അയാളുടെ അനുയായികൾ മരിച്ചു. അങ്ങനെ അവർ മുന്നറിയിപ്പിനുള്ള ഒരു ചിഹ്നമായിത്തീർന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","എന്നാൽ കോരഹിന്റെ പുത്രന്മാർ ആ ദിവസം മരിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ശിമെയോന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: നെമൂവേലിലൂടെ നെമൂവേല്യകുടുംബം; യാമിനിലൂടെ യാമിന്യകുടുംബം; യാഖീനിലൂടെ യാഖീന്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","സേരഹിലൂടെ സേരഹ്യകുടുംബം; ശാവൂലിലൂടെ ശാവൂല്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ഇവയായിരുന്നു ശിമെയോന്യകുടുംബങ്ങൾ; അതിൽ എണ്ണപ്പെട്ടവർ 22,200 പുരുഷന്മാർ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ഗാദിന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: സെഫോനിലൂടെ സെഫോന്യകുടുംബം; ഹഗ്ഗീയിലൂടെ ഹഗ്ഗീയകുടുംബം; ശൂനിയിലൂടെ ശൂനീയകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ഒസ്നിയിലൂടെ ഒസ്നീയകുടുംബം; ഏരിയിലൂടെ ഏര്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","അരോദിലൂടെ അരോദ്യകുടുംബം; അരേലിയിലൂടെ അരേല്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ഗാദിന്റെ കുടുംബങ്ങൾ ഇവയായിരുന്നു; അതിൽ എണ്ണപ്പെട്ടവർ 40,500 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ഏരും ഓനാനും യെഹൂദയുടെ പുത്രന്മാർ ആയിരുന്നു. എന്നാൽ അവർ കനാനിൽവെച്ചു മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","യെഹൂദയുടെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: ശേലഹിലൂടെ ശേലഹ്യകുടുംബം; ഫേരെസിലൂടെ ഫേരെസ്യകുടുംബം; സേരഹിലൂടെ സേരഹ്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ഫേരെസിന്റെ സന്തതികൾ: ഹെസ്രോനിലൂടെ ഹെസ്രോന്യകുടുംബം; ഹാമൂലിലൂടെ ഹാമൂല്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","യെഹൂദയുടെ കുടുംബങ്ങൾ ഇവയായിരുന്നു. അതിൽ എണ്ണപ്പെട്ടവർ 76,500 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","യിസ്സാഖാറിന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: തോലാവിലൂടെ തോലാവ്യകുടുംബം; പൂവായിലൂടെ പൂവ്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","യാശൂബിലൂടെ യാശൂബ്യകുടുംബം; ശിമ്രോനിലൂടെ ശിമ്രോന്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","യിസ്സാഖാർ പിതൃഭവനത്തിൽനിന്ന് ഉള്ളവർ ഇവരായിരുന്നു. അതിൽ എണ്ണപ്പെട്ടവർ 64,300 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","സെബൂലൂന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: സേരെദിലൂടെ സേരെദ്യകുടുംബം, ഏലോനിലൂടെ ഏലോന്യകുടുംബം, യഹ്ലെയേലിലൂടെ യഹ്ലെയേല്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","സെബൂലൂൻ കുടുംബങ്ങൾ ഇവയായിരുന്നു. അതിൽ എണ്ണപ്പെട്ടവർ 60,500 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","മനശ്ശെ, എഫ്രയീം എന്നിവരിലൂടെ യോസേഫിന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: ");
INSERT INTO malc_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","മനശ്ശെയുടെ സന്തതികൾ: മാഖീരിലൂടെ മാഖീര്യകുടുംബം; മാഖീർ ഗിലെയാദിന്റെ പിതാവായിരുന്നു; ഗിലെയാദിലൂടെ ഗിലെയാദ്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ഗിലെയാദിന്റെ സന്തതികൾ: ഈയേസെരിലൂടെ ഈയേസെര്യകുടുംബം: ഹേലെക്കിലൂടെ ഹേലെക്ക്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","അസ്രീയേലിലൂടെ അസ്രീയേല്യകുടുംബം; ശേഖേമിലൂടെ ശേഖേമ്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ശെമീദാവിലൂടെ ശെമീദാവ്യകുടുംബം; ഹേഫെരിലൂടെ ഹേഫെര്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ഹേഫെരിന്റെ പുത്രൻ സെലോഫഹാദിനു പുത്രന്മാരില്ലായിരുന്നു; അദ്ദേഹത്തിനു പുത്രിമാർമാത്രമേ ഉണ്ടായിരുന്നുള്ളൂ. അവരുടെ പേരുകൾ: മഹ്ലാ, നോവാ, ഹൊഗ്ലാ, മിൽക്കാ, തിർസാ എന്നിവരായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","മനശ്ശെയുടെ കുടുംബങ്ങൾ ഇവയായിരുന്നു; അതിൽ എണ്ണപ്പെട്ടവർ 52,700 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","എഫ്രയീമിന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: ശൂഥേലഹിലൂടെ ശൂഥേലഹ്യകുടുംബം; ബേഖെരിലൂടെ ബേഖെര്യകുടുംബം; തഹനിലൂടെ തഹന്യകടുംബം, ");
INSERT INTO malc_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ശൂഥേലഹിന്റെ സന്തതികൾ: ഏരാനിലൂടെ ഏരാന്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","എഫ്രയീമിന്റെ കുടുംബങ്ങൾ ഇവയായിരുന്നു. അതിൽ എണ്ണപ്പെട്ടവർ 32,500 ആയിരുന്നു. ഇവയായിരുന്നു യോസേഫിന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ. ");
INSERT INTO malc_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ബെന്യാമീന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: ബേലയിലൂടെ ബേലാവ്യകുടുംബം; അശ്ബേലിലൂടെ അശ്ബേല്യകുടുംബം; അഹീരാമിലൂടെ അഹീരാമ്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ശൂപാമിലൂടെ ശൂപാമ്യകുടുംബം; ഹൂഫാമിലൂടെ ഹൂഫാമ്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ആരെദ്, നയമാൻ എന്നിവരിലൂടെയുള്ള ബേലിയുടെ സന്തതികൾ: അർദിലൂടെ അർദ്യകുടുംബം. നാമാനിലൂടെ നാമാന്യകുടുംബം ");
INSERT INTO malc_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ബെന്യാമീന്റെ കുടുംബങ്ങൾ ഇവയായിരുന്നു; അവരിൽ എണ്ണപ്പെട്ടവർ 45,600 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ദാന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: ശൂഹാമിലൂടെ ശൂഹാമ്യകുടുംബം. ദാന്റെ കുടുംബങ്ങൾ ഇവയായിരുന്നു; ");
INSERT INTO malc_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","അവയെല്ലാം ശൂഹാമ്യകുടുംബങ്ങളായിരുന്നു; അവരിൽ എണ്ണപ്പെട്ടവർ 64,400 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ആശേരിന്റെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: യിമ്നായിലൂടെ യിമ്നീയകുടുംബം; യിശ്വിയിലൂടെ യിശ്വീയകുടുംബം; ബേരീയാവിലൂടെ ബേരീയാവ്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ബേരീയാവിന്റെ സന്തതികളിലൂടെ: ഹേബെരിലൂടെ ഹേബെര്യകുടുംബം; മൽക്കീയേലിലൂടെ മൽക്കീയേല്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ആശേരിന് സേരഹ് എന്നു പേരുള്ള ഒരു മകൾ ഉണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ആശേരിന്റെ കുടുംബങ്ങൾ ഇവയായിരുന്നു; അവരിൽ എണ്ണപ്പെട്ടവർ 53,400 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","നഫ്താലിയുടെ പിതൃഭവനത്തിൽനിന്നുള്ള സന്തതികൾ: യഹ്സേലിലൂടെ യഹ്സേല്യകുടുംബം; ഗൂനിയിലൂടെ ഗൂന്യകുടുംബം; ");
INSERT INTO malc_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","യെസെരിലൂടെ യെസെര്യകടുംബം; ശില്ലേമിലൂടെ ശില്ലേമ്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ഇവയായിരുന്നു നഫ്താലിയുടെ കുടുംബങ്ങൾ; അതിൽ എണ്ണപ്പെട്ടവർ 45,400 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ഇസ്രായേലിലെ പുരുഷന്മാരുടെ ആകെ എണ്ണം 6,01,730 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","യഹോവ മോശയോട്, ");
INSERT INTO malc_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ആളെണ്ണത്തിനൊത്തവണ്ണം ദേശം അവർക്ക് അവകാശമായി വിഭജിച്ചു കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","വലിയ കൂട്ടത്തിനു കൂടുതലും ചെറിയ കൂട്ടത്തിനു കുറവുമായി ഓഹരി കൊടുക്കുക. പട്ടികയിൽ പേരു ചേർക്കപ്പെട്ടവരുടെ എണ്ണത്തിനൊത്തവണ്ണം ഓരോരുത്തർക്കും അവരവരുടെ ഓഹരി ലഭിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","നറുക്കിട്ടുവേണം ദേശം വിഭജിക്കേണ്ടത്. പിതൃഗോത്രത്തിന്റെ പേരിൻപ്രകാരമായിരിക്കണം ഓരോ കൂട്ടത്തിനും ഓഹരി ലഭിക്കേണ്ടത്. ");
INSERT INTO malc_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","വലിയ കൂട്ടങ്ങൾക്കും ചെറിയ കൂട്ടങ്ങൾക്കും നറുക്കിലൂടെയാണ് ഓഹരി വിഭജിച്ചുകൊടുക്കേണ്ടത്.” ");
INSERT INTO malc_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","പിതൃഭവനമായി എണ്ണപ്പെട്ട ലേവ്യർ ഇവരായിരുന്നു: ഗെർശോനിലൂടെ ഗെർശോന്യകുടുംബം; കെഹാത്തിലൂടെ കെഹാത്യകുടുംബം; മെരാരിയിലൂടെ മെരാര്യകുടുംബം. ");
INSERT INTO malc_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ഇവയും ലേവ്യകുടുംബങ്ങളായിരുന്നു: ലിബ്നീയകുടുംബം, ഹെബ്രോന്യകുടുംബം, മഹ്ലീയകുടുംബം, മൂശ്യകുടുംബം, കോരഹ്യകുടുംബം. അമ്രാമിന്റെ പിതാമഹനായിരുന്നു കെഹാത്ത്; ");
INSERT INTO malc_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","അമ്രാമിന്റെ ഭാര്യയുടെ പേര് യോഖേബേദ് എന്നായിരുന്നു. അവൾ ഈജിപ്റ്റിൽവെച്ച് ലേവിക്കു ജനിച്ച മകൾ. അമ്രാമിന് അവൾ, അഹരോൻ, മോശ, അവരുടെ സഹോദരിയായ മിര്യാം എന്നിവരെ പ്രസവിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","നാദാബ്, അബീഹൂ, എലെയാസാർ, ഈഥാമാർ എന്നിവരുടെ പിതാവായിരുന്നു അഹരോൻ. ");
INSERT INTO malc_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","എന്നാൽ യഹോവയുടെമുമ്പാകെ അന്യാഗ്നി കത്തിച്ചതുകൊണ്ട് നാദാബും അബീഹൂവും മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ലേവ്യരിൽ ഒരുമാസമോ അതിലധികമോ പ്രായമായ ആണുങ്ങൾ 23,000 ആയിരുന്നു. മറ്റ് ഇസ്രായേല്യരോടൊപ്പം അവരെ എണ്ണിയില്ല; കാരണം അവരുടെ ഇടയിൽ അവർക്ക് യാതൊരവകാശവും ലഭിച്ചില്ല. ");
INSERT INTO malc_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","യെരീഹോവിനെതിരേ യോർദാൻനദിക്കരികെയുള്ള മോവാബിന്റെ സമതലത്തിൽവെച്ച് മോശയും പുരോഹിതനായ എലെയാസാരും എണ്ണിയ ഇസ്രായേല്യർ ഇവരാണ്. ");
INSERT INTO malc_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","മോശയും പുരോഹിതനായ അഹരോനുംകൂടി ഇസ്രായേൽമക്കളെ സീനായിമരുഭൂമിയിൽവെച്ച് എണ്ണിയപ്പോൾ എണ്ണപ്പെട്ടവരുടെ കൂട്ടത്തിൽ ഇവരിൽ ഒരാൾപോലും ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","അവർ നിശ്ചയമായും മരുഭൂമിയിൽ മരിച്ചുപോകുമെന്ന് അവരെക്കുറിച്ച് യഹോവ അരുളിച്ചെയ്തിരുന്നല്ലോ. അങ്ങനെ യെഫുന്നയുടെ മകൻ കാലേബും നൂന്റെ മകൻ യോശുവയും ഒഴികെ അവരിൽ ഒരാൾപോലും ശേഷിച്ചിരുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","യോസേഫിന്റെ മകനായ മനശ്ശെയുടെ കുടുംബങ്ങളിൽ മനശ്ശെയുടെ മകനായ മാഖീരിന്റെ മകനായ ഗിലെയാദിന്റെ മകനായ ഹേഫെരിന്റെ മകനായ സെലോഫഹാദിന്റെ പുത്രിമാർ, മഹ്ലാ, നോവാ, ഹൊഗ്ലാ, മിൽക്കാ, തിർസാ എന്നിവർ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","അവർ സമാഗമകൂടാരത്തിന്റെ കവാടത്തിൽ വന്ന്, മോശ, പുരോഹിതനായ എലെയാസാർ, പ്രഭുക്കന്മാർ എന്നിവരുടെയും സർവസഭയുടെയും മുമ്പാകെ നിന്ന് പറഞ്ഞു: ");
INSERT INTO malc_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“ഞങ്ങളുടെ പിതാവ് മരുഭൂമിയിൽവെച്ച് മരിച്ചു. യഹോവയ്ക്കെതിരേ മത്സരിച്ച കോരഹിന്റെ അനുയായികളുടെ കൂട്ടത്തിൽ അദ്ദേഹം ഉണ്ടായിരുന്നില്ല. അദ്ദേഹം സ്വന്തപാപത്തിലാണ് മരിച്ചത്. അദ്ദേഹത്തിനു പുത്രന്മാർ ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO malc_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ഞങ്ങളുടെ പിതാവിനു പുത്രന്മാർ ഇല്ലാതിരുന്നതിനാൽ അദ്ദേഹത്തിന്റെ പേര് തന്റെ കുടുംബത്തിൽനിന്നും നീക്കപ്പെടുന്നതെന്തിന്? ഞങ്ങൾക്ക് ഞങ്ങളുടെ പിതാവിന്റെ ബന്ധുക്കളുടെ ഇടയിൽ ഒരവകാശം തരണം.” ");
INSERT INTO malc_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","അങ്ങനെ മോശ അവരുടെ കാര്യം യഹോവയുടെമുമ്പാകെ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“സെലോഫഹാദിന്റെ പുത്രിമാർ പറയുന്ന കാര്യം ശരിയാണ്. നീ നിശ്ചയമായും അവർക്ക് അവരുടെ പിതാവിന്റെ ബന്ധുക്കളുടെ ഇടയിൽ ഒരവകാശം നൽകണം. അവരുടെ പിതാവിന്റെ ഓഹരി അവർക്കു നൽകണം. ");
INSERT INTO malc_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“ഇസ്രായേല്യരോടു പറയുക: ‘ഒരു മനുഷ്യൻ മരിക്കുകയും തനിക്കു പുത്രന്മാരില്ലാതിരിക്കുകയും ചെയ്താൽ അയാളുടെ ഓഹരി പുത്രിമാർക്കു കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","അവനു പുത്രിമാരില്ലെങ്കിൽ അവന്റെ ഓഹരി തന്റെ സഹോദരന്മാർക്കു കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","അവനു സഹോദരന്മാരില്ലെങ്കിൽ അവന്റെ ഓഹരി തന്റെ പിതൃസഹോദരന്മാർക്കു കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","അവന്റെ പിതാവിന് സഹോദരന്മാരില്ലെങ്കിൽ അവന്റെ ഓഹരി തന്റെ കുടുംബത്തിലെ അടുത്ത ബന്ധുവിനു കൊടുക്കണം. ഇതു യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ ഇസ്രായേൽമക്കൾക്ക് ഒരു നിയമവും ചട്ടവുമായിരിക്കണം.’ ” ");
INSERT INTO malc_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ഇതിനുശേഷം യഹോവ മോശയോട്, “അബാരീംനിരയിലുള്ള ഈ പർവതത്തിൽ കയറി ഞാൻ ഇസ്രായേല്യർക്കു കൊടുത്തിരിക്കുന്ന ദേശം കാണുക. ");
INSERT INTO malc_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","നീ അതു കണ്ടശേഷം നീയും നിന്റെ സഹോദരനായ അഹരോനെപ്പോലെ നിന്റെ ജനത്തോടു ചേർക്കപ്പെടും. ");
INSERT INTO malc_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","സീൻ മരുഭൂമിയിൽവെച്ച് വെള്ളത്തിന്റെ കാര്യത്തിൽ എന്നെ വിശുദ്ധീകരിക്കാനുള്ള എന്റെ കൽപ്പനയോടു നിങ്ങൾ മത്സരിച്ചതുകൊണ്ടുതന്നെ” എന്നു പറഞ്ഞു. സീൻമരുഭൂമിയിൽ കാദേശിലെ മെരീബാജലാശയം ഇതുതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","മോശ യഹോവയോട്, ");
INSERT INTO malc_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","“യഹോവയുടെ ജനം ഇടയനില്ലാത്ത ആടുകളെപ്പോലെ ആകാതിരിക്കാൻ, അവർക്കുമുമ്പാകെ പോകാനും വരാനും പുറത്തുകൊണ്ടുപോകാനും അകത്തുകൊണ്ടുവരാനും സകലജഡത്തിന്റെയും ആത്മാക്കളുടെ ദൈവമായ യഹോവേ, ഈ സഭയുടെമേൽ ഒരു മനുഷ്യനെ നിയമിച്ചാലും” എന്നു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","അതുകൊണ്ട് യഹോവ മോശയോട്: “നൂന്റെ മകനും, എന്റെ ആത്മാവുള്ള പുരുഷനുമായ യോശുവയെ വിളിച്ച് നിന്റെ കൈ അവന്റെമേൽ വെക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","അവനെ പുരോഹിതനായ എലെയാസാരിന്റെയും സർവസഭയുടെയും മുമ്പാകെ നിർത്തി അവരുടെ സാന്നിധ്യത്തിൽ അവനെ അധികാരം ഏൽപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","നിന്റെ അധികാരത്തിൽ കുറെ അവനു കൊടുക്കുക. അങ്ങനെ ഇസ്രായേൽമക്കളുടെ സഭമുഴുവനും അവനെ അനുസരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","അവൻ പുരോഹിതനായ എലെയാസാരിന്റെ മുമ്പാകെ നിൽക്കണം. യഹോവയുടെമുമ്പാകെ ഊറീം മുഖാന്തരം അരുളപ്പാടു ചോദിക്കുന്നതിലൂടെ അദ്ദേഹം അവനുവേണ്ടിയുള്ള തീരുമാനങ്ങൾ അറിയും. അവന്റെ കൽപ്പനയിങ്കൽ അയാളും ഇസ്രായേല്യരുടെ സർവസമൂഹവും പുറത്തുപോകുകയും അയാളുടെ കൽപ്പനയിങ്കൽ അവർ അകത്തുവരികയും ചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","യഹോവ തന്നോടു കൽപ്പിച്ചതുപോലെ മോശ ചെയ്തു. അദ്ദേഹം യോശുവയെ കൂട്ടിക്കൊണ്ട് പുരോഹിതനായ എലെയാസാരിന്റെയും സർവസഭയുടെയും മുമ്പാകെ നിർത്തി. ");
INSERT INTO malc_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","യഹോവ മോശയോടു നിർദേശിച്ചപ്രകാരം അവന്റെമേൽ കൈവെച്ച് ജനത്തെ നയിക്കാനുള്ള അധികാരം ഏൽപ്പിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","യഹോവ മോശയോട് ഇപ്രകാരം അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ഇസ്രായേൽമക്കൾക്ക് ഈ കൽപ്പന നൽകി അവരോടു പറയുക: ‘എനിക്കു ഹൃദ്യസുഗന്ധമായി ദഹനയാഗമാകുന്ന വഴിപാടുകൾ യഥാസമയം അർപ്പിക്കാൻ നിങ്ങൾ ശ്രദ്ധിക്കുക’ ");
INSERT INTO malc_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","അവരോടു പറയുക: ‘യഹോവയ്ക്കു നിങ്ങൾ അർപ്പിക്കേണ്ട ദഹനയാഗം ഇതാണ്: ദിവസംതോറും ഒരുവയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത രണ്ട് കുഞ്ഞാടിനെ നിരന്തരം അർപ്പിക്കേണ്ട ഹോമയാഗമായി അർപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ഒരു കുഞ്ഞാടിനെ രാവിലെയും മറ്റേ കുഞ്ഞാടിനെ വൈകുന്നേരത്തും യാഗമർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ഇടിച്ചുപിഴിഞ്ഞെടുത്ത ഒലിവെണ്ണ കാൽ ഹീൻ ചേർത്ത ഒരു ഓമെർ നേരിയമാവ് ഭോജനയാഗമായും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ഇതു ഹൃദ്യസുഗന്ധമായി, യഹോവയ്ക്കു ദഹനയാഗമായി സീനായിമലയിൽവെച്ച് നിയമിക്കപ്പെട്ട, നിരന്തരം അർപ്പിക്കേണ്ട ഹോമയാഗം. ");
INSERT INTO malc_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","അതിന്റെ പാനീയയാഗം ഓരോ കുഞ്ഞാടിനുമൊപ്പം കാൽ ഹീൻ വീര്യമുള്ള പാനീയം ആയിരിക്കണം. യഹോവയ്ക്കുള്ള പാനീയയാഗം വിശുദ്ധമന്ദിരത്തിൽ ഒഴിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","രാവിലെ നിങ്ങൾ അർപ്പിക്കുന്നവിധംതന്നെയുള്ള ഭോജനയാഗത്തോടും പാനീയയാഗത്തോടുമൊപ്പം രണ്ടാമത്തെ കുഞ്ഞാടിനെ വൈകുന്നേരത്ത് അർപ്പിക്കണം. ഇത് യഹോവയ്ക്ക് ഹൃദ്യസുഗന്ധമായ ദഹനയാഗം. ");
INSERT INTO malc_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘ശബ്ബത്തുദിവസം, ഒരുവയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത രണ്ടു കുഞ്ഞാടുകളെ, അതിന്റെ പാനീയയാഗത്തോടും, അതിന്റെ ഭോജനയാഗമായ ഒലിവെണ്ണചേർത്ത രണ്ട് ഓമെർ നേരിയമാവോടുംകൂടെ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","എല്ലാ ശബ്ബത്തിനുമുള്ള ഹോമയാഗം ഇതുതന്നെ. നിരന്തരം അർപ്പിക്കേണ്ട ഹോമയാഗത്തിനും അതിന്റെ പാനീയയാഗത്തിനും പുറമേയുള്ളതാണ് ഇത്. ");
INSERT INTO malc_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘എല്ലാമാസവും ഒന്നാംദിവസം ഊനമില്ലാത്ത രണ്ടു കാളക്കിടാങ്ങൾ, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഏഴ് ആൺകുഞ്ഞാട് ഇവ ഹോമയാഗമായി യഹോവയ്ക്ക് അർപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ഓരോ കാളയോടുംകൂടെ ഒലിവെണ്ണചേർത്ത മൂന്ന് ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗവും, ആട്ടുകൊറ്റനോടുകൂടെ എണ്ണചേർത്ത രണ്ട് ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗവും, ");
INSERT INTO malc_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ഓരോ കുഞ്ഞാടിനോടുംകൂടെ എണ്ണചേർത്ത ഒരു ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗവും ഉണ്ടായിരിക്കണം. ഇതു ഹോമയാഗത്തിനുവേണ്ടിയുള്ളതാണ്; യഹോവയ്ക്ക് ഹൃദ്യസുഗന്ധമായ ദഹനയാഗമായി അർപ്പിക്കപ്പെടുന്ന ഹോമയാഗംതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","അവയുടെ പാനീയയാഗം കാളയൊന്നിന് അര ഹീനും ഓരോ ആട്ടുകൊറ്റനും മൂന്നിലൊന്നു ഹീനും, ഓരോ കുഞ്ഞാടിനും കാൽ ഹീനും വീഞ്ഞ് ആയിരിക്കണം. വർഷത്തിലെ എല്ലാ അമാവാസിയിലും അർപ്പിക്കേണ്ട മാസംതോറുമുള്ള ദഹനയാഗം ഇതുതന്നെ. ");
INSERT INTO malc_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","പാനീയയാഗത്തോടുകൂടെ നിരന്തരം അർപ്പിക്കേണ്ട ഹോമയാഗത്തിനുപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും യഹോവയ്ക്ക് അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘ഒന്നാംമാസം പതിന്നാലാംതീയതി യഹോവയുടെ പെസഹാ ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ഈ മാസത്തിന്റെ പതിനഞ്ചാംതീയതി ഒരു ഉത്സവം ഉണ്ടായിരിക്കണം; ഏഴുദിവസം പുളിപ്പില്ലാത്ത അപ്പം ഭക്ഷിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ഒന്നാംദിവസം വിശുദ്ധസഭായോഗം കൂടണം, അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","യഹോവയ്ക്ക് അർപ്പിക്കുന്ന ദഹനയാഗം: ഊനമില്ലാത്ത രണ്ടു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമായ ഏഴ് ആൺകുഞ്ഞാട് എന്നിവ ഒരു ഹോമയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ഓരോ കാളയോടുംകൂടെ ഒലിവെണ്ണചേർത്ത മൂന്ന് ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗവും, ആട്ടുകൊറ്റനോടുകൂടെ രണ്ട് ഓമെറും ");
INSERT INTO malc_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ഏഴ് കുഞ്ഞാടുകളിൽ ഓരോന്നിനോടുംകൂടെ ഒരു ഓമെറും ഒരുക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","നിങ്ങൾക്കു പ്രായശ്ചിത്തം വരുത്താൻ പാപശുദ്ധീകരണയാഗത്തിന് ഒരു കോലാടിനെയുംകൂടി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","പ്രഭാതത്തിൽ നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനുപുറമേയാണ് ഇവ ഒരുക്കേണ്ടത്. ");
INSERT INTO malc_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ഇപ്രകാരം യഹോവയ്ക്ക് ഹൃദ്യസുഗന്ധമായി ദഹനയാഗത്തിന്റെ ഭോജനം ഏഴുദിവസത്തേക്ക് ദിനംപ്രതി ഒരുക്കണം. നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ പാനീയയാഗത്തിനുംപുറമേയാണ് ഇത് ഒരുക്കപ്പെടേണ്ടത്. ");
INSERT INTO malc_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ഏഴാംദിവസം വിശുദ്ധസഭായോഗം കൂടണം, അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘ആദ്യഫലം ശേഖരിക്കുന്ന ദിവസം, പുതിയ ധാന്യത്തിന്റെ ഒരു ഭോജനയാഗം ആഴ്ചകളുടെ പെരുന്നാളിൽ നിങ്ങൾ യഹോവയ്ക്ക് അർപ്പിക്കുമ്പോൾ വിശുദ്ധസഭായോഗം കൂടണം; അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായി രണ്ടു കാളക്കിടാവും ഒരു ആട്ടുകൊറ്റനും ഒരുവയസ്സു പ്രായമുള്ള ഏഴ് ആണാട്ടിൻകുട്ടിയും ഹോമയാഗമായി അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ഓരോ കാളയോടുംകൂടെ ഒലിവെണ്ണചേർത്ത മൂന്ന് ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗവും ആട്ടുകൊറ്റനോടുകൂടെ രണ്ട് ഓമെറും ");
INSERT INTO malc_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ഏഴു കുഞ്ഞാടുകളിൽ ഓരോന്നിനോടുംകൂടെ ഒരു ഓമെറും വീതം ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","നിനക്കു പ്രായശ്ചിത്തം വരുത്താനായി ഒരു കോലാട്ടുകൊറ്റനെയും ഉൾപ്പെടുത്തുക. ");
INSERT INTO malc_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ ഭോജനയാഗത്തിനുംപുറമേ ഇവ അവയുടെ പാനീയയാഗങ്ങളോടുകൂടെ ഒരുക്കുക. മൃഗങ്ങൾ ഊനമില്ലാത്തവ ആയിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘ഏഴാംമാസം ഒന്നാംതീയതി വിശുദ്ധസഭായോഗം കൂടണം; അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. അതു നിങ്ങൾക്കു കാഹളങ്ങൾ മുഴക്കാനുള്ള ദിനം. ");
INSERT INTO malc_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായി ഊനമില്ലാത്ത ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഏഴ് ആൺകുഞ്ഞാട് എന്നിവ ഹോമയാഗം അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ഓരോ കാളയോടുംകൂടെ ഒലിവെണ്ണചേർത്ത മൂന്ന് ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗവും ആട്ടുകൊറ്റനോടുകൂടെ രണ്ട് ഓമെർ, ");
INSERT INTO malc_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ഏഴ് കുഞ്ഞാടുകളിൽ ഓരോന്നിനോടുംകൂടെ ഒരു ഓമെർ, ഇപ്രകാരം ഒലിവെണ്ണചേർത്ത നേരിയമാവിന്റെ ഭോജനയാഗം ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","നിനക്കു പ്രായശ്ചിത്തം വരുത്താൻ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും ഉൾപ്പെടുത്തുക. ");
INSERT INTO malc_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ദിവസേനയും മാസംതോറുമുള്ള നിർദിഷ്ട ഹോമയാഗങ്ങൾക്കും അവയോടുകൂടെയുള്ള ഭോജനയാഗങ്ങൾ, പാനീയയാഗങ്ങൾ എന്നിവയ്ക്കുംപുറമേയാണ് ഇവ. അവ യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗം. ");
INSERT INTO malc_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘ഈ ഏഴാംമാസം പത്താംതീയതി വിശുദ്ധസഭായോഗം കൂടണം. അന്നു നിങ്ങൾ ആത്മതപനം ചെയ്യുകയും വേലയൊന്നും ചെയ്യാതിരിക്കുകയും വേണം. ");
INSERT INTO malc_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","യഹോവയ്ക്ക് ഹൃദ്യസുഗന്ധമായി ഊനമില്ലാത്ത ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമായ ഏഴ് ആൺകുഞ്ഞാട് എന്നിവ ഹോമയാഗം അർപ്പിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ഓരോ കാളയോടുംകൂടെ ഒലിവെണ്ണചേർത്ത മൂന്ന് ഓമെർ നേരിയമാവിന്റെ ഒരു ഭോജനയാഗവും ഉണ്ടായിരിക്കണം. അത് ആട്ടുകൊറ്റനോടുകൂടെ രണ്ട് ഓമെറും ");
INSERT INTO malc_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ഏഴു കുഞ്ഞാടുകളിൽ ഓരോന്നിനോടുംകൂടെ ഒരു ഓമെറും വീതം ഉണ്ടായിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","പ്രായശ്ചിത്തത്തിനുള്ള പാപശുദ്ധീകരണയാഗത്തിനും പതിവു ഹോമയാഗത്തിനും അതോടുകൂടിയുള്ള ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനുംപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും ഉൾപ്പെടുത്തണം. ");
INSERT INTO malc_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘ഏഴാംമാസത്തിന്റെ പതിനഞ്ചാംതീയതി വിശുദ്ധസഭായോഗം നടത്തണം; അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. ഏഴുദിവസം യഹോവയ്ക്ക് ഉത്സവം ആചരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","യഹോവയ്ക്ക് ഹൃദ്യസുഗന്ധമായ ദഹനയാഗമായി ഊനമില്ലാത്ത പതിമ്മൂന്നു കാളക്കിടാവ്, രണ്ട് ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള പതിന്നാല് ആൺകുഞ്ഞാട് എന്നിവ ഹോമയാഗം അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","പതിമ്മൂന്ന് കാളക്കിടാങ്ങളിൽ ഓരോന്നിനോടുംകൂടി ഒലിവെണ്ണചേർത്ത മൂന്ന് ഓമെർ നേരിയമാവിന്റെ ഭോജനയാഗവും അത് ഓരോ ആട്ടുകൊറ്റനോടുംകൂടി രണ്ട് ഓമെറും ");
INSERT INTO malc_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ഓരോ ആട്ടിൻകുട്ടിയോടുംകൂടി ഒരു ഓമെറും വീതം അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനുംപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘രണ്ടാംദിവസം, ഊനമില്ലാത്ത പന്ത്രണ്ട് കാളക്കിടാവ്, രണ്ട് ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള പതിന്നാല് ആൺകുഞ്ഞാട് എന്നിവ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","കാളകൾ, ആട്ടുകൊറ്റന്മാർ, കുഞ്ഞാടുകൾ എന്നിവയോടൊപ്പം നിർദിഷ്ടമായ എണ്ണത്തിനനുസരിച്ച് അവയുടെ ഭോജനയാഗങ്ങളും പാനീയയാഗങ്ങളും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനുംപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും ഉൾപ്പെടുത്തണം. ");
INSERT INTO malc_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘മൂന്നാംദിവസം ഊനമില്ലാത്ത പതിനൊന്നു കാളക്കിടാവ്, രണ്ട് ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള പതിന്നാല് ആൺകുഞ്ഞാട് എന്നിവ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","കാളകൾ, ആട്ടുകൊറ്റന്മാർ, കുഞ്ഞാടുകൾ എന്നിവയോടൊപ്പം നിർദേശിക്കപ്പെട്ടിട്ടുള്ള എണ്ണത്തിനനുസരിച്ച് അവയുടെ ഭോജനയാഗങ്ങളും പാനീയയാഗങ്ങളും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനുംപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘നാലാംദിവസം ഊനമില്ലാത്ത പത്തു കാളക്കിടാവ്, രണ്ട് ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള പതിന്നാല് ആൺകുഞ്ഞാട് എന്നിവ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","കാളകൾ, ആട്ടുകൊറ്റന്മാർ, കുഞ്ഞാടുകൾ എന്നിവയോടൊപ്പം നിർദേശിക്കപ്പെട്ടിട്ടുള്ള എണ്ണത്തിനനുസരിച്ച് അവയുടെ ഭോജനയാഗങ്ങളും പാനീയയാഗങ്ങളും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനുംപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘അഞ്ചാംദിവസം ഊനമില്ലാത്ത ഒൻപതു കാളക്കിടാവ്, രണ്ട് ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള പതിന്നാല് ആൺകുഞ്ഞാട് ഇവ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","കാളകൾ, ആട്ടുകൊറ്റന്മാർ, കുഞ്ഞാടുകൾ എന്നിവയോടൊപ്പം നിർദേശിക്കപ്പെട്ടിട്ടുള്ള എണ്ണത്തിനനുസരിച്ച് അവയുടെ ഭോജനയാഗങ്ങളും പാനീയയാഗങ്ങളും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനുംപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും ഉൾപ്പെടുത്തണം. ");
INSERT INTO malc_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘ആറാംദിവസം ഊനമില്ലാത്ത എട്ടു കാളക്കിടാവ്, രണ്ട് ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള പതിന്നാല് ആൺകുഞ്ഞാട് എന്നിവ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","കാളകൾ, ആട്ടുകൊറ്റന്മാർ, കുഞ്ഞാടുകൾ എന്നിവയോടൊപ്പം നിർദേശിക്കപ്പെട്ടിട്ടുള്ള എണ്ണത്തിനനുസരിച്ച് അവയുടെ ഭോജനയാഗങ്ങളും പാനീയയാഗങ്ങളും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനുംപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘ഏഴാംദിവസം ഊനമില്ലാത്ത ഏഴു കാളക്കിടാവ്, രണ്ട് ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള പതിന്നാല് ആൺകുഞ്ഞാട് എന്നിവ അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","കാളകൾ, ആട്ടുകൊറ്റന്മാർ, കുഞ്ഞാടുകൾ എന്നിവയോടൊപ്പം നിർദേശിക്കപ്പെട്ടിട്ടുള്ള എണ്ണത്തിനനുസരിച്ച് അവയുടെ ഭോജനയാഗങ്ങളും പാനീയയാഗങ്ങളും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനുംപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘എട്ടാംദിവസം വിശുദ്ധസഭായോഗം കൂടണം; അന്നു സാധാരണ ജോലിയൊന്നും ചെയ്യരുത്. ");
INSERT INTO malc_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","യഹോവയ്ക്കു ഹൃദ്യസുഗന്ധമായ ദഹനയാഗമായി, ഊനമില്ലാത്ത ഒരു കാളക്കിടാവ്, ഒരു ആട്ടുകൊറ്റൻ, ഒരുവയസ്സു പ്രായമുള്ള ഏഴ് ആൺകുഞ്ഞാട് ഇവയുടെ ഒരു ഹോമയാഗം അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","കാള, ആട്ടുകൊറ്റൻ, കുഞ്ഞാടുകൾ എന്നിവയോടൊപ്പം നിർദേശിക്കപ്പെട്ടിട്ടുള്ള എണ്ണത്തിനനുസരിച്ച് അവയുടെ ഭോജനയാഗങ്ങളും പാനീയയാഗങ്ങളും അർപ്പിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","നിരന്തരം അർപ്പിക്കുന്ന ഹോമയാഗത്തിനും അതിന്റെ ഭോജനയാഗത്തിനും പാനീയയാഗത്തിനുംപുറമേ പാപശുദ്ധീകരണയാഗമായി ഒരു കോലാട്ടുകൊറ്റനെയും ഉൾപ്പെടുത്തണം. ");
INSERT INTO malc_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘നിങ്ങൾ നേരുന്നതിനും നിങ്ങളുടെ സ്വമേധാദാനങ്ങൾക്കുംപുറമേ നിങ്ങളുടെ നിർദിഷ്ടമായ പെരുന്നാളുകളിൽ യഹോവയ്ക്കായി ഹോമയാഗങ്ങൾ, ഭോജനയാഗങ്ങൾ, പാനീയയാഗങ്ങൾ, സമാധാനയാഗങ്ങൾ എന്നിവ അർപ്പിക്കുകയും വേണം.’ ” ");
INSERT INTO malc_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","യഹോവ മോശയോടു കൽപ്പിച്ചതെല്ലാം അദ്ദേഹം ഇസ്രായേൽമക്കളോടു പറഞ്ഞു. ");
INSERT INTO malc_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ഇസ്രായേൽഗോത്രങ്ങളുടെ തലവന്മാരോടു മോശ പറഞ്ഞു: “യഹോവ കൽപ്പിച്ചത് ഇതാണ്: ");
INSERT INTO malc_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ഒരു പുരുഷൻ യഹോവയ്ക്ക് ഒരു നേർച്ച നേരുകയോ വ്രതം അനുഷ്ഠിക്കാൻ ശപഥംചെയ്യുകയോ ചെയ്താൽ അയാൾ തന്റെ വാക്ക് മാറ്റാൻ പാടില്ല; ശപഥംചെയ്തവയെല്ലാം അയാൾ അനുഷ്ഠിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“തന്റെ പിതാവിന്റെ ഭവനത്തിൽത്തന്നെ താമസിക്കുന്ന ഒരു യുവതി യഹോവയ്ക്ക് ഒരു നേർച്ചനേരുകയും ഒരു വ്രതം നിശ്ചയിക്കുകയും ");
INSERT INTO malc_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","അവളുടെ പിതാവ് ആ നേർച്ചയെക്കുറിച്ചോ ശപഥത്തെക്കുറിച്ചോ കേൾക്കുകയും അവളോട് ഒന്നും പറയാതിരിക്കുകയും ചെയ്താൽ, അവളുടെ സകലനേർച്ചകളും, അവൾ നിശ്ചയിച്ച വ്രതമൊക്കെയും നിലനിൽക്കും. ");
INSERT INTO malc_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","എന്നാൽ അവളുടെ പിതാവ് അതേക്കുറിച്ചു കേൾക്കുമ്പോൾ അദ്ദേഹം അവളെ വിലക്കിയാൽ, അവളുടെ നേർച്ചകളിലും വ്രതത്തിലും ഒന്നും നിലനിൽക്കുകയില്ല; അവളുടെ പിതാവ് അവളെ വിലക്കിയതിനാൽ യഹോവ അവളോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ഒരു നേർച്ച നേരുകയോ വ്രതത്തിനു തിടുക്കപ്പെട്ട് അധരങ്ങളാൽ ഒരു ശപഥംചെയ്യുകയോ ചെയ്തശേഷം അവൾ വിവാഹംകഴിക്കുകയും ");
INSERT INTO malc_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","അവളുടെ ഭർത്താവ് അതേക്കുറിച്ചു കേട്ടിട്ട് അവളോടൊന്നും മിണ്ടാതിരിക്കുകയും ചെയ്താൽ അവളുടെ നേർച്ചകളും വ്രതങ്ങളും നിലനിൽക്കും. ");
INSERT INTO malc_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","എന്നാൽ അവളുടെ ഭർത്താവ് അതു കേൾക്കുമ്പോൾ അവളെ വിലക്കുന്നെങ്കിൽ അവളുടെ നേർച്ചയും വ്രതത്തിനു തിടുക്കപ്പെട്ടുചെയ്ത ശപഥവും അദ്ദേഹം ദുർബലപ്പെടുത്തുന്നു. യഹോവ അവളോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“ഒരു വിധവയോ വിവാഹമോചനം ചെയ്യപ്പെട്ടവളായ ഒരു സ്ത്രീയോ നേരുന്ന നേർച്ചയും വ്രതവും അവളുടെമേൽ നിലനിൽക്കും. ");
INSERT INTO malc_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ഭർത്താവിന്റെകൂടെ ജീവിക്കുന്ന ഒരു സ്ത്രീ ഒരു നേർച്ചനേരുകയും വ്രതത്തിനു ശപഥംചെയ്യുകയും ");
INSERT INTO malc_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","അവളുടെ ഭർത്താവ് അതേക്കുറിച്ചു കേട്ടിട്ടും, അവളോടൊന്നും പറയാതിരിക്കുകയും അവളെ വിലക്കാതിരിക്കുകയും ചെയ്താൽ അവളുടെ സകലനേർച്ചകളും വ്രതത്തിനു ചെയ്ത ശപഥവും നിലനിൽക്കും. ");
INSERT INTO malc_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","എന്നാൽ അവയെക്കുറിച്ചു കേൾക്കുമ്പോൾ അവളുടെ ഭർത്താവ് അവയെ ദുർബലപ്പെടുത്തിയാൽ അവളുടെ അധരങ്ങളിൽനിന്നു പുറപ്പെട്ട നേർച്ചകളിലോ ശപഥങ്ങളിലോ ഒന്നുപോലും നിലനിൽക്കുകയില്ല. അവളുടെ ഭർത്താവ് അവ വിലക്കിയതിനാൽ യഹോവ അവളോടു ക്ഷമിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ആത്മതപനം ചെയ്യാനുള്ള നേർച്ചയോ വ്രതമോ സ്ഥിരപ്പെടുത്തുകയോ അസ്ഥിരപ്പെടുത്തുകയോ ചെയ്യാൻ അവളുടെ ഭർത്താവിന് അധികാരമുണ്ട്. ");
INSERT INTO malc_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","എന്നാൽ അവളുടെ ഭർത്താവ് അതേപ്പറ്റി അവളോട് ദിവസങ്ങളോളം ഒന്നും മിണ്ടാതിരിക്കുന്നെങ്കിൽ, അവൾ കടപ്പെട്ടിരിക്കുന്ന അവളുടെ സകലനേർച്ചകളും ശപഥങ്ങളും അദ്ദേഹം സ്ഥിരപ്പെടുത്തുകയാണ്. അവയെക്കുറിച്ച് കേട്ടിട്ടും അവളോട് ഒന്നും മിണ്ടാതിരുന്നതിലൂടെ അദ്ദേഹം അവ സ്ഥിരപ്പെടുത്തിയിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","എന്നാൽ, അവയെക്കുറിച്ച് കേട്ട് കുറെക്കാലം കഴിഞ്ഞ് അദ്ദേഹം അത് ദുർബലപ്പെടുത്തിയാൽ ആ മനുഷ്യൻതന്നെയായിരിക്കും അവളുടെ തെറ്റിന് ഉത്തരവാദി.” ");
INSERT INTO malc_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ഒരു പുരുഷനും അയാളുടെ ഭാര്യയുംതമ്മിലും ഒരു പിതാവും തന്റെ വീട്ടിൽത്തന്നെ താമസിക്കുന്ന യുവതിയായ പുത്രിയുംതമ്മിലും ഉള്ള ബന്ധങ്ങൾ സംബന്ധിച്ച് യഹോവ മോശയ്ക്കു നൽകിയ നിബന്ധനകൾ ഇവയാണ്. ");
INSERT INTO malc_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","യഹോവ മോശയോട്, ");
INSERT INTO malc_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ഇസ്രായേല്യർക്കുവേണ്ടി മിദ്യാന്യരോടു പ്രതികാരം നടത്തുക. അതിനുശേഷം നീ നിന്റെ ജനത്തോടു ചേർക്കപ്പെടും” എന്ന് അരുളിച്ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","അങ്ങനെ മോശ ജനത്തോടു പറഞ്ഞു: “മിദ്യാന്യർക്കെതിരായി യുദ്ധംചെയ്യേണ്ടതിനും യഹോവയ്ക്ക് അവരുടെമേലുള്ള പ്രതികാരം നടത്തേണ്ടതിനുമായി നിങ്ങളുടെ പുരുഷന്മാരിൽ ചിലരെ സജ്ജരാക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ഇസ്രായേല്യരുടെ ഓരോ ഗോത്രത്തിൽനിന്നും ആയിരം പുരുഷന്മാരെവീതം യുദ്ധത്തിനയയ്ക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","അങ്ങനെ ഇസ്രായേലിന്റെ കുലങ്ങളിൽനിന്ന് ആയിരംപേർവീതം തെരഞ്ഞെടുക്കപ്പെട്ടു; അങ്ങനെ പന്തീരായിരം പുരുഷന്മാർ യുദ്ധസന്നദ്ധരായി. ");
INSERT INTO malc_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ഓരോ ഗോത്രത്തിൽനിന്നും ആയിരംപേർ വീതമായിവന്ന അവരെ മോശ പുരോഹിതനായ എലെയാസാരിന്റെ പുത്രൻ ഫീനെഹാസിനൊപ്പം യുദ്ധത്തിനയച്ചു. വിശുദ്ധമന്ദിരത്തിൽനിന്നുള്ള ഉപകരണങ്ങളും മുന്നറിയിപ്പു നൽകുന്നതിനുള്ള കാഹളങ്ങളും അദ്ദേഹം തന്നോടൊപ്പം എടുത്തിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ അവർ മിദ്യാന്യരുമായി യുദ്ധംചെയ്ത് പുരുഷന്മാരെയൊക്കെയും വധിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ആ വധിക്കപ്പെട്ടവരെക്കൂടാതെ ഏവി, രേക്കെം, സൂർ, ഹൂർ, രേബ എന്നീ മിദ്യാനിലെ അഞ്ചു രാജാക്കന്മാരെയും വധിച്ചു. ബെയോരിന്റെ മകനായ ബിലെയാമിനെയും അവർ വാൾകൊണ്ടു കൊന്നു. ");
INSERT INTO malc_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ഇസ്രായേല്യർ മിദ്യാന്യസ്ത്രീകളെയും കുഞ്ഞുങ്ങളെയും തടവുകാരാക്കി; അവരുടെ ആടുമാടുകളെ മുഴുവൻ എടുക്കുകയും അവരുടെ സമ്പത്ത് എല്ലാം കൊള്ളയിടുകയും ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","മിദ്യാന്യർ താമസിച്ചിരുന്ന സകലപട്ടണങ്ങളും അവരുടെ പാളയങ്ങളും അവർ തീയിട്ടു ചുട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ജനങ്ങളും മൃഗങ്ങളും ഉൾപ്പെടെ സകലകൊള്ളവസ്തുക്കളും കവർച്ചയും അവർ എടുത്തു; ");
INSERT INTO malc_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","യുദ്ധത്തടവുകാർ, കൊള്ളവസ്തുക്കൾ, കവർച്ച എന്നിവ മോശയുടെയും പുരോഹിതനായ എലെയാസാരിന്റെയും ഇസ്രായേല്യസഭയുടെയും അടുക്കൽ, അവർ പാളയമടിച്ചിരുന്ന യെരീഹോവിനെതിരേ യോർദാൻനദിക്കരികെയുള്ള മോവാബ് സമതലത്തിൽ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","മോശയും പുരോഹിതനായ എലെയാസാരും സഭാനേതാക്കന്മാരെല്ലാവരും പാളയത്തിനുപുറത്ത് അവരെ എതിരേൽക്കാൻ പോയി. ");
INSERT INTO malc_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","എന്നാൽ യുദ്ധംചെയ്തു മടങ്ങിവന്ന സഹസ്രാധിപന്മാരും ശതാധിപന്മാരുമായ സൈന്യാധിപന്മാരോട് മോശ കോപിച്ചു: ");
INSERT INTO malc_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","“സകലസ്ത്രീകളെയും നിങ്ങൾ ജീവനോടെ വെച്ചുവോ?” മോശ അവരോടു ചോദിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","“യഹോവയുടെ ജനത്തിന്മേൽ ഒരു ബാധ വരാൻ തക്കവണ്ണം പെയോരിലെ സംഭവത്തിൽ ബിലെയാമിന്റെ ഉപദേശം അനുസരിച്ചതിനാൽ, ഇസ്രായേല്യർ യഹോവയോട് അവിശ്വസ്തരായിത്തീരാൻ കാരണക്കാരായവർ അവരാണ്. ");
INSERT INTO malc_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ഇപ്പോൾ സകല ആൺകുട്ടികളെയും പുരുഷനോടുകൂടെ ലൈംഗികബന്ധത്തിലേർപ്പെട്ടിട്ടുള്ള സകലസ്ത്രീകളെയും വധിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","എന്നാൽ പുരുഷനോടുകൂടെ ഒരിക്കലും കിടക്കപങ്കിട്ടിട്ടില്ലാത്ത സകലപെൺകുട്ടികളെയും നിങ്ങൾക്കായി രക്ഷിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“ആരെയെങ്കിലും കൊന്നിട്ടുള്ളവരോ കൊല്ലപ്പെട്ട ആരെയെങ്കിലും സ്പർശിച്ചവരോ ആയ നിങ്ങൾ എല്ലാവരും ഏഴുദിവസത്തേക്കു പാളയത്തിനു വെളിയിൽ പാർക്കണം. മൂന്നും ഏഴും ദിവസങ്ങളിൽ നിങ്ങൾ നിങ്ങളെത്തന്നെയും നിങ്ങളുടെ ബന്ദികളെയും ശുദ്ധീകരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","അപ്രകാരംതന്നെ സകലവസ്ത്രങ്ങളും തുകൽ, ആട്ടുരോമം, മരം എന്നിവകൊണ്ടു നിർമിച്ച സകലതും ശുദ്ധീകരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ഇതിനുശേഷം പുരോഹിതനായ എലെയാസാർ യുദ്ധത്തിനുപോയ പടയാളികളോടു പറഞ്ഞു, “യഹോവ മോശയ്ക്കു നൽകിയ ന്യായപ്രമാണത്തിലെ ചട്ടം ഇതാണ്: ");
INSERT INTO malc_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","സ്വർണം, വെള്ളി, വെങ്കലം, ഇരുമ്പ്, വെളുത്തീയം, കറുത്തീയം മുതലായ ");
INSERT INTO malc_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","തീയാൽ നശിക്കാത്ത മറ്റെന്തും തീയിലിട്ട് എടുക്കണം. അപ്പോൾ അവ ശുദ്ധമാകും. എന്നാൽ അവ ശുദ്ധീകരണജലത്താലും ശുദ്ധമാക്കപ്പെടണം. അഗ്നിയെ അതിജീവിക്കാൻ കഴിയാത്ത വസ്തു ഒക്കെയും ആ ജലത്തിലിട്ട് എടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ഏഴാംദിവസം നിങ്ങളുടെ വസ്ത്രം കഴുകണം; അപ്പോൾ നിങ്ങൾ ശുദ്ധരാകും. പിന്നെ നിങ്ങൾക്കു പാളയത്തിലേക്ക് വരാം.” ");
INSERT INTO malc_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","യഹോവ മോശയോടു കൽപ്പിച്ചു: ");
INSERT INTO malc_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“നീയും പുരോഹിതനായ എലെയാസാരും സഭയിലെ പിതൃഭവനത്തലവന്മാരുംകൂടി യുദ്ധത്തിൽ പിടിച്ചെടുത്ത സകലമനുഷ്യരെയും മൃഗങ്ങളെയും എണ്ണണം. ");
INSERT INTO malc_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","യുദ്ധത്തിൽ പങ്കെടുത്ത പടയാളികൾക്കും സമൂഹത്തിലെ മറ്റുള്ളവർക്കുമായി കൊള്ളമുതൽ തുല്യ രണ്ടോഹരിയായി പങ്കിടണം. ");
INSERT INTO malc_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","യുദ്ധത്തിൽ പങ്കെടുത്ത പടയാളികളുടേതിൽനിന്ന് യുദ്ധത്തടവുകാരോ കന്നുകാലികളോ കഴുതകളോ ചെമ്മരിയാടോ കോലാടോ ഏതുമാകട്ടെ, അഞ്ഞൂറിലൊന്നുവീതം യഹോവയ്ക്കായി വേർതിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","അതു പടയാളികളുടെ ഓഹരിയിൽനിന്ന് പകുതി യഹോവയ്ക്കു വിശിഷ്ടയാഗാർപ്പണമായി പുരോഹിതനായ എലെയാസാരിനു കൊടുക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ഇസ്രായേല്യരുടെ ഓഹരിയിൽനിന്നു പകുതി യുദ്ധത്തടവുകാരോ കന്നുകാലികളോ കഴുതകളോ ചെമ്മരിയാടോ കോലാടോ മറ്റ് ഏതുമൃഗമോ ആകട്ടെ അൻപതിന് ഒന്നുവീതം തെരഞ്ഞെടുക്കുക. അവയെ യഹോവയുടെ സമാഗമകൂടാരത്തിൽ ശുശ്രൂഷിക്കുന്ന ലേവ്യർക്കു കൊടുക്കുക.” ");
INSERT INTO malc_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","അങ്ങനെ മോശയും പുരോഹിതനായ എലെയാസാരും യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ ചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","പടയാളികൾ എടുത്ത കവർച്ചയ്ക്കുപുറമേ ഉണ്ടായിരുന്ന കൊള്ളമുതൽ 6,75,000 ചെമ്മരിയാട്, ");
INSERT INTO malc_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 കന്നുകാലി, ");
INSERT INTO malc_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 കഴുത, ");
INSERT INTO malc_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","പുരുഷനുമായി ഒരിക്കലും കിടക്കപങ്കിട്ടിട്ടില്ലാത്തവരായ 32,000 സ്ത്രീകൾ ഇവയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","യുദ്ധത്തിൽ പങ്കെടുത്തവർക്കുള്ള ഓഹരി—കൊള്ളമുതലിന്റെ പകുതി—ഇവയായിരുന്നു: 3,37,500 ചെമ്മരിയാട്, ");
INSERT INTO malc_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","അതിൽ യഹോവയ്ക്കുള്ള വിഹിതം 675 ആയിരുന്നു; ");
INSERT INTO malc_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000 കന്നുകാലി, അതിൽ യഹോവയ്ക്കുള്ള വിഹിതം 72 ആയിരുന്നു; ");
INSERT INTO malc_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500 കഴുത, അതിൽ യഹോവയ്ക്കുള്ള വിഹിതം 61 ആയിരുന്നു; ");
INSERT INTO malc_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 ജനങ്ങൾ, അതിൽ യഹോവയ്ക്കുള്ള വിഹിതം 32 ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","യഹോവ മോശയോടു കൽപ്പിച്ചതുപോലെ മോശ ആ വിഹിതം യഹോവയുടെ ഭാഗമായി പുരോഹിതനായ എലെയാസാരിനു കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","പോരാളികൾക്കുള്ളതിൽനിന്ന് മോശ വേർതിരിച്ച, പകുതി കൊള്ളമുതലിൽ, ഇസ്രായേല്യരുടെ ഓഹരി ");
INSERT INTO malc_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","3,37,500 ചെമ്മരിയാട്, ");
INSERT INTO malc_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 കന്നുകാലി, ");
INSERT INTO malc_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 കഴുത, ");
INSERT INTO malc_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","16,000 ജനങ്ങൾ എന്നിവയായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","യഹോവ തന്നോടു കൽപ്പിച്ചതുപോലെ മോശ ഇസ്രായേല്യരുടെ ഓഹരിയിൽനിന്നു പകുതി യുദ്ധത്തടവുകാർ, മൃഗങ്ങൾ എന്നിവയിൽ അൻപതിന് ഒന്നുവീതം സമാഗമകൂടാരത്തിൽ ശുശ്രൂഷിച്ചിരുന്ന ലേവ്യർക്കു കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ഇതിനുശേഷം സൈന്യവിഭാഗങ്ങളുടെമേൽ നിയമിക്കപ്പെട്ടിരുന്ന സഹസ്രാധിപന്മാരും ശതാധിപന്മാരുമായ സൈന്യാധിപന്മാർ മോശയുടെ അടുക്കൽ ചെന്ന് ");
INSERT INTO malc_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","അദ്ദേഹത്തോടു പറഞ്ഞു: “അങ്ങയുടെ ആജ്ഞാനുസരണം അങ്ങയുടെ ദാസന്മാർ പടയാളികളെ എണ്ണി. ഒരുവൻപോലും നഷ്ടപ്പെട്ടിട്ടില്ല. ");
INSERT INTO malc_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","അതുകൊണ്ട് ഞങ്ങൾക്കുവേണ്ടി യഹോവയുടെമുമ്പാകെ പ്രായശ്ചിത്തം ചെയ്യാൻ ഞങ്ങൾക്ക് ഓരോരുത്തർക്കും ലഭിച്ച സ്വർണ ഉരുപ്പടികളായ തോൾവള, കൈവള, മോതിരം, കുണുക്ക്, മാല എന്നിവ യഹോവയ്ക്ക് ഒരു കാഴ്ചയായിക്കൊണ്ടുവന്നിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","മോശയും പുരോഹിതനായ എലെയാസാരും അവരിൽനിന്ന് കൈപ്പണിയായി നിർമിച്ച ആ സ്വർണ ഉരുപ്പടികൾ സ്വീകരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","സഹസ്രാധിപന്മാരിലും ശതാധിപന്മാരിലുംനിന്ന് അവർ യഹോവയ്ക്കു കാഴ്ചയായി അർപ്പിച്ച സ്വർണം ആകെ 16,750 ശേക്കേൽ ആയിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ഓരോ പടയാളിയും തനിക്കുവേണ്ടി കൊള്ളമുതൽ എടുത്തിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","മോശയും പുരോഹിതനായ എലെയാസാരും സഹസ്രാധിപന്മാരിൽനിന്നും ശതാധിപന്മാരിൽനിന്നും സ്വർണം സ്വീകരിച്ച് യഹോവയുടെമുമ്പാകെ ഇസ്രായേല്യർക്ക് ഒരു സ്മാരകമായി സമാഗമകൂടാരത്തിൽ കൊണ്ടുവന്നു. ");
INSERT INTO malc_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","വളരെയധികം കന്നുകാലികളും ആട്ടിൻപറ്റങ്ങളും ഉണ്ടായിരുന്ന രൂബേന്യരും ഗാദ്യരും യാസേർ, ഗിലെയാദ് എന്നീ ദേശങ്ങൾ വളർത്തുമൃഗങ്ങൾക്ക് അനുയോജ്യമെന്നു കണ്ടു. ");
INSERT INTO malc_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","അതിനാൽ രൂബേന്യരും ഗാദ്യരും മോശയുടെയും പുരോഹിതനായ എലെയാസാരിന്റെയും സഭാനേതാക്കന്മാരുടെയും അടുക്കൽവന്ന് പറഞ്ഞു: ");
INSERT INTO malc_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“അതാരോത്ത്, ദീബോൻ, യാസേർ, നിമ്രാ, ഹെശ്ബോൻ, എലെയാലേ, സേബാം, നെബോ, ബെയോൻ എന്നിങ്ങനെ ");
INSERT INTO malc_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ഇസ്രായേൽജനത്തിന്റെ മുമ്പിൽ യഹോവ കീഴടക്കിയ ദേശം വളർത്തുമൃഗങ്ങൾക്ക് അനുയോജ്യമാണ്; അങ്ങയുടെ ദാസന്മാർക്കു വളർത്തുമൃഗങ്ങൾ ഉണ്ടല്ലോ. ");
INSERT INTO malc_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","അവിടന്ന് ഞങ്ങളിൽ പ്രസാദിച്ചിരിക്കുന്നെങ്കിൽ, ഈ ദേശം ഞങ്ങളുടെ അവകാശമായി അങ്ങയുടെ ദാസന്മാർക്കു നൽകണമേ. യോർദാൻ മറികടക്കാൻ ഞങ്ങൾക്കിടയാക്കരുതേ.” ");
INSERT INTO malc_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","മോശ ഗാദ്യരോടും രൂബേന്യരോടും പറഞ്ഞു: “നിങ്ങൾ ഇവിടെ ആയിരിക്കുമ്പോൾ നിങ്ങളുടെ സഹോദരന്മാർ യുദ്ധത്തിനു പോകുമോ? ");
INSERT INTO malc_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ഇസ്രായേല്യരെ യഹോവ അവർക്കു നൽകിയ ദേശത്തേക്കു പോകുന്നതിൽനിന്ന് നിങ്ങൾ നിരുത്സാഹപ്പെടുത്തുന്നതെന്ത്? ");
INSERT INTO malc_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ഇതുതന്നെയാണ്, ഞാൻ കാദേശ്-ബർന്നേയയിൽനിന്ന് ദേശം നോക്കാൻ വിട്ടപ്പോൾ, നിങ്ങളുടെ പിതാക്കന്മാരും ചെയ്തത്. ");
INSERT INTO malc_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","എസ്കോൽ താഴ്വരയിലേക്ക് അവർ കയറിപ്പോയി ദേശം നിരീക്ഷിച്ചശേഷം, യഹോവ ഇസ്രായേല്യർക്കു നൽകിയ ദേശത്ത് കടക്കുന്നതിൽനിന്ന് അവരെ അവർ നിരുത്സാഹപ്പെടുത്തി. ");
INSERT INTO malc_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","അന്നാളിൽ യഹോവയുടെ കോപം ജ്വലിച്ചു. അവിടന്ന് ഇപ്രകാരം ശപഥംചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","12","‘കെനിസ്യനായ യെഫുന്നയുടെ മകൻ കാലേബും നൂന്റെ മകനായ യോശുവയും പൂർണഹൃദയത്തോടെ യഹോവയെ പിൻപറ്റിയിരിക്കുകയാൽ, അവരല്ലാതെ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെട്ടു വന്നവരിൽ ഇരുപതു വയസ്സോ അതിലധികമോ പ്രായമുള്ള പുരുഷന്മാരിൽ ഒരുത്തൻപോലും, അബ്രാഹാമിനോടും യിസ്ഹാക്കിനോടും യാക്കോബിനോടും ഞാൻ ശപഥംചെയ്ത വാഗ്ദത്തദേശം കാണുകയില്ല. കാരണം ഇവരാരും എന്നെ പൂർണഹൃദയത്തോടെ പിൻപറ്റിയില്ല.’ ");
INSERT INTO malc_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","യഹോവയുടെ കോപം ഇസ്രായേലിനെതിരേ ജ്വലിച്ചു. അവിടത്തെ ദൃഷ്ടിയിൽ തിന്മ പ്രവർത്തിച്ചവരുടെ തലമുറ മുഴുവനും നശിക്കുംവരെ അവിടന്ന് അവരെ നാൽപ്പതുവർഷം മരുഭൂമിയിൽ അലഞ്ഞുനടക്കുമാറാക്കി. ");
INSERT INTO malc_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“ഇപ്പോൾ ഇവിടെയിതാ നിങ്ങൾ, പാപികളുടെ ഒരു കുലം, നിങ്ങളുടെ പിതാക്കന്മാരുടെ ചുവടുകളിൽത്തന്നെ നിന്നുകൊണ്ട് യഹോവ ഇസ്രായേലിനോട് വീണ്ടും അധികം കോപാകുലനാക്കാൻ ഇടയാക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","അവിടത്തെ പിൻപറ്റുന്നതിൽനിന്നും നിങ്ങൾ മാറിപ്പോയാൽ, അവിടന്ന് ഈ ജനത്തെ മുഴുവൻ മരുഭൂമിയിൽ വീണ്ടും കൈവിടും; അവരുടെ നാശത്തിന് കാരണക്കാർ നിങ്ങളായിരിക്കുകയും ചെയ്യും.” ");
INSERT INTO malc_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","പിന്നെ അവർ അദ്ദേഹത്തിന്റെ അടുക്കൽവന്ന് പറഞ്ഞു: “ഞങ്ങളുടെ കന്നുകാലികൾക്കു തൊഴുത്തുകളും സ്ത്രീകൾക്കും കുട്ടികൾക്കുമായി പട്ടണങ്ങളും ഞങ്ങൾ ഇവിടെ നിർമിക്കാൻ ആഗ്രഹിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","എന്നാൽ ഞങ്ങളുടെ സഹോദരങ്ങളായ ഇസ്രായേല്യരെ അവരുടെ സ്ഥാനത്ത് എത്തിക്കുംവരെ ആയുധധാരികളായി അവർക്കുമുമ്പായി അണിനിരക്കാനും ഞങ്ങൾ തയ്യാറാണ്. അതേസമയം ഞങ്ങളുടെ സ്ത്രീകളും കുഞ്ഞുങ്ങളും തദ്ദേശവാസികളിൽനിന്ന് സംരക്ഷിക്കപ്പെടാൻ കെട്ടുറപ്പുള്ള പട്ടണങ്ങളിൽ പാർക്കും. ");
INSERT INTO malc_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","സകല ഇസ്രായേല്യർക്കും അവരുടെ ഓഹരി ലഭിക്കുന്നതുവരെ ഞങ്ങൾ സ്വന്തം ഭവനങ്ങളിലേക്കു മടങ്ങുകയില്ല. ");
INSERT INTO malc_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ഞങ്ങളുടെ ഓഹരി യോർദാന്റെ കിഴക്കുഭാഗത്ത് ഞങ്ങൾക്കു ലഭിച്ചിരിക്കുകയാൽ അവരോടൊപ്പം യോർദാന്റെ മറുകരയിൽ ഞങ്ങൾ ഓഹരി വാങ്ങുകയില്ല.” ");
INSERT INTO malc_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","അപ്പോൾ മോശ അവരോടു പറഞ്ഞു: “ഈ വാക്കു നിങ്ങൾ പാലിക്കുമെങ്കിൽ യഹോവയുടെമുമ്പാകെ നിങ്ങൾ നിങ്ങളെത്തന്നെ യുദ്ധസന്നദ്ധരാക്കുകയും ");
INSERT INTO malc_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","തിരുമുമ്പിൽനിന്ന് അവിടത്തെ ശത്രുക്കളെ തുരത്തുന്നതുവരെ നിങ്ങൾ എല്ലാവരും യഹോവയുടെമുമ്പാകെ ആയുധധാരികളായി യോർദാൻ കടക്കുകയും ചെയ്യണം. ");
INSERT INTO malc_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","അങ്ങനെ ദേശം യഹോവയ്ക്ക് അധീനപ്പെടുമ്പോൾ, യഹോവയോടും ഇസ്രായേലിനോടുമുള്ള നിങ്ങളുടെ കടപ്പാടൊഴിഞ്ഞ് നിങ്ങൾക്കു മടങ്ങിപ്പോകാം. അങ്ങനെ ഈ ദേശം യഹോവയുടെമുമ്പാകെ നിങ്ങളുടെ അവകാശമായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“എന്നാൽ ഇതു ചെയ്യുന്നതിൽ നിങ്ങൾ വീഴ്ചവരുത്തിയാൽ, യഹോവയ്ക്കെതിരായി നിങ്ങൾ പാപം ചെയ്യുകയായിരിക്കും; നിങ്ങളുടെ പാപത്തിനുള്ള ശിക്ഷ നിങ്ങൾതന്നെ അനുഭവിക്കുമെന്നു നിങ്ങൾ ഉറപ്പായും അറിഞ്ഞിരിക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","നിങ്ങളുടെ സ്ത്രീകൾക്കും കുഞ്ഞുങ്ങൾക്കുമായി പട്ടണങ്ങളും കന്നുകാലികൾക്കായി തൊഴുത്തുകളും പണിയുക. എന്നാൽ നിങ്ങൾ ചെയ്ത വാഗ്ദാനവും നിറവേറ്റുക.” ");
INSERT INTO malc_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ഗാദ്യരും രൂബേന്യരും മോശയോടു പറഞ്ഞു: “യജമാനൻ കൽപ്പിച്ചതുപോലെതന്നെ അങ്ങയുടെ ദാസരായ ഞങ്ങൾ ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ഞങ്ങളുടെ കുഞ്ഞുങ്ങളും ഭാര്യമാരും ആടുമാടുകളും ഇവിടെ ഗിലെയാദിലെ പട്ടണങ്ങളിൽത്തന്നെ പാർക്കും. ");
INSERT INTO malc_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","എന്നാൽ അങ്ങയുടെ ദാസന്മാർ, യുദ്ധസന്നദ്ധരായ സകലരും, ഞങ്ങളുടെ യജമാനൻ പറയുന്നതുപോലെതന്നെ യഹോവയുടെമുമ്പാകെ യുദ്ധംചെയ്യാൻ അക്കരെ കടക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","പിന്നെ മോശ അവരെക്കുറിച്ച് പുരോഹിതനായ എലെയാസാരിനും നൂന്റെ മകനായ യോശുവയ്ക്കും ഇസ്രായേല്യഗോത്രങ്ങളുടെ പിതൃഭവനത്തലവന്മാർക്കും കൽപ്പനകൾ കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","അദ്ദേഹം അവരോടു പറഞ്ഞു: “ഗാദ്യരിലും രൂബേന്യരിലും യുദ്ധസന്നദ്ധരായ സകലപുരുഷന്മാരും യഹോവയുടെമുമ്പാകെ നിങ്ങളോടൊപ്പം യോർദാൻ കടക്കുന്നെങ്കിൽ, ദേശം നിങ്ങളുടെമുമ്പാകെ അധീനമാകുമ്പോൾ ഗിലെയാദുദേശം അവർക്ക് അവകാശമായി കൊടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","എന്നാൽ നിങ്ങളുടെകൂടെ ആയുധധാരികളായി അവർ അക്കരെ കടക്കുന്നില്ലെങ്കിൽ, അവരുടെ ഓഹരി കനാനിലുള്ള നിങ്ങളോടൊപ്പം ആയിരിക്കണം.” ");
INSERT INTO malc_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ഗാദ്യരും രൂബേന്യരും മറുപടി പറഞ്ഞു: “യഹോവ അരുളിച്ചെയ്തതുപോലെ അങ്ങയുടെ ദാസന്മാർ ചെയ്യും. ");
INSERT INTO malc_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","യഹോവയുടെമുമ്പിൽ ആയുധധാരികളായി ഞങ്ങൾ കനാനിൽ കടക്കും. എന്നാൽ ഞങ്ങളുടെ അവകാശദേശം യോർദാന്റെ ഇക്കരെയായിരിക്കും.” ");
INSERT INTO malc_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","പിന്നെ മോശ ഗാദ്യർക്കും രൂബേന്യർക്കും യോസേഫിന്റെ പുത്രനായ മനശ്ശെയുടെ പകുതിഗോത്രത്തിനും അമോര്യരാജാവായ സീഹോന്റെ രാജ്യവും ബാശാൻരാജാവായ ഓഗിന്റെ രാജ്യവും അവയുടെ പട്ടണങ്ങളോടും ചുറ്റുമുള്ള പ്രദേശങ്ങളോടുംകൂടി നൽകി. ");
INSERT INTO malc_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ഗാദ്യർ ദീബോൻ, അതാരോത്ത്, അരോയേർ, ");
INSERT INTO malc_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","അത്രോത്ത്-ശോഫാൻ, യാസേർ, യൊഗ്ബെഹാ, ");
INSERT INTO malc_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ബേത്-നിമ്രാ, ബേത്-ഹാരാൻ എന്നിവ കെട്ടുറപ്പുള്ള പട്ടണങ്ങളായി പണിതു; അവരുടെ കന്നുകാലികൾക്കു തൊഴുത്തുകളും അവിടെ പണിതു. ");
INSERT INTO malc_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","രൂബേന്യർ ഹെശ്ബോൻ, എലെയാലേ, കിര്യാത്തയീം എന്നിവയും ");
INSERT INTO malc_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","നെബോ, ബാൽ-മെയോൻ (ഈ പേരുകൾ മാറ്റപ്പെട്ടു), സിബ്മാ എന്നിവയും പുതുക്കിപ്പണിതു. പുതുക്കിപ്പണിത പട്ടണങ്ങൾക്ക് അവർ പുതിയ പേരുകൾ കൊടുത്തു. ");
INSERT INTO malc_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","മനശ്ശെയുടെ പുത്രൻ മാഖീരിന്റെ സന്തതികൾ ഗിലെയാദിലേക്കു പോയി അതിനെ പിടിച്ചടക്കി അവിടെ ഉണ്ടായിരുന്ന അമോര്യരെ തുരത്തി. ");
INSERT INTO malc_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","അതുകൊണ്ട് മോശ മനശ്ശെയുടെ സന്തതികളായ മാഖീര്യർക്കു ഗിലെയാദ് കൊടുത്തു. അവർ അവിടെ താമസമുറപ്പിച്ചു, ");
INSERT INTO malc_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","മനശ്ശെയുടെ സന്തതികളിൽ ഒരുവനായ യായീർ അവരുടെ പട്ടണങ്ങൾ പിടിച്ചടക്കി. അവയ്ക്ക് യായീരിന്റെ ഊരുകൾ എന്നർഥമുള്ള ഹാവോത്ത്-യായീർ എന്നു പേരിട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","നോബഹ് ചെന്ന് കെനാത്തും അതിന്റെ ചുറ്റുമുള്ള പട്ടണങ്ങളും പിടിച്ചടക്കി; ആ ദേശത്തിനു തന്റെ പേരിൻപ്രകാരം നോബഹ് എന്നു പുനർനാമകരണംചെയ്തു. ");
INSERT INTO malc_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","മോശയുടെയും അഹരോന്റെയും നേതൃത്വത്തിൽ ഈജിപ്റ്റിൽനിന്നും ഗണംഗണമായി പുറപ്പെട്ട ഇസ്രായേൽമക്കളുടെ പ്രയാണത്തിലെ പാളയങ്ങൾ ഇവയാണ്: ");
INSERT INTO malc_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","യഹോവയുടെ കൽപ്പനപ്രകാരം അവരുടെ പ്രയാണത്തിലെ പാളയങ്ങൾ മോശ രേഖപ്പെടുത്തി. ഘട്ടംഘട്ടമായുള്ള അവരുടെ പ്രയാണം ഇതാണ്: ");
INSERT INTO malc_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","4","ഒന്നാംമാസം പതിനഞ്ചാംതീയതി—പെസഹായുടെ പിറ്റേന്നാൾ—ഇസ്രായേല്യർ രമെസേസിൽനിന്ന് യാത്രപുറപ്പെട്ടു. ഈജിപ്റ്റുകാരുടെ ദേവതകളുടെമേൽ യഹോവ ന്യായവിധി വരുത്തുകയാൽ അവിടന്ന് അവരുടെ ഇടയിൽ സംഹരിച്ച അവരുടെ സകല ആദ്യജാതന്മാരെയും സംസ്കരിച്ചുകൊണ്ടിരിക്കുകയായിരുന്ന അവരുടെയെല്ലാം കണ്മുമ്പിലൂടെ ഇസ്രായേല്യർ യുദ്ധസന്നദ്ധരായി പുറപ്പെട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ഇസ്രായേല്യർ രമെസേസിൽനിന്ന് പുറപ്പെട്ട് സൂക്കോത്തിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","അവർ സൂക്കോത്തിൽനിന്ന് പുറപ്പെട്ട് മരുഭൂമിക്കരികെയുള്ള ഏഥാമിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","അവർ ഏഥാമിൽനിന്ന് പുറപ്പെട്ട് ബാൽ-സെഫോനു കിഴക്കുഭാഗത്തുള്ള പീ-ഹഹീരോത്തിലേക്കു പിൻവാങ്ങി മിഗ്ദോലിനു സമീപം പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","അവർ പീ-ഹഹീരോത്തിൽനിന്ന് പുറപ്പെട്ട് കടലിലൂടെ മരുഭൂമിയിൽ കടന്നു. അവർ ഏഥാം മരുഭൂമിയിലൂടെ മൂന്നുദിവസം സഞ്ചരിച്ചു, തുടർന്ന് അവർ മാറായിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","അവർ മാറായിൽനിന്ന് പുറപ്പെട്ട് ഏലീമിലേക്കു പോയി. അവിടെ പന്ത്രണ്ടു നീരുറവകളും എഴുപത് ഈന്തപ്പനകളും ഉണ്ടായിരുന്നു. അവർ അവിടെ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","അവർ ഏലീമിൽനിന്ന് പുറപ്പെട്ട് ചെങ്കടലിനരികിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","അവർ ചെങ്കടലിൽനിന്ന് പുറപ്പെട്ട് സീൻമരുഭൂമിയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","അവർ സീൻമരുഭൂമിയിൽനിന്ന് പുറപ്പെട്ട് ദൊഫ്കയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","അവർ ദൊഫ്കയിൽനിന്ന് പുറപ്പെട്ട് ആലൂശിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","അവർ ആലൂശിൽനിന്ന് പുറപ്പെട്ട് രെഫീദീമിൽ പാളയമടിച്ചു. അവിടെ ജനത്തിനു കുടിക്കാൻ വെള്ളമില്ലായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","അവർ രെഫീദീമിൽനിന്ന് പുറപ്പെട്ട് സീനായിമരുഭൂമിയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","അവർ സീനായിമരുഭൂമിയിൽനിന്ന് പുറപ്പെട്ട് കിബ്രോത്ത്-ഹത്താവയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","അവർ കിബ്രോത്ത്-ഹത്താവയിൽനിന്ന് പുറപ്പെട്ട് ഹസേരോത്തിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","അവർ ഹസേരോത്തിൽനിന്ന് പുറപ്പെട്ട് രിത്മയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","അവർ രിത്മയിൽനിന്ന് പുറപ്പെട്ട് രിമ്മോൻ-ഫേരെസിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","അവർ രിമ്മോൻ-ഫേരെസിൽനിന്ന് പുറപ്പെട്ട് ലിബ്നായിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","അവർ ലിബ്നായിൽനിന്ന് പുറപ്പെട്ട് രിസ്സയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","അവർ രിസ്സയിൽനിന്ന് പുറപ്പെട്ട് കെഹേലാഥയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","അവർ കെഹേലാഥയിൽനിന്ന് പുറപ്പെട്ട് ശാഫേർ പർവതത്തിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","അവർ ശാഫേർ പർവതത്തിൽനിന്ന് പുറപ്പെട്ട് ഹരാദയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","അവർ ഹരാദയിൽനിന്ന് പുറപ്പെട്ട് മക്ഹേലോത്തിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","അവർ മക്ഹേലോത്തിൽനിന്ന് പുറപ്പെട്ട് തഹത്തിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","അവർ തഹത്തിൽനിന്ന് പുറപ്പെട്ട് താരഹിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","അവർ താരഹിൽനിന്ന് പുറപ്പെട്ട് മിത്ക്കയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","അവർ മിത്ക്കയിൽനിന്ന് പുറപ്പെട്ട് ഹശ്മോനയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","അവർ ഹശ്മോനയിൽനിന്ന് പുറപ്പെട്ട് മൊസേരോത്തിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","അവർ മൊസേരോത്തിൽനിന്ന് പുറപ്പെട്ട് ബെനേ-യാക്കാനിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","അവർ ബെനേ-യാക്കാനിൽനിന്ന് പുറപ്പെട്ട് ഹോർ-ഹഗ്ഗിദ്ഗാദിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","അവർ ഹോർ-ഹഗ്ഗിദ്ഗാദിൽനിന്ന് പുറപ്പെട്ട് യൊത്-ബാഥായിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","അവർ യൊത്-ബാഥായിൽനിന്ന് പുറപ്പെട്ട് അബ്രോനയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","അവർ അബ്രോനയിൽനിന്ന് പുറപ്പെട്ട് എസ്യോൻ-ഗേബെറിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","അവർ എസ്യോൻ-ഗേബെറിൽനിന്ന് പുറപ്പെട്ട് സീൻ മരുഭൂമിയിലെ കാദേശിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","അവർ കാദേശിൽനിന്ന് പുറപ്പെട്ട് ഏദോമിന്റെ അതിർത്തിയിലുള്ള ഹോർ പർവതത്തിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","യഹോവയുടെ കൽപ്പനപ്രകാരം പുരോഹിതനായ അഹരോൻ ഹോർ പർവതത്തിലേക്കു കയറിപ്പോയി. അവിടെ അദ്ദേഹം, ഇസ്രായേല്യർ ഈജിപ്റ്റിൽനിന്ന് പുറപ്പെട്ടശേഷം നാൽപ്പതാംവർഷത്തിന്റെ അഞ്ചാംമാസം ഒന്നാംതീയതി മരിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","അഹരോൻ ഹോർ പർവതത്തിൽവെച്ചു മരിക്കുമ്പോൾ അദ്ദേഹത്തിനു നൂറ്റിഇരുപത്തിമൂന്ന് വയസ്സുണ്ടായിരുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","കനാൻ ദേശത്തിനു തെക്കു താമസിച്ചിരുന്ന കനാന്യരാജാവായ അരാദ് ഇസ്രായേല്യർ വരുന്നു എന്നു കേട്ടു. ");
INSERT INTO malc_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ഇസ്രായേല്യർ ഹോർ പർവതത്തിൽനിന്ന് പുറപ്പെട്ട് സല്മോനയിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","അവർ സല്മോനയിൽനിന്ന് പുറപ്പെട്ട് പൂനോനിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","അവർ പൂനോനിൽനിന്ന് പുറപ്പെട്ട് ഓബോത്തിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","അവർ ഓബോത്തിൽനിന്ന് പുറപ്പെട്ട് മോവാബിന്റെ അതിർത്തിയിലുള്ള ഇയ്യെ-അബാരീമിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","അവർ ഇയ്യീമിൽനിന്ന് പുറപ്പെട്ട് ദീബോൻ-ഗാദിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","അവർ ദീബോൻ-ഗാദിൽനിന്ന് പുറപ്പെട്ട് അല്മോൻ-ദിബ്ലാഥയീമിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","അവർ അല്മോൻ-ദിബ്ലാഥയീമിൽനിന്ന് പുറപ്പെട്ട് നെബോവിനുസമീപം അബാരീം പർവതങ്ങളിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","അവർ അബാരീം പർവതങ്ങളിൽനിന്ന് പുറപ്പെട്ടു യെരീഹോവിനെതിരേ യോർദാൻതീരത്ത് മോവാബ് സമതലങ്ങളിൽ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","അവിടെ മോവാബ് സമതലത്തിൽ യോർദാന്റെ തീരത്ത് ബേത്-യെശീമോത്ത്മുതൽ ആബേൽ-ശിത്തീംവരെ അവർ പാളയമടിച്ചു. ");
INSERT INTO malc_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","യെരീഹോവിനെതിരേ യോർദാൻതീരത്ത് മോവാബുസമതലത്തിൽവെച്ച് യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“ഇസ്രായേല്യരോടു സംസാരിക്കണം. അവരോട് ഇപ്രകാരം പറയുക: ‘നിങ്ങൾ യോർദാൻ കടന്ന് കനാനിലേക്കു പോകുമ്പോൾ, ");
INSERT INTO malc_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","നിങ്ങളുടെമുമ്പിലുള്ള ദേശത്തിലെ സകലനിവാസികളെയും ഓടിച്ചുകളയണം. അവരുടെ വിഗ്രഹങ്ങളെയും പ്രതിമകളെയും നശിപ്പിച്ച് അവർ യാഗമർപ്പിച്ചുവരുന്ന ക്ഷേത്രങ്ങൾ മുഴുവൻ ഇടിച്ചുകളയണം. ");
INSERT INTO malc_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ദേശം കൈവശമാക്കി അതിൽ പാർക്കുക. കാരണം നിങ്ങൾക്കു കൈവശമാക്കാനായി ദേശം ഞാൻ തന്നിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","നിങ്ങൾ കുടുംബങ്ങളായി നറുക്കിട്ട് ആ ദേശം കൈവശമാക്കണം. വലിയ ഗോത്രത്തിനു വലിയ അവകാശവും ചെറിയഗോത്രത്തിനു ചെറിയ അവകാശവും നൽകണം. നറുക്കുവീഴുന്നതിലൂടെ ലഭിക്കുന്ന ദേശം ഏതുതന്നെയായാലും അത് അവർക്കുള്ളതായിരിക്കും. നിങ്ങളുടെ പിതൃഗോത്രമനുസരിച്ച് നിങ്ങൾ ദേശം അവകാശമാക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘എന്നാൽ ദേശത്തിലെ നിവാസികളെ നിങ്ങൾ ഓടിക്കുന്നില്ലെങ്കിൽ, ദേശത്തു തങ്ങാൻ നിങ്ങൾ അനുവദിക്കുന്നവർ നിങ്ങളുടെ കണ്ണുകൾക്കു ചൂണ്ടയും പാർശ്വങ്ങൾക്കു മുള്ളും ആയിരിക്കും. നിങ്ങൾ ജീവിക്കുന്ന ദേശത്ത് അവർ നിങ്ങളെ ഉപദ്രവിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","അതുമാത്രമല്ല, ഞാൻ അവരോടു ചെയ്യാൻ വിചാരിച്ചതു നിങ്ങളോടു ചെയ്യും.’ ” ");
INSERT INTO malc_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ഇസ്രായേല്യരോടു കൽപ്പിക്കണം. അവരോട് ഇപ്രകാരം പറയുക: നിങ്ങൾ കനാനിൽ പ്രവേശിക്കുമ്പോൾ, നിങ്ങൾ അവകാശമാക്കുന്ന ദേശത്തിന്റെ അതിരുകൾ ഇവയായിരിക്കും: ");
INSERT INTO malc_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘ഏദോമിന്റെ അതിരിനു നെടുകെ സീൻ മരുഭൂമിയുടെ കുറെ ഭാഗം നിങ്ങളുടെ തെക്കുഭാഗത്ത് ഉൾപ്പെടും. നിങ്ങളുടെ തെക്കേ അതിര് കിഴക്ക് ഉപ്പുകടലിന്റെ അതിരുമുതൽ, ");
INSERT INTO malc_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","അക്രബീംകയറ്റത്തിൽനിന്ന് തെക്കോട്ടു തിരിഞ്ഞ് സീനിലേക്കു തുടർന്ന് കാദേശ്-ബർന്നേയയുടെ തെക്കുഭാഗത്തേക്കു നീളും. പിന്നെ ഹസർ-അദ്ദാറിലേക്കും തുടർന്ന് അസ്മോനിലേക്കും നീണ്ട് ");
INSERT INTO malc_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","അവിടെവെച്ച് അതു തിരിഞ്ഞ് ഈജിപ്റ്റിലെ തോടുമായിച്ചേർന്ന് മെഡിറ്ററേനിയൻ സമുദ്രത്തിൽ അവസാനിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","പടിഞ്ഞാറേ അതിര് മെഡിറ്ററേനിയൻ മഹാസമുദ്രതീരം ആയിരിക്കും. ഇതാണ് നിങ്ങളുടെ പടിഞ്ഞാറേ അതിര്. ");
INSERT INTO malc_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","വടക്കേ അതിർ മെഡിറ്ററേനിയൻ മഹാസമുദ്രം തുടങ്ങി ഹോർ പർവതംവരെ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","അവിടെനിന്ന് ലെബോ-ഹമാത്തുവരെയും അതിർത്തിയാകും. പിന്നെ ആ അതിർത്തി സെദാദിലേക്കു പോയി, ");
INSERT INTO malc_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","സിഫ്രോനിലേക്കു തുടർന്ന് ഹസർ-ഏനാനിൽ അവസാനിക്കും. ഇതായിരിക്കും നിങ്ങളുടെ വടക്കുള്ള അതിർത്തി. ");
INSERT INTO malc_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","കിഴക്ക്, ഹസർ-ഏനാനിൽനിന്നും ശെഫാംവരെ നിങ്ങളുടെ അതിരാകും. ");
INSERT INTO malc_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ആ അതിർത്തി ശെഫാമിൽനിന്ന് അയീന്റെ കിഴക്കുഭാഗത്തുള്ള രിബ്ലയിലേക്ക് ഇറങ്ങിച്ചെന്ന് കിന്നെരെത്തുതടാകത്തിന്റെ കിഴക്കുള്ള ചരിവുകളിൽക്കൂടി നെടുകെ തുടർന്നുപോകും. ");
INSERT INTO malc_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","പിന്നെ ആ അതിർത്തി യോർദാനു സമാന്തരമായി താഴോട്ടുപോയി ഉപ്പുകടലിൽ അവസാനിക്കും. “ ‘നിങ്ങളുടെ ദേശത്തിന്റെ ചുറ്റുമുള്ള അതിരുകൾ ഇവയായിരിക്കും.’ ” ");
INSERT INTO malc_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","മോശ ഇസ്രായേല്യരോടു കൽപ്പിച്ചു: “ഈ ദേശം നറുക്കിലൂടെ അവകാശമായി ഭാഗിച്ചെടുക്കണം. ഒൻപതരഗോത്രങ്ങൾക്ക് അതുകൊടുക്കണമെന്ന് യഹോവ കൽപ്പിച്ചിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","എന്തെന്നാൽ, രൂബേൻഗോത്രത്തിലെയും ഗാദ്ഗോത്രത്തിലെയും മനശ്ശെയുടെ പാതിഗോത്രത്തിലെയും കുടുംബങ്ങൾക്ക് അവരുടെ ഓഹരി ലഭിച്ചുകഴിഞ്ഞിരിക്കുന്നു. ");
INSERT INTO malc_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ഈ രണ്ടരഗോത്രങ്ങൾ അവരുടെ ഓഹരി യോർദാന് അക്കരെ യെരീഹോവിന് കിഴക്കുഭാഗത്ത് സൂര്യോദയത്തിനുനേരേ സ്വീകരിച്ചിരിക്കുന്നു.” ");
INSERT INTO malc_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ദേശം നിങ്ങൾക്ക് അവകാശമായി ഭാഗിക്കേണ്ട പുരുഷന്മാരുടെ പേരുകൾ ഇവയാണ്: പുരോഹിതനായ എലെയാസാരും നൂന്റെ പുത്രനായ യോശുവയും. ");
INSERT INTO malc_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","കൂടാതെ ഓരോ ഗോത്രത്തിൽനിന്നും ഓരോ പ്രഭുവിനെ ദേശം ഭാഗിക്കേണ്ടതിന് സഹായിയായി നിയമിക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“ഇവയാണ് അവരുടെ പേരുകൾ: “യെഹൂദാഗോത്രത്തിൽനിന്ന് യെഫുന്നെയുടെ മകൻ കാലേബ്. ");
INSERT INTO malc_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ശിമെയോൻഗോത്രത്തിൽനിന്ന് അമ്മീഹൂദിന്റെ മകൻ ശെമൂവേൽ. ");
INSERT INTO malc_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ബെന്യാമീൻഗോത്രത്തിൽനിന്ന് കിസ്ളോന്റെ മകൻ എലീദാദ്. ");
INSERT INTO malc_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ദാൻഗോത്രത്തിൽനിന്നുള്ള പ്രഭു യൊഗ്ലിയുടെ മകൻ ബുക്കി. ");
INSERT INTO malc_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","യോസേഫിന്റെ പുത്രന്മാരിൽ, മനശ്ശെയുടെ ഗോത്രത്തിൽനിന്നുള്ള പ്രഭു ഏഫോദിന്റെ മകൻ ഹന്നീയേൽ. ");
INSERT INTO malc_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","എഫ്രയീമിന്റെ ഗോത്രത്തിൽനിന്നുള്ള പ്രഭു ശിഫ്താന്റെ മകൻ കെമൂവേൽ. ");
INSERT INTO malc_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","സെബൂലൂൻ ഗോത്രത്തിൽനിന്നുള്ള പ്രഭു പർന്നാക്കിന്റെ മകൻ എലീസാഫാൻ. ");
INSERT INTO malc_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","യിസ്സാഖാർഗോത്രത്തിൽനിന്നുള്ള പ്രഭു അസ്സാന്റെ മകൻ ഫല്തിയേൽ. ");
INSERT INTO malc_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ആശേർഗോത്രത്തിൽനിന്നുള്ള പ്രഭു ശെലോമിയുടെ മകൻ അഹീഹൂദ്. ");
INSERT INTO malc_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","നഫ്താലിഗോത്രത്തിൽനിന്നുള്ള പ്രഭു അമ്മീഹൂദിന്റെ മകൻ പെദഹേൽ.” ");
INSERT INTO malc_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","കനാൻദേശത്ത് ഓഹരി വിഭജിച്ചുകൊടുക്കേണ്ടതിന്നു യഹോവ നിയമിച്ച ഇസ്രായേല്യ പുരുഷന്മാർ ഇവരാണ്. ");
INSERT INTO malc_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","യെരീഹോവിനെതിരേ യോർദാന്നരികിൽ മോവാബുസമതലത്തിൽവെച്ച് യഹോവ മോശയോട് ഇപ്രകാരം അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ഇസ്രായേല്യർ കൈവശമാക്കുന്ന അവകാശത്തിൽ ലേവ്യർക്ക് വസിക്കാനായി പട്ടണങ്ങൾ നൽകാൻ അവരോടു കൽപ്പിക്കുക. പട്ടണങ്ങൾക്കു ചുറ്റുമായി പുൽമേടുകളും അവർക്കു കൊടുക്കുക. ");
INSERT INTO malc_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","അങ്ങനെ അവർക്ക് വസിക്കാൻ പട്ടണങ്ങളും അവരുടെ കന്നുകാലികൾക്കും സകലവളർത്തുമൃഗങ്ങൾക്കും മേയാൻ പുൽമേടുകളും ലഭിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“നിങ്ങൾ ലേവ്യർക്കു നൽകുന്ന പുൽപ്പുറങ്ങൾക്ക്, പട്ടണമതിലിൽനിന്ന് പുറത്തേക്കു ചുറ്റും ആയിരംമുഴം വിസ്താരമുണ്ടായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","പട്ടണത്തിനുപുറത്ത്, രണ്ടായിരംമുഴം കിഴക്കുഭാഗത്തും രണ്ടായിരം തെക്കുഭാഗത്തും രണ്ടായിരം പടിഞ്ഞാറുഭാഗത്തും രണ്ടായിരംമുഴം വടക്കുഭാഗത്തും നടുവിൽ പട്ടണം വരത്തക്കവിധം അളക്കുക. ഇത് അവർക്കു പട്ടണങ്ങളുടെ പുൽമേടുകളായിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“നിങ്ങൾ ലേവ്യർക്കു നൽകുന്ന പട്ടണങ്ങളിൽ ആറെണ്ണം സങ്കേതനഗരങ്ങൾ ആയിരിക്കും. അബദ്ധവശാൽ കൊലപാതകം ചെയ്ത വ്യക്തിക്ക് അവയിലൊന്നിലേക്ക് ഓടിയൊളിക്കാം. ഇതിനുപുറമേ, മറ്റു നാൽപ്പത്തിരണ്ട് പട്ടണങ്ങളും അവർക്കു നൽകണം. ");
INSERT INTO malc_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ആകെ നാൽപ്പത്തിയെട്ടു പട്ടണങ്ങൾ, അവയുടെ പുൽമേടുകളോടുകൂടെ നിങ്ങൾ ലേവ്യർക്കു നൽകണം. ");
INSERT INTO malc_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ഇസ്രായേല്യർ കൈവശമാക്കുന്ന ദേശത്തുനിന്ന് നിങ്ങൾ ലേവ്യർക്കു നൽകുന്ന പട്ടണങ്ങൾ ഓരോ ഗോത്രത്തിന്റെയും അവകാശത്തിന് അനുപാതമായിട്ട് ആയിരിക്കണം നൽകേണ്ടത്: അധികം പട്ടണങ്ങൾ ഉള്ള ഗോത്രത്തിൽനിന്ന് അധികം എടുക്കണം. എന്നാൽ കുറച്ചുള്ള ഒന്നിൽനിന്ന് കുറച്ചും എടുക്കണം.” ");
INSERT INTO malc_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","പിന്നെ യഹോവ മോശയോട് അരുളിച്ചെയ്തു: ");
INSERT INTO malc_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ഇസ്രായേല്യരോടു സംസാരിക്കണം. അവരോട് ഇപ്രകാരം പറയുക: നിങ്ങൾ യോർദാൻ കടന്ന് കനാനിൽ എത്തുമ്പോൾ, ");
INSERT INTO malc_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","അബദ്ധവശാൽ ആരെയെങ്കിലും വധിക്കുന്ന ഒരു വ്യക്തിക്ക് ഓടിച്ചെല്ലാനുള്ള—നിങ്ങളുടെ സങ്കേതനഗരങ്ങൾ ആയിരിക്കാൻ—ചില പട്ടണങ്ങളെ തെരഞ്ഞെടുക്കണം. ");
INSERT INTO malc_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","കൊലക്കുറ്റം ചുമത്തപ്പെട്ട ഒരു വ്യക്തി സഭയുടെമുമ്പാകെ വിസ്താരത്തിന്നു വിധേയനാകുന്നതുവരെ മരിക്കാതിരിക്കാനായി പ്രതികാരകനിൽനിന്നുള്ള സങ്കേതസ്ഥാനങ്ങൾ അവ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","നിങ്ങൾ നൽകുന്ന ഈ ആറുപട്ടണങ്ങൾ നിങ്ങളുടെ സങ്കേതനഗരങ്ങൾ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","മൂന്നെണ്ണം യോർദാന്റെ അക്കരെയും മൂന്നെണ്ണം കനാനിലും സങ്കേതനഗരങ്ങളായി നൽകുക. ");
INSERT INTO malc_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","മറ്റൊരു വ്യക്തിയെ അബദ്ധവശാൽ കൊന്ന ഏതൊരാൾക്കും ഓടിച്ചെല്ലാൻ കഴിയേണ്ടതിന്, ഇസ്രായേല്യർക്കും പ്രവാസികൾക്കും അവരുടെയിടയിൽ പാർക്കുന്ന മറ്റേതൊരു ജനത്തിനും ഈ ആറുപട്ടണങ്ങൾ സങ്കേതസ്ഥാനങ്ങൾ ആയിരിക്കും. ");
INSERT INTO malc_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘ഒരാൾ മറ്റൊരാളെ ഒരു ഇരുമ്പുപകരണംകൊണ്ട് അടിക്കുകയും അയാൾ മരിക്കുകയും ചെയ്താൽ ആ മനുഷ്യൻ ഒരു കൊലപാതകി; കൊലപാതകി മരണശിക്ഷ അനുഭ