﻿USE sofia;
DROP TABLE IF EXISTS sofia.mal2015_vpl;
CREATE TABLE mal2015_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mal2015_vpl WRITE;
INSERT INTO mal2015_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ആദിയിൽ ദൈവം ആകാശവും ഭൂമിയും സൃഷ്ടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ഭൂമി പാഴായും ശൂന്യമായും ഇരുന്നു; ആഴത്തിന്മീതെ ഇരുൾ ഉണ്ടായിരുന്നു. ദൈവത്തിന്റെ ആത്മാവു വെള്ളത്തിൻ മീതെ പരിവർത്തിച്ചുകൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","വെളിച്ചം ഉണ്ടാകട്ടെ എന്നു ദൈവം കല്പിച്ചു; വെളിച്ചം ഉണ്ടായി. ");
INSERT INTO mal2015_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","വെളിച്ചം നല്ലതു എന്നു ദൈവം കണ്ടു; ദൈവം വെളിച്ചവും ഇരുളും തമ്മിൽ വേർപിരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ദൈവം വെളിച്ചത്തിന്നു പകൽ എന്നും ഇരുളിന്നു രാത്രി എന്നും പേരിട്ടു. സന്ധ്യയായി ഉഷസ്സുമായി, ഒന്നാം ദിവസം. ");
INSERT INTO mal2015_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ദൈവം: വെള്ളങ്ങളുടെ മദ്ധ്യേ ഒരു വിതാനം ഉണ്ടാകട്ടെ; അതു വെള്ളത്തിന്നും വെള്ളത്തിന്നും തമ്മിൽ വേർപിരിവായിരിക്കട്ടെ എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","വിതാനം ഉണ്ടാക്കീട്ടു ദൈവം വിതാനത്തിൻ കീഴുള്ള വെള്ളവും വിതാനത്തിൻ മീതെയുള്ള വെള്ളവും തമ്മിൽ വേർപിരിച്ചു; അങ്ങനെ സംഭവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ദൈവം വിതാനത്തിന്നു ആകാശം എന്നു പേരിട്ടു. സന്ധ്യയായി ഉഷസ്സുമായി, രണ്ടാം ദിവസം. ");
INSERT INTO mal2015_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ദൈവം: ആകാശത്തിൻ കീഴുള്ള വെള്ളം ഒരു സ്ഥലത്തു കൂടട്ടെ; ഉണങ്ങിയ നിലം കാണട്ടെ എന്നു കല്പിച്ചു; അങ്ങനെ സംഭവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ഉണങ്ങിയ നിലത്തിന്നു ദൈവം ഭൂമി എന്നും വെള്ളത്തിന്റെ കൂട്ടത്തിന്നു സമുദ്രം എന്നും പേരിട്ടു; നല്ലതു എന്നു ദൈവം കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ഭൂമിയിൽനിന്നു പുല്ലും വിത്തുള്ള സസ്യങ്ങളും ഭൂമിയിൽ അതതു തരം വിത്തുള്ള ഫലം കായിക്കുന്ന വൃക്ഷങ്ങളും മുളെച്ചുവരട്ടെ എന്നു ദൈവം കല്പിച്ചു; അങ്ങനെ സംഭവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ഭൂമിയിൽ നിന്നു പുല്ലും അതതു തരം വിത്തുള്ള ഫലം കായിക്കുന്ന വൃക്ഷങ്ങളും മുളെച്ചുവന്നു; നല്ലതു എന്നു ദൈവം കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","സന്ധ്യയായി ഉഷസ്സുമായി, മൂന്നാം ദിവസം. ");
INSERT INTO mal2015_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","പകലും രാവും തമ്മിൽ വേർപിരിവാൻ ആകാശവിതാനത്തിൽ വെളിച്ചങ്ങൾ ഉണ്ടാകട്ടെ; അവ അടയാളങ്ങളായും കാലം, ദിവസം, സംവത്സരം എന്നിവ തിരിച്ചറിവാനായും ഉതകട്ടെ; ");
INSERT INTO mal2015_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ഭൂമിയെ പ്രകാശിപ്പിപ്പാൻ ആകാശവിതാനത്തിൽ അവ വെളിച്ചങ്ങളായിരിക്കട്ടെ എന്നു ദൈവം കല്പിച്ചു; അങ്ങനെ സംഭവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","പകൽ വാഴേണ്ടതിന്നു വലിപ്പമേറിയ വെളിച്ചവും രാത്രി വാഴേണ്ടതിന്നു വലിപ്പം കുറഞ്ഞ വെളിച്ചവും ആയി രണ്ടു വലിയ വെളിച്ചങ്ങളെ ദൈവം ഉണ്ടാക്കി; നക്ഷത്രങ്ങളെയും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ഭൂമിയെ പ്രകാശിപ്പിപ്പാനും പകലും രാത്രിയും വാഴുവാനും വെളിച്ചത്തെയും ഇരുളിനെയും തമ്മിൽ വേർപിരിപ്പാനുമായി ");
INSERT INTO mal2015_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ദൈവം അവയെ ആകാശവിതാനത്തിൽ നിർത്തി; നല്ലതു എന്നു ദൈവം കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","സന്ധ്യയായി ഉഷസ്സുമായി, നാലാം ദിവസം. ");
INSERT INTO mal2015_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","വെള്ളത്തിൽ ജലജന്തുക്കൾ കൂട്ടമായി ജനിക്കട്ടെ; ഭൂമിയുടെ മീതെ ആകാശവിതാനത്തിൽ പറവജാതി പറക്കട്ടെ എന്നു ദൈവം കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ദൈവം വലിയ തിമിംഗലങ്ങളെയും വെള്ളത്തിൽ കൂട്ടമായി ജനിച്ചു ചരിക്കുന്ന അതതു തരം ജീവജന്തുക്കളെയും അതതു തരം പറവജാതിയെയും സൃഷ്ടിച്ചു; നല്ലതു എന്നു ദൈവം കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","നിങ്ങൾ വർദ്ധിച്ചു പെരുകി സമുദ്രത്തിലെ വെള്ളത്തിൽ നിറവിൻ; പറവജാതി ഭൂമിയിൽ പെരുകട്ടെ എന്നു കല്പിച്ചു ദൈവം അവയെ അനുഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","സന്ധ്യയായി ഉഷസ്സുമായി, അഞ്ചാം ദിവസം. ");
INSERT INTO mal2015_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","അതതു തരം കന്നുകാലി, ഇഴജാതി, കാട്ടുമൃഗം ഇങ്ങനെ അതതുതരം ജീവജന്തുക്കൾ ഭൂമിയിൽനിന്നുളവാകട്ടെ എന്നു ദൈവം കല്പിച്ചു; അങ്ങനെ സംഭവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ഇങ്ങനെ ദൈവം അതതു തരം കാട്ടുമൃഗങ്ങളെയും അതതു തരം കന്നുകാലികളെയും അതതു തരം ഭൂചരജന്തുക്കളെയും ഉണ്ടാക്കി; നല്ലതു എന്നു ദൈവം കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","അനന്തരം ദൈവം: നാം നമ്മുടെ സ്വരൂപത്തിൽ നമ്മുടെ സാദൃശ്യപ്രകാരം മനുഷ്യനെ ഉണ്ടാക്കുക; അവർ സമുദ്രത്തിലുള്ള മത്സ്യത്തിന്മേലും ആകാശത്തിലുള്ള പറവജാതിയിന്മേലും മൃഗങ്ങളിന്മേലും സർവ്വഭൂമിയിന്മേലും ഭൂമിയിൽ ഇഴയുന്ന എല്ലാഇഴജാതിയിന്മേലും വാഴട്ടെ എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ഇങ്ങനെ ദൈവം തന്റെ സ്വരൂപത്തിൽ മനുഷ്യനെ സൃഷ്ടിച്ചു, ദൈവത്തിന്റെ സ്വരൂപത്തിൽ അവനെ സൃഷ്ടിച്ചു, ആണും പെണ്ണുമായി അവരെ സൃഷ്ടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ദൈവം അവരെ അനുഗ്രഹിച്ചു: നിങ്ങൾ സന്താനപുഷ്ടിയുള്ളവരായി പെരുകി ഭൂമിയിൽ നിറഞ്ഞു അതിനെ അടക്കി സമുദ്രത്തിലെ മത്സ്യത്തിന്മേലും ആകാശത്തിലെ പറവജാതിയിന്മേലും സകലഭൂചരജന്തുവിന്മേലും വാഴുവിൻ എന്നു അവരോടു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ഭൂമിയിൽ എങ്ങും വിത്തുള്ള സസ്യങ്ങളും വൃക്ഷത്തിന്റെ വിത്തുള്ള ഫലം കായിക്കുന്ന സകലവൃക്ഷങ്ങളും ഇതാ, ഞാൻ നിങ്ങൾക്കു തന്നിരിക്കുന്നു; അവ നിങ്ങൾക്കു ആഹാരമായിരിക്കട്ടെ; ");
INSERT INTO mal2015_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ഭൂമിയിലെ സകലമൃഗങ്ങൾക്കും ആകാശത്തിലെ എല്ലാ പറവകൾക്കും ഭൂമിയിൽ ചരിക്കുന്ന സകലഭൂചരജന്തുക്കൾക്കും ആഹാരമായിട്ടു പച്ചസസ്യം ഒക്കെയും ഞാൻ കൊടുത്തിരിക്കുന്നു എന്നു ദൈവം കല്പിച്ചു; അങ്ങനെ സംഭവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","താൻ ഉണ്ടാക്കിയതിനെ ഒക്കെയും ദൈവം നോക്കി, അതു എത്രയും നല്ലതു എന്നു കണ്ടു. സന്ധ്യയായി ഉഷസ്സുമായി, ആറാം ദിവസം. ");
INSERT INTO mal2015_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ഇങ്ങനെ ആകാശവും ഭൂമിയും അവയിലുള്ള ചരാചരങ്ങളൊക്കെയും തികഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","താൻ ചെയ്ത പ്രവൃത്തി ഒക്കെയും ദൈവം തീർത്തശേഷം താൻ ചെയ്ത സകലപ്രവൃത്തിയിൽനിന്നും ഏഴാം ദിവസം നിവൃത്തനായി. ");
INSERT INTO mal2015_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","താൻ സൃഷ്ടിച്ചുണ്ടാക്കിയ സകല പ്രവൃത്തിയിൽനിന്നും അന്നു നിവൃത്തനായതുകൊണ്ടു ദൈവം ഏഴാം ദിവസത്തെ അനുഗ്രഹിച്ചു ശുദ്ധീകരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","യഹോവയായ ദൈവം ഭൂമിയും ആകാശവും സൃഷ്ടിച്ച നാളിൽ ആകാശവും ഭൂമിയും സൃഷ്ടിച്ചതിന്റെ ഉല്പത്തിവിവരം: വയലിലെ ചെടി ഒന്നും അതുവരെ ഭൂമിയിൽ ഉണ്ടായിരുന്നില്ല; വയലിലെ സസ്യം ഒന്നും മുളെച്ചിരുന്നതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","യഹോവയായ ദൈവം ഭൂമിയിൽ മഴ പെയ്യിച്ചിരുന്നില്ല; നിലത്തു വേല ചെയ്‌വാൻ മനുഷ്യനും ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ഭൂമിയിൽ നിന്നു മഞ്ഞു പൊങ്ങി, നിലം ഒക്കെയും നനെച്ചുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","യഹോവയായ ദൈവം നിലത്തെ പൊടികൊണ്ടു മനുഷ്യനെ നിർമ്മിച്ചിട്ടു അവന്റെ മൂക്കിൽ ജീവശ്വാസം ഊതി, മനുഷ്യൻ ജീവനുള്ള ദേഹിയായി തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","അനന്തരം യഹോവയായ ദൈവം കിഴക്കു ഏദെനിൽ ഒരു തോട്ടം ഉണ്ടാക്കി, താൻ സൃഷ്ടിച്ച മനുഷ്യനെ അവിടെ ആക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","കാണ്മാൻ ഭംഗിയുള്ളതും തിന്മാൻ നല്ല ഫലമുള്ളതുമായ ഓരോ വൃക്ഷങ്ങളും തോട്ടത്തിന്റെ നടുവിൽ ജീവവൃക്ഷവും നന്മതിന്മകളെക്കുറിച്ചുള്ള അറിവിന്റെ വൃക്ഷവും യഹോവയായ ദൈവം നിലത്തുനിന്നു മുളെപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","തോട്ടം നനെപ്പാൻ ഒരു നദി ഏദെനിൽനിന്നു പുറപ്പെട്ടു; അതു അവിടെനിന്നു നാലു ശാഖയായി പിരിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ഒന്നാമത്തേതിന്നു പീശോൻ എന്നു പേർ; അതു ഹവീലാദേശമൊക്കെയും ചുറ്റുന്നു; അവിടെ പൊന്നുണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ആ ദേശത്തിലെ പൊന്നു മേത്തരമാകുന്നു; അവിടെ ഗുല്ഗുലുവും ഗോമേദകവും ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","രണ്ടാം നദിക്കു ഗീഹോൻ എന്നു പേർ; അതു കൂശ്‌ദേശമൊക്കെയും ചുറ്റുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","മൂന്നാം നദിക്കു ഹിദ്ദേക്കെൽ എന്നു പേർ; അതു അശ്ശൂരിന്നു കിഴക്കോട്ടു ഒഴുകുന്നു; നാലാം നദി ഫ്രാത്ത് ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","യഹോവയായ ദൈവം മനുഷ്യനെ കൂട്ടിക്കൊണ്ടു പോയി ഏദെൻ തോട്ടത്തിൽ വേല ചെയ്‌വാനും അതിനെ കാപ്പാനും അവിടെ ആക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","യഹോവയായ ദൈവം മനുഷ്യനോടു കല്പിച്ചതു എന്തെന്നാൽ: തോട്ടത്തിലെ സകലവൃക്ഷങ്ങളുടെയും ഫലം നിനക്കു ഇഷ്ടംപോലെ തിന്നാം. ");
INSERT INTO mal2015_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","എന്നാൽ നന്മതിന്മകളെക്കുറിച്ചുള്ള അറിവിന്റെ വൃക്ഷത്തിൻ ഫലം തിന്നരുതു; തിന്നുന്ന നാളിൽ നീ മരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","അനന്തരം യഹോവയായ ദൈവം: മനുഷ്യൻ ഏകനായിരിക്കുന്നതു നന്നല്ല; ഞാൻ അവന്നു തക്കതായൊരു തുണ ഉണ്ടാക്കിക്കൊടുക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","യഹോവയായ ദൈവം ഭൂമിയിലെ സകല മൃഗങ്ങളെയും ആകാശത്തിലെ എല്ലാ പറവകളെയും നിലത്തു നിന്നു നിർമ്മിച്ചിട്ടു മനുഷ്യൻ അവെക്കു എന്തു പേരിടുമെന്നു കാണ്മാൻ അവന്റെ മുമ്പിൽ വരുത്തി; സകല ജീവജന്തുക്കൾക്കും മനുഷ്യൻ ഇട്ടതു അവെക്കു പേരായി. ");
INSERT INTO mal2015_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","മനുഷ്യൻ എല്ലാകന്നുകാലികൾക്കും ആകാശത്തിലെ പറവകൾക്കും എല്ലാകാട്ടുമൃഗങ്ങൾക്കും പേരിട്ടു; എങ്കിലും മനുഷ്യന്നു തക്കതായൊരു തുണ കണ്ടുകിട്ടിയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ആകയാൽ യഹോവയായ ദൈവം മനുഷ്യന്നു ഒരു ഗാഢനിദ്ര വരുത്തി; അവൻ ഉറങ്ങിയപ്പോൾ അവന്റെ വാരിയെല്ലുകളിൽ ഒന്നു എടുത്തു അതിന്നു പകരം മാംസം പിടിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","യഹോവയായ ദൈവം മനുഷ്യനിൽനിന്നു എടുത്ത വാരിയെല്ലിനെ ഒരു സ്ത്രീയാക്കി, അവളെ മനുഷ്യന്റെ അടുക്കൽ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","അപ്പോൾ മനുഷ്യൻ; ഇതു ഇപ്പോൾ എന്റെ അസ്ഥിയിൽ നിന്നു അസ്ഥിയും എന്റെ മാംസത്തിൽനിന്നു മാംസവും ആകുന്നു. ഇവളെ നരനിൽനിന്നു എടുത്തിരിക്കയാൽ ഇവൾക്കു നാരി എന്നു പേരാകും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","അതുകൊണ്ടു പുരുഷൻ അപ്പനെയും അമ്മയെയും വിട്ടുപിരിഞ്ഞു ഭാര്യയോടു പറ്റിച്ചേരും; അവർ ഏകദേഹമായി തീരും. ");
INSERT INTO mal2015_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","മനുഷ്യനും ഭാര്യയും ഇരുവരും നഗ്നരായിരുന്നു; അവർക്കു നാണം തോന്നിയില്ലതാനും. ");
INSERT INTO mal2015_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","യഹോവയായ ദൈവം ഉണ്ടാക്കിയ എല്ലാ കാട്ടുജന്തുക്കളെക്കാളും പാമ്പു കൗശലമേറിയതായിരുന്നു. അതു സ്ത്രീയോടു: തോട്ടത്തിലെ യാതൊരു വൃക്ഷത്തിന്റെ ഫലവും നിങ്ങൾ തിന്നരുതെന്നു ദൈവം വാസ്തവമായി കല്പിച്ചിട്ടുണ്ടോ എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","സ്ത്രീ പാമ്പിനോടു: തോട്ടത്തിലെ വൃക്ഷങ്ങളുടെ ഫലം ഞങ്ങൾക്കു തിന്നാം; ");
INSERT INTO mal2015_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","എന്നാൽ നിങ്ങൾ മരിക്കാതിരിക്കേണ്ടതിന്നു തോട്ടത്തിന്റെ നടുവിലുള്ള വൃക്ഷത്തിന്റെ ഫലം തിന്നരുതു, തൊടുകയും അരുതു എന്നു ദൈവം കല്പിച്ചിട്ടുണ്ടു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","പാമ്പു സ്ത്രീയോടു: നിങ്ങൾ മരിക്കയില്ല നിശ്ചയം; ");
INSERT INTO mal2015_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","അതു തിന്നുന്ന നാളിൽ നിങ്ങളുടെ കണ്ണു തുറക്കയും നിങ്ങൾ നന്മതിന്മകളെ അറിയുന്നവരായി ദൈവത്തെപ്പോലെ ആകയും ചെയ്യും എന്നു ദൈവം അറിയുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ആ വൃക്ഷഫലം തിന്മാൻ നല്ലതും കാണ്മാൻ ഭംഗിയുള്ളതും ജ്ഞാനം പ്രാപിപ്പാൻ കാമ്യവും എന്നു സ്ത്രീ കണ്ടു ഫലം പറിച്ചു തിന്നു ഭർത്താവിന്നും കൊടുത്തു; അവനും തിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ഉടനെ ഇരുവരുടെയും കണ്ണു തുറന്നു തങ്ങൾ നഗ്നരെന്നു അറിഞ്ഞു, അത്തിയില കൂട്ടിത്തുന്നി തങ്ങൾക്കു അരയാട ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","വെയിലാറിയപ്പോൾ യഹോവയായ ദൈവം തോട്ടത്തിൽ നടക്കുന്ന ഒച്ച അവർ കേട്ടു; മനുഷ്യനും ഭാര്യയും യഹോവയായ ദൈവം തങ്ങളെ കാണാതിരിപ്പാൻ തോട്ടത്തിലെ വൃക്ഷങ്ങളുടെ ഇടയിൽ ഒളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","യഹോവയായ ദൈവം മനുഷ്യനെ വിളിച്ചു: നീ എവിടെ എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","തോട്ടത്തിൽ നിന്റെ ഒച്ച കേട്ടിട്ടു ഞാൻ നഗ്നനാകകൊണ്ടു ഭയപ്പെട്ടു ഒളിച്ചു എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","നീ നഗ്നനെന്നു നിന്നോടു ആർ പറഞ്ഞു? തിന്നരുതെന്നു ഞാൻ നിന്നോടു കല്പിച്ച വൃക്ഷഫലം നീ തിന്നുവോ എന്നു അവൻ ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","അതിന്നു മനുഷ്യൻ: എന്നോടു കൂടെ ഇരിപ്പാൻ നീ തന്നിട്ടുള്ള സ്ത്രീ വൃക്ഷഫലം തന്നു; ഞാൻ തിന്നുകയും ചെയ്തു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","യഹോവയായ ദൈവം സ്ത്രീയോടു: നീ ഈ ചെയ്തതു എന്തു എന്നു ചോദിച്ചതിന്നു: പാമ്പു എന്നെ വഞ്ചിച്ചു, ഞാൻ തിന്നുപോയി എന്നു സ്ത്രീ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","യഹോവയായ ദൈവം പാമ്പിനോടു കല്പിച്ചതു: നീ ഇതു ചെയ്കകൊണ്ടു എല്ലാ കന്നുകാലികളിലും എല്ലാ കാട്ടുമൃഗങ്ങളിലുംവെച്ചു നീ ശപിക്കപ്പെട്ടിരിക്കുന്നു; നീ ഉരസ്സുകൊണ്ടു ഗമിച്ചു നിന്റെ ആയുഷ്കാലമൊക്കെയും പൊടി തിന്നും. ");
INSERT INTO mal2015_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ഞാൻ നിനക്കും സ്ത്രീക്കും നിന്റെ സന്തതിക്കും അവളുടെ സന്തതിക്കും തമ്മിൽ ശത്രുത്വം ഉണ്ടാക്കും. അവൻ നിന്റെ തല തകർക്കും; നീ അവന്റെ കുതികാൽ തകർക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","സ്ത്രീയോടു കല്പിച്ചതു: ഞാൻ നിനക്കു കഷ്ടവും ഗർഭധാരണവും ഏറ്റവും വർദ്ധിപ്പിക്കും; നീ വേദനയോടെ മക്കളെ പ്രസവിക്കും; നിന്റെ ആഗ്രഹം നിന്റെ ഭർത്താവിനോടു ആകും; അവൻ നിന്നെ ഭരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","മനുഷ്യനോടു കല്പിച്ചതോ: നീ നിന്റെ ഭാര്യയുടെ വാക്കു അനുസരിക്കയും തിന്നരുതെന്നു ഞാൻ കല്പിച്ച വൃക്ഷഫലം തിന്നുകയും ചെയ്തതുകൊണ്ടു നിന്റെ നിമിത്തം ഭൂമി ശപിക്കപ്പെട്ടിരിക്കുന്നു; നിന്റെ ആയുഷ്കാലമൊക്കെയും നീ കഷ്ടതയോടെ അതിൽനിന്നു അഹോവൃത്തി കഴിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","മുള്ളും പറക്കാരയും നിനക്കു അതിൽനിന്നു മുളെക്കും; വയലിലെ സസ്യം നിനക്കു ആഹാരമാകും. ");
INSERT INTO mal2015_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","നിലത്തുനിന്നു നിന്നെ എടുത്തിരിക്കുന്നു; അതിൽ തിരികെ ചേരുവോളം മുഖത്തെ വിയർപ്പോടെ നീ ഉപജീവനം കഴിക്കും; നീ പൊടിയാകുന്നു, പൊടിയിൽ തിരികെ ചേരും. ");
INSERT INTO mal2015_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","മനുഷ്യൻ തന്റെ ഭാര്യക്കു ഹവ്വാ എന്നു പേരിട്ടു; അവൾ ജീവനുള്ളവർക്കെല്ലാം മാതാവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","യഹോവയായ ദൈവം ആദാമിന്നും അവന്റെ ഭാര്യക്കും തോൽകൊണ്ടു ഉടുപ്പു ഉണ്ടാക്കി അവരെ ഉടുപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","യഹോവയായ ദൈവം: മനുഷ്യൻ നന്മതിന്മകളെ അറിവാൻ തക്കവണ്ണം നമ്മിൽ ഒരുത്തനെപ്പോലെ ആയിത്തീർന്നിരിക്കുന്നു; ഇപ്പോൾ അവൻ കൈനീട്ടി ജീവവൃക്ഷത്തിന്റെ ഫലം കൂടെ പറിച്ചു തിന്നു എന്നേക്കും ജീവിപ്പാൻ സംഗതി വരരുതു എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","അവനെ എടുത്തിരുന്ന നിലത്തു കൃഷി ചെയ്യേണ്ടതിന്നു യഹോവയായ ദൈവം അവനെ ഏദെൻതോട്ടത്തിൽനിന്നു പുറത്താക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ഇങ്ങനെ അവൻ മനുഷ്യനെ ഇറക്കിക്കളഞ്ഞു; ജീവന്റെ വൃക്ഷത്തിങ്കലേക്കുള്ള വഴി കാപ്പാൻ അവൻ ഏദെൻ തോട്ടത്തിന്നു കിഴക്കു കെരൂബുകളെ തിരിഞ്ഞുകൊണ്ടിരിക്കുന്ന വാളിന്റെ ജ്വാലയുമായി നിർത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","അനന്തരം മനുഷ്യൻ തന്റെ ഭാര്യയായ ഹവ്വയെ പരിഗ്രഹിച്ചു; അവൾ ഗർഭം ധരിച്ചു കയീനെ പ്രസവിച്ചു: യഹോവയാൽ എനിക്കു ഒരു പുരുഷപ്രജ ലഭിച്ചു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","പിന്നെ അവൾ അവന്റെ അനുജനായ ഹാബെലിനെ പ്രസവിച്ചു. ഹാബെൽ ആട്ടിടയനും കയീൻ കൃഷിക്കാരനും ആയിത്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","കുറെക്കാലം കഴിഞ്ഞിട്ടു കയീൻ നിലത്തെ അനുഭവത്തിൽനിന്നു യഹോവെക്കു ഒരു വഴിപാടു കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ഹാബെലും ആട്ടിൻ കൂട്ടത്തിലെ കടിഞ്ഞൂലുകളിൽനിന്നു, അവയുടെ മേദസ്സിൽനിന്നു തന്നേ, ഒരു വഴിപാടു കൊണ്ടുവന്നു. യഹോവ ഹാബെലിലും അവന്റെ വഴിപാടിലും പ്രസാദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","കയീനിലും അവന്റെ വഴിപാടിലും പ്രസാദിച്ചില്ല. കയീന്നു ഏറ്റവും കോപമുണ്ടായി, അവന്റെ മുഖം വാടി. ");
INSERT INTO mal2015_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","എന്നാറെ യഹോവ കയീനോടു: നീ കോപിക്കുന്നതു എന്തിന്നു? നിന്റെ മുഖം വാടുന്നതും എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","നീ നന്മചെയ്യുന്നു എങ്കിൽ പ്രസാദമുണ്ടാകയില്ലയോ? നീ നന്മ ചെയ്യുന്നില്ലെങ്കിലോ പാപം വാതില്ക്കൽ കിടക്കുന്നു; അതിന്റെ ആഗ്രഹം നിങ്കലേക്കു ആകുന്നു; നീയോ അതിനെ കീഴടക്കേണം എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","എന്നാറെ കയീൻ തന്റെ അനുജനായ ഹാബെലിനോടു: (നാം വയലിലേക്കു പോക എന്നു) പറഞ്ഞു. അവർ വയലിൽ ഇരിക്കുമ്പോൾ കയീൻ തന്റെ അനുജനായ ഹാബെലിനോടു കയർത്തു അവനെ കൊന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","പിന്നെ യഹോവ കയീനോടു: നിന്റെ അനുജനായ ഹാബെൽ എവിടെ എന്നു ചോദിച്ചതിന്നു: ഞാൻ അറിയുന്നില്ല; ഞാൻ എന്റെ അനുജന്റെ കാവൽക്കാരനോ എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","അതിന്നു അവൻ അരുളിച്ചെയ്തതു. നീ എന്തു ചെയ്തു? നിന്റെ അനുജന്റെ രക്തത്തിന്റെ ശബ്ദം ഭൂമിയിൽ നിന്നു എന്നോടു നിലവിളിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ഇപ്പോൾ നിന്റെ അനുജന്റെ രക്തം നിന്റെ കയ്യിൽ നിന്നു ഏറ്റുകൊൾവാൻ വായിതുറന്ന ദേശം നീ വിട്ടു ശാപഗ്രസ്തനായി പോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","നീ കൃഷി ചെയ്യുമ്പോൾ നിലം ഇനി മേലാൽ തന്റെ വീര്യം നിനക്കു തരികയില്ല; നീ ഭൂമിയിൽ ഉഴന്നലയുന്നവൻ ആകും. ");
INSERT INTO mal2015_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","കയീൻ യഹോവയോടു: എന്റെ കുറ്റം പൊറുപ്പാൻ കഴിയുന്നതിനെക്കാൾ വലിയതാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ഇതാ, നീ ഇന്നു എന്നെ ആട്ടിക്കളയുന്നു; ഞാൻ തിരുസന്നിധിവിട്ടു ഒളിച്ചു ഭൂമിയിൽ ഉഴന്നലയുന്നവൻ ആകും; ആരെങ്കിലും എന്നെ കണ്ടാൽ, എന്നെ കൊല്ലും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","യഹോവ അവനോടു: അതുകൊണ്ടു ആരെങ്കിലും കയീനെ കൊന്നാൽ അവന്നു ഏഴിരട്ടി പകരം കിട്ടും എന്നു അരുളിച്ചെയ്തു; കയീനെ കാണുന്നവർ ആരും കൊല്ലാതിരിക്കേണ്ടതിന്നു യഹോവ അവന്നു ഒരു അടയാളം വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","അങ്ങനെ കയീൻ യഹോവയുടെ സന്നിധിയിൽ നിന്നു പുറപ്പെട്ടു ഏദെന്നു കിഴക്കു നോദ് ദേശത്തു ചെന്നു പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","കയീൻ തന്റെ ഭാര്യയെ പരിഗ്രഹിച്ചു; അവൾ ഗർഭം ധരിച്ചു ഹാനോക്കിനെ പ്രസവിച്ചു. അവൻ ഒരു പട്ടണം പണിതു, ഹാനോക്ക് എന്നു തന്റെ മകന്റെ പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ഹാനോക്കിന്നു ഈരാദ് ജനിച്ചു; ഈരാദ് മെഹൂയയേലിനെ ജനിപ്പിച്ചു; മെഹൂയയേൽ മെഥൂശയേലിനെ ജനിപ്പിച്ചു; മെഥൂശയേൽ ലാമെക്കിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ലാമെക്ക് രണ്ടു ഭാര്യമാരെ എടുത്തു; ഒരുത്തിക്കു ആദാ എന്നും മറ്റവൾക്കു സില്ലാ എന്നും പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ആദാ യാബാലിനെ പ്രസവിച്ചു; അവൻ കൂടാരവാസികൾക്കും പശുപാലകന്മാർക്കും പിതാവായ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","അവന്റെ സഹോദരന്നു യൂബാൽ എന്നു പേർ. ഇവൻ കിന്നരവും വേണുവും പ്രയോഗിക്കുന്ന എല്ലാവർക്കും പിതാവായ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","സില്ലാ തൂബൽകയീനെ പ്രസവിച്ചു; അവൻ ചെമ്പുകൊണ്ടും ഇരിമ്പുകൊണ്ടുമുള്ള ആയുധങ്ങളെ തീർക്കുന്നവനായ്തീർന്നു; തൂബൽകയീന്റെ പെങ്ങൾ നയമാ. ");
INSERT INTO mal2015_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ലാമെക്ക് തന്റെ ഭാര്യമാരോടു പറഞ്ഞതു: ആദയും സില്ലയും ആയുള്ളോരേ, എന്റെ വാക്കു കേൾപ്പിൻ; ലാമെക്കിൻ ഭാര്യമാരേ, എന്റെ വചനത്തിന്നു ചെവി തരുവിൻ! എന്റെ മുറിവിന്നു പകരം ഞാൻ ഒരു പുരുഷനെയും, എന്റെ പരിക്കിന്നു പകരം ഒരു യുവാവിനെയും കൊല്ലും. ");
INSERT INTO mal2015_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","കയീന്നുവേണ്ടി ഏഴിരട്ടി പകരം ചെയ്യുമെങ്കിൽ, ലാമെക്കിന്നുവേണ്ടി എഴുപത്തേഴു ഇരട്ടി പകരം ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ആദാം തന്റെ ഭാര്യയെ പിന്നെയും പരിഗ്രഹിച്ചു; അവൾ ഒരു മകനെ പ്രസവിച്ചു: കയീൻ കൊന്ന ഹാബെലിന്നു പകരം ദൈവം എനിക്കു മറ്റൊരു സന്തതിയെ തന്നു എന്നു പറഞ്ഞു അവന്നു ശേത്ത് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ശേത്തിന്നും ഒരു മകൻ ജനിച്ചു; അവന്നു എനോശ് എന്നു പേരിട്ടു. ആ കാലത്തു യഹോവയുടെ നാമത്തിലുള്ള ആരാധന തുടങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ആദാമിന്റെ വംശപാരമ്പര്യമാവിതു: ദൈവം മനുഷ്യനെ സൃഷ്ടിച്ചപ്പോൾ ദൈവത്തിന്റെ സാദൃശ്യത്തിൽ അവനെ ഉണ്ടാക്കി; ആണും പെണ്ണുമായി അവരെ സൃഷ്ടിച്ചു; ");
INSERT INTO mal2015_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","സൃഷ്ടിച്ച നാളിൽ അവരെ അനുഗ്രഹിക്കയും അവർക്കു ആദാമെന്നു പേരിടുകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ആദാമിനു നൂറ്റിമുപ്പതു വയസ്സായാപ്പോൾ അവൻ തന്റെ സാദൃശ്യത്തിൽ തന്റെ സ്വരൂപപ്രകാരം ഒരു മകനെ ജനിപ്പിച്ചു; അവന്നു ശേത്ത് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ശേത്തിനെ ജനിപ്പിച്ചശേഷം ആദാം എണ്ണൂറു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരേയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ആദാമിന്റെ ആയുഷ്കാലം ആകെ തൊള്ളായിരത്തി മുപ്പതു സംവത്സരമായിരുന്നു; പിന്നെ അവൻ മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ശേത്തിന്നു നൂറ്റഞ്ചു വയസ്സായപ്പോൾ അവൻ എനോശിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","എനോശിനെ ജനിപ്പിച്ച ശേഷം ശേത്ത് എണ്ണൂറ്റേഴു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ശേത്തിന്റെ ആയുഷ്കാലം ആകെ തൊള്ളായിരത്തി പന്ത്രണ്ടു സംവത്സരമായിരുന്നു; പിന്നെ അവൻ മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","എനോശിന്നു തൊണ്ണൂറു വയസ്സായപ്പോൾ അവൻ കേനാനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","കേനാനെ ജനിപ്പിച്ച ശേഷം എനോശ് എണ്ണൂറ്റി പതിനഞ്ചു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","എനോശിന്റെ ആയുഷ്കാലം ആകെ തൊള്ളായിരത്തഞ്ചു സംവത്സരമായിരുന്നു; പിന്നെ അവൻ മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","കേനാന്നു എഴുപതു വയസ്സായപ്പോൾ അവൻ മഹലലേലിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","മഹലലേലിനെ ജനിപ്പിച്ച ശേഷം കേനാൻ എണ്ണൂറ്റിനാല്പതു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","കേനാന്റെ ആയുഷ്കാലം ആകെ തൊള്ളായിരത്തി പത്തു സംവത്സരമായിരുന്നു; പിന്നെ അവൻ മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","മഹലലേലിന്നു അറുപത്തഞ്ചു വയസ്സായപ്പോൾ അവൻ യാരെദിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","യാരെദിനെ ജനിപ്പിച്ച ശേഷം മഹലലേൽ എണ്ണൂറ്റി മുപ്പതു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","മഹലലേലിന്റെ ആയുഷ്കാലം ആകെ എണ്ണൂറ്റി തൊണ്ണൂറ്റഞ്ചു സംവത്സരമായിരുന്നു; പിന്നെ അവൻ മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","യാരെദിന്നു നൂറ്ററുപത്തിരണ്ടു വയസ്സായപ്പോൾ അവൻ ഹാനോക്കിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ഹാനോക്കിനെ ജനിപ്പിച്ച ശേഷം യാരെദ് എണ്ണൂറു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","യാരെദിന്റെ ആയൂഷ്കാലം ആകെ തൊള്ളായിരത്തറുപത്തിരണ്ടു സംവത്സരമായിരുന്നു; പിന്നെ അവൻ മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ഹാനോക്കിന്നു അറുപത്തഞ്ചു വയസ്സായപ്പോൾ അവൻ മെഥൂശലഹിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","മെഥൂശലഹിനെ ജനിപ്പിച്ച ശേഷം ഹാനോക്ക് മൂന്നൂറു സംവത്സരം ദൈവത്തോടുകൂടെ നടക്കയും പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിക്കയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ഹനോക്കിന്റെ ആയുഷ്കാലം ആകെ മുന്നൂറ്ററുപത്തഞ്ചു സംവത്സരമായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ഹാനോക്ക് ദൈവത്തോടുകൂടെ നടന്നു, ദൈവം അവനെ എടുത്തുകൊണ്ടതിനാൽ കാണാതെയായി. ");
INSERT INTO mal2015_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","മെഥൂശലഹിന്നു നൂറ്റെണ്പത്തേഴു വയസ്സായപ്പോൾ അവൻ ലാമേക്കിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ലാമേക്കിനെ ജനിപ്പിച്ച ശേഷം മെഥൂശലഹ് എഴുനൂറ്റെണ്പത്തിരണ്ടു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","മെഥൂശലഹിന്റെ ആയൂഷ്കാലം ആകെ തൊള്ളായിരത്തറുപത്തൊമ്പതു സംവത്സരമായിരുന്നു; പിന്നെ അവൻ മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ലാമേക്കിന്നു നൂറ്റെണ്പത്തിരണ്ടു വയസ്സായപ്പോൾ അവൻ ഒരു മകനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","യഹോവ ശപിച്ച ഭൂമിയിൽ നമ്മുടെ പ്രവൃത്തിയിലും നമ്മുടെ കൈകളുടെ പ്രയത്നത്തിലും ഇവൻ നമ്മെ ആശ്വസിപ്പിക്കുമെന്നു പറഞ്ഞു അവന്നു നോഹ എന്നു പേർ ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","നോഹയെ ജനിപ്പിച്ചശേഷം ലാമേക്ക് അഞ്ഞൂറ്റി തൊണ്ണൂറ്റഞ്ചു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ലാമേക്കിന്റെ ആയൂഷ്കാലം ആകെ എഴുനൂറ്റെഴുപത്തേഴു സംവത്സരമായിരുന്നു; പിന്നെ അവൻ മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","നോഹെക്കു അഞ്ഞൂറു വയസ്സായശേഷം നോഹ ശേമിനെയും ഹാമിനെയും യാഫെത്തിനെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","മനുഷ്യർ ഭൂമിയിൽ പെരുകിത്തുടങ്ങി. അവർക്കു പുത്രിമാർ ജനിച്ചപ്പോൾ ");
INSERT INTO mal2015_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ദൈവത്തിന്റെ പുത്രന്മാർ മനുഷ്യരുടെ പുത്രിമാരെ സൗന്ദര്യമുള്ളവരെന്നു കണ്ടിട്ടു തങ്ങൾക്കു ബോധിച്ച ഏവരെയും ഭാര്യമാരായി എടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","അപ്പോൾ യഹോവ: മനുഷ്യനിൽ എന്റെ ആത്മാവു സദാകാലവും വാദിച്ചുകൊണ്ടിരിക്കയില്ല; അവൻ ജഡം തന്നേയല്ലോ; എങ്കിലും അവന്റെ കാലം നൂറ്റിരുപതു സംവത്സരമാകും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","അക്കാലത്തു ഭൂമിയിൽ മല്ലന്മാർ ഉണ്ടായിരുന്നു; അതിന്റെ ശേഷവും ദൈവത്തിന്റെ പുത്രന്മാർ മനുഷ്യരുടെ പുത്രിമാരുടെ അടുക്കൽ ചെന്നിട്ടു അവർ മക്കളെ പ്രസവിച്ചു; ഇവരാകുന്നു പുരാതനകാലത്തെ വീരന്മാർ, കീർത്തിപ്പെട്ട പുരുഷന്മാർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ഭൂമിയിൽ മനുഷ്യന്റെ ദുഷ്ടത വലിയതെന്നും അവന്റെ ഹൃദയവിചാരങ്ങളുടെ നിരൂപണമൊക്കെയും എല്ലായ്പോഴും ദോഷമുള്ളതത്രേ എന്നും യഹോവ കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","താൻ ഭൂമിയിൽ മനുഷ്യനെ ഉണ്ടാക്കുകകൊണ്ടു യഹോവ അനുതപിച്ചു; അതു അവന്റെ ഹൃദയത്തിന്നു ദുഃഖമായി: ");
INSERT INTO mal2015_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ഞാൻ സൃഷ്ടിച്ചിട്ടുള്ള മനുഷ്യനെ ഭൂമിയിൽ നിന്നു നശിപ്പിച്ചുകളയും; മനുഷ്യനെയും മൃഗത്തെയും ഇഴജാതിയെയും ആകാശത്തിലെ പക്ഷികളെയും തന്നേ; അവയെ ഉണ്ടാക്കുകകൊണ്ടു ഞാൻ അനുതപിക്കുന്നു എന്നു യഹോവ അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","എന്നാൽ നോഹെക്കു യഹോവയുടെ കൃപ ലഭിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","നോഹയുടെ വംശപാരമ്പര്യം എന്തെന്നാൽ: നോഹ നീതിമാനും തന്റെ തലമുറയിൽ നിഷ്കളങ്കനുമായിരുന്നു; നോഹ ദൈവത്തോടുകൂടെ നടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ശേം, ഹാം, യാഫെത്ത് എന്ന മൂന്നു പുത്രന്മാരെ നോഹ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","എന്നാൽ ഭൂമി ദൈവത്തിന്റെ മുമ്പാകെ വഷളായി; ഭൂമി അതിക്രമംകൊണ്ടു നിറഞ്ഞിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ദൈവം ഭൂമിയെ നോക്കി, അതു വഷളായി എന്നു കണ്ടു; സകലജഡവും ഭൂമിയിൽ തന്റെ വഴി വഷളാക്കിയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ദൈവം നോഹയോടു കല്പിച്ചതെന്തെന്നാൽ: സകലജഡത്തിന്റെയും അവസാനം എന്റെ മുമ്പിൽ വന്നിരിക്കുന്നു; ഭൂമി അവരാൽ അതിക്രമംകൊണ്ടു നിറഞ്ഞിരിക്കുന്നു; ഞാൻ അവരെ ഭൂമിയോടുകൂടെ നശിപ്പിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","നീ ഗോഫർമരംകൊണ്ടു ഒരു പെട്ടകം ഉണ്ടാക്കുക; പെട്ടകത്തിന്നു അറകൾ ഉണ്ടാക്കി, അകത്തും പുറത്തും കീൽ തേക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","അതു ഉണ്ടാക്കേണ്ടതു എങ്ങനെ എന്നാൽ: പെട്ടകത്തിന്റെ നീളം മുന്നൂറു മുഴം; വീതി അമ്പതു മുഴം; ഉയരം മുപ്പതു മുഴം. ");
INSERT INTO mal2015_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","പെട്ടകത്തിന്നു കിളിവാതിൽ ഉണ്ടാക്കേണം; മേൽനിന്നു ഒരു മുഴം താഴെ അതിനെ വെക്കേണം; പെട്ടകത്തിന്റെ വാതിൽ അതിന്റെ വശത്തുവെക്കേണം: താഴത്തെയും രണ്ടാമത്തെയും മൂന്നാമത്തെയും തട്ടായി അതിനെ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ആകാശത്തിൻ കീഴിൽനിന്നു ജീവശ്വാസമുള്ള സർവ്വജഡത്തെയും നശിപ്പിപ്പാൻ ഞാൻ ഭൂമിയിൽ ഒരു ജലപ്രളയം വരുത്തും; ഭൂമിയിലുള്ളതൊക്കെയും നശിച്ചുപോകും. ");
INSERT INTO mal2015_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","നിന്നോടോ ഞാൻ ഒരു നിയമം ചെയ്യും; നീയും നിന്റെ പുത്രന്മാരും ഭാര്യയും പുത്രന്മാരുടെ ഭാര്യമാരും പെട്ടകത്തിൽ കടക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","സകല ജീവികളിൽനിന്നും, സർവ്വജഡത്തിൽനിന്നും തന്നേ, ഈരണ്ടീരണ്ടിനെ നിന്നോടുകൂടെ ജീവരക്ഷെക്കായിട്ടു പെട്ടകത്തിൽ കയറ്റേണം; അവ ആണും പെണ്ണുമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","അതതു തരം പക്ഷികളിൽനിന്നും അതതു തരം മൃഗങ്ങളിൽനിന്നും ഭൂമിയിലെ അതതു തരം ഇഴജാതികളിൽനിന്നൊക്കെയും ഈരണ്ടീരണ്ടു ജീവ രക്ഷെക്കായിട്ടു നിന്റെ അടുക്കൽ വരേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","നീയോ സകലഭക്ഷണസാധനങ്ങളിൽനിന്നും വേണ്ടുന്നതു എടുത്തു സംഗ്രഹിച്ചുകൊള്ളേണം; അതു നിനക്കും അവെക്കും ആഹാരമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ദൈവം തന്നോടു കല്പിച്ചതൊക്കെയും നോഹ ചെയ്തു; അങ്ങനെ തന്നേ അവൻ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","അനന്തരം യഹോവ നോഹയോടു കല്പിച്ചതെന്തെന്നാൽ: നീയും സർവ്വകുടുംബവുമായി പെട്ടകത്തിൽ കടക്ക; ഞാൻ നിന്നെ ഈ തലമുറയിൽ എന്റെ മുമ്പാകെ നീതിമാനായി കണ്ടിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ശുദ്ധിയുള്ള സകലമൃഗങ്ങളിൽനിന്നും ആണും പെണ്ണുമായി ഏഴേഴും, ശുദ്ധിയില്ലാത്ത മൃഗങ്ങളിൽനിന്നു ആണും പെണ്ണുമായി ഈരണ്ടും, ");
INSERT INTO mal2015_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ആകാശത്തിലെ പറവകളിൽനിന്നു പൂവനും പിടയുമായി ഏഴേഴും, ഭൂമിയിലൊക്കെയും സന്തതി ശേഷിച്ചിരിക്കേണ്ടതിന്നു നീ ചേർത്തുകൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ഇനി ഏഴുദിവസം കഴിഞ്ഞിട്ടു ഞാൻ ഭൂമിയിൽ നാല്പതു രാവും നാല്പതു പകലും മഴ പെയ്യിക്കും; ഞാൻ ഉണ്ടാക്കീട്ടുള്ള സകല ജീവജാലങ്ങളെയും ഭൂമിയിൽനിന്നു നശിപ്പിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","യഹോവ തന്നോടു കല്പിച്ചപ്രകാരമൊക്കെയും നോഹ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ഭൂമിയിൽ ജലപ്രളയം ഉണ്ടായപ്പോൾ നോഹെക്കു അറുനൂറു വയസ്സായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","നോഹയും പുത്രന്മാരും അവന്റെ ഭാര്യയും പുത്രന്മാരുടെ ഭാര്യമാരും ജലപ്രളയം നിമിത്തം പെട്ടകത്തിൽ കടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ശുദ്ധിയുള്ള മൃഗങ്ങളിൽ നിന്നും ശുദ്ധിയില്ലാത്ത മൃഗങ്ങളിൽനിന്നും പറവകളിൽനിന്നും ഭൂമിയിലുള്ള ഇഴജാതിയിൽനിന്നൊക്കെയും, ");
INSERT INTO mal2015_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ദൈവം നോഹയോടു കല്പിച്ചപ്രകാരം ഈരണ്ടീരണ്ടു ആണും പെണ്ണുമായി നോഹയുടെ അടുക്കൽ വന്നു പെട്ടകത്തിൽ കടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ഏഴു ദിവസം കഴിഞ്ഞശേഷം ഭൂമിയിൽ ജലപ്രളയം തുടങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","നോഹയുടെ ആയുസ്സിന്റെ അറുനൂറാം സംവത്സരത്തിൽ രണ്ടാം മാസം പതിനേഴാം തിയ്യതി, അന്നുതന്നേ ആഴിയുടെ ഉറവുകൾ ഒക്കെയും പിളർന്നു; ആകാശത്തിന്റെ കിളിവാതിലുകളും തുറന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","നാല്പതു രാവും നാല്പതു പകലും ഭൂമിയിൽ മഴ പെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","അന്നുതന്നേ നോഹയും നോഹയുടെ പുത്രന്മാരായ ശേമും ഹാമും യാഫേത്തും നോഹയുടെ ഭാര്യയും അവന്റെ പുത്രന്മാരുടെ മൂന്നു ഭാര്യമാരും പെട്ടകത്തിൽ കടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","അവരും അതതു തരം കാട്ടുമൃഗങ്ങളും അതതു തരം കന്നുകാലികളും നിലത്തു ഇഴയുന്ന അതതു തരം ഇഴജാതിയും അതതു തരം പറവകളും അതതു തരം പക്ഷികളും തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ജീവശ്വാസമുള്ള സർവ്വജഡത്തിൽനിന്നും ഈരണ്ടീരണ്ടു നോഹയുടെ അടുക്കൽ വന്നു പെട്ടകത്തിൽ കടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ദൈവം അവനോടു കല്പിച്ചതുപോലെ അകത്തു കടന്നവ സർവ്വജഡത്തിൽനിന്നും ആണും പെണ്ണുമായി കടന്നു; യഹോവ വാതിൽ അടെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ഭൂമിയിൽ നാല്പതു ദിവസം ജലപ്രളയം ഉണ്ടായി, വെള്ളം വർദ്ധിച്ചു പെട്ടകം പൊങ്ങി, നിലത്തുനിന്നു ഉയർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","വെള്ളം പൊങ്ങി ഭൂമിയിൽ ഏറ്റവും പെരുകി; പെട്ടകം വെള്ളത്തിൽ ഒഴുകിത്തുടങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","വെള്ളം ഭൂമിയിൽ അത്യധികം പൊങ്ങി, ആകാശത്തിൻ കീഴെങ്ങുമുള്ള ഉയർന്ന പർവ്വതങ്ങളൊക്കെയും മൂടിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","പർവ്വതങ്ങൾ മൂടുവാൻ തക്കവണ്ണം വെള്ളം പതിനഞ്ചു മുഴം അവെക്കു മീതെ പൊങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","പറവകളും കന്നുകാലികളും കാട്ടുമൃഗങ്ങളും നിലത്തു ഇഴയുന്ന എല്ലാ ഇഴജാതിയുമായി ഭൂചരജഡമൊക്കെയും സകലമനുഷ്യരും ചത്തുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","കരയിലുള്ള സകലത്തിലും മൂക്കിൽ ജീവശ്വാസമുള്ളതൊക്കെയും ചത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ഭൂമിയിൽ മനുഷ്യനും മൃഗങ്ങളും ഇഴജാതിയും ആകാശത്തിലെ പറവകളുമായി ഭൂമിയിൽ ഉണ്ടായിരുന്ന സകലജീവജാലങ്ങളും നശിച്ചുപോയി; അവ ഭൂമിയിൽനിന്നു നശിച്ചുപോയി; നോഹയും അവനോടുകൂടെ പെട്ടകത്തിൽ ഉണ്ടായിരുന്നവരും മാത്രം ശേഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","വെള്ളം ഭൂമിയിൽ നൂറ്റമ്പതു ദിവസം പൊങ്ങിക്കൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ദൈവം നോഹയെയും അവനോടുകൂടെ പെട്ടകത്തിൽ ഉള്ള സകല ജീവികളെയും സകലമൃഗങ്ങളെയും ഓർത്തു; ദൈവം ഭൂമിമേൽ ഒരു കാറ്റു അടിപ്പിച്ചു; വെള്ളം നിലെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ആഴിയുടെ ഉറവുകളും ആകാശത്തിന്റെ കിളിവാതിലുകളും അടഞ്ഞു; ആകാശത്തുനിന്നുള്ള മഴയും നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","വെള്ളം ഇടവിടാതെ ഭൂമിയിൽനിന്നു ഇറങ്ങിക്കൊണ്ടിരുന്നു; നൂറ്റമ്പതു ദിവസം കഴിഞ്ഞശേഷം വെള്ളം കുറഞ്ഞു തുടങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ഏഴാം മാസം പതിനേഴാം തിയ്യതി പെട്ടകം അരരാത്ത് പർവ്വതത്തിൽ ഉറെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","പത്താം മാസം വരെ വെള്ളം ഇടവിടാതെ കുറഞ്ഞു; പത്താം മാസം ഒന്നാം തിയ്യതി പർവ്വതശിഖരങ്ങൾ കാണായി. ");
INSERT INTO mal2015_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","നാല്പതു ദിവസം കഴിഞ്ഞശേഷം നോഹ താൻ പെട്ടകത്തിന്നു ഉണ്ടാക്കിയിരുന്ന കിളിവാതിൽ തുറന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","അവൻ ഒരു മലങ്കാക്കയെ പുറത്തു വിട്ടു; അതു പുറപ്പെട്ടു ഭൂമിയിൽ വെള്ളം വറ്റിപ്പോയതു വരെ പോയും വന്നും കൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ഭൂമിയിൽ വെള്ളം കുറഞ്ഞുവോ എന്നു അറിയേണ്ടതിന്നു അവൻ ഒരു പ്രാവിനെയും തന്റെ അടുക്കൽനിന്നു പുറത്തു വിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","എന്നാൽ സർവ്വഭൂമിയിലും വെള്ളം കിടക്കകൊണ്ടു പ്രാവു കാൽ വെപ്പാൻ സ്ഥലം കാണാതെ അവന്റെ അടുക്കൽ പെട്ടകത്തിലേക്കു മടങ്ങിവന്നു; അവൻ കൈനീട്ടി അതിനെ പിടിച്ചു തന്റെ അടുക്കൽ പെട്ടകത്തിൽ ആക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ഏഴു ദിവസം കഴിഞ്ഞിട്ടു അവൻ വീണ്ടും ആ പ്രാവിനെ പെട്ടകത്തിൽ നിന്നു പുറത്തു വിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","പ്രാവു വൈകുന്നേരത്തു അവന്റെ അടുക്കൽ വന്നു; അതിന്റെ വായിൽ അതാ, ഒരു പച്ച ഒലിവില; അതിനാൽ ഭൂമിയിൽ വെള്ളം കുറഞ്ഞു എന്നു നോഹ അറിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","പിന്നെയും ഏഴു ദിവസം കഴിഞ്ഞിട്ടു അവൻ ആ പ്രാവിനെ പുറത്തു വിട്ടു; അതു പിന്നെ അവന്റെ അടുക്കൽ മടങ്ങി വന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ആറുനൂറ്റൊന്നാം സംവത്സരം ഒന്നാം മാസം ഒന്നാം തിയ്യതി ഭൂമിയിൽ വെള്ളം വറ്റിപ്പോയിരുന്നു; നോഹ പെട്ടകത്തിന്റെ മേല്ത്തട്ടു നീക്കി, ഭൂതലം ഉണങ്ങിയിരിക്കുന്നു എന്നു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","രണ്ടാം മാസം ഇരുപത്തേഴാം തിയ്യതി ഭൂമി ഉണങ്ങിയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ദൈവം നോഹയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","നീയും നിന്റെ ഭാര്യയും പുത്രന്മാരും പുത്രന്മാരുടെ ഭാര്യമാരും പെട്ടകത്തിൽനിന്നു പുറത്തിറങ്ങുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","പറവകളും മൃഗങ്ങളും നിലത്തു ഇഴയുന്ന ഇഴജാതിയുമായ സർവ്വജഡത്തിൽനിന്നും നിന്നോടുകൂടെ ഇരിക്കുന്ന സകല ജീവികളെയും പുറത്തു കൊണ്ടുവരിക; അവ ഭൂമിയിൽ അനവധിയായി വർദ്ധിക്കയും പെറ്റു പെരുകുകയും ചെയ്യട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","അങ്ങനെ നോഹയും അവന്റെ പുത്രന്മാരും ഭാര്യയും പുത്രന്മാരുടെ ഭാര്യമാരും പുറത്തിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","സകലമൃഗങ്ങളും ഇഴജാതികൾ ഒക്കെയും എല്ലാ പറവകളും ഭൂചരങ്ങളൊക്കെയും ജാതിജാതിയായി പെട്ടകത്തിൽനിന്നു ഇറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","നോഹ യഹോവെക്കു ഒരു യാഗപീഠം പണിതു, ശുദ്ധിയുള്ള സകല മൃഗങ്ങളിലും ശുദ്ധിയുള്ള എല്ലാപറവകളിലും ചിലതു എടുത്തു യാഗപീഠത്തിന്മേൽ ഹോമയാഗം അർപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","യഹോവ സൗരഭ്യവാസന മണത്തപ്പോൾ യഹോവ തന്റെ ഹൃദയത്തിൽ അരുളിച്ചെയ്തതു: ഞാൻ മനുഷ്യന്റെ നിമിത്തം ഇനി ഭൂമിയെ ശപിക്കയില്ല; മനുഷ്യന്റെ മനോനിരൂപണം ബാല്യം മുതൽ ദോഷമുള്ളതു ആകുന്നു; ഞാൻ ചെയ്തതുപോലെ സകലജീവികളെയും ഇനി നശിപ്പിക്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ഭൂമിയുള്ള കാലത്തോളം വിതയും കൊയിത്തും, ശീതവും ഉഷ്ണവും, വേനലും വർഷവും, രാവും പകലും നിന്നുപോകയുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ദൈവം നോഹയെയും അവന്റെ പുത്രന്മാരെയും അനുഗ്രഹിച്ചു അവരോടു അരുളിച്ചെയ്തതെന്തന്നാൽ: നിങ്ങൾ സന്താനപുഷ്ടിയുള്ളവരായി പെരുകി ഭൂമിയിൽ നിറവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","നിങ്ങളെയുള്ള പേടിയും നടുക്കവും ഭൂമിയിലെ സകലമൃഗങ്ങൾക്കും ആകാശത്തിലെ എല്ലാപറവകൾക്കും സകല ഭൂചരങ്ങൾക്കും സമുദ്രത്തിലെ സകലമത്സ്യങ്ങൾക്കും ഉണ്ടാകും; അവയെ നിങ്ങളുടെ കയ്യിൽ ഏല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ഭൂചരജന്തുക്കളൊക്കെയും നിങ്ങൾക്കു ആഹാരം ആയിരിക്കട്ടെ; പച്ചസസ്യംപോലെ ഞാൻ സകലവും നിങ്ങൾക്കു തന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","പ്രാണനായിരിക്കുന്ന രക്തത്തോടുകൂടെ മാത്രം നിങ്ങൾ മാംസം തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","നിങ്ങളുടെ പ്രാണനായിരിക്കുന്ന നിങ്ങളുടെ രക്തത്തിന്നു ഞാൻ പകരം ചോദിക്കും; സകലമൃഗത്തോടും മനുഷ്യനോടും ചോദിക്കും; അവനവന്റെ സഹോദരനോടും ഞാൻ മനുഷ്യന്റെ പ്രാണന്നു പകരം ചോദിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ആരെങ്കിലും മനുഷ്യന്റെ രക്തം ചൊരിയിച്ചാൽ അവന്റെ രക്തം മനുഷ്യൻ ചൊരിയിക്കും; ദൈവത്തിന്റെ സ്വരൂപത്തിലല്ലോ മനുഷ്യനെ ഉണ്ടാക്കിയതു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ആകയാൽ നിങ്ങൾ സന്താനപുഷ്ടിയുള്ളവരായി പെരുകുവിൻ; ഭൂമിയിൽ അനവധിയായി പെറ്റു പെരുകുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ദൈവം പിന്നെയും നോഹയോടും അവന്റെ പുത്രന്മാരോടും അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","ഞാൻ, ഇതാ, നിങ്ങളോടും നിങ്ങളുടെ സന്തതിയോടും ");
INSERT INTO mal2015_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ഭൂമിയിൽ നിങ്ങളോടുകൂടെ ഉള്ള പക്ഷികളും കന്നുകാലികളും കാട്ടുമൃഗങ്ങളുമായ സകലജീവജന്തുക്കളോടും പെട്ടകത്തിൽനിന്നു പുറപ്പെട്ട സകലവുമായി ഭൂമിയിലെ സകലമൃഗങ്ങളോടും ഒരു നിയമം ചെയ്യുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ഇനി സകലജഡവും ജലപ്രളയത്താൽ നശിക്കയില്ല; ഭൂമിയെ നശിപ്പിപ്പാൻ ഇനി ജലപ്രളയം ഉണ്ടാകയുമില്ല എന്നു ഞാൻ നിങ്ങളോടു ഒരു നിയമം ചെയ്യുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","പിന്നെയും ദൈവം അരുളിച്ചെയ്തതു: ഞാനും നിങ്ങളും നിങ്ങളോടുകൂടെ ഉള്ള സകലജീവജന്തുക്കളും തമ്മിൽ തലമുറതലമുറയോളം സദാകാലത്തേക്കും ചെയ്യുന്ന നിയമത്തിന്റെ അടയാളം ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ഞാൻ എന്റെ വില്ലു മേഘത്തിൽ വെക്കുന്നു; അതു ഞാനും ഭൂമിയും തമ്മിലുള്ള നിയമത്തിന്നു അടയാളമായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ഞാൻ ഭൂമിയുടെ മീതെ മേഘം വരുത്തുമ്പോൾ മേഘത്തിൽ വില്ലു കാണും. ");
INSERT INTO mal2015_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","അപ്പോൾ ഞാനും നിങ്ങളും സർവ്വജഡവുമായ സകലജീവജന്തുക്കളും തമ്മിലുള്ള എന്റെ നിയമം ഞാൻ ഓർക്കും; ഇനി സകലജഡത്തെയും നശിപ്പിപ്പാൻ വെള്ളം ഒരു പ്രളയമായി തീരുകയുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","വില്ലു മേഘത്തിൽ ഉണ്ടാകും; ദൈവവും ഭൂമിയിലെ സർവ്വജഡവുമായ സകലജീവികളും തമ്മിൽ എന്നേക്കുമുള്ള നിയമം ഓർക്കേണ്ടതിന്നു ഞാൻ അതിനെ നോക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ഞാൻ ഭൂമിയിലുള്ള സർവ്വ ജഡത്തോടും ചെയ്തിരിക്കുന്ന നിയമത്തിന്നു ഇതു അടയാളം എന്നും ദൈവം നോഹയോടു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","പെട്ടകത്തിൽനിന്നു പുറപ്പെട്ടവരായ നോഹയുടെ പുത്രന്മാർ ശേമും ഹാമും യാഫെത്തും ആയിരുന്നു; ഹാം എന്നവനോ കനാന്റെ പിതാവു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ഇവർ മൂവരും നോഹയുടെ പുത്രന്മാർ; അവരെക്കൊണ്ടു ഭൂമി ഒക്കെയും നിറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","നോഹ കൃഷിചെയ്‌വാൻ തുടങ്ങി; ഒരു മുന്തിരിത്തോട്ടം നട്ടുണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","അവൻ അതിലെ വീഞ്ഞുകുടിച്ചു ലഹരിപിടിച്ചു തന്റെ കൂടാരത്തിൽ വസ്ത്രം നീങ്ങി കിടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","കനാന്റെ പിതാവായ ഹാം പിതാവിന്റെ നഗ്നത കണ്ടു വെളിയിൽ ചെന്നു തന്റെ രണ്ടു സഹോദരന്മാരെയും അറിയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ശേമും യാഫെത്തും ഒരു വസ്ത്രം എടുത്തു, ഇരുവരുടെയും തോളിൽ ഇട്ടു വിമുഖരായി ചെന്നു പിതാവിന്റെ നഗ്നത മറെച്ചു; അവരുടെ മുഖം തിരിഞ്ഞിരുന്നതുകൊണ്ടു അവർ പിതാവിന്റെ നഗ്നത കണ്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","നോഹ ലഹരിവിട്ടുണർന്നപ്പോൾ തന്റെ ഇളയമകൻ ചെയ്തതു അറിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","അപ്പോൾ അവൻ: കനാൻ ശപിക്കപ്പെട്ടവൻ; അവൻ തന്റെ സഹോദരന്മാർക്കു അധമദാസനായ്തീരും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ശേമിന്റെ ദൈവമായ യഹോവ സ്തുതിക്കപ്പെട്ടവൻ; കനാൻ അവരുടെ ദാസനാകും. ");
INSERT INTO mal2015_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ദൈവം യാഫെത്തിനെ വർദ്ധിപ്പിക്കട്ടെ; അവൻ ശേമിന്റെ കൂടാരങ്ങളിൽ വസിക്കും; കനാൻ അവരുടെ ദാസനാകും എന്നും അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ജലപ്രളയത്തിന്റെ ശേഷം നോഹ മുന്നൂറ്റമ്പതു സംവത്സരം ജീവിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","നോഹയുടെ ആയുഷ്കാലം ആകെ തൊള്ളായിരത്തമ്പതു സംവത്സരമായിരുന്നു; പിന്നെ അവൻ മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","നോഹയുടെ പുത്രന്മാരായ ശേം, ഹാം, യാഫെത്ത് എന്നവരുടെ വംശപാരമ്പര്യമാവിതു: ജലപ്രളയത്തിന്റെ ശേഷം അവർക്കു പുത്രന്മാർ ജനിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","യാഫെത്തിന്റെ പുത്രന്മാർ: ഗോമെർ, മാഗോഗ്, മാദായി, യാവാൻ, തൂബൽ, മേശെക്, തീരാസ്. ");
INSERT INTO mal2015_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ഗോമെരിന്റെ പുത്രന്മാർ: അസ്കെനാസ്, രീഫത്ത്, തോഗർമ്മാ. ");
INSERT INTO mal2015_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","യാവാന്റെ പുത്രന്മാർ: എലീശാ, തർശീശ്, കിത്തീം, ദോദാനീം. ");
INSERT INTO mal2015_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ഇവരാൽ ജാതികളുടെ ദ്വീപുകൾ അതതു ദേശത്തിൽ ഭാഷഭാഷയായും ജാതിജാതിയായും കുലംകുലമായും പിരിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ഹാമിന്റെ പുത്രന്മാർ: കൂശ്, മിസ്രയീം, പൂത്ത്, കനാൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","കൂശിന്റെ പുത്രന്മാർ: സെബാ, ഹവീലാ, സബ്താ, രമാ, സബ്തെക്കാ; രമയുടെ പുത്രന്മാർ: ശെബയും ദെദാനും. ");
INSERT INTO mal2015_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","കൂശ് നിമ്രോദിനെ ജനിപ്പിച്ചു; അവൻ ഭൂമിയിൽ ആദ്യവീരനായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","അവൻ യഹോവയുടെ മുമ്പാകെ നായാട്ടു വീരനായിരുന്നു; അതുകൊണ്ടു: യഹോവയുടെ മുമ്പാകെ നിമ്രോദിനെപ്പോലെ നായാട്ടുവീരൻ എന്നു പഴഞ്ചൊല്ലായി. ");
INSERT INTO mal2015_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","അവന്റെ രാജ്യത്തിന്റെ ആരംഭം ശിനാർദേശത്തു ബാബേൽ, ഏരെക്ക്, അക്കാദ്, കൽനേ എന്നിവ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ആ ദേശത്തനിന്നു അശ്ശൂർ പുറപ്പെട്ടു നീനവേ, രെഹോബൊത്ത് പട്ടണം, കാലഹ്, ");
INSERT INTO mal2015_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","നീനവേക്കും കാലഹിന്നും മദ്ധ്യേ മഹാനഗരമായ രേസെൻ എന്നിവ പണിതു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","മിസ്രയീമോ; ലൂദീം, അനാമീം, ലെഹാബീം, നഫ്തൂഹീം, ");
INSERT INTO mal2015_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","പത്രൂസീം, കസ്ളൂഹീം ‒ ഇവരിൽനിന്നു ഫെലിസ്ത്യർ ഉത്ഭവിച്ചു ‒ കഫ്തോരീം എന്നിവരെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","കനാൻ തന്റെ ആദ്യജാതനായ സീദോൻ, ഹേത്ത്, ");
INSERT INTO mal2015_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","യെബൂസ്യൻ, അമോര്യൻ, ");
INSERT INTO mal2015_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ഗിർഗ്ഗശ്യൻ, ഹിവ്യൻ, അർക്ക്യൻ, സീന്യൻ, ");
INSERT INTO mal2015_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","അർവ്വാദ്യൻ, സെമാര്യൻ, ഹമാത്യൻ എന്നിവരെ ജനിപ്പിച്ചു. പിന്നീടു കനാന്യവംശങ്ങൾ പരന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","കനാന്യരുടെ അതിർ സീദോൻ തുടങ്ങി ഗെരാർ വഴിയായി ഗസ്സാവരെയും സൊദോമും ഗൊമോരയും ആദ്മയും സെബോയീമും വഴിയായി ലാശവരെയും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ഇവർ അതതു ദേശത്തിൽ ജാതിജാതിയായും കുലംകുലമായും ഭാഷഭാഷയായും ഹാമിന്റെ പുത്രന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ഏബെരിന്റെ പുത്രന്മാർക്കൊക്കെയും പിതാവും യാഫെത്തിന്റെ ജ്യേഷ്ഠനുമായ ശേമിന്നും പുത്രന്മാർ ജനിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ശേമിന്റെ പുത്രന്മാർ: ഏലാം, അശ്ശൂർ, അർപ്പക്ഷാദ്, ലൂദ്, അരാം. ");
INSERT INTO mal2015_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","അരാമിന്റെ പുത്രന്മാർ: ഊസ്, ഹൂൾ, ഗേഥെർ, മശ്. ");
INSERT INTO mal2015_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","അർപ്പക്ഷാദ് ശാലഹിനെ ജനിപ്പിച്ചു; ശാലഹ് ഏബെരിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ഏബെരിന്നു രണ്ടു പുത്രന്മാർ ജനിച്ചു; ഒരുത്തന്നു പേലെഗ് എന്നു പേർ; അവന്റെ കാലത്തായിരുന്നു ഭൂവാസികൾ പിരിഞ്ഞുപോയതു; അവന്റെ സഹോദരന്നു യൊക്താൻ എന്നു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","യൊക്താനോ: അല്മോദാദ്, ");
INSERT INTO mal2015_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ശാലെഫ്, ഹസർമ്മാവെത്ത്, യാരഹ്, ഹദോരാം, ");
INSERT INTO mal2015_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ഊസാൽ, ദിക്ലാ, ഓബാൽ, അബീമയേൽ, ");
INSERT INTO mal2015_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ശെബാ, ഓഫീർ, ഹവീലാ, യോബാബ് എന്നിവരെ ജനിപ്പിച്ചു; ഇവർ എല്ലാവരും യൊക്താന്റെ പുത്രന്മാർ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","അവരുടെ വാസസ്ഥലം മേശാതുടങ്ങി കിഴക്കൻമലയായ സെഫാർവരെ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ഇവർ അതതു ദേശത്തിൽ ജാതിജാതിയായും കുലംകുലമായും ഭാഷഭാഷയായും ശേമിന്റെ പുത്രന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ഇവർ തന്നേ ജാതിജാതിയായും കുലംകുലമായും നോഹയുടെ പുത്രന്മാരുടെ വംശങ്ങൾ. അവരിൽനിന്നാകുന്നു ജലപ്രളയത്തിന്റെശേഷം ഭൂമിയിൽ ജാതികൾ പിരിഞ്ഞുപോയതു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ഭൂമിയിൽ ഒക്കെയും ഒരേ ഭാഷയും ഒരേ വാക്കും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","എന്നാൽ അവർ കിഴക്കോട്ടു യാത്ര ചെയ്തു, ശിനാർദേശത്തു ഒരു സമഭൂമി കണ്ടു അവിടെ കുടിയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","അവർ തമ്മിൽ: വരുവിൻ, നാം ഇഷ്ടക അറുത്തു ചുടുക എന്നു പറഞ്ഞു. അങ്ങനെ അവർ ഇഷ്ടക കല്ലായും പശമണ്ണു കുമ്മായമായും ഉപയോഗിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","വരുവിൻ; നാം ഭൂതലത്തിൽ ഒക്കെയും ചിതറിപ്പോകാതിരിപ്പാൻ ഒരു പട്ടണവും ആകാശത്തോളം എത്തുന്ന ഒരു ഗോപുരവും പണിക; നമുക്കു ഒരു പേരുമുണ്ടാക്കുക എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","മനുഷ്യർ പണിത പട്ടണവും ഗോപുരവും കാണേണ്ടതിന്നു യഹോവ ഇറങ്ങിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","അപ്പോൾ യഹോവ: ഇതാ, ജനം ഒന്നു, അവർക്കെല്ലാവർക്കും ഭാഷയും ഒന്നു; ഇതും അവർ ചെയ്തു തുടങ്ങുന്നു; അവർ ചെയ്‌വാൻ നിരൂപിക്കുന്നതൊന്നും അവർക്കു അസാദ്ധ്യമാകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","വരുവിൻ; നാം ഇറങ്ങിച്ചെന്നു, അവർ തമ്മിൽ ഭാഷ തിരിച്ചറിയാതിരിപ്പാൻ അവരുടെ ഭാഷ കലക്കിക്കളക എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","അങ്ങനെ യഹോവ അവരെ അവിടെനിന്നു ഭൂതലത്തിലെങ്ങും ചിന്നിച്ചു; അവർ പട്ടണം പണിയുന്നതു വിട്ടുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","സർവ്വഭൂമിയിലെയും ഭാഷ യഹോവ അവിടെവെച്ചു കലക്കിക്കളകയാൽ അതിന്നു ബാബേൽ എന്നു പേരായി; യഹോവ അവരെ അവിടെനിന്നു ഭൂതലത്തിൽ എങ്ങും ചിന്നിച്ചുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ശേമിന്റെ വംശപാരമ്പര്യമാവിതു: ശേമിന്നു നൂറു വയസ്സായപ്പോൾ അവൻ ജലപ്രളയത്തിന്നു പിമ്പു രണ്ടു സംവത്സരം കഴിഞ്ഞശേഷം അർപ്പക്ഷാദിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","അർപ്പക്ഷാദിനെ ജനിപ്പിച്ചശേഷം ശേം അഞ്ഞൂറു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","അർപ്പക്ഷാദിന്നു മുപ്പത്തഞ്ചു വയസ്സായപ്പോൾ അവൻ ശാലഹിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ശാലഹിനെ ജനിപ്പിച്ചശേഷം അർപ്പക്ഷാദ് നാനൂറ്റിമൂന്നു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ശാലഹിന്നു മുപ്പതു വയസ്സായപ്പോൾ അവൻ ഏബെരിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ഏബെരിനെ ജനിപ്പിച്ചശേഷം ശാലഹ് നാനൂറ്റി മൂന്നു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ഏബെരിന്നു മുപ്പത്തിനാലു വയസ്സായപ്പോൾ അവൻ പേലെഗിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","പേലെഗിനെ ജനിപ്പിച്ചശേഷം ഏബെർ നാനൂറ്റിമുപ്പതു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","പേലെഗിന്നു മുപ്പതു വയ്സായപ്പോൾ അവൻ രെയൂവിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","രെയൂവിനെ ജനിപ്പിച്ചശേഷം പേലെഗ് ഇരൂനൂറ്റൊമ്പതു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","രെയൂവിന്നു മുപ്പത്തിരണ്ടു വയസ്സായപ്പോൾ അവൻ ശെരൂഗിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ശെരൂഗിനെ ജനിപ്പിച്ചശേഷം രെയൂ ഇരുനൂറ്റേഴു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ശെരൂഗിന്നു മുപ്പതു വയസ്സായപ്പോൾ അവൻ നാഹോരിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","നാഹോരിനെ ജനിപ്പിച്ചശേഷം ശെരൂഗ് ഇരുനൂറു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","നാഹോരിന്നു ഇരുപത്തൊമ്പതു വയസ്സായപ്പോൾ അവൻ തേരഹിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","തേരഹിനെ ജനിപ്പിച്ചശേഷം നാഹോർ നൂറ്റി പത്തൊമ്പതു സംവത്സരം ജീവിച്ചിരുന്നു പുത്രന്മാരെയും പുത്രിമാരെയും ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","തേരഹിന്നു എഴുപതു വയസ്സായപ്പോൾ അവൻ അബ്രാം, നാഹോർ, ഹാരാൻ എന്നിവരെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","തേരഹിന്റെ വംശപാരമ്പര്യമാവിതു: തേരഹ് അബ്രാമിനെയും നാഹോരിനെയും ഹാരാനെയും ജനിപ്പിച്ചു; ഹാരാൻ ലോത്തിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","എന്നാൽ ഹാരാൻ തന്റെ ജന്മദേശത്തുവെച്ചു, കൽദയരുടെ ഒരു പട്ടണമായ ഊരിൽവെച്ചു തന്നേ, തന്റെ അപ്പനായ തേരഹിന്നു മുമ്പെ മരിച്ചുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","അബ്രാമും നാഹോരും ഭാര്യമാരെ എടുത്തു; അബ്രാമിന്റെ ഭാര്യക്കു സാറായി എന്നും നാഹോരിന്റെ ഭാര്യക്കു മിൽക്കാ എന്നും പേർ. ഇവൾ മിൽക്കയുടെയും യിസ്കയുടെയും അപ്പനായ ഹാരാന്റെ മകൾ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","സാറായി മച്ചിയായിരുന്നു; അവൾക്കു സന്തതി ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","തേരഹ് തന്റെ മകനായ അബ്രാമിനെയും ഹാരാന്റെ മകനായ തന്റെ പൗത്രൻ ലോത്തിനെയും തന്റെ മകനായ അബ്രാമിന്റെ ഭാര്യയായി മരുമകളായ സാറായിയെയും കൂട്ടി കൽദയരുടെ പട്ടണമായ ഊരിൽനിന്നു കനാൻദേശത്തേക്കു പോകുവാൻ പുറപ്പെട്ടു; അവർ ഹാരാൻ വരെ വന്നു അവിടെ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","തേരഹിന്റെ ആയുഷ്കാലം ഇരുനൂറ്റഞ്ചു സംവത്സരം ആയിരുന്നു; തേരഹ് ഹാരാനിൽവെച്ചു മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","യഹോവ അബ്രാമിനോടു അരുളിച്ചെയ്തതെന്തെന്നാൽ: നീ നിന്റെ ദേശത്തെയും ചാർച്ചക്കാരെയും പിതൃഭവനത്തെയും വിട്ടു പുറപ്പെട്ടു ഞാൻ നിന്നെ കാണിപ്പാനിരിക്കുന്ന ദേശത്തെക്കു പോക. ");
INSERT INTO mal2015_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ഞാൻ നിന്നെ വലിയോരു ജാതിയാക്കും; നിന്നെ അനുഗ്രഹിച്ചു നിന്റെ പേർ വലുതാക്കും; നീ ഒരു അനുഗ്രഹമായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","നിന്നെ അനുഗ്രഹിക്കുന്നവരെ ഞാൻ അനുഗ്രഹിക്കും; നിന്നെ ശപിക്കുന്നവരെ ഞാൻ ശപിക്കും; നിന്നിൽ ഭൂമിയിലെ സകലവംശങ്ങളും അനുഗ്രഹിക്കപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","യഹോവ തന്നോടു കല്പിച്ചതുപോലെ അബ്രാം പുറപ്പെട്ടു; ലോത്തും അവനോടുകൂടെ പോയി; ഹാരാനിൽനിന്നു പുറപ്പെടുമ്പോൾ അബ്രാമിന്നു എഴുപത്തഞ്ചു വയസ്സായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","അബ്രാം തന്റെ ഭാര്യയായ സാറായിയെയും സഹോദരന്റെ മകനായ ലോത്തിനെയും തങ്ങൾ ഉണ്ടാക്കിയ സമ്പത്തുകളെയൊക്കെയും തങ്ങൾ ഹാരാനിൽ വെച്ചു സമ്പാദിച്ച ആളുകളെയും കൂട്ടിക്കൊണ്ടു കനാൻദേശത്തേക്കു പോകുവാൻ പുറപ്പെട്ടു കനാൻദേശത്തു എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","അബ്രാം ശേഖേമെന്ന സ്ഥലംവരെയും ഏലോൻമോരെവരെയും ദേശത്തുകൂടി സഞ്ചരിച്ചു. അന്നു കനാന്യൻ ദേശത്തു പാർത്തിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","യഹോവ അബ്രാമിന്നു പ്രത്യക്ഷനായി: നിന്റെ സന്തതിക്കു ഞാൻ ഈ ദേശം കൊടുക്കുമെന്നു അരുളിച്ചെയ്തു. തനിക്കു പ്രത്യക്ഷനായ യഹോവെക്കു അവൻ അവിടെ ഒരു യാഗപീഠം പണിതു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","അവൻ അവിടെനിന്നു ബേഥേലിന്നു കിഴക്കുള്ള മലെക്കു പുറപ്പെട്ടു; ബേഥേൽ പടിഞ്ഞാറും ഹായി കിഴക്കുമായി കൂടാരം അടിച്ചു; അവിടെ അവൻ യഹോവെക്കു ഒരു യാഗപീഠം പണിതു യഹോവയുടെ നാമത്തിൽ ആരാധിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","അബ്രാം പിന്നെയും തെക്കോട്ടു യാത്രചെയ്തുകൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ദേശത്തു ക്ഷാമം ഉണ്ടായി; ദേശത്തു ക്ഷാമം കഠിനമായി തീർന്നതുകൊണ്ടു അബ്രാം മിസ്രയീമിൽ ചെന്നുപാർപ്പാൻ അവിടേക്കു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","മിസ്രയീമിൽ എത്തുമാറായപ്പോൾ അവൻ തന്റെ ഭാര്യ സാറായിയോടു പറഞ്ഞതു: ഇതാ, നീ സൗന്ദര്യമുള്ള സ്ത്രീയെന്നു ഞാൻ അറിയുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","മിസ്രയീമ്യർ നിന്നെ കാണുമ്പോൾ: ഇവൾ അവന്റെ ഭാര്യയെന്നു പറഞ്ഞു എന്നെകൊല്ലുകയും നിന്നെ ജീവനോടെ രക്ഷിക്കയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","നീ എന്റെ സഹോദരിയെന്നു പറയേണം; എന്നാൽ നിന്റെ നിമിത്തം എനിക്കു നന്മവരികയും ഞാൻ ജീവിച്ചിരിക്കയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","അങ്ങനെ അബ്രാം മിസ്രയീമിൽ എത്തിയപ്പോൾ സ്ത്രീ അതിസുന്ദരി എന്നു മിസ്രയീമ്യർ കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ഫറവോന്റെ പ്രഭുക്കന്മാരും അവളെ കണ്ടു, ഫറവോന്റെ മുമ്പാകെ അവളെ പ്രശംസിച്ചു; സ്ത്രീ ഫറവോന്റെ അരമനയിൽ പോകേണ്ടിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","അവളുടെ നിമിത്തം അവൻ അബ്രാമിന്നു നന്മ ചെയ്തു; അവന്നു ആടുമാടുകളും ആൺകഴുതകളും ദാസന്മാരും ദാസിമാരും പെൺകഴുതകളും ഒട്ടകങ്ങളും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","അബ്രാമിന്റെ ഭാര്യയായ സാറായി നിമിത്തം യഹോവ ഫറവോനെയും അവന്റെ കുടുംബത്തെയും അത്യന്തം ദണ്ഡിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","അപ്പോൾ ഫറവോൻ അബ്രാമിനെ വിളിച്ചു: നീ എന്നോടു ഈ ചെയ്തതു എന്തു? അവൾ നിന്റെ ഭാര്യയെന്നു എന്നെ അറിയിക്കാഞ്ഞതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","അവൾ എന്റെ സഹോദരിയെന്നു എന്തിന്നു പറഞ്ഞു? ഞാൻ അവളെ ഭാര്യയായിട്ടു എടുപ്പാൻ സംഗതി വന്നുപോയല്ലോ; ഇപ്പോൾ ഇതാ, നിന്റെ ഭാര്യ; അവളെ കൂട്ടിക്കൊണ്ടു പോക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ഫറവോൻ അവനെക്കുറിച്ചു തന്റെ ആളുകളോടു കല്പിച്ചു; അവർ അവനെയും അവന്റെ ഭാര്യയെയും അവന്നുള്ള സകലവുമായി പറഞ്ഞയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ഇങ്ങനെ അബ്രാമും ഭാര്യയും അവന്നുള്ളതൊക്കെയും അവനോടുകൂടെ ലോത്തും മിസ്രയീമിൽനിന്നു പുറപ്പെട്ടു തെക്കെ ദേശത്തു വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","കന്നുകാലി, വെള്ളി, പൊന്നു ഈ വകയിൽ അബ്രാം ബഹുസമ്പന്നനായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","അവൻ തന്റെ യാത്രയിൽ തെക്കുനിന്നു ബേഥേൽവരെയും ബേഥേലിന്നും ഹായിക്കും മദ്ധ്യേ തനിക്കു ആദിയിൽ കൂടാരം ഉണ്ടായിരുന്നതും താൻ ആദിയിൽ ഉണ്ടാക്കിയ യാഗപീഠമിരുന്നതുമായ സ്ഥലംവരെയും ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","അവിടെ അബ്രാം യഹോവയുടെ നാമത്തിൽ ആരാധിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","അബ്രാമിനോടുകൂടെവന്ന ലോത്തിന്നും ആടുമാടുകളും കൂടാരങ്ങളും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","അവർ ഒന്നിച്ചുപാർപ്പാൻ തക്കവണ്ണം ദേശത്തിന്നു അവരെ വഹിച്ചു കൂടാഞ്ഞു; സമ്പത്തു വളരെ ഉണ്ടായിരുന്നതുകൊണ്ടു അവർക്കു ഒന്നിച്ചുപാർപ്പാൻ കഴിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","അബ്രാമിന്റെ കന്നുകാലികളുടെ ഇടയന്മാർക്കും ലോത്തിന്റെ കന്നുകാലികളുടെ ഇടയന്മാർക്കും തമ്മിൽ പിണക്കമുണ്ടായി; കനാന്യരും പെരീസ്യരും അന്നു ദേശത്തു പാർത്തിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","അതു കൊണ്ടു അബ്രാം ലോത്തിനോടു: എനിക്കും നിനക്കും എന്റെ ഇടയന്മാർക്കും നിന്റെ ഇടയന്മാർക്കും തമ്മിൽ പിണക്കം ഉണ്ടാകരുതേ; നാം സഹോദരന്മാരല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ദേശമെല്ലാം നിന്റെ മുമ്പാകെ ഇല്ലയോ? എന്നെ വിട്ടുപിരിഞ്ഞാലും. നീ ഇടത്തോട്ടെങ്കിൽ ഞാൻ വലത്തോട്ടു പൊയ്ക്കൊള്ളാം; നീ വലത്തോട്ടെങ്കിൽ ഞാൻ ഇടത്തോട്ടു പൊയ്ക്കൊള്ളാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","അപ്പോൾ ലോത്ത് നോക്കി യോർദ്ദാന്നരികെയുള്ള പ്രദേശം ഒക്കെയും നീരോട്ടമുള്ളതെന്നു കണ്ടു; യഹോവ സൊദോമിനെയും ഗൊമോരയെയും നശിപ്പിച്ചതിന്നു മുമ്പെ അതു യഹോവയുടെ തോട്ടം പോലെയും സോവർ വരെ മിസ്രയീംദേശംപോലെയും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ലോത്ത് യോർദ്ദാന്നരികെയുള്ള പ്രദേശം ഒക്കെയും തിരഞ്ഞെടുത്തു; ഇങ്ങനെ ലോത്ത് കിഴക്കോട്ടു യാത്രയായി; അവർ തമ്മിൽ പിരിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","അബ്രാം കനാൻദേശത്തു പാർത്തു; ലോത്ത് ആ പ്രദേശത്തിലെ പട്ടണങ്ങളിൽ പാർത്തു സൊദോംവരെ കൂടാരം നീക്കി നീക്കി അടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","സൊദോംനിവാസികൾ ദുഷ്ടന്മാരും യഹോവയുടെ മുമ്പാകെ മഹാപാപികളും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ലോത്ത് അബ്രാമിനെ വിട്ടു പിരിഞ്ഞശേഷം യഹോവ അബ്രാമിനോടു അരുളിച്ചെയ്തതു: തലപൊക്കി, നീ ഇരിക്കുന്ന സ്ഥലത്തു നിന്നു വടക്കോട്ടും തെക്കോട്ടും കിഴക്കോട്ടും പടിഞ്ഞാറോട്ടും നോക്കുക. ");
INSERT INTO mal2015_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","നീ കാണുന്ന ഭൂമി ഒക്കെയും ഞാൻ നിനക്കും നിന്റെ സന്തതിക്കും ശാശ്വതമായി തരും. ");
INSERT INTO mal2015_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ഞാൻ നിന്റെ സന്തതിയെ ഭൂമിയിലെ പൊടിപോലെ ആക്കും: ഭൂമിയിലെ പൊടിയെ എണ്ണുവാൻ കഴിയുമെങ്കിൽ നിന്റെ സന്തതിയെയും എണ്ണാം. ");
INSERT INTO mal2015_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","നീ പുറപ്പെട്ടു ദേശത്തു നെടുകെയും കുറുകെയും സഞ്ചരിക്ക; ഞാൻ അതു നിനക്കു തരും. ");
INSERT INTO mal2015_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","അപ്പോൾ അബ്രാം കൂടാരം നീക്കി ഹെബ്രോനിൽ മമ്രേയുടെ തോപ്പിൽ വന്നു പാർത്തു; അവിടെ യഹോവെക്കു ഒരു യാഗപീഠം പണിതു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ശിനാർരാജാവായ അമ്രാഫെൽ, എലാസാർരാജാവായ അര്യോക്, ഏലാംരാജാവായ കെദൊർലായോമെർ, ജാതികളുടെ രാജാവായ തീദാൽ എന്നിവരുടെ കാലത്തു ");
INSERT INTO mal2015_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ഇവർ സൊദോംരാജാവായ ബേരാ, ഗൊമോരാരാജാവായ ബിർശാ, ആദ്മാരാജാവായ ശിനാബ്, സെബോയീംരാജാവായ ശെമേബെർ, സോവർ എന്ന ബേലയിലെ രാജാവു എന്നിവരോടു യുദ്ധം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ഇവരെല്ലാവരും സിദ്ദീംതാഴ്‌വരയിൽ ഒന്നിച്ചുകൂടി. അതു ഇപ്പോൾ ഉപ്പുകടലാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","അവർ പന്ത്രണ്ടു സംവത്സരം കെദൊർലായോമെരിന്നു കീഴടങ്ങിയിരിന്നു; പതിമൂന്നാം സംവത്സരത്തിൽ മത്സരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","അതുകൊണ്ടു പതിനാലാം സംവത്സരത്തിൽ കെദൊർലായോമെരും അവനോടു കൂടെയുള്ള രാജാക്കന്മാരും വന്നു, അസ്തെരോത്ത് കർന്നയീമിലെ രെഫായികളെയും ഹാമിലെ സൂസ്യരെയും ശാവേകിര്യാത്തായീമിലെ ഏമ്യരെയും ");
INSERT INTO mal2015_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","സേയീർമലയിലെ ഹോര്യരെയും മരുഭൂമിക്കു സമീപമുള്ള ഏൽപാരാൻ വരെ തോല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","പിന്നെ അവർ തിരിഞ്ഞു കാദേശ് എന്ന ഏൻമിശ്പാത്തിൽ വന്നു അമാലേക്യരുടെ ദേശമൊക്കെയും ഹസെസോൻ-താമാരിൽ പാർത്തിരുന്ന അമോര്യരെയും കൂടെ തോല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","അപ്പോൾ സൊദോംരാജാവും ഗൊമോരാരാജാവും ആദ്മാരാജാവും സെബോയീംരാജാവും സോവർ എന്ന ബേലയിലെ രാജാവും പുറപ്പെട്ടു സിദ്ദീംതാഴ്‌വരയിൽ വെച്ചു ");
INSERT INTO mal2015_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ഏലാംരാജാവായ കെദൊർലായോമെർ, ജാതികളുടെ രാജാവായ തീദാൽ, ശിനാർരാജാവായ അമ്രാഫെൽ, എലാസാർരാജാവായ അര്യോക്ക് എന്നിവരുടെ നേരെ പട നിരത്തി; നാലു രാജാക്കന്മാർ അഞ്ചു രാജാക്കന്മാരുടെ നേരെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","സിദ്ദീംതാഴ്‌വരയിൽ കീൽകുഴികൾ വളരെയുണ്ടായിരുന്നു; സൊദോംരാജാവും ഗൊമോരാരാജാവും ഓടിപ്പോയി അവിടെ വീണു; ശേഷിച്ചവർ പർവ്വതത്തിലേക്കു ഓടിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","സൊദോമിലും ഗൊമോരയിലും ഉള്ള സമ്പത്തും ഭക്ഷണ സാധനങ്ങളും എല്ലാം അവൻ എടുത്തുകൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","അബ്രാമിന്റെ സഹോദരന്റെ മകനായി സൊദോമിൽ പാർത്തിരുന്ന ലോത്തിനെയും അവന്റെ സമ്പത്തിനെയും അവർ കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ഓടിപ്പോന്ന ഒരുത്തൻ വന്നു എബ്രായനായ അബ്രാമിനെ അറിയിച്ചു. അവൻ എശ്ക്കോലിന്റെയും ആനേരിന്റെയും സഹോദരനായി അമോര്യനായ മമ്രേയുടെ തോപ്പിൽ പാർത്തിരുന്നു; അവർ അബ്രാമിനോടു സഖ്യത ചെയ്തവർ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","തന്റെ സഹോദരനെ ബദ്ധനാക്കി കൊണ്ടുപോയി എന്നു അബ്രാം കേട്ടപ്പോൾ അവൻ തന്റെ വീട്ടിൽ ജനിച്ചവരും അഭ്യാസികളുമായ മുന്നൂറ്റി പതിനെട്ടു പേരെ കൂട്ടിക്കൊണ്ടു ദാൻവരെ പിന്തുടർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","രാത്രിയിൽ അവനും അവന്റെ ദാസന്മാരും അവരുടെ നേരെ ഭാഗംഭാഗമായി പിരിഞ്ഞു ചെന്നു അവരെ തോല്പിച്ചു ദമ്മേശെക്കിന്റെ ഇടത്തുഭാഗത്തുള്ള ഹോബാവരെ അവരെ പിന്തുടർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","അവൻ സമ്പത്തൊക്കെയും മടക്കിക്കൊണ്ടു വന്നു; തന്റെ സഹോദരനായ ലോത്തിനെയും അവന്റെ സമ്പത്തിനെയും സ്ത്രീകളെയും ജനത്തെയും കൂടെ മടക്കിക്കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","അവൻ കെദൊർലായോമെരിനെയും കൂടെയുള്ള രാജാക്കന്മാരെയും തോല്പിച്ചിട്ടു മടങ്ങിവന്നപ്പോൾ സൊദോംരാജാവു രാജതാഴ്‌വര എന്ന ശാവേതാഴ്‌വരവരെ അവനെ എതിരേറ്റുചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ശാലേംരാജാവായ മൽക്കീസേദെക്ക് അപ്പവും വീഞ്ഞുംകൊണ്ടുവന്നു; അവൻ അത്യുന്നതനായ ദൈവത്തിന്റെ പുരോഹിതനായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","അവൻ അവനെ അനുഗ്രഹിച്ചു: സ്വർഗ്ഗത്തിന്നും ഭൂമിക്കും നാഥനായി അത്യുന്നതനായ ദൈവത്താൽ അബ്രാം അനുഗ്രഹിക്കപ്പെടുമാറാകട്ടെ; ");
INSERT INTO mal2015_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","നിന്റെ ശത്രുക്കളെ നിന്റെ കൈയിൽ ഏല്പിച്ച അത്യുന്നതനായ ദൈവം സ്തുതിക്കപ്പെടുമാറാകട്ടെ എന്നു പറഞ്ഞു. അവന്നു അബ്രാം സകലത്തിലും ദശാംശം കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","സൊദോംരാജാവു അബ്രാമിനോടു: ആളുകളെ എനിക്കു തരിക; സമ്പത്തു നീ എടുത്തുകൊൾക എന്നുപറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","അതിന്നു അബ്രാം സൊദോംരാജാവിനോടു പറഞ്ഞതു: ഞാൻ അബ്രാമിനെ സമ്പന്നനാക്കിയെന്നു നീ പറയാതിരിപ്പാൻ ഞാൻ ഒരു ചരടാകട്ടെ ചെരിപ്പുവാറാകട്ടെ നിനക്കുള്ളതിൽ യാതൊന്നുമാകട്ടെ എടുക്കയില്ല എന്നു ഞാൻ ");
INSERT INTO mal2015_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","സ്വർഗ്ഗത്തിന്നും ഭൂമിക്കും നാഥനായി അത്യുന്നതദൈവമായ യഹോവയിങ്കലേക്കു കൈ ഉയർത്തി സത്യം ചെയ്യുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ബാല്യക്കാർ ഭക്ഷിച്ചതും എന്നോടുകൂടെ വന്ന ആനേർ, എശ്ക്കോൽ, മമ്രേ എന്നീ പുരുഷന്മാരുടെ ഓഹരിയും മാത്രമേ വേണ്ടു; ഇവർ തങ്ങളുടെ ഓഹരി എടുത്തുകൊള്ളട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","അതിന്റെ ശേഷം അബ്രാമിന്നു ദർശനത്തിൽ യഹോവയുടെ അരുളപ്പാടു ഉണ്ടായതെന്തെന്നാൽ: അബ്രാമേ, ഭയപ്പെടേണ്ടാ; ഞാൻ നിന്റെ പരിചയും നിന്റെ അതിമഹത്തായ പ്രതിഫലവും ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","അതിന്നു അബ്രാം: കർത്താവായ യഹോവേ, നീ എനിക്കു എന്തു തരും? ഞാൻ മക്കളില്ലാത്തവനായി നടക്കുന്നുവല്ലോ; എന്റെ അവകാശി ദമ്മേശെക്കുകാരനായ ഈ എല്യേസെർ അത്രേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","നീ എനിക്കു സന്തതിയെ തന്നിട്ടില്ല, എന്റെ വീട്ടിൽ ജനിച്ച ദാസൻ എന്റെ അവകാശിയാകുന്നു എന്നും അബ്രാം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","അവൻ നിന്റെ അവകാശിയാകയില്ല; നിന്റെ ഉദരത്തിൽനിന്നു പുറപ്പെടുന്നവൻ തന്നേ നിന്റെ അവകാശിയാകും എന്നു അവന്നു യഹോവയുടെ അരുളപ്പാടുണ്ടായി. ");
INSERT INTO mal2015_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","പിന്നെ അവൻ അവനെ പുറത്തു കൊണ്ടുചെന്നു: നീ ആകാശത്തേക്കു നോക്കുക; നക്ഷത്രങ്ങളെ എണ്ണുവാൻ കഴിയുമെങ്കിൽ എണ്ണുക എന്നു കല്പിച്ചു. നിന്റെ സന്തതി ഇങ്ങനെ ആകും എന്നും അവനോടു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","അവൻ യഹോവയിൽ വിശ്വസിച്ചു; അതു അവൻ അവന്നു നീതിയായി കണക്കിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","പിന്നെ അവനോടു: ഈ ദേശത്തെ നിനക്കു അവകാശമായി തരുവാൻ കൽദയപട്ടണമായ ഊരിൽനിന്നു നിന്നെ കൂട്ടിക്കൊണ്ടുവന്ന യഹോവ ഞാൻ ആകുന്നു എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","കർത്താവായ യഹോവേ, ഞാൻ അതിനെ അവകാശമാക്കുമെന്നുള്ളതു എനിക്കു എന്തൊന്നിനാൽ അറിയാം എന്നു അവൻ ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","അവൻ അവനോടു: നീ മൂന്നു വയസ്സുള്ള ഒരു പശുക്കിടാവിനെയും മൂന്നുവയസ്സുള്ള ഒരു കോലാടിനെയും മൂന്നു വയസ്സുള്ള ഒരു ആട്ടുകൊറ്റനെയും ഒരു കുറുപ്രാവിനെയും ഒരു പ്രാവിൻകുഞ്ഞിനെയും കൊണ്ടുവരിക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ഇവയെയൊക്കെയും അവൻ കൊണ്ടുവന്നു ഒത്തനടുവെപിളർന്നു ഭാഗങ്ങളെ നേർക്കുനേരെ വെച്ചു; പക്ഷികളെയോ അവൻ പിളർന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ഉടലുകളിന്മേൽ റാഞ്ചൻപക്ഷികൾ ഇറങ്ങി വന്നപ്പോൾ അബ്രാം അവയെ ആട്ടിക്കളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","സൂര്യൻ അസ്തമിക്കുമ്പോൾ അബ്രാമിന്നു ഒരു ഗാഢനിദ്ര വന്നു; ഭീതിയും അന്ധതമസ്സും അവന്റെ മേൽ വീണു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","അപ്പോൾ അവൻ അബ്രാമിനോടു: നിന്റെ സന്തതി സ്വന്തമല്ലാത്ത ദേശത്തു നാനൂറു സംവത്സരം പ്രവാസികളായിരുന്നു ആ ദേശക്കാരെ സേവിക്കും; അവർ അവരെ പീഡിപ്പിക്കുമെന്നു നീ അറിഞ്ഞുകൊൾക. ");
INSERT INTO mal2015_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","എന്നാൽ അവർ സേവിക്കുന്ന ജാതിയെ ഞാൻ വിധിക്കും; അതിന്റെ ശേഷം അവർ വളരെ സമ്പത്തോടുംകൂടെ പുറപ്പെട്ടുപോരും. ");
INSERT INTO mal2015_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","നീയോ സമാധാനത്തോടെ നിന്റെ പിതാക്കന്മാരോടു ചേരും; നല്ല വാർദ്ധക്യത്തിൽ അടക്കപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","നാലാം തലമുറക്കാർ ഇവിടേക്കു മടങ്ങിവരും; അമോര്യരുടെ അക്രമം ഇതുവരെ തികഞ്ഞിട്ടില്ല എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","സൂര്യൻ അസ്തമിച്ചു ഇരുട്ടായശേഷം ഇതാ, പുകയുന്ന ഒരു തീച്ചൂള; ആ ഭാഗങ്ങളുടെ നടുവെ ജ്വലിക്കുന്ന ഒരു പന്തം കടന്നുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","അന്നു യഹോവ അബ്രാമിനോടു ഒരു നിയമം ചെയ്തു: നിന്റെ സന്തതിക്കു ഞാൻ മിസ്രയീംനദി തുടങ്ങി ഫ്രാത്ത് നദിയായ മഹാനദിവരെയുള്ള ഈ ദേശത്തെ, ");
INSERT INTO mal2015_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","കേന്യർ, കെനിസ്യർ, കദ്മോന്യർ, ഹിത്യർ, ");
INSERT INTO mal2015_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","പെറിസ്യർ, രെഫായീമ്യർ, അമോര്യർ, ");
INSERT INTO mal2015_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","കനാന്യർ, ഗിർഗ്ഗശ്യർ, യെബൂസ്യർ എന്നിവരുടെ ദേശത്തെ തന്നേ, തന്നിരിക്കുന്നു എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","അബ്രാമിന്റെ ഭാര്യയായ സാറായി മക്കളെ പ്രസവിച്ചിരുന്നില്ല; എന്നാൽ അവൾക്കു ഹാഗാർ എന്നു പേരുള്ള ഒരു മിസ്രയീമ്യദാസി ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","സാറായി അബ്രാമിനോടു: ഞാൻ പ്രസവിക്കാതിരിപ്പാൻ യഹോവ എന്റെ ഗർഭം അടെച്ചിരിക്കുന്നുവല്ലോ. എന്റെ ദാസിയുടെ അടുക്കൽ ചെന്നാലും; പക്ഷേ അവളാൽ എനിക്കു മക്കൾ ലഭിക്കും എന്നു പറഞ്ഞു. അബ്രാം സാറായിയുടെ വാക്കു അനുസരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","അബ്രാം കനാൻദേശത്തു പാർത്തു പത്തു സംവത്സരം കഴിഞ്ഞപ്പോൾ അബ്രാമിന്റെ ഭാര്യയായ സാറായി മിസ്രയീമ്യദാസിയായ ഹാഗാറിനെ തന്റെ ഭർത്താവായ അബ്രാമിന്നു ഭാര്യയായി കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","അവൻ ഹാഗാരിന്റെ അടുക്കൽ ചെന്നു; അവൾ ഗർഭം ധരിച്ചു; താൻ ഗർഭം ധരിച്ചു എന്നു അവൾ കണ്ടപ്പോൾ യജമാനത്തി അവളുടെ കണ്ണിന്നു നിന്ദിതയായി. ");
INSERT INTO mal2015_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","അപ്പോൾ സാറായി അബ്രാമിനോടു: എനിക്കു ഭവിച്ച അന്യായത്തിന്നു നീ ഉത്തരവാദി; ഞാൻ എന്റെ ദാസിയെ നിന്റെ മാർവ്വിടത്തിൽ തന്നു; എന്നാൽ താൻ ഗർഭം ധരിച്ചു എന്നു അവൾ കണ്ടപ്പോൾ ഞാൻ അവളുടെ കണ്ണിന്നു നിന്ദിതയായി; യഹോവ എനിക്കും നിനക്കും മദ്ധ്യേ ന്യായം വിധിക്കട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","അബ്രാം സാറായിയോടു: നിന്റെ ദാസി നിന്റെ കയ്യിൽ ഇരിക്കുന്നു; ഇഷ്ടംപോലെ അവളോടു ചെയ്തുകൊൾക എന്നു പറഞ്ഞു. സാറായി അവളോടു കാഠിന്യം തുടങ്ങിയപ്പോൾ അവൾ അവളെ വിട്ടു ഓടിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","പിന്നെ യഹോവയുടെ ദൂതൻ മരുഭൂമിയിൽ ഒരു നീരുറവിന്റെ അരികെ, ശൂരിന്നു പോകുന്ന വഴിയിലെ നീരുറവിന്റെ അരികെ വെച്ചു തന്നേ, അവളെ കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","സാറായിയുടെ ദാസിയായ ഹാഗാരേ, നീ എവിടെ നിന്നു വരുന്നു? എങ്ങോട്ടു പോകുന്നു എന്നു ചോദിച്ചു. അതിന്നു അവൾ: ഞാൻ എന്റെ യജമാനത്തി സാറായിയെ വിട്ടു ഓടിപ്പോകയാകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","യഹോവയുടെ ദൂതൻ അവളോടു: നിന്റെ യജമാനത്തിയുടെ അടുക്കൽ മടങ്ങിച്ചെന്നു അവൾക്കു കീഴടങ്ങിയിരിക്ക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","യഹോവയുടെ ദൂതൻ പിന്നെയും അവളോടു: ഞാൻ നിന്റെ സന്തതിയെ ഏറ്റവും വർദ്ധിപ്പിക്കും; അതു എണ്ണിക്കൂടാതവണ്ണം പെരുപ്പമുള്ളതായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","നീ ഗർഭിണിയല്ലോ; നീ ഒരു മകനെ പ്രസവിക്കും; യഹോവ നിന്റെ സങ്കടം കേൾക്കകൊണ്ടു അവന്നു യിശ്മായേൽ എന്നു പേർ വിളിക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","അവൻ കാട്ടുകഴുതയെപ്പോലെയുള്ള മനുഷ്യൻ ആയിരിക്കും: അവന്റെ കൈ എല്ലാവർക്കും വിരോധമായും എല്ലാവരുടെയും കൈ അവന്നു വിരോധമായും ഇരിക്കും; അവൻ തന്റെ സകല സഹോദരന്മാർക്കും എതിരെ പാർക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","എന്നാറെ അവൾ: എന്നെ കാണുന്നവനെ ഞാൻ ഇവിടെയും കണ്ടുവോ എന്നു പറഞ്ഞു തന്നോടു അരുളിച്ചെയ്ത യഹോവെക്കു: ദൈവമേ, നീ എന്നെ കാണുന്നു എന്നു പേർ വിളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","അതുകൊണ്ടു ആ കിണറ്റിന്നു ബേർ-ലഹയീ-രോയീ എന്നു പേരായി; അതു കാദേശിന്നും ബേരെദിന്നും മദ്ധ്യേ ഇരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","പിന്നെ ഹാഗാർ അബ്രാമിന്നു ഒരു മകനെ പ്രസവിച്ചു: ഹാഗാർ പ്രസവിച്ച തന്റെ മകന്നു അബ്രാം യിശ്മായേൽ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ഹാഗാർ അബ്രാമിന്നു യിശ്മായേലിനെ പ്രസവിച്ചപ്പോൾ അബ്രാമിന്നു എണ്പത്താറു വയസ്സായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","അബ്രാമിന്നു തൊണ്ണൂറ്റൊമ്പതു വയസ്സായപ്പോൾ യഹോവ അബ്രാമിന്നു പ്രത്യക്ഷനായി അവനോടു: ഞാൻ സർവ്വശക്തിയുള്ള ദൈവം ആകുന്നു; നീ എന്റെ മുമ്പാകെ നടന്നു നിഷ്കളങ്കനായിരിക്ക. ");
INSERT INTO mal2015_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","എനിക്കും നിനക്കും മദ്ധ്യേ ഞാൻ എന്റെ നിയമം സ്ഥാപിക്കും; നിന്നെ അധികമധികമായി വർദ്ധിപ്പിക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","അപ്പോൾ അബ്രാം സാഷ്ടാംഗം വീണു; ദൈവം അവനോടു അരുളിച്ചെയ്തതെന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","എനിക്കു നിന്നോടു ഒരു നിയമമുണ്ടു; നീ ബഹുജാതികൾക്കു പിതാവാകും; ");
INSERT INTO mal2015_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ഇനി നിന്നെ അബ്രാം എന്നല്ല വിളിക്കേണ്ടതു; ഞാൻ നിന്നെ ബഹുജാതികൾക്കു പിതാവാക്കിയിരിക്കയാൽ നിന്റെ പേർ അബ്രാഹാം എന്നിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ഞാൻ നിന്നെ അധികമധികമായി വർദ്ധിപ്പിച്ചു, അനേകജാതികളാക്കും; നിന്നിൽ നിന്നു രാജാക്കന്മാരും ഉത്ഭവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ഞാൻ നിനക്കും നിന്റെ ശേഷം നിന്റെ സന്തതിക്കും ദൈവമായിരിക്കേണ്ടതിന്നു ഞാൻ എനിക്കും നിനക്കും നിന്റെ ശേഷം തലമുറതലമുറയായി നിന്റെ സന്തതിക്കും മദ്ധ്യേ എന്റെ നിയമത്തെ നിത്യനിയമമായി സ്ഥാപിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ഞാൻ നിനക്കും നിന്റെ ശേഷം നിന്റെ സന്തതിക്കും നീ പ്രവാസം ചെയ്യുന്ന ദേശമായ കനാൻദേശം ഒക്കെയും ശാശ്വതാവകാശമായി തരും; ഞാൻ അവർക്കു ദൈവമായുമിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ദൈവം പിന്നെയും അബ്രാഹാമിനോടു അരുളിച്ചെയ്തതു: നീയും നിന്റെ ശേഷം തലമുറതലമുറയായി നിന്റെ സന്തതിയും എന്റെ നിയമം പ്രമാണിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","എനിക്കും നിങ്ങൾക്കും നിന്റെ ശേഷം നിന്റെ സന്തതിക്കും മദ്ധ്യേയുള്ളതും നിങ്ങൾ പ്രമാണിക്കേണ്ടതുമായ എന്റെ നിയമം ആവിതു: നിങ്ങളിൽ പുരുഷപ്രജയൊക്കെയും പരിച്ഛേദന ഏൽക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","നിങ്ങളുടെ അഗ്രചർമ്മം പരിച്ഛേദന ചെയ്യേണം; അതു എനിക്കും നിങ്ങൾക്കും മദ്ധ്യേയുള്ള നിയമത്തിന്റെ അടയാളം ആകും. ");
INSERT INTO mal2015_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","തലമുറതലമുറയായി നിങ്ങളിൽ പുരുഷപ്രജയൊക്കെയും എട്ടു ദിവസം പ്രായമാകുമ്പോൾ പരിച്ഛേദന ഏൽക്കേണം; വീട്ടിൽ ജനിച്ച ദാസനായാലും നിന്റെ സന്തതിയല്ലാത്തവനായി അന്യനോടു വിലയ്ക്കു വാങ്ങിയവനായാലും ശരി. ");
INSERT INTO mal2015_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","നിന്റെ വീട്ടിൽ ജനിച്ച ദാസനും നീ വിലകൊടുത്തു വാങ്ങിയവനും പരിച്ഛേദന ഏറ്റേകഴിയൂ; എന്റെ നിയമം നിങ്ങളുടെ ദേഹത്തിൽ നിത്യനിയമമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","അഗ്രചർമ്മിയായ പുരുഷപ്രജയെ പരിച്ഛേദന ഏൽക്കാതിരുന്നാൽ ജനത്തിൽ നിന്നു ഛേദിച്ചുകളയേണം; അവൻ എന്റെ നിയമം ലംഘിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ദൈവം പിന്നെയും അബ്രാഹാമിനോടു: നിന്റെ ഭാര്യയായ സാറായിയെ സാറായി എന്നല്ല വിളിക്കേണ്ടതു; അവളുടെ പേർ സാറാ എന്നു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ഞാൻ അവളെ അനുഗ്രഹിച്ചു അവളിൽനിന്നു നിനക്കു ഒരു മകനെ തരും; ഞാൻ അവളെ അനുഗ്രഹിക്കയും അവൾ ജാതികൾക്കു മാതാവായി തീരുകയും ജാതികളുടെ രാജാക്കന്മാർ അവളിൽനിന്നു ഉത്ഭവിക്കയും ചെയ്യും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","അപ്പോൾ അബ്രാഹാം കവിണ്ണുവീണു ചിരിച്ചു: നൂറു വയസ്സുള്ളവന്നു മകൻ ജനിക്കുമോ? തൊണ്ണൂറു വയസ്സുള്ള സാറാ പ്രസവിക്കുമോ എന്നു തന്റെ ഹൃദയത്തിൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","യിശ്മായേൽ നിന്റെ മുമ്പാകെ ജീവിച്ചിരുന്നാൽ മതി എന്നു അബ്രാഹാം ദൈവത്തോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","അതിന്നു ദൈവം അരുളിച്ചെയ്തതു: അല്ല, നിന്റെ ഭാര്യയായ സാറാ തന്നേ നിനക്കൊരു മകനെ പ്രസവിക്കും; നീ അവന്നു യിസ്ഹാക്ക് എന്നു പേരിടേണം; ഞാൻ അവനോടും അവന്റെ ശേഷം അവന്റെ സന്തതിയോടും എന്റെ നിയമത്തെ നിത്യനിയമമായി ഉറപ്പിക്കും ");
INSERT INTO mal2015_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","യിശ്മായേലിനെ കുറിച്ചും ഞാൻ നിന്റെ അപേക്ഷ കേട്ടിരിക്കുന്നു; ഞാൻ അവനെ അനുഗ്രഹിച്ചു അത്യന്തം സന്താനപുഷ്ടിയുള്ളവനാക്കി വർദ്ധിപ്പിക്കും. അവൻ പന്ത്രണ്ടു പ്രഭുക്കന്മാരെ ജനിപ്പിക്കും; ഞാൻ അവനെ വലിയോരു ജാതിയാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","എന്റെ നിയമം ഞാൻ ഉറപ്പിക്കുന്നതോ, ഇനിയത്തെ ആണ്ടു ഈ സമയത്തു സാറാ നിനക്കു പ്രസവിപ്പാനുള്ള യിസ്ഹാക്കിനോടു ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ദൈവം അബ്രാഹാമിനോടു അരുളിച്ചെയ്തു തീർന്നശേഷം അവനെ വിട്ടു കയറിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","അനന്തരം അബ്രാഹാം തന്റെ മകനായ യിശ്മായേലിനെയും തന്റെ വീട്ടിൽ ജനിച്ച സകലദാസന്മാരെയും താൻ വിലയ്ക്കു വാങ്ങിയവരെ ഒക്കെയും അബ്രാഹാമിന്റെ വീട്ടിലുള്ള സകലപുരുഷന്മാരെയും കൂട്ടി ദൈവം തന്നോടു കല്പിച്ചതുപോലെ അവരുടെ അഗ്രചർമ്മത്തെ അന്നുതന്നേ പരിച്ഛേദന കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","അബ്രാഹാം പരിച്ഛേദനയേറ്റപ്പോൾ അവന്നു തൊണ്ണൂറ്റൊമ്പതു വയസ്സായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","അവന്റെ മകനായ യിശ്മായേൽ പരിച്ഛേദനയേറ്റപ്പോൾ അവന്നു പതിമൂന്നു വയസ്സായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","അബ്രാഹാമും അവന്റെ മകനായ യിശ്മായേലും ഒരേ ദിവസത്തിൽ പരിച്ഛേദന ഏറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","വീട്ടിൽ ജനിച്ച ദാസന്മാരും അന്യരോടു അവൻ വിലെക്കു വാങ്ങിയവരുമായി അവന്റെ വീട്ടിലുള്ളവർ എല്ലാവരും അവനോടുകൂടെ പരിച്ഛേദന ഏറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","അനന്തരം യഹോവ അവന്നു മമ്രേയുടെ തോപ്പിൽവെച്ചു പ്രത്യക്ഷനായി; വെയിലുറെച്ചപ്പോൾ അവൻ കൂടാരവാതിൽക്കൽ ഇരിക്കയായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","അവൻ തലപൊക്കി നോക്കിയപ്പോൾ മൂന്നു പുരുഷന്മാർ തന്റെ നേരെ നില്ക്കുന്നതു കണ്ടു; അവരെ കണ്ടപ്പോൾ അവൻ കൂടാരവാതിൽക്കൽ നിന്നു അവരെ എതിരേല്പാൻ ഓടിച്ചെന്നു നിലംവരെ കുനിഞ്ഞു: ");
INSERT INTO mal2015_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","യജമാനനേ, എന്നോടു കൃപയുണ്ടെങ്കിൽ അടിയനെ കടന്നുപോകരുതേ. ");
INSERT INTO mal2015_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","അസാരം വെള്ളം കൊണ്ടുവന്നു നിങ്ങളുടെ കാലുകളെ കഴുകട്ടെ; വൃക്ഷത്തിൻ കീഴിൽ ഇരിപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ഞാൻ ഒരു മുറി അപ്പം കൊണ്ടുവരാം; വിശപ്പു അടക്കീട്ടു നിങ്ങൾക്കു പോകാം; ഇതിന്നായിട്ടല്ലോ നിങ്ങൾ അടിയന്റെ അടുക്കൽ കയറിവന്നതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","നീ പറഞ്ഞതുപോലെ ആകട്ടെ എന്നു അവർ പറഞ്ഞു. അബ്രഹാം ബദ്ധപ്പെട്ടു കൂടാരത്തിൽ സാറയുടെ അടുക്കൽ ചെന്നു: നീ ക്ഷണത്തിൽ മൂന്നിടങ്ങഴി മാവു എടുത്തു കുഴെച്ചു അപ്പമുണ്ടാക്കുക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","അബ്രാഹാം പശുക്കൂട്ടത്തിൽ ഓടിച്ചെന്നു ഇളയതും നല്ലതുമായൊരു കാളക്കുട്ടിയെ പിടിച്ചു ഒരു ബാല്യക്കാരന്റെ പക്കൽ കൊടുത്തു; അവൻ അതിനെ ക്ഷണത്തിൽ പാകം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","പിന്നെ അവൻ വെണ്ണയും പാലും താൻ പാകം ചെയ്യിച്ച കാളക്കുട്ടിയെയും കൊണ്ടുവന്നു അവരുടെ മുമ്പിൽ വെച്ചു. അവരുടെ അടുക്കൽ വൃക്ഷത്തിൻ കീഴിൽ ശുശ്രൂഷിച്ചു നിന്നു; അവർ ഭക്ഷണം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","അവർ അവനോടു: നിന്റെ ഭാര്യ സാറാ എവിടെ എന്നു ചോദിച്ചതിന്നു: കൂടാരത്തിൽ ഉണ്ടു എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ഒരു ആണ്ടു കഴിഞ്ഞിട്ടു ഞാൻ നിന്റെ അടുക്കൽ മടങ്ങിവരും; അപ്പോൾ നിന്റെ ഭാര്യ സാറെക്കു ഒരു മകൻ ഉണ്ടാകും എന്നു അവൻ പറഞ്ഞു. സാറാ കൂടാരവാതിൽക്കൽ അവന്റെ പിൻവശത്തു കേട്ടുകൊണ്ടു നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","എന്നാൽ അബ്രാഹാമും സാറയും വയസ്സു ചെന്നു വൃദ്ധരായിരുന്നു. സ്ത്രീകൾക്കുള്ള പതിവു സാറെക്കു നിന്നു പോയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ആകയാൽ സാറാ ഉള്ളുകൊണ്ടു ചിരിച്ചു: വൃദ്ധയായിരിക്കുന്ന എനിക്കു സുഖഭോഗമുണ്ടാകുമോ? എന്റെ ഭർത്താവും വൃദ്ധനായിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","യഹോവ അബ്രാഹാമിനോടു: വൃദ്ധയായ ഞാൻ പ്രസവിക്കുന്നതു വാസ്തവമോ എന്നു പറഞ്ഞു സാറാ ചിരിച്ചതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","യഹോവയാൽ കഴിയാത്ത കാര്യം ഉണ്ടോ? ഒരു ആണ്ടു കഴിഞ്ഞിട്ടു ഈ സമയമാകുമ്പോൾ ഞാൻ നിന്റെ അടുക്കൽ മടങ്ങിവരും; സാറെക്കു ഒരു മകൻ ഉണ്ടാകും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","സാറാ ഭയപ്പെട്ടു: ഇല്ല, ഞാൻ ചിരിച്ചില്ല എന്നു പറഞ്ഞു. അങ്ങനെയല്ല, നീ ചിരിച്ചു എന്നു അവൻ അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ആ പുരുഷന്മാർ അവിടെനിന്നു പുറപ്പെട്ടു സൊദോംവഴിക്കു തിരിഞ്ഞു; അബ്രാഹാം അവരെ യാത്ര അയപ്പാൻ അവരോടുകൂടെ പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","അപ്പോൾ യഹോവ അരുളിച്ചെയ്തതു: ഞാൻ ചെയ്‌വാനിരിക്കുന്നതു അബ്രാഹാമിനോടു മറെച്ചുവെക്കുമോ? ");
INSERT INTO mal2015_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","അബ്രാഹാം വലിയതും ബലമുള്ളതുമായ ജാതിയായി തീരുകയും അവനിൽ ഭൂമിയിലെ ജാതികളൊക്കെയും അനുഗ്രഹിക്കപ്പെടുകയും ചെയ്യുമല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","യഹോവ അബ്രാഹാമിനെക്കുറിച്ചു അരുളിച്ചെയ്തതു അവന്നു നിവൃത്തിച്ചുകൊടുപ്പാൻ തക്കവണ്ണം അബ്രാഹാം തന്റെ മക്കളോടും തനിക്കു പിമ്പുള്ള കുടുംബത്തോടും നീതിയും ന്യായവും പ്രവൃത്തിച്ചുകൊണ്ടു യഹോവയുടെ വഴിയിൽ നടപ്പാൻ കല്പിക്കേണ്ടതിന്നു ഞാൻ അവനെ തിരഞ്ഞെടുത്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","പിന്നെ യഹോവ: സൊദോമിന്റെയും ഗൊമോരയുടെയും നിലവിളി വലിയതും അവരുടെ പാപം അതികഠിനവും ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ഞാൻ ചെന്നു എന്റെ അടുക്കൽ വന്നെത്തിയ നിലവിളിപോലെ അവർ കേവലം പ്രവൃത്തിച്ചിട്ടുണ്ടോ ഇല്ലയോ എന്നു നോക്കി അറിയും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","അങ്ങനെ ആ പുരുഷന്മാർ അവിടെനിന്നു തിരിഞ്ഞു സൊദോമിലേക്കു പോയി. അബ്രാഹാമോ യഹോവയുടെ സന്നിധിയിൽ തന്നേ നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","അബ്രാഹാം അടുത്തുചെന്നു പറഞ്ഞതു: ദുഷ്ടനോടുകൂടെ നീതിമാനെയും നീ സംഹരിക്കുമോ? ");
INSERT INTO mal2015_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","പക്ഷേ ആ പട്ടണത്തിൽ അമ്പതു നീതിമാന്മാർ ഉണ്ടെങ്കിൽ നീ അതിനെ സംഹരിക്കുമോ? അതിലെ അമ്പതു നീതിമാന്മാർ നിമിത്തം ആ സ്ഥലത്തോടു ക്ഷമിക്കയില്ലയോ? ");
INSERT INTO mal2015_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ഇങ്ങനെ നീ ഒരുനാളും ചെയ്യുന്നതല്ലല്ലോ; നീതിമാൻ ദുഷ്ടനെപ്പോലെ ആകത്തക്കവണ്ണം ദുഷ്ടനോടുകൂടെ നീതിമാനെ നീ ഒരുനാളും കൊല്ലുകയില്ല. സർവ്വ ഭൂമിക്കും ന്യായാധിപതിയായവൻ നീതി പ്രവൃത്തിക്കാതിരിക്കുമോ? ");
INSERT INTO mal2015_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","അതിന്നു യഹോവ: ഞാൻ സൊദോമിൽ, പട്ടണത്തിന്നകത്തു, അമ്പതു നീതിമാന്മാരെ കാണുന്നു എങ്കിൽ അവരുടെ നിമിത്തം ആ സ്ഥലത്തോടൊക്കെയും ക്ഷമിക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","പൊടിയും വെണ്ണീറുമായ ഞാൻ കർത്താവിനോടു സംസാരിപ്പാൻ തുനിഞ്ഞുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","അമ്പതു നീതിമാന്മാരിൽ പക്ഷേ അഞ്ചുപേർ കുറഞ്ഞു പോയെങ്കിലോ? അഞ്ചുപേർ കുറഞ്ഞതുകൊണ്ടു നീ ആ പട്ടണം മുഴുവനും നശിപ്പിക്കുമോ എന്നു അബ്രാഹാം പറഞ്ഞതിന്നു: നാല്പത്തഞ്ചു പേരെ ഞാൻ അവിടെ കണ്ടാൽ അതിനെ നശിപ്പിക്കയില്ല എന്നു അവൻ അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","അവൻ പിന്നെയും അവനോടു സംസാരിച്ചു: പക്ഷേ നാല്പതുപേരെ അവിടെ കണ്ടാലോ എന്നു പറഞ്ഞതിന്നു: ഞാൻ നാല്പതുപേരുടെ നിമിത്തം നശിപ്പിക്കയില്ല എന്നു അവൻ അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","അതിന്നു അവൻ: ഞാൻ പിന്നെയും സംസാരിക്കുന്നു; കർത്താവു കോപിക്കരുതേ; പക്ഷേ മുപ്പതുപേരെ അവിടെ കണ്ടാലോ എന്നു പറഞ്ഞു. ഞാൻ മുപ്പതുപേരെ അവിടെ കണ്ടാൽ നശിപ്പിക്കയില്ല എന്നു അവൻ അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ഞാൻ കർത്താവിനോടു സംസാരിപ്പാൻ തുനിഞ്ഞുവല്ലോ; പക്ഷേ ഇരുപതുപേരെ അവിടെ കണ്ടാലോ എന്നു അവൻ പറഞ്ഞതിന്നു: ഞാൻ ഇരുപതുപേരുടെ നിമിത്തം നശിപ്പിക്കയില്ല എന്നു അവൻ അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","അപ്പോൾ അവൻ: കർത്താവു കോപിക്കരുതേ; ഞാൻ ഇനി ഒരു പ്രാവശ്യം മാത്രം സംസാരിക്കും; പക്ഷേ പത്തു പേരെ അവിടെ കണ്ടാലോ എന്നു പറഞ്ഞു. ഞാൻ പത്തുപേരുടെ നിമിത്തം നശിപ്പിക്കയില്ല എന്നു അവൻ അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","യഹോവ അബ്രാഹാമിനോടു അരുളിച്ചെയ്തു തീർന്നശേഷം അവിടെനിന്നു പോയി. അബ്രാഹാമും തന്റെ സ്ഥലത്തേക്കു മടങ്ങിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ആ രണ്ടു ദൂതന്മാർ വൈകുന്നേരത്തു സൊദോമിൽ എത്തി; ലോത്ത് സൊദോംപട്ടണവാതിൽക്കൽ ഇരിക്കയായിരുന്നു; അവരെ കണ്ടിട്ടു ലോത്ത് എഴുന്നേറ്റു എതിരേറ്റുചെന്നു നിലംവരെ കുനിഞ്ഞു നമസ്കരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","യജമാനന്മാരേ, അടിയന്റെ വീട്ടിൽ വന്നു നിങ്ങളുടെ കാലുകളെ കഴുകി രാപാർപ്പിൻ; കാലത്തു എഴുന്നേറ്റു നിങ്ങളുടെ വഴിക്കു പോകയുമാം എന്നു പറഞ്ഞതിന്നു: അല്ല, ഞങ്ങൾ വീഥിയിൽ തന്നേ രാപാർക്കും എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","അവൻ അവരെ ഏറ്റവും നിർബന്ധിച്ചു; അപ്പോൾ അവർ അവന്റെ അടുക്കൽ തിരിഞ്ഞു അവന്റെ വീട്ടിൽ ചെന്നു; അവൻ അവർക്കു വിരുന്നൊരുക്കി, പുളിപ്പില്ലാത്ത അപ്പം ചുട്ടു; അവർ ഭക്ഷണം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","അവർ ഉറങ്ങുവാൻ പോകുമ്മുമ്പെ സൊദോംപട്ടണത്തിലെ പുരുഷന്മാർ സകല ഭാഗത്തുനിന്നും ആബാലവൃദ്ധം എല്ലാവരും വന്നു വീടു വളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","അവർ ലോത്തിനെ വിളിച്ചു: ഈ രാത്രി നിന്റെ അടുക്കൽ വന്ന പുരുഷന്മാർ എവിടെ? ഞങ്ങൾ അവരെ ഭോഗിക്കേണ്ടതിന്നു ഞങ്ങളുടെ അടുക്കൽ പുറത്തു കൊണ്ടുവാ എന്നു അവനോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ലോത്ത് വാതിൽക്കൽ അവരുടെ അടുക്കൽ പുറത്തു ചെന്നു, കതകു അടെച്ചുംവെച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","സഹോദരന്മാരേ, ഇങ്ങനെ ദോഷം ചെയ്യരുതേ. ");
INSERT INTO mal2015_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","പുരുഷൻ തൊടാത്ത രണ്ടു പുത്രിമാർ എനിക്കുണ്ടു; അവരെ ഞാൻ നിങ്ങളുടെ അടുക്കൽ പുറത്തു കൊണ്ടുവരാം; നിങ്ങൾക്കു ബോധിച്ചതുപോലെ അവരോടു ചെയ്തുകൊൾവിൻ; ഈ പുരുഷന്മാരോടു മാത്രം ഒന്നും ചെയ്യരുതേ; ഇതിന്നായിട്ടല്ലോ അവർ എന്റെ വീട്ടിന്റെ നിഴലിൽ വന്നതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","മാറിനിൽക എന്നു അവർ പറഞ്ഞു. ഇവനൊരുത്തൻ പരദേശിയായി വന്നു പാർക്കുന്നു; ന്യായംവിധിപ്പാനും ഭാവിക്കുന്നു. ഇപ്പോൾ ഞങ്ങൾ അവരോടു ഭാവിച്ചതിലധികം നിന്നോടു ദോഷം ചെയ്യും എന്നും അവർ പറഞ്ഞു ലോത്തിനെ ഏറ്റവും തിക്കി വാതിൽ പൊളിപ്പാൻ അടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","അപ്പോൾ ആ പുരുഷന്മാർ കൈ പുറത്തോട്ടു നീട്ടി ലോത്തിനെ തങ്ങളുടെ അടുക്കൽ അകത്തു കയറ്റി വാതിൽ അടെച്ചു, ");
INSERT INTO mal2015_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","വാതിൽക്കൽ ഉണ്ടായിരുന്ന പുരുഷന്മാർക്കു അബാലവൃദ്ധം അന്ധത പിടിപ്പിച്ചു. അതുകൊണ്ടു അവർ വാതിൽ തപ്പിനടന്നു വിഷമിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ആ പുരുഷന്മാർ ലോത്തിനോടു: ഇവിടെ നിനക്കു മറ്റു വല്ലവരുമുണ്ടോ? മരുമക്കളോ പുത്രന്മാരോ പുത്രിമാരോ ഇങ്ങനെ പട്ടണത്തിൽ നിനക്കുള്ളവരെയൊക്കെയും ഈ സ്ഥലത്തുനിന്നു കൊണ്ടുപൊയ്ക്കെൾക; ");
INSERT INTO mal2015_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ഇവരെക്കുറിച്ചുള്ള ആവലാധി യഹോവയുടെ മുമ്പാകെ വലുതായിത്തീർന്നിരിക്കകൊണ്ടു ഞങ്ങൾ ഈ സ്ഥലത്തെ നശിപ്പിക്കും. അതിനെ നശിപ്പിപ്പാൻ യഹോവ ഞങ്ങളെ അയച്ചിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","അങ്ങനെ ലോത്ത് ചെന്നു തന്റെ പുത്രിമാരെ വിവാഹം ചെയ്‌വാനുള്ള മരുമക്കളോടു സംസാരിച്ചു: നിങ്ങൾ എഴുന്നേറ്റു ഈ സ്ഥലം വിട്ടു പുറപ്പെടുവിൻ; യഹോവ ഈ പട്ടണം നശിപ്പിക്കും എന്നു പറഞ്ഞു. എന്നാൽ അവൻ കളി പറയുന്നു എന്നു അവന്റെ മരുമക്കൾക്കു തോന്നി. ");
INSERT INTO mal2015_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ഉഷസ്സായപ്പോൾ ദൂതന്മാർ ലോത്തിനെ ബദ്ധപ്പെടുത്തി: ഈ പട്ടണത്തിന്റെ അകൃത്യത്തിൽ നശിക്കാതിരിപ്പാൻ എഴുന്നേറ്റു നിന്റെ ഭാര്യയെയും ഇവിടെ കാണുന്ന നിന്റെ രണ്ടു പുത്രിമാരെയും കൂട്ടിക്കൊണ്ടു പൊയ്ക്കൾക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","അവൻ താമസിച്ചപ്പോൾ, യഹോവ അവനോടു കരുണ ചെയ്കയാൽ, ആ പുരുഷന്മാർ അവനെയും ഭാര്യയെയും രണ്ടു പുത്രിമാരെയും കൈക്കു പിടിച്ചു പട്ടണത്തിന്റെ പുറത്തു കൊണ്ടുപോയി ആക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","അവരെ പുറത്തു കൊണ്ടുവന്ന ശേഷം അവൻ: ജീവരക്ഷെക്കായി ഓടിപ്പോക; പുറകോട്ടു നോക്കരുതു; ഈ പ്രദേശത്തെങ്ങും നിൽക്കയുമരുതു; നിനക്കു നാശം ഭവിക്കാതിരിപ്പാൻ പർവ്വതത്തിലേക്കു ഓടിപ്പോക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ലോത്ത് അവരോടു പറഞ്ഞതു: അങ്ങനെയല്ല കർത്താവേ; ");
INSERT INTO mal2015_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","നിനക്കു അടിയനോടു കൃപ തോന്നിയല്ലോ; എന്റെ ജീവനെ രക്ഷിപ്പാൻ എനിക്കു വലിയ കൃപ നീ കാണിച്ചിരിക്കുന്നു; പർവ്വതത്തിൽ ഓടി എത്തുവാൻ എനിക്കു കഴികയില്ല; പക്ഷേ എനിക്കു ദോഷം തട്ടി മരണം ഭവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ഇതാ, ഈ പട്ടണം സമീപമാകുന്നു; അവിടേക്കു എനിക്കു ഓടാം; അതു ചെറിയതുമാകുന്നു; ഞാൻ അവിടേക്കു ഓടിപ്പേകട്ടെ. അതു ചെറിയതല്ലോ; എന്നാൽ എനിക്കു ജീവരക്ഷ ഉണ്ടാകും. ");
INSERT INTO mal2015_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","അവൻ അവനോടു: ഇക്കാര്യത്തിലും ഞാൻ നിന്നെ കടാക്ഷിച്ചിരിക്കുന്നു; നീ പറഞ്ഞ പട്ടണം ഞാൻ മറിച്ചുകളകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ബദ്ധപ്പെട്ടു അവിടേക്കു ഓടിപ്പോക; നീ അവിടെ എത്തുവോളം എനിക്കു ഒന്നും ചെയ്‌വാൻ കഴികയില്ല എന്നു പറഞ്ഞു. അതുകൊണ്ടു ആ പട്ടണത്തിന്നു സോവർ എന്നു പേരായി. ");
INSERT INTO mal2015_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ലോത്ത് സോവരിൽ കടന്നപ്പോൾ സൂര്യൻ ഉദിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","യഹോവ സൊദോമിന്റെയും ഗൊമോരയുടെയും മേൽ യഹോവയുടെ സന്നിധിയിൽനിന്നു, ആകാശത്തു നിന്നു തന്നെ, ഗന്ധകവും തീയും വർഷിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ആ പട്ടണങ്ങൾക്കും പ്രദേശത്തിന്നു മുഴുവനും ആ പട്ടണങ്ങളിലെ സകലനിവാസികൾക്കും നിലത്തെ സസ്യങ്ങൾക്കും ഉന്മൂലനാശം വരുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ലോത്തിന്റെ ഭാര്യ അവന്റെ പിന്നിൽനിന്നു തിരിഞ്ഞുനോക്കി ഉപ്പുതൂണായി ഭവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","അബ്രാഹാം രാവിലെ എഴുന്നേറ്റു താൻ യഹോവയുടെ സന്നിധിയിൽ നിന്നിരുന്ന സ്ഥലത്തു ചെന്നു, ");
INSERT INTO mal2015_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","സൊദോമിന്നും ഗൊമോരെക്കും ആ പ്രദേശത്തിലെ സകലദിക്കിന്നും നേരെ നോക്കി, ദേശത്തിലെ പുക തീച്ചൂളയിലെ പുകപോലെ പൊങ്ങുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","എന്നാൽ ആ പ്രദേശത്തിലെ പട്ടണങ്ങളെ നശിപ്പിക്കുമ്പോൾ ദൈവം അബ്രാഹാമിനെ ഓർത്തു. ലോത്ത് പാർത്ത പട്ടണങ്ങൾക്കു ഉന്മൂലനാശം വരുത്തുകയിൽ ലോത്തിനെ ആ ഉന്മൂലനാശത്തിൽനിന്നു വിടുവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","അനന്തരം ലോത്ത് സോവർ വിട്ടുപോയി; അവനും അവന്റെ രണ്ടു പുത്രിമാരും പർവ്വതത്തിൽ ചെന്നു പാർത്തു; സോവരിൽ പാർപ്പാൻ അവൻ ഭയപ്പെട്ടു; അവനും അവന്റെ രണ്ടു പുത്രിമാരും ഒരു ഗുഹയിൽ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","അങ്ങനെയിരിക്കുമ്പോൾ മൂത്തവൾ ഇളയവളോടു: നമ്മുടെ അപ്പൻ വൃദ്ധനായിരിക്കുന്നു; ഭൂമിയിൽ എല്ലാടവും ഉള്ള നടപ്പുപോലെ നമ്മുടെ അടുക്കൽ വരുവാൻ ഭൂമിയിൽ ഒരു പുരുഷനും ഇല്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","വരിക; അപ്പനാൽ സന്തതി ലഭിക്കേണ്ടതിന്നു അവനെ വീഞ്ഞുകുടിപ്പിച്ചു അവനോടുകൂടെ ശയിക്ക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","അങ്ങനെ അന്നു രാത്രി അവർ അപ്പനെ വീഞ്ഞുകുടിപ്പിച്ചു; മൂത്തവൾ അകത്തു ചെന്നു അപ്പനോടുകൂടെ ശയിച്ചു; അവൾ ശയിച്ചതും എഴുന്നേറ്റതും അവൻ അറിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","പിറ്റെന്നാൾ മൂത്തവൾ ഇളയവളോടു: ഇന്നലെ രാത്രി ഞാൻ അപ്പനോടുകൂടെ ശയിച്ചു; നാം അവനെ ഇന്നു രാത്രിയും വീഞ്ഞു കുടിപ്പിക്ക; അപ്പനാൽ സന്തതി ലഭിക്കേണ്ടതിന്നു നീയും അകത്തുചെന്നു അവനോടു കൂടെ ശയിക്ക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","അങ്ങനെ അന്നു രാത്രിയും അവർ അപ്പനെ വീഞ്ഞു കുടിപ്പിച്ചു; ഇളയവൾ ചെന്നു അവനോടുകൂടെ ശയിച്ചു; അവൾ ശയിച്ചതും എഴുന്നേറ്റതും അവൻ അറിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ഇങ്ങനെ ലോത്തിന്റെ രണ്ടു പുത്രിമാരും അപ്പനാൽ ഗർഭം ധരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","മൂത്തവൾ ഒരു മകനെ പ്രസവിച്ചു അവന്നു മോവാബ് എന്നു പേരിട്ടു; അവൻ ഇന്നുള്ള മോവാബ്യർക്കു പിതാവു. ");
INSERT INTO mal2015_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ഇളയവളും ഒരു മകനെ പ്രസവിച്ചു; അവന്നു ബെൻ-അമ്മീ എന്നു പേരിട്ടു; അവൻ ഇന്നുള്ള അമ്മോന്യർക്കു പിതാവു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","അനന്തരം അബ്രാഹാം അവിടെനിന്നു തെക്കെ ദേശത്തേക്കു യാത്ര പുറപ്പെട്ടു കാദേശിന്നും സൂരിന്നും മദ്ധ്യേ കുടിയിരുന്നു ഗെരാരിൽ പരദേശിയായി പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","അബ്രാഹാം തന്റെ ഭാര്യയായ സാറയെക്കുറിച്ചു: അവൾ എന്റെ പെങ്ങൾ എന്നു പറഞ്ഞു. ഗെരാർ രാജാവായ അബീമേലെക്ക് ആളയച്ചു സാറയെ കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","എന്നാൽ രാത്രിയിൽ ദൈവം സ്വപ്നത്തിൽ അബീമേലെക്കിന്റെ അടുക്കൽ വന്നു അവനോടു: നീ എടുത്ത സ്ത്രീയുടെ നിമിത്തം നീ മരിക്കും; അവൾ ഒരു പുരുഷന്റെ ഭാര്യ എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","എന്നാൽ അബീമേലെക്ക് അവളുടെ അടുക്കൽ ചെന്നിരുന്നില്ല; ആകയാൽ അവൻ: കർത്താവേ, നീതിയുള്ള ജാതിയെയും നീ കൊല്ലുമോ? ");
INSERT INTO mal2015_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ഇവൾ എന്റെ പെങ്ങളാകുന്നു എന്നു അവൻ എന്നോടു പറഞ്ഞുവല്ലോ. അവൻ എന്റെ ആങ്ങള എന്നു അവളും പറഞ്ഞു. ഹൃദയപരമാർത്ഥതയോടും കയ്യുടെ നിർമ്മലതയോടും കൂടെ ഞാൻ ഇതു ചെയ്തിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","അതിന്നു ദൈവം സ്വപ്നത്തിൽ അവനോടു: നീ ഇതു ഹൃദയപരമാർത്ഥതയോടെ ചെയ്തിരിക്കുന്നു എന്നു ഞാൻ അറിയുന്നു; നീ എന്നോടു പാപം ചെയ്യാതിരിപ്പാൻ ഞാൻ നിന്നെ തടുത്തു; അതുകൊണ്ടാകുന്നു അവളെ തൊടുവാൻ ഞാൻ നിന്നെ സമ്മതിക്കാതിരുന്നതു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ഇപ്പോൾ ആ പുരുഷന്നു അവന്റെ ഭാര്യയെ മടക്കിക്കൊടുക്ക; അവൻ ഒരു പ്രവാചകൻ ആകുന്നു; നീ ജീവനോടിരിക്കേണ്ടതിന്നു അവൻ നിനക്കുവേണ്ടി പ്രാർത്ഥിക്കട്ടെ. അവളെ മടക്കിക്കൊടുക്കാതിരുന്നാലോ, നീയും നിനക്കുള്ളവരൊക്കെയും മരിക്കേണ്ടിവരും എന്നു അറിഞ്ഞുകൊൾക എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","അബീമേലെക്ക് അതികാലത്തു എഴുന്നേറ്റു തന്റെ സകലഭൃത്യന്മാരെയും വരുത്തി ഈ കാര്യം ഒക്കെയും അവരോടു പറഞ്ഞു; അവർ ഏറ്റവും ഭയപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","അബീമേലെക്ക് അബ്രാഹാമിനെ വിളിപ്പിച്ചു അവനോടു: നീ ഞങ്ങളോടു ചെയ്തതു എന്തു? നീ എന്റെ മേലും എന്റെ രാജ്യത്തിന്മേലും ഒരു മഹാപാപം വരുത്തുവാൻ തക്കവണ്ണം ഞാൻ നിന്നോടു എന്തു ദോഷം ചെയ്തു? ചെയ്യരുതാത്ത കാര്യം നീ എന്നോടു ചെയ്തുവല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","നീ എന്തു കണ്ടിട്ടാകുന്നു ഇക്കാര്യം ചെയ്തതു എന്നു അബീമേലെക്ക് അബ്രാഹാമിനോടു ചോദിച്ചതിന്നു അബ്രാഹാം പറഞ്ഞതു: ");
INSERT INTO mal2015_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ഈ സ്ഥലത്തു ദൈവഭയം ഇല്ല നിശ്ചയം; എന്റെ ഭാര്യനിമിത്തം അവർ എന്നെ കൊല്ലും എന്നു ഞാൻ നിരൂപിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","വാസ്തവത്തിൽ അവൾ എന്റെ പെങ്ങളാകുന്നു; എന്റെ അപ്പന്റെ മകൾ; എന്റെ അമ്മയുടെ മകളല്ല താനും; അവൾ എനിക്കു ഭാര്യയായി. ");
INSERT INTO mal2015_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","എന്നാൽ ദൈവം എന്നെ എന്റെ പിതൃഭവനത്തിൽനിന്നു പുറപ്പെടുവിച്ചപ്പോൾ ഞാൻ അവളോടു: നീ എനിക്കു ഒരു ദയ ചെയ്യേണം; നാം ഏതൊരു ദിക്കിൽ ചെന്നാലും അവിടെ: അവൻ എന്റെ ആങ്ങള എന്നു എന്നെക്കുറിച്ചു പറയേണം എന്നു പറഞ്ഞിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","അബീമേലെക്ക് അബ്രാഹാമിന്നു ആടുമാടുകളെയും ദാസീദാസന്മാരെയും കൊടുത്തു; അവന്റെ ഭാര്യയായ സാറയെയും അവന്നു മടക്കിക്കൊടുത്തു: ");
INSERT INTO mal2015_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ഇതാ, എന്റെ രാജ്യം നിന്റെ മുമ്പാകെ ഇരിക്കുന്നു; നിനക്കു ബോധിച്ചേടത്തു പാർത്തുകൊൾക എന്നു അബീമേലെക്ക് പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","സാറയോടു അവൻ: നിന്റെ ആങ്ങളെക്കു ഞാൻ ആയിരം വെള്ളിക്കാശു കൊടുത്തിട്ടുണ്ടു; നിന്നോടുകൂടെയുള്ള എല്ലാവരുടെയും മുമ്പാകെ ഇതു നിനക്കു ഒരു പ്രതിശാന്തി; നീ എല്ലാവർക്കും മുമ്പാകെ നീതീകരിക്കപ്പെട്ടുമിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","അബ്രാഹാം ദൈവത്തോടു അപേക്ഷിച്ചു; അപ്പോൾ ദൈവം അബീമേലെക്കിനെയും അവന്റെ ഭാര്യയെയും അവന്റെ ദാസിമാരെയും സൗഖ്യമാക്കി, അവർ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","അബ്രാഹാമിന്റെ ഭാര്യയായ സാറയുടെ നിമിത്തം യഹോവ അബീമേലെക്കിന്റെ ഭവനത്തിലെ ഗർഭം ഒക്കെയും അടെച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","അനന്തരം യഹോവ താൻ അരുളിച്ചെയ്തിരുന്നതുപോലെ സാറയെ സന്ദർശിച്ചു; താൻ വാഗ്ദത്തം ചെയ്തിരുന്നതു യഹോവ സാറെക്കു നിവൃത്തിച്ചുകൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","അബ്രാഹാമിന്റെ വാർദ്ധക്യത്തിൽ ദൈവം അവനോടു അരുളിച്ചെയ്തിരുന്ന അവധിക്കു സാറാ ഗർഭം ധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","സാറാ അബ്രാഹാമിന്നു പ്രസവിച്ച മകന്നു അവൻ യിസ്ഹാക്ക് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ദൈവം അബ്രാഹാമിനോടു കല്പിച്ചിരുന്നതുപോലെ അവൻ തന്റെ മകനായ യിസ്ഹാക്കിന്നു എട്ടാം ദിവസം പരിച്ഛേദന കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","തന്റെ മകനായ യിസ്ഹാക്ക് ജനിച്ചപ്പോൾ അബ്രാഹാമിന്നു നൂറു വയസ്സായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ദൈവം എനിക്കു ചിരിയുണ്ടാക്കി; കേൾക്കുന്നവരെല്ലാം എന്നെച്ചൊല്ലി ചിരിക്കും എന്നു സാറാ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","സാറാ മക്കൾക്കു മുലകൊടുക്കുമെന്നു അബ്രാഹാമിനോടു ആർ പറയുമായിരുന്നു. അവന്റെ വാർദ്ധക്യത്തിലല്ലോ ഞാൻ ഒരു മകനെ പ്രസവിച്ചതു എന്നും അവൾ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","പൈതൽ വളർന്നു മുലകുടി മാറി; യിസ്ഹാക്കിന്റെ മുലകുടി മാറിയ നാളിൽ അബ്രാഹാം ഒരു വലിയ വിരുന്നു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","മിസ്രയീമ്യദാസി ഹാഗാർ അബ്രാഹാമിന്നു പ്രസവിച്ച മകൻ പരിഹാസി എന്നു സാറാ കണ്ടു അബ്രാഹാമിനോടു: ");
INSERT INTO mal2015_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ഈ ദാസിയെയും മകനെയും പുറത്താക്കിക്കളക; ഈ ദാസിയുടെ മകൻ എന്റെ മകൻ യിസ്ഹാക്കിനോടുകൂടെ അവകാശിയാകരുതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","തന്റെ മകൻ നിമിത്തം ഈ കാര്യം അബ്രാഹാമിന്നു അനിഷ്ടമായി. ");
INSERT INTO mal2015_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","എന്നാൽ ദൈവം അബ്രാഹാമിനോടു: ബാലന്റെ നിമിത്തവും ദാസിയുടെ നിമിത്തവും നിനക്കു അനിഷ്ടം തോന്നരുതു; സാറാ നിന്നോടു പറഞ്ഞതിലൊക്കെയും അവളുടെ വാക്കു കേൾക്ക; യിസ്ഹാക്കിൽനിന്നുള്ളവരല്ലോ നിന്റെ സാക്ഷാൽ സന്തതിയെന്നു വിളിക്കപ്പെടുന്നതു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ദാസിയുടെ മകനെയും ഞാൻ ഒരു ജാതിയാക്കും; അവൻ നിന്റെ സന്തതിയല്ലോ എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","അബ്രാഹാം അതികാലത്തു എഴുന്നേറ്റു അപ്പവും ഒരു തുരുത്തി വെള്ളവും എടുത്തു ഹാഗാരിന്റെ തോളിൽവെച്ചു, കുട്ടിയെയും കൊടുത്തു അവളെ അയച്ചു; അവൾ പുറപ്പെട്ടുപോയി ബേർ-ശേബ മരുഭൂമിയിൽ ഉഴന്നു നടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","തുരുത്തിയിലെ വെള്ളം ചെലവായശേഷം അവൾ കുട്ടിയെ ഒരു കുറുങ്കാട്ടിൻ തണലിൽ ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","അവൾ പോയി അതിന്നെതിരെ ഒരു അമ്പിൻപാടു ദൂരത്തു ഇരുന്നു: കുട്ടിയുടെ മരണം എനിക്കു കാണേണ്ടാ എന്നു പറഞ്ഞു എതിരെ ഇരുന്നു ഉറക്കെ കരഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ദൈവം ബാലന്റെ നിലവിളി കേട്ടു; ദൈവത്തിന്റെ ദൂതൻ ആകാശത്തു നിന്നു ഹാഗാരിനെ വിളിച്ചു അവളോടു: ഹാഗാരേ, നിനക്കു എന്തു? നീ ഭയപ്പെടേണ്ടാ; ബാലൻ ഇരിക്കുന്നേടത്തുനിന്നു അവന്റെ നിലവിളി ദൈവം കേട്ടിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","നീ ചെന്നു ബാലനെ താങ്ങി എഴുന്നേല്പിച്ചുകൊൾക; ഞാൻ അവനെ ഒരു വലിയ ജാതിയാക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ദൈവം അവളുടെ കണ്ണു തുറന്നു; അവൾ ഒരു നീരുറവു കണ്ടു, ചെന്നു തുരുത്തിയിൽ വെള്ളം നിറച്ചു ബാലനെ കുടിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ദൈവം ബാലനോടുകൂടെ ഉണ്ടായിരുന്നു; അവൻ മരുഭൂമിയിൽ പാർത്തു, മുതിർന്നപ്പോൾ ഒരു വില്ലാളിയായി തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","അവൻ പാരാൻമരുഭൂമിയിൽ പാർത്തു; അവന്റെ അമ്മ മിസ്രയീംദേശത്തുനിന്നു അവന്നു ഒരു ഭാര്യയെ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","അക്കാലത്തു അബിമേലെക്കും അവന്റെ സേനാപതിയായ പീക്കോലും അബ്രാഹാമിനോടു സംസാരിച്ചു: നിന്റെ സകലപ്രവൃത്തിയിലും ദൈവം നിന്നോടുകൂടെയുണ്ടു; ");
INSERT INTO mal2015_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ആകയാൽ നീ എന്നോടോ എന്റെ സന്തതിയോടോ എന്റെ കുലത്തോടോ വ്യാജം പ്രവൃത്തിക്കാതെ ഞാൻ നിന്നോടു ദയ കാണിച്ചതുപോലെ നീ എന്നോടും നീ പാർത്തുവരുന്ന ദേശത്തോടും ദയകാണിക്കുമെന്നു ദൈവത്തെച്ചൊല്ലി ഇവിടെവെച്ചു എന്നോടു സത്യം ചെയ്ക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","സത്യം ചെയ്യാം എന്നു അബ്രാഹാം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","എന്നാൽ അബീമേലെക്കിന്റെ ദാസന്മാർ അപഹരിച്ച കിണർ നിമിത്തം അബ്രാഹാം അബീമേലെക്കിനോടു ഭത്സിച്ചുപറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","അതിന്നു അബീമേലെക്ക്: ഇക്കാര്യം ചെയ്തതു ആരെന്നു ഞാൻ അറിയുന്നില്ല; നീ എന്നെ അറിയിച്ചിട്ടില്ല; ഇന്നല്ലാതെ ഞാൻ അതിനെക്കുറിച്ചു കേട്ടിട്ടുമില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","പിന്നെ അബ്രാഹാം അബീമേലെക്കിന്നു ആടുമാടുകളെ കൊടുത്തു; അവർ ഇരുവരും തമ്മിൽ ഉടമ്പടി ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","അബ്രാഹാം ഏഴു പെണ്ണാട്ടുകുട്ടികളെ വേറിട്ടു നിർത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","അപ്പോൾ അബീമേലെക്ക് അബ്രാഹാമിനോടു: നീ വേറിട്ടു നിർത്തിയ ഈ ഏഴു പെണ്ണാട്ടുകുട്ടികൾ എന്തിന്നു എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ഞാൻ ഈ കിണർ കുഴിച്ചു എന്നതിന്നു സാക്ഷിയായി നീ ഈ ഏഴു പെണ്ണാട്ടുകുട്ടികളെ എന്നോടു വാങ്ങേണം എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","അവർ ഇരുവരും അവിടെവെച്ചു സത്യം ചെയ്കകൊണ്ടു അവൻ ആ സ്ഥലത്തിന്നു ബേർ-ശേബ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ഇങ്ങനെ അവർ ബേർ-ശേബയിൽവെച്ചു ഉടമ്പടി ചെയ്തു. അബീമേലെക്കും അവന്റെ സേനാപതിയായ പീക്കോലും എഴുന്നേറ്റു ഫെലിസ്ത്യരുടെ ദേശത്തേക്കു മടങ്ങിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","അബ്രാഹാം ബേർ-ശേബയിൽ ഒരു പിചുലവൃക്ഷം നട്ടു, നിത്യദൈവമായ യഹോവയുടെ നാമത്തിൽ അവിടെവെച്ചു ആരാധന കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","അബ്രാഹാം കുറേക്കാലം ഫെലിസ്ത്യരുടെ ദേശത്തു പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","അതിന്റെ ശേഷം ദൈവം അബ്രാഹാമിനെ പരീക്ഷിച്ചതു എങ്ങനെയെന്നാൽ: അബ്രാഹാമേ, എന്നു വിളിച്ചതിന്നു: ഞാൻ ഇതാ എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","അപ്പോൾ അവൻ: നിന്റെ മകനെ, നീ സ്നേഹിക്കുന്ന നിന്റെ ഏകജാതനായ യിസ്ഹാക്കിനെ തന്നേ കൂട്ടിക്കൊണ്ടു മോരീയാദേശത്തു ചെന്നു, അവിടെ ഞാൻ നിന്നോടു കല്പിക്കുന്ന ഒരു മലയിൽ അവനെ ഹോമയാഗം കഴിക്ക എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","അബ്രാഹാം അതികാലത്തു എഴുന്നേറ്റു കഴുതെക്കു കോപ്പിട്ടു കെട്ടി ബാല്യക്കാരിൽ രണ്ടുപേരെയും തന്റെ മകൻ യിസ്ഹാക്കിനെയും കൂട്ടി ഹോമയാഗത്തിന്നു വിറകു കീറി എടുത്തുംകൊണ്ടു പുറപ്പെട്ടു, ദൈവം തന്നോടു കല്പിച്ച സ്ഥലത്തേക്കു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","മൂന്നാം ദിവസം അബ്രാഹാം നോക്കി ദൂരത്തു നിന്നു ആ സ്ഥലം കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","അബ്രാഹാം ബാല്യക്കാരോടു: നിങ്ങൾ കഴുതയുമായി ഇവിടെ ഇരിപ്പിൻ; ഞാനും ബാലനും അവിടത്തോളം ചെന്നു ആരാധന കഴിച്ചു മടങ്ങിവരാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","അബ്രാഹാം ഹോമയാഗത്തിന്നുള്ള വിറകു എടുത്തു തന്റെ മകനായ യിസ്ഹാക്കിന്റെ ചുമലിൽ വെച്ചു; തീയും കത്തിയും താൻ എടുത്തു; ഇരുവരും ഒന്നിച്ചു നടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","അപ്പോൾ യിസ്ഹാക്ക് തന്റെ അപ്പനായ അബ്രാഹാമിനോടു: അപ്പാ, എന്നു പറഞ്ഞതിന്നു അവൻ: എന്താകുന്നു മകനേ എന്നു പറഞ്ഞു. തീയും വിറകുമുണ്ടു; എന്നാൽ ഹോമയാഗത്തിന്നു ആട്ടിൻകുട്ടി എവിടെ എന്നു അവൻ ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ദൈവം തനിക്കു ഹോമയാഗത്തിന്നു ഒരു ആട്ടിൻകുട്ടിയെ നോക്കിക്കൊള്ളും, മകനേ, എന്നു അബ്രാഹാം പറഞ്ഞു. അങ്ങനെ അവർ ഇരുവരും ഒന്നിച്ചു നടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ദൈവം കല്പിച്ചിരുന്ന സ്ഥലത്തു അവർ എത്തി; അബ്രാഹാം ഒരു യാഗപീഠം പണിതു, വിറകു അടുക്കി, തന്റെ മകൻ യിസ്ഹാക്കിനെ കെട്ടി യാഗപീഠത്തിന്മേൽ വിറകിന്മീതെ കിടത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","പിന്നെ അബ്രാഹാം കൈ നീട്ടി തന്റെ മകനെ അറുക്കേണ്ടതിന്നു കത്തി എടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ഉടനെ യഹോവയുടെ ദൂതൻ ആകാശത്തുനിന്നു: അബ്രാഹാമേ, അബ്രാഹാമേ, എന്നു വിളിച്ചു; ഞാൻ ഇതാ, എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ബാലന്റെ മേൽ കൈവെക്കരുതു; അവനോടു ഒന്നും ചെയ്യരുതു; നിന്റെ ഏകജാതനായ മകനെ തരുവാൻ നീ മടിക്കായ്കകൊണ്ടു നീ ദൈവത്തെ ഭയപ്പെടുന്നു എന്നു ഞാൻ ഇപ്പോൾ അറിയുന്നു എന്നു അവൻ അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","അബ്രാഹാം തലപൊക്കി നോക്കിയപ്പോൾ പിമ്പുറത്തു ഒരു ആട്ടുകൊറ്റൻ കൊമ്പു കാട്ടിൽ പിടിപെട്ടു കിടക്കുന്നതു കണ്ടു; അബ്രാഹാം ചെന്നു ആട്ടുകൊറ്റനെ പിടിച്ചു തന്റെ മകന്നു പകരം ഹോമയാഗം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","അബ്രാഹാം ആ സ്ഥലത്തിന്നു യഹോവ യിരേ എന്നു പേരിട്ടു. യഹോവയുടെ പർവ്വതത്തിൽ അവൻ പ്രത്യക്ഷനാകും എന്നു ഇന്നുവരെയും പറഞ്ഞുവരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","യഹോവയുടെ ദൂതൻ രണ്ടാമതും ആകാശത്തുനിന്നു അബ്രാഹാമിനോടു വിളിച്ചു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","നീ ഈ കാര്യം ചെയ്തു, നിന്റെ ഏകജാതനായ മകനെ തരുവാൻ മടിക്കായ്കകൊണ്ടു ");
INSERT INTO mal2015_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ഞാൻ നിന്നെ ഐശ്വര്യമായി അനുഗ്രഹിക്കും; നിന്റെ സന്തതിയെ ആകാശത്തിലെ നക്ഷത്രങ്ങൾപോലെയും കടൽക്കരയിലെ മണൽപോലെയും അത്യന്തം വർദ്ധിപ്പിക്കും; നിന്റെ സന്തതി ശത്രുക്കളുടെ പട്ടണങ്ങളെ കൈവശമാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","നീ എന്റെ വാക്കു അനുസരിച്ചതു കൊണ്ടു നിന്റെ സന്തതി മുഖാന്തരം ഭൂമിയിലുള്ള സകലജാതികളും അനുഗ്രഹിക്കപ്പെടും എന്നു ഞാൻ എന്നെക്കൊണ്ടു തന്നേ സത്യം ചെയ്തിരിക്കുന്നു എന്നു യഹോവ അരുളിച്ചെയ്യുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","പിന്നെ അബ്രാഹാം ബാല്യക്കാരുടെ അടുക്കൽ മടങ്ങിവന്നു; അവർ ഒന്നിച്ചു പുറപ്പെട്ടു ബേർ-ശേബയിലേക്കു പോന്നു; അബ്രാഹാം ബേർ-ശേബയിൽ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","അനന്തരം മിൽക്കയും നിന്റെ സഹോദരനായ നാഹോരിന്നു മക്കളെ പ്രസവിച്ചിരിക്കുന്നു എന്നു അബ്രാഹാമിന്നു വർത്തമാനം കിട്ടി. ");
INSERT INTO mal2015_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","അവർ ആരെന്നാൽ: ആദ്യജാതൻ ഊസ്, അവന്റെ അനുജൻ ബൂസ്, അരാമിന്റെ പിതാവായ കെമൂവേൽ, ");
INSERT INTO mal2015_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","കേശെദ്, ഹസോ, പിൽദാശ്, യിദലാഫ്, ബെഥൂവേൽ. ");
INSERT INTO mal2015_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ബെഥൂവേൽ റിബെക്കയെ ജനിപ്പിച്ചു. ഈ എട്ടുപേരെ മിൽക്കാ അബ്രാഹാമിന്റെ സഹോദരനായ നാഹോരിന്നു പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","അവന്റെ വെപ്പാട്ടി രെയൂമാ എന്നവളും തേബഹ്, ഗഹാം, തഹശ്, മാഖാ എന്നിവരെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","സാറെക്കു നൂറ്റിരുപത്തേഴു വയസ്സു ആയിരുന്നു: ഇതു സാറയുടെ ആയുഷ്കാലം. ");
INSERT INTO mal2015_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","സാറാ കനാൻദേശത്തു ഹെബ്രോൻ എന്ന കിര്യത്തർബ്ബയിൽവെച്ചു മരിച്ചു; അബ്രാഹാം സാറയെക്കുറിച്ചു വിലപിച്ചു കരവാൻ വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","പിന്നെ അബ്രാഹാം മരിച്ചവളുടെ അടുക്കൽ നിന്നു എഴുന്നേറ്റു ഹിത്യരോടു സംസാരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","ഞാൻ നിങ്ങളുടെ ഇടയിൽ പരദേശിയും വന്നു പാർക്കുന്നവനും ആകുന്നു; ഞാൻ എന്റെ മരിച്ചവളെ കൊണ്ടുപോയി അടക്കേണ്ടതിന്നു എനിക്കു നിങ്ങളുടെ ഇടയിൽ ഒരു ശ്മശാനഭൂമി അവകാശമായി തരുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ഹിത്യർ അബ്രാഹാമിനോടു: യജമാനനേ, കേട്ടാലും: ");
INSERT INTO mal2015_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","നീ ഞങ്ങളുടെ ഇടയിൽ ദൈവത്തിന്റെ ഒരു പ്രഭുവാകുന്നു; ഞങ്ങളുടെ ശ്മശാനസ്ഥലങ്ങളിൽവെച്ചു വിശേഷമായതിൽ മരിച്ചവളെ അടക്കിക്കൊൾക; മരിച്ചവളെ അടക്കുവാൻ ഞങ്ങളിൽ ആരും ശ്മശാനസ്ഥലം നിനക്കു തരാതിരിക്കയില്ല എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","അപ്പോൾ അബ്രാഹാം എഴുന്നേറ്റു ആ ദേശക്കാരായ ഹിത്യരെ നമസ്കരിച്ചു അവരോടു സംസാരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","എന്റെ മരിച്ചവളെ കൊണ്ടുപോയി അടക്കുവാൻ സമ്മതമുണ്ടെങ്കിൽ നിങ്ങൾ എന്റെ അപേക്ഷ കേട്ടു എനിക്കുവേണ്ടി സോഹരിന്റെ മകനായ എഫ്രോനോടു, ");
INSERT INTO mal2015_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","അവൻ തന്റെ നിലത്തിന്റെ അറുതിയിൽ തനിക്കുള്ള മക്പേലാ എന്ന ഗുഹ എനിക്കു തരേണ്ടതിന്നു അപേക്ഷിപ്പിൻ; നിങ്ങളുടെ ഇടയിൽ ശ്മശാനാവകാശമായിട്ടു അവൻ അതിനെ പിടിപ്പതു വിലെക്കു തരേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","എന്നാൽ എഫ്രോൻ ഹിത്യരുടെ നടുവിൽ ഇരിക്കയായിരുന്നു; ഹിത്യനായ എഫ്രോൻ തന്റെ നഗരവാസികളായ ഹിത്യർ എല്ലാവരും കേൾക്കെ അബ്രാഹാമിനോടു: ");
INSERT INTO mal2015_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","അങ്ങനെയല്ല, യജമാനനേ, കേൾക്കേണമേ; നിലം ഞാൻ നിനക്കു തരുന്നു; അതിലെ ഗുഹയും നിനക്കു തരുന്നു; എന്റെ സ്വജനം കാൺകെ തരുന്നു; മരിച്ചവളെ അടക്കം ചെയ്തുകൊണ്ടാലും എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","അപ്പോൾ അബ്രാഹാം ദേശത്തിലെ ജനത്തെ നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ദേശത്തിലെ ജനം കേൾക്കെ അവൻ എഫ്രോനോടു: ദയ ചെയ്തു കേൾക്കേണം; നിലത്തിന്റെ വില ഞാൻ നിനക്കു തരുന്നതു എന്നോടു വാങ്ങേണം; എന്നാൽ ഞാൻ മരിച്ചവളെ അവിടെ അടക്കം ചെയ്യും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","എഫ്രോൻ അബ്രാഹാമിനോടു: യജമാനനേ, കേട്ടാലും: ");
INSERT INTO mal2015_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","നാനൂറു ശേക്കെൽ വെള്ളി വിലയുള്ള ഒരു ഭൂമി, അതു എനിക്കും നിനക്കും എന്തുള്ളു? മരിച്ചവളെ അടക്കം ചെയ്തുകൊൾക എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","അബ്രാഹാം എഫ്രോന്റെ വാക്കു സമ്മതിച്ചു ഹിത്യർ കേൾക്കെ എഫ്രോൻ പറഞ്ഞതുപോലെ കച്ചവടക്കാർക്കു നടപ്പുള്ള വെള്ളിശേക്കെൽ നാനൂറു അവന്നു തൂക്കിക്കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ഇങ്ങനെ മമ്രേക്കരികെ എഫ്രോന്നുള്ള മക്പേലാനിലവും അതിലെ ഗുഹയും നിലത്തിന്റെ അതിർക്കകത്തുള്ള സകലവൃക്ഷങ്ങളും ");
INSERT INTO mal2015_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","അവന്റെ നഗരവാസികളായ ഹിത്യരുടെ മുമ്പാകെ അബ്രാഹാമിന്നു അവകാശമായി ഉറെച്ചുകിട്ടി. ");
INSERT INTO mal2015_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","അതിന്റെ ശേഷം അബ്രാഹാം തന്റെ ഭാര്യയായ സാറയെ കനാൻദേശത്തിലെ ഹെബ്രോൻ എന്ന മമ്രേക്കരികെയുള്ള മക്പേലാ നിലത്തിലെ ഗുഹയിൽ അടക്കം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ഇങ്ങനെ ഹിത്യർ ആ നിലവും അതിലെ ഗുഹയും അബ്രാഹാമിന്നു ശ്മശാനാവകാശമായി ഉറപ്പിച്ചുകൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","അബ്രാഹാം വയസ്സുചെന്നു വൃദ്ധനായി; യഹോവ അബ്രാഹാമിനെ സകലത്തിലും അനുഗ്രഹിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","തന്റെ വീട്ടിൽ മൂപ്പനും തനിക്കുള്ളതിന്നൊക്കെയും വിചാരകനുമായ ദാസനോടു അബ്രാഹാം പറഞ്ഞതു: നിന്റെ കൈ എന്റെ തുടയിൻ കീഴിൽ വെക്കുക; ");
INSERT INTO mal2015_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ചുറ്റും പാർക്കുന്ന കനാന്യരുടെ കന്യകമാരിൽനിന്നു നീ എന്റെ മകന്നു ഭാര്യയെ എടുക്കാതെ, ");
INSERT INTO mal2015_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","എന്റെ ദേശത്തും എന്റെ ചാർച്ചക്കാരുടെ അടുക്കലും ചെന്നു എന്റെ മകനായ യിസ്ഹാക്കിന്നു ഭാര്യയെ എടുക്കുമെന്നു സ്വർഗ്ഗത്തിന്നും ഭൂമിക്കും ദൈവമായ യഹോവയുടെ നാമത്തിൽ ഞാൻ നിന്നെക്കൊണ്ടു സത്യം ചെയ്യിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ദാസൻ അവനോടു: പക്ഷേ സ്ത്രീക്കു എന്നോടുകൂടെ ഈ ദേശത്തേക്കു വരുവാൻ മനസ്സില്ലെങ്കിലോ? നീ വിട്ടുപോന്ന ദേശത്തേക്കു ഞാൻ നിന്റെ മകനെ മടക്കിക്കൊണ്ടുപോകേണമോ എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","അബ്രാഹാം അവനോടു പറഞ്ഞതു: എന്റെ മകനെ അവിടെക്കു മടക്കിക്കൊണ്ടു പോകാതിരിപ്പാൻ സൂക്ഷിച്ചുകൊൾക. ");
INSERT INTO mal2015_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","എന്റെ പിതൃഭവനത്തിൽനിന്നും ജന്മദേശത്തുനിന്നും എന്നെ കൊണ്ടുവന്നവനും എന്നോടു അരുളിച്ചെയ്തവനും നിന്റെ സന്തതിക്കു ഞാൻ ഈ ദേശം കൊടുക്കുമെന്നു എന്നോടു സത്യം ചെയ്തവനുമായി സ്വർഗ്ഗത്തിന്റെ ദൈവമായ യഹോവ എന്റെ മകന്നു നീ ഒരു ഭാര്യയെ അവിടെനിന്നു കൊണ്ടുവരുവാൻ തക്കവണ്ണം നിനക്കു മുമ്പായി തന്റെ ദൂതനെ അയക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","എന്നാൽ സ്ത്രീക്കു നിന്നോടുകൂടെ വരുവാൻ മനസ്സില്ലെങ്കിൽ നീ ഈ സത്യത്തിൽ നിന്നു ഒഴിഞ്ഞിരിക്കും; എന്റെ മകനെ അവിടേക്കു മടക്കിക്കൊണ്ടുപോക മാത്രം അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","അപ്പോൾ ദാസൻ തന്റെ യജമാനനായ അബ്രാഹാമിന്റെ തുടയിൻകീഴിൽ കൈവെച്ചു അങ്ങനെ അവനോടു സത്യം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","അനന്തരം ആ ദാസൻ തന്റെ യജമാനന്റെ ഒട്ടകങ്ങളിൽ പത്തു ഒട്ടകങ്ങളെയും യജമാനന്നുള്ള വിവിധമായ വിശേഷവസ്തുക്കളെയും കൊണ്ടു പുറപ്പെട്ടു മെസൊപ്പൊത്താമ്യയിൽ നാഹോരിന്റെ പട്ടണത്തിൽ ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","വൈകുന്നേരം സ്ത്രീകൾ വെള്ളം കോരുവാൻ വരുന്ന സമയത്തു അവൻ ഒട്ടകങ്ങളെ പട്ടണത്തിന്നു പുറത്തു ഒരു കിണറ്റിന്നരികെ നിറുത്തി പറഞ്ഞതെന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","എന്റെ യജമാനനായ അബ്രാഹാമിന്റെ ദൈവമായ യഹോവേ, എന്റെ യജമാനനായ അബ്രാഹാമിനോടു കൃപചെയ്തു ഇന്നുതന്നേ കാര്യം സാധിപ്പിച്ചുതരേണമേ. ");
INSERT INTO mal2015_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ഇതാ, ഞാൻ കിണറ്റിന്നരികെ നില്ക്കുന്നു; ഈ പട്ടണക്കാരുടെ കന്യകമാർ വെള്ളം കോരുവാൻ വരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","നിന്റെ പാത്രം ഇറക്കി എനിക്കു കുടിപ്പാൻ തരേണം എന്നു ഞാൻ പറയുമ്പോൾ: കുടിക്ക; നിന്റെ ഒട്ടകങ്ങൾക്കും കുടിപ്പാൻ കൊടുക്കാമെന്നു പറയുന്ന സ്ത്രീ തന്നേ നീ നിന്റെ ദാസനായ യിസ്ഹാക്കിന്നു നിയമിച്ചവളായിരിക്കട്ടെ; നീ എന്റെ യജമാനനോടു കൃപ ചെയ്തു എന്നു ഞാൻ അതിനാൽ ഗ്രഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","അവൻ പറഞ്ഞു തീരുംമുമ്പെ അബ്രാഹാമിന്റെ സഹോദരനായ നാഹോരിന്റെ ഭാര്യ മിൽക്കയുടെ മകൻ ബെഥൂവേലിന്റെ മകൾ റിബെക്കാ തോളിൽ പാത്രവുമായി വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ബാല അതിസുന്ദരിയും പുരുഷൻ തൊടാത്ത കന്യകയും ആയിരുന്നു; അവൾ കിണറ്റിൽ ഇറങ്ങി പാത്രം നിറച്ചു കയറിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ദാസൻ വേഗത്തിൽ അവളെ എതിരേറ്റു ചെന്നു: നിന്റെ പാത്രത്തിലെ വെള്ളം കുറെ എനിക്കു കുടിപ്പാൻ തരേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","യജമാനനേ, കുടിക്ക എന്നു അവൾ പറഞ്ഞു വേഗം പാത്രം കയ്യിൽ ഇറക്കി അവന്നു കുടിപ്പാൻ കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","അവന്നു കുടിപ്പാൻ കൊടുത്ത ശേഷം: നിന്റെ ഒട്ടകങ്ങൾക്കും വേണ്ടുവോളം ഞാൻ കോരിക്കൊടുക്കാം എന്നു പറഞ്ഞു, ");
INSERT INTO mal2015_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","പാത്രത്തിലെ വെള്ളം വേഗം തൊട്ടിയിൽ ഒഴിച്ചു, പിന്നെയും കോരിക്കൊണ്ടുവരുവാൻ കിണറ്റിലേക്കു ഓടി ഇറങ്ങി അവന്റെ ഒട്ടകങ്ങൾക്കും എല്ലാം കോരിക്കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ആ പുരുഷൻ അവളെ ഉറ്റുനോക്കി, യഹോവ തന്റെ യാത്രയെ സഫലമാക്കിയോ ഇല്ലയോ എന്നു അറിയേണ്ടതിന്നു മിണ്ടാതിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ഒട്ടകങ്ങൾ കുടിച്ചു തീർന്നപ്പോൾ അവൻ അര ശേക്കെൽ തൂക്കമുള്ള ഒരു പൊന്മൂക്കുത്തിയും അവളുടെ കൈക്കിടുവാൻ പത്തു ശേക്കെൽ തൂക്കമുള്ള രണ്ടു പൊൻവളയും എടുത്തു അവളോടു: ");
INSERT INTO mal2015_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","നീ ആരുടെ മകൾ? പറക; നിന്റെ അപ്പന്റെ വീട്ടിൽ ഞങ്ങൾക്കു രാപാർപ്പാൻ സ്ഥലമുണ്ടോ എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","അവൾ അവനോടു: നാഹോരിന്നു മിൽക്കാ പ്രസവിച്ച മകനായ ബെഥൂവേലിന്റെ മകൾ ആകുന്നു ഞാൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ഞങ്ങളുടെയവിടെ വയ്ക്കോലും തീനും വേണ്ടുവോളം ഉണ്ടു; രാപാർപ്പാൻ സ്ഥലവും ഉണ്ടു എന്നും അവൾ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","അപ്പോൾ ആ പുരുഷൻ കുനിഞ്ഞു യഹോവയെ നമസ്കരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","എന്റെ യജമാനനായ അബ്രാഹാമിന്റെ ദൈവമായ യഹോവ വാഴ്ത്തപ്പെട്ടവൻ; അവൻ എന്റെ യജമാനനോടുള്ള ദയയും വിശ്വസ്തതയും ഉപേക്ഷിച്ചിട്ടില്ല. ഈ യാത്രയിൽ യഹോവ എന്നെ എന്റെ യജമാനന്റെ സഹോദരന്മാരുടെ വീട്ടിലേക്കു നടത്തിക്കൊണ്ടുവന്നുവല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ബാല ഓടിച്ചെന്നു അമ്മയുടെ വീട്ടുകാരെ ഈ വസ്തുത അറിയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","റിബെക്കെക്കു ഒരു സഹോദരൻ ഉണ്ടായിരുന്നു; അവന്നു ലാബാൻ എന്നു പേർ. ലാബാൻ പുറത്തു കിണറ്റിങ്കൽ ആ പുരുഷന്റെ അടുക്കൽ ഓടിച്ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","അവൻ മൂക്കുത്തിയും സഹോദരിയുടെ കൈമേൽ വളയും കാണുകയും ആ പുരുഷൻ ഇന്നപ്രകാരം എന്നോടു പറഞ്ഞു എന്നു തന്റെ സഹോദരിയായ റിബെക്കയുടെ വാക്കു കേൾക്കയും ചെയ്തപ്പോൾ ആ പുരുഷന്റെ അടുക്കൽ ചെന്നു; അവൻ കിണറ്റിങ്കൽ ഒട്ടകങ്ങളുടെ അരികെ നിൽക്കയായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","അപ്പോൾ അവൻ: യഹോവയാൽ അനുഗ്രഹിക്കപ്പെട്ടവനേ, അകത്തു വരിക; എന്തിന്നു പുറത്തു നില്ക്കുന്നു? വീടും ഒട്ടകങ്ങൾക്കു സ്ഥലവും ഞാൻ ഒരുക്കിയിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","അങ്ങനെ ആ പുരുഷൻ വീട്ടിൽ ചെന്നു. അവൻ ഒട്ടകങ്ങളെ കോപ്പഴിച്ചു ഒട്ടകങ്ങൾക്കു വയ്ക്കോലും തീനും അവന്നും കൂടെയുള്ളവർക്കും കാലുകളെ കഴുകുവാൻ വെള്ളവും കൊടുത്തു, അവന്റെ മുമ്പിൽ ഭക്ഷണം വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ഞാൻ വന്ന കാര്യം അറിയിക്കും മുമ്പെ ഭക്ഷണം കഴിക്കയില്ല എന്നു അവൻ പറഞ്ഞു. പറക എന്നു അവനും പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","അപ്പോൾ അവൻ പറഞ്ഞതു: ഞാൻ അബ്രാഹാമിന്റെ ദാസൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","യഹോവ എന്റെ യജമാനനെ ഏറ്റവും അനുഗ്രഹിച്ചു അവൻ മഹാനായിത്തീർന്നു; അവൻ അവന്നു ആടു, മാടു, പൊന്നു, വെള്ളി, ദാസീദാസന്മാർ, ഒട്ടകങ്ങൾ കഴുതകൾ എന്നീവകയൊക്കെയും കൊടുത്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","എന്റെ യജമാനന്റെ ഭാര്യയായ സാറാ വൃദ്ധയായശേഷം എന്റെ യജമാനന്നു ഒരു മകനെ പ്രസവിച്ചു; അവൻ തനിക്കുള്ളതൊക്കെയും അവന്നു കൊടുത്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ഞാൻ പാർക്കുന്ന കനാൻദേശത്തിലെ കനാന്യകന്യകമാരിൽനിന്നു നീ എന്റെ മകന്നു ഭാര്യയെ എടുക്കാതെ, ");
INSERT INTO mal2015_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","എന്റെ പിതൃഭവനത്തിലും വംശക്കാരുടെ അടുക്കലും ചെന്നു എന്റെ മകന്നു ഭാര്യയെ എടുക്കേണമെന്നു പറഞ്ഞു യജമാനൻ എന്നെക്കൊണ്ടു സത്യം ചെയ്യിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ഞാൻ യജമാനനോടു: പക്ഷേ സ്ത്രീ എന്നോടുകൂടെ പേരുന്നില്ലെങ്കിലോ എന്നു പറഞ്ഞതിന്നു അവൻ എന്നോടു: ");
INSERT INTO mal2015_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ഞാൻ സേവിച്ചുപോരുന്ന യഹോവ തന്റെ ദൂതനെ നിന്നോടുകൂടെ അയച്ചു, നീ എന്റെ വംശത്തിൽനിന്നും പിതൃഭവനത്തിൽനിന്നും എന്റെ മകന്നു ഭാര്യയെ എടുപ്പാന്തക്കവണ്ണം നിന്റെ യാത്രയെ സഫലമാക്കും; ");
INSERT INTO mal2015_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","എന്റെ വംശക്കാരുടെ അടുക്കൽ ചെന്നാൽ നീ ഈ സത്യത്തിൽനിന്നു ഒഴിഞ്ഞിരിക്കും; അവർ നിനക്കു തരുന്നില്ല എന്നു വരികിലും നീ ഈ സത്യത്തിൽ നിന്നു ഒഴിഞ്ഞിരിക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","ഞാൻ ഇന്നു കിണറ്റിന്നരികെ വന്നപ്പോൾ പറഞ്ഞതു: എന്റെ യജമാനനായ അബ്രാഹാമിന്റെ ദൈവമായ യഹോവേ, ഞാൻ വന്നിരിക്കുന്ന ഈ യാത്രയെ നീ സഫലമാക്കി എങ്കിൽ‒ ");
INSERT INTO mal2015_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ഇതാ, ഞാൻ കിണറ്റിന്നരികെ നില്ക്കുന്നു; വെള്ളം കോരുവാൻ ഒരു കന്യക വരികയും ഞാൻ അവളോടു: നിന്റെ പാത്രത്തിലെ വെള്ളം കുറെ എനിക്കു കുടിപ്പാൻ തരിക എന്നു പറയുമ്പോൾ, ");
INSERT INTO mal2015_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","അവൾ എന്നോടു: കുടിക്ക, ഞാൻ നിന്റെ ഒട്ടകങ്ങൾക്കും കോരി കൊടുക്കാമെന്നു പറകയും ചെയ്താൽ അവൾ തന്നേ യഹോവ എന്റെ യജമാനന്റെ മകന്നു നിയമിച്ച സ്ത്രീയായിരിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ഞാൻ ഇങ്ങനെ ഹൃദയത്തിൽ പറഞ്ഞു തീരുമ്മുമ്പെ ഇതാ, റിബെക്കാ തോളിൽ പാത്രവുമായി വന്നു കിണറ്റിൽ ഇറങ്ങി വെള്ളം കോരി; ഞാൻ അവളോടു: എനിക്കു കുടിപ്പാൻ തരേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","അവൾ വേഗം തോളിൽനിന്നു പാത്രം ഇറക്കി: കുടിക്ക, ഞാൻ നിന്റെ ഒട്ടകങ്ങൾക്കും കുടിപ്പാൻ കൊടുക്കാം എന്നു പറഞ്ഞു. അങ്ങനെ ഞാൻ കുടിച്ചു; അവൾ ഒട്ടകങ്ങൾക്കും കുടിപ്പാൻ കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ഞാൻ അവളോടു: നീ ആരുടെ മകൾ എന്നു ചോദിച്ചതിന്നു അവൾ: മിൽക്കാ നാഹോരിന്നു പ്രസവിച്ച മകനായ ബെഥൂവേലിന്റെ മകൾ എന്നു പറഞ്ഞു. ഞാൻ അവളുടെ മൂക്കിന്നു മൂക്കുത്തിയും കൈകൾക്കു വളയും ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ഞാൻ കുനിഞ്ഞു യഹോവയെ നമസ്കരിച്ചു, എന്റെ യജമാനന്റെ സഹോദരന്റെ മകളെ അവന്റെ മകന്നായിട്ടു എടുപ്പാൻ എന്നെ നേർവ്വഴിക്കു കൊണ്ടുവന്നവനായി എന്റെ യജമാനൻ അബ്രാഹാമിന്റെ ദൈവമായ യഹോവയെ വാഴ്ത്തുകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ആകയാൽ നിങ്ങൾ എന്റെ യജമാനനോടു ദയയും വിശ്വസ്തതയും കാണിക്കുമെങ്കിൽ എന്നോടു പറവിൻ; അല്ല എന്നു വരികിൽ അതും പറവിൻ; എന്നാൽ ഞാൻ ഇടത്തോട്ടോ വലത്തോട്ടോ തിരിഞ്ഞുകൊള്ളാം. ");
INSERT INTO mal2015_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","അപ്പോൾ ലാബാനും ബെഥൂവേലും: ഈ കാര്യം യഹോവയാൽ വരുന്നു; നിന്നോടു ഗുണമെങ്കിലും ദോഷമെങ്കിലും പറവാൻ ഞങ്ങൾക്കു കഴികയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ഇതാ, റിബെക്കാ നിന്റെ മുമ്പാകെ ഉണ്ടല്ലോ; അവളെ കൂട്ടിക്കൊണ്ടുപോക; യഹോവ കല്പിച്ചതുപോലെ അവൾ നിന്റെ യജമാനന്റെ മകന്നു ഭാര്യയാകട്ടെ എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","അബ്രാഹാമിന്റെ ദാസൻ അവരുടെ വാക്കു കേട്ടപ്പോൾ യഹോവയെ സാഷ്ടാംഗം നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","പിന്നെ ദാസൻ വെള്ളിയാഭരണങ്ങളും പൊന്നാഭരണങ്ങളും വസ്ത്രങ്ങളും എടുത്തു റിബെക്കെക്കു കൊടുത്തു; അവളുടെ സഹോദരന്നും അമ്മെക്കും വിശേഷവസ്തുക്കൾ കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","അവനും കൂടെയുള്ളവരും ഭക്ഷിച്ചു പാനം ചെയ്തു രാപാർത്തു. രാവിലെ അവർ എഴുന്നേറ്റശേഷം അവൻ: എന്റെ യജമാനന്റെ അടുക്കൽ എന്നെ അയക്കേണമെന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","അതിന്നു അവളുടെ സഹോദരനും അമ്മയും: ബാല ഒരു പത്തുദിവസമെങ്കിലും ഞങ്ങളോടുകൂടെ പാർത്തിട്ടു പിന്നെ പോരട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","അവൻ അവരോടു: എന്നെ താമസിപ്പിക്കരുതേ; യഹോവ എന്റെ യാത്ര സഫലമാക്കിയിരിക്കുന്നുവല്ലോ; യജമാനന്റെ അടുക്കൽ പോകുവാൻ എന്നെ പറഞ്ഞയക്കേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ഞങ്ങൾ ബാലയെ വിളിച്ചു അവളോടു ചോദിക്കട്ടെ എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","അവർ റിബെക്കയെ വിളിച്ചു അവളോടു: നീ ഈ പുരുഷനോടുകൂടെ പോകുന്നുവോ എന്നു ചോദിച്ചു. ഞാൻ പോകുന്നു എന്നു അവൾ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","അങ്ങനെ അവർ തങ്ങളുടെ സഹോദരിയായ റിബെക്കയെയും അവളുടെ ധാത്രിയെയും അബ്രാഹാമിന്റെ ദാസനെയും അവന്റെ ആളുകളെയും പറഞ്ഞയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","അവർ റിബെക്കയെ അനുഗ്രഹിച്ചു അവളോടു: സഹോദരീ, നീ അനേകായിരമായി തീരുക; നിന്റെ സന്തതി, തന്നെ ദ്വേഷിക്കുന്നവരുടെ പടിവാതിൽ കൈവശമാക്കട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","പിന്നെ റിബെക്കയും അവളുടെ ദാസിമാരും എഴുന്നേറ്റു ഒട്ടകപ്പുറത്തു കയറി ആ പുരുഷനോടുകൂടെ പോയി; അങ്ങനെ ദാസൻ റിബെക്കയെ കൂട്ടിക്കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","എന്നാൽ യിസ്ഹാക്ക് ബേർലഹയിരോയീവരെ വന്നു; അവൻ തെക്കേദേശത്തു പാർക്കയായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","വൈകുന്നേരത്തു യിസ്ഹാക്ക് ധ്യാനിപ്പാൻ വെളിമ്പ്രദേശത്തു പോയിരുന്നു; അവൻ തലപൊക്കി നോക്കി ഒട്ടകങ്ങൾ വരുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","റിബെക്കയും തലപൊക്കി യിസ്ഹാക്കിനെ കണ്ടിട്ടു ഒട്ടകപ്പുറത്തുനിന്നു ഇറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","അവൾ ദാസനോടു: വെളിമ്പ്രദേശത്തു നമ്മെ എതിരേറ്റു വരുന്ന പുരുഷൻ ആരെന്നു ചോദിച്ചതിന്നു എന്റെ യജമാനൻ തന്നേ എന്നു ദാസൻ പറഞ്ഞു. അപ്പോൾ അവൾ ഒരു മൂടുപടം എടുത്തു തന്നെ മൂടി. ");
INSERT INTO mal2015_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","താൻ ചെയ്ത കാര്യം ഒക്കെയും ദാസൻ യിസ്ഹാക്കിനോടു വിവരിച്ചു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","യിസ്ഹാക്ക് അവളെ തന്റെ അമ്മയായ സാറയുടെ കൂടാരത്തിൽ കൊണ്ടുപോയി. അവൻ റിബെക്കയെ പരിഗ്രഹിച്ചു അവൾ അവന്നു ഭാര്യയായിത്തീർന്നു; അവന്നു അവളിൽ സ്നേഹമായി. ഇങ്ങനെ യിസ്ഹാക്കിന്നു തന്റെ അമ്മയുടെ മരണദുഃഖം തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","അബ്രാഹാം വേറൊരു ഭാര്യയെ പരിഗ്രഹിച്ചു; അവൾക്കു കെതൂറാ എന്നു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","അവൾ സിമ്രാൻ, യൊക്ശാൻ, മെദാൻ, മിദ്യാൻ, യിശ്ബാക്, ശൂവഹ് എന്നിവരെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","യൊക്ശാൻ ശെബയെയും ദെദാനെയും ജനിപ്പിച്ചു; ദെദാന്റെ പുത്രന്മാർ അശ്ശൂരീം, ലെത്തൂശീം, ലെയുമ്മീം എന്നിവർ. ");
INSERT INTO mal2015_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","മിദ്യാന്റെ പുത്രന്മാർ ഏഫാ, ഏഫെർ, ഹനോക്, അബീദാ, എൽദാഗാ എന്നിവർ. ഇവർ എല്ലാവരും കെതൂറയുടെ മക്കൾ. ");
INSERT INTO mal2015_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","എന്നാൽ അബ്രാഹാം തനിക്കുള്ളതൊക്കെയും യിസ്ഹാക്കിന്നു കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","അബ്രാഹാമിന്നു ഉണ്ടായിരുന്ന വെപ്പാട്ടികളുടെ മക്കൾക്കോ അബ്രാഹാം ദാനങ്ങൾ കൊടുത്തു; താൻ ജീവനോടിരിക്കുമ്പോൾ തന്നേ അവരെ തന്റെ മകനായ യിസ്ഹാക്കിന്റെ അടുക്കൽനിന്നു കിഴക്കോട്ടു കിഴക്കുദേശത്തേക്കു അയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","അബ്രാഹാമിന്റെ ആയുഷ്കാലം നൂറ്റെഴുപത്തഞ്ചു സംവത്സരം ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","അബ്രാഹാം വയോധികനും കാലസമ്പൂർണ്ണനുമായി നല്ല വാർദ്ധക്യത്തിൽ പ്രാണനെ വിട്ടു മരിച്ചു, തന്റെ ജനത്തോടു ചേർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","അവന്റെ പുത്രന്മാരായ യിസ്ഹാക്കും യിശ്മായേലും കൂടി മമ്രേക്കരികെ സോഹരിന്റെ മകനായ എഫ്രോനെന്ന ഹിത്യന്റെ നിലത്തു മക്പേലാഗുഹയിൽ അവനെ അടക്കം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","അബ്രാഹാം ഹിത്യരോടു വിലെക്കു വാങ്ങിയ നിലത്തു തന്നേ; അവിടെ അബ്രാഹാമിനെയും അവന്റെ ഭാര്യയായ സാറയെയും അടക്കം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","അബ്രാഹാം മരിച്ചശേഷം ദൈവം അവന്റെ മകനായ യിസ്ഹാക്കിനെ അനുഗ്രഹിച്ചു; യിസ്ഹാക്ക് ബേർലഹയിരോയീക്കരികെ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","സാറയുടെ മിസ്രയീമ്യദാസി ഹാഗാർ അബ്രാഹാമിന്നു പ്രസവിച്ച മകനായ യിശ്മായേലിന്റെ വംശപാരമ്പര്യം: ");
INSERT INTO mal2015_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","അവരുടെ വംശാവലിപ്രകാരം പേരുപേരായി യിശ്മായേലിന്റെ പുത്രന്മാരുടെ പേരുകൾ ആവിതു: യിശ്മായേലിന്റെ ആദ്യജാതൻ നെബായോത്ത്, ");
INSERT INTO mal2015_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","കേദാർ, അദ്ബെയേൽ, മിബ്ശാം, മിശ്മാ, ദൂമാ, ");
INSERT INTO mal2015_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","മശ്ശാ, ഹദാദ്, തേമാ, യെതൂർ, നാഫീശ്, കേദെമാ. ");
INSERT INTO mal2015_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","പന്ത്രണ്ടു പ്രഭുക്കന്മാരായ യിശ്മായേലിന്റെ പുത്രന്മാർ അവരുടെ ഊരുകളിലും പാളയങ്ങളിലും വംശംവംശമായി ഇവർ ആകുന്നു; അവരുടെ പേരുകൾ ഇവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","യിശ്മായേലിന്റെ ആയുഷ്കാലം നൂറ്റി മുപ്പത്തേഴു സംവത്സരം ആയിരുന്നു; അവൻ പ്രാണനെ വിട്ടു മരിച്ചു, തന്റെ ജനത്തോടു ചേർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ഹവീലാ തുടങ്ങി അശ്ശൂരിലേക്കു പോകുന്ന വഴിയിൽ മിസ്രയീമിന്നു കിഴക്കുള്ള ശൂർവരെ അവർ കുടിയിരുന്നു; അവൻ തന്റെ സകലസഹോദരന്മാർക്കും എതിരെ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","അബ്രാഹാമിന്റെ മകനായ യിസ്ഹാക്കിന്റെ വംശപാരമ്പര്യമാവിതു: അബ്രാഹാം യിസ്ഹാക്കിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","യിസ്ഹാക്കിന്നു നാല്പതു വയസ്സായപ്പോൾ അവൻ പദ്ദൻ-അരാമിലുള്ള അരാമ്യനായ ബെഥൂവേലിന്റെ പുത്രിയും അരാമ്യനായ ലാബാന്റെ സഹോദരിയുമായ റിബെക്കയെ ഭാര്യയായി പരിഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","തന്റെ ഭാര്യ മച്ചിയായിരുന്നതുകൊണ്ടു യിസ്ഹാക്ക് അവൾക്കു വേണ്ടി യഹോവയോടു പ്രാർത്ഥിച്ചു; യഹോവ അവന്റെ പ്രാർത്ഥന കേട്ടു; അവന്റെ ഭാര്യ റിബെക്കാ ഗർഭംധരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","അവളുടെ ഉള്ളിൽ ശിശുക്കൾ തമ്മിൽ തിക്കിയപ്പോൾ അവൾ: ഇങ്ങനെയായാൽ ഞാൻ എന്തിന്നു ജീവിക്കുന്നു എന്നു പറഞ്ഞു യഹോവയോടു ചോദിപ്പാൻ പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","യഹോവ അവളോടു: രണ്ടുജാതികൾ നിന്റെ ഗർഭത്തിൽ ഉണ്ടു. രണ്ടു വംശങ്ങൾ നിന്റെ ഉദരത്തിൽനിന്നു തന്നേ പിരിയും; ഒരു വംശം മറ്റേ വംശത്തിലും ശക്തിപ്പെടും മൂത്തവൻ ഇളയവനെ സേവിക്കും. എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","അവൾക്കു പ്രസവകാലം തികഞ്ഞപ്പോൾ ഇരട്ടപ്പിള്ളകൾ അവളുടെ ഗർഭത്തിൽ ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ഒന്നാമത്തവൻ ചുവന്നവനായി പുറത്തുവന്നു, മേൽ മുഴുവനും രോമംകൊണ്ടുള്ള വസ്ത്രംപോലെ ഇരുന്നു; അവന്നു ഏശാവ് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","പിന്നെ അവന്റെ സഹോദരൻ പുറത്തുവന്നു; അവന്റെ കൈ ഏശാവിന്റെ കുതികാൽ പിടിച്ചിരുന്നു; അവന്നു യാക്കോബ് എന്നു പേരിട്ടു. അവൾ അവരെ പ്രസവിച്ചപ്പോൾ യിസ്ഹാക്കിന്നു അറുപതു വയസ്സു ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","കുട്ടികൾ വളർന്നു; ഏശാവ് വേട്ടയിൽ സമർത്ഥനും വനസഞ്ചാരിയും യാക്കോബ് സാധുശീലനും കൂടാരവാസിയും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ഏശാവിന്റെ വേട്ടയിറച്ചിയിൽ രുചി പിടിച്ചിരുന്നതുകൊണ്ടു യിസ്ഹാക്ക് അവനെ സ്നേഹിച്ചു; റിബെക്കയോ യാക്കോബിനെ സ്നേഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ഒരിക്കൽ യാക്കോബ് ഒരു പായസം വെച്ചു; ഏശാവ് വെളിമ്പ്രദേശത്തുനിന്നു വന്നു; അവൻ നന്നാ ക്ഷീണിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ഏശാവ് യാക്കോബിനോടു: ആ ചുവന്ന പായസം കുറെ എനിക്കു തരേണം; ഞാൻ നന്നാ ക്ഷീണിച്ചിരിക്കുന്നു എന്നു പറഞ്ഞു. അതുകൊണ്ടു അവന്നു ഏദോം (ചുവന്നവൻ) എന്നു പേരായി. ");
INSERT INTO mal2015_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","നിന്റെ ജ്യേഷ്ഠാവകാശം ഇന്നു എനിക്കു വില്ക്കുക എന്നു യാക്കോബ് പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","അതിന്നു ഏശാവ്: ഞാൻ മരിക്കേണ്ടിവരുമല്ലോ; ഈ ജ്യേഷ്ഠാവകാശം എനിക്കു എന്തിന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ഇന്നു എന്നോടു സത്യം ചെയ്ക എന്നു യാക്കോബ് പറഞ്ഞു. അവൻ അവനോടു സത്യം ചെയ്തു; തന്റെ ജ്യേഷ്ഠാവകാശം യാക്കോബിന്നു വിറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","യാക്കോബ് ഏശാവിന്നു അപ്പവും പയറു കൊണ്ടുള്ള പായസവും കൊടുത്തു; അവൻ ഭക്ഷിച്ചു പാനം ചെയ്തു, എഴുന്നേറ്റുപോയി; ഇങ്ങനെ ഏശാവ് ജ്യേഷ്ഠാവകാശത്തെ അലക്ഷ്യമാക്കിക്കളഞ്ഞു ");
INSERT INTO mal2015_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","അബ്രാഹാമിന്റെ കാലത്തുണ്ടായ മുമ്പിലത്തെ ക്ഷാമം കൂടാതെ പിന്നെയും ആ ദേശത്തു ഒരു ക്ഷാമം ഉണ്ടായി. അപ്പോൾ യിസ്ഹാക്ക് ഗെരാരിൽ ഫെലിസ്ത്യരുടെ രാജാവായ അബീമേലെക്കിന്റെ അടുക്കൽ പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","യഹോവ അവന്നു പ്രത്യക്ഷനായി അരുളിച്ചെയ്തതെന്തെന്നാൽ: നീ മിസ്രയീമിലേക്കു പോകരുതു; ഞാൻ നിന്നോടു കല്പിക്കുന്ന ദേശത്തു പാർക്ക. ");
INSERT INTO mal2015_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ഈ ദേശത്തു താമസിക്ക; ഞാൻ നിന്നോടുകൂടെ ഇരുന്നു നിന്നെ അനുഗ്രഹിക്കും; നിനക്കും നിന്റെ സന്തതിക്കും ഈ ദേശം ഒക്കെയും തരും; നിന്റെ പിതാവായ അബ്രാഹാമിനോടു ഞാൻ ചെയ്ത സത്യം നിവർത്തിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","അബ്രാഹാം എന്റെ വാക്കു കേട്ടു എന്റെ നിയോഗവും കല്പനകളും ചട്ടങ്ങളും പ്രമാണങ്ങളും ആചരിച്ചതുകൊണ്ടു ");
INSERT INTO mal2015_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ഞാൻ നിന്റെ സന്തതിയെ ആകാശത്തിലെ നക്ഷത്രങ്ങളെപ്പോലെ വർദ്ധിപ്പിച്ചു നിന്റെ സന്തതിക്കു ഈ ദേശമൊക്കെയും കൊടുക്കും; നിന്റെ സന്തതി മുഖാന്തരം ഭൂമിയിലെ സകല ജാതികളും അനുഗ്രഹിക്കപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","അങ്ങനെ യിസ്ഹാക്ക് ഗെരാരിൽ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ആ സ്ഥലത്തെ ജനം അവന്റെ ഭാര്യയെക്കുറിച്ചു അവനോടു ചോദിച്ചു; അവൾ എന്റെ സഹോദരിയെന്നു അവൻ പറഞ്ഞു; റിബെക്കാ സൗന്ദര്യമുള്ളവളാകകൊണ്ടു ആ സ്ഥലത്തെ ജനം അവളുടെ നിമിത്തം തന്നേ കൊല്ലാതിരിക്കേണ്ടതിന്നു അവൾ എന്റെ ഭാര്യ എന്നു പറവാൻ അവൻ ശങ്കിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","അവൻ അവിടെ ഏറെക്കാലം പാർത്തശേഷം ഫെലിസ്ത്യരുടെ രാജാവായ അബീമേലെക്ക് കിളിവാതിൽക്കൽ കൂടി നോക്കി യിസ്ഹാക്ക് തന്റെ ഭാര്യയായ റിബെക്കയോടുകൂടെ വിനോദിക്കുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","അബീമേലെക്ക് യിസ്ഹാക്കിനെ വിളിച്ചു: അവൾ നിന്റെ ഭാര്യയാകുന്നു നിശ്ചയം; പിന്നെ എന്റെ സഹോദരിയെന്നു നീ പറഞ്ഞതു എങ്ങനെ എന്നു ചോദിച്ചതിന്നു യിസ്ഹാക്ക് അവനോടു: അവളുടെ നിമിത്തം മരിക്കാതിരിപ്പാൻ ആകുന്നു ഞാൻ അങ്ങനെ പറഞ്ഞതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","അപ്പോൾ അബീമേലെക്ക്: നീ ഞങ്ങളോടു ഈ ചെയ്തതു എന്തു? ജനത്തിൽ ആരെങ്കിലും നിന്റെ ഭാര്യയോടുകൂടെ ശയിപ്പാനും നീ ഞങ്ങളുടെ മേൽ കുറ്റം വരുത്തുവാനും സംഗതി വരുമായിരുന്നുവല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","പിന്നെ അബീമേലെക്ക്: ഈ പുരുഷനെയോ അവന്റെ ഭാര്യയെയോ തൊടുന്നവന്നു മരണശിക്ഷ ഉണ്ടാകും എന്നു സകലജനത്തോടും കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","യിസ്ഹാക്ക് ആ ദേശത്തു വിതെച്ചു; ആയാണ്ടിൽ നൂറുമേനി വിളവു കിട്ടി; യഹോവ അവനെ അനുഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","അവൻ വർദ്ധിച്ചു വർദ്ധിച്ചു മഹാധനവാനായിത്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","അവന്നു ആട്ടിൻ കൂട്ടങ്ങളും മാട്ടിൻ കൂട്ടങ്ങളും വളരെ ദാസീദാസന്മാരും ഉണ്ടായിരുന്നതുകൊണ്ടു ഫെലിസ്ത്യർക്കു അവനോടു അസൂയ തോന്നി. ");
INSERT INTO mal2015_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","എന്നാൽ അവന്റെ പിതാവായ അബ്രാഹാമിന്റെ കാലത്തു അവന്റെ പിതാവിന്റെ ദാസന്മാർ കുഴിച്ചിരുന്ന കിണറൊക്കെയും ഫെലിസ്ത്യർ മണ്ണിട്ടു നികത്തിക്കളഞ്ഞിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","അബീമേലെക്ക് യിസ്ഹാക്കിനോടു: നീ ഞങ്ങളെക്കാൾ ഏറ്റവും ബലവാനാകകൊണ്ടു ഞങ്ങളെ വിട്ടു പോക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","അങ്ങനെ യിസ്ഹാക്ക് അവിടെനിന്നു പുറപ്പെട്ടു ഗേരാർതാഴ്‌വരയിൽ കൂടാരമടിച്ചു, അവിടെ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","തന്റെ പിതാവായ അബ്രാഹാമിന്റെ കാലത്തു കുഴിച്ചതും അബ്രാഹാം മരിച്ചശേഷം ഫെലിസ്ത്യർ നികത്തിക്കളഞ്ഞതുമായ കിണറുകൾ യിസ്ഹാക്ക് പിന്നെയും കുഴിച്ചു തന്റെ പിതാവു അവെക്കു ഇട്ടിരുന്ന പേർ തന്നേ ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","യിസ്ഹാക്കിന്റെ ദാസന്മാർ ആ താഴ്‌വരയിൽ കുഴിച്ചു നീരുറവുള്ള ഒരു കിണറ് കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","അപ്പോൾ ഗെരാർദേശത്തിലെ ഇടയന്മാർ: ഈ വെള്ളം ഞങ്ങൾക്കുള്ളതു എന്നു പറഞ്ഞു യിസ്ഹാക്കിന്റെ ഇടയന്മാരോടു ശണ്ഠയിട്ടു; അവർ തന്നോടു ശണ്ഠയിട്ടതുകൊണ്ടു അവൻ ആ കിണറ്റിനു ഏശെക് എന്നു പേർ വിളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","അവർ മറ്റൊരു കിണറ് കുഴിച്ചു; അതിനെക്കുറിച്ചും അവർ ശണ്ഠയിട്ടതുകൊണ്ടു അവൻ അതിന്നു സിത്നാ എന്നു പേർ വിളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","അവൻ അവിടെനിന്നു മാറിപ്പോയി മറ്റൊരു കിണറ് കുഴിച്ചു; അതിനെക്കുറിച്ചു അവർ ശണ്ഠയിട്ടില്ല. യഹോവ ഇപ്പോൾ നമുക്കു ഇടം ഉണ്ടാക്കി നാം ദേശത്തു വർദ്ധിക്കുമെന്നു പറഞ്ഞു അവൻ അതിന്നു രെഹോബോത്ത് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","അവിടെ നിന്നു അവൻ ബേർ-ശേബെക്കു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","അന്നു രാത്രി യഹോവ അവന്നു പ്രത്യക്ഷനായി: ഞാൻ നിന്റെ പിതാവായ അബ്രാഹാമിന്റെ ദൈവം ആകുന്നു; നീ ഭയപ്പെടേണ്ടാ; ഞാൻ നിന്നോടുകൂടെ ഉണ്ടു; എന്റെ ദാസനായ അബ്രാഹാം നിമിത്തം ഞാൻ നിന്നെ അനുഗ്രഹിച്ചു നിന്റെ സന്തതിയെ വർദ്ധിപ്പിക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","അവിടെ അവൻ ഒരു യാഗപീഠം പണിതു, യഹോവയുടെ നാമത്തിൽ ആരാധിച്ചു. അവിടെ തന്റെ കൂടാരം അടിച്ചു; അവിടെയും യിസ്ഹാക്കിന്റെ ദാസന്മാർ ഒരു കിണറ് കുഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","അനന്തരം അബീമേലെക്കും സ്നേഹിതനായ അഹൂസത്തും സേനാപതിയായ ഫീക്കോലും ഗെരാരിൽനിന്നു അവന്റെ അടുക്കൽ വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","യിസ്ഹാക്ക് അവരോടു: നിങ്ങൾ എന്തിന്നു എന്റെ അടുക്കൽ വരുന്നു? നിങ്ങൾ എന്നെ ദ്വേഷിച്ചു നിങ്ങളുടെ ഇടയിൽനിന്നു അയച്ചുകളഞ്ഞുവല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","അതിന്നു അവർ: യഹോവ നിന്നോടുകൂടെയുണ്ടു എന്നു ഞങ്ങൾ സ്പഷ്ടമായി കണ്ടു; അതുകൊണ്ടു നമുക്കു തമ്മിൽ, ഞങ്ങൾക്കും നിനക്കും തമ്മിൽ തന്നേ, ഒരു സത്യബന്ധമുണ്ടായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ഞങ്ങൾ നിന്നെ തൊട്ടിട്ടില്ലാത്തതുപോലെയും നന്മമാത്രം നിനക്കു ചെയ്തു നിന്നെ സമാധാനത്തോടെ അയച്ചതുപോലെയും നീ ഞങ്ങളോടു ഒരു ദോഷവും ചെയ്കയില്ല എന്നു ഞങ്ങളും നീയും തമ്മിൽ ഒരു ഉടമ്പടി ചെയ്ക. നീ യഹോവയാൽ അനുഗ്രഹിക്കപ്പെട്ടവനല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","അവൻ അവർക്കു ഒരു വിരുന്നു ഒരുക്കി; അവർ ഭക്ഷിച്ചു പാനം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","അവർ അതികാലത്തു എഴുന്നേറ്റു, തമ്മിൽ സത്യം ചെയ്തശേഷം യിസ്ഹാക്ക് അവരെ യാത്രയയച്ചു അവർ സമാധാനത്തോടെ പിരിഞ്ഞുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ആ ദിവസം തന്നേ യിസ്ഹാക്കിന്റെ ദാസന്മാർ വന്നു തങ്ങൾ കുഴിച്ച കിണറ്റിന്റെ വസ്തുത അവനെ അറിയിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ഞങ്ങൾ വെള്ളം കണ്ടു എന്നു പറഞ്ഞു. അവൻ അതിന്നു ശിബാ എന്നു പേരിട്ടു; അതുകൊണ്ടു ആ പട്ടണത്തിന്നു ഇന്നുവരെ ബേർ-ശേബ എന്നു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ഏശാവിന്നു നാല്പതു വയസ്സായപ്പോൾ അവൻ ഹിത്യനായ ബേരിയുടെ മകൾ യെഹൂദീത്തിനെയും ഹിത്യനായ ഏലോന്റെ മകൾ ബാസമത്തിനെയും ഭാര്യമാരായി പരിഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ഇവർ യിസ്ഹാക്കിന്നും റിബെക്കെക്കും മനോവ്യസനകാരണമായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","യിസ്ഹാക്ക് വൃദ്ധനായി അവന്റെ കണ്ണു കാണ്മാൻ വഹിയാതവണ്ണം മങ്ങിയപ്പോൾ അവൻ ഒരു ദിവസം മൂത്ത മകനായ ഏശാവിനെ വിളിച്ചു അവനോടു: മകനേ, എന്നു പറഞ്ഞു. അവൻ അവനോടു: ഞാൻ ഇതാ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","അപ്പോൾ അവൻ: ഞാൻ വൃദ്ധനായിരിക്കുന്നു; എന്റെ മരണദിവസം അറിയുന്നതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","നീ ഇപ്പോൾ നിന്റെ ആയുധങ്ങളായ വില്ലും പൂണിയും എടുത്തു കാട്ടിൽ ചെന്നു എനിക്കു വേണ്ടി വേട്ട തേടി ");
INSERT INTO mal2015_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","എനിക്കു ഇഷ്ടവും രുചികരവുമായ ഭോജനം ഉണ്ടാക്കി, ഞാൻ മരിക്കുമ്മുമ്പെ തിന്നു നിന്നെ അനുഗ്രഹിക്കേണ്ടതിന്നു എന്റെ അടുക്കൽ കൊണ്ടുവരിക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","യിസ്ഹാക്ക് തന്റെ മകനായ ഏശാവിനോടു പറയുമ്പൊൾ റിബെക്കാ കേട്ടു. ഏശാവോ വേട്ടതേടി കൊണ്ടുവരുവാൻ കാട്ടിൽ പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","റിബെക്കാ തന്റെ മകനായ യാക്കോബിനോടു പറഞ്ഞതു: നിന്റെ അപ്പൻ നിന്റെ സഹോദരനായ ഏശാവിനോടു സംസാരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ഞാൻ എന്റെ മരണത്തിന്നു മുമ്പെ തിന്നു നിന്നെ യഹോവയുടെ മുമ്പാകെ അനുഗ്രഹിക്കേണ്ടതിന്നു നീ വേട്ടയിറച്ചി കൊണ്ടുവന്നു രുചികരമായ ഭോജനം ഉണ്ടാക്കിത്തരിക എന്നു പറയുന്നതു ഞാൻ കേട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ആകയാൽ മകനേ, നീ എന്റെ വാക്കു കേട്ടു ഞാൻ നിന്നോടു കല്പിക്കുന്നതു ചെയ്ക. ");
INSERT INTO mal2015_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ആട്ടിൻകൂട്ടത്തിൽ ചെന്നു അവിടെനിന്നു രണ്ടു നല്ല കോലാട്ടിൻകുട്ടികളെ കൊണ്ടുവരിക; ഞാൻ അവയെക്കൊണ്ടു നിന്റെ അപ്പന്നു ഇഷ്ടവും രുചികരവുമായ ഭോജനം ഉണ്ടാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","നിന്റെ അപ്പൻ തിന്നു തന്റെ മരണത്തിന്നു മുമ്പെ അനുഗ്രഹിക്കേണ്ടതിന്നു നീ അതു അവന്റെ അടുക്കൽ കൊണ്ടുചെല്ലേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","അതിന്നു യാക്കോബ് തന്റെ അമ്മയായ റിബെക്കയോടു: എന്റെ സഹോദരനായ ഏശാവു രോമമുള്ളവനും ഞാൻ രോമമില്ലാത്തവനും ആകുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","പക്ഷേ അപ്പൻ എന്നെ തപ്പിനോക്കും; ഞാൻ ഉപായി എന്നു അവന്നു തോന്നീട്ടു ഞാൻ എന്റെ മേൽ അനുഗ്രഹമല്ല ശാപം തന്നേ വരുത്തും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","അവന്റെ അമ്മ അവനോടു: മകനേ, നിന്റെ ശാപം എന്റെ മേൽ വരട്ടെ; എന്റെ വാക്കു മാത്രം കേൾക്ക; പോയി കൊണ്ടുവാ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","അവൻ ചെന്നു പിടിച്ചു അമ്മയുടെ അടുക്കൽ കൊണ്ടുവന്നു; അമ്മ അവന്റെ അപ്പന്നു ഇഷ്ടവും രുചികരവുമായ ഭോജനം ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","പിന്നെ റിബെക്കാ വീട്ടിൽ തന്റെ പക്കൽ ഉള്ളതായ മൂത്തമകൻ ഏശാവിന്റെ വിശേഷവസ്ത്രം എടുത്തു ഇളയമകൻ യാക്കോബിനെ ധരിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","അവൾ കോലാട്ടിൻ കുട്ടികളുടെ തോൽകൊണ്ടു അവന്റെ കൈകളും രോമമില്ലാത്ത കഴുത്തും പൊതിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","താൻ ഉണ്ടാക്കിയ രുചികരമായ ഭോജനവും അപ്പവും തന്റെ മകനായ യാക്കോബിന്റെ കയ്യിൽ കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","അവൻ അപ്പന്റെ അടുക്കൽ ചെന്നു: അപ്പാ എന്നു പറഞ്ഞതിന്നു: ഞാൻ ഇതാ; നീ ആർ, മകനേ എന്നു അവൻ ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","യാക്കോബ് അപ്പനോടു: ഞാൻ നിന്റെ ആദ്യജാതൻ ഏശാവു; എന്നോടു കല്പിച്ചതു ഞാൻ ചെയ്തിരിക്കുന്നു; എഴുന്നേറ്റു ഇരുന്നു എന്റെ വേട്ടയിറച്ചി തിന്നു എന്നെ അനുഗ്രഹിക്കേണമേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","യിസ്ഹാക്ക് തന്റെ മകനോടു: മകനേ, നിനക്കു ഇത്ര വേഗത്തിൽ കിട്ടിയതു എങ്ങനെ എന്നു ചോദിച്ചതിന്നു നിന്റെ ദൈവമായ യഹോവ എന്റെ നേർക്കു വരുത്തിത്തന്നു എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","യിസ്ഹാക്ക് യാക്കോബിനോടു: മകനെ, അടുത്തുവരിക; നീ എന്റെ മകനായ ഏശാവു തന്നേയോ അല്ലയോ എന്നു ഞാൻ തപ്പിനോക്കട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","യാക്കോബ് തന്റെ അപ്പനായ യിസ്ഹാക്കിനോടു അടുത്തു ചെന്നു; അവൻ അവനെ തപ്പിനോക്കി: ശബ്ദം യാക്കോബിന്റെ ശബ്ദം; കൈകൾ ഏശാവിന്റെ കൈകൾ തന്നേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","അവന്റെ കൈകൾ സഹോദരനായ ഏശാവിന്റെ കൈകൾപോലെ രോമമുള്ളവയാകകൊണ്ടു അവൻ തിരിച്ചറിയാതെ അവനെ അനുഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","നീ എന്റെ മകൻ ഏശാവ് തന്നേയോ എന്നു അവൻ ചോദിച്ചതിന്നു: അതേ എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","അപ്പോൾ അവൻ: എന്റെ അടുക്കൽ കൊണ്ടുവാ; ഞാൻ നിന്നെ അനുഗ്രഹിക്കേണ്ടതിന്നു എന്റെ മകന്റെ വേട്ടയിറച്ചി ഞാൻ തിന്നാം എന്നു പറഞ്ഞു; അവൻ അടുക്കൽ കൊണ്ടു ചെന്നു, അവൻ തിന്നു; അവൻ വീഞ്ഞും കൊണ്ടുചെന്നു, അവൻ കുടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","പിന്നെ അവന്റെ അപ്പനായ യിസ്ഹാക്ക് അവനോടു: മകനേ, നീ അടുത്തുവന്നു എന്നെ ചുംബിക്ക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","അവൻ അടുത്തുചെന്നു അവനെ ചുംബിച്ചു; അവൻ അവന്റെ വസ്ത്രങ്ങളുടെ വാസന മണത്തു അവനെ അനുഗ്രഹിച്ചു പറഞ്ഞതു: ഇതാ, എന്റെ മകന്റെ വാസന ");
INSERT INTO mal2015_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","യഹോവ അനുഗ്രഹിച്ചിരിക്കുന്ന വയലിലെ വാസനപോലെ. ദൈവം ആകാശത്തിന്റെ മഞ്ഞും ഭൂമിയുടെ പുഷ്ടിയും ");
INSERT INTO mal2015_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","അനവധി ധാന്യവും വീഞ്ഞും നിനക്കു തരുമാറാകട്ടെ. വംശങ്ങൾ നിന്നെ സേവിക്കട്ടെ; ജാതികൾ നിന്നെ വണങ്ങട്ടെ; നിന്റെ സഹോദരന്മാർക്കു നീ പ്രഭുവായിരിക്ക; നിന്റെ മാതാവിന്റെ പുത്രന്മാർ നിന്നെ വണങ്ങട്ടെ. നിന്നെ ശപിക്കുന്നവൻ എല്ലാം ശപിക്കപ്പെട്ടവൻ; നിന്നെ അനുഗ്രഹിക്കുന്നവൻ എല്ലാം അനുഗ്രഹിക്കപ്പെട്ടവൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","യിസ്ഹാക്ക് യാക്കോബിനെ അനുഗ്രഹിച്ചു കഴിഞ്ഞപ്പോൾ യാക്കോബ് തന്റെ അപ്പനായ യിസ്ഹാക്കിന്റെ മുമ്പിൽനിന്നു പുറപ്പെട്ടു; ഉടനെ അവന്റെ സഹോദരൻ ഏശാവ് വേട്ട കഴിഞ്ഞു മടങ്ങിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","അവനും രുചികരമായ ഭോജനം ഉണ്ടാക്കി അപ്പന്റെ അടുക്കൽ കൊണ്ടുചെന്നു അപ്പനോടു: അപ്പൻ എഴുന്നേറ്റു മകന്റെ വേട്ടയിറച്ചി തിന്നു എന്നെ അനുഗ്രഹിക്കേണമേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","അവന്റെ അപ്പനായ യിസ്ഹാക്ക് അവനോടു: നീ ആർ എന്നു ചോദിച്ചതിന്നു: ഞാൻ നിന്റെ മകൻ, നിന്റെ ആദ്യജാതൻ ഏശാവ് എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","അപ്പോൾ യിസ്ഹാക്ക് അത്യന്തം ഭ്രമിച്ചു നടുങ്ങി: എന്നാൽ വേട്ടതേടി എന്റെ അടുക്കൽ കൊണ്ടുവന്നവൻ ആർ? നീ വരുമുമ്പെ ഞാൻ സകലവും തിന്നു അവനെ അനുഗ്രഹിച്ചിരിക്കുന്നു; അവൻ അനുഗ്രഹിക്കപ്പെട്ടവനുമാകും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ഏശാവ് അപ്പന്റെ വാക്കു കേട്ടപ്പോൾ അതിദുഃഖിതനായി ഉറക്കെ നിലവിളിച്ചു: അപ്പാ, എന്നെ, എന്നെയും കൂടെ അനുഗ്രഹിക്കേണമേ എന്നു അപ്പനോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","അതിന്നു അവൻ: നിന്റെ സഹോദരൻ ഉപായത്തോടെ വന്നു നിന്റെ അനുഗ്രഹം അപഹരിച്ചുകളഞ്ഞു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ശരി, യാക്കോബ് എന്നല്ലോ അവന്റെ പേർ; രണ്ടു പ്രാവശ്യം അവൻ എന്നെ ചതിച്ചു; അവൻ എന്റെ ജ്യേഷ്ഠാവകാശം അപഹരിച്ചു; ഇപ്പോൾ ഇതാ, എന്റെ അനുഗ്രഹവും അപഹരിച്ചുകളഞ്ഞു എന്നു അവൻ പറഞ്ഞു. നീ എനിക്കു ഒരു അനുഗ്രഹവും കരുതിവെച്ചിട്ടില്ലയോ എന്നു അവൻ ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","യിസ്ഹാക്ക് ഏശാവിനോടു: ഞാൻ അവനെ നിനക്കു പ്രഭുവാക്കി അവന്റെ സഹോദരന്മാരെ ഒക്കെയും അവന്നു ദാസന്മാരാക്കി; അവന്നു ധാന്യവും വീഞ്ഞും കൊടുത്തു; ഇനി നിനക്കു ഞാൻ എന്തു തരേണ്ടു മകനേ, എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ഏശാവ് പിതാവിനോടു: നിനക്കു ഒരു അനുഗ്രഹം മാത്രമേ ഉള്ളുവോ, അപ്പാ? എന്നെ, എന്നെയുംകൂടെ അനുഗ്രഹിക്കേണമേ, അപ്പാ എന്നു പറഞ്ഞു പൊട്ടിക്കരഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","എന്നാറെ അവന്റെ അപ്പനായ യിസ്ഹാക്ക് ഉത്തരമായിട്ടു അവനോടു പറഞ്ഞതു: നിന്റെ വാസം ഭൂമിയിലെ പുഷ്ടികൂടാതെയും മീതെ ആകാശത്തിലെ മഞ്ഞുകൂടാതെയും ഇരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","നിന്റെ വാളുകൊണ്ടു നീ ഉപജീവിക്കും; നിന്റെ സഹോദരനെ നീ സേവിക്കും. നിന്റെ കെട്ടു അഴിഞ്ഞുപോകുമ്പോൾ നീ അവന്റെ നുകം കഴുത്തിൽനിന്നു കുടഞ്ഞുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","തന്റെ അപ്പൻ യാക്കോബിനെ അനുഗ്രഹിച്ച അനുഗ്രഹം നിമിത്തം ഏശാവു അവനെ ദ്വേഷിച്ചു: അപ്പനെക്കുറിച്ചു ദുഃഖിക്കുന്ന കാലം അടുത്തിരിക്കുന്നു; അപ്പോൾ ഞാൻ എന്റെ സഹോദരനായ യാക്കോബിനെ കൊല്ലും എന്നു ഏശാവു ഹൃദയത്തിൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","മൂത്തമകനായ ഏശാവിന്റെ വാക്കു റിബെക്കാ അറിഞ്ഞപ്പോൾ, അവൾ ഇളയമകനായ യാക്കോബിനെ ആളയച്ചു വിളിപ്പിച്ചു അവനോടു പറഞ്ഞതു: നിന്റെ സഹോദരൻ ഏശാവ് നിന്നെ കൊന്നു പകവീട്ടുവാൻ ഭാവിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ആകയാൽ മകനേ, എന്റെ വാക്കു കേൾക്ക: നീ എഴുന്നേറ്റു ഹാരാനിൽ എന്റെ സഹോദരനായ ലാബാന്റെ അടുക്കലേക്കു ഓടിപ്പോക. ");
INSERT INTO mal2015_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","നിന്റെ സഹോദരന്റെ ക്രോധം ശമിക്കുവോളം കുറെ നാൾ അവന്റെ അടുക്കൽ പാർക്ക. ");
INSERT INTO mal2015_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","നിന്റെ സഹോദരന്നു നിന്നോടുള്ള കോപം മാറി നീ അവനോടു ചെയ്തതു അവൻ മറക്കുംവരെ അവിടെ താമസിക്ക; പിന്നെ ഞാൻ ആളയച്ചു നിന്നെ അവിടെ നിന്നു വരുത്തിക്കൊള്ളാം; ഒരു ദിവസം തന്നേ നിങ്ങൾ ഇരുവരും എനിക്കു ഇല്ലാതെയാകുന്നതു എന്തിനു? ");
INSERT INTO mal2015_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","പിന്നെ റിബെക്കാ യിസ്ഹാക്കിനോടു: ഈ ഹിത്യസ്ത്രീകൾ നിമിത്തം എന്റെ ജീവൻ എനിക്കു അസഹ്യമായിരിക്കുന്നു; ഈ ദേശക്കാരത്തികളായ ഇവരെപ്പോലെയുള്ള ഒരു ഹിത്യസ്ത്രീയെ യാക്കോബ് വിവാഹം കഴിച്ചാൽ ഞാൻ എന്തിന്നു ജീവിക്കുന്നു? എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","അനന്തരം യിസ്ഹാക്ക് യാക്കോബിനെ വിളിച്ചു, അവനെ അനുഗ്രഹിച്ചു, അവനോടു ആജ്ഞാപിച്ചു പറഞ്ഞതു: നീ കനാന്യസ്ത്രീകളിൽനിന്നു ഭാര്യയെ എടുക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","പുറപ്പെട്ടു പദ്ദൻ-അരാമിൽ നിന്റെ അമ്മയുടെ അപ്പനായ ബെഥൂവേലിന്റെ വീട്ടിൽ ചെന്നു നിന്റെ അമ്മയുടെ സഹോദരനായ ലാബാന്റെ പുത്രിമാരിൽ നിന്നു നിനക്കു ഒരു ഭാര്യയെ എടുക്ക. ");
INSERT INTO mal2015_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","സർവ്വശക്തനായ ദൈവം നിന്നെ അനുഗ്രഹിക്കയും നീ ജനസമൂഹമായി തീരത്തക്കവണ്ണം നിന്നെ സന്താനപുഷ്ടിയുള്ളവനായി പെരുക്കുകയും ");
INSERT INTO mal2015_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ദൈവം അബ്രാഹാമിന്നു കൊടുത്തതും നീ പരദേശിയായി പാർക്കുന്നതുമായ ദേശം നീ കൈവശമാക്കേണ്ടതിന്നു അബ്രാഹാമിന്റെ അനുഗ്രഹം നിനക്കും നിന്റെ സന്തതിക്കും തരികയും ചെയ്യുമാറാകട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","അങ്ങനെ യിസ്ഹാക്ക് യാക്കോബിനെ പറഞ്ഞയച്ചു; അവൻ പദ്ദൻ-അരാമിൽ അരാമ്യനായ ബെഥൂവേലിന്റെ മകനും യാക്കോബിന്റെയും ഏശാവിന്റെയും അമ്മയായ റിബെക്കയുടെ സഹോദരനുമായ ലാബാന്റെ അടുക്കൽ പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","യിസ്ഹാക്ക് യാക്കോബിനെ അനുഗ്രഹിച്ചു പദ്ദൻ-അരാമിൽനിന്നു ഒരു ഭാര്യയെ എടുപ്പാൻ അവനെ അവിടെക്കു അയച്ചതും, അവനെ അനുഗ്രഹിക്കുമ്പോൾ: നീ കനാന്യസ്ത്രീകളിൽനിന്നു ഭാര്യയെ എടുക്കരുതെന്നു അവനോടു കല്പിച്ചതും ");
INSERT INTO mal2015_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","യാക്കോബ് അപ്പനെയും അമ്മയെയും അനുസരിച്ചു പദ്ദൻ-അരാമിലേക്കു പോയതും ഏശാവ് അറിഞ്ഞപ്പോൾ, ");
INSERT INTO mal2015_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","കനാന്യസ്ത്രീകൾ തന്റെ അപ്പനായ യിസ്ഹാക്കിന്നു ഇഷ്ടമുള്ളവരല്ല എന്നു കണ്ടു ");
INSERT INTO mal2015_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ഏശാവ് യിശ്മായേലിന്റെ അടുക്കൽ ചെന്നു തനിക്കുള്ള ഭാര്യമാരെ കൂടാതെ അബ്രാഹാമിന്റെ മകനായ യിശ്മായേലിന്റെ മകളും നെബായോത്തിന്റെ സഹോദരിയുമായ മഹലത്തിനെയും വിവാഹം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","എന്നാൽ യാക്കോബ് ബേർ-ശേബയിൽ നിന്നു പുറപ്പെട്ടു ഹാരാനിലേക്കു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","അവൻ ഒരു സ്ഥലത്തു എത്തിയപ്പോൾ സൂര്യൻ അസ്തമിക്കകൊണ്ടു അവിടെ രാപാർത്തു; അവൻ ആ സ്ഥലത്തെ കല്ലുകളിൽ ഒന്നു എടുത്തു തലയണയായി വെച്ചു അവിടെ കിടന്നുറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","അവൻ ഒരു സ്വപ്നം കണ്ടു: ഇതാ, ഭൂമിയിൽ വെച്ചിരിക്കുന്ന ഒരു കോവണി; അതിന്റെ തല സ്വർഗ്ഗത്തോളം എത്തിയിരുന്നു; ദൈവത്തിന്റെ ദൂതന്മാർ അതിന്മേൽകൂടി കയറുകയും ഇറങ്ങുകയുമായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","അതിന്മീതെ യഹോവ നിന്നു അരുളിച്ചെയ്തതു: ഞാൻ നിന്റെ പിതാവായ അബ്രാഹാമിന്റെ ദൈവവും, യിസ്ഹാക്കിന്റെ ദൈവവുമായ യഹോവ ആകുന്നു; നീ കിടക്കുന്ന ഭൂമിയെ ഞാൻ നിനക്കും നിന്റെ സന്തതിക്കും തരും. ");
INSERT INTO mal2015_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","നിന്റെ സന്തതി ഭൂമിയിലെ പൊടിപോലെ ആകും; നീ പടിഞ്ഞാറോട്ടും കിഴക്കോട്ടും വടക്കോട്ടും തെക്കോട്ടും പരക്കും; നീ മുഖാന്തരവും നിന്റെ സന്തതി മുഖാന്തരവും ഭൂമിയിലെ സകലവംശങ്ങളും അനുഗ്രഹിക്കപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ഇതാ, ഞാൻ നിന്നോടുകൂടെയുണ്ടു; നീ പോകുന്നേടത്തൊക്കെയും നിന്നെ കാത്തു ഈ രാജ്യത്തേക്കു നിന്നെ മടക്കിവരുത്തും; ഞാൻ നിന്നെ കൈവിടാതെ നിന്നോടു അരുളിച്ചെയ്തതു നിവർത്തിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","അപ്പോൾ യാക്കോബ് ഉറക്കമുണർന്നു: യഹോവ ഈ സ്ഥലത്തുണ്ടു സത്യം; ഞാനോ അതു അറിഞ്ഞില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","അവൻ ഭയപ്പെട്ടു: ഈ സ്ഥലം എത്ര ഭയങ്കരം! ഇതു ദൈവത്തിന്റെ ആലയമല്ലാതെ മറ്റൊന്നല്ല; ഇതു സ്വർഗ്ഗത്തിന്റെ വാതിൽ തന്നേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","യാക്കോബ് അതികാലത്തു എഴുന്നേറ്റു തലയണയായി വെച്ചിരുന്ന കല്ലു എടുത്തു തൂണായി നിർത്തി, അതിന്മേൽ എണ്ണ ഒഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","അവൻ ആ സ്ഥലത്തിന്നു ബേഥേൽ എന്നു പേർവിളിച്ചു; ആദ്യം ആ പട്ടണത്തിന്നു ലൂസ് എന്നു പേരായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","യാക്കോബ് ഒരു നേർച്ചനേർന്നു: ദൈവം എന്നോടുകൂടെ ഇരിക്കയും ഞാൻ പോകുന്ന ഈ യാത്രയിൽ എന്നെ കാക്കുകയും ഭക്ഷിപ്പാൻ ആഹാരവും ധരിപ്പാൻ വസ്ത്രവും എനിക്കു തരികയും ");
INSERT INTO mal2015_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","എന്നെ എന്റെ അപ്പന്റെ വീട്ടിലേക്കു സൗഖ്യത്തോടെ മടക്കിവരുത്തുകയും ചെയ്യുമെങ്കിൽ യഹോവ എനിക്കു ദൈവമായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ഞാൻ തൂണായി നിർത്തിയ ഈ കല്ലു ദൈവത്തിന്റെ ആലയവും ആകും. നീ എനിക്കു തരുന്ന സകലത്തിലും ഞാൻ നിനക്കു ദശാംശം തരും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","പിന്നെ യാക്കോബ് പ്രയാണം ചെയ്തു കിഴക്കരുടെ ദേശത്തു എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","അവൻ വെളിമ്പ്രദേശത്തു ഒരു കിണർ കണ്ടു. അതിന്നരികെ മൂന്നു ആട്ടിൻ കൂട്ടം കിടക്കുന്നു. ആ കിണറ്റിൽനിന്നു ആയിരുന്നു ആട്ടിൻ കൂട്ടങ്ങൾക്കു വെള്ളം കൊടുക്കുന്നതു; എന്നാൽ കിണറ്റിന്റെ വായ്ക്കലുള്ള കല്ലു വലുതായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ആ സ്ഥലത്തു കൂട്ടങ്ങൾ ഒക്കെ കൂടുകയും അവർ കിണറ്റിന്റെ വായ്ക്കൽനിന്നു കല്ലു ഉരുട്ടി ആടുകൾക്കു വെള്ളം കൊടുക്കയും കല്ലു കിണറ്റിന്റെ വായ്ക്കൽ അതിന്റെ സ്ഥലത്തു തന്നേ തിരികെ വെക്കയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","യാക്കോബ് അവരോടു: സഹോദരന്മാരേ, നിങ്ങൾ എവിടുത്തുകാർ എന്നു ചോദിച്ചതിന്നു: ഞങ്ങൾ ഹാരാന്യർ എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","അവൻ അവരോടു: നിങ്ങൾ നാഹോരിന്റെ മകനായ ലാബാനെ അറിയുമോ എന്നു ചോദിച്ചതിന്നു: അറിയും എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","അവൻ അവരോടു: അവൻ സുഖമായിരിക്കുന്നുവോ എന്നു ചോദിച്ചു. സുഖം തന്നേ; അവന്റെ മകൾ റാഹേൽ അതാ ആടുകളോടുകൂടെ വരുന്നു എന്നു അവർ അവനോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","പകൽ ഇനിയും വളരെയുണ്ടല്ലോ; കൂട്ടം ഒന്നിച്ചു കൂടുന്ന നേരമായിട്ടില്ല; ആടുകൾക്കു വെള്ളം കൊടുത്തു കൊണ്ടുപോയി തീറ്റുവിൻ എന്നു അവൻ പറഞ്ഞതിന്നു ");
INSERT INTO mal2015_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","അവർ: കൂട്ടങ്ങൾ ഒക്കെയും കൂടുവോളം ഞങ്ങൾക്കു വഹിയാ; അവർ കിണറ്റിന്റെ വായ്ക്കൽനിന്നു കല്ലു ഉരുട്ടും; പിന്നെ ഞങ്ങൾ ആടുകൾക്കു വെള്ളം കൊടുക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","അവൻ അവരോടു സംസാരിച്ചുകൊണ്ടിരിക്കുമ്പോൾ തന്നേ റാഹേൽ തന്റെ അപ്പന്റെ ആടുകളോടുകൂടെ വന്നു. അവളായിരുന്നു അവയെ മേയിച്ചുവന്നതു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","തന്റെ അമ്മയുടെ സഹോദരനായ ലാബാന്റെ മകൾ റാഹേലിനെയും അമ്മയുടെ സഹോദരനായ ലാബാന്റെ ആടുകളെയും കണ്ടപ്പോൾ യാക്കോബ് അടുത്തു ചെന്നു കണറ്റിന്റെ വായ്ക്കൽനിന്നു കല്ലു ഉരുട്ടി, അമ്മയുടെ സഹോദരനായ ലാബാന്റെ ആടുകൾക്കു വെള്ളം കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","യാക്കോബ് റാഹേലിനെ ചുംബിച്ചു പൊട്ടിക്കരഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","താൻ അവളുടെ അപ്പന്റെ സഹോദരൻ എന്നും റിബെക്കയുടെ മകനെന്നും യാക്കോബ് റാഹേലിനോടു പറഞ്ഞു. അവൾ ഓടിച്ചെന്നു തന്റെ അപ്പനെ അറിയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ലാബാൻ തന്റെ സഹോദരിയുടെ മകനായ യാക്കോബിന്റെ വസ്തുത കേട്ടപ്പോൾ അവനെ എതിരേല്പാൻ ഓടിച്ചെന്നു അവനെ ആലിംഗനം ചെയ്തു ചുംബിച്ചു വീട്ടിൽ കൂട്ടിക്കൊണ്ടുപോയി; അവൻ ലാബാനോടു വിവരം ഒക്കെയും പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ലാബാൻ അവനോടു: നീ എന്റെ അസ്ഥിയും മാംസവും തന്നേ എന്നു പറഞ്ഞു. അവൻ ഒരു മാസകാലം അവന്റെ അടുക്കൽ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","പിന്നെ ലാബാൻ യാക്കോബിനോടു: നീ എന്റെ സഹോദരനാകകൊണ്ടു വെറുതെ എന്നെ സേവിക്കേണമോ? നിനക്കു എന്തു പ്രതിഫലം വേണം? എന്നോടു പറക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","എന്നാൽ ലാബാന്നു രണ്ടു പുത്രിമാർ ഉണ്ടായിരുന്നു: മൂത്തവൾക്കു ലേയാ എന്നും ഇളയവൾക്കു റാഹേൽ എന്നും പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ലേയയുടെ കണ്ണു ശോഭ കുറഞ്ഞതായിരുന്നു; റാഹേലോ സുന്ദരിയും മനോഹരരൂപിണിയും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","യാക്കോബ് റാഹേലിനെ സ്നേഹിച്ചു; നിന്റെ ഇളയമകൾ റാഹേലിന്നു വേണ്ടി ഞാൻ ഏഴു സംവത്സരം നിന്നെ സേവിക്കാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","അതിന്നു ലാബാൻ: ഞാൻ അവളെ അന്യപുരുഷന്നു കൊടുക്കുന്നതിലും നിനക്കു തരുന്നതു നല്ലതു; എന്നോടുകൂടെ പാർക്ക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","അങ്ങനെ യാക്കോബ് റാഹേലിന്നു വേണ്ടി ഏഴു സംവത്സരം സേവ ചെയ്തു; അവൻ അവളെ സ്നേഹിക്കകൊണ്ടു അതു അവന്നു അല്പകാലംപോലെ തോന്നി. ");
INSERT INTO mal2015_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","അനന്തരം യാക്കോബ് ലാബാനോടു: എന്റെ സമയം തികഞ്ഞിരിക്കയാൽ ഞാൻ എന്റെ ഭാര്യയുടെ അടുക്കൽ ചെല്ലുവാൻ അവളെ തരേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","അപ്പോൾ ലാബാൻ ആ സ്ഥലത്തെ ജനങ്ങളെ എല്ലാം ഒന്നിച്ചുകൂട്ടി ഒരു വിരുന്നു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","എന്നാൽ രാത്രിയിൽ അവൻ തന്റെ മകൾ ലേയയെ കൂട്ടി അവന്റെ അടുക്കൽ കൊണ്ടു പോയി ആക്കി; അവൻ അവളുടെ അടുക്കൽ ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ലാബാൻ തന്റെ മകൾ ലേയെക്കു തന്റെ ദാസി സില്പയെ ദാസിയായി കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","നേരം വെളുത്തപ്പോൾ അതു ലേയാ എന്നു കണ്ടു അവൻ ലാബാനോടു: നീ എന്നോടു ചെയ്തതു എന്തു? റാഹേലിന്നു വേണ്ടി അല്ലയോ ഞാൻ നിന്നെ സേവിച്ചതു? നീ എന്തിന്നു എന്നെ ചതിച്ചു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","അതിന്നു ലാബാൻ: മൂത്തവൾക്കു മുമ്പെ ഇളയവളെ കൊടുക്ക ഞങ്ങളുടെ ദിക്കിൽ നടപ്പില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ഇവളുടെ ആഴ്ചവട്ടം നിവർത്തിക്ക; എന്നാൽ നീ ഇനിയും ഏഴു സംവത്സരം എന്റെ അടുക്കൽ ചെയ്യുന്ന സേവെക്കു വേണ്ടി ഞങ്ങൾ അവളെയും നിനക്കു തരാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","യാക്കോബ് അങ്ങനെ തന്നേ ചെയ്തു, അവളുടെ ആഴ്ചവട്ടം നിവർത്തിച്ചു; അവൻ തന്റെ മകൾ റാഹേലിനെയും അവന്നു ഭാര്യയായി കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","തന്റെ മകൾ റാഹേലിന്നു ലാബാൻ തന്റെ ദാസി ബിൽഹയെ ദാസിയായി കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","അവൻ റാഹേലിന്റെ അടുക്കലും ചെന്നു; റാഹേലിനെ ലേയയെക്കാൾ അധികം സ്നേഹിച്ചു; പിന്നെയും ഏഴു സംവത്സരം അവന്റെ അടുക്കൽ സേവ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ലേയാ അനിഷ്ടയെന്നു യഹോവ കണ്ടപ്പോൾ അവളുടെ ഗർഭത്തെ തുറന്നു; റാഹേലോ മച്ചിയായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ലേയാ ഗർഭംധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു: യഹോവ എന്റെ സങ്കടം കണ്ടു; ഇപ്പോൾ എന്റെ ഭർത്താവു എന്നെ സ്നേഹിക്കും എന്നു പറഞ്ഞു അവൾ അവന്നു രൂബേൻ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","അവൾ പിന്നെയും ഗർഭംധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു: ഞാൻ അനിഷ്ട എന്നു യഹോവ കേട്ടതുകൊണ്ടു ഇവനെയും എനിക്കു തന്നു എന്നു പറഞ്ഞു അവന്നു ശിമെയോൻ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","അവൾ പിന്നെയും ഗർഭംധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു: ഇപ്പോൾ ഈ സമയം എന്റെ ഭർത്താവു എന്നോടു പറ്റിച്ചേരും; ഞാൻ അവന്നു മൂന്നു പുത്രന്മാരെ പ്രസവിച്ചുവല്ലോ എന്നു പറഞ്ഞു; അതുകൊണ്ടു അവൾ അവന്നു ലേവി എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","അവൾ പിന്നെയും ഗർഭംധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു; ഇപ്പോൾ ഞാൻ യഹോവയെ സ്തുതിക്കും എന്നു അവൾ പറഞ്ഞു; അതുകൊണ്ടു അവൾ അവന്നു യെഹൂദാ എന്നു പേരിട്ടു. പിന്നെ അവൾക്കു പ്രസവം നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","താൻ യാക്കോബിന്നു മക്കളെ പ്രസവിക്കുന്നില്ല എന്നു റാഹേൽ കണ്ടു തന്റെ സഹോദരിയോടു അസൂയപ്പെട്ടു യാക്കോബിനോടു: എനിക്കു മക്കളെ തരേണം; അല്ലെങ്കിൽ ഞാൻ മരിച്ചുപോകും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","അപ്പോൾ യാക്കോബിന്നു റാഹേലിനോടു കോപം ജ്വലിച്ചു: നിനക്കു ഗർഭഫലം തരാതിരിക്കുന്ന ദൈവത്തിന്റെ സ്ഥാനത്തോ ഞാൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","അതിന്നു അവൾ: എന്റെ ദാസി ബിൽഹാ ഉണ്ടല്ലോ; അവളുടെ അടുക്കൽ ചെല്ലുക; അവൾ എന്റെ മടിയിൽ പ്രസവിക്കട്ടെ; അവളാൽ എനിക്കും മക്കൾ ഉണ്ടാകും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","അങ്ങനെ അവൾ തന്റെ ദാസി ബിൽഹയെ അവന്നു ഭാര്യയായി കൊടുത്തു; യാക്കോബ് അവളുടെ അടുക്കൽ ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ബിൽഹാ ഗർഭംധരിച്ചു യാക്കോബിന്നു ഒരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","അപ്പോൾ റാഹേൽ: ദൈവം എനിക്കു ന്യായം നടത്തി എന്റെ അപേക്ഷ കേട്ടു എനിക്കു ഒരു മകനെ തന്നു എന്നു പറഞ്ഞു; അതുകൊണ്ടു അവന്നു ദാൻ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","റാഹേലിന്റെ ദാസി ബിൽഹാ പിന്നെയും ഗർഭംധരിച്ചു യാക്കോബിന്നു രണ്ടാമതൊരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ഞാൻ എന്റെ സഹോദരിയോടു വലിയോരു പോർ പൊരുതു ജയിച്ചുമിരിക്കുന്നു എന്നു റാഹേൽ പറഞ്ഞു അവന്നു നഫ്താലി എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","തനിക്കു പ്രസവം നിന്നുപോയി എന്നു ലേയാ കണ്ടാറെ തന്റെ ദാസി സില്പയെ വിളിച്ചു അവളെ യാക്കോബിന്നു ഭാര്യയായി കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ലേയയുടെ ദാസി സില്പാ യാക്കോബിന്നു ഒരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","അപ്പോൾ ലേയാ: ഭാഗ്യം എന്നു പറഞ്ഞു അവന്നു ഗാദ് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ലേയയുടെ ദാസി സില്പാ യാക്കോബിന്നു രണ്ടാമതു ഒരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ഞാൻ ഭാഗ്യവതി; സ്ത്രീകൾ എന്നെ ഭാഗ്യവതിയെന്നു പറയും എന്നു ലേയാ പറഞ്ഞു അവന്നു ആശേർ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","കോതമ്പുകൊയിത്തുകാലത്തു രൂബേൻ പുറപ്പെട്ടു വയലിൽ ദൂദായിപ്പഴം കണ്ടു തന്റെ അമ്മയായ ലേയയുടെ അടുക്കൽ കൊണ്ടുവന്നു. റാഹേൽ ലേയയോടു: നിന്റെ മകന്റെ ദൂദായിപ്പഴം കുറെ എനിക്കു തരേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","അവൾ അവളോടു: നീ എന്റെ ഭർത്താവിനെ എടുത്തതു പോരയോ? എന്റെ മകന്റെ ദൂദായിപ്പഴവും കൂടെ വേണമോ എന്നു പറഞ്ഞതിന്നു റാഹേൽ: ആകട്ടെ; നിന്റെ മകന്റെ ദൂദായിപ്പഴത്തിന്നു വേണ്ടി ഇന്നു രാത്രി അവൻ നിന്നോടുകൂടെ ശയിച്ചുകൊള്ളട്ടേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","യാക്കോബ് വൈകുന്നേരം വയലിൽനിന്നു വരുമ്പോൾ ലേയാ അവനെ എതിരേറ്റു ചെന്നു: നീ എന്റെ അടുക്കൽ വരേണം; എന്റെ മകന്റെ ദൂദായിപ്പഴം കൊണ്ടു ഞാൻ നിന്നെ കൂലിക്കു വാങ്ങിയിരിക്കുന്നു എന്നു പറഞ്ഞു; അന്നു രാത്രി അവൻ അവളോടുകൂടെ ശയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ദൈവം ലേയയുടെ അപേക്ഷ കേട്ടു; അവൾ ഗർഭം ധരിച്ചു യാക്കോബിന്നു അഞ്ചാമതു ഒരു മകനെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","അപ്പോൾ ലേയാ: ഞാൻ എന്റെ ദാസിയെ എന്റെ ഭർത്താവിന്നു കൊടുത്തതുകൊണ്ടു ദൈവം എനിക്കു കൂലി തന്നു എന്നു പറഞ്ഞു അവന്നു യിസ്സാഖാർ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ലേയാ പിന്നെയും ഗർഭം ധരിച്ചു, യാക്കോബിന്നു ആറാമതു ഒരു മകനെ പ്രസവിച്ചു; ");
INSERT INTO mal2015_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ദൈവം എനിക്കു ഒരു നല്ലദാനം തന്നിരിക്കുന്നു; ഇപ്പോൾ എന്റെ ഭർത്താവു എന്നോടുകൂടെ വസിക്കും; ഞാൻ അവന്നു ആറു മക്കളെ പ്രസവിച്ചുവല്ലോ എന്നു ലേയാ പറഞ്ഞു അവന്നു സെബൂലൂൻ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","അതിന്റെ ശേഷം അവൾ ഒരു മകളെ പ്രസവിച്ചു അവൾക്കു ദീനാ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ദൈവം റാഹേലിനെ ഓർത്തു; ദൈവം അവളുടെ അപേക്ഷ കേട്ടു അവളുടെ ഗർഭത്തെ തുറന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","അവൾ ഗർഭം ധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു: ദൈവം എന്റെ നിന്ദ നീക്കിക്കളഞ്ഞിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","യഹോവ എനിക്കു ഇനിയും ഒരു മകനെ തരുമെന്നും പറഞ്ഞു അവന്നു യോസേഫ് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","റാഹേൽ യോസേഫിനെ പ്രസവിച്ചശേഷം യാക്കോബ് ലാബാനോടു: ഞാൻ എന്റെ സ്ഥലത്തേക്കും ദേശത്തേക്കും പോകുവാൻ എന്നെ അയക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ഞാൻ നിന്നെ സേവിച്ചതിന്റെ പ്രതിഫലമായ എന്റെ ഭാര്യമാരേയും മക്കളെയും എനിക്കു തരേണം; ഞാൻ പോകട്ടെ; ഞാൻ നിന്നെ സേവിച്ച സേവ നീ അറിയുന്നുവല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ലാബാൻ അവനോടു: നിനക്കു എന്നോടു ദയ ഉണ്ടെങ്കിൽ പോകരുതേ; നിന്റെ നിമിത്തം യഹോവ എന്നെ അനുഗ്രഹിച്ചു എന്നു എനിക്കു ബോദ്ധ്യമായിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","നിനക്കു എന്തു പ്രതിഫലം വേണം എന്നു പറക; ഞാൻ തരാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","അവൻ അവനോടു: ഞാൻ നിന്നെ എങ്ങനെ സേവിച്ചു എന്നും നിന്റെ ആട്ടിൻകൂട്ടം എന്റെ പക്കൽ എങ്ങനെ ഇരുന്നു എന്നും നീ അറിയുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ഞാൻ വരുംമുമ്പെ നിനക്കു അല്പമേ ഉണ്ടായിരുന്നുള്ളു; ഇപ്പോൾ അതു അത്യന്തം വർദ്ധിച്ചിരിക്കുന്നു; ഞാൻ കാൽ വെച്ചേടത്തൊക്കെയും യഹോവ നിന്നെ അനുഗ്രഹിച്ചിരിക്കുന്നു. ഇനി എന്റെ സ്വന്തഭവനത്തിന്നുവേണ്ടി ഞാൻ എപ്പോൾ കരുതും എന്നും പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ഞാൻ നിനക്കു എന്തു തരേണം എന്നു അവൻ ചോദിച്ചതിന്നു യാക്കോബ് പറഞ്ഞതു: നീ ഒന്നും തരേണ്ടാ; ഈ കാര്യം നീ ചെയ്തുതന്നാൽ ഞാൻ നിന്റെ ആട്ടിൻ കൂട്ടത്തെ ഇനിയും മേയിച്ചു പാലിക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ഞാൻ ഇന്നു നിന്റെ എല്ലാകൂട്ടങ്ങളിലും കൂടി കടന്നു, അവയിൽനിന്നു പുള്ളിയും മറുവുമുള്ള ആടുകളെ ഒക്കെയും ചെമ്മരിയാടുകളിൽ കറുത്തതിനെയൊക്കെയും കോലാടുകളിൽ പുള്ളിയും മറുവുമുള്ളതിനെയും വേർതിരിക്കാം; അതു എന്റെ പ്രതിഫലമായിരിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","നാളെ ഒരിക്കൽ എന്റെ പ്രതിഫലം സംബന്ധിച്ചു നീ നോക്കുവാൻ വരുമ്പോൾ എന്റെ നീതി തെളിവായിരിക്കും; കോലാടുകളിൽ പുള്ളിയും മറുവുമില്ലാത്തതും ചെമ്മരിയാടുകളിൽ കറുത്തനിറമില്ലാത്തതും എല്ലാം മോഷ്ടിച്ചതായി എണ്ണാം. ");
INSERT INTO mal2015_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","അതിന്നു ലാബാൻ: നീ പറഞ്ഞതുപോലെ ആകട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","അന്നു തന്നേ അവൻ വരയും മറുവുമുള്ള മുട്ടാടുകളെയും പുള്ളിയും മറുവുമുള്ള പെൺകോലാടുകളെ ഒക്കെയും വെണ്മയുള്ളതിനെ ഒക്കെയും ചെമ്മരിയാടുകളിൽ കറുത്തനിറമുള്ളതിനെ ഒക്കെയും വേർതിരിച്ചു അവന്റെ പുത്രന്മാരുടെ കയ്യിൽ ഏല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","അവൻ തനിക്കും യാക്കോബിന്നും ഇടയിൽ മൂന്നു ദിവസത്തെ വഴിയകലം വെച്ചു; ലാബാന്റെ ശേഷമുള്ള ആട്ടിൻകൂട്ടങ്ങളെ യാക്കോബ് മേയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","എന്നാൽ യാക്കോബ് പുന്നവൃക്ഷത്തിന്റെയും ബദാംവൃക്ഷത്തിന്റെയും അരിഞ്ഞിൽവൃക്ഷത്തിന്റെയും പച്ചക്കൊമ്പുകളെ എടുത്തു അവയിൽ വെള്ള കാണത്തക്കവണ്ണം വെള്ളവരയായി തോലുരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ആടുകൾ കുടിപ്പാൻ വന്നപ്പോൾ അവൻ, താൻ തോലുരിച്ച കൊമ്പുകളെ പാത്തികളിലും വെള്ളം പകരുന്ന തൊട്ടികളിലും ആടുകളുടെ മുമ്പിൽ വെച്ചു; അവ വെള്ളം കുടിപ്പാൻ വന്നപ്പോൾ ചനയേറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ആടുകൾ കൊമ്പുകളെ കണ്ടുകൊണ്ടു ചനയേറ്റു വരയും പുള്ളിയും മറുവുമുള്ള കുട്ടികളെ പെറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ആ ആട്ടിൻകുട്ടികളെ യാക്കോബ് വേർതിരിച്ചു ആടുകളെ ലാബാന്റെ ആടുകളിൽ വരയും മറുവുമുള്ള എല്ലാറ്റിന്നും അഭിമുഖമായി നിർത്തി; തന്റെ സ്വന്തകൂട്ടങ്ങളെ ലാബാന്റെ ആടുകളോടു ചേർക്കാതെ വേറെയാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ബലമുള്ള ആടുകൾ ചനയേല്ക്കുമ്പോഴൊക്കെയും കൊമ്പുകളെ കണ്ടുകൊണ്ടു ചനയേൽക്കേണ്ടതിന്നു യാക്കോബ് ആ കൊമ്പുകളെ പാത്തികളിൽ ആടുകളുടെ കണ്ണിന്നു മുമ്പിൽ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ബലമില്ലാത്ത ആടുകൾ ചനയേല്ക്കുമ്പോൾ അവയെ വെച്ചില്ല; അങ്ങനെ ബലമില്ലാത്തവ ലാബാന്നും ബലമുള്ളവ യാക്കോബിന്നും ആയിത്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","അവൻ മഹാസമ്പന്നനായി അവന്നു വളരെ ആടുകളും ദാസീദാസന്മാരും ഒട്ടകങ്ങളും കഴുതകളും ഉണ്ടാകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","എന്നാൽ ഞങ്ങളുടെ അപ്പന്നുള്ളതൊക്കെയും യാക്കോബ് എടുത്തുകളഞ്ഞു ഞങ്ങളുടെ അപ്പന്റെ വകകൊണ്ടു അവൻ ഈ ധനം ഒക്കെയും സമ്പാദിച്ചു എന്നു ലാബാന്റെ പുത്രന്മാർ പറഞ്ഞ വാക്കുകളെ അവൻ കേട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","യാക്കോബ് ലാബാന്റെ മുഖത്തു നോക്കിയാറെ അതു തന്റെ നേരെ മുമ്പെ ഇരുന്നതുപോലെ അല്ല എന്നു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","അപ്പോൾ യഹോവ യാക്കോബിനോടു: നിന്റെ പിതാക്കന്മാരുടെ ദേശത്തേക്കും നിന്റെ ചാർച്ചക്കാരുടെ അടുക്കലേക്കും മടങ്ങിപ്പോക; ഞാൻ നിന്നോടുകൂടെ ഇരിക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","യാക്കോബ് ആളയച്ചു റാഹേലിനേയും ലേയയെയും വയലിൽ തന്റെ ആട്ടിൻ കൂട്ടത്തിന്റെ അടുക്കൽ വിളിപ്പിച്ചു, ");
INSERT INTO mal2015_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","അവരോടു പറഞ്ഞതു: നിങ്ങളുടെ അപ്പന്റെ മുഖം എന്റെ നേരെ മുമ്പെപ്പോലെ അല്ല എന്നു ഞാൻ കാണുന്നു; എങ്കിലും എന്റെ അപ്പന്റെ ദൈവം എന്നോടുകൂടെ ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","നിങ്ങളുടെ അപ്പനെ ഞാൻ എന്റെ സർവ്വബലത്തോടും കൂടെ സേവിച്ചു എന്നു നിങ്ങൾക്കു തന്നേ അറിയാമല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","നിങ്ങളുടെ അപ്പനോ എന്നെ ചതിച്ചു എന്റെ പ്രതിഫലം പത്തു പ്രാവശ്യം മാറ്റി; എങ്കിലും എന്നോടു ദോഷം ചെയ്‌വാൻ ദൈവം അവനെ സമ്മതിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","പുള്ളിയുള്ളവ നിന്റെ പ്രതിഫലം ആയിരിക്കട്ടെ എന്നു അവൻ പറഞ്ഞു എങ്കിൽ കൂട്ടമൊക്കെയും പുള്ളിയുള്ള കുട്ടികളെ പെറ്റു; വരയുള്ളവ നിന്റെ പ്രതിഫലം ആയിരിക്കട്ടെ എന്നു അവൻ പറഞ്ഞു എങ്കിൽ കൂട്ടമൊക്കെയും വരയുള്ള കുട്ടികളെ പെറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ഇങ്ങനെ ദൈവം നിങ്ങളുടെ അപ്പന്റെ ആട്ടിൻകൂട്ടത്തെ എടുത്തു എനിക്കു തന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ആടുകൾ ചനയേല്ക്കുന്ന കാലത്തു ഞാൻ സ്വപ്നത്തിൽ ആടുകളിന്മേൽ കയറുന്ന മുട്ടാടുകൾ വരയും പുള്ളിയും മറുവും ഉള്ളവ എന്നു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ദൈവത്തിന്റെ ദൂതൻ സ്വപ്നത്തിൽ എന്നോടു: യാക്കോബേ എന്നു വിളിച്ചു; ഞാൻ ഇതാ, എന്നു ഞാൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","അപ്പോൾ അവൻ: നീ തലപൊക്കി നോക്കുക; ആടുകളുടെ മേൽ കയറുന്ന മുട്ടാടുകൾ ഒക്കെയും വരയും പുള്ളിയും മറുവുമുള്ളവയല്ലോ; ലാബാൻ നിന്നോടു ചെയ്യുന്നതു ഒക്കെയും ഞാൻ കണ്ടിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","നീ തൂണിനെ അഭിഷേകം ചെയ്കയും എന്നോടു നേർച്ചനേരുകയും ചെയ്ത സ്ഥലമായ ബേഥേലിന്റെ ദൈവം ആകുന്നു ഞാൻ; ആകയാൽ നീ എഴുന്നേറ്റു, ഈ ദേശംവിട്ടു നിന്റെ ജന്മദേശത്തേക്കു മടങ്ങിപ്പോക എന്നു കല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","റാഹേലും ലേയയും അവനോടു ഉത്തരം പറഞ്ഞതു: അപ്പന്റെ വീട്ടിൽ ഞങ്ങൾക്കു ഇനി ഓഹരിയും അവകാശവും ഉണ്ടോ? ");
INSERT INTO mal2015_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","അവൻ ഞങ്ങളെ അന്യരായിട്ടല്ലയോ വിചാരിക്കുന്നതു? ഞങ്ങളെ വിറ്റു വിലയും എല്ലാം തിന്നു കളഞ്ഞുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ദൈവം ഞങ്ങളുടെ അപ്പന്റെ പക്കൽനിന്നു എടുത്തുകളഞ്ഞ സമ്പത്തൊക്കെയും ഞങ്ങൾക്കും ഞങ്ങളുടെ മക്കൾക്കും ഉള്ളതല്ലോ; ആകയാൽ ദൈവം നിന്നോടു കല്പിച്ചതു ഒക്കെയും ചെയ്തുകൊൾക. ");
INSERT INTO mal2015_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","അങ്ങനെ യാക്കോബ് എഴുന്നേറ്റു തന്റെ ഭാര്യമാരെയും പുത്രന്മാരെയും ഒട്ടകപ്പുറത്തു കയറ്റി. ");
INSERT INTO mal2015_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","തന്റെ കന്നുകാലികളെ ഒക്കെയും താൻ സമ്പാദിച്ച സമ്പത്തു ഒക്കെയും താൻ പദ്ദൻ-അരാമിൽ സമ്പാദിച്ച മൃഗസമ്പത്തു ഒക്കെയും ചേർത്തുകൊണ്ടു കനാൻദേശത്തു തന്റെ അപ്പനായ യിസ്ഹാക്കിന്റെ അടുക്കൽ പോകുവാൻ പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ലാബാൻ തന്റെ ആടുകളെ രോമം കത്രിപ്പാൻ പോയിരുന്നു; റാഹേൽ തന്റെ അപ്പന്നുള്ള ഗൃഹവിഗ്രഹങ്ങളെ മോഷ്ടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","താൻ ഓടിപ്പോകുന്നതു യാക്കോബ് അരാമ്യനായ ലാബാനോടു അറിയിക്കായ്കയാൽ അവനെ തോല്പിച്ചായിരുന്നു പോയതു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ഇങ്ങനെ അവൻ തനിക്കുള്ള സകലവുമായി ഓടിപ്പോയി; അവൻ പുറപ്പെട്ടു നദി കടന്നു, ഗിലെയാദ്പർവ്വതത്തിന്നു നേരെ തിരിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","യാക്കോബ് ഓടിപ്പോയി എന്നു ലാബാന്നു മൂന്നാം ദിവസം അറിവു കിട്ടി. ");
INSERT INTO mal2015_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ഉടനെ അവൻ തന്റെ സഹോദരന്മാരെ കൂട്ടിക്കൊണ്ടു ഏഴു ദിവസത്തെ വഴി അവനെ പിന്തുടർന്നു ഗിലെയാദ്പർവ്വതത്തിൽ അവനോടു ഒപ്പം എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","എന്നാൽ ദൈവം രാത്രി സ്വപ്നത്തിൽ അരാമ്യനായ ലാബാന്റെ അടുക്കൽ വന്നു അവനോടു: നീ യാക്കോബിനോടു ഗുണമെങ്കിലും ദോഷമെങ്കിലും പറയാതിരിപ്പാൻ സൂക്ഷിച്ചുകൊൾക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ലാബാൻ യാക്കോബിനോടു ഒപ്പം എത്തി; യാക്കോബ് പർവ്വതത്തിൽ കൂടാരം അടിച്ചിരുന്നു; ലാബാനും തന്റെ സഹോദരന്മാരുമായി ഗിലെയാദ്പർവ്വതത്തിൽ കൂടാരം അടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ലാബാൻ യാക്കോബിനോടു പറഞ്ഞതു: നീ എന്നെ ഒളിച്ചു പോയ്ക്കളകയും എന്റെ പുത്രിമാരെ വാളാൽ പിടിച്ചവരെപ്പോലെ കൊണ്ടുപോകയും ചെയ്തതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","നീ എന്നെ തോല്പിച്ചു രഹസ്യമായിട്ടു ഓടിപ്പോകയും ഞാൻ സന്തോഷത്തോടും സംഗീതത്തോടും മുരജത്തോടും വീണയോടുംകൂടെ നിന്നെ അയപ്പാന്തക്കവണ്ണം എന്നെ അറിയിക്കാതിരിക്കയും ");
INSERT INTO mal2015_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","എന്റെ പുത്രന്മാരെയും പുത്രിമാരെയും ചുംബിപ്പാൻ എനിക്കു ഇടതരാതിരിക്കയും ചെയ്തതു എന്തു? ഭോഷത്വമാകുന്നു നീ ചെയ്തതു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","നിങ്ങളോടു ദോഷം ചെയ്‌വാൻ എന്റെ പക്കൽ ശക്തിയുണ്ടു; എങ്കിലും നീ യാക്കോബിനോടു ഗുണമെങ്കിലും ദോഷമെങ്കിലും ചെയ്യാതിരിപ്പാൻ സൂക്ഷിച്ചുകൊൾക എന്നു നിങ്ങളുടെ പിതാവിന്റെ ദൈവം കഴിഞ്ഞ രാത്രി എന്നോടു കല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ആകട്ടെ, നിന്റെ പിതൃഭവനത്തിന്നായുള്ള അതിവാഞ്ഛയാൽ നീ പുറപ്പെട്ടുപോന്നു; എന്നാൽ എന്റെ ദേവന്മാരെ മോഷ്ടിച്ചതു എന്തിന്നു? ");
INSERT INTO mal2015_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","യാക്കോബ് ലാബാനോടു: പക്ഷെ നിന്റെ പുത്രിമാരെ നീ എന്റെ പക്കൽനിന്നു അപഹരിക്കും എന്നു ഞാൻ ഭയപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","എന്നാൽ നീ ആരുടെ പക്കൽ എങ്കിലും നിന്റെ ദേവന്മാരെ കണ്ടാൽ അവൻ ജീവനോടിരിക്കരുതു; എന്റെ പക്കൽ നിന്റെ വക വല്ലതും ഉണ്ടോ എന്നു നീ നമ്മുടെ സഹോദരന്മാർ കാൺകെ നോക്കി എടുക്ക എന്നു ഉത്തരം പറഞ്ഞു. റാഹേൽ അവയെ മോഷ്ടിച്ചതു യാക്കോബ് അറിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","അങ്ങനെ ലാബാൻ യാക്കോബിന്റെ കൂടാരത്തിലും ലേയയുടെ കൂടാരത്തിലും രണ്ടു ദാസിമാരുടെ കൂടാരത്തിലും ചെന്നു നോക്കി, ഒന്നും കണ്ടില്ല താനും; അവൻ ലേയയുടെ കൂടാരത്തിൽ നിന്നു ഇറങ്ങി റാഹേലിന്റെ കൂടാരത്തിൽ ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","എന്നാൽ റാഹേൽ വിഗ്രഹങ്ങളെ എടുത്തു ഒട്ടകക്കോപ്പിനകത്തു ഇട്ടു അതിന്മേൽ ഇരിക്കയായിരുന്നു. ലാബാൻ കൂടാരത്തിൽ ഒക്കെയും തിരഞ്ഞു നോക്കി, കണ്ടില്ല താനും. ");
INSERT INTO mal2015_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","അവൾ അപ്പനോടു: യജമാനൻ കോപിക്കരുതേ; നിന്റെ മുമ്പാകെ എഴുന്നേല്പാൻ എനിക്കു കഴിവില്ല; സ്ത്രീകൾക്കുള്ള മുറ എനിക്കു വന്നിരിക്കുന്നു എന്നു പറഞ്ഞു. അങ്ങനെ അവൻ ശോധന കഴിച്ചു; ഗൃഹവിഗ്രഹങ്ങളെ കണ്ടില്ല താനും. ");
INSERT INTO mal2015_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","അപ്പോൾ യാക്കോബിന്നു കോപം ജ്വലിച്ചു, അവൻ ലാബാനോടു വാദിച്ചു. യാക്കോബ് ലാബാനോടു പറഞ്ഞതു എന്തെന്നാൽ: എന്റെ കുറ്റം എന്തു? നീ ഇത്ര ഉഗ്രതയോടെ എന്റെ പിന്നാലെ ഓടി വരേണ്ടതിന്നു എന്റെ തെറ്റു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","നീ എന്റെ സാമാനം ഒക്കെയും ശോധന കഴിച്ചുവല്ലോ; നിന്റെ വീട്ടിലെ സാമാനം വല്ലതും കണ്ടുവോ? എന്റെ സഹോദരന്മാർക്കും നിന്റെ സഹോദരന്മാർക്കും മുമ്പാകെ ഇവിടെ വെക്കുക; അവർ നമുക്കിരുവർക്കും മദ്ധ്യേ വിധിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ഈ ഇരുപതു സംവത്സരം ഞാൻ നിന്റെ അടുക്കൽ പാർത്തു; നിന്റെ ചെമ്മരിയാടുകൾക്കും കോലാടുകൾക്കും ചനനാശം വന്നിട്ടില്ല. നിന്റെ കൂട്ടത്തിലെ ആട്ടുകൊറ്റന്മാരെ ഞാൻ തിന്നുകളഞ്ഞിട്ടുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ദുഷ്ടമൃഗം കടിച്ചുകീറിയതിനെ നിന്റെ അടുക്കൽ കൊണ്ടുവരാതെ ഞാൻ അതിന്നു ഉത്തരവാദിയായിരുന്നു; പകൽ കളവു പോയതിനെയും രാത്രി കളവുപോയതിനെയും നീ എന്നോടു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ഇങ്ങനെയായിരുന്നു എന്റെ വസ്തുത; പകൽ വെയിൽകൊണ്ടും രാത്രി ശീതംകൊണ്ടും ഞാൻക്ഷയിച്ചു; എന്റെ കണ്ണിന്നു ഉറക്കമില്ലാതെയായി. ");
INSERT INTO mal2015_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ഈ ഇരുപതു സംവത്സരം ഞാൻ നിന്റെ വീട്ടിൽ പാർത്തു; പതിന്നാലു സംവത്സരം നിന്റെ രണ്ടു പുത്രിമാർക്കായിട്ടും ആറു സംവത്സരം നിന്റെ ആട്ടിൻ കൂട്ടത്തിന്നായിട്ടും നിന്നെ സേവിച്ചു; പത്തു പ്രാവശ്യം നീ എന്റെ പ്രതിഫലം മാറ്റി. ");
INSERT INTO mal2015_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","എന്റെ പിതാവിന്റെ ദൈവമായി അബ്രാഹാമിന്റെ ദൈവവും യിസ്ഹാക്കിന്റെ ഭയവുമായവൻ എനിക്കു ഇല്ലാതിരുന്നു എങ്കിൽ നീ ഇപ്പോൾ എന്നെ വെറുതെ അയച്ചുകളയുമായിരുന്നു; ദൈവം എന്റെ കഷ്ടതയും എന്റെ കൈകളുടെ പ്രയത്നവും കണ്ടു കഴിഞ്ഞ രാത്രി ന്യായം വിധിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ലാബാൻ യാക്കോബിനോടു: പുത്രിമാർ എന്റെ പുത്രിമാർ, മക്കൾ എന്റെ മക്കൾ, ആട്ടിൻ കൂട്ടം എന്റെ ആട്ടിൻ കൂട്ടം; നീ കാണുന്നതൊക്കെയും എനിക്കുള്ളതു തന്നേ; ഈ എന്റെ പുത്രിമാരോടോ അവർ പ്രസവിച്ച മക്കളോടോ ഞാൻ ഇന്നു എന്തു ചെയ്യും? ");
INSERT INTO mal2015_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ആകയാൽ വരിക, ഞാനും നീയും തമ്മിൽ ഒരു ഉടമ്പടി ചെയ്ക; അതു എനിക്കും നിനക്കും മദ്ധ്യേ സാക്ഷിയായിരിക്കട്ടെ എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","അപ്പോൾ യാക്കോബ് ഒരു കല്ലു എടുത്തു തൂണായി നിർത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","കല്ലു കൂട്ടുവിൻ എന്നു യാക്കോബ് തന്റെ സഹോദരന്മാരോടു പറഞ്ഞു; അവർ കല്ലു എടുത്തു ഒരു കൂമ്പാരമുണ്ടാക്കി; കൂമ്പാരത്തിന്മേൽവെച്ചു അവർ ഭക്ഷണം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ലാബാൻ അതിന്നു യെഗർ-സഹദൂഥാ (സാക്ഷ്യത്തിന്റെ കൂമ്പാരം) എന്നു പേരിട്ടു; യാക്കോബ് അതിന്നു ഗലേദ് (സാക്ഷ്യത്തിന്റെ കൂമ്പാരം) എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ഈ കൂമ്പാരം ഇന്നു എനിക്കും നിനക്കും മദ്ധ്യേ സാക്ഷി എന്നു ലാബാൻ പറഞ്ഞു. അതുകൊണ്ടു അതിന്നു ഗലേദ് എന്നും മിസ്പാ (കാവൽ മാടം) എന്നും പോരായി: ");
INSERT INTO mal2015_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","നാം തമ്മിൽ അകന്നിരിക്കുമ്പോൾ യഹോവ എനിക്കും നിനക്കും നടുവെ കാവലായിരിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","നീ എന്റെ പുത്രിമാരെ ഉപദ്രവിക്കയോ എന്റെ പുത്രിമാരെയല്ലാതെ വേറെ സ്ത്രീകളെ പരിഗ്രഹിക്കയോ ചെയ്യുമെങ്കിൽ നമ്മോടുകൂടെ ആരും ഇല്ല; നോക്കുക, ദൈവം തന്നേ എനിക്കും നിനക്കും മദ്ധ്യേ സാക്ഷി എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ലാബാൻ പിന്നെയും യാക്കോബിനോടു: ഇതാ, ഈ കൂമ്പാരം; ഇതാ, എനിക്കും നിനക്കും മദ്ധ്യേ നിർത്തിയ തൂൺ. ");
INSERT INTO mal2015_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ദോഷത്തിന്നായി ഞാൻ ഈ കൂമ്പാരം കടന്നു നിന്റെ അടുക്കൽ വരാതെയും നീ ഈ കൂമ്പാരവും ഈ തൂണും കടന്നു എന്റെ അടുക്കൽ വരാതെയും ഇരിക്കേണ്ടതിന്നു ഈ കൂമ്പാരവും സാക്ഷി, ഈ തൂണും സാക്ഷി. ");
INSERT INTO mal2015_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","അബ്രാഹാമിന്റെ ദൈവവും നാഹോരിന്റെ ദൈവവും അവരുടെ പിതാവിന്റെ ദൈവവുമായവൻ നമുക്കു മദ്ധ്യേ വിധിക്കട്ടെ എന്നു പറഞ്ഞു. യാക്കോബ് തന്റെ പിതാവായ യിസ്ഹാക്കിന്റെ ഭയമായവനെച്ചൊല്ലി സത്യം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","പിന്നെ യാക്കോബ് പർവ്വതത്തിൽ യാഗം അർപ്പിച്ചു ഭക്ഷണം കഴിപ്പാൻ തന്റെ സഹോദരന്മാരെ വിളിച്ചു; അവർ ഭക്ഷണം കഴിച്ചു പർവ്വതത്തിൽ രാപാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ലാബാൻ അതികാലത്തു എഴുന്നേറ്റു തന്റെ പുത്രന്മാരെയും പുത്രിമാരെയും ചുംബിക്കയും അനുഗ്രഹിക്കയും ചെയ്തശേഷം അവിടെനിന്നു പുറപ്പെട്ടു സ്വദേശത്തേക്കു മടങ്ങിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","യാക്കോബ് തന്റെ വഴിക്കു പോയി; ദൈവത്തിന്റെ ദൂതന്മാർ അവന്റെ എതിരെ വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","യാക്കോബ് അവരെ കണ്ടപ്പോൾ: ഇതു ദൈവത്തിന്റെ സേന എന്നു പറഞ്ഞു. ആ സ്ഥലത്തിന്നു മഹനയീം എന്നു പേർ ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","അനന്തരം യാക്കോബ് എദോംനാടായ സേയീർദേശത്തു തന്റെ സഹോദരനായ ഏശാവിന്റെ അടുക്കൽ തനിക്കു മുമ്പായി ദൂതന്മാരെ അയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","അവരോടു കല്പിച്ചതു എന്തെന്നാൽ: എന്റെ യജമാനനായ ഏശാവിനോടു ഇങ്ങനെ പറവിൻ: നിന്റെ അടിയാൻ യാക്കോബ് ഇപ്രകാരം പറയുന്നു: ഞാൻ ലാബാന്റെ അടുക്കൽ പരദേശിയായി പാർത്തു ഇന്നുവരെ അവിടെ താമസിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","എനിക്കു കാളയും കഴുതയും ആടും ദാസീദാസന്മാരും ഉണ്ടു; നിനക്കു എന്നൊടു കൃപ തോന്നേണ്ടതിന്നാകുന്നു യജമാനനെ അറിയിപ്പാൻ ആളയക്കുന്നതു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ദൂതന്മാർ യാക്കോബിന്റെ അടുക്കൽ മടങ്ങി വന്നു: ഞങ്ങൾ നിന്റെ സഹോദരനായ ഏശാവിന്റെ അടുക്കൽ പോയി വന്നു; അവൻ നാനൂറു ആളുമായി നിന്നെ എതിരേല്പാൻ വരുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","അപ്പോൾ യാക്കോബ് ഏറ്റവും ഭ്രമിച്ചു ഭയവശനായി, തന്നോടുകൂടെ ഉണ്ടായിരുന്ന ജനത്തെയും ആടുകളെയും കന്നുകാലികളെയും ഒട്ടകങ്ങളെയും രണ്ടു കൂട്ടമായി വിഭാഗിച്ചു, ");
INSERT INTO mal2015_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ഏശാവ് ഒരു കൂട്ടത്തിന്റെ നേരെ വന്നു അതിനെ നശിപ്പിച്ചാൽ മറ്റേ കൂട്ടത്തിന്നു ഓടിപ്പോകാമല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","പിന്നെ യാക്കോബ് പ്രാർത്ഥിച്ചതു: എന്റെ പിതാവായ അബ്രാഹാമിന്റെ ദൈവവും എന്റെ പിതാവായ യിസ്ഹാക്കിന്റെ ദൈവവുമായുള്ളോവേ, നിന്റെ ദേശത്തേക്കും നിന്റെ ചാർച്ചക്കാരുടെ അടുക്കലേക്കും മടങ്ങിപ്പോക; ഞാൻ നിനക്കു നന്മ ചെയ്യുമെന്നു എന്നോടു അരുളിച്ചെയ്ത യഹോവേ, ");
INSERT INTO mal2015_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","അടിയനോടു കാണിച്ചിരിക്കുന്ന സകലദയെക്കും സകലവിശ്വസ്തതെക്കും ഞാൻ അപാത്രമത്രേ; ഒരു വടിയോടുകൂടെ മാത്രമല്ലോ ഞാൻ ഈ യോർദ്ദാൻ കടന്നതു; ഇപ്പോഴോ ഞാൻ രണ്ടു കൂട്ടമായി തീർന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","എന്റെ സഹോദരനായ ഏശാവിന്റെ കയ്യിൽനിന്നു എന്നെ രക്ഷിക്കേണമേ; പക്ഷേ അവൻ വന്നു എന്നെയും മക്കളോടുകൂടെ തള്ളയെയും നശിപ്പിക്കും എന്നു ഞാൻ ഭയപ്പെടുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","നീയോ: ഞാൻ നിന്നോടു നന്മ ചെയ്യും; നിന്റെ സന്തതിയെ പെരുപ്പംകൊണ്ടു എണ്ണിക്കൂടാത്ത കടൽകരയിലെ മണൽപോലെ ആക്കുമെന്നു അരുളിച്ചെയ്തുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","അന്നു രാത്രി അവൻ അവിടെ പാർത്തു; തന്റെ പക്കൽ ഉള്ളതിൽ തന്റെ സഹോദരനായ ഏശാവിന്നു സമ്മാനമായിട്ടു ");
INSERT INTO mal2015_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ഇരുനൂറു കോലാടിനെയും ഇരുപതു കോലാട്ടുകൊറ്റനെയും ഇരുനൂറു ചെമ്മരിയാടിനെയും ഇരുപതു ചെമ്മരിയാട്ടുകൊറ്റനെയും ");
INSERT INTO mal2015_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","കറവുള്ള മുപ്പതു ഒട്ടകത്തെയും അവയുടെ കുട്ടികളെയും നാല്പതു പശുവിനെയും പത്തു കാളയെയും ഇരുപതു പെൺകഴുതയെയും പത്തു കഴുതക്കുട്ടിയെയും വേർതിരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","തന്റെ ദാസന്മാരുടെ പക്കൽ ഓരോ കൂട്ടത്തെ പ്രത്യേകം പ്രത്യേകമായി ഏല്പിച്ചു, തന്റെ ദാസന്മാരോടു: നിങ്ങൾ എനിക്കു മുമ്പായി കടന്നുപോയി അതതു കൂട്ടത്തിന്നു മദ്ധ്യേ ഇടയിടുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ഒന്നാമതു പോകുന്നവനോടു അവൻ: എന്റെ സഹോദരനായ ഏശാവ് നിന്നെ കണ്ടു: നീ ആരുടെ ആൾ? എവിടെ പോകുന്നു? നിന്റെ മുമ്പിൽ പോകുന്ന ഇവ ആരുടെ വക എന്നിങ്ങനെ നിന്നോടു ചോദിച്ചാൽ: ");
INSERT INTO mal2015_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","നിന്റെ അടിയാൻ യാക്കോബിന്റെ വക ആകുന്നു; ഇതു യജമാനനായ ഏശാവിന്നു അയച്ചിരിക്കുന്ന സമ്മാനം; അതാ, അവനും പിന്നാലെ വരുന്നു എന്നു നീ പറയേണം എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","രണ്ടാമത്തവനോടും മൂന്നാമത്തവനോടും കൂട്ടങ്ങളെ നടത്തിക്കൊണ്ടു പോകുന്ന എല്ലാവരോടും: നിങ്ങൾ ഏശാവിനെ കാണുമ്പോൾ ഇപ്രകാരം അവനോടുപറവിൻ; ");
INSERT INTO mal2015_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","അതാ, നിന്റെ അടിയാൻ യാക്കോബ് പിന്നാലെ വരുന്നു എന്നും പറവിൻ എന്നു അവൻ കല്പിച്ചു. എനിക്കു മുമ്പായിപോകുന്ന സമ്മാനംകൊണ്ടു അവനെ ശാന്തമാക്കീട്ടു പിന്നെ ഞാൻ അവന്റെ മുഖം കണ്ടുകൊള്ളാം; പക്ഷേ അവന്നു എന്നോടു ദയ തോന്നുമായിരിക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","അങ്ങനെ സമ്മാനം അവന്റെ മുമ്പായി പോയി; അവനോ അന്നു രാത്രി കൂട്ടത്തോടുകൂടെ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","രാത്രിയിൽ അവൻ എഴുന്നേറ്റു, തന്റെ രണ്ടു ഭാര്യമാരെയും രണ്ടു ദാസിമാരെയും പതിനൊന്നു പുത്രന്മാരെയും കൂട്ടി യാബ്ബോക്ക്കടവു കടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","അങ്ങനെ അവൻ അവരെ കൂട്ടി ആറ്റിന്നക്കരെ കടത്തി; തനിക്കുള്ളതൊക്കെയും അക്കരെ കടത്തിയശേഷം യാക്കോബ് തനിയേ ശേഷിച്ചു; ");
INSERT INTO mal2015_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","അപ്പോൾ ഒരു പുരുഷൻ ഉഷസ്സാകുവോളം അവനോടു മല്ലുപിടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","അവനെ ജയിക്കയില്ല എന്നു കണ്ടപ്പോൾ അവൻ അവന്റെ തുടയുടെ തടം തൊട്ടു; ആകയാൽ അവനോടു മല്ലുപിടിക്കയിൽ യാക്കോബിന്റെ തുടയുടെ തടം ഉളുക്കിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","എന്നെ വിടുക; ഉഷസ്സു ഉദിക്കുന്നുവല്ലോ എന്നു അവൻ പറഞ്ഞതിന്നു: നീ എന്നെ അനുഗ്രഹിച്ചല്ലാതെ ഞാൻ നിന്നെ വിടുകയില്ല എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","നിന്റെ പേർ എന്തു എന്നു അവൻ അവനോടു ചോദിച്ചതിന്നു: യാക്കോബ് എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","നീ ദൈവത്തോടും മനുഷ്യരോടും മല്ലുപിടിച്ചു ജയിച്ചതുകൊണ്ടു നിന്റെ പേർ ഇനി യാക്കോബ് എന്നല്ല യിസ്രായേൽ എന്നു വിളിക്കപ്പെടും എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","യാക്കോബ് അവനോടു: നിന്റെ പേർ എനിക്കു പറഞ്ഞുതരേണം എന്നു അപേക്ഷിച്ചു: നീ എന്റെ പേർ ചോദിക്കുന്നതു എന്തു എന്നു അവൻ പറഞ്ഞു, അവിടെവെച്ചു അവനെ അനുഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ഞാൻ ദൈവത്തെ മുഖാമുഖമായി കണ്ടിട്ടും എനിക്കു ജീവഹാനി വന്നില്ല എന്നു യാക്കോബ് പറഞ്ഞു, ആ സ്ഥലത്തിന്നു പെനീയേൽ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","അവൻ പെനീയേൽ കടന്നു പോകുമ്പോൾ സൂര്യൻ ഉദിച്ചു; എന്നാൽ തുടയുടെ ഉളുക്കുനിമിത്തം അവൻ മുടന്തിനടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","അവൻ യാക്കോബിന്റെ തുടയുടെ തടത്തിലെ ഞരമ്പു തൊടുകകൊണ്ടു യിസ്രായേൽമക്കൾ ഇന്നുവരെയും തുടയുടെ തടത്തിലെ ഞരമ്പു തിന്നാറില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","അനന്തരം യാക്കോബ് തലപൊക്കി നോക്കി, ഏശാവും അവനോടുകൂടെ നാനൂറു ആളും വരുന്നതു കണ്ടു; തന്റെ മക്കളെ ലേയയുടെ അടുക്കലും റാഹേലിന്റെ അടുക്കലും രണ്ടു ദാസിമാരുടെ അടുക്കലും വിഭാഗിച്ചുനിർത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","അവൻ ദാസിമാരെയും അവരുടെ മക്കളെയും മുമ്പായും ലേയയെയും അവളുടെ മക്കളെയും പിന്നാലെയും റാഹേലിനെയും യോസേഫിനെയും ഒടുക്കമായും നിർത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","അവൻ അവർക്കു മുമ്പായി കടന്നു ഏഴു പ്രാവശ്യം സാഷ്ടാംഗം നമസ്കരിച്ചുകൊണ്ടു തന്റെ സഹോദരനോടു അടുത്തുചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ഏശാവ് ഓടിവന്നു അവനെ എതിരേറ്റു, ആലിംഗനം ചെയ്തു; അവന്റെ കഴുത്തിൽ വീണു അവനെ ചുംബിച്ചു, രണ്ടുപേരും കരഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","പിന്നെ അവൻ തലപൊക്കി സ്ത്രീകളെയും കുഞ്ഞുങ്ങളെയും കണ്ടു: നിന്നോടുകൂടെയുള്ള ഇവർ ആർ എന്നു ചോദിച്ചുതിന്നു: ദൈവം അടിയന്നു നല്കിയിരിക്കുന്ന മക്കൾ എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","അപ്പോൾ ദാസിമാരും മക്കളും അടുത്തുവന്നു നമസ്കരിച്ചു; ");
INSERT INTO mal2015_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ലേയയും മക്കളും അടുത്തുവന്നു നമസ്കരിച്ചു; ഒടുവിൽ യോസേഫും റാഹേലും അടുത്തുവന്നു നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ഞാൻ വഴിക്കു കണ്ട ആ കൂട്ടമൊക്കെയും എന്തിന്നു എന്നു അവൻ ചോദിച്ചതിന്നു: യജമാനന്നു എന്നോടു കൃപതോന്നേണ്ടതിന്നു ആകുന്നു എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","അതിന്നു ഏശാവ്: സഹോദരാ, എനിക്കു വേണ്ടുന്നതു ഉണ്ടു; നിനക്കുള്ളതു നിനക്കു ഇരിക്കട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","അതിന്നു യാക്കോബ്: അങ്ങനെയല്ല, എന്നോടു കൃപ ഉണ്ടെങ്കിൽ എന്റെ സമ്മാനം എന്റെ കയ്യിൽനിന്നു വാങ്ങേണമേ; ദൈവത്തിന്റെ മുഖം കാണുന്നതുപോലെ ഞാൻ നിന്റെ മുഖം കാണുകയും നിനക്കു എന്നോടു ദയ തോന്നുകയും ചെയ്തുവല്ലോ; ");
INSERT INTO mal2015_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ഞാൻ അയച്ചിരിക്കുന്ന കാഴ്ച വാങ്ങേണമേ; ദൈവം എന്നോടു കൃപ ചെയ്തിരിക്കുന്നു; എനിക്കു വേണ്ടുവോളം ഉണ്ടു എന്നു പറഞ്ഞു അവനെ നിർബ്ബന്ധിച്ചു; അങ്ങനെ അവൻ അതു വാങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","പിന്നെ അവൻ: നാം പ്രയാണംചെയ്തു പോക; ഞാൻ നിനക്കു മുമ്പായി നടക്കാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","അതിന്നു അവൻ അവനോടു: കുട്ടികൾ നന്നാ ഇളയവർ എന്നും കറവുള്ള ആടുകളും കന്നുകാലികളും കൂടെ ഉണ്ടെന്നും യജമാനൻ അറിയുന്നുവല്ലോ; അവയെ ഒരു ദിവസം അധികമായി ഓടിച്ചാൽ കൂട്ടമെല്ലാം ചത്തുപോകും. ");
INSERT INTO mal2015_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","യജമാനൻ അടിയന്നു മുമ്പായി പോയാലും; എന്റെ കൂടെയുള്ള കന്നുകാലികളുടെയും കുഞ്ഞുങ്ങളുടെയും പ്രാപ്തിക്കു ഒത്തവണ്ണം ഞാൻ സാവധാനത്തിൽ അവയെ നടത്തിക്കൊണ്ടു സേയീരിൽ യജമാനന്റെ അടുക്കൽ വന്നുകൊള്ളാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","എന്റെ ആളുകളിൽ ചിലരെ ഞാൻ നിന്റെ അടുക്കൽ നിർത്തട്ടെ എന്നു ഏശാവു പറഞ്ഞതിന്നു: എന്തിന്നു? യജമാനന്റെ കൃപയുണ്ടായാൽ മതി എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","അങ്ങനെ ഏശാവ് അന്നു തന്റെ വഴിക്കു സേയീരിലേക്കു മടങ്ങിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","യാക്കോബോ സുക്കോത്തിന്നു യാത്ര പുറപ്പെട്ടു; തനിക്കു ഒരു വീടു പണിതു; കന്നുകാലിക്കൂട്ടത്തിന്നു തൊഴുത്തുകളും കെട്ടി; അതുകൊണ്ടു ആ സ്ഥലത്തിന്നു സുക്കോത്ത് എന്നു പേർ പറയുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","യാക്കോബ് പദ്ദൻ-അരാമിൽനിന്നു വന്നശേഷം കനാൻദേശത്തിലെ ശേഖേംപട്ടണത്തിൽ സമാധാനത്തോടെ എത്തി പട്ടണത്തിന്നരികെ പാളയമടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","താൻ കൂടാരമടിച്ച നിലം ശെഖേമിന്റെ അപ്പനായ ഹമോരിന്റെ പുത്രന്മാരോടു നൂറു വെള്ളിക്കാശിന്നു വാങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","അവിടെ അവൻ ഒരു യാഗപീഠം പണിതു, അതിന്നു ഏൽ-എലോഹേ-യിസ്രായേൽ എന്നു പേർ ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ലേയാ യാക്കോബിന്നു പ്രസവിച്ച മകളായ ദീനാ ദേശത്തിലെ കന്യകമാരെ കാണ്മാൻ പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","എന്നാറെ ഹിവ്യനായ ഹമോരിന്റെ മകനായി ദേശത്തിന്റെ പ്രഭുവായ ശെഖേം അവളെ കണ്ടിട്ടു പിടിച്ചുകൊണ്ടുപോയി അവളോടുകൂടെ ശയിച്ചു അവൾക്കു പോരായ്കവരുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","അവന്റെ ഉള്ളം യാക്കോബിന്റെ മകളായ ദീനയൊടു പറ്റിച്ചേർന്നു; അവൻ ബാലയെ സ്നേഹിച്ചു, ബാലയോടു ഹൃദ്യമായി സംസാരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ശെഖേം തന്റെ അപ്പനായ ഹമോരിനോടു: ഈ ബാലയെ എനിക്കു ഭാര്യയായിട്ടു എടുക്കേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","തന്റെ മകളായ ദീനയെ അവൻ വഷളാക്കി എന്നു യാക്കോബ് കേട്ടു; അവന്റെ പുത്രന്മാർ ആട്ടിൻകൂട്ടത്തോടുകൂടെ വയലിൽ ആയിരുന്നു; അവർ വരുവോളം യാക്കോബ് മിണ്ടാതിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ശെഖേമിന്റെ അപ്പനായ ഹമോർ യാക്കോബിനോടു സംസാരിപ്പാൻ അവന്റെ അടുക്കൽ വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","യാക്കോബിന്റെ പുത്രന്മാർ വസ്തുത കേട്ടു വയലിൽ നിന്നു വന്നു. അവൻ യാക്കോബിന്റെ മകളോടുകൂടെ ശയിച്ചു, അങ്ങനെ അരുതാത്ത കാര്യം ചെയ്തു യിസ്രായേലിൽ വഷളത്വം പ്രവർത്തിച്ചതുകൊണ്ടു ആ പുരുഷന്മാർക്കു വ്യസനം തോന്നി മഹാകോപവും ജ്വലിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ഹമോർ അവരോടു സംസാരിച്ചു: എന്റെ മകൻ ശെഖേമിന്റെ ഉള്ളം നിങ്ങളുടെ മകളോടു പറ്റിയിരിക്കുന്നു; അവളെ അവന്നു ഭാര്യയായി കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","നിങ്ങൾ ഞങ്ങളോടു വിവാഹസംബന്ധം കൂടി നിങ്ങളുടെ സ്ത്രീകളെ ഞങ്ങൾക്കു തരികയും ഞങ്ങളുടെ സ്ത്രീകളെ നിങ്ങൾക്കു എടുക്കയും ചെയ്‌വിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","നിങ്ങൾക്കു ഞങ്ങളോടുകൂടെ പാർക്കാം; ദേശത്തു നിങ്ങൾക്കു സ്വാതന്ത്ര്യമുണ്ടാകും; അതിൽ പാർത്തു വ്യാപാരം ചെയ്തു വസ്തു സമ്പാദിപ്പിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ശെഖേമും അവളുടെ അപ്പനോടും സഹോദരന്മാരോടും: നിങ്ങൾക്കു എന്നോടു കൃപ തോന്നിയാൽ നിങ്ങൾ പറയുന്നതു ഞാൻ തരാം. ");
INSERT INTO mal2015_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","എന്നോടു സ്ത്രീധനവും ദാനവും എത്രയെങ്കിലും ചോദിപ്പിൻ; നിങ്ങൾ പറയുംപോലെ ഞാൻ തരാം; ബാലയെ എനിക്കു ഭാര്യയായിട്ടു തരേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","തങ്ങളുടെ സഹോദരിയായ ദീനയെ ഇവൻ വഷളാക്കിയതുകൊണ്ടു യാക്കോബിന്റെ പുത്രന്മാർ ശെഖേമിനോടും അവന്റെ അപ്പനായ ഹമോരിനോടും സംസാരിച്ചു കപടമായി ഉത്തരം പറഞ്ഞതു: ");
INSERT INTO mal2015_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ഞങ്ങളുടെ സഹോദരിയെ അഗ്രചർമ്മിയായ പുരുഷനു കൊടുക്കുന്ന കാര്യം ഞങ്ങൾക്കു പാടുള്ളതല്ല; അതു ഞങ്ങൾക്കു അവമാനമാകുന്നു. എങ്കിലും ഒന്നു ചെയ്താൽ ഞങ്ങൾ സമ്മതിക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","നിങ്ങളിലുള്ള ആണെല്ലാം പരിച്ഛേദന ഏറ്റു നിങ്ങൾ ഞങ്ങളെപ്പോലെ ആയ്തീരുമെങ്കിൽ ");
INSERT INTO mal2015_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ഞങ്ങളുടെ സ്ത്രീകളെ നിങ്ങൾക്കു തരികയും നിങ്ങളുടെ സ്ത്രീകളെ ഞങ്ങൾ എടുക്കയും നിങ്ങളോടുകൂടെ പാർത്തു ഒരു ജനമായ്തീരുകയും ചെയ്യാം. ");
INSERT INTO mal2015_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","പരിച്ഛേദന ഏല്ക്കുന്നതിൽ ഞങ്ങളുടെ വാക്കു സമ്മതിക്കാഞ്ഞാലോ ഞങ്ങൾ ഞങ്ങളുടെ ബാലയെ കൂട്ടിക്കൊണ്ടുപോരും. ");
INSERT INTO mal2015_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","അവരുടെ വാക്കു ഹമോരിന്നും ഹാമോരിന്റെ മകനായ ശെഖേമിന്നും ബോധിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ആ യൗവനക്കാരന്നു യാക്കോബിന്റെ മകളോടു അനുരാഗം വർദ്ധിച്ചതുകൊണ്ടു അവൻ ആ കാര്യം നടത്തുവാൻ താമസം ചെയ്തില്ല; അവൻ തന്റെ പിതൃഭവനത്തിൽ എല്ലാവരിലും ശ്രേഷ്ഠനായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","അങ്ങനെ ഹമോരും അവന്റെ മകനായ ശെഖേമും തങ്ങളുടെ പട്ടണഗോപുരത്തിങ്കൽ ചെന്നു, പട്ടണത്തിലെ പുരുഷന്മാരോടു സംസാരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","ഈ മനുഷ്യർ നമ്മോടു സമാധാനമായിരിക്കുന്നു; അതുകൊണ്ടു അവർ ദേശത്തു പാർത്തു വ്യാപാരം ചെയ്യട്ടെ; അവർക്കും നമുക്കും മതിയാകംവണ്ണം ദേശം വിസ്താരമുള്ളതല്ലോ; അവരുടെ സ്ത്രീകളെ നാം വിവാഹം കഴിക്കയും നമ്മുടെ സ്ത്രീകളെ അവർക്കു കൊടുക്കയും ചെയ്ക. ");
INSERT INTO mal2015_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","എങ്കിലും അവർ പരിച്ഛേദനയുള്ളവരായിരിക്കുംപോലെ നമ്മിലുള്ള ആണെല്ലാം പരിച്ഛേദന ഏറ്റാൽ മാത്രമേ അവർ നമ്മോടുകൂടെ പാർത്തു ഒരു ജനമായിരിപ്പാൻ സമ്മതിക്കയുള്ളു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","അവരുടെ ആട്ടിൻകൂട്ടവും സമ്പത്തും മൃഗങ്ങളൊക്കെയും നമുക്കു ആകയില്ലയോ? അവർ പറയുംവണ്ണം സമ്മതിച്ചാൽ മതി; എന്നാൽ അവർ നമ്മോടുകൂടെ പാർക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","അപ്പോൾ ഹമോരിന്റെ പട്ടണക്കാർ എല്ലാവരും അവന്റെയും മകൻ ശെഖേമിന്റെയും വാക്കു കേട്ടു പട്ടണക്കാരിൽ ആണെല്ലാം പരിച്ഛേദന ഏറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","മൂന്നാം ദിവസം അവർ വേദനപ്പെട്ടിരിക്കുമ്പോൾ യാക്കോബിന്റെ രണ്ടു പുത്രന്മാരായി ദീനയുടെ സഹോദരന്മാരായ ശിമെയോനും ലേവിയും താന്താന്റെ വാൾ എടുത്തു നിർഭയമായിരുന്ന പട്ടണത്തിന്റെ നേരെ ചെന്നു ആണിനെയൊക്കെയും കൊന്നുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","അവർ ഹമോരിനെയും അവന്റെ മകനായ ശേഖേമിനെയും വാളിന്റെ വായ്ത്തലയാൽ കൊന്നു ദീനയെ ശെഖേമിന്റെ വീട്ടിൽനിന്നു കൂട്ടിക്കൊണ്ടു പോന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","പിന്നെ യാക്കോബിന്റെ പുത്രന്മാർ നിഹതന്മാരുടെ ഇടയിൽ ചെന്നു, തങ്ങളുടെ സഹോദരിയെ അവർ വഷളാക്കിയതുകൊണ്ടു പട്ടണത്തെ കൊള്ളയിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","അവർ അവരുടെ ആടു, കന്നുകാലി, കഴുത ഇങ്ങനെ പട്ടണത്തിലും വെളിയിലുമുള്ളവയൊക്കെയും അപഹരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","അവരുടെ സമ്പത്തൊക്കെയും എല്ലാപൈതങ്ങളെയും സ്ത്രീകളെയും അവർ കൊണ്ടുപോയി; വീടുകളിലുള്ളതൊക്കെയും കൊള്ളയിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","അപ്പോൾ യാക്കോബ് ശിമെയോനോടും ലേവിയോടും: ഈ ദേശനിവാസികളായ കനാന്യരുടെയും പെരിസ്യരുടെയും ഇടയിൽ നിങ്ങൾ എന്നെ നാറ്റിച്ചു വിഷമത്തിലാക്കിയിരിക്കുന്നു; ഞാൻ ആൾ ചുരുക്കമുള്ളവനല്ലോ; അവർ എനിക്കു വിരോധമായി കൂട്ടംകൂടി എന്നെ തോല്പിക്കയും ഞാനും എന്റെ ഭവനവും നശിക്കയും ചെയ്യും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","അതിന്നു അവർ: ഞങ്ങളുടെ സഹോദരിയോടു അവന്നു ഒരു വേശ്യയോടു എന്നപോലെ പെരുമാറാമോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","അനന്തരം ദൈവം യാക്കോബിനോടു: നീ പുറപ്പെട്ടു ബേഥേലിൽ ചെന്നു പാർക്ക; നിന്റെ സഹോദരനായ ഏശാവിന്റെ മുമ്പിൽനിന്നു നീ ഓടിപ്പോകുമ്പോൾ നിനക്കു പ്രത്യക്ഷനായ ദൈവത്തിന്നു അവിടെ ഒരു യാഗപീഠം ഉണ്ടാക്കുക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","അപ്പോൾ യാക്കോബ് തന്റെ കുടുംബത്തോടും കൂടെയുള്ള എല്ലാവരോടും: നിങ്ങളുടെ ഇടയിലുള്ള അന്യദേവന്മാരെ നീക്കിക്കളഞ്ഞു നിങ്ങളെ ശുദ്ധീകരിച്ചു വസ്ത്രം മാറുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","നാം പുറപ്പെട്ടു ബേഥേലിലേക്കു പോക; എന്റെ കഷ്ടകാലത്തു എന്റെ പ്രാർത്ഥന കേൾക്കയും ഞാൻ പോയ വഴിയിൽ എന്നോടു കൂടെയിരിക്കയും ചെയ്ത ദൈവത്തിന്നു ഞാൻ അവിടെ ഒരു യാഗപീഠം ഉണ്ടാക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","അങ്ങനെ അവർ തങ്ങളുടെ പക്കലുള്ള അന്യദേവന്മാരെ ഒക്കെയും കാതുകളിലെ കുണുക്കുകളെയും യാക്കോബിന്റെ പക്കൽ കൊടുത്തു; യാക്കോബ് അവയെ ശെഖേമിന്നരികെയുള്ള കരുവേലകത്തിൻ കീഴിൽ കുഴിച്ചിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","പിന്നെ അവർ യാത്രപുറപ്പെട്ടു; അവരുടെ ചുറ്റുമിരുന്ന പട്ടണങ്ങളുടെ മേൽ ദൈവത്തിന്റെ ഭീതി വീണതുകൊണ്ടു യാക്കോബിന്റെ പുത്രന്മാരെ ആരും പിന്തുടർന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","യാക്കോബും കൂടെയുള്ള ജനമൊക്കെയും കനാൻദേശത്തിലെ ലൂസ് എന്ന ബേഥേലിൽ എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","അവിടെ അവൻ ഒരു യാഗപീഠം പണിതു; തന്റെ സഹോദരന്റെ മുമ്പിൽനിന്നു ഓടിപ്പോകുമ്പോൾ അവന്നു അവിടെവെച്ചു ദൈവം പ്രത്യക്ഷനായതുകൊണ്ടു അവൻ ആ സ്ഥലത്തിന്നു ഏൽ-ബേഥേൽ എന്നു പേർ വിളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","റിബെക്കയുടെ ധാത്രിയായ ദെബോരാ മരിച്ചു, അവളെ ബേഥേലിന്നു താഴെ ഒരു കരുവേലകത്തിൻ കീഴിൽ അടക്കി; അതിന്നു അല്ലോൻ-ബാഖൂത്ത് (വിലാപവൃക്ഷം) എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","യാക്കോബ് പദ്ദൻ-അരാമിൽനിന്നു വന്ന ശേഷം ദൈവം അവന്നു പിന്നെയും പ്രത്യക്ഷനായി അവനെ അനുഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ദൈവം അവനോടു: നിന്റെ പേർ യാക്കോബ് എന്നല്ലോ; ഇനി നിനക്കു യാക്കോബ് എന്നല്ല യിസ്രായേൽ എന്നു തന്നെ പേരാകേണം എന്നു കല്പിച്ചു അവന്നു യിസ്രായേൽ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ദൈവം പിന്നെയും അവനോടു: ഞാൻ സർവ്വശക്തിയുള്ള ദൈവം ആകുന്നു; നീ സന്താനപുഷ്ടിയുള്ളവനായി പെരുകുക; ഒരു ജാതിയും ജാതികളുടെ കൂട്ടവും നിന്നിൽ നിന്നു ഉത്ഭവിക്കും; രാജാക്കന്മാരും നിന്റെ കടിപ്രദേശത്തുനിന്നു പുറപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ഞാൻ അബ്രാഹാമിന്നും യിസ്ഹാക്കിന്നും കൊടുത്തദേശം നിനക്കു തരും; നിന്റെ ശേഷം നിന്റെ സന്തതിക്കും ഈ ദേശം കൊടുക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","അവനോടു സംസാരിച്ച സ്ഥലത്തുനിന്നു ദൈവം അവനെ വിട്ടു കയറിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","അവൻ തന്നോടു സംസാരിച്ചേടത്തു യാക്കോബ് ഒരു കൽത്തൂൺ നിർത്തി; അതിന്മേൽ ഒരു പാനീയയാഗം ഒഴിച്ചു എണ്ണയും പകർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ദൈവം തന്നോടു സംസാരിച്ച സ്ഥലത്തിന്നു യാക്കോബ് ബേഥേൽ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","അവർ ബേഥേലിൽനിന്നു യാത്ര പുറപ്പെട്ടു; എഫ്രാത്തയിൽ എത്തുവാൻ അല്പദൂരം മാത്രമുള്ളപ്പോൾ റാഹേൽ പ്രസവിച്ചു; പ്രസവിക്കുമ്പോൾ അവൾക്കു കഠിന വേദനയുണ്ടായി. ");
INSERT INTO mal2015_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","അങ്ങനെ പ്രസവത്തിൽ അവൾക്കു കഠിനവേദനയായിരിക്കുമ്പോൾ സൂതികർമ്മിണി അവളോടു: ഭയപ്പെടേണ്ടാ; ഇതും ഒരു മകനായിരിക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","എന്നാൽ അവൾ മരിച്ചുപോയി; ജീവൻ പോകുന്ന സമയം അവൾ അവന്നു ബെനോനീ എന്നു പേർ ഇട്ടു; അവന്റെ അപ്പനോ അവന്നു ബെന്യാമീൻ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","റാഹേൽ മരിച്ചിട്ടു അവളെ ബേത്ത്ലേഹെം എന്ന എഫ്രാത്തിന്നു പോകുന്ന വഴിയിൽ അടക്കം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","അവളുടെ കല്ലറയിന്മേൽ യാക്കോബ് ഒരു തൂൺ നിർത്തി അതു റാഹേലിന്റെ കല്ലറത്തൂൺ എന്ന പേരോടെ ഇന്നുവരെയും നില്ക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","പിന്നെ യിസ്രായേൽ യാത്ര പുറപ്പെട്ടു, ഏദെർഗോപുരത്തിന്നു അപ്പുറം കൂടാരം അടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","യിസ്രായേൽ ആ ദേശത്തു പാർത്തിരിക്കുമ്പോൾ രൂബേൻ ചെന്നു തന്റെ അപ്പന്റെ വെപ്പാട്ടിയായ ബിൽഹയോടുകൂടെ ശയിച്ചു; യിസ്രായേൽ അതുകേട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","യാക്കോബിന്റെ പുത്രന്മാർ പന്ത്രണ്ടു പേരായിരുന്നു. ലേയയുടെ പുത്രന്മാർ: യാക്കോബിന്റെ ആദ്യജാതൻ രൂബേൻ, ശിമെയോൻ, ലേവി, യെഹൂദാ, യിസ്സാഖാർ, സെബൂലൂൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","റാഹേലിന്റെ പുത്രന്മാർ: യോസേഫും ബെന്യാമീനും. ");
INSERT INTO mal2015_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","റാഹേലിന്റെ ദാസിയായ ബിൽഹയുടെ പുത്രന്മാർ: ദാനും നഫ്താലിയും. ");
INSERT INTO mal2015_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ലേയയുടെ ദാസിയായ സില്പയുടെ പുത്രന്മാർ; ഗാദും ആശേരും. ഇവർ യാക്കോബിന്നു പദ്ദൻ-അരാമിൽവെച്ചു ജനിച്ച പുത്രന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","പിന്നെ യാക്കോബ് കിര്യാത്തർബ്ബാ എന്ന മമ്രേയിൽ തന്റെ അപ്പനായ യിസ്ഹാക്കിന്റെ അടുക്കൽ വന്നു; അബ്രാഹാമും യിസ്ഹാക്കും പാർത്തിരുന്ന ഹെബ്രോൻ ഇതു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","യിസ്ഹാക്കിന്റെ ആയുസ്സു നൂറ്റെണ്പതു സംവത്സരമായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","യിസ്ഹാക്ക് വയോധികനും കാലസമ്പൂർണ്ണനുമായി പ്രാണനെ വിട്ടു മരിച്ചു തന്റെ ജനത്തോടു ചേർന്നു; അവന്റെ പുത്രന്മാരായ ഏശാവും യാക്കോബും കൂടി അവനെ അടക്കംചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","എദോം എന്ന ഏശാവിന്റെ വംശപാരമ്പര്യമാവിതു: ");
INSERT INTO mal2015_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ഏശാവ് ഹിത്യനായ ഏലോന്റെ മകൾ ആദാ, ഹിവ്യനായ സിബെയോന്റെ മകളായ അനയുടെ മകൾ ഒഹൊലീബാ എന്നീ കനാന്യകന്യകമാരെയും ");
INSERT INTO mal2015_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","യിശ്മായേലിന്റെ മകളും നെബായോത്തിന്റെ സഹോദരിയുമായ ബാസമത്തിനെയും ഭാര്യമാരായി പരിഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ആദാ ഏശാവിന്നു എലീഫാസിനെ പ്രസവിച്ചു; ബാസമത്ത് രെയൂവേലിനെ പ്രസവിച്ചു; ");
INSERT INTO mal2015_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ഒഹൊലീബാമാ യെയൂശിനെയും യലാമിനെയും കോരഹിനെയും പ്രസവിച്ചു; ഇവർ ഏശാവിന്നു കനാൻദേശത്തുവെച്ചു ജനിച്ച പുത്രന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","എന്നാൽ ഏശാവ് തന്റെ ഭാര്യമാരെയും പുത്രന്മാരെയും പുത്രിമാരെയും വീട്ടിലുള്ളവരെയൊക്കെയും തന്റെ ആടുമാടുകളെയും സകലമൃഗങ്ങളെയും കനാൻദേശത്തു സമ്പാദിച്ച സമ്പത്തൊക്കെയും കൊണ്ടു തന്റെ സഹോദരനായ യാക്കോബിന്റെ സമീപത്തുനിന്നു ദൂരെ ഒരു ദേശത്തേക്കു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","അവർക്കു ഒന്നിച്ചു പാർപ്പാൻ വഹിയാതവണ്ണം അവരുടെ സമ്പത്തു അധികമായിരുന്നു; അവരുടെ ആടുമാടുകൾ ഹേതുവായി അവർ പരദേശികളായി പാർത്തിരുന്ന ദേശത്തിന്നു അവരെ വഹിച്ചുകൂടാതെയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","അങ്ങനെ എദോം എന്നും പേരുള്ള ഏശാവ് സേയീർപർവ്വതത്തിൽ കുടിയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","സേയീർപർവ്വതത്തിലുള്ള എദോമ്യരുടെ പിതാവായ ഏശാവിന്റെ വംശപാരമ്പര്യമാവിതു: ");
INSERT INTO mal2015_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ഏശാവിന്റെ പുത്രന്മാരുടെ പേരുകൾ ഇവ: ഏശാവിന്റെ ഭാര്യയായ ആദയുടെ മകൻ എലീഫാസ്, ഏശാവിന്റെ ഭാര്യയായ ബാസമത്തിന്റെ മകൻ രെയൂവേൽ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","എലീഫാസിന്റെ പുത്രന്മാർ: തേമാൻ, ഓമാർ, സെഫോ, ഗത്ഥാം, കെനസ്. ");
INSERT INTO mal2015_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","തിമ്നാ എന്നവൾ ഏശാവിന്റെ മകനായ എലീഫാസിന്റെ വെപ്പാട്ടി ആയിരുന്നു. അവൾ എലീഫാസിന്നു അമാലേക്കിനെ പ്രസവിച്ചു; ഇവർ ഏശാവിന്റെ ഭാര്യയായ ആദയുടെ പുത്രന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","രെയൂവേലിന്റെ പുത്രന്മാർ: നഹത്ത്, സേറഹ്, ശമ്മാ, മിസ്സാ; ഇവർ ഏശാവിന്റെ ഭാര്യയായ ബാസമത്തിന്റെ പുത്രന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","സിബെയോന്റെ മകളായ അനയുടെ മകൾ ഒഹൊലീബാമാ എന്ന ഏശാവിന്റെ ഭാര്യയുടെ പുത്രന്മാർ ആരെന്നാൽ: അവൾ ഏശാവിന്നു യെയൂശ്, യലാം, കോരഹ് എന്നിവരെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ഏശാവിന്റെ പുത്രന്മാരിലെ പ്രഭുക്കന്മാർ ആരെന്നാൽ: ഏശാവിന്റെ ആദ്യജാതൻ എലീഫാസിന്റെ പുത്രന്മാർ: തേമാൻപ്രഭു, ഓമാർപ്രഭു, സെഫോപ്രഭു, കെനസ്പ്രഭു, ");
INSERT INTO mal2015_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","കോരഹ്പ്രഭു, ഗത്ഥാംപ്രഭു, അമാലേക്പ്രഭു; ഇവർ ഏദോംദേശത്തു എലീഫാസിൽനിന്നു ഉത്ഭവിച്ച പ്രഭുക്കന്മാർ; ഇവർ ആദയുടെ പുത്രന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ഏശാവിന്റെ മകനായ രെയൂവേലിന്റെ പുത്രന്മാർ ആരെന്നാൽ: നഹത്ത്പ്രഭു, സേരഹ്പ്രഭു, ശമ്മാപ്രഭു, മിസ്സാപ്രഭു, ഇവർ എദോംദേശത്തു രെയൂവേലിൽ നിന്നു ഉത്ഭവിച്ച പ്രഭുക്കന്മാർ; ഇവർ ഏശാവിന്റെ ഭാര്യ ബാസമത്തിന്റെ പുത്രന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ഏശാവിന്റെ ഭാര്യയായ ഒഹൊലീബാമയുടെ പുത്രന്മാർ ആരെന്നാൽ: യെയൂശ്പ്രഭു, യലാംപ്രഭു, കോറഹ്പ്രഭു; ഇവർ അനയുടെ മകളായി ഏശാവിന്റെ ഭാര്യയായ ഒഹൊലീബാമയിൽ നിന്നു ഉത്ഭവിച്ച പ്രഭുക്കന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ഇവർ എദോം എന്നും പേരുള്ള ഏശാവിന്റെ പുത്രന്മാരും അവരിൽനിന്നു ഉത്ഭവിച്ച പ്രഭുക്കന്മാരും ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ഹോര്യനായ സേയീരിന്റെ പുത്രന്മാരായി ദേശത്തിലെ പൂർവ്വനിവാസികളായവർ ആരെന്നാൽ: ലോതാൻ, ശോബാൽ, സിബെയോൻ, ");
INSERT INTO mal2015_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","അനാ, ദീശോൻ, ഏസെർ, ദീശാൻ; ഇവർ എദോംദേശത്തു സേയീരിന്റെ പുത്രന്മാരായ ഹോര്യപ്രഭുക്കന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ലോതാന്റെ പുത്രന്മാർ ഹോരിയും ഹേമാമും ആയിരുന്നു. ലോതാന്റെ സഹോദരി തിമ്നാ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ശോബാലിന്റെ പുത്രന്മാർ ആരെന്നാൽ: അൽവാൻ, മാനഹത്ത്, ഏബാൽ, ശെഫോ, ഓനാം. ");
INSERT INTO mal2015_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","സിബെയോന്റെ പുത്രന്മാർ: അയ്യാവും അനാവും ആയിരുന്നു; മരുഭൂമിയിൽ തന്റെ അപ്പനായ സിബെയോന്റെ കഴുതകളെ മേയ്ക്കുമ്പോൾ ചൂടുറവുകൾ കണ്ടെത്തിയ അനാ ഇവൻ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","അനാവിന്റെ മക്കൾ ഇവർ: ദീശോനും അനാവിന്റെ മകൾ ഒഹൊലീബാമയും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ദീശോന്റെ പുത്രന്മാർ ആരെന്നാൽ: ഹെംദാൻ, എശ്ബാൻ, യിത്രാൻ, കെരാൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ഏസെരിന്റെ പുത്രന്മാർ: ബിൽഹാൻ, സാവാൻ, അക്കാൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ദീശാന്റെ പുത്രന്മാർ ഊസും അരാനും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ഹോര്യപ്രഭുക്കന്മാർ ആരെന്നാൽ: ലോതാൻപ്രഭു, ശോബാൽപ്രഭു, സിബെയോൻപ്രഭു, അനാപ്രഭു, ");
INSERT INTO mal2015_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ദീശോൻപ്രഭു, ഏസെർപ്രഭു, ദീശാൻ പ്രഭു. ഇവർ സേയീർദേശത്തു വാണ ഹോര്യപ്രഭുക്കന്മാർ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","യിസ്രായേൽമക്കൾക്കു രാജാവുണ്ടാകുംമുമ്പെ എദോംദേശത്തു വാണ രാജാക്കന്മാർ ആരെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ബെയോരിന്റെ പുത്രനായ ബേല എദോമിൽ രാജാവായിരുന്നു; അവന്റെ പട്ടണത്തിന്നു ദിൻഹാബാ എന്നു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ബേല മരിച്ചശേഷം ബൊസ്രക്കാരനായ സേരഹിന്റെ മകൻ യോബാബ് അവന്നു പകരം രാജാവായി. ");
INSERT INTO mal2015_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","യോബാബ് മരിച്ചശേഷം തേമാന്യദേശക്കാരനായ ഹൂശാം അവന്നു പകരം രാജാവായി. ");
INSERT INTO mal2015_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ഹൂശാം മരിച്ചശേഷം മോവാബ് സമഭൂമിയിൽവെച്ചു മിദ്യാനെ തോല്പിച്ച ബെദദിന്റെ മകൻ ഹദദ് അവന്നു പകരം രാജാവായി; അവന്റെ പട്ടണത്തിന്നു അവീത്ത് എന്നു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ഹദദ് മരിച്ച ശേഷം മസ്രേക്കക്കാരൻ സമ്ളാ അവന്നു പകരം രാജാവായി. ");
INSERT INTO mal2015_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","സമ്ളാ മരിച്ചശേഷം നദീതീരത്തുള്ള രെഹോബോത്ത് പട്ടണക്കാരനായ ശൗൽ അവന്നു പകരം രാജാവായി. ");
INSERT INTO mal2015_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ശൗൽ മരിച്ചശേഷം അക്ബോരിന്റെ മകൻ ബാൽഹാനാൻ അവന്നു പകരം രാജാവായി. ");
INSERT INTO mal2015_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","അക്ബോരിന്റെ മകനായ ബാൽഹാനാൻ മരിച്ചശേഷം ഹദർ അവന്നു പകരം രാജാവായി. അവന്റെ പട്ടണത്തിന്നു പാവൂ എന്നു പേർ. അവന്റെ ഭാര്യക്കു മെഹെതബേൽ എന്നു പേർ; അവൾ മേസാഹാബിന്റെ മകളായ മത്രേദിന്റെ മകൾ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","വംശംവംശമായും ദേശംദേശമായും പേരുപേരായും ഏശാവിൽ നിന്നു ഉത്ഭവിച്ച പ്രഭുക്കന്മാരുടെ പേരുകൾ ആവിതു: തിമ്നാപ്രഭു, അൽവാപ്രഭു, യെഥേത്ത്പ്രഭു, ഒഹൊലീബാമാപ്രഭു; ");
INSERT INTO mal2015_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ഏലാപ്രഭു, പീനോൻപ്രഭു, കെനസ്പ്രഭു, തേമാൻപ്രഭു; ");
INSERT INTO mal2015_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","മിബ്സാർപ്രഭു, മഗ്ദീയേൽപ്രഭു, ഈരാംപ്രഭു; ");
INSERT INTO mal2015_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ഇവർ താന്താങ്ങളുടെ അവകാശദേശത്തും വാസസ്ഥലങ്ങളിലും വാണ എദോമ്യപ്രഭുക്കന്മാർ ആകുന്നു; എദോമ്യരുടെ പിതാവു ഏശാവ് തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","യാക്കോബ് തന്റെ പിതാവു പരദേശിയായി പാർത്ത ദേശമായ കനാൻദേശത്തു വസിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","യാക്കോബിന്റെ വംശപാരമ്പര്യം എന്തെന്നാൽ: യോസേഫിന്നു പതിനേഴു വയസ്സായപ്പോൾ അവൻ തന്റെ സഹോദരന്മാരോടുകൂടെ ആടുകളെ മേയിച്ചുകൊണ്ടു ഒരു ബാലനായി തന്റെ അപ്പന്റെ ഭാര്യമാരായ ബിൽഹയുടെയും സില്പയുടെയും പുത്രന്മാരോടുകൂടെ ഇരുന്നു അവരെക്കുറിച്ചുള്ള ദുഃശ്രുതി യോസേഫ് അപ്പനോടു വന്നു പറയും. ");
INSERT INTO mal2015_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","യോസേഫ് വാർദ്ധക്യത്തിലെ മകനാകകൊണ്ടു യിസ്രായേൽ എല്ലാമക്കളിലുംവെച്ചു അവനെ അധികം സ്നേഹിച്ചു ഒരു നിലയങ്കി അവന്നു ഉണ്ടാക്കിച്ചു കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","അപ്പൻ തങ്ങളെ എല്ലാവരെക്കാളും അവനെ അധികം സ്നേഹിക്കുന്നു എന്നു അവന്റെ സഹോദരന്മാർ കണ്ടിട്ടു അവനെ പകെച്ചു; അവനോടു സമാധാനമായി സംസാരിപ്പാൻ അവർക്കു കഴിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","യോസേഫ് ഒരു സ്വപ്നം കണ്ടു; അതു തന്റെ സഹോദരന്മാരോടു അറിയിച്ചതുകൊണ്ടു അവർ അവനെ പിന്നെയും അധികം പകെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","അവൻ അവരോടു പറഞ്ഞതു: ഞാൻ കണ്ട സ്വപ്നം കേട്ടുകൊൾവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","നാം വയലിൽ കറ്റ കെട്ടിക്കൊണ്ടിരുന്നു; അപ്പോൾ എന്റെ കറ്റ എഴുന്നേറ്റു നിവിർന്നുനിന്നു; നിങ്ങളുടെ കറ്റകൾ ചുറ്റും നിന്നു എന്റെ കറ്റയെ നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","അവന്റെ സഹോദരന്മാർ അവനോടു: നീ ഞങ്ങളുടെ രാജാവാകുമോ? നീ ഞങ്ങളെ വാഴുമോ എന്നു പറഞ്ഞു, അവന്റെ സ്വപ്നങ്ങൾ നിമിത്തവും അവന്റെ വാക്കു നിമിത്തവും അവനെ പിന്നെയും അധികം ദ്വേഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","അവൻ മറ്റൊരു സ്വപ്നം കണ്ടു തന്റെ സഹോദരന്മാരോടു അറിയിച്ചു: ഞാൻ പിന്നെയും ഒരു സ്വപ്നം കണ്ടു; സൂര്യനും ചന്ദ്രനും പതിനൊന്നു നക്ഷത്രങ്ങളും എന്നെ നമസ്കരിച്ചു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","അവൻ അതു അപ്പനോടും സഹോദരന്മാരോടും അറിയിച്ചപ്പോൾ അപ്പൻ അവനെ ശാസിച്ചു അവനോടു: നീ ഈ കണ്ട സ്വപ്നം എന്തു? ഞാനും നിന്റെ അമ്മയും നിന്റെ സഹോദരന്മാരും സാഷ്ടാംഗം വീണു നിന്നെ നമസ്കരിപ്പാൻ വരുമോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","അവന്റെ സഹോദരന്മാർക്കു അവനോടു അസൂയ തോന്നി; അപ്പനോ ഈ വാക്കു മനസ്സിൽ സംഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","അവന്റെ സഹോദരന്മാർ അപ്പന്റെ ആടുകളെ മേയ്പാൻ ശെഖേമിൽ പോയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","യിസ്രായേൽ യോസേഫിനോടു: നിന്റെ സഹോദരന്മാർ ശെഖേമിൽ ആടുമേയിക്കുന്നുണ്ടല്ലോ; വരിക, ഞാൻ നിന്നെ അവരുടെ അടുക്കൽ അയക്കും എന്നു പറഞ്ഞതിന്നു അവൻ അവനോടു: ഞാൻ പോകാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","അവൻ അവനോടു: നീ ചെന്നു നിന്റെ സഹോദരന്മാർക്കു സുഖം തന്നേയോ? ആടുകൾ നന്നായിരിക്കുന്നുവോ എന്നു നോക്കി, വന്നു വസ്തുത അറിയിക്കേണം എന്നു പറഞ്ഞു ഹെബ്രോൻതാഴ്‌വരയിൽ നിന്നു അവനെ അയച്ചു; അവൻ ശെഖേമിൽ എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","അവൻ വെളിമ്പ്രദേശത്തു ചുറ്റി നടക്കുന്നതു ഒരുത്തൻ കണ്ടു: നീ എന്തു അന്വേഷിക്കുന്നു എന്നു അവനോടു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","അതിന്നു അവൻ: ഞാൻ എന്റെ സഹോദരന്മാരെ അന്വേഷിക്കുന്നു; അവർ എവിടെ ആടു മേയിക്കുന്നു എന്നു എന്നോടു അറിയിക്കേണമേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","അവർ ഇവിടെനിന്നു പോയി; നാം ദോഥാനിലേക്കു പോക എന്നു അവർ പറയുന്നതു ഞാൻ കേട്ടു എന്നു അവൻ പറഞ്ഞു. അങ്ങനെ യോസേഫ് തന്റെ സഹോദരന്മാരെ അന്വേഷിച്ചു ചെന്നു ദോഥാനിൽവെച്ചു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","അവർ അവനെ ദൂരത്തു നിന്നു കണ്ടിട്ടു അവനെ കൊല്ലേണ്ടതിന്നു അവൻ അടുത്തുവരുംമുമ്പെ അവന്നു വിരോധമായി ദുരാലോചന ചെയ്തു: ");
INSERT INTO mal2015_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","അതാ, സ്വപ്നക്കാരൻ വരുന്നു; വരുവിൻ, നാം അവനെ കൊന്നു ഒരു കുഴിയിൽ ഇട്ടുകളക; ");
INSERT INTO mal2015_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ഒരു ദുഷ്ടമൃഗം അവനെ തിന്നുകളഞ്ഞു എന്നു പറയാം; അവന്റെ സ്വപ്നങ്ങൾ എന്താകുമെന്നു നമുക്കു കാണാമല്ലോ എന്നു തമ്മിൽ തമ്മിൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","രൂബേൻ അതു കേട്ടിട്ടു: നാം അവന്നു ജീവഹാനി വരുത്തരുതു എന്നു പറഞ്ഞു അവനെ അവരുടെ കയ്യിൽനിന്നു വിടുവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","അവരുടെ കയ്യിൽ നിന്നു അവനെ വിടുവിച്ചു അപ്പന്റെ അടുക്കൽ കൊണ്ടു പോകേണമെന്നു കരുതിക്കൊണ്ടു രൂബേൻ അവരോടു: രക്തം ചൊരിയിക്കരുതു; നിങ്ങൾ അവന്റെമേൽ കൈ വെക്കാതെ മരുഭൂമിയിലുള്ള ആ കുഴിയിൽ അവനെ ഇടുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","യോസേഫ് തന്റെ സഹോദരന്മാരുടെ അടുക്കൽ വന്നപ്പോൾ അവൻ ഉടുത്തിരുന്ന നിലയങ്കി അവർ ഊരി, അവനെ എടുത്തു ഒരു കുഴിയിൽ ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","അതു വെള്ളമില്ലാത്ത പൊട്ടക്കുഴി ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","അവർ ഭക്ഷണം കഴിപ്പാൻ ഇരുന്നപ്പോൾ തലപൊക്കി നോക്കി, ഗിലെയാദിൽനിന്നു സാംപ്രാണിയും സുഗന്ധപ്പശയും സന്നിനായകവും ഒട്ടകപ്പുറത്തു കയറ്റി മിസ്രയീമിലേക്കു കൊണ്ടുപോകുന്ന യിശ്മായേല്യരുടെ ഒരു യാത്രക്കൂട്ടം വരുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","അപ്പോൾ യെഹൂദാ തന്റെ സഹോദരന്മാരോടു: നാം നമ്മുടെ സഹോദരനെ കൊന്നു അവന്റെ രക്തം മറെച്ചിട്ടു എന്തു ഉപകാരം? ");
INSERT INTO mal2015_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","വരുവിൻ, നാം അവനെ യിശ്മായേല്യർക്കു വില്ക്കുക; നാം അവന്റെ മേൽ കൈ വെക്കരുതു; അവൻ നമ്മുടെ സഹോദരനും നമ്മുടെ മാംസവുമല്ലോ എന്നു പറഞ്ഞു; അവന്റെ സാഹോദരന്മാർ അതിന്നു സമ്മതിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","മിദ്യാന്യകച്ചവടക്കാർ കടന്നുപോകുമ്പോൾ അവർ യോസേഫിനെ കുഴിയിൽനിന്നു വലിച്ചു കയറ്റി, യിശ്മായേല്യർക്കു ഇരുപതു വെള്ളിക്കാശിന്നു വിറ്റു. അവർ യോസേഫിനെ മിസ്രയീമിലേക്കു കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","രൂബേൻ തിരികെ കുഴിയുടെ അടുക്കൽ ചെന്നപ്പോൾ യോസേഫ് കുഴിയിൽ ഇല്ല എന്നു കണ്ടു തന്റെ വസ്ത്രം കീറി, ");
INSERT INTO mal2015_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","സഹോദരന്മാരുടെ അടുക്കൽ വന്നു: ബാലനെ കാണുന്നില്ലല്ലോ; ഞാൻ ഇനി എവിടെ പോകേണ്ടു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","പിന്നെ അവർ ഒരു കോലാട്ടുകൊറ്റനെ കൊന്നു, യോസേഫിന്റെ അങ്കി എടുത്തു രക്തത്തിൽ മുക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","അവർ നിലയങ്കി തങ്ങളുടെ അപ്പന്റെ അടുക്കൽ കൊടുത്തയച്ചു: ഇതു ഞങ്ങൾക്കു കണ്ടുകിട്ടി; ഇതു നിന്റെ മകന്റെ അങ്കിയോ അല്ലയോ എന്നു നോക്കേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","അവൻ അതു തിരിച്ചറിഞ്ഞു: ഇതു എന്റെ മകന്റെ അങ്കി തന്നേ; ഒരു ദുഷ്ടമൃഗം അവനെ തിന്നുകളഞ്ഞു: യോസേഫിനെ പറിച്ചുകീറിപ്പോയി എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","യാക്കോബ് വസ്ത്രം കീറി, അരയിൽ രട്ടുശീല ചുറ്റി ഏറിയനാൾ തന്റെ മകനെച്ചൊല്ലി ദുഃഖിച്ചുകൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","അവന്റെ പുത്രന്മാരും പുത്രിമാരും എല്ലാം അവനെ ആശ്വസിപ്പിപ്പാൻ വന്നു; അവനോ ആശ്വാസം കൈക്കൊൾവാൻ മനസ്സില്ലാതെ: ഞാൻ ദുഃഖത്തോടെ എന്റെ മകന്റെ അടുക്കൽ പാതാളത്തിൽ ഇറങ്ങുമെന്നു പറഞ്ഞു. ഇങ്ങനെ അവന്റെ അപ്പൻ അവനെക്കുറിച്ചു കരഞ്ഞുകൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","എന്നാൽ മിദ്യാന്യർ അവനെ മിസ്രയീമിൽ ഫറവോന്റെ ഒരു ഉദ്യോഗസ്ഥനായി അകമ്പടിനായകനായ പോത്തീഫറിന്നു വിറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","അക്കാലത്തു യെഹൂദാ തന്റെ സഹോദരന്മാരെ വിട്ടു ഹീരാ എന്നു പേരുള്ള ഒരു അദുല്ലാമ്യന്റെ അടുക്കൽ ചെന്നു; ");
INSERT INTO mal2015_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","അവിടെ ശൂവാ എന്നു പേരുള്ള ഒരു കനാന്യന്റെ മകളെ കണ്ടു; അവളെ പരിഗ്രഹിച്ചു അവളുടെ അടുക്കൽ ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","അവൾ ഗർഭംധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു; അവന്നു ഏർ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","അവൾ പിന്നെയും ഗർഭംധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു; അവന്നു ഓനാൻ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","അവൾ പിന്നെയും ഗർഭം ധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു; അവന്നു ശേലാ എന്നു പേരിട്ടു. അവൾ ഇവനെ പ്രസവിച്ചപ്പോൾ അവൻ കെസീബിൽ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","യെഹൂദാ തന്റെ ആദ്യജാതനായ ഏരിന്നു താമാർ എന്നു പേരുള്ള ഒരു ഭാര്യയെ എടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","യെഹൂദയുടെ ആദ്യജാതനായ ഏർ യഹോവെക്കു അനിഷ്ടനായിരുന്നതുകൊണ്ടു യഹോവ അവനെ മരിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","അപ്പോൾ യെഹൂദാ ഓനാനോടു: നിന്റെ ജ്യേഷ്ഠന്റെ ഭാര്യയുടെ അടുക്കൽ ചെന്നു അവളോടു ദേവരധർമ്മം അനുഷ്ഠിച്ചു, ജ്യേഷ്ഠന്റെ പേർക്കു സന്തതിയെ ഉളവാക്കുക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","എന്നാൽ ആ സന്തതി തന്റേതായിരിക്കയില്ല എന്നു ഓനാൻ അറികകൊണ്ടു ജ്യേഷ്ഠന്റെ ഭാര്യയുടെ അടുക്കൽ ചെന്നപ്പോൾ ജ്യേഷ്ഠന്നു സന്തതിയെ കൊടുക്കാതിരിക്കേണ്ടതിന്നു നിലത്തു വീഴ്ത്തിക്കളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","അവൻ ചെയ്തതു യഹോവെക്കു അനിഷ്ടമായിരുന്നതുകൊണ്ടു അവൻ ഇവനെയും മരിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","അപ്പോൾ യെഹൂദാ തന്റെ മരുമകളായ താമാരോടു: എന്റെ മകൻ ശേലാ പ്രാപ്തിയാകുവോളം നീ അപ്പന്റെ വീട്ടിൽ വിധവയായി പാർക്ക എന്നു പറഞ്ഞു; ഇവനും സഹോദരന്മാരെപ്പോലെ മരിച്ചുപോകരുതു എന്നു അവൻ വിചാരിച്ചു; അങ്ങനെ താമാർ അപ്പന്റെ വീട്ടിൽപോയി പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","കുറെ കാലം കഴിഞ്ഞിട്ടു ശൂവയുടെ മകൾ യെഹൂദയുടെ ഭാര്യ മരിച്ചു; യെഹൂദയുടെ ദുഃഖം മാറിയശേഷം അവൻ തന്റെ സ്നേഹിതൻ അദുല്ലാമ്യനായ ഹീരയോടുകൂടെ തന്റെ ആടുകളെ രോമം കത്രിക്കുന്ന അടിയന്തരത്തിന്നു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","നിന്റെ അമ്മായപ്പൻ തന്റെ ആടുകളെ രോമം കത്രിക്കുന്ന അടിയന്തരത്തിന്നു തിമ്നെക്കു പോകുന്നു എന്നു താമാരിന്നു അറിവു കിട്ടി. ");
INSERT INTO mal2015_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ശേലാ പ്രാപ്തിയായിട്ടും തന്നെ അവന്നു ഭാര്യയായി കൊടുത്തില്ല എന്നു കണ്ടിട്ടു അവൾ വൈധവ്യവസ്ത്രം മാറ്റിവെച്ചു, ഒരു മൂടുപടം മൂടി പുതെച്ചു തിമ്നെക്കു പോകുന്ന വഴിക്കുള്ള എനയീംപട്ടണത്തിന്റെ ഗോപുരത്തിങ്കൽ ഇരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","യെഹൂദാ അവളെ കണ്ടപ്പോൾ അവൾ മുഖം മൂടിയിരുന്നതു കൊണ്ടു ഒരു വേശ്യ എന്നു നിരൂപിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","അവൻ വഴിയരികെ അവളുടെ അടുക്കലേക്കു തിരിഞ്ഞു തന്റെ മരുമകൾ എന്നു അറിയാതെ: വരിക, ഞാൻ നിന്റെ അടുക്കൽ വരട്ടെ എന്നു പറഞ്ഞു. എന്റെ അടുക്കൽ വരുന്നതിന്നു നീ എനിക്കു എന്തു തരും എന്നു അവൾ ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ഞാൻ ആട്ടിൻകൂട്ടത്തിൽ നിന്നു ഒരു കോലാട്ടിൻകുട്ടിയെ നിനക്കു കൊടുത്തയക്കാം എന്നു അവൻ പറഞ്ഞു. നീ കൊടുത്തയക്കുവോളത്തിന്നു ഒരു പണയം തരുമോ എന്നു അവൾ ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","എന്തു പണയം തരേണം എന്നു അവൻ ചോദിച്ചതിന്നു നിന്റെ മുദ്രമോതിരവും മോതിരച്ചരടും നിന്റെ കയ്യിലെ വടിയും എന്നു അവൾ പറഞ്ഞു. ഇവ അവൾക്കു കൊടുത്തു, അവൻ അവളുടെ അടുക്കൽ ചെന്നു; അവൾ ഗർഭം ധരിക്കയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","പിന്നെ അവൾ എഴുന്നേറ്റു പോയി, തന്റെ മൂടുപടം നീക്കി വൈധവ്യവസ്ത്രം ധരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","സ്ത്രീയുടെ കയ്യിൽനിന്നു പണയം മടക്കി വാങ്ങേണ്ടതിന്നു യെഹൂദാ അദുല്ലാമ്യനായ സ്നേഹിതന്റെ കൈവശം ആട്ടിൻകുട്ടിയെ കൊടുത്തയച്ചു; അവൻ അവളെ കണ്ടില്ല താനും. ");
INSERT INTO mal2015_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","അവൻ ആ സ്ഥലത്തെ ആളുകളോടു: ഏനയീമിൽ വഴിയരികെ ഇരുന്ന വേശ്യ എവിടെ എന്നു ചോദിച്ചതിന്നു: ഇവിടെ ഒരു വേശ്യയും ഉണ്ടായിരുന്നില്ല എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","അവൻ യെഹൂദയുടെ അടുക്കൽ മടങ്ങിവന്നു: ഞാൻ അവളെ കണ്ടില്ല; ഈ സ്ഥലത്തു ഒരു വേശ്യയും ഉണ്ടായിരുന്നില്ല എന്നു അവിടെയുള്ള ആളുകൾ പറഞ്ഞു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","അപ്പോൾ യെഹൂദാ നമുക്കു അപകീർത്തി ഉണ്ടാകാതിരിപ്പാൻ അവൾ അതു എടുത്തുകൊള്ളട്ടെ; ഞാൻ ഈ ആട്ടിൻകുട്ടിയെ കൊടുത്തയച്ചുവല്ലോ; നീ അവളെ കണ്ടില്ലതാനും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ഏകദേശം മൂന്നുമാസം കഴിഞ്ഞിട്ടു: നിന്റെ മരുമകൾ താമാർ പരസംഗംചെയ്തു, പരസംഗത്താൽ ഗർഭിണിയായിരിക്കുന്നു എന്നു യെഹൂദെക്കു അറിവുകിട്ടി. അപ്പോൾ യെഹൂദാ: അവളെ പുറത്തുകൊണ്ടു വരുവിൻ; അവളെ ചുട്ടുകളയേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","അവളെ പുറത്തു കൊണ്ടുവന്നപ്പോൾ അവൾ അമ്മായപ്പന്റെ അടുക്കൽ ആളയച്ചു: ഇവയുടെ ഉടമസ്ഥനായ പുരുഷനാൽ ആകുന്നു ഞാൻ ഗർഭിണിയായിരിക്കുന്നതു; ഈ മുദ്രമോതിരവും മോതിരച്ചരടും വടിയും ആർക്കുള്ളതു എന്നു നോക്കി അറിയേണം എന്നു പറയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","യെഹൂദാ അവയെ അറിഞ്ഞു: അവൾ എന്നിലും നീതിയുള്ളവൾ; ഞാൻ അവളെ എന്റെ മകൻ ശേലാവിന്നു കൊടുത്തില്ല എന്നു പറഞ്ഞു; അതിൽ പിന്നെ അവളെ പരിഗ്രഹിച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","അവൾക്കു പ്രസവകാലം ആയപ്പോൾ അവളുടെ ഗർഭത്തിൽ ഇരട്ടപ്പിള്ളകൾ ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","അവൾ പ്രസവിക്കുമ്പോൾ ഒരു പിള്ള കൈ പുറത്തു നീട്ടി; അപ്പോൾ സൂതികർമ്മിണി ഒരു ചുവന്ന നൂൽ എടുത്തു അവന്റെ കൈക്കു കെട്ടി; ഇവൻ ആദ്യം പുറത്തുവന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","കൈ പിന്നെയും അകത്തേക്കു വലിച്ചു. അവനോ അപ്പോൾ അവന്റെ സഹോദരൻ പുറത്തുവന്നു: നീ ഛിദ്രം ഉണ്ടാക്കിയതു എന്തു എന്നു അവൾ പറഞ്ഞു. അതുകൊണ്ടു അവന്നു പെരെസ്സ് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","അതിന്റെ ശേഷം കൈമേൽ ചുവന്ന നൂലുള്ള അവന്റെ സഹോദരൻ പുറത്തുവന്നു; അവന്നു സേരഹ് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","എന്നാൽ യോസേഫിനെ മിസ്രയീമിലേക്കു കൊണ്ടുപോയി; അവനെ അവിടെ കൊണ്ടുവന്ന യിശ്മായേല്യരുടെ കയ്യിൽനിന്നു ഫറവോന്റെ ഒരു ഉദ്യോഗസ്ഥനായി അകമ്പടിനായകനായ പോത്തീഫർ എന്ന ഒരു മിസ്രയീമ്യൻ അവനെ വിലെക്കു വാങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","യഹോവ യോസേഫിനോടുകൂടെ ഉണ്ടായിരുന്നതുകൊണ്ടു അവൻ കൃതാർത്ഥനായി, മിസ്രയീമ്യനായ യജമാനന്റെ വീട്ടിൽ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","യഹോവ അവനോടുകൂടെ ഉണ്ടെന്നും അവൻ ചെയ്യുന്നതൊക്കെയും യഹോവ സാധിപ്പിക്കുന്നു എന്നും അവന്റെ യജമാനൻ കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","അതുകൊണ്ടു യോസേഫ് അവന്നു ഇഷ്ടനായി ശുശ്രൂഷചെയ്തു; അവൻ അവനെ ഗൃഹവിചാരകനാക്കി, തനിക്കുള്ളതൊക്കെയും അവന്റെ കയ്യിൽ ഏല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","അവൻ തന്റെ വീട്ടിന്നും തനിക്കുള്ള സകലത്തിന്നും അവനെ വിചാരകനാക്കിയതു മുതൽ യഹോവ യോസേഫിന്റെ നിമിത്തം മിസ്രയീമ്യന്റെ വീട്ടിനെ അനുഗ്രഹിച്ചു; വീട്ടിലും വയലിലും അവന്നുള്ള സകലത്തിന്മേലും യഹോവയുടെ അനുഗ്രഹം ഉണ്ടായി. ");
INSERT INTO mal2015_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","അവൻ തനിക്കുള്ളതൊക്കെയും യോസേഫിന്റെ കയ്യിൽ ഏല്പിച്ചു; താൻ ഭക്ഷിക്കുന്ന ഭക്ഷണം ഒഴികെ അവന്റെ കൈവശം ഉള്ള മറ്റു യാതൊന്നും അവൻ അറിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","യോസേഫ് കോമളനും മനോഹരരൂപിയും ആയിരുന്നതുകൊണ്ടു യജമാനന്റെ ഭാര്യ യോസേഫിന്മേൽ കണ്ണു പതിച്ചു: എന്നോടുകൂടെ ശയിക്ക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","അവൻ അതിന്നു സമ്മതിക്കാതെ യജമാനന്റെ ഭാര്യയോടു: ഇതാ, വീട്ടിൽ എന്റെ കൈവശമുള്ള യാതൊന്നും എന്റെ യജമാനൻ അറിയുന്നില്ല; തനിക്കുള്ളതൊക്കെയും എന്റെ കയ്യിൽ ഏല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ഈ വീട്ടിൽ എന്നെക്കാൾ വലിയവനില്ല; നീ അവന്റെ ഭാര്യയാകയാൽ നിന്നെയല്ലാതെ മറ്റു യാതൊന്നും അവൻ എനിക്കു വിരോധിച്ചിട്ടുമില്ല; അതുകൊണ്ടു ഞാൻ ഈ മഹാദോഷം പ്രവർത്തിച്ചു ദൈവത്തോടു പാപം ചെയ്യുന്നതു എങ്ങനെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","അവൾ ദിനം പ്രതിയും യോസേഫിനോടു പറഞ്ഞിട്ടും അവളോടുകൂടെ ശയിപ്പാനോ അവളുടെ അരികെ ഇരിപ്പാനോ അവൻ അവളെ അനുസരിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ഒരു ദിവസം അവൻ തന്റെ പ്രവൃത്തി ചെയ്‌വാൻ വീട്ടിന്നകത്തു ചെന്നു; വീട്ടിലുള്ളവർ ആരും അവിടെ ഇല്ലായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","അവൾ അവന്റെ വസ്ത്രം പിടിച്ചു: എന്നോടു കൂടെ ശയിക്ക എന്നു പറഞ്ഞു: എന്നാൽ അവൻ തന്റെ വസ്ത്രം അവളുടെ കയ്യിൽ വിട്ടേച്ചു പുറത്തേക്കു ഓടിക്കളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","അവൻ വസ്ത്രം തന്റെ കയ്യിൽ വിട്ടേച്ചു പുറത്തേക്കു ഓടിപ്പോയി എന്നു കണ്ടപ്പോൾ, ");
INSERT INTO mal2015_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","അവൾ വീട്ടിലുള്ളവരെ വിളിച്ചു അവരോടു: കണ്ടോ, നമ്മെ ഹാസ്യമാക്കേണ്ടതിന്നു അവൻ ഒരു എബ്രായനെ കൊണ്ടുവന്നിട്ടിരിക്കുന്നു; അവൻ എന്നോടുകൂടെ ശയിക്കേണ്ടതിന്നു എന്റെ അടുക്കൽ വന്നു; എന്നാൽ ഞാൻ ഉറക്കെ നിലവിളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ഞാൻ ഉറക്കെ നിലവിളിച്ചതു കേട്ടപ്പോൾ അവൻ തന്റെ വസ്ത്രം എന്റെ അടുക്കൽ വിട്ടേച്ചു ഓടി പൊയ്ക്കളഞ്ഞു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","യജമാനൻ വീട്ടിൽ വരുവോളം അവൾ ആ വസ്ത്രം തന്റെ പക്കൽ വെച്ചുകൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","അവനോടു അവൾ അവ്വണ്ണം തന്നേ സംസാരിച്ചു: നീ കൊണ്ടുവന്നിരിക്കുന്ന എബ്രായദാസൻ എന്നെ ഹാസ്യമാക്കുവാൻ എന്റെ അടുക്കൽ വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ഞാൻ ഉറക്കെ നിലവിളിച്ചപ്പോൾ അവൻ തന്റെ വസ്ത്രം എന്റെ അടുക്കൽ വിട്ടേച്ചു പുറത്തേക്കു ഓടിപ്പോയി എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","നിന്റെ ദാസൻ ഇങ്ങനെ എന്നോടു ചെയ്തു എന്നു തന്റെ ഭാര്യ പറഞ്ഞ വാക്കു യജമാനൻ കേട്ടപ്പോൾ അവന്നു കോപം ജ്വലിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","യോസേഫിന്റെ യജമാനൻ അവനെ പിടിച്ചു രാജാവിന്റെ ബദ്ധന്മാർ കിടക്കുന്ന കാരാഗൃഹത്തിൽ ആക്കി; അങ്ങനെ അവൻ കാരാഗൃഹത്തിൽ കിടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","എന്നാൽ യഹോവ യോസേഫിനോടുകൂടെ ഇരുന്നു, കാരാഗൃഹപ്രമാണിക്കു അവനോടു ദയ തോന്നത്തക്കവണ്ണം അവന്നു കൃപ നല്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","കാരാഗൃഹത്തിലെ സകലബദ്ധന്മാരെയും കാരാഗൃഹപ്രമാണി യോസേഫിന്റെ കയ്യിൽ ഏല്പിച്ചു; അവരുടെ പ്രവൃത്തിക്കൊക്കെയും അവൻ വിചാരകനായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","യഹോവ അവനോടുകൂടെ ഇരുന്നു അവൻ ചെയ്തതൊക്കെയും സഫലമാക്കുകകൊണ്ടു അവന്റെ കൈക്കീഴുള്ള യാതൊന്നും കാരാഗൃഹ പ്രമാണി നോക്കിയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","അനന്തരം മിസ്രയീംരാജാവിന്റെ പാനപാത്രവാഹകനും അപ്പക്കാരനും മിസ്രയീംരാജാവായ തങ്ങളുടെ യജമാനനോടു കുറ്റം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ഫറവോൻ പാനപാത്രവാഹകന്മാരുടെ പ്രമാണിയും അപ്പക്കാരുടെ പ്രമാണിയുമായ തന്റെ രണ്ടു ഉദ്യോഗസ്ഥന്മാരോടു കോപിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","അവരെ അകമ്പടിനായകന്റെ വീട്ടിൽ യോസേഫ് ബദ്ധനായി കിടന്ന കാരാഗൃഹത്തിൽ ആക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","അകമ്പടിനായകൻ അവരെ യോസേഫിന്റെ പക്കൽ ഏല്പിച്ചു; അവൻ അവർക്കു ശുശ്രൂഷചെയ്തു; അവർ കുറെക്കാലം തടവിൽ കിടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","മിസ്രയീംരാജാവിന്റെ പാനപാത്രവാഹകനും അപ്പക്കാരനും ഇങ്ങനെ കാരാഗൃഹത്തിൽ ബദ്ധന്മാരായിരുന്ന രണ്ടുപേരും ഒരു രാത്രിയിൽ തന്നേ വെവ്വേറെ അർത്ഥമുള്ള ഓരോ സ്വപ്നം കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","രാവിലെ യോസേഫ് അവരുടെ അടുക്കൽ വന്നു നോക്കിയപ്പോൾ അവർ വിഷാദിച്ചിരിക്കുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","അവൻ യജമാനന്റെ വീട്ടിൽ തന്നോടുകൂടെ തടവിൽ കിടക്കുന്നവരായ ഫറവോന്റെ ഉദ്യോഗസ്ഥന്മാരോടു: നിങ്ങൾ ഇന്നു വിഷാദഭാവത്തോടിരിക്കുന്നതു എന്തു എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","അവർ അവനോടു: ഞങ്ങൾ സ്വപ്നം കണ്ടു; വ്യാഖ്യാനിച്ചുതരുവാൻ ആരുമില്ല എന്നു പറഞ്ഞു. യോസേഫ് അവരോടു: സ്വപ്നവ്യാഖ്യാനം ദൈവത്തിന്നുള്ളതല്ലയോ? അതു എന്നോടു പറവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","അപ്പോൾ പാനപാത്രവാഹകന്മാരുടെ പ്രമാണി യോസേഫിനെ തന്റെ സ്വപ്നം അറിയിച്ചു പറഞ്ഞതു: എന്റെ സ്വപ്നത്തിൽ ഇതാ, എന്റെ മുമ്പിൽ ഒരു മുന്തിരി വള്ളി. ");
INSERT INTO mal2015_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","മുന്തിരിവള്ളിയിൽ മൂന്നു കൊമ്പു; അതു തളിർത്തു പൂത്തു; കുലകളിൽ മുന്തിരിങ്ങാ പഴുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ഫറവോന്റെ പാനപാത്രം എന്റെ കയ്യിൽ ഉണ്ടായിരുന്നു; ഞാൻ മുന്തിരിപ്പഴം പറിച്ചു ഫറവോന്റെ പാനപാത്രത്തിൽ പിഴിഞ്ഞു: പാനപാത്രം ഫറവോന്റെ കയ്യിൽ കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","യോസേഫ് അവനോടു പറഞ്ഞതു: അതിന്റെ അർത്ഥം ഇതാകുന്നു: മൂന്നു കൊമ്പു മൂന്നു ദിവസം. ");
INSERT INTO mal2015_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","മൂന്നു ദിവസത്തിന്നകം ഫറവോൻ നിന്നെ കടാക്ഷിച്ചു, വീണ്ടും നിന്റെ സ്ഥാനത്തു ആക്കും. നീ പാനപാത്രവാഹകനായി മുമ്പിലത്തെ പതിവുപോലെ ഫറവോന്റെ കയ്യിൽ പാനപാത്രം കൊടുക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","എന്നാൽ നീ ശുഭമായിരിക്കുമ്പോൾ എന്നെ ഓർത്തു എന്നോടു ദയ ചെയ്തു ഫറവോനെ എന്റെ വസ്തുത ബോധിപ്പിച്ചു എന്നെ ഈ വീട്ടിൽനിന്നു വിടുവിക്കേണമേ. ");
INSERT INTO mal2015_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","എന്നെ എബ്രായരുടെ ദേശത്തുനിന്നു കട്ടുകൊണ്ടുപോന്നതാകുന്നു; ഈ കുണ്ടറയിൽ എന്നെ ഇടേണ്ടതിന്നു ഞാൻ ഇവിടെയും യാതൊന്നും ചെയ്തിട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","അർത്ഥം നല്ലതെന്നു അപ്പക്കാരുടെ പ്രമാണി കണ്ടിട്ടു യോസേഫിനോടു: ഞാനും സ്വപ്നത്തിൽ എന്റെ തലയിൽ വെളുത്ത അപ്പമുള്ള മൂന്നു കൊട്ട കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","മേലത്തെ കൊട്ടയിൽ ഫറവോന്റെ വക അപ്പത്തരങ്ങൾ ഒക്കെയും ഉണ്ടായിരുന്നു; പക്ഷികൾ എന്റെ തലയിലെ കൊട്ടയിൽ നിന്നു അവയെ തിന്നുകളഞ്ഞു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","അതിന്നു യോസേഫ്: അതിന്റെ അർത്ഥം ഇതാകുന്നു: മൂന്നു കൊട്ട മൂന്നു ദിവസം. ");
INSERT INTO mal2015_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","മൂന്നു ദിവസത്തിന്നകം ഫറവോൻ നിന്റെ തല വെട്ടി നിന്നെ ഒരു മരത്തിന്മേൽ തൂക്കും; പക്ഷികൾ നിന്റെ മാംസം തിന്നുകളയും എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","മൂന്നാം നാളിൽ ഫറവോന്റെ തിരുനാളിൽ അവൻ തന്റെ സകലദാസന്മാർക്കും ഒരു വിരുന്നുകഴിച്ചു. തന്റെ ദാസന്മാരുടെ മദ്ധ്യേ പാനപാത്ര വാഹകന്മാരുടെ പ്രമാണിയെയും അപ്പക്കാരുടെ പ്രമാണിയെയും ഓർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","പാനപാത്രവാഹകന്മാരുടെ പ്രമാണിയെ ഫറവോന്റെ കയ്യിൽ പാനപാത്രം കൊടുക്കേണ്ടതിന്നു വീണ്ടും അവന്റെ സ്ഥാനത്തു ആക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","അപ്പക്കാരുടെ പ്രമാണിയെയോ അവൻ തൂക്കിച്ചു; യോസേഫ് അർത്ഥം പറഞ്ഞതുപോലെ തന്നെ. ");
INSERT INTO mal2015_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","എങ്കിലും പാനപാത്രവാഹകന്മാരുടെ പ്രമാണി യോസേഫിനെ ഓർക്കാതെ അവനെ മറന്നുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","രണ്ടു സംവത്സരം കഴിഞ്ഞശേഷം ഫറവോൻ ഒരു സ്വപ്നം കണ്ടതെന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","അവൻ നദീതീരത്തു നിന്നു. അപ്പോൾ രൂപഗുണവും മാംസപുഷ്ടിയുമുള്ള ഏഴു പശു നദിയിൽനിന്നു കയറി, ഞാങ്ങണയുടെ ഇടയിൽ മേഞ്ഞുകൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","അവയുടെ പിന്നാലെ മെലിഞ്ഞും വിരൂപമായുമുള്ള വേറെ ഏഴു പശു നദിയിൽ നിന്നു കയറി, നദീതീരത്തു മറ്റേ പശുക്കളുടെ അരികെ നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","മെലിഞ്ഞും വിരൂപമായുമുള്ള പശുക്കൾ രൂപഗുണവും മാംസപുഷ്ടിയുമുള്ള ഏഴു പശുക്കളെ തിന്നുകളഞ്ഞു; അപ്പോൾ ഫറവോൻ ഉണർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","അവൻ പിന്നെയും ഉറങ്ങി, രണ്ടാമതും ഒരു സ്വപ്നം കണ്ടു; പുഷ്ടിയുള്ളതും നല്ലതുമായ ഏഴു കതിർ ഒരു തണ്ടിൽ നിന്നു പൊങ്ങി വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","അവയുടെ പിന്നാലെ നേർത്തും കിഴക്കൻ കാറ്റിനാൽ കരിഞ്ഞുമിരിക്കുന്ന ഏഴു കതിർ പൊങ്ങിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","നേർത്ത ഏഴു കതിരുകൾ പുഷ്ടിയും മണിക്കരുത്തുമുള്ള ഏഴു കതിരുകളെ വിഴുങ്ങിക്കളഞ്ഞു. അപ്പോൾ ഫറവോൻ ഉണർന്നു, അതു സ്വപ്നം എന്നു അറിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","പ്രാതഃകാലത്തു അവൻ വ്യാകുലപ്പെട്ടു മിസ്രയീമിലെ മന്ത്രവാദികളെയും ജ്ഞാനികളെയും എല്ലാം ആളയച്ചു വരുത്തി അവരോടു തന്റെ സ്വപ്നം പറഞ്ഞു. എന്നാൽ വ്യാഖ്യാനിപ്പാൻ ആർക്കും കഴിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","അപ്പോൾ പാനപാത്രവാഹകന്മാരുടെ പ്രമാണി ഫറവോനോടു പറഞ്ഞതു: ഇന്നു ഞാൻ എന്റെ കുറ്റം ഓർക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ഫറവോൻ അടിയങ്ങളോടു കോപിച്ചു, എന്നെയും അപ്പക്കാരുടെ പ്രമാണിയെയും അകമ്പടിനായകന്റെ വീട്ടിൽ തടവിലാക്കിയിരുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","അവിടെവെച്ചു ഞാനും അവനും ഒരു രാത്രിയിൽ തന്നേ സ്വപ്നം കണ്ടു; വെവ്വേറെ അർത്ഥമുള്ള സ്വപ്നം ആയിരുന്നു ഓരോരുത്തൻ കണ്ടതു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","അവിടെ അകമ്പടി നായകന്റെ ദാസനായ ഒരു എബ്രായ യൗവനക്കാരൻ ഞങ്ങളോടുകൂടെ ഉണ്ടായിരുന്നു; ഞങ്ങൾ അവനോടു അറിയിച്ചാറെ അവൻ സ്വപ്നങ്ങളെ വ്യാഖ്യാനിച്ചു; ഓരോരുത്തന്നു താന്താന്റെ സ്വപ്നത്തിന്റെ അർത്ഥം പറഞ്ഞുതന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","അവൻ അർത്ഥം പറഞ്ഞതുപോലെ തന്നേ സംഭവിച്ചു; എന്നെ വീണ്ടും സ്ഥാനത്തു ആക്കുകയും മറ്റവനെ തൂക്കിക്കളകയും ചെയ്തുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ഉടനെ ഫറവോൻ ആളയച്ചു യോസേഫിനെ വിളിപ്പിച്ചു. അവർ അവനെ വേഗത്തിൽ കുണ്ടറയിൽനിന്നു ഇറക്കി; അവൻ ക്ഷൗരം ചെയ്യിച്ചു, വസ്ത്രം മാറി, ഫറവോന്റെ അടുക്കൽ ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ഫറവോൻ യോസേഫിനോടു: ഞാൻ ഒരു സ്വപ്നം കണ്ടു; അതിനെ വ്യാഖ്യനിപ്പാൻ ആരുമില്ല; എന്നാൽ നീ ഒരു സ്വപ്നം കേട്ടാൽ വ്യാഖ്യാനിക്കുമെന്നു നിന്നെക്കുറിച്ചു ഞാൻ കേട്ടിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","അതിന്നു യോസേഫ് ഫറവോനോടു: ഞാനല്ല ദൈവം തന്നേ ഫറവോന്നു ശുഭമായോരു ഉത്തരം നല്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","പിന്നെ ഫറവോൻ യോസേഫിനോടു പറഞ്ഞതു: എന്റെ സ്വപ്നത്തിൽ ഞാൻ നദീതീരത്തു നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","അപ്പോൾ മാംസപുഷ്ടിയും രൂപഗുണവുമുള്ള ഏഴു പശു നദിയിൽനിന്നു കയറി ഞാങ്ങണയുടെ ഇടയിൽ മേഞ്ഞുകൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","അവയുടെ പിന്നാലെ ക്ഷീണിച്ചും മെലിഞ്ഞും എത്രയും വിരൂപമായുമുള്ള വേറെ ഏഴു പശു കയറി വന്നു; അത്ര വിരൂപമായവയെ ഞാൻ മിസ്രയീംദേശത്തു എങ്ങും കണ്ടിട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","എന്നാൽ മെലിഞ്ഞും വിരൂപമായുമുള്ള പശുക്കൾ പുഷ്ടിയുള്ള മുമ്പിലത്തെ ഏഴു പശുക്കളെ തിന്നുകളഞ്ഞു; ");
INSERT INTO mal2015_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ഇവ അവയുടെ വയറ്റിൽ ചെന്നിട്ടും വയറ്റിൽ ചെന്നു എന്നു അറിവാനില്ലായിരന്നു; അവ മുമ്പിലത്തെപ്പോലെ തന്നേ വിരൂപമുള്ളവ ആയിരുന്നു. അപ്പോൾ ഞാൻ ഉണർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","പിന്നെയും ഞാൻ സ്വപ്നത്തിൽ കണ്ടതു: നിറഞ്ഞതും നല്ലതുമായ ഏഴു കതിർ ഒരു തണ്ടിൽ പൊങ്ങിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","അവയുടെ പിന്നാലെ ഉണങ്ങിയും നേർത്തും കിഴക്കൻ കാറ്റിനാൽ കരിഞ്ഞുമിരിക്കുന്ന ഏഴു കതിർ പൊങ്ങിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","നേർത്ത കതിരുകൾ ഏഴു നല്ല കതിരുകളെ വിഴുങ്ങിക്കളഞ്ഞു. ഇതു ഞാൻ മന്ത്രവാദികളോടു പറഞ്ഞു; എന്നാൽ വ്യാഖ്യാനിപ്പാൻ ആർക്കും കഴിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","അപ്പോൾ യോസേഫ് ഫറവോനോടു പറഞ്ഞതു: ഫറവോന്റെ സ്വപ്നം ഒന്നുതന്നേ; താൻ ചെയ്‌വാൻ ഭാവിക്കുന്നതു ദൈവം ഫറവോന്നു വെളിപ്പെടുത്തിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ഏഴു നല്ല പശു ഏഴു സംവത്സരം; നല്ല കതിരും ഏഴു സംവത്സരം; സ്വപ്നം ഒന്നു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","അവയുടെ പിന്നാലെ കയറിവന്ന മെലിഞ്ഞും വിരൂപമായുമുള്ള ഏഴു പശുവും കിഴക്കൻ കാറ്റിനാൽ കരിഞ്ഞു പതിരായുള്ള ഏഴു കതിരും ഏഴു സംവത്സരം; അവ ക്ഷാമമുള്ള ഏഴു സംവത്സരം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ദൈവം ചെയ്‌വാൻ ഭാവിക്കുന്നതു ഫറവോന്നു കാണിച്ചു തന്നിരിക്കുന്നു. അതാകുന്നു ഞാൻ ഫറവോനോടു പറഞ്ഞതു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","മിസ്രയീംദേശത്തു ഒക്കെയും ബഹു സുഭിക്ഷമായ ഏഴു സംവത്സരം വരും. ");
INSERT INTO mal2015_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","അതു കഴിഞ്ഞിട്ടു ക്ഷാമമുള്ള ഏഴു സംവത്സരം വരും; അപ്പോൾ മിസ്രയീംദേശത്തു ആ സുഭിക്ഷതയൊക്കെയും മറന്നിരിക്കും; ക്ഷാമത്താൽ ദേശം ഒക്കെയും ക്ഷയിച്ചുപോകും. ");
INSERT INTO mal2015_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","പിൻവരുന്ന ക്ഷാമം അതികഠിനമായിരിക്കയാൽ ദേശത്തുണ്ടായിരുന്ന സുഭിക്ഷത അറിയാതെയായിപ്പോകും. ");
INSERT INTO mal2015_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ഫറവോന്നു സ്വപ്നം രണ്ടുവട്ടം ഉണ്ടായതോ കാര്യം ദൈവത്തിന്റെ മുമ്പാകെ സ്ഥിരമായിരിക്കകൊണ്ടും ദൈവം അതിനെ വേഗത്തിൽ വരുത്തുവാനിരിക്കകൊണ്ടും ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ആകയാൽ ഫറവോൻ വിവേകവും ജ്ഞാനവുമുള്ള ഒരുത്തനെ അന്വേഷിച്ചു മിസ്രയീംദേശത്തിന്നു മേലധികാരി ആക്കി വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","അതുകൂടാതെ ഫറവോൻ ദേശത്തിന്മേൽ വിചാരകന്മാരെ ആക്കി, സുഭിക്ഷതയുള്ള ഏഴു സംവത്സരത്തിൽ മിസ്രയീംദേശത്തിലെ വിളവിൽ അഞ്ചിലൊന്നു വാങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ഈ വരുന്ന നല്ല സംവത്സരങ്ങളിലെ വിളവൊക്കെയും ശേഖരിച്ചു പട്ടണങ്ങളിൽ ഫറവോന്റെ അധീനത്തിൽ ധാന്യം സൂക്ഷിച്ചുവെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ആ ധാന്യം മിസ്രയീംദേശത്തു വരുവാൻ പോകുന്ന ക്ഷാമമുള്ള ഏഴുസംവത്സരത്തേക്കു ദേശത്തിന്നു സംഗ്രഹമായിട്ടിരിക്കേണം; എന്നാൽ ദേശം ക്ഷാമംകൊണ്ടു നശിക്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ഈ വാക്കു ഫറവോന്നും അവന്റെ സകലഭൃത്യന്മാർക്കും ബോധിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ഫറവോൻ തന്റെ ഭൃത്യന്മാരോടു: ദൈവാത്മാവുള്ള ഈ മനുഷ്യനെപ്പോലെ ഒരുത്തനെ കണ്ടുകിട്ടുമോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","പിന്നെ ഫറവോൻ യോസേഫിനോടു: ദൈവം ഇതൊക്കെയും നിനക്കു വെളിപ്പെടുത്തി തന്നതുകൊണ്ടു നിന്നെപ്പോലെ വിവേകവും ജ്ഞാനവുമുള്ളവൻ ഒരുത്തനുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","നീ എന്റെ ഗൃഹത്തിന്നു മേലധികാരിയാകും; നിന്റെ വാക്കു എന്റെ ജനമെല്ലാം അനുസരിച്ചു നടക്കും; സിംഹാസനംകൊണ്ടു മാത്രം ഞാൻ നിന്നെക്കാൾ വലിയവനായിരിക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ഇതാ, മിസ്രയീംദേശത്തിന്നൊക്കെയും ഞാൻ നിന്നെ മേലധികാരി ആക്കിയിരിക്കുന്നു, എന്നും ഫറവോൻ യോസേഫിനോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ഫറവോൻ തന്റെ കയ്യിൽനിന്നു മുദ്രമോതിരം ഊരി, യോസേഫിന്റെ കൈക്കു ഇട്ടു, അവനെ നേർമ്മയുള്ള വസ്ത്രംധരിപ്പിച്ചു, ഒരു സ്വർണ്ണസരപ്പളിയും അവന്റെ കഴുത്തിൽ ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","തന്റെ രണ്ടാം രഥത്തിൽ അവനെ കയറ്റി: മുട്ടുകുത്തുവിൻ എന്നു അവന്റെ മുമ്പിൽ വിളിച്ചു പറയിച്ചു; ഇങ്ങനെ അവനെ മിസ്രയീംദേശത്തിന്നൊക്കെയും മേലധികാരിയാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","പിന്നെ ഫറവോൻ യോസേഫിനോടു: ഞാൻ ഫറവോൻ ആകുന്നു; നിന്റെ കല്പന കൂടാതെ മിസ്രയീംദേശത്തു എങ്ങും യാതൊരുത്തനും കയ്യോ കാലോ അനക്കുകയില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ഫറവോൻ യോസേഫിന്നു സാപ്നത്ത് പനേഹ് എന്നു പേരിട്ടു; ഓനിലെ പുരോഹിതനായ പോത്തിഫേറയുടെ മകൾ ആസ്നത്തിനെ അവന്നു ഭാര്യയായി കൊടുത്തു. പിന്നെ യോസേഫ് മിസ്രയീംദേശത്തു സഞ്ചരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","യോസേഫ് മിസ്രയീംരാജാവായ ഫറവോന്റെ മുമ്പാകെ നില്ക്കുമ്പോൾ അവന്നു മുപ്പതു വയസ്സായിരുന്നു. യോസേഫ് ഫറവോന്റെ സന്നിധാനത്തിൽനിന്നു പുറപ്പെട്ടു മിസ്രയീംദേശത്തു ഒക്കെയും സഞ്ചരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","എന്നാൽ സുഭിക്ഷമായ ഏഴു സംവത്സരവും ദേശം സമൃദ്ധിയായി വിളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","മിസ്രയീംദേശത്തു സുഭിക്ഷത ഉണ്ടായ ഏഴു സംവത്സരത്തിലെ ധാന്യം ഒക്കെയും അവൻ ശേഖരിച്ചു പട്ടണങ്ങളിൽ സൂക്ഷിച്ചു; ഓരോ പട്ടണത്തിൽ ചുറ്റുവട്ടത്തുള്ള നിലത്തിലെ ധാന്യം സൂക്ഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","അങ്ങനെ യോസേഫ് കടൽകരയിലെ മണൽപോലെ എത്രയും വളരെ ധാന്യം ശേഖരിച്ചു വെച്ചു; അളപ്പാൻ കഴിവില്ലായ്കയാൽ അളവു നിർത്തിക്കളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ക്ഷാമകാലം വരുംമുമ്പെ യോസേഫിന്നു രണ്ടു പുത്രന്മാർ ജനിച്ചു; അവരെ ഓനിലെ പുരോഹിതനായ പോത്തിഫേറയുടെ മകൾ ആസ്നത്ത് പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","എന്റെ സകല കഷ്ടതയും എന്റെ പിതൃഭവനം ഒക്കെയും ദൈവം എന്നെ മറക്കുമാറാക്കി എന്നു പറഞ്ഞു യോസേഫ് തന്റെ ആദ്യജാതന്നു മനശ്ശെ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","സങ്കടദേശത്തു ദൈവം എന്നെ വർദ്ധിപ്പിച്ചു എന്നു പറഞ്ഞു, അവൻ രണ്ടാമത്തവന്നു എഫ്രയീം എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","മിസ്രയീംദേശത്തുണ്ടായ സുഭിക്ഷതയുള്ള ഏഴു സംവത്സരം കഴിഞ്ഞപ്പോൾ ");
INSERT INTO mal2015_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","യോസേഫ് പറഞ്ഞതുപോലെ ക്ഷാമമുള്ള ഏഴു സംവത്സരം തുടങ്ങി; സകലദേശങ്ങളിലും ക്ഷാമമുണ്ടായി; എന്നാൽ മിസ്രയീംദേശത്തു എല്ലാടവും ആഹാരം ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","പിന്നെ മിസ്രയീംദേശത്തു എല്ലാടവും ക്ഷാമം ഉണ്ടായപ്പോൾ ജനങ്ങൾ ആഹാരത്തിന്നായി ഫറവോനോടു നിലവിളിച്ചു; ഫറവോൻ മിസ്രയീമ്യരോടു ഒക്കെയും: നിങ്ങൾ യോസേഫിന്റെ അടുക്കൽ ചെല്ലുവിൻ; അവൻ നിങ്ങളോടു പറയുംപോലെ ചെയ്‌വിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ക്ഷാമം ഭൂതലത്തിലൊക്കെയും ഉണ്ടായി; യോസേഫ് പാണ്ടികശാലകൾ ഒക്കെയും തുറന്നു, മിസ്രയീമ്യർക്കു ധാന്യം വിറ്റു; ക്ഷാമം മിസ്രയീംദേശത്തും കഠിനമായ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ഭൂമിയിൽ എങ്ങും ക്ഷാമം കഠിനമായയ്തീർന്നതുകൊണ്ടു സകലദേശക്കാരും ധാന്യം കൊള്ളുവാൻ മിസ്രയീമിൽ യോസേഫിന്റെ അടുക്കൽ വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","മിസ്രയീമിൽ ധാന്യം ഉണ്ടെന്നു യാക്കോബ് അറിഞ്ഞപ്പോൾ തന്റെ പുത്രന്മാരോടു: നിങ്ങൾ തമ്മിൽ തമ്മിൽ നോക്കിനില്ക്കുന്നതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","മിസ്രയീമിൽ ധാന്യം ഉണ്ടെന്നു ഞാൻ കേട്ടിരിക്കുന്നു; നാം മരിക്കാതെ ജീവിച്ചിരിക്കേണ്ടതിന്നു അവിടെ ചെന്നു അവിടെ നിന്നു നമുക്കു ധാന്യം കൊള്ളുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","യോസേഫിന്റെ സഹോദരന്മാർ പത്തു പേർ മിസ്രയീമിൽ ധാന്യം കൊള്ളുവാൻ പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","എന്നാൽ യോസേഫിന്റെ അനുജനായ ബെന്യാമീന്നു പക്ഷേ വല്ല ആപത്തും ഭവിക്കും എന്നുവെച്ചു യാക്കോബ് അവനെ സഹോദരന്മാരോടുകൂടെ അയച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","അങ്ങനെ ധാന്യം കൊള്ളുവാൻ വന്നവരുടെ ഇടയിൽ യിസ്രായേലിന്റെ പുത്രന്മാരും വന്നു; കനാൻദേശത്തും ക്ഷാമം ഉണ്ടായിരുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","യോസേഫ് ദേശത്തിന്നു അധിപതിയായിരുന്നു; അവൻ തന്നേ ആയിരുന്നു ദേശത്തിലെ സകല ജനങ്ങൾക്കും ധാന്യം വിറ്റതു; യോസേഫിന്റെ സഹോദരന്മാരും വന്നു അവനെ സാഷ്ടാംഗം നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","യോസഫ് തന്റെ സഹോദരന്മാരെ കണ്ടാറെ അവരെ അറിഞ്ഞു എങ്കിലും അറിയാത്ത ഭാവം നടിച്ചു അവരോടു കഠിനമായി സംസാരിച്ചു: നിങ്ങൾ എവിടെ നിന്നു വരുന്നു എന്നു അവരോടു ചോദിച്ചതിന്നു: ആഹാരം കൊള്ളുവാൻ കനാൻദേശത്തു നിന്നു വരുന്നു എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","യോസേഫ് സഹോദരന്മാരെ അറിഞ്ഞു എങ്കിലും അവർ അവനെ അറിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","യോസേഫ് അവരെക്കുറിച്ചു കണ്ടിരുന്ന സ്വപ്നങ്ങൾ ഓർത്തു അവരോടു: നിങ്ങൾ ഒറ്റുകാരാകുന്നു; ദേശത്തിന്റെ ദുർബ്ബലഭാഗം നോക്കുവാൻ നിങ്ങൾ വന്നിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","അവർ അവനോടു: അല്ല, യജമാനനേ, അടിയങ്ങൾ ആഹാരം കൊള്ളുവാൻ വന്നിരിക്കുന്നു; ");
INSERT INTO mal2015_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ഞങ്ങൾ എല്ലാവരും ഒരാളുടെ മക്കൾ; ഞങ്ങൾ പരമാർത്ഥികളാകുന്നു; അടിയങ്ങൾ ഒറ്റുകാരല്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","അവൻ അവരോടു: അല്ല, നിങ്ങൾ ദേശത്തിന്റെ ദുർബ്ബലഭാഗം നോക്കുവാൻ വന്നിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","അതിന്നു അവർ: അടിയങ്ങൾ കനാൻദേശത്തുള്ള ഒരാളുടെ മക്കൾ; പന്ത്രണ്ടു സഹോദരന്മാർ ആകുന്നു; ഇളയവൻ ഇന്നു ഞങ്ങളുടെ അപ്പന്റെ അടുക്കൽ ഉണ്ടു; ഒരുത്തൻ ഇപ്പോൾ ഇല്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","യോസേഫ് അവരോടു പറഞ്ഞതു: ഞാൻ പറഞ്ഞതുപോലെ നിങ്ങൾ ഒറ്റുകാർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ഇതിനാൽ ഞാൻ നിങ്ങളെ പരീക്ഷിക്കും; നിങ്ങളുടെ ഇളയസഹോദരൻ ഇവിടെ വന്നല്ലാതെ, ഫറവോനാണ, നിങ്ങൾ ഇവിടെനിന്നു പുറപ്പെടുകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","നിങ്ങളുടെ സഹോദരനെ കൂട്ടിക്കൊണ്ടുവരുവാൻ നിങ്ങളിൽ ഒരുത്തനെ അയപ്പിൻ; നിങ്ങളോ ബദ്ധന്മാരായിരിക്കേണം; നിങ്ങൾ നേരുള്ളവരോ എന്നു നിങ്ങളുടെ വാക്കു പരീക്ഷിച്ചറിയാമല്ലോ; അല്ലെന്നുവരികിൽ; ഫറവോനാണ, നിങ്ങൾ ഒറ്റുകാർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","അങ്ങനെ അവൻ അവരെ മൂന്നു ദിവസം തടവിൽ ആക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","മൂന്നാം ദിവസം യോസേഫ് അവരോടു പറഞ്ഞതു: ഞാൻ ദൈവത്തെ ഭയപ്പെടുന്നു; നിങ്ങൾ ജീവിച്ചിരിക്കേണ്ടതിന്നു ഇതു ചെയ്‌വിൻ: ");
INSERT INTO mal2015_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","നിങ്ങൾ പരമാർത്ഥികൾ എങ്കിൽ നിങ്ങളുടെ ഒരു സഹോദരൻ കാരാഗൃഹത്തിൽ കിടക്കട്ടെ; നിങ്ങൾ പുറപ്പെട്ടു, നിങ്ങളുടെ വീടുകളിലെ ബുദ്ധിമുട്ടിന്നു ധാന്യം കൊണ്ടുപോകുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","എന്നാൽ നിങ്ങളുടെ ഇളയസഹോദരനെ എന്റെ അടുക്കൽ കൊണ്ടുവരേണം; അതിനാൽ നിങ്ങളുടെ വാക്കു നേരെന്നു തെളിയും; നിങ്ങൾ മരിക്കേണ്ടിവരികയില്ല; അവർ അങ്ങനെ സമ്മതിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ഇതു നമ്മുടെ സഹോദരനോടു നാം ചെയ്ത ദ്രോഹമാകുന്നു; അവൻ നമ്മോടു കെഞ്ചിയപ്പോൾ നാം അവന്റെ പ്രാണസങ്കടം കണ്ടാറെയും അവന്റെ അപേക്ഷ കേട്ടില്ലല്ലോ; അതുകൊണ്ടു ഈ സങ്കടം നമുക്കു വന്നിരിക്കുന്നു എന്നു അവർ തമ്മിൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","അതിന്നു രൂബേൻ: ബാലനോടു ദോഷം ചെയ്യരുതെന്നു ഞാൻ നിങ്ങളോടു പറഞ്ഞില്ലയോ? എന്നിട്ടും നിങ്ങൾ കേട്ടില്ല; ഇപ്പോൾ ഇതാ, അവന്റെ രക്തം നമ്മോടു ചോദിക്കുന്നു എന്നു അവരോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","യോസേഫ് അവരോടു സംസാരിച്ചതു ദ്വിഭാഷിമുഖാന്തരം ആയിരുന്നതുകൊണ്ടു അവൻ ഇതു ഗ്രഹിച്ചു എന്നു അവർ അറിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","അവൻ അവരെ വിട്ടു മാറിപ്പോയി കരഞ്ഞു; പിന്നെ അവരുടെ അടുക്കൽ വന്നു അവരോടു സംസാരിച്ചു അവരുടെ കൂട്ടത്തിൽ നിന്നു ശിമെയോനെ പിടിച്ചു അവർ കാൺകെ ബന്ധിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","അവരുടെ ചാക്കിൽ ധാന്യം നിറെപ്പാനും അവരുടെ ദ്രവ്യം അവനവന്റെ ചാക്കിൽ തിരികെ വെപ്പാനും വഴിക്കു വേണ്ടിയ ആഹാരം അവർക്കു കൊടുപ്പാനും യോസേഫ് കല്പിച്ചു; അങ്ങനെ തന്നേ അവർക്കു ചെയ്തുകൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","അവർ ധാന്യം കഴുതപ്പുറത്തു കയറ്റി അവിടെനിന്നു പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","വഴിയമ്പലത്തിൽവെച്ചു അവരിൽ ഒരുത്തൻ കഴുതെക്കു തീൻ കൊടുപ്പാൻ ചാക്കു അഴിച്ചപ്പോൾ തന്റെ ദ്രവ്യം ചാക്കിന്റെ വായ്ക്കൽ ഇരിക്കുന്നതു കണ്ടു, ");
INSERT INTO mal2015_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","തന്റെ സഹോദരന്മാരോടു: എന്റെ ദ്രവ്യം എനിക്കു തിരികെ കിട്ടി അതു ഇതാ, എന്റെ ചാക്കിൽ ഇരിക്കുന്നു എന്നു പറഞ്ഞു. അപ്പോൾ അവരുടെ ഉള്ളം തളർന്നു, അവർ വിറെച്ചു: ദൈവം നമ്മോടു ഈ ചെയ്തതു എന്തെന്നു തമ്മിൽ തമ്മിൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","അവർ കനാൻദേശത്തു തങ്ങളുടെ അപ്പനായ യാക്കോബിന്റെ അടുക്കൽ എത്തിയാറെ, തങ്ങൾക്കു സംഭവിച്ചതു ഒക്കെയും അവനോടു അറിയിച്ചു പറഞ്ഞതു: ");
INSERT INTO mal2015_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ദേശത്തിലെ അധിപതിയായവൻ ഞങ്ങൾ ദേശത്തെ ഒറ്റുനോക്കുന്നവർ എന്നു വിചാരിച്ചു ഞങ്ങളോടു കഠിനമായി സംസാരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ഞങ്ങൾ അവനോടു: ഞങ്ങൾ പരാമാർത്ഥികളാകുന്നു, ഞങ്ങൾ ഒറ്റുകാരല്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ഞങ്ങൾ ഒരു അപ്പന്റെ മക്കൾ; പന്ത്രണ്ടു സഹോരന്മാരാകുന്നു; ഒരുത്തൻ ഇപ്പോൾ ഇല്ല; ഇളയവൻ കനാൻദേശത്തു ഞങ്ങളുടെ അപ്പന്റെ അടുക്കൽ ഉണ്ടു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","അതിന്നു ദേശത്തിലെ അധിപതിയായവൻ ഞങ്ങളോടു പറഞ്ഞതു: നിങ്ങൾ പരമാർത്ഥികൾ എന്നു ഞാൻ ഇതിനാൽ അറിയും: നിങ്ങളുടെ ഒരു സഹോദരനെ എന്റെ അടുക്കൽ വിട്ടേച്ചു നിങ്ങളുടെ വീടുകളിലെ ബുദ്ധിമുട്ടിന്നു ധാന്യം വാങ്ങി കൊണ്ടുപോകുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","നിങ്ങളുടെ ഇളയസഹോദരനെ എന്റെ അടുക്കൽ കൊണ്ടുവരുവിൻ; അതിനാൽ നിങ്ങൾ ഒറ്റുകാരല്ല, പരമാർത്ഥികൾ തന്നേ എന്നു ഞാൻ അറിയും; നിങ്ങളുടെ സഹോദരനെ നിങ്ങൾക്കു ഏല്പിച്ചുതരും; നിങ്ങൾക്കു ദേശത്തു വ്യാപാരവും ചെയ്യാം. ");
INSERT INTO mal2015_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","പിന്നെ അവർ ചാക്കു ഒഴിക്കുമ്പോൾ ഇതാ, ഓരോരുത്തന്റെ ചാക്കിൽ അവനവന്റെ പണക്കെട്ടു ഇരിക്കുന്നു; അവരും അവരുടെ അപ്പനും പണക്കെട്ടു കണ്ടാറെ ഭയപ്പെട്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","അവരുടെ അപ്പനായ യാക്കോബ് അവരോടു: നിങ്ങൾ എന്നെ മക്കളില്ലാത്തവനാക്കുന്നു; യോസേഫ് ഇല്ല, ശിമെയോൻ ഇല്ല; ബെന്യാമീനെയും നിങ്ങൾ കൊണ്ടുപോകും; സകലവും എനിക്കു പ്രതികൂലം തന്നേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","അതിന്നു രൂബേൻ അപ്പനോടു: എന്റെ കയ്യിൽ അവനെ ഏല്പിക്ക; ഞാൻ അവനെ നിന്റെ അടുക്കൽ മടക്കി കൊണ്ടുവരും; ഞാൻ അവനെ നിന്റെ അടുക്കൽ കൊണ്ടുവരാത്തപക്ഷം എന്റെ രണ്ടു പുത്രന്മാരെ കൊന്നുകളക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","എന്നാൽ അവൻ: എന്റെ മകൻ നിങ്ങളോടുകൂടെ പോരികയില്ല; അവന്റെ ജ്യേഷ്ഠൻ മരിച്ചുപോയി, അവൻ ഒരുത്തനേ ശേഷിപ്പുള്ളു; നിങ്ങൾ പോകുന്ന വഴിയിൽ അവന്നു വല്ല ആപത്തും വന്നാൽ നിങ്ങൾ എന്റെ നരയെ ദുഃഖത്തോടെ പാതാളത്തിലേക്കു ഇറങ്ങുമാറാക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","എന്നാൽ ക്ഷാമം ദേശത്തു കഠിനമായി തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","അവർ മിസ്രയീമിൽനിന്നു കൊണ്ടുവന്ന ധാന്യം തിന്നു തീർന്നപ്പോൾ അവരുടെ അപ്പൻ അവരോടു: നിങ്ങൾ ഇനിയും പോയി കുറെ ആഹാരം കൊള്ളുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","അതിന്നു യെഹൂദാ അവനോടു പറഞ്ഞതു: നിങ്ങളുടെ സഹോദരൻ നിങ്ങളോടുകൂടെ ഇല്ലാതിരുന്നാൽ നിങ്ങൾ എന്റെ മുഖം കാണുകയില്ല എന്നു അദ്ദേഹം തീർച്ചയായി ഞങ്ങളോടു പറഞ്ഞിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","നീ ഞങ്ങളുടെ സഹോദരനെ ഞങ്ങളുടെകൂടെ അയച്ചാൽ ഞങ്ങൾ ചെന്നു ആഹാരം വാങ്ങി കൊണ്ടുവരാം; ");
INSERT INTO mal2015_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","അയക്കാഞ്ഞാലോ ഞങ്ങൾ പോകയില്ല. നിങ്ങളുടെ സഹോദരൻ നിങ്ങളോടുകൂടെ ഇല്ല എങ്കിൽ നിങ്ങൾ എന്റെ മുഖം കാണുകയില്ല എന്നു അദ്ദേഹം ഞങ്ങളോടു പറഞ്ഞിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","നിങ്ങൾക്കു ഇനിയും ഒരു സഹോദരൻ ഉണ്ടെന്നു നിങ്ങൾ അദ്ദേഹത്തോടു പറഞ്ഞു എനിക്കു ഈ ദോഷം വരുത്തിയതു എന്തിന്നു എന്നു യിസ്രായേൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","അതിന്നു അവർ: നിങ്ങളുടെ അപ്പൻ ജീവിച്ചിരിക്കുന്നുവോ? നിങ്ങൾക്കു ഇനിയും ഒരു സഹോദരൻ ഉണ്ടോ എന്നിങ്ങനെ അദ്ദേഹം ഞങ്ങളെയും ഞങ്ങളുടെ വംശത്തെയും കുറിച്ചു താല്പര്യമായി ചോദിച്ചതുകൊണ്ടു ഞങ്ങൾ ഇതൊക്കെയും അറിയിക്കേണ്ടിവന്നു; നിങ്ങളുടെ സഹോദരനെ ഇവിടെ കൂട്ടിക്കൊണ്ടുവരുവിൻ എന്നു അദ്ദേഹം പറയുമെന്നു ഞങ്ങൾ അറിഞ്ഞിരുന്നുവോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","പിന്നെ യെഹൂദാ തന്റെ അപ്പനായ യിസ്രായേലിനോടു പറഞ്ഞതു: ഞങ്ങളും നീയും ഞങ്ങളുടെ കുഞ്ഞുകുട്ടികളും മരിക്കാതെ ജീവിച്ചിരിക്കേണ്ടതിന്നു ബാലനെ എന്നോടുകൂടെ അയക്കേണം; എന്നാൽ ഞങ്ങൾ പോകാം. ");
INSERT INTO mal2015_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ഞാൻ അവന്നു വേണ്ടി ഉത്തരവാദിയായിരിക്കാം; നീ അവനെ എന്റെ കയ്യിൽനിന്നു ചോദിക്കേണം; ഞാൻ അവനെ നിന്റെ അടുക്കൽ കൊണ്ടുവന്നു അവനെ നിന്റെ മുമ്പിൽ നിർത്തുന്നില്ലെങ്കിൽ ഞാൻ സദാകാലം നിനക്കു കുറ്റക്കാരനായിക്കൊള്ളാം. ");
INSERT INTO mal2015_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ഞങ്ങൾ താമസിച്ചിരുന്നില്ലെങ്കിൽ ഇപ്പോൾ രണ്ടു പ്രാവശ്യം പോയിവരുമായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","അപ്പോൾ അവരുടെ അപ്പനായ യിസ്രായേൽ അവരോടു പറഞ്ഞതു: അങ്ങനെയെങ്കിൽ ഇതു ചെയ്‌വിൻ: നിങ്ങളുടെ പാത്രങ്ങളിൽ കുറെ സുഗന്ധപ്പശ, കുറെ തേൻ, സാംപ്രാണി, സന്നിനായകം, ബോടനണ്ടി, ബദാമണ്ടി എന്നിങ്ങനെ ദേശത്തിലെ വിശേഷവസ്തുക്കളിൽ ചിലതൊക്കെയും കൊണ്ടുപോയി അദ്ദേഹത്തിന്നു കാഴ്ചവെപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ഇരട്ടിദ്രവ്യവും കയ്യിൽ എടുത്തുകൊൾവിൻ; നിങ്ങളുടെ ചാക്കിന്റെ വായ്ക്കൽ മടങ്ങിവന്ന ദ്രവ്യവും കയ്യിൽ തിരികെ കൊണ്ടുപോകുവിൻ; പക്ഷേ അതു കൈമറിച്ചലായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","നിങ്ങളുടെ സഹോദരനെയും കൂട്ടി പുറപ്പെട്ടു അദ്ദേഹത്തിന്റെ അടുക്കൽ വീണ്ടും ചെല്ലുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","അവൻ നിങ്ങളുടെ മറ്റേ സഹോദരനെയും ബെന്യാമീനെയും നിങ്ങളോടുകൂടെ അയക്കേണ്ടതിന്നു സർവ്വശക്തിയുള്ള ദൈവം അവന്നു നിങ്ങളോടു കരുണ തോന്നിക്കട്ടെ; എന്നാൽ ഞാൻ മക്കളില്ലാത്തവനാകേണമെങ്കിൽ ആകട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","അങ്ങനെ അവർ ആ കാഴ്ചയും ഇരട്ടിദ്രവ്യവും എടുത്തു ബെന്യാമീനെയും കൂട്ടി പുറപ്പെട്ടു മിസ്രയീമിൽ ചെന്നു യോസേഫിന്റെ മുമ്പിൽനിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","അവരോടുകൂടെ ബെന്യാമീനെ കണ്ടപ്പോൾ അവൻ തന്റെ ഗൃഹവിചാരകനോടു: നീ ഈ പുരുഷന്മാരെ വീട്ടിൽ കൂട്ടിക്കൊണ്ടു പോക; അവർ ഉച്ചെക്കു എന്നോടുകൂടെ ഭക്ഷണം കഴിക്കേണ്ടതാകയാൽ മൃഗത്തെ അറുത്തു ഒരുക്കിക്കൊൾക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","യോസേഫ് കല്പിച്ചതുപോലെ അവൻ ചെയ്തു; അവരെ യോസേഫിന്റെ വീട്ടിൽ കൂട്ടിക്കൊണ്ടു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","തങ്ങളെ യോസേഫിന്റെ വീട്ടിൽ കൊണ്ടുപോകയാൽ അവർ ഭയപ്പെട്ടു: ആദ്യത്തെ പ്രാവശ്യം നമ്മുടെ ചാക്കിൽ മടങ്ങിവന്ന ദ്രവ്യം നിമിത്തം നമ്മെ പിടിച്ചു അടിമകളാക്കി നമ്മുടെ കഴുതകളെയും എടുത്തുകൊള്ളേണ്ടതിന്നാകുന്നു നമ്മെ കൊണ്ടുവന്നിരിക്കുന്നതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","അവർ യോസേഫിന്റെ ഗൃഹവിചാരകന്റെ അടുക്കൽ ചെന്നു, വീട്ടുവാതിൽക്കൽവെച്ചു അവനോടു സംസാരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","യജമാനനേ, ആഹാരം കൊള്ളുവാൻ ഞങ്ങൾ മുമ്പെ വന്നിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ഞങ്ങൾ വഴിയമ്പലത്തിൽ ചെന്നു ചാക്കു അഴിച്ചപ്പോൾ ഓരോരുത്തന്റെ ദ്രവ്യം മുഴുവനും അവനവന്റെ ചാക്കിന്റെ വായ്ക്കൽ ഉണ്ടായിരുന്നു; അതു ഞങ്ങൾ വീണ്ടും കൊണ്ടുവന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ആഹാരം കൊള്ളുവാൻ വേറെ ദ്രവ്യവും ഞങ്ങൾ കൊണ്ടുവന്നിട്ടുണ്ടു; ദ്രവ്യം ഞങ്ങളുടെ ചാക്കിൽ വെച്ചതു ആരെന്നു ഞങ്ങൾക്കു അറിഞ്ഞുകൂടാ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","അതിന്നു അവൻ: നിങ്ങൾക്കു സമാധാനം; നിങ്ങൾ ഭയപ്പെടേണ്ടാ; നിങ്ങളുടെ ദൈവം, നിങ്ങളുടെ അപ്പന്റെ ദൈവം തന്നേ, നിങ്ങളുടെ ചാക്കിൽ നിങ്ങൾക്കു നിക്ഷേപം തന്നിരിക്കുന്നു; നിങ്ങളുടെ ദ്രവ്യം എനിക്കു കിട്ടി എന്നു പറഞ്ഞു. ശിമെയോനെയും അവരുടെ അടുക്കൽ പുറത്തു കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","പിന്നെ അവൻ അവരെ യോസേഫിന്റെ വീട്ടിന്നകത്തു കൊണ്ടുപോയി; അവർക്കു വെള്ളം കൊടുത്തു, അവർ കാലുകളെ കഴുകി; അവരുടെ കഴുതകൾക്കു അവൻ തീൻ കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ഉച്ചെക്കു യോസേഫ് വരുമ്പോഴേക്കു അവർ കാഴ്ച ഒരുക്കിവെച്ചു; തങ്ങൾക്കു ഭക്ഷണം അവിടെ എന്നു അവർ കേട്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","യോസേഫ് വീട്ടിൽ വന്നപ്പോൾ അവർ കൈവശമുള്ള കാഴ്ച അകത്തുകൊണ്ടുചെന്നു അവന്റെ മുമ്പാകെവെച്ചു അവനെ സാഷ്ടാംഗം നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","അവൻ അവരോടു കുശലപ്രശ്നം ചെയ്തു: നിങ്ങൾ പറഞ്ഞ വൃദ്ധൻ, നിങ്ങളുടെ അപ്പൻ സൗഖ്യമായിരിക്കുന്നുവോ? അവൻ ജീവനോടിരിക്കുന്നുവോ എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","അതിന്നു അവർ: ഞങ്ങളുടെ അപ്പനായ നിന്റെ അടിയാന്നു സുഖം തന്നേ; അവൻ ജീവനോടിരിക്കുന്നു എന്നു ഉത്തരം പറഞ്ഞു കുനിഞ്ഞു നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","പിന്നെ അവൻ തല ഉയർത്തി, തന്റെ അമ്മയുടെ മകനും തന്റെ അനുജനുമായ ബെന്യാമീനെ കണ്ടു: നിങ്ങൾ എന്നോടു പറഞ്ഞ നിങ്ങളുടെ ഇളയസഹോദരനോ ഇവൻ എന്നു ചോദിച്ചു: ദൈവം നിനക്കു കൃപ നല്കട്ടെ മകനേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","അനുജനെ കണ്ടിട്ടു യോസേഫിന്റെ മനസ്സു ഇരുകിയതുകൊണ്ടു അവൻ കരയേണ്ടതിന്നു ബദ്ധപ്പെട്ടു സ്ഥലം അന്വേഷിച്ചു, അറയിൽചെന്നു അവിടെവെച്ചു കരഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","പിന്നെ അവൻ മുഖം കഴുകി പുറത്തു വന്നു തന്നെത്താൻ അടക്കി: ഭക്ഷണം കൊണ്ടുവരുവിൻ എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","അവർ അവന്നു പ്രത്യേകവും അവർക്കു പ്രത്യേകവും, അവനോടുകൂടെ ഭക്ഷിക്കുന്ന മിസ്രയീമ്യർക്കു പ്രത്യേകവും കൊണ്ടുവന്നു വെച്ചു; മിസ്രയീമ്യർ എബ്രായരോടുകൂടെ ഭക്ഷണം കഴിക്കയില്ല; അതു മിസ്രയീമ്യർക്കു വെറുപ്പു ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","മൂത്തവൻ മുതൽ ഇളയവൻ വരെ പ്രായത്തിന്നൊത്തവണ്ണം അവരെ അവന്റെ മുമ്പാകെ ഇരുത്തി; അവർ അന്യോന്യം നോക്കി ആശ്ചര്യപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","അവൻ തന്റെ മുമ്പിൽനിന്നു അവർക്കു ഓഹരികൊടുത്തയച്ചു; ബെന്യാമീന്റെ ഓഹരി മറ്റവരുടെ ഓഹരിയുടെ അഞ്ചിരട്ടിയായിരുന്നു; അവർ പാനംചെയ്തു അവനോടുകൂടെ ആഹ്ലാദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","അനന്തരം അവൻ തന്റെ ഗൃഹവിചാരകനോടു: നീ ഇവരുടെ ചാക്കിൽ പിടിപ്പതു ധാന്യം നിറച്ചു, ഓരോരുത്തന്റെ ദ്രവ്യം അവനവന്റെ ചാക്കിന്റെ വായ്ക്കൽ വെക്കുക. ");
INSERT INTO mal2015_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ഇളയവന്റെ ചാക്കിന്റെ വായ്ക്കൽ വെള്ളികൊണ്ടുള്ള എന്റെ പാനപാത്രവും അവന്റെ ധാന്യവിലയും വെക്കുക എന്നു കല്പിച്ചു; യോസേഫ് കല്പിച്ചതുപോലെ അവൻ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","നേരം വെളുത്തപ്പോൾ അവരുടെ കഴുതകളുമായി അവരെ യാത്ര അയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","അവർ പട്ടണത്തിൽനിന്നു പുറപ്പെട്ടു ദൂരത്താകുംമുമ്പെ, യോസേഫ് തന്റെ ഗൃഹവിചാരകനോടു: എഴുന്നേറ്റു ആ പുരുഷന്മാരുടെ പിന്നാലെ ഓടിച്ചെല്ലുക; ഒപ്പം എത്തുമ്പോൾ അവരോടു: നിങ്ങൾ നന്മെക്കു പകരം തിന്മ ചെയ്തതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","അതിലല്ലയോ എന്റെ യജമാനൻ കുടിക്കുന്നതു? അതിനാലല്ലയോ ലക്ഷണം നോക്കുന്നതു? നിങ്ങൾ ഈ ചെയ്തതു ഒട്ടും നന്നല്ല എന്നു പറക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","അവൻ അവരുടെ അടുക്കൽ എത്തിയപ്പോൾ ഈ വാക്കുകൾ അവരോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","അവർ അവനോടു പറഞ്ഞതു: യജമാനൻ ഇങ്ങനെ പറയുന്നതു എന്തു? ഈ വക കാര്യം അടിയങ്ങൾ ഒരുനാളും ചെയ്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ഞങ്ങളുടെ ചാക്കിന്റെ വായ്ക്കൽ കണ്ട ദ്രവ്യം ഞങ്ങൾ കനാൻദേശത്തുനിന്നു നിന്റെ അടുക്കൽ വീണ്ടും കൊണ്ടുവന്നുവല്ലോ; പിന്നെ ഞങ്ങൾ നിന്റെ യജമാനന്റെ വീട്ടിൽനിന്നു വെള്ളിയും പൊന്നും മോഷ്ടിക്കുമോ? ");
INSERT INTO mal2015_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","അടിയങ്ങളിൽ ആരുടെ പക്കൽ എങ്കിലും അതു കണ്ടാൽ അവൻ മരിക്കട്ടെ; ഞങ്ങളും യജമാനന്നു അടിമകളായിക്കൊള്ളാം. ");
INSERT INTO mal2015_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","അതിന്നു അവൻ: നിങ്ങൾ പറഞ്ഞതുപോലെ ആകട്ടെ; അതു ആരുടെ പക്കൽ കാണുന്നുവോ അവൻ എനിക്കു അടിമയാകും; നിങ്ങളോ കുറ്റമില്ലാത്തവരായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","അവർ ബദ്ധപ്പെട്ടു ചാക്കു നിലത്തു ഇറക്കി: ഓരോരുത്തൻ താന്താന്റെ ചാക്കു അഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","അവൻ മൂത്തവന്റെ ചാക്കുതുടങ്ങി ഇളയവന്റേതുവരെ ശോധന കഴിച്ചു. ബെന്യാമീന്റെ ചാക്കിൽ പാനപാത്രം കണ്ടുപിടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","അപ്പോൾ അവർ വസ്ത്രം കീറി, ചുമടു കഴുതപ്പുറത്തു കയറ്റി പട്ടണത്തിലേക്കു മടങ്ങിച്ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","യെഹൂദയും അവന്റെ സഹോദരന്മാരും യോസേഫിന്റെ വീട്ടിൽ ചെന്നു; അവൻ അതുവരെയും അവിടെത്തന്നേ ആയിരുന്നു; അവർ അവന്റെ മുമ്പാകെ സാഷ്ടാംഗം വീണു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","യോസേഫ് അവരോടു: നിങ്ങൾ ഈ ചെയ്ത പ്രവൃത്തി എന്തു? എന്നെപ്പോലെയുള്ള ഒരുത്തന്നു ലക്ഷണവിദ്യ അറിയാമെന്നു നിങ്ങൾ അറിഞ്ഞിട്ടില്ലയോ എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","അതിന്നു യെഹൂദാ: യജമാനനോടു ഞങ്ങൾ എന്തു പറയേണ്ടു? എന്തു ബോധിപ്പിക്കേണ്ടു? എങ്ങനെ ഞങ്ങളെത്തന്നേ നീതീകരിക്കേണ്ടു? ദൈവം അടിയങ്ങളുടെ അകൃത്യം കണ്ടെത്തി; ഇതാ ഞങ്ങൾ യജമാനന്നു അടിമകൾ; ഞങ്ങളും ആരുടെ കയ്യിൽ പാത്രം കണ്ടുവോ അവനും തന്നേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","അതിന്നു അവൻ അങ്ങനെ ഞാൻ ഒരുനാളും ചെയ്കയില്ല; ആരുടെ പക്കൽ പാത്രം കണ്ടുവോ അവൻ തന്നേ എനിക്കു അടിമയായിരിക്കും; നിങ്ങളോ സമാധാനത്തോടെ നിങ്ങളുടെ അപ്പന്റെ അടുക്കൽ പോയ്ക്കൊൾവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","അപ്പോൾ യെഹൂദാ അടുത്തുചെന്നു പറഞ്ഞതു: യജമാനനേ, അടിയൻ യജമാനനോടു ഒന്നു ബോധിപ്പിച്ചുകൊള്ളട്ടേ; അടിയന്റെ നേരെ കോപം ജ്വലിക്കരുതേ; ");
INSERT INTO mal2015_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","യജമാനൻ ഫറവോനെപ്പോലെയല്ലോ; നിങ്ങൾക്കു അപ്പനോ സഹോദരനോ ഉണ്ടോ എന്നു യജമാനൻ അടിയങ്ങളോടു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","അതിന്നു ഞങ്ങൾ യജമാനനോടു: ഞങ്ങൾക്കു വൃദ്ധനായോരു അപ്പനും അവന്നു വാർദ്ധക്യത്തിൽ ജനിച്ച ഒരു മകനും ഉണ്ടു; അവന്റെ ജ്യേഷ്ഠൻ മരിച്ചുപോയി; അവന്റെ അമ്മ പ്രസവിച്ചിട്ടു അവൻ ഒരുത്തനെ ശേഷിപ്പുള്ളു; അവൻ അപ്പന്റെ ഇഷ്ടനാകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","അപ്പോൾ യജമാനൻ അടിങ്ങളോടു: എനിക്കു കാണേണ്ടതിന്നു അവനെ എന്റെ അടുക്കൽ കൂട്ടിക്കൊണ്ടുവരുവിൻ എന്നു കല്പിച്ചുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ഞങ്ങൾ യജമാനനോടു: ബാലന്നു അപ്പനെ പിരിഞ്ഞുകൂടാ; പിരിഞ്ഞാൽ അപ്പൻ മരിച്ചുപോകും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","അതിന്നു യജമാനൻ അടിയങ്ങളോടു നിങ്ങളുടെ ഇളയസഹോദരൻ നിങ്ങളോടുകൂടെ വരാതിരുന്നാൽ നിങ്ങൾ എന്റെ മുഖം ഇനി കാണുകയില്ല എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","അവിടത്തെ അടിയാനായ അപ്പന്റെ അടുക്കൽ ഞങ്ങൾ ചെന്നു യജമാനന്റെ വാക്കുകളെ അറിയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","അനന്തരം ഞങ്ങളുടെ അപ്പൻ നിങ്ങൾ ഇനിയും പോയി കുറെ ധാന്യം നമുക്കു കൊള്ളുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","അതിന്നു ഞങ്ങൾ: ഞങ്ങൾ പൊയ്ക്കൂടാ; അനുജൻ കൂടെ ഉണ്ടെങ്കിൽ ഞങ്ങൾ പോകാം; അനുജൻ ഇല്ലാതെ ഞങ്ങൾക്കു അദ്ദേഹത്തിന്റെ മുഖം കാണ്മാൻ പാടില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","അപ്പോൾ അവിടത്തെ അടിയാനായ അപ്പൻ ഞങ്ങളോടു പറഞ്ഞതു: എന്റെ ഭാര്യ എനിക്കു രണ്ടു പുത്രന്മാരെ പ്രസവിച്ചു എന്നു നിങ്ങൾക്കു അറിയാമല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","അവരിൽ ഒരുത്തൻ എന്റെ അടുക്കൽനിന്നു പോയി; അവനെ പറിച്ചു കീറിപ്പോയി നിശ്ചയം എന്നു ഞാൻ ഉറെച്ചു; ഇതുവരെ ഞാൻ അവനെ കണ്ടിട്ടുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","നിങ്ങൾ ഇവനെയും കൊണ്ടുപോയിട്ടു അവന്നു വല്ല ആപത്തും വന്നാൽ നിങ്ങൾ എന്റെ നരയെ ദുഃഖത്തോടെ പാതാളത്തിൽ ഇറങ്ങുമാറാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","അതുകൊണ്ടു ഇപ്പോൾ ബാലൻ കൂടെയില്ലാതെ ഞാൻ അവിടത്തെ അടിയാനായ അപ്പന്റെ അടുക്കൽ ചെല്ലുമ്പോൾ, അവന്റെ പ്രാണൻ ഇവന്റെ പ്രാണനോടു പറ്റിയിരിക്കകൊണ്ടു, ");
INSERT INTO mal2015_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ബാലൻ ഇല്ലെന്നു കണ്ടാൽ അവൻ മരിച്ചുപോകും; അങ്ങനെ അടിയങ്ങൾ അവിടെത്തെ അടിയാനായ അപ്പന്റെ നരയെ ദുഃഖത്തോടെ പാതാളത്തിൽ ഇറങ്ങുമാറാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","അടിയൻ അപ്പനോടു: അവനെ നിന്റെ അടുക്കൽ കൊണ്ടുവരാതിരുന്നാൽ ഞാൻ എന്നും അപ്പന്നു കുറ്റക്കാരനായിക്കൊളാമെന്നു പറഞ്ഞു, അപ്പനോടു ബാലന്നുവേണ്ടി ഉത്തരവാദിയായിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","ആകയാൽ ബാലന്നു പകരം അടിയൻ യജമാനന്നു അടിമയായിരിപ്പാനും ബാലൻ സഹോദരന്മാരോടുകൂടെ പൊയ്ക്കൊൾവാനും അനുവദിക്കേണമേ. ");
INSERT INTO mal2015_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ബാലൻ കൂടെ ഇല്ലാതെ ഞാൻ എങ്ങനെ അപ്പന്റെ അടുക്കൽ പോകും? അപ്പന്നു ഭവിക്കുന്ന ദോഷം ഞാൻ കാണേണ്ടിവരുമല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","അപ്പോൾ ചുറ്റും നില്ക്കുന്നവരുടെ മുമ്പിൽ തന്നെത്താൻ അടക്കുവാൻ വഹിയാതെ: എല്ലാവരെയും എന്റെ അടുക്കൽനിന്നു പുറത്താക്കുവിൻ എന്നു യോസേഫ് വിളിച്ചുപറഞ്ഞു. ഇങ്ങനെ യോസേഫ് തന്റെ സഹോദരന്മാർക്കു തന്നെ വെളിപ്പെടുത്തിയപ്പോൾ ആരും അടുക്കൽ ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","അവൻ ഉച്ചത്തിൽ കരഞ്ഞു; മിസ്രയീമ്യരും ഫറവോന്റെ ഗൃഹവും അതു കേട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","യോസേഫ് സഹോദരന്മാരോടു: ഞാൻ യോസേഫ് ആകുന്നു; എന്റെ അപ്പൻ ജീവനോടിരിക്കുന്നുവോ എന്നു പറഞ്ഞു. അവന്റെ സഹോദരന്മാർ അവന്റെ സന്നിധിയിൽ ഭ്രമിച്ചുപോയതുകൊണ്ടു അവനോടു ഉത്തരം പറവാൻ അവർക്കു കഴിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","യോസേഫ് സഹോദരന്മാരോടു: ഇങ്ങോട്ടു അടുത്തുവരുവിൻ എന്നു പറഞ്ഞു; അവർ അടുത്തുചെന്നപ്പോൾ അവൻ പറഞ്ഞതു; നിങ്ങൾ മിസ്രയീമിലേക്കു വിറ്റുകളഞ്ഞ നിങ്ങളുടെ സഹോദരൻ യോസേഫ് ആകുന്നു ഞാൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","എന്നെ ഇവിടെ വിറ്റതുകൊണ്ടു നിങ്ങൾ വ്യസനിക്കേണ്ടാ, വിഷാദിക്കയും വേണ്ടാ; ജീവരക്ഷക്കായി ദൈവം എന്നെ നിങ്ങൾക്കു മുമ്പെ അയച്ചതാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ദേശത്തു ക്ഷാമം ഉണ്ടായിട്ടു ഇപ്പോൾ രണ്ടു സംവത്സരമായി; ഉഴവും കൊയ്ത്തും ഇല്ലാത്ത അഞ്ചു സംവത്സരം ഇനിയും ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ഭൂമിയിൽ നിങ്ങൾക്കു സന്തതി ശേഷിക്കേണ്ടതിന്നും വലിയോരു രക്ഷയാൽ നിങ്ങളുടെ ജീവനെ രക്ഷിക്കേണ്ടതിന്നും ദൈവം എന്നെ നിങ്ങൾക്കു മുമ്പെ അയച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ആകയാൽ നിങ്ങൾ അല്ല, ദൈവം അത്രേ എന്നെ ഇവിടെ അയച്ചതു; അവൻ എന്നെ ഫറവോന്നു പിതാവും അവന്റെ ഗൃഹത്തിന്നു ഒക്കെയും യജമാനനും മിസ്രയീംദേശത്തിന്നൊക്കെയും അധിപതിയും ആക്കിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","നിങ്ങൾ ബദ്ധപ്പെട്ടു എന്റെ അപ്പന്റെ അടുക്കൽ ചെന്നു അവനോടു പറയേണ്ടതു എന്തെന്നാൽ: നിന്റെ മകനായ യോസേഫ് ഇപ്രകാരം പറയുന്നു: ദൈവം എന്നെ മിസ്രയീമിന്നൊക്കെയും അധിപതിയാക്കിയിരിക്കുന്നു; നീ താമസിയാതെ എന്റെ അടുക്കൽ വരേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","നീ ഗോശെൻദേശത്തു പാർത്തു എനിക്കു സമീപമായിരിക്കും; നീയും മക്കളും മക്കളുടെ മക്കളും നിന്റെ ആടുകളും കന്നുകാലികളും നിനക്കുള്ളതൊക്കെയും തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","നിനക്കും കുടുംബത്തിന്നും നിനക്കുള്ള സകലത്തിന്നും ദാരിദ്ര്യം നേരിടാതവണ്ണം ഞാൻ അവിടെ നിന്നെ പോഷിപ്പിക്കും; ക്ഷാമം ഇനിയും അഞ്ചു സംവത്സരം നില്ക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ഇതാ, ഞാൻ തന്നേ നിങ്ങളോടു സംസാരിക്കുന്നു എന്നു നിങ്ങളും എന്റെ അനുജൻ ബെന്യാമീനും കണ്ണാലെ കാണുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","മിസ്രയീമിൽ എനിക്കുള്ള മഹത്വവും നിങ്ങൾ കണ്ടതൊക്കെയും അപ്പനെ അറിയിക്കേണം; എന്റെ അപ്പനെ വേഗത്തിൽ ഇവിടെ കൊണ്ടുവരികയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","അവൻ തന്റെ അനുജൻ ബെന്യാമീനെ കെട്ടിപ്പിടിച്ചു കരഞ്ഞു; ബെന്യാമീൻ അവനെയും കെട്ടിപ്പിടിച്ചു കരഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","അവൻ സഹോദരന്മാരെ ഒക്കെയും ചുംബിച്ചു കെട്ടിപ്പിടിച്ചു കരഞ്ഞു; അതിന്റെ ശേഷം സഹോദരന്മാർ അവനുമായി സല്ലാപിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","യോസേഫിന്റെ സഹോദരന്മാർ വന്നിരിക്കുന്നു എന്നുള്ള കേൾവി ഫറവോന്റെ അരമനയിൽ എത്തി; അതു ഫറവോന്നും അവന്റെ ഭൃത്യന്മാർക്കും സന്തോഷമായി. ");
INSERT INTO mal2015_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ഫറവോൻ യോസേഫിനോടു പറഞ്ഞതു: നിന്റെ സഹോദരന്മാരോടു നീ പറയേണ്ടതു എന്തെന്നാൽ: നിങ്ങൾ ഇതു ചെയ്‌വിൻ; നിങ്ങളുടെ മൃഗങ്ങളുടെ പുറത്തു ചുമടു കയറ്റി പുറപ്പെട്ടു കനാൻദേശത്തു ചെന്നു ");
INSERT INTO mal2015_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","നിങ്ങളുടെ അപ്പനെയും കുടുംബങ്ങളെയും കൂട്ടിക്കൊണ്ടു എന്റെ അടുക്കൽ വരുവിൻ; ഞാൻ നിങ്ങൾക്കു മിസ്രയീംരാജ്യത്തിലെ നന്മ തരും; ദേശത്തിന്റെ പുഷ്ടി നിങ്ങൾ അനുഭവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","നിനക്കു കല്പന തന്നിരിക്കുന്നു; ഇതാകുന്നു നിങ്ങൾ ചെയ്യേണ്ടതു: നിങ്ങളുടെ പൈതങ്ങൾക്കും ഭാര്യമാർക്കും വേണ്ടി മിസ്രയീംദേശത്തു നിന്നു രഥങ്ങൾ കൊണ്ടുപോയി നിങ്ങളുടെ അപ്പനെ കയറ്റി കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","നിങ്ങളുടെ സാമാനങ്ങളെ കുറിച്ചു ചിന്തിക്കേണ്ടാ; മിസ്രയീംദേശത്തെങ്ങുമുള്ള നന്മ നിങ്ങൾക്കുള്ളതു ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","യിസ്രായേലിന്റെ പുത്രന്മാർ അങ്ങനെ തന്നേ ചെയ്തു; യോസേഫ് അവർക്കു ഫറവോന്റെ കല്പനപ്രകാരം രഥങ്ങൾ കൊടുത്തു; വഴിക്കു വേണ്ടുന്ന ആഹാരവും കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","അവരിൽ ഓരോരുത്തന്നു ഓരോ വസ്ത്രവും ബെന്യാമീന്നോ മുന്നൂറു വെള്ളിക്കാശും അഞ്ചു വസ്ത്രവും കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","അങ്ങനെ തന്നേ അവൻ തന്റെ അപ്പന്നു പത്തു കഴുതപ്പുറത്തു മിസ്രയീമിലെ വിശേഷസാധനങ്ങളും പത്തു പെൺകഴുതപ്പുറത്തു വഴിച്ചെലവിന്നു ധാന്യവും ആഹാരവും കയറ്റി അയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","അങ്ങനെ അവൻ തന്റെ സഹോദരന്മാരെ യാത്ര അയച്ചു; അവർ പുറപ്പെടുമ്പോൾ: നിങ്ങൾ വഴിയിൽ വെച്ചു ശണ്ഠകൂടരുതെന്നു അവരോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","അവർ മിസ്രയീമിൽ നിന്നു പുറപ്പെട്ടു കനാൻദേശത്തു അപ്പനായ യാക്കോബിന്റെ അടുക്കൽ എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","അവനോടു: യോസേഫ് ജീവനോടിരിക്കുന്നു; അവൻ മിസ്രയീംദേശത്തിന്നൊക്കെയും അധിപതിയാകുന്നു എന്നു പറഞ്ഞു. അപ്പോൾ യാക്കോബ് സ്തംഭിച്ചുപോയി; അവർ പറഞ്ഞതു വിശ്വസിച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","യോസേഫ് തങ്ങളോടു പറഞ്ഞവാക്കുകളൊക്കെയും അവർ അവനോടു പറഞ്ഞു; തന്നെ കയറ്റികൊണ്ടു പോകുവാൻ യോസേഫ് അയച്ച രഥങ്ങളെ കണ്ടപ്പോൾ അവരുടെ അപ്പനായ യാക്കോബിന്നു വീണ്ടും ചൈതന്യം വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","മതി; എന്റെ മകൻ യോസേഫ് ജീവനോടിരിക്കുന്നു; ഞാൻ മരിക്കുംമുമ്പെ അവനെ പോയി കാണും എന്നു യിസ്രായേൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","അനന്തരം യിസ്രായേൽ തനിക്കുള്ള സകലവുമായി യാത്ര പുറപ്പെട്ടു ബേർ-ശേബയിൽ എത്തി തന്റെ പിതാവായ യിസ്ഹാക്കിന്റെ ദൈവത്തിന്നു യാഗം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ദൈവം യിസ്രായേലിനോടു രാത്രി ദർശനങ്ങളിൽ: യാക്കോബേ, യാക്കോബേ എന്നു വിളിച്ചതിന്നു ഞാൻ ഇതാ എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","അപ്പോൾ അവൻ: ഞാൻ ദൈവം ആകുന്നു; നിന്റെ പിതാവിന്റെ ദൈവം തന്നേ; മിസ്രയീമിലേക്കു പോകുവാൻ ഭയപ്പെടേണ്ടാ; അവിടെ ഞാൻ നിന്നെ വലിയ ജാതിയാക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ഞാൻ നിന്നോടുകൂടെ മിസ്രയീമിലേക്കു പോരും; ഞാൻ നിന്നെ മടക്കി വരുത്തും; യോസേഫ് സ്വന്തകൈകൊണ്ടു നിന്റെ കണ്ണു അടെക്കും എന്നും അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","പിന്നെ യാക്കോബ് ബേർ-ശേബയിൽനിന്നു പുറപ്പെട്ടു; യിസ്രായേലിന്റെ പുത്രന്മാർ അപ്പനായ യാക്കോബിനെ കയറ്റുവാൻ ഫറവോൻ അയച്ച രഥങ്ങളിൽ അവനെയും തങ്ങളുടെ മക്കളെയും ഭാര്യമാരെയും കയറ്റി കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","തങ്ങളുടെ ആടുമാടുകളെയും കനാൻദേശത്തുവെച്ചു സമ്പാദിച്ച സമ്പത്തുകളെയും കൊണ്ടുപോയി; അങ്ങനെ യാക്കോബും സന്തതികളുമെല്ലാം മിസ്രയീമിൽ എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","അവൻ തന്റെ പുത്രിപുത്രന്മാരെയും പൗത്രിപൗത്രന്മാരെയും തന്റെ സന്തതികളെയൊക്കെയും കൂട്ടി മിസ്രയീമിലേക്കു കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","മിസ്രയീമിൽ വന്ന യിസ്രായേൽമക്കളുടെ പേരുകൾ ആവിതു: യാക്കോബും അവന്റെ പുത്രന്മാരും; യാക്കോബിന്റെ ആദ്യജാതനായ രൂബേൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","രൂബേന്റെ പുത്രന്മാർ: ഹാനോക്, ഫല്ലൂ, ഹെസ്രോൻ, കർമ്മി. ");
INSERT INTO mal2015_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ശിമെയോന്റെ പുത്രന്മാർ: യെമൂവേൽ, യാമീൻ, ഓഹദ്, യാഖീൻ, സോഹർ, കനാന്യക്കാരത്തിയുടെ മകനായ ശൗൽ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ലേവിയുടെ പുത്രന്മാർ: ഗേർശോൻ, കഹാത്ത്, മെരാരി. ");
INSERT INTO mal2015_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","യെഹൂദയുടെ പുത്രന്മാർ: ഏർ, ഓനാൻ, ശേലാ, പേരെസ്, സേരഹ്; എന്നാൽ ഏർ, ഓനാൻ എന്നിവർ കനാൻദേശത്തുവെച്ചു മരിച്ചുപോയി. പേരെസിന്റെ പുത്രന്മാർ: ഹെസ്രോൻ, ഹാമൂൽ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","യിസ്സാഖാരിന്റെ പുത്രന്മാർ: തോലാ, പുവ്വാ, യോബ്, ശിമ്രോൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","സെബൂലൂന്റെ പുത്രന്മാർ: സേരെദ്, ഏലോൻ, യഹ്ലെയേൽ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ഇവർ ലേയയുടെ പുത്രന്മാർ; അവൾ അവരെയും യാക്കോബിന്റെ മകളായ ദീനയെയും അവന്നു പദ്ദൻ-അരാമിൽവെച്ചു പ്രസവിച്ചു; അവന്റെ പുത്രന്മാരും പുത്രിമാരും എല്ലാം കൂടെ മുപ്പത്തുമൂന്നു പേർ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ഗാദിന്റെ പുത്രന്മാർ: സിഫ്യോൻ, ഹഗ്ഗീ, ശൂനീ, എസ്ബോൻ, ഏരി, അരോദീ, അരേലീ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ആശേരിന്റെ പുത്രന്മാർ: യിമ്നാ, യിശ്വാ, യിശ്വീ, ബെരീയാ; ഇവരുടെ സഹോദരി സേരഹ്. ബെരീയാവിന്റെ പുത്രന്മാർ: ");
INSERT INTO mal2015_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ഹേബെർ, മൽക്കീയേൽ. ഇവർ ലാബാൻ തന്റെ മകളായ ലേയെക്കു കൊടുത്ത സില്പയുടെ പുത്രന്മാർ; അവൾ യാക്കോബിന്നു ഈ പതിനാറു പേരെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","യാക്കോബിന്റെ ഭാര്യയായ റാഹേലിന്റെ പുത്രന്മാർ: യോസേഫ്, ബെന്യാമീൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","യോസേഫിന്നു മിസ്രയീംദേശത്തു മനശ്ശെയും എഫ്രയീമും ജനിച്ചു; അവരെ ഓനിലെ പുരോഹിതനായ പോത്തിഫേറയുടെ മകളായ ആസ്നത്ത് അവന്നു പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ബെന്യാമീന്റെ പുത്രന്മാർ: ബേല, ബേഖെർ, അശ്ബെൽ, ഗേരാ, നാമാൻ, ഏഹീ, രോശ്, മുപ്പീം, ഹുപ്പീം, ആരെദ്. ");
INSERT INTO mal2015_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ഇവർ റാഹേൽ യാക്കോബിന്നു പ്രസവിച്ച പുത്രന്മാർ; എല്ലാംകൂടെ പതിന്നാലു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ദാന്റെ പുത്രന്മാർ ഹൂശീം. ");
INSERT INTO mal2015_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","നഫ്താലിയുടെ പുത്രന്മാർ: യഹസേൽ, ഗൂനീ, യേസെർ, ശില്ലേം. ");
INSERT INTO mal2015_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ഇവർ ലാബാൻ തന്റെ മകളായ റാഹേലിന്നു കൊടുത്ത ബിൽഹയുടെ പുത്രന്മാർ; അവൾ യാക്കോബിന്നു ഇവരെ പ്രസവിച്ചു; എല്ലാംകൂടെ ഏഴുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","യാക്കോബിന്റെ പുത്രന്മാരുടെ ഭാര്യമാരെ കൂടാതെ അവന്റെ കടിപ്രദേശത്തുനിന്നു ജനിച്ചവരായി അവനോടുകൂടെ മിസ്രയീമിൽ വന്നവർ ആകെ അറുപത്താറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","യോസേഫിന്നു മിസ്രയീമിൽവെച്ചു ജനിച്ച പുത്രന്മാർ രണ്ടുപേർ; മിസ്രയീമിൽ വന്നരായ യാക്കോബിന്റെ കുടുംബം ആകെ എഴുപതു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","എന്നാൽ ഗോശെനിലേക്കു യോസേഫ് തനിക്കു വഴി കാണിക്കേണ്ടതിന്നു അവൻ യെഹൂദയെ അവന്റെ അടുക്കൽ മുമ്പിട്ടു അയച്ചു; ഇങ്ങനെ അവർ ഗോശെൻദേശത്തു എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","യോസേഫ് രഥം കെട്ടിച്ചു അപ്പനായ യിസ്രായേലിനെ എതിരേല്പാൻ ഗോശെനിലേക്കു പോയി, അവനെ കണ്ടപ്പോൾ കെട്ടിപ്പിടിച്ചു ഏറെനേരം കരഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","യിസ്രായേൽ യോസേഫിനോടു: നീ ജീവനോടിരിക്കുന്നു എന്നു ഞാൻ നിന്റെ മുഖം കണ്ടറിഞ്ഞതുകൊണ്ടു ഞാൻ ഇപ്പോൾ തന്നേ മരിച്ചാലും വേണ്ടതില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","പിന്നെ യോസേഫ് സഹോദരന്മാരോടും അപ്പന്റെ കുടുംബത്തോടും പറഞ്ഞതു: ഞാൻ ചെന്നു ഫറവോനോടു: കനാൻദേശത്തുനിന്നു എന്റെ സഹോദരന്മാരും അപ്പന്റെ കുടുംബവും എന്റെ അടുക്കൽ വന്നിരിക്കുന്നു എന്നു അറിയിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","അവർ ഇടയന്മാർ ആകുന്നു; കന്നുകാലികളെ മേയിക്കുന്നതു അവരുടെ തൊഴിൽ; അവർ തങ്ങളുടെ ആടുകളെയും കന്നുകാലികളെയും തങ്ങൾക്കുള്ളതൊക്കെയും കൊണ്ടുവന്നിട്ടുണ്ടു എന്നു അവനോടു പറയും. ");
INSERT INTO mal2015_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","അതുകൊണ്ടു ഫറവോൻ നിങ്ങളെ വിളിച്ചു: നിങ്ങളുടെ തൊഴിൽ എന്തു എന്നു ചോദിക്കുമ്പോൾ: ");
INSERT INTO mal2015_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","അടിയങ്ങൾ ബാല്യംമുതൽ ഇന്നുവരെയും, ഞങ്ങളും ഞങ്ങളുടെ പിതാക്കന്മാരും ഗോപാലകന്മാരാകുന്നു എന്നു പറവിൻ; എന്നാൽ നിങ്ങൾക്കു ഗോശെനിൽ പാർപ്പാൻ സംഗതിയാകും; ഇടയന്മാരെല്ലാം മിസ്രയീമ്യർക്കു വെറുപ്പല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","അങ്ങനെ യോസേഫ് ചെന്നു: എന്റെ അപ്പനും സഹോദരന്മാരും അവരുടെ ആടുകളും കന്നുകാലികളും അവർക്കുള്ളതൊക്കെയും കനാൻദേശത്തുനിന്നു വന്നു; ഗോശെൻദേശത്തു ഇരിക്കുന്നു എന്നു ഫറവോനെ ബോധിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","പിന്നെ അവൻ തന്റെ സഹോദരന്മാരിൽ അഞ്ചുപേരെ കൂട്ടിക്കൊണ്ടുചെന്നു ഫറവോന്റെ സന്നിധിയിൽ നിർത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","അപ്പോൾ ഫറവോൻ അവന്റെ സഹോദരന്മാരോടു: നിങ്ങളുടെ തൊഴിൽ എന്തു എന്നു ചോദിച്ചതിന്നു അവർ ഫറവോനോടു: അടിയങ്ങളും അടിയങ്ങളുടെ പിതാക്കന്മാരും ഇടയന്മാരാകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ദേശത്തു താമസിപ്പാൻ ഞങ്ങൾ വന്നിരിക്കുന്നു; കനാൻദേശത്തു ക്ഷാമം കഠിനമായിരിക്കയാൽ അടിയങ്ങളുടെ ആടുകൾക്കു മേച്ചലില്ല; അടിയങ്ങൾ ഗോശെൻദേശത്തു പാർത്തുകൊള്ളട്ടെ എന്നും അവർ ഫറവോനോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ഫറവോൻ യോസേഫിനോടു: നിന്റെ അപ്പനും സഹോദരന്മാരും നിന്റെ അടുക്കൽ വന്നിരിക്കുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","മിസ്രയീംദേശം നിന്റെ മുമ്പാകെ ഇരിക്കുന്നു; ദേശത്തിലേക്കും നല്ലഭാഗത്തു നിന്റെ അപ്പനെയും സഹോദരന്മാരെയും പാർപ്പിക്ക; അവർ ഗോശെൻദേശത്തുതന്നേ പാർത്തുകൊള്ളട്ടെ. അവരിൽ പ്രാപ്തന്മാർ ഉണ്ടെന്നു നീ അറിയുന്നു എങ്കിൽ അവരെ എന്റെ ആടുമാടുകളുടെ മേൽവിചാരകന്മാരാക്കി വെക്കുക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","യോസേഫ് തന്റെ അപ്പനായ യാക്കോബിനെയും അകത്തു കൊണ്ടുചെന്നു, അവനെ ഫറവോന്റെ സന്നിധിയിൽ നിർത്തി, ");
INSERT INTO mal2015_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","യാക്കോബ് ഫറവോനെ അനുഗ്രഹിച്ചു. ഫറവോൻ യാക്കോബിനോടു: എത്രവയസ്സായി എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","യാക്കോബ് ഫറവോനോടു: എന്റെ പരദേശപ്രയാണത്തിന്റെ കാലം നൂറ്റിമുപ്പതു സംവത്സരം ആയിരിക്കുന്നു. എന്റെ ആയുഷ്കാലം ചുരുക്കവും കഷ്ടമുള്ളതും അത്രേ; എന്റെ പിതാക്കന്മാരുടെ പരദേശപ്രയാണമായ ആയുഷ്കാലത്തോളം എത്തീട്ടുമില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","യാക്കോബ് ഫറവോനെ പിന്നെയും അനുഗ്രഹിച്ചു ഫറവോന്റെ സന്നിധിയിൽനിന്നു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","അനന്തരം യോസേഫ് തന്റെ അപ്പനെയും സഹോദരന്മാരെയും കുടിപാർപ്പിച്ചു; ഫറവോൻ കല്പിച്ചതുപോലെ അവർക്കു മിസ്രയീംദേശത്തിലേക്കും നല്ല ഭാഗമായ രമെസേസ് ദേശത്തു അവകാശവും കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","യോസേഫ് തന്റെ അപ്പനെയും സഹോദരന്മാരെയും അപ്പന്റെ കുടുംബത്തെ ഒക്കെയും കുഞ്ഞുകുട്ടികളുടെ എണ്ണത്തിന്നു ഒത്തവണ്ണം ആഹാരം കൊടുത്തു രക്ഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","എന്നാൽ ക്ഷാമം ഏറ്റവും കഠിനമായിരുന്നതുകൊണ്ടു ദേശത്തെങ്ങും ആഹാരമില്ലാതെയായി മിസ്രയീംദേശവും കനാൻദേശവും ക്ഷാമംകൊണ്ടു വലഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ജനങ്ങൾ വാങ്ങിയ ധാന്യത്തിന്നു വിലയായി യോസേഫ് മിസ്രയീംദേശത്തും കനാൻദേശത്തുമുള്ള പണം ഒക്കെയും ശേഖരിച്ചു; പണം യോസേഫ് ഫറവോന്റെ ഗൃഹത്തിൽ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","മിസ്രയീംദേശത്തും കനാൻദേശത്തും പണം ഇല്ലാതെയായപ്പോൾ മിസ്രയീമ്യർ ഒക്കെയും യോസേഫിന്റെ അടുക്കൽ ചെന്നു: ഞങ്ങൾക്കു ആഹാരം തരേണം; ഞങ്ങൾ നിന്റെ മുമ്പിൽ കിടന്നു മരിക്കുന്നതു എന്തിന്നു? പണം തീർന്നുപോയി എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","അതിന്നു യോസേഫ്: നിങ്ങളുടെ ആടുമാടുകളെ തരുവിൻ; പണം തീർന്നുപോയെങ്കിൽ നിങ്ങളുടെ ആടുമാടുകളെ വിലയായി വാങ്ങി ഞാൻ തരാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","അങ്ങനെ അവർ തങ്ങളുടെ കന്നുകാലികളെ യോസേഫിന്റെ അടുക്കൽ കൊണ്ടുവന്നു; കുതിര, ആടു, കന്നുകാലി, കഴുത എന്നിവയെ യോസേഫ് വിലയായി വാങ്ങി അവർക്കു ആഹാരം കൊടുത്തു; ആയാണ്ടിൽ അവരുടെ കന്നുകാലികളെ എല്ലാം വാങ്ങി ആഹാരം കൊടുത്തു അവരെ രക്ഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ആ ആണ്ടു കഴിഞ്ഞു പിറ്റെ ആണ്ടിൽ അവർ അവന്റെ അടുക്കൽ ചെന്നു അവനോടു പറഞ്ഞതു: ഞങ്ങളുടെ പണം ചെലവായി, മൃഗക്കൂട്ടങ്ങളും യജമാനന്നു ചേർന്നു; ഞങ്ങളുടെ ശരീരങ്ങളും നിലങ്ങളുമല്ലാതെ യജമാനന്റെ മുമ്പാകെ ഒന്നും ശേഷിപ്പില്ല എന്നുള്ളതു യജമാനനെ ഞങ്ങൾ മറെക്കുന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ഞങ്ങളും ഞങ്ങളുടെ നിലവും നിന്റെ കണ്ണിന്നു മുമ്പിൽ എന്തിന്നു നശിക്കുന്നു? നീ ഞങ്ങളെയും നിലത്തെയും ആഹാരത്തിന്നു വിലയായി വാങ്ങേണം. ഞങ്ങൾ നിലവുമായി ഫറവോന്നു അടിമകൾ ആകട്ടെ. ഞങ്ങൾ മരിക്കാതെ ജീവനോടിരിക്കേണ്ടതിന്നും നിലം ശൂന്യമായി പോകാതിരിക്കേണ്ടതിന്നും ഞങ്ങൾക്കു വിത്തു തരേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","അങ്ങനെ യോസേഫ് മിസ്രയീമിലെ നിലം ഒക്കെയും ഫറവോന്നു വിലെക്കു വാങ്ങി; ക്ഷാമം പ്രബലപ്പെടുകകൊണ്ടു മിസ്രയീമ്യർ തങ്ങളുടെ നിലം വിറ്റു; നിലമെല്ലാം ഫറവോന്നു ആയി. ");
INSERT INTO mal2015_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ജനങ്ങളേയോ അവൻ മിസ്രയീംദേശത്തിന്റെ അറ്റംമുതൽ അറ്റംവരെ പട്ടണങ്ങളിലേക്കു കുടിനീക്കി പാർപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","പുരോഹിതന്മാരുടെ നിലം മാത്രം അവൻ വാങ്ങിയില്ല; പുരോഹിതന്മാർക്കു ഫറവോൻ അവകാശം കല്പിച്ചിരുന്നു; ഫറവോൻ അവർക്കു കൊടുത്ത അവകാശം കൊണ്ടു അവർ ഉപജീവനം കഴിച്ചതിനാൽ അവർ തങ്ങളുടെ നിലം വിറ്റില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","യോസേഫ് ജനങ്ങളോടു: ഞാൻ ഇന്നു നിങ്ങളെയും നിങ്ങളുടെ നിലത്തെയും ഫറവോന്നു വിലെക്കു വാങ്ങിയിരിക്കുന്നു; നിങ്ങൾക്കു വിത്തു ഇതാ; നിലം വിതെച്ചുകൊൾവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","വിളവെടുക്കുമ്പോൾ നിങ്ങൾ ഫറവോന്നു അഞ്ചിലൊന്നു കൊടുക്കേണം; നാലോഹരിയോ, വിത്തിന്നു വിത്തായിട്ടും നിങ്ങൾക്കും നിങ്ങളുടെ വീടുകളിലുള്ളവർക്കും നിങ്ങളുടെ കുഞ്ഞുകുട്ടികൾക്കും ആഹാരമായിട്ടും നിങ്ങൾക്കു തന്നേ ഇരിക്കട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","അതിന്നു അവർ: നീ ഞങ്ങളുടെ ജീവനെ രക്ഷിച്ചിരിക്കുന്നു; യജമാനന്നു ഞങ്ങളോടു ദയയുണ്ടായാൽ മതി; ഞങ്ങൾ ഫറവോന്നു അടിമകളായിക്കൊള്ളാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","അഞ്ചിലൊന്നു ഫറവൊന്നു ചെല്ലേണം എന്നിങ്ങിനെ യോസേഫ് മിസ്രയീമിലെ നിലങ്ങളെ സംബന്ധിച്ചുവെച്ച ചട്ടം ഇന്നുവരെയും നടപ്പാകുന്നു. പുരോഹിതന്മാരുടെ നിലം മാത്രം ഫറവോന്നു ചേർന്നിട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","യിസ്രായേൽ മിസ്രയീംരാജ്യത്തിലെ ഗോശെൻദേശത്തു പാർത്തു; അവിടെ അവകാശം സമ്പാദിച്ചു, ഏറ്റവും സന്താനപുഷ്ടിയുള്ളവരായി പെരുകിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","യാക്കോബ് മിസ്രയീംദേശത്തു വന്നിട്ടു പതിനേഴു സംവത്സരം ജീവിച്ചിരുന്നു; യാക്കോബിന്റെ ആയുഷ്കാലം ആകെ നൂറ്റിനാല്പത്തേഴു സംവത്സരം ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","യിസ്രായേൽ മരിപ്പാനുള്ള കാലം അടുത്തപ്പോൾ അവൻ തന്റെ മകനായ യോസേഫിനെ വിളിപ്പിച്ചു അവനോടു: നിനക്കു എന്നോടു കൃപയുണ്ടെങ്കിൽ നിന്റെ കൈ എന്റെ തുടയിൻകീഴിൽ വെക്കുക; എന്നോടു ദയയും വിശ്വസ്തതയും കാണിച്ചു എന്നെ മിസ്രയീമിൽ അടക്കാതെ, ");
INSERT INTO mal2015_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ഞാൻ എന്റെ പിതാക്കന്മാരെപ്പോലെ നിദ്രകൊള്ളുമ്പോൾ എന്നെ മിസ്രയീമിൽനിന്നു എടുത്തുകൊണ്ടുപോയി അവരുടെ ശ്മശാനഭൂമിയിൽ അടക്കേണം എന്നു പറഞ്ഞു. നിന്റെ കല്പനപ്രകാരം ഞാൻ ചെയ്യാം എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","എന്നോടു സത്യം ചെയ്ക എന്നു അവൻ പറഞ്ഞു; അവൻ സത്യവും ചെയ്തു; അപ്പോൾ യിസ്രായേൽ കട്ടിലിന്റെ തലെക്കൽ നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","അനന്തരം യോസേഫിന്നു: നിന്റെ അപ്പൻ ദീനമായി കിടക്കുന്നു എന്നു വർത്തമാനം വന്നു; ഉടനെ അവൻ മനശ്ശെ, എഫ്രയീം എന്ന രണ്ടു പുത്രന്മാരെയും കൂട്ടിക്കൊണ്ടു ചെന്നു: ");
INSERT INTO mal2015_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","നിന്റെ മകൻ യോസേഫ് ഇതാ വരുന്നു എന്നു യാക്കോബിനെ അറിയിച്ചു; അപ്പോൾ യിസ്രായേൽ തന്നെത്താൻ ഉറപ്പിച്ചു കട്ടിലിന്മേൽ ഇരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","യാക്കോബ് യോസേഫിനോടു പറഞ്ഞതു: സർവ്വശക്തിയുള്ള ദൈവം കനാൻദേശത്തിലെ ലൂസ്സിൽവെച്ചു എനിക്കു പ്രത്യക്ഷനായി എന്നെ അനുഗ്രഹിച്ചു, ");
INSERT INTO mal2015_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","എന്നോടു: ഞാൻ നിന്നെ സന്താനപുഷ്ടിയുള്ളവനാക്കി പെരുക്കി നിന്നെ ജനസമൂഹമാക്കുകയും നിന്റെ ശേഷം നിന്റെ സന്തതിക്കു ഈ ദേശം ശാശ്വതാവകാശമായി കൊടുക്കയും ചെയ്യും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","മിസ്രയീമിൽ നിന്റെ അടുക്കൽ ഞാൻ വരുംമുമ്പെ നിനക്കു മിസ്രയീംദേശത്തുവെച്ചു ജനിച്ച രണ്ടു പുത്രന്മാരായ മനശ്ശെയും എഫ്രയീമും എനിക്കുള്ളവർ ആയിരിക്കട്ടെ; രൂബേനും ശിമെയോനും എന്നപോലെ അവർ എനിക്കുള്ളവരായിരിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ഇവരുടെ ശേഷം നിനക്കു ജനിക്കുന്ന സന്തതിയോ നിനക്കുള്ളവരായിരിക്കട്ടെ; അവർ തങ്ങളുടെ അവകാശത്തിൽ തങ്ങളുടെ സഹോദരന്മാരുടെ പേരിൻപ്രകാരം വിളിക്കപ്പെടട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ഞാൻ പദ്ദനിൽനിന്നു വരുമ്പോൾ, കനാൻദേശത്തു എഫ്രാത്തിൽ എത്തുവാൻ അല്പം ദൂരം മാത്രമുള്ളപ്പോൾ വഴിയിൽവെച്ചു റാഹേൽ മരിച്ചു; ഞാൻ അവളെ അവിടെ ബേത്ത്ലേഹെം എന്ന എഫ്രാത്തിന്നുള്ള വഴിയരികെ അടക്കം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","യിസ്രായേൽ യോസേഫിന്റെ പുത്രന്മാരെ കണ്ടപ്പോൾ: ഇവർ ആരെന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ദൈവം ഇവിടെ എനിക്കു തന്നിട്ടുള്ള പുത്രന്മാർ എന്നു യോസേഫ് അപ്പനോടു പറഞ്ഞു. അവരെ എന്റെ അടുക്കൽ കൊണ്ടുവരിക; ഞാൻ അവരെ അനുഗ്രഹിക്കും എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","എന്നാൽ യിസ്രായേലിന്റെ കണ്ണു വയസ്സുകൊണ്ടു മങ്ങി കാണ്മാൻ വഹിയാതിരുന്നു; അവരെ അടുക്കൽ കൊണ്ടുചെന്നപ്പോൾ അവൻ അവരെ ചുംബിച്ചു ആലിംഗനം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","യിസ്രായേൽ യോസേഫിനോടു: നിന്റെ മുഖം കാണുമെന്നു ഞാൻ വിചാരിച്ചിരുന്നില്ല; എന്നാൽ നിന്റെ സന്തതിയെയും കാണ്മാൻ ദൈവം എനിക്കു സംഗതിവരുത്തിയല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","യോസേഫ് അവരെ അവന്റെ മുഴങ്കാലുകൾക്കിടയിൽ നിന്നു മാറ്റി; സാഷ്ടാംഗം നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","പിന്നെ യോസേഫ് എഫ്രയീമിനെ വലങ്കൈകൊണ്ടു പിടിച്ചു യിസ്രായേലിന്റെ ഇടങ്കൈക്കു നേരെയും മനശ്ശെയെ ഇടങ്കൈകൊണ്ടു പിടിച്ചു യിസ്രായേലിന്റെ വലങ്കൈക്കു നേരെയുമായി ഇങ്ങനെ രണ്ടുപേരെയും അവന്റെ അടുക്കൽ കൊണ്ടുചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","യിസ്രായേൽ വലങ്കൈ നീട്ടി ഇളയവനായ എഫ്രയീമിന്റെ തലയിലും ഇടങ്കൈ മൂത്തവനായ മനശ്ശെയുടെ തലയിലുമായി അങ്ങനെ തന്റെ കൈകളെ പിണെച്ചുവെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","പിന്നെ അവൻ യോസേഫിനെ അനുഗ്രഹിച്ചു: എന്റെ പിതാക്കന്മാരായ അബ്രാഹാമും യിസ്ഹാക്കും ഭജിച്ചുപോന്ന ദൈവം, ഞാൻ ജനിച്ച നാൾമുതൽ ഇന്നുവരെയും എന്നെ പുലർത്തിയിരിക്കുന്ന ദൈവം, ");
INSERT INTO mal2015_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","എന്നെ സകലദോഷങ്ങളിൽനിന്നും വിടുവിച്ച ദൂതൻ ഈ കുട്ടികളെ അനുഗ്രഹിക്കുമാറാകട്ടെ; എന്റെ പേരും എന്റെ പിതാക്കന്മാരായ അബ്രാഹാമിന്റെയും യിസ്ഹാക്കിന്റെയും പേരും ഇവരിൽ നിലനില്ക്കുമാറാകട്ടെ; അവർ ഭൂമിയിൽ കൂട്ടമായിവർദ്ധിക്കട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","അപ്പൻ വലങ്കൈ എഫ്രയീമിന്റെ തലയിൽവെച്ചു എന്നു യോസേഫ് കണ്ടപ്പോൾ അവന്നു അനിഷ്ടം തോന്നി; അപ്പന്റെ കൈ എഫ്രയീമിന്റെ തലയിൽനിന്നു മനശ്ശെയുടെ തലയിൽ മാറ്റിവെപ്പാൻ പിടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","യോസേഫ് അപ്പനോടു: അങ്ങനെയല്ല, എന്റെ അപ്പാ; ഇവനല്ലോ ആദ്യജാതൻ; ഇവന്റെ തലയിൽ വലങ്കൈ വെക്കേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","എന്നാൽ അവന്റെ അപ്പൻ സമ്മതിക്കാതെ: എനിക്കു അറിയാം; മകനേ, എനിക്കു അറിയാം; ഇവനും ഒരു വലിയ ജനമായിത്തീരും, ഇവനും വർദ്ധിക്കും; എങ്കിലും അനുജൻ അവനെക്കാൾ അധികം വർദ്ധിക്കും; അവന്റെ സന്തതി ജനസമൂഹമായ്തീരും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","അങ്ങനെ അവൻ അന്നു അവരെ അനുഗ്രഹിച്ചു: ദൈവം നിന്നെ എഫ്രയീമിനെയും മനശ്ശെയെയുംപോലെ ആക്കുമാറാകട്ടെ എന്നു യിസ്രായേല്യർ നിന്റെ പേർ ചൊല്ലി അനുഗ്രഹിക്കും എന്നു പറഞ്ഞു എഫ്രയീമിനെ മനശ്ശെക്കു മുമ്പാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","യോസേഫിനോടു യിസ്രായേൽ പറഞ്ഞതു: ഇതാ, ഞാൻ മരിക്കുന്നു; ദൈവം നിങ്ങളോടുകൂടെ ഇരുന്നു നിങ്ങളെ നിങ്ങളുടെ പിതാക്കന്മാരുടെ ദേശത്തേക്കു മടക്കി കൊണ്ടുപോകും. ");
INSERT INTO mal2015_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","എന്റെ വാളും വില്ലുംകൊണ്ടു ഞാൻ അമോര്യരുടെ കയ്യിൽ നിന്നു പിടിച്ചടക്കിയ മലഞ്ചരിവു ഞാൻ നിന്റെ സഹോദരന്മാരുടെ ഓഹരിയിൽ കവിഞ്ഞതായി നിനക്കു തന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","അനന്തരം യാക്കോബ് തന്റെ പുത്രന്മാരെ വിളിച്ചു അവരോടു പറഞ്ഞതു: കൂടിവരുവിൻ, ഭാവികാലത്തു നിങ്ങൾക്കു സംഭവിപ്പാനുള്ളതു ഞാൻ നിങ്ങളെ അറിയിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","യാക്കോബിന്റെ പുത്രന്മാരേ: കൂടിവന്നു കേൾപ്പിൻ; നിങ്ങളുടെ അപ്പനായ യിസ്രായേലിന്റെ മൊഴിക്കു ചെവിതരുവിൻ! ");
INSERT INTO mal2015_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","രൂബേനേ, നീ എന്റെ ആദ്യജാതൻ, എന്റെ വീര്യവും എന്റെ ശക്തിയുടെ ആദ്യഫലവും ശ്രേഷ്ഠതയുടെ വൈശിഷ്ട്യവും ബലത്തിന്റെ വൈശിഷ്ട്യവും തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","വെള്ളംപോലെ തുളുമ്പുന്നവനേ, നീ ശ്രേഷ്ഠനാകയില്ല; നീ അപ്പന്റെ കിടക്കമേൽ കയറി അതിനെ അശുദ്ധമാക്കി; എന്റെ ശയ്യമേൽ അവൻ കയറിയല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","ശിമയോനും ലേവിയും സഹോദരന്മാർ; അവരുടെ വാളുകൾ സാഹസത്തിന്റെ ആയുധങ്ങൾ. ");
INSERT INTO mal2015_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","എൻ ഉള്ളമേ, അവരുടെ മന്ത്രണത്തിൽ കൂടരുതേ; എൻ മനമേ, അവരുടെ യോഗത്തിൽ ചേരരുതേ; തങ്ങളുടെ കോപത്തിൽ അവർ പുരുഷന്മാരെ കൊന്നു; തങ്ങളുടെ ശാഠ്യത്തിൽ കൂറ്റന്മാരുടെ വരിയുടെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","അവരുടെ ഉഗ്രകോപവും കഠിനക്രോധവും ശപിക്കപ്പെട്ടതു; ഞാൻ അവരെ യാക്കോബിൽ പകുക്കയും യിസ്രായേലിൽ ചിതറിക്കയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","യെഹൂദയേ, സഹോദരന്മാർ നിന്നെ പുകഴ്ത്തും; നിന്റെ കൈ ശത്രുക്കളുടെ കഴുത്തിൽ ഇരിക്കും; അപ്പന്റെ മക്കൾ നിന്റെ മുമ്പിൽ നമസ്കരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","യഹൂദാ ഒരു ബാലസിംഹം; മകനേ, നീ ഇരപിടിച്ചു കയറിയിരിക്കുന്നു; അവൻ കുനിഞ്ഞു, സിംഹംപോലെയും സിംഹിപോലെയും പതുങ്ങിക്കിടക്കുന്നു; ആർ അവനെ എഴുന്നേല്പിക്കും? ");
INSERT INTO mal2015_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","അവകാശമുള്ളവൻ വരുവോളം ചെങ്കോൽ യെഹൂദയിൽനിന്നും രാജദണ്ഡു അവന്റെ കാലുകളുടെ ഇടയിൽ നിന്നും നീങ്ങിപ്പോകയില്ല; ജാതികളുടെ അനുസരണം അവനോടു ആകും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","അവൻ മുന്തിരിവള്ളിയോടു ചെറുകഴുതയെയും വിശിഷ്ടമുന്തിരിവള്ളിയോടു കഴുതക്കുട്ടിയെയും കെട്ടുന്നു; അവൻ വീഞ്ഞിൽ തന്റെ ഉടുപ്പും ദ്രാക്ഷാരസത്തിൽ തന്റെ വസ്ത്രവും അലക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","അവന്റെ കണ്ണു വീഞ്ഞുകൊണ്ടു ചുവന്നും അവന്റെ പല്ലു പാലുകൊണ്ടു വെളുത്തും ഇരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","സെബൂലൂൻ സമുദ്രതീരത്തു വസിക്കും; അവൻ കപ്പൽതുറമുഖത്തു പാർക്കും; അവന്റെ പാർശ്വം സീദോൻ വരെ ആകും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","യിസ്സാഖാർ അസ്ഥിബലമുള്ള കഴുത; അവൻ തൊഴുത്തുകളുടെ മദ്ധ്യേ കിടക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","വിശ്രാമം നല്ലതെന്നും ദേശം ഇമ്പമുള്ളതെന്നും കണ്ടു, അവൻ ചുമടിന്നു ചുമൽ കൊടുത്തു ഊഴിയത്തിന്നു ദാസനായ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ദാൻ ഏതൊരു യിസ്രായേല്യഗോത്രവുംപോലെ സ്വജനത്തിന്നു ന്യായപാലനം ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ദാൻ വഴിയിൽ ഒരു പാമ്പും പാതയിൽ ഒരു സർപ്പവും ആകുന്നു; അവൻ കുതിരയുടെ കുതികാൽ കടിക്കും; പുറത്തു കയറിയവൻ മലർന്നു വീഴും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","യഹോവേ, ഞാൻ നിന്റെ രക്ഷക്കായി കാത്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ഗാദോ കവർച്ചപ്പട അവനെ ഞെരുക്കും; അവനോ അവരുടെ പിൻപടയെ ഞെരുക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ആശേരോ, അവന്റെ ആഹാരം പുഷ്ടിയുള്ളതു; അവൻ രാജകീയസ്വാദുഭോജനം നല്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","നഫ്താലി സ്വതന്ത്രയായി നടക്കുന്ന പേടമാൻ; അവൻ ലാവണ്യവാക്കുകൾ സംസാരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","യോസേഫ് ഫലപ്രദമായോരു വൃക്ഷം, നീരുറവിന്നരികെ ഫലപ്രദമായോരു വൃക്ഷം തന്നേ; അതിന്റെ കൊമ്പുകൾ മതിലിന്മേൽ പടരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","വില്ലാളികൾ അവനെ വിഷമിപ്പിച്ചു; അവർ എയ്തു, അവനോടു പൊരുതു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","അവന്റെ വില്ലു ഉറപ്പോടെ നിന്നു; അവന്റെ ഭുജം യാക്കോബിൻ വല്ലഭന്റെ കയ്യാൽ ബലപ്പെട്ടു; യിസ്രായേലിന്റെ പാറയായ ഇടയന്റെ നാമത്താൽ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","നിൻ പിതാവിന്റെ ദൈവത്താൽ - അവൻ നിന്നെ സഹായിക്കും - സർവ്വശക്തനാൽ തന്നേ - അവൻ മീതെ ആകാശത്തിന്റെ അനുഗ്രഹങ്ങളാലും താഴെ കിടക്കുന്ന ആഴത്തിന്റെ അനുഗ്രങ്ങളാലും മുലയുടെയും ഗർഭത്തിന്റെയും അനുഗ്രഹങ്ങളാലും നിന്നെ അനുഗ്രഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","നിൻ പിതാവിന്റെ അനുഗ്രഹങ്ങൾ എൻ ജനകന്മാരുടെ അനുഗ്രഹങ്ങൾക്കു മീതെ ശാശ്വതഗിരികളുടെ അറ്റത്തോളം പ്രബലപ്പെട്ടു. അവ യോസേഫിന്റെ തലയിലും തന്റെ സഹോദരന്മാരിൽ പ്രഭുവായവന്റെ നെറുകയിലും വരും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","ബെന്യാമീൻ കടിച്ചു കീറുന്ന ചെന്നായി; രാവിലേ അവൻ ഇരപിടിച്ചു വിഴുങ്ങും; വൈകുന്നേരത്തു അവൻ കവർച്ച പങ്കിടും. ");
INSERT INTO mal2015_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","യിസ്രായെൽ ഗോത്രം പന്ത്രണ്ടും ഇവ ആകുന്നു; അവരുടെ പിതാവു അവരോടു പറഞ്ഞതു ഇതു തന്നേ; അവൻ അവരിൽ ഓരോരുത്തന്നു അവനവന്റെ അനുഗ്രഹം കൊടുത്തു അവരെ അനുഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","അവൻ അവരോടു ആജ്ഞാപിച്ചു പറഞ്ഞതു: ഞാൻ എന്റെ ജനത്തോടു ചേരുമ്പോൾ നിങ്ങൾ ഹിത്യനായ എഫ്രോന്റെ നിലത്തിലെ ഗുഹയിൽ എന്റെ പിതാക്കന്മാരുടെ അടുക്കൽ എന്നെ അടക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","കനാൻദേശത്തു മമ്രേക്കു സമീപം, അബ്രാഹാം ഹിത്യനായ എഫ്രോനോടു നിലത്തോടുകൂടെ ശ്മശാനഭൂമിയായി ജന്മം വാങ്ങിയ മക്പേലാ എന്ന നിലത്തിലെ ഗുഹയിൽ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","അവിടെ അവർ അബ്രാഹാമിനെയും അവന്റെ ഭാര്യയായ സാറയെയും യിസ്ഹാക്കിനെയും അവന്റെ ഭാര്യയായ റിബെക്കയെയും അടക്കി; അവിടെ ഞാൻ ലേയയെയും അടക്കി. ");
INSERT INTO mal2015_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ആ നിലവും അതിലെ ഗുഹയും ഹിത്യരോടു വിലെക്കു വാങ്ങിയതാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","യാക്കോബ് തന്റെ പുത്രന്മാരോടു ആജ്ഞാപിച്ചു തീർന്നശേഷം അവൻ കാൽ കട്ടിലിന്മേൽ എടുത്തു വെച്ചിട്ടു പ്രാണനെ വിട്ടു തന്റെ ജനത്തോടു ചേർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","അപ്പോൾ യോസേഫ് തന്റെ അപ്പന്റെ മുഖത്തു വീണു കരഞ്ഞു അവനെ ചുംബിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","പിന്നെ തന്റെ അപ്പന്നു സുഗന്ധവർഗ്ഗം ഇടുവാൻ യോസേഫ് തന്റെ ദാസന്മാരായ വൈദ്യന്മാരോടു കല്പിച്ചു; വൈദ്യന്മാർ യിസ്രായേലിനു സുഗന്ധവർഗ്ഗം ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","അങ്ങനെ നാല്പതു ദിവസം കഴിഞ്ഞു; സുഗന്ധവർഗ്ഗം ഇടുവാൻ അത്ര ദിവസം വേണ്ടിവരും. മിസ്രയീമ്യർ അവനെക്കുറിച്ചു എഴുപതു ദിവസം വിലാപം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","അവന്നായുള്ള വിലാപകാലം കഴിഞ്ഞപ്പോൾ യോസേഫ് ഫറവോന്റെ ഗൃഹക്കാരോടു സംസാരിച്ചു: നിങ്ങൾക്കു എന്നോടു ദയ ഉണ്ടെങ്കിൽ നിങ്ങൾ ഫറവോനോടു: ");
INSERT INTO mal2015_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","എന്റെ അപ്പൻ: ഇതാ, ഞാൻ മരിക്കുന്നു; ഞാൻ കനാൻദേശത്തു എനിക്കുവേണ്ടി വെട്ടിയിരിക്കുന്ന കല്ലറയിൽ തന്നേ നീ എന്നെ അടക്കേണമെന്നു പറഞ്ഞു എന്നെക്കൊണ്ടു സത്യം ചെയ്യിച്ചിട്ടുണ്ടു. ആകയാൽ ഞാൻ പോയി എന്റെ അപ്പനെ അടക്കി മടങ്ങിവരുവാൻ അനുവാദത്തിന്നു അപേക്ഷിക്കുന്നു എന്നു ഉണർത്തിപ്പിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","നിന്റെ അപ്പൻ നിന്നെക്കൊണ്ടു സത്യം ചെയ്യിച്ചതുപോലെ നീ പോയി അവനെ അടക്കുക എന്നു ഫറവോൻ കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","അങ്ങനെ യോസേഫ് അപ്പനെ അടക്കുവാൻ പൊയി; ഫറവോന്റെ ഭൃത്യന്മാരും കോവിലധികാരികളും ");
INSERT INTO mal2015_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","മിസ്രയീംദേശത്തിലെ പ്രമാണികളും യോസേഫിന്റെ കുടുംബം ഒക്കെയും അവന്റെ സഹോദരന്മാരും പിതൃഭവനവും അവനോടുകൂടെ പോയി; തങ്ങളുടെ കുഞ്ഞുകുട്ടികളെയും ആടുമാടുകളെയും മാത്രം അവർ ഗോശെൻദേശത്തു വിട്ടേച്ചുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","രഥങ്ങളും കുതിരയാളുകളും അവനോടുകൂടെ പോയി; അതു എത്രയും വലിയ കൂട്ടമായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","അവർ യോർദ്ദാന്നക്കരെയുള്ള ഗോരെൻ-ആതാദിൽ എത്തിയപ്പോൾ അവിടെവെച്ചു എത്രയും ഗൗരവമായ പ്രലാപം കഴിച്ചു; ഇങ്ങനെ അവൻ ഏഴു ദിവസം തന്റെ അപ്പനെക്കുറിച്ചു വിലാപം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ദേശനിവാസികളായ കനാന്യർ ഗോരെൻ-ആതാദിലെ വിലാപം കണ്ടിട്ടു: ഇതു മിസ്രയീമ്യരുടെ മഹാവിലാപം എന്നു പറഞ്ഞു; അതുകൊണ്ടു ആ സ്ഥലത്തിന്നു ആബേൽ-മിസ്രയീം എന്നു പേരായി; അതു യോർദ്ദാന്നക്കരെ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","അവൻ കല്പിച്ചിരുന്നതുപോലെ പുത്രന്മാർ അവന്നു ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","അവന്റെ പുത്രന്മാർ അവനെ കനാൻദേശത്തേക്കു കൊണ്ടുപോയി, മമ്രേക്കു സമീപം അബ്രാഹാം ഹിത്യനായ എഫ്രോനോടു നിലത്തോടുകൂടെ ശ്മശാനഭൂമിയായി ജന്മം വാങ്ങിയ മക്പേലയെന്ന നിലത്തിലെ ഗുഹയിൽ അവനെ അടക്കംചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","യോസേഫ് അപ്പനെ അടക്കിയശേഷം അവനും സഹോദരനും അവന്റെ അപ്പനെ അടക്കുവാൻ കൂടെ പോയിരുന്ന എല്ലാവരും മിസ്രയീമിലേക്കു മടങ്ങിപ്പോന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","അപ്പൻ മരിച്ചുപോയി എന്നു യോസേഫിന്റെ സഹോദരന്മാർ കണ്ടിട്ടു: പക്ഷേ യോസേഫ് നമ്മെ ദ്വേഷിച്ചു, നാം അവനോടു ചെയ്ത സകലദോഷത്തിന്നും നമ്മോടു പ്രതികാരം ചെയ്യുമെന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","അവർ യോസേഫിന്റെ അടുക്കൽ ആളയച്ചു: അപ്പൻ മരിക്കും മുമ്പെ: നിന്റെ സഹോദരന്മാർ നിന്നോടു ദോഷം ചെയ്തു; അവർ ചെയ്ത അതിക്രമവും പാപവും നീ ക്ഷമിക്കേണം എന്നു യോസേഫിനോടു പറവിൻ എന്നു കല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ആകയാൽ അപ്പന്റെ ദൈവത്തിന്റെ ദാസന്മാരുടെ ദ്രോഹം ക്ഷമിക്കേണമേ എന്നു പറയിച്ചു. അവർ യോസേഫിനോടു സംസാരിക്കുമ്പോൾ അവൻ കരഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","അവന്റെ സഹോദരന്മാർ ചെന്നു അവന്റെ മുമ്പാകെ വീണു: ഇതാ, ഞങ്ങൾ നിനക്കു അടിമകൾ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","യോസേഫ് അവരോടു: നിങ്ങൾ ഭയപ്പെടേണ്ടാ; ഞാൻ ദൈവത്തിന്റെ സ്ഥാനത്തു ഇരിക്കുന്നുവോ? ");
INSERT INTO mal2015_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","നിങ്ങൾ എന്റെ നേരെ ദോഷം വിചാരിച്ചു; ദൈവമോ, ഇന്നുള്ളതുപോലെ ബഹുജനത്തിന്നു ജീവരക്ഷ വരുത്തേണ്ടതിന്നു അതിനെ ഗുണമാക്കിത്തീർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ആകയാൽ നിങ്ങൾ ഭയപ്പെടേണ്ടാ; ഞാൻ നിങ്ങളെയും നിങ്ങളുടെ കുഞ്ഞുകുട്ടികളെയും പോറ്റി രക്ഷിക്കും എന്നു പറഞ്ഞു അവരെ ആശ്വസിപ്പിച്ചു ധൈര്യപ്പെടുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","യോസേഫും അവന്റെ പിതൃഭവനവും മിസ്രയീമിൽ പാർത്തു, യോസേഫ് നൂറ്റിപ്പത്തു സംവത്സരം ജീവിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","എഫ്രയീമിന്റെ മൂന്നാം തലമുറയിലെ മക്കളെയും കണ്ടു; മനശ്ശെയുടെ മകനായ മാഖീരിന്റെ മക്കളും യോസേഫിന്റെ മടിയിൽ വളർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","അനന്തരം യോസേഫ് തന്റെ സഹോദരന്മാരോടു: ഞാൻ മരിക്കുന്നു; എന്നാൽ ദൈവം നിങ്ങളെ സന്ദർശിക്കയും ഈ ദേശത്തുനിന്നു താൻ അബ്രാഹാമിനോടും യിസ്ഹാക്കിനോടും യാക്കോബിനോടും സത്യംചെയ്ത ദേശത്തേക്കു കൊണ്ടുപോകയും ചെയ്യും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ദൈവം നിങ്ങളെ സന്ദർശിക്കുമ്പോൾ നിങ്ങൾ എന്റെ അസ്ഥികളെ ഇവിടെനിന്നു കൊണ്ടുപോകേണമെന്നു പറഞ്ഞു യോസേഫ് യിസ്രായേൽമക്കളെക്കൊണ്ടു സത്യം ചെയ്യിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","യോസേഫ് നൂറ്റിപ്പത്തു വയസ്സുള്ളവനായി മരിച്ചു. അവർ അവന്നു സുഗന്ധവർഗ്ഗം ഇട്ടു അവനെ മിസ്രയീമിൽ ഒരു ശവപ്പെട്ടിയിൽ വെച്ചു.");
INSERT INTO mal2015_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","യാക്കോബിനോടുകൂടെ താന്താന്റെ കുടുംബസഹിതം മിസ്രയീമിൽ വന്ന യിസ്രായേൽമക്കളുടെ പേരുകൾ ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","രൂബേൻ, ശിമെയോൻ, ലേവി, ");
INSERT INTO mal2015_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","യെഹൂദാ, യിസ്സാഖാർ, സെബൂലൂൻ, ബെന്യാമീൻ ");
INSERT INTO mal2015_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ദാൻ, നഫ്താലി, ഗാദ്, ആശേർ. ");
INSERT INTO mal2015_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","യാക്കോബിന്റെ കടിപ്രദേശത്തുനിന്നു ഉത്ഭവിച്ച ദേഹികൾ എല്ലാം കൂടെ എഴുപതു പേർ ആയിരുന്നു; യോസേഫോ മുമ്പെ തന്നേ മിസ്രയീമിൽ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","യോസേഫും സഹോദരന്മാരെല്ലാവരും ആ തലമുറ ഒക്കെയും മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","യിസ്രായേൽമക്കൾ സന്താനസമ്പന്നരായി അത്യന്തം വർദ്ധിച്ചു പെരുകി ബലപ്പെട്ടു; ദേശം അവരെക്കൊണ്ടു നിറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","അനന്തരം യോസേഫിനെ അറിയാത്ത പുതിയോരു രാജാവു മിസ്രയീമിൽ ഉണ്ടായി. ");
INSERT INTO mal2015_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","അവൻ തന്റെ ജനത്തോടു: യിസ്രായേൽജനം നമ്മെക്കാൾ ബാഹുല്യവും ശക്തിയുമുള്ളവരാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","അവർ പെരുകീട്ടു ഒരു യുദ്ധം ഉണ്ടാകുന്ന പക്ഷം നമ്മുടെ ശത്രുക്കളോടു ചേർന്നു നമ്മോടു പൊരുതു ഈ രാജ്യം വിട്ടു പൊയ്ക്കളവാൻ സംഗതി വരാതിരിക്കേണ്ടതിന്നു നാം അവരോടു ബുദ്ധിയായി പെരുമാറുക. ");
INSERT INTO mal2015_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","അങ്ങനെ കഠിനവേലകളാൽ അവരെ പീഡിപ്പിക്കേണ്ടതിന്നു അവരുടെമേൽ ഊഴിയവിചാരകന്മാരെ ആക്കി; അവർ പീഥോം, റയംസേസ് എന്ന സംഭാരനഗരങ്ങളെ ഫറവോന്നു പണിതു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","എന്നാൽ അവർ പീഡിപ്പിക്കുന്തോറും ജനം പെരുകി വർദ്ധിച്ചു; അതുകൊണ്ടു അവർ യിസ്രായേൽമക്കൾ നിമിത്തം പേടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","മിസ്രയീമ്യർ യിസ്രായേൽമക്കളെക്കൊണ്ടു കഠിനവേല ചെയ്യിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","കളിമണ്ണും ഇഷ്ടികയും വയലിലെ സകലവിധവേലയും സംബന്ധിച്ചുള്ള കഠിനപ്രവർത്തിയാലും അവരെക്കൊണ്ടു കാഠിന്യത്തോടെ ചെയ്യിച്ച സകലപ്രയത്നത്താലും അവർ അവരുടെ ജീവനെ കൈപ്പാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","എന്നാൽ മിസ്രയീംരാജാവു ശിപ്രാ എന്നും പൂവാ എന്നും പേരുള്ള എബ്രായസൂതികർമ്മിണികളോടു: ");
INSERT INTO mal2015_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","എബ്രായസ്ത്രീകളുടെ അടുക്കൽ നിങ്ങൾ സൂതികർമ്മത്തിന്നു ചെന്നു പ്രസവശയ്യയിൽ അവരെ കാണുമ്പോൾ കുട്ടി ആണാകുന്നു എങ്കിൽ നിങ്ങൾ അതിനെ കൊല്ലേണം; പെണ്ണാകുന്നു എങ്കിൽ ജീവനോടിരിക്കട്ടെ എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","സൂതികർമ്മിണികളോ ദൈവത്തെ ഭയപ്പെട്ടു, മിസ്രയീം രാജാവു തങ്ങളോടു കല്പിച്ചതുപോലെ ചെയ്യാതെ ആൺകുഞ്ഞുങ്ങളെ ജീവനോടെ രക്ഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","അപ്പോൾ മിസ്രയീം രാജാവു സൂതികർമ്മിണികളെ വരുത്തി; ഇതെന്തൊരു പ്രവൃത്തി? നിങ്ങൾ ആൺകുഞ്ഞുങ്ങളെ ജീവനോടെ രക്ഷിക്കുന്നതു എന്തു എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","സൂതികർമ്മിണികൾ ഫറവോനോടു: എബ്രായസ്ത്രീകൾ മിസ്രയീമ്യസ്ത്രീകളെപ്പോലെ അല്ല; അവർ നല്ല തിറമുള്ളവർ; സൂതികർമ്മിണികൾ അവരുടെ അടുക്കൽ എത്തുമ്മുമ്പെ അവർ പ്രസവിച്ചുകഴിയും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","അതുകൊണ്ടു ദൈവം സൂതികർമ്മിണികൾക്കു നന്മചെയ്തു; ജനം വർദ്ധിച്ചു ഏറ്റവും ബലപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","സൂതി കർമ്മിണികൾ ദൈവത്തെ ഭയപ്പെടുകകൊണ്ടു അവൻ അവർക്കു കുടുംബവർദ്ധന നല്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","പിന്നെ ഫറവോൻ തന്റെ സകലജനത്തോടും: ജനിക്കുന്ന ഏതു ആൺകുട്ടിയെയും നദിയിൽ ഇട്ടുകളയേണമെന്നും ഏതു പെൺകുട്ടിയെയും ജീവനോടെ രക്ഷിക്കേണമെന്നും കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","എന്നാൽ ലേവികുടുംബത്തിലെ ഒരു പുരുഷൻ പോയി ഒരു ലേവ്യകന്യകയെ പരിഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","അവൾ ഗർഭം ധരിച്ചു ഒരു മകനെ പ്രസവിച്ചു. അവൻ സൗന്ദര്യമുള്ളവൻ എന്നു കണ്ടിട്ടു അവനെ മൂന്നു മാസം ഒളിച്ചുവെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","അവനെ പിന്നെ ഒളിച്ചുവെപ്പാൻ കഴിയാതെ ആയപ്പോൾ അവൾ ഒരു ഞാങ്ങണപ്പെട്ടകം വാങ്ങി, അതിന്നു പശയും കീലും തേച്ചു, പൈതലിനെ അതിൽ കിടത്തി, നദിയുടെ അരികിൽ ഞാങ്ങണയുടെ ഇടയിൽ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","അവന്നു എന്തു ഭവിക്കുമെന്നു അറിവാൻ അവന്റെ പെങ്ങൾ ദൂരത്തു നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","അപ്പോൾ ഫറവോന്റെ പുത്രി നദിയിൽ കുളിപ്പാൻ വന്നു; അവളുടെ ദാസിമാർ നദീതീരത്തുകൂടി നടന്നു; അവൾ ഞാങ്ങണയുടെ ഇടയിൽ പെട്ടകം കണ്ടപ്പോൾ അതിനെ എടുത്തുകൊണ്ടുവരുവാൻ ദാസിയെ അയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","അവൾ അതു തുറന്നാറെ പൈതലിനെ കണ്ടു: കുട്ടി ഇതാ, കരയുന്നു. അവൾക്കു അതിനോടു അലിവുതോന്നി: ഇതു എബ്രായരുടെ പൈതങ്ങളിൽ ഒന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","അവന്റെ പെങ്ങൾ ഫറവോന്റെ പുത്രിയോടു: ഈ പൈതലിന്നു മുല കൊടുക്കേണ്ടതിന്നു ഒരു എബ്രായസ്ത്രീയെ ഞാൻ ചെന്നു വിളിച്ചുകൊണ്ടുവരേണമോ എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ഫറവോന്റെ പുത്രി അവളോടു: ചെന്നു കൊണ്ടുവരിക എന്നു പറഞ്ഞു. കന്യക ചെന്നു പൈതലിന്റെ അമ്മയെ വിളിച്ചുകൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ഫറവോന്റെ പുത്രി അവളോടു: നീ ഈ പൈതലിനെ കൊണ്ടുപോയി മുലകൊടുത്തു വളർത്തേണം; ഞാൻ നിനക്കു ശമ്പളം തരാം എന്നു പറഞ്ഞു. സ്ത്രീ പൈതലിനെ എടുത്തു കൊണ്ടുപോയി മുലകൊടുത്തു വളർത്തി. ");
INSERT INTO mal2015_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","പൈതൽ വളർന്നശേഷം അവൾ അവനെ ഫറവോന്റെ പുത്രിയുടെ അടുക്കൽ കൊണ്ടു പോയി, അവൻ അവൾക്കു മകനായി: ഞാൻ അവനെ വെള്ളത്തിൽ നിന്നു വലിച്ചെടുത്തു എന്നു പറഞ്ഞു അവൾ അവന്നു മോശെ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ആ കാലത്തു മോശെ മുതിർന്നശേഷം അവൻ തന്റെ സഹോദരന്മാരുടെ അടുക്കൽ ചെന്നു അവരുടെ ഭാരമുള്ള വേല നോക്കി, തന്റെ സഹോദരന്മാരിൽ ഒരു എബ്രായനെ ഒരു മിസ്രയീമ്യൻ അടിക്കുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","അവൻ അങ്ങോട്ടും ഇങ്ങോട്ടും നോക്കീട്ടു ആരും ഇല്ലെന്നു കണ്ടപ്പോൾ മിസ്രയീമ്യനെ അടിച്ചു കൊന്നു മണലിൽ മറവുചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","പിറ്റേ ദിവസവും അവൻ ചെന്നപ്പോൾ രണ്ടു എബ്രായ പുരുഷന്മാർ തമ്മിൽ ശണ്ഠയിടുന്നതു കണ്ടു, അന്യായം ചെയ്തവനോടു: നിന്റെ കൂട്ടുകാരനെ അടിക്കുന്നതു എന്തു എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","അതിന്നു അവൻ: നിന്നെ ഞങ്ങൾക്കു പ്രഭുവും ന്യായാധിപതിയും ആക്കിയവൻ ആർ? മിസ്രയീമ്യനെ കൊന്നതുപോലെ എന്നെയും കൊല്ലുവാൻ ഭാവിക്കുന്നുവോ എന്നു ചോദിച്ചു. അപ്പോൾ കാര്യം പ്രസിദ്ധമായിപ്പോയല്ലോ എന്നു മോശെ പറഞ്ഞു പേടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ഫറവോൻ ഈ കാര്യം കേട്ടാറെ മോശെയെ കൊല്ലുവാൻ അന്വേഷിച്ചു. മോശെ ഫറവോന്റെ സന്നിധിയിൽനിന്നു ഓടിപ്പോയി, മിദ്യാൻദേശത്തു ചെന്നു പാർത്തു; അവൻ ഒരു കിണറ്റിന്നരികെ ഇരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","മിദ്യാനിലെ പുരോഹിതന്നു ഏഴു പുത്രിമാർ ഉണ്ടായിരുന്നു. അവർ വന്നു അപ്പന്റെ ആടുകൾക്കു കുടിപ്പാൻ വെള്ളം കോരി തൊട്ടികൾ നിറെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","എന്നാൽ ഇടയന്മാർ വന്നു അവരെ ആട്ടിക്കളഞ്ഞു: അപ്പോൾ മോശെ എഴുന്നേറ്റു അവരെ സഹായിച്ചു അവരുടെ ആടുകളെ കുടിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","അവർ തങ്ങളുടെ അപ്പനായ റെഗൂവേലിന്റെ അടുക്കൽ വന്നപ്പോൾ: നിങ്ങൾ ഇന്നു ഇത്ര വേഗം വന്നതു എങ്ങനെ എന്നു അവൻ ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ഒരു മിസ്രയീമ്യൻ ഇടയന്മാരുടെ കയ്യിൽനിന്നു ഞങ്ങളെ വിടുവിച്ചു, ഞങ്ങൾക്കു വെള്ളം കോരിത്തന്നു ആടുകളെ കുടിപ്പിച്ചു എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","അവൻ തന്റെ പുത്രിമാരോടു: അവൻ എവിടെ? നിങ്ങൾ അവനെ വിട്ടേച്ചു പോന്നതെന്തു? ഭക്ഷണം കഴിപ്പാൻ അവനെ വിളിപ്പിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","മോശെക്കു അവനോടുകൂടെ പാർപ്പാൻ സമ്മതമായി; അവൻ മോശെക്കു തന്റെ മകൾ സിപ്പോറയെ കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","അവൾ ഒരു മകനെ പ്രസവിച്ചു: ഞാൻ അന്യദേശത്തു പരദേശി ആയിരിക്കുന്നു എന്നു അവൻ പറഞ്ഞു അവന്നു ഗേർശോം എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ഏറെ നാൾ കഴിഞ്ഞിട്ടു മിസ്രയീംരാജാവു മരിച്ചു. യിസ്രായേൽമക്കൾ അടിമവേല നിമിത്തം നെടുവീർപ്പിട്ടു നിലവിളിച്ചു; അടിമവേല ഹേതുവായുള്ള നിലവിളി ദൈവസന്നിധിയിൽ എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ദൈവം അവരുടെ നിലവിളി കേട്ടു; ദൈവം അബ്രാഹാമിനോടും യിസ്ഹാക്കിനോടും യാക്കോബിനോടും തനിക്കുള്ള നിയമവും ഓർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ദൈവം യിസ്രായേൽമക്കളെ കടാക്ഷിച്ചു; ദൈവം അറിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","മോശെ മിദ്യാനിലെ പുരോഹിതനും തന്റെ അമ്മായപ്പനുമായ യിത്രോവിന്റെ ആടുകളെ മേയിച്ചുകൊണ്ടിരുന്നു; അവൻ ആടുകളെ മരുഭൂമിക്കു അപ്പുറത്തു ദൈവത്തിന്റെ പർവ്വതമായ ഹോരേബ് വരെ കൊണ്ടു ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","അവിടെ യഹോവയുടെ ദൂതൻ ഒരു മുൾപടർപ്പിന്റെ നടുവിൽനിന്നു അഗ്നിജ്വാലയിൽ അവന്നു പ്രത്യക്ഷനായി. അവൻ നോക്കിയാറെ മുൾപടർപ്പു തീ പിടിച്ചു കത്തുന്നതും മുൾപടർപ്പു വെന്തുപോകാതിരിക്കുന്നതും കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","മുൾപടർപ്പു വെന്തുപോകാതിരിക്കുന്ന ഈ വലിയ കാഴ്ച എന്തെന്നു ഞാൻ ചെന്നു നോക്കട്ടെ എന്നു മോശെ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","നോക്കേണ്ടതിന്നു അവൻ വരുന്നതു യഹോവ കണ്ടപ്പോൾ ദൈവം മുൾപടർപ്പിന്റെ നടുവിൽ നിന്നു അവനെ മോശേ, മോശെ എന്നു വിളിച്ചു. അതിന്നു അവൻ: ഇതാ, ഞാൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","അപ്പോൾ അവൻ: ഇങ്ങോട്ടു അടുക്കരുതു; നീ നില്ക്കുന്ന സ്ഥലം വിശുദ്ധഭൂമിയാകയാൽ കാലിൽനിന്നു ചെരിപ്പു അഴിച്ചുകളക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ഞാൻ അബ്രാഹാമിന്റെ ദൈവവും യിസ്ഹാക്കിന്റെ ദൈവവും യാക്കോബിന്റെ ദൈവവുമായി, നിന്റെ പിതാവിന്റെ ദൈവം ആകുന്നു എന്നും അവൻ അരുളിച്ചെയ്തു. മോശെ ദൈവത്തെ നോക്കുവാൻ ഭയപ്പെട്ടു മുഖം മൂടി. ");
INSERT INTO mal2015_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","യഹോവ അരുളിച്ചെയ്തതു: മിസ്രയീമിലുള്ള എന്റെ ജനത്തിന്റെ കഷ്ടത ഞാൻ കണ്ടു കണ്ടു; ഊഴിയവിചാരകന്മാർ നിമിത്തമുള്ള അവരുടെ നിലവിളിയും കേട്ടു; ഞാൻ അവരുടെ സങ്കടങ്ങൾ അറിയുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","അവരെ മിസ്രയീമ്യരുടെ കയ്യിൽനിന്നു വിടുവിപ്പാനും ആ ദേശത്തു നിന്നു നല്ലതും വിശാലവുമായ ദേശത്തേക്കു, പാലും തേനും ഒഴുകുന്ന ദേശത്തേക്കു, കനാന്യർ, ഹിത്യർ, അമോര്യർ, പെരിസ്യർ, ഹിവ്യർ, യെബൂസ്യർ എന്നവരുടെ സ്ഥലത്തേക്കു അവരെ കൊണ്ടുപോകുവാനും ഞാൻ ഇറങ്ങിവന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","യിസ്രായേൽമക്കളുടെ നിലവിളി എന്റെ അടുക്കൽ എത്തിയിരിക്കുന്നു; മിസ്രയീമ്യർ അവരെ ഞെരുക്കുന്ന ഞെരുക്കവും ഞാൻ കണ്ടിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ആകയാൽ വരിക; നീ എന്റെ ജനമായ യിസ്രായേൽമക്കളെ മിസ്രയീമിൽനിന്നു പുറപ്പെടുവിക്കേണ്ടതിന്നു ഞാൻ നിന്നെ ഫറവോന്റെ അടുക്കൽ അയക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","മോശെ ദൈവത്തോടു: ഫറവോന്റെ അടുക്കൽ പോകുവാനും യിസ്രായേൽമക്കളെ മിസ്രയീമിൽനിന്നു പുറപ്പെടുവിപ്പാനും ഞാൻ എന്തു മാത്രമുള്ളു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","അതിന്നു അവൻ: ഞാൻ നിന്നോടുകൂടെ ഇരിക്കും; നീ ജനത്തെ മിസ്രയീമിൽനിന്നു കൂട്ടിക്കൊണ്ടു വരുമ്പോൾ നിങ്ങൾ ഈ പർവ്വതത്തിങ്കൽ ദൈവത്തെ ആരാധിക്കുമെന്നുള്ളതു ഞാൻ നിന്നെ അയച്ചതിന്നു അടയാളം ആകും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","മോശെ ദൈവത്തോടു: ഞാൻ യിസ്രായേൽമക്കളുടെ അടുക്കൽ ചെന്നു: നിങ്ങളുടെ പിതാക്കന്മാരുടെ ദൈവം എന്നെ നിങ്ങളുടെ അടുക്കൽ അയച്ചിരിക്കുന്നു എന്നു പറയുമ്പോൾ: അവന്റെ നാമം എന്തെന്നു അവർ എന്നോടു ചോദിച്ചാൽ ഞാൻ അവരോടു എന്തു പറയേണം എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","അതിന്നു ദൈവം മോശെയോടു: ഞാൻ ആകുന്നവൻ ഞാൻ ആകുന്നു; ഞാൻ ആകുന്നു എന്നുള്ളവൻ എന്നെ നിങ്ങളുടെ അടുക്കൽ അയച്ചിരിക്കുന്നു എന്നിങ്ങനെ നീ യിസ്രായേൽമക്കളോടു പറയേണം എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ദൈവം പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതെന്തന്നാൽ: നീ യിസ്രായേൽമക്കളോടു ഇപ്രകാരം പറയേണം: അബ്രാഹാമിന്റെ ദൈവവും യിസ്ഹാക്കിന്റെ ദൈവവും യാക്കോബിന്റെ ദൈവവുമായി നിങ്ങളുടെ പിതാക്കന്മാരുടെ ദൈവമായ യഹോവ എന്നെ നിങ്ങളുടെ അടുക്കൽ അയച്ചിരിക്കുന്നു; ഇതു എന്നേക്കും എന്റെ നാമവും തലമുറതലമുറയായി എന്റെ ജ്ഞാപകവും ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","നീ ചെന്നു യിസ്രായേൽമൂപ്പന്മാരെ കൂട്ടി അവരോടു: അബ്രാഹാമിന്റെയും യിസ്ഹാക്കിന്റെയും യാക്കോബിന്റെയും ദൈവമായി, നിങ്ങളുടെ പിതാക്കന്മാരുടെ ദൈവമായ യഹോവ എനിക്കു പ്രത്യക്ഷനായി കല്പിച്ചതു: ഞാൻ നിങ്ങളെയും മിസ്രയീമിൽ അവർ നിങ്ങളോടു ചെയ്യുന്നതിനെയും സന്ദർശിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","മിസ്രയീമിലെ കഷ്ടതയിൽനിന്നു കനാന്യർ, ഹിത്യർ, അമോര്യർ, പെരിസ്യർ, ഹിവ്യർ, യെബൂസ്യർ എന്നിവരുടെ ദേശത്തേക്കു, പാലും തേനും ഒഴുകുന്ന ദേശത്തേക്കു നിങ്ങളെ കൊണ്ടുപോകുവാൻ ഞാൻ നിശ്ചയിച്ചിരിക്കുന്നു എന്നു പറക. ");
INSERT INTO mal2015_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","എന്നാൽ അവർ നിന്റെ വാക്കു കേൾക്കും. അപ്പോൾ നീയും യിസ്രായേൽമൂപ്പന്മാരും മിസ്രയീംരാജാവിന്റെ അടുക്കൽ ചെന്നു അവനോടു: എബ്രായരുടെ ദൈവമായ യഹോവ ഞങ്ങൾക്കു വെളിപ്പെട്ടുവന്നിരിക്കുന്നു. ആകയാൽ ഞങ്ങൾ മൂന്നു ദിവസത്തെ വഴി മരുഭൂമിയിൽ ചെന്നു ഞങ്ങളുടെ ദൈവമായ യഹോവെക്കു യാഗം കഴിക്കട്ടെ എന്നു പറവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","എന്നാൽ മിസ്രയീംരാജാവു ഭുജബലംകൊണ്ടല്ലാതെ നിങ്ങളെ പോകുവാൻ സമ്മതിക്കയില്ല എന്നു ഞാൻ അറിയുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","അതുകൊണ്ടു ഞാൻ എന്റെ കൈ നീട്ടി മിസ്രയീമിന്റെ നടുവിൽ ചെയ്‌വാനിരിക്കുന്ന അത്ഭുതങ്ങളെക്കൊണ്ടൊക്കെയും അതിനെ ദണ്ഡിപ്പിക്കും; അതിന്റെ ശേഷം അവൻ നിങ്ങളെ വിട്ടയക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ഞാൻ മിസ്രയീമ്യർക്കു ഈ ജനത്തോടു കൃപ തോന്നുമാറാക്കും; നിങ്ങൾ പോരുമ്പോൾ വെറുങ്കയ്യായി പോരേണ്ടിവരികയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ഓരോ സ്ത്രീ താന്താന്റെ അയൽക്കാരത്തിയോടും വീട്ടിൽ അതിഥിയായി പാർക്കുന്നവളോടും വെള്ളിയാഭരണങ്ങളും പൊന്നാഭരണങ്ങളും വസ്ത്രങ്ങളും ചോദിച്ചുവാങ്ങി നിങ്ങളുടെ പുത്രന്മാരെയും പുത്രിമാരെയും ധരിപ്പിക്കയും മിസ്രയീമ്യരെ കൊള്ളയിടുകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","അതിന്നു മോശെ: അവർ എന്നെ വിശ്വസിക്കാതെയും എന്റെ വാക്കു കേൾക്കാതെയും: യഹോവ നിനക്കു പ്രത്യക്ഷനായിട്ടില്ല എന്നു പറയും എന്നുത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","യഹോവ അവനോടു: നിന്റെ കയ്യിൽ ഇരിക്കുന്നതു എന്തു എന്നു ചോദിച്ചു. ഒരു വടി എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","അതു നിലത്തിടുക എന്നു കല്പിച്ചു. അവൻ നിലത്തിട്ടു; അതു ഒരു സർപ്പമായ്തീർന്നു; മോശെ അതിനെ കണ്ടു ഓടിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","യഹോവ മോശെയോടു: നിന്റെ കൈ നീട്ടി അതിനെ വാലിന്നു പിടിക്ക എന്നു കല്പിച്ചു. അവൻ കൈ നീട്ടി അതിനെ പിടിച്ചു; അതു അവന്റെ കയ്യിൽ വടിയായ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ഇതു അബ്രാഹാമിന്റെ ദൈവവും യിസ്ഹാക്കിന്റെ ദൈവവും യാക്കോബിന്റെ ദൈവവും ആയി അവരുടെ പിതാക്കന്മാരുടെ ദൈവമായ യഹോവ നിനക്കു പ്രത്യക്ഷനായി എന്നു അവർ വിശ്വസിക്കേണ്ടതിന്നു ആകുന്നു ");
INSERT INTO mal2015_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","യഹോവ പിന്നെയും അവനോടു: നിന്റെ കൈ മാർവ്വിടത്തിൽ ഇടുക എന്നു കല്പിച്ചു. അവൻ കൈ മാർവ്വിടത്തിൽ ഇട്ടു; പുറത്തു എടുത്തപ്പോൾ കൈ ഹിമംപോലെ വെളുത്തു കുഷ്ഠമുള്ളതായി കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","നിന്റെ കൈ വീണ്ടും മാർവ്വിടത്തിൽ ഇടുക എന്നു കല്പിച്ചു. അവൻ കൈ വീണ്ടും മാർവ്വിടത്തിൽ ഇട്ടു, മാർവ്വിടത്തിൽനിന്നു പുറത്തെടുത്തപ്പോൾ, അതു വീണ്ടും അവന്റെ മറ്റേ മാംസംപോലെ ആയി കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","എന്നാൽ അവർ വിശ്വസിക്കാതെയും ആദ്യത്തെ അടയാളം അനുസരിക്കാതെയും ഇരുന്നാൽ അവർ പിന്നത്തെ അടയാളം വിശ്വസിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ഈ രണ്ടടയാളങ്ങളും അവർ വിശ്വസിക്കാതെയും നിന്റെ വാക്കു കേൾക്കാതെയും ഇരുന്നാൽ നീ നദിയിലെ വെള്ളം കോരി ഉണങ്ങിയ നിലത്തു ഒഴിക്കേണം; നദിയിൽ നിന്നു കോരിയ വെള്ളം ഉണങ്ങിയ നിലത്തു രക്തമായ്തീരും. ");
INSERT INTO mal2015_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","മോശെ യഹോവയോടു: കർത്താവേ, മുമ്പേ തന്നെയും നീ അടിയനോടു സംസാരിച്ചശേഷവും ഞാൻ വാക്സാമർത്ഥ്യമുള്ളവനല്ല; ഞാൻ വിക്കനും തടിച്ച നാവുള്ളവനും ആകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","അതിന്നു യഹോവ അവനോടു: മനുഷ്യന്നു വായി കൊടുത്തതു ആർ? അല്ല, ഊമനെയും ചെകിടനെയും കാഴ്ചയുള്ളവനെയും കുരുടനെയും ഉണ്ടാക്കിയതു ആർ? യഹോവയായ ഞാൻ അല്ലയോ? ആകയാൽ നീ ചെല്ലുക; ");
INSERT INTO mal2015_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ഞാൻ നിന്റെ വായോടുകൂടെ ഇരുന്നു നീ സംസാരിക്കേണ്ടതു നിനക്കു ഉപദേശിച്ചുതരും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","എന്നാൽ അവൻ: കർത്താവേ, നിനക്കു ബോധിച്ച മറ്റാരെയെങ്കിലും അയക്കേണമേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","അപ്പോൾ യഹോവയുടെ കോപം മോശെയുടെ നേരെ ജ്വലിച്ചു, അവൻ അരുളിച്ചെയ്തു: ലേവ്യനായ അഹരോൻ നിന്റെ സഹോദരനല്ലയോ? അവന്നു നല്ലവണ്ണം സംസാരിക്കാമെന്നു ഞാൻ അറിയുന്നു. അവൻ നിന്നെ എതിരേല്പാൻ പുറപ്പെട്ടുവരുന്നു; നിന്നെ കാണുമ്പോൾ അവൻ ഹൃദയത്തിൽ ആനന്ദിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","നീ അവനോടു സംസാരിച്ചു അവന്നു വാക്കു പറഞ്ഞുകൊടുക്കേണം. ഞാൻ നിന്റെ വായോടും അവന്റെ വായോടുംകൂടെ ഇരിക്കും; നിങ്ങൾ ചെയ്യേണ്ടുന്നതു ഉപദേശിച്ചു തരും. ");
INSERT INTO mal2015_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","നിനക്കു പകരം അവൻ ജനത്തോടു സംസാരിക്കും; അവൻ നിനക്കു വായായിരിക്കും, നീ അവന്നു ദൈവവും ആയിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","അടയാളങ്ങൾ പ്രവർത്തിക്കേണ്ടതിന്നു ഈ വടിയും നിന്റെ കയ്യിൽ എടുത്തുകൊൾക. ");
INSERT INTO mal2015_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","പിന്നെ മോശെ തന്റെ അമ്മായപ്പനായ യിത്രോവിന്റെ അടുക്കൽ ചെന്നു അവനോടു: ഞാൻ പുറപ്പെട്ടു, മിസ്രയീമിലെ എന്റെ സഹോദരന്മാരുടെ അടുക്കൽ ചെന്നു, അവർ ജീവനോടിരിക്കുന്നുവോ എന്നു നോക്കട്ടെ എന്നു പറഞ്ഞു. യിത്രോ മോശെയോടു: സമാധാനത്തോടെ പോക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","യഹോവ മിദ്യാനിൽവെച്ചു മോശെയോടു: മിസ്രയീമിലേക്കു മടങ്ങിപ്പോക; നിനക്കു ജീവഹാനി വരുത്തുവാൻ നോക്കിയവർ എല്ലാവരും മരിച്ചുപോയി എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","അങ്ങനെ മോശെ തന്റെ ഭാര്യയെയും പുത്രന്മാരെയും കൂട്ടി കഴുതപ്പുറത്തു കയറ്റി മിസ്രയിംദേശത്തേക്കു മടങ്ങി; ദൈവത്തിന്റെ വടിയും മോശെ കയ്യിൽ എടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: നീ മിസ്രയീമിൽ ചെന്നെത്തുമ്പോൾ ഞാൻ നിന്നെ ഭരമേല്പിച്ചിട്ടുള്ള അത്ഭുതങ്ങളൊക്കെയും ഫറവോന്റെ മുമ്പാകെ ചെയ്‌വാൻ ഓർത്തുകൊൾക; എന്നാൽ അവൻ ജനത്തെ വിട്ടയക്കാതിരിപ്പാൻ ഞാൻ അവന്റെ ഹൃദയം കഠിനമാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","നീ ഫറവോനോടു: യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: യിസ്രായേൽ എന്റെ പുത്രൻ, എന്റെ ആദ്യജാതൻ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","എനിക്കു ശുശ്രൂഷ ചെയ്‌വാൻ എന്റെ പുത്രനെ വിട്ടയക്കേണമെന്നു ഞാൻ നിന്നോടു കല്പിക്കുന്നു; അവനെ വിട്ടയപ്പാൻ സമ്മതിക്കുന്നില്ലെങ്കിൽ ഞാൻ നിന്റെ പുത്രനെ, നിന്റെ ആദ്യജാതനെ തന്നേ കൊന്നുകളയും എന്നു പറക. ");
INSERT INTO mal2015_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","എന്നാൽ വഴിയിൽ സത്രത്തിൽവെച്ചു യഹോവ അവനെ എതിരിട്ടു കൊല്ലുവാൻ ഭാവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","അപ്പോൾ സിപ്പോരാ ഒരു കൽക്കത്തി എടുത്തു തന്റെ മകന്റെ അഗ്രചർമ്മം ഛേദിച്ചു അവന്റെ കാൽക്കൽ ഇട്ടു: നീ എനിക്കു രക്തമണവാളൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ഇങ്ങനെ അവൻ അവനെ വിട്ടൊഴിഞ്ഞു; ആ സമയത്താകുന്നു അവൾ പരിച്ഛേദന നിമിത്തം രക്തമണവാളൻ എന്നു പറഞ്ഞതു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","എന്നാൽ യഹോവ അഹരോനോടു: നീ മരുഭൂമിയിൽ മോശെയെ എതിരേല്പാൻ ചെല്ലുക എന്നു കല്പിച്ചു; അവൻ ചെന്നു ദൈവത്തിന്റെ പർവ്വതത്തിങ്കൽവെച്ചു അവനെ എതിരേറ്റു ചുംബിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","യഹോവ തന്നേ ഏല്പിച്ചയച്ച വചനങ്ങളൊക്കെയും തന്നോടു കല്പിച്ച അടയാളങ്ങളൊക്കെയും മോശെ അഹരോനെ അറിയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","പിന്നെ മോശെയും അഹരോനും പോയി, യിസ്രായേൽമക്കളുടെ മൂപ്പന്മാരെ ഒക്കെയും കൂട്ടിവരുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","യഹോവ മോശെയോടു കല്പിച്ച വചനങ്ങളെല്ലാം അഹരോൻ പറഞ്ഞു കേൾപ്പിച്ചു, ജനം കാൺകെ ആ അടയാളങ്ങളും പ്രവർത്തിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","അപ്പോൾ ജനം വിശ്വസിച്ചു; യഹോവ യിസ്രായേൽമക്കളെ സന്ദർശിച്ചു എന്നും തങ്ങളുടെ കഷ്ടത കടാക്ഷിച്ചു എന്നും കേട്ടിട്ടു അവർ കുമ്പിട്ടു നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","അതിന്റെശേഷം മോശെയും അഹരോനും ചെന്നു ഫറവോനോടു: മരുഭൂമിയിൽ എനിക്കു ഉത്സവം കഴിക്കേണ്ടതിന്നു എന്റെ ജനത്തെ വിട്ടയക്കേണം എന്നിപ്രകാരം യിസ്രായേലിന്റെ ദൈവമായ യഹോവ കല്പിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","അതിന്നു ഫറവോൻ: യിസ്രായേലിനെ വിട്ടയപ്പാൻ തക്കവണ്ണം ഞാൻ യഹോവയുടെ വാക്കു കേൾക്കേണ്ടതിന്നു അവൻ ആർ? ഞാൻ യഹോവയെ അറികയില്ല; ഞാൻ യിസ്രായേലിനെ വിട്ടയക്കയുമില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","അതിന്നു അവർ: എബ്രായരുടെ ദൈവം ഞങ്ങൾക്കു പ്രത്യക്ഷനായ്‌വന്നിരിക്കുന്നു; അവൻ മഹാമാരിയാലോ വാളാലോ ഞങ്ങളെ ദണ്ഡിപ്പിക്കാതിരിക്കേണ്ടതിന്നു ഞങ്ങൾ മൂന്നു ദിവസത്തെ വഴി മരുഭൂമിയിൽ പോയി, ഞങ്ങളുടെ ദൈവമായ യഹോവെക്കു യാഗം കഴിക്കട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","മിസ്രയീംരാജാവു അവരോടു: മോശേ, അഹരോനേ, നിങ്ങൾ ജനങ്ങളെ വേല മിനക്കെടുത്തുന്നതു എന്തു? നിങ്ങളുടെ ഊഴിയവേലെക്കു പോകുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ദേശത്തു ജനം ഇപ്പോൾ വളരെ ആകുന്നു; നിങ്ങൾ അവരെ അവരുടെ ഊഴിയവേല മിനക്കെടുത്തുന്നു എന്നും ഫറവോൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","അന്നു ഫറവോൻ ജനത്തിന്റെ ഊഴിയവിചാരകന്മാരോടും പ്രമാണികളോടും കല്പിച്ചതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","ഇഷ്ടിക ഉണ്ടാക്കുവാൻ ജനത്തിന്നു മുമ്പിലത്തെപ്പോലെ ഇനി വൈക്കോൽ കൊടുക്കരുതു; അവർ തന്നേ പോയി വൈക്കോൽ ശേഖരിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","എങ്കിലും ഇഷ്ടികയുടെ കണക്കു മുമ്പിലത്തെപ്പോലെ തന്നേ അവരുടെ മേൽ ചുമത്തേണം; ഒട്ടും കുറെക്കരുതു. അവർ മടിയന്മാർ; അതുകൊണ്ടാകുന്നു: ഞങ്ങൾ പോയി ഞങ്ങളുടെ ദൈവത്തിന്നു യാഗം കഴിക്കട്ടെ എന്നു നിലവിളിക്കുന്നതു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","അവരുടെ വേല അതിഭാരമായിരിക്കട്ടെ; അവർ അതിൽ കഷ്ടപ്പെടട്ടെ; ");
INSERT INTO mal2015_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","അവരുടെ വ്യാജവാക്കുകൾ കേൾക്കരുതു. അങ്ങനെ ജനത്തിന്റെ ഊഴിയവിചാരകന്മാരും പ്രമാണികളും ചെന്നു ജനത്തോടു: നിങ്ങൾക്കു വൈക്കോൽ തരികയില്ല; ");
INSERT INTO mal2015_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","നിങ്ങൾ തന്നേ പോയി കിട്ടുന്നേടത്തുനിന്നു വൈക്കോൽ ശേഖരിപ്പിൻ; എങ്കിലും നിങ്ങളുടെ വേലയിൽ ഒട്ടും കുറെക്കയില്ല എന്നു ഫറവോൻ കല്പിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","അങ്ങനെ ജനം വൈക്കോലിന്നു പകരം താളടി ശേഖരിപ്പാൻ മിസ്രയീംദേശത്തു എല്ലാടവും ചിതറി നടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ഊഴിയവിചാരകന്മാർ അവരെ ഹേമിച്ചു: വൈക്കോൽ കിട്ടിവന്നപ്പോൾ ഉള്ളതിന്നു ശരിയായി നിങ്ങളുടെ നിത്യവേല ദിവസവും തികെക്കേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ഫറവോന്റെ ഊഴിയവിചാരകന്മാർ യിസ്രായേൽ മക്കളുടെ മേൽ ആക്കിയിരുന്ന പ്രമാണികളെ അടിച്ചു: നിങ്ങൾ ഇന്നലെയും ഇന്നും മുമ്പിലത്തെപ്പോലെ ഇഷ്ടിക തികെക്കാഞ്ഞതു എന്തു എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","അതുകൊണ്ടു യിസ്രായേൽമക്കളുടെ പ്രമാണികൾ ചെന്നു ഫറവോനോടു നിലവിളിച്ചു; അടിയങ്ങളോടു ഇങ്ങനെ ചെയ്യുന്നതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","അടിയങ്ങൾക്കു വൈക്കോൽ തരാതെ ഇഷ്ടിക ഉണ്ടാക്കുവിൻ എന്നു അവർ പറയുന്നു; അടിയങ്ങളെ തല്ലുന്നു; അതു നിന്റെ ജനത്തിന്നു പാപമാകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","അതിന്നു അവൻ: മടിയന്മാരാകുന്നു നിങ്ങൾ, മടിയന്മാർ; അതുകൊണ്ടു: ഞങ്ങൾ പോയി യഹോവെക്കു യാഗം കഴിക്കട്ടെ എന്നു നിങ്ങൾ പറയുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","പോയി വേല ചെയ്‌വിൻ; വൈക്കോൽ തരികയില്ല, ഇഷ്ടിക കണക്കുപോലെ ഏല്പിക്കേണം താനും എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ദിവസംതോറുമുള്ള ഇഷ്ടികക്കണക്കിൽ ഒന്നും കുറെക്കരുതു എന്നു കല്പിച്ചപ്പോൾ തങ്ങൾ വിഷമത്തിലായി എന്നു യിസ്രായേൽമക്കളുടെ പ്രമാണികൾ കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","അവർ ഫറവോനെ വിട്ടു പുറപ്പെടുമ്പോൾ മോശെയും അഹരോനും വഴിയിൽ നില്ക്കുന്നതു കണ്ടു, ");
INSERT INTO mal2015_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","അവരോടു: നിങ്ങൾ ഫറവോന്റെയും അവന്റെ ഭൃത്യന്മാരുടെയും മുമ്പാകെ ഞങ്ങളെ നാറ്റി, ഞങ്ങളെ കൊല്ലുവാൻ അവരുടെ കയ്യിൽ വാൾ കൊടുത്തതുകൊണ്ടു യഹോവ നിങ്ങളെ നോക്കി ന്യായം വിധിക്കട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","അപ്പോൾ മോശെ യഹോവയുടെ അടുക്കൽ ചെന്നു: കർത്താവേ, നീ ഈ ജനത്തിന്നു ദോഷം വരുത്തിയതു എന്തു? നീ എന്നെ അയച്ചതു എന്തിന്നു? ");
INSERT INTO mal2015_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ഞാൻ നിന്റെ നാമത്തിൽ സംസാരിപ്പാൻ ഫറവോന്റെ അടുക്കൽ ചെന്നതു മുതൽ അവൻ ഈ ജനത്തോടു ദോഷം ചെയ്തിരിക്കുന്നു; നിന്റെ ജനത്തെ നീ വിടുവിച്ചതുമില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","യഹോവ മോശെയോടു: ഞാൻ ഫറവോനോടു ചെയ്യുന്നതു നീ ഇപ്പോൾ കാണും: ശക്തിയുള്ള കൈ കണ്ടിട്ടു അവൻ അവരെ വിട്ടയക്കും; ശക്തിയുള്ള കൈ കണ്ടിട്ടു അവരെ തന്റെ ദേശത്തുനിന്നു ഓടിച്ചുകളയും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ദൈവം പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതെന്തെന്നാൽ: ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ഞാൻ അബ്രാഹാമിന്നും യിസ്ഹാക്കിന്നും യാക്കോബിന്നും സർവ്വശക്തിയുള്ള ദൈവമായിട്ടു പ്രത്യക്ഷനായി; എന്നാൽ യഹോവ എന്ന നാമത്താൽ ഞാൻ അവർക്കു വെളിപ്പെട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","അവർ പരദേശികളായി പാർത്ത കനാൻദേശം അവർക്കു കൊടുക്കുമെന്നു ഞാൻ അവരോടു ഒരു നിയമം ചെയ്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","മിസ്രയീമ്യർ അടിമകളാക്കിയിരിക്കുന്ന യിസ്രായേൽമക്കളുടെ ഞരക്കം ഞാൻ കേട്ടു എന്റെ നിയമം ഓർത്തുമിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","അതുകൊണ്ടു നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ഞാൻ യഹോവ ആകുന്നു; ഞാൻ നിങ്ങളെ മിസ്രയീമ്യരുടെ ഊഴിയവേലയിൽനിന്നു ഉദ്ധരിച്ചു അവരുടെ അടിമയിൽനിന്നു നിങ്ങളെ വിടുവിക്കും; നീട്ടിയിരിക്കുന്ന ഭുജംകൊണ്ടും മഹാശിക്ഷാവിധികൾകൊണ്ടും നിങ്ങളെ വീണ്ടെടുക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ഞാൻ നിങ്ങളെ എനിക്കു ജനമാക്കിക്കൊൾകയും ഞാൻ നിങ്ങൾക്കു ദൈവമായിരിക്കയും ചെയ്യും. മിസ്രയീമ്യരുടെ ഊഴിയവേലയിൽനിന്നു നിങ്ങളെ ഉദ്ധരിക്കുന്ന നിങ്ങളുടെ ദൈവമായ യഹോവ ഞാൻ ആകുന്നു എന്നു നിങ്ങൾ അറിയും. ");
INSERT INTO mal2015_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ഞാൻ അബ്രാഹാമിന്നും യിസ്ഹാക്കിന്നും യാക്കോബിന്നും നല്കുമെന്നു സത്യം ചെയ്ത ദേശത്തേക്കു നിങ്ങളെ കൊണ്ടുപോയി, അതു നിങ്ങൾക്കു അവകാശമായി തരും. ");
INSERT INTO mal2015_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ഞാൻ യഹോവ ആകുന്നു. മോശെ ഇങ്ങനെ തന്നേ യിസ്രായേൽമക്കളോടു പറഞ്ഞു; എന്നാൽ അവർ മനോവ്യസനംകൊണ്ടും കഠിനമായ അടിമവേലകൊണ്ടും മോശെയുടെ വാക്കു കേട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","നീ ചെന്നു മിസ്രയീംരാജാവായ ഫറവോനോടു യിസ്രായേൽമക്കളെ തന്റെ ദേശത്തുനിന്നു വിട്ടയപ്പാൻ പറക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","അതിന്നു മോശെ: യിസ്രായേൽമക്കൾ എന്റെ വാക്കു കേട്ടില്ല; പിന്നെ ഫറവോൻ എങ്ങനെ കേൾക്കും? ഞാൻ വാഗ്വൈഭവമുള്ളവനല്ലല്ലോ എന്നു യഹോവയുടെ സന്നിധിയിൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","അനന്തരം യഹോവ മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തു, യിസ്രായേൽമക്കളെ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെടുവിക്കേണ്ടതിന്നു അവരെ യിസ്രായേൽമക്കളുടെ അടുക്കലേക്കും മിസ്രയീംരാജാവായ ഫറവോന്റെ അടുക്കലേക്കും നിയോഗിച്ചയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","അവരുടെ കുടുംബത്തലവന്മാർ ആരെന്നാൽ: യിസ്രായേലിന്റെ ആദ്യജാതനായ രൂബേന്റെ പുത്രന്മാർ: ഹനോക്, ഫല്ലൂ, ഹെസ്രോൻ, കർമ്മി; ഇവ രൂബേന്റെ കുലങ്ങൾ. ");
INSERT INTO mal2015_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ശിമെയോന്റെ പുത്രന്മാർ: യെമൂവേൽ, യാമീൻ, ഓഹദ്, യാഖീൻ, സോഹർ, കനാന്യസ്ത്രീയുടെ മകനായ ശൗൽ; ഇവ ശിമെയോന്റെ കുലങ്ങൾ. ");
INSERT INTO mal2015_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","വംശപാരമ്പര്യപ്രകാരം ലേവിയുടെ പുത്രന്മാരുടെ പേരുകൾ ഇവ: ഗേർശോൻ, കഹാത്ത്, മെരാരി; ലേവിയുടെ ആയുഷ്കാലം നൂറ്റിമുപ്പത്തേഴു സംവത്സരം ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ഗേർശോന്റെ പുത്രന്മാർ: കുടുംബസഹിതം ലിബ്നിയും ശിമെയിയും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","കഹാത്തിന്റെ പുത്രന്മാർ: അമ്രാം, യിസ്ഹാർ, ഹെബ്രോൻ, ഉസ്സീയേൽ; കഹാത്തിന്റെ ആയുഷ്കാലം നൂറ്റി മുപ്പത്തുമൂന്നു സംവത്സരം. ");
INSERT INTO mal2015_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","മെരാരിയുടെ പുത്രന്മാർ; മഹ്ലി, മൂശി. ഇവർ വംശപാരമ്പര്യപ്രകാരം ലേവിയുടെ കുലങ്ങൾ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","അമ്രാം തന്റെ പിതാവിന്റെ സഹോദരിയായ യോഖേബെദിനെ വിവാഹം കഴിച്ചു; അവൾ അവന്നു അഹരോനെയും മോശെയെയും പ്രസവിച്ചു: അമ്രാമിന്റെ ആയുഷ്കാലം നൂറ്റി മുപ്പത്തേഴു സംവത്സരം ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","യിസ്ഹാരിന്റെ പുത്രന്മാർ: കോരഹ്, നേഫെഗ്, സിക്രി. ");
INSERT INTO mal2015_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ഉസ്സീയേലിന്റെ പുത്രന്മാർ: മീശായേൽ, എൽസാഫാൻ, സിത്രി. ");
INSERT INTO mal2015_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","അഹരോൻ അമ്മീനാദാബിന്റെ മകളും നഹശോന്റെ സഹോദരിയുമായ എലീശേബയെ ഭാര്യയായി പരിഗ്രഹിച്ചു; അവൾ അവന്നു നാദാബ്, അബീഹൂ, എലെയാസാർ, ഈഥാമാർ എന്നിവരെ പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","കോരഹിന്റെ പുത്രന്മാർ: അസ്സൂർ, എൽക്കാനാ അബിയാസാഫ്. ഇവ കോരഹ്യകുലങ്ങൾ. ");
INSERT INTO mal2015_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","അഹരോന്റെ മകനായ എലെയാസാർ ഫൂതീയേലിന്റെ പുത്രിമാരിൽ ഒരുത്തിയെ വിവാഹം കഴിച്ചു. അവൾ അവന്നു ഫീനെഹാസിനെ പ്രസവിച്ചു; ഇവർ കുലം കുലമായി ലേവ്യകുടുംബത്തലവന്മാർ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","നിങ്ങൾ യിസ്രായേൽമക്കളെ ഗണം ഗണമായി മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെടുവിപ്പിൻ എന്നു യഹോവ കല്പിച്ച അഹരോനും മോശെയും ഇവർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","യിസ്രായേൽമക്കളെ മിസ്രയീമിൽനിന്നു പുറപ്പെടുവിപ്പാൻ മിസ്രയീംരാജാവായ ഫറവോനോടു സംസാരിച്ചവർ ഈ മോശെയും അഹരോനും തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","യഹോവ മിസ്രയീംദേശത്തുവെച്ചു മോശെയോടു അരുളിച്ചെയ്ത നാളിൽ: ഞാൻ യഹോവ ആകുന്നു; ");
INSERT INTO mal2015_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ഞാൻ നിന്നോടു കല്പിക്കുന്നതൊക്കെയും നീ മിസ്രയീംരാജാവായ ഫറവോനോടു പറയേണം എന്നു യഹോവ മോശെയോടു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","അതിന്നു മോശെ: ഞാൻ വാഗ്വൈവഭവമില്ലാത്തവൻ; ഫറവോൻ എന്റെ വാക്കു എങ്ങനെ കേൾക്കും എന്നു യഹോവയുടെ സന്നിധിയിൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: നോക്കു, ഞാൻ നിന്നെ ഫറവോന്നു ദൈവമാക്കിയിരിക്കുന്നു; നിന്റെ സഹോദരൻ അഹരോൻ നിനക്കു പ്രവാചകനായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ഞാൻ നിന്നോടു കല്പിക്കുന്നതൊക്കെയും നീ പറയേണം; നിന്റെ സഹോദരനായ അഹരോൻ യിസ്രായേൽമക്കളെ തന്റെ ദേശത്തുനിന്നു വിട്ടയപ്പാൻ ഫറവോനോടു പറയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","എന്നാൽ ഞാൻ ഫറവോന്റെ ഹൃദയം കഠിനമാക്കും; മിസ്രയീംദേശത്തു എന്റെ അടയാളങ്ങളും അത്ഭുതങ്ങളും പെരുക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ഫറവോൻ നിങ്ങളുടെ വാക്കു കേൾക്കയില്ല; ഞാൻ മിസ്രയീമിന്മേൽ എന്റെ കൈവെച്ചു വലിയ ശിക്ഷാവിധികളാൽ എന്റെ ഗണങ്ങളെ, എന്റെ ജനമായ യിസ്രായേൽമക്കളെ തന്നേ, മിസ്രയിംദേശത്തുനിന്നു പുറപ്പെടുവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","അങ്ങനെ ഞാൻ എന്റെ കൈ മിസ്രയീമിന്മേൽ നീട്ടി, യിസ്രായേൽമക്കളെ അവരുടെ ഇടയിൽനിന്നു പുറപ്പെടുവിക്കുമ്പോൾ ഞാൻ യഹോവ എന്നു മിസ്രയീമ്യർ അറിയും. ");
INSERT INTO mal2015_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","മോശെയും അഹരോനും യഹോവ തങ്ങളോടു കല്പിച്ചതുപോലെ ചെയ്തു. അവർ അങ്ങനെ തന്നേ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","അവർ ഫറവോനോടു സംസാരിച്ച കാലത്തു മോശെക്കു എൺപതു വയസ്സും അഹരോന്നു എൺപത്തുമൂന്നു വയസ്സും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","യഹോവ മോശെയോടും അഹരോനോടും: ");
INSERT INTO mal2015_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","ഫറവോൻ നിങ്ങളോടു ഒരു അത്ഭുതം കാണിപ്പിൻ എന്നു പറഞ്ഞാൽ നീ അഹരോനോടു: നിന്റെ വടി എടുത്തു ഫറവോന്റെ മുമ്പാകെ നിലത്തിടുക എന്നു പറയേണം; അതു ഒരു സർപ്പമായ്തീരും എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","അങ്ങനെ മോശെയും അഹരോനും ഫറവോന്റെ അടുക്കൽ ചെന്നു യഹോവ തങ്ങളോടു കല്പിച്ചതു പോലെ ചെയ്തു. അഹരോൻ തന്റെ വടി ഫറവോന്റെയും അവന്റെ ഭൃത്യന്മാരുടെയും മുമ്പാകെ നിലത്തിട്ടു; അതു സർപ്പമായ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","അപ്പോൾ ഫറവോൻ വിദ്വാന്മാരെയും ക്ഷുദ്രക്കാരെയും വിളിപ്പിച്ചു; മിസ്രയീമ്യമന്ത്രവാദികളായ ഇവരും തങ്ങളുടെ മന്ത്രവാദത്താൽ അതുപോലെ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","അവർ ഓരോരുത്തൻ താന്താന്റെ വടി നിലത്തിട്ടു; അവയും സർപ്പങ്ങളായ്തീർന്നു; എന്നാൽ അഹരോന്റെ വടി അവരുടെ വടികളെ വിഴുങ്ങിക്കളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ഫറവോന്റെ ഹൃദയമോ, യഹോവ അരുളിച്ചെയ്തതുപോലെ കഠിനപ്പെട്ടു; അവൻ അവരെ ശ്രദ്ധിച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","അപ്പോൾ യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ഫറവോന്റെ ഹൃദയം കഠിനപ്പെട്ടിരിക്കുന്നു; ജനത്തെ വിട്ടയപ്പാൻ അവന്നു മനസ്സില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","രാവിലെ നീ ഫറവോന്റെ അടുക്കൽ ചെല്ലുക; അവൻ വെള്ളത്തിന്റെ അടുക്കൽ ഇറങ്ങിവരും; നീ അവനെ കാണ്മാൻ നദീതീരത്തു നിൽക്കേണം; സർപ്പമായ്തീർന്ന വടിയും കയ്യിൽ എടുത്തുകൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","അവനോടു പറയേണ്ടതു എന്തെന്നാൽ: മരുഭൂമിയിൽ എന്നെ ആരാധിപ്പാൻ എന്റെ ജനത്തെ വിട്ടയക്ക എന്നു കല്പിച്ചു എബ്രായരുടെ ദൈവമായ യഹോവ എന്നെ നിന്റെ അടുക്കൽ അയച്ചു; നീയോ ഇതുവരെ കേട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ഞാൻ യഹോവ എന്നു നീ ഇതിനാൽ അറിയും എന്നിങ്ങനെ യഹോവ കല്പിക്കുന്നു; ഇതാ, എന്റെ കയ്യിലുള്ള വടികൊണ്ടു ഞാൻ നദിയിലെ വെള്ളത്തിൽ അടിക്കും; അതു രക്തമായ്തീരും; ");
INSERT INTO mal2015_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","നദിയിലെ മത്സ്യം ചാകും. നദി നാറും; നദിയിലെ വെള്ളം കുടിപ്പാൻ മിസ്രയീമ്യർക്കു അറെപ്പു തോന്നും. ");
INSERT INTO mal2015_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","യഹോവ പിന്നെയും മോശെയോടു: നീ അഹരോനോടു പറയേണ്ടതു എന്തെന്നാൽ: നിന്റെ വടി എടുത്തിട്ടു മിസ്രയീമിലെ വെള്ളത്തിന്മേൽ, അവരുടെ നദി, പുഴ, കുളം എന്നിങ്ങനെ അവരുടെ സകലജലാശയങ്ങളുടെ മേലും കൈ നീട്ടുക; അവ രക്തമായ്തീരും; മിസ്രയീംദേശത്തു എല്ലാടവും മരപ്പാത്രങ്ങളിലും കല്പാത്രങ്ങളിലും രക്തം ഉണ്ടാകും എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","മോശെയും അഹരോനും യഹോവ കല്പിച്ചതുപോലെ ചെയ്തു. അവൻ ഫറവോന്റെയും അവന്റെ ഭൃത്യന്മാരുടെയും മുമ്പാകെ വടി ഓങ്ങി നദിയിലുള്ള വെള്ളത്തിൽ അടിച്ചു; നദിയിലുള്ള വെള്ളം ഒക്കെയും രക്തമായ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","നദിയിലെ മത്സ്യം ചാകയും നദി നാറുകയും ചെയ്തു. നദിയിലെ വെള്ളം കുടിപ്പാൻ മിസ്രയീമ്യർക്കു കഴിഞ്ഞില്ല; മിസ്രയീംദേശത്തു എല്ലാടവും രക്തം ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","മിസ്രയീമ്യമന്ത്രവാദികളും തങ്ങളുടെ മന്ത്രവാദത്താൽ അതുപോലെ ചെയ്തു; എന്നാൽ യഹോവ അരുളിച്ചെയ്തിരുന്നതുപോലെ ഫറവോന്റെ ഹൃദയം കഠിനപ്പെട്ടു; അവൻ അവരെ ശ്രദ്ധിച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ഫറവോൻ തിരിഞ്ഞു തന്റെ അരമനയിലേക്കു പോയി; ഇതും അവൻ ഗണ്യമാക്കിയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","നദിയിലെ വെള്ളം കുടിപ്പാൻ കഴിവില്ലായ്കകൊണ്ടു മിസ്രയീമ്യർ എല്ലാവരും കുടിപ്പാൻ വെള്ളത്തിന്നായി നദിയരികെ ഒക്കെയും ഓലി കുഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","യഹോവ നദിയെ അടിച്ചിട്ടു ഏഴു ദിവസം കഴിഞ്ഞപ്പോൾ മോശെയോടു കല്പിച്ചതു: നീ ഫറവോന്റെ അടുക്കൽ ചെന്നു പറയേണ്ടതു എന്തെന്നാൽ: യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: എന്നെ ആരാധിപ്പാൻ എന്റെ ജനത്തെ വിട്ടയക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","നീ അവരെ വിട്ടയപ്പാൻ സമ്മതിക്കയില്ലെങ്കിൽ ഞാൻ നിന്റെ രാജ്യത്തെ ഒക്കെയും തവളയെക്കൊണ്ടു ബാധിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","നദിയിൽ തവള അനവധിയായി ജനിക്കും; അതു കയറി നിന്റെ അരമനയിലും ശയനഗൃഹത്തിലും കട്ടിലിന്മേലും നിന്റെ ഭൃത്യന്മാരുടെ വീടുകളിലും നിന്റെ ജനത്തിന്മേലും അപ്പം ചുടുന്ന അടുപ്പുകളിലും മാവു കുഴെക്കുന്ന തൊട്ടികളിലും വരും. ");
INSERT INTO mal2015_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","തവള നിന്റെ മേലും നിന്റെ ജനത്തിന്മേലും നിന്റെ സകലഭൃത്യന്മാരുടെ മേലും കയറും. ");
INSERT INTO mal2015_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","യഹോവ പിന്നെയും മോശെയോടു: മിസ്രയീംദേശത്തു തവള കയറുവാൻ നദികളിൻമേലും പുഴകളിൻമേലും കുളങ്ങളിൻമേലും വടിയോടുകൂടെ കൈ നീട്ടുക എന്നു നീ അഹരോനോടു പറയേണം എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","അങ്ങനെ അഹരോൻ മിസ്രയീമിലെ വെള്ളങ്ങളിൻമേൽ കൈ നീട്ടി, തവള കയറി മിസ്രയീംദേശത്തെ മൂടി. ");
INSERT INTO mal2015_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","മന്ത്രവാദികളും തങ്ങളുടെ മന്ത്രവാദത്താൽ അതുപോലെ ചെയ്തു, മിസ്രയീംദേശത്തു തവള കയറുമാറാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","എന്നാറെ ഫറവോൻ മോശെയെയും അഹരോനെയും വിളിപ്പിച്ചു: തവള എന്നെയും എന്റെ ജനത്തെയും വിട്ടു നീങ്ങുമാറാകേണ്ടതിന്നു യഹോവയോടു പ്രാർത്ഥിപ്പിൻ. എന്നാൽ യഹോവെക്കു യാഗം കഴിപ്പാൻ ഞാൻ ജനത്തെ വിട്ടയക്കാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","മോശെ ഫറവോനോടു: തവള നിന്നെയും നിന്റെ ഗൃഹങ്ങളെയും വിട്ടു നീങ്ങി നദിയിൽ മാത്രം ഇരിക്കേണ്ടതിന്നു ഞാൻ നിനക്കും നിന്റെ ഭൃത്യന്മാർക്കും നിന്റെ ജനത്തിനും വേണ്ടി എപ്പോൾ പ്രാർത്ഥിക്കേണം എന്നു എനിക്കു സമയം നിശ്ചയിച്ചാലും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","നാളെ എന്നു അവൻ പറഞ്ഞു; ഞങ്ങളുടെ ദൈവമായ യഹോവയെപ്പോലെ ആരുമില്ല എന്നു നീ അറിയേണ്ടതിന്നു നിന്റെ വാക്കുപോലെ ആകട്ടെ; ");
INSERT INTO mal2015_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","തവള നിന്നെയും നിന്റെ ഗൃഹങ്ങളെയും നിന്റെ ഭൃത്യന്മാരെയും ജനത്തെയും വിട്ടു മാറി നദിയിൽ മാത്രം ഇരിക്കും എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","അങ്ങനെ മോശെയും അഹരോനും ഫറവോന്റെ അടുക്കൽനിന്നു ഇറങ്ങി ഫറവോന്റെ മേൽ വരുത്തിയ തവള നിമിത്തം മോശെ യഹോവയോടു പ്രാർത്ഥിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","മോശെയുടെ പ്രാർത്ഥനപ്രകാരം യഹോവ ചെയ്തു; ഗൃഹങ്ങളിലും മുറ്റങ്ങളിലും പറമ്പുകളിലും ഉള്ള തവള ചത്തുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","അവർ അതിനെ കൂമ്പാരംകൂമ്പാരമായി കൂട്ടി; ദേശം നാറുകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","എന്നാൽ സ്വൈരം വന്നു എന്നു ഫറവോൻ കണ്ടാറെ യഹോവ അരുളിച്ചെയ്തിരുന്നതുപോലെ അവൻ തന്റെ ഹൃദയത്തെ കഠിനമാക്കി അവരെ ശ്രദ്ധിച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","അപ്പോൾ യഹോവ മോശെയോടു: നിന്റെ വടി നീട്ടി നിലത്തിലെ പൊടിയെ അടിക്ക എന്നു അഹരോനോടു പറക. അതു മിസ്രയീംദേശത്തു എല്ലാടവും പേൻ ആയ്തീരും എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","അവർ അങ്ങനെ ചെയ്തു; അഹരോൻ വടിയോടുകൂടെ കൈ നീട്ടി നിലത്തിലെ പൊടിയെ അടിച്ചു; അതു മനുഷ്യരുടെ മേലും മൃഗങ്ങളിൻമേലും പേൻ ആയ്തീർന്നു; മിസ്രയീംദേശത്തെങ്ങും നിലത്തിലെ പൊടിയെല്ലാം പേൻ ആയ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","മന്ത്രവാദികളും തങ്ങളുടെ മന്ത്രവാദത്താൽ പേൻ ഉളവാക്കുവാൻ അതുപോലെ ചെയ്തു; അവർക്കു കഴിഞ്ഞില്ല താനും. മനുഷ്യരുടെയും മൃഗങ്ങളുടെയും മേൽ പേൻ ഉളവായതുകൊണ്ടു മന്ത്രവാദികൾ ഫറവോനോടു: ");
INSERT INTO mal2015_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ഇതു ദൈവത്തിന്റെ വിരൽ ആകുന്നു എന്നു പറഞ്ഞു; എന്നാൽ യഹോവ അരുളിച്ചെയ്തിരുന്നതുപോലെ ഫറവോന്റെ ഹൃദയം കഠിനപ്പെട്ടു അവൻ അവരെ ശ്രദ്ധിച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","പിന്നെ യഹോവ മോശെയോടു കല്പിച്ചതു: നീ നാളെ നന്ന രാവിലെ എഴുന്നേറ്റു ഫറവോന്റെ മുമ്പാകെ നിൽക്ക; അവൻ വെള്ളത്തിന്റെ അടുക്കൽ വരും. നീ അവനോടു പറയേണ്ടതു എന്തെന്നാൽ: യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: എന്നെ ആരാധിപ്പാൻ എന്റെ ജനത്തെ വിട്ടയക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","നീ എന്റെ ജനത്തെ വിട്ടയക്കയില്ല എങ്കിൽ ഞാൻ നിന്റെമേലും നിന്റെ ഭൃത്യന്മാരുടെമേലും നിന്റെ ജനത്തിൻമേലും നിന്റെ ഗൃഹങ്ങളിലും നായീച്ചയെ അയക്കും. മിസ്രയീമ്യരുടെ വീടുകളും അവർ പാർക്കുന്ന ദേശവും നായീച്ചകൊണ്ടു നിറയും. ");
INSERT INTO mal2015_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ഭൂമിയിൽ ഞാൻ തന്നേ യഹോവ എന്നു നീ അറിയേണ്ടതിന്നു എന്റെ ജനം പാർക്കുന്ന ഗോശെൻദേശത്തെ അന്നു ഞാൻ നായീച്ച വരാതെ വേർതിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","എന്റെ ജനത്തിന്നും നിന്റെ ജനത്തിന്നും മദ്ധ്യേ ഞാൻ ഒരു വ്യത്യാസം വെക്കും; നാളെ ഈ അടയാളം ഉണ്ടാകും. ");
INSERT INTO mal2015_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","യഹോവ അങ്ങനെ തന്നേ ചെയ്തു: അനവധി നായീച്ച ഫറവോന്റെ അരമനയിലും അവന്റെ ഭൃത്യന്മാരുടെ വീടുകളിലും മിസ്രയീംദേശത്തു എല്ലാടവും വന്നു; നായീച്ചയാൽ ദേശം നശിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","അപ്പോൾ ഫറവോൻ മോശെയെയും അഹരോനെയും വിളിച്ചു: നിങ്ങൾ പോയി ദേശത്തുവെച്ചു തന്നേ നിങ്ങളുടെ ദൈവത്തിന്നു യാഗം കഴിപ്പിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","അതിന്നു മോശെ: അങ്ങനെ ചെയ്തുകൂടാ; മിസ്രയീമ്യർക്കു അറെപ്പായുള്ളതു ഞങ്ങളുടെ ദൈവമായ യഹോവെക്കു യാഗംകഴിക്കേണ്ടിവരുമല്ലോ; മിസ്രയീമ്യർക്കു അറെപ്പായുള്ളതു അവർ കാൺകെ ഞങ്ങൾ യാഗം കഴിച്ചാൽ അവർ ഞങ്ങളെ കല്ലെറികയില്ലയോ? ");
INSERT INTO mal2015_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ഞങ്ങളുടെ ദൈവമായ യഹോവ ഞങ്ങളോടു കല്പിച്ചതുപോലെ ഞങ്ങൾ മൂന്നു ദിവസത്തെ വഴി ദൂരം മരുഭൂമിയിൽ പോയി അവന്നു യാഗം കഴിക്കേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","അപ്പോൾ ഫറവോൻ: നിങ്ങളുടെ ദൈവമായ യഹോവെക്കു മരുഭൂമിയിൽവെച്ചു യാഗംകഴിക്കേണ്ടതിന്നു നിങ്ങളെ വിട്ടയക്കാം; അതിദൂരത്തു മാത്രം പോകരുതു; എനിക്കു വേണ്ടി പ്രാർത്ഥിപ്പിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","അതിന്നു മോശെ: ഞാൻ നിന്റെ അടുക്കൽ നിന്നു പുറപ്പെട്ടു യഹോവയോടു പ്രാർത്ഥിക്കും; നാളെ നായീച്ച ഫറവോനെയും ഭൃത്യന്മാരെയും ജനത്തെയും വിട്ടു നീങ്ങിപ്പോകും. എങ്കിലും യഹോവെക്കു യാഗം കഴിപ്പാൻ ജനത്തെ വിട്ടയക്കാതിരിക്കുന്നതിനാൽ ഫറവോൻ ഇനി ചതിവു ചെയ്യരുതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","അങ്ങനെ മോശെ ഫറവോന്റെ അടുക്കൽനിന്നു പുറപ്പെട്ടു യഹോവയോടു പ്രാർത്ഥിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","യഹോവ മോശെയുടെ പ്രാർത്ഥനപ്രകാരം ചെയ്തു: നായീച്ച ഒന്നുപോലും ശേഷിക്കാതെ ഫറവോനെയും ഭൃത്യന്മാരെയും ജനത്തെയും വിട്ടു നീങ്ങിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","എന്നാൽ ഫറവോൻ ഈ പ്രാവശ്യവും തന്റെ ഹൃദയം കഠിനമാക്കി; ജനത്തെ വിട്ടയച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു: നീ ഫറവോന്റെ അടുക്കൽ ചെന്നു അവനോടു പറയേണ്ടതു എന്തെന്നാൽ: എബ്രായരുടെ ദൈവമായ യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: എന്നെ ആരാധിപ്പാൻ എന്റെ ജനത്തെ വിട്ടയക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","വിട്ടയപ്പാൻ സമ്മതിക്കാതെ ഇനിയും അവരെ തടഞ്ഞു നിർത്തിയാൽ, ");
INSERT INTO mal2015_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","യഹോവയുടെ കൈ കുതിര, കഴുത, ഒട്ടകം, കന്നുകാലി, ആടു എന്നിങ്ങനെ വയലിൽ നിനക്കുള്ള മൃഗങ്ങളിന്മേൽ വരും; അതികഠിനമായ വ്യാധിയുണ്ടാകും. ");
INSERT INTO mal2015_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","യഹോവ യിസ്രായേല്യരുടെ മൃഗങ്ങൾക്കും മിസ്രയീമ്യരുടെ മൃഗങ്ങൾക്കും തമ്മിൽ വ്യത്യാസം വെക്കും; യിസ്രായേൽമക്കൾക്കുള്ള സകലത്തിലും ഒന്നും ചാകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","നാളെ യഹോവ ഈ കാര്യം ദേശത്തു ചെയ്യുമെന്നു കല്പിച്ചു സമയം കുറിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","അങ്ങനെ പിറ്റേദിവസം യഹോവ ഈ കാര്യം ചെയ്തു: മിസ്രയീമ്യരുടെ മൃഗങ്ങൾ എല്ലാം ചത്തു; യിസ്രായേൽമക്കളുടെ മൃഗങ്ങളോ ഒന്നുപോലും ചത്തില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ഫറവോൻ ആളയച്ചു; യിസ്രായേല്യരുടെ മൃഗങ്ങൾ ഒന്നുപോലും ചത്തില്ല എന്നു കണ്ടു എങ്കിലും ഫറവോന്റെ ഹൃദയം കഠിനപ്പെട്ടു അവൻ ജനത്തെ വിട്ടയച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","പിന്നെ യഹോവ മോശെയോടും അഹരോനോടും: അടുപ്പിലെ വെണ്ണീർ കൈനിറച്ചു വാരുവിൻ; മോശെ അതു ഫറവോന്റെ മുമ്പാകെ ആകാശത്തേക്കു വിതറട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","അതു മിസ്രയീംദേശത്തു എല്ലാടവും ധൂളിയായി പാറി മിസ്രയീംദേശത്തൊക്കെയും മനുഷ്യരുടെ മേലും മൃഗങ്ങളിൻമേലും പുണ്ണായി പൊങ്ങുന്ന പരുവാകും എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","അങ്ങനെ അവർ അടുപ്പിലെ വെണ്ണീർ വാരി ഫറവോന്റെ മുമ്പാകെ നിന്നു. മോശെ അതു ആകാശത്തേക്കു വിതറിയപ്പോൾ അതു മനുഷ്യരുടെ മേലും മൃഗങ്ങളിൻ മേലും പുണ്ണായി പൊങ്ങുന്ന പരുവായ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","പരുനിമിത്തം മന്ത്രവാദികൾക്കു മോശെയുടെ മുമ്പാകെ നില്പാൻ കഴിഞ്ഞില്ല; പരു മന്ത്രവാദികൾക്കും എല്ലാമിസ്രയീമ്യർക്കും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","എന്നാൽ യഹോവ മോശെയോടു അരുളിച്ചെയ്തിരുന്നതുപോലെ അവൻ ഫറവോന്റെ ഹൃദയത്തെ കഠിനമാക്കി; അവൻ അവരെ ശ്രദ്ധിച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","അപ്പോൾ യഹോവ മോശെയോടു കല്പിച്ചതു: നീ നന്ന രാവിലെ എഴുന്നേറ്റു, ഫറവോന്റെ മുമ്പാകെ നിന്നു അവനോടു പറയേണ്ടതു എന്തെന്നാൽ: എബ്രായരുടെ ദൈവമായ യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: എന്നെ ആരാധിപ്പാൻ എന്റെ ജനത്തെ വിട്ടയക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","സർവ്വഭൂമിയിലും എന്നെപ്പോലെ മറ്റൊരുത്തനുമില്ല എന്നു നീ അറിയേണ്ടതിന്നു ഈ പ്രാവശ്യം ഞാൻ എന്റെ ബാധകളൊക്കെയും നിന്റെ മേലും നിന്റെ ഭൃത്യന്മാരുടെ മേലും നിന്റെ ജനത്തിന്മേലും അയക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ഇപ്പോൾ തന്നേ ഞാൻ എന്റെ കൈ നീട്ടി നിന്നെയും നിന്റെ ജനത്തെയും മഹാമാരിയാൽ ദണ്ഡിപ്പിച്ചു നിന്നെ ഭൂമിയിൽ നിന്നു ഛേദിച്ചുകളയുമായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","എങ്കിലും എന്റെ ശക്തി നിന്നെ കാണിക്കേണ്ടതിന്നും എന്റെ നാമം സർവ്വഭൂമിയിലും പ്രസ്താവിക്കപ്പെടേണ്ടതിന്നും ഞാൻ നിന്നെ നിർത്തിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","എന്റെ ജനത്തെ അയക്കാതിരിപ്പാൻ തക്കവണ്ണം നീ ഇനിയും അവരെ തടഞ്ഞു നിർത്തുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","മിസ്രയീം സ്ഥാപിതമായ നാൾമുതൽ ഇന്നുവരെ അതിൽ ഉണ്ടായിട്ടില്ലാത്ത അതികഠിനമായ കല്മഴ ഞാൻ നാളെ ഈ നേരത്തു പെയ്യിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","അതുകൊണ്ടു ഇപ്പോൾ ആളയച്ചു നിന്റെ മൃഗങ്ങളെയും വയലിൽ നിനക്കുള്ള സകലത്തെയും അകത്തു വരുത്തിക്കൊൾക. വീട്ടിൽ വരുത്താതെ വയലിൽ കാണുന്ന സകലമനുഷ്യന്റെയും മൃഗത്തിന്റെയും മേൽ കല്മഴ പെയ്യുകയും എല്ലാം ചാകയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ഫറവോന്റെ ഭൃത്യന്മാരിൽ യഹോവയുടെ വചനത്തെ ഭയപ്പെട്ടവർ ദാസന്മാരെയും മൃഗങ്ങളെയും വീടുകളിൽ വരുത്തി രക്ഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","എന്നാൽ യഹോവയുടെ വചനത്തെ പ്രമാണിക്കാതിരുന്നവർ ദാസന്മാരെയും മൃഗങ്ങളെയും വയലിൽ തന്നേ വിട്ടേച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","പിന്നെ യഹോവ മോശെയോടു: മിസ്രയീംദേശത്തു എല്ലാടവും മനുഷ്യരുടെയും മൃഗങ്ങളുടെയും മേലും മിസ്രയീംദേശത്തുള്ള സകലസസ്യത്തിന്മേലും കല്മഴ വരുവാൻ നിന്റെ കൈ ആകാശത്തേക്കു നീട്ടുക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","മോശെ തന്റെ വടി ആകാശത്തേക്കു നീട്ടി; അപ്പോൾ യഹോവ ഇടിയും കല്മഴയും അയച്ചു; തീ ഭൂമിയിലേക്കു പാഞ്ഞിറങ്ങി; യഹോവ മിസ്രയീംദേശത്തിന്മേൽ കല്മഴ പെയ്യിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ഇങ്ങനെ കല്മഴയും കല്മഴയോടു കൂടെ വിടാതെ ഇറങ്ങുന്ന തീയും അതികഠിനമായിരുന്നു; മിസ്രയീംദേശത്തു ജനവാസം തുടങ്ങിയതുമുതൽ അതിലെങ്ങും ഇതുപോലെ ഉണ്ടായിട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","മിസ്രയീംദേശത്തു എല്ലാടവും മനുഷ്യരെയും മൃഗങ്ങളെയും വയലിൽ ഇരുന്ന സകലത്തെയും കല്മഴ സംഹരിച്ചു; കല്മഴ വയലിലുള്ള സകലസസ്യത്തെയും നശിപ്പിച്ചു; പറമ്പിലെ വൃക്ഷത്തെ ഒക്കെയും തകർത്തുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","യിസ്രായേൽമക്കൾ പാർത്ത ഗോശെൻദേശത്തു മാത്രം കല്മഴ ഉണ്ടായില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","അപ്പോൾ ഫറവോൻ ആളയച്ചു മോശെയെയും അഹരോനെയും വിളിപ്പിച്ചു അവരോടു: ഈ പ്രാവശ്യം ഞാൻ പാപം ചെയ്തു; യഹോവ നീതിയുള്ളവൻ; ഞാനും എന്റെ ജനവും ദുഷ്ടന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","യഹോവയോടു പ്രാർത്ഥിപ്പിൻ; ഈ ഭയങ്കരമായ ഇടിയും കല്മഴയും മതി. ഞാൻ നിങ്ങളെ വിട്ടയക്കാം; ഇനി താമസിപ്പിക്കയില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","മോശെ അവനോടു: ഞാൻ പട്ടണത്തിൽനിന്നു പുറപ്പെടുമ്പോൾ യഹോവയിങ്കലേക്കു കൈ മലർത്തും; ഭൂമി യഹോവെക്കുള്ളതു എന്നു നീ അറിയേണ്ടതിന്നു ഇടിമുഴക്കം നിന്നുപോകും; കല്മഴയും പിന്നെ ഉണ്ടാകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","എന്നാൽ നീയും നിന്റെ ഭൃത്യന്മാരും യഹോവയായ ദൈവത്തെ ഭയപ്പെടുകയില്ല എന്നു ഞാൻ അറിയുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","അങ്ങനെ ചണവും യവവും നശിച്ചുപോയി; യവം കതിരായും ചണം പൂത്തും ഇരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","എന്നാൽ കോതമ്പും ചോളവും വളർന്നിട്ടില്ലാഞ്ഞതുകൊണ്ടു നശിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","മോശെ ഫറവോനെ വിട്ടു പട്ടണത്തിൽനിന്നു പുറപ്പെട്ടു യഹോവയിങ്കലേക്കു കൈ മലർത്തിയപ്പോൾ ഇടിമുഴക്കവും കല്മഴയും നിന്നു മഴ ഭൂമിയിൽ ചൊരിഞ്ഞതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","എന്നാൽ മഴയും കല്മഴയും ഇടിമുഴക്കവും നിന്നുപോയി എന്നു ഫറവോൻ കണ്ടപ്പോൾ അവൻ പിന്നെയും പാപം ചെയ്തു; അവനും ഭൃത്യന്മാരും ഹൃദയം കഠിനമാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","യഹോവ മോശെമുഖാന്തരം അരുളിച്ചെയ്തിരുന്നതുപോലെ ഫറവോന്റെ ഹൃദയം കഠിനപ്പെട്ടു, അവൻ യിസ്രായേൽമക്കളെ വിട്ടയച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","യഹോവ പിന്നെയും മോശെയോടു: നീ ഫറവോന്റെ അടുക്കൽ ചെല്ലുക. ഞാൻ അവന്റെ മുമ്പിൽ എന്റെ അടയാളങ്ങളെ ചെയ്യേണ്ടതിന്നും, ");
INSERT INTO mal2015_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ഞാൻ മിസ്രയീമിൽ പ്രവർത്തിച്ച കാര്യങ്ങളും അവരുടെ മദ്ധ്യേ ചെയ്ത അടയാളങ്ങളും നീ നിന്റെ പുത്രന്മാരോടും പൗത്രന്മാരോടും വിവരിക്കേണ്ടതിന്നും ഞാൻ യഹോവ ആകുന്നു എന്നു നിങ്ങൾ അറിയേണ്ടതിന്നും ഞാൻ അവന്റെയും ഭൃത്യന്മാരുടെയും ഹൃദയം കഠിനമാക്കിയിരിക്കുന്നു എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","അങ്ങനെ മോശെയും അഹരോനും ഫറവോന്റെ അടുക്കൽ ചെന്നു അവനോടു പറഞ്ഞതെന്തെന്നാൽ: എബ്രായരുടെ ദൈവമായ യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: എന്റെ മുമ്പാകെ നിന്നെ തന്നേ താഴ്ത്തുവാൻ എത്രത്തോളം നിനക്കു മനസ്സില്ലാതിരിക്കും? എന്നെ ആരാധിപ്പാൻ എന്റെ ജനത്തെ വിട്ടയക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","എന്റെ ജനത്തെ വിട്ടയപ്പാൻ നിനക്കു മനസ്സില്ലെങ്കിൽ ഞാൻ നാളെ നിന്റെ രാജ്യത്തു വെട്ടുക്കിളിയെ വരുത്തും. ");
INSERT INTO mal2015_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","നിലം കാണ്മാൻ വഹിയാതവണ്ണം അവ ഭൂതലത്തെ മൂടുകയും കല്മഴയിൽ നശിക്കാതെ ശേഷിച്ചിരിക്കുന്നതും പറമ്പിൽ തളിർത്തു വളരുന്ന സകലവൃക്ഷവും തിന്നുകളകയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","നിന്റെ ഗൃഹങ്ങളും നിന്റെ സകലഭൃത്യന്മാരുടെയും സകലമിസ്രയീമ്യരുടെയും വീടുകളും അതുകൊണ്ടു നിറയും; നിന്റെ പിതാക്കന്മാരെങ്കിലും പിതൃപിതാക്കന്മാരെങ്കിലും ഭൂമിയിൽ ഇരുന്ന കാലം മുതൽ ഇന്നുവരെയും അങ്ങനെയുള്ളതു കണ്ടിട്ടില്ല. പിന്നെ അവൻ തിരിഞ്ഞു ഫറവോന്റെ അടുക്കൽനിന്നു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","അപ്പോൾ ഭൃത്യന്മാർ ഫറവോനോടു: എത്രത്തോളം ഇവൻ നമുക്കു കണിയായിരിക്കും? ആ മനുഷ്യരെ തങ്ങളുടെ ദൈവമായ യഹോവയെ ആരാധിക്കേണ്ടതിന്നു വിട്ടയക്കേണം; മിസ്രയീം നശിച്ചുപോകുന്നു എന്നു ഇപ്പോഴും നീ അറിയുന്നില്ലയോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","അപ്പോൾ ഫറവോൻ മോശെയെയും അഹരോനെയും വീണ്ടും വരുത്തി അവരോടു: നിങ്ങൾ പോയി നിങ്ങളുടെ ദൈവമായ യഹോവയെ ആരാധിപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","എന്നാൽ പോകേണ്ടുന്നവർ ആരെല്ലാം? എന്നു ചോദിച്ചതിന്നു മോശെ ഞങ്ങൾക്കു യഹോവയുടെ ഉത്സവമുണ്ടാകകൊണ്ടു ഞങ്ങൾ ഞങ്ങളുടെ ബാലന്മാരും വൃദ്ധന്മാരും പുത്രന്മാരും പുത്രിമാരുമായി പോകും; ഞങ്ങളുടെ ആടുകളെയും കന്നുകാലികളെയും കൂടെ കൊണ്ടുപോകും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","അവൻ അവരോടു: ഞാൻ നിങ്ങളെയും നിങ്ങളുടെ കുഞ്ഞുകുട്ടികളെയും വിട്ടയച്ചാൽ യഹോവ നിങ്ങളോടുകൂടെ ഇരിക്കട്ടെ; നോക്കുവിൻ; ദോഷമാകുന്നു നിങ്ങളുടെ അന്തരം. ");
INSERT INTO mal2015_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","അങ്ങനെയല്ല, നിങ്ങൾ പുരുഷന്മാർ പോയി യഹോവയെ ആരാധിച്ചുകൊൾവിൻ; ഇതല്ലോ നിങ്ങൾ അപേക്ഷിച്ചതു എന്നു പറഞ്ഞു അവരെ ഫറവോന്റെ സന്നിധിയിൽനിന്നു ആട്ടിക്കളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","അപ്പോൾ യഹോവ മോശെയോടു: നിലത്തിലെ സകലസസ്യാദികളും കല്മഴയിൽ ശേഷിച്ചതു ഒക്കെയും തിന്നുകളയേണ്ടതിന്നു വെട്ടുക്കിളി മിസ്രയീംദേശത്തു വരുവാൻ നിന്റെ കൈ ദേശത്തിന്മേൽ നീട്ടുക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","അങ്ങനെ മോശെ തന്റെ വടി മിസ്രയീംദേശത്തിന്മേൽ നീട്ടി; യഹോവ അന്നു പകൽ മുഴുവനും രാത്രി മുഴുവനും ദേശത്തിന്മേൽ കിഴക്കൻകാറ്റു അടിപ്പിച്ചു; പ്രഭാതം ആയപ്പോൾ കിഴക്കൻകാറ്റു വെട്ടുക്കിളിയെ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","വെട്ടുക്കിളി മിസ്രയീംദേശത്തൊക്കെയും വന്നു മിസ്രയീമിന്റെ അതിർക്കകത്തു ഒക്കെയും അനവധിയായി വീണു; അതുപോലെ വെട്ടുക്കിളി ഉണ്ടായിട്ടില്ല, ഇനി അതുപോലെ ഉണ്ടാകയുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","അതു ഭൂതലത്തെ ഒക്കെയും മൂടി ദേശം അതിനാൽ ഇരുണ്ടുപോയി; കല്മഴയിൽ ശേഷിച്ചതായി നിലത്തിലെ സകലസസ്യവും വൃക്ഷങ്ങളുടെ സകലഫലവും അതു തിന്നുകളഞ്ഞു; മിസ്രയീംദേശത്തു എങ്ങും വൃക്ഷങ്ങളിലാകട്ടെ നിലത്തിലെ സസ്യത്തിലാകട്ടെ പച്ചയായതൊന്നും ശേഷിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ഫറവോൻ മോശെയെയും അഹരോനെയും വേഗത്തിൽ വിളിപ്പിച്ചു: നിങ്ങളുടെ ദൈവമായ യഹോവയോടും നിങ്ങളോടും ഞാൻ പാപം ചെയ്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","അതുകൊണ്ടു ഈ പ്രാവശ്യം മാത്രം നീ എന്റെ പാപം ക്ഷമിച്ചു ഈ ഒരു മരണം എന്നെ വിട്ടു നീങ്ങുവാൻ നിങ്ങളുടെ ദൈവമായ യഹോവയോടു പ്രാർത്ഥിപ്പിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","അവൻ ഫറവോന്റെ അടുക്കൽ നിന്നു പറപ്പെടു യഹോവയോടു പ്രാർത്ഥിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","യഹോവ മഹാശക്തിയുള്ളോരു പടിഞ്ഞാറൻ കാറ്റു അടിപ്പിച്ചു; അതു വെട്ടുക്കിളിയെ എടുത്തു ചെങ്കടലിൽ ഇട്ടുകളഞ്ഞു. മിസ്രയീംരാജ്യത്തെങ്ങും ഒരു വെട്ടുക്കിളിപോലും ശേഷിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","എന്നാൽ യഹോവ ഫറവോന്റെ ഹൃദയത്തെ കഠിനമാക്കി; അവൻ യിസ്രായേൽമക്കളെ വിട്ടയച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","അപ്പോൾ യഹോവ മോശെയോടു: മിസ്രയീംദേശത്തു സ്പർശിക്കത്തക്ക ഇരുൾ ഉണ്ടാകേണ്ടതിന്നു നിന്റെ കൈ ആകാശത്തേക്കു നീട്ടുക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","മോശെ തന്റെ കൈ ആകാശത്തേക്കു നീട്ടി, മിസ്രയീംദേശത്തൊക്കെയും മൂന്നു ദിവസത്തേക്കു കൂരിരുട്ടുണ്ടായി. ");
INSERT INTO mal2015_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","മൂന്നു ദിവസത്തേക്കു ഒരുത്തനെ ഒരുത്തൻ കണ്ടില്ല; ഒരുത്തനും തന്റെ സ്ഥലം വിട്ടു എഴുന്നേറ്റതുമില്ല. എന്നാൽ യിസ്രായേൽമക്കൾക്കു എല്ലാവർക്കും തങ്ങളുടെ വാസസ്ഥലങ്ങളിൽ വെളിച്ചം ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","അപ്പോൾ ഫറവോൻ മോശെയെ വിളിപ്പിച്ചു. നിങ്ങൾ പോയി യഹോവയെ ആരാധിപ്പിൻ; നിങ്ങളുടെ ആടുകളും കന്നുകാലികളും മാത്രം ഇങ്ങു നിൽക്കട്ടെ; നിങ്ങളുടെ കുഞ്ഞു കുട്ടികളും നിങ്ങളോടുകൂടെ പോരട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","അതിന്നു മോശെ പറഞ്ഞതു: ഞങ്ങൾ ഞങ്ങളുടെ ദൈവമായ യഹോവെക്കു അർപ്പിക്കേണ്ടതിന്നു യാഗങ്ങൾക്കും സർവ്വാംഗഹോമങ്ങൾക്കും വേണ്ടി മൃഗങ്ങളെയും നീ ഞങ്ങൾക്കു തരേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ഞങ്ങളുടെ മൃഗങ്ങളും ഞങ്ങളോടുകൂടെ പോരേണം; ഒരു കുളമ്പുപോലും പിമ്പിൽ ശേഷിച്ചുകൂടാ; ഞങ്ങളുടെ ദൈവമായ യഹോവയെ ആരാധിക്കേണ്ടതിന്നു അതിൽനിന്നല്ലോ ഞങ്ങൾ എടുക്കേണ്ടതു; ഏതിനെ അർപ്പിച്ചു യഹോവയെ ആരാധിക്കേണമെന്നു അവിടെ എത്തുവോളം ഞങ്ങൾ അറിയുന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","എന്നാൽ യഹോവ ഫറവോന്റെ ഹൃദയം കഠിനമാക്കി; അവരെ വിട്ടയപ്പാൻ അവന്നു മനസ്സായില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ഫറവോൻ അവനോടു: എന്റെ അടുക്കൽനിന്നു പോക. ഇനി എന്റെ മുഖം കാണാതിരിപ്പാൻ സൂക്ഷിച്ചുകൊൾക. എന്റെ മുഖം കാണുന്ന നാളിൽ നീ മരിക്കും എന്നു പറഞ്ഞതിന്നു മോശെ: ");
INSERT INTO mal2015_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","നീ പറഞ്ഞതുപോലെ ആകട്ടെ; ഞാൻ ഇനി നിന്റെ മുഖം കാണുകയില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","അനന്തരം യഹോവ മോശെയോടു: ഞാൻ ഒരു ബാധകൂടെ ഫറവോന്മേലും മിസ്രയീമിന്മേലും വരുത്തും; അതിന്റെ ശേഷം അവൻ നിങ്ങളെ ഇവിടെനിന്നു വിട്ടയക്കും; വിട്ടയക്കുമ്പോൾ നിങ്ങളെ ഒട്ടൊഴിയാതെ ഇവിടെ നിന്നു ഓടിച്ചുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ഓരോ പുരുഷൻ താന്താന്റെ അയൽക്കാരനോടും ഓരോ സ്ത്രീ താന്താന്റെ അയൽക്കാരത്തിയോടും വെള്ളിയാഭരണങ്ങളും പൊന്നാഭരണങ്ങളും ചോദിപ്പാൻ നീ ജനത്തോടു പറക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","യഹോവ മിസ്രയീമ്യർക്കു ജനത്തോടു കൃപ തോന്നുമാറാക്കി. വിശേഷാൽ മോശെ എന്ന പുരുഷനെ മിസ്രയീംദേശത്തു ഫറവോന്റെ ഭൃത്യന്മാരും പ്രജകളും മഹാശ്രേഷ്ഠനായി വിചാരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","മോശെ പറഞ്ഞതെന്തെന്നാൽ: യഹോവ ഇപ്രകാരം അരുളിച്ചെയ്യുന്നു: അർദ്ധരാത്രിയിൽ ഞാൻ മിസ്രയീമിന്റെ നടുവിൽകൂടി പോകും. ");
INSERT INTO mal2015_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","അപ്പോൾ സിംഹാസനത്തിൽ ഇരിക്കുന്ന ഫറവോന്റെ ആദ്യജാതൻമുതൽ തിരികല്ലിങ്കൽ ഇരിക്കുന്ന ദാസിയുടെ ആദ്യജാതൻവരെയും മിസ്രയീംദേശത്തുള്ള കടിഞ്ഞൂൽ ഒക്കെയും മൃഗങ്ങളുടെ എല്ലാകടിഞ്ഞൂലും ചത്തുപോകും. ");
INSERT INTO mal2015_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","മിസ്രയീംദേശത്തു എങ്ങും മുമ്പൊരിക്കലും ഉണ്ടായിട്ടില്ലാത്തതും ഇനി ഉണ്ടാകാത്തതുമായ വലിയൊരു നിലവിളി ഉണ്ടാകും. ");
INSERT INTO mal2015_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","എന്നാൽ യഹോവ മിസ്രയീമ്യർക്കും യിസ്രായേല്യർക്കും മദ്ധ്യേ വ്യത്യാസം വെക്കുന്നു എന്നു നിങ്ങൾ അറിയേണ്ടതിന്നു യിസ്രായേൽമക്കളിൽ യാതൊരു മനുഷ്യന്റെയോ മൃഗത്തിന്റെയോ നേരെ ഒരു നായിപോലും നാവു അനക്കുകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","അപ്പോൾ നിന്റെ ഈ സകലഭൃത്യന്മാരും എന്റെ അടുക്കൽ വന്നു: നീയും നിന്റെ കീഴിൽ ഇരിക്കുന്ന സർവ്വജനവുംകൂടെ പുറപ്പെടുക എന്നു പറഞ്ഞു എന്നെ നമസ്കരിക്കും; അതിന്റെ ശേഷം ഞാൻ പുറപ്പെടും. അങ്ങനെ അവൻ ഉഗ്രകോപത്തോടെ ഫറവോന്റെ അടുക്കൽ നിന്നു പുറപ്പെട്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","യഹോവ മോശെയോടു: മിസ്രയീംദേശത്തു എന്റെ അത്ഭുതങ്ങൾ പെരുകേണ്ടതിന്നു ഫറവോൻ നിങ്ങളുടെ വാക്കു കേൾക്കയില്ല എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","മോശെയും അഹരോനും ഈ അത്ഭുതങ്ങളൊക്കെയും ഫറവോന്റെ മുമ്പാകെ ചെയ്തു എങ്കിലും യഹോവ ഫറവോന്റെ ഹൃദയത്തെ കഠിനമാക്കി; അവൻ യിസ്രായേൽമക്കളെ തന്റെ ദേശത്തു നിന്നു വിട്ടയച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","യഹോവ മോശെയോടും അഹരോനോടും മിസ്രയീംദേശത്തുവെച്ചു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","ഈ മാസം നിങ്ങൾക്കു മാസങ്ങളുടെ ആരംഭമായി ആണ്ടിൽ ഒന്നാം മാസം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","നിങ്ങൾ യിസ്രായേലിന്റെ സർവ്വസംഘത്തോടും പറയേണ്ടതു എന്തെന്നാൽ: ഈ മാസം പത്താം തിയ്യതി അതതു കുടുംബത്തിന്നു ഒരു ആട്ടിൻകുട്ടി വീതം ഓരോരുത്തൻ ഓരോ ആട്ടിൻകുട്ടിയെ എടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ആട്ടിൻകുട്ടിയെ തിന്നുവാൻ വീട്ടിലുള്ളവർ പോരായെങ്കിൽ ആളുകളുടെ എണ്ണത്തിന്നു ഒത്തവണ്ണം അവനും അവന്റെ വീട്ടിന്നടുത്ത അയൽക്കാരനും കൂടി അതിനെ എടുക്കേണം. ഓരോരുത്തൻ തിന്നുന്നതിന്നു ഒത്തവണ്ണം കണക്കു നോക്കി നിങ്ങൾ ആട്ടിൻകുട്ടിയെ എടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ആട്ടിൻകുട്ടി ഊനമില്ലാത്തതും ഒരു വയസ്സു പ്രായമുള്ള ആണുമായിരിക്കേണം; അതു ചെമ്മരിയാടോ കോലാടോ ആകാം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ഈ മാസം പതിന്നാലാം തിയ്യതിവരെ അതിനെ സൂക്ഷിക്കേണം. യിസ്രായേൽസഭയുടെ കൂട്ടമെല്ലാം സന്ധ്യാസമയത്തു അതിനെ അറുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","അതിന്റെ രക്തം കുറെ എടുത്തു തങ്ങൾ തിന്നുന്ന വീടുകളുടെ വാതിലിന്റെ കട്ടളക്കാൽ രണ്ടിന്മേലും കുറുമ്പടിമേലും പുരട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","അന്നു രാത്രി അവർ തീയിൽ ചുട്ടതായ ആ മാംസവും പുളിപ്പില്ലാത്ത അപ്പവും തിന്നേണം; കൈപ്പുചീരയോടുകൂടെ അതു തിന്നേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","തലയും കാലും അന്തർഭാഗങ്ങളുമായി തീയിൽ ചുട്ടിട്ടല്ലാതെ പച്ചയായിട്ടോ വെള്ളത്തിൽ പുഴുങ്ങിയതായിട്ടോ തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","പിറ്റെന്നാൾ കാലത്തേക്കു അതിൽ ഒട്ടും ശേഷിപ്പിക്കരുതു; പിറ്റെന്നാൾ കാലത്തേക്കു ശേഷിക്കുന്നതു നിങ്ങൾ തീയിലിട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","അര കെട്ടിയും കാലിന്നു ചെരിപ്പിട്ടും കയ്യിൽ വടി പിടിച്ചുംകൊണ്ടു നിങ്ങൾ തിന്നേണം; തിടുക്കത്തോടെ നിങ്ങൾ തിന്നേണം; അതു യഹോവയുടെ പെസഹ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","ഈ രാത്രിയിൽ ഞാൻ മിസ്രയീംദേശത്തുകൂടി കടന്നു മിസ്രയീംദേശത്തുള്ള മനുഷ്യന്റെയും മൃഗത്തിന്റെയും കടിഞ്ഞൂലിനെ ഒക്കെയും സംഹരിക്കും; മിസ്രയീമിലെ സകലദേവന്മാരിലും ഞാൻ ന്യായവിധി നടത്തും; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","നിങ്ങൾ പാർക്കുന്ന വീടുകളിന്മേൽ രക്തം അടയാളമായിരിക്കും; ഞാൻ രക്തം കാണുമ്പോൾ നിങ്ങളെ ഒഴിഞ്ഞു കടന്നു പോകും; ഞാൻ മിസ്രയീംദേശത്തെ ബാധിക്കുന്ന ബാധ നിങ്ങൾക്കു നാശഹേതുവായ്തീരുകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","ഈ ദിവസം നിങ്ങൾക്കു ഓർമ്മനാളായിരിക്കേണം; നിങ്ങൾ അതു യഹോവെക്കു ഉത്സവമായി ആചരിക്കേണം. തലമുറതലമുറയായും നിത്യനിയമമായും നിങ്ങൾ അതു ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ഏഴു ദിവസം നിങ്ങൾ പുളിപ്പില്ലാത്ത അപ്പം തിന്നേണം; ഒന്നാം ദിവസം തന്നേ പുളിച്ച മാവു നിങ്ങളുടെ വീടുകളിൽനിന്നു നീക്കേണം; ഒന്നാം ദിവസംമുതൽ ഏഴാം ദിവസംവരെ ആരെങ്കിലും പുളിപ്പുള്ള അപ്പം തിന്നാൽ അവനെ യിസ്രായേലിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ഒന്നാം ദിവസത്തിലും ഏഴാം ദിവസത്തിലും നിങ്ങൾക്കു വിശുദ്ധസഭായോഗം ഉണ്ടാകേണം; അന്നു അവരവർക്കു വേണ്ടുന്ന ഭക്ഷണം ഒരുക്കുകയല്ലാതെ ഒരു വേലയും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","പുളിപ്പില്ലാത്ത അപ്പത്തിന്റെ പെരുനാൾ നിങ്ങൾ ആചരിക്കേണം; ഈ ദിവസത്തിൽ തന്നേയാകുന്നു ഞാൻ നിങ്ങളുടെ ഗണങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെടുവിച്ചിരിക്കുന്നതു; അതുകൊണ്ടു ഈ ദിവസം തലമുറതലമുറയായും നിത്യനിയമമായും നിങ്ങൾ ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ഒന്നാം മാസം പതിന്നാലാം തിയ്യതി വൈകുന്നേരംമുതൽ ആ മാസം ഇരുപത്തൊന്നാം തിയ്യതി വൈകുന്നേരംവരെ നിങ്ങൾ പുളിപ്പില്ലാത്ത അപ്പം തിന്നേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ഏഴു ദിവസം നിങ്ങളുടെ വീടുകളിൽ പുളിച്ചമാവു കാണരുതു; ആരെങ്കിലും പുളിച്ചതു തിന്നാൽ പരദേശിയായാലും സ്വദേശിയായാലും അവനെ യിസ്രായേൽസഭയിൽ നിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","പുളിച്ചതു യാതൊന്നും നിങ്ങൾ തിന്നരുതു; നിങ്ങളുടെ വാസസ്ഥലങ്ങളിലെല്ലാം പുളിപ്പില്ലാത്ത അപ്പം തിന്നേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","അനന്തരം മോശെ യിസ്രായേൽമൂപ്പന്മാരെ ഒക്കെയും വിളിച്ചു അവരോടു പറഞ്ഞതു: നിങ്ങൾ നിങ്ങളുടെ കുടുംബങ്ങൾക്കു ഒത്തവണ്ണം ഓരോ ആട്ടിൻകുട്ടിയെ തിരഞ്ഞെടുത്തു പെസഹയെ അറുപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ഈസോപ്പുചെടിയുടെ ഒരു കെട്ടു എടുത്തു കിണ്ണത്തിലുള്ള രക്തത്തിൽ മുക്കി കിണ്ണത്തിലുള്ള രക്തം കുറമ്പടിമേലും കട്ടളക്കാൽ രണ്ടിന്മേലും തേക്കേണം; പിറ്റെന്നാൾ വെളുക്കുംവരെ നിങ്ങളിൽ ആരും വീട്ടിന്റെ വാതിലിന്നു പുറത്തിറങ്ങരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","യഹോവ മിസ്രയീമ്യരെ ദണ്ഡിപ്പിക്കേണ്ടതിന്നു കടന്നുവരും; എന്നാൽ കുറുമ്പടിമേലും കട്ടളക്കാൽ രണ്ടിന്മേലും രക്തം കാണുമ്പോൾ യഹോവ വാതിൽ ഒഴിഞ്ഞു കടന്നു പോകും; നിങ്ങളുടെ വീടുകളിൽ നിങ്ങളെ ദണ്ഡിപ്പിക്കേണ്ടതിന്നു സംഹാരകൻ വരുവാൻ സമ്മതിക്കയുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ഈ കാര്യം നീയും പുത്രന്മാരും ഒരു നിത്യനിയമമായി ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","യഹോവ അരുളിച്ചെയ്തതുപോലെ നിങ്ങൾക്കു തരുവാനിരിക്കുന്ന ദേശത്തു നിങ്ങൾ എത്തിയശേഷം നിങ്ങൾ ഈ കർമ്മം ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ഈ കർമ്മം എന്തെന്നു നിങ്ങളുടെ മക്കൾ നിങ്ങളോടു ചോദിക്കുമ്പോൾ: ");
INSERT INTO mal2015_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","മിസ്രയീമ്യരെ ദണ്ഡിപ്പിക്കയിൽ മിസ്രയീമിലിരുന്ന യിസ്രായേൽമക്കളുടെ വീടുകളെ ഒഴിഞ്ഞു കടന്നു നമ്മുടെ വീടുകളെ രക്ഷിച്ച യഹോവയുടെ പെസഹയാഗം ആകുന്നു ഇതു എന്നു നിങ്ങൾ പറയേണം. അപ്പോൾ ജനം കുമ്പിട്ടു നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","യിസ്രായേൽമക്കൾ പോയി അങ്ങനെ ചെയ്തു. യഹോവ മോശെയോടും അഹരോനോടും കല്പിച്ചതുപോലെ തന്നേ അവർ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","അർദ്ധരാത്രിയിലോ, സിംഹാസനത്തിലിരുന്ന ഫറവോന്റെ ആദ്യജാതൻ മുതൽ കുണ്ടറയിൽ കിടന്ന തടവുകാരന്റെ ആദ്യജാതൻ വരെയും മിസ്രയീംദേശത്തിലെ ആദ്യജാതന്മാരെയും മൃഗങ്ങളുടെ കടിഞ്ഞൂലുകളെയും എല്ലാം യഹോവ സംഹരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ഫറവോനും അവന്റെ സകലഭൃത്യന്മാരും സകലമിസ്രയീമ്യരും രാത്രിയിൽ എഴുന്നേറ്റു; മിസ്രയീമിൽ വലിയോരു നിലവിളി ഉണ്ടായി; ഒന്നു മരിക്കാതെ ഒരു വീടും ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","അപ്പോൾ അവൻ മോശെയെയും അഹരോനെയും രാത്രിയിൽ വിളിപ്പിച്ചു: നിങ്ങൾ യിസ്രായേൽമക്കളുമായി എഴുന്നേറ്റു എന്റെ ജനത്തിന്റെ നടുവിൽനിന്നു പുറപ്പെട്ടു, നിങ്ങൾ പറഞ്ഞതുപോലെ പോയി യഹോവയെ ആരാധിപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","നിങ്ങൾ പറഞ്ഞതുപോലെ നിങ്ങളുടെ ആടുകളെയും കന്നുകാലികളെയും കൂടെ കൊണ്ടുപോയ്ക്കൊൾവിൻ; എന്നെയും അനുഗ്രഹിപ്പിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","മിസ്രയീമ്യർ ജനത്തെ നിർബന്ധിച്ചു വേഗത്തിൽ ദേശത്തുനിന്നു അയച്ചു: ഞങ്ങൾ എല്ലാവരും മരിച്ചുപോകുന്നു എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","അതുകൊണ്ടു ജനം കുഴെച്ച മാവു പുളിക്കുന്നതിന്നു മുമ്പെ തൊട്ടികളോടുകൂടെ ശീലകളിൽ കെട്ടി ചുമലിൽ എടുത്തു കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","യിസ്രായേൽമക്കൾ മോശെയുടെ വചനം അനുസരിച്ചു മിസ്രയീമ്യരോടു വെള്ളിയാഭരണങ്ങളും പൊന്നാഭരണങ്ങളും വസ്ത്രങ്ങളും ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","യഹോവ മിസ്രയീമ്യർക്കു ജനത്തോടു കൃപ തോന്നിച്ചതുകൊണ്ടു അവർ ചോദിച്ചതൊക്കെയും അവർ അവർക്കു കൊടുത്തു; അങ്ങനെ അവർ മിസ്രയീമ്യരെ കൊള്ളയിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","എന്നാൽ യിസ്രായേൽമക്കൾ, കുട്ടികൾ ഒഴികെ ഏകദേശം ആറു ലക്ഷം പുരുഷന്മാർ കാൽനടയായി റമസേസിൽനിന്നു സുക്കോത്തിലേക്കു യാത്ര പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","വലിയോരു സമ്മിശ്രപുരുഷാരവും ആടുകളും കന്നുകാലികളുമായി അനവധി മൃഗങ്ങളും അവരോടു കൂടെ പോന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","മിസ്രയീമിൽനിന്നു കൊണ്ടു പോന്ന കുഴെച്ച മാവുകൊണ്ടു അവർ പുളിപ്പില്ലാത്ത ദോശ ചുട്ടു; അവരെ മിസ്രയീമിൽ ഒട്ടും താമസിപ്പിക്കാതെ ഓടിച്ചുകളകയാൽ അതു പുളിച്ചിരുന്നില്ല; അവർ വഴിക്കു ആഹാരം ഒന്നും ഒരുക്കിയിരുന്നതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","യിസ്രായേൽമക്കൾ മിസ്രയീമിൽ കഴിച്ച പരദേശവാസം നാനൂറ്റി മുപ്പതു സംവത്സരമായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","നാനൂറ്റി മുപ്പതു സംവത്സരം കഴിഞ്ഞിട്ടു, ആ ദിവസം തന്നെ, യഹോവയുടെ ഗണങ്ങൾ ഒക്കെയും മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","യഹോവ അവരെ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെടുവിച്ചതിനാൽ ഇതു അവന്നു പ്രത്യേകമായി ആചരിക്കേണ്ടുന്ന രാത്രി ആകുന്നു; ഇതു തന്നേ യിസ്രായേൽ മക്കൾ ഒക്കെയും തലമുറതലമുറയായി യഹോവെക്കു പ്രത്യേകം ആചരിക്കേണ്ടുന്ന രാത്രി. ");
INSERT INTO mal2015_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും കല്പിച്ചതു: പെസഹയുടെ ചട്ടം ഇതു ആകുന്നു: അന്യജാതിക്കാരനായ ഒരുത്തനും അതു തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","എന്നാൽ ദ്രവ്യം കൊടുത്തു വാങ്ങിയ ദാസന്നു ഒക്കെയും പരിച്ഛേദന ഏറ്റശേഷം അതു തിന്നാം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","പരദേശിയും കൂലിക്കാരനും അതു തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","അതതു വീട്ടിൽവെച്ചു തന്നേ അതു തിന്നേണം; ആ മാംസം ഒട്ടും വീട്ടിന്നു പുറത്തു കൊണ്ടുപോകരുതു; അതിൽ ഒരു അസ്ഥിയും ഒടിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","യിസ്രായേൽസഭ ഒക്കെയും അതു ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ഒരു അന്യജാതിക്കാരൻ നിന്നോടുകൂടെ പാർത്തു യഹോവെക്കു പെസഹ ആചരിക്കേണമെങ്കിൽ, അവന്നുള്ള ആണൊക്കെയും പരിച്ഛേദന ഏൽക്കേണം. അതിന്റെ ശേഷം അതു ആചരിക്കേണ്ടതിന്നു അവന്നു അടുത്തുവരാം; അവൻ സ്വദേശിയെപ്പോലെ ആകും. പരിച്ഛേദനയില്ലാത്ത ഒരുത്തനും അതു തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","സ്വദേശിക്കും നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പരദേശിക്കും ഒരു ന്യായപ്രമാണം തന്നേ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","യിസ്രായേൽമക്കൾ ഒക്കെയും അങ്ങനെ ചെയ്തു; യഹോവ മോശെയോടും അഹരോനോടും കല്പിച്ചതുപോലെ തന്നേ അവർ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","അന്നു തന്നേ യഹോവ യിസ്രായേൽമക്കളെ ഗണം ഗണമായി മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെടുവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","യഹോവ പിന്നെയും മോശെയോടു: ");
INSERT INTO mal2015_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","യിസ്രായേൽമക്കളുടെ ഇടയിൽ മനുഷ്യരിലും മൃഗങ്ങളിലും കടിഞ്ഞൂലായി പിറക്കുന്നതിന്നെ ഒക്കെയും എനിക്കായി ശുദ്ധീകരിക്ക; അതു എനിക്കുള്ളതാകുന്നു എന്നു കല്പിച്ചു; ");
INSERT INTO mal2015_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","അപ്പോൾ മോശെ ജനത്തോടു പറഞ്ഞതു: നിങ്ങൾ അടിമവീടായ മിസ്രയീമിൽനിന്നു പുറപ്പെട്ടുപോന്ന ഈ ദിവസത്തെ ഓർത്തു കൊൾവിൻ; യഹോവ ബലമുള്ള കൈകൊണ്ടു നിങ്ങളെ അവിടെനിന്നു പുറപ്പെടുവിച്ചു; അതുകൊണ്ടു പുളിപ്പുള്ള അപ്പം തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ആബീബ് മാസം ഈ തിയ്യതി നിങ്ങൾ പുറപ്പെട്ടു പോന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","എന്നാൽ കനാന്യർ, ഹിത്യർ, അമോര്യർ, ഹിവ്യർ, യെബൂസ്യർ എന്നിവരുടെ ദേശമായി യഹോവ നിനക്കു തരുമെന്നു നിന്റെ പിതാക്കന്മാരോടു സത്യം ചെയ്തതും പാലും തേനും ഒഴുകുന്നതുമായ ദേശത്തേക്കു നിന്നെ കൊണ്ടുചെന്നശേഷം നീ ഈ മാസത്തിൽ ഈ കർമ്മം ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ഏഴു ദിവസം നീ പുളിപ്പില്ലാത്ത അപ്പം തിന്നേണം; ഏഴാം ദിവസം യഹോവെക്കു ഒരു ഉത്സവം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ഏഴു ദിവസവും പുളിപ്പില്ലാത്ത അപ്പം തിന്നേണം; നിന്റെ പക്കൽ പുളിപ്പുള്ള അപ്പം കാണരുതു; നിന്റെ അരികത്തെങ്ങും പുളിച്ചമാവും കാണരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ഞാൻ മിസ്രയീമിൽനിന്നു പുറപ്പെടുമ്പോൾ യഹോവ എനിക്കുവേണ്ടി ചെയ്ത കാര്യം നിമിത്തം ആകുന്നു ഇങ്ങനെ ചെയ്യുന്നതു എന്നു നീ ആ ദിവസത്തിൽ നിന്റെ മകനോടു അറിയിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","യഹോവയുടെ ന്യായപ്രമാണം നിന്റെ വായിൽ ഉണ്ടായിരിക്കേണ്ടതിന്നു ഇതു നിനക്കു നിന്റെ കയ്യിന്മേൽ അടയാളമായും നിന്റെ കണ്ണുകളുടെ നടുവിൽ ജ്ഞാപകലക്ഷ്യമായും ഇരിക്കേണം. ബലമുള്ള കൈകൊണ്ടല്ലോ യഹോവ നിന്നെ മിസ്രയീമിൽ നിന്നു പുറപ്പെടുവിച്ചതു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","അതു കൊണ്ടു നീ ആണ്ടുതോറും നിശ്ചയിക്കപ്പെട്ട സമയത്തു ഈ ചട്ടം ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","യഹോവ നിന്നോടും നിന്റെ പിതാക്കന്മാരോടും സത്യം ചെയ്തതുപോലെ നിന്നെ കനാന്യരുടെ ദേശത്തു കൊണ്ടുചെന്നു അതു നിനക്കു തരുമ്പോൾ ");
INSERT INTO mal2015_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","കടിഞ്ഞൂലിനെ ഒക്കെയും, നിനക്കുള്ള മൃഗങ്ങളുടെ കടിഞ്ഞൂൽപിറവിയെ ഒക്കെയും നീ യഹോവെക്കായി വേർതിരിക്കേണം; ആണൊക്കെയും യഹോവെക്കുള്ളതാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","എന്നാൽ കഴുതയുടെ കടിഞ്ഞൂലിനെ ഒക്കെയും ആട്ടിൻകുട്ടിയെക്കൊണ്ടു വീണ്ടുകൊള്ളേണം; അതിനെ വീണ്ടുകൊള്ളുന്നില്ലെങ്കിൽ അതിന്റെ കഴുത്തു ഒടിച്ചുകളയേണം. നിന്റെ പുത്രന്മാരിൽ ആദ്യജാതനെ ഒക്കെയും നീ വീണ്ടുകൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","എന്നാൽ ഇതു എന്തു എന്നു നാളെ നിന്റെ മകൻ നിന്നോടു ചോദിക്കുമ്പോൾ: യഹോവ ബലമുള്ള കൈകൊണ്ടു അടിമവീടായ മിസ്രയീമിൽനിന്നു ഞങ്ങളെ പുറപ്പെടുവിച്ചു; ");
INSERT INTO mal2015_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ഫറവോൻ കഠിനപ്പെട്ടു ഞങ്ങളെ വിട്ടയക്കാതിരുന്നപ്പോൾ യഹോവ മിസ്രയീംദേശത്തു മനുഷ്യന്റെ കടിഞ്ഞൂൽമുതൽ മൃഗത്തിന്റെ കടിഞ്ഞൂൽവരെയുള്ള കടിഞ്ഞൂൽപിറവിയെ ഒക്കെയും കൊന്നുകളഞ്ഞു. അതുകൊണ്ടു കടിഞ്ഞൂലായ ആണിനെ ഒക്കെയും ഞാൻ യഹോവെക്കു യാഗം അർപ്പിക്കുന്നു; എന്നാൽ എന്റെ മക്കളിൽ കടിഞ്ഞൂലിനെ ഒക്കെയും ഞാൻ വീണ്ടുകൊള്ളുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ഇതു നിന്റെ കയ്യിന്മേൽ അടയാളമായും നിന്റെ കണ്ണുകളുടെ നടുവിൽ നെറ്റിപ്പട്ടമായും ഇരിക്കേണം. യഹോവ ഞങ്ങളെ ബലമുള്ള കൈകൊണ്ടു മിസ്രയീമിൽ നിന്നു പുറപ്പെടുവിച്ചു എന്നു നീ അവനോടു പറയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ഫറവോൻ ജനത്തെ വിട്ടയച്ച ശേഷം ഫെലിസ്ത്യരുടെ ദേശത്തു കൂടിയുള്ള വഴി അടുത്തതു എന്നുവരികിലും ജനം യുദ്ധം കാണുമ്പോൾ പക്ഷേ അനുതപിച്ചു മിസ്രയീമിലേക്കു മടങ്ങിപ്പോകുമെന്നുവെച്ചു ദൈവം അവരെ അതിലെ കൊണ്ടുപോയില്ല; ");
INSERT INTO mal2015_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ചെങ്കടലരികെയുള്ള മരുഭൂമിയിൽകൂടി ദൈവം ജനത്തെ ചുറ്റിനടത്തി. യിസ്രായേൽമക്കൾ മിസ്രയീംദേശത്തുനിന്നു യുദ്ധസന്നദ്ധരായി പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","മോശെ യോസേഫിന്റെ അസ്ഥികളും എടുത്തുകൊണ്ടു പോന്നു. ദൈവം നിങ്ങളെ സന്ദർശിക്കും നിശ്ചയം; അപ്പോൾ എന്റെ അസ്ഥികളും നിങ്ങൾ ഇവിടെനിന്നു എടുത്തുകൊണ്ടു പോകേണമെന്നു പറഞ്ഞു അവൻ യിസ്രായേൽമക്കളെക്കൊണ്ടു ഉറപ്പായി സത്യം ചെയ്യിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","അവർ സുക്കോത്തിൽനിന്നു യാത്രപുറപ്പെട്ടു മരുഭൂമിക്കരികെ ഏഥാമിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","അവർ പകലും രാവും യാത്രചെയ്‌വാൻ തക്കവണ്ണം അവർക്കു വഴികാണിക്കേണ്ടതിന്നു പകൽ മേഘസ്തംഭത്തിലും അവർക്കു വെളിച്ചം കൊടുക്കേണ്ടതിന്നു രാത്രി അഗ്നിസ്തംഭത്തിലും യഹോവ അവർക്കു മുമ്പായി പൊയ്ക്കൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","പകൽ മേഘസ്തംഭവും രാത്രി അഗ്നിസ്തംഭവും ജനത്തിന്റെ മുമ്പിൽനിന്നു മാറിയതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","നിങ്ങൾ തിരിഞ്ഞു മിഗ്ദോലിന്നും കടലിന്നും മദ്ധ്യേ ബാൽസെഫോന്നു സമീപത്തുള്ള പീഹഹീരോത്തിന്നരികെ പാളയം ഇറങ്ങേണമെന്നു യിസ്രായേൽമക്കളോടു പറക; അതിന്റെ സമീപത്തു സമുദ്രത്തിന്നരികെ നിങ്ങൾ പാളയം ഇറങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","എന്നാൽ അവർ ദേശത്തു ഉഴലുന്നു; മരുഭൂമിയിൽ കുടുങ്ങിയിരിക്കുന്നു എന്നു ഫറവോൻ യിസ്രായേൽമക്കളെക്കുറിച്ചു പറയും. ");
INSERT INTO mal2015_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ഫറവോൻ അവരെ പിന്തുടരുവാൻ തക്കവണ്ണം ഞാൻ അവന്റെ ഹൃദയം കഠിനമാക്കും. ഞാൻ യഹോവ ആകുന്നു എന്നു മിസ്രയീമ്യർ അറിയേണ്ടതിന്നു ഫറവോനിലും അവന്റെ സകലസൈന്യങ്ങളിലും ഞാൻ എന്നെ തന്നേ മഹത്വപ്പെടുത്തും. ");
INSERT INTO mal2015_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","അവർ അങ്ങനെ ചെയ്തു. ജനം ഓടിപ്പോയി എന്നു മിസ്രയീംരാജാവിന്നു അറിവു കിട്ടിയപ്പോൾ ജനത്തെ സംബന്ധിച്ചു ഫറവോന്റെയും അവന്റെ ഭൃത്യന്മാരുടെയും മനസ്സുമാറി: യിസ്രായേല്യരെ നമ്മുടെ അടിമവേലയിൽനിന്നു വിട്ടയച്ചുകളഞ്ഞുവല്ലോ; നാം ഈ ചെയ്തതു എന്തു എന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","പിന്നെ അവൻ രഥം കെട്ടിച്ചു പടജ്ജനത്തെയും ");
INSERT INTO mal2015_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","വിശേഷപ്പെട്ട അറുനൂറു രഥങ്ങളെയും മിസ്രയീമിലെ സകലരഥങ്ങളെയും അവെക്കു വേണ്ടുന്ന തേരാളികളെയും കൂട്ടി. ");
INSERT INTO mal2015_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","യഹോവ മിസ്രയീംരാജാവായ ഫറവോന്റെ ഹൃദയം കഠിനമാക്കിയതിനാൽ അവൻ യിസ്രായേൽമക്കളെ പിന്തുടർന്നു. എന്നാൽ യിസ്രായേൽമക്കൾ യുദ്ധസന്നദ്ധരായി പുറപ്പെട്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ഫറവോന്റെ എല്ലാ കുതിരയും രഥവും കുതിരപ്പടയും സൈന്യവുമായി മിസ്രയീമ്യർ അവരെ പിന്തുടർന്നു; കടൽക്കരയിൽ ബാൽസെഫോന്നു സമീപത്തുള്ള പീഹഹീരോത്തിന്നു അരികെ അവർ പാളയമിറങ്ങിയിരിക്കുമ്പോൾ അവരോടു അടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ഫറവോൻ അടുത്തുവരുമ്പോൾ യിസ്രായേൽമക്കൾ തല ഉയർത്തി മിസ്രയീമ്യർ പിന്നാലെ വരുന്നതു കണ്ടു ഏറ്റവും ഭയപ്പെട്ടു; യിസ്രായേൽമക്കൾ യഹോവയോടു നിലവിളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","അവർ മോശെയോടു: മിസ്രയീമിൽ ശവക്കുഴിയില്ലാഞ്ഞിട്ടോ നീ ഞങ്ങളെ മരുഭൂമിയിൽ മരിപ്പാൻ കൂട്ടിക്കൊണ്ടുവന്നതു? നീ ഞങ്ങളെ മിസ്രയീമിൽനിന്നു പുറപ്പെടുവിച്ചതിനാൽ ഞങ്ങളോടു ഈ ചെയ്തതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","മിസ്രയീമ്യർക്കു വേല ചെയ്‌വാൻ ഞങ്ങളെ വിടേണം എന്നു ഞങ്ങൾ മിസ്രയീമിൽവെച്ചു നിന്നോടു പറഞ്ഞില്ലയോ? മരുഭൂമിയിൽ മരിക്കുന്നതിനെക്കാൾ മിസ്രയീമ്യർക്കു വേല ചെയ്യുന്നതായിരുന്നു ഞങ്ങൾക്കു നല്ലതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","അതിന്നു മോശെ ജനത്തോടു: ഭയപ്പെടേണ്ടാ; ഉറച്ചുനില്പിൻ; യഹോവ ഇന്നു നിങ്ങൾക്കു ചെയ്‌വാനിരിക്കുന്ന രക്ഷ കണ്ടുകൊൾവിൻ; നിങ്ങൾ ഇന്നു കണ്ടിട്ടുള്ള മിസ്രയീമ്യരെ ഇനി ഒരുനാളും കാണുകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","യഹോവ നിങ്ങൾക്കുവേണ്ടി യുദ്ധംചെയ്യും; നിങ്ങൾ മിണ്ടാതിരിപ്പിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","അപ്പോൾ യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: നീ എന്നോടു നിലവിളിക്കുന്നതു എന്തു? മുമ്പോട്ടു പോകുവാൻ യിസ്രായേൽമക്കളോടു പറക. ");
INSERT INTO mal2015_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","വടി എടുത്തു നിന്റെ കൈ കടലിന്മേൽ നീട്ടി അതിനെ വിഭാഗിക്ക; യിസ്രായേൽമക്കൾ കടലിന്റെ നടുവെ ഉണങ്ങിയ നിലത്തുകൂടി കടന്നുപോകും. ");
INSERT INTO mal2015_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","എന്നാൽ ഞാൻ മിസ്രയീമ്യരുടെ ഹൃദയത്തെ കഠിനമാക്കും; അവർ ഇവരുടെ പിന്നാലെ ചെല്ലും; ഞാൻ ഫറവോനിലും അവന്റെ സകല സൈന്യത്തിലും അവന്റെ രഥങ്ങളിലും കുതിരപ്പടയിലും എന്നെ തന്നെ മഹത്വപ്പെടുത്തും. ");
INSERT INTO mal2015_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ഇങ്ങനെ ഞാൻ ഫറവോനിലും അവന്റെ രഥങ്ങളിലും കുതിരപ്പടയിലും എന്നെത്തന്നേ മഹത്വപ്പെടുത്തുമ്പോൾ ഞാൻ യഹോവ ആകുന്നു എന്നു മിസ്രയീമ്യർ അറിയും. ");
INSERT INTO mal2015_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","അനന്തരം യിസ്രായേല്യരുടെ സൈന്യത്തിന്നു മുമ്പായി നടന്ന ദൈവദൂതൻ അവിടെനിന്നു മാറി, അവരുടെ പിന്നാലെ നടന്നു; മേഘസ്തംഭവും അവരുടെ മുമ്പിൽ നിന്നു മാറി അവരുടെ പിമ്പിൽ പോയി നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","രാത്രി മുഴുവനും മിസ്രയീമ്യരുടെ സൈന്യവും യിസ്രായേല്യരുടെ സൈന്യവും തമ്മിൽ അടുക്കാതവണ്ണം അതു അവയുടെ മദ്ധ്യേ വന്നു; അവർക്കു മേഘവും അന്ധകാരവും ആയിരുന്നു; ഇവർക്കോ രാത്രിയെ പ്രകാശമാക്കിക്കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","മോശെ കടലിന്മേൽ കൈനീട്ടി; യഹോവ അന്നു രാത്രി മുഴുവനും മഹാശക്തിയുള്ള ഒരു കിഴക്കൻകാറ്റുകൊണ്ടു കടലിനെ പിൻവാങ്ങിച്ചു ഉണങ്ങിയ നിലം ആക്കി; അങ്ങനെ വെള്ളം തമ്മിൽ വേർപിരിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","യിസ്രായേൽമക്കൾ കടലിന്റെ നടുവിൽ ഉണങ്ങിയ നിലത്തുകൂടി നടന്നുപോയി; അവരുടെ ഇടത്തും വലത്തും വെള്ളം മതിലായി നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","മിസ്രയീമ്യർ പിന്തുടർന്നു; ഫറവോന്റെ കുതിരയും രഥങ്ങളും കുതിരപ്പടയും എല്ലാം അവരുടെ പിന്നാലെ കടലിന്റെ നടുവിലേക്കു ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","പ്രഭാതയാമത്തിൽ യഹോവ അഗ്നിമേഘസ്തംഭത്തിൽനിന്നു മിസ്രയീമ്യസൈന്യത്തെ നോക്കി മിസ്രയീമ്യസൈന്യത്തെ താറുമാറാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","അവരുടെ രഥചക്രങ്ങളെ തെറ്റിച്ചു ഓട്ടം പ്രയാസമാക്കി. അതുകൊണ്ടു മിസ്രയീമ്യർ: നാം യിസ്രായേലിനെ വിട്ടു ഓടിപ്പോക; യഹോവ അവർക്കു വേണ്ടി മിസ്രയീമ്യരോടു യുദ്ധം ചെയ്യുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","അപ്പോൾ യഹോവ മോശെയോടു: വെള്ളം മിസ്രയീമ്യരുടെ മേലും അവരുടെ രഥങ്ങളിൻ മേലും കുതിരപ്പടയുടെമേലും മടങ്ങിവരേണ്ടതിന്നു കടലിന്മേൽ കൈനീട്ടുക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","മോശെ കടലിന്മേൽ കൈ നീട്ടി; പുലർച്ചെക്കു കടൽ അതിന്റെ സ്ഥിതിയിലേക്കു മടങ്ങിവന്നു. മിസ്രയീമ്യർ അതിന്നു എതിരായി ഓടി; യഹോവ മിസ്രയീമ്യരെ കടലിന്റെ നടുവിൽ തള്ളിയിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","വെള്ളം മടങ്ങിവന്നു അവരുടെ പിന്നാലെ കടലിലേക്കു ചെന്നിരുന്ന രഥങ്ങളെയും കുതിരപ്പടയെയും ഫറവോന്റെ സൈന്യത്തെയും എല്ലാം മുക്കിക്കളഞ്ഞു; അവരിൽ ഒരുത്തൻ പോലും ശേഷിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","യിസ്രായേൽമക്കൾ കടലിന്റെ നടുവെ ഉണങ്ങിയ നിലത്തുകൂടി കടന്നുപോയി; വെള്ളം അവരുടെ ഇടത്തും വലത്തും മതിലായി നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ഇങ്ങനെ യഹോവ ആ ദിവസം യിസ്രായേല്യരെ മിസ്രയീമ്യരുടെ കയ്യിൽനിന്നു രക്ഷിച്ചു; മിസ്രയീമ്യർ കടൽക്കരയിൽ ചത്തടിഞ്ഞു കിടക്കുന്നതു യിസ്രായേല്യർ കാണുകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","യഹോവ മിസ്രയീമ്യരിൽ ചെയ്ത ഈ മഹാപ്രവൃത്തി യിസ്രായേല്യർ കണ്ടു; ജനം യഹോവയെ ഭയപ്പെട്ടു, യഹോവയിലും അവന്റെ ദാസനായ മോശെയിലും വിശ്വസിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","മോശെയും യിസ്രായേൽമക്കളും അന്നു യഹോവെക്കു സങ്കീർത്തനം പാടി ചൊല്ലിയതു എന്തെന്നാൽ: ഞാൻ യഹോവെക്കു പാട്ടുപാടും, അവൻ മഹോന്നതൻ: കുതിരയെയും അതിന്മേൽ ഇരുന്നവനെയും അവൻ കടലിൽ തള്ളിയിട്ടിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","എന്റെ ബലവും എന്റെ ഗീതവും യഹോവയത്രേ; അവൻ എനിക്കു രക്ഷയായ്തീർന്നു. അവൻ എന്റെ ദൈവം; ഞാൻ അവനെ സ്തുതിക്കും; അവൻ എന്റെ പിതാവിൻ ദൈവം; ഞാൻ അവനെ പുകഴ്ത്തും. ");
INSERT INTO mal2015_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","യഹോവ യുദ്ധവീരൻ; യഹോവ എന്നു അവന്റെ നാമം. ");
INSERT INTO mal2015_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ഫറവോന്റെ രഥങ്ങളെയും സൈന്യത്തെയും അവൻ കടലിൽ തള്ളിയിട്ടു; അവന്റെ രഥിപ്രവരന്മാർ ചെങ്കടലിൽ മുങ്ങിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ആഴി അവരെ മൂടി; അവർ കല്ലുപോലെ ആഴത്തിൽ താണു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","യഹോവേ, നിന്റെ വലങ്കൈ ബലത്തിൽ മഹത്വപ്പെട്ടു; യഹോവേ, നിന്റെ വലങ്കൈ ശത്രുവിനെ തകർത്തുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","നീ എതിരാളികളെ മഹാപ്രഭാവത്താൽ സംഹരിക്കുന്നു; നീ നിന്റെ ക്രോധം അയക്കുന്നു; അതു അവരെ താളടിയെപ്പോലെ ദഹിപ്പിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","നിന്റെ മൂക്കിലെ ശ്വാസത്താൽ വെള്ളം കുന്നിച്ചുകൂടി; പ്രവാഹങ്ങൾ ചിറപോലെ നിന്നു; ആഴങ്ങൾ കടലിന്റെ ഉള്ളിൽ ഉറെച്ചുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ഞാൻ പിന്തുടരും, പിടിക്കും, കൊള്ള പങ്കിടും; എന്റെ ആശ അവരാൽ പൂർത്തിയാകും; ഞാൻ എന്റെ വാൾ ഊരും; എന്റെ കൈ അവരെ നിഗ്രഹിക്കും എന്നു ശത്രു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","നിന്റെ കാറ്റിനെ നീ ഊതിച്ചു, കടൽ അവരെ മൂടി; അവർ ഈയംപോലെ പെരുവെള്ളത്തിൽ താണു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","യഹോവേ, ദേവന്മാരിൽ നിനക്കു തുല്യൻ ആർ? വിശുദ്ധിയിൽ മഹിമയുള്ളവനേ, സ്തുതികളിൽ ഭയങ്കരനേ, അത്ഭുതങ്ങളെ പ്രവർത്തിക്കുന്നവനേ, നിനക്കു തുല്യൻ ആർ? ");
INSERT INTO mal2015_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","നീ വലങ്കൈ നീട്ടി, ഭൂമി അവരെ വിഴുങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","നീ വീണ്ടെടുത്ത ജനത്തെ ദയയാൽ നടത്തി; നിന്റെ വിശുദ്ധനിവാസത്തിലേക്കു നിന്റെ ബലത്താൽ അവരെ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ജാതികൾ കേട്ടു നടങ്ങുന്നു. ഫെലിസ്ത്യനിവാസികൾക്കു ഭീതിപിടിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","എദോമ്യപ്രഭുക്കന്മാർ ഭ്രമിച്ചു; മോവാബ്യമുമ്പന്മാർക്കു കമ്പം പിടിച്ചു; കനാന്യനിവാസികളെല്ലാം ഉരുകിപ്പോകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ഭയവും ഭീതിയും അവരുടെമേൽ വീണു, നിൻഭുജമാഹാത്മ്യത്താൽ അവർ കല്ലുപോലെ ആയി; അങ്ങനെ, യഹോവേ, നിന്റെ ജനം കടന്നു, നീ സമ്പാദിച്ച ജനം കടന്നു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","നീ അവരെ കൊണ്ടുചെന്നു തിരുനിവാസത്തിന്നൊരുക്കിയ സ്ഥാനത്തു, യഹോവേ, നിന്നവകാശപർവ്വതത്തിൽ നീ അവരെ നട്ടു, കർത്താവേ, തൃക്കൈ സ്ഥാപിച്ച വിശുദ്ധ മന്ദിരത്തിങ്കൽ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","യഹോവ എന്നും എന്നേക്കും രാജാവായി വാഴും. ");
INSERT INTO mal2015_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","എന്നാൽ ഫറവോന്റെ കുതിര അവന്റെ രഥവും കുതിരപ്പടയുമായി കടലിന്റെ നടുവിൽ ഇറങ്ങിച്ചെന്നപ്പോൾ യഹോവ കടലിലെ വെള്ളം അവരുടെ മേൽ മടക്കി വരുത്തി; യിസ്രായേൽമക്കളോ കടലിന്റെ നടുവിൽ ഉണങ്ങിയ നിലത്തുകൂടി കടന്നുപോന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","അഹരോന്റെ സഹോദരി മിര്യാം എന്ന പ്രവാചകി കയ്യിൽ തപ്പു എടുത്തു, സ്ത്രീകൾ എല്ലാവരും തപ്പുകളോടും നൃത്തങ്ങളോടും കൂടെ അവളുടെ പിന്നാലെ ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","മിര്യാം അവരോടും പ്രതിഗാനമായി ചൊല്ലിയതു: യഹോവെക്കു പാട്ടുപാടുവിൻ, അവൻ മഹോന്നതൻ: കുതിരയെയും അതിന്മേൽ ഇരുന്നവനെയും അവൻ കടലിൽ തള്ളിയിട്ടിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","അനന്തരം മോശെ യിസ്രായേലിനെ ചെങ്കടലിൽനിന്നു പ്രയാണം ചെയ്യിച്ചു; അവർ ശൂർമരുഭൂമിയിൽ ചെന്നു, മൂന്നു ദിവസം മരുഭൂമിയിൽ വെള്ളം കിട്ടാതെ സഞ്ചരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","മാറയിൽ എത്തിയാറെ, മാറയിലെ വെള്ളം കുടിപ്പാൻ അവർക്കു കഴിഞ്ഞില്ല; അതു കൈപ്പുള്ളതായിരുന്നു. അതുകൊണ്ടു അതിന്നു മാറാ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","അപ്പോൾ ജനം: ഞങ്ങൾ എന്തു കുടിക്കും എന്നു പറഞ്ഞു മോശെയുടെ നേരെ പിറുപിറുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","അവൻ യഹോവയോടു അപേക്ഷിച്ചു; യഹോവ അവന്നു ഒരു വൃക്ഷം കാണിച്ചുകൊടുത്തു. അവൻ അതു വെള്ളത്തിൽ ഇട്ടപ്പോൾ വെള്ളം മധുരമായി തീർന്നു. അവിടെവെച്ചു അവൻ അവർക്കു ഒരു ചട്ടവും പ്രമാണവും നിയമിച്ചു; അവിടെവെച്ചു അവൻ അവരെ പരീക്ഷിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","നിന്റെ ദൈവമായ യഹോവയുടെ വാക്കു നീ ശ്രദ്ധയോടെ കേട്ടു അവന്നു പ്രസാദമുള്ളതു ചെയ്കയും അവന്റെ കല്പനകളെ അനുസരിച്ചു അവന്റെ സകലവിധികളും പ്രമാണിക്കയും ചെയ്താൽ ഞാൻ മിസ്രയീമ്യർക്കു വരുത്തിയ വ്യാധികളിൽ ഒന്നും നിനക്കു വരുത്തുകയില്ല; ഞാൻ നിന്നെ സൗഖ്യമാക്കുന്ന യഹോവ ആകുന്നു എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","പിന്നെ അവർ ഏലീമിൽ എത്തി; അവിടെ പന്ത്രണ്ടു നീരുറവും എഴുപതു ഈത്തപ്പനയും ഉണ്ടായിരുന്നു; അവർ അവിടെ വെള്ളത്തിന്നരികെ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","അവർ ഏലീമിൽനിന്നു യാത്രപുറപ്പെട്ടു; യിസ്രായേൽമക്കൾ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെട്ട രണ്ടാം മാസം പതിനഞ്ചാം തിയ്യതി അവരുടെ സംഘം ഒക്കെയും ഏലീമിന്നും സീനായിക്കും മദ്ധ്യേ ഉള്ള സീൻമരുഭൂമിയിൽ വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ആ മരുഭൂമിയിൽവെച്ചു യിസ്രായേൽമക്കളുടെ സംഘം ഒക്കെയും മോശെക്കും അഹരോന്നും വിരോധമായി പിറുപിറുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","യിസ്രായേൽമക്കൾ അവരോടു: ഞങ്ങൾ ഇറച്ചിക്കലങ്ങളുടെ അടുക്കലിരിക്കയും തൃപ്തിയാകുംവണ്ണം ഭക്ഷണം കഴിക്കയും ചെയ്ത മിസ്രയീംദേശത്തു വെച്ചു യഹോവയുടെ കയ്യാൽ മരിച്ചിരുന്നു എങ്കിൽ കൊള്ളായിരുന്നു. നിങ്ങൾ ഈ സംഘത്തെ മുഴുവനും പട്ടിണിയിട്ടു കൊല്ലുവാൻ ഈ മരുഭൂമിയിലേക്കു കൂട്ടിക്കൊണ്ടു വന്നിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","അപ്പോൾ യഹോവ മോശെയോടു: ഞാൻ നിങ്ങൾക്കു ആകാശത്തുനിന്നു അപ്പം വർഷിപ്പിക്കും; ജനം എന്റെ ന്യായപ്രമാണം അനുസരിക്കുമോ ഇല്ലയോ എന്നു ഞാൻ അവരെ പരീക്ഷിക്കേണ്ടതിന്നു അവർ പുറപ്പെട്ടു ഓരോ ദിവസത്തേക്കു വേണ്ടതു അന്നന്നു പെറുക്കിക്കൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","എന്നാൽ ആറാം ദിവസം അവർ കൊണ്ടുവരുന്നതു ഒരുക്കുമ്പോൾ ദിവസംപ്രതി പെറുക്കുന്നതിന്റെ ഇരട്ടി കാണും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","മോശെയും അഹരോനും യിസ്രായേൽമക്കളോടു ഒക്കെയും: നിങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്നതു യഹോവ തന്നേ എന്നു ഇന്നു വൈകുന്നേരം നിങ്ങൾ അറിയും. ");
INSERT INTO mal2015_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","പ്രഭാതകാലത്തു നിങ്ങൾ യഹോവയുടെ തേജസ്സു കാണും; യഹോവയുടെ നേരെയുള്ള നിങ്ങളുടെ പിറുപിറുപ്പു അവൻ കേട്ടിരിക്കുന്നു; നിങ്ങൾ ഞങ്ങളുടെ നേരെ പിറുപിറുക്കുവാൻ ഞങ്ങൾ എന്തുള്ളു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","മോശെ പിന്നെയും: യഹോവ നിങ്ങൾക്കു തിന്നുവാൻ വൈകുന്നേരത്തു മാംസവും പ്രഭാതകാലത്തു തൃപ്തിയാകുംവണ്ണം അപ്പവും തരുമ്പോൾ നിങ്ങൾ അറിയും; യഹോവയുടെ നേരെ നിങ്ങൾ പിറുപിറുക്കുന്നതു അവൻ കേൾക്കുന്നു; ഞങ്ങൾ എന്തുള്ളു? നിങ്ങളുടെ പിറുപിറുപ്പു ഞങ്ങളുടെ നേരെയല്ല, യഹോവയുടെ നേരെയത്രേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","അഹരോനോടു: മോശെ: യഹോവയുടെ മുമ്പാകെ അടുത്തുവരുവിൻ; അവൻ നിങ്ങളുടെ പിറുപിറുപ്പു കേട്ടിരിക്കുന്നു എന്നു യിസ്രായേൽമക്കളുടെ സർവ്വസംഘത്തോടും പറക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","അഹരോൻ യിസ്രായേൽമക്കളുടെ സർവ്വസംഘത്തോടും സംസാരിക്കുമ്പോൾ അവർ മരുഭൂമിക്കു നേരെ തിരിഞ്ഞുനോക്കി, യഹോവയുടെ തേജസ്സു മേഘത്തിൽ വെളിപ്പെട്ടിരിക്കുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","യഹോവ മോശെയോടു: യിസ്രായേൽമക്കളുടെ പിറുപിറുപ്പു ഞാൻ കേട്ടിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","നീ അവരോടു സംസാരിച്ചു: നിങ്ങൾ വൈകുന്നേരത്തു മാംസം തിന്നും; പ്രഭാതകാലത്തു അപ്പംകൊണ്ടു തൃപ്തരാകും; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു എന്നു നിങ്ങൾ അറിയും എന്നു പറക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","വൈകുന്നേരം കാടകൾ വന്നു പാളയത്തെ മൂടി; പ്രഭാതകാലത്തു പാളയത്തിന്റെ ചുറ്റും മഞ്ഞു വീണുകിടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","വീണുകിടന്ന മഞ്ഞു മാറിയ ശേഷം മരുഭൂമിയിൽ എല്ലാടവും ചെതുമ്പലിന്റെ മാതിരിയിൽ ഒരു നേരിയ വസ്തു ഉറെച്ച മഞ്ഞുപോലെ നിലത്തു കിടക്കുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","യിസ്രായേൽമക്കൾ അതു കണ്ടാറെ എന്തെന്നു അറിയായ്കയാൽ ഇതെന്തു എന്നു തമ്മിൽ തമ്മിൽ ചോദിച്ചു. മോശെ അവരോടു: ഇതു യഹോവ നിങ്ങൾക്കു ഭക്ഷിപ്പാൻ തന്നിരിക്കുന്ന ആഹാരം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ഓരോരുത്തന്നു ഭക്ഷിക്കാകുന്നെടത്തോളം പെറുക്കിക്കൊൾവിൻ; താന്താന്റെ കൂടാരത്തിലുള്ളവരുടെ എണ്ണത്തിന്നൊത്തവണ്ണം ആളൊന്നിന്നു ഇടങ്ങഴിവീതം എടുത്തുകൊള്ളേണം എന്നു യഹോവ കല്പിച്ചിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","യിസ്രായേൽമക്കൾ അങ്ങനെ ചെയ്തു. ചിലർ ഏറെയും ചിലർ കുറെയും പെറുക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ഇടങ്ങഴികൊണ്ടു അളന്നപ്പോൾ ഏറെ പെറുക്കിയവന്നു ഏറെയും കുറെ പെറുക്കിയവന്നു കുറവും കണ്ടില്ല; ഓരോരുത്തൻ താന്താന്നു ഭക്ഷിക്കാകുന്നെടത്തോളം പെറുക്കിയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","പിറ്റെന്നാളേക്കു ആരും ഒട്ടും ശേഷിപ്പിക്കരുതെന്നു മോശെ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","എങ്കിലും ചിലർ മോശെയെ അനുസരിക്കാതെ പിറ്റെന്നാളേക്കു കുറെ ശേഷിപ്പിച്ചു; അതു കൃമിച്ചു നാറി; മോശെ അവരോടു കോപിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","അവർ രാവിലെതോറും അവനവന്നു ഭക്ഷിക്കാകുന്നേടത്തോളം പെറുക്കും; വെയിൽ മൂക്കുമ്പോൾ അതു ഉരുകിപ്പോകും. ");
INSERT INTO mal2015_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","എന്നാൽ ആറാം ദിവസം അവർ ആളൊന്നിന്നു ഈരണ്ടിടങ്ങഴിവീതം ഇരട്ടി ആഹാരം ശേഖരിച്ചു. അപ്പോൾ സംഘപ്രമാണികൾ എല്ലാവരും വന്നു മോശെയോടു അറിയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","അവൻ അവരോടു: അതു യഹോവ കല്പിച്ചതു തന്നേ; നാളെ സ്വസ്ഥത ആകുന്നു; യഹോവെക്കു വിശുദ്ധമായുള്ള ശബ്ബത്തു. ചുടുവാനുള്ളതു ചുടുവിൻ; പാകം ചെയ്‌വാനുള്ളതു പാകം ചെയ്‌വിൻ; ശേഷിക്കുന്നതൊക്കെയും നാളത്തേക്കു സൂക്ഷിച്ചുവെപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","മോശെ കല്പിച്ചതുപോലെ അവർ അതു പിറ്റെന്നാളേക്കു സൂക്ഷിച്ചുവെച്ചു; അതു നാറിപ്പോയില്ല, കൃമിച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","അപ്പോൾ മോശെ പറഞ്ഞതു: ഇതു ഇന്നു ഭക്ഷിപ്പിൻ; ഇന്നു യഹോവയുടെ ശബ്ബത്ത് ആകുന്നു; ഇന്നു അതു വെളിയിൽ കാണുകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ആറു ദിവസം നിങ്ങൾ അതു പെറുക്കേണം; ശബ്ബത്തായ ഏഴാം ദിവസത്തിലോ അതു ഉണ്ടാകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","എന്നാൽ ഏഴാംദിവസം ജനത്തിൽ ചിലർ പെറുക്കുവാൻ പോയാറെ കണ്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","അപ്പോൾ യഹോവ മോശെയോടു: എന്റെ കല്പനകളും ന്യായപ്രമാണങ്ങളും പ്രമാണിപ്പാൻ നിങ്ങൾക്കു എത്രത്തോളം മനസ്സില്ലാതിരിക്കും? ");
INSERT INTO mal2015_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","നോക്കുവിൻ, യഹോവ നിങ്ങൾക്കു ശബ്ബത്ത് തന്നിരിക്കുന്നു; അതുകൊണ്ടു ആറാം ദിവസം അവൻ നിങ്ങൾക്കു രണ്ടു ദിവസത്തേക്കുള്ള ആഹാരം തരുന്നു; നിങ്ങൾ താന്താങ്ങളുടെ സ്ഥലത്തു ഇരിപ്പിൻ; ഏഴാം ദിവസം ആരും തന്റെ സ്ഥലത്തുനിന്നു പുറപ്പെടരുതു എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","അങ്ങനെ ജനം ഏഴാം ദിവസം സ്വസ്ഥമായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","യിസ്രായേല്യർ ആ സാധനത്തിന്നു മന്നാ എന്നു പേരിട്ടു; അതു കൊത്തമ്പാലരിപോലെയും വെള്ളനിറമുള്ളതും തേൻകൂട്ടിയ ദോശയോടൊത്ത രുചിയുള്ളതും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","പിന്നെ മോശെ: യഹോവ കല്പിക്കുന്ന കാര്യം ആവിതു: ഞാൻ നിങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവരുമ്പോൾ നിങ്ങൾക്കു മരുഭൂമിയിൽ ഭക്ഷിപ്പാൻ തന്ന ആഹാരം നിങ്ങളുടെ തലമുറകൾ കാണേണ്ടതിന്നു സൂക്ഷിച്ചുവെപ്പാൻ അതിൽനിന്നു ഒരിടങ്ങഴി നിറച്ചെടുക്കേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","അഹരോനോടു മോശെ: ഒരു പാത്രം എടുത്തു അതിൽ ഒരു ഇടങ്ങഴി മന്നാ ഇട്ടു നിങ്ങളുടെ തലമുറകൾക്കുവേണ്ടി സൂക്ഷിപ്പാൻ യഹോവയുടെ മുമ്പാകെ വെച്ചുകൊൾക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ അഹരോൻ അതു സാക്ഷ്യസന്നിധിയിൽ സൂക്ഷിച്ചുവെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","കുടിപാർപ്പുള്ള ദേശത്തു എത്തുവോളം യിസ്രായേൽമക്കൾ നാല്പതു സംവത്സരം മന്നാ ഭക്ഷിച്ചു. കനാൻദേശത്തിന്റെ അതിരിൽ എത്തുവോളം അവർ മന്നാ ഭക്ഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ഒരു ഇടങ്ങഴി (ഓമെർ) പറ (ഏഫ)യുടെ പത്തിൽ ഒന്നു ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","അനന്തരം യിസ്രായേൽമക്കളുടെ സംഘം എല്ലാം സീൻമരുഭൂമിയിൽനിന്നു പുറപ്പെട്ടു, യഹോവയുടെ കല്പനപ്രകാരം ചെയ്ത പ്രയാണങ്ങളിൽ രെഫീദീമിൽ എത്തി പാളയമിറങ്ങി; അവിടെ ജനത്തിന്നു കുടിപ്പാൻ വെള്ളമില്ലായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","അതുകൊണ്ടു ജനം മോശെയോടു: ഞങ്ങൾക്കു കുടിപ്പാൻ വെള്ളം തരിക എന്നു കലഹിച്ചു പറഞ്ഞതിന്നു മോശെ അവരോടു: നിങ്ങൾ എന്നോടു എന്തിന്നു കലഹിക്കുന്നു? നിങ്ങൾ യഹോവയെ പരീക്ഷിക്കുന്നതു എന്തു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ജനത്തിന്നു അവിടെവെച്ചു നന്നാ ദാഹിച്ചതുകൊണ്ടു ജനം മോശെയുടെ നേരെ പിറുപിറുത്തു: ഞങ്ങളും മക്കളും ഞങ്ങളുടെ മൃഗങ്ങളും ദാഹംകൊണ്ടു ചാകേണ്ടതിന്നു നീ ഞങ്ങളെ മിസ്രയീമിൽനിന്നു കൊണ്ടുവന്നതു എന്തിന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","മോശെ യഹോവയോടു നിലവിളിച്ചു: ഈ ജനത്തിന്നു ഞാൻ എന്തു ചെയ്യേണ്ടു? അവർ എന്നെ കല്ലെറിവാൻ പോകുന്നുവല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","യഹോവ മോശെയോടു: യിസ്രായേൽമൂപ്പന്മാരിൽ ചിലരെ കൂട്ടിക്കൊണ്ടു നീ നദിയെ അടിച്ച വടിയും കയ്യിൽ എടുത്തു ജനത്തിന്റെ മുമ്പാകെ കടന്നുപോക. ");
INSERT INTO mal2015_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ഞാൻ ഹോരേബിൽ നിന്റെ മുമ്പാകെ പാറയുടെ മേൽ നില്ക്കും; നീ പാറയെ അടിക്കേണം; ഉടനെ ജനത്തിന്നു കുടിപ്പാൻ വെള്ളം അതിൽനിന്നു പുറപ്പെടും എന്നു കല്പിച്ചു. യിസ്രായേൽമൂപ്പന്മാർ കാൺകെ മോശെ അങ്ങനെ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","യിസ്രായേൽമക്കളുടെ കലഹം നിമിത്തവും യഹോവ ഞങ്ങളുടെ ഇടയിൽ ഉണ്ടോ ഇല്ലയോ എന്നു അവർ യഹോവയെ പരീക്ഷിക്ക നിമിത്തവും അവൻ ആ സ്ഥലത്തിന്നു മസ്സാ (പരീക്ഷ) എന്നും മെരീബാ (കലഹം) എന്നും പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","രെഫീദീമിൽവെച്ചു അമാലേക്ക് വന്നു യിസ്രായേലിനോടു യുദ്ധംചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","അപ്പോൾ മോശെ യോശുവയോടു: നീ ആളുകളെ തിരഞ്ഞെടുത്തു പുറപ്പെട്ടു അമാലേക്കിനോടു യുദ്ധം ചെയ്ക; ഞാൻ നാളെ കുന്നിൻ മുകളിൽ ദൈവത്തിന്റെ വടി കയ്യിൽ പിടിച്ചുംകൊണ്ടു നില്ക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","മോശെ തന്നോടു പറഞ്ഞതുപോലെ യോശുവ ചെയ്തു, അമാലേക്കിനോടു പൊരുതു; എന്നാൽ മോശെയും അഹരോനും ഹൂരും കുന്നിൻമുകളിൽ കയറി. ");
INSERT INTO mal2015_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","മോശെ കൈ ഉയർത്തിയിരിക്കുമ്പോൾ യിസ്രായേൽ ജയിക്കും; കൈ താഴ്ത്തിയിരിക്കുമ്പോൾ അമാലേക്ക് ജയിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","എന്നാൽ മോശെയുടെ കൈ ഭാരം തോന്നിയപ്പോൾ അവർ ഒരു കല്ലു എടുത്തുവെച്ചു, അവൻ അതിന്മേൽ ഇരുന്നു; അഹരോനും ഹൂരും ഒരുത്തൻ ഇപ്പുറത്തും ഒരുത്തൻ അപ്പുറത്തും നിന്നു അവന്റെ കൈ താങ്ങി; അങ്ങനെ അവന്റെ കൈ സൂര്യൻ അസ്തമിക്കുംവരെ ഉറെച്ചുനിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","യോശുവ അമാലേക്കിനെയും അവന്റെ ജനത്തെയും വാളിന്റെ വായ്ത്തലയാൽ തോല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","യഹോവ മോശെയോടു: നീ ഇതു ഓർമ്മെക്കായിട്ടു ഒരു പുസ്തകത്തിൽ എഴുതി യോശുവയെ കേൾപ്പിക്ക; ഞാൻ അമാലേക്കിന്റെ ഓർമ്മ ആകാശത്തിന്റെ കീഴിൽനിന്നു അശേഷം മായിച്ചുകളയും എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","പിന്നെ മോശെ ഒരു യാഗപീഠം പണിതു, അതിന്നു യഹോവനിസ്സി (യഹോവ എന്റെ കൊടി) എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","യഹോവയുടെ സിംഹാസനത്താണ യഹോവെക്കു അമാലേക്കിനോടു തലമുറതലമുറയായി യുദ്ധം ഉണ്ടു എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ദൈവം മോശെക്കും തന്റെ ജനമായ യിസ്രായേലിന്നും വേണ്ടി ചെയ്തതു ഒക്കെയും യഹോവ യിസ്രായേലിനെ മിസ്രയീമിൽ നിന്നു പുറപ്പെടുവിച്ചതും മിദ്യാനിലെ പുരോഹിതനായി മോശെയുടെ അമ്മായപ്പനായ യിത്രോ കേട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","അപ്പോൾ മോശെയുടെ അമ്മായപ്പനായ യിത്രോ മോശെ മടക്കി അയച്ചിരുന്ന അവന്റെ ഭാര്യ സിപ്പോറയെയും അവളുടെ രണ്ടു പുത്രന്മാരെയും കൂട്ടിക്കൊണ്ടു പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ഞാൻ അന്യദേശത്തു പരദേശിയായി എന്നു അവൻ പറഞ്ഞതുകൊണ്ടു അവരിൽ ഒരുത്തന്നു ഗേർഷോം എന്നു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","എന്റെ പിതാവിന്റെ ദൈവം എനിക്കു തുണയായി എന്നെ ഫറവോന്റെ വാളിങ്കൽനിന്നു രക്ഷിച്ചു എന്നു അവൻ പറഞ്ഞതുകൊണ്ടു മററവന്നു എലീയേസെർ എന്നു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","എന്നാൽ മോശെയുടെ അമ്മായപ്പനായ യിത്രോ അവന്റെ പുത്രന്മാരോടും അവന്റെ ഭാര്യയോടുംകൂടെ, മോശെ പാളയമിറങ്ങിയിരുന്ന മരുഭൂമിയിൽ ദൈവത്തിന്റെ പർവ്വതത്തിങ്കൽ അവന്റെ അടുക്കൽ വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","നിന്റെ അമ്മായപ്പൻ യിത്രോ എന്ന ഞാനും നിന്റെ ഭാര്യയും രണ്ടു പുത്രന്മാരും നിന്റെ അടുക്കൽ വന്നിരിക്കുന്നു എന്നു അവൻ മോശെയോടു പറയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","മോശെ തന്റെ അമ്മായപ്പനെ എതിരേല്പാൻ ചെന്നു വണങ്ങി അവനെ ചുംബിച്ചു; അവർ തമ്മിൽ കുശലപ്രശ്നം ചെയ്തു കൂടാരത്തിൽ വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","മോശെ തന്റെ അമ്മായപ്പനോടു യഹോവ യിസ്രായേലിന്നുവേണ്ടി ഫറവോനോടും മിസ്രയീമ്യരോടും ചെയ്തതു ഒക്കെയും വഴിയിൽ തങ്ങൾക്കു നേരിട്ട പ്രയാസം ഒക്കെയും യഹോവ തങ്ങളെ രക്ഷിച്ചപ്രകാരവും വിവരിച്ചു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","യഹോവ മിസ്രയീമ്യരുടെ കയ്യിൽനിന്നു യിസ്രായേലിനെ വിടുവിച്ചതിനാൽ അവർക്കു ചെയ്ത എല്ലാനന്മനിമിത്തവും യിത്രോ സന്തോഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","യിത്രോ പറഞ്ഞതെന്തെന്നാൽ: നിങ്ങളെ മിസ്രയീമ്യരുടെ കയ്യിൽനിന്നും ഫറവോന്റെ കയ്യിൽനിന്നും രക്ഷിച്ചു മിസ്രയീമ്യരുടെ കൈക്കീഴിൽനിന്നു ജനത്തെ വിടുവിച്ചിരിക്കുന്ന യഹോവ സ്തുതിക്കപ്പെടുമാറാകട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","യഹോവ സകലദേവന്മാരിലും വലിയവൻ എന്നു ഞാൻ ഇപ്പോൾ അറിയുന്നു. അതേ, ഇവരോടു അവർ അഹങ്കരിച്ച കാര്യത്തിൽ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","മോശെയുടെ അമ്മായപ്പനായ യിത്രോ ദൈവത്തിന്നു ഹോമവും ഹനനയാഗവും കഴിച്ചു; അഹരോനും യിസ്രായേൽമൂപ്പന്മാരെല്ലാവരും വന്നു മോശെയുടെ അമ്മായപ്പനോടുകൂടെ ദൈവസന്നിധിയിൽ ഭക്ഷണം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","പിറ്റെന്നാൾ മോശെ ജനത്തിന്നു ന്യായം വിധിപ്പാൻ ഇരുന്നു; ജനം രാവിലെ തുടങ്ങി വൈകുന്നേരം വരെ മോശെയുടെ ചുറ്റും നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","അവൻ ജനത്തിന്നുവേണ്ടി ചെയ്യുന്നതൊക്കെയും മോശെയുടെ അമ്മായപ്പൻ കണ്ടപ്പോൾ: നീ ജനത്തിന്നുവേണ്ടി ചെയ്യുന്ന ഈ കാര്യം എന്തു? നീ ഏകനായി വിസ്തരിപ്പാൻ ഇരിക്കയും ജനം ഒക്കെയും രാവിലേ തുടങ്ങി വൈകുന്നേരം വരെ നിന്റെ ചുറ്റും നിൽക്കയും ചെയ്യുന്നതു എന്തു എന്നു അവൻ ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","മോശെ തന്റെ അമ്മായപ്പനോടു: ദൈവത്തോടു ചോദിപ്പാൻ ജനം എന്റെ അടുക്കൽ വരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","അവർക്കു ഒരു കാര്യം ഉണ്ടാകുമ്പോൾ അവർ എന്റെ അടുക്കൽ വരും. അവർക്കു തമ്മിലുള്ള കാര്യം ഞാൻ കേട്ടു വിധിക്കയും ദൈവത്തിന്റെ കല്പനകളും പ്രമാണങ്ങളും അവരെ അറിയിക്കയും ചെയ്യും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","അതിന്നു മോശെയുടെ അമ്മായപ്പൻ അവനോടു പറഞ്ഞതു: ");
INSERT INTO mal2015_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","നീ ചെയ്യുന്ന കാര്യം നന്നല്ല; നീയും നിന്നോടുകൂടെയുള്ള ഈ ജനവും ക്ഷീണിച്ചുപോകും; ഈ കാര്യം നിനക്കു അതിഭാരമാകുന്നു; ഏകനായി അതു നിവർത്തിപ്പാൻ നിനക്കു കഴിയുന്നതല്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ആകയാൽ എന്റെ വാക്കു കേൾക്ക; ഞാൻ ഒരാലോചന പറഞ്ഞുതരാം. ദൈവം നിന്നോടുകൂടെ ഇരിക്കും; നീ ജനത്തിന്നുവേണ്ടി ദൈവസന്നിധിയിൽ ഇരിക്ക; നീ കാര്യങ്ങളെ ദൈവസന്നിധിയിൽ കൊണ്ടുചെല്ലുക. ");
INSERT INTO mal2015_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","അവർക്കു കല്പനകളും പ്രമാണങ്ങളും ഉപദേശിക്കയും നടക്കേണ്ടുന്ന വഴിയും ചെയ്യേണ്ടുന്ന പ്രവൃത്തിയും അവരെ അറിയിക്കയും ചെയ്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","അതല്ലാതെ, ദൈവഭക്തന്മാരും സത്യവാന്മാരും ദുരാദായം വെറുക്കുന്നവരുമായ പ്രാപ്തിയുള്ള പുരുഷന്മാരെ സകലജനത്തിൽനിന്നും തിരഞ്ഞെടുത്തു അവരെ ആയിരംപേർക്കു അധിപതിമാരായും നൂറുപേർക്കു അധിപതിമാരായും അമ്പതുപേർക്കു അധിപതിമാരായും പത്തുപേർക്കു അധിപതിമാരായും നിയമിക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","അവർ എല്ലാസമയത്തും ജനത്തിന്നു ന്യായം വിധിക്കട്ടെ; വലിയ കാര്യം ഒക്കെയും അവർ നിന്റെ അടുക്കൽ കൊണ്ടുവരട്ടെ; ചെറിയ കാര്യം ഒക്കെയും അവർ തന്നേ തീർക്കട്ടെ; ഇങ്ങനെ അവർ നിന്നോടുകൂടെ വഹിക്കുന്നതിനാൽ നിനക്കു ഭാരം കുറയും. ");
INSERT INTO mal2015_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","നീ ഈ കാര്യം ചെയ്കയും ദൈവം അതു അനുവദിക്കയും ചെയ്താൽ നിനക്കു നിന്നുപൊറുക്കാം. ഈ ജനത്തിന്നൊക്കെയും സമാധാനത്തോടെ തങ്ങളുടെ സ്ഥലത്തേക്കു പോകയുമാം. ");
INSERT INTO mal2015_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","മോശെ തന്റെ അമ്മായപ്പന്റെ വാക്കു കേട്ടു, അവൻ പറഞ്ഞതുപോലെ ഒക്കെയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","മോശെ എല്ലായിസ്രായേലിൽനിന്നും പ്രാപ്തിയുള്ള പുരുഷന്മാരെ തിരഞ്ഞെടുത്തു അവരെ ആയിരംപേർക്കു അധിപതിമാരായും നൂറുപേർക്കു അധിപതിമാരായും അമ്പതുപേർക്കു അധിപതിമാരായും പത്തുപേർക്കു അധിപതിമാരായും ജനത്തിന്നു തലവന്മാരാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","അവർ എല്ലാസമയത്തും ജനത്തിന്നു ന്യായംവിധിച്ചു വന്നു; വിഷമമുള്ള കാര്യം അവർ മോശെയുടെ അടുക്കൽ കൊണ്ടുവരും; ചെറിയ കാര്യം ഒക്കെയും അവർ തന്നേ തീർക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","അതിന്റെ ശേഷം മോശെ തന്റെ അമ്മായപ്പനെ യാത്ര അയച്ചു; അവൻ സ്വദേശത്തേക്കു മടങ്ങിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","യിസ്രായേൽമക്കൾ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെട്ടതിന്റെ മൂന്നാം മാസത്തിൽ അതേദിവസം അവർ സീനായിമരുഭൂമിയിൽ എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","അവർ രെഫീദീമിൽനിന്നു യാത്ര പുറപ്പെട്ടു, സീനായിമരുഭൂമിയിൽ വന്നു, മരുഭൂമിയിൽ പാളയമിറങ്ങി; അവിടെ പർവ്വതത്തിന്നു എതിരെ യിസ്രായേൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","മോശെ ദൈവത്തിന്റെ അടുക്കൽ കയറിച്ചെന്നു; യഹോവ പർവ്വതത്തിൽനിന്നു അവനോടു വിളിച്ചു കല്പിച്ചതു: നീ യാക്കോബ് ഗൃഹത്തോടു പറകയും യിസ്രായേൽമക്കളോടു അറിയിക്കയും ചെയ്യേണ്ടതെന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","ഞാൻ മിസ്രയീമ്യരോടു ചെയ്തതും നിങ്ങളെ കഴുകന്മാരുടെ ചിറകിന്മേൽ വഹിച്ചു എന്റെ അടുക്കൽ വരുത്തിയതും നിങ്ങൾ കണ്ടുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ആകയാൽ നിങ്ങൾ എന്റെ വാക്കു കേട്ടു അനുസരിക്കയും എന്റെ നിയമം പ്രമാണിക്കയും ചെയ്താൽ നിങ്ങൾ എനിക്കു സകലജാതികളിലുംവെച്ചു പ്രത്യേക സമ്പത്തായിരിക്കും; ഭൂമി ഒക്കെയും എനിക്കുള്ളതല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","നിങ്ങൾ എനിക്കു ഒരു പുരോഹിതരാജത്വവും വിശുദ്ധജനവും ആകും. ഇവ നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടുന്ന വചനങ്ങൾ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","മോശെ വന്നു ജനത്തിന്റെ മൂപ്പന്മാരെ വിളിച്ചു, യഹോവ തന്നോടു കല്പിച്ച ഈ വചനങ്ങളൊക്കെയും അവരെ പറഞ്ഞു കേൾപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","യഹോവ കല്പിച്ചതൊക്കെയും ഞങ്ങൾ ചെയ്യും എന്നു ജനം ഉത്തരം പറഞ്ഞു. മോശെ ജനത്തിന്റെ വാക്കു യഹോവയുടെ സന്നിധിയിൽ ബോധിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","യഹോവ മോശെയോടു: ഞാൻ നിന്നോടു സംസാരിക്കുമ്പോൾ ജനം കേൾക്കേണ്ടതിന്നും നിന്നെ എന്നേക്കും വിശ്വസിക്കേണ്ടതിന്നും ഞാൻ ഇതാ, മേഘതമസ്സിൽ നിന്റെ അടുക്കൽ വരുന്നു എന്നു അരുളിച്ചെയ്തു, ജനത്തിന്റെ വാക്കു മോശെ യഹോവയോടു ബോധിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു: നീ ജനത്തിന്റെ അടുക്കൽ ചെന്നു ഇന്നും നാളെയും അവരെ ശുദ്ധീകരിക്ക; ");
INSERT INTO mal2015_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","അവർ വസ്ത്രം അലക്കി, മൂന്നാം ദിവസത്തേക്കു ഒരുങ്ങിയിരിക്കട്ടെ; മൂന്നാം ദിവസം യഹോവ സകല ജനവും കാൺകെ സീനായിപർവ്വത്തിൽ ഇറങ്ങും. ");
INSERT INTO mal2015_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ജനം പർവ്വതത്തിൽ കയറാതെയും അതിന്റെ അടിവാരം തൊടാതെയും ഇരിപ്പാൻ സൂക്ഷിക്കേണം എന്നു പറഞ്ഞു നീ അവർക്കായി ചുറ്റും അതിർ തിരിക്കേണം; പർവ്വതം തൊടുന്നവൻ എല്ലാം മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","കൈ തൊടാതെ അവനെ കല്ലെറിഞ്ഞോ എയ്തോ കൊന്നുകളയേണം; മൃഗമായാലും മനുഷ്യനായാലും ജീവനോടിരിക്കരുതു. കാഹളം ദീർഘമായി ധ്വനിക്കുമ്പോൾ അവർ പർവ്വതത്തിന്നു അടുത്തുവരട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","മോശെ പർവ്വതത്തിൽനിന്നു ജനത്തിന്റെ അടുക്കൽ ഇറങ്ങിച്ചെന്നു ജനത്തെ ശുദ്ധീകരിച്ചു; അവർ വസ്ത്രം അലക്കുകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","അവൻ ജനത്തോടു: മൂന്നാം ദിവസത്തേക്കു ഒരുങ്ങിയിരിപ്പിൻ; നിങ്ങളുടെ ഭാര്യമാരുടെ അടുക്കൽ ചെല്ലരുതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","മൂന്നാം ദിവസം നേരം വെളുത്തപ്പോൾ ഇടിമുഴക്കവും മിന്നലും പർവ്വതത്തിൽ കാർമേഘവും മഹാഗംഭീരമായ കാഹളധ്വനിയും ഉണ്ടായി; പാളയത്തിലുള്ള ജനം ഒക്കെയും നടുങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ദൈവത്തെ എതിരേല്പാൻ മോശെ ജനത്തെ പാളയത്തിൽനിന്നു പുറപ്പെടുവിച്ചു; അവർ പർവ്വതത്തിന്റെ അടിവാരത്തു നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","യഹോവ തീയിൽ സീനായി പർവ്വതത്തിൽ ഇറങ്ങുകയാൽ അതു മുഴുവനും പുകകൊണ്ടു മൂടി; അതിന്റെ പുക തീച്ചൂളയിലെ പുകപോലെ പൊങ്ങി; പർവ്വതം ഒക്കെയും ഏറ്റവും കുലുങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","കാഹളധ്വനി ദീർഘമായി ഉറച്ചുറച്ചു വന്നപ്പോൾ മോശെ സംസാരിച്ചു; ദൈവം ഉച്ചത്തിൽ അവനോടു ഉത്തരം അരുളി. ");
INSERT INTO mal2015_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","യഹോവ സീനായി പർവ്വതത്തിൽ പർവ്വതത്തിന്റെ കൊടുമുടിയിൽ ഇറങ്ങി; യഹോവ മോശെയെ പർവ്വതത്തിന്റെ കൊടുമുടിയിലേക്കു വിളിച്ചു; മോശെ കയറിച്ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","യഹോവ മോശെയോടു കല്പിച്ചതെന്തെന്നാൽ: ജനം നോക്കേണ്ടതിന്നു യഹോവയുടെ അടുക്കൽ കടന്നുവന്നിട്ടു അവരിൽ പലരും നശിച്ചുപോകാതിരിപ്പാൻ നീ ഇറങ്ങിച്ചെന്നു അവരോടു അമർച്ചയായി കല്പിക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","യഹോവയോടു അടുക്കുന്ന പുരോഹിതന്മാരും യഹോവ അവർക്കു ഹാനി വരുത്താതിരിക്കേണ്ടതിന്നു തങ്ങളെ ശുദ്ധീകരിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","മോശെ യഹോവയോടു: ജനത്തിന്നു സീനായിപർവ്വത്തിൽ കയറുവാൻ പാടില്ല; പർവ്വതത്തിന്നു അതിർ തിരിച്ചു അതിനെ ശുദ്ധമാക്കുക എന്നു ഞങ്ങളോടു അമർച്ചയായി കല്പിച്ചിട്ടുണ്ടല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","യഹോവ അവനോടു: ഇറങ്ങിപ്പോക; നീ അഹരോനുമായി കയറിവരിക; എന്നാൽ പുരോഹിതന്മാരും ജനവും യഹോവ അവർക്കു നാശം വരുത്താതിരിക്കേണ്ടതിന്നു അവന്റെ അടുക്കൽ കയറുവാൻ അതിർ കടക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","അങ്ങനെ മോശെ ജനത്തിന്റെ അടുക്കൽ ഇറങ്ങിച്ചെന്നു അവരോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ദൈവം ഈ വചനങ്ങളൊക്കെയും അരുളിച്ചെയ്തു: ");
INSERT INTO mal2015_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","അടിമവീടായ മിസ്രയീംദേശത്തുനിന്നു നിന്നെ കൊണ്ടുവന്ന യഹോവയായ ഞാൻ നിന്റെ ദൈവം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","ഞാനല്ലാതെ അന്യദൈവങ്ങൾ നിനക്കു ഉണ്ടാകരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","ഒരു വിഗ്രഹം ഉണ്ടാക്കരുതു; മീതെ സ്വർഗ്ഗത്തിൽ എങ്കിലും താഴെ ഭൂമിയിൽ എങ്കിലും ഭൂമിക്കു കീഴെ വെള്ളത്തിൽ എങ്കിലും ഉള്ള യാതൊന്നിന്റെ പ്രതിമയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","അവയെ നമസ്കരിക്കയോ സേവിക്കയോ ചെയ്യരുതു. നിന്റെ ദൈവമായ യഹോവയായ ഞാൻ തീക്ഷ്ണതയുള്ള ദൈവം ആകുന്നു; എന്നെ പകെക്കുന്നവരിൽ പിതാക്കന്മാരുടെ അകൃത്യം മൂന്നാമത്തെയും നാലാമത്തെയും തലമുറവരെ മക്കളുടെ മേൽ സന്ദർശിക്കയും ");
INSERT INTO mal2015_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","എന്നെ സ്നേഹിച്ചു എന്റെ കല്പനകളെ പ്രമാണിക്കുന്നവർക്കു ആയിരം തലമുറ വരെ ദയ കാണിക്കയും ചെയ്യുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","നിന്റെ ദൈവമായ യഹോവയുടെ നാമം വൃഥാ എടുക്കരുതു; തന്റെ നാമം വൃഥാ എടുക്കുന്നവനെ യഹോവ ശിക്ഷിക്കാതെ വിടുകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ശബ്ബത്ത് നാളിനെ ശുദ്ധീകരിപ്പാൻ ഓർക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ആറു ദിവസം അദ്ധ്വാനിച്ചു നിന്റെ വേല ഒക്കെയും ചെയ്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ഏഴാം ദിവസം നിന്റെ ദൈവമായ യഹോവയുടെ ശബ്ബത്ത് ആകുന്നു; അന്നു നീയും നിന്റെ പുത്രനും പുത്രിയും നിന്റെ വേലക്കാരനും വേലക്കാരത്തിയും നിന്റെ കന്നുകാലികളും നിന്റെ പടിവാതിൽക്കകത്തുള്ള പരദേശിയും ഒരു വേലയും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ആറു ദിവസംകൊണ്ടു യഹോവ ആകാശവും ഭൂമിയും സമുദ്രവും അവയിലുള്ളതൊക്കെയും ഉണ്ടാക്കി, ഏഴാം ദിവസം സ്വസ്ഥമായിരുന്നു; അതുകൊണ്ടു യഹോവ ശബ്ബത്തുനാളിനെ അനുഗ്രഹിച്ചു ശുദ്ധീകരിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","നിന്റെ ദൈവമായ യഹോവ നിനക്കു തരുന്ന ദേശത്തു നിനക്കു ദീർഘായുസ്സുണ്ടാകുവാൻ നിന്റെ അപ്പനെയും അമ്മയെയും ബഹുമാനിക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","കൊല ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","വ്യഭിചാരം ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","മോഷ്ടിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","കൂട്ടുകാരന്റെ നേരെ കള്ളസ്സാക്ഷ്യം പറയരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","കൂട്ടുകാരന്റെ ഭവനത്തെ മോഹിക്കരുതു; കൂട്ടുകാരന്റെ ഭാര്യയെയും അവന്റെ ദാസനെയും ദാസിയെയും അവന്റെ കാളയെയും കഴുതയെയും കൂട്ടുകാരനുള്ള യാതൊന്നിനെയും മോഹിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ജനം ഒക്കെയും ഇടിമുഴക്കവും മിന്നലും കാഹളധ്വനിയും പർവ്വതം പുകയുന്നതും കണ്ടു; ജനം അതു കണ്ടപ്പോൾ വിറെച്ചുകൊണ്ടു ദൂരത്തു നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","അവർ മോശെയോടു: നീ ഞങ്ങളോടു സംസാരിക്ക; ഞങ്ങൾ കേട്ടുകൊള്ളാം; ഞങ്ങൾ മരിക്കാതിരിക്കേണ്ടതിന്നു ദൈവം ഞങ്ങളോടു സംസാരിക്കരുതേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","മോശെ ജനത്തോടു: ഭയപ്പെടേണ്ടാ; നിങ്ങളെ പരീക്ഷിക്കേണ്ടതിന്നും നിങ്ങൾ പാപം ചെയ്യാതിരിപ്പാൻ അവങ്കലുള്ള ഭയം നിങ്ങൾക്കു ഉണ്ടായിരിക്കേണ്ടതിന്നും അത്രേ ദൈവം വന്നിരിക്കുന്നതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","അങ്ങനെ ജനം ദൂരത്തു നിന്നു; മോശെയോ ദൈവം ഇരുന്ന ഇരുളിന്നു അടുത്തുചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","അപ്പോൾ യഹോവ മോശെയോടു കല്പിച്ചതു: നീ യിസ്രായേൽമക്കളോടു ഇപ്രകാരം പറയേണം: ഞാൻ സ്വർഗ്ഗത്തിൽനിന്നു നിങ്ങളോടു സംസാരിച്ചതു നിങ്ങൾ കണ്ടിരിക്കുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","എന്റെ സന്നിധിയിൽ വെള്ളികൊണ്ടുള്ള ദേവന്മാരെയോ പൊന്നുകൊണ്ടുള്ള ദേവന്മാരെയോ നിങ്ങൾ ഉണ്ടാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","എനിക്കു മണ്ണുകൊണ്ടു ഒരു യാഗപീഠം ഉണ്ടാക്കി അതിന്മേൽ നിന്റെ ഹോമയാഗങ്ങളെയും സമാധാനയാഗങ്ങളെയും നിന്റെ ആടുകളെയും കന്നുകാലികളെയും അർപ്പിക്കേണം. ഞാൻ എന്റെ നാമത്തിന്റെ സ്മരണ സ്ഥാപിക്കുന്ന ഏതു സ്ഥലത്തും ഞാൻ നിന്റെ അടുക്കൽ വന്നു നിന്നെ അനുഗ്രഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","കല്ലുകൊണ്ടു എനിക്കു യാഗപീഠം ഉണ്ടാക്കുന്നു എങ്കിൽ ചെത്തിയ കല്ലുകൊണ്ടു അതു പണിയരുതു; നിന്റെ ആയുധംകൊണ്ടു അതിനെ തൊട്ടാൽ നീ അതിനെ അശുദ്ധമാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","എന്റെ യാഗപീഠത്തിങ്കൽ നിന്റെ നഗ്നത കാണാതിരിപ്പാൻ നീ അതിങ്കൽ പടികളാൽ കയറരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","അവരുടെ മുമ്പാകെ നീ വെക്കേണ്ടുന്ന ന്യായങ്ങളാവിതു: ");
INSERT INTO mal2015_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ഒരു എബ്രായദാസനെ വിലെക്കു വാങ്ങിയാൽ ആറു സംവത്സരം സേവിച്ചിട്ടു ഏഴാം സംവത്സരത്തിൽ അവൻ ഒന്നും കൊടുക്കാതെ സ്വതന്ത്രനായി പൊയ്ക്കൊള്ളട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ഏകനായി വന്നു എങ്കിൽ ഏകനായി പോകട്ടെ; അവന്നു ഭാര്യയുണ്ടായിരുന്നു എങ്കിൽ ഭാര്യയും അവനോടുകൂടെ പോകട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","അവന്റെ യജമാനൻ അവന്നു ഭാര്യയെ കൊടുക്കയും അവൾ അവന്നു പുത്രന്മാരെയോ പുത്രിമാരെയോ പ്രസവിക്കയും ചെയ്തിട്ടുണ്ടെങ്കിൽ ഭാര്യയും മക്കളും യജമാനന്നു ഇരിക്കേണം; അവൻ ഏകനായി പോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","എന്നാൽ ദാസൻ: ഞാൻ എന്റെ യജമാനനെയും എന്റെ ഭാര്യയെയും മക്കളെയും സ്നേഹിക്കുന്നു; ഞാൻ സ്വതന്ത്രനായി പോകയില്ല എന്നു തീർത്തു പറഞ്ഞാൽ ");
INSERT INTO mal2015_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","യജമാനൻ അവനെ ദൈവസന്നിധിയിൽ കൂട്ടിക്കൊണ്ടു ചെന്നു കതകിന്റെയോ കട്ടളക്കാലിന്റെയോ അടുക്കൽ നിറുത്തീട്ടു സൂചികൊണ്ടു അവന്റെ കാതു കുത്തി തുളക്കേണം; പിന്നെ അവൻ എന്നേക്കും അവന്നു ദാസനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ഒരുത്തൻ തന്റെ പുത്രിയെ ദാസിയായി വിറ്റാൽ അവൾ ദാസന്മാർ പോകുന്നതുപോലെ പോകരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","അവളെ തനിക്കു സംബന്ധത്തിന്നു നിയമിച്ച യജമാനന്നു അവളെ ബോധിക്കാതിരുന്നാൽ അവളെ വീണ്ടെടുപ്പാൻ അവൻ അനുവദിക്കേണം; അവളെ ചതിച്ചതുകൊണ്ടു അന്യജാതിക്കു വിറ്റുകളവാൻ അവന്നു അധികാരമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","അവൻ അവളെ തന്റെ പുത്രന്നു നിയമിച്ചു എങ്കിൽ പുത്രിമാരുടെ ന്യായത്തിന്നു തക്കവണ്ണം അവളോടു പെരുമാറേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","അവൻ മറ്റൊരുത്തിയെ പരിഗ്രഹിച്ചാൽ ഇവളുടെ ഉപജീവനവും ഉടുപ്പും വിവാഹമുറയും കുറെക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ഈ മൂന്നു കാര്യവും അവൻ അവൾക്കു ചെയ്യാതിരുന്നാൽ അവളെ പണം വാങ്ങാതെ വെറുതെ വിട്ടയക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","ഒരു മനുഷ്യനെ അടിച്ചുകൊല്ലുന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","അവൻ കരുതിക്കൂട്ടാതെ അങ്ങനെ അവന്റെ കയ്യാൽ സംഭവിപ്പാൻ ദൈവം സംഗതിവരുത്തിയതായാൽ അവൻ ഓടിപ്പോകേണ്ടുന്ന സ്ഥലം ഞാൻ നിയമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","എന്നാൽ ഒരുത്തൽ കരുതിക്കൂട്ടി കൂട്ടുകാരനെ ചതിച്ചു കൊന്നതെങ്കിൽ അവൻ മരിക്കേണ്ടതിന്നു നീ അവനെ എന്റെ യാഗപീഠത്തിങ്കൽ നിന്നും പിടിച്ചു കൊണ്ടുപോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","തന്റെ അപ്പനെയോ അമ്മയെയോ അടിക്കുന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","ഒരുത്തൻ ഒരാളെ മോഷ്ടിച്ചിട്ടു അവനെ വില്ക്കയാകട്ടെ അവന്റെ കൈവശം അവനെ കണ്ടു പിടിക്കയാകട്ടെ ചെയ്താൽ അവൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","തന്റെ അപ്പനെയോ അമ്മയെയോ ശപിക്കുന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","മനുഷ്യർ തമ്മിൽ ശണ്ഠകൂടീട്ടു ഒരുത്തൻ മറ്റവനെ കല്ലുകൊണ്ടോ മുഷ്ടികൊണ്ടോ കുത്തിയതിനാൽ അവൻ മരിച്ചുപോകാതെ കിടപ്പിലാകയും ");
INSERT INTO mal2015_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","പിന്നെയും എഴുന്നേറ്റു വടി ഊന്നി വെളിയിൽ നടക്കയും ചെയ്താൽ കുത്തിയവനെ ശിക്ഷിക്കരുതു; എങ്കിലും അവൻ അവന്റെ മിനക്കേടിന്നുവേണ്ടി കൊടുത്തു അവനെ നല്ലവണ്ണം ചികിത്സിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ഒരുത്തൻ തന്റെ ദാസനെയോ ദാസിയെയോ തൽക്ഷണം മരിച്ചുപോകത്തക്കവണ്ണം വടികൊണ്ടു അടിച്ചാൽ അവനെ നിശ്ചയമായി ശിക്ഷിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","എങ്കിലും അവൻ ഒന്നു രണ്ടു ദിവസം ജീവിച്ചിരുന്നാൽ അവനെ ശിക്ഷിക്കരുതു; അവൻ അവന്റെ മുതലല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","മനുഷ്യർ തമ്മിൽ ശണ്ഠകൂടീട്ടു ഗർഭിണിയായ ഒരു സ്ത്രീയെ അടിച്ചതിനാൽ ഗർഭം അലസിയതല്ലാതെ അവൾക്കു മറ്റൊരു ദോഷവും വന്നില്ലെങ്കിൽ അടിച്ചവൻ ആ സ്ത്രീയുടെ ഭർത്താവു ചുമത്തുന്ന പിഴ കൊടുക്കേണം; ന്യായാധിപന്മാർ വിധിക്കുമ്പോലെ അവൻ കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","മറ്റു ദോഷം വന്നിട്ടുണ്ടെങ്കിൽ ജീവന്നു പകരം ജീവൻ കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","കണ്ണിന്നു പകരം കണ്ണു; പല്ലിന്നു പകരം പല്ലു; കൈക്കു പകരം കൈ; കാലിന്നു പകരം കാൽ; ");
INSERT INTO mal2015_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","പൊള്ളലിന്നു പകരം പൊള്ളൽ; മുറിവിന്നു പകരം മുറിവു; തിണർപ്പിന്നു പകരം തിണർപ്പു. ");
INSERT INTO mal2015_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ഒരുത്തൻ അടിച്ചു തന്റെ ദാസന്റെയോ ദാസിയുടെയോ കണ്ണു കളഞ്ഞാൽ അവൻ കണ്ണിന്നു പകരം അവനെ സ്വതന്ത്രനായി വിട്ടയക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","അവൻ തന്റെ ദാസന്റെയോ ദാസിയുടെയോ പല്ലു അടിച്ചു തകർത്താൽ അവൻ പല്ലിന്നു പകരം അവനെ സ്വതന്ത്രനായി വിട്ടയക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ഒരു കാള ഒരു പുരുഷനെയോ സ്ത്രീയെയോ കുത്തിക്കൊന്നാൽ ആ കാളയെ കല്ലെറിഞ്ഞു കൊല്ലേണം; അതിന്റെ മാംസം തിന്നരുതു; കാളയുടെ ഉടമസ്ഥനോ കുറ്റമില്ലാത്തവൻ. ");
INSERT INTO mal2015_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","എന്നാൽ ആ കാള മുമ്പെ തന്നേ കുത്തുന്നതായും ഉടമസ്ഥൻ അതു അറിഞ്ഞുമിരിക്കെ അവൻ അതിനെ സൂക്ഷിക്കായ്കകൊണ്ടു അതു ഒരു പുരുഷനെയോ സ്ത്രീയെയോ കൊന്നുകളഞ്ഞാൽ ആ കാളയെ കല്ലെറിഞ്ഞു കൊല്ലേണം; അതിന്റെ ഉടമസ്ഥനും മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ഉദ്ധാരണ ദ്രവ്യം അവന്റെ മേൽ ചുമത്തിയാൽ തന്റെ ജീവന്റെ വീണ്ടെടുപ്പിന്നായി തന്റെ മേൽ ചുമത്തിയതു ഒക്കെയും അവൻ കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","അതു ഒരു ബാലനെ കുത്തിയാലും ഒരു ബാലയെ കുത്തിയാലും ഈ ന്യായപ്രകാരം അവനോടു ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","കാള ഒരു ദാസനെയോ ദാസിയെയോ കുത്തിയാൽ അവൻ അവരുടെ ഉടമസ്ഥന്നു മുപ്പതു ശേക്കെൽ വെള്ളി കൊടുക്കേണം; കാളയെ കൊന്നുകളകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ഒരുത്തൻ ഒരു കുഴി തുറന്നുവെക്കുകയോ കുഴി കുഴിച്ചു അതിനെ മൂടാതിരിക്കയോ ചെയ്തിട്ടു അതിൽ ഒരു കാളയോ കഴുതയോ വീണാൽ, ");
INSERT INTO mal2015_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","കുഴിയുടെ ഉടമസ്ഥൻ വിലകൊടുത്തു അതിന്റെ യജമാനന്നു തൃപ്തിവരുത്തേണം; എന്നാൽ ചത്തുപോയതു അവന്നുള്ളതായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ഒരുത്തന്റെ കാള മറ്റൊരുത്തന്റെ കാളയെ കുത്തീട്ടു അതു ചത്തുപോയാൽ അവർ ജീവനോടിരിക്കുന്ന കാളയെ വിറ്റു അതിന്റെ വില പകുത്തെടുക്കേണം; ചത്തുപോയതിനെയും പകുത്തെടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","അല്ലെങ്കിൽ ആ കാള മുമ്പെ തന്നേ കുത്തുന്നതു എന്നു അറിഞ്ഞിട്ടും ഉടമസ്ഥൻ അതിനെ സൂക്ഷിക്കാതിരുന്നു എങ്കിൽ അവൻ കാളെക്കു പകരം കാളയെ കൊടുക്കേണം; എന്നാൽ ചത്തുപോയതു അവന്നുള്ളതായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","ഒരുത്തൻ ഒരു കാളയെയോ ഒരു ആടിനെയോ മോഷ്ടിച്ചു അറുക്കുകയാകട്ടെ വില്ക്കുകയാകട്ടെ ചെയ്താൽ അവൻ ഒരു കാളെക്കു അഞ്ചു കാളയെയും, ഒരു ആടിന്നു നാലു ആടിനെയും പകരം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","കള്ളൻ വീടു മുറിക്കുമ്പോൾ പിടിക്കപ്പെട്ടു അടികൊണ്ടു മരിച്ചുപോയാൽ അവനെ സംബന്ധിച്ചു രക്തപാതകം ഇല്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","എന്നാൽ അതു നേരം വെളുത്തശേഷമാകുന്നു എങ്കിൽ രക്തപാതകം ഉണ്ടു. കള്ളൻ ശരിയായിട്ടു പ്രതിശാന്തി ചെയ്യേണം; അവൻ വകയില്ലാത്തവനെങ്കിൽ തന്റെ മോഷണം നിമിത്തം അവനെ വില്ക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","മോഷണവസ്തുവായ കാളയെയോ കഴുതയെയോ ആടിനെയോ ജീവനോടെ അവന്റെ കൈവശം കണ്ടുപിടിച്ചാൽ അവൻ ഇരട്ടി പകരം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ഒരുത്തൻ ഒരു വയലോ മുന്തിരിത്തോട്ടമോ തീറ്റിക്കയാകട്ടെ തന്റെ കന്നുകാലിയെ അഴിച്ചുവിട്ടു അതു മറ്റൊരുത്തന്റെ വയലിൽ മേയുകയാകട്ടെ ചെയ്താൽ അവൻ തന്റെ വയലിലുള്ളതിൽ ഉത്തമമായതും തന്റെ മുന്തിരിത്തോട്ടത്തിലുള്ളതിൽ ഉത്തമമായതും പകരം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","തീ വീണു കാടു കത്തീട്ടു കറ്റക്കൂട്ടമോ വിളവോ നിലമോ വെന്തുപോയെങ്കിൽ തീ കത്തിച്ചവൻ പകരം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ഒരുത്തൻ കൂട്ടകാരന്റെ പറ്റിൽ പണമോ വല്ല സാധനമോ സൂക്ഷിപ്പാൻ ഏല്പിച്ചിരിക്കെ അതു അവന്റെ വീട്ടിൽനിന്നു കളവുപോയാൽ കള്ളനെ പിടികിട്ടി എന്നുവരികിൽ അവൻ ഇരട്ടി പകരം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","കള്ളനെ പിടികിട്ടാതിരുന്നാൽ ആ വീട്ടുകാരൻ കൂട്ടുകാരന്റെ വസ്തുവിന്മേൽ കൈ വെച്ചിട്ടുണ്ടോ എന്നു അറിവാൻ അവനെ ദൈവസന്നിധിയിൽ കൊണ്ടുപോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","കാണാതെപോയ കാള, കഴുത, ആടു, വസ്ത്രം മുതലായ യാതൊന്നിനെയും സംബന്ധിച്ചു ഇതു എനിക്കുള്ളതു എന്നു ഒരുവൻ പറഞ്ഞു കുറ്റം ചുമത്തിയാൽ ഇരുപാട്ടുകാരുടെയും കാര്യം ദൈവസന്നിധിയിൽ വരേണം; കുറ്റക്കാരനെന്നു ദൈവം വിധിക്കുന്നവൻ കൂട്ടുകാരന്നു ഇരട്ടി പകരം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ഒരുത്തൻ കൂട്ടുകാരന്റെ പക്കൽ കഴുത, കാള, ആടു എന്നിങ്ങനെ ഒരു മൃഗത്തെ സൂക്ഷിപ്പാൻ ഏല്പിച്ചിരിക്കെ അതു ചത്തുപോകയോ അതിന്നു വല്ല കേടു തട്ടുകയോ ആരും കാണാതെ കളവുപോകയോ ചെയ്താൽ ");
INSERT INTO mal2015_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","കൂട്ടുകാരന്റെ വസ്തുവിന്മേൽ അവൻ കൈ വെച്ചിട്ടില്ല എന്നു യഹോവയെക്കൊണ്ടുള്ള സത്യം ഇരുപാട്ടുകാർക്കും തീർച്ച ആയിരിക്കേണം; ഉടമസ്ഥൻ അതു സമ്മതിക്കേണം; മറ്റവൻ പകരം കൊടുക്കേണ്ടാ. ");
INSERT INTO mal2015_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","എന്നാൽ അതു അവന്റെ പക്കൽനിന്നു കളവുപോയി എന്നു വരികിൽ അവൻ അതിന്റെ ഉടമസ്ഥന്നു പകരം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","അതു കടിച്ചു കീറിപ്പോയെങ്കിൽ അവൻ അതിന്നു സാക്ഷ്യം കൊണ്ടുവരേണം; കടിച്ചു കീറിപ്പോയതിന്നു അവൻ പകരം കൊടുക്കേണ്ടാ. ");
INSERT INTO mal2015_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ഒരുത്തൻ കൂട്ടുകാരനോടു വായ്പ വാങ്ങീട്ടു ഉടമസ്ഥൻ അരികെ ഇല്ലാതിരിക്കെ വല്ല കേടു ഭവിക്കയോ ചത്തുപോകയോ ചെയ്താൽ അവൻ പകരം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ഉടമസ്ഥൻ അരികെ ഉണ്ടായിരുന്നാൽ അവൻ പകരം കൊടുക്കേണ്ടാ; അതു കൂലിക്കു വാങ്ങിയതെങ്കിൽ അതിന്നു കൂലിയുണ്ടല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","വിവാഹത്തിന്നു നിയമിക്കപ്പെടാത്ത ഒരു കന്യകയെ ഒരുത്തൻ വശീകരിച്ചു അവളോടുകൂടെ ശയിച്ചാൽ അവൻ സ്ത്രീധനം കൊടുത്തു അവളെ വിവാഹം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","അവളെ അവന്നു കൊടുപ്പാൻ അവളുടെ അപ്പന്നു അശേഷം മനസ്സില്ലെങ്കിൽ അവൻ കന്യകമാരുടെ സ്ത്രീധനത്തിന്നു ഒത്തവണ്ണം പണം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","ക്ഷുദ്രക്കാരത്തിയെ നീ ജീവനോടെ വെക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","മൃഗത്തോടുകൂടെ ശയിക്കുന്ന ഏവനും മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","യഹോവെക്കു മാത്രമല്ലാതെ വേറെ ദൈവങ്ങൾക്കു യാഗം കഴിക്കുന്നവനെ നിർമ്മൂലമാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","പരദേശിയെ പീഡിപ്പിക്കരുതു ഉപദ്രവിക്കയുമരുതു; നിങ്ങൾ മിസ്രയീംദേശത്തു പരദേശികൾ ആയിരുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","വിധവയെയും അനാഥനെയും നിങ്ങൾ ക്ലേശിപ്പിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","അവരെ വല്ലപ്രകാരത്തിലും ക്ലേശിപ്പിക്കയും അവർ എന്നോടു നിലവിളിക്കയും ചെയ്താൽ ഞാൻ അവരുടെ നിലവിളി കേൾക്കും; ");
INSERT INTO mal2015_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","എന്റെ കോപവും ജ്വലിക്കും; ഞാൻ വാൾകൊണ്ടു നിങ്ങളെ കൊല്ലും; നിങ്ങളുടെ സ്ത്രീകൾ വിധവമാരും നിങ്ങളുടെ പൈതങ്ങൾ അനാഥരുമായി തീരും. ");
INSERT INTO mal2015_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","എന്റെ ജനത്തിൽ നിന്റെ അടുക്കലുള്ള ഒരു ദരിദ്രന്നു പണം വായ്പ കൊടുത്താൽ പൊലികടക്കാരനെപ്പോലെ ഇരിക്കരുതു; അവനോടു പലിശ വാങ്ങുകയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","നീ കൂട്ടുകാരന്റെ വസ്ത്രം പണയം വാങ്ങിയാൽ സൂര്യൻ അസ്തമിക്കുംമുമ്പെ മടക്കിക്കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","അതുമാത്രമല്ലോ അവന്റെ പുതപ്പു; അതുമാത്രമല്ലോ അവന്റെ ശരീരം മൂടുന്ന വസ്ത്രം; അവൻ പിന്നെ എന്തൊന്നു പുതെച്ചു കിടക്കും? അവൻ എന്നോടു നിലവിളിക്കുമ്പോൾ ഞാൻ കേൾക്കും; ഞാൻ കൃപയുള്ളവനല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","നീ ദൈവത്തെ ദുഷിക്കരുതു; നിന്റെ ജനത്തിന്റെ അധിപതിയെ ശപിക്കയുമരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","നിന്റെ വിളവും ദ്രാവകവർഗ്ഗവും അർപ്പിപ്പാൻ താമസിക്കരുതു; നിന്റെ പുത്രന്മാരിൽ ആദ്യജാതനെ എനിക്കു തരേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","നിന്റെ കാളകളിലും ആടുകളിലും അങ്ങനെ തന്നേ; അതു ഏഴു ദിവസം തള്ളയോടു കൂടെ ഇരിക്കട്ടെ; എട്ടാം ദിവസം അതിനെ എനിക്കു തരേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","നിങ്ങൾ എനിക്കു വിശുദ്ധന്മാരായിരിക്കേണം; കാട്ടുമൃഗം കടിച്ചുകീറിയ മാംസം തിന്നരുതു. നിങ്ങൾ അതിനെ നായ്ക്കൾക്കു ഇട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","വ്യാജവർത്തമാനം പരത്തരുതു; കള്ളസ്സാക്ഷിയായിരിപ്പാൻ ദുഷ്ടനോടുകൂടെ ചേരരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ബഹുജനത്തെ അനുസരിച്ചു ദോഷം ചെയ്യരുതു; ന്യായം മറിച്ചുകളവാൻ ബഹുജനപക്ഷം ചേർന്നു വ്യവഹാരത്തിൽ സാക്ഷ്യം പറയരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ദരിദ്രന്റെ വ്യവഹാരത്തിൽ അവനോടു പക്ഷം കാണിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","നിന്റെ ശത്രുവിന്റെ കാളയോ കഴുതയോ വഴിതെറ്റിയതായി കണ്ടാൽ അതിനെ അവന്റെ അടുക്കൽ തിരികെ കൊണ്ടുപോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","നിന്നെ ദ്വേഷിക്കുന്നവന്റെ കഴുത ചുമടിൻ കീഴെ കിടക്കുന്നതു കണ്ടാൽ അവനെ വിചാരിച്ചു അതിനെ അഴിച്ചുവിടുവാൻ മടിച്ചാലും അഴിച്ചുവിടുവാൻ അവന്നു സഹായം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","നിങ്ങളുടെ ഇടയിലുള്ള ദരിദ്രന്റെ വ്യവഹാരത്തിൽ അവന്റെ ന്യായം മറിച്ചുകളയരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","കള്ളക്കാര്യം വിട്ടു അകന്നിരിക്ക; കുറ്റമില്ലാത്തവനെയും നീതിമാനെയും കൊല്ലരുതു; ഞാൻ ദുഷ്ടനെ നീതീകരിക്കയില്ലല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","സമ്മാനം കാഴ്ചയുള്ളവരെ കുരുടാക്കുകയും നീതിമാന്മാരുടെ വാക്കുകളെ മറിച്ചുകളകയും ചെയ്യുന്നതുകൊണ്ടു നീ സമ്മാനം വാങ്ങരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","പരദേശിയെ ഉപദ്രവിക്കരുതു: നിങ്ങൾ മിസ്രയീംദേശത്തു പരദേശികളായിരുന്നതുകൊണ്ടു പരദേശിയുടെ അനുഭവം അറിയുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ആറു സംവത്സരം നിന്റെ നിലം വിതെച്ചു വിളവു എടുത്തുകൊൾക. ");
INSERT INTO mal2015_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ഏഴാം സംവത്സരത്തിലോ അതു ഉഴവുചെയ്യാതെ വെറുതെ ഇട്ടേക്ക; നിന്റെ ജനത്തിലെ ദരിദ്രന്മാർ അഹോവൃത്തി കഴിക്കട്ടെ; അവർ ശേഷിപ്പിക്കുന്നതു കാട്ടുമൃഗങ്ങൾ തിന്നട്ടെ. നിന്റെ മുന്തിരിത്തോട്ടവും ഒലിവുവൃക്ഷവും സംബന്ധിച്ചും അങ്ങനെ തന്നേ ചെയ്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ആറു ദിവസം വേല ചെയ്ക; ഏഴാം ദിവസം നിന്റെ കാളയും കഴുതയും വിശ്രമിപ്പാനും നിന്റെ ദാസിയുടെ പുത്രനും പരദേശിയും ആശ്വസിപ്പാനും വേണ്ടി നീ സ്വസ്ഥമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ഞാൻ നിങ്ങളോടു കല്പിച്ച എല്ലാറ്റിലും സൂക്ഷ്മതയോടിരിപ്പിൻ; അന്യദൈവങ്ങളുടെ നാമം കീർത്തിക്കരുതു; അതു നിന്റെ വായിൽനിന്നു കേൾക്കയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","സംവത്സരത്തിൽ മൂന്നു പ്രാവശ്യം എനിക്കു ഉത്സവം ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","പുളിപ്പില്ലാത്ത അപ്പത്തിന്റെ ഉത്സവം ആചരിക്കേണം; ഞാൻ നിന്നോടു കല്പിച്ചതുപോലെ ആബീബ് മാസത്തിൽ നിശ്ചയിച്ച സമയത്തു ഏഴു ദിവസം പുളിപ്പില്ലാത്ത അപ്പം തിന്നുക; അന്നല്ലോ നീ മിസ്രയീമിൽനിന്നു പുറപ്പെട്ടു പോന്നതു. എന്നാൽ വെറുങ്കയ്യോടെ നിങ്ങൾ എന്റെ മുമ്പാകെ വരരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","വയലിൽ വിതെച്ച വിതയുടെ ആദ്യഫലമെടുക്കുന്ന കൊയ്ത്തുപെരുനാളും ആണ്ടറുതിയിൽ വയലിൽ നിന്നു നിന്റെ വേലയുടെ ഫലം കൂട്ടിത്തീരുമ്പോൾ കായ്കനിപ്പെരുനാളും ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","സംവത്സരത്തിൽ മൂന്നു പ്രാവശ്യം നിന്റെ ആണുങ്ങൾ എല്ലാം കർത്താവായ യഹോവയുടെ മുമ്പാകെ വരേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","എന്റെ യാഗരക്തം പുളിപ്പുള്ള അപ്പത്തോടുകൂടെ അർപ്പിക്കരുതു; എന്റെ യാഗമേദസ്സ് ഉഷഃകാലംവരെ ഇരിക്കയുമരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","നിന്റെ ഭൂമിയുടെ ആദ്യവിളവുകളിലെ പ്രഥമഫലം നിന്റെ ദൈവമായ യഹോവയുടെ ആലയത്തിൽ കൊണ്ടുവരേണം. ആട്ടിൻകുട്ടിയെ തള്ളയുടെ പാലിൽ പാകം ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ഇതാ, വഴിയിൽ നിന്നെ കാക്കേണ്ടതിന്നും ഞാൻ നിയമിച്ചിരിക്കുന്ന സ്ഥലത്തേക്കു നിന്നെ കൊണ്ടുപോകേണ്ടതിന്നും ഞാൻ ഒരു ദൂതനെ നിന്റെ മുമ്പിൽ അയക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","നീ അവനെ ശ്രദ്ധിച്ചു അവന്റെ വാക്കു കേൾക്കേണം; അവനോടു വികടിക്കരുതു; അവൻ നിങ്ങളുടെ അതിക്രമങ്ങളെ ക്ഷമിക്കയില്ല; എന്റെ നാമം അവനിൽ ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","എന്നാൽ നീ അവന്റെ വാക്കു ശ്രദ്ധയോടെ കേട്ടു ഞാൻ കല്പിക്കുന്നതൊക്കെയും ചെയ്താൽ നിന്നെ പകെക്കുന്നവരെ ഞാൻ പകെക്കും; നിന്നെ ഞെരുക്കുന്നവരെ ഞാൻ ഞെരുക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","എന്റെ ദൂതൻ നിനക്കു മുമ്പായി നടന്നു നിന്നെ അമോര്യർ, ഹിത്യർ, പെരിസ്യർ, കനാന്യർ, ഹിവ്യർ, യെബൂസ്യർ എന്നിവരുടെ ദേശത്തേക്കു കൊണ്ടുപോകും; അവരെ ഞാൻ നിർമ്മൂലമാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","അവരുടെ ദേവന്മാരെ നമസ്കരിക്കരുതു; അവയെ സേവിക്കരുതു; അവരുടെ പ്രവൃത്തികൾപോലെ പ്രവർത്തിക്കരുതു; അവരെ അശേഷം നശിപ്പിച്ചു അവരുടെ വിഗ്രഹങ്ങളെ തകർത്തുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","നിങ്ങളുടെ ദൈവമായ യഹോവയെ തന്നേ സേവിപ്പിൻ; എന്നാൽ അവൻ നിന്റെ അപ്പത്തെയും വെള്ളത്തെയും അനുഗ്രഹിക്കും; ഞാൻ രോഗങ്ങളെ നിന്റെ നടുവിൽനിന്നു അകറ്റിക്കളയും. ");
INSERT INTO mal2015_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ഗർഭം അലസുന്നവളും മച്ചിയും നിന്റെ ദേശത്തു ഉണ്ടാകയില്ല; നിന്റെ ആയുഷ്കാലം ഞാൻ പൂർത്തിയാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","എന്റെ ഭീതിയെ ഞാൻ നിന്റെ മുമ്പിൽ അയച്ചു നീ ചെല്ലുന്നേടത്തുള്ള ജാതികളെ ഒക്കെയും അമ്പരപ്പിക്കയും നിന്റെ സകലശത്രുക്കളെയും നിന്റെ മുമ്പിൽനിന്നു ഓടിക്കയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","നിന്റെ മുമ്പിൽനിന്നു ഹിവ്യനെയും കനാന്യനെയും ഹിത്യനെയും ഓടിച്ചുകളവാൻ ഞാൻ നിനക്കു മുമ്പായി കടുന്നലിനെ അയക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ദേശം ശൂന്യമാകാതെയും കാട്ടുമൃഗം നിനക്കു ബാധയായി പെരുകാതെയും ഇരിപ്പാൻ ഞാൻ അവരെ ഒരു സംവത്സരത്തിന്നകത്തു നിന്റെ മുമ്പിൽ നിന്നു ഓടിച്ചുകളകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","നീ സന്താനസമ്പന്നമായി ദേശം അടക്കുന്നതുവരെ ഞാൻ അവരെ കുറേശ്ശ, കുറേശ്ശ നിന്റെ മുമ്പിൽ നിന്നു ഓടിച്ചുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ഞാൻ നിന്റെ ദേശം ചെങ്കടൽ തുടങ്ങി ഫെലിസ്ത്യരുടെ കടൽവരെയും മരുഭൂമി തുടങ്ങി നദിവരെയും ആക്കും; ദേശത്തിലെ നിവാസികളെ നിങ്ങളുടെ കയ്യിൽ ഏല്പിക്കും; നീ അവരെ നിന്റെ മുമ്പിൽ നിന്നു ഓടിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","അവരോടു എങ്കിലും അവരുടെ ദേവന്മാരോടു എങ്കിലും നീ ഉടമ്പടി ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","നീ എന്നോടു പാപം ചെയ്‌വാൻ അവർ ഹേതുവായിത്തീരാതിരിക്കേണ്ടതിന്നു അവർ നിന്റെ ദേശത്തു വസിക്കരുതു. നീ അവരുടെ ദേവന്മാരെ സേവിച്ചാൽ അതു നിനക്കു കണിയായി തീരും. ");
INSERT INTO mal2015_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","അവൻ പിന്നെയും മോശെയോടു: നീയും അഹരോനും നാദാബും അബീഹൂവും യിസ്രായേൽമൂപ്പന്മാരിൽ എഴുപതു പേരും യഹോവയുടെ അടുക്കൽ കയറിവന്നു ദൂരത്തുനിന്നു നമസ്കരിപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","മോശെ മാത്രം യഹോവെക്കു അടുത്തുവരട്ടെ. അവർ അടുത്തുവരരുതു; ജനം അവനോടുകൂടെ കയറി വരികയുമരുതു എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","എന്നാറെ മോശെ വന്നു യഹോവയുടെ വചനങ്ങളും ന്യായങ്ങളും എല്ലാം ജനത്തെ അറിയിച്ചു. യഹോവ കല്പിച്ച സകലകാര്യങ്ങളും ഞങ്ങൾ ചെയ്യും എന്നു ജനമൊക്കെയും ഏകശബ്ദത്തോടെ ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","മോശെ യഹോവയുടെ വചനങ്ങളൊക്കെയും എഴുതി അതികാലത്തു എഴുന്നേറ്റു പർവ്വതത്തിന്റെ അടിവാരത്തു ഒരു യാഗപീഠവും യിസ്രായേലിന്റെ പന്ത്രണ്ടു ഗോത്രങ്ങളുടെ സംഖ്യക്കൊത്തവണ്ണം പന്ത്രണ്ടു തൂണും പണിതു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","പിന്നെ അവർ യിസ്രായേൽമക്കളിൽ ചില ബാല്യക്കാരെ അയച്ചു; അവർ ഹോമയാഗങ്ങളെ കഴിച്ചു യഹോവെക്കു സമാധാനയാഗങ്ങളായി കാളകളെയും അർപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","മോശെ രക്തത്തിൽ പാതി എടുത്തു പാത്രങ്ങളിൽ ഒഴിച്ചു; രക്തത്തിൽ പാതി യാഗപീഠത്തിന്മേൽ തളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","അവൻ നിയമപുസ്തകം എടുത്തു ജനം കേൾക്കെ വായിച്ചു. യഹോവ കല്പിച്ചതൊക്കെയും ഞങ്ങൾ അനുസരിച്ചു നടക്കുമെന്നു അവർ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","അപ്പോൾ മോശെ രക്തം എടുത്തു ജനത്തിന്മേൽ തളിച്ചു; ഈ സകലവചനങ്ങളും ആധാരമാക്കി യഹോവ നിങ്ങളോടു ചെയ്തിരിക്കുന്ന നിയമത്തിന്റെ രക്തം ഇതാ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","അനന്തരം മോശെയും അഹരോനും നാദാബും അബീഹൂവും യിസ്രായേൽമൂപ്പന്മാരിൽ എഴുപതു പേരുംകൂടെ കയറിച്ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","അവർ യിസ്രായേലിന്റെ ദൈവത്തെ കണ്ടു; അവന്റെ പാദങ്ങൾക്കു കീഴെ നീലക്കല്ലു പടുത്ത തളം പോലെയും ആകാശത്തിന്റെ സ്വച്ഛതപോലെയും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","യിസ്രായേൽമക്കളുടെ പ്രമാണികൾക്കു തൃക്കയ്യാൽ ഒന്നും ഭവിച്ചില്ല; അവർ ദൈവത്തെ കണ്ടു ഭക്ഷണ പാനീയങ്ങൾ കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","പിന്നെ യഹോവ മോശെയോടു: നീ എന്റെ അടുക്കൽ പർവ്വതത്തിൽ കയറിവന്നു അവിടെ ഇരിക്ക; ഞാൻ നിനക്കു കല്പലകകളും നീ അവരെ ഉപദേശിക്കേണ്ടതിന്നു ഞാൻ എഴുതിയ ന്യായപ്രമാണവും കല്പനകളും തരും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","അങ്ങനെ മോശെയും അവന്റെ ശുശ്രൂഷക്കാരനായ യോശുവയും എഴുന്നേറ്റു, മോശെ ദൈവത്തിന്റെ പർവ്വത്തിൽ കയറി. ");
INSERT INTO mal2015_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","അവൻ മൂപ്പന്മാരോടു: ഞങ്ങൾ നിങ്ങളുടെ അടുക്കൽ മടങ്ങിവരുവോളം ഇവിടെ താമസിപ്പിൻ; അഹരോനും ഹൂരും നിങ്ങളോടുകൂടെ ഉണ്ടല്ലോ; ആർക്കെങ്കിലും വല്ല കാര്യവുമുണ്ടായാൽ അവൻ അവരുടെ അടുക്കൽ ചെല്ലട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","അങ്ങനെ മോശെ പർവ്വതത്തിൽ കയറിപ്പോയി; ഒരു മേഘം പർവ്വതത്തെ മൂടി. ");
INSERT INTO mal2015_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","യഹോവയുടെ തേജസ്സും സീനായിപർവ്വതത്തിൽ ആവസിച്ചു. മേഘം ആറുദിവസം അതിനെ മൂടിയിരുന്നു; അവൻ ഏഴാം ദിവസം മേഘത്തിന്റെ നടുവിൽ നിന്നു മോശെയെ വിളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","യഹോവയുടെ തേജസ്സിന്റെ കാഴ്ച പർവ്വതത്തിന്റെ മുകളിൽ കത്തുന്ന തീപോലെ യിസ്രായേൽമക്കൾക്കു തോന്നി. ");
INSERT INTO mal2015_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","മോശെയോ മേഘത്തിന്റെ നടുവിൽ പർവ്വതത്തിൽ കയറി. മോശെ നാല്പതു പകലും നാല്പതു രാവും പർവ്വതത്തിൽ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","യഹോവ മോശെയോടു കല്പിച്ചതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","എനിക്കു വഴിപാടു കൊണ്ടു വരുവാൻ യിസ്രായേൽമക്കളോടു പറക; നല്ല മനസ്സോടെ തരുന്ന ഏവനോടും നിങ്ങൾ എനിക്കുവേണ്ടി വഴിപാടു വാങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","അവരോടു വാങ്ങേണ്ടുന്ന വഴിപാടോ: പൊന്നു, വെള്ളി, താമ്രം; നീലനൂൽ, ധൂമ്രനൂൽ, ");
INSERT INTO mal2015_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ചുവപ്പുനൂൽ, പഞ്ഞിനൂൽ, കോലാട്ടുരോമം, ");
INSERT INTO mal2015_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ചുവപ്പിച്ച ആട്ടുകൊറ്റന്തോൽ, തഹശൂതോൽ, ഖദിരമരം; ");
INSERT INTO mal2015_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","വിളക്കിന്നു എണ്ണ, അഭിഷേക തൈലത്തിന്നും പരിമളധൂപത്തിന്നും സുഗന്ധവർഗ്ഗം, ");
INSERT INTO mal2015_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ഏഫോദിന്നും മാർപദക്കത്തിന്നും പതിപ്പാൻ ഗോമേദകക്കല്ലു, രത്നങ്ങൾ എന്നിവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ഞാൻ അവരുടെ നടുവിൽ വസിപ്പാൻ അവർ എനിക്കു ഒരു വിശുദ്ധ മന്ദിരം ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","തിരുനിവാസവും അതിന്റെ ഉപകരണങ്ങളും ഞാൻ കാണിക്കുന്ന മാതൃകപ്രകാരമൊക്കെയും തന്നേ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","ഖദിരമരംകൊണ്ടു ഒരു പെട്ടകം ഉണ്ടാക്കേണം; അതിന്നു രണ്ടര മുഴം നീളവും ഒന്നര മുഴം വീതിയും ഒന്നര മുഴം ഉയരവും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","അതു മുഴുവനും തങ്കംകൊണ്ടു പൊതിയേണം; അകത്തും പുറത്തും പൊതിയേണം; അതിന്റെ മേൽ ചുറ്റും പൊന്നുകൊണ്ടുള്ള ഒരു വക്കും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","അതിന്നു നാലു പൊൻവളയം വാർപ്പിച്ചു നാലു കാലിലും ഇപ്പുറത്തു രണ്ടു വളയവും അപ്പുറത്തു രണ്ടു വളയവുമായി തറെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ഖദിരമരംകൊണ്ടു തണ്ടുകൾ ഉണ്ടാക്കി പൊന്നുകൊണ്ടു പൊതിയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","തണ്ടുകളാൽ പെട്ടകം ചുമക്കേണ്ടതിന്നു പെട്ടകത്തിന്റെ പാർശ്വങ്ങളിലുള്ള വളയങ്ങളിൽ അവ ചെലുത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","തണ്ടുകൾ പെട്ടകത്തിന്റെ വളയങ്ങളിൽ ഇരിക്കേണം; അവയെ അതിൽ നിന്നു ഊരരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ഞാൻ തരുവാനിരിക്കുന്ന സാക്ഷ്യം പെട്ടകത്തിൽ വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","തങ്കംകൊണ്ടു കൃപാസനം ഉണ്ടാക്കേണം; അതിന്റെ നീളം രണ്ടര മുഴവും വീതി ഒന്നര മുഴവും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","പൊന്നുകൊണ്ടു രണ്ടു കെരൂബുകളെ ഉണ്ടാക്കേണം; കൃപാസനത്തിന്റെ രണ്ടു അറ്റത്തും അടിപ്പുപണിയായി പൊന്നുകൊണ്ടു അവയെ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ഒരു കെരൂബിനെ ഒരു അറ്റത്തും മറ്റെ കെരൂബിനെ മറ്റെ അറ്റത്തും ഉണ്ടാക്കേണം. കെരൂബുകളെ കൃപാസനത്തിൽനിന്നുള്ളവയായി അതിന്റെ രണ്ടു അറ്റത്തും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","കെരൂബുകൾ മേലോട്ടു ചിറകുവിടർത്തി ചിറകുകൊണ്ടു കൃപാസനത്തെ മൂടുകയും തമ്മിൽ അഭിമുഖമായിരിക്കയും വേണം. കെരൂബുകളുടെ മുഖം കൃപാസനത്തിന്നു നേരെ ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","കൃപാസനത്തെ പെട്ടകത്തിന്മീതെ വെക്കേണം; ഞാൻ തരുവാനിരിക്കുന്ന സാക്ഷ്യം പെട്ടകത്തിനകത്തു വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","അവിടെ ഞാൻ നിനക്കു പ്രത്യക്ഷനായി കൃപാസനത്തിന്മേൽനിന്നു സാക്ഷ്യപ്പെട്ടകത്തിന്മേൽ നില്ക്കുന്ന രണ്ടു കെരൂബുകളുടെ നടുവിൽ നിന്നും യിസ്രായേൽമക്കൾക്കായി ഞാൻ നിന്നോടു കല്പിപ്പാനിരിക്കുന്ന സകലവും നിന്നോടു അരുളിച്ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","ഖദിരമരംകൊണ്ടു ഒരു മേശ ഉണ്ടാക്കേണം. അതിന്റെ നീളം രണ്ടു മുഴവും വീതി ഒരു മുഴവും ഉയരം ഒന്നര മുഴവും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","അതു തങ്കംകൊണ്ടു പൊതിഞ്ഞു ചുറ്റും പൊന്നുകൊണ്ടു ഒരു വക്കും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ചുറ്റും അതിന്നു നാലു വിരൽ വീതിയുള്ള ഒരു ചട്ടവും ചട്ടത്തിന്നു ചുറ്റും പൊന്നുകൊണ്ടു ഒരു വക്കും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","അതിന്നു നാലു പൊൻവളയം ഉണ്ടാക്കേണം; വളയം നാലു കാലിന്റെയും പാർശ്വങ്ങളിൽ തറെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","മേശ ചുമക്കേണ്ടതിന്നു തണ്ടു ചെലുത്തുവാൻ വേണ്ടി വളയം ചട്ടത്തിന്നു ചേർന്നിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","തണ്ടുകൾ ഖദരിമരംകൊണ്ടു ഉണ്ടാക്കി പൊന്നുകൊണ്ടു പൊതിയേണം; അവകൊണ്ടു മേശ ചുമക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","അതിന്റെ തളികകളും കരണ്ടികളും പകരുന്നതിന്നുള്ള കുടങ്ങളും കിണ്ടികളും ഉണ്ടാക്കേണം; തങ്കംകൊണ്ടു അവയെ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","മേശമേൽ നിത്യം കാഴ്ചയപ്പം എന്റെ മുമ്പാകെ വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","തങ്കംകൊണ്ടു ഒരു നിലവിളക്കു ഉണ്ടാക്കേണം. നിലവിളക്കു അടിപ്പുപണിയായിരിക്കേണം. അതിന്റെ ചുവടും തണ്ടും പുഷ്പപുടങ്ങളും മുട്ടുകളും പൂക്കളും അതിൽ നിന്നു തന്നേ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","നിലവിളക്കിന്റെ മൂന്നു ശാഖ ഒരു വശത്തുനിന്നും നിലവിളക്കിന്റെ മൂന്നു ശാഖ മറ്റെ വശത്തു നിന്നും ഇങ്ങനെ ആറു ശാഖ അതിന്റെ പാർശ്വങ്ങളിൽനിന്നു പുറപ്പെടേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ഒരു ശാഖയിൽ ഓരോ മുട്ടും ഓരോ പൂവുമായി ബദാംപൂപോലെ മൂന്നു പുഷ്പപുടവും മറ്റൊരു ശാഖയിൽ ഓരോ മുട്ടും ഓരോ പൂവുമായി ബദാംപൂപോലെ മൂന്നു പുഷ്പപുടവും ഉണ്ടായിരിക്കേണം; നിലവിളക്കിൽനിന്നു പുറപ്പെടുന്ന ആറു ശാഖെക്കും അങ്ങനെ തന്നേ വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","വിളക്കുതണ്ടിലോ മുട്ടുകളോടും പൂക്കളോടും കൂടിയ ബദാംപൂപോലെ നാലു പുഷ്പപുടം ഉണ്ടായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","അതിൽനിന്നുള്ള രണ്ടു ശാഖെക്കു കീഴെ ഒരു മുട്ടും മറ്റു രണ്ടു ശാഖെക്കു കീഴെ ഒരു മുട്ടും മറ്റു രണ്ടു ശാഖെക്കു കീഴെ ഒരു മുട്ടും ഇങ്ങനെ നിലവിളക്കിൽ നിന്നു പുറപ്പെടുന്ന ആറു ശാഖെക്കും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","അവയുടെ മുട്ടുകളും ശാഖകളും അതിൽനിന്നു തന്നേ ആയിരിക്കേണം; മുഴുവനും തങ്കം കൊണ്ടു ഒറ്റ അടിപ്പു പണി ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","അതിന്നു ഏഴു ദീപം ഉണ്ടാക്കി നേരെ മുമ്പോട്ടു പ്രകാശിപ്പാൻ തക്കവണ്ണം ദീപങ്ങളെ കൊളുത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","അതിന്റെ ചവണകളും കരിന്തിരിപ്പാത്രങ്ങളും തങ്കംകൊണ്ടു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","അതും ഈ ഉപകരണങ്ങൾ ഒക്കെയും ഒരു താലന്തു തങ്കം കൊണ്ടു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","പർവ്വതത്തിൽവെച്ചു കാണിച്ചുതന്ന മാതൃകപ്രകാരം അവയെ ഉണ്ടാക്കുവാൻ സൂക്ഷിച്ചുകൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","തിരുനിവാസത്തെ പിരിച്ച പഞ്ഞിനൂൽ, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ എന്നിവകൊണ്ടുണ്ടാക്കിയ പത്തു മൂടുശീലകൊണ്ടു തീർക്കേണം, നെയ്ത്തുകാരന്റെ ചിത്രപ്പണിയായ കെരൂബുകൾ ഉള്ളവയായി അവയെ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ഓരോ മൂടുശീലെക്കു ഇരുപത്തെട്ടു മുഴം നീളവും ഓരോ മൂടുശീലെക്കു നാലു മുഴം വീതിയും ഇങ്ങനെ മൂടുശീലെക്കെല്ലാം ഒരു അളവു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","അഞ്ചു മൂടുശീല ഒന്നോടൊന്നു ഇണെച്ചിരിക്കേണം; മറ്റെ അഞ്ചു മൂടുശീലെയും ഒന്നോടൊന്നു ഇണെച്ചിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ഇങ്ങനെ ഇണെച്ചുണ്ടാക്കിയ ഒന്നാമത്തെ വിരിയുടെ അറ്റത്തുള്ള മൂടുശീലെയുടെ വിളുമ്പിൽ നീലനൂൽകൊണ്ടു കണ്ണി ഉണ്ടാക്കേണം; രണ്ടാമത്തെ വിരിയുടെ പുറത്തെ മൂടുശീലയുടെ വിളുമ്പിലും അങ്ങനെ തന്നേ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ഒരു മൂടുശീലയിൽ അമ്പതു കണ്ണി ഉണ്ടാക്കേണം; രണ്ടാമത്തെ വിരിയിലുള്ള മൂടുശീലയുടെ വിളുമ്പിലും അമ്പതു കണ്ണി ഉണ്ടാക്കേണം; കണ്ണി നേർക്കുനേരെ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","പൊന്നുകൊണ്ടു അമ്പതു കൊളുത്തും ഉണ്ടാക്കേണം; തിരുനിവാസം ഒന്നായിരിപ്പാൻ തക്കവണ്ണം മൂടുശീലകളെ കൊളുത്തുകൊണ്ടു ഒന്നിച്ചു ഇണെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","തിരുനിവാസത്തിന്മേൽ മൂടുവിരിയായി കോലാട്ടുരോമം കൊണ്ടു മൂടുശീല ഉണ്ടാക്കേണം; പതിനൊന്നു മൂടുശീല വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ഓരോ മൂടുശീലെക്കു മുപ്പതു മുഴം നീളവും ഓരോ മൂടുശീലെക്കു നാലു മുഴം വീതിയും ഇങ്ങനെ മൂടുശീല പതിനൊന്നും ഒരു അളവു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","അഞ്ചു മൂടുശീല ഒന്നായും ആറു മൂടുശീല ഒന്നായും ഇണെച്ചു ആറാമത്തെ മൂടുശീല കൂടാരത്തിന്റെ മുൻവശത്തു മടക്കി ഇടേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ഇണെച്ചുണ്ടാക്കിയ ഒന്നാമത്തെ വരിയുടെ അറ്റത്തുള്ള മൂടുശീലയുടെ വിളുമ്പിൽ അമ്പതു കണ്ണിയും രണ്ടാമത്തെ വരിയിലെ മൂടുശീലയുടെ വിളുമ്പിൽ അമ്പതു കണ്ണിയും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","താമ്രംകൊണ്ടു അമ്പതു കൊളുത്തും ഉണ്ടാക്കി കൊളുത്തു കണ്ണിയിൽ ഇട്ടു കൂടാരം ഒന്നായിരിക്കത്തക്കവണ്ണം ഇണെച്ചുകൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","മൂടുവിരിയുടെ മൂടുശീലയിൽ മിച്ചമായി കവിഞ്ഞുകിടക്കുന്ന പാതി മൂടുശീല തിരുനിവാസത്തിന്റെ പിൻവശത്തു തൂങ്ങിക്കിടക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","മൂടുവിരിയുടെ മൂടുശീല നീളത്തിൽ ശേഷിപ്പുള്ളതു ഇപ്പുറത്തു ഒരു മുഴവും അപ്പുറത്തു ഒരു മുഴവും ഇങ്ങനെ തിരുനിവാസത്തെ മൂടേണ്ടുന്നതിന്നു അതിന്റെ രണ്ടു പാർശ്വങ്ങളിലും തൂങ്ങിക്കിടക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ചുവപ്പിച്ച ആട്ടുകൊറ്റന്തോൽകൊണ്ടു മൂടുവിരിക്കു ഒരു പുറമൂടിയും അതിന്റെ മീതെ തഹശൂതോൽകൊണ്ടു ഒരു പുറമൂടിയും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","തിരുനിവാസത്തിന്നു ഖദിരമരംകൊണ്ടു നിവിരെ നില്ക്കുന്ന പലകകളും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ഓരോ പലകെക്കു പത്തുമുഴം നീളവും ഒന്നര മുഴം വീതിയും ഉണ്ടായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ഓരോ പലകെക്കു ഒന്നോടൊന്നു ചേർന്നിരിക്കുന്ന രണ്ടു കുടുമ ഉണ്ടായിരിക്കേണം, തിരുനിവാസത്തിന്റെ പലകെക്കു ഒക്കെയും അങ്ങനെ തന്നേ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","തിരുനിവാസത്തിന്നു പലകകൾ ഉണ്ടാക്കേണം; തെക്കു വശത്തേക്കു ഇരുപതു പലക. ");
INSERT INTO mal2015_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ഇരുപതു പലകെക്കും താഴെ വെള്ളികൊണ്ടു നാല്പതു ചുവടു, ഒരു പലകയുടെ അടിയിൽ രണ്ടു കുടുമെക്കു രണ്ടു ചുവടും മറ്റൊരു പലകയുടെ അടിയിൽ രണ്ടു കുടുമെക്കു രണ്ടു ചുവടും ഇങ്ങനെ ഇരുപതു പലകയുടെയും അടിയിൽ വെള്ളികൊണ്ടു നാല്പതു ചുവടു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","തിരുനിവാസത്തിന്റെ മറുപുറത്തു വടക്കുവശത്തേക്കു ഇരുപതു പലകയും ഒരു പലകയുടെ താഴെ രണ്ടു ചുവടു, ");
INSERT INTO mal2015_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","മറ്റൊരു പലകയുടെ താഴെ രണ്ടു ചുവടു, ഇങ്ങനെ അവെക്കു നാല്പതു വെള്ളിച്ചുവടും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","തിരുനിവാസത്തിന്റെ പിൻവശത്തു പടിഞ്ഞാറോട്ടു ആറു പലക ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","തിരുനിവാസത്തിന്റെ രണ്ടു വശത്തുമുള്ള മൂലെക്കു ഈരണ്ടു പലക ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ഇവ താഴെ ഇരട്ടിയായിരിക്കേണം; മേലറ്റത്തോ ഒന്നാം വളയംവരെ തമ്മിൽ ചേർന്നു ഒറ്റയായിരിക്കേണം; രണ്ടിന്നും അങ്ങനെ തന്നേ വേണം; അവ രണ്ടു മൂലെക്കും ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ഇങ്ങനെ എട്ടു പലകയും അവയുടെ വെള്ളിച്ചുവടു, ഒരു പലകയുടെ അടിയിൽ രണ്ടു ചുവടു മറ്റൊരു പലകയുടെ അടിയിൽ രണ്ടു ചുവടു ഇങ്ങനെ പതിനാറു വെള്ളിച്ചുവടും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","ഖദിരമരംകൊണ്ടു അന്താഴങ്ങൾ ഉണ്ടാക്കേണം; തിരുനിവാസത്തിന്റെ ഒരു ഭാഗത്തെ പലകെക്കു അഞ്ചു അന്താഴം ");
INSERT INTO mal2015_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","തിരുനിവാസത്തിന്റെ മറുഭാഗത്തെ പലകെക്കു അഞ്ചു അന്താഴം, തിരുനിവാസത്തിന്റെ പടിഞ്ഞാറെ ഭാഗത്തു പിൻവശത്തെ പലകെക്കു അഞ്ചു അന്താഴം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","നടുവിലത്തെ അന്താഴം പലകയുടെ നടുവിൽ ഒരു അറ്റത്തുനിന്നു മറ്റെ അറ്റത്തോളം ചെല്ലുന്നതായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","പലക പൊന്നുകൊണ്ടു പൊതികയും അന്താഴം ചെലുത്തുവാനുള്ള അവയുടെ വളയങ്ങൾ പൊന്നുകൊണ്ടു ഉണ്ടാക്കുകയും വേണം; അന്താഴങ്ങൾ പൊന്നുകൊണ്ടു പൊതിയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","അങ്ങനെ പർവ്വതത്തിൽവെച്ചു കാണിച്ചുതന്ന പ്രമാണപ്രകാരം നീ തിരുനിവാസം നിവിർത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു ഒരു തിരശ്ശീല ഉണ്ടാക്കേണം; നെയ്ത്തുകാരന്റെ ചിത്രപ്പണിയായ കെരൂബുകളുള്ളതായി അതിനെ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","പൊന്നു പൊതിഞ്ഞതും പൊൻകൊളുത്തുള്ളതും വെള്ളികൊണ്ടുള്ള നാലു ചുവടിന്മേൽ നില്ക്കുന്നതുമായ നാലു ഖദിരസ്തംഭങ്ങളിന്മേൽ അതു തൂക്കിയിടേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","കൊളുത്തുകളിൽ തിരശ്ശീല തൂക്കി സാക്ഷ്യപ്പെട്ടകം തിരശ്ശീലെക്കകത്തു കൊണ്ടുചെന്നു വെക്കേണം; തിരശ്ശീല വിശുദ്ധസ്ഥലവും അതിവിശുദ്ധസ്ഥലവും തമ്മിൽ വേർതിരിക്കുന്നതായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","അതിവിശുദ്ധസ്ഥലത്തു സാക്ഷ്യപ്പെട്ടകത്തിൻ മീതെ കൃപാസനം വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","തിരശ്ശീലയുടെ പുറമെ മേശയും മേശക്കു എതിരെ തിരുനിവാസത്തിന്റെ തെക്കുഭാഗത്തു നിലവിളക്കും വെക്കേണം; മേശ വടക്കുഭാഗത്തു വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽ പണിയായ ഒരു മറയും കൂടാരത്തിന്റെ വാതിലിന്നു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","മറശ്ശീലെക്കു ഖദിരമരംകൊണ്ടു അഞ്ചു തൂണുണ്ടാക്കി പൊന്നുകൊണ്ടു പൊതിയേണം. അവയുടെ കൊളുത്തു പൊന്നുകൊണ്ടു ആയിരിക്കേണം; അവെക്കു താമ്രംകൊണ്ടു അഞ്ചു ചുവടും വാർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","അഞ്ചു മുഴം നീളവും അഞ്ചു മുഴം വീതിയുമായി ഖദിരമരംകൊണ്ടു യാഗപീഠം ഉണ്ടാക്കേണം; യാഗപീഠം സമചതുരവും മൂന്നു മുഴം ഉയരവും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","അതിന്റെ നാലു കോണിലും കൊമ്പുണ്ടാക്കേണം; കൊമ്പു അതിൽനിന്നു തന്നേ ആയിരിക്കേണം; അതു താമ്രംകൊണ്ടു പൊതിയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","അതിലെ വെണ്ണീർ എടുക്കേണ്ടതിന്നു ചട്ടികളും അതിന്റെ ചട്ടുകങ്ങളും കിണ്ണങ്ങളും മുൾകൊളുത്തുകളും തീക്കലശങ്ങളും ഉണ്ടാക്കേണം; അതിന്റെ ഉപകരണങ്ങളൊക്കെയും താമ്രംകൊണ്ടു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","അതിന്നു താമ്രംകൊണ്ടു വലപ്പണിയായി ഒരു ജാലവും ഉണ്ടാക്കേണം; ജാലത്തിന്മേൽ നാലു കോണിലും നാലു താമ്രവളയം ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ജാലം യാഗപീഠത്തിന്റെ പകുതിയോളം എത്തുംവണ്ണം താഴെ യാഗപീഠത്തിന്റെ ചുറ്റുപടിക്കു കീഴായി വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","യാഗപീഠത്തിന്നു ഖദിരമരംകൊണ്ടു തണ്ടുകൾ ഉണ്ടാക്കി താമ്രംകൊണ്ടു പൊതിയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","തണ്ടുകൾ വളയങ്ങളിൽ ഇടേണം; യാഗപീഠം ചുമക്കുമ്പോൾ തണ്ടുകൾ അതിന്റെ രണ്ടു ഭാഗത്തും ഉണ്ടായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","പലകകൊണ്ടു പൊള്ളയായി അതു ഉണ്ടാക്കേണം; പർവ്വതത്തിൽവെച്ചു കാണിച്ചുതന്നപ്രകാരം തന്നേ അതു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","തിരുനിവാസത്തിന്നു പ്രാകാരവും ഉണ്ടാക്കേണം; തെക്കെ ഭാഗത്തേക്കു പ്രാകാരത്തിന്നു പിരിച്ച പഞ്ഞിനൂൽകൊണ്ടു ഒരു ഭാഗത്തേക്കു നൂറു മുഴം നീളത്തിൽ മറശ്ശീല വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","അതിന്റെ ഇരുപതു തൂണും അവയുടെ ഇരുപതു ചുവടും താമ്രംകൊണ്ടും തൂണുകളുടെ കൊളുത്തും മേൽചുറ്റുപടികളും വെള്ളികൊണ്ടും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","അങ്ങനെ തന്നേ വടക്കെ ഭാഗത്തേക്കു നൂറു മുഴം നീളത്തിൽ മറശ്ശീല വേണം; അതിന്റെ ഇരുപതു തൂണും അവയുടെ ഇരുപതു ചുവടും താമ്രംകൊണ്ടും തൂണുകളുടെ കൊളുത്തും മേൽചുറ്റുപടികളും വെള്ളികൊണ്ടും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","പടിഞ്ഞാറെ ഭാഗത്തേക്കു പ്രാകാരത്തിന്റെ വീതിക്കു അമ്പതു മുഴം നീളത്തിൽ മറശ്ശീലയും അതിന്നു പത്തു തൂണും അവെക്കു പത്തു ചുവടും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","കിഴക്കെ ഭാഗത്തേക്കും പ്രാകാരത്തിന്റെ വീതി അമ്പതു മുഴം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ഒരു ഭാഗത്തേക്കു പതിനഞ്ചു മുഴം നീളമുള്ള മറശ്ശീലയും അതിന്നു മൂന്നു തൂണും അവെക്കു മൂന്നു ചുവടും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","മറ്റെ ഭാഗത്തേക്കും പതിനഞ്ചു മുഴം നീളമുള്ള മറശ്ശീലയും അതിന്നു മൂന്നു തൂണും അവെക്കു മൂന്നു ചുവടും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","എന്നാൽ പ്രാകാരത്തിന്റെ വാതിലിന്നു നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽപണിയായി ഇരുപതു മുഴം നീളമുള്ള ഒരു മറയും അതിന്നു നാലു തൂണും അവെക്കു നാലു ചുവടും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","പ്രാകാരത്തിന്റെ എല്ലാ തൂണുകൾക്കും വെള്ളികൊണ്ടു മേൽചുറ്റുപടി വേണം; അവയുടെ കൊളുത്തു വെള്ളികൊണ്ടും അവയുടെ ചുവടു താമ്രംകൊണ്ടും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","പ്രാകാരത്തിന്നു നാനൂറു മുഴം നീളവും എല്ലാടവും അമ്പതു മുഴം വീതിയും അഞ്ചു മുഴം ഉയരവും ഉണ്ടായിരിക്കേണം; അതു പിരിച്ച പഞ്ഞിനൂൽകൊണ്ടും ചുവടു താമ്രംകൊണ്ടും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","തിരുനിവാസത്തിലെ സകലശുശ്രൂഷെക്കുമുള്ള ഉപകരണങ്ങളൊക്കെയും അതിന്റെ എല്ലാകുറ്റികളും പ്രാകാരത്തിന്റെ എല്ലാകുറ്റികളും താമ്രംകൊണ്ടു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","വിളക്കു നിരന്തരം കത്തികൊണ്ടിരിക്കേണ്ടതിന്നു യിസ്രായേൽമക്കൾ വിളക്കിന്നു ഇടിച്ചെടുത്ത തെളിവുള്ള ഒലിവെണ്ണ നിന്റെ അടുക്കൽ കൊണ്ടുവരുവാൻ അവരോടു കല്പിക്ക. ");
INSERT INTO mal2015_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","സമാഗമനകൂടാരത്തിൽ സാക്ഷ്യത്തിന്നു മുമ്പിലുള്ള തിരശ്ശീലെക്കു പുറത്തു അഹരോനും അവന്റെ പുത്രന്മാരും അതിനെ വൈകുന്നേരം മുതൽ പ്രഭാതം വരെ യഹോവയുടെ മുമ്പാകെ കത്തുവാന്തക്കവണ്ണം വെക്കേണം; ഇതു യിസ്രായേൽമക്കൾക്കു തലമുറതലമുറയായി എന്നേക്കുമുള്ള ചട്ടമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","നിന്റെ സഹോദരനായ അഹരോനെയും അവന്റെ പുത്രന്മാരെയും എനിക്കു പുരോഹിതശുശ്രൂഷ ചെയ്യേണ്ടതിന്നു യിസ്രായേൽമക്കളുടെ ഇടയിൽനിന്നു നിന്റെ അടുക്കൽ വരുത്തുക; അഹരോനെയും അഹരോന്റെ പുത്രന്മാരായ നാദാബ്, അബീഹൂ, എലെയാസാർ, ഈഥാമാർ എന്നിവരെയും തന്നേ ");
INSERT INTO mal2015_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","നിന്റെ സഹോദരനായ അഹരോന്നു വേണ്ടി മഹത്വത്തിന്നും അലങ്കാരത്തിന്നുമായി വിശുദ്ധവസ്ത്രം ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","അഹരോൻ എനിക്കു പുരോഹിതശുശ്രൂഷ ചെയ്‌വാൻ തക്കവണ്ണം അവനെ ശുദ്ധീകരിക്കേണ്ടതിന്നു അവന്നു വസ്ത്രം ഉണ്ടാക്കേണമെന്നു ഞാൻ ജ്ഞാനാത്മാവുകൊണ്ടു നിറെച്ചിരിക്കുന്ന സകലജ്ഞാനികളോടും നീ പറയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","അവർ ഉണ്ടാക്കേണ്ടുന്ന വസ്ത്രമോ: പതക്കം, ഏഫോദ്, നീളക്കുപ്പായം, ചിത്രത്തയ്യലുള്ള നിലയങ്കി, മുടി, നടുക്കെട്ടു എന്നിവ തന്നേ. നിന്റെ സഹോദരനായ അഹരോൻ എനിക്കു പുരോഹിതശുശ്രൂഷ ചെയ്യേണ്ടതിന്നു അവർ അവന്നും അവന്റെ പുത്രന്മാർക്കും വിശുദ്ധവസ്ത്രം ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","അതിന്നു പൊന്നു, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവ എടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","പൊന്നു, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു നെയ്ത്തുകാരന്റെ ചിത്രപ്പണിയായി ഏഫോദ് ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","അതിന്റെ രണ്ടു അറ്റത്തോടു ചേർന്നതായി രണ്ടു ചുമൽക്കണ്ടം ഉണ്ടായിരിക്കേണം. അങ്ങനെ അതു തമ്മിൽ ഇണെച്ചിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","അതു കെട്ടിമുറുക്കുവാൻ അതിന്മേലുള്ളതായി ചിത്രപ്പണിയായ നടുക്കെട്ടു അതിൽനിന്നു തന്നേ അതിന്റെ പണിപോലെ പൊന്നു, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","അതു കൂടാതെ രണ്ടു ഗോമേദകക്കല്ലു എടുത്തു അവയിൽ യിസ്രായേൽമക്കളുടെ പേർ കൊത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","അവരുടെ പേരുകളിൽ ആറു ഒരുകല്ലിലും ശേഷമുള്ള ആറു മറ്റെ കല്ലിലും അവരുടെ ജനനക്രമത്തിൽ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","രത്നശില്പിയുടെ പണിയായി മുദ്രക്കൊത്തുപോലെ രണ്ടു കല്ലിലും യിസ്രായേൽ മക്കളുടെ പേർ കൊത്തേണം; അവ പൊന്തടങ്ങളിൽ പതിക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","കല്ലു രണ്ടും ഏഫോദിന്റെ ചുമൽക്കണ്ടങ്ങളിന്മേൽ യിസ്രായേൽമക്കൾക്കു വേണ്ടി ഓർമ്മക്കല്ലായി വെക്കേണം; അഹരോൻ യഹോവയുടെ മുമ്പാകെ അവരുടെ പേർ ഓർമ്മക്കായി തന്റെ രണ്ടു ചുമലിന്മേലും വഹിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","പൊന്നുകൊണ്ടു തടങ്ങൾ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","തങ്കംകൊണ്ടു ചരടുപോലെ മുറിച്ചുകുത്തുപണിയായി രണ്ടു സരപ്പളിയും ഉണ്ടാക്കേണം; മുറിച്ചു കുത്തുപണിയായ സരപ്പളി തടങ്ങളിൽ ചേർക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","ന്യായവിധിപ്പതക്കം ചിത്രപ്പണിയായിട്ടു ഉണ്ടാക്കേണം; അതു ഏഫോദിന്റെ പണിക്കൊത്തതായി പൊന്നു, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവ കൊണ്ടു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","അതു സമചതുരവും ഇരട്ടയും ഒരു ചാൺ നീളമുള്ളതും ഒരു ചാൺ വീതിയുള്ളതും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","അതിൽ കൽപതിപ്പായി നാലു നിര കല്ലു പതിക്കേണം; താമ്രമണി, പീതരത്നം, മരതകം എന്നിവ ഒന്നാമത്തെ നിര. ");
INSERT INTO mal2015_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","രണ്ടാമത്തെ നിര: മാണിക്യം, നീലക്കല്ലു, വജ്രം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","മൂന്നാമത്തെ നിര: പത്മരാഗം, വൈഡൂര്യം, സുഗന്ധിക്കല്ലു. ");
INSERT INTO mal2015_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","നാലാമത്തെ നിര: പുഷ്പരാഗം, ഗോമേദകം, സൂര്യകാന്തം. അവ അതതു തടത്തിൽ പൊന്നിൽ പതിച്ചിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ഈ കല്ലു യിസ്രായേൽമക്കളുടെ പേരോടുകൂടെ അവരുടെ പേർപോലെ പന്ത്രണ്ടായിരിക്കേണം; പന്ത്രണ്ടു ഗോത്രങ്ങളിൽ ഓരോന്നിന്റെ പേർ അവയിൽ മുദ്രക്കൊത്തായി കൊത്തിയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","പതക്കത്തിന്നു ചരടുപോലെ മുറിച്ചുകുത്തുപണിയായി തങ്കംകൊണ്ടു സരപ്പളി ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","പതക്കത്തിന്നു പൊന്നുകൊണ്ടു രണ്ടു വട്ടക്കണ്ണി ഉണ്ടാക്കി പതക്കത്തിന്റെ രണ്ടു അറ്റത്തും വട്ടക്കണ്ണി വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","പൊന്നുകൊണ്ടു മുറിച്ചുകുത്തുപണിയായ സരപ്പളി രണ്ടും പതക്കത്തിന്റെ അറ്റങ്ങളിൽ ഉള്ള വട്ടക്കണ്ണി രണ്ടിലും കൊളുത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","മുറിച്ചുകുത്തുപണിയായ രണ്ടു സരപ്പളിയുടെ മറ്റേ അറ്റം രണ്ടും രണ്ടു തടത്തിൽ കൊളുത്തി ഏഫോദിന്റെ ചുമൽക്കണ്ടങ്ങളിൽ അതിന്റെ മുൻഭാഗത്തു വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","പൊന്നുകൊണ്ടു രണ്ടു വട്ടക്കണ്ണി ഉണ്ടാക്കി പതക്കത്തിന്റെ മറ്റേ രണ്ടു അറ്റത്തും ഏഫോദിന്റെ കീഴറ്റത്തിന്നു നേരെ അതിന്റെ വിളുമ്പിൽ അകത്തായി വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","പൊന്നുകൊണ്ടു വേറെ രണ്ടു വട്ടക്കണ്ണി ഉണ്ടാക്കി, ഏഫോദിന്റെ മുൻഭാഗത്തു അതിന്റെ രണ്ടു ചുമൽക്കണ്ടത്തിന്മേൽ താഴെ അതിന്റെ ഇണെപ്പിന്നരികെ ഏഫോദിന്റെ നടുക്കെട്ടിന്നു മേലായി വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","പതക്കം ഏഫോദിന്റെ നടുക്കെട്ടിന്നു മേലായിരിക്കേണ്ടതിന്നും ഏഫോദിൽ ആടാതിരിക്കേണ്ടതിന്നും അതിന്റെ വട്ടക്കണ്ണികളാൽ ഏഫോദിന്റെ വട്ടക്കണ്ണികളോടു നീലനാടകൊണ്ടു കെട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","അങ്ങനെ അഹരോൻ വിശുദ്ധമന്ദിരത്തിൽ കടക്കുമ്പോൾ ന്യായവിധിപ്പതക്കത്തിൽ യിസ്രായേൽമക്കളുടെ പേർ എപ്പോഴും യഹോവയുടെ മുമ്പാകെ ഓർമ്മെക്കായിട്ടു തന്റെ ഹൃദയത്തിന്മേൽ വഹിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ന്യായവിധിപ്പതക്കത്തിന്നകത്തു ഊറീമും തുമ്മീമും (വെളിപ്പാടും സത്യവും) വെക്കേണം; അഹരോൻ യഹോവയുടെ സന്നിധാനത്തിങ്കൽ കടക്കുമ്പോൾ അവന്റെ ഹൃദയത്തിന്മേൽ ഇരിക്കേണം; അഹരോൻ യിസ്രായേൽമക്കൾക്കുള്ള ന്യായവിധി എപ്പോഴും യഹോവയുടെ മുമ്പാകെ തന്റെ ഹൃദയത്തിന്മേൽ വഹിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ഏഫോദിന്റെ അങ്കി മുഴുവനും നീലനൂൽകൊണ്ടു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","അതിന്റെ നടുവിൽ തല കടപ്പാൻ ഒരു ദ്വാരം വേണം; ദ്വാരത്തിന്നു നെയ്ത്തുപണിയായ ഒരു നാട ചുറ്റിലും വേണം; അതു കീറിപ്പോകാതിരിപ്പാൻ കവചത്തിന്റെ ദ്വാരംപോലെ അതിന്നു ഉണ്ടായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ എന്നിവകൊണ്ടു ചുറ്റും അതിന്റെ വിളുമ്പിൽ മാതളപ്പഴങ്ങളും അവയുടെ ഇടയിൽ ചുറ്റും പൊന്നുകൊണ്ടു മണികളും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","അങ്കിയുടെ വിളുമ്പിൽ ചുറ്റും ഒരു പൊന്മണി ഒരു മാതളപ്പഴം, ഒരു പൊന്മണി ഒരു മാതളപ്പഴം, ഇങ്ങനെ വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ശുശ്രൂഷ ചെയ്കയിൽ അഹരോൻ അതു ധരിക്കേണം. യഹോവയുടെ മുമ്പാകെ വിശുദ്ധമന്ദിരത്തിൽ കടക്കുമ്പോഴും പുറത്തു വരുമ്പോഴും അവൻ മരിക്കാതിരിക്കേണ്ടതിന്നു അതിന്റെ ശബ്ദം കേൾക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","തങ്കംകൊണ്ടു ഒരു പട്ടം ഉണ്ടാക്കി അതിൽ “യഹോവെക്കു വിശുദ്ധം” എന്നു മുദ്രക്കൊത്തായി കൊത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","അതു മുടിമേൽ ഇരിക്കേണ്ടതിന്നു നീലച്ചരടുകൊണ്ടു കെട്ടേണം; അതു മുടിയുടെ മുൻഭാഗത്തു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","യിസ്രായേൽമക്കൾ തങ്ങളുടെ സകല വിശുദ്ധവഴിപാടുകളിലും ശുദ്ധീകരിക്കുന്ന വിശുദ്ധവസ്തുക്കളുടെ കുറ്റം അഹരോൻ വഹിക്കേണ്ടതിന്നു അതു അഹരോന്റെ നെറ്റിയിൽ ഇരിക്കേണം; യഹോവയുടെ മുമ്പാകെ അവർക്കു പ്രസാദം ലഭിക്കേണ്ടതിന്നു അതു എപ്പോഴും അവന്റെ നെറ്റിയിൽ ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","പഞ്ഞിനൂൽകൊണ്ടു ഉള്ളങ്കിയും വിചിത്രപ്പണിയായി നെയ്യേണം; പഞ്ഞിനൂൽകൊണ്ടു മുടിയും ഉണ്ടാക്കേണം; നടുക്കെട്ടും ചിത്രത്തയ്യൽപണിയായിട്ടു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","അഹരോന്റെ പുത്രന്മാർക്കു മഹത്വത്തിന്നും അലങ്കാരത്തിന്നുമായിട്ടു അങ്കി, നടുക്കെട്ടു, തലപ്പാവു എന്നിവ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","അവ നിന്റെ സഹോദരനായ അഹരോനെയും അവന്റെ പുത്രന്മാരെയും ധരിപ്പിക്കേണം; അവർ എനിക്കു പുരോഹിതശുശ്രൂഷ ചെയ്യേണ്ടതിന്നു അവരെ അഭിഷേകവും കരപൂരണവും ചെയ്തു ശുദ്ധീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","അവരുടെ നഗ്നത മറെപ്പാൻ അവർക്കു ചണനൂൽകൊണ്ടു കാൽചട്ടയും ഉണ്ടാക്കേണം; അതു അര തുടങ്ങി തുടവരെ എത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","അഹരോനും അവന്റെ പുത്രന്മാരും വിശുദ്ധമന്ദിരത്തിൽ ശുശ്രൂഷ ചെയ്‌വാൻ സമാഗമനകൂടാരത്തിൽ കടക്കുമ്പോഴോ യാഗപീഠത്തിന്റെ അടുക്കൽ ചെല്ലുമ്പോഴോ കുറ്റം ചുമന്നു മരിക്കാതിരിക്കേണ്ടതിന്നു അവർ അതു ധരിക്കേണം. അവന്നും അവന്റെ സന്തതിക്കും അതു എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","അവർ എനിക്കു പുരോഹിതശുശ്രൂഷ ചെയ്‌വാൻ അവരെ ശുദ്ധീകരിക്കേണ്ടതിന്നു നീ അവർക്കു ചെയ്യേണ്ടതു എന്തെന്നാൽ: ഒരു കാളക്കിടാവിനെയും ഊനമില്ലാത്ത രണ്ടു ആട്ടുകൊറ്റനെയും ");
INSERT INTO mal2015_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","പുളിപ്പില്ലാത്ത അപ്പവും എണ്ണ ചേർത്ത പുളിപ്പില്ലാത്ത ദോശകളും എണ്ണ പിരട്ടിയ പുളിപ്പില്ലാത്ത വടകളും എടുക്കേണം; കോതമ്പുമാവുകൊണ്ടു അവ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","അവ ഒരു കൊട്ടയിൽ വെച്ചു കാളയോടും രണ്ടു ആട്ടുകൊറ്റനോടുംകൂടെ കൊട്ടയിൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","അഹരോനെയും അവന്റെ പുത്രന്മാരെയും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ വരുത്തി വെള്ളംകൊണ്ടു കഴുകേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","പിന്നെ വസ്ത്രം എടുത്തു അഹരോനെ ഉള്ളങ്കിയും ഏഫോദിന്റെ അങ്കിയും ഏഫോദും പതക്കവും ധരിപ്പിച്ചു അവന്റെ അരെക്കു ഏഫോദിന്റെ നടുക്കെട്ടു കെട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","അവന്റെ തലയിൽ മുടി വെച്ചു വിശുദ്ധപട്ടം മുടിമേൽ വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","പിന്നെ അഭിഷേകതൈലം എടുത്തു തലയിൽ ഒഴിച്ചു അവനെ അഭിഷേകം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","അവന്റെ പുത്രന്മാരെയും കൊണ്ടുവന്നു അങ്കി ധരിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","അഹരോന്റെയും പുത്രന്മാരുടെയും അരെക്കു നടുക്കെട്ടു കെട്ടി അവർക്കു തലപ്പാവു വെക്കേണം. പൗരോഹിത്യം അവർക്കു നിത്യാവകാശമായിരിക്കേണം. പിന്നെ നീ അഹരോന്നും അവന്റെ പുത്രന്മാർക്കും കരപൂരണം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","നീ കാളയെ സമാഗമനകൂടാരത്തിന്റെ മുമ്പാകെ വരുത്തേണം; അഹരോനും അവന്റെ പുത്രന്മാരും കാളയുടെ തലമേൽ കൈവെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","പിന്നെ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ യഹോവയുടെ മുമ്പാകെ കാളയെ അറുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","കാളയുടെ രക്തം കുറെ എടുത്തു നിന്റെ വിരൽകൊണ്ടു യാഗപീഠത്തിന്റെ കൊമ്പുകളിന്മേൽ പുരട്ടി ശേഷമുള്ള രക്തം ഒക്കെയും യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","കുടൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സു ഒക്കെയും കരളിന്മേൽ ഉള്ള വപയും മൂത്രപിണ്ഡം രണ്ടും അവയുടെ മേലുള്ള മേദസ്സും എടുത്തു യാഗപീഠത്തിന്മേൽ വെച്ചു ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","കാളയുടെ മാംസവും തോലും ചാണകവും പാളയത്തിന്നു പുറത്തു തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ഇതു പാപയാഗം. പിന്നെ ഒരു ആട്ടുകൊറ്റനെ എടുക്കേണം; അഹരോനും അവന്റെ പുത്രന്മാരും ആട്ടുകൊറ്റന്റെ തലമേൽ കൈവെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ആട്ടുകൊറ്റനെ അറുത്തു അതിന്റെ രക്തം എടുത്തു യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ആട്ടുകൊറ്റനെ ഖണ്ഡംഖണ്ഡമായി മുറിച്ചു അതിന്റെ കുടലും കാലും കഴുകി ഖണ്ഡങ്ങളുടെ മേലും അതിന്റെ തലയുടെ മേലും വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ആട്ടുകൊറ്റനെ മുഴുവനും യാഗപീഠത്തിന്മേൽ വെച്ചു ദഹിപ്പിക്കേണം. ഇതു യഹോവെക്കു ഹോമയാഗം, യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","പിന്നെ നീ മറ്റെ ആട്ടുകൊറ്റനെ എടുക്കേണം; അഹരോനും അവന്റെ പുത്രന്മാരും ആട്ടുകൊറ്റന്റെ തലമേൽ കൈ വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ആട്ടുകൊറ്റനെ അറുത്തു അതിന്റെ രക്തം കുറേ എടുത്തു അഹരോന്റെ വലത്തെ കാതിന്നും അവന്റെ പുത്രന്മാരുടെ വലത്തെ കാതിന്നും അവരുടെ വലത്തെ കയ്യുടെ പെരുവിരലിന്നും വലത്തെ കാലിന്റെ പെരുവിരലിന്നും പുരട്ടി രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","പിന്നെ നീ യാഗപീഠത്തിന്മേലുള്ള രക്തവും അഭിഷേകതൈലവും കുറേശ്ശ എടുത്തു അഹരോന്റെമേലും അവന്റെ വസ്ത്രത്തിന്മേലും അവന്റെ പുത്രന്മാരുടെമേലും അവരുടെ വസ്ത്രത്തിന്മേലും തളിക്കേണം; ഇങ്ങനെ അവനും അവന്റെ വസ്ത്രവും അവന്റെ പുത്രന്മാരും അവരുടെ വസ്ത്രവും ശുദ്ധീകരിക്കപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","അതു കരപൂരണത്തിന്റെ ആട്ടുകൊറ്റൻ ആകകൊണ്ടു നീ അതിന്റെ മേദസ്സും തടിച്ച വാലും കുടൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും കരളിന്മേലുള്ള വപയും മൂത്രപിണ്ഡം രണ്ടും അവയുടെ മേലുള്ള മേദസ്സും ");
INSERT INTO mal2015_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","വലത്തെ കൈക്കുറകും യഹോവയുടെ മുമ്പാകെ വെച്ചിരിക്കുന്ന പുളിപ്പില്ലാത്ത അപ്പത്തിന്റെ കൊട്ടയിൽനിന്നു ഒരു അപ്പവും എണ്ണ പകർന്ന അപ്പമായ ഒരു ദോശയും ഒരു വടയും എടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","അതു ഒക്കെയും അഹരോന്റെ കയ്യിലും അവന്റെ പുത്രന്മാരുടെ കയ്യിലും വെച്ചു യഹോവയുടെ സന്നിധിയിൽ നീരാജനാർപ്പണമായി നീരാജനം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","പിന്നെ അവരുടെ കയ്യിൽ നിന്നു അവ വാങ്ങി യാഗപീഠത്തിന്മേൽ ഹോമയാഗത്തിന്നു മീതെ യഹോവയുടെ സന്നിധിയിൽ സൗരഭ്യവാസനയായി ദഹിപ്പിക്കേണം; ഇതു യഹോവെക്കു ദഹനയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","പിന്നെ അഹരോന്റെ കരപൂരണത്തിന്നുള്ള ആട്ടുകൊറ്റന്റെ നെഞ്ചു എടുത്തു യഹോവയുടെ സന്നിധിയിൽ നീരാജനാർപ്പണമായി നീരാജനം ചെയ്യേണം; അതു നിന്റെ ഓഹരിയായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","അഹരോന്റെയും അവന്റെ പുത്രന്മാരുടെയും കരപൂരണത്തിന്നുള്ള ആട്ടുകൊറ്റന്റെ നീരാജനവും ഉദർച്ചയുമായി നീരാജനാർപ്പണമായ നെഞ്ചും ഉദർച്ചാർപ്പണമായ കൈക്കുറകും നീ ശുദ്ധീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","അതു ഉദർച്ചാർപ്പണമാകകൊണ്ടു യിസ്രായേൽമക്കളുടെ പക്കൽനിന്നു നിത്യാവകാശമായിട്ടു അഹരോന്നും അവന്റെ പുത്രന്മാർക്കും ഉള്ളതായിരിക്കേണം; അതു യിസ്രായേൽമക്കൾ അർപ്പിക്കുന്ന സമാധാനയാഗത്തിന്റെ ഉദർച്ചാർപ്പണമായി യഹോവെക്കുള്ള ഉദർച്ചാർപ്പണം തന്നേ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","അഹരോന്റെ വിശുദ്ധവസ്ത്രം അവന്റെ ശേഷം അവന്റെ പുത്രന്മാർക്കുള്ളതാകേണം; അതു ധരിച്ചു അവർ അഭിഷേകവും കരപൂരണവും പ്രാപിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","അവന്റെ പുത്രന്മാരിൽ അവന്നു പകരം പുരോഹിതനായി വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷ ചെയ്‌വാൻ സമാഗമനകൂടാരത്തിൽ കടക്കുന്നവൻ ഏഴു ദിവസം അതു ധരിക്കേണം ");
INSERT INTO mal2015_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","കരപൂരണത്തിന്റെ ആട്ടുകൊറ്റനെ എടുത്തു അതിന്റെ മാംസം വിശുദ്ധമായോരു സ്ഥലത്തു വെച്ചു പാകം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ആട്ടുകൊറ്റന്റെ മാംസവും കൊട്ടയിലുള്ള അപ്പവും അഹരോനും അവന്റെ പുത്രന്മാരും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽവെച്ചു തിന്നേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","അവരുടെ കരപൂരണത്തിന്നും വിശുദ്ധീകരണത്തിന്നും വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കുന്ന വസ്തുക്കളെ അവർ തിന്നേണം; അവ വിശുദ്ധമായിരിക്കയാൽ അന്യൻ തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","കരപൂരണയാഗത്തിന്റെ മാംസത്തിലും അപ്പത്തിലും വല്ലതും പ്രഭാതകാലംവരെ ശേഷിച്ചിരുന്നാൽ ആ ശേഷിപ്പു തീയിൽ ഇട്ടു ചുട്ടുകളയേണം; അതു വിശുദ്ധമാകകൊണ്ടു തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","അങ്ങനെ ഞാൻ നിന്നോടു കല്പിച്ചതുപോലെ ഒക്കെയും നീ അഹരോന്നും അവന്റെ പുത്രന്മാർക്കും ചെയ്യേണം; ഏഴു ദിവസം അവർക്കു കരപൂരണം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","പ്രായശ്ചിത്തത്തിന്നായി ദിവസേന ഓരോ കാളയെ പാപയാഗമായിട്ടു അർപ്പിക്കേണം; യാഗപീഠത്തിന്നും പ്രായശ്ചിത്തം കഴിച്ചു പാപശുദ്ധി വരുത്തുകയും അതിനെ ശുദ്ധീകരിക്കേണ്ടതിന്നു അഭിഷേകം ചെയ്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ഏഴു ദിവസം നീ യാഗപീഠത്തിന്നായി പ്രായശ്ചിത്തം കഴിച്ചു അതിനെ ശുദ്ധീകരിക്കേണം; യാഗപീഠം അതിവിശുദ്ധമായിരിക്കേണം; യാഗപീഠത്തെ തൊടുന്നവനൊക്കെയും വിശുദ്ധനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","യാഗപീഠത്തിന്മേൽ അർപ്പിക്കേണ്ടതു എന്തെന്നാൽ: ദിവസന്തോറും നിരന്തരം ഒരു വയസ്സുപ്രായമുള്ള രണ്ടു ആട്ടിൻകുട്ടി; ");
INSERT INTO mal2015_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ഒരു ആട്ടിൻകുട്ടിയെ രാവിലെ അർപ്പിക്കേണം; മറ്റെ ആട്ടിൻകുട്ടിയെ വൈകുന്നേരത്തു അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ഇടിച്ചെടുത്ത കാൽഹീൻ എണ്ണ പകർന്നിരിക്കുന്ന ഒരു ഇടങ്ങഴി നേരിയ മാവും പാനീയയാഗമായി കാൽഹീൻ വീഞ്ഞും ആട്ടിൻകുട്ടിയോടുകൂടെ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","മറ്റെ ആട്ടിൻകുട്ടിയെ രാവിലത്തെ ഭോജനയാഗത്തിന്നും അതിന്റെ പാനീയയാഗത്തിന്നും ഒത്തവണ്ണം ഒരുക്കി സൗരഭ്യവാസനയായി യഹോവെക്കു ദഹനയാഗമായി വൈകുന്നേരത്തു അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ഞാൻ നിന്നോടു സംസാരിക്കേണ്ടതിന്നു നിങ്ങൾക്കു വെളിപ്പെടുവാനുള്ള സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽവെച്ചു യഹോവയുടെ മുമ്പാകെ ഇതു നിങ്ങൾക്കു തലമുറതലമുറയായി നിരന്തരഹോമയാഗമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","അവിടെ ഞാൻ യിസ്രായേൽമക്കൾക്കു വെളിപ്പെടും. അതു എന്റെ തേജസ്സിനാൽ ശുദ്ധീകരിക്കപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ഞാൻ സമാഗമനകൂടാരവും യാഗപീഠവും ശുദ്ധീകരിക്കും. ഞാൻ അഹരോനെയും അവന്റെ പുത്രന്മാരെയും എനിക്കു പുരോഹിതശുശ്രൂഷ ചെയ്യേണ്ടതിന്നു ശുദ്ധീകരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ഞാൻ യിസ്രായേൽമക്കളുടെ മദ്ധ്യേ വസിക്കയും അവർക്കു ദൈവമായിരിക്കയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","അവരുടെ മദ്ധ്യേ വസിക്കേണ്ടതിന്നു അവരെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്നവനായി അവരുടെ ദൈവമായ യഹോവ ഞാൻ ആകുന്നു എന്നു അവർ അറിയും; ഞാൻ അവരുടെ ദൈവമായ യഹോവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","ധൂപം കാട്ടുവാൻ ഒരു ധൂപപീഠവും ഉണ്ടാക്കേണം; ഖദിരമരംകൊണ്ടു അതു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","അതു ഒരു മുഴം നീളവും ഒരു മുഴം വീതിയുമായി സമചതുരവും രണ്ടു മുഴം ഉയരവും ആയിരിക്കേണം. അതിന്റെ കൊമ്പുകൾ അതിൽനിന്നു തന്നേ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","അതിന്റെ മേല്പലകയും ചുറ്റും അതിന്റെ പാർശ്വങ്ങളും കൊമ്പുകളും ഇങ്ങനെ അതു മുഴുവനും തങ്കംകൊണ്ടു പൊതിയേണം. അതിന്നു ചുറ്റും പൊന്നുകൊണ്ടു ഒരു വക്കും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ചുമക്കേണ്ടതിന്നു തണ്ടു ചെലുത്തുവാൻ അതിന്റെ വക്കിന്നു കീഴെ ഇരുപുറത്തും ഈരണ്ടു പൊൻവളയവും ഉണ്ടാക്കേണം. അതിന്റെ രണ്ടു പാർശ്വത്തിലും അവയെ ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","തണ്ടുകൾ ഖദിരമരംകൊണ്ടു ഉണ്ടാക്കി പൊന്നു പൊതിയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","സാക്ഷ്യപെട്ടകത്തിന്റെ മുമ്പിലും ഞാൻ നിനക്കു വെളിപ്പെടുവാനുള്ള ഇടമായി സാക്ഷ്യത്തിന്മീതെയുള്ള കൃപാസനത്തിന്റെ മുമ്പിലും ഇരിക്കുന്ന തിരശ്ശീലെക്കു മുമ്പാകെ അതു വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","അഹരോൻ അതിന്മേൽ സുഗന്ധധൂപം കാട്ടേണം; അവൻ ദിനംപ്രതി കാലത്തു ദീപം തുടെക്കുമ്പോൾ അങ്ങനെ ധൂപം കാട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","അഹരോൻ വൈകുന്നേരം ദീപം കൊളുത്തുമ്പോഴും അങ്ങനെ സുഗന്ധധൂപം കാട്ടേണം. അതു തലമുറതലമുറയായി യഹോവയുടെ മുമ്പാകെ നിരന്തരധൂപം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","നിങ്ങൾ അതിന്മേൽ അന്യധൂപമോ ഹോമയാഗമോ ഭോജനയാഗമോ അർപ്പിക്കരുതു; അതിന്മേൽ പാനീയയാഗം ഒഴിക്കയുമരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","സംവത്സരത്തിൽ ഒരിക്കൽ അഹരോൻ അതിന്റെ കൊമ്പുകൾക്കു വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; പ്രായശ്ചിത്തത്തിന്നുള്ള പാപയാഗത്തിന്റെ രക്തംകൊണ്ടു അവൻ തലമുറതലമുറയായി വർഷാന്തരപ്രായശ്ചിത്തം കഴിക്കേണം; ഇതു യഹോവെക്കു അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","യിസ്രായേൽമക്കളുടെ ജനസംഖ്യ എടുക്കേണ്ടതിന്നു അവരെ എണ്ണുമ്പോൾ അവരുടെ മദ്ധ്യേ ബാധ ഉണ്ടാകാതിരിപ്പാൻ അവരിൽ ഓരോരുത്തൻ താന്താന്റെ ജീവന്നുവേണ്ടി യഹോവെക്കു വീണ്ടെടുപ്പുവില കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","എണ്ണപ്പെടുന്നവരുടെ കൂട്ടത്തിൽ ഉൾപ്പെടുന്ന ഏവനും വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം അര ശേക്കെൽ കൊടുക്കേണം. ശേക്കെൽ എന്നതു ഇരുപതു ഗേരാ. ആ അര ശേക്കെൽ യഹോവെക്കു വഴിപാടു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","എണ്ണപ്പെടുന്നവരുടെ കൂട്ടത്തിൽ ഇരുപതു വയസ്സും അതിന്നു മീതെയുമുള്ളവനെല്ലാം യഹോവെക്കു വഴിപാടു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","നിങ്ങളുടെ ജിവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിപ്പാൻ നിങ്ങൾ യഹോവെക്കു വഴിപാടു കൊടുക്കുമ്പോൾ ധനവാൻ അരശേക്കെലിൽ അധികം കൊടുക്കരുതു; ദരിദ്രൻ കുറെച്ചു കൊടുക്കയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ഈ പ്രായശ്ചിത്തദ്രവ്യം നീ യിസ്രായേൽമക്കളോടു വാങ്ങി സമാഗമനകൂടാരത്തിന്റെ ശുശ്രൂഷെക്കായി കൊടുക്കേണം. നിങ്ങളുടെ ജീവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണ്ടതിന്നു അതു യഹോവയുടെ മുമ്പാകെ യിസ്രായേൽമക്കൾക്കു വേണ്ടി ഒരു ജ്ഞാപകമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","കഴുകേണ്ടതിന്നു ഒരു താമ്രത്തൊട്ടിയും അതിന്നു ഒരു താമ്രക്കാലും ഉണ്ടാക്കേണം; അതിനെ സമാഗമനകൂടാരത്തിന്നും യാഗപീഠത്തിനും മദ്ധ്യേ വെച്ചു അതിൽ വെള്ളം ഒഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","അതിങ്കൽ അഹരോനും അവന്റെ പുത്രന്മാരും കയ്യും കാലും കഴുകേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","അവർ സമാഗമനകൂടാരത്തിൽ കടക്കയോ യഹോവെക്കു ദഹനയാഗം കഴിക്കേണ്ടതിന്നു യാഗപീഠത്തിങ്കൽ ശുശ്രൂഷിപ്പാൻ ചെല്ലുകയോ ചെയ്യുമ്പോൾ മരിക്കാതിരിക്കേണ്ടതിന്നു വെള്ളംകൊണ്ടു കഴുകേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","അവർ മരിക്കാതിരിക്കേണ്ടതിന്നു കയ്യും കാലും കഴുകേണം; അതു അവർക്കു തലമുറതലമുറയായി എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു എന്തെന്നാൽ; ");
INSERT INTO mal2015_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","മേത്തരമായ സുഗന്ധവർഗ്ഗമായി വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം അഞ്ഞൂറു ശേക്കെൽ അയഞ്ഞ മൂരും അതിൽ പാതി ഇരുനൂറ്റമ്പതു ശേക്കെൽ സുഗന്ധലവംഗവും ");
INSERT INTO mal2015_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","അഞ്ഞൂറു ശേക്കെൽ വഴനത്തൊലിയും ഒരു ഹീൻ ഒലിവെണ്ണയും എടുത്തു ");
INSERT INTO mal2015_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","തൈലക്കാരന്റെ വിദ്യപ്രകാരം ചേർത്തുണ്ടാക്കിയ വിശുദ്ധമായ അഭിഷേക തൈലമാക്കേണം; അതു വിശുദ്ധമായ അഭിഷേകതൈലമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","അതിനാൽ നീ സമാഗമനകൂടാരവും സാക്ഷ്യപെട്ടകവും മേശയും ");
INSERT INTO mal2015_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","അതിന്റെ ഉപകരണങ്ങളൊക്കെയും നിലവിളക്കും അതിന്റെ ഉപകരണങ്ങളും ");
INSERT INTO mal2015_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ധൂപപീഠവും ഹോമയാഗപീഠവും അതിന്റെ ഉപകരണങ്ങളൊക്കെയും തൊട്ടിയും അതിന്റെ കാലും അഭിഷേകം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","അവ അതിവിശുദ്ധമായിരിക്കേണ്ടതിന്നു അവയെ ശുദ്ധീകരിക്കേണം; അവയെ തൊടുന്നവനൊക്കെയും വിശുദ്ധനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","അഹരോനെയും അവന്റെ പുത്രന്മാരെയും എനിക്കു പുരോഹിതശുശ്രൂഷ ചെയ്യേണ്ടതിന്നു നീ അഭിഷേകം ചെയ്തു ശുദ്ധീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","യിസ്രായേൽമക്കളോടു നീ പറയേണ്ടതു എന്തെന്നാൽ: ഇതു നിങ്ങളുടെ തലമുറകളിൽ എനിക്കു വിശുദ്ധമായ അഭിഷേകതൈലം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","അതു മനുഷ്യന്റെ ദേഹത്തിന്മേൽ ഒഴിക്കരുതു; അതിന്റെ യോഗപ്രകാരം അതുപോലെയുള്ളതു നിങ്ങൾ ഉണ്ടാക്കുകയും അരുതു; അതു വിശുദ്ധമാകുന്നു; അതു നിങ്ങൾക്കു വിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","അതുപോലെയുള്ള തൈലം ഉണ്ടാക്കുന്നവനെയും അതിൽനിന്നു അന്യന്നു കൊടുക്കുന്നവനെയും അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു എന്തെന്നാൽ: നീ നറുംപശ, ഗുല്ഗുലു, ഹൽബാനപ്പശ എന്നീ സുഗന്ധവർഗ്ഗവും നിർമ്മലസാമ്പ്രാണിയും എടുക്കേണം; എല്ലാം ഒരുപോലെ തൂക്കം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","അതിൽ ഉപ്പും ചേർത്തു തൈലക്കാരന്റെ വിദ്യപ്രകാരം നിർമ്മലവും വിശുദ്ധവുമായ ധൂപവർഗ്ഗമാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","നീ അതിൽ ഏതാനും ഇടിച്ചു പൊടിയാക്കി, ഞാൻ നിനക്കു വെളിപ്പെടുവാനുള്ള സമാഗമനകൂടാരത്തിലെ സാക്ഷ്യത്തിന്നു മുമ്പാകെ വെക്കേണം; അതു നിങ്ങൾക്കു അതിവിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ഈ ഉണ്ടാക്കുന്ന ധൂപവർഗ്ഗത്തിന്റെ യോഗത്തിന്നു ഒത്തതായി നിങ്ങൾക്കു ഉണ്ടാക്കരുതു; അതു യഹോവെക്കു വിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","മണക്കേണ്ടതിന്നു അതുപോലെയുള്ളതു ആരെങ്കിലും ഉണ്ടാക്കിയാൽ അവനെ അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","ഇതാ, ഞാൻ യെഹൂദാഗോത്രത്തിൽ ഹൂരിന്റെ മകനായ ഊരിയുടെ മകൻ ബെസലേലിനെ പേർ ചൊല്ലി വിളിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","അവൻ കൗശലപ്പണികളെ സങ്കല്പിച്ചു ചെയ്‌വാനും പൊന്നു, വെള്ളി, താമ്രം എന്നിവകൊണ്ടു പണി ചെയ്‌വാനും രത്നം വെട്ടി പതിപ്പാനും ");
INSERT INTO mal2015_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","മരത്തിൽ കൊത്തുപണി ചെയ്‌വാനും സകലവിധമായ പണിത്തരം ഉണ്ടാക്കുവാനും ഞാൻ അവനെ ");
INSERT INTO mal2015_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ദിവ്യാത്മാവിനാൽ ജ്ഞാനവും ബുദ്ധിയും അറിവും സകലവിധസാമർത്ഥ്യവുംകൊണ്ടു നിറെച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ഞാൻ ദാൻഗോത്രത്തിൽ അഹീസാമാക്കിന്റെ മകനായ ഒഹൊലിയാബിനെ അവനോടുകൂടെ ആക്കുകയും സകല ജ്ഞാനികളുടെ ഹൃദയത്തിലും ജ്ഞാനം നല്കുകയും ചെയ്തിരിക്കുന്നു. ഞാൻ നിന്നോടു കല്പിച്ചതു ഒക്കെയും അവർ ഉണ്ടാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","സമാഗമനകൂടാരവും സാക്ഷ്യപെട്ടകവും അതിന്മീതെയുള്ള കൃപാസനവും കൂടാരത്തിന്റെ ഉപകരണങ്ങളൊക്കെയും ");
INSERT INTO mal2015_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","മേശയും അതിന്റെ ഉപകരണങ്ങളും തങ്കംകൊണ്ടുള്ള നിലവിളക്കും അതിന്റെ ഉപകരണങ്ങളൊക്കെയും ");
INSERT INTO mal2015_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ധൂപപീഠവും ഹോമയാഗപീഠവും അതിന്റെ ഉപകരണങ്ങളൊക്കെയും തൊട്ടിയും അതിന്റെ കാലും വിശേഷവസ്ത്രങ്ങളും ");
INSERT INTO mal2015_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","പുരോഹിതനായ അഹരോന്റെ വിശുദ്ധവസ്ത്രങ്ങളും പുരോഹിതശുശ്രൂഷെക്കായിട്ടു ");
INSERT INTO mal2015_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","അവന്റെ പുത്രന്മാരുടെ വസ്ത്രങ്ങളും അഭിഷേകതൈലവും വിശുദ്ധമന്ദിരത്തിന്നുള്ള സുഗന്ധധൂപവർഗ്ഗവും ഞാൻ നിന്നോടു കല്പിച്ചതുപോലെ ഒക്കെയും അവർ ഉണ്ടാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു: നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: നിങ്ങൾ എന്റെ ശബ്ബത്തുകളെ ആചരിക്കേണം. ഞാൻ നിങ്ങളെ ശുദ്ധീകരിക്കുന്ന യഹോവയാകുന്നു എന്നു അറിയേണ്ടതിന്നു അതു തലമുറതലമുറയായി എനിക്കും നിങ്ങൾക്കും മദ്ധ്യേ ഒരു അടയാളം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","അതുകൊണ്ടു നിങ്ങൾ ശബ്ബത്ത് ആചരിക്കേണം; അതു നിങ്ങൾക്കു വിശുദ്ധം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","അതിനെ അശുദ്ധമാക്കുന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം. ആരെങ്കിലും അന്നു വേല ചെയ്താൽ അവനെ അവന്റെ ജനത്തിന്റെ ഇടയിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ആറു ദിവസം വേല ചെയ്യേണം; എന്നാൽ ഏഴാം ദിവസം സ്വസ്ഥമായുള്ള ശബ്ബത്തായി യഹോവെക്കു വിശുദ്ധം ആകുന്നു; ആരെങ്കിലും ശബ്ബത്ത് നാളിൽ വേല ചെയ്താൽ അവൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ആകയാൽ യിസ്രായേൽമക്കൾ തലമുറതലമുറയായി ശബ്ബത്തിനെ നിത്യനിയമമായിട്ടു ആചരിക്കേണ്ടതിന്നു ശബ്ബത്തിനെ പ്രമാണിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","അതു എനിക്കും യിസ്രായേൽമക്കൾക്കും മദ്ധ്യേ എന്നേക്കും ഒരു അടയാളം ആകുന്നു; ആറു ദിവസംകൊണ്ടല്ലോ യഹോവ ആകാശത്തെയും ഭൂമിയെയും ഉണ്ടാക്കിയതു; ഏഴാംദിവസം അവൻ സ്വസ്ഥമായിരുന്നു വിശ്രമിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","അവൻ സീനായി പർവ്വതത്തിൽ വെച്ചു മോശെയോടു അരുളിച്ചെയ്തു കഴിഞ്ഞശേഷം ദൈവത്തിന്റെ വിരൽകൊണ്ടു എഴുതിയ കല്പലകകളായ സാക്ഷ്യപലക രണ്ടും അവന്റെ പക്കൽ കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","എന്നാൽ മോശെ പർവ്വതത്തിൽനിന്നു ഇറങ്ങിവരുവാൻ താമസിക്കുന്നു എന്നു ജനം കണ്ടപ്പോൾ ജനം അഹരോന്റെ അടുക്കൽ വന്നുകൂടി അവനോടു: നീ എഴുന്നേറ്റു, ഞങ്ങളുടെ മുമ്പിൽ നടക്കേണ്ടതിന്നു ഒരു ദൈവത്തെ ഉണ്ടാക്കി തരിക; ഞങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെടുവിച്ചു കൊണ്ടുവന്ന പുരുഷനായ ഈ മോശെക്കു എന്തു ഭവിച്ചു എന്നു ഞങ്ങൾ അറിയുന്നില്ലല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","അഹരോൻ അവരോടു: നിങ്ങളുടെ ഭാര്യമാരുടെയും പുത്രന്മാരുടെയും പുത്രിമാരുടെയും കാതിലെ പൊൻകുണുക്കു പറിച്ചു എന്റെ അടുക്കൽ കൊണ്ടുവരുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ജനം ഒക്കെയും തങ്ങളുടെ കാതിൽ നിന്നു പൊൻകുണുക്കു പറിച്ചു അഹരോന്റെ അടുക്കൽ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","അവൻ അതു അവരുടെ കയ്യിൽനിന്നു വാങ്ങി, ഒരു കൊത്തുളികൊണ്ടു ഭാഷവരുത്തി ഒരു കാളക്കുട്ടിയെ വാർത്തുണ്ടാക്കി. അപ്പോൾ അവർ: യിസ്രായേലേ, ഇതു നിന്നെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്ന നിന്റെ ദൈവം ആകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","അഹരോൻ അതു കണ്ടാറെ അതിന്നു മുമ്പാകെ ഒരു യാഗപീഠം പണിതു: നാളെ യഹോവെക്കു ഒരു ഉത്സവം എന്നു വിളിച്ചു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","പിറ്റെന്നാൾ അവർ അതികാലത്തു എഴുന്നേറ്റു ഹോമയാഗങ്ങൾ കഴിച്ചു സമാധാനയാഗങ്ങളും അർപ്പിച്ചു; ജനം ഭക്ഷിപ്പാനും കുടിപ്പാനും ഇരുന്നു കളിപ്പാൻ എഴുന്നേറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","അപ്പോൾ യഹോവ മോശെയോടു: നീ ഇറങ്ങിച്ചെല്ലുക; നീ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്ന നിന്റെ ജനം തങ്ങളെ തന്നേ വഷളാക്കിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ഞാൻ അവരോടു കല്പിച്ച വഴി അവർ വേഗത്തിൽ വിട്ടുമാറി ഒരു കാളക്കുട്ടിയെ വാർത്തുണ്ടാക്കി നമസ്കരിച്ചു അതിന്നു യാഗം കഴിച്ചു: യിസ്രായേലേ, ഇതു നിന്നെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്ന നിന്റെ ദൈവം ആകുന്നു എന്നു പറയുന്നു എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ഞാൻ ഈ ജനത്തെ നോക്കി, അതു ദുശ്ശാഠ്യമുള്ള ജനം ആകുന്നു എന്നു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","അതുകൊണ്ടു എന്റെ കോപം അവർക്കു വിരോധമായി ജ്വലിച്ചു ഞാൻ അവരെ ദഹിപ്പിക്കേണ്ടതിന്നു എന്നെ വിടുക; നിന്നെ ഞാൻ വലിയോരു ജാതിയാക്കും എന്നും യഹോവ മോശെയോടു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","എന്നാൽ മോശെ തന്റെ ദൈവമായ യഹോവയോടു അപേക്ഷിച്ചു പറഞ്ഞതു: യഹോവേ, നീ മഹാബലംകൊണ്ടും ഭുജവീര്യംകൊണ്ടും മിസ്രയിംദേശത്തുനിന്നു കൊണ്ടുവന്ന നിന്റെ ജനത്തിന്നു വിരോധമായി നിന്റെ കോപം ജ്വലിക്കുന്നതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","മലകളിൽവെച്ചു കൊന്നുകളവാനും ഭൂതലത്തിൽനിന്നു നശിപ്പിപ്പാനും അവരെ ദോഷത്തിന്നായി അവൻ കൊണ്ടുപോയി എന്നു മിസ്രയീമ്യരെക്കൊണ്ടു പറയിക്കുന്നതു എന്തിന്നു? നിന്റെ ഉഗ്രകോപം വിട്ടുതിരിഞ്ഞു നിന്റെ ജനത്തിന്നു വരുവാനുള്ള ഈ അനർത്ഥത്തെക്കുറിച്ചു അനുതപിക്കേണമേ. ");
INSERT INTO mal2015_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","നിന്റെ ദാസന്മാരായ അബ്രാഹാമിനെയും യിസ്ഹാക്കിനെയും യിസ്രായേലിനെയും ഓർക്കേണമേ. ഞാൻ നിങ്ങളുടെ സന്തതിയെ ആകാശത്തിലെ നക്ഷത്രങ്ങളെപ്പോലെ വർദ്ധിപ്പിക്കയും ഞാൻ അരുളിച്ചെയ്ത ഈ ദേശം ഒക്കെയും നിങ്ങളുടെ സന്തതിക്കു കൊടുക്കയും അവർ അതിനെ എന്നേക്കും അവകാശമായി പ്രാപിക്കയും ചെയ്യുമെന്നു നീ നിന്നെക്കൊണ്ടു തന്നേ അവരോടു സത്യംചെയ്തുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","അപ്പോൾ യഹോവ തന്റെ ജനത്തിന്നു വരുത്തും എന്നു കല്പിച്ച അനർത്ഥത്തെക്കുറിച്ചു അനുതപിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","മോശെ തിരിഞ്ഞു പർവ്വതത്തിൽനിന്നു ഇറങ്ങി; സാക്ഷ്യത്തിന്റെ പലക രണ്ടും അവന്റെ കയ്യിൽ ഉണ്ടായിരുന്നു. പലക ഇപ്പുറവും അപ്പുറവുമായി ഇരുവശത്തും എഴുതിയതായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","പലക ദൈവത്തിന്റെ പണിയും പലകയിൽ പതിഞ്ഞ എഴുത്തു ദൈവത്തിന്റെ എഴുത്തും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ജനം ആർത്തുവിളിക്കുന്ന ഘോഷം യോശുവ കേട്ടപ്പോൾ അവൻ മോശെയോടു: പാളയത്തിൽ യുദ്ധഘോഷം ഉണ്ടു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","അതിന്നു അവൻ: ജയിച്ചു ആർക്കുന്നവരുടെ ഘോഷമല്ല, തോറ്റു നിലവിളിക്കുന്നവരുടെ നിലവിളിയുമല്ല, പ്രതിഗാനം ചെയ്യുന്നവരുടെ ഘോഷമത്രേ ഞാൻ കേൾക്കുന്നതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","അവൻ പാളയത്തിന്നു സമീപിച്ചപ്പോൾ കാളക്കുട്ടിയെയും നൃത്തങ്ങളെയും കണ്ടു അപ്പോൾ മോശെയുടെ കോപം ജ്വലിച്ചു അവൻ പലകകളെ കയ്യിൽനിന്നു എറിഞ്ഞു പർവ്വതത്തിന്റെ അടിവാരത്തുവെച്ചു പൊട്ടിച്ചുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","അവർ ഉണ്ടാക്കിയിരുന്ന കാളക്കുട്ടിയെ അവൻ എടുത്തു തീയിൽ ഇട്ടു ചുട്ടു അരെച്ചു പൊടിയാക്കി വെള്ളത്തിൽ വിതറി യിസ്രായേൽമക്കളെ കുടിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","മോശെ അഹരോനോടു: ഈ ജനത്തിന്മേൽ ഇത്രവലിയ പാപം വരുത്തുവാൻ അവർ നിന്നോടു എന്തു ചെയ്തു എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","അതിന്നു അഹരോൻ പറഞ്ഞതു: യജമാനന്റെ കോപം ജ്വലിക്കരുതേ; ഈ ജനം ദോഷത്തിലേക്കു ചാഞ്ഞിരിക്കുന്നതെന്നു നീ അറിയുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ഞങ്ങൾക്കു മുമ്പായി നടക്കേണ്ടതിന്നു ഒരു ദൈവത്തെ ഉണ്ടാക്കി തരേണം; ഞങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്ന പുരുഷനായ ഈ മോശെക്കു എന്തു ഭവിച്ചു എന്നു ഞങ്ങൾ അറിയുന്നില്ലല്ലോ എന്നു അവർ എന്നോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ഞാൻ അവരോടു: പൊന്നുള്ളവർ അതു പറിച്ചെടുക്കട്ടെ എന്നു പറഞ്ഞു. അവർ അതു എന്റെ പക്കൽ തന്നു; ഞാൻ അതു തീയിൽ ഇട്ടു ഈ കാളക്കുട്ടി പുറത്തു വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","അവരുടെ വിരോധികൾക്കു മുമ്പാകെ അവർ ഹാസ്യമാകത്തക്കവണ്ണം അഹരോൻ അവരെ അഴിച്ചുവിട്ടുകളകയാൽ ജനം കെട്ടഴിഞ്ഞവരായി എന്നു കണ്ടിട്ടു മോശെ പാളയത്തിന്റെ വാതിൽക്കൽ നിന്നുകൊണ്ടു: ");
INSERT INTO mal2015_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","യഹോവയുടെ പക്ഷത്തിൽ ഉള്ളവൻ എന്റെ അടുക്കൽ വരട്ടെ എന്നു പറഞ്ഞു. എന്നാറെ ലേവ്യർ എല്ലാവരും അവന്റെ അടുക്കൽ വന്നുകൂടി. ");
INSERT INTO mal2015_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","അവൻ അവരോടു: നിങ്ങൾ ഓരോരുത്തൻ താന്താന്റെ വാൾ അരെക്കു കെട്ടി പാളയത്തിൽകൂടി വാതിൽതോറും കടന്നു ഓരോരുത്തൻ താന്താന്റെ സഹോദരനെയും താന്താന്റെ സ്നേഹിതനെയും താന്താന്റെ കൂട്ടുകാരനെയും കൊന്നുകളവിൻ എന്നിങ്ങനെ യിസ്രായേലിന്റെ ദൈവമായ യഹോവ കല്പിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ലേവ്യർ മോശെ പറഞ്ഞതുപോലെ ചെയ്തു അന്നു ഏകദേശം മൂവായിരം പേർ വീണു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","യഹോവ ഇന്നു നിങ്ങൾക്കു അനുഗ്രഹം നല്കേണ്ടതിന്നു നിങ്ങൾ ഇന്നു ഓരോരുത്തൻ താന്താന്റെ മകന്നും താന്താന്റെ സഹോദരന്നും വിരോധമായി യഹോവെക്കു നിങ്ങളെ തന്നേ ഏല്പിച്ചുകൊടുപ്പിൻ എന്നു മോശെ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","പിറ്റെന്നാൾ മോശെ: നിങ്ങൾ ഒരു മഹാപാപം ചെയ്തിരിക്കുന്നു; ഇപ്പോൾ ഞാൻ യഹോവയുടെ അടുക്കൽ കയറിച്ചെല്ലും; പക്ഷേ നിങ്ങളുടെ പാപത്തിന്നുവേണ്ടി പ്രായശ്ചിത്തം വരുത്തുവാൻ എനിക്കു ഇടയാകും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","അങ്ങനെ മോശെ യഹോവയുടെ അടുക്കൽ മടങ്ങിച്ചെന്നു പറഞ്ഞതു എന്തെന്നാൽ: അയ്യോ, ഈ ജനം മഹാപാതകം ചെയ്തു പൊന്നുകൊണ്ടു തങ്ങൾക്കു ഒരു ദൈവത്തെ ഉണ്ടാക്കിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","എങ്കിലും നീ അവരുടെ പാപം ക്ഷമിക്കേണമേ; അല്ലെങ്കിൽ നീ എഴുതിയ നിന്റെ പുസ്തകത്തിൽനിന്നു എന്റെ പേർ മായിച്ചുകളയേണമേ. ");
INSERT INTO mal2015_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","യഹോവ മോശെയോടു: എന്നോടു പാപം ചെയ്തവന്റെ പേർ ഞാൻ എന്റെ പുസ്തകത്തിൽനിന്നു മായിച്ചുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ആകയാൽ നീ പോയി ഞാൻ നിന്നോടു അരുളിച്ചെയ്ത ദേശത്തേക്കു ജനത്തെ കൂട്ടിക്കൊണ്ടു പോക; എന്റെ ദൂതൻ നിന്റെ മുമ്പിൽ നടക്കും. എന്നാൽ എന്റെ സന്ദർശനദിവസത്തിൽ ഞാൻ അവരുടെ പാപം അവരുടെമേൽ സന്ദർശിക്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","അഹരോൻ ഉണ്ടാക്കിയ കാളക്കുട്ടിയെ ജനം ഉണ്ടാക്കിച്ചതാകകൊണ്ടു യഹോവ അവരെ ദണ്ഡിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","അനന്തരം യഹോവ മോശെയോടു കല്പിച്ചതു എന്തെന്നാൽ: നീയും മിസ്രയീംദേശത്തുനിന്നു നീ കൊണ്ടുവന്ന ജനവും ഇവിടെ നിന്നു പുറപ്പെട്ടു, നിന്റെ സന്തതിക്കു കൊടുക്കുമെന്നു ഞാൻ അബ്രാഹാമിനോടും യിസ്ഹാക്കിനോടും യാക്കോബിനോടും സത്യംചെയ്ത ദേശത്തേക്കു, ");
INSERT INTO mal2015_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","പാലും തേനും ഒഴുകുന്ന ദേശത്തേക്കു, തന്നേ, പോകുവിൻ. ഞാൻ ഒരു ദൂതനെ നിനക്കു മുമ്പായി അയക്കും; കനാന്യൻ, അമോര്യൻ, ഹിത്യൻ, പെരിസ്യൻ, ഹിവ്യൻ, യെബൂസ്യൻ എന്നിവരെ ഞാൻ ഓടിച്ചുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","വഴിയിൽവെച്ചു ഞാൻ നിന്നെ നശിപ്പിക്കാതിരിക്കേണ്ടതിന്നു ഞാൻ നിന്റെ നടുവിൽ നടക്കയില്ല; നീ ദുശ്ശാഠ്യമുള്ള ജനം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ദോഷകരമായ ഈ വചനം കേട്ടപ്പോൾ ജനം ദുഃഖിച്ചു; ആരും തന്റെ ആഭരണം ധരിച്ചതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","നിങ്ങൾ ദുശ്ശാഠ്യമുള്ള ജനം ആകുന്നു; ഞാൻ ഒരു നിമിഷനേരം നിന്റെ നടുവിൽ നടന്നാൽ നിന്നെ സംഹരിച്ചുകളയും; അതുകൊണ്ടു ഞാൻ നിന്നോടു എന്തു ചെയ്യേണം എന്നു അറിയേണ്ടതിന്നു നീ നിന്റെ ആഭരണം നീക്കിക്കളക എന്നിങ്ങനെ യിസ്രായേൽ മക്കളോടു പറക എന്നു യഹോവ മോശെയോടു കല്പിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","അങ്ങനെ ഹോരേബ് പർവ്വതത്തിങ്കൽ തുടങ്ങി യിസ്രായേൽമക്കൾ ആഭരണം ധരിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","മോശെ കൂടാരം എടുത്തു പാളയത്തിന്നു പുറത്തു പാളയത്തിൽനിന്നു ദൂരത്തു അടിച്ചു; അതിന്നു സമാഗമനകൂടാരം എന്നു പേർ ഇട്ടു. യഹോവയെ അന്വേഷിക്കുന്നവനെല്ലാം പുറപ്പെട്ടു പാളയത്തിന്നു പുറത്തുള്ള സമാഗമനകൂടാരത്തിലേക്കു ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","മോശെ കൂടാരത്തിലേക്കു പോകുമ്പോൾ ജനം ഒക്കെയും എഴുന്നേറ്റു ഒരോരുത്തൻ താന്താന്റെ കൂടാരവാതിൽക്കൽ നിന്നു, മോശെ കൂടാരത്തിന്നകത്തു കടക്കുവേളം അവനെ നോക്കിക്കൊണ്ടിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","മോശെ കൂടാരത്തിൽ കടക്കുമ്പോൾ മേഘസ്തംഭം ഇറങ്ങി കൂടാരവാതിൽക്കൽ നിൽക്കയും യഹോവ മോശെയോടു സംസാരിക്കയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ജനം എല്ലാം കൂടാരവാതിൽക്കൽ മേഘസ്തംഭം നില്ക്കുന്നതു കണ്ടു. ജനം എല്ലാം എഴുന്നേറ്റു ഓരോരുത്തൻ താന്താന്റെ കൂടാരവാതിൽക്കൽവെച്ചു നമസ്കരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ഒരുത്തൻ തന്റെ സ്നേഹിതനോടു സംസാരിക്കുന്നതുപോലെ യഹോവ മോശെയോടു അഭിമുഖമായി സംസാരിച്ചു. പിന്നെ അവൻ പാളയത്തിലേക്കു മടങ്ങിവന്നു; അവന്റെ ശുശ്രൂഷക്കാരനായ നൂന്റെ പുത്രനായ യോശുവ എന്ന ബാല്യക്കാരനോ കൂടാരത്തെ വിട്ടുപിരിയാതിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","മോശെ യഹോവയോടു പറഞ്ഞതു എന്തെന്നാൽ: ഈ ജനത്തെ കൂട്ടിക്കൊണ്ടു പോക എന്നു നീ എന്നോടു കല്പിച്ചുവല്ലോ; എങ്കിലും ആരെ എന്നോടുകൂടെ അയക്കുമെന്നു അറിയിച്ചുതന്നില്ല; എന്നാൽ: ഞാൻ നിന്നെ അടുത്തു അറിഞ്ഞിരിക്കുന്നു; എനിക്കു നിന്നോടു കൃപ തോന്നിയിരിക്കുന്നു എന്നു നീ അരുളിച്ചെയ്തിട്ടുണ്ടല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ആകയാൽ എന്നോടു കൃപയുണ്ടെങ്കിൽ നിന്റെ വഴി എന്നെ അറിയിക്കേണമേ; നിനക്കു എന്നോടു കൃപയുണ്ടാകുവാന്തക്കവണ്ണം ഞാൻ നിന്നെ അറിയുമാറാകട്ടെ; ഈ ജാതി നിന്റെ ജനം എന്നു ഓർക്കേണമേ. ");
INSERT INTO mal2015_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","അതിന്നു അവൻ: എന്റെ സാന്നിദ്ധ്യം നിന്നോടുകൂടെ പോരും; ഞാൻ നിനക്കു സ്വസ്ഥത നല്കും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","അവൻ അവനോടു: തിരുസാന്നിദ്ധ്യം എന്നോടുകൂടെ പോരുന്നില്ല എങ്കിൽ ഞങ്ങളെ ഇവിടെനിന്നു പുറപ്പെടുവിക്കരുതേ. ");
INSERT INTO mal2015_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","എന്നോടും നിന്റെ ജനത്തോടും കൃപ ഉണ്ടെന്നുള്ളതു ഏതിനാൽ അറിയും? നീ ഞങ്ങളോടുകൂടെ പോരുന്നതിനാലല്ലയോ? അങ്ങനെ ഞാനും നിന്റെ ജനവും ഭൂതലത്തിലുള്ള സകലജാതികളിലുംവെച്ചു വിശേഷതയുള്ളവരായിരിക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","യഹോവ മോശെയോടു: നീ പറഞ്ഞ ഈ വാക്കുപോലെ ഞാൻ ചെയ്യും; എനിക്കു നിന്നോടു കൃപ തോന്നിയിരിക്കുന്നു; ഞാൻ നിന്നെ അടുത്തു അറിഞ്ഞുമിരിക്കുന്നു എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","അപ്പോൾ അവൻ: നിന്റെ തേജസ്സു എനിക്കു കാണിച്ചു തരേണമേ എന്നപേക്ഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","അതിന്നു അവൻ: ഞാൻ എന്റെ മഹിമ ഒക്കെയും നിന്റെ മുമ്പാകെ കടക്കുമാറാക്കി യഹോവയുടെ നാമത്തെ നിന്റെ മുമ്പാകെ ഘോഷിക്കും; കൃപ ചെയ്‌വാൻ എനിക്കു മനസ്സുള്ളവനോടു ഞാൻ കൃപ ചെയ്യും; കരുണ കാണിപ്പാൻ എനിക്കു മനസ്സുള്ളവന്നു ഞാൻ കരുണ കാണിക്കും എന്നരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","നിനക്കു എന്റെ മുഖം കാണ്മാൻ കഴികയില്ല; ഒരു മനുഷ്യനും എന്നെ കണ്ടു ജീവനോടെ ഇരിക്കയില്ല എന്നും അവൻ കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ഇതാ, എന്റെ അടുക്കൽ ഒരു സ്ഥലം ഉണ്ടു; അവിടെ ആ പാറമേൽ നീ നിൽക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","എന്റെ തേജസ്സു കടന്നുപോകുമ്പോൾ ഞാൻ നിന്നെ പാറയുടെ ഒരു പിളർപ്പിൽ ആക്കി ഞാൻ കടന്നുപോകുവോളം എന്റെ കൈകൊണ്ടു നിന്നെ മറെക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","പിന്നെ എന്റെ കൈ നീക്കും; നീ എന്റെ പിൻഭാഗം കാണും; എന്റെ മുഖമോ കാണാവതല്ല എന്നും യഹോവ അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു എന്തെന്നാൽ: മുമ്പിലത്തേവപോലെ രണ്ടു കല്പലക ചെത്തിക്കൊൾക; എന്നാൽ നീ പൊട്ടിച്ചുകളഞ്ഞ മുമ്പിലത്തെ പലകയിൽ ഉണ്ടായിരുന്ന വചനങ്ങളെ ഞാൻ ആ പലകയിൽ എഴുതും. ");
INSERT INTO mal2015_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","നീ രാവിലേ ഒരുങ്ങി രാവിലേ തന്നേ സീനായിപർവ്വതത്തിൽ കയറി; പർവ്വതത്തിന്റെ മുകളിൽ എന്റെ സന്നിധിയിൽ വരേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","നിന്നോടുകൂടെ ആരും കയറരുതു. പർവ്വതത്തിലെങ്ങും ആരെയും കാണരുതു. പർവ്വതത്തിൻ അരികെ ആടുകളോ കന്നുകാലികളോ മേയുകയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","അങ്ങനെ മോശെ മുമ്പിലത്തേവപോലെ രണ്ടു കല്പലക ചെത്തി, അതികാലത്തു എഴുന്നേറ്റു യഹോവ തന്നോടു കല്പിച്ചതുപോല സീനായിപർവ്വതത്തിൽ കയറി; കല്പലക രണ്ടും കയ്യിൽ എടുത്തുകൊണ്ടു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","അപ്പോൾ യഹോവ മേഘത്തിൽ ഇറങ്ങി അവിടെ അവന്റെ അടുക്കൽനിന്നു യഹോവയുടെ നാമത്തെ ഘോഷിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","യഹോവ അവന്റെ മുമ്പാകെ കടന്നു ഘോഷിച്ചതു എന്തെന്നാൽ: യഹോവ, യഹോവയായ ദൈവം, കരുണയും കൃപയുമുള്ളവൻ; ദീർഘക്ഷമയും മഹാദയയും വിശ്വസ്തതയുമുള്ളവൻ. ");
INSERT INTO mal2015_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ആയിരം ആയിരത്തിന്നു ദയ പാലിക്കുന്നവൻ; അകൃത്യവും അതിക്രമവും പാപവും ക്ഷമിക്കുന്നവൻ; കുറ്റമുള്ളവനെ വെറുതെ വിടാതെ പിതാക്കന്മാരുടെ അകൃത്യം മക്കളുടെമേലും മക്കളുടെ മക്കളുടെമേലും മൂന്നാമത്തെയും നാലാമത്തെയും തലമുറയോളം സന്ദർശിക്കുന്നവൻ. ");
INSERT INTO mal2015_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","എന്നാറെ മോശെ ബദ്ധപ്പെട്ടു സാഷ്ടാംഗം വീണു നമസ്കരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","കർത്താവേ, നിനക്കു എന്നോടു കൃപയുണ്ടെങ്കിൽ കർത്താവു ഞങ്ങളുടെ മദ്ധ്യേ നടക്കേണമേ. ഇതു ദുശ്ശാഠ്യമുള്ള ജനം തന്നേ എങ്കിലും ഞങ്ങളുടെ അകൃത്യവും പാപവും ക്ഷമിച്ചു ഞങ്ങളെ നിന്റെ അവകാശമാക്കേണമേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","അതിന്നു അവൻ അരുളിച്ചെയ്തതെന്തെന്നാൽ: ഞാൻ ഒരു നിയമം ഉണ്ടാക്കുന്നു. ഭൂമിയിലെങ്ങും ഒരു ജാതിയിലും സംഭവിച്ചിട്ടില്ലാത്ത അത്ഭുതങ്ങൾ നിന്റെ സർവ്വജനത്തിന്നും മുമ്പാകെ ഞാൻ ചെയ്യും; നീ സഹവാസം ചെയ്തുപോരുന്ന ജനം ഒക്കെയും യഹോവയുടെ പ്രവൃത്തിയെ കാണും; ഞാൻ നിന്നോടു ചെയ്‌വാനിരിക്കുന്നതു ഭയങ്കരമായുള്ളതു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ഇന്നു ഞാൻ നിന്നോടു കല്പിക്കുന്നതു സൂക്ഷിച്ചുകൊൾക; അമോര്യൻ, കനാന്യൻ, ഹിത്യൻ, പെരിസ്യൻ, ഹിവ്യൻ, യെബൂസ്യൻ എന്നിവരെ ഞാൻ നിന്റെ മുമ്പിൽ നിന്നു ഓടിച്ചുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","നീ ചെല്ലുന്ന ദേശത്തിലെ നിവാസികളോടു നീ ഒരു ഉടമ്പടി ചെയ്യാതിരിപ്പാൻ കരുതിക്കൊൾക; അല്ലാഞ്ഞാൽ അതു നിന്റെ മദ്ധ്യേ ഒരു കണിയായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","നിങ്ങൾ അവരുടെ ബലിപീഠങ്ങളെ ഇടിച്ചു വിഗ്രഹങ്ങളെ തകർത്തു അശേരപ്രതിഷ്ഠകളെ വെട്ടിക്കളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","അന്യദൈവത്തെ നമസ്കരിക്കരുതു; യഹോവയുടെ നാമം തീക്ഷ്ണൻ എന്നാകുന്നു; അവൻ തീക്ഷ്ണതയുള്ള ദൈവം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ആ ദേശത്തിലെ നിവാസികളോടു ഉടമ്പടി ചെയ്കയും അവരുടെ ദേവന്മാരോടു അവർ പരസംഗം ചെയ്തു അവരുടെ ദേവന്മാർക്കു ബലി കഴിക്കുമ്പോൾ നിന്നെ വിളിക്കയും നീ ചെന്നു അവരുടെ ബലികൾ തിന്നുകയും ");
INSERT INTO mal2015_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","അവരുടെ പുത്രിമാരിൽനിന്നു നിന്റെ പുത്രന്മാർക്കു ഭാര്യമാരെ എടുക്കയും അവരുടെ പുത്രിമാർ തങ്ങളുടെ ദേവന്മാരോടു പരസംഗം ചെയ്യുമ്പോൾ നിന്റെ പുത്രന്മാരെക്കൊണ്ടു അവരുടെ ദേവന്മാരോടു പരസംഗം ചെയ്യിക്കയും ചെയ്‌വാൻ ഇടവരരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","ദേവന്മാരെ വാർത്തുണ്ടാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","പുളിപ്പില്ലാത്ത അപ്പത്തിന്റെ ഉത്സവം നീ ആചരിക്കേണം. ഞാൻ നിന്നോടു കല്പിച്ചതുപോലെ ആബീബ് മാസത്തിൽ നിശ്ചയിച്ച സമയത്തു ഏഴു ദിവസം പുളിപ്പില്ലാത്ത അപ്പം തിന്നേണം; ആബീബ് മാസത്തിലല്ലോ നീ മിസ്രയീമിൽനിന്നു പുറപ്പെട്ടുപോന്നതു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","ആദ്യം ജനിക്കുന്നതൊക്കെയും നിന്റെ ആടുകളുടെയും കന്നുകാലികളുടെയും കൂട്ടത്തിൽ കടിഞ്ഞൂലായ ആൺ ഒക്കെയും എനിക്കുള്ളതു ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","എന്നാൽ കഴുതയുടെ കടിഞ്ഞൂലിനെ ആട്ടിൻകുട്ടിയെക്കൊണ്ടു വീണ്ടുകൊള്ളേണം. വീണ്ടുകൊള്ളുന്നില്ലെങ്കിൽ അതിന്റെ കഴുത്തു ഒടിച്ചുകളയേണം. നിന്റെ പുത്രന്മാരിൽ ആദ്യജാതനെ ഒക്കെയും വീണ്ടുകൊള്ളേണം. വെറുങ്കയ്യോടെ നിങ്ങൾ എന്റെ മുമ്പാകെ വരരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ആറു ദിവസം വേല ചെയ്യേണം; ഏഴാം ദിവസം സ്വസ്ഥമായിരിക്കേണം; വിതകാലമോ കൊയ്ത്തുകാലമോ ആയാലും സ്വസ്ഥമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","കോതമ്പുകൊയ്ത്തിലെ ആദ്യഫലോത്സവമായ വാരോത്സവവും ആണ്ടറുതിയിൽ കായ്കനിപ്പെരുനാളും നീ ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","സംവത്സരത്തിൽ മൂന്നു പ്രാവശ്യം പുരുഷന്മാരൊക്കയും യിസ്രായേലിന്റെ ദൈവമായി യഹോവയായ കർത്താവിന്റെ മുമ്പാകെ വരേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ഞാൻ ജാതികളെ നിന്റെ മുമ്പിൽനിന്നു ഓടിച്ചുകളഞ്ഞു നിന്റെ അതൃത്തികളെ വിശാലമാക്കും; നീ സംവത്സരത്തിൽ മൂന്നു പ്രാവശ്യം നിന്റെ ദൈവമായ യഹോവയുടെ മുമ്പാകെ ചെല്ലുവാൻ കയറിപ്പോയിരിക്കുമ്പോൾ ഒരു മനുഷ്യനും നിന്റെ ദേശം മോഹിക്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","എന്റെ യാഗരക്തം പുളിപ്പുള്ള അപ്പത്തോടുകൂടെ അർപ്പിക്കരുതു. പെസഹപെരുനാളിലെ യാഗം പ്രഭാതകാലംവരെ വെച്ചേക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","നിന്റെ നിലത്തിലെ ആദ്യവിളവിന്റെ ആദ്യഫലം നിന്റെ ദൈവമായ യഹോവയുടെ ആലയത്തിൽ കൊണ്ടുവരേണം. കോലാട്ടിൻകുട്ടിയെ അതിന്റെ തള്ളയുടെ പാലിൽ പാകം ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","യഹോവ പിന്നെയും മോശെയോടു: ഈ വചനങ്ങളെ എഴുതിക്കൊൾക; ഈ വചനങ്ങൾ ആധാരമാക്കി ഞാൻ നിന്നോടും യിസ്രായേലിനോടും നിയമം ചെയ്തിരിക്കുന്നു എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","അവൻ അവിടെ ഭക്ഷണം കഴിക്കാതെയും വെള്ളം കുടിക്കാതെയും നാല്പതു പകലും നാല്പതു രാവും യഹോവയോടുകൂടെ ആയിരുന്നു; അവൻ പത്തു കല്പനയായ നിയമത്തിന്റെ വചനങ്ങളെ പലകയിൽ എഴുതിക്കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","അവൻ തന്നോടു അരുളിച്ചെയ്തതു നിമിത്തം തന്റെ മുഖത്തിന്റെ ത്വക്ക് പ്രകാശിച്ചു എന്നു മോശെ സാക്ഷ്യത്തിന്റെ പലക രണ്ടും കയ്യിൽ പടിച്ചുകൊണ്ടു സീനായിപർവ്വതത്തിൽനിന്നു ഇറങ്ങുമ്പോൾ അറിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","അഹരോനും യിസ്രായേൽമക്കൾ എല്ലാവരും മോശെയെ നോക്കിയപ്പോൾ അവന്റെ മുഖത്തിന്റെ ത്വക്ക് പ്രകാശിക്കുന്നതു കണ്ടു; അതുകൊണ്ടു അവർ അവന്റെ അടുക്കൽ ചെല്ലുവാൻ ഭയപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","മോശെ അവരെ വിളിച്ചു; അപ്പോൾ അഹരോനും സഭയിലെ പ്രമാണികൾ ഒക്കെയും അവന്റെ അടുക്കൽ മടങ്ങി വന്നു; മോശെ അവരോടു സംസാരിചു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","അതിന്റെ ശേഷം യിസ്രായേൽമക്കൾ ഒക്കെയും അവന്റെ അടുക്കൽ ചെന്നു. സീനായിപർവ്വതത്തിൽവെച്ചു യഹോവ തന്നോടു അരുളിച്ചെയ്തതൊക്കെയും അവൻ അവരോടു ആജ്ഞാപിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","മോശെ അവരോടു സംസാരിച്ചു കഴിഞ്ഞപ്പോൾ അവൻ തന്റെ മുഖത്തു ഒരു മൂടുപടം ഇട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","മോശെ യഹോവയോടു സംസാരിക്കേണ്ടതിന്നു അവന്റെ സന്നിധാനത്തിൽ കടക്കുമ്പോൾ പുറത്തു വരുവോളം മൂടുപടം നീക്കിയിരിക്കും; തന്നോടു കല്പിച്ചതു അവൻ പുറത്തുവന്നു യിസ്രായേൽമക്കളോടു പറയും. ");
INSERT INTO mal2015_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","യിസ്രായേൽമക്കൾ മോശെയുടെ മുഖത്തിന്റെ ത്വക്ക് പ്രകാശിക്കുന്നതായി കണ്ടതുകൊണ്ടു മോശെ അവനോടു സംസാരിക്കേണ്ടതിന്നു അകത്തു കടക്കുവോളം മൂടുപടം പിന്നെയും തന്റെ മുഖത്തു ഇട്ടുകൊള്ളും. ");
INSERT INTO mal2015_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","അനന്തരം മോശെ യിസ്രായേൽമക്കളുടെ സംഘത്തെ ഒക്കെയും കൂട്ടി അവരോടു പറഞ്ഞതു: നിങ്ങൾ ചെയ്‌വാൻ യഹോവ കല്പിച്ച വചനങ്ങൾ ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ആറു ദിവസം വേല ചെയ്യേണം; ഏഴാം ദിവസം നിങ്ങൾക്കു വിശുദ്ധമായി യഹോവയുടെ മഹാസ്വസ്ഥതയുള്ള ശബ്ബത്ത് ആയിരിക്കേണം; അന്നു വേല ചെയ്യുന്നവൻ എല്ലാം മരണ ശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ശബ്ബത്ത് നാളിൽ നിങ്ങളുടെ വാസസ്ഥലങ്ങളിൽ എങ്ങും തീ കത്തിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","മോശെ പിന്നെയും യിസ്രായേൽമക്കളുടെ സർവ്വസഭയോടും പറഞ്ഞതു: യഹോവ കല്പിച്ചതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","നിങ്ങളുടെ ഇടയിൽനിന്നു യഹോവെക്കു ഒരു വഴിപാടു എടുപ്പിൻ. നല്ല മനസ്സുള്ളവനെല്ലാം യഹോവെക്കു വഴിപാടു കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","പൊന്നു, വെള്ളി, താമ്രം, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പഞ്ഞിനൂൽ, കോലാട്ടുരോമം, ");
INSERT INTO mal2015_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ചുവപ്പിച്ച ആട്ടുകൊറ്റന്തോൽ, തഹശുതോൽ, ഖദിരമരം, ");
INSERT INTO mal2015_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","വിളക്കിന്നു എണ്ണ, അഭിഷേകതൈലത്തിന്നും പരിമളധൂപത്തിന്നും സുഗന്ധവർഗ്ഗം, ");
INSERT INTO mal2015_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ഗോമേദകക്കല്ലു, ഏഫോദിന്നു പതക്കത്തിന്നും പതിക്കേണ്ടുന്ന കല്ലു എന്നിവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","നിങ്ങളിൽ ജ്ഞാനികളായ എല്ലാവരും വന്നു യഹോവ കല്പിച്ചിരിക്കുന്നതു ഒക്കെയും ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","തിരുനിവാസം, അതിന്റെ മൂടുവിരി, പുറമൂടി, കൊളുത്തുകൾ, പലകകൾ, അന്താഴങ്ങൾ, ");
INSERT INTO mal2015_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","തൂണുകൾ, ചുവടുകൾ, പെട്ടകം, അതിന്റെ തണ്ടുകൾ, കൃപാസനം, മറയുടെ തിരശ്ശീല, ");
INSERT INTO mal2015_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","മേശ, അതിന്റെ തണ്ടുകൾ, ഉപകരണങ്ങൾ ഒക്കെയും, കാഴ്ചയപ്പം, ");
INSERT INTO mal2015_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","വെളിച്ചത്തിന്നു നിലവിളക്കു, അതിന്റെ ഉപകരണങ്ങൾ, അതിന്റെ ദീപങ്ങൾ, വിളക്കിന്നു എണ്ണ, ");
INSERT INTO mal2015_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ധൂപപീഠം, അതിന്റെ തണ്ടുകൾ, അഭിഷേകതൈലം, സുഗന്ധധൂപവർഗ്ഗം, തിരുനിവാസത്തിലേക്കുള്ള പ്രവേശന വാതിലിന്റെ മറശ്ശീല, ");
INSERT INTO mal2015_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ഹോമയാഗപീഠം, അതിന്റെ താമ്രജാലം, തണ്ടുകൾ, അതിന്റെ ഉപകരണങ്ങൾ ഒക്കെയും, തൊട്ടി, അതിന്റെ കാൽ, ");
INSERT INTO mal2015_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","പ്രാകാരത്തിന്റെ മറശ്ശീലകൾ, അതിന്റെ തൂണുകൾ, ചുവടുകൾ, പ്രാകാരവാതിലിന്റെ മറ, ");
INSERT INTO mal2015_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","തിരുനിവാസത്തിന്റെ കുറ്റികൾ, പ്രാകാരത്തിന്റെ കുറ്റികൾ, ");
INSERT INTO mal2015_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","അവയുടെ കയറുകൾ, വിശുദ്ധമന്ദിരത്തിൽ ശുശ്രൂഷ ചെയ്‌വാൻ വിശേഷവസ്ത്രങ്ങൾ, പുരോഹിതനായ അഹരോന്റെ വിശുദ്ധവസ്ത്രം, പുരോഹിതശുശ്രൂഷെക്കായി അവന്റെ പുത്രന്മാരുടെ വസ്ത്രങ്ങൾ എന്നിവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","അപ്പോൾ യിസ്രായേൽമക്കളുടെ സർവ്വസഭയും മോശെയുടെ മുമ്പിൽ നിന്നു പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ഹൃദയത്തിൽ ഉത്സാഹവും മനസ്സിൽ താല്പര്യവും തോന്നിയവൻ എല്ലാം സമാഗമനകൂടാരത്തിന്റെ പ്രവൃത്തിക്കും അതിന്റെ സകലശുശ്രൂഷെക്കും വിശുദ്ധവസ്ത്രങ്ങൾക്കും വേണ്ടി യഹോവെക്കു വഴിപാടു കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","പുരുഷന്മാരും സ്ത്രീകളുമായി ഔദാര്യമനസ്സുള്ളവർ എല്ലാവരും യഹോവെക്കു പൊൻവഴിപാടു കൊടുപ്പാൻ നിശ്ചയിച്ചവരൊക്കെയും വള, കുണുക്കു, മോതിരം, മാല മുതലായ സകലവിധപൊന്നാഭരണങ്ങളും കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പഞ്ഞിനൂൽ, കോലാട്ടുരോമം, ചുവപ്പിച്ച ആട്ടുകൊറ്റന്തോൽ, തഹശൂതോൽ എന്നിവ കൈവശമുള്ളവർ അതു കൊണ്ടു വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","വെള്ളിയും താമ്രവും വഴിപാടുകൊടുപ്പാൻ നിശ്ചയിച്ചവനെല്ലാം യഹോവെക്കു വഴിപാടു കൊണ്ടുവന്നു. ശുശ്രൂഷയിലെ എല്ലാപണിക്കുമായി ഖദിരമരം കൈവശമുള്ളവൻ അതുകൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","സാമർത്ഥ്യമുള്ള സ്ത്രീകൾ ഒക്കെയും തങ്ങളുടെ കൈകൊണ്ടു നൂറ്റ നീലനൂലും ധൂമ്രനൂലും ചുവപ്പുനൂലും പഞ്ഞിനൂലും കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","സാമർത്ഥ്യത്താൽ ഹൃദയത്തിൽ ഉത്സാഹം തോന്നിയ സ്ത്രീകൾ ഒക്കെയും കോലാട്ടുരോമം നൂറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","പ്രമാണികൾ ഏഫോദിന്നും പതക്കത്തിനും പതിക്കേണ്ടുന്ന കല്ലുകളും ഗോമേദകക്കല്ലുകളും ");
INSERT INTO mal2015_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","വെളിച്ചത്തിന്നും അഭിഷേകതൈലത്തിന്നും സുഗന്ധധൂപത്തിന്നുമായി പരിമളവർഗ്ഗവും എണ്ണയും കൊണ്ടു വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","മോശെ മുഖാന്തരം യഹോവ കല്പിച്ച സകലപ്രവൃത്തിക്കുമായി കൊണ്ടുവരുവാൻ യിസ്രായേൽമക്കളിൽ ഔദാര്യമനസ്സുള്ള സകല പുരുഷന്മാരും സ്ത്രീകളും യഹോവെക്കു സ്വമേധാദാനം കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","എന്നാൽ മോശെ യിസ്രായേൽമക്കളോടു പറഞ്ഞതു: നോക്കുവിൻ; യഹോവ യെഹൂദാഗോത്രത്തിൽ ഹൂരിന്റെ മകനായ ഊരിയുടെ മകൻ ബെസലേലിനെ പേർചൊല്ലി വിളിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","കൗശലപ്പണികളെ സങ്കല്പിച്ചുണ്ടാക്കുവാനും പൊന്നു, വെള്ളി, താമ്രം എന്നിവകൊണ്ടു പണി ചെയ്‌വാനും ");
INSERT INTO mal2015_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","രത്നം വെട്ടി പതിപ്പാനും മരത്തിൽ കൊത്തുപണിയായ സകലവിധകൗശലപ്പണിയും ചെയ്‌വാനും ");
INSERT INTO mal2015_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","അവൻ ദിവ്യാത്മാവിനാൽ അവനെ ജ്ഞാനവും ബുദ്ധിയും അറിവും സകലവിധ സാമർത്ഥ്യവുംകൊണ്ടു നിറെച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","അവന്റെ മനസ്സിലും ദാൻഗോത്രത്തിൽ അഹീസാമാക്കിന്റെ മകനായ ഒഹൊലീയാബിന്റെ മനസ്സിലും മറ്റുള്ളവരെ പഠിപ്പിപ്പാൻ അവൻ തോന്നിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","കൊത്തുപണിക്കാരന്റെയും കൗശലപ്പണിക്കാരന്റെയും നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു പണിചെയ്യുന്ന തയ്യൽക്കാരന്റെയും നെയ്ത്തുകാരന്റെയും ഏതുതരം ശില്പപ്പണി ചെയ്യുന്നവരുടെയും കൗശലപ്പണികൾ സങ്കല്പിച്ചു ഉണ്ടാക്കുന്നവരുടെയും സകലവിധപ്രവൃത്തിയും ചെയ്‌വാൻ അവൻ അവരെ മനസ്സിൽ ജ്ഞാനം കൊണ്ടു നിറെച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ബെസലേലും ഒഹൊലീയാബും വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷെക്കു യഹോവ കല്പിച്ചതുപോലെ ഒക്കെയും സകലപ്രവൃത്തിയും ചെയ്‌വാൻ അറിയേണ്ടതിന്നു യഹോവ ജ്ഞാനവും ബുദ്ധിയും നല്കിയ സകലജ്ഞാനികളും പ്രവൃത്തി ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","അങ്ങനെ മോശെ ബെസലേലിനെയും ഒഹൊലീയാബിനെയും യഹോവ മനസ്സിൽ ജ്ഞാനം നല്കിയിരുന്ന എല്ലാവരെയും പ്രവൃത്തിയിൽ ചേരുവാൻ മനസ്സിൽ ഉത്സാഹം തോന്നിയ എല്ലാവരെയും വിളിച്ചുവരുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷയുടെ പ്രവൃത്തി ചെയ്‌വാൻ യിസ്രായേൽമക്കൾ കൊണ്ടുവന്ന വഴിപാടു ഒക്കെയും അവർ മോശെയുടെ പക്കൽനിന്നു വാങ്ങി; എന്നാൽ അവർ പിന്നെയും രാവിലെതോറും സ്വമേധാദാനങ്ങളെ അവന്റെ അടുക്കൽ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","അപ്പോൾ വിശുദ്ധമന്ദിരത്തിന്റെ സകല പ്രവൃത്തിയും ചെയ്യുന്ന ജ്ഞാനികൾ ഒക്കെയും താന്താൻ ചെയ്തുവന്ന പണി നിർത്തി വന്നു മോശെയോടു: ");
INSERT INTO mal2015_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","യഹോവ ചെയ്‌വാൻ കല്പിച്ച ശുശ്രൂഷയുടെ പ്രവൃത്തിക്കു വേണ്ടതിലധികമായി ജനം കൊണ്ടുവരുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","അതിന്നു മോശെ: പുരുഷന്മാരാകട്ടെ സ്ത്രീകളാകട്ടെ വിശുദ്ധമന്ദിരത്തിന്റെ വഴിപാടുവകെക്കു മേലാൽ പ്രവൃത്തി ചെയ്യേണ്ട എന്നു കല്പിച്ചു; അവർ അതു പാളയത്തിൽ പ്രസിദ്ധമാക്കി. അങ്ങനെ ജനം കൊണ്ടുവരുന്നതു നിർത്തലായി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","കിട്ടിയ സാമാനങ്ങളോ സകല പ്രവൃത്തിയും ചെയ്‌വാൻ വേണ്ടുവോളവും അധികവും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","പണി ചെയ്യുന്നവരിൽ ജ്ഞാനികളായ എല്ലാവരും പഞ്ഞിനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ എന്നിവകൊണ്ടുള്ള പത്തു മൂടുശീലകൊണ്ടു തിരുനിവാസം ഉണ്ടാക്കി; നെയ്ത്തുകാരന്റെ ചിത്രപ്പണിയായ കെരൂബുകളുള്ളതായിട്ടു അതിനെ ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ഓരോ മൂടുശീലെക്കു ഇരുപത്തെട്ടു മുഴം നീളവും ഓരോ മൂടുശീലെക്കു നാലു മുഴം വീതിയും ഉണ്ടായിരുന്നു; എല്ലാമൂടുശീലകൾക്കും ഒരു അളവു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","അഞ്ചു മൂടുശീല ഒന്നോടൊന്നു ഇണെച്ചു; മറ്റെ അഞ്ചു മൂടുശീലയും ഒന്നോടൊന്നു ഇണെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","അങ്ങനെ ഇണെച്ചുണ്ടാക്കിയ ഒന്നാമത്തെ വിരിയുടെ അറ്റത്തുള്ള മൂടുശീലയുടെ വിളുമ്പിൽ നീലനൂൽ കൊണ്ടു കണ്ണികൾ ഉണ്ടാക്കി; രണ്ടാമത്തെ വിരിയുടെ പുറത്തെ മൂടുശീലയുടെ വിളുമ്പിലും അങ്ങനെ തന്നേ ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ഒരു മൂടുശീലയിൽ അമ്പതു കണ്ണി ഉണ്ടാക്കി; രണ്ടാമത്തെ വിരിയുടെ പുറത്തെ മൂടുശീലയുടെ വിളുമ്പിലും അമ്പതു കണ്ണി ഉണ്ടാക്കി; കണ്ണികൾ നേർക്കുനേരെ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","അവൻ പൊന്നുകൊണ്ടു അമ്പതു കൊളുത്തും ഉണ്ടാക്കി; കൊളുത്തുകൊണ്ടു മൂടുശീലകളെ ഒന്നോടൊന്നു ഇണെച്ചു; അങ്ങനെ തിരുനിവാസം ഒന്നായി തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","തിരുനിവാസത്തിന്മേൽ മൂടുവരിയായി കോലാട്ടുരോമംകൊണ്ടുള്ള മൂടുശീലകൾ ഉണ്ടാക്കി, പതിനൊന്നു മൂടുശീലയായി അവയെ ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ഓരോ മൂടുശീലെക്കു മുപ്പതു മുഴം നീളവും ഓരോ മൂടുശീലെക്കു നാലു മുഴം വീതിയും ഉണ്ടായിരുന്നു; മൂടുശീല പതിനൊന്നിന്നും ഒരു അളവു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","അവൻ അഞ്ചു മൂടുശീല ഒന്നായും ആറു മൂടുശീല ഒന്നായും ഇണെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ഇങ്ങനെ ഇണെച്ചുണ്ടാക്കിയ ഒന്നാമത്തെ വിരിയുടെ അറ്റത്തുള്ള മൂടുശീലയുടെ വിളുമ്പിൽ അമ്പതു കണ്ണിയും രണ്ടാമത്തെ വിരിയുടെ അറ്റത്തുള്ള മൂടുശീലയുടെ വിളുമ്പിൽ അമ്പതു കണ്ണിയും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","കൂടാരം ഒന്നായിരിക്കേണ്ടതിന്നു അതു ഇണെപ്പാൻ താമ്രംകൊണ്ടു അമ്പതു കൊളുത്തും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ചുവപ്പിച്ച ആട്ടുകൊറ്റന്തോൽകൊണ്ടു കൂടാരത്തിന്നു ഒരു പുറമൂടിയും അതിന്റെ മീതെ തഹശൂതോൽകൊണ്ടു ഒരു പുറമൂടിയും അവൻ ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ഖദിരമരംകൊണ്ടു തിരുനിവാസത്തിന്നു നിവിരെ നില്ക്കുന്ന പലകകളും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ഓരോ പലകെക്കു പത്തുമുഴം നീളവും ഓരോ പലകെക്കു ഒന്നര മുഴം വീതിയും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ഓരോ പലകെക്കു തമ്മിൽ ചേർന്നിരിക്കുന്ന ഈരണ്ടു കുടുമ ഉണ്ടായിരുന്നു; ഇങ്ങനെ തിരുനിവാസത്തിന്റെ എല്ലാപലകെക്കും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","അവൻ തിരുനിവാസത്തിന്നു പലക ഉണ്ടാക്കിയതു തെക്കുവശത്തേക്കു ഇരുപതു പലക: ");
INSERT INTO mal2015_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ഒരു പലകയുടെ അടിയിൽ രണ്ടു കുടുമെക്കു രണ്ടു ചുവടും മറ്റൊരു പലകയുടെ അടിയിൽ രണ്ടു കുടുമെക്കു രണ്ടു ചുവടും ഇങ്ങനെ ഇരുപതു പലകയുടെ അടിയിൽ വെള്ളികൊണ്ടു നാല്പതു ചുവടു അവൻ ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","തിരുനിവാസത്തിന്റെ മറുപുറത്തു വടക്കുവശത്തേക്കും ഇരുപതു പലക ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ഒരു പലകയുടെ അടിയിൽ രണ്ടു ചുവടും മറ്റൊരു പലകയുടെ അടിയിൽ രണ്ടു ചുവടും ഇങ്ങനെ അവെക്കു നാല്പതു വെള്ളിച്ചുവടു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","തിരുനിവാസത്തിന്റെ പടിഞ്ഞാറെ വശത്തേക്കു ആറു പലക ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","തിരുനിവാസത്തിന്റെ ഇരുവശത്തുമുള്ള കോണുകൾക്കു ഈരണ്ടു പലക ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","അവ താഴെ ഇരട്ടയായും മേലറ്റത്തു ഒന്നാമത്തെ വളയംവരെ തമ്മിൽ ചേർന്നു ഒറ്റയായും ഇരുന്നു. രണ്ടു മൂലയിലുള്ള രണ്ടിന്നും അങ്ങനെ തന്നേ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ഇങ്ങനെ എട്ടു പലകയും ഓരോ പലകയുടെ അടിയിൽ ഈരണ്ടു ചുവടായി പതിനാറു വെള്ളിച്ചുവടും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","അവൻ ഖദിരമരംകൊണ്ടു അന്താഴങ്ങളും ഉണ്ടാക്കി; തിരുനിവാസത്തിന്റെ ഒരു വശത്തെ പലകെക്കു അഞ്ചു അന്താഴം; ");
INSERT INTO mal2015_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","തിരുനിവാസത്തിന്റെ മറുവശത്തെ പലകെക്കു അഞ്ചു അന്താഴം; തിരുനിവാസത്തിന്റെ പടിഞ്ഞാറെ ഭാഗത്തു പിൻവശത്തെ പലകെക്കു അഞ്ചു അന്താഴം. ");
INSERT INTO mal2015_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","നടുവിലത്തെ അന്താഴം പലകയുടെ ഒത്ത നടുവിൽ ഒരു അറ്റത്തുനിന്നു മറ്റെ അറ്റത്തോളം ചെല്ലുവാൻ തക്കവണ്ണം ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","പലകകൾ പൊന്നുകൊണ്ടു പൊതിഞ്ഞു; അന്താഴം ചെലുത്തുവാനുള്ള അവയുടെ വളയങ്ങൾ പൊന്നുകൊണ്ടു ഉണ്ടാക്കി, അന്താഴം പൊന്നുകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു അവൻ ഒരു തിരശ്ശീലയും ഉണ്ടാക്കി: നെയ്ത്തുകാരന്റെ ചിത്രപ്പണിയായ കെരൂബുകളുള്ളതായിട്ടു അതിനെ ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","അതിന്നു ഖദിരമരംകൊണ്ടു നാലു തൂണും ഉണ്ടാക്കി, പൊന്നുകൊണ്ടു പൊതിഞ്ഞു; അവയുടെ കൊളുത്തുകൾ പൊന്നുകൊണ്ടു ആയിരുന്നു; അവെക്കു വെള്ളികൊണ്ടു നാലു ചുവടു വാർപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","കൂടാരത്തിന്റെ വാതിലിന്നു നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽക്കാരന്റെ പണിയായ ഒരു മറശ്ശീലയും ");
INSERT INTO mal2015_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","അതിന്നു അഞ്ചു തൂണും അവെക്കു കൊളുത്തും ഉണ്ടാക്കി; അവയുടെ കുമിഴുകളും മേൽചുറ്റുപടികളും പൊന്നുകൊണ്ടു പൊതിഞ്ഞു; എന്നാൽ അവയുടെ ചുവടു അഞ്ചും താമ്രം കൊണ്ടു ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ബെസലേൽ പെട്ടകം ഖദിരമരംകൊണ്ടു ഉണ്ടാക്കി. അതിന്നു രണ്ടരമുഴം നീളവും ഒന്നരമുഴം വീതിയും ഒന്നരമുഴം ഉയരവും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","അതു അകവും പുറവും പൊന്നുകൊണ്ടു പൊതിഞ്ഞു, ചുറ്റും അതിന്നു പൊന്നുകൊണ്ടു ഒരു വക്കു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","അതിന്റെ നാലു കാലിന്നും ഇപ്പുറത്തു രണ്ടു വളയം അപ്പുറത്തു രണ്ടു വളയം ഇങ്ങനെ നാലു പൊൻവളയം വാർപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","അവൻ ഖദിരമരംകൊണ്ടു തണ്ടുകളും ഉണ്ടാക്കി പൊന്നുകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","പെട്ടകം ചുമക്കേണ്ടതിന്നു ആ തണ്ടു പെട്ടകത്തിന്റെ പാർശ്വങ്ങളിലുള്ള വളയങ്ങളിൽ ചെലുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","അവൻ തങ്കം കൊണ്ടു കൃപാസനം ഉണ്ടാക്കി; അതിന്നു രണ്ടര മുഴം നീളവും ഒന്നര മുഴം വീതിയും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","അവൻ പൊന്നുകൊണ്ടു രണ്ടു കെരൂബുകളെ ഉണ്ടാക്കി കൃപാസനത്തിന്റെ രണ്ടു അറ്റത്തും അവയെ അടിപ്പുപണിയായി ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ഒരു കെരൂബ് ഒരു അറ്റത്തും മറ്റെ കെരൂബ് മറ്റെ അറ്റത്തും ഇങ്ങനെ കെരൂബുകളെ കൃപാസനത്തിന്റെ രണ്ടു അറ്റത്തും അതിൽ നിന്നു തന്നേ ഉള്ളവയായിട്ടു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","കെരൂബുകൾ മേലോട്ടു ചിറകു വിടർത്തു ചിറകുകൊണ്ടു കൃപാസനത്തെ മൂടുകയും തമ്മിൽ അഭിമുഖമായിരിക്കയും ചെയ്തു; കെരൂബുകളുടെ മുഖം കൃപാസനത്തിന്നു നേരെ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","അവൻ ഖദിരമരംകൊണ്ടു മേശ ഉണ്ടാക്കി. അതിന്നു രണ്ടു മുഴം നീളവും ഒരു മുഴം വീതിയും ഒന്നര മുഴം ഉയരവും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","അതു തങ്കംകൊണ്ടു പൊതിഞ്ഞു ചുറ്റും പൊന്നുകൊണ്ടു ഒരു വക്കു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ചുറ്റും അതിന്നു നാലു വിരൽ വീതിയുള്ള ഒരു ചട്ടവും ഉണ്ടാക്കി. ചട്ടത്തിന്നു ചുറ്റും പൊന്നുകൊണ്ടു ഒരു വക്കു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","അതിന്നു നാലു പൊൻവളയം വാർത്തു നാലു കാലിന്റെയും ഓരോ പാർശ്വത്തിൽ തറെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","മേശ ചുമക്കേണ്ടതിന്നു തണ്ടുകൾ ചെലുത്തുവാൻ വളയങ്ങൾ ചട്ടത്തോടു ചേർന്നിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","മേശചുമക്കേണ്ടതിന്നുള്ള തണ്ടുകൾ ഖദിരമരംകൊണ്ടു ഉണ്ടാക്കി പൊന്നുകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","മേശമേലുള്ള ഉപകരണങ്ങളായ തളികകളും കരണ്ടികളും കിണ്ടികളും പകരുവാൻ ഉപയോഗിക്കുന്ന കുടങ്ങളും തങ്കംകൊണ്ടു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","അവൻ തങ്കംകൊണ്ടു നിലവിളക്കു ഉണ്ടാക്കി; വിളക്കു അടിപ്പുപണിയായി ഉണ്ടാക്കി; അതിന്റെ ചുവടും തണ്ടും പുഷ്പപുടങ്ങളും മുട്ടുകളും പൂക്കളും അതിൽനിന്നു തന്നേ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","നിലവിളക്കിന്റെ ഒരു വശത്തുനിന്നു മൂന്നു ശാഖ, അതിന്റെ മറ്റെവശത്തു നിന്നും മൂന്നു ശാഖ, ഇങ്ങനെ ആറു ശാഖ അതിന്റെ പാർശ്വങ്ങളിൽനിന്നു പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ഒരു ശാഖയിൽ ഓരോ മുട്ടും ഓരോ പൂവുമായി ബദാംപൂപോലെ മൂന്നു പുഷ്പപുടവും മറ്റൊരു ശാഖയിൽ ഓരോ മുട്ടും ഓരോ പൂവുമായി ബദാംപൂപോലെ മൂന്നു പുഷ്പപുടവും ഇങ്ങനെ നിലവിളക്കിൽനിന്നു പുറപ്പെട്ട ശാഖ ആറിലും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","വിളക്കുതണ്ടിലോ മുട്ടുകളും പൂക്കളുമായി ബദാം പൂപോലെ നാലു പുഷ്പപുടം ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","അതിൽ നിന്നുള്ള രണ്ടു ശാഖെക്കു കീഴെ ഒരു മുട്ടും അതിൽനിന്നുള്ള മറ്റെ രണ്ടു ശാഖെക്കു കീഴെ ഒരു മുട്ടും അതിൽനിന്നുള്ള ശേഷം രണ്ടു ശാഖെക്കു കീഴെ ഒരു മുട്ടും ഇങ്ങനെ അതിൽനിന്നു പുറപ്പെടുന്ന ശാഖ ആറിന്നും കീഴെ ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","മുട്ടുകളും ശാഖകളും അതിൽനിന്നു തന്നേ ആയിരുന്നു; അതു മുഴുവനും തങ്കം കൊണ്ടുള്ള ഒറ്റ അടിപ്പുപണിയായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","അവൻ അതിന്റെ ഏഴു ദീപവും അതിന്റെ ചവണകളും കരിന്തിരിപ്പാത്രങ്ങളും തങ്കംകൊണ്ടു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ഒരു താലന്തു തങ്കംകൊണ്ടു അവൻ അതും അതിന്റെ ഉപകരണങ്ങളൊക്കെയും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","അവൻ ഖദിരമരംകൊണ്ടു ധൂപപീഠം ഉണ്ടാക്കി; അതു ഒരു മുഴം നീളവും ഒരു മുഴം വീതിയും ഇങ്ങനെ സമചതുരം ആയിരുന്നു. അതിന്നു ഉയരം രണ്ടു മുഴം ആയിരുന്നു. അതിന്റെ കൊമ്പുകൾ അതിൽനിന്നു തന്നേ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","അവൻ അതും അതിന്റെ മേല്പലകയും ചുറ്റും അതിന്റെ പാർശ്വങ്ങളും കൊമ്പുകളും തങ്കംകൊണ്ടു പൊതിഞ്ഞു; അതിന്നു ചുറ്റും പൊന്നുകൊണ്ടു ഒരു വക്കു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","അതു ചുമക്കേണ്ടതിന്നു തണ്ടു ചെലുത്തുവാൻ വക്കിന്നു കീഴെ രണ്ടു പാർശ്വത്തിലുള്ള ഓരോ കോണിങ്കലും ഓരോ പൊൻവളയം ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ഖദിരമരംകൊണ്ടു തണ്ടുകളും ഉണ്ടാക്കി പൊന്നുകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","അവൻ വിശുദ്ധമായ അഭിഷേകതൈലവും നല്ല സുഗന്ധമുള്ള നിർമ്മല ധൂപവർഗ്ഗവും തൈലക്കാരന്റെ വിദ്യപ്രകാരം ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","അവൻ ഖദിരമരംകൊണ്ടു ഹോമയാഗപീഠം ഉണ്ടാക്കി; അതു അഞ്ചു മുഴം നീളവും അഞ്ചു മുഴം വീതിയും ഇങ്ങനെ സമചതുരവും മൂന്നു മുഴം ഉയരവുമുള്ളതായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","അതിന്റെ നാലു കോണിലും നാലു കൊമ്പു ഉണ്ടാക്കി; കൊമ്പുകൾ അതിൽനിന്നു തന്നേ ആയിരുന്നു. താമ്രംകൊണ്ടു അതു പൊതിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ചട്ടി, ചട്ടുകം, കലശം, മുൾകൊളുത്തു, തീക്കലശം ഇങ്ങനെ പീഠത്തിന്റെ ഉപകരണങ്ങളൊക്കെയും ഉണ്ടാക്കി; അതിന്റെ ഉപകരണങ്ങളൊക്കെയും താമ്രംകൊണ്ടു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","അവൻ യാഗപീഠത്തിന്നു വലപ്പണിയായ ഒരു താമ്രജാലം ഉണ്ടാക്കി; അതു താഴെ അതിന്റെ ചുറ്റുപടിക്കു കീഴെ അതിന്റെ പാതിയോളം എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","താമ്രജാലത്തിന്റെ നാലു അറ്റത്തിന്നും തണ്ടു ചെലുത്തുവാൻ നാലു വളയം വാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ഖദിരമരംകൊണ്ടു തണ്ടുകളും ഉണ്ടാക്കി താമ്രംകൊണ്ടു പൊതിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","യാഗപീഠം ചുമക്കേണ്ടതിന്നു അതിന്റെ പാർശ്വങ്ങളിലുള്ള വളയങ്ങളിൽ ആ തണ്ടുകൾ ചെലുത്തി; യാഗപീഠം പലകകൊണ്ടു പൊള്ളയായി ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ സേവ ചെയ്തുവന്ന സ്ത്രീകളുടെ ദർപ്പണങ്ങൾകൊണ്ടു അവൻ താമ്രത്തൊട്ടിയും അതിന്റെ താമ്രക്കാലും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","അവൻ പ്രാകാരവും ഉണ്ടാക്കി; തെക്കുവശത്തെ പ്രാകാരത്തിന്നു പിരിച്ച പഞ്ഞിനൂൽകൊണ്ടുള്ള നൂറു മുഴം മറശ്ശീല ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","അതിന്നു ഇരുപതു തൂണും തൂണുകൾക്കു ഇരുപതു താമ്രച്ചുവടും ഉണ്ടായിരുന്നു. തൂണുകളുടെ കൊളുത്തും മേൽചുറ്റുപടിയും വെള്ളി ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","വടക്കുവശത്തു നൂറു മുഴം മറശ്ശീലയും അതിന്നു ഇരുപതു തൂണും തൂണുകൾക്കു ഇരുപതു താമ്രച്ചുവടും ഉണ്ടായിരുന്നു; തൂണുകളുടെ കൊളുത്തും മേൽചുറ്റുപടിയും വെള്ളി ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","പടിഞ്ഞാറുവശത്തു അമ്പതു മുഴം മറശ്ശീലയും അതിന്നു പത്തു തൂണും തൂണുകൾക്കു പത്തു ചുവടും ഉണ്ടായിരുന്നു; തൂണുകളുടെ കൊളുത്തും മേൽചുറ്റുപടിയും വെള്ളി ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","കിഴക്കുവശത്തു മറശ്ശീല അമ്പതു മുഴം ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","വാതിലിന്റെ ഒരു വശത്തു മറശ്ശീല പതിനഞ്ചു മുഴവും അതിന്നു മൂന്നു തൂണും അവെക്കു മൂന്നു ചുവടും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","മറ്റെവശത്തും അങ്ങനെ തന്നേ; ഇങ്ങനെ പ്രാകാരവാതിലിന്റെ ഇപ്പുറത്തും അപ്പുറത്തും പതിനഞ്ചീതു മുഴം മറശ്ശീലയും അതിന്നു മുമ്മൂന്നു തൂണും മുമ്മൂന്നു ചുവടും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ചുറ്റും പ്രാകാരത്തിന്റെ മറശ്ശീല ഒക്കെയും പിരിച്ച പഞ്ഞിനൂൽകൊണ്ടു ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","തൂണുകൾക്കുള്ള ചുവടു താമ്രംകൊണ്ടും തൂണുകളുടെ കൊളുത്തും മേൽചുറ്റുപടിയും വെള്ളികൊണ്ടും കുമിഴുകൾ വെള്ളിപൊതിഞ്ഞവയും പ്രാകാരത്തിന്റെ തൂണുകൾ ഒക്കെയും വെള്ളികൊണ്ടു മേൽചുറ്റുപടിയുള്ളവയും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","എന്നാൽ പ്രാകാരവാതിലിന്റെ മറശ്ശീല നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽപണി ആയിരുന്നു; അതിന്റെ നീളം ഇരുപതു മുഴവും അതിന്റെ ഉയരമായ വീതി പ്രാകാരത്തിന്റെ മറശ്ശീലെക്കു സമമായി അഞ്ചു മുഴവും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","അതിന്റെ തൂണു നാലും അവയുടെ ചുവടു നാലും താമ്രമായിരുന്നു; കൊളുത്തും കുമിഴുകൾ പൊതിഞ്ഞിരുന്ന തകിടും മേൽചുറ്റുപടിയും വെള്ളി ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","തിരുനിവാസത്തിന്നും പ്രാകാരത്തിന്നും നാലു പുറവുമുള്ള കുറ്റികൾ ഒക്കെയും താമ്രം ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","മോശെയുടെ കല്പന അനുസരിച്ചു പുരോഹിതനായ അഹരോന്റെ മകൻ ഈഥാമാർ മുഖാന്തരം ലേവ്യരുടെ ശുശ്രൂഷയാൽ കണക്കു കൂട്ടിയതുപോലെ സാക്ഷ്യകൂടാരമെന്ന തിരുനിവാസത്തിന്നുണ്ടായ ചെലവു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","യെഹൂദാഗോത്രത്തിൽ ഹൂരിന്റെ മകനായ ഊരിയുടെ മകൻ ബെസലേൽ മോശെയോടു യഹോവ കല്പിച്ചതൊക്കെയും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","അവനോടുകൂടെ ദാൻഗോത്രത്തിൽ അഹീസാമാക്കിന്റെ മകനായി കൊത്തുപണിക്കാരനും കൗശലപ്പണിക്കാരനും നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പഞ്ഞിനൂൽ എന്നിവ കൊണ്ടു ചിത്രത്തയ്യൽപണി ചെയ്യുന്നവനുമായ ഒഹൊലീയാബും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","വിശുദ്ധമന്ദിരത്തിന്റെ സകലപ്രവൃത്തിയുടെയും പണിക്കു വഴിപാടായി വന്നു ഉപയോഗിച്ച പൊന്നു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം ആകെ ഇരുപത്തൊമ്പതു താലന്തും എഴുനൂറ്റിമുപ്പതു ശേക്കെലും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","സഭയിൽ ചാർത്തപ്പെട്ടവരുടെ വെള്ളി വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറു താലന്തും ആയിരത്തെഴുനൂറ്റെഴുപത്തഞ്ചു ശേക്കെലും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു പ്രായമുള്ളവരായി ചാർത്തപ്പെട്ടവരുടെ എണ്ണത്തിൽ ഉൾപ്പെട്ട ആറുലക്ഷത്തിമൂവായിരത്തഞ്ഞൂറ്റമ്പതു പേരിൽ ഓരോരുത്തന്നു ഓരോ ബെക്കാ വീതമായിരുന്നു; അതു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം അര ശേക്കെൽ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","വിശുദ്ധമന്ദിരത്തിന്റെ ചുവടുകളും മറശ്ശീലയുടെ ചുവടുകളും വാർക്കുന്നതിന്നു ഒരു ചുവടിന്നു ഒരു താലന്തു വീതം നൂറു ചുവടിന്നു നൂറു താലന്തു വെള്ളി ചെലവായി. ");
INSERT INTO mal2015_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ശേഷിപ്പുള്ള ആയിരത്തെഴുനൂറ്റെഴുപത്തഞ്ചു ശേക്കെൽകൊണ്ടു അവൻ തൂണുകൾക്കു കൊളുത്തു ഉണ്ടാക്കുകയും കുമിഴ് പൊതികയും മേൽചുറ്റുപടി ഉണ്ടാക്കുകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","വഴിപാടു വന്ന താമ്രം എഴുപതു താലന്തും രണ്ടായിരത്തിനാനൂറു ശേക്കെലും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","അതുകൊണ്ടു അവൻ സമാഗമനകൂടാരത്തിന്റെ വാതിലിന്നുള്ള ചുവടുകളും താമ്രയാഗപീഠവും അതിന്റെ താമ്രജാലവും യാഗപീഠത്തിന്റെ ഉപകരണങ്ങളൊക്കെയും ");
INSERT INTO mal2015_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ചുറ്റും പ്രാകാരത്തിന്റെ ചുവടുകളും പ്രാകാരവാതിലിന്നുള്ള ചുവടുകളും തിരുനിവാസത്തിന്റെ എല്ലാകുറ്റികളും ചുറ്റും പ്രാകാരത്തിന്റെ കുറ്റികളും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ അവർ നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ എന്നിവകൊണ്ടു വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷെക്കായി വിശേഷവസ്ത്രവും അഹരോന്നു വിശുദ്ധവസ്ത്രവും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","പൊന്നു, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു ഏഫോദ് ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പഞ്ഞിനൂൽ എന്നിവയുടെ ഇടയിൽ ചിത്രപ്പണിയായി നെയ്യേണ്ടതിന്നു അവർ പൊന്നു അടിച്ചു നേരിയ തകിടാക്കി നൂലായി കണ്ടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","അവർ അതിന്നു തമ്മിൽ ഇണെച്ചിരിക്കുന്ന ചുമൽക്കണ്ടങ്ങൾ ഉണ്ടാക്കി: അതു രണ്ടു അറ്റത്തും ഇണെച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","അതു കെട്ടി മുറുക്കുവാൻ അതിന്മേലുള്ളതായി ചിത്രപ്പണിയായ നടുക്കെട്ടു, യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ അതിൽ നിന്നു തന്നേ, അതിന്റെ പണിപോലെ പൊന്നു, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","മുദ്രക്കൊത്തായിട്ടു യിസ്രായേൽമക്കളുടെപേർ കൊത്തിയ ഗോമേദകക്കല്ലുകളെ അവർ പൊന്തടങ്ങളിൽ പതിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ അവൻ യിസ്രായേൽമക്കൾക്കുവേണ്ടി ഏഫോദിന്റെ ചുമൽക്കണ്ടങ്ങളിന്മേൽ ഓർമ്മക്കല്ലുകൾ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","അവൻ ഏഫോദിന്റെ പണിപോലെ ചിത്രപ്പണിയായിട്ടു പൊന്നു, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ എന്നിവകൊണ്ടു പതക്കവും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","അതു സമചതുരമായിരുന്നു; പതക്കം ഇരട്ടയായി ഉണ്ടാക്കി; അതു ഒരു ചാൺ നീളവും ഒരു ചാൺ വീതിയും ഉള്ളതായി ഇരട്ട ആയിരന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","അവർ അതിൽ നാലു നിര രത്നം പതിച്ചു: താമ്രമണി, പീതരത്നം, മരതകം; ഇതു ഒന്നാമത്തെ നിര. ");
INSERT INTO mal2015_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","രണ്ടാമത്തെ നിര: മാണിക്യം, നിലക്കല്ലു, വജ്രം, ");
INSERT INTO mal2015_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","മൂന്നാമത്തെ നിര: പത്മരാഗം, വൈഡൂര്യം, സുഗന്ധിക്കല്ലു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","നാലാമത്തെ നിര: ഗോമേദകം, പുഷ്പരാഗം, സൂര്യകാന്തം; അവ അതതു തടത്തിൽ പൊന്നിൽ പതിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ഈ കല്ലുകൾ യിസ്രായേൽമക്കളുടെ പേരുകളോടുകൂടെ അവരുടെ പേർപോലെ പന്ത്രണ്ടു ആയിരുന്നു; പന്ത്രണ്ടു ഗോത്രങ്ങളിൽ ഓരോന്നിന്റെ പേർ അവയിൽ മുദ്രക്കൊത്തായി കൊത്തിയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","പതക്കത്തിന്നു ചരടുപോലെ മുറിച്ചു കുത്തുപണിയായി തങ്കംകൊണ്ടു സരപ്പളികളും ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","പൊന്നുകൊണ്ടു രണ്ടു വളയവും രണ്ടു കണ്ണിയും ഉണ്ടാക്കി; വളയം രണ്ടും പതക്കത്തിന്റെ രണ്ടു അറ്റത്തും വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","പൊന്നുകൊണ്ടുള്ള രണ്ടു സരപ്പളി അവർ പതക്കത്തിന്റെ അറ്റത്തു രണ്ടു വളയത്തിലും കൊളുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","രണ്ടു സരപ്പളിയുടെയും അറ്റം രണ്ടും അവർ കണ്ണിരണ്ടിലും കൊളുത്തി ഏഫോദിന്റെ ചുമൽക്കണ്ടങ്ങളിന്മേൽ മുൻഭാഗത്തുവെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","അവർ പൊന്നുകൊണ്ടു വേറെ രണ്ടു കണ്ണി ഉണ്ടാക്കി പതക്കത്തിന്റെ മറ്റെ രണ്ടു അറ്റത്തും ഏഫോദിന്റെ കീഴറ്റത്തിന്നു നേരെ അകത്തെ വിളുമ്പിൽ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","അവർ വേറെ രണ്ടു പൊൻകണ്ണി ഉണ്ടാക്കി ഏഫോദിന്റെ മുൻഭാഗത്തു രണ്ടു ചുമൽക്കണ്ടങ്ങളിൽ താഴെ അതിന്റെ ഇണെപ്പിന്നരികെ എഫോദിന്റെ നടുക്കെട്ടിന്നു മേലായി വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","പതക്കം ഏഫോദിന്റെ നടുക്കെട്ടിന്നു മേലായി ഇരിക്കേണ്ടതിന്നും അതു ഏഫോദിൽ ആടാതിരിക്കേണ്ടതിന്നും ദൈവം മോശെയോടു കല്പിച്ചതുപോലെ അവർ അതു കണ്ണികളാൽ ഏഫോദിന്റെ കണ്ണികളോടു നീലനാടകൊണ്ടു കെട്ടി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","അവൻ ഏഫോദിന്റെ അങ്കി മുഴുവനും നീലനൂൽകൊണ്ടു നെയ്ത്തുപണിയായി ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","അങ്കിയുടെ നടുവിൽ കവചത്തിന്റെ ദ്വാരംപോലെ ഒരു ദ്വാരവും അതു കീറാതിരിക്കേണ്ടതിന്നു ചുറ്റും ഒരു നാടയും വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","അങ്കിയുടെ വിളുമ്പിൽ നീലനൂൽ ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ, പിരിച്ച പഞ്ഞിനൂൽ, എന്നിവ കൊണ്ടു മാതളപ്പഴങ്ങൾ ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","തങ്കം കൊണ്ടു മണികളും ഉണ്ടാക്കി; മണികൾ അങ്കിയുടെ വിളുമ്പിൽ ചുറ്റും മാതളപ്പഴങ്ങളുടെ ഇടയിൽ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ശുശ്രൂഷെക്കുള്ള അങ്കിയുടെ വിളുമ്പിൽ ചുറ്റും ഒരു മണിയും ഒരു മാതളപ്പഴവും ഒരു മണിയും ഒരു മാതളപ്പഴവും ഇങ്ങനെ യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","അഹരോന്നും പുത്രന്മാർക്കും പഞ്ഞിനൂൽകൊണ്ടു നെയ്ത്തുപണിയായ അങ്കിയും ");
INSERT INTO mal2015_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","പഞ്ഞിനൂൽകൊണ്ടു മുടിയും പഞ്ഞിനൂൽകൊണ്ടു അലങ്കാരമുള്ള തലപ്പാവും പിരിച്ച പഞ്ഞിനൂൽകൊണ്ടു കാൽച്ചട്ടയും ");
INSERT INTO mal2015_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","പിരിച്ച പഞ്ഞിനൂൽ, നീലനൂൽ, ധൂമ്രനൂൽ, ചുവപ്പുനൂൽ എന്നിവകൊണ്ടു ചിത്രത്തയ്യൽപണിയായ നടുക്കെട്ടും യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","അവർ തങ്കംകൊണ്ടു വിശുദ്ധമുടിയുടെ നെറ്റിപ്പട്ടം ഉണ്ടാക്കി, അതിൽ “യഹോവെക്കു വിശുദ്ധം” എന്നു മുദ്രക്കൊത്തായുള്ള ഒരു എഴുത്തു കൊത്തി. ");
INSERT INTO mal2015_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","അതു മുടിമേൽ കെട്ടേണ്ടതിന്നു അതിൽ നീലനൂൽനാട കോർത്തു: യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ഇങ്ങനെ സമാഗമനകൂടാരമെന്ന തിരുനിവാസത്തിന്റെ പണി ഒക്കെയും തീർന്നു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ ഒക്കെയും യിസ്രായേൽമക്കൾ ചെയ്തു. അങ്ങനെ തന്നേ അവർ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","അവർ തിരുനിവാസം മോശെയുടെ അടുക്കൽ കൊണ്ടുവന്നു; കൂടാരവും അതിന്റെ ഉപകരണങ്ങളൊക്കെയും കൊളുത്തു, പലക, ");
INSERT INTO mal2015_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","അന്താഴം, തൂൺ, ചുവടു, ചുവപ്പിച്ച ആട്ടുകൊറ്റന്തോൽകൊണ്ടുള്ള പുറമൂടി, തഹശൂതോൽകൊണ്ടുള്ള പുറമൂടി, മറയുടെ തിരശ്ശീല, ");
INSERT INTO mal2015_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","സാക്ഷ്യപെട്ടകം, അതിന്റെ തണ്ടു, ");
INSERT INTO mal2015_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","കൃപാസനം, മേശ, അതിന്റെ ഉപകരണങ്ങളൊക്കെയും, ");
INSERT INTO mal2015_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","കാഴ്ചയപ്പം, തങ്കംകൊണ്ടുള്ള നിലവിളക്കു, കത്തിച്ചുവെപ്പാനുള്ള ദീപങ്ങൾ, അതിന്റെ ഉപകരണങ്ങളൊക്കെയും, ");
INSERT INTO mal2015_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","വെളിച്ചത്തിന്നു എണ്ണ, പൊന്നുകൊണ്ടുള്ള ധൂപപീഠം, അഭിഷേകതൈലം, സുഗന്ധ ധൂപവർഗ്ഗം, കൂടാരവാതിലിന്നുള്ള മറശ്ശീല, ");
INSERT INTO mal2015_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","താമ്രംകൊണ്ടുള്ള യാഗപീഠം, അതിന്റെ താമ്രജാലം, തണ്ടു, അതിന്റെ ഉപകരണങ്ങളൊക്കെയും, തൊട്ടി, അതിന്റെ കാൽ, ");
INSERT INTO mal2015_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","പ്രാകാരത്തിന്റെ മറശ്ശീല, തൂൺ, അതിന്റെ ചുവടു, പ്രാകാരവാതിലിന്റെ മറശ്ശീല, അതിന്റെ കയറു, കുറ്റി, സമാഗമനകൂടാരമെന്ന തിരുനിവാസത്തിലെ ശുശ്രൂഷെക്കുള്ള ഉപകരണങ്ങളൊക്കെയും, ");
INSERT INTO mal2015_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷെക്കായി വിശേഷവസ്ത്രം, പുരോഹിതശുശ്രൂഷെക്കുള്ള അഹരോന്റെ വിശുദ്ധവസ്ത്രം, അവന്റെ പുത്രന്മാരുടെ വസ്ത്രം ");
INSERT INTO mal2015_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ഇങ്ങനെ യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ ഒക്കെയും യിസ്രായേൽമക്കൾ എല്ലാപണിയും തീർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","മോശെ പണി ഒക്കെയും നോക്കി, യഹോവ കല്പിച്ചതുപോലെ തന്നേ അവർ അതു ചെയ്തു തീർത്തിരുന്നു എന്നു കണ്ടു മോശെ അവരെ അനുഗ്രഹിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","അനന്തരം യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","ഒന്നാം മാസം ഒന്നാം തിയ്യതി നീ സമാഗമനകൂടാരമെന്ന തിരുനിവാസം നിവിർക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","സാക്ഷ്യപെട്ടകം അതിൽ വെച്ചു തിരശ്ശീലകൊണ്ടു പെട്ടകം മറെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","മേശ കൊണ്ടുവന്നു അതിന്റെ സാധനങ്ങൾ ക്രമത്തിൽ വെക്കേണം. നിലവിളക്കു കൊണ്ടുവന്നു അതിന്റെ ദീപം കൊളുത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ധൂപത്തിന്നുള്ള പൊൻപീഠം സാക്ഷ്യപെട്ടകത്തിന്നു മുമ്പിൽ വെച്ചു തിരുനിവാസവാതിലിന്റെ മറശ്ശീല തൂക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","സമാഗമനകൂടാരമെന്ന തിരുനിവാസത്തിന്റെ വാതിലിന്നു മുമ്പിൽ ഹോമയാഗപീഠം വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","സമാഗമനകൂടാരത്തിന്നും യാഗപീഠത്തിന്നും നടുവിൽ തൊട്ടി വെച്ചു അതിൽ വെള്ളം ഒഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ചുറ്റും പ്രാകാരം നിവിർത്തു പ്രാകാരവാതിലിന്റെ മറശ്ശീല തൂക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","അഭിഷേകതൈലം എടുത്തു തിരുനിവാസവും അതിലുള്ള സകലവും അഭിഷേകം ചെയ്തു അതും അതിന്റെ ഉപകരണങ്ങളൊക്കെയും ശുദ്ധീകരിക്കേണം; അതു വിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ഹോമയാഗപീഠവും അതിന്റെ ഉപകരണങ്ങൾ ഒക്കെയും അഭിഷേകം ചെയ്തു യാഗപീഠം ശുദ്ധീകരിക്കേണം; യാഗപീഠം അതിവിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","തൊട്ടിയും അതിന്റെ കാലും അഭിഷേകം ചെയ്തു ശുദ്ധീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","അഹരോനെയും പുത്രന്മാരെയും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ കൊണ്ടുവന്നു അവരെ വെള്ളംകൊണ്ടു കഴുകേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","അഹരോനെ വിശുദ്ധവസ്ത്രം ധരിപ്പിച്ചു, എനിക്കു പുരോഹിതശുശ്രൂഷ ചെയ്യേണ്ടതിന്നു അവനെ അഭിഷേകം ചെയ്തു ശുദ്ധീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","അവന്റെ പുത്രന്മാരെ വരുത്തി അങ്കി ധരിപ്പിച്ചു, ");
INSERT INTO mal2015_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","എനിക്കു പുരോഹിത ശുശ്രൂഷ ചെയ്യേണ്ടതിന്നു അവരുടെ അപ്പനെ അഭിഷേകം ചെയ്തതുപോലെ അവരെയും അഭിഷേകം ചെയ്യേണം; അവരുടെ അഭിഷേകം ഹേതുവായി അവർക്കു തലമുറതലമുറയോളം നിത്യപൗരോഹിത്യം ഉണ്ടായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","മോശെ അങ്ങനെ ചെയ്തു; യഹോവ തന്നോടു കല്പിച്ചതുപോലെ ഒക്കെയും അവൻ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ഇങ്ങനെ രണ്ടാം സംവത്സരം ഒന്നാം മാസം ഒന്നാം തിയ്യതി തിരുനിവാസം നിവിർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","മോശെ തിരുനിവാസം നിവിർക്കുകയും അതിന്റെ ചുവടു ഉറപ്പിക്കയും പലക നിറുത്തുകയും അന്താഴം ചെലുത്തുകയും തൂൺ നാട്ടുകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","അവൻ മൂടുവിരി തിരുനിവാസത്തിന്മേൽ വിരിച്ചു അതിന്മീതെ മൂടുവിരിയുടെ പുറമൂടിയും വിരിച്ചു; യഹോവാ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","അവൻ സാക്ഷ്യം എടുത്തു പെട്ടകത്തിൽ വെച്ചു; പെട്ടകത്തിന്നു തണ്ടു ചെലുത്തി പെട്ടകത്തിന്നു മീതെ കൃപാസനം വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","പെട്ടകം തിരുനിവാസത്തിൽ കൊണ്ടുവന്നു മറയുടെ തിരശ്ശീല തൂക്കി സാക്ഷ്യപെട്ടകം മറെച്ചു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","സമാഗമനകൂടാരത്തിൽ തിരുനിവാസത്തിന്റെ വടക്കുവശത്തു തിരശ്ശീലെക്കു പുറത്തായി മേശവെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","അതിന്മേൽ യഹോവയുടെ സന്നിധിയിൽ അപ്പം അടുക്കിവെച്ചു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","സമാഗമനകൂടാരത്തിൽ മേശെക്കു നേരെ തിരുനിവാസത്തിന്റെ തെക്കുവശത്തു നിലവിളക്കു വെക്കയും യഹോവയുടെ സന്നിധിയിൽ ദീപം കൊളുത്തുകയും ചെയ്തു; ");
INSERT INTO mal2015_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","സമാഗമനകൂടാരത്തിൽ തിരശ്ശീലയുടെ മുൻവശത്തു പൊന്നുകൊണ്ടുള്ള ധൂപപീഠം വെക്കയും അതിന്മേൽ സുഗന്ധധൂപവർഗ്ഗം ധൂപിക്കയും ചെയ്തു; ");
INSERT INTO mal2015_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","അവൻ തിരുനിവാസത്തിന്റെ വാതിലിന്നുള്ള മറശ്ശീല തൂക്കി. ");
INSERT INTO mal2015_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ഹോമയാഗപീഠം സമാഗമനകൂടാരമെന്ന തിരുനിവാസത്തിന്റെ വാതിലിന്നു മുൻവശത്തു വെക്കയും അതിന്മേൽ ഹോമയാഗവും ഭോജനയാഗവും അർപ്പിക്കയും ചെയ്തു. യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","സമാഗമനകൂടാരത്തിന്നും യാഗപീഠത്തിന്നും നടുവിൽ അവൻ തൊട്ടിവെക്കയും കഴുകേണ്ടതിന്നു അതിൽ വെള്ളം ഒഴിക്കയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","മോശെയും അഹരോനും അവന്റെ പുത്രന്മാരും അതിൽ കയ്യും കാലും കഴുകി. ");
INSERT INTO mal2015_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","അവർ സമാഗമനകൂടാരത്തിൽ കടക്കുമ്പോഴും യാഗപീഠത്തിങ്കൽ ചെല്ലുമ്പോഴും കൈകാലുകൾ കഴുകും; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","അവൻ തിരുനിവാസത്തിന്നും യാഗപീഠത്തിന്നും ചുറ്റം പ്രാകാരം നിറുത്തി; പ്രാകാരവാതിലിന്റെ മറശ്ശീല തൂക്കി. ഇങ്ങനെ മോശെ പ്രവൃത്തി സമാപിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","അപ്പോൾ മേഘം സമാഗമനകൂടാരത്തെ മൂടി, യഹോവയുടെ തേജസ്സു തിരുനിവാസത്തെ നിറെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","മേഘം സമാഗമനകൂടാരത്തിന്മേൽ അധിവസിക്കയും യഹോവയുടെ തേജസ്സു തിരുനിവാസത്തെ നിറെക്കയും ചെയ്തതുകൊണ്ടു മോശെക്കു അകത്തു കടപ്പാൻ കഴിഞ്ഞില്ല. ");
INSERT INTO mal2015_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","യിസ്രായേൽമക്കൾ തങ്ങളുടെ സകലപ്രയാണങ്ങളിലും മേഘം തിരുനിവാസത്തിന്മേൽനിന്നു ഉയരുമ്പോൾ യാത്ര പുറപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","മേഘം ഉയരാതിരുന്നാൽ അതു ഉയരുംനാൾവരെ അവർ യാത്രപുറപ്പെടാതിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","യിസ്രായേല്യരുടെ സകലപ്രയാണങ്ങളിലും അവരെല്ലാവരും കാൺകെ പകൽ സമയത്തു തിരുനിവാസത്തിന്മേൽ യഹോവയുടെ മേഘവും രാത്രിസമയത്തു അതിൽ അഗ്നിയും ഉണ്ടായിരുന്നു.");
INSERT INTO mal2015_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","യഹോവ സമാഗമനകൂടാരത്തിൽവെച്ചു മോശെയെ വിളിച്ചു അവനോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","നീ യിസ്രായേൽമക്കളോടു സംസാരിച്ചു അവരോടു പറയേണ്ടതു എന്തെന്നാൽ: നിങ്ങളിൽ ആരെങ്കിലും യഹോവെക്കു വഴിപാടു കഴിക്കുന്നു എങ്കിൽ കന്നുകാലികളോ ആടുകളോ ആയ മൃഗങ്ങളെ വഴിപാടു കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","അവൻ വഴിപാടായി കന്നുകാലികളിൽ ഒന്നിനെ ഹോമയാഗം കഴിക്കുന്നുവെങ്കിൽ ഊനമില്ലാത്ത ആണിനെ അർപ്പിക്കേണം; യഹോവയുടെ പ്രസാദം ലഭിപ്പാൻ തക്കവണ്ണം അവൻ അതിനെ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽവെച്ചു അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","അവൻ ഹോമയാഗത്തിന്റെ തലയിൽ കൈ വെക്കേണം; എന്നാൽ അതു അവന്നുവേണ്ടി പ്രായശ്ചിത്തം വരുത്തുവാൻ അവന്റെ പേർക്കു സുഗ്രാഹ്യമാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","അവൻ യഹോവയുടെ സന്നിധിയിൽ കാളക്കിടാവിനെ അറുക്കേണം; അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാർ അതിന്റെ രക്തം കൊണ്ടുവന്നു സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ ഉള്ള യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","അവൻ ഹോമയാഗമൃഗത്തെ തോലുരിച്ചു ഖണ്ഡംഖണ്ഡമായി മുറിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","പുരോഹിതനായ അഹരോന്റെ പുത്രന്മാർ യാഗപീഠത്തിന്മേൽ തീ ഇട്ടു തീയുടെമേൽ വിറകു അടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","പിന്നെ അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാർ ഖണ്ഡങ്ങളും തലയും മേദസ്സും യാഗപീഠത്തിൽ തീയുടെമേലുള്ള വിറകിന്മീതെ അടുക്കിവെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","അതിന്റെ കുടലും കാലും അവൻ വെള്ളത്തിൽ കഴുകേണം. പുരോഹിതൻ സകലവും യാഗപീഠത്തിന്മേൽ ഹോമയാഗമായി ദഹിപ്പിക്കേണം; അതു യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","ഹോമയാഗത്തിന്നുള്ള അവന്റെ വഴിപാടു ആട്ടിൻകൂട്ടത്തിലെ ഒരു ചെമ്മരിയാടോ കോലാടോ ആകുന്നുവെങ്കിൽ ഊനമില്ലാത്ത ആണിനെ അവൻ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","അവൻ യഹോവയുടെ സന്നിധിയിൽ യാഗപീഠത്തിന്റെ വടക്കുവശത്തുവെച്ചു അതിനെ അറുക്കേണം; അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാർ അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","അവൻ അതിനെ തലയോടും മേദസ്സോടുംകൂടെ ഖണ്ഡംഖണ്ഡമായി മുറിക്കേണം; പുരോഹിതൻ അവയെ യാഗപീഠത്തിൽ തീയുടെമേലുള്ള വിറകിന്മീതെ അടുക്കിവെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","കുടലും കാലും അവൻ വെള്ളത്തിൽ കഴുകേണം; പുരോഹിതൻ സകലവും കൊണ്ടുവന്നു ഹോമയാഗമായി യഹോവെക്കു സൗരഭ്യവാസനയുള്ള ദഹനയാഗമായി യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","യഹോവെക്കു അവന്റെ വഴിപാടു പറവജാതിയിൽ ഒന്നിനെക്കൊണ്ടുള്ള ഹോമയാഗമാകുന്നു എങ്കിൽ അവൻ കുറുപ്രാവിനെയോ പ്രാവിൻകുഞ്ഞിനെയോ വഴിപാടായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","പുരോഹിതൻ അതിനെ യാഗപീഠത്തിന്റെ അടുക്കൽ കൊണ്ടുവന്നു തല പിരിച്ചുപറിച്ചു യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കേണം; അതിന്റെ രക്തം യാഗപീഠത്തിന്റെ പാർശ്വത്തിങ്കൽ പിഴിഞ്ഞുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","അതിന്റെ തീൻപണ്ടം മലത്തോടുകൂടെ പറിച്ചെടുത്തു യാഗപീഠത്തിന്റെ അരികെ കിഴക്കുവശത്തു വെണ്ണീരിടുന്ന സ്ഥലത്തു ഇടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","അതിനെ രണ്ടാക്കാതെ ചിറകോടുകൂടെ പിളർക്കേണം; പുരോഹിതൻ അതിനെ യാഗപീഠത്തിൽ തീയുടെമേലുള്ള വിറകിന്മീതെ ദഹിപ്പിക്കേണം; അതു ഹോമയാഗമായി യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ആരെങ്കിലും യഹോവെക്കു ഭോജനയാഗമായ വഴിപാടു കഴിക്കുമ്പോൾ അവന്റെ വഴിപാടു നേരിയ മാവു ആയിരിക്കേണം; അവൻ അതിന്മേൽ എണ്ണ ഒഴിച്ചു കുന്തുരുക്കവും ഇടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാരുടെ അടുക്കൽ അതു കൊണ്ടുവരേണം. അവൻ മാവും എണ്ണയും ഒരു കൈ നിറച്ചും കുന്തുരുക്കം മുഴുവനും എടുക്കേണം; പുരോഹിതൻ അതു നിവേദ്യമായി യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കേണം; അതു യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","എന്നാൽ ഭോജനയാഗത്തിന്റെ ശേഷിപ്പു അഹരോന്നും പുത്രന്മാർക്കും ഇരിക്കേണം. യഹോവെക്കുള്ള ദഹനയാഗങ്ങളിൽ ഇതു അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","അടുപ്പത്തുവെച്ചു ചുട്ടതു നീ ഭോജനയാഗമായി കഴിക്കുന്നു എങ്കിൽ അതു നേരിയ മാവു കൊണ്ടുണ്ടാക്കിയതായി എണ്ണ ചേർത്ത പുളിപ്പില്ലാത്ത ദോശകളോ എണ്ണ പുരട്ടിയ പുളിപ്പില്ലാത്ത വടകളോ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","നിന്റെ വഴിപാടു ചട്ടിയിൽ ചുട്ട ഭോജനയാഗം ആകുന്നുവെങ്കിൽ അതു എണ്ണ ചേർത്ത പുളിപ്പില്ലാത്ത നേരിയ മാവുകൊണ്ടു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","അതു കഷണംകഷണമായി നുറക്കി അതിന്മേൽ എണ്ണ ഒഴിക്കേണം; അതു ഭോജനയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","നിന്റെ വഴിപാടു ഉരുളിയിൽ ചുട്ട ഭോജനയാഗം ആകുന്നുവെങ്കിൽ അതു എണ്ണ ചേർത്ത നേരിയ മാവുകൊണ്ടു ഉണ്ടാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ഇവകൊണ്ടു ഉണ്ടാക്കിയ ഭോജനയാഗം നീ യഹോവെക്കു കൊണ്ടുവരേണം; അതു പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുചെല്ലുകയും അവൻ അതു യാഗപീഠത്തിങ്കൽ കൊണ്ടുപോകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","പുരോഹിതൻ ഭോജനയാഗത്തിന്റെ നിവേദ്യം എടുത്തു യാഗപീഠത്തിന്മേൽ യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗമായി ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ഭോജനയാഗത്തിന്റെ ശേഷിപ്പു അഹരോന്നും പുത്രന്മാർക്കും ഇരിക്കേണം; അതു യഹോവെക്കുള്ള ദഹനയാഗങ്ങളിൽ അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","നിങ്ങൾ യഹോവെക്കു കഴിക്കുന്ന യാതൊരു ഭോജനയാഗവും പുളിപ്പുള്ളതായി ഉണ്ടാക്കരുതു; പുളിച്ചതു ഒന്നും യാതൊരു വക തേനും യഹോവെക്കു ദഹനയാഗമായി ദഹിപ്പിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","അവ ആദ്യഫലങ്ങളുടെ വഴിപാടായി യഹോവെക്കു അർപ്പിക്കാം. എങ്കിലും സൗരഭ്യവാസനയായി യാഗപീഠത്തിന്മേൽ അവ കയറരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","നിന്റെ ഭോജനയാഗത്തിന്നു ഒക്കെയും ഉപ്പു ചേർക്കേണം; നിന്റെ ദൈവത്തിന്റെ നിയമത്തിൻ ഉപ്പു ഭോജനയാഗത്തിന്നു ഇല്ലാതിരിക്കരുതു; എല്ലാവഴിപാടിന്നും ഉപ്പു ചേർക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","നിന്റെ ആദ്യഫലങ്ങളുടെ ഭോജനയാഗം യഹോവെക്കു കഴിക്കുന്നു എങ്കിൽ കതിർ ചുട്ടു ഉതിർത്ത മണികൾ ആദ്യഫലങ്ങളുടെ ഭോജനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","അതിന്മേൽ എണ്ണ ഒഴിച്ചു അതിൻമീതെ കുന്തുരുക്കവും ഇടേണം; അതു ഒരു ഭോജനയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ഉതിർത്ത മണിയിലും എണ്ണയിലും കുറേശ്ശയും കുന്തുരുക്കം മുഴുവനും പുരോഹിതൻ നിവേദ്യമായി ദഹിപ്പിക്കേണം; അതു യഹോവെക്കു ഒരു ദഹനയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","ഒരുവന്റെ വഴിപാടു സമാധാനയാഗം ആകുന്നുവെങ്കിൽ കന്നുകാലികളിൽ ഒന്നിനെ അർപ്പിക്കുന്നതായാൽ ആണാകട്ടെ പെണ്ണാകട്ടെ ഊനമില്ലാത്തതിനെ അവൻ യഹോവയുടെ സന്നിധിയിൽ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","തന്റെ വഴിപാടിന്റെ തലയിൽ അവൻ കൈവെച്ചു സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽവെച്ചു അതിനെ അറുക്കേണം; അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാർ അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","അവൻ സമാധാനയാഗത്തിൽനിന്നു കുടൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും കുടലിന്മേലിരിക്കുന്ന സകലമേദസ്സും മൂത്രപിണ്ഡം രണ്ടും ");
INSERT INTO mal2015_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","അവയുടെ മേൽ കടിപ്രദേശത്തുള്ള മേദസ്സും മൂത്രപിണ്ഡത്തോടുകൂടെ കരളിന്മേലുള്ള വപയും നീക്കി യഹോവെക്കു ദഹനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","അഹരോന്റെ പുത്രന്മാർ യാഗപീഠത്തിൽ തീയുടെ മേലുള്ള വിറകിന്മേൽ ഹോമയാഗത്തിന്മീതെ അതു ദഹിപ്പിക്കേണം; അതു യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","യഹോവെക്കു സമാധാനയാഗമായുള്ള വഴിപാടു ആടു ആകുന്നു എങ്കിൽ ആണാകട്ടെ പെണ്ണാകട്ടെ ഊനമില്ലാത്തതിനെ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ഒരു കുഞ്ഞാടിനെ വഴിപാടായിട്ടു അർപ്പിക്കുന്നു എങ്കിൽ അതിനെ യഹോവയുടെ സന്നിധിയിൽ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","തന്റെ വഴിപാടിന്റെ തലയിൽ അവൻ കൈവെച്ചു സമാഗമനകൂടാരത്തിന്റെ മുമ്പാകെ അതിനെ അറുക്കേണം; അഹരോന്റെ പുത്രന്മാർ അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","അവൻ സമാധാനയാഗത്തിൽനിന്നു അതിന്റെ മേദസ്സും തടിച്ചവാൽ മുഴുവനും - ഇതു തണ്ടെല്ലിങ്കൽനിന്നു പറിച്ചുകളയേണം - കുടൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും കുടലിന്മേലുള്ള സകലമേദസ്സും ");
INSERT INTO mal2015_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","മൂത്രപിണ്ഡം രണ്ടും അവയുടെ മേൽ കടിപ്രദേശത്തുള്ള മേദസ്സും മൂത്രപിണ്ഡത്തോടുകൂടെ കരളിന്മേലുള്ള വപയും നീക്കി യഹോവെക്കു ദഹനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","പുരോഹിതൻ അതു യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കേണം; അതു യഹോവെക്കു ദഹനയാഗഭോജനം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","അവന്റെ വഴിപാടു കോലാടു ആകുന്നു എങ്കിൽ അവൻ അതിനെ യഹോവയുടെ സന്നിധിയിൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","അതിന്റെ തലയിൽ അവൻ കൈവെച്ചു സമാഗമനകൂടാരത്തിന്റെ മുമ്പാകെ അതിനെ അറുക്കേണം; അഹരോന്റെ പുത്രന്മാർ അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","അതിൽനിന്നു കുടൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും കുടലിന്മേലുള്ള സകല മേദസ്സും മൂത്രപിണ്ഡം രണ്ടും ");
INSERT INTO mal2015_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","അവയുടെ മേൽ കടിപ്രദേശത്തുള്ള മേദസ്സം മൂത്രപിണ്ഡങ്ങളോടുകൂടെ കരളിന്മേലുള്ള വപയും നീക്കി അവൻ യഹോവെക്കു ദഹനയാഗമായി തന്റെ വഴിപാടു അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","പുരോഹിതൻ അതു യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കേണം; അതു സൗരഭ്യവാസനയായ ദഹനയാഗഭോജനം; മേദസ്സൊക്കെയും യഹോവെക്കുള്ളതു ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","മേദസ്സും രക്തവും തിന്നരുതു എന്നുള്ളതു നിങ്ങളുടെ സകലവാസസ്ഥലങ്ങളിലും നിങ്ങൾക്കു തലമുറതലമുറയായി എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ചെയ്യരുതെന്നു യഹോവ കല്പിച്ചിട്ടുള്ള വല്ല കാര്യത്തിലും ആരെങ്കിലും അബദ്ധവശാൽ പിഴെച്ചു ആ വക വല്ലതും ചെയ്താൽ - ");
INSERT INTO mal2015_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","അഭിഷിക്തനായ പുരോഹിതൻ ജനത്തിന്മേൽ കുറ്റം വരത്തക്കവണ്ണം പാപം ചെയ്തു എങ്കിൽ താൻ ചെയ്ത പാപം നിമിത്തം അവൻ യഹോവെക്കു പാപയാഗമായി ഊനമില്ലാത്ത ഒരു കാളക്കിടാവിനെ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","അവൻ ആ കാളയെ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ യഹോവയുടെ സന്നിധിയിൽ കൊണ്ടുവന്നു കാളയുടെ തലയിൽ കൈവെച്ചു യഹോവയുടെ സന്നിധിയിൽ കാളയെ അറുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","അഭിഷിക്തനായ പുരോഹിതൻ കാളയുടെ രക്തം കുറെ എടുത്തു സമാഗമനകൂടാരത്തിൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","പുരോഹിതൻ രക്തത്തിൽ വിരൽ മുക്കി യഹോവയുടെ സന്നിധിയിൽ വിശുദ്ധമന്ദിരത്തിന്റെ തിരശ്ശീലെക്കു മുമ്പിൽ ഏഴു പ്രാവശ്യം തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","പുരോഹിതൻ രക്തം കുറെ യഹോവയുടെ സന്നിധിയിൽ സമാഗമനകൂടാരത്തിലുള്ള സുഗന്ധവർഗ്ഗത്തിൻ ധൂപപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടേണം; കാളയുടെ ശേഷം രക്തം മുഴുവനും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ ഉള്ള ഹോമയാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","പാപയാഗത്തിന്നുള്ള കാളയുടെ സകലമേദസ്സും കുടൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും കുടലിന്മേലുള്ള സകലമേദസ്സും അതിൽനിന്നു നീക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","മൂത്രപിണ്ഡം രണ്ടും അവയുടെ മേൽ കടിപ്രദേശത്തുള്ള മേദസ്സും മൂത്രപിണ്ഡങ്ങളോടുകൂടെ കരളിന്മേലുള്ള വപയും അവൻ എടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","സമാധാനയാഗത്തിന്നുള്ള കാളയിൽനിന്നു എടുത്തതുപോലെ തന്നേ; പുരോഹിതൻ ഹോമയാഗപീഠത്തിന്മേൽ അതു ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","കാളയുടെ തോലും മാംസം മുഴുവനും തലയും കാലുകളും കുടലും ചാണകവുമായി കാളയെ മുഴുവനും ");
INSERT INTO mal2015_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","അവൻ പാളയത്തിന്നു പുറത്തു വെണ്ണീർ ഇടുന്ന വെടിപ്പുള്ള സ്ഥലത്തു കൊണ്ടുപോയി വിറകിന്മേൽ വെച്ചു തീയിട്ടു ചുട്ടുകളയേണം; വെണ്ണീർ ഇടുന്നേടത്തു വെച്ചുതന്നേ അതു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","യിസ്രായേൽസഭ മുഴുവനും അബദ്ധവശാൽ പിഴെക്കയും ആ കാര്യം സഭയുടെ കണ്ണിന്നു മറഞ്ഞിരിക്കയും, ചെയ്യരുതെന്നു യഹോവ കല്പിച്ചിട്ടുള്ള വല്ലകാര്യത്തിലും അവർ പാപം ചെയ്തു കുറ്റക്കാരായി തീരുകയും ചെയ്താൽ, ");
INSERT INTO mal2015_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ചെയ്ത പാപം അവർ അറിയുമ്പോൾ സഭ ഒരു കാളക്കിടാവിനെ പാപയാഗമായി അർപ്പിക്കേണം; സമാഗമനകൂടാരത്തിന്റെ മുമ്പാകെ അതിനെ കൊണ്ടുവന്നിട്ടു ");
INSERT INTO mal2015_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","സഭയുടെ മൂപ്പന്മാർ യഹോവയുടെ സന്നിധിയിൽ കാളയുടെ തലയിൽ കൈ വെക്കേണം; യഹോവയുടെ സന്നിധിയിൽ കാളയെ അറുക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","അഭിഷിക്തനായ പുരോഹിതൻ കാളയുടെ രക്തം കുറെ സമാഗമനകൂടാരത്തിൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","പുരോഹിതൻ രക്തത്തിൽ വിരൽ മുക്കി യഹോവയുടെ സന്നിധിയിൽ തിരശ്ശീലെക്കു മുമ്പിൽ ഏഴു പ്രാവശ്യം തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","അവൻ സമാഗമനകൂടാരത്തിൽ യഹോവയുടെ സന്നിധിയിലുള്ള പീഠത്തിന്റെ കൊമ്പുകളിൽ കുറെ പുരട്ടേണം; ശേഷം രക്തം മുഴുവനും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കലുള്ള ഹോമയാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","അതിന്റെ മേദസ്സു ഒക്കെയും അവൻ അതിൽനിന്നു എടുത്തു യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","പാപയാഗത്തിന്നുള്ള കാളയെ അവൻ ചെയ്തതുപോലെ തന്നേ ഈ കാളയെയും ചെയ്യേണം; അങ്ങനെ തന്നേ ഇതിനെയും ചെയ്യേണം; ഇങ്ങനെ പുരോഹിതൻ അവർക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു അവരോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","പിന്നെ അവൻ കാളയെ പാളയത്തിന്നു പുറത്തു കൊണ്ടുപോയി മുമ്പിലത്തെ കാളയെ ചുട്ടുകളഞ്ഞതുപോലെ ഇതിനെയും ചുട്ടുകളയേണം; ഇതു സഭെക്കുവേണ്ടിയുള്ള പാപയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","ഒരു പ്രമാണി പാപം ചെയ്കയും, ചെയ്യരുതെന്നു തന്റെ ദൈവമായ യഹോവ കല്പിച്ചിട്ടുള്ള വല്ല കാര്യത്തിലും അബദ്ധവശാൽ പിഴെച്ചു കുറ്റക്കാരനായി തീരുകയും ചെയ്താൽ ");
INSERT INTO mal2015_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","അവൻ ചെയ്ത പാപം അവന്നു ബോദ്ധ്യമായി എങ്കിൽ അവൻ ഊനമില്ലാത്ത ഒരു ആൺകോലാട്ടിനെ വഴിപാടായി കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","അവൻ ആട്ടിന്റെ തലയിൽ കൈവെച്ചു യഹോവയുടെ സന്നിധിയിൽ ഹോമയാഗമൃഗത്തെ അറുക്കുന്ന സ്ഥലത്തുവെച്ചു അതിനെ അറുക്കേണം; അതു ഒരു പാപയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","പിന്നെ പുരോഹിതൻ പാപയാഗത്തിന്റെ രക്തം വിരൽകൊണ്ടു കുറെ എടുത്തു ഹോമയാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടി ശേഷം രക്തം ഹോമയാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","അതിന്റെ മേദസ്സു ഒക്കെയും അവൻ സമാധാനയാഗത്തിന്റെ മേദസ്സുപോലെ യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കേണം; ഇങ്ങനെ പുരോഹിതൻ അവന്റെ പാപം നിമിത്തം അവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു അവനോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ദേശത്തെ ജനത്തിൽ ഒരുത്തൻ ചെയ്യരുതെന്നു യഹോവ കല്പിച്ചിട്ടുള്ള വല്ലകാര്യത്തിലും അബദ്ധവശാൽ പിഴെച്ചു കുറ്റക്കാരനായി തീർന്നാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","പാപം അവന്നു ബോദ്ധ്യമായി എങ്കിൽ അവൻ ചെയ്ത പാപംനിമിത്തം ഊനമില്ലാത്ത ഒരു പെൺകോലാട്ടിനെ വഴിപാടായി കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","പാപയാഗമൃഗത്തിന്റെ തലയിൽ അവൻ കൈ വെച്ചിട്ടു ഹോമയാഗത്തിന്റെ സ്ഥലത്തുവെച്ചു പാപയാഗമൃഗത്തെ അറുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","പുരോഹിതൻ അതിന്റെ രക്തം വിരൽകൊണ്ടു കുറെ എടുത്തു ഹോമയാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടി, ശേഷം രക്തം ഒക്കെയും യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","അതിന്റെ മേദസ്സു ഒക്കെയും സമാധാനയാഗത്തിൽനിന്നു മേദസ്സു എടുക്കുന്നതുപോലെ എടുത്തു പുരോഹിതൻ യാഗപീഠത്തിന്മേൽ യഹോവെക്കു സൗരഭ്യവാസനയായി ദഹിപ്പിക്കേണം; ഇങ്ങനെ പുരോഹിതൻ അവന്നു വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു അവനോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","അവൻ പാപയാഗമായി ഒരു ആട്ടിൻകുട്ടിയെ കൊണ്ടുവരുന്നു എങ്കിൽ ഊനമില്ലാത്ത പെണ്ണാട്ടിനെ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","പാപയാഗമൃഗത്തിന്റെ തലയിൽ അവൻ കൈവെച്ചു ഹോമയാഗമൃഗത്തെ അറുക്കുന്ന സ്ഥലത്തുവെച്ചു അതിനെ പാപയാഗമായി അറുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","പുരോഹിതൻ പാപയാഗത്തിന്റെ രക്തം വിരൽകൊണ്ടു കുറെ എടുത്തു ഹോമയാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടി, ശേഷം രക്തം ഒക്കെയും യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","അതിന്റെ മേദസ്സു ഒക്കെയും സമാധാനയാഗത്തിൽനിന്നു ആട്ടിൻകുട്ടിയുടെ മേദസ്സു എടുക്കുന്നതുപോലെ അവൻ എടുക്കേണം; പുരോഹിതൻ യാഗപീഠത്തിന്മേൽ യഹോവയുടെ ദഹനയാഗങ്ങളെപ്പോലെ അവയെ ദഹിപ്പിക്കേണം; അവൻ ചെയ്ത പാപത്തിന്നു പുരോഹിതൻ ഇങ്ങനെ പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു അവനോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","ഒരുത്തൻ സത്യവാചകം കേട്ടിട്ടു, താൻ സാക്ഷിയായി കാണുകയോ അറികയോ ചെയ്തതു അറിയിക്കാതെ അങ്ങനെ പാപം ചെയ്താൽ അവൻ തന്റെ കുറ്റം വഹിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ശുദ്ധിയില്ലാത്ത കാട്ടുമൃഗത്തിന്റെ പിണമോ ശുദ്ധിയില്ലാത്ത നാട്ടുമൃഗത്തിന്റെ പിണമോ ശുദ്ധിയില്ലാത്ത ഇഴജാതിയുടെ പിണമോ ഇങ്ങനെ വല്ല അശുദ്ധവസ്തുവും ഒരുത്തൻ തൊടുകയും അതു അവന്നു മറവായിരിക്കയും ചെയ്താൽ അവൻ അശുദ്ധനും കുറ്റക്കാരനും ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","അല്ലെങ്കിൽ യാതൊരു അശുദ്ധിയാലെങ്കിലും അശുദ്ധനായ ഒരു മനുഷ്യന്റെ അശുദ്ധിയെ ഒരുത്തൻ തൊടുകയും അതു അവന്നു മറവായിരിക്കയും ചെയ്താൽ അതു അറിയുമ്പോൾ അവൻ കുറ്റക്കാരനാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","അല്ലെങ്കിൽ മനുഷ്യൻ നിർവ്വിചാരമായി സത്യം ചെയ്യുന്നതുപോലെ ദോഷം ചെയ്‌വാനോ ഗുണം ചെയ്‌വാനോ ഒരുത്തൻ തന്റെ അധരങ്ങൾ കൊണ്ടു നിർവ്വിചാരമായി സത്യം ചെയ്കയും അതു അവന്നു മറവായിരിക്കയും ചെയ്താൽ അവൻ അതു അറിയുമ്പോൾ അങ്ങനെയുള്ള കാര്യത്തിൽ അവൻ കുറ്റക്കാരനാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ആ വക കാര്യത്തിൽ അവൻ കുറ്റക്കാരനാകുമ്പോൾ താൻ പാപം ചെയ്തു എന്നു അവൻ ഏറ്റുപറയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","താൻ ചെയ്ത പാപം നിമിത്തം അവൻ യഹോവെക്കു അകൃത്യയാഗമായി ചെമ്മരിയാട്ടിൻകുട്ടിയോ കോലാട്ടിൻകുട്ടിയോ ആയ ഒരു പെണ്ണാട്ടിനെ പാപയാഗമായി കൊണ്ടുവരേണം; പുരോഹിതൻ അവന്നുവേണ്ടി അവന്റെ പാപംനിമിത്തം പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","ആട്ടിൻകുട്ടിക്കു അവന്നു വകയില്ലെങ്കിൽ താൻ ചെയ്ത പാപംനിമിത്തം അവൻ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ ഒന്നിനെ പാപയാഗമായും മറ്റേതിനെ ഹോമയാഗമായും യഹോവെക്കു കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","അവൻ അവയെ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടു വരേണം; അവൻ പാപയാഗത്തിന്നുള്ളതിനെ മുമ്പെ അർപ്പിച്ചു അതിന്റെ തല കഴുത്തിൽനിന്നു പിരിച്ചുപറിക്കേണം; എന്നാൽ രണ്ടായി പിളർക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","അവൻ പാപയാഗത്തിന്റെ രക്തം കുറെ യാഗപീഠത്തിന്റെ പാർശ്വത്തിൽ തളിക്കേണം; ശേഷം രക്തം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ പിഴിഞ്ഞുകളയേണം; ഇതു പാപയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","രണ്ടാമത്തേതിനെ അവൻ നിയമപ്രകാരം ഹോമയാഗമായി അർപ്പിക്കേണം; ഇങ്ങനെ പുരോഹിതൻ അവൻ ചെയ്ത പാപംനിമിത്തം അവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു അവനോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","രണ്ടു കുറുപ്രാവിന്നോ രണ്ടു പ്രാവിൻകുഞ്ഞിന്നോ അവന്നു വകയില്ലെങ്കിൽ പാപം ചെയ്തവൻ പാപയാഗത്തിന്നു ഒരിടങ്ങഴി നേരിയ മാവു വഴിപാടായി കൊണ്ടുവരേണം; അതു പാപയാഗം ആകകൊണ്ടു അതിന്മേൽ എണ്ണ ഒഴിക്കരുതു; കുന്തുരുക്കം ഇടുകയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","അവൻ അതു പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരേണം: പുരോഹിതൻ നിവേദ്യമായി അതിൽനിന്നു കൈ നിറച്ചെടുത്തു യാഗപീഠത്തിന്മേൽ യഹോവെക്കുള്ള ദഹനയാഗങ്ങളെപ്പോലെ ദഹിപ്പിക്കേണം; ഇതു പാപയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ഇങ്ങനെ പുരോഹിതൻ ആ വക കാര്യത്തിൽ അവൻ ചെയ്ത പാപംനിമിത്തം അവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു അവനോടു ക്ഷമിക്കും; ശേഷിപ്പുള്ളതു ഭോജനയാഗംപോലെ പുരോഹിതന്നു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","ആരെങ്കിലും യഹോവയുടെ വിശുദ്ധവസ്തുക്കളെ സംബന്ധിച്ചു അബദ്ധവശാൽ അതിക്രമം ചെയ്തു പിഴെച്ചു എങ്കിൽ അവൻ തന്റെ അകൃത്യത്തിന്നു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നീ മതിക്കുന്ന വിലെക്കുള്ളതായി ഊനമില്ലാത്ത ഒരു ആട്ടുകൊറ്റനെ അകൃത്യയാഗമായി യഹോവെക്കു കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","വിശുദ്ധവസ്തുക്കളെ സംബന്ധിച്ചു താൻ പിഴെച്ചതിന്നു പകരം മുതലും അതിനോടു അഞ്ചിലൊന്നു കൂട്ടിയും അവൻ പുരോഹിതന്നു കൊടുക്കേണം; പുരോഹിതൻ അകൃത്യയാഗത്തിന്നുള്ള ആട്ടുകൊറ്റനെക്കൊണ്ടു അവന്നു വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു അവനോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","ചെയ്യരുതെന്നു യഹോവ കല്പിച്ചിട്ടുള്ള വല്ലകാര്യത്തിലും ആരെങ്കിലും പിഴെച്ചിട്ടു അവൻ അറിയാതിരുന്നാലും കുറ്റക്കാരനാകുന്നു; അവൻ തന്റെ കുറ്റം വഹിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","അവൻ അകൃത്യയാഗത്തിന്നായി നിന്റെ മതിപ്പുപോലെ ഊനമില്ലാത്ത ഒരു ആട്ടുകൊറ്റനെ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരേണം; അവൻ അബദ്ധവശാൽ പിഴെച്ചതും അറിയാതിരുന്നതുമായ പിഴെക്കായി പുരോഹിതൻ അവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു അവനോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ഇതു അകൃത്യയാഗം; അവൻ യഹോവയോടു അകൃത്യം ചെയ്തുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","ആരെങ്കിലും പിഴെച്ചു യഹോവയോടു അതിക്രമം ചെയ്തു തന്റെ പക്കൽ ഏല്പിച്ച വസ്തുവിനെയോ പണയം വെച്ചതിനെയോ മോഷണകാര്യത്തെയോ സംബന്ധിച്ചു കൂട്ടുകാരനോടു ഭോഷ്കു പറക എങ്കിലും കൂട്ടുകാരനോടു വഞ്ചന ചെയ്ക എങ്കിലും ");
INSERT INTO mal2015_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","കണാതെപോയ വസ്തു കണ്ടിട്ടു അതിനെക്കുറിച്ചു ഭോഷ്കു പറഞ്ഞു മനുഷ്യൻ പിഴെക്കുന്ന ഈ വക വല്ല കാര്യത്തിലും കള്ളസ്സത്യം ചെയ്കയെങ്കിലും ചെയ്തിട്ടു ");
INSERT INTO mal2015_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","അവൻ പിഴെച്ചു കുറ്റക്കാരനായാൽ താൻ മോഷ്ടിച്ചതോ വഞ്ചിച്ചെടുത്തതോ തന്റെ പക്കൽ ഏല്പിച്ചതോ കാണാതെപോയിട്ടു താൻ കണ്ടതോ ");
INSERT INTO mal2015_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","താൻ കള്ളസ്സത്യം ചെയ്തു എടുത്തതോ ആയതൊക്കെയും മുതലോടു അഞ്ചിലൊന്നു കൂട്ടി പകരം കൊടുക്കേണം; അകൃത്യയാഗം കഴിക്കുന്ന നാളിൽ അവൻ അതു ഉടമസ്ഥന്നു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","അകൃത്യയാഗത്തിന്നായിട്ടു അവൻ നിന്റെ മതിപ്പുപോലെ ഊനമില്ലാത്ത ഒരു ആട്ടുകൊറ്റനെ യഹോവെക്കു അകൃത്യയാഗമായി പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","പുരോഹിതൻ യഹോവയുടെ സന്നിധിയിൽ അവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അവൻ അകൃത്യമായി ചെയ്തതൊക്കെയും അവനോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","നീ അഹരോനോടും പുത്രന്മാരോടും കല്പിക്കേണ്ടതു എന്തെന്നാൽ: ഹോമയാഗത്തിന്റെ പ്രമാണമാവിതു: ഹോമയാഗം രാത്രി മുഴുവനും ഉഷസ്സുവരെ യാഗപീഠത്തിന്മേലുള്ള വിറകിന്മേൽ ഇരിക്കയും യാഗപീഠത്തിലെ തീ അതിനാൽ കത്തിക്കൊണ്ടിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","പുരോഹിതൻ പഞ്ഞിനൂൽകൊണ്ടുള്ള അങ്കി ധരിച്ചു പഞ്ഞിനൂൽകൊണ്ടുള്ള കാൽ ചട്ടയാൽ തന്റെ നഗ്നത മറെച്ചുകൊണ്ടു യാഗപീഠത്തിന്മേൽ ഹോമയാഗം ദഹിച്ചുണ്ടായ വെണ്ണീർ എടുത്തു യാഗപീഠത്തിന്റെ ഒരു വശത്തു ഇടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","അവൻ വസ്ത്രം മാറി വേറെ വസ്ത്രം ധരിച്ചു പാളയത്തിന്നു പുറത്തു വെടിപ്പുള്ള ഒരു സ്ഥലത്തു വെണ്ണീർ കൊണ്ടുപോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","യാഗപീഠത്തിൽ തീ കെട്ടുപോകാതെ കത്തിക്കൊണ്ടിരിക്കേണം; പുരോഹിതൻ ഉഷസ്സുതോറും അതിന്മേൽ വിറകു കത്തിച്ചു ഹോമയാഗം അടുക്കി വെച്ചു അതിൻമീതെ സമാധാനയാഗങ്ങളുടെ മേദസ്സു ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","യാഗപീഠത്തിന്മേൽ തീ കെട്ടുപോകാതെ എപ്പോഴും കത്തിക്കൊണ്ടിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ഭോജനയാഗത്തിന്റെ പ്രമാണമാവിതു: അഹരോന്റെ പുത്രന്മാർ യഹോവയുടെ സന്നിധിയിൽ യാഗപീഠത്തിന്റെ മുമ്പിൽ അതു അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ഭോജനയാഗത്തിന്റെ നേരിയ മാവിൽനിന്നും എണ്ണയിൽനിന്നും കൈനിറച്ചും ഭോജനയാഗത്തിന്മേലുള്ള കുന്തുരുക്കം മുഴുവനും എടുത്തു നിവേദ്യമായി യാഗപീഠത്തിന്മേൽ യഹോവെക്കു സൗരഭ്യവാസനയായി ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","അതിന്റെ ശേഷിപ്പു അഹരോനും പുത്രന്മാരും തിന്നേണം; ഒരു വിശുദ്ധസ്ഥലത്തു വെച്ചു അതു പുളിപ്പില്ലാത്തതായി തിന്നേണം; സമാഗമനകൂടാരത്തിന്റെ പ്രാകാരത്തിൽവെച്ചു അതു തിന്നേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","അതു പുളിച്ച മാവു കൂട്ടി ചുടരുതു; എന്റെ ദഹനയാഗങ്ങളിൽനിന്നു അതു ഞാൻ അവരുടെ ഓഹരിയായി കൊടുത്തിരിക്കുന്നു; അതു പാപയാഗംപോലെയും അകൃത്യയാഗംപോലെയും അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","അഹരോന്റെ മക്കളിൽ ആണുങ്ങൾക്കു ഒക്കെയും അതു തിന്നാം; യഹോവയുടെ ദഹനയാഗങ്ങളിൽ അതു നിങ്ങൾക്കു തലമുറതലമുറയായി ശാശ്വതാവകാശം ആകുന്നു; അതിനെ തൊടുന്നവൻ എല്ലാം വിശുദ്ധനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","അഹരോന്നു അഭിഷേകം കഴിയുന്ന ദിവസം അവനും പുത്രന്മാരും യഹോവെക്കു കഴിക്കേണ്ടുന്ന വഴിപാടാവിതു: ഒരു ഇടങ്ങഴി നേരിയ മാവിൽ പാതി രാവിലേയും പാതി വൈകുന്നേരവും നിരന്തരഭോജനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","അതു എണ്ണ ചേർത്തു ചട്ടിയിൽ ചുടേണം; അതു കുതിർത്തു കൊണ്ടുവരേണം; ചുട്ട കഷണങ്ങൾ ഭോജനയാഗമായി യഹോവെക്കു സൗരഭ്യവാസനയായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","അവന്റെ പുത്രന്മാരിൽ അവന്നു പകരം അഭിഷേകം പ്രാപിക്കുന്ന പുരോഹിതനും അതു അർപ്പിക്കേണം; എന്നേക്കുമുള്ള ചട്ടമായി അതു മുഴുവനും യഹോവെക്കു ദഹിപ്പിക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","പുരോഹിതന്റെ ഭോജനയാഗം മുഴുവനും ദഹിപ്പിക്കേണം; അതു തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","നീ അഹരോനോടും പുത്രന്മാരോടും പറയേണ്ടതു എന്തെന്നാൽ: പാപയാഗത്തിന്റെ പ്രമാണമാവിതു: ഹോമയാഗമൃഗത്തെ അറുക്കുന്ന സ്ഥലത്തുവെച്ചു പാപയാഗമൃഗത്തെയും യഹോവയുടെ സന്നിധിയിൽ അറുക്കേണം; അതു അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","പാപത്തിന്നുവേണ്ടി അതു അർപ്പിക്കുന്ന പുരോഹിതൻ അതു തിന്നേണം; സമാഗമനകൂടാരത്തിന്റെ പ്രാകാരത്തിൽ ഒരു വിശുദ്ധസ്ഥലത്തുവെച്ചു അതു തിന്നേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","അതിന്റെ മാംസം തൊടുന്നവൻ എല്ലാം വിശുദ്ധനായിരിക്കേണം; അതിന്റെ രക്തം ഒരു വസ്ത്രത്തിൽ തെറിച്ചാൽ അതു വീണതു ഒരു വിശുദ്ധസ്ഥലത്തുവെച്ചു കഴുകേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","അതു വേവിച്ച മൺപാത്രം ഉടെച്ചുകളയേണം; ചെമ്പുകലത്തിൽ വേവിച്ചു എങ്കിൽ അതു തേച്ചു മഴക്കി വെള്ളംകൊണ്ടു കഴുകേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","പുരോഹിതകുലത്തിലെ ആണുങ്ങളൊക്കെയും അതു തിന്നേണം; അതു അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","എന്നാൽ വിശുദ്ധമന്ദിരത്തിൽ പ്രായശ്ചിത്തം കഴിപ്പാൻ സാമഗമനകൂടാരത്തിന്നകത്തു രക്തം കൊണ്ടുവരുന്ന പാപയാഗത്തെ തിന്നരുതു; അതു തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","അകൃത്യയാഗത്തിന്റെ പ്രമാണമാവിതു: അതു അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ഹോമയാഗമൃഗത്തെ അറുക്കുന്ന സ്ഥലത്തുവെച്ചു അകൃത്യയാഗമൃഗത്തെയും അറുക്കേണം; അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","അതിന്റെ സകലമേദസ്സും തടിച്ചവാലും കുടൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും മൂത്രപിണ്ഡം രണ്ടും ");
INSERT INTO mal2015_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","അവയുടെ മേൽ കടിപ്രദേശത്തുള്ള മേദസ്സും മൂത്രപിണ്ഡങ്ങളോടു കൂടെ കരളിന്മേലുള്ള വപയും എടുത്തു ");
INSERT INTO mal2015_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","പുരോഹിതൻ യാഗപീഠത്തിന്മേൽ യഹോവെക്കു ദഹനയാഗമായി ദഹിപ്പിക്കേണം; അതു അകൃത്യയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","പുരോഹിതകുലത്തിലെ ആണുങ്ങളൊക്കെയും അതു തിന്നേണം; ഒരു വിശുദ്ധസ്ഥലത്തുവെച്ചു അതു തിന്നേണം; അതു അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","പാപയാഗംപോലെ തന്നേ അകൃത്യയാഗവും ആകുന്നു; അവെക്കു പ്രമാണവും ഒന്നു തന്നേ; പ്രായശ്ചിത്തം കഴിക്കുന്ന പുരോഹിതന്നു അതു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","പുരോഹിതൻ ഒരുത്തന്റെ ഹോമയാഗം അർപ്പിക്കുമ്പോൾ അർപ്പിച്ച പുരോഹിതന്നു ഹോമയാഗമൃഗത്തിന്റെ തോൽ ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","അടുപ്പത്തുവെച്ചു ചുടുന്ന ഭോജനയാഗം ഒക്കെയും ഉരുളിയിലും ചട്ടിയിലും ഉണ്ടാക്കുന്നതു ഒക്കെയും അർപ്പിക്കുന്ന പുരോഹിതന്നു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","എണ്ണ ചേർത്തതോ ചേർക്കാത്തതോ ആയ സകലഭോജനയാഗവും അഹരോന്റെ സകലപുത്രന്മാർക്കും ഒരുപോലെ ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","യഹോവെക്കു അർപ്പിക്കുന്ന സമാധാനയാഗത്തിന്റെ പ്രമാണം ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","അതിനെ സ്തോത്രമായി അർപ്പിക്കുന്നു എങ്കിൽ അവൻ സ്തോത്രയാഗത്തോടുകൂടെ എണ്ണ ചേർത്ത പുളിപ്പില്ലാത്ത ദോശകളും എണ്ണ പുരട്ടിയ പുളിപ്പില്ലാത്ത വടകളും എണ്ണ ചേർത്തു കുതിർത്ത നേരിയ മാവുകൊണ്ടുണ്ടാക്കിയ ദോശകളും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","സ്തോത്രമായുള്ള സമാധാനയാഗത്തോടുകൂടെ പുളിച്ച മാവുകൊണ്ടുള്ള ദോശകളും ഭോജനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ആ എല്ലാവഴിപാടിലും അതതു വകയിൽ നിന്നു ഒരോന്നു യഹോവെക്കു നീരാജനാർപ്പണമായിട്ടു അർപ്പിക്കേണം; അതു സമാധാനയാഗത്തിന്റെ രക്തം തളിക്കുന്ന പുരോഹിതന്നു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","എന്നാൽ സ്തോത്രമായുള്ള സമാധാനയാഗത്തിന്റെ മാംസം, അർപ്പിക്കുന്ന ദിവസത്തിൽ തന്നേ തിന്നേണം; അതിൽ ഒട്ടും പ്രഭാതംവരെ ശേഷിപ്പിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","അർപ്പിക്കുന്ന യാഗം ഒരു നേർച്ചയോ സ്വമേധാദാനമോ ആകുന്നു എങ്കിൽ യാഗം അർപ്പിക്കുന്ന ദിവസത്തിൽ തന്നേ അതു തിന്നേണം; അതിൽ ശേഷിപ്പുള്ളതു പിറ്റെന്നാളും തിന്നാം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","യാഗമാംസത്തിൽ മൂന്നാം ദിവസംവരെ ശേഷിക്കുന്നതു തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","സമാധാനയാഗത്തിന്റെ മാംസത്തിൽ ഏതാനും മൂന്നാം ദിവസം തിന്നാൽ അതു പ്രസാദമായിരിക്കയില്ല; അർപ്പിക്കുന്നവന്നു കണക്കിടുകയുമില്ല; അതു അറെപ്പായിരിക്കും; അതു തിന്നുന്നവൻ കുറ്റം വഹിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","ശുദ്ധിയില്ലാത്ത വല്ലതിനെയും തൊട്ടുപോയ മാംസം തിന്നരുതു; അതു തീയിൽ ഇട്ടു ചുട്ടുകളയേണം; ശേഷം മാംസമോ ശുദ്ധിയുള്ളവന്നെല്ലാം തിന്നാം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","എന്നാൽ അശുദ്ധി തന്റെ മേൽ ഇരിക്കുമ്പോൾ ആരെങ്കിലും യഹോവെക്കുള്ള സമാധാനയാഗങ്ങളുടെ മാംസം തിന്നാൽ അവനെ അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","മനുഷ്യന്റെ അശുദ്ധിയെയോ അശുദ്ധമൃഗത്തെയോ ശുദ്ധിയില്ലാത്ത വല്ല അറെപ്പിനെയോ ഇങ്ങനെ ശുദ്ധിയില്ലാത്ത യാതൊന്നിനെയും ആരെങ്കിലും തൊട്ടിട്ടു യഹോവെക്കുള്ള സമാധാനയാഗങ്ങളുടെ മാംസം തിന്നാൽ അവനെ അവന്റെ ജനത്തിൽ നിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ചെമ്മരിയാട്ടിന്റെയോ കോലാട്ടിന്റെയോ കാളയുടെയോ മേദസ്സു നിങ്ങൾ അശേഷം തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","താനേ ചത്തതിന്റെ മേദസ്സും പറിച്ചുകീറിപ്പോയതിന്റെ മേദസ്സും മറ്റു എന്തിന്നെങ്കിലും കൊള്ളിക്കാം; തിന്നുക മാത്രം അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","യഹോവെക്കു ദഹനയാഗമായി അർപ്പിച്ച മൃഗത്തിന്റെ മേദസ്സു ആരെങ്കിലും തിന്നാൽ അവനെ അവന്റെ ജനത്തിൽ നിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","നിങ്ങളുടെ വാസസ്ഥലങ്ങളിൽ എങ്ങും യാതൊരു പക്ഷിയുടെയും മൃഗത്തിന്റെയും രക്തം നിങ്ങൾ ഭക്ഷിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","വല്ല രക്തവും ഭക്ഷിക്കുന്നവനെ എല്ലാം അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: യഹോവെക്കു സമാധാനയാഗം അർപ്പിക്കുന്നവൻ തന്റെ സമാധാനയാഗത്തിൽനിന്നു യഹോവെക്കു വഴിപാടു കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","സ്വന്തകയ്യാൽ അവൻ അതു യഹോവയുടെ ദഹനയാഗമായി കൊണ്ടുവരേണം; യഹോവയുടെ സന്നിധിയിൽ നീരാജനാർപ്പണമായി നീരാജനം ചെയ്യേണ്ടതിന്നു നെഞ്ചോടുകൂടെ മേദസ്സും കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","പുരോഹിതൻ മേദസ്സു യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കേണം; എന്നാൽ നെഞ്ചു അഹരോനും പുത്രന്മാർക്കും ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","നിങ്ങളുടെ സമാധാനയാഗങ്ങളിൽ വലത്തെ കൈക്കുറകു ഉദർച്ചാർപ്പണത്തിന്നായി നിങ്ങൾ പുരോഹിതന്റെ പക്കൽ കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","അഹരോന്റെ പുത്രന്മാരിൽ സമാധാനയാഗങ്ങളുടെ രക്തവും മേദസ്സും അർപ്പിക്കുന്നവന്നു തന്നേ വലത്തെ കൈക്കുറകു ഓഹരിയായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","യിസ്രായേൽമക്കളുടെ സമാധാനയാഗങ്ങളിൽനിന്നു നീരാജനത്തിന്റെ നെഞ്ചും ഉദർച്ചയുടെ കൈക്കുറകും ഞാൻ എടുത്തു പുരോഹിതനായ അഹരോന്നും പുത്രന്മാർക്കും യിസ്രായേൽമക്കളിൽനിന്നുള്ള ശാശ്വതാവകാശമായി കൊടുത്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ഇതു അഹരോനെയും പുത്രന്മാരെയും യഹോവെക്കു പുരോഹിതശുശ്രൂഷ ചെയ്‌വാൻ പ്രതിഷ്ഠിച്ച നാൾമുതൽ യഹോവയുടെ ദഹനയാഗങ്ങളിൽനിന്നു അഹരോന്നുള്ള ഓഹരിയും അവന്റെ പുത്രന്മാർക്കുള്ള ഓഹരിയും ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","യിസ്രായേൽമക്കൾ അതു അവർക്കു കൊടുക്കേണമെന്നു താൻ അവരെ അഭിഷേകം ചെയ്തനാളിൽ യഹോവ കല്പിച്ചു; അതു അവർക്കു തലമുറതലമുറയായി ശാശ്വതാവകാശം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ദഹനയാഗം, ഭോജനയാഗം, പാപയാഗം, അകൃത്യയാഗം, കരപൂരണയാഗം, സമാധാനയാഗം എന്നിവയെ സംബന്ധിച്ചുള്ള പ്രമാണം ഇതു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","യഹോവെക്കു തങ്ങളുടെ വഴിപാടുകൾ കഴിപ്പാൻ അവൻ യിസ്രായേൽമക്കളോടു സീനായിമരുഭൂമിയിൽവെച്ചു അരുളിച്ചെയ്ത നാളിൽ യഹോവ മോശെയോടു സീനായിപർവ്വതത്തിൽവെച്ചു ഇവ കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","യഹോവ പിന്നെയും മോശെയോടു: നീ അഹരോനെയും അവനോടുകൂടെ ");
INSERT INTO mal2015_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","അവന്റെ പുത്രന്മാരെയും വസ്ത്രം, അഭിഷേകതൈലം, പാപയാഗത്തിന്നുള്ള കാള, രണ്ടു ആട്ടുകൊറ്റന്മാർ, കൊട്ടയിൽ പുളിപ്പില്ലാത്ത അപ്പം എന്നിവയുമായി കൊണ്ടുവരികയും ");
INSERT INTO mal2015_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","സഭയെ മുഴുവനും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ കൂട്ടുകയും ചെയ്ക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","യഹോവ തന്നോടു കല്പിച്ചതുപോലെ മോശെ ചെയ്തു; സഭ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ വന്നുകൂടി. ");
INSERT INTO mal2015_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","മോശെ സഭയോടു: യഹോവ കല്പിച്ച കാര്യം ഇതാകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","മോശെ അഹരോനെയും പുത്രന്മാരെയും അടുക്കൽ വരുത്തി അവരെ വെള്ളംകൊണ്ടു കഴുകി. ");
INSERT INTO mal2015_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","അവനെ ഉള്ളങ്കി ഇടുവിച്ചു നടുക്കെട്ടു കെട്ടിച്ചു അങ്കി ധരിപ്പിച്ചു ഏഫോദ് ഇടുവിച്ചു ഏഫോദിന്റെ ചിത്രപ്പണിയായ നടുക്കെട്ടു കെട്ടിച്ചു അതിനാൽ അതു മുറുക്കി. ");
INSERT INTO mal2015_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","അവനെ പതക്കം ധരിപ്പിച്ചു; പതക്കത്തിൽ ഊറീമും തുമ്മീമും വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","അവന്റെ തലയിൽ മുടി വെച്ചു; മുടിയുടെ മേൽ മുൻവശത്തു വിശുദ്ധകിരീടമായ പൊൻപട്ടം വെച്ചു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","മോശെ അഭിഷേകതൈലം എടുത്തു കൂടാരവും അതിലുള്ളതൊക്കെയും അഭിഷേകം ചെയ്തു ശുദ്ധീകരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","അതിൽ കുറെ അവൻ യാഗപീഠത്തിന്മേൽ ഏഴു പ്രാവശ്യം തളിച്ചു യാഗപീഠവും അതിന്റെ ഉപകരണങ്ങളൊക്കെയും തൊട്ടിയും അതിന്റെ കാലും അഭിഷേകം ചെയ്തു ശുദ്ധീകരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","അവൻ അഹരോന്റെ തലയിൽ അഭിഷേകതൈലം ഒഴിച്ചു അവനെ അഭിഷേകം ചെയ്തു ശുദ്ധീകരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","മോശെ അഹരോന്റെ പുത്രന്മാരെ വരുത്തി, അങ്കി ധരിപ്പിച്ചു നടുക്കെട്ടു കെട്ടിച്ചു തലപ്പാവും ഇടുവിച്ചു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","അവൻ പാപയാഗത്തിന്നുള്ള കാളയെ കൊണ്ടുവന്നു: പാപയാഗത്തിന്നുള്ള കാളയുടെ തലയിൽ അഹരോനും പുത്രന്മാരും കൈ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","അവൻ അതിനെ അറുത്തു; മോശെ അതിന്റെ രക്തം എടുത്തു വിരൽകൊണ്ടു യാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ ചുറ്റും പുരട്ടി യാഗപീഠം ശുദ്ധീകരിച്ചു; ശേഷം രക്തം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിച്ചു, അതിന്നുവേണ്ടി പ്രാശ്ചിത്തം കഴിച്ചു അതിനെ ശുദ്ധീകരിച്ചു; ");
INSERT INTO mal2015_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","കുടലിന്മേലുള്ള സകലമേദസ്സും കരളിന്മേലുള്ള വപയും മൂത്രപിണ്ഡം രണ്ടും അവയുടെ മേദസ്സും മോശെ എടുത്തു യാഗപീഠത്തിന്മേൽ ദഹിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","എന്നാൽ കാളയെയും അതിന്റെ തോൽ, മാംസം, ചാണകം എന്നിവയെയും അവൻ പാളയത്തിന്നു പുറത്തു തീയിൽ ഇട്ടു ചുട്ടുകളഞ്ഞു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","അവൻ ഹോമയാഗത്തിന്നുള്ള ആട്ടുകൊറ്റനെയും കൊണ്ടുവന്നു: അഹരോനും പുത്രന്മാരും ആട്ടുകൊറ്റന്റെ തലയിൽ കൈ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","അവൻ അതിനെ അറുത്തു; മോശെ അതിന്റെ രക്തം യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ആട്ടുകൊറ്റനെ ഖണ്ഡംഖണ്ഡമായി ഖണ്ഡിച്ചു; മോശെ തലയും ഖണ്ഡങ്ങളും മേദസ്സും ദഹിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","അവൻ അതിന്റെ കുടലും കാലും വെള്ളംകൊണ്ടു കഴുകി; മോശെ ആട്ടുകൊറ്റനെ മുഴുവനും യാഗപീഠത്തിന്മേൽ ദഹിപ്പിച്ചു; ഇതു സൗരഭ്യവാസനയായ ഹോമയാഗമായി യഹോവെക്കുള്ള ദഹനയാഗം; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","അവൻ കരപൂരണത്തിന്നുള്ള ആട്ടുകൊറ്റനായ മറ്റെ ആട്ടുകൊറ്റനെയും കൊണ്ടുവന്നു; അഹരോനും പുത്രന്മാരും ആട്ടുകൊറ്റന്റെ തലയിൽ കൈവെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","അവൻ അതിനെ അറുത്തു; മോശെ അതിന്റെ രക്തം കുറെ എടുത്തു അഹരോന്റെ വലത്തെ കാതിന്മേലും വലത്തെ കയ്യുടെ പെരുവിരലിന്മേലും വലത്തെ കാലിന്റെ പെരുവിരലിന്മേലും പുരട്ടി. ");
INSERT INTO mal2015_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","അവൻ അഹരോന്റെ പുത്രന്മാരെയും വരുത്തി; മോശെ രക്തം കുറെ അവരുടെ വലത്തെ കാതിന്മേലും വലത്തെ കയ്യുടെ പെരുവിരലിന്മേലും വലത്തെ കാലിന്റെ പെരുവിരലിന്മേലും പുരട്ടി; ശേഷം രക്തം മോശെ യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","മേദസ്സും തടിച്ചവാലും കുടലിന്മേലുള്ള സകലമേദസ്സും കരളിന്മേലുള്ള വപയും മൂത്രപിണ്ഡം രണ്ടും അവയുടെ മേദസ്സും വലത്തെ കൈക്കുറകും അവൻ എടുത്തു, ");
INSERT INTO mal2015_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","യഹോവയുടെ സന്നിധിയിലുള്ള പുളിപ്പില്ലാത്ത അപ്പം ഇരിക്കുന്ന കൊട്ടയിൽ നിന്നു പുളിപ്പില്ലാത്ത ഒരു അപ്പവും എണ്ണയപ്പമായ ഒരു ദോശയും ഒരു വടയും എടുത്തു മേദസ്സിന്മേലും കൈക്കുറകിന്മേലും വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","അവയൊക്കെയും അഹരോന്റെ കയ്യിലും അവന്റെ പുത്രന്മാരുടെ കയ്യിലും വെച്ചു യഹോവെക്കു നീരാജനം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","പിന്നെ മോശെ അവയെ അവരുടെ കയ്യിൽനിന്നു എടുത്തു യാഗപീഠത്തിന്മേൽ യാഗത്തിൻമീതെ ദഹിപ്പിച്ചു. ഇതു സൗരഭ്യവാസനയായ കരപൂരണയാഗം, യഹോവെക്കുള്ള ദഹനയാഗം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","മോശെ അതിന്റെ നെഞ്ചു എടുത്തു യഹോവയുടെ സന്നിധിയിൽ നീരാജനാർപ്പണമായി നീരാജനം ചെയ്തു; അതു കരപൂരണത്തിന്റെ ആട്ടുകൊറ്റനിൽ മോശെക്കുള്ള ഓഹരി ആയിരുന്നു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","മോശെ അഭിഷേകതൈലവും യാഗപീഠത്തിന്മേലുള്ള രക്തവും കുറേശ്ശ എടുത്തു അഹരോന്റെ മേലും അവന്റെ വസ്ത്രത്തിന്മേലും അവന്റെ പുത്രന്മാരുടെ മേലും പുത്രന്മാരുടെ വസ്ത്രത്തിന്മേലും തളിച്ചു; അഹരോനെയും അവന്റെ വസ്ത്രത്തെയും അവന്റെ പുത്രന്മാരെയും പുത്രന്മാരുടെ വസ്ത്രങ്ങളെയും ശുദ്ധീകരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","അഹരോനോടും അവന്റെ പുത്രന്മാരോടും മോശെ പറഞ്ഞതു എന്തെന്നാൽ: മാംസം നിങ്ങൾ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽവെച്ചു പാകംചെയ്തു, അഹരോനും പുത്രന്മാരും അതു തിന്നേണമെന്നു എനിക്കു കല്പനയുണ്ടായതുപോലെ അവിടെവെച്ചു അതും കരപൂരണത്തിന്റെ കൊട്ടയിൽ ഇരിക്കുന്ന അപ്പവും തിന്നുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","മാംസത്തിലും അപ്പത്തിലും ശേഷിക്കുന്നതു നിങ്ങൾ തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","നിങ്ങളുടെ കരപൂരണദിവസങ്ങൾ തികയുവോളം നിങ്ങൾ ഏഴു ദിവസത്തേക്കു സമാഗമനകൂടാരത്തിന്റെ വാതിൽ വിട്ടു പുറത്തു പോകരുതു; ഏഴു ദിവസം അവൻ നിങ്ങൾക്കു കരപൂരണം ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","നിങ്ങൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിപ്പാൻ ഇന്നു ചെയ്തതുപോലെ ഇനിയും ചെയ്യേണ്ടതിന്നു യഹോവ കല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ആകയാൽ നിങ്ങൾ മരിക്കാതിരിപ്പാൻ ഏഴു ദിവസം രാവും പകലും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ പാർത്തു യഹോവയുടെ കല്പന അനുസരിക്കേണം; ഇങ്ങനെ എന്നോടു കല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","യഹോവ മോശെ മുഖാന്തരം കല്പിച്ച സകലകാര്യങ്ങളെയും അഹരോനും അവന്റെ പുത്രന്മാരും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","എട്ടാം ദിവസം മോശെ അഹരോനെയും പുത്രന്മാരെയും യിസ്രായേൽമൂപ്പന്മാരെയും വിളിച്ചു, ");
INSERT INTO mal2015_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","അഹരോനോടു പറഞ്ഞതു എന്തെന്നാൽ: നീ പാപയാഗത്തിന്നായി ഊനമില്ലാത്ത ഒരു കാളക്കുട്ടിയെയും ഹോമയാഗത്തിന്നായി ഊനമില്ലാത്ത ഒരു ആട്ടുകൊറ്റനെയും എടുത്തു യഹോവയുടെ സന്നിധിയിൽ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","എന്നാൽ യിസ്രായേൽമക്കളോടു നീ പറയേണ്ടതു എന്തെന്നാൽ: യഹോവയുടെ സന്നിധിയിൽ യാഗം കഴിക്കേണ്ടതിന്നു നിങ്ങൾ പാപയാഗത്തിന്നായി ഊനമില്ലാത്ത ഒരു കോലാട്ടിനെയും ഹോമയാഗത്തിന്നായി ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഒരു കാളക്കുട്ടിയെയും ഒരു വയസ്സുപ്രായമുള്ള ഊനമില്ലാത്ത ഒരു ചെമ്മരിയാട്ടിൻകുട്ടിയെയും ");
INSERT INTO mal2015_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","സമാധാനയാഗത്തിന്നായി ഒരു കാളയെയും ഒരു ചെമ്മരിയാട്ടുകൊറ്റനെയും എണ്ണ ചേർത്ത ഭോജനയാഗത്തെയും എടുപ്പിൻ; യഹോവ ഇന്നു നിങ്ങൾക്കു പ്രത്യക്ഷനാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","മോശെ കല്പിച്ചവയെ അവർ സമാഗമനകൂടാരത്തിന്നു മുമ്പിൽ കൊണ്ടു വന്നു; സഭ മുഴുവനും അടുത്തുവന്നു യഹോവയുടെ സന്നിധിയിൽ നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","അപ്പോൾ മോശെ: നിങ്ങൾ ചെയ്യേണമെന്നു യഹോവ കല്പിച്ച കാര്യം ഇതു ആകുന്നു; യഹോവയുടെ തേജസ്സു നിങ്ങൾക്കു പ്രത്യക്ഷമാകും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","അഹരോനോടു മോശെ: നീ യാഗപീഠത്തിന്റെ അടുക്കൽ ചെന്നു യഹോവ കല്പിച്ചതുപോലെ നിന്റെ പാപയാഗവും ഹോമയാഗവും അർപ്പിച്ചു നിനക്കും ജനത്തിന്നും വേണ്ടി പ്രായശ്ചിത്തം കഴിച്ചു ജനത്തിന്റെ വഴിപാടു അർപ്പിച്ചു അവർക്കായിട്ടും പ്രായശ്ചിത്തം കഴിക്ക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","അങ്ങനെ അഹരോൻ യാഗപീഠത്തിന്റെ അടുക്കൽ ചെന്നു തനിക്കുവേണ്ടി പാപയാഗത്തിന്നുള്ള കാളക്കുട്ടിയെ അറുത്തു; ");
INSERT INTO mal2015_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","അഹരോന്റെ പുത്രന്മാർ അതിന്റെ രക്തം അവന്റെ അടുക്കൽ കൊണ്ടുവന്നു; അവൻ രക്തത്തിൽ വിരൽ മുക്കി യാഗപീഠത്തിന്റെ കൊമ്പുകളിൽ പുരട്ടി ശേഷം രക്തം യാഗപീഠത്തിന്റെ ചുവട്ടിൽ ഒഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","പാപയാഗത്തിന്റെ മേദസ്സും മൂത്രപിണ്ഡങ്ങളും കരളിന്മേലുള്ള വപയും അവൻ യാഗപീഠത്തിന്മേൽ ദഹിപ്പിച്ചു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെതന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","അതിന്റെ മാംസവും തോലും അവൻ പാളയത്തിന്നു പുറത്തു തീയിൽ ഇട്ടു ചുട്ടുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","അവൻ ഹോമയാഗത്തെയും അറുത്തു; അഹരോന്റെ പുത്രന്മാർ അതിന്റെ രക്തം അവന്റെ അടുക്കൽ കൊണ്ടുവന്നു; അവൻ അതു യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","അവർ ഖണ്ഡംഖണ്ഡമായി ഹോമയാഗവും അതിന്റെ തലയും അവന്റെ അടുക്കൽ കൊണ്ടുവന്നു അവൻ അവയെ യാഗപീഠത്തിന്മേൽ ദഹിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","അവൻ അതിന്റെ കുടലും കാലും കഴുകി യാഗപീഠത്തിന്മേൽ ഹോമയാഗത്തിൻ മീതെ ദഹിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","അവൻ ജനത്തിന്റെ വഴിപാടു കൊണ്ടുവന്നു: ജനത്തിന്നുവേണ്ടി പാപയാഗത്തിന്നുള്ള കോലാടിനെ പിടിച്ചു അറുത്തു മുമ്പിലത്തേതിനെപ്പോലെ പാപയാഗമായി അർപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","അവൻ ഹോമയാഗംകൊണ്ടു വന്നു അതും നിയമപ്രകാരം അർപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","അവൻ ഭോജനയാഗം കൊണ്ടുവന്നു അതിൽ നിന്നു കൈനിറെച്ചു എടുത്തു കാലത്തെ ഹോമയാഗത്തിന്നു പുറമെ യാഗപീഠത്തിന്മേൽ ദഹിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","പിന്നെ അവൻ ജനത്തിന്നുവേണ്ടി സമാധാനയാഗത്തിന്നുള്ള കാളയെയും ചെമ്മരിയാട്ടുകൊറ്റനെയും അറുത്തു; അഹരോന്റെ പുത്രന്മാർ അതിന്റെ രക്തം അവന്റെ അടുക്കൽ കൊണ്ടുവന്നു; അവൻ അതു യാഗപീഠത്തിന്മേൽ ചുറ്റും തളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","കാളയുടെയും ആട്ടുകൊറ്റന്റെയും മേദസ്സും തടിച്ചവാലും കുടൽ പൊതിഞ്ഞിരിക്കുന്ന മേദസ്സും മൂത്രപിണ്ഡങ്ങളും കരളിന്മേലുള്ള വപയും കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","അവർ മേദസ്സു നെഞ്ചുകണ്ടങ്ങളുടെമേൽ വെച്ചു; അവൻ മേദസ്സു യാഗപീഠത്തിന്മേൽ ദഹിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","എന്നാൽ നെഞ്ചുകണ്ടങ്ങളും വലത്തെ കൈക്കുറകും മോശെ കല്പിച്ചതുപോലെ അഹരോൻ യഹോവയുടെ സന്നിധിയിൽ നീരാജാനാർപ്പണമായി നീരാജനം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","പിന്നെ അഹരോൻ ജനത്തിന്നു നേരെ കൈ ഉയർത്തി അവരെ ആശീർവ്വദിച്ചു; പാപയാഗവും ഹോമയാഗവും സമാധാനയാഗവും അർപ്പിച്ചിട്ടു അവൻ ഇറങ്ങിപ്പോന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","മോശെയും അഹരോനും സമാഗമനകൂടാരത്തിൽ കടന്നിട്ടു പുറത്തുവന്നു ജനത്തെ ആശീർവ്വദിച്ചു; അപ്പോൾ യഹോവയുടെ തേജസ്സു സകല ജനത്തിന്നും പ്രത്യക്ഷമായി. ");
INSERT INTO mal2015_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","യഹോവയുടെ സന്നിധിയിൽനിന്നു തീ പുറപ്പെട്ടു യാഗപീഠത്തിന്മേൽ ഉള്ള ഹോമയാഗവും മേദസ്സും ദഹിപ്പിച്ചു; ജനമെല്ലാം അതു കണ്ടപ്പോൾ ആർത്തു സാഷ്ടാംഗം വീണു. ");
INSERT INTO mal2015_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","അനന്തരം അഹരോന്റെ പുത്രന്മാരായ നാദാബും അബീഹൂവും ഓരോ ധൂപകലശം എടുത്തു അതിൽ തീ ഇട്ടു അതിന്മേൽ ധൂപ വർഗ്ഗവും ഇട്ടു, അങ്ങനെ തങ്ങളോടു കല്പിച്ചതല്ലാത്ത അന്യാഗ്നി യഹോവയുടെ സന്നിധിയിൽ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ഉടനെ യഹോവയുടെ സന്നിധിയിൽനിന്നു തീ പുറപ്പെട്ടു അവരെ ദഹിപ്പിച്ചുകളഞ്ഞു; അവർ യഹോവയുടെ സന്നിധിയിൽ മരിച്ചുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","അപ്പോൾ മോശെ: എന്നോടു അടുക്കുന്നവരിൽ ഞാൻ ശുദ്ധീകരിക്കപ്പെടും; സർവ്വജനത്തിന്റെയും മുമ്പാകെ ഞാൻ മഹത്വപ്പെടും എന്നു യഹോവ അരുളിച്ചെയ്തതു ഇതു തന്നേ എന്നു അഹരോനോടു പറഞ്ഞു. അഹരോനോ മിണ്ടാതിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","പിന്നെ മോശെ അഹരോന്റെ ഇളയപ്പൻ ഉസ്സീയേലിന്റെ പുത്രന്മാരായ മീശായേലിനെയും എത്സാഫാനെയും വിളിച്ചു അവരോടു: നിങ്ങൾ അടുത്തുചെന്നു നിങ്ങളുടെ സഹോദരന്മാരെ വിശുദ്ധമന്ദിരത്തിന്റെ മുമ്പിൽനിന്നു പാളയത്തിന്നു പുറത്തു കൊണ്ടുപോകുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","മോശെ പറഞ്ഞതുപോലെ അവർ അടുത്തുചെന്നു അവരെ അവരുടെ അങ്കികളോടുകൂടെ പാളയത്തിന്നു പുറത്തു കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","പിന്നെ മോശെ അഹരോനോടും അവന്റെ പുത്രന്മാരായ എലെയാസാരോടും ഈഥാമാരോടും നിങ്ങൾ മരിക്കാതെയും സർവ്വസഭയുടെയും മേൽ കോപം വരാതെയും ഇരിപ്പാൻ നിങ്ങളുടെ തലമുടി പിച്ചിപ്പറിക്കരുതു; നിങ്ങളുടെ വസ്ത്രം കീറുകയും അരുതു; നിങ്ങളുടെ സഹോദരന്മാരായ യിസ്രായേൽഗൃഹം ഒക്കെയും യഹോവ ദഹിപ്പിച്ച ദഹനംനിമിത്തം കരയട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","നിങ്ങളോ മരിച്ചുപോകാതിരിക്കേണ്ടതിന്നു സമാഗമനകൂടാരത്തിന്റെ വാതിൽ വിട്ടു പുറത്തു പോകരുതു; യഹോവയുടെ അഭിഷേകതൈലം നിങ്ങളുടെ മേൽ ഇരിക്കുന്നുവല്ലോ എന്നു പറഞ്ഞു. അവർ മോശെയുടെ വചനംപോലെ തന്നേ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","യഹോവ അഹരോനോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","നീയും നിന്റെ പുത്രന്മാരും മരിച്ചു പോകാതിരിക്കേണ്ടതിന്നു സമാഗമനകൂടാരത്തിൽ കടക്കുമ്പോൾ വീഞ്ഞും മദ്യവും കുടിക്കരുതു. ഇതു നിങ്ങൾക്കു തലമുറതലമുറയായി എന്നേക്കുമുള്ള ചട്ടമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ശുദ്ധവും അശുദ്ധവും മലിനവും നിർമ്മലവും തമ്മിൽ നിങ്ങൾ വകതിരിക്കേണ്ടതിന്നും ");
INSERT INTO mal2015_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","യഹോവ മോശെമുഖാന്തരം യിസ്രായേൽമക്കളോടു കല്പിച്ച സകലപ്രമാണങ്ങളും അവരെ ഉപദേശിക്കേണ്ടതിന്നും തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","അഹരോനോടും അവന്റെ ശേഷിപ്പുള്ള പുത്രന്മാരായ എലെയാസാരോടും ഈഥാമാരോടും മോശെ പറഞ്ഞതെന്തെന്നാൽ: യഹോവയുടെ ദഹനയാഗങ്ങളിൽ ശേഷിപ്പുള്ള ഭോജനയാഗം നിങ്ങൾ എടുത്തു യാഗപീഠത്തിന്റെ അടുക്കൽ വെച്ചു പുളിപ്പില്ലാത്തതായി ഭക്ഷിപ്പിൻ; അതു അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","അതു ഒരു വിശുദ്ധസ്ഥലത്തു വെച്ചു ഭക്ഷിക്കേണം; യഹോവയുടെ ദഹനയാഗങ്ങളിൽ അതു നിനക്കുള്ള അവകാശവും നിന്റെ പുത്രന്മാർക്കുള്ള അവകാശവും ആകുന്നു; ഇങ്ങനെ എന്നോടു കല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","നീരാജനത്തിന്റെ നെഞ്ചും ഉദർച്ചയുടെ കൈക്കുറകും നീയും നിന്റെ പുത്രന്മാരും പുത്രിമാരും വെടിപ്പുള്ളോരു സ്ഥലത്തു വെച്ചു തിന്നേണം; യിസ്രായേൽമക്കളുടെ സമാധാനയാഗങ്ങളിൽ അവ നിനക്കുള്ള അവകാശവും നിന്റെ മക്കൾക്കുള്ള അവകാശവുമായി നല്കിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","മേദസ്സിന്റെ ദഹനയാഗങ്ങളോടുകൂടെ അവർ യഹോവയുടെ സന്നിധിയിൽ നീരാജനം ചെയ്യേണ്ടതിന്നു ഉദർച്ചയുടെ കൈക്കുറകും നീരാജനത്തിന്റെ നെഞ്ചും കൊണ്ടു വരേണം; അതു യഹോവ കല്പിച്ചതുപോലെ ശാശ്വതാവകാശമായി നിനക്കും നിന്റെ മക്കൾക്കും ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","പിന്നെ പാപയാഗമായ കോലാടിനെക്കുറിച്ചു മോശെ താൽപര്യമായി അന്വേഷിച്ചു; എന്നാൽ അതു ചുട്ടുകളഞ്ഞിരുന്നു; അപ്പോൾ അവൻ അഹരോന്റെ ശേഷിപ്പുള്ള പുത്രന്മാരായ എലെയാസാരോടും ഈഥാമാരോടും കോപിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","പാപയാഗം അതിവിശുദ്ധവും സഭയുടെ അകൃത്യം നീക്കിക്കളവാനും അവർക്കുവേണ്ടി യഹോവയുടെ സന്നിധിയിൽ പ്രായശ്ചിത്തം കഴിപ്പാനും നിങ്ങൾക്കു തന്നതുമായിരിക്കെ നിങ്ങൾ അതു ഒരു വിശുദ്ധ സ്ഥലത്തുവെച്ചു ഭക്ഷിക്കാഞ്ഞതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","അതിന്റെ രക്തം വിശുദ്ധമന്ദിരത്തിന്നകത്തു കൊണ്ടുവന്നില്ലല്ലോ; ഞാൻ ആജ്ഞാപിച്ചതുപോലെ നിങ്ങൾ അതു ഒരു വിശുദ്ധസ്ഥലത്തു വെച്ചു ഭക്ഷിക്കേണ്ടതായിരുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","അപ്പോൾ അഹരോൻ മോശെയോടു: ഇന്നു അവർ തങ്ങളുടെ പാപയാഗവും ഹോമയാഗവും യഹോവയുടെ സന്നിധിയിൽ അർപ്പിച്ചു; എനിക്കു ഇങ്ങനെ ഭവിച്ചുവല്ലോ. ഇന്നു ഞാൻ പാപയാഗം ഭക്ഷിച്ചു എങ്കിൽ അതു യഹോവെക്കു പ്രസാദമായിരിക്കുമോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ഇതു കേട്ടപ്പോൾ മോശെക്കു ബോധിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","നിങ്ങൾ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ഭൂമിയിലുള്ള സകലമൃഗങ്ങളിലും നിങ്ങൾക്കു തിന്നാകുന്ന മൃഗങ്ങൾ ഇവ: ");
INSERT INTO mal2015_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","മൃഗങ്ങളിൽ കുളമ്പു പിളർന്നിരിക്കുന്നതും കുളമ്പു രണ്ടായി പിരിഞ്ഞിരിക്കുന്നതും അയവിറക്കുന്നതുമായതൊക്കെയും നിങ്ങൾക്കു തിന്നാം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","എന്നാൽ അയവിറക്കുന്നവയിലും കുളമ്പു പിളർന്നിരിക്കുന്നവയിലും നിങ്ങൾ തിന്നരുതാത്തവ ഇവ: ഒട്ടകം; അയവിറക്കുന്നു എങ്കിലും കുളമ്പു പിളർന്നതല്ലായ്കകൊണ്ടു അതു നിങ്ങൾക്കു അശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","കുഴിമുയൽ; അയവിറക്കുന്നു എങ്കിലും കുളമ്പു പിളർന്നതല്ലായ്കയാൽ അതു നിങ്ങൾക്കു അശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","മുയൽ; അയവിറക്കുന്നു എങ്കിലും കുളമ്പു പിളന്നതല്ലായ്കയാൽ അതു നിങ്ങൾക്കു അശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","പന്നി; കുളമ്പു പിളർന്നതായി കുളമ്പു രണ്ടായി പിരിഞ്ഞിരിക്കുന്നതു തന്നേ എങ്കിലും അയവിറക്കുന്നതല്ലായ്കയാൽ അതു നിങ്ങൾക്കു അശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ഇവയുടെ മാംസം നിങ്ങൾ തിന്നരുതു; പിണം തൊടുകയും അരുതു; ഇവ നിങ്ങൾക്കു അശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","വെള്ളത്തിലുള്ള എല്ലാറ്റിലുംവെച്ചു നിങ്ങൾക്കു തിന്നാകുന്നവ ഇവ: കടലുകളിലും നദികളിലും ഉള്ള വെള്ളത്തിൽ ചിറകും ചെതുമ്പലും ഉള്ളവ ഒക്കെയും നിങ്ങൾക്കു തിന്നാം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","എന്നാൽ കടലുകളിലും നദികളിലും ഉള്ള വെള്ളത്തിൽ ചലനം ചെയ്യുന്ന എല്ലാറ്റിലും വെള്ളത്തിലുള്ള സകലജന്തുക്കളിലും ചിറകും ചെതുമ്പലുമില്ലാത്തതു ഒക്കെയും നിങ്ങൾക്കു അറെപ്പായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","അവ നിങ്ങൾക്കു അറെപ്പായി തന്നേ ഇരിക്കേണം. അവയുടെ മാംസം തിന്നരുതു; അവയുടെ പിണം നിങ്ങൾക്കു അറെപ്പായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ചിറകും ചെതുമ്പലും ഇല്ലാതെ വെള്ളത്തിൽ ഉള്ളതൊക്കെയും നിങ്ങൾക്കു അറെപ്പു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","പക്ഷികളിൽ നിങ്ങൾക്കു അറെപ്പായിരിക്കേണ്ടുന്നവ ഇവ: അവയെ തിന്നരുതു; അവ അറെപ്പു ആകുന്നു: കഴുകൻ, ചെമ്പരുന്തു, ");
INSERT INTO mal2015_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","കടൽറാഞ്ചൻ, ഗൃദ്ധ്രം, അതതു വിധം പരുന്തു, ");
INSERT INTO mal2015_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","അതതു വിധം കാക്ക, ഒട്ടകപ്പക്ഷി, ");
INSERT INTO mal2015_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","പുള്ളു, കടൽകാക്ക, അതതു വിധം പ്രാപ്പിടിയൻ, ");
INSERT INTO mal2015_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","നത്തു, നീർക്കാക്ക, കൂമൻ, മൂങ്ങ, ");
INSERT INTO mal2015_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","വേഴാമ്പൽ, കുടുമ്മച്ചാത്തൻ, പെരിഞാറ, ");
INSERT INTO mal2015_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","അതതതു വിധം കൊക്കു, കുളക്കോഴി, നരിച്ചീർ എന്നിവയും ");
INSERT INTO mal2015_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","ചിറകുള്ള ഇഴജാതിയിൽ നാലുകാൽകൊണ്ടു നടക്കുന്നതു ഒക്കെയും നിങ്ങൾക്കു അറെപ്പായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","എങ്കിലും ചിറകുള്ള ഇഴജാതിയിൽ നാലുകാൽ കൊണ്ടു നടക്കുന്ന എല്ലാറ്റിലും നിലത്തു കുതിക്കേണ്ടതിന്നു കാലിന്മേൽ തുട ഉള്ളവയെ നിങ്ങൾക്കു തിന്നാം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ഇവയിൽ അതതു വിധം വെട്ടുക്കിളി, അതതു വിധം വിട്ടിൽ, അതതു വിധം ചീവീടു, അതതു വിധം തുള്ളൻ എന്നിവയെ നിങ്ങൾക്കു തിന്നാം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ചിറകും നാലുകാലുമുള്ള ശേഷം ഇഴജാതി ഒക്കെയും നിങ്ങൾക്കു അറെപ്പായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","അവയാൽ നിങ്ങൾ അശുദ്ധരാകും: അവയുടെ പിണം തൊടുന്നവനെല്ലാം സന്ധ്യവരെ അശുദ്ധൻ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","അവയുടെ പിണം വഹിക്കുന്നവനെല്ലാം വസ്ത്രം അലക്കി സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","കുളമ്പു പിളർന്നതെങ്കിലും കുളമ്പു രണ്ടായി പിരിയാതെയും അയവിറക്കാതെയും ഇരിക്കുന്ന സകലമൃഗവും നിങ്ങൾക്കു അശുദ്ധം; അവയെ തൊടുന്നവനെല്ലാം അശുദ്ധൻ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","നാലുകാൽകൊണ്ടു നടക്കുന്ന സകലമൃഗങ്ങളിലും ഉള്ളങ്കാൽ പതിച്ചു നടക്കുന്നവ ഒക്കെയും നിങ്ങൾക്കു അശുദ്ധം; അവയുടെ പിണം തൊടുന്നവനെല്ലാം സന്ധ്യവരെ അശുദ്ധൻ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","അവയുടെ പിണം വഹിക്കുന്നവൻ വസ്ത്രം അലക്കി സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം; അവ നിങ്ങൾക്കു അശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","നിലത്തു ഇഴയുന്ന ഇഴജാതിയിൽ നിങ്ങൾക്കു അശുദ്ധമായവ ഇവ: ");
INSERT INTO mal2015_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","പെരിച്ചാഴി, എലി, അതതു വിധം ഉടുമ്പു, അളുങ്കു, ഓന്തു, പല്ലി, അരണ, തുരവൻ. ");
INSERT INTO mal2015_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","എല്ലാ ഇഴജാതിയിലുംവെച്ചു ഇവ നിങ്ങൾക്കു അശുദ്ധം; അവ ചത്തശേഷം അവയെ തൊടുന്നവനെല്ലാം സന്ധ്യവരെ അശുദ്ധൻ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ചത്തശേഷം അവയിൽ ഒന്നു ഏതിന്മേൽ എങ്കിലും വീണാൽ അതൊക്കെയും അശുദ്ധമാകും; അതു മരപ്പാത്രമോ വസ്ത്രമോ തോലോ ചാക്കുശീലയോ വേലെക്കു ഉപയോഗിക്കുന്ന പാത്രമോ എന്തായാലും വെള്ളത്തിൽ ഇടേണം; അതു സന്ധ്യവരെ അശുദ്ധമായിരിക്കേണം; പിന്നെ ശുദ്ധമാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","അവയിൽ യാതൊന്നെങ്കിലും ഒരു മൺപാത്രത്തിന്നകത്തു വീണാൽ അതിന്നകത്തുള്ളതു ഒക്കെയും അശുദ്ധമാകും; നിങ്ങൾ അതു ഉടെച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","തിന്നുന്ന വല്ല സാധനത്തിന്മേലും ആ വെള്ളം വീണാൽ അതു അശുദ്ധമാകും; കുടിക്കുന്ന വല്ല പാനീയവും ആ വക പാത്രത്തിൽ ഉണ്ടെങ്കിൽ അതു അശുദ്ധമാകും; ");
INSERT INTO mal2015_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","അവയിൽ ഒന്നിന്റെ പിണം വല്ലതിന്മേലും വീണാൽ അതു ഒക്കെയും അശുദ്ധമാകും: അടുപ്പോ തീച്ചട്ടിയോ ഇങ്ങനെ എന്തായാലും അതു തകർത്തുകളയേണം; അവ അശുദ്ധം ആകുന്നു; അവ നിങ്ങൾക്കു അശുദ്ധം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","എന്നാൽ നീരുറവും വെള്ളമുള്ള കിണറും ശുദ്ധമായിരിക്കും; പിണം തൊടുന്നവനോ അശുദ്ധനാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","വിതെക്കുന്ന വിത്തായ വല്ല ധാന്യത്തിന്മേലും അവയിൽ ഒന്നിന്റെ പിണം വീണാലും അതു ശുദ്ധമായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","എന്നാൽ വിത്തിൽ വെള്ളം ഒഴിച്ചിട്ടു അവയിൽ ഒന്നിന്റെ പിണം അതിന്മേൽ വീണാൽ അതു അശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","നിങ്ങൾക്കു തിന്നാകുന്ന ഒരു മൃഗം ചത്താൽ അതിന്റെ പിണം തൊടുന്നവൻ സന്ധ്യവരെ അശുദ്ധൻ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","അതിന്റെ പിണം തിന്നുന്നവൻ വസ്ത്രം അലക്കി സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം; അതിന്റെ പിണം വഹിക്കുന്നവനും വസ്ത്രം അലക്കി സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","നിലത്തു ഇഴയുന്ന ഇഴജാതിയെല്ലാം അറെപ്പാകുന്നു; അതിനെ തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ഉരസ്സുകൊണ്ടു ചരിക്കുന്നതും നാലുകാൽകൊണ്ടു നടക്കുന്നതും അല്ലെങ്കിൽ അനേകം കാലുള്ളതായി നിലത്തു ഇഴയുന്നതുമായ യാതൊരു ഇഴജാതിയെയും നിങ്ങൾ തിന്നരുതു; അവ അറെപ്പാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","യാതൊരു ഇഴജാതിയെക്കൊണ്ടും നിങ്ങളെ തന്നേ അറെപ്പാക്കരുതു; അവയാൽ നിങ്ങൾ മലിനപ്പെടുമാറു നിങ്ങളെത്തന്നേ അശുദ്ധമാക്കുകയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു; ഞാൻ വിശുദ്ധനാകയാൽ നിങ്ങൾ നിങ്ങളെ തന്നേ വിശുദ്ധീകരിച്ചു വിശുദ്ധന്മാരായിരിക്കേണം; ഭൂമിയിൽ ഇഴയുന്ന യാതൊരു ഇഴജാതിയാലും നിങ്ങളെ തന്നേ അശുദ്ധമാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ഞാൻ നിങ്ങൾക്കു ദൈവമായിരിക്കേണ്ടതിന്നു നിങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെടുവിച്ച യഹോവ ആകുന്നു; ഞാൻ വിശുദ്ധനാകയാൽ നിങ്ങളും വിശുദ്ധന്മാരായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","ശുദ്ധവും അശുദ്ധവും തമ്മിലും തിന്നാകുന്ന മൃഗത്തെയും തിന്നരുതാത്ത മൃഗത്തെയും തമ്മിലും ");
INSERT INTO mal2015_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","വകതിരിക്കേണ്ടതിന്നു ഇതു മൃഗങ്ങളെയും പക്ഷികളെയും വെള്ളത്തിൽ ചലനം ചെയ്യുന്ന സകലജന്തുക്കളെയും നിലത്തു ഇഴയുന്ന ജന്തുക്കളെയും പറ്റിയുള്ള പ്രമാണം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ഒരു സ്ത്രീ ഗർഭംധരിച്ചു ആൺകുഞ്ഞിനെ പ്രസവിച്ചാൽ അവൾ ഏഴു ദിവസം അശുദ്ധയായിരിക്കേണം; ഋതുവിന്റെ മാലിന്യകാലത്തെന്നപോലെ അവൾ അശുദ്ധയായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","എട്ടാം ദിവസം അവന്റെ അഗ്രചർമ്മം പരിച്ഛേദന ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","പിന്നെ അവൾ മുപ്പത്തുമൂന്നു ദിവസം തന്റെ രക്തശുദ്ധീകരണത്തിൽ ഇരിക്കേണം; അവളുടെ ശുദ്ധീകരണകാലം തികയുന്നതുവരെ അവൾ യാതൊരു വിശുദ്ധവസ്തുവും തൊടരുതു; വിശുദ്ധ മന്ദിരത്തിലേക്കു വരികയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","പെൺകുഞ്ഞിനെ പ്രസവിച്ചാൽ അവൾ രണ്ടു ആഴ്ചവട്ടം ഋതുകാലത്തെന്നപോലെ അശുദ്ധയായിരിക്കേണം; പിന്നെ അറുപത്താറു ദിവസം തന്റെ രക്തശുദ്ധീകരണത്തിൽ ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","മകന്നു വേണ്ടിയോ മകൾക്കു വേണ്ടിയോ അവളുടെ ശുദ്ധീകരണകാലം തികഞ്ഞശേഷം അവൾ ഒരു വയസ്സുപ്രായമുള്ള ആട്ടിൻകുട്ടിയെ ഹോമയാഗത്തിന്നായിട്ടും ഒരു പ്രാവിൻകുഞ്ഞിനെയോ ഒരു കുറുപ്രാവിനെയോ പാപയാഗത്തിന്നായിട്ടും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","അവൻ അതു യഹോവയുടെ സന്നിധിയിൽ അർപ്പിച്ചു പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അവളുടെ രക്തസ്രവം നിന്നിട്ടു അവൾ ശുദ്ധയാകും. ഇതു ആൺകുഞ്ഞിനെയോ പെൺകുഞ്ഞിനെയോ പ്രസവിച്ചവൾക്കുള്ള പ്രമാണം. ");
INSERT INTO mal2015_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ആട്ടിൻകുട്ടിക്കു അവളുടെ പക്കൽ വകയില്ല എങ്കിൽ അവൾ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ ഒന്നിനെ ഹോമയാഗത്തിന്നും മറ്റേതിനെ പാപയാഗത്തിന്നുമായി കൊണ്ടുവരേണം; പുരോഹിതൻ അവൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അവൾ ശുദ്ധയാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","ഒരു മനുഷ്യന്റെ ത്വക്കിന്മേൽ തിണർപ്പോ ചുണങ്ങോ വെളുത്ത പുള്ളിയോ ഇങ്ങനെ കുഷ്ഠത്തിന്റെ വടു കണ്ടാൽ അവനെ പുരോഹിതനായ അഹരോന്റെ അടുക്കലോ പുരോഹിതന്മാരായ അവന്റെ പുത്രന്മാരിൽ ഒരുത്തന്റെ അടുക്കലോ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","പുരോഹിതൻ ത്വക്കിന്മേൽ ഉള്ള വടു നോക്കേണം; വടുവിന്നകത്തുള്ള രോമം വെളുത്തതും വടു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞതും ആയി കണ്ടാൽ അതു കുഷ്ഠലക്ഷണം; പുരോഹിതൻ അവനെ നോക്കി അശുദ്ധനെന്നു വിധിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","അവന്റെ ത്വക്കിന്മേൽ പുള്ളി വെളുത്തതും ത്വക്കിനെക്കാളും കുഴിഞ്ഞിരിക്കാത്തതും അതിന്നകത്തുള്ള രോമം വെളുത്തിരിക്കാത്തതും ആയി കണ്ടാൽ പുരോഹിതൻ ആ ലക്ഷണമുള്ളവനെ ഏഴു ദിവസത്തേക്കു അകത്താക്കി അടക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ഏഴാം ദിവസം പുരോഹിതൻ അവനെ നോക്കേണം. വടു ത്വക്കിന്മേൽ പരക്കാതെ, കണ്ട സ്ഥിതിയിൽ നില്ക്കുന്നു എങ്കിൽ പുരോഹിതൻ രണ്ടാം പ്രാവശ്യം അവനെ ഏഴു ദിവസത്തേക്കു അകത്താക്കി അടെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ഏഴാം ദിവസം പുരോഹിതൻ അവനെ വീണ്ടും നോക്കേണം; വടു മങ്ങിയതായും ത്വക്കിന്മേൽ പരക്കാതെയും കണ്ടാൽ പുരോഹിതൻ അവനെ ശുദ്ധിയുള്ളവൻ എന്നു വിധിക്കേണം; അതു ചുണങ്ങത്രേ. അവൻ വസ്ത്രം അലക്കി ശുദ്ധിയുള്ളവനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","അവൻ ശുദ്ധീകരണത്തിന്നായി തന്നെത്താൻ പുരോഹിതനെ കാണിച്ചശേഷം ചുണങ്ങു ത്വക്കിന്മേൽ അധികമായി പരന്നാൽ അവൻ പിന്നെയും തന്നെത്താൻ പുരോഹിതനെ കാണിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ചുണങ്ങു ത്വക്കിന്മേൽ പരക്കുന്നു എന്നു പുരോഹിതൻ കണ്ടാൽ പുരോഹിതൻ അവനെ അശുദ്ധനെന്നു വിധിക്കേണം; അതു കുഷ്ഠം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","കുഷ്ഠത്തിന്റെ ലക്ഷണം ഒരു മനുഷ്യനിൽ ഉണ്ടായാൽ അവനെ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","പുരോഹിതൻ അവനെ നോക്കേണം; ത്വക്കിന്മേൽ വെളുത്ത തിണർപ്പുണ്ടായിരിക്കയും അതിലെ രോമം വെളുത്തിരിക്കയും തിണർപ്പിൽ പച്ചമാംസത്തിന്റെ ലക്ഷണം ഉണ്ടായിരിക്കയും ചെയ്താൽ ");
INSERT INTO mal2015_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","അതു അവന്റെ ത്വക്കിൽ പഴകിയ കുഷ്ഠം ആകുന്നു; പുരോഹിതൻ അവനെ അശുദ്ധൻ എന്നു വിധിക്കേണം; അവൻ അശുദ്ധനാകകൊണ്ടു അവനെ അകത്താക്കി അടെക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","കുഷ്ഠം ത്വക്കിൽ അധികമായി പരന്നു രോഗിയുടെ തലതൊട്ടു കാൽവരെ പുരോഹിതൻ കാണുന്നേടത്തൊക്കെയും വടു ത്വക്കിൽ ആസകലം മൂടിയിരിക്കുന്നു എങ്കിൽ പുരോഹിതൻ നോക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","കുഷ്ഠം അവന്റെ ദേഹത്തെ മുഴുവനും മൂടിയിരുന്നാൽ അവൻ വടുവുള്ളവനെ ശുദ്ധിയുള്ളവനെന്നു വിധിക്കേണം; ആസകലം വെള്ളയായി തീർന്നു; അവൻ ശുദ്ധിയുള്ളവൻ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","എന്നാൽ പച്ചമാംസം അവനിൽ കണ്ടാൽ അവൻ അശുദ്ധൻ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","പുരോഹിതൻ പച്ചമാംസം നോക്കി അവനെ അശുദ്ധനെന്നു വിധിക്കേണം. പച്ചമാംസം അശുദ്ധം; അതു കുഷ്ഠം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","എന്നാൽ പച്ചമാംസം മാറി വെള്ളയായി തീർന്നാൽ അവൻ പുരോഹിതന്റെ അടുക്കൽ വരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","പുരോഹിതൻ അവനെ നോക്കേണം; വടു വെള്ളയായി തീർന്നു എങ്കിൽ പുരോഹിതൻ വടുവുള്ളവനെ ശുദ്ധിയുള്ളവനെന്നു വിധിക്കേണം; അവൻ ശുദ്ധിയുള്ളവൻ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ദേഹത്തിന്റെ ത്വക്കിൽ പരുവുണ്ടായിരുന്നിട്ടു ");
INSERT INTO mal2015_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","സൗഖ്യമായ ശേഷം പരുവിന്റെ സ്ഥലത്തു വെളുത്ത തിണർപ്പോ ചുവപ്പോടുകൂടിയ വെളുത്ത പുള്ളിയോ ഉണ്ടായാൽ അതു പുരോഹിതനെ കാണിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","പുരോഹിതൻ അതു നോക്കേണം; അതു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞതും അതിലെ രോമം വെളുത്തതുമായി കണ്ടാൽ പുരോഹിതൻ അവനെ അശുദ്ധനെന്നു വിധിക്കേണം; അതു പരുവിൽനിന്നുണ്ടായ കുഷ്ഠരോഗം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","എന്നാൽ പുരോഹിതൻ അതു നോക്കി അതിൽ വെളുത്ത രോമം ഇല്ലാതെയും അതു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞിരിക്കാതെയും നിറം മങ്ങിയും കണ്ടാൽ പുരോഹിതൻ അവനെ ഏഴു ദിവസത്തേക്കു അകത്താക്കി അടെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","അതു ത്വക്കിന്മേൽ അധികം പരന്നാൽ പുരോഹിതൻ അവനെ അശുദ്ധനെന്നു വിധിക്കേണം; അതു കുഷ്ഠലക്ഷണം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","എന്നാൽ വെളുത്ത പുള്ളി പരക്കാതെ, കണ്ട നിലയിൽ തന്നേ നിന്നു എങ്കിൽ അതു പരുവിന്റെ വടു അത്രേ. പുരോഹിതൻ അവനെ ശുദ്ധിയുള്ളവനെന്നു വിധിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","അല്ലെങ്കിൽ ദേഹത്തിന്റെ ത്വക്കിൽ തീപ്പൊള്ളൽ ഉണ്ടായി പൊള്ളലിന്റെ വടു ചുവപ്പോടുകൂടി വെളുത്തോ വെളുത്തു തന്നേയോ ഇരിക്കുന്ന പുള്ളി ആയി തീർന്നാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","പുരോഹിതൻ അതു നോക്കേണം; പുള്ളിയിലെ രോമം വെള്ളയായി തീർന്നു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞുകണ്ടാൽ പൊള്ളലിൽ ഉണ്ടായ കുഷ്ഠം; ആകയാൽ പുരോഹിതൻ അവനെ അശുദ്ധനെന്നു വിധിക്കേണം; അതു കുഷ്ഠലക്ഷണം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","എന്നാൽ പുരോഹിതൻ അതു നോക്കീട്ടു പുള്ളിയിൽ വെളുത്തരോമം ഇല്ലാതെയും അതു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞിരിക്കാതെയും നിറം മങ്ങിയും കണ്ടാൽ പുരോഹിതൻ അവനെ ഏഴു ദിവസത്തേക്കു അകത്താക്കി അടെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ഏഴാം ദിവസം പുരോഹിതൻ അവനെ നോക്കേണം: അതു ത്വക്കിന്മേൽ പരന്നിരുന്നാൽ പുരോഹിതൻ അവനെ അശുദ്ധനെന്നു വിധിക്കേണം; അതു കുഷ്ഠലക്ഷണം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","എന്നാൽ പുള്ളി ത്വക്കിന്മേൽ പരക്കാതെ, കണ്ട നിലയിൽ തന്നേ നിൽക്കയും നിറം മങ്ങിയിരിക്കയും ചെയ്താൽ അതു തീപ്പൊള്ളലിന്റെ തിണർപ്പു ആകുന്നു; പുരോഹിതൻ അവനെ ശുദ്ധിയുള്ളവനെന്നു വിധിക്കേണം; അതു തീപ്പൊള്ളലിന്റെ തിണർപ്പത്രേ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","ഒരു പുരുഷന്നു എങ്കിലും ഒരു സ്ത്രീക്കു എങ്കിലും തലയിലോ താടിയിലോ ഒരു വടു ഉണ്ടായാൽ പുരോഹിതൻ വടു നോക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","അതു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞും അതിൽ പൊൻനിറമായ നേർമ്മയുള്ള രോമം ഉള്ളതായും കണ്ടാൽ പുരോഹിതൻ അവനെ അശുദ്ധനെന്നു വിധിക്കേണം; അതു പുറ്റാകുന്നു; തലയിലോ താടിയിലോ ഉള്ള കുഷ്ഠം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","പുരോഹിതൻ പുറ്റിന്റെ വടുവിനെ നോക്കുമ്പോൾ അതു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞിരിക്കാതെയും അതിൽ കറുത്ത രോമം ഇല്ലാതെയും കണ്ടാൽ പുരോഹിതൻ പുറ്റുവടുവുള്ളവനെ ഏഴുദിവസത്തേക്കുഅകത്താക്കി അടെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ഏഴാം ദിവസം പുരോഹിതൻ വടുവിനെ നോക്കേണം; പുറ്റു പരക്കാതെയും അതിൽ പൊൻനിറമുള്ള രോമം ഇല്ലാതെയും പുറ്റിന്റെ കാഴ്ച ത്വക്കിനെക്കാൾ കുഴിഞ്ഞിരിക്കാതെയും ഇരുന്നാൽ അവൻ ക്ഷൗരം ചെയ്യിക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","എന്നാൽ പുറ്റിൽ ക്ഷൗരം ചെയ്യരുതു; പുരോഹിതൻ പുറ്റുള്ളവനെ പിന്നെയും ഏഴു ദിവസത്തേക്കു അകത്താക്കി അടെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ഏഴാം ദിവസം പുരോഹിതൻ പുറ്റു നോക്കേണം; പുറ്റു ത്വക്കിന്മേൽ പരക്കാതെയും കാഴ്ചെക്കു ത്വക്കിനെക്കാൾ കുഴിഞ്ഞിരിക്കാതെയും ഇരുന്നാൽ പുരോഹിതൻ അവനെ ശുദ്ധിയുള്ളവനെന്നു വിധിക്കേണം; അവൻ വസ്ത്രം അലക്കി ശുദ്ധിയുള്ളവനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","എന്നാൽ അവന്റെ ശുദ്ധീകരണത്തിന്റെ ശേഷം പുറ്റു ത്വക്കിന്മേൽ പരന്നാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","പുരോഹിതൻ അവനെ നോക്കേണം; പുറ്റു ത്വക്കിന്മേൽ പരന്നിരുന്നാൽ പുരോഹിതൻ പൊൻനിറമുള്ള രോമം അന്വേഷിക്കേണ്ടാ; അവൻ അശുദ്ധൻ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","എന്നാൽ പുറ്റു കണ്ട നിലയിൽ തന്നേ നില്ക്കുന്നതായും അതിൽ കറുത്ത രോമം മുളെച്ചതായും കണ്ടാൽ പുറ്റു സൗഖ്യമായി; അവൻ ശുദ്ധിയുള്ളവൻ; പുരോഹിതൻ അവനെ ശുദ്ധിയുള്ളവനെന്നു വിധിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","ഒരു പുരുഷന്നോ സ്ത്രീക്കോ ദേഹത്തിന്റെ ത്വക്കിൽ വെളുത്ത പുള്ളി ഉണ്ടായാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","പുരോഹിതൻ നോക്കേണം; ദേഹത്തിന്റെ ത്വക്കിൽ മങ്ങിയ വെള്ളപ്പുള്ളി ഉണ്ടായാൽ അതു ത്വക്കിൽ ഉണ്ടാകുന്ന ചുണങ്ങു; അവൻ ശുദ്ധിയുള്ളവൻ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","തലമുടി കൊഴിഞ്ഞവനോ കഷണ്ടിക്കാരനത്രേ; അവൻ ശുദ്ധിയുള്ളവൻ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","തലയിൽ മുൻവശത്തെ രോമം കൊഴിഞ്ഞവൻ മുൻകഷണ്ടിക്കാരൻ; അവൻ ശുദ്ധിയുള്ളവൻ. ");
INSERT INTO mal2015_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","പിൻകഷണ്ടിയിലോ മുൻകഷണ്ടിയിലോ ചുവപ്പോടുകൂടിയ വെള്ളപ്പുള്ളിയുണ്ടായാൽ അതു അവന്റെ പിൻകഷണ്ടിയിലോ മുൻകഷണ്ടിയിലോ ഉത്ഭവിക്കുന്ന കുഷ്ഠം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","പുരോഹിതൻ അതു നോക്കേണം; അവന്റെ പിൻകഷണ്ടിയിലോ മുൻകഷണ്ടിയിലോ ത്വക്കിൽ കുഷ്ഠത്തിന്റെ കാഴ്ചപോലെ വടുവിന്റെ തിണർപ്പു ചുവപ്പോടുകൂടി വെളുത്തതായിരുന്നാൽ അവൻ കുഷ്ഠരോഗി; ");
INSERT INTO mal2015_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","അവൻ അശുദ്ധൻ തന്നേ; പുരോഹിതൻ അവനെ അശുദ്ധൻ എന്നു തീർത്തു വിധിക്കേണം; അവന്നു തലയിൽ കുഷ്ഠരോഗം ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","വടുവുള്ള കുഷ്ഠരോഗിയുടെ വസ്ത്രം കീറിക്കളയേണം: അവന്റെ തല മൂടാതിരിക്കേണം; അവൻ അധരം മൂടിക്കൊണ്ടിരിക്കയും അശുദ്ധൻ അശുദ്ധൻ എന്നു വിളിച്ചുപറകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","അവന്നു രോഗം ഉള്ള നാൾ ഒക്കെയും അവൻ അശുദ്ധനായിരിക്കേണം; അവൻ അശുദ്ധൻ തന്നേ; അവൻ തനിച്ചു പാർക്കേണം; അവന്റെ പാർപ്പു പാളയത്തിന്നു പുറത്തു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","ആട്ടുരോമവസ്ത്രമോ ചണവസ്ത്രമോ ആയ ഏതു വസ്ത്രത്തിലെങ്കിലും ");
INSERT INTO mal2015_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ചണംകൊണ്ടോ ആട്ടുരോമംകൊണ്ടോ ഉള്ള പാവിൽ എങ്കിലും ഊടയിലെങ്കിലും തോലിലെങ്കിലും തോൽകൊണ്ടു ഉണ്ടാക്കിയ യാതൊരു സാധനത്തിൽ എങ്കിലും ");
INSERT INTO mal2015_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","കുഷ്ഠത്തിന്റെ വടുവായി വസ്ത്രത്തിൽ എങ്കിലും തോലിലെങ്കിലും പാവിലെങ്കിലും ഊടയിലെങ്കിലും തോൽകൊണ്ടുള്ള യാതൊരു സാധനത്തിലെങ്കിലും വടു ഇളമ്പച്ചയോ ഇളഞ്ചുവപ്പോ ആയിരുന്നാൽ അതു കുഷ്ഠലക്ഷണം ആകുന്നു; അതു പുരോഹിതനെ കാണിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","പുരോഹിതൻ വടുനോക്കി വടുവുള്ളതിനെ ഏഴു ദിവസത്തേക്കു അകത്തിട്ടു അടെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","അവൻ ഏഴാം ദിവസം വടുവിനെ നോക്കേണം; വസ്ത്രത്തിലോ പാവിലോ ഊടയിലോ തോലിലോ തോൽകൊണ്ടു ഉണ്ടാക്കിയ യാതൊരു പണിയിലോ വടു പരന്നിരുന്നാൽ ആ വടു കഠിന കുഷ്ഠം; അതു അശുദ്ധമാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","വടുവുള്ള സാധനം ആട്ടിൻരോമംകൊണ്ടോ ചണംകൊണ്ടോ ഉള്ള വസ്ത്രമോ പാവോ ഊടയോ തോൽകൊണ്ടുള്ള എന്തെങ്കിലുമോ ആയിരുന്നാലും അതു ചുട്ടുകളയേണം; അതു കഠിന കുഷ്ഠം; അതു തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","എന്നാൽ പുരോഹിതൻ നോക്കേണം; വടു വസ്ത്രത്തിലോ പാവിലോ ഊടയിലോ തോൽകൊണ്ടുള്ള യാതൊരു സാധനത്തിലോ പരന്നിട്ടില്ല എങ്കിൽ ");
INSERT INTO mal2015_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","പുരോഹിതൻ വടുവുള്ള സാധനം കഴുകുവാൻ കല്പിക്കേണം; അതു പിന്നെയും ഏഴു ദിവസത്തേക്കു അകത്തിട്ടു അടെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","കഴുകിയശേഷം പുരോഹിതൻ വടു നോക്കേണം: വടു നിറം മാറാതെയും പരക്കാതെയും ഇരുന്നാൽ അതു അശുദ്ധം ആകുന്നു; അതു തീയിൽ ഇട്ടു ചുട്ടുകളയേണം; അതു അതിന്റെ അകത്തോ പുറത്തോ തിന്നെടുക്കുന്ന വ്രണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","പിന്നെ പുരോഹിതൻ നോക്കേണം; കഴുകിയശേഷം വടുവിന്റെ നിറം മങ്ങി എങ്കിൽ അവൻ അതിനെ വസ്ത്രത്തിൽനിന്നോ തോലിൽനിന്നോ പാവിൽനിന്നോ ഊടയിൽനിന്നോ കീറിക്കളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","അതു വസ്ത്രത്തിലോ പാവിലോ ഊടയിലോ തോൽകൊണ്ടുള്ള യാതൊരു സാധനത്തിലോ കാണുന്നു എങ്കിൽ അതു പടരുന്നതാകുന്നു; വടുവുള്ളതു തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","എന്നാൽ വസ്ത്രമോ പാവോ ഊടയോ തോൽകൊണ്ടുള്ള യാതൊരു സാധനമോ കഴുകിയശേഷം വടു അവയിൽ നിന്നു നീങ്ങിപ്പോയി എങ്കിൽ അതിനെ രണ്ടാം പ്രാവശ്യം കഴുകേണം; അപ്പോൾ അതു ശുദ്ധമാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ആട്ടുരോമമോ ചണമോ കൊണ്ടുള്ള വസ്ത്രത്തിൽ എങ്കിലും പാവിൽ എങ്കിലും ഊടയിൽ എങ്കിലും തോൽകൊണ്ടുള്ള യാതൊന്നിലെങ്കിലും ഉള്ള കുഷ്ഠത്തിന്റെ വടുവിനെക്കുറിച്ചു അതു ശുദ്ധമെന്നോ അശുദ്ധമെന്നോ വിധിപ്പാനുള്ള പ്രമാണം ഇതു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","കുഷ്ഠരോഗിയുടെ ശുദ്ധീകരണദിവസത്തിൽ അവനെ സംബന്ധിച്ചുള്ള പ്രമാണമാവിതു: അവനെ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","പുരോഹിതൻ പാളയത്തിന്നു പുറത്തു ചെല്ലേണം; കുഷ്ഠരോഗിയുടെ കുഷ്ഠം സുഖമായി എന്നു പുരോഹിതൻ കണ്ടാൽ ശുദ്ധീകരണം ");
INSERT INTO mal2015_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","കഴിവാനുള്ളവന്നുവേണ്ടി ജീവനും ശുദ്ധിയുള്ള രണ്ടു പക്ഷി, ദേവദാരു, ചുവപ്പുനൂൽ, ഈസോപ്പു എന്നിവയെ കൊണ്ടുവരുവാൻ കല്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","പുരോഹിതൻ ഒരു പക്ഷിയെ ഒരു മൺപാത്രത്തിലെ ഉറവുവെള്ളത്തിന്മീതെ അറുപ്പാൻ കല്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ജീവനുള്ള പക്ഷി, ദേവദാരു, ചുവപ്പുനൂൽ, ഈസോപ്പു എന്നിവയെ അവൻ എടുത്തു ഇവയെയും ജീവനുള്ള പക്ഷിയെയും ഉറവുവെള്ളത്തിന്മീതെ അറുത്ത പക്ഷിയുടെ രക്തത്തിൽ മുക്കി ");
INSERT INTO mal2015_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","കുഷ്ഠശുദ്ധീകരണം കഴിവാനുള്ളവന്റെ മേൽ ഏഴു പ്രാവശ്യം തളിച്ചു അവനെ ശുദ്ധിയുള്ളവനെന്നു വിധിക്കയും ജീവനുള്ള പക്ഷിയെ വെളിയിൽ വിടുകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","ശുദ്ധീകരണം കഴിയുന്നവൻ വസ്ത്രം അലക്കി രോമം ഒക്കെയും ക്ഷൗരം ചെയ്യിച്ചു വെള്ളത്തിൽ കുളിക്കേണം; എന്നാൽ അവൻ ശുദ്ധിയുള്ളവനാകും; അതിന്റെ ശേഷം അവൻ പാളയത്തിൽ ചെന്നു തന്റെ കൂടാരത്തിന്നു പുറമേ ഏഴു ദിവസം പാർക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ഏഴാം ദിവസം അവൻ തലയും താടിയും പുരികവും എല്ലാം വെടിപ്പാക്കേണം; ഇങ്ങനെ അവൻ സകലരോമവും ക്ഷൗരം ചെയ്യിച്ചു വസ്ത്രം അലക്കുകയും ദേഹം വെള്ളത്തിൽ കഴുകുകയും വേണം; എന്നാൽ അവൻ ശുദ്ധിയുള്ളവനാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","എട്ടാം ദിവസം അവൻ ഊനമില്ലാത്ത രണ്ടു ആൺകുഞ്ഞാടിനെയും ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഒരു പെൺകുഞ്ഞാടിനെയും ഭോജനയാഗമായിട്ടു എണ്ണ ചേർത്ത മൂന്നിടങ്ങഴി നേരിയ മാവും ഒരു കുറ്റി എണ്ണയും കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ശുദ്ധീകരണം കഴിക്കുന്ന പുരോഹിതൻ ശുദ്ധീകരണം കഴിയുന്നവനെ അവയുമായി യഹോവയുടെ സന്നിധിയിൽ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ നിർത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","പുരോഹിതൻ ആൺകുഞ്ഞാടുകളിൽ ഒന്നിനെയും എണ്ണയും എടുത്തു അകൃത്യയാഗമായി അർപ്പിച്ചു യഹോവയുടെ സന്നിധിയിൽ നീരാജനം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","അവൻ വിശുദ്ധമന്ദിരത്തിൽ പാപയാഗത്തെയും ഹോമയാഗത്തെയും അറുക്കുന്ന ഇടത്തുവെച്ചു കുഞ്ഞാടിനെ അറുക്കേണം; അകൃത്യയാഗം പാപയാഗംപോലെ പുരോഹിതന്നുള്ളതു ആകുന്നു; അതു അതിവിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","പുരോഹിതൻ അകൃത്യയാഗത്തിന്റെ രക്തം കുറെ എടുത്തു ശുദ്ധീകരണം കഴിയുന്നവന്റെ വലത്തുകാതിന്മേലും വലത്തുകയ്യുടെ പെരുവിരലിന്മേലും വലത്തുകാലിന്റെ പെരുവിരലിന്മേലും പുരട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","പിന്നെ പുരോഹിതൻ ആ എണ്ണ കുറെ തന്റെ ഇടത്തെ ഉള്ളങ്കയ്യിൽ ഒഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","പുരോഹിതൻ ഇടങ്കയ്യിൽ ഉള്ള എണ്ണയിൽ വലങ്കയ്യുടെ വിരൽ മുക്കി വിരൽകൊണ്ടു ഏഴു പ്രാവശ്യം യഹോവയുടെ സന്നിധിയിൽ എണ്ണ തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ഉള്ളങ്കയ്യിൽ ശേഷിച്ച എണ്ണ കുറെ പുരോഹിതൻ ശുദ്ധീകരണം കഴിയുന്നവന്റെ വലത്തുകാതിന്മേലും വലത്തുകയ്യുടെ പെരുവിരലിന്മേലും വലത്തുകാലിന്റെ പെരുവിരലിന്മേലും അകൃത്യയാഗത്തിന്റെ രക്തത്തിന്മീതെ പുരട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","പുരോഹിതന്റെ ഉള്ളങ്കയ്യിൽ ശേഷിപ്പുള്ള എണ്ണ അവൻ ശുദ്ധീകരണം കഴിയുന്നവന്റെ തലയിൽ ഒഴിച്ചു യഹോവയുടെ സന്നിധിയിൽ അവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","പുരോഹിതൻ പാപയാഗം അർപ്പിച്ചു അശുദ്ധിപോക്കി ശുദ്ധീകരിക്കപ്പെടുന്നവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിച്ചശേഷം ഹോമയാഗമൃഗത്തെ അറുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","പുരോഹിതൻ ഹോമയാഗവും ഭോജനയാഗവും യാഗപീഠത്തിന്മേൽ അർപ്പിക്കേണം; അങ്ങനെ പുരോഹിതൻ അവന്നു വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അവൻ ശുദ്ധിയുള്ളവൻ ആകും. ");
INSERT INTO mal2015_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","അവൻ ദരിദ്രനും അത്രെക്കു വകയില്ലാത്തവനും ആകുന്നു എങ്കിൽ തനിക്കു വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണ്ടതിന്നു നീരാജനത്തിന്നായി അകൃത്യയാഗമായിട്ടു ഒരു കുഞ്ഞാടിനെയും ഭോജനയാഗമായിട്ടു എണ്ണ ചേർത്ത ഒരിടങ്ങഴി നേരിയ മാവും ");
INSERT INTO mal2015_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ഒരു കുറ്റി എണ്ണയും പ്രാപ്തിപോലെ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ ഒന്നിനെ പാപയാഗമായിട്ടും മറ്റേതിനെ ഹോമയാഗമായിട്ടും എടുത്തു തന്റെ ശുദ്ധീകരണത്തിന്നായി ");
INSERT INTO mal2015_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","എട്ടാം ദിവസം സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ യഹോവയുടെ സന്നിധിയിൽ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","പുരോഹിതൻ അകൃത്യയാഗത്തിന്നുള്ള ആട്ടിൻകുട്ടിയെയും എണ്ണയും എടുത്തു യഹോവയുടെ സന്നിധിയിൽ നീരാജനം ചെയ്യേണം; ");
INSERT INTO mal2015_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","അവൻ അകൃത്യയാഗത്തിന്നുള്ള ആട്ടിൻകുട്ടിയെ അറുക്കേണം; പുരോഹിതൻ അകൃത്യയാഗത്തിന്റെ രക്തം കുറെ എടുത്തു ശുദ്ധീകരണം കഴിയുന്നവന്റെ വലത്തു കാതിന്മേലും വലത്തുകയ്യുടെ പെരുവിരലിന്മേലും വലത്തു കാലിന്റെ പെരുവിരലിന്മേലും പുരട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","പുരോഹിതൻ എണ്ണ കുറെ തന്റെ ഇടത്തെ ഉള്ളങ്കയ്യിൽ ഒഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","പുരോഹിതൻ ഇടത്തുകയ്യിൽ ഉള്ള എണ്ണ കുറെ വലത്തുകയ്യുടെ വിരൽകൊണ്ടു യഹോവയുടെ സന്നിധിയിൽ ഏഴു പ്രാവശ്യം തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","പുരോഹിതൻ ഉള്ളങ്കയ്യിലുള്ള എണ്ണ കുറെ ശുദ്ധികരണം കഴിയുന്നവന്റെ വലത്തുകാതിന്മേലും വലത്തുകയ്യുടെ പെരുവിരലിന്മേലും വലത്തു കാലിന്റെ പെരുവിരലിന്മേലും അകൃത്യയാഗത്തിന്റെ രക്തം ഉള്ളേടത്തു പുരട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","പുരോഹിതൻ ഉള്ളങ്കയ്യിൽ ശേഷിപ്പുള്ള എണ്ണ അവൻ ശുദ്ധീകരണം കഴിയുന്നവന്റെ തലയിൽ ഒഴിച്ചു അവന്നുവേണ്ടി യഹോവയുടെ സന്നിധിയിൽ പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","അവൻ പ്രാപ്തിപോലെ കുറുപ്രാവുകളിലോ ");
INSERT INTO mal2015_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","പ്രാവിൻകുഞ്ഞുങ്ങളിലോ ഒന്നിനെ പാപയാഗമായിട്ടും മറ്റേതിനെ ഹോമയാഗമായിട്ടും ഭോജനയാഗത്തോടുകൂടെ അർപ്പിക്കേണം; ഇങ്ങനെ പുരോഹിതൻ ശുദ്ധീകരണം കഴിയുന്നവന്നുവേണ്ടി യഹോവയുടെ സന്നിധിയിൽ പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ഇതു ശുദ്ധീകരണത്തിന്നുവേണ്ടി വകയില്ലാത്ത കുഷ്ഠരോഗിക്കുള്ള പ്രമാണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","ഞാൻ നിങ്ങൾക്കു അവകാശമായി തരുന്ന കനാൻദേശത്തു നിങ്ങൾ എത്തിയശേഷം ഞാൻ നിങ്ങളുടെ അവകാശദേശത്തു ഒരു വീട്ടിൽ കുഷ്ഠബാധ വരുത്തുമ്പോൾ ");
INSERT INTO mal2015_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","വീട്ടുടമസ്ഥൻ വന്നു വീട്ടിൽ കുഷ്ഠലക്ഷണമുള്ളപ്രകാരം എനിക്കു തോന്നുന്നു എന്നു പുരോഹിതനെ അറിയിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","അപ്പോൾ വീട്ടിലുള്ള സകലവും അശുദ്ധമാകാതിരിപ്പാൻ പുരോഹിതൻ വടു നോക്കേണ്ടതിന്നു ചെല്ലും മുമ്പെ വീടു ഒഴിച്ചിടുവാൻ കല്പിക്കേണം; പിന്നെ പുരോഹിതൻ വീടു നോക്കുവാൻ അകത്തു ചെല്ലേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","അവൻ വടു നോക്കേണം; വീട്ടിന്റെ ചുവരിൽ ഇളമ്പച്ചയും ഇളഞ്ചുവപ്പുമായ കുത്തുകൾ ഉണ്ടായിട്ടു അവ കാഴ്ചെക്കു ചുവരിനെക്കാൾ കുഴിഞ്ഞതായി കണ്ടാൽ പുരോഹിതൻ വീടു വിട്ടു ");
INSERT INTO mal2015_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","വാതിൽക്കൽ വന്നു വീടു ഏഴുദിവസത്തേക്കു അടെച്ചിടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ഏഴാം ദിവസം പുരോഹിതൻ വീണ്ടും ചെന്നു നോക്കേണം; വടു വീട്ടിന്റെ ചുവരിൽ പരന്നിട്ടുണ്ടെങ്കിൽ ");
INSERT INTO mal2015_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","വടുവുള്ള കല്ലു നീക്കി പട്ടണത്തിന്നു പുറത്തു ഒരു അശുദ്ധസ്ഥലത്തു ഇടുവാൻ പുരോഹിതൻ കല്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","പിന്നെ വീട്ടിന്റെ അകം ഒക്കെയും ചുരണ്ടിക്കേണം; ചുരണ്ടിയ മണ്ണു പട്ടണത്തിന്നു പുറത്തു ഒരു അശുദ്ധസ്ഥലത്തു കളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","പിന്നെ വേറെ കല്ലു എടുത്തു ആ കല്ലിന്നു പകരം വെക്കേണം; വേറെ കുമ്മായം വീട്ടിന്നു തേക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","അങ്ങനെ കല്ലു നീക്കുകയും വീടു ചുരണ്ടുകയും കുമ്മായം തേക്കയും ചെയ്തശേഷം വടു പിന്നെയും വീട്ടിൽ ഉണ്ടായി വന്നാൽ പുരോഹിതൻ ചെന്നു നോക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","വടു വീട്ടിൽ പരന്നിരുന്നാൽ അതു വീട്ടിൽ തിന്നെടുക്കുന്ന കുഷ്ഠം തന്നേ; അതു അശുദ്ധം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","വീട്ടിന്റെ കല്ലും മരവും കുമ്മായവും ഇടിച്ചുപൊളിച്ചു പട്ടണത്തിന്നു പുറത്തു ഒരു അശുദ്ധസ്ഥലത്തു കൊണ്ടുപോയി കളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","വീടു അടെച്ചിരുന്ന കാലത്തു എപ്പോഴെങ്കിലും അതിന്നകത്തു കടക്കുന്നവൻ സന്ധ്യവരെ അശുദ്ധിയുള്ളവനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","വീട്ടിൽ കിടക്കുന്നവൻ വസ്ത്രം അലക്കേണം; ആ വീട്ടിൽ വെച്ചു ഭക്ഷണം കഴിക്കുന്നവനും വസ്ത്രം അലക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","വീട്ടിന്നു കുമ്മായം തേച്ചശേഷം പുരോഹിതൻ അകത്തു ചെന്നു നോക്കി വീട്ടിൽ വടു പരന്നിട്ടില്ല എന്നു കണ്ടാൽ വടു മാറിപ്പോയതുകൊണ്ടു പുരോഹിതൻ ആ വീടു ശുദ്ധിയുള്ളതു എന്നു വിധിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","അപ്പോൾ അവൻ വീടു ശുദ്ധീകരിക്കേണ്ടതിന്നു രണ്ടു പക്ഷി, ദേവദാരു, ചുവപ്പുനൂൽ, ഈസോപ്പു എന്നിവയെ എടുത്തു ");
INSERT INTO mal2015_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ഒരു പക്ഷിയെ മൺപാത്രത്തിലുള്ള ഉറവുവെള്ളത്തിന്മീതെ അറുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","പിന്നെ ദേവദാരു, ഈസോപ്പു, ചുവപ്പുനൂൽ, ജീവനുള്ള പക്ഷി എന്നിവയെ എടുത്തു അറുത്ത പക്ഷിയുടെ രക്തത്തിലും ഉറവുവെള്ളത്തിലും മുക്കി വീട്ടിന്മേൽ ഏഴു പ്രാവശ്യം തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","പക്ഷിയുടെ രക്തം, ഉറവു വെള്ളം, ജിവനുള്ള പക്ഷി, ദേവദാരു, ഈസോപ്പു, ചുവപ്പുനൂൽ എന്നിവയെക്കൊണ്ടു വീടു ശുദ്ധീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ജീവനുള്ള പക്ഷിയെ പട്ടണത്തിന്നു പുറത്തു വെളിയിൽ വിടേണം; അങ്ങനെ വീട്ടിന്നു വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു ശുദ്ധമാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ഇതു സകല കുഷ്ഠത്തിന്നും വടുവിന്നും ");
INSERT INTO mal2015_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","പുറ്റിന്നും വസ്ത്രത്തിന്റെയും വീട്ടിന്റെയും ");
INSERT INTO mal2015_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","കുഷ്ഠത്തിന്നും തിണർപ്പിന്നും ചുണങ്ങിന്നും ചിരങ്ങിന്നും വെളുത്തപുള്ളിക്കും ഉള്ള പ്രമാണം. ");
INSERT INTO mal2015_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","എപ്പോൾ അശുദ്ധമെന്നും എപ്പോൾ ശുദ്ധമെന്നും അറിയേണ്ടതിന്നു ഇതു കുഷ്ഠത്തെക്കുറിച്ചുള്ള പ്രമാണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","നിങ്ങൾ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ആർക്കെങ്കിലും തന്റെ അംഗത്തിൽ ശുക്ലസ്രവം ഉണ്ടായാൽ അവൻ സ്രവത്താൽ അശുദ്ധൻ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","അവന്റെ സ്രവത്താലുള്ള അശുദ്ധിയാവിതു: അവന്റെ അംഗം സ്രവിച്ചുകൊണ്ടിരുന്നാലും അവന്റെ അംഗം സ്രവിക്കാതെ അടഞ്ഞിരുന്നാലും അതു അശുദ്ധി തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","സ്രവക്കാരൻ കിടക്കുന്ന കിടക്ക ഒക്കെയും അശുദ്ധം; അവൻ ഇരിക്കുന്ന സാധനമൊക്കെയും അശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","അവന്റെ കിടക്ക തൊടുന്ന മനുഷ്യൻ വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","സ്രവക്കാരൻ ഇരുന്ന സാധനത്തിന്മേൽ ഇരിക്കുന്നവൻ വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധൻ ആയിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","സ്രവക്കാരന്റെ ദേഹം തൊടുന്നവൻ വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","സ്രവക്കാരൻ ശുദ്ധിയുള്ളവന്റെമേൽ തുപ്പിയാൽ അവൻ വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","സ്രവക്കാരൻ കയറിപ്പോകുന്ന ഏതു വാഹനവും അശുദ്ധമാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","അവന്റെ കീഴെ ഇരുന്ന ഏതിനെയും തൊടുന്നവനെല്ലാം സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം; അവയെ വഹിക്കുന്നവൻ വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","സ്രവക്കാരൻ വെള്ളംകൊണ്ടു കൈകഴുകാതെ ആരെ എങ്കിലും തൊട്ടാൽ അവൻ വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","സ്രവക്കാരൻ തൊട്ട മൺപാത്രം ഉടെച്ചുകളയേണം; മരപ്പാത്രമെല്ലാം വെള്ളംകൊണ്ടു കഴുകേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","സ്രവക്കാരൻ സ്രവം മാറി ശുദ്ധിയുള്ളവൻ ആകുമ്പോൾ ശുദ്ധികരണത്തിന്നായി ഏഴുദിവസം എണ്ണീട്ടു വസ്ത്രം അലക്കി ദേഹം ഒഴുക്കുവെള്ളത്തിൽ കഴുകേണം; എന്നാൽ അവൻ ശുദ്ധിയുള്ളവൻ ആകും. ");
INSERT INTO mal2015_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","എട്ടാം ദിവസം അവൻ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ എടുത്തു സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ യഹോവയുടെ സന്നിധിയിൽ വന്നു അവയെ പുരോഹിതന്റെ പക്കൽ കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","പുരോഹിതൻ അവയിൽ ഒന്നിനെ പാപയാഗമായിട്ടും മറ്റേതിനെ ഹോമയാഗമായിട്ടും അർപ്പിക്കേണം; ഇങ്ങനെ പുരോഹിതൻ അവന്നുവേണ്ടി യഹോവയുടെ സന്നിധിയിൽ അവന്റെ സ്രവത്തിന്നു പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","ഒരുത്തന്നു ബീജം പോയാൽ അവൻ തന്റെ ദേഹം മുഴുവനും വെള്ളത്തിൽ കഴുകുകയും സന്ധ്യവരെ അശുദ്ധൻ ആയിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ബീജം വീണസകലവസ്ത്രവും എല്ലാതോലും വെള്ളത്തിൽ കഴുകുകയും അതു സന്ധ്യവരെ അശുദ്ധമായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","പുരുഷനും സ്ത്രീയും തമ്മിൽ ബീജസ്ഖലനത്തോടുകൂടെ ശയിച്ചാൽ ഇരുവരും വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധരായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","ഒരു സ്ത്രീക്കു സ്രവമുണ്ടായി അവളുടെ അംഗസ്രവം രക്തം ആയിരുന്നാൽ അവൾ ഏഴു ദിവസം അശുദ്ധയായിരിക്കേണം; അവളെ തൊടുന്നവനെല്ലാം സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","അവളുടെ അശുദ്ധിയിൽ അവൾ ഏതിന്മേലെങ്കിലും കിടന്നാൽ അതൊക്കെയും അശുദ്ധമായിരിക്കേണം; അവൾ ഏതിന്മേലെങ്കിലും ഇരുന്നാൽ അതൊക്കെയും അശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","അവളുടെ കിടക്ക തൊടുന്നവനെല്ലാം വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","അവൾ ഇരുന്ന ഏതൊരു സാധനവും തൊടുന്നവനെല്ലാം വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","അവളുടെ കിടക്കമേലോ അവൾ ഇരുന്നതിന്മേലോ ഉള്ള ഏതൊന്നെങ്കിലും തൊടുന്നവൻ സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ഒരുത്തൻ അവളോടുകൂടെ ശയിക്കയും അവളുടെ അശുദ്ധി അവന്മേൽ ആകയും ചെയ്താൽ അവൻ ഏഴു ദിവസം അശുദ്ധനായിരിക്കേണം; അവൻ കിടക്കുന്ന കിടക്ക ഒക്കെയും അശുദ്ധമാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ഒരു സ്ത്രീക്കു ഋതുകാലത്തല്ലാതെ രക്തസ്രവം ഏറിയ ദിവസം ഉണ്ടാകയോ ഋതുകാലം കവിഞ്ഞു സ്രവിക്കയോ ചെയ്താൽ അവളുടെ അശുദ്ധിയുടെ സ്രവകാലം ഒക്കെയും ഋതുകാലംപോലെ ഇരിക്കേണം; അവൾ അശുദ്ധയായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","രക്തസ്രവമുള്ള കാലത്തെല്ലാം അവൾ കിടക്കുന്ന കിടക്കയൊക്കെയും ഋതുകാലത്തിലെ കിടക്കപോലെ ഇരിക്കേണം; അവൾ ഇരിക്കുന്ന സാധനമൊക്കെയും ഋതുകാലത്തിലെ അശുദ്ധിപോലെ അശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","അവ തൊടുന്നവനെല്ലാം അശുദ്ധനാകും; അവൻ വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","രക്തസ്രവം മാറി ശുദ്ധിയുള്ളവളായാൽ അവൾ ഏഴു ദിവസം എണ്ണിക്കൊള്ളേണം; അതിന്റെ ശേഷം അവൾ ശുദ്ധിയുള്ളവളാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","എട്ടാം ദിവസം അവൾ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ എടുത്തു സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","പുരോഹിതൻ ഒന്നിനെ പാപയാഗമായിട്ടും മറ്റേതിനെ ഹോമയാഗമായിട്ടും അർപ്പിക്കേണം; ഇങ്ങനെ പുരോഹിതൻ അവൾക്കു വേണ്ടി യഹോവയുടെ സന്നിധിയിൽ അവളുടെ അശുദ്ധിയുടെ രക്തസ്രവംനിമിത്തം പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","യിസ്രായേൽമക്കളുടെ നടുവിലുള്ള എന്റെ നിവാസം അവർ അശുദ്ധമാക്കീട്ടു തങ്ങളുടെ അശുദ്ധികളിൽ മരിക്കാതിരിക്കേണ്ടതിന്നു നിങ്ങൾ അവരുടെ അശുദ്ധിയെക്കുറിച്ചു അവരെ ഇങ്ങനെ പ്രബോധിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ഇതു സ്രവക്കാരന്നും ബീജസ്ഖലനത്താൽ അശുദ്ധനായവനും ");
INSERT INTO mal2015_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ഋതുസംബന്ധമായ ദീനമുള്ളവൾക്കും സ്രവമുള്ള പുരുഷന്നും സ്ത്രീക്കും അശുദ്ധയോടുകൂടെ ശയിക്കുന്നവന്നും ഉള്ള പ്രമാണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","അഹരോന്റെ രണ്ടുപുത്രന്മാർ യഹോവയുടെ സന്നിധിയിൽ അടുത്തുചെന്നിട്ടു മരിച്ചുപോയ ശേഷം യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","കൃപാസനത്തിന്മീതെ മേഘത്തിൽ ഞാൻ വെളിപ്പെടുന്നതുകൊണ്ടു നിന്റെ സഹോദരനായ അഹരോൻ മരിക്കാതിരിക്കേണ്ടതിന്നു വിശുദ്ധമന്ദിരത്തിൽ തിരശ്ശീലെക്കകത്തു പെട്ടകത്തിന്മേലുള്ള കൃപാസനത്തിൻ മുമ്പിൽ എല്ലാസമയത്തും വരരുതു എന്നു അവനോടു പറയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","പാപയാഗത്തിന്നു ഒരു കാളക്കിടാവിനോടും ഹോമയാഗത്തിന്നു ഒരു ആട്ടുകൊറ്റനോടുംകൂടെ അഹരോൻ വിശുദ്ധമന്ദിരത്തിൽ കടക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","അവൻ പഞ്ഞിനൂൽകൊണ്ടുള്ള വിശുദ്ധമായ അങ്കി ധരിച്ചു ദേഹത്തിൽ പഞ്ഞിനൂൽകൊണ്ടുള്ള കാൽചട്ട ഇട്ടു പഞ്ഞിനൂൽകൊണ്ടുള്ള നടുക്കെട്ടു കെട്ടി പഞ്ഞിനൂൽകൊണ്ടുള്ള മുടിയും വെക്കേണം; ഇവ വിശുദ്ധവസ്ത്രം ആകയാൽ അവൻ ദേഹം വെള്ളത്തിൽ കഴുകീട്ടു അവയെ ധരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","അവൻ യിസ്രായേൽമക്കളുടെ സഭയുടെ പക്കൽനിന്നു പാപയാഗത്തിന്നു രണ്ടു കോലാട്ടുകൊറ്റനെയും ഹോമയാഗത്തിന്നു ഒരു ആട്ടുകൊറ്റനെയും വാങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","തനിക്കുവേണ്ടിയുള്ള പാപയാഗത്തിന്റെ കാളയെ അഹരോൻ അർപ്പിച്ചു തനിക്കും കുടുംബത്തിന്നുംവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","അവൻ ആ രണ്ടു കോലാട്ടുകൊറ്റനെ കൊണ്ടുവന്നു സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ യഹോവയുടെ സന്നിധിയിൽ നിർത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","പിന്നെ അഹരോൻ യഹോവെക്കു എന്നു ഒരു ചീട്ടും അസസ്സേലിന്നു എന്നു മറ്റൊരു ചീട്ടും ഇങ്ങനെ രണ്ടു കോലാട്ടുകൊറ്റനും ചീട്ടിടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","യഹോവെക്കുള്ള ചീട്ടു വീണ കോലാട്ടുകൊറ്റനെ അഹരോൻ കൊണ്ടുവന്നു പാപയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","അസസ്സേലിന്നു ചീട്ടു വീണ കോലാട്ടുകൊറ്റനെയോ, അതിനാൽ പ്രായശ്ചിത്തം കഴിക്കേണ്ടതിന്നും അതിനെ അസസ്സേലിന്നു മരുഭൂമിയിലേക്കു വിട്ടയക്കേണ്ടതിന്നുമായി യഹോവയുടെ സന്നിധിയിൽ ജീവനോടെ നിർത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","പിന്നെ തനിക്കുവേണ്ടിയുള്ള പാപയാഗത്തിന്റെ കാളയെ അഹരോൻ അർപ്പിച്ചു തനിക്കും കുടുംബത്തിന്നുംവേണ്ടി പ്രായശ്ചിത്തം കഴിച്ചു തനിക്കുവേണ്ടിയുള്ള പാപയാഗത്തിന്റെ കാളയെ അറുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","അവൻ യഹോവയുടെ സന്നിധിയിൽ യാഗപീഠത്തിന്മേൽ ഉള്ള തീക്കനൽ ഒരു കലശത്തിൽ നിറെച്ചു സൗരഭ്യമുള്ള ധൂപവർഗ്ഗചൂർണ്ണം കൈ നിറയ എടുത്തു തിരശ്ശീലക്കകത്തു കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","താൻ മരിക്കാതിരിക്കേണ്ടതിന്നു ധൂപത്തിന്റെ മേഘം സാക്ഷ്യത്തിന്മേലുള്ള കൃപാസനത്തെ മറെപ്പാൻ തക്കവണ്ണം അവൻ യഹോവയുടെ സന്നിധിയിൽ ധൂപവർഗ്ഗം തീയിൽ ഇടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","അവൻ കാളയുടെ രക്തം കുറെ എടുത്തു വിരൽകൊണ്ടു കിഴക്കോട്ടു കൃപാസനത്തിന്മേൽ തളിക്കേണം; അവൻ രക്തം കുറെ തന്റെ വിരൽകൊണ്ടു കൃപാസനത്തിന്റെ മുമ്പിലും ഏഴു പ്രാവശ്യം തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","പിന്നെ അവൻ ജനത്തിന്നുവേണ്ടിയുള്ള പാപയാഗത്തിന്റെ കോലാട്ടുകൊറ്റനെ അറുത്തു രക്തം തിരശ്ശീലെക്കകത്തു കൊണ്ടുവന്നു കാളയുടെ രക്തംകൊണ്ടു ചെയ്തതുപോലെ ഇതിന്റെ രക്തംകൊണ്ടും ചെയ്തു അതിനെ കൃപാസനത്തിന്മേലും കൃപാസനത്തിന്റെ മുമ്പിലും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","യിസ്രായേൽമക്കളുടെ അശുദ്ധികൾ നിമിത്തവും അവരുടെ സകലപാപവുമായ ലംഘനങ്ങൾ നിമിത്തവും അവൻ വിശുദ്ധമന്ദിരത്തിന്നു പ്രായശ്ചിത്തം കഴിക്കേണം; അവരുടെ ഇടയിൽ അവരുടെ അശുദ്ധിയുടെ നടുവിൽ ഇരിക്കുന്ന സമാഗമനകൂടാരത്തിന്നും അവൻ അങ്ങനെതന്നേ ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","അവൻ വിശുദ്ധമന്ദിരത്തിൽ പ്രായശ്ചിത്തം കഴിപ്പാൻ കടന്നിട്ടു പുറത്തു വരുന്നതുവരെ സമാഗമനകൂടാരത്തിൽ ആരും ഉണ്ടായിരിക്കരുതു; ഇങ്ങനെ അവൻ തനിക്കും കുടുംബത്തിന്നും യിസ്രായേലിന്റെ സർവ്വസഭെക്കും വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","പിന്നെ അവൻ യഹോവയുടെ സന്നിധിയിലുള്ള യാഗപീഠത്തിങ്കൽ ചെന്നു അതിന്നും പ്രായശ്ചിത്തം കഴിക്കേണം. കാളയുടെ രക്തവും കോലാട്ടുകൊറ്റന്റെ രക്തവും കുറേശ്ശ എടുത്തു പീഠത്തിന്റെ കൊമ്പുകളിൽ ചുറ്റും പുരട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","അവൻ രക്തം കുറെ വിരൽകൊണ്ടു ഏഴു പ്രാവശ്യം അതിന്മേൽ തളിച്ചു യിസ്രായേൽമക്കളുടെ അശുദ്ധികളെ നീക്കി വെടിപ്പാക്കി ശുദ്ധീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","അവൻ വിശുദ്ധമന്ദിരത്തിന്നും സമാഗമനകൂടാരത്തിന്നും യാഗപീഠത്തിന്നും ഇങ്ങനെ പ്രായശ്ചിത്തം കഴിച്ചു തീർന്നശേഷം ജീവനോടിരിക്കുന്ന കോലാട്ടുകൊറ്റനെ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ജീവനോടിരിക്കുന്ന കോലാട്ടുകൊറ്റന്റെ തലയിൽ അഹരോൻ കൈ രണ്ടും വെച്ചു യിസ്രായേൽമക്കളുടെ എല്ലാകുറ്റങ്ങളും സകലപാപങ്ങളുമായ ലംഘനങ്ങളൊക്കെയും ഏറ്റുപറഞ്ഞു കോലാട്ടുകൊറ്റന്റെ തലയിൽ ചുമത്തി, നിയമിക്കപ്പെട്ട ഒരു ആളുടെ കൈവശം അതിനെ മരുഭൂമിയിലേക്കു അയക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","കോലാട്ടുകൊറ്റൻ അവരുടെ കുറ്റങ്ങളെ ഒക്കെയും ശൂന്യപ്രദേശത്തേക്കു ചുമന്നുകൊണ്ടുപോകേണം; അവൻ കോലാട്ടുകൊറ്റനെ മരുഭൂമിയിൽ വിടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","പിന്നെ അഹരോൻ സമാഗമനകൂടാരത്തിൽ വന്നു താൻ വിശുദ്ധമന്ദിരത്തിൽ കടന്നപ്പോൾ ധരിച്ചിരുന്ന പഞ്ഞിനൂൽവസ്ത്രം നീക്കി അവിടെ വെച്ചേക്കണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","അവൻ ഒരു വിശുദ്ധസ്ഥലത്തുവെച്ചു വെള്ളംകൊണ്ടു ദേഹം കഴുകി സ്വന്തവസ്ത്രം ധരിച്ചു പുറത്തുവന്നു തന്റെ ഹോമയാഗവും ജനത്തിന്റെ ഹോമയാഗവും അർപ്പിച്ചു തനിക്കും ജനത്തിന്നും വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","അവൻ പാപയാഗത്തിന്റെ മേദസ്സു യാഗപീഠത്തിന്മേൽ ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ആട്ടുകൊറ്റനെ അസസ്സേലിന്നു കൊണ്ടുപോയി വിട്ടവൻ വസ്ത്രം അലക്കി ദേഹം വെള്ളത്തിൽ കഴുകീട്ടുമാത്രമേ പാളയത്തിൽ വരാവു. ");
INSERT INTO mal2015_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","വിശുദ്ധമന്ദിരത്തിൽ പ്രായശ്ചിത്തം കഴിക്കേണ്ടതിന്നു രക്തം കൊണ്ടുപോയ പാപയാഗത്തിന്റെ കാളയെയും കോലാട്ടുകൊറ്റനെയും പാളയത്തിന്നു പുറത്തു കൊണ്ടുപോകേണം; അവയുടെ തോലും മാംസവും ചാണകവും തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","അവയെ ചുട്ടുകളഞ്ഞവൻ വസ്ത്രം അലക്കി ദേഹം വെള്ളത്തിൽ കഴുകീട്ടു മാത്രമേ പാളയത്തിൽ വരാവു. ");
INSERT INTO mal2015_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","ഇതു നിങ്ങൾക്കു എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം; ഏഴാം മാസം പത്താം തിയ്യതി നിങ്ങൾ ആത്മതപനം ചെയ്യേണം; സ്വദേശിയും നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പരദേശിയും യാതൊരു വേലെയും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ആ ദിവസത്തിൽ അല്ലോ യഹോവയുടെ സന്നിധിയിൽ നിങ്ങളെ ശുദ്ധീകരിക്കേണ്ടതിന്നു നിങ്ങൾക്കു വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കയും നിങ്ങളുടെ സകലപാപങ്ങളും നീക്കി നിങ്ങളെ ശുദ്ധീകരിക്കയും ചെയ്യുന്നതു. ");
INSERT INTO mal2015_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","അതു നിങ്ങൾക്കു വിശുദ്ധസ്വസ്ഥതയുള്ള ശബ്ബത്ത് ആയിരിക്കേണം. നിങ്ങൾ ആത്മ തപനം ചെയ്യേണം; അതു നിങ്ങൾക്കു എന്നേക്കുമുള്ള ചട്ടമാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","അപ്പന്നു പകരം പുരോഹിതശുശ്രൂഷചെയ്‌വാൻ അഭിഷേകം പ്രാപിക്കയും പ്രതിഷ്ഠിക്കപ്പെടുകയും ചെയ്ത പുരോഹിതൻ തന്നേ പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","അവൻ വിശുദ്ധവസ്ത്രമായ പഞ്ഞിനൂൽവസ്ത്രം ധരിച്ചു വിശുദ്ധമന്ദിരത്തിന്നു പ്രായശ്ചിത്തം കഴിക്കേണം; സമാഗമനകൂടാരത്തിന്നും യാഗപീഠത്തിന്നും പ്രായശ്ചിത്തം കഴിക്കേണം; പുരോഹിതന്മാർക്കും സഭയിലെ സകലജനത്തിന്നും വേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","സംവത്സരത്തിൽ ഒരിക്കൽ യിസ്രായേൽമക്കൾക്കുവേണ്ടി അവരുടെ സകലപാപങ്ങൾക്കായിട്ടും പ്രായശ്ചിത്തം കഴിക്കേണ്ടതിന്നു ഇതു നിങ്ങൾക്കു എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ അവൻ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","നീ അഹരോനോടും പുത്രന്മാരോടും എല്ലായിസ്രായേൽമക്കളോടും പറയേണ്ടതു എന്തെന്നാൽ: യഹോവ കല്പിച്ച കാര്യം ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","യിസ്രായേൽഗൃഹത്തിൽ ആരെങ്കിലും കാളയെയോ ആട്ടിൻകുട്ടിയെയോ കോലാടിനെയോ പാളയത്തിൽവെച്ചെങ്കിലും പാളയത്തിന്നു പുറത്തുവെച്ചെങ്കിലും അറുക്കയും ");
INSERT INTO mal2015_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","അതിനെ യഹോവയുടെ കൂടാരത്തിന്റെ മുമ്പിൽ യഹോവെക്കു വഴിപാടായി അർപ്പിക്കേണ്ടതിന്നു സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ കൊണ്ടുവരാതിരിക്കയും ചെയ്താൽ അതു അവന്നു രക്തപാതകമായി എണ്ണേണം; അവൻ രക്തം ചൊരിയിച്ചു; ആ മനുഷ്യനെ അവന്റെ ജനത്തിന്റെ നടുവിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","യിസ്രായേൽമക്കൾ വെളിമ്പ്രദേശത്തുവെച്ചു അർപ്പിച്ചുവരുന്ന യാഗങ്ങളെ യഹോവെക്കു സമാധാനയാഗങ്ങളായി അർപ്പിക്കേണ്ടതിന്നു സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ പുരോഹിതന്റെ അടുക്കൽ യഹോവയുടെ സന്നിധിയിൽ കൊണ്ടുവരേണ്ടതാകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","പുരോഹിതൻ അവയുടെ രക്തം സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ യഹോവയുടെ യാഗപീഠത്തിന്മേൽ തളിച്ചു മേദസ്സു യഹോവെക്കു സൗരഭ്യവാസനയായി ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","അവർ പരസംഗമായി പിന്തുടരുന്ന ഭൂതങ്ങൾക്കു ഇനി തങ്ങളുടെ ബലികൾ അർപ്പിക്കരുതു; ഇതു തലമുറതലമുറയായി അവർക്കു എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","നീ അവരോടു പറയേണ്ടതു എന്തെന്നാൽ: യിസ്രായേൽഗൃഹത്തിലോ നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പരദേശികളിലോ ആരെങ്കിലും ഹോമയാഗമോ ഹനനയാഗമോ അർപ്പിക്കയും ");
INSERT INTO mal2015_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","അതു യഹോവെക്കു അർപ്പിക്കേണ്ടതിന്നു സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ കൊണ്ടുവരാതിരിക്കയും ചെയ്താൽ അവനെ അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","യിസ്രായേൽഗൃഹത്തിലോ നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പരദേശികളിലോ ആരെങ്കിലും വല്ല രക്തവും ഭക്ഷിച്ചാൽ രക്തം ഭക്ഷിച്ചവന്റെ നേരെ ഞാൻ ദൃഷ്ടിവെച്ചു അവനെ അവന്റെ ജനത്തിന്റെ ഇടയിൽനിന്നു ഛേദിച്ചുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","മാംസത്തിന്റെ ജീവൻ രക്തത്തിൽ അല്ലോ ഇരിക്കുന്നതു; യാഗപീഠത്തിന്മേൽ നിങ്ങൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിപ്പാൻ ഞാൻ അതു നിങ്ങൾക്കു തന്നിരിക്കുന്നു; രക്തമല്ലോ ജീവൻമൂലമായി പ്രായശ്ചിത്തം ആകുന്നതു. ");
INSERT INTO mal2015_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","അതുകൊണ്ടത്രേ നിങ്ങളിൽ യാതൊരുത്തനും രക്തം ഭക്ഷിക്കരുതു; നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പരദേശിയും രക്തം ഭക്ഷിക്കരുതു എന്നു ഞാൻ യിസ്രായേൽ മക്കളോടു കല്പിച്ചതു. ");
INSERT INTO mal2015_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","യിസ്രായേൽമക്കളിലോ നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പരദേശികളിലോ ആരെങ്കിലും തിന്നാകുന്ന ഒരു മൃഗത്തെയോ പക്ഷിയെയോ വേട്ടയാടി പിടിച്ചാൽ അവൻ അതിന്റെ രക്തം കളഞ്ഞു മണ്ണിട്ടു മൂടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","സകലജഡത്തിന്റെയും ജീവൻ അതിന്റെ ജീവാധാരമായ രക്തം തന്നേ. അതുകൊണ്ടത്രേ ഞാൻ യിസ്രായേൽമക്കളോടു: യാതൊരു ജഡത്തിന്റെ രക്തവും നിങ്ങൾ ഭക്ഷിക്കരുതു എന്നു കല്പിച്ചതു; സകലജഡത്തിന്റെയും ജീവൻ അതിന്റെ രക്തമല്ലോ; അതു ഭക്ഷിക്കുന്നവനെയെല്ലാം ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","താനേ ചത്തതിനെയോ പറിച്ചുകീറിപ്പോയതിനെയോ തിന്നുന്നവനൊക്കെയും സ്വദേശിയായാലും പരദേശിയായാലും വസ്ത്രം അലക്കി വെള്ളത്തിൽ കുളിക്കയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം; പിന്നെ അവൻ ശുദ്ധിയുള്ളവനാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","വസ്ത്രം അലക്കാതെയും ദേഹം കഴുകാതെയും ഇരുന്നാൽ അവൻ കുറ്റം വഹിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു; ");
INSERT INTO mal2015_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","നിങ്ങൾ പാർത്തിരുന്ന മിസ്രയീംദേശത്തിലെ നടപ്പുപോലെ നിങ്ങൾ നടക്കരുതു; ഞാൻ നിങ്ങളെ കൊണ്ടുപോകുന്ന കനാൻദേശത്തിലെ നടപ്പുപോലെയും അരുതു; അവരുടെ മര്യാദ ആചരിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","എന്റെ വിധികളെ അനുസരിച്ചു എന്റെ ചട്ടങ്ങളെ പ്രമാണിച്ചു നടക്കേണം; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ആകയാൽ എന്റെ ചട്ടങ്ങളും ന്യായങ്ങളും നിങ്ങൾ പ്രമാണിക്കേണം; അവയെ ചെയ്യുന്ന മനുഷ്യൻ അവയാൽ ജീവിക്കും; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","നിങ്ങളിൽ ആരും തനിക്കു രക്തസംബന്ധമുള്ള യാതൊരുത്തരുടെയും നഗ്നത അനാവൃതമാക്കുവാൻ തക്കവണ്ണം അവരോടു അടുക്കരുതു; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","നിന്റെ അപ്പന്റെ നഗ്നതയും അമ്മയുടെ നഗ്നതയും അനാവൃതമാക്കരുതു. അവൾ നിന്റെ അമ്മയാകുന്നു; അവളുടെ നഗ്നത അനാവൃതമാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","അപ്പന്റെ ഭാര്യയുടെ നഗ്നത അനാവൃതമാക്കരുതു; അതു നിന്റെ അപ്പന്റെ നഗ്നതയല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","അപ്പന്റെ മകളോ അമ്മയുടെ മകളോ ആയ നിന്റെ സഹോദരിയുടെ നഗ്നത അനാവൃതമാക്കരുതു; വീട്ടിൽ ജനിച്ചവരായാലും പുറമെ ജനിച്ചവരായാലും അവരുടെ നഗ്നത അനാവൃതമാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","നിന്റെ മകന്റെ മകളുടെ നഗ്നതയോ മകളുടെ മകളുടെ നഗ്നതയോ അനാവൃതമാക്കരുതു; അവരുടെ നഗ്നത നിന്റേതു തന്നേയല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","നിന്റെ അപ്പന്നു ജനിച്ചവളും അവന്റെ ഭാര്യയുടെ മകളുമായവളുടെ നഗ്നത അനാവൃതമാക്കരുതു; അവൾ നിന്റെ സഹോദരിയല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","അപ്പന്റെ സഹോദരിയുടെ നഗ്നത അനാവൃതമാക്കരുതു; അവൾ അപ്പന്റെ അടുത്ത ചാർച്ചക്കാരത്തിയല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","അമ്മയുടെ സഹോദരിയുടെ നഗ്നത അനാവൃതമാക്കരുതു; അവൾ നിന്റെ അമ്മയുടെ അടുത്ത ചാർച്ചക്കാരത്തിയല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","അപ്പന്റെ സഹോദരന്റെ നഗ്നത അനാവൃതമാക്കരുതു; അവന്റെ ഭാര്യയോടു അടുക്കയുമരുതു; അവൾ നിന്റെ ഇളയമ്മയല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","നിന്റെ മരുമകളുടെ നഗ്നത അനാവൃതമാക്കരുതു; അവൾ നിന്റെ മകന്റെ ഭാര്യ അല്ലോ; അവളുടെ നഗ്നത അനാവൃതമാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","സഹോദരന്റെ ഭാര്യയുടെ നഗ്നത അനാവൃതമാക്കരുതു; അതു നിന്റെ സഹോദരന്റെ നഗ്നതയല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ഒരു സ്ത്രീയുടെയും അവളുടെ മകളുടെയും നഗ്നത അനാവൃതമാക്കരുതു; അവളുടെ മകന്റെയോ മകളുടെയോ മകളുടെ നഗ്നത അനാവൃതമാക്കുമാറു അവരെ പരിഗ്രഹിക്കരുതു: അവർ അടുത്ത ചാർച്ചക്കാരല്ലോ; അതു ദുഷ്കർമ്മം. ");
INSERT INTO mal2015_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ഭാര്യ ജീവനോടിരിക്കുമ്പോൾ അവളെ ദുഃഖിപ്പിപ്പാൻ അവളുടെ സഹോദരിയുടെ നഗ്നത അനാവൃതമാക്കുമാറു അവളെകൂടെ പരിഗ്രഹിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","ഒരു സ്ത്രീ ഋതു നിമിത്തം അശുദ്ധമായിരിക്കുമ്പോൾ അവളുടെ നഗ്നത അനാവൃതമാക്കുമാറു അവളോടു അടുക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","കൂട്ടുകാരന്റെ ഭാര്യയോടുകൂടെ ശയിച്ചു അവളെക്കൊണ്ടു നിന്നെ അശുദ്ധനാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","നിന്റെ സന്തതിയിൽ ഒന്നിനെയും മോലേക്കിന്നു അർപ്പിച്ചു നിന്റെ ദൈവത്തിന്റെ നാമത്തെ അശുദ്ധമാക്കരുതു; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","സ്ത്രീയോടു എന്നപോലെ പുരുഷനോടുകൂടെ ശയിക്കരുതു; അതു മ്ലേച്ഛത. ");
INSERT INTO mal2015_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","യാതൊരു മൃഗത്തോടുംകൂടെ ശയിച്ചു അതിനാൽ നിന്നെ അശുദ്ധനാക്കരുതു; യാതൊരു സ്ത്രീയും ഒരു മൃഗത്തോടും കൂടെ ശയിക്കേണ്ടതിന്നു അതിന്റെ മുമ്പിൽ നിൽക്കയും അരുതു; അതു നികൃഷ്ടം. ");
INSERT INTO mal2015_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","ഇവയിൽ ഒന്നുകൊണ്ടും നിങ്ങളെ തന്നേ അശുദ്ധരാക്കരുതു; ഞാൻ നിങ്ങളുടെ മുമ്പിൽ നിന്നു നീക്കിക്കളയുന്ന ജാതികൾ ഇവയാൽ ഒക്കെയും തങ്ങളെത്തന്നേ അശുദ്ധരാക്കിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ദേശവും അശുദ്ധമായിത്തീർന്നു; അതുകൊണ്ടു ഞാൻ അതിന്റെ അകൃത്യം അതിന്മേൽ സന്ദർശിക്കുന്നു; ദേശം തന്റെ നിവാസികളെ ഛർദ്ദിച്ചുകളയുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ഈ മ്ലേച്ഛത ഒക്കെയും നിങ്ങൾക്കു മുമ്പെ ആ ദേശത്തുണ്ടായിരുന്ന മനുഷ്യർ ചെയ്തു, ദേശം അശുദ്ധമായി തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","നിങ്ങൾക്കു മുമ്പെ ഉണ്ടായിരുന്ന ജാതികളെ ദേശം ഛർദ്ദിച്ചുകളഞ്ഞതുപോലെ നിങ്ങൾ അതിനെ അശുദ്ധമാക്കീട്ടു നിങ്ങളെയും ഛർദ്ദിച്ചുകളയാതിരിപ്പാൻ നിങ്ങൾ എന്റെ ചട്ടങ്ങളും വിധികളും പ്രമാണിക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ഈ മ്ലേച്ഛതകളിൽ യാതൊന്നും സ്വദേശിയാകട്ടെ നിങ്ങളുടെ ഇടയിൽ പാർക്കുന്ന പരദേശിയാകട്ടെ ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ആരെങ്കിലും ഈ സകലമ്ലേച്ഛതകളിലും ഏതെങ്കിലും ചെയ്താൽ അങ്ങനെ ചെയ്യുന്നവരെ അവരുടെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ആകയാൽ നിങ്ങൾക്കു മുമ്പെ നടന്ന ഈ മ്ലേച്ഛമര്യാദകളിൽ യാതൊന്നും ചെയ്യാതെയും അവയാൽ അശുദ്ധരാകാതെയും ഇരിപ്പാൻ നിങ്ങൾ എന്റെ പ്രമാണങ്ങളെ പ്രമാണിക്കേണം; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","നീ യിസ്രായേൽമക്കളുടെ സർവ്വസഭയോടും പറയേണ്ടതു എന്തെന്നാൽ: നിങ്ങളുടെ ദൈവമായ യഹോവ എന്ന ഞാൻ വിശുദ്ധനാകയാൽ നിങ്ങളും വിശുദ്ധരായിരിപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","നിങ്ങൾ ഓരോരുത്തൻ താന്താന്റെ അമ്മയെയും അപ്പനെയും ഭയപ്പെടേണം; എന്റെ ശബ്ബത്തുകൾ പ്രമാണിക്കേണം: ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","വിഗ്രഹങ്ങളുടെ അടുക്കലേക്കു തിരിയരുതു; ദേവന്മാരെ നിങ്ങൾക്കു വാർത്തുണ്ടാക്കരുതു; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","യഹോവെക്കു സമാധാനയാഗം അർപ്പിക്കുന്നു എങ്കിൽ നിങ്ങൾക്കു പ്രസാദം ലഭിപ്പാൻ തക്കവണ്ണം അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","അർപ്പിക്കുന്ന ദിവസവും പിറ്റെന്നാളും അതു തിന്നാം; മൂന്നാം ദിവസംവരെ ശേഷിക്കുന്നതു തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","മൂന്നാം ദിവസം തിന്നു എന്നുവരികിൽ അതു അറെപ്പാകുന്നു; പ്രസാദമാകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","അതു തിന്നുന്നവൻ കുറ്റം വഹിക്കും; യഹോവെക്കു വിശുദ്ധമായതു അവൻ അശുദ്ധമാക്കിയല്ലോ; അവനെ അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","നിങ്ങളുടെ നിലത്തിലെ വിള നിങ്ങൾ കൊയ്യുമ്പോൾ വയലിന്റെ അരികു തീർത്തുകൊയ്യരുതു; നിന്റെ കൊയ്ത്തിൽ കാലാ പെറുക്കയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","നിന്റെ മുന്തിരിത്തോട്ടത്തിൽ കാലാ പറിക്കരുതു; നിന്റെ മുന്തിരിത്തോട്ടത്തിൽ വീണുകിടക്കുന്ന പഴം പെറുക്കയും അരുതു. അവയെ ദരിദ്രന്നും പരദേശിക്കും വിട്ടേക്കേണം; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","മോഷ്ടിക്കരുതു, ചതിക്കരുതു, ഒരുത്തനോടു ഒരുത്തൻ ഭോഷ്കുപറയരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","എന്റെ നാമത്തെക്കൊണ്ടു കള്ളസ്സത്യം ചെയ്തു നിന്റെ ദൈവത്തിന്റെ നാമത്തെ അശുദ്ധമാക്കരുതു; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","കൂട്ടുകാരനെ പീഡിപ്പിക്കരുതു; അവന്റെ വസ്തു കവർച്ച ചെയ്കയും അരുതു; കൂലിക്കാരന്റെ കൂലി പിറ്റേന്നു രാവിലെവരെ നിന്റെ പക്കൽ ഇരിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","ചെകിടനെ ശപിക്കരുതു; കുരുടന്റെ മുമ്പിൽ ഇടർച്ച വെക്കരുതു; നിന്റെ ദൈവത്തെ ഭയപ്പെടേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","ന്യായവിസ്താരത്തിൽ അന്യായം ചെയ്യരുതു; എളിയവന്റെ മുഖം നോക്കാതെയും വലിയവന്റെ മുഖം ആദരിക്കാതെയും നിന്റെ കൂട്ടുകാരന്നു നീതിയോടെ ന്യായം വിധിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","നിന്റെ ജനത്തിന്റെ ഇടയിൽ ഏഷണി പറഞ്ഞു നടക്കരുതു; കൂട്ടുകാരന്റെ മരണത്തിന്നായി നിഷ്കർഷിക്കരുതു; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","സഹോദരനെ നിന്റെ ഹൃദയത്തിൽ ദ്വേഷിക്കരുതു; കൂട്ടുകാരന്റെ പാപം നിന്റെ മേൽ വരാതിരിപ്പാൻ അവനെ താല്പര്യമായി ശാസിക്കേണം. പ്രതികാരം ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","നിന്റെ ജനത്തിന്റെ മക്കളോടു പക വെക്കരുതു; കൂട്ടുകാരനെ നിന്നെപ്പോലെ തന്നേ സ്നേഹിക്കേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","നിങ്ങൾ എന്റെ ചട്ടങ്ങൾ പ്രമാണിക്കേണം. രണ്ടുതരം മൃഗങ്ങളെ തമ്മിൽ ഇണ ചേർക്കരുതു; നിന്റെ വയലിൽ കൂട്ടുവിത്തു വിതെക്കരുതു; രണ്ടു വക സാധനം കലർന്ന വസ്ത്രം ധരിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ഒരു പുരുഷന്നു നിയമിച്ചവളും വീണ്ടെടുക്കപ്പെടുകയോ സ്വാതന്ത്ര്യം കിട്ടുകയോ ചെയ്യാത്തവളുമായ ഒരു ദാസിയോടുകൂടെ ഒരുത്തൻ ശയിച്ചാൽ അവരെ ശിക്ഷിക്കേണം. എന്നാൽ അവൾ സ്വാതന്ത്ര്യമില്ലാത്തവളായാൽ അവരെ കൊല്ലരുതു; ");
INSERT INTO mal2015_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","അവൻ യഹൊവെക്കു അകൃത്യയാഗത്തിന്നായി സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ ഒരു ആട്ടുകൊറ്റനെ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","അവൻ ചെയ്ത പാപത്തിന്നായി പുരോഹിതൻ അകൃത്യയാഗത്തിന്റെ ആട്ടുകൊറ്റനെക്കൊണ്ടു അവന്നു വേണ്ടി യഹോവയുടെ സന്നിധിയിൽ പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അവൻ ചെയ്ത പാപം അവനോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","നിങ്ങൾ ദേശത്തു എത്തി ഭക്ഷണത്തിന്നു ഉതകുന്ന സകലവിധവൃക്ഷങ്ങളും നട്ടശേഷം നിങ്ങൾക്കു അവയുടെ ഫലം പരിച്ഛേദന കഴിയാത്തതുപോലെ ആയിരിക്കേണം; അതു മൂന്നു സംവത്സരത്തേക്കു പരിച്ഛേദനയില്ലാത്തതുപോലെ ഇരിക്കേണം; അതു തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","നാലാം സംവത്സരത്തിൽ അതിന്റെ ഫലമെല്ലാം യഹോവയുടെ സ്തോത്രത്തിന്നായിട്ടു ശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","അഞ്ചാം സംവത്സരത്തിലോ നിങ്ങൾക്കു അതിന്റെ ഫലം തിന്നാം; അങ്ങനെ അതിന്റെ അനുഭവം നിങ്ങൾക്കു വർദ്ധിച്ചുവരും; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","രക്തത്തോടുകൂടിയുള്ളതു തിന്നരുതു; ആഭിചാരം ചെയ്യരുതു; മുഹൂർത്തം നോക്കരുതു; ");
INSERT INTO mal2015_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","നിങ്ങളുടെ തലമുടി ചുറ്റും വിളുമ്പു വടിക്കരുതു; താടിയുടെ അറ്റം വിരൂപമാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","മരിച്ചവന്നുവേണ്ടി ശരീരത്തിൽ മുറിവുണ്ടാക്കരുതു; മെയ്മേൽ പച്ചകുത്തരുതു; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","ദേശം വേശ്യാവൃത്തി ചെയ്തു ദുഷ്കർമ്മംകൊണ്ടു നിറയാതിരിക്കേണ്ടതിന്നു നിന്റെ മകളെ വേശ്യാവൃത്തിക്കു ഏല്പിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","നിങ്ങൾ എന്റെ ശബ്ബത്തുകൾ പ്രമാണിക്കയും എന്റെ വിശുദ്ധമന്ദിരത്തോടു ഭയഭക്തിയുള്ളവരായിരിക്കയും വേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","വെളിച്ചപ്പാടന്മാരുടെയും മന്ത്രവാദികളുടെയും അടുക്കൽ പോകരുതു. അവരാൽ അശുദ്ധരായ്തീരുവാൻ തക്കവണ്ണം അവരെ അന്വേഷിക്കയും അരുതു. ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","നരച്ചവന്റെ മുമ്പാകെ എഴുന്നേൽക്കയും വൃദ്ധന്റെ മുഖം ബഹുമാനിക്കയും നിന്റെ ദൈവത്തെ ഭയപ്പെടുകയും വേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","പരദേശി നിന്നോടുകൂടെ നിങ്ങളുടെ ദേശത്തു പാർത്താൽ അവനെ ഉപദ്രവിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","നിങ്ങളോടുകൂടെ പാർക്കുന്ന പരദേശി നിങ്ങൾക്കു സ്വദേശിയെപ്പോലെ ഇരിക്കേണം; അവനെ നിന്നെപ്പോലെ തന്നേ സ്നേഹിക്കേണം; നിങ്ങളും മിസ്രയീംദേശത്തു പരദേശികളായിരുന്നുവല്ലോ; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","ന്യായവിസ്താരത്തിലും അളവിലും തൂക്കത്തിലും നിങ്ങൾ അന്യായം ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ഒത്ത തുലാസ്സും ഒത്ത കട്ടിയും ഒത്ത പറയും ഒത്ത ഇടങ്ങഴിയും നിങ്ങൾക്കു ഉണ്ടായിരിക്കേണം; ഞാൻ നിങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെടുവിച്ച നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","നിങ്ങൾ എന്റെ എല്ലാചട്ടങ്ങളും സകലവിധികളും പ്രമാണിച്ചു അനുസരിക്കേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: യിസ്രായേൽമക്കളിലോ യിസ്രായേലിൽ വന്നു പാർക്കുന്ന പരദേശികളിലോ ആരെങ്കിലും തന്റെ സന്തതിയിൽ ഒന്നിനെ മോലെക്കിന്നു കൊടുത്താൽ അവൻ മരണശിക്ഷ അനുഭവിക്കേണം; ദേശത്തിലെ ജനം അവനെ കല്ലെറിയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","അവൻ തന്റെ സന്തതിയെ മോലെക്കിന്നു കൊടുത്തതിനാൽ എന്റെ വിശുദ്ധമന്ദിരം മലിനമാക്കുകയും എന്റെ വിശുദ്ധനാമം അശുദ്ധമാക്കുകയും ചെയ്തതുകൊണ്ടു ഞാൻ അവന്റെ നേരെ ദൃഷ്ടിവെച്ചു അവനെ അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","അവൻ തന്റെ സന്തതിയെ മോലെക്കിന്നു കൊടുക്കുമ്പോൾ ദേശത്തിലെ ജനം അവനെ കൊല്ലാതെ കണ്ണടെച്ചുകളഞ്ഞാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ഞാൻ അവനും കുടുംബത്തിന്നും നേരെ ദൃഷ്ടിവെച്ചു അവനെയും അവന്റെ പിന്നാലെ മോലെക്കിനോടു പരസംഗം ചെയ്‌വാൻ പോകുന്ന എല്ലാവരെയും അവരുടെ ജനത്തിന്റെ നടുവിൽനിന്നു ഛേദിച്ചുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","വെളിച്ചപ്പാടന്മാരുടെയും മന്ത്രവാദികളുടെയും പിന്നാലെ പരസംഗം ചെയ്‌വാൻ പോകുന്നവന്റെ നേരെയും ഞാൻ ദൃഷ്ടിവെച്ചു അവനെ അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","ആകയാൽ നിങ്ങൾ നിങ്ങളെത്തന്നേ ശുദ്ധീകരിച്ചു വിശുദ്ധന്മാരായിരിപ്പിൻ; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","എന്റെ ചട്ടങ്ങൾ പ്രമാണിച്ചു ആചരിപ്പിൻ; ഞാൻ നിങ്ങളെ ശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","അപ്പനെയോ അമ്മയെയോ ശപിക്കുന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം; അവൻ അപ്പനെയും അമ്മയെയും ശപിച്ചു; അവന്റെ രക്തം അവന്റെ മേൽ ഇരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","ഒരുത്തന്റെ ഭാര്യയുമായി വ്യഭിചാരം ചെയ്യുന്നവൻ, കൂട്ടുകാരന്റെ ഭാര്യയുമായി വ്യഭിചാരംചെയ്യുന്ന വ്യഭിചാരിയും വ്യഭിചാരിണിയും തന്നേ, മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","അപ്പന്റെ ഭാര്യയോടുകൂടെ ശയിക്കുന്നവൻ അപ്പന്റെ നഗ്നത അനാവൃതമാക്കുന്നു; ഇരുവരും മരണശിക്ഷ അനുഭവിക്കേണം; അവരുടെ രക്തം അവരുടെമേൽ ഇരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ഒരുത്തൻ മരുമകളോടുകൂടെ ശയിച്ചാൽ ഇരുവരും മരണശിക്ഷ അനുഭവിക്കേണം; അവർ നികൃഷ്ട കർമ്മം ചെയ്തു; അവരുടെ രക്തം അവരുടെമേൽ ഇരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","സ്ത്രീയോടുകൂടെ ശയിക്കുന്നതുപോലെ ഒരുത്തൻ പുരുഷനോടുകൂടെ ശയിച്ചാൽ ഇരുവരും മ്ലേച്ഛത ചെയ്തു; അവർ മരണശിക്ഷ അനുഭവിക്കേണം; അവരുടെ രക്തം അവരുടെമേൽ ഇരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ഒരു പുരുഷൻ ഒരു സ്ത്രീയെയും അവളുടെ അമ്മയെയും പരിഗ്രഹിച്ചാൽ അതു ദുഷ്കർമ്മം; നിങ്ങളുടെ ഇടയിൽ ദുഷ്കർമ്മം ഇല്ലാതിരിക്കേണ്ടതിന്നു അവനെയും അവരെയും തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ഒരു പുരുഷൻ മൃഗത്തോടുകൂടെ ശയിച്ചാൽ അവൻ മരണശിക്ഷ അനുഭവിക്കേണം; മൃഗത്തെയും കൊല്ലേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ഒരു സ്ത്രീ യാതൊരു മൃഗത്തോടെങ്കിലും ചേർന്നു ശയിച്ചാൽ സ്ത്രീയെയും മൃഗത്തെയും കൊല്ലേണം; അവർ മരണശിക്ഷ അനുഭവിക്കേണം; അവരുടെ രക്തം അവരുടെമേൽ ഇരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ഒരു പുരുഷൻ തന്റെ അപ്പന്റെ മകളോ അമ്മയുടെ മകളോ ആയ തന്റെ സഹോദരിയെ പരിഗ്രഹിച്ചു അവളുടെ നഗ്നത കാണുകയും അവൾ അവന്റെ നഗ്നത കാണുകയും ചെയ്താൽ അതു ലജ്ജാകരം; അവരെ അവരുടെ ജനത്തിന്റെ മുമ്പിൽവെച്ചു തന്നേ സംഹരിച്ചുകളയേണം; അവൻ സഹോദരിയുടെ നഗ്നത അനാവൃതമാക്കി; അവൻ തന്റെ കുറ്റം വഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ഒരു പുരുഷൻ ഋതുവായ സ്ത്രീയോടുകൂടെ ശയിച്ചു അവളുടെ നഗ്നത അനാവൃതമാക്കിയാൽ അവൻ അവളുടെ സ്രവം അനാവൃതമാക്കി; അവളും തന്റെ രക്തസ്രവം അനാവൃതമാക്കി; ഇരുവരെയും അവരുടെ ജനത്തിന്റെ ഇടയിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","നിന്റെ അമ്മയുടെ സഹോദരിയുടെയോ അപ്പന്റെ സഹോദരിയുടെയോ നഗ്നത അനാവൃതമാക്കരുതു; അങ്ങനെത്തവൻ തന്റെ അടുത്ത ചാർച്ചക്കാരത്തിയെ അനാവൃതയാക്കുന്നുവല്ലോ; അവർ തങ്ങളുടെ കുറ്റം വഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ഒരു പുരുഷൻ ഇളയപ്പന്റെ ഭാര്യയോടുകൂടെ ശയിച്ചാൽ അവൻ ഇളയപ്പന്റെ നഗ്നത അനാവൃതമാക്കി; അവർ തങ്ങളുടെ പാപം വഹിക്കും; അവർ സന്തതിയില്ലാത്തവരായി മരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ഒരുത്തൻ സഹോദരന്റെ ഭാര്യയെ പരിഗ്രഹിച്ചാൽ അതു മാലിന്യം; അവൻ സഹോദരന്റെ നഗ്നത അനാവൃതമാക്കി; അവർ സന്തതിയില്ലാത്തവർ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","ആകയാൽ നിങ്ങൾ കുടിയിരിക്കേണ്ടതിന്നു ഞാൻ നിങ്ങളെ കൊണ്ടുപോകുന്ന ദേശം നിങ്ങളെ ഛർദ്ദിച്ചുകളയാതിരിപ്പാൻ എന്റെ എല്ലാചട്ടങ്ങളും സകലവിധികളും പ്രമാണിച്ചു ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ഞാൻ നിങ്ങളുടെ മുമ്പിൽ നിന്നു നീക്കിക്കളയുന്ന ജാതിയുടെ ചട്ടങ്ങളെ അനുസരിച്ചു നടക്കരുതു; ഈ കാര്യങ്ങളെ ഒക്കെയും ചെയ്തതുകൊണ്ടു അവർ എനിക്കു അറെപ്പായി തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","നിങ്ങൾ അവരുടെ ദേശത്തെ കൈവശമാക്കും എന്നു ഞാൻ നിങ്ങളോടു കല്പിച്ചുവല്ലോ; പാലും തേനും ഒഴുകുന്ന ആ ദേശം നിങ്ങൾ കൈവശമാക്കേണ്ടതിന്നു ഞാൻ അതിനെ നിങ്ങൾക്കു തരും; ഞാൻ നിങ്ങളെ ജാതികളിൽനിന്നു വേറുതിരിച്ചവനായി നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ആകയാൽ ശുദ്ധിയുള്ള മൃഗവും ശുദ്ധിയില്ലാത്ത മൃഗവും തമ്മിലും, ശുദ്ധിയില്ലാത്ത പക്ഷിയും ശുദ്ധിയുള്ള പക്ഷിയും തമ്മിലും നിങ്ങൾ വ്യത്യാസം വെക്കേണം; ഞാൻ നിങ്ങൾക്കു അശുദ്ധമെന്നു വേറുതിരിച്ചിട്ടുള്ള മൃഗത്തെക്കൊണ്ടും പക്ഷിയെക്കൊണ്ടും നിലത്തു ഇഴയുന്ന യാതൊരു ജന്തുവിനെക്കൊണ്ടും നിങ്ങളെത്തന്നേ അറെപ്പാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","നിങ്ങൾ എനിക്കു വിശുദ്ധന്മാരായിരിക്കേണം; യഹോവയായ ഞാൻ വിശുദ്ധനാകകൊണ്ടു നിങ്ങളും എനിക്കു വിശുദ്ധന്മാരായിരിക്കേണം; നിങ്ങൾ എനിക്കുള്ളവരായിരിക്കേണ്ടതിന്നു ഞാൻ നിങ്ങളെ ജാതികളിൽ നിന്നു വേറുതിരിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","വെളിച്ചപ്പാടോ മന്ത്രവാദമോ ഉള്ള പുരുഷൻ ആകട്ടെ സ്ത്രീയാകട്ടെ മരണശിക്ഷ അനുഭവിക്കേണം; അവരെ കല്ലെറിഞ്ഞു കൊല്ലേണം; അവരുടെ രക്തം അവരുടെമേൽ ഇരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാരോടു പറയേണ്ടതെന്തെന്നാൽ: പുരോഹിതൻ തന്റെ ജനത്തിൽ ഒരുവന്റെ ശവത്താൽ തന്നെത്താൻ മലിനമാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","എന്നാൽ തന്റെ അമ്മ, അപ്പൻ, മകൻ, മകൾ, സഹോദരൻ, ");
INSERT INTO mal2015_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","തനിക്കടുത്തവളും ഭർത്താവില്ലാത്ത കന്യകയുമായ സഹോദരി എന്നിങ്ങിനെയുള്ള ഉററ ചാർച്ചക്കാരാൽ അവന്നു മലിനനാകാം. ");
INSERT INTO mal2015_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","അവൻ തന്റെ ജനത്തിൽ പ്രമാണിയായിരിക്കയാൽ തന്നെത്താൻ മലിനമാക്കി അശുദ്ധനാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","അവർ തലമുടി വടിക്കയും താടിയുടെ അറ്റം കത്രിക്കയും ശരീരത്തിൽ മുറിവുണ്ടാക്കുകയും അരുതു; ");
INSERT INTO mal2015_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","തങ്ങളുടെ ദൈവത്തിന്റെ നാമത്തെ അശുദ്ധമാക്കാതെ തങ്ങളുടെ ദൈവത്തിന്നു വിശുദ്ധന്മാരായിരിക്കേണം; അവർ തങ്ങളുടെ ദൈവത്തിന്റെ ഭോജനമായ യഹോവയുടെ ദഹനയാഗങ്ങൾ അർപ്പിക്കുന്നു; ആകയാൽ അവർ വിശുദ്ധന്മാരായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","വേശ്യയെയോ ദുർന്നടപ്പുകാരത്തിയെയോ അവർ വിവാഹം കഴിക്കരുതു; ഭർത്താവു ഉപേക്ഷിച്ചുകളഞ്ഞവളെയും വിവാഹം കഴിക്കരുതു; അവൻ തന്റെ ദൈവത്തിന്നു വിശുദ്ധൻ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","അതുകൊണ്ടു നീ അവനെ ശുദ്ധീകരിക്കേണം; അവൻ നിന്റെ ദൈവത്തിന്നു ഭോജനം അർപ്പിക്കുന്നവനാകയാൽ നീ അവനെ ശുദ്ധീകരിക്കേണം; അവൻ നിനക്കു വിശുദ്ധനായിരിക്കേണം; നിങ്ങളെ ശുദ്ധീകരിക്കുന്ന യഹോവയായ ഞാൻ വിശുദ്ധൻ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","പുരോഹിതന്റെ മകൾ ദുർന്നടപ്പു ചെയ്തു തന്നെത്താൻ അശുദ്ധയാക്കിയാൽ അവൾ തന്റെ അപ്പനെ അശുദ്ധനാക്കുന്നു; അവളെ തീയിൽ ഇട്ടു ചുട്ടുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","അഭിഷേകതൈലം തലയിൽ ഒഴിക്കപ്പെട്ടവനും വസ്ത്രം ധരിപ്പാൻ പ്രതിഷ്ഠിക്കപ്പെട്ടവനുമായി തന്റെ സഹോദരന്മാരിൽ മഹാപുരോഹിതനായവൻ തന്റെ തലമുടി പിച്ചിപ്പറിക്കയും വസ്ത്രം കീറുകയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","അവൻ യാതൊരു ശവത്തോടും അടുക്കുകയും തന്റെ അപ്പനാലോ അമ്മയാലോ അശുദ്ധനാകയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","വിശുദ്ധമന്ദിരം വിട്ടു അവൻ പുറത്തിറങ്ങുകയും തന്റെ ദൈവത്തിന്റെ വിശുദ്ധമന്ദിരം അശുദ്ധമാക്കുകയും അരുതു; അവന്റെ ദൈവത്തിന്റെ അഭിഷേകതൈലമായ സംസ്കാരം അവന്റെ മേൽ ഇരിക്കുന്നു; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","കന്യകയായ സ്ത്രീയെ മാത്രമേ അവൻ വിവാഹം കഴിക്കാവു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","വിധവ, ഉപേക്ഷിക്കപ്പെട്ടവൾ, ദുർന്നടപ്പുകാരത്തി, വേശ്യ ഇങ്ങനെയുള്ളവരെ അവൻ വിവാഹം കഴിക്കരുതു; സ്വജനത്തിലുള്ള കന്യകയെ മാത്രമേ വിവാഹം കഴിക്കാവു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","അവൻ തന്റെ സന്തതിയെ തന്റെ ജനത്തിന്റെ ഇടയിൽ അശുദ്ധമാക്കരുതു; ഞാൻ അവനെ ശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: നീ അഹരോനോടു പറയേണ്ടതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","നിന്റെ സന്തതിയിൽ അംഗഹീനനായവൻ നിന്റെ ദൈവത്തിന്റെ ഭോജനം അർപ്പിപ്പാൻ ഒരിക്കലും അടുത്തു വരരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","അംഗഹീനനായ യാതൊരുത്തനും അടുത്തുവരരുതു; കുരുടൻ, മുടന്തൻ, ");
INSERT INTO mal2015_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","പതിമൂക്കൻ, അധികാംഗൻ, കാലൊടിഞ്ഞവൻ, കയ്യൊടിഞ്ഞവൻ, ");
INSERT INTO mal2015_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","കൂനൻ, മുണ്ടൻ, പൂക്കണ്ണൻ, ചൊറിയൻ, പൊരിച്ചുണങ്ങൻ, ഷണ്ഡൻ എന്നിങ്ങനെയുള്ളവരും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","പുരോഹിതനായ അഹരോന്റെ സന്തതിയിൽ അംഗഹീനനായ ഒരുത്തനും യഹോവയുടെ ദഹനയാഗങ്ങൾ അർപ്പിപ്പാൻ അടുത്തുവരരുതു; അവൻ അംഗഹീനൻ; അവൻ തന്റെ ദൈവത്തിന്റെ ഭോജനം അർപ്പിപ്പാൻ അടുത്തുവരരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","തന്റെ ദൈവത്തിന്റെ ഭോജനമായ അതിപരിശുദ്ധമായവയും വിശുദ്ധമായവയും അവന്നു ഭക്ഷിക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","എങ്കിലും തിരശ്ശീലയുടെ അടുക്കൽ ചെല്ലുകയും യാഗപീഠത്തിങ്കൽ അടുത്തുവരികയും അരുതു; അവൻ അംഗഹീനനല്ലോ; അവൻ എന്റെ വിശുദ്ധസാധനങ്ങളെ അശുദ്ധമാക്കരുതു; ഞാൻ അവരെ ശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","മോശെ ഇതു അഹരോനോടും പുത്രന്മാരോടും എല്ലായിസ്രായേൽമക്കളോടും പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","യിസ്രായേൽമക്കൾ എനിക്കു ശുദ്ധീകരിക്കുന്ന വിശുദ്ധസാധനങ്ങളെ സംബന്ധിച്ചു അഹരോനും അവന്റെ പുത്രന്മാരും സൂക്ഷിച്ചുനിൽക്കേണമെന്നും എന്റെ വിശുദ്ധനാമത്തെ അശുദ്ധമാക്കരുതെന്നും അവരോടു പറയേണം. ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","നീ അവരോടു പറയേണ്ടതു എന്തെന്നാൽ: നിങ്ങളുടെ തലമുറകളിൽ നിങ്ങളുടെ സകലസന്തതിയിലും ആരെങ്കിലും അശുദ്ധനായിരിക്കുമ്പോൾ യിസ്രായേൽമക്കൾ യഹോവെക്കു ശുദ്ധീകരിക്കുന്ന വിശുദ്ധസാധനങ്ങളോടു അടുത്താൽ അവനെ എന്റെ മുമ്പിൽനിന്നു ഛേദിച്ചുകളയേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","അഹരോന്റെ സന്തതിയിൽ ആരെങ്കിലും കുഷ്ഠരോഗിയോ ശുക്ലസ്രവക്കാരനോ ആയാൽ അവൻ ശുദ്ധനായിത്തീരുംവരെ വിശുദ്ധസാധനങ്ങൾ ഭക്ഷിക്കരുതു; ശവത്താൽ അശുദ്ധമായ യാതൊന്നെങ്കിലും തൊടുന്നവനും ബീജസ്ഖലനം ഉണ്ടായവനും ");
INSERT INTO mal2015_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","അശുദ്ധിവരുത്തുന്ന യാതൊരു ഇഴജാതിയെ എങ്കിലും വല്ല അശുദ്ധിയുമുണ്ടായിട്ടു അശുദ്ധിവരുത്തുന്ന മനുഷ്യനെ എങ്കിലും തൊടുന്നവനും ");
INSERT INTO mal2015_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ഇങ്ങനെ തൊട്ടുതീണ്ടിയവൻ സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം; അവൻ ദേഹം വെള്ളത്തിൽ കഴുകിയല്ലാതെ വിശുദ്ധസാധനങ്ങൾ ഭക്ഷിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","സൂര്യൻ അസ്തമിച്ചശേഷം അവൻ ശുദ്ധനാകും; പിന്നെ അവന്നു വിശുദ്ധസാധനങ്ങൾ ഭക്ഷിക്കാം; അതു അവന്റെ ആഹാരമല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","താനേ ചത്തതിനെയും പറിച്ചുകീറിപ്പോയതിനെയും തിന്നിട്ടു തന്നെത്താൽ അശുദ്ധമാക്കരുതു; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ആകയാൽ അവർ എന്റെ പ്രമാണങ്ങളെ നിസ്സാരമാക്കി തങ്ങളുടെ മേൽ പാപം വരുത്തുകയും അതിനാൽ മരിക്കയും ചെയ്യാതിരിപ്പാൻ അവ പ്രമാണിക്കേണം; ഞാൻ അവരെ ശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","യാതൊരു അന്യനും വിശുദ്ധസാധനം ഭക്ഷിക്കരുതു; പുരോഹിതന്റെ അടുക്കൽ വന്നു പാർക്കുന്നവനും കൂലിക്കാരനും വിശുദ്ധസാധനം ഭക്ഷിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","എന്നാൽ പുരോഹിതൻ ഒരുത്തനെ വിലെക്കു വാങ്ങിയാൽ അവന്നും വീട്ടിൽ പിറന്നുണ്ടായവന്നും ഭക്ഷിക്കാം; ഇവർക്കു അവന്റെ ആഹാരം ഭക്ഷിക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","പുരോഹിതന്റെ മകൾ അന്യകുടുംബക്കാരന്നു ഭാര്യയായാൽ അവൾ വിശുദ്ധസാധനങ്ങളായ വഴിപാടു ഒന്നും ഭക്ഷിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","പുരോഹിതന്റെ മകൾ വിധവയോ ഉപേക്ഷിക്കപ്പെട്ടവളോ ആയി സന്തതിയില്ലാതെ അപ്പന്റെ വീട്ടിലേക്കു തന്റെ ബാല്യത്തിൽ എന്നപോലെ മടങ്ങിവന്നാൽ അവൾക്കു അപ്പന്റെ ആഹാരം ഭക്ഷിക്കാം; എന്നാൽ യാതൊരു അന്യനും അതു ഭക്ഷിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ഒരുത്തൻ അബദ്ധവശാൽ വിശുദ്ധസാധനം ഭക്ഷിച്ചുപോയാൽ അവൻ വിശുദ്ധസാധനം അഞ്ചിൽ ഒരംശവും കൂട്ടി പുരോഹിതന്നു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","യിസ്രായേൽമക്കൾ യഹോവെക്കു അർപ്പിക്കുന്ന വിശുദ്ധസാധനങ്ങൾ അശുദ്ധമാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","അവരുടെ വിശുദ്ധസാധനങ്ങൾ ഭക്ഷിക്കുന്നതിൽ അവരുടെ മേൽ അകൃത്യത്തിന്റെ കുറ്റം വരുത്തരുതു; ഞാൻ അവരെ ശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","നീ അഹരോനോടും പുത്രന്മാരോടും എല്ലായിസ്രായേൽമക്കളോടും പറയേണ്ടതു എന്തെന്നാൽ: യിസ്രായേൽഗൃഹത്തിലോ യിസ്രായേലിൽ ഉള്ള പരദേശികളിലോ ആരെങ്കിലും യഹോവെക്കു ഹോമയാഗമായിട്ടു അർപ്പിക്കുന്ന വല്ല നേർച്ചകളാകട്ടെ സ്വമേധാദാനങ്ങളാകട്ടെ ഇവയിൽ ഏതെങ്കിലും ഒരു വഴിപാടു കഴിക്കുന്നു എങ്കിൽ ");
INSERT INTO mal2015_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","നിങ്ങൾക്കു പ്രസാദം ലഭിപ്പാന്തക്കവണ്ണം അതു മാടുകളിൽ നിന്നോ ചെമ്മരിയാടുകളിൽനിന്നോ കോലാടുകളിൽനിന്നോ ഊനമില്ലാത്ത ഒരു ആണായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ഊനമുള്ള യാതൊന്നിനെയും നിങ്ങൾ അർപ്പിക്കരുതു; അതിനാൽ നിങ്ങൾക്കു പ്രസാദം ലഭിക്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ഒരുത്തൻ നേർച്ചനിവർത്തിക്കായിട്ടോ സ്വമേധാദാനമായിട്ടോ യഹോവെക്കു മാടുകളിൽനിന്നാകട്ടെ ആടുകളിൽനിന്നാകട്ടെ ഒന്നിനെ സമാധാനയാഗമായിട്ടു അർപ്പിക്കുമ്പോൾ അതു പ്രസാദമാകുവാന്തക്കവണ്ണം ഊനമില്ലത്തതായിരിക്കേണം; അതിന്നു ഒരു കുറവും ഉണ്ടായിരിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","കുരുടു, ചതവു, മുറിവു, മുഴ, ചൊറി, പുഴുക്കടി എന്നിവയുള്ള യാതൊന്നിനെയും യഹോവെക്കു അർപ്പിക്കരുതു; ഇവയിൽ ഒന്നിനെയും യഹോവെക്കു യാഗപീഠത്തിന്മേൽ ദഹനയാഗമായി അർപ്പിക്കരുതു; ");
INSERT INTO mal2015_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","അവയവങ്ങളിൽ ഏതെങ്കിലും നീളം കൂടിയോ കുറഞ്ഞോ ഇരിക്കുന്ന കാളയെയും കുഞ്ഞാടിനെയും സ്വമേധാദാനമായിട്ടു അർപ്പിക്കാം; എന്നാൽ നേർച്ചയായിട്ടു അതു പ്രസാദമാകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","വരിചതെച്ചതോ എടുത്തുകളഞ്ഞതോ ഉടെച്ചതോ മുറിച്ചുകളഞ്ഞതോ ആയുള്ളതിനെ നിങ്ങൾ യഹോവെക്കു അർപ്പിക്കരുതു; ഇങ്ങനെ നിങ്ങളുടെ ദേശത്തു ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","അന്യന്റെ കയ്യിൽനിന്നു ഇങ്ങനെയുള്ള ഒന്നിനെയും വാങ്ങി നിങ്ങളുടെ ദൈവത്തിന്റെ ഭോജനമായിട്ടു അർപ്പിക്കരുതു; അവെക്കു കേടും കുറവും ഉള്ളതുകൊണ്ടു അവയാൽ നിങ്ങൾക്കു പ്രസാദം ലഭിക്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","ഒരു കാളയോ ചെമ്മരിയാടോ കോലാടോ പിറന്നാൽ ഏഴു ദിവസം തള്ളയുടെ അടുക്കൽ ഇരിക്കേണം; എട്ടാം ദിവസംമുതൽ അതു യഹോവെക്കു ദഹനയാഗമായി പ്രസാദമാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","പശുവിനെയോ പെണ്ണാടിനെയോ അതിനെയും കുട്ടിയെയും ഒരു ദിവസത്തിൽ അറുക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","യഹോവെക്കു സ്തോത്രയാഗം അർപ്പിക്കുമ്പോൾ അതു പ്രസാദമാകത്തക്കവണ്ണം അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","അന്നു തന്നേ അതിനെ തിന്നേണം; രാവിലെവരെ അതിൽ ഒട്ടും ശേഷിപ്പിക്കരുതു; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","ആകയാൽ നിങ്ങൾ എന്റെ കല്പനകൾ പ്രമാണിച്ചു ആചരിക്കേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","എന്റെ വിശുദ്ധനാമത്തെ നിങ്ങൾ അശുദ്ധമാക്കരുതു; യിസ്രായേൽമക്കളുടെ ഇടയിൽ ഞാൻ ശുദ്ധീകരിക്കപ്പെടേണം; ഞാൻ നിങ്ങളെ ശുദ്ധീകരിക്കുന്ന യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","നിങ്ങൾക്കു ദൈവമായിരിക്കേണ്ടതിന്നു മിസ്രയീംദേശത്തുനിന്നു നിങ്ങളെ കൊണ്ടുവന്ന ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു: എന്റെ ഉത്സവങ്ങൾ, വിശുദ്ധസഭായോഗം വിളിച്ചുകൂട്ടേണ്ടുന്ന യഹോവയുടെ ഉത്സവങ്ങൾ ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ആറു ദിവസം വേല ചെയ്യേണം; ഏഴാം ദിവസം വിശുദ്ധസഭായോഗം കൂടേണ്ടുന്ന സ്വസ്ഥതെക്കുള്ള ശബ്ബത്ത്. അന്നു ഒരു വേലയും ചെയ്യരുതു; നിങ്ങളുടെ സകലവാസസ്ഥലങ്ങളിലും അതു യഹോവയുടെ ശബ്ബത്ത് ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","അതതുകാലത്തു വിശുദ്ധസഭായോഗം വിളിച്ചുകൂട്ടേണ്ടുന്ന യഹോവയുടെ ഉത്സവങ്ങൾ ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ഒന്നാംമാസം പതിന്നാലം തിയ്യതി സന്ധ്യാസമയത്തു യഹോവയുടെ പെസഹ. ");
INSERT INTO mal2015_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ആ മാസം പതിനഞ്ചാം തിയ്യതി യഹോവെക്കു പുളിപ്പില്ലാത്ത അപ്പത്തിന്റെ പെരുനാൾ; ഏഴു ദിവസം പുളിപ്പില്ലാത്ത അപ്പം തിന്നേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ഒന്നാം ദിവസം നിങ്ങൾക്കു വിശുദ്ധസഭായോഗം ഉണ്ടാകേണം; സാമാന്യവേല യാതൊന്നും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","നിങ്ങൾ ഏഴു ദിവസം യഹോവെക്കു ദഹനയാഗം അർപ്പിക്കേണം; ഏഴാം ദിവസം വിശുദ്ധസഭായോഗം; അന്നു സാമാന്യവേല യാതൊന്നും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ഞാൻ നിങ്ങൾക്കു തരുന്ന ദേശത്തു നിങ്ങൾ എത്തിയശേഷം അതിലെ വിളവെടുക്കുമ്പോൾ നിങ്ങളുടെ കൊയ്ത്തിലെ ആദ്യത്തെ കറ്റ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","നിങ്ങൾക്കു പ്രസാദം ലഭിക്കേണ്ടതിന്നു അവൻ ആ കറ്റ യഹോവയുടെ സന്നിധിയിൽ നീരാജനം ചെയ്യേണം. ശബ്ബത്തിന്റെ പിറ്റെന്നാൾ പുരോഹിതൻ അതു നീരാജനം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","കറ്റ നീരാജനം ചെയ്യുന്ന ദിവസം നിങ്ങൾ യഹോവെക്കു ഹോമയാഗമായി ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഒരു ആണാട്ടിൻകുട്ടിയെ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","അതിന്റെ ഭോജനയാഗം എണ്ണ ചേർത്ത രണ്ടിടങ്ങഴി നേരിയ മാവു ആയിരിക്കേണം; അതു യഹോവെക്കു സൗരഭ്യവാസനയായുള്ള ദഹനയാഗം; അതിന്റെ പാനീയയാഗം ഒരു നാഴി വീഞ്ഞു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","നിങ്ങളുടെ ദൈവത്തിന്നു വഴിപാടു കൊണ്ടുവരുന്ന ദിവസംവരെ നിങ്ങൾ അപ്പമാകട്ടെ മലരാകട്ടെ കതിരാകട്ടെ തിന്നരുതു; നിങ്ങളുടെ സകലവാസസ്ഥലങ്ങളിലും ഇതു തലമുറതലമുറയായി നിങ്ങൾക്കു എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","ശബ്ബത്തിന്റെ പിറ്റെന്നാൾമുതൽ നിങ്ങൾ നീരാജനത്തിന്റെ കറ്റ കൊണ്ടുവന്ന ദിവസംമുതൽ തന്നേ, എണ്ണി ഏഴു ശബ്ബത്ത് തികയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ഏഴാമത്തെ ശബ്ബത്തിന്റെ പിറ്റെന്നാൾവരെ അമ്പതു ദിവസം എണ്ണി യഹോവെക്കു പുതിയ ധാന്യംകൊണ്ടു ഒരു ഭോജനയാഗം അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","നീരാജനത്തിന്നു രണ്ടിങ്ങഴി മാവുകൊണ്ടു രണ്ടപ്പം നിങ്ങളുടെ വാസസ്ഥലങ്ങളിൽ നിന്നു കൊണ്ടുവരേണം; അതു നേരിയ മാവുകൊണ്ടുള്ളതും പുളിപ്പിച്ചു ചുട്ടതും ആയിരിക്കേണം; അതു യഹോവെക്കു ആദ്യവിളവു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","അപ്പത്തോടു കൂടെ ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഏഴു ചെമ്മരിയാട്ടിൻകുട്ടിയെയും ഒരു കാളക്കുട്ടിയെയും രണ്ടു മുട്ടാടിനെയും അർപ്പിക്കേണം; അവയും അവയുടെ ഭോജനയാഗവും പാനീയയാഗവും യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗമായി യഹോവെക്കു ഹോമയാഗമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ഒരു കോലാട്ടുകൊറ്റനെ പാപയാഗമായും ഒരു വയസ്സു പ്രായമുള്ള രണ്ടു ആട്ടിൻകുട്ടിയെ സമാധാനയാഗമായും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","പുരോഹിതൻ അവയെ ആദ്യവിളവിന്റെ അപ്പത്തോടും രണ്ടു ആട്ടിൻകുട്ടിയോടുംകൂടെ യഹോവയുടെ സന്നിധിയിൽ നീരാജനം ചെയ്യേണം; അവ പുരോഹിതന്നുവേണ്ടി യഹോവെക്കു വിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","അന്നു തന്നേ നിങ്ങൾ വിശുദ്ധസഭായോഗം വിളിച്ചുകൂട്ടേണം; അന്നു സാമാന്യവേല യാതൊന്നും ചെയ്യരുതു; ഇതു നിങ്ങളുടെ സകലവാസസ്ഥലങ്ങളിലും തലമുറതലമുറയായി നിങ്ങൾക്കു എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","നിങ്ങളുടെ നിലത്തിലെ വിളവു എടുക്കുമ്പോൾ വയലിന്റെ അരികു തീർത്തുകൊയ്യരുതു; കാലാ പെറുക്കുകയുമരുതു; അതു ദരിദ്രന്നും പരദേശിക്കും വിട്ടേക്കേണം; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ഏഴാം മാസം ഒന്നാം തിയ്യതി നിങ്ങൾക്കു കാഹളധ്വനിയുടെ ജ്ഞാപകവും വിശുദ്ധസഭായോഗമുള്ള സ്വസ്ഥദിവസവുമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","അന്നു സാമാന്യവേല യാതൊന്നും ചെയ്യാതെ യഹോവെക്കു ദഹനയാഗം അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","ഏഴാം മാസം പത്താം തിയ്യതി പാപപരിഹാരദിവസം ആകുന്നു. അന്നു നിങ്ങൾക്കു വിശുദ്ധസഭായോഗം ഉണ്ടാകേണം; നിങ്ങൾ ആത്മതപനം ചെയ്കയും യഹോവെക്കു ദഹനയാഗം അർപ്പിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","അന്നു നിങ്ങൾ യാതൊരു വേലയും ചെയ്യരുതു; അതു നിങ്ങളുടെ ദൈവമായ യഹോവയുടെ സന്നിധിയിൽ നിങ്ങൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണ്ടതിന്നുള്ള പാപപരിഹാരദിവസം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","അന്നു ആത്മതപനം ചെയ്യാത്ത ഏവനെയും അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","അന്നു ആരെങ്കിലും വല്ല വേലയും ചെയ്താൽ അവനെ ഞാൻ അവന്റെ ജനത്തിന്റെ ഇടയിൽനിന്നു നശിപ്പിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","യാതൊരു വേലയും ചെയ്യരുതു; ഇതു നിങ്ങൾക്കു തലമുറതലമുറയായി നിങ്ങളുടെ സകലവാസസ്ഥലങ്ങളിലും എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","അതു നിങ്ങൾക്കു സ്വസ്ഥതെക്കുള്ള ശബ്ബത്ത്; അന്നു നിങ്ങൾ ആത്മതപനം ചെയ്യേണം. ആ മാസം ഒമ്പതാം തിയ്യതി വൈകുന്നേരം മുതൽ പിറ്റെന്നാൾ വൈകുന്നേരംവരെ നിങ്ങൾ ശബ്ബത്ത് ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ഏഴാം മാസം പതിനഞ്ചാം തിയ്യതിമുതൽ ഏഴു ദിവസം യഹോവെക്കു കൂടാരപ്പെരുനാൾ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ഒന്നാം ദിവസത്തിൽ വിശുദ്ധസഭായോഗം ഉണ്ടാകേണം; അന്നു സാമാന്യവേല യാതൊന്നും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ഏഴു ദിവസം യഹോവെക്കു ദഹനയാഗം അർപ്പിക്കേണം; എട്ടാംദിവസം നിങ്ങൾക്കു വിശുദ്ധസഭായോഗം ഉണ്ടാകേണം; യഹോവെക്കു ദഹനയാഗവും അർപ്പിക്കേണം; അന്നു അന്ത്യസഭായോഗം; സാമാന്യവേല യാതൊന്നും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","യഹോവയുടെ ശബ്ബത്തുകളും നിങ്ങളുടെ വഴിപാടുകളും നിങ്ങളുടെ എല്ലാ നേർച്ചകളും നിങ്ങൾ യഹോവെക്കു കൊടുക്കുന്ന സകല സ്വമേധാദാനങ്ങളും കൂടാതെ ");
INSERT INTO mal2015_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","അതതു ദിവസത്തിൽ യഹോവെക്കു ദഹനയാഗവും ഹോമയാഗവും ഭോജനയാഗവും പാനീയയാഗവും അർപ്പിക്കേണ്ടതിന്നു വിശുദ്ധസഭായോഗങ്ങൾ വിളിച്ചുകൂട്ടേണ്ടുന്ന യഹോവയുടെ ഉത്സവങ്ങൾ ഇവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","ഭൂമിയുടെ ഫലം ശേഖരിച്ചശേഷം ഏഴാം മാസം പതിനഞ്ചാം തിയ്യതി യഹോവെക്കു ഏഴു ദിവസം ഉത്സവം ആചരിക്കേണം; ആദ്യദിവസം വിശുദ്ധസ്വസ്ഥത; എട്ടാം ദിവസവും വിശുദ്ധസ്വസ്ഥത. ");
INSERT INTO mal2015_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ആദ്യദിവസം ഭംഗിയുള്ള വൃക്ഷങ്ങളുടെ ഫലവും ഈത്തപ്പനയുടെ കുരുത്തോലയും തഴെച്ചിരിക്കുന്ന വൃക്ഷങ്ങളുടെ കൊമ്പും ആറ്റലരിയും എടുത്തു കൊണ്ടു നിങ്ങളുടെ ദൈവമായ യഹോവയുടെ സന്നിധിയിൽ ഏഴു ദിവസം സന്തോഷിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","സംവത്സരം തോറും ഏഴു ദിവസം യഹോവെക്കു ഈ ഉത്സവം ആചരിക്കേണം; ഇതു തലമുറതലമുറയായി നിങ്ങൾക്കു എന്നേക്കുമുള്ള ചട്ടം; ഏഴാം മാസത്തിൽ അതു ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ഞാൻ യിസ്രായേൽമക്കളെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്നപ്പോൾ ");
INSERT INTO mal2015_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","അവരെ കൂടാരങ്ങളിൽ പാർപ്പിച്ചു എന്നു നിങ്ങളുടെ സന്തതികൾ അറിവാൻ നിങ്ങൾ ഏഴു ദിവസം കൂടാരങ്ങളിൽ പാർക്കേണം; യിസ്രായേലിലെ സ്വദേശികൾ ഒക്കെയും കൂടാരങ്ങളിൽ പാർക്കേണം; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","അങ്ങനെ മോശെ യഹോവയുടെ ഉത്സവങ്ങളെ യിസ്രായേൽമക്കളോടു അറിയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ദീപങ്ങൾ നിത്യം കത്തിക്കൊണ്ടിരിക്കേണ്ടതിന്നു യിസ്രായേൽമക്കൾ നിലവിളക്കിന്നു ഇടിച്ചെടുത്ത തെളിവുള്ള ഒലിവെണ്ണ നിന്റെ അടുക്കൽ കൊണ്ടുവരേണമെന്നു അവരോടു കല്പിക്ക. ");
INSERT INTO mal2015_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","സാമാഗമനകൂടാരത്തിൽ സാക്ഷ്യത്തിന്റെ തിരശ്ശീലെക്കു പുറത്തു വൈകുന്നേരംമുതൽ രാവിലെവരെ കത്തേണ്ടതിന്നു അഹരോൻ അതു യഹോവയുടെ സന്നിധിയിൽ നിത്യം ഒരുക്കിവെക്കേണം; ഇതു തലമുറതലമുറയായി നിങ്ങൾക്കു എന്നേക്കുമുള്ള ചട്ടം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","അവൻ നിത്യവും യഹോവയുടെ സന്നിധിയിൽ തങ്കനിലവിളക്കിന്മേൽ ദീപങ്ങൾ ഒരുക്കിവെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","നീ നേരിയ മാവു എടുത്തു അതുകൊണ്ടു പന്ത്രണ്ടു ദോശ ചുടേണം; ഓരോ ദോശ രണ്ടിടങ്ങഴി മാവുകൊണ്ടു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","അവയെ യഹോവയുടെ സന്നിധിയിൽ തങ്കമേശമേൽ രണ്ടു അടുക്കായിട്ടു ഓരോ അടുക്കിൽ ആറാറുവീതം വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ഓരോ അടുക്കിന്മേൽ നിർമ്മലമായ കുന്തുരുക്കം വെക്കേണം; അതു അപ്പത്തിന്മേൽ നിവേദ്യമായി യഹോവെക്കു ദഹനയാഗമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","അവൻ അതു നിത്യനിയമമായിട്ടു യിസ്രായേൽമക്കളോടു വാങ്ങി ശബ്ബത്തുതോറും യഹോവയുടെ സന്നിധിയിൽ നിരന്തരമായി അടുക്കിവെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","അതു അഹരോന്നും പുത്രന്മാർക്കും ഉള്ളതായിരിക്കേണം; അവർ അതു ഒരു വിശുദ്ധസ്ഥലത്തു വെച്ചു തിന്നേണം; അതു അവന്നു ശാശ്വതാവകാശമായി യഹോവയുടെ ദഹനയാഗങ്ങളിൽ അതിവിശുദ്ധം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","അനന്തരം ഒരു യിസ്രായേല്യസ്ത്രീയുടെയും ഒരു മിസ്രയീമ്യന്റെയും മകനായ ഒരുത്തൻ യിസ്രായേൽമക്കളുടെ മദ്ധ്യേ പുറപ്പെട്ടു; യിസ്രായേല്യസ്ത്രീയുടെ ഈ മകനും ഒരു യിസ്രാല്യേനും തമ്മിൽ പാളയത്തിൽവെച്ചു ശണ്ഠയിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","യിസ്രയേല്യസ്ത്രീയുടെ മകൻ തിരുനാമം ദുഷിച്ചു ശപിച്ചു; അതുകൊണ്ടു അവർ അവനെ മോശെയുടെ അടുക്കൽ കൊണ്ടു വന്നു; അവന്റെ അമ്മെക്കു ശെലോമീത്ത് എന്നു പേർ. അവൾ ദാൻഗോത്രത്തിൽ ദിബ്രി എന്നൊരുവന്റെ മകളായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","യഹോവയുടെ അരുളപ്പാടു കിട്ടേണ്ടതിന്നു അവർ അവനെ തടവിൽ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","അപ്പോൾ യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","ശപിച്ചവനെ പാളയത്തിന്നു പുറത്തു കൊണ്ടുപോക; കേട്ടവർ എല്ലാവരും അവന്റെ തലയിൽ കൈവെച്ചശേഷം സഭയൊക്കെയും അവനെ കല്ലെറിഞ്ഞു കൊല്ലേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","എന്നാൽ യിസ്രായേൽമക്കളോടു നി പറയേണ്ടതു എന്തെന്നാൽ: ആരെങ്കിലും തന്റെ ദൈവത്തെ ശപിച്ചാൽ അവൻ തന്റെ പാപം വഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","യഹോവയുടെ നാമം ദുഷിക്കുന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം; സഭയൊക്കെയും അവനെ കല്ലെറിയേണം; പരദേശിയാകട്ടേ സ്വദേശിയാകട്ടെ തിരുനാമത്തെ ദുഷിക്കുന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","മനുഷ്യനെ കൊല്ലുന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","മൃഗത്തെ കൊല്ലുന്നവൻ മൃഗത്തിന്നു പകരം മൃഗത്തെ കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ഒരുത്തൻ കൂട്ടുകാരന്നു കേടു വരുത്തിയാൽ അവൻ ചെയ്തതുപോലെ തന്നേ അവനോടു ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ഒടിവിന്നു പകരം ഒടിവു, കണ്ണിന്നു പകരം കണ്ണു, പല്ലിന്നു പകരം പല്ലു; ഇങ്ങനെ അവൻ മറ്റേവന്നു കേടുവരുത്തിയതുപോലെ തന്നേ അവന്നും വരുത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","മൃഗത്തെ കൊല്ലുന്നവൻ അതിന്നു പകരം കൊടുക്കേണം; മനുഷ്യനെ കൊല്ലുന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","നിങ്ങൾക്കു പരദേശിക്കും സ്വദേശിക്കും ഒരു പ്രമാണം തന്നേ ആയിരിക്കേണം; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ദുഷിച്ചവനെ പാളയത്തിന്നു പുറത്തുകൊണ്ടുപൊയി കല്ലെറിയേണമെന്നു മോശെ യിസ്രായേൽമക്കളോടു പറഞ്ഞു. യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ യിസ്രായേൽമക്കൾ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","യഹോവ സീനായിപർവ്വതത്തിൽവെച്ചു മോശെയോടു അരുളിച്ചെയ്തതതു: ");
INSERT INTO mal2015_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ഞാൻ നിങ്ങൾക്കു തരുന്ന ദേശത്തു നിങ്ങൾ എത്തിയശേഷം ദേശം യഹോവെക്കു ശബ്ബത്തു ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ആറു സംവത്സരം നിന്റെ നിലം വിതെക്കേണം; അവ്വണ്ണം ആറു സംവത്സരം നിന്റെ മുന്തിരിത്തോട്ടം വള്ളിത്തല മുറിച്ചു അനുഭവം എടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ഏഴാം സംവത്സരത്തിലോ ദേശത്തിന്നു സ്വസ്ഥതയുള്ള ശബ്ബത്തായ യഹോവയുടെ ശബ്ബത്ത് ആയിരിക്കേണം; നിന്റെ നിലം വിതെക്കയും മുന്തിരിത്തോട്ടം വള്ളിത്തല മുറിക്കയും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","നിന്റെ കൊയ്ത്തിന്റെ പടുവിളവു കൊയ്യുകയും വള്ളിത്തല മുറിക്കാത്ത മുന്തിരിത്തോട്ടത്തിലെ പഴം പറിക്കയും അരുതു; അതു ദേശത്തിന്നു ശബ്ബത്താണ്ടു ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ദേശത്തിന്റെ ശബ്ബത്തിൽ താനേ വിളയുന്നതു നിങ്ങളുടെ ആഹാരമായിരിക്കേണം; നിനക്കും നിന്റെ ദാസന്നും ദാസിക്കും കൂലിക്കാരന്നും നിന്നോടുകൂടെ പാർക്കുന്ന പരദേശിക്കും ");
INSERT INTO mal2015_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","നിന്റെ കന്നുകാലിക്കും കാട്ടുമൃഗത്തിന്നും അതിന്റെ അനുഭവം ഒക്കെയും ആഹാരമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","പിന്നെ ഏഴു ശബ്ബത്താണ്ടായ ഏഴേഴുസംവത്സരം എണ്ണേണം; അങ്ങനെ ഏഴു ശബ്ബത്താണ്ടായ നാല്പത്തൊമ്പതു സംവത്സരം കഴിയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","അപ്പോൾ ഏഴാം മാസം പത്താം തിയ്യതി മഹാധ്വനികാഹളം ധ്വനിപ്പിക്കേണം; പാപപരിഹാരദിവസത്തിൽ നിങ്ങൾ നിങ്ങളുടെ ദേശത്തു എല്ലാടവും കാഹളം ധ്വനിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","അമ്പതാം സംവത്സരത്തെ ശുദ്ധീകരിച്ചു ദേശത്തെല്ലാടവും സകലനിവാസികൾക്കും സ്വാതന്ത്ര്യം പ്രസിദ്ധമാക്കേണം; അതു നിങ്ങൾക്കു യോബേൽസംവത്സരമായിരിക്കേണം: നിങ്ങൾ താന്താന്റെ അവകാശത്തിലേക്കു മടങ്ങിപ്പോകേണം; ഓരോരുത്തൻ താന്താന്റെ കുടുംബത്തിലേക്കും മടങ്ങിപ്പോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","അമ്പതാം സംവത്സരം നിങ്ങൾക്കു യോബേൽ സംവത്സരമായിരിക്കേണം; അതിൽ നിങ്ങൾ വിതെക്കയോ പടുവിളവു കൊയ്കയോ വള്ളിത്തല മുറിക്കാത്ത മുന്തിരിവള്ളിയുടെ പഴം പറിക്കയോ ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","അതു യോബേൽസംവത്സരം ആകുന്നു; അതു നിങ്ങൾക്കു വിശുദ്ധമായിരിക്കേണം; ആയാണ്ടത്തെ അനുഭവം നിങ്ങൾ വയലിൽ നിന്നുതന്നേ എടുത്തു തിന്നേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ഇങ്ങനെയുള്ള യോബേൽ സംവത്സരത്തിൽ നിങ്ങൾ താന്താന്റെ അവകാശത്തിലേക്കു മടങ്ങിപ്പോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","കൂട്ടുകാരന്നു എന്തെങ്കിലും വിൽക്കയോ കൂട്ടുകാരനോടു എന്തെങ്കിലും വാങ്ങുകയോ ചെയ്താൽ നിങ്ങൾ തമ്മിൽ തമ്മിൽ അന്യായം ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","യോബേൽസംവത്സരത്തിന്റെ പിമ്പുള്ള സംവത്സരങ്ങളുടെ സംഖ്യക്കു ഒത്തവണ്ണം നിന്റെ കൂട്ടുകാരനോടു വാങ്ങേണം; അനുഭവമുള്ള സംവത്സരങ്ങളുടെ സംഖ്യെക്കു ഒത്തവണ്ണം അവൻ നിനക്കു വിൽക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","സംവത്സരങ്ങൾ ഏറിയിരുന്നാൽ വില ഉയർത്തേണം; സംവത്സരങ്ങൾ കുറഞ്ഞിരുന്നാൽ വില താഴ്ത്തേണം; അനുഭവത്തിന്റെ കാലസംഖ്യെക്കു ഒത്തവണ്ണം അവൻ നിനക്കു വില്ക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ആകയാൽ നിങ്ങൾ തമ്മിൽ തമ്മിൽ അന്യായം ചെയ്യരുതു; നിന്റെ ദൈവത്തെ ഭയപ്പെടേണം: ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","അതു കൊണ്ടു നിങ്ങൾ എന്റെ കല്പനകൾ അനുസരിച്ചു എന്റെ വിധികൾ പ്രമാണിച്ചു ആചരിക്കേണം; എന്നാൽ നിങ്ങൾ ദേശത്തു നിർഭയം വസിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ഭൂമി അതിന്റെ ഫലം തരും; നിങ്ങൾ തൃപ്തിയായി ഭക്ഷിച്ചു അതിൽ നിർഭയം വസിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","എന്നാൽ ഏഴാം സംവത്സരത്തിൽ ഞങ്ങൾ എന്തു ഭക്ഷിക്കും? ഞങ്ങൾ വിതെക്കയും ഞങ്ങളുടെ അനുഭവമെടുക്കയും ചെയ്യരുതല്ലോ എന്നു നിങ്ങൾ പറയുന്നുവെങ്കിൽ ");
INSERT INTO mal2015_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ഞാൻ ആറാം സംവത്സരത്തിൽ നിങ്ങൾക്കു എന്റെ അനുഗ്രഹം അരുളുകയും അതു മൂന്നു സംവത്സരത്തേക്കുള്ള അനുഭവം തരികയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","എട്ടാം സംവത്സരത്തിൽ നിങ്ങൾ വിതെക്കയും ഒമ്പതാം സംവത്സരംവരെ പഴയ അനുഭവംകൊണ്ടു ഉപജീവിക്കയും വേണം; അതിന്റെ അനുഭവം വരുംവരെ പഴയതുകൊണ്ടു ഉപജീവിച്ചുകൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","നിലം ജന്മം വിൽക്കരുതു; ദേശം എനിക്കുള്ളതു ആകുന്നു; നിങ്ങൾ എന്റെ അടുക്കൽ പരദേശികളും വന്നു പാർക്കുന്നവരും അത്രേ. ");
INSERT INTO mal2015_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","നിങ്ങളുടെ അവകാശമായ ദേശത്തൊക്കെയും നിലത്തിന്നു വീണ്ടെടുപ്പു സമ്മതിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","നിന്റെ സഹോദരൻ ദിരദ്രനായ്തീർന്നു തന്റെ അവകാശത്തിൽ ഏതാനും വിറ്റാൽ അവന്റെ അടുത്ത ചാർച്ചക്കാരൻ വന്നു സഹോദരൻ വിറ്റതു വീണ്ടുകൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","എന്നാൽ വീണ്ടുകൊള്ളുവാൻ അവന്നു ആരും ഇല്ലാതിരിക്കയും താൻ തന്നേ വകയുള്ളവനായി വീണ്ടുകൊള്ളുവാൻ പ്രാപ്തനാകയും ചെയ്താൽ ");
INSERT INTO mal2015_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","അവൻ അതു വിറ്റശേഷമുള്ള സംവത്സരം കണക്കുകൂട്ടി മിച്ചമുള്ളതു അതു വാങ്ങിയിരുന്ന ആൾക്കു മടക്കിക്കൊടുത്തു തന്റെ അവകാശത്തിലേക്കു മടങ്ങിവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","എന്നാൽ മടക്കിക്കൊടുപ്പാൻ അവന്നു പ്രാപ്തിയില്ല എങ്കിൽ വിറ്റുപോയ യോബേൽ സംവത്സരംവരെ വാങ്ങിയവന്റെ കയ്യിൽ ഇരിക്കേണം; യോബേൽസംവത്സരത്തിൽ അതു ഒഴിഞ്ഞുകൊടുക്കയും അവൻ തന്റെ അവകാശത്തിലേക്കു മടങ്ങിവരികയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","ഒരുത്തൻ മതിലുള്ള പട്ടണത്തിൽ ഒരു വീടു വിറ്റാൽ വിറ്റശേഷം ഒരു സംവത്സരത്തിന്നകം അവന്നു അതു വീണ്ടുകൊള്ളാം; വീണ്ടുകൊള്ളുവാൻ ഒരു സംവത്സരത്തെ അവധി ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ഒരു സംവത്സരം മുഴുവനും തികയുവോളം വീണ്ടുകൊണ്ടില്ലെങ്കിൽ മതിലുള്ള പട്ടണത്തിലെ വീടു, വാങ്ങിയവന്നു തലമുറതലമുറയായി എന്നും സ്ഥിരമായിരിക്കേണം; യോബേൽസംവത്സരത്തിൽ അതു ഒഴിഞ്ഞുകൊടുക്കേണ്ടാ. ");
INSERT INTO mal2015_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","മതിലില്ലാത്ത ഗ്രാമങ്ങളിലെ വീടുകളോ ദേശത്തുള്ള നിലത്തിന്നു സമമായി വിചാരിക്കേണം; അവെക്കു വീണ്ടെടുപ്പു ഉണ്ടു; യോബേൽസംവത്സരത്തിൽ അവയെ ഒഴിഞ്ഞുകൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","എന്നാൽ ലേവ്യരുടെ പട്ടണങ്ങളും അവരുടെ അവകാശമായ പട്ടണങ്ങളിലെ വീടുകളും ലേവ്യർക്കു എപ്പോഴെങ്കിലും വീണ്ടുകൊള്ളാം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ലേവ്യരിൽ ഒരുത്തൻ വീണ്ടുകൊള്ളുന്നു എങ്കിൽ വിറ്റുപോയ വീടും അവന്റെ അവകാശമായ പട്ടണവും യോബേൽസംവത്സരത്തിൽ ഒഴിഞ്ഞുകൊടുക്കേണം; ലേവ്യരുടെ പട്ടണങ്ങളിലെ വീടുകൾ യിസ്രായേൽ മക്കളുടെ ഇടയിൽ അവർക്കുള്ള അവകാശമല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","എന്നാൽ അവരുടെ പട്ടണങ്ങളോടു ചേർന്നിരിക്കുന്ന പുല്പുറമായ ഭൂമി വിൽക്കരുതു; അതു അവർക്കു ശാശ്വതാവകാശം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","നിന്റെ സഹോദരൻ ദരിദ്രനായ്തീർന്നു നിന്റെ അടുക്കൽവെച്ചു ക്ഷയിച്ചുപോയാൽ നീ അവനെ താങ്ങേണം; അന്യനും പരദേശിയും എന്നപോലെ അവൻ നിന്റെ അടുക്കൽ പാർക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","അവനോടു പലിശയും ലാഭവും വാങ്ങരുതു; നിന്റെ ദൈവത്തെ ഭയപ്പെടേണം; നിന്റെ സഹോദരൻ നിന്റെ അടുക്കൽ പാർക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","നിന്റെ പണം പലിശെക്കു കൊടുക്കരുതു; നിന്റെ ആഹാരം അവന്നു ലാഭത്തിന്നായി കൊടുക്കയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ഞാൻ നിങ്ങൾക്കു കനാൻദേശം തരുവാനും നിങ്ങളുടെ ദൈവമായിരിപ്പാനും നിങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്ന നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","നിന്റെ സഹോദരൻ ദരിദ്രനായ്തീർന്നു തന്നെത്താൻ നിനക്കു വിറ്റാൽ അവനെകൊണ്ടു അടിമവേല ചെയ്യിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","കൂലിക്കാരൻ എന്നപോലെയും വന്നുപാർക്കുന്നവൻ എന്നപോലെയും അവൻ നിന്റെ അടുക്കൽ ഇരുന്നു യോബേൽസംവത്സരംവരെ നിന്നെ സേവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","പിന്നെ അവൻ തന്റെ മക്കളുമായി നിന്നെ വിട്ടു തന്റെ കുടുംബത്തിലേക്കു മടങ്ങിപ്പോകേണം; തന്റെ പിതാക്കന്മാരുടെ അവകാശത്തിലേക്കു അവൻ മടങ്ങിപ്പോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","അവർ മിസ്രയീംദേശത്തുനിന്നു ഞാൻ കൊണ്ടുവന്ന എന്റെ ദാസന്മാർ ആകകൊണ്ടു അവരെ അടിമകളായി വിൽക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","അവനോടു കാഠിന്യം പ്രവർത്തിക്കരുതു; നിന്റെ ദൈവത്തെ ഭയപ്പെടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","നിന്റെ അടിയാരും അടിയാട്ടികളും നിങ്ങൾക്കു ചുറ്റുമുള്ള ജാതികളിൽനിന്നു ആയിരിക്കേണം; അവരിൽനിന്നു അടിയാരെയും അടിയാട്ടികളെയും കൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","അവ്വണ്ണം നിങ്ങളുടെ ഇടയിൽ വന്നു പാർക്കുന്ന അന്യജാതിക്കാരുടെ മക്കളിൽനിന്നും അവർ നിങ്ങളുടെ ദേശത്തു ജനിപ്പിച്ചവരും നിങ്ങളോടുകൂടെ ഇരിക്കുന്നവരുമായ അവരുടെ കുടുംബങ്ങളില് നിന്നും നിങ്ങൾ വാങ്ങേണം; അവർ നിങ്ങൾക്കു അവകാശമായിരിക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","നിങ്ങളുടെ ശേഷം നിങ്ങളുടെ മക്കൾക്കും അവകാശമായിരിക്കേണ്ടതിന്നു നിങ്ങൾ അവരെ അവകാശമാക്കിക്കൊള്ളേണം; അവർ എന്നും നിങ്ങൾക്കു അടിമകളായിരിക്കേണം; യിസ്രായേൽമക്കളായ നിങ്ങളുടെ സഹോദരന്മാരോടോ നിങ്ങൾ കാഠിന്യം പ്രവർത്തിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","നിന്നോടുകൂടെയുള്ള പരദേശിയോ അന്യനോ സമ്പന്നനാകയും അവന്റെ അടുക്കലുള്ള നിന്റെ സഹോദരൻ ദരിദ്രനായ്തീർന്നു തന്നെത്താൻ അന്യന്നോ പരദേശിക്കോ അന്യന്റെ സന്തതിക്കോ വിൽക്കയും ചെയ്താൽ ");
INSERT INTO mal2015_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","അവൻ തന്നെത്താൻ വിറ്റശേഷം അവനെ വീണ്ടെടുക്കാം; അവന്റെ സഹോദരന്മാരിൽ ഒരുത്തന്നു അവനെ വീണ്ടെടുക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","അവന്റെ പിതൃവ്യന്നോ പിതൃവ്യന്റെ പുത്രന്നോ അവനെ വീണ്ടെടുക്കാം; അല്ലെങ്കിൽ അവന്റെ കുടുംബത്തിൽ അവന്റെ അടുത്ത ചാർച്ചക്കാരിൽ ഒരുത്തന്നു അവനെ വീണ്ടെടുക്കാം; അവന്നു പ്രാപ്തിയുണ്ടെങ്കിൽ തന്നെത്താൻ വീണ്ടെടുക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","അവൻ തന്നെ വിറ്റ സംവത്സരംമുതൽ യോബേൽസംവത്സരംവരെയുള്ള കാലക്കണക്കു തന്നെ വാങ്ങിയവനുമായി കൂട്ടിനോക്കേണം; അവന്റെ വില സംവത്സരസംഖ്യക്കു ഒത്തവണ്ണം ആയിരിക്കേണം; അവൻ ഒരു കൂലിക്കാരന്റെ കാലത്തിന്നു ഒത്തവണ്ണം അവന്റെ അടുക്കൽ പാർക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","സംവത്സരം ഏറെയുണ്ടെങ്കിൽ അതിന്നു തക്കവണ്ണം അവൻ തന്റെ വീണ്ടെടുപ്പുവില തനിക്കു കിട്ടിയ പണത്തിൽനിന്നു മടക്കിക്കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","യോബേൽസംവത്സരംവരെ ശേഷിക്കുന്ന സംവത്സരം കുറെ മാത്രം എങ്കിൽ അവനുമായി കണക്കുകൂട്ടി സംവത്സരങ്ങൾക്കു ഒത്തവണ്ണം തന്റെ വീണ്ടെടുപ്പുവില മടക്കിക്കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","അവൻ ആണ്ടോടാണ്ടു കൂലിക്കാരൻ എന്നപോലെ അവന്റെ അടുക്കൽ ഇരിക്കേണം; നീ കാൺകെ അവൻ അവനോടു കാഠിന്യം പ്രവർത്തിക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ഇങ്ങനെ അവൻ വീണ്ടെടുക്കപ്പെടാതെയിരുന്നാൽ അവനും അവനോടുകൂടെ അവന്റെ മക്കളും യോബേൽ സംവത്സരത്തിൽ പുറപ്പെട്ടുപോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","യിസ്രായേൽമക്കൾ എനിക്കു ദാസന്മാർ ആകുന്നു; അവർ മിസ്രയീംദേശത്തുനിന്നു ഞാൻ കൊണ്ടുവന്ന എന്റെ ദാസന്മാർ; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","വിഗ്രഹങ്ങളെ ഉണ്ടാക്കരുതു; ബിംബമോ സ്തംഭമോ നാട്ടരുതു; രൂപം കൊത്തിയ യാതൊരു കല്ലും നമസ്കരിപ്പാൻ നിങ്ങളുടെ ദേശത്തു നാട്ടുകയും അരുതു; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","നിങ്ങൾ എന്റെ ശബ്ബത്തുകൾ ആചരിക്കയും എന്റെ വിശുദ്ധമന്ദിരം ബഹുമാനിക്കയും വേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","എന്റെ ചട്ടം ആചരിച്ചു എന്റെ കല്പന പ്രമാണിച്ചു അനുസരിച്ചാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ഞാൻ തക്കസമയത്തു നിങ്ങൾക്കു മഴ തരും; ഭൂമി വിളവു തരും; ഭൂമിയിലുള്ള വൃക്ഷവും ഫലം തരും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","നിങ്ങളുടെ മെതി മുന്തിരിപ്പഴം പറിക്കുന്നതുവരെ നില്ക്കും; മുന്തിരിപ്പഴം പറിക്കുന്നതു വിതകാലംവരെയും നില്ക്കും; നിങ്ങൾ തൃപ്തരായി അഹോവൃത്തികഴിച്ചു ദേശത്തു നിർഭയം വസിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ഞാൻ ദേശത്തു സമാധാനം തരും; നിങ്ങൾ കിടക്കും; ആരും നിങ്ങളെ ഭയപ്പെടുത്തുകയില്ല; ഞാൻ ദേശത്തുനിന്നു ദുഷ്ടമൃഗങ്ങളെ നീക്കിക്കളയും; വാൾ നിങ്ങളുടെ ദേശത്തുകൂടി കടക്കയുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","നിങ്ങളുടെ ശത്രുക്കളെ നിങ്ങൾ ഓടിക്കും; അവർ നിങ്ങളുടെ മുമ്പിൽ വാളിനാൽ വീഴും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","നിങ്ങളിൽ അഞ്ചുപേർ നൂറുപേരെ ഓടിക്കും; നിങ്ങളിൽ നൂറുപേർ പതിനായിരംപേരെ ഓടിക്കും; നിങ്ങളുടെ ശത്രുക്കൾ നിങ്ങളുടെ മുമ്പിൽ വാളിനാൽ വീഴും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ഞാൻ നിങ്ങളെ കടാക്ഷിച്ചു സന്താനസമ്പന്നരാക്കി പെരുക്കുകയും നിങ്ങളോടുള്ള എന്റെ നിയമം സ്ഥിരമാക്കുകയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","നിങ്ങൾ പഴയ ധാന്യം ഭക്ഷിക്കയും പുതിയതിന്റെ നിമിത്തം പഴയതു പുറത്തു ഇറക്കുകയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ഞാൻ എന്റെ നിവാസം നിങ്ങളുടെ ഇടയിൽ ആക്കും; എന്റെ ഉള്ളം നിങ്ങളെ വെറുക്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ഞാൻ നിങ്ങളുടെ ഇടയിൽ സഞ്ചരിച്ചുകൊണ്ടിരിക്കും; ഞാൻ നിങ്ങൾക്കു ദൈവവും നിങ്ങൾ എനിക്കു ജനവും ആയിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","നിങ്ങൾ മിസ്രയീമ്യർക്കു അടിമകളാകാതിരിപ്പാൻ അവരുടെ ദേശത്തുനിന്നു നിങ്ങളെ കൊണ്ടുവന്ന നിങ്ങളുടെ ദൈവമായ യഹോവ ഞാൻ ആകുന്നു; ഞാൻ നിങ്ങളുടെ നുകക്കൈകളെ ഒടിച്ചു നിങ്ങളെ നിവിർന്നു നടക്കുമാറാക്കിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","എന്നാൽ നിങ്ങൾ എന്റെ വാക്കു കേൾക്കാതെയും ഈ കല്പനകളൊക്കെയും പ്രമാണിക്കാതെയും ");
INSERT INTO mal2015_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","എന്റെ ചട്ടങ്ങൾ ധിക്കരിച്ചു നിങ്ങളുടെ ഉള്ളം എന്റെ വിധികളെ വെറുത്തു നിങ്ങൾ എന്റെ കല്പനകളൊക്കെയും പ്രമാണിക്കാതെ എന്റെ നിയമം ലംഘിച്ചാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ഞാനും ഇങ്ങനെ നിങ്ങളോടു ചെയ്യും; കണ്ണിനെ മങ്ങിക്കുന്നതും ജീവനെ ക്ഷയിപ്പിക്കുന്നതുമായ ഭീതി, ക്ഷയരോഗം, ജ്വരം എന്നിവ ഞാൻ നിങ്ങളുടെ മേൽ വരുത്തും; നിങ്ങളുടെ വിത്തു നിങ്ങൾ വെറുതെ വിതെക്കും; ശത്രുക്കൾ അതു ഭക്ഷിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ഞാൻ നിങ്ങളുടെ നേരെ ദൃഷ്ടിവെക്കും; നിങ്ങൾ ശത്രുക്കളോടു തോറ്റുപോകും; നിങ്ങളെ ദ്വേഷിക്കുന്നവർ നിങ്ങളെ ഭരിക്കും; ഓടിക്കുന്നവർ ഇല്ലാതെ നിങ്ങൾ ഓടും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","ഇതെല്ലാം ആയിട്ടും നിങ്ങൾ എന്റെ വാക്കു കേൾക്കാതിരുന്നാൽ നിങ്ങളുടെ പാപങ്ങൾനിമിത്തം ഞാൻ നിങ്ങളെ ഏഴുമടങ്ങു ശിക്ഷിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ഞാൻ നിങ്ങളുടെ ബലത്തിന്റെ പ്രതാപം കെടുക്കും; നിങ്ങളുടെ ആകാശത്തെ ഇരിമ്പുപോലെയും ഭൂമിയെ ചെമ്പുപോലെയും ആക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","നിങ്ങളുടെ ശക്തി വെറുതെ ക്ഷയിച്ചുപോകും; നിങ്ങളുടെ ദേശം വിളവു തരാതെയും ദേശത്തിലെ വൃക്ഷം ഫലം കായ്ക്കാതെയും ഇരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","നിങ്ങൾ എനിക്കു വിരോധമായി നടന്നു എന്റെ വാക്കു കേൾക്കാതിരുന്നാൽ ഞാൻ നിങ്ങളുടെ പാപങ്ങൾക്കു തക്കവണ്ണം ഏഴു മടങ്ങു ബാധ നിങ്ങളുടെമേൽ വരുത്തും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ഞാൻ നിങ്ങളുടെ ഇടയിൽ കാട്ടുമൃഗങ്ങളെ അയക്കും; അവ നിങ്ങളെ മക്കളില്ലാത്തവരാക്കുകയും നിങ്ങളുടെ കന്നുകാലികളെ നശിപ്പിക്കയും നിങ്ങളെ എണ്ണത്തിൽ കുറെക്കുകയും ചെയ്യും; നിങ്ങളുടെ വഴികൾ പാഴായി കിടക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","ഇവയാലും നിങ്ങൾക്കു ബോധംവരാതെ നിങ്ങൾ എനിക്കു വിരോധമായി നടന്നാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ഞാനും നിങ്ങൾക്കു വിരോധമായി നടന്നു നിങ്ങളുടെ പാപങ്ങൾ നിമിത്തം ഏഴുമടങ്ങു നിങ്ങളെ ദണ്ഡിപ്പിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","എന്റെ നിയമത്തിന്റെ പ്രതികാരം നടത്തുന്ന വാൾ ഞാൻ നിങ്ങളുടെ മേൽ വരുത്തും; നിങ്ങൾ നിങ്ങളുടെ പട്ടണങ്ങളിൽ ഒന്നിച്ചുകൂടുമ്പോൾ ഞാൻ നിങ്ങളുടെ ഇടയിൽ മഹാമാരി അയക്കയും നിങ്ങളെ ശത്രുവിന്റെ കൈയിൽ ഏൽപ്പിക്കുകയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ഞാൻ നിങ്ങളുടെ അപ്പമെന്ന കോൽ ഒടിച്ചിരിക്കുമ്പോൾ പത്തു സ്ത്രീകൾ ഒരടുപ്പിൽ നിങ്ങളുടെ അപ്പം ചുട്ടു നിങ്ങൾക്കു തിരികെ തൂക്കിത്തരും; നിങ്ങൾ ഭക്ഷിച്ചിട്ടു തൃപ്തരാകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ഇതെല്ലാമായിട്ടും നിങ്ങൾ എന്റെ വാക്കു കേൾക്കാതെ എനിക്കു വിരോധമായി നടന്നാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ഞാനും ക്രോധത്തോടെ നിങ്ങൾക്കു വിരോധമായി നടക്കും; നിങ്ങളുടെ പാപങ്ങൾനിമിത്തം നിങ്ങളെ ഏഴുമടങ്ങു ശിക്ഷിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","നിങ്ങളുടെ പുത്രന്മാരുടെ മാംസം നിങ്ങൾ തിന്നും; നിങ്ങളുടെ പുത്രിമാരുടെ മാംസവും തിന്നും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ഞാൻ നിങ്ങളുടെ പൂജാഗിരികളെ നശിപ്പിച്ചു നിങ്ങളുടെ സൂര്യവിഗ്രഹങ്ങളെ വെട്ടിക്കളകയും നിങ്ങളുടെ ശവം നിങ്ങളുടെ വിഗ്രഹങ്ങളുടെ ഉടലിന്മേൽ ഇട്ടുകളകയും എനിക്കു നിങ്ങളോടു വെറുപ്പുതോന്നുകയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ഞാൻ നിങ്ങളുടെ പട്ടണങ്ങളെ പാഴ്നിലവും നിങ്ങളുടെ വിശുദ്ധമന്ദിരങ്ങളെ ശൂന്യവും ആക്കും; നിങ്ങളുടെ സൗരഭ്യവാസന ഞാൻ മണക്കുകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ഞാൻ ദേശത്തെ ശൂന്യമാക്കും; അതിൽ വസിക്കുന്ന നിങ്ങളുടെ ശത്രുക്കൾ അതിങ്കൽ ആശ്ചര്യപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ഞാൻ നിങ്ങളെ ജാതികളുടെ ഇടയിൽ ചിതറിച്ചു നിങ്ങളുടെ പിന്നാലെ വാൾ ഊരും; നിങ്ങളുടെ ദേശം ശൂന്യമായും നിങ്ങളുടെ പട്ടണങ്ങൾ പാഴ്നിലമായും കിടക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","അങ്ങനെ ദേശം ശൂന്യമായി കിടക്കയും നിങ്ങൾ ശത്രുക്കളുടെ ദേശത്തു ഇരിക്കയും ചെയ്യുന്ന നാളൊക്കെയും അതു തന്റെ ശബ്ബത്തുകൾ അനുഭവിക്കും; അപ്പോൾ ദേശം സ്വസ്ഥമായിക്കിടന്നു തന്റെ ശബ്ബത്തുകൾ അനുഭവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","നിങ്ങൾ അവിടെ പാർത്തിരുന്നപ്പോൾ നിങ്ങളുടെ ശബ്ബത്തുകളിൽ അതിന്നു അനുഭവമാകാതിരുന്ന സ്വസ്ഥത അതു ശൂന്യമായി കിടക്കുന്ന നാളൊക്കെയും അനുഭവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ശേഷിച്ചിരിക്കുന്നവരുടെ ഹൃദയത്തിൽ ഞാൻ ശത്രുക്കളുടെ ദേശത്തുവെച്ചു ഭീരുത്വം വരുത്തും; ഇല പറക്കുന്ന ശബ്ദം കേട്ടിട്ടു അവർ ഓടും; വാളിന്റെ മുമ്പിൽനിന്നു ഓടുന്നതുപോലെ അവർ ഓടും; ആരും ഓടിക്കാതെ അവർ ഓടി വീഴും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ആരും ഓടിക്കാതെ അവർ വാളിന്റെ മുമ്പിൽനിന്നു എന്നപോലെ ഓടി ഒരുത്തന്റെ മേൽ ഒരുത്തൻ വീഴും; ശത്രുക്കളുടെ മുമ്പിൽ നില്പാൻ നിങ്ങൾക്കു കഴികയുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","നിങ്ങൾ ജാതികളുടെ ഇടയിൽ നശിക്കും; ശത്രുക്കളുടെ ദേശം നിങ്ങളെ തിന്നുകളയും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","നിങ്ങളിൽ ശേഷിച്ചിരിക്കുന്നവർ ശത്രുക്കളുടെ ദേശത്തുവെച്ചു തങ്ങളുടെ അകൃത്യങ്ങളാൽ ക്ഷയിച്ചുപോകും; തങ്ങളുടെ പിതാക്കന്മാരുടെ അകൃത്യങ്ങളാലും അവർ അവരോടുകൂടെ ക്ഷയിച്ചുപോകും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","അവർ തങ്ങളുടെ അകൃത്യവും തങ്ങളുടെ പിതാക്കന്മാരുടെ അകൃത്യവും അവർ എന്നോടു ദ്രോഹിച്ച ദ്രോഹവും അവർ എനിക്കു വിരോധമായി നടന്നതുകൊണ്ടു ");
INSERT INTO mal2015_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ഞാനും അവർക്കു വിരോധമായി നടന്നു അവരെ ശത്രുക്കളുടെ ദേശത്തു വരുത്തിയതും ഏറ്റുപറകയും അവരുടെ പരിച്ഛേദനയില്ലാത്ത ഹൃദയം അപ്പോൾ താഴുകയും അവർ തങ്ങളുടെ അകൃത്യത്തിന്നുള്ള ശിക്ഷ അനുഭവിക്കയും ചെയ്താൽ ");
INSERT INTO mal2015_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ഞാൻ യാക്കോബിനോടുള്ള എന്റെ നിയമം ഓർക്കും; യിസ്ഹാക്കിനോടുള്ള എന്റെ നിയമവും അബ്രാഹാമിനോടുള്ള എന്റെ നിയമവും ഞാൻ ഓർക്കും; ദേശത്തെയും ഞാൻ ഓർക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","അവർ ദേശം വിട്ടുപോയിട്ടു അവരില്ലാതെ അതു ശൂന്യമായി കിടന്നു തന്റെ ശബ്ബത്തുകൾ അനുഭവിക്കും. അവർ എന്റെ വിധികളെ ധിക്കരിക്കയും അവർക്കു എന്റെ ചട്ടങ്ങളോടു വെറുപ്പുതോന്നുകയും ചെയ്തതുകൊണ്ടു അവർ തങ്ങളുടെ അകൃത്യത്തിന്നുള്ള ശിക്ഷ അനുഭവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","എങ്കിലും അവർ ശത്രുക്കളുടെ ദേശത്തു ഇരിക്കുമ്പോൾ അവരെ നിർമ്മൂലമാക്കുവാനും അവരോടുള്ള എന്റെ നിയമം ലംഘിപ്പാനും തക്കവണ്ണം ഞാൻ അവരെ ഉപേക്ഷിക്കയില്ല, അവരെ വെറുക്കയുമില്ല; ഞാൻ അവരുടെ ദൈവമായ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ഞാൻ അവരുടെ ദൈവമായിരിക്കേണ്ടതിന്നു ജാതികൾ കാൺകെ മിസ്രയീംദേശത്തുനിന്നു ഞാൻ കൊണ്ടുവന്ന അവരുടെ പൂർവ്വന്മാരോടു ചെയ്ത നിയമം ഞാൻ അവർക്കു വേണ്ടി ഓർക്കും; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","യഹോവ സീനായി പർവ്വതത്തിൽവെച്ചു തനിക്കും യിസ്രായേൽമക്കൾക്കും തമ്മിൽ മോശെമുഖാന്തരം വെച്ചിട്ടുള്ള ചട്ടങ്ങളും വിധികളും പ്രമാണങ്ങളും ഇവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","യിസ്രായേൽമക്കളോടു നീ പറയേണ്ടതു എന്തെന്നാൽ: ആരെങ്കിലും യഹോവെക്കു ഒരു നേർച്ച നിവർത്തിക്കുമ്പോൾ ആൾ നിന്റെ മതിപ്പുപോലെ യഹോവെക്കുള്ളവൻ ആകേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ഇരുപതു വയസ്സുമുതൽ അറുപതു വയസ്സുവരെയുള്ള ആണിന്നു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നിന്റെ മതിപ്പു അമ്പതു ശേക്കെൽ വെള്ളി ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","പെണ്ണായിരുന്നാൽ നിന്റെ മതിപ്പു മുപ്പതു ശേക്കെൽ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","അഞ്ചു വയസ്സുമുതൽ ഇരുപതു വയസ്സുവരെ എങ്കിൽ നിന്റെ മതിപ്പു ആണിന്നു ഇരുപതു ശേക്കെലും പെണ്ണിന്നു പത്തു ശേക്കെലും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ഒരു മാസം മുതൽ അഞ്ചു വയസ്സുവരെയുള്ളതായാൽ നിന്റെ മതിപ്പു ആണിന്നു അഞ്ചു ശേക്കെൽ വെള്ളിയും പെണ്ണിന്നു മൂന്നു ശേക്കെൽ വെള്ളിയും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","അറുപതു വയസ്സുമുതൽ മേലോട്ടെങ്കിൽ നിന്റെ മതിപ്പു ആണിന്നു പതിനഞ്ചു ശേക്കെലും പെണ്ണിന്നു പത്തു ശേക്കെലും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","നിന്റെ മതിപ്പുപോലെ കൊടുപ്പാൻ കഴിയാതവണ്ണം ഒരുത്തൻ ദരിദ്രനായിരുന്നാൽ അവനെ പുരോഹിതന്റെ മുമ്പാകെ കൊണ്ടുവന്നു നിർത്തേണം; പുരോഹിതൻ അവനെ മതിക്കേണം; നേർന്നവന്റെ പ്രാപ്തിക്കു ഒത്തവണ്ണം പുരോഹിതൻ അവനെ മതിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","അതു യഹോവെക്കു വഴിപാടു കഴിപ്പാൻ തക്ക മൃഗം ആകുന്നു എങ്കിൽ ആ വകയിൽ നിന്നു യഹോവെക്കു കൊടുക്കുന്നതൊക്കെയും വിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","തീയതിന്നു പകരം നല്ലതു, നല്ലതിന്നു പകരം തീയതു ഇങ്ങനെ മാറ്റുകയോ വ്യത്യാസം വരുത്തുകയോ ചെയ്യരുതു; മൃഗത്തിന്നു മൃഗത്തെ വെച്ചുമാറുന്നു എങ്കിൽ അതും വെച്ചുമാറിയതും വിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","അതു യഹോവെക്കു വഴിപാടു കഴിച്ചുകൂടാത്ത അശുദ്ധമൃഗമാകുന്നു എങ്കിൽ ആ മൃഗത്തെ പുരോഹിതന്റെ മുമ്പാകെ നിർത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","അതു നല്ലതോ തീയതോ ആയിരിക്കുന്നതിന്നു ഒത്തവണ്ണം പുരോഹിതൻ അതിനെ മതിക്കേണം; പുരോഹിതനായ നീ അതിനെ മതിക്കുന്നതുപോലെ തന്നേ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","അതിനെ വീണ്ടെടുക്കുന്നു എങ്കിൽ നീ മതിച്ച തുകയോടു അഞ്ചിലൊന്നു കൂട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","ഒരുത്തൻ തന്റെ വീടു യഹോവെക്കു വിശുദ്ധമായിരിക്കേണ്ടതിന്നു വിശുദ്ധീകരിച്ചാൽ അതു നല്ലതെങ്കിലും തീയതെങ്കിലും പുരോഹിതൻ അതു മതിക്കേണം; പുരോഹിതൻ മതിക്കുന്നതുപോലെ തന്നേ അതു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","തന്റെ വീടു വിശുദ്ധീകരിച്ചാൽ അതു വീണ്ടെടുക്കുന്നെങ്കിൽ അവൻ നിന്റെ മതിപ്പുവിലയുടെ അഞ്ചിലൊന്നു അതിനോടു കൂട്ടേണം; എന്നാൽ അതു അവന്നുള്ളതാകും. ");
INSERT INTO mal2015_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","ഒരുത്തൻ തന്റെ അവകാശനിലത്തിൽ ഏതാനും യഹോവെക്കു വിശുദ്ധീകരിച്ചാൽ നിന്റെ മതിപ്പു അതിന്റെ വിത്തുപാടിന്നു ഒത്തവണ്ണം ആയിരിക്കേണം; ഒരു ഹോമെർ യവം വിതെക്കുന്ന നിലത്തിന്നു അമ്പതു ശേക്കെൽ വെള്ളി മതിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","യോബേൽസംവത്സരംമുതൽ അവൻ തന്റെ നിലം വിശുദ്ധീകരിച്ചാൽ അതു നിന്റെ മതിപ്പുപോലെ ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","യോബേൽസംവത്സരത്തിന്റെ ശേഷം അവൻ അതിനെ വിശുദ്ധീകരിച്ചാലോ യോബേൽസംവത്സരംവരെ ശേഷിക്കുന്ന സംവത്സരങ്ങൾക്കു ഒത്തവണ്ണം പുരോഹിതൻ അതിന്റെ വില കണക്കാക്കേണം; അതു നിന്റെ മതിപ്പിൽനിന്നു കുറെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","നിലം വിശുദ്ധീകരിച്ചവൻ അതു വീണ്ടെടുക്കുന്നെങ്കിൽ അവൻ നിന്റെ മതിപ്പുവിലയുടെ അഞ്ചിലൊന്നു അതിനോടു കൂട്ടേണം; എന്നാൽ അതു അവന്നു സ്ഥിരമായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","അവൻ നിലം വീണ്ടെടുക്കാതെ മറ്റൊരുത്തന്നു വിറ്റാലോ പിന്നെ അതു വീണ്ടെടുത്തുകൂടാ. ");
INSERT INTO mal2015_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ആ നിലം യൊബേൽസംവത്സരത്തിൽ ഒഴിഞ്ഞുകൊടുക്കുമ്പോൾ ശപഥാർപ്പിതഭൂമിപോലെ യഹോവെക്കു വിശുദ്ധമായിരിക്കേണം; അതിന്റെ അനുഭവം പുരോഹിതന്നു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","തന്റെ അവകാശനിലങ്ങളിൽ ഉൾപ്പെടാതെ സ്വായർജ്ജിതമായുള്ള ഒരു നിലം ഒരുത്തൻ യഹോവെക്കു ശുദ്ധീകരിച്ചാൽ ");
INSERT INTO mal2015_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","പുരോഹിതൻ യോബേൽസംവത്സരംവരെ മതിപ്പുവില കണക്കാക്കേണം; നിന്റെ മതിപ്പുവില അവൻ അന്നുതന്നേ യഹോവെക്കു വിശുദ്ധമായി കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ആ നിലം മുന്നുടമസ്ഥന്നു യോബേൽസംവത്സരത്തിൽ തിരികെ ചേരേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","നിന്റെ മതിപ്പു ഒക്കെയും ശേക്കെലിന്നു ഇരുപതു ഗേരാവെച്ചു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","കടിഞ്ഞൂൽപിറവിയാൽ യഹോവെക്കുള്ളതായ മൃഗത്തെ മാത്രം ആരും വിശുദ്ധീകരിക്കരുതു; മാടായാലും ആടായാലും അതു യഹോവെക്കുള്ളതു ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","അതു അശുദ്ധമൃഗമാകുന്നു എങ്കിൽ മതിപ്പുവിലയും അതിന്റെ അഞ്ചിലൊന്നും കൂടെ കൊടുത്തു അതിനെ വീണ്ടെടുക്കേണം; വീണ്ടെടുക്കുന്നില്ലെങ്കിൽ നിന്റെ മതിപ്പുവിലെക്കു അതിനെ വിൽക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","എന്നാൽ ഒരുത്തൻ തനിക്കുള്ള ആൾ, മൃഗം, അവകാശനിലം മുതലായി യഹോവെക്കു കൊടുക്കുന്ന യാതൊരു ശപഥാർപ്പിതവും വിൽക്കയോ വീണ്ടെടുക്കയോ ചെയ്തുകൂടാ; ശപഥാർപ്പിതം ഒക്കെയും യഹോവെക്കു അതിവിശുദ്ധം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","മനുഷ്യവർഗ്ഗത്തിൽനിന്നു ശപഥാർപ്പിതമായി കൊടുക്കുന്ന ആരെയും വീണ്ടെടുക്കാതെ കൊന്നുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","നിലത്തിലെ വിത്തിലും വൃക്ഷത്തിന്റെ ഫലത്തിലും ദേശത്തിലെ ദശാംശം ഒക്കെയും യഹോവെക്കുള്ളതു ആകുന്നു; അതു യഹോവെക്കു വിശുദ്ധം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ആരെങ്കിലും തന്റെ ദശാംശത്തിൽ ഏതാനും വീണ്ടെടുക്കുന്നു എങ്കിൽ അതിനോടു അഞ്ചിലൊന്നുകൂടെ ചേർത്തുകൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","മാടാകട്ടെ ആടാകട്ടെ കോലിൻ കീഴെ കടന്നുപോകുന്ന എല്ലാറ്റിലും പത്തിലൊന്നു യഹോവെക്കു വിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","അതു നല്ലതോതീയതോ എന്നു ശോധനചെയ്യരുതു; വെച്ചുമാറുകയും അരുതു; വെച്ചുമാറുന്നു എങ്കിൽ അതും വെച്ചുമാറിയതും വിശുദ്ധമായിരിക്കേണം. അവയെ വീണ്ടെടുത്തുകൂടാ. ");
INSERT INTO mal2015_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","യിസ്രായേൽമക്കൾക്കുവേണ്ടി യഹോവ സീനായിപർവ്വതത്തിൽവെച്ചു മോശെയോടു കല്പിച്ച കല്പനകൾ ഇവതന്നേ.");
INSERT INTO mal2015_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","അവർ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെട്ടതിന്റെ രണ്ടാം സംവത്സരം രണ്ടാം മാസം ഒന്നാം തിയ്യതി യഹോവ സീനായിമരുഭൂമിയിൽ സമാഗമനകൂടാരത്തിൽവെച്ചു മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","നിങ്ങൾ യിസ്രായേൽമക്കളിൽ ഗോത്രംഗോത്രമായും കുടുംബംകുടുംബമായും സകലപുരുഷന്മാരെയും ആളാംപ്രതി പേർവഴി ചാർത്തി സംഘത്തിന്റെ ആകത്തുക എടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","നീയും അഹരോനും യിസ്രായേലിൽ ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു, യുദ്ധത്തിന്നു പുറപ്പെടുവാൻ പ്രാപ്തിയുള്ള എല്ലാവരെയും ഗണംഗണമായി എണ്ണേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ഓരോ ഗോത്രത്തിൽനിന്നു തന്റെ കുടുംബത്തിൽ തലവനായ ഒരുത്തൻ നിങ്ങളോടുകൂടെ ഉണ്ടായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","നിങ്ങളോടുകൂടെ നില്ക്കേണ്ടുന്ന പുരുഷന്മാരുടെ പേരാവിതു: രൂബേൻഗോത്രത്തിൽ ശെദേയൂരിന്റെ മകൻ എലീസൂർ; ");
INSERT INTO mal2015_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ശിമെയോൻ ഗോത്രത്തിൽ സൂരീശദ്ദായിയുടെ മകൻ ശെലൂമീയേൽ; ");
INSERT INTO mal2015_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","യെഹൂദാഗോത്രത്തിൽ അമ്മീനാദാബിന്റെ മകൻ നഹശോൻ; ");
INSERT INTO mal2015_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","യിസ്സാഖാർഗോത്രത്തിൽ സൂവാരിന്റെ മകൻ നെഥനയേൽ; ");
INSERT INTO mal2015_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","സെബൂലൂൻഗോത്രത്തിൽ ഹോലോന്റെ മകൻ എലീയാബ്; ");
INSERT INTO mal2015_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","യോസേഫിന്റെ മക്കളിൽ എഫ്രയീംഗോത്രത്തിൽ അമ്മീഹൂദിന്റെ മകൻ എലീശാമാ; മനശ്ശെഗോത്രത്തിൽ പെദാസൂരിന്റെ മകൻ ഗമലീയേൽ; ");
INSERT INTO mal2015_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ബെന്യാമീൻഗോത്രത്തിൽ ഗിദെയോനിയുടെ മകൻ അബീദാൻ; ");
INSERT INTO mal2015_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ദാൻഗോത്രത്തിൽ അമ്മീശദ്ദായിയുടെ മകൻ അഹീയേസെർ; ");
INSERT INTO mal2015_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ആശേർഗോത്രത്തിൽ ഒക്രാന്റെ മകൻ പഗീയേൽ; ");
INSERT INTO mal2015_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ഗാദ്ഗോത്രത്തിൽ ദെയൂവേലിന്റെ മകൻ എലീയാസാഫ്; ");
INSERT INTO mal2015_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","നഫ്താലിഗോത്രത്തിൽ ഏനാന്റെ മകൻ അഹീര. ");
INSERT INTO mal2015_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ഇവർ സംഘത്തിൽനിന്നു വിളിക്കപ്പെട്ടവരും തങ്ങളുടെ പിതൃഗോത്രങ്ങളിൽ പ്രഭുക്കന്മാരും യിസ്രായേലിൽ സഹസ്രാധിപന്മാരും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","കുറിക്കപ്പെട്ട ഈ പുരുഷന്മാരെ മോശെയും അഹരോനും കൂട്ടിക്കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","രണ്ടാം മാസം ഒന്നാം തിയ്യതി അവർ സർവ്വസഭയെയും വിളിച്ചുകൂട്ടി; അവർ ഗോത്രം ഗോത്രമായും കുടുംബംകുടുംബമായും ആളാംപ്രതി ഇരുപതു വയസ്സുമുതൽ മോലോട്ടു പേരുപേരായി താന്താങ്ങളുടെ വംശവിവരം അറിയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ അവൻ സീനായിമരുഭൂമിയിൽവെച്ചു അവരുടെ എണ്ണമെടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","യിസ്രായേലിന്റെ മൂത്തമകനായ രൂബേന്റെ മക്കളുടെ സന്തതികൾ കുലംകുലമായും കുടുംബംകുടുംബമായും ആളാംപ്രതി ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു, യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും ");
INSERT INTO mal2015_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","പേരുപേരായി രൂബേൻ ഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ നാല്പത്താറായിരത്തഞ്ഞൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ശിമെയോന്റെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ആളാംപ്രതി ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും ");
INSERT INTO mal2015_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","പേരുപേരായി ശിമെയോൻ ഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ അമ്പത്തൊമ്പതിനായിരത്തി മുന്നൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ഗാദിന്റെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും പേരുപേരായി ");
INSERT INTO mal2015_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ഗാദ്ഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ നാല്പത്തയ്യായിരത്തറുനൂറ്റമ്പതു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","യെഹൂദയുടെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും പേരുപേരായി ");
INSERT INTO mal2015_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","യെഹൂദാഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ എഴുപത്തുനാലായിരത്തറുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","യിസ്സാഖാരിന്റെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും പേരുപേരായി ");
INSERT INTO mal2015_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","യിസ്സാഖാർഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ അമ്പത്തുനാലായിരത്തി നാനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","സെബൂലൂന്റെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും ");
INSERT INTO mal2015_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","പേരുപേരായി സെബൂലൂൻ ഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ അമ്പത്തേഴായിരത്തി നാനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","യോസേഫിന്റെ മക്കളിൽ എഫ്രയീമിന്റെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും ");
INSERT INTO mal2015_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","പേരുപേരായി എഫ്രയീംഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ നാല്പതിനായിരത്തഞ്ഞൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","മനശ്ശെയുടെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും പേരുപേരായി ");
INSERT INTO mal2015_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","മനശ്ശെഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ മുപ്പത്തീരായിരത്തിരുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ബെന്യാമീന്റെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും പേരുപേരായി ");
INSERT INTO mal2015_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ബെന്യാമീൻ ഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ മുപ്പത്തയ്യായിരത്തി നാനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ദാന്റെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും പേരുപേരായി ");
INSERT INTO mal2015_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ദാൻഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ അറുപത്തീരായിരത്തെഴുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ആശേരിന്റെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും പേരുപേരായി ");
INSERT INTO mal2015_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ആശേർഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ നാല്പത്തോരായിരത്തഞ്ഞൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","നഫ്താലിയുടെ മക്കളുടെ സന്തതികളിൽ കുലംകുലമായും കുടുംബംകുടുംബമായും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരും പേരുപേരായി ");
INSERT INTO mal2015_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","നഫ്താലിഗോത്രത്തിൽ എണ്ണപ്പെട്ടവർ അമ്പത്തുമൂവായിരത്തി നാനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","മോശെയും അഹരോനും ഗോത്രത്തിന്നു ഒരുവൻ വീതം യിസ്രായേൽപ്രഭുക്കന്മാരായ പന്ത്രണ്ടു പുരുഷന്മാരുംകൂടി എണ്ണമെടുത്തവർ ഇവർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","യിസ്രായേൽമക്കളിൽ ഗോത്രംഗോത്രമായി ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള സകലപുരുഷന്മാരുമായി ");
INSERT INTO mal2015_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","എണ്ണപ്പെട്ടവർ ആകെ ആറുലക്ഷത്തി മൂവായിരത്തഞ്ഞൂറ്റമ്പതു പേർ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ഇവരുടെ കൂട്ടത്തിൽ ലേവ്യരെ പിതൃഗോത്രമായി എണ്ണിയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ലേവിഗോത്രത്തെ മാത്രം എണ്ണരുതു; ");
INSERT INTO mal2015_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","യിസ്രായേൽമക്കളുടെ ഇടയിൽ അവരുടെ സംഖ്യ എടുക്കയും അരുതു എന്നു യഹോവ മോശെയോടു കല്പിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ലേവ്യരെ സാക്ഷ്യനിവാസത്തിന്നും അതിന്റെ ഉപകരണങ്ങൾക്കും വസ്തുക്കൾക്കും ഒക്കെ വിചാരകന്മാരായി നിയമിക്കേണം; അവർ തിരുനിവാസവും അതിന്റെ ഉപകരണങ്ങളൊക്കെയും വഹിക്കേണം; അവർ അതിന്നു ശുശ്രൂഷ ചെയ്കയും തിരുനിവാസത്തിന്റെ ചുറ്റും പാളയമടിച്ചു പാർക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","തിരുനിവാസം പുറപ്പെടുമ്പോൾ ലേവ്യർ അതു അഴിച്ചെടുക്കേണം; തിരുനിവാസം അടിക്കുമ്പോൾ ലേവ്യർ അതു നിവിർത്തേണം; ഒരന്യൻ അടുത്തുവന്നാൽ മരണ ശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","യിസ്രായേൽമക്കൾ ഗണംഗണമായി ഓരോരുത്തൻ താന്താന്റെ പാളയത്തിലും ഓരോരുത്തൻ താന്താന്റെ കൊടിക്കരികെയും ഇങ്ങനെ കൂടാരം അടിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","എന്നാൽ യിസ്രായേൽമക്കളുടെ സംഘത്തിന്മേൽ ക്രോധം ഉണ്ടാകാതിരിക്കേണ്ടതിന്നു ലേവ്യർ സാക്ഷ്യനിവാസത്തിന്നു ചുറ്റം പാളയമിറങ്ങേണം; ലേവ്യർ സാക്ഷ്യനിവാസത്തിന്റെ കാര്യം നോക്കേണം ");
INSERT INTO mal2015_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","എന്നു യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ എല്ലാം യിസ്രായേൽമക്കൾ ചെയ്തു; അതുപോലെ തന്നേ അവർ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","യിസ്രായേൽമക്കളിൽ ഓരോരുത്തൻ താന്താന്റെ ഗോത്രത്തിന്റെ അടയാളത്തോടുകൂടിയ കൊടിക്കരികെ പാളയമിറങ്ങേണം; സമാഗമനകൂടാരത്തിന്നെതിരായി ചുറ്റും അവർ പാളയമിറങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","യെഹൂദാപാളയത്തിന്റെ കൊടിക്കീഴുള്ളവർ ഗണംഗണമായി കിഴക്കു സൂര്യോദയത്തിന്നു നേരെ പാളയമിറങ്ങേണം; യെഹൂദയുടെ മക്കൾക്കു അമ്മീനാദാബിന്റെ മകൻ നഹശോൻ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","അവന്റെ ഗണം ആകെ എഴുപത്തുനാലായിരത്തറുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","അവന്റെ അരികെ യിസ്സാഖാർഗോത്രം പാളയമിറങ്ങേണം; യിസ്സാഖാരിന്റെ മക്കൾക്കു സൂവാരിന്റെ മകൻ നെഥനയേൽ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","അവന്റെ ഗണം ആകെ അമ്പത്തുനാലായിരത്തി നാനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","പിന്നെ സെബൂലൂൻ ഗോത്രം; സെബൂലൂന്റെ മക്കൾക്കു ഹേലോന്റെ മകൻ എലീയാബ് പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","അവന്റെ ഗണം ആകെ അമ്പത്തേഴായിരത്തി നാനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","യെഹൂദാപാളയത്തിലെ ഗണങ്ങളിൽ എണ്ണപ്പെട്ടവർ ആകെ ലക്ഷത്തെൺപത്താറായിരത്തി നാനൂറു പേർ. ഇവർ ആദ്യം പുറപ്പെടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","രൂബേൻപാളയത്തിന്റെ കൊടിക്കീഴുള്ളവർ ഗണംഗണമായി തെക്കുഭാഗത്തു പാളയമിറങ്ങേണം; രൂബേന്റെ മക്കൾക്കു ശെദേയൂരിന്റെ മകൻ എലീസൂർ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","അവന്റെ ഗണം ആകെ നാല്പത്താറായിരത്തഞ്ഞൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","അവന്റെ അരികെ ശിമെയോൻഗോത്രം പാളയമിറങ്ങേണം; ശിമെയോന്റെ മക്കൾക്കു സൂരീശദ്ദായിയുടെ മകൻ ശെലൂമീയേൽ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","അവന്റെ ഗണം ആകെ അമ്പത്തൊമ്പതിനായിരത്തി മുന്നൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","പിന്നെ ഗാദ്ഗോത്രം; ഗാദിന്റെ മക്കൾക്കു രെയൂവേലിന്റെ മകൻ എലീയാസാഫ് പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","അവന്റെ ഗണം ആകെ നാല്പത്തയ്യായിരത്തറുനൂറ്റമ്പതു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","രൂബേൻ പാളയത്തിലെ ഗണങ്ങളിൽ എണ്ണപ്പെട്ടവർ ആകെ ഒരു ലക്ഷത്തമ്പത്തോരായിരത്തി നാനൂറ്റമ്പതു പേർ. അവർ രണ്ടാമതായി പുറപ്പെടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","പിന്നെ സമാഗമനകൂടാരം പാളയത്തിന്റെ നടുവിൽ ലേവ്യരുടെ പാളയവുമായി യാത്രചെയ്യേണം; അവർ പാളയമിറങ്ങുന്നതുപോലെ തന്നേ താന്താങ്ങളുടെ കൊടിക്കരികെ യഥാക്രമം പുറപ്പെടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","എഫ്രയീംപാളയത്തിന്റെ കൊടിക്കീഴുള്ളവർ ഗണംഗണമായി പടിഞ്ഞാറെഭാഗത്തു പാളയമിറങ്ങേണം; എഫ്രയീമിന്റെ മക്കൾക്കു അമ്മീഹൂദിന്റെ മകൻ എലീശാമാ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","അവന്റെ ഗണം ആകെ നാല്പതിനായിരത്തഞ്ഞൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","അവന്റെ അരികെ മനശ്ശെഗോത്രം പാളയമിറങ്ങേണം; മനശ്ശെയുടെ മക്കൾക്കു പെദാസൂരിന്റെ മകൻ ഗമലീയേൽ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","അവന്റെ ഗണം ആകെ മുപ്പത്തീരായിരത്തിരുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","പിന്നെ ബെന്യാമീൻ ഗോത്രം പാളയമിറങ്ങേണം; ബെന്യാമീന്റെ മക്കൾക്കു ഗിദെയോനിയുടെ മകൻ അബീദാൻ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","അവന്റെ ഗണം ആകെ മുപ്പത്തയ്യായിരത്തി നാനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","എഫ്രയീംപാളയത്തിലെ ഗണങ്ങളിൽ എണ്ണപ്പെട്ടവർ ആകെ ഒരു ലക്ഷത്തെണ്ണായിരത്തൊരുനൂറു പേർ. അവർ മൂന്നാമതായി പുറപ്പെടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ദാൻപാളയത്തിന്റെ കൊടിക്കീഴുള്ളവർ ഗണംഗണമായി വടക്കെഭാഗത്തു പാളയമിറങ്ങേണം; ദാന്റെ മക്കൾക്കു അമ്മീശദ്ദായിയുടെ മകൻ അഹീയേസർ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","അവന്റെ ഗണം ആകെ അറുപത്തീരായിരത്തെഴുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","അവന്റെ അരികെ ആശേർഗോത്രം പാളയമിറങ്ങേണം; ആശേരിന്റെ മക്കൾക്കു ഒക്രാന്റെ മകൻ പഗീയേൽ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","അവന്റെ ഗണം ആകെ നാല്പത്തോരായിരത്തഞ്ഞൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","പിന്നെ നഫ്താലിഗോത്രം പാളയമിറങ്ങേണം; നഫ്താലിയുടെ മക്കൾക്കു ഏനാന്റെ മകൻ അഹീര പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","അവന്റെ ഗണം ആകെ അമ്പത്തുമൂവായിരത്തി നാനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ദാൻപാളയത്തിലെ ഗണങ്ങളിൽ എണ്ണപ്പെട്ടവർ ആകെ ഒരു ലക്ഷത്തമ്പത്തേഴായിരത്തറുനൂറു പേർ. അവർ തങ്ങളുടെ കൊടികളോടുകൂടെ ഒടുവിൽ പുറപ്പെടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","യിസ്രായേൽമക്കളിൽ ഗോത്രംഗോത്രമായി എണ്ണപ്പെട്ടവർ ഇവർ തന്നേ. പാളയങ്ങളിൽ ഗണംഗണമായി എണ്ണപ്പെട്ടവർ ആകെ ആറുലക്ഷത്തി മൂവായിരത്തഞ്ഞുറ്റമ്പതുപേർ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","എന്നാൽ യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ യിസ്രായേൽമക്കളുടെ കൂട്ടത്തിൽ ലേവ്യരെ എണ്ണിയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ ഒക്കെയും യിസ്രായേൽമക്കൾ ചെയ്തു; അങ്ങനെ തന്നേ അവർ താന്താങ്ങളുടെ കൊടിക്കരികെ പാളയമിറങ്ങി; അങ്ങനെ തന്നേ അവർ കുടുംബംകുടുംബമായും കുലംകുലമായും പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","യഹോവ സീനായിപർവ്വതത്തിൽവെച്ചു മോശെയോടു അരുളിച്ചെയ്ത കാലത്തു അഹരോന്റെയും മോശെയുടെയും വംശപാരമ്പര്യമാവിതു: ");
INSERT INTO mal2015_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","അഹരോന്റെ പുത്രന്മാരുടെ പേരുകൾ ഇവ: ആദ്യജാതൻ നാദാബ്, അബീഹൂ, എലെയാസാർ, ഈഥാമാർ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","പുരോഹിതശുശ്രൂഷ ചെയ്‌വാൻ പ്രതിഷ്ഠിക്കപ്പെട്ടവരായി അഭിഷേകം ലഭിച്ച പുരോഹിതന്മാരായ അഹരോന്റെ പുത്രന്മാരുടെ പേരുകൾ ഇവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","എന്നാൽ നാദാബും അബീഹൂവും സീനായിമരുഭൂമിയിൽവെച്ചു യഹോവയുടെ സന്നിധിയിൽ അന്യാഗ്നി കത്തിച്ചപ്പോൾ യഹോവയുടെ സന്നിധിയിൽവെച്ചു മരിച്ചുപോയി; അവർക്കു മക്കൾ ഉണ്ടായിരുന്നില്ല; എലെയാസാരും ഈഥാമാരും അപ്പനായ അഹരോന്റെ മുമ്പാകെ പുരോഹിതശുശ്രൂഷ ചെയ്തുപോന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","നീ ലേവിഗോത്രത്തെ അടുക്കൽ വരുത്തി പുരോഹിതനായ അഹരോന്നു ശുശ്രൂഷ ചെയ്യേണ്ടതിന്നു അവന്റെ മുമ്പാകെ നിർത്തുക. ");
INSERT INTO mal2015_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","അവർ സമാഗമനകൂടാരത്തിന്റെ മുമ്പിൽ അവന്റെ കാര്യവും സർവ്വസഭയുടെ കാര്യവും നോക്കി തിരുനിവാസത്തിലെ വേല ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","അവർ സമാഗമനകൂടാരത്തിന്നുള്ള ഉപകരണങ്ങളൊക്കെയും യിസ്രായേൽമക്കളുടെ കാര്യവും നോക്കി കൂടാരം സംബന്ധിച്ചുള്ള വേല ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","നീ ലേവ്യരെ അഹരോന്നും അവന്റെ പുത്രന്മാർക്കും കൊടുക്കേണം; യിസ്രായേൽമക്കളിൽനിന്നു അവർ അവന്നു സാക്ഷാൽ ദാനമായുള്ളവർ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","അഹരോനെയും പുത്രന്മാരെയും പൗരോഹിത്യം നടത്തുവാൻ നിയമിച്ചാക്കേണം; അടുത്തുവരുന്ന അന്യൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","യിസ്രായേൽമക്കളുടെ ഇടയിൽ പിറക്കുന്ന എല്ലാകടിഞ്ഞൂലിന്നും പകരം ഞാൻ ലേവ്യരെ യിസ്രായേൽമക്കളിൽനിന്നു എടുത്തിരിക്കുന്നു; ലേവ്യർ എനിക്കുള്ളവരായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","കടിഞ്ഞൂലെല്ലാം എനിക്കുള്ളതു; ഞാൻ മിസ്രയീംദേശത്തു കടിഞ്ഞൂലിനെ ഒക്കെയും കൊന്നനാളിൽ യിസ്രായേലിൽ മനുഷ്യന്റെയും മൃഗത്തിന്റെയും കടിഞ്ഞൂലിനെയെല്ലാം എനിക്കായിട്ടു ശുദ്ധീകരിച്ചു; അതു എനിക്കുള്ളതായിരിക്കേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","യഹോവ പിന്നെയും സീനായിമരുഭൂമിയിൽവെച്ചു മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","ലേവ്യരെ കുലംകുലമായും കുടുംബംകുടുംബമായും എണ്ണുക; അവരിൽ ഒരു മാസംമുതൽ മേലോട്ടു പ്രായമുള്ള ആണിനെ ഒക്കെയും നീ എണ്ണേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","തന്നോടു കല്പിച്ചതുപോലെ മോശെ യഹോവയുടെ വചനപ്രകാരം അവരെ എണ്ണി. ");
INSERT INTO mal2015_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ലേവിയുടെ പുത്രന്മാരുടെ പേരുകൾ: ഗേർശോൻ, കെഹാത്ത്, മെരാരി. ");
INSERT INTO mal2015_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","കുടുംബംകുടുംബമായി ഗേർശോന്റെ പുത്രന്മാരുടെ പേരുകൾ: ");
INSERT INTO mal2015_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ലിബ്നി, ശിമെയി. കുടുംബംകുടുംബമായി കെഹാത്തിന്റെ പുത്രന്മാർ: അമ്രാം, യിസ്ഹാർ, ഹെബ്രോൻ, ഉസ്സീയേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","കുടുംബംകുടുംബമായി മെരാരിയുടെ പുത്രന്മാർ: മഹ്ലി, മൂശി. ഇവർതന്നേ കുലംകുലമായി ലേവിയുടെ കുടുംബങ്ങൾ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ഗേർശോനിൽനിന്നു ലിബ്നിയരുടെ കുടുംബവും ശിമ്യരുടെ കുടുംബവും ഉത്ഭവിച്ചു; ഇവ ഗേർശോന്യകുടുംബങ്ങൾ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","അവരിൽ ഒരു മാസംമുതൽ മേലോട്ടു പ്രായമുള്ള ആണുങ്ങളുടെ സംഖ്യയിൽ എണ്ണപ്പെട്ടവരുടെ ആകത്തുക ഏഴായിരത്തഞ്ഞൂറു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ഗേർശോന്യകുടുംബങ്ങൾ തിരുനിവാസത്തിന്റെ പുറകിൽ പടിഞ്ഞാറെഭാഗത്തു പാളയമിറങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ഗേർശോന്യരുടെ പിതൃഭവനത്തിന്നു ലായേലിന്റെ മകൻ എലീയാസാഫ് പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","സമാഗമനകൂടാരത്തിൽ ഗേർശോന്യർ നോക്കേണ്ടതു തിരുനിവാസവും കൂടാരവും അതിന്റെ പുറമൂടിയും സമാഗമനകൂടാരത്തിന്റെ വാതിലിന്നുള്ള മറശ്ശീലയും ");
INSERT INTO mal2015_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","തിരുനിവാസത്തിന്നും യാഗപീഠത്തിന്നും ചുറ്റുമുള്ള പ്രാകാരത്തിന്റെ മറശ്ശീലയും പ്രാകാരവാതിലിന്റെ മറശ്ശീലയും അതിന്റെ എല്ലാവേലെക്കും ഉള്ള കയറുകളും ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","കെഹാത്തിൽനിന്നു അമ്രാമ്യരുടെ കുടുംബവും യിസ്ഹാര്യരുടെ കുടുംബവും ഹെബ്രോന്യരുടെ കുടുംബവും ഉസ്സീയേല്യരുടെ കുടുംബവും ഉത്ഭവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ഇവ കെഹാത്യരുടെ കുടുംബങ്ങൾ. ഒരു മാസംമുതൽ മേലോട്ടു പ്രായമുള്ള എല്ലാ ആണുങ്ങളുടെയും സംഖ്യയിൽ വിശുദ്ധമന്ദിരത്തിന്റെ കാര്യം നോക്കുന്നവർ എണ്ണായിരത്തറുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","കെഹാത്യകുടുംബങ്ങൾ തിരുനിവാസത്തിന്റെ തെക്കെഭാഗത്തു പാളയമിറങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","കെഹാത്യകുടുംബങ്ങളുടെ പിതൃഭവനത്തിന്നു ഉസ്സീയേലിന്റെ മകൻ എലീസാഫാൻ പ്രഭു ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","അവർ നോക്കേണ്ടതു പെട്ടകം, മേശ, നിലവിളക്കു, പീഠങ്ങൾ, വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷെക്കുള്ള ഉപകരണങ്ങൾ, തിരശ്ശീല എന്നിവയും അവെക്കുള്ള വേല ഒക്കെയും ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","പുരോഹിതനായ അഹരോന്റെ മകൻ എലെയാസാർ ലേവ്യർക്കു പ്രധാനപ്രഭുവും വിശുദ്ധമന്ദിരത്തിലെ കാര്യം നോക്കുന്നവരുടെ മേൽവിചാരകനും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","മെരാരിയിൽനിന്നു മഹ്ലിയരുടെ കുടുംബവും മൂശ്യരുടെ കുടുംബവും ഉത്ഭവിച്ചു; മെരാര്യകുടുംബങ്ങൾ ഇവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","അവരിൽ ഒരു മാസംമുതൽ മേലോട്ടു പ്രായമുള്ള ആണുങ്ങളുടെ സംഖ്യയിൽ എണ്ണപ്പെട്ടവർ ആറായിരത്തിരുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","മെരാര്യകുടുംബങ്ങളുടെ പിതൃഭവനത്തിന്നു അബീഹയിലിന്റെ മകൻ സൂരിയേൽ പ്രഭു ആയിരിക്കേണം; ഇവർ തിരുനിവാസത്തിന്റെ വടക്കെ ഭാഗത്തു പാളയമിറങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","മെരാര്യർ നോക്കുവാൻ നിയമിച്ചിട്ടുള്ളതു തിരുനിവാസത്തിന്റെ പലക, അന്താഴം, തൂൺ, ചുവടു, അതിന്റെ ഉപകരണങ്ങൾ ഒക്കെയും, അതു സംബന്ധിച്ചുള്ള എല്ലാവേലയും, ");
INSERT INTO mal2015_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","പ്രാകാരത്തിന്റെ ചുറ്റും ഉള്ള തൂൺ, അവയുടെ ചുവടു, കുറ്റി, കയറു എന്നിവ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","എന്നാൽ തിരുനിവാസത്തിന്റെ മുൻവശത്തു കിഴക്കു, സമാഗമനകൂടാരത്തിന്റെ മുൻവശത്തു തന്നേ, സൂര്യോദയത്തിന്നു നേരെ മോശെയും അഹരോനും അവന്റെ പുത്രന്മാരും പാളയമിറങ്ങുകയും യിസ്രായേൽമക്കളുടെ കാര്യമായ വിശുദ്ധമന്ദിരത്തിന്റെ കാര്യം നോക്കുകയും വേണം; അന്യൻ അടുത്തുവന്നാൽ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","മോശെയും അഹരോനും യഹോവയുടെ വചനപ്രകാരം കുടുംബംകുടുംബമായി എണ്ണിയ ലേവ്യരിൽ ഒരു മാസംമുതൽ മോലോട്ടു പ്രായമുള്ള ആണുങ്ങൾ ആകെ ഇരുപത്തീരായിരം പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","യഹോവ പിന്നെയും മോശെയോടു കല്പിച്ചതു: യിസ്രായേൽമക്കളിൽ ഒരു മാസംമുതൽ മേലോട്ടു പ്രായമുള്ള ആദ്യജാതന്മാരായ ആണുങ്ങളെ ഒക്കെയും എണ്ണി പേരുപേരായി അവരുടെ സംഖ്യ എടുക്കുക. ");
INSERT INTO mal2015_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","യിസ്രായേൽമക്കളിലെ എല്ലാകടിഞ്ഞൂലുകൾക്കും പകരം ലേവ്യരുടെ മൃഗങ്ങളെയും എനിക്കായിട്ടു എടുക്കേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","യഹോവ തന്നോടു കല്പിച്ചതുപോലെ മോശെ യിസ്രായേൽമക്കളുടെ എല്ലാകടിഞ്ഞൂലുകളെയും എണ്ണി. ");
INSERT INTO mal2015_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ഒരു മാസംമുതൽ മേലോട്ടു പ്രായമുള്ള ആദ്യജാതന്മാരായ എല്ലാ ആണുങ്ങളെയും പേരുപേരായി എണ്ണിയ ആകത്തുക ഇരുപത്തീരായിരത്തിരുനൂറ്റെഴുപത്തുമൂന്നു ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","യിസ്രായേൽമക്കളിൽ എല്ലാകടിഞ്ഞൂലുകൾക്കും പകരം ലേവ്യരെയും അവരുടെ മൃഗങ്ങൾക്കു പകരം ലേവ്യരുടെ മൃഗങ്ങളെയും എടുക്ക; ലേവ്യർ എനിക്കുള്ളവരായിരിക്കേണം; ഞാൻ യഹോവ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","യിസ്രായേൽമക്കളുടെ കടിഞ്ഞൂലുകളിൽ ലേവ്യരുടെ എണ്ണത്തെ കവിഞ്ഞുള്ള ഇരുനൂറ്റെഴുപത്തുമൂന്നു പേരുടെ വീണ്ടെടുപ്പിന്നായി തലക്കു അഞ്ചു ശേക്കെൽ വീതം വാങ്ങേണം; ");
INSERT INTO mal2015_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം ശേക്കെൽ ഒന്നിന്നു ഇരുപതു ഗേരാവെച്ചു വാങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","അവരുടെ എണ്ണത്തെ കവിയുന്നവരുടെ വീണ്ടെടുപ്പുവില അഹരോന്നും അവന്റെ മക്കൾക്കും കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ലേവ്യരെക്കൊണ്ടു വീണ്ടെടുത്തവരുടെ എണ്ണത്തെ കവിഞ്ഞുള്ളവരുടെ വീണ്ടെടുപ്പുവില മോശെ വാങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","യിസ്രായേൽമക്കളുടെ ആദ്യജാതന്മാരോടു അവൻ വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം ഒരായിരത്തി മൂന്നൂറ്ററുപത്തഞ്ചു ശേക്കെൽ പണം വാങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ വീണ്ടെടുത്തവരുടെ വില മോശെ അഹരോന്നും അവന്റെ മക്കൾക്കും യഹോവയുടെ വചനപ്രകാരം കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","ലേവ്യരിൽ വെച്ചു കെഹാത്യരിൽ മുപ്പതു വയസ്സുമുതൽ അമ്പതു വയസ്സുവരെയുള്ളവരായി സമാഗമനകൂടാരത്തിൽ ");
INSERT INTO mal2015_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","വേലചെയ്‌വാൻ സേവയിൽ പ്രവേശിക്കുന്ന എല്ലാവരെയും കുടുംബംകുടുംബമായും കുലംകുലമായും എണ്ണി തുക എടുപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","സമാഗമനകൂടാരത്തിൽ അതിവിശുദ്ധകാര്യങ്ങളെ സംബന്ധിച്ചു കെഹാത്യരുടെ വേല എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","പാളയം യാത്രപുറപ്പെടുമ്പോൾ അഹരോനും പുത്രന്മാരും വന്നു തിരശ്ശീല ഇറക്കി അതുകൊണ്ടു സാക്ഷ്യപെട്ടകം മൂടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","തഹശൂതോൽകൊണ്ടുള്ള മൂടി അതിന്മേൽ ഇട്ടു അതിന്നു മീതെ നീലശ്ശീല വിരിച്ചു തണ്ടു ചെലുത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","കാഴ്ചയപ്പത്തിന്റെ മേശമേലും ഒരു നീലശ്ശീല വിരിച്ചു അതിന്മേൽ തളികകളും കരണ്ടികളും കിണ്ടികളും പകരുന്നതിന്നുള്ള കുടങ്ങളും വെക്കേണം; നിരന്തരമായ അപ്പവും അതിന്മേൽ ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","അവയുടെമേൽ ഒരു ചുവപ്പുശീല വിരിച്ചു തഹശൂതോൽകൊണ്ടുള്ള മൂടുവിരിയാൽ അതു മൂടുകയും തണ്ടു ചെലുത്തുകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ഒരു നീലശ്ശീല എടുത്തു വെളിച്ചത്തിന്നുള്ള നിലവിളക്കും അതിന്റെ ദീപങ്ങളും ചവണകളും കരിന്തിരി മുറിച്ചിടുന്ന പാത്രങ്ങളും അതിന്റെ ഉപയോഗത്തിന്നുള്ള എല്ലാ എണ്ണക്കുടങ്ങളും മൂടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","അതും അതിന്റെ പാത്രങ്ങളൊക്കെയും തഹശൂതോൽകൊണ്ടുള്ള ഒരു വിരിയിൽ പൊതിഞ്ഞു ഒരു തണ്ടിന്മേൽ വെച്ചുകെട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","സ്വർണ്ണ പീഠത്തിന്മേലും അവർ ഒരു നീലശ്ശീല വിരിച്ചു തഹശ്ശൂതോൽകൊണ്ടുള്ള ഒരു വിരിയാൽ മൂടുകയും തണ്ടു ചെലുത്തുകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","വിശുദ്ധമന്ദിരത്തിലെ ശുശ്രൂഷെക്കുള്ള ഉപകരണങ്ങളൊക്കെയും അവർ എടുത്തു ഒരു നീലശ്ശീലയിൽ പൊതിഞ്ഞു തഹശൂതോൽകൊണ്ടുള്ള ഒരു വിരിയാൽ മൂടുകയും ഒരു തണ്ടിന്മേൽ വെച്ചുകെട്ടുകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","അവർ യാഗപീഠത്തിൽനിന്നു വെണ്ണീർ നീക്കി അതിന്മേൽ ഒരു ധൂമ്രശീല വിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","അവർ അതിന്മേൽ ശുശ്രൂഷചെയ്യേണ്ടതിന്നുള്ള ഉപകരണങ്ങളായ കലശം, മുൾക്കൊളുത്തു, ചട്ടുകം, കലം എന്നിങ്ങനെ യാഗപീഠത്തിന്റെ ഉപകരണങ്ങളൊക്കെയും അതിന്മേൽ വെക്കേണം; തഹശൂതോൽകൊണ്ടുള്ള ഒരു വിരി അതിന്മേൽ വിരിക്കയും തണ്ടു ചെലുത്തുകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","പാളയം യാത്രപുറപ്പെടുമ്പോൾ അഹരോനും പുത്രന്മാരും വിശുദ്ധമന്ദിരവും വിശുദ്ധമന്ദിരത്തിലെ ഉപകരണങ്ങളൊക്കെയും മൂടി തീർന്നശേഷം കെഹാത്യർ ചുമപ്പാൻ വരേണം; എന്നാൽ അവർ മരിക്കാതിരിക്കേണ്ടതിന്നു വിശുദ്ധമായതൊന്നും തൊടരുതു; സമാഗമനകൂടാരത്തിൽ കെഹാത്യരുടെ ചുമടു ഇവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","പുരോഹിതനായ അഹരോന്റെ മകൻ എലെയാസാർ നോക്കേണ്ടതു: വെളിച്ചത്തിന്നുള്ള എണ്ണ, സുഗന്ധധൂപവർഗ്ഗം, നിരന്തരഭോജനയാഗം, അഭിഷേകതൈലം എന്നിവയും തിരുനിവാസം മുഴുവനും അതിലുള്ളതൊക്കെയും വിശുദ്ധമന്ദിരവും അതിന്റെ ഉപകരണങ്ങളും തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","നിങ്ങൾ കെഹാത്യകുടുംബങ്ങളുടെ ഗോത്രത്തെ ലേവ്യരിൽനിന്നു ഛേദിച്ചുകളയരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","അവർ അതിവിശുദ്ധവസ്തുക്കളോടു അടുക്കുമ്പോൾ മരിക്കാതെ ജീവനോടിരിക്കേണ്ടതിന്നു ഇങ്ങനെ ചെയ്‌വിൻ: അഹരോനും പുത്രന്മാരും അകത്തു കടന്നു അവരിൽ ഓരോരുത്തനെ അവനവന്റെ വേലെക്കും അവനവന്റെ ചുമട്ടിന്നും ആക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","എന്നാൽ അവർ വിശുദ്ധമന്ദിരം കണ്ടിട്ടു മരിച്ചുപോകാതിരിക്കേണ്ടതിന്നു ക്ഷണനേരംപോലും അകത്തു കടക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","ഗേർശോന്യരെയും കുലംകുലമായും കുടുംബംകുടുംബമായും എണ്ണി തുക എടുക്കുക. ");
INSERT INTO mal2015_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","മുപ്പതു വയസ്സുമുതൽ അമ്പതു വയസ്സുവരെ സമാഗമനകൂടാരത്തിൽ വേല ചെയ്‌വാൻ സേവയിൽ പ്രവേശിക്കുന്ന എല്ലാവരെയും എണ്ണേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","സേവ ചെയ്യുന്നതിലും ചുമടെടുക്കുന്നതിലും ഗേർശോന്യകുടുംബങ്ങൾക്കുള്ള വേല എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","തിരുനിവാസത്തിന്റെ തിരശ്ശീല, സമാഗമനകൂടാരം, അതിന്റെ മൂടുവിരി, തഹശുതോൽകൊണ്ടു അതിന്മേലുള്ള പുറമൂടി, സമാഗമനകൂടാരത്തിന്റെ വാതിലിന്നുള്ള മറശ്ശീല, ");
INSERT INTO mal2015_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","പ്രാകാരത്തിന്റെ മറശ്ശീല, തിരുനിവാസത്തിന്നും യാഗപീഠത്തിന്നും ചുറ്റുമുള്ള പ്രാകാരത്തിന്റെ വാതിലിന്നുള്ള മറശ്ശീല, അവയുടെ കയറു എന്നിവയും അവയുടെ ഉപയോഗത്തിന്നുള്ള ഉപകരണങ്ങൾ ഒക്കെയും അവർ ചുമക്കേണം; അവയെ സംബന്ധിച്ചു ചെയ്‌വാനുള്ള വേലയൊക്കെയും അവർ ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ഗേർശോന്യരുടെ എല്ലാ ചുമടുകളും എല്ലാവേലയും സംബന്ധിച്ചുള്ളതൊക്കെയും അഹരോന്റെയും പുത്രന്മാരുടെയും കല്പനപ്രകാരം ആയിരിക്കേണം; അവരുടെ എല്ലാ ചുമടും നിങ്ങൾ അവരുടെ വിചാരണയിൽ ഏല്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","സമാഗമനകൂടാരത്തിൽ ഗേർശോന്യരുടെ കുടുംബങ്ങൾക്കുള്ള വേല ഇതു തന്നേ; അവരുടെ സേവ പുരോഹിതനായ അഹരോന്റെ മകൻ ഈഥാമാരിന്റെ കൈക്കീഴായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","മെരാര്യരെയും കുലംകുലമായും കുടുംബംകുടുംബമായും എണ്ണേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","മുപ്പതു വയസ്സുമുതൽ അമ്പതു വയസ്സുവരെ സമാഗമനകൂടാരത്തിലെ വേല ചെയ്‌വാൻ സേവയിൽ പ്രവേശിക്കുന്ന എല്ലാവരെയും നീ എണ്ണേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","സമാഗമനകൂടാരത്തിൽ അവർക്കുള്ള എല്ലാവേലയുടെയും മുറെക്കു അവർ എടുക്കേണ്ടുന്ന ചുമടു എന്തെന്നാൽ: തിരുനിവാസത്തിന്റെ പലക, അന്താഴം, തൂൺ, ചുവടു, ");
INSERT INTO mal2015_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ചുറ്റുമുള്ള പ്രാകാരത്തിന്റെ തൂൺ, ചുവടു, കുറ്റി, കയറു എന്നിവയും അവയുടെ ഉപകരണങ്ങളൊക്കെയും അവ സംബന്ധിച്ചുള്ള എല്ലാവേലയും തന്നേ; അവർ എടുക്കേണ്ടുന്ന ഉപകരണങ്ങൾ നിങ്ങൾ പേർവിവരമായി അവരെ ഏല്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","പുരോഹിതനായ അഹരോന്റെ മകൻ ഈഥാമാരിന്റെ കൈക്കീഴെ സമാഗമനകൂടാരത്തിൽ മെരാര്യരുടെ കുടുംബങ്ങൾക്കുള്ള സകലസേവയുടെയും മുറെക്കു അവർ ചെയ്യേണ്ടുന്ന വേല ഇതു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","മോശെയും അഹരോനും സഭയിലെ പ്രഭുക്കന്മാരും കെഹാത്യരിൽ മുപ്പതു വയസ്സുമുതൽ അമ്പതു വയസ്സുവരെ ");
INSERT INTO mal2015_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","സമാഗമനകൂടാരത്തിൽ വേല ചെയ്‌വാൻ സേവയിൽ പ്രവേശിക്കുന്ന എല്ലാവരെയും കുടുംബംകുടുംബമായും കുലംകുലമായും എണ്ണി. ");
INSERT INTO mal2015_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","അവരിൽ കുടുംബംകുടുംബമായി എണ്ണപ്പെട്ടവർ രണ്ടായിരത്തെഴുനൂറ്റമ്പതു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","മോശെമുഖാന്തരം യഹോവ കല്പിച്ചതുപോലെ മോശെയും അഹരോനും കെഹാത്യകുടുംബങ്ങളിൽ എണ്ണിയവരായി സമാഗമനകൂടാരത്തിൽ വേല ചെയ്‌വാനുള്ളവർ എല്ലാം ഇവർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ഗേർശോന്യരിൽ കുടുംബംകുടുംബമായും കുലംകുലമായും എണ്ണപ്പെട്ടവരോ ");
INSERT INTO mal2015_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","മുപ്പതുവയസ്സുമുതൽ അമ്പതു വയസ്സുവരെ സമാഗമനകൂടാരത്തിൽ വേല ചെയ്‌വാൻ സേവയിൽ പ്രവേശിക്കുന്നവരായി ");
INSERT INTO mal2015_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","കുടുംബംകുടുംബമായും കുലംകുലമായും എണ്ണപ്പെട്ടവർ രണ്ടായിരത്തറുനൂറ്റി മുപ്പതുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","യഹോവ കല്പിച്ചതുപോലെ മോശെയും അഹരോനും ഗേർശോന്യകുടുംബങ്ങളിൽ എണ്ണിയവരായി സമാഗമനകൂടാരത്തിൽ വേല ചെയ്‌വാനുള്ളവർ എല്ലാം ഇവർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","മെരാര്യകുടുംബങ്ങളിൽ കുടുംബംകുടുംബമായും കുലംകുലമായും എണ്ണപ്പെട്ടവരോ ");
INSERT INTO mal2015_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","മുപ്പതു വയസ്സുമുതൽ അമ്പതു വയസ്സുവരെ സമാഗമനകൂടാരത്തിൽ വേല ചെയ്‌വാൻ സേവയിൽ പ്രവേശിക്കുന്നവരായി ");
INSERT INTO mal2015_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","അവരിൽ കുടുംബംകുടുംബമായി എണ്ണപ്പെട്ടവർ ആകെ മൂവായിരത്തിരുനൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","യഹോവ മോശെമുഖാന്തരം കല്പിച്ചതുപോലെ മോശെയും അഹരോനും മെരാര്യകുടുംബങ്ങളിൽ എണ്ണിയവർ ഇവർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","മോശെയും അഹരോനും യിസ്രായേൽ പ്രഭുക്കന്മാരും ലേവ്യരിൽ കുടുംബംകുടുംബമായും കുലംകുലമായും എണ്ണിയവരായി മുപ്പതു വയസ്സുമുതൽ അമ്പതുവയസ്സുവരെ ");
INSERT INTO mal2015_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","സമാഗമനകൂടാരത്തിലെ സേവയും ചുമട്ടുവേലയും ചെയ്‌വാൻ പ്രവേശിച്ചവർ ആകെ ");
INSERT INTO mal2015_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","എണ്ണായിരത്തഞ്ഞൂറ്റെൺപതു പേർ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","യഹോവയുടെ കല്പനപ്രകാരം അവർ മോശെ മുഖാന്തരം ഓരോരുത്തൻ താന്താന്റെ വേലയ്ക്കും താന്താന്റെ ചുമട്ടിന്നും തക്കവണ്ണം എണ്ണപ്പെട്ടു; യഹോവ മോശെയോടു കല്പിച്ചപോലെ അവൻ അവരെ എണ്ണി. ");
INSERT INTO mal2015_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","സകലകുഷ്ഠരോഗിയെയും സകലസ്രവക്കാരനെയും ശവത്താൽ അശുദ്ധനായ ഏവനെയും പാളയത്തിൽനിന്നു പുറത്താക്കുവാൻ യിസ്രായേൽമക്കളോടു കല്പിക്ക. ");
INSERT INTO mal2015_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ആണായാലും പെണ്ണായാലും അവരെ പാളയത്തിൽനിന്നു പുറത്താക്കേണം; ഞാൻ അവരുടെ മദ്ധ്യേ വസിക്കയാൽ അവർ തങ്ങളുടെ പാളയം അശുദ്ധമാക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","യിസ്രായേൽമക്കൾ അങ്ങനെ ചെയ്തു അവരെ പാളയത്തിൽനിന്നു പുറത്താക്കി; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ യിസ്രായേൽമക്കൾ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","നീ യിസ്രായേൽമക്കളോടു പറക: ഒരു പുരുഷനോ സ്ത്രീയോ യഹോവയോടു ദ്രോഹിച്ചു മനുഷ്യരുടെ ഇടയിൽ നടപ്പുള്ള വല്ല പാപവും ചെയ്തിട്ടു കുറ്റക്കാരായാൽ ചെയ്ത പാപം ");
INSERT INTO mal2015_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","അവർ ഏറ്റുപറകയും തങ്ങളുടെ അകൃത്യത്തിന്നു പ്രതിശാന്തിയായി മുതലും അതിന്റെ അഞ്ചിലൊന്നും കൂട്ടി, തങ്ങൾ അകൃത്യം ചെയ്തവന്നു പകരം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","എന്നാൽ അകൃത്യത്തിന്നു പ്രതിശാന്തി വാങ്ങുവാൻ അവന്നു ചാർച്ചക്കാരൻ ഇല്ലെങ്കിൽ അകൃത്യത്തിന്നുള്ള പ്രതിശാന്തി യഹോവെക്കു കൊടുക്കുന്നതു പുരോഹിതന്നു ഇരിക്കേണം; അതുകൂടാതെ അവന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിപ്പാനുള്ള പ്രായശ്ചിത്തത്തിന്റെ ആട്ടുകൊറ്റനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","യിസ്രായേൽമക്കൾ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുവരുന്ന സകലവിശുദ്ധവസ്തുക്കളിലും ഉദർച്ചയായതൊക്കെയും അവന്നു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ആരെങ്കിലും ശുദ്ധീകരിച്ചർപ്പിക്കുന്ന വസ്തുക്കൾ അവന്നുള്ളവയായിരിക്കേണം; ആരെങ്കിലും പുരോഹിതന്നു കൊടുക്കുന്നതെല്ലാം അവന്നുള്ളതായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു. ");
INSERT INTO mal2015_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: വല്ല പുരുഷന്റെയും ഭാര്യ പിഴെച്ചു അവനോടു ദ്രോഹിച്ചു, ");
INSERT INTO mal2015_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ഒരുത്തൻ അവളോടുകൂടെ ശയിക്കയും അതു അവളുടെ ഭർത്താവിന്നു വെളിപ്പെടാതെ മറവായിരിക്കയും അവൾ അശുദ്ധയാകയും അവൾക്കു വിരോധമായി സാക്ഷിയില്ലാതിരക്കയും ");
INSERT INTO mal2015_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","അവൾ ക്രിയയിൽ പിടിപെടാതിരിക്കയും ശങ്കാവിഷം അവനെ ബാധിച്ചു അവൻ ഭാര്യയെ സംശയിക്കയും അവൾ അശുദ്ധയായിരിക്കയും ചെയ്താൽ, അല്ലെങ്കിൽ ശങ്കാവിഷം അവനെ ബാധിച്ചു അവൻ ഭാര്യയെ സംശയിക്കയും അവൾ അശുദ്ധയല്ലാതിരിക്കയും ചെയ്താൽ ");
INSERT INTO mal2015_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ആ പുരുഷൻ ഭാര്യയെ പുരോഹിതന്റെ അടുക്കൽ കൊണ്ടുചെല്ലേണം; അവൾക്കുവേണ്ടി വഴിപാടായിട്ടു ഒരിടങ്ങഴി യവപ്പൊടിയും കൊണ്ടുചെല്ലേണം; അതിന്മേൽ എണ്ണ ഒഴിക്കരുതു; കുന്തുരുക്കം ഇടുകയും അരുതു; അതു സംശയത്തിന്റെ ഭോജനയാഗമല്ലോ, അപരാധജ്ഞാപകമായ ഭോജനയാഗം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","പുരോഹിതൻ അവളെ അടുക്കൽ വരുത്തി യഹോവയുടെ സന്നിധിയിൽ നിർത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","പുരോഹിതൻ ഒരു മൺപാത്രത്തിൽ വിശുദ്ധജലം എടുക്കേണം; പുരോഹിതൻ തിരുനിവാസത്തിന്റെ നിലത്തെ പൊടി കുറെ എടുത്തു ആ വെള്ളത്തിൽ ഇടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","പുരോഹിതൻ സ്ത്രീയെ യഹോവയുടെ സന്നിധിയിൽ നിർത്തി അവളുടെ തലമുടി അഴിച്ചു അപരാധജ്ഞാപകത്തിന്റെ ഭോജനയാഗം അവളുടെ കയ്യിൽ വെക്കേണം; പുരോഹിതന്റെ കയ്യിൽ ശാപകരമായ കൈപ്പുവെള്ളവും ഉണ്ടായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","പുരോഹിതൻ അവളെക്കൊണ്ടു സത്യം ചെയ്യിച്ചു അവളോടു പറയേണ്ടതു: ആരും നിന്നോടുകൂടെ ശയിക്കയും നിനക്കു ഭർത്താവുണ്ടായിരിക്കെ നീ അശുദ്ധിയിലേക്കു തിരികയും ചെയ്തിട്ടില്ല എങ്കിൽ ശാപകരമായ ഈ കൈപ്പുവെള്ളത്തിന്റെ ദോഷം നിനക്കു വരാതിരിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","എന്നാൽ നിനക്കു ഭർത്താവുണ്ടായിരിക്കെ നീ പിഴെച്ചു അശുദ്ധയാകയും നിന്റെ ഭർത്താവല്ലാതെ മറ്റൊരു പുരുഷൻ നിന്നോടുകൂടെ ശയിക്കയും ചെയ്തിട്ടുണ്ടെങ്കിൽ - ");
INSERT INTO mal2015_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","അപ്പോൾ പുരോഹിതൻ സ്ത്രീയെക്കൊണ്ടു ശാപസത്യം ചെയ്യിച്ചു അവളോടു: യഹോവ നിന്റെ നിതംബം ക്ഷയിപ്പിക്കയും ഉദരം വീർപ്പിക്കയും ചെയ്തു നിന്റെ ജനത്തിന്റെ ഇടയിൽ നിന്നെ ശാപവും പ്രാക്കും ആക്കി തീർക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ശാപകരമായ ഈ വെള്ളം നിന്റെ കുടലിൽ ചെന്നു നിന്റെ ഉദരം വീർപ്പിക്കയും നിന്റെ നിതംബം ക്ഷിയിപ്പിക്കയും ചെയ്യും എന്നു പറയേണം. അതിന്നു സ്ത്രീ: ആമേൻ, ആമേൻ എന്നു പറയേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","പുരോഹിതൻ ഈ ശാപങ്ങൾ ഒരു പുസ്തകത്തിൽ എഴുതി കൈപ്പുവെള്ളത്തിൽ കഴുകി കലക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","അവൻ ശാപകരമായ കൈപ്പുവെള്ളം സ്ത്രീയെ കുടിപ്പിക്കേണം; ശാപകരമായ വെള്ളം അവളുടെ ഉള്ളിൽ ചെന്നു കൈപ്പായ്തീരും; ");
INSERT INTO mal2015_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","പുരോഹിതൻ സ്ത്രീയുടെ കയ്യിൽനിന്നു സംശയത്തിന്റെ ഭോജനയാഗം വാങ്ങി യഹോവയുടെ സന്നിധിയിൽ നീരാജനം ചെയ്തു യാഗപീഠത്തിന്മേൽ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","പിന്നെ പുരോഹിതൻ ഭോജനയാഗത്തിൽ ഒരു പിടി എടുത്തു യാഗപീഠത്തിന്മേൽ നിവേദ്യമായി ദഹിപ്പിക്കേണം; അതിന്റെ ശേഷം സ്ത്രീയെ ആ വെള്ളം കുടിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","അവൾ അശുദ്ധയായി തന്റെ ഭർത്താവോടു ദ്രോഹം ചെയ്തിട്ടുണ്ടെങ്കിൽ അവളെ വെള്ളം കുടിപ്പിച്ച ശേഷം ശാപകരമായ വെള്ളം അവളുടെ ഉള്ളിൽ ചെന്നു കൈപ്പായ്തീരും; അവളുടെ ഉദരം വീർക്കയും നിതംബം ക്ഷയിക്കയും സ്ത്രീ തന്റെ ജനത്തിന്റെ ഇടയിൽ ശാപഗ്രസ്തയായിരിക്കയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","എന്നാൽ സ്ത്രീ അശുദ്ധയാകാതെ നിർമ്മല ആകുന്നു എങ്കിൽ അവൾക്കു ദോഷം വരികയില്ല; അവൾ ഗർഭം ധരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","ഇതാകുന്നു പാതിവ്രത്യസംശയം സംബന്ധിച്ചുള്ള പ്രമാണം; ");
INSERT INTO mal2015_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ഒരു സ്ത്രീ ഭർത്താവുണ്ടായിരിക്കെ പിഴെച്ചു അശുദ്ധയാകയോ ശങ്കാവിഷം അവനെ ബാധിച്ചു, അവൻ ഭാര്യയെ സംശയിക്കയോ ചെയ്തിട്ടു അവളെ യഹോവയുടെ സന്നിധിയിൽ നിർത്തുമ്പോൾ പുരോഹിതൻ ഈ പ്രമാണമൊക്കെയും അവളിൽ നടത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","എന്നാൽ പുരുഷൻ അകൃത്യത്തിൽ ഓഹരിക്കാരനാകയില്ല; സ്ത്രീയോ തന്റെ അകൃത്യം വഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതെന്തെന്നാൽ: ഒരു പുരുഷനാകട്ടെ സ്ത്രീയാകട്ടെ യഹോവെക്കു തന്നെത്താൻ സമർപ്പിക്കേണ്ടതിന്നു നാസീർവ്രതം എന്ന വിശേഷ വിധിയായുള്ള വ്രതം ദീക്ഷിക്കുമ്പോൾ ");
INSERT INTO mal2015_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","വീഞ്ഞും മദ്യവും വർജ്ജിച്ചിരിക്കേണം: വീഞ്ഞിന്റെ കാടിയും മദ്യത്തിന്റെ കാടിയും കുടിക്കരുതു; മുന്തിരിപ്പഴത്തിന്റെ യാതൊരു രസവും കുടിക്കരുതു; മുന്തിരിങ്ങ പഴുത്തതാകട്ടെ ഉണങ്ങിയതാകട്ടെ തിന്നുകയുമരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","തന്റെ നാസീർവ്രതകാലത്തു ഒക്കെയും കുരുതൊട്ടു തൊലിവരെ മുന്തിരിങ്ങാകൊണ്ടു ഉണ്ടാക്കുന്നതു ഒന്നും അവൻ തിന്നരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","നാസീർവ്രതകാലത്തൊക്കെയും ക്ഷൗരക്കത്തി അവന്റെ തലയിൽ തൊടരുതു; യഹോവെക്കു തന്നെത്താൻ സമർപ്പിച്ചിരിക്കുന്ന കാലം തികയുവോളം അവൻ വിശുദ്ധനായിരിക്കേണം: തലമുടി വളർത്തേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","അവൻ യഹോവെക്കു തന്നെത്താൻ സമർപ്പിച്ചിരിക്കുന്ന കാലത്തൊക്കെയും ശവത്തിന്റെ അടുക്കൽ ചെല്ലരുതു; ");
INSERT INTO mal2015_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","അപ്പൻ, അമ്മ, സഹോദരൻ, സഹോദരി എന്നിവരിൽ ആരെങ്കിലും മരിക്കുമ്പോൾ അവരാൽ അവൻ തന്നെത്താൻ അശുദ്ധനാകരുതു; അവന്റെ ദൈവത്തിന്റെ നാസീർവ്രതം അവന്റെ തലയിൽ ഇരിക്കുന്നു; ");
INSERT INTO mal2015_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","നാസീർവ്രതകാലത്തു ഒക്കെയും അവൻ യഹോവെക്കു വിശുദ്ധൻ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","അവന്റെ അടുക്കൽവെച്ചു വല്ലവനും പെട്ടെന്നു മരിക്കയും അവന്റെ നാസീർവ്രതമുള്ള തലയെ അശുദ്ധമാക്കുകയും ചെയ്താൽ അവൻ തന്റെ ശുദ്ധീകരണദിവസത്തിൽ തല ക്ഷൗരം ചെയ്യേണം; ഏഴാം ദിവസം അവൻ ക്ഷൗരം ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","എട്ടാം ദിവസം അവൻ രണ്ടു കുറുപ്രാവിനെയോ രണ്ടു പ്രാവിൻകുഞ്ഞിനെയോ പുരോഹിതന്റെ അടുക്കൽ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","പുരോഹിതൻ ഒന്നിനെ പാപയാഗമായിട്ടും മറ്റേതിനെ ഹോമയാഗമായിട്ടും അർപ്പിച്ചു ശവത്താൽ അവൻ പിഴെച്ചതുകൊണ്ടു അവന്നു വേണ്ടി പ്രായശ്ചിത്തം കഴിച്ചു അവന്റെ തല അന്നുതന്നേ ശുദ്ധീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","അവൻ വീണ്ടും തന്റെ നാസീർ വ്രതത്തിന്റെ കാലം യഹോവെക്കു വേർതിരിച്ചു ഒരു വയസ്സു പ്രായമുള്ള ഒരു ആട്ടിൻകുട്ടിയെ അകൃത്യയാഗമായി കൊണ്ടുവരേണം അവന്റെ നാസീർവ്രതം അശുദ്ധമായിപ്പോയതുകൊണ്ടു മുമ്പിലത്തെ കാലം തള്ളിപ്പോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","വ്രതസ്ഥന്റെ പ്രമാണം ആവിതു: അവന്റെ നാസീർവ്രതത്തിന്റെ കാലം തികയുമ്പോൾ അവനെ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","അവൻ യഹോവെക്കു വഴിപാടായി ഹോമയാഗത്തിന്നു ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഒരു ആണാട്ടിൻകുട്ടി, പാപയാഗത്തിന്നു ഒരു വയസ്സു പ്രായമുള്ള ഒരു പെണ്ണാട്ടിൻകുട്ടി, സമാധാനയാഗത്തിന്നു ഊനമില്ലാത്ത ഒരു ആട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ഒരു കൊട്ടയിൽ, എണ്ണചേർത്തു നേരിയ മാവുകൊണ്ടുണ്ടാക്കിയ പുളിപ്പില്ലാത്ത ദോശ, എണ്ണപുരട്ടിയ പുളിപ്പില്ലാത്ത വട എന്നിവയും അവയുടെ ഭോജനയാഗവും പാനീയയാഗങ്ങളും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","പുരോഹിതൻ അവയെ യഹോവയുടെ സന്നിധിയിൽ കൊണ്ടുവന്നു അവന്റെ പാപയാഗവും ഹോമയാഗവും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","അവൻ ആട്ടുകൊറ്റനെ കൊട്ടയിലെ പുളിപ്പില്ലാത്ത അപ്പത്തോടുകൂടെ യഹോവെക്കു സമാധാനയാഗമായി അർപ്പിക്കേണം; പുരോഹിതൻ അതിന്റെ ഭോജനയാഗവും പാനീയയാഗവും കൂടെ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","പിന്നെ വ്രതസ്ഥൻ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽവെച്ചു തന്റെ വ്രതമുള്ള തല ക്ഷൗരം ചെയ്തു തന്റെ വ്രതമുള്ള തലമുടി എടുത്തു സമാധാനയാഗത്തിൻ കീഴുള്ള തീയിൽ ഇടേണം; ");
INSERT INTO mal2015_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","വ്രതസ്ഥൻ തന്റെ വ്രതമുള്ള തല ക്ഷൗരം ചെയ്തശേഷം പുരോഹിതൻ ആട്ടുകൊറ്റന്റെ വേവിച്ച കൈക്കുറകും കൊട്ടയിൽനിന്നു പുളിപ്പില്ലാത്ത ഒരു ദോശയും പുളിപ്പില്ലാത്ത ഒരു വടയും എടുത്തു അവയെ വ്രതസ്ഥന്റെ കൈയിൽ വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","പുരോഹിതൻ അവയെ യഹോവയുടെ സന്നിധിയിൽ നീരാജനം ചെയ്യേണം; ഇതു നീരാജനം ചെയ്ത നെഞ്ചോടും ഉദർച്ച ചെയ്ത കൈക്കുറകോടും കൂടെ പുരോഹിതന്നുവേണ്ടി വിശുദ്ധമാകുന്നു; അതിന്റെ ശേഷം വ്രതസ്ഥന്നു വീഞ്ഞു കുടിക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","നാസീർവ്രതം ദീക്ഷിക്കുന്ന വ്രതസ്ഥന്റെയും അവൻ തന്റെ പ്രാപ്തിപോലെ കൊടുക്കുന്നതു കൂടാതെ തന്റെ നാസീർവ്രതം ഹേതുവായി യഹോവെക്കു കഴിക്കേണ്ടുന്ന വഴിപാടിന്റെയും പ്രമാണം ഇതു തന്നേ. അവൻ ദീക്ഷിച്ചവ്രതംപോലെ തന്റെ നാസീർവ്രതത്തിന്റെ പ്രമാണത്തിന്നു അനുസരണയായി തന്നേ അവൻ ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","നീ അഹരോനോടും പുത്രന്മാരോടും പറയേണ്ടതു: നിങ്ങൾ യിസ്രായേൽമക്കളെ അനുഗ്രഹിച്ചു ചൊല്ലേണ്ടതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","യഹോവ നിന്നെ അനുഗ്രഹിച്ചു കാക്കുമാറാകട്ടെ; ");
INSERT INTO mal2015_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","യഹോവ തിരുമുഖം നിന്റെമേൽ പ്രകാശിപ്പിച്ചു നിന്നോടു കൃപയുള്ളവനാകട്ടെ; ");
INSERT INTO mal2015_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","യഹോവ തിരുമുഖം നിന്റെമേൽ ഉയർത്തി നിനക്കു സമാധാനം നല്കുമാറാകട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ഇങ്ങനെ അവർ യിസ്രായേൽമക്കളുടെ മേൽ എന്റെ നാമം വെക്കേണം; ഞാൻ അവരെ അനുഗ്രഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","മോശെ തിരുനിവാസം നിവിർത്തുകഴിഞ്ഞിട്ടു അതും അതിന്റെ ഉപകരണങ്ങളൊക്കെയും അഭിഷേകം ചെയ്തു ശുദ്ധീകരിക്കയും യാഗപീഠത്തെയും അതിന്റെ സകലപാത്രങ്ങളെയും അഭിഷേകം കഴിച്ചു ശുദ്ധീകരിക്കയും ചെയ്ത ദിവസം ");
INSERT INTO mal2015_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","തങ്ങളുടെ പിതൃഭവനങ്ങളിൽ പ്രധാനികളും ഗോത്രപ്രഭുക്കന്മാരും എണ്ണപ്പെട്ടവരുടെ മേൽവിചാരകന്മാരും ആയ യിസ്രായേൽപ്രഭുക്കന്മാർ വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","അവർ വഴിപാടായിട്ടു ഈരണ്ടു പ്രഭുക്കന്മാർ ഓരോ വണ്ടിയും ഓരോരുത്തൻ ഓരോ കാളയും ഇങ്ങനെ കൂടുള്ള ആറു വണ്ടിയും പന്ത്രണ്ടു കാളയും യഹോവയുടെ സന്നിധിയിൽ തിരുനിവാസത്തിന്റെ മുമ്പിൽ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","അപ്പോൾ യഹോവ മോശെയോടു: ");
INSERT INTO mal2015_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","അവരുടെ പക്കൽനിന്നു അവയെ വാങ്ങുക. അവ സമാഗമനകൂടാരത്തിന്റെ ഉപയോഗത്തിന്നു ഇരിക്കട്ടെ; അവയെ ലേവ്യരിൽ ഓരോരുത്തന്നു അവനവന്റെ വേലക്കു തക്കവണ്ണം കൊടുക്കേണം എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","മോശെ വണ്ടികളെയും കാളകളെയും വാങ്ങി ലേവ്യർക്കു കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","രണ്ടു വണ്ടിയും നാലു കാളയെയും അവൻ ഗേർശോന്യർക്കു അവരുടെ വേലെക്കു തക്കവണ്ണം കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","നാലു വണ്ടിയും എട്ടു കാളയെയും അവൻ മെരാര്യർക്കു പുരോഹിതനായ അഹരോന്റെ പുത്രൻ ഈഥാമാരിന്റെ കൈക്കീഴ് അവർക്കുള്ള വേലെക്കു തക്കവണ്ണം കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","കെഹാത്യർക്കു അവൻ ഒന്നും കൊടുത്തില്ല; അവരുടെ വേല വിശുദ്ധമന്ദിരം സംബന്ധിച്ചുള്ളതും തോളിൽ ചുമക്കുന്നതും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","യാഗപീഠം അഭിഷേകം ചെയ്ത ദിവസം പ്രഭുക്കന്മാർ പ്രതിഷ്ഠെക്കുള്ള വഴിപാടു കൊണ്ടുവന്നു; യാഗപീഠത്തിന്റെ മുമ്പാകെ പ്രഭുക്കന്മാർ തങ്ങളുടെ വഴിപാടു കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","അപ്പോൾ യഹോവ മോശെയോടു: യാഗപീഠത്തിന്റെ പ്രതിഷ്ഠെക്കായി ഓരോ പ്രഭു ഓരോ ദിവസം താന്താന്റെ വഴിപാടു കൊണ്ടുവരേണം എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ഒന്നാം ദിവസം വഴിപാടു കഴിച്ചവൻ യെഹൂദാഗോത്രത്തിൽ അമ്മീനാദാബിന്റെ മകനായ നഹശോൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - അവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കം ഉള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു ആൺകുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, ");
INSERT INTO mal2015_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു ചെമ്മരിയാട്ടിൻകുട്ടി; ഇതു അമ്മീനാദാബിന്റെ മകനായ നഹശോന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","രണ്ടാം ദിവസം യിസ്സാഖാരിന്റെ മക്കളുടെ പ്രഭുവായ സൂവാരിന്റെ മകൻ നെഥനയേൽ വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","അവൻ വഴിപാടു കഴിച്ചതു: വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കമുള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു; ഇതു സൂവാരിന്റെ മകനായ നെഥനയേലിന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","മൂന്നാം ദിവസം സെബൂലൂന്റെ മക്കളുടെ പ്രഭുവായ ഹേലോന്റെ മകൻ എലീയാബ് വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത നേരിയമാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കം ഉള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ; ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു; ഇതു ഹേലോന്റെ മകൻ എലീയാബിന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","നാലാം ദിവസം രൂബേന്റെ മക്കളുടെ പ്രഭുവായ ശെദേയൂരിന്റെ മകൻ എലീസൂർ വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റി മുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കമുള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു; ഇതു ശെദേയൂരിന്റെ മകൻ എലീസൂരിന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","അഞ്ചാം ദിവസം ശിമെയോന്റെ മക്കളുടെ പ്രഭുവായ സൂരീശദ്ദായിയുടെ മകൻ ശെലൂമീയേൽ വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കമുള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, ");
INSERT INTO mal2015_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു. ഇതു സൂരീശദ്ദായിയുടെ മകൻ ശെലൂമീയേലിന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ആറാം ദിവസം ഗാദിന്റെ മക്കളുടെ പ്രഭുവായ ദെയൂവേലിന്റെ മകൻ എലീയാസാഫ് വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കമുള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു. ഇതു ദെയൂവേലിന്റെ മകൻ എലീയാസാഫിന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ഏഴാം ദിവസം എഫ്രയീമിന്റെ മക്കളുടെ പ്രഭുവായ അമ്മീഹൂദിന്റെ മകൻ എലീശാമാ വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത നേരിയമാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കം ഉള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സുപ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു. ഇതു അമ്മീഹൂദിന്റെ മകൻ എലീശാമായുടെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","എട്ടാം ദിവസം മനശ്ശെയുടെ മക്കളുടെ പ്രഭുവായ പെദാസൂരിന്റെ മകൻ ഗമലീയേൽ വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവരണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണ ചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കമുള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു; ഇതു പെദാസൂരിന്റെ മകൻ ഗമലീയേലിന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ഒമ്പതാം ദിവസം ബെന്യാമീന്റെ മക്കളുടെ പ്രഭുവായ ഗിദെയോനിയുടെ മകൻ അബീദാൻ വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണ ചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കമുള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ഹോമയാഗത്തിന്നായി, ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു. ഇതു ഗിദെയോനിയുടെ മകൻ അബീദാന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","പത്താം ദിവസം ദാന്റെ മക്കളുടെ പ്രഭുവായ അമ്മീശദ്ദായിയുടെ മകൻ അഹീയേസെർ വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണ ചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കം ഉള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു. ഇതു അമ്മീശദ്ദായിയുടെ മകൻ അഹീയേസെരിന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","പതിനൊന്നാം ദിവസം ആശേരിന്റെ മക്കളുടെ പ്രഭുവായ ഒക്രാന്റെ മകൻ പഗീയേൽ വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവ രണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കമുള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു. ഇതു ഒക്രാന്റെ മകനായ പഗീയേലിന്റെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","പന്ത്രണ്ടാം ദിവസം നഫ്താലിയുടെ മക്കളുടെ പ്രഭുവായ ഏനാന്റെ മകൻ അഹീര വഴിപാടു കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","അവന്റെ വഴിപാടു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം നൂറ്റിമുപ്പതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിത്തളിക, എഴുപതു ശേക്കെൽ തൂക്കമുള്ള ഒരു വെള്ളിക്കിണ്ണം - ഇവരണ്ടും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത നേരിയ മാവുകൊണ്ടു നിറഞ്ഞിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ധൂപവർഗ്ഗം നിറഞ്ഞതും പത്തു ശേക്കെൽ തൂക്കമുള്ളതുമായ ഒരു പൊൻകലശം, ");
INSERT INTO mal2015_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവു, ഒരു ആട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള ഒരു കുഞ്ഞാടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റൻ, ");
INSERT INTO mal2015_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","സമാധാനയാഗത്തിന്നായി രണ്ടു കാള, അഞ്ചു ആട്ടുകൊറ്റൻ, അഞ്ചു കോലാട്ടുകൊറ്റൻ, ഒരു വയസ്സു പ്രായമുള്ള അഞ്ചു കുഞ്ഞാടു. ഇതു ഏനാന്റെ മകൻ അഹീരയുടെ വഴിപാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","യാഗപീഠം അഭിഷേകം ചെയ്ത ദിവസം യിസ്രായേൽ പ്രഭുക്കന്മാരുടെ പ്രതിഷ്ഠവഴിപാടു ഇതു ആയിരുന്നു; വെള്ളിത്തളിക പന്ത്രണ്ടു, വെള്ളിക്കിണ്ണം പന്ത്രണ്ടു, ");
INSERT INTO mal2015_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","പൊൻകലശം പന്ത്രണ്ടു, വെള്ളിത്തളിക ഒന്നിന്നു തൂക്കം നൂറ്റിമുപ്പതു ശേക്കെൽ; കിണ്ണം ഒന്നിന്നു എഴുപതു ശേക്കെൽ; ഇങ്ങനെ വെള്ളിപ്പാത്രങ്ങൾ ആകെ വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം രണ്ടായിരത്തി നാനൂറു ശേക്കെൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ധൂപവർഗ്ഗം നിറഞ്ഞ പൊൻകലശം പന്ത്രണ്ടു; ഓരോന്നു വിശുദ്ധമന്ദിരത്തിലെ തൂക്കപ്രകാരം പത്തു ശേക്കെൽ വീതം കലശങ്ങളുടെ പൊന്നു ആകെ നൂറ്റിരുപതു ശേക്കെൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ഹോമയാഗത്തിന്നുള്ള നാൽക്കാലികൾ എല്ലാംകൂടി കാളക്കിടാവു പന്ത്രണ്ടു, ആട്ടുകൊറ്റൻ പന്ത്രണ്ടു, ഒരു വയസ്സു പ്രായമുള്ള കുഞ്ഞാടു പന്ത്രണ്ടു, അവയുടെ ഭോജനയാഗം, പാപയാഗത്തിന്നായി കോലാട്ടുകൊറ്റൻ പന്ത്രണ്ടു; ");
INSERT INTO mal2015_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","സമാധാനയാഗത്തിന്നായി നാൽക്കാലികൾ എല്ലാംകൂടി കാള ഇരുപത്തിനാലു, ആട്ടുകൊറ്റൻ അറുപതു, കോലാട്ടുകൊറ്റൻ അറുപതു, ഒരു വയസ്സു പ്രായമുള്ള കുഞ്ഞാടു അറുപതു; യാഗപീഠത്തെ അഭിഷേകം ചെയ്തശേഷം അതിന്റെ പ്രതിഷ്ഠെക്കുള്ള വഴിപാടു ഇതു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","മോശെ തിരുമുമ്പിൽ സംസാരിപ്പാൻ സമാഗമനകൂടാരത്തിൽ കടക്കുമ്പോൾ അവൻ സാക്ഷ്യപെട്ടകത്തിന്മേലുള്ള കൃപാസനത്തിങ്കൽ നിന്നു രണ്ടു കെരൂബുകളുടെ നടുവിൽനിന്നു തന്നോടു സംസാരിക്കുന്ന തിരുശബ്ദം കേട്ടു; അങ്ങനെ അവൻ അവനോടു സംസാരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","ദീപം കൊളുത്തുമ്പോൾ ദീപം ഏഴും നിലവിളക്കിന്റെ മുൻവശത്തോട്ടു വെളിച്ചംകൊടുക്കേണം എന്നു അഹരോനോടു പറക. ");
INSERT INTO mal2015_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","അഹരോൻ അങ്ങനെ ചെയ്തു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ അവൻ നിലവിളക്കിന്റെ ദീപം മുൻവശത്തേക്കു തിരിച്ചുകൊളുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","നിലവിളക്കിന്റെ പണിയോ, അതു പൊന്നുകൊണ്ടു അടിച്ചുണ്ടാക്കിയതായിരുന്നു; അതിന്റെ ചുവടുമുതൽ പുഷ്പംവരെ അടിപ്പുപണി തന്നേ; യഹോവ മോശെയെ കാണിച്ച മാതൃകപോലെ തന്നേ അവൻ നിലവിളക്കു ഉണ്ടാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതെന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","ലേവ്യരെ യിസ്രായേൽമക്കളുടെ ഇടയിൽനിന്നു എടുത്തു ശുചീകരിക്ക. ");
INSERT INTO mal2015_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","അവരെ ശുചീകരിക്കേണ്ടതിന്നു ഇങ്ങനെ ചെയ്യേണം: പാപപരിഹാരജലം അവരുടെ മേൽ തളിക്കേണം; അവർ സർവ്വാംഗം ക്ഷൗരം ചെയ്തു വസ്ത്രം അലക്കി ഇങ്ങനെ തങ്ങളെത്തന്നേ ശുചീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","അതിന്റെ ശേഷം അവർ ഒരു കാളക്കിടാവിനെയും അതിന്റെ ഭോജനയാഗമായി എണ്ണചേർത്ത നേരിയ മാവും എടുക്കേണം; പാപയാഗത്തിന്നായി നീ വേറെ ഒരു കാളക്കിടാവിനെയും എടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ലേവ്യരെ സമാഗമനകൂടാരത്തിന്റെ മുമ്പാകെ വരുത്തേണം; യിസ്രായേൽമക്കളുടെ സഭയെ മുഴുവനും ഒരുമിച്ചു കൂട്ടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","പിന്നെ ലേവ്യരെ യഹോവയുടെ സന്നിധിയിൽ നിർത്തേണം; യിസ്രായേൽമക്കൾ ലേവ്യരുടെ മേൽ കൈ വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","യഹോവയുടെ വേല ചെയ്യേണ്ടതിന്നു അഹരോൻ ലേവ്യരെ യഹോവയുടെ സന്നിധിയിൽ യിസ്രായേൽമക്കളുടെ നീരാജനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ലേവ്യർ കാളക്കിടാക്കളുടെ തലയിൽ കൈ വെക്കേണം; പിന്നെ ലേവ്യർക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണ്ടതിന്നു നീ യഹോവെക്കു ഒന്നിനെ പാപയാഗമായിട്ടും മറ്റേതിനെ ഹോമയാഗമായിട്ടും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","നീ ലേവ്യരെ അഹരോന്റെയും പുത്രന്മാരുടെയും മുമ്പാകെ നിർത്തി യഹോവെക്കു നീരാജനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ഇങ്ങനെ ലേവ്യരെ യിസ്രായേൽമക്കളുടെ ഇടയിൽനിന്നു വേർതിരിക്കയും ലേവ്യർ എനിക്കുള്ളവരായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","അതിന്റെ ശേഷം സമാഗമനകൂടാരം സംബന്ധിച്ചുള്ള വേല ചെയ്യേണ്ടതിന്നു ലേവ്യർക്കു അടുത്തു ചെല്ലാം; നീ അവരെ ശുചീകരിച്ചു നീരാജനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","അവർ യിസ്രായേൽമക്കളുടെ ഇടയിൽനിന്നു എനിക്കു സാക്ഷാൽ ദാനമായുള്ളവർ; എല്ലായിസ്രായേൽമക്കളിലുമുള്ള ആദ്യജാതന്മാർക്കു പകരം ഞാൻ അവരെ എനിക്കായി എടുത്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","മനുഷ്യരിലാകട്ടെ മൃഗങ്ങളിലാകട്ടെ യിസ്രായേൽമക്കൾക്കുള്ള കടിഞ്ഞൂൽ ഒക്കെയും എനിക്കുള്ളതു; ഞാൻ മിസ്രയീംദേശത്തുള്ള കടിഞ്ഞൂലുകളെ ഒക്കെയും സംഹരിച്ച നാളിൽ അവയെ എനിക്കായി ശുദ്ധീകരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","എന്നാൽ യിസ്രായേൽമക്കളിൽ ഉള്ള എല്ലാ കടിഞ്ഞൂലുകൾക്കും പകരം ഞാൻ ലേവ്യരെ എടുത്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","യിസ്രായേൽമക്കൾ വിശുദ്ധമന്ദിരത്തിന്നു അടുത്തുവരുമ്പോൾ അവരുടെ ഇടയിൽ ബാധയുണ്ടാകാതിരിക്കേണ്ടതിന്നു സമാഗമനകൂടാരത്തിൽ യിസ്രായേൽമക്കളുടെ വേല ചെയ്‌വാനും യിസ്രായേൽമക്കൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിപ്പാനും ലേവ്യരെ ഞാൻ യിസ്രായേൽമക്കളുടെ ഇടയിൽനിന്നു അഹരോന്നും പുത്രന്മാർക്കും ദാനം ചെയ്തുമിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","അങ്ങനെ മോശെയും അഹരോനും യിസ്രായേൽമക്കളുടെ സഭ മുഴുവനും ലേവ്യരെക്കുറിച്ചു യഹോവ മോശെയോടു കല്പിച്ചതുപോലെയൊക്കെയും ലേവ്യർക്കു ചെയ്തു; അങ്ങനെ തന്നേ യിസ്രായേൽമക്കൾ അവർക്കു ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ലേവ്യർ തങ്ങൾക്കു തന്നേ പാപശുദ്ധിവരുത്തി വസ്ത്രം അലക്കി; അഹരോൻ അവരെ യഹോവയുടെ സന്നിധിയിൽ നീരാജനയാഗമായി അർപ്പിച്ചു; അവരെ ശുചീകരിക്കേണ്ടതിന്നു അഹരോൻ അവർക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","അതിന്റെ ശേഷം ലേവ്യർ അഹരോന്റെയും പുത്രന്മാരുടെയും മുമ്പാകെ സമാഗമനകൂടാരത്തിൽ തങ്ങളുടെ വേലചെയ്‌വാൻ അടുത്തുചെന്നു; യഹോവ ലേവ്യരെക്കുറിച്ചു മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ അവർ അവർക്കു ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","ലേവ്യർക്കുള്ള പ്രമാണം ആവിതു: ഇരുപത്തഞ്ചു വയസ്സുമുതൽ അവർ സമാഗമനകൂടാരത്തിലെ വേലചെയ്യുന്ന സേവയിൽ പ്രവേശിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","അമ്പതു വയസ്സുമുതലോ അവർ വേലചെയ്യുന്ന സേവയിൽനിന്നു ഒഴിയേണം; പിന്നെ സേവിക്കേണ്ടാ; ");
INSERT INTO mal2015_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","എങ്കിലും സമാഗമനകൂടാരത്തിലെ കാര്യംനോക്കുന്നതിൽ അവർ തങ്ങളുടെ സഹോദരന്മാരെ സഹായിക്കേണം; വേല ഒന്നും ചെയ്യേണ്ടാ. ലേവ്യരുടെ കാര്യം സംബന്ധിച്ചു നീ ഇങ്ങനെ അവർക്കു ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","അവർ മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെട്ടുപോന്നതിന്റെ രണ്ടാം സംവത്സരം ഒന്നാം മാസം യഹോവ സീനായിമരുഭൂമിയിൽവെച്ചു മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","യിസ്രായേൽമക്കൾ പെസഹ അതിന്നു നിശ്ചയിച്ച സമയത്തു ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","അതിന്നു നിശ്ചയിച്ച സമയമായ ഈ മാസം പതിന്നാലാം തിയ്യതി വൈകുന്നേരം അതു ആചരിക്കേണം; അതിന്റെ എല്ലാചട്ടങ്ങൾക്കും നിയമങ്ങൾക്കും അനുസരണയായി നിങ്ങൾ അതു ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","പെസഹ ആചരിക്കേണമെന്നു മോശെ യിസ്രായേൽമക്കളോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","അങ്ങനെ അവർ ഒന്നാം മാസം പതിന്നാലാം തിയ്യതി സന്ധ്യാസമയത്തു സീനായിമരുഭൂമിയിൽവെച്ചു പെസഹ ആചരിച്ചു; യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ യിസ്രായേൽമക്കൾ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","എന്നാൽ ഒരു മനുഷ്യന്റെ ശവത്താൽ അശുദ്ധരായിത്തീർന്നിട്ടു ആ നാളിൽ പെസഹ ആചരിപ്പാൻ കഴിയാത്ത ചിലർ ഉണ്ടായിരുന്നു; അവർ അന്നുതന്നേ മോശെയുടെയും അഹരോന്റെയും മുമ്പാകെ വന്നു അവനോടു: ");
INSERT INTO mal2015_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ഞങ്ങൾ ഒരുത്തന്റെ ശവത്താൽ അശുദ്ധരായിരിക്കുന്നു; നിശ്ചയിക്കപ്പെട്ട സമയത്തു യിസ്രായേൽമക്കളുടെ ഇടയിൽ യഹോവയുടെ വഴിപാടു കഴിക്കാതിരിപ്പാൻ ഞങ്ങളെ മുടക്കുന്നതു എന്തു എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","മോശെ അവരോടു: നില്പിൻ; യഹോവ നിങ്ങളെക്കുറിച്ചു കല്പിക്കുന്നതു എന്തു എന്നു ഞാൻ കേൾക്കട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","എന്നാറെ യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു. ");
INSERT INTO mal2015_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: നിങ്ങളിലോ നിങ്ങളുടെ സന്തതികളിലോ വല്ലവനും ശവത്താൽ അശുദ്ധനാകയോ ദൂരയാത്രയിൽ ആയിരിക്കയോ ചെയ്താലും അവൻ യഹോവെക്കു പെസഹ ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","രണ്ടാം മാസം പതിന്നാലാം തിയ്യതി സന്ധ്യാസമയത്തു അവർ അതു ആചരിച്ചു പുളിപ്പില്ലാത്ത അപ്പത്തോടും കൈപ്പുചീരയോടും കൂടെ അതു ഭക്ഷിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","രാവിലത്തേക്കു അതിൽ ഒന്നും ശേഷിപ്പിച്ചുവെക്കരുതു; അതിന്റെ അസ്ഥിയൊന്നും ഒടിക്കയും അരുതു; പെസഹയുടെ ചട്ടപ്രകാരമൊക്കെയും അവർ അതു ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","എന്നാൽ ശുദ്ധിയുള്ളവനും പ്രയാണത്തിൽ അല്ലാത്തവനുമായ ഒരുത്തൻ പെസഹ ആചരിക്കാതെ വീഴ്ച വരുത്തിയാൽ അവനെ അവന്റെ ജനത്തിൽനിന്നു ഛേദിച്ചുകളയേണം; നിശ്ചയിച്ച സമയത്തു യഹോവയുടെ വഴിപാടു കഴിക്കായ്കകൊണ്ടു അവൻ തന്റെ പാപം വഹിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","നിങ്ങളുടെ ഇടയിൽ വന്നുപാർക്കുന്ന ഒരു പരദേശിക്കു യഹോവയുടെ പെസഹ ആചരിക്കേണമെങ്കിൽ പെസഹയുടെ ചട്ടത്തിന്നും നിയമത്തിന്നും അനുസരണയായി അവൻ ആചരിക്കേണം; പരദേശിക്കാകട്ടെ സ്വദേശിക്കാകട്ടെ നിങ്ങൾക്കു ഒരു ചട്ടം തന്നേ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","തിരുനിവാസം നിവിർത്തുനിർത്തിയ നാളിൽ മേഘം സാക്ഷ്യകൂടാരമെന്ന തിരുനിവാസത്തെ മൂടി; സന്ധ്യാസമയംതൊട്ടു രാവിലെവരെ അതു തിരുനിവാസത്തിന്മേൽ അഗ്നിപ്രകാശംപോലെ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","അതു എല്ലായ്പോഴും അങ്ങനെതന്നേ ആയിരുന്നു; പകൽ മേഘവും രാത്രി അഗ്നിരൂപവും അതിനെ മൂടിയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","മേഘം കൂടാരത്തിന്മേൽനിന്നു പൊങ്ങുമ്പോൾ യിസ്രായേൽമക്കൾ യാത്ര പുറപ്പെടും; മേഘം നില്ക്കുന്നേടത്തു അവർ പാളയമിറങ്ങും. ");
INSERT INTO mal2015_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","യഹോവയുടെ കല്പനപോലെ യിസ്രായേൽമക്കൾ യാത്ര പുറപ്പെടുകയും യഹോവയുടെ കല്പനപോലെ പാളയമിറങ്ങുകയും ചെയ്തു; മേഘം തിരുനിവാസത്തിന്മേൽ നില്ക്കുമ്പോൾ ഒക്കെയും അവർ പാളയമടിച്ചു താമസിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","മേഘം തിരുനിവാസത്തിന്മേൽ ഏറെനാൾ ഇരുന്നു എങ്കിൽ യിസ്രായേൽമക്കൾ യാത്ര പുറപ്പെടാതെ യഹോവയുടെ ആജ്ഞ കാത്തുകൊണ്ടിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ചിലപ്പോൾ മേഘം തിരുനിവാസത്തിന്മേൽ കുറെനാൾ ഇരിക്കും; അപ്പോൾ അവർ യഹോവയുടെ കല്പനപോലെ പാളയമിറങ്ങിയിരിക്കും; പിന്നെ യഹോവയുടെ കല്പനപോലെ യാത്ര പുറപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ചിലപ്പോൾ മേഘം സന്ധ്യമുതൽ ഉഷസ്സുവരെ ഇരിക്കും; ഉഷഃകാലത്തു മേഘം പൊങ്ങി എങ്കിൽ അവർ യാത്ര പുറപ്പെടും. ചിലപ്പോൾ പകലും രാവും ഇരിക്കും; പിന്നെ മേഘം പൊങ്ങിയെങ്കിൽ അവർ യാത്ര പുറപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","രണ്ടു ദിവസമോ ഒരു മാസമോ ഒരു സംവത്സരമോ മേഘം തിരുനിവാസത്തിന്മേൽ ആവസിച്ചിരുന്നാൽ യിസ്രായേൽമക്കൾ പുറപ്പെടാതെ പാളയമടിച്ചു താമസിക്കും; അതു പൊങ്ങുമ്പോഴോ അവർ പുറപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","യഹോവയുടെ കല്പനപോലെ അവർ പാളയമിറങ്ങുകയും യഹോവയുടെ കല്പനപോലെ യാത്ര പുറപ്പെടുകയും ചെയ്യും; മോശെ മുഖാന്തരം യഹോവ കല്പിച്ചതുപോലെ അവർ യഹോവയുടെ ആജ്ഞ പ്രമാണിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","വെള്ളികൊണ്ടു രണ്ടു കാഹളം ഉണ്ടാക്കുക; അടിപ്പുപണിയായി അവയെ ഉണ്ടാക്കേണം; അവ നിനക്കു സഭയെ വിളിച്ചുകൂട്ടുവാനും പാളയത്തെ പുറപ്പെടുവിപ്പാനും ഉതകേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","അവ ഊതുമ്പോൾ സഭ മുഴുവനും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ നിന്റെ അടുക്കൽ കൂടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ഒരു കാഹളം മാത്രം ഊതിയാൽ യിസ്രായേലിന്റെ സഹസ്രാധിപന്മാരായ പ്രഭുക്കന്മാർ നിന്റെ അടുക്കൽ കൂടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ഗംഭീരധ്വനി ഊതുമ്പോൾ കിഴക്കെ പാളയങ്ങൾ യാത്ര പുറപ്പെടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","രണ്ടാം പ്രാവശ്യം ഗംഭീരധ്വനി ഊതുമ്പോൾ തെക്കെ പാളയങ്ങൾ യാത്ര പുറപ്പെടേണം; ഇങ്ങനെ ഇവരുടെ പുറപ്പാടുകൾക്കായി ഗംഭീരധ്വനി ഊതേണം: ");
INSERT INTO mal2015_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","സഭയെ കൂട്ടേണ്ടതിന്നു ഊതുമ്പോൾ ഗംഭീരധ്വനി ഊതരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","അഹരോന്റെ പുത്രന്മാരായ പുരോഹിതന്മാർ ആകുന്നു കാഹളം ഊതേണ്ടതു; ഇതു നിങ്ങൾക്കു തലമുറതലമുറയായി എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","നിങ്ങളുടെ ദേശത്തു നിങ്ങളെ ഞെരുക്കുന്ന ശത്രുവിന്റെ നേരെ നിങ്ങൾ യുദ്ധത്തിന്നു പോകുമ്പോൾ ഗംഭീരധ്വനിയായി കാഹളം ഊതേണം; എന്നാൽ നിങ്ങളുടെ ദൈവമായ യഹോവ നിങ്ങളെ ഓർത്തു ശത്രുക്കളുടെ കയ്യിൽനിന്നു രക്ഷിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","നിങ്ങളുടെ സന്തോഷദിവസങ്ങളിലും ഉത്സവങ്ങളിലും മാസാരംഭങ്ങളിലും നിങ്ങൾ ഹോമയാഗങ്ങളും സമാധാനയാഗങ്ങളും കഴിക്കുമ്പോൾ കാഹളം ഊതേണം; അവ നിങ്ങൾക്കു ദൈവത്തിന്റെ സന്നിധിയിൽ ജ്ഞാപകമായിരിക്കും; യഹോവയായ ഞാൻ നിങ്ങളുടെ ദൈവം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","അനന്തരം രണ്ടാം സംവത്സരം രണ്ടാം മാസം ഇരുപതാം തിയ്യതി മേഘം സാക്ഷ്യനിവാസത്തിന്മേൽനിന്നു പൊങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","അപ്പോൾ യിസ്രായേൽമക്കൾ സീനായിമരുഭൂമിയിൽനിന്നു യാത്രപുറപ്പെട്ടു; മേഘം പാറാൻമരുഭൂമിയിൽ വന്നുനിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","യഹോവ മോശെമുഖാന്തരം കല്പിച്ചതുപോലെ അവർ ഇങ്ങനെ ആദ്യമായി യാത്ര പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","യെഹൂദാമക്കളുടെ കൊടിക്കീഴുള്ള പാളയം ഗണംഗണമായി ആദ്യം പുറപ്പെട്ടു; അവരുടെ സേനാപതി അമ്മീനാദാബിന്റെ മകൻ നഹശോൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","യിസ്സാഖാർമക്കളുടെ ഗോത്രത്തിന്റെ സേനാപതി സൂവാരിന്റെ മകൻ നെഥനയേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","സെബൂലൂൻ മക്കളുടെ ഗോത്രത്തിന്റെ സേനാപതി ഹേലോന്റെ മകൻ എലീയാബ്. ");
INSERT INTO mal2015_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","അപ്പോൾ തിരുനിവാസം അഴിച്ചു താഴ്ത്തി; ഗേർശോന്യരും മെരാര്യരും തിരുനിവാസം ചുമന്നുകൊണ്ടു പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","പിന്നെ രൂബേന്റെ കൊടിക്കീഴുള്ള പാളയം ഗണംഗണമായി പുറപ്പെട്ടു; അവരുടെ സേനാപതി ശെദേയൂരിന്റെ മകൻ എലീസൂർ. ");
INSERT INTO mal2015_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ശിമെയോൻമക്കളുടെ ഗോത്രത്തിന്റെ സേനാപതി സൂരിശദ്ദായിയുടെ മകൻ ശെലൂമിയേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ഗാദ്മക്കളുടെ ഗോത്രത്തിന്റെ സേനാപതി ദെയൂവേലിന്റെ മകൻ എലീയാസാഫ്. ");
INSERT INTO mal2015_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","അപ്പോൾ കെഹാത്യർ വിശുദ്ധസാധനങ്ങൾ ചുമന്നുകൊണ്ടു പുറപ്പെട്ടു; ഇവർ എത്തുമ്പോഴേക്കു തിരുനിവാസം നിവിർത്തുകഴിയും. ");
INSERT INTO mal2015_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","പിന്നെ എഫ്രയീംമക്കളുടെ കൊടിക്കീഴുള്ള പാളയം ഗണംഗണമായി പുറപ്പെട്ടു; അവരുടെ സേനാപതി അമ്മീഹൂദിന്റെ മകൻ എലീശാമാ. ");
INSERT INTO mal2015_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","മനശ്ശെമക്കളുടെ ഗോത്രത്തിന്റെ സേനാപതി പെദാസൂരിന്റെ മകൻ ഗമലീയേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ബെന്യാമീൻമക്കളുടെ ഗോത്രത്തിന്റെ സേനാപതി ഗിദെയോനിയുടെ മകൻ അബീദാൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","പിന്നെ അവരുടെ എല്ലാപാളയങ്ങളിലും ഒടുവിലത്തേതായിരുന്ന ദാൻമക്കളുടെ കൊടിക്കീഴുള്ള പാളയം ഗണംഗണമായി പുറപ്പെട്ടു; അവരുടെ സേനാപതി അമ്മീശദ്ദായിയുടെ മകനായ അഹീയേസേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ആശേർമക്കളുടെ ഗോത്രത്തിന്റെ സേനാപതി ഒക്രാന്റെ മകൻ പഗീയേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","നഫ്താലിമക്കളുടെ ഗോത്രത്തിന്റെ സേനാപതി ഏനാന്റെ മകൻ അഹീര. ");
INSERT INTO mal2015_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","യിസ്രായേൽമക്കൾ യാത്ര പുറപ്പെട്ടപ്പോൾ ഗണംഗണമായുള്ള അവരുടെ യാത്ര ഇങ്ങനെ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","പിന്നെ മോശെ തന്റെ അമ്മായപ്പനായ രെയൂവേൽ എന്ന മിദ്യാനന്റെ മകനായ ഹോബാബിനോടു: നിങ്ങൾക്കു ഞാൻ തരുമെന്നു യഹോവ അരുളിച്ചെയ്ത ദേശത്തേക്കു ഞങ്ങൾ യാത്രചെയ്യുന്നു; യഹോവ യിസ്രായേലിന്നു നന്മ ചൊല്ലിയിരിക്കകൊണ്ടു നീ ഞങ്ങളോടുകൂടെ വരിക; ഞങ്ങൾ നിനക്കു നന്മ ചെയ്യും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","അവൻ അവനോടു: ഞാൻ വരുന്നില്ല; എന്റെ സ്വദേശത്തേക്കും ചാർച്ചക്കാരുടെ അടുക്കലേക്കും ഞാൻ പോകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","അതിന്നു അവൻ: ഞങ്ങളെ വിട്ടുപോകരുതേ; മരുഭൂമിയിൽ ഞങ്ങൾ പാളയമിറങ്ങേണ്ടതു എങ്ങനെ എന്നു നീ അറിയുന്നു; നീ ഞങ്ങൾക്കു കണ്ണായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ഞങ്ങളോടുകൂടെ പോന്നാൽ യഹോവ ഞങ്ങൾക്കു ചെയ്യുന്ന നന്മപോലെ തന്നേ ഞങ്ങൾ നിനക്കും ചെയ്യും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","അനന്തരം അവർ യഹോവയുടെ പർവ്വതം വിട്ടു മൂന്നു ദിവസത്തെ വഴി പോയി; യഹോവയുടെ നിയമപെട്ടകം അവർക്കു വിശ്രാമസ്ഥലം അന്വേഷിക്കേണ്ടതിന്നു മൂന്നു ദിവസത്തെ വഴി മുമ്പോട്ടു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","പാളയം പുറപ്പെട്ടപ്പോൾ യഹോവയുടെ മേഘം പകൽസമയം അവർക്കു മീതെ ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","പെട്ടകം പുറപ്പെടുമ്പോൾ മോശെ: യഹോവേ, എഴുന്നേൽക്കേണമേ; നിന്റെ ശത്രുക്കൾ ചിതറുകയും നിന്നെ പകെക്കുന്നവർ നിന്റെ മുമ്പിൽനിന്നു ഓടിപ്പോകയും ചെയ്യട്ടെ എന്നു പറയും. ");
INSERT INTO mal2015_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","അതു വിശ്രമിക്കുമ്പോൾ അവൻ: യഹോവേ, അനേകായിരമായ യിസ്രായേലിന്റെ അടുക്കൽ മടങ്ങിവരേണമേ എന്നു പറയും. ");
INSERT INTO mal2015_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","അനന്തരം ജനം യഹോവെക്കു അനിഷ്ടം തോന്നുമാറു പിറുപിറുത്തു; യഹോവ കേട്ടു അവന്റെ കോപം ജ്വലിച്ചു; യഹോവയുടെ തീ അവരുടെ ഇടയിൽ കത്തി പാളയത്തിന്റെ അറ്റങ്ങളിലുള്ളവരെ ദഹിപ്പിച്ചുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ജനം മോശെയോടു നിലവിളിച്ചു; മോശെ യഹോവയോടു പ്രാർത്ഥിച്ചു: അപ്പോൾ തീ കെട്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","യഹോവയുടെ തീ അവരുടെ ഇടയിൽ കത്തുകയാൽ ആ സ്ഥലത്തിന്നു തബേരാ എന്നു പേരായി. ");
INSERT INTO mal2015_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","പിന്നെ അവരുടെ ഇടയിലുള്ള സമ്മിശ്രജാതി ദുരാഗ്രഹികളായി, യിസ്രായേൽമക്കളും വീണ്ടും കരഞ്ഞുകൊണ്ടു: ഞങ്ങൾക്കു തിന്മാൻ ഇറച്ചി ആർ തരും? ");
INSERT INTO mal2015_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ഞങ്ങൾ മിസ്രയീമിൽവെച്ചു വിലകൂടാതെ തിന്നിട്ടുള്ള മത്സ്യം, വെള്ളരിക്കാ, മത്തങ്ങാ, ഉള്ളി, ചുവന്നുള്ളി, ചിറ്റുള്ളി എന്നിവ ഞങ്ങൾ ഓർക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ഇപ്പോഴോ ഞങ്ങളുടെ പ്രാണൻ പൊരിഞ്ഞിരിക്കുന്നു; ഈ മന്നാ അല്ലാതെ ഒന്നും കാണ്മാനില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","മന്നയോ കൊത്തമ്പാലരിപോലെയും അതിന്റെ നിറം ഗുല്ഗുലുവിന്റേതുപോലെയും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ജനം നടന്നു പെറുക്കി തിരികല്ലിൽ പൊടിച്ചിട്ടോ ഉരലിൽ ഇടിച്ചിട്ടോ കലത്തിൽ പുഴുങ്ങി അപ്പം ഉണ്ടാക്കും. അതിന്റെ രുചി എണ്ണചേർത്തുണ്ടാക്കിയ ദോശപോലെ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","രാത്രി പാളയത്തിൽ മഞ്ഞു പൊഴിയുമ്പോൾ മന്നയും പൊഴിയും. ");
INSERT INTO mal2015_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ജനം കുടുംബംകുടുംബമായി ഓരോരുത്തൻ താന്താന്റെ കൂടാരവാതിൽക്കൽവെച്ചു കരയുന്നതു മോശെ കേട്ടു; യഹോവയുടെ കോപം ഏറ്റവും ജ്വലിച്ചു; മോശെക്കും അനിഷ്ടമായി. ");
INSERT INTO mal2015_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","അപ്പോൾ മോശെ യഹോവയോടു പറഞ്ഞതു: നീ അടിയനെ വലെച്ചതു എന്തു? നിനക്കു എന്നോടു കൃപ തോന്നാതെ ഈ സർവ്വജനത്തിന്റെയും ഭാരം എന്റെമേൽ വെച്ചതെന്തു? ");
INSERT INTO mal2015_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","മുലകുടിക്കുന്ന കുഞ്ഞിനെ ഒരു ധാത്രി എടുക്കുന്നതുപോലെ ഞാൻ അവരെ നീ അവരുടെ പിതാക്കന്മാരോടു സത്യം ചെയ്ത ദേശത്തേക്കു എന്റെ മാറത്തെടുത്തുകൊണ്ടു പോകേണമെന്നു എന്നോടു കല്പിപ്പാൻ ഈ ജനത്തെ ഒക്കെയും ഞാൻ ഗർഭംധരിച്ചുവോ? ഞാൻ അവരെ പ്രസവിച്ചുവോ? ");
INSERT INTO mal2015_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ഈ ജനത്തിന്നു ഒക്കെയും കൊടുപ്പാൻ എനിക്കു എവിടെനിന്നു ഇറച്ചി കിട്ടും? അവർ ഇതാ: ഞങ്ങൾക്കു തിന്മാൻ ഇറച്ചി തരിക എന്നു എന്നോടു പറഞ്ഞു കരയുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ഏകനായി ഈ സർവ്വജനത്തെയും വഹിപ്പാൻ എന്നെക്കൊണ്ടു കഴിയുന്നതല്ല; അതു എനിക്കു അതിഭാരം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ഇങ്ങനെ എന്നോടു ചെയ്യുന്ന പക്ഷം ദയവിചാരിച്ചു എന്നെ കൊന്നുകളയേണമേ. എന്റെ അരിഷ്ടത ഞാൻ കാണരുതേ. ");
INSERT INTO mal2015_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","അപ്പോൾ യഹോവ മോശെയോടു കല്പിച്ചതു: യിസ്രായേൽമൂപ്പന്മാരിൽവെച്ചു ജനത്തിന്നു പ്രമാണികളും മേൽവിചാരകന്മാരും എന്നു നീ അറിയുന്ന എഴുപതു പുരുഷന്മാരെ സമാഗമനകൂടാരത്തിന്നരികെ നിന്നോടുകൂടെ നിൽക്കേണ്ടതിന്നു എന്റെ അടുക്കൽ കൂട്ടിക്കൊണ്ടു വരിക. ");
INSERT INTO mal2015_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","അവിടെ ഞാൻ ഇറങ്ങിവന്നു നിന്നോടു അരുളിച്ചെയ്യും; ഞാൻ നിന്റെമേലുള്ള ആത്മാവിൽ കുറെ എടുത്തു അവരുടെ മേൽ പകരും. നീ ഏകനായി വഹിക്കാതിരിക്കേണ്ടതിന്നു അവർ നിന്നോടുകൂടെ ജനത്തിന്റെ ഭാരം വഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","എന്നാൽ ജനത്തോടു നീ പറയേണ്ടതു: നാളത്തേക്കു നിങ്ങളെത്തന്നേ ശുദ്ധീകരിപ്പിൻ; എന്നാൽ നിങ്ങൾ ഇറച്ചി തിന്നും; ഞങ്ങൾക്കു തിന്മാൻ ഇറച്ചി ആർ തരും? മിസ്രയീമിൽ ഞങ്ങൾക്കു നന്നായിരുന്നു എന്നു നിങ്ങൾ പറഞ്ഞു യഹോവ കേൾക്കെ കരഞ്ഞുവല്ലോ; ആകയാൽ യഹോവ നിങ്ങൾക്കു ഇറച്ചി തരികയും നിങ്ങൾ തിന്നുകയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ഒരു ദിവസമല്ല, രണ്ടു ദിവസമല്ല, അഞ്ചു ദിവസമല്ല, പത്തു ദിവസമല്ല, ഇരുപതു ദിവസവുമല്ല, ഒരു മാസം മുഴുവനും തന്നേ; ");
INSERT INTO mal2015_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","അതു നിങ്ങളുടെ മൂക്കിൽകൂടി പുറപ്പെട്ടു നിങ്ങൾക്കു ഓക്കാനം വരുവോളം നിങ്ങൾ തിന്നും; നിങ്ങളുടെ ഇടയിൽ ഉള്ള യഹോവയെ നിങ്ങൾ നിരസിക്കയും: ഞങ്ങൾ മിസ്രയീമിൽനിന്നു എന്തിന്നു പുറപ്പെട്ടുപോന്നു എന്നു പറഞ്ഞു അവന്റെ മുമ്പാകെ കരകയും ചെയ്തിരിക്കുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","അപ്പോൾ മോശെ: എന്നോടുകൂടെയുള്ള ജനം ആറുലക്ഷം കാലാൾ ഉണ്ടു; ഒരു മാസം മുഴുവൻ തിന്മാൻ ഞാൻ അവർക്കു ഇറച്ചി കൊടുക്കുമെന്നു നീ അരുളിച്ചെയ്യുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","അവർക്കു മതിയാകുംവണ്ണം ആടുകളെയും മാടുകളെയും അവർക്കുവേണ്ടി അറുക്കുമോ? അവർക്കു മതിയാകുംവണ്ണം സമുദ്രത്തിലെ മത്സ്യത്തെ ഒക്കെയും അവർക്കുവേണ്ടി പിടിച്ചുകൂട്ടുമോ എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","യഹോവ മോശെയോടു: യഹോവയുടെ കൈ കുറുതായിപ്പോയോ? എന്റെ വചനം നിവൃത്തിയാകുമോ ഇല്ലയോ എന്നു നീ ഇപ്പോൾ കാണും എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","അങ്ങനെ മോശെ ചെന്നു യഹോവയുടെ വചനങ്ങളെ ജനത്തോടു പറഞ്ഞു, ജനത്തിന്റെ മൂപ്പന്മാരിൽ എഴുപതു പുരുഷന്മാരെ കൂട്ടി കൂടാരത്തിന്റെ ചുറ്റിലും നിറുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","എന്നാറെ യഹോവ ഒരു മേഘത്തിൽ ഇറങ്ങി അവനോടു അരുളിച്ചെയ്തു, അവന്മേലുള്ള ആത്മാവിൽ കുറെ എടുത്തു മൂപ്പന്മാരായ ആ എഴുപതു പുരുഷന്മാർക്കു കൊടുത്തു; ആത്മാവു അവരുടെ മേൽ ആവസിച്ചപ്പോൾ അവർ പ്രവചിച്ചു; പിന്നെ അങ്ങനെ ചെയ്തില്ല താനും. ");
INSERT INTO mal2015_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","എന്നാൽ ആ പുരുഷന്മാരിൽ രണ്ടുപേർ പാളയത്തിൽ തന്നേ താമസിച്ചിരുന്നു; ഒരുത്തന്നു എൽദാദ് എന്നും മറ്റവന്നു മേദാദ് എന്നും പേർ. ആത്മാവു അവരുടെമേലും ആവസിച്ചു; അവരും പേരെഴുതിയവരിൽ ഉള്ളവർ ആയിരുന്നു എങ്കിലും കൂടാരത്തിലേക്കു ചെന്നിരുന്നില്ല; അവർ പാളയത്തിൽവെച്ചു പ്രവചിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","അപ്പോൾ ഒരു ബാല്യക്കാരൻ മോശെയുടെ അടുക്കൽ ഓടിച്ചെന്നു: എൽദാദും മേദാദും പാളയത്തിൽവെച്ചു പ്രവചിക്കുന്നു എന്നു അറിയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","എന്നാറെ നൂന്റെ മകനായി ബാല്യംമുതൽ മോശെയുടെ ശുശ്രൂഷക്കാരനായിരുന്ന യോശുവ: എന്റെ യജമാനനായ മോശെയേ, അവരെ വിരോധിക്കേണമേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","മോശെ അവനോടു: എന്നെ വിചാരിച്ചു നീ അസൂയപ്പെടുന്നുവോ? യഹോവയുടെ ജനം ഒക്കെയും പ്രവാചകന്മാരാകയും യഹോവ തന്റെ ആത്മാവിനെ അവരുടെമേൽ പകരുകയും ചെയ്തെങ്കിൽ കൊള്ളായിരുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","പിന്നെ മോശെയും യിസ്രായേൽമൂപ്പന്മാരും പാളയത്തിൽ വന്നുചേർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","അനന്തരം യഹോവ അയച്ച ഒരു കാറ്റു ഊതി കടലിൽനിന്നു കാടയെ കൊണ്ടുവന്നു പാളയത്തിന്റെ സമീപത്തു ഒരു ദിവസത്തെ വഴി ഇങ്ങോട്ടും ഒരു ദിവസത്തെ വഴി അങ്ങോട്ടും ഇങ്ങനെ പാളയത്തിന്റെ ചുറ്റിലും നിലത്തോടു ഏകദേശം രണ്ടു മുഴം അടുത്തു പറന്നുനില്ക്കുമാറാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ജനം എഴുന്നേറ്റു അന്നു പകൽ മുഴുവനും രാത്രി മുഴുവനും പിറ്റെന്നാൾ മുഴുവനും കാടയെ പിടിച്ചുകൂട്ടി; നന്നാ കുറെച്ചു പിടിച്ചവൻ പത്തു പറ പിടിച്ചുകൂട്ടി; അവർ അവയെ പാളയത്തിന്റെ ചുറ്റിലും ചിക്കി. ");
INSERT INTO mal2015_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","എന്നാൽ ഇറച്ചി അവരുടെ പല്ലിന്നിടയിൽ ഇരിക്കുമ്പോൾ അതു ചവെച്ചിറക്കും മുമ്പെ തന്നേ യഹോവയുടെ കോപം ജനത്തിന്റെ നേരെ ജ്വലിച്ചു, യഹോവ ജനത്തെ ഒരു മഹാബാധകൊണ്ടു സംഹരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ദുരാഗ്രഹികളുടെ കൂട്ടത്തെ അവിടെ കുഴിച്ചിട്ടതുകൊണ്ടു ആ സ്ഥലത്തിന്നു കിബ്രോത്ത്-ഹത്താവ എന്നു പേരായി. ");
INSERT INTO mal2015_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","കിബ്രോത്ത്-ഹത്താവ വിട്ടു ജനം ഹസേരോത്തിലേക്കു പുറപ്പെട്ടുചെന്നു ഹസേരോത്തിൽ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","മോശെ ഒരു കൂശ്യസ്ത്രീയെ വിവാഹം ചെയ്തിരുന്നതുകൊണ്ടു കൂശ്യസ്ത്രീനിമിത്തം മിര്യാമും അഹരോനും അവന്നു വിരോധമായി സംസാരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","യഹോവ മോശെമുഖാന്തരം മാത്രമേ അരുളിച്ചെയ്തിട്ടുള്ളുവോ? ഞങ്ങൾമുഖാന്തരവും അരുളിച്ചെയ്തിട്ടില്ലയോ എന്നു പറഞ്ഞു; യഹോവ അതു കേട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","മോശെ എന്ന പുരുഷനോ ഭൂതലത്തിൽ ഉള്ള സകലമനുഷ്യരിലും അതിസൗമ്യനായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","പെട്ടെന്നു യഹോവ മോശെയോടും അഹരോനോടും മിര്യാമിനോടും: നിങ്ങൾ മൂവരും സമാഗമനകൂടാരത്തിങ്കൽ വരുവിൻ എന്നു കല്പിച്ചു; അവർ മൂവരും ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","യഹോവ മേഘസ്തംഭത്തിൽ ഇറങ്ങി കൂടാരവാതിൽക്കൽ നിന്നു അഹരോനെയും മിര്യാമിനെയും വിളിച്ചു; അവർ ഇരുവരും അങ്ങോട്ടു ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","പിന്നെ അവൻ അരുളിച്ചെയ്തതു: എന്റെ വചനങ്ങളെ കേൾപ്പിൻ; നിങ്ങളുടെ ഇടയിൽ ഒരു പ്രവാചകൻ ഉണ്ടെങ്കിൽ യഹോവയായ ഞാൻ അവന്നു ദർശനത്തിൽ എന്നെ വെളിപ്പെടുത്തുകയും സ്വപ്നത്തിൽ അവനോടു അരുളിച്ചെയ്കയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","എന്റെ ദാസനായ മോശെയോ അങ്ങനെയല്ല; അവൻ എന്റെ ഗൃഹത്തിൽ ഒക്കെയും വിശ്വസ്തൻ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","അവനോടു ഞാൻ അരുളിച്ചെയ്യുന്നതു മറപൊരുളായിട്ടല്ല അഭിമുഖമായിട്ടും സ്പഷ്ടമായിട്ടും അത്രേ; അവൻ യഹോവയുടെ രൂപം കാണുകയും ചെയ്യും. അങ്ങനെയിരിക്കെ നിങ്ങൾ എന്റെ ദാസനായ മോശെക്കു വിരോധമായി സംസാരിപ്പാൻ ശങ്കിക്കാഞ്ഞതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","യഹോവയുടെ കോപം അവരുടെ നേരെ ജ്വലിച്ചു അവൻ മറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","മേഘവും കൂടാരത്തിന്മേൽനിന്നു നീങ്ങിപ്പോയി. മിര്യാം ഹിമംപോലെ വെളുത്തു കുഷ്ഠരോഗിണിയായി; അഹരോൻ മിര്യാമിനെ നോക്കിയപ്പോൾ അവൾ കുഷ്ഠരോഗിണി എന്നു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","അഹരോൻ മോശെയോടു: അയ്യോ യജമാനനേ, ഞങ്ങൾ ഭോഷത്വമായി ചെയ്തുപോയ ഈ പാപം ഞങ്ങളുടെമേൽ വെക്കരുതേ. ");
INSERT INTO mal2015_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","അമ്മയുടെ ഗർഭത്തിൽനിന്നു പുറപ്പെടുമ്പോൾ മാംസം പകുതി അഴുകിയിരിക്കുന്ന ചാപിള്ളയെപ്പോലെ ഇവൾ ആകരുതേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","അപ്പോൾ മോശെ യഹോവയോടു: ദൈവമേ, അവളെ സൗഖ്യമാക്കേണമേ എന്നു നിലവിളിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","യഹോവ മോശെയോടു: അവളുടെ അപ്പൻ അവളുടെ മുഖത്തു തുപ്പിയെങ്കിൽ അവൾ ഏഴുദിവസം ലജ്ജിച്ചിരിക്കയില്ലയോ? അവളെ ഏഴു ദിവസത്തേക്കു പാളയത്തിന്നു പുറത്തു അടെച്ചിടേണം; പിന്നത്തേതിൽ അവളെ ചേർത്തുകൊള്ളാം എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ഇങ്ങനെ മിര്യാമിനെ ഏഴു ദിവസം പാളയത്തിന്നു പുറത്തു ആക്കി അടെച്ചിട്ടു; അവളെ വീണ്ടും അംഗീകരിച്ചതുവരെ ജനം യാത്ര ചെയ്യാതിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","അതിന്റെ ശേഷം ജനം ഹസേരോത്തിൽനിന്നു പുറപ്പെട്ടു പാരാൻമരുഭൂമിയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","യിസ്രായേൽമക്കൾക്കു ഞാൻ കൊടുപ്പാനിരിക്കുന്ന കനാൻദേശം ഒറ്റുനോക്കേണ്ടതിന്നു ആളുകളെ അയക്ക; അതതു ഗോത്രത്തിൽനിന്നു ഓരോ ആളെ അയക്കേണം; അവരെല്ലാവരും പ്രഭുക്കന്മാരായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","അങ്ങനെ മോശെ യഹോവയുടെ കല്പനപ്രകാരം പാരാൻമരുഭൂമിയിൽനിന്നു അവരെ അയച്ചു; ആ പുരുഷന്മാർ ഒക്കെയും യിസ്രായേൽമക്കളിൽ തലവന്മാർ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","അവരുടെ പേർ ആവിതു: രൂബേൻ ഗോത്രത്തിൽ സക്കൂറിന്റെ മകൻ ശമ്മൂവ. ");
INSERT INTO mal2015_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ശിമേയോൻ ഗോത്രത്തിൽ ഹോരിയുടെ മകൻ ശഫാത്ത്. ");
INSERT INTO mal2015_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","യെഹൂദാഗോത്രത്തിൽ യെഫുന്നയുടെ മകൻ കാലേബ്. ");
INSERT INTO mal2015_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","യിസ്സാഖാർഗോത്രത്തിൽ യോസേഫിന്റെ മകൻ ഈഗാൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","എഫ്രയീംഗോത്രത്തിൽ നൂന്റെ മകൻ ഹോശേയ. ");
INSERT INTO mal2015_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ബെന്യാമീൻഗോത്രത്തിൽ രാഫൂവിന്റെ മകൻ പൽതി. ");
INSERT INTO mal2015_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","സെബൂലൂൻഗോത്രത്തിൽ സോദിയുടെ മകൻ ഗദ്ദീയേൽ ");
INSERT INTO mal2015_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","യോസേഫിന്റെ ഗോത്രമായ മനശ്ശെഗോത്രത്തിൽ സൂസിയുടെ മകൻ ഗദ്ദി. ");
INSERT INTO mal2015_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ദാൻഗോത്രത്തിൽ ഗെമല്ലിയുടെ മകൻ അമ്മീയേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ആശേർഗോത്രത്തിൽ മിഖായേലിന്റെ മകൻ സെഥൂർ. ");
INSERT INTO mal2015_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","നഫ്താലിഗോത്രത്തിൽ വൊപ്സിയുടെ മകൻ നഹ്ബി. ");
INSERT INTO mal2015_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ഗാദ്ഗോത്രത്തിൽ മാഖിയുടെ മകൻ ഗയൂവേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ദേശം ഒറ്റുനോക്കുവാൻ മോശെ അയച്ച പുരുഷന്മാരുടെ പേർ ഇവ തന്നേ. എന്നാൽ മോശെ നൂന്റെ മകനായ ഹോശേയെക്കു യോശുവ എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","മോശെ കനാൻദേശം ഒറ്റുനോക്കുവാൻ അവരെ അയച്ചു അവരോടു: നിങ്ങൾ ഈ വഴി തെക്കെ ദേശത്തു ചെന്നു മലയിൽ കയറി: ");
INSERT INTO mal2015_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ദേശം ഏതുവിധമുള്ളതു, അതിൽ കുടിയിരിക്കുന്ന ജനം ബലവാന്മാരോ ബലഹീനരോ, ചുരുക്കമോ അധികമോ; ");
INSERT INTO mal2015_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","അവർ പാർക്കുന്ന ദേശം നല്ലതോ ആകാത്തതോ, അവർ വസിക്കുന്ന പട്ടണങ്ങൾ പാളയങ്ങളോ കോട്ടകളോ, ");
INSERT INTO mal2015_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ദേശം പുഷ്ടിയുള്ളതോ പുഷ്ടിയില്ലാത്തതോ, അതിൽ വൃക്ഷം ഉണ്ടോ ഇല്ലയോ എന്നിങ്ങനെ നോക്കിയറിവിൻ; നിങ്ങൾ ധൈര്യപ്പെട്ടു ദേശത്തിലെ ഫലങ്ങളും കൊണ്ടുവരുവിൻ എന്നു പറഞ്ഞു. അതു മുന്തിരിങ്ങ പഴുത്തു തുടങ്ങുന്ന കാലം ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","അങ്ങനെ അവർ കയറിപ്പോയി, സീൻമരുഭൂമിമുതൽ ഹാമാത്തിന്നുപോകുന്ന വഴിയായി രഹോബ് വരെ ദേശത്തെ ശോധനചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","അവർ തെക്കെദേശത്തുകൂടി ചെന്നു ഹെബ്രോനിൽ എത്തി; അവിടെ അനാക്കിന്റെ പുത്രന്മാരായ അഹീമാനും ശേശായിയും തൽമായിയും ഉണ്ടായിരുന്നു; ഹെബ്രോൻ മിസ്രയീമിലെ സോവാരിന്നു ഏഴു സംവത്സരം മുമ്പെ പണിതതായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","അവർ എസ്കോൽതാഴ്‌വരയോളം ചെന്നു അവിടെനിന്നു ഒരു മുന്തിരിവള്ളി കുലയോടെ പറിച്ചെടുത്തു ഒരു തണ്ടിന്മേൽ കെട്ടി രണ്ടുപേർകൂടി ചുമന്നു; അവർ മാതളപ്പഴവും അത്തിപ്പഴവും കൂടെ കൊണ്ടുപോന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","യിസ്രായേൽമക്കൾ അവിടെനിന്നു മുറിച്ചെടുത്ത മുന്തിരിക്കുലനിമിത്തം ആ സ്ഥലത്തിന്നു എസ്കോൽതാഴ്‌വര എന്നു പേരായി. ");
INSERT INTO mal2015_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","അവർ നാല്പതു ദിവസംകൊണ്ടു ദേശം ഒറ്റുനോക്കിക്കഴിഞ്ഞു മടങ്ങിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","അവർ യാത്രചെയ്തു പാറാൻമരുഭൂമിയിലെ കാദേശിൽ മോശെയുടെയും അഹരോന്റെയും യിസ്രായേൽമക്കളുടെ സർവ്വസഭയുടെയും അടുക്കൽ വന്നു അവരോടും സർവ്വസഭയോടും വർത്തമാനം അറിയിച്ചു; ദേശത്തിലെ ഫലങ്ങളും അവരെ കാണിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","അവർ അവനോടു വിവരിച്ചു പറഞ്ഞതെന്തെന്നാൽ: നീ ഞങ്ങളെ അയച്ച ദേശത്തേക്കു ഞങ്ങൾ പോയി; അതു പാലും തേനും ഒഴുകുന്ന ദേശം തന്നേ; അതിലെ ഫലങ്ങൾ ഇതാ. ");
INSERT INTO mal2015_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","എങ്കിലും ദേശത്തു പാർക്കുന്ന ജനങ്ങൾ ബലവാന്മാരും പട്ടണങ്ങൾ ഏറ്റവും ഉറപ്പും വലിപ്പവും ഉള്ളവയും ആകുന്നു. ഞങ്ങൾ അനാക്കിന്റെ പുത്രന്മാരെയും അവിടെ കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","അമാലേക്യർ തെക്കെ ദേശത്തു പാർക്കുന്നു; ഹിത്യരും യെബൂസ്യരും അമോര്യരും പർവ്വതങ്ങളിൽ പാർക്കുന്നു; കനാന്യർ കടൽക്കരയിലും യോർദ്ദാൻനദീതീരത്തും പാർക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","എന്നാൽ കാലേബ് മോശെയുടെ മുമ്പാകെ ജനത്തെ അമർത്തി: നാം ചെന്നു അതു കൈവശമാക്കുക; അതു ജയിപ്പാൻ നമുക്കു കഴിയും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","എങ്കിലും അവനോടുകൂടെ പോയിരുന്ന പുരുഷന്മാർ: ആ ജനത്തിന്റെ നേരെ ചെല്ലുവാൻ നമുക്കു കഴികയില്ല; അവർ നമ്മിലും ബലവാന്മാർ ആകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","തങ്ങൾ ഒറ്റുനോക്കിയ ദേശത്തെക്കുറിച്ചു അവർ യിസ്രായേൽമക്കളോടു ദുർവ്വർത്തമാനമായി പറഞ്ഞതെന്തെന്നാൽ: ഞങ്ങൾ സഞ്ചരിച്ചു ഒറ്റുനോക്കിയ ദേശം നിവാസികളെ തിന്നുകളയുന്ന ദേശം ആകുന്നു; ഞങ്ങൾ അവിടെ കണ്ട ജനം ഒക്കെയും അതികായന്മാർ; ");
INSERT INTO mal2015_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","അവിടെ ഞങ്ങൾ മല്ലന്മാരുടെ സന്തികളായ അനാക്യമല്ലന്മാരെയും കണ്ടു; ഞങ്ങൾക്കു തന്നേ ഞങ്ങൾ വെട്ടുക്കിളികളെപ്പോലെ തോന്നി; അവരുടെ കാഴ്ചെക്കും ഞങ്ങൾ അങ്ങനെതന്നേ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","അപ്പോൾ സഭയൊക്കെയും ഉറക്കെ നിലവിളിച്ചു, ജനം ആ രാത്രി മുഴുവനും കരഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","യിസ്രായേൽമക്കൾ എല്ലാവരും മോശെക്കും അഹരോന്നും വിരോധമായി പിറുപിറുത്തു; സഭ ഒക്കെയും അവരോടു: മിസ്രയീംദേശത്തുവെച്ചു ഞങ്ങൾ മരിച്ചുപോയിരുന്നു എങ്കിൽ കൊള്ളായിരുന്നു. അല്ലെങ്കിൽ ഈ മരുഭൂമിയിൽവെച്ചു ഞങ്ങൾ മരിച്ചുപോയിരുന്നു എങ്കിൽ കൊള്ളായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","വാളാൽ വീഴേണ്ടതിന്നു യഹോവ ഞങ്ങളെ ആ ദേശത്തിലേക്കു കൊണ്ടുപോകുന്നതു എന്തിന്നു? ഞങ്ങളുടെ ഭാര്യമാരും മക്കളും കൊള്ളയായ്പോകുമല്ലോ; മിസ്രയീമിലേക്കു മടങ്ങിപ്പോകയല്ലയോ ഞങ്ങൾക്കു നല്ലതു? എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","നാം ഒരു തലവനെ നിശ്ചയിച്ചു മിസ്രയീമിലേക്കു മടങ്ങിപ്പോക എന്നും അവർ തമ്മിൽതമ്മിൽ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","അപ്പോൾ മോശെയും അഹരോനും യിസ്രായേൽസഭയുടെ സർവ്വസംഘത്തിന്റെയും മുമ്പാകെ കവിണ്ണുവീണു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ദേശത്തെ ഒറ്റുനോക്കിയവരിൽ നൂന്റെ മകൻ യോശുവയും യെഫുന്നയുടെ മകൻ കാലേബും വസ്ത്രം കീറി, ");
INSERT INTO mal2015_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","യിസ്രായേൽമക്കളുടെ സർവ്വസഭയോടും പറഞ്ഞതു എന്തെന്നാൽ: ഞങ്ങൾ സഞ്ചരിച്ചു ഒറ്റു നോക്കിയ ദേശം എത്രയും നല്ലദേശം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","യഹോവ നമ്മിൽ പ്രസാദിക്കുന്നു എങ്കിൽ അവൻ നമ്മെ പാലും തേനും ഒഴുകുന്ന ആ ദേശത്തേക്കു കൊണ്ടുചെന്നു നമുക്കു അതു തരും. ");
INSERT INTO mal2015_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","യഹോവയോടു നിങ്ങൾ മത്സരിക്കമാത്രം അരുതു; ആ ദേശത്തിലെ ജനത്തെ ഭയപ്പെടരുതു; അവർ നമുക്കു ഇരയാകുന്നു; അവരുടെ ശരണം പോയ്പോയിരിക്കുന്നു; നമ്മോടുകൂടെ യഹോവ ഉള്ളതുകൊണ്ടു അവരെ ഭയപ്പെടരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","എന്നാറെ അവരെ കല്ലെറിയേണം എന്നു സഭയെല്ലാം പറഞ്ഞു. അപ്പോൾ യഹോവയുടെ തേജസ്സു സമാഗമനകൂടാരത്തിൽ എല്ലായിസ്രായേൽമക്കളും കാൺകെ പ്രത്യക്ഷമായി. ");
INSERT INTO mal2015_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","യഹോവ മോശെയോടു: ഈ ജനം എത്രത്തോളം എന്നെ നിരസിക്കും? ഞാൻ അവരുടെ മദ്ധ്യേ ചെയ്തിട്ടുള്ള അടയാളങ്ങളൊക്കെയും കണ്ടിട്ടും അവർ എത്രത്തോളം എന്നെ വിശ്വസിക്കാതിരിക്കും? ");
INSERT INTO mal2015_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ഞാൻ അവരെ മഹാമാരിയാൽ ദണ്ഡിപ്പിച്ചു സംഹരിച്ചുകളകയും നിന്നെ അവരെക്കാൾ വലിപ്പവും ബലവുമുള്ള ജാതിയാക്കുകയും ചെയ്യും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","മോശെ യഹോവയോടു പറഞ്ഞതു: എന്നാൽ മിസ്രയീമ്യർ അതു കേൾക്കും; നീ ഈ ജനത്തെ അവരുടെ ഇടയിൽനിന്നു നിന്റെ ശക്തിയാൽ കൊണ്ടുപോന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","അവർ അതു ഈ ദേശനിവാസികളോടും പറയും; യഹോവയായ നീ ഈ ജനത്തിന്റെ മദ്ധ്യേ ഉണ്ടെന്നു അവർ കേട്ടിരിക്കുന്നു; യഹോവയായ നിന്നെ ഇവർ കണ്ണാലേ കാണുകയും നിന്റെ മേഘം ഇവർക്കു മീതെ നില്ക്കുകയും പകൽ മേഘസ്തംഭത്തിലും രാത്രി അഗ്നിസ്തംഭത്തിലും നീ ഇവർക്കു മുമ്പായി നടക്കുകയും ചെയ്യുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","നീ ഇപ്പോൾ ഈ ജനത്തെ ഒക്കെയും ഒരു ഒറ്റമനുഷ്യനെപ്പോലെ കൊന്നുകളഞ്ഞാൽ നിന്റെ കീർത്തി കേട്ടിരിക്കുന്ന ജാതികൾ: ");
INSERT INTO mal2015_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","ഈ ജനത്തോടു സത്യം ചെയ്ത ദേശത്തേക്കു അവരെ കൊണ്ടു പോകുവാൻ യഹോവെക്കു കഴിയായ്കകൊണ്ടു അവൻ അവരെ മരുഭൂമിയിൽവെച്ചു കൊന്നുകളഞ്ഞു എന്നു പറയും. ");
INSERT INTO mal2015_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","യഹോവ ദീർഘക്ഷമയും മഹാദയയും ഉള്ളവൻ; അകൃത്യവും ലംഘനവും ക്ഷമിക്കുന്നവൻ; കുറ്റക്കാരനെ വെറുതെ വിടാതെ പിതാക്കന്മാരുടെ അകൃത്യം മൂന്നാമത്തെയും നാലാമത്തെയും തലമുറയോളം മക്കളുടെ മേൽ സന്ദർശിക്കുന്നവൻ ");
INSERT INTO mal2015_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","എന്നിങ്ങനെ നീ അരുളിച്ചെയ്തതുപോലെ കർത്താവേ, ഇപ്പോൾ നിന്റെ ശക്തി വലുതായിരിക്കേണമേ. ");
INSERT INTO mal2015_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","നിന്റെ മഹാദയെക്കു തക്കവണ്ണം മിസ്രയീംമുതൽ ഇവിടംവരെ ഈ ജനത്തോടു നീ ക്ഷമിച്ചുവന്നതുപോലെ ഈ ജനത്തിന്റെ അകൃത്യം ക്ഷമിക്കേണമേ. ");
INSERT INTO mal2015_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","അതിന്നു യഹോവ അരുളിച്ചെയ്തതു: നിന്റെ അപേക്ഷപ്രകാരം ഞാൻ ക്ഷമിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","എങ്കിലും എന്നാണ, ഭൂമിയെല്ലാം യഹോവയുടെ തേജസ്സുകൊണ്ടു നിറഞ്ഞിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","എന്റെ തേജസ്സും മിസ്രയീമിലും മരുഭൂമിയിലുംവെച്ചു ഞാൻ ചെയ്ത അടയാളങ്ങളും കണ്ടിട്ടുള്ള പുരുഷന്മാർ എല്ലാവരും ഇപ്പോൾ പത്തു പ്രാവശ്യം എന്നെ പരീക്ഷിക്കയും എന്റെ വാക്കു കൂട്ടാക്കാതിരിക്കയും ചെയ്തതുകൊണ്ടു ");
INSERT INTO mal2015_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","അവരുടെ പിതാക്കന്മാരോടു ഞാൻ സത്യം ചെയ്തിട്ടുള്ള ദേശം അവർ കാൺകയില്ല; എന്നെ നിരസിച്ചവർ ആരും അതു കാൺകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","എന്റെ ദാസനായ കാലേബോ, അവന്നു വേറൊരു സ്വഭാവമുള്ളതുകൊണ്ടും എന്നെ പൂർണ്ണമായി അനുസരിച്ചതുകൊണ്ടും അവൻ പോയിരുന്ന ദേശത്തേക്കു ഞാൻ അവനെ എത്തിക്കും; അവന്റെ സന്തതി അതു കൈവശമാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","എന്നാൽ അമാലേക്യരും കനാന്യരും താഴ്‌വരയിൽ പാർക്കുന്നതുകൊണ്ടു നിങ്ങൾ നാളെ ചെങ്കടലിങ്കലേക്കുള്ള വഴിയായി മരുഭൂമിയിലേക്കു മടങ്ങിപ്പോകുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","ഈ ദുഷ്ടസഭ എത്രത്തോളം എനിക്കു വിരോധമായി പിറുപിറുക്കും? യിസ്രായേൽമക്കൾ എനിക്കു വിരോധമായി പിറുപിറുക്കുന്നതു ഞാൻ കേട്ടിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","അവരോടു പറവിൻ: ഞാൻ കേൾക്കെ നിങ്ങൾ പറഞ്ഞതുപോലെ തന്നേ, എന്നാണ, ഞാൻ നിങ്ങളോടു ചെയ്യുമെന്നു യഹോവ അരുളിച്ചെയ്യുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ഈ മരുഭൂമിയിൽ നിങ്ങളുടെ ശവം വീഴും; യെഫുന്നയുടെ മകൻ കാലേബും നൂന്റെ മകൻ യോശുവയും ഒഴികെ ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു എണ്ണപ്പെട്ടവരായി ");
INSERT INTO mal2015_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","എന്റെ നേരെ പിറുപിറുത്തവരായ നിങ്ങളുടെ എണ്ണത്തിൽ ആരും ഞാൻ നിങ്ങളെ പാർപ്പിക്കുമെന്നു സത്യം ചെയ്തിട്ടുള്ള ദേശത്തു കടക്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","എന്നാൽ കൊള്ളയായ്പോകുമെന്നു നിങ്ങൾ പറഞ്ഞിട്ടുള്ള നിങ്ങളുടെ കുഞ്ഞുകുട്ടികളെ ഞാൻ അതിൽ കടക്കുമാറാക്കും; നിങ്ങൾ നിരസിച്ചിരിക്കുന്ന ദേശം അവർ അറിയും. ");
INSERT INTO mal2015_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","നിങ്ങളോ, നിങ്ങളുടെ ശവം ഈ മരുഭൂമിയിൽ വീഴും. ");
INSERT INTO mal2015_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","നിങ്ങളുടെ ശവം മരുഭൂമിയിൽ ഒടുങ്ങുംവരെ നിങ്ങളുടെ മക്കൾ മരുഭൂമിയിൽ നാല്പതു സംവത്സരം ഇടയരായി സഞ്ചരിച്ചു നിങ്ങളുടെ പാതിവ്രത്യഭംഗം വഹിക്കും; ");
INSERT INTO mal2015_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ദേശം ഒറ്റു നോക്കിയ നാല്പതു ദിവസത്തിന്റെ എണ്ണത്തിന്നൊത്തവണ്ണം, ഒരു ദിവസത്തിന്നു ഒരു സംവത്സരം വീതം, നാല്പതു സംവത്സരം നിങ്ങൾ നിങ്ങളുടെ അകൃത്യങ്ങൾ വഹിച്ചു എന്റെ അകല്ച അറിയും. ");
INSERT INTO mal2015_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","എനിക്കു വിരോധമായി കൂട്ടംകൂടിയ ഈ ദുഷ്ടസഭയോടു ഞാൻ ഇങ്ങനെ ചെയ്യും: ഈ മരുഭൂമിയിൽ അവർ ഒടുങ്ങും; ഇവിടെ അവർ മരിക്കും എന്നു യഹോവയായ ഞാൻ കല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ദേശം ഒറ്റുനോക്കുവാൻ മോശെ അയച്ചവരും, മടങ്ങിവന്നു ദേശത്തെക്കുറിച്ചു ദുർവ്വർത്തമാനം പറഞ്ഞു സഭ മുഴുവനും അവന്നു വിരോധമായി പിറുപിറുപ്പാൻ സംഗതി വരുത്തിയ വരും, ");
INSERT INTO mal2015_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ദേശത്തെക്കുറിച്ചു ദുർവ്വർത്തമാനം പറഞ്ഞവരുമായ പുരുഷന്മാർ യഹോവയുടെ മുമ്പാകെ ഒരു ബാധകൊണ്ടു മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","എന്നാൽ ദേശം ഒറ്റുനോക്കുവാൻ പോയ പുരുഷന്മാരിൽ നൂന്റെ മകൻ യോശുവയും യെഫുന്നയുടെ പുത്രൻ കാലേബും മരിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","പിന്നെ മോശെ ഈ വാക്കുകൾ യിസ്രായേൽമക്കളോടൊക്കെയും പറഞ്ഞു; ജനം ഏറ്റവും ദുഃഖിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","പിറ്റേന്നു അവർ അതികാലത്തു എഴുന്നേറ്റു: ഇതാ, യഹോവ ഞങ്ങൾക്കു ചൊല്ലിയിരിക്കുന്ന സ്ഥലത്തേക്കു ഞങ്ങൾ കയറിപ്പോകുന്നു: ഞങ്ങൾ പാപം ചെയ്തുപോയി എന്നു പറഞ്ഞു മലമുകളിൽ കയറി. ");
INSERT INTO mal2015_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","അപ്പോൾ മോശെ: നിങ്ങൾ എന്തിന്നു യഹോവയുടെ കല്പന ലംഘിക്കുന്നു? അതു സാദ്ധ്യമാകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ശത്രുക്കളാൽ തോൽക്കാതിരിക്കേണ്ടതിന്നു നിങ്ങൾ കയറരുതു; യഹോവ നിങ്ങളുടെ മദ്ധ്യേ ഇല്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","അമാലേക്യരും കനാന്യരും അവിടെ നിങ്ങളുടെ മുമ്പിൽ ഉണ്ടു; നിങ്ങൾ വാളാൽ വീഴും; നിങ്ങൾ യഹോവയെ വിട്ടു പിന്തിരിഞ്ഞിരിക്കകൊണ്ടു യഹോവ നിങ്ങളോടുകൂടെ ഉണ്ടായിരിക്കയില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","എന്നിട്ടും അവർ ധാർഷ്ട്യം പൂണ്ടു മലമുകളിൽ കയറി; യഹോവയുടെ നിയമപെട്ടകവും മോശെയും പാളയത്തിൽനിന്നു പുറപ്പെട്ടില്ലതാനും. ");
INSERT INTO mal2015_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","എന്നാറെ മലയിൽ പാർത്തിരുന്ന അമാലേക്യരും കനാന്യരും ഇറങ്ങിവന്നു അവരെ തോല്പിച്ചു ഹോർമ്മാവരെ അവരെ ഛിന്നിച്ചു ഓടിച്ചുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതെന്തെന്നാൽ: ഞാൻ നിങ്ങൾക്കു തരുന്ന നിങ്ങളുടെ നിവാസദേശത്തു നിങ്ങൾ ചെന്നിട്ടു ");
INSERT INTO mal2015_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ഒരു നേർച്ച നിവർത്തിപ്പാനോ സ്വമേധാദാനമായിട്ടോ നിങ്ങളുടെ ഉത്സവങ്ങളിലോ യഹോവെക്കു മാടിനെയാകട്ടെ ആടിനെയാകട്ടെ ഹോമയാഗമായിട്ടെങ്കിലും ഹനനയാഗമായിട്ടെങ്കിലും യഹോവെക്കു സൗരഭ്യവാസനയാകുമാറു ഒരു ദഹനയാഗം അർപ്പിക്കുമ്പോൾ ");
INSERT INTO mal2015_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","യഹോവെക്കു വഴിപാടുകഴിക്കുന്നവൻ കാൽഹീൻ എണ്ണ ചേർത്ത ഒരിടങ്ങഴി മാവു ഭോജനയാഗമായി കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ഹോമയാഗത്തിന്നും ഹനനയാഗത്തിന്നും പാനീയയാഗമായി നീ ആടൊന്നിന്നു കാൽഹീൻ വീഞ്ഞു കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","ആട്ടുകൊറ്റനായാൽ ഹീനിൽ മൂന്നിലൊന്നു എണ്ണ ചേർത്ത രണ്ടിടങ്ങഴി മാവു ഭോജനയാഗമായി കൊണ്ടുവരേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","അതിന്റെ പാനീയയാഗത്തിന്നു ഹീനിൽ മൂന്നിലൊന്നു വീഞ്ഞും യഹോവെക്കു സൗരഭ്യവാസനയായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","നേർച്ച നിവർത്തിപ്പാനോ യഹോവെക്കു സമാധാനയാഗം കഴിപ്പാനോ ഹോമയാഗത്തിന്നാകട്ടെ ഹനനയാഗത്തിന്നാകട്ടെ ഒരു കാളക്കിടാവിനെ കൊണ്ടുവരുമ്പോൾ ");
INSERT INTO mal2015_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","കിടാവിനോടുകൂടെ അരഹീൻ എണ്ണ ചേർത്ത മൂന്നിടങ്ങഴി മാവു ഭോജനയാഗമായിട്ടു അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","അതിന്റെ പാനീയയാഗമായി അരഹീൻ വീഞ്ഞു യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","കാളക്കിടാവു, ആട്ടുകൊറ്റൻ, കുഞ്ഞാടു, കോലാട്ടിൻകുട്ടി എന്നിവയിൽ ഓരോന്നിന്നും ഇങ്ങനെ തന്നേ വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","നിങ്ങൾ അർപ്പിക്കുന്ന യാഗമൃഗങ്ങളുടെ എണ്ണത്തിന്നും ഒത്തവണ്ണം ഓരോന്നിന്നും ഇങ്ങനെ തന്നേ വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","സ്വദേശിയായവനൊക്കെയും യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗം അർപ്പിക്കുമ്പോൾ ഇതെല്ലാം ഇങ്ങനെതന്നേ അനുഷ്ഠിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","നിങ്ങളോടുകൂടെ പാർക്കുന്ന പരദേശിയോ നിങ്ങളുടെ ഇടയിൽ സ്ഥിരവാസം ചെയ്യുന്ന ഒരുത്തനോ യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗം കഴിക്കുന്നുവെങ്കിൽ നിങ്ങൾ അനുഷ്ഠിക്കുംവണ്ണം തന്നേ അവനും അനുഷ്ഠിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","നിങ്ങൾക്കാകട്ടെ വന്നു പാർക്കുന്ന പരദേശിക്കാകട്ടെ സർവ്വസഭെക്കും തലമുറതലമുറയായി എന്നേക്കും ഒരു ചട്ടം തന്നേ ആയിരിക്കേണം; യഹോവയുടെ സന്നിധിയിൽ പരദേശി നിങ്ങളെപ്പോലെ തന്നേ ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","നിങ്ങൾക്കും വന്നു പാർക്കുന്ന പരദേശിക്കും പ്രമാണവും നിയമവും ഒന്നുതന്നേ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","യിസ്രായേൽമക്കളോടു പറയേണ്ടതെന്തെന്നാൽ: ഞാൻ നിങ്ങളെ കൊണ്ടുപോകുന്ന ദേശത്തു നിങ്ങൾ എത്തിയശേഷം ");
INSERT INTO mal2015_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ദേശത്തിലെ ആഹാരം ഭക്ഷിക്കുമ്പോൾ നിങ്ങൾ യഹോവെക്കു ഉദർച്ചാർപ്പണം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ആദ്യത്തെ തരിമാവുകൊണ്ടുള്ള ഒരു വട ഉദർച്ചാർപ്പണമായി കഴിക്കേണം; മെതിക്കളത്തിന്റെ ഉദർച്ചാർപ്പണംപോലെ തന്നേ അതു ഉദർച്ച ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ഇങ്ങനെ നിങ്ങൾ തലമുറതലമുറയായി ആദ്യത്തെ തരിമാവുകൊണ്ടു യഹോവെക്കു ഉദർച്ചാർപ്പണം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","യഹോവ മോശെയോടു കല്പിച്ച ഈ സകലകല്പനകളിലും ");
INSERT INTO mal2015_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","യാതൊന്നെങ്കിലും യഹോവ മോശെയോടു കല്പിച്ച നാൾമുതൽ തലമുറതലമുറയായി യഹോവ മോശെമുഖാന്തരം നിങ്ങളോടു കല്പിച്ച സകലത്തിലും യാതൊന്നെങ്കിലും നിങ്ങൾ പ്രമാണിക്കാതെ തെറ്റു ചെയ്താൽ, ");
INSERT INTO mal2015_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","അറിയാതെകണ്ടു അബദ്ധവശാൽ സഭ വല്ലതും ചെയ്തുപോയാൽ സഭയെല്ലാം കൂടെ ഹോമയാഗത്തിന്നായി ഒരു കാളക്കിടാവിനെയും പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റനെയും ചട്ടപ്രകാരം അതിന്നുള്ള ഭോജനയാഗത്തോടും പാനീയയാഗത്തോടുംകൂടെ യഹോവെക്കു സൗരഭ്യവാസനയായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ഇങ്ങനെ പുരോഹിതൻ യിസ്രായേൽമക്കളുടെ സർവ്വസഭെക്കുംവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണം; എന്നാൽ അതു അവരോടു ക്ഷമിക്കപ്പെടും; അതു അബദ്ധവശാൽ സംഭവിക്കയും അവർ തങ്ങളുടെ അബദ്ധത്തിന്നായിട്ടു യഹോവെക്കു ദഹനയാഗമായി തങ്ങളുടെ വഴിപാടും പാപയാഗവും യഹോവയുടെ സന്നിധിയിൽ അർപ്പിക്കയും ചെയ്തുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","എന്നാൽ അതു യിസ്രായേൽമക്കളുടെ സർവ്വസഭയോടും അവരുടെ ഇടയിൽ വന്നുപാർക്കുന്ന പരദേശിയോടും ക്ഷമിക്കപ്പെടും; തെറ്റു സർവ്വജനത്തിന്നുമുള്ളതായിരുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","ഒരാൾ അബദ്ധവശാൽ പാപം ചെയ്താൽ അവൻ തനിക്കുവേണ്ടി പാപയാഗത്തിന്നായി ഒരു വയസ്സു പ്രായമുള്ള ഒരു പെൺകോലാട്ടിനെ അർപ്പിക്കണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","അബദ്ധവശാൽ പാപം ചെയ്തവന്നു പാപപരിഹാരം വരുത്തുവാൻ പുരോഹിതൻ അവന്നുവേണ്ടി യഹോവയുടെ സന്നിധിയിൽ പ്രായശ്ചിത്തകർമ്മം അനുഷ്ഠിക്കേണം; എന്നാൽ അതു അവനോടു ക്ഷമിക്കപ്പെടും. ");
INSERT INTO mal2015_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","യിസ്രായേൽമക്കളുടെ ഇടയിൽ അബദ്ധവശാൽ പാപം ചെയ്യുന്നവൻ സ്വദേശിയോ വന്നു പാർക്കുന്ന പരദേശിയോ ആയാലും പ്രമാണം ഒന്നുതന്നേ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","എന്നാൽ സ്വദേശികളിലോ പരദേശികളിലോ ആരെങ്കിലും കരുതിക്കൂട്ടിക്കൊണ്ടു ചെയ്താൽ അവൻ യഹോവയെ ദുഷിക്കുന്നു; അവനെ അവന്റെ ജനത്തിൽ നിന്നു ഛേദിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","അവൻ യഹോവയുടെ വചനം ധിക്കരിച്ചു അവന്റെ കല്പന ലംഘിച്ചു; അവനെ നിർമ്മൂലമാക്കിക്കളയേണം; അവന്റെ അകൃത്യം അവന്റെമേൽ ഇരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","യിസ്രായേൽമക്കൾ മരുഭൂമിയിൽ ഇരിക്കുമ്പോൾ ശബ്ബത്ത് നാളിൽ ഒരുത്തൻ വിറകു പെറുക്കുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","അവൻ വിറകു പെറുക്കുന്നതു കണ്ടവർ അവനെ മോശെയുടെയും അഹരോന്റെയും സർവ്വസഭയുടെയും അടുക്കൽ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","അവനോടു ചെയ്യേണ്ടതു ഇന്നതെന്നു വിധിച്ചിട്ടില്ലായ്കകൊണ്ടു അവർ അവനെ തടവിൽ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","പിന്നെ യഹോവ മോശെയോടു: ആ മനുഷ്യൻ മരണശിക്ഷ അനുഭവിക്കേണം; സർവ്വസഭയും പാളയത്തിന്നു പുറത്തുവെച്ചു അവനെ കല്ലെറിയേണം എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ തന്നേ സർവ്വസഭയും അവനെ പാളയത്തിന്നു പുറത്തു കൊണ്ടുപോയി കല്ലെറിഞ്ഞു കൊന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതെന്തെന്നാൽ: അവർ തലമുറതലമുറയായി വസ്ത്രത്തിന്റെ കോൺതലെക്കു പൊടിപ്പു ഉണ്ടാക്കുകയും കോൺതലെക്കലെ പൊടിപ്പിൽ നീലച്ചരടു കെട്ടുകയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","നിങ്ങൾ യഹോവയുടെ സകലകല്പനകളും ഓർത്തു അനുസരിക്കേണ്ടതിന്നും നിങ്ങളുടെ സ്വന്തഹൃദയത്തിന്നും സ്വന്തകണ്ണിന്നും തോന്നിയവണ്ണം പരസംഗമായി നടക്കാതിരിക്കേണ്ടതിന്നും ആ പൊടിപ്പു ജ്ഞാപകം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","നിങ്ങൾ എന്റെ സകലകല്പനകളും ഓർത്തു അനുസരിച്ചു നിങ്ങളുടെ ദൈവത്തിന്നു വിശുദ്ധരായിരിക്കേണ്ടതിന്നു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","നിങ്ങളുടെ ദൈവമായിരിക്കേണ്ടതിന്നു നിങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്ന ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവ ആകുന്നു; ഞാൻ നിങ്ങളുടെ ദൈവമായ യഹോവതന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","എന്നാൽ ലേവിയുടെ മകനായ കെഹാത്തിന്റെ മകനായ യിസ്ഹാരിന്റെ മകൻ കോരഹ്, രൂബേൻഗോത്രത്തിൽ എലീയാബിന്റെ പുത്രന്മാരായ ദാഥാൻ, അബീരാം, പേലെത്തിന്റെ മകനായ ഓൻ എന്നിവർ ");
INSERT INTO mal2015_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","യിസ്രായേൽമക്കളിൽ സഭാപ്രധാനികളും സംഘസദസ്യന്മാരും പ്രമാണികളുമായ ഇരുനൂറ്റമ്പതു പുരുഷന്മാരെ കൂട്ടി മോശെയോടു മത്സരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","അവൻ മോശെക്കും അഹരോന്നും വിരോധമായി കൂട്ടംകൂടി അവരോടു: മതി, മതി; സഭ ഒട്ടൊഴിയാതെ എല്ലാവരും വിശുദ്ധരാകുന്നു; യഹോവ അവരുടെ മദ്ധ്യേ ഉണ്ടു; പിന്നെ നിങ്ങൾ യഹോവയുടെ സഭെക്കു മീതെ നിങ്ങളെത്തന്നേ ഉയർത്തുന്നതു എന്തു? എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ഇതു കേട്ടപ്പോൾ മോശെ കവിണ്ണുവീണു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","അവൻ കോരഹിനോടും അവന്റെ എല്ലാ കൂട്ടരോടും പറഞ്ഞതു: നാളെ രാവിലെ യഹോവ തനിക്കുള്ളവർ ആരെന്നും തന്നോടടുപ്പാൻ തക്കവണ്ണം വിശുദ്ധൻ ആരെന്നും കാണിക്കും; താൻ തിരഞ്ഞെടുക്കുന്നവനെ തന്നോടു അടുക്കുമാറാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","കോരഹും അവന്റെ എല്ലാകൂട്ടവുമായുള്ളോരേ, നിങ്ങൾ ഇതു ചെയ്‌വിൻ: ");
INSERT INTO mal2015_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ധൂപകലശം എടുത്തു നാളെ യഹോവയുടെ സന്നിധിയിൽ അതിൽ തീയിട്ടു ധൂപവർഗ്ഗം ഇടുവിൻ; യഹോവ തിരഞ്ഞെടുക്കുന്നവൻ തന്നേ വിശുദ്ധൻ; ലേവിപുത്രന്മാരേ, മതി, മതി! ");
INSERT INTO mal2015_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","പിന്നെ മോശെ കോരഹിനോടു പറഞ്ഞതു: ലേവിപുത്രന്മാരേ, കേൾപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","യഹോവയുടെ തിരുനിവാസത്തിലെ വേലചെയ്‌വാനും സഭയുടെ ശുശ്രൂഷെക്കായി അവരുടെ മുമ്പാകെ നില്പാനും യിസ്രായേലിന്റെ ദൈവം നിങ്ങളെ തന്റെ അടുക്കൽ വരുത്തേണ്ടതിന്നു യിസ്രായേൽസഭയിൽനിന്നു നിങ്ങളെ വേറുതിരിച്ചതു നിങ്ങൾക്കു പോരായോ? ");
INSERT INTO mal2015_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","അവൻ നിന്നെയും ലേവിപുത്രന്മാരായ നിന്റെ സകലസഹോദരന്മാരെയും തന്നോടു അടുക്കുമാറാക്കിയല്ലോ; നിങ്ങൾ പൗരോഹിത്യംകൂടെ കാംക്ഷിക്കുന്നുവോ? ");
INSERT INTO mal2015_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ഇതു ഹേതുവായിട്ടു നീയും നിന്റെ കൂട്ടക്കാർ ഒക്കെയും യഹോവെക്കു വിരോധമായി കൂട്ടംകൂടിയിരിക്കുന്നു; നിങ്ങൾ അഹരോന്റെ നേരെ പിറുപിറുപ്പാൻ തക്കവണ്ണം അവൻ എന്തുമാത്രമുള്ളു? ");
INSERT INTO mal2015_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","പിന്നെ മോശെ എലിയാബിന്റെ പുത്രന്മാരായ ദാഥാനെയും അബീരാമിനെയും വിളിപ്പാൻ ആളയച്ചു; അതിന്നു അവർ: ");
INSERT INTO mal2015_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ഞങ്ങൾ വരികയില്ല; മരുഭൂമിയിൽ ഞങ്ങളെ കൊല്ലുവാൻ നീ ഞങ്ങളെ പാലും തേനും ഒഴുകുന്ന ദേശത്തുനിന്നു കൊണ്ടുവന്നരിക്കുന്നതു പോരാഞ്ഞിട്ടു നിന്നെത്തന്നെ ഞങ്ങൾക്കു അധിപതിയും ആക്കുന്നുവോ? ");
INSERT INTO mal2015_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","അത്രയുമല്ല, നീ ഞങ്ങളെ പാലും തേനും ഒഴുകുന്ന ദേശത്തേക്കു കൊണ്ടുവരികയോ നിലങ്ങളും മുന്തിരിത്തോട്ടങ്ങളും അവകാശമായി തരികയോ ചെയ്തിട്ടില്ല; നീ ഇവരുടെ കണ്ണു ചുഴന്നുകളയുമോ? ഞങ്ങൾ വരികയില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","അപ്പോൾ മോശെ ഏറ്റവും കോപിച്ചു. അവൻ യഹോവയോടു: അവരുടെ വഴിപാടു കടാക്ഷിക്കരുതേ; ഞാൻ അവരുടെ പക്കൽനിന്നു ഒരു കഴുതയെപ്പോലും വാങ്ങീട്ടില്ല; അവരിൽ ഒരുത്തനോടും ഒരു ദോഷം ചെയ്തിട്ടുമില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","മോശെ കോരഹിനോടു: നീയും നിന്റെ എല്ലാകൂട്ടവും നാളെ യഹോവയുടെ സന്നിധിയിൽ വരേണം; നീയും അവരും അഹരോനും കൂടെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","നിങ്ങൾ ഓരോരുത്തൻ താന്താന്റെ ധൂപകലശം എടുത്തു അവയിൽ ധൂപവർഗ്ഗം ഇട്ടു ഒരോരുത്തൻ ഓരോ ധൂപകലശമായി ഇരുനൂറ്റമ്പതു കലശവും യഹോവയുടെ സന്നിധിയിൽ കൊണ്ടുവരുവിൻ; നീയും അഹരോനും കൂടെ താന്താന്റെ ധൂപകലശവുമായി വരേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","അങ്ങനെ അവർ ഓരോരുത്തൻ താന്താന്റെ ധൂപകലശം എടുത്തു തീയിട്ടു അതിൽ ധൂപവർഗ്ഗവും ഇട്ടു മോശെയും അഹരോനുമായി സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","കോരഹ് അവർക്കു വിരോധമായി സർവ്വസഭയെയും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ കൂട്ടിവരുത്തി; അപ്പോൾ യഹോവയുടെ തേജസ്സു സർവ്വസഭെക്കും പ്രത്യക്ഷമായി. ");
INSERT INTO mal2015_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","യഹോവ മോശെയോടും അഹരോനോടും: ");
INSERT INTO mal2015_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","ഈ സഭയുടെ മദ്ധ്യേനിന്നു മാറിപ്പോകുവിൻ; ഞാൻ അവരെ ക്ഷണത്തിൽ സംഹരിക്കും എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","അപ്പോൾ അവർ കവിണ്ണുവീണു: സകലജനത്തിന്റെയും ആത്മാക്കൾക്കു ഉടയവനാകുന്ന ദൈവമേ, ഒരു മനുഷ്യൻ പാപം ചെയ്തതിന്നു നീ സർവ്വസഭയോടും കോപിക്കുമൊ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","അതിന്നു യഹോവ മോശെയോടു: ");
INSERT INTO mal2015_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","കോരഹ്, ദാഥാൻ, അബീരാം എന്നിവരുടെ വാസസ്ഥലത്തിന്റെ ചുറ്റിലും നിന്നു മാറിക്കൊൾവിൻ എന്നു സഭയോടു പറക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","മോശെ എഴുന്നേറ്റു ദാഥാന്റെയും അബീരാമിന്റെയും അടുക്കൽ ചെന്നു; യിസ്രായേൽമൂപ്പന്മാരും അവന്റെ പിന്നാലെ ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","അവൻ സഭയോടു: ഈ ദുഷ്ടമനുഷ്യരുടെ സകലപാപങ്ങളാലും നിങ്ങൾ സംഹരിക്കപ്പെടാതിരിക്കേണ്ടതിന്നു അവരുടെ കൂടാരങ്ങളുടെ അടുക്കൽനിന്നു മാറിപ്പോകുവിൻ; അവർക്കുള്ള യാതൊന്നിനെയും തൊടരുതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","അങ്ങനെ അവർ കോരഹ്, ദാഥാൻ, അബീരാം എന്നവരുടെ വാസസ്ഥലത്തിന്റെ ചുറ്റിലുംനിന്നു മാറിപ്പോയി. എന്നാൽ ദാഥാനും അബീരാമും പുറത്തു വന്നു: അവരും അവരുടെ ഭാര്യമാരും പുത്രന്മാരും കുഞ്ഞുങ്ങളും താന്താങ്ങളുടെ കൂടാരവാതിൽക്കൽനിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","അപ്പോൾ മോശെ പറഞ്ഞതു: ഈ സകലപ്രവൃത്തികളും ചെയ്യേണ്ടതിന്നു യഹോവ എന്നെ അയച്ചു; ഞാൻ സ്വമേധയായി ഒന്നും ചെയ്തിട്ടില്ല എന്നു നിങ്ങൾ ഇതിനാൽ അറിയും: ");
INSERT INTO mal2015_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","സകലമനുഷ്യരും മരിക്കുന്നതുപോലെ ഇവർ മരിക്കയോ സകലമനുഷ്യർക്കും ഭവിക്കുന്നതുപോലെ ഇവർക്കു ഭവിക്കയോ ചെയ്താൽ യഹോവ എന്നെ അയച്ചിട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","എന്നാൽ യഹോവ ഒരു അപൂർവ്വകാര്യം പ്രവർത്തിക്കയും ഭൂമി വായ് പിളർന്നു അവരെയും അവർക്കുള്ള സകലത്തെയും വിഴുങ്ങിക്കളകയും അവർ ജീവനോടു പാതാളത്തിലേക്കു ഇറങ്ങുകയും ചെയ്താൽ അവർ യഹോവയെ നിരസിച്ചു എന്നു നിങ്ങൾ അറിയും. ");
INSERT INTO mal2015_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","അവൻ ഈ വാക്കുകളെല്ലാം പറഞ്ഞു തീർന്നപ്പോൾ അവരുടെ കീഴെ ഭൂമി പിളർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ഭൂമി വായ് തുറന്നു അവരെയും അവരുടെ കുടുംബങ്ങളെയും കോരഹിനോടു ചേർന്നിട്ടുള്ള എല്ലാവരെയും അവരുടെ സർവ്വസമ്പത്തിനെയും വിഴുങ്ങിക്കളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","അവരും അവരോടു ചേർന്നിട്ടുള്ള എല്ലാവരും ജീവനോടെ പാതാളത്തിലേക്കു ഇറങ്ങി; ഭൂമി അവരുടെമേൽ അടകയും അവർ സഭയുടെ ഇടയിൽനിന്നു നശിക്കയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","അവരുടെ ചുറ്റും ഇരുന്ന യിസ്രായേല്യർ ഒക്കെയും അവരുടെ നിലവിളി കേട്ടു: ഭൂമി നമ്മെയും വഴുങ്ങിക്കളയരുതേ എന്നു പറഞ്ഞു ഓടിപ്പോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","അപ്പോൾ യഹോവയിങ്കൽനിന്നു തീ പുറപ്പെട്ടു ധൂപം കാട്ടിയ ഇരുനൂറ്റമ്പതുപേരെയും ദഹിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","പുരോഹിതനായ അഹരോന്റെ മകൻ എലെയാസാരിനോടു അവൻ എരിതീയുടെ ഇടയിൽനിന്നു ധൂപകലശങ്ങൾ എടുപ്പാൻ പറക; അവ വിശുദ്ധമാകുന്നു; തീ അങ്ങോട്ടു തട്ടിക്കളകയും ചെയ്ക; ");
INSERT INTO mal2015_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","പാപം ചെയ്തു തങ്ങൾക്കു ജീവനാശം വരുത്തിയ ഇവരുടെ ധൂപകലശങ്ങൾ യാഗപീഠം പൊതിവാൻ അടിച്ചു തകിടാക്കണം; അതു യഹോവയുടെ സന്നിധിയിൽ കൊണ്ടുവന്നതിനാൽ വിശുദ്ധമാകുന്നു; യിസ്രായേൽമക്കൾക്കു അതു ഒരു അടയാളമായിരിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","വെന്തുപോയവർ ധൂപം കാട്ടിയ താമ്രകലശങ്ങൾ പുരോഹിതനായ എലെയാസാർ എടുത്തു ");
INSERT INTO mal2015_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","അഹരോന്റെ സന്തതിയിൽ അല്ലാത്ത യാതൊരു അന്യനും യഹോവയുടെ സന്നിധിയിൽ ധൂപം കാണിപ്പാൻ അടുക്കയും കോരഹിനെയും അവന്റെ കൂട്ടുകാരെയുംപോലെ ആകയും ചെയ്യാതിരിക്കേണ്ടതിന്നു യിസ്രായേൽമക്കൾക്കു ജ്ഞാപകമായി അവയെ യാഗപീഠം പൊതിവാൻ തകിടായി അടിപ്പിച്ചു; യഹോവ മോശെമുഖാന്തരം കല്പിച്ചതു പോലെതന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","പിറ്റെന്നാൾ യിസ്രായേൽമക്കളുടെ സഭയെല്ലാം മോശെക്കും അഹരോന്നും വിരോധമായി പിറുപിറുത്തു: നിങ്ങൾ യഹോവയുടെ ജനത്തെ കൊന്നുകളഞ്ഞു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ഇങ്ങനെ മോശെക്കും അഹരോന്നും വിരോധമായി സഭകൂടിയപ്പോൾ അവർ സമാഗമനകൂടാരത്തിന്റെ നേരെ നോക്കി: മേഘം അതിനെ മൂടി യഹോവയുടെ തേജസ്സും പ്രത്യക്ഷമായിരിക്കുന്നതു കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","അപ്പോൾ മോശെയും അഹരോനും സമാഗമനകൂടാരത്തിന്റെ മുമ്പിൽ ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","യഹോവ മോശെയോടു: ഈ സഭയുടെ മദ്ധ്യേനിന്നു മാറിപ്പോകുവിൻ; ");
INSERT INTO mal2015_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","ഞാൻ അവരെ ക്ഷണത്തിൽ സംഹരിക്കും എന്നരുളിച്ചെയ്തു. അപ്പോൾ അവർ കവിണ്ണുവീണു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","മോശെ അഹരോനോടു: നീ ധൂപകലശം എടുത്തു അതിൽ യാഗപീഠത്തിലെ തീ ഇട്ടു ധൂപവർഗ്ഗവും ഇട്ടു വേഗത്തിൽ സഭയുടെ മദ്ധ്യേ ചെന്നു അവർക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്ക; യഹോവയുടെ സന്നിധിയിൽനിന്നു ക്രോധം പുറപ്പെട്ടു ബാധ തുടങ്ങിയിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","മോശെ കല്പിച്ചതുപോലെ അഹരോൻ കലശം എടുത്തു സഭയുടെ നടുവിലേക്കു ഓടി, ബാധ ജനത്തിന്റെ ഇടയിൽ തുടങ്ങിയിരിക്കുന്നതു കണ്ടു, ധൂപം കാട്ടി ജനത്തിന്നുവേണ്ടി പ്രായശ്ചിത്തം കഴിച്ചു, ");
INSERT INTO mal2015_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","മരിച്ചവർക്കും ജീവനുള്ളവർക്കും നടുവിൽ നിന്നപ്പോൾ ബാധ അടങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","കോരഹിന്റെ സംഗതിവശാൽ മരിച്ചവരെ കൂടാതെ ബാധയാൽ മരിച്ചവർ പതിന്നാലായിരത്തെഴുനൂറുപേർ ആയിരുന്നു ");
INSERT INTO mal2015_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","പിന്നെ അഹരോൻ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ മോശെയുടെ അടുക്കൽ മടങ്ങിവന്നു, അങ്ങനെ ബാധ നിന്നുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","യിസ്രായേൽമക്കളോടു സംസാരിച്ചു അവരുടെ പക്കൽനിന്നു ഗോത്രം ഗോത്രമായി സകലഗോത്രപ്രഭുക്കന്മാരോടും ഓരോ വടിവീതം പന്ത്രണ്ടു വടി വാങ്ങി ഓരോരുത്തന്റെ വടിമേൽ അവന്റെ പേർ എഴുതുക. ");
INSERT INTO mal2015_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ലേവിയുടെ വടിമേലോ അഹരോന്റെ പേർ എഴുതേണം; ഓരോ ഗോത്രത്തലവന്നു ഓരോ വടി ഉണ്ടായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","സമാഗമനകൂടാരത്തിൽ ഞാൻ നിങ്ങൾക്കു വെളിപ്പെടുന്ന ഇടമായ സാക്ഷ്യത്തിന്റെ മുമ്പാകെ അവയെ വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ഞാൻ തിരഞ്ഞെടുക്കുന്നവന്റെ വടി തളിർക്കും; ഇങ്ങനെ യിസ്രായേൽമക്കൾ നിങ്ങൾക്കു വിരോധമായി പിറുപിറുക്കുന്നതു ഞാൻ നിർത്തലാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","മോശെ യിസ്രായേൽമക്കളോടു സംസാരിക്കയും അവരുടെ സകലപ്രഭുക്കന്മാരും ഗോത്രംഗോത്രമായി ഓരോ പ്രഭു ഓരോ വടിവീതം പന്ത്രണ്ടു വടി അവന്റെ പക്കൽ കൊടുക്കയും ചെയ്തു: വടികളുടെ കൂട്ടത്തിൽ അഹരോന്റെ വടിയും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","മോശെ വടികളെ സാക്ഷ്യകൂടാരത്തിൽ യഹോവയുടെ സന്നിധിയിൽ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","പിറ്റെന്നാൾ മോശെ സാക്ഷ്യകൂടാരത്തിൽ കടന്നപ്പോൾ ലേവിഗൃഹത്തിന്നുള്ള അഹരോന്റെ വടി തളിർത്തിരിക്കുന്നതു കണ്ടു; അതു തളിർത്തു പൂത്തു ബദാം ഫലം കായിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","മോശെ വടികളെല്ലാം യഹോവയുടെ സന്നിധിയിൽനിന്നു എടുത്തു യിസ്രായേൽമക്കളുടെ അടുക്കൽ പുറത്തു കൊണ്ടുവന്നു; അവർ ഓരോരുത്തൻ താന്താന്റെ വടി നോക്കിയെടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","യഹോവ മോശെയോടു: അഹരോന്റെ വടി മത്സരികൾക്കു ഒരു അടയാളമായി സൂക്ഷിക്കേണ്ടതിന്നു സാക്ഷ്യത്തിന്റെ മുമ്പിൽ തിരികെ കൊണ്ടുവരിക; അവർ മരിക്കാതിരിക്കേണ്ടതിന്നു എനിക്കു വിരോധമായുള്ള അവരുടെ പിറുപിറുപ്പു നീ ഇങ്ങനെ നിർത്തലാക്കും എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","മോശെ അങ്ങനെ തന്നേ ചെയ്തു: യഹോവ തന്നോടു കല്പിച്ചതുപോലെ അവൻ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","അപ്പോൾ യിസ്രായേൽമക്കൾ മോശെയോടു: ഇതാ, ഞങ്ങൾ ചത്തൊടുങ്ങുന്നു; ഞങ്ങൾ നശിക്കുന്നു; ഞങ്ങൾ എല്ലാവരും നശിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","യഹോവയുടെ തിരുനിവാസത്തോടു അടുക്കുന്നവനെല്ലാം ചാകുന്നു; ഞങ്ങൾ ഒക്കെയും ചത്തൊടുങ്ങേണമോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","പിന്നെ യഹോവ അഹരോനോടു അരുളിച്ചെയ്തതെന്തെന്നാൽ: നീയും നിന്റെ പുത്രന്മാരും നിന്റെ പിതൃഭവനവും വിശുദ്ധമന്ദിരം സംബന്ധിച്ചുണ്ടാകുന്ന അകൃത്യം വഹിക്കേണം; നീയും നിന്റെ പുത്രന്മാരും നിങ്ങളുടെ പൗരോഹിത്യം സംബന്ധിച്ചുണ്ടാകുന്ന അകൃത്യവും വഹിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","നിന്റെ പിതൃഗോത്രമായ ലേവിഗോത്രത്തിലുള്ള നിന്റെ സഹോദരന്മാരെയും നിന്നോടുകൂടെ അടുത്തുവരുമാറാക്കേണം. അവർ നിന്നോടു ചേർന്നു നിനക്കു ശുശ്രൂഷ ചെയ്യേണം; നീയും നിന്റെ പുത്രന്മാരുമോ സാക്ഷ്യകൂടാരത്തിങ്കൽ ശുശ്രൂഷ ചെയ്യേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","അവർ നിനക്കും കൂടാരത്തിന്നൊക്കെയും ആവശ്യമുള്ള കാര്യം നോക്കേണം; എന്നാൽ അവരും നിങ്ങളും കൂടെ മരിക്കാതിരിക്കേണ്ടതിന്നു അവർ വിശുദ്ധമന്ദിരത്തിലെ ഉപകരണങ്ങളോടും യാഗപീഠത്തോടും അടുക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","അവർ നിന്നോടു ചേർന്നു സമാഗമനകൂടാരം സംബന്ധിച്ചുള്ള സകലവേലെക്കുമായി കൂടാരത്തിന്റെ കാര്യം നോക്കേണം; ഒരു അന്യനും നിങ്ങളോടു അടുക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","യിസ്രായേൽമക്കളുടെ മേൽ ഇനി ക്രോധം വരാതിരിക്കേണ്ടതിന്നു വിശുദ്ധമന്ദിരത്തിന്റെയും യാഗപീഠത്തിന്റെയും കാര്യം നിങ്ങൾ നോക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ലേവ്യരായ നിങ്ങളുടെ സഹോദരന്മാരെയോ ഞാൻ യിസ്രായേൽമക്കളുടെ ഇടയിൽനിന്നു എടുത്തിരിക്കുന്നു; യഹോവെക്കു ദാനമായിരിക്കുന്ന അവരെ സമാഗമനകൂടാരം സംബന്ധിച്ചുള്ള വേല ചെയ്യേണ്ടതിന്നു ഞാൻ നിങ്ങൾക്കു ദാനം ചെയ്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ആകയാൽ നീയും നിന്റെ പുത്രന്മാരും യാഗപീഠത്തിങ്കലും തിരശ്ശീലെക്കകത്തും ഉള്ള സകലകാര്യത്തിലും നിങ്ങളുടെ പൗരോഹിത്യം അനുഷ്ഠിച്ചു ശുശ്രൂഷചെയ്യേണം; പൗരോഹിത്യം ഞാൻ നിങ്ങൾക്കു ദാനം ചെയ്തിരിക്കുന്നു; അന്യൻ അടുത്തു വന്നാൽ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","യഹോവ പിന്നെയും അഹരോനോടു അരുളിച്ചെയ്തതു: ഇതാ, എന്റെ ഉദർച്ചാർപ്പണങ്ങളുടെ കാര്യം ഞാൻ നിന്നെ ഭരമേല്പിച്ചിരിക്കുന്നു; യിസ്രായേൽമക്കളുടെ സകലവസ്തുക്കളിലും അവയെ ഞാൻ നിനക്കും നിന്റെ പുത്രന്മാർക്കും ഓഹരിയായും ശാശ്വതവാകാശമായും തന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","തീയിൽ ദഹിപ്പിക്കാത്തതായി അതിവിശുദ്ധവസ്തുക്കളിൽവെച്ചു ഇതു നിനക്കുള്ളതായിരിക്കേണം; അവർ എനിക്കു അർപ്പിക്കുന്ന അവരുടെ എല്ലാവഴിപാടും സകലഭോജനയാഗവും സകലപാപയാഗവും സകലഅകൃത്യയാഗവും അതിവിശുദ്ധമായി നിനക്കും നിന്റെ പുത്രന്മാർക്കും ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","അതിവിശുദ്ധവസ്തുവായിട്ടു അതു ഭക്ഷിക്കേണം; ആണുങ്ങളെല്ലാം അതു ഭക്ഷിക്കേണം. അതു നിനക്കുവേണ്ടി വിശുദ്ധമായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","യിസ്രായേൽമക്കളുടെ ദാനമായുള്ള ഉദർച്ചാർപ്പണമായ ഇതു അവരുടെ സകലനീരാജനയാഗങ്ങളോടുംകൂടെ നിനക്കുള്ളതാകുന്നു; ഇവയെ ഞാൻ നിനക്കും നിന്റെ പുത്രന്മാർക്കും പുത്രിമാർക്കും ശാശ്വതാവകാശമായി തന്നിരിക്കുന്നു; നിന്റെ വീട്ടിൽ ശുദ്ധിയുള്ളവന്നെല്ലാം അതു ഭക്ഷിക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","എണ്ണയിൽ വിശേഷമായതൊക്കെയും പുതുവീഞ്ഞിലും ധാന്യത്തിലും വിശേഷമായതൊക്കെയും ഇങ്ങനെ അവർ യഹോവെക്കു അർപ്പിക്കുന്ന ആദ്യഫലമൊക്കെയും ഞാൻ നിനക്കു തന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","അവർ തങ്ങളുടെ ദേശത്തുള്ള എല്ലാറ്റിലും യഹോവെക്കു കൊണ്ടുവരുന്ന ആദ്യഫലങ്ങൾ നിനക്കു ആയിരിക്കേണം; നിന്റെ വീട്ടിൽ ശുദ്ധിയുള്ളവന്നെല്ലാം അതു ഭക്ഷിക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","യിസ്രായേലിൽ ശപഥാർപ്പിതമായതു ഒക്കെയും നിനക്കു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","മനുഷ്യരിൽ ആകട്ടെ മൃഗങ്ങളിൽ ആകട്ടെ സകലജഡത്തിലും അവർ യഹോവെക്കു കൊണ്ടുവരുന്ന കടിഞ്ഞൂൽ ഒക്കെയും നിനക്കു ഇരിക്കേണം; മനുഷ്യന്റെ കടിഞ്ഞൂലിനെയോ വീണ്ടെടുക്കേണം; അശുദ്ധമൃഗങ്ങളുടെ കടിഞ്ഞൂലിനെയും വീണ്ടെടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","വീണ്ടെടുപ്പുവിലയോ: ഒരു മാസംമുതൽ മേലോട്ടു പ്രായമുള്ളതിനെ നിന്റെ മതിപ്പുപ്രകാരം അഞ്ചു ശേക്കെൽ ദ്രവ്യംകൊടുത്തു വീണ്ടെടുക്കേണം. ശേക്കെൽ ഒന്നിന്നു ഇരുപതു ഗേരപ്രകാരം വിശുദ്ധമന്ദിരത്തിലെ തൂക്കം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","എന്നാൽ പശു, ആടു, കോലാടു എന്നിവയുടെ കടിഞ്ഞൂലിനെ വീണ്ടെടുക്കരുതു; അവ വിശുദ്ധമാകുന്നു; അവയുടെ രക്തം യാഗപീഠത്തിന്മേൽ തളിച്ചു മേദസ്സു യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗമായി ദഹിപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","നീരാജനം ചെയ്ത നെഞ്ചും വലത്തെ കൈക്കുറകും നിനക്കുള്ളതായിരിക്കുന്നതുപോലെ തന്നേ അവയുടെ മാംസവും നിനക്കു ഇരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","യിസ്രായേൽമക്കൾ യഹോവെക്കു അർപ്പിക്കുന്ന വിശുദ്ധവസ്തുക്കളിൽ ഉദർച്ചാർപ്പണങ്ങളെല്ലാം ഞാൻ നിനക്കും നിന്റെ പുത്രന്മാർക്കും പുത്രിമാർക്കും ശാശ്വതാവകാശമായി തന്നിരിക്കുന്നു; യഹോവയുടെ സന്നിധിയിൽ നിനക്കും നിന്റെ സന്തതിക്കും ഇതു എന്നേക്കും ഒരു ലവണനിയമം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","യഹോവ പിന്നെയും അഹരോനോടു: നിനക്കു അവരുടെ ഭൂമിയിൽ ഒരു അവകാശവും ഉണ്ടാകരുതു; അവരുടെ ഇടയിൽ നിനക്കു ഒരു ഓഹരിയും അരുതു; യിസ്രായേൽമക്കളുടെ ഇടയിൽ ഞാൻ തന്നേ നിന്റെ ഓഹരിയും അവകാശവും ആകുന്നു എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ലേവ്യർക്കോ ഞാൻ സാമഗമനകൂടാരം സംബന്ധിച്ചു അവർ ചെയ്യുന്ന വേലെക്കു യിസ്രായേലിൽ ഉള്ള ദശാംശം എല്ലാം അവകാശമായി കൊടുത്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","യിസ്രായേൽമക്കൾ പാപം വഹിച്ചു മരിക്കാതിരിക്കേണ്ടതിന്നു മേലാൽ സമാഗമനകൂടാരത്തോടു അടുക്കരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ലേവ്യർ സമാഗമനകൂടാരം സംബന്ധിച്ചുള്ള വേല ചെയ്കയും അവരുടെ അകൃത്യം വഹിക്കയും വേണം; അതു തലമുറതലമുറയായി എന്നേക്കുമുള്ള ചട്ടമായിരിക്കേണം; അവർക്കു യിസ്രായേൽമക്കളുടെ ഇടയിൽ അവകാശം ഉണ്ടാകരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","യിസ്രായേൽമക്കൾ യഹോവെക്കു ഉദർച്ചാർപ്പണമായി അർപ്പിക്കുന്ന ദശാംശം ഞാൻ ലേവ്യർക്കു അവകാശമായി കൊടുത്തിരിക്കുന്നു; അതുകൊണ്ടു അവർക്കു യിസ്രായേൽമക്കളുടെ ഇടയിൽ അവകാശം അരുതു എന്നു ഞാൻ അവരോടു കല്പിച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","നീ ലേവ്യരോടു പറയേണ്ടതു എന്തെന്നാൽ: യിസ്രായേൽമക്കളുടെ പക്കൽനിന്നു ഞാൻ നിങ്ങളുടെ അവകാശമായി നിങ്ങൾക്കു തന്നിരിക്കുന്ന ദശാംശം അവരോടു വാങ്ങുമ്പോൾ ദശാംശത്തിന്റെ പത്തിലൊന്നു നിങ്ങൾ യഹോവെക്കു ഉദർച്ചാർപ്പണമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","നിങ്ങളുടെ ഈ ഉദർച്ചാർപ്പണം കളത്തിലെ ധാന്യംപോലെയും മുന്തിരിച്ചക്കിലെ നിറവുപോലെയും നിങ്ങളുടെ പേർക്കു എണ്ണും. ");
INSERT INTO mal2015_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ഇങ്ങനെ യിസ്രായേൽ മക്കളോടു നിങ്ങൾ വാങ്ങുന്ന സകലദശാംശത്തില്നിന്നും യഹോവെക്കു ഒരു ഉദർച്ചാർപ്പണം അർപ്പിക്കേണം; യഹോവെക്കുള്ള ആ ഉദർച്ചാർപ്പണം നിങ്ങൾ പുരോഹിതനായ അഹരോന്നു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","നിങ്ങൾക്കുള്ള സകലദാനങ്ങളിലും ഉത്തമമായ എല്ലാറ്റിന്റെയും വിശുദ്ധഭാഗം നിങ്ങൾ യഹോവെക്കു ഉദർച്ചാർപ്പണമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ആകയാൽ നീ അവരോടു പറയേണ്ടതെന്തെന്നാൽ: നിങ്ങൾ അതിന്റെ ഉത്തമഭാഗം ഉദർച്ചാർപ്പണമായി അർപ്പിക്കുമ്പോൾ അതു കളത്തിലെ അനുഭവംപോലെയും മുന്തിരിച്ചക്കിലെ അനുഭവംപോലെയും ലേവ്യർക്കു എണ്ണും. ");
INSERT INTO mal2015_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","അതു നിങ്ങൾക്കും നിങ്ങളുടെ കുടുംബങ്ങൾക്കും എല്ലാടത്തുവെച്ചും ഭക്ഷിക്കാം; അതു സമാഗമനകൂടാരത്തിങ്കൽ നിങ്ങൾ ചെയ്യുന്ന വേലെക്കുള്ള ശമ്പളം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","അതിന്റെ ഉത്തമഭാഗം ഉദർച്ചചെയ്താൽ പിന്നെ നിങ്ങൾ അതുനിമിത്തം പാപം വഹിക്കയില്ല; നിങ്ങൾ യിസ്രായേൽമക്കളുടെ വിശുദ്ധവസ്തുക്കൾ അശുദ്ധമാക്കുകയും അതിനാൽ മരിച്ചു പോവാൻ ഇടവരികയുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","യഹോവ പിന്നെയും മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","യഹോവ കല്പിച്ച ന്യായപ്രമാണമെന്തെന്നാൽ: കളങ്കവും ഊനവുമില്ലാത്തതും നുകം വെക്കാത്തതുമായ ഒരു ചുവന്ന പശുക്കിടാവിനെ നിന്റെ അടുക്കൽ കൊണ്ടുവരുവാൻ യിസ്രായേൽമക്കളോടു പറക. ");
INSERT INTO mal2015_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","നിങ്ങൾ അതിനെ പുരോഹിതനായ എലെയാസാരിന്റെ പക്കൽ ഏല്പിക്കേണം; അവൻ അതിനെ പാളയത്തിന്നു പുറത്തുകൊണ്ടുപോകയും ഒരുവൻ അതിനെ അവന്റെ മുമ്പിൽവെച്ചു അറുക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","പുരോഹിതനായ എലെയാസാർ വിരല്കൊണ്ടു അതിന്റെ രക്തം കുറെ എടുത്തു സമാഗമനകൂടാരത്തിന്റെ മുൻഭാഗത്തിന്നു നേരെ ഏഴു പ്രാവശ്യം തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","അതിന്റെ ശേഷം പശുക്കിടാവിനെ അവൻ കാൺകെ ചുട്ടു ഭസ്മീകരിക്കേണം; അതിന്റെ തോലും മാംസവും രക്തവും ചാണകവും കൂടെ ചുടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","പിന്നെ പുരോഹിതൻ ദേവദാരു, ഈസോപ്പു, ചുവപ്പുനൂൽ എന്നിവ എടുത്തു പശുക്കിടാവിനെ ചുടുന്ന തീയുടെ നടുവിൽ ഇടേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","അനന്തരം പുരോഹിതൻ വസ്ത്രം അലക്കി ദേഹം വെള്ളത്തിൽ കഴുകിയശേഷം പാളയത്തിലേക്കു വരികയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","അതിനെ ചുട്ടവനും വസ്ത്രം അലക്കി ദേഹം വെള്ളത്തിൽ കഴുകുകയും സന്ധ്യവരെ അശുദ്ധനായിരിക്കയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","പിന്നെ ശുദ്ധിയുള്ള ഒരുത്തൻ പശുക്കിടാവിന്റെ ഭസ്മം വാരി പാളയത്തിന്നു പുറത്തു വെടിപ്പുള്ള ഒരു സ്ഥലത്തു വെക്കേണം; അതു യിസ്രായേൽമക്കളുടെ സഭെക്കുവേണ്ടി ശുദ്ധീകരണജലത്തിന്നായി സൂക്ഷിച്ചുവെക്കേണം; അതു ഒരു പാപയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","പശുക്കിടാവിന്റെ ഭസ്മം വാരിയവനും വസ്ത്രം അലക്കി സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം; യിസ്രായേൽമക്കൾക്കും അവരുടെ ഇടയിൽ വന്നു പാർക്കുന്ന പരദേശിക്കും ഇതു എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","യാതൊരു മനുഷ്യന്റെയും ശവം തൊടുന്നവൻ ഏഴു ദിവസം അശുദ്ധൻ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","അവൻ മൂന്നാം ദിവസവും ഏഴാം ദിവസവും ആ വെള്ളംകൊണ്ടു തന്നെത്താൻ ശുദ്ധീകരിക്കേണം; അങ്ങനെ അവൻ ശുദ്ധിയുള്ളവനാകും; എന്നാൽ മൂന്നാം ദിവസം തന്നെ ശുദ്ധീകരിക്കാഞ്ഞാൽ ഏഴാം ദിവസം അവൻ ശുദ്ധിയുള്ളവനാകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","മരിച്ചുപോയ ഒരു മനുഷ്യന്റെ ശവം ആരെങ്കിലും തൊട്ടിട്ടു തന്നെത്താൻ ശുദ്ധീകരിക്കാഞ്ഞാൽ അവൻ യഹോവയുടെ തിരുനിവാസത്തെ അശുദ്ധമാക്കുന്നു; അവനെ യിസ്രായേലിൽ നിന്നു ഛേദിച്ചുകളയേണം; ശുദ്ധീകരണജലംകൊണ്ടു അവനെ തളിച്ചില്ല; അവൻ അശുദ്ധൻ. അവന്റെ അശുദ്ധി അവന്റെമേൽ നില്ക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","കൂടാരത്തിൽവെച്ചു ഒരുത്തൻ മരിച്ചാലുള്ള ന്യായപ്രമാണം ആവിതു: ആ കൂടാരത്തിൽ കടക്കുന്ന ഏവനും കൂടാരത്തിൽ ഇരിക്കുന്ന ഏവനും ഏഴു ദിവസം അശുദ്ധൻ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","മൂടിക്കെട്ടാതെ തുറന്നിരിക്കുന്ന പാത്രമെല്ലാം അശുദ്ധമാകും. ");
INSERT INTO mal2015_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","വെളിയിൽവെച്ചു വാളാൽ കൊല്ലപ്പെട്ട ഒരുത്തനെയോ മരിച്ചുപോയ ഒരുത്തനെയോ മനുഷ്യന്റെ അസ്ഥിയെയോ ഒരു ശവക്കുഴിയെയോ തൊടുന്നവൻ എല്ലാം ഏഴു ദിവസം അശുദ്ധനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","അശുദ്ധനായിത്തീരുന്നവന്നുവേണ്ടി പാപയാഗം ചുട്ട ഭസ്മം എടുത്തു ഒരു പാത്രത്തിൽ ഇട്ടു അതിൽ ഉറവു വെള്ളം ഒഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","പിന്നെ ശുദ്ധിയുള്ള ഒരുത്തൻ ഈസോപ്പു എടുത്തു വെള്ളത്തിൽ മുക്കി കൂടാരത്തെയും സകലപാത്രങ്ങളെയും അവിടെ ഉണ്ടായിരുന്ന ആളുകളെയും അസ്ഥിയെയോ കൊല്ലപ്പെട്ട ഒരുത്തനെയോ മരിച്ചുപോയ ഒരുത്തനെയോ ഒരു ശവക്കുഴിയെയോ തൊട്ടവനെയും തളിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ശുദ്ധിയുള്ളവൻ അശുദ്ധനായ്തീർന്നവനെ മൂന്നാം ദിവസവും ഏഴാം ദിവസവും തളിക്കേണം; ഏഴാം ദിവസം അവൻ തന്നെ ശുദ്ധീകരിച്ചു വസ്ത്രം അലക്കി വെള്ളത്തിൽ തന്നെത്താൻ കഴുകേണം; സന്ധ്യക്കു അവൻ ശുദ്ധിയുള്ളവനാകും. ");
INSERT INTO mal2015_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","എന്നാൽ ആരെങ്കിലും അശുദ്ധനായ്തീർന്നിട്ടു തന്നെത്താൻ ശുദ്ധീകരിക്കാഞ്ഞാൽ അവനെ സഭയിൽ നിന്നു ഛേദിച്ചുകളയേണം; അവൻ യഹോവയുടെ വിശുദ്ധമന്ദിരം അശുദ്ധമാക്കി; ശുദ്ധീകരണജലംകൊണ്ടു അവനെ തളിച്ചില്ല; അവൻ അശുദ്ധൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ഇതു അവർക്കു എന്നേക്കുമുള്ള ചട്ടം ആയിരിക്കേണം; ശുദ്ധീകരണ ജലം തളിക്കുന്നവൻ വസ്ത്രം അലക്കേണം; ശുദ്ധീകരണ ജലം തൊടുന്നവനും സന്ധ്യവരെ അശുദ്ധൻ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","അശുദ്ധൻ തൊടുന്നതു എല്ലാം അശുദ്ധമാകും; അതു തൊടുന്നവനും സന്ധ്യവരെ അശുദ്ധനായിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","അനന്തരം യിസ്രായേൽമക്കളുടെ സർവ്വസഭയും ഒന്നാം മാസം സീൻമരുഭൂമിയിൽ എത്തി, ജനം കാദേശിൽ പാർത്തു; അവിടെവെച്ചു മിര്യാം മരിച്ചു; അവിടെ അവളെ അടക്കം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ജനത്തിന്നു കുടിപ്പാൻ വെള്ളം ഉണ്ടായിരുന്നില്ല; അപ്പോൾ അവർ മോശെക്കും അഹരോന്നും വിരോധമായി കൂട്ടം കൂടി. ");
INSERT INTO mal2015_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ജനം മോശെയോടു കലഹിച്ചു: ഞങ്ങളുടെ സഹോദരന്മാർ യഹോവയുടെ സന്നിധിയിൽ മരിച്ചപ്പോൾ ഞങ്ങളും മരിച്ചുപോയിരുന്നുവെങ്കിൽ കൊള്ളായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ഞങ്ങളും ഞങ്ങളുടെ മൃഗങ്ങളും ഇവിടെ കിടന്നു ചാകേണ്ടതിന്നു നിങ്ങൾ യഹോവയുടെ സഭയെ ഈ മരുഭൂമിയിൽ കൊണ്ടുവന്നതു എന്തു? ");
INSERT INTO mal2015_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ഈ വല്ലാത്ത സ്ഥലത്തു ഞങ്ങളെ കൊണ്ടുവരുവാൻ നിങ്ങൾ മിസ്രയീമിൽനിന്നു ഞങ്ങളെ പുറപ്പെടുവിച്ചതു എന്തിന്നു? ഇവിടെ വിത്തും അത്തിപ്പഴവും മുന്തിരിപ്പഴവും മാതളപ്പഴവും ഇല്ല; കുടിപ്പാൻ വെള്ളവുമില്ല എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","എന്നാറെ മോശെയും അഹരോനും സഭയുടെ മുമ്പില്നിന്നു സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ ചെന്നു കവിണ്ണുവീണു; യഹോവയുടെ തേജസ്സു അവർക്കു പ്രത്യക്ഷമായി. ");
INSERT INTO mal2015_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","യഹോവ മോശെയോടു: നിന്റെ വടി എടുത്തു നീയും സഹോദരനായ അഹരോനും സഭയെ വിളിച്ചുകൂട്ടി അവർ കാൺകെ പാറയോടു കല്പിക്ക. ");
INSERT INTO mal2015_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","എന്നാൽ അതു വെള്ളംതരും; പാറയിൽ നിന്നു അവർക്കു വെള്ളം പുറപ്പെടുവിച്ചു ജനത്തിന്നും അവരുടെ കന്നുകാലികൾക്കും കുടിപ്പാൻ കൊടുക്കേണം എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","തന്നോടു കല്പിച്ചതുപോലെ മോശെ യഹോവയുടെ സന്നിധിയിൽനിന്നു വടി എടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","മോശെയും അഹരോനും പാറയുടെ അടുക്കൽ സഭയെ വിളിച്ചുകൂട്ടി അവരോടു: മത്സരികളേ, കേൾപ്പിൻ; ഈ പാറയിൽനിന്നു ഞങ്ങൾ നിങ്ങൾക്കുവേണ്ടി വെള്ളം പുറപ്പെടുവിക്കുമോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","മോശെ കൈ ഉയർത്തി വടികൊണ്ടു പാറയെ രണ്ടു പ്രാവശ്യം അടിച്ചു; വളരെ വെള്ളം പുറപ്പെട്ടു; ജനവും അവരുടെ കന്നുകാലികളും കുടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","പിന്നെ യഹോവ മോശെയോടും അഹരോനോടും: നിങ്ങൾ യിസ്രായേൽമക്കൾ കാണ്കെ എന്നെ ശുദ്ധീകരിപ്പാൻ തക്കവണ്ണം എന്നെ വിശ്വസിക്കാതിരുന്നതുകൊണ്ടു നിങ്ങൾ ഈ സഭയെ ഞാൻ അവർക്കു കൊടുത്തിരിക്കുന്ന ദേശത്തേക്കു കൊണ്ടുപോകയില്ല എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ഇതു യിസ്രായേൽമക്കൾ യഹോവയോടു കലഹിച്ചതും അവർ അവരിൽ ശുദ്ധീകരിക്കപ്പെട്ടതുമായ കലഹജലം. ");
INSERT INTO mal2015_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","അനന്തരം മോശെ കാദേശിൽനിന്നു എദോംരാജാവിന്റെ അടുക്കൽ ദൂതന്മാരെ അയച്ചു പറയിച്ചതു: “നിന്റെ സഹോദരനായ യിസ്രായേൽ ഇപ്രകാരം പറയുന്നു: ");
INSERT INTO mal2015_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ഞങ്ങൾക്കുണ്ടായ കഷ്ടതയൊക്കെയും നീ അറിഞ്ഞിരിക്കുന്നുവല്ലോ; ഞങ്ങളുടെ പിതാക്കന്മാർ മിസ്രയീമിൽ പോയി ഏറിയ കാലം പാർത്തു: മിസ്രയീമ്യർ ഞങ്ങളെയും ഞങ്ങളുടെ പിതാക്കന്മാരെയും പീഡിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ഞങ്ങൾ യഹോവയോടു നിലവിളിച്ചപ്പോൾ അവൻ ഞങ്ങളുടെ നിലവിളി കേട്ടു ഒരു ദൂതനെ അയച്ചു ഞങ്ങളെ മിസ്രയീമിൽനിന്നു പുറപ്പെടുവിച്ചു; ഞങ്ങൾ നിന്റെ അതിരിങ്കലുള്ള പട്ടണമായ കാദേശിൽ എത്തിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ഞങ്ങൾ നിന്റെ ദേശത്തുകൂടി കടന്നുപോകുവാൻ അനുവദിക്കേണമേ. ഞങ്ങൾ വയലിലോ മുന്തിരിത്തോട്ടത്തിലോ കയറുകയില്ല; കിണറ്റിലെ വെള്ളം കുടിക്കയുമില്ല. ഞങ്ങൾ രാജപാതയില്കൂടി തന്നേ നടക്കും; ");
INSERT INTO mal2015_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","നിന്റെ അതിർ കഴിയുംവരെ ഇടത്തോട്ടോ വലത്തോട്ടോ തിരികയുമില്ല.” എദോം അവനോടു: “നീ എന്റെ നാട്ടിൽകൂടി കടക്കരുതു: കടന്നാൽ ഞാൻ വാളുമായി നിന്റെ നേരെ പുറപ്പെടും” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","അതിന്നു യിസ്രായേൽമക്കൾ അവനോടു: “ഞങ്ങൾ പെരുവഴിയിൽ കൂടി പൊയ്ക്കൊള്ളാം; ഞാനും എന്റെ കന്നുകാലിയും നിന്റെ വെള്ളം കുടിച്ചുപോയാൽ അതിന്റെ വിലതരാം; കാൽനടയായി കടന്നു പോകേണമെന്നല്ലാതെ മറ്റൊന്നും എനിക്കു വേണ്ടാ” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","അതിന്നു അവൻ “നീ കടന്നുപോകരുതു” എന്നു പറഞ്ഞു. എദോം ബഹുസൈന്യത്തോടും ബലമുള്ള കയ്യോടും കൂടെ അവന്റെ നേരെ പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ഇങ്ങനെ എദോം തന്റെ അതിരിൽകൂടി കടന്നുപോകുവാൻ യിസ്രായേലിനെ സമ്മതിച്ചില്ല. യിസ്രായേൽ അവനെ വിട്ടു ഒഴിഞ്ഞുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","പിന്നെ യിസ്രായേൽമക്കളുടെ സർവ്വസഭയും കാദേശിൽനിന്നു യാത്ര പുറപ്പെട്ടു ഹോർപർവ്വതത്തിൽ എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","എദോംദേശത്തിന്റെ അതിരിങ്കലുള്ള ഹോർപർവ്വതത്തിൽവെച്ചു യഹോവ മോശെയോടും അഹരോനോടും അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","അഹരോൻ തന്റെ ജനത്തോടു ചേരും; കലഹജലത്തിങ്കൽ നിങ്ങൾ എന്റെ കല്പന മറുത്തതുകൊണ്ടു ഞാൻ യിസ്രായേൽമക്കൾക്കു കൊടുത്തിരിക്കുന്ന ദേശത്തേക്കു അവൻ കടക്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","അഹരോനെയും അവന്റെ മകനായ എലെയാസാരിനെയും കൂട്ടി അവരെ ഹോർപർവ്വതത്തിൽ കൊണ്ടു ചെന്നു ");
INSERT INTO mal2015_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","അഹരോന്റെ വസ്ത്രം ഊരി അവന്റെ മകനായ എലെയാസാരിനെ ധരിപ്പിക്കേണം; അഹരോൻ അവിടെവെച്ചു മരിച്ചു തന്റെ ജനത്തോടു ചേരും. ");
INSERT INTO mal2015_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","യഹോവ കല്പിച്ചതുപോലെ മോശെ ചെയ്തു; സർവ്വസഭയും കാൺകെ അവർ ഹോർപർവ്വത്തിൽ കയറി. ");
INSERT INTO mal2015_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","മോശെ അഹരോന്റെ വസ്ത്രം ഊരി അവന്റെ മകനായ എലെയാസാരിനെ ധരിപ്പിച്ചു; അഹരോൻ അവിടെ പർവ്വതത്തിന്റെ മുകളിൽവെച്ചു മരിച്ചു; മോശെയും എലെയാസാരും പർവ്വതത്തിൽനിന്നു ഇറങ്ങിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","അഹരോൻ മരിച്ചുപോയി എന്നു സഭയെല്ലാം അറിഞ്ഞപ്പോൾ യിസ്രായേൽഗൃഹം ഒക്കെയും അഹരോനെക്കുറിച്ചു മുപ്പതു ദിവസം വിലാപിച്ചുകൊണ്ടിരുന്നു ");
INSERT INTO mal2015_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","യിസ്രായേൽ അഥാരീംവഴിയായി വരുന്നു എന്നു തെക്കെ ദേശത്തു വസിച്ചിരുന്ന കനാന്യനായ അരാദ്‌രാജാവു കേട്ടപ്പോൾ അവൻ യിസ്രായേലിനോടു യുദ്ധം തുടങ്ങി ചിലരെ പിടിച്ചു കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","അപ്പോൾ യിസ്രായേൽ യഹോവെക്കു ഒരു നേർച്ച നേർന്നു; ഈ ജനത്തെ നീ എന്റെ കയ്യിൽ ഏല്പിച്ചാൽ ഞാൻ അവരുടെ പട്ടണങ്ങൾ ശപഥാർപ്പിതമായി നശിപ്പിക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","യഹോവ യിസ്രായേലിന്റെ അപേക്ഷ കേട്ടു കനാന്യരെ ഏല്പിച്ചുകൊടുത്തു; അവർ അവരെയും അവരുടെ പട്ടണങ്ങളെയും ശപഥാർപ്പിതമായി നശിപ്പിച്ചു; ആ സ്ഥലത്തിന്നു ഹോർമ്മാ എന്നു പേരായി. ");
INSERT INTO mal2015_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","പിന്നെ അവർ എദോംദേശത്തെ ചുറ്റിപ്പോകുവാൻ ഹോർപർവ്വതത്തിങ്കല്നിന്നു ചെങ്കടൽവഴിയായി യാത്രപുറപ്പെട്ടു; വഴിനിമിത്തം ജനത്തിന്റെ മനസ്സു ക്ഷീണിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ജനം ദൈവത്തിന്നും മോശെക്കും വിരോധമായി സംസാരിച്ചു: മരുഭൂമിയിൽ മരിക്കേണ്ടതിന്നു നിങ്ങൾ ഞങ്ങളെ മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്നതു എന്തിന്നു? ഇവിടെ അപ്പവുമില്ല, വെള്ളവുമില്ല; ഈ സാരമില്ലാത്ത ആഹാരം ഞങ്ങൾക്കു വെറുപ്പാകുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","അപ്പോൾ യഹോവ ജനത്തിന്റെ ഇടയിൽ അഗ്നിസർപ്പങ്ങളെ അയച്ചു; അവ ജനത്തെ കടിച്ചു; യിസ്രായേലിൽ വളരെ ജനം മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ആകയാൽ ജനം മോശെയുടെ അടുക്കൽ വന്നു; ഞങ്ങൾ യഹോവെക്കും നിനക്കും വിരോധമായി സംസാരിച്ചതിനാൽ പാപം ചെയ്തിരിക്കുന്നു. സർപ്പങ്ങളെ ഞങ്ങളുടെ ഇടയിൽനിന്നു നീക്കിക്കളവാൻ യഹോവയോടു പ്രാർത്ഥിക്കേണം എന്നു പറഞ്ഞു; മോശെ ജനത്തിന്നുവേണ്ടി പ്രാർത്ഥിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","യഹോവ മോശെയോടു: ഒരു അഗ്നിസർപ്പത്തെ ഉണ്ടാക്കി കൊടിമരത്തിന്മേൽ തൂക്കുക; കടിയേല്ക്കുന്നവൻ ആരെങ്കിലും അതിനെ നോക്കിയാൽ ജീവിക്കും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","അങ്ങനെ മോശെ താമ്രംകൊണ്ടു ഒരു സർപ്പത്തെ ഉണ്ടാക്കി കൊടിമരത്തിന്മേൽ തൂക്കി; പിന്നെ സർപ്പം ആരെയെങ്കിലും കടിച്ചിട്ടു അവൻ താമ്രസർപ്പത്തെ നോക്കിയാൽ ജീവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","അനന്തരം യിസ്രായേൽമക്കൾ പുറപ്പെട്ടു ഓബോത്തിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ഓബോത്തിൽനിന്നു യാത്ര പുറപ്പെട്ടു സൂര്യോദയത്തിന്നു നേരെ മോവാബിന്റെ കിഴക്കുള്ള മരുഭൂമിയിൽ ഇയ്യെ-അബാരീമിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","അവിടെനിന്നു പുറപ്പെട്ടു സാരേദ് താഴ്‌വരയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","അവിടെനിന്നു പുറപ്പെട്ടു അമോര്യരുടെ ദേശത്തുനിന്നു ഉത്ഭവിച്ചു മരുഭൂമിയിൽകൂടി ഒഴുകുന്ന അർന്നോൻതോട്ടിന്നക്കരെ പാളയമിറങ്ങി; അർന്നോൻ മോവാബിന്നും അമോര്യർക്കും മദ്ധ്യേ മോവാബിന്നുള്ള അതിർ ആകുന്നു. അതുകൊണ്ടു: ");
INSERT INTO mal2015_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","“സൂഫയിലെ വാഹേബും അർന്നോൻ താഴ്‌വരകളും ആരിന്റെ നിവാസത്തോളം നീണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","മോവാബിന്റെ അതിരോടു ചാഞ്ഞിരിക്കുന്ന താഴ്‌വരച്ചരിവു” എന്നിങ്ങനെ യഹോവയുടെ യുദ്ധപുസ്തകത്തിൽ പറഞ്ഞിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","അവിടെനിന്നു അവർ ബേരിലേക്കു പോയി; യഹോവ മോശെയോടു: ജനത്തെ ഒന്നിച്ചുകൂട്ടുക: ഞാൻ അവർക്കു വെള്ളം കൊടുക്കുമെന്നു കല്പിച്ച കിണർ അതു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ആ സമയത്തു യിസ്രായേൽ: “കിണറേ, പൊങ്ങിവാ; അതിന്നു പാടുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","പ്രഭുക്കന്മാർ കുഴിച്ച കിണർ; ജനശ്രേഷ്ഠന്മാർ ചെങ്കോൽകൊണ്ടും തങ്ങളുടെ ദണ്ഡുകൾകൊണ്ടും കുത്തിയ കിണർ” എന്നുള്ള പാട്ടു പാടി. ");
INSERT INTO mal2015_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","പിന്നെ അവർ മരുഭൂമിയിൽനിന്നു മത്ഥാനെക്കും മത്ഥാനയിൽനിന്നു നഹലീയേലിന്നും നഹലീയേലിൽനിന്നു ");
INSERT INTO mal2015_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ബാമോത്തിന്നും ബാമോത്തിൽനിന്നു മോവാബിന്റെ പ്രദേശത്തുള്ള താഴ്‌വരയിലേക്കും മരുഭൂമിക്കെതിരെയുള്ള പിസ്ഗമുകളിലേക്കും യാത്ര ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","അവിടെനിന്നു യിസ്രായേൽ അമോര്യരുടെ രാജാവായ സീഹോന്റെ അടുക്കൽ ദൂതന്മാരെ അയച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ഞാൻ നിന്റെ ദേശത്തുകൂടി കടന്നുപോകുവാൻ അനുവദിക്കേണമേ; ഞങ്ങൾ വയലിലെങ്കിലും മുന്തിരിത്തോട്ടത്തിലെങ്കിലും കയറുകയില്ല, കിണറ്റിലെ വെള്ളം കുടിക്കയുമില്ല; ഞങ്ങൾ നിന്റെ അതിർ കഴിയുംവരെ രാജപാതയിൽകൂടി തന്നേ പൊയ്ക്കൊള്ളാം.” എന്നു പറയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","എന്നാൽ സീഹോൻ തന്റെ ദേശത്തുകൂടി യിസ്രായേൽ കടന്നുപോവാൻ സമ്മതിക്കാതെ തന്റെ ജനത്തെയെല്ലാം ഒന്നിച്ചുകൂട്ടി യിസ്രായേലിന്റെ നേരെ മരുഭൂമിയിലേക്കു പുറപ്പെട്ടു; അവൻ യാഹാസിൽ വന്നു യിസ്രായേലിനോടു യുദ്ധം ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","യിസ്രായേൽ അവനെ വാളിന്റെ വായ്ത്തലകൊണ്ടു വെട്ടി, അർന്നോൻ മുതൽ യബ്ബോക്ക്‌വരെയും അമ്മോന്യരുടെ അതിർവരെയും ഉള്ള അവന്റെ ദേശത്തെ കൈവശമാക്കി; അമ്മോന്യരുടെ അതിരോ ഉറപ്പുള്ളതു ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ഈ പട്ടണങ്ങൾ എല്ലാം യിസ്രായേൽ പിടിച്ചു; അങ്ങനെ യിസ്രായേൽ അമോര്യരുടെ എല്ലാ പട്ടണങ്ങളിലും കുടിപാർത്തു; ഹെശ്ബോനിലും അതിന്റെ സകല ഗ്രാമങ്ങളിലും തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ഹെശ്ബോൻ അമോര്യരുടെ രാജാവായ സീഹോന്റെ നഗരം ആയിരുന്നു; അവൻ മുമ്പിലത്തെ മോവാബ് രാജാവിനോടു പടയെടുത്തു അർന്നോൻ വരെ ഉള്ള അവന്റെ ദേശമൊക്കെയും അവന്റെ കയ്യിൽനിന്നു പിടിച്ചിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","അതുകൊണ്ടു കവിവരന്മാർ പറയുന്നതു: “ഹെശ്ബോനിൽ വരുവിൻ; സീഹോന്റെ നഗരം പണിതുറപ്പിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ഹെശ്ബോനിൽനിന്നു തീയും സീഹോന്റെ നഗരത്തിൽനിന്നു ജ്വാലയും പുറപ്പെട്ടു, മോവാബിലെ ആരിനെയും അർന്നോൻ തീരത്തെ ഗിരിനിവാസികളെയും ദഹിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","മോവാബേ, നിനക്കു ഹാ കഷ്ടം! കെമോശിന്റെ ജനമേ, നീ മുടിഞ്ഞിരിക്കുന്നു. അവൻ തന്റെ പുത്രന്മാരെ പലായനത്തിന്നും പുത്രിമാരെ അമോര്യരാജാവായ സീഹോന്നു അടിമയായും കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ഞങ്ങൾ അവരെ അമ്പെയ്തു; ദീബോൻവരെ ഹെശ്ബോൻ നശിച്ചു; മെദബവരെയുള്ള നോഫയോളം അവരെ ശൂന്യമാക്കി.” ");
INSERT INTO mal2015_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ഇങ്ങനെ യിസ്രായേൽ അമോര്യരുടെ ദേശത്തു കുടിപാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","അനന്തരം മോശെ യസേരിനെ ഒറ്റുനോക്കുവാൻ ആളയച്ചു; അവർ അതിന്റെ ഗ്രാമങ്ങളെ പിടിച്ചു അവിടെയുള്ള അമോര്യരെ ഓടിച്ചുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","പിന്നെ അവർ തിരിഞ്ഞു ബാശാൻ വഴിയായി പോയി; ബാശാൻ രാജാവായ ഓഗ് തന്റെ സകലജനവുമായി അവരുടെനേരെപുറപ്പെട്ടു എദ്രെയിൽ വെച്ചു പടയേറ്റു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","അപ്പോൾ യഹോവ മോശെയോടു: അവനെ ഭയപ്പെടേണ്ടാ; അവനെയും അവന്റെ സകലജനത്തെയും അവന്റെ ദേശത്തെയും ഞാൻ നിന്റെ കയ്യിൽ ഏല്പിച്ചിരിക്കുന്നു; നീ ഹെശ്ബോനിൽ പാർത്ത അമോര്യരാജാവായ സീഹോനോടു ചെയ്തതുപോലെ അവനോടും ചെയ്യും എന്നു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","അങ്ങനെ അവർ അവനെയും അവന്റെ പുത്രന്മാരെയും അവന്റെ സകലജനത്തെയും ഒട്ടൊഴിയാതെ സംഹരിച്ചു, അവന്റെ ദേശത്തെ കൈവശമാക്കുകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","യിസ്രായേൽമക്കൾ യാത്ര പുറപ്പെട്ടു യെരീഹോവിന്റെ സമീപത്തു യോർദ്ദാന്നക്കരെ മോവാബ് സമഭൂമിയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","യിസ്രായേൽ അമോര്യരോടു ചെയ്തതൊക്കെയും സിപ്പോരിന്റെ മകനായ ബാലാക്ക് അറിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ജനം വളരെയായിരുന്നതുകൊണ്ടു മോവാബ് ഏറ്റവും ഭയപ്പെട്ടു; യിസ്രായേൽമക്കളെക്കുറിച്ചു മോവാബ് പരിഭ്രമിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","മോവാബ് മിദ്യാന്യമൂപ്പന്മാരോടു: കാള വയലിലെ പുല്ലു നക്കിക്കളയുന്നതുപോലെ ഈ കൂട്ടം നമ്മുടെ ചുറ്റുമുള്ള എല്ലാവരെയും നക്കിക്കളയും എന്നു പറഞ്ഞു. അക്കാലത്തു മോവാബ്‌രാജാവു സിപ്പോരിന്റെ മകനായ ബാലാക്ക് ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","അവൻ ബെയോരിന്റെ മകനായ ബിലെയാമിനെ വിളിപ്പാൻ അവന്റെ സ്വജാതിക്കാരുടെ ദേശത്തു നദീതീരത്തുള്ള പെഥോരിലേക്കു ദൂതന്മാരെ അയച്ചു: “ഒരു ജനം മിസ്രയീമിൽനിന്നു പുറപ്പെട്ടുവന്നു ഭൂതലത്തെ മൂടിയിരിക്കുന്നു; അവർ എനിക്കെതിരെ പാർക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","നീ വന്നു എനിക്കുവേണ്ടി ഈ ജനത്തെ ശപിക്കേണമേ; അവർ എന്നെക്കാൾ ഏറ്റവും ബലവാന്മാർ ആയിരിക്കകൊണ്ടു പക്ഷേ അവരെ തോല്പിച്ചു ദേശത്തുനിന്നു ഓടിച്ചുകളവാൻ എനിക്കു കഴിവുണ്ടാകുമായിരിക്കും; നീ അനുഗ്രഹിക്കുന്നവൻ അനുഗ്രഹിക്കപ്പെട്ടവൻ, നീ ശപിക്കുന്നവൻ ശപിക്കപ്പെട്ടവൻ എന്നു ഞാൻ അറിയുന്നു” എന്നു പറയിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","മോവാബ്യമൂപ്പന്മാരും മിദ്യാന്യമൂപ്പന്മാരും കൂടി കയ്യിൽ പ്രശ്നദക്ഷിണയുമായി ബിലെയാമിന്റെ അടുക്കൽ ചെന്നു ബാലാക്കിന്റെ വാക്കുകളെ അവനോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","അവൻ അവരോടു: “ഇന്നു രാത്രി ഇവിടെ പാർപ്പിൻ; യഹോവ എന്നോടു അരുളിച്ചെയ്യുന്നതുപോലെ ഞാൻ നിങ്ങളോടു ഉത്തരം പറയാം” എന്നു പറഞ്ഞു. മോവാബ്യപ്രഭുക്കന്മാർ ബിലെയാമിനോടുകൂടെ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ദൈവം ബിലെയാമിന്റെ അടുക്കൽ വന്നു: “നിന്നോടുകൂടെയുള്ള ഈ മനുഷ്യർ ആരെന്നു” ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ബിലെയാം ദൈവത്തോടു: “ഒരു ജനം മിസ്രയീമിൽനിന്നു പുറപ്പെട്ടുവന്നു ഭൂതലത്തെ മൂടിയിരിക്കുന്നു; നീ വന്നു എനിക്കുവേണ്ടി അവരെ ശപിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","പക്ഷേ അവരോടു യുദ്ധം ചെയ്തു അവരെ ഓടിച്ചുകളവാൻ എനിക്കു കഴിയും എന്നിങ്ങനെ മോവാബ്‌രാജാവായി സിപ്പോരിന്റെ മകനായ ബാലാക്ക് എന്റെ അടുക്കൽ പറഞ്ഞയച്ചിരിക്കുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ദൈവം ബിലെയാമിനോടു: “നീ അവരോടുകൂടെ പോകരുതു; ആ ജനത്തെ ശപിക്കയും അരുതു; അവർ അനുഗ്രഹിക്കപ്പെട്ടവർ ആകുന്നു” എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ബിലെയാം രാവിലെ എഴുന്നേറ്റു ബാലാക്കിന്റെ പ്രഭുക്കന്മാരോടു: “നിങ്ങളുടെ ദേശത്തേക്കു പോകുവിൻ; നിങ്ങളോടുകൂടെ പോരുവാൻ യഹോവ എനിക്കു അനുവാദം തരുന്നില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","മോവാബ്യപ്രഭുക്കന്മാർ പുറപ്പെട്ടു ബാലാക്കിന്റെ അടുക്കൽ ചെന്നു; “ബിലെയാമിന്നു ഞങ്ങളോടുകൂടെ വരുവാൻ മനസ്സില്ല” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ബാലാക്ക് വീണ്ടും അവരെക്കാൾ മാന്യരായ അധികം പ്രഭുക്കന്മാരെ അയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","അവർ ബിലെയാമിന്റെ അടുക്കൽ വന്നു അവനോടു: “‘എന്റെ അടുക്കൽ വരുന്നതിന്നു മുടക്കം ഒന്നും പറയരുതേ. ");
INSERT INTO mal2015_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ഞാൻ നിന്നെ ഏറ്റവും ബഹുമാനിക്കും; നീ എന്നോടു പറയുന്നതൊക്കെയും ഞാൻ ചെയ്യാം; വന്നു എനിക്കുവേണ്ടി ഈ ജനത്തെ ശപിക്കേണമേ’ എന്നു സിപ്പോരിന്റെ മകനായ ബാലാക്ക് പറയുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ബിലെയാം ബാലാക്കിന്റെ ഭൃത്യന്മാരോടു: “ബാലാക്ക് തന്റെ ഗൃഹം നിറെച്ചു വെള്ളിയും പൊന്നും എനിക്കു തന്നാലും എന്റെ ദൈവമായ യഹോവയുടെ കല്പന ലംഘിച്ചു ഏറെയോ കുറെയോ ചെയ്‌വാൻ എനിക്കു കഴിയുന്നതല്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ആകയാൽ യഹോവ ഇനിയും എന്നോടു എന്തു അരുളിച്ചെയ്യും എന്നു ഞാൻ അറിയട്ടെ; നിങ്ങളും ഈ രാത്രി ഇവിടെ പാർപ്പിൻ” എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","രാത്രിയിൽ ദൈവം ബിലെയാമിന്റെ അടുക്കൽ വന്നു: “ഇവർ നിന്നെ വിളിപ്പാൻ വന്നിരിക്കുന്നു എങ്കിൽ പുറപ്പെട്ടു അവരോടുകൂടെ പോക; എന്നാൽ ഞാൻ നിന്നോടു കല്പിക്കുന്ന കാര്യം മാത്രമേ ചെയ്യാവു” എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ബിലെയാം രാവിലെ എഴുന്നേറ്റു കഴുതെക്കു കോപ്പിട്ടു മോവാബ്യപ്രഭുക്കന്മാരോടുകൂടെ പോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","അവൻ പോകുന്നതുകൊണ്ടു ദൈവത്തിന്റെ കോപം ജ്വലിച്ചു; യഹോവയുടെ ദൂതൻ വഴിയിൽ അവന്നു പ്രതിയോഗിയായി നിന്നു; അവനോ കഴുതപ്പുറത്തു കയറി യാത്ര ചെയ്കയായിരുന്നു; അവന്റെ രണ്ടു ബാല്യക്കാരും കൂടെ ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","യഹോവയുടെ ദൂതൻ വാൾ ഊരിപ്പിടിച്ചുകൊണ്ടു വഴിയിൽ നില്ക്കുന്നതു കഴുത കണ്ടു; കഴുത വഴിയിൽ നിന്നു മാറി വയലിലേക്കു പോയി; കഴുതയെ വഴിയിലേക്കു തിരിക്കേണ്ടതിന്നു ബിലെയാം അതിനെ അടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","പിന്നെ യഹോവയുടെ ദൂതൻ ഇരുപുറവും മതിലുള്ള മുന്തിരിത്തോട്ടങ്ങളുടെ ഇടുക്കുവഴിയിൽനിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","കഴുത യഹോവയുടെ ദൂതനെ കണ്ടപ്പോൾ മതിലരികെ ഒതുങ്ങി ബിലെയാമിന്റെ കാൽ മതിലോടു ചേർത്തു ഞെക്കി; അവൻ അതിനെ വീണ്ടും അടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","പിന്നെ യഹോവയുടെ ദൂതൻ മുമ്പോട്ടു ചെന്നു ഇടത്തോട്ടും വലത്തോട്ടും മാറുവാൻ വഴിയില്ലാത്ത ഒരു ഇടുക്കിടയിൽ നിന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","യഹോവയുടെ ദൂതനെ കണ്ടപ്പോൾ കഴുത ബിലെയാമിന്റെ കീഴെ കിടന്നുകളഞ്ഞു; ബിലെയാമിന്റെ കോപം ജ്വലിച്ചു അവൻ കഴുതയെ വടികൊണ്ടു അടിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","അപ്പോൾ യഹോവ കഴുതയുടെ വായ് തുറന്നു; അതു ബിലെയാമിനോടു: “നീ എന്നെ ഈ മൂന്നു പ്രാവശ്യം അടിപ്പാൻ ഞാൻ നിന്നോടു എന്തു ചെയ്തു” എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ബിലെയാം കഴുതയോടു: “നീ എന്നെ കളിയാക്കിയതുകൊണ്ടത്രേ. എന്റെ കയ്യിൽ ഒരു വാൾ ഉണ്ടായിരുന്നെങ്കിൽ ഞാൻ ഇപ്പോൾ തന്നേ നിന്നെ കൊന്നുകളയുമായിരുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","കഴുത ബിലെയാമിനോടു: “ഞാൻ നിന്റെ കഴുതയല്ലയോ? ഇക്കാലമൊക്കെയും എന്റെ പുറത്തല്ലയോ നീ കയറി നടന്നതു? ഞാൻ എപ്പോഴെങ്കിലും ഇങ്ങനെ നിന്നോടു കാണിച്ചിട്ടുണ്ടോ” എന്നു ചോദിച്ചു. “ഇല്ല” എന്നു അവൻ പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","അപ്പോൾ യഹോവ ബിലെയാമിന്റെ കണ്ണു തുറന്നു, യഹോവയുടെ ദൂതൻ വാളൂരിപ്പിടിച്ചുകൊണ്ടു നില്ക്കുന്നതു അവൻ കണ്ടു സാഷ്ടാംഗം വീണു നമസ്കരിച്ചു. യഹോവയുടെ ദൂതൻ അവനോടു: ");
INSERT INTO mal2015_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","“ഈ മൂന്നു പ്രാവശ്യം നീ കഴുതയെ അടിച്ചതു എന്തു? ഇതാ, ഞാൻ നിനക്കു പ്രതിയോഗിയായി പുറപ്പെട്ടിരിക്കുന്നു: നിന്റെ വഴി നാശകരം എന്നു ഞാൻ കാണുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","കഴുത എന്നെ കണ്ടു ഈ മൂന്നു പ്രാവശ്യം എന്റെ മുമ്പിൽനിന്നു മാറിപ്പോയി; അതു മാറിപ്പോയിരുന്നില്ലെങ്കിൽ ഞാൻ ഇപ്പോൾ തന്നേ നിന്നെ കൊന്നുകളകയും അതിനെ ജീവനോട രക്ഷിക്കയും ചെയ്യുമായിരുന്നു” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ബിലെയാം യഹോവയുടെ ദൂതനോടു: “ഞാൻ പാപം ചെയ്തിരിക്കുന്നു: നീ എനിക്കു എതിരായി വഴിയിൽ നിന്നിരുന്നു എന്നു ഞാൻ അറിഞ്ഞില്ല; ഇതു നിനക്കു അനിഷ്ടമെന്നുവരികിൽ ഞാൻ മടങ്ങിപ്പൊയ്ക്കൊള്ളാം” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","യഹോവയുടെ ദൂതൻ ബിലെയാമിനോടു: “ഇവരോടുകൂടെ പോക; എങ്കിലും ഞാൻ നിന്നോടു കല്പിക്കുന്ന വചനം മാത്രമേ പറയാവു” എന്നു പറഞ്ഞു; ബിലെയാം ബാലാക്കിന്റെ പ്രഭുക്കന്മാരോടുകൂടെ പോകയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ബിലെയാം വരുന്നു എന്നു ബാലാക്ക് കേട്ടപ്പോൾ അർന്നോൻതീരത്തു ദേശത്തിന്റെ അതിരിലുള്ള ഈർമോവാബ് വരെ അവനെ എതിരേറ്റുചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ബാലാക്ക് ബിലെയാമിനോടു: “ഞാൻ നിന്നെ വിളിപ്പാൻ ആളയച്ചില്ലയോ? നീ വരാതിരുന്നതു എന്തു? നിന്നെ ബഹുമാനിപ്പാൻ എനിക്കു കഴികയില്ലയോ” എന്നു പറഞ്ഞതിന്നു ബിലെയാം ബാലാക്കിനോടു: ");
INSERT INTO mal2015_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","“ഞാൻ വന്നിരിക്കുന്നുവല്ലോ; എന്നാൽ എന്തെങ്കിലും പറവാൻ എനിക്കു കഴിയുമോ? ദൈവം എന്റെ നാവിന്മേൽ ആക്കിത്തരുന്ന വചനമേ ഞാൻ പ്രസ്താവിക്കയുള്ളു” എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","അങ്ങനെ ബിലെയാം ബാലാക്കിനോടുകൂടെ പോയി; അവർ കിര്യത്ത് - ഹൂസോത്തിൽ എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ബാലാക്ക് കാളകളെയും ആടുകളെയും അറുത്തു ബിലെയാമിന്നും അവനോടുകൂടെയുള്ള പ്രഭുക്കന്മാർക്കും കൊടുത്തയച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","പിറ്റെന്നാൾ ബാലാക്ക് ബിലെയാമിനെ ബാമോത്ത്-ബാലിലേക്കു കൂട്ടിക്കൊണ്ടുപോയി; അവിടെനിന്നു അവൻ ജനത്തിന്റെ ഒരു അറ്റം കണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","അനന്തരം ബിലെയാം ബാലാക്കിനോടു: ഇവിടെ എനിക്കു ഏഴു യാഗപീഠം പണിതു ഏഴു കാളയെയും ഏഴു ആട്ടുകൊറ്റനെയും ഒരുക്കിനിർത്തുക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ബിലെയാം പറഞ്ഞതുപോലെ ബാലാക്ക് ചെയ്തു; ബാലാക്കും ബിലെയാമും ഓരോ പീഠത്തിന്മേലും ഒരു കാളയെയും ഒരു ആട്ടുകൊറ്റനെയും യാഗം കഴിച്ചു; ");
INSERT INTO mal2015_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","പിന്നെ ബിലെയാം ബാലാക്കിനോടു: നിന്റെ ഹോമയാഗത്തിന്റെ അടുക്കൽ നിൽക്ക; ഞാൻ അങ്ങോട്ടു ചെല്ലട്ടെ; പക്ഷേ യഹോവ എനിക്കു പ്രത്യക്ഷനാകും; അവൻ എന്നെ ദർശിപ്പിക്കുന്നതു ഞാൻ നിന്നോടു അറിയിക്കും എന്നു പറഞ്ഞു കുന്നിന്മേൽ കയറി. ");
INSERT INTO mal2015_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ദൈവം ബിലെയാമിന്നു പ്രത്യക്ഷനായി; ബിലെയാം അവനോടു: ഞാൻ ഏഴു പീഠം ഒരുക്കി ഓരോ പീഠത്തിന്മേൽ ഒരു കാളയെയും ഒരു ആട്ടുകൊറ്റനെയും യാഗം കഴിച്ചിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","എന്നാറെ യഹോവ ഒരു വചനം ബിലെയാമിന്റെ നാവിന്മേൽ ആക്കിക്കൊടുത്തു: നീ ബാലാക്കിന്റെ അടുക്കൽ മടങ്ങിച്ചെന്നു ഇപ്രകാരം പറയേണം എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","അവൻ അവന്റെ അടുക്കൽ മടങ്ങിച്ചെന്നു; അവനും മോവാബ്യപ്രഭുക്കന്മാർ എല്ലാവരും ഹോമയാഗത്തിന്റെ അടുക്കൽ നിന്നിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","അപ്പോൾ അവൻ സുഭാഷിതം ചൊല്ലിത്തുടങ്ങിയതു: ബാലാക്ക് എന്നെ അരാമിൽനിന്നും മോവാബ്‌രാജാവു പൂർവ്വപർവ്വതങ്ങളിൽനിന്നും വരുത്തി: ചെന്നു യാക്കോബിനെ ശപിക്ക; ചെന്നു യിസ്രായേലിനെ പ്രാകുക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ദൈവം ശപിക്കാത്തവനെ ഞാൻ എങ്ങനെ ശപിക്കും? യഹോവ പ്രാകാത്തവനെ ഞാൻ എങ്ങനെ പ്രാകും? ");
INSERT INTO mal2015_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ശിലാഗ്രങ്ങളിൽനിന്നു ഞാൻ അവനെ കാണുന്നു; ഗിരികളിൽനിന്നു ഞാൻ അവനെ ദർശിക്കുന്നു; ഇതാ തനിച്ചു പാർക്കുന്നോരു ജനം; ജാതികളുടെ കൂട്ടത്തിൽ എണ്ണപ്പെടുന്നതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","യാക്കോബിന്റെ ധൂളിയെ ആർക്കു എണ്ണാം? യിസ്രായേലിന്റെ കാലംശത്തെ ആർക്കു ഗണിക്കാം? ഭക്തന്മാർ മരിക്കുമ്പോലെ ഞാൻ മരിക്കട്ടെ; എന്റെ അവസാനം അവന്റേതുപോലെ ആകട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ബാലാക്ക് ബിലെയാമിനോടു: നീ എന്നോടു ഈ ചെയ്തതു എന്തു? എന്റെ ശത്രുക്കളെ ശപിപ്പാനല്ലോ ഞാൻ നിന്നെ വരുത്തിയതു? നീയോ അവരെ അനുഗ്രഹിക്കയത്രേ ചെയ്തിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","അതിന്നു അവൻ: യഹോവ എന്റെ നാവിന്മേൽ തന്നതു പറവാൻ ഞാൻ ശ്രദ്ധിക്കേണ്ടായോ എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ബാലാക്ക് അവനോടു: നീ അവരെ മറ്റൊരു സ്ഥലത്തുനിന്നു കാണേണ്ടതിന്നു എന്നോടുകൂടെ വരിക; എന്നാൽ അവരുടെ ഒരറ്റം മാത്രമല്ലാതെ എല്ലാവരെയും കാണുകയില്ല; അവിടെനിന്നു അവരെ ശപിക്കേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ഇങ്ങനെ അവൻ പിസ്ഗകൊടുമുടിയിൽ സോഫീം എന്ന മുകൾപ്പരപ്പിലേക്കു അവനെ കൊണ്ടുപോയി ഏഴു യാഗപീഠം പണിതു ഓരോ പീഠത്തിന്മേലും ഒരു കാളയെയും ഒരു ആട്ടുകൊറ്റനെയും യാഗം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","പിന്നെ അവൻ ബാലാക്കിനോടു: ഇവിടെ നിന്റെ ഹോമയാഗത്തിന്റെ അടുക്കൽ നിൽക്ക; ഞാൻ അങ്ങോട്ടു ചെന്നു കാണട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","യഹോവ ബിലെയാമിന്നു പ്രത്യക്ഷനായി അവന്റെ നാവിന്മേൽ ഒരു വചനം കൊടുത്തു: ബാലാക്കിന്റെ അടുക്കൽ മടങ്ങിച്ചെന്നു ഇപ്രകാരം പറക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","അവൻ അവന്റെ അടുക്കൽ വന്നപ്പോൾ അവൻ മോവാബ്യപ്രഭുക്കന്മാരോടുകൂടെ തന്റെ ഹോമയാഗത്തിന്റെ അടുക്കൽ നിന്നിരുന്നു. അപ്പോൾ ബാലാക്ക് അവനോടു: യഹോവ എന്തു അരുളിച്ചെയ്തു എന്നു ചോദിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","അവൻ സുഭാഷിതം ചൊല്ലിത്തുടങ്ങിയതു: ബാലാക്കേ, എഴുന്നേറ്റു കേൾക്ക; സിപ്പോരിന്റെ പുത്രാ, എനിക്കു ചെവി തരിക. ");
INSERT INTO mal2015_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","വ്യാജം പറവാൻ ദൈവം മനുഷ്യനല്ല; അനുതപിപ്പാൻ അവൻ മനുഷ്യപുത്രനുമല്ല; താൻ ചെയ്യാതിരിക്കുമോ? താൻ അരുളിച്ചെയ്തതു നിവർത്തിക്കാതിരിക്കുമോ? ");
INSERT INTO mal2015_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","അനുഗ്രഹിപ്പാൻ എനിക്കു കല്പന ലഭിച്ചിരിക്കുന്നു; അവൻ അനുഗ്രഹിച്ചിരിക്കുന്നു; എനിക്കു അതു മറിച്ചുകൂടാ. ");
INSERT INTO mal2015_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","യാക്കോബിൽ തിന്മ കാണ്മാനില്ല; യിസ്രായേലിൽ കഷ്ടത ദർശിപ്പാനുമില്ല; അവന്റെ ദൈവമായ യഹോവ അവനോടുകൂടെ ഇരിക്കുന്നു; രാജകോലാഹലം അവരുടെ മദ്ധ്യേ ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ദൈവം അവരെ മിസ്രയീമിൽനിന്നു കൊണ്ടുവരുന്നു; കാട്ടുപോത്തിന്നു തുല്യമായ ബലം അവന്നു ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ആഭിചാരം യാക്കോബിന്നു പറ്റുകയില്ല; ലക്ഷണവിദ്യ യിസ്രായേലിനോടു ഫലിക്കയുമില്ല; ഇപ്പോൾ യാക്കോബിനെക്കുറിച്ചും യിസ്രായേലിനെക്കുറിച്ചും: ദൈവം എന്തെല്ലാം പ്രവർത്തിച്ചിരിക്കുന്നു എന്നേ പറയാവു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ഇതാ, ജനം സിംഹിയെപ്പോലെ എഴുന്നേല്ക്കുന്നു; ബാലസിംഹത്തെപ്പോലെ തെളിഞ്ഞുനില്ക്കുന്നു; അവൻ ഇര പിടിച്ചു തിന്നാതെയും നിഹതന്മാരുടെ രക്തം കുടിക്കാതെയും കിടക്കയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","അപ്പോൾ ബാലാക്ക് ബിലെയാമിനോടു: അവരെ ശപിക്കയും വേണ്ടാ അനുഗ്രഹിക്കയും വേണ്ടാ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ബിലെയാം ബാലാക്കിനോടു: യഹോവ കല്പിക്കുന്നതൊക്കെയും ഞാൻ ചെയ്യും എന്നു നിന്നോടു പറഞ്ഞില്ലയോ എന്നുത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ബാലാക്ക് ബിലെയാമിനോടു: വരിക, ഞാൻ നിന്നെ മറ്റൊരു സ്ഥലത്തു കൊണ്ടുപോകും; അവിടെനിന്നു നീ എനിക്കുവേണ്ടി അവരെ ശപിപ്പാൻ ദൈവത്തിന്നു പക്ഷേ സമ്മതമാകും എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","അങ്ങനെ ബാലാക്ക് ബിലെയാമിനെ മരുഭൂമിക്കു എതിരെയുള്ള പെയോർമലയുടെ മുകളിൽ കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ബിലെയാം ബാലാക്കിനോടു: ഇവിടെ എനിക്കു ഏഴു യാഗപീഠം പണിതു ഏഴു കാളയെയും ഏഴു ആട്ടുകൊറ്റനെയും ഒരുക്കിനിർത്തുക എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ബിലെയാം പറഞ്ഞതുപോലെ ബാലാക്ക് ചെയ്തു; ഓരോ യാഗപീഠത്തിന്മേലും ഒരു കാളയെയും ഒരു ആട്ടുകൊറ്റനെയും യാഗം കഴിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","യിസ്രായേലിനെ അനുഗ്രഹിക്കുന്നതു യഹോവെക്കു പ്രസാദമെന്നു ബിലെയാം കണ്ടപ്പോൾ അവൻ മുമ്പിലത്തെപ്പോലെ ലക്ഷണം നോക്കുവാൻ പോകാതെ മരുഭൂമിക്കുനേരെ മുഖം തിരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ബിലെയാം തല ഉയർത്തി യിസ്രായേൽ ഗോത്രംഗോത്രമായി പാർക്കുന്നതു കണ്ടു; ദൈവത്തിന്റെ ആത്മാവു അവന്റെമേൽ വന്നു; ");
INSERT INTO mal2015_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","അവൻ സുഭാഷിതം ചൊല്ലിത്തുടങ്ങിയതു: ബെയോരിന്റെ മകനായ ബിലെയാം പറയുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","കണ്ണടച്ചിരിക്കുന്ന പുരുഷൻ പറയുന്നു; ദൈവത്തിന്റെ അരുളപ്പാടു കേൾക്കുന്നവൻ, സർവ്വശക്തന്റെ ദർശനം ദർശിക്കുന്നവൻ, വീഴുമ്പോൾ കണ്ണു തുറന്നിരിക്കുന്നവൻ പറയുന്നതു: ");
INSERT INTO mal2015_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","യാക്കോബേ, നിന്റെ കൂടാരങ്ങൾ, യിസ്രായേലേ, നിന്റെ നിവാസങ്ങൾ എത്ര മനോഹരം! ");
INSERT INTO mal2015_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","താഴ്‌വരപോലെ അവ പരന്നിരിക്കുന്നു; നദീതീരത്തെ ഉദ്യാനങ്ങൾ പോലെ, യഹോവ നട്ടിരിക്കുന്ന ചന്ദനവൃക്ഷങ്ങൾ പോലെ, ജലാന്തികേയുള്ള ദേവദാരുക്കൾപോലെ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","അവന്റെ തൊട്ടികളിൽനിന്നു വെള്ളം ഒഴുകുന്നു; അവന്റെ വിത്തിന്നു വെള്ളം ധാരാളം; അവന്റെ അരചൻ ആഗാഗിലും ശ്രേഷ്ഠൻ; അവന്റെ രാജത്വം ഉന്നതം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ദൈവം അവനെ മിസ്രയീമിൽനിന്നു കൊണ്ടു വരുന്നു; കാട്ടുപോത്തിന്നു തുല്യമായ ബലം അവന്നു ഉണ്ടു; ശത്രുജാതികളെ അവൻ തിന്നുകളയുന്നു; അവരുടെ അസ്ഥികളെ അവൻ തകർക്കുന്നു; അസ്ത്രം എയ്തു അവരെ തുളെക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","അവൻ സിംഹംപോലെ പതുങ്ങിക്കിടക്കുന്നു; ഒരു സിംഹികണക്കെത്തന്നേ; ആർ അവനെ ഉണർത്തും? നിന്നെ അനുഗ്രഹിക്കുന്നവൻ അനുഗ്രഹിക്കപ്പെട്ടവൻ; നിന്നെ ശപിക്കുന്നവൻ ശപിക്കപ്പെട്ടവൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","അപ്പോൾ ബാലാക്കിന്റെ കോപം ബിലെയാമിന്റെ നേരെ ജ്വലിച്ചു; അവൻ കൈഞെരിച്ചു ബിലെയാമിനോടു: എന്റെ ശത്രുക്കളെ ശപിപ്പാൻ ഞാൻ നിന്നെ വിളിപ്പിച്ചു; നീയോ ഇവരെ ഈ മൂന്നു പ്രാവശ്യവും ആശീർവ്വദിക്കയത്രേ ചെയ്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ഇപ്പോൾ നിന്റെ സ്ഥലത്തേക്കു ഓടിപ്പോക; നിന്നെ ഏറ്റവും ബഹുമാനിപ്പാൻ ഞാൻ വിചാരിച്ചിരുന്നു; എന്നാൽ യഹോവ നിനക്കു ബഹുമാനം മുടക്കിയിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","അതിന്നു ബിലെയാം ബാലാക്കിനോടു പറഞ്ഞതു: ബാലാക്ക് തന്റെ ഗൃഹം നിറെച്ചു വെള്ളിയും പൊന്നും തന്നാലും യഹോവയുടെ കല്പന ലംഘിച്ചു ഗുണമെങ്കിലും ദോഷമെങ്കിലും സ്വമേധയായി ചെയ്‌വാൻ എനിക്കു കഴിയുന്നതല്ല; ");
INSERT INTO mal2015_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","യഹോവ അരുളിച്ചെയ്യുന്നതു മാത്രമേ ഞാൻ പറകയുള്ളു. എന്നു എന്റെ അടുക്കൽ നീ അയച്ച ദൂതന്മാരോടു ഞാൻ പറഞ്ഞില്ലയോ? ");
INSERT INTO mal2015_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ഇപ്പോൾ ഇതാ, ഞാൻ എന്റെ ജനത്തിന്റെ അടുക്കലേക്കു പോകുന്നു; വരിക, ഭാവികാലത്തു ഈ ജനം നിന്റെ ജനത്തോടു എന്തു ചെയ്യുമെന്നു ഞാൻ നിന്നെ അറിയിക്കാം. ");
INSERT INTO mal2015_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","പിന്നെ അവൻ സുഭാഷിതം ചൊല്ലിത്തുടങ്ങിയതെന്തെന്നാൽ: ബെയോരിന്റെ മകൻ ബിലെയാം പറയുന്നു; കണ്ണടെച്ചിരിക്കുന്ന പുരുഷൻ പറയുന്നു; ");
INSERT INTO mal2015_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ദൈവത്തിന്റെ അരുളപ്പാടു കേൾക്കുന്നവൻ, അത്യുന്നതന്റെ പരിജ്ഞാനം പ്രാപിച്ചവൻ, സർവ്വശക്തന്റെ ദർശനം ദർശിക്കുന്നവൻ, വീഴുമ്പോൾ കണ്ണു തുറന്നിരിക്കുന്നവൻ പറയുന്നതു: ");
INSERT INTO mal2015_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ഞാൻ അവനെ കാണും, ഇപ്പോൾ അല്ലതാനും; ഞാൻ അവനെ ദർശിക്കും, അടുത്തല്ലതാനും. യാക്കോബിൽനിന്നു ഒരു നക്ഷത്രം ഉദിക്കും; യിസ്രായേലിൽനിന്നു ഒരു ചെങ്കോൽ ഉയരും. അതു മോവാബിന്റെ പാർശ്വങ്ങളെയെല്ലാം തകർക്കയും തുമുലപുത്രന്മാരെ ഒക്കെയും സംഹരിക്കയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","എദോം ഒരു അധീനദേശമാകും; ശത്രുവായ സെയീരും അധീനദേശമാകും; യിസ്രായേലോ വീര്യം പ്രവർത്തിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","യാക്കോബിൽനിന്നു ഒരുത്തൻ ഭരിക്കും; ഒഴിഞ്ഞുപോയവരെ അവൻ നഗരത്തിൽനിന്നു നശിപ്പിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","അവൻ അമാലേക്കിനെ നോക്കി സുഭാഷിതം ചൊല്ലിയതു: അമാലേക്ക് ജാതികളിൽ മുമ്പൻ; അവന്റെ അവസാനമോ നാശം അത്രേ. ");
INSERT INTO mal2015_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","അവൻ കേന്യരെ നോക്കി സുഭാഷിതം ചൊല്ലിയതു: നിന്റെ നിവാസം ഉറപ്പുള്ളതു: നിന്റെ കൂടു പാറയിൽ വെച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","എങ്കിലും കേന്യന്നു നിർമ്മൂലനാശം ഭവിക്കും; അശ്ശൂർ നിന്നെ പിടിച്ചു കൊണ്ടുപോവാൻ ഇനിയെത്ര? ");
INSERT INTO mal2015_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","പിന്നെ അവൻ ഈ സുഭാഷിതം ചൊല്ലിയതു: ഹാ, ദൈവം ഇതു നിവർത്തിക്കുമ്പോൾ ആർ ജീവിച്ചിരിക്കും? ");
INSERT INTO mal2015_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","കിത്തീംതീരത്തുനിന്നു കപ്പലുകൾ വരും; അവ അശ്ശൂരിനെ താഴ്ത്തും, ഏബെരിനെയും താഴ്ത്തും. അവന്നും നിർമ്മൂലനാശം ഭവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","അതിന്റെ ശേഷം ബിലെയാം പുറപ്പെട്ടു തന്റെ സ്ഥലത്തേക്കു മടങ്ങിപ്പോയി; ബാലാക്കും തന്റെ വഴിക്കു പോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","യിസ്രായേൽ ശിത്തീമിൽ പാർക്കുമ്പോൾ ജനം മോവാബ്യസ്ത്രീകളുമായി പരസംഗം തുടങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","അവർ ജനത്തെ തങ്ങളുടെ ദേവന്മാരുടെ ബലികൾക്കു വിളിക്കയും ജനം ഭക്ഷിച്ചു അവരുടെ ദേവന്മാരെ നമസ്കരിക്കയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","യിസ്രായേൽ ബാൽപെയോരിനോടു ചേർന്നു, യഹോവയുടെ കോപം യിസ്രായേലിന്റെ നേരെ ജ്വലിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","യഹോവ മോശെയോടു: ജനത്തിന്റെ തലവന്മാരെയൊക്കെയും കൂട്ടി യഹോവയുടെ ഉഗ്രകോപം യിസ്രായേലിനെ വിട്ടുമാറേണ്ടതിന്നു അവരെ യഹോവയുടെ മുമ്പാകെ പരസ്യമായി തൂക്കിക്കളക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","മോശെ യിസ്രായേൽ ന്യായാധിപന്മാരോടു: നിങ്ങൾ ഓരോരുത്തൻ താന്താന്റെ ആളുകളിൽ ബാൽപെയോരിനോടു ചേർന്നവരെ കൊല്ലുവിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","എന്നാൽ മോശെയും സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ കരഞ്ഞുകൊണ്ടിരിക്കുന്ന യിസ്രായേൽമക്കളുടെ സർവ്വസഭയും കാൺകെ, ഒരു യിസ്രായേല്യൻ തന്റെ സഹോദരന്മാരുടെ മദ്ധ്യത്തിലേക്കു ഒരു മിദ്യാന്യസ്ത്രീയെ കൊണ്ടുവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","അഹരോൻപുരോഹിതന്റെ മകനായ എലെയാസാരിന്റെ മകൻ ഫീനെഹാസ് അതു കണ്ടപ്പോൾ സഭയുടെ മദ്ധ്യേനിന്നു എഴുന്നേറ്റു കയ്യിൽ ഒരു കുന്തം എടുത്തു, ");
INSERT INTO mal2015_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ആ യിസ്രായേല്യന്റെ പിന്നാലെ അന്തഃപുരത്തിലേക്കു ചെന്നു ഇരുവരെയും, ആ യിസ്രായേല്യനെയും ആ സ്ത്രീയെയും തന്നേ, അവളുടെ ഉദരം തുളയുംവണ്ണം കുത്തി, അപ്പോൾ ബാധ യിസ്രായേൽ മക്കളെ വിട്ടുമാറി. ");
INSERT INTO mal2015_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ബാധകൊണ്ടു മരിച്ചുപോയവർ ഇരുപത്തുനാലായിരം പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","പിന്നെ യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","ഞാൻ എന്റെ തീക്ഷ്ണതയിൽ യിസ്രായേൽമക്കളെ സംഹരിക്കാതിരിക്കേണ്ടതിന്നു അഹരോൻപുരോഹിതന്റെ മകനായ എലെയാസാരിന്റെ മകൻ ഫീനെഹാസ് അവരുടെ ഇടയിൽ എനിക്കുവേണ്ടി തീക്ഷ്ണതയുള്ളവനായി എന്റെ ക്രോധം യിസ്രായേൽ മക്കളെ വിട്ടുപോകുമാറാക്കിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ആകയാൽ ഇതാ, ഞാൻ അവന്നു എന്റെ സമാധാനനിയമം കൊടുക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","അവൻ തന്റെ ദൈവത്തിന്നുവേണ്ടി തീക്ഷ്ണതയുള്ളവനായി യിസ്രായേൽമക്കൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിച്ചതുകൊണ്ടു അതു അവന്നും അവന്റെ സന്തതിക്കും നിത്യപൗരോഹിത്യത്തിന്റെ നിയമമാകും എന്നു നീ പറയേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","മിദ്യാന്യസ്ത്രീയോടുകൂടെ കൊന്ന യിസ്രായേല്യന്നു സിമ്രി എന്നു പേർ; അവൻ ശിമെയോൻ ഗോത്രത്തിൽ ഒരു പ്രഭുവായ സാലൂവിന്റെ മകൻ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","കൊല്ലപ്പെട്ട മിദ്യാന്യസ്ത്രീക്കു കൊസ്ബി എന്നു പേർ; അവൾ ഒരു മിദ്യാന്യഗോത്രത്തിൽ ജനാധിപനായിരുന്ന സൂരിന്റെ മകളായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","പെയോരിന്റെ സംഗതിയിലും പെയോർ നിമിത്തം ഉണ്ടായ ബാധയുടെ നാളിൽ കൊല്ലപ്പെട്ട അവരുടെ സഹോദരിയായി മിദ്യാന്യപ്രഭുവിന്റെ മകൾ കൊസ്ബിയുടെ സംഗതിയിലും മിദ്യാന്യർ നിങ്ങളെ ചതിച്ചു ഉപായങ്ങളാൽ വലെച്ചിരിക്കകൊണ്ടു, ");
INSERT INTO mal2015_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","നിങ്ങൾ അവരെ വലെച്ചു സംഹരിപ്പിൻ ");
INSERT INTO mal2015_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","എന്നു യഹോവ മോശെയോടു അരുളിച്ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ബാധ കഴിഞ്ഞശേഷം യഹോവ മോശെയോടും പുരോഹിതനായ അഹരോന്റെ മകൻ എലെയാസാരിനോടും: ");
INSERT INTO mal2015_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","യിസ്രായേൽമക്കളുടെ സർവ്വസഭയെയും ഇരുപതു വയസ്സുമുതൽ മേലോട്ടു യുദ്ധത്തിന്നു പ്രാപ്തിയുള്ള എല്ലാവരെയും ഗോത്രം ഗോത്രമായി എണ്ണി തുക എടുപ്പിൻ എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","അങ്ങനെ മോശെയും പുരോഹിതനായ എലെയാസാരും യെരീഹോവിന്റെ സമീപത്തു യോർദ്ദാന്നരികെയുള്ള മോവാബ് സമഭൂമിയിൽവെച്ചു അവരോടു: ");
INSERT INTO mal2015_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","യഹോവ മോശെയോടും മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെട്ട യിസ്രായേൽമക്കളോടും കല്പിച്ചതുപോലെ ഇരുപതു വയസ്സുമുതൽ മേലോട്ടുള്ളവരുടെ തുകയെടുപ്പിൻ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","യിസ്രായേലിന്റെ ആദ്യജാതൻ രൂബേൻ; രൂബേന്റെ പുത്രന്മാർ: ഹനോക്കിൽനിന്നു ഹനോക്ക്യകുടുംബം; പല്ലൂവിൽനിന്നു പല്ലൂവ്യകുടുംബം; ");
INSERT INTO mal2015_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ഹെസ്രോനിൽനിന്നു ഹെസ്രോന്യകുടുംബം; കർമ്മിയിൽനിന്നു കർമ്മ്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ഇവയാകുന്നു രൂബേന്യകുടുംബങ്ങൾ; അവരിൽ എണ്ണപ്പെട്ടവർ നാല്പത്തിമൂവായിരത്തെഴുനൂറ്റി മുപ്പതുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","പല്ലൂവിന്റെ പുത്രന്മാർ: എലീയാബ്. ");
INSERT INTO mal2015_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","എലീയാബിന്റെ പുത്രന്മാർ: നെമൂവേൽ, ദാഥാൻ, അബീരാം. യഹോവെക്കു വിരോധമായി കലഹിച്ചപ്പോൾ കോരഹിന്റെ കൂട്ടത്തിൽ മോശെക്കും അഹരോന്നും വിരോധമായി കലഹിച്ച സംഘസദസ്യന്മാരായ ദാഥാനും അബീരാമും ഇവർ തന്നേ; ");
INSERT INTO mal2015_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ഭൂമി വായി തുറന്നു അവരെയും കോരഹിനെയും വിഴുങ്ങിക്കളകയും തീ ഇരുനൂറ്റമ്പതുപേരെ ദഹിപ്പിക്കയും ചെയ്ത സമയം ആ കൂട്ടം മരിച്ചു; അവർ ഒരു അടയാളമായ്തീർന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","എന്നാൽ കോരഹിന്റെ പുത്രന്മാർ മരിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ശിമെയോന്റെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: നെമൂവേലിൽനിന്നു നെമൂവേല്യകുടുംബം; യാമീനിൽനിന്നു യാമീന്യകുടുംബം; യാഖീനിൽനിന്നു യാഖീന്യകുടുംബം; ");
INSERT INTO mal2015_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","സേരഹിൽനിന്നു സേരഹ്യകുടുംബം; ശാവൂലിൽനിന്നു ശാവൂല്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ശിമെയോന്യകുടുംബങ്ങളായ ഇവർ ഇരുപത്തീരായിരത്തിരുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ഗാദിന്റെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: സെഫോനിൽനിന്നു സെഫോന്യകുടുംബം; ഹഗ്ഗിയിൽനിന്നു ഹഗ്ഗീയകുടുംബം; ശൂനിയിൽനിന്നു ശൂനീയകുടുംബം; ");
INSERT INTO mal2015_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ഒസ്നിയിൽനിന്നു ഒസ്നീയകുടുംബം; ഏരിയിൽനിന്നു ഏര്യകുടുംബം; ");
INSERT INTO mal2015_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","അരോദിൽനിന്നു അരോദ്യകുടുംബം; അരേലിയിൽനിന്നു അരേല്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","അവരിൽ എണ്ണപ്പെട്ടവരായി ഗാദ്പുത്രന്മാരുടെ കുടുംബങ്ങളായ ഇവർ നാല്പതിനായിരത്തഞ്ഞൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","യെഹൂദയുടെ പുത്രന്മാർ ഏരും ഓനാനും ആയിരുന്നു; ഏരും ഒനാനും കനാൻദേശത്തുവെച്ചു മരിച്ചുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","യെഹൂദയുടെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: ശേലയിൽനിന്നു ശേലാന്യകുടുംബം; ഫേരെസിൽനിന്നു ഫേരെസ്യകുടുംബം; സേരഹിൽനിന്നു സേരഹ്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ഫേരെസിന്റെ പുത്രന്മാർ: ഹെസ്രോനിൽനിന്നു ഹെസ്രോന്യകുടുംബം; ഹാമൂലിൽനിന്നു ഹാമൂല്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","അവരിൽ എണ്ണപ്പെട്ടവരായി യെഹൂദാകുടുംബങ്ങളായ ഇവർ എഴുപത്താറായിരത്തഞ്ഞൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","യിസ്സാഖാരിന്റെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: തോലാവിൽ നിന്നു തോലാവ്യകുടുംബം; പൂവയിൽനിന്നു പൂവ്യകുടുംബം; ");
INSERT INTO mal2015_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","യാശൂബിൽനിന്നു യാശൂബ്യകുടുംബം; ശിമ്രോനിൽനിന്നു ശിമ്രോന്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","അവരിൽ എണ്ണപ്പെട്ടവരായി യിസ്സാഖാർകുടുംബങ്ങളായ ഇവർ അറുപത്തുനാലായിരത്തി മുന്നൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","സെബൂലൂന്റെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: സേരെദിൽനിന്നു സേരെദ്യകുടുംബം; ഏലോനിൽനിന്നു ഏലോന്യകുടുംബം; യഹ്ലേലിൽനിന്നു യഹ്ലേല്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","അവരിൽ എണ്ണപ്പെട്ടവരായി സെബൂലൂന്യകുടുംബങ്ങളായ ഇവർ അറുപതിനായിരത്തഞ്ഞൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","യോസേഫിന്റെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: മനശ്ശെയും എഫ്രയീമും. ");
INSERT INTO mal2015_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","മനശ്ശെയുടെ പുത്രന്മാർ: മാഖീരിൽനിന്നു മാഖീര്യകുടുംബം; മാഖീർ ഗിലെയാദിനെ ജനിപ്പിച്ചു; ഗിലെയാദിൽനിന്നു ഗിലെയാദ്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ഗിലെയാദിന്റെ പുത്രന്മാർ ആരെന്നാൽ: ഈയേസെരിൽ നിന്നു ഈയേസെര്യകുടുംബം; ഹേലെക്കിൽനിന്നു ഹേലെക്ക്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","അസ്രീയേലിൽനിന്നു അസ്രീയേല്യകുടുംബം; ശേഖെമിൽനിന്നു ശേഖെമ്യകുടുംബം; ");
INSERT INTO mal2015_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ശെമീദാവിൽനിന്നു ശെമീദാവ്യകുടുംബം; ഹേഫെരിൽനിന്നു ഹേഫെര്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ഹേഫെരിന്റെ മകനായ സെലോഫഹാദിന്നു പുത്രിമാർ അല്ലാതെ പുത്രന്മാർ ഉണ്ടായില്ല; സെലോഫഹാദിന്റെ പുത്രിമാർ മഹ്ലാ, നോവാ, ഹൊഗ്ല, മിൽക്കാ, തിർസാ എന്നിവരായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","അവരിൽ എണ്ണപ്പെട്ടവരായി മനശ്ശെകുടുംബങ്ങളായ ഇവർ അമ്പത്തീരായിരത്തെഴുനൂറു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","എഫ്രയീമിന്റെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: ശൂഥേലഹിൽനിന്നു ശൂഥേലഹ്യകുടുംബം; ബേഖെരിൽനിന്നു ബേഖെര്യകുടുംബം; തഹനിൽനിന്നു തഹന്യകുടുംബം, ");
INSERT INTO mal2015_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ശൂഥേലഹിന്റെ പുത്രന്മാർ ആരെന്നാൽ: ഏരാനിൽനിന്നു ഏരാന്യകടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","അവരിൽ എണ്ണപ്പെട്ടവരായി എഫ്രയീമ്യകുടുംബങ്ങളായ ഇവർ മുപ്പത്തീരായിരത്തഞ്ഞൂറുപേർ. ഇവർ കുടുംബംകുടുംബമായി യോസേഫിന്റെ പുത്രന്മാർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ബെന്യാമീന്റെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: ബേലയിൽനിന്നു ബേലാവ്യകുടുംബം; അസ്ബേലിൽനിന്നു അസ്ബേല്യകുടുംബം; അഹീരാമിൽനിന്നു അഹീരാമ്യകുടുംബം; ");
INSERT INTO mal2015_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ശെഫൂമിൽനിന്നു ശെഫൂമ്യകുടുംബം; ഹൂഫാമിൽനിന്നു ഹൂഫാമ്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ബേലിയുടെ പുത്രന്മാർ അർദ്ദും നാമാനും ആയിരുന്നു; അർദ്ദിൽനിന്നു അർദ്ദ്യകുടുംബം; നാമാനിൽനിന്നു നാമാന്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ഇവർ കുടുംബംകുടുംബമായി ബെന്യാമീന്റെ പുത്രന്മാർ; അവരിൽ എണ്ണപ്പെട്ടവർ നാല്പത്തയ്യായിരത്തറുനൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ദാന്റെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: ശൂഹാമിൽനിന്നു ശൂഹാമ്യ കുടുംബം; ഇവർ കുടുംബംകുടുംബമായി ദാന്യകുടുംബങ്ങൾ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ശൂഹാമ്യകുടുംബങ്ങളിൽ എണ്ണപ്പെട്ടവർ എല്ലാംകൂടി അറുപത്തുനാലായിരത്തി നാനൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ആശേരിന്റെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: യിമ്നയിൽനിന്നു യിമ്നീയകുടുംബം; യിശ്വയിൽനിന്നു യിശ്വീയ കുടുംബം; ബെരീയാവിൽനിന്നു ബെരീയാവ്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ബെരീയാവിന്റെ പുത്രന്മാരുടെ കുടുംബംങ്ങൾ ആരെന്നാൽ: ഹേബെരിൽനിന്നു ഹേബെര്യകുടുംബം; മൽക്കീയേലിൽനിന്നു മൽക്കീയേല്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ആശേരിന്റെ പുത്രിക്കു സാറാ എന്നു പേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ഇവർ ആശേർപുത്രന്മാരുടെ കുടുംബങ്ങൾ. അവരിൽ എണ്ണപ്പെട്ടവർ അമ്പത്തുമൂവായിരത്തി നാനൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","നഫ്താലിയുടെ പുത്രന്മാർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: യഹ്സേലിൽനിന്നു യഹ്സേല്യകുടുംബം; ഗൂനിയിൽനിന്നു ഗൂന്യകുടുംബം; ");
INSERT INTO mal2015_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","യേസെരിൽനിന്നു യേസെര്യകുടുംബം. ശില്ലോമിൽനിന്നു ശില്ലോമ്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ഇവർ കുടുംബംകുടുംബമായി നഫ്താലികുടുംബങ്ങൾ ആകുന്നു; അവരിൽ എണ്ണപ്പെട്ടവർ നാല്പത്തയ്യായിരത്തി നാനൂറുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","യിസ്രായേൽമക്കളിൽ എണ്ണപ്പെട്ട ഇവർ ആറു ലക്ഷത്തോരായിരത്തെഴുനൂറ്റി മുപ്പതുപേർ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","പിന്നെ യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","ഇവർക്കു ആളെണ്ണത്തിന്നു ഒത്തവണ്ണം ദേശത്തെ അവകാശമായി വിഭാഗിച്ചു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ആളേറെയുള്ളവർക്കു അവകാശം ഏറെയും ആൾ കുറവുള്ളവർക്കു അവകാശം കുറെച്ചും കൊടുക്കേണം; ഓരോരുത്തന്നു അവനവന്റെ ആളെണ്ണത്തിന്നു ഒത്തവണ്ണം അവകാശം കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ദേശത്തെ ചീട്ടിട്ടു വിഭാഗിക്കേണം; അതതു പിതൃഗോത്രത്തിന്റെ പേരിന്നൊത്തവണ്ണം അവർക്കു അവകാശം ലഭിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ആൾ ഏറെയുള്ളവർക്കും കുറെയുള്ളവർക്കും അവകാശം ചീട്ടിട്ടു വിഭാഗിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ലേവ്യരിൽ എണ്ണപ്പെട്ടവർ കുടുംബംകുടുംബമായി ആരെന്നാൽ: ഗേർശോനിൽനിന്നു ഗേർശോന്യകുടുംബം; കെഹാത്തിൽനിന്നു കെഹാത്യകുടുംബം; മെരാരിയിൽനിന്നു മെരാര്യകുടുംബം. ");
INSERT INTO mal2015_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ലേവ്യകുടുംബങ്ങൾ ആവിതു: ലിബ്നീയകുടുംബം; ഹെബ്രോന്യകുടുംബം; മഹ്ലീയകുടുംബം; മൂശ്യകുടുംബം; കോരഹ്യകുടുംബം. കെഹാത്ത് അമ്രാമിനെ ജനിപ്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","അമ്രാമിന്റെ ഭാര്യക്കു യോഖേബേദ് എന്നു പേർ; അവൾ മിസ്രയീംദേശത്തുവെച്ചു ലേവിക്കു ജനിച്ച മകൾ; അവൾ അമ്രാമിന്നു അഹരോനെയും മോശെയെയും അവരുടെ സഹോദരിയായ മിര്യാമിനെയും പ്രസവിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","അഹരോന്നു നാദാബ്, അബീഹൂ, എലെയാസാർ, ഈഥാമാർ എന്നിവർ ജനിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","എന്നാൽ നാദാബും അബീഹൂവും യഹോവയുടെ സന്നിധിയിൽ അന്യാഗ്നി കത്തിച്ചു മരിച്ചുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ഒരു മാസം പ്രായംമുതൽ മേലോട്ടു അവരിൽ എണ്ണപ്പെട്ട ആണുങ്ങൾ ആകെ ഇരുപത്തുമൂവായിരം പേർ; യിസ്രായേൽമക്കളുടെ ഇടയിൽ അവർക്കു അവകാശം കൊടുക്കായ്കകൊണ്ടു അവരെ യിസ്രായേൽമക്കളുടെ കൂട്ടത്തിൽ എണ്ണിയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","യെരീഹോവിന്റെ സമീപത്തു യോർദ്ദാന്നരികെ മോവാബ്സമഭൂമിയിൽവെച്ചു യിസ്രായേൽമക്കളെ എണ്ണിയപ്പോൾ മോശെയും പുരോഹിതനായ എലെയാസാരും എണ്ണിയവർ ഇവർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","എന്നാൽ മോശെയും അഹരോൻപുരോഹിതനും സീനായിമരുഭൂമിയിൽവെച്ചു യിസ്രായേൽമക്കളെ എണ്ണിയപ്പോൾ അവർ എണ്ണിയവരിൽ ഒരുത്തനും ഇവരുടെ കൂട്ടത്തിൽ ഉണ്ടായിരുന്നില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","അവർ മരുഭൂമിയിൽവെച്ചു മരിച്ചുപോകും എന്നു യഹോവ അവരെക്കുറിച്ചു അരുളിച്ചെയ്തിരുന്നു. യെഫുന്നെയുടെ മകൻ കാലേബും നൂന്റെ മകൻ യോശുവയും ഒഴികെ അവരിൽ ഒരുത്തനും ശേഷിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","അനന്തരം യോസേഫിന്റെ മകനായ മനശ്ശെയുടെ കുടുംബങ്ങളിൽ മനശ്ശെയുടെ മകനായ മാഖീരിന്റെ മകനായ ഗിലെയാദിന്റെ മകനായ ഹേഫെരിന്റെ മകനായ സെലോഫഹാദിന്റെ പുത്രിമാർ അടുത്തുവന്നു. അവന്റെ പുത്രിമാർ മഹ്ലാ, നോവ, ഹോഗ്ല, മിൽക്കാ, തിർസാ എന്നിവരായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","അവർ സമാഗമനകൂടാരത്തിന്റെ വാതിൽക്കൽ മോശെയുടെയും എലെയാസാർപുരോഹിതന്റെയും പ്രഭുക്കന്മാരുടെയും സർവ്വസഭയുടെയും മുമ്പാകെ നിന്നു പറഞ്ഞതു എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","ഞങ്ങളുടെ അപ്പൻ മരുഭൂമിയിൽവെച്ചു മരിച്ചുപോയി; എന്നാൽ അവൻ യഹോവെക്കു വിരോധമായി കോരഹിനോടു കൂടിയവരുടെ കൂട്ടത്തിൽ ചേർന്നിരുന്നില്ല; അവൻ സ്വന്തപാപത്താൽ അത്രേ മരിച്ചതു; അവന്നു പുത്രന്മാർ ഉണ്ടായിരുന്നതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ഞങ്ങളുടെ അപ്പന്നു മകൻ ഇല്ലായ്കകൊണ്ടു അവന്റെ പേർ കുടുംബത്തിൽനിന്നു ഇല്ലാതെയാകുന്നതു എന്തു? അപ്പന്റെ സഹോദരന്മാരുടെ ഇടയിൽ ഞങ്ങൾക്കു ഒരു അവകാശം തരേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","മോശെ അവരുടെ കാര്യം യഹോവയുടെ മുമ്പാകെ വെച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","സെലോഫഹാദിന്റെ പുത്രിമാർ പറയുന്നതു ശരിതന്നേ; അവരുടെ അപ്പന്റെ സഹോദരന്മാരുടെ ഇടയിൽ അവർക്കു ഒരു അവകാശം കൊടുക്കേണം; അവരുടെ അപ്പന്റെ അവകാശം അവർക്കു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതു എന്തെന്നാൽ: ഒരുത്തൻ മകനില്ലാതെ മരിച്ചാൽ അവന്റെ അവകാശം അവന്റെ മകൾക്കു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","അവന്നു മകൾ ഇല്ലാതിരുന്നാൽ അവന്റെ അവകാശം അവന്റെ സഹോദരന്മാർക്കു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","അവന്നു സഹോദരന്മാർ ഇല്ലാതിരുന്നാൽ അവന്റെ അവകാശം അവന്റെ അപ്പന്റെ സഹോദരന്മാർക്കു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","അവന്റെ അപ്പന്നു സഹോദരന്മാർ ഇല്ലാതിരുന്നാൽ നിങ്ങൾ അവന്റെ കുടുംബത്തിൽ അവന്റെ അടുത്ത ചാർച്ചക്കാരന്നു അവന്റെ അവകാശം കൊടുക്കേണം; അവൻ അതു കൈവശമാക്കേണം; ഇതു യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ യിസ്രായേൽമക്കൾക്കു ന്യായപ്രമാണം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","അനന്തരം യഹോവ മോശെയോടു കല്പിച്ചതു: ഈ അബാരീംമലയിൽ കയറി ഞാൻ യിസ്രായേൽമക്കൾക്കു കൊടുത്തിരിക്കുന്ന ദേശം നോക്കുക. ");
INSERT INTO mal2015_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","അതു കണ്ടശേഷം നിന്റെ സഹോദരനായ അഹരോനെപ്പോലെ നീയും നിന്റെ ജനത്തോടു ചേരും. ");
INSERT INTO mal2015_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","സഭയുടെ കലഹത്തിങ്കൽ നിങ്ങൾ സീൻമരുഭൂമിയിൽവെച്ചു അവർ കാൺകെ വെള്ളത്തിന്റെ കാര്യത്തിൽ എന്നെ ശുദ്ധീകരിക്കാതെ എന്റെ കല്പനയെ മറുത്തതുകൊണ്ടു തന്നേ. സീൻമരുഭൂമിയിൽ കാദേശിലെ കലഹജലം അതു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","അപ്പോൾ മോശെ യഹോവയോടു: ");
INSERT INTO mal2015_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","യഹോവയുടെ സഭ ഇടയനില്ലാത്ത ആടുകളെപ്പോലെ ആകാതിരിപ്പാൻ തക്കവണ്ണം അവർക്കു മുമ്പായി പോകുവാനും അവർക്കു മുമ്പായി വരുവാനും അവരെ പുറത്തു കൊണ്ടുപോകുവാനും ");
INSERT INTO mal2015_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","അകത്തുകൊണ്ടു വരുവാനും സകലജഡത്തിന്റെയും ആത്മാക്കളുടെ ദൈവമായ യഹോവ സഭയുടെമേൽ ഒരാളെ നിയമിക്കുമാറാകട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","യഹോവ മോശെയോടു കല്പിച്ചതു: എന്റെ ആത്മാവുള്ള പുരുഷനായി നൂന്റെ മകനായ യോശുവയെ വിളിച്ചു അവന്റെ മേൽ കൈവെച്ചു ");
INSERT INTO mal2015_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","അവനെ പുരോഹിതനായ എലെയാസാരിന്റെയും സർവ്വസഭയുടെയും മുമ്പാകെ നിർത്തി അവർ കാൺകെ അവന്നു ആജ്ഞ കൊടുക്ക. ");
INSERT INTO mal2015_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","യിസ്രായേൽമക്കളുടെ സഭയെല്ലാം അനുസരിക്കേണ്ടതിന്നു നിന്റെ മഹിമയിൽ ഒരംശം അവന്റെ മേൽ വെക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","അവൻ പുരോഹിതനായ എലെയാസാരിന്റെ മുമ്പാകെ നില്ക്കേണം; അവൻ അവന്നുവേണ്ടി യഹോവയുടെ സന്നിധിയിൽ ഊരീംമുഖാന്തരം അരുളപ്പാടു ചോദിക്കേണം; അവനും യിസ്രായേൽമക്കളുടെ സർവ്വസഭയും അവന്റെ വാക്കുപ്രകാരം പോകയും അവന്റെ വാക്കുപ്രകാരം വരികയും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","യഹോവ തന്നോടു കല്പിച്ചതുപോലെ മോശെ ചെയ്തു; അവൻ യോശുവയെ വിളിച്ചു പുരോഹിതനായ എലെയാസാരിന്റെയും സർവ്വസഭയുടെയു മുമ്പാകെ നിർത്തി. ");
INSERT INTO mal2015_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","അവന്റെമേൽ കൈവെച്ചു യഹോവ മോശെമുഖാന്തരം കല്പിച്ചതുപോലെ അവന്നു ആജ്ഞ കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","എനിക്കു സൗരഭ്യവാസനയായ ദഹനയാഗങ്ങൾക്കുള്ള എന്റെ ഭോജനമായ വഴിപാടു തക്കസമയത്തു എനിക്കു അർപ്പിക്കേണ്ടതിന്നു ജാഗ്രതയായിരിപ്പാൻ യിസ്രായേൽമക്കളോടു കല്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","നീ അവരോടു പറയേണ്ടതു: നിങ്ങൾ യഹോവെക്കു അർപ്പിക്കേണ്ടുന്ന ദഹനയാഗം എന്തെന്നാൽ: നാൾതോറും നിരന്തരഹോമയാഗത്തിന്നായി ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത രണ്ടു കുഞ്ഞാടു. ");
INSERT INTO mal2015_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ഒരു കുഞ്ഞാടിനെ രാവിലേയും മറ്റെ കുഞ്ഞാടിനെ വൈകുന്നേരത്തും യാഗം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ഇടിച്ചെടുത്ത എണ്ണ കാൽ ഹീൻ ചേർത്ത ഒരിടങ്ങഴി മാവു ഭോജനയാഗമായും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ഇതു യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗമായി സീനായിപർവ്വതത്തിൽവെച്ചു നിയമിക്കപ്പെട്ട നിരന്തരഹോമയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","അതിന്റെ പാനീയയാഗം കുഞ്ഞാടൊന്നിന്നു കാൽ ഹീൻ മദ്യം ആയിരിക്കേണം; അതു യഹോവെക്കു പാനീയയാഗമായി വിശുദ്ധമന്ദിരത്തിൽ ഒഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","മറ്റെ കുഞ്ഞാടിനെ വൈകുന്നേരത്തു യാഗം കഴിക്കേണം; അതിനെ രാവിലത്തെ ഭോജനയാഗവും അതിന്റെ പാനീയയാഗവുംപോലെ യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗമായി അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","ശബ്ബത്ത്നാളിലോ ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത രണ്ടു കുഞ്ഞാടിനെയും ഭോജനയാഗത്തിന്നായി എണ്ണചേർത്ത രണ്ടിടങ്ങഴി മാവും അതിന്റെ പാനീയയാഗവും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ പാനീയയാഗത്തിന്നും പുറമെ ഇതു ശബ്ബത്തുതോറുമുള്ള ഹോമയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","നിങ്ങളുടെ മാസാരംഭങ്ങളിൽ നിങ്ങൾ യഹോവെക്കു ഹോമയാഗത്തിന്നായി രണ്ടു കാളക്കിടാവിനെയും ഒരു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഏഴു കുഞ്ഞാടിനെയും ");
INSERT INTO mal2015_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","കാള ഒന്നിന്നു ഭോജനയാഗമായി എണ്ണചേർത്ത മൂന്നിടങ്ങഴി മാവും ആട്ടുകൊറ്റന്നു ഭോജനയാഗമായി എണ്ണചേർത്ത രണ്ടിടങ്ങഴി മാവും ");
INSERT INTO mal2015_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","കുഞ്ഞാടൊന്നിന്നു ഭോജനയാഗമായി എണ്ണചേർത്ത ഒരിടങ്ങഴി മാവും അർപ്പിക്കേണം. അതു ഹോമയാഗം; യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗം തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","അവയുടെ പാനീയയാഗം കാളയൊന്നിന്നു അര ഹീൻ വീഞ്ഞും ആട്ടുകൊറ്റന്നു ഹീനിന്റെ മൂന്നിൽ ഒന്നും കുഞ്ഞാടൊന്നിന്നു കാൽ ഹീനും ആയിരിക്കേണം; ഇതു മാസാന്തരം അമാവാസിതോറുമുള്ള ഹോമയാഗം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ പാനീയയാഗത്തിന്നും പുറമെ പാപയാഗമായി യഹോവെക്കു ഒരു കോലാട്ടുകൊറ്റനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","ഒന്നാം മാസം പതിന്നാലാം തിയ്യതി യഹോവയുടെ പെസഹ ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ആ മാസം പതിനഞ്ചാം തിയ്യതി പെരുനാൾ ആയിരിക്കേണം. ഏഴു ദിവസം പുളിപ്പില്ലാത്ത അപ്പം തിന്നേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ഒന്നാം ദിവസം വിശുദ്ധസഭായോഗം കൂടേണം; അന്നു സാമാന്യവേലയൊന്നും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","എന്നാൽ നിങ്ങൾ യഹോവെക്കു ഹോമയാഗത്തിന്നായി രണ്ടു കാളക്കിടാവിനെയും ഒരു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഏഴു കുഞ്ഞാടിനെയും ദഹനയാഗമായി അർപ്പിക്കേണം; അവ ഊനമില്ലാത്തവ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","അവയുടെ ഭോജനയാഗം എണ്ണ ചേർത്ത മാവു ആയിരിക്കേണം; കാള ഒന്നിന്നു മൂന്നിടങ്ങഴിയും ആട്ടുകൊറ്റന്നു രണ്ടിടങ്ങഴിയും ");
INSERT INTO mal2015_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ഏഴു കുഞ്ഞാട്ടിൽ ഓരോന്നിന്നു ഓരോ ഇടങ്ങഴിയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","നിങ്ങൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിപ്പാൻ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടിനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","നിരന്തരഹോമയാഗമായ രാവിലത്തെ ഹോമയാഗത്തിന്നു പുറമെ ഇവ അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ഇങ്ങനെ ഏഴു നാളും യഹോവെക്കു സൗരഭ്യവാസനയായി ദഹനയാഗത്തിന്റെ ഭോജനം ദിവസംപ്രതി അർപ്പിക്കേണം. നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ പാനീയയാഗത്തിന്നും പുറമെ ഇതു അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ഏഴാം ദിവസം വിശുദ്ധസഭായോഗം കൂടേണം; അന്നു സാമാന്യവേലയൊന്നും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","വാരോത്സവമായ ആദ്യഫലദിവസത്തിൽ പുതിയധാന്യംകൊണ്ടു ഒരു ഭോജനയാഗം കൊണ്ടുവരുമ്പോഴും വിശുദ്ധസഭായോഗം കൂടേണം. അന്നു സാമാന്യവേലയൊന്നും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","എന്നാൽ നിങ്ങൾ യഹോവെക്കു സൗരഭ്യവാസനയായ ഹോമയാഗത്തിന്നായി രണ്ടു കാളക്കിടാവിനെയും ഒരു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഏഴു കുഞ്ഞാടിനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","അവയുടെ ഭോജനയാഗമായി എണ്ണചേർത്ത മാവു, കാള ഒന്നിന്നു ഇടങ്ങഴി മൂന്നും ആട്ടുകൊറ്റന്നു ഇടങ്ങഴി രണ്ടും ");
INSERT INTO mal2015_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ഏഴു കുഞ്ഞാട്ടിൽ ഓരോന്നിന്നു ഇടങ്ങഴി ഓരോന്നും ");
INSERT INTO mal2015_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","നിങ്ങൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിപ്പാൻ ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും അവയുടെ പാനീയയാഗത്തിന്നും പുറമെ നിങ്ങൾ ഇവ അർപ്പിക്കേണം; അവ ഊനമില്ലാത്തവ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","ഏഴാം മാസം ഒന്നാം തിയ്യതി വിശുദ്ധസഭായോഗം കൂടേണം; അന്നു സാമാന്യവേലയൊന്നും ചെയ്യരുതു; അതു നിങ്ങൾക്കു കാഹളനാദോത്സവം ആകുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","അന്നു നിങ്ങൾ യഹോവെക്കു സൊരഭ്യവാസനയായ ഹോമയാഗമായി ഒരു കാളക്കിടാവിനെയും ഒരു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഏഴു കുഞ്ഞാടിനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","അവയുടെ ഭോജനയാഗം എണ്ണചേർത്ത മാവു കാളെക്കു ഇടങ്ങഴി മൂന്നും ആട്ടുകൊറ്റന്നു ഇടങ്ങഴി രണ്ടും, ");
INSERT INTO mal2015_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ഏഴു കുഞ്ഞാട്ടിൽ ഓരോന്നിന്നു ഇടങ്ങഴി ഓരോന്നും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","നിങ്ങൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിപ്പാൻ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","അമാവാസിയിലെ ഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും നാൾതോറുമുള്ള ഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും അവെക്കു നിയമപ്രകാരമുള്ള പാനീയയാഗങ്ങൾക്കും പുറമെ യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗമായി തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","ഏഴാം മാസം പത്താം തിയ്യതി വിശുദ്ധസഭായോഗം കൂടേണം; അന്നു നിങ്ങൾ ആത്മതപനം ചെയ്യേണം; വേലയൊന്നും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","എന്നാൽ യഹോവെക്കു സുഗന്ധവാസനയായ ഹോമയാഗമായി ഒരു കാളക്കിടാവിനെയും ഒരു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഏഴു കുഞ്ഞാടിനെയും അർപ്പിക്കേണം; അവ ഊനമില്ലാത്തവ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","അവയുടെ ഭോജനയാഗം എണ്ണചേർത്ത മാവു കാളെക്കു ഇടങ്ങഴി മൂന്നും ആട്ടുകൊറ്റന്നു ഇടങ്ങഴി രണ്ടും ");
INSERT INTO mal2015_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ഏഴു കുഞ്ഞാട്ടിൽ ഓരോന്നിന്നു ഇടങ്ങഴി ഓരോന്നും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","പ്രായശ്ചിത്തയാഗത്തിന്നും നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും പാനീയയാഗങ്ങൾക്കും പുറമെ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റന്നും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","ഏഴാം മാസം പതിനഞ്ചാം തിയ്യതി വിശുദ്ധസഭായോഗം കൂടേണം; അന്നു സാമാന്യവേലയൊന്നും ചെയ്യരുതു; ഏഴു ദിവസം യഹോവെക്കു ഉത്സവം ആചരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","നിങ്ങൾ യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗമായി പതിമൂന്നു കാളക്കിടാവിനെയും രണ്ടു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള പതിന്നാലു കുഞ്ഞാടിനെയും ഹോമയാഗം കഴിക്കേണം; അവ ഊനമില്ലാത്തവ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","അവയുടെ ഭോജനയാഗം പതിമൂന്നു കാളയിൽ ഓരോന്നിന്നു എണ്ണചേർത്ത മാവു ഇടങ്ങഴി മുമ്മൂന്നും രണ്ടു ആട്ടുകൊറ്റനിൽ ഓരോന്നിന്നു ഇടങ്ങഴി ഈരണ്ടും ");
INSERT INTO mal2015_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","പതിന്നാലു കുഞ്ഞാട്ടിൽ ഓരോന്നിന്നും ഇടങ്ങഴി ഓരോന്നും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും അതിന്റെ പാനീയയാഗങ്ങൾക്കും പുറമെ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","രണ്ടാം ദിവസം നിങ്ങൾ പന്ത്രണ്ടു കാളക്കിടാവിനെയും രണ്ടു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത പതിന്നാലു കുഞ്ഞാടിനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","അവയുടെ ഭോജനയാഗവും പാനീയയാഗങ്ങളും കാള, ആട്ടുകൊറ്റൻ, കുഞ്ഞാടു എന്നിവയുടെ എണ്ണംപോലെയും നിയമംപോലെയും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും പാനീയയാഗങ്ങൾക്കും പുറമെ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","മൂന്നാം ദിവസം പതിനൊന്നു കാളയെയും രണ്ടു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത പതിന്നാലു കുഞ്ഞാടിനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","അവയുടെ ഭോജനയാഗവും പാനീയയാഗങ്ങളും കാള, ആട്ടുകൊറ്റൻ, കുഞ്ഞാടു എന്നിവയുടെ എണ്ണംപോലെയും നിയമംപോലെയും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും പാനീയയാഗങ്ങൾക്കും പുറമെ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","നാലാം ദിവസം പത്തു കാളയെയും രണ്ടു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സുപ്രായമുള്ള ഊനമില്ലാത്ത പതിന്നാലു കുഞ്ഞാടിനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","അവയുടെ ഭോജനയാഗവും പാനീയയാഗങ്ങളും കാള, ആട്ടുകൊറ്റൻ, കുഞ്ഞാടു എന്നിവയുടെ എണ്ണംപോലെയും നിയമംപോലെയും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും പാനീയയാഗങ്ങൾക്കും പുറമെ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","അഞ്ചാം ദിവസം ഒമ്പതു കാളയെയും രണ്ടു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത പതിന്നാലു കുഞ്ഞാടിനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","അവയുടെ ഭോജനയാഗവും പാനീയയാഗങ്ങളും കാള, ആട്ടുകൊറ്റൻ, കുഞ്ഞാടു എന്നിവയുടെ എണ്ണംപോലെയും നിയമംപോലെയും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും പാനീയയാഗങ്ങൾക്കും പുറമെ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","ആറാം ദിവസം എട്ടു കാളയെയും രണ്ടു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത പതിന്നാലും കുഞ്ഞാടിനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","അവയുടെ ഭോജനയാഗവും പാനീയയാഗങ്ങളും കാള, ആട്ടുകൊറ്റൻ, കുഞ്ഞാടു എന്നിവയുടെ എണ്ണംപോലെയും നിയമംപോലെയും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും പാനീയയാഗങ്ങൾക്കും പുറമെ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","ഏഴാം ദിവസം ഏഴു കാളയെയും രണ്ടു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത പതിന്നാലു കുഞ്ഞാടിനെയും അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","അവയുടെ ഭോജനയാഗവും പാനീയയാഗങ്ങളും കാള, ആട്ടുകൊറ്റൻ, കുഞ്ഞാടു എന്നിവയുടെ എണ്ണംപോലെയും നിയമംപോലെയും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും പാനീയയാഗങ്ങൾക്കും പുറമെ പാപയാഗത്തിന്നായി ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","എട്ടാം ദിവസം നിങ്ങൾക്കു അന്ത്യയോഗം ഉണ്ടാകേണം; അന്നു സാമാന്യവേലയൊന്നും ചെയ്യരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","എന്നാൽ യഹോവെക്കു സൗരഭ്യവാസനയായ ദഹനയാഗമായി ഒരു കാളയെയും ഒരു ആട്ടുകൊറ്റനെയും ഒരു വയസ്സു പ്രായമുള്ള ഊനമില്ലാത്ത ഏഴു കുഞ്ഞാടിനെയും ഹോമയാഗം കഴിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","അവയുടെ ഭോജനയാഗവും പാനീയയാഗങ്ങളും കാള, ആട്ടുകൊറ്റൻ, കുഞ്ഞാടു എന്നിവയുടെ എണ്ണംപോലെയും നിയമംപോലെയും ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","നിരന്തരഹോമയാഗത്തിന്നും അതിന്റെ ഭോജനയാഗത്തിന്നും പാനീയയാഗങ്ങൾക്കും പുറമെ പാപയാഗത്തിന്നായിട്ടു ഒരു കോലാട്ടുകൊറ്റനും വേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","ഇവയെ നിങ്ങൾ നിങ്ങളുടെ നേർച്ചകളും സ്വമേധാദാനങ്ങളുമായ ഹോമയാഗങ്ങൾക്കും ഭോജനയാഗങ്ങൾക്കും പാനീയയാഗങ്ങൾക്കും പുറമെ നിങ്ങളുടെ ഉത്സവങ്ങളിൽ യഹോവെക്കു അർപ്പിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","യഹോവ മോശെയോടു കല്പിച്ചതു ഒക്കെയും മോശെ യിസ്രായേൽമക്കളോടു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","മോശെ യിസ്രായേൽമക്കളുടെ ഗോത്രപ്രധാനികളോടു പറഞ്ഞതു: യഹോവ കല്പിച്ചിരിക്കുന്ന കാര്യം എന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ആരെങ്കിലും യഹോവെക്കു ഒരു നേർച്ച നേരുകയോ ഒരു പരിവർജ്ജനവ്രതം ദീക്ഷിപ്പാൻ ശപഥം ചെയ്കയോ ചെയ്താൽ അവൻ വാക്കിന്നു ഭംഗംവരുത്താതെ തന്റെ വായിൽനിന്നു പുറപ്പെട്ടതുപോലെ ഒക്കെയും നിവർത്തിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","ഒരു സ്ത്രീ ബാല്യപ്രായത്തിൽ അപ്പന്റെ വീട്ടിൽ ഇരിക്കുമ്പോൾ യഹോവെക്കു ഒരു നേർച്ചനേർന്നു ഒരു പരിവർജ്ജനവ്രതം നിശ്ചയിക്കയും ");
INSERT INTO mal2015_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","അവളുടെ അപ്പൻ അവളുടെ നേർച്ചയെയും അവൾ നിശ്ചയിച്ച പരിവർജ്ജനവ്രതത്തെയും കുറിച്ചു കേട്ടിട്ടു മിണ്ടാതിരിക്കയും ചെയ്താൽ അവളുടെ എല്ലാനേർച്ചകളും അവൾ നിശ്ചയിച്ച പരിവർജ്ജനവ്രതമൊക്കെയും സ്ഥിരമായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","എന്നാൽ അവളുടെ അപ്പൻ അവളുടെ എല്ലാനേർച്ചയെയും അവൾ നിശ്ചയിച്ച പരിവർജ്ജനവ്രതത്തെയും കുറിച്ചു കേൾക്കുന്ന നാളിൽ അവളോടു വിലക്കിയാൽ അവ സ്ഥിരമായിരിക്കയില്ല; അവളുടെ അപ്പൻ അവളോടു വിലക്കുകകൊണ്ടു യഹോവ അവളോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","അവൾക്കു ഒരു നേർച്ചയോ വിചാരിക്കാതെ നിശ്ചയിച്ചുപോയ പരിവർജ്ജനവ്രതമോ ഉള്ളപ്പോൾ ");
INSERT INTO mal2015_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","അവൾ ഒരുത്തന്നു ഭാര്യയാകയും ഭർത്താവു അതിനെക്കുറിച്ചു കേൾക്കുന്ന നാളിൽ മിണ്ടാതിരിക്കയും ചെയ്താൽ അവളുടെ നേർച്ചകളും അവൾ നിശ്ചയിച്ച പരിവർജ്ജനവ്രതവും സ്ഥിരമായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","എന്നാൽ ഭർത്താവു അതു കേട്ട നാളിൽ അവളോടു വിലക്കിയാൽ അവളുടെ നേർച്ചയും അവൾ വിചാരിക്കാതെ നിശ്ചയിച്ചുപോയ പരിവർജ്ജനവ്രതവും അവൻ ദുർബ്ബലപ്പെടുത്തുന്നു; യഹോവ അവളോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","വിധവയോ ഉപേക്ഷിക്കപ്പെട്ടവളോ ചെയ്യുന്ന നേർച്ചയും പരിവർജ്ജനവ്രതവും എല്ലാം അവളുടെ മേൽ സ്ഥിരമായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","അവൾ ഭർത്താവിന്റെ വീട്ടിൽവെച്ചു നേരുകയോ ഒരു പരിവർജ്ജനശപഥം ചെയ്കയോ ചെയ്തിട്ടു ");
INSERT INTO mal2015_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ഭർത്താവു അതിനെക്കുറിച്ചു കേൾക്കുമ്പോൾ മിണ്ടാതെയും അവളോടു വിലക്കാതെയും ഇരുന്നാൽ അവളുടെ നേർച്ചകൾ ഒക്കെയും അവൾ നിശ്ചയിച്ച പരിവർജ്ജനവ്രതവും എല്ലാം സ്ഥിരമായിരിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","എന്നാൽ ഭർത്താവു കേട്ട നാളിൽ അവയെ ദുർബ്ബലപ്പെടുത്തി എങ്കിൽ നേർച്ചകളോ പരിവർജ്ജനവ്രതമോ സംബന്ധിച്ചു അവളുടെ നാവിന്മേൽനിന്നു വീണതൊന്നും സ്ഥിരമായിരിക്കയില്ല; അവളുടെ ഭർത്താവു അതിനെ ദുർബ്ബലപ്പെടുത്തിയിരിക്കുന്നു; യഹോവ അവളോടു ക്ഷമിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ആത്മതപനം ചെയ്‌വാനുള്ള ഏതു നേർച്ചയും പരിവർജ്ജനശപഥവും സ്ഥിരപ്പെടുത്തുവാനോ ദുർബ്ബലപ്പെടുത്തുവാനോ ഭർത്താവിന്നു അധികാരം ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","എന്നാൽ ഭർത്താവു ഒരിക്കലും ഒന്നും മിണ്ടിയില്ല എങ്കിൽ അവൻ അവളുടെ എല്ലാനേർച്ചയും അവൾ നിശ്ചയിച്ച സകലപരിവർജ്ജനവ്രതവും സ്ഥിരപ്പെടുത്തുന്നു. കേട്ട നാളിൽ മിണ്ടാതിരിക്കകൊണ്ടു അവൻ അവയെ സ്ഥിരപ്പെടുത്തിയിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","എന്നാൽ കേട്ടിട്ടു കുറെ കഴിഞ്ഞശേഷം അവയെ ദുർബ്ബലപ്പെടുത്തിയാൽ അവൻ അവളുടെ കുറ്റം വഹിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ഭാര്യാഭർത്താക്കന്മാർ തമ്മിലും അപ്പന്റെ വീട്ടിൽ കന്യകയായി പാർക്കുന്ന മകളും അപ്പനും തമ്മിലും പ്രമാണിക്കേണ്ടതിന്നു യഹോവ മോശെയോടു കല്പിച്ച ചട്ടങ്ങൾ ഇവ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","അനന്തരം യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","യിസ്രായേൽമക്കൾക്കു വേണ്ടി മിദ്യാന്യരോടു പ്രതികാരം നടത്തുക; അതിന്റെ ശേഷം നീ നിന്റെ ജനത്തോടു ചേരും. ");
INSERT INTO mal2015_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","അപ്പോൾ മോശെ ജനത്തോടു സംസാരിച്ചു: മിദ്യാന്യരുടെ നേരെ പുറപ്പെട്ടു യഹോവെക്കുവേണ്ടി മിദ്യാനോടു പ്രതികാരം നടത്തേണ്ടതിന്നു നിങ്ങളിൽനിന്നു ആളുകളെ യുദ്ധത്തിന്നു ഒരുക്കുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","നിങ്ങൾ യിസ്രായേലിന്റെ സകലഗോത്രങ്ങളിലും ഓരോന്നിൽനിന്നു ആയിരംപേരെ വീതം യുദ്ധത്തിന്നു അയക്കേണം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","അങ്ങനെ യിസ്രായേല്യസഹസ്രങ്ങളിൽനിന്നു ഓരോ ഗോത്രത്തിൽ ആയിരം പേർ വീതം പന്തീരായിരം പേരെ യുദ്ധസന്നദ്ധരായി വേർതിരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","മോശെ ഓരോ ഗോത്രത്തിൽനിന്നു ആയിരം പേർ വീതമുള്ള അവരെയും പുരോഹിതനായ എലെയാസാരിന്റെ മകൻ ഫീനെഹാസിനെയും യുദ്ധത്തിന്നു അയച്ചു; അവന്റെ കൈവശം വിശുദ്ധമന്ദിരത്തിലെ ഉപകരണങ്ങളും ഗംഭീരനാദകാഹളങ്ങളും ഉണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ അവർ മിദ്യാന്യരോടു യുദ്ധം ചെയ്തു ആണുങ്ങളെ ഒക്കെയും കൊന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","നിഹതന്മാരുടെ കൂട്ടത്തിൽ അവർ മിദ്യാന്യരാജാക്കന്മാരായ ഏവി, രേക്കെം, സൂർ, ഹൂർ, രേബ എന്നീ അഞ്ചു രാജാക്കന്മാരെയും കൊന്നു; ബെയോരിന്റെ മകനായ ബിലെയാമിനെയും അവർ വാളുകൊണ്ടു കൊന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","യിസ്രായേൽമക്കൾ മിദ്യാന്യസ്ത്രീകളെയും അവരുടെ കുഞ്ഞുങ്ങളെയും ബദ്ധരാക്കി; അവരുടെ സകലവാഹനമൃഗങ്ങളെയും ആടുമാടുകളെയും അവരുടെ സമ്പത്തൊക്കെയും കൊള്ളയിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","അവർ പാർത്തിരുന്ന എല്ലാപട്ടണങ്ങളും എല്ലാപാളയങ്ങളും തീയിട്ടു ചുട്ടുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","അവർ എല്ലാകൊള്ളയും മനുഷ്യരും മൃഗങ്ങളുമായുള്ള അപഹൃതമൊക്കെയും എടുത്തു; ");
INSERT INTO mal2015_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ബദ്ധന്മാരെ അപഹൃതത്തോടും കൊള്ളയോടുംകൂടെ യെരീഹോവിന്റെ സമീപത്തു യോർദ്ദാന്നരികെയുള്ള മോവാബ്സമഭൂമിയിൽ പാളയത്തിലേക്കു മോശെയുടെയും പുരോഹിതനായ എലെയാസാരിന്റെയും യിസ്രായേൽസഭയുടെയും അടുക്കൽ കൊണ്ടു വന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","മോശെയും പുരോഹിതൻ എലെയാസാരും സഭയുടെ സകലപ്രഭുക്കന്മാരും പാളയത്തിന്നു പുറത്തു അവരെ എതിരേറ്റു ചെന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","എന്നാൽ മോശെ യുദ്ധത്തിൽനിന്നു വന്നിട്ടുള്ള സഹസ്രാധിപന്മാരും ശതാധിപന്മാരുമായ സൈന്യനായകന്മാരോടു കോപിച്ചു പറഞ്ഞതെന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","നിങ്ങൾ സ്ത്രീകളെയെല്ലാം ജീവനോടെ വെച്ചിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ഇവരത്രേ പെയോരിന്റെ സംഗതിയിൽ ബിലെയാമിന്റെ ഉപദേശത്താൽ യിസ്രായേൽമക്കൾ യഹോവയോടു ദ്രോഹം ചെയ്‌വാനും യഹോവയുടെ സഭയിൽ ബാധ ഉണ്ടാവാനും ഹേതുവായതു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ആകയാൽ ഇപ്പോൾ കുഞ്ഞുങ്ങളിലുള്ള ആണിനെയൊക്കെയും പുരുഷനോടുകൂടെ ശയിച്ചിട്ടുള്ള സകലസ്ത്രീകളെയും കൊന്നുകളവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","പുരുഷനോടുകൂടെ ശയിക്കാത്ത പെൺകുഞ്ഞുങ്ങളെ ജീവനോടു വെച്ചുകൊൾവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","നിങ്ങൾ ഏഴു ദിവസം പാളയത്തിന്നു പുറത്തു പാർക്കേണം; ഒരുത്തനെ കൊന്നവനും കൊല്ലപ്പെട്ടവനെ തൊട്ടവനുമെല്ലാം മൂന്നാം ദിവസവും ഏഴാം ദിവസവും തങ്ങളെയും തങ്ങളുടെ ബദ്ധന്മാരെയും ശുദ്ധീകരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","സകലവസ്ത്രവും തോൽകൊണ്ടുള്ള എല്ലാകോപ്പും കോലാട്ടുരോമം കൊണ്ടുണ്ടാക്കിയതൊക്കെയും മരംകൊണ്ടുള്ള സകലസാധനവും ശുദ്ധീകരിപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","പുരോഹിതനായ എലെയാസാർ യുദ്ധത്തിന്നു പോയിരുന്ന യോദ്ധാക്കളോടു പറഞ്ഞതു: യഹോവ മോശെയോടു കല്പിച്ചിട്ടുള്ള ന്യായപ്രമാണം ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","പൊന്നു, വെള്ളി, ചെമ്പു, ഇരിമ്പു, ");
INSERT INTO mal2015_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","വെള്ളീയും, കാരീയം, മുതലായി തീയിൽ നശിച്ചുപോകാത്ത സാധനമൊക്കെയും തീയിൽ ഇട്ടെടുക്കേണം; എന്നാൽ അതു ശുദ്ധമാകും; എങ്കിലും ശുദ്ധീകരണജലത്താലും അതു ശുദ്ധീകരിക്കേണം. തീയിൽ നശിച്ചുപോകുന്നതെല്ലാം നിങ്ങൾ വെള്ളത്തിൽ മുക്കിയെടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ഏഴാം ദിവസം വസ്ത്രം അലക്കി ശുദ്ധിയുള്ളവരായശേഷം നിങ്ങൾക്കു പാളയത്തിലേക്കു വരാം. ");
INSERT INTO mal2015_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","പിന്നെ യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","നീയും പുരോഹിതനായ എലെയാസാരും സഭയിലെ ഗോത്രപ്രധാനികളും കൊള്ളയായി പിടിക്കപ്പെട്ട മനുഷ്യരുടെയും മൃഗങ്ങളുടെയും തുകനോക്കി ");
INSERT INTO mal2015_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","പടെക്കുപോയ യോദ്ധാക്കൾക്കും സഭെക്കും ഇങ്ങനെ രണ്ടു ഓഹരിയായി കൊള്ള വിഭാഗിപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","യുദ്ധത്തിന്നു പോയ യോദ്ധാക്കളോടു മനുഷ്യരിലും മാടു, കഴുത, ആടു എന്നിവയിലും അഞ്ഞൂറ്റിൽ ഒന്നു യഹോവയുടെ ഓഹരിയായി വാങ്ങേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","അവർക്കുള്ള പാതിയിൽനിന്നു അതു എടുത്തു യഹോവെക്കു ഉദർച്ചാർപ്പണമായി പുരോഹിതനായ എലെയാസാരിന്നു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","എന്നാൽ യിസ്രായേൽമക്കൾക്കുള്ള പാതിയിൽനിന്നു മനുഷ്യരിലും മാടു, കഴുത, ആടു മുതലായ സകലവിധമൃഗത്തിലും അമ്പതിൽ ഒന്നു എടുത്തു യഹോവയുടെ തിരുനിവാസത്തിലെ വേലചെയ്യുന്ന ലേവ്യർക്കു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ മോശെയും എലെയാസാരും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","യോദ്ധാക്കൾ കൈവശമാക്കിയതിന്നു പുറമെയുള്ള കൊള്ള ആറു ലക്ഷത്തെഴുപത്തയ്യായിരം ആടും ");
INSERT INTO mal2015_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","എഴുപത്തീരായിരം മാടും ");
INSERT INTO mal2015_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","അറുപത്തോരായിരം കഴുതയും ");
INSERT INTO mal2015_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","പുരുഷനോടുകൂടെ ശയിക്കാത്ത പെണ്ണുങ്ങൾ എല്ലാംകൂടി മുപ്പത്തീരായിരംപേരും ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","യുദ്ധത്തിന്നു പോയവരുടെ ഓഹരിക്കുള്ള പാതിയിൽ ആടു മൂന്നുലക്ഷത്തി മുപ്പത്തേഴായിരത്തഞ്ഞൂറു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ആടിൽ യഹോവെക്കുള്ള ഓഹരി അറുനൂറ്റെഴുപത്തഞ്ചു; ");
INSERT INTO mal2015_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","കന്നുകാലി മുപ്പത്താറായിരം; അതിൽ യഹോവെക്കുള്ള ഓഹരി എഴുപത്തുരണ്ടു; ");
INSERT INTO mal2015_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","കഴുത മുപ്പതിനായിരത്തഞ്ഞൂറു; അതിൽ യഹോവെക്കുള്ള ഓഹരി അറുപത്തൊന്നു; ");
INSERT INTO mal2015_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ആൾ പതിനാറായിരം; അവരിൽ യഹോവെക്കുള്ള ഓഹരി മുപ്പത്തിരണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","യഹോവെക്കു ഉദർച്ചാർപ്പണമായിരുന്ന ഓഹരി യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ മോശെ പുരോഹിതനായ എലെയാസാരിന്നു കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","മോശെ പടയാളികളുടെ പക്കൽ നിന്നു യിസ്രായേൽമക്കൾക്കു വിഭാഗിച്ചുകൊടുത്ത പാതിയിൽനിന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","സഭെക്കുള്ള പാതി മൂന്നു ലക്ഷത്തി മുപ്പത്തേഴായിരത്തഞ്ഞൂറു ആടും ");
INSERT INTO mal2015_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","മുപ്പത്താറായിരം മാടും ");
INSERT INTO mal2015_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","മുപ്പതിനായിരത്തഞ്ഞൂറു കഴുതയും ");
INSERT INTO mal2015_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","പതിനാറായിരം ആളും ആയിരുന്നു - ");
INSERT INTO mal2015_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","യിസ്രായേൽമക്കളുടെ പാതിയിൽനിന്നു മോശെ മനുഷ്യരിലും മൃഗങ്ങളിലും അമ്പതിൽ ഒന്നു എടുത്തു യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ യഹോവയുടെ തിരുനിവാസത്തിലെ വേല ചെയ്യുന്ന ലേവ്യർക്കു കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","പിന്നെ സൈന്യസഹസ്രങ്ങൾക്കു നായകന്മാരായ സഹസ്രാധിപന്മാരും ശതാധിപന്മാരും മോശെയുടെ അടുക്കൽ വന്നു മോശെയോടു: ");
INSERT INTO mal2015_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","അടിയങ്ങൾ അടിയങ്ങളുടെ കീഴുള്ള യോദ്ധാക്കളുടെ തുക നോക്കി, ഒരുത്തനും കുറഞ്ഞു പോയിട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","അതുകൊണ്ടു ഞങ്ങൾക്കു ഓരോരുത്തന്നു കിട്ടിയ പൊന്നാഭരണങ്ങളായ മാല, കൈവള, മോതിരം, കുണുക്കു, കടകം എന്നിവ യഹോവയുടെ സന്നിധിയിൽ ഞങ്ങൾക്കുവേണ്ടി പ്രായശ്ചിത്തം കഴിക്കേണ്ടതിന്നു ഞങ്ങൾ യഹോവെക്കു വഴിപാടായി കൊണ്ടുവന്നിരിക്കുന്നു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","മോശെയും പുരോഹിതനായ എലെയാസാരും വിചിത്രപ്പണിയുള്ള ആഭരണങ്ങളായ പൊന്നു അവരോടു വാങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","സഹസ്രാധിപന്മാരും ശതാധിപന്മാരും യഹോവെക്കു ഉദർച്ചാർപ്പണം ചെയ്ത പൊന്നു എല്ലാംകൂടെ പതിനാറായിരത്തെഴുനൂറ്റമ്പതു ശേക്കെൽ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","യോദ്ധാക്കളിൽ ഒരോരുത്തന്നും താന്താന്നു വേണ്ടി കൊള്ളയിട്ടു എടുത്തിട്ടുണ്ടായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","മോശെയും പുരോഹിതനായ എലെയാസാരും സഹാസ്രാധിപന്മാരോടും ശതാധിപന്മാരോടും ആ പൊന്നു വാങ്ങി യഹോവയുടെ സന്നിധിയിൽ യിസ്രായേൽമക്കളുടെ ഓർമ്മെക്കായി സമാഗമനകൂടാരത്തിൽ കൊണ്ടുപോയി. ");
INSERT INTO mal2015_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","എന്നാൽ രൂബേന്യർക്കും ഗാദ്യർക്കും എത്രയും വളരെ ആടുമാടുകൾ ഉണ്ടായിരുന്നു; അവർ യസേർദേശവും ഗിലെയാദ്‌ദേശവും ആടുമാടുകൾക്കു കൊള്ളാകുന്ന സ്ഥലം എന്നു കണ്ടിട്ടു വന്നു ");
INSERT INTO mal2015_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","മോശെയൊടും പുരോഹിതനായ എലെയാസാരിനോടും സഭയിലെ പ്രഭുക്കന്മാരോടും സംസാരിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","അതാരോത്ത്, ദീബോൻ, യസേർ, നിമ്രാ, ഹെശ്ബോൻ, എലെയാലേ, സെബാം, നെബോ, ബെയോൻ ");
INSERT INTO mal2015_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","എന്നിങ്ങനെ യഹോവ യിസ്രായേൽസഭയുടെ മുമ്പിൽ ജയിച്ചടക്കിയ ദേശം ആടുമാടുകൾക്കു കൊള്ളാകുന്ന പ്രദേശം; അടിയങ്ങൾക്കോ ആടുമാടുകൾ ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","അതുകൊണ്ടു നിനക്കു അടിയങ്ങളോടു കൃപയുണ്ടെങ്കിൽ ഈ ദേശം അടിയങ്ങൾക്കു അവകാശമായി തരേണം; ഞങ്ങളെ യോർദ്ദാന്നക്കരെ കൊണ്ടുപോകരുതേ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","മോശെ ഗാദ്യരോടും രൂബേന്യരോടും പറഞ്ഞതു: നിങ്ങളുടെ സഹോദരന്മാർ യുദ്ധത്തിന്നു പോകുമ്പോൾ നിങ്ങൾക്കു ഇവിടെ ഇരിക്കേണമെന്നോ? ");
INSERT INTO mal2015_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","യഹോവ യിസ്രായേൽമക്കൾക്കു കൊടുത്തിട്ടുള്ള ദേശത്തേക്കു അവർ കടക്കാതിരിപ്പാൻ തക്കവണ്ണം നിങ്ങൾ അവരെ അധൈര്യപ്പെടുത്തുന്നതു എന്തിന്നു? ");
INSERT INTO mal2015_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ഒറ്റുനോക്കേണ്ടതിന്നു ഞാൻ നിങ്ങളുടെ പിതാക്കന്മാരെ കാദേശ്ബർന്നേയയിൽനിന്നു അയച്ചപ്പോൾ അവർ ഇങ്ങനെ തന്നേ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","അവർ എസ്കോൽ താഴ്‌വരയൊളം ചെന്നു ദേശം കണ്ടശേഷം യഹോവ യിസ്രായേൽമക്കൾക്കു കൊടുത്തിട്ടുള്ള ദേശത്തേക്കു പോകാതിരിക്കത്തക്കവണ്ണം അവരെ അധൈര്യപ്പെടുത്തി. ");
INSERT INTO mal2015_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","അന്നു യഹോവയുടെ കോപം ജ്വലിച്ചു; അവൻ സത്യംചെയ്തു കല്പിച്ചതു: ");
INSERT INTO mal2015_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","കെനിസ്യനായ യെഫുന്നെയുടെ മകൻ കാലേബും നൂന്റെ മകൻ യോശുവയും യഹോവയോടു പൂർണ്ണമായി പറ്റിനിന്നതുകൊണ്ടു ");
INSERT INTO mal2015_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","അവരല്ലാതെ മിസ്രയീമിൽനിന്നു പോന്നവരിൽ ഇരുപതു വയസ്സുമുതൽ മേലോട്ടുള്ള ഒരുത്തനും ഞാൻ അബ്രാഹാമിനോടും യിസ്ഹാക്കിനോടും യാക്കോബിനോടും സത്യം ചെയ്ത ദേശത്തെ കാണുകയില്ല; അവർ എന്നോടു പൂർണ്ണമായി പറ്റിനില്ക്കായ്കകൊണ്ടു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","അങ്ങനെ യഹോവയുടെ കോപം യിസ്രായേലിന്റെ നേരെ ജ്വലിച്ചു; യഹോവെക്കു അനിഷ്ടമായുള്ളതു ചെയ്ത തലമുറ എല്ലാം മുടിഞ്ഞുപോകുവോളം അവൻ നാല്പതു സംവത്സരം അവരെ മരുഭൂമിയിൽ അലയുമാറാക്കി. ");
INSERT INTO mal2015_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","എന്നാൽ യിസ്രായേലിന്റെ നേരെ യഹോവയുടെ ഉഗ്രകോപം ഇനിയും വർദ്ധിപ്പാൻ തക്കവണ്ണം നിങ്ങളുടെ പിതാക്കന്മാർക്കു പകരം നിങ്ങൾ പാപികളുടെ ഒരു കൂട്ടമായി എഴുന്നേറ്റിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","നിങ്ങൾ അവനെ വിട്ടു പിന്നോക്കം പോയാൽ അവൻ ഇനിയും അവരെ മരുഭൂമിയിൽ വിട്ടുകളയും; അങ്ങനെ നിങ്ങൾ ഈ ജനത്തെയെല്ലാം നശിപ്പിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","അപ്പോൾ അവർ അടുത്തുചെന്നു പറഞ്ഞതു: ഞങ്ങൾ ഇവിടെ ഞങ്ങളുടെ ആടുമാടുകൾക്കു തൊഴുത്തുകളും ഞങ്ങളുടെ കുഞ്ഞുകുട്ടികൾക്കു പട്ടണങ്ങളും പണിയട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","എങ്കിലും യിസ്രായേൽമക്കളെ അവരുടെ സ്ഥലത്തു കൊണ്ടുപോയി ആക്കുന്നതുവരെ ഞങ്ങൾ യുദ്ധസന്നദ്ധരായി അവർക്കു മുമ്പായി നടക്കും; ഞങ്ങളുടെ കുഞ്ഞുകുട്ടികളോ ദേശത്തിലെ നിവാസികൾ നിമിത്തം ഉറപ്പുള്ള പട്ടണങ്ങളിൽ പാർക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","യിസ്രായേൽമക്കൾ ഓരോരുത്തൻ താന്താന്റെ അവകാശം അടക്കിക്കൊള്ളുംവരെ ഞങ്ങൾ ഞങ്ങളുടെ വീടുകളിലേക്കു മടങ്ങിപ്പോരികയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","യോർദ്ദാന്നക്കരെയും അതിന്നപ്പുറവും ഞങ്ങൾ അവരോടുകൂടെ അവകാശം വാങ്ങുകയില്ല; കിഴക്കു യോർദ്ദാന്നിക്കരെ ഞങ്ങൾക്കു അവകാശം ഉണ്ടല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","അതിന്നു മോശെ അവരോടു പറഞ്ഞതു: നിങ്ങൾ ഈ കാര്യം ചെയ്യുമെങ്കിൽ, യഹോവയുടെ മുമ്പാകെ യുദ്ധസന്നദ്ധരായി പുറപ്പെട്ടു ");
INSERT INTO mal2015_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","യഹോവ തന്റെ മുമ്പിൽനിന്നു ശത്രുക്കളെ നീക്കിക്കളയുവോളം നിങ്ങൾ എല്ലാവരും അവന്റെ മുമ്പാകെ യുദ്ധസന്നദ്ധരായി യോർദ്ദാന്നക്കരെ കടന്നുപോകുമെങ്കിൽ ");
INSERT INTO mal2015_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ദേശം യഹോവയുടെ മുമ്പാകെ കീഴമർന്നശേഷം നിങ്ങൾ മടങ്ങിപ്പോരികയും യഹോവയുടെയും യിസ്രായേലിന്റെയും മുമ്പാകെ കുറ്റമില്ലാത്തവരായിരിക്കയും ചെയ്യും; അപ്പോൾ ഈ ദേശം യഹോവയുടെ മുമ്പാകെ നിങ്ങളുടെ അവകാശമാകും. ");
INSERT INTO mal2015_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","എന്നാൽ നിങ്ങൾ അങ്ങനെ ചെയ്കയില്ല എങ്കിൽ നിങ്ങൾ യഹോവയോടു പാപം ചെയ്തിരിക്കുന്നു; നിങ്ങളുടെ പാപഫലം നിങ്ങൾ അനുഭവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","നിങ്ങളുടെ കുട്ടികൾക്കായി പട്ടണങ്ങളും നിങ്ങളുടെ ആടുകൾക്കായി തൊഴുത്തുകളും പണിതു നിങ്ങൾ പറഞ്ഞതുപോലെ ചെയ്തുകൊൾവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ഗാദ്യരും രൂബേന്യരും മോശെയോടു: യജമാനൻ കല്പിക്കുന്നതുപോലെ അടിയങ്ങൾ ചെയ്തുകൊള്ളാം. ");
INSERT INTO mal2015_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ഞങ്ങളുടെ കുഞ്ഞുങ്ങളും ഭാര്യമാരും ഞങ്ങളുടെ കന്നുകാലികളും മൃഗങ്ങളൊക്കെയും ഗിലെയാദിലെ പട്ടണങ്ങളിൽ ഇരിക്കട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","അടിയങ്ങളോ യജമാനൻ കല്പിക്കുന്നതുപോലെ എല്ലാവരും യുദ്ധസന്നദ്ധരായി യഹോവയുടെ മുമ്പാകെ യുദ്ധത്തിന്നു കടന്നുപോകാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ആകയാൽ മോശെ അവരെക്കുറിച്ചു പുരോഹിതനായ എലെയാസാരിനോടും നൂന്റെ മകനായ യോശുവയോടും യിസ്രായേൽമക്കളുടെ ഗോത്രപ്രധാനികളോടും കല്പിച്ചതെന്തെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ഗാദ്യരും രൂബേന്യരും ഓരോരുത്തൻ യുദ്ധസന്നദ്ധനായി യഹോവയുടെ മുമ്പാകെ നിങ്ങളോടുകൂടെ യോർദ്ദാന്നക്കരെ കടന്നുപോരികയും ദേശം നിങ്ങളുടെ മുമ്പാകെ കീഴടങ്ങുകയും ചെയ്താൽ നിങ്ങൾ അവർക്കു ഗിലെയാദ്‌ദേശം അവകാശമായി കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","എന്നാൽ അവർ നിങ്ങളോടുകൂടെ യുദ്ധസന്നദ്ധരായി അക്കരെക്കു കടക്കാതിരുന്നാൽ അവരുടെ അവകാശം നിങ്ങളുടെ ഇടയിൽ കനാൻദേശത്തുതന്നേ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ഗാദ്യരും രൂബേന്യരും അതിന്നു: യഹോവ അടിയങ്ങളോടു അരുളിച്ചെയ്തതുപോലെ ചെയ്തുകൊള്ളാം. ");
INSERT INTO mal2015_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ഞങ്ങളുടെ അവകാശം ലഭിക്കേണ്ടതിന്നു ഞങ്ങൾ യഹോവയുടെ മുമ്പാകെ യുദ്ധസന്നദ്ധരായി കനാൻദേശത്തേക്കു കടന്നുപോകാം എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","അപ്പോൾ മോശെ ഗാദ്യർക്കും രൂബേന്യർക്കും യോസേഫിന്റെ മകനായ മനശ്ശെയുടെ പാതിഗോത്രത്തിന്നും അമോര്യരാജാവായ സീഹോന്റെ രാജ്യവും ബാശാൻ രാജാവായ ഓഗിന്റെ രാജ്യവുമായ ദേശവും അതിന്റെ അതിരുകളിൽ ചുറ്റുമുള്ള ദേശത്തിലെ പട്ടണങ്ങളും കൊടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","അങ്ങനെ ഗാദ്യർ ദീബോൻ, അതാരോത്ത്, ");
INSERT INTO mal2015_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","അരോയേർ, അത്രോത്ത്, ശോഫാൻ, യസേർ, യൊഗ്ബെഹാ, ");
INSERT INTO mal2015_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ബേത്ത്-നിമ്രാ, ബേത്ത്-ഹാരാൻ എന്നിവയെ ഉറപ്പുള്ള പട്ടണങ്ങളായും ആടുകൾക്കു തൊഴുത്തുകളായും പണിതു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","രൂബേന്യർ ഹെശ്ബോനും എലെയാലേയും കിര്യത്തയീമും പേരുമാറ്റിക്കളഞ്ഞ നെബോ, ");
INSERT INTO mal2015_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ബാൽമെയോൻ എന്നിവയും സിബ്മയും പണിതു; അവർ പണിത പട്ടണങ്ങൾക്കു പുതിയ പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","മനശ്ശെയുടെ മകനായ മാഖീരിന്റെ പുത്രന്മാർ ഗിലെയാദിൽ ചെന്നു അതിനെ അടക്കി, അവിടെ പാർത്തിരുന്ന അമോര്യരെ ഓടിച്ചുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","മോശെ ഗിലെയാദ്‌ദേശം മനശ്ശെയുടെ മകനായ മാഖീരിന്നു കൊടുത്തു; അവൻ അവിടെ പാർത്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","മനശ്ശെയുടെ പുത്രനായ യായീർ ചെന്നു അതിലെ ഊരുകളെ അടക്കി, അവെക്കു ഹവവോത്ത്-യായീർ (യായീരിന്റെ ഊരുകൾ) എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","നോബഹ് ചെന്നു കെനാത്ത് പട്ടണവും അതിന്റെ ഗ്രാമങ്ങളും അടക്കി; അതിന്നു തന്റെ പേരിൻപ്രകാരം നോബഹ് എന്നു പേരിട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","മോശെയുടെയും അഹരോന്റെയും കൈക്കീഴിൽ ഗണംഗണമായി മിസ്രയീംദേശത്തുനിന്നു പുറപ്പെട്ട യിസ്രായേൽമക്കളുടെ പ്രയാണങ്ങൾ ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","മോശെ യഹോവയുടെ കല്പനപ്രകാരം അവരുടെ പ്രയാണക്രമത്തിൽ അവരുടെ താവളങ്ങൾ എഴുതിവെച്ചു; താവളം താവളമായി അവർ ചെയ്ത പ്രയാണങ്ങൾ ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ഒന്നാം മാസം പതിനഞ്ചാം തിയ്യതി അവർ രമെസേസിൽനിന്നു പുറപ്പെട്ടു; പെസഹ കഴിഞ്ഞ പിറ്റെന്നാൾ യിസ്രായേൽമക്കൾ എല്ലാമിസ്രയീമ്യരും കാൺകെ യുദ്ധസന്നദ്ധരായി പുറപ്പെട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","മിസ്രയീമ്യരോ, യഹോവ തങ്ങളുടെ ഇടയിൽ സംഹരിച്ച കടിഞ്ഞൂലുകളെ എല്ലാം കുഴിച്ചിടുകയായിരുന്നു; അവരുടെ ദേവന്മാരുടെമേലും യഹോവ ന്യായവിധി നടത്തിയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","യിസ്രായേൽമക്കൾ രമെസേസിൽനിന്നു പുറപ്പെട്ടു സുക്കോത്തിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","സുക്കോത്തിൽനിന്നു അവർ പുറപ്പെട്ടു മരുഭൂമിയുടെ അറ്റത്തുള്ള ഏഥാമിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ഏഥാമിൽനിന്നു പുറപ്പെട്ടു ബാൽ-സെഫോന്നെതിരെയുള്ള പീഹഹീരോത്തിന്നു തിരിഞ്ഞുവന്നു; അവർ മിഗ്ദോലിന്നു കിഴക്കു പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","പീഹഹീരോത്തിന്നു കിഴക്കുനിന്നു പുറപ്പെട്ടു കടലിന്റെ നടുവിൽകൂടി മരുഭൂമിയിൽ കടന്നു ഏഥാമരുഭൂമിയിൽ മൂന്നു ദിവസത്തെ വഴിനടന്നു മാറയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","മാറയിൽനിന്നു പുറപ്പെട്ടു ഏലീമിൽ എത്തി; ഏലീമിൽ പന്ത്രണ്ടു നീരുറവും എഴുപതു ഈത്തപ്പനയും ഉണ്ടായിരുന്നതുകൊണ്ടു അവർ അവിടെ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ഏലീമിൽനിന്നു പുറപ്പെട്ടു ചെങ്കടലിന്നരികെ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ചെങ്കടലിന്നരികെനിന്നു പുറപ്പെട്ടു സീൻമരുഭൂമിയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","സീൻമരുഭൂമിയിൽനിന്നു പുറപ്പെട്ടു ദൊഫ്ക്കയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ദൊഫ്ക്കയിൽ നിന്നു പുറപ്പെട്ടു ആലൂശിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ആലൂശിൽ നിന്നു പുറപ്പെട്ടു രെഫീദീമിൽ പാളയമിറങ്ങി; അവിടെ ജനത്തിന്നു കുടിപ്പാൻ വെള്ളമില്ലായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","രെഫീദീമിൽ നിന്നു പുറപ്പെട്ടു സീനായിമരുഭൂമിയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","സീനായിമരുഭൂമിയിൽനിന്നു പുറപ്പെട്ടു കിബ്രോത്ത്-ഹത്താവയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","കിബ്രോത്ത്-ഹത്താവയിൽനിന്നു പുറപ്പെട്ടു ഹസേരോത്തിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ഹസേരോത്തിൽനിന്നു പുറപ്പെട്ടു രിത്ത്മയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","രിത്ത്മയിൽനിന്നു പുറപ്പെട്ടു രിമ്മോൻ-പേരെസിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","രിമ്മോൻ-പേരെസിൽനിന്നു പുറപ്പെട്ടു ലിബ്നയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ലിബ്നയിൽനിന്നു പുറപ്പെട്ടു രിസ്സയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","രിസ്സയിൽനിന്നു പുറപ്പെട്ടു കെഹേലാഥയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","കെഹേലാഥയിൽനിന്നു പുറപ്പെട്ടു ശാഫേർമലയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ശാഫേർമലയിൽനിന്നു പുറപ്പെട്ടു ഹരാദയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ഹരാദയിൽനിന്നു പുറപ്പെട്ടു മകഹേലോത്തിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","മകഹേലോത്തിൽനിന്നു പുറപ്പെട്ടു തഹത്തിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","തഹത്തിൽനിന്നു പുറപ്പെട്ടു താരഹിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","താരഹിൽനിന്നു പുറപ്പെട്ടു മിത്ത്ക്കയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","മിത്ത്ക്കയിൽനിന്നു പുറപ്പെട്ടു ഹശ്മോനയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ഹശ്മോനയിൽനിന്നു പുറപ്പെട്ടു മോസേരോത്തിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","മോസേരോത്തിൽനിന്നു പുറപ്പെട്ടു ബെനേയാക്കാനിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ബെനേയാക്കാനിൽനിന്നു പുറപ്പെട്ടു ഹോർ-ഹഗ്ഗിദ്ഗാദിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ഹോർ-ഹഗ്ഗിദ്ഗാദിൽനിന്നു പുറപ്പെട്ടു യൊത്ബാഥയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","യൊത്ബാഥയിൽനിന്നു പുറപ്പെട്ടു അബ്രോനയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","അബ്രോനയിൽനിന്നു പുറപ്പെട്ടു എസ്യോൻ-ഗേബെരിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","എസ്യോൻ-ഗേബെരിൽനിന്നു പുറപ്പെട്ടു സീൻമരുഭൂമിയിൽ പാളയമിറങ്ങി. അതാകുന്നു കാദേശ്. ");
INSERT INTO mal2015_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","അവർ കാദേശിൽനിന്നു പുറപ്പെട്ടു എദോംദേശത്തിന്റെ അതിരിങ്കൽ ഹോർപർവ്വതത്തിങ്കൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","പുരോഹിതനായ അഹരോൻ യഹോവയുടെ കല്പനപ്രകാരം ഹോർപർവ്വതത്തിൽ കയറി, യിസ്രായേൽമക്കൾ മിസ്രയീംദേശത്തുനിന്നു പോന്നതിന്റെ നാല്പതാം സംവത്സരം അഞ്ചാം മാസം ഒന്നാം തിയ്യതി അവിടെവെച്ചു മരിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","അഹരോൻ ഹോർപർവ്വതത്തിൽവെച്ചു മരിച്ചപ്പോൾ അവന്നു നൂറ്റിരുപത്തിമൂന്നു വയസ്സായിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","എന്നാൽ കനാൻദേശത്തു തെക്കു പാർത്തിരുന്ന കനാന്യനായ അരാദ് രാജാവു യിസ്രായേൽ മക്കളുടെ വരവിനെക്കുറിച്ചു കേട്ടു. ");
INSERT INTO mal2015_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ഹോർപർവ്വതത്തിങ്കൽനിന്നു അവർ പുറപ്പെട്ടു സല്മോനയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","സല്മോനയിൽനിന്നു പറപ്പെട്ടു പൂനോനിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","പൂനോനിൽനിന്നു പുറപ്പെട്ടു ഓബോത്തിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ഓബോത്തിൽനിന്നു പുറപ്പെട്ടു മോവാബിന്റെ അതിരിങ്കൽ ഈയേ-അബാരീമിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ഈയീമിൽനിന്നു പുറപ്പെട്ടു ദീബോൻഗാദിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ദീബോൻഗാദിൽനിന്നു പുറപ്പെട്ടു അല്മോദിബ്ളാഥയീമിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","അല്മോദിബ്ളാഥയീമിൽനിന്നു പുറപ്പെട്ടു നെബോവിന്നു കിഴക്കു അബാരീംപർവ്വതത്തിങ്കൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","അബാരീംപർവ്വതത്തിങ്കൽ നിന്നു പുറപ്പെട്ടു യെരീഹോവിന്നെതിരെ യോർദ്ദാന്നരികെ മോവാബ്സമഭൂമിയിൽ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","യോർദ്ദാന്നരികെ മോവാബ്സമഭൂമിയിൽ ബേത്ത്-യെശീമോത്ത് മുതൽ ആബേൽ-ശിത്തീംവരെ പാളയമിറങ്ങി. ");
INSERT INTO mal2015_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","യെരീഹോവിന്നെതിരെ യോർദ്ദാന്നരികെ മോവാബ് സമഭൂമിയിൽവെച്ചു യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടുന്നതെന്തെന്നാൽ: നിങ്ങൾ യോർദ്ദാന്നക്കരെ കനാൻദേശത്തേക്കു കടന്നശേഷം ");
INSERT INTO mal2015_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ദേശത്തിലെ സകലനിവാസികളെയും നിങ്ങളുടെ മുമ്പിൽനിന്നു നീക്കിക്കളഞ്ഞു അവരുടെ വിഗ്രഹങ്ങളെയും ബിംബങ്ങളെയും എല്ലാം തകർത്തു അവരുടെ സകലപൂജാഗിരികളെയും നശിപ്പിച്ചുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","നിങ്ങൾ ദേശം കൈവശമാക്കി അതിൽ കുടിപാർക്കേണം; നിങ്ങൾ കൈവശമാക്കേണ്ടതിന്നു ഞാൻ ആ ദേശം നിങ്ങൾക്കു തന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","നിങ്ങൾ കുടുംബംകുടുംബമായി ദേശം ചീട്ടിട്ടു അവകാശമാക്കേണം; ആളേറെയുള്ളവർക്കു ഏറെയും കുറെയുള്ളവർക്കു കുറെയും അവകാശം കൊടുക്കേണം; അവന്നവന്നു ചീട്ടു എവിടെ വീഴുന്നുവോ അവിടെ അവന്റെ അവകാശം ആയിരിക്കേണം; പിതൃഗോത്രം പിതൃഗോത്രമായി നിങ്ങൾക്കു അവകാശം ലഭിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","എന്നാൽ ദേശത്തെ നിവാസികളെ നിങ്ങളുടെ മുമ്പിൽനിന്നു നീക്കിക്കളയാതിരുന്നാൽ നിങ്ങൾ അവരിൽ ശേഷിപ്പിക്കുന്നവർ നിങ്ങളുടെ കണ്ണുകളിൽ മുള്ളുകളും പാർശ്വങ്ങളിൽ കണ്ടകങ്ങളുമായി നിങ്ങൾ പാർക്കുന്ന ദേശത്തു നിങ്ങളെ ഉപദ്രവിക്കും. ");
INSERT INTO mal2015_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","അത്രയുമല്ല, ഞാൻ അവരോടു ചെയ്‌വാൻ നിരൂപിച്ചതുപോലെ നിങ്ങളോടു ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","യിസ്രായേൽമക്കളോടു നീ കല്പിക്കേണ്ടതെന്തെന്നാൽ: നിങ്ങൾ കനാൻദേശത്തു എത്തുമ്പോൾ നിങ്ങൾക്കു അവകാശമായി വരുവാനിരിക്കുന്ന ദേശത്തിന്റെ അതിർ ഇങ്ങനെ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","തെക്കെഭാഗം സീൻമരുഭൂമിതുടങ്ങി എദോമിന്റെ വശത്തുകൂടിയായിരിക്കേണം; നിങ്ങളുടെ തെക്കെ അതിർ കിഴക്കു ഉപ്പുകടലിന്റെ അറ്റംതുടങ്ങി ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","പിന്നെ നിങ്ങളുടെ അതിർ അക്രബ്ബീംകയറ്റത്തിന്നു തെക്കോട്ടു തിരിഞ്ഞു സീനിലേക്കു കടന്നു കാദേശ്ബർന്നേയയുടെ തെക്കു അവസാനിക്കേണം. അവിടെനിന്നു ഹസർ-അദ്ദാർവരെ ചെന്നു അസ്മോനിലേക്കു കടക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","പിന്നെ അതിർ അസ്മോൻതുടങ്ങി മിസ്രയീംതോട്ടിലേക്കു തിരിഞ്ഞു സമുദ്രത്തിങ്കൽ അവസാനിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","പടിഞ്ഞാറോ മഹാസമുദ്രം അതിർ ആയിരിക്കേണം. അതു നിങ്ങളുടെ പടിഞ്ഞാറെ അതിർ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","വടക്കോ മഹാസമുദ്രംതുടങ്ങി ഹോർപർവ്വതം നിങ്ങളുടെ അതിരാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ഹോർപർവ്വതംമുതൽ ഹമാത്ത്‌വരെ അതിരാക്കേണം. സെദാദിൽ ആ അതിർ അവസാനിക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","പിന്നെ അതിർ സിഫ്രോൻവരെ ചെന്നു ഹസാർ-ഏനാനിൽ അവസാനിക്കേണം; ഇതു നിങ്ങളുടെ വടക്കെ അതിർ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","കിഴക്കോ ഹസാർ-എനാൻതുടങ്ങി ശെഫാംവരെ നിങ്ങളുടെ അതിരാക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ശെഫാംതുടങ്ങി ആ അതിർ അയീന്റെ കിഴക്കു ഭാഗത്തു രിബ്ളാവരെ ഇറങ്ങിച്ചെന്നിട്ടു കിന്നേരെത്ത്കടലിന്റെ കിഴക്കെ കര തൊട്ടിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","അവിടെനിന്നു യോർദ്ദാൻവഴിയായി ഇറങ്ങിച്ചെന്നു ഉപ്പുകടലിങ്കൽ അവസാനിക്കേണം. ഇതു ചുറ്റും നിങ്ങളുടെ ദേശത്തിന്റെ അതിർ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","മോശെ യിസ്രായേൽമക്കളോടു കല്പിച്ചതു: നിങ്ങൾക്കു ചീട്ടിനാൽ അവകാശമായി ലഭിപ്പാനുള്ളതായി യഹോവ ഒമ്പതര ഗോത്രങ്ങൾക്കു കൊടുപ്പാൻ കല്പിച്ചിട്ടുള്ള ദേശം ഇതു തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","രൂബേൻഗോത്രക്കാരുടെ കുടുംബങ്ങൾക്കും ഗാദ്ഗോത്രക്കാരുടെ കുടുംബങ്ങൾക്കും മനശ്ശെയുടെ പാതി ഗോത്രത്തിന്നും താന്താങ്ങളുടെ അവകാശം ലഭിച്ചുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ഈ രണ്ടര ഗോത്രത്തിന്നു അവകാശം ലഭിച്ചതു കിഴക്കൻപ്രദേശത്തു യെരീഹോവിന്നു കിഴക്കു യോർദ്ദാന്നക്കരെ ആയിരുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","പിന്നെ യഹോവ മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","നിങ്ങൾക്കു ദേശം വിഭാഗിച്ചു തരേണ്ടുന്നവരുടെ പേരുകൾ ആവിതു: പുരോഹിതനായ എലെയാസാരും നൂന്റെ മകനായ യോശുവയും. ");
INSERT INTO mal2015_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ദേശത്തെ അവകാശമായി വിഭാഗിക്കേണ്ടതിന്നു നിങ്ങൾ ഓരോ ഗോത്രത്തിൽനിന്നു ഓരോ പ്രഭുവിനെയും കൂട്ടിക്കൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","അവർ ആരെല്ലാമെന്നാൽ: യെഹൂദാഗോത്രത്തിൽ യെഫുന്നെയുടെ മകൻ കാലേബ്. ");
INSERT INTO mal2015_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ശിമെയോൻഗോത്രത്തിൽ അമ്മീഹൂദിന്റെ മകൻ ശെമൂവേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ബെന്യാമീൻഗോത്രത്തിൽ കിസ്ളോന്റെ മകൻ എലീദാദ്. ");
INSERT INTO mal2015_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ദാൻഗോത്രത്തിന്നുള്ള പ്രഭു യൊഗ്ലിയുടെ മകൻ ബുക്കി. ");
INSERT INTO mal2015_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","യോസേഫിന്റെ പുത്രന്മാരിൽ മനശ്ശെയുടെ ഗോത്രത്തിന്നുള്ള പ്രഭു എഫോദിന്റെ മകൻ ഹാന്നീയേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","എഫ്രയീംഗോത്രത്തിന്നുള്ള പ്രഭു ശിഫ്താന്റെ മകൻ കെമൂവേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","സെബൂലൂൻഗോത്രത്തിന്നുള്ള പ്രഭു പർന്നാക്കിന്റെ മകൻ എലീസാഫാൻ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","യിസ്സാഖാർഗോത്രത്തിന്നുള്ള പ്രഭു അസ്സാന്റെ മകൻ പൽത്തീയേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ആശേർഗോത്രത്തിന്നുള്ള പ്രഭു ശെലോമിയുടെ പുത്രൻ അഹീഹൂദ്. ");
INSERT INTO mal2015_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","നഫ്താലിഗോത്രത്തിന്നുള്ള പ്രഭു അമ്മീഹൂദിന്റെ മകൻ പെദഹേൽ. ");
INSERT INTO mal2015_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","യിസ്രായേൽമക്കൾക്കു കനാൻദേശത്തു അവകാശം വിഭാഗിച്ചുകൊടുക്കേണ്ടതിന്നു യഹോവ നിയമിച്ചവർ ഇവർ തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","യഹോവ പിന്നെയും യെരീഹോവിന്നെതിരെ യോർദ്ദാന്നരികെ മോവാബ് സമഭൂമിയിൽവെച്ചു മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","യിസ്രായേൽമക്കൾ തങ്ങളുടെ അവകാശത്തിൽനിന്നു ലേവ്യർക്കു വസിപ്പാൻ പട്ടണങ്ങൾ കൊടുക്കേണമെന്നു അവരോടു കല്പിക്ക; പട്ടണങ്ങളോടുകൂടെ അവയുടെ പുല്പുറവും നിങ്ങൾ ലേവ്യർക്കു കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","പട്ടണങ്ങൾ അവർക്കു പാർപ്പിടമായിരിക്കേണം; അവയുടെ പുല്പുറം ആടുമാടുകൾ മുതലായ സകലമൃഗസമ്പത്തിന്നുംവേണ്ടി ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","നിങ്ങൾ ലേവ്യർക്കു കൊടുക്കേണ്ടുന്ന പുല്പുറം. പട്ടണത്തിന്റെ മതിലിങ്കൽതുടങ്ങി പുറത്തോട്ടു ചുറ്റും ആയിരം മുഴം വിസ്താരം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","പട്ടണം നടുവാക്കി അതിന്നു പുറമെ കിഴക്കോട്ടു രണ്ടായിരം മുഴവും തെക്കോട്ടു രണ്ടായിരം മുഴവും പടിഞ്ഞാറോട്ടു രണ്ടായിരം മുഴവും വടക്കോട്ടു രണ്ടായിരം മുഴവും അളക്കേണം; ഇതു അവർക്കു പട്ടണങ്ങളുടെ പുല്പുറം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","നിങ്ങൾ ലേവ്യർക്കു കൊടുക്കുന്ന പട്ടണങ്ങളിൽ ആറു സങ്കേതനഗരങ്ങളായിരിക്കേണം; കൊലചെയ്തവൻ അവിടേക്കു ഓടിപ്പോകേണ്ടതിന്നു നിങ്ങൾ അവയെ അവന്നുവേണ്ടി വേറുതിരിക്കേണം; ഇവ കൂടാതെ നിങ്ങൾ വേറെയും നാല്പത്തുരണ്ടു പട്ടണങ്ങളെ കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","അങ്ങനെ നിങ്ങൾ ലേവ്യർക്കു കൊടുക്കുന്ന പട്ടണങ്ങൾ എല്ലാംകൂടെ നാല്പത്തെട്ടു ആയിരിക്കേണം; അവയും അവയുടെ പുല്പുറങ്ങളും കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","യിസ്രായേൽമക്കളുടെ അവകാശത്തിൽനിന്നു ജനമേറിയവർ ഏറെയും ജനം കുറഞ്ഞവർ കുറെയും പട്ടണങ്ങൾ കൊടുക്കേണം; ഓരോ ഗോത്രം തനിക്കു ലഭിക്കുന്ന അവകാശത്തിന്നു ഒത്തവണ്ണം ലേവ്യർക്കു പട്ടണങ്ങളെ കൊടുക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","യഹോവ പിന്നെയും മോശെയോടു അരുളിച്ചെയ്തതു: ");
INSERT INTO mal2015_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","നീ യിസ്രായേൽമക്കളോടു പറയേണ്ടതെന്തെന്നാൽ: നിങ്ങൾ യോർദ്ദാൻ കടന്നു കനാൻദേശത്തു എത്തിയശേഷം ");
INSERT INTO mal2015_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ചില പട്ടണങ്ങൾ സങ്കേതനഗരങ്ങളായി വേറുതിരിക്കേണം; അബദ്ധവശാൽ ഒരുത്തനെ കൊന്നുപോയവൻ അവിടേക്കു ഓടിപ്പോകേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","കൊലചെയ്തവൻ സഭയുടെ മുമ്പാകെ വിസ്താരത്തിന്നു നില്ക്കുംവരെ അവൻ പ്രതികാരകന്റെ കയ്യാൽ മരിക്കാതിരിക്കേണ്ടതിന്നു അവ സങ്കേതനഗരങ്ങൾ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","നിങ്ങൾ കൊടുക്കുന്ന പട്ടണങ്ങളിൽ ആറെണ്ണം സങ്കേതനഗരം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","യോർദ്ദാന്നക്കരെ മൂന്നു പട്ടണവും കനാൻദേശത്തു മൂന്നു പട്ടണവും കൊടുക്കേണം; അവ സങ്കേതനഗരങ്ങൾ ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","അബദ്ധവശാൽ ഒരുത്തനെ കൊല്ലുന്നവൻ ഏവനും അവിടേക്കു ഓടിപ്പോകേണ്ടതിന്നു ഈ ആറുപട്ടണം യിസ്രായേൽമക്കൾക്കും പരദേശിക്കും വന്നുപാർക്കുന്നവന്നും സങ്കേതം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","എന്നാൽ ആരെങ്കിലും ഇരുമ്പായുധംകൊണ്ടു ഒരുത്തനെ അടിച്ചിട്ടു അവൻ മരിച്ചുപോയാൽ അവൻ കൊലപാതകൻ; കൊലപാതകൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","മരിപ്പാൻ തക്കവണ്ണം ആരെങ്കിലും ഒരുത്തനെ കല്ലെറിഞ്ഞിട്ടു അവൻ മരിച്ചുപോയാൽ അവൻ കൊലപാതകൻ; കൊലപാതകൻ മരണ ശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","അല്ലെങ്കിൽ മരിപ്പാൻ തക്കവണ്ണം ആരെങ്കിലും കയ്യിലിരുന്ന മരയായുധംകൊണ്ടു ഒരുത്തനെ അടിച്ചിട്ടു അവൻ മരിച്ചുപോയാൽ അവൻ കൊലപാതകൻ; കൊലപാതകൻ മരണശിക്ഷ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","രക്തപ്രതികാരകൻ തന്നേ കൊലപാതകനെ കൊല്ലേണം; അവനെ കണ്ടുകൂടുമ്പോൾ അവനെ കൊല്ലേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ആരെങ്കിലും ദ്വേഷംനിമിത്തം ഒരുത്തനെ കുത്തുകയോ കരുതിക്കൂട്ടി അവന്റെമേൽ വല്ലതും എറികയോ ചെയ്തിട്ടു അവൻ മരിച്ചുപോയാൽ, ");
INSERT INTO mal2015_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","അല്ലെങ്കിൽ ശത്രുതയാൽ കൈകൊണ്ടു അവനെ അടിച്ചിട്ടു അവൻ മരിച്ചുപോയാൽ അവനെ കൊന്നവൻ മരണശിക്ഷ അനുഭവിക്കേണം. അവൻ കൊലപാതകൻ; രക്തപ്രതികാരകൻ കൊലപാതകനെ കണ്ടുകൂടുമ്പോൾ കൊന്നുകളയേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","എന്നാൽ ആരെങ്കിലും ശത്രുതകൂടാതെ പെട്ടെന്നു ഒരുത്തനെ കുത്തുകയോ കരുതാതെ വല്ലതും അവന്റെമേൽ എറിഞ്ഞുപോകയോ, ");
INSERT INTO mal2015_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","അവന്നു ശത്രുവായിരിക്കാതെയും അവന്നു ദോഷം വിചാരിക്കാതെയും അവൻ മരിപ്പാൻ തക്കവണ്ണം അവനെ കാണാതെ കല്ലു എറികയോ ചെയ്തിട്ടു അവൻ മരിച്ചു പോയാൽ ");
INSERT INTO mal2015_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","കൊലചെയ്തവന്നും രക്തപ്രതികാരകന്നും മദ്ധ്യേ ഈ ന്യായങ്ങളെ അനുസരിച്ചു സഭ വിധിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","കൊലചെയ്തവനെ സഭ രക്തപ്രതികാരകന്റെ കയ്യിൽനിന്നു രക്ഷിക്കേണം; അവൻ ഓടിപ്പോയിരുന്ന സങ്കേതനഗരത്തിലേക്കു അവനെ മടക്കി അയക്കേണം; വിശുദ്ധതൈലത്താൽ അഭിഷിക്തനായ മഹാപുരോഹിതന്റെ മരണംവരെ അവൻ അവിടെ പാർക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","എന്നാൽ കൊലചെയ്തവൻ ഓടിപ്പോയിരുന്ന സങ്കേതനഗരത്തിന്റെ അതിർ വിട്ടു പുറത്തു വരികയും ");
INSERT INTO mal2015_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","അവനെ അവന്റെ സങ്കേതനഗരത്തിന്റെ അതിരിന്നു പുറത്തുവെച്ചു കണ്ടു രക്തപ്രതികാരകൻ കൊലചെയ്തവനെ കൊല്ലുകയും ചെയ്താൽ അവന്നു രക്തപാതകം ഇല്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","അവൻ മഹാപുരോഹിതന്റെ മരണംവരെ തന്റെ സങ്കേതനഗരത്തിൽ പാർക്കേണ്ടിയിരുന്നു; എന്നാൽ കൊലചെയ്തവന്നു മഹാപുരോഹിതന്റെ മരണശേഷം തന്റെ അവകാശഭൂമിയിലേക്കു മടങ്ങിപ്പോകാം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","ഇതു നിങ്ങൾക്കു തലമുറതലമുറയായി നിങ്ങളുടെ സകലവാസസ്ഥലങ്ങളിലും ന്യായവിധിക്കുള്ള പ്രമാണം ആയിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","ആരെങ്കിലും ഒരുത്തനെ കൊന്നാൽ കൊലപാതകൻ സാക്ഷികളുടെ വാമൊഴിപ്രകാരം മരണശിക്ഷ അനുഭവിക്കേണം; എന്നാൽ ഒരു മനുഷ്യന്റെ നേരെ മരണശിക്ഷെക്കു ഏകസാക്ഷിയുടെ മൊഴി മതിയാകുന്നതല്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","മരണയോഗ്യനായ കൊലപാതകന്റെ ജീവന്നുവേണ്ടി നിങ്ങൾ വീണ്ടെടുപ്പുവില വാങ്ങരുതു; അവൻ മരണശിക്ഷ തന്നേ അനുഭവിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","സങ്കേതനഗരത്തിലേക്കു ഓടിപ്പോയവൻ പുരോഹിതന്റെ മരണത്തിന്നു മുമ്പെ നാട്ടിൽ മടങ്ങിവന്നു പാർക്കേണ്ടതിന്നും നിങ്ങൾ വീണ്ടെടുപ്പുവില വാങ്ങരുതു. ");
INSERT INTO mal2015_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","നിങ്ങൾ പാർക്കുന്ന ദേശം അങ്ങനെ അശുദ്ധമാക്കരുതു; രക്തം ദേശത്തെ അശുദ്ധമാക്കുന്നു; ദേശത്തിൽ ചൊരിഞ്ഞ രക്തത്തിന്നുവേണ്ടി രക്തം ചൊരിയിച്ചവന്റെ രക്തത്താൽ അല്ലാതെ ദേശത്തിന്നു പ്രായശ്ചിത്തം സാദ്ധ്യമല്ല. ");
INSERT INTO mal2015_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","അതുകൊണ്ടു ഞാൻ അധിവസിക്കുന്ന നിങ്ങളുടെ പാർപ്പിടമായ ദേശം അശുദ്ധമാക്കരുതു; യിസ്രായേൽമക്കളുടെ മദ്ധ്യേ യഹോവയായ ഞാൻ അധിവസിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","യോസേഫിന്റെ മക്കളുടെ കുടുംബങ്ങളിൽ മനശ്ശെയുടെ മകനായ മാഖീരിന്റെ മകനായ ഗിലെയാദിന്റെ മക്കളുടെ കുടുംബത്തലവന്മാർ അടുത്തുവന്നു മോശെയുടെയും യിസ്രായേൽമക്കളുടെ ഗോത്രപ്രധാനികളായ പ്രഭുക്കന്മാരുടെയും മുമ്പാകെ പറഞ്ഞതു: ");
INSERT INTO mal2015_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","യിസ്രായേൽമക്കൾക്കു ദേശം ചീട്ടിട്ടു അവകാശമായി കൊടുപ്പാൻ യഹോവ യജമാനനോടു കല്പിച്ചു; ഞങ്ങളുടെ സഹോദരനായ ശെലോഫഹാദിന്റെ അവകാശം അവന്റെ പുത്രിമാർക്കു കൊടുപ്പാൻ യജമാനന്നു യഹോവയുടെ കല്പന ഉണ്ടായി. ");
INSERT INTO mal2015_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","എന്നാൽ അവർ യിസ്രായേൽമക്കളുടെ മറ്റു ഗോത്രങ്ങളിലെ പുരുഷന്മാരിൽ വല്ലവർക്കും ഭാര്യമാരായാൽ അവരുടെ അവകാശം ഞങ്ങളുടെ പിതാക്കന്മാരുടെ അവകാശത്തിൽനിന്നു വിട്ടുപോകയും അവർ ചേരുന്ന ഗോത്രത്തിന്റെ അവകാശത്തോടു കൂടുകയും ചെയ്യും; ഇങ്ങനെ അതു ഞങ്ങളുടെ അവകാശത്തിന്റെ ഓഹരിയിൽനിന്നു പൊയ്പോകും. ");
INSERT INTO mal2015_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","യിസ്രായേൽമക്കളുടെ യോബേൽസംവത്സരം വരുമ്പോൾ അവരുടെ അവകാശം അവർ ചേരുന്ന ഗോത്രത്തിന്റെ അവകാശത്തോടുകൂടുകയും അങ്ങനെ അവരുടെ അവകാശം ഞങ്ങളുടെ പിതൃഗോത്രത്തിന്റെ അവകാശത്തിൽനിന്നു വിട്ടുപോകയും ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","അപ്പോൾ മോശെ യഹോവയുടെ വചനപ്രകാരം യിസ്രായേൽമക്കളോടു കല്പിച്ചതു: യോസേഫിന്റെ പുത്രന്മാരുടെ ഗോത്രം പറഞ്ഞതു ശരി തന്നേ. ");
INSERT INTO mal2015_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","യഹോവ ശെലോഫഹാദിന്റെ പുത്രിമാരെക്കുറിച്ചു കല്പിക്കുന്ന കാര്യം എന്തെന്നാൽ: അവർ തങ്ങൾക്കു ബോധിച്ചവർക്കു ഭാര്യമാരായിരിക്കട്ടെ; എങ്കിലും തങ്ങളുടെ പിതൃഗോത്രത്തിലെ കുടുംബത്തിലുള്ളവർക്കു മാത്രമേ ആകാവു. ");
INSERT INTO mal2015_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","യിസ്രായേൽമക്കളുടെ അവകാശം ഒരു ഗോത്രത്തിൽ നിന്നു മറ്റൊരു ഗോത്രത്തിലേക്കു മാറരുതു; യിസ്രായേൽമക്കളിൽ ഓരോരുത്തൻ താന്താന്റെ പിതൃഗോത്രത്തിന്റെ അവകാശത്തോടു ചേർന്നിരിക്കേണം; ");
INSERT INTO mal2015_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","യിസ്രായേൽമക്കൾ ഓരോരുത്തൻ താന്താന്റെ പിതാക്കന്മാരുടെ അവകാശം കൈവശമാക്കേണ്ടതിന്നു യിസ്രായേൽമക്കളുടെ യാതൊരു ഗോത്രത്തിലും അവകാശം ലഭിക്കുന്ന ഏതുകന്യകയും തന്റെ പിതൃഗോത്രത്തിലെ ഒരു കുടുംബത്തിൽ ഒരുത്തന്നു ഭാര്യയാകേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","അങ്ങനെ അവകാശം ഒരു ഗോത്രത്തിൽനിന്നു മറ്റൊരു ഗോത്രത്തിലേക്കു മാറാതെ യിസ്രായേൽമക്കളുടെ ഗോത്രങ്ങളിൽ ഓരോരുത്തൻ താന്താന്റെ അവകാശത്തോടു ചേർന്നിരിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","യഹോവ മോശെയോടു കല്പിച്ചതുപോലെ ശെലോഫഹാദിന്റെ പുത്രിമാർ ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ശെലോഫഹാദിന്റെ പുത്രിമാരായ മഹ്ലാ, തിർസാ, ഹൊഗ്ല, മിൽക്കാ, നോവാ എന്നിവർ തങ്ങളുടെ അപ്പന്റെ സഹോദരന്മാരുടെ പുത്രന്മാർക്കു ഭാര്യമാരായി. ");
INSERT INTO mal2015_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","യോസേഫിന്റെ മകനായ മനശ്ശെയുടെ പുത്രന്മാരുടെ കുടുംബങ്ങളിൽ അവർ ഭാര്യമാരാകയും അവരുടെ അവകാശം അവരുടെ പിതൃകുടുംബത്തിന്റെ ഗോത്രത്തിൽതന്നേ ഇരിക്കയും ചെയ്തു. ");
INSERT INTO mal2015_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","യെരീഹോവിന്നെതിരെ യോർദ്ദാന്നരികെ മോവാബ് സമഭൂമിയിൽവെച്ചു യഹോവ മോശെമുഖാന്തരം യിസ്രായേൽമക്കളോടു കല്പിച്ച കല്പനകളും വിധികളും ഇവ തന്നേ.");
INSERT INTO mal2015_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","സൂഫിന്നെതിരെ പാരാന്നും തോഫെലിന്നും ലാബാന്നും ഹസേരോത്തിന്നും ദീസാഹാബിന്നും നടുവെ യോർദ്ദാന്നക്കരെ മരുഭൂമിയിൽ അരാബയിൽവെച്ചു മോശെ എല്ലായിസ്രായേലിനോടും പറഞ്ഞ വചനങ്ങൾ ആവിതു: ");
INSERT INTO mal2015_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","സേയീർപർവ്വതം വഴിയായി ഹോരേബിൽനിന്നു കാദേശ്ബർന്നേയയിലേക്കു പതിനൊന്നു ദിവസത്തെ വഴി ഉണ്ടു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","നാല്പതാം സംവത്സരം പതിനൊന്നാം മാസം ഒന്നാം തിയ്യതി മോശെ യിസ്രായേൽമക്കളോടു യഹോവ അവർക്കുവേണ്ടി തന്നോടു കല്പിച്ചതുപോലെ ഒക്കെയും പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ഹെശ്ബോനിൽ പാർത്തിരുന്ന അമോര്യരാജാവായ സീഹോനെയും അസ്താരോത്തിൽ പാർത്തിരുന്ന ബാശാൻ രാജാവായ ഓഗിനെയും എദ്രെയിൽവെച്ചു സംഹരിച്ചശേഷം ");
INSERT INTO mal2015_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","യോർദ്ദാന്നക്കരെ മോവാബ് ദേശത്തുവെച്ചു മോശെ ഈ ന്യായപ്രമാണം വിവരിച്ചുതുടങ്ങിയതു എങ്ങനെയെന്നാൽ: ");
INSERT INTO mal2015_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","ഹോരേബിൽവെച്ചു നമ്മുടെ ദൈവമായ യഹോവ നമ്മോടു കല്പിച്ചതു: നിങ്ങൾ ഈ പർവ്വതത്തിങ്കൽ പാർത്തതു മതി. ");
INSERT INTO mal2015_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","തിരിഞ്ഞു യാത്രചെയ്തു അമോര്യരുടെ പർവ്വതത്തിലേക്കും അതിന്റെ അയൽപ്രദേശങ്ങളായ അരാബാ, മലനാടു, താഴ്‌വീതി, തെക്കേദേശം, കടൽക്കര എന്നിങ്ങനെയുള്ള കനാന്യദേശത്തേക്കും ലെബാനോനിലേക്കും ഫ്രാത്ത് എന്ന മഹാനദിവരെയും പോകുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ഇതാ, ഞാൻ ആ ദേശം നിങ്ങളുടെ മുമ്പിൽ വെച്ചിരിക്കുന്നു; നിങ്ങൾ കടന്നു യഹോവ നിങ്ങളുടെ പിതാക്കന്മാരായ അബ്രാഹാമിന്നും യിസ്ഹാക്കിന്നും യാക്കോബിന്നും അവരുടെ സന്തതിക്കും കൊടുക്കുമെന്നു അവരോടു സത്യംചെയ്ത ദേശത്തെ കൈവശമാക്കുവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","അക്കാലത്തു ഞാൻ നിങ്ങളോടു പറഞ്ഞതു: എനിക്കു ഏകനായി നിങ്ങളെ വഹിപ്പാൻ കഴികയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","നിങ്ങളുടെ ദൈവമായ യഹോവ നിങ്ങളെ വർദ്ധിപ്പിച്ചിരിക്കുന്നു; ഇതാ നിങ്ങൾ ഇന്നു പെരുപ്പത്തിൽ ആകാശത്തിലെ നക്ഷത്രങ്ങൾ പോലെ ഇരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","നിങ്ങളുടെ പിതാക്കന്മാരുടെ ദൈവമായ യഹോവ നിങ്ങളെ ഇപ്പോഴുള്ളതിനെക്കാൾ ഇനിയും ആയിരം ഇരട്ടിയാക്കി, താൻ നിങ്ങളോടു അരുളിച്ചെയ്തതുപോലെ അനുഗ്രഹിക്കുമാറാകട്ടെ. ");
INSERT INTO mal2015_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ഞാൻ ഏകനായി നിങ്ങളുടെ ഭാരവും നിങ്ങളുടെ ചുമടും നിങ്ങളുടെ വ്യവഹാരങ്ങളും വഹിക്കുന്നതു എങ്ങനെ? ");
INSERT INTO mal2015_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","അതതു ഗോത്രത്തിൽനിന്നു ജ്ഞാനവും വിവേകവും പ്രസിദ്ധിയുമുള്ള പുരുഷന്മാരെ തിരഞ്ഞെടുപ്പിൻ; അവരെ ഞാൻ നിങ്ങൾക്കു തലവന്മാരാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","അതിന്നു നിങ്ങൾ എന്നോടു: നീ പറഞ്ഞ കാര്യം നല്ലതു എന്നു ഉത്തരം പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ആകയാൽ ഞാൻ നിങ്ങളുടെ ഗോത്രത്തലവന്മാരായി ജ്ഞാനവും പ്രസിദ്ധിയുമുള്ള പുരുഷന്മാരെ ആയിരംപേർക്കു അധിപതിമാർ, നൂറുപേർക്കു അധിപതിമാർ, അമ്പതുപേർക്കു അധിപതിമാർ, പത്തുപേർക്കു അധിപതിമാർ ഇങ്ങനെ നിങ്ങൾക്കു തലവന്മാരും ഗോത്രപ്രമാണികളുമായി നിയമിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","അന്നു ഞാൻ നിങ്ങളുടെ ന്യായാധിപന്മാരോടു ആജ്ഞാപിച്ചതു: നിങ്ങളുടെ സഹോദരന്മാർക്കു തമ്മിലുള്ള കാര്യങ്ങളെ കേട്ടു, ആർക്കെങ്കിലും സഹോദരനോടോ പരദേശിയോടോ വല്ലകാര്യവും ഉണ്ടായാൽ അതു നീതിയോടെ വിധിപ്പിൻ. ");
INSERT INTO mal2015_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ന്യായവിസ്താരത്തിൽ മുഖം നോക്കാതെ ചെറിയവന്റെ കാര്യവും വലിയവന്റെ കാര്യവും ഒരുപോലെ കേൾക്കേണം; മനുഷ്യനെ ഭയപ്പെടരുതു; ന്യായവിധി ദൈവത്തിന്നുള്ളതല്ലോ. നിങ്ങൾക്കു അധികം പ്രയാസമുള്ള കാര്യം എന്റെ അടുക്കൽ കൊണ്ടുവരുവിൻ; അതു ഞാൻ തീർക്കും ");
INSERT INTO mal2015_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","അങ്ങനെ നിങ്ങൾ ചെയ്യേണ്ടുന്ന കാര്യങ്ങളൊക്കെയും ഞാൻ അക്കാലത്തു നിങ്ങളോടു കല്പിച്ചുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","പിന്നെ നമ്മുടെ ദൈവമായ യഹോവ നമ്മോടു കല്പിച്ചതുപോലെ നാം ഹോരേബിൽനിന്നു പുറപ്പെട്ടശേഷം നിങ്ങൾ കണ്ട ഭയങ്കരമായ മഹാമരുഭൂമിയിൽകൂടി നാം അമോര്യരുടെ മലനാട്ടിലേക്കുള്ള വഴിയായി സഞ്ചരിച്ചു കാദേശ്ബർന്നേയയിൽ എത്തി. ");
INSERT INTO mal2015_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","അപ്പോൾ ഞാൻ നിങ്ങളോടു: നമ്മുടെ ദൈവമായ യഹോവ നമുക്കു തരുന്ന അമോര്യരുടെ മലനാടുവരെ നിങ്ങൾ എത്തിയിരിക്കുന്നുവല്ലോ. ");
INSERT INTO mal2015_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ഇതാ, നിന്റെ ദൈവമായ യഹോവ ആ ദേശം നിന്റെ മുമ്പിൽ വെച്ചിരിക്കുന്നു; നിന്റെ പിതാക്കന്മാരുടെ ദൈവമായ യഹോവ നിന്നോടു അരുളിച്ചെയ്തതുപോലെ നീ ചെന്നു അതു കൈവശമാക്കിക്കൊൾക; ഭയപ്പെടരുതു; അധൈര്യപ്പെടുകയും അരുതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","എന്നാറെ നിങ്ങൾ എല്ലാവരും അടുത്തുവന്നു: നാം ചില ആളുകളെ മുമ്പുകൂട്ടി അയക്കുക; അവർ ദേശം ഒറ്റുനോക്കീട്ടു നാം ചെല്ലേണ്ടുന്ന വഴിയെയും പോകേണ്ടുന്ന പട്ടണങ്ങളെയും കുറിച്ചു വർത്തമാനം കൊണ്ടുവരട്ടെ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ആ വാക്കു എനിക്കു ബോധിച്ചു; ഞാൻ ഓരോ ഗോത്രത്തിൽനിന്നു ഓരോ ആൾ വീതം പന്ത്രണ്ടുപേരെ നിങ്ങളുടെ കൂട്ടത്തിൽനിന്നു തിരഞ്ഞെടുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","അവർ പുറപ്പെട്ടു പർവ്വതത്തിൽ കയറി എസ്കോൽതാഴ്‌വരയോളം ചെന്നു ദേശം ഒറ്റുനോക്കി. ");
INSERT INTO mal2015_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ദേശത്തിലെ ഫലവും ചിലതു അവർ കൈവശമാക്കിക്കൊണ്ടു നമ്മുടെ അടുക്കൽ വന്നു വർത്തമാനമെല്ലാം അറിയിച്ചു; നമ്മുടെ ദൈവമായ യഹോവ നമുക്കു തരുന്ന ദേശം നല്ലതു എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","എന്നാൽ കയറിപ്പോകുവാൻ നിങ്ങൾക്കു മനസ്സില്ലാതെ നിങ്ങളുടെ ദൈവമായ യഹോവയുടെ കല്പന നിങ്ങൾ മറുത്തു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","യഹോവ നമ്മെ പകെക്കയാൽ നമ്മെ നശിപ്പിപ്പാൻ തക്കവണ്ണം അമോര്യരുടെ കയ്യിൽ ഏല്പിക്കേണ്ടതിന്നു മിസ്രയീംദേശത്തുനിന്നു കൊണ്ടുവന്നിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","എവിടേക്കാകുന്നു നാം കയറിപ്പോകുന്നതു? ജനങ്ങൾ നമ്മെക്കാൾ വലിയവരും ദീർഘകായന്മാരും പട്ടണങ്ങൾ വലിയവയും ആകാശത്തോളം എത്തുന്ന മതിലുള്ളവയും ആകുന്നു; ഞങ്ങൾ അവിടെ അനാക്യരെയും കണ്ടു എന്നു പറഞ്ഞു നമ്മുടെ സഹോദരന്മാർ നമ്മുടെ ഹൃദയം ഉരുക്കിയിരിക്കുന്നു എന്നിങ്ങനെ നിങ്ങൾ നിങ്ങളുടെ കൂടാരങ്ങളിൽ വെച്ചു പിറുപിറുത്തു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","അപ്പോൾ ഞാൻ നിങ്ങളോടു: നിങ്ങൾ ഭ്രമിക്കരുതു, അവരെ ഭയപ്പെടുകയും അരുതു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","നിങ്ങളുടെ ദൈവമായ യഹോവ നിങ്ങളുടെ മുമ്പിൽ നടക്കുന്നു. നിങ്ങൾ കാൺകെ അവൻ മിസ്രയീമിലും മരുഭൂമിയിലും ചെയ്തതുപോലെ ഒക്കെയും നിങ്ങൾക്കുവേണ്ടി യുദ്ധം ചെയ്യും. ");
INSERT INTO mal2015_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ഒരു മനുഷ്യൻ തന്റെ മകനെ വഹിക്കുന്നതുപോലെ നിങ്ങൾ ഈ സ്ഥലത്തു എത്തുവോളം നടന്ന എല്ലാ വഴിയിലും നിങ്ങളുടെ ദൈവമായ യഹോവ നിങ്ങളെ വഹിച്ചു എന്നു നിങ്ങൾ കണ്ടുവല്ലോ എന്നു പറഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ഇതെല്ലാമായിട്ടും പാളയമിറങ്ങേണ്ടതിന്നു നിങ്ങൾക്കു സ്ഥലം അന്വേഷിപ്പാനും നിങ്ങൾ പോകേണ്ടുന്ന വഴി നിങ്ങൾക്കു കാണിച്ചുതരുവാനും ");
INSERT INTO mal2015_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","രാത്രി അഗ്നിയിലും പകൽ മേഘത്തിലും നിങ്ങൾക്കു മുമ്പായി നടന്ന നിങ്ങളുടെ ദൈവമായ യഹോവയെ നിങ്ങൾ വിശ്വസിച്ചില്ല. ");
INSERT INTO mal2015_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","ആകയാൽ യഹോവ നിങ്ങളുടെ വാക്കു കേട്ടു കോപിച്ചു: ");
INSERT INTO mal2015_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","ഞാൻ നിങ്ങളുടെ പിതാക്കന്മാർക്കു കൊടുക്കുമെന്നു സത്യം ചെയ്തിട്ടുള്ള നല്ല ദേശം ഈ ദുഷ്ടതലമുറയിലെ പുരുഷന്മാർ ആരും കാണുകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","യെഫുന്നെയുടെ മകനായ കാലേബ് മാത്രം അതു കാണുകയും അവൻ യഹോവയെ പൂർണ്ണമായി പറ്റിനിന്നതുകൊണ്ടു അവന്നും അവന്റെ പുത്രന്മാർക്കും അവൻ ചവിട്ടിയ ദേശം ഞാൻ കൊടുക്കയും ചെയ്യുമെന്നു സത്യം ചെയ്തു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","യഹോവ നിങ്ങളുടെ നിമിത്തം എന്നോടും കോപിച്ചു കല്പിച്ചതു: നീയും അവിടെ ചെല്ലുകയില്ല. ");
INSERT INTO mal2015_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","നിന്റെ ശുശ്രൂഷകനായ നൂന്റെ മകൻ യോശുവ അവിടെ ചെല്ലും; അവനെ ധൈര്യപ്പെടുത്തുക; അവനാകുന്നു യിസ്രായേലിന്നു അതു കൈവശമാക്കിക്കൊടുക്കേണ്ടതു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","കൊള്ളയാകുമെന്നു നിങ്ങൾ പറഞ്ഞ നിങ്ങളുടെ കുഞ്ഞുകുട്ടികളും ഇന്നു ഗുണദോഷങ്ങളെ തിരിച്ചറിയാത്ത നിങ്ങളുടെ മക്കളും അവിടെ ചെല്ലും; അവർക്കു ഞാൻ അതു കൊടുക്കും; അവർ അതു കൈവശമാക്കും. ");
INSERT INTO mal2015_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","നിങ്ങൾ തിരിഞ്ഞു ചെങ്കടൽവഴിയായി മരുഭൂമിയിലേക്കു യാത്ര ചെയ്‌വിൻ. ");
INSERT INTO mal2015_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","അതിന്നു നിങ്ങൾ എന്നോടു: ഞങ്ങൾ യഹോവയോടു പാപം ചെയ്തിരിക്കുന്നു. നമ്മുടെ ദൈവമായ യഹോവ ഞങ്ങളോടു കല്പിച്ചതുപോലെ ഒക്കെയും ഞങ്ങൾ പോയി യുദ്ധം ചെയ്യും എന്നു ഉത്തരം പറഞ്ഞു. അങ്ങനെ നിങ്ങൾ ഓരോരുത്തൻ താന്താന്റെ യുദ്ധായുധം ധരിച്ചു പർവ്വതത്തിൽ കയറുവാൻ തുനിഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","എന്നാൽ യഹോവ എന്നോടു: നിങ്ങൾ പോകരുതു; യുദ്ധം ചെയ്യരുതു; ഞാൻ നിങ്ങളുടെ ഇടയിൽ ഇല്ല; ശത്രുക്കളോടു നിങ്ങൾ തോറ്റുപോകും എന്നു അവരോടു പറക എന്നു കല്പിച്ചു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","അങ്ങനെ ഞാൻ നിങ്ങളോടു പറഞ്ഞു; എന്നാൽ നിങ്ങൾ കേൾക്കാതെ യഹോവയുടെ കല്പന മറുത്തു അഹമ്മതിയോടെ പർവ്വതത്തിൽ കയറി. ");
INSERT INTO mal2015_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ആ പർവ്വതത്തിൽ കുടിയിരുന്ന അമോര്യർ നിങ്ങളുടെ നേരെ പുറപ്പെട്ടുവന്നു തേനീച്ചപോലെ നിങ്ങളെ പിന്തുടർന്നു സേയീരിൽ ഹൊർമ്മാവരെ ഛിന്നിച്ചുകളഞ്ഞു. ");
INSERT INTO mal2015_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","നിങ്ങൾ മടങ്ങിവന്നു യഹോവയുടെ മുമ്പാകെ കരഞ്ഞു; എന്നാൽ യഹോവ നിങ്ങളുടെ നിലവിളി കേട്ടില്ല; നിങ്ങളുടെ അപേക്ഷെക്കു ചെവി തന്നതുമില്ല. ");
INSERT INTO mal2015_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","അങ്ങനെ നിങ്ങൾ കാദേശിൽ പാർത്ത ദീർഘകാലമൊക്കെയും അവിടെ താമസിക്കേണ്ടിവന്നു. ");
INSERT INTO mal2015_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","അനന്തരം യഹോവ എന്നോടു കല്പിച്ചതുപോലെ നാം തിരിഞ്ഞു ചെങ്കടൽവഴിയായി മരുഭൂമിയിലേക്കു യാത്രപുറപ്പെട്ടു; നാം ഏറിയനാൾ സേയീർപർവ്വതത്തെ ചുറ്റിനടന്നു. ");
INSERT INTO mal2015_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","പിന്നെ യഹോവ എന്നോടു കല്പിച്ചതു: ");
INSERT INTO mal2015_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","നിങ്ങൾ ഈ പർവ്വതം ചുറ്റിനടന്നതു മതി; വടക്കോട്ടു തിരിവിൻ. ");
INSERT INTO mal2015_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","നീ ജനത്തോടു കല്പിക്കേണ്ടതു എന്തെന്നാൽ: സേയീരിൽ കുടിയിരിക്കുന്ന ഏശാവിന്റെ മക്കളായ നിങ്ങളുടെ സഹോദരന്മാരുടെ അതിരിൽകൂടി നിങ്ങൾ കടപ്പാൻ പോകുന്നു. അവർ നിങ്ങളെ പേടിക്കും; ആകയാൽ ഏറ്റവും സൂക്ഷിച്ചുകൊള്ളേണം. ");
INSERT INTO mal2015_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","നിങ്ങൾ അവരോടു പടയെടുക്കരുതു; അവരുടെ ദേശത്തു ഞാൻ നിങ്ങൾക്കു ഒരു കാൽ വെപ്പാൻപോലും ഇടം തരികയില്ല; സേയീർപർവ്വതം ഞാൻ ഏശാവിന്നു അവകാശമായി കൊടുത്തിരിക്കുന്നു. ");
INSERT INTO mal2015_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","നിങ്ങൾ അവരോടു ആഹാരം വിലെക്കു വാങ്ങി കഴിക്കേണം; വെള്ളവും വിലെക്കു വാങ്ങി കുടിക്കേണം. ");
INSERT INTO mal2015_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","നിന്റെ ദൈവമായ യഹോവ നിന്റെ കൈകളുടെ സകലപ്രവൃത്തിയിലും നിന്നെ അനുഗ്രഹിച്ചിരിക്കുന്നു; ഈ മഹാമരുഭൂമിയിൽ നീ സഞ്ചരിക്കുന്നതു അവൻ അറിഞ്ഞിരിക്കുന്നു; ഈ നാല്പതു സംവത്സരം നിന്റെ ദൈവമായ യഹോവ നിന്നോടുകൂടെ ഇരുന്നു; നിനക്കു യാതൊന്നിന്നും മുട്ടും വന്നിട്ടില്ല. ");
INSERT INTO mal2015_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","അങ്ങനെ നാം സേയീരിൽ കുടിയിരുന്ന ഏശാവിന്റെ മക്കളായ നമ്മുടെ സഹോദരന്മാരെ ഒഴിച്ചു അരാബവഴിയായി ഏലാത്തിന്റെയും എസ്യോൻ-ഗേബെരിന്റെയും അരികത്തുകൂടി കടന്നിട്ടു തിരിഞ്ഞു മോവാബ് മരുഭൂമിയിലേക്കുള്ള വഴിയായി കടന്നുപോന്നു. ");
INSERT INTO mal2015_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","അപ്പോൾ യഹോവ എന്നോടു കല്പിച്ച