﻿USE sofia;
DROP TABLE IF EXISTS sofia.majNT_vpl;
CREATE TABLE majNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES majNT_vpl WRITE;
INSERT INTO majNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","E̱i̱ tjít'a ntje̱he̱ Jesucristo̱. Ntje̱he̱ David nibaha̱ ra̱ ko̱ ntje̱he̱ Abraham nibaha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham kama na̱'mihi̱ Isaac. Isaac kama na̱'mihi̱ Jacob. Jacob kama na̱'mihi̱ Juda̱ ko̱ já nts'e̱. ");
INSERT INTO majNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda̱ kama na̱'mihi̱ Fare̱s ko̱ Zera̱, ko̱ Tamar kama na̱aha̱. Fare̱s kama na̱'mihi̱ Esrom. Esrom kama na̱'mihi̱ Aram. ");
INSERT INTO majNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram kama na̱'mihi̱ Aminadab. Aminadab kama na̱'mihi̱ Naason. Naason kama na̱'mihi̱ Salmon. ");
INSERT INTO majNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon kama na̱'mihi̱ Booz, ko̱ Rahab kama na̱aha̱. Booz kama na̱'mihi̱ Obed, ko̱ Rut kama na̱aha̱. Obed kama na̱'mihi̱ Isai. ");
INSERT INTO majNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai kama na̱'mihi̱ nda̱ rei̱ David. David kama na̱'mihi̱ Salomon, ko̱ chju̱úhu̱n Urias kama na̱aha̱. ");
INSERT INTO majNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomon kama na̱'mihi̱ Roboam. Roboam kama na̱'mihi̱ Abias. Abias kama na̱'mihi̱ Asa. ");
INSERT INTO majNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kama na̱'mihi̱ Josafat. Josafat kama na̱'mihi̱ Joram. Joram kama na̱'mihi̱ Uzia̱s. ");
INSERT INTO majNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia̱s kama na̱'mihi̱ Jotam. Jotam kama na̱'mihi̱ Acaz. Acaz kama na̱'mihi̱ Ezekia̱s. ");
INSERT INTO majNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekia̱s kama na̱'mihi̱ Manases. Manases kama na̱'mihi̱ Amon. Amon kama na̱'mihi̱ Josia̱s. ");
INSERT INTO majNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia̱s kama na̱'mihi̱ Jeconia̱s ko̱ já nts'e̱. Kui xi tjíntu ni̱stjin nga ngjinijé xu̱ta̱ Israel Babiloni̱a̱. ");
INSERT INTO majNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","A̱skaha̱n nk'ie nga ja ngjinijé xu̱ta̱ Israel Babiloni̱a̱, Jeconia̱s kama na̱'mihi̱ Salatiel. Salatiel kama na̱'mihi̱ Zorobabel. ");
INSERT INTO majNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel kama na̱'mihi̱ Abiud. Abiud kama na̱'mihi̱ Eliakim. Eliakim kama na̱'mihi̱ Azor. ");
INSERT INTO majNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor kama na̱'mihi̱ Sadoc. Sadoc kama na̱'mihi̱ Akim. Akim kama na̱'mihi̱ Eliud. ");
INSERT INTO majNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud kama na̱'mihi̱ Eleazar. Eleazar kama na̱'mihi̱ Matan. Matan kama na̱'mihi̱ Jacob. ");
INSERT INTO majNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob kama na̱'mihi̱ Kuse. Kuse xi x'i̱hi̱n Maria̱, ko̱ Maria̱ xi na̱aha̱ Jesu. Jesu xi 'mihi̱ Cristo̱. ");
INSERT INTO majNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","B'a̱ ts'ín j'aha te ñju tíkjá ntje̱ chá xi nibaha̱ ra̱ Abraham santaha David. A̱skahan ta̱ te ñjuhú tíkjá ntje̱ chá j'a ngáha santa nkúhu nga ngjinijé xu̱ta̱ Israel Babiloni̱a̱. Ko̱ a̱skahan nk'ie nga ja ngjinijé xu̱ta̱ Israel Babiloni̱a̱, ta̱ te ñjuhú tíkjá ntje̱ chá j'a ngáha santa nkúhu nga j'ai tsin xi Cristo̱. ");
INSERT INTO majNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","B'i̱ kama nga tsín Jesucristo̱. Maria̱ xi kama na̱aha̱ Jesu, kui xi ja tjíndako̱ho̱ nga ku̱i̱xanko̱ Kuse. Tu̱nga kintehe̱ ní nga k'úéntuko̱ xinkjín, tu̱ ntíhí kik'a Maria̱, ntí xi kitsjáha̱ Espiri̱tu̱ Santo̱. ");
INSERT INTO majNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ko̱ Kuse xi ka̱ma x'i̱hi̱n, kui xi nku nda̱ xi je tjíya ani̱ma̱ha̱ ko̱ najmi mjehe̱ nga k'u̱échjit'ain Maria̱. Kui nga kama mjehe̱ ra̱ nga jyukj'i k'u̱éjñaha. ");
INSERT INTO majNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tu̱nga a̱skahán ni nga ja kits'ínnkjink'un Kuse ni xu'bi̱, nku ntítsjehe̱ Nti̱a̱ná tsakúchjihi̱ yjoho̱ nga nijñá ján ko̱ b'a̱ kitsúhu̱: —Ji Kuse xi ntje̱he̱ David, najmi tu̱ binkjuin nga n'e̱kjáín saha̱ ri̱ Maria̱ xi ja tjíndako̱hi nga ku̱i̱nchjunko̱hi. A̱t'aha̱ ntí xi y'a Espiri̱tu̱ Santo̱ kitsjáha̱. ");
INSERT INTO majNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nku ntíx'i̱n tsíhin ko̱ Jesu t'et'aihi̱ ntíu̱, a̱t'aha̱ kui xi ts'i̱ín nda̱íhi̱ ngatitsuhu̱n xu̱ta̱ xi ts'e̱ nga ts'i̱ínk'anki. ");
INSERT INTO majNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","B'a̱ kama ngayjee̱ ni xu'bi̱ tu̱ xi tsitjusuhun én xi kitsú Nti̱a̱ná nga kits'ínkinchja̱ nda̱ profeta̱: ");
INSERT INTO majNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ta̱kjín xu̱nkúu̱ k'u̱a̱ nku ntí. Nku ntíx'i̱n tsíhi̱n ko̱ Emanuel k'úín ntíu̱. Kui j'áín xi tsuhu̱ ra̱: Nti̱a̱ná tíjñajinná. ");
INSERT INTO majNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nk'ie nga j'áha̱ Kuse nga kik'a̱i̱ chi̱nihi̱, a̱s'a̱i kits'ín xi nkú nga kitsúhu̱ ntítsjehe̱ Nti̱a̱ná. Kits'ínkjáíhi̱n nga Maria̱ ka̱ma chju̱úhún. ");
INSERT INTO majNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tu̱nga najmi kits'ínko̱hó santa nkúhu nga kitsin ntíu̱, ko̱ kitsjá j'áíhi̱n nga Jesu k'úín. ");
INSERT INTO majNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Belen kitsin Jesu, nanki xi tíjñajihi̱n a̱nte Judea̱, ni̱stjin nga tjíhi̱n xá nda̱ rei̱ Herode̱. Kui ni̱stjiu̱n j'ai nanki Jerusalen já nkjink'un xi nibaha xi má tjuhu ts'íu̱ ");
INSERT INTO majNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ko̱ b'a̱ i̱ncha kitsú nga kingjásjaiya: —¿Má tíjña nda̱ rei̱hi̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ xi ja kitsiu̱n? A̱t'aha̱ santaha ján a̱nteni̱ má xi tje̱hen tju ts'íu̱, kiyai̱ niñu xi ts'e̱ ko̱ kjúái̱ n'etsjoi̱hi̱ ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nk'ie nga kint'é nda̱ rei̱ Herode̱ ni xu'bi̱, tu̱ ni xí kis'enta̱há ra̱ ko̱ ta̱ kis'enta̱ha̱ ra̱ ngayjee̱ xu̱ta̱ nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A̱s'a̱i kinchja̱ ñjaha̱ nda̱ rei̱ ngatentee̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. Kingjásjaiyaha̱ má xi tje̱hen tsín xi Cristo̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","B'a̱ i̱ncha kitsú jóo̱: —Xi tje̱hen Belen, nanki xi tíjñajihi̱n a̱nte Judea̱. A̱t'aha̱ b'a̱ ts'ín y'ét'a éhe̱n Nti̱a̱ná nda̱ profeta̱: ");
INSERT INTO majNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Máha Belen, nanki xi tíjñajihi̱n a̱nte xi ts'e̱ xu̱ta̱ Juda̱, najmi kui xi 'yún i̱chí sa a̱jihi̱n já tjíxáha̱ xu̱ta̱ Juda̱. A̱t'aha̱ yo̱ stjújin nku nda̱ tjíxá kui xi kúnnta xu̱ta̱ ts'a̱n xi xu̱ta̱ Israel. ");
INSERT INTO majNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","A̱s'a̱i Herode̱ kinchja̱ 'maha̱ já nkjink'uu̱n ko̱ kingjásjaiya ch'ich'ihi̱n mí ni̱stjihin kama chji niñuu̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nga ja kama, a̱s'a̱i kits'ínkji nanki Belen nga b'a̱ kitsúhu̱ jóo̱: —Tankíún ko̱ cha̱sjaiya sisiun ntíu̱. Nk'ie nga sa̱kúsjainu̱u, t'inya ngáhanú tu̱ xi ko̱ an kfín ts'intsjoho̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nk'ie nga ja tsasínñju já nkjink'uu̱n én xi kitsú nda̱ rei̱, i̱ncha kits'ín ngáha ni̱yá. Ko̱ niñu xi kikie a̱ntehe̱ má xi tje̱hen tju ts'íu̱, tu̱ nku tje̱n títjuhún ra̱ santa nkúhu nga tsichu sasin'yún má kjijña ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nk'ie nga kikie ngáha jóo̱ niñuu̱, tu̱ ni xí tsjohó kamaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","I̱ncha jas'en ni'yoo̱ ko̱ kikie ntíu̱ ko̱ Maria̱ xi na̱aha̱ maha. Tsinchakúnch'int'aha̱ ntíu̱ nga kits'íntsjoho̱. A̱s'a̱i kikjex'á kaxa̱ha̱ ko̱ kitsjáha̱ ntíu̱ ni xi i̱ncha y'a. Kitsjáha̱ to̱onsine, ko̱ ni xi sinjne̱ xi 'mi incienso̱, ko̱ ni xi sinjne̱ xi 'mi mirra̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","A̱s'a̱i kik'óya ngáha já nkjink'uu̱n a̱ntehe̱. Kj'a̱í ni̱yá i̱ncha jakj'á, a̱t'aha̱ kik'inya títjuhu̱n nga niñjá ján nga najmi ta̱ tjíhin nga kj'u̱a̱ha má tíjña Herode̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A̱skahan nga ja ngji já nkjink'uu̱n, nku ntítsjehe̱ Nti̱a̱ná tsakúchjihi̱ yjoho̱ Kuse nga nijñá ján ko̱ b'i̱ kitsúhu̱: —Ti̱síntje̱i̱n, chjúbéí ntíu̱ ko̱ na̱aha̱. A̱nte Egipto̱ ti̱yúko̱i̱. Yo̱ ti̱nchin santa nkúhu nga xínya kixi̱ ngáhara. A̱t'aha̱ Herode̱ ku̱a̱ngisjai ntíu̱ tu̱ xi ts'i̱ínk'iehen. ");
INSERT INTO majNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A̱s'a̱i tsisintje̱n Kuse, jakj'á ntíu̱ ko̱ na̱aha̱ ntíu̱ ko̱ tsitjuko̱ jyún nga ngji Egipto̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yo̱ y'ejña santa nkúhu nga k'ien Herode̱. B'a̱ kama tu̱ xi tsitjusuhun éhe̱n Nti̱a̱ná xi kits'ínkinchja̱ha̱ nda̱ profeta̱: “Egipto̱ kinchjaha̱ ra̱ Ntína̱.” ");
INSERT INTO majNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nk'ie nga kamankjihi̱n Herode̱ nga najmi kits'íntjusun já nkjink'uu̱n ni xi kitsúhu̱, tu̱ xí kjahán kamaha̱. Kitsjá kju̱a̱ nga n'e̱k'ien ngatentee̱ ntíx'i̱n xi tjín Belen ko̱ xi tjín a̱ndai na̱nti̱o̱. Kits'ínk'ien ngatentee̱ xi tjíhi̱n santaha jo nú, a̱t'aha̱ kik'axki̱ ni̱stjin xi kitsú já nkjink'uu̱n nga kikie niñuu̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","B'a̱ ts'ín tsitjusuhun éhe̱n Nti̱a̱ná xi y'ét'a nda̱ profeta̱ Jeremia̱: ");
INSERT INTO majNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Kinu'yá nanki Rama nku nta̱, tjín xi tíkjintáya ko̱ tu̱ xí uhún tíbehe̱. Kui xi Rakel xi tíkjintát'a ntíhi̱. Najmi ta̱ mjehe̱ ra̱ n'e̱k'íéjyu a̱t'aha̱ ja k'ien ntíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","A̱skahan nga k'ien Herode̱, nk'ie nga tíjña sa Kuse Egipto̱, nku ntítsjehe̱ Nti̱a̱ná tsakúchjihi̱ yjoho̱ nga nijñá ján ko̱ b'i̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ti̱síntje̱i̱n, chjúbéí ntíu̱ ko̱ na̱aha̱. T'inko̱ ngáhani má tjíntu xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱. A̱t'aha̱ ja jesun já xi mjehe̱ ts'i̱ínk'ien ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A̱s'a̱i tsisintje̱n Kuse, jakj'á ntíu̱ ko̱ na̱aha̱ ntíu̱ ko̱ niba ngáha má tjíntu xu̱ta̱ Israel. ");
INSERT INTO majNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kitsankjún nga ngju̱a̱i̱ a̱nte Judea̱ a̱t'aha̱ kint'é én nga Arkelao̱ tíbatéxuma yo̱ a̱ntehe̱ Herode̱ xi kama na̱'mihi̱. Tu̱nga kik'a̱i̱ chi̱ni títjuhún ra̱ xi má nga kik'inyaha̱ nga a̱nte Galilea̱ ngju̱a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A̱s'a̱i ngjik'iejña nanki xi 'mi Nazaret. B'a̱ kama tu̱ xi tsitjusuhun éhe̱n Nti̱a̱ná xi kinchja̱ já profeta̱, nga nku nda̱ xi nibáha Nazaret k'úín Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kui ni̱stjin ján j'aik'íéni̱jmí Jua Bautista̱ a̱nte kixi xi tjín a̱nte Judea̱. ");
INSERT INTO majNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","B'i̱ kitsú nga y'éni̱jmí: —Tankínchj'a̱ha̱ ru̱u ani̱ma̱nu̱u, a̱t'aha̱ ja 'yún tiña tíjñanu̱u Nti̱a̱ná nga tíbatéxumanu̱u nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jua kinchja̱ni̱jmíyaha nda̱ profeta̱ Isaia̱ nk'ie nga b'i̱ ts'ín y'ét'a: Tínu'yá nta̱ha̱ nku nda̱ xi tíkjintáya a̱nte kixiu̱: “T'endo ni̱yáha̱ Nti̱a̱ná. Tjen na̱xu̱u ni̱yáha̱.” ");
INSERT INTO majNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nk'ie nga y'ejña Jua, najyun xi kamandako̱ho ntsja̱ha̱ chu̱ camello̱ bja ko̱ nku tja̱ba̱xín b'ékjá. Chju̱ba̱ ko̱ ntsjényá kjine. ");
INSERT INTO majNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tsitju xu̱ta̱ nanki Jerusalen ko̱ ngayjee̱ xu̱ta̱ xi tjín a̱nte Judea̱ ko̱ a̱ndai ntáje̱ Jordan nga j'aisehe̱ Jua. ");
INSERT INTO majNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","I̱ncha kisaténtájin ntáje̱ Jordan nk'ie nga kits'ínkie yjoho̱ nga tjíhi̱n ngatitsun. ");
INSERT INTO majNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nk'ie nga kikie Jua nga nkjin já fariseo̱ ko̱ já saduseo̱ tíi̱ncha f'ai nga mjehe̱ nga sa̱téntá, a̱s'a̱i b'i̱ kitsúhu̱: —¡Já ch'onk'un xi b'a̱ k'un! ¿Yá xi b'a̱ kitsúnu̱u nga ku̱i̱yúhu̱u kju̱a̱kjaha̱n Nti̱a̱ná xi ja tje̱n tiña? ");
INSERT INTO majNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tu̱ sahá n'o̱o ni xi ku̱a̱kúchji nga ja tsankinchj'aha̱ ru̱u ani̱ma̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Najmi tu̱ yjonu̱u ch'ana̱cho̱ho̱o: “Ntje̱he̱ Abraham ñá”, tsa ku̱i̱xíún. A̱t'aha̱ an b'a̱ tíxinnu̱u nga santaha kui ndji̱o̱i̱ Nti̱a̱ná ka̱ma ts'i̱ín ma ntje̱he̱ Abraham. ");
INSERT INTO majNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ja tíjña nda icho̱ nd'a̱i̱ nga ku̱a̱te kja̱ma̱ha̱ yóo̱. Kui nga ngayjee̱ yá xi najmi nda tu xi tsjáha, kui xi stísun ko̱ chja̱nikj'ajin a̱jin nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’An ntánijua tíbatentáko̱ho̱nu̱u tu̱ xi ku̱a̱kínchj'a̱ha̱ ru̱u ani̱ma̱nu̱u. Tu̱nga xi nibáha a̱skahan nga an 'yún nk'a tje̱n sa, xi ndaha̱chí najmi tsuhuna tsa kfínko̱ho̱ ntéhe̱. Kui xi Espiri̱tu̱ Santo̱ ko̱ nd'í ku̱a̱téntáko̱ho̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kui xi nkú joyaha nda̱ xi ts'ín chuhu̱n tuni̱ñu̱. Ja kjiya ntsja yá xi ts'ín chunko̱ho̱ ra̱ tuni̱ñu̱hu̱, tu̱ xi ts'i̱ínkj'a t'axíhin tuni̱ñu̱ ko̱ xin ts'i̱ínkj'a tja̱ba̱ha̱. A̱s'a̱i kj'u̱átjo tuni̱ñu̱ ni'ya nji̱hi̱ ko̱ k'u̱éti tja̱ba̱ha̱ a̱jin nd'í xi najmi ta̱ ka̱maha̱ ra̱ ku̱a̱yáyaha. ");
INSERT INTO majNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","A̱s'a̱i tsitju Jesu a̱nte Galilea̱. Ntáje̱ Jordan j'aisehe̱ Jua tu̱ xi ku̱a̱téntáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tu̱nga najmi títs'ín yuhú Jua nga tjuhun. B'i̱ kitsúhu̱ Jesu: —Ji ní xi tjíhin nga ku̱a̱tentání. ¿Nkú tjíhi̱n ra̱ nga an tínibásehení nga kuatentáhara? ");
INSERT INTO majNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tu̱nga b'i̱hí kitsú Jesu: —N'e̱ yi nd'a̱i̱, a̱t'aha̱ nda tjín nga n'e̱tjusaán ngatentee̱ ni xi mjehe̱ Nti̱a̱ná. A̱s'a̱i kits'ín yu Jua. ");
INSERT INTO majNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nk'ie nga ja kisaténtá Jesu, a̱s'a̱i tsitjujin ntánijuo̱ ko̱ tu̱ tsix'áhá nk'a ján ko̱ kikie Jesu Espiri̱tu̱hu̱ Nti̱a̱ná xi nkú joyaha nku chu̱tuju nga nibajennehe̱. ");
INSERT INTO majNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","A̱s'a̱i kinu'yá nk'a ján nku nta̱ xi b'a̱ kitsú: —Kui xu'bi̱ xi Ntína̱. 'Yún tjona. Tsjo ṉkjún mana Ntína̱. ");
INSERT INTO majNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","A̱s'a̱i Espiri̱tu̱ Santo̱ ngjiko̱ t'axíhi̱n Jesu a̱nte kixiu̱ tu̱ xi kjút'ayák'uhu̱n ra̱ nda̱nindoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yo̱ y'ejña kjintíá yachán ni̱stjin ko̱ yachán ni̱stje̱n. A̱skahan kama bjoho̱. ");
INSERT INTO majNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","A̱s'a̱i nda̱nindoo̱ j'ai kjut'ayák'uhu̱n nga b'i̱ kitsúhu̱: —Tsa kju̱axi̱ nga ji xi Ntíhi̱ Nti̱a̱ná, b'a̱ t'ihi̱n ndji̱o̱i̱ nga ni̱nku̱a̱n katuma. ");
INSERT INTO majNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","B'i̱ kitsú Jesu: —B'i̱ títsu xu̱ju̱n éhe̱n Nti̱a̱ná: “Najmi nku tutu ni̱nku̱o̱n xi ts'ín nga b'entu tík'un xu̱ta̱. Ko̱ ní ngayjee̱ éhe̱n Nti̱a̱ná machjéhe̱n xu̱ta̱.” ");
INSERT INTO majNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","A̱s'a̱i nda̱nindoo̱ ngjiko̱ Jesu nanki Jerusalen. Kits'ín s'esun má 'yún nk'aha̱ ni̱nku̱ ");
INSERT INTO majNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ko̱ b'a̱ kitsúhu̱: —Tsa kju̱axi̱ nga ji xi Ntíhi̱ Nti̱a̱ná, chja̱nikj'anki yjohi̱. A̱t'aha̱ b'a̱ títsu xu̱ju̱n éhe̱n Nti̱a̱ná: Nti̱a̱ná k'u̱éxá ntítsjehe̱ xi má nga kúhin. Kjésíntje̱nya ntsjahi tu̱ xi ndaha nku ndji̱o̱ najmi sa̱ténkihi tsu̱kui. ");
INSERT INTO majNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A̱s'a̱i b'i̱ kitsú Jesu: —Ko̱ b'i̱ ta̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “Najmi tu̱ ji chjut'ayák'uin Nti̱a̱ná, kui xi Nti̱a̱hi̱ maha.” ");
INSERT INTO majNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A̱s'a̱i tu̱ sa nkuhú a̱sunntu tje̱nki̱ xi 'yún nk'a ngjiko̱ ngáha nda̱nindoo̱. Yo̱ tsakúyjehe̱ má batéxuma já rei̱ xi tjín a̱sunntee̱ ko̱ kju̱a̱chánka xi tjíhi̱n nga nkúnkú ");
INSERT INTO majNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ko̱ b'a̱ kitsúhu̱: —Ts'inkjas'ehen ngatentee̱ ni xu'bi̱ tsa ku̱i̱si̱nkúnch'int'aní nga cha̱nkjúnní. ");
INSERT INTO majNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","B'i̱ kitsú Jesu: —T'in t'axínní, Satana. A̱t'aha̱ b'a̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “Cha̱nkjúín Nti̱a̱ná, kui xi Nti̱a̱hi̱ maha ko̱ nkuhú kui ku̱i̱nú'yá'éíhi̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","A̱s'a̱i ngji t'axín nda̱nindoo̱ nga y'éjña suba Jesu, ko̱ i̱ncha j'ai ntítsjehe̱ Nti̱a̱ná nga j'aisinko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nk'ie nga kint'é én Jesu nga kjiya'yún Jua, ngji a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tsitju nanki Nazaret nga ngjik'iejña Capernaum, nanki xi tíjña a̱ndai ntáchak'uu̱n xi tje̱hen má nga y'entu xu̱ta̱ xi y'aha̱ ra̱ ntje̱ chá Zabulon ko̱ xi y'aha̱ ra̱ ntje̱ chá Neftali. ");
INSERT INTO majNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","B'a̱ kama tu̱ xi tsitjusuhun éhe̱n Nti̱a̱ná xi y'ét'a nda̱ profeta̱ Isaia̱ nga b'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","A̱ntehe̱ xu̱ta̱ xi y'aha̱ ra̱ Zabulon ko̱ a̱ntehe̱ xu̱ta̱ xi y'aha̱ ra̱ Neftali, a̱nte xi tiña maha̱ a̱ndai ntáchak'uu̱n, ngabantá ntáje̱ Jordan, Galilea̱ má nga ta̱ tjíntu xu̱ta̱ xi najmi ntje̱ Israel y'aha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Xi tjíntu má jyuu̱n ja kikie nku nd'í chánka. Xi tjíntu má tje̱n nk'íéhe̱n ngabayoo̱ ja kitsjehe̱n nku nd'í. ");
INSERT INTO majNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kui ni̱stjiu̱n kik'atuts'i̱hi̱n Jesu nga y'éni̱jmí. B'i̱ kitsú nga kinchja̱ko̱ xu̱ta̱: —Tankínchj'a̱ha̱ ru̱u ani̱ma̱nu̱u, a̱t'aha̱ ja 'yún tiña tíjñanu̱u Nti̱a̱ná nga tíbatéxumanu̱u nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nk'ie nga tsú'ba Jesu a̱ndai ntáchak'un Galilea̱, kikie jo já xi nts'e̱ maha xinkjín. Kui xi Simon xi ta̱ 'mi Pedro̱ ko̱ Andre. Tíi̱ncha kjaníkj'a na̱'ya tji̱o̱ho̱ a̱jin ntóo̱, a̱t'aha̱ tji̱o̱ i̱ncha tsuba jóo̱. B'i̱ kitsú Jesu: ");
INSERT INTO majNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Jun já, tsjénnkinú. An ts'ian nga xu̱ta̱ nu̱bo̱o. ");
INSERT INTO majNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ta̱ kuihi chu̱bo̱ y'éntu jóo̱ na̱'yaha̱ ko̱ kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A̱s'a̱i ngjindju sa ko̱ yo̱ kikie jo já xi ta̱ nts'e̱ maha xinkjín. Kui xi Santiago̱ ko̱ Jua xi jáha̱ Zebedeo̱. Tjíntuyáko̱ tsutsuhu̱ na̱'mihi̱ nga tíi̱ncha b'énda na̱'yaha̱. A̱s'a̱i kinchja̱ha̱ Jesu jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ta̱ kuihi chu̱bo̱ y'éntu jóo̱ tsutsuu̱ ko̱ na̱'mihi̱ nga kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kikjatsú'ba Jesu ngayjee̱ a̱nte xi tjín Galilea̱. Tsakúya a̱ya ni'ya sinagoga̱ xi tjín yo̱ ko̱ y'éni̱jmí én nda tsuhu̱ Nti̱a̱ná nga Nti̱a̱ná xi batéxuma. Kits'ínnkihi̱ tu̱ mí ch'ihín ni xi k'uhu̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A̱s'a̱i ngayjee̱ a̱nte xi tjín a̱nte Siri̱a̱ kichubani̱jmíyaha Jesu. J'aich'áha̱ ngatentee̱ xu̱ta̱ un xi tjín yo̱, xi tíneya yjoho̱ nga nkjin tíkjá ch'in xi k'uhu̱n, xi un tíbehe̱, xi tjíntujíhi̱n jánindoo̱, xi tjíhi̱n ch'in b'atsé, ko̱ xi najmi ma fi. Kits'ínnkihi̱ Jesu ngatentee̱ xu̱ta̱ uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kitsjennkíhi̱ Jesu nkjin ṉkjún xu̱ta̱ xi nibaha a̱nte xi tjín Galilea̱ ko̱ Decapo̱li̱, xi nibaha nanki Jerusalen ko̱ a̱nte xi tjín Judea̱ ko̱ xi tjín ngabantá ntáje̱ Jordan. ");
INSERT INTO majNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nk'ie nga kikie Jesu nga tíma ñjakú ṉkjún xu̱ta̱, a̱s'a̱i ngjinji nku a̱sunntu tje̱nki̱ ko̱ yo̱ y'ejña. Yo̱ kama ñjat'áha̱ xu̱ta̱ ni'yakuyáha̱, ");
INSERT INTO majNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ko̱ b'i̱ kitsú Jesu nga tsakúyaha̱: ");
INSERT INTO majNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi najmi tjíhi̱n ra̱ kju̱a̱nchi̱ná xi tíma 'yún k'un, a̱t'aha̱ kui xi tjíntujín má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi tíkjintáha, a̱t'aha̱ kui xi n'e̱k'íéjyu. ");
INSERT INTO majNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi ni̱ma̱kju̱a̱ha, a̱t'aha̱ kui xi ts'i̱ínkjáíhi̱n nga ka̱ma ts'e̱ t'anankiu̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi mangimjehe̱ ra̱ nga na̱xu̱ ka̱maha, a̱t'aha̱ kui xi na̱xu̱ ka̱ma. ");
INSERT INTO majNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi ma ni̱ma̱ha̱ ra̱ xu̱ta̱, a̱t'aha̱ kui xi cha̱se̱ ni̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi je tjíyaha ani̱ma̱ha̱, a̱t'aha̱ kui xi sku̱e̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi tsjáha kju̱a̱jyu má nga tjín kju̱a̱chán, a̱t'aha̱ kui xi k'úín ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi tín'e unchaha nk'ie nga na̱xu̱ ts'ín, a̱t'aha̱ kui xi tjíntujín má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Á b'a̱ nda tjíhin ts'a̱jun nk'ie nga ch'on ku̱i̱tsu̱nu̱u xu̱ta̱ ko̱ nga tsjénnki unkienu̱u ko̱ nga nkjin tíkjá én tsank'á ch'on tsu ku̱i̱tsu̱nu̱u tu̱ nga̱t'ana̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tsjo katumanu̱u ko̱ 'yún tsjo kat'enu̱u, a̱t'aha̱ 'yún chánka chjí xi n'e̱kjáín ngáha̱ ru̱u ndji̱o̱jmi ján. A̱t'aha̱ b'a̱ ta̱ kin'ehe̱ já profeta̱ xi tjun kis'e nga jun. ");
INSERT INTO majNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Jun xi nkú joyaha na̱xa̱ha̱ a̱sunntee̱. Tu̱nga tsa ndyja̱ nga'yúhu̱n na̱xo̱, ¿nkú ts'ín ka̱ma ntia ngáha? Nku ni xi najmi chumi ni chjíhi̱ ra̱ ka̱ma. Tu̱ ngju̱a̱i̱yahá sa na̱tsin ján ko̱ ku̱a̱si̱nnehe̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Jun xi nkú joyaha nd'íhi̱ a̱sunntee̱. Nku nanki xi tíjñasun nku a̱sunntu tje̱nki̱ najmi ma s'ejña 'ma. ");
INSERT INTO majNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nk'ie nga nd'í b'éti xu̱ta̱, najmi kinte kaxa̱ b'éjñanki. Tu̱ sa ní b'éjña nk'a tu̱ xi ts'ín ndzjehe̱n ra̱ nd'íu̱ ngatentee̱ xu̱ta̱ xi tjíntu a̱yoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","B'a̱ ts'ín kats'ín ndzjen nd'ínu̱u nginku̱n xu̱ta̱, tu̱ xi sku̱e̱he xu̱ta̱ ni xi nda tín'o ko̱ ts'i̱íntsjoho̱ Na̱'minu̱u xi tíjña ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Najmi tu̱ b'a̱ ts'ín n'enkjíntak'un tsa an jái̱ ts'inndyja kju̱a̱téxumoo̱ ko̱ ni xi tsakúya já profeta̱. Najmi jái̱ ts'inndyja niu̱. Jái̱ ts'intjusan níná niu̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A̱t'aha̱ kju̱axi̱ ni xi tíxinnu̱u. Ndaha nku ntu xi tjít'a kju̱a̱téxumoo̱ ndaha̱chí najmi ndyja̱jihi̱nsén nk'ie nga tíjña sa nk'a ján ko̱ t'anankiu̱. Ku̱i̱tjusunyje ní. ");
INSERT INTO majNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","’Kui b'a̱ maha, tsa tjín xi najmi ts'i̱ínchjí ndaha tsa tu̱ nku kju̱a̱téxuma i̱chí xi tjít'a kju̱a̱téxumoo̱, ko̱ tsa b'a̱ ts'ín ku̱a̱kúyaha̱ xu̱ta̱ xi kj'a̱í, kui xi 'yún i̱chí ka̱ma ngáha má batéxuma Nti̱a̱ná. Tu̱nga tsa tjín xi ts'i̱ín xi nkú títsu kju̱a̱téxumoo̱, ko̱ tsa b'a̱ ts'ín ku̱a̱kúyaha̱ xu̱ta̱ xi kj'a̱í, kui xi chánka ka̱ma ngáha má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A̱t'aha̱ an b'a̱ tíxinnu̱u. Tjíhin nga 'yún na̱xu̱ n'e̱tjusun so jun ni xi mjehe̱ Nti̱a̱ná nga já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱. Tsa najmi b'a̱ n'o̱o, ndaha̱chí najmi ku̱i̱ntsu̱ba̱jiun má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ja kinu'yó nga b'a̱ kik'ihi̱n xu̱ta̱ xi kis'e ni̱stjin nk'ie: “Najmi tu̱ n'ek'iein. Tsa tjín xi ts'i̱ínk'ien ani̱ma̱, kui xi tjíhin nga n'e̱ kju̱a̱ha̱ ra̱.” ");
INSERT INTO majNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tu̱nga an b'a̱ tíxinnu̱u nga tu̱ yáhá ni xi ts'i̱ínkjanko̱ nda̱ nts'e̱, kui xi tjíhin nga n'e̱ kju̱a̱ha̱ ra̱. Tu̱ yáhá ni xi b'a̱ ku̱i̱tsu̱hu̱ nda̱ nts'e̱: “Á b'a̱ nkjún ts'ín stje̱henni”, kui xi n'e̱ kju̱a̱ha̱ nginku̱n já tjíxóo̱. Ko̱ tu̱ yáhá ni xi b'a̱ ku̱i̱tsu̱hu̱ nda̱ nts'e̱: “Á b'a̱ 'yún chi̱nihini ji”, kui xi tje̱he̱n ra̱ nd'íhi̱ nga̱k'i̱e̱n. ");
INSERT INTO majNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Kui b'a̱ maha, tsa tí'ba̱i̱hini chje̱hi̱ a̱sun na̱chan chje̱ ko̱ tsa yo̱ kj'u̱a̱ítsjein nga tinchun chánko̱i̱ nda̱ nts'ei, ");
INSERT INTO majNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tu̱ sahá t'ejñai chje̱hi̱ a̱nkjín na̱chan chje̱ ko̱ t'in chu̱bako̱ nda mahi tjun nda̱ nts'ei. A̱s'a̱i nibák'a̱i̱ ngáhani chje̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Ki̱tsa̱ t'endako̱i̱ xi tífitéjénehi nk'ie nga tje̱nko̱ sai a̱ya ni̱yóo̱, tu̱ xi najmi ts'i̱ínkjas'ehe̱n ra̱ ji nda̱ jue. A̱t'aha̱ tsa ts'i̱ínkjas'ehin nginku̱n nda̱ jue, a̱s'a̱i nda̱ jue ts'i̱ínkjas'en ngáha ri a̱ya ntsja nda̱ xi kunnta nu̱ba̱yóo̱ ko̱ kui xi ngju̱áya'yíhin. ");
INSERT INTO majNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kju̱axi̱ ni xi tíxihin. Najmi ku̱i̱tjui yo̱ santa nkúhu nga k'úéchjíyjei to̱on xi tje̱hin. ");
INSERT INTO majNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ja kinu'yó nga b'a̱ kik'ihi̱n xu̱ta̱ ni̱stjin nk'ie: “Najmi tu̱ biyunéí kju̱a̱bixahi̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tu̱nga an b'a̱ tíxinnu̱u nga tu̱ yáhá ni xi ku̱a̱se̱he̱ nku ta̱chju̱ún nga ngju̱ásihi̱n, kui xi a̱jin ani̱ma̱ha̱ ja kuakangane kju̱a̱bixaha̱n. ");
INSERT INTO majNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Kui nga tsa tunkuin kixi̱ xi títs'ínkijnejihin ri jé, tu̱ sahá n'e̱sjei ko̱ kjin chja̱niyai. A̱t'aha̱ tu̱ sahá nda tjín nga̱t'a ts'i̱ tsa ndyja̱t'a nku tíkjá yjonintehi̱, tu̱ xi b'a̱ ts'ín najmi chja̱nikj'ajihin nga̱k'i̱e̱n ngayjee̱ yjonintehi̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ko̱ tsa ntsa̱i̱ kixi̱ xi títs'ínkijnejihin jé, tu̱ sahá ti̱chákjáí ko̱ kjin chja̱niyai. A̱t'aha̱ tu̱ sahá nda tjín nga̱t'a ts'i̱ tsa ndyja̱t'a nku tíkjá yjonintehi̱, tu̱ xi b'a̱ ts'ín najmi chja̱nikj'ajihin nga̱k'i̱e̱n ngayjee̱ yjonintehi̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’B'a̱ ta̱ kik'in yaha̱ xu̱ta̱ ni̱stjin nk'ie: “Nda̱ xi k'u̱éjña chju̱úhu̱n, kui xi tjíhin nga tsjáha̱ nku xu̱ju̱n xi má nga ja kits'ínkje kju̱a̱bixaha̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tu̱nga an b'a̱ tíxinnu̱u. Tsa nku nda̱ k'u̱éjña chju̱úhu̱n, tsa chju̱úhu̱n najmi kik'at'aha̱, kui ndo̱ títs'ín nga chju̱úhu̱n tíbangane kju̱a̱bixoo̱n. Ko̱ tsa kj'a̱í nda̱ ku̱i̱xanko̱ ngáha ta̱chju̱ún xi y'éjñaha̱ x'i̱hi̱n, kui ndo̱ xi ta̱ tíbangane ni xi 'mihi̱ kju̱a̱bixan. ");
INSERT INTO majNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ja kinu'yó nga b'a̱ kik'ihi̱n xu̱ta̱ xi kis'e ni̱stjin nk'ie: “Najmi tu̱: Kate Nti̱a̱ná, bixín tsank'áí. Tu̱ sahá n'e̱tjusuin ni xi tín'ekiei Nti̱a̱ná.” ");
INSERT INTO majNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tu̱nga ahán b'a̱ tíxinnu̱u. Ndaha̱chí najmi tu̱ “kate Nti̱a̱ná” bixíún. Najmi tu̱ ndji̱o̱jmi ján nungijiun ni xi ku̱i̱xíún, a̱t'aha̱ yo̱ tíjña Nti̱a̱ná nga batéxuma. ");
INSERT INTO majNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ta̱ ndaha najmi tu̱ t'anankiu̱ nungijiun ni xi ku̱i̱xíún, a̱t'aha̱ Nti̱a̱ná batéxumaha̱. Ta̱ ndaha najmi tu̱ nanki Jerusalen nungijiun ni xi ku̱i̱xíún, a̱t'aha̱ kui xi nankihi̱ Nda̱ Rei̱ k'aku̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","’Ko̱ ta̱ ndaha najmi tu̱ nintaku nungijiun ni xi ku̱i̱xíún, a̱t'aha̱ najmi manu̱u n'ek'óntjaiyo ndaha nku ntsja̱ku tsa taba ko̱ tsa jma n'ek'íó. ");
INSERT INTO majNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tsa tíchasjaiyanu̱u, “joho̱n” ti̱xíún tsa b'a̱ tjín ko̱ “najmi” ti̱xíún tsa najmi b'a̱ tjín. A̱t'aha̱ én xi s'esun saha̱, kui xi nibáha̱ ra̱ nda̱nindoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ja kinu'yó nga b'a̱ kik'ihi̱n xu̱ta̱ ni̱stjin nk'ie: “Xi ch'on ts'i̱ín, n'e̱ ngajoya ngáha̱ ra̱ xi nkú kats'ín. Tsa nku tunku̱n kats'ín'uhu̱n, a̱ nku tunku̱n n'e̱'uhu̱n. Tsa nku ni̱'yu̱n kats'ín'uhu̱n, a̱ nku ni̱'yu̱n n'e̱'uhu̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tu̱nga ahán b'a̱ tíxinnu̱u nga tjehe̱nntoho̱o xi ch'on títs'ínnu̱u. Tsa tjín xi k'o̱njin tsa̱ kixi̱hi̱, tjeihi̱n ko̱ tsa̱ skjúhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tsa tjín xi mjehe̱ ts'i̱ínko̱kju̱a̱hi xi má nga kjé'ahi chi̱nkahi̱, tjeihi̱n ko̱ chi̱nka ntsja̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tsa tjín xi ts'i̱ín kju̱a̱'yúhun ri nga k'úínko̱i̱ ch'áha̱ nku kilome̱tru̱ tjíhin, tu̱ sahá t'inko̱i̱ jo kilome̱tru̱ tjíhin. ");
INSERT INTO majNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tjeihi̱n xi ku̱a̱nkihi tsa mí nihi ko̱ najmi tu̱ xin chasei tsa tjín xi mjehe̱ ku̱e̱nyahi tsa mí nihi. ");
INSERT INTO majNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ja kinu'yó nga b'a̱ kik'ihi̱n xu̱ta̱ ni̱stjin nk'ie: “N'e̱tjóí xu̱ta̱ xinki̱ ko̱ n'e̱ unchai xu̱ta̱ kontra̱hi̱.” ");
INSERT INTO majNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tu̱nga ahán b'a̱ tíxinnu̱u nga tu̱ sahá n'e̱tjó xu̱ta̱ kontra̱nu̱u. Ti̱nchíhu̱u Nti̱a̱ná nga nda kats'ínko̱ xi ch'on títsunu̱u. Nda n'o̱ho̱o xi unkienu̱u. Chu̱bantjo nginku̱n Nti̱a̱ná xi ch'on títs'ínnu̱u ko̱ xi tje̱nnki unkienu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","’B'a̱ n'o̱o tu̱ xi b'a̱ ts'ín ka̱mahanu ntíhi̱ Na̱'minu̱u xi tíjña ndji̱o̱jmi ján. A̱t'aha̱ kui xi ts'íntjuhu̱ ts'íu̱ ngayjee̱ xu̱ta̱, ndaha tsa xi ch'onk'un ko̱ ndaha tsa xi nda. Ko̱ ts'ínk'aha̱ ts'í ngayjee̱ xu̱ta̱, ndaha tsa xi na̱xu̱ ts'ín ko̱ ndaha tsa xi najmi na̱xu̱ ts'ín. ");
INSERT INTO majNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","A̱t'aha̱ tsa n'e̱tjó xi tjoho̱ jun, ¿mí chjíhi xi ku̱i̱jne̱nu̱u nk'ie? Santaha já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ b'a̱ ta̱ i̱ncha ts'ín. ");
INSERT INTO majNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ko̱ tsa tu̱ subahá já nts'o xi súniñoho̱o, ¿mí ni nda tjíhin xi tín'o nk'ie? Santaha xu̱ta̱ xi najmi be Nti̱a̱ná b'a̱ ta̱ i̱ncha ts'ín. ");
INSERT INTO majNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Katumo xi tjíhin nga ka̱mo. A̱t'aha̱ tsjehé Na̱'minu̱u xi tíjña ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Najmi tu̱ nginku̱n xu̱ta̱ na̱xu̱ n'esjo yjonu̱u, tsa tu̱ xi sku̱e̱he̱nu̱u nga na̱xu̱ tín'o. A̱t'aha̱ tsa b'a̱ n'o̱o, najmi chumi ni chjíhi xi tsjánu̱u Na̱'minu̱u xi tíjña ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Kui b'a̱ maha, nk'ie nga k'u̱a̱i̱hini chje̱hi̱, najmi tu̱ tjio títjun n'ekjanei, xi nkú ts'ín xu̱ta̱ xi tu̱ tsjohó ra̱ bakúchji xi nkú ts'ín benkjún Nti̱a̱ná a̱ya ni'ya sinagoga̱ ko̱ a̱ya ni̱yóo̱, tu̱ xi nda sku̱e̱he̱ ra̱ xu̱ta̱. Kju̱axi̱ ni xi tíxinnu̱u. Ja títs'ínkjáíhi̱n chjí xi ts'e̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tu̱nga ji, nk'ie nga tí'ba̱i̱ chje̱hi̱, najmi tjíhin nga sku̱e̱ ntsa̱ skjúín ni xi títs'ín ntsa̱ kixi̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tu̱ sahá jyuhú kj'i tjein chje̱hi̱. Ko̱ kui Na̱'mihi̱ xi tíbe ni xi 'ma tín'ei, kui xi tsjáhi chjíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Nk'ie nga chu̱bako̱o Nti̱a̱ná, najmi b'a̱ tu̱ n'o xi nkú ts'ín xu̱ta̱ xi tu̱ tsjohó ra̱ bakúchji xi nkú ts'ín benkjún Nti̱a̱ná. Kui xi tsjoho̱ bincha ndju a̱ya ni'ya sinagoga̱ ko̱ ni̱yátée̱ nk'ie nga nchja̱ko̱ Nti̱a̱ná, tu̱ xi sku̱e̱he̱ ra̱ xu̱ta̱. Kju̱axi̱ ni xi tíxinnu̱u. Ja títs'ínkjáíhi̱n chjí xi ts'e̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tu̱nga ji, nk'ie nga chu̱bako̱i̱ Nti̱a̱ná, ti̱tjás'e̱i̱n a̱ya 'mahi̱, t'echjáí a̱nkju̱a̱hi̱ ko̱ chu̱bako̱i̱ Na̱'mihi̱ xi tíjñako̱ subahi má 'moo̱. Ko̱ kui Na̱'mihi̱ xi tíbe ni xi 'ma tíma, kui xi tsjáhi chíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Nk'ie nga chu̱bako̱o Nti̱a̱ná, najmi tu̱ n'e chjón én xi najmi tjíhi̱n sin, tsa ta̱ kui ta̱ maha én xi chu̱bo, xi nkú ts'ín xu̱ta̱ xi tjín a̱sunntee̱. Kui xi b'a̱ maha̱ nga ngju̱énñjuhu̱ Nti̱a̱ná tu̱ nga̱t'aha̱ nga 'yún tse tínchja̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kui nga najmi b'a̱ tu̱ n'ehenu jun xi nkú nga ts'ín xu̱ta̱ xu'bo̱. A̱t'aha̱ jahá be títjun Na̱'minu̱u ni xi machjénnu̱u kintehe̱ ni nga ku̱i̱nchíhu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","’Kui b'a̱ maha, b'i̱ ts'ín chu̱bako̱honu Nti̱a̱ná: Ji Na̱'mini̱ xi tinchin ndji̱o̱jmi ján, katenkjúhin xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ta̱texumani̱. Katuma t'anankii̱ ni xi mjehi xi nkú nga ta̱ tíma ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tjenni̱ nd'a̱i̱ nichine xi machjénni̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","N'e̱ndyjat'ani̱ ngatitsunni̱, xi nkú ts'ín ji̱n ta̱ n'endyjat'ai̱hi̱ xi ch'on títs'ínni̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Najmi tu̱ 'ba̱i̱ntei nga ku̱i̱jne̱jii̱n nga chjút'ayák'unni̱. Tu̱ sahá chjúxinni̱ ni xi ch'onk'uu̱n. A̱t'aha̱ ji xi batexumai, ko̱ ji xi tjíhin nga'yún, ko̱ ji xi tjíhin kju̱a̱chánka tu̱ nkj'íéhé ni. B'a̱ tjín. ");
INSERT INTO majNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’A̱t'aha̱ tsa n'e̱ndyjat'oho̱o xu̱ta̱ xi ch'on títs'ínnu̱u, b'a̱ ta̱ ts'ín ts'i̱ínndyjat'anu̱u Na̱'minu̱u xi tíjña ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tu̱nga tsa najmi n'e̱ndyjat'oho̱o xu̱ta̱ xi ch'on títs'ínnu̱u, b'a̱ ta̱ ts'ín Na̱'minu̱u najmi ts'i̱ínndyjat'anu̱u ngatitsunnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Nk'ie nga ku̱i̱ntsu̱ba̱ kjintíó, najmi tu̱ nusin kat'enu̱u xi nkú 'behe̱ xu̱ta̱ xi tu̱ tsjohó ra̱ bakúchji xi nkú ts'ín benkjún Nti̱a̱ná. A̱t'aha̱ kui xi ndzjen ts'ínk'íé a̱nkjín tu̱ xi sku̱e̱he̱ ra̱ xu̱ta̱ nga tjíntu kjintíá. Kju̱axi̱ ni xi tíxinnu̱u. Ja títs'ínkjáíhi̱n chjí xi ts'e̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tu̱nga ji, nk'ie nga ku̱i̱nchun kjintíáí, tu̱ sahá chjújin na̱tí sisin ntsja̱hi̱ ko̱ ta̱nejin a̱nkjin. ");
INSERT INTO majNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","B'a̱ ts'ín najmi sku̱e̱he xu̱ta̱ nga tinchun kjintíáí. Tu̱ Na̱'mihi̱ ní xi sku̱e̱, a̱t'aha̱ kui xi tíjñako̱ subahi má 'moo̱. Ko̱ kui Na̱'mihi̱ xi tíbe ni xi 'ma tíma, kui xi tsjáhi chjíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Najmi tu̱ e̱i̱ a̱sunntei̱ n'e nchi̱náí yjohi̱, má nga ts'ínkatsúhu̱n xubíu̱ ni xi tjín ko̱ má nga ma stu ni xi tjín ko̱ má fas'en já ndyjée̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tu̱ sa ní ndji̱o̱jmi ján n'e̱ nchi̱náí yjohi̱, má nga najmi ts'ínkatsúhu̱n xubíu̱ ni xi tjín ko̱ má nga najmi ma stu ni xi tjín ko̱ má najmi fas'en já ndyjé. ");
INSERT INTO majNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","B'a̱ tíxihin a̱t'aha̱ má nga tíjña kju̱a̱nchi̱náhi̱, yo̱ ta̱ tíjña ani̱ma̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Tunkuin, kui xi xi nkú joyaha nku nd'í xi ts'ín ndzjehe̱n yjonintehi̱. Kui b'a̱ maha, tsa tunkuin fas'en ni xi nda, ngayjee̱ yjonintehi̱ s'e ndzjehe̱n. ");
INSERT INTO majNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tu̱nga tsa ni xi najmi nda fas'en tunkuin, ngayjee̱ yjonintehi̱ s'e jyuhu̱n. Kui nga tsa ni xi tjíhin nga ts'i̱ín ndzjehen ri tu̱ sahá ts'ín jyun, ¡'yún ṉkjún jyun má tinchin ma! ");
INSERT INTO majNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ndaha nku nda̱ musu̱ najmi ma ts'ínxát'aha̱ jo já nti̱a̱. A̱t'aha̱ nku xi ts'i̱ín unkie ko̱ nku xi ts'i̱íntjo, ko̱ a ra̱ ts'i̱ínxát'a sisihi̱n nku ko̱ ch'on ts'ín ku̱a̱se̱he̱ xinkuu̱. Kui nga najmi ka̱ma n'e̱xát'aha̱ ru̱u Nti̱a̱ná ko̱ kju̱a̱nchi̱nóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Kui kju̱a̱ha nga b'a̱ tíxihi̱nnu̱u. Najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u ni xi machjénnu̱u, mí nihi xi chi̱no̱o ko̱ mí nihi xi s'i̱u. Ta̱ ndaha najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u ni xi machjéhe̱n yjonintenu̱u, mí najyuhun xi ndyjo̱o. Nk'ie ní nga ku̱i̱ntsu̱bo̱o, kui ní nihi xi 'yún chjíhi̱ ra̱ nga nichinee̱. Ko̱ yjonintenu̱u, kui xi 'yún chjíhi̱ ra̱ nga najyuu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cha̱so̱ho̱ ni̱se xi tjíma tje̱n nk'a ján. Najmi b'éntje̱, najmi b'ékú ko̱ najmi f'átjo ni xi kji̱ne̱. Tu̱nga Na̱'minu̱u xi tíjña ndji̱o̱jmi ján tsjáha̱ nichine. Ko̱ jun, ¿a najmi 'yúhún chjí so nga ni̱see̱? ");
INSERT INTO majNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ko̱ ndaha tsa 'yún kjúánta̱ha̱ ru̱u yjonu̱u tu̱ xi sáhanu masen metru̱, najmi tjín xi nkú ts'ín sáhanu masen metru̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Ko̱ á jun fanta̱ha̱ ru̱u yjonu̱u najyun xi ndyja̱hanu? Cha̱se̱ chu̱ba̱yoho̱o xi nkú ts'ín sá naxú jñóo̱. Najmi ts'ínxá ko̱ najmi ts'ínnda nachjún. ");
INSERT INTO majNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tu̱nga an b'a̱ tíxinnu̱u nga ta̱ ndaha nda̱ rei̱ Salomon xi 'yún chánka kama ni̱stjin nk'ie, najmi b'a̱ k'un najyun xi kingja xi nkúhu naxúu̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tsa Nti̱a̱ná b'a̱ tsjo ts'ínk'íéntu jñá xi chu̱ba̱ ma cháhá, xi nd'a̱i̱ ma chá ko̱ ndyjunni̱ ku̱i̱ti̱, ¿a najmi tu̱ sahá 'yún tsjá sanu̱u najyun xi ndyjo̱o jun xi 'yún chjí so nga jñóo̱? ¡Á b'a̱ 'yún i̱chí s'ejihi̱nnu̱u Nti̱a̱ná! ");
INSERT INTO majNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","’Kui b'a̱ maha, najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u: “¿Mí nihi xi chi̱ne̱é?” ko̱ “¿Mí nihi xi s'i̱á?” ko̱ “¿Mí najyuhun xi ndyja̱á nd'a̱i̱?”, tsa ku̱i̱xíún. ");
INSERT INTO majNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A̱t'aha̱ ngatentee̱ ni xu'bi̱ bangisjai xu̱ta̱ xi najmi be Nti̱a̱ná, tu̱nga jahá be Na̱'minu̱u xi tíjña ndji̱o̱jmi ján nga machjénnu̱u ngatentee̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Títjun tjehe̱nnto nga katatéxumanu̱u Nti̱a̱ná ko̱ n'o̱o ni xi na̱xu̱ nginku̱n, ko̱ b'a̱ ts'ín tu̱ k'u̱a̱i̱suhúnnu̱u ngayjee̱ ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u mí nihi xi ka̱ma ndyjunni̱. Ndyjunni̱ s'e̱ ngáha̱nu̱u a̱nte nga kjúánta̱ ngáha̱ ru̱u yjonu̱u. A̱t'aha̱ ngayje ni̱stjin y'a kju̱a̱sti xi ts'e̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Najmi tu̱ n'ek'anjiu jé xu̱ta̱ xi kj'a̱í, tu̱ xi najmi ts'i̱ínnijéhe̱nu̱u Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","A̱t'aha̱ xi nkú nga ts'ín n'e̱k'anjiu jé xu̱ta̱ xi kj'a̱í, b'a̱ ta̱ ts'ín ts'i̱ínnijé ngáha̱nu̱u Nti̱a̱ná. Ko̱ chu̱ba̱ xi n'e̱ chjón nga ch'a̱chu̱bo̱o, ta̱ kuihi xi k'u̱a̱chu̱ba̱ko̱ ngáha̱nu̱u Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","’¿Nkú ts'ín ji tíchasehe̱ ri̱ stjé xi kjinkihi tunku̱n nda̱ nts'ei nk'ie nga najmi títs'ín ndzjehin yáxu'ba xi kjinki tunkuin? ");
INSERT INTO majNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nk'ie nga yáxu'ba kjinki tunkuin, ¿nkú ts'ín b'a̱ k'úíhi̱n ri̱ nda̱ nts'ei: “K'u̱a̱i̱ntení nga k'uasjénkia stjé xi kjinki tunkuin”? ");
INSERT INTO majNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tín'ei ni xi ts'ín xi tu̱ tsjohó ra̱ bakúchji xi nkú ts'ín benkjún Nti̱a̱ná ni xi n'e̱ní ní. N'e̱sje mahi tjun yáxu'ba xi kjinki tunkuin, tu̱ xi nda ka̱ma ndzjehen ri nga n'e̱sjenki stjé xi kjinki tunku̱n nda̱ nts'ei. ");
INSERT INTO majNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Najmi tu̱ 'bo̱ho̱ nañóo̱ ni xi je nginku̱n Nti̱a̱ná ko̱ najmi tu̱ chi̱nko̱ chjanikj'ajihu̱un ni tsjo k'unnu̱u, a̱t'aha̱ ku̱a̱si̱nne chu̱ ni xi tsjo k'unnu̱u ko̱ santaha ko̱ jun kji̱ne̱nu̱u chu̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Ti̱nchíú, ko̱ Nti̱a̱ná tsjánu̱u. Ti̱nchísjo, ko̱ sa̱kúnu̱u. N'e̱kjano a̱nkju̱o̱, ko̱ chjúx'ánu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","A̱t'aha̱ ngatentee̱ xi banki ts'ínkjáíhi̱n. Xi bangisjai sakúhu̱. Ko̱ xi ts'ínkjane a̱nkju̱o̱ chjux'áha̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿A tjín a̱jinnu̱u nku xi tu̱ ndji̱o̱hó tsjáha̱ ntíhi̱ nk'ie nga ni̱nku̱a̱n ku̱a̱nkihi̱? ");
INSERT INTO majNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tsa tji̱o̱ ku̱a̱nki ntíhi̱, ¿a tu̱ ye̱hé tsjáha̱? ");
INSERT INTO majNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Santaha ko̱ jun xi ch'onk'un yo nga 'bo̱ho̱o ni xi nda ntínu̱u. ¿A najmi tu̱ sahá Na̱'minu̱u xi tíjña ndji̱o̱jmi ján 'yún tsjá saha̱ ni xi nda xu̱ta̱ xi ku̱a̱nkihi̱? ");
INSERT INTO majNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Kui b'a̱ maha, xi nkú ts'ín mjenu̱u nga n'e̱nu̱u, b'a̱ ta̱ n'o̱ho̱ xu̱ta̱ xi kj'a̱í. Kuihí niu̱ xi bakúya kju̱a̱téxumoo̱ ko̱ ni xi y'ét'a já profeta̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Ti̱tjás'o̱on a̱nkju̱a̱ ntsjíyoo̱. A̱t'aha̱ tayá a̱nkju̱a̱ ko̱ tayá ni̱yá xi fi má nga ndyja xu̱ta̱. 'Yún nkjin xi tíi̱ncha fas'en a̱nkju̱a̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tu̱nga ntsjíyahá a̱nkju̱a̱ ko̱ ntsjí ni̱yá xi fi má nga b'entu xu̱ta̱. Chuba xi tíi̱ncha sakúhu̱ a̱nkju̱a̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Chúhu̱un yjonu̱u já profeta̱ tsank'óo̱. Kui xi kj'u̱a̱í ts'ín ni̱ma̱kju̱a̱ maña̱ yjoho̱ xi nkúhu chu̱tsa̱nka̱, tu̱nga kjahán tjíntuyáha̱ xi nkúhu chu̱ kjan. ");
INSERT INTO majNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka̱mankjinnu̱u nkú k'un jóo̱ nk'ie nga cho̱o ni xi ts'i̱ín. A̱t'aha̱ ni xi ts'ín xu̱ta̱, kui xi nkú joyaha tu xi bjaha̱ nku yá tu. ¿A jñá na'yáhá xi bjaha̱ tuntsja̱jé? ¿A yá na'yáhá xi bjaha̱ tu higo̱? ");
INSERT INTO majNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ngatentee̱ yá xi nda bjaha̱ tu xi nda. Ko̱ yá xi najmi nda bjaha̱ tu xi najmi nda. ");
INSERT INTO majNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nku yá xi nda, najmi ma bjaha̱ tu xi najmi nda. Ko̱ nku yá xi najmi nda, najmi ma bjaha̱ tu xi nda. ");
INSERT INTO majNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ko̱ ngatentee̱ yá xi najmi bjaha̱ tu xi nda, stisún ko̱ s'etí a̱jin nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kui b'a̱ maha, cha̱hanu já profeta̱ tsank'óo̱ nk'ie nga cho̱o tu xi ts'e̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Najmi kju̱a̱s'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱ ngatentee̱ xu̱ta̱ xi: “Ji nda̱ maestru̱, ji nda̱ maestru̱”, títsuna. Xi títs'íntjusun ní xi nkú ts'ín mjehe̱ Na̱'mina̱ xi tíjña ndji̱o̱jmi ján, kuihí xi kju̱a̱s'enjin yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nk'ie nga ku̱i̱chú ni̱stjin nkjin ṉkjún xi b'a̱ ku̱i̱tsu̱na: “Ji Nda̱ Nti̱a̱, ji Nda̱ Nti̱a̱, ngajohi̱ y'eni̱jmíi̱, ngajohi̱ tsich'onsjehe̱ni̱ jánindoo̱ ko̱ nkjin kju̱a̱nkjún kin'ei̱.” ");
INSERT INTO majNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tu̱nga an b'a̱ xín ngáha̱ ra̱ xu̱ta̱ xu'bo̱: “Ndaha̱chí najmi benu̱u. Tankín t'axínnú jun xi ch'on kin'o.” ");
INSERT INTO majNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Kui b'a̱ maha, ngatentee̱ xu̱ta̱ xi nt'é énna̱ ko̱ ts'íntjusun, kui xi nkú joyaha nku nda̱ kitikju̱a̱ xi kits'ínndasún ni'yaha̱ a̱sun ndji̱o̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A̱s'a̱i kik'a tsíu̱, kama 'yún ntáje̱, ko̱ ntjo̱ kits'ínk'ajni ni'yoo̱ nga mjehe̱ kja̱níts'in. Tu̱nga najmi tsijnehé a̱t'aha̱ a̱sun ndji̱o̱ kamandasún. ");
INSERT INTO majNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tu̱nga ngatentee̱ xu̱ta̱ xi nt'é énna̱ ko̱ najmi ts'íntjusun, kui xi nkú joyaha nku nda̱ chi̱ni xi kits'ínndasún ni'yaha̱ a̱sun tsumíu̱. ");
INSERT INTO majNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A̱s'a̱i kik'a tsíu̱, kama 'yún ntáje̱, ko̱ ntjo̱ kits'ínk'ajni ni'yoo̱ nga mjehe̱ kja̱níts'in. Tsijne ni'yoo̱ nga tsatsunyje. ");
INSERT INTO majNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nk'ie nga ja kamaha̱ Jesu nga b'a̱ kitsú, tu̱ ni xí kama nkjúhún ra̱ ngayjee̱ xu̱ta̱ xi nkú ts'ín tíbakúya. ");
INSERT INTO majNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","A̱t'aha̱ tíbakúya xi nkúhu tsa xá tjíhi̱n. Najmi b'a̱ ts'ín tíbakúya xi nkú ts'ín bakúya já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nk'ie nga j'aijen ngáha Jesu nga nibaha a̱sunntu tje̱nki̱u̱, nkjin ṉkjún xu̱ta̱ kitsjennkíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A̱s'a̱i j'aisehe̱ Jesu nku nda̱ xi k'uhu̱n ch'in fentujnu. Tsasinkúnch'int'aha̱ ko̱ b'i̱ kitsúhu̱: —Ji nda̱ maestru̱, tsa ji xi mjehi, ka̱ma n'e̱ jení nga chjúxinní ch'in xi k'unna. ");
INSERT INTO majNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kingjénne ntsja Jesu nga kits'ínko̱ nda̱ uu̱n ko̱ b'i̱ kitsúhu̱: —Mjena. Katuma jei. Ta̱ kuihi chu̱bo̱ tsitjuxíhi̱n ch'ihi̱n ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","A̱s'a̱i b'i̱ kitsúhu̱ Jesu ndo̱: —Ji najmi tu̱ ch'a xi 'miyaihi̱ ni xi kamat'ain. T'ihi̱nkúchjihi̱ yjohi̱ nda̱ na̱'miu̱ ko̱ tjein chje̱ xi nkú ts'ín y'éjña Moise, tu̱ xi sku̱e̱ kixi̱hi xu̱ta̱ nga ja kamanda ngáhani. ");
INSERT INTO majNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nk'ie nga jas'en Jesu nanki Capernaum, a̱s'a̱i j'aisehe̱ nku nda̱ jun k'aku̱ nga j'ainkihi̱ nku kju̱a̱nda. ");
INSERT INTO majNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","B'i̱ kitsúhu̱: —Ji nda̱ nti̱a̱, nda̱ musu̱na̱ kjijña un ni'yana̱. Najmi ta̱ ma ts'ín ni̱yáha ko̱ un tíbehe̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","B'i̱ kitsú Jesu: —Ka̱ma kfín ts'innkíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tu̱nga b'a̱há kitsú nda̱ jun k'aku̱: —Ji nda̱ nti̱a̱, najmi an tsuhuna tsa ni'yana̱ ku̱i̱tjás'e̱i̱n. Tu̱ b'a̱ ti̱xín ní nga katumanda nda̱ musu̱na̱, ko̱ ka̱manda ndo̱ ma. ");
INSERT INTO majNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","A̱t'aha̱ xi nkúhu an, tíjñana xi batéxumana ko̱ ta̱ tjínna já jun xi batexumaha̱. Nk'ie nga: “T'in”, xihi̱n nku, a̱s'a̱i fi. Ko̱ tsa: “Nibái̱”, xíhi̱n kj'a̱í, a̱s'a̱i nibá. Ko̱ tsa nku nda̱ musu̱na̱: “N'e̱i̱ kui nii̱”, xíhi̱n, a̱s'a̱i ts'ín. ");
INSERT INTO majNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nk'ie nga kint'é Jesu én xi kitsú ndo̱, kama nkjúhu̱n ko̱ b'i̱ kitsúhu̱ xu̱ta̱ xi tje̱nko̱: —Kju̱axi̱ ni xi tíxinnu̱u. Ndaha nku xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱ najmi kje̱e sakújinna xi b'i̱ ts'ín s'ejihi̱n an xi nkú ts'ín s'ejihi̱n nda̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ko̱ b'a̱ tíxinnu̱u. Nkjin ṉkjún xu̱ta̱ xi ni̱ba tu̱ má xi tje̱hén ni ko̱ k'úéntut'áko̱ yámixo̱ ntje̱ cháná Abraham ko̱ Isaac ko̱ Jacob má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tu̱nga xu̱ta̱ xi tje̱he̱n ra̱ nga kju̱a̱s'en kai má batéxuma Nti̱a̱ná, kui xi ngju̱a̱i̱ya na̱tsin ján má jyuu̱n, a̱nte má nga kji̱ntá xu̱ta̱ ko̱ ku̱a̱te ni̱'yu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","A̱s'a̱i ta̱ kinchja̱ko̱ ngáha Jesu nda̱ jun k'aku̱: —T'in. Ngandahi̱ katuma xi nkú ts'ín kuas'ejihin. Ta̱ kuihi chu̱bo̱ kamanda nda̱ musu̱hu̱ nda̱ juu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nk'ie nga jas'en Jesu ni'yaha̱ Pedro̱, kikie nga ch'in kjijñako̱ na̱ nchí'yaha̱ Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A̱s'a̱i kits'ínko̱ ntsja ta̱chjúu̱n. Kindyjajihi̱n ch'iu̱n ko̱ tsisintje̱n nga kitsjáha̱ nichine xi tsichusehe̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nk'ie nga ja kama'ña̱, j'aich'áha̱ Jesu nkjin ṉkjún xu̱ta̱ xi tjíntujíhi̱n jánindoo̱. Nkuhú tsu̱'ba én xi kitsú Jesu nga kik'onsje jánindoo̱ ko̱ nga kits'ínnkihi̱ ngatentee̱ xu̱ta̱ uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","B'a̱ kama tu̱ xi tsitjusuhun éhe̱n Nti̱a̱ná xi kitsú nda̱ profeta̱ Isaia̱: “Kui xi ngjiko̱ kju̱a̱'unná ko̱ jakj'á ch'inná.” ");
INSERT INTO majNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nk'ie nga kikie Jesu nga nkjin xu̱ta̱ katsendáíhi̱ ra̱, b'i̱ kitsú nga mjehe̱ ngju̱a̱i̱ ngabantá ntáchak'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","A̱s'a̱i j'aik'úhu̱n nku nda̱ chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ b'a̱ kitsúhu̱: —Ji nda̱ maestru̱, tsjénnkihi tu̱ má xi tje̱hén ni nga k'úín. ");
INSERT INTO majNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","B'i̱ kitsú Jesu: —Chu̱ xi tjín ngijñóo̱ tjíhi̱n ti̱xa̱ ngijo ko̱ ni̱see̱ tjíhi̱n nu̱ba̱. Tu̱nga Ntíhi̱ Nda̱x'i̱u̱n najmi tjíhi̱n má nga ka̱ma kju̱ájñasun nintaku̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A̱s'a̱i b'a̱ kitsú nku nda̱ ni'yakuyáha̱: —Ji nda̱ maestru̱, k'u̱a̱i̱ntení nga tjun kfínngjayánjia na̱'mina̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","B'i̱ kitsú Jesu: —Tsjénnkiní ji. T'ejñaihi̱ xu̱ta̱ xi b'a̱ joyaha tsa ja k'ien nga kandjáyanji suba xu̱ta̱ k'ien xinkjín. ");
INSERT INTO majNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","A̱s'a̱i jas'en Jesu tsutsuu̱ ko̱ já ni'yakuyáha̱ ta̱ jas'enko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tu̱ nkuhú ntjo̱ xi tu̱ xí 'yúhún kamané nk'ie nga tje̱njin ntáchak'uu̱n, santaha i̱xí kingjá 'mahá ra̱ t'éhe̱n ntóo̱ tsutsuu̱. Tu̱nga kjifehé Jesu nga b'a̱ tímoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A̱s'a̱i já ni'yakuyáha̱ ngji ts'ínkj'áha̱ ko̱ b'a̱ kitsúhu̱: —¡Ji nda̱ maestru̱, n'e̱k'ankini̱! ¡Ja ku̱a̱yáá e̱i̱ ni̱! ");
INSERT INTO majNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","B'i̱ kitsú Jesu: —¿Á tíbinkjuhunnu? ¡Á b'a̱ 'yún i̱chí s'ejihi̱nnu̱u Nti̱a̱ná! A̱s'a̱i tsisintje̱n Jesu ko̱ ndjá kinchja̱ko̱ ntjo̱ ko̱ ntáchak'uu̱n nga kits'ínk'íéjyu. A̱s'a̱i kis'e jyujyu. ");
INSERT INTO majNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kama nkjúhu̱n jóo̱ ko̱ b'a̱ kitsúhu̱ xinkjín: —¿Yá nda̱ha xu'bi̱ nga santaha ntjo̱ ko̱ ntáchak'uu̱n nt'é'éhe̱n ra̱? ");
INSERT INTO majNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nk'ie nga tsichu Jesu ngabantá ntáchak'uu̱n, nankihi̱ xu̱ta̱ Gadara̱, a̱s'a̱i tsitjujín tsjóo̱ nga j'aik'úhu̱n Jesu jo já xi tjíntujíhi̱n jánindoo̱. Tu̱ ni xí kjahán jóo̱, nga santaha najmi ta̱ ch'a ma f'a ni̱yá xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A̱s'a̱i i̱ncha kikjintáya nga b'i̱ kitsúhu̱ Jesu: —Ji Jesu, Ntíhi̱ Nti̱a̱ nku tutuu̱, ¿mí nihi xi tjínko̱ni̱? ¿A ja kjúái̱k'a̱i̱ni̱ kju̱a̱ni̱ma̱ kintehe̱ ni nga ku̱i̱chú ni̱stjiu̱n? ");
INSERT INTO majNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Xi tje̱hen yo̱ nkjin ṉkjún chi̱nka̱ tíi̱ncha kjine jñá. ");
INSERT INTO majNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kui nga b'a̱ kitsúhu jánindoo̱ nga i̱ncha tsankihi̱ Jesu: —Tsa ku̱i̱ch'onsje̱ni̱ e̱i̱, tu̱ sahá tjennteni̱ nga ku̱i̱tjás'e̱njihi̱n chi̱nko̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Tankíún —kitsú Jesu. A̱s'a̱i tsitjujíhi̱n jóo̱ jánindoo̱ nga i̱ncha ngjikjas'enjihi̱n chi̱nko̱. Tsangatsanka ngatentee̱ chi̱nko̱ nga kikjaníkj'antjai yjoho̱ má nk'antjaihi̱ yo̱ ko̱ tsixuntujín ntáchak'uu̱n. Yo̱ jesunjin ntá. ");
INSERT INTO majNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A̱s'a̱i i̱ncha tsanka já xi tíi̱ncha kunntá chi̱nko̱. I̱ncha j'ai a̱jin na̱nti̱o̱ ko̱ kitsúya ngatentee̱ ni xi kamoo̱ ko̱ ni xi kamaha̱ já xi tjíntujíhi̱n jánindoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tu̱ tsitju tentehé xu̱ta̱ na̱nti̱o̱ nga nibasehe̱ Jesu. Nk'ie nga j'aisehe̱, i̱ncha tsankihi̱ nga ku̱i̱tju nankihi̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","A̱s'a̱i jas'en Jesu nku tsutsu nga j'atikjá ntáchak'uu̱n ko̱ tsichu ngáha nankihi. ");
INSERT INTO majNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ja kamoo̱. J'aisehe̱ Jesu já xi y'ang'anki nku nda̱ xi najmi ma fi, xi kjisun na̱chaha̱n. Nk'ie nga kikie Jesu nga s'ejihi̱n jóo̱ yáha kui, a̱s'a̱i kinchja̱ko̱ nda̱ uu̱n: —Tsjo kat'ehe̱ tak'uin, ntína̱. Ja kama ndyjat'ahi ngatitsuhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","B'i̱ ts'ín kits'ínnkjink'un k'u̱a̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱: “Najmi tíbenkjún Nti̱a̱ná nda̱i̱ nga b'a̱ ts'ín tínchja̱.” ");
INSERT INTO majNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tu̱nga behé Jesu ni xi tíi̱ncha ts'ínnkjink'un jóo̱. A̱s'a̱i b'i̱ kitsúhu̱: —¿Á b'a̱ ch'on ts'ín tín'enkjíntak'uhunnu? ");
INSERT INTO majNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Má éhen xi 'yún na̱xu̱ tje̱n xi ka̱ma xíhi̱n ndo̱? ¿A: “Ja kama ndyjat'ahi ngatitsuhi̱n”? ¿A ra̱: “Ti̱síntje̱i̱n ko̱ ti̱tsutjai”? ");
INSERT INTO majNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tu̱nga mjehéna kuakuchjínu̱u nga Ntíhi̱ Nda̱x'i̱u̱n tíjña ngajoho̱ Nti̱a̱ná a̱sunntei̱ xi má nga ka̱ma ts'i̱ínndyjat'aha̱ ngatitsuhu̱n xu̱ta̱. A̱s'a̱i b'i̱ kitsúhu̱ nda̱ xi najmi ma fiu̱: —Ti̱síntje̱i̱n, chjúbéí na̱chahi̱n ko̱ t'in ngáhani ni'yahi̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsisintje̱n nda̱ uu̱n ko̱ ngji ngáha ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nk'ie nga kikie xu̱ta̱ nkjiu̱n nii̱, kitsankjún ko̱ kits'íntsjoho̱ Nti̱a̱ná a̱t'aha̱ xu̱ b'a̱ tse nga'yún kitsjáha̱ nku nda̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nk'ie nga títs'ín ni̱yá Jesu, kikie nku nda̱ xi 'mi Mateo̱ xi kab'ejña a̱nte má nga f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ ko̱ b'i̱ kitsúhu̱: —Tsjénnkiní. A̱s'a̱i tsisintje̱n Mateo̱ ko̱ kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ko̱ ni xi kama, nk'ie nga tíkjine Jesu ni̱ñu̱ ni'yaha̱, nkjin ṉkjún já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ ko̱ já xi najmi na̱xu̱ ts'íntjusun kju̱a̱téxumoo̱ ta̱ i̱ncha j'aik'ientut'áha̱ Jesu ko̱ já ni'yakuyáha̱ t'a yámixo̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nk'ie nga kikie já fariseo̱ nii̱, a̱s'a̱i b'a̱ kitsúhu̱ já ni'yakuyáha̱ Jesu: —¿Á já xi f'áchjíntjaihi ch'á ko̱ já xi najmi na̱xu̱ ts'íntjusuhun kju̱a̱téxumoo̱ tíneko̱ho ni̱ñu̱ nda̱ maestru̱nu̱u? ");
INSERT INTO majNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tu̱nga nk'iehé nga kint'é Jesu éi̱n, b'i̱ kitsú: —Xu̱ta̱ xi uhu̱n machjéhe̱n já chji̱ne̱nki, najmi xi ndaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tankíún ko̱ ti̱nchíyo nkú tsuhu̱ ra̱ éhe̱n Nti̱a̱ná xi b'i̱ ts'ín tjít'a: “Ni xi mjehéna, nk'ie nga ka̱ma ni̱ma̱nu̱u xu̱ta̱. Najmi chje̱ xi k'u̱échjíntjainu̱u mjena.” Najmi xu̱ta̱ je jái̱ nchjaha̱, xu̱ta̱ ngatitsun ní jái̱ nchjaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","A̱s'a̱i j'aisehe̱ Jesu já ni'yakuyáha̱ Jua Bautista̱ ko̱ b'i̱ i̱ncha kitsúhu̱: —¿Nkú tjíhi̱n ra̱ nga najmi b'entu kjintíáha já ni'yakuyáhi̱ xi nkú ts'ín bintsu̱ba̱ kjintíáha̱ni̱ ji̱n ko̱ já fariseo̱? ");
INSERT INTO majNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A̱s'a̱i b'i̱ kitsú Jesu: —¿A mahá 'be babaha̱ xu̱ta̱ xi tjíntujín nku s'í kju̱a̱bixan nk'ie nga tíjñajin saha̱ nda̱ bixoo̱n? Tu̱nga ku̱i̱chúhú ni̱stjin nga chjú'aha̱ nda̱ bixoo̱n. Nk'iehé nga k'úéntu kjintíá. ");
INSERT INTO majNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ta̱ ndaha najmi ch'a b'éstiko̱ho najyun chá nku te najyun tse̱tse̱ xi najmi kje̱e nibákú. A̱t'aha̱ ni̱bakú najyun tse̱tse̱ ko̱ kjeti̱ya najyun chóo̱. B'a̱ ts'ín fi tsehe má kitiyá. ");
INSERT INTO majNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ko̱ ta̱ ndaha najmi ch'a binchá binu̱ tse̱tse̱ nku tsa tja̱ba̱xín chá. A̱t'aha̱ binu̱ tse̱tse̱ kjeti̱ya tsa tja̱ba̱xín chóo̱. A̱s'a̱i fi ndzjo binu̱ ko̱ batsun tsa tja̱ba̱xíu̱n. Kui nga tsa tja̱ba̱xín tse̱tse̱hé xincháha binu̱ tse̱tse̱, ko̱ b'a̱ ts'ín nda f'áítjoho nga joo̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nk'ie nga b'a̱ títsu Jesu, tu̱ j'aihí yo̱ nku nda̱ tjíxá ko̱ tsasinkúnch'int'aha̱ nga b'i̱ kitsúhu̱: —Ta̱kjínna ja k'uen. Nibángjennéí ntsa̱i̱ ntína̱ tu̱ xi kj'u̱a̱íya ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A̱s'a̱i tsisintje̱n Jesu ko̱ ngjiko̱ já ni'yakuyáha̱ nga kitsjennkíhi̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ko̱ tu̱ yo̱hó j'ai tje̱nnkihi̱ Jesu nku ta̱chju̱ún xi tjíhi̱n te jo nú nga jní títs'ínk'iehe̱n. Kui xi kits'ínko̱ tuts'in najyun xi yja Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A̱t'aha̱ b'i̱ ts'ín kits'ínnkjink'un: “Tsa tu̱ najyuhu̱n ts'inko̱ sa, ka̱manda ngáhana.” ");
INSERT INTO majNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tu̱nga kits'ínk'ótjiyahá Jesu nga tsasehe̱ ta̱chjúu̱n ko̱ b'a̱ kitsúhu̱: —Ji ntína̱, tsjo kat'ehe̱ tak'uin. A̱t'aha̱ kuas'ejihin nga Nti̱a̱ná kits'ín nibána, kui nga kama nkihi ri. Ta̱ kuihi chu̱bo̱ kamanda ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nk'ie nga tsichu Jesu ni'yaha̱ nda̱ tjíxóo̱, kikie yo̱ já xi títs'ínkjane yána̱xu̱ ko̱ xu̱ta̱ xi xa̱áha̱n tíi̱ncha ts'ín nga tíkjintá. ");
INSERT INTO majNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A̱s'a̱i b'i̱ kitsú Jesu: —Tankín ngáhanu. Najmi ka'me ta̱kjíu̱n. Tu̱ kjifehé. Tsajnukiehe̱ xu̱ta̱ xi kama ñjakú yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tu̱nga nk'iehé nga ja kik'onsje Jesu xu̱to̱, a̱s'a̱i jas'en má kjijña ta̱kjíu̱n, jakj'á ntsja ko̱ tsisintje̱n ngáha ta̱kjíu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kint'é ngayjee̱ xu̱ta̱ xi tjín yo̱ ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nk'ie nga tíbitju Jesu yo̱, kitsjennkíhi̱ jo já ka̱ xi kikjintáya tje̱nnkihi̱. B'i̱ i̱ncha kitsú: —Ji xi ntje̱he̱ David, katuma ni̱ma̱hi ji̱n. ");
INSERT INTO majNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ko̱ nk'ie nga jas'en ni'yaha̱ Jesu, yo̱ i̱ncha j'aisehe̱ já ko̱. B'i̱ kitsú Jesu nga kingjásjaiyaha̱ jóo̱: —¿A s'ejinnu̱u nga ka̱mana ts'ian ni xi mjenu̱u? B'a̱ i̱ncha kitsú jóo̱: —Joho̱n, nda̱ maestru̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","A̱s'a̱i kits'ínko̱ Jesu tunku̱n jóo̱ ko̱ b'i̱ kitsúhu̱: —Katuma xi nkú ts'ín tís'ejinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tsix'ánki tunku̱n jóo̱. A̱s'a̱i b'a̱ kitsú Jesu: —Tu̱nga najmi tu̱ ch'a 'miyahá ru̱u ni kamat'on. ");
INSERT INTO majNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tu̱nga nk'iehé nga i̱ncha ngji jóo̱, kitsúyaha̱ ngayjee̱ xu̱ta̱ xi tjín yo̱ xi nkú nga kits'ínko̱ho̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nk'ie nga tíbitju já xi ka̱ kai, i̱ncha j'ai xu̱ta̱ xi j'aiko̱ho̱ Jesu nku nda̱ xi najmi ma nchja̱, a̱t'aha̱ nda̱nindoo̱ tíjñajihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nk'ie nga kik'onsje Jesu nda̱nindoo̱, kinchja̱ ngáha nda̱ ni̱mo̱. Kama nkjúhu̱n xu̱ta̱ nkjiu̱n ko̱ b'a̱ i̱ncha kitsúhu̱ xinkjín: —Ndaha̱chí najmi kje̱e yaá a̱jinná xi ntje̱he̱ Israel tjenná nku ni xi b'a̱ tjín. ");
INSERT INTO majNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tu̱nga b'a̱há kitsú já fariseo̱: —Nga'yúhu̱n nda̱ninda k'aku̱hu̱ jánindoo̱ m'osjeko̱ho jánindoo̱ nda̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kikjatsú'ba Jesu ngayjee̱ nanki i ko̱ nanki xi̱ xi tjín yo̱ nga tsakúya a̱ya ni'ya sinagoga̱. Y'éni̱jmí én nda tsu xi títsuya nga Nti̱a̱ná xi batéxuma ko̱ kits'ínnkiyjehe̱ ch'in xi k'uhu̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nk'ie nga kikie Jesu xu̱ta̱ nkjiu̱n, kama ni̱ma̱ha̱, a̱t'aha̱ tíi̱nchajihi̱n sén ko̱ chu̱ba̱ tjímahá xi nkú joyaha chu̱tsa̱nka̱ xi najmi tjíhi̱n nda̱ bastu. ");
INSERT INTO majNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A̱s'a̱i kinchja̱ko̱ já ni'yakuyáha̱ nga b'i̱ kitsúhu̱: —Xu̱ta̱ xi tjín b'a̱ joyaha nkúhu nku ntje̱ chánka, tu̱nga chubahá maha já musu̱ xi ts'i̱ínxájin nii̱. ");
INSERT INTO majNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kui nga ti̱nchíhi̱ ru̱u xi ts'e̱ ntje̱ nga kats'ínkji já musu̱ a̱jin ntje̱he̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","A̱s'a̱i kinchja̱ha̱ Jesu já ni'yakuyá xi te joo̱ ko̱ kitsjáha̱ nga ngajoho̱ Jesu ka̱maha̱ jóo̱ k'o̱nsje jánindoo̱ xi tjíntujíhi̱n xu̱ta̱ ko̱ nga ts'i̱ínnkiyjehe̱ xu̱ta̱ xi ch'ihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kui xu'bi̱ xi j'áíhi̱n já postru̱ xi te joo̱: títjun Simon, xi ta̱ 'mi Pedro̱, ko̱ Andre xi nda̱ nts'e̱ Pedro̱ maha; Santiago̱ ko̱ Jua xi nts'e̱ maha xinkjín, xi jáha̱ Zebedeo̱; ");
INSERT INTO majNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe̱ ko̱ Bartolome; Toma ko̱ Mateo̱ xi j'áchjíntjai ch'á; Santiago̱ ntíhi̱ Alfeo̱ ko̱ Tadeo̱; ");
INSERT INTO majNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon xi mako̱ já kananista̱ ko̱ Juda̱ Iscariote̱ xi a̱skahan kits'ínkjas'en Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","A̱s'a̱i kits'ínkji Jesu já ni'yakuyá xi te joo̱ nga kitsúyaha̱ ni xi tjíhin nga i̱ncha ts'i̱ín. B'i̱ kitsúhu̱: —Najmi tu̱ bankíún má nga najmi tjín xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱ ko̱ najmi tu̱ bitjas'o̱on nankihi̱ xu̱ta̱ Samari̱a̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xu̱ta̱ xi ntje̱he̱ ní Israel y'aha̱ ra̱ tankíhi̱nso̱ho̱, xu̱ta̱ xi ja kindyja xi nkú joyaha chu̱tsa̱nka̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tankíún ko̱ t'eni̱jmíú nga ja 'yún tiña tíjña Nti̱a̱ná nga tíbatéxuma nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","N'e̱nkihu̱u xu̱ta̱ un, n'e̱kj'áíyoho̱o xu̱ta̱ xi ja ka'me, n'e̱nkihu̱u xu̱ta̱ xi k'uhu̱n ch'in fentujnu tu̱ xi ka̱ma jehe nginku̱n Nti̱a̱ná, ko̱ ti̱ch'onsjo̱o jáninda xi tjíntujíhi̱n xu̱ta̱. Xi nkú ts'ín tu̱ kik'a̱i̱hínu̱u nga'yún, b'a̱ ts'ín tu̱ ti̱si̱nko̱nú xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Najmi tu̱ ch'o to̱onsine a̱ya tsanu̱u, ta̱ ndaha to̱ontaba, ko̱ ta̱ ndaha kj'a̱í to̱on. ");
INSERT INTO majNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Najmi tu̱ ch'o tsa nga n'o̱o ni̱yá, ta̱ ndaha jo 'yún najyun xi ndyjo̱o, ta̱ ndaha tja̱ba̱xínnté, ko̱ ta̱ ndaha yánise. A̱t'aha̱ xi ts'ínxá tjíhi̱n kixi̱ nga k'u̱a̱i̱hi̱ nichine. ");
INSERT INTO majNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Nk'ie nga ku̱i̱tjás'o̱on nku nanki 'yún ko̱ tsa nku nanki i̱chí, yo̱ ti̱nchísjo nku xi nda ani̱ma̱ha̱. Ti̱ntsu̱bo̱o ni'yaha̱ santa nkúhu nga ku̱i̱tju ngáhanu nanki xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nk'ie nga ku̱i̱tjás'o̱on ni'yoo̱, b'i̱ ts'ín súniño: “Kas'enu̱u kju̱a̱jyu”, ti̱xíún. ");
INSERT INTO majNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tsa nda ani̱ma̱ha̱ xu̱ta̱ xi ts'e̱ ni'yoo̱, kas'ehe̱ kju̱a̱jyunu̱u. Tu̱nga tsa najmi nda ani̱ma̱ha̱ xu̱ta̱ xu'bo̱, kak'óyak'un ngáha̱nu̱u kju̱a̱jyunu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","’Tsa tjín xi najmi ts'i̱ínkjáínnu̱u ko̱ tsa najmi ngju̱énñjuhu̱ énnu̱u, tu̱ sahá ti̱tjusje̱ ngáhanu ni'yoo̱ ko̱ tsa nankiu̱, ko̱ t'etsujno ndyjo tsu̱ku. ");
INSERT INTO majNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kju̱axi̱ ni xi tíxinnu̱u. Nk'ie nga ku̱i̱chú ni̱stjin nga cha̱se̱he̱ ni xi kits'ín nga nkúnkú xu̱ta̱, kui nanki xu'bo̱ xi 'yún un sku̱e̱ saha̱ nga xu̱ta̱ xi kis'e nanki Sodoma̱ ko̱ nanki Gomorra̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’T'ejin tak'un. An títs'inkjínu̱u xi nkú joyaha chu̱tsa̱nka̱ a̱jihi̱n nañá kjan. Kui nga ti̱ntsu̱ba̱ ndahanu xi nkú joyaha ye̱ ko̱ ni̱ma̱kju̱a̱ n'e̱sjo yjonu̱u xi nkú joyaha chu̱tujuu̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chúhu̱un yjonu̱u xu̱ta̱, a̱t'aha̱ ts'i̱ínkjas'ennu̱u já tjíxóo̱ ko̱ k'u̱énu̱u a̱ya ni'ya sinagoga̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nga̱t'ana̱ ngju̱a̱i̱ko̱nu̱u nginku̱n já títjuu̱n ko̱ nginku̱n já rei̱, tu̱ xi ku̱i̱xínyaha̱ ru̱u jóo̱ ko̱ ta̱ xu̱ta̱ xi najmi ntje̱he̱ Israel tje̱he̱n ra̱ yáha an. ");
INSERT INTO majNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","’Tu̱nga nk'ie nga ts'i̱ínkjas'ennu̱u xu̱ta̱, najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u nkú n'e̱ chu̱bo ko̱ mí éhen xi ku̱i̱xíún. A̱t'aha̱ kui chu̱ba̱ xu'bo̱ k'u̱a̱i̱nu̱u én xi chu̱bo. ");
INSERT INTO majNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","A̱t'aha̱ najmi jun xi chu̱bo, Espiri̱tu̱hu̱ ní Na̱'minu̱u xi ku̱i̱nchja̱ nk'ie nga chu̱bo. ");
INSERT INTO majNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Já xi nts'e̱ maha xinkjín ta̱ kuihi ts'i̱ínkjas'en xinkjín nga n'e̱k'ien. Xi tí'mi na̱'mi ts'i̱ínkjas'en ntíhi̱. Xi tí'mi ntí kja̱ánko̱ xi cháha̱ ko̱ ts'i̱ínk'ien. ");
INSERT INTO majNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nga̱t'ana̱ ts'i̱ín unkiehe̱nu̱u ngayjee̱ xu̱ta̱. Tu̱nga xi tu̱ nku ndjáhá ku̱a̱si̱njña, kui xi k'u̱a̱nki. ");
INSERT INTO majNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nk'ie nga tsjénnki unkienu̱u xu̱ta̱ xi tjín nku nanki, tu̱ sahá ti̱yú. Tankíún kj'a̱í nanki. A̱t'aha̱ kju̱axi̱ ni xi tíxinnu̱u. Najmi kfe̱nu̱u nga ku̱i̱nimo ngayjee̱ nankihi̱ xu̱ta̱ Israel kintehe̱ ni nga kj'u̱a̱í Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Nku nda̱ ni'yakuyá najmi 'yún yankjún sa nga nda̱ maestru̱hu̱, ko̱ nku nda̱ musu̱ najmi 'yún yakjún sa nga nda̱ nti̱a̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nda tjín ts'e̱ nda̱ ni'yakuyóo̱ tsa b'a̱ ts'ín ka̱maha̱ xi nkúhu nda̱ maestru̱hu̱, ko̱ nda tjín ts'e̱ nda̱ musu̱ tsa ku̱i̱chú ma xi nkú joyaha nda̱ nti̱a̱ha̱. Tsa na̱'mihi̱ ntíu̱ xi tí'mihi̱ nda̱ninda Beelzebu, ¿a najmi tu̱ sahá 'yún ch'on k'úín saha̱ ntíhí? ");
INSERT INTO majNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Kui b'a̱ maha, najmi tu̱ binkjuhunnu xu̱ta̱ xu'bo̱. A̱t'aha̱ najmi tjín ni xi 'ma tjítjo xi najmi cha̱, ko̱ najmi tjín ni xi tíjña 'ma xi najmi s'e̱jña chji. ");
INSERT INTO majNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ni xi tíxinyanu̱u má jyuu̱n, chu̱ba ngáhanu má ndzjee̱n. Ko̱ én se̱n xi ku̱i̱nú'yó nga kuinchja, ch'i̱íyako̱ ngáhanu a̱sun nk'a ni'yoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Najmi tu̱ binkjun xi tu̱ yjonintee̱hé maha̱ ts'ínk'ien tu̱nga najmi mahá ra̱ ts'i̱ínk'ien ani̱ma̱nu̱u. Xi ma níhi̱ ts'ínkji ani̱ma̱nu̱u ko̱ yjonintenu̱u a̱jin nga̱k'i̱e̱n, kui ní xi ti̱nkjún. ");
INSERT INTO majNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿A najmi mahá tsa tu̱ xí nanki chjíhí ch'a nga satéña jo ni̱se xi̱ tíntí? Ndaha tsa b'a̱ ma, ndaha nku ni̱see̱ najmi ndyja̱ tsa najmi mjehe̱ Na̱'minu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nga̱t'a ts'a̱jun bi, santaha ngayjee̱ ntsja̱ku tjín xki̱hi̱ Na̱'minu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kui kju̱a̱ha nga najmi tu̱ binkjuhunnu, a̱t'aha̱ jun xi 'yún chjí so nga nkjin ni̱se. ");
INSERT INTO majNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ngatentee̱ xi ts'i̱ínkie yjoho̱ nga bena nginku̱n xu̱ta̱, ts'inkíé yjona̱ nga be xu̱to̱ nginku̱n Na̱'mina̱ xi tíjña ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tu̱nga xi najmi ts'i̱ínkie yjoho̱ nga bena nginku̱n xu̱ta̱, ko̱ an ta̱ najmi ts'inkíé yjona̱ nga be xu̱to̱ nginku̱n Na̱'mina̱ xi tíjña ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Najmi b'a̱ tu̱ ts'ín n'enkjíntak'un, tsa kju̱a̱jyu jái̱k'iejñá a̱sunntei̱. Najmi kju̱a̱jyu jái̱ tsja. Kju̱a̱chán ní jái̱ tsja. ");
INSERT INTO majNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A̱t'aha̱ jáa̱ tu̱ xi ku̱a̱kjányaha yjoho̱ xu̱ta̱, má nga nku nda̱ ngju̱a̱i̱ kontra̱ha̱ na̱'mihi̱ ko̱ nku ta̱kjín ngju̱a̱i̱ kontra̱ha̱ na̱aha̱ ko̱ nku na̱ a̱nta ngju̱a̱i̱ kontra̱ha̱ na̱ nchí'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta̱ kuihi xinkjín xu̱ta̱ ngju̱a̱i̱ kontra̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Xi 'yún ts'i̱íntjo sa na̱'mihi̱ ko̱ tsa na̱aha̱ nga an, kui xi najmi tsuhu̱ ra̱ nga ka̱ma xu̱ta̱ ni'yakuyána̱. Xi 'yún ts'i̱íntjo sa ntíhi̱ nga an, najmi tsuhu̱ ra̱ nga ka̱ma xu̱ta̱ ni'yakuyána̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Xi najmi títsjáha̱ yjoho̱ nga tsjénnkina santaha tsa ku̱a̱yá nga̱t'ana̱, najmi tsuhu̱ ra̱ nga ka̱ma xu̱ta̱ ni'yakuyána̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Xi ku̱a̱ngisjáí suba nga k'úéjña tík'un, tu̱ sahá ku̱a̱yá. Tu̱nga xi ku̱a̱yá nga̱t'ana̱, kui xi sa̱kúhu̱ nga k'úéjña tík'un. ");
INSERT INTO majNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Xu̱ta̱ xi ts'i̱ínkjáínnu̱u, ja an títs'ínkjáínna. Ko̱ xi ts'i̱ínkjáínna, ta̱ títs'ínkjáíhi̱n xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Xi ts'i̱ínkjáíhi̱n nku nda̱ profeta̱ a̱t'aha̱ nda̱ profeta̱ nii̱, xi nkú ts'ín tje̱he̱n ra̱ b'a̱ ts'ín k'u̱a̱i̱hi̱. Ko̱ xi ts'i̱ínkjáíhi̱n nku nda̱ xi na̱xu̱ ts'ín a̱t'aha̱ na̱xu̱ ts'ín ndo̱, xi nkú ts'ín tje̱he̱n ra̱ b'a̱ ts'ín k'u̱a̱i̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ko̱ tsa tjín xi tsjáha̱ nku chu̱tsín ntánijua nch'án xi k'úí nku xu̱ta̱ xu'bi̱ a̱t'aha̱ xu̱ta̱ ni'yakuyána̱ nii̱, kju̱axi̱ ni xi tíxinnu̱u nga kj'u̱a̱i̱hi̱ chjíhi̱ xu̱ta̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nk'ie nga ja kamaha̱ Jesu nga kitsúyaha̱ já ni'yakuyá xi te joo̱ ni xi tjíhin nga i̱ncha ts'i̱ín, a̱s'a̱i i̱ncha ngji nga tsakúya ko̱ y'éni̱jmí én nda tsuhu̱ Nti̱a̱ná nanki xi tjín yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A̱ya nu̱ba̱yóo̱ kint'é Jua Bautista̱ ni xi títs'ín Jesu. A̱s'a̱i kits'ínkji k'u̱a̱ já ni'yakuyáha̱ ");
INSERT INTO majNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tu̱ xi ngju̱ásjaiyaha̱ ra̱ Jesu. B'a̱ i̱ncha kitsúhu̱: —¿A ji nda̱ xi tjíhin nga kj'u̱a̱í? ¿A ra̱ chúyahá ri̱ kj'a̱í nda̱ha? ");
INSERT INTO majNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","B'i̱ kitsú Jesu: —Tankínk'inyoho̱o Jua ni xi tínu'yó ko̱ tíyo. ");
INSERT INTO majNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tíma chjihi̱ xi ka̱ha̱. Xi najmi ma fi tíi̱ncha fi. Xi k'uhu̱n ch'in fentujnu tímanda. Tínt'é xi stayaha̱. Tíf'áíyaha̱ xi ja k'ien. Tís'eni̱jmíhi̱ én nda tsuhu̱ Nti̱a̱ná xi x'a̱ha̱n. ");
INSERT INTO majNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Nda tjín ts'e̱ xi najmi tjín ni xi ts'i̱ínch'oho̱ nga tsjénnkina! ");
INSERT INTO majNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nk'ie nga ja tíi̱ncha fi ngáha já ni'yakuyáha̱ Jua Bautista̱, kik'atuts'i̱hi̱n Jesu nga kinchja̱ni̱jmíyaha Jua. B'i̱ kitsúhu̱ xu̱ta̱ nkjiu̱n: —¿Mí nihi xi tsankinse nkjúhu̱un a̱nte kixiu̱? ¿A nku yáxá xi títs'ínk'ajnihi̱ ntjo̱? ");
INSERT INTO majNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tsa najmi, ¿mí nihi xi tsankisoho̱o? ¿A nku nda̱ xi yja najyun tsjo tjín? Najmi, a̱t'aha̱ xi bja najyun tsjo k'un, kui xi tjíntu ni'yaha̱ já rei̱. ");
INSERT INTO majNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tu̱nga, ¿á tsitjuhunu? ¿A ra̱ nkuhú nda̱ profeta̱ tsankisoho̱o? Joho̱n, kui. An b'a̱ tíxinnu̱u nga kui Jua xi 'yún chánka sa a̱jihi̱n já profeta̱. ");
INSERT INTO majNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jua tínchja̱ni̱jmíyaha ni xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná: Títs'inkjíá nda̱ chji̱ne̱'énna̱ tu̱ xi ngju̱a̱i̱ títjuhun ri. K'u̱énda títjun ni̱yáhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kju̱axi̱ ni xi tíxinnu̱u. Ndaha nku xu̱ta̱ xi tjín a̱sunntei̱ najmi 'yún chánka sa nga Jua Bautista̱. Tu̱nga xi 'yún i̱chí má batéxuma Nti̱a̱ná, kui xi 'yún chánka sa nga Jua. ");
INSERT INTO majNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ni̱stjin nga y'éni̱jmí Jua Bautista̱ éhe̱n Nti̱a̱ná ko̱ santaha nd'a̱i̱ 'yún tíbixkjanyáha má batéxuma Nti̱a̱ná, ko̱ xu̱ta̱ xi kitikju̱a̱ títs'ín ts'e̱ yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A̱t'aha̱ Nti̱a̱ná kits'ínchjén ni xi y'ét'a já profeta̱ ko̱ xi kis'et'a kju̱a̱téxumaha̱ Moise nga kitsjá éhe̱n santaha nkúhu nga j'ai Jua. ");
INSERT INTO majNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tsa mjenu̱u n'e̱ s'ejiun éi̱n, Jua kui xi Elia̱ xi tjíhin nga kj'u̱a̱í. ");
INSERT INTO majNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Xi tje̱n tja̱ba̱xínñju, katasínñju. ");
INSERT INTO majNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Mí nihi xi k'uejñá chu̱ba̱yako̱hona xi nkú k'un xu̱ta̱ xi tjín nd'a̱i̱? Kui xi b'a̱ joyaha já a̱sti xi b'entu ni̱yátée̱ ko̱ kjintáyaha̱ xinkjín ");
INSERT INTO majNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","nga b'a̱ i̱ncha tsu: “Nk'ie nga kin'ekjanei̱ yána̱xu̱, ¿á najmi kichankihinu? Ko̱ nk'ie nga kisei̱ suu̱n nusin, ¿á najmi kich'íhinu?” ");
INSERT INTO majNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","’A̱t'aha̱ nk'ie nga j'ai Jua, y'ejña kjintíá ko̱ najmi kik'i binu̱. A̱s'a̱i: “Nda̱ninda tíjñajihi̱n”, kitsú xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A̱skahan j'ai ngá Ntíhi̱ Nda̱x'i̱u̱n xi kjine ko̱ 'bi, ko̱ tu̱ sa b'a̱há tsu ngá xu̱ta̱: “Kui nda̱i̱ xi 'yún kjine ko̱ 'yún 'bi. Nda nchja̱ko̱ já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ ko̱ já xi najmi na̱xu̱ ts'íntjusun kju̱a̱téxumoo̱.” Tu̱nga tís'ejña chjihí kju̱a̱nkjintak'uhu̱n Nti̱a̱ná nk'ie nga tíyaha̱ ni xi títs'ín. ");
INSERT INTO majNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","A̱s'a̱i b'i̱ ts'ín ndjá kinchja̱ni̱jmíyaha Jesu xu̱ta̱ xi tjíntu nanki má nga 'yún kits'ín kju̱a̱nkjún, a̱t'aha̱ najmi ngjikj'áha̱ ra̱ ani̱ma̱ha̱: ");
INSERT INTO majNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ni̱ma̱ rú n'ehenu jun, xu̱ta̱ nanki Corazin! ¡Ni̱ma̱ rú n'ehenu jun, xu̱ta̱ nanki Betsaida̱! A̱t'aha̱ tsa xu̱ta̱ nanki Tiro̱ ko̱ xu̱ta̱ nanki Sidon kikie kju̱a̱nkjún xi kama a̱jinnu̱u, ja ra̱ nd'a̱i ngjikj'áha̱ ra̱ ani̱ma̱ha̱ nga kingja najyun kfe ko̱ y'entujín nasu. ");
INSERT INTO majNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tu̱nga ahán b'a̱ tíxinnu̱u. Ni̱stjin nga cha̱se̱he̱ mí nihi xi kits'ín nga nkúnkú xu̱ta̱, jun xi 'yún un sku̱e̱ sanu̱u nga xu̱ta̱ xi kis'e nanki Tiro̱ ko̱ nanki Sidon. ");
INSERT INTO majNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","’Ko̱ jun xu̱ta̱ nanki Capernaum, tsa b'a̱ manu̱u nga santaha ndji̱o̱jmi ján cha̱nkjúnnu̱u, najmi. Tu̱ sa ní santaha nga̱k'i̱e̱n kuankínjo̱on. A̱t'aha̱ tsa xu̱ta̱ nanki Sodoma̱ kikie kju̱a̱nkjún xi kama a̱jinnu̱u, ta̱ tíjña ra̱ santaha nd'a̱i̱ tsakai. ");
INSERT INTO majNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tu̱nga an b'a̱ tíxinnu̱u. Nk'ie nga ku̱i̱chú ni̱stjin nga cha̱se̱he̱ mí nihi xi kits'ín nga nkúnkú xu̱ta̱, jun xi 'yún un sku̱e̱ sanu̱u nga xu̱ta̱ xi kis'e nanki Sodoma̱. ");
INSERT INTO majNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kui ni̱stjiu̱n b'i̱ kitsú Jesu: —An títs'intsjoho, Na̱'mi, Nti̱a̱ xi ts'e̱ nk'a ján ko̱ t'anankiu̱. A̱t'aha̱ y'ejña chjihi̱ xu̱ta̱ xi b'a̱ k'un xi nkú joyaha jántí xi̱ ni xi kik'iejña 'maihi̱ já nkjink'uu̱n ko̱ já xi mankjihi̱n ni xi tjín. ");
INSERT INTO majNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Joho̱n, Na̱'mi, a̱t'aha̱ b'a̱ ts'ín kama tsjohi. ");
INSERT INTO majNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Ngayjee̱ ni xi tjín ja kits'ínkjas'en a̱ya ntsa̱ Na̱'mina̱. Najmi ch'a behe̱ Ntíu̱, tu̱ nkuhú Na̱'miu̱ xi behe̱. Ta̱ ndaha najmi ch'a behe̱ Na̱'miu̱, tu̱ nkuhú Ntíu̱ xi behe̱. Ko̱ xu̱ta̱ xi mjehe̱ Ntíu̱ nga ku̱a̱kúchjihi̱ Na̱'miu̱, kui xi sku̱e̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Nibáha̱se̱nú ngatentoo̱ xi tsichu manu̱u nga kich'anjiu ch'áha̱ kju̱a̱téxumoo̱, ko̱ an tsjanu̱u nga n'e̱kj'áíyo. ");
INSERT INTO majNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tjasuntjio nkú tsuhu̱ ra̱ kju̱a̱téxuma xi tíbakuyá, a̱t'aha̱ ts'inkjáíhi̱n xu̱ta̱ ko̱ ni̱ma̱kju̱a̱ tjíyana. Sa̱kúnu̱u xi má nga ts'i̱ínkj'áíya ani̱ma̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","A̱t'aha̱ najmi 'ni s'esúntjia ni xi bakuyá ko̱ kijna ch'á xi tsjanu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nku xua̱tu̱ j'ajin Jesu má nga tjíntje̱ tuni̱ñu̱. Kama bjoho̱ já ni'yakuyáha̱ ko̱ i̱ncha kikje'yún tuni̱ñu̱. Kits'íntjiya ntsja nga kikjine. ");
INSERT INTO majNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tu̱nga kikiehé já fariseo̱ ni xi tíi̱ncha ts'ín jóo̱. A̱s'a̱i b'a̱ i̱ncha kitsúhu̱ Jesu: —Cha̱se̱ ma ri̱. Ni xi tíjña nkjúhu̱n kju̱a̱téxumoo̱ nga ni̱stjin nkjúu̱n tíi̱ncha ts'ín já ni'yakuyáhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","B'i̱ kitsú Jesu: —¿A najmi kje̱hé n'eyo má nga tjít'a ni xi kits'ín David nk'ie nga kama bjoho̱ kui ko̱ já xi tje̱nko̱ho̱? ");
INSERT INTO majNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jas'en a̱nte nkjúhu̱n Nti̱a̱ná ko̱ kikjine ni̱nku̱a̱n nkjún xi tjíntu yo̱, ni xi najmi tjíhin nga kui kji̱ne̱ ko̱ ta̱ ndaha já xi tje̱nko̱, ni̱nku̱a̱n xi tu̱ já na̱'miu̱ ma kjinehé. ");
INSERT INTO majNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ko̱ a najmi kje̱hé n'eyo kui nii̱ xi tjít'a xu̱ju̱n kju̱a̱téxumoo̱? Já na̱'mi xi ts'ínxá a̱ya ni̱nku̱ nga ni̱stjin nkjúu̱n najmi chumi jéhe b'anji. ");
INSERT INTO majNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","An b'a̱ tíxinnu̱u. E̱i̱ tíjñajinnu̱u nku xi 'yún chánka sa nga ni̱nku̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","’Tu̱nga najmi kje̱hé mankjinnu̱u éhe̱n Nti̱a̱ná xi b'a̱ ts'ín tjít'a: “Ni xi mjehéna, nk'ie nga ka̱ma ni̱ma̱nu̱u xu̱ta̱. Najmi chje̱ xi k'u̱échjíntjainu̱u mjena.” Tsa mankjinnu̱u ée̱n, najmi chu̱ba̱ n'e̱nijéhe̱ ru̱u xu̱ta̱ xi najmi tjíhi̱n jé. ");
INSERT INTO majNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","A̱t'aha̱ Ntíhi̱ Nda̱x'i̱u̱n batéxumaha̱ santaha ko̱ ni̱stjin nkjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ngjikjas'en Jesu ni'ya sinagoga̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yo̱ ta̱ kab'ejña nku nda̱ xi ch'ihi̱n ntsja. A̱s'a̱i b'a̱ i̱ncha kitsú jóo̱ nga kingjásjaiyaha̱ Jesu, tu̱ xi b'a̱ ts'ín sa̱kúhu̱ ra̱ má tíndyjajihi̱n Jesu: —¿A ma n'enki nga ni̱stjin nkjún? ");
INSERT INTO majNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A̱s'a̱i b'a̱ kitsú Jesu: —Tsa nku xi kabasinjña e̱i̱ tíjñaha̱ nku chu̱tsa̱nka̱, tsa tu̱ nkuhú ti̱xa̱ ku̱i̱jne̱ngiya chu̱ nga ni̱stjin nkjúu̱n, ¿a najmi ku̱a̱kj'áhá chu̱ ko̱ k'u̱a̱sjeya ti̱xo̱? ");
INSERT INTO majNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kui b'a̱ maha, ¡'yún chjí sa nku xu̱ta̱ nga nku chu̱tsa̱nka̱! Kui nga ma n'ehe nku ni xi nda nga ni̱stjin nkjún. ");
INSERT INTO majNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A̱s'a̱i Jesu b'a̱ kitsúhu̱ nda̱ xi ch'ihi̱n ntsja: —Tjentei ntsa̱i̱. Kingjénte ntsja ndo̱ ko̱ kamanda. B'a̱ kik'ie xi nkúhu̱ ntsja xinkuu̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A̱s'a̱i i̱ncha tsitju yo̱ já fariseo̱ ko̱ y'éndako̱ xinkjín xi nkú ts'ín ka̱ma ts'i̱ínk'iehen Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A̱s'a̱i ngji t'axín Jesu, a̱t'aha̱ ja be ni xi mjehe̱ ts'i̱ín jóo̱. Nkjin ṉkjún xu̱ta̱ kitsjennkíhi̱. Kits'ínnkihi̱ ngatentee̱ xi uhu̱n ");
INSERT INTO majNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ko̱ b'a̱ kitsúhu̱ xu̱ta̱ nga najmi i̱ncha ku̱i̱tsu̱ya yáha Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","B'a̱ kama tu̱ xi tsitjusuhun éhe̱n Nti̱a̱ná xi kinchja̱ nda̱ profeta̱ Isaia̱ nk'ie nga b'a̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","E̱i̱ tíjña nda̱ musu̱na̱ xi j'ajián, xi tjona ko̱ xi tsjo maha̱ ani̱ma̱na̱. Tsjaha̱ Espiri̱tu̱na̱, ko̱ ku̱i̱tsu̱yaha̱ xu̱ta̱ xi tjín a̱sunntee̱ ni xi na̱xu̱ nginkán. ");
INSERT INTO majNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Najmi kjan ku̱i̱nchja̱ ko̱ najmi kji̱ntáya, najmi ni̱yátée̱ ku̱i̱nú'yá nta̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Najmi kjét'okjá nku yáxá xi ja títs'okjá. Najmi ts'i̱ínk'ien nd'í xi tu̱ ni̱nti̱hí títju saha̱, santa nkúhu nga ts'i̱ínndju̱ú ni xi na̱xu̱ nginkán. ");
INSERT INTO majNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ko̱ xu̱ta̱ xi tjín a̱sunntee̱ ka̱ma 'yún tak'un nda̱ musu̱na̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","J'aisehe̱ Jesu xu̱ta̱ xi j'aiko̱ nku nda̱ xi tíjñajihi̱n nda̱nindoo̱. Kui xi ka̱ ko̱ najmi ma nchja̱. A̱s'a̱i Jesu ts'asjehe̱ nda̱nindoo̱ ndo̱. Kama chjihi̱ ko̱ kama kinchja̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tu̱ ni xí kama nkjúhu̱n ra̱ ngayjee̱ xu̱ta̱. B'a̱ i̱ncha kitsúhu̱ xinkjín: —¿Kutsa kuihí xu'bi̱ xi ntje̱he̱ David? ");
INSERT INTO majNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nk'ie nga kint'é já fariseo̱ ni xi tíi̱ncha tsu xu̱ta̱, b'a̱ i̱ncha kitsú: —Nga'yúhu̱n nda̱ninda Beelzebu xi nda̱ k'aku̱hu̱ jánindoo̱ tím'osjeko̱ho nda̱i̱ jánindoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tu̱nga behé Jesu ni xi títs'ínnkjink'un jóo̱, kui nga b'a̱ kitsúhu̱ ra̱: —Tsa xu̱ta̱ xi tjíntu má batéxuma nku nda̱ rei̱ ta̱ kuihi fi kontra̱ha̱ xinkjín, ta̱ kuihi i̱ncha ngju̱á tiya nankihi̱. Ngatentee̱ nanki ko̱ ni'ya xi ta̱ kuihi fi kontra̱ha̱ xinkjín, najmi tse maha̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","B'a̱ ta̱ tjín ts'e̱ nda̱nindoo̱. Tsa Satana k'o̱nsje suba yjoho̱, ta̱ kuihi tífi kontra̱ subaha̱ yjoho̱. Tsa b'a̱ ts'i̱ín, ¿nkú ts'ín tse ku̱i̱chúkju̱a̱ha̱ ra̱ nga ku̱a̱téxumaha? ");
INSERT INTO majNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","’Ko̱ tsa nga'yúhu̱n nda̱ninda Beelzebu tím'osjeko̱hona jánindoo̱ tíbixíún, ¿yá xi ts'e̱ nga'yún xi m'osjeko̱ho jánindoo̱ já ts'a̱jun? B'a̱ ts'ín ta̱ kuihi jóo̱ bakúchji nga najmi kixi̱ tjíntuyánu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tu̱nga tsa Espiri̱tu̱hu̱ Nti̱a̱ná tím'osjéko̱hona jánindoo̱, kui xi tsuhu̱ ra̱ nk'ie nga ja j'ai ni̱stjin nga ja tíbatéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Nkú ts'ín nku nda̱ ka̱ma kju̱a̱s'ehen ni'yaha̱ nku nda̱ xi 'yún tjíhi̱n nga'yún ko̱ kjé'aha̱ ra̱ ni xi tjíhín? Tjín níhi nga tjun k'u̱é'yún ndo̱. B'a̱ ts'ín ka̱ma kjé'aha̱ ra̱ ni xi tjíhi̱n ndo̱ ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Xi najmi an mako̱na, kui xi xu̱ta̱ kontra̱na̱. Xi najmi tíf'áyako̱na, kui xi tíbaténdzjo. ");
INSERT INTO majNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Kui nga b'a̱ tíxihi̱nnu̱u. Ka̱ma ndyjat'aha̱ xu̱ta̱ ngatentee̱ ngatitsuhu̱n ko̱ ngatentee̱ én ch'on tsu xi ku̱i̱nchja̱. Tu̱nga xi ch'on ku̱i̱tsu̱hu̱ Espiri̱tu̱ Santo̱, kui xi najmi ta̱ ka̱ma ndyjat'aha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Xi nkú ku̱i̱tsu̱hu̱ Ntíhi̱ Nda̱x'i̱u̱n, ka̱ma ndyjat'aha̱. Tu̱nga xi nkú ku̱i̱tsu̱hu̱ Espiri̱tu̱ Santo̱, kui xi najmi ta̱ ka̱ma ndyjat'aha̱ ra̱, ta̱ ndaha nd'a̱i̱ ko̱ ta̱ ndaha ndyjun nkini̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Tsa tuhu̱ yóo̱ xi nda, nda yóo̱. Ko̱ tsa tuu̱ xi najmi nda, najmi nda yóo̱. A̱t'aha̱ tuu̱ bakúchji nkú k'un yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Já ch'onk'un xi b'a̱ k'un! ¿Nkú ts'ín ka̱ma chu̱bahanu ni xi nda, nk'ie nga jun xi ch'onk'un? A̱t'aha̱ ni xi kitsejíhin ani̱ma̱ha̱ xu̱ta̱, kui nihi xi bitju ts'a. ");
INSERT INTO majNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nku nda̱ xi nda b'asjejin ni xi nda a̱jihi̱n ngayjee̱ ni nda xi tjítjoho̱. Ko̱ nku nda̱ xi ch'onk'un b'asjejin ni ch'onk'un a̱jihi̱n ngayjee̱ ni ch'onk'un xi tjítjoho̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","’Ko̱ an b'a̱ tíxinnu̱u. Nk'ie nga ku̱i̱chú ni̱stjin nga cha̱se̱he̱ ni xi kits'ín nga nkúnkú xu̱ta̱, nk'ie ts'i̱ínkjas'en kuenta̱ xu̱ta̱ nga nkúnkú én xi najmi chumi ni chjíhi̱ ra̱ xi kinchja̱ e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","A̱t'aha̱ ta̱ kuihi én xi kichubai n'e̱ kju̱a̱ha ri, tsa tjíhin jé ko̱ tsa najmi tjíhin jé. ");
INSERT INTO majNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","A̱s'a̱i k'u̱a̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱ b'a̱ i̱ncha kitsúhu̱ Jesu: —Ji nda̱ maestru̱, mjeni̱ nga cha̱i̱ nku kju̱a̱kjún xi n'e̱i̱, xi ku̱a̱kúchji nga Nti̱a̱ná kits'ín nibáhi. ");
INSERT INTO majNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","B'i̱ kitsú Jesu: —Xu̱ta̱ xi tjín nd'a̱i̱ tíi̱ncha banki nga sku̱e̱ nku kju̱a̱nkjún, a̱t'aha̱ ch'onk'un ko̱ najmi na̱xu̱ tíi̱ncha nginku̱n Nti̱a̱ná. Tu̱ ni xi kamat'aihín nda̱ profeta̱ Jona nk'ie, tu̱ kuihí kju̱a̱nkjún xi s'e̱jña chjihi̱ xu̱ta̱ xi tjín nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","A̱t'aha̱ xi nkú ts'ín y'ejña Jona jan ni̱stjin ko̱ jan ni̱stje̱n a̱ya ka̱ts'a̱ ti̱ chánkoo̱, b'a̱ ta̱ ts'ín k'úéjña Ntíhi̱ Nda̱x'i̱u̱n jan ni̱stjin ko̱ jan ni̱stje̱n kinte t'anankiu̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","’Xu̱ta̱ xi y'entu nanki Nini̱ve̱ ku̱i̱síntje̱nko̱ xu̱ta̱ xi tjín nd'a̱i̱ nk'ie nga ku̱i̱chú ni̱stjin nga cha̱se̱he̱ ni xi kits'ín nga nkúnkú xu̱ta̱. Kui xi ts'i̱ínko̱kju̱a̱ha̱ xu̱ta̱ xi tjín nd'a̱i̱, a̱t'aha̱ kui xi ngjikj'áha̱ ra̱ ani̱ma̱ha̱ nk'ie nga Jona y'éni̱jmíhi̱ éhe̱n Nti̱a̱ná. Nd'a̱i̱ bi, e̱i̱ tíjña nku xi 'yún nk'a tje̱n sa nga Jona. ");
INSERT INTO majNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ko̱ na̱ rei̱na̱ xi tsatéxuma nanki Saba ku̱i̱síntje̱nko̱ xu̱ta̱ xi tjín nd'a̱i̱ nk'ie nga ku̱i̱chú ni̱stjin nga cha̱se̱he̱ ni xi kits'ín nga nkúnkú xu̱ta̱. Kui xi ts'i̱ínko̱kju̱a̱ha̱ xu̱ta̱ xi tjín nd'a̱i̱, a̱t'aha̱ kui xi 'yún kjin nibaha nga j'aisínñjuhu̱ kju̱a̱nkjink'uhu̱n Salomon. Nd'a̱i̱ bi, e̱i̱ tíjña nku xi 'yún nk'a tje̱n sa nga Salomon. ");
INSERT INTO majNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Nk'ie nga nku nda̱ninda bitjujíhi̱n nku nda̱, fatsú'basún a̱nte kixiu̱ nga bangisjai má nga ts'i̱ínkj'áíya. Nk'ie nga najmi sakúhu̱ a̱nte, ");
INSERT INTO majNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","a̱s'a̱i b'a̱ tsu: “Tu̱ sahá kfin ngáhana ni'yana̱ má tsitja.” Nk'ie nga b'óya ngáha, ja kjitiya ni'yoo̱ nga f'aise ngáha̱ ra̱. Kichjuchá ko̱ ja tjínda. ");
INSERT INTO majNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","A̱s'a̱i fikj'á sa yatu jáninda xi 'yún ch'onk'un sa nga kui ko̱ ngatentee̱ i̱ncha fas'enjihi̱n ndo̱. Ko̱ máha nda̱ xu'bo̱, 'yún ch'on ts'ín b'ejña a̱skahan nk'ie nga tjuhun. B'a̱ ta̱ ka̱maha̱ xu̱ta̱ ch'onk'un xi tjín nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nk'ie nga tínchja̱ko̱ sa Jesu xu̱ta̱ nkjiu̱n, tu̱ na̱aha̱ ní ko̱ já nts'e̱ j'aincha na̱tsiu̱n xi má nga mjehe̱ ku̱i̱nchja̱ko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","A̱s'a̱i tjín xi b'i̱ kitsúhu̱ Jesu: —Na̱ahi̱ ko̱ já nts'ei kabincha na̱tsin ján. Mje rúhu̱ ku̱i̱nchja̱ko̱hi. ");
INSERT INTO majNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","B'i̱ kitsú Jesu nga kinchja̱ko̱ nda̱ xi j'aiko̱ho̱ ée̱n: —¿Yá xi nána̱ ko̱ yá xi já nts'é? ");
INSERT INTO majNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A̱s'a̱i tsakú xu̱ta̱ ni'yakuyáha̱ ko̱ b'i̱ kitsú: —Kui xu̱ta̱ xu'bi̱ xi nána̱ ko̱ já nts'é. ");
INSERT INTO majNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tu̱ yáhá ni xi ts'i̱íntjusun xi nkú ts'ín mjehe̱ Na̱'mina̱ xi tíjña ndji̱o̱jmi ján, kui xi nda̱ nts'é, na̱ nichja ko̱ nána̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kui ni̱stjiu̱n tsitju Jesu ni'yaha̱ ko̱ ngjik'iejña a̱ndai ntáchak'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nkjin ṉkjún xu̱ta̱ kama ñjakút'aha̱. Kui nga nku tsutsu ngjik'iejñayaha Jesu, ko̱ ngayjee̱ xu̱ta̱ tsincha a̱ndai ntóo̱ má kixiu̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nkjin tíkjá ni xi tsakúyaha̱ nga y'éjña chu̱ba̱yaha̱. B'i̱ kitsú: —Nku nda̱ tsitju nga ngjiténdzjo xujmá. ");
INSERT INTO majNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nk'ie nga tíbaténdzjo xujmóo̱, k'u̱a̱ xi tsixuntu a̱ndai ni̱yóo̱. A̱s'a̱i i̱ncha j'ai ni̱see̱ ko̱ kikjine xujmá xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","K'u̱a̱ xi tsixuntu a̱jin ndji̱o̱ má nga najmi 'yún tjín ninte. Ki̱tsa̱ jasu xujmóo̱, a̱t'aha̱ najmi 'yún tjain nintee̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tu̱nga nk'iehé nga tsitju ts'íu̱, kits'ínchjaha̱n ko̱ kixí, a̱t'aha̱ najmi 'yún ngjiyanji kja̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","K'u̱a̱ ngá xi tsixuntu a̱jin na'yóo̱. Kisá na'yóo̱ ko̱ najmi kitsjántehe̱ nga nda sa̱á xujmá xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tu̱nga k'u̱a̱há ngá xi tsixuntu má nga nda nankiu̱. Tu̱ xí tsehé ni xi kitsjá. Tjín xujmóo̱ xi kitsjá unchan tjíhin, tjín xi kitsjá cháte ko̱ te tjíhin, ko̱ tjín xi kitsjá katé tjíhin. ");
INSERT INTO majNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Xi tje̱n tja̱ba̱xínñju, katasínñju. ");
INSERT INTO majNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","A̱s'a̱i j'aisehe̱ Jesu já ni'yakuyáha̱ ko̱ b'a̱ kitsúhu̱: —¿Á tu̱ subahá b'ejña chu̱ba̱yahani nk'ie nga chubako̱honi xu̱ta̱? ");
INSERT INTO majNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A̱s'a̱i b'i̱ kitsú Jesu: —Jun ja kik'a̱i̱nu̱u nga ka̱mankjinnu̱u ni xi 'ma tíjña ts'e̱ xi nkú ts'ín batéxuma Nti̱a̱ná. Tu̱nga xu̱ta̱ xu'bo̱ najmi kik'a̱i̱hi̱ nga ka̱mankjihi̱n niu̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","A̱t'aha̱ xi kamankjihi̱n, k'u̱a̱i̱ saha̱ ko̱ 'yún nda ka̱mankjihi̱n. Tu̱nga xi najmi ts'i̱ínsihi̱n nga ka̱mankjihi̱n, chjú'aha̱ santaha ni xi tíjñaha̱ nga ka̱mankjihi̱n kai. ");
INSERT INTO majNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kui kju̱a̱ha tu̱ tíb'ejñá chu̱ba̱yahá ra̱ xu̱ta̱ xu'bo̱. A̱t'aha̱ tíbase tu̱nga najmi tíbehé, ko̱ tínt'é tu̱nga najmi tíbasínñjuhú ko̱ najmi tímankjihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","’Ni xi tíi̱ncha ts'ín xu̱ta̱ xu'bo̱ títs'íntjusun éhe̱n Nti̱a̱ná xi kitsúya nda̱ profeta̱ Isaia̱ nk'ie nga b'a̱ kitsú: 'Yún ku̱a̱sinñju tu̱nga najmi ka̱mankjihínnu̱u, ko̱ 'yún cha̱so̱o tu̱nga najmi cha̱nú. ");
INSERT INTO majNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","A̱t'aha̱ ja kama ndjá ani̱ma̱ha̱ xu̱ta̱ xu'bi̱, kits'ín staya yjoho̱ ko̱ kik'íéchja tunku̱n, tu̱ xi najmi sku̱e̱he ko̱ najmi ku̱i̱nt'éhe, ko̱ najmi ka̱mankjihi̱n ra̱, tsa ts'i̱ínk'óntjaiya ani̱ma̱ha̱ ko̱ nga an ts'innkíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Tu̱nga máha jun, á b'a̱ nda tjíhin ts'a̱jun xi tíyo ko̱ tínu'yó, a̱t'aha̱ tíbe tunkun ko̱ tínt'é tja̱ba̱xínñju. ");
INSERT INTO majNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kju̱axi̱ ni xi tíxinnu̱u. Nkjin já profeta̱ ko̱ xu̱ta̱ xi na̱xu̱ y'entu xi kis'e ni̱stjin nk'ie i̱ncha kama mjehe̱ nga sku̱e̱ ni xi tíyo nd'a̱i̱, tu̱nga najmi kikiehé. Kama mjehe̱ nga ku̱i̱nt'é ni xi tínu'yó nd'a̱i̱, tu̱nga najmi kint'éhé. ");
INSERT INTO majNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Kui b'a̱ maha, tjenñjuhúnu nkú tsuhu̱ ra̱ ni xi kuak'iejñá chu̱ba̱ya ts'e̱ nda̱ xi tsaténdzjo xujmóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nk'ie nga nt'é xu̱ta̱ én xi tsuya nga Nti̱a̱ná xi batéxuma, a̱s'a̱i najmi mankjihi̱n niu̱, nibá nda̱nindoo̱ ko̱ kjexín én xi ja kis'entje̱jin ani̱ma̱ha̱. Kui xu̱ta̱ha xi nkú joya xujmá xi tsixuntu a̱ndai ni̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","’Xujmá xi tsixuntu a̱jin ndji̱o̱, kui xu̱ta̱ha xi nt'é ée̱n ko̱ tje̱n'yún tsjohó ts'ín ts'ínkjáíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tu̱nga najmi 'yúhún tjíhi̱n kja̱ma̱ a̱jin ani̱ma̱ha̱ ko̱ najmi ndjá bincha. Nk'ie nga sakúhu̱ kju̱a̱sti ko̱ nk'ie nga n'e uncha tu̱ nga̱t'aha̱ ée̱n, ts'ín t'axíhi̱n yjoho̱ ée̱n. ");
INSERT INTO majNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","’Xujmá xi tsixuntu a̱jin na'yóo̱, kui xu̱ta̱ha xi ta̱ nt'é ée̱n, tu̱nga ni xi tjíhín a̱sunntei̱ s'enta̱ha̱ ra̱ ko̱ kju̱a̱nchi̱nóo̱ b'ana̱cha̱ha̱. B'a̱ ts'ín najmi sakúntehe̱ ra̱ nga nda sa̱áha ée̱n a̱jin ani̱ma̱ha̱ xu̱ta̱ xu'bo̱ ko̱ najmi tsjá cha̱n. ");
INSERT INTO majNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","’Tu̱nga máha xujmá xi tsixuntu nanki xi ndoo̱, kui xu̱ta̱ha xi nt'é ée̱n ko̱ mankjihi̱n. Nda ts'ín nga b'entu. Kui xi b'a̱ joyaha xujmá xi tsjá unchan tjíhin, ko̱ tsa xi tsjá cháte ko̱ te tjíhin, ko̱ tsa xi tsjá katé tjíhin. ");
INSERT INTO majNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ta̱ y'éjña chu̱ba̱yahá ngáha Jesu nga tsakúya. B'i̱ kitsú: —Má batéxuma Nti̱a̱ná b'a̱ joyaha nku nda̱ xi nda xujmá xi y'éntje̱jin jñáha̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tu̱nga nk'iehé nga kjintufé, j'ai nda̱ kontra̱ha̱ ndo̱. Y'éntje̱jihi̱n tuni̱ñu̱ jñá ch'onk'un ko̱ a̱s'a̱i ngji. ");
INSERT INTO majNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nk'ie nga jasu tuni̱ñu̱ ko̱ kis'ehe̱ tu, ta̱ kama chji jñá ch'onk'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A̱s'a̱i i̱ncha j'ai já musu̱hu̱ nda̱ xi ts'e̱ tuni̱ñu̱ ko̱ b'a̱ kitsúhu̱: “Ji nda̱ nti̱a̱, ¿a najmi xujmá ndahá xi y'entje̱jin jñáhi̱? ¿Nkú ts'ín nga tu̱ sa jñá ch'onk'uhún kj'ijin ngáha̱ ra̱ ntje̱hi̱?” ");
INSERT INTO majNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","B'a̱ kitsú ndo̱: “Nku nda̱ kontra̱ b'a̱ kits'ín.” B'a̱ kitsú já musu̱: “¿A mjehé ri nga kuankín chjúneyai̱ jñá ch'onk'uu̱n?” ");
INSERT INTO majNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tu̱nga b'a̱há kitsú ndo̱: “Najmi, a̱t'aha̱ tsa chjúneyo jñá ch'onk'uu̱n, ko̱ xka̱ tuni̱ñu̱ chjúyanjiu. ");
INSERT INTO majNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tu̱ sahá katuma chá suba nga joo̱ santaha nkúhu nga ku̱i̱chú ni̱stjin nga ka̱ma chá. Kui ni̱stjiu̱n b'a̱ xíhi̱n já xi ku̱a̱te tuu̱ nga títjun kjéneya jñá ch'onk'uu̱n, kj'u̱ách'á ko̱ k'u̱éti. Tu̱nga máha tuni̱ñu̱, kui xi kj'u̱átjo a̱ntehe̱.” ");
INSERT INTO majNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ta̱ y'éjña chu̱ba̱yahá ngáha Jesu nga tsakúya. B'i̱ kitsú: —Xi nkú ts'ín batéxuma Nti̱a̱ná b'a̱ joyaha nku k'un mostasa̱ xi jakj'á nku nda̱ ko̱ y'éntje̱ jñáha̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kui k'un xu'bi̱ xi 'yún i̱chí sa nga k'un xi k'oo̱. Tu̱nga nk'iehé nga ma chá, 'yún chánka ma sa nga ni ntje̱ xi b'éntje̱ xu̱ta̱. Santaha nku yá tu bichú ma, ko̱ f'ai ts'ínnda'á ni̱see̱ nu̱ba̱ha̱ tjiaha̱ yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A̱s'a̱i ta̱ y'éjña chu̱ba̱ya ngáha Jesu: —Xi nkú ts'ín batéxuma Nti̱a̱ná b'a̱ joyaha na̱'yu̱ saha̱n ni̱nku̱a̱n xi jakj'á nku ta̱chju̱ún ko̱ kits'íntjijinko̱ tse nku̱a̱n ni̱nku̱a̱n. A̱s'a̱i tsijin ngatente na̱'yu̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","B'a̱ ts'ín kinchja̱ko̱ Jesu xu̱ta̱ nkjiu̱n. Y'éjña chu̱ba̱yaha̱ ngayjee̱ ni xu'bi̱ nga kitsúyaha̱. Najmi kinchja̱ko̱ tsa najmi y'éjña chu̱ba̱yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","B'a̱ kama tu̱ xi tsitjusuhun éhe̱n Nti̱a̱ná xi kitsúya nda̱ profeta̱ nga b'a̱ kitsú: K'uejñá chu̱ba̱ya, xínya ni xi tjíntu'má santaha nkúhu nga kamanda a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nk'ie nga ja kits'ínkji Jesu xu̱ta̱ nkjiu̱n, jas'en ni'yaha̱. A̱s'a̱i já ni'yakuyáha̱ j'aik'úhu̱n ko̱ b'a̱ i̱ncha kitsúhu̱: —T'inyani̱ nkú tsuhu̱ ra̱ én xi kuak'iejña chu̱ba̱yai ts'e̱ jñá ch'onk'un xi tjín a̱jihi̱n tuni̱ñu̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","B'i̱ kitsú Jesu: —Nda̱ xi y'éntje̱ xujmá ndoo̱, kui xi Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A̱nte xi má nga y'éntje̱, kui xi a̱sunntei̱. Xujmá xi ndoo̱, kui xu̱ta̱ha xi ts'e̱ má batéxuma Nti̱a̱ná. Jñá ch'onk'uu̱n, kui xu̱ta̱ha xi ts'e̱ nda̱nindoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nda̱ kontra̱ xi y'éntje̱ jñá ch'onk'uu̱n, kui xi nda̱nindoo̱. Ni̱stjin nga chjúsíntje̱n tuni̱ñu, kui ni̱stjihin nk'ie nga kfe̱ a̱sunntee̱. Ko̱ já xi ku̱a̱te tuni̱ñu̱, kui xi ntítsjee̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","’Xi nkú ts'ín f'áíya jñá ch'onk'uu̱n ko̱ s'etí a̱jin nd'íu̱, b'a̱ ta̱ ka̱ma nk'ie nga kfe̱ a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nk'ie nga ku̱a̱téxuma Ntíhi̱ Nda̱x'i̱u̱n, ts'i̱ínkji ntítsjehe̱ nga kjéxin a̱jihi̱n xu̱ta̱ xi ts'e̱ ngayjee̱ xu̱ta̱ xi ts'ínkijnejin ngatitsun xu̱ta̱ xi k'oo̱ ko̱ ngayjee̱ xu̱ta̱ xi ch'on ts'ín. ");
INSERT INTO majNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kui xi kja̱níkj'ajin má tíma 'yún nd'íu̱. Yo̱ kji̱ntá xu̱ta̱ ko̱ ku̱a̱te ni̱'yu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nk'iehé ku̱a̱t'ai xu̱ta̱ jee̱ xi nkú joyaha ts'íu̱ nga k'úéntu má batéxuma Na̱'mihi̱. Xi tje̱n tja̱ba̱xínñju, katasínñju. ");
INSERT INTO majNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Má batéxuma Nti̱a̱ná b'a̱ joyaha xi nkúhu nku nisa to̱on xi tíjña 'ma nku a̱nte. Nda̱ xi sakúhu̱ niu̱ ta̱ b'éjña 'mahá ngáha a̱t'aha̱ najmi kui ts'e̱ a̱ntee̱. Tsjo maha̱ ndo̱ niu̱. Kui nga fitéñayjehe ni xi tjíhi̱n ra̱ ko̱ b'atse a̱ntee̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Má batéxuma Nti̱a̱ná ta̱ b'a̱ joyaha xi nkúhu nku nda̱ xi ts'ínxáko̱ ndji̱o̱ tsjo k'un. ");
INSERT INTO majNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nk'ie nga sakúhu̱ nku xi 'yún chjíhi̱, a̱s'a̱i fitéñayje ni xi tjíhi̱n ko̱ b'atse ndji̱o̱ tsjo tjín xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Má batéxuma Nti̱a̱ná ta̱ b'a̱ joyaha xi nkúhu nku na̱'ya xi kikjaníkj'ajin jóo̱ ntáchak'uu̱n. Kixincháha̱ ngayjee̱ tíkjá tji̱o̱ xi tjín. ");
INSERT INTO majNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nk'ie nga kitsehe tji̱o̱ na̱'yoo̱, a̱s'a̱i kikje'yún jóo̱ a̱ndai ntóo̱. Yo̱ y'entu nga j'ájin tji̱o̱ xi ndoo̱. Tsinchá ni̱si̱n xi ndoo̱ ko̱ kikjaníya xi najmi ndoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","B'a̱ ta̱ ka̱ma nk'ie nga kfe̱ a̱sunntee̱. Ku̱i̱tju ntítsjee̱ ko̱ ts'i̱ínkj'a t'axín xu̱ta̱ xi ch'onk'un ko̱ xi je. ");
INSERT INTO majNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","A̱s'a̱i kja̱níkj'ajin xi ch'onk'uu̱n má nga tíma 'yún nd'íu̱. Yo̱ kji̱ntá xu̱ta̱ ko̱ ku̱a̱te ni̱'yu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","A̱s'a̱i b'i̱ kitsú Jesu nga kingjásjaiyaha̱ já ni'yakuyáha̱: —¿A kamankjinnu̱u ngayjee̱ ni xu'bi̱? —Joho̱n —i̱ncha kitsú jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","B'i̱ kitsú Jesu: —Nk'ie nga nku nda̱ chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ bangiya nkú tsuhu̱ ra̱ nga Nti̱a̱ná batéxuma, kui xi b'a̱ joyaha nku nda̱ xi tíjñaha̱ nku ni'ya chánka. Bakúchji ni tsjo k'un xi tjíntutjóho̱, ni xi cháha̱ ko̱ ni xi tse̱tse̱he̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nk'ie nga ja kamaha̱ Jesu nga y'éjña chu̱ba̱ya, a̱s'a̱i tsitju yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ngji ngáha nankihi̱ ko̱ tsakúya a̱ya ni'ya sinagoga̱ xi tjín yo̱. Kama nkjúhu̱n xu̱to̱ ko̱ b'a̱ i̱ncha kitsúhu̱ xinkjín: —¿Má ngjikj'áha kju̱a̱nkjink'un na̱nka̱ xi y'aha nda̱i̱? ¿Nkú ts'ín maha̱ ra̱ ts'íhin kju̱a̱nkjún? ");
INSERT INTO majNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿A najmi kuihí nda̱i̱ xi ntíhi̱ nda̱ chji̱ne̱yóo̱? ¿A najmi kuihí na̱aha̱ xi 'mi Maria̱? ¿A najmi já nts'e̱hé maha Santiago̱, Kuse, Simon ko̱ Juda̱? ");
INSERT INTO majNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿A najmi e̱i̱hí ta̱ tjíntujínná ngatentee̱ jminchjín nichja nda̱i̱? Kui b'a̱ maha, ¿má ngjikj'áha ni xi maha̱? ");
INSERT INTO majNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kui nga najmi i̱ncha kits'ínkjáíhi̱n ra̱. Tu̱nga b'a̱há kitsúhu̱ Jesu xu̱ta̱ nkiu̱n: —Tu̱ má xi tje̱hén ni yankjún nku nda̱ profeta̱. Nkuhú nankihi̱ ko̱ ni'yaha̱ najmi b'a̱ n'ehe̱. ");
INSERT INTO majNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Najmi 'yún kits'ín kju̱a̱nkjún Jesu yo̱, a̱t'aha̱ najmi kis'ejihi̱n xu̱ta̱ nga Nti̱a̱ná kits'ín nibáha̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kui ni̱stjiu̱n Herode̱ Antipa̱ tjíhi̱n xá a̱nte Galilea̱. Kint'é ni xi títs'ín Jesu ko̱ b'a̱ kitsúhu̱ já xi ts'ínxát'aha̱: ");
INSERT INTO majNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","—Jua Bautista̱ niu̱. Ja j'áíya ngáha̱ ra̱ ngabayoo̱. Kui kju̱a̱ha nga tjíhi̱n ra̱ nga'yún nga títs'íhin kju̱a̱nkjún. ");
INSERT INTO majNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A̱t'aha̱ Herode̱ kits'ínkji já juhu̱n nga jakj'ánijé Jua. Y'é'yún ko̱ kits'ínkjas'en nu̱ba̱yóo̱. Nga̱t'aha̱ na̱ Herodia̱ b'a̱ kits'íhin. A̱t'aha̱ chju̱úhu̱n Felipe̱ kama na̱ Herodia̱, ko̱ ndo̱ ngá nts'e̱ kamaha Herode̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","B'a̱ kits'ín ndo̱ a̱t'aha̱ Jua Bautista̱ b'a̱ kitsúhu̱: —Tíjña nkjúhu̱n kju̱a̱téxumoo̱ ni xi tín'ei, nga ta̱ jihi tinchunko̱i̱ chju̱úhu̱n nda̱ nts'ei. ");
INSERT INTO majNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kama mjehe̱ Herode̱ nga ts'i̱ínk'ien Jua, tu̱nga tsankjúhún nga b'a̱ ts'i̱ín, a̱t'aha̱ b'a̱ tsu xu̱ta̱ nga nku nda̱ profeta̱ Jua Bautista̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tu̱nga nk'iehé nga tsichu nú Herode̱, ts'asje s'íhi̱ ko̱ kitenki ta̱kjíhi̱n na̱ Herodia̱ nginku̱n xu̱ta̱ xi j'ai s'íu̱, ko̱ tsjo ṉkjún kamaha̱ Herode̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A̱s'a̱i i̱xí Nti̱a̱náhá kits'ínkie nga tsjáha̱ ta̱kjíu̱n tu̱ mí nihí ni xi ku̱a̱nkihi̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tu̱nga jahá kabinchá'a títjuhu̱n na̱aha̱ ta̱kjíu̱n, ko̱ b'i̱ kitsúhu̱ Herode̱: —T'eya ta̱ba̱ní nintaku̱ Jua Bautista̱ nga k'u̱a̱i̱ní. ");
INSERT INTO majNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A̱s'a̱i kik'ie babaha̱ nda̱ rei̱ Herode̱, tu̱nga nga̱t'aha̱ ní nga ja kats'ínkie Nti̱a̱ná nga ts'i̱íntjusun éhe̱n ko̱ nga̱t'aha̱ já xi kab'entut'áko̱ho̱ yámixo̱, kui nga b'a̱ kitsúhu nga k'u̱a̱i̱hi̱ ra̱ ta̱kjíu̱n ni xi tíbankihi. ");
INSERT INTO majNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kitsjá kju̱a̱ nga stíkjá nintaku̱ Jua a̱ya nu̱ba̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nku ta̱ba̱ kis'eya nintaku̱ Jua ko̱ kik'a̱i̱hi̱ ta̱kjíu̱n, ko̱ kui xi ngjitsjá ngáha̱ ra̱ na̱aha̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ja kamoo̱, já ni'yakuyáha̱ Jua j'aikj'á yjoninte k'ie̱n ko̱ kingjáyanji. A̱s'a̱i ngji tsúyaha̱ Jesu ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nk'ie nga kint'é Jesu éi̱n, y'eya nku tsutsu nga ngji t'axín suba nku a̱nte má najmi ch'a tjín. Tu̱nga nk'iehé nga kint'é xu̱ta̱ nkjiu̱n nga ja tífi Jesu, a̱s'a̱i tsu̱ku̱ ngji títjuhu̱n ra̱ Jesu nga ngjitje̱nnki. ");
INSERT INTO majNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nk'ie nga tsitjujen Jesu tsutsuu̱, kikie nga nkjin ṉkjún maha xu̱ta̱ xi tíkuyáha̱. Kama ni̱ma̱ha̱ ko̱ kits'ínnkihi̱ xi uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nk'ie nga ja kama ngixuu̱n, i̱ncha j'aik'úhu̱n já ni'yakuyáha̱ ko̱ b'a̱ kitsúhu̱: —T'axínt'a ṉkjún e̱i̱ ko̱ ja 'yún kama ngixun. Tu̱ sahá b'a̱ t'ihi̱n xu̱to̱ nga katji nanki xi tjíndai e̱i̱ má nga ka̱ma k'u̱a̱tse ni xi kji̱ne̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi machjéhe̱n nga ngju̱a̱i̱ xu̱to̱. Tu̱ sahá jun tjoho̱on ni xi kji̱ne̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","B'a̱ kitsú jóo̱: —Un i̱chí maha ni̱nku̱a̱n xi kich'ai̱ ko̱ jo i̱chí tji̱o̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Nibáko̱nú e̱i̱ —kitsú Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A̱s'a̱i b'a̱ kitsúhu̱ xu̱ta̱ nkjiu̱n nga k'úéntujin jñóo̱. Jakj'á ni̱nku̱a̱n xi uu̱n ko̱ tji̱o̱ xi joo̱. Tsasenjinki nk'a ján nga kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná. Tsakjánya ni̱nku̱o̱n ko̱ kitsjáha̱ já ni'yakuyáha̱ tu̱ xi kui i̱ncha ts'i̱ínndzjo ngáha̱ ra̱ xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ngatentee̱ xu̱to̱ i̱ncha kikjine niu̱ santa nkúhu nga i̱ncha kitse sisihi̱n. A̱s'a̱i j'áíya ni̱nku̱a̱n xi ts'ankiu̱. Te jo ni̱si̱n kama. ");
INSERT INTO majNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma ra̱ un mii̱ jáx'i̱n ko̱ kj'a̱í jminchjíu̱n ko̱ jántí xi i̱ncha kikjine nichinee̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A̱s'a̱i b'a̱ kitsúhu̱ Jesu já ni'yakuyáha̱ nga i̱ncha kju̱a̱s'en tsutsuu̱ ko̱ nga i̱ncha ngju̱a̱i̱ títjuhu̱n ngabantá ntáchak'uu̱n, a̱t'aha̱ Jesu tsasín ni̱yá xu̱to̱ nk'ie nga i̱ncha ngji ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nk'ie nga ja kits'ínkji xu̱ta̱, a̱s'a̱i ngji nchja̱ko̱ t'axín suba Nti̱a̱ná a̱sunntu tje̱nki̱u̱. Yo̱ tíjña suba nk'ie nga ja kama jyun. ");
INSERT INTO majNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kui chu̱bo̱ ja kamasehe̱n ntáchak'uu̱n tje̱njin tsutsuu̱. T'éhe̱n ntóo̱ títs'ínstihi̱, a̱t'aha̱ ntjo̱ 'yún ṉkjún tísatéjihi̱n tsutsuu̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nkú ra̱ ma nga ja tífi ma sen, tsichu tje̱nnki tiña Jesu jóo̱ nga tífisun ntáchak'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nk'ie nga kikie já ni'yakuyóo̱ nga nibásun ntáchak'uu̱n, i̱ncha kitsankjún ṉkjún. B'a̱ i̱ncha kitsú nga kikjintáya nkjún: —¡Nku se̱n nibá yo̱! ");
INSERT INTO majNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tu̱nga tje̱n'yún kinchja̱há Jesu: —¡Jyu ní! ¡Ahán niu̱! ¡Najmi tu̱ binkjun! ");
INSERT INTO majNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A̱s'a̱i b'i̱ kitsú Pedro̱: —Ji nda̱ maestru̱, tsa kju̱axi̱ nga ji niu̱, tjein kju̱a̱ nga kfínsehe yo̱ má tje̱njin ntóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Nibáí —kitsú Jesu. A̱s'a̱i tsitjujen Pedro̱ tsutsuu̱ ko̱ ngjisun ntóo̱ nga ngjisehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tu̱nga nk'iehé nga kikie nga 'yún tíma ntjo̱, kitsankjún ko̱ nk'ie nga ja tífijintí, kikjintáya: —¡Ji nda̱ maestru̱, n'e̱k'ankiní! ");
INSERT INTO majNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ta̱ kuihi chu̱bo̱ jakj'á Jesu ntsja Pedro̱ ko̱ b'a̱ kitsúhu̱: —¡Á b'a̱ 'yún i̱chí s'ejihin ri an! ¿Á jo jan kamaha ri? ");
INSERT INTO majNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nk'ie nga i̱ncha jas'en tsutsuu̱, kitsjenjyú ntjo̱. ");
INSERT INTO majNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A̱s'a̱i já xi tíi̱ncha tsutsuu̱ kits'íntsjoho̱ Jesu nga b'i̱ kitsúhu̱: —Kju̱axi̱ nga ji xi Ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nk'ie nga ja j'atikjáko̱ Jesu já ni'yakuyáha̱ ntáchak'uu̱n, a̱s'a̱i tsichu nanki Genesaret. ");
INSERT INTO majNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nk'ie nga kamankjihi̱n xu̱ta̱ xi tjín yo̱ nga Jesu niu̱, kits'ínkint'é xu̱ta̱ xi tjín xki̱ a̱nte xi tjíndai yo̱. A̱s'a̱i i̱ncha j'aisehe̱ Jesu nga j'aiko̱ ngatentee̱ xu̱ta̱ xi uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","I̱ncha tsankihi̱ tsa tsjántehe̱ tsa tu̱ a̱ndai tuts'in najyun xi yja ts'i̱ínko̱, ko̱ kamanda ngayjee̱ xi kits'ínko̱ najyuhu̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","A̱s'a̱i i̱ncha j'aisehe̱ Jesu já fariseo̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ xi nibaha nanki Jerusalen. B'a̱ i̱ncha kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Á najmi ts'íntjusuhun já ni'yakuyáhi̱ sihi̱n xi y'éjñaná ntje̱ cháná? Najmi títjun bané ntsja nk'ie nga kjine ni̱ñu̱. ");
INSERT INTO majNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A̱s'a̱i b'i̱ kitsú Jesu: —Ko̱ máha jun, ¿á najmi n'etjusuhunnu ni xi y'éjña Nti̱a̱ná, nga tu̱ sahá sinnu̱u n'etjusuhunnu? ");
INSERT INTO majNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tjít'a má nga b'a̱ kitsú Nti̱a̱ná: “Cha̱nkjúín na̱'mihi̱ ko̱ na̱ahi̱”, ko̱ “Xi ch'on ku̱i̱tsu̱hu̱ na̱'mihi̱ ko̱ tsa na̱aha̱, kui xi tjíhin nga n'e̱k'ien.” ");
INSERT INTO majNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tu̱nga juhún b'a̱ bixíún nga tsa tjín xi b'i̱ ku̱i̱tsu̱hu̱ na̱'mihi̱ ko̱ tsa na̱aha̱: “Ngayjee̱ ni xi tjínna nga kúási̱nko̱ho kai, ja chje̱ kitsjaha̱ Nti̱a̱ná”, ");
INSERT INTO majNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","tsa tjín xi b'a̱ ku̱i̱tsu̱, kui xi najmi ta̱ tjíhin tsa sku̱e̱nkjún na̱'mihi̱ ko̱ tsa na̱aha̱. Kui nihi xi bixíún. B'a̱ ts'ín najmi ta̱ n'echjíhinu éhe̱n Nti̱a̱ná tu̱ nga̱t'aha̱ sin xi kin'ekjas'ennu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","’¡Tu̱ tsjohónu̱u nga bakuchíú xi nkú ts'ín yankjún Nti̱a̱ná! Kju̱axi̱ kjáíhin ni xi kitsú nda̱ profeta̱ Isaia̱ nk'ie nga b'a̱ ts'ín y'ét'a: ");
INSERT INTO majNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kui xu̱ta̱ xu'bi̱ tu̱ ts'ahá benkjúnna, tu̱nga ani̱ma̱ha̱ kjin tíjñaha̱ an. ");
INSERT INTO majNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Najmi chumi ni chjíhi̱ ra̱ chje̱ xi tsjána, a̱t'aha̱ tu̱ kju̱a̱téxumaha̱ xu̱ta̱há bakúya. ");
INSERT INTO majNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A̱s'a̱i b'i̱ kitsúhu̱ Jesu xu̱ta̱ nkjiu̱n: —Tjenñju ko̱ katumankjinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ni xi fas'en ts'a xu̱ta̱, najmi kui xi ts'ín sihi̱ nginku̱n Nti̱a̱ná. Ni xi bitju ní ts'a, kui ní nihi xi ts'ín sihi̱. ");
INSERT INTO majNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A̱s'a̱i j'aisehe̱ Jesu já ni'yakuyáha̱ ko̱ b'a̱ kitsúhu̱: —¿A yai nga já fariseo̱ najmi kuasasíhi̱n én xi kuachubai? ");
INSERT INTO majNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","B'i̱ kitsú Jesu: —N'e̱sjenji santaha ko̱ kja̱ma̱ha̱ ngayjee̱ yá xi najmi y'éntje̱ Na̱'mina̱ xi tíjña ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Najmi tu̱ nkjún manu̱u jóo̱. Já ka̱há niu̱ xi bakú ni̱yáha̱ xu̱ta̱ ka̱. Tsa nku nda̱ ka̱ ku̱a̱kú ni̱yáha̱ kj'a̱í nda̱ ka̱, ¿a najmi ku̱i̱xu̱ntuyáhá nga joo̱ nku ti̱xa̱? ");
INSERT INTO majNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A̱s'a̱i b'a̱ kitsú Pedro̱: —T'inyani̱ nkú tsuhu̱ ra̱ ni xi kuak'iejña chu̱ba̱yai. ");
INSERT INTO majNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","B'i̱ kitsú Jesu: —¿A ta̱ ndaha jun najmi mankjinnu̱u? ");
INSERT INTO majNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A najmi yanú nga ngayjee̱ ni xi fas'en ts'a xu̱ta̱, fi a̱ya ka̱ts'a̱ ko̱ bitju ngáha? ");
INSERT INTO majNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ni xi bitju ní ts'a xu̱ta̱, kui ní xi nibáha a̱jin ani̱ma̱ha̱ ko̱ kui xi ts'ín sihi̱ nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A̱t'aha̱ a̱jin ani̱ma̱ha̱ ní xu̱ta̱ nibáha̱ ra̱ nga ch'on ts'ín ts'ínnkjink'un, nga ts'ínk'ien xinkjín, nga bangane kju̱a̱bixoo̱n, nga tjín xi fantuko̱ jminchjín nga najmi kje̱e bixan, nga ndyjé ts'ín, nga nchja̱ én tsank'á, ko̱ nga ch'on tsuhu̱ xinkjín. ");
INSERT INTO majNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kuihí ni xu'bi̱ xi ts'ín sihi̱ xu̱ta̱ nginku̱n Nti̱a̱ná. Tu̱nga tsa kji̱ne̱ ni̱nku̱a̱n nga najmi títjun ku̱a̱né ntsja, najmi kui nihi xi ts'ín sihi̱ xu̱ta̱ nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","A̱s'a̱i tsitju Jesu yo̱ nga ngji a̱nte xi tiña maha̱ nanki Tiro̱ ko̱ nanki Sidon. ");
INSERT INTO majNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ko̱ tu̱ kikjintáya tje̱nnkihí ra̱ nku ta̱chju̱ún xi najmi ntje̱ judio̱ tje̱he̱n ra̱ xi yo̱ tíjña. B'a̱ kitsúhu̱: —¡Ji chá maestru̱, ji xi ntje̱he̱ David, cha̱se̱ ni̱ma̱ní i̱chí an! ¡Ta̱kjín i̱chína̱ tíjñajihi̱n chánindoo̱, kui nga tu̱ xí uhún tíbehe̱ ra̱! ");
INSERT INTO majNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tu̱nga ndahá nku én najmi kinchja̱ Jesu. A̱s'a̱i j'aise tiñaha̱ já ni'yakuyáha̱ ko̱ b'a̱ i̱ncha kitsúhu̱: —Tu̱ sahá b'a̱ t'ihi̱n ta̱chjúu̱n nga katji, a̱t'aha̱ tíkjintáya tje̱nnkiná. ");
INSERT INTO majNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A̱s'a̱i b'i̱ kitsú Jesu: —Kits'ín nibána Nti̱a̱ná nga tu̱ nkuhú xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱ kfínsehe̱, xu̱ta̱ xi kindyja xi nkú joyaha chu̱tsa̱nka̱ xi ngji t'axín suba. ");
INSERT INTO majNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A̱s'a̱i j'ai ta̱chjúu̱n, tsasinkúnch'int'aha̱ Jesu ko̱ b'a̱ kitsúhu̱: —¡Ji chá maestru̱, ti̱si̱nko̱ní i̱chí an! ");
INSERT INTO majNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","B'i̱ kitsú Jesu: —Najmi nda tjín tsa chjú'aha̱ ni̱nku̱a̱ha̱n jántíu̱ nga kj'u̱a̱i̱hi̱ nañóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A̱s'a̱i b'a̱ kitsú ta̱chjúu̱n: —Joho̱n, chá maestru̱, tu̱nga santahá ni ko̱ nañóo̱ kjine xi̱hi̱ ni̱nku̱a̱n xi bixunntunkí yámixa̱ha̱ nti̱a̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","B'i̱ kitsú Jesu: —Ji ta̱chju̱ún, ¡á b'a̱ 'yún s'ejihin ri nga Nti̱a̱ná kits'ín nibána! Katuma xi nkú ts'ín mjehi. Ta̱ kuihi chu̱bo̱ kamanda ta̱kjíhi̱n ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tsitju Jesu yo̱ nga ngji a̱ndai ntáchak'un Galilea̱. A̱s'a̱i ngjinji nku a̱sunntu tje̱nki̱ ko̱ yo̱ y'ejña. ");
INSERT INTO majNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","I̱ncha j'aisehe̱ Jesu nkjin ṉkjún xu̱ta̱ nga j'aiko̱ xi najmi ma fi, xi ka̱, xi najmi ma nchja̱, xi kutu ntsja, ko̱ nkjin sa xi uhu̱n. Kui xi j'aik'íéntut'áha̱ Jesu ko̱ Jesu kits'ínnkihi̱ ngayjee̱. ");
INSERT INTO majNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kui nga kama nkjúhu̱n ra̱ xu̱ta̱ nkjiu̱n nk'ie nga kikie nga tínchja̱ xu̱ta̱ xi najmi ma nchja̱, kamandu̱ú ntsja xu̱ta̱ xi kutu ntsja, tjíma xu̱ta̱ xi najmi ma fi, ko̱ kama chjihi̱ xu̱ta̱ xi ka̱. A̱s'a̱i i̱ncha kits'íntsjoho̱ Nti̱a̱ha̱ xu̱ta̱ Israel. ");
INSERT INTO majNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A̱s'a̱i kinchja̱ha̱ Jesu já ni'yakuyáha̱ ko̱ b'i̱ kitsúhu̱: —Tíma ni̱ma̱na xu̱ta̱ nkjii̱n, a̱t'aha̱ ja tjíhi̱n jan ni̱stjin nga tjíntuko̱ná e̱i̱. Ja najmi ta̱ tjíhi̱n ra̱ nichine. Najmi mjena ts'inkjí kjintíá, a̱t'aha̱ tsa ku̱a̱yáya a̱ya ni̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A̱s'a̱i b'i̱ i̱ncha kitsú já ni'yakuyóo̱: —¿Tu̱nga má xi tje̱hen sa̱kúná e̱i̱ a̱nte t'axín xu'bi̱ ni̱nku̱a̱n xi ka̱maha̱ ra̱ nga kji̱ne̱ xu̱ta̱ xi b'i̱ nkjún ts'ín nkjin maha? ");
INSERT INTO majNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","B'i̱ kitsú Jesu: —¿Nkú tjín ni̱nku̱a̱n kich'o? B'a̱ i̱ncha kitsú jóo̱: —Yatu maha ko̱ k'u̱a̱ tji̱o̱ xi̱xi̱. ");
INSERT INTO majNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","A̱s'a̱i b'a̱ kitsú Jesu nga k'úéntu xu̱ta̱ nkjiu̱n t'anankiu̱. ");
INSERT INTO majNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jakj'á ni̱nku̱a̱n xi yatuu̱ ko̱ tji̱o̱ ko̱ kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná. Tsakjánya ko̱ kitsjáha̱ já ni'yakuyáha̱. A̱s'a̱i já ni'yakuyóo̱ kits'ínndzjoho̱ ni̱nku̱o̱n ko̱ tji̱o̱ xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kikjine tente xu̱ta̱ niu̱ santa nkúhu nga kitse sisihi̱n. A̱s'a̱i j'áíya ni̱nku̱a̱n xi ts'ankiu̱. Yatu ni̱si̱n kama. ");
INSERT INTO majNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ñju mii̱ jáx'i̱n ko̱ kj'a̱í jminchjíu̱n ko̱ jántí xi kikjine nichinee̱. ");
INSERT INTO majNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nk'ie nga kits'ínkji Jesu xu̱ta̱ nkjiu̱n ni'yaha̱, jas'en ngáha tsutsuu̱ nga ngji a̱nte xi tiña maha̱ nanki Magadan. ");
INSERT INTO majNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","I̱ncha j'ai já fariseo̱ ko̱ já saduseo̱ nga j'ai kjut'ayák'un Jesu. Tsankihi̱ nga ts'i̱ín nku kju̱a̱nkjún xi ku̱a̱kúchji nga Nti̱a̱ná kits'ín nibáha̱. ");
INSERT INTO majNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tunga b'i̱hí kitsú Jesu: —Nk'ie nga ja ma ngixuu̱n b'a̱ bixíún: “Nda chun ka̱ma, a̱t'aha̱ chun jeje nk'a ján.” ");
INSERT INTO majNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ko̱ nga ta̱ jyuu̱n b'a̱ bixín ngó: “Ch'on chun ka̱ma nd'a̱i̱, a̱t'aha̱ ni̱nti̱ tíi̱ncha.” Mankjinnu̱u ni xi ma chji nk'a ján, tu̱nga, ¿á najmi tímankjihi̱nnu̱u ni xi tís'ejña chjihi ni̱stjin nd'a̱i̱? ");
INSERT INTO majNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Xu̱ta̱ xi tjín nd'a̱i̱ tíi̱ncha banki nga sku̱e̱ nku kju̱a̱nkjún, a̱t'aha̱ ch'onk'un ko̱ najmi na̱xu̱ tíi̱ncha nginku̱n Nti̱a̱ná. Tu̱nga tu̱ ni xi kamat'aihín nda̱ profeta̱ Jona ni̱stjin nk'ie, kui kju̱a̱nkjúhun xi s'e̱jña chjihi̱ xu̱ta̱ xi tjín nd'a̱i̱. B'a̱ kitsú Jesu, a̱s'a̱i ngji t'axíhi̱n xu̱to̱. ");
INSERT INTO majNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nk'ie nga tsichu já ni'yakuyáha̱ ngabantóo̱, tu̱ kichayahá ra̱ nga kik'a ni̱nku̱a̱n. ");
INSERT INTO majNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","A̱s'a̱i b'a̱ kitsú Jesu: —Nda cha̱so̱o. Chúhu̱un yjonu̱u na̱'yu̱ saha̱n já fariseo̱ ko̱ já saduseo̱. ");
INSERT INTO majNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A̱s'a̱i b'i̱ ngján kinchja̱ni̱jmíyako̱ho xinkjín já ni'yakuyóo̱ nga najmi i̱ncha y'a ni̱nku̱a̱n. ");
INSERT INTO majNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kamankjihi̱n Jesu ni xi tíi̱ncha tsu jóo̱ ko̱ b'a̱ kitsúhu̱: —¿Á tíchubani̱jmíyako̱honu xinki̱u nga najmi kich'ahanu ni̱nku̱a̱n? ¡Á b'a̱ 'yún i̱chí s'ejihi̱nnu̱u nga Nti̱a̱ná kits'ín nibána! ");
INSERT INTO majNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿A tu̱ yje najmi kje̱hé mankjinnu̱u? ¿A najmi ta̱ f'áítsjehénnu̱u ni̱nku̱a̱n xi uu̱n xi tsakjanyáha̱ já xi un mii̱ maha ko̱ nkú tjín ni̱si̱n kin'etso ni̱nku̱a̱n xi y'ekú? ");
INSERT INTO majNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ko̱ a najmi ta̱ f'áítsjehénnu̱u ni̱nku̱a̱n xi yatuu̱ xi tsakjanyáha̱ já xi ñju mii̱ maha ko̱ nkú tjín ni̱si̱n kin'etso ni̱nku̱a̱n xi y'ekú? ");
INSERT INTO majNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nkú tjíhi̱n ra̱ nga najmi tímankjihi̱nnu̱u nga najmi ni̱nku̱a̱n tínchjani̱jmíyahana? Tu̱nga chúhún ru̱u yjonu̱u na̱'yu̱ saha̱n já fariseo̱ ko̱ já saduseo̱. ");
INSERT INTO majNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","A̱s'a̱i kamankjihi̱n já ni'yakuyóo̱ ni xi tínchja̱ Jesu, nga najmi na̱'yu̱ saha̱n ni̱nku̱a̱n xi tjíhin nga kúhu̱n yjoho̱. Nga̱t'aha̱ ní ni xi bakúya já fariseo̱ ko̱ já saduseo̱ tjíhin nga kúhu̱n yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nk'ie nga tsichu Jesu tiña nanki Cesarea̱, má nga batéxuma nda̱ Felipe̱, a̱s'a̱i b'a̱ kitsúhu̱ já ni'yakuyáha̱: —¿Yáhá ni Ntíhi̱ Nda̱x'i̱u̱n tsu xu̱ta̱? ");
INSERT INTO majNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","B'a̱ kitsú já ni'yakuyóo̱: —Tjín xi b'a̱ tíi̱ncha tsu nga ji xi Jua Bautista̱. Tjín ngá xi b'a̱ tíi̱ncha tsu nga ji xi Elia̱. Ko̱ tjín ngá xi b'a̱ tíi̱ncha tsu nga ji xi Jeremia̱ ko̱ a ra̱ kj'a̱í nda̱ profeta̱. ");
INSERT INTO majNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","B'i̱ kitsú Jesu: —Ko̱ jun, ¿yá xi bixíún nga an? ");
INSERT INTO majNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A̱s'a̱i b'a̱ kitsú Simon Pedro̱: —Ji xi Cristo̱. Ji xi Ntíhi̱ Nti̱a̱ná xi tíjña tík'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","B'i̱ kitsú Jesu: —Nda tjín nga̱t'a ts'i̱, Simon, ntíhi̱ Jona. A̱t'aha̱ ndaha nku xu̱ta̱ a̱sunntei̱ najmi y'éjña chjihi nii̱. Na̱'mina̱ ní xi tíjña ndji̱o̱jmi ján y'éjña chjihi nii̱. ");
INSERT INTO majNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ko̱ an b'a̱ tíxihin nga ji xi k'úíhin Pedro̱. Ts'inndá ni̱nku̱na̱ a̱suhu̱n ndji̱o̱ xu'bi̱ ko̱ nga'yúhu̱n ngabayoo̱ najmi ka̱maha̱ ts'i̱ín ngana̱ha̱ xu̱ta̱ xi ts'a̱n. ");
INSERT INTO majNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","An tsjaha yubi̱hi̱ má batéxuma Nti̱a̱ná. Ni xi k'úét'a'yín e̱i̱ a̱sunntei̱, ta̱ s'e̱t'a'yún ndji̱o̱jmi ján. Ko̱ ni xi chjúndáyai e̱i̱ a̱sunntei̱, ta̱ ku̱i̱ndáya ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A̱s'a̱i b'a̱ kitsúhu̱ Jesu já ni'yakuyáha̱ nga najmi tu̱ ch'a ku̱i̱tsu̱yaha̱ nga kui xi kits'ín nibáha̱ Nti̱a̱ná ngajoho̱. ");
INSERT INTO majNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kui ni̱stjiu̱n kik'atuts'i̱hi̱n Jesu nga kitsúya kixi̱hi̱ já ni'yakuyáha̱ nga tjíhin nga ngju̱a̱i̱ nanki Jerusalen, ko̱ nga un ṉkjún sku̱e̱he̱ a̱ya ntsja jáchá xi tjíhi̱n xá ko̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱, ko̱ nga n'e̱k'ien ko̱ ni̱stjin xi ma jahan kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","A̱s'a̱i Pedro̱ ngjiko̱ t'axín Jesu ko̱ b'a̱ kitsúhu̱ nga najmi nda kits'ín nga b'a̱ kitsú. B'a̱ kitsú Pedro̱: —¡Ji nda̱ maestru̱, Nti̱a̱ná kakjexíhin ngayjee̱ ni xu'bo̱! ¡Najmi tu̱ chumi nihi xi katumahi! ");
INSERT INTO majNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tu̱nga kits'ínk'ótjiyak'uhún Jesu Pedro̱ ko̱ b'i̱ kitsúhu̱: —¡Ti̱yú xinní, Satana! Ji xi tín'endyja̱jinní. A̱t'aha̱ najmi ni xi ts'e̱ Nti̱a̱ná tín'enkjíntak'uin. Ni xi ts'e̱ ní xu̱ta̱ a̱sunntei̱ tín'enkjíntak'uin. ");
INSERT INTO majNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","A̱s'a̱i b'a̱ kitsúhu̱ já ni'yakuyáha̱: —Tsa tjín xi mjehe̱ tsjénnkina, kat'éch'o subaha̱ yjoho̱ ni xi mjehe̱ ko̱ katsjáha̱ yjoho̱ nga ku̱a̱yá nga̱t'ana̱, a̱s'a̱i katsjennkína. ");
INSERT INTO majNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","A̱t'aha̱ xi mjehe̱ ts'i̱ínk'anki suba yjoho̱ nga k'úéjña tík'un, kui xi tu̱ sahá ku̱a̱yá. Tu̱nga xi ku̱a̱yá nga̱t'ana̱, kui xi sa̱kúhu̱ nga k'úéjña tík'un. ");
INSERT INTO majNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","A̱t'aha̱, ¿mí xi chjíhi̱ ra̱ tsa ts'i̱ín ngana̱ xu̱ta̱ ngayjee̱ ni xi tjín a̱sunntee̱, tsa tu̱ sa ndyja̱há ngá ani̱ma̱ha̱? ¿Mí nihi xi tsjá nga k'u̱échjíntjai ani̱ma̱ha̱? ");
INSERT INTO majNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","A̱t'aha̱ Ntíhi̱ Nda̱x'i̱u̱n kj'u̱a̱íko̱ kju̱a̱chánkaha̱ Na̱'mihi̱ ko̱ kj'u̱a̱íko̱ ntítsjehe̱. Nk'ie k'u̱échjíhi̱ nga nkúnkú xu̱ta̱ ni xi kits'ín. ");
INSERT INTO majNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kju̱axi̱ ni xi tíxinnu̱u. K'u̱a̱ xi tíi̱ncha e̱i̱ najmi ku̱a̱yá santa nkúhu nga sku̱e̱ nga kj'u̱a̱ítéxuma Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A̱skahan nk'ie nga j'a jun ni̱stjin, Jesu kinchja̱ t'axíhi̱n Pedro̱, Santiago̱ ko̱ Jua xi nts'e̱ maha Santiago̱. Ngjiko̱ t'axín jóo̱ nku a̱sunntu tje̱nki̱ nk'a. ");
INSERT INTO majNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yo̱ kik'óntjaiya sénni̱stjihi̱n Jesu nginku̱n jóo̱. Tsat'ai a̱nkjín xi nkú joyaha ts'íu̱ ko̱ najyuhu̱n taba xúxú kama ko̱ tsat'ai. ");
INSERT INTO majNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ta̱ kikie jóo̱ Moise ko̱ Elia̱ nga ti̱íncha nchja̱ni̱jmíko̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","A̱s'a̱i b'a̱ kitsú Pedro̱: —Ji nda̱ maestru̱, ¡á b'a̱ nda tjíhin nga e̱i̱ ku̱i̱ntsu̱ba̱haná! Tsa mjehi, ts'inndá e̱i̱ jan ni'ya yántsu̱, nku xi ka̱ma ts'i̱, nku xi ka̱ma ts'e̱ Moise ko̱ nku xi ka̱ma ts'e̱ Elia̱. ");
INSERT INTO majNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nk'ie nga b'a̱ ta̱ títsuhu Pedro̱, tu̱ nkuhú ni̱nti̱ xi tíbat'ai j'ai ts'ínnk'íéhe̱n jóo̱ ko̱ kinu'yá a̱jin ni̱nti̱u̱ nku nta̱ xi b'a̱ kitsú: —Kui xu'bi̱ xi Ntína̱. Tjona ko̱ tsjo mana. Ta̱sinñjuhu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nk'ie nga kint'é nto̱ já ni'yakuyóo̱ tu̱ ni xí i̱ncha kitsankjúhún. Kui nga xí t'anankiu̱hú y'ét'aha nintaku̱ nga i̱ncha tsinchakúnch'in. ");
INSERT INTO majNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A̱s'a̱i j'aik'úhu̱n Jesu ko̱ kits'ínko̱ho̱ nga b'i̱ kitsúhu̱: —Tisíntjo̱on. Najmi tu̱ binkjun. ");
INSERT INTO majNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nk'ie nga kingjénnk'a ngáha a̱nkjín jóo̱, najmi ta̱ ch'a xi kikiehe. Tu̱ Jesu síjña subahá. ");
INSERT INTO majNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nk'ie nga ja tíi̱ncha nibájen ngáha a̱sunntu tje̱nki̱u̱, b'a̱ kitsúhu̱ Jesu jóo̱: —Najmi tu̱ ch'a xi 'miyoho̱o ni xi kuayo santaha nkúhu nga kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱ Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A̱s'a̱i kingjásjaiya já ni'yakuyóo̱: —¿Á b'a̱ tsuhu já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ nga tjíhin nga kj'u̱a̱í títjuhun Elia̱? ");
INSERT INTO majNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","B'i̱ kitsú Jesu: —Kju̱axi̱ nga kj'u̱a̱í títjun Elia̱ ko̱ k'u̱énda ngayjee̱ ni xi tjín. ");
INSERT INTO majNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tu̱nga an b'a̱ tíxinnu̱u nga ja j'ai Elia̱, tu̱nga najmi kamankjihín ra̱ xu̱ta̱ tsa Elia̱ niu̱. Tu̱ ni xi kama mjehé ra̱ jóo̱ kits'íhi̱n. B'a̱ ta̱ ts'ín un sku̱e̱he̱ Ntíhi̱ Nda̱x'i̱u̱n a̱ya ntsja jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","A̱s'a̱i kamankjihi̱n já ni'yakuyóo̱ nga Jua Bautista̱ kinchja̱ni̱jmíyaha Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nk'ie nga i̱ncha j'ai ngáha má nga tíi̱ncha xu̱ta̱ nkjiu̱n, a̱s'a̱i nku nda̱ j'aisehe̱ Jesu ko̱ tsasinkúnch'int'aha̱ nga b'a̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ji nda̱ maestru̱, cha̱se̱ ni̱ma̱hi̱ i̱chí nda̱ chína̱. Tjín ni̱stjin nga jyuhú kj'i b'atsé ko̱ 'yún un behe̱. Tjín nga nkjin ni̱yá jnejin nd'íu̱ ko̱ tsa ntánijuo̱. ");
INSERT INTO majNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kjúái̱ko̱ho̱ já ni'yakuyáhi̱, tu̱nga najmi kamahá ra̱ kuats'ínnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A̱s'a̱i b'i̱ kitsú Jesu: —¡Á b'a̱ 'yún i̱chí s'ejihi̱n ra̱ Nti̱a̱ná xu̱ta̱ xi tjíhin nd'a̱i̱ ko̱ ch'onk'uhun! ¿Nkjé kjin tjíhin nga kúáte̱jñajinnu̱u? ¿Nkjé kjin tjíhin nga ts'in chúkju̱a̱nu̱u? Nibáko̱nú nda̱ chíu̱ e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","A̱s'a̱i ndjá kinchja̱ko̱ Jesu nda̱nindoo̱ ko̱ tsitjujihi̱n nda̱ chíu̱. Ta̱ kuihi chu̱bo̱ kamanda nda̱ chíu̱. ");
INSERT INTO majNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","A̱skahan já ni'yakuyáha̱ j'aingjásjaiya t'axíhi̱n. B'a̱ i̱ncha kitsúhu̱: —¿Á najmi kamaha̱ni̱ kuakich'onsje̱he̱ni̱ nda̱nindoo̱? ");
INSERT INTO majNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","B'i̱ kitsú Jesu: —A̱t'aha̱ 'yún i̱chí s'ejinnu̱u Nti̱a̱ná. Kju̱axi̱ ni xi tíxinnu̱u. Tsa tu̱ i̱chí s'ejinnu̱u xi nkúhu nku k'un mostasa̱ xi 'yún i̱chí, ka̱ma b'a̱ k'úíhu̱un a̱sunntu tje̱nki̱ xu'bi̱: “Ti̱yú xin e̱i̱ ko̱ t'in t'axín.” A̱s'a̱i ngju̱a̱i̱ t'axín. Ko̱ tu̱ mí nihí ni xi ka̱manu̱u, tsa b'a̱ ts'ín s'e̱jinnu̱u Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tu̱nga jáninda xi nkúhu xu'bi̱ najmi chu̱ba̱ bitju. Nk'ie nga chu̱baka̱áhá Nti̱a̱ná ko̱ nga bintsu̱ba̱ kjintíaá, nk'iehé nga bitju. ");
INSERT INTO majNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nk'ie nga tsú'bako̱ Jesu já ni'yakuyáha̱ a̱nte Galilea̱, b'i̱ kitsúhu̱: —N'e̱kjas'en Ntíhi̱ Nda̱x'i̱u̱n a̱ya ntsja xu̱ta̱ ");
INSERT INTO majNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ko̱ i̱ncha ts'i̱ínk'iehe̱n. Tu̱nga ni̱stjin xi ma jahán ni kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱. Kik'ie nusin nusihi̱n já ni'yakuyóo̱ nga b'a̱ kitsú Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nk'ie nga tsichuko̱ Jesu já ni'yakuyáha̱ nanki Capernaum, a̱s'a̱i i̱ncha j'aisehe̱ Pedro̱ já xi f'ásuhu̱n to̱on ni̱nku̱ xi síjña nanki Jerusalen. B'a̱ i̱ncha kitsúhu̱ Pedro̱: —¿A najmi b'échjíntjaihí nda̱ maestru̱hi̱ ni̱nku̱? ");
INSERT INTO majNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Joho̱n —kitsú Pedro̱. A̱s'a̱i nk'ie nga jas'en Pedro̱ ni'ya má tíjña Jesu, tu̱ Jesuhú tjun kinchja̱ko̱ho̱: —Ji Simon, ¿nkú bixín? Já rei̱ xi tjín a̱sunntei̱, ¿yá xi ts'ínk'íéchjíntjai? ¿A ntíhi̱, a ra̱ xu̱ta̱ xi kj'a̱íhí? ");
INSERT INTO majNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Xu̱ta̱ xi kj'a̱í —kitsú Pedro̱. A̱s'a̱i b'i̱ kitsú Jesu: —Joho̱n, najmi b'échjí ntíhi̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tu̱nga tu̱ xi najmi ch'on ka̱maha̱ ra̱ jóo̱, tu̱ sahá t'in a̱ndai ntáchak'uu̱n ko̱ ndjein nintu. Tji̱o̱ xi tjun ngju̱a̱i̱t'ahi chjúx'á'ai ts'a. Yo̱ sa̱kúhi to̱on xi ka̱ma k'úéchjíntjaihini jo xu̱ta̱. Chjúbéí to̱oo̱n ko̱ t'ink'iechjí xi ts'i̱ ko̱ xi ts'a̱n. ");
INSERT INTO majNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ta̱ kui ni̱stjin xu'bo̱ j'aisehe̱ Jesu já ni'yakuyáha̱. B'a̱ i̱ncha kitsúhu̱ nga kingjásjaiyaha̱: —¿Yá xi 'yún chánka sa má batéxuma Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A̱s'a̱i kinchja̱ha̱ Jesu nku nda̱ chí, tsasíjñajin masehe̱n jóo̱ ");
INSERT INTO majNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ko̱ b'a̱ kitsú: —Kju̱axi̱ ni xi tíxinnu̱u. Tsa najmi kuankínchj'a̱ha̱ ru̱u ani̱ma̱nu̱u ko̱ n'e̱k'óntjaiyo yjonu̱u xi nkú joyaha ntí xi̱ ntí ntí, najmi ku̱i̱tjás'e̱njiun nga Nti̱aṉá xi ku̱a̱téxumanu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kui nga tu̱ yáha ni xi ts'i̱ín ni̱ma̱kju̱a̱ha yjoho̱ xi nkú joyaha nda̱ chí xu'bi̱, kui xi 'yún chánka ka̱ma má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ko̱ xi ngajona̱ ts'i̱ínkjáíhi̱n ra̱ nku nda̱ chí xi nkúhu xu'bi̱, kui xi an títs'ínkjáínna. ");
INSERT INTO majNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Tu̱ yáha ni xi ts'i̱ínkijnejin ngatitsun nku nda̱ chí xi nkúhu xu'bi̱ xi s'ejihi̱n an, tu̱ sahá ra̱ ngandaha̱ xi b'a̱ ts'i̱íu̱n tsa s'e̱t'a 'yúnt'a kásin nku ndji̱o̱ chánka ko̱ chja̱nikj'ajin má na̱nka̱ha̱ ntáchak'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ni̱ma̱ rú ts'íhin xu̱ta̱ xi tjín a̱sunntei̱, a̱t'aha̱ tjín ni xi ts'ínkijnejihi̱n ngatitsun! Tjíhin nga s'e̱ ni xi ts'i̱ínkijnejihi̱n ngatitsun xu̱ta̱, tu̱nga, ¡ni̱ma̱ rú ts'íhin xu̱ta̱ xi ts'i̱ínkijnejin ngatitsun xu̱ta̱ xi kj'a̱í! ");
INSERT INTO majNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Kui b'a̱ maha, tsa ntsa̱i̱ ko̱ tsa tsu̱kui xi títs'ínkijnejihin ngatitsun, tu̱ sahá ti̱chákjáí ko̱ kjin chja̱niyai. Tu̱ sahá ngandahi̱ tsa ku̱i̱tjás'e̱n ni̱ma̱i̱ ko̱ tsa kutui má nga k'úéntu tík'un xu̱ta̱, ko̱ najmi tsa tjít'a nga joo̱ tsu̱kui ko̱ nga joo̱ ntsa̱i̱ tu̱nga tu̱ sa a̱jin nd'í xi najmi mahá ra̱ 'meya chja̱nikj'ajin ngáhi. ");
INSERT INTO majNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ko̱ tsa tunkuin xi títs'ínkijnejihin ngatitsun, tu̱ sahá n'e̱sjei ko̱ kjin chja̱niyai. Tu̱ sahá ngandahi̱ tsa ku̱i̱tjás'e̱n ka̱t'ai má nga k'úéntu tík'un xu̱ta̱, ko̱ najmi tsa tíi̱ncha nga joo̱ tunkuin tu̱nga tu̱ sa a̱jin nd'í nga̱k'i̱e̱hén chja̱nikj'ajin ngáhi. ");
INSERT INTO majNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’T'ejin tak'un. Najmi tu̱ tohón manu̱u nku nda̱ chí xi nkúhu xu'bi̱. A̱t'aha̱ an b'a̱ tíxinnu̱u nga ntítsjehe̱ jántíu̱ xi tjín ndji̱o̱jmi ján, tjíntu tehe̱nte nginku̱n Na̱'mina̱ xi tíjña ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","A̱t'aha̱ Ntíhi̱ Nda̱x'i̱u̱n j'ai ts'ínk'anki xu̱ta̱ xi ja kindyja kai. ");
INSERT INTO majNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Nkú bixíún? Tsa nku nda̱ tíi̱nchaha̱ unchan chu̱tsa̱nka̱, tsa ndyja̱ha̱ nku, ¿a najmi ku̱i̱ncháhá xi cháte ko̱ yachán ñjoo̱ a̱jin jñóo̱ ko̱ ngju̱a̱i̱ngisjáí xi kandyjoo̱? ");
INSERT INTO majNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kju̱axi̱ ni xi tíxinnu̱u. Tsa sa̱kúsjaihi̱ chu̱ xi kandyjoo̱, 'yún tsjo ka̱ma saha̱ chu̱ xi nku xi kuasakú ngáha̱ ra̱, nga xi cháte ko̱ yachán ñja xi najmi kandyjoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","B'a̱ ta̱ ts'ín najmi mjehe̱ Na̱'minu̱u xi tíjña ndji̱o̱jmi ján tsa ndyja̱ ndaha nku jántí ntí xi nkúhu xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tsa ch'on títs'íhin nda̱ nts'ei, t'ihi̱nse̱i̱hi̱ ko̱ chu̱bani̱jmíko̱ su̱ba̱i̱ nga b'a̱ t'ihi̱n nga najmi nda tjín ni xi títs'ín. Tsa ku̱i̱nt'é éhin, ja kuijnehi nda̱ nts'ei. ");
INSERT INTO majNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tu̱nga tsa najmi ku̱i̱nt'é éhin, t'inko̱i̱ tsa nku ko̱ tsa jo xu̱ta̱, tu̱ xi b'a̱ ts'ín s'e̱he tsa jo ko̱ tsa jan testiyu̱ xi ku̱i̱tsu̱ya ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tu̱nga tsa najmi ku̱i̱nt'é éhe̱n jóo̱, t'inyaihi̱ xu̱ta̱ ni̱nku̱ ni xi títs'ín. Ko̱ tsa najmi ku̱i̱nt'é éhe̱n xu̱ta̱ ni̱nku̱, katumahi ndo̱ xi nkú joyaha já xi najmi be Nti̱a̱ná ko̱ tsa xi nkúhu já xi f'áchjíntai ch'á nga ts'ínxát'aha̱ já Roma. ");
INSERT INTO majNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Kju̱axi̱ ni xi tíxinnu̱u. Ni xi k'úét'a'yún e̱i̱ a̱sunntei̱, ta̱ s'e̱t'a'yún ndji̱o̱jmi ján. Ko̱ ni xi chjúndáyo e̱i̱ a̱sunntei̱, ta̱ ku̱i̱ndáya ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ko̱ b'a̱há ta̱ tíxin ngáhanu̱u. Tsa jo ka̱mo nga k'úéndo e̱i̱ a̱sunntei̱ ni xi mjenu̱u nga ku̱i̱nchíhu̱u Na̱'mina̱ xi tíjña ndji̱o̱jmi ján, kui xi tsjánu̱u ni xi ku̱i̱nchíú. ");
INSERT INTO majNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","A̱t'aha̱ má nga ka̱ma ñjakú tsa jo ko̱ tsa jan xu̱ta̱ xi s'ejihi̱n an, an ta̱ tíi̱jñajin masehe̱n xu̱ta̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","A̱s'a̱i j'ai tiña Pedro̱ ko̱ kingjásjaiya: —Ji nda̱ maestru̱, ¿nkú tjín ni̱yá ts'inndyjat'aha̱ nda̱ nts'é nga ch'on títs'ínna? ¿A santaha yatu ni̱yá? ");
INSERT INTO majNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","B'i̱ kitsú Jesu: —Najmi tu̱ yatu ni̱yá tíxihin. Cháte ko̱ kan ní ni̱yá nga yatu. ");
INSERT INTO majNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","B'i̱ kitsú Jesu: —Kui b'a̱ maha, má batéxuma Nti̱a̱ná b'a̱ joyaha nku nda̱ rei̱ xi kama mjehe̱ ts'i̱ínko̱ kuenta̱ já musu̱hu̱. ");
INSERT INTO majNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nk'ie nga tíb'atuts'i̱hi̱n nga títs'ínxki̱, a̱s'a̱i j'ai kin'ekasínjña nginku̱n nku nda̱ musu̱ xi 'yún tse tje̱he̱n ts'e̱. ");
INSERT INTO majNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tu̱nga najmi tjíhín ra̱ ndo̱ to̱on xi k'u̱échjíhi ni xi tje̱he̱n. A̱s'a̱i kitsjá kju̱a̱ nda̱ nti̱a̱ha̱ nga sa̱téña ndo̱, chju̱úhu̱n, ntíhi̱ ko̱ ngayjee̱ ni xi tjíhi̱n, tu̱ xi b'a̱ ts'ín ku̱i̱tju chjíhi̱ ra̱ to̱on xi tje̱he̱n. ");
INSERT INTO majNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","A̱s'a̱i tsasinkúnch'in nda̱ musu̱ nginku̱n nda̱ nti̱a̱ha̱ ko̱ b'a̱ kitsú: “Ji nda̱ nti̱a̱, n'e̱ chúkju̱a̱ saní i̱chí. K'uechjí tentehé ra to̱ohi̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kama ni̱ma̱ha̱ ndo̱ nda̱ musu̱hu̱. Kits'ín nda̱í ngáha̱ ra̱ ko̱ kits'ínndyjat'a tentehe̱ to̱on xi tje̱he̱n. ");
INSERT INTO majNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Tu̱nga nk'iehé nga tsitju nda̱ musu̱ yo̱, kisatékjá kj'a̱í nda̱ musu̱ xinkjín xi i̱chí tje̱he̱n ts'e̱. Kui xi jakj'á nga kitsubantu ko̱ b'a̱ kitsúhu̱: “¡T'echjíná to̱onna̱ xi tje̱hin!” ");
INSERT INTO majNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A̱s'a̱i tsasinkúnch'int'aha̱ nda̱ musu̱ xinkjín ko̱ b'i̱ kitsú nga tsankihi̱: “N'e̱ chúkju̱a̱ saní i̱chí. K'uechjí tentehé ra to̱ohi̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tu̱nga najmi kits'ín yuhú nda̱ musu̱. Tu̱ sahá ngjingjáya'yún nda̱ musu̱ xinkjín ndo̱. Yo̱ rú ngju̱áya santaha nkú rúhu k'u̱échjí ni xi tje̱he̱n. ");
INSERT INTO majNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","’Nk'ie nga kikie já musu̱ xingisoo̱ ni xu'bi̱, un ṉkjún kama k'un ko̱ ngji tsúyaha̱ nda̱ nti̱a̱ha̱ ngayjee̱ ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","A̱s'a̱i kinchja̱ ngáha̱ ra̱ nda̱nti̱a̱ha̱ nda̱ musu̱ xu'bo̱ ko̱ b'a̱ kitsúhu̱: “¡Ji nda̱ musu̱ ch'onk'un! An kuats'inndyjat'aha ngayjee̱ to̱on xi tje̱hin tu̱ nga̱t'aha̱ nga b'a̱ kuak'inní. ");
INSERT INTO majNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿A najmi ko̱hó ji tjíhin nga ka̱ma ni̱ma̱hi nda̱ musu̱ xinki̱ xi nkú ts'ín kama ni̱ma̱na ji?” ");
INSERT INTO majNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kama kjaha̱n nda̱ nti̱a̱ha̱. A̱s'a̱i kits'ínkjas'en nda̱ musu̱ a̱ya ntsja já xi basehe̱ nu̱ba̱yóo̱ tu̱ xi tsjáha̱ ra̱ kju̱a̱ni̱ma̱. Yo̱ s'e̱ya santaha nkúhu nga k'u̱échjí to̱on xi tje̱he̱n. ");
INSERT INTO majNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’B'a̱ ta̱ ts'i̱ínnu̱u Na̱'mina̱ xi tíjña ndji̱o̱jmi ján tsa najmi ngayjehe ani̱ma̱nu̱u n'e̱ndyjat'oho̱o nts'o. ");
INSERT INTO majNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nk'ie nga ja kamaha̱ Jesu nga b'a̱ kitsú, a̱s'a̱i tsitju a̱nte Galilea̱ nga ngji a̱nte xi tjín Judea̱ xi tíjña ngabantá ntáje̱ Jordan. ");
INSERT INTO majNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nkjin ṉkjún xu̱ta̱ kitsjennkíhi̱ ko̱ yo̱ kits'ínnkihi̱ xu̱ta̱ xi uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","A̱s'a̱i j'aisehe̱ Jesu k'u̱a̱ já fariseo̱ tu̱ xi kikjut'ayák'uhu̱n ra̱. B'i̱ ts'ín kingjásjaiyaha̱: —¿A ka̱ma nku nda̱ chu̱ba̱ ts'i̱ínkjehé kju̱a̱bixaha̱n nga k'u̱éjña chju̱úhu̱n? ");
INSERT INTO majNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","B'i̱ kitsú Jesu: —¿A najmi kje̱hé n'eyo éhe̱n Nti̱a̱ná má nga tjít'a xi nkú ts'ín kits'ínnda Nti̱a̱ná xu̱ta̱ nga tuts'ihi̱n ni? B'a̱ ts'ín tjít'a: “Nku chju̱ún nku x'i̱n kits'ínnda.” ");
INSERT INTO majNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ko̱ tjít'a ya má nga b'a̱ ta̱ kitsú: “Kui kju̱a̱ha nga nku nda̱ k'u̱éjñaha na̱'mihi̱ ko̱ na̱aha̱ nga k'úéjñako̱ chju̱úhu̱n, ko̱ nga joo̱ nkuhú ku̱i̱chú ma.” ");
INSERT INTO majNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kui nga najmi ta̱ jo ma saha. Nku ní yjoninte i̱ncha maha. Kui b'a̱ maha, ni xi y'é'yúhun Nti̱a̱ná, najmi xu̱ta̱ kjéndáya. ");
INSERT INTO majNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","B'a̱ i̱ncha kitsú jóo̱: —Tu̱nga tsa b'a̱ ts'ín tíjña, ¿á b'a̱ ts'ín y'éjñaha Moise nga nku nda̱ ka̱ma kjésíntje̱hen nku xu̱ju̱n má nga ja títs'ínkje kju̱a̱bixaha̱n ko̱ b'a̱ ts'ín ka̱ma k'u̱éjñaha chju̱úhu̱n? ");
INSERT INTO majNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A̱s'a̱i b'i̱ kitsú Jesu: —A̱t'aha̱ ndjá ani̱ma̱nu̱u, kui kju̱a̱ha nga kits'ínj'o̱ho Moise nga ka̱ma k'úéjñahanu chju̱únnu̱u. Tu̱nga najmi b'a̱há ts'ín kis'ejña nga tuts'ihi̱n ni. ");
INSERT INTO majNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","An b'a̱ tíxinnu̱u. Tsa nku nda̱ k'u̱éjña chju̱úhu̱n, tsa chju̱úhu̱n najmi kik'at'aha̱, tsa a̱s'a̱i ku̱i̱xanko̱ kj'a̱í ta̱chju̱ún, kui xi tíbangane kju̱a̱bixan tjuhu̱n. Ko̱ tsa kj'a̱í nda̱ ku̱i̱xanko̱ ngáha ta̱chju̱ún xi y'éjñaha̱ x'i̱hi̱n, kui nda̱ xu'bo̱ xi ta̱ tíbangane ni xi 'mihi̱ kju̱a̱bixan. ");
INSERT INTO majNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A̱s'a̱i já ni'yakuyóo̱ b'a̱ i̱ncha kitsúhu̱ Jesu: —Tsa b'a̱ ts'ín tíjña nga̱t'aha̱ nda̱ xi tíjñaha̱ chju̱ún, tu̱ sahá nda tjín nga najmi ku̱i̱xaán. ");
INSERT INTO majNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","B'i̱ kitsú Jesu: —Najmi ngatentee̱ xu̱ta̱ mankjihi̱n ni xu'bi̱, nku tutuhú xi Nti̱a̱ná kitsjáha̱ nga ka̱mankjihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","A̱t'aha̱ tjín xu̱ta̱ xi b'a̱ ts'ín kitsin nga najmi ka̱ma ku̱i̱xan, ko̱ tjín ngá xi kin'e xanta tu̱ xi najmi ka̱ma ku̱i̱xahan. Ko̱ tjín ngá kj'a̱í xi ja y'éch'oho̱ yjoho̱ nga ku̱i̱xan tu̱ xi tu̱ nku Nti̱a̱náhá ts'i̱ínxát'aha̱ ra̱. Xi ka̱ma ts'i̱ínkjáíhi̱n ni xu'bi̱, kats'ínkjáíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","I̱ncha j'aiko̱ xu̱ta̱ ntíhi̱ tu̱ xi Jesu ngju̱énnehe̱ ra̱ ntsja ko̱ ku̱i̱nchja̱ntjaihi nginku̱n Nti̱a̱ná. Tu̱nga já ni'yakuyóo̱hó b'a̱ kitsúhu̱ xu̱ta̱ nga najmi b'a̱ i̱ncha ts'i̱ín. ");
INSERT INTO majNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","A̱s'a̱i b'i̱ kitsú Jesu: —Tjehe̱nntoho̱ jántíu̱ nga kanibásena. Najmi tu̱ jun b'ech'óho̱o. A̱t'aha̱ xu̱ta̱ xi b'a̱ ts'ín tjíntuyáha̱ xi nkú joyaha jántí xi̱, kui xi tje̱he̱n ra̱ nga Nti̱a̱ná ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kingjénne ntsja Jesu jántíu̱. A̱s'a̱i tsitju yo̱ nga ngji t'axín. ");
INSERT INTO majNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","J'aisehe̱ Jesu nku nda̱ ko̱ b'a̱ kitsúhu̱: —Ji nda̱ maestru̱, ¿mí ni nda xi tjíhin nga ts'ian tu̱ xi ka̱ma ts'inkjáíhi̱n ra̱ nga kúáte̱jña tík'un síán? ");
INSERT INTO majNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A̱s'a̱i b'i̱ kitsú Jesu: —¿Á ni xi nda tíchasjaiyahaní? Nku tutuhú maha xi nda. Tsa mjehi ku̱i̱tjás'e̱i̱n má nga ku̱i̱nchun tík'uin, n'e̱tjusuin ni xi tjít'a kju̱a̱téxumoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Má xi kui? —kitsú ndo̱. B'i̱ kitsú Jesu: —Najmi tu̱ n'ek'iein. Najmi tu̱ biyunéí kju̱a̱bixoo̱n. Najmi tu̱ ndyjé n'ei. Najmi tu̱ testiyu̱ tsank'á n'ei. ");
INSERT INTO majNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Cha̱nkjúín na̱'mihi̱ ko̱ na̱ahi̱. Ko̱ n'e̱tjóí xu̱ta̱ xinki̱ xi nkú ts'ín tjohi yjohi̱. ");
INSERT INTO majNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","B'a̱ kitsú nda̱tiu̱: —Santa nkúhu nga ndyjana títs'intjusan ngayjee̱ ni xu'bo̱. ¿Mí nihi xi ndyjat'á sana? ");
INSERT INTO majNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A̱s'a̱i b'i̱ kitsú Jesu: —Tsa mjehi nga ku̱i̱chú mai xi tjíhin nga ku̱i̱chú mai, t'ihi̱nteñai ni xi tjíhin ko̱ tjeihi̱n xu̱ta̱ x'a̱n. B'a̱ ts'ín s'e̱he ri kju̱a̱nchi̱ná ndji̱o̱jmi ján. A̱s'a̱i nibáí nga tsjénnkiní. ");
INSERT INTO majNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tu̱nga nk'iehé nga kint'é nda̱tiu̱ éi̱n, kik'ie nusin nusihi̱n nga ngji, a̱t'aha̱ 'yún ṉkjún nchi̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A̱s'a̱i b'a̱ kitsúhu̱ Jesu já ni'yaku'yáha̱: —Kju̱axi̱ ni xi tíxinnu̱u. 'Ni tjín tsa nku nda̱ nchi̱ná kju̱a̱s'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","B'a̱há ta̱ tíxin ngáha̱nu̱u nga tu̱ sahá najmi 'ni tjín tsa nku chu̱ camello̱ kju̱a̱s'en ti̱xa̱ha̱ nku nintu nga nku nda̱ nchi̱ná kju̱a̱s'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nk'ie nga kint'é já ni'yakuyóo̱ éi̱n, tu̱ ni xí kama nkjúhún ra̱ ko̱ b'a̱ i̱ncha kitsú: —¿Yá xi ka̱ma k'u̱a̱nki ni̱ ma? ");
INSERT INTO majNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A̱s'a̱i tsase'a Jesu jóo̱ ko̱ b'a̱ kitsúhu̱: —Xu̱ta̱ ndaha̱chí najmi ka̱maha̱ ts'i̱ínk'anki yjoho̱, tu̱nga Nti̱a̱ná maha̱ ts'ínk'anki xu̱ta̱. A̱t'aha̱ tu̱ mí nihí ni xi maha̱ ts'ín Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","A̱s'a̱i b'a̱ kitsú Pedro̱: —Xi nkúhu ji̱n, ja y'entu tentei̱ ni xi tjínni̱ ko̱ tje̱nnkihi̱ nd'a̱i̱. Kui kju̱a̱ha, ¿mí nihi xi sa̱kúhúni̱ ji̱n? ");
INSERT INTO majNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Nk'ie nga ku̱i̱chú ni̱stjin nga n'e̱ tse̱tse̱ ngayjee̱ ni xi tjín ko̱ nk'ie nga ku̱a̱kúchji Ntíhi̱ Nda̱x'i̱u̱n kju̱a̱chánkaha̱ nga k'úéjñasun a̱nte má nga ku̱a̱téxuma, kui ni̱stjiu̱n jun xi tje̱nko̱nú nd'a̱i̱ ta̱ ku̱i̱ntsu̱bo̱o a̱nte xi te jo maha nga ku̱a̱texumoho̱o ntje̱he̱ xu̱ta̱ Israel xi te jo tíkjá maha. ");
INSERT INTO majNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tu̱ yáhá ni xi nga̱t'ana̱ y'éjñaha ni'yaha̱, tsa já nts'e̱, tsa jminchjín nichja, tsa na̱'mihi̱, tsa na̱aha̱, tsa ntíhi̱ ko̱ tsa jñá xi tjíhi̱n, kui xu̱ta̱i̱ k'u̱a̱i̱ ngáha̱ ra̱ unchan ni̱yá tjíhin ni xi y'éjña ko̱ ts'i̱ínkjáíhi̱n nga k'úéntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nkjin xu̱ta̱ xi tjun nd'a̱i̱ tsjénnki, ko̱ nkjin xi yjanki nd'a̱i̱ xi tsjén títjun ka̱ma ngáha. ");
INSERT INTO majNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Xi nkú ts'ín batéxuma Nti̱a̱ná b'a̱ joyaha nku nda̱ xi tíjñaha̱ nku jñá. Kui xi ta̱ jyun tsitju nga ngjik'íéndako̱ já musu̱ tu̱ xi ngju̱a̱i̱ ts'ínxájihin a̱nte tuntsja̱jéhe̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nk'ie nga kits'ínj'o̱ já musu̱ nga ka̱ma chjíhi̱ nku to̱on denari̱o̱ nga nku ni̱stjin, a̱s'a̱i kits'ínkji jóo̱ a̱jin tuntsja̱jéhe̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A̱s'a̱i ta̱ ngjihí ngáha ndo̱, nkú ma nga chu̱ba̱ ñja, ko̱ kikie kj'a̱í já xi tíi̱ncha a̱jin na̱nti̱o̱ xi najmi tjíhi̱n xá. ");
INSERT INTO majNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","B'a̱ kitsúhu̱ jóo̱: “Tu̱ sahá tankín n'e̱xó ko̱ jun a̱jin tuntsja̱jéna̱ ko̱ nda tjín k'uechjínu̱u.” A̱s'a̱i ngji jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","’A̱s'a̱i ta̱ ngjihí ngáha ndo̱, nkú ma nga chu̱ba̱ te jo ko̱ nkú ma nga chu̱ba̱ jan, ko̱ b'a̱há ta̱ kits'ín ngáha. ");
INSERT INTO majNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ko̱ xi nkú ma nga chu̱ba̱ un nga ngixuu̱n ta̱ ngjihí ngáha ndo̱ ko̱ kisakú saha̱ kj'a̱í já xi najmi tjíhi̱n xá. “Jun, ¿á nku ni̱stjin kab'aha̱nu̱u e̱i̱ nga najmi tín'exáhanu?”, kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“A̱t'aha̱ najmi tjín xi títsjá xáni̱”, kitsú jóo̱. “Tu̱ sahá tankín n'e̱xó ko̱ jun a̱jin tuntsja̱jéna̱”, kitsú ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Nk'ie nga kama jyuu̱n, kinchja̱ko̱ nda̱ xi ts'e̱ tuntsja̱jée̱ nda̱ xi basehe̱ já musu̱ ko̱ b'a̱ kitsúhu̱: “Chu̱bañjaihi̱ já musu̱ ko̱ t'echjíhi̱ ni̱stjin xi kats'ínxá. Xi a̱skahan kafas'ee̱n ch'a̱tuts'i̱hi̱n ri̱, santaha nkúhu nga ku̱i̱chuk'uin xi tjun kafas'ee̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","’I̱ncha j'ai já musu̱ xi jas'en xi nkú ma nga chu̱ba̱ un ko̱ kits'ínkjáíhi̱n nku to̱on denari̱o̱ nga nkúnkú. ");
INSERT INTO majNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","A̱s'a̱i i̱ncha j'ai já musu̱ xi tjun jas'ee̱n ko̱ b'a̱ i̱ncha kitsú ani̱ma̱ha̱ nga ts'ati k'u̱a̱i̱hi̱, tu̱nga ta̱ nkuhú to̱on denari̱o̱ kits'ínkjáíhi̱n nga nkúnkú. ");
INSERT INTO majNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nk'ie nga kits'ínkjáíhi̱n niu̱, y'ésiko̱ nda̱ xi ts'e̱ tuntsja̱jée̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","B'a̱ kitsúhu̱: “Já xi a̱skahan kafas'ee̱n tu̱ nkuhú ora̱ kuats'ínxá sa. Tu̱nga tu̱ ngúsuhún kuan'ei nga kuak'iechjíhi̱ jóo̱ ko̱ ji̱n xi kan'e chúkju̱a̱i̱ xóo̱ ko̱ nubóo̱ nga nku ni̱stjin tantoo̱.” ");
INSERT INTO majNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","’Tu̱nga b'a̱há kitsú ndo̱ nga kinchja̱ko̱ nda̱ musu̱ xi b'a̱ títsuhu̱: “Ji nda̱ xinkjíán, najmi ch'on títs'inko̱ho. ¿A najmi nkuhú to̱on denari̱o̱ kab'endako̱ní? ");
INSERT INTO majNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chjúbéí to̱ohi̱n ko̱ t'in. Tu̱nga mjehéna tsjaha̱ já xi a̱skahan kafas'ee̱n xi nkú nga tjín ta̱ títsjaha. ");
INSERT INTO majNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿A najmi ka̱mahá ts'inka̱ ni xi tjínna xi nkú ts'ín mjena? ¿A ra̱ tíma xin tak'unní a̱t'aha̱ nda ani̱ma̱na̱?” ");
INSERT INTO majNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’B'a̱ ts'ín xi yjanki nd'a̱i̱ tjun ka̱ma ngáha. Ko̱ xi tjun nd'a̱i̱, kui xi tsjénnki. ");
INSERT INTO majNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nk'ie nga tje̱nya Jesu ni̱yá xi fi nanki Jerusalen, kinchja̱ t'axín subaha̱ já ni'yakuyá xi te joo̱ ko̱ b'a̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Tjenñju. Ja tíbankíaán nanki Jerusalen. Ja n'e̱kjas'en Ntíhi̱ Nda̱x'i̱u̱n a̱ya ntsja já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. Kui xi i̱ncha tsjá kju̱a̱ nga n'e̱k'ien ");
INSERT INTO majNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ko̱ a̱s'a̱i ts'i̱ínkjas'ehe̱n xu̱ta̱ xi najmi ntje̱ Israel tje̱he̱n ra̱, tu̱ xi i̱ncha ku̱a̱jnu̱kiehe̱ ra̱ ko̱ k'u̱éhe̱ ko̱ ngju̱át'a kruu̱hu̱. Tu̱nga ni̱stjin xi ma jahan kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","A̱s'a̱i j'ai na̱aha̱ jáha̱ Zebedeo̱ nga tje̱nko̱ ts'íhin jáha̱. Tsasinkúnch'int'aha̱ Jesu nga tsankihi̱ nku kju̱a̱nda. ");
INSERT INTO majNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","B'a̱ kitsú Jesu: —¿Mí nihi xi mjehi? B'i̱ kitsú ta̱chjúu̱n: —Tjenntei nga nku ntína̱ kat'ejña kixi̱hi̱ ko̱ nku xi kat'ejña skjúhi̱n nk'ie nga ku̱a̱texumai. ");
INSERT INTO majNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi yo ni xi tíbinchu. ¿A ku̱i̱chúkju̱a̱nu̱u nga un sku̱e̱nu̱u xi nkú ts'ín un sku̱e̱na? —Ku̱i̱chúkju̱a̱ni̱ —kitsú jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ nga un sku̱e̱nu̱u xi nkúhu an. Tu̱nga tsa ku̱i̱ntsu̱bo̱o nga kixi̱na̱ ko̱ tsa skjúnna̱, najmi an tíjñana nga tsja niu̱. Ja tjíntu̱hu̱ Na̱'mina̱ xi tíjña ndaha̱ kui a̱ntee̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nk'ie nga kint'é já ni'yakuyá xi tee̱ niu̱, i̱ncha kits'ínkjanko̱ já ni'yakuyá xi joo̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tu̱nga kinchja̱ ñjahá ra̱ Jesu jóo̱ ko̱ b'i̱ kitsúhu̱: —Yo xi nkú ts'ín xu̱ta̱ xi tjíhi̱n xá e̱i̱ a̱sunntei̱ 'yún ndjá ts'ínko̱ xu̱ta̱ xingisoo̱, ko̱ xi tjíhi̱n nga'yún ts'ín nga nu'yá'éhe̱n. ");
INSERT INTO majNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tu̱nga a̱jinnu̱u najmi b'a̱ ka̱ma. Xi mje níhi̱ nga nda̱ k'aku̱ ka̱ma a̱jinnu̱u, kui xi kats'ín ni xi nda ngandanu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Xi mjehe̱ nga tjun ka̱ma a̱jinnu̱u, kui xi katuma nda̱ musu̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","A̱t'aha̱ ta̱ ndaha Ntíhi̱ Nda̱x'i̱u̱n najmi j'ai tsa tu̱ xi kui nda n'e̱he̱ ra̱. J'ai ní tu̱ xi ni xi ngandaha̱ xu̱ta̱ j'ai ts'íhin ko̱ tu̱ xi ts'i̱ínkjas'ehen yjoho̱ nga k'u̱échjíntjai nkjin xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nk'ie nga tíi̱ncha bitju nanki Jerico Jesu ko̱ já ni'yakuyáha̱, nkjin ṉkjún xu̱ta̱ xi kitsjennkíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jo já ka̱ kab'entu a̱ndai ni̱yóo̱. Nk'ie nga kint'é nga yo̱ tíf'a Jesu, i̱ncha kikjintáya: —¡Ji xi ntje̱he̱ David, katuma ni̱ma̱hi ji̱n! ");
INSERT INTO majNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A̱s'a̱i xu̱ta̱ xi tjín yo̱ kinchja̱tiko̱ho̱ tu̱ xi k'u̱échja'aha ts'a. Tu̱nga tu̱ sahá 'yún i̱ncha kikjintáya sa: —¡Ji nda̱ maestru̱, ntje̱he̱ David, katuma ni̱ma̱hi ji̱n! ");
INSERT INTO majNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A̱s'a̱i tsasin'yún Jesu, kinchja̱ha̱ jóo̱ ko̱ b'a̱ kitsúhu̱: —¿Mí nihi xi mjenu̱u nga ts'innu̱u? ");
INSERT INTO majNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","B'a̱ kitsú jóo̱: —Ji nda̱ maestru̱, mjeni̱ nga ku̱i̱x'ánki tunkui̱n. ");
INSERT INTO majNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A̱s'a̱i Jesu kama ni̱ma̱ha̱ jóo̱ ko̱ kits'ínko̱ tunku̱n. Ta̱ kuihi chu̱bo̱ kama chjihi̱ ko̱ kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nk'ie nga ja tíi̱ncha bichú tiña nanki Jerusalen nga i̱ncha j'ai Betfage, nanki xi tiña maha̱ a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱, a̱s'a̱i kits'ínkji Jesu jo já ni'yakuyáha̱ ");
INSERT INTO majNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nga b'i̱ kitsúhu̱: —Tankíún nanki i̱chí xi tíjña tiña ján. Yo̱ sa̱kúnu̱u nku búrrú xi tjít'a'yúnko̱ ntí búrrúhu̱. Chjúndáyo ko̱ nibáko̱nú e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tsa tjín xi nkú ku̱i̱tsu̱nu̱u, b'a̱ t'ihu̱un: “Nda̱ maestru̱ rú machjéhe̱n chu̱. A̱s'a̱i rú ts'i̱ínk'óya ngáha.” ");
INSERT INTO majNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","B'a̱ kama tu̱ xi tsitjusuhun éhe̱n Nti̱a̱ná xi kinchja̱ nda̱ profeta̱ nga b'a̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","B'a̱ t'ihu̱un xu̱ta̱ xi tjín Sion: “Cha̱so̱o, ja nibásenu̱u Nda̱ rei̱nu̱u. Kui xi ni̱ma̱kju̱a̱, nku búrrú tjísun, nku ntí búrrú, ntíhi̱ chu̱ xi b'anji ch'á.” ");
INSERT INTO majNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A̱s'a̱i ngji ts'íntjusun já ni'yakuyóo̱ ni xi kitsú Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","I̱ncha j'aiko̱ búrrúu̱ ko̱ ntí búrrúu̱. Najyuhu̱n i̱ncha kingjásuhu̱n ko̱ Jesu y'esúhu̱n chu̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nkjin ṉkjún xu̱ta̱ i̱ncha kingjántu najyuhu̱n a̱ya ni̱yóo̱, ko̱ kj'a̱í ngá xi tjiaha̱ yá i̱ncha tsatet'a ko̱ kingjántu a̱ya ni̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","'Yún i̱ncha kikjintáya xu̱ta̱ nkjin xi yja títjuu̱n ko̱ xi yjankiu̱ nga b'i̱ i̱ncha kitsú: —¡Kats'ínk'ankiná xi ntje̱he̱ David! ¡Nti̱a̱ná nda kats'ínko̱ xi kits'ín nibá ngajoho̱! ¡Kats'ínk'ankiná xi tíjña nk'a ján! ");
INSERT INTO majNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nk'ie nga jas'en Jesu nanki Jerusalen, kama nkjúhu̱n ngayjee̱ xu̱ta̱ na̱nti̱o̱ ko̱ b'a̱ i̱ncha kitsú: —¿Yá nda̱ha xu'bi̱? ");
INSERT INTO majNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","B'a̱ i̱ncha kitsú xu̱ta̱ xi tje̱nko̱ Jesu: —Nda̱ profeta̱ Jesuu̱hú niu̱ xi nibáha Nazaret, nanki xi tíjñajihi̱n a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","A̱s'a̱i jas'en Jesu má ma na̱tsihi̱n ni̱nku̱. Kik'onsje ngayjee̱ já xi tíi̱ncha batéña ko̱ xi tíi̱ncha b'atse chu̱ yo̱. Kits'ínk'ótsjá yámixa̱ha̱ já xi tíi̱ncha ts'ínk'óntjaiya to̱on ko̱ yáxile̱he̱ já xi tíi̱ncha batéña chu̱tuju. ");
INSERT INTO majNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","B'i̱ kitsúhu̱: —B'a̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “B'a̱ k'úíhi̱n ni'yana̱ nga kui xi ka̱ma ni'ya xi má nga xu̱ta̱ ku̱i̱nchja̱ko̱ Nti̱a̱ná.” Tu̱nga jun a̱ntehe̱ já ndyjé tín'e mo. ");
INSERT INTO majNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A̱s'a̱i i̱ncha j'ai xu̱ta̱ ka̱ ko̱ xi najmi ma fi nga j'aisehe̱ Jesu má ma na̱tsihi̱n ni̱nku̱ ko̱ Jesu kits'ínnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tu̱nga já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ i̱ncha kama kjaha̱n, nk'ie nga kikie kju̱a̱nkjún xi títs'ín Jesu ko̱ nga kint'é nta̱ha̱ jántí xi̱ xi tíi̱ncha nchja̱ na̱tsihi̱n ni̱nku̱ nga b'a̱ tíi̱ncha tsu: “¡Kas'ehe̱ kju̱a̱chánka xi ntje̱he̱ David!” ");
INSERT INTO majNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","B'a̱ i̱ncha kitsúhu̱ Jesu: —¿A tínu'yáí ni xi tíi̱ncha tsu jántí xi̱u̱? B'i̱ kitsú Jesu: —Joho̱n, tínt'e. ¿A najmi kje̱hé n'eyo xu̱ju̱n éhe̱n Nti̱a̱ná má nga tjít'a niu̱? B'i̱ ts'ín tjít'a: Ts'a jántí xi̱u̱ ko̱ xi baki kin'echjéín nga 'yún nda kin'etsjohi. ");
INSERT INTO majNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A̱s'a̱i Jesu ngji t'axíhi̱n xu̱to̱. Nanki Betani̱a̱ ngji. Yo̱ kits'ínkj'a ni̱stje̱n. ");
INSERT INTO majNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nk'ie nga ta̱ jyuu̱n nga tífi ngáha Jesu nanki Jerusalen, kama bjoho̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ngjisehe̱ nku yá higuera̱ xi kikie a̱ndai ni̱yóo̱, tu̱nga ndahá nku tu najmi kisakúhu̱, tu̱ subahá xka̱. B'i̱ kitsúhu̱ yóo̱: —Ndaha̱chí najmi ta̱ kas'ehe ri tu. Tu̱ tje̱n'yún kixíhí yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nk'ie nga kikie já ni'yakuyóo̱ ni xi kamoo̱, kama nkjúhu̱n ko̱ b'a̱ kitsúhu̱ Jesu: —¿Nkú tjíhi̱n ra̱ nga tje̱n'yún kuaxíhí ni yá higuera̱? ");
INSERT INTO majNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Tsa s'ejinnu̱u Nti̱a̱ná ko̱ najmi jo jan ka̱manu̱u, najmi tu̱ suba ni xi kuats'ihi̱n yá higuera̱ ka̱manu̱u n'o̱o. Ta̱ ka̱ma b'a̱ ku̱i̱xíhu̱un a̱sunntu tje̱nki̱ xu'bi̱: “Ti̱yú xin yo̱ ko̱ chja̱níkj'ajin yjohi̱ a̱jin ntáchak'uu̱n”, ko̱ b'a̱ ka̱ma. ");
INSERT INTO majNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ko̱ ngatentee̱ ni xi ku̱i̱nchíhu̱u Nti̱a̱ná nga chu̱bako̱o, n'e̱kjóho̱on tsa s'ejinnu̱u Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jas'en Jesu má ma na̱tsihi̱n ni̱nku̱ ko̱ tsakúya. A̱s'a̱i j'aik'úhu̱n já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá ko̱ b'a̱ i̱ncha kitsúhu̱: —¿Mí xá xi tjíhin nga b'a̱ tín'ei? ¿Yá xi kitsjá xáhi? ");
INSERT INTO majNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","B'i̱ kitsú Jesu: —Ko̱ an ta̱ kuasjáíyanu̱u nku ni. Tsa k'úínyanú, xínyanu̱u mí xáha xi tjínna nga b'a̱ títs'ian. ");
INSERT INTO majNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Yá xi kits'ín nibáha̱ Jua Bautista̱ nga j'aiténtá xu̱ta̱? ¿A Nti̱a̱ná, a ra̱ xu̱ta̱ a̱sunntei̱hí? A̱s'a̱i b'i̱ kitsúhu̱ xinkjín jóo̱ nga kinchja̱ni̱jmíyaha niu̱: —Tsa: “Nti̱a̱ná kits'ín nibáha̱ Jua”, ku̱i̱xíaán, a̱s'a̱i b'a̱ ku̱i̱tsu̱ná: “¿Á najmi kis'ejihi̱nnu̱u ni xi kitsúhu Jua?” ");
INSERT INTO majNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ta̱ najmi ka̱ma tsa: “Xu̱ta̱ a̱sunntei̱ kits'ín nibáha̱”, ku̱i̱xíaán, a̱t'aha̱ ngayjee̱ xu̱ta̱ b'a̱ tsu nga nku nda̱ profeta̱ kama Jua. Najmi ka̱ma b'a̱ ku̱i̱xíaán a̱t'aha̱ binkjaán xu̱ta̱ na̱nti̱o̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kui nga a̱s'a̱i b'a̱ i̱ncha kitsúhu̱ ra̱ Jesu: —Najmi yai̱. A̱s'a̱i b'i̱ kitsú Jesu: —Ko̱ ta̱ ndaha an najmi xínyanu̱u yá xi kitsjána nga b'i̱ títs'ian. ");
INSERT INTO majNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","A̱s'a̱i b'a̱ kitsú sa Jesu: —Nkú ma ni xínyanu̱u. ¿Nkú bixíún? Nku nda̱ tjíntuhu̱ jo já. Ngjisehe̱ nda̱ xi tjuu̱n ko̱ b'a̱ kitsúhu̱: “Ji ntína̱, t'in n'e̱xájin tuntsja̱jéna̱ nd'a̱i̱.” ");
INSERT INTO majNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Najmi mjena kfíán”, kitsú ntíhi̱ ndo̱, tu̱nga a̱skahán ni kits'ínnkjink'un ko̱ ngji ts'ínxá. ");
INSERT INTO majNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A̱s'a̱i ngjisehe̱ nda̱ xinkuu̱ ko̱ b'a̱ ta̱ kitsúhu̱. “Jo̱'o̱ho, na̱'mi”, kitsú nda̱ xu'bi̱, tu̱nga najmi ngjihí. ");
INSERT INTO majNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Má xi kui já xi joo̱ kits'ín ni xi mjehe̱ na̱'mihi̱? —Nda̱ xi tjuu̱n —kitsú jóo̱. A̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ ko̱ jminchjín skóo̱ títjun kju̱a̱s'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","A̱t'aha̱ j'aisenu̱u Jua ko̱ tsakúyanu̱u ni xi na̱xu̱ nginku̱n Nti̱a̱ná, tu̱nga najmi kin'e s'ejinnú ni xi kitsú. Tu̱ sahá já xi f'áchjíntjai ch'á ko̱ jminchjín skóo̱ xi kis'ejihi̱n. Ko̱ máha jun, ndaha tsa kiyo niu̱, tu̱nga najmi tsankinchj'ahá ru̱u ani̱ma̱nu̱u tsa kis'ejinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Tjenñju ma ngó. K'u̱e̱jñá chu̱ba̱ya manu̱u. Nku nda̱ nchi̱ná y'éntje̱ tuntsja̱jé, y'éngi nch'á ko̱ kits'ínnda nku a̱nte má nga ts'íónnki tuntsja̱jée̱. Kits'ínnda nku xjó nk'a tu̱ xi ka̱ma chúnntaha a̱ntee̱. Kitsjá sáha̱ a̱ntee̱ já xi maha̱ ts'ínxáko̱ tuntsja̱jée̱, a̱s'a̱i ngji kjin. ");
INSERT INTO majNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nk'ie nga ja tíjne tuu̱, a̱s'a̱i kits'ínkjisehe̱ ndo̱ já musu̱hu̱ já xi títs'ínxáko̱ tuntsja̱jée̱ tu̱ xi ku̱a̱nkihi̱ ra̱ tu xi kanéhe̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tu̱nga jakj'áhá jóo̱ já musu̱hu̱ ndo̱. Nku xi kits'ín'uhu̱n, nku xi kits'ínk'ien, ko̱ nku xi y'éhe̱ ndji̱o̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","A̱s'a̱i ta̱ kits'ínkjihí ngáha ndo̱ nkjin já musu̱, tu̱nga b'a̱há ta̱ kits'ín ngáha̱ ra̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Tu̱ chahán kits'ínkji ntíhi̱ ndo̱ nga b'i̱ kitsú: “Sku̱e̱nkjún ntína̱ jóo̱.” ");
INSERT INTO majNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tu̱nga nk'iehé nga kikie já xi ts'ínxáko̱ tuntsja̱jée̱ nga nibá ntíhi̱ ndo̱, b'a̱ kitsúhu̱ xinkjín: “Kui xu'bo̱ xi ts'i̱ínkjáíhi̱n ngayjee̱ ni xi tjíhi̱n na̱'mihi̱. Tu̱ sahá n'e̱k'ieén tu̱ xi ka̱ma ts'a̱ñáhaná ni xi ts'i̱ínkjáíhi̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","A̱s'a̱i jakj'á jóo̱ ntíhi̱ ndo̱, kik'onsje na̱tsin má nga tjíntje̱ tuntsja̱jée̱ ko̱ kits'ínk'ien. ");
INSERT INTO majNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kui b'a̱ maha, nk'ie nga kj'u̱a̱í nda̱ xi ts'e̱ tuntsja̱jée̱, ¿mí nihi xi kj'u̱a̱í ts'íhi̱n já musu̱ xu'bo̱? ");
INSERT INTO majNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","B'a̱ i̱ncha kitsú jóo̱: —Ts'i̱ínkje nga najmi ka̱ma ni̱ma̱ha̱ já ch'onk'un xu'bo̱ ko̱ kj'a̱í já tsjá sá ngáha̱ ra̱ a̱nte tuntsja̱jée̱, já xi k'u̱échjíhi̱ tuhu̱ nk'ie nga ku̱i̱chú cha̱ha̱n. ");
INSERT INTO majNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","A̱s'a̱i b'i̱ kitsú Jesu: —¿A najmi kje̱hé n'eyo ni xu'bi̱ xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná? B'a̱ títsu: Ndji̱o̱ xi kikjaníya já chji̱ne̱xjóo̱ ja j'ai ma ndji̱o̱ k'aku̱. Nti̱a̱ná xi b'a̱ kits'ín ko̱ ma nkjúnná nga chasehe̱é. ");
INSERT INTO majNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kui kju̱a̱ha nga b'a̱ tíxihi̱nnu̱u. Chjú'anu̱u nga ku̱i̱ntsu̱ba̱jiun nga Nti̱a̱ná xi ku̱a̱téxumanu̱u, ko̱ xu̱ta̱ xi bakúchji nga Nti̱a̱ná xi batéxumaha̱, kui xi kj'u̱a̱i̱hi̱ nga kju̱a̱s'enjin yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ndji̱o̱ xi títsu éhe̱n Nti̱a̱ná nga kikjaníya já chji̱ne̱xjóo̱, tu̱ yáhá ni xi ku̱i̱jne̱sun ndji̱o̱ ka̱ma xi̱xi̱. Ko̱ xi ku̱i̱jne̱nehe̱ ndji̱o̱ ka̱ma nku̱a̱n nku̱a̱n. ");
INSERT INTO majNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nk'ie nga kint'é já na̱'mi k'aku̱ ko̱ já fariseo̱ éi̱n, i̱ncha kamankjihi̱n nga kui tínchja̱ni̱jmíyaha Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mjehe̱ nga ku̱a̱kj'ánijé tu̱nga i̱ncha kitsankjúhún xu̱ta̱ nkjiu̱n, a̱t'aha̱ b'a̱ i̱ncha tsu xu̱to̱ nga nku nda̱ profeta̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A̱s'a̱i ta̱ kinchja̱há ngáha Jesu nga y'éjña chu̱ba̱ya. B'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Xi nkú ts'ín batéxuma Nti̱a̱ná b'a̱ joyaha nku nda̱ rei̱ xi ts'asje nku s'í nk'ie nga tsixan ntíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kits'ínkji já musu̱hu̱ nga ku̱i̱nchja̱ha̱ xu̱ta̱ xi kitsúya títjuhu̱n. Tu̱nga najmi kits'ín yuhú xu̱to̱ nga kj'u̱a̱í s'íu̱. ");
INSERT INTO majNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A̱s'a̱i ta̱ kits'ínkjihí ngáha kj'a̱í já musu̱ nga b'a̱ kitsúhu̱: “B'a̱ t'ihu̱un xu̱ta̱ xi ja kixinyaha̱ nga ja kab'endá nichinee̱. Ja kats'ink'íén turu̱. Ja tjínda ngatentee̱ niu̱. T'inyoho̱o nga kanibá s'í kju̱a̱bixoo̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","’Tu̱nga najmi nkjún kamaha̱ xu̱ta̱ xi kik'inyaha̱. Nku xi ngjisehe̱ jñáha̱, kj'a̱í xi ngjik'atseya ni. ");
INSERT INTO majNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tjín ngá xi jakj'ánijé já musu̱hu̱ nda̱ rei̱, kits'ín'uhu̱n ko̱ kits'ínk'ien. ");
INSERT INTO majNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nk'ie nga kint'é nda̱ rei̱ ni xi kamoo̱, kama kjaha̱n. Kits'ínkji já juhu̱n nga kits'ínk'ien xu̱ta̱ xi b'a̱ kits'íu̱n ko̱ y'éti nankihi̱. ");
INSERT INTO majNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","’A̱s'a̱i b'a̱ kitsú nda̱ rei̱ nga kinchja̱ko̱ já musu̱hu̱: “Ja tjínda s'í kju̱a̱bixoo̱n, tu̱nga najmi chumi ni chjíhí ra̱ xu̱ta̱ xi tjun kixinyaha̱ nga kj'u̱a̱í. ");
INSERT INTO majNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kui b'a̱ maha, tankíhinnu ni̱yátée̱ ko̱ tu̱ yáhá ni xi sa̱kúnu̱u t'inyoho̱o nga kanibá s'í kju̱a̱bixoo̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A̱s'a̱i tsitju já musu̱ nga ngji ni̱yátée̱. Kinchja̱ ñja tentehe̱ xi kisakúhu̱, ndaha tsa xi ch'onk'uhu̱n ko̱ ndaha tsa xi nda tjíntuyáha̱. Kitsehe xu̱ta̱ má tje̱n s'í kju̱a̱bixoo̱n. ");
INSERT INTO majNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Nk'ie nga jas'en nda̱ rei̱ nga j'aisehe̱ xu̱ta̱ xi kab'entut'á yámixo̱, kikie yo̱ nku nda̱ xi najmi yja najyun xi bja xu̱ta̱ nga fi s'í kju̱a̱bixan. ");
INSERT INTO majNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A̱s'a̱i b'i̱ kitsúhu̱: “Ji nda̱ xinkjíán, ¿nkú ts'ín kabitjas'e̱henni e̱i̱ nga najmi tjíhin ri najyun xi ts'e̱ s'í kju̱a̱bixan?” Tu̱nga najmi kinchja̱há ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","A̱s'a̱i kinchja̱ha̱ nda̱ rei̱ já xi títsjá nichinee̱ ko̱ b'a̱ kitsúhu̱: “T'e'yún sjai ko̱ ntsja ndo̱ ko̱ chja̱nikj'o na̱tsin ján má jyuu̱n, a̱nte xi má kji̱ntá xu̱ta̱ ko̱ ku̱a̱te ni̱'yu̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","A̱t'aha̱ nkjin maha xi tíchubaha̱, tu̱nga tu̱ chubahá maha xi kj'u̱a̱íjin. ");
INSERT INTO majNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","A̱s'a̱i ngjik'íéndako̱ xinkjín já fariseo̱ tu̱ xi ts'i̱ínkijneyaha Jesu nku én xi najmi b'a̱ tjín. ");
INSERT INTO majNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","I̱ncha kits'ínkjisehe̱ Jesu já ni'yakuyá xi ts'e̱ ko̱ já xi yjankihi̱ nda̱ rei̱ Herode̱ Antipa̱. B'a̱ i̱ncha j'ai tsúhu̱: —Ji nda̱ maestru̱, yai̱ nga kju̱axi̱ én xi chubai ko̱ nga na̱xu̱ bakuyáí sisin ni xi ts'e̱ Nti̱a̱ná. Najmi ni xi sasíhi̱n xu̱ta̱ chubai. 'Yún na̱nka̱ chaseihi̱. ");
INSERT INTO majNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kui nga t'inyaha̱ni̱. ¿A ma b'echjíhi̱í nda̱ títjun Cesa̱r ni xi f'áchjíná, a ra̱ najmi? ");
INSERT INTO majNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tu̱nga behé Jesu nga tu̱ xi títsuhu jóo̱ ko̱ b'i̱ kitsúhu̱: —¡Jun xi tu̱ tsjohónu̱u nga bakuchjíú xi nkú ts'ín yankjún Nti̱a̱ná! ¿Á an tíchjut'ayák'uhunnú? ");
INSERT INTO majNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ta̱kúnnú nku to̱on xi ma chjíntjaihi ch'á. J'aiko̱ jóo̱ nku to̱on denari̱o̱. ");
INSERT INTO majNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ko̱ b'i̱ kitsú Jesu: —¿Yá xi ts'e̱ sénni̱stjii̱n ko̱ j'áín xi tjít'aha̱ to̱oi̱n? ");
INSERT INTO majNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A̱s'a̱i b'a̱ kitsú jóo̱: —Ts'e̱ nda̱ títjun Cesa̱r. A̱s'a̱i b'i̱ kitsú Jesu: —Tjoho̱on nda̱ títjun Cesa̱r ni xi ts'e̱ nda̱ títjun Cesa̱r, ko̱ tjoho̱on Nti̱a̱ná ni xi ts'e̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nk'ie nga kint'é jóo̱ niu̱, tu̱ ni xí kama nkjúhún ra̱ ko̱ i̱ncha ngji t'axín. ");
INSERT INTO majNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Já saduseo̱ bakúya nga najmi kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱. Kui ni̱stjin xu'bo̱ k'u̱a̱ xi i̱ncha j'aisehe̱ Jesu nga b'i̱ i̱ncha kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ji nda̱ maestru̱, b'a̱ kitsú Moise nk'ie: “Tsa tjín xi ku̱a̱yá nga najmi s'e̱he̱ ntí, nda̱ nts'e̱ tjíhin nga ku̱i̱xanko̱ ngáha chju̱úhu̱n, tu̱ xi b'a̱ ts'ín s'e̱he̱ ra̱ ntí nda̱ nts'e̱ xi k'ie̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Y'entujinni̱ yatu já xi nts'e̱ maha xinkjín. Tsixan nda̱ xi tjuu̱n tu̱nga b'a̱há tjíu̱n k'ien. Najmi kis'ehe̱ ntí. K'ien x'i̱hi̱n tachjúu̱n. A̱s'a̱i nda̱ nts'e̱ y'ejñako̱ ngáha ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tu̱nga ta̱ k'iehén ngáha nda̱ nts'e̱ xi ma joho, a̱s'a̱i xi ma jahan, ko̱ santaha nda̱ xi yatuu̱. ");
INSERT INTO majNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A̱skahan ta̱ k'ien ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","’Kui b'a̱ maha, ni̱stjin nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱, ¿má xi kui já xi yatuu̱ ka̱ma ts'e̱ ta̱chjúu̱n, a̱t'aha̱ ngatentee̱ y'entuko̱? ");
INSERT INTO majNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi b'a̱ tjín ni xi chubo, a̱t'aha̱ najmi mankjinnu̱u ni xi tjít'a éhe̱n Nti̱a̱ná ko̱ ta̱ ndaha nga'yúhu̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A̱t'aha̱ nk'ie nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱, najmi ta̱ ku̱i̱xahan ko̱ ta̱ ndaha najmi ts'i̱ínkixan ntíhí. B'a̱ ní ts'ín k'úéntu xi nkú ts'ín tjíntu ntítsje xi tjín ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tu̱nga nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱, ¿a najmi kje̱hé n'eyo ni xi títsunu̱u éhe̱n Nti̱a̱ná? B'a̱ kitsú Nti̱a̱ná: ");
INSERT INTO majNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“An xi Nti̱a̱ha̱ Abraham, Nti̱a̱ha̱ Isaac ko̱ Nti̱a̱ha̱ Jacob.” Nti̱a̱ná najmi Nti̱a̱ha̱ ani̱ma̱. Nti̱a̱ha̱ ní xu̱ta̱ tík'un. ");
INSERT INTO majNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nk'ie nga kint'é xu̱ta̱ niu̱, tu̱ ni xí kama nkjúhún ra̱ nga̱t'a ts'e̱ ni xi bakúya Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kama ñjakúko̱ xinkjín já fariseo̱ nk'ie nga kint'é nga Jesu kits'ínkinchá jyujyu já saduseo̱. ");
INSERT INTO majNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","A̱s'a̱i nku nda̱ chji̱ne̱'én xi ts'e̱, nku nda̱ maestru̱hu̱ kju̱a̱téxumoo̱, kingjásjaiyaha̱ Jesu nga kikjut'ayák'un: ");
INSERT INTO majNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ji nda̱ maestru̱, a̱jihi̱n ngayjee̱ kju̱a̱téxumoo̱, ¿má kju̱a̱téxumaha xi 'yún chjíhi̱ ra̱? ");
INSERT INTO majNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","A̱s'a̱i b'i̱ kitsú Jesu: —“N'e̱tjóí Nti̱a̱ná xi Nti̱a̱hi̱ maha ngayjee̱ ani̱ma̱hi̱. N'e̱tjóí xi nkú ts'ín tinchin ko̱ xi nkú ts'ín n'enkjíntak'uin.” ");
INSERT INTO majNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kui kju̱a̱téxuma xu'bi̱ xi 'yún chjíhi̱ ra̱ ko̱ kui xi tjun. ");
INSERT INTO majNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ko̱ b'a̱há ta̱ tjín ngáha kju̱a̱téxuma xi ma joho: “N'e̱tjóí xu̱ta̱hi̱ xi nkú nga ts'ín tjohi yjohi̱.” ");
INSERT INTO majNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nga joo̱ kju̱a̱téxuma xu'bi̱ y'aha̱ ra̱ ngatentee̱ ni xi tjít'a xu̱ju̱n kju̱a̱téxumoo̱ ko̱ xi y'ét'a já profeta̱. ");
INSERT INTO majNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nk'ie nga kabincha sa yo̱ já fariseo̱, a̱s'a̱i b'i̱ kitsú Jesu: ");
INSERT INTO majNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Nkú bixíún nga̱t'a ts'e̱ xi Cristo̱? ¿Má nibáha̱ ntje̱he̱? B'a̱ kitsú jóo̱: —Ntje̱he̱ David. ");
INSERT INTO majNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","A̱s'a̱i b'i̱ kitsú Jesu: —¿Nkú tjíhi̱n ra̱ nga b'a̱ kitsúhu David nga Nda̱ Nti̱a̱ha̱ maha xi Cristo̱? A̱t'aha̱ b'a̱ kitsú nk'ie nga Espiri̱tu̱ Santo̱ho̱ Nti̱a̱ná kits'ínkinchja̱ha̱: ");
INSERT INTO majNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nti̱a̱ná b'a̱ kitsúhu̱ Nda̱ Nti̱a̱na̱: “Ti̱nchint'ání má batexuma, k'uentú maná já kontra̱hi̱ kinte tsu̱kui.” ");
INSERT INTO majNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tsa David b'a̱ kitsú nga xi Cristo̱ xi Nda̱ Nti̱a̱ha̱, ¿nkú ts'ín ntje̱he̱ David nibáha̱ ra̱ xi Cristo̱? ");
INSERT INTO majNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ndaha nku najmi kamaha̱ kits'ínk'óyaha̱ Jesu tsa tu̱ nku én. Kui ni̱stjiu̱n kich'atuts'i̱hi̱n nga najmi ta̱ ch'a kama k'un kingjásjaiyaha̱ ra̱ Jesu tsa mí nihi. ");
INSERT INTO majNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","A̱s'a̱i kinchja̱ko̱ Jesu xu̱ta̱ ko̱ já ni'yakuyáha̱ nga b'i̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱, kui xi tíjñaha̱ nga ku̱i̱tsu̱ya nkú tjíhi̱n ra̱ kju̱a̱téxumaha̱ Moise. ");
INSERT INTO majNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kui b'a̱ maha, n'e̱tjusuhunnu ngatentee̱ ni xi ku̱i̱tsu̱hu̱nu̱u ko̱ chj'a̱tjó. Tu̱nga najmi tu̱ n'enú ni xi i̱ncha ts'ín, a̱t'aha̱ najmi ts'íntjusun ni xi nchja̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kui xi b'énehe̱ ni xi áí xu̱ta̱, tu̱nga máha kui, ndaha̱chí najmi i̱ncha ts'ín nga'yún nga ts'i̱íntjusun niu̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","’'Yún mjehe̱ nga sku̱e̱he̱ xu̱ta̱ xi nkú ts'ín benkjún Nti̱a̱ná. Kui nga 'yún i ts'íhin kaxa̱ tíntí xi b'entut'áá stjeén ko̱ tjianá, xi tíi̱nchaha̱ éhe̱n Nti̱a̱ná, ko̱ 'yún ts'ín ndju nachjún xi yjandáíhi̱ najyun xi mjéntjai nga nchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tsjoho̱ nga b'entu a̱nte k'aku̱ xi tjín nku s'í ko̱ nga b'entusún yáxile̱ xi tíi̱ncha títjun ni'ya sinagoga̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tsjoho̱ nga tsjo ts'ín súniñaha̱ ni̱yátée̱ ko̱ nga maestru̱ k'úíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Najmi tu̱ n'ej'o̱o tsa maestru̱ ku̱i̱tsu̱nu̱u xu̱ta̱, a̱t'aha̱ nkuhú ma nda̱ maestru̱nu̱u ko̱ ngatentoo̱ jun nts'o mahanu xinki̱u. ");
INSERT INTO majNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Najmi tu̱ ch'a na̱'mi 'mihu̱u e̱i̱ a̱sunntei̱, a̱t'aha̱ nkuhú ma Na̱'minu̱u, kui xi tíjña ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Najmi tu̱ n'ej'o̱o tsa já nti̱a̱ ku̱i̱tsu̱nu̱u xu̱ta̱, a̱t'aha̱ nkuhú ma xi ts'e̱nu̱u, kui xi Cristo̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Xi mjehe̱ cha̱nkjún a̱jinnu̱u tjíhin nga nda ts'i̱ín ngandaha̱ xingisoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Xi k'u̱a̱sjenk'a suba yjoho̱, kui xi i̱chí ka̱ma nginku̱n Nti̱a̱ná. Xi k'u̱a̱sje ni̱ma̱kju̱a̱ yjoho̱, kui xi sa̱kúhu̱ kju̱a̱chánka. ");
INSERT INTO majNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ni̱ma̱ rú n'ehenu jun, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱! ¡Jun xi tu̱ tsjohónu̱u bakuchjíú xi nkú ts'ín yankjún Nti̱a̱ná! Najmi 'ba̱i̱nto nga xu̱ta̱ kju̱a̱s'enjin nga Nti̱a̱ná ku̱a̱téxumaha̱. Ta̱ ndaha jun najmi bitjas'o̱on ko̱ ta̱ ndaha najmi 'ba̱i̱ntoho̱o xu̱ta̱ xi mjehe̱ kju̱a̱s'en yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ni̱ma̱ rú n'ehenu jun, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱! ¡Jun xi tu̱ tsjohónu̱u bakuchjíú xi nkú ts'ín yankjún Nti̱a̱ná! Chju'óho̱o ni'yaha̱ jminchjín xi ja k'ien x'i̱hi̱n ko̱ a̱s'a̱i chu̱ba̱ 'yúhún tse chu̱bako̱o Nti̱a̱ná tu̱ xi b'é'mat'aihinnu yjonu̱u. Kui nga 'yún un sku̱e̱he̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ni̱ma̱ rú n'ehenu jun, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱! ¡Jun xi tu̱ tsjohónu̱u bakuchjíú xi nkú ts'ín yankjún Nti̱a̱ná! Fenu̱u nga binimo nga ngúsuhu̱n a̱sunntee̱ ko̱ ntáchak'uu̱n nga binchisjó xu̱ta̱ xi n'e̱ mo nga ts'i̱ín s'ejin xi nkú ts'ín s'ejinnu̱u. Ko̱ nk'ie nga ja sakúnu̱u nku, a̱s'a̱i n'o nga kui xi 'yún ts'ín sa ni xi ts'e̱ nda̱nindoo̱ nga jun. ");
INSERT INTO majNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ni̱ma̱ rú n'ehenu jun, já ka̱ xi baku ni̱yóho̱o xu̱ta̱! Jun xi b'a̱ bixíún: “Tsa tjín xi nkú ku̱i̱tsu̱, tsa a̱s'a̱i ni̱nku̱ tsúngijin, najmi tjíhi̱n kju̱a̱'yún nga ts'i̱íntjusun. Tu̱nga xi tsúngijin to̱onsine xi tíjñaya ni̱nku̱, kuihí xi tjíhin nga ts'i̱íntjusun ni xi ku̱i̱tsu̱.” ");
INSERT INTO majNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Jun xi já chi̱ni ko̱ já ka̱. ¿Má xi 'yún chánka sa? ¿A to̱onsinee̱, a ra̱ ni̱nku̱hú xi títs'ín nga je to̱onsinee̱ nginku̱n Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","’Ko̱ b'a̱ bixíún yo: “Tsa tjín xi nkú ku̱i̱tsu̱, tsa a̱s'a̱i na̱chan chje̱ tsúngijin, kui xi najmi tjíhi̱n kju̱a̱'yún nga ts'i̱íntjusun. Tu̱nga xi tsúngijin chje̱ xi tíjñasun na̱chan chje̱, kuihí xi tjíhin nga ts'i̱íntjusun ni xi ku̱i̱tsu̱.” ");
INSERT INTO majNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Jun já ka̱. ¿Má xi 'yún chánka sa? ¿A chje̱, a ra̱ na̱chan chje̱hé xi títs'ín nga je chje̱ nginkun Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kui b'a̱ maha, tsa tjín xi nkú ku̱i̱tsu̱hu, tsa a̱s'a̱i na̱chan chje̱ tsúngijin, kui xi ja títsungijin na̱chan chje̱ ko̱ ngayjee̱ ni xi tjíntusún yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tsa tjín xi nkú ku̱i̱tsu̱, tsa a̱s'a̱i ni̱nku̱ tsúngijin, ja títsungijin ni̱nku̱ ko̱ Nti̱a̱ná xi tíjña yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tsa tjín xi nkú ku̱i̱tsu̱, tsa a̱s'a̱i ndji̱o̱jmi ján tsúngijin, ja títsungijin Nti̱a̱ná xi tíjña yo̱ nga tíbatéxuma. ");
INSERT INTO majNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ni̱ma rú n'ehenu jun, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱! ¡Jun xi tu̱ tsjohónu̱u bakuchjíú xi nkú ts'ín yankjún Nti̱a̱ná! 'Bo̱ho̱o Nti̱a̱ná nku tíkjá na̱jún chi̱nko̱ ko̱ xka̱ sinjne̱ xingisoo̱ xi nkú ts'ín tjít'a kju̱a̱téxumoo̱, tu̱nga n'echayanú ni xi 'yún chánka sa xi ta̱ bakúya kju̱a̱téxumoo̱. N'echayo ni xi na̱xu̱ nginku̱n Nti̱a̱ná ko̱ nga tjíhin nga ka̱ma ni̱ma̱nu̱u xu̱ta̱ xi kj'a̱í ko̱ nga tjíhin nga na̱xu̱ s'e̱jinnu̱u éhe̱n Nti̱a̱ná. Kuihí ni xi joo̱n xi tjíhin nga n'o̱o, ko̱ najmi tjíhin nga n'e̱chayo nga n'o̱o ni xingisoo̱ xi tjít'a. ");
INSERT INTO majNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Jun já ka̱ xi baku ni̱yóho̱o xu̱ta̱! N'etjusun ni xi tu̱ tje̱nt'ahá ko̱ ni xi 'yún chjíhi̱ ra̱ najmi n'esiuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ni̱ma̱ rú n'ehenu jun, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱! ¡Jun xi tu̱ tsjohónu̱u bakuchjíú xi nkú ts'ín yankjún Nti̱a̱ná! Jun xi nkú joyaha tasa̱ ko̱ ta̱ba̱ xi tu̱ na̱tsihi̱n ní kin'echuhu̱n, tu̱nga kitsejíhín ni ani̱ma̱nu̱u ndyjé ko̱ ni xi najmi na̱xu̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ji nda̱ fariseo̱ ka̱, títjun n'e̱chihi̱n a̱yaha̱ taso̱ ko̱ b'a̱ ts'ín ka̱ma jehe na̱tsihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ni̱ma̱ rú n'ehenu jun, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱! ¡Jun xi tu̱ tsjohónu̱u bakuchjíú xi nkú ts'ín yankjún Nti̱a̱ná! Jun xi b'a̱ joyaha tsjó xi taba kin'ek'i. Kui xi tsjo ts'ín bakú sunnk'a, tu̱nga a̱yaha̱ kitsehe nintaha̱ ani̱ma̱ ko̱ ngatentee̱ ni chu̱ntí. ");
INSERT INTO majNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jun xi b'a̱ ta̱ k'un sunnk'o, a̱t'aha̱ nginku̱n xu̱ta̱ 'yún je bakuchíú yjonu̱u, tu̱nga a̱jin ani̱ma̱nu̱u kitsejíhin ni xi tu̱ b'ana̱cha̱ha ko̱ ngatitsun. ");
INSERT INTO majNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ni̱ma̱ rú n'ehenu jun, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱! ¡Jun xi tu̱ tsjohónu̱u bakuchjíú xi nkú ts'ín yankjún Nti̱a̱ná! N'endo tsjóho̱ já profeta̱ ko̱ n'enaxú ndji̱o̱ tsjóho̱ xu̱ta̱ je xi kis'e ni̱stjin nk'ie. ");
INSERT INTO majNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ko̱ b'a̱ bixíún: “Tsa tu̱ ñá ma ti̱ntsu̱ba̱á nk'ie nga y'entu ntje̱ cháná, najmi tsisinko̱ ra̱á nga kits'ínk'ien já profeta̱.” ");
INSERT INTO majNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nk'ie nga b'a̱ bixíún, ta̱ juhun n'ek'io yjonu̱u nga ntje̱he̱ xu̱ta̱ xi kits'ínk'ien já profeta̱ jun. ");
INSERT INTO majNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Tu̱ sahá n'e̱ndju̱ú ni xi kik'atuts'i̱n ntje̱ chánu̱u! ");
INSERT INTO majNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Jun xi b'a̱ k'un xi nkúhu ntje̱nu̱u! ¡Já ch'onk'un xi b'a̱ k'un! ¿Nkú ts'ín ku̱i̱tjunkihinu nga najmi kuankíún nga̱k'i̱e̱n? ");
INSERT INTO majNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kui b'a̱ maha, an ts'inkjísenu̱u já profeta̱ ko̱ já nkjink'un ko̱ já chji̱ne̱'én. K'u̱a̱ xi n'e̱k'ion ko̱ kjúát'a kruu̱ ko̱ k'u̱a̱ xi ngjúóho̱o a̱ya ni'ya sinagoga̱nu̱u ko̱ tsjénnkí'uncho xki̱ nanki. ");
INSERT INTO majNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","B'a̱ ts'ín ch'a̱njihinu ngayjee̱ jníhi̱ xu̱ta̱ je xi kin'ek'ien. Ch'a̱tuts'i̱hi̱n ra̱ jníhi̱ Abel, nda̱ je xi y'ejña nk'ie, nga santaha jníhi̱ Zacaria̱ ntíhi̱ Berekia̱ xi kin'ek'ient'ó na̱chan chje̱ xi kjijña a̱nkjín ni̱nku̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kju̱axi̱ ni xi tíxinnu̱u. Ngatentee̱ ni xu'bi̱ ni̱banehe̱ xu̱ta̱ xi tjín nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jun xu̱ta̱ Jerusalen, xi n'ek'ion já profeta̱ ko̱ b'oho̱o ndji̱o̱ xu̱ta̱ xi n'e nibásenu̱u! ¡A tu̱ nkjihín ni̱yá kama mjena nga k'uentúkúnu̱u xi nkú ts'ín xa̱nto̱ nga b'énkinka̱ ntíhí, tu̱nga najmi kin'e yunú! ");
INSERT INTO majNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nd'a̱i̱ ni̱ ma, ja s'e̱jña masen a̱ntenu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","An b'a̱ tíxinnu̱u nga najmi ta̱ cha̱hanú santa nkúhu nga ku̱i̱chú ni̱stjin nga b'a̱ ku̱i̱xíún: “Kakjanínk'a Nti̱a̱ná xi nibáha ngajoho̱.” ");
INSERT INTO majNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tsitjusje Jesu má ma na̱tsihi̱n ni̱nku̱ ko̱ nk'ie nga ja tífi, j'aik'úhu̱n já ni'yakuyáha̱. Tíi̱ncha ma nkjúhu̱n nga tíbasenkjúhu̱n xjóho̱ ni̱nku̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","B'i̱ kitsú Jesu: —¿A tíyo ngayjee̱ ni xi tjín e̱i̱? Kju̱axi̱ ni xi tíxinnu̱u. Ndaha nku ndji̱o̱ najmi ta̱ s'e̱jñasuhu̱n ra̱ xinkjín. Ngayjee̱ n'e̱xúya. ");
INSERT INTO majNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nk'ie nga kab'ejña Jesu a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱, já ni'yakuyáha̱ j'ai nchja̱ko̱ t'axíhi̱n. B'a̱ i̱ncha kitsúhu̱: —T'inyani̱, ¿nkjé b'a̱ ka̱ma? ¿Mí ni xi ku̱a̱kúchji títjun nk'ie nga kjúái̱ ngáhani ko̱ nga kfe̱ a̱sunntee̱? ");
INSERT INTO majNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A̱s'a̱i kinchja̱ Jesu: —Chúhu̱un yjonu̱u nga najmi tu̱ ch'a xi k'u̱a̱na̱cha̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","A̱t'aha̱ nkjin maha xi kj'u̱a̱í nga an ts'i̱ín ma yjoho̱. “An xi kits'ín nibána Nti̱a̱ná”, ku̱i̱tsu̱ ko̱ nkjin xu̱ta̱ k'u̱a̱na̱cha̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","’Ku̱i̱nú'yó nga s'e̱ kju̱a̱chán ko̱ nga ku̱i̱nchja̱ni̱jmíyaha xu̱ta̱ kju̱a̱chán xi tíma, tu̱nga najmi tu̱ binkjunnú. A̱t'aha̱ tjíhin ni nga b'a̱ ka̱ma, tu̱nga najmi kje̱hé kfe̱ a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","A̱t'aha̱ xu̱ta̱ xi tjín nku nanki kja̱ánko̱ xu̱ta̱ xi kj'a̱í nanki. Nku nda̱ rei̱ kja̱ánko̱ kj'a̱í nda̱ rei̱. S'e̱ kjintíá ko̱ chón ka̱ma kj'a̱í kj'a̱í nanki. ");
INSERT INTO majNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nk'ie nga ja b'a̱ tíma, a̱s'a̱ihí tíb'atuts'i̱hi̱n kju̱a̱ni̱ma̱ xi s'e̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ts'i̱ínkjas'ennu̱u xu̱ta̱ xi má nga ts'i̱ín'unnu̱u ko̱ ts'i̱ínk'iennu̱u. Nga̱t'ana̱ ts'i̱ín unkiehe̱nu̱u ngayjee̱ xu̱ta̱ a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kui ni̱stjiu̱n nkjin xi ts'i̱ínndyja̱ha̱ yjoho̱ nga najmi ta̱ s'e̱jihi̱n ra̱ an. Ts'i̱ínkjas'en xinkjín ko̱ ts'i̱ín unkie xinkjín. ");
INSERT INTO majNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","S'e̱ ṉkjún já profeta̱ tsank'á xi nkjin xu̱ta̱ k'u̱a̱na̱cha̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tu̱ xí s'ehé ni xi ch'onk'un, kui nga nkjin ṉkjún xi najmi ta̱ ts'i̱íntjoho xinkjín. ");
INSERT INTO majNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tu̱nga xi ndjá ku̱a̱si̱njña santa nkúhu nga ku̱a̱yá, kui xi k'u̱a̱nki. ");
INSERT INTO majNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","S'e̱ni̱jmí én nda tsuhu̱ Nti̱a̱ná nga ngúsuhu̱n a̱sunntee̱, én nda tsu xi tsuya xi nkú ts'ín batéxuma Nti̱a̱ná. Ngayjehe̱ a̱sunntee̱ ku̱i̱nt'é nga Nti̱a̱ná xi batéxuma. Nk'iehé nga kfe̱ a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Y'ét'a nda̱ profeta̱ Daniel nk'ie nga najmi cha̱nkjún a̱nte tsjehe̱ ni̱nku̱. Cho̱o xi b'a̱ ts'i̱íu̱n. B'i̱ kitsú Jesu ko̱ xi títs'ínya xu̱ju̱i̱n katumankjihi̱n. B'i̱ ta̱ kitsú ya: ");
INSERT INTO majNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","—Kui ni̱stjiu̱n katanka xu̱ta̱ xi tjíntu a̱nte Judea̱ xi tje̱hen a̱sunntu tje̱nnki̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Xi kab'ejñasun nk'a ni'yaha̱ najmi tu̱ ku̱i̱tjujen nga kj'u̱a̱ík'asje ni xi tjíntu a̱ya ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Xi kafi jñá najmi tu̱ k'o̱óya nga kj'u̱a̱íkj'á najyuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","’¡Ni̱ma̱ rú ts'íhin jminchjín xi y'a ntí ko̱ xi títs'ínki ntí kui ni̱stjiu̱n! ");
INSERT INTO majNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ti̱nchíhu̱u Nti̱a̱ná tu̱ xi najmi ni̱stjin chu̱nch'án ku̱i̱yúhunu ko̱ tsa ni̱stjin nkjún. ");
INSERT INTO majNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","A̱t'aha̱ 'yún s'e̱ kju̱a̱ni̱ma̱ kui ni̱stjiu̱n, kju̱a̱ni̱ma̱ xi najmi kje̱e s'e santa nkúhu nga tuts'ihi̱n ni nga kamanda a̱sunntee̱. Ko̱ ta̱ ndaha najmi s'e̱ a̱skahan nku xi b'a̱ joyaha. ");
INSERT INTO majNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tsa najmi ku̱a̱tekjá Nti̱a̱ná chuba ni̱stjin xu'bo̱, nda ra̱ nku najmi k'u̱a̱nki kai. Tu̱nga ku̱a̱tekjáhá Nti̱a̱ná chuba ni̱stjin xu'bo̱ ngandaha̱ xu̱ta̱ xi j'ájin. ");
INSERT INTO majNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Kui ni̱stjiu̱n tsa tjín xi b'a̱ ku̱i̱tsu̱nu̱u: “Cha̱so̱o, e̱i̱ tíjña xi kits'ín nibá Nti̱a̱ná”, ko̱ tsa b'a̱ ku̱i̱tsu̱nu̱u: “Ján tíjña”, najmi tu̱ n'e s'ejiun. ");
INSERT INTO majNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","A̱t'aha̱ i̱ncha kj'u̱a̱í xi b'a̱ ku̱i̱tsu̱ tsank'á nga kui xi j'ai ngajoho̱ Nti̱a̱ná ko̱ xi já profeta̱ ts'i̱ín ma tsank'á yjoho̱. Kui xi i̱ncha ts'i̱ín nkjin tíkjá kju̱a̱nkjún ko̱ ni xi chánka, tu̱ xi k'u̱a̱na̱cha̱ha̱ ra̱ xu̱ta̱, xí ko̱hó ra̱ xu̱ta̱ xi j'ájin Nti̱a̱ná ka̱maha̱ ra̱ k'u̱a̱na̱cha̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jahá tíxinya títjunnu̱u ni xi ka̱ma. ");
INSERT INTO majNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","’Kui b'a̱ maha, tsa b'a̱ ku̱i̱tsu̱nu̱u jóo̱: “A̱nte kixi ján tíjña xi j'ai ngajoho̱ Nti̱a̱ná”, najmi tu̱ bankíún yo̱. Tsa b'a̱ ku̱i̱tsu̱nu̱u: “A̱ya 'ma ján tíjña”, najmi tu̱ n'e s'ejiun. ");
INSERT INTO majNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","A̱t'aha̱ xi nkú ma nga bat'ai nd'ích'o̱n má tju ts'íu̱ ko̱ ma chji santaha má fintjai, b'a̱ ta̱ ka̱ma nk'ie nga kj'u̱a̱í Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yaha̱ nga má kjijña nku yjoninte k'ien, yo̱ ma ñjakú chálíkíe̱. B'a̱ ta̱ ts'ín cha̱ha̱ nga kj'u̱a̱í Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’A̱skahan nga ja kj'u̱a̱ kju̱a̱ni̱ma̱ xi ka̱ma kui ni̱stjiu̱n, tje̱n'yún ka̱ma jyuhún ts'íu̱, ko̱ sóo̱ najmi ta̱ ts'i̱ín ndzjehen. Niñu xi tjín nk'a ján ku̱i̱xu̱ntu, ko̱ k'u̱a̱tsé ni xi tjín nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","A̱s'a̱i ka̱ma chji nk'a ján ni xi ku̱a̱kúchji nga ja nibá Ntíhi̱ Nda̱x'i̱u̱n. Nk'iehé kji̱nta nkjún ngayje tíkjá xu̱ta̱ xi tjín a̱sunntei̱ ko̱ sku̱e̱ Ntíhi̱ Nda̱x'i̱u̱n nga tje̱njin ni̱nti̱ nga nibáko̱ ngayjee̱ nga'yúhu̱n ko̱ kju̱a̱chánkaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ts'i̱ínkji ntítsjehe̱ nk'ie nga 'yún kju̱a̱ne̱ tjio̱. I̱ncha k'u̱éntukú xu̱ta̱ xi j'ájin xi tjíntu tu̱ má xi tje̱hén ni, b'aha̱ ra̱ má tju ts'íu̱ santaha má fintjai. ");
INSERT INTO majNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Katumankjinnu̱u ni xi b'éjña chjinu̱u yá higuera̱. Nk'ie nga ja tju nts'én tjiaha̱ yóo̱ ko̱ tjuhu̱ xka̱, yo nga ja tíbichú tiña chu̱nubóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","B'a̱ ta̱ ts'ín nk'ie nga ja cho̱o nga ja b'a̱ tíma, katumankjinnu̱u nga ja tje̱n tiña Ntíhi̱ Nda̱x'i̱u̱n xi nkúhu tsa a̱sti a̱nkju̱o̱ síjña. ");
INSERT INTO majNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kju̱axi̱ ni xi tíxinnu̱u. Ku̱i̱tjusun ngayjee̱ ni xu'bi̱ kintehe̱ ni nga ku̱a̱yáyje xu̱ta̱ xi tjín nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ka̱maha̱ a̱sunntee̱ ko̱ nk'a ján ndyja̱, tu̱nga énna̱ najmi kj'u̱a̱ tiya. ");
INSERT INTO majNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Tu̱nga má ni̱stjin ko̱ chu̱ba̱ nga b'a̱ ka̱moo̱, najmi ch'a xi behe̱, ta̱ ndaha ntítsje xi tjín ndji̱o̱jmi ján ko̱ ta̱ ndaha Ntíhi̱ Nti̱a̱ná. Nku tutuhú Nti̱a̱ Na̱'miná xi be. ");
INSERT INTO majNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Xi nkú kama ni̱stjin nga y'ejña Noe, b'a̱ ta̱ ka̱ma nk'ie nga kj'u̱a̱í ngáha Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kui ni̱stjin xu'bo̱, nk'ie nga najmi kje̱e fejin ntá xu̱ta̱, tu̱ tíi̱ncha kjinehé ko̱ tíi̱ncha 'bi. Tíi̱ncha bixan ko̱ tíi̱ncha ts'ínkixan ntíhí. B'a̱ tíi̱ncha ts'ín santa nkúhu nga tsichu ni̱stjin nga jas'en Noe tsutsu chánkoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Najmi kamankjihi̱n xu̱ta̱ santaha nkúhu nga tu̱ ni xí kik'ahá ts'í ko̱ kits'ínkje tentehe̱. B'a̱há ta̱ ka̱ma ngáha nk'ie nga kj'u̱a̱í Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kui ni̱stjiu̱n jo já xi tíi̱ncha ts'ínxájin jñáha̱, nku chjúbé ko̱ xinkuu̱ s'e̱jña. ");
INSERT INTO majNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jo jminchjín xi tíi̱ncha o, nku xi chjúbé ko̱ xinkuu̱ xi s'e̱jña. ");
INSERT INTO majNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Kui b'a̱ maha, ti̱ntsu̱ba̱ ndahanu, a̱t'aha̱ najmi yo mí chu̱ba̱ha kj'u̱a̱í Nda̱ Nti̱a̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Katumankjinnu̱u ni xu'bi̱. Tsa be títjun nda̱ xi ts'e̱ ni'yoo̱ mí chu̱ba̱ha nga jyuu̱n kj'u̱a̱í nda̱ ndyjée̱, ta̱ k'úéjña nda. Najmi tsjánte tsa nda̱ ndyjée̱ kju̱a̱s'en kju̱a̱'yún ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kui kju̱a̱ha, b'a̱ ts'ín ti̱ntsu̱ba̱ ndahanu ko̱ jun, a̱t'aha̱ chu̱ba̱ nga najmi tíchuyóho̱o kj'u̱a̱í Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Yá nda̱ musu̱hu xi na̱xu̱ fiko̱ xáha̱ ko̱ xi nkjink'un, xi nda̱ nti̱a̱ha̱ kitsjá xáha̱ nga kui xi tsjáha̱ nichine já musu̱ xingisoo̱ nk'ie nga ku̱i̱chú chu̱ba̱? ");
INSERT INTO majNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","¡Á b'a̱ nda tjíhin ts'e̱ nda̱ musu̱ xu'bi̱ tsa b'a̱ títs'ín nk'ie nga kj'u̱a̱í nda̱ nti̱a̱ha̱! ");
INSERT INTO majNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kju̱axi̱ ni xi tíxinnu̱u. Nda̱ nti̱a̱ha̱ ts'i̱ín kunntáha̱ ngayjee̱ ni xi tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","’Tu̱nga tsa ch'onk'un nda̱ musu̱ ko̱ tsa b'i̱ ts'ín ts'i̱ínnkjink'un: “K'u̱a̱ndaya saha̱ nda̱ nti̱a̱na̱ nga kj'u̱a̱í.” ");
INSERT INTO majNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","A̱s'a̱i k'u̱éhe̱ já musu̱ xinkjín ko̱ nga kji̱ne̱ ko̱ k'úíko̱ já ch'i̱u̱. ");
INSERT INTO majNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tsa tu̱ kj'u̱a̱íhí nda̱ nti̱a̱ha̱ nda̱ musu̱ xu'bi̱ ni̱stjin xi najmi tíkuyáha̱ ko̱ chu̱ba̱ xi najmi be, ");
INSERT INTO majNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","'yún ndjá ts'i̱ínnijéhe̱ nda̱ nti̱a̱ha̱ xi nkú ts'ín n'enijéhe̱ já xi b'ana̱cha̱ha̱ já nti̱a̱, yo̱ má nga kji̱ntá ko̱ ku̱a̱te ni̱'yu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Kui ni̱stjiu̱n b'a̱ ka̱ma a̱jihi̱n xi nkú ts'ín batéxuma Nti̱a̱ná xi nkú kamat'ain te i̱stinchjín xi ngji nku s'í kju̱a̱bixan. I̱ncha jakj'á nd'í seti̱hi̱ ko̱ i̱ncha ngji ts'ínkjáíhi̱n nda̱ bixoo̱n. ");
INSERT INTO majNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Un maha xi chi̱nihi̱ ko̱ un maha xi kitikju̱a̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Xi chi̱niu̱ najmi kik'a sa seti̱ nk'ie nga jakj'á nd'íhi̱ nga i̱ncha ngji. ");
INSERT INTO majNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tu̱nga xi kitikju̱o̱, jakj'á nd'íhi̱ ko̱ ta̱ kik'a nisa seti̱ xi ku̱i̱nchá saha̱ nd'íhi̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","’A̱s'a̱i ts'andayaha̱ nda̱ bixoo̱n ko̱ kama nijñáha̱ i̱stinchjíu̱n, kui nga i̱ncha kikjantuféhe. ");
INSERT INTO majNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nkú ra̱ ma nga masen ni̱stje̱n, tjín xi kikjintáya: “¡Ja nibá nda̱ bixoo̱n! ¡Ti̱tjusjo̱o ko̱ tankín n'e̱kjóho̱on!” ");
INSERT INTO majNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","’Tsisitje̱n i̱stinchjíu̱n ko̱ y'énda nd'í seti̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","B'a̱ kitsúhu̱ xi chi̱niu̱ xi kitikju̱o̱: “K'u̱a̱i̱ni̱ i̱chí chuba seti̱nu̱u, a̱t'aha̱ ja tí'me nd'íni̱.” ");
INSERT INTO majNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tu̱nga b'a̱há kitsú xi kitikju̱o̱: “Najmi, a̱t'aha̱ tsa b'a̱ n'e̱i̱, najmi ku̱i̱chú maha̱ni̱ ji̱n ko̱ ta̱ ndaha jun. Tu̱ sahá tankín ch'a̱tso xi ts'a̱jun má satéña.” ");
INSERT INTO majNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nk'ie nga tíi̱ncha fik'atse seti̱ xi chi̱niu̱, tu̱ j'ai sahá nda̱ bixoo̱n. Xi tjíndaha̱ yjoho̱ i̱ncha jas'enko̱ má tíma s'í kju̱a̱bixoo̱n ko̱ kis'echjá a̱nkju̱o̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","A̱s'a̱i j'ai i̱stinchjín xingisoo̱ ko̱ b'a̱ kitsú: “¡Ji chá nti̱a̱, chá nti̱a̱, chúx'áni̱ a̱nkju̱o̱!” ");
INSERT INTO majNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tu̱nga b'a̱há kitsú nda̱ bixoo̱n: “Kju̱axi̱ ni xi tíxinnu̱u nga najmi benu̱u.” ");
INSERT INTO majNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Kui b'a̱ maha, ti̱ntsu̱ba̱ ndahanu, a̱t'aha̱ najmi yo mí ni̱stjin ko̱ mí chu̱ba̱ha nga kj'u̱a̱í Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Xi nkú ts'ín batéxuma Nti̱a̱ná b'a̱ joyaha nku nda̱ xi ngjitsube kj'a̱í nanki. Kintehe̱ ni nga ngju̱a̱i̱, tjun kinchja̱ha̱ já musu̱hu̱ ko̱ kitsjáha̱ ni xi tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nku xi kitsjáha̱ un mii̱ to̱onsine, nku xi kitsjáha̱ jo mii̱, ko̱ nku xi kitsjáha̱ nku mii̱. Kitsjáha̱ nga nkúnkú xi nkú ts'ín ka̱maha̱ nga ts'i̱ínxáko̱ to̱oo̱n. A̱s'a̱i ngji kjin. ");
INSERT INTO majNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","’Nda̱ musu̱ xi kits'ínkjáíhi̱n un mii̱ to̱onsine, ngji ts'ínxáko̱ ko̱ kits'ín ngana̱sun sa un mii̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Xi kits'ínkjáíhi̱n jo mii̱, b'a̱ ta̱ kits'ín ko̱ kits'ín ngana̱sun sa jo mii̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tu̱nga máha xi kits'ínkjáíhi̱n nku mii̱, kui xi ngji kján t'anankiu̱ ko̱ y'éyanji to̱oho̱n nda̱ nti̱a̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Nk'ie nga j'a nkjin ni̱stjin, j'ai ngáha nda̱ nti̱a̱ha̱ já musu̱ xu'bo̱ ko̱ kits'ínko̱ho̱ kuenta̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tjun j'ai xi kits'ínkjáíhi̱n un mii̱ to̱onsine. Kui xi y'a sa un mii̱. B'a̱ kitsú: “Ji nda̱ nti̱a̱, un mii̱ to̱onsine kik'a̱i̱ní. E̱i̱ tíjña sahi un mii̱ xi kits'in ngana̱san.” ");
INSERT INTO majNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A̱s'a̱i b'a̱ kitsú nda̱ nti̱a̱ha̱: “Nda tjín. Nda ní ji, nda̱ musu̱. Na̱xu̱ 'miko̱i̱ xáhi̱. Na̱xu̱ kin'etjusuin xá i̱chí xi kitsjaha. Kui nga nd'a̱i̱ 'yún tse ni xi ts'in kunntáhara. Nibái̱ ko̱ tsjo kat'ehi xi nkúhu nda̱ nti̱a̱hi̱.” ");
INSERT INTO majNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’A̱s'a̱i j'ai xi kits'ínkjáíhi̱n jo mii̱ to̱onsine. Kui xi y'a sa jo mii̱. B'a̱ kitsú: “Ji nda̱ nti̱a̱, jo mii̱ to̱onsine kik'a̱i̱ní. E̱i̱ tíjña sahi jo mii̱ xi kits'in ngana̱san.” ");
INSERT INTO majNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A̱s'a̱i b'a̱ kitsú nda̱ nti̱a̱ha̱: “Nda tjín. Nda ní ji, nda̱ musu̱. Na̱xu̱ 'miko̱i̱ xáhi̱. Na̱xu̱ kin'etjusuin xá i̱chí xi kitsjaha. Kui nga nd'a̱i̱ 'yún tse ni xi ts'in kunntáhara. Nibái̱ ko̱ tsjo kat'ehi xi nkúhu nda̱ nti̱a̱hi̱.” ");
INSERT INTO majNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’A̱s'a̱i j'ai xi kits'ínkjáíhi̱n nku mii̱ to̱onsine ko̱ b'a̱ kitsú: “Ji nda̱ nti̱a̱, be nga kjain. Chjusíntje̱i̱n cha̱n xi najmi ji y'entje̱i̱. Ni xi kj'a̱í xi y'entje̱ ji chubéí. ");
INSERT INTO majNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kui nga kitsankjuhunna ko̱ ngjik'iejñá 'ma to̱ohi̱n t'anankiu̱. E̱i̱ tíjña ngáha ri to̱ohi̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A̱s'a̱i kinchja̱ nda̱ nti̱a̱ha̱ nga b'a̱ kitsúhu̱: “Ji nda̱ musu̱ ch'onk'un ko̱ ts'e. Tsa yai nga kjesíntje̱n cha̱n xi najmi an y'entje̱ ko̱ bakj'á ni xi kj'a̱í xi y'entje̱, ");
INSERT INTO majNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","tsa kik'a̱i̱hi̱ to̱onna̱ já xi maha̱ ts'ínxáko̱. Tsa b'a̱ kin'ei, ja ra̱ ts'inkjáín ngáha̱ ra̱ nd'a̱i̱ nga kjúa̱ to̱onna̱ ko̱ santaha ntíhi̱ kai.” ");
INSERT INTO majNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","’A̱s'a̱i b'a̱ kitsúhu̱ ndo̱ já xi kabincha yo̱: “Chjú'oho̱o ndo̱ to̱oo̱n ko̱ tjoho̱on xi tíjñaha̱ te mii̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","A̱t'aha̱ ngatentee̱ xi tjíhi̱n ni, kui xi k'u̱a̱i̱ saha̱ ko̱ 'yún s'e̱he̱. Tu̱nga xi najmi tjíhi̱n, kui xi chjú'aha̱ santaha ni xi i̱chí xi tíjñaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chja̱nikj'o na̱tsin ján má jyuu̱n nda̱ musu̱ xu'bi̱ xi najmi chumi ni chjíhi̱ ra̱, a̱nte má nga kji̱ntá xu̱ta̱ ko̱ ku̱a̱te ni̱'yu̱n.” ");
INSERT INTO majNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Nk'ie nga kj'u̱a̱i̱hí Ntíhi̱ Nda̱x'i̱u̱n, kj'u̱a̱íko̱ kju̱a̱chánkaha̱ ko̱ ngatentee̱ ntítsjehe̱ ko̱ k'úéjñasun a̱nte má nga ku̱a̱kúchji kju̱a̱chánkaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ngayjee̱ xu̱ta̱ xi tjín a̱sunntee̱ ka̱ma ñjakú nginku̱n. A̱s'a̱i ku̱a̱kjánya xu̱ta̱ xi nkú joyaha nku nda̱ bastu xi ts'ínkj'a t'axín chu̱tsa̱nko̱ ko̱ xin ts'ínkj'a chu̱tentsu̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kixi̱hi̱ k'u̱éntu chu̱tsa̱nko̱ ko̱ skjúhu̱n k'u̱éntu chu̱tentsu̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’A̱s'a̱i ku̱i̱nchja̱ Nda̱ Rei̱ nga b'a̱ ku̱i̱tsu̱hu̱ xi tíi̱ncha nga kixi̱hi̱: “Nibó jun xi nda kits'ínko̱nu̱u Na̱'mina̱. N'e̱kjóho̱on nd'a̱i̱ nga ti̱tjás'e̱njiun xi nkú ts'ín batéxuma Na̱'mina̱, kui niu̱ xi kis'endanu̱u nkúhu nga tuts'ihi̱n ni nga kamanda a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","A̱t'aha̱ nk'ie nga kama bjona, kik'a̱i̱nú nichine. Nga kama xintána, kik'a̱i̱nú ntá. Nga kikjatsú'ba̱san nankinu̱u, kik'a̱i̱ntenú ni'yanu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nga najmi tjínna najyun, kik'a̱i̱nú najyun xi kingja. Nga kisaté ch'an, tsankintsubek'unnú. Ko̱ nga kikjáa̱ya'yán, tsankinsekjánú.” ");
INSERT INTO majNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’A̱s'a̱i i̱ncha ku̱i̱nchja̱ xu̱ta̱ xi na̱xu̱ kits'ín nginku̱n Nti̱a̱ná nga b'a̱ ku̱i̱tsu̱: “Ji Nda̱ Nti̱a̱, ¿nkjé kiyai̱ nga kama bjohi ko̱ kik'a̱i̱hi̱ nichine, ko̱ tsa kama xintáhi ko̱ kik'a̱i̱hi̱ ntá? ");
INSERT INTO majNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Nkjé kiyai̱ nga nankini̱ kitsutjasúín ko̱ kik'a̱i̱ntei̱hi̱ ni'yani̱, ko̱ tsa najmi tjíhin najyun ko̱ kik'a̱i̱hi̱ najyun xi kindyjai? ");
INSERT INTO majNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Nkjé kiyai̱ nga kisaté ch'in ko̱ tsa kisuya'yín ko̱ tsankintsubek'úíhi̱n?” ");
INSERT INTO majNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A̱s'a̱i ku̱i̱nchja̱ ngáha Nda̱ Rei̱ nga b'a̱ ku̱i̱tsu̱: “Kju̱axi̱ ni xi tíxinnu̱u. Xi nkú ts'ín nda kin'oho̱o tu̱ má xi kuihí ni já nts'é, a̱ ahán xi b'a̱ kin'enú, ndaha tsa xi 'yún kinte tje̱n nga chasehe̱.” ");
INSERT INTO majNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’A̱s'a̱i b'a̱ ku̱i̱tsu̱ ngáha̱ xu̱ta̱ xi tíi̱ncha skjúhu̱n: “Ti̱yú xinnú jun xi najmi nda nginkán. Tankíún a̱jin nd'í xi najmi ta̱ maha̱ ra̱ 'meyaha, xi kis'endaha̱ nda̱nindoo̱ ko̱ ntítsje xi tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","A̱t'aha̱ nk'ie nga kama bjona, najmi kik'a̱i̱nú nichine. Nga kama xintána, najmi kik'a̱i̱nú ntá. ");
INSERT INTO majNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nga kikjatsú'ba̱san nankinu̱u, najmi kik'a̱i̱ntenú ni'yanu̱u. Nga najmi tjínna najyun, najmi kik'a̱i̱nú najyun xi kingja. Ko̱ nga kiseté ch'an ko̱ kikjáa̱ya'yán, najmi tsankintsubek'unnú.” ");
INSERT INTO majNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’A̱s'a̱i i̱ncha ku̱i̱nchja̱ xu̱ta̱ xu'bo̱ nga b'a̱ ku̱i̱tsu̱: “Ji Nda̱ Nti̱a̱, ¿nkjé kiyai̱ nga kama bjohi, ko̱ tsa kama xintáhi, ko̱ tsa nankini̱ kitsutjasúín, ko̱ tsa najmi tjíhin najyun, ko̱ tsa kisete ch'in, ko̱ tsa kisuya'yúín, ko̱ najmi tsisinko̱i̱hi̱?” ");
INSERT INTO majNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","A̱s'a̱i ku̱i̱nchja̱ ngáha Nda̱ Rei̱ nga b'a̱ ku̱i̱tsu̱: “Kju̱axi̱ ni xi tíxinnu̱u. Xi nkú ts'ín najmi nda kin'oho̱o tu̱ má xi kuihí ni já nts'é, a̱ ahán najmi nda kin'enú, ndaha tsa xi 'yún kinte tje̱n nga chasehe̱.” ");
INSERT INTO majNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","’Ko̱ xu̱ta̱ xu'bo̱ ngju̱a̱i̱ má nga un sku̱e̱ síhi̱n. Tu̱nga xu̱ta̱ xi na̱xu̱ nginku̱n Nti̱a̱ná ngju̱a̱i̱ má nga k'úéntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nk'ie nga ja kamaha̱ Jesu nga kitsúya ngayjee̱ ni xu'bi̱, a̱s'a̱i b'i̱ kitsúhu̱ já ni'yakuyáha̱: ");
INSERT INTO majNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Yo nga jo ni̱stjin ndyjaha̱ nga ku̱i̱tju S'í Pascu̱a̱, nk'ie nga n'e̱kjas'en Ntíhi̱ Nda̱x'i̱u̱n xi má nga s'e̱t'a kruu̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A̱s'a̱i kama ñjakú já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá ni'yaha̱ nda̱ na̱'mi títjun Caifa. ");
INSERT INTO majNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Y'éndako̱ xinkjín xi nkú ts'ín k'u̱a̱na̱cha̱ha̱ ra̱ Jesu nga ku̱a̱kj'ánijé ko̱ ts'i̱ínk'ien. ");
INSERT INTO majNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tu̱nga b'a̱há kitsúhu̱ xinkjín: —Najmi tu̱ a̱jihi̱n s'íu̱ chjubéé ndo̱ tu̱ xi najmi k'u̱ésihi xu̱ta̱ nkjin xi kj'u̱a̱í. ");
INSERT INTO majNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nk'ie nga tíjña Jesu nanki Betani̱a̱, ni'yaha̱ Simon, nda̱ xi k'uhu̱n ch'in fentujnu kai, ");
INSERT INTO majNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a̱s'a̱i nku ta̱chju̱ún j'aiko̱ ntá sinjne̱ xi chjí ṉkjún, xi tíi̱nchaha̱ nku lubata̱ ndji̱o̱ chjí. Kui xi tsaténdzjojnú nintaku̱ Jesu nk'ie nga kab'ejñat'a yámixo̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nk'ie nga kikie já ni'yakuyóo̱ niu̱, kama kjaha̱n ko̱ b'a̱ i̱ncha kitsú: —¿Á b'a̱ ts'ín kuan'ekatsún tiyaha ntá sinjne̱? ");
INSERT INTO majNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kamahá 'yún chjí kuach'a ntóo̱ nga kuasatéña kai, tu̱ xi kui to̱oo̱n k'u̱a̱i̱hi̱ ra̱ xu̱ta̱ x'a̱n. ");
INSERT INTO majNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kint'é Jesu ni xi tíi̱ncha tsu jóo̱ ko̱ b'a̱ kitsúhu̱: —¿Á jun tín'estihi̱ ru̱u ta̱chjíi̱n? Nda tjín ni xi kuats'ínna. ");
INSERT INTO majNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Xu̱ta̱ x'a̱n bi tehe̱nte k'úéntujínnu̱u, tu̱nga an najmi tehe̱nte kúáte̱jñajinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nk'ie nga kuakaténdzjojnúna ta̱chjíi̱n ntá sinjne̱i̱, ja kuak'íénda yjonintena̱ tu̱ xi s'e̱yanjihinna. ");
INSERT INTO majNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kju̱axi̱ ni xi tíxinnu̱u. Tu̱ má xi tje̱hén ni nga s'e̱ni̱jmí én nda tsuhu̱ Nti̱a̱ná nga ngúsuhu̱n a̱sunntee̱, ta̱ chu̱bani̱jmíyaha ni xi kuats'ín ta̱chjíi̱n. B'a̱ ts'ín n'e̱kj'áítsjehen. ");
INSERT INTO majNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","A̱s'a̱i nku nda̱ ni'yakuyá xi te joo̱ xi 'mi Juda̱ Iscariote̱ ngjisehe̱ já na̱'mi k'aku̱ ");
INSERT INTO majNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ko̱ b'a̱ kitsúhu̱: —¿Mí nihi xi k'u̱a̱i̱nú tsa ts'inkjas'ennu̱u ndo̱? A̱s'a̱i y'énda jóo̱ nga tsjáha̱ katé to̱ontaba. ");
INSERT INTO majNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kui ni̱stjiu̱n kik'atuts'i̱hi̱n Juda̱ nga tsangisjáí ni̱yá xi nkú ts'ín ka̱ma ts'i̱ínkjas'ehen Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ni̱stjin nga b'atuts'i̱hi̱n ra̱ S'í Pascu̱a̱, nk'ie nga chine ni̱nku̱a̱n xi najmi kamandako̱ho na̱'yu̱ san, a̱s'a̱i i̱ncha j'aisehe̱ Jesu já ni'yakuyáha̱ ko̱ b'a̱ i̱ncha kitsúhu̱: —¿Má xi tje̱hen mjehi nga k'úéndai̱ tu̱ xi chi̱ne̱heni nichinehe̱ S'í Pascu̱a̱? ");
INSERT INTO majNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","B'i̱ kitsú Jesu: —Tankíún a̱jin na̱nti̱o̱. Tankíhi̱nso̱o nda xi ja yaá ko̱ b'a̱ t'ihu̱un: “B'a̱ títsu nda̱ maestru̱: Ja tíbichú tiña chu̱ba̱na̱. Ni'yahi̱ kfínka̱ já ni'yakuyána̱ nga ts'inkj'a S'í Pascu̱a̱.” ");
INSERT INTO majNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A̱s'a̱i kits'íntjusun já ni'yakuyóo̱ ni xi kitsú Jesu. Yo̱ i̱ncha y'énda nichinehe̱ S'í Pascu̱a̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nk'ie nga ja kama jyuu̱n, y'ejñat'ako̱ Jesu yámixo̱ já ni'yakuyá xi te joo̱ ");
INSERT INTO majNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ko̱ nk'ie nga ja tíi̱ncha kjine nichinee̱, b'i̱ kitsúhu̱: —Kju̱axi̱ ni xi tíxinnu̱u. Nku xi tje̱njinnu̱u ts'i̱ínkjas'enna. ");
INSERT INTO majNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A̱s'a̱i kik'ientu babaha̱ já ni'yakuyóo̱ ko̱ nga nkúnkú kingjásjaiyaha̱: —¿A an, nda̱ maestru̱? ");
INSERT INTO majNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A̱s'a̱i b'i̱ kitsú Jesu: —Xi ta̱ tíbakj'á nichine xi tjíya ta̱ba̱ má nga tíbakj'a, kui xi ts'i̱ínkjas'enna. ");
INSERT INTO majNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","B'a̱ n'e̱he̱ Ntíhi̱ Nda̱x'i̱u̱n xi nkú ts'ín tjít'a éhe̱n Nti̱a̱ná, tu̱nga, ¡ni̱ma̱ rú ts'íhin nda̱ xi ts'i̱ínkjas'ehe̱n! Tu̱ sahá ra̱ ngandaha̱ nda̱ xu'bo̱ tsa najmi kitsin. ");
INSERT INTO majNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A̱s'a̱i kinchja̱ Juda̱, nda̱ xi ts'i̱ínkjas'en Jesu, nga b'a̱ kitsú: —¿A an, nda̱ maestru̱? B'i̱ kitsú Jesu: —Ji xi ja b'a̱ kuixín. ");
INSERT INTO majNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nk'ie nga tíi̱ncha kjine nichinehe̱ S'í Pascu̱a̱, jakj'á Jesu ni̱nku̱o̱n ko̱ kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná. Tsakjánya ko̱ kitsjáha̱ já ni'yakuyóo̱ nga b'a̱ kitsúhu̱: —Chjúbó ko̱ chi̱no̱o. Kui xu'bi̱ xi yjonintena̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ko̱ ta̱ jakj'á chu̱tsíu̱n. Nk'ie nga ja kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná, a̱s'a̱i kitsjáha̱ já ni'yakuyáha̱ nga b'a̱ kitsúhu̱: —S'i̱u̱yo ngatentoo̱ chu̱tsíi̱n. ");
INSERT INTO majNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kui xu'bi̱ xi jnína̱. Kui xi ngju̱a̱i̱ ndzjoho ngandaha̱ nkjin ṉkjún xu̱ta̱ tu̱ xi ka̱ma ndyjat'aha̱ ra̱ jéhe̱. Jnína tíb'éndako̱ tse̱tse̱ Nti̱a̱ná nd'a̱i̱ xi nkú ts'ín nda ts'i̱ínko̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","An b'a̱ tíxinnu̱u. Najmi ta̱ k'u̱i̱ sahana ntáha̱ tuntsja̱jée̱ santa nkúhu nga ku̱i̱chú ni̱stjin nga k'u̱i̱ko̱ ngáha̱nu̱u xi tse̱tse̱he̱ má batéxuma Na̱'mina̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nk'ie nga ja kamaha̱ nga i̱ncha kisehe̱ Nti̱a̱ná, a̱s'a̱i i̱ncha ngji a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","B'i̱ kitsú Jesu: —Kui ni̱stje̱n xu'bi̱ ngatentoho̱o n'e̱ndyja̱jihu̱un yjonu̱u yáha an. A̱t'aha̱ b'a̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “Ts'in'úhu̱n nda̱ bastuu̱ ko̱ ndzjo̱ya chu̱tsa̱nko̱.” ");
INSERT INTO majNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tu̱nga nk'iehé nga kj'u̱a̱íya ngáhana ngabayoo̱, kfín títjunnu̱u a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A̱s'a̱i kinchja̱ Pedro̱: —Ndaha tsa ngatentee̱ ts'i̱ínndyja̱jihi̱n yjoho̱ nga̱t'a ts'i̱i, tu̱nga an ndaha̱chí najmi ndyja̱ ka̱mana. ");
INSERT INTO majNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","B'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxihin. Kui ni̱stje̱n xu'bi̱, kintehe̱ ni nga kji̱ntá xa̱nto̱, b'a̱ ku̱i̱xín nga najmi yaní jan ni̱yá tjíhin. ");
INSERT INTO majNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","B'a̱ kitsú Pedro̱: —Ndaha tsa tjíhin nga ku̱a̱yáko̱ho, tu̱ nku nga ts'inkíéná yjona̱ nga behe. B'a̱ ta̱ i̱ncha kitsú ngatentee̱ já ni'yakuyóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","A̱s'a̱i tsichuko̱ Jesu já ni'yakuyáha̱ nku a̱nte xi 'mi Getsemani ko̱ b'a̱ kitsúhu̱: —Ti̱ntsu̱ba̱hanu e̱i̱. Kfín nchjako̱ maná Nti̱a̱ná ján. ");
INSERT INTO majNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ngjiko̱ Pedro̱ ko̱ nga joo̱ jáha̱ Zebedeo̱. Kik'atuts'i̱hi̱n nga kik'ie babaha̱ ko̱ kis'enta̱ha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","B'a̱ kitsúhu̱ jóo̱: —Kju̱a̱ba kitsejíhin ani̱ma̱na̱ xi nkúhu tsa kui xi ja ts'i̱ínk'ienna. Ti̱ntsu̱ba̱ko̱nú e̱i̱ ko̱ ta̱ ti̱ntsu̱ba̱ ndo. ");
INSERT INTO majNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A̱s'a̱i ngjindju sa i̱chí ko̱ yo̱ kingjénsten a̱nkjín. B'i̱ kitsú nga kinchja̱ko̱ Nti̱a̱ná: —Ji Na̱'mi, tsa ka̱ma kj'u̱a̱ t'axínna kju̱a̱ni̱ma̱ xu'bi̱, n'e̱kj'a t'axínní. Tu̱nga katumahá xi nkú ts'ín mjehi, najmi xi nkú ts'ín mjena. ");
INSERT INTO majNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A̱s'a̱i ngjise ngáha̱ ra̱ já ni'yakuyóo̱, ko̱ kjintufé nga j'aisehe̱. B'i̱ kitsúhu̱ Pedro̱: —¿A ndaha nku ora̱ najmi kuichukju̱a̱nu̱u nga kuakintsu̱ba̱ko̱nú? ");
INSERT INTO majNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ti̱ntsu̱ba̱ ndo ko̱ chu̱bako̱o Nti̱a̱ná tu̱ xi najmi chjút'ayák'uhu̱nnu̱u. Yuhu̱ ani̱ma̱nu̱u tu̱nga yjonintenu̱uhú xi najmi tíchúkju̱a̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A̱s'a̱i ta̱ ngji nchja̱ko̱hó ngáha Nti̱a̱ná ni̱yá xi ma joho Jesu nga b'a̱ kitsú: —Ji Na̱'mi, tsa tjíhin nga un sku̱e̱na ko̱ najmi ka̱ma kj'u̱a̱ t'axínna kju̱a̱ni̱ma̱ xu'bi̱, tu̱ sahá katuma xi nkú ts'ín mjehi. ");
INSERT INTO majNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nk'ie nga kik'óya ngáha má tjíntu já ni'yakuyóo̱, ta̱ kjintuféhé ngáha nga j'aisehe̱ a̱t'aha̱ nijñóo̱ tíb'échja suba tunku̱n jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ta̱ ngji nchja̱ko̱ t'axíhín ngáha Nti̱a̱ná ni̱yá xi ma jahan Jesu nga ta̱ kuihí én kitsú ngáha. ");
INSERT INTO majNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","A̱s'a̱i j'aisehe̱ já ni'yakuyáha̱ ko̱ b'a̱ kitsúhu̱: —¿A tu̱ nku kisuntuféhé so ko̱ tín'ekj'áíyo? Ja kuichu chu̱ba̱ nga n'e̱kjas'en Ntíhi̱ Nda̱x'i̱u̱n a̱ya ntsja xu̱ta̱ ngatitsuu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ti̱síntjo̱on ko̱ tjián. Ja nibá tiña xi títs'ínkjas'enna. ");
INSERT INTO majNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nk'ie nga ta̱ tínchja̱ha Jesu, tu̱ j'aihí Juda̱, nku nda̱ ni'yakuyá xi te joo̱. J'aiko̱ nkjin ṉkjún xu̱ta̱ xi kits'ín nibá já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá. I̱ncha y'a ki̱cha̱ ndju ko̱ yá nga i̱ncha j'ai. ");
INSERT INTO majNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ko̱ nda̱ xi títs'ínkjas'en Jesu ja kabinchá'a títjun jóo̱ nga b'i̱ kitsúhu̱: —Xi kjexu̱'ba nga kjuaniñaha̱, kui xi Jesu. Kui xi chjúbó. ");
INSERT INTO majNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tje̱n'yún ngjik'úhún ra̱ Jesu ko̱ b'a̱ kitsúhu̱ nga kikjexu̱'ba: —Antahi, nda̱ maestru̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","B'i̱ kitsú Jesu: —Ji nda̱ xinkjíán, n'e̱ndju̱í xá xi kjúái̱hini. A̱s'a̱i j'aik'úhu̱n Jesu já xingisoo̱ ko̱ jakj'ánijéhe̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tu̱nga nkuhú ki̱cha̱ ndju ts'asje nku nda̱ xi tje̱nko̱ Jesu. Kits'ín'uhu̱n nku nda̱ musu̱hu̱ nda̱ na̱'mi títjuu̱n. Tsatet'a tja̱ba̱xínñju. ");
INSERT INTO majNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tu̱nga b'a̱há kitsú Jesu: —Chj'atjó ngáhani ki̱cha̱hi̱ a̱ntehe̱. A̱t'aha̱ ngatentee̱ xi ts'ínchjén ki̱cha̱ nga kján, ta̱ ki̱cha̱ ku̱a̱yáha. ");
INSERT INTO majNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿A najmi yaní nga ka̱ma kuankihi̱ Na̱'mina̱ ko̱ tje̱n'yún ts'i̱ín nibáhána mii̱ ní ntítsje? ");
INSERT INTO majNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tu̱nga tsa b'a̱ ts'ian, ¿nkú ts'ín ku̱i̱tjusuhun ni xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná? A̱t'aha̱ b'a̱ ts'ín tjít'a nga tjíhin nga b'a̱ ka̱ma. ");
INSERT INTO majNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A̱s'a̱i b'i̱ kitsúhu̱ já xi tsichukj'áha̱: —¿A nda̱ ndyjéná? ¿Á i̱xí ki̱cha̱há ko̱ yá kich'ahanu nga kjúái̱chj'anijéhenú? Xki̱ ni̱stjin tsási̱njña nga tsakuyá má ma na̱tsihi̱n ni̱nku̱. Najmi kichjubénijénú. ");
INSERT INTO majNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tu̱nga b'a̱há tíma ngatentee̱ ni xu'bi̱ tu̱ xi tíbitjusuhun éhe̱n Nti̱a̱ná xi y'ét'a já profeta̱. A̱s'a̱i i̱ncha tsanka ngatentee̱ já ni'yakuyóo̱ nga tsasínjña suba Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Já xi j'aikj'áha̱ Jesu ni'yaha̱ nda̱ na̱'mi títjun Caifa i̱ncha ngjiko̱ho̱. Ja kab'entu yo̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ jáchá xi ta̱ tjíhi̱n xá. ");
INSERT INTO majNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Máha Pedro̱, kitsjennkí kjihi̱n Jesu santaha nkúhu nga tsichu na̱tsin ni'yaha̱ nda̱ na̱'mi títjuu̱n. Jas'en ko̱ y'ejñajihi̱n já jun xi kunntá yo̱, tu̱ xi sku̱e̱he ni xi ka̱ma. ");
INSERT INTO majNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A̱s'a̱i já na̱'mi k'aku̱ ko̱ ngayjee̱ já tjíxóo̱ tsangisjai ni xi ka̱ma kja̱nít'aha̱ Jesu tu̱ xi ka̱ma n'e̱k'iehen. ");
INSERT INTO majNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tu̱nga najmi i̱ncha kisakúhú ra̱ ni xi kja̱nínehe̱ Jesu, ndaha tsa i̱ncha j'ai ṉkjún já testiyu̱ tsank'á xi i̱ncha ngji kontra̱ha̱ Jesu. Tu̱nga tu̱ chahán j'ai jo ");
INSERT INTO majNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","xi kitsúya én xi kinchja̱ Jesu: —B'a̱ kitsú nda̱i̱ nga kinchja̱: “An ka̱mana ts'inkatsúnya ni̱nku̱hu̱ Nti̱a̱ná ko̱ jan ni̱stjin kjesíntje̱n ngáhana.” ");
INSERT INTO majNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A̱s'a̱i tsisintje̱n nda̱ na̱'mi títjuu̱n nga kingjásjaiyaha̱ Jesu: —¿A najmi chumi nihi xi ku̱i̱xínní? ¿Á b'a̱ tíi̱ncha tsuhu jóo̱ nga tífi kontra̱ha ri? ");
INSERT INTO majNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tu̱nga najmi kinchja̱há Jesu. A̱s'a̱i b'a̱há ta̱ kitsú ngáha nda̱ na̱'mi títjuu̱n: —Nginku̱n Nti̱a̱ná xi tíjña tík'un an tíbjasjáíyaha. Ti̱xínyani̱ tsa ji xi kits'ín nibá Nti̱a̱ná, xi Ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","B'i̱ kitsú Jesu: —B'a̱ tjín ni xi tíbixín. Ko̱ ta̱ xínyanu̱u nga cho̱o Ntíhi̱ Nda̱x'i̱u̱n nga k'úéjñat'aha̱ Nti̱a̱ná xi tjíhi̱n nga'yún ko̱ nga ni̱bajin ni̱nti̱ xi tjín nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A̱s'a̱i kikjeti̱yajen najyun xi yja nda̱ na̱'mi títjuu̱n. B'a̱ ts'ín tsakúchji ndo̱ nga najmi kisasíhi̱n én xi kinchja̱ Jesu. B'a̱ kitsú: —¡Najmi tíbenkjún Nti̱a̱ná nda̱i̱ nga b'a̱ títsu! ¿A machjén saná já testiyu̱? Ja kuanu'yó nga najmi kuakienkjún Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nkú manu̱u? B'a̱ i̱ncha kitsú jóo̱: —Ngabaya tje̱he̱n ra̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","A̱s'a̱i tjín xi tsatétéjin a̱nkjín Jesu nga kik'aya ko̱ kik'íéhe̱. K'u̱a̱ xi kik'onjihi̱n ");
INSERT INTO majNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nga b'a̱ kitsúhu̱: —Ji xi jái̱ni ngajoho̱ Nti̱a̱ná, ti̱xínyai xi nkúhu nda̱ profeta̱, ¿yá xi kuak'íéhi? ");
INSERT INTO majNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nk'ie nga kab'ejña Pedro̱ na̱tsin ni'yaha̱ nda̱ na̱'mi títjuu̱n, a̱s'a̱i j'aik'úhu̱n nku na̱ musu̱ ko̱ b'a̱ kitsúhu̱: —Ji xi ta̱ tje̱nko̱i̱ Jesu xi nibáha Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tu̱nga najmi kits'ínkiehé yjoho̱ Pedro̱ nginku̱n ngatentee̱ xu̱ta̱ xi tjín yo̱. B'a̱ kitsú: —Najmi be ni xi tíbixín. ");
INSERT INTO majNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A̱s'a̱i tsitju yo̱ nga ngji má tje̱n a̱nkju̱a̱ na̱tsiu̱n. Yo̱ ta̱ kikiehé ngáha̱ ra̱ kj'a̱í na̱ musu̱ ko̱ b'a̱ kitsúhu̱ já xi kabincha yo̱: —Kui chái̱ xi ta̱ tje̱nko̱ Jesu xi nibáha Nazaret. ");
INSERT INTO majNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ta̱ najmi kits'ínkiehé ngáha yjoho̱ Pedro̱. Santaha Nti̱a̱ná kits'ínkie nga b'a̱ kitsú: —¡Najmi be ndo̱! ");
INSERT INTO majNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sa kutju já xi kabincha yo̱ j'aisehe̱ Pedro̱ ko̱ b'a̱ kitsúhu̱: —Kju̱axi̱ kjáíhin nga ta̱ ji xi tsjenko̱i̱ jóo̱. A̱t'aha̱ xi nkú n'e chubai tíb'échjit'aihin. ");
INSERT INTO majNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","A̱s'a̱i ndjá kinchja̱ Pedro̱ ko̱ i̱xí Nti̱a̱náhá kits'ínkie nga b'i̱ kitsú: —¡Najmi be ndo̱! Kui chu̱bo̱ tje̱n'yún kikjintáhá nku xa̱nta̱ ");
INSERT INTO majNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ko̱ j'áítsjehe̱n Pedro̱ ni xi kitsú Jesu: “Kintehe̱ ni nga kji̱ntá xa̱nto̱, b'a̱ ku̱i̱xín nga najmi yaní jan ni̱yá tjíhin.” A̱s'a̱i tsitjusje Pedro̱ ko̱ kikjintá un kikjintá nte. ");
INSERT INTO majNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nk'ie nga ja kama see̱n, i̱ncha y'éndako̱ xinkjín ngatentee̱ já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá xi nkú ts'ín ka̱ma ts'i̱ínk'iehen Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","A̱s'a̱i tjí'yúhún ts'íhi̱n ra̱ nga i̱ncha ngji ts'ínkjas'ehe̱n nda̱ títjun Pilato̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Máha Juda̱, nda̱ xi kits'ínkjas'en Jesu, nk'ie nga kint'é nga kitsjá kju̱a̱ já tjíxóo̱ nga n'e̱k'ien Jesu, a̱s'a̱i ngjikj'áha̱ ra̱ ani̱ma̱ha̱ nga̱t'a ts'e̱ ni xi kits'ín ko̱ kits'ínk'óya ngáha̱ ra̱ já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá to̱ontaba xi katée̱. B'a̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Jé tje̱nna. Nku nda̱ xi najmi tjíhi̱n jé kits'inkjas'en nga n'e̱k'ien. B'a̱ i̱ncha kitsú jóo̱: —¿Mí xi nusinni̱ ji̱n? Kuenta̱hi̱ ní ni xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A̱s'a̱i kikjaníya Juda̱ to̱oo̱n a̱ya ni̱nku̱ ko̱ tsitju yo̱ nga ngji kjenntu n'ú suba yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","J'áya já na̱'mi k'aku̱ to̱oo̱n ko̱ b'a̱ kitsúhu̱ xinkjín: —Najmi ma tsa kaxa̱ha̱ to̱on chje̱ k'úéyaá to̱on xu'bi̱, a̱t'aha̱ chjíhi̱ nda̱ xi n'e̱k'ie̱n niu̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Y'éndako̱ xinkjín jóo̱. A̱s'a̱i ts'atseko̱ho to̱oo̱n xu'baha̱ nda̱ xi ts'ínnda ndji̱í tu̱ xi yo̱ ka̱ma s'e̱yanjihi xu̱ta̱ xi xin nanki nibáha. ");
INSERT INTO majNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kui kju̱a̱ha nga A̱nte Jní 'mihi a̱nte xu'bo̱ santaha ni̱stjin nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","B'a̱ ts'ín tsitjusuhun éhe̱n Nti̱a̱ná xi kinchja̱ nda̱ profeta̱ Jeremia̱: “Jakj'á jóo̱ to̱ontaba xi katée̱, chjí xi y'énda já xi ntje̱ Israel tje̱he̱n ra̱ nga b'a̱ tjín chjíhi̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kui xi ts'atseko̱ho xu'baha̱ nda̱ xi ts'ínnda ndji̱í. B'a̱ kitsúna Nti̱a̱ná.” ");
INSERT INTO majNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ngjinijé Jesu nginku̱n nda̱ títjun Pilato̱. Kui xi b'a̱ kitsúhu̱ nga kingjásjaiyaha̱: —¿A ji xi nda̱ rei̱hi̱ xu̱ta̱ judio̱? B'i̱ kitsú Jesu: —B'a̱ tjín ni xi tíbixín. ");
INSERT INTO majNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nk'ie nga nkjin ni xi kikjanínehe̱ já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá, ndaha̱chí najmi kinchja̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","A̱s'a̱i b'a̱ kitsú Pilato̱: —¿A najmi tínu'yání ngayjee̱ ni xi tíkjanínehi jóo̱? ");
INSERT INTO majNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tu̱nga ndahá nku én najmi kinchja̱ Jesu. Kui nga tu̱ ni xí kama nkjúhu̱n ra̱ nda̱ títjuu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ni xi ma nk'ie nga S'í Pascu̱a̱, b'i̱ ts'ín tíjñaha̱ nda̱ títjuu̱n. B'éjña nda̱í nku nda̱ nu̱ba̱yá xi f'ájin xu̱ta̱ na̱nti̱a̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kui ni̱stjiu̱n kjiya'yún nku nda̱ xi be tentehe̱ xu̱ta̱, xi 'mi Barraba. ");
INSERT INTO majNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nk'ie nga kama ñjakú xu̱ta̱, a̱s'a̱i b'a̱ kitsú Pilato̱: —¿Má xi mjenu̱u nga k'uejñá nda̱ínu̱u? ¿A Barraba a ra̱ Jesu xi 'mihi̱ Cristo̱? ");
INSERT INTO majNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","B'a̱ kitsú Pilato̱ a̱t'aha̱ kamankjihi̱n nga tíma xin k'un jóo̱ nga̱t'aha̱ ni xi títs'ín Jesu ko̱ nga kui kju̱a̱ha nga i̱ncha kits'ínkjas'ehe̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nga kab'ejña Pilato̱ a̱nte má nga ts'ín kju̱a̱, b'i̱ tsu én xi kits'ín nibáha̱ chju̱úhu̱n: “Najmi chumi ni tje̱he̱n xu̱to̱. Najmi tu̱ ji nungijin yjohi̱. A̱t'aha̱ ch'on ts'ín ka'ba̱i̱ chi̱nina nkui jyún tu̱ nga̱t'aha̱ ni xi tímat'ain xu̱to̱.” ");
INSERT INTO majNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tu̱nga já na̱'mi k'aku̱hú ko̱ jáchá xi ta̱ tjíhi̱n xá tsinchá'a xu̱ta̱ xi kama ñjakú yo̱ tu̱ xi i̱ncha ku̱a̱nkihi nga tu̱ sahá Barraba xi n'e̱ nda̱íhi̱ ra̱ ko̱ nga Jesu xi n'e̱k'ien. ");
INSERT INTO majNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A̱s'a̱i ta̱ kingjásjaiyahá ngáha nda̱ títjuu̱n: —¿Má xi kui já xi joo̱ mjenu̱u nga k'uejñá nda̱ínu̱u? B'a̱ i̱ncha kitsú xu̱ta̱ nkjiu̱n: —Barraba. ");
INSERT INTO majNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","B'a̱ kitsú Pilato̱: —¿Ko̱ mí xi ts'ihi̱n Jesu xi 'mi Cristo̱? B'a̱ i̱ncha kitsú tente xu̱ta̱: —¡Kas'et'a kruu̱! ");
INSERT INTO majNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","B'a̱há ta̱ kitsú ngáha Pilato̱: —Tu̱nga, ¿mí ni ch'on tjíhin xi kits'ín ndo̱? Tu̱nga tu̱ sahá 'yún i̱ncha kikjintáya sa xu̱to̱: —¡Kas'et'a kruu̱! ");
INSERT INTO majNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","A̱s'a̱i najmi ta̱ be nkú ts'i̱íhin Pilato̱, a̱t'aha̱ tu̱ sahá 'yún tíi̱ncha kjintáya sa xu̱ta̱ nkjiu̱n nga tíma kjaha̱n. Kui nga jakj'áha ntánijua, tsanéjnu ntsja nginku̱n xu̱ta̱ ko̱ b'a̱ kitsúhu̱: —Najmi an tjínna jé nga ku̱a̱yá nda̱i̱. Jun yo ni xi n'o̱o. ");
INSERT INTO majNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","B'a̱ i̱ncha kitsú ngatentee̱ xu̱ta̱: —Ji̱n ko̱ ntíni̱ ch'a̱njii̱ ngabayaha̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A̱s'a̱i y'éjña nda̱í Pilato̱ Barraba ko̱ kitsjá kju̱a̱ nga s'e̱he̱ Jesu ko̱ nga s'e̱t'a kruu̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","A̱s'a̱i já juhu̱n Pilato̱ jas'enko̱ Jesu ni'ya masen xi 'mi ni'ya pretori̱o̱. Kinchja̱ ñjaha̱ ngayjee̱ já jun xinkjín nga y'étjindaihi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","I̱ncha ts'asje najyuhu̱n Jesu ko̱ kits'ínngja nku najyun ndju kuan nga i̱ncha kik'aya. ");
INSERT INTO majNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ko̱ i̱ncha kits'ínnda nku corona̱ na'yá xi y'é'a nintaku̱ ko̱ ntsja kixi̱ kits'ínk'a nku yáxá. A̱s'a̱i tsinchakúnch'int'a maña̱ha̱ ko̱ tsajnukie nga b'a̱ i̱ncha kitsúhu̱: —Antahi, nda̱ rei̱hi̱ xu̱ta̱ judio̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tsatétéjnu ko̱ jakj'á yáxóo̱ nga kik'onntjai nintaku̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","A̱skahan nga ja kamaha̱ nga kik'aya Jesu, ts'asje ngáha najyun ndju kuo̱n ko̱ kits'ínngja ngáha najyun xi ts'e̱ Jesu. A̱s'a̱i i̱ncha tsitjuko̱ tu̱ xi ngju̱át'a kruu̱hu. ");
INSERT INTO majNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nk'ie nga tíi̱ncha bitju yo̱, kisatékjá nku nda̱ nanki Cirene̱ xi Simon 'mi. Kui xi kits'ín kju̱a̱'yúhu̱n ra̱ já juu̱n nga k'u̱a̱nji kruu̱hu̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","A̱s'a̱i i̱ncha tsichu a̱nte xi 'mi Golgo̱ta̱. Kui ée̱n xi tsuhu̱ ra̱: A̱ntehe̱ Nintaku̱ Ani̱ma̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kik'a̱i̱hi̱ Jesu nga k'úí binu̱ xi kin'etjijinko̱ho nki, tu̱nga nk'iehé nga kikjut'a Jesu ntóo̱, najmi kits'ín yu nga kik'i. ");
INSERT INTO majNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nk'ie nga kingját'a kruu̱, já juu̱n tsakjánya xi̱hi̱ xinkjín najyuhu̱n Jesu nga kitsutonyá ts'íhin. ");
INSERT INTO majNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","A̱s'a̱i y'entu yo̱ nga kikunntá. ");
INSERT INTO majNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kis'et'a xi tje̱hen a̱ntsjáku̱ Jesu nku yáte xi títsuya mí kju̱a̱ha nga tín'ek'iehen. “Kui xu'bi̱ xi Jesu xi nda̱ rei̱hi̱ xu̱ta̱ judio̱”, kis'et'a yátee̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ta̱ kis'et'a kruu̱ko̱ Jesu jo já ndyjé. Nku xi kitsjen nga kixi̱hi̱ ko̱ nku nga skjúhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Xu̱ta̱ xi tíi̱ncha f'a yo̱ najmi kikienkjún Jesu nga kinchja̱. Kits'ínk'ajni nintaku̱ ");
INSERT INTO majNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nga b'a̱ i̱ncha kitsúhu̱: —Ji xi n'e̱xúyai ni̱nku̱ ko̱ jan ni̱stjin chjúsíntje̱n ngáhani, tsixín, n'e̱k'anki yjohi̱. Tsa ji xi Ntíhi̱ Nti̱a̱ná, ti̱tjuje̱nt'ai kruu̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","B'a̱ ta̱ ts'ín kik'ayaha̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ jáchá xi ta̱ tjíhi̱n xá. B'a̱ i̱ncha kitsúhu̱ xinkjín: ");
INSERT INTO majNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Kamaha̱ nda̱i̱ nga kj'a̱í xi kits'ínk'anki, tu̱nga tu̱ sa najmi mahá ngáha̱ ts'ínk'anki yjoho̱. Katitjujent'a kruu̱ nd'a̱i̱ tsa kui xi nda̱ rei̱hi̱ xu̱ta̱ Israel. Nk'iehé nga s'e̱jinná. ");
INSERT INTO majNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kui xi 'yún kis'ejihi̱n Nti̱a̱ná, kui nga Nti̱a̱ná kats'ínk'ankihi̱ ra̱ nd'a̱i̱ tsa tjo kju̱axi̱hi̱. ¿A najmi b'a̱há kitsú nga kui xi Ntíhi̱ Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ko̱ já ndyjé xi kjintut'á kruu̱ko̱ Jesu ta̱ ch'on i̱ncha kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chu̱ba̱ te jo nga ni̱stjiu̱n kis'e jyun ngayjee̱ a̱sunntee̱ santa nkúhu nga tsichu chu̱ba̱ jan nga ngixuu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nkú ma nga chu̱ba̱ jan 'yún kikjintáya Jesu nga éhe̱n kinchja̱. B'i̱ kitsú: —Eli, Eli, ¿lema sabactani̱? —kui éi̱n xi tsuhu̱ ra̱: Ji Nti̱a̱na̱, ji Nti̱a̱na̱, ¿á kan'e nga mahaní? ");
INSERT INTO majNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","K'u̱a̱ xu̱ta̱ xi kabincha yo̱ i̱ncha kint'é kui ée̱n. Kui nga b'a̱ i̱ncha kitsúhu̱ ra̱ xinkjín: —Nda̱ profeta̱ Elia̱ tínchja̱ha̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","A̱s'a̱i tje̱n'yún tsangatsankahá nku nda̱ xi síjña yo̱ ko̱ nku tsa̱nka̱ kits'ínk'anchi̱ko̱ sesehe binu̱ san. Kui xi y'éku nku yáxá nga kits'ínkjik'uhu̱n Jesu tu̱ xi k'úíhi. ");
INSERT INTO majNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tu̱nga b'a̱há kitsú xu̱ta̱ xi kabincha yo̱: —Chúya mai. Cha̱se̱ ma ra̱á tsa nibá Elia̱ nga ts'i̱ínk'ankihi̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A̱s'a̱i ta̱ 'yúhún kikjintáya ngáha Jesu ko̱ k'ien. ");
INSERT INTO majNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nk'ie nga b'a̱ kamoo̱, kitiyájen najyun xi tje̱nchja a̱nte xi 'yún nkjúhu̱n ni̱nku̱. Jo tsitju. Kik'aha̱ ra̱ nk'aha̱ santaha kintee̱. Ko̱ chón kama ko̱ tsakjan na̱xi̱u̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tsix'á tsjóho̱ ani̱ma̱ ko̱ j'áíya ngáha̱ ra̱ nkjin xu̱ta̱ k'ien xi kis'ejihi̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","I̱ncha tsitju tsjóho̱ nk'ie nga j'áíya ngáha̱ ra̱ Jesu ko̱ jas'en nanki je Jerusalen nga tsakúchjihi̱ yjoho̱ nkjin xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nda̱ jun k'aku̱ ko̱ já jun xi tíi̱ncha kunntá Jesu, nk'ie nga kikie chóo̱n ko̱ ngayjee̱ ni xi tímoo̱, tu̱ xí i̱ncha kitsankjúhún ko̱ b'a̱ i̱ncha kitsú: —Kju̱axi̱ kjáíhin nga kui nda̱i̱ xi Ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yo̱ kjint'á kabincha nkjin jminchjín xi tíi̱ncha base. Kitsjennkíhi̱ Jesu nga tsitju a̱nte Galilea̱ ko̱ tsasinko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","A̱jihi̱n jminchjíu̱n tje̱njin Maria̱ Magdalena̱, Maria̱ xi na̱aha̱ maha Santiago̱ ko̱ Kuse, ko̱ na̱aha̱ jáha̱ Zebedeo̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nk'ie nga ja tíma jyun, j'ai nku nda̱ nchi̱ná xi 'mi Kuse, nku nda̱ nanki Arimatea̱ xi ta̱ ja tsichu ma nku nda̱ ni'yakuyáha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A̱s'a̱i ngjisehe̱ Pilato̱ ko̱ tsankihi̱ yjonintehe̱ Jesu. Kitsjá kju̱a̱ Pilato̱ nga k'u̱a̱i̱hi̱ ndo̱ yjonintee̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jakj'á Kuse yjonintee̱. Nku najyun je kik'ontikjájnu ");
INSERT INTO majNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ko̱ ngjingjájñaya nku ti̱xa̱ tsjó tse̱tse̱he̱ xi kits'ínndat'á na̱xi̱u̱. A̱s'a̱i kik'ontikjá nku ndji̱o̱ chánka nga y'échjane a̱nkju̱a̱ tsjóo̱ ko̱ ngji. ");
INSERT INTO majNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Y'entu a̱nkjín tsjóo̱ Maria̱ Magdalena̱ ko̱ Maria̱ xinkuu̱. ");
INSERT INTO majNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ni̱stjin xi ma ndyjuu̱n, nk'ie nga j'a ni̱stjin nk'ie nga s'enda ni xi machjén S'í Pascu̱a̱, a̱s'a̱i kama ñjakú já na̱'mi k'aku̱ ko̱ já fariseo̱ nginku̱n Pilato̱ ko̱ b'a̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Ji nda̱ nti̱a̱, f'áítsjenni̱ nga b'a̱ kitsú nda̱ tsank'óo̱ nk'ie nga tíjña sa: “Nk'ie nga kj'u̱a̱ jan ni̱stjin, kj'u̱a̱íya ngáhana ngabayoo̱.” ");
INSERT INTO majNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kui b'a̱ maha, b'a̱ ti̱xín nga chúnnta tsjóo̱ santaha nkúhu nga kj'u̱a̱ ni̱stjin xi ma jahan. A̱t'aha̱ tsa najmi ma, kutsa kj'u̱a̱íhí já ni'yakuyáha̱ ndo̱ nga jyuu̱n ko̱ ngju̱a̱i̱ko̱ ndyjé yjonintehe̱. A̱s'a̱i: “Ja j'áíya ngáha̱ ra̱ ngabayoo̱”, ku̱i̱tsu̱hu̱ xu̱ta̱. Tsa b'a̱ ts'i̱ín jóo̱, 'yún s'e̱ sa én tsank'á xi ku̱i̱tju a̱skahan nga xi tjuu̱n. ");
INSERT INTO majNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","B'a̱ kitsú Pilato̱: —Tankínko̱o já juu̱n. Tankíún n'e̱ kunntó tsjóo̱ xi nkú ts'ín mjenu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","A̱s'a̱i i̱ncha ngjisehe̱ tsjóo̱. Nku ndji̱o̱ y'échjaneko̱ho. Y'échjane sisin ko̱ y'éntu já jun xi kikunntá yo̱. ");
INSERT INTO majNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nk'ie nga j'a xua̱tu̱, ja tífi ma sen ngáha ni̱stjin xi b'atuts'i̱hi̱n ra̱ tuntjóo̱, ngjisehe̱ tsjóo̱ Maria̱ Magdalena̱ ko̱ Maria̱ xinkuu̱. ");
INSERT INTO majNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A̱s'a̱i tu̱ nkuhú chón xi tu̱ xí 'yúhún kama. Nku ntítsjehe̱ Nti̱a̱ná nibajen nk'a ján. J'aikjexín ndji̱o̱ xi tjíchjane a̱nkju̱a̱ha̱ tsjóo̱ ko̱ yo̱ y'ejñasun. ");
INSERT INTO majNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Xi nkú joyaha nd'ích'o̱n tjín sénni̱stjihi̱n ko̱ taba xúxú najyun xi yja xi nkú joyaha nch'án. ");
INSERT INTO majNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nk'ie nga i̱ncha kikie ntítsjee̱ já jun xi tíi̱ncha kunntá tsjóo̱, tu̱ xí i̱ncha kitsankjúhún nga i̱ncha kik'atsé. B'a̱ i̱ncha kik'ientu xi nkúhu tsa ja k'ien kik'ientu. ");
INSERT INTO majNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A̱s'a̱i kinchja̱ko̱ ntítsjee̱ jminchjíu̱n nga b'a̱ kitsúhu̱: —Najmi tu̱ binkjun. Be nga Jesu xi kis'et'a kruu̱ tíbinchisjó. ");
INSERT INTO majNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Najmi ta̱ e̱i̱ tíjñaha. Ja kaf'áíya ngáha̱ ra̱ ngabayoo̱ xi nkú nga kitsú. Nibáha̱so̱o a̱nte má nga kis'ejña. ");
INSERT INTO majNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ki̱tsa̱ tankínk'inyoho̱o já ni'yakuyáha̱ nga ja kaf'áíya ngáha̱ ra̱ ngabayoo̱ Jesu ko̱ ngju̱a̱i̱ títjuhu̱n a̱nte Galilea̱. Yo̱ sku̱e̱. Ja kuaxinyanu̱u ni xi tjíhin nga xínnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","A̱s'a̱i tsitju ki̱tsa̱ ki̱tsa̱ jminchjíu̱n a̱ya tsjóo̱. Títsankjún ko̱ tsjo ṉkjún tímaha̱. Tsangatsanka nga ngji tsúyaha̱ já ni'yakuyóo̱ ée̱n. ");
INSERT INTO majNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ko̱ nga tíi̱ncha fi, tu̱ yo̱hó kisatéjin Jesu ko̱ janiñaha̱. A̱s'a̱i i̱ncha ngjik'úhu̱n ko̱ kitsubakjá sjai nga kits'íntsjoho̱. ");
INSERT INTO majNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","B'i̱ kitsú Jesu: —Najmi tu̱ binkjun. Tankínk'inyoho̱o já nts'é nga katji a̱nte Galilea̱. Yo̱ sku̱e̱na. ");
INSERT INTO majNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nk'ie nga tíi̱ncha fi jminchjíu̱n, a̱s'a̱i ngji k'u̱a̱ já juu̱n a̱jin na̱xi̱nantóo̱. Ngji tsúyaha̱ já na̱'mi k'aku̱ ngatentee̱ ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A̱s'a̱i kama ñjakú já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá nga y'éndako̱ xinkjín. A̱s'a̱i kitsjá ṉkjúhu̱n to̱on já juu̱n ko̱ b'a̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—B'i̱ ti̱xíún: “Kaf'aijyún já ni'yakuyáha̱ ndo̱ ko̱ kafiko̱ ndyjé yjoninte k'ie̱n nk'ie nga kisuntuféi̱.” ");
INSERT INTO majNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tsa ku̱i̱nt'é nda̱ títjuu̱n niu̱, ji̱n yai̱ xi nkú n'e̱ chu̱bani̱jmíko̱i̱. Najmi tu̱ jun fanto̱ho̱ yjonu̱u. ");
INSERT INTO majNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A̱s'a̱i jakj'á já juu̱n to̱oo̱n ko̱ b'a̱ i̱ncha kitsú xi nkú kik'ihi̱n. Kui én xu'bi̱ xi tu̱ yje chubani̱jmíyahá sa a̱jihi̱n xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ santaha ni̱stjin nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Já ni'yakuyá xi te nkuu̱ i̱ncha ngji a̱nte Galilea̱ a̱sunntu tje̱nki̱ xi kitsú Jesu. ");
INSERT INTO majNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nk'ie nga i̱ncha kikie Jesu, kits'íntsjoho̱, tu̱nga tjíhín xi jo jan kamaha̱. ");
INSERT INTO majNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","A̱s'a̱i Jesu ngjisehe̱ já ni'yakuyáha̱ ko̱ b'a̱ kitsúhu̱: —Ja kik'a̱i̱na nga kuatexumaha̱ ndji̱o̱jmi ján ko̱ a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kui nga tankíhinnu ko̱ n'e̱ mo xu̱ta̱ ni'yakuyána̱ ngayjee̱ xu̱ta̱ na̱xi̱nantá xi tjín a̱sunntee̱. Ta̱tentó xu̱ta̱ tu̱ xi Nti̱a̱ Na̱'miu̱, Ntíu̱ ko̱ Espiri̱tu̱ Santo̱ ka̱mats'e̱he. ");
INSERT INTO majNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ta̱kúyoho̱o nga kats'íntjusun ngayjee̱ kju̱a̱téxumana̱. An kúáte̱jñajinnu̱u ngayje ni̱stjin santaha nkúhu nga kfe̱ a̱sunntee̱.");
INSERT INTO majNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","B'i̱ ts'ín b'atuts'i̱hi̱n ra̱ én nda tsuhu̱ Jesu, kui xi Cristo̱ xi Ntíhi̱ Nti̱a̱ná maha. ");
INSERT INTO majNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nda̱ profeta̱ Isaia̱ b'i̱ ts'ín y'ét'a nk'ie: Títs'inkjíá nda̱ chji̱ne̱'énna̱ tu̱ xi ngju̱a̱i̱ títjuhun ri. K'u̱énda títjun ni̱yáhi̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tínu'yá nta̱ha̱ nku nda̱ xi tíkjintáya a̱nte kixiu̱: “T'endo ni̱yáha̱ Nti̱a̱ná. Tjen na̱xu̱u ni̱yáha̱.” ");
INSERT INTO majNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Xi nkú ts'ín y'ét'a Isaia̱ nk'ie, b'a̱ ts'ín j'aiténtá xu̱ta̱ Jua a̱nte kixiu̱. Y'éni̱jmí nga tjíhin nga ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱ xu̱ta̱ ko̱ nga sa̱téntá tu̱ xi ka̱ma ndyjat'aha̱ ra̱ ngatitsuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tsitju ngayjee̱ xu̱ta̱ xi tjín a̱nte Judea̱ ko̱ ngayjee̱ xu̱ta̱ xi tjín nanki Jerusalen nga j'aisehe̱ Jua. I̱ncha kisaténtájin ntáje̱ Jordan nk'ie nga kits'ínkie yjoho̱ nga tjíhi̱n ngatitsun. ");
INSERT INTO majNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nk'ie nga y'ejña Jua, najyun xi kamandako̱ho ntsja̱ha̱ chu̱ camello̱ bja ko̱ nku tja̱ba̱xín b'ékjá. Chju̱ba̱ ko̱ ntsjényá kjine. ");
INSERT INTO majNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","B'i̱ kitsú nga y'éni̱jmí: —A̱skahan an kj'u̱a̱í nku xi 'yún nk'a tje̱n sa, xi má nga ndaha̱chí najmi tsuhuna tsa kjendáya n'úhu̱ ntéhe̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","An ntánijua tíbatentáko̱ho̱nu̱u tu̱nga máha kui, Espiri̱tu̱ Santo̱ ku̱a̱téntáko̱ho̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ni̱stjin ján tsitju Jesu nanki Nazaret, nanki xi tíjñajihi̱n a̱nte Galilea̱, ko̱ ntáje̱ Jordan tsaténtájihi̱n Jua. ");
INSERT INTO majNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nk'ie nga tíbitjujín ntánijuo̱, kikie nga tsix'á nk'a ján ko̱ nga Espiri̱tu̱ Santo̱ nibajennehe̱ xi nkú joyaha nku chu̱tuju. ");
INSERT INTO majNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kinu'yá nk'a ján nku nta̱ xi b'a̱ kitsú: —Ji Ntína̱, tjona ji. Tsjo ṉkjún mana ji. ");
INSERT INTO majNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A̱s'a̱i tje̱n'yún ngjiko̱hó ra̱ Espiri̱tu̱ Santo̱ a̱nte kixiu̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yo̱ y'ejña yachán ni̱stjin tjíhin, ko̱ nda̱nindoo̱ kikjut'ayák'uhu̱n. Y'ejñajihi̱n chu̱ xi tjín ngijñóo̱ ko̱ ntítsjehe̱ Nti̱a̱ná j'aisinko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A̱skahan nk'ie nga kis'eya'yún Jua, ngji Jesu a̱nte Galilea̱ nga y'éni̱jmí én nda tsuhu̱ Nti̱a̱ná. B'i̱ kitsúhu̱ xu̱ta̱: ");
INSERT INTO majNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Ja kuichu chu̱ba̱. Ja 'yún tiña tíjñanu̱u Nti̱a̱ná nga tíbatéxumanu̱u nd'a̱i̱. Tankínchj'a̱ha̱ ru̱u ani̱ma̱nu̱u ko̱ n'e̱ s'ejiun én nda tsuhu̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nk'ie nga tsú'ba Jesu a̱ndai ntáchak'un Galilea̱, kikie Simon ko̱ Andre xi nts'e̱ maha xinkjín. Kui xi tíi̱ncha kjaníkj'a na̱'ya tji̱o̱ho̱ a̱jin ntóo̱, a̱t'aha̱ tji̱o̱ i̱ncha tsuba jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","B'i̱ kitsú Jesu: —Jun já, tsjénnkinú. An ts'ian nga xu̱ta̱ nu̱bo̱o. ");
INSERT INTO majNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ta̱ kuihi chu̱bo̱ y'éntu jóo̱ na̱'yaha̱ ko̱ kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A̱s'a̱i ngjindju sa ko̱ kikie Santiago̱ ko̱ Jua xi nts'e̱ maha xinkjín. Kui jóo̱ xi jáha̱ Zebedeo̱. A̱yaha̱ tsutsuhu̱ jóo̱ i̱ncha kabincha nga tíi̱ncha b'énda na̱'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A̱s'a̱i tje̱n'yún kinchja̱há ra̱, ko̱ y'éntu jóo̱ Zebedeo̱ xi na̱'mihi̱ maha ko̱ já xi basinko̱ho̱ a̱ya tsutsuu̱ nga kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","A̱s'a̱i i̱ncha j'ai nanki Capernaum. Nk'ie nga ni̱stjin nkjúu̱n jas'en Jesu ni'ya sinagoga̱ nga tsakúya. ");
INSERT INTO majNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kama nkjúhu̱n xu̱ta̱ xi nkú ts'ín tsakúya, a̱t'aha̱ tsakúya xi nkúhu tsa xá tjíhín, najmi xi nkú ts'ín bakúya já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tíjña sinagoga̱ha̱ xu̱ta̱ Capernaum nku nda̱ xi tíjñajihi̱n nku nda̱ninda. Kui xi 'yún kikjintáya nga b'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Ji Jesu xi nibáhani Nazaret, ¿mí nihi xi tjínko̱ni̱? ¿Á ja kjúái̱ n'ekjehe̱ni̱? Bená yáha ji. Ji xi ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tu̱nga ndjáhá kinchja̱ko̱ Jesu nda̱nindoo̱: —¡Xu̱ sin n'ei ko̱ ti̱tjusje̱jihi̱n ndo̱! ");
INSERT INTO majNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","I̱xí y'étsujnehé ra̱ ndo̱ nda̱nindoo̱ ko̱ tu̱ xí 'yúhún kikjintáya nga tsitjujíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ngatentee̱ xu̱ta̱ tu̱ ni xí kama nkjúhún ra̱ ko̱ b'i̱ ngján kingjásjaiyaha̱ xinkjín: —¿Mí nihi xu'bi̱? Kj'a̱í ts'ín bakúya nda̱i̱. Bakúya xi nkú joyaha tsa xá tjíhi̱n. Santaha jánindoo̱ batéxumaha̱ ko̱ nt'é'éhe̱n. ");
INSERT INTO majNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ngayjee̱ nanki xi tjín a̱nte Galilea̱ tu̱ xí kitsahá kichubani̱jmíyaha Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nk'ie nga i̱ncha tsitju ni'ya sinagoga̱, ngji Jesu, Santiago̱ ko̱ Jua ni'yaha̱ Simon ko̱ Andre. ");
INSERT INTO majNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kui chu̱bo̱ ch'in kjijñako̱ na̱ nchí'yaha̱ Simon. Tje̱n'yún kik'inyahá ra̱ Jesu ni xi tímaha̱ ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A̱s'a̱i ngjik'úhu̱n Jesu ko̱ jakj'á ntsja nga kikjesíntje̱n. Ta̱ kuihi chu̱bo̱ kindyjajihi̱n ch'ihi̱n ta̱chjúu̱n ko̱ kitsjáha̱ nichine xi tsichusehe̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nk'ie nga ja kama'ña̱, a̱skahan nga ja ngjintjai ts'íu̱, j'aich'áha̱ Jesu ngayjee̱ xu̱ta̱ un ko̱ xi tjíntujíhi̱n jánindoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ngayjee̱ xu̱ta̱ na̱nti̱o̱ kama ñjakú a̱sti a̱nkju̱o̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kits'ínnkihi̱ Jesu nkjin ṉkjún xu̱ta̱ un xi k'uhu̱n nkjin tíkjá ch'in. Kik'onsje nkjin ṉkjún jáninda. Najmi kitsjántehe̱ tsa ku̱i̱nchja̱ jánindoo̱, a̱t'aha̱ jánindoo̱ be yáha Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nk'ie nga jyunya xa̱ sa, tsisintje̱n Jesu ko̱ ngji nku a̱nte t'axín tiya. Yo̱ kinchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A̱s'a̱i Simon ko̱ já xi tjíntuko̱ho̱ yo̱ i̱ncha tsangisjáí Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nk'ie nga kisakúhu̱, b'a̱ i̱ncha kitsúhu̱: —Ngayjee̱ xu̱ta̱ tíbangisjaihi. ");
INSERT INTO majNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","B'i̱ kitsú Jesu: —Tjián kj'a̱í a̱nte xi tjín tiña e̱i̱ tu̱ xi ko̱ ta̱ yo̱ k'ueni̱jmíhina. A̱t'aha̱ kui xá jáíhi̱na. ");
INSERT INTO majNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ngji nga y'éni̱jmí xki̱ ni'ya sinagoga̱ xi tjín ngayjee̱ a̱nte Galilea̱ ko̱ kik'onsje jáninda xi tjíntujíhi̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nku nda̱ xi k'uhu̱n ch'in fentujnu j'aisehe̱ Jesu ko̱ tsasinkúnch'int'aha̱ nga tsankihi̱ nga ku̱a̱si̱nko̱ho̱. B'i̱ kitsúhu̱: —Tsa ji xi mjehi, ka̱ma n'e̱ jení nga chjúxinní ch'in xi k'unna. ");
INSERT INTO majNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","A̱s'a̱i kama ni̱ma̱ha̱ Jesu nda̱ uu̱n. Kingjénne ntsja nga kits'ínko̱ ko̱ b'i̱ kitsúhu̱: —Mjena. Katuma jei. ");
INSERT INTO majNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ta̱ kuihi chu̱bo̱ kindyja ch'ihi̱n ndo̱. Kama je ngáha. ");
INSERT INTO majNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","A̱s'a̱i b'i̱ kitsúhu̱ Jesu ndo̱: ");
INSERT INTO majNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ji, najmi tu̱ ch'a xi 'miyaihi̱ ni xi kamat'ain. T'ihi̱nkúchjihi̱ yjohi̱ nda̱ na̱'miu̱ ko̱ tjein chje̱ xi nkú ts'ín y'éjña Moise nga̱t'aha̱ nga ja kama jei, tu̱ xi sku̱e̱ kixi̱hi xu̱ta̱ nga ja kamanda ngáhani. ");
INSERT INTO majNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tu̱nga nk'iehé nga ngji ndo̱, kitsúya tentehe̱ xu̱ta̱ ni xi kamat'ain. Kui nga najmi ta̱ kama jas'en chjihi Jesu nanki xi tjíhin yo̱. Tu̱ a̱ndai na̱nti̱o̱hó kikjatsú'ba má nga najmi tjín xu̱ta̱. Tu̱nga tsitjuhú xu̱ta̱ xi tjín tu̱ má nankihí ni nga j'aisehe̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A̱s'a̱i ta̱ j'aihí ngáha Jesu nanki Capernaum ko̱ kint'é xu̱ta̱ nga ja tíjña ngáha Jesu ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kui nga kama ñjakú ṉkjúhun xu̱ta̱, nga santaha najmi ta̱ kis'ehe a̱nte a̱sti a̱nkju̱o̱, ko̱ Jesu y'éni̱jmíhi̱ éhe̱n Nti̱a̱ná xu̱to̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","A̱s'a̱i i̱ncha j'ai ñju já xi i̱ncha kab'anganki nku nda̱ xi najmi ma fi. Jesu j'aich'áha̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tu̱nga najmi mahá i̱ncha bichúko̱ nda̱ uu̱n má síjña Jesu tu̱ nga̱t'aha̱ xu̱ta̱ nkjin xi kama ñjakú yo̱. Kui nga i̱ncha kikjexíhin nku te ni xi kjinehe̱ ra̱ ni'yoo̱ ko̱ yo̱ i̱ncha kits'ínkjihi nda̱ uu̱n santaha má síjña Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nk'ie nga kikie Jesu nga s'ejihi̱n jóo̱ nga Nti̱a̱ná kits'ín nibáha̱, a̱s'a̱i kinchja̱ko̱ nda̱ uu̱n: —Ji ntína̱, ja kama ndyjat'ahi ngatitsuhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tu̱nga ta̱ kab'entuhú yo̱ k'u̱a̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ xi b'i̱ ts'ín i̱ncha kits'ínnkjink'un: ");
INSERT INTO majNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Á b'a̱ ts'ín tínchja̱ha nda̱i̱? Najmi tíbenkjún Nti̱a̱ná nga b'a̱ ts'ín tínchja̱. A̱t'aha̱ nku tutuhú Nti̱a̱ná xi maha̱ ts'ínndyjat'aha̱ xu̱ta̱ ngatitsuhu̱n.” ");
INSERT INTO majNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tu̱nga tje̱n'yún kamankjihín ra̱ Jesu ni xi tíi̱ncha ts'ínnkjink'un jóo̱. A̱s'a̱i b'i̱ kitsúhu̱: —¿Á b'a̱ ts'ín tín'enkjínk'uhunnu? ");
INSERT INTO majNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Má éhen xi 'yún na̱xu̱ tje̱n xi ka̱ma xíhi̱n nda̱ xi najmi ma fii̱? ¿A: “Ja kama ndyjat'ahi ngatitsuhi̱n”? ¿A ra̱: “Ti̱síntje̱i̱n, chjúbéí na̱chan xi kisujñasuin ko̱ ti̱tsutjai”? ");
INSERT INTO majNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tu̱nga mjehéna kuakuchjínu̱u nga Ntíhi̱ Nda̱x'i̱u̱n tíjña ngajoho̱ Nti̱a̱ná a̱sunntei̱ xi má nga ka̱ma ts'i̱ínndyjat'aha̱ ngatitsuhu̱n xu̱ta̱. A̱s'a̱i b'i̱ kitsúhu̱ nda̱ xi najmi ma fiu̱: ");
INSERT INTO majNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ji tínchjako̱ho. Ti̱síntje̱i̱n, chjúbéí na̱chahi̱n ko̱ t'in ngáhani ni'yahi̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A̱s'a̱i tje̱n'yún tsisintje̱hén nda̱ uu̱n, jakj'á na̱chaha̱n, ko̱ ngayjee̱ xu̱ta̱ kikiehe̱ nga tsitjusje. Tu̱ ni xí kama nkjúhún ra̱ ngatentee̱ xu̱ta̱ ko̱ kits'íntsjoho̱ Nti̱a̱ná. B'i̱ i̱ncha kitsúhu̱ xinkjín: —Ndaha̱chí najmi kje̱e yaá nku ni xi nkúhu xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A̱s'a̱i ta̱ tsitjuhú ngáha Jesu nga ngji a̱ndai ntáchak'uu̱n. Nkjin ṉkjún xu̱ta̱ j'aisehe̱, ko̱ Jesu tsakúyaha̱ xu̱to̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nk'ie nga títs'ín ni̱yá, kikie nda̱ xi 'mi Levi xi ntíhi̱ Alfeo̱ nga kab'ejña a̱nte má nga f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ ko̱ b'i̱ kitsúhu̱: —Tsjénnkiní. A̱s'a̱i tsisintje̱n Levi ko̱ kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nk'ie nga tíkjine Jesu ni̱ñu̱ ni'yaha̱ Levi, nkjin ṉkjún já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ ko̱ já xi najmi na̱xu̱ ts'íntjusun kju̱a̱téxumaha̱ Moise ta̱ i̱ncha j'aik'ientut'áha̱ Jesu ko̱ já ni'yakuyáha̱. A̱t'aha̱ nkjin ṉkjún maha xi i̱ncha kitsjennkíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kikie já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱ nga Jesu tíkjineko̱ ni̱ñu̱ jóo̱. A̱s'a̱i kinchja̱ko̱ já ni'yakuyáha̱ Jesu nga b'i̱ kitsúhu̱: —¿Á já xi f'áchjíntjaihi ch'á ko̱ já xi najmi na̱xu̱ ts'íntjusuhun kju̱a̱téxumaha̱ Moise tíneko̱ho ni̱ñu̱ nda̱ maestru̱nu̱u? ");
INSERT INTO majNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nk'ie nga kint'é Jesu éi̱n, b'i̱ kitsú: —Xu̱ta̱ xi uhu̱n machjéhe̱n já chji̱ne̱nki, najmi xi ndaha̱. Najmi xu̱ta̱ je jái̱ nchjaha̱, xu̱ta̱ ngatitsun ní jái̱ nchjaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nku ni̱yá nk'ie nga tjíntu kjintíá já ni'yakuyáha̱ Jua Bautista̱ ko̱ já fariseo̱, a̱s'a̱i tjín xi i̱ncha j'aisehe̱ Jesu ko̱ b'i̱ kitsúhu̱: —¿Nkú tjíhi̱n ra̱ nga najmi b'entu kjintíáha já ni'yakuyáhi̱, xi nkú ts'ín b'entu kjintíá já ni'yakuyáha̱ Jua ko̱ já ni'yakuyáni̱? ");
INSERT INTO majNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A̱s'a̱i b'i̱ kitsú Jesu: —¿A mahá b'entu kjintíá xu̱ta̱ xi tjíntujín nku s'í kju̱a̱bixan nk'ie nga tíjñajin saha̱ nda̱ bixoo̱n? Nk'ie nga tíjñajin saha̱ nda̱ bixoo̱n, najmi ka̱ma k'úéntu kjintíá. ");
INSERT INTO majNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tu̱nga ku̱i̱chúhú ni̱stjin nga chjú'aha̱ nda̱ bixoo̱n. Nk'ie nga ku̱i̱chú ni̱stjin xu'bo̱, nk'iehé nga k'úéntu kjintíá. ");
INSERT INTO majNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Najmi ch'a b'éstiko̱ho najyun chá nku te najyun tse̱tse̱ xi najmi kje̱e nibákú. A̱t'aha̱ nibákú najyun tse̱tse̱ ko̱ kjeti̱ya najyun chóo̱. B'a̱ ts'ín fi tsehe má kitiyá. ");
INSERT INTO majNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ko̱ ta̱ ndaha najmi ch'a binchá binu̱ tse̱tse̱ nku tsa tja̱ba̱xín chá. A̱t'aha̱ binu̱ tse̱tse̱ kjeti̱ya tsa tja̱ba̱xín chóo̱. A̱s'a̱i fi ndzjo binu̱ ko̱ batsun tsa tja̱ba̱xíu̱n. Kui nga tsa tja̱ba̱xín tse̱tse̱hé xincháha binu̱ tse̱tse̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nku xua̱tu̱ tíf'a Jesu má nga tjíntje̱ tuni̱ñu̱. A̱s'a̱i i̱ncha kikje'yún tuni̱ñu̱ já ni'yakuyáha̱ ko̱ kits'íntjiya ntsja nga kikjine. ");
INSERT INTO majNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A̱s'a̱i b'a̱ i̱ncha kitsúhu̱ Jesu já fariseo̱: —Cha̱se̱ ma ri̱. ¿Á ni xi tíjña nkjúhu̱n ra̱ kju̱a̱téxumoo̱ nga ni̱stjin nkjúu̱n tíi̱ncha ts'íhin já ni'yakuyáhi̱? ");
INSERT INTO majNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","B'i̱ kitsú Jesu: —¿A ndaha̱chí najmi kje̱e n'eyo má nga tjít'a ni xi kits'ín David nk'ie nga un kikiehe̱ ko̱ kama bjoho̱ kui ko̱ já xi tje̱nko̱ho̱? ");
INSERT INTO majNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kui ni̱stjiu̱n Abiatar tjíhi̱n nda̱ na̱'mi títjun. Jas'en David a̱nte nkjúhu̱n Nti̱a̱ná ko̱ kikjine ni̱nku̱a̱n nkjún xi tjíntu yo̱, ni xi tu̱ já na̱'miu̱ ma kjinehé. Ta̱ kitsjá yaha̱ ni̱nku̱o̱n já xi tje̱nko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","’Ni̱stjin nkjúu̱n kis'ejña ngandaha̱ xu̱ta̱, najmi ngandaha̱ ni̱stjin nkjúu̱n kamandaha xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kui nga Ntíhi̱ Nda̱x'i̱u̱n batéxumaha̱ ra̱ santaha ko̱ ni̱stjin nkjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nku ni̱yá jas'en Jesu ni'ya sinagoga̱ ko̱ yo̱ ta̱ kab'ejña nku nda̱ xi ch'ihi̱n ntsja. ");
INSERT INTO majNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kikunntá 'maha̱ jóo̱ tu̱ xi i̱ncha sku̱e̱he tsa ts'i̱ínnkihi̱ ndo̱ nga ni̱stjin nkjúu̱n, tu̱ xi b'a̱ ts'ín sa̱kúhu̱ ra̱ má tíndyjajihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A̱s'a̱i b'a̱ kitsúhu̱ Jesu nda̱ xi ch'ihi̱n ntsja: —Ti̱síntje̱i̱n ko̱ ti̱si̱njñai kamasee̱n. ");
INSERT INTO majNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A̱s'a̱i b'i̱ kitsúhu̱ jóo̱: —Jun, ¿mí nihi xi ma n'e nga ni̱stjin nkjúu̱n? ¿A ma n'e ni xi nda, a ra̱ ni xi najmi nda? ¿A ma n'ek'anki xu̱ta̱, a ra̱ ma n'ek'ien? Tu̱nga najmi kinchja̱há jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A̱s'a̱i kjan tsasehe̱ Jesu já xi kabinchandaihi̱ ko̱ kikie babaha̱ a̱t'aha̱ ndjá tjíntuyá ani̱ma̱ha̱ jóo̱. B'i̱ kitsúhu̱ nda̱ xi ch'ihi̱n ntsja: —Tjentei ntsa̱i̱. Kingjénte ntsja ndo̱ ko̱ kamanda. ");
INSERT INTO majNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tu̱nga nk'iehé nga tsitju já fariseo̱ yo̱, a̱s'a̱i kama ñjakúko̱ já xi yjanki nda̱ rei̱ Herode̱ Antipa̱ nga tsangisjai ni̱yáko̱ xi nkú ts'ín ka̱ma ts'i̱ínk'iehen Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","A̱s'a̱i ngjiko̱ t'axín Jesu já ni'yakuyáha̱ a̱ndai ntáchak'uu̱n. Ta̱ kitsjennkíhi̱ nkjin ṉkjún xu̱ta̱ xi i̱ncha niba a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ko̱ ta̱ i̱ncha kint'é ngayjee̱ ni xi títs'ín Jesu xu̱ta̱ xi tjín a̱nte Judea̱, xi tjín nanki Jerusalen, xi tjín a̱nte Idumea̱, xi tjín ngabantá ntáje̱ Jordan, ko̱ xi tjín a̱ndaihi̱ nanki Tiro̱ ko̱ nanki Sidon. Kui kju̱a̱ha nga i̱ncha j'aise tentehe̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A̱s'a̱i y'éxá Jesu já ni'yakuyáha̱ xi má nga k'u̱éndaha̱ nku tsutsu, tu̱ xi najmi ku̱a̱si̱nne'yúhu̱n ra̱ ngayjee̱ xu̱ta̱ nkjin xi kama ñjakú yo̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","A̱t'aha̱ ngatentee̱ xu̱ta̱ xi uhu̱n i̱xí tíi̱ncha basinne'yúhún ra̱ nga mjehe̱ ts'i̱ínko̱ho̱, a̱t'aha̱ nkjin ṉkjún maha xu̱ta̱ un xi kits'ínnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ko̱ máha jánindoo̱, nk'ie nga i̱ncha kikie Jesu, tsinchakúnch'int'aha̱ ko̱ b'i̱ i̱ncha kitsú nga kikjintáya: —¡Ji xi Ntíhi̱ Nti̱a̱ná! ");
INSERT INTO majNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tu̱nga ndjáhá kinchja̱ko̱ Jesu jánindoo̱ tu̱ xi najmi i̱ncha ku̱i̱tsu̱yaha yáha Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A̱s'a̱i ngjinji Jesu nku a̱sunntu tje̱nki̱. Kinchja̱ha̱ já xi j'ájin nga kj'u̱a̱ísehe̱ ko̱ i̱ncha j'ai jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Te jo maha já xi j'ájin tu̱ xi tsjénko̱ho̱ ra̱ ko̱ tu̱ xi ts'i̱ínkjihi nga k'u̱éni̱jmí éhe̱n Nti̱a̱ná. Já postru̱ kitsúhu̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kitsjáha̱ jóo̱ nga ngajoho̱ ts'i̱ínnkihi̱ ra̱ xu̱ta̱ ko̱ nga k'o̱nsje jáninda xi tjíntujíhi̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kui xu'bi̱ já te jo xi j'ájin Jesu: Simon xi kitsjá j'áíhi̱n nga kui xi ta̱ Pedro̱ k'úín; ");
INSERT INTO majNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago̱ ko̱ Jua xi nts'e̱ maha xinkjín, xi jáha̱ Zebedeo̱ maha. Jesu ta̱ kitsjá j'áíhi̱n já xi joo̱ nga ta̱ k'úín Boanerge̱, kui j'áín xi tsuhu̱ ra̱: Ntíhi̱ Ch'o̱n. ");
INSERT INTO majNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","J'ájin ya: Andre, Felipe̱, Bartolome, Mateo̱, Toma, Santiago̱ xi ntíhi̱ Alfeo̱, Tadeo̱, Simon xi mako̱ já cananista, ");
INSERT INTO majNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ko̱ Juda̱ Iscariote̱ xi a̱skahan kits'ínkjas'en Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A̱s'a̱i kik'óya ngáha Jesu ni'yaha̱ ko̱ ta̱ kama ñjakú ṉkjúhún ngáha xu̱ta̱, nga santaha najmi kama i̱ncha kikjine ni̱ñu̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nk'ie nga kint'é xu̱ta̱ xinkjín Jesu niu̱, i̱ncha j'aingisjaihi̱. A̱t'aha̱ b'a̱ kitsú xu̱ta̱ nga ja tíma luku̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Máha já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ xi i̱ncha nibaha nanki Jerusalen, kui xi b'a̱ kitsú: —Nda̱ninda Beelzebu xi nda̱ninda k'aku̱hu̱ jánindoo̱ tíjñajihi̱n nda̱i̱. Kui nga nga'yúhu̱n nda̱ninda k'aku̱hu̱ jánindoo̱ tím'osjeko̱ho jánindoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","A̱s'a̱i kinchja̱ha̱ Jesu jóo̱ ko̱ y'éjña chu̱ba̱yaha̱ nga tsakúya: —Jun, ¿nkú ts'ín ka̱maha tsa nda̱nindoo̱ ta̱ kuihi k'o̱nsje suba yjoho̱? ");
INSERT INTO majNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Xu̱ta̱ xi tjín má nga batéxuma nku nda̱ rei̱, tsa ta̱ kuihi fi kontra̱ha̱ xinkjín, ndaha̱chí najmi tse maha̱ má nga batéxuma nda̱ rei̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ko̱ tsa xu̱ta̱ xi tjíntu nku ni'ya fi kontra̱ha̱ xinkjín, ndaha̱chí najmi ta̱ s'ehe̱ ra̱ nga'yún. ");
INSERT INTO majNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","B'a̱ ta̱ ts'ín tíjña ts'e̱ nda̱nindoo̱. Tsa Satana ku̱a̱kjánya yjoho̱ nga ta̱ kuihi ngju̱a̱i̱ kontra̱ yjoho, ndaha̱chí najmi tse ka̱maha̱ nga k'úéjña. Tu̱ sa ní ku̱i̱chúkje ni̱stjihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ndaha nku najmi ma fas'en ni'yaha̱ nku nda̱ xi 'yún tjíhi̱n nga'yún ko̱ kjé'aha̱ ni xi tjíhín. Tjín níhi nga tjun k'u̱é'yún ndo̱. B'a̱ ts'ín ka̱ma kjé'aha̱ ra̱ ni xi tjíhi̱n ndo̱ ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Kju̱axi̱ ni xi tíxinnu̱u. Ka̱ma ndyjat'aha̱ ngatentee̱ ngatitsuhu̱n xu̱ta̱ ko̱ ngatentee̱ tu̱ mí én ch'on tsuhú ni xi kitsú. ");
INSERT INTO majNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tu̱nga xi ch'on ku̱i̱tsu̱hu̱ Espiri̱tu̱ Santo̱, kui xi najmi ta̱ ka̱ma ndyjat'aha̱ ra̱. Nku jé xi najmi ta̱ ka̱maha̱ ra̱ ndyja̱ha ts'i̱ín. ");
INSERT INTO majNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","B'a̱ kitsú Jesu a̱t'aha̱: “Nda̱nindoo̱ tíjñajihi̱n”, i̱ncha kitsú jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ja kamoo̱. J'ai na̱aha̱ ko̱ já nts'e̱ Jesu. Na̱tsiu̱n tsincha nga kits'ínkji xi ngji nchja̱ha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A̱s'a̱i xu̱ta̱ xi kab'entut'áha̱ b'a̱ kitsúhu̱: —Na̱ahi̱, já nts'ei ko̱ jminchjín nichjai kabincha na̱tsin ján. Mje rúhu̱ ku̱i̱nchja̱ko̱hi. ");
INSERT INTO majNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","B'i̱ kitsú Jesu: —¿Yá xi nána̱ ko̱ yá xi já nts'é? ");
INSERT INTO majNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A̱s'a̱i tsasehe̱ xu̱ta̱ xi kab'entut'áha̱ ko̱ b'i̱ kitsú: —Kui xu̱ta̱ xu'bi̱ xi nána̱ ko̱ já nts'é. ");
INSERT INTO majNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tu̱ yáhá ni xi ts'i̱íntjusun xi nkú ts'ín mjehe̱ Nti̱a̱ná, kui xi nda̱ nts'é, na̱ nichja ko̱ nána̱. ");
INSERT INTO majNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nku ni̱yá Jesu tsakúyaha̱ xu̱ta̱ éhe̱n Nti̱a̱ná a̱ndai ntáchak'uu̱n, ko̱ tu̱ ni xí nkjihín xu̱ta̱ kama ñjakút'aha̱. Kui nga nku tsutsu ngjik'iejñayaha ko̱ ngayjee̱ xu̱to̱ a̱ndai ntóo̱ tsincha. ");
INSERT INTO majNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nkjin tíkjá ni tsakúyaha̱ nga y'éjña chu̱ba̱yaha̱. B'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Tjenñju. Nku nda̱ ngjiténdzjo xujmá. ");
INSERT INTO majNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nk'ie nga tíbaténdzjo xujmóo̱, k'u̱a̱ xi tsixuntu a̱ndai ni̱yóo̱. A̱s'a̱i i̱ncha j'ai ni̱see̱ ko̱ kikjine xujmá xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","K'u̱a̱ xi tsixuntu a̱jin ndji̱o̱ má nga najmi 'yún tjín ninte. Ki̱tsa̱ jasu xujmóo̱, a̱t'aha̱ najmi 'yún tjain nintee̱. ");
INSERT INTO majNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tu̱nga nk'iehé nga tsitju ts'íu̱, kits'ínchjaha̱n ko̱ kixí, a̱t'aha̱ najmi 'yún ngjiyanji kja̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","K'u̱a̱ ngá xi tsixuntu a̱jin na'yóo̱. Kisá na'yóo̱ ko̱ najmi kitsjántehe̱ nga nda sa̱á xujmá xu'bo̱. Najmi chumi nihi kitsjá. ");
INSERT INTO majNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tu̱nga k'u̱a̱há ngá xi tsixuntu má nga nda nankiu̱. Jasu xujmá xu'bo̱ ko̱ kisá. Tu̱ xí tsehé ni xi kitsjá. Tjín xujmóo̱ xi kitsjá katé tjíhin, tjín xi kitsjá cháte ko̱ te tjíhin, ko̱ tjín ngá xi kitsjá unchan tjíhin. ");
INSERT INTO majNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ko̱ b'i̱ kitsú sa: —Xi tje̱n tja̱ba̱xínñju, katasínñju. ");
INSERT INTO majNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A̱skahan nk'ie nga y'ejña suba Jesu, xu̱ta̱ xi kabinchat'aha̱ ko̱ já ni'yakuyá xi te joo̱ i̱ncha kingjásjaiyaha̱ mí nihi xi tsakúya nga y'éjña chu̱ba̱ya. ");
INSERT INTO majNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A̱s'a̱i b'i̱ kitsú Jesu: —Jun ja kik'a̱i̱nu̱u nga ka̱mankjinnu̱u ni xi 'ma tíjña ts'e̱ xi nkú ts'ín batéxuma Nti̱a̱ná. Tu̱nga xu̱ta̱ xi k'oo̱ tu̱ s'ejña chu̱ba̱yahá ra̱, ");
INSERT INTO majNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","tu̱ xi ndaha tsa ku̱a̱se̱he tu̱nga najmi sku̱e̱hé, ko̱ ndaha tsa ku̱a̱sínñju tu̱nga najmi ka̱mankjihín ra̱. B'a̱ ts'ín najmi ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱ ko̱ najmi n'e̱ndyjat'aha̱ ra̱ ngatitsuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","B'i̱ kitsú ya Jesu: —¿A najmi mankjinnu̱u nkú tsuhu̱ ra̱ én xi kuak'iejñá chu̱ba̱ya? Tsa najmi kamankjinnu̱u, ¿nkú ts'ín ka̱mankjin tentehe̱nu̱u én xi bakuyá nga b'ejñá chu̱ba̱ya? ");
INSERT INTO majNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","’Nda̱ xi tsaténdzjo xujmóo̱, kui xi nkú joyaha xi b'éni̱jmí éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tjín xu̱ta̱ xi b'a̱ k'un xi nkú joyaha xujmá xi tsixuntu a̱ndai ni̱yóo̱. Nk'ie nga nt'é ée̱n, tje̱n'yún nibáhá Satana ko̱ kjexín én xi ja kis'entje̱jin ani̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","’Tjín ngá xu̱ta̱ xi b'a̱ k'un xi nkú joyaha xujmá xi tsixuntu a̱jin ndji̱o̱. Nk'ie nga nt'é ée̱n, tje̱n'yún tsjohó ts'ín ts'ínkjáíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tu̱nga najmi 'yúhún tjíhi̱n kja̱ma̱ a̱jin ani̱ma̱ha̱ ko̱ najmi ndjá bincha. Nk'ie nga sakúhu̱ kju̱a̱sti ko̱ nk'ie nga n'e uncha tu̱ nga̱t'aha̱ ée̱n, ts'ín t'axíhi̱n yjoho̱ ée̱n. ");
INSERT INTO majNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","’Tjín ngá xu̱ta̱ xi b'a̱ k'un xi nkú joyaha xujmá xi tsixuntu a̱jin na'yóo̱. Kui xu̱ta̱ha xi ta̱ nt'é ée̱n, ");
INSERT INTO majNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tu̱nga ni xi tjíhín a̱sunntei̱ s'enta̱ha̱ ra̱, kju̱a̱nchi̱nóo̱ b'ana̱cha̱ha̱, ko̱ ma mje tentehe̱ ni xi tjín. B'a̱ ts'ín najmi sakúntehe̱ ra̱ nga nda sa̱áha ée̱n a̱jin ani̱ma̱ha̱ xu̱ta̱ xu'bo̱ ko̱ najmi tsjá cha̱n. ");
INSERT INTO majNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","’Tu̱nga tjíhín xu̱ta̱ xi b'a̱ k'un xi nkú joyaha xujmá xi tsixuntu nanki xi ndoo̱. Kui xu̱ta̱ha xi nt'é ée̱n ko̱ ts'ínkjáíhi̱n. Nda ts'ín nga b'entu. Kui xi b'a̱ joyaha xujmá xi tsjá katé tjíhin, ko̱ tsa cháte ko̱ te tjíhin, ko̱ tsa unchan tjíhin. ");
INSERT INTO majNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","B'i̱ ta̱ kitsú sa Jesu: —¿A tjín xi b'éti nku nd'í tu̱ xi k'u̱éjñaha kintehe̱ nku kaxa̱ a ra̱ kintehe̱ nku kama̱? ¿A najmi b'éjña nk'ahá? ");
INSERT INTO majNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A̱t'aha̱ ngayjee̱ ni xi 'ma tíjña nd'a̱i̱, ku̱i̱chú ni̱stjin nga s'e̱jña chji. Ko̱ ngayjee̱ ni xi najmi tíjña chji nd'a̱i̱, ku̱i̱chú ni̱stjin nga ku̱i̱tju chji. ");
INSERT INTO majNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Xi tje̱n tja̱ba̱xínñju, katasínñju. ");
INSERT INTO majNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","B'i̱ ta̱ kitsú sa Jesu: —'Yún nda ta̱sinñjuhu̱u ni xi tínu'yó. Xi nkú ts'ín nda ku̱a̱sinñju, b'a̱ ts'ín nda ka̱mankjinnu̱u, ko̱ 'yún k'u̱a̱i̱ sanu̱u nga ka̱mankjinnu̱u ni xi tínu'yó. ");
INSERT INTO majNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A̱t'aha̱ xi ba̱sínñju ni xi bakuyá, kui xi k'u̱a̱i̱ saha̱ nga ka̱mankjihi̱n. Tu̱nga xi najmi ba̱sínñju, chjú'aha̱ santaha ni xi i̱chí mankjihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","B'i̱ ta̱ kitsú sa Jesu: —Má batéxuma Nti̱a̱ná, kui xi b'a̱ joyaha ni xi ma nk'ie nga nku nda̱ baténdzjo xujmá. ");
INSERT INTO majNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tsa kjife ndo̱ ko̱ tsa tíjña tík'un, ndaha tsa nga ni̱stjiu̱n ko̱ ndaha tsa nga ni̱stje̱n, fasu xujmóo̱ ko̱ sá. Najmi be ndo̱ á b'a̱ maha. ");
INSERT INTO majNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A̱t'aha̱ t'anankiu̱ ts'ín nga sá kui ni ján. Títjun tjuhu̱ nts'én, a̱s'a̱i tjuhu̱ xka̱, a̱skahan xu, ko̱ ja kamoo̱ s'ehe̱ xujmá. ");
INSERT INTO majNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nk'ie nga ja chu̱ba̱ha̱, a̱s'a̱i bate ndo̱ niu̱, a̱t'aha̱ ja kuichu ni̱stjin nga stí. ");
INSERT INTO majNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","B'i̱ ta̱ kitsú sa Jesu: —¿Mí nihi xi k'uejñá chu̱ba̱yako̱hona xi nkú ts'ín batéxuma Nti̱a̱ná? ¿Mí éhen xi ts'inchjén nga k'uejñá chu̱ba̱yahana? ");
INSERT INTO majNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kui xi nkú joyaha nku k'un mostasa̱ xi s'entje̱. Kui k'un xu'bi̱ xi 'yún i̱chí sa nga k'un xi k'oo̱ xi tjín a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tu̱nga nk'iehé nga ja s'entje̱, a̱s'a̱i sá ko̱ 'yún chánka ma sa nga ni ntje̱ xi k'oo̱. I ṉkjún ma tjiaha̱, nga santaha ni̱see̱ ts'ínnda'á nu̱ba̱ha̱ má nk'íéhe̱n tjiaha̱ yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu y'éjña chu̱ba̱yaha̱ xu̱ta̱ nga tsakúyaha̱. Ni xi ma chu̱ba̱yaha̱ ra̱ xu̱ta̱, kui nihi xi kits'ínchjén. ");
INSERT INTO majNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Najmi tsakúya tsa najmi y'éjña chu̱ba̱ya. Tu̱nga máha já ni'yakuyáha̱, najmi y'éjña chu̱ba̱yaha̱ nga tsakúyaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ta̱ kuihi ni̱stjin xu'bo̱ nkú ma nga ja tíma jyun, b'i̱ kitsúhu̱ Jesu já ni'yakuyáha̱: —Tjián ngabantá ján. ");
INSERT INTO majNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A̱s'a̱i kits'ínkji xu̱ta̱ nkjiu̱n ko̱ tsutsu xi tu̱ b'a̱ ts'ín jahá kab'eya i̱ncha ngjiko̱. Ta̱ i̱ncha kitsjennkíhi̱ kj'a̱í sa tsutsu. ");
INSERT INTO majNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tu̱ ni xi kamahá, tu̱ i̱ncha kamanehé nku ntjo̱ xi tu̱ xí 'yúhún, ko̱ t'éhe̱n ntáchak'uu̱n ni xi nkjún kits'íhi̱n tsutsuu̱, nga santaha ja ma tséhé ni ntánijua xi tífas'ehe̱n. ");
INSERT INTO majNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tu̱nga máha Jesu, kjife a̱stu̱n tsutsuu̱ nga kab'énki nku ni nintaku̱. A̱s'a̱i já ni'yakuyáha̱ ngji ts'ínkj'áha̱ ko̱ b'a̱ kitsúhu̱: —Ji nda̱ maestru̱, ¿á najmi nkjún tímaha ri? ¡Ja ku̱a̱yáá e̱i̱ ni̱! ");
INSERT INTO majNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","A̱s'a̱i tsisintje̱n Jesu ko̱ ndjá kinchja̱ko̱ ntjo̱ ko̱ ntáchak'uu̱n nga b'i̱ kitsúhu̱: —¡Tjenjyúí! ¡Tjent'íáhi̱! Kitsjenjyú ntjo̱ ko̱ kis'e jyujyu. ");
INSERT INTO majNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A̱s'a̱i b'a̱ kitsúhu̱ já ni'yakuyáha̱: —¿Á b'a̱ nkjún ts'ín binkjuhunnu? ¿Á najmi s'ejihi̱nnu̱u Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tu̱ xí i̱ncha kitsankjúhún jóo̱ ko̱ b'i̱ ngján b'i̱ kitsúhu̱ xinkjín: —¿Yá nda̱ha xu'bi̱ nga santaha ntjo̱ ko̱ ntáchak'uu̱n nt'é'éhe̱n ra̱? ");
INSERT INTO majNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A̱s'a̱i i̱ncha tsichu nankihi̱ xu̱ta̱ Gerasa̱, nanki xi tíjña ngabantá ntáchak'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nk'ie nga tsitjujen Jesu tsutsuu̱, tje̱n'yún j'aik'úhún ra̱ nku nda̱ xi tsitjujin tsjóo̱. Nda̱nindoo̱ tíjñajihi̱n ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A̱jin tsjóo̱ b'ejña ko̱ najmi ch'a ta̱ ma ts'ínk'íéjña'yúhu̱n ra̱, ndaha tsa n'úki̱cha̱ s'e̱'yúnko̱ho. ");
INSERT INTO majNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A̱t'aha̱ nkjin ṉkjún ni̱yá kis'e'yúnko̱ho n'úki̱cha̱ sjai ko̱ ntsja, tu̱nga kikjeti̱yahá n'úki̱cha̱ ntsja ko̱ kits'ín xi̱xi̱ n'úki̱cha̱ sjai. Najmi tjín xi ma ts'ínk'íéjña jyuhu̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ni̱stjin ni̱stje̱n fatsú'bajín tsjóo̱ ko̱ jñóo̱ nga kjintáya ko̱ nga ndji̱o̱ ts'ín'unko̱ho̱ ra̱ yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nk'ie nga kjin tje̱n sa Jesu, kikiehe̱ ndo̱ ko̱ tsangatsanka nga j'aisinkúnch'int'aha̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","'Yún kikjintáya nga b'i̱ kitsúhu̱: —Ji Jesu, Ntíhi̱ Nti̱a̱ nku tutu xi tíjña nk'a ján, ¿mí nihi xi tjínko̱hi an? Nti̱a̱ nku tutuu̱ tíbená. Tíbankihi nga najmi tu̱ 'ba̱i̱ní kju̱a̱ni̱ma̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","B'a̱ ts'ín kinchja̱ ndo̱ a̱t'aha̱ Jesu b'a̱ kitsúhu̱: —¡Ji nda̱ninda, ti̱tjusje̱jihi̱n ndo̱! ");
INSERT INTO majNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A̱s'a̱i Jesu kingjásjaiyaha̱: —¿Nkú 'mihi? B'a̱ kitsú jánindoo̱: —Legion 'mini̱ a̱t'aha̱ tu̱ xí nkjihín maha̱ni̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A̱s'a̱i 'yún ṉkjún i̱ncha tsankihi̱ Jesu nga najmi tu̱ ts'i̱ínkji t'axíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Xi tje̱hen nku a̱sunntu tje̱nki̱ nkjin ṉkjún chi̱nka̱ tíi̱ncha kjine jñá. ");
INSERT INTO majNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A̱s'a̱i jánindoo̱ i̱ncha tsankihi̱ Jesu: —N'e̱kjíni̱ má tjíma chi̱nko̱ tu̱ xi ku̱i̱tjás'e̱njihi̱n ri̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A̱s'a̱i Jesu kitsjántehe̱ jánindoo̱. I̱ncha tsitjujíhi̱n ndo̱ nga i̱ncha ngjikjas'enjihi̱n chi̱nko̱. Jo ra̱ mii̱ maha chi̱nko̱. Tsangatsanka chi̱nko̱ nga kikjaníkj'antjai yjoho̱ má nk'antjaihi̱ yo̱ ko̱ tsixuntujín ntáchak'uu̱n. Yo̱ jesunjin ntá. ");
INSERT INTO majNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A̱s'a̱i i̱ncha tsanka já xi tíi̱ncha kunntá chi̱nko̱. Ngji tsúyaha̱ xu̱ta̱ xi tjín a̱jin na̱nti̱o̱ ko̱ a̱ndai na̱nti̱o̱. A̱s'a̱i i̱ncha j'aisehe̱ xu̱ta̱ ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","J'ai má tíjña Jesu ko̱ kikie nga kab'ejña yo̱ nda̱ xi tsitjujíhi̱n jáninda xi tu̱ xí nkjihín maha. Ja yja ngáha najyun ko̱ ja nda je je ngáha. I̱ncha kitsankjún jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Já xi kikie ni xi kamoo̱ i̱ncha kitsúyaha̱ xu̱ta̱ xingisoo̱ ni xi kamaha̱ ndo̱ ko̱ ni xi i̱ncha kamaha̱ chi̱nko̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","A̱s'a̱i xu̱ta̱ na̱nti̱o̱ tsankihi̱ Jesu nga ku̱i̱tju nankihi̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nk'ie nga tífas'en ngáha Jesu tsutsuu̱, nda̱ xi tsitjujíhi̱n jánindoo̱ mjehe̱ nga tsjénnkihi̱ ko̱ tsankihi̱ kju̱a̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tu̱nga najmi kitsjántehé ra̱ Jesu. B'i̱ kitsúhu̱: —T'in ni'yahi̱ ko̱ t'ihi̱nse̱i̱hi̱ xu̱ta̱ xinki̱. T'inyaihi̱ ngayjee̱ ni xi kuats'ínko̱hi Nti̱a̱ná ko̱ xi nkú ts'ín kama ni̱ma̱ha̱ ji. ");
INSERT INTO majNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A̱s'a̱i ngji ndo̱ ko̱ kik'atuts'i̱hi̱n nga kitsúya a̱nte Decapo̱li̱ ngayjee̱ ni xi kits'ínko̱ho̱ Jesu. Ngatentee̱ xu̱ta̱ xi tjín yo̱ i̱ncha kama nkjúhu̱n niu̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nk'ie nga ja kik'óyako̱ ngáha Jesu tsutsuu̱ ngabantá ntáchak'uu̱n, a̱s'a̱i nkjin ṉkjún xu̱ta̱ kama ñjakút'aha̱ ko̱ y'ejña Jesu a̱ndai ntáchak'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","A̱s'a̱i j'ai nku nda̱ xi 'mi Jairo̱ xi ta̱ nku nda̱ k'aku̱hu̱ ni'ya sinagoga̱. Nk'ie nga kikie Jesu, tsasinkúnch'int'aha̱ ");
INSERT INTO majNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ko̱ tsankihi̱ nga ku̱a̱si̱nko̱ho̱. B'i̱ kitsúhu̱: —Ta̱kjín i̱chína̱ ja tí'me. Nibángjennéí ntsa̱i̱ ntína̱ tu̱ xi ka̱mandaha ko̱ kj'u̱a̱íya ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","A̱s'a̱i ngjiko̱ Jesu ndo̱, ko̱ nkjin ṉkjún xu̱ta̱ kitsjennkíhi̱ nga i̱xí tsinchane'yúhún ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ta̱ tje̱njihi̱n xu̱ta̱ nkjiu̱n nku ta̱chju̱ún xi tjíhi̱n te jo nú nga jní títs'ínk'iehe̱n. ");
INSERT INTO majNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kui xi nkjin kju̱a̱ni̱ma̱ kikie a̱ya ntsja já chji̱ne̱nkiu̱. Santaha kits'ínkje ngayjee̱ ni xi tjíhín, tu̱nga ndahá i̱chí najmi kamanda. Tu̱ sa ní 'yún ngjitse ch'ihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nk'ie nga kint'é ta̱chjúu̱n ni xi títs'ín Jesu, a̱s'a̱i j'ai tje̱nnki Jesu a̱jihi̱n xu̱ta̱ nkjiu̱n. J'aik'úhu̱n ko̱ kits'ínko̱ najyun xi yja Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","A̱t'aha̱ b'i̱ ts'ín kits'ínnkjink'un: “Tsa tu̱ najyuhu̱n ts'inko̱ sa, ka̱manda ngáhana.” ");
INSERT INTO majNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nk'ie nga b'a̱ kits'ín, tje̱n'yún kitikjáyahá ra̱ jníu̱ ko̱ ndzjen kamaha̱ yjonintehe̱ ta̱chjúu̱n nga kama nkihi̱ ch'in xi k'uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tu̱nga kikiehé Jesu nga tsitjujíhi̱n nga'yún. Kits'ínk'ótjiya nga tsasehe̱ xu̱ta̱ nkjiu̱n ko̱ b'i̱ kitsúhu̱: —¿Yá xi kuats'ínko̱ najyunna̱? ");
INSERT INTO majNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A̱s'a̱i b'a̱ kitsú já ni'yakuyáha̱: —Tíyai nga xu̱ta̱ nkjiu̱n tíbasinne'yíhin. Á: “¿Yá xi kuats'ínko̱ najyunna̱?”, tíbixíhinni. ");
INSERT INTO majNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tu̱nga tu̱ nku nga tsasehé ra̱ Jesu xu̱ta̱ xi kabinchandaihi̱ tu̱ xi sku̱e̱he yá xi b'a̱ kits'íu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Máha ta̱chjúu̱n, nk'ie nga kikie ni xi kamat'ain, a̱s'a̱i i̱xí ts'atsé nkjúhún nga j'aisinkúnch'int'aha̱ Jesu ko̱ kitsúya kixi̱ kixi̱hi̱ mí kju̱a̱ha nga b'a̱ kits'íhin. ");
INSERT INTO majNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A̱s'a̱i b'i̱ kitsúhu̱ Jesu: —Ji ntína̱, a̱t'aha̱ kuas'ejihin nga Nti̱a̱ná kits'ín nibána, kui nga kama nkihi ri. Kas'ehi kju̱a̱jyu nga t'in ko̱ katumandaihi̱ ch'in xi k'uhin. ");
INSERT INTO majNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nk'ie nga b'a̱ ta̱ títsuhu Jesu, tu̱ i̱ncha j'aihí k'u̱a̱ já xi nibaha ni'yaha̱ nda̱ k'aku̱hu̱ ni'ya sinagoga̱ ko̱ b'a̱ i̱ncha kitsúhu̱: —Ja k'uen ta̱kjíhi̱n. Najmi ta̱ n'estihi̱ ri̱ nda̱ maestru̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tu̱nga najmi kits'ínsihín ra̱ Jesu ni xi kitsú jóo̱. A̱s'a̱i b'i̱ kitsúhu̱ ndo̱: —Najmi tu̱ binkjuin. Tu̱ nkú kas'ejihín ri an. ");
INSERT INTO majNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Najmi kitsjánte Jesu tsa kj'a̱í xu̱ta̱ tsjénnkihi̱, tu̱ Pedro̱ sahá, Santiago̱ ko̱ Jua xi nts'e̱ maha Santiago̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nk'ie nga i̱ncha tsichu ni'yaha̱ nda̱ k'aku̱, kikie Jesu nga xa̱áha̱n tíma ko̱ nga tíi̱ncha kjintá xu̱ta̱ nga 'yún tíi̱ncha kjintáya. ");
INSERT INTO majNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A̱s'a̱i jas'en Jesu ko̱ b'i̱ kitsú: —¿Á xa̱áha̱n tín'ehenu ko̱ tích'íhinu? Najmi ka'me ta̱kjíu̱n. Tu̱ kjifehé. ");
INSERT INTO majNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tsajnukiehe̱ xu̱ta̱ xi kama ñjakú yo̱, tu̱nga kik'onsjehé Jesu ngatentee̱ xu̱to̱. A̱s'a̱i tu̱ na̱'mihi̱ ní ko̱ na̱aha̱ ta̱kjíu̱n ko̱ já ni'yakuyáha̱ xi tje̱nko̱, kui xi jas'enko̱ má xi tje̱hen kjijña ta̱kjíu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jakj'á ntsja ko̱ b'i̱ kitsúhu̱: —Talita̱, kuu̱m —kui éi̱n xi tsuhu̱ ra̱: Ta̱kjín, ji tínchjako̱ho, ti̱síntje̱i̱n. ");
INSERT INTO majNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tje̱n'yún tsisintje̱hén ta̱kjíu̱n ko̱ kikjatsú'ba ngáha. Tu̱ ni xí kama nkjúhu̱n ra̱ xu̱ta̱ xi tjíntu yo̱ ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tu̱nga b'a̱há kitsú Jesu nga najmi tu̱ ch'a xi k'úínyaha̱ niu̱. Ko̱ b'a̱ kitsú nga k'u̱a̱i̱hi̱ nichine ta̱kjíu̱n. Te jo nú tjíhi̱n ta̱kjíu̱n nga b'a̱ kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A̱s'a̱i tsitju Jesu yo̱ nga ngji ngáha nankihi̱ ko̱ kitsjennkíhi̱ já ni'yakuyáha̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nk'ie nga tsichu xua̱tu̱ tsakúya ni'ya sinagoga̱. Kama nkjúhu̱n xu̱ta̱ xi tjín yo̱ nk'ie nga kint'é xi nkú ts'ín tíbakúya. B'a̱ i̱ncha kitsúhu̱ xinkjín: —¿Má ngjikj'áha nda̱i̱ ngayjee̱ ni xu'bi̱? ¿Mí kju̱a̱nkjink'un na̱nka̱ha xi kik'a̱i̱hi̱ ko̱ á maha̱ ra̱ ts'íhin kju̱a̱nkjún? ");
INSERT INTO majNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿A najmi kuihí nda̱i̱ xi nda̱ chji̱ne̱yóo̱, xi ntíhi̱ Maria̱ ko̱ já nts'e̱ maha Santiago̱, Kuse, Juda̱ ko̱ Simon? ¿A najmi e̱i̱hí ta̱ tjíntujínná jminchjín nichja nda̱i̱? Kui nga najmi i̱ncha kama kits'ínkjáíhi̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tu̱nga b'a̱há kitsúhu̱ Jesu xu̱ta̱ nkjiu̱n: —Tu̱ má xi tje̱hén ni yankjún nku nda̱ profeta̱. Nkuhú nankihi̱ ko̱ a̱jihi̱n xu̱ta̱ xinkjín ko̱ ni'yaha̱ najmi b'a̱ n'ehe̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ndaha nku kju̱a̱nkjún najmi kamaha̱ kits'ín yo̱. Tu̱ chubahá xu̱ta̱ un xi kingjénne ntsja nga kits'ínnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kama nkjúhu̱n Jesu, a̱t'aha̱ najmi s'ejihi̱n xu̱ta̱ nga Nti̱a̱ná kits'ín nibáha̱. Kikjatsú'ba Jesu nga tsakúya a̱nte xi tjíndai yo̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A̱s'a̱i kinchja̱ha̱ já ni'yakuyá xi te joo̱ ko̱ kik'atuts'i̱hi̱n nga jo jo kits'ínk'a xinkjín nga kits'ínkji. Kitsjáha̱ nga ngajoho̱ Jesu ka̱maha̱ jóo̱ k'o̱nsje jáninda xi tjíntujíhi̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","B'a̱ kitsúhu̱ nga najmi chumi nihi xi k'u̱a̱ nga i̱ncha ts'i̱ín ni̱yá, tu̱ yánisehé xi ka̱ma k'u̱a̱. Najmi tjíhin nga k'u̱a̱ ni̱nku̱a̱n, ta̱ ndaha tsa, ta̱ ndaha to̱on. ");
INSERT INTO majNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ka̱ma ngju̱áya tja̱ba̱xín ntéhe̱, tu̱nga najmi ka̱mahá k'u̱a̱ tsa jo 'yún najyun. B'i̱ kitsúhu̱ jóo̱: ");
INSERT INTO majNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—Má ku̱i̱tjás'o̱on nku ni'ya, yo̱ ti̱ntsu̱bo̱o santa nkúhu nga ku̱i̱tju ngáhanu a̱nte xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tsa tjín má najmi n'e̱kjáínnu̱u, ko̱ tsa najmi ngju̱énñjunu̱u xu̱ta̱ xi tjín yo̱, tu̱ sahá ti̱tjusjo̱o a̱nte xu'bo̱ ko̱ t'etsujno ndyjo tsu̱ku, tu̱ xi b'a̱ ts'ín ku̱a̱kúchjihinu nga tje̱he̱n jé xu̱ta̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A̱s'a̱i i̱ncha tsitju jóo̱ ko̱ y'éni̱jmíhi̱ xu̱ta̱ nga tjíhin nga i̱ncha ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nkjin ṉkjún jáninda i̱ncha kik'onsjejihi̱n xu̱ta̱, ko̱ nkjin ṉkjún xu̱ta̱ un i̱ncha kits'ínnkihi̱ nga kik'onjnuhu̱ seti̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nda̱ rei̱ Herode̱ Antipa̱ ta̱ kint'é ni xi títs'ín Jesu, a̱t'aha̱ tu̱ má kichubani̱jmíyahá ni Jesu. A̱s'a̱i b'a̱ kitsú: —Jua Bautista̱ ja j'áíya ngáha̱ ra̱ ngabayoo̱. Kui kju̱a̱ha nga tjíhi̱n ra̱ nga'yún nga títs'íhin kju̱a̱nkjún. ");
INSERT INTO majNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","K'u̱a̱ xu̱ta̱ xi b'a̱ i̱ncha kitsú: —Nda̱ profeta̱ Elia̱ niu̱. K'u̱a̱ ngá xi b'a̱ i̱ncha kitsú: —Nku nda̱ profeta̱ niu̱ xi nkúhu já profeta̱ xi kis'e nú chá ján. ");
INSERT INTO majNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tu̱nga máha Herode̱, nk'ie nga kint'é ni xi tíi̱ncha tsu xu̱ta̱, a̱s'a̱i b'a̱ kitsú: —Jua niu̱. Nda̱ xi an kitsja kju̱a̱ nga kitikjá nintaku̱. Ja j'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","B'a̱ kitsú Herode̱ a̱t'aha̱ kits'ínkji já juhu̱n nga jakj'ánijé Jua. Y'é'yún ko̱ kits'ínkjas'en nu̱ba̱yóo̱. Nga̱t'aha̱ na̱ Herodia̱ b'a̱ kits'íhin a̱t'aha̱ chju̱úhu̱n Felipe̱ kama na̱ Herodia̱, ko̱ ndo̱ ngá nts'e̱ kamaha Herode̱ tu̱nga Herode̱ y'ejñako̱ no̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","B'i̱ kitsú Jua nga kinchja̱ko̱ Herode̱ nk'ie: —Tíjña nkjúhu̱n kju̱a̱téxumoo̱ ni xi tín'ei, nga ta̱ jihi tinchunko̱i̱ chju̱úhu̱n nda̱ nts'ei. ");
INSERT INTO majNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kui nga na̱ Herodia̱ kits'ín unkiehe Jua ko̱ kama mjehe̱ nga ts'i̱ínk'ien, tu̱nga najmi tjíhín nkú ts'i̱íhi̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","A̱t'aha̱ be Herode̱ nga Nti̱a̱ná ts'e̱he̱ ndo̱ ko̱ na̱xu̱ ts'ín. Kui nga tsankjúhun ko̱ kuhu̱n ra̱. Nk'ie nga nt'é ni xi tsuhu̱ Jua, najmi be mí nihi xi ts'i̱ín tu̱nga tsjohó maha̱ nga mjéñjuhu̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tu̱nga tu̱ chahán tsichu ni̱stjin nga kisakú ni̱yáha̱ na̱ Herodia̱ nk'ie nga tsichu nú Herode̱. Kui ni̱stjiu̱n ts'asje Herode̱ nku s'í ko̱ kitsúyaha̱ já k'aku̱hu̱ ko̱ já jun k'aku̱hu̱ ko̱ já títjun xi tjín a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","A̱s'a̱i jas'en ta̱kjíhi̱n na̱ Herodia̱ nga kitenki. Tsjo ṉkjún kamaha̱ Herode̱ ko̱ já xi kab'entut'áko̱ho̱ yámixo̱ ko̱ b'i̱ kitsúhu̱ ta̱kjíu̱n: —Ti̱nchíní tu̱ mí ni xi mjehé ri. Tsjaha. ");
INSERT INTO majNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Xí Nti̱a̱náhá kits'ínkie nda̱ rei̱ nga b'a̱ kitsú: —Tsjaha tu̱ mí nihí ni xi ku̱i̱nchíní santaha masen ni xi batexumaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A̱s'a̱i tsitju ta̱kjíu̱n nga ngjingjásjaiyaha̱ na̱aha̱: —¿Mí nihi xi kuankia? B'i̱ kitsú na̱ Herodia̱: —Nintaku̱ Jua Bautista̱ ti̱nchíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A̱s'a̱i jas'en tsuntsu ngáha ta̱kjíu̱n má xi tje̱hen kab'ejña nda̱ rei̱ ko̱ tsankihi̱ niu̱: —Mjena nga k'u̱a̱i̱ní nd'a̱i̱ mamai̱ nga k'úéya ta̱ba̱ ní nintaku̱ Jua Bautista̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A̱s'a̱i 'yún kik'ie babaha̱ nda̱ rei̱, tu̱nga nga̱t'aha̱ ní nga ja kats'ínkie Nti̱a̱ná nga ts'i̱íntjusun éhe̱n ko̱ nga̱t'aha̱ já xi kab'entut'áko̱ho̱ yámixo̱, kui nga najmi tjín nkú ts'ín najmi ku̱i̱tsu̱hu̱ ra̱ ta̱kjíu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tje̱n'yún kits'ínkjihí nda̱ rei̱ nku nda̱ jun nga kitsjáha̱ kju̱a̱ nga kj'u̱a̱íko̱ nintaku̱ Jua. A̱s'a̱i ngji nda̱ juu̱n ko̱ tsatekjá nintaku̱ Jua a̱ya nu̱ba̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nku ta̱ba̱ y'éya nintaku̱ Jua ko̱ kitsjáha̱ ta̱kjíu̱n, ko̱ na̱aha̱ ta̱kjíu̱n kits'ínkjas'ehe̱n nintaku̱ Jua. ");
INSERT INTO majNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nk'ie nga kint'é já ni'yakuyáha̱ Jua ni xi kamoo̱, i̱ncha j'aikj'á yjoninte k'ie̱n ko̱ i̱ncha ngjingjáyanji. ");
INSERT INTO majNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ta̱ i̱ncha kama ñjakú ngáha já postru̱ má tíjña Jesu ko̱ i̱ncha kitsúya tentehe̱ ni xi kits'ín ko̱ ni xi tsakúya. A̱s'a̱i b'i̱ kitsú Jesu: ");
INSERT INTO majNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","—Nibá su̱bo̱o. Tankíaán nku a̱nte t'axín tu̱ xi n'e̱kj'áíyahaná. A̱t'aha̱ nkjin ṉkjún xu̱ta̱ xi tíi̱ncha fi ko̱ xi tíi̱ncha f'ai, nga santaha najmi ta̱ tíi̱ncha sakúntehe̱ ra̱ tsa i̱ncha kji̱ne̱ ni̱ñu̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","A̱s'a̱i i̱ncha y'eya nku tsutsu nga ngji t'axín suba nku a̱nte má najmi ch'a tjín. ");
INSERT INTO majNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tu̱nga nkjihín xu̱ta̱ xi kikiehe̱ nga i̱ncha ngji ko̱ i̱ncha kamankjihi̱n nga Jesu niu̱ ko̱ já ni'yakuyáha̱. A̱s'a̱i i̱ncha tsitju xu̱ta̱ xi tjíntu ngayjee̱ nanki xi tjín yo̱ nga tsu̱ku̱ ngjihi má nga tífi Jesu. I̱ncha tsichu títjun xu̱to̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nk'ie nga tsitjujen Jesu tsutsuu̱, kikie nga nkjin ṉkjún maha xu̱ta̱ xi tíkuyáha̱. Kama ni̱ma̱ha̱, a̱t'aha̱ tjíma xi nkú joyaha chu̱tsa̱nka̱ xi najmi tjíhi̱n nda̱ bastu. A̱s'a̱i kik'atuts'i̱hi̱n nga tsakúyaha̱ nkjin tíkjá ni. ");
INSERT INTO majNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nk'ie nga kama ngixuu̱n, i̱ncha j'aik'úhu̱n já ni'yakuyáha̱ ko̱ b'a̱ kitsúhu̱: —T'axínt'a ṉkjún e̱i̱ ko̱ ja kama ngixun ṉkjún. ");
INSERT INTO majNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tu̱ sahá b'a̱ t'ihi̱n xu̱to̱ nga katji nanki xi tjíndai e̱i̱ má nga ka̱ma k'u̱a̱tse ni xi kji̱ne̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A̱s'a̱i b'i̱ kitsú Jesu: —Tu̱ sahá jun tjoho̱on ni xi kji̱ne̱. B'a̱ kitsú jóo̱: —¿A kuankín ch'a̱tse níi̱ jo unchan denari̱o̱ tjíhin ni̱nku̱a̱n ko̱ k'u̱a̱i̱hi̱ nga kji̱ne̱ xu̱ta̱? ");
INSERT INTO majNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","B'i̱ kitsú Jesu nga kingjásjaiyaha̱ jóo̱: —¿Nkú tjín maha ni̱nku̱a̱n xi kich'o? Tankínk'iexki̱u. Nk'ie nga ja b'a̱ kits'ín jóo̱, a̱s'a̱i b'a̱ kitsú: —Un ni̱nku̱a̱n ko̱ jo tji̱o̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A̱s'a̱i b'a̱ kitsúhu̱ xu̱ta̱ nkjiu̱n nga k'úéntu stín a̱jin na̱xi̱chu̱ xkjúe̱n. ");
INSERT INTO majNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tjín xi unchan kik'a stín yjoho̱ nga i̱ncha y'entu, ko̱ tjín xi cháte kik'a stín yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A̱s'a̱i jakj'á Jesu ni̱nku̱a̱n xi uu̱n ko̱ tji̱o̱ xi joo̱. Tsasenjinki nk'a ján nga kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná. Tsakjánya ni̱nku̱o̱n ko̱ kitsjáha̱ já ni'yakuyáha̱ tu̱ xi kui i̱ncha ts'i̱ínndzjoho ni̱nku̱o̱n. Ta̱ tsakjánya tji̱o̱ xi joo̱ nga kitsjáha̱ ngatentee̱ xu̱to̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ngatentee̱ xu̱to̱ i̱ncha kikjine niu̱ santa nkúhu nga i̱ncha kitse sisihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A̱s'a̱i j'áíya ni̱nku̱o̱n ko̱ tji̱o̱ xi tsankiu̱. Te jo ni̱si̱n kamaha. ");
INSERT INTO majNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Un mii̱ maha já xi i̱ncha kikjine ni̱nku̱o̱n kui chu̱bo̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A̱s'a̱i b'a̱ kitsúhu̱ Jesu já ni'yakuyáha̱ nga i̱ncha kju̱a̱s'en tsutsuu̱ ko̱ nga i̱ncha ngju̱a̱i̱ títjuhu̱n ngabantá ntáchak'uu̱n xi tje̱hen nanki Betsaida̱, ko̱ tsasín ni̱yá xu̱to̱ nk'ie nga i̱ncha ngji ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nk'ie nga ja kits'ínkji xu̱to̱, a̱s'a̱i ngji nchja̱ko̱ t'axín Nti̱a̱ná a̱sunntu tje̱nki̱u̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nk'ie nga ja kama jyuu̱n, ja kamasehe̱n ntáchak'uu̱n tje̱njin tsutsuu̱. Tu̱nga máha Jesu, má kixiu̱ kab'ejña. ");
INSERT INTO majNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A̱s'a̱i kikie nga 'ni ṉkjún tíkjenntá já ni'yakuyóo̱, a̱t'aha̱ ntjo̱ 'yún ṉkjún tísatéjihi̱n tsutsuu̱. Nkú ra̱ ma nga ja tífi ma sen, tsichu tje̱nnki Jesu jóo̱ nga tífisun ntáchak'uu̱n. B'a̱ kits'ín xi kju̱a̱t'a ni̱yáha̱ jóo̱ kits'ín. ");
INSERT INTO majNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nk'ie nga kikie já ni'yakuyóo̱ nga Jesu nibásun ntáchak'uu̱n, se̱n kits'ín maha̱ ko̱ i̱ncha kikjintáya nkjún. ");
INSERT INTO majNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","A̱t'aha̱ ngatentee̱ i̱ncha kikiehe̱ ko̱ i̱ncha kitsankjún. Tu̱nga tje̱n'yún kinchja̱há Jesu: —¡Jyu ní! ¡Ahán niu̱! ¡Najmi tu̱ binkjun! ");
INSERT INTO majNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A̱s'a̱i jas'enne Jesu jóo̱ ko̱ kitsjenjyúya ntjo̱. Tu̱ ni xí kama nkjúhún ra̱ jóo̱, ");
INSERT INTO majNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","a̱t'aha̱ najmi kje̱e mankjihi̱n nkú tsuhu̱ ra̱ kju̱a̱nkjúhu̱n ni̱nku̱a̱n xi i̱ncha kikjine, a̱t'aha̱ ndjá tjíntuyá ani̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nk'ie nga ja j'atikjáko̱ Jesu já ni'yakuyáha̱ ntáchak'uu̱n, a̱s'a̱i tsichu nanki Genesaret. Yo̱ a̱ndai ntáchak'uu̱n y'ét'a'yún tsutsuu̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nk'ie nga i̱ncha tsitju tsutsuu̱, tu̱ tje̱n'yún i̱ncha kamankjihín ra̱ xu̱ta̱ xi tjín yo̱ nga Jesu niu̱. ");
INSERT INTO majNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A̱s'a̱i xu̱to̱ i̱ncha ngji ngayjee̱ a̱nte xi tjín yo̱ nga ngji ts'ínkint'é xinkjín. I̱ncha ngjiko̱ xu̱ta̱ un xi tjíhi̱n má xi tje̱hen i̱ncha kint'é nga tsú'ba̱ Jesu nga kjintusún na̱chaha̱n. ");
INSERT INTO majNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tu̱ má a̱ntehé ni xi jas'en Jesu, ndaha tsa a̱nte xi xi̱xi̱, ndaha tsa xi ihi̱, ko̱ ndaha tsa a̱ndai na̱nti̱a̱, i̱ncha kikjántu a̱ya ni̱yátée̱ xu̱ta̱ un xi tjíhi̱n ko̱ tsankihi̱ tsa tsjántehe̱ tsa tu̱ a̱ndai tuts'in najyun xi yja ts'i̱ínko̱. Ko̱ kamanda ngayjee̱ xi kits'ínko̱ najyuhu̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A̱s'a̱i i̱ncha j'aisehe̱ Jesu já fariseo̱ ko̱ k'u̱a̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ xi nibaha nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kinchja̱yane k'u̱a̱ já ni'yakuyáha̱ Jesu nk'ie nga i̱ncha kikie nga tíi̱ncha kjine ni̱ñu̱ nga najmi tjun bané ntsja. Kui xi tsuhu̱ ra̱ nga najmi i̱ncha ts'íntjusun sihi̱n ntje̱ cháha̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A̱t'aha̱ ngayjee̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ ts'íntjusun sihi̱n ntje̱ cháha̱, nga najmi i̱ncha kjine ni̱ñu̱ tsa najmi títjun bané ntsja xi nkú ts'ín tíjñaha̱. 'Yún sa b'a̱ ts'ín já fariseo̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Xu̱ta̱ judio̱ nk'ie nga i̱ncha f'aihi ni̱yátée̱, títjun bané sisin ntsja ko̱ a̱s'a̱i i̱ncha kjine ni̱ñu̱. B'a̱ ts'ín i̱ncha ts'íntjusuhun sihi̱n ntje̱ cháha̱. Ko̱ tjíntu saha̱ kj'a̱i̱hí sin xi nkúhu ts'e̱ chu̱tsíhi̱n, ndji̱í ntánijuaha̱, staña̱ha̱ ko̱ kama̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kui kju̱a̱ha nga já fariseo̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ kingjásjaiyaha̱ ra̱ Jesu: —¿Á najmi ts'íntjusuhun já ni'yakuyáhi̱ sin xi y'éjñaná ntje̱ cháná, nga tu̱ b'a̱há tjíu̱n kjinehe ni̱ñu̱? Najmi títjun bané ntsja. ");
INSERT INTO majNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A̱s'a̱ b'i̱ kitsú Jesu: —¡Tu̱ tsjohónu̱u nga bakuchíú xi nkú ts'ín yankjún Nti̱a̱ná! Kju̱axi̱ kjáíhin ni xi kitsú nda̱ profeta̱ Isaia̱ nk'ie nga b'a̱ ts'ín y'ét'a: Kui xu̱ta̱ xu'bi̱ tu̱ ts'ahá benkjúnna, tu̱nga ani̱ma̱ha̱ kjin tíjñaha̱ an. ");
INSERT INTO majNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Najmi chumi ni chjíhi̱ ra̱ chje̱ xi tsjána, a̱t'aha̱ tu̱ kju̱a̱téxumaha̱ xu̱ta̱há bakúya. ");
INSERT INTO majNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","A̱t'aha̱ jun n'e t'axíún ni xi y'éjña Nti̱a̱ná nga tu̱ sahá sin xi y'éjña xu̱ta̱ n'etjusun. ");
INSERT INTO majNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","B'i̱ kitsú ya Jesu: —Jun ja ya sisiun xi nkú ts'ín n'e t'axíún ni xi y'éjña Nti̱a̱ná tu̱ xi sinnu̱u n'etjusuhunnu. ");
INSERT INTO majNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","B'i̱ ts'ín y'ét'a Moise éhe̱n Nti̱a̱ná: “Cha̱nkjúín na̱'mihi̱ ko̱ na̱ahi̱.” Ko̱ ta̱ y'ét'a ya: “Xi ch'on ku̱i̱tsu̱hu̱ na̱'mihi̱ ko̱ tsa na̱aha̱, kui xi tjíhin nga n'e̱k'ien.” ");
INSERT INTO majNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","’Tu̱nga juhún b'a̱ bixíún nga tsa tjín xi b'i̱ ku̱i̱tsu̱hu̱ na̱'mihi̱ ko̱ tsa na̱aha̱: “Ngayjee̱ ni xi tjínna nga kúási̱nko̱ho kai, ja chje̱ kitsjaha̱ Nti̱a̱ná”, ");
INSERT INTO majNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tsa tjín xi b'a̱ ku̱i̱tsu̱, kui xi najmi ta̱ tjíhín ra̱ kju̱a̱'yún tsa ku̱a̱si̱nko̱ na̱'mihi̱ ko̱ tsa na̱aha̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nk'ie nga b'a̱ bixíún najmi ta̱ n'echjíhinu éhe̱n Nti̱a̱ná tu̱ nga̱t'aha̱ sin xi kin'ekjas'ennu̱u ko̱ xi b'i̱ ngján n'ek'atiya ngáha̱ ru̱u xinki̱u. Ko̱ nkjin sa ni xi nkúhu xu'bi̱ n'etjusun yo. ");
INSERT INTO majNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A̱s'a̱i b'i̱ kitsúhu̱ Jesu xu̱ta̱ nkjiu̱n: —Tjenñju tentenú ko̱ katumankjinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ndaha nku ni xi nibáha na̱tsin ján nga fas'enjihi̱n xu̱ta̱, najmi ma ts'ín sihi̱ nginku̱n Nti̱a̱ná. Ni xi bitjujín níhi̱ xu̱ta̱, kui ní nihi xi ts'ín sihi̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Xi tje̱n tja̱ba̱xínñju, katasínñju. ");
INSERT INTO majNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nk'ie nga ngji t'axíhi̱n xu̱ta̱ ko̱ jas'en ni'yoo̱, a̱s'a̱i já ni'yakuyáha̱ kingjásjaiyaha̱ nkú tsuhu̱ ra̱ én xi yéjña chu̱ba̱ya nga tsakúya. ");
INSERT INTO majNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","B'i̱ kitsú Jesu: —¿A ta̱ ndaha jun najmi mankjinnu̱u? ¿A najmi yanú nga ngayjee̱ ni xi nibáha na̱tsin ján nga fas'enjihi̱n xu̱ta̱, najmi ma ts'ín sihi̱ nginku̱n Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","A̱t'aha̱ najmi ani̱ma̱ha̱ fas'enjin niu̱. Tu̱ a̱ya ka̱ts'a̱há fas'en ko̱ f'aya, a̱s'a̱i bitju ngáha. B'a̱ ts'ín kitsúyaha nga ndaha nku nichine xi tjín najmi ma ts'ín sihi̱ xu̱ta̱ nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","B'a̱ ta̱ kitsú ya: —Ni xi bitju ní ts'a xu̱ta̱, kui ní nihi xi ts'ín sihi̱ nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","A̱t'aha̱ a̱jin ani̱ma̱ha̱ ní xu̱ta̱ nibáha̱ ra̱ nga ch'on ts'ín ts'ínnkjink'un, nga bangane kju̱a̱bixoo̱n, nga tjín xi fantuko̱ jminchjín nga najmi kje̱e bixan, nga ts'ínk'ien xinkjín, ");
INSERT INTO majNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nga ndyjé ts'ín, nga 'yún ts'ín mje ni xi tjín, nga ch'on ts'ín, nga b'ana̱cha̱, nga ts'ínkjas'ehe̱n yjoho̱ ni xi mjehe̱ yjonintehe̱, nga ma xin k'un, nga ch'on tsuhu̱ xinkjín, nga nk'a b'asje yjoho̱ ko̱ nga najmi nda ts'ínnkjink'un. ");
INSERT INTO majNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ngayjee̱ ni ch'onk'un xu'bi̱ a̱jin ani̱ma̱ha̱ xu̱ta̱ bitju. Kui ní nihi xi ts'ín sihi̱ xu̱ta̱ nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A̱s'a̱i tsitju Jesu yo̱ nga ngji a̱nte xi tiña maha̱ nanki Tiro̱ ko̱ nanki Sidon ko̱ jas'en nku ni'ya. Najmi kama yuhu̱ tsa tjín xi sku̱e̱ nga yo̱ tíjña. Tu̱nga tu̱ nkú kiyahá. ");
INSERT INTO majNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","A̱s'a̱i nku ta̱chju̱ún xi tíjñajihi̱n nku nda̱ninda ta̱kjíhi̱n, nk'ie nga kint'é nga Jesu tíjña yo̱, j'aisehe̱ ko̱ tsasinkúnch'int'aha̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tu̱nga najmi ntje̱he̱ xu̱ta̱ judio̱hó tje̱he̱n ra̱ ta̱chjúu̱n, a̱t'aha̱ a̱nte Sirofenici̱a̱ kitsin. Kui xi j'ainkihi̱ Jesu nga k'o̱nsje nda̱ninda xi tíjñajihi̱n ta̱kjíhín. ");
INSERT INTO majNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tu̱nga b'a̱há kitsú Jesu: —Katse sisin ma ra̱ tjun jántíu̱. A̱t'aha̱ najmi nda tjín tsa chjú'aha̱ ni̱nku̱a̱ha̱n jántíu̱ nga kj'u̱a̱i̱hi̱ nañóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A̱s'a̱i b'a̱ kitsú ta̱chjúu̱n: —Joho̱n, Chá Nti̱a̱, tu̱nga santahá ni ko̱ nañá xi b'entunkí kinte yámixo̱ kjine xi̱hi̱ ni̱nku̱a̱n xi bixuntuhu̱ ntí xi̱u̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","B'i̱ kitsú Jesu: —A̱t'aha̱ b'a̱ kuixín, t'in ngáhani. Ja kuitjujíhi̱n ta̱kjíhi̱n nda̱nindoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nk'ie nga tsichu ngáha ta̱chjúu̱n ni'yaha̱, kikie nga kjijña ndju ta̱kjíhi̱n ko̱ nga ja najmi ta̱ tíjñajihi̱n ra̱ nda̱nindoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","A̱s'a̱i tsitju Jesu a̱nte xi tiña maha̱ nanki Tiro̱ nga j'a nanki Sidon. Tsichu ntáchak'un Galilea̱ nga j'ajin ts'íhin nanki xi tjín a̱nte Decapo̱li̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yo̱ j'aiko̱ho̱ xu̱ta̱ nku nda̱ xi staya ko̱ tsakján'a. I̱ncha tsankihi̱ Jesu nga ngju̱énne ntsja ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","A̱s'a̱i ngjiko̱ t'axín Jesu ndo̱. Kitsungis'en na̱jnú ntsja tja̱ba̱xínñju ndo̱ ko̱ ntá na̱téhe̱ kik'onjnuko̱ho̱ ra̱ nja̱i̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A̱s'a̱i tsasenjinki nk'a ján nga na̱nka̱ tsakj'á nta̱ha̱ ko̱ b'i̱ kitsúhu̱ ndo̱: —¡Efata! —Kui éi̱n xi tsuhu̱ ra̱: ¡Katix'áí! ");
INSERT INTO majNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ta̱ kuihi chu̱bo̱ kint'é ndo̱ ko̱ kama nda̱íhi̱ nja̱i̱. Kinchja̱ sisin. ");
INSERT INTO majNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","A̱s'a̱i b'a̱ kitsúhu̱ Jesu xu̱ta̱ nga najmi tu̱ ch'a ku̱i̱tsu̱yaha̱ niu̱. Tu̱nga ndahá tsa 'yún b'a̱ kitsúhu̱ xu̱ta̱ nga najmi ku̱i̱tsu̱ya niu̱, tu̱ sahá tu̱ nku i̱ncha kitsúyahá xu̱ta̱ ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tu̱ ni xí i̱ncha kama nkjúhún ra̱ nga b'a̱ i̱ncha kitsúhu̱ xinkjín: —Ts'ín sisin tu̱ mí nihí ni. Santaha maha̱ ts'ín nga nt'é xu̱ta̱ xi staya ko̱ ts'ín nga nchja̱ xu̱ta̱ xi ni̱ma̱. ");
INSERT INTO majNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nku ni̱yá nk'ie nga ta̱ kama ñjakú ṉkjúhún ngáha xu̱ta̱ ko̱ nga najmi tjíhi̱n ni xi i̱ncha kji̱ne̱, a̱s'a̱i kinchja̱ha̱ Jesu já ni'yakuyáha̱ ko̱ b'i̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Tíma ni̱ma̱na xu̱ta̱ nkjii̱n, a̱t'aha̱ ja tjíhi̱n jan ni̱stjin nga tjíntuko̱na e̱i̱. Ja najmi ta̱ tjíhi̱n ra̱ nichine. ");
INSERT INTO majNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tsa b'a̱há tjíu̱n ts'inkjí kjintíá ni'yaha̱, kutsa i̱ncha ku̱a̱yáyahá a̱ya ni̱yóo̱. A̱t'aha̱ tjín xi kjin ṉkjún nibáha. ");
INSERT INTO majNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A̱s'a̱i b'i̱ i̱ncha kitsú já ni'yakuyóo̱: —Tu̱nga a̱nte t'axín xu'bi̱. ¿Má xi tje̱hen kuankínchj'a̱haná ni̱nku̱a̱n xi ka̱maha̱ ra̱ xu̱ta̱ nkjii̱n? ");
INSERT INTO majNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","B'i̱ kitsú Jesu: —¿Nkú tjín ni̱nku̱a̱n kich'o? B'a̱ i̱ncha kitsú jóo̱: —Yatu maha. ");
INSERT INTO majNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A̱s'a̱i b'a̱ kitsú Jesu nga k'úéntu xu̱ta̱ nkjiu̱n t'anankiu̱. Jakj'á ni̱nku̱a̱n xi yatuu̱ ko̱ kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná. Tsakjánya ko̱ kitsjáha̱ já ni'yakuyáha̱ tu̱ xi n'e̱ndzjoho̱ ra̱ xu̱ta̱. A̱s'a̱i já ni'yakuyóo̱ kits'ínndzjoho̱ ni̱nku̱o̱n xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ko̱ ta̱ y'a ya jóo̱ k'u̱a̱ tji̱o̱ xi̱xi̱. A̱s'a̱i kitsjáha̱ Jesu máb'a̱chjíhi̱ Nti̱a̱ná nga̱t'a ts'e̱ tji̱o̱ ko̱ b'a̱ ta̱ kitsúhu̱ já ni'yakuyáha̱ nga ts'i̱ínndzjoho̱ xu̱ta̱ nkjiu̱n niu̱. ");
INSERT INTO majNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kikjine xu̱ta̱ niu̱ santa nkúhu nga kitse sisihi̱n. A̱s'a̱i j'áíya ni̱nku̱a̱n xi ts'ankiu̱. Yatu ni̱si̱n kama. ");
INSERT INTO majNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma ra̱ ñju mii̱ xu̱ta̱ xi i̱ncha kikjine nichinee̱. A̱s'a̱i kits'ínkji Jesu xu̱ta̱ nkjiu̱n ni'yaha̱ ");
INSERT INTO majNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ko̱ jas'enko̱ já ni'yakuyáha̱ tsutsuu̱ nga ngji a̱nte Dalmanuta̱. ");
INSERT INTO majNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","A̱s'a̱i i̱ncha j'ai já fariseo̱ ko̱ kik'atuts'i̱hi̱n nga ngji kontra̱ha̱ ni xi tsakúya Jesu. Tu̱ xi kikjut'ayák'uhun, tsankihi̱ nga ts'i̱ín nku kju̱a̱nkjún xi ku̱a̱kúchji nga Nti̱a̱ná kits'ín nibáha̱. ");
INSERT INTO majNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Najmi kisasíhi̱n Jesu ni xi kitsú jóo̱ ko̱ b'i̱ kitsú: —¿Á tíbankihi xu̱ta̱ xi tjíhin nd'a̱i̱ nga sku̱e̱he nku kju̱a̱nkjún? Kju̱axi̱ ni xi tíxinnu̱u nga najmi s'e̱jña chjihi̱ xu̱ta̱ xi tjín nd'a̱i̱ ndaha nku kju̱a̱nkjún. ");
INSERT INTO majNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A̱s'a̱i ngji t'axíhi̱n jóo̱ nga jas'en ngáha tsutsuu̱ ko̱ ngji ngabantá xinkuu̱. ");
INSERT INTO majNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Já ni'yakuyóo̱ kichayaha̱ nga i̱ncha kik'a ni̱nku̱a̱n. Tu̱ nku i̱chíhí ni̱nku̱a̱n xi i̱ncha y'a nga kab'entuyá tsutsuu̱. ");
INSERT INTO majNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A̱s'a̱i Jesu b'a̱ kitsúhu̱ jóo̱: —Nda cha̱so̱o. Chúhu̱un yjonu̱u na̱'yu̱ saha̱n já fariseo̱ ko̱ na̱'yu̱ saha̱n Herode̱. ");
INSERT INTO majNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A̱s'a̱i b'i̱ ngján kinchja̱ni̱jmíyako̱ho xinkjín já ni'yakuyóo̱ nga najmi i̱ncha y'a ni̱nku̱a̱n. ");
INSERT INTO majNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kamankjihi̱n Jesu ni xi tíi̱ncha tsu jóo̱ ko̱ b'a̱ kitsúhu̱: —¿Á tíchubani̱jmíyahanu nga najmi kich'ahanu ni̱nku̱a̱n? ¿A tu̱ yje najmi kje̱hé ma chjinu̱u ko̱ mankjinnu̱u? ¡Á b'a̱ nkjún ts'ín ndjáha ani̱ma̱nu̱u! ");
INSERT INTO majNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tíi̱ncha tunkun, tu̱nga, ¿a najmi ma chjihínu̱u? Ko̱ tjínnu̱u tja̱ba̱xínñju, tu̱nga, ¿a najmi nu'yánú? ¿A najmi ta̱ f'áítsjehénnu̱u? ");
INSERT INTO majNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nk'ie nga tsakjanyáha̱ ni̱nku̱a̱n xi uu̱n já xi un mii̱ maha, ¿nkú tjín ni̱si̱n kama ni̱nku̱a̱n xi tsankiu̱ nga y'ekú? B'a̱ i̱ncha kitsú jóo̱: —Te jo ni̱si̱n. ");
INSERT INTO majNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","B'i̱ kitsú Jesu: —Ko̱ nk'ie nga tsakjanyáha̱ ni̱nku̱a̱n xi yatuu̱ já xi ñju mii̱ maha, ¿nkú tjín ni̱si̱n kama ni̱nku̱a̱n xi tsankiu̱ nga y'ekú? B'a̱ kitsú jóo̱: —Yatu ni̱si̱n. ");
INSERT INTO majNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A̱s'a̱i b'i̱ kitsú Jesu: —¿Á tu̱ yje najmi kje̱hé mankjihi̱nnu̱u ma? ");
INSERT INTO majNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nk'ie nga tsichuko̱ Jesu já ni'yakuyáha̱ nanki Betsaida̱, a̱s'a̱i i̱ncha j'aiko̱ho̱ xu̱ta̱ nku nda̱ ka̱ ko̱ i̱ncha tsankihi̱ nga ngju̱áne ntsja nda̱ ko̱. ");
INSERT INTO majNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jakj'á ntsja ndo̱ nga tsitjuko̱ na̱tsihi̱n na̱nti̱o̱. A̱s'a̱i tsáta̱téjnu tunku̱n ndo̱ ko̱ kingjáne ntsja. A̱s'a̱i kingjásjaiyaha̱: —¿A tjín ni xi tíma chjihi? ");
INSERT INTO majNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","B'a̱ kitsú ndo̱ nga tsase: —Tíma chjina xu̱ta̱. B'a̱ k'un yá tu xi tjíma k'un. ");
INSERT INTO majNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A̱s'a̱i ta̱ kingjáne ntsja ngáha Jesu tunku̱n ndo̱. Tsase sisin ndo̱ nga kamanda. Kama chji tentehe̱ ngayjee̱ ni xi tjín. ");
INSERT INTO majNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","A̱s'a̱i kits'ínkji ni'yaha̱ ndo̱ nga b'i̱ kitsúhu̱: —Najmi ta̱ bitjas'e̱henni a̱jin na̱nti̱o̱ tsa ku̱i̱xínyai ni xi kamahi. ");
INSERT INTO majNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A̱s'a̱i ngji Jesu ko̱ já ni'yakuyáha̱ a̱nte xi tjín nanki Cesarea̱, má nga batéxuma nda̱ Felipe̱. Nk'ie nga tje̱n a̱ya ni̱yóo̱, a̱s'a̱i b'a̱ kitsúhu̱ já ni'yakuyáha̱: —¿Yá xi títsu xu̱ta̱ nga an? ");
INSERT INTO majNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","B'a̱ kitsú já ni'yakuyóo̱: —Tjín xi b'a̱ tíi̱ncha tsu nga ji xi Jua Bautista̱. Tjín ngá xi b'a̱ tíi̱ncha tsu nga ji xi Elia̱. Ko̱ tjín ngá xi b'a̱ tíi̱ncha tsu nga nku nda̱ profeta̱ ji. ");
INSERT INTO majNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","B'i̱ kitsú Jesu: —Ko̱ jun, ¿yá xi bixíún nga an? A̱s'a̱i b'a̱ kitsú Pedro̱: —Ji xi Cristo̱. ");
INSERT INTO majNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A̱s'a̱i b'a̱ kitsúhu̱ Jesu jóo̱ nga najmi tu̱ ch'a xi ku̱i̱tsu̱yaha̱ kui éi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kik'atuts'i̱hi̱n Jesu nga tsakúyaha̱ já ni'yakuyáha̱ nga tjíhin nga un ṉkjún sku̱e̱he̱ Ntíhi̱ Nda̱x'i̱u̱n, ko̱ nga jáchá xi tjíhi̱n xá ko̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ najmi i̱ncha ts'i̱ínkjáíhi̱n, ko̱ nga n'e̱k'ien, ko̱ nga kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱ nga ja kj'u̱a̱ jan ni̱stjin. ");
INSERT INTO majNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kitsúyaha̱ ni xu'bi̱ já ni'yakuyáha̱. A̱s'a̱i Pedro̱ ngjiko̱ t'axín Jesu ko̱ b'a̱ kitsúhu̱ nga najmi nda kits'ín nga b'a̱ kitsú. ");
INSERT INTO majNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tu̱nga kits'ínk'ótjiyak'uhún Jesu já ni'yakuyáha̱ nga ndjá kinchja̱ko̱ Pedro̱: —¡Ti̱yú xinní, Satana! A̱t'aha̱ najmi ni xi ts'e̱ Nti̱a̱ná tín'enkjíntak'uin. Ni xi ts'e̱ ní xu̱ta̱ a̱sunntei̱ tín'enkjíntak'uin. ");
INSERT INTO majNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A̱s'a̱i kinchja̱ha̱ xu̱ta̱ nkjiu̱n ko̱ já ni'yakuyáha̱ nga b'i̱ kitsúhu̱: —Tsa tjín xi mjehe̱ tsjénnkina, kat'éch'o subaha̱ yjoho̱ ni xi mjehe̱ ko̱ katsjáha̱ yjoho̱ nga ku̱a̱yá nga̱t'ana̱, a̱s'a̱i katsjennkína. ");
INSERT INTO majNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","A̱t'aha̱ xi mjehe̱ ts'i̱ínk'anki suba yjoho̱ nga k'úéjña tík'un, kui xi tu̱ sahá ku̱a̱yá. Tu̱nga xi ku̱a̱yá nga̱t'ana̱ ko̱ nga̱t'aha̱ én nda tsuhu̱ Nti̱a̱ná, kui xi tu̱ sahá n'e̱k'anki. ");
INSERT INTO majNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","A̱t'aha̱, ¿mí xi chjíhi̱ ra̱ tsa ts'i̱ín ngana̱ xu̱ta̱ ngayjee̱ ni xi tjín a̱sunntee̱, tsa tu̱ sa ndyja̱há ngá ani̱ma̱ha̱? ");
INSERT INTO majNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Mí nihi xi tsjá nga k'u̱échjíntjai ani̱ma̱ha̱? ");
INSERT INTO majNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","’Kui nga tsa tjín xi ka̱ma subaha̱ ra̱ an ko̱ énna̱ a̱jihi̱n xu̱ta̱ ngatitsun xi tjín nd'a̱i̱ xi najmi na̱xu̱ tíi̱ncha nginku̱n Nti̱a̱ná, b'a̱ ta̱ ts'ín ta̱ ka̱ma subaha̱ Ntíhi̱ Nda̱x'i̱u̱n xu̱ta̱ xu'bi̱ ni̱stjin nk'ie nga kj'u̱a̱íko̱ kju̱a̱chánkaha̱ Na̱'mihi̱ ko̱ nga kj'u̱a̱íko̱ ntítsjehe̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","B'i̱ ta̱ kitsú ya Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. K'u̱a̱ xi tíi̱ncha e̱i̱ najmi ku̱a̱yá santa nkúhu nga sku̱e̱ xi nkú ts'ín ku̱a̱kúchji nga'yúhu̱n Nti̱a̱ná nga ja ku̱a̱téxuma. ");
INSERT INTO majNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","A̱skahan nk'ie nga j'a jun ni̱stjin, Jesu kinchja̱ t'axíhi̱n Pedro̱, Santiago̱ ko̱ Jua. Ngjiko̱ t'axín suba jóo̱ nku a̱sunntu na̱xi̱ nk'a. Yo̱ kik'óntjaiya sénni̱stjihi̱n Jesu nginku̱n jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tsat'ai najyuhu̱n. Taba xúxú kama. Najmi tjín a̱sunntei̱ xi ka̱maha̱ b'a̱ ts'i̱ínk'íé taba taba najyuhu̱n nga ku̱a̱né nga xi nkú kik'ie najyuhu̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ta̱ kikie jóo̱ Elia̱ ko̱ Moise nga tíi̱ncha nchja̱ni̱jmíko̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","A̱s'a̱i b'i̱ kitsú Pedro̱: —Ji nda̱ maestru̱, ¡á b'a̱ nda tjíhin nga e̱i̱ ku̱i̱ntsu̱ba̱haná! Tu̱ sahá n'e̱ndai̱ jan ni'ya yántsu̱, nku xi ka̱ma ts'i̱, nku xi ka̱ma ts'e̱ Moise, ko̱ nku xi ka̱ma ts'e̱ Elia̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","B'a̱ kitsú Pedro̱ a̱t'aha̱ najmi be mí nihi xi ku̱i̱tsu̱, a̱t'aha̱ tu̱ ni xí kitsankjúhún jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","A̱s'a̱i tu̱ nkuhú ni̱nti̱ j'ai ts'ínnk'íéhe̱n ko̱ a̱jin ni̱nti̱u̱ kinu'yá nku nta̱ xi b'a̱ kitsú: —Kui xu'bi̱ xi Ntína̱. Tjona. Ta̱sinñjuhu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ko̱ a̱s'a̱i tje̱n'yún i̱ncha tsasehé a̱ndaihi̱ jóo̱, tu̱nga najmi ta̱ ch'a xi kikiehé ni. Tu̱ Jesu síjñako̱ subahá saha̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nk'ie nga ja tíi̱ncha nibájen ngáha, b'a̱ kitsúhu̱ Jesu jóo̱ nga najmi tu̱ ch'a xi ku̱i̱tsu̱yaha̱ ni xi kikie santa nkúhu nga kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱ Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tu̱ kui i̱ncha kikiehé niu̱ ko̱ kinchja̱ni̱jmíyako̱ho xinkjín nkú tsuhu̱ ra̱ nga kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","A̱s'a̱i i̱ncha kingjásjaiyaha̱ Jesu: —¿Á b'a̱ tsuhu já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ nga tjíhin nga kj'u̱a̱í títjuhun Elia̱? ");
INSERT INTO majNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","B'i̱ kitsú Jesu: —Kju̱axi̱ nga kj'u̱a̱í títjun Elia̱ ko̱ k'u̱énda ngayjee̱ ni xi tjín. Tu̱nga, ¿nkú tsuhu̱ ra̱ nga b'a̱ ts'ín tjít'aha éhe̱n Nti̱a̱ná nga un ṉkjún sku̱e̱he̱ ra̱ Ntíhi̱ Nda̱x'i̱u̱n ko̱ nga xi najmi chumi ni chjíhi̱ ra̱ n'e̱ maha? ");
INSERT INTO majNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tu̱nga an b'a̱ tíxinnu̱u nga ja j'ai Elia̱, ko̱ ni xi mjehe̱ xu̱ta̱ kits'íhi̱n ndo̱. Kin'ehe̱ xi nkú ts'ín tjít'a éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nk'ie nga i̱ncha j'ai ngáha má nga tjíntu já ni'yakuyá xingisoo̱, kikie nga nkjin ṉkjún xu̱ta̱ katsendáíhi̱ ra̱ jóo̱ ko̱ nga k'u̱a̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ tíi̱ncha b'ésiko̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nk'ie nga kikie xu̱ta̱ nkjiu̱n Jesu, tu̱ ni xí i̱ncha kama nkjúhún ra̱ ko̱ tsangatsanka nga ngjikjaniñaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A̱s'a̱i b'i̱ kitsú Jesu: —¿Mí nihi xi tjínko̱ho̱nu̱u jóo̱? ");
INSERT INTO majNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","B'a̱ kitsú nku nda̱ xi síjñajihi̱n xu̱to̱: —Ji nda̱ maestru̱, kjúái̱ko̱ho nda̱ chína̱, a̱t'aha̱ nku nda̱ninda tíjñajihi̱n xi najmi tsjántehe̱ nga ku̱i̱nchja̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tu̱ má xi tje̱hén ni nga fakj'áha̱, ts'ínkijnehe̱ t'anankiu̱. I̱xí b'éxúhú ts'a nda̱ chína̱ nga bate ni̱'yu̱n ko̱ bjá ndjáha̱. Ja b'a̱ kuaxihi̱n já ni'yakuyáhi̱ nga k'o̱nsje nda̱nindoo̱, tu̱nga najmi kamahá ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","A̱s'a̱i b'i̱ kitsú Jesu: —¡Á b'a̱ 'yún i̱chí s'ejihi̱n ra̱ Nti̱a̱ná xu̱ta̱ xi tjíhin nd'a̱i̱! ¿Nkjé kjin tjíhin nga kúáte̱jñajinnu̱u? ¿Nkjé kjin tjíhin nga ts'in chúkju̱a̱nu̱u? Nibáko̱nú nda̱ chíu̱ e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","A̱s'a̱i j'aich'áha̱ nda̱ chíu̱. Tu̱nga nk'ie nga kikie nda̱nindoo̱ Jesu, tje̱n'yún y'étsujneyáhá nda̱ chíu̱ ko̱ tsijne t'anankiu̱ nga ngjitikjá ko̱ y'éxú ts'íhin ts'a. ");
INSERT INTO majNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","A̱s'a̱i kingjásjaiyaha̱ Jesu na̱'mihi̱ nda̱ chíu̱: —¿Nkjé kjin b'a̱ maha̱ ra̱? B'a̱ kitsú ndo̱: —Santa nkúhu nga ntí i̱chí. ");
INSERT INTO majNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nkjin ni̱yá ja sa kjaníkj'ajihi̱n nd'íu̱ ko̱ ntóo̱ nga mjehe̱ ts'i̱ínk'ien ntína̱. Tsa tjín ni xi ka̱mahi n'e̱i̱ kai, katuma ni̱ma̱ni̱ ji̱n ko̱ ti̱si̱nko̱ni̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","A̱s'a̱i b'i̱ kitsú Jesu: —“Tsa ka̱mahi”, tíbixín. Xi s'ejihi̱n Nti̱a̱ná maha̱ tu̱ mí nihí ni. ");
INSERT INTO majNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tje̱n'yún 'yúhún kinchja̱ na̱'mihi̱ nda̱ chíu̱ nga b'i̱ kitsú: —S'ejinna Nti̱a̱ná. Ti̱si̱nko̱ní tu̱ xi najmi jo jan ka̱mahana. ");
INSERT INTO majNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nk'ie nga kikie Jesu nga tíma ñjakú ṉkjún xu̱ta̱, a̱s'a̱i ndjá kinchja̱ko̱ nda̱nindoo̱: —Ji nda̱ninda xi tín'e stayai ko̱ najmi tí'ba̱i̱ntei̱hi̱ nga ku̱i̱nchja̱ nda̱ chíi̱, an b'a̱ tíxihin: ti̱tjujíhi̱n ko̱ najmi ta̱ bitjas'e̱njihi̱n ri̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A̱s'a̱i tsitju nda̱nindoo̱ nga kikjintáya ts'íhin ko̱ nga 'yún y'étsujneyá nda̱ chíu̱. Kis'ejña nda̱ chíu̱ xi nkúhu tsa k'ien. Nkjin xu̱ta̱ xi b'a̱ kitsú: —Ja k'uen. ");
INSERT INTO majNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tu̱nga jakj'áhá Jesu ntsja nda̱ chíu̱ nga kikjesíntje̱n ko̱ tsasinjña ngáha. ");
INSERT INTO majNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nk'ie nga jas'en Jesu ni'yaha̱, a̱s'a̱i já ni'yakuyáha̱ kingjásjaiya t'axíhi̱n: —¿Á najmi kamaha̱ni̱ kuakich'onsje̱he̱ni̱ nda̱nindoo̱? ");
INSERT INTO majNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A̱s'a̱i b'i̱ kitsú Jesu: —Jáninda xi nkúhu xu'bi̱ najmi chu̱ba̱ bitju. Nk'ie nga chu̱baka̱á Nti̱a̱ná ko̱ nk'ie nga bintsu̱ba̱ kjintíaá, nk'iehé nga bitju. ");
INSERT INTO majNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A̱s'a̱i tsitju yo̱ nga i̱ncha j'ajin a̱nte Galilea̱. Najmi kama mjehe̱ tsa tjín xi sku̱e̱he̱ nga yo̱ j'a, ");
INSERT INTO majNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","a̱t'aha̱ b'i̱ ts'ín tsakúyaha̱ já ni'yakuyáha̱: —N'e̱kjas'en Ntíhi̱ Nda̱x'i̱u̱n a̱ya ntsja xu̱ta̱ ko̱ i̱ncha ts'i̱ínk'iehe̱n. A̱skahan nga ja ku̱a̱yá, kj'u̱a̱íya ngáha̱ ra̱ nga ja kj'u̱a̱ jan ni̱stjin. ");
INSERT INTO majNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tu̱nga najmi kamankjihín ra̱ já ni'yakuyóo̱ én xu'bi̱ ko̱ najmi kama k'un kingjásjaiyaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","A̱s'a̱i i̱ncha tsichu nanki Capernaum ko̱ nk'ie nga ja tíjña a̱ya ni'yoo̱, kingjásjaiyaha̱ já ni'yakuyáha̱: —¿Mí nihi xi tíchubani̱jmíyako̱honu xinki̱u a̱ya ni̱yóo̱? ");
INSERT INTO majNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tu̱nga najmi kinchja̱há jóo̱, a̱t'aha̱ a̱ya ni̱yóo̱ kinchja̱ni̱jmíyako̱ho xinkjín yá xi 'yún nk'a tje̱n a̱jihi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A̱s'a̱i y'ejña Jesu, kinchja̱ha̱ já ni'yakuyá xi te joo̱ ko̱ b'i̱ kitsúhu̱: —Tsa tjín xi nda̱ k'aku̱ mjehe̱ ka̱ma a̱jinnu̱u, tu̱ sahá nda̱ musu̱ kats'ín ma yjoho̱ ko̱ kats'ínxát'aha̱ já xingisoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A̱s'a̱i jakj'á nku nda̱ chí ko̱ tsasínjñajin masehe̱n jóo̱. Kitsubakjá ts'íhin nda̱ chíu̱ nga b'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Xi ngajona̱ ts'i̱ínkjáíhi̱n ra̱ nku nda̱ chí xi nkúhu xu'bi̱, kui xi an títs'ínkjáínna. Ko̱ xi ts'i̱ínkjáínna, najmi tu̱ nku an títs'ínkjáínna. Ko̱ ta̱ xi kits'ín nibána títs'ínkjáíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A̱s'a̱i b'a̱ kitsú Jua: —Ji nda̱ maestru̱, kiyai̱ nga nku nda̱ ngajohi̱ tím'osjehe jánindoo̱. Tu̱nga kik'iech'ohó ri̱ a̱t'aha̱ najmi ñá tje̱nko̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi tu̱ jun b'ech'óho̱o. A̱t'aha̱ tsa tjín xi títs'ín nku kju̱a̱nkjún ngajona̱, kui xi najmi ka̱ma tsa tu̱ sa a̱ kui ch'ohón ts'ín ku̱i̱nchja̱yane ngáhana. ");
INSERT INTO majNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","A̱t'aha̱ xi najmi tífi kontra̱ná, kui xi ñá mako̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tu̱ yáhá ni xi tsjánu̱u tsa tu̱ nku chu̱tsín ntánijua a̱t'aha̱ an tje̱nnkinú, kju̱axi̱ ni xi tíxinnu̱u nga k'u̱a̱i̱hi̱ chjíhi̱ xu̱ta̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Tu̱ yáhá ni xi ts'i̱ínkijnejin ngatitsun nku nda̱ chí xi nkúhu xu'bi̱ xi s'ejihi̱n an, tu̱ sahá ra̱ ngandaha̱ xi b'a̱ ts'i̱íu̱n tsa s'e̱t'a 'yúnt'a kásin nku ndji̱o̱ chánka ko̱ chja̱nikj'ajin ntáchak'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tsa ntsa̱i̱ títs'ínkijnejihin ngatitsun, tu̱ sahá ti̱chákjáí. Tu̱ sahá ngandahi̱ tsa ku̱i̱tjás'e̱n ni̱ma̱i̱ má nga k'úéntu tík'un xu̱ta̱, nga najmi k'úínko̱i̱ nga joo̱ ntsa̱i̱ nga̱k'i̱e̱n, má nga najmi maha̱ 'meya nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Yo̱ najmi 'me chju̱ntuu̱ ko̱ najmi 'meya nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","’Tsa tsu̱kui títs'ínkijnejihin ngatitsun, tu̱ sahá ti̱chákjáí. Tu̱ sahá ngandahi̱ tsa ku̱i̱tjás'e̱n ni̱ma̱i̱ má nga k'úéntu tík'un xu̱ta̱, nga tjít'a nga joo̱ tsu̱kui nga a̱jin nd'í nga̱k'i̱e̱n chja̱nikj'ajihin, má nga najmi maha̱ 'meya nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yo̱ najmi 'me chju̱ntuu̱ ko̱ najmi 'meya nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","’Tsa tunkuin títs'ínkijnejihin ngatitsun, tu̱ sahá n'e̱sjei. Tu̱ sahá ngandahi̱ tsa ku̱i̱tjás'e̱n ka̱t'ai má nga batéxuma Nti̱a̱ná, nga najmi tsa tíi̱ncha nga joo̱ tunkuin tsa tu̱ sa a̱jin nd'í nga̱k'i̱e̱hén chja̱nikj'ajin ngáhi, ");
INSERT INTO majNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","má nga najmi 'me chju̱ntuu̱ ko̱ najmi 'meya nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’A̱t'aha̱ nd'í n'entiako̱ho ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nda na̱xo̱, tu̱nga tsa ndyja̱ nga'yúhu̱n, ¿nkú ts'ín ka̱ma ntia ngáha? Kas'e a̱jinnu̱u na̱xa̱ xi tíxinnu̱u ko̱ b'i̱ ngján jyu ti̱ntsu̱ba̱ko̱o xinki̱u. ");
INSERT INTO majNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tsitju Jesu yo̱ nga ngji a̱nte xi tjín Judea̱ ko̱ a̱nte xi tjín ngabantá ntáje̱ Jordan. Ta̱ kama ñjakút'a ṉkjúhún ngáha̱ ra̱ xu̱ta̱. Tsakúyaha̱ éhe̱n Nti̱a̱ná xi nkú nga ts'ín tehe̱nte. ");
INSERT INTO majNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A̱s'a̱i k'u̱a̱ já fariseo̱ j'aisehe̱ tu̱ xi kjút'ayák'uhu̱n ra̱. B'i̱ ts'ín kingjásjaiyaha̱: —¿A ka̱ma nku nda̱ chu̱ba̱ ts'i̱ínkjehé kju̱a̱bixaha̱n nga k'u̱éjña chju̱úhu̱n? ");
INSERT INTO majNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","B'i̱ kitsú Jesu: —¿Nkú ts'ín y'éjñanu̱u Moise? ");
INSERT INTO majNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","B'a̱ i̱ncha kitsú jóo̱: —Moise kitsjá kju̱a̱ nga nku nda̱ ka̱ma kjésíntje̱n nku xu̱ju̱n má nga ja títs'ínkje kju̱a̱bixaha̱n ko̱ b'a̱ ts'ín ka̱ma k'u̱éjñaha chju̱úhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","A̱s'a̱i b'i̱ kitsú Jesu: —A̱t'aha̱ ndjá ani̱ma̱nu̱u, kui kju̱a̱ha nga b'a̱ ts'ín y'éjnaha̱nu̱u Moise. ");
INSERT INTO majNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tu̱nga nga tuts'ihi̱n ni, nk'ie nga kits'ínnda Nti̱a̱ná a̱sunntee̱, “nku chju̱ún nku x'i̱n kits'ínnda xu̱ta̱” tjít'a. ");
INSERT INTO majNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ko̱ ta̱ tjít'a ya: “Kui kju̱a̱ha nga nku nda̱ k'u̱éjñaha na̱'mihi̱ ko̱ na̱aha̱ nga k'úéjñako̱ chju̱úhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nga joo̱ nkuhú ku̱i̱chú ma.” Kui nga najmi ta̱ jo ma saha. Nku ní yjoninte i̱ncha maha. ");
INSERT INTO majNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kui b'a̱ maha, ni xi y'é'yúhun Nti̱a̱ná, najmi xu̱ta̱ kjéndáya. ");
INSERT INTO majNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A̱s'a̱i já ni'yakuyáha̱ ta̱ kuihí niu̱ kingjásjaiya ngáha̱ ra̱ nk'ie nga ja i̱ncha j'ai ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","B'i̱ kitsú Jesu: —Tu̱ yáhá ni xi k'u̱éjña chju̱úhu̱n ko̱ ku̱i̱xanko̱ kj'a̱í ta̱chju̱ún, kui xi tíbangane kju̱a̱bixaha̱n. ");
INSERT INTO majNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ko̱ tsa nku ta̱chju̱ún k'u̱éjña x'i̱hi̱n ko̱ ku̱i̱xanko̱ kj'a̱í nda̱, kui xi ta̱ tíbangane kju̱a̱bixaha̱n. ");
INSERT INTO majNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A̱s'a̱i i̱ncha j'aiko̱ xu̱ta̱ ntíhi̱ tu̱ xi Jesu ngju̱énnehe̱ ra̱ ntsja. Tu̱nga já ni'yakuyóo̱hó b'a̱ kitsúhu̱ xu̱ta̱ nga najmi b'a̱ i̱ncha ts'i̱ín. ");
INSERT INTO majNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nk'ie nga kikie Jesu ni xi tíi̱ncha ts'ín jóo̱, najmi kisasíhi̱n niu̱. A̱s'a̱i b'a̱ kitsúhu̱: —Tjehe̱nntoho̱o jántíu̱ nga kanibásena. Najmi tu̱ jun b'ech'óho̱o. A̱t'aha̱ xu̱ta̱ xi b'a̱ ts'ín tjíntuyáha̱ xi nkú joyaha jántí xi̱, kui xi tje̱he̱n ra̱ nga Nti̱a̱ná ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kju̱axi̱ ni xi tíxinnu̱u. Xi najmi ts'i̱ínkjáíhi̱n nga Nti̱a̱ná xi batéxuma xi nkú ts'ín ts'ínkjáíhi̱n nku nda̱ chí ni xi 'ba̱i̱hi̱, kui xi ndaha̱chí najmi kju̱a̱s'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A̱s'a̱i jakj'á jántí xi̱u̱ nga ts'ank'a ko̱ kingjénne ntsja nga nda kinchja̱ne. ");
INSERT INTO majNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nk'ie nga ja tíbitju Jesu yo̱ nga ts'i̱ín ni̱yá, a̱s'a̱i j'ai tsuntsu nku nda̱. Tsasinkúnch'int'aha̱ ko̱ b'a̱ kitsúhu̱: —Ji nda̱ maestru̱, ji xi ndai, ¿mí nihi xi ts'ian tu̱ xi ka̱ma ts'inkjáíhi̱n ra̱ nga kúáte̱jña tík'un síán? ");
INSERT INTO majNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A̱s'a̱i b'i̱ kitsú Jesu: —¿Á an xi nda tí'mihiní? Najmi tjín xi ndaha̱, nku tutuhú Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yai xi nkú ts'ín tjít'a kju̱a̱téxumoo̱: “Najmi tu̱ n'ek'iein. Najmi tu̱ biyunéí kju̱a̱bixoo̱n. Najmi tu̱ ndyjé n'ei. Najmi tu̱ testiyu̱ tsank'á n'ei. Najmi tu̱ ch'ana̱ch'a̱i̱hi̱ xu̱ta̱ xingisoo̱. Cha̱nkjúín na̱'mihi̱ ko̱ na̱ahi̱.” ");
INSERT INTO majNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","B'a̱ kitsú ndo̱: —Ji nda̱ maestru̱, ngayjee̱ ni xu'bo̱ títs'intjusan santa nkúhu nga ndyjana. ");
INSERT INTO majNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A̱s'a̱i Jesu kama ni̱ma̱ha̱ ndo̱ nga tsase'a ko̱ b'i̱ kitsúhu̱: —Nku ni ndyjat'a sahi. T'ihi̱nteñai ni xi tjíhin ko̱ tjeihi̱n xu̱ta̱ x'a̱n. B'a̱ ts'ín s'e̱he ri kju̱a̱nchi̱ná ndji̱o̱jmi ján. A̱s'a̱i ni̱báí nga tsjénnkiní. ");
INSERT INTO majNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tu̱nga nk'iehé nga kint'é ndo̱ éi̱n, kik'ie babaha̱ ko̱ kik'ie nusin nusihi̱n nga ngji, a̱t'aha̱ 'yún ṉkjún nchi̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A̱s'a̱i tsase Jesu a̱ndaihi̱ ko̱ b'a̱ kitsúhu̱ já ni'yakuyáha̱: —¡Á b'a̱ 'yún 'ni tjíhin tsa xu̱ta̱ xi nchi̱ná ṉkjúhun kju̱a̱s'enjihin nga Nti̱a̱ná xi ku̱a̱téxumaha̱! ");
INSERT INTO majNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kama nkjúhu̱n já ni'yakuyóo̱ én xi kitsú Jesu, tu̱nga b'a̱há ta̱ kitsú ngáha̱ Jesu: —Jun ntína̱, ¡á b'a̱ 'yún 'ni tjíhin nga kju̱a̱s'enjihin xu̱ta̱ nga Nti̱a̱ná ku̱a̱téxumaha̱! ");
INSERT INTO majNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tu̱ sahá najmi 'ni tjín tsa nku chu̱ camello̱ kju̱a̱s'en ti̱xa̱ha̱ nku nintu nga nku nda̱ nchi̱ná kju̱a̱s'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tu̱ ni xí kama nkjúhún saha̱ jóo̱ ko̱ b'a̱ kitsúhu̱ xinkjín: —¿Yá xi ka̱ma k'u̱a̱nki ni̱ ma? ");
INSERT INTO majNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A̱s'a̱i tsase'a Jesu jóo̱ ko̱ b'a̱ kitsúhu̱: —Xu̱ta̱ ndaha̱chí najmi ka̱maha̱ ts'i̱ínk'anki yjoho̱, tu̱nga Nti̱a̱ná maha̱ ts'ínk'anki xu̱ta̱. A̱t'aha̱ tu̱ mí nihí ni xi maha̱ ts'ín Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A̱s'a̱i b'a̱ kitsú Pedro̱: —Xi nkúhu ji̱n, ja y'entu tentei̱ ni xi tjínni̱ ko̱ tje̱nnkihi̱ nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","A̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Tu̱ yáhá ni xi y'éjña ni'yaha̱, tsa já nts'e̱, tsa jminchjín nichja, tsa na̱aha̱, tsa na̱'mihi̱, tsa ntíhi̱ ko̱ tsa jñá xi tjíhi̱n nga̱t'ana̱ ko̱ nga̱t'aha̱ én nda tsuhu̱ Nti̱a̱ná, ");
INSERT INTO majNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kui xu̱ta̱i̱ k'u̱a̱i̱ ngáha̱ ra̱ unchan ni̱yá tjíhin ni xi y'éjña. Nd'a̱i̱ a̱sunnte xu'bi̱ k'u̱a̱i̱hi̱ ni'ya, já nts'e̱, jminchjín nichja, na̱aha̱, ntí ko̱ jñá, ko̱ ta̱ tsjénnki uncha. Ko̱ ni̱stjin xi nibá a̱skahan k'u̱a̱i̱hi̱ nga k'úéntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nkjin xu̱ta̱ xi tjun nd'a̱i̱ tsjénnki, ko̱ nkjin xi yjanki nd'a̱i̱ xi tsjén títjun ka̱ma ngáha. ");
INSERT INTO majNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nk'ie nga tíi̱ncha ts'ín ni̱yá nga tíi̱ncha fi nanki Jerusalen, Jesu tje̱n títjuhu̱n xu̱ta̱ ni'yakuyáha̱. Kama nkjúhu̱n jóo̱ ko̱ tíi̱ncha tsankjún nga tje̱nnkihi̱. A̱s'a̱i ta̱ kinchja̱ t'axíhín ngáha̱ ra̱ já ni'yakuyá xi te joo̱ ko̱ kik'atuts'i̱hi̱n nga kitsúyaha̱ ni xi ka̱mat'ain. ");
INSERT INTO majNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","B'i̱ kitsúhu̱ jóo̱: —Tjenñju. Ja tíbankíaán nanki Jerusalen. Ja n'e̱kjas'en Ntíhi̱ Nda̱x'i̱u̱n a̱ya ntsja já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. Kui xi i̱ncha tsjá kju̱a̱ nga n'e̱k'ien ko̱ a̱s'a̱i ts'i̱ínkjas'ehe̱n xu̱ta̱ xi najmi ntje̱ Israel tje̱he̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kui xi ku̱a̱jnu̱kiehe̱ ko̱ ku̱a̱tétéjnuhu̱. K'u̱éhe̱ ko̱ ts'i̱ínk'ien. Tu̱nga nk'iehé nga ja kj'u̱a̱ jan ni̱stjin, kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A̱s'a̱i Santiago̱ ko̱ Jua xi jáha̱ Zebedeo̱ maha, kui xi i̱ncha j'aise tiñaha̱ Jesu ko̱ b'a̱ kitsúhu̱: —Ji nda̱ maestru̱, mjeni̱ nga k'u̱a̱i̱ni̱ ni xi ku̱i̱nchíhi̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","B'i̱ kitsú Jesu: —¿Mí nihi xi mjenu̱u nga ts'ian? ");
INSERT INTO majNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","B'a̱ i̱ncha kitsú jóo̱: —K'u̱a̱i̱nteni̱ nga nku xi k'úéjña kixi̱hi̱ ko̱ nku xi k'úéjña skjúhi̱n ni̱stjin nga n'e̱kjáíhi̱n kju̱a̱chákahi̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi yo ni xi tíbinchu. ¿A ku̱i̱chúkju̱a̱nu̱u nga un sku̱e̱nu̱u xi nkú ts'ín un sku̱e̱na? ¿A ku̱i̱chúkju̱a̱nu̱u nga n'e̱kjóho̱on kju̱a̱ni̱ma̱ xi ts'inkjáíhi̱n? ");
INSERT INTO majNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","B'a̱ i̱ncha kitsú jóo̱: —Ku̱i̱chúkju̱a̱ni̱. A̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ nga un sku̱e̱nu̱u xi nkúhu an ko̱ nga cho̱o kju̱a̱ni̱ma̱ xi ts'inkjáíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tu̱nga tsa ku̱i̱ntsu̱bo̱o nga kixi̱na̱ ko̱ tsa skjúnna̱, najmi an tíjñana nga tsja niu̱. Ja tjíntu xi tíjña ndaha̱ kui a̱ntee̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nk'ie nga kint'é já ni'yakuyá xi tee̱ niu̱, i̱ncha kits'ínkjanko̱ Santiago̱ ko̱ Jua. ");
INSERT INTO majNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tu̱nga kinchja̱ ñjahá ra̱ Jesu jóo̱ ko̱ b'i̱ kitsúhu̱: —Yo xi nkú ts'ín xu̱ta̱ xi tjíhi̱n xá e̱i̱ a̱sunntei̱ 'yún ndjá ts'ínko̱ xu̱ta̱ xingisoo̱, ko̱ xi tjíhi̱n nga'yún ts'ín nga nu'yá'éhe̱n. ");
INSERT INTO majNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tu̱nga a̱jinnu̱u najmi b'a̱ ka̱ma. Xi mje níhi̱ nga nda̱ k'aku̱ ka̱ma a̱jinnu̱u, kui xi kats'ín ni xi nda ngandanu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Xi mjehe̱ nga tjun ka̱ma a̱jinnu̱u, kui xi katuma nda̱ musu̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","A̱t'aha̱ ta̱ ndaha Ntíhi̱ Nda̱x'i̱u̱n najmi j'ai tsa tu̱ xi kui nda n'e̱he̱ ra̱. J'ai ní tu̱ xi ni xi ngandaha̱ xu̱ta̱ j'ai ts'íhin ko̱ tu̱ xi ts'i̱ínkjas'ehen yjoho̱ nga k'u̱échjíntjai nkjin xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","A̱s'a̱i i̱ncha tsichu nanki Jerico. Ko̱ nk'ie nga tíbitju Jesu yo̱ ko̱ já ni'yakuyáha̱ ko̱ xu̱ta̱ nkjin xi tje̱nko̱, tu̱ yo̱hó a̱ndai ni̱yóo̱ kab'ejña nga tíbanki chje̱ nku nda̱ ka̱ xi 'mi Bartimeo̱, xi ntíhi̱ Timeo̱ maha. ");
INSERT INTO majNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nk'ie nga kint'é nga nibá tiña Jesu nda̱ Nazaret, a̱s'a̱i kik'atuts'i̱hi̱n nga kikjintáya: —¡Ji Jesu, ji xi ntje̱he̱ David, katuma ni̱ma̱hi an! ");
INSERT INTO majNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nkjin xu̱ta̱ kinchja̱tiko̱ho̱ tu̱ xi k'u̱échja'aha ts'a. Tu̱nga tu̱ sahá 'yún kikjintáya sa: —¡Ji xi ntje̱he̱ David, katuma ni̱ma̱hi an! ");
INSERT INTO majNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","A̱s'a̱i tsasin'yún Jesu ko̱ b'a̱ kitsú: —Chu̱boho̱o ndo̱. A̱s'a̱i b'i̱ kik'ihi̱n nda̱ ko̱: —Tsjo katumahi. Ti̱síntje̱i̱n, a̱t'aha̱ tínchja̱hi. ");
INSERT INTO majNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kikjaníya najyun ndjuhu̱ ndo̱ ko̱ xu̱úhu̱n tsisintje̱n nga ngjik'úhu̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","A̱s'a̱i Jesu kingjásjaiyaha̱: —¿Mí xi mjehi nga ts'ihin? B'a̱ kitsú nda̱ ko̱: —Ji nda̱ maestru̱, mjena nga ka̱ma chjina. ");
INSERT INTO majNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","B'i̱ kitsú Jesu: —T'in ngáhani. A̱t'aha̱ kuas'ejihin nga Nti̱a̱ná kits'ín nibána, kui nga kama nkihi ri. Ta̱ kuihi chu̱bo̱ kama chjihi̱ ndo̱ ko̱ kitsjennkíhi̱ Jesu nga kits'ínko̱ ni̱yá. ");
INSERT INTO majNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nk'ie nga ja tíi̱ncha bichú tiña nanki Jerusalen nga i̱ncha j'ai Betfage ko̱ Betani̱a̱, nanki xi̱xi̱ xi tiña maha̱ a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱, a̱s'a̱i kits'ínkji Jesu jo já ni'yakuyáha̱ ");
INSERT INTO majNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nga b'i̱ kitsúhu̱: —Tankíún nanki i̱chí xi tíjña tiña ján. Nk'ie nga ja ku̱i̱chú yo̱, sa̱kúnu̱u nku ntí búrrú xi tjít'a'yún, xi najmi kje̱e ch'a b'esúhu̱n. Chjúndáyo ko̱ nibáko̱o e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ko̱ tsa tjín xi b'a̱ ku̱i̱tsu̱nu̱u nga ngju̱ásjaiyanu̱u: “¿Á b'a̱ tín'ehenu?”, b'a̱ t'ihu̱un: “Nda̱ maestru̱ rú machjéhe̱n chu̱. A̱s'a̱i rú ts'i̱ínk'óya ngáha.” ");
INSERT INTO majNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","A̱s'a̱i i̱ncha ngji já ni'yakuyóo̱ ko̱ kisakúhu̱ ntí búrrú xi tjít'a'yúnt'a nku a̱nkju̱a̱ xi tje̱n a̱ndai ni̱yóo̱ ko̱ kikjendáya. ");
INSERT INTO majNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","K'u̱a̱ xu̱ta̱ xi tíi̱ncha yo̱ kingjásjaiyaha̱: —¿Mí nihi xi tín'o? ¿Á jun tíchjundáyahanu ntí búrrúu̱? ");
INSERT INTO majNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tu̱nga b'a̱há kitsú já ni'yakuyóo̱ xi nkú nga kitsúhu̱ Jesu ko̱ kitsjántehe̱ jóo̱ nga ngju̱a̱i̱ko̱ chu̱. ");
INSERT INTO majNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","I̱ncha j'aiko̱ho̱ Jesu ntí búrrúu̱. Najyuhu̱n i̱ncha kingjásuhu̱n ko̱ Jesu y'esúhu̱n chu̱. ");
INSERT INTO majNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nkjin ṉkjún xu̱ta̱ i̱ncha kingjántu najyuhu̱n a̱ya ni̱yóo̱, ko̱ kj'a̱í ngá xi tjiaha̱ yá i̱ncha tsatet'a ko̱ kingjántu a̱ya ni̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","'Yún kikjintáya xu̱ta̱ xi yja títjuu̱n ko̱ xi yjankiu̱ nga b'i̱ i̱ncha kitsú: —¡Kats'ínk'ankiná Nti̱a̱ná! ¡Nti̱a̱ná nda kats'ínko̱ xi kits'ín nibá ngajoho̱! ");
INSERT INTO majNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Nti̱a̱ná nda kats'ínko̱ xi kits'ín nibá nga ku̱a̱téxuma, xi ts'i̱ínkjáíhi̱n xáha̱ ntje̱ cháná David! ¡Kats'ínk'ankiná Nti̱a̱ná xi tíjña nk'a ján! ");
INSERT INTO majNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jas'en Jesu nanki Jerusalen ko̱ ngji na̱tsihi̱n ni̱nku̱ má ma ñjakú xu̱ta̱. Nk'ie nga ja kamaha̱ nga tsasehe̱ ngayjee̱ ni xi tjín a̱ndaihi̱, a̱s'a̱i tsitju nga ngjiko̱ nanki Betani̱a̱ já ni'yakuyá xi te joo̱. A̱t'aha̱ ja kama ngixun. ");
INSERT INTO majNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ni̱stjin xi ma ndyjuu̱n nk'ie nga i̱ncha tsitju ngáha nanki Betani̱a̱, tu̱ kama bjohó ra̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kjin tje̱n sa nga kikie nku yá higuera̱ xi xkfén ko̱ ngjisehe̱ yóo̱ tsa tu̱ ahá ni sa̱kúhu̱ tu. Tu̱nga nk'ie nga tsichuk'úhu̱n yóo̱, tu̱ ndahá nku tu najmi kisakúhu̱, tu̱ subahá xka̱. A̱t'aha̱ najmi ni̱stjihi̱n tu higo̱. ");
INSERT INTO majNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A̱s'a̱i b'i̱ kitsúhu̱ yá higuera̱: —Ndaha̱chí najmi ta̱ ch'a kji̱ne̱he tu xi s'e̱hi. Kint'é já ni'yakuyáha̱ nga b'a̱ kitsú. ");
INSERT INTO majNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","I̱ncha tsichu nanki Jerusalen ko̱ jas'en má ma na̱tsihi̱n ni̱nku̱. A̱s'a̱i kik'atuts'i̱hi̱n Jesu nga kik'onsje já xi tíi̱ncha batéña ko̱ xi tíi̱ncha b'atse chu̱ yo̱. Kits'ínk'ótsjá yámixa̱ha̱ já xi tíi̱ncha ts'ínk'óntjaiya to̱on ko̱ yáxile̱he̱ já xi tíi̱ncha batéña chu̱tuju. ");
INSERT INTO majNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ko̱ ta̱ ndaha nku najmi ch'a kitsjántehe̱ tsa kj'u̱a̱tikjáko̱ na̱tsihi̱n ni̱nku̱ tsa mí nihi. ");
INSERT INTO majNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","B'i̱ kitsú nga y'éjña chji éhe̱n Nti̱a̱ná: —B'a̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “B'a̱ k'úíhi̱n ni'yana̱ nga kui xi ka̱ma ni'ya xi má nga xu̱ta̱ xi ni̱baha ngayjee̱ na̱xi̱nantá xi tjín a̱sunntee̱ i̱ncha ku̱i̱nchja̱ko̱ Nti̱a̱ná.” Tu̱nga jun a̱ntehe̱ já ndyjé tín'e mo. ");
INSERT INTO majNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kint'é én xu'bi̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ i̱ncha tsangisjai ni̱yá xi nkú ts'ín ka̱ma ts'i̱ínk'iehen Jesu. Tu̱nga i̱ncha tsankjúhún Jesu, a̱t'aha̱ ngayjee̱ xu̱ta̱ nkjiu̱n tíi̱ncha ma nkjúhu̱n xi nkú ts'ín tíbakúya. ");
INSERT INTO majNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nk'ie nga ja kama jyuu̱n, tsitju a̱jin na̱nti̱o̱ Jesu ko̱ já ni'yakuyáha̱. ");
INSERT INTO majNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nk'ie nga ta̱ jyuhu̱n ni̱stjin xi ma ndyjuu̱n, i̱ncha j'a má xi tje̱hen síjña yá higuera̱ ko̱ kikie nga santaha ko̱ kja̱ma̱ha̱ yóo̱ ja kixí. ");
INSERT INTO majNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","J'áítsjehe̱n Pedro̱ niu̱, a̱s'a̱i b'a̱ kitsú: —Ji nda̱ maestru̱, cha̱se̱ ma ri̱. Ja kixí yá higuera̱ xi ndjá kichubako̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","A̱s'a̱i b'i̱ kitsú Jesu: —N'e̱ s'ejiun Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kju̱axi̱ ni xi tíxinnu̱u. Tu̱ yáhá ni xi b'a̱ ku̱i̱tsu̱hu̱ a̱sunntu tje̱nki̱ xu'bi̱: “Ti̱yú xin yo̱ ko̱ chja̱nikj'ajin yjohi̱ ntáchak'uu̱n”, ka̱ma xi nkú ku̱i̱tsu̱ tsa najmi jo jan ka̱maha̱ nga s'e̱jihi̱n nga b'a̱ ka̱ma xi nkú nga títsu. ");
INSERT INTO majNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kui nga b'a̱ tíxihi̱nnu̱u. Ngayjee̱ ni xi ku̱i̱nchíhu̱u Nti̱a̱ná nga chu̱bako̱o, n'e̱ s'ejiun nga n'e̱kjóho̱on ko̱ b'a̱ ka̱ma. ");
INSERT INTO majNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","’Nk'ie nga tíchubako̱o Nti̱a̱ná, n'e̱ndyjat'oho̱o tsa tjín xi tjínko̱kju̱a̱nu̱u, tu̱ xi b'a̱ ts'ín ta̱ Na̱'minu̱u xi tíjñaha ndji̱o̱jmi ján ts'i̱ínndyjat'aha̱nu̱u ngatitsunnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tu̱nga tsa najmi n'e̱ndyjat'o, ta̱ ndaha Na̱'minu̱u xi tíjña ndji̱o̱jmi ján najmi ts'i̱ínndyjat'a ngatitsunnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","A̱s'a̱i ta̱ i̱ncha j'ai ngáha nanki Jerusalen. Nk'ie nga tsú'ba Jesu má ma na̱tsihi̱n ni̱nku̱, a̱s'a̱i j'aik'úhu̱n já na̱'mi k'aku̱, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ jáchá xi ta̱ tjíhi̱n xá. ");
INSERT INTO majNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","B'a̱ i̱ncha kitsúhu̱: —¿Mí xá xi tjíhin nga b'a̱ tín'ei? ¿Yá xi kitsjá xáhi nga b'a̱ tín'ei? ");
INSERT INTO majNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","B'i̱ kitsú Jesu: —Ko̱ an ta̱ kuasjáíyanu̱u nku ni. N'e̱k'óyanú, a̱s'a̱i xínyanu̱u mí xáha xi tjínna nga b'a̱ títs'ian. ");
INSERT INTO majNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Yá xi kits'ín nibáha̱ Jua Bautista̱ nga j'aiténtá xu̱ta̱? ¿A Nti̱a̱ná, a ra̱ xu̱ta̱ a̱sunntei̱hí? N'e̱k'óyanú. ");
INSERT INTO majNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A̱s'a̱i b'i̱ kitsúhu̱ xinkjín nga kinchja̱ni̱jmíyaha niu̱: —Tsa: “Nti̱a̱ná kits'ín nibáha̱ Jua”, ku̱i̱xíaán, a̱s'a̱i b'a̱ ku̱i̱tsu̱ná: “¿Á najmi kis'ejihi̱nnu̱u ni xi kitsúhu Jua?” ");
INSERT INTO majNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tu̱nga najmi ka̱ma tsa: “Xu̱ta̱ a̱sunntei̱ kits'ín nibáha̱”, ku̱i̱xíaán. B'a̱ i̱ncha kitsúhu̱ xinkjín a̱t'aha̱ tsankjún xu̱ta̱ nkjiu̱n, a̱t'aha̱ ngayjee̱ xu̱ta̱ b'a̱ tsu nga nku nda̱ profeta̱ kama Jua. ");
INSERT INTO majNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kui nga a̱s'a̱i b'a̱ i̱ncha kitsúhu̱ ra̱ Jesu: —Najmi yai̱. A̱s'a̱i b'i̱ kitsú Jesu: —Ko̱ ta̱ ndaha an najmi xínyanu̱u yá xi kitsjána nga b'a̱ títs'ian. ");
INSERT INTO majNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","A̱s'a̱i Jesu b'i̱ ts'ín tsakúyaha̱ xu̱ta̱ nga y'éjña chu̱ba̱yaha̱: —Nku nda̱ y'éntje̱ tuntsja̱jé. Y'éngi nch'á ko̱ kits'ínnda nku a̱nte má nga ts'íónnki tuntsja̱jée̱. Kits'ínnda nku xjó nk'a tu̱ xi ka̱ma chúnntaha a̱ntee̱. Kitsjá sáha̱ a̱ntee̱ já xi maha̱ ts'ínxáko̱ tuntsja̱jée̱, a̱s'a̱i ngji kjin. ");
INSERT INTO majNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nk'ie nga ja tíjne tuu̱, a̱s'a̱i kits'ínkjisehe̱ ndo̱ nku nda̱ musu̱hu̱ já xi títs'ínxáko̱ tuntsja̱jée̱ tu̱ xi ku̱a̱nkihi̱ ra̱ tu xi kanéhe̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tu̱nga jakj'áhá jóo̱ nda̱ musu̱ nga kik'íéhe̱ ko̱ kits'ínkji tiya tiya. ");
INSERT INTO majNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","’A̱s'a̱i ta̱ kits'ínkjihí ngáha ndo̱ kj'a̱í nda̱ musu̱. Tu̱nga máha nda̱ xu'bi̱, ni kik'onntjaihi̱ jóo̱ ko̱ ch'on ṉkjún i̱ncha kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ta̱ kits'ínkjihí ngáha kj'a̱í nda̱ musu̱hu̱ ndo̱, tu̱nga kits'ínk'iehén ra̱ jóo̱ nda̱ xu'bi̱. Nkjin sa já musu̱ xi kits'ínkji ndo̱. K'u̱a̱ xi kis'ehe̱ ko̱ k'u̱a̱ xi kits'ínk'iehe̱n jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Tíjña saha̱ ndo̱ nku xi ts'i̱ín nibá, kui ntí xi tjo ṉkjúhu̱n. B'i̱ kitsú nga kits'ínkjisehe̱ jóo̱: “Sku̱e̱nkjún ntína̱ jóo̱.” ");
INSERT INTO majNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tu̱nga b'a̱há kitsúhu̱ xinkjín já xi ts'ínxáko̱ tuntsja̱jée̱: “Kui xu'bo̱ xi ts'i̱ínkjáíhi̱n ngayjee̱ ni xi tjíhi̱n na̱'mihi. Tu̱ sahá n'e̱k'ieén tu̱ xi ka̱ma ts'a̱ñáhaná ni xi ts'i̱ínkjáíhi̱n.” ");
INSERT INTO majNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A̱s'a̱i jakj'á jóo̱ ntíhi̱ ndo̱ ko̱ kits'ínk'ien. Kik'onsje yjoninte k'ie̱n na̱tsin má nga tjíntje̱ tuntsja̱jée̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Kui b'a̱ maha, ¿nkú ts'i̱íhin nda̱ xi ts'e̱ tuntsja̱jée̱? Kj'u̱a̱í ko̱ ts'i̱ínkje já xi ts'ínxáko̱ tuntsja̱jée̱ ko̱ kj'a̱í já tsjá sá ngáha̱ ra̱ a̱nte tuntsja̱jée̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿A najmi kje̱hé n'eyo ni xu'bi̱ xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná? B'a̱ títsu: Ndji̱o̱ xi kikjaníya já chji̱ne̱xjóo̱ ja j'ai ma ndji̱o̱ k'aku̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nti̱a̱ná xi b'a̱ kits'ín ko̱ ma nkjúnná nga chasehe̱é. ");
INSERT INTO majNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A̱s'a̱i mjehe̱ já xi tjíhi̱n xá nga ku̱a̱kj'ánijé Jesu, a̱t'aha̱ kamankjihi̱n nga kui kinchja̱ni̱jmíyaha nga y'éjña chu̱ba̱ya. Tu̱nga i̱ncha kitsankjúhún xu̱ta̱ nkjiu̱n ko̱ i̱ncha ngji t'axíhi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","A̱s'a̱i kin'e nibásehe̱ Jesu k'u̱a̱ já fariseo̱ ko̱ k'u̱a̱ já xi yjankihi̱ nda̱ rei̱ Herode̱ Antipa̱, tu̱ xi ts'i̱ínkijneyaha Jesu nku én xi najmi b'a̱ tjín. ");
INSERT INTO majNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","B'a̱ i̱ncha j'ai tsúhu̱: —Ji nda̱ maestru̱, yai̱ nga kju̱axi̱ én xi chubai ko̱ nga najmi ni xi sasíhi̱n xu̱ta̱ chubai. 'Yún na̱nka̱ chaseihi̱. Na̱xu̱ bakuyáí sisin ni xi ts'e̱ Nti̱a̱ná. Kui nga, ¿a ma b'echjíhi̱í nda̱ títjun Cesa̱r ni xi f'áchjíná, a ra̱ najmi? ¿A k'u̱a̱íhi̱, a ra̱ najmi k'u̱a̱íhí ra̱á? ");
INSERT INTO majNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tu̱nga behé Jesu kju̱a̱joho̱nkjihi̱n jóo̱ ko̱ b'i̱ kitsúhu̱: —¿Á an tíchjut'ayák'uhunnú? Nibáko̱nú e̱i̱ nku to̱on denari̱o̱ tu̱ xi kuasehe̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","A̱s'a̱i j'aiko̱ jóo̱ to̱oo̱n ko̱ b'a̱ kitsú Jesu: —¿Yá xi ts'e̱ sénni̱stjii̱n ko̱ j'áín xi tjít'aha̱ to̱oi̱n? B'a̱ kitsú jóo̱: —Ts'e̱ nda̱ títjun Cesa̱r. ");
INSERT INTO majNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","A̱s'a̱i b'i̱ kitsú Jesu: —Tjoho̱on nda̱ títjun Cesa̱r ni xi ts'e̱ nda̱ títjun Cesa̱r, ko̱ tjoho̱on Nti̱a̱ná ni xi ts'e̱ Nti̱a̱ná. Tu̱ ni xí kama nkjúhún ra̱ jóo̱ én xi kits'ínk'óya Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Já saduseo̱ bakúya nga najmi kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱. A̱s'a̱i k'u̱a̱ xi i̱ncha j'aisehe̱ Jesu nga kingjásjaiyaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","B'i̱ i̱ncha kitsúhu̱: —Ji nda̱ maestru̱, y'ét'aná Moise: “Tsa nku nda̱ xi tíjñaha̱ chju̱ún ku̱a̱yá nga najmi kis'eko̱ho̱ ntí chju̱úhu̱n, nda̱ nts'e̱ tjíhin nga ku̱i̱xanko̱ ngáha chju̱úhu̱n, tu̱ xi b'a̱ ts'ín s'e̱he̱ ra̱ ntí nda̱ nts'e̱ xi k'ie̱n.” ");
INSERT INTO majNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","’Y'entu yatu já xi nts'e̱ maha xinkjín. Tsixan nda̱ xi tjuu̱n tu̱nga b'a̱há tjíu̱n k'ien. Najmi kis'ehe̱ ntí. ");
INSERT INTO majNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A̱s'a̱i nda̱ xi ma joho tsixanko̱ ngáha ta̱chjúu̱n, tu̱nga ta̱ k'iehén ko̱ najmi kis'ehe̱ ntí. B'a̱ ta̱ kamaha̱ nda̱ xi ma jahan. ");
INSERT INTO majNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","B'a̱ ta̱ ts'ín tsixanko̱ ta̱chjúu̱n já nts'e̱ xi k'oo̱, tu̱nga ndahá nku najmi kis'ehe̱ ntí. A̱skahan ta̱ k'ien ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","’Ni̱stjin nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱, ¿yá nda̱ha xi ka̱ma ts'e̱ ta̱chjúu̱n, a̱t'aha̱ nga yatuu̱ tsixanko̱? ");
INSERT INTO majNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi b'a̱ tjín ni xi chubo, a̱t'aha̱ najmi mankjinnu̱u ni xi tjít'a éhe̱n Nti̱a̱ná ko̱ ta̱ ndaha nga'yúhu̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","A̱t'aha̱ nk'ie nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱, najmi ta̱ ku̱i̱xahan ko̱ ta̱ ndaha najmi ts'i̱ínkixan ntíhi̱. B'a̱ ní ts'ín k'úéntu xi nkú ts'ín tjíntu ntítsje xi tjín ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","’Tu̱nga nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱, ¿a najmi kje̱hé n'eyo má y'ét'a Moise má nga tínchja̱ni̱jmíyaha na'yá ntsje̱ xi títiu̱? B'a̱ kitsú Nti̱a̱ná nga kinchja̱ko̱ Moise: “An xi Nti̱a̱ha̱ Abraham, Nti̱a̱ha̱ Isaac ko̱ Nti̱a̱ha̱ Jacob.” ");
INSERT INTO majNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nti̱a̱ná najmi Nti̱a̱ha̱ ani̱ma̱. Nti̱a̱ha̱ ní xu̱ta̱ tík'un. Tu̱ xí najmi b'a̱há tjín ni xi chubo. ");
INSERT INTO majNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ta̱ j'ai nku nda̱ chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. Kint'é nda̱i̱ ni xi kichubani̱jmíyaha ko̱ kamankjihi̱n nga b'a̱ tjín én xi kinchja̱ Jesu. A̱s'a̱i kingjásjaiyaha̱: —A̱jihi̱n ngayjee̱ kju̱a̱téxumoo̱, ¿má kju̱a̱téxumaha xi 'yún chjíhi̱ ra̱? ");
INSERT INTO majNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","A̱s'a̱i b'i̱ kitsú Jesu: —Kui xu'bi̱: “Ta̱sinñju, xu̱ta̱ Israel. Nti̱a̱ xi Nti̱a̱ná maha, kui xi Nti̱a̱ nku tutu. ");
INSERT INTO majNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","N'e̱tjóí Nti̱a̱ná xi Nti̱a̱hi̱ maha ngayjee̱ ani̱ma̱hi̱ ko̱ ngayjee̱ nga'yíhi̱n. N'e̱tjóí xi nkú ts'ín tinchin ko̱ xi nkú ts'ín n'enkjíntak'uin.” ");
INSERT INTO majNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kju̱a̱téxuma xu'bi̱ xi ma joho: “N'e̱tjóí xu̱ta̱hi̱ xi nkú nga ts'ín tjohi yjohi̱.” Najmi tjín kj'a̱í kju̱a̱téxuma xi 'yún chjí saha̱ ra̱ nga nga joo̱ kju̱a̱téxuma xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A̱s'a̱i b'a̱ kitsú ndo̱: —Joho̱n, nda̱ maestru̱, b'a̱ tjín. Kju̱axi̱ ni xi tíbixín, nga nku tutu maha Nti̱a̱ná ko̱ nga najmi tjín sa kj'a̱í. ");
INSERT INTO majNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ko̱ nga n'e̱tjáá Nti̱a̱ná ngayjee̱ ani̱ma̱ná ko̱ ngayjee̱ nga'yúnná ko̱ xi nkú ts'ín n'enkjín t'ak'aán, ko̱ nga n'e̱tjáá xu̱ta̱ná xi nkú nga ts'ín tjoná yjoná, kui xi 'yún chjí saha̱ ra̱ nga tu̱ má chje̱hé ni xi s'etísun na̱chan chje̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nk'ie nga kint'é Jesu nga b'a̱ tjín én xi kinchja̱ ndo̱, a̱s'a̱i b'i̱ kitsúhu̱: —Najmi kjin tinchihi̱n má batéxuma Nti̱a̱ná. Ndaha nku najmi ta̱ kama k'un kingjásjaiya saha̱ ra̱ Jesu tsa mí nihi. ");
INSERT INTO majNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nk'ie nga tíbakúya Jesu má ma na̱tsihi̱n ni̱nku̱, a̱s'a̱i b'i̱ kitsú: —¿Nkú tjíhi̱n ra̱ nga b'a̱ tsuhu já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ nga ntje̱he̱ David nibáha̱ ra̱ xi Cristo̱? ");
INSERT INTO majNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A̱t'aha̱ ta̱ kuihi David b'a̱ kitsú nk'ie nga Espiri̱tu̱ Santo̱ho̱ Nti̱a̱ná kits'ínkinchja̱ha̱: Nti̱a̱ná b'a̱ kitsúhu̱ Nda̱ Nti̱a̱na̱: “Ti̱nchint'ání má batexuma. K'uentú maná já kontra̱hi̱ kinte tsu̱kui.” ");
INSERT INTO majNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","B'a̱ ts'ín ta̱ kuihi David kitsúhu nga Nda̱ Nti̱a̱ha̱ maha xi Cristo̱. Kui nga, ¿nkú ts'ín ntje̱he̱ David nibáha̱ ra̱ xi Cristo̱? Tsjo ṉkjún kamaha̱ xu̱ta̱ nkjin xi tíi̱ncha mjéñjuhu̱ ni xi tínchja̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","B'a̱ kitsú sa Jesu nga tsakúya: —Chúhu̱un yjonu̱u já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. Kui xi tsjoho̱ nga bja najyun ndju nga b'ema ko̱ nga tsjo ts'ín súniñaha̱ ni̱yátée̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tsjoho̱ nga b'entusún yáxile̱ xi tíi̱ncha títjun ni'ya sinagoga̱ ko̱ nga b'entu a̱nte k'aku̱ xi tjín nku s'í. ");
INSERT INTO majNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kui xi kje'áha̱ ni'yaha̱ jminchjín xi ja k'ien x'i̱hi̱n ko̱ a̱s'a̱i chu̱ba̱ 'yúhún tse nchja̱ko̱ maña̱ Nti̱a̱ná, tu̱ xi b'é'mat'aihin yjoho̱. 'Yún un sku̱e̱he̱ já xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A̱nkjín kaxa̱ to̱on chje̱ kab'ejña Jesu ko̱ tíbase xi nkú ts'ín tíbinchá xu̱ta̱ to̱on chje̱he̱ yo̱. Nkjin maha já nchi̱ná xi 'yún tse to̱on tíbinchá. ");
INSERT INTO majNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tu̱ j'aihí nku ta̱chju̱ún xi ja k'ien x'i̱hi̱n. Kui xi jo to̱on xi̱ tíntí tsinchá kaxa̱ chje̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","A̱s'a̱i kinchja̱ha̱ Jesu já ni'yakuyáha̱ ko̱ b'i̱ kitsúhu̱: —Kju̱axi̱ ni xi tíxinnu̱u. Ta̱chju̱ún x'a̱i̱n 'yún tse kuatsjá sa nga ngayjee̱ xu̱ta̱ xi k'oo̱ xi tíi̱ncha b'éya to̱on kaxa̱ chje̱. ");
INSERT INTO majNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","A̱t'aha̱ ngayjee̱ xu̱ta̱ xi k'oo̱ ni xi tíb'ankihi̱ kuatsjá. Tu̱nga máha ta̱chjíi̱n, ngayjee̱ to̱on xi tíjñaha̱ nga kji̱ne̱yaha nichine kuatsjá. ");
INSERT INTO majNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nk'ie nga tíbitju Jesu má ma na̱tsihi̱n ni̱nku̱, a̱s'a̱i nku nda̱ ni'yakuyáha̱ b'a̱ kitsúhu̱: —Ji nda̱ maestru̱, cha̱se̱ ma ri̱. ¡Á b'a̱ nkjún k'uhun ndji̱o̱! ¡Á b'a̱ tsjo ts'ín kin'endaha ni xi tjíhin e̱i̱! ");
INSERT INTO majNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A̱s'a̱i b'i̱ kitsú Jesu: —¿A tíyai ni̱nku̱ ko̱ xjóo̱ ko̱ ngayjee̱ ni xi kin'enda e̱i̱? Ndaha nku ndji̱o̱ najmi ta̱ s'e̱jñasuhu̱n ra̱ xinkjín. Ngayjee̱ n'e̱xúya. ");
INSERT INTO majNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nk'ie nga kab'ejña Jesu a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱ kixi̱ yaha̱ ni̱nku̱, a̱s'a̱i Pedro̱, Santiago̱, Jua ko̱ Andre i̱ncha kingjásjaiya t'axíhi̱n: ");
INSERT INTO majNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—T'inyani̱, ¿nkjé b'a̱ ka̱ma? ¿Mí nihi xi ku̱a̱kúchji títjun nk'ie nga ja ku̱i̱tjusun ngayjee̱ niu̱? ");
INSERT INTO majNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A̱s'a̱i kinchja̱ Jesu: —Chúhu̱un yjonu̱u nga najmi tu̱ ch'a xi k'u̱a̱na̱cha̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","A̱t'aha̱ nkjin maha xi kj'u̱a̱í nga an ts'i̱ín ma yjoho̱. “An xi kui”, ku̱i̱tsu̱ ko̱ k'u̱a̱na̱cha̱ha̱ nkjin xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Nk'ie nga ku̱i̱nú'yó nga tjín kju̱a̱chán ko̱ nga ku̱i̱nchja̱ni̱jmíyaha xu̱ta̱ kju̱a̱chán xi tíma, najmi tu̱ binkjun. A̱t'aha̱ tjíhin ni nga b'a̱ ka̱ma, tu̱nga najmi kje̱hé kfe̱ a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","A̱t'aha̱ xu̱ta̱ xi tjín nku nanki kja̱ánko̱ xu̱ta̱ xi kj'a̱í nanki. Nku nda̱ rei̱ kja̱ánko̱ kj'a̱í nda̱ rei̱. Chón ka̱ma kj'a̱í kj'a̱í nankihi ko̱ s'e̱ kjintíá. Nk'ie nga ja b'a̱ tíma, a̱s'a̱ihí tíb'atuts'i̱hi̱n kju̱a̱ni̱ma̱ xi s'e̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Jun chúhu̱un yjonu̱u. A̱t'aha̱ já tjíxóo̱ n'e̱kjas'ennu̱u ko̱ s'e̱nu̱u a̱ya ni'ya sinagoga̱. Nga̱t'ana̱ ngju̱a̱i̱ko̱ho̱nu̱u xu̱ta̱ nginku̱n já títjuu̱n ko̱ nginku̱n já rei̱, tu̱ xi k'úínyaha̱ ru̱u jóo̱ yáha an. ");
INSERT INTO majNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kintehe̱ ni nga kfe̱ a̱sunntee̱ tjíhin nga s'e̱ni̱jmíhi̱ én nda tsuhu̱ Nti̱a̱ná ngayjee̱ na̱xi̱nantá xi tjín a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nk'ie nga ngju̱a̱i̱ko̱nijénu̱u xu̱ta̱ nga ts'i̱ínkjas'ennu̱u nginku̱n já tjíxóo̱, najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u mí éhen xi ku̱i̱xíún. Én xi k'u̱a̱i̱nu̱u kui chu̱bo̱ xi chu̱bo, a̱t'aha̱ najmi jun xi chu̱bo. Espiri̱tu̱ Santo̱ xi ku̱i̱nchja̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","’Xi tí'mi nda̱ nts'e̱ ts'i̱ínkjas'en nga n'e̱k'ien nda̱ nts'e̱. Xi tí'mi na̱'mi ts'i̱ínkjas'en ntíhi̱. Xi tí'mi ntí kja̱ánko̱ xi cháha̱ ko̱ ts'i̱ínk'ien. ");
INSERT INTO majNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nga̱t'ana̱ ts'i̱ín unkiehe̱nu̱u ngayjee̱ xu̱ta̱. Tu̱nga xi tu̱ nku ndjáhá ku̱a̱si̱njña, kui xi k'u̱a̱nki. ");
INSERT INTO majNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Y'ét'a nda̱ profeta̱ Daniel nk'ie nga najmi cha̱nkjún a̱nte tsjehe̱ ni̱nku̱. Cho̱o xi b'a̱ ts'i̱íu̱n. B'i̱ kitsú Jesu ko̱ xi títs'ínya xu̱ju̱i̱n katumankjihi̱n. B'i̱ ta̱ kitsú ya: —Kui ni̱stjiu̱n katanka xu̱ta̱ xi tjíntu a̱nte Judea̱ xi tje̱hen a̱sunntu tje̱nnki̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Xi kab'ejñasun nk'a ni'yaha̱, najmi tu̱ ku̱i̱tjujen ko̱ ta̱ ndaha najmi tu̱ kju̱a̱s'en ni'yaha̱ nga kj'u̱a̱íkj'ásje ni xi tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Xi kafi jñá, najmi tu̱ k'o̱óya nga kj'u̱a̱íkj'á najyuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","’¡Ni̱ma̱ rú ts'íhin jminchjín xi y'a ntí ko̱ xi títs'ínki ntí kui ni̱stjiu̱n! ");
INSERT INTO majNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ti̱nchíhu̱u Nti̱a̱ná tu̱ xi najmi ni̱stjin chu̱nch'án b'a̱ ka̱maha. ");
INSERT INTO majNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A̱t'aha̱ 'yún s'e̱ kju̱a̱ni̱ma̱ ni̱stjin xu'bo̱, kju̱a̱ni̱ma̱ xi najmi kje̱e s'e santa nkúhu nga tuts'ihi̱n ni nga kits'ínnda Nti̱a̱ná a̱sunntee̱. Ko̱ ta̱ ndaha najmi s'e̱ a̱skahan nku xi b'a̱ joyaha. ");
INSERT INTO majNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tsa najmi ku̱a̱tekjá Nti̱a̱ná chuba ni̱stjin xu'bo̱, nda ra̱ nku najmi k'u̱a̱nki kai. Tu̱nga jahá tsatekjá Nti̱a̱ná chuba ni̱stjin xu'bo̱ ngandaha̱ xu̱ta̱ xi j'ájin. ");
INSERT INTO majNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Kui ni̱stjiu̱n tsa tjín xi b'a̱ ku̱i̱tsu̱nu̱u: “Cha̱so̱o, e̱i̱ tíjña xi kits'ín nibá Nti̱a̱ná”, ko̱ tsa b'a̱ ku̱i̱tsu̱nu̱u: “Cha̱so̱o, ján tíjña”, najmi tu̱ n'e s'ejiun. ");
INSERT INTO majNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","A̱t'aha̱ i̱ncha kj'u̱a̱í xi b'a̱ ku̱i̱tsu̱ tsank'á nga kui xi kits'ín nibáha̱ Nti̱a̱ná ko̱ xi já profeta̱ ts'i̱ín ma tsank'á yjoho̱. Kui xi i̱ncha ts'i̱ín nkjin tíkjá kju̱a̱nkjún tu̱ xi k'u̱a̱na̱cha̱ha̱ ra̱ xu̱ta̱, xi ko̱hó ra̱ xu̱ta̱ xi j'ájin Nti̱a̱ná ka̱maha̱ ra̱ k'u̱a̱na̱cha̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tu̱nga máha jun, chúhu̱un yjonu̱u. Jahá tíxinya títjunnu̱u ngatentee̱ ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Tu̱nga kui ni̱stjiu̱n, a̱skahan nga ja kj'u̱a̱ kju̱a̱ni̱ma̱ xu'bo̱, ka̱ma jyun ts'íu̱ ko̱ sóo̱ najmi ta̱ ts'i̱ín ndzjehen. ");
INSERT INTO majNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Niñu xi tjín nk'a ján ku̱i̱xu̱ntu ko̱ k'u̱a̱tsé ni xi tjín nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nk'iehé cha̱ Ntíhi̱ Nda̱x'i̱u̱n nga tje̱njin ni̱nti̱u̱ nga nibáko̱ ngayjee̱ nga'yúhu̱n ko̱ kju̱a̱chánkaha̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A̱s'a̱i ts'i̱ínkji ntítsjehe̱ nga k'u̱éntukú xu̱ta̱ xi j'ájin xi tjíntu tu̱ má xi tje̱hén ni, b'aha̱ ra̱ má b'atuts'i̱hi̱n ra̱ a̱sunntee̱ santaha má fekuhu̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Katumankjinnu̱u ni xi b'éjña chjinu̱u yá higuera̱. Nk'ie nga ja tju nts'én tjiaha̱ yóo̱ ko̱ tjuhu̱ xka̱, yo nga ja tíbichú tiña chu̱nubóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","B'a̱ ta̱ ts'ín nk'ie nga ja cho̱o nga ja b'a̱ tíma, katumankjinnu̱u nga ja tje̱n tiña Ntíhi̱ Nda̱x'i̱u̱n xi nkúhu tsa a̱sti a̱nkju̱o̱ síjña. ");
INSERT INTO majNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kju̱axi̱ ni xi tíxinnu̱u. Ku̱i̱tjusun ngayjee̱ ni xu'bi̱ kintehe̱ ni nga ku̱a̱yáyje xu̱ta̱ xi tjín nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ka̱maha̱ a̱sunntee̱ ko̱ nk'a ján ndyja̱, tu̱nga énna̱ najmi kj'u̱a̱ tiya. ");
INSERT INTO majNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Tu̱nga má ni̱stjin ko̱ chu̱ba̱ nga b'a̱ ka̱moo̱, najmi ch'a xi behe̱, ta̱ ndaha ntítsje xi tjín ndji̱o̱jmi ján ko̱ ta̱ ndaha Ntíhi̱ Nti̱a̱ná. Nku tutuhú Nti̱a̱ Na̱'miná xi be. ");
INSERT INTO majNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kui b'a̱ maha, t'endahanu yjonu̱u ko̱ chúnnto yjonu̱u, a̱t'aha̱ najmi yo nkjé b'a̱ ka̱moo̱. ");
INSERT INTO majNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","’Xi nkú joyaha nku nda̱ xi tífi kjin. Kintehe̱ ni nga ku̱i̱tju ni'yaha̱ tsjá xáha̱ nga kúnkú já musu̱hu̱ nga ts'i̱ín xá xi maha̱ ts'ín. Ko̱ b'a̱ tsuhu̱ nda̱ musu̱ xi kunntá a̱nkju̱o̱ nga kat'ejña nda. ");
INSERT INTO majNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kui nga ti̱ntsu̱ba̱ ndahanu, a̱t'aha̱ najmi yo nkjé kj'u̱a̱í nda̱ xi ts'e̱ ni'yoo̱, tsa nga ja tífi ma 'ña̱, a ra̱ masen ni̱stje̱n, a ra̱ nga kji̱ntá xa̱nto̱, ko̱ a ra̱ nga ja tífi ma sen. ");
INSERT INTO majNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ti̱ntsu̱ba̱ ndo tu̱ xi tsa kj'u̱a̱í tje̱n'yúhun, najmi kisuntuféhenu nga kj'u̱a̱íkienu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ni xi tíxinnu̱u, b'a̱ ta̱ tíxihi̱n ngayjee̱ xu̱ta̱ xingisoo̱: ¡Ti̱ntsu̱ba̱ ndo! ");
INSERT INTO majNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ndyja sa jo ni̱stjin nga ku̱i̱chú S'í Pascu̱a̱, nk'ie nga chine ni̱nku̱a̱n xi najmi kamandako̱ho na̱'yu̱ san. Já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ i̱ncha tsangisjai ni̱yá xi nkú ts'ín k'u̱a̱na̱cha̱ha̱ ra̱ Jesu nga ku̱a̱kj'ánijé ko̱ ts'i̱ínk'ien. ");
INSERT INTO majNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tu̱nga b'a̱há i̱ncha kitsúhu̱ xinkjín: —Najmi tu̱ a̱jihi̱n s'íu̱ chjubéé ndo̱ tu̱ xi najmi k'u̱ésihi xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nk'ie nga tíjña Jesu nanki Betani̱a̱, ni'yaha̱ Simon, nda̱ xi k'uhu̱n ch'in fentujnu, nk'ie nga kab'ejñat'a yámixo̱, a̱s'a̱i nku ta̱chju̱ún j'aiko̱ ntá sinjne̱ xi chjí ṉkjún, xi naxú nardo̱ kikjin kamandako̱ho. Kui xi tíi̱nchaha̱ nku lubata̱ ndji̱o̱ chjí. Tsakján ta̱chjúu̱n lubata̱ ndji̱o̱ ko̱ tsaténdzjojnú nintaku̱ Jesu ntá sinjne̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","A̱s'a̱i k'u̱a̱ já xi tíi̱ncha yo̱ kama kjaha̱n ko̱ b'i̱ ngján b'a̱ i̱ncha kitsúhu̱ xinkjín: —¿Á b'a̱ ts'ín kuan'ekatsún tiyaha ntá sinjne̱? ");
INSERT INTO majNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A̱t'aha̱ kama ts'ati jan unchan to̱on denari̱o̱ kuach'a kai, tu̱ xi kui to̱oo̱n k'u̱a̱i̱hi̱ ra̱ xu̱ta̱ x'a̱n. Ta̱ i̱ncha kinchja̱yane ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","A̱s'a̱i b'i̱ kitsú Jesu: —Tjehe̱nntoho̱o ta̱chjúu̱n. ¿Á jun tín'estihi̱ru̱u? Nda tjín ni xi kuats'ínna. ");
INSERT INTO majNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Xu̱ta̱ x'a̱n bi, tehe̱nte k'úéntujínnu̱u ko̱ ka̱ma ku̱i̱si̱nko̱o nk'ie nga ka̱ma mjenu̱u. Tu̱nga an najmi tehe̱nte kúáte̱jñajinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kui ta̱chjíi̱n kuatsjá xi nkú tjín tíjñaha̱. Ja kuak'íénda títjun yjonintena̱ nga kuak'ojnuhu̱ ntá sinjne̱i̱ tu̱ xi s'e̱yanjihinna. ");
INSERT INTO majNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kju̱axi̱ ni xi tíxinnu̱u. Tu̱ má xi tje̱hén ni nga s'e̱ni̱jmí én nda tsuhu̱ Nti̱a̱ná nga ngúsuhu̱n a̱sunntee̱, ta̱ chu̱bani̱jmíyaha ni xi kuats'ín ta̱chjíi̱n. B'a̱ ts'ín n'e̱kj'áítsjehen. ");
INSERT INTO majNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","A̱s'a̱i Juda̱ Iscariote̱, nku nda̱ ni'yakuyá xi te joo̱, ngjisehe̱ já na̱'mi k'aku̱ tu̱ xi ts'i̱ínkjas'ehe̱n ra̱ Jesu jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nk'ie nga kint'é jóo̱ éi̱n, kama tsjoho̱ ko̱ b'a̱ i̱ncha kitsúhu̱ Juda̱ nga tsjáha̱ to̱on. A̱s'a̱i tsangisjai ni̱yá Juda̱ xi nkú ts'ín ka̱ma ts'i̱ínkjas'ehen Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ni̱stjin nga b'atuts'i̱hi̱n ra̱ S'í Pascu̱a̱, nk'ie nga chine ni̱nku̱a̱n xi najmi kamandako̱ho na̱'yu̱ san ko̱ nga n'ek'ien chu̱tsa̱nka̱ha̱ s'íu̱, a̱s'a̱i já ni'yakuyáha̱ Jesu kingjásjaiyaha̱: —¿Má xi tje̱hen mjehi nga kuankínk'iendai̱ tu̱ xi chi̱ne̱heni nichinehe̱ S'í Pascu̱a̱? ");
INSERT INTO majNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A̱s'a̱i b'a̱ kitsúhu̱ jo já ni'yakuyáha̱ nga kits'ínkji: —Tankíún a̱jin na̱nti̱o̱. Yo̱ sa̱tékjó nku nda̱ xi y'a nku ndji̱í ntánijua. Tsjénnkihu̱u ");
INSERT INTO majNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ko̱ má nga kju̱a̱s'en b'a̱ t'ihu̱un nda̱ xi ts'e̱ ni'yoo̱: “B'a̱ títsu nda̱ maestru̱: ¿Má xi kui a̱nte má nga kjíne̱ka̱ nichinehe̱ S'í Pascu̱a̱ já ni'yakuyána̱?” ");
INSERT INTO majNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A̱s'a̱i ku̱a̱kúnu̱u nku a̱nte tayá chánka xi ja tjínda xi tje̱hen nk'a ni'yaha̱. Yo̱ t'endo ni xi chi̱ne̱é. ");
INSERT INTO majNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","A̱s'a̱i tsitju já ni'yakuyóo̱. I̱ncha tsichu a̱jin na̱nti̱o̱ ko̱ b'a̱ kamat'ain xi nkú nga kitsúhu̱ Jesu. Yo̱ i̱ncha y'énda nichinehe̱ S'í Pascu̱a̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nk'ie nga ja kama jyuu̱n, tsichuko̱ Jesu já ni'yakuyá xi te joo̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nk'ie nga ja tjíntut'á yámixo̱ nga tíi̱ncha kjine nichinehe̱ S'í Pascu̱a̱, a̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Nku xi tje̱njinnu̱u, xi ta̱ e̱i̱ tíneko̱na, ts'i̱ínkjas'enna. ");
INSERT INTO majNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A̱s'a̱i kik'ientu babaha̱ já ni'yakuyóo̱ ko̱ nga nkúnkú kingjásjaiyaha̱: —¿A an? ");
INSERT INTO majNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A̱s'a̱i b'i̱ kitsú Jesu: —Nku xi te joo̱, xi ta̱ tíbakj'á nichine xi tjíya ta̱ba̱ má nga tíbakj'a. ");
INSERT INTO majNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A̱t'aha̱ b'a̱ n'e̱he̱ Ntíhi̱ Nda̱x'i̱u̱n xi nkú ts'ín tjít'a éhe̱n Nti̱a̱ná, tu̱nga, ¡ni̱ma̱ rú ts'íhin nda̱ xi ts'i̱ínkjas'ehe̱n! Tu̱ sahá ra̱ ngandaha̱ nda̱ xu'bo̱ tsa najmi kitsin. ");
INSERT INTO majNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nk'ie nga tíi̱ncha kjine nichinehe̱ S'í Pascu̱a̱, jakj'á Jesu ni̱nku̱o̱n ko̱ kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná. Tsakjánya ko̱ kitsjáha̱ jóo̱ nga b'a̱ kitsúhu̱: —Chjúbó. Kui xu'bi̱ xi yjonintena̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ko̱ ta̱ jakj'á chu̱tsíu̱n. Nk'ie nga ja kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná, a̱s'a̱i kitsjáha̱ já ni'yakuyáha̱ ko̱ i̱ncha kik'iyá chu̱tsíu̱n ngatentee̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","B'i̱ kitsúhu̱ jóo̱: —Kui xu'bi̱ xi jnína̱. Kui xi ngju̱a̱i̱ ndzjoho ngandaha̱ nkjin ṉkjún xu̱ta̱. Jnína tíb'éndako̱ tse̱tse̱ Nti̱a̱ná nd'a̱i̱ xi nkú ts'ín nda ts'i̱ínko̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kju̱axi̱ ni xi tíxinnu̱u. Najmi ta̱ k'u̱i̱ sahana ntáha̱ tuntsja̱jée̱ santa nkúhu nga ku̱i̱chú ni̱stjin nga k'u̱i̱ ngáhana xi tse̱tse̱he̱ má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nk'ie nga ja kamaha̱ nga i̱ncha kisehe̱ Nti̱a̱ná, a̱s'a̱i i̱ncha ngji a̱sunntu tje̱nnki̱ xi 'mi Yá Olivo̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","B'i̱ kitsú Jesu: —Ngatentoo̱ n'e̱ndyja̱jihu̱un yjonu̱u yáha an. A̱t'aha̱ b'a̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “Ts'in'úhu̱n nda̱ bastuu̱ ko̱ ndzjo̱ya chu̱tsa̱nko̱.” ");
INSERT INTO majNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tu̱nga nk'iehé nga kj'u̱a̱íya ngáhana ngabayoo̱, kfín títjunnu̱u Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A̱s'a̱i kinchja̱ Pedro̱: —Ndaha tsa ngatentee̱ ts'i̱ínndyja̱jihi̱n yjoho̱, tu̱nga an najmi. ");
INSERT INTO majNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","B'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxihin. Kui ni̱stje̱n xu'bi̱, kintehe̱ ni nga kji̱ntá xa̱nto̱ ni̱yá xi ma joho, b'a̱ ku̱i̱xín nga najmi yaní jan ni̱yá tjíhin. ");
INSERT INTO majNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tu̱nga b'a̱há ta̱ kitsú ngáha Pedro̱: —Ndaha tsa tjíhin nga ku̱a̱yáko̱ho, tu̱ nku nga ts'inkíéná yjona̱ nga behe. B'a̱ ta̱ i̱ncha kitsú ngatentee̱ já ni'yakuyóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","A̱s'a̱i i̱ncha tsichu nku a̱nte xi 'mi Getsemani ko̱ b'a̱ kitsúhu̱ Jesu já ni'yakuyáha̱: —Ti̱ntsu̱ba̱hanu e̱i̱. Kfínnchjako̱ maná Nti̱a̱ná ján. ");
INSERT INTO majNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ngjiko̱ Pedro̱, Santiago̱ ko̱ Jua. Kik'atuts'i̱hi̱n nga kik'ie baba ṉkjúhu̱n ko̱ kis'enta̱ha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","B'i̱ kitsúhu̱ jóo̱: —Kju̱a̱ba kitsejíhin ani̱ma̱na̱ xi nkúhu tsa kui xi ja ts'i̱ínk'ienna. Ti̱ntsu̱bo̱o e̱i̱ ko̱ ti̱ntsu̱ba̱ ndo. ");
INSERT INTO majNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A̱s'a̱i ngjindju sa i̱chí ko̱ yo̱ kingjénsten a̱nkjín santaha t'anankiu̱. Kinchja̱ko̱ Nti̱a̱ná nga tsankihi̱ tsa ka̱ma kj'u̱a̱ t'axíhi̱n chu̱ba̱ xi má nga un sku̱e̱he̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","B'i̱ kitsú: —Na̱'mi, na̱'mi chí, ji xi mahi n'ei tu̱ mí nihí ni. N'e̱kj'a t'axínní kju̱a̱ni̱ma̱ xu'bi̱. Tu̱nga katumahá xi nkú ts'ín mjehi, najmi xi nkú ts'ín mjena. ");
INSERT INTO majNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A̱s'a̱i ngjise ngáha̱ ra̱ jóo̱, ko̱ kjintufé nga j'aisehe̱. B'i̱ kitsúhu̱ Pedro̱: —Simon, ¿a kisufei? ¿A ndaha nku ora̱ najmi kuichukju̱a̱hi nga kuakinchin tík'uin? ");
INSERT INTO majNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ti̱ntsu̱ba̱ ndo ko̱ chu̱bako̱o Nti̱a̱ná tu̱ xi najmi chjút'ayák'uhu̱nnu̱u. Yuhu̱ ani̱ma̱nu̱u, tu̱nga yjonintenu̱uhú xi najmi tíchúkju̱a̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A̱s'a̱i Jesu ta̱ ngji nchja̱ko̱hó ngáha Nti̱a̱ná ko̱ ta̱ kuihí ée̱n kitsú ngáha. ");
INSERT INTO majNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nk'ie nga kik'óya ngáha má tjíntu já ni'yakuyóo̱, ta̱ kjintuféhé ngáha nga j'aisehe̱, a̱t'aha̱ tíb'échja suba nijñóo̱ tunku̱n jóo̱. Najmi ta̱ be nkú i̱ncha ku̱i̱tsu̱hu. ");
INSERT INTO majNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A̱s'a̱i ta̱ kik'óya ngáha Jesu ni̱yá xi ma jahan ko̱ b'a̱ kitsúhu̱ jóo̱: —¿A tu̱ nku kisuntuféhé so ko̱ tín'ekj'áíyo? Ja kama. Ja kuichu chu̱ba̱ nga n'e̱kjas'en Ntíhi̱ Nda̱x'i̱u̱n a̱ya ntsja xu̱ta̱ ngatitsuu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ti̱síntjo̱on ko̱ tjián. Ja nibá tiña xi títs'ínkjas'enna. ");
INSERT INTO majNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nk'ie nga ta̱ tínchja̱ha Jesu, tu̱ j'aihí Juda̱, nku nda̱ ni'yakuyá xi te joo̱. J'aiko̱ nkjin ṉkjún xu̱ta̱ xi kits'ín nibá já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ jáchá xi ta̱ tjíhi̱n xá. I̱ncha y'a ki̱cha̱ ndju ko̱ yá nga i̱ncha j'ai. ");
INSERT INTO majNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nda̱ xi títs'ínkjas'en Jesu tsinchá'a títjun jóo̱ nga b'i̱ kitsúhu̱: —Xi kjexu̱'ba nga kjuaniñaha̱, kui xi Jesu. Chjúbó ko̱ t'e'yún sisiun nga tankínko̱o. ");
INSERT INTO majNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nk'ie nga j'ai, tje̱n'yún ngjik'úhún ra̱ Jesu ko̱ b'a̱ kitsúhu̱ nga kikjexu̱'ba: —Ji nda̱ maestru̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","A̱s'a̱i i̱ncha jakj'ánijéhe̱ jóo̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tu̱nga nkuhú ki̱cha̱ ndju ts'asje nku nda̱ xi síjña yo̱. Kits'ín'uhu̱n nku nda̱ musu̱hu̱ nda̱ na̱'mi títjuu̱n. Tsatet'a tja̱ba̱xínñju. ");
INSERT INTO majNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A̱s'a̱i b'i̱ kitsúhu̱ Jesu jóo̱: —¿A nda̱ ndyjéná? ¿Á i̱xí ki̱cha̱há ko̱ yá kich'ahanu nga kjúái̱chj'anijéhenú? ");
INSERT INTO majNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Xki̱ ni̱stjin tsási̱njñajinnu̱u nga tsakuyá má ma na̱tsihi̱n ni̱nku̱. Najmi kichjubénijénú. Tu̱nga tjíhín ni nga ku̱i̱tjusun éhe̱n Nti̱a̱ná, kui nga b'a̱ tímaha. ");
INSERT INTO majNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","A̱s'a̱i i̱ncha tsanka ngatentee̱ já ni'yakuyóo̱ nga tsasínjña suba Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tu̱nga nkuhú nda̱ti xi tu̱ najyun tjabehé kam'otikjájnuhu yjoho̱ nga tje̱nnkihi̱ Jesu, kui xi ta̱ jakj'áha̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tu̱nga tsinkféhén najyun tjabehe̱ ko̱ tsanka kisti. ");
INSERT INTO majNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","A̱s'a̱i i̱ncha ngjiko̱ jóo̱ Jesu nginku̱n nda̱ na̱'mi títjuu̱n. Yo̱ kama ñjakú ngayjee̱ já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Máha Pedro̱, kitsjennkí kjihi̱n Jesu santa nkúhu nga tsichu na̱tsin ni'yaha̱ nda̱ na̱'mi títjuu̱n ko̱ y'ejñajihi̱n já jun xi kunntá yo̱ nga kits'ínsut'á ts'íhin yjoho̱ t'a nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A̱s'a̱i já na̱'mi k'aku̱ ko̱ ngayjee̱ já tjíxóo̱ tsangisjai ni xi ka̱ma kja̱nít'aha̱ Jesu tu̱ xi ka̱ma n'e̱k'iehen, tu̱nga najmi i̱ncha kisakúhú ra̱ ni xi kja̱nínehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A̱t'aha̱ ndaha tsa nkjin maha xi i̱ncha kitsjá tsank'á éhe̱n nga ngji kontra̱ha̱ Jesu, tu̱nga najmi kamahá nga nkuhú ni xi i̱ncha kinchja̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tjín xi i̱ncha tsisintje̱n ko̱ tsatéjéne tsank'á Jesu nga b'a̱ i̱ncha kitsú: ");
INSERT INTO majNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ji̱n kinu'yái̱ nga b'a̱ kitsú nda̱i̱: “An ts'inxúya ni̱nku̱ xu'bi̱ xi xu̱ta̱ kits'ínnda. Jan ni̱stjin kjesíntje̱n ngáhana kj'a̱í xi najmi maha̱ xu̱ta̱ ts'ínnda.” ");
INSERT INTO majNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tu̱nga tu̱ nkú najmi kamahá nga nkuhú ni xi i̱ncha kinchja̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","A̱s'a̱i tsisintje̱n nda̱ na̱'mi títjuu̱n nga ngji sinjña kamasehe̱n a̱yoo̱ ko̱ kingjásjaiyaha̱ Jesu: —¿A najmi chumi nihi xi ku̱i̱xínní? ¿Á b'a̱ tíi̱ncha tsuhu jóo̱ nga tífi kontra̱ha ri? ");
INSERT INTO majNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tu̱nga najmi chumi ni kitsúhú Jesu. Ndaha nku én najmi kinchja̱. A̱s'a̱i ta̱ kingjásjaiyahá ngáha̱ ra̱ nda̱ na̱'mi títjuu̱n: —¿A ji xi kits'ín nibá Nti̱a̱ná, xi Ntíhi̱ Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","B'i̱ kitsú Jesu: —An xi tíbixín. Cho̱o Ntíhi̱ Nda̱x'i̱u̱n nga k'úéjñat'aha̱ Nti̱a̱ná xi tjíhi̱n nga'yún ko̱ nga ni̱bajin ni̱nti̱ xi tjín nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A̱s'a̱i kikjeti̱yajen najyun xi yja nda̱ na̱'mi títjuu̱n. B'a̱ ts'ín tsakúchji ndo̱ nga najmi kisasíhi̱n én xi kinchja̱ Jesu. B'a̱ kitsú: —¿A machjén saná já testiyu̱? ");
INSERT INTO majNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ja kuanu'yó nga najmi kuakienkjún Nti̱a̱ná nga kuanchja̱. ¿Nkú manu̱u? Ngayjee̱ jóo̱ b'a̱ i̱ncha kitsú nga tje̱he̱n ra̱ ngabaya Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A̱s'a̱i tjín xi tsatétéjnu Jesu nga kik'aya. Y'é'ma a̱nkjín ko̱ y'éhe̱ ko̱ b'a̱ i̱ncha kitsúhu̱: —Ti̱xínyai xi nkúhu nda̱ profeta̱, ¿yá xi kuak'íéhi? Já jun xi kunntá yo̱ ta̱ i̱ncha kik'onjin Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nga kab'ejña Pedro̱ kintee̱ xi tje̱hen na̱tsin ni'yoo̱, tu̱ j'aihí nku na̱ musu̱hu̱ nda̱ na̱'mi títjuu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nk'ie nga kikie nga títs'ínsut'á yjoho̱ Pedro̱ t'a nd'íu̱, a̱s'a̱i tu̱ nku tsasehé ra̱ ko̱ b'a̱ kitsúhu̱: —Ji xi ta̱ tje̱nko̱i̱ Jesu xi chá Nazaret. ");
INSERT INTO majNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tu̱nga najmi kits'ínkiehé yjoho̱ Pedro̱. B'a̱ kitsú: —Najmi be ndo̱. Najmi be ni xi tíbixín. Tsitju yo̱ nga ngji má xi tje̱hen tje̱n a̱nkju̱a̱ na̱tsiu̱n. A̱s'a̱i kikjintá nku xa̱nta̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na̱ musu̱ ta̱ kikiehé ngáha̱ ra̱ ko̱ kik'atuts'i̱hi̱n nga b'a̱ kitsúhu̱ xu̱ta̱ xi tíi̱ncha yo̱: —Kui chái̱ ta̱ mako̱ jmi xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ta̱ najmi kits'ínkiehé ngáha yjoho̱ Pedro̱. Sa kutju já xi tíi̱ncha yo̱ b'a̱há ta̱ i̱ncha kitsú ngáha̱ ra̱: —Kju̱axi̱ kjáíhin nga ta̱ ji mako̱i̱ jóo̱. A̱t'aha̱ Galilea̱ nibáhani. ");
INSERT INTO majNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A̱s'a̱i ndjá kinchja̱ Pedro̱ ko̱ i̱xí Nti̱a̱náhá kits'ínkie nga b'i̱ kitsú: —¡Najmi be nda̱ xi tíbixíún! ");
INSERT INTO majNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kui chu̱bo̱ tje̱n'yún kikjintáhá xa̱nto̱ ni̱yá xi ma joho ko̱ j'áítsjehe̱n Pedro̱ ni xi kitsúhu̱ Jesu: “Kintehe̱ ni nga kji̱ntá xa̱nto̱ ni̱yá xi ma joho, b'a̱ ku̱i̱xín nga najmi yaní jan ni̱yá tjíhin.” Nk'ie nga j'áítsjehe̱n Pedro̱ én xu'bi̱, kikjintá. ");
INSERT INTO majNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nk'ie nga ja kama see̱n, i̱ncha y'éndako̱ xinkjín já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ ngayjee̱ já tjíxá xingisoo̱. A̱s'a̱i tjí'yúhún ts'íhi̱n ra̱ Jesu nga i̱ncha ngji ts'ínkjas'ehe̱n Pilato̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","B'a̱ kitsú Pilato̱ nga kingjásjaiyaha̱: —¿A ji xi nda̱ rei̱hi̱ xu̱ta̱ judio̱? B'i̱ kitsú Jesu: —B'a̱ tjín ni xi tíbixín. ");
INSERT INTO majNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nkjin ṉkjún ni xi kikjanínehe̱ já na̱'mi k'aku̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kui nga Pilato̱ ta̱ kingjásjaiyahá ngáha̱ ra̱ Jesu: —¿A najmi chumi nihi xi k'úínní? Ta̱sinñjú ma ri̱ xi nkú ts'ín nkjin maha ni xi tíkjanínehi jóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tu̱nga ndahá nku én najmi kinchja̱ Jesu. Kui nga tu̱ ni xí kama nkjúhu̱n ra̱ Pilato̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nk'ie nga xki̱ S'í Pascu̱a̱, b'éjña nda̱í Pilato̱ nku nda̱ nu̱ba̱yá xi banki xu̱ta̱ na̱nti̱a̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kui ni̱stjiu̱n kjiya'yún nku nda̱ xi 'mi Barraba ko̱ já xi kamako̱ho̱ nga kikjánko̱ já Roma̱. Kui xi i̱ncha kits'ínk'ien ani̱ma̱ nga b'a̱ i̱ncha kits'ín. ");
INSERT INTO majNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A̱s'a̱i i̱ncha j'ai xu̱ta̱ nkjiu̱n ko̱ kik'atuts'i̱n nga tsankihi̱ Pilato̱ nga ts'i̱ín xi nkú ts'ín xki̱ s'í. ");
INSERT INTO majNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","B'a̱ kitsú Pilato̱ nga kingjásjaiyaha̱ xu̱ta̱ nkjiu̱n: —¿A mjenu̱u nga k'uejñá nda̱ínu̱u nda̱ rei̱hi̱ xu̱ta̱ judio̱? ");
INSERT INTO majNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","B'a̱ kitsú a̱t'aha̱ kamankjihi̱n nga tíma xin k'un já na̱'mi k'aku̱ nga̱t'aha̱ ni xi títs'ín Jesu ko̱ nga kui kju̱a̱ha nga i̱ncha kits'ínkjas'ehe̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tu̱nga já na̱'mi k'aku̱hú tsinchá'a xu̱ta̱ nkjiu̱n tu̱ xi ku̱a̱nkihi nga tu̱ sahá Barraba xi n'e̱ nda̱íhi̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A̱s'a̱i b'a̱ kitsú Pilato̱: —Nda̱ xi nda̱ rei̱hi̱ xu̱ta̱ judio̱ bixíún, ¿mí xi ts'ihi̱n? ");
INSERT INTO majNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","B'a̱ i̱ncha kitsú xu̱ta̱ nkjiu̱n nga kikjintáya: —¡Tjat'a krui̱ ndo̱! ");
INSERT INTO majNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","B'a̱há ta̱ kitsú ngáha Pilato̱: —Tu̱nga, ¿mí ni ch'on tjíhin xi kits'ín ndo̱? Tu̱nga tu̱ sahá 'yún i̱ncha kikjintáya sa xu̱to̱: —¡Tjat'a krui̱ ndo̱! ");
INSERT INTO majNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato̱ bi mjehe̱ nga tsjo k'úéhe̱ xu̱ta̱ nkjiu̱n, kui nga kits'ín nda̱íhi̱ ra̱ Barraba ko̱ kitsjá kju̱a̱ nga s'e̱he̱ Jesu ko̱ nga s'e̱t'a kruu̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A̱s'a̱i já juu̱n jas'enko̱ Jesu ni'ya masen xi 'mi ni'ya pretori̱o̱. Kinchja̱ ñjaha̱ ngayjee̱ já jun xinkjín. ");
INSERT INTO majNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","I̱ncha kits'ínngja Jesu nku najyun ndju kuan nga i̱ncha kik'aya. Ko̱ i̱ncha kits'ínnda nku corona̱ na'yá xi y'é'a nintaku̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","A̱s'a̱i i̱ncha kik'atuts'i̱n nga kik'aya: —Antahi, nda̱ rei̱hi̱ xu̱ta̱ judio̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","I̱ncha jakj'á nku yáxá nga kik'onntjai nintaku̱ Jesu ko̱ tsatétéjnu. Tsinchakúnch'int'aha̱ nga kik'aya. ");
INSERT INTO majNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","A̱skahan nga ja kamaha̱ nga kik'aya Jesu, ts'asje ngáha najyun ndju kuo̱n ko̱ kits'ínngja ngáha najyun xi ts'e̱ Jesu. A̱s'a̱i i̱ncha tsitjuko̱ tu̱ xi ngju̱át'a kruu̱hu. ");
INSERT INTO majNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nku nda̱ nanki Cirene̱ xi Simon 'mi, Alejandro̱ ko̱ Rufo̱ ntíhi̱. Jñá j'aihi ndo̱ ko̱ nk'ie nga tíf'a yo̱, kin'e kju̱a̱'yúhún ra̱ nga k'u̱a̱nji kruu̱hu̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","A̱s'a̱i i̱ncha ngjiko̱ Jesu a̱nte xi 'mi Golgo̱ta̱. Kui ée̱n xi tsuhu̱ ra̱: A̱ntehe̱ Nintaku̱ Ani̱ma̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kik'a̱i̱hi̱ nga k'úí binu̱ xi kin'etjijinko̱ho nki, tu̱nga najmi kik'ihí Jesu niu̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A̱s'a̱i i̱ncha kingját'a kruu̱. Já juu̱n i̱ncha tsakjánya xi̱hi̱ xinkjín najyuhu̱n Jesu nga kitsutonyá ts'íhin, tu̱ xi b'a̱ ts'ín sku̱e̱he má t'íáha xi sa̱kúhu̱ ra̱ nga nkúnkú. ");
INSERT INTO majNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Chu̱ba̱ ñja nga ta̱ jyuu̱n kis'et'a kruu̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nku yáte kis'et'a mí kju̱a̱ha nga tín'ek'iehen. B'i̱ ts'ín kis'et'aha̱ yátee̱: “Nda̱ rei̱hi̱ xu̱ta̱ judio̱.” ");
INSERT INTO majNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ta̱ kis'et'a kruu̱ko̱ Jesu jo já ndyjé. Nku xi kitsjen nga kixi̱hi̱ ko̱ nku nga skjúhu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yo̱ tsitjusun ni xi y'ét'a Isaia̱ nk'ie nga b'a̱ kitsú: “Nkujihín kamako̱ já xi bangane kju̱a̱téxumaha̱ Nti̱a̱ná.” ");
INSERT INTO majNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Xu̱ta̱ xi tíi̱ncha f'a yo̱ najmi kikienkjún Jesu nga kinchja̱. Kits'ínk'ajni nintaku̱ nga b'a̱ i̱ncha kitsúhu̱: —Ji xi n'e̱xúyai ni̱nku̱ ko̱ jan ni̱stjin chjúsíntje̱n ngáhani, tsixín. ");
INSERT INTO majNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡N'e̱k'anki yjohi̱! ¡Ti̱tjuje̱nt'ai kruu̱! ");
INSERT INTO majNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","B'a̱ ta̱ ts'ín kik'ayaha̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. B'a̱ i̱ncha kitsúhu̱ xinkjín: —Kamaha̱ nda̱i̱ nga kj'a̱í xi kits'ínk'anki, tu̱nga tu̱ sa najmi mahá ngáha̱ ts'ínk'anki yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Katitjujent'a kruu̱ nd'a̱i̱, tsa kui xi kits'ín nibáha̱ Nti̱a̱ná, tsa kui xi nda̱ rei̱hi̱ xu̱ta̱ Israel. B'a̱ ts'ín cha̱haná ko̱ s'e̱jinná ma. Ko̱ já xi kjintut'á kruu̱ko̱ Jesu ta̱ ch'on i̱ncha kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nk'ie nga tsichu chu̱ba̱ te jo nga ni̱stjiu̱n, kis'e jyun ngayjee̱ a̱sunntee̱ santa nkúhu nga tsichu chu̱ba̱ jan nga ngixuu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chu̱ba̱ jan 'yún kikjintáya Jesu nga éhe̱n kinchja̱. B'i̱ kitsú: —Eloi, Eloi, ¿lema sabactani̱? —kui éi̱n xi tsuhu̱ ra̱: Ji Nti̱a̱na̱, ji Nti̱a̱na̱, ¿á kan'e nga mahaní? ");
INSERT INTO majNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","K'u̱a̱ xu̱ta̱ xi kabincha yo̱ i̱ncha kint'é kui ée̱n. Kui nga b'a̱ i̱ncha kitsúhu̱ ra̱ xinkjín: —Ta̱sinñju. Nda̱ profeta̱ Elia̱ tínchja̱ha̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A̱s'a̱i tsangatsanka nku nda̱ xi síjña yo̱ ko̱ nku tsa̱nka̱ kits'ínk'anchi̱ko̱ sesehe binu̱ san. Kui xi y'éku nku yáxá nga kits'ínkjik'uhu̱n Jesu tu̱ xi k'úíhi ko̱ b'i̱ kitsú: —Chúya maá. Cha̱se̱ ma ra̱á tsa nibá Elia̱ nga kjéje̱he̱n t'a kruu̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A̱s'a̱i 'yún kikjintáya Jesu ko̱ k'ien. ");
INSERT INTO majNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nk'ie nga b'a̱ kamoo̱, kitiyájen najyun xi tje̱nchja a̱nte xi 'yún nkjúhu̱n ni̱nku̱. Jo tsitju. Kik'aha̱ ra̱ nk'aha̱ santaha kintee̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Máha nda̱ jun k'aku̱hu̱ já juu̱n xi kabasinjña a̱nkjín Jesu, nk'ie nga kint'é xi nkú ts'ín kikjintáya ko̱ nga kikie xi nkú ts'ín k'ien Jesu, a̱s'a̱i b'a̱ kitsú: —Kju̱axi̱ kjáíhin nga kui nda̱i̱ xi Ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yo̱ kjint'á kabincha k'u̱a̱ jminchjín xi tíi̱ncha base. A̱jihi̱n jminchjíu̱n ta̱ kabasinjñajin Maria̱ Magdalena̱, Maria̱ xi na̱aha̱ maha Kuse ko̱ Santiago̱ xi ntí ku̱ts'i̱, ko̱ na̱ Salome. ");
INSERT INTO majNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kui jminchjín xu'bi̱ xi kitsjennkíhi̱ ko̱ tsasinko̱ho̱ Jesu nk'ie nga y'ejña a̱nte Galilea̱. Ta̱ tíi̱ncha ya yo̱ kj'a̱í jminchjín xi ta̱ i̱ncha j'aiko̱ho̱ Jesu nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kui ni̱stjiu̱n tís'enda ni xi ts'e̱ s'íu̱, a̱t'aha̱ ja tíbichú tiña ni̱stjin nkjúu̱n. Nk'ie nga ja tíma jyun, ");
INSERT INTO majNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","j'ai nku nda̱ xi 'mi Kuse xi nanki Arimatea̱ nibáha, xi ta̱ nda̱ tjíxá k'aku̱. Ta̱ tíkuyáha̱ ni̱stjin nk'ie nga ku̱a̱téxuma Nti̱a̱ná. Kui xi kama k'un ngjisehe̱ Pilato̱ ko̱ tsankihi̱ yjonintehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kama nkjúhu̱n Pilato̱ nga kutjuhú k'ien Jesu. A̱s'a̱i kinchja̱ha̱ nda̱ jun k'aku̱hu̱ já juu̱n ko̱ kingjásjaiyaha̱ tsa ja ka'me Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nk'ie nga kitsúyaha̱ nda̱ jun k'aku̱ niu̱, a̱s'a̱i kitsjáha̱ Kuse yjonintehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A̱s'a̱i ts'atse Kuse nku najyun. Kui xi kik'ontikjájnu yjonintehe̱ Jesu, nk'ie nga kikjeje̱n t'a kruu̱. A̱s'a̱i ngjingjájñaya nku ti̱xa̱ tsjó xi kin'endat'á na̱xi̱u̱ ko̱ kik'ontikjá nku ndji̱o̱ chánka nga y'échjane a̱nkju̱a̱ tsjóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria̱ Magdalena̱ ko̱ Maria̱ xi na̱aha̱ Kuse i̱ncha kikie má xi tje̱hen kis'ejña yjonintehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nk'ie nga j'a xua̱tu̱, a̱s'a̱i Maria̱ Magdalena̱, Maria̱ xi na̱aha̱ Santiago̱ maha ko̱ na̱ Salome ts'atse ni xi sinjne̱, tu̱ xi ngju̱a̱i̱ngjájnuhu̱ ra̱ yjonintehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nk'ie nga ta̱ jyun ta̱ jyuhu̱n ni̱stjin xi b'atuts'i̱hi̱n ra̱ tuntjóo̱, i̱ncha ngji tsjóo̱ nga ja títju ts'íu̱. B'i̱ ngján kingjásjaiyaha̱ xinkjín: ");
INSERT INTO majNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","—¿Yá xi kjéxinná ndji̱o̱ xi tjíchjane tsjóo̱? ");
INSERT INTO majNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tu̱nga nk'iehé nga i̱ncha tsase, kikie nga ja kan'e t'axín ndji̱o̱ chánkantsú xi kis'echjáne a̱nkju̱a̱ha̱ tsjóo̱. ");
INSERT INTO majNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","I̱ncha jas'en ti̱xa̱ tsjóo̱ ko̱ kikie yo̱ nku nda̱ti xi yja nku najyun ndju taba nga kab'ejña a̱ndai kixi̱hi̱ tsjóo̱. Kitsankjún jminchjíu̱n. ");
INSERT INTO majNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tu̱nga b'a̱há kitsú nda̱tiu̱: —Najmi tu̱ binkjun. Jesu xi nibáha Nazaret xi kis'et'a kruu̱ tíbinchisjó. Ja kaf'áíya ngáha̱ ra̱ ngabayoo̱. Najmi ta̱ tjíhin e̱i̱. Cha̱so̱o e̱i̱ má nga kis'ejña. ");
INSERT INTO majNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tu̱nga b'i̱hí tankínk'ihu̱un já ni'yakuyáha̱ ko̱ Pedro̱ nga a̱nte Galilea̱ ngju̱a̱i̱ títjuhu̱n Jesu. Yo̱ sku̱e̱ xi nkú nga kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","A̱s'a̱i i̱xí tíi̱ncha b'atsé nkjúhún ts'íhin jminchjíu̱n nga tsitju a̱ya tsjóo̱ ko̱ 'yún i̱ncha ngji. Ndaha nku én najmi i̱ncha kinchja̱ a̱t'aha̱ tíi̱ncha tsankjún. ");
INSERT INTO majNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nk'ie nga j'áíyaha̱ Jesu ngabayoo̱ nga ta̱ jyuhu̱n ni̱stjin xi tíb'atuts'i̱hi̱n ra̱ tuntjóo̱, títjun tsakúchjihi̱ yjoho̱ Maria̱ Magdalena̱ xi kik'asjejihi̱n yatu jáninda. ");
INSERT INTO majNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kui xi ngji tsúyaha̱ já xi kitsjenko̱ Jesu xi ta̱ tjíntu baba ko̱ tíi̱ncha kjintá. ");
INSERT INTO majNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tu̱nga nk'iehé nga kint'é jóo̱ nga tíjña tík'un Jesu ko̱ nga Maria̱ Magdalena̱ kabakúchjihi̱ yjoho̱, najmi kis'ejihi̱n ni xi kitsú Maria̱. ");
INSERT INTO majNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A̱skahan kj'a̱í ts'ín tsakúchjihi̱ yjoho̱ jo já ni'yakuyáha̱ Jesu xi tíi̱ncha ts'ín ni̱yá nga tíi̱ncha fi jñá. ");
INSERT INTO majNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A̱s'a̱i i̱ncha kik'óya ngáha já xi joo̱ nga ngji tsúyaha̱ já xingisoo̱, tu̱nga tu̱ nkú najmi kis'ejihín ra̱ ni xi kitsú já xi joo̱. ");
INSERT INTO majNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A̱s'a̱i tu̱ chahán tsakúchjihi̱ yjoho̱ Jesu já ni'yakuyá xi te nkuu̱ nk'ie nga kab'entut'á yámixo̱. Ndjá kinchja̱ko̱ a̱t'aha̱ najmi s'ejihi̱n ko̱ ndjá tjíntuyá ani̱ma̱ha̱, a̱t'aha̱ najmi kis'ejihi̱n ni xi kitsúyaha̱ xi kikie Jesu nk'ie nga ja j'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","B'i̱ kitsúhu̱ jóo̱: —Tankíún nga ngúsuhu̱n a̱sunntee̱ ko̱ t'eni̱jmíhu̱u én nda tsuhu̱ Nti̱a̱ná ngayjee̱ xu̱ta̱ xi tjín. ");
INSERT INTO majNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xi s'e̱jihi̱n én nda tsuhu̱ Nti̱a̱ná ko̱ sa̱téntá, kui xi k'u̱a̱nki. Tu̱nga xi najmi s'e̱jihi̱n, kui xi ndyja̱. ");
INSERT INTO majNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Xu̱ta̱ xi s'e̱jihi̱n én nda tsuhu̱ Nti̱a̱ná ts'i̱ín kui kju̱a̱nkjúi̱n: ngajona̱ k'o̱nsjehe jánindoo̱, ku̱i̱nchja̱ kj'a̱í kj'a̱í én xi tjín, ");
INSERT INTO majNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ku̱a̱kj'áya ntsja ye̱, tsa tjín nki ch'onk'un xi k'úí, najmi chumi nihi xi ts'i̱íhi̱n, ko̱ ngju̱énne ntsja xu̱ta̱ un ko̱ ka̱manda. ");
INSERT INTO majNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nda̱ Nti̱a̱ná Jesu, nk'ie nga ja kinchja̱ko̱ já ni'yakuyáha̱, a̱s'a̱i ngjinji nk'a ján ko̱ y'ejñat'aha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A̱s'a̱i i̱ncha tsitju já ni'yakuyóo̱ nga y'éni̱jmí éhe̱n Nti̱a̱ná ngayjee̱ a̱nte xi tjín. Nda̱ Nti̱a̱ná tsasinko̱ho̱ ko̱ kits'ín kju̱a̱nkjún nga tsakúchji nga kju̱axi̱ én xi tíi̱ncha b'éni̱jmí já ni'yakuyáha̱.");
INSERT INTO majNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nkjin ṉkjún maha xu̱ta̱ xi kama mjehe̱ nga k'u̱ét'a ch'ich'in xu̱ju̱n ni xi kama a̱jinni̱, ");
INSERT INTO majNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","xi nkú ts'ín tsakúyani̱ já xi tunku̱n kikiehe niu̱ santaha nga tuts'ihi̱n ni ko̱ xi kik'a̱i̱ xáha̱ nga y'éni̱jmí ée̱n. ");
INSERT INTO majNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kui nga ko̱ ta̱ an, nda̱ xinkjíán Teofi̱lo̱, kingjasjáíya sisihinna xi nkú ts'ín niba tuts'i̱hi̱n ra̱ ngayjee̱ niu̱, ko̱ b'a̱ mana nga nda tjín nga k'uet'á ch'ich'ihin ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","B'a̱ títs'ian tu̱ xi b'a̱ ts'ín cha̱ kixi̱ sisihinni ni xi tsinchiyáí. ");
INSERT INTO majNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ni̱stjin nga tsatéxuma nda̱ rei̱ Herode̱ a̱nte Judea̱, ta̱ y'ejña nku nda̱ na̱'mi xi kik'in Zacaria̱ xi y'aha̱ ra̱ ntje̱he̱ nda̱ na̱'mi Abia̱. Ko̱ Isabel xi chju̱úhu̱n maha, kui xi y'aha̱ ra̱ ntje̱he̱ Aaron. ");
INSERT INTO majNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nga joo̱ na̱xu̱ tsincha nginku̱n Nti̱a̱ná. Najmi tjín xi ka̱ma ts'i̱ínnijéhe̱ ra̱ tsa mí nihi, a̱t'aha̱ i̱ncha ts'íntjusun ngayjee̱ éhe̱n Nti̱a̱ná ko̱ kju̱a̱téxumaha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tu̱nga najmi tjíhín ra̱ ntí, a̱t'aha̱ nti̱ Isabel ko̱ ja chá ṉkjún nga joo̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nk'ie nga tjíhi̱n nda̱ na̱'mi Zacaria̱ nginku̱n Nti̱a̱ná xi nkú ts'ín tje̱he̱n ra̱ ntje̱he̱ ");
INSERT INTO majNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","xi nkú ts'ín tíjñaha̱ já na̱'miu̱, kui kikanéhe̱ nga kju̱a̱s'en a̱nte nkjúhu̱n ni̱nku̱ xi má nga k'u̱éti ni xi sinjne̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ngayjee̱ xu̱ta̱ na̱nti̱o̱ kabincha na̱tsin ni̱nku̱ nga tíi̱ncha nchja̱ko̱ Nti̱a̱ná nk'ie nga títi ni xi sinjne̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tu̱ kama chjihí ra̱ Zacaria̱ nku ntítsjehe̱ Nti̱a̱ná xi kabasinjñat'a nga kixi̱hi̱ na̱chan xi má nga s'etísun ni xi sinjne̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","I̱xí b'a̱há kamaha̱ Zacaria̱ nk'ie nga kikie ntítsjee̱ ko̱ tu̱ ni xí kitsankjúhún. ");
INSERT INTO majNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tu̱nga b'a̱há kitsú ntítsjee̱: —Ji Zacaria̱, najmi tu̱ binkjuin. A̱t'aha̱ Nti̱a̱ná ja tsasínñjuhu̱ ni xi tsinchihi̱. Isabel xi chji̱íhi̱n maha tsjáhi nku ntíx'i̱n, ko̱ Jua t'et'aihi̱ ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'Yún s'e̱hi kju̱a̱tsjo ko̱ nkjin xu̱ta̱ xi ta̱ s'e̱he̱ kju̱a̱tsjo nk'ie nga tsín ntíhi̱, ");
INSERT INTO majNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","a̱t'aha̱ kui xi chánka ka̱ma nginku̱n Nti̱a̱ná. Najmi k'úí binu̱ ko̱ ta̱ ndaha xán. Tséjihi̱n ra̱ Espiri̱tu̱ Santo̱ kintehe̱ ni nga tsín. ");
INSERT INTO majNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","’Ts'i̱ín nga nkjin ṉkjún xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱ ts'i̱ínk'ótjiyak'un ngáha Nti̱a̱ná xi Nti̱a̱ha̱ maha. ");
INSERT INTO majNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kui xi tjun kj'u̱a̱í ko̱ s'e̱jñajihi̱n Espiri̱tu̱hu̱ ko̱ nga'yúhu̱n Nti̱a̱ná xi nkúhu nda̱ profeta̱ Elia̱ nk'ie. Kui xi ts'i̱ínk'óntjaiya ani̱ma̱ha̱ xi tí'mi na̱'mi tu̱ xi ts'i̱íntjoho ntíhi̱. Ko̱ ts'i̱ínk'óntjaiya ani̱ma̱ha̱ xu̱ta̱ xi ndjá tjíntuyáha̱ tu̱ xi na̱xu̱ ka̱mankjihi̱n ra̱ xi nkú ts'ín na̱xu̱ mankjihi̱n xu̱ta̱ xi na̱xu̱ tjíma nginku̱n Nti̱a̱ná. B'a̱ ts'ín k'u̱éndaha nku na̱xi̱nantá xi tjíndaha̱ yjoho̱ nk'ie nga ts'i̱ínkjáíhi̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A̱s'a̱i b'a̱ kitsú Zacaria̱ nga kingjásjaiyaha̱ ntítsjee̱: —¿Nkú ts'ín skuehena nga kju̱axi̱ ni xi tí'miní? A̱t'aha̱ ja chá ṉkján ko̱ ta̱chju̱únna̱ ja ta̱ tjín ṉkjúhu̱n nú. ");
INSERT INTO majNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","B'a̱ kitsú ntítsjee̱: —An xi 'mina Gabriel. An xi tíi̱jña nginku̱n Nti̱a̱ná. Kan'e nibána xi má nga kuinchjako̱ho ko̱ nga xínyaha én nda tsu xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nd'a̱i̱ ka̱ma ni̱ma̱i ko̱ najmi ta̱ ka̱ma chu̱bahani santa nkúhu nga ku̱i̱tjusun én xi kuaxihin, a̱t'aha̱ najmi kuas'ejihin énna̱. Kui xi ku̱i̱tjusun ni̱stjin xi tjíhin nga ku̱i̱tjusun. ");
INSERT INTO majNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Máha xu̱ta̱ na̱nti̱o̱, kabincha na̱tsiu̱n nga tíkuyáha̱ Zacaria̱. Kis'enta̱ha̱ ra̱ a̱t'aha̱ tíb'andayaha̱ Zacaria̱ a̱ya nkjúhu̱n ni̱nku̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tu̱nga nk'iehé nga tsitju yo̱, najmi ta̱ kama kinchja̱ko̱ho xu̱to̱. A̱s'a̱i i̱ncha kamankjihi̱n xu̱to̱ nga tjín ni xi kikie Zacaria̱ a̱ya nkjúhu̱n ni̱nku̱, a̱t'aha̱ tu̱ ntsjahá títs'ínchjén nga tínchja̱. J'a ni̱stjiu̱n ko̱ tu̱ nku b'a̱há ts'ín y'ejña ni̱ma̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nk'ie nga ja kama ndju̱ú xáha̱, a̱s'a̱i ngji ngáha ni'yaha. ");
INSERT INTO majNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A̱skahan kik'a ntí Isabel, chju̱úhu̱n Zacaria̱. Un sá kamaha̱ nga najmi tsitju ni'yaha̱ ta̱chjúu̱n. B'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“B'a̱ kits'ínko̱na Nti̱a̱ná tu̱ xi najmi ta̱ ch'on ts'ín ku̱a̱se̱hena xu̱ta̱.” ");
INSERT INTO majNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nk'ie nga j'a jun sá, a̱s'a̱i kits'ínkji Nti̱a̱ná ntítsje Gabriel nanki Nazaret, nanki xi tíjñajihi̱n a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nku én ngjiko̱ho̱ ntítsjee̱ nku ta̱kjín xu̱nkú xi 'mi Maria̱, xi ja tjíndako̱ho̱ nga ku̱i̱xanko̱ nda̱ xi 'mi Kuse, xi ntje̱he̱ nda̱ rei̱ David y'aha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jas'en ntítsjee̱ má tíjña ta̱kjíu̱n ko̱ b'i̱ kitsúhu̱: —Antahi. Tse ṉkjún kju̱a̱nda xi tí'ba̱i̱hi. Nda ṉkjún ts'ín basehi Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nk'ie nga kikie Maria̱ ntítsjee̱ ko̱ nga kint'é niu̱, i̱xí b'a̱há kamaha̱ ko̱ kingjásjaiyaha̱ yjoho̱ nkú tsuhu̱ ra̱ kju̱a̱suniñoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A̱s'a̱i b'a̱há ta̱ kitsú ngáha ntítsjee̱: —Ji Maria̱, najmi tu̱ binkjuin. Kju̱a̱ndaha̱ Nti̱a̱ná títsjáhi. ");
INSERT INTO majNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nd'a̱i̱ nku ntí ch'a̱i̱, nku ntíx'i̱n s'e̱jñahi. Jesu k'úét'aihi̱ ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kui xi nku nda̱ chánka ka̱ma ko̱ Ntíhi̱ Nti̱a̱ná xi tíjña nk'a ján k'úíhi̱n. Nti̱a̱ná ts'i̱ín nga kui xi ka̱ma nda̱ rei̱ xi nkúhu nda̱ rei̱ David, a̱t'aha̱ kui xi ntje̱he̱ David. ");
INSERT INTO majNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ku̱a̱téxumaha̱ na̱xi̱nantá xi y'aha̱ ra̱ ntje̱he̱ Jacob santaha tu̱ nkjéhé ni ko̱ najmi tjín xi ka̱ma kjé'aha̱ xáha̱ nga ku̱a̱téxuma. ");
INSERT INTO majNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","B'a̱ kitsú Maria̱ nga kingjásjaiyaha̱ ntítsjee̱: —¿Nkú ts'ín ku̱i̱tjusuhun ni xu'bi̱? A̱t'aha̱ najmi kje̱ tjínna x'i̱n. ");
INSERT INTO majNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","B'a̱ kitsú ntítsjee̱: —Espiri̱tu̱ Santo̱ ni̱bajenk'úhin ko̱ nga'yúhu̱n Nti̱a̱ná xi tíjña nk'a ján k'u̱é'mako̱ho ri nk'íéhe̱n. Kui kju̱a̱ha nga Ntíhi̱ Nti̱a̱ná k'úíhin ntí je xi tsíu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Isabel xi na̱ xinki̱ maha ja ta̱ y'a nku ntí, ndaha tsa ja chá. Na̱ xi nti̱ kitsú xu̱ta̱ jun sá ja tjíhi̱n nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nti̱a̱ná bi najmi tjíhi̱n ni xi najmi maha̱ ts'ín. ");
INSERT INTO majNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A̱s'a̱i b'a̱ kitsú Maria̱: —An xi na̱ musu̱hu̱ Nti̱a̱ná. B'a̱ katumana xi nkú nga kuakixínní. Nk'ie nga b'a̱ kitsú Maria̱, a̱s'a̱i ngji ngáha ntítsjee̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kui ni̱stjiu̱n y'énda yjoho̱ Maria̱ ko̱ ngji ki̱tsa̱ ki̱tsa̱ nku nanki i̱chí xi tíjñajihi̱n a̱sunntu tje̱nki̱ xi tjín a̱nte Judea̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A̱s'a̱i jas'en ni'yaha̱ Zacaria̱ ko̱ kikjaniñaha̱ Isabel. ");
INSERT INTO majNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nk'ie nga kint'é Isabel kju̱a̱suniñaha̱ Maria̱, kits'ín ni̱yá ntí xi y'a ko̱ j'aitsejíhi̱n ra̱ Isabel Espiri̱tu̱ Santo̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A̱s'a̱i 'yún kinchja̱ Isabel nga b'a̱ kitsú: —A̱jihi̱n ngayjehe̱ jmichjíu̱n 'yún nda kits'ínko̱ sahi Nti̱a̱ná ji ko̱ 'yún nda kits'ínko̱ ntí xi kich'ai. ");
INSERT INTO majNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tu̱nga, ¿yáhá ni an nga na̱aha̱ Chá Nti̱a̱na̱ kj'uaisehena? ");
INSERT INTO majNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","A̱t'aha̱ nk'ie nga kuant'e kju̱a̱suniñahi̱, i̱xí kuats'ín ni̱yá tsjoho̱ ntína̱ a̱ya ka̱nts'á. ");
INSERT INTO majNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Á b'a̱ ndaha ri ji xi kis'ejihin ri nga tjíhin nga ku̱i̱tjusun én xi kitsúhi Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A̱s'a̱i b'i̱ kitsú Maria̱: A b'a̱ 'yún chánkaha Nti̱a̱ná títsu ani̱ma̱na̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Títs'intsjoho̱ Nti̱a̱ná xi kunna. ");
INSERT INTO majNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A̱t'aha̱ xi batéxumana kik'axki̱hina an xi kinte tje̱n. Nd'a̱i̱ ko̱ santaha tu̱ nkjéhé ni: “Á b'a̱ nda kits'ínko̱ho ri Nti̱a̱ná”, ku̱i̱tsu̱na xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","A̱t'aha̱ ni xi i ja kits'ínko̱na xi tjíhi̱n nga'yún. Nkjún j'áín xi ts'e̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kui xi base ni̱ma̱ha̱ xu̱ta̱ xi benkjúhu̱n, xu̱ta̱ xi kis'e ko̱ xi tjín ko̱ xi s'e̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tsakúchji nga'yúhu̱n nga kits'ín ni xi i. Kits'ínndzjoya xu̱ta̱ xi ngak'un b'asje yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kikjexíhi̱n xáha̱ jmirei̱, ko̱ ts'asjenk'a xu̱ta̱ x'a̱n. ");
INSERT INTO majNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kitsjáha̱ ni xi nda xu̱ta̱ xi najmi tjíhi̱n nichine, ko̱ kits'ínkji tiya xu̱ta̱ nchi̱nóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tsasinko̱ xu̱ta̱ Israel xi xu̱ta̱ musu̱hu̱ maha, j'áítsjehe̱n ko̱ tsase ni̱ma̱ha̱, ");
INSERT INTO majNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","xi nkú kitsú títjuhu̱n ntje̱ cháná, Abraham ko̱ ntje̱ xi s'e̱he̱ a̱skahan. ");
INSERT INTO majNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jan sá kamaha̱ Maria̱ nga y'ejñako̱ Isabel. A̱skahan kik'óya ni'yaha. ");
INSERT INTO majNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsichu ni̱stjin nga tsíhi̱n ntí Isabel. Nku ntíx'i̱n kitsihi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nk'ie nga kint'é xu̱ta̱ xi tjíntut'á tiñaha̱ ko̱ xu̱ta̱ xinkjín nga Nti̱a̱ná tsase ni̱ma̱ha̱ Isabel, ta̱ tsjo ṉkjún i̱ncha kamaha̱ ko̱ kui. ");
INSERT INTO majNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nk'ie nga tsichu ni̱stjin jihi̱n ntíu̱, ngji ts'íhi̱n ni circuncision ko̱ mjehe̱ xu̱ta̱ nga Zacaria̱ k'úín ntíu̱ xi nkú 'mi na̱'mihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tu̱nga b'a̱há kitsú na̱aha̱ ntíu̱: —Najmi. Jua tjíhin nga k'úín. ");
INSERT INTO majNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","B'a̱ i̱ncha kitsú xu̱ta̱: —Tu̱nga najmi tjíhín xu̱ta̱ xinki̱u xi b'a̱ 'miu̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A̱s'a̱i kingjásjaiyaha̱ na̱'mihi̱ ntíu̱ mí j'áíhin xi mjehe̱ k'u̱ét'a. ");
INSERT INTO majNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tsanki Zacaria̱ nku yáte i̱chí ko̱ b'i̱ ts'ín y'ét'a: “Jua k'úín”, kitsú. Kama nkjúhu̱n ngayjee̱ xu̱ta̱ xi tíi̱ncha yo̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta̱ kuihi chu̱bo̱ kama kinchja̱ ngáha Zacaria̱ ko̱ kik'atuts'i̱n nga kits'íntsjoho̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kitsankjún ngayjee̱ xu̱ta̱ xi tjín tiña a̱ndai ni'yaha̱ ko̱ kinchja̱ni̱jmíyaha ni xi kamoo̱ xu̱ta̱ xi tjíntu ngayjee̱ a̱sunntu tje̱nki̱ xi tjín a̱nte Judea̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ngayjee̱ xu̱ta̱ xi kint'é niu̱ y'éjintak'un ko̱ b'i̱ i̱ncha kitsú ani̱ma̱ha̱: —¿Yá xi ka̱ma ntíu̱ nga ka̱ma chá? A̱t'aha̱ nga'yúhu̱n Nti̱a̱ná tíjñajihi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","J'aitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱ Zacaria̱, na̱'mihi̱ ntíu̱. Kits'ínkinchja̱ha̱ xi nkúhu nku nda̱ profeta̱ nga b'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Kan'etsjoho̱ Nti̱a̱ná xi Nti̱a̱ha̱ xu̱ta̱ Israel, a̱t'aha̱ j'ai ts'ín nda̱íhi̱ xu̱ta̱ xi ts'e̱! ");
INSERT INTO majNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ja kits'ín nibá nku xi tjíhi̱n nga'yún, kui xi ts'i̱ínk'ankiná, nku xi y'aha̱ ra̱ ntje̱he̱ David, nda̱ xi kint'é'éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kui ni xi kinchja̱ ni̱stjin nk'ie, nga kits'ínkinchja̱ já profeta̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kitsú nga k'u̱a̱sjejinná a̱jihi̱n já kontra̱ná, a̱jihi̱n nga'yúhu̱n ngayjee̱ já xi unkiená. ");
INSERT INTO majNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kitsú nga ku̱a̱se̱ ni̱ma̱ha̱ ntje̱ cháná, nga najmi ts'i̱ínchaya ni nda xi y'énda nk'ie. ");
INSERT INTO majNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kitsúya kixi̱hi̱ Abraham xi ntje̱ cháná maha, ");
INSERT INTO majNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nga ts'i̱ín nda̱íná a̱jihi̱n já kontra̱ná, tu̱ xi najmi ku̱i̱nkjúhunná nga ku̱i̱nú'yá'éhe̱én, ");
INSERT INTO majNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nga je ko̱ na̱xu̱ ku̱i̱ntsu̱ba̱á nginku̱n ngayjee̱ ni̱stjinná. ");
INSERT INTO majNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ko̱ ji, ntí i̱chína̱, ji xi k'úíhin nda̱ profeta̱ha̱ Nti̱a̱ná xi tíjña nk'a ján. A̱t'aha̱ ji xi k'úín títjuihi̱n Nda̱ Nti̱a̱ná, ji xi k'úéndai ni̱yáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ku̱a̱kúchjihi̱ xu̱ta̱ xi ts'e̱ yá xi ts'i̱ínk'ankihi̱, nga ka̱ma ndyjat'aha̱ ngatitsuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chánka kju̱a̱ni̱ma̱ tak'uhu̱n Nti̱a̱ná, xi nkú ts'ín ma chji ts'íu̱ nga nibá ma see̱n, ");
INSERT INTO majNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tu̱ xi ts'i̱ín ndzjehe̱n ra̱ xu̱ta̱ xi tjíntu má jyuu̱n, má tje̱n nk'íéhe̱n ngabayoo̱, tu̱ xi tsjáni̱yáhaná nkú ts'ín ku̱i̱ntsu̱ba̱jián kju̱a̱jyu. ");
INSERT INTO majNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ntíu̱ tu̱ nku kisáhá ko̱ kama nkjink'un. A̱nte kixiu̱ y'ejña santa nkúhu nga tsichu ni̱stjin nga tsakúchjihi̱ yjoho̱ xu̱ta̱ Israel. ");
INSERT INTO majNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ni̱stjin ján nda̱ títjun Augusto̱ Cesa̱r kitsjá kju̱a̱ nga ngju̱a̱i̱t'a xi nkú tjín maha xu̱ta̱ xi batéxumaha̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nk'ie nga j'a̱ísun títjun j'áíhi̱n xu̱ta̱, nda̱ Cireni̱o̱ tjíhi̱n xá a̱nte xi 'mihi̱ Siri̱a̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ngayjee̱ xu̱ta̱ nankihi̱ i̱ncha ngjik'íét'a yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nazaret tsitju Kuse, nanki i̱chí xi tíjñajihi̱n a̱nte Galilea̱, nga ngji Belen, nanki i̱chí xi tíjñajihi̱n a̱nte Judea̱. Yo̱ má nga kitsin nda̱ rei̱ David, ko̱ Kuse ta̱ ntje̱he̱ David y'aha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yo̱ ngjik'íét'a yjoho̱ nga tje̱nko̱ ts'íhin Maria̱, ta̱chju̱ún xi tíjñako̱. Ntí ja y'a Maria̱ kui chu̱bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ko̱ ni xi kama, nk'ie nga ja tjíntu yo̱, tu̱ tsichuhú ni̱stjin nga tsín ntíhi̱ Maria̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kitsihi̱n ntí tjuhu̱n. Kik'ontikjájnu nusti ko̱ kits'ínkjájñaya yátikúyá xi kjineya nichine chu̱, a̱t'aha̱ najmi ta̱ tjíhin a̱nte a̱ya ni'ya má nga ts'ínkj'a ni̱stje̱n xu̱ta̱ xi ts'ín ni̱yá. ");
INSERT INTO majNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tiña nanki Belen tjíntu a̱jin jñóo̱ já bastu xi tíi̱ncha kunntá jyun chu̱tsa̱nka̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","A̱s'a̱i tje̱n'yún nkuhú ntítsjehe̱ Nti̱a̱ná tsakúchjihi̱ yjoho̱, ko̱ kju̱a̱chánkaha̱ Nti̱a̱ná kits'ín ndzjen chji chji má xi tje̱hen kab'entu jóo̱. Tu̱ xí i̱ncha kitsankjúhún jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tu̱nga b'a̱há kitsú ntítsjee̱: —Najmi tu̱ binkjun. A̱t'aha̱ én nda tsuhú kjúái̱ xinyanu̱u, én xi ts'i̱ín nga k'úétsjoho̱ ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","A̱t'aha̱ ngandanu̱u nankihi̱ David kuatsin nd'a̱i̱ nku xi ts'i̱ínk'ankinu̱u, kui xi Cristo̱ xi Nda̱ Nti̱a̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","B'i̱ ts'ín cha̱hanu ntíu̱. Nusti kitikjájnu nga kjijñaya yátikúyá xi kjineya nichine chu̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tje̱n'yún j'ainchat'ahá ra̱ ntítsjee̱ nkjin ṉkjún sa ntítsje xi nibaha ndji̱o̱jmi ján. Kui xi kits'íntsjoho̱ Nti̱a̱ná nga b'i̱ i̱ncha kitsú: ");
INSERT INTO majNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Kas'ehe̱ kju̱a̱chánka Nti̱a̱ná nk'a ján, ko̱ t'anankiu̱ kas'ehe̱ kju̱a̱jyu xu̱ta̱ xi nda tjíntuyáha̱! ");
INSERT INTO majNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ko̱ nk'ie nga ja i̱ncha ngji ngáha ntítsjee̱ nk'a ján, b'i̱ ngján kinchja̱ko̱ xinkjín já bastuu̱: —Tjián Belen. Tjihi̱nse̱é ni xi kamoo̱, ni xi kuatsúyaná Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A̱s'a̱i i̱ncha ngji ki̱tsa̱ ki̱tsa̱ yo̱ ko̱ kisakúhu̱ Maria̱ ko̱ Kuse ko̱ ntíu̱ nga kjijñaya yátikúyá xi kjineya nichine chu̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nk'ie nga i̱ncha kikie ntíu̱, a̱s'a̱i kitsúya ni xi kik'ihi̱n nga kis'ejña chjihi̱ ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ko̱ ngayjee̱ xu̱ta̱ xi kint'é niu̱ kama nkjúhu̱n ni xi tíi̱ncha nchja̱ já bastuu̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tu̱nga máha Maria̱, ani̱ma̱ha̱ y'éjñajin ngayjee̱ ni xi kamoo̱. Tu̱ nku kits'ínnkjink'uhún niu̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A̱s'a̱i kik'óya ngáha já bastuu̱. I̱ncha kits'ínkie yjoho̱ nga Nti̱a̱ná xi tjíhi̱n kju̱a̱chánka ko̱ kits'íntsjoho̱ Nti̱a̱ná tu̱ nga̱t'aha̱ ni xi kint'é ko̱ kikie. A̱t'aha̱ tsitjusunyje ni xi kik'ihi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nk'ie nga j'a jin ni̱stjin, kin'ehe̱ ni circuncision ntíu̱ ko̱ Jesu kik'in nga kis'et'a, kui j'ái̱n xi kitsjáha̱ ntítsjee̱ Maria̱ kintehe̱ ni nga tsín ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xi nkú ts'ín tjít'a kju̱a̱téxumaha̱ Moise, nk'ie nga tsichu ni̱stjin nga tjíhin nga ts'i̱ín je yjoho̱ Maria̱ ko̱ ntíu̱ nginku̱n Nti̱a̱ná, i̱ncha ngji nanki Jerusalen tu̱ xi s'e̱jña chjihi nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","A̱t'aha̱ b'a̱ ts'ín tjít'a kju̱a̱téxumaha̱ Nti̱a̱ná: “Ngayjee̱ ntíx'i̱n xi tjun tsín, kui xi ka̱ma ts'e̱ Nti̱a̱ná.” ");
INSERT INTO majNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ngjiko̱ chje̱ xi nkú nga ts'ín tjít'a kju̱a̱téxumaha̱ Nti̱a̱ná, a̱t'aha̱ b'a̱ ts'ín tjít'a: “Jo chu̱tuju ko̱ tsa jo ni̱se xi nkú joyaha chu̱tuju xi k'u̱a̱i̱ chje̱.” ");
INSERT INTO majNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tíjña nanki Jerusalen nku nda̱ xi 'mi Simeon. Kui xi na̱xu̱ síjña nginku̱n Nti̱a̱ná ko̱ benkjún Nti̱a̱ná ko̱ tíkuyáha̱ ni̱stjin nga ka̱ma nda̱íhi̱ xu̱ta̱ Israel. Espiri̱tu̱ Santo̱ tíjñajihi̱n ");
INSERT INTO majNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ko̱ kitsúyaha̱ nga najmi ku̱a̱yá tsa najmi sku̱e̱ Cristo̱ xi ts'i̱ín nibá Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tsasín ni̱yáha̱ Espiri̱tu̱ Santo̱ nga j'ai ni̱nku̱, ko̱ nk'ie nga j'aiko̱ho̱ xi cháha̱ ntí Jesu ni̱nku̱ tu̱ xi n'e̱he̱ ra̱ xi nkú ts'ín tjít'a kju̱a̱téxumoo̱, ");
INSERT INTO majNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","a̱s'a̱i Simeon kingjáya ntsja ntíu̱. Kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná nga b'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ji Na̱'mi, ja kuasakúna kju̱a̱jyu nd'a̱i̱. Ja kuitjusun ni xi kik'inya títjunní. Kui nga tjennteheni nga ku̱a̱yáhana an xi nda̱ musu̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","A̱t'aha̱ tunkán kuakieko̱hona xi nkú ts'ín ts'i̱ínk'anki xu̱ta̱, ");
INSERT INTO majNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","xi y'endai nginku̱n ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kui xi nkú joyaha nd'í, kui xi ts'i̱ín ndzjehe̱n xu̱ta̱ a̱sunntee̱, ko̱ tsjáha̱ kju̱a̱chánka xu̱ta̱ xi ts'i̱, xu̱ta̱ Israel. ");
INSERT INTO majNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kama nkjúhu̱n na̱'mihi̱ ko̱ na̱aha̱ ntíu̱ ni xi kitsú Simeon nga kincha̱yaha ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nda kinchja̱ne Simeon xi cháha̱ ntíu̱. A̱s'a̱i b'i̱ kitsúhu̱ Maria̱: —Kui ntíi̱ xi tjíhin nga ts'i̱ínkijne ko̱ a ra̱ kjésíntje̱n nkjin xu̱ta̱ Israel. Ni xi ku̱a̱kúchji nkjin xu̱ta̱ ngju̱a̱i̱ kontra̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","B'a̱ ts'ín s'e̱jña chjihi ni xi tjíntujín ani̱ma̱ha̱ nkjin xu̱ta̱. Tu̱nga máha ji, b'a̱ ka̱mahi ni xu'bi̱ xi nkú joyaha nku ki̱cha̱ xi kju̱a̱s'enjin santaha ani̱ma̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ko̱ ta̱ síjña yo̱ nku ta̱chju̱ún profeta̱ xi 'mi Ana̱, xi ta̱kjíhi̱n Fanuel maha, xi y'aha̱ ra̱ ntje̱he̱ Aser. Kui xi ja chá ṉkjún. Kjintí nga tsixan ko̱ yatu nú kamaha̱ nga y'ejñako̱ x'i̱hi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ja tjíhi̱n cháte ko̱ katé ñju nú nga ja k'ien x'i̱hi̱n. Ko̱ tu̱ nku na̱tsin ni̱nku̱hú b'ejña. Ni̱stjin ni̱stje̱n ts'íntsjoho̱ Nti̱a̱ná nga b'ejña kjintíá ko̱ nga nchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kui chu̱bo̱ ta̱ tsichu Ana̱ yo̱ ko̱ kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná nga kikie ntí Jesu. Kitsúyaha̱ ngayjee̱ xu̱ta̱ xi tíi̱ncha kuyáha̱ ni̱stjin nga ka̱ma nda̱í ngáha̱ ra̱ nanki Jerusalen yáha kui ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ko̱ nk'ie nga ja kamaha̱ nga kits'íntjusun xi cháha̱ Jesu ngayjee̱ xi nkú ts'ín tjít'a kju̱a̱téxumaha̱ Nti̱a̱ná, a̱s'a̱i kik'óya ngáha nanki Nazaret, nanki i̱chí xi tíjñajin a̱nte Galilea̱, a̱t'aha̱ yo̱ nankihi. ");
INSERT INTO majNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kisá ntíu̱ ko̱ kis'ehe̱ nga'yún ko̱ 'yún kama nkjink'un sa. Ko̱ kitsjáha̱ kju̱a̱ndaha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Xki̱ nú i̱ncha fi xi cháha̱ Jesu nanki Jerusalen nk'ie nga bitju S'í Pascu̱a̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nk'ie nga ja jehe̱ te jo nú Jesu, i̱ncha ngji yo̱ a̱t'aha̱ b'a̱ ts'ín tíjña ni̱yáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nk'ie nga ja je s'íu̱, a̱s'a̱i i̱ncha kik'óya ngáha ni'yaha̱, tu̱nga y'ejñahá nda̱ chí Jesu nanki Jerusalen. Najmi kikie xi cháha̱ nga b'a̱ kits'ín. ");
INSERT INTO majNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Xu̱ta̱ xingisoo̱ ra̱ tje̱njihi̱n Jesu i̱ncha kitsú. Nku ni̱stjin kits'ín ni̱yá, tu̱nga nk'iehé nga tsangisjaijíhi̱n xu̱ta̱ xinkjín ko̱ xu̱ta̱ xi behe̱, ");
INSERT INTO majNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tu̱ najmi kisakúsjaihí ra̱. A̱s'a̱i kits'ínk'óya ngáha yjoho̱ nanki Jerusalen nga tsangisjai. ");
INSERT INTO majNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ni̱stjin xi ma jahan i̱ncha kisakúhu̱ Jesu na̱tsihi̱n ni̱nku̱. Kab'ejñajihi̱n já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. Kui jóo̱ xi tíbasínñjuhu̱ ko̱ tíbjásjaiyaha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ngayjee̱ xu̱ta̱ xi tínt'éhe̱ kama nkjúhu̱n kju̱a̱nkjintak'un xi tjíhi̱n Jesu ko̱ xi nkú ts'ín títsuya ni xi tíchasjaiyaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kama nkjúhu̱n xi cháha̱ nk'ie nga kikiehe̱ ko̱ b'a̱ kitsú na̱aha̱: —Ji ntína̱, ¿á b'a̱ kin'eko̱ho̱ni̱? Na̱'mihi̱ ko̱ an ni xi nkjún tímani̱ nga tíbinchisjái̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","B'i̱ kitsú Jesu: —¿Á an tíbinchisjáíhinú? ¿A najmi yanú tsa ni'yaha̱ na̱'mina̱ tjíhin nga kúáte̱jña? ");
INSERT INTO majNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tu̱nga najmi kamankjihín ra̱ ni xi kitsú Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A̱s'a̱i kits'óyako̱ ngáha xi cháha̱ Nazaret ko̱ kint'é'én tehe̱ntehe̱. Ko̱ na̱aha̱ y'éjñajin ani̱ma̱ha̱ ngayjee̱ ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu tu̱ nku kisáhá nga kama ng'ayá ko̱ 'yún kama nkjink'un sa. Kisasíhi̱n Nti̱a̱ná Ntíu̱ ko̱ xu̱ta̱ ta̱ kisasíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nk'ie nga tjíhi̱n tj'ion nú nga tíbatéxuma nda̱ títjun Tiberi̱o̱ Cesa̱r, ko̱ Ponci̱o̱ Pilato̱ tjíhi̱n xá a̱nte Judea̱, ko̱ Herode̱ Atipa̱ tjíhi̱n xá a̱nte Galilea̱, ko̱ Felipe̱ xi nda̱ nts'e̱ maha Herode̱ tjíhi̱n xá a̱nte Iturea̱ ko̱ a̱nte Trakonite̱, ko̱ Lisani̱a̱ tjíhi̱n xá a̱nte Abilini̱a̱, ");
INSERT INTO majNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ko̱ Ana ko̱ Caifa xi já na̱'mi k'aku̱hu̱ xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱, kui ni̱stjiu̱n Jua xi ntíhi̱ Zacaria̱ maha kint'é nta̱ha̱ Nti̱a̱ná nk'ie nga tíjña a̱nte kixiu̱. ");
INSERT INTO majNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","A̱s'a̱i kikjatsú'ba Jua ngayjee̱ a̱ndai ntáje̱ Jordan ko̱ y'éni̱jmíhi̱ xu̱ta̱ nga tjíhin nga ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱ nga sa̱téntá, tu̱ xi ka̱ma ndyjat'aha̱ ra̱ ngatitsuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","B'a̱ kama xi nkú ts'ín y'ét'a éhe̱n Nti̱a̱ná nda̱ profeta̱ Isaia̱: Tínu'yá nta̱ha̱ nku nda̱ xi tíkjintáya a̱nte kixiu̱: “T'endo ni̱yáha̱ Nti̱a̱ná. Tjen na̱xu̱u ni̱yáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ngayjee̱ xu̱nká xi tjín xi̱ncháha̱ ninte, ko̱ ngayjee̱ a̱nte ng'aya xi tjín n'e̱ sunya. N'e̱ na̱xu̱ ni̱yá tsitin xi tjín, ko̱ n'e̱ sunya ni̱yá xi nk'ajnu nk'at'a. ");
INSERT INTO majNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ko̱ ngayjee̱ xu̱ta̱ a̱sunntee̱ sku̱e̱ xi nkú ts'ín ts'i̱ínk'ankiná Nti̱a̱ná.” ");
INSERT INTO majNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kinchja̱ko̱ Jua xu̱ta̱ xi nibak'úhu̱n, xi mjehe̱ nga sa̱téntá: —¡Já ch'onk'un xi b'a̱ k'un! ¿Yá xi b'a̱ kitsúnu̱u nga ku̱i̱yúhu̱u kju̱a̱kjaha̱n Nti̱a̱ná xi ja tje̱n tiña? ");
INSERT INTO majNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tu̱ sahá n'o̱o ni xi ku̱a̱kúchji nga ja tsankinchj'aha̱ ru̱u ani̱ma̱nu̱u. Najmi tu̱ b'a̱ katsú ani̱ma̱nu̱u: “Ntje̱he̱ Abraham ñá”, tsa ku̱i̱xíún. A̱t'aha̱ an b'a̱ tíxinnu̱u nga santaha kui ndji̱o̱i̱ Nti̱a̱ná ka̱ma ts'i̱ín ma ntje̱he̱ Abraham. ");
INSERT INTO majNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Icho̱ ja tíjña nda nd'a̱i̱ nga ku̱a̱te kja̱ma̱ha̱ yóo̱. Kui nga ngayjee̱ yá xi najmi nda tu xi tsjáha, kui xi stísun ko̱ chja̱nikj'ajin a̱jin nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A̱s'a̱i b'a̱ kitsú xu̱ta̱ nga kingjásjaiyaha̱ Jua: —¿Mí ni xi tjíhin nga n'e̱i̱ ji̱n? ");
INSERT INTO majNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","B'a̱ kitsú Jua: —Xi tíjñaha̱ jo chi̱nka ndju, katsjáha̱ xi najmi tjíhi̱n. Ko̱ xi tjíhi̱n nichine, b'a̱ ta̱ kats'ín. ");
INSERT INTO majNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta̱ j'ai k'u̱a̱ já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ tu̱ xi sa̱téntáha ko̱ b'i̱ i̱ncha kitsú: —Ji nda̱ maestru̱, ¿mí nihi xi n'e̱i̱ ji̱n? ");
INSERT INTO majNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","B'i̱ kitsú Jua: —Najmi tu̱ bitjatíúhu̱u nga chj'a̱chjíú xi nkú nga ts'ín tíjña. ");
INSERT INTO majNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ko̱ k'u̱a̱ já jun ta̱ kingjásjaiyaha̱: —Ko̱ ji̱n, ¿mí nihi xi n'e̱i̱? B'i̱ kitsú Jua: —Najmi tu̱ ch'a chju'á kju̱a̱'yúhu̱un ni xi tjíhi̱n ko̱ najmi tu̱ chjaninóho̱o tsa mí nihi, tsa tu̱ xi b'a̱ ts'ín sa̱kúhu̱nu̱u to̱on. Tsjo katumanu̱u xi nkú nga tjín tíma chjínu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ngayjee̱ xu̱ta̱ tu̱ tíi̱ncha basehé ko̱ b'i̱ ngján i̱ncha kitsú nga kits'ínnkjink'un: “Kutsa kuihí Jua xi kits'ín nibá Nti̱a̱ná.” ");
INSERT INTO majNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tu̱nga b'i̱hí kitsú Jua nga kinchja̱ko̱yje xu̱ta̱: —An ntánijua tíbatentáko̱ho̱nu̱u, tu̱nga kj'u̱a̱íhí nku xi 'yún nk'a tje̱n sa, xi ndaha̱chí najmi tsuhuna tsa kjenndáya n'úhu̱ ntéhe̱. Kui xi Espiri̱tu̱ Santo̱ ko̱ nd'í ku̱a̱téntáko̱ho̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kui xi nkú joyaha nda̱ xi ts'ín chuhu̱n tuni̱ñu̱. Ja kjiya ntsja yá xi ts'ín chunko̱ho̱ ra̱ tuni̱ñu̱hu̱, tu̱ xi ts'i̱ínkj'a t'axíhin tuni̱ñu̱ ko̱ xin ts'i̱ínkj'a tja̱ba̱ha̱. A̱s'a̱i kj'u̱átjo tuni̱ñu̱ ni'ya nji̱hi̱, ko̱ k'u̱éti tja̱ba̱ha̱ a̱jin nd'í xi najmi ta̱ ka̱maha̱ ra̱ ku̱a̱yáyaha. ");
INSERT INTO majNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","B'a̱ ts'ín kinchja̱ Jua, ko̱ nkjin sa kj'a̱í kju̱a̱téxuma xi kitsjáha̱ xu̱ta̱ nga y'éni̱jmí én nda tsuhu̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ko̱ ta̱ kinchja̱tiko̱ nda̱ rei̱ Herode̱ Antipa̱, a̱t'aha̱ na̱ Herodia̱ tíjñako̱, kui xi chju̱úhu̱n Felipe̱ xi nda̱ nts'e̱ maha Herode̱, ko̱ nga̱t'aha̱ ya ngayjee̱ ni ch'onk'un xi kits'ín Herode̱. ");
INSERT INTO majNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tu̱nga ngatentee̱ ni ch'onk'un xi kits'ín Herode̱ y'ésun saha̱ xu'bi̱. Nu̱ba̱yá kits'ínkjas'en Jua. ");
INSERT INTO majNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ko̱ ni xi kama nk'ie nga tísaténtá ngatentee̱ xu̱ta̱, ta̱ kisaténtá Jesu. Nk'ie nga tínchja̱ko̱ Nti̱a̱ná, tsix'á nk'a ján ");
INSERT INTO majNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ko̱ nibajenne chji chjihi̱ Espiri̱tu̱ Santo̱ xi nkú joyaha chu̱tuju. Ko̱ kinu'yá nk'a ján nku nta̱ xi b'i̱ kitsú: —Ji Ntína̱, tjona ji. Tsjo ṉkjún mana ji. ");
INSERT INTO majNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Katé ra̱ nú tjíhi̱n Jesu nk'ie nga kik'atuts'i̱hi̱n xáha̱. Kui xi ntíhi̱ Kuse kitsú xu̱ta̱. Kuse, kui xi ntíhi̱ Eli. ");
INSERT INTO majNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli, kui xi ntíhi̱ Matat. Matat, kui xi ntíhi̱ Levi. Levi, kui xi ntíhi̱ Melki̱. Melki̱, kui xi ntíhi̱ Jana̱. Jana̱, kui xi ntíhi̱ Kuse. ");
INSERT INTO majNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Kuse, kui xi ntíhi̱ Matatia̱. Matatia̱, kui xi ntíhi̱ Amos. Amos, kui xi ntíhi̱ Nahum. Nahum, kui xi ntíhi̱ Esli̱. Esli̱, kui xi ntíhi̱ Nagai. ");
INSERT INTO majNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, kui xi ntíhi̱ Mat. Mat, kui xi ntíhi̱ Matatia̱. Matatia̱, kui xi ntíhi̱ Semei. Semei, kui xi ntíhi̱ Jose. Jose, kui xi ntíhi̱ Juda̱. ");
INSERT INTO majNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Juda̱, kui xi ntíhi̱ Joana̱. Joana̱, kui xi ntíhi̱ Resa̱. Resa̱, kui xi ntíhi̱ Zorobabel. Zorobabel, kui xi ntíhi̱ Salatiel. Salatiel, kui xi ntíhi̱ Neri̱. ");
INSERT INTO majNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri̱, kui xi ntíhi̱ Melki̱. Melki̱, kui xi ntíhi̱ Adi̱. Adi̱, kui xi ntíhi̱ Cosam. Cosam, kui xi ntíhi̱ Elmodam. Elmodam, kui xi ntíhi̱ Er. ");
INSERT INTO majNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, kui xi ntíhi̱ Josue. Josue, kui xi ntíhi̱ Elieze̱r. Elieze̱r, kui xi ntíhi̱ Jori̱m. Jori̱m, kui xi ntíhi̱ Matat. ");
INSERT INTO majNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat, kui xi ntíhi̱ Levi. Levi, kui xi ntíhi̱ Simeon. Simeon, kui xi ntíhi̱ Juda̱. Juda̱, kui xi ntíhi̱ Kuse. Kuse, kui xi ntíhi̱ Jonan. Jonan, kui xi ntíhi̱ Eliakim. ");
INSERT INTO majNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim, kui xi ntíhi̱ Melea̱. Melea̱, kui xi ntíhi̱ Mainan. Mainan, kui xi ntíhi̱ Matata̱. Matata̱, kui xi ntíhi̱ Natan. ");
INSERT INTO majNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natan, kui xi ntíhi̱ David. David, kui xi ntíhi̱ Isai. Isai, kui xi ntíhi̱ Obed. Obed, kui xi ntíhi̱ Booz. Booz, kui xi ntíhi̱ Salmon. Salmon, kui xi ntíhi̱ Naason. ");
INSERT INTO majNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason, kui xi ntíhi̱ Aminadab. Aminadab, kui xi ntíhi̱ Aram. Aram, kui xi ntíhi̱ Esrom. Esrom, kui xi ntíhi̱ Fare̱s. Fare̱s, kui xi ntíhi̱ Juda̱. ");
INSERT INTO majNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda̱, kui ntíhi̱ Jacob. Jacob, kui xi ntíhi̱ Isaac. Isaac, kui xi ntíhi̱ Abraham. Abraham, kui xi ntíhi̱ Tare. Tare, kui xi ntíhi̱ Nakor. ");
INSERT INTO majNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor, kui xi ntíhi̱ Serug. Serug, kui xi ntíhi̱ Ragau. Ragau, kui xi ntíhi̱ Peleg. Peleg, kui xi ntíhi̱ Hebe̱r. Hebe̱r, kui xi ntíhi̱ Sala̱. ");
INSERT INTO majNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala̱, kui xi ntíhi̱ Cainan. Cainan, kui xi ntíhi̱ Arfaxa̱d. Arfaxa̱d, kui xi ntíhi̱ Sem. Sem, kui xi ntíhi̱ Noe. Noe, kui xi ntíhi̱ Lame̱c. ");
INSERT INTO majNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lame̱c, kui xi ntíhi̱ Matusalen. Matusalen, kui xi ntíhi̱ Enoc. Enoc, kui xi ntíhi̱ Jare̱d. Jare̱d, kui xi ntíhi̱ Mahalalel. Mahalalel, kui xi ntíhi̱ Cainan. ");
INSERT INTO majNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan, kui ntíhi̱ Enos. Enos, kui xi ntíhi̱ Set. Set, kui xi ntíhi̱ Adan. Adan, kui xi ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kitsejíhi̱n ra̱ Jesu Espiri̱tu̱ Santo̱ nk'ie nga nibaha ntáje̱ Jordan, ko̱ Espiri̱tu̱ Santo̱ ngjiko̱ho̱ a̱nte kixiu̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yo̱ y'ejña yachán ni̱stjin ko̱ nda̱nindoo̱ kikjut'ayák'uhu̱n. Najmi chumi nihi xi kikjine ngayjee̱ ni̱stjin xu'bo̱. A̱skahan kama bjoho̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A̱s'a̱i b'i̱ kitsú nda̱nindoo̱ nga kinchja̱ko̱ Jesu: —Tsa kju̱axi̱ nga ji xi Ntíhi̱ Nti̱a̱ná, b'a̱ t'ihi̱n ndji̱o̱i̱ nga ni̱nku̱a̱n katuma. ");
INSERT INTO majNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","B'i̱ kitsú Jesu: —B'i̱ ts'ín tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná: “Najmi nku tutu ni̱nku̱o̱n xi ts'ín nga b'entu tík'un xu̱ta̱.” ");
INSERT INTO majNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A̱s'a̱i ngjiko̱ho̱ nda̱nindoo̱ nku a̱sunntu tje̱nki̱ nk'a. Kutjuhú yo̱ tsakúyjehe̱ má batéxuma já rei̱ xi tjín a̱sunntee̱ ");
INSERT INTO majNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ko̱ b'a̱ kitsúhu̱: —Ts'inkjas'ehen nga ku̱a̱texumaihi̱ ngayjee̱ na̱xi̱nantá xu'bi̱ ko̱ kju̱a̱chánka xi tjíhi̱n. A̱t'aha̱ an kik'a̱i̱na ko̱ tsjaha̱ xi ka̱ma mjena nga tsjaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tsa ku̱i̱si̱nkúnch'int'aní nga cha̱nkjúnní, ka̱ma ts'i̱ ngayjee̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","B'i̱ kitsú Jesu: —B'a̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “Cha̱nkjúín Nti̱a̱ná, kui xi Nti̱a̱hi̱ maha ko̱ nkuhú kui ku̱i̱nú'yá'éíhi̱n.” ");
INSERT INTO majNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A̱s'a̱i ngjiko̱ho̱ nda̱nindoo̱ nanki Jerusalen. Kits'ín s'esun má 'yún nk'aha̱ ni̱nku̱ ko̱ b'a̱ kitsúhu̱: —Tsa kju̱axi̱ nga ji xi Ntíhi̱ Nti̱a̱ná, chja̱nikj'anki yjohi̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","A̱t'aha̱ b'a̱ títsu xu̱ju̱n éhe̱n Nti̱a̱ná: Nti̱a̱ná k'u̱éxá ntítsjehe̱ xi má nga kúhin ko̱ ku̱a̱se̱hi. ");
INSERT INTO majNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kjésíntje̱nya ntsjahi tu̱ xi ndaha nku ndji̱o̱ najmi sa̱ténkihi tsu̱kui. ");
INSERT INTO majNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","B'i̱ kitsú Jesu: —Ko̱ b'a̱ ta̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “Najmi tu̱ ji chjut'ayák'uin Nti̱a̱ná, kui xi Nti̱a̱hi̱ maha.” ");
INSERT INTO majNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nk'ie nga jet'aha̱ nda̱nindoo̱ ngayjee̱ ni xi kikjut'ayák'unko̱ho̱ Jesu, a̱s'a̱i ngji t'axíhi̱n chuba ni̱stjin. ");
INSERT INTO majNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","A̱s'a̱i kik'óya ngáha Jesu a̱nte Galilea̱ nga kitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱, ko̱ ngayjee̱ xu̱ta̱ xi tjín tiña yo̱ nda ts'ín kinchja̱ni̱jmíyaha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tsakúya xki̱ ni'ya sinagoga̱ xi tjín yo̱, ko̱ ngayjee̱ xu̱ta̱ nda ts'ín kikiehe̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A̱s'a̱i tsichu nanki Nazaret má nga kama chá. Nku xua̱tu̱ tjíhin jas'en ni'ya sinagoga̱ xi nkú ts'ín tíjña ni̱yáha̱. Yo̱ kits'ínya éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kik'a̱i̱hi̱ xu̱ju̱n éhe̱n Nti̱a̱ná xi y'ét'a nda̱ profeta̱ Isaia̱. A̱s'a̱i kikjexínka xu̱ju̱n ko̱ kisakúhu̱ má nga b'i̱ ts'ín tjít'a: ");
INSERT INTO majNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espiri̱tu̱hu̱ Nti̱a̱ná tíjñajinna a̱t'aha̱ Nti̱a̱ná kitsjá xána, tu̱ xi k'ueni̱jmíhi̱ ra̱ xu̱ta̱ x'a̱n én tse̱tse̱ xi nda tsu. Nti̱a̱ná kits'ín nibána, tu̱ xi xínyaha̱ ra̱ xu̱ta̱ xi kjintuyá'yún nga ka̱ma nda̱íhi̱, nga kjex'ánkia tunku̱n xu̱ta̱ ka̱, nga ts'in nda̱íhi̱ xu̱ta̱ xi un tíbehe̱, ");
INSERT INTO majNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ko̱ nga k'ueni̱jmíhi̱ xu̱ta̱ nga nd'a̱i̱ ku̱a̱kúchji Nti̱a̱ná kju̱a̱ndaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","A̱s'a̱i kingjákjoya ngáha xu̱ju̱n ko̱ kitsjáha̱ nda̱ xi basehe̱ ni'ya sinagoga̱. Y'ejña. Ngayjee̱ xu̱ta̱ xi tjíntu yo̱ tu̱ nku tsasentáhá ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A̱s'a̱i b'i̱ kitsú nga kinchja̱: —Nd'a̱i̱ nginkun kuitjusun éhe̱n Nti̱a̱ná xi kuanu'yó e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ngayjee̱ xu̱ta̱ nda ts'ín kinchja̱yane Jesu ko̱ i̱ncha kama nkjúhu̱n ra̱ én tsjo tsu xi tsitju ts'a. B'i̱ ngján b'a̱ i̱ncha kitsúhu̱ xinkjín: —¿A najmi kuihí nda̱i̱ xi ntíhi̱ Kuse? ");
INSERT INTO majNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","B'i̱ ta̱ kitsú Jesu: —Be nga b'a̱ ku̱i̱xínnú xi nkú tsu én xi nchja̱ xu̱ta̱: “Ji nda̱ chji̱ne̱nki, ji ma tjun n'e̱nkihi̱ yjohi̱”, ko̱ ta̱ be nga b'a̱ ku̱i̱xíún: “Ni xi kinu'yái̱ nga kin'ei Capernaum, kui nihi xi ta̱ n'e̱i̱ e̱i̱ nankihi̱.” ");
INSERT INTO majNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ko̱ b'i̱ ta̱ kitsú: —Kju̱axi̱ ni xi tíxinnu̱u. Ndaha nku nda̱ profeta̱ najmi nda ts'ín n'ekjáíhi̱n nankihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kju̱axi̱ nga nkjin maha jminchjín xi ja k'ien x'i̱hi̱n xi tjín Israel ni̱stjin nga y'ejña nda̱ profeta̱ Elia̱, nk'ie nga kis'echjá nk'a ján nga najmi ta̱ kik'aha ts'í jan nú masen tjíhin ko̱ nk'ie nga tu̱ xí chánkahá kjintíá xi kis'e ngayjee̱ a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ndaha tsa b'a̱ kama, tu̱nga najmi kin'ekjísehé ra̱ ndaha nku jminchjín xi ja k'ien x'i̱hi̱n xi tjín yo̱, nku tutuhú ta̱chju̱ún xi ja k'ien x'i̱hi̱n xi y'ejña Sarepta̱, nanki xi tiña maha̱ nanki Sidon. ");
INSERT INTO majNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ko̱ ta̱ nkjin maha xu̱ta̱ xi k'uhu̱n ch'in fentujnu xi tjín Israel ni̱stjin nga y'ejña nda̱ profeta̱ Eliseo̱, tu̱nga ndahá nku najmi kama nkihi̱, nku tutuhú Naman, nda̱ xi a̱nte Siri̱a̱ nibáha. ");
INSERT INTO majNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nk'ie nga i̱ncha kint'é ni xu'bi̱, ngayjee̱ xu̱ta̱ xi tjíntu a̱ya ni'ya sinagoga̱ tu̱ ni xí kama kjahán ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","A̱s'a̱i i̱ncha tsisintje̱n ko̱ kik'onsje Jesu na̱tsin na̱nti̱o̱. I̱ncha ngjiko̱ santaha má nk'antjaihi̱ a̱sunntu tje̱nki̱ xi kamandasún nankiu̱, tu̱ xi yo̱ kja̱níkj'antjaihi. ");
INSERT INTO majNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tu̱nga j'ajin masehén ra̱ Jesu xu̱to̱ nga ngji. ");
INSERT INTO majNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A̱s'a̱i ngji Jesu nanki Capernaum, nanki xi tíjñajihi̱n a̱nte Galilea̱. Yo̱ tsakúyaha̱ xu̱ta̱ éhe̱n Nti̱a̱ná nga ni̱stjin nkjún. ");
INSERT INTO majNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kama nkjúhu̱n xu̱ta̱ xi nkú ts'ín tsakúya, a̱t'aha̱ kinchja̱ xi nkúhu tsa xá tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ko̱ a̱ya ni'ya sinagoga̱ xi tíjña yo̱ kab'ejñajihi̱n xu̱ta̱ nku nda̱ xi tíjñajihi̱n nku nda̱ninda. Kui xi 'yún ṉkjún kikjintáya nga b'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Ji Jesu xi nibáhani Nazaret, ¿mí nihi xi tjínko̱ni̱? ¿Á ja kjúái̱ n'ekjehe̱ni̱? Bená yáha ji. Ji xi ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tu̱nga ndjáhá kinchja̱ko̱ Jesu nda̱nindoo̱: —¡Xu̱ sin n'ei ko̱ ti̱tjusje̱jihi̱n ndo̱! A̱s'a̱i nda̱nindoo̱ kikjaníkj'a ndo̱ t'anankiu̱ nginku̱n ngayjee̱ xu̱ta̱ ko̱ najmi kits'ín'uhu̱n nga tsitjujíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tu̱ ni xí kama nkjúhún ra̱ ngatentee̱ xu̱ta̱ ko̱ b'i̱ ngján kingjásjaiyaha̱ xinkjín: —¿Mí én chánkaha xu'bi̱? Tjíhi̱n nga'yún ndo̱ nga batéxumaha̱ jánindoo̱ ko̱ nt'é'éhe̱n nga m'osje. ");
INSERT INTO majNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ngayjee̱ a̱nte xi tjín tiña yo̱ tu̱ xí kichubani̱jmíyahá ni Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A̱s'a̱i tsisintje̱n Jesu ko̱ tsitju ni'ya sinagoga̱ nga ngji ni'yaha̱ Simon. Kui chu̱bo̱ ch'in kjijñako̱ na̱ nchí'yaha̱ Simon. Tu̱ xí tímahá ra̱ ch'in ko̱ b'a̱ kik'ihi̱n Jesu tsa ts'i̱ínnkihi̱ ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A̱s'a̱i kingjénstenne Jesu ta̱chjúu̱n ko̱ tsanka tje̱nnki ch'iu̱n. Kindyjajihi̱n ch'iu̱n ko̱ tje̱n'yún tsisintje̱hén nga kitsjáha̱ nichine xi tsichusehe̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nk'ie nga ja ngjintjai ts'íu̱, ngayjee̱ xu̱ta̱ xi tjíhi̱n xu̱ta̱ un xi kj'a̱í kj'a̱í ch'in xi k'uhu̱n, kui xi i̱ncha j'aiko̱ho̱ Jesu ko̱ Jesu kingjenne ntsja nga nkúnkú xu̱ta̱ uu̱n ko̱ kits'ínnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ko̱ nkjin ta̱ maha xu̱ta̱ xi tsitjujíhi̱n jánindoo̱. B'a̱ kitsú jánindoo̱ nga kikjintáya: —¡Ji xi Ntíhi̱ Nti̱a̱ná! Tu̱nga ndjáhá kinchja̱ko̱ Jesu jánindoo̱. Najmi kitsjántehe̱ tsa ku̱i̱nchja̱, a̱t'aha̱ i̱ncha be nga Jesu xi kits'ín nibáha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nk'ie nga ja kama see̱n, tsitju Jesu nga ngji nku a̱nte t'axín tiya. Tu̱nga tsangisjaihí ra̱ xu̱ta̱, ko̱ nk'ie nga i̱ncha tsichu má xi tje̱hen síjña Jesu, kama mjehe̱ nga ts'i̱ínkasín'yún tu̱ xi najmi ngju̱a̱i̱hi. ");
INSERT INTO majNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tu̱nga b'i̱hí kitsú Jesu: —Tjíhin nga ta̱ k'ueni̱jmíhi̱ xu̱ta̱ na̱nti̱a̱ xingisoo̱ én nda tsuhu̱ Nti̱a̱ná xi tsu nga Nti̱a̱ná tíbatéxuma. A̱t'aha̱ kui xá kin'e nibáhana. ");
INSERT INTO majNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ja kamoo̱, ngjik'íéni̱jmí Jesu éhe̱n Nti̱a̱ná xki̱ ni'ya sinagoga̱ xi tjín a̱nte Judea̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nku ni̱yá nk'ie nga síjña Jesu a̱ndai ntáchak'un xi 'mi Genesaret, j'aitsenéhe̱ ra̱ xu̱ta̱ xi mjehe̱ ku̱a̱sínñjuhu̱ éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kikie Jesu jo tsutsu xi kjintu tiya a̱ndai ntáchak'uu̱n, a̱t'aha̱ ja kabitjujen já tsuba tji̱o̱ nga tíi̱ncha bané na̱'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A̱s'a̱i jas'en Jesu nku tsutsu, yá xi ts'e̱ Simon, ko̱ tsankihi̱ nga ts'i̱ín t'axín i̱chí tsutsuu̱ a̱ndai ntáchak'uu̱n. Y'ejñaya Jesu yóo̱ nga tsakúyaha̱ xu̱ta̱ éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nga ja kamaha̱ nga kinchja̱, a̱s'a̱i kinchja̱ko̱ Simon: —T'inko̱i̱ tsutsuu̱ má na̱nka̱ha̱ ntáchak'uu̱n. Yo̱ chja̱nikj'o na̱'yanu̱u tu̱ xi sa̱kúhu̱nu̱u tji̱o̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","B'a̱ kitsú Simon: —Ji nda̱ maestru̱, nku ni̱stje̱n kamjei̱ na̱'yani̱. Ndaha nku tji̱o̱ najmi kafit'ani̱. Tu̱nga jihí xi b'a̱ tíbixín, kui nga kfín kjanikj'áhana na̱'yoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nk'ie nga ja b'a̱ kits'ín jóo̱, tu̱ ni xí nkjihín tji̱o̱ kisakúhu̱ nga santaha xí mjehé stíya na̱'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","A̱s'a̱i kinchja̱ha̱ já xinkjín xi tíi̱ncha tsutsu xinkuu̱ tu̱ xi kj'u̱a̱ísinko̱ho̱ ra̱. J'ai jóo̱ ko̱ kits'íntse susun nga joo̱ tsutsuu̱ ko̱ i̱chí mahá ndyjaha̱ nga ngju̱a̱i̱jinntí. ");
INSERT INTO majNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nk'ie nga kikie Simon Pedro̱ niu̱, tsasinkúnch'in nginku̱n Jesu ko̱ b'a̱ kitsúhu̱: —Ji Nda̱ Nti̱a̱, t'ejñaní, a̱t'aha̱ xi nkúhu an, ngatitsuhún ts'ian. ");
INSERT INTO majNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","B'a̱ kitsú a̱t'aha̱ kitsankjún Simon ko̱ ngayjee̱ já xi tje̱nko̱ho̱ tu̱ nga̱t'aha̱ tji̱o̱ ṉkjún xi kisakúhu̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","B'a̱ ta̱ kamaha̱ Santiago̱ ko̱ Jua xi jáha̱ Zebedeo̱ maha, xi ta̱ tje̱nko̱ Simon. Tu̱nga b'i̱hí kitsú Jesu nga kinchja̱ko̱ Simon: —Najmi tu̱ binkjuin. Nd'a̱i̱ ch'a̱tuts'i̱hi̱n ri̱ nga xu̱ta̱ nu̱ba̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nk'ie nga i̱ncha j'aiko̱ tsutsuu̱ a̱ndai ntóo̱, i̱ncha y'éntuyje ni xi tjíhi̱n yo̱ ko̱ kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ni xi kama, nk'ie nga tíjña Jesu nku nanki i̱chí xi tjín yo̱, tu̱ j'aihí nku nda̱ xi k'uhu̱n ch'in fentujnu. Nk'ie nga kikie Jesu, tsasinkúnch'int'aha̱ ko̱ kinchja̱ntjai yjoho̱: —Ji nda̱ maestru̱, tsa ji xi mjehi, ka̱ma n'e̱ jení nga chjúxinní ch'in xi k'unna. ");
INSERT INTO majNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","A̱s'a̱i kingjénne ntsja Jesu nda̱ uu̱n ko̱ b'i̱ kitsúhu̱ nga kits'ínko̱: —Mjena. Katuma jei. Ta̱ kuihi chu̱bo̱ tsitjuxíhi̱n ch'ihi̱n ndo̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A̱s'a̱i b'i̱ kitsúhu̱ Jesu ndo̱: —Ji, najmi tu̱ ch'a xi 'miyaihi̱. T'ihi̱nkúchjihi̱ yjohi̱ nda̱ na̱'miu̱ ko̱ tjein chje̱ xi nkú ts'ín y'éjña Moise a̱t'aha̱ ja kama jei, tu̱ xi sku̱e̱ kixi̱hi xu̱ta̱ nga ja kamanda ngáhani. ");
INSERT INTO majNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ndaha tsa b'a̱ tsu Jesu, tu̱nga tu̱ sahá 'yún kiya sa. Nkjin ṉkjún xu̱ta̱ xi f'aisehe̱ tu̱ xi ku̱a̱sínñjuhu̱ ra̱ ko̱ tu̱ xi ka̱ma nkihi̱ ra̱, a̱t'aha̱ ch'in k'uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tu̱nga máha Jesu, a̱nte kixi xi tjín yo̱ fi nga fi t'axín. Yo̱ kinchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nku ni̱stjin nk'ie nga tíbakúya Jesu, yo̱ ta̱ kab'entu já fariseo̱ ko̱ já xi bakúya kju̱a̱téxumoo̱ xi nibaha nga ngúsuhu̱n a̱nte Galilea̱, a̱nte Judea̱ ko̱ nanki Jerusalen. Kis'ejña chji nga'yúhu̱n Nti̱a̱ná a̱jihi̱n Jesu nga kits'ínnkihi̱ xu̱ta̱ un kui chu̱bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tu̱ j'aihí k'u̱a̱ já xi kab'anganki nku nda̱ nga kjisun na̱chaha̱n, xi najmi ma fi. Mjehe̱ jóo̱ nga kju̱a̱s'enko̱ nda̱ uu̱n a̱ya ni'yoo̱ ko̱ ngju̱ájña nginku̱n Jesu kai. ");
INSERT INTO majNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tu̱nga najmi kisakú ni̱yáhá ra̱ xi nkú ts'ín kju̱a̱s'enko̱ho, a̱t'aha̱ katsehe xu̱ta̱ yo̱. Kui nga i̱ncha ngjiyajnuhu nk'a ni'yoo̱ ko̱ i̱ncha kikjexín nku te ni xi kjinehe̱ ni'yoo̱. Yo̱ kits'ín nibájen nda̱ uu̱n nga kjiya na̱chan ts'íhi̱n ra̱. Kits'ín nibájen santa nkúhu nga j'aingjájña kamasehe̱n a̱yoo̱ xi tje̱hen nginku̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nk'ie nga kikie Jesu nga s'ejihi̱n jóo̱ yáha kui, a̱s'a̱i kinchja̱ko̱ nda̱ uu̱n: —Ji nda̱ xinkjíán, ja kama ndyjat'ahi ngatitsuhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A̱s'a̱i kik'atuts'i̱hi̱n já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱ nga b'i̱ ts'ín kits'ínnkjink'un: “¿Yá nda̱ha xu'bi̱? Najmi tíbenkjún Nti̱a̱ná nga b'a̱ ts'ín tínchja̱. A̱t'aha̱ nku tutuhú Nti̱a̱ná xi maha̱ ts'ínndyjat'aha̱ ngatitsuhu̱n xu̱ta̱.” ");
INSERT INTO majNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tu̱nga kamankjihín ra̱ Jesu ni xi tíi̱ncha ts'ínnkjink'un jóo̱. A̱s'a̱i b'i̱ kitsúhu̱: —¿Á b'a̱ ts'ín tín'enkjínk'uhunnu? ");
INSERT INTO majNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Má éhen xi 'yún na̱xu̱ tje̱n xi ka̱ma xíhi̱n ndo̱? ¿A: “Ja kama ndyjat'ahi ngatitsuhi̱n”? ¿A ra̱: “Ti̱síntje̱i̱n ko̱ ti̱tsutjai”? ");
INSERT INTO majNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tu̱nga mjehéna nga cho̱o nga Ntíhi̱ Nda̱x'i̱u̱n tíjña ngajoho̱ Nti̱a̱ná a̱sunntei̱ xi má nga ka̱ma ts'i̱ínndyjat'aha̱ ngatitsuhu̱n xu̱ta̱. A̱s'a̱i b'i̱ kitsúhu̱ nda̱ xi najmi ma fiu̱: —Ji tínchjako̱ho. Ti̱síntje̱i̱n, chjúbéí na̱chahi̱n ko̱ t'in ngáhani ni'yahi̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A̱s'a̱i nginku̱n ngatentee̱ xu̱ta̱ tje̱n'yún tsisintje̱hén nda̱ uu̱n, jakj'á na̱chan xi kjijñasun ko̱ títs'íntsjo ts'íhi̱n ra̱ Nti̱a̱ná nga ngji ngáha ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kama nkjúhu̱n ngayjee̱ xu̱ta̱ ko̱ kits'íntsjoho̱ Nti̱a̱ná. Tu̱ ni xí kitsankjúhún nga b'i̱ i̱ncha kitsúhu̱ xinkjín: —Kju̱a̱nkjún xi kju̱axi̱hi kuayaá nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nk'ie nga ja kama, a̱s'a̱i tsitju Jesu ko̱ kikie nku nda̱ xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱, xi Levi 'mi. Kui xi kab'ejña a̱nte má nga f'áchjíntjai ch'á. Jesu b'i̱ kitsúhu̱: —Tsjénnkiní. ");
INSERT INTO majNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A̱s'a̱i tsisintje̱n Levi, y'éntuyje ni xi tjíhi̱n yo̱ ko̱ kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ni'yaha̱ Levi kits'íhi̱n Jesu nku s'í chánka ko̱ nkjin ṉkjún já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ ko̱ kj'a̱í sa xu̱ta̱ kab'entut'áko̱ho̱ yámixo̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tu̱nga já fariseo̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ b'a̱ i̱ncha kitsúhu̱ já ni'yakuyáha̱ Jesu nga y'ésiko̱: —¿Á já xi f'áchjíntjaihi ch'á ko̱ já xi najmi na̱xu̱ ts'íntjusuhun kju̱a̱téxumoo̱ tíchineko̱honu ko̱ tí'yuko̱honu? ");
INSERT INTO majNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A̱s'a̱i b'i̱ kitsú Jesu: —Xu̱ta̱ xi uhu̱n machjéhe̱n já chji̱ne̱nki, najmi xi ndaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Najmi xu̱ta̱ xi na̱xu̱ ts'íntjusun kju̱a̱téxumaha̱ Moise jái̱ nchjaha̱, xu̱ta̱ ngatitsun ní jái̱ nchjaha̱ tu̱ xi ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A̱s'a̱i b'i̱ i̱ncha kitsúhu̱ jóo̱ Jesu: —Nkjin ni̱yá b'entu kjintíá ko̱ nchja̱ko̱ Nti̱a̱ná já ni'yakuyáha̱ Jua Bautista̱, ko̱ b'a̱ ta̱ ts'ín já ni'yakuyáha̱ já fariseo̱. Tu̱nga máha xi ts'i̱, i̱ncha kjine ko̱ 'bi. ");
INSERT INTO majNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","B'i̱ kitsú Jesu: —¿A mahá b'entu kjintíá xu̱ta̱ xi tjíntujín nku s'í kju̱a̱bixan nk'ie nga tíjñajin saha̱ nda̱ bixoo̱n? ");
INSERT INTO majNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tu̱nga ku̱i̱chúhú ni̱stjin nga chjú'aha̱ nda̱ bixoo̱n. Nk'ie nga ku̱i̱chú ni̱stjin xu'bo̱, nk'iehé nga k'úéntu kjintíá. ");
INSERT INTO majNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ko̱ b'i̱ ts'ín ta̱ y'éjña chu̱ba̱yaha̱: —Najmi tjín xi batet'a nku te najyun tse̱tse̱ ko̱ b'éstit'ako̱ho nku najyun chá. Tsa b'a̱ ts'i̱ín, najmi tu̱ nku najyun tse̱tse̱ batsun. Ta̱ najmi b'akjáha̱ xinkjín najyuu̱n nga s'estiya. ");
INSERT INTO majNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ko̱ ta̱ ndaha najmi ch'a binchá binu̱ tse̱tse̱ nku tsa tja̱ba̱xín chá. A̱t'aha̱ binu̱ tse̱tse̱ kjeti̱ya tsa tja̱ba̱xín chóo̱. A̱s'a̱i fi ndzjo binu̱ ko̱ batsún tsa tja̱ba̱xíu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kui nga tsa tja̱ba̱xín tse̱tse̱hé xincháha binu̱ tse̱tse̱. ");
INSERT INTO majNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","’Ko̱ najmi tjín xi 'bi binu̱ chá, tsa tu̱ sa binu̱ tse̱tse̱hé ts'i̱ín mje ngá. A̱t'aha̱ b'a̱ tsu nga xi chóo̱ xi 'yún nda. ");
INSERT INTO majNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nku xua̱tu̱ tíf'a Jesu má nga tjíntje̱ tuni̱ñu̱. A̱s'a̱i já ni'yakuyáha̱ i̱ncha kikje'yún tuni̱ñu̱ ko̱ i̱ncha kits'íntjiya ntsja nga kikjine. ");
INSERT INTO majNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","A̱s'a̱i k'u̱a̱ já fariseo̱ b'a̱ kitsúhu̱: —¿Á ni xi tíjña nkjúhu̱n ra̱ kju̱a̱téxumoo̱ nga ni̱stjin nkjúu̱n tín'ehenu? ");
INSERT INTO majNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","B'i̱ kitsú Jesu: —¿A najmi kje̱hé n'eyo má nga tjít'a ni xi kits'ín David nk'ie nga kama bjoho̱ kui ko̱ já xi tje̱nko̱ho̱? ");
INSERT INTO majNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jas'en a̱nte nkjúhu̱n Nti̱a̱ná ko̱ kikjine ni̱nku̱a̱n nkjún xi tjíntu yo̱, ni xi tu̱ já na̱'miu̱ ma kjinehé. Kikjine niu̱ ko̱ ta̱ kitsjáha̱ já xi tje̱nko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ko̱ b'a̱ ta̱ kitsúhu̱: —Ntíhi̱ Nda̱x'i̱u̱n batéxumaha̱ santaha ko̱ ni̱stjin nkjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ni xi kama nga kj'a̱í xua̱tu̱ ngáha, jas'en Jesu ni'ya sinagoga̱ ko̱ tsakúya. Yo̱ ta̱ kab'ejña nku nda̱ xi ch'ihi̱n ntsja kixi̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱ kikuntá 'ma Jesu, tu̱ xi sku̱e̱he tsa ts'i̱ínnkihi̱ ndo̱ nga ni̱stjin nkjúu̱n ko̱ b'a̱ ts'ín sa̱kúhu̱ ra̱ má tíndyjajihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tu̱nga behé Jesu ni xi tíi̱ncha ts'ínnkjink'un jóo̱. A̱s'a̱i kinchja̱ko̱ nda̱ xi ch'ihi̱n ntsja: —Ti̱síntje̱i̱n ko̱ ti̱si̱njñai yo̱ kamasee̱n. Tsisintje̱n ndo̱ ko̱ tsasinjña kamasee̱n. ");
INSERT INTO majNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A̱s'a̱i b'i̱ kitsúhu̱ jóo̱: —Nku ni kuasjáíyanu̱u. ¿Mí nihi xi ma n'e nga ni̱stjin nkjúu̱n? ¿A ma n'e ni xi nda, a ra̱ ni xi najmi nda? ¿A ma n'ek'anki xu̱ta̱, a ra̱ ma n'ek'ien? ");
INSERT INTO majNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A̱s'a̱i tsasehe̱ ngayjee̱ já xi kabinchandáíhi̱ ko̱ b'i̱ kitsúhu̱ nda̱ xi ch'ihi̱n ntsja: —Tjentei ntsa̱i̱. B'a̱ kits'ín ndo̱ ko̱ kamanda ntsja. ");
INSERT INTO majNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tu̱nga máha já xu'bo̱, tu̱ ni xí kama kjahán ra̱ ko̱ b'i̱ ngján kinchja̱ni̱jmíyako̱ho xinkjín mí nihi xi ka̱ma ts'i̱íhi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kj'a̱í ni̱stjin ngáha ngji nchja̱ko̱ Nti̱a̱ná Jesu má tíjña nku a̱sunntu tje̱nki̱. Nku ni̱stje̱n kik'aha̱ yo̱ nga kinchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nk'ie nga ja kama ndzjee̱n, kinchja̱ha̱ xu̱ta̱ ni'yakuyáha̱. Te jo maha já xi j'ájin. Já postru̱ kitsúhu̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kui xu'bi já te jo xi j'ájin Jesu: Simon, xi kitsjá j'áíhi̱n nga ta̱ Pedro̱ k'úín, ko̱ Andre, xi nda̱ nts'e̱ Pedro̱ maha, Santiago̱, Jua, Felipe̱, Bartolome, ");
INSERT INTO majNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo̱, Toma, Santiago̱ xi ntíhi̱ Alfeo̱, Simon xi mako̱ já xi mjehe̱ ts'i̱ín nda̱íhi̱ na̱xi̱nantá Israel, ");
INSERT INTO majNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda̱ xi ntíhi̱ Santiago̱, ko̱ Juda̱ Iscariote̱ ya xi a̱skahan kits'ínkjas'en Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A̱s'a̱i nibajenko̱ Jesu jóo̱ ko̱ j'ai sinjña'yún nku a̱nte sunya. Yo̱ kama ñjakú nkjin xu̱ta̱ ni'yakuyáha̱ ko̱ nkjin ṉkjún xu̱ta̱ xi nibaha ngayjee̱ nanki xi tjín a̱nte Judea̱ ko̱ xi tjín a̱ndaihi̱ nanki Jerusalen ko̱ a̱nte xi tiña maha̱ nanki Tiro̱ ko̱ nanki Sidon. Kui xi j'aisínñjuhu̱ Jesu ko̱ tu̱ xi ka̱ma nki yaha̱ ra̱ xi k'uhu̱n ch'in. ");
INSERT INTO majNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ko̱ xu̱ta̱ xi un tíbehe̱ nga tjíntujíhi̱n jánindoo̱ ta̱ kama nda̱íhi̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ngayjee̱ xu̱ta̱ mjehe̱ nga ts'i̱ínko̱ Jesu, a̱t'aha̱ nga'yún xi bitjujíhi̱n. Kui nga'yún xi ts'ínnkiko̱ho̱ ra̱ ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A̱s'a̱i tsasehe̱ Jesu xu̱ta̱ ni'yakuyáha̱ ko̱ b'i̱ kitsúhu̱: —Á b'a̱ nda tjíhin ts'a̱jun xi najmi tjínnu̱u kju̱a̱nchíná xi ka̱ma 'yún k'un, a̱t'aha̱ jun xi tintsu̱ba̱jiun má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Á b'a̱ nda tjíhin ts'a̱jun xi tíma bjoho̱nu̱u nd'a̱i̱, a̱t'aha̱ jun xi k'u̱a̱nki ka̱ma ngáha̱nu̱u. ’Á b'a̱ nda tjíhin ts'a̱jun xi tích'íhinu nd'a̱i̱, a̱t'aha̱ jun xi cha̱jnu̱ ngáhanu. ");
INSERT INTO majNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Á b'a̱ nda tjíhin ts'a̱jun xi ts'i̱ín unkiehe̱nu̱u xu̱ta̱, nk'ie nga najmi sa̱síhi̱n jun xu̱ta̱, nk'ie nga ch'on ku̱i̱tsu̱nu̱u ko̱ nga ku̱i̱nchja̱yanenu̱u xi nkú joyaha tsa jun xi ch'onk'un a̱t'aha̱ Ntíhi̱ Nda̱x'i̱u̱n yjankiu. ");
INSERT INTO majNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tsjo katumanu̱u kui ni̱stjiu̱n ko̱ katsejíhi̱nnu̱u kju̱a̱tsjo, a̱t'aha̱ 'yún tse chjí xi n'e̱kjóho̱on ndji̱o̱jmi ján. A̱t'aha̱ ntje̱ cháha̱ xu̱ta̱ xu'bo̱ b'a̱ ta̱ ch'on kits'íhi̱n já profeta̱ xi kis'e ni̱stjin nk'ie. ");
INSERT INTO majNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Tu̱nga ni̱ma̱ rú n'ehenu xi nchi̱nó, a̱t'aha̱ ja tín'ekjóho̱on kju̱a̱tsjonu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ni̱ma̱ rú n'ehenu xi kitse sisinnu̱u nd'a̱i̱, a̱t'aha̱ ka̱ma bjo ngáha̱nu̱u. ’Ni̱ma̱ rú n'ehenu xi tíchajnu nd'a̱i̱, a̱t'aha̱ k'úé nusin nusinnu̱u ko̱ ch'i̱ú. ");
INSERT INTO majNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Ni̱ma̱ rú n'ehenu nk'ie nga ngatentee̱ xu̱ta̱ nda ts'ín ku̱i̱nchja̱yanenu̱u, a̱t'aha̱ b'a̱ ta̱ nda ts'ín kinchja̱yane ntje̱ cháha̱ xu̱ta̱ xu'bo̱ já profeta̱ tsank'á xi kis'e ni̱stjin nk'ie. ");
INSERT INTO majNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Tu̱nga máha jun xi tíbasinñjúnú, b'a̱ tíxinnu̱u. N'e̱tjó xu̱ta̱ kontra̱nu̱u. Nda n'o̱ho̱ xu̱ta̱ xi unkienu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xi ch'on ku̱i̱tsu̱nu̱u, nda t'ihu̱un. Nk'ie nga chu̱bako̱o Nti̱a̱ná, chu̱bantjo xu̱ta̱ xi ch'on títs'ínnu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tsa tjín xi k'o̱njihin nku tsa̱hi̱, tjeihi̱n ko̱ xinkuu̱. Ko̱ tsa tjín xi kjé'ahi chi̱nkantsja̱hi̱, tjennteihi̱ nga katjiko̱ ko̱ chi̱nkahi̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tu̱ yáhá ni xi ku̱a̱nkihi tsa mí nihi, tjeihi̱n. Ko̱ tsa tjín xi ngju̱a̱i̱ko̱ ni xi ts'i̱, najmi tu̱ ji n'enisihi̱ ri̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xi nkú ts'ín mjenu̱u nga n'e̱nu̱u, b'a̱ ta̱ n'o̱ho̱ xu̱ta̱ xi kj'a̱í. ");
INSERT INTO majNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tsa n'e̱tjó xi tjoho̱ jun, ¿mí kju̱a̱ndaha xi tín'o? Santaha ko̱ xu̱ta̱ ngatitsuu̱n b'a̱ ta̱ ts'ín tjoho̱ xinkjín. ");
INSERT INTO majNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ko̱ tsa nda n'oho̱o xi nda títs'ínnu̱u, ¿mí kju̱a̱ndaha xi tín'o? Santaha ko̱ xu̱ta̱ ngatitsuu̱n b'a̱ ta̱ i̱ncha ts'ín. ");
INSERT INTO majNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ko̱ tsa n'ekienyoho̱o xi behe̱ k'un nga tsjá ngajoya ngáha̱nu̱u, ¿mí kju̱a̱ndaha xi tín'o? Santaha ko̱ xu̱ta̱ ngatitsuu̱n ts'ínkienyaha̱ xinkjín ko̱ kuyá ngajoya ngáha. ");
INSERT INTO majNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","’Tu̱nga máha jun, n'e̱tjó xu̱ta̱ kontra̱nu̱u, n'o̱ho̱ ni xi nda, ko̱ n'e̱kienyo nga najmi tu̱ chuyó tsa k'u̱a̱i̱ ngajoya ngáha̱nu̱u. B'a̱ ts'ín tse chjí n'e̱kjáíhi̱n ru̱u ko̱ ku̱i̱chúmo ntíhi̱ Nti̱a̱ná xi tíjña nk'a ján. A̱t'aha̱ kui xi nda ts'ínko̱ ndaha tsa xi ch'onk'uu̱n ko̱ xi najmi tsjáha̱ máb'a̱chjíhi̱ nga nda tín'eko̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kui nga katuma ni̱ma̱ha̱nu̱u xu̱ta̱ xingisoo̱ xi nkú ts'ín Na̱'minu̱u ma ni̱ma̱ha̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Najmi tu̱ n'ek'anjiu jé xu̱ta̱ xi kj'a̱í. B'a̱ ta̱ ts'ín Nti̱a̱ná najmi ts'i̱ínnijénu̱u. Najmi tu̱ n'oho̱o kju̱a̱ xu̱ta̱ xi kj'a̱í. B'a̱ ta̱ ts'ín Nti̱a̱ná najmi ts'i̱ínnu̱u kju̱a̱. N'e̱ndyjat'o ko̱ Nti̱a̱ná ta̱ ts'i̱ínndyjat'anu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tjon ko̱ Nti̱a̱ná tsjá sisinnu̱u. Ts'i̱íntse susun ko̱ xí k'u̱étsujneyáhá tsanu̱u. Xí ngju̱a̱i̱ ndzjontjáíhí ka̱ma. Chu̱ba̱ xi n'e̱ chjón nga k'u̱o, ta̱ kui xi k'u̱a̱chu̱ba̱ko̱ ngáha̱nu̱u Nti̱a̱ná nga tsjánu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ko̱ b'i̱ ta̱ ts'ín tsakúya Jesu nga y'éjña chu̱ba̱ya: —¿A ka̱mahá ra̱ nku nda̱ ka̱ ku̱a̱kú ni̱yáha̱ kj'a̱í nda̱ ka̱? ¿A najmi ku̱i̱xuntuyáhá nku ti̱xa̱ nga joo̱? ");
INSERT INTO majNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nku nda̱ ni'yakuyá najmi 'yún yankjún sa nga nda̱ maestru̱hu̱. Tu̱nga nga ja kfe̱t'aha̱ ni xi tíbangiya, b'a̱ ta̱ ts'ín ka̱maha̱ xi nkúhu nda̱ maestru̱hu̱. ");
INSERT INTO majNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Nkú ts'ín ji tíchasehe̱ ri̱ stjé xi kjinkihi tunku̱n nda̱ nts'ei nk'ie nga najmi títs'ín ndzjehin yáxu'ba xi kjinki tunkuin? ");
INSERT INTO majNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tsa najmi tíyai yáxu'ba xi kjinki ts'i̱, ¿nkú ts'ín b'a̱ k'úíhi̱n ri̱ nda̱ nts'ei: “Nda̱ nts'é, k'u̱a̱i̱ntení nga k'uasjénkia stjé xi kjinki tunkuin”? Tín'ei ni xi ts'ín xi tu̱ tsjohó ra̱ bakúchji xi nkú ts'ín benkjún Nti̱a̱ná ni xi n'e̱ní ní. N'e̱sje mahi tjun yáxu'ba xi kjinki tunkuin, tu̱ xi nda ka̱ma ndzjehen ri nga n'e̱sjenki stjé xi kjinki tunku̱n nda̱ nts'ei. ");
INSERT INTO majNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Najmi yá tu xi nda bjaha̱ tu xi najmi nda, ko̱ ta̱ ndaha yá tu xi najmi nda bjaha̱ tu xi nda. ");
INSERT INTO majNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tu xi bjaha̱ nga nkúnkú yá tu xi tjín, kui xi bakúchji xi nkú k'un yá tuu̱. A̱t'aha̱ najmi a̱jin na'yóo̱ s'e tu higo̱ ko̱ ta̱ ndaha najmi a̱jin na'yá ntsje̱ s'e tuntsja̱jé. ");
INSERT INTO majNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nku nda̱ xi nda, ni nda xi tíjñajin ani̱ma̱ha̱ b'asje. Nku nda̱ xi ch'onk'un, ni ch'onk'un xi tíjñajin ani̱ma̱ha̱ b'asje. A̱t'aha̱ ni xi kitsejíhin ani̱ma̱ha̱ xu̱ta̱, kui ní nihi xi bitju ts'a. ");
INSERT INTO majNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Á: “Nda̱ maestru̱, nda̱ maestru̱”, tí'mihinú nga najmi tín'ehenu ni xi tíbakuyánu̱u? ");
INSERT INTO majNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Xínyanu̱u yá xi nkú joyaha xi f'aisena ko̱ nt'é énna̱ ko̱ ts'íntjusun. ");
INSERT INTO majNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kui xi b'a̱ joyaha nku nda̱ xi na̱nka̱ tsakján ko̱ na̱xi̱ y'éyanjiko̱ho tuts'in ni'yaha̱ nga kits'ínnda. Nk'ie nga kama 'yún ntáje̱, 'yún j'aik'íéhe̱ ni'yoo̱. Tu̱nga najmi j'ajniyáhá ra̱, a̱t'aha̱ na̱xi̱ kamandasún. ");
INSERT INTO majNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","’Tunga máha xi nt'é énna̱ ko̱ najmi ts'íntjusun, kui xi b'a̱ joyaha nku nda̱ xi tu̱ a̱sun t'anankiu̱hú kits'ínndasún ni'yaha̱ nga najmi y'éyanji. Nk'ie nga 'yún j'aisatéhe̱ ntáje̱ ni'yoo̱, tu̱ tje̱n'yún tsijnehé ko̱ tu̱ xi̱hi̱ ní kis'ejña. ");
INSERT INTO majNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nk'ie nga ja kamaha̱ Jesu nga kinchja̱ko̱ xu̱ta̱, a̱s'a̱i ngji nanki Capernaum. ");
INSERT INTO majNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yo̱ tíjña nku nda̱ jun k'aku̱ Roma̱ xi tíjñaha̱ nku nda̱ musu̱ xi tjo ṉkjúhu̱n, xi kjijña un ko̱ ja ma ku̱a̱yáhá. ");
INSERT INTO majNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nk'ie nga kint'é nda̱ jun k'aku̱ ni xi títs'ín Jesu, kits'ínkjisehe̱ k'u̱a̱ jáchá xi tjíhi̱n xá a̱jihi̱n xu̱ta̱ judio̱, tu̱ xi ku̱a̱nkihi̱ ra̱ Jesu nga kj'u̱a̱í ts'ínnkihi̱ nda̱ musu̱hu̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","A̱s'a̱i i̱ncha j'aisehe̱ Jesu ko̱ tsankintjáí nda̱ juu̱n nga b'a̱ i̱ncha kitsú: —Nda ani̱ma̱ha̱ ndo̱. Machjéhe̱n nga ku̱i̱si̱nko̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","A̱t'aha̱ tjoho̱ xu̱ta̱ná ko̱ santaha nku ni'ya sinagoga̱ kits'ínndani̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","A̱s'a̱i ngjiko̱ Jesu jóo̱. Tu̱nga nk'iehé nga ja i̱ncha tsichu tiña ni'yaha̱ nda̱ juu̱n, k'u̱a̱ já xi nda nchja̱ko̱ho̱ nda̱ juu̱n kits'ínkjisehe̱ Jesu tu̱ xi b'a̱ ku̱i̱tsu̱hu̱ ra̱: —B'i̱ títsuhi nda̱ jun k'aku̱: Ji nda̱ nti̱a̱, najmi tu̱ n'estihi̱ yjohi̱, a̱t'aha̱ najmi an tsuhuna tsa ni'yana̱ ku̱i̱tjás'e̱i̱n. ");
INSERT INTO majNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kui kju̱a̱ha nga ta̱ najmi kama tak'an kjúái̱sehera. Tu̱ b'a̱ ti̱xín ní nga katumanda nda̱ musu̱na̱, ko̱ ka̱manda ndo̱ ma. ");
INSERT INTO majNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","A̱t'aha̱ xi nkúhu an, tíjñana xi batéxumana ko̱ ta̱ tjínna já jun xi batexumaha̱. Nk'ie nga: “T'in”, xihi̱n nku, a̱s'a̱i fi. Ko̱ tsa: “Nibái̱”, xíhi̱n kj'a̱í, a̱s'a̱i nibá. Ko̱ tsa nku nda̱ musu̱na̱: “N'e̱i̱ kui nii̱”, xíhi̱n, a̱s'a̱i ts'ín. ");
INSERT INTO majNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nk'ie nga kint'é Jesu én xi kits'ín nibá nda̱ juu̱n, kama nkjúhu̱n ko̱ kits'ínk'ótjiya nga kinchja̱ko̱ xu̱ta̱ nkjin xi tje̱nko̱: —Kju̱axi̱ ni xi tíxinnu̱u. Ndaha nku xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱ najmi kje̱e sakújinna xi b'i̱ ts'ín s'ejihi̱n an xi nkú ts'ín s'ejihi̱n nda̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nk'ie nga kik'óya ngáha já xi kits'ínkji nda̱ jun k'aku̱, ja nda ngáha nda̱ musu̱ nga i̱ncha j'ai. ");
INSERT INTO majNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nk'ie nga ja kama, a̱s'a̱i ngji Jesu nanki i̱chí xi 'mi Nain nga tje̱nko̱ ts'íhin já ni'yakuyáha̱ ko̱ nkjin ṉkjún xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nk'ie nga ja tsichu tiña Jesu má nga bitjas'e̱he̱n ra̱á nankiu̱, kikie nga ntí nku tutuhu̱ nku ta̱chju̱ún xi ja k'ien x'i̱hi̱n tíi̱ncha fingjáyanji xu̱ta̱. Nkjin ṉkjún xu̱ta̱ na̱nti̱a̱ xi tjín yo̱ xi tje̱nko̱ho̱ ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nk'ie nga kikie Nda̱ Nti̱a̱ná ta̱chjúu̱n, kama ni̱ma̱ha̱ ko̱ b'a̱ kitsúhu̱: —Najmi tu̱ ch'í. ");
INSERT INTO majNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","A̱s'a̱i ngjise tiñaha̱ kaxo̱ ko̱ kits'ínko̱. Tsincha'yún já xi y'anganki kaxo̱. A̱s'a̱i b'i̱ kitsú Jesu: —Nda̱ti, ji tínchjako̱ho. ¡Ti̱síntje̱i̱n! ");
INSERT INTO majNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A̱s'a̱i y'ejña kutu nda̱ xi ja ka'mee̱ kai ko̱ kinchja̱. Kits'ínkjas'en ngáha Jesu ndo̱ a̱ya ntsja na̱aha̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kitsankjún ngayjee̱ xu̱ta̱ ko̱ kits'íntsjoho̱ Nti̱a̱ná nga b'i̱ kitsúhu̱ xinkjín: —Nku nda̱ profeta̱ chánka ja kuitjujinná. Ko̱ b'a̱ ta̱ kitsú ya: —Nti̱a̱ná ja kj'uaisinko̱ xu̱ta̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kinu'yá ni xi kits'ín Jesu ngayjee̱ a̱nte Judea̱ ko̱ ngayjee̱ a̱nte xi tjíndai yo̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jua Bautista̱ ta̱ kint'é ngayjee̱ ni xu'bi̱, a̱t'aha̱ já ni'yakuyáha̱ kitsúyaha̱. A̱s'a̱i kinchja̱ha̱ jo já ni'yakuyáha̱ ");
INSERT INTO majNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ko̱ kits'ínkjisehe̱ Jesu tu̱ xi ngju̱a̱i̱ngjásjaiyaha̱ ra̱ nga b'i̱ ku̱i̱tsu̱hu̱: “¿A ji nda̱ xi tjíhin nga kj'u̱a̱í? ¿A ra̱ chúyahá ri̱ kj'a̱í nda̱ha?” ");
INSERT INTO majNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nk'ie nga j'ai jóo̱ má tíjña Jesu, b'i̱ i̱ncha kitsúhu̱: —Jua Bautista̱ kuats'ín nibáni̱ nga cha̱sjaiyai̱hi̱: “¿A ji rú nda̱ xi tjíhin nga kj'u̱a̱í? ¿A ra̱ chúya rú ri̱ kj'a̱í nda̱ha?” ");
INSERT INTO majNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ta̱ kuihi chu̱bo̱ kits'ínnkihi̱ Jesu nkjin xu̱ta̱ xi k'uhu̱n ch'in, xi un tíbehe̱ ko̱ xi tjíntujíhi̱n jánindoo̱, ko̱ kits'ín nga kama chjihi̱ nkjin xu̱ta̱ ka̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A̱s'a̱i b'a̱ kitsúhu̱ jóo̱: —Tankínk'inyoho̱o Jua ni xi kuayo ko̱ ni xi kuanu'yó e̱i̱. Tíma chjihi̱ xi ka̱ha̱. Xi najmi ma fi tíi̱ncha fi. Xi k'uhu̱n ch'in fentujnu tímanda. Tínt'é xi stayaha̱. Tíf'áíyaha̱ xi ja k'ien. Tís'eni̱jmíhi̱ én nda tsuhu̱ Nti̱a̱ná xi x'a̱ha̱n. ");
INSERT INTO majNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Nda tjín ts'e̱ xi najmi tjín ni xi ts'i̱ínch'oho̱ nga tsjénnkina! ");
INSERT INTO majNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nk'ie nga ja ngji já ni'yakuyáha̱ Jua Bautista̱, a̱s'a̱i b'i̱ kitsú Jesu nga kinchja̱ni̱jmíyaha Jua: —¿Mí nihi xi tsankinsenkjúhu̱un a̱nte kixiu̱? ¿A nku yáxá xi títs'ínk'ajnihi̱ ntjo̱? ");
INSERT INTO majNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tsa najmi, ¿mí nihi xi tsankinsoho̱o? ¿A nku nda̱ xi yja najyun tsjo tjín? Najmi, a̱t'aha̱ xi bja najyun tsjo k'un ko̱ xi nda ts'ín tjíntu, ni'yaha̱ ní já rei̱ tjíntu. ");
INSERT INTO majNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tu̱nga, ¿mí nihi xi tsankinsenkjúhu̱un? ¿A nku nda̱ profeta̱? Joho̱n, kui. An b'a̱ tíxinnu̱u nga kui Jua xi 'yún chánka sa a̱jihi̱n já profeta̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","’Jua tínchja̱ni̱jmíyaha ni xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná: Títs'inkjíá nda̱ chji̱ne̱'énna̱ tu̱ xi ngju̱a̱i̱ títjuhun ri. K'u̱énda títjun ni̱yáhi̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","An b'a̱ tíxinnu̱u. Ndaha nku xu̱ta̱ xi tjín a̱sunntei̱ najmi 'yún chánka sa nga Jua Bautista̱. Tu̱nga xi 'yún i̱chí má batéxuma Nti̱a̱ná, kui xi 'yún chánka sa nga Jua. ");
INSERT INTO majNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ngayjee̱ xu̱ta̱ ko̱ santaha já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱, nk'ie nga kint'é éhe̱n Jesu, b'a̱ i̱ncha kitsú nga na̱xu̱ ts'ín Nti̱a̱ná. A̱t'aha̱ kui xi kits'ín yu nga kisaténtá nk'ie nga tsaténtá Jua xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tu̱nga já fariseo̱hó ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ najmi kisaténtá. B'a̱ ts'ín ta̱ kuihi y'éch'oho̱ ra̱ yjoho̱ ni xi y'énda Nti̱a̱ná nga tsjáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","B'i̱ kitsú ya Jesu: —¿Mí nihi xi k'uejñá chu̱ba̱yako̱hona xi nkú k'un xu̱ta̱ xi tjín nd'a̱i̱? ¿Yá xi b'a̱ joyaha xu̱ta̱ xu'bi̱? ");
INSERT INTO majNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kui xi b'a̱ joyaha já a̱sti xi b'entu ni̱yátée̱ ko̱ kjintáyaha̱ xinkjín nga b'a̱ i̱ncha tsu: “Nk'ie nga kin'ekjanei̱ yána̱xu̱, ¿á najmi kichankihinu? Ko̱ nk'ie nga kisei̱ suu̱n nusin, ¿á najmi kich'íhinu?” ");
INSERT INTO majNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","’A̱t'aha̱ nk'ie nga j'ai Jua Bautista̱, y'ejña kjintíá ko̱ najmi kik'i binu̱. A̱s'a̱i: “Nda̱ninda tíjñajihi̱n”, tsixíún. ");
INSERT INTO majNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A̱skahan j'ai ngá Ntíhi̱ Nda̱x'i̱u̱n xi kjine ko̱ 'bi, ko̱ tu̱ sa b'a̱há bixín ngó: “Kui nda̱i̱ xi 'yún kjine ko̱ 'yún 'bi. Nda nchja̱ko̱ já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ ko̱ já xi najmi na̱xu̱ ts'íntjusun kju̱a̱téxumoo̱.” ");
INSERT INTO majNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tu̱nga tís'ejña chjihí kju̱a̱nkjintak'uhu̱n Nti̱a̱ná nk'ie nga tíyaha̱ ni xi títs'ín. ");
INSERT INTO majNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A̱s'a̱i nku nda̱ fariseo̱ b'a̱ kitsúhu̱ Jesu nga ngju̱a̱i̱ kjineko̱ho̱ ni̱ñu̱. Ngji Jesu ni'yaha̱ ndo̱ ko̱ y'ejñat'a yámixo̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A̱s'a̱i nku ta̱chju̱ún ngatitsun xi ta̱ tíjña nanki xu'bo̱ kint'é nga ni̱ñu̱ tíkjine Jesu ni'yaha̱ nda̱ fariseo̱. A̱s'a̱i j'aiko̱ nku lubata̱ ndji̱o̱ chjí xi tíi̱nchaha̱ ntá sinjne̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tíkjintáhá ts'íhin nga j'aik'iejñat'a tsu̱ku̱ Jesu ko̱ ntánku̱n tsanéjnuko̱ho. A̱s'a̱i ta̱ kuihi ntsja̱ku̱ kits'ínxijnuko̱ho sjai Jesu ko̱ kikjexu̱'ba ko̱ kik'onjnuhu̱ ntá sinjne̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nk'ie nga kikie ni xu'bi̱ nda̱ fariseo̱ xi tsankihi̱ Jesu nga kj'u̱a̱í kjineko̱ho̱ ni̱ñu̱, b'i̱ ts'ín kits'ínnkjink'un: “Tsa kju̱axi̱ nga nku nda̱ profeta̱ nda̱i̱, sku̱e̱ ra̱ yá na̱aha xi títs'ínko̱ho̱ ko̱ mí xu̱ta̱ha niu̱, a̱t'aha̱ ngatitsuhún ts'ín ta̱chjúu̱n.” ");
INSERT INTO majNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A̱s'a̱i b'i̱ kitsú Jesu: —Ji Simon, nku ni mjena xínyaha. B'a̱ kitsú ndo̱: —Chu̱bai, nda̱ maestru̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","B'i̱ kitsú Jesu: —Jo já kitsjehe̱n to̱oho̱n nku nda̱ xi ts'ínkienya to̱on. Nku xi kitsjehe̱n un unchan to̱ontaba ko̱ nku xi kitsjehe̱n cháte. ");
INSERT INTO majNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nk'ie nga najmi be jóo̱ nkú ts'ín k'u̱échjíhi̱ ndo̱ a̱t'aha̱ najmi tjíhi̱n to̱on, a̱s'a̱i kin'endyjat'aha̱ nga joo̱ ni xi tje̱he̱n. Kui nga t'inyahaní, ¿má xi kui já xi joo̱ 'yún tjo saha̱ nda̱ xi ts'ínkienya to̱on? ");
INSERT INTO majNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","B'a̱ kitsú Simon: —Nda̱ xi 'yún tse kin'endyjat'aha̱, xian. B'i̱ kitsú Jesu: —B'a̱ tjín ni xi kuakixín. ");
INSERT INTO majNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","A̱s'a̱i tsase Jesu má síjña ta̱chjúu̱n ko̱ b'a̱ ta̱ kitsúhu̱ Simon: —¿A tíyai ta̱chjíi̱n? An kjúái̱kjas'e̱n ni'yahi̱ ko̱ najmi kuak'a̱i̱ní ntánijua xi kuanejnúhuna tsu̱ká. Tu̱nga máha ta̱chjíi̱n, ntánku̱n kuakanéjnuko̱ho tsu̱ká ko̱ ntsja̱ku̱ kuats'ínxijnuko̱ho. ");
INSERT INTO majNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Najmi kuachjuxu̱'baní tsa kuasuniñaní nk'ie nga kjúa̱ ni'yahi̱, tu̱nga ta̱chjíi̱n santa nkúhu nga kuas'en najmi tíchú maha̱ nga tíkjexu̱'ba tsu̱ká. ");
INSERT INTO majNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Najmi kuich'onjnuihi̱ seti̱ nintaká, tu̱nga ta̱chjíi̱n ntá sinjne̱ kuak'onjnuhu̱ tsu̱ká. ");
INSERT INTO majNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kui nga b'a̱ tíxihin ra. Ja kama ndyjat'aha̱ ngayjee̱ ngatitsun ṉkjún xi tjíhi̱n, a̱t'aha̱ 'yún tse kju̱a̱tjo kuakakúchji. Tu̱nga xu̱ta̱ xi i̱chí n'endyjat'aha̱, kui xi i̱chí kju̱a̱tjo bakúchji. ");
INSERT INTO majNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A̱s'a̱i b'a̱ kitsúhu̱ ta̱chjúu̱n: —Ja kama ndyjat'ahi jéhi̱. ");
INSERT INTO majNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A̱s'a̱i já xi kab'entut'áko̱ho̱ yámixo̱ b'a̱ i̱ncha kitsúhu̱ xinkjín: —¿Yá nda̱ha xu'bi̱ nga santaha ngatitsun maha̱ ra̱ ts'ínndyjat'aha? ");
INSERT INTO majNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesu b'i̱ kitsú yaha̱ ta̱chjúu̱n: —A̱t'aha̱ kuas'ejihin nga Nti̱a̱ná kits'ín nibána, kui nga kuan'ek'ankihi ri. T'inndai ko̱ kas'ehi kju̱a̱jyu. ");
INSERT INTO majNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ja kamoo̱, a̱s'a̱i ngji Jesu nga kikjatsú'ba xki̱ nanki i xi tjín yo̱ ko̱ xi xi̱xi̱hi̱. Y'éni̱jmí ko̱ kitsúya nga Nti̱a̱ná xi batéxuma. Kitsjenko̱ho̱ já postru̱ xi te joo̱ ");
INSERT INTO majNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ko̱ k'u̱a̱ jminchjín xi kits'ínnkihi̱ ko̱ xi kik'onsje jáninda xi tjíntujíhi̱n. Tje̱njihi̱n jminchjíu̱n Maria̱ xi ta̱ 'mi Magdalena̱, xi tsitjujíhi̱n yatu jáninda, ");
INSERT INTO majNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ko̱ Juana̱ chju̱úhu̱n Chuza̱, nda̱ xi ts'ínxát'aha̱ nda̱ rei̱ Herode̱ Antipa̱, ko̱ Susana̱ ko̱ nkjin sa jminchjín xi tsasinko̱ Jesu nga kitsjáha̱ ni xi tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kama ñjakú ṉkjún xu̱ta̱ xi i̱ncha tsitju nankihi̱ nga j'aisehe̱ Jesu. A̱s'a̱i tsakúyaha̱ nga y'éjña chu̱ba̱yaha̱. B'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Nku nda̱ ngjiténdzjo xujmáha̱. Nk'ie nga tíbaténdzjo xujmóo̱, k'u̱a̱ xi tsixuntu a̱ndai ni̱yóo̱. A̱s'a̱i tsisinne ko̱ ni̱see̱ i̱ncha kikjine xujmá xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","K'u̱a̱ xi tsixuntu a̱jin ndji̱o̱. Nk'ie nga jasu, a̱s'a̱i kixí a̱t'aha̱ kindyjat'aha̱ ntánijua. ");
INSERT INTO majNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","K'u̱a̱ ngá xi tsixuntu a̱jin na'yóo̱. Kisá na'yóo̱ ko̱ najmi kitsjántehe̱ nga nda sa̱á xujmá xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tu̱nga k'u̱a̱há ngá xi tsixuntu má nga nda nankiu̱. Kui xi jasu ko̱ tu̱ xí tsehé kitsjá. Nkúnkú xujmóo̱ kitsjá santaha unchan ni̱yá sa. Ko̱ 'yún kinchja̱ Jesu nga b'i̱ kitsú sa: —Xi tje̱n tja̱ba̱xínñju katasínñju. ");
INSERT INTO majNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A̱s'a̱i já ni'yakuyáha̱ i̱ncha kingjásjaiyaha̱ mí nihi xi tsakúya nga y'éjña chu̱ba̱yoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A̱s'a̱i b'i̱ kitsú Jesu: —Jun ja kik'a̱i̱nu̱u nga ka̱mankjinnu̱u ni xi 'ma tíjña ts'e̱ xi nkú ts'ín batéxuma Nti̱a̱ná. Tu̱nga xu̱ta̱ xi k'oo̱ tu̱ s'ejña chu̱ba̱yahá ra̱, tu̱ xi ndaha tsa ku̱a̱se̱he tu̱nga najmi sku̱e̱hé, ko̱ ndaha tsa ku̱a̱sínñju tu̱nga najmi ka̱mankjihín ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’B'i̱ tsuhu̱ ra̱ én xi kuak'iejñá chu̱ba̱ya. Xujmóo̱, kui xi nkú joyaha éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Xujmá xi tsixuntu a̱ndai ni̱yóo̱, kui xu̱ta̱ha xi nt'é ée̱n, a̱s'a̱i nibá nda̱nindoo̱ ko̱ kjexín én xi ja tíjñajin ani̱ma̱ha̱ xu̱ta̱ xu'bo̱ tu̱ xi najmi s'e̱jihi̱n ra̱ ée̱n ko̱ b'a̱ ts'ín najmi n'e̱k'ankihi. ");
INSERT INTO majNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","’Xujmá xi tsixuntu a̱jin ndji̱o̱, kui xu̱ta̱ha xi nt'é ée̱n ko̱ tsjo ts'ín ts'ínkjáíhi̱n tu̱nga najmi 'yúhún tjíhi̱n kja̱ma̱. Kutjuhú s'ejihi̱n Nti̱a̱ná ko̱ nk'ie nga chjut'ayák'un, ts'ín t'axíhi̱n yjoho̱ ée̱n. ");
INSERT INTO majNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","’Xujmá xi tsixuntu ngá a̱jin na'yóo̱, kui xu̱ta̱ha xi nt'é ée̱n tu̱nga ni xi tjíhín a̱sunntee̱ s'enta̱ha̱ ra̱, ko̱ mjehe̱ kju̱a̱nchi̱nóo̱ ko̱ kju̱a̱tsjo xi tjín a̱sunntee̱. B'a̱ ts'ín najmi sakúntehe̱ ra̱ nga nda sa̱áha ée̱n a̱jin ani̱ma̱ha̱ xu̱ta̱ xu'bo̱ ko̱ najmi tsjá cha̱n. ");
INSERT INTO majNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","’Tu̱nga máha xujmá xi tsixuntu nanki xi ndoo̱, kui xu̱ta̱ha xi nda ani̱ma̱ha̱ ko̱ kixi̱ tjíntuyáha̱. Basínñjuhu̱ ée̱n ko̱ b'a̱ joyaha xujmá xi tsjá cha̱n xi nda, a̱t'aha̱ ndjá tíi̱ncha. ");
INSERT INTO majNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Najmi tjín xi b'éti nku nd'í ko̱ a̱s'a̱i b'é'mako̱ho nku ni ko̱ tsa b'éjñanki kinte na̱chan kamo̱. B'éjña nk'a ní, tu̱ xi s'e̱ ndzjehe̱n ra̱ xu̱ta̱ xi kju̱a̱s'ehen a̱yoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","A̱t'aha̱ ngayjee̱ ni xi 'ma tíjña nd'a̱i̱, ku̱i̱chú ni̱stjin nga s'e̱jña chji. Ko̱ ngayjee̱ ni xi najmi tíjña chji nd'a̱i̱, ku̱i̱chú ni̱stjin nga cha̱ ko̱ ku̱i̱tju chji. ");
INSERT INTO majNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kui nga 'yún nda ta̱sinñjuhunu ni xi tínu'yó. A̱t'aha̱ xi mjehe̱ nga ka̱mankjihi̱n, k'u̱a̱i̱ saha̱. Tu̱nga xi najmi ts'i̱ínsihi̱n nga ka̱mankjihi̱n, chjú'aha̱ santaha ni xi títsu nga ka̱mankjihi̱n kai. ");
INSERT INTO majNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A̱s'a̱i na̱aha̱ ko̱ já nts'e̱ Jesu j'aisehe̱, tu̱nga najmi kamahá tsichusehe̱ a̱t'aha̱ katsehe xu̱ta̱ yo̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A̱s'a̱i tjín xi b'a̱ kitsúhu̱ Jesu: —Na̱ahi̱ ko̱ já nts'ei kabincha na̱tsin ján. Mje rúhu̱ sku̱e̱hi. ");
INSERT INTO majNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","B'i̱ kitsú Jesu: —Xi basínñjuhu̱ éhe̱n Nti̱a̱ná ko̱ ts'íntjusun, kui xu̱ta̱ha xi nána̱ ko̱ já nts'é. ");
INSERT INTO majNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nku ni̱yá jas'enko̱ Jesu já ni'yakuyáha̱ nku tsutsu ko̱ b'a̱ kitsú: —Tjián ngabantá xinkuhu̱ ntáchak'uu̱n. A̱s'a̱i i̱ncha ngji. ");
INSERT INTO majNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tu̱nga nk'iehé nga tíi̱ncha f'atikjá ntóo̱, tu̱ kis'efehé Jesu. A̱s'a̱i kamajín ntáchak'uu̱n nku ntjo̱ xi tu̱ xí 'yúhún ko̱ jas'ehe̱n ntánijua tsutsuu̱. B'a̱ kama xi ja ngju̱a̱i̱jinntí yóo̱ kama. ");
INSERT INTO majNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A̱s'a̱i já ni'yakuyóo̱ i̱ncha ngji ts'ínkj'áha̱ Jesu ko̱ b'i̱ kitsúhu̱: —¡Ji nda̱ maestru̱, nda̱ maestru̱! ¡Ja ku̱a̱yáá e̱i̱ ni̱! A̱s'a̱i tsisintje̱n Jesu ko̱ ndjá kinchja̱ko̱ ntjo̱ ko̱ t'éhe̱n ntáchak'uu̱n. Kitsjenjyú ntjo̱ ko̱ kis'e jyujyu. ");
INSERT INTO majNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","B'i̱ kitsúhu̱ já ni'yakuyáha̱: —¿Á najmi s'ejihi̱nnu̱u Nti̱a̱ná? Kitsankjún ko̱ kama nkjúhu̱n jóo̱ ko̱ b'i̱ ngján b'i̱ kitsúhu̱ xinkjín: —¿Yá nda̱ha xu'bi̱ nga santaha ko̱ ntjo̱ ko̱ ntáchak'uu̱n batéxumaha̱ ko̱ nt'é'éhe̱n? ");
INSERT INTO majNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","A̱s'a̱i i̱ncha tsichu nankihi̱ xu̱ta̱ Gerasa̱, nanki xi tíjña ngabantá ntáchak'uu̱n, xi tje̱hen a̱nkjín a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nk'ie nga tsitjujen Jesu tsutsuu̱, a̱s'a̱i j'aik'úhu̱n nku nda̱ xi yo̱ nankihi̱. Nda̱ninda tíjñajihi̱n ndo̱. Kui xi ja nd'a̱i ṉkjún najmi ta̱ bjaha najyun ko̱ ta̱ ndaha najmi b'ejñaya ni'ya. Tu̱ a̱jin tsjóo̱hó b'ejña. ");
INSERT INTO majNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nk'ie nga kikie Jesu, tsasinkúnch'int'aha̱ ko̱ kikjintáya nga b'i̱ kitsúhu̱: —Ji Jesu, Ntíhi̱ Nti̱a̱ nku tutu xi tíjña nk'a ján, ¿mí nihi xi tjínko̱hi an? Tíbankihi nga najmi tu̱ 'ba̱i̱ní kju̱a̱ni̱ma̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","B'a̱ ts'ín kinchja̱ ndo̱, a̱t'aha̱ Jesu b'a̱ kitsúhu̱ nda̱nindoo̱ nga ku̱i̱tjujihi̱n. Ja tu̱ xí nd'a̱i̱hí ko̱ yaha nga tíjñajihi̱n ndo̱ nda̱nindoo̱. Ta̱ nda tsa n'úki̱cha̱ s'e'yúnko̱ho ndo̱. Tu̱ nkú kjeti̱yahá ni xi s'e'yúnko̱ho. A̱s'a̱i nda̱nindoo̱ fiko̱ho̱ má nga najmi ch'a tjín. ");
INSERT INTO majNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","A̱s'a̱i Jesu kingjásjaiyaha̱: —¿Nkú 'mihi? B'a̱ kitsú nda̱nindoo̱: —Legion 'mini̱. B'a̱ kitsú a̱t'aha̱ mii̱hí jánindoo̱ tjíntujíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A̱s'a̱i i̱ncha tsankihi̱ Jesu nga najmi tu̱ ts'i̱ínkjihi̱ a̱nte ch'on chuu̱n má nga un sku̱e̱he̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Xi tje̱hen nku a̱sunntu tje̱nki̱ nkjin ṉkjún chi̱nka̱ tíi̱ncha kjine jñá. A̱s'a̱i jánindoo̱ tsankihi̱ Jesu nga tsjántehe̱ nga ngju̱a̱i̱kjas'enjihi̱n chi̱nko̱, ko̱ kitsjá kju̱a̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","I̱ncha tsitjujíhi̱n ndo̱ jánindoo̱ nga i̱ncha ngjikjas'enjihi̱n chi̱nko̱. Tsangatsanka chi̱nko̱ nga kikjaníkj'antjai yjoho̱ má nk'antjaihi̱ yo̱ ko̱ tsixuntujín ntáchak'uu̱n. Yo̱ jesunjin ntá. ");
INSERT INTO majNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Máha já xi tíi̱ncha kunntá chi̱nko̱, nk'ie nga kikie ni xi kamoo̱, i̱ncha tsanka. Ngji tsúyaha̱ xu̱ta̱ xi tjín a̱jin na̱nti̱o̱ ko̱ a̱ndai na̱nti̱o̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A̱s'a̱i i̱ncha j'aisehe̱ xu̱ta̱ ni xi kamoo̱. J'ai má tíjña Jesu ko̱ kikie nga kab'ejñat'a sjai Jesu nda̱ xi tsitjujíhi̱n jánindoo̱. Ja yja ngáha najyun ko̱ ja nda jeje ngáha. I̱ncha kitsankjún jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Já xi kikie ni xi kamoo̱ i̱ncha kitsúyaha̱ xu̱ta̱ xingisoo̱ xi nkú ts'ín kamandaha nda̱ xi tsitjujíhi̱n jánindoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","A̱s'a̱i ngayjee̱ xu̱ta̱ na̱nti̱a̱ xi tjín nanki Gerasa̱ tsankihi̱ Jesu nga ku̱i̱tju ngáha yo̱, a̱t'aha̱ tu̱ ni xí i̱ncha kitsankjúhún. A̱s'a̱i jas'en Jesu tsutsuu̱ ko̱ kik'óya ngáha. ");
INSERT INTO majNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Máha nda̱ xi tsitjujíhi̱n jánindoo̱, mjehe̱ nga tsjénnkihi̱ Jesu ko̱ tsankihi̱ kju̱a̱. Tu̱nga tsasín ni̱yáhá ra̱ Jesu. B'i̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—T'in ngáhani ni'yahi̱ ko̱ ti̱xínyai ngayjee̱ ni xi kuats'ínko̱hi Nti̱a̱ná. A̱s'a̱i ngji ndo̱ ko̱ kitsúya ngayjee̱ a̱jin na̱nti̱o̱ ngatentee̱ ni xi kits'ínko̱ho̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nk'ie nga ja kik'óya ngáha Jesu ngabantá xinkuu̱, tsjo ts'ín kits'ínkjáíhi̱n xu̱ta̱ nkjiu̱n, a̱t'aha̱ ngatentee̱ tíi̱ncha kuyáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A̱s'a̱i j'ai nku nda̱ xi 'mi Jairo̱ xi ta̱ nku nda̱ k'aku̱hu̱ ni'ya sinagoga̱. Kui xi tsasinkúnch'int'aha̱ Jesu ko̱ tsankihi̱ nga ngju̱a̱i̱ ni'yaha̱, ");
INSERT INTO majNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","a̱t'aha̱ ta̱kjín nku tutuhu̱ xi tjíhi̱n te jo nú ja tí'me. Nk'ie nga tífi Jesu yo̱, i̱xí tíbasinne'yúhún ra̱ xu̱ta̱ nkjin xi tje̱nnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta̱ tje̱njihi̱n xu̱ta̱ nkjiu̱n nku ta̱chju̱ún xi tjíhi̱n te jo nú nga jní títs'ínk'iehe̱n. Já chji̱ne̱nki kits'ínkjehe ngayjee̱ ni xi tjíhi̱n. Ndaha nku najmi kamaha̱ kits'ínnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kui ta̱chjúu̱n xi nibaha a̱stu̱n Jesu ko̱ kits'ínko̱ tuts'in najyuhu̱n. Ta̱ kuihi chu̱bo̱ tje̱n'yún kitikjáyahá ra̱ jníu̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A̱s'a̱i b'a̱há kitsú Jesu: —¿Yá xi kuats'ínko̱na? Tu̱nga ndaha nku najmi kits'ínkie yjoho̱. A̱s'a̱i b'a̱ kitsú Pedro̱: —Ji nda̱ maestru̱, xu̱ta̱ nkjiu̱n tíbasinne'yíhin ko̱ b'i̱ ngján tíi̱ncha tsuniñaihi. ");
INSERT INTO majNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tu̱nga b'i̱hí kitsú Jesu: —Tjín xi kuats'ínko̱na, a̱t'aha̱ ndzjen kamana nga kuitjujin nga'yúnna̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Máha ta̱chjúu̱n, nk'ie nga kikie nga najmi kama tsanka 'ma, a̱s'a̱i i̱xí ts'atsé nkjúhún nga j'aisinkúnch'int'aha̱ Jesu. Nginku̱n ngatentee̱ xu̱ta̱ kitsúya mí kju̱a̱ha nga kits'ínko̱ho najyuhu̱n Jesu ko̱ xi nkú ts'ín ta̱ kuihi chu̱bo̱ kama nkihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","B'i̱ kitsúhu̱ Jesu ta̱chjúu̱n: —Ji ntína̱, a̱t'aha̱ kuas'ejihin nga Nti̱a̱ná kits'ín nibána, kui nga kama nkihi ri. Kas'ehi kju̱a̱jyu nga t'in. ");
INSERT INTO majNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nk'ie nga b'a̱ ta̱ títsuhu Jesu, tu̱ j'aihí nku nda̱ xi nibaha ni'yaha̱ nda̱ k'aku̱hu̱ ni'ya sinagoga̱ ko̱ b'a̱ kitsúhu̱: —Ja k'uen ta̱kjíhi̱n. Najmi ta̱ n'estihi̱ ri̱ nda̱ maestru̱. ");
INSERT INTO majNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tu̱nga nk'ie nga kint'é Jesu niu̱, a̱s'a̱i b'i̱ kitsúhu̱ ndo̱: —Najmi tu̱ binkjuin. Tu̱ nkú kas'ejihín ri an ko̱ ka̱ma nkihi̱ ta̱kjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nk'ie nga tsichu Jesu ni'yaha̱ ndo̱, najmi kitsjánte tsa kj'a̱í xi kju̱a̱s'enko̱ a̱yoo̱, tu̱ Pedro̱ sahá, Jua, Santiago̱, ko̱ na̱'mihi̱ ko̱ na̱aha̱ ta̱kjíu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kui chu̱bo̱ ngayjee̱ xu̱ta̱ xi kama ñjakú yo̱ tíi̱ncha kjintá ko̱ tíi̱ncha ts'ínbat'a ta̱kjíu̱n, tu̱nga b'i̱hí kitsú Jesu: —Najmi tu̱ ch'íú. Najmi ka'me ta̱kjíu̱n. Tu̱ kjifehé. ");
INSERT INTO majNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tsajnukiehe̱ xu̱ta̱, a̱t'aha̱ i̱ncha be nga ja ka'me ta̱kjíu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tu̱nga Jesu jakj'á ntsja ta̱kjíu̱n ko̱ b'i̱ kitsúhu̱: —Ta̱kjín, ti̱síntje̱i̱n. ");
INSERT INTO majNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A̱s'a̱i j'áíya ngáha̱ ra̱ ta̱kjíu̱n ko̱ tje̱n'yún tsisintje̱hén. B'a̱ kitsú Jesu nga k'u̱a̱i̱hi̱ nichine ta̱kjíu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tu̱ ni xí kama nkjúhún ra̱ xi cháha̱ ta̱kjíu̱n, tu̱nga b'a̱há kitsú Jesu nga najmi tu̱ ch'a xi ku̱i̱tsu̱yaha̱ ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kinchja̱ ñjaha̱ Jesu já ni'yakuyá xi te joho̱ ko̱ kitsjáha̱ nga'yún nga ngajoho̱ Jesu ka̱maha̱ jóo̱ k'o̱nsje jáninda xi tjíntujíhi̱n xu̱ta̱ ko̱ nga ts'i̱ínnkihi̱ ch'in xi k'uhu̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kits'ínkji tu̱ xi i̱ncha k'u̱éni̱jmíhi nga Nti̱a̱ná ja tíbatéxuma ko̱ nga ts'i̱ínnkihi̱ xu̱ta̱ xi uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","B'i̱ kitsúhu̱: —Najmi tu̱ chumi nihi xi ch'o nga n'o̱o ni̱yá. Najmi tu̱ ch'o yánise, ta̱ ndaha tsa, ta̱ ndaha ni̱nku̱a̱n, ta̱ ndaha to̱on, ko̱ ta̱ ndaha najmi tu̱ ch'o jo 'yún najyun. ");
INSERT INTO majNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Má ku̱i̱tjás'o̱on nku ni'ya, yo̱ ti̱ntsu̱bo̱o santa nkúhu nga ku̱i̱tju ngáhanu a̱nte xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tsa tjín má najmi n'e̱kjáínnu̱u, tu̱ sahá ti̱tjusjo̱o nanki xu'bo̱ ko̱ t'etsujno ndyjo tsu̱ku, tu̱ xi b'a̱ ts'ín ku̱a̱kúchjihinu nga tje̱he̱n jé xu̱ta̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A̱s'a̱i tsitju jóo̱ nga i̱ncha ngji ngayjee̱ nanki xi tjín yo̱. Y'éni̱jmí én nda tsuhu̱ Nti̱a̱ná ko̱ kits'ínnkihi̱ xu̱ta̱ un xi tjín tu̱ má xi tje̱hén ni. ");
INSERT INTO majNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nda̱ rei̱ Herode̱ Antipa̱ kint'é ngayjee̱ ni xi títs'ín Jesu ko̱ ndaha najmi be nkú ts'ín ts'i̱ínnkjink'un nga̱t'a ts'e̱ yáha Jesu. A̱t'aha̱ tjín xi b'a̱ kitsú nga Jua Bautista̱ xi ja j'áíya ngáha̱ ra̱ ngabayoo̱, ");
INSERT INTO majNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ko̱ tjín ngá xi b'a̱ kitsú nga nda̱ profeta̱ Elia̱ ja j'ai ngáha, ko̱ kj'a̱í ngá xi b'a̱ kitsú nga ja j'áíya ngáha̱ ra̱ ngabayoo̱ nku nda̱ profeta̱ xi y'ejña ni̱stjin nk'ie. ");
INSERT INTO majNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tu̱nga máha Herode̱, b'i̱ kitsú: —An kitsja kju̱a̱ nga kitikjá nintaku̱ Jua. Tu̱nga, ¿yá nda̱ha xu'bi̱ yo̱ ni̱ ma, xi b'i̱ ts'ín tínt'e éhe̱n? Kui nga mjehe̱ ra̱ Herode̱ sku̱e̱he Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nk'ie nga ja kik'óya ngáha já postru̱, i̱ncha kitsúya tentehe̱ Jesu ni xi kits'ín. A̱s'a̱i Jesu ngjiko̱ t'axín suba jóo̱ nku a̱nte má najmi ch'a tjín, xi tiña maha̱ nanki xi 'mi Betsaida̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tu̱nga i̱ncha kikiehé ra̱ xu̱ta̱ ko̱ kitsjennkíhi̱. Jesu nda ts'ín kits'ínkjáíhi̱n xu̱to̱ ko̱ kinchja̱ni̱jmíyaha Nti̱a̱ná, xi nkú ts'ín batéxuma, ko̱ kits'ínnkihi̱ xi uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nk'ie nga ja tíma ngixun, i̱ncha j'aik'úhu̱n já ni'yakuyá xi te joo̱ ko̱ b'a̱ kitsúhu̱: —Tu̱ sahá b'a̱ t'ihi̱n xu̱to̱ nga katji nanki xi tjíndai e̱i̱ nga ts'ínkj'a ni̱stje̱n ko̱ katangisjáí nichine, a̱t'aha̱ a̱nte kixihí e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A̱s'a̱i b'i̱ kitsú Jesu: —Tu̱ sahá jun tjoho̱on ni xi kji̱ne̱ xu̱ta̱. B'a̱ kitsú jóo̱: —Un i̱chí maha ni̱nku̱a̱n xi kich'ai̱ ko̱ jo i̱chí tji̱o̱. ¿A ra̱ kuankín ch'atse níi̱ nichine xi kji̱ne̱ ngayjee̱ xu̱ta̱ nkjiu̱n? ");
INSERT INTO majNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A̱t'aha̱ ma ra̱ un mii̱ já xi kabincha yo̱. Tu̱nga b'i̱hí kitsúhu̱ Jesu já ni'yakuyáha̱: —Nkú ma tsa cháte cháte n'e̱k'a stíún xinkjín xu̱to̱ nga n'e̱k'íéntu. ");
INSERT INTO majNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","B'a̱ i̱ncha kits'ín já ni'yakuyóo̱ ko̱ ngayjee̱ xu̱ta̱ i̱ncha y'entu. ");
INSERT INTO majNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A̱s'a̱i jakj'á Jesu ni̱nku̱a̱n xi uu̱n ko̱ tji̱o̱ xi joo̱. Tsasenjinki nk'a ján nga kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná. Tsakjánya ni̱nku̱o̱n ko̱ kitsjáha̱ já ni'yakuyáha̱ tu̱ xi kui i̱ncha ts'i̱ínndzjo ngáha̱ ra̱ xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ngatentee̱ xu̱to̱ i̱ncha kikjine niu̱ santa nkúhu nga i̱ncha kitse sisihi̱n. A̱s'a̱i j'áíya ni̱nku̱a̱n xi ts'ankiu̱. Te jo ni̱si̱n kamaha. ");
INSERT INTO majNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nku ni̱yá ngjiko̱ t'axín Jesu já ni'yakuyáha̱ ko̱ nk'ie nga tínchja̱ko̱ Nti̱a̱ná, a̱s'a̱i b'i̱ kitsúhu̱ jóo̱: —¿Yá xi títsu xu̱ta̱ nga an? ");
INSERT INTO majNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","B'a̱ kitsú já ni'yakuyóo̱: —Tjín xi b'a̱ tíi̱ncha tsu nga ji xi Jua Bautista̱. Tjín ngá xi b'a̱ tíi̱ncha tsu nga ji xi Elia̱. Ko̱ tjín ngá xi b'a̱ tíi̱ncha tsu nga ja j'áíya ngáha̱ ra̱ ngabayoo̱ nku nda̱ profeta̱ xi y'ejña ni̱stjin nk'ie. ");
INSERT INTO majNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","B'i̱ kitsú Jesu: —Ko̱ jun, ¿yá xi bixíún nga an? A̱s'a̱i b'a̱ kitsú Pedro̱: —Ji xi Cristo̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A̱s'a̱i b'a̱ kitsúhu̱ Jesu jóo̱ nga tu̱ xí najmi ch'ahá xi ku̱i̱tsu̱yaha̱ kui éi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","B'i̱ kitsú ya: —Tjíhin nga un ṉkjún sku̱e̱he̱ Ntíhi̱ Nda̱x'i̱u̱n. Jáchá xi tjíhi̱n xá ko̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ najmi i̱ncha ts'i̱ínkjáíhi̱n. N'e̱k'ien, tu̱nga ni̱stjin xi ma jahan kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A̱s'a̱i kinchja̱ko̱ ngayjee̱ xu̱ta̱ nga b'i̱ kitsúhu̱: —Tsa tjín xi mjehe̱ tsjénnkina, ngayje ni̱stjin kat'éch'o subaha̱ yjoho̱ ni xi mjehe̱ ko̱ katsjáha̱ yjoho̱ nga ku̱a̱yá nga̱t'ana̱, a̱s'a̱i katsjennkína. ");
INSERT INTO majNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","A̱t'aha̱ xi mjehe̱ ts'i̱ínk'anki suba yjoho̱ nga k'úéjña tík'un, kui xi tu̱ sahá ku̱a̱yá. Tu̱nga xi ku̱a̱yá nga̱t'ana̱, kui xi tu̱ sahá n'e̱k'anki. ");
INSERT INTO majNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿A̱t'aha̱ mí xi chjíhi̱ ra̱ tsa ts'i̱ín ngana̱ xu̱ta̱ ngayjee̱ ni xi tjín a̱sunntee̱, tsa tu̱ sa ndyja̱há ngá ani̱ma̱ha̱? ");
INSERT INTO majNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","’Kui nga tsa tjín xi ka̱ma subaha̱ ra̱ an ko̱ énna̱, b'a̱ ta̱ ts'ín ta̱ ka̱ma subaha̱ Ntíhi̱ Nda̱x'i̱u̱n xu̱ta̱ xu'bi̱ ni̱stjin nk'ie nga kj'u̱a̱íko̱ kju̱a̱chánkaha̱ ko̱ kju̱a̱chánkaha̱ Na̱'mihi̱ ko̱ kju̱a̱chánkaha̱ ntítsjehe̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kju̱axi̱ ni xi tíxinnu̱u. K'u̱a̱ xi tíi̱ncha e̱i̱ najmi ku̱a̱yá santa nkúhu nga sku̱e̱ nga batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","A̱skahan nk'ie nga j'a xi nkú ma jin ni̱stjin nk'ie nga b'a̱ kitsú Jesu, a̱s'a̱i kinchja̱ t'axíhi̱n Pedro̱, Jua ko̱ Santiago̱. Ngjinji nku a̱sunntu tje̱nki̱ nga ngji nchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nk'ie nga tínchja̱ko̱ Nti̱a̱ná, tu̱ kik'óntjaiyahá sénni̱stjihi̱n Jesu ko̱ taba xúxú kama najyuhu̱n ko̱ tsat'ai. ");
INSERT INTO majNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ko̱ tu̱ kama chjihí jo já xi tínchja̱ni̱jmíko̱ Jesu, kui xi Moise ko̱ Elia̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Katsendaihi̱ ra̱ kju̱a̱chánkaha̱ Nti̱a̱ná ko̱ tíi̱ncha nchja̱ni̱jmíyaha ngabaya xi a̱s'a̱i sa̱kúhú ra̱ Jesu nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Máha Pedro̱ ko̱ já xi kab'entuko̱ho̱, tu̱ ni xí tíi̱ncha ma nijñáhá ra̱, tu̱nga y'entu tík'uhún ko̱ i̱ncha kikie kju̱a̱chánkaha̱ Jesu ko̱ já xi jo kabinchako̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nk'ie nga ja tíi̱ncha fi t'axín ngáha̱ ra̱ Jesu já xi joo̱, a̱s'a̱i kinchja̱ Pedro̱: —Ji nda̱ maestru̱, ¡á b'a̱ nda tjíhin nga e̱i̱ ku̱i̱ntsu̱ba̱haná! Tu̱ sahá n'e̱ndai̱ jan ni'ya yántsu̱, nku xi ka̱ma ts'i̱ ko̱ nku xi ka̱ma ts'e̱ Moise ko̱ nku xi ka̱ma ts'e̱ Elia̱. B'a̱ kitsú Pedro̱ nga ndaha kui najmi be ni xi kinchja̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nk'ie nga b'a̱ ta̱ títsuhu Pedro̱, tu̱ nkuhú ni̱nti̱ j'ai ts'ínnk'íéhe̱n jóo̱ ko̱ i̱ncha kitsankjún nk'ie nga kitsjennéhe̱ ni̱nti̱u̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kinu'yá a̱jin ni̱nti̱u̱ nku nta̱ xi b'a̱ kitsú: —Kui xu'bi̱ xi Ntína̱ xi j'ajíán. Ta̱sinñjuhu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nk'ie nga ja kinu'yá nto̱, i̱ncha kikie nga síjña suba ngáha Jesu. Najmi kinchja̱ni̱jmíyaha jóo̱ niu̱. Ndaha nku najmi kitsúyaha̱ kui ni̱stjin xu'bo̱ ni xi i̱ncha kikie. ");
INSERT INTO majNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ni̱stjin xi ma ndyjuu̱n, nk'ie nga i̱ncha nibajen ngáha a̱sunntu tje̱nki̱u̱, nkjin ṉkjún xu̱ta̱ j'aikj'á ni̱yáha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A̱s'a̱i 'yún kinchja̱ nku nda̱ xi tje̱njihi̱n xu̱ta̱ nkjiu̱n nga b'a̱ kitsúhu̱ Jesu: —Ji nda̱ maestru̱, tíbankihi nga cha̱se̱i̱hi̱ i̱chí nda̱ chína̱. A̱t'aha̱ ntí nku tutuna̱ maha. ");
INSERT INTO majNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kui xi fas'enjihi̱n nku nda̱ninda ko̱ tje̱n'yún ts'ínkjintáyahá ra̱. B'étsujneyáha̱ ko̱ xú b'asje ts'a. Ja títs'ín'un ṉkjúhu̱n ko̱ tu̱ 'yaha fi t'axíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ja kuakankihi̱ já ni'yakuyáhi̱ nga k'o̱nsje nda̱nindoo̱, tu̱nga najmi kamahá ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A̱s'a̱i b'i̱ kitsú Jesu: —¡Á b'a̱ 'yún i̱chí s'ejihi̱n ra̱ Nti̱a̱ná xu̱ta̱ xi tjíhin nd'a̱i̱ ko̱ ch'onk'uhun! ¿Nkjé kjin tjíhin nga kúáte̱jñajinnu̱u ko̱ ts'in chúkju̱a̱nu̱u? Nibáko̱i̱ nda̱ chíhi̱ e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nk'ie nga ja tífi nda̱ chíu̱ má síjña Jesu, a̱s'a̱i nda̱nindoo̱ kikjaníkj'aha̱ t'anankiu̱ ko̱ tu̱ xí y'étsujneyáhá ra̱. Tu̱nga ndjáhá kinchja̱ko̱ Jesu nda̱nindoo̱. Kits'ín nda̱íhi̱ nda̱ chíu̱ ko̱ kits'ínkjas'en ngáha̱ ra̱ na̱'mihi. ");
INSERT INTO majNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ngayjee̱ xu̱ta̱ tu̱ ni xí kama nkjúhún ra̱ kju̱a̱chánkaha̱ Nti̱a̱ná. Nk'ie nga tíi̱ncha ma nkjúhu̱n ngayjee̱ xu̱ta̱ ni xi títs'ín Jesu, ");
INSERT INTO majNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","a̱s'a̱i b'a̱ kitsúhu̱ já ni'yakuyáha̱: —'Yún nda ta̱sinñju ni xi xínnu̱u. Ntíhi̱ Nda̱x'i̱u̱n n'e̱kjas'en a̱ya ntsja xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tu̱nga najmi kamankjihín ra̱ já ni'yakuyóo̱ én xu'bi̱, a̱t'aha̱ najmi kik'a̱i̱ntehe̱ nga ka̱mankjihi̱n. Najmi kama ya k'un kingjásjaiyaha̱ Jesu nkú tsuhu̱ ra̱ ée̱n. ");
INSERT INTO majNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A̱s'a̱i já ni'yakuyóo̱ kinchja̱ni̱jmíyaha yá xi 'yún nk'a tje̱n a̱jihi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tu̱nga kamankjihín ra̱ Jesu ni xi tínchja̱ ani̱ma̱ha̱ jóo̱. A̱s'a̱i jakj'á nku nda̱ chí, tsasínjñat'aha̱ yjoho ");
INSERT INTO majNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ko̱ b'a̱ kitsú: —Xi ngajona̱ ts'i̱ínkjáíhi̱n ra̱ nda̱ chíi̱, kui xi an títs'ínkjáínna. Ko̱ xi ts'i̱ínkjáínna, kui xi ta̱ títs'ínkjáíhi̱n xi kits'ín nibána. A̱t'aha̱ xi 'yún kinte tje̱n a̱jinnu̱u, kui xi 'yún nk'a tje̱n. ");
INSERT INTO majNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A̱s'a̱i b'a̱ kitsú Jua: —Ji nda̱ maestru̱, kiyai̱ nga nku nda̱ ngajohi̱ tím'osjehe jánindoo̱. Tu̱nga kik'iech'ohó ri̱, a̱t'aha̱ najmi ñá tje̱nko̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi tu̱ jun b'ech'óho̱o. A̱t'aha̱ xi najmi tífi kontra̱ná, kui xi ñá mako̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nk'ie nga ja tsichu tiña ni̱stjin nga tjíhin nga ngju̱a̱i̱nji ngáha Jesu nk'a ján, a̱s'a̱i ngayjehe k'un tsasin ni̱yá nga ngji nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kits'ínkji títjuhu̱n yjoho̱ k'u̱a̱ já xi ts'e̱. Kui xi i̱ncha ngji nku nanki i̱chí xi tíjñajihi̱n a̱nte Samari̱a̱ tu̱ xi k'u̱éndaha̱ ra̱ a̱nte Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tu̱nga xu̱ta̱ Samari̱a̱ xi tjíhín yo̱ najmi kits'ínkjáíhi̱n, a̱t'aha̱ i̱ncha kikie nga tu̱ ni xí mjehé ra̱ Jesu ngju̱a̱i̱ nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nk'ie kikie nii̱ já ni'yakuyá Santiago̱ ko̱ Jua, a̱s'a̱i b'i̱ i̱ncha kitsú: —Ji nda maestru̱, ¿a mjehi nga ku̱i̱nchíi̱ nga ni̱bájen nd'í nk'a ján tu̱ xi ts'i̱ínkjehe xu̱ta̱ xu'bi̱? ");
INSERT INTO majNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tu̱nga ndjáhá kinchja̱ko̱ Jesu jóo̱ nga̱t'aha̱ ni xi i̱ncha kitsú. ");
INSERT INTO majNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","A̱s'a̱i i̱ncha ngji kj'a̱í nanki. ");
INSERT INTO majNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nk'ie nga tíi̱ncha ts'ín ni̱yá, a̱s'a̱i nku nda̱ b'a̱ kitsúhu̱ Jesu: —Tsjénnkihi tu̱ má xi tje̱hén ni nga k'úín. ");
INSERT INTO majNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","B'i̱ kitsú Jesu: —Chu̱ xi tjín ngijñóo̱ tjíhi̱n ti̱xa̱ ngijo ko̱ ni̱see̱ tjíhi̱n nu̱ba̱, tu̱nga Ntíhi̱ Nda̱x'i̱u̱n najmi tjíhi̱n má nga ka̱ma kju̱ájñasun nintaku̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A̱s'a̱i kinchja̱ko̱ kj'a̱í nda̱: —Tsjénnkiní ji. B'a̱ kitsú ndo̱: —Ji nda̱ maestru̱, k'u̱a̱i̱ntení nga tjun kfínngjayánjia na̱'mina̱. ");
INSERT INTO majNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","B'i̱ kitsú Jesu: —T'ejñaihi̱ xu̱ta̱ xi b'a̱ joyaha tsa ja k'ien nga kandjáyanji suba xu̱ta̱ k'ien xinkjín. Tu̱nga máha ji, t'ink'ieni̱jmí nga ja tíbatéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","B'a̱ kitsú ya kj'a̱í nda̱: —Ji nda̱ maestru̱, tsjénnkihi, tu̱nga tjenntehéní nga tjun ma kfín xinyaha̱ xu̱ta̱ xi tjín ni'yana̱ nga ja tífia. ");
INSERT INTO majNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","B'i̱ kitsú Jesu: —Xi mjehe̱ tsénnkina ko̱ a̱s'a̱i ku̱a̱se̱nji a̱stu̱n nga ts'i̱ín ni xi nkaha̱, kui xi najmi tsuhu̱ ra̱ má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","A̱skahan ta̱ j'ájin Nda̱ Nti̱a̱ná cháte ko̱ kan jo já. Jo jo kits'ínk'a xinkjín nga kits'ínkji títjuhu̱n yjoho̱ ngayjee̱ nanki ko̱ a̱nte xi má nga tjíhin nga kj'u̱a̱ a̱skahan. ");
INSERT INTO majNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","B'i̱ kitsúhu̱ jóo̱: —Xu̱ta̱ xi tjín b'a̱ joyaha nkúhu nku ntje̱ chánka, tu̱nga chubahá maha já musu̱ xi ts'i̱ínxájin nii̱. Kui nga ti̱nchíhi̱ ru̱u xi ts'e̱ ntje̱ nga kats'ínkji já musu̱ a̱jin ntje̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tankíún. Títs'inkjínu̱u xi nkú joyaha chu̱tsa̱nka̱ a̱jihi̱n nañá kjan. ");
INSERT INTO majNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Najmi tu̱ ch'o tsa, ko̱ ta̱ ndaha to̱on, ko̱ ta̱ ndaha tja̱ba̱xínnté. Ko̱ najmi tu̱ bincha'yún nga súniñoho̱ xu̱ta̱ a̱ya ni̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","’Nk'ie nga ku̱i̱tjás'o̱on nku ni'ya, tjun súniño. “Kju̱a̱jyu kas'e ni'ya xu'bi̱”, ti̱xíún. ");
INSERT INTO majNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tsa tjíntu yo̱ xu̱ta̱ xi tjíhi̱n kju̱a̱jyu, kju̱a̱jyu xi tí'bo̱o s'e̱jñaha̱. Tu̱nga tsa najmi, k'o̱óyak'un ngáha̱nu̱u kju̱a̱jyu xi tí'bo̱o. ");
INSERT INTO majNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Najmi tu̱ xki̱ ni'ya binimo. Nkuhú ni'ya ti̱ntsu̱bo̱o nga chi̱no̱o ko̱ s'i̱u ni xi k'u̱a̱i̱nu̱u. A̱t'aha̱ já xi ts'ínxá tjíhi̱n kixi̱ nga ka̱ma chjíhi̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’Nk'ie nga ku̱i̱tjás'o̱on nku nanki, tsa nda ts'ín ts'i̱ínkjáínnu̱u xu̱ta̱ xi tjín yo̱, chi̱no̱o ni xi k'u̱éjñat'anu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","N'e̱nkihu̱u xu̱ta̱ un xi tjín yo̱ ko̱: “Ja 'yún tiña tíjñanu̱u Nti̱a̱ná nga tíbatéxumanu̱u nd'a̱i̱”, ti̱xíhu̱un. ");
INSERT INTO majNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tu̱nga tsa ku̱i̱tjás'o̱on nku nanki ko̱ tsa najmi nda ts'ín ts'i̱ínkjáínnu̱u xu̱ta̱ xi tjín yo̱, tankíún a̱jin na̱nti̱o̱ ko̱ b'a̱ ti̱xíún: ");
INSERT INTO majNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Santaha ndyjoho̱ nankinu̱u xi kafajnu tsu̱kui̱ tíb'etsujnei̱. Tu̱nga tjíhín ni nga cho̱o ni xu'bi̱. Ja 'yún tiña tíjñanu̱u Nti̱a̱ná nga tíbatéxumanu̱u nd'a̱i̱”, ti̱xíún. ");
INSERT INTO majNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","An b'a̱ tíxinnu̱u. Nk'ie nga ku̱i̱chú ni̱stjin nga cha̱se̱he̱ ni xi kits'ín nga nkúnkú xu̱ta̱, kui nanki xu'bo̱ xi 'yún un sku̱e̱ saha̱ nga xu̱ta̱ xi kis'e nanki Sodoma̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Ni̱ma̱ rú n'ehenu jun, xu̱ta̱ nanki Corazin! ¡Ni̱ma̱ rú n'ehenu jun, xu̱ta̱ nanki Betsaida̱! A̱t'aha̱ tsa xu̱ta̱ nanki Tiro̱ ko̱ xu̱ta̱ nanki Sidon kikie kju̱a̱nkjún xi kama a̱jinnu̱u, ja ra̱ nd'a̱i ngjikj'áha̱ ra̱ ani̱ma̱ha̱ nga kingja najyun kfe ko̱ y'entujín nasu. ");
INSERT INTO majNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tu̱nga ni̱stjin nga cha̱se̱he̱ mí nihi xi kits'ín nga nkúnkú xu̱ta̱, jun xi 'yún un sku̱e̱ sanu̱u nga xu̱ta̱ xi kis'e nanki Tiro̱ ko̱ nanki Sidon. ");
INSERT INTO majNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","’Ko̱ jun xu̱ta̱ nanki Capernaum, tsa b'a̱ manu̱u nga santaha ndji̱o̱jmi ján cha̱nkjúnnu̱u, najmi. Tu̱ sa ní santaha nga̱k'i̱e̱n kuankínjo̱on. ");
INSERT INTO majNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","A̱s'a̱i b'i̱ kitsúhu̱ Jesu já xi títs'ínkji: —Xu̱ta̱ xi tíbasínñjunu̱u, kui xi an tíbasínñjuna. Xi títs'ín t'axínnu̱u, kui xi an títs'ín t'axínna. Ko̱ xi títs'ín t'axínna, kui xi títs'ín t'axín xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tsjo ṉkjún tíi̱ncha maha̱ já xi cháte ko̱ kan joo̱ nga kik'óya ngáha. B'a̱ i̱ncha kitsú: —Ji nda̱ maestru̱, ngajohi̱ kichubai̱ ko̱ santaha jánindoo̱ kint'é'énni̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A̱s'a̱i b'i̱ kitsú Jesu: —Joho̱n, kikie nga tsijne nda̱nindoo̱ xi nkú joyaha nku nd'ích'o̱n nga nibaha nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","An ja kitsjanu̱u nga'yún xi má nga ku̱i̱sinno ye̱ ko̱ chándayá, ko̱ nga n'e̱ ngano̱ho̱ ngayje nga'yún xi tjíhi̱n nda̱ kontra̱. Najmi tjín ni xi ts'i̱ín'unnu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tu̱nga najmi tu̱ tsjohó manu̱u a̱t'aha̱ tsa jánindoo̱ nt'é'énnu̱u. Tsjo ní katumanu̱u a̱t'aha̱ ja tjíntut'á j'áínnu̱u ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ta̱ kuihi chu̱bo̱ j'aijíhi̱n Jesu kju̱a̱tsjo xi kitsjáha̱ Espiri̱tu̱ Santo̱. B'i̱ kitsú: —An títs'intsjoho, Na̱'mi, Nti̱a̱ xi ts'e̱ nk'a ján ko̱ t'anankiu̱. A̱t'aha̱ y'ejña chjihi̱ xu̱ta̱ xi b'a̱ k'un xi nkú joyaha jántí ni xi kik'iejña 'maihi̱ já nkjink'uu̱n ko̱ já xi mankjihi̱n ni xi tjín. Joho̱n, Na̱'mi, a̱t'aha̱ b'a̱ ts'ín kama tsjohi. ");
INSERT INTO majNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Ngayjee̱ ni xi tjín ja kits'ínkjas'en a̱ya ntsa̱ Na̱'mina̱. Najmi ch'a be yáha ntíu̱, tu̱ nkuhú Na̱'miu̱ xi be. Najmi ch'a be yáha Na̱'miu̱, tu̱ nkuhú Ntíu̱ xi be. Ko̱ xu̱ta̱ xi mjehe̱ Ntíu̱ nga ku̱a̱kúchjihi̱ Na̱'miu̱, kui xi sku̱e̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A̱s'a̱i kits'ínk'ótjiya Jesu nga tsasehe̱ já ni'yakuyáha̱ ko̱ b'i̱ kitsú t'axíhi̱n: —Á b'a̱ nda tjíhin ts'e̱ xi tíbe ni xi tíyo. ");
INSERT INTO majNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","A̱t'aha̱ an b'a̱ tíxinnu̱u nga nkjin já profeta̱ ko̱ já rei̱ xi kis'e ni̱stjin nk'ie i̱ncha kama mjehe̱ nga sku̱e̱ ni xi tíyo nd'a̱i̱, tu̱nga najmi kikiehé. Kama mjehe̱ nga ku̱i̱nt'é ni xi tínu'yó nd'a̱i̱, tu̱nga najmi kint'éhé. ");
INSERT INTO majNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nku ni̱yá nku nda̱ maestru̱hu̱ kju̱a̱téxumoo̱ ngjikjut'ayák'un Jesu. B'a̱ kitsú nga kingjásjaiyaha̱: —Ji nda̱ maestru̱, ¿mí ni xi tjíhin nga ts'ian tu̱ xi sa̱kúhuna nga kúáte̱jña tík'un síán? ");
INSERT INTO majNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","B'i̱ kitsú Jesu: —¿Mí nihi xi tjít'a kju̱a̱téxumoo̱? ¿Nkú n'e n'eyai? ");
INSERT INTO majNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","B'a̱ kitsú ndo̱: —“N'e̱tjóí Nti̱a̱ná xi Nti̱a̱hi̱ maha ngayjee̱ ani̱ma̱hi̱ ko̱ ngayjee̱ nga'yíhi̱n. N'e̱tjóí xi nkú ts'ín tinchin ko̱ xi nkú ts'ín n'enkjíntak'uin. Ko̱ n'e̱tjóí xu̱ta̱hi̱ xi nkú nga ts'ín tjohi yjohi̱.” ");
INSERT INTO majNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","B'i̱ kitsú Jesu: —B'a̱ tjín ni xi kuachubai. B'a̱ n'e̱i̱ ko̱ ku̱i̱nchun tík'uin. ");
INSERT INTO majNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tu̱nga mjehé ra̱ ndo̱ kju̱a̱kúchji nga na̱xu̱ síjña nginku̱n Nti̱a̱ná. Kui nga b'a̱ kitsúhu: —¿Yá xi xu̱ta̱na̱ ma? ");
INSERT INTO majNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A̱s'a̱i b'i̱ kitsú Jesu: —Nku nda̱ tsitju nanki Jerusalen nga tífijen ni̱yá xi fi nanki Jerico ko̱ tu̱ já ndyjéhé kisatéjin. Kui xi kikje'áha̱ santaha najyun xi yja, kik'íéhe̱ nga i̱xí kits'ínk'ienyahá ko̱ i̱ncha ngji jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tu̱ yo̱hó ta̱ nibájen nku nda̱ na̱'mi, tu̱nga nk'iehé nga kikie nda̱ uu̱n, j'at'a ni̱yáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta̱ j'ai a̱nte xu'bo̱ nku nda̱ xi ta̱ ts'ínxát'a ni̱nku̱. Nk'ie nga kikie nda̱ uu̱n, ta̱ j'at'a ni̱yáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","’Tu̱nga nkuhú nda̱ xi nibá Samari̱a̱ xi títs'ín ni̱yá ta̱ j'ai má kjijña nda̱ uu̱n. Nk'ie nga kikie ndo̱, kama ni̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","J'aise tiñaha̱ ko̱ kits'ínnkihi̱ má kama uhu̱n ndo̱. Kik'onjnuhu̱ seti̱ ko̱ binu̱ ko̱ kik'ontikjájnuhu̱ najyun má uhu̱n. A̱s'a̱i ta̱ kuihi chu̱ xi tje̱nko̱ kits'ínk'íésun nda̱ uu̱n. Ngjiko̱ ni'ya má nga ts'ínkj'áíya xu̱ta̱ xi ts'ín ni̱yá ko̱ yo̱ kikuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ni̱stjin xi ma ndyjuu̱n, nk'ie nga ja tífi nda̱ xi nabá Samari̱a̱, ts'asje jo to̱on denari̱o̱ ko̱ kitsjáha̱ nda̱ xi ts'e̱ ni'yoo̱ nga b'a̱ kitsúhu̱: “Cha̱se̱i̱hi̱ i̱chí nda̱i̱. Ngayjee̱ ni xi n'e̱chjén sai, k'uechjíhi nk'ie nga kjúái̱ ngáhana.” ");
INSERT INTO majNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","’Nda tjín. Nk'ie nga nga jaa̱n jái̱ xi kikie nda̱ xi kisatéjin já ndyjée̱, ¿yá xi mahi ji nga xu̱ta̱ha̱ ndo̱ kits'ín ma yjoho? ");
INSERT INTO majNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","B'a̱ kitsú ndo̱: —Nda̱ xi tsase ni̱ma̱ha̱ ndo̱. A̱s'a̱i b'i̱ kitsú Jesu: —T'in, b'a̱ ta̱ n'e̱i̱ ko̱ ji. ");
INSERT INTO majNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","A̱s'a̱i kits'ínndju̱ú ni̱yáha̱ Jesu ko̱ tsichu nku nanki i̱chí. Xi tje̱hen yo̱ nku ta̱chju̱ún xi 'mi Marta̱ kits'ínkjáíhi̱n ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maria̱ 'mi na̱ nichja Marta̱. Kui xi y'ejñat'a sjai Jesu nga tíbasínñjuhu̱ ni xi tínchja̱. ");
INSERT INTO majNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tu̱nga kas'enta̱há ra̱ Marta̱ xá ṉkjún xi títs'ín. A̱s'a̱i j'aik'úhu̱n Jesu ko̱ b'a̱ kitsúhu̱: —Ji chá maestru̱, ¿a najmi nkjún mahi nga ta̱kjín nichja kab'éne subana ngatentee̱ xóo̱? B'a̱ t'ihi̱n nga katasinko̱na. ");
INSERT INTO majNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","B'i̱ kitsú Jesu: —Ji Marta̱, Marta̱, kas'enta̱ha ri ko̱ tífa nusihi̱n yjohi̱ ni ṉkjún xi tín'ei. ");
INSERT INTO majNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tu̱nga nkuhú maha ni xi 'yún machjén. Maria̱ kaf'ájin ni xi ndoo̱ ko̱ najmi ch'a xi kjé'aha̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nku ni̱yá nk'ie nga Jesu tínchja̱ko̱ Nti̱a̱ná, b'a̱ kitsúhu̱ nku nda̱ já ni'yakuyáha̱ nk'ie nga ja kamaha̱ nga kinchja̱ko̱ Nti̱a̱ná: —Ji nda̱ maestru̱, ta̱kúyani̱ xi nkú ts'ín tjíhin nga chu̱baka̱á Nti̱a̱ná, xi nkú ts'ín ta̱ Jua tsakúyaha̱ já ni'yakuyáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","B'i̱ kitsú Jesu: —Nk'ie nga chu̱bako̱o Nti̱a̱ná, b'i̱ ti̱xíún: Ji Na̱'mini̱ xi tinchin ndji̱o̱jmi ján, katenkjúhin xu̱ta̱. Ta̱texumani̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tjenni̱ nd'a̱i̱ nichine xi machjénni̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","N'e̱ndyjat'ani̱ ngatitsunni̱, xi nkú ts'ín ji̱n ta̱ n'endyjat'ai̱hi̱ xi ch'on ts'ínni̱. Najmi tu̱ 'ba̱i̱ntei nga ku̱i̱jne̱jii̱n nga chjút'ayák'unni̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","B'i̱ ta̱ kitsú ya Jesu: —K'úéjñaha̱ ra̱á tsa tjín xi tíjñaha̱ nku nda̱ amigo̱ xi ku̱i̱chúsehe̱ masen ni̱stje̱n nga b'a̱ ku̱i̱tsu̱hu̱: “Ji nda̱, n'e̱k'ieyaní i̱chí ni xi ts'inkjén xi kj'uaisena. ");
INSERT INTO majNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","A̱t'aha̱ nku nda̱ amigo̱na̱ kj'uaisena xi kjin kanibáha ko̱ najmi tjínna ni xi tsjaha̱.” ");
INSERT INTO majNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tsa b'a̱ ts'i̱ín, nda̱ xinkuu̱ xi tíjña a̱ya ján najmi b'a̱ ku̱i̱tsu̱hu̱: “Najmi tu̱ n'estiní. Ja tjíchja a̱nkju̱o̱ ko̱ ntína̱ ja kjintusúnko̱na kamo̱. Najmi ta̱ ma bisíntje̱henna nga tsjaha ni xi tíbinchi.” ");
INSERT INTO majNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","An b'a̱ tíxinnu̱u. Ndaha tsa najmi ku̱i̱síntje̱n nga tsjáha̱ ni xi tíbanki ndo̱ a̱t'aha̱ nda̱ amigo̱ho̱ maha, tu̱nga ku̱i̱síntje̱hén a̱t'aha̱ kju̱a̱sti títsjá ndo̱ ko̱ tsjáha̱ ngayjee̱ ni xi machjéhe̱n. ");
INSERT INTO majNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Ko̱ an b'a̱ ta̱ tíxinnu̱u. Ti̱nchíú, ko̱ Nti̱a̱ná tsjánu̱u. Ti̱nchísjo, ko̱ sa̱kúnu̱u. N'e̱kjano a̱nkju̱o̱, ko̱ chjúx'ánu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","A̱t'aha̱ ngatentee̱ xi banki ts'ínkjáíhi̱n. Xi bangisjai sakúhu̱. Ko̱ xi ts'ínkjane a̱nkju̱o̱ chjux'áha̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿A tjín a̱jinnu̱u xi tí'mi na̱'mi xi tu̱ ye̱hé tsjáha̱ ntíhi nk'ie nga tji̱o̱ ku̱a̱nkihi̱? ");
INSERT INTO majNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tsa chj'o̱ó ku̱a̱nki ntíhi̱, ¿a tu̱ chándayáhá tsjáha̱? ");
INSERT INTO majNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Santaha ko̱ jun xi ch'onk'un yo nga 'bo̱ho̱o ni xi nda ntínu̱u. ¿A najmi tu̱ sahá Na̱'minu̱u xi tíjña ndji̱o̱jmi ján 'yún tsjá saha̱ Espiri̱tu̱ Santo̱ xu̱ta̱ xi ku̱a̱nkihi̱? ");
INSERT INTO majNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nk'ie nga tím'osje Jesu nku nda̱ninda xi kits'ín ni̱ma̱'aha̱ nku nda̱, a̱skahan nga tsitju nda̱nindoo̱, kama kinchja̱ ndo̱. Tu̱ ni xí kama nkjúhún ra̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tu̱nga tjíhín xi b'a̱ i̱ncha kitsú: —Nga'yúhu̱n nda̱ninda Beelzebu xi nda̱ k'aku̱hu̱ jánindoo̱ tím'osjeko̱ho nda̱i̱ jánindoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tjín ngá xi kikjut'ayák'un Jesu ko̱ tsankihi̱ nga ts'i̱ín nku kju̱a̱nkjún xi ku̱a̱kúchji nga Nti̱a̱ná kits'ín nibáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tu̱nga behé Jesu ni xi títs'ínnkjink'un jóo̱, kui nga b'a̱ kitsúhu̱ ra̱: —Tsa xu̱ta̱ xi tjíntu má batéxuma nku nda̱ rei̱ ta̱ kuihi fi kontra̱ha̱ xinkjín, ta̱ kuihi i̱ncha ngju̱á tiya nankihi̱. Ndzjoya xi nkuhú ni'ya tjíntu tsa ts'ínstiko̱ xinkjín. ");
INSERT INTO majNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","B'a̱ ta̱ ts'ín tíjña ts'e̱ nda̱nindoo̱. Tsa Satana ta̱ kuihi ngju̱a̱i̱ kontra̱ subaha̱ yjoho̱, ¿nkú ts'ín tse ku̱i̱chúkju̱a̱ha̱ ra̱ nga ku̱a̱téxuma? B'a̱ tíxian a̱t'aha̱ b'a̱ tíbixíún nga nga'yúhu̱n nda̱ninda Beelzebu tím'osjéko̱hona jánindoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ko̱ tsa nga'yúhu̱n nda̱ninda Beelzebu tím'osjéko̱hona jánindoo̱, tíbixíún, ¿yá xi ts'e̱ nga'yún xi m'osjeko̱ho jánindoo̱ já ts'a̱jun? B'a̱ ts'ín ta̱ kuihi jóo̱ bakúchji nga najmi na̱xu̱ tjíntuyánu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tu̱nga tsa nga'yúhu̱n Nti̱a̱ná tím'osjéko̱hona jánindoo̱, kui xi tsuhu̱ ra̱ nk'ie nga ja j'ai ni̱stjin nga ja tíbatéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Nk'ie nga nku nda̱ xi 'yún tjíhi̱n nga'yún tjíndaha̱ yjoho̱ nga kja̱án ko̱ tíkunntá ni'yaha̱, najmi ch'a xi ka̱ma ts'i̱ínko̱ ni xi tjíntuhu̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tu̱nga tsa f'ai nku xi 'yún tjín saha̱ nga'yún nga kui, ts'i̱ín ngana̱ha̱ ko̱ kje'áha̱ ngayjee̱ ni xi ts'ínchjén nga kján. A̱s'a̱i bakj'á ni xi tjíntu a̱yoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Xi najmi an mako̱na, kui xi xu̱ta̱ kontra̱na̱. Xi najmi tíf'áyako̱na, kui xi tíbaténdzjo. ");
INSERT INTO majNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Nk'ie nga nku nda̱ninda bitjujíhi̱n nku nda̱, fatsú'basún a̱nte kixiu̱ nga bangisjai má nga ts'i̱ínkj'áíya. Nk'ie nga najmi sakúhu̱ a̱nte, a̱s'a̱i b'a̱ tsu: “Tu̱ sahá kfin ngáhana ni'yana̱ má tsitja.” ");
INSERT INTO majNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nk'ie nga b'óya ngáha, ja kichjuchá ko̱ ja tjínda ni'yoo̱ nga f'aise ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","A̱s'a̱i fikj'á sa yatu jáninda xi 'yún ch'onk'un sa nga kui ko̱ ngatentee̱ i̱ncha fas'enjihi̱n ndo̱. Ko̱ máha nda̱ xu'bo̱, 'yún ch'on ts'ín b'ejña a̱skahan nk'ie nga tjuhun. ");
INSERT INTO majNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nk'ie nga b'a̱ títsu Jesu, a̱s'a̱i kikjintáya nku ta̱chju̱ún xi síjñajihi̱n xu̱ta̱ nkjiu̱n: —¡Á b'a̱ nda tjíhin ts'e̱ ta̱chju̱ún xi kitsihi̱n ji ko̱ kits'íncháha ri! ");
INSERT INTO majNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","B'i̱ kitsú Jesu: —¡Á ní b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi basínñjuhu̱ ra̱ éhe̱n Nti̱a̱ná ko̱ ts'íntjusun! ");
INSERT INTO majNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nk'ie nga ja kama ñjakú ṉkjún sa xu̱ta̱, a̱s'a̱i b'i̱ kitsú Jesu: —Ch'onk'un xu̱ta̱ xi tjín nd'a̱i̱. Kju̱a̱nkjún i̱ncha mjehe̱ sku̱e̱, tu̱nga najmi sa̱kúhú ra̱ kju̱a̱nkjún. Tu̱ ni xi kamat'aihín nda̱ profeta̱ Jona nk'ie, tu̱ kuihí kju̱a̱nkjún xi s'e̱jña chjihi̱ xu̱ta̱ xi tjín nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","A̱t'aha̱ xi nkú ts'ín kits'ínchjén Nti̱a̱ná Jona nga kitsjáha̱ éhe̱n xu̱ta̱ nanki Nini̱ve̱, b'a̱ ta̱ ts'ín ts'i̱ínchjén Ntíhi̱ Nda̱x'i̱u̱n nga tsjáha̱ éhe̱n xu̱ta̱ xi tjín nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","’Na̱rei̱na̱ xi tsatéxuma nanki Saba ku̱i̱síntje̱nko̱ xu̱ta̱ xi tjín nd'a̱i̱ nk'ie nga ku̱i̱chú ni̱stjin nga cha̱se̱he̱ ni xi kits'ín nga nkúnkú xu̱ta̱. Kui xi ts'i̱ínko̱kju̱a̱ha̱ xu̱ta̱ xi tjín nd'a̱i̱, a̱t'aha̱ kui xi 'yún kjin nibaha nga j'aisínñjuhu̱ kju̱a̱nkjink'uhu̱n Salomon. Nd'a̱i̱ bi, e̱i̱ tíjña nku xi 'yún nk'a tje̱n sa nga Salomon. ");
INSERT INTO majNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ko̱ xu̱ta̱ xi y'entu nanki Nini̱ve̱ ku̱i̱síntje̱nko̱ xu̱ta̱ xi tjín nd'a̱i̱ nk'ie nga ku̱i̱chú ni̱stjin nga cha̱se̱he̱ ni xi kits'ín nga nkúnkú xu̱ta̱. Kui xi ts'i̱ínko̱kju̱a̱ha̱ xu̱ta̱ xi tjín nd'a̱i̱, a̱t'aha̱ kui xi ngjikj'áha̱ ra̱ ani̱ma̱ha̱ nk'ie nga Jona y'éni̱jmíhi̱ éhe̱n Nti̱a̱ná. Nd'a̱i̱ bi, e̱i̱ tíjña nku xi 'yún nk'a tje̱n sa nga Jona. ");
INSERT INTO majNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Najmi tjín xi b'éti nku nd'í ko̱ a̱s'a̱i b'éjña 'ma ko̱ tsa b'éjñanki kintehe̱ nku kaxa̱. B'éjña nk'a ní tu̱ xi s'e̱ ndzjehe̱n ra̱ xu̱ta̱ xi kju̱a̱s'ehen a̱yoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tunkuin, kui xi nkú joyaha nku nd'í xi ts'ín ndzjehe̱n yjonintehi̱. Tsa tunkuin fas'en ni xi nda, ngayjee̱ yjonintehi̱ s'e ndzjehe̱n. Tu̱nga tsa ni xi najmi nda fas'en tunkuin, ngayjee̱ yjonintehi̱ s'e jyuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chíhi̱n nga najmi tu̱ ka̱ma jyun nd'í nda xi tíjñajihin. ");
INSERT INTO majNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tsa ngayjee̱ yjonintehi̱ tjíhi̱n nd'í ko̱ tsa najmi tjín má jyunt'aha̱, ka̱ma ndzjen sisihin xi nkú joyaha tsa tíbat'ai nku nd'í xi títs'ín ndzjehin. ");
INSERT INTO majNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nk'ie nga ja kamaha̱ Jesu nga kinchja̱, a̱s'a̱i nku nda̱ fariseo̱ tsankihi̱ nga ngju̱a̱i̱ kjineko̱ho̱ ni̱ñu̱ ni'yaha̱. Kui nga jas'ehen Jesu ni'yaha̱ ndo̱ ko̱ y'ejñat'a yámixo̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kama nkjúhu̱n nda̱ fariseo̱ nk'ie nga kikie nga najmi tsanéjnu ntsja Jesu kintehe̱ ni nga kikjine ni̱ñu̱ xi nkú ts'ín tíjñaha̱ sinchóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A̱s'a̱i b'i̱ kitsú Jesu nga kinchja̱ko̱ nda̱ fariseo̱: —Jun xi 'minu̱u já fariseo̱, jun xi nkú joyaha tasa̱ ko̱ ta̱ba̱ xi tu̱ na̱tsihi̱n kin'echuhún ra̱, tu̱nga kitsejíhín kju̱a̱nkjintak'unnu̱u kju̱a̱ndyjé ko̱ kju̱a̱ch'onk'un. ");
INSERT INTO majNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Jun já chi̱ni! Nti̱a̱ná kits'ínnda na̱tsiu̱n ko̱ ta̱ kits'ínnda a̱yoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tu̱ sa ní ni xi tjínnu̱u, yo̱ tjehe̱n ru̱u xu̱ta̱ x'a̱n to̱on chje̱. B'a̱ ts'ín je ka̱mahanu ma nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ni̱ma̱ rú n'ehenu jun, já fariseo̱! 'Bo̱ho̱ Nti̱a̱ná nku tíkjá na̱jún chi̱nko̱ ko̱ xka̱ ruda̱ ko̱ ngayjee̱ xka̱ sinjne̱ xi nkú nga ts'ín tjít'a kju̱a̱téxumoo̱, tu̱nga n'echayanú ni xi na̱xu̱ nginku̱n Nti̱aná ko̱ kju̱a̱tjoho̱ Nti̱a̱ná. Kuihí ni xu'bi̱ xi tjíhin nga n'o̱o, ko̱ najmi tjíhin nga n'e̱chayo nga n'o̱o ni xingisoo̱ xi tjít'a. ");
INSERT INTO majNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ni̱ma̱ rú n'ehenu jun, já fariseo̱! A̱t'aha̱ n'e mjo nga ku̱i̱ntsu̱ba̱sun yáxile̱ xi tíi̱ncha títjun a̱ya ni'ya sinagoga̱ ko̱ nga tsjo ts'ín súniñanu̱u ni̱yátée̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ni̱ma̱ rú n'ehenu, já maestru̱hu̱ kju̱a̱téxumoo̱ ko̱ já fariseo̱! ¡A̱t'aha̱ tu̱ tsjohónu̱u bakuchíú xi nkú ts'ín yankjún Nti̱a̱ná! Xi nkú joyaha tsjó xi najmi kjintu chji jun, xi b'emasún xu̱ta̱ nga ndaha najmi be. ");
INSERT INTO majNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A̱s'a̱i b'a̱ kitsú nku nda̱ maestru̱hu̱ kju̱a̱téxumoo̱: —Ji nda̱ maestru̱, nk'ie nga b'a̱ tíbixín, ko̱ ji̱n ta̱ ch'on tí'mini̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","B'i̱ kitsú Jesu: —¡Ni̱ma̱ rú n'ehenu ko̱ jun, já maestru̱hu̱ kju̱a̱téxumoo̱! A̱t'aha̱ ch'á xi najmi chúkju̱a̱ha̱ xu̱ta̱ n'ek'anjiu, tu̱nga máha jun, ndaha̱chí najmi i̱ncha n'o nga'yún nga n'etjusun niu̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ni̱ma̱ rú n'ehenu! A̱t'aha̱ n'endo tsjóho̱ já profeta̱ xi kits'ínk'ien ntje̱ chánu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","B'a̱ ts'ín bakuchjí kixi̱hinu nga tjínkuhu̱ k'un ni xi kits'ín ntje̱ chánu̱u. A̱t'aha̱ kui xi i̱ncha kits'ínk'ien já profeta̱ ko̱ jun n'endoho̱o tsjó. ");
INSERT INTO majNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Kui nga b'a̱ kitsúhu Nti̱a̱ná xi be tu̱ mí nihí ni: “Ts'inkjísehe̱ já profeta̱ ko̱ já postru̱ xu̱ta̱ xu'bo̱. K'u̱a̱ xi ts'i̱ínk'ien ko̱ k'u̱a̱ xi tsjénnki unkie.” ");
INSERT INTO majNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","B'a̱ ts'ín n'e̱nijéhe̱ ra̱ xu̱ta̱ xi tjín nd'a̱i̱ jní xi tsaténdzjo ngayjee̱ já profeta̱ santa nkúhu nga kamanda a̱sunntee̱ ko̱ santaha nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ch'a̱tuts'i̱hi̱n ra̱ jníhi̱ Abel santaha jníhi̱ Zacaria̱ xi kin'ek'ient'á na̱chan chje̱ xi kjijña a̱nkjín ni̱nku̱. Kui nga b'a̱ tíxihi̱nnu̱u nga n'e̱nijéhe̱ ra̱ xu̱ta̱ xi tjín nd'a̱i̱ ngayjee̱ ni xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ni̱ma̱ rú n'ehenu jun, já maestru̱hu̱ kju̱a̱téxumoo̱! Ja kichju'óho̱o xu̱ta̱ yubi̱ xi bix'áko̱ho a̱nkju̱a̱ má nga tíjña kju̱a̱nkjink'uu̱n. Jun najmi bitjas'o̱on ko̱ ta̱ b'ech'óho̱o xu̱ta̱ xi mjehe̱ kju̱a̱s'en yo̱. ");
INSERT INTO majNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nk'ie nga b'a̱ kitsú Jesu, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱ tu̱ ni xí najmi kisasíhín ra̱ ni xi kitsú Jesu. Kui nga nkjin tíkjá ni xi kingjásjaiyaha̱ ra̱ ");
INSERT INTO majNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tu̱ xi ts'i̱ínkijnejihin Jesu nga ku̱i̱nchja̱ nku én xi najmi b'a̱ tjín. I̱ncha tsangisjai ni̱yá xi nkú ts'ín ka̱ma kju̱a̱téjénehe. ");
INSERT INTO majNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tu̱ ni xí kama ñjakú ṉkjúhún xu̱ta̱ nga ta̱ kui ta̱ maha tíi̱ncha basinne'yún xinkjín. A̱s'a̱i já ni'yakuyáha̱ Jesu kinchja̱ko̱ títjun: —Chúhu̱un yjonu̱u xi nkú ts'ín nkaha̱ já fariseo̱. Kui xi bakúchji nga 'yún benkjún Nti̱a̱ná tu̱ xi b'a̱ ts'ín b'é'maha ni ch'onk'un xi tjíntujíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A̱t'aha̱ najmi tjín ni xi 'ma tjítjo xi najmi cha̱, ko̱ najmi tjín ni xi tíjña 'ma xi najmi s'e̱jña chji. ");
INSERT INTO majNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kui b'a̱ maha, ngayjee̱ ni xi kichubahanu má jyuu̱n, kui xi ku̱i̱nú'yá ngáha má ndzjee̱n. Ko̱ én se̱n xi kik'inyoho̱o xinki̱u a̱ya 'manu̱u, kui xi ch'i̱íyako̱ ngáha a̱sun nk'a ni'yoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Jun, já amigo̱na̱, b'a̱ tíxinnu̱u. Najmi tu̱ binkjun xi tu̱ yjonintee̱hé maha̱ ts'ínk'ien ko̱ a̱skahan najmi ta̱ tjín nkú ts'i̱ín saha. ");
INSERT INTO majNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Xínyanu̱u yá xi tjíhin nga ku̱i̱nkjún. Ti̱nkjún xi a̱skahan nga ts'i̱ínk'ien yjonintee̱, tjíhi̱n nga'yún nga ts'i̱ínkji nga̱k'i̱e̱n. Joho̱n, kuihí xu'bo̱ xi ti̱nkjún. ");
INSERT INTO majNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿A najmi mahá tsa tu̱ xí nanki chjíhí ch'a nga satéña un ni̱se xi̱ tíntí? Ndaha tsa b'a̱ ma, tu̱nga najmi ts'ínchayahá Nti̱a̱ná ndaha nku ni̱see̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nga̱t'a ts'a̱jun bi, santaha ngayjee̱ ntsja̱ku tjín xki̱hi̱ Na̱'minu̱u. Kui kju̱a̱ha nga najmi tu̱ binkjuhunnu, a̱t'aha̱ jun xi 'yún chjí so nga nkjin ni̱se. ");
INSERT INTO majNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ko̱ b'a̱ tíxinnu̱u. Ngayjee̱ xi ts'i̱ínkie yjoho̱ nga bena nginku̱n xu̱ta̱, Ntíhi̱ Nda̱x'i̱u̱n ta̱ ts'i̱ínkie yjoho̱ nga be xu̱to̱ nginku̱n ntítsjehe̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tu̱nga xi najmi ts'i̱ínkie yjoho̱ nga bena nginku̱n xu̱ta̱, ko̱ an ta̱ najmi ts'inkíé yjona̱ nga be xu̱to̱ nginku̱n ntítsjehe̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ko̱ ngayjee̱ xu̱ta̱ xi nkú ku̱i̱tsu̱hu̱ Ntíhi̱ Nda̱x'i̱u̱n, ka̱ma ndyjat'aha̱. Tu̱nga xi ch'on ku̱i̱tsu̱hu̱ Espiri̱tu̱ Santo̱, najmi ta̱ ka̱ma ndyjat'aha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nk'ie nga ngju̱a̱i̱ko̱nu̱u xu̱ta̱ ni'ya sinagoga̱ ko̱ tsa nginku̱n já jue ko̱ tsa nginku̱n já tjíxóo̱, najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u xi nkú ts'ín n'ek'óyo ni xi k'úínnu̱u ko̱ mí éhen xi ku̱i̱xíún. ");
INSERT INTO majNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","A̱t'aha̱ kui chu̱ba̱ xu'bo̱ Espiri̱tu̱ Santo̱ ku̱i̱tsu̱yanu̱u mí ni xi tjíhin nga ku̱i̱xíún. ");
INSERT INTO majNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A̱s'a̱i kinchja̱ nku nda̱ xi síjñajihi̱n xu̱ta̱ nkjiu̱n: —Ji nda̱ maestru̱, b'a̱ t'ihi̱n nda̱ nts'é nga katakjányako̱na ni xi y'éjña na̱'mini̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","B'i̱ kitsú Jesu: —Ji nda̱, ¿yá xi y'ét'a xána nga nda̱ jue ka̱manu̱u ko̱ a ra̱ nku nda̱ xi ku̱a̱kjánya ni xi tjíhi̱n xu̱ta̱? ");
INSERT INTO majNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","B'i̱ kitsú sa Jesu nga kinchja̱ko̱ xu̱ta̱ xi kabincha yo̱: —Cha̱so̱o ko̱ chúhu̱un yjonu̱u. Najmi tu̱ n'e mjo ni xi tjíhi̱n xu̱ta̱ xingisoo̱. Najmi tsa tu̱ nga̱t'aha̱ nga tse ni xi tjíhi̱n xu̱ta̱ nga 'yún nda ts'ín k'úéntu. ");
INSERT INTO majNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A̱s'a̱i y'éjña chu̱ba̱ya Jesu nga tsakúya: —Jñáha̱ nku nda̱ nchi̱ná tu̱ ni xí ndahá kitsjá nintje̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A̱s'a̱i b'i̱ kitsú ani̱ma̱ha̱: “¿Mí nihi xi ts'ian? Najmi tjínna má k'uetjá ni xi kama chána.” ");
INSERT INTO majNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ko̱ b'a̱ kitsú ya ani̱ma̱ha̱: “Kui nii̱ xi ts'ian. Ts'inxúnta ni'ya xi tíi̱nchana má nga f'atjá ni xi kama chána ko̱ kj'a̱í xi 'yún i sa ts'inndá ngáhana. Yo̱ kj'uatjá niu̱ ko̱ ngayjee̱ ni xi tjínna. ");
INSERT INTO majNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A̱s'a̱i b'a̱ xíhi̱n yjona̱: Ji nda̱, nkjin ṉkjún maha ni xi tjítjohi. 'Yún nkjin nú ka̱maha̱. Tu̱ sahá n'e̱kj'áíyai, chi̱ne̱i, s'i̱ ko̱ tsjo kat'ehi.” ");
INSERT INTO majNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tu̱nga b'a̱há kitsú Nti̱a̱ná: “Ji nda̱ chi̱ni, kui ni̱stje̱n xu'bi̱ ku̱a̱yáí. Ni xi tjítjohi, ¿yá xi ka̱ma ts'e̱?” ");
INSERT INTO majNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","’B'a̱ mat'ain xu̱ta̱ xi b'ékúhu̱ yjoho̱ kju̱a̱nchi̱ná. Kui xi x'a̱n nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","A̱s'a̱i b'a̱ kitsúhu̱ já ni'yakuyáha̱: —Kui kju̱a̱ha nga b'a̱ tíxihi̱nnu̱u. Najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u ni xi machjénnu̱u, mí nihi xi chi̱no̱o. Ta̱ ndaha najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u ni xi machjéhe̱n yjonintenu̱u, mí najyuhun xi ndyjo̱o. ");
INSERT INTO majNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nk'ie ní nga ku̱i̱ntsu̱bo̱o, kui ní nihi xi 'yún chjíhi̱ ra̱ nga nichinee̱, ko̱ yjonintenu̱u, kui xi 'yún chjíhi̱ ra̱ nga najyuu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cha̱so̱ho̱ ni̱see̱. Najmi b'éntje̱, najmi b'ékú, najmi tjíhi̱n ni'ya xi má nga f'átjo nichinehe̱. Tu̱nga tsjáhá ra̱ Nti̱a̱ná nichine. Ko̱ jun, ¿a najmi 'yúhún chjí so nga ni̱see̱? ");
INSERT INTO majNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ko̱ ndaha tsa 'yún kjúánta̱ha̱ ru̱u yjonu̱u tu̱ xi sáhanu masen metru̱, najmi tjín xi nkú ts'ín sáhanu masen metru̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tsa najmi manu̱u n'o ni xi i̱chí, ¿á jun tífanta̱ha̱ ru̱u yjonu̱u ni xingisoo̱? ");
INSERT INTO majNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Cha̱se̱ chu̱ba̱yoho̱o xi nkú ts'ín sá naxúu̱. Najmi ts'ínxá ko̱ najmi ts'ínnda nachjún. Tu̱nga an b'a̱ tíxinnu̱u nga ta̱ ndaha nda̱ rei̱ Salomon xi 'yún chánka kama ni̱stjin nk'ie, najmi b'a̱ k'un najyun xi kingja xi nkúhu naxúu̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tsa Nti̱a̱ná b'a̱ tsjo ts'ínk'íéntu jñá xi chu̱ba̱ ma cháhá, xi nd'a̱i̱ ma chá ko̱ ndyjunni̱ ku̱i̱ti̱, ¿a najmi tu̱ sahá 'yún tsjá sanu̱u najyun xi ndyjo̱o jun xi 'yún chjí so nga jñóo̱? ¡Á b'a̱ 'yún i̱chí s'ejihi̱nnu̱u Nti̱a̱ná! ");
INSERT INTO majNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kui b'a̱ maha, najmi tu̱ b'ejña títjun nga ni xi chi̱no̱o ko̱ ni xi s'i̱u ku̱i̱nchísjo. Najmi tu̱ kui kju̱a̱baha̱ niu̱ kas'enu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","A̱t'aha̱ ngayjee̱ ni xu'bi̱ bangisjai xu̱ta̱ xi tjín a̱sunntee̱, tu̱nga jahá be Na̱'minu̱u nga machjénnu̱u ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tjehe̱nnto nga katatéxumanu̱u Nti̱a̱ná ko̱ b'a̱ ts'ín tu̱ k'u̱a̱i̱suhúnnu̱u ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Najmi tu̱ binkjun, chu̱tsa̱nka̱ tíntína̱. A̱t'aha̱ tsjo tjíhi̱n Na̱'minu̱u nga tsjánu̱u nga ku̱i̱tjás'e̱njiun xi nkú ts'ín batéxuma. ");
INSERT INTO majNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ta̱teño ni xi tjínnu̱u ko̱ tjoho̱on xu̱ta̱ x'a̱n. T'ekú ni xi najmi maha̱ batsun. Ch'a̱tjó ndji̱o̱jmi ján ni xi ts'i̱ín nchi̱ná sínnu̱u, má najmi ma fas'en já ndyjé ko̱ ta̱ ndaha xubíu̱ najmi maha̱ bate. ");
INSERT INTO majNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","B'a̱ tíxinnu̱u a̱t'aha̱ má nga tíjña kju̱a̱nchi̱nánu̱u, yo̱ ta̱ tíjña ani̱ma̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’T'endo yjonu̱u ko̱ t'etíú nd'ínu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","B'a̱ n'o̱o xi nkú ts'ín já musu̱ xi i̱ncha kuyá nga kj'u̱a̱í nda̱ nti̱a̱ha̱ xi kafí kju̱a̱bixan, xi nk'ie nga f'ai tu̱ tje̱n'yún chjux'áhá ra̱ a̱nkju̱o̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Á b'a̱ nda tjíhin ts'e̱ já musu̱ xi tjíntujíhin nk'ie nga kj'u̱a̱íhi nda̱ nti̱a̱ha̱. Kju̱axi̱ ni xi tíxinnu̱u. Ni xi ts'i̱ín nda̱nti̱o̱ tu̱ nga̱t'aha̱ nga tíchuyáha̱, k'u̱énda yjoho̱ nga ts'i̱ínk'íéntut'á yámixo̱ já musu̱ ko̱ tsjáha̱ ni̱ñu̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Á b'a̱ nda tjíhin ts'e̱ já musu̱ xu'bo̱ tsa tjíntu tík'un nk'ie nga kj'u̱a̱í nda̱ nti̱a̱ha̱, ndaha tsa masen ni̱stje̱n ko̱ ndaha tsa ja tífi ma sen. ");
INSERT INTO majNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","’Katumankjinnu̱u ni xu'bi̱. Tsa be títjun nda̱ xi ts'e̱ ni'yoo̱ mí chu̱ba̱ha kj'u̱a̱í nda̱ ndyjée̱, ta̱ k'úéjña nda. Najmi tsjánte tsa nda̱ ndyjée̱ kju̱a̱s'en kju̱a̱'yún ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","B'a̱ ts'ín ta̱ ti̱ntsu̱ba̱ ndahanu ko̱ jun, a̱t'aha̱ chu̱ba̱ nga najmi tíchuyóho̱o kj'u̱a̱í Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A̱s'a̱i b'a̱ kitsú Simon Pedro̱: —Ji nda̱ maestru̱, ¿a ji̱n ts'a̱ji̱n én xi kuachubai, a ra̱ ko̱hó xu̱ta̱? ");
INSERT INTO majNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","B'i̱ kitsú Nda̱ Nti̱a̱ná: —¿Yá nda̱ musu̱hu xi na̱xu̱ fiko̱ xáha̱ ko̱ xi nkjink'un, xi nda̱ nti̱a̱ha̱ kitsjá xáha̱ nga kui xi tsjáha̱ nichine já musu̱ xingisoo̱ nk'ie nga ku̱i̱chú chu̱ba̱? ");
INSERT INTO majNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","¡Á b'a̱ nda tjíhin ts'e̱ nda̱ musu̱ xu'bi̱ tsa b'a̱ títs'ín nk'ie nga kj'u̱a̱í nda̱ nti̱a̱ha̱! ");
INSERT INTO majNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kju̱axi̱ ni xi tíxinnu̱u. Nda̱ nti̱a̱ha̱ ts'i̱ín kunntáha̱ ngayjee̱ ni xi tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tu̱nga tsa b'i̱ ts'ín ts'i̱ínnkjink'un nda̱ musu̱ xu'bi̱: “K'u̱a̱ndaya saha̱ nda̱ nti̱a̱na̱ nga kj'u̱a̱í.” A̱s'a̱i k'u̱éhe̱ já musu̱ ko̱ jminchjín musu̱ xingisoo̱ ko̱ nga kji̱ne̱ ko̱ k'úí ko̱ ka̱ma ch'i̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tsa tu̱ kj'u̱a̱íhí nda̱ nti̱a̱ha̱ nda̱ musu̱ xu'bi̱ ni̱stjin xi najmi tíkuyáha̱ ko̱ chu̱ba̱ xi najmi be, 'yún ndjá ts'i̱ínnijéhe̱ nda̱ nti̱a̱ha̱ xi nkú ts'ín n'enijéhe̱ xu̱ta̱ xi najmi mjehe̱ s'ejihi̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Nda̱ musu̱ xi be ni xi mjehe̱ nda̱ nti̱a̱ha̱ ko̱ najmi b'énda yjoho̱ ko̱ ta̱ ndaha najmi ts'íntjusun ni xi mjehe̱ nda̱ nti̱a̱ha̱, kui xi nkjin ni̱yá s'e̱he̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tu̱nga nda̱ musu̱ xi najmi be ni xi mjehe̱ nda̱ nti̱a̱ha̱ ko̱ títs'ín ni xi tjíhin nga n'e̱ kju̱a̱ha̱ ra̱, kui xi chuba ni̱yá s'e̱he̱. A̱t'aha̱ ngayjee̱ xi ts'ati ni xi kits'ínkjáíhi̱n, kui xi ta̱ ts'ati ni xi ku̱i̱nchí ngáha̱ ra̱. Ko̱ xi 'yún tse ni xi kin'e kunntá, kui xi ta̱ 'yún tse ni xi n'e̱nisi ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’An jái̱k'iet'á nd'íá a̱sunntei̱ ko̱ mangimjena nga ku̱i̱ti̱ kai. ");
INSERT INTO majNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tu̱nga tjíhin ni nga nku kju̱a̱ni̱ma̱ xi tu̱ xí chánkahá kj'u̱a̱jian. Un ṉkjún tíbena ko̱ b'a̱ ka̱mana santaha nkúhu nga ku̱i̱chú ni̱stjin nga ku̱i̱tjusun niu̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A b'a̱ manu̱u nga kju̱a̱jyu jái̱ tsja a̱sunntei̱? An b'a̱ tíxinnu̱u nga najmi. Tu̱ xi kju̱a̱kjánya níhi yjoho̱ xu̱ta̱ jái̱hina. ");
INSERT INTO majNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","A̱t'aha̱ nd'a̱i̱ ch'a̱tuts'i̱hi̱n ra̱ nga ku̱a̱kjánya yjoho̱ má nga tjíntu un xu̱ta̱. Jan ngju̱a̱i̱ kontra̱ha̱ jo, ko̱ xi joo̱ ngju̱a̱i̱ kontra̱ha̱ xi joo̱n. ");
INSERT INTO majNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Xi tí'mi na̱'mi ngju̱a̱i̱ kontra̱ha̱ ntíhi̱, ko̱ xi tí'mi ntí ngju̱a̱i̱ kontra̱ha̱ na̱'mihi̱. Xi tí'mi na̱a ngju̱a̱i̱ kontra̱ha̱ ta̱kjíhi̱n, ko̱ xi tí'mi ta̱kjín ngju̱a̱i̱ kontra̱ha̱ na̱aha̱. Xi tí'mi na̱ nchí'ya ngju̱a̱i̱ kontra̱ha̱ na̱ a̱ntaha̱, ko̱ xi tí'mi na̱ a̱nta ngju̱a̱i̱ kontra̱ha̱ na̱ nchí'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","B'a̱ ta̱ kitsú ya Jesu nga kinchja̱ko̱ xu̱ta̱ nkjiu̱n: —Nk'ie nga yo nga nibá ni̱nti̱ xi tje̱hen má fintjai ts'íu̱, a̱s'a̱i: “Tsí k'u̱a̱” bixíún, ko̱ b'a̱ ma. ");
INSERT INTO majNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ko̱ nk'ie nga tsjen ntjo̱ sje, a̱s'a̱i: “Ka̱ma sje” bixíún, ko̱ b'a̱ ma. ");
INSERT INTO majNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Xu̱ta̱ xi tu̱ tsjohó ra̱ bakúchji xi nkú ts'ín benkjún Nti̱a̱ná! Mankjinnu̱u ni xi ma chji nk'a ján ko̱ t'anankiu̱, tu̱nga, ¿á najmi tímankjihi̱nnu̱u ni̱stjin xi kich'ahanu nd'a̱i̱? ");
INSERT INTO majNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Á najmi n'enkjíntak'un su̱ba̱hanu ni xi nda tjín nginku̱n Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tsa tjín xi tíbatéjénehi ko̱ tje̱nko̱i̱ nga tí'miko̱i̱ nginku̱n nda̱ tjíxóo̱, chu̱bako̱ndai nga tje̱nko̱ sai a̱ya ni̱yóo̱, tu̱ xi najmi ngju̱a̱i̱ko̱ho ri nginku̱n nda̱ jue. A̱t'aha̱ tsa nginku̱n nda̱ jue ngju̱a̱i̱ko̱hi, a̱s'a̱i nda̱ jue ts'i̱ínkjas'ehin a̱ya ntsja nda̱ xi kunntá nu̱ba̱yóo̱ ko̱ kui xi ngju̱áya'yíhin. ");
INSERT INTO majNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","B'a̱ tíxihin nga najmi ku̱i̱tjui yo̱ santa nkúhu nga k'úéchjíyjei to̱on xi tje̱hin. ");
INSERT INTO majNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kui ni̱stjin xu'bo̱ kabincha yo̱ k'u̱a̱ xi kitsúyaha̱ Jesu ni xi kamat'ain k'u̱a̱ já xi nibáha a̱nte Galilea̱. Pilato̱ kits'ínk'ien jóo̱ ko̱ ta̱ kuihi jníhi̱ jakj'á nga kits'íntjijinko̱ho jníhi̱ chu̱ xi i̱ncha tsichuko̱ nga kitsjá chje̱. ");
INSERT INTO majNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A̱s'a̱i kinchja̱ Jesu: —¿A b'a̱ manu̱u nga b'a̱ kamat'ain já Galilea̱ xu'bi̱ a̱t'aha̱ 'yún tjín saha̱ ngatitsun nga ngayjee̱ xu̱ta̱ xi tjín a̱nte Galilea̱? ");
INSERT INTO majNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","An b'a̱ tíxinnu̱u nga najmi. Ko̱ ta̱ jun, tsa najmi kuankínchj'a̱ha̱ ru̱u ani̱ma̱nu̱u, ngatentoo̱ b'a̱ ta̱ ts'ín ku̱a̱yó. ");
INSERT INTO majNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ko̱ máha já tj'ion jan xi k'ien nga tsijnenehe̱ xjó nk'a xi kisasín ntá ti̱xa̱ Siloe, ¿a b'a̱ manu̱u nga kui xi 'yún tjín saha̱ ngatitsun nga xu̱ta̱ xi tjín nanki Jerusalen? ");
INSERT INTO majNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","An b'a̱ tíxinnu̱u nga najmi. Ko̱ ta̱ jun, tsa najmi kuankínchj'a̱ha̱ ru̱u ani̱ma̱nu̱u, ngatentoo̱ b'a̱ ta̱ ts'ín ku̱a̱yó. ");
INSERT INTO majNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ko̱ b'i̱ ta̱ ts'ín y'éjña chu̱ba̱ya Jesu nga tsakúya: —Nku nda̱ kisasíhi̱n nku yá higuera̱ a̱jin yá tuntsja̱jéhe̱ ko̱ ngjisehe̱ tsa ja yjaha̱ tu higo̱ yóo̱, tu̱nga ndahá nku najmi kisakúhu̱. ");
INSERT INTO majNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A̱s'a̱i kinchja̱ko̱ nda̱ xi kunntá yá tuntsja̱jée̱: “Ja tjínna jan nú nd'a̱i̱ nga tíf'ái̱ngisja tuhu̱ yá higuera̱ xu'bi̱. Ndaha nku najmi tísakúna. Ti̱chásuin, a̱t'aha̱ tu̱ títs'ínkjenki tiyahá nga'yúhu̱n t'anankiu̱”, kitsú. ");
INSERT INTO majNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","A̱s'a̱i b'a̱ kitsú nda̱ xi kunntá yá tuntsja̱jée̱: “Ji nda̱ nti̱a̱, tjennteihi̱ nga katasinjña sa nú xu'bi̱. Kuakjanndáíhi̱ tuts'in ko̱ kuinchankíhi̱ abono̱. ");
INSERT INTO majNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tsa tsjá tu núni̱, nda tjín. Tu̱nga tsa najmi, ka̱ma stísun.” ");
INSERT INTO majNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nku ni̱yá nk'ie ni̱stjin nkjún, ni'ya sinagoga̱ tíbakúya Jesu éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yo̱ kab'ejña nku ta̱chju̱ún xi tjíhi̱n tj'ion jan nú nga uhu̱n. Nku nda̱ninda kits'ínchitjuhu̱ ko̱ ndaha̱chí najmi ta̱ ma basin na̱xu̱hu. ");
INSERT INTO majNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nk'ie nga kikie Jesu ta̱chjúu̱n, a̱s'a̱i kinchja̱ha̱ ko̱ b'a̱ kitsúhu̱: —Ji ta̱chju̱ún, ja kama nda̱íhi ch'in xi k'uhin. ");
INSERT INTO majNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A̱s'a̱i kingjénne ntsja Jesu ta̱chjúu̱n. Ta̱ kuihi chu̱bo̱ tsasin na̱xu̱ ngáha ko̱ kits'íntsjoho̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tu̱nga kama kjahán ra̱ nda̱ k'aku̱hu̱ ni'ya sinagoga̱, a̱t'aha̱ ni̱stjin nkjún nga kits'ínnkihi̱ Jesu ta̱chjúu̱n. A̱s'a̱i b'a̱ kitsúhu̱ xu̱to̱: —Jun ni̱stjin tíjña nga ma n'exá. Kui ni̱stjiu̱n nibó nga n'e̱nkinu̱u, najmi tu̱ ni̱stjin nkjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tu̱nga b'i̱hí kitsú Jesu: —¡Tu̱ tsjohónu̱u bakuchjíú xi nkú ts'ín yankjún Nti̱a̱ná! ¿A najmi chjunndáyanú chu̱ xi tjínnu̱u nga ni̱stjin nkjún nga bankín n'ek'iu ntá? ");
INSERT INTO majNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ta̱chjíi̱n ta̱ ntje̱he̱ ntje̱ cháná Abraham maha, xi ja tjíhi̱n tj'ion jan nú nga Satana y'ét'a'yúhu̱n nga kitsjá ch'ihi̱n, ¿a najmi tjíhín ni nga chjúnndáya nga ni̱stjin nkjún? ");
INSERT INTO majNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nk'ie nga b'a̱ kitsú Jesu, kama subaha̱ ngayjee̱ já kontra̱ha̱. Tu̱nga máha xu̱ta̱ nkjiu̱n, kama tsjoho̱ ngayjee̱ kju̱a̱nkjún xi títs'ín Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","A̱s'a̱i b'i̱ kitsú ya Jesu: —¿Mí nihi xi b'a̱ joyaha xi nkú ts'ín batéxuma Nti̱a̱ná? ¿Mí nihi xi k'uejñá chu̱ba̱yahana? ");
INSERT INTO majNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kui xi b'a̱ joyaha nku k'un mostasa̱ xi jakj'á nku nda̱ ko̱ y'éntje̱ jñáha̱. A̱s'a̱i kisá k'uu̱n ko̱ nku yá tu chánka kama, ko̱ ni̱see̱ j'ai ts'ínnda'á nu̱ba̱ha̱ tjiaha̱ yóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","A̱s'a̱i ta̱ kinchja̱ ngáha Jesu: —¿Mí nihi xi k'uejñá chu̱ba̱yako̱hona xi nkú ts'ín batéxuma Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kui xi b'a̱ joyaha na̱'yu̱ saha̱n ni̱nku̱a̱n xi jakj'á nku ta̱chju̱ún ko̱ kits'íntjijinko̱ tse nku̱a̱n ni̱nku̱a̱n. A̱s'a̱i tsijin ngatentee̱ na̱'yu̱. ");
INSERT INTO majNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nk'ie nga títs'ín ni̱yá Jesu nga tífi nanki Jerusalen, tsakúya ts'íhi̱n éhe̱n Nti̱a̱ná má xi tje̱hen nga tíf'a, nanki i ko̱ nanki xi̱xi̱. ");
INSERT INTO majNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","A̱s'a̱i b'a̱ kitsú nku xi kingjásjaiyaha̱ Jesu: —Ji Nda̱ maestru, ¿a chuba maha xi n'e̱k'anki? ");
INSERT INTO majNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","B'i̱ kitsú Jesu: —N'e̱ kju̱a̱'yúhu̱n ru̱u yjonu̱u nga ti̱tjás'o̱on a̱nkju̱a̱ ntsjíyoo̱. A̱t'aha̱ tíxinyanu̱u nga nkjin ṉkjún maha xi ka̱ma mjehe̱ kju̱a̱s'en yo̱, tu̱nga najmi ka̱mahá ra̱. ");
INSERT INTO majNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nk'ie nga ku̱i̱síntje̱n nda̱ xi ts'e̱ ni'yoo̱ ko̱ k'u̱échja a̱nkju̱o̱, jun xi kabincho na̱tsin ján n'e̱kjano a̱nkju̱o̱ nga b'a̱ ku̱i̱xíún: “Ji nda̱ nti̱a̱, chjúx'áni̱ a̱nkju̱o̱.” Tu̱nga b'a̱há ku̱i̱tsu̱nu̱u: “Najmi be yáha jun.” ");
INSERT INTO majNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","A̱s'a̱i b'a̱ ku̱i̱xíún: “Yanáá xinki̱á. Ni̱yáténi̱ tsakuyáí éhe̱n Nti̱a̱ná.” ");
INSERT INTO majNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tu̱nga b'a̱há ku̱i̱tsu̱nu̱u: “Ja b'a̱ kuaxinnu̱u nga najmi be yáha jun. Ti̱yú t'axín tentenú, jun xi ch'on kin'o.” ");
INSERT INTO majNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","’Yo̱ ch'i̱ú ko̱ ku̱i̱chó ni'yun nk'ie nga cho̱o nga ntje̱ cháná Abraham, Isaac ko̱ Jacob ko̱ ngayjee̱ já profeta̱ tjíntu má batéxuma Nti̱a̱ná. Ko̱ máha jun, ku̱i̱ch'onsje̱nu̱u na̱tsiu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","A̱t'aha̱ tu̱ má xi tje̱hén ni ni̱baha xu̱ta̱ nga kj'u̱a̱í s'í xi ka̱ma má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tjín xu̱ta̱ xi yjanki nd'a̱i̱, kui xi tjun ka̱ma ngáha, ko̱ tjín xi tjun nd'a̱i̱, kui xi tsjénnki. ");
INSERT INTO majNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ta̱ kuihi chu̱bo̱ tjín já fariseo̱ xi j'aisehe̱ Jesu ko̱ b'a̱ kitsúhu̱: —Xin t'in, a̱t'aha̱ Herode̱ Antipa̱ mjehe̱ ts'i̱ínk'iehin. ");
INSERT INTO majNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","B'i̱ kitsú Jesu: —B'a̱ tankínk'ihu̱un nda̱ maña̱ xi b'a̱ tjíu̱n: “Cha̱se̱i̱. Nd'a̱i̱ ko̱ ndyjunni̱ k'onsje̱ jánindoo̱ ko̱ ts'innkíhi̱ xu̱ta̱, ko̱ ni̱stjin xi ma jahan ka̱ma ndju̱úna xána̱.” ");
INSERT INTO majNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tu̱nga tjíhín ni nga ts'inndja̱á ni̱yána̱ nd'a̱i̱ ko̱ ndyjunni̱ ko̱ nkini̱ nga kfíán nanki Jerusalen. A̱t'aha̱ najmi ka̱ma xin nanki ku̱a̱yá nku nda̱ profeta̱. ");
INSERT INTO majNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jun xu̱ta̱ Jerusalen, xi n'ek'ion já profeta̱ ko̱ b'oho̱o ndji̱o̱ xu̱ta̱ xi n'e nibásenu̱u! ¡A tu̱ nkjihín ni̱yá kama mjena nga k'uentúkúnu̱u xi nkú ts'ín xa̱nto̱ nga b'énkinka̱ ntíhí, tu̱nga najmi kin'e yunú! ");
INSERT INTO majNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nd'a̱i̱ ni̱ ma, ja s'e̱jña masen a̱ntenu̱u. An b'a̱ tíxinnu̱u nga najmi ta̱ cha̱hanú santa nkúhu nga ku̱i̱chú ni̱stjin nga b'a̱ ku̱i̱xíún: “¡Kakjanínk'a Nti̱a̱ná xi nibáha ngajoho̱!” ");
INSERT INTO majNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nku ni̱stjin nkjún ni̱ñu̱ ngji kjine Jesu ni'yaha̱ nku nda̱ k'aku̱ fariseo̱. Kikuntá 'maha̱ jóo̱ kui chu̱bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ta̱ kabasinjña yo̱ nginku̱n Jesu nku nda̱ xi xka̱í tíi̱nchaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","A̱s'a̱i kinchja̱ko̱ Jesu já maestru̱hu̱ kju̱a̱téxumoo̱ ko̱ já fariseo̱: —¿A ma n'enkihi̱ xu̱ta̱ xi uhu̱n nga ni̱stjin nkjún, a ra̱ najmi? ");
INSERT INTO majNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tu̱nga najmi kinchja̱há jóo̱. A̱s'a̱i Jesu kits'ínsihi̱n nda̱ uu̱n, kits'ínnkihi̱ ko̱ kits'ínkji ngáha ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A̱s'a̱i ta̱ kinchja̱ko̱hó ngáha jóo̱ nga b'i̱ kitsúhu̱: —Tsa ntíhi̱ ko̱ tsa turu̱hu̱ nku xi síjñajinnu̱u ku̱i̱jne̱ya nku ntá ti̱xa̱ nk'ie nga ni̱stjin nkjún, ¿a najmi tje̱n'yún k'u̱a̱sjejihín? ");
INSERT INTO majNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Najmi kinchja̱ jóo̱, a̱t'aha̱ najmi be nkú ku̱i̱tsu̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ja kamoo̱, nk'ie nga kikie Jesu xi nkú ts'ín tíf'ájin xu̱ta̱ xi kama ñjakú yo̱ a̱nte xi tíi̱ncha títjuu̱n nga tíb'entut'á yámixo̱, a̱s'a̱i y'éjña chu̱ba̱yaha̱ nga tsakúya. B'i̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Tsa tjín xi ku̱i̱tsu̱yahi nga k'úín nku s'í kju̱a̱bixan, najmi tu̱ a̱nte xi síjña títjuu̱n binchin. A̱t'aha̱ tsa tu̱ ahá ni kj'u̱a̱í nku xi ta̱ kik'inyaha̱ nga kj'u̱a̱í s'íu̱ xi 'yún yankjún sa nga ji, ");
INSERT INTO majNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tsa a̱s'a̱i b'a̱ kj'u̱a̱í tsuhi nda̱ xi tíb'asje s'íu̱: “Nda̱i̱ tjehi̱n má kabinchin”, kui nga ka̱ma suba ts'íhin ri nk'ie nga k'úi̱nnchin a̱nte xi fekuu̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ni xi n'e̱ní tsa tjín xi ku̱i̱tsu̱yahi nga k'úín nku s'í, t'ihi̱nnchin a̱nte xi fekuu̱, tu̱ xi b'a̱ kj'u̱a̱í tsuhu ri nda̱ xi kitsúyahi nga kjúái̱ s'íu̱: “Ji nda̱ amigo̱, t'ihi̱nnchin nku a̱nte xi tíjña k'aku̱.” B'a̱ ts'ín sa̱kúhu ri kju̱a̱chánka nginku̱n ngayjee̱ xi k'úéntut'áko̱hi yámixo̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","A̱t'aha̱ tu̱ yáhá ni xi k'u̱a̱sje nk'a suba yjoho̱, kui xi cha̱jnu̱cha. Ko̱ xi k'u̱a̱sje ni̱ma̱kju̱a̱ yjoho̱, kui xi sa̱kúhu̱ kju̱a̱chánka. ");
INSERT INTO majNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ko̱ ta̱ kinchja̱ko̱ Jesu nda̱ xi kitsúyaha̱ nga kj'u̱a̱í kjine ni̱ñu̱. B'i̱ kitsúhu̱: —Nk'ie nga s'í n'e̱sjei, najmi tu̱ já xi nda nchja̱ko̱hi chubaihi̱, ta̱ ndaha já nts'ei, ta̱ ndaha já xinki̱, ko̱ ta̱ ndaha já nchi̱ná xi tjíntut'á tiñahi. A̱t'aha̱ tsa b'a̱ n'e̱i̱, kui jóo̱ ku̱i̱nchja̱ ngajoya ngáha ri ko̱ b'a̱ ts'ín ku̱i̱tju chjíhi ni xi kik'a̱i̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ni xi n'e̱ní nk'ie nga s'í n'e̱sjei, xu̱ta̱ x'a̱n chu̱baihi̱, xi ni̱ma̱ha̱, xi najmi ma fi ko̱ xi ka̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","B'a̱ ts'ín nda ka̱mat'aihinni. A̱t'aha̱ xu̱ta̱ xu'bi̱ najmi ka̱maha̱ tsjá ngajoya ngáha ri ni xi kj'u̱a̱i̱hi̱, tu̱nga ka̱ma chjíhí ri ni̱stjin nk'ie nga kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱ xu̱ta̱ xi na̱xu̱ y'entu. ");
INSERT INTO majNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nk'ie nga kint'é ni xu'bi̱ nku nda̱ xi ta̱ kab'ejñat'ako̱ Jesu yámixo̱, a̱s'a̱i b'a̱ kitsú: —¡Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi k'úéntujíhi̱n s'í chánka xi ka̱ma má batéxuma Nti̱a̱ná! ");
INSERT INTO majNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A̱s'a̱i b'a̱ kitsúhu̱ Jesu ndo̱: —Nku ni̱yá nku nda̱ ts'asje nku s'í chánka ko̱ nkjin ṉkjún xu̱ta̱ kits'ínkint'é nga kj'u̱a̱ísehe̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nk'ie nga ja tsichu chu̱ba̱, a̱s'a̱i kits'ínkji nku nda̱ musu̱hu̱ ndo̱. “Nibó, a̱t'aha̱ ja tjínda ngayjee̱ nichinee̱”, kitsúhu̱ xi i̱ncha kin'ekint'é nga kj'u̱a̱í s'íu̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tu̱nga ngayjee̱ jóo̱ i̱ncha tsanki nga n'e̱'yún tak'uhu̱n. “A̱s'a̱i kuak'atsená nku jñá ko̱ tjíhin nga kfínsehe̱. Tíbankihi nga n'e̱'yún tak'unní”, kitsú nda̱ xi tjun kik'inyaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“A̱s'a̱i kuak'atsená te turu̱ bakján nanki. Tífikjut'ayá chu̱. Tíbankihi nga n'e̱'yún tak'unní”, kitsú ngá kj'a̱í nda̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“A̱s'a̱i kuixanná, kui kju̱a̱ha nga najmi ka̱ma kfíhinna”, kitsú ngá nda̱ xi ma jahan. ");
INSERT INTO majNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’Kik'óya ngáha nda̱ musu̱ ko̱ kitsúyaha̱ nda̱ nti̱a̱ha̱ ngayjee̱ ni xu'bi̱. A̱s'a̱i kama kjaha̱n nda̱ xi ts'e̱ ni'yoo̱. “Ki̱tsa̱ t'in a̱jin na̱nti̱o̱ ko̱ ni̱yáté xi tjín nanki xu'bi̱. Nibáko̱i̱ e̱i̱ xi x'a̱ha̱n, xi ni̱ma̱ha̱, xi ka̱ha̱, ko̱ xi najmi ma fi”, kitsúhu̱ nda̱ musu̱hu̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","A̱skahan b'a̱ kitsú nda̱ musu̱: “Ji nda̱ nti̱a̱, ja kuats'intjusan xi nkú nga kuakixín, tu̱nga tjíhín sa a̱nte.” ");
INSERT INTO majNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","A̱s'a̱i b'a̱ kitsú nda̱nti̱o̱: “T'in a̱ya ni̱yóo̱ ko̱ a̱nte xi̱ xi tjíndai e̱i̱. N'e̱ kju̱a̱'yúhu̱n ri̱ xu̱ta̱ nga kju̱a̱s'en e̱i̱, tu̱ xi tséhe ni'yana̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A̱t'aha̱ an b'a̱ tíxinnu̱u nga ndaha nku xu̱ta̱ xu'bo̱ xi kixinya títjuhu̱n najmi kji̱ne̱ ni xi y'endá.” ");
INSERT INTO majNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nkjin ṉkjún maha xu̱ta̱ xi tje̱nnkihi̱ Jesu. A̱s'a̱i kits'ínk'ótjiyak'un ko̱ b'a̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Tsa tjín xi tsjénnkina, tjíhin nga 'yún ts'i̱ín mjena nga na̱'mihi̱, na̱aha̱, chju̱úhu̱n, ntíhi̱, já nts'e̱, jminchjín nichja, ko̱ santaha yjoho̱. Tsa najmi b'a̱ ts'i̱ín, najmi tsuhu̱ ra̱ nga ka̱ma xu̱ta̱ ni'yakuyána̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Xi najmi títsjáha̱ yjoho̱ nga tsjénnkina santaha tsa ku̱a̱yá nga̱t'ana̱, najmi tsuhu̱ ra̱ nga ka̱ma xu̱ta̱ ni'yakuyána̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Tsa nku xi tíjñajinnu̱u mjehe̱ ts'i̱ínnda nku torre̱, ¿a najmi tjuhún k'úéjña nga ts'i̱ínxki̱ nkú tjín ni xi kfe̱t'aha̱, tu̱ xi sku̱e̱he tsa tíjñaha̱ ni xi machjéhe̱n nga ts'i̱ínndju̱ú niu̱? ");
INSERT INTO majNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A̱t'aha̱ tsa̱ ts'i̱ínnda tuts'in xjóo̱ ko̱ a̱skahan najmi ku̱i̱chúkju̱a̱ha̱ nga ts'i̱ínndju̱ú niu̱, a̱s'a̱i ngayjee̱ xu̱ta̱ xi sku̱e̱he̱ nga b'a̱ ts'i̱ín ku̱a̱jnu̱kiehe̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","B'i̱ ngján b'a̱ ku̱i̱tsu̱: “Nku xá kik'atuts'i̱hi̱n kui nda̱i̱, tu̱nga najmi tsichukju̱a̱há ra̱ nga kits'ínndju̱ú.” ");
INSERT INTO majNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Ko̱ tsa nku nda̱ rei̱ xi tíjñaha̱ te mii̱ já jun mjehe̱ ngju̱a̱i̱ kjánko̱ kj'a̱í nda̱ rei̱, ¿a najmi tjuhún k'úéjña nga ts'i̱ínnkjink'un tsa ku̱i̱chúkju̱a̱ha̱ nga kja̱ánko̱ nda̱ rei̱ xinkuu̱ xi nibáko̱ kan mii̱ já jun xi ts'e̱? ");
INSERT INTO majNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ko̱ tsa behe̱ k'un nga najmi ku̱i̱chúkju̱a̱ha̱, a̱s'a̱i ts'i̱ínkji já chji̱ne̱'én xi ts'e̱ xi má nga ku̱a̱nkihi̱ kju̱a̱jyu nda̱ rei̱ xinkuu̱ nk'ie nga kjin tje̱n sa. ");
INSERT INTO majNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kui b'a̱ maha, tu̱ yáhá ni xi tíjñajinnu̱u xi najmi k'u̱éjña ngayjee̱ ni xi tjíhi̱n, kui xi najmi tsuhu̱ ra̱ nga ka̱ma xu̱ta̱ ni'yakuyána̱. ");
INSERT INTO majNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Nda na̱xo̱, tu̱nga tsa ndyja̱ nga'yúhu̱n, ¿nkú ts'ín ka̱ma ntia ngáha? ");
INSERT INTO majNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Najmi ta̱ chjíhi̱ ra̱. Najmi ka̱ma n'e̱chjén xi nkúhu tsa ninte ko̱ ta̱ ndaha tsa n'e̱tjijihi̱n abono̱. Tu̱ ngju̱a̱i̱yahá sa na̱tsin ján. Xi tje̱n tja̱ba̱xínñju, katasínñju. ");
INSERT INTO majNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nkjín já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱ ko̱ xu̱ta̱ xi najmi na̱xu̱ ts'íntjusun kju̱a̱téxumaha̱ Moise kama ñjakút'aha̱ Jesu nga j'aisínñjuhu̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","A̱s'a̱i kinchja̱yanehe̱ já fariseo̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ nga b'a̱ kitsúhu̱ xinkjín: —Kui nda̱i̱ ts'ínkjáíhi̱n ko̱ kjineko̱ ni̱ñu̱ xu̱ta̱ xi najmi na̱xu̱ ts'íntjusun kju̱a̱texumoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","B'i̱ kitsú Jesu nga y'éjña chu̱ba̱yaha̱: ");
INSERT INTO majNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Tsa tíjñajinnu̱u nku xi tíi̱nchaha̱ unchan chu̱tsa̱nka̱, tsa ndyja̱ha̱ nku, ¿a najmi ku̱i̱ncháhá xi cháte ko̱ yachán ñjoo̱ a̱jin jñóo̱ ko̱ ngju̱a̱i̱ngisjai xi kandyjoo̱ santa nkúhu nga sa̱kúhu̱? ");
INSERT INTO majNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ko̱ nk'ie nga sa̱kúhu̱ chu̱, tsjo ka̱maha̱ nga ngju̱ásun tjia. ");
INSERT INTO majNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nga kj'u̱a̱í ni'yaha̱, ku̱i̱nchja̱ ñjaha̱ já xi nda nchja̱ko̱ho̱ ko̱ já xi tjíntut'á tiñaha̱. “N'e̱tsjoko̱nú, a̱t'aha̱ ja kuasakú ngáhana chu̱tsa̱nka̱ xi kandyjana”, ku̱i̱tsu̱hu̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","’B'a̱ tíxinnu̱u nga b'a̱ ta̱ ts'ín 'yún s'e sa kju̱a̱tsjo ndji̱o̱jmi ján nk'ie nga nku xu̱ta̱ ngatitsun fikj'áha̱ ra̱ ani̱ma̱ha̱ nga cháte ko̱ yachán ñja xu̱ta̱ xi na̱xu̱ nginku̱n Nti̱a̱ná, xi najmi tjíhin nga ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Ko̱ tsa nku ta̱chju̱ún tíjñaha̱ te to̱ontaba, tsa ndyja̱ha̱ nku, ¿a najmi k'u̱étihí nku nd'í ko̱ kjécha ni'yaha̱ nga ku̱a̱ngisjáí sisin santa nkúhu nga sa̱kú ngáha̱ ra̱ to̱oho̱n? ");
INSERT INTO majNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ko̱ nk'ie nga sa̱kúhu̱, a̱s'a̱i ku̱i̱nchja̱ ñjaha̱ jminchjín xi nda nchja̱ko̱ho̱ ko̱ jminchjín xi tjíntut'á tiñaha̱. “N'e̱tsjoko̱nú, a̱t'aha̱ ja kuasakú ngáhana to̱ontaba xi kandyjana”, ku̱i̱tsu̱hu̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","B'a̱ tíxinnu̱u nga b'a̱ ta̱ ts'ín s'e kju̱a̱tsjo a̱jihi̱n ntítsjehe̱ Nti̱a̱ná nk'ie nga nku xu̱ta̱ ngatitsun fikj'áha̱ ra̱ ani̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","B'i̱ kitsú sa Jesu: —Nku nda̱ kis'ejñaha̱ jo já. ");
INSERT INTO majNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nda̱ xi kjintíu̱ kinchja̱ko̱ na̱'mihi̱: “Ji na̱'mi, k'u̱a̱i̱ní ni xi kanéna”, kitsúhu̱. A̱s'a̱i tsakjánya ndo̱ ni xi tjíhi̱n nga kitsjáha̱ ntíhí. ");
INSERT INTO majNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A̱skahan nga ja j'a chuba ni̱stjin, a̱s'a̱i tsatéña nda̱ xi kjintíu̱ ngayjee̱ ni xi kik'a̱i̱hi̱ ko̱ ngji nku nanki t'axín kjin nga kik'a to̱on xi kisakúhu̱. Yo̱ kits'ínkje tiya to̱oho̱n nga kits'ínjnu kits'ínt'a. ");
INSERT INTO majNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tu̱nga nk'ie nga ja kits'ínkje ngayjee̱ to̱oho̱n, tu̱ nkuhú kjintíá xi tu̱ xí 'yúhún kama nanki xu'bo̱ ko̱ kikie kjintíá ko̱ kui. ");
INSERT INTO majNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A̱s'a̱i ngjinki xáha̱ nku nda̱ xi tíjña nanki xu'bo̱, a̱s'a̱i kits'ínkjihi̱ ndo̱ má tíi̱ncha chi̱nka̱ha̱ tu̱ xi ts'i̱ínkjehen chu̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mjehe̱ kji̱ne̱ ni xi tíi̱ncha kjine chi̱nko̱, tu̱nga najmi ch'a xi kitsjáhá ra̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Tu̱ chahán kama chu̱ba̱yaha̱ ni xi kits'ín, kui nga b'i̱ kitsúhu: “Nkú tjín maha já xi ts'ín xánta ni'yaha̱ na̱'mina̱ xi tíb'anki tímaha̱ nichine. Ko̱ máha an, e̱i̱ tíbaya kjintíá. ");
INSERT INTO majNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tu̱ sahá kfínse ngáha̱ ra̱ na̱'mina̱ ko̱ b'a̱ xíhi̱n: Ji na̱'mi, tje̱nna jé nginku̱n Nti̱a̱ná ko̱ nginkuin. ");
INSERT INTO majNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Najmi ta̱ an tsuhuna tsa ntíhi̱ k'úínní. Tu̱ sahá katumahi an xi nkú joyaha nku nda̱ musu̱ xi ts'íhin xánta.” ");
INSERT INTO majNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A̱s'a̱i kits'ín ni̱yá nda̱tiu̱ nga nibase ngáha̱ ra̱ na̱'mihi. Kjin tje̱n sa nk'ie nga kikiehe̱ na̱'mihi ko̱ kama ni̱ma̱ha̱. Tsangatsanka nga ngjitsubakjá ntíhi̱ ndo̱ ko̱ kikjexu̱'ba. ");
INSERT INTO majNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","A̱s'a̱i b'a̱ kitsú nda̱tiu̱: “Ji na̱'mi, tje̱nna jé nginku̱n Nti̱a̱ná ko̱ nginkuin. Najmi ta̱ an tsuhuna tsa ntíhi̱ k'úíhinní.” ");
INSERT INTO majNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","’Tu̱nga b'a̱há kitsú na̱'mihi̱ nda̱tiu̱ nga kinchja̱ko̱ já musu̱hu̱: “Ki̱tsa̱ nibáko̱o najyun xi 'yún nda ko̱ n'e̱ngjo ntína̱, ko̱ ta̱ t'eyoho̱o na̱jnú ntsja nku stji̱nk'un, ko̱ tjayoho̱o tja̱ba̱xínnté. ");
INSERT INTO majNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nku turu̱ xu̱nkú xi 'yún chánka nibáko̱o ko̱ n'e̱k'ion. Chi̱ne̱é ko̱ n'e̱sjeé s'í. ");
INSERT INTO majNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","A̱t'aha̱ ntína̱ xu'bi̱ nkú joyaha tsa ja k'ien ja kj'úáíya ngáha̱ ra̱. Kui xi kindyja ja kuasakusjáí ngáha.” A̱s'a̱i nku s'í i̱ncha kik'asje. ");
INSERT INTO majNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Máha nda̱ xi chóo̱, jñá kafí. Nk'ie nga kik'óya ko̱ j'ai tiña ni'yoo̱, kint'é nga suu̱n tífane ko̱ nga tíi̱ncha tenki xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A̱s'a̱i kinchja̱ha̱ nku nda̱ musu̱ ko̱ kingjásjaiyaha̱ mí nihi xi tíma. ");
INSERT INTO majNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","B'a̱ kik'ihi̱n: “Nda̱ nts'ei ja kaf'ai ngáha ko̱ na̱'mihi̱ katsjá kju̱a̱ nga kan'ek'ien nku turu̱ xu̱nkú xi 'yún chánka, a̱t'aha̱ nda tjíhi̱n ndo̱ nga kuats'ínkjáín ngáha̱ ra̱.” ");
INSERT INTO majNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kama kjan ṉkjúhu̱n nda̱ xi chóo̱ nga santaha najmi ta̱ mjehe̱ ra̱ kju̱a̱s'ehen a̱yoo̱. Kui nga tsitjusjehe na̱'mihi̱ ko̱ tsankihi̱ nga kju̱a̱s'en. ");
INSERT INTO majNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tu̱nga b'a̱há kitsú ndo̱: “Yai, té, xi nkú ts'ín nkjin nú tjíhi̱n nga títs'inxát'aha ko̱ tehe̱nte tínt'e'éhen, tu̱nga ndaha̱chí nku ni̱yá najmi kje̱ 'ba̱i̱ní nku chu̱tentsu̱ i̱chí xi k'uasjéko̱hona s'í já xi tjoho̱ an. ");
INSERT INTO majNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tu̱nga nk'ie nga kj'uai ntíhi̱ xu'bi̱, xi kits'ínkjeko̱ jminchjín skóo̱ ni xi kik'a̱i̱hi̱, kan'ek'ieihi̱n nku turu̱ xu̱nkú chánka.” ");
INSERT INTO majNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’A̱s'a̱i b'a̱ kitsú na̱'mihi̱: “Ji ntína̱, tehe̱nte tinchunko̱ní e̱i̱, ko̱ ngayjee̱ ni xi tjínna̱ ji ts'i̱. ");
INSERT INTO majNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tu̱nga nd'a̱i̱ tjíhin nga n'e̱sjeé s'í ko̱ n'e̱tsjaá, a̱t'aha̱ nda̱ nts'ei nkú joyaha tsa ja k'ien ja kj'úáíya ngáha̱ ra̱. Kui xi kindyja ko̱ ja kuasakúsjáí ngáha”, kitsú. ");
INSERT INTO majNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","B'i̱ kitsú ya Jesu nga kinchja̱ko̱ xu̱ta̱ ni'yakuyáha̱: —Y'ejña nku nda̱ nchi̱ná xi kitsjá xáha̱ nku nda̱ musu̱hu̱ tu̱ xi ku̱a̱se̱he̱ ra̱ ni xi tjíhi̱n. Kik'inyaha̱ nga nda̱ musu̱ títs'ínkje tiya ni xi kits'ínkjas'ehe̱n nga ku̱a̱se̱he̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A̱s'a̱i kinchja̱ha̱ nda̱ musu̱ ko̱ b'a̱ kitsúhu̱: “¿Á b'a̱ tsu én xi tínt'ehena? N'e̱kjas'enní kuenta̱ha̱ xá xi tín'ei, a̱t'aha̱ najmi ta̱ ji cha̱se̱he̱ ri̱ ni xi tjínna.” ");
INSERT INTO majNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","A̱s'a̱i kits'ínnkjink'un nda̱ musu̱. B'i̱ kitsú: “¿Mí nihi xi ts'ian e̱i̱ ni̱, a̱t'aha̱ ja títs'ínkje xána̱ nda̱ nti̱a̱na̱? Najmi ku̱i̱chúkju̱a̱na tsa xá ndjá ts'ian ko̱ subana tsa chje̱ kuankia. ");
INSERT INTO majNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ja be mí nihi xi ts'ian tu̱ xi ts'i̱ínkjáíhinna xu̱ta̱ ni'yaha̱ nk'ie nga ja kje̱ xána̱.” ");
INSERT INTO majNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’A̱s'a̱i kinchja̱ha̱ nga nkúnkú já xi tje̱he̱n ts'e̱ nda̱ nti̱a̱ha̱. “¿Nkú tjín tje̱hin ts'e̱ nda̱ nti̱a̱na̱?”, kitsúhu̱ nda̱ xi tjun j'aisehe̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Unchan ndji̱í seti̱”, kitsú ndo̱. B'a̱ kitsú nda̱ musu̱: “Á xu̱ju̱n xi tjít'a xki̱hi̱ ni xi tje̱hin e̱i̱. Ki̱tsa̱ ti̱nchin, tu̱ sahá tu̱ chátehé t'et'ai.” ");
INSERT INTO majNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","A̱s'a̱i b'a̱ kitsú ngáha̱ kj'a̱í: “Ko̱ ji, ¿nkú tjín tje̱hin?” “Unchan kusta̱ tuni̱ñu̱”, kitsú nda̱ xu'bi̱. B'a̱há ta̱ kitsú ngáha nda̱ musu̱: “Á xu̱ju̱n xi tjít'a xki̱hi̱ ni xi tje̱hin e̱i̱. Tu̱ sahá tu̱ cháte ko̱ katéhé t'et'ai.” ");
INSERT INTO majNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","’A̱s'a̱i nda̱ nti̱a̱ha̱ nda̱ musu̱ ch'onk'un xu'bi̱ kama nkjúhu̱n nga 'yún nkjink'un ndo̱ nga b'a̱ kits'ín. A̱t'aha̱ xu̱ta̱ xi ts'e̱ a̱sunntee̱ 'yún tjín saha̱ kju̱a̱nkjink'un xi nkú ts'ín b'éndako̱ xinkjín nga xu̱ta̱ xi ts'e̱ má ndzjee̱n. ");
INSERT INTO majNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ko̱ an b'a̱ tíxinnu̱u. N'e̱ chjón kju̱a̱nchi̱ná xi tjín a̱sunnte ngatitsui̱n nga ku̱i̱si̱nko̱ xu̱ta̱, tu̱ xi kas'ehe̱nu̱u xu̱ta̱ xi nda ku̱i̱nchja̱ko̱nu̱u. B'a̱ ts'ín nk'ie nga kfe̱ko̱ a̱sunntei̱ kju̱a̱nchi̱náha̱, n'e̱kjáínnu̱u má nga ku̱i̱ntsu̱ba̱ síún. ");
INSERT INTO majNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Xi kixi̱ fiko̱ nga ts'íntjusun ni xi i̱chí, kui xi ta̱ na̱xu̱ fiko̱ nga ts'íntjusun ni xi tse. Ko̱ xi najmi kixi̱ fiko̱ nga ts'íntjusun ni xi i̱chí, kui xi ta̱ najmi na̱xu̱ fiko̱ nga ts'íntjusun ni xi tse. ");
INSERT INTO majNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kui b'a̱ maha, tsa najmi kixi̱ ku̱a̱nkínko̱o nga cha̱so̱ho̱ kju̱a̱nchi̱ná xi tjín a̱sunnte ngatitsui̱n, ¿yá xi tsjánu̱u nga chúnnto kju̱a̱nchi̱ná xi ndoo̱? ");
INSERT INTO majNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tsa najmi kixi̱ kuankínko̱o nga cha̱so̱ho̱ ni xi ts'e̱ xi kj'a̱í, ¿yá xi tsjánu̱u ni xi ts'a̱jun? ");
INSERT INTO majNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ndaha nku nda̱ musu̱ najmi ma ts'ínxát'aha̱ jo já nti̱a̱. A̱t'aha̱ nku xi ts'i̱ín unkie ko̱ nku xi ts'i̱íntjo, ko̱ a ra̱ ts'i̱ínxát'a sisihi̱n nku ko̱ ch'on ts'ín ku̱a̱se̱he̱ xinkuu̱. Kui nga najmi ka̱ma n'e̱xát'aha̱ ru̱u Nti̱a̱ná ko̱ kju̱a̱nchi̱nóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tu̱nga já fariseo̱, kui xi 'yún tsjoho̱ to̱on. Kui nga tsajnukiehe Jesu nk'ie nga kint'é ngayjee̱ ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A̱s'a̱i b'i̱ kitsúhu̱ Jesu jóo̱: —Xu̱ta̱ nda n'esjo yjonu̱u nginku̱n xu̱ta̱, tu̱nga Nti̱a̱náhá be xi nkú ts'ín tjíntuyá ani̱ma̱nu̱u. A̱t'aha̱ ni xi benkjún xu̱ta̱ tu̱ ts'i̱hí maha̱ Nti̱a̱ná nga basehe̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jet'a xáha̱ ni xi kis'et'a kju̱a̱téxumoo̱ ko̱ ni xi tsakúya já profeta̱ ni̱stjin nga j'ai Jua Bautista̱. Kui ni̱stjiu̱n kik'atuts'i̱hi̱n ra̱ nga tís'eni̱jmí nga Nti̱a̱ná xi batéxuma ko̱ xu̱ta̱ títsjá nga'yúhu̱n yjoho̱ nga tífas'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tu̱nga ta̱ chjíhi̱ ra̱ kju̱a̱téxumoo̱. Najmi 'ni tjín tsa ndyja̱jihi̱n sén nk'a ján ko̱ t'anankiu̱ nga nku ntu i̱chíhi̱ kju̱a̱téxumoo̱ ndyja̱t'a. ");
INSERT INTO majNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Tu̱ yáhá ni xi k'u̱éjña chju̱úhu̱n ko̱ ku̱i̱xanko̱ kj'a̱í ta̱chju̱ún, kui xi tíbangane kju̱a̱bixan tjuhu̱n. Ko̱ xi ku̱i̱xanko̱ ngáha ta̱chju̱ún xi y'éjñaha̱ x'i̱hi̱n, kui xi ta̱ tíbangane ni xi 'mihi̱ kju̱a̱bixan. ");
INSERT INTO majNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Y'ejña nku nda̱ nchi̱ná xi bja najyun xi 'yún chjí ko̱ najyun xi tsjo k'un ko̱ ngayje ni̱stjin tsjo ts'ín b'asje s'í. ");
INSERT INTO majNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta̱ y'ejña ya nku nda̱ x'a̱n xi 'mi Laza̱ro̱, xi kitsejnúhú ra̱ tsé ko̱ xi fajñastiu a̱nkju̱a̱ ni'yaha̱ nda̱ nchi̱nóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kui nda̱ x'o̱n ni xi un b'éhe k'un nga kji̱ne̱ t'íá xi̱ xi bixuntunkí kinte yámixa̱ha̱ nda̱ nchi̱nóo̱. Ko̱ santaha nañóo̱ f'aik'úhu̱n nga kjinejnu tséhe̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tu̱ k'iehén nda̱ x'o̱n ko̱ ntítsjee̱ ngjiko̱ho̱ a̱nte xi má nga tíjña ntje̱ cháná Abraham, ko̱ ta̱ k'ien nda̱ nchi̱nóo̱ ko̱ ngjiyanji. ");
INSERT INTO majNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nk'ie nga un tíbehe̱ nda̱ nchi̱nóo̱ nga̱k'i̱e̱n, tsasenjinki ko̱ kikie nga kjin tíjña Abraham ko̱ nga Laza̱ro̱ kab'ejñat'aha̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","’A̱s'a̱i kikjintáya nda̱ nchi̱nóo̱ nga kinchja̱: “Ji na̱'mi Abraham, katuma ni̱ma̱hi an. T'exáí Laza̱ro̱ nga kats'ínk'anchi̱ku na̱jnú ntsja ko̱ kanibá ts'ínk'anchi̱ njá. A̱t'aha̱ 'yún ṉkjún un tíbena e̱i̱ a̱jin nd'íi̱”, kitsú. ");
INSERT INTO majNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tu̱nga b'a̱há kitsú Abraham: “Ji ntína̱, n'e̱kj'áítsjein nga tsjo ts'ín tsinchin a̱sunntee̱ ko̱ Laza̱ro̱ kju̱a̱ni̱ma̱ j'anki. Tu̱nga nd'a̱i̱ tjíhi̱n kju̱a̱jyu ko̱ ji un tíbehi. ");
INSERT INTO majNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ko̱ nku tíkjá ya. Nku ti̱xa̱ chánkantsú tje̱nchja masen yaná. B'a̱ ts'ín najmi ma f'atikjáha xi tjíntu e̱i̱ xi mjehe̱ ngju̱a̱i̱ ján ko̱ ta̱ ndaha xi tjíntu ján najmi ma f'atikjá nga kj'u̱a̱í e̱i̱.” ");
INSERT INTO majNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’A̱s'a̱i ta̱ kinchja̱há ngáha nda̱ nchi̱nóo̱: “Tíbankihi, na̱'mi, nga n'e̱kjí Laza̱ro̱ ni'yaha̱ na̱'mina̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","A̱t'aha̱ un maha já nts'é. Katjitsúyaha̱ tu̱ xi najmi ko̱ kui kj'u̱a̱íhi a̱nte xu'bi̱ má nga un tíbehe̱ xu̱ta̱”, kitsú ndo̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tu̱nga b'a̱há kitsú Abraham: “Tíjñaha̱ já nts'ei kju̱a̱téxumaha̱ Moise ko̱ xu̱ju̱n xi y'ét'a já profeta̱. Kui xi kant'é éhe̱n”, kitsú. ");
INSERT INTO majNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A̱s'a̱i: “Najmi, na̱'mi Abraham. Tu̱nga tsa tjín xi kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱ ko̱ ngju̱a̱i̱sehe̱ já nts'é, ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱”, kitsú nda̱ nchi̱nóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tu̱nga b'a̱há kitsú Abraham: “Tsa najmi tínt'é éhe̱n ni xi y'ét'a Moise ko̱ já profeta̱, ta̱ najmi ka̱ma chu̱ba̱yaha̱ ndaha tsa tjín xi kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱.” ");
INSERT INTO majNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","B'i̱ kitsú Jesu nga kinchja̱ko̱ xu̱ta̱ ni'yakuyáha̱: —Tjíhin nga s'e̱ ni xi ts'i̱ínkijnejihi̱n ngatitsun xu̱ta̱, tu̱nga, ¡ni̱ma̱ rú ts'íhin xi ts'i̱ínkijnejin ngatitsun xu̱ta̱ xi kj'a̱í! ");
INSERT INTO majNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tu̱ sahá ra̱ ngandaha̱ xi b'a̱ ts'i̱íu̱n tsa s'e̱t'a 'yúnt'a kásin nku ndji̱o̱ chánka ko̱ chja̱nikj'ajin ntáchak'uu̱n, kintehe̱ ni nga ts'i̱ínkijnejin ngatitsun nku ntí i̱chí xi nkúhu xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Chúhu̱un yjonu̱u. ’Tsa nda̱ nts'ei títs'ín ngatitsun, chu̱bako̱i̱ nga najmi nda títs'ín. Tsa ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱, n'e̱ndyjat'aihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tsa yatu ni̱yá ch'on ts'i̱ínko̱hi nga nku ni̱stjin ko̱ tsa yatu ni̱yá: “Tífikj'aha̱ ra̱ ani̱ma̱na, n'e̱ndyjat'aní”, tsa ku̱i̱tsu̱hi, n'e̱ndyjat'aihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A̱s'a̱i kinchja̱ já postru̱: —Ti̱si̱nko̱ni̱ tu̱ xi 'yún s'e̱jin saha̱ni̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","B'i̱ kitsú Jesu: —Tsa tu̱ i̱chí s'ejinnu̱u Nti̱a̱ná xi nkúhu nku k'un mostasa̱ xi 'yún i̱chí, ka̱ma b'a̱ k'úíhu̱un yá tu xu'bi̱: “Ti̱yú xin e̱i̱ ko̱ t'ihi̱nsi̱njñajin ntáchak'uu̱n.” Ku̱i̱nt'é'énnu̱u yóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Tsa nku xi tíjñajinnu̱u tíjñaha̱ nku nda̱ musu̱ xi kafikján t'anankiu̱ ko̱ tsa chu̱ kafikunntá, nk'ie nga ja k'o̱óyaha jñá nda̱ musu̱, najmi b'a̱ ku̱i̱tsu̱hu̱: “Ti̱tjáha̱nchunt'áí yámixo̱.” ");
INSERT INTO majNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","B'a̱ ní ku̱i̱tsu̱hu̱: “T'endaní ni xi kjíne̱ ko̱ n'e̱sjei najyihi̱n. T'eyání nichinena̱ ko̱ ntá xi k'u̱i̱a̱, ko̱ a̱skahan ka̱ma chi̱ne̱i̱ ko̱ s'i̱ ji.” ");
INSERT INTO majNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ko̱ ta̱ ndaha najmi tsjáha̱ máb'a̱chjíhi̱ nda̱ musu̱hu̱ nk'ie nga ja kuats'íntjusun xá xi kuatsjáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","B'a̱ ta̱ ts'ín jun, nk'ie nga ja n'e̱tjusun ngayjee̱ xá xi kitsjánu̱u Nti̱a̱ná, b'a̱ ní ti̱xíún: “Já musu̱ níi̱. Ni xi kik'inni̱, kui nihi xi kin'ei̱.” ");
INSERT INTO majNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nk'ie nga títs'ín ni̱yá Jesu nga tífi nanki Jerusalen, j'ajin masen a̱nte Samari̱a̱ ko̱ a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nk'ie nga tsichu nku nanki i̱chí, j'aik'úhu̱n te já xi k'uhu̱n ch'in fentujnu. Kui xi kjint'á tsincha ");
INSERT INTO majNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nga kikjintáya: —Ji Jesu, nda̱ maestru̱, katuma ni̱ma̱hi ji̱n. ");
INSERT INTO majNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nk'ie nga kikie Jesu jóo̱, a̱s'a̱i b'i̱ kitsúhu̱: —Tankínkuhu̱u yjonu̱u já na̱'miu̱. Nk'ie nga tíi̱ncha fi jóo̱, tsitjuxín ch'ihin. ");
INSERT INTO majNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","A̱s'a̱i nku nda̱ xi tje̱njihi̱n já xi tee̱, nk'ie nga kikie nga kama nkihi̱, kik'óya ko̱ kits'íntsjoho̱ Nti̱a̱ná nga 'yún kikjintáya. ");
INSERT INTO majNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","J'aisinkúnch'int'aha̱ Jesu nga i̱xí t'anankiu̱hú kingjénsten nintaku̱ ko̱ kitsjáha̱ máb'a̱chjíhi̱. Samari̱a̱ nibáha nda̱ xi b'a̱ kits'íu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","A̱s'a̱i b'i̱ kitsú Jesu: —¿A najmi tehé maha já xi kama nkihi̱? ¿Má kfihi̱ já xi ñja xingisoo̱? ");
INSERT INTO majNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Á tu̱ nkuhú nda̱ xu'bi̱ xi najmi ntje̱ Israel tje̱he̱n ra̱ kuak'óyaha nga kj'u̱a̱i̱ts'íntsjoho̱ ra̱ Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A̱s'a̱i b'i̱ kitsúhu̱ ndo̱: —Ti̱síntje̱i̱n ko̱ t'in. A̱t'aha̱ kuas'ejihin nga Nti̱a̱ná kits'ín nibána, kui nga kama nkihi ri. ");
INSERT INTO majNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","A̱s'a̱i já fariseo̱ kingjásjaiyaha̱ Jesu nkjé ku̱i̱chú ni̱stjin nga ku̱a̱téxuma Nti̱a̱ná. B'i̱ kitsú Jesu: —Tunkaán najmi ka̱ma chjihi̱ nk'ie nga ku̱a̱téxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ko̱ ta̱ ndaha najmi b'a̱ ku̱i̱tsu̱ xu̱ta̱: “E̱i̱ tíjña”, ko̱ a ra̱: “Ján tíjña.” A̱t'aha̱ ja tíbatéxuma Nti̱a̱ná a̱jinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A̱s'a̱i b'a̱ kitsúhu̱ xu̱ta̱ ni'yakuyáha̱: —Ku̱i̱chú ni̱stjin nga ka̱ma mjenu̱u nga cho̱o ndaha tsa tu̱ nku i̱chí ni̱stjin xi s'e̱ nk'ie nga kj'u̱a̱í Ntíhi̱ Nda̱x'i̱u̱n, tu̱nga najmi cha̱nú. ");
INSERT INTO majNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tjín xi b'a̱ ku̱i̱tsu̱nu̱u: “E̱i̱ tíjña”, ko̱ a ra̱: “Ján tíjña.” Tu̱nga najmi tu̱ bankínnú ko̱ ta̱ ndaha najmi tu̱ tsjennkíhu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","A̱t'aha̱ xi nkú ts'ín ma chji nd'ích'o̱n nk'a ján nga bat'ai, nga ma chji e̱i̱ ko̱ ma chji ján, b'a̱ ta̱ ts'ín ka̱ma chji Ntíhi̱ Nda̱x'i̱u̱n ni̱stjin nk'ie nga kj'u̱a̱í ngáha. ");
INSERT INTO majNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tu̱nga títjuhún tjíhin nga un ṉkjún sku̱e̱he̱ ko̱ nga xu̱ta̱ xi tjín nd'a̱i̱ najmi ts'i̱ínkjáíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Xi nkú kama ni̱stjin nga y'ejña Noe, b'a̱ ta̱ ka̱ma ni̱stjin nk'ie nga kj'u̱a̱í ngáha Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kui ni̱stjiu̱n tíi̱ncha kjine ko̱ tíi̱ncha 'bi xu̱ta̱. Tíi̱ncha bixan ko̱ tíi̱ncha ts'ínkixan ntíhí. B'a̱ tíi̱ncha ts'ín santa nkúhu nga tsichu ni̱stjin nga jas'en Noe tsutsu chánkoo̱, ko̱ tu̱ ni xí kik'ahá ts'í ko̱ jesunjin ntá ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ko̱ b'a̱ ta̱ kama ni̱stjin nga y'ejña Lot. Tíi̱ncha kjine ko̱ tíi̱ncha 'bi xu̱ta̱. Tíi̱ncha b'atse ni ko̱ tíi̱ncha batéña ni. Tíi̱ncha b'éntje̱ ko̱ tíi̱ncha ts'ínnda ni'ya. ");
INSERT INTO majNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tu̱nga ni̱stjin nga tsitju Lot nanki Sodoma̱, nibajen nk'a ján nd'í ko̱ sufri̱ nga tsixuntu t'anankiu̱. Jesun ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","B'a̱ ta̱ ka̱ma ni̱stjin nk'ie nga ku̱a̱kúchji yjoho̱ Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Kui ni̱stjin xu'bo̱, xi kab'ejñasun nk'a ni'yaha̱ najmi tu̱ ku̱i̱tjujen nga kj'u̱a̱ík'asje ni xi tjíntu a̱ya ni'yaha̱. Ko̱ xi kafi jñá najmi ta̱ kats'óyaha ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","N'e̱kj'áítsjoho̱on yjonu̱u ni xi kamat'ain chju̱úhu̱n Lot. ");
INSERT INTO majNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tu̱ yáhá ni xi mjehe̱ ts'i̱ínk'anki suba yjoho̱ nga k'úéjña tík'un, kui xi tu̱ sahá ku̱a̱yá. Tu̱nga xi ku̱a̱yá, kui xi tu̱ sahá n'e̱k'anki. ");
INSERT INTO majNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","An b'a̱ tíxinnu̱u. Kui ni̱stje̱n xu'bo̱ jo xu̱ta̱ xi kjintusún nku kama̱, nku chjúbé ko̱ xinkuu̱ s'e̱jña. ");
INSERT INTO majNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jo jminchjín xi tíi̱ncha ot'áha̱ xinkjín, nku chjúbé ko̱ xinkuu̱ s'e̱jña. ");
INSERT INTO majNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jo já xi kafi jñá, nku chjúbé ko̱ xinkuu̱ s'e̱jña. ");
INSERT INTO majNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","B'a̱ kitsú jóo̱: —Ji Nda̱ Nti̱a̱, ¿má xi tje̱hen b'a̱ ka̱moo̱? B'i̱ kitsú Jesu: —Yaha̱ nga má kjijña nku yjoninte k'ien, yo̱ ma ñjakú chálíkíe̱. B'a̱ ta̱ ts'ín cha̱ha̱ nga kj'u̱a̱í Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A̱s'a̱i Jesu y'éjña chu̱ba̱yaha̱ xu̱ta̱ ni'yakuyáha̱ nga tsakúyaha̱ nga tjíhin nga tehe̱nte ku̱i̱nchja̱ Nti̱a̱ná ko̱ nga najmi ts'i̱ínkjehe̱ k'un. ");
INSERT INTO majNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","B'i̱ kitsúhu̱: —Nku nanki y'ejña nku nda̱ jue xi najmi benkjún Nti̱a̱ná ko̱ ta̱ ndaha najmi nusihi̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Yo̱ ta̱ y'ejña nku ta̱chju̱ún xi ja k'ien x'i̱hi̱n. Kui xi fisehe̱ nda̱ jue nga b'a̱ tsuhu̱: “Kixi̱ n'e̱ní kju̱a̱ xi tjínko̱na chá kontra̱na̱.” ");
INSERT INTO majNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nkjin ni̱stjin j'a nga najmi kits'íhi̱n kju̱a̱ ta̱chjúu̱n. Tu̱nga a̱skahán ni kits'ínnkjink'un: “Ndaha tsa najmi benkján Nti̱a̱ná ko̱ najmi nusinna xu̱ta̱, ");
INSERT INTO majNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tu̱nga tu̱ nku títs'ínstihína ta̱chjíi̱n. Kui nga tu̱ sahá kixi̱ ts'ihi̱n ra̱ kju̱a̱ tu̱ xi najmi ts'i̱ínkjehe kju̱a̱tsentana̱ nga kj'u̱a̱íse tehe̱ntena.” ");
INSERT INTO majNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","B'i̱ kitsú sa Nda̱ Nti̱a̱ná Jesu: —Nda ta̱sinñju ni xi kitsú nda̱ jue ch'onk'un xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nti̱a̱ná, ¿a najmi kixi̱hí ts'i̱íhi̱n kju̱a̱ xu̱ta̱ xi j'ájin, xi ni̱stjin ni̱stje̱n nchja̱ko̱ho̱? ¿A ts'i̱ínk'andayahá nga ku̱a̱si̱nko̱? ");
INSERT INTO majNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","B'a̱ tíxinnu̱u nga ntju̱úhu̱n ts'i̱íhi̱n kju̱a̱ xu̱ta̱ xi ts'e̱. Tu̱nga nk'ie nga kj'u̱a̱í ngáha Ntíhi̱ Nda̱x'i̱u̱n, ¿a sa̱kú saha̱ a̱sunntee̱ xu̱ta̱ xi s'ejihi̱n Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ta̱ y'éjña chu̱ba̱yaha̱ Jesu nga tsakúyaha̱ xu̱ta̱ xi b'a̱ maha̱ nga na̱xu̱ tíi̱ncha ts'ín nginku̱n Nti̱a̱ná maha̱, tu̱nga najmi ndahá ts'ín basehe̱ xu̱ta̱ xingisoo̱. B'i̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Jo já ngji nchja̱ko̱ Nti̱a̱ná má ma na̱tsihi̱n ni̱nku̱, nku xi nda̱ fariseo̱ ko̱ nku nda̱ xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nda̱ fariseo̱ b'i̱ ts'ín kinchja̱ko̱ Nti̱a̱ná nga ngandaha̱ kinchja̱ nk'ie nga kabasinjña ndju: “Ji Na̱'mi, títsjaha máb'a̱chjí a̱t'aha̱ najmi b'a̱ k'an xi nkú k'un xu̱ta̱ xi k'oo̱, xi ndyjé ts'ín, xi ch'onk'un, xi b'at'aha̱ chju̱úhu̱n. Ko̱ ta̱ ndaha najmi b'a̱ k'an xi nkúhu nda̱ xu'bi̱ xi f'áchjíntjai ch'á. ");
INSERT INTO majNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jo ni̱yá nga tuntjóo̱ báte̱jña kjintíá ko̱ nku tíkjá ngayjee̱ ni xi ts'in ngana̱ tsja chje̱.” ");
INSERT INTO majNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Tu̱nga nda̱ xi f'áchjíntjai ch'á kjin tsasinjña ko̱ santaha najmi ma k'un tsa nk'a ján ku̱a̱se̱njinki. Tu̱ kik'onyahá 'me̱he̱ nga b'i̱ kitsú: “Ji Na̱'mi, katuma ni̱ma̱hi an nga jé tje̱nna.” ");
INSERT INTO majNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","An b'a̱ tíxinnu̱u. Nku nda̱ xi na̱xu̱ kama nda̱i̱ nginku̱n Nti̱a̱ná nk'ie nga kik'óya ngáha ni'yaha̱. Najmi b'a̱ha nda̱ xinkuu̱. A̱t'aha̱ tu̱ yáhá ni xi k'u̱a̱sjenk'a suba yjoho̱, kui xi i̱chí ka̱ma nginku̱n Nti̱a̱ná. Ko̱ xi k'u̱a̱sje ni̱ma̱kju̱a̱ yjoho̱, kui xi sa̱kúhu̱ kju̱a̱chánka. ");
INSERT INTO majNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A̱s'a̱i i̱ncha j'aiko̱ xu̱ta̱ ntíhi̱ tu̱ xi Jesu ngju̱énnehe̱ ra̱ ntsja. Tu̱nga nk'iehé nga kikie já ni'yakuyóo̱ nii̱, b'a̱ kitsúhu̱ xu̱ta̱ nga najmi b'a̱ i̱ncha ts'i̱ín. ");
INSERT INTO majNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tu̱nga kinchja̱há ra̱ Jesu jóo̱ ko̱ b'i̱ kitsúhu̱: —Tjehe̱nntoho̱ jántíu̱ nga kanibásena. Najmi tu̱ jun b'ech'óho̱o. A̱t'aha̱ xu̱ta̱ xi b'a̱ ts'ín tjíntuyáha̱ xi nkú joyaha jántí xi̱, kui xi tje̱he̱n ra̱ nga Nti̱a̱ná ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kju̱axi̱ ni xi tíxinnu̱u. Xi najmi ts'i̱ínkjáíhi̱n nga Nti̱a̱ná xi batéxumaha̱ xi nkú ts'ín ts'ínkjáíhi̱n nku nda̱ chí ni xi 'ba̱i̱hi̱, kui xi ndaha̱chí najmi kju̱a̱s'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A̱s'a̱i nku nda̱ k'aku̱ kingjásjaiyaha̱ Jesu: —Ji nda̱ maestru̱, ji xi ndai, ¿mí nihi xi ts'ian tu̱ xi ka̱ma ts'inkjáíhi̱n ra̱ nga kúáte̱jña tík'un síán? ");
INSERT INTO majNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A̱s'a̱i b'i̱ kitsú Jesu: —¿Á an xi nda tí'mihiní? Najmi tjín xi ndaha̱, nku tutuhú Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yai xi nkú ts'ín tjít'a kju̱a̱téxumoo̱: “Najmi tu̱ biyunéí kju̱a̱bixoo̱n. Najmi tu̱ n'ek'iein. Najmi tu̱ ndyjé n'ei. Najmi tu̱ testiyu̱ tsank'á n'ei. Cha̱nkjúín na̱'mihi̱ ko̱ na̱ahi̱.” ");
INSERT INTO majNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","B'a̱ kitsú ndo̱: —Ngayjee̱ ni xu'bo̱ títs'intjusan santa nkúhu nga ndyjana. ");
INSERT INTO majNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nk'ie nga kint'é Jesu ni xu'bi̱ b'a̱ kitsú: —Nku ni ndyjat'á sahi. Ta̱teñai ngayjee̱ ni xi tjíhin ko̱ tjeihi̱n xu̱ta̱ x'a̱n. B'a̱ ts'ín s'e̱he ri kju̱a̱nchi̱ná ndji̱o̱jmi ján. A̱s'a̱i nibáí nga tsjénnkiní. ");
INSERT INTO majNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tu̱nga nk'iehé nga kint'é ndo̱ éi̱n, kik'ie nusin nusihi̱n, a̱t'aha̱ 'yún ṉkjún nchi̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nk'ie nga kikie Jesu nga kik'ie nusin nusihi̱n ndo̱, b'i̱ kitsú: —¡Á b'a̱ 'yún 'ni tjíhin tsa xu̱ta̱ xi nchi̱ná ṉkjúhun kju̱a̱s'enjihin nga Nti̱a̱ná ku̱a̱téxumaha̱! ");
INSERT INTO majNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tu̱ sahá najmi 'ni tjín tsa nku chu̱ camello̱ kju̱a̱s'en ti̱xa̱ha̱ nku nintu nga nku nda̱ nchi̱ná kju̱a̱s'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A̱s'a̱i xu̱ta̱ xi kint'éhe̱ b'a̱ i̱ncha kitsú: —¿Yá xi ka̱ma k'u̱a̱nki ni̱ ma? ");
INSERT INTO majNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","B'i̱ kitsú Jesu: —Ni xi ndaha̱chí najmi maha̱ ts'ín xu̱ta̱, Nti̱a̱ná maha̱ ts'ín nii̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A̱s'a̱i b'a̱ kitsú Pedro̱: —Xi nkúhu ji̱n, ja y'entui̱ ni xi tjínni̱ ko̱ tje̱nnkihi̱ nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Tu̱ yáhá ni xi y'éjña ni'yaha̱, tsa chju̱úhu̱n, tsa já nts'e̱, tsa xi cháha̱ ko̱ tsa ntíhi̱ a̱t'aha̱ Nti̱a̱ná batéxumaha̱, ");
INSERT INTO majNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kui xu̱ta̱i̱ 'yún ts'ati k'u̱a̱i̱ ngáha̱ ra̱ a̱sunnte xu'bi̱ ko̱ ni̱stjin xi nibá a̱skahan k'u̱a̱i̱hi̱ nga k'úéntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A̱s'a̱i ngjiko̱ t'axín Jesu já ni'yakuyá xi te joo̱ ko̱ b'a̱ kitsúhu̱: —Tjenñju. Ja tíbankíaán nanki Jerusalen. Yo̱ ku̱i̱tjusun ngayjee̱ ni xi y'ét'a já profeta̱ nga ka̱maha̱ Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A̱t'aha̱ a̱ya ntsja xu̱ta̱ xi najmi ntje̱ Israel tje̱he̱n ra̱ n'e̱kjas'en. Kui xi ku̱a̱jnu̱kiehe̱, ch'on ts'i̱íhi̱n, ko̱ ku̱a̱tétéjnuhu̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","K'u̱éhe̱ ko̱ ts'i̱ínk'ien. Tu̱nga ni̱stjin xi ma jahan kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ndaha nku ni xu'bi̱ najmi kamankjihi̱n já ni'yakuyóo̱. Najmi be ni xi tínchja̱ Jesu, a̱t'aha̱ kis'ejña 'maha̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nk'ie nga ja tíbichú tiña Jesu nanki Jerico, nku nda̱ ka̱ kab'ejña a̱ndai ni̱yóo̱ nga tíbanki chje̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nk'ie nga kint'é ndo̱ nga tíf'a ṉkjún xu̱ta̱, a̱s'a̱i kingjásjaiya mí nihi xi tíma. ");
INSERT INTO majNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kik'inyaha̱ nga Jesu, nda̱ xi nibáha Nazaret, tíf'a yo̱. ");
INSERT INTO majNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A̱s'a̱i kikjintáya: —¡Ji Jesu, ji xi ntje̱he̱ David, katuma ni̱ma̱hi an! ");
INSERT INTO majNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Xu̱ta̱ xi yja títjuu̱n kinchja̱tiko̱ho̱ tu̱ xi k'u̱échja'aha ts'a, tu̱nga tu̱ sahá 'yún kikjintáya sa: —¡Ji ntje̱he̱ David, katuma ni̱ma̱hi an! ");
INSERT INTO majNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A̱s'a̱i tsasin'yún Jesu ko̱ b'a̱ kitsú nga ngju̱a̱i̱chj'a nda̱ ko̱. Nk'ie nga ja j'ai, Jesu kingjásjaiyaha̱: ");
INSERT INTO majNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Mí xi mjehi nga ts'ihin? B'a̱ kitsú nda̱ ko̱: —Ji nda̱ maestru̱, mjena nga ka̱ma chjina. ");
INSERT INTO majNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","B'i̱ kitsú Jesu: —Katuma chjihi. A̱t'aha̱ kuas'ejihin nga Nti̱a̱ná kits'ín nibána, kui nga kama nkihi ri. ");
INSERT INTO majNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ta̱ kuihi chu̱bo̱ kama chjihi̱ ndo̱ ko̱ kitsjennkíhi̱ Jesu nga kits'íntsjoho̱ Nti̱a̱ná. Ko̱ ta̱ kits'íntsjoho̱ Nti̱a̱ná ngayjee̱ xu̱ta̱ xi kikie ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","A̱s'a̱i tsichu Jesu nanki Jerico. J'ajin nankiu̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yo̱ tíjña nku nda̱ nchi̱ná xi 'mi Zakeo̱, xi nda̱ k'aku̱hu̱ já xi f'áchjíntjai ch'á nga ts'ínxát'aha̱ já Roma̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kui xi mjehe̱ sku̱e̱ yáha Jesu, tu̱nga najmi tímahá ra̱, a̱t'aha̱ katsehe xu̱ta̱ ko̱ ch'e̱ ṉkjún ya Zakeo̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A̱s'a̱i tsangatsanka títjuhu̱n xu̱ta̱ nkjiu̱n ko̱ tsiyajnu nku yá xi síjña yo̱, tu̱ xi sku̱e̱he Jesu, a̱t'aha̱ yo̱ tjíhin nga kj'u̱a̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nk'ie nga ja tíf'a Jesu yo̱, tsasenjinki má kji'a ndo̱ ko̱ b'i̱ kitsúhu̱: —Ji Zakeo̱, ki̱tsa̱ ti̱tjuje̱i̱n, a̱t'aha̱ ni'yahi̱ tjíhin nga ts'inkj'áíya nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A̱s'a̱i ki̱tsa̱ tsitjujen Zakeo̱ ko̱ tsjo kamaha̱ nga kits'ínkjáíhi̱n Jesu ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tu̱nga nk'ie nga kikie xu̱ta̱ ni xu'bi̱, a̱s'a̱i ngayjee̱ kinchja̱yane Jesu nga b'a̱ kitsúhu̱ xinkjín: —Ni'yaha̱ nku nda̱ xi najmi ts'íntjusun kju̱a̱téxumaha̱ Moise kfi ts'ínkj'áíya. ");
INSERT INTO majNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A̱s'a̱i tsasinjña ndju Zakeo̱ ko̱ b'a̱ kitsúhu̱ Jesu: —Cha̱se̱i̱, nda̱ maestru̱. Tsjaha̱ xu̱ta̱ x'a̱n masen ni xi tjínna. Ko̱ tsa tjín xi ndyjé kits'ihi̱n nga ts'ana̱cha̱ha̱, ts'ink'óya ngáha̱ ra̱ ñju ni̱yá tjíhin ni xi jakj'aha̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","B'i̱ kitsú Jesu: —Ja k'uanki nd'a̱i̱ xu̱ta̱ xi tjíntu ni'ya xu'bi̱, a̱t'aha̱ ta̱ ntje̱he̱ ntje̱ chjáná Abraham y'aha̱ ra̱ nda̱ xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A̱t'aha̱ Ntíhi̱ Nda̱x'i̱u̱n j'aingisjáí ko̱ j'ai ts'ínk'anki xu̱ta̱ xi ja kindyja. ");
INSERT INTO majNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nk'ie nga tímjéñju xu̱ta̱ ni xi tínchja̱ Jesu, a̱s'a̱i ta̱ y'éjña chu̱ba̱ya ngáha nga tsakúya. A̱t'aha̱ ja tíbichú tiña nanki Jerusalen ko̱ b'a̱ tímaha̱ xu̱ta̱ nga a̱kui ku̱a̱téxumahá Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kui nga b'a̱ kitsúhu Jesu: —Y'ejña nku nda̱ nchi̱ná xi ngji kjin kj'a̱í nanki tu̱ xi nda̱ rei̱ n'e̱ maha ko̱ a̱skahan k'o̱óya ngáha. ");
INSERT INTO majNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A̱s'a̱i kinchja̱ha̱ te já musu̱hu̱ ko̱ kitsjáha̱ to̱on nga nkúnkú jóo̱. “N'e̱xáko̱o to̱oi̱n santa nkúhu nga kjúái̱ ngáhana”, kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","’Tu̱nga unkiehé ra̱ xu̱ta̱ nankihi̱ ndo̱ ko̱ i̱ncha kits'ínkji tje̱nnki ndo̱ já chji̱ne̱'én xi b'a̱ ku̱i̱tsu̱: “Najmi mjeni̱ tsa kui nda̱i̱ xi ka̱ma nda̱ rei̱ni̱.” ");
INSERT INTO majNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tu̱nga kin'e mahá nda̱ rei̱ ndo̱ ko̱ kik'óya ngáha nankihi̱. A̱s'a̱i kitsjá kju̱a̱ nga chu̱baha̱ já musu̱ xi kitsjáha̱ to̱on, tu̱ xi sku̱e̱he xi nkú tjín kits'ín ngana̱sun nga nkúnkú jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","’A̱s'a̱i j'ai nda̱ xi tjuu̱n. “Ji nda̱ nti̱a̱, te tjíhin nga kits'ín ngana̱sun to̱ohi̱n”, kitsú. ");
INSERT INTO majNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Nda tjín. Nda ní ji, nda̱ musu̱. Na̱xu̱ kin'etjusuin xá i̱chí xi kitsjaha, kui nga tsjaha ra nga ku̱a̱texumaha̱ ri̱ te nanki”, kitsú nda̱ rei̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A̱s'a̱i j'ai nda̱ musu̱ xi ma joho. “Ji nda̱ nti̱a̱, un tjíhin nga kits'ín ngana̱sun to̱ohi̱n”, kitsú. ");
INSERT INTO majNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ji xi ku̱a̱texumaihi̱ un nanki”, ta̱ kitsúhu̱ nda̱ musu̱ xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’A̱s'a̱i j'ai ngá kj'a̱í nda̱ musu̱. “Ji nda̱ nti̱a̱, á to̱ohi̱n ngáha e̱i̱. Nku pañu̱ kik'ontikjájian nga y'etjá, ");
INSERT INTO majNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","a̱t'aha̱ tsankjuhun. A̱t'aha̱ kjan ní ji. Chjubéí ni xi najmi ji y'ejñai ko̱ chjusíntje̱i̱n cha̱n xi najmi ji y'entje̱i̱”, kitsú. ");
INSERT INTO majNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A̱s'a̱i b'a̱ kitsú nda̱ rei̱: “Ji nda̱ musu̱ ch'onk'un, ta̱ kuihi én xi kuakixín ts'inko̱kju̱a̱hara. Tsa an xi kjan ko̱ fakj'a ni xi najmi an y'ejñá ko̱ kjesíntje̱n cha̱n xi najmi an y'entje̱, ");
INSERT INTO majNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kui nga, ¿á najmi kin'ekjas'ehe̱n ri̱ to̱onna̱ já xi be nkú ts'ín ts'ínxáko̱ho to̱on? Tsa b'a̱ kin'ei, ja ra̱ ts'inkjáín ngáha̱ ra̱ nd'a̱i̱ to̱onna̱ ko̱ santaha ntíhi̱ nga kjúa̱”, kitsú. ");
INSERT INTO majNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","’A̱s'a̱i kinchja̱ko̱ nda̱ rei̱ já xi kabincha yo̱. “Chjú'oho̱o to̱oo̱n nda̱ xu'bi̱ ko̱ tjoho̱on nda̱ xi tíjñaha̱ te”, kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ji nda̱ nti̱a̱, ja tíjñaha̱ te to̱on nda̱ xu'bo̱”, kitsú jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tu̱nga b'a̱há kitsú nda̱ rei̱: “An b'a̱ tíxinnu̱u. Ngayjee̱ xi tjíhi̱n ni, kui xi k'u̱a̱i̱ saha̱. Tu̱nga xi najmi tjíhi̱n, kui xi chjú'aha̱ santaha ni xi i̱chí xi tíjñaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ko̱ máha já kontra̱na̱ xi najmi mjehe̱ nga kuatexumaha̱, nibáko̱o e̱i̱ ko̱ nginkán ti̱chákjó kásin.” ");
INSERT INTO majNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nk'ie nga ja b'a̱ kitsú Jesu, a̱s'a̱i kitsjen títjun nga kits'ínndju̱ú ngáha ni̱yáha̱ nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nk'ie nga ja tsichu tiña Betfage ko̱ Betani̱a̱, nanki xi tiña maha̱ a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱, a̱s'a̱i kits'ínkji Jesu jo já ni'yakuyáha̱ ");
INSERT INTO majNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nga b'i̱ kitsúhu̱: —Tankíún nanki i̱chí xi tíjña tiña ján. Nk'ie nga ja ku̱i̱chú yo̱, sa̱kúnu̱u nku ntí búrrú xi tjít'a'yún, xi najmi kje̱e ch'a b'esúhu̱n. Chjúnndáyo ko̱ nibáko̱o e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ko̱ tsa tjín xi ngju̱ásjaiyanu̱u: “¿Á jun tíchjundáyahanu chu̱?”, tsa ku̱i̱tsu̱nu̱u, b'a̱ t'ihu̱un: “Nda̱ maestru̱ rú machjéhe̱n chu̱.” ");
INSERT INTO majNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A̱s'a̱i ngji já xi kin'ekjíu̱ ko̱ kisakúhu̱ chu̱ xi nkú nga kitsú Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nk'ie nga ja tíi̱ncha kjendáya ntí búrrúu̱, a̱s'a̱i b'a̱ kitsú já xi ts'e̱ chu̱: —¿Á jun tíchjundáyahanu ntí búrrúu̱? ");
INSERT INTO majNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","B'a̱ kitsú jóo̱: —Nda̱ maestru̱ rú machjéhe̱n chu̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","I̱ncha j'aiko̱ho̱ Jesu chu̱. Najyuhu̱n i̱ncha kingjásuhu̱n chu̱ ko̱ kits'ínk'íésun Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Xi nkú nga ts'ín tífi Jesu, b'a̱ ts'ín kingjántu najyuhu̱n xu̱ta̱ a̱ya ni̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nk'ie nga ja tíi̱ncha bichú tiña má jenstehe̱n a̱sunntu tje̱nki̱ Yá Olivo̱, a̱s'a̱i ngayjee̱ xu̱ta̱ ni'yakuyáha̱ Jesu 'yún i̱ncha kikjintáya tsjo nga kits'íntsjoho̱ Nti̱a̱ná nga̱t'aha̱ ngayjee̱ kju̱a̱nkjún xi i̱ncha kikie. ");
INSERT INTO majNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","B'a̱ i̱ncha kitsú xu̱to̱: —¡Nti̱a̱ná nda kats'ínko̱ nda̱ rei̱ xi kits'ín nibá ngajoho̱! ¡Kas'e kju̱a̱jyu ndji̱o̱jmi ján ko̱ kaya kju̱a̱chánkaha̱ Nti̱a̱ná nk'a ján! ");
INSERT INTO majNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A̱s'a̱i kinchja̱ k'u̱a̱ já fariseo̱ xi tje̱njihi̱n xu̱ta̱ nkjiu̱n: —Ji nda̱ maestru̱, b'a̱ t'ihi̱n xu̱ta̱ ni'yakuyáhi̱ nga najmi tu̱ b'a̱ i̱ncha kats'ín. ");
INSERT INTO majNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","B'i̱ kitsú Jesu: —B'a̱ tíxinnu̱u, tsa k'u̱échja ts'a xu̱ta̱ xu'bi̱, ndji̱o̱ i̱ncha kji̱ntáya. ");
INSERT INTO majNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nk'ie nga j'ai tiña Jesu nanki Jerusalen, kikjintántjai nankiu̱ nk'ie nga kikie. ");
INSERT INTO majNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","B'i̱ kitsú: —¡Tsa tu̱ kui sa ni̱stjin xu'bi̱ ka̱mankjinnu̱u ni xi tsjánu̱u kju̱a̱jyu! Tu̱nga tíjña 'mahánu̱u niu̱ nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","A̱t'aha̱ ku̱i̱chú ni̱stjin nga já kontra̱nu̱u k'u̱étjindainu̱u xjó nga k'u̱échjanu̱u tu̱ xi ts'i̱ínkjehe̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ts'i̱ínkjenu̱u ko̱ ts'i̱ínk'ien xu̱ta̱ nankinu̱u. Ndaha nku ndji̱o̱ najmi ta̱ s'e̱jñasun saha̱ ra̱ xinkjín. A̱t'aha̱ najmi kamankjinnu̱u nk'ie nga y'éjña chjinu̱u Nti̱a̱ná kju̱a̱ndaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","A̱s'a̱i jas'en Jesu má ma na̱tsihi̱n ni̱nku̱. Kik'onsje já xi tíi̱ncha batéña ko̱ tíi̱ncha b'atse chu̱ yo̱. ");
INSERT INTO majNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","B'i̱ kitsúhu̱: —B'a̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “Ni'ya xi má nga ku̱i̱nchja̱ko̱ xu̱ta̱ Nti̱a̱ná ka̱ma ni'yana̱.” Tu̱nga jun a̱ntehe̱ já ndyjé tín'e mo. ");
INSERT INTO majNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Xki̱ ni̱stjin tsakúya Jesu na̱tsihi̱n ni̱nku̱. Ko̱ já na̱'mi k'aku̱, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já xi yankjúhu̱n i̱ncha tsangisjai ni̱yá xi nkú ts'ín ka̱ma ts'i̱ínk'iehen Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tu̱nga najmi tísakú ni̱yáhá ra̱ nkú ts'ín b'a̱ i̱ncha ts'i̱ín, a̱t'aha̱ ngayjee̱ xu̱ta̱ 'yún mjehe̱ nga ku̱a̱sínñjuhu̱ ni xi tínchja̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nku ni̱yá nk'ie nga tíbakúya Jesu má ma na̱tsihi̱n ni̱nku̱ nga y'éni̱jmíhi̱ xu̱ta̱ én nda tsuhu̱ Nti̱a̱ná, a̱s'a̱i j'aik'úhu̱n já na̱'mi k'aku̱, já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ jáchá xi ta̱ tjíhi̱n xá. ");
INSERT INTO majNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","B'a̱ i̱ncha kitsúhu̱: —T'inyani̱, ¿mí xá xi tjíhin nga b'a̱ tín'ei? ¿Yá xi kitsjá xáhi? ");
INSERT INTO majNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","B'i̱ kitsú Jesu: —Ko̱ an ta̱ kuasjáíyanu̱u nku ni. T'inyanú. ");
INSERT INTO majNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Yá xi kits'ín nibáha̱ Jua Bautista̱ nga j'aiténtá xu̱ta̱? ¿A Nti̱a̱ná, a ra̱ xu̱ta̱ a̱sunntei̱hí? ");
INSERT INTO majNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A̱s'a̱i b'i̱ kitsúhu̱ xinkjín nga kinchja̱ni̱jmíyaha niu̱: —Tsa: “Nti̱a̱ná kits'ín nibáha̱ Jua”, ku̱i̱xíaán, a̱s'a̱i b'a̱ ku̱i̱tsu̱ná: “¿Á najmi kis'ejihi̱nnu̱u ni xi kitsúhu Jua?” ");
INSERT INTO majNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ko̱ tsa: “Xu̱ta̱ a̱sunntei̱ kits'ín nibáha̱” ku̱i̱xíaán, ngayjee̱ xu̱ta̱ k'u̱éná ndji̱o̱ nga ts'i̱ínk'ienná, a̱t'aha̱ b'a̱ tsu xu̱ta̱ nga nku nda̱ profeta̱ kama Jua. ");
INSERT INTO majNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","A̱s'a̱i kinchja̱ko̱ ngáha Jesu: —Najmi yai̱ yá xi kits'ín nibáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A̱s'a̱i b'i̱ kitsú Jesu: —Ko̱ ta̱ ndaha an najmi xínyanu̱u yá xi kitsjána nga b'a̱ títs'ian. ");
INSERT INTO majNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","A̱s'a̱i Jesu b'i̱ ts'ín tsakúyaha̱ xu̱ta̱ nga y'éjña chu̱ba̱yaha̱: —Nku nda̱ y'éntje̱ tuntsja̱jé. Kitsjá sáha̱ a̱ntee̱ já xi maha̱ ts'ínxáko̱ tuntsja̱jée̱, a̱s'a̱i ngji kjin tse ṉkjún ni̱stjin. ");
INSERT INTO majNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nk'ie nga ja tíjne tuu̱, a̱s'a̱i kits'ínkjisehe̱ ndo̱ nku nda̱ musu̱hu̱ já xi títs'ínxáko̱ tuntsja̱jée̱ tu̱ xi ku̱a̱nkihi̱ ra̱ tu xi kanéhe̱. Tu̱nga kik'íéhé ra̱ jóo̱ nda̱ musu̱hu̱ ko̱ kits'ínkji tiya tiya. ");
INSERT INTO majNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A̱s'a̱i ta̱ kits'ínkjihí ngáha ndo̱ kj'a̱í nda̱ musu̱, tu̱nga ta̱ kik'íéhé ngáha̱ ra̱ jóo̱ nda̱ musu̱ xu'bi̱. Ch'on ṉkjún i̱ncha kitsúhu̱ ko̱ kits'ínkji tiya tiya. ");
INSERT INTO majNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ta̱ kits'ínkjihí ngáha kj'a̱í nda̱ musu̱hu̱ ndo̱, tu̱nga ta̱ kits'ín'uhún ngáha̱ ra̱ jóo̱ nda̱ xu'bi̱ nga tsanka tje̱nnki. ");
INSERT INTO majNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Tu̱ chahán b'i̱ kitsú nda̱ xi ts'e̱ tuntsja̱jée̱: “¿Mí nihi xi ts'ian? Tu̱ sahá ntína̱ xi tjo ṉkjúnna ts'inkjíá. Tsa tu̱ ahá ni sku̱e̱nkjún ntína̱ jóo̱.” ");
INSERT INTO majNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tu̱nga nk'iehé nga kikie já xi ts'ínxáko̱ tuntsja̱jée̱ nga nibá ntíhi̱ ndo̱, b'a̱ kitsúhu̱ xinkjín: “Kui xu'bo̱ xi ts'i̱ínkjáíhi̱n ngayjee̱ ni xi tjíhi̱n na̱'mihi̱. Tu̱ sahá n'e̱k'ieén tu̱ xi ka̱ma ts'a̱ñáhaná ni xi ts'i̱ínkjáíhi̱n.” ");
INSERT INTO majNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kui nga kik'onsjehe jóo̱ ntíhi̱ ndo̱ na̱tsin má nga tjíntje̱ tuntsja̱jée̱ ko̱ kits'ínk'ien. ’Kui b'a̱ maha, ¿nkú ts'i̱íhi̱n ra̱ nda̱ xi ts'e̱ tuntsja̱jée̱ já xu'bo̱? ");
INSERT INTO majNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kj'u̱a̱í ko̱ ts'i̱ínkje já xi ts'ínxáko̱ tuntsja̱jée̱ ko̱ kj'a̱í já tsjá sá ngáha̱ ra̱ a̱nte tuntsja̱jée̱. Nk'ie nga kint'é ni xu'bi̱ xu̱ta̱ xi tíi̱ncha yo̱, a̱s'a̱i b'a̱ i̱ncha kitsú: —¡Najmi b'a̱ tu̱ katuma! ");
INSERT INTO majNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tu̱nga tsase'ahá Jesu jóo̱ ko̱ b'i̱ kitsúhu̱: —Kui nga, ¿nkú tsuhu̱ ra̱ ma ni xu'bi̱ xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná? B'a̱ títsu̱: Ndji̱o̱ xi kikjaníya já chji̱ne̱xóo̱, ja j'ai ma ndji̱o̱ k'aku̱. ");
INSERT INTO majNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tu̱ yáhá ni xi ku̱i̱jne̱sun ndji̱o̱ xu'bi̱ ka̱ma xi̱xi̱. Ko̱ xi ku̱i̱jne̱nehe̱ ndji̱o̱ ka̱ma nku̱a̱nku̱a̱n. ");
INSERT INTO majNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ta̱ kuihi chu̱bo̱ mjehe̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ nga ku̱a̱kj'ánijé Jesu, a̱t'aha̱ kamankjihi̱n nga kui kinchja̱ni̱jmíyaha nga y'éjña chu̱ba̱ya. Tu̱nga i̱ncha kitsankjúhún xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A̱s'a̱i kits'ín nibásehe̱ Jesu k'u̱a̱ já xi kúnnta 'maha̱, xi xu̱ta̱ nda kits'ín ma maña̱ yjoho̱, tu̱ xi ts'i̱ínkijnejihin Jesu nku én xi najmi b'a̱ tjín. B'a̱ ts'ín ka̱ma ts'i̱ínkjas'ehe̱n ra̱ nda̱ tjíxá Roma̱. ");
INSERT INTO majNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","B'a̱ i̱ncha j'ai tsúhu̱: —Ji nda̱ maestru̱, yai̱ nga kju̱axi̱ én xi chubai nga bakuyáí ko̱ nga najmi ngabi n'ei kju̱a̱. Na̱xu̱ bakuyáí éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kui nga, ¿a ma b'echjíhi̱í nda̱ títjun Cesa̱r ni xi f'áchjíná, a ra̱ najmi? ");
INSERT INTO majNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tu̱nga kamankjihín ra̱ Jesu kju̱a̱maña̱ha̱ jóo̱ ko̱ b'a̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ta̱kúnú nku to̱on denari̱o̱. ¿Yá xi ts'e̱ sénni̱stjii̱n ko̱ j'áín xi tjít'aha̱ to̱oi̱n? B'a̱ kitsú jóo̱: —Ts'e̱ nda̱ títjun Cesa̱r. ");
INSERT INTO majNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A̱s'a̱i b'i̱ kitsú Jesu: —Tjoho̱on nda̱ títjun Cesa̱r ni xi ts'e̱ nda̱ títjun Cesa̱r, ko̱ tjoho̱on Nti̱a̱ná ni xi ts'e̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Najmi kamaha̱ jóo̱ kits'ínkijneya Jesu nga ku̱i̱nchja̱ nginku̱n xu̱ta̱ na̱nti̱o̱ nku én xi najmi b'a̱ tjín. Tu̱ sahá kama nkjúhu̱n én xi kits'ínk'óya Jesu ko̱ najmi ta̱ kinchja̱ha. ");
INSERT INTO majNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Já saduseo̱ bakúya nga najmi kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱. A̱s'a̱i k'u̱a̱ xi j'aisehe̱ Jesu nga ");
INSERT INTO majNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","kingjásjaiyaha̱. B'i̱ i̱ncha kitsúhu̱: —Ji nda̱ maestru̱, y'ét'aná Moise: “Tsa nku nda̱ xi tíjñaha̱ chju̱ún kju̱a̱yá nga najmi kis'eko̱ho̱ ntí chju̱úhu̱n, nda̱ nts'e̱ tjíhin nga ku̱i̱xanko̱ ngáha chju̱úhu̱n, tu̱ xi b'a̱ ts'ín s'e̱he̱ ra̱ ntí nda̱ nts'e̱ xi k'ie̱n.” ");
INSERT INTO majNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Y'entu yatu já xi nts'e̱ maha xinkjín. Tsixan nda̱ xi tjuu̱n tu̱nga b'a̱há tjíu̱n k'ien. Najmi kis'ehe̱ ntí. ");
INSERT INTO majNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A̱s'a̱i nda̱ xi ma joho tsixanko̱ ngáha ta̱chjúu̱n, tu̱nga ta̱ k'iehén ngáha. ");
INSERT INTO majNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A̱s'a̱i b'a̱há ta̱ kits'ín ngáha nda̱ xi ma jahan ko̱ ta̱ k'ien, ko̱ b'a̱ ta̱ kamat'ain já xingisoo̱. Ndaha nku xi yatuu̱ najmi kis'ehe̱ ntí. ");
INSERT INTO majNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A̱sakahan ta̱ k'ien ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","’Kui b'a̱ maha, ni̱stjin nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱, ¿yá nda̱ha xi ka̱ma ts'e̱ ta̱chjúu̱n? A̱t'aha̱ nga yatuu̱ tsixanko̱. ");
INSERT INTO majNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","A̱s'a̱i b'i̱ kitsú Jesu: —Bixan xu̱ta̱ xi tjín ni̱stjin nd'a̱i̱ ko̱ ts'ínkixan ntíhi̱. ");
INSERT INTO majNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tu̱nga xu̱ta̱ xi tje̱he̱n ra̱ nga k'úéntu tík'un ni̱stjin xi s'e̱jña a̱skahan, xi kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱, kui xi najmi ta̱ ku̱i̱xahan ko̱ najmi ta̱ ts'i̱ínkixahan ntíhi̱. ");
INSERT INTO majNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","A̱t'aha̱ najmi ta̱ ka̱ma ku̱a̱yáha. B'a̱ ní ts'ín k'úéntu xi nkú ts'ín tjíntu ntítsjee̱. Ntíhi̱ Nti̱a̱ná ka̱ma, a̱t'aha̱ j'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","’Ko̱ santaha Moise ta̱ y'éjña chji nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱, nk'ie nga kinchja̱ni̱jmíyaha na'yá ntsje̱ xi títiu̱. A̱t'aha̱ b'a̱ ts'ín tjít'a nga Nti̱a̱ná xi “Nti̱a̱ha̱ Abraham, Nti̱a̱ha̱ Isaac ko̱ Nti̱a̱ha̱ Jacob.” ");
INSERT INTO majNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nti̱a̱ná najmi Nti̱a̱ha̱ ani̱ma̱. Nti̱a̱ha̱ ní xu̱ta̱ tík'un. A̱t'aha̱ nginku̱n Nti̱a̱ná tjíntu tík'un ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A̱s'a̱i kinchja̱ k'u̱a̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱: —B'a̱ tjín ni xi ku̱a̱kixín, nda̱ maestru̱. ");
INSERT INTO majNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Najmi ta̱ kama k'un kingjásjaiya saha̱ ra̱ Jesu tsa mí nihi. ");
INSERT INTO majNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","A̱s'a̱i b'i̱ kitsú Jesu: —¿Nkú tjíhi̱n ra̱ nga b'a̱ tsuhu xu̱ta̱ nga ntje̱he̱ David nibáha̱ ra̱ xi Cristo̱? ");
INSERT INTO majNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","A̱t'aha̱ ta̱ kuihi David b'a̱ ts'ín y'ét'a xu̱ju̱n salmo̱: Nti̱a̱ná b'a̱ kitsúhu̱ Nda̱ Nti̱a̱na̱: “Ti̱nchint'ání má batexuma, ");
INSERT INTO majNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","k'uentú maná já kontra̱hi̱ kinte tsu̱kui.” ");
INSERT INTO majNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","B'a̱ ts'ín ta̱ kuihi David b'a̱ kitsúhu nga Nda̱ Nti̱a̱ha̱ maha xi Cristo̱. Kui nga, ¿nkú ts'ín ntje̱he̱ David nibáha̱ ra̱ xi Cristo̱? ");
INSERT INTO majNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nga tíi̱ncha basínñju ngayjee̱ xu̱ta̱, a̱s'a̱i kinchja̱ko̱ Jesu xu̱ta̱ ni'yakuyáha̱: ");
INSERT INTO majNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Chúhu̱un yjonu̱u já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. Kui xi tsjoho̱ nga bja najyun ndju nga b'ema ko̱ nga tsjo ts'ín súniñaha̱ ni̱yátée̱. Tsjoho̱ nga b'entusún yáxile̱ xi tíi̱ncha títjun ni'ya sinagoga̱ ko̱ nga b'entu a̱nte k'aku̱ xi tjín nku s'í. ");
INSERT INTO majNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kui xi kje'áha̱ ni'yaha̱ jminchjín xi ja k'ien x'i̱hi̱n ko̱ a̱s'a̱i chu̱ba̱ 'yúhún tse nchja̱ko̱ maña̱ Nti̱a̱ná tu̱ xi b'é'mat'aihin yjoho̱. 'Yún un sku̱e̱he̱ já xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tsase Jesu ko̱ kikie xu̱ta̱ nchi̱ná xi tíbinchá to̱oho̱n a̱ya kaxa̱ to̱on chje̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ko̱ ta̱ kikie nku ta̱chju̱ún xi ja k'ien x'i̱hi̱n. Kui xi jo to̱on xi̱ tíntí tsinchá kaxa̱ chje̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A̱s'a̱i b'i̱ kitsú: —Kju̱axi̱ ni xi tíxinnu̱u. Ta̱chju̱ún x'a̱i̱n 'yún tse kuatsjá sa nga ngayjee̱ xu̱ta̱ xi k'oo̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","A̱t'aha̱ ngayjee̱ xu̱ta̱ xi k'oo̱ ni xi tíb'ankihi̱ kuatsjá. Tu̱nga máha ta̱chjíi̱n, ngayjee̱ to̱on xi tíjñaha̱ nga kji̱ne̱yaha nichine kuatsjá. ");
INSERT INTO majNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","K'u̱a̱ xu̱ta̱ tínchja̱ni̱jmíyaha ni̱nku̱ nga tsjo ts'ín kin'enaxúko̱ho ndji̱o̱ tsjo k'un ko̱ ni xi kits'ínsuhun xu̱ta̱. A̱s'a̱i b'i̱ kitsú Jesu: ");
INSERT INTO majNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Máha ni xi tíyo e̱i̱, ku̱i̱chú ni̱stjin nga ndaha nku ndji̱o̱ najmi ta̱ s'e̱jñasuhu̱n ra̱ xinkjín. Ngayjee̱ n'e̱xúya. ");
INSERT INTO majNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","A̱s'a̱i b'a̱ kitsú jóo̱ nga kingjásjaiyaha̱: —Ji nda̱ maestru̱, ¿nkjé b'a̱ ka̱ma? ¿Mí nihi xi ku̱a̱kúchji títjun nga b'a̱ ka̱ma? ");
INSERT INTO majNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A̱s'a̱i kinchja̱ Jesu: —Chúhu̱un yjonu̱u nga najmi tu̱ ch'a xi k'u̱a̱na̱cha̱nu̱u. A̱t'aha̱ nkjin maha xi kj'u̱a̱í nga an ts'i̱ín ma yjoho̱. “An xi kui”, ku̱i̱tsu̱. Ko̱ b'a̱ ku̱i̱tsu̱ ya: “Ja kuichu ni̱stjiu̱n.” Tu̱nga najmi tu̱ tsjennkíhí ru̱u jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nk'ie nga ku̱i̱nú'yó nga tjín kju̱a̱chán ko̱ nga najmi tjín kju̱a̱jyu a̱jihi̱n xu̱ta̱ na̱xi̱nantá xi tjín, najmi tu̱ binkjun. A̱t'aha̱ tjíhin ni nga tjun b'a̱ ka̱ma, tu̱nga najmi kje̱hé kfe̱ a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ko̱ b'i̱ kitsú sa Jesu nga ngjindju: —Xu̱ta̱ xi tjín nku nanki kja̱ánko̱ xu̱ta̱ xi kj'a̱í nanki. Nku nda̱ rei̱ kja̱ánko̱ kj'a̱í nda̱ rei̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chón xi tu̱ xí 'yúhún ka̱ma ko̱ s'e̱ kjintíá kj'a̱í kj'a̱í nanki. Tsjén ch'in ch'onk'un, ko̱ ka̱ma chji nk'a ján ni xi ku̱i̱nchánkjúhu̱n xu̱ta̱ ko̱ kju̱a̱nkjún chánka. ");
INSERT INTO majNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Tu̱nga kintehe̱ ni nga ku̱i̱tjusun ngayjee̱ ni xu'bi̱, títjun ku̱a̱kj'ánijénu̱u xu̱ta̱ ko̱ tsjénnki unkienu̱u. Ts'i̱ínkjas'ennu̱u a̱ya ntsja já k'aku̱hu̱ xu̱ta̱ sinagoga̱ ko̱ ts'i̱ínkjas'ennu̱u nu̱ba̱yá. Nga̱t'ana̱ ngju̱a̱i̱ko̱ho̱nu̱u nginku̱n já rei̱ ko̱ nginku̱n já títjun. ");
INSERT INTO majNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","B'a̱ ts'ín sa̱kúntehe̱nu̱u nga k'úínyaha̱ ru̱u jóo̱ yáha an. ");
INSERT INTO majNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","B'i̱ n'e̱ n'e̱nkjíntak'un nga najmi tu̱ b'enda títjun xi nkú ts'ín ku̱i̱si̱nko̱o yjonu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","A̱t'aha̱ an tsjanu̱u én xi chu̱bo ko̱ kju̱a̱nkjintak'un xi chánka sa nga xi ts'e̱ já kontra̱nu̱u, tu̱ xi najmi ku̱i̱chúkju̱a̱ha̱ ra̱ ni xi chu̱bo ko̱ tsa b'a̱ ku̱i̱tsu̱ nga najmi b'a̱ tjín ni xi tíchubo. ");
INSERT INTO majNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","’Santaha xi chánu̱u, já nts'o, xu̱ta̱ xinki̱u ko̱ xu̱ta̱ xi nda nchja̱ko̱nu̱u ts'i̱ínkjas'ennu̱u. K'u̱a̱ xi tjín a̱jinnu̱u n'e̱k'ien. ");
INSERT INTO majNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nga̱t'ana̱ ts'i̱ín unkiehe̱nu̱u ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tu̱nga ndahá nku ntsja̱ku najmi ndyja̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ndjá ti̱ncho, tu̱ xi k'u̱a̱nkihinu. ");
INSERT INTO majNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Nk'ie nga cho̱o nga k'u̱étjindaihi̱ já jun nanki Jerusalen, katumankjinnu̱u nga ja kuichu ni̱stjin nga n'e̱kje. ");
INSERT INTO majNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kui ni̱stjiu̱n katanka xu̱ta̱ xi tjíntu a̱nte Judea̱ xi tje̱hen a̱sunntu tje̱nnki̱. Xi tjíntu a̱jin na̱nti̱a̱ Jerusalen katitju. Xi kafi jñá najmi ta̱ kak'óyaha a̱jin na̱nti̱o̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","A̱t'aha̱ kui ni̱stjin xu'bo̱ ts'i̱ínkjáíhi̱n xu̱ta̱ chjíhi̱ ni xi najmi nda kits'ín, tu̱ xi ku̱i̱tjusuhun ngayjee̱ ni xi tjít'a éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ni̱ma̱ rú ts'íhin jminchjín xi y'a ntí ko̱ xi títs'ínki ntí kui ni̱stjiu̱n! A̱t'aha̱ tse kju̱a̱ni̱ma̱ xi s'e̱ a̱sunntee̱ ko̱ kju̱a̱kjaha̱n Nti̱a̱ná ni̱banehe̱ xu̱ta̱ xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","K'u̱a̱ xi ki̱cha̱ ndju n'e̱k'ienko̱ho ko̱ kj'a̱í ngá xi ngju̱a̱i̱nijé ngayjee̱ nanki xi tjín. Xu̱ta̱ xi najmi ntje̱ Israel tje̱he̱n ra̱ ku̱a̱si̱nne nanki Jerusalen xi nkú tjín nú nga k'u̱a̱i̱ntehe̱ nga ku̱a̱téxuma. ");
INSERT INTO majNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’A̱s'a̱i ts'íu̱ ko̱ sóo̱ ko̱ niñuu̱ ku̱a̱kúchji kju̱a̱nkjún xi ka̱ma. Xu̱ta̱ na̱xi̱nantá xi tjín t'anankiu̱ ngju̱ánta̱ha̱ ra̱ yjoho̱ ko̱ tsa̱nkjún, a̱t'aha̱ 'yún kju̱a̱ne̱ya ntáchak'uu̱n ko̱ 'yún ngju̱a̱i̱nk'a t'éhe̱n ntóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Xí ku̱a̱yáyahá xu̱ta̱ nga tsa̱nkjún ko̱ nga kúyaha̱ ni xi ka̱maha̱ a̱sunntee̱. A̱t'aha̱ Nti̱a̱ná ts'i̱ínk'atsé ni xi tjín nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nk'iehé cha̱ Ntíhi̱ Nda̱x'i̱u̱n nga tje̱njin ni̱nti̱u̱ nga nibáko̱ ngayjee̱ nga'yúhu̱n ko̱ kju̱a̱chánkaha̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nk'ie nga k'u̱a̱tuts'i̱hi̱n nga b'i̱ ka̱ma, tsjo katumanu̱, a̱t'aha̱ ja tíbichú tiña ni̱stjin nga ja ka̱ma nda̱ínu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ko̱ b'i̱ ta̱ ts'ín y'éjña chu̱ba̱ya Jesu nga tsakúya: —Cha̱so̱ho̱ yá higuera̱ ko̱ ngayjee̱ yá xi tjín. ");
INSERT INTO majNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nk'ie nga yo nga ja títjuhu̱ nts'én, mankjinnu̱u nga ja tíbichú tiña chu̱nubóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","B'a̱ ta̱ ts'ín nk'ie nga ja cho̱o nga ja b'a̱ tíma, katumankjinnu̱u nga ja tíjña tiña ni̱stjin nga ku̱a̱téxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kju̱axi̱ ni xi tíxinnu̱u. Ku̱i̱tjusun ngayjee̱ ni xu'bi̱ kintehe̱ ni nga ku̱a̱yáyje xu̱ta̱ xi tjín nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ka̱maha̱ a̱sunntee̱ ko̱ nk'a ján ndyja̱, tu̱nga énna̱ najmi kj'u̱a̱ tiya. ");
INSERT INTO majNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Chúhu̱un yjonu̱u, tu̱ xi najmi ka̱ma ndjáha ani̱ma̱nu̱u, tsa tséjihi̱n ra̱ ni xi mjehe̱ yjonintenu̱u, tsa ka̱ma ch'i̱u, ko̱ tsa kjúánta̱ha̱ ru̱u yjonu̱u ni xi tjín a̱sunntee̱. A̱t'aha̱ tsa b'a̱ n'o̱o, tu̱ ndyjahánu̱u nk'ie nga kj'u̱a̱í ni̱stjin xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","A̱t'aha̱ kj'u̱a̱ínehe̱ ni̱stjin xu'bo̱ ngayjee̱ xu̱ta̱ xi tjín tu̱ má xi tje̱hén ni a̱sunntee̱. Tu̱ ndyjehé ra̱ nga b'a̱ ka̱moo̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kui nga ti̱ntsu̱ba̱ ndahanu ko̱ tehe̱nte chu̱bako̱o Nti̱a̱ná, tu̱ xi ku̱i̱chúkju̱a̱ha̱nu̱u nga ku̱i̱tjánkiu ngayjee̱ ni xi ka̱moo̱ ko̱ ku̱i̱chú nginku̱n Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Xki̱ ni̱stjin tsakúya Jesu na̱tsin ni̱nku̱ ko̱ nga ma ngixuu̱n bitju nga fi ts'ínkj'a ni̱stje̱n a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱. ");
INSERT INTO majNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ko̱ ngayjee̱ xu̱ta̱ ta̱ jyun ta̱ jyun i̱ncha f'ai na̱tsin ni̱nku̱ nga f'aisínñjuhu̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ja tíbichú tiña S'í Pascu̱a̱, nk'ie nga chine ni̱nku̱a̱n xi najmi kamandako̱ho na̱'yu̱ san. ");
INSERT INTO majNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ i̱ncha tsangisjai ni̱yá xi nkú nga ts'ín ts'i̱ínk'iehen Jesu, a̱t'aha̱ tsankjún jóo̱ xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","A̱s'a̱i jas'enjihi̱n Satana Juda̱ xi ta̱ 'mi Iscariote̱, nku nda̱ ni'yakuyá xi te joo̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kui xi ngjisehe̱ já na̱'mi k'aku̱ ko̱ já jun k'aku̱ nga kinchja̱ni̱jmíyako̱ xi nkú ts'ín ka̱ma ts'i̱ínkjas'ehen Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tsjo kamaha̱ jóo̱ ko̱ y'éndako̱ Juda̱ nga tsjáha̱ to̱on. ");
INSERT INTO majNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kits'ín yu Juda̱ ko̱ tsangisjai ni̱yá xi nkú ts'ín ka̱ma ts'i̱ínkjas'en Jesu nk'ie nga najmi 'yún tjín xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tsichu ni̱stjin nga chine ni̱nku̱a̱n xi najmi kamandako̱ho na̱'yu̱ san, nk'ie nga n'ek'ien chu̱tsa̱nka̱ha̱ S'í Pascu̱a̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","A̱s'a̱i b'a̱ kitsú Jesu nga kits'ínkji Pedro̱ ko̱ Jua: —Tankínk'iendo ni xi chi̱ne̱é S'í Pascu̱a̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","B'a̱ kitsú jóo̱: —¿Má xi tje̱hen mjehi nga k'úéndai̱ nichinee̱? ");
INSERT INTO majNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","B'i̱ kitsú Jesu: —Nk'ie nga ku̱i̱tjás'o̱on a̱jin na̱nti̱o̱, sa̱tékjó nku nda̱ xi y'a nku ndji̱í ntánijua. Tsjénnkihu̱u santaha má nga kju̱a̱s'en ");
INSERT INTO majNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ko̱ b'a̱ t'ihu̱un nda̱ xi ts'e̱ ni'yoo̱: “B'a̱ títsu nda̱ maestru̱: ¿Má xi kui a̱nte má nga kjíne̱ka̱ nichinehe̱ S'í Pascu̱a̱ já ni'yakuyána̱?” ");
INSERT INTO majNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A̱s'a̱i ku̱a̱kúnu̱u nku a̱nte tayá chánka xi ja tjínda xi tje̱hen nk'a ni'yaha̱. Yo̱ t'endo ni xi chi̱ne̱é. ");
INSERT INTO majNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A̱s'a̱i ngji jóo̱ ko̱ b'a̱ kamat'ain xi nkú nga kitsúhu̱ Jesu. Yo̱ i̱ncha y'énda nichinehe̱ S'í Pascu̱a̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nk'ie nga tsichu chu̱ba̱, y'ejñat'ako̱ Jesu yámixo̱ já postru̱hu̱ ");
INSERT INTO majNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ko̱ b'i̱ kitsúhu̱: —Mangimjena nga kjuasjéko̱nu̱u S'í Pascu̱a̱ xu'bi̱ kintehe̱ ni ngabayana̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","A̱t'aha̱ b'a̱ tíxinnu̱u nga najmi ta̱ kjíne̱ sahana nichinei̱ santaha nkúhu nga ku̱i̱tjusun xi nkú tsuhu̱ ra̱ kui s'íi̱ má batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A̱s'a̱i jakj'á chu̱tsíu̱n ko̱ nga ja kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná, b'i̱ kitsú: —Chjúbó niu̱ ko̱ n'e̱ndzjoho̱o xinki̱u. ");
INSERT INTO majNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","A̱t'aha̱ b'a̱ tíxinnu̱u nga najmi ta̱ k'u̱i̱ sahana ntáha̱ tuntsja̱jée̱ santa nkúhu nga ku̱i̱chú ni̱stjin nga ku̱a̱téxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A̱s'a̱i jakj'á ni̱nku̱o̱n ko̱ nga ja kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná, tsakjánya ko̱ kitsjáha̱ jóo̱ nga b'a̱ kitsú: —Kui xu'bi̱ xi yjonintena̱ xi n'e̱kjas'en ngandanu̱u. B'a̱ n'o̱o tu̱ xi kj'u̱a̱ítsjennu̱u an. ");
INSERT INTO majNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nk'ie nga ja kamaha̱ nga kikjine nichinee̱, ta̱ jakj'á chu̱tsíu̱n nga b'a̱ kitsú: —Kui chu̱tsíi̱n tíbakúchji jnína̱ xi ngju̱a̱i̱ ndzjo ngandanu̱u. Jnína tíb'éndako̱ tse̱tse̱he Nti̱a̱ná nd'a̱i̱ xi nkú ts'ín nda ts'i̱ínko̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tu̱nga máha nd'a̱i̱, nda̱ xi títs'ínkjas'enna ta̱ tíjñat'ako̱na yámixa̱i̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A̱t'aha̱ b'a̱ n'e̱he̱ Ntíhi̱ Nda̱x'i̱u̱n xi nkú ts'ín kis'endaha̱. Tu̱nga, ¡ni̱ma̱ rú ts'íhin nda̱ xi ts'i̱ínkjas'ehe̱n! ");
INSERT INTO majNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A̱s'a̱i b'i̱ ngján kingjásjaiyaha̱ xinkjín jóo̱ nga yá xi b'a̱ ts'i̱íu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A̱s'a̱i já ni'yakuyóo̱ b'a̱ i̱ncha kitsúhu̱ xinkjín nga yá xi 'yún chánka sa a̱jihi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tu̱nga b'a̱há kitsú Jesu: —Já rei̱ xi batéxuma na̱xi̱nantá xi tjín a̱sunntee̱ ndjá ts'ínko̱ xu̱ta̱ xi ts'e̱. Ko̱ já xi tjíhi̱n xá, kui xi nda i̱ncha ts'ín, tsu xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tu̱nga a̱jinnu̱u najmi b'a̱ ka̱ma. Xi 'yún ní chánka sa a̱jinnu̱u kats'ín ma yjoho̱ xi nkú joyaha tsa kui xi 'yún kinte tje̱n. Ko̱ xi batéxuma kats'ín ma yjoho̱ xi nkú joyaha tsa kui xi nda̱ musu̱hu̱ já xingisoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A̱t'aha̱, ¿yá xi 'yún chánka sa? ¿A xi b'ejñat'a yámixo̱ nga kjine, a ra̱ nda̱ musu̱ xi b'éyahá nichinee̱? ¿A najmi xi b'ejñat'ahá yámixo̱? Tu̱nga máha an, tíi̱jñajinnu̱u e̱i̱ xi nkú joyaha nda̱ musu̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Jun najmi kin'e nga manú nk'ie nga kichjut'ayák'unna. ");
INSERT INTO majNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kui nga k'uendáha̱nu̱u nga ku̱a̱texumo, xi nkú ts'ín y'éndana Na̱'mina̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ku̱i̱ntsu̱ba̱t'o yámixa̱na̱ nga chi̱no̱o ko̱ s'i̱u nk'ie nga kuatexuma, ko̱ ku̱i̱ntsu̱bo̱o a̱nte má nga ku̱a̱texumoho̱o ntje̱he̱ xu̱ta̱ Israel xi te jo tíkjá maha. ");
INSERT INTO majNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","’Simon, Simon, ta̱sinñjui. Satana tsanki nga k'u̱étsujneyánu̱u xi nkú n'ehe̱ tuni̱ñu̱ nga kjút'ayák'unnu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tu̱nga an ja tsankintjáíhi nginku̱n Na̱'miu̱ tu̱ xi tu̱ nku s'e̱jihín ri an. Ko̱ ji, nk'ie nga sa̱kú nga'yún ngáha ri nga s'e̱jihin an, ti̱si̱nko̱i̱ já nts'ei tu̱ xi tu̱ nku ndjáhá ku̱i̱nchaha. ");
INSERT INTO majNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","B'a̱ kitsú Simon: —Ji nda̱ maestru̱, tjínkuhu̱ k'an nga kfínko̱ho nu̱ba̱yá ko̱ santaha nga ku̱a̱yáko̱ho. ");
INSERT INTO majNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","B'i̱ kitsú Jesu: —Ji Pedro̱, an b'a̱ tíxihin. Kintehe̱ ni nga kji̱ntá xa̱nto̱ nd'a̱i̱, b'a̱ ku̱i̱xín nga najmi yaní jan ni̱yá tjíhin. ");
INSERT INTO majNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","A̱s'a̱i b'i̱ kitsúhu̱ já ni'yakuyáha̱: —Nk'ie nga kits'inkjínu̱u nga najmi tu̱ ch'o tsa kixinnu̱u, ko̱ ta̱ ndaha to̱on ko̱ ta̱ ndaha tja̱ba̱xínnté, ¿a tjín ni xi kindyjat'anu̱u? B'a̱ kitsú jóo̱: —Najmi chumi nihi xi kindyjat'ani̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A̱s'a̱i b'a̱ kitsú Jesu: —Tu̱nga nd'a̱i̱, xi tíjñaha̱ tsa, kat'a ko̱ ta̱ kat'a to̱oho̱n. Ko̱ xi najmi tíjñaha̱ ki̱cha̱, katatéña najyun ndjuhu̱ ko̱ kat'atse nku. ");
INSERT INTO majNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","A̱t'aha̱ b'a̱ tíxinnu̱u. Tjíhin nga ku̱i̱tjusuhun ni xu'bi̱ xi tjít'a éhe̱n Nti̱a̱ná: “Kui xi ta̱ kich'axki̱hi̱ ra̱ a̱jihi̱n já ch'onk'uu̱n.” A̱t'aha̱ ngayjee̱ ni xi tjít'a nga tínchja̱ni̱jmíyahana tjíhin nga ku̱i̱tjusun. ");
INSERT INTO majNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","B'a̱ kitsú jóo̱: —Ji nda̱ maestru̱, ¡á jo ki̱cha̱ e̱i̱! B'i̱ kitsú Jesu: —Ja kama. ");
INSERT INTO majNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A̱s'a̱i tsitju Jesu nga ngji a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱ xi nkú ts'ín tehe̱nte, ko̱ ta̱ kitsjennkíhi̱ já ni'yakuyáha̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nk'ie nga tsichu yo̱, b'a̱ kitsúhu̱: —Chu̱bako̱o Nti̱a̱ná tu̱ xi najmi chjút'ayák'uhu̱nnu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","A̱s'a̱i b'a̱ ts'ín kjin ngji t'axín suba xi nkúhu má bichúkijne nku ndji̱o̱ nga s'e. Yo̱ tsasinkúnch'in ko̱ kinchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","B'i̱ kitsú: —Ji Na̱'mi, tsa ka̱ma kai, n'e̱kj'a t'axínní kju̱a̱ni̱ma̱ xu'bi̱. Tu̱nga katumahá xi nkú ts'ín mjehi, najmi xi nkú ts'ín mjena. ");
INSERT INTO majNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","A̱s'a̱i kama chjihi̱ nku ntítsje xi nibajehen nk'a ján nga j'ai tsjá nga'yúhu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ko̱ nk'ie nga 'yún ṉkjún un tíbehe̱ Jesu, tu̱ sahá 'yún kinchja̱ko̱ sa Nti̱a̱ná ko̱ tsixuntu t'anankiu̱ ntánubáha̱ xi b'a̱ k'un xi nkú joyaha stubá jní i. ");
INSERT INTO majNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nk'ie nga ja kamaha̱ nga kinchja̱ko̱ Nti̱a̱ná, a̱s'a̱i tsisintje̱n ko̱ j'aise ngáha̱ ra̱ já ni'yakuyáha̱. Kjintufé jóo̱ nk'ie nga j'aisehe̱ a̱t'aha̱ kju̱a̱boo̱ xi kats'ín ngana̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A̱s'a̱i b'i̱ kitsú: —¿Á kisunntuféhenu? Ti̱síntjo̱on ko̱ chu̱bako̱o Nti̱a̱ná tu̱ xi najmi chjút'ayák'uhu̱nnu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nk'ie nga ta̱ tínchja̱ha Jesu, tu̱ j'aihí nkjin ṉkjún xu̱ta̱. Tje̱n títjuhu̱n xu̱to̱ nda̱ xi 'mi Juda̱, xi nku nda̱ ni'yakuyá xi te joo̱. Kui xi j'aik'úhu̱n Jesu ko̱ kikjexu̱'ba. ");
INSERT INTO majNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","B'i̱ kitsú Jesu: —Ji Juda̱, ¿a tíchjuxu̱'bai Ntíhi̱ Nda̱x'i̱u̱n nga tín'ekjas'ein? ");
INSERT INTO majNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nk'ie nga kikie já xi kabinchandaihi̱ Jesu ni xi tímoo̱, a̱s'a̱i b'a̱ kitsú: —Ji nda̱ maestru̱, ¿a ki̱cha̱ ku̱i̱xkjaha̱nni̱? ");
INSERT INTO majNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nku nda̱ xi síjñajihi̱n jóo̱ kits'ín'uhu̱n nku nda̱ musu̱hu̱ nda̱ na̱'mi títjuu̱n. Tsatet'a tja̱ba̱xínñju kixi̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tu̱nga b'a̱há kitsú Jesu: —Najmi b'a̱ tu̱ n'o. Jyu ti̱ncho. Kits'ínko̱ tja̱ba̱xínñju nda̱ musu̱ nga kits'ínnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","A̱s'a̱i kinchja̱ko̱ já xi j'aikj'ánijéhe̱, kui xi já na̱'mi k'aku̱ ko̱ já jun k'aku̱hu̱ ni̱nku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá. B'i̱ kitsúhu̱: —¿A nda̱ ndyjéná? ¿Á i̱xí ki̱cha̱há ko̱ yá kich'ahanu nga kjúái̱hinu? ");
INSERT INTO majNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Xki̱ ni̱stjin tsási̱njñajinnu̱u má ma na̱tsihi̱n ni̱nku̱. Ndaha̱chí najmi kin'eko̱nú. Tu̱nga kuihí chu̱ba̱nu̱u xu'bi̱, chu̱ba̱ nga batéxuma má jyuu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","A̱s'a̱i jakj'ánijéhe̱ jóo̱ Jesu ko̱ ngjiko̱ho̱ ni'yaha̱ nda̱ na̱'mi títjuu̱n. Máha Pedro̱, kitsjennkí kjihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nk'ie nga kíts'ín'yún nd'í jóo̱ kamasehe̱n na̱tsiu̱n, y'entut'á ko̱ Pedro̱ ta̱ y'ejñajihi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","A̱s'a̱i nku na̱ musu̱ kikiehe̱ nk'ie nga kab'ejñat'a nd'íu̱. Tsase'a sisihi̱n ko̱ b'a̱ kitsú: —Kui chái̱ xi ta̱ tsjenko̱ chá ján. ");
INSERT INTO majNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tu̱nga najmi kits'ínkiehé yjoho̱ Pedro̱. B'a̱ kitsú: —Ji ta̱chju̱ún, najmi be ndo̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sa kutju tu̱ sa kj'a̱íhí xi kikie ngáha̱ ko̱ b'a̱ kitsúhu̱: —Ji xi ta̱ mako̱i̱ jóo̱. Tu̱nga b'a̱há kitsú Pedro̱: —Ji nda̱, najmi an niu̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","J'a ra̱ xi nkú maha tsa nku ora̱. A̱s'a̱i tu̱ sa kj'a̱í ngá xi ta̱ b'a̱há kitsú ngáha̱ ra̱: —Kju̱axi̱ kjáíhin nga ko̱ kui nda̱i̱ mako̱ nda̱ xu'ba̱ ján, a̱t'aha̱ ta̱ Galilea̱ nabáha. ");
INSERT INTO majNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","B'a̱há ta̱ kitsú ngáha Pedro̱: —Ji nda̱, najmi be ni xi tíchubai. Ta̱ kuihi chu̱bo̱, nk'ie nga b'a̱ ta̱ títsuhu Pedro̱, tje̱n'yún kikjintáhá nku xa̱nta̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kits'ínk'ótjiya Nda̱ Nti̱a̱ná nga tsase'a Pedro̱, ko̱ j'áítsjehe̱n Pedro̱ ni xi kitsúhu̱ Nda̱ Nti̱a̱ná: “Kintehe̱ ni nga kji̱ntá xa̱nto̱ nd'a̱i̱, b'a̱ ku̱i̱xín nga najmi yaní jan ni̱yá tjíhin.” ");
INSERT INTO majNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A̱s'a̱i tsitjusje Pedro̱ ko̱ kikjintá'un kikjintánte. ");
INSERT INTO majNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Máha já xi tíi̱ncha kunntáha̱ Jesu, kik'aya ko̱ kik'íéhe̱. ");
INSERT INTO majNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Y'é'ma tunku̱n ko̱ b'a̱ i̱ncha kitsúhu̱: —Ti̱xínyai xi nkúhu nda̱ profeta̱, ¿yá xi kuak'íéhi? ");
INSERT INTO majNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nkjin tíkjá ya én xi kitsúhu̱ Jesu nga najmi kikienkjún. ");
INSERT INTO majNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nk'ie nga ja kama see̱n, kama ñja jáchá xi tjíhi̱n xá ko̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. I̱ncha ngjiko̱ Jesu má ma ñjakú já tjíxá judio̱ ko̱ b'a̱ i̱ncha kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—T'inyani̱, ¿a ji xi kits'ín nibá Nti̱a̱ná? B'i̱ kitsú Jesu: —Tsa xínyanu̱u, najmi s'e̱jinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ko̱ tsa kuasjáíyanu̱u, najmi n'e̱k'óyanú. ");
INSERT INTO majNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tu̱nga nd'a̱i̱ k'u̱a̱tuts'i̱hi̱n Ntíhi̱ Nda̱x'i̱u̱n nga k'úéjñat'aha̱ Nti̱a̱ná xi tjíhi̱n nga'yún. ");
INSERT INTO majNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","A̱s'a̱i ngatentee̱ kingjásjaiyaha̱: —¿A xúhu̱ jihí xi Ntíhi̱ Nti̱a̱ná? B'i̱ kitsú Jesu: —An xi tíbixíún. ");
INSERT INTO majNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","B'a̱ i̱ncha kitsú jóo̱: —¿A machjén saná já testiyu̱? Ñá kikjin ja kuanu'yáá ni xi kuatsú. ");
INSERT INTO majNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","A̱s'a̱i tsisintje̱n ngayjee̱ já tjíxóo̱ ko̱ ngjiko̱ Jesu nginku̱n Pilato̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nkjin ni xi kikjanínehe̱ yo̱ nga b'i̱ i̱ncha kitsú: —Xu̱ta̱ nankini̱ tíbinchákjaha̱n nda̱i̱ nk'ie kuasakúni̱. Tíb'éjña nkjún nga s'e̱chjíhi̱ nda̱ títjun Cesa̱r ni xi f'áchjíntjai, ko̱ b'a̱ títsu nga kui xi nku nda̱ rei̱ xi kits'ín nibáha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","B'a̱ kitsúhu̱ Pilato̱ Jesu: —¿A ji xi nda̱ rei̱hi̱ xu̱ta̱ judio̱? B'i̱ kitsú Jesu: —B'a̱ tjín ni xi tíbixín. ");
INSERT INTO majNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","A̱s'a̱i kinchja̱ko̱ Pilato̱ já na̱'mi k'aku̱ ko̱ xu̱ta̱ nkjiu̱n nga b'a̱ kitsúhu̱: —Najmi chumi jéhe xi tísakújinna ndo̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tu̱nga tu̱ nku b'a̱há i̱ncha kitsú jóo̱: —Xu̱ta̱ nankini̱ tíbinchákjaha̱n. Tíbakúya xki̱ a̱nte xi tjín Judea̱. A̱nte Galilea̱ kik'atuts'i̱hi̱n ra̱ ko̱ santaha e̱i̱ ja j'ai nga b'a̱ títs'ín. ");
INSERT INTO majNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nk'ie nga kint'é Pilato̱ ni xu'bi̱, kingjásjaiya tsa a̱nte Galilea̱ nibáha Jesu, ");
INSERT INTO majNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","a̱t'aha̱ yo̱ batéxuma Herode̱ Antipa̱. Nk'ie nga kik'inyaha̱ nga Galilea̱ nibáha Jesu, a̱s'a̱i kits'ínkji Jesu má tíjña Herode̱, a̱t'aha̱ nanki Jerusalen tíjña Herode̱ kui chu̱bo̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tu̱ ni xí tsjohó kamaha̱ Herode̱ nk'ie nga kikie Jesu, a̱t'aha̱ nd'a̱i ṉkjún mjehe̱ ra̱ sku̱e̱he. Nkjin tíkjá ni xi kik'inyaha̱ nga títs'ín Jesu ko̱ mjehe̱ sku̱e̱ nga ts'i̱ín Jesu nku kju̱a̱nkjún. ");
INSERT INTO majNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nkjin ṉkjún ni xi kingjásjaiyaha̱, tu̱nga ndahá nku én najmi kinchja̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ta̱ kabincha ya yo̱ já na̱'mi k'aku̱ ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ nga nihi xi nkjún ts'ín nkjin ni xi tíkjanínehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A̱s'a̱i Herode̱ ko̱ já juhu̱n xi nkúhu ni xi najmi chumi ni chjíhi̱ ra̱ kits'ín ma Jesu ko̱ tsajnukie. Kits'ínngja nku najyun tsjo tjín xi nkúhu xi bja já rei̱ nga i̱ncha kik'aya. A̱s'a̱i kits'ínk'óya ngáha̱ ra̱ Pilato̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kui ni̱stjin xu'bo̱ Herode̱ ko̱ Pilato̱ kik'atuts'i̱hi̱n nga kinchja̱ko̱ nda ngáha xinkjín, a̱t'aha̱ unkie xinkjín kintehe̱ ni ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","A̱s'a̱i Pilato̱ kinchja̱ ñjaha̱ já na̱'mi k'aku̱ ko̱ já tjíxóo̱ ko̱ xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","B'a̱ kitsúhu̱: —Jun kafái̱ko̱nú nda̱i̱. B'a̱ tíbixíún nga xu̱ta̱ nankinu̱u tíbinchákjaha̱n. Nginkun kuangjasjáíyaha̱ ndo̱. A̱jihi̱n ngayjee̱ ni xi tíchjaninóho̱o nda̱i̱ najmi kuasakúna tsa tjíhi̱n jé. ");
INSERT INTO majNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ta̱ ndaha Herode̱ najmi kuasakújihi̱n tsa mí nihi. Kui nga kuats'ínk'óya ngáhana nda̱i̱. Ja tíyo. Najmi chumi nihi xi kits'ín nda̱i̱ xi tje̱he̱n ra̱ ngabaya. ");
INSERT INTO majNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Kui b'a̱ maha, tsjahana kju̱a̱ nga s'e̱he̱ ra̱ ko̱ a̱s'a̱i ts'in nda̱íhi̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tu̱nga nkuhú kits'ín nta̱ha̱ xu̱ta̱ nga kikjintáya: —¡Kan'ek'ien nda̱ xu'bo̱! ¡N'e̱ nda̱íhi̱ Barraba! ");
INSERT INTO majNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Kjiya'yún nda̱ Barraba a̱t'aha̱ já Roma̱ ngji kontra̱ha̱ ko̱ nku nda̱ kits'ínk'ien. ");
INSERT INTO majNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato̱ mjehe̱ nga ts'i̱ín nda̱íhi̱ Jesu kai, kui nga ta̱ kinchja̱ko̱hó ngáha xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tu̱nga 'yún kikjintáya xu̱to̱: —¡Tjat'a krui̱ ndo̱! ¡Tjat'a krui̱ ndo̱! ");
INSERT INTO majNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A̱s'a̱i ta̱ kinchja̱há ngáha Pilato̱ ni̱yá xi ma jahan: —Tu̱nga, ¿mí ni ch'on tjíhin xi kits'ín ndo̱? Ndaha nku ni najmi tísakújinna tsa tje̱he̱n ra̱ ngabaya. Kui b'a̱ maha, tsjahana kju̱a̱ nga s'e̱he̱ ra̱ ko̱ a̱s'a̱i ts'in nda̱íhi̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tu̱nga tu̱ ni xí 'yúhún kikjintáya sa xu̱ta̱. Tsankihi̱ Pilato̱ nga ngju̱át'a kruu̱ Jesu. B'a̱ i̱ncha kits'ín santaha nkúhu nga i̱ncha kin'esihi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kui nga kitsjáha kju̱a̱ Pilato̱ nga n'e̱tjusuhun ni xi tíi̱ncha banki. ");
INSERT INTO majNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kits'ín nda̱íhi̱ nda̱ xi j'ájin xu̱ta̱ nga n'e̱ nda̱íhi̱, nda̱ xi kjiya'yún nu̱ba̱yá a̱t'aha̱ já Roma̱ ngji kontra̱ha̱ ko̱ a̱t'aha̱ ani̱ma̱ tje̱he̱n. A̱s'a̱i kitsjá kju̱a̱ nga n'e̱he̱ Jesu ni xi mjehe̱ xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nk'ie nga tífi s'et'a kruu̱ Jesu, kichjubé nku nda̱ nanki Sirene̱ xi Simon 'mi. Jñá kaf'aihi ndo̱. Kui xi kin'ek'anji kruu̱ nga kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ta̱ kitsjennkíhi̱ nkjin ṉkjún xu̱ta̱ ko̱ jminchjín xi tíi̱ncha kjintá nga títs'ínbat'a Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tu̱nga kits'ínk'ótjiyahá Jesu, tsasehe̱ jminchjíu̱n ko̱ b'i̱ kitsúhu̱: —Jun jminchjín Jerusalen, najmi tu̱ an ch'ít'anú. Yjonu̱u ko̱ ntínu̱u xi ch'i̱ít'o. ");
INSERT INTO majNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","A̱t'aha̱ ku̱i̱chú ni̱stjin nga b'a̱ ku̱i̱tsu̱ xu̱ta̱: “Á b'a̱ nda tjíhin ts'e̱ jminchjín xi nti̱hi, xi najmi kik'a ntí ko̱ xi najmi kits'ínki ntí.” ");
INSERT INTO majNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","A̱s'a̱i b'a̱ i̱ncha ku̱i̱tsu̱hu̱ tje̱nki̱u̱: “Ti̱xuntunéni̱.” Ko̱: “T'e'mani̱”, ku̱i̱tsu̱hu̱ tje̱nki̱u̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","A̱t'aha̱ tsa b'i̱ tíi̱ncha ts'íhi̱n yá xi xkfée̱n, kui nga, ¿nkú sa ts'i̱íhi̱n ra̱ yá xi kixiu̱? ");
INSERT INTO majNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ta̱ tje̱nko̱ jóo̱ jo já ch'onk'un xi ta̱ ngju̱át'a kruu̱ko̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nk'ie nga i̱ncha tsichu a̱nte xi 'mi Nintaku̱ Ani̱ma̱, yo̱ kingját'a kruu̱ Jesu ko̱ nga joo̱ já ch'onk'uu̱n. Nku xi kitsjen kixi̱hi̱ Jesu ko̱ nku skjúhu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","B'i̱ kitsú Jesu: —Ji Na̱'mi, n'e̱ndyjat'aihi̱, a̱t'aha̱ najmi be ni xi tíi̱ncha ts'ín. Já juu̱n kits'ínndzjoho̱ xinkjín najyuhu̱n Jesu nga kitsutonyá ts'íhin. ");
INSERT INTO majNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Xu̱ta̱ nkjiu̱n kabincha yo̱ nga tíi̱ncha basenkjún. Ko̱ já tjíxóo̱ kik'aya Jesu nga b'a̱ kitsú: —Kamaha̱ nda̱i̱ nga kj'a̱í xi kits'ínk'anki. Kats'ínk'anki yjoho̱ nd'a̱i̱ tsa kui xi kits'ín nibáha̱ Nti̱a̱ná, tsa kui xi j'ájihi̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Já juu̱n ta̱ kik'ayaha̱ Jesu. J'aik'úhu̱n ko̱ kitsjáha̱ nga k'úí binu̱ san. ");
INSERT INTO majNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","B'a̱ i̱ncha kitsúhu̱: —Tsa ji xi nda̱ rei̱hi̱ xu̱ta̱ judio̱, n'e̱k'anki yjohi̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ta̱ kis'et'a a̱ntsjáku̱ Jesu nku yáte xi b'i̱ kitsú: “Kui xu'bi̱ xi nda̱ rei̱hi̱ xu̱ta̱ judio̱.” ");
INSERT INTO majNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nku nda̱ ch'onk'un xi ta̱ kjit'a kruu̱ ta̱ najmi kikienkjún Jesu nga b'i̱ kitsúhu̱: —Tsa ji xi kits'ín nibá Nti̱a̱ná, n'e̱k'anki su̱ba̱i̱ yjohi̱ ko̱ ta̱ n'e̱k'ankini̱ ko̱ ji̱n. ");
INSERT INTO majNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tu̱nga b'a̱há kitsú nda̱ xinkuu̱ nga kinchja̱tiko̱ nda̱ xu'bi̱: —Najmi binkjuin Nti̱a̱ná ji, ta̱ ndaha tsa ta̱ kui kju̱a̱ni̱ma̱ha tíyai. ");
INSERT INTO majNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Máha ñá, tjíhi̱n kixi̱ nga un tíbená, a̱t'aha̱ tín'ekjáíhi̱ín chjíhi̱ ni xi kin'eé. Tu̱nga kui nda̱i̱ ndaha̱chí najmi ch'on kits'ín. ");
INSERT INTO majNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A̱s'a̱i b'a̱ kitsúhu̱ Jesu: —Ji Jesu, katj'áítsjeihin an nk'ie nga ch'a̱tuts'i̱hi̱n nga ku̱a̱texumai. ");
INSERT INTO majNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","B'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxihin. Nd'a̱i̱ ku̱i̱nchunko̱ní ndji̱o̱jmi ján. ");
INSERT INTO majNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Xi nkú ra̱ ma nga chu̱ba̱ te jo nga ni̱stjiu̱n kis'e jyun ngayjee̱ a̱sunntee̱ santa nkúhu nga tsichu chu̱ba̱ jan nga ngixuu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Najmi ta̱ kits'ín ndzjehen ts'íu̱. Ko̱ jo tsitju nga kitiyájen najyun xi tje̱nchja a̱nte xi 'yún nkjúhu̱n ni̱nku̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A̱s'a̱i 'yún kikjintáya Jesu: —Ji Na̱'mi, a̱ya ntsa̱i̱ títs'inkjas'en ani̱ma̱na̱. Nga ja b'a̱ kitsú, a̱s'a̱i k'ien. ");
INSERT INTO majNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nk'ie nga kikie nda̱ jun k'aku̱ ni xi kamoo̱, kits'íntsjoho̱ Nti̱a̱ná nga b'a̱ kitsú: —Kju̱axi̱ kjáíhin nga na̱xu̱ nda̱i̱ nginku̱n Nti̱a̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ngayjee̱ xu̱ta̱ na̱nti̱a̱ xi i̱ncha kikie ni xi kamoo̱, i̱ncha kamankjihi̱n nga najmi nda tjín ni xi kin'e nga kin'ek'ien Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tu̱nga máha ngayjee̱ xu̱ta̱ xi behe̱ Jesu ko̱ jminchjín xi kitsjennkíhi̱ nk'ie nga tsitju xi tje̱hen a̱nte Galilea̱, kui xi kjin kabincha nga tíi̱ncha basehe̱ ni xi tímoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tíjñajihi̱n já tjíxóo̱ nku nda̱ xi 'mi Kuse xi Arimatea̱ nibáha, nanki xi tíjñajihi̱n Judea̱. Nda tjíya ani̱ma̱ha̱ ndo̱ ko̱ na̱xu̱ fiko̱ yjoho̱ nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ta̱ tíkuyaha̱ ni̱stjin nga ku̱a̱téxuma Nti̱a̱ná ko̱ najmi kits'ín yu ni xi y'énda ko̱ ni xi kits'ín já tjíxá xingisoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kui xi ngjisehe̱ Pilato̱ ko̱ tsankihi̱ yjonintehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nk'ie nga ja kikjeje̱nt'a kruu̱ yjonintehe̱ Jesu, a̱s'a̱i nku najyun kik'ontjikjájnu ko̱ ngjingjájñaya nku ti̱xa̱ tsjó xi kin'endat'á na̱xi̱u̱, xi ndaha nku najmi kje̱ ch'a s'eya. ");
INSERT INTO majNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kui ni̱stjiu̱n tís'enda nichinehe̱ S'í Pascu̱a̱ ko̱ ja tíb'atuts'i̱hi̱n ni̱stjin nkjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jminchjín xi kitsjennkíhi̱ Jesu nga tsitju a̱nte Galilea̱, ta̱ i̱ncha ngji ko̱ kikie tsjóo̱ ko̱ xi nkú ts'ín kis'ejña yjonintehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","A̱s'a̱i kik'óya ngáha ni'yaha̱ ko̱ y'énda ntá sinjne̱ ko̱ ni xi sinjne̱. Kits'ínkj'áíya jminchjíu̱n ni̱stjin nkjúu̱n xi nkú ts'ín tíjña kju̱a̱téxumoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nga ta̱ jyun ta̱ jyuhu̱n ni̱stjin xi b'atuts'i̱hi̱n ra̱ tuntjóo̱, j'aisehe̱ jminchjíu̱n tsjóo̱ nga y'a ts'íhin ni xi sinjne̱ xi y'énda. ");
INSERT INTO majNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nk'ie nga i̱ncha j'ai, kikie nga ja kachjuxín ndji̱o̱ chákantsú xi tjíchjane tsjóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","I̱ncha jas'en tu̱nga najmi kisakúhú ra̱ yjonintehe̱ Nda̱ Nti̱a̱ná Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nk'ie nga ndaha najmi i̱ncha be mí nihi xi i̱ncha ts'i̱ín, tu̱ i̱ncha kikiehé nga kabinchat'aha̱ jo já xi yja najyun xi tíbat'ai. ");
INSERT INTO majNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tu̱ ni xí kitsankjúhún jminchjíu̱n ko̱ kingjénsten a̱nkjín t'anankiu̱. Tu̱nga b'a̱há kitsú jóo̱: —¿Á a̱jihi̱n xu̱ta̱ k'ie̱n tíbinchisjáíhinu xi tíjña tík'un? ");
INSERT INTO majNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Najmi ta̱ e̱i̱ tíjñaha. Ja kaf'áíya ngáha̱ ra̱ ngabayoo̱. N'e̱kj'áítsjoho̱on yjonu̱u nga b'i̱ kitsúnu̱u nk'ie nga y'ejña a̱nte Galilea̱: ");
INSERT INTO majNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Tjíhin nga n'e̱kjas'en Ntíhi̱ Nda̱x'i̱u̱n a̱ya ntsja já ngatitsuu̱n ko̱ s'e̱t'a kruu̱. Ni̱stjin xi ma jahan kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱.” ");
INSERT INTO majNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","A̱s'a̱i j'áítsjehe̱n jminchjíu̱n ni xi kitsú Jesu ");
INSERT INTO majNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ko̱ nk'ie nga i̱ncha j'aihi tsjóo̱ kitsúyaha̱ ngayjee̱ ni xu'bi̱ já ni'yakuyá xi te nkuu̱ ko̱ ngayjee̱ xu̱ta̱ xingisoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria̱ Magdalena̱ ko̱ Juana̱ ko̱ Maria̱ xi na̱aha̱ Santiago̱ ko̱ jminchjín xingisoo̱ xi tje̱nko̱ho̱, kui xi j'ai tsúyaha̱ já postru̱ ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tu̱nga najmi kis'ejihín ra̱ já postru̱, a̱t'aha̱ én xi najmi tjíhi̱n sin kamaha̱ ni xi títsuya jminchjíu̱n. ");
INSERT INTO majNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tu̱nga tsisintje̱hén Pedro̱ ko̱ tsangatsanka nga ngji tsjóo̱. Nk'ie nga tsaseya tsjóo̱, kikie nga tu̱ najyun xi tsich'ontikjájnuhú yjonintee̱ kjijña yo̱. A̱s'a̱i kik'óya ngáha ni'yaha̱ nga tíma nkjúhu̱n ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta̱ kuihi ni̱stjin xu'bo̱ jo já ni'yakuyáha̱ Jesu yja nga tíi̱ncha fi nanki i̱chí xi 'mi Emau, nanki xi te nku ra̱ kilome̱tro̱ maha̱ nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tínchja̱ni̱jmíyako̱ho xinkjín ngayjee̱ ni xi kamoo̱ nga tíi̱ncha fi. ");
INSERT INTO majNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ni xi kama, nk'ie nga tínchja̱ni̱jmíyako̱ho xinkjín niu̱, j'aise tiñaha̱ Jesu ko̱ kitsjent'áha̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tu̱nga b'a̱ kama xi kis'echjahá tunku̱n jóo̱ kama. Najmi kamankjihi̱n tsa Jesu niu̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A̱s'a̱i b'i̱ kitsú Jesu: —¿Mí nihi xi tíchubani̱jmíyako̱honu xinki̱u nk'ie nga tín'o ni̱yá? A̱s'a̱i tsincha'yún baba jóo̱ ");
INSERT INTO majNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ko̱ b'a̱ kitsú nda̱ xi 'mi Cleofa̱: —¿A nku tutu ra̱ ji xi tinchin nanki Jerusalen xi najmi be ni xi kama ni̱stjin xi nibahaná yo̱? ");
INSERT INTO majNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","B'i̱ kitsú Jesu: —¿Mí nihi xi kama? B'a̱ i̱ncha kitsú jóo̱: —Ni xi kin'ehe̱ Jesu, nda̱ xi nibáha Nazaret. Kui xi kama nku nda̱ profeta̱ ko̱ chánka ni xi kits'ín. Kis'ehe̱ nga'yún én xi kinchja̱ nginku̱n Nti̱a̱ná ko̱ nginku̱n ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tu̱nga já na̱'mi k'aku̱hú ko̱ já tjíxáná kits'ínkjas'en tu̱ xi kin'ek'iehen, ko̱ kis'et'a kruu̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ji̱n kichuyái̱ tsakai nga kui xi ts'i̱ín nda̱íhi̱ na̱xi̱nantá Israel. Tu̱nga ja tjíhi̱n jan ni̱stjin nd'a̱i̱ nga b'a̱ kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","’K'u̱a̱ jminchjín xi tjínjinni̱ kabinchánkjúnni̱. Ta̱ jyun ta̱ jyun kafisehe̱ tsjóo̱, ");
INSERT INTO majNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tu̱nga najmi kasakúhú ra̱ yjonintee̱. Ntítsje rú i̱ncha kama chjihi̱ katsúni̱ ko̱ nga kui xi b'a̱ katsúhu̱ nga tíjña tík'un Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","A̱skahan ta̱ kafisehe̱ tsjóo̱ k'u̱a̱ já xi tjínjinni̱ ko̱ b'a̱ ts'ín kasakúhu̱ xi nkú nga katsú jminchjíu̱n, tu̱nga najmi kabehé Jesu. ");
INSERT INTO majNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","B'i̱ kitsú Jesu: —¡Á b'a̱ nkjún ts'ín i̱chí mankjihi̱nnu̱u ko̱ 'ni s'ejihi̱nnu̱u ngayjee̱ ni xi kitsúhu já profeta̱! ");
INSERT INTO majNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿A najmi tjíhin ni nga un sku̱e̱he̱ xi kits'ín nibá Nti̱a̱ná kintehe̱ ni nga sa̱kúhu̱ kju̱a̱chánka xi ts'e̱? ");
INSERT INTO majNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A̱s'a̱i Jesu y'éjña chjihi̱ jóo̱ nkú tsuhu̱ ra̱ ngayjee̱ xu̱ju̱n éhe̱n Nti̱a̱ná má tjít'a ni xi ka̱maha̱. Kik'atuts'i̱hi̱n ra̱ xu̱ju̱n xi y'ét'a Moise ko̱ ngjindjuko̱ ngayjee̱ xu̱ju̱n xi y'ét'a já profeta̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nk'ie nga tsichu nanki i̱chí xi má nga tíi̱ncha fi jóo̱, b'a̱ kits'ín xi kj'u̱a̱ ni̱yá Jesu kits'ín. ");
INSERT INTO majNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tu̱nga kits'ínkasín'yún kju̱a̱'yúhún ra̱ jóo̱ nga b'a̱ kitsúhu̱ Jesu: —Ti̱nchinko̱ni̱ e̱i̱, a̱t'aha̱ ja ngixun ko̱ ja tíma'ña̱. Kui nga kits'ín yuhu Jesu nga y'ejñako̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ni xi kama, nk'ie nga kab'entut'áko̱ yámixo̱ jóo̱, jakj'á Jesu ni̱nku̱o̱n ko̱ kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná. A̱s'a̱i tsakjánya ko̱ kitsjáha̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kui chu̱bo̱ tsix'ánki nku̱n jóo̱ ko̱ kamankjihi̱n nga Jesu niu̱. A̱s'a̱i Jesu kits'ínndyjajihi̱nsén yjoho̱ nginku̱n jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","B'i̱ ngján b'a̱ kitsúhu̱ xinkjín jóo̱: —¿A najmi tíf'ajin nd'íhí tíma ani̱ma̱ná nk'ie nga tínchja̱ko̱ná a̱ya ni̱yóo̱ ko̱ nk'ie nga títsuyaná nkú tsuhu̱ ra̱ ni xi tjít'a éhe̱n Nti̱aná? ");
INSERT INTO majNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ta̱ kuihi chu̱bo̱ i̱ncha tsisintje̱n ko̱ kik'óya ngáha nanki Jerusalen. I̱ncha kikie nga nku stíhín kats'ín yjoho̱ já ni'yakuyá xi te nkuu̱ ko̱ já xi tjíntuko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kui xi b'a̱ tíi̱ncha tsu: —Kju̱axi̱ kjáíhin nga ja kaf'áíya ngáha̱ ra̱ ngabayoo̱ Nda̱ Nti̱a̱ná ko̱ ja kuakakúchjihi̱ yjoho̱ Simon. ");
INSERT INTO majNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A̱s'a̱i kitsúya já xi joo̱ ni xi kamat'ain a̱ya ni̱yóo̱ ko̱ xi nkú ts'ín kamankjihi̱n nga Jesu niu̱ nga tsakjánya ni̱nku̱o̱n. ");
INSERT INTO majNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ta̱ tíi̱ncha nchja̱ha nk'ie nga j'ai sinjñajin masehe̱n Jesu ko̱ b'i̱ kitsú nga kikjaniña: —Kas'enu̱u kju̱a̱jyu. ");
INSERT INTO majNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tu̱ ni xí kitsankjúhún já ni'yakuyóo̱ ko̱ kits'ínnkjink'un nga nku se̱n xi tíma chjihi̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","B'i̱ kitsú Jesu: —¿Á tíbinkjuhunnu? ¿Á tín'entji̱hi̱ ru̱u yjonu̱u nga b'a̱ ts'ín tín'enkjíntak'uhunnu? ");
INSERT INTO majNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ahán niu̱. Cha̱so̱o ntsa̱ ko̱ tsu̱ká. N'e̱ko̱nú ko̱ cha̱se̱nú. Nku se̱n najmi tjíhi̱n yjo ko̱ ninta xi nkú ts'ín tíyo nga tjínna. ");
INSERT INTO majNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nk'ie nga ja b'a̱ kitsú, a̱s'a̱i tsakú ntsja ko̱ tsu̱ku̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tu̱nga najmi kje̱hé s'ejin sisihi̱n jóo̱, a̱t'aha̱ tsjo ṉkjún tíi̱ncha maha̱ ko̱ tíi̱ncha ma nkjúhu̱n. A̱s'a̱i b'i̱ kitsú Jesu: —¿A tíjñanu̱u i̱chí nichine e̱i̱? ");
INSERT INTO majNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","A̱s'a̱i kitsjáha̱ nku te tji̱o̱ xi kab'échjan. ");
INSERT INTO majNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jakj'á Jesu niu̱ ko̱ kikjine nginku̱n jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A̱s'a̱i b'a̱ kitsú: —Ni xi kama, kui nihi xi kixinnu̱u nk'ie nga tsáte̱jñajin sanu̱u. B'a̱ kixinnu̱u nga tjíhin nga ku̱i̱tjusun ngayjee̱ ni xi tjít'a nga kinchja̱ni̱jmíyahana xu̱ju̱n kju̱a̱téxumaha̱ Moise ko̱ xu̱ju̱hu̱n já profeta̱ ko̱ xu̱ju̱n salmo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kikjex'ájin Jesu kju̱a̱nkjintak'uhu̱n jóo̱ tu̱ xi ka̱mankjihi̱n ra̱ ni xi tjít'a éhe̱n Ntianá ");
INSERT INTO majNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ko̱ b'i̱ kitsúhu̱: —B'a̱ ts'ín tjít'a nga tjíhin nga un sku̱e̱he̱ xi kits'ín nibá Nti̱a̱ná, nga ni̱stjin xi ma jahan kj'u̱a̱íya ngáha̱ ra̱ a̱jihi̱n xu̱ta̱ k'ie̱n, ");
INSERT INTO majNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ko̱ nga ngajoho̱ s'e̱ni̱jmí nga ngúsuhu̱n a̱sunntee̱. Jerusalen ch'a̱tuts'i̱hi̱n ra̱ nga b'a̱ k'úíhi̱n xu̱ta̱ nga tjíhin nga ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱ tu̱ xi ka̱ma ndyjat'aha̱ ra̱ ngatitsuhun. ");
INSERT INTO majNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jun xi ku̱i̱xínyo ni xi kiyo. ");
INSERT INTO majNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","An ts'in nibánu̱u xi kitsúya títjun Na̱'mina̱ nga tsjánu̱u. Tu̱nga ti̱ntsu̱ba̱nú e̱i̱ Jerusalen santa nkúhu nga n'e̱kjóho̱on nga'yún xi ni̱baha nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","A̱s'a̱i tsitjuko̱ Jesu já ni'yakuyáha̱. Ngjiko̱ santaha nanki Betani̱a̱. Kingjénnk'a ntsja ko̱ nda kinchja̱ne jóo̱. ");
INSERT INTO majNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nk'ie nga nda tínchja̱ne jóo̱, nk'a ján ngji t'axíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nk'ie nga ja i̱ncha kamaha̱ nga kits'íntsjoho̱ Jesu, tu̱ ni xí tsjohó tíi̱ncha maha̱ jóo̱ nga i̱ncha kik'óya ngáha nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tehe̱nte i̱ncha kits'íntsjoho̱ Nti̱a̱ná má ma na̱tsihi̱n ni̱nku̱.");
INSERT INTO majNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nga tuts'ihi̱n ni tu̱ b'a̱ ts'ín jahá tíjña Ée̱n. Kui Ée̱n xi y'ejñako̱ho̱ Nti̱a̱ná. Kui Ée̱n xi Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kui xi y'ejñako̱ Nti̱a̱ná nkúhu nga tuts'ihi̱n ni. ");
INSERT INTO majNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ée̱n kits'ínndako̱ho Nti̱a̱ná ngayjee̱ ni xi tjín. Ndaha nku ni xi tjín najmi kin'enda tsa najmi tjín Ée̱n. ");
INSERT INTO majNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yo̱ nibáha̱ ra̱ kju̱a̱tík'un. Kui kju̱a̱tík'uu̱n, kui nd'í xi ts'ín ndzjehe̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ndíi̱ tíb'at'ai má jyuu̱n ko̱ má jyuu̱n najmi tíchúkju̱a̱ha̱ nga títs'ínk'ien. ");
INSERT INTO majNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","J'ai nku nda̱ xi 'mi Jua xi Nti̱a̱ná kits'ín nibáha̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","J'ai tsúya ni xi kikie tu̱ xi ku̱i̱tsu̱yaha yáha nd'íu̱ ko̱ tu̱ xi s'e̱jihi̱n ra̱ ngayjee̱ xu̱ta̱ nd'í xi j'ai nchja̱ni̱jmíyaha. ");
INSERT INTO majNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Najmi kui xi nd'íu̱. Tu̱ kin'e nibáhá tu̱ xi ku̱i̱tsu̱yaha yáha nd'íu̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nd'í xi ndoo̱ xi ts'ín ndzjehe̱n ngayjee̱ xu̱ta̱ ja ma kj'u̱a̱íhí a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ée̱n j'aik'iejña a̱sunntee̱, Én xi Nti̱a̱ná kits'ínndako̱ho a̱sunntee̱. Tu̱nga xu̱ta̱ a̱sunntee̱ najmi kamankjihi̱n yáha kui. ");
INSERT INTO majNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","J'ai a̱nte xi ts'e̱, tu̱nga xu̱ta̱ xi ts'e̱ najmi kits'ínkjáíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tu̱nga xi kits'ínkjáíhi̱n ko̱ kis'ejihi̱n, kui xu̱ta̱ha xi kitsjáha̱ nga ka̱ma ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kui xi kitsin xi nkú ts'ín kama mjehe̱ Nti̱a̱ná. Najmi kitsin xi nkú ts'ín tsin xu̱ta̱ xi tjín, ko̱ ta̱ ndaha najmi xi nkú ts'ín tíjñaha̱ xu̱ta̱, ko̱ ta̱ ndaha najmi xi nkú ts'ín mjehe̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kui Ée̱n xi kik'a yjoninte ko̱ y'ejñajinni̱ ko̱ kiyai̱ kju̱a̱chánkaha̱, a̱t'aha̱ kui xi Ntí nku tutuhu̱ Nti̱a̱ Na̱'miu̱. Tsakúchji kju̱a̱nda chánkaha̱ ko̱ én xi b'a̱ tjíu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jua kitsúya yáha kui. B'i̱ kitsú: —Kui xi kinchjani̱jmíyahana nga b'a̱ kixian: “Xi a̱skahan nibá nga an, kui xi tjun nga an, a̱t'aha̱ kui xi tu̱ b'a̱ ts'ín jahá tíjña.” ");
INSERT INTO majNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Xki̱ kju̱a̱nda xi kik'a̱i̱ná kju̱a̱nchi̱ná chánka xi ts'e̱ tsitjujihin. ");
INSERT INTO majNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","A̱t'aha̱ Nti̱a̱ná kits'ínchjén Moise nga kitsjá kju̱a̱téxumoo̱, tu̱nga j'aihí Jesucristo̱ nga y'éjña kju̱a̱ndoo̱ ko̱ én xi na̱xu̱ tjín. ");
INSERT INTO majNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Najmi tjín xi ja be nkú tjín Nti̱a̱ná. Nku tutuhú Ntí nku tutuu̱ xi tíjñako̱ Nti̱a̱ Na̱'miu̱, kui xi j'aikúchjiná Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","B'i̱ ts'ín kinchja̱ Jua nk'ie nga já judio̱ k'aku̱ xi tjín nanki Jerusalen kits'ínkji já na̱'mi ko̱ já xi ta̱ ts'ínxát'a ni̱nku̱ xi má nga ngju̱ásjaiyaha̱ Jua yáha kui. ");
INSERT INTO majNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kinchja̱ kixi̱ kixi̱ Jua ko̱ najmi ts'ana̱cha̱. B'i̱ kitsú: —Najmi an nda̱ xi xi kitsú Nti̱a̱ná nga ts'i̱ín nibá. ");
INSERT INTO majNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","B'a̱ kitsú jóo̱ nga kingjásjaiyaha̱: —¿Yáhá ni ji? ¿A jihí xi Elia̱? —Najmi an —kitsú Jua. —¿A jihí xi nda̱ profeta̱ xi tjíhin nga kj'u̱a̱í? —kitsú jóo̱. —Najmi —kitsú Jua. ");
INSERT INTO majNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—¿Yáha ji? —ta̱ kitsú ngáha jóo̱—. A̱t'aha̱ tjíhin nga kuankínko̱ ngáha̱ ri̱ én kixi̱ já xi kits'ín nibáni̱. ¿Nkú bixín? ");
INSERT INTO majNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A̱s'a̱i b'i̱ kitsú Jua: —An xi nku nda̱ xi tínchja̱ a̱nte kixiu̱ nga b'a̱ títsu: “Tjen kixi̱u ni̱yá má nga nibá Nti̱a̱ná.” Kui niu̱ xi y'ét'a nda̱ profeta̱ Isaia̱ xu̱ju̱n éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ko̱ já xi kits'ínkji já fariseo̱ ");
INSERT INTO majNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ta̱ kingjásjaiyaha̱ Jua: —Tsa najmi ji xi kitsú Nti̱a̱ná nga ts'i̱ín nibá ko̱ ta̱ ndaha Elia̱ ko̱ ta̱ ndaha nda̱ profeta̱ xi tjíhin nga kj'u̱a̱í, ¿á xu̱ta̱ tíbatentáhani? ");
INSERT INTO majNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","B'i̱ kitsú Jua: —An ntánijua tíbatentáko̱hona xu̱ta̱, tu̱nga síjñajihínnu̱u nku xi najmi yo, ");
INSERT INTO majNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","xi kj'u̱a̱í a̱skahan nga an. Najmi tje̱henna tsa kjendáya n'úhu̱ tja̱ba̱xín ntéhe̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","B'a̱ kama ni xu'bi̱ nanki xi 'mi Betani̱a̱, nanki xi tíjña ngabantá ntáje̱ Jordan, má tsaténtá xu̱ta̱ Jua. ");
INSERT INTO majNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ni̱stjin xi ma ndyjuu̱n ngáha kikie Jua nga Jesu nibák'un tiñaha̱ ko̱ b'i̱ kitsú: —Kui xu'bi̱ xi chu̱tsa̱nka̱ha̱ Nti̱a̱ná xi kjexín ngatitsuhu̱n xu̱ta̱ a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kui xi kinchjani̱jmíyahana nga b'i̱ kixian: “Xi a̱skahan nibá nga an, kui xi tjun nga an, a̱t'aha̱ kui xi tu̱ b'a̱ ts'ín jahá tíjña.” ");
INSERT INTO majNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nk'ie ta̱ ndaha an najmi be yá níhi, tu̱nga ntánijuahá jái̱tentá xu̱ta̱ tu̱ xi s'e̱jña chjihi̱ ra̱ xu̱ta̱ Israel yáha kui. ");
INSERT INTO majNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","B'i̱ ta̱ kitsúya Jua ni xi kikie: —Kikie nga nibajen Espiri̱tu̱ ndji̱o̱jmi ján xi nkú joyaha nku chu̱tuju ko̱ nga j'aik'iejñantjai nintaku̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ta̱ ndaha an najmi kje̱e be yá níhi, tu̱nga xi kits'ín nibáhána nga ntánijua kuatentáhana xu̱ta̱, kui xi b'a̱ kitsúna: “Xi cha̱i̱ nga ni̱bajenk'uhu̱n Espiri̱tu̱ ko̱ k'úéjñantjaihi̱, kui xi Espiri̱tu̱ Santo̱ ku̱a̱téntáko̱ho xu̱ta̱.” ");
INSERT INTO majNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","An kikie nga tsitjusun kui ée̱n ko̱ tíxinya nga kui xi Ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nk'ie nga kama ndyjuu̱n, ta̱ yo̱hó tíi̱nchako̱ ngáha Jua jo já ni'yakuyáha̱. Kikie nga j'a Jesu yo̱ ko̱ b'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","—Kui xu'bo̱ xi chu̱tsa̱nka̱ha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kint'é nga joo̱ já ni'yakuyáha̱ ni xi kinchja̱ ko̱ kitsjennkíhi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","A̱s'a̱i tsasenji a̱stu̱n Jesu ko̱ kikie nga tje̱nnkihi̱ jóo̱. B'i̱ kitsúhu̱: —¿Mí xi tíbinchisjó? —Ji nda̱ maestru̱ —kitsú jóo̱—, ¿má tinchin? ");
INSERT INTO majNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Nibáa̱so̱ho̱o —kitsú Jesu. A̱s'a̱i ngji jóo̱ ko̱ kikie má tíjña Jesu. Yo̱ kits'ínkj'a ni̱stjin xu'bo̱, a̱t'aha̱ ja ngixun. Nkú ra̱ ma nga chu̱ba̱ ñju niu̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Já xi joo̱ xi kint'é ni xi kinchja̱ Jua ko̱ kitsjennkíhi̱ Jesu, nku xi 'mi Andre xi nda̱ nts'e̱ maha Simon Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kui xi títjun ngjingisjai Simon ko̱ b'a̱ kitsúhu̱: —Ja kuasakúni̱ nda̱ xi kitsú Nti̱a̱ná nga ts'i̱ín nibá. ");
INSERT INTO majNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A̱s'a̱i j'aiko̱ Andre nda̱ nts'e̱ nga j'aisehe̱ Jesu. Jesu tsasehe̱ Simon ko̱ b'i̱ kitsúhu̱: —Ji xi Simon, ntíhi̱ Jona. Ji xi k'úín ngáha ri Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ni̱stjin xi ma ndyjuu̱n, nk'ie nga tífi Jesu a̱nte Galilea̱, a̱s'a̱i ngjisehe̱ Felipe̱ ko̱ b'i̱ kitsúhu̱: —Tsjénnkiní. ");
INSERT INTO majNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nanki Betsaida̱ nibáha Felipe̱, má nga ta̱ nankihi̱ Andre ko̱ Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","A̱s'a̱i Felipe̱ ngjisehe̱ Natanael ko̱ b'a̱ kitsúhu̱: —Ja kuasakúni̱ nda̱ xi kinchja̱ni̱jmíyaha Moise nga y'ét'a xu̱ju̱n kju̱a̱téxumoo̱ ko̱ xi ta̱ y'ét'a já profeta̱. Kui xi Jesu ntíhi̱ Kuse, nda̱ xi nibáha nanki Nazaret. ");
INSERT INTO majNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","B'a̱ kitsú Natanael: —¿A ka̱mahá stjújin Nazaret nku ni xi nda? —Nibáa̱se̱i̱hi̱ —kitsú Felipe̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nk'ie nga kikie Jesu nga nibá tiña Natanael, b'a̱ kitsú: —Kuihí nda̱ xu'bi̱ xi xu̱ta̱ Israel tje̱he̱n ra̱, nku nda̱ xi najmi b'ana̱cha̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—¿Nkú ts'ín yahaní? —kitsú Natanael. B'i̱ kitsú Jesu: —Kuakiehe kintehe̱ ni nga kuanchja̱hi Felipe̱, nk'ie nga kabinchunnkí yá higuera̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Ji nda̱ maestru̱ —kitsú ngáha Natanael—, ji xi Ntíhi̱ Nti̱a̱ná. Ji xi nda̱ rei̱hi̱ xu̱ta̱ Israel. ");
INSERT INTO majNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","B'i̱ kitsú Jesu: —¿A a̱t'aha̱ kuakiehe kintehe̱ yá higuera̱ kuaxihin, a kui kju̱a̱ha nga kuas'ejihin ri nga Nti̱a̱ná kits'ín nibáhana? 'Yún chánka ni xi cha̱ sai nga xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ko̱ b'i̱ ta̱ kitsú ya Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Cho̱o nga tsjén ti̱xa̱ ndji̱o̱jmi ján ko̱ nga ntítsjehe̱ Nti̱a̱ná ku̱i̱yájnu ko̱ ku̱i̱tjujen nga kj'u̱a̱ísehe̱ Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ni̱stjin xi ma jahan kama nku kju̱a̱bixan nanki Cana, nanki xi tíjñajihi̱n a̱nte Galilea̱, ko̱ yo̱ ngji na̱aha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ta̱ ngji Jesu ko̱ já ni'yakuyáha̱ kju̱a̱bixoo̱n, a̱t'aha̱ kik'inyaha̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nk'ie nga jeya binu̱, a̱s'a̱i b'a̱ kitsú na̱aha̱ Jesu nga kinchja̱ko̱ho̱: —Ja najmi ta̱ tjíhi̱n ra̱ binu̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Ji ta̱chju̱ún —kitsú Jesu—, ¿á an tí'miyahaní niu̱? Najmi kje̱e bichú chu̱ba̱na̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A̱s'a̱i kinchja̱ko̱ na̱aha̱ Jesu já xi tíi̱ncha basehe̱ yámixo̱ nga b'a̱ kitsúhu̱: —N'e̱tjusun ngayjee̱ ni xi ku̱i̱tsu̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yo̱ tíi̱ncha jun ndji̱í nisa xi kamandako̱ho ndji̱o̱. Kui xi ts'ínchjén xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ nk'ie nga ts'ín je yjoho̱ nginku̱n Nti̱a̱ná, xi nkú ts'ín tíjña ni̱yáha̱. Nkúnkú ndji̱íu̱ s'en ra̱ tsa cháte ko̱ tsa cháte ko̱ kan litru̱ ntánijua. ");
INSERT INTO majNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","B'i̱ kitsúhu̱ Jesu já xi tíi̱ncha basehe̱ yámixo̱: —N'e̱tso ntánijua ndji̱íi̱. Kits'íntse susun jóo̱ ndji̱íu̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","A̱s'a̱i Jesu b'i̱ kitsúhu̱ jóo̱: —Chjúbó chuba ko̱ tankínko̱ho nda̱ xi tíbasehe̱ s'íu̱. B'a̱ i̱ncha kits'ín jóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","A̱s'a̱i kikjut'a nda̱ xi tíbasehe̱ s'íu̱ ntánijua xi ja kama binu̱, tu̱nga najmi behé má nibaha̱ ra̱ ntóo̱. Tu̱ já xi tíi̱ncha basehé ra̱ yámixo̱ xi be, a̱t'aha̱ kui xi ts'asje ntánijuo̱. Kui nga nda̱ xi tíbasehe̱ ra̱ s'íu̱ kinchja̱ha̱ ra̱ nda̱ bixoo̱n ko̱ b'a̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Ngayjee̱ xu̱ta̱ títjun tsjá binu̱ xi nda ko̱ nk'ie nga ja 'yún ka'bi xu̱ta̱, a̱s'a̱i ní tsjá xi najmi 'yún ndaha̱. Tu̱nga máha ji, binu̱ xi 'yún nda xi tjítjoihi nd'a̱i̱ tí'ba̱i̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kui kju̱a̱nkjún xu'bi̱ xi títjun kits'ín Jesu nanki Cana, nanki xi tíjñajihi̱n a̱nte Galilea̱. B'a̱ ts'ín tsakúchjihi kju̱a̱chánkaha̱, ko̱ kis'ejihi̱n já ni'yakuyáha̱ nga Nti̱a̱ná kits'ín nibáha̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ja kamoo̱. A̱s'a̱i ngji Jesu nanki Capernaum nga tje̱nko̱ na̱aha̱ ko̱ já nts'e̱ ko̱ já ni'yakuyáha̱. Yo̱ y'entu chuba ni̱stjin. ");
INSERT INTO majNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nk'ie nga ja tíbichú tiña S'í Pascu̱a̱ xi b'asje xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱, a̱s'a̱i ngji Jesu nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Má ma na̱tsihi̱n ni̱nku̱ kisakúhu̱ já xi tíi̱ncha batéña turu̱ ko̱ chu̱tsa̱nka̱ ko̱ chu̱tuju ko̱ já xi tjíntu yo̱ nga tíi̱ncha ts'ínk'óntjaiya to̱on. ");
INSERT INTO majNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","A̱s'a̱i jách'á n'ú'ya̱, kui xi kik'onsjeko̱ho ngayjee̱ chu̱tsa̱nko̱ ko̱ turu̱. Kikjaní ndzjo to̱oho̱n já xi tíi̱ncha ts'ínk'óntjaiya to̱on yo̱ ko̱ kits'ínk'ótsjá yámixa̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","B'i̱ kitsúhu̱ já xi tíi̱ncha batéña chu̱tuju: —Ti̱ch'onsjo̱o chu̱nu̱u e̱i̱. Najmi tu̱ tiyanta̱ n'e mo ni'yaha̱ Na̱'mina̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","J'áítsjehe̱n já ni'yakuyáha̱ nga b'i̱ ts'ín tjít'a éhe̱n Nti̱a̱ná: “Tjo ts'atina ni'yahi̱, kui nga tíb'enkíhina kju̱a̱ni̱ma̱.” ");
INSERT INTO majNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A̱s'a̱i já judio̱ k'aku̱ kingjásjaiyaha̱ Jesu: —¿Mí kju̱a̱nkjúhun xi ku̱a̱kúchji nga ma n'e ni xi tín'ei? ");
INSERT INTO majNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","B'i̱ ts'ín kinchja̱ Jesu: —N'e̱katsúnyo ni̱nku̱ ko̱ jan ni̱stjin kjesíntje̱n ngáhana. ");
INSERT INTO majNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","B'i̱ kitsú já judio̱ k'aku̱: —Yachán jun nú kamandaha ni̱nku̱. ¿Nkú ts'ín jan ni̱stjin chjúsíntje̱henni ji? ");
INSERT INTO majNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tu̱nga yjonintehe̱ ní Jesu kinchja̱ni̱jmíyaha nga kits'ínkjó ni̱nku̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kui kju̱a̱ha, nk'ie nga j'áíya ngáha̱ ra̱ ngabayoo̱, j'áítsjehe̱n ra̱ já ni'yakuyáha̱ ni xi kitsú ko̱ kis'ejihi̱n én xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná ko̱ én xi kinchja̱ko̱ já judio̱ k'aku̱. ");
INSERT INTO majNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nk'ie nga tíjña Jesu nanki Jerusalen a̱jihi̱n S'í Pascu̱a̱, nkjin ṉkjún xu̱ta̱ kis'ejihi̱n nk'ie nga kikie kju̱a̱nkjún xi kits'ín. ");
INSERT INTO majNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tu̱nga Jesu najmi kits'ínkjáíhi̱n xi nkú ts'ín ts'ínnkjink'un xu̱to̱, a̱t'aha̱ be xi nkú k'un. ");
INSERT INTO majNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Najmi kamachjén tsa tjín xi kitsúyaha̱ nkú k'un, a̱t'aha̱ be xi nkú ts'ín tjíntuyá ani̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nku nda̱ fariseo̱ xi 'mi Nicodemo̱ xi ta̱ nda̱ k'aku̱hu̱ xu̱ta̱ judio̱ ");
INSERT INTO majNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","j'aisehe̱ Jesu nga jyuu̱n ko̱ b'i̱ kitsúhu̱: —Ji nda̱ maestru̱, yaníi̱ nga ji xi nku nda̱ maestru̱ xi Nti̱a̱ná kits'ín nibáha̱. A̱t'aha̱ najmi ch'a ka̱maha̱ ts'i̱ín kju̱a̱nkjún xi tín'ei tsa najmi tíjñajihi̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","B'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxihin. Xi najmi tsin tse̱tse̱, kui xi najmi ma chjihi̱ xi nkú ts'ín batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","B'a̱ kitsú Nicodemo̱: —¿Nkú ts'ín tsín tse̱tse̱ ngáha nku nda̱ nk'ie nga ja chá? ¿A ka̱mahá ta̱ kju̱a̱s'en xi ma johó ngáha a̱ya ka̱ts'a̱ na̱aha̱ ko̱ tsín ngáha? ");
INSERT INTO majNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","B'i̱ ts'ín kinchja̱ Jesu: —Kju̱axi̱ ni xi tíxihin. Xi najmi tsínjin ntánijua ko̱ Espiri̱tu̱ najmi ka̱ma kju̱a̱s'enjin nga Nti̱a̱ná xi ku̱a̱téxumaha̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Xi xu̱ta̱ tsjáha̱ kju̱a̱tík'un, kui xi kju̱a̱tík'uhu̱n xu̱ta̱ tjíhi̱n. Xi Espiri̱tu̱ tsjáha̱ kju̱a̱tík'un, kui xi kju̱a̱tík'uhu̱n Espiri̱tu̱ tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Najmi tu̱ ma nkjúhin ni xi kuaxihin, nga tjíhin nga tsín tse̱tse̱ ngáhanu. ");
INSERT INTO majNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fi ntjo̱ tu̱ má nga mjehé ra̱ ko̱ ta̱ nu'yáí nga xu. Tu̱nga najmi yaní má nibáha ko̱ má tífi. B'a̱ joyaha ngayjee̱ xu̱ta̱ xi tsinjín Espiri̱tu̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","B'a̱ kitsú Nicodemo̱: —¿Nkú tjíhi̱n ra̱ ni xi tíbixín? ");
INSERT INTO majNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","B'i̱ ts'ín kinchja̱ Jesu: —Ji xi nda̱ maestru̱hu̱ xu̱ta̱ Israel. ¿A najmi yaní niu̱? ");
INSERT INTO majNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kju̱axi̱ ni xi tíxihin. Ji̱n chubai̱ ni xi yai̱ ko̱ bixínyai̱ ni xi kiyai̱, tu̱nga jun najmi n'e s'ejiun én xi bixínyai̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tsa najmi s'ejinnu̱u énna̱ nk'ie nga ni xi ts'e̱ a̱sunntei̱ tínchjani̱jmíyaha̱nu̱u, ¿nkú ts'ín s'e̱jihi̱nnu̱u énna̱ tsa ni xi ts'e̱ ndji̱o̱jmi ján kuinchjani̱jmíyaha̱nu̱u? ");
INSERT INTO majNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ndaha nku najmi kje̱e fi ndji̱o̱jmi ján. Nkuhú Ntíhi̱ Nda̱x'i̱u̱n xi nibajehen yo̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","’Xi nkú ts'ín kikjesíntje̱n Moise ye̱ a̱nte kixiu̱ nk'ie, b'a̱ ta̱ ts'ín tjíhin nga chjúsíntje̱n Ntíhi̱ Nda̱x'i̱u̱n, ");
INSERT INTO majNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tu̱ xi najmi ndyja̱ha xi s'e̱jihi̱n ra̱ kui nga tu̱ sahá k'úéntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Kits'íntjo Nti̱a̱ná xu̱ta̱ a̱sunntee̱ nga kitsjá Ntí nku tutuhu̱ tu̱ xi najmi ndyja̱ha xi s'e̱jihi̱n ra̱ kui, nga tu̱ sahá k'úéntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nti̱a̱ná najmi kits'ín nibá Ntíhi̱ a̱sunntee̱ tsa tu̱ xi k'u̱éjñanehe̱ ra̱ xu̱ta̱ ni xi kanéhe̱ nga̱t'aha̱ ngatitsun xi kits'ín. Kits'ín nibá ní tu̱ xi ts'i̱ínk'ankihi. ");
INSERT INTO majNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Xi s'ejihi̱n Ntíhi̱ Nti̱a̱ná najmi tjín ni xi ngju̱a̱i̱néhe̱. Tu̱nga xi najmi s'ejihi̱n, kui xi ja tje̱n jé a̱t'aha̱ najmi kis'ejihi̱n Ntí nku tutuhu̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kui nga̱t'ai̱ tje̱he̱n ra̱ jé xu̱ta̱. J'ai a̱sunntee̱ nd'í xi ts'ín ndzjehe̱n xu̱ta̱, tu̱nga 'yúhún kama mjehe̱ xu̱ta̱ má jyuu̱n nga má ndzjee̱n, a̱t'aha̱ najmi nda tjín ni xi tíi̱ncha ts'ín. ");
INSERT INTO majNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ngayjee̱ xi ch'on ts'ín, kui xi ch'oho̱n nd'í xi ts'ín ndzjehe̱n. Najmi fik'úhu̱n tu̱ xi najmi cha̱ha ni xi tíi̱ncha ts'ín. ");
INSERT INTO majNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tu̱nga xi na̱xu̱ ts'ín, kui xi fik'úhu̱n nd'íu̱ tu̱ xi cha̱ha nga tíi̱ncha ts'ín xi nkú ts'ín mjehe̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","A̱skahan nga b'a̱ kamoo̱ ngjiko̱ Jesu já ni'yakuyáha̱ a̱nte Judea̱. Yo̱ y'ejñako̱ já ni'yakuyáha̱ chuba ni̱stjin nga tsaténtá xu̱ta̱ xi tjín yo̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jua ta̱ tsaténtá xu̱ta̱ nanki Enon, yo̱ má tiña maha̱ nanki Salim, a̱t'aha̱ 'yún tjín ntánijua yo̱. I̱ncha j'ai xu̱ta̱ nga kisaténtá yo̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","B'a̱ kama nk'ie nga najmi kje̱e s'eya'yún Jua. ");
INSERT INTO majNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A̱s'a̱i já ni'yakuyáha̱ Jua ko̱ nku nda̱ judio̱ kinchja̱ni̱jmíyaha xi nkú ts'ín tjíhin nga ts'i̱ín je yjoho̱ xu̱ta̱ judio̱ nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","I̱ncha ngjisehe̱ Jua ko̱ b'a̱ kitsúhu̱: —Ji nda̱ maestru̱, nda̱ xi j'aisehi ngabantá ntáje̱ Jordan, xi tsixínyai yáha kui, kui xi ta̱ tíbaténtá ko̱ ngayjee̱ xu̱ta̱ tíi̱ncha fisehe̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A̱s'a̱i b'i̱ ts'ín kinchja̱ Jua: —Ndaha nku ni najmi ma ts'ínkjáíhi̱n xu̱ta̱ tsa najmi ndji̱o̱jmi ján kik'a̱i̱hi̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jun kinu'yó ni xi kinchja, nga najmi an nda̱ xi ts'i̱ín nibá Nti̱a̱ná ngajoho̱. Tu̱ kin'e nibá títjuhúnna. ");
INSERT INTO majNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Xi nkúhu tsa nku kju̱a̱bixan, nkuhú nda̱ xi tíbixan. Nda̱ xinkjín nda̱ bixoo̱n tu̱ síjñat'ahá ra̱. Tímjéñjuhu̱ ni xi tínchja̱ ko̱ tsjo tímaha̱ nga tínt'é nta̱ha̱ nda̱ bixoo̱n. B'a̱ ts'ín an nd'a̱i̱. Ja tsichu ma ndju̱ú kju̱a̱tsjona̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kui ndo̱ xi tjíhin nga nk'a ngju̱a̱i̱, an kinte kfíán. ");
INSERT INTO majNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Xi nibáha nk'a ján 'yún chánka sa nga tu̱ yáhá ni. Xi tje̱he̱n ra̱ a̱sunntee̱, kui xi xu̱ta̱ a̱sunnte ko̱ ni xi ts'e̱ a̱sunntee̱ nchja̱. Xi nibáha ndji̱o̱jmi ján 'yún chánka sa nga tu̱ yáhá ni. ");
INSERT INTO majNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Títsuya ni xi kikie ko̱ ni xi kint'é, tu̱nga najmi ch'a tís'ejihín ra̱ én xi tínchja̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tu̱nga xi tís'ejihi̱n én xi tínchja̱, kui títs'ínkie yjoho̱ nga kju̱axi̱ én xi nchja̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","A̱t'aha̱ xi kits'ín nibá Nti̱a̱ná, kui xi nchja̱ éhe̱n Nti̱a̱ná, a̱t'aha̱ Nti̱a̱ná kitsjáyjehe̱ Espiri̱tu̱. ");
INSERT INTO majNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nti̱a̱ Na̱'miu̱ 'yún tjoho̱ Ntíhi̱ ko̱ ngayjee̱ ni xi tjín ja kits'ínkjas'en a̱ya ntsja. ");
INSERT INTO majNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Xi tís'ejihi̱n Ntíu̱, kui xi tíjña tík'un sín. Tu̱nga xi najmi tíma mjehe̱ nga ku̱i̱nt'é éhe̱n Ntíu̱, kui xi najmi k'úéjña tík'un. Kju̱a̱kjaha̱n Nti̱a̱ná tíjñanehe̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kik'inyaha̱ já fariseo̱ nga Jesu 'yún tjín saha̱ xu̱ta̱ ni'yakuyá nga Jua ko̱ nga 'yún nkjin xu̱ta̱ tíbaténtá. ");
INSERT INTO majNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tu̱nga najmi Jesu xi tsaténtá xu̱ta̱. Já ni'yakuyáha̱ ní xi b'a̱ kits'ín. ");
INSERT INTO majNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nk'ie nga kint'é Jesu ni xi kik'inyaha̱ já fariseo̱, a̱s'a̱i tsitju a̱nte Judea̱ nga kik'óya ngáha a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tjíhin nga kj'u̱a̱ a̱nte Samari̱a̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kui nga j'aihi Sicar, nanki xi tíjñajihi̱n a̱nte Samari̱a̱. Tíjñakjoko̱ xu'ba xi Jacob kitsjáha̱ Kuse xi ntíhi̱ maha. ");
INSERT INTO majNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yo̱ tíjña ntá ti̱xa̱ xi kits'ínnda Jacob. A̱s'a̱i ngjik'iejñat'a Jesu ntá ti̱xo̱, a̱t'aha̱ ja kafentaha̱ nga títs'ín ni̱yá. Nkú ra̱ ma nga chu̱ba̱ te jo niu̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","A̱s'a̱i j'ai nku ta̱chju̱ún Samari̱a̱ nga j'aik'asje ntánijua. B'i̱ kitsú Jesu: —K'u̱a̱i̱ní i̱chí ntánijua xi k'u̱i̱a̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kui chu̱bo̱ najmi tjíntuko̱ho̱ já ni'yakuyáha̱, a̱t'aha̱ nichine i̱ncha kafík'atse a̱jin na̱nti̱o̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A̱s'a̱i b'i̱ kitsú ta̱chjúu̱n: —¿Nkú tjíhi̱n ra̱ nga an tíbinchihiní ntánijua xi s'i̱hini, nga ji xi chá judio̱ ko̱ an xi na̱ Samari̱a̱? B'a̱ kitsú ta̱chjúu̱n a̱t'aha̱ najmi nda i̱ncha y'a xinkjín xu̱ta̱ judio̱ xu̱ta̱ Samari̱a̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","B'i̱ kitsú Jesu: —Tsa yai ni xi tsjá Nti̱a̱ná ko̱ tsa yai yá xi tíbankihi ntánijua, ji ku̱i̱nchíhi̱ ko̱ kui tsjáhi ntánijua xi ts'ínk'íéntu tík'uhu̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Ji chá nti̱a̱ —ta̱ kitsú ngáha ta̱chjúu̱n—, najmi tjíhin ni xi n'e̱sjeko̱honi ntánijuo̱ ko̱ 'yún na̱nka̱ ntá ti̱xo̱. ¿Má k'úínchj'ahani ntánijua xi ts'ínk'íéntu tík'uhu̱n xu̱ta̱? ");
INSERT INTO majNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ntje̱ cháná Jacob y'éjñaná ntá ti̱xa̱i̱. Kui xi ta̱ kits'i ntánijuaha̱ ko̱ ta̱ kits'i ntíhi̱ ko̱ chu̱ xi kis'ehe̱. ¿A jihí xi 'yún chánka sai nga kui? ");
INSERT INTO majNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A̱s'a̱i b'i̱ kitsú Jesu: —Ngayjee̱ xi k'úí ntánijua xu'bi̱ ta̱ ka̱ma xintá ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tu̱nga xi k'úí ntánijua xi tsjaha̱, kui xi ndaha̱chí najmi ta̱ ka̱ma xintáha̱ ra̱. A̱t'aha̱ ntánijua xi tsjaha̱ ka̱ma a̱jihi̱n xu̱ta̱ xu'bo̱ xi nkú joyaha nku ntá ti̱xa̱ xi bitju subaha̱ ntánijua. B'a̱ ts'ín k'úéntu tík'un síhin. ");
INSERT INTO majNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Ji chá nti̱a̱ —kitsú ta̱chjúu̱n—, k'u̱a̱i̱ní ntánijua xu'bo̱ tu̱ xi najmi ta̱ ka̱ma xintáhana ko̱ najmi ta̱ kj'úái̱k'asjéhena ntánijua e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—T'in chu̱baihi̱ x'i̱hi̱n ko̱ nibáko̱i̱ —kitsú Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Najmi tjínna x'i̱n —kitsú ta̱chjúu̱n. A̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíbixín, nga najmi tjíhin x'i̱n. ");
INSERT INTO majNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A̱t'aha̱ ja ma un x'i̱n binchunko̱i̱ ko̱ nda̱ xi tinchunko̱i̱ nd'a̱i̱ najmi x'i̱hi̱n maha. Kju̱axi̱ ni xi kuakixín. ");
INSERT INTO majNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Ji chá nti̱a̱ —kitsú ta̱chjúu̱n—, tímankjinna nga chá profeta̱ ní. ");
INSERT INTO majNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ntje̱ cháni̱ kits'íntsjoho̱ Nti̱a̱ná na̱xi̱ xu'bi̱. Tu̱nga máha jun, b'a̱ bixíún nga Jerusalen tíjña a̱nte má nga tjíhin nga n'e̱tsjoho̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Ji ta̱chju̱ún —kitsú Jesu—, n'e̱ s'ejin ni xi tíxihin. Ku̱i̱chú chu̱ba̱ nk'ie nga najmi ta̱ kjúái̱hinu na̱xi̱ xu'bi̱ ko̱ najmi ta̱ kuankíhinnu Jerusalen nga n'e̱tsjoho̱o Nti̱a̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jun najmi yo xi n'etsjoho̱o. Tu̱nga ji̱n yai̱ xi n'etsjoi̱hi̱, a̱t'aha̱ a̱jihi̱n xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ stjújin xi ts'i̱ínk'anki xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","’Tu̱nga jahá tíbichú chu̱ba̱ ko̱ ja kuichu chu̱bo̱ nd'a̱i̱ nk'ie nga kju̱axi̱ n'etsjoho̱ Nti̱a̱ Na̱'miu̱. Xi nkú ts'ín ku̱a̱kúyaha̱ Espiri̱tu̱ Santo̱ xu̱ta̱, b'a̱ ts'ín ts'i̱íntsjoho̱ Nti̱a̱ Na̱'miu̱. A̱t'aha̱ Nti̱a̱ Na̱'miu̱ mjehe̱ nga xu̱ta̱ xi b'i̱ ts'ín tjíntuyáha̱ ts'i̱íntsjoho̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Xi ts'i̱íntsjoho̱, tjíhin nga kju̱axi̱ b'a̱ ts'i̱ín xi nkú ts'ín ku̱a̱kúya Espiri̱tu̱ Santo̱. A̱t'aha̱ Espiri̱tu̱ ní Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","B'a̱ kitsú ta̱chjúu̱n: —Be nga kj'u̱a̱í Mesia̱, chá xi ts'i̱ín nibá Nti̱a̱ná. Nk'ie nga kj'u̱a̱í, ku̱i̱tsu̱yaná nkú tjíhi̱n ra̱ ni xi tjín. ");
INSERT INTO majNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—An ní niu̱, an xi tínchja̱ko̱hi —kitsú Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kui chu̱bo̱ j'ai ngáha já ni'yakuyáha̱ ko̱ kama nkjúhu̱n nga nku ta̱chju̱ún tínchja̱ni̱jmíko̱ Jesu. Tu̱nga ndaha nku najmi kama k'un kingjásjaiyaha̱ mí nihi xi mjehe̱ ko̱ a ra̱ mí nihi xi tínchja̱ni̱jmíyako̱ho ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A̱s'a̱i tsasínjña nisaha̱ ta̱chjúu̱n ko̱ ngji a̱jin na̱nti̱o̱. Ngji tsúyaha̱ xu̱ta̱ ni xi kamat'ain. ");
INSERT INTO majNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","B'i̱ kitsú: —Nibáa̱se̱ ma ru̱u xu̱ta̱ x'i̱n xi kuatsúyana ngatentee̱ ni xi kits'ian. Kutsa kuihí xi kitsú Nti̱a̱ná nga ts'i̱ín nibá. ");
INSERT INTO majNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","A̱s'a̱i tsitju xu̱ta̱ na̱nti̱o̱ nga j'aisehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nk'ie nga ngji ta̱chjúu̱n a̱jin na̱nti̱o̱, já ni'yakuyáha̱ Jesu b'i̱ kitsúhu̱: —Ji nda̱ maestru̱, chi̱ne̱i̱ i̱chí nichinei̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Tíjñana nichine xi najmi yo —kitsú Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kui nga b'i̱ ngján kingjásjaiyaha̱ ra̱ xinkjín já ni'yakuyóo̱ nga b'a̱ kitsú: —Tjín ra̱ xi kj'uaiko̱ho̱ nichine. ");
INSERT INTO majNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A̱s'a̱i b'i̱ kitsú Jesu: —Nk'ie nga ts'ian xi nkú ts'ín mjehe̱ xi kits'ín nibána ko̱ nga ts'intjusan xá xi ts'e̱, kui ní niu̱ xi nichinena̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tíbixíún: “Ndyja sa ñju sá nga ku̱i̱chú cho̱n.” Tu̱nga an b'a̱ tíxinnu̱u: Chjúx'ánkiu tunkun ko̱ cha̱so̱o. Xu̱ta̱ xi nibá ján, kui xi nkú joyaha cha̱n. Ja tíbichú chu̱ba̱ha̱. Ja ka̱ma kj'u̱a̱íya cho̱n. ");
INSERT INTO majNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Xi tíf'áya cha̱n xi nibá yo̱ ka̱ma chjíhi̱. A̱t'aha̱ k'úéntu tík'un sín xu̱to̱. B'a̱ ts'ín nkuhú tsjo ka̱maha̱ ra̱ xi ts'ínxájin ko̱ xi f'áya cho̱n. ");
INSERT INTO majNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","A̱t'aha̱ kju̱axi̱ kjáíhin én xi b'a̱ tsuu̱: “Nku xi b'éntje̱ ko̱ kj'a̱í xi f'áya.” ");
INSERT INTO majNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","An kits'inkjínu̱u nga chj'a̱yo cha̱n xi najmi jun kis'enkinu̱u kju̱a̱ni̱ma̱. Kj'a̱í xi kuak'íéntje̱ nga nibá xu̱ta̱i̱, ko̱ jun ta̱ sakút'anu̱u chjíhi̱ xóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nkjin xu̱ta̱ Samari̱a̱ xi tjíntu a̱nte xu'bo̱ kis'ejihi̱n Jesu nk'ie nga kint'é nga b'i̱ kitsú ta̱chjúu̱n: “Kuatsúyana ngatentee̱ ni xi kits'ian.” ");
INSERT INTO majNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kui kju̱a̱ha nk'ie nga j'aisehe̱ ra̱ xu̱ta̱ Samari̱a̱ Jesu, tsankihi̱ nga k'úéjña yo̱. Y'ejña Jesu jo ni̱stjin tjíhin ");
INSERT INTO majNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ko̱ 'yún nkjin sa xi kis'ejihi̱n én xi kinchja̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A̱s'a̱i b'a̱ i̱ncha kitsúhu̱ ta̱chjúu̱n: —S'ejinni̱ nd'a̱i̱ tu̱nga najmi tu̱ nga̱t'aha̱ ní én xi tsixín. S'ejin níni̱ a̱t'aha̱ ko̱ ji̱n kuanu'yái̱ ko̱ mankjinni̱ nga kju̱axi̱ nga kui xi ts'ínk'anki xu̱ta̱ xi tu̱ má tjíntuhú. ");
INSERT INTO majNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nk'ie nga j'a jo ni̱stjin, a̱s'a̱i tsitju Jesu yo̱ nga ngji a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","A̱t'aha̱ kitsúya Jesu nga najmi yankjún nku nda̱ profeta̱ a̱nte xi ts'e̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nk'ie nga tsichu Galilea̱, xu̱ta̱ xi tjín yo̱ kits'ínkjáíhi̱n, a̱t'aha̱ kikie ngayjee̱ ni xi kits'ín Jesu nanki Jerusalen a̱jihi̱n s'íu̱. A̱t'aha̱ ko̱ kui i̱ncha ngji s'íu̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","A̱s'a̱i tsichu ngáha Jesu Cana, nanki xi tíjñajihi̱n a̱nte Galilea̱ má nga kits'ín ma binu̱ ntánijuo̱. Yo̱ tíjña nku nda̱ xi ts'ínxát'aha̱ nda̱ rei̱, kui xi tíjñaha̱ nku nda̱ chí xi kjijña un nanki Capernaum. ");
INSERT INTO majNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nk'ie nga kint'é nga tsitju Jesu a̱nte Judea̱ ko̱ j'ai a̱nte Galilea̱, a̱s'a̱i j'aisehe̱ ko̱ tsankihi̱ nga ngju̱a̱i̱ ni'yaha̱ tu̱ xi ts'i̱ínnkihi̱ ra̱ nda̱ chíhi̱, a̱t'aha̱ ja tí'me. ");
INSERT INTO majNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","B'i̱ kitsú Jesu: —Tsa najmi cho̱o kju̱a̱nkjún ko̱ ni xi tíbakúchji nga'yúhu̱n Nti̱a̱ná, najmi s'e̱jinnu̱u nga Nti̱a̱ná kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","A̱s'a̱i b'a̱ kitsú nda̱ xi ts'ínxát'aha̱ nda̱ rei̱: —Ji nda̱ nti̱a̱, nibá mai i̱chí kintehe̱ ni nga ku̱a̱yá nda̱ chína̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","B'i̱ kitsú Jesu: —T'in ngáhani ni'yahi̱. Ja nda ngáha nda̱ chíhi̱. Kis'ejihi̱n ndo̱ én xi kitsú Jesu ko̱ ngji. ");
INSERT INTO majNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nk'ie nga tje̱n masen ni̱yóo̱, kisatéjin já musu̱hu̱ ko̱ b'a̱ kitsúhu̱: —Ja nda ngáha ntíhi̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kingjásjaiyaha̱ ndo̱ já musu̱hu̱ mí chu̱ba̱ha kik'atuts'i̱hi̱n nga kis'e nda ngáha̱ ra̱ ntíhi̱. B'a̱ kitsú jóo̱: —Kujña̱ nga chu̱ba̱ nku tsitjujihi̱n ch'iu̱n nda̱ chíu̱. ");
INSERT INTO majNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","J'áítsjehe̱n na̱'mihi̱ nda̱ chíu̱ nga kui chu̱bo̱: “Ja nda ngáha nda̱ chíhi̱”, kitsúhu̱ Jesu. Kui ko̱ ngayjee̱ xu̱ta̱ xi tjín ni'yaha̱ kis'ejihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kui kju̱a̱nkjún xu'bi̱ xi ma joho xi kits'ín Jesu nk'ie nga tsitju a̱nte Judea̱ ko̱ j'ai ngáha a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kj'a̱í ni̱stjin ngáha, nk'ie nga tíi̱ncha b'asje s'íhi̱ xu̱ta̱ judio̱ ngji ngáha Jesu nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yo̱ tíjña nku ntá ti̱xa̱ chánkantsú xi tiña maha̱ a̱nkju̱a̱ha̱ na̱xi̱nantóo̱ xi 'mi A̱nkju̱a̱ Chu̱tsa̱nka̱. Kui ntá ti̱xo̱ xi 'mi Betesda̱ nga én hebreo̱. Un a̱nte nk'íén kis'entuhu̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yo̱ fantu ṉkjún xu̱ta̱ un, xu̱ta̱ ka̱, xi najmi ma fi ko̱ xi nta sjai. Kui xi i̱ncha kuyáha̱ nga ts'ín ni̱yá ntánijuo̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","A̱t'aha̱ tu̱ nkjé tu̱ nkjéhé ni nku ntítsjehe̱ Nti̱a̱ná f'aijénjin ntá ti̱xo̱ ko̱ ts'ín ni̱yánkihi̱ ntánijuo̱. Ko̱ xi tjun tsungijin yjoho̱ ntóo̱ nk'ie nga ja kuan'e ni̱yáha̱, kui xi ma nda tu̱ mí ch'in xi k'uhún ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Yo̱ kjijñajihi̱n xu̱ta̱ uu̱n nku nda̱ xi tjíhi̱n kan tj'ion jan nú nga uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nk'ie nga kikie Jesu nga kjijña ndo̱ yo̱, kamankjihi̱n nga ja nkjin nú tjíhi̱n nga uhu̱n ko̱ b'i̱ kitsúhu̱: —¿A mjehi ka̱ma nda ngáhani? ");
INSERT INTO majNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Ji nda̱ nti̱a̱ —kitsú nda̱ uu̱n—, najmi ch'a tjínna xi ku̱a̱si̱nko̱na, tsa tsúngijinna ntá ti̱xo̱ nk'ie nga n'e ni̱yáha̱. Nk'ie nga mjena tsungijian yjona̱, tu̱ kj'a̱íhí xi tjun tsungijin yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","A̱s'a̱i b'i̱ kitsú Jesu: —Ti̱síntje̱i̱n, chjúbéí nijña xi kisujñasuin ko̱ t'in. ");
INSERT INTO majNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ta̱ kuihi chu̱bo̱ kama nda ngáha ndo̱. Jakj'á nijña xi kjijñasun ko̱ ngji. Tu̱nga xua̱tu̱hú kui ni̱stjiu̱n, ni̱stjin nkjúhu̱n xu̱ta̱ judio̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kui nga b'a̱ kitsúhu̱ ra̱ já judio̱ k'aku̱ nda̱ xi kama ndoo̱: —Xua̱tu̱ nd'a̱i̱. Tíjña nkjúhu̱n kju̱a̱téxumoo̱ nga ch'a̱i̱ nijñahi̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","B'a̱ kitsú ndo̱: —Xi kuats'ínnkina, kui xi b'a̱ kuatsúna: “Chjúbéí nijña xi kisujñasuin ko̱ t'in.” ");
INSERT INTO majNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","B'a̱ kitsú jóo̱ nga kingjásjaiyaha̱: —¿Yá xi b'a̱ kuatsúhi: “Chjúbéí nijña xi kisujñasuin ko̱ t'in”? ");
INSERT INTO majNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tu̱nga najmi behé nda̱ xi kama nkihi̱ yá xi kits'ínnkihi̱, a̱t'aha̱ ngji t'axín Jesu a̱jihi̱n xu̱ta̱ xi tíi̱ncha yo̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A̱skahan Jesu kisatéjin ngáha ndo̱ má ma na̱tsihi̱n ni̱nku̱ ko̱ b'i̱ kitsúhu̱: —Ji, ja kama nda ngáhani. Najmi ta̱ n'eheni ngatitsun tu̱ xi najmi sa̱téhe ri nku ni xi 'yún ch'onk'un sa. ");
INSERT INTO majNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A̱s'a̱i ngji tsúyaha̱ ndo̱ já judio̱ k'aku̱ nga Jesu xi kits'ínnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kui kju̱a̱ha nga kits'ín unkiehe̱ ra̱ Jesu já judio̱ k'aku̱, a̱t'aha̱ b'a̱ kits'ín nga ni̱stjin nkjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","A̱s'a̱i b'i̱ kitsú Jesu: —Na̱'mina̱ títs'ínxá santaha nd'a̱i̱ ko̱ an ta̱ títs'inxá. ");
INSERT INTO majNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kui kju̱a̱ha nga tu̱ sahá 'yún tsangisjai ni̱yáha já judio̱ k'aku̱ nga mjehe̱ ts'i̱ínk'iehen Jesu. A̱t'aha̱ najmi tu̱ suba tsa ni̱stjin nkjúu̱n xi najmi kitsenkjún, tu̱nga b'a̱há kitsú ya nga Nti̱a̱ná xi Na̱'mihi̱. B'a̱ ts'ín ta̱ kuihi kits'ín ma yjoho̱ xi nkúhu Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A̱s'a̱i kinchja̱ Jesu nga b'a̱ kitsúhu̱ jóo̱: —Kju̱axi̱ ni xi tíxinnu̱u. Ndaha nku ni najmi ma ts'ín Ntíhi̱ Nti̱a̱ná kuenta̱ subaha̱. Tu̱ nkuhú ni xi tíbe nga títs'ín Na̱'mihi̱, kui xi ts'ín. A̱t'aha̱ ngatentee̱ ni xi ts'ín Na̱'miu̱, ta̱ kui nihi xi ts'ín Ntíu̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","A̱t'aha̱ Na̱'miu̱ 'yún tjoho̱ Ntíu̱ ko̱ bakúchjihi̱ ngayjee̱ ni xi ts'ín. Ko̱ ku̱a̱kúchji saha̱ ni xi 'yún chánka. Xí ka̱ma nkjúhúnnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","A̱t'aha̱ xi nkú ts'ín Na̱'miu̱ ts'ínkj'áíyaha̱ xu̱ta̱ ngabayoo̱ ko̱ ts'ínk'íéntu tík'un ngáha, b'a̱ ta̱ ts'ín Ntíu̱ ts'ínk'íéntu tík'un xi mjehe̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Najmi Na̱'miu̱ xi ku̱a̱se̱he̱ tsa nda ko̱ tsa najmi nda ni xi kits'ín xu̱ta̱. Ntíu̱ ní kitsjáha̱ nga kui xi ku̱a̱se̱yjehe̱ kui niu̱, ");
INSERT INTO majNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tu̱ xi ngayjee̱ xu̱ta̱ sku̱e̱nkjúhun Ntíu̱ xi nkú ta̱ ts'ín benkjún Na̱'miu̱. Xi najmi benkjún Ntíu̱, b'a̱ ta̱ ts'ín najmi benkjún Na̱'mi xi kits'ín nibáha̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Kju̱axi̱ ni xi tíxinnu̱u. Xi basínñjuhu̱ énna̱ ko̱ s'ejihi̱n xi kits'ín nibána, kui xi ja tjíntu tík'un sín. Najmi tjín ni xi ngju̱a̱i̱néhe̱ a̱t'aha̱ ja tsitjujin ngabayoo̱ ko̱ tjíntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kju̱axi̱ ni xi tíxinnu̱u. Ku̱i̱chú chu̱ba̱ ko̱ ja kuichu chu̱bo̱ nd'a̱i̱ nk'ie nga xu̱ta̱ k'ie̱n ku̱i̱nt'é nta̱ha̱ Ntíhi̱ Nti̱a̱ná, ko̱ xi tínt'é'éhe̱n k'úéntu tík'un. ");
INSERT INTO majNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","A̱t'aha̱ xi nkú ts'ín Nti̱a̱ Na̱'miu̱ kuenta̱ha̱ tíjña tík'uhun, b'a̱ ta̱ ts'ín kitsjáha̱ Ntíu̱ nga kuenta̱ha̱ tíjña tík'uhun. ");
INSERT INTO majNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na̱'miu̱ kitsjáha̱ Ntíu̱ tu̱ xi ku̱a̱se̱he̱ ra̱ tsa nda ko̱ tsa najmi nda ni xi kits'ín xu̱ta̱, a̱t'aha̱ kui xi Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","’Najmi tu̱ ma nkjúnnu̱u niu̱. A̱t'aha̱ ku̱i̱chú chu̱ba̱ nk'ie nga ku̱i̱nt'é nta̱ha̱ Ntíu̱ ngayjee̱ xu̱ta̱ xi kjintuyánji ");
INSERT INTO majNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ko̱ ku̱i̱síntje̱n ngáha. Xi nda kits'ín ku̱i̱síntje̱n nga k'úéntu tík'un. Xi najmi nda kits'ín ku̱i̱síntje̱n nga s'e̱néhe̱ ni xi kanéhe̱ nga̱t'aha̱ ni xi i̱ncha kits'ín. ");
INSERT INTO majNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ndaha nku ni najmi ma ts'ian kuenta̱na̱. Xi nkú ts'ín nt'e, b'a̱ ts'ín ts'ian kju̱a̱. Ko̱ kixi̱ ts'ian kju̱a̱, a̱t'aha̱ najmi bangisjai su̱ba̱ ni xi mjena. Ni xi mje níhi̱ Na̱'mi xi kits'ín nibána bangisja. ");
INSERT INTO majNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","’Tsa ta̱ ahan xínya yáha an, najmi chjíhi̱ ra̱ én xi kuinchja. ");
INSERT INTO majNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tu̱nga tíjñahá kj'a̱í xi tífina kju̱a̱nda, ko̱ be nga chjíhi̱ ra̱ ni xi ts'ín nga b'éjña chji yáha an. ");
INSERT INTO majNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jun kin'ekjíú já xi ngjingjásjaiyaha̱ Jua nga yáha kui ko̱ kui xi kitsúya yáha an. ");
INSERT INTO majNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","An najmi machjénna tsa xu̱ta̱ yjoninte ngju̱a̱i̱na kju̱a̱nda, tu̱nga tíxihínnu̱u nga n'e̱chjíhi̱ ru̱u Jua tu̱ xi k'u̱a̱nkihinu. ");
INSERT INTO majNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jua b'a̱ joyaha nku nd'í xi tsat'ai ko̱ kits'ín ndzjen, ko̱ jun kin'e tsjojiun kutju nd'íhi̱. ");
INSERT INTO majNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","’Tu̱nga 'yún chánka sa ni xi tífina kju̱a̱nda nga én xi kinchja̱ Jua. A̱t'aha̱ xá xi kitsjána Nti̱a̱ Na̱'miu̱ nga ts'intjusan ko̱ xi títs'ian nd'a̱i̱, kui xi ta̱ tífina kju̱a̱nda. Tíbakúchji nga Nti̱a̱ Na̱'miu̱ kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ko̱ Na̱'miu̱ ya xi kits'ín nibána ta̱ tífina kju̱a̱nda. Jun najmi kje̱e nu'yó nta̱ha̱ ko̱ ta̱ ndaha najmi kje̱e yo xi nkú tjín. ");
INSERT INTO majNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ta̱ ndaha najmi tíjñajinnu̱u éhe̱n a̱jin ani̱ma̱nu̱u, a̱t'aha̱ najmi s'ejinnu̱u xi kits'ín nibá. ");
INSERT INTO majNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","'Yún ṉkjún n'eyo xu̱ju̱n éhe̱n Nti̱a̱ná a̱t'aha̱ b'a̱ manu̱u nga b'a̱ ts'ín sa̱kúhu̱nu̱u nga ku̱i̱ntsu̱ba̱ tík'un síún. Tu̱nga an ní tínchja̱ni̱jmíyahana xu̱ju̱n nga tífina kju̱a̱nda. ");
INSERT INTO majNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tu̱nga najmi mjehénu̱u ni̱basenú tu̱ xi ku̱i̱ntsu̱ba̱ tík'uhunnu. ");
INSERT INTO majNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Najmi tíbangisja tsa xu̱ta̱ tsjána kju̱a̱chánka. ");
INSERT INTO majNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tu̱nga behénu̱u. Be nga najmi n'etjó Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngajoho̱ Na̱'mina̱ jái̱hina ko̱ jun najmi n'ekjáínnú. Tu̱nga tsa kj'a̱í xi ku̱a̱té xá subaha̱ yjoho̱, tu̱ sahá kui xi n'ekjóho̱on. ");
INSERT INTO majNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","B'i̱ ngján 'bo̱ho̱ kju̱a̱chánka yjonu̱u. Najmi binchisjó nga Nti̱a̱ná xi nku tutuu̱ tsjánu̱u kju̱a̱chánka. Nk'ie nga b'a̱ n'o, ¿nkú ts'ín s'e̱jihi̱nnu̱u énna̱? ");
INSERT INTO majNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","’Najmi tu̱ b'a̱ bixíún tsa an xínyat'ainnu̱u nginku̱n Nti̱a̱ Na̱'miu̱. Moise ní xi tíma 'yún tak'un, kui ní xi títsuyat'ainnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tsa kju̱axi̱ nga s'ejinnu̱u ni xi y'ét'a Moise, ta̱ s'e̱jinnu̱u an, a̱t'aha̱ an kinchja̱ni̱jmíyahana Moise. ");
INSERT INTO majNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tu̱nga tsa najmi s'ejinnu̱u ni xi y'ét'a Moise, ¿nkú ts'ín s'e̱jihi̱nnu̱u én xi tínchja? ");
INSERT INTO majNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kj'a̱í ni̱stjin ngáha ngji Jesu ngabantá ntáchak'un Galilea̱, xi ta̱ 'mi ntáchak'un Tiberi̱a̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nkjin ṉkjún xu̱ta̱ kitsjennkíhi̱, a̱t'aha̱ kikie kju̱a̱nkjún xi kits'ín nga kits'ínnkihi̱ xu̱ta̱ un. ");
INSERT INTO majNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","A̱s'a̱i tsiyajnu Jesu nku a̱sunntu tje̱nki̱ ko̱ yo̱ y'ejñako̱ já ni'yakuyáha̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kui ni̱stjiu̱n ja tíbichú tiña S'í Pascu̱a̱ xi b'asje xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nk'ie nga tsase Jesu ko̱ kikie nga nkjin ṉkjún xu̱ta̱ xi tíi̱ncha nibák'uhu̱n, b'a̱ kitsúhu̱ Felipe̱: —¿Má xi tje̱hen ch'a̱tseé ni̱nku̱a̱n xi kji̱ne̱ xu̱ta̱ nkiu̱n? ");
INSERT INTO majNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tu̱nga tu̱ xi kikjut'ayák'uhún ni Felipe̱ nga b'a̱ kitsúhu̱, a̱t'aha̱ be ni xi ts'i̱ín. ");
INSERT INTO majNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A̱s'a̱i b'a̱ kitsú Felipe̱: —Ta̱ ndaha tsa jo unchan to̱on denari̱o̱ ni̱nku̱a̱n ch'a̱tseé, tsa a̱s'a̱i i̱chí i̱chí k'u̱a̱i̱hi̱ nga nkúnkú, najmi ku̱i̱chú maha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A̱s'a̱i b'i̱ kitsú nda̱ ni'yakuyá xi 'mi Andre, xi nts'e̱ maha Simon Pedro̱: ");
INSERT INTO majNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—E̱i̱ síjña nku nda̱ chí xi y'a un ni̱nku̱a̱n xi kamandako̱ho tu cebada̱ ko̱ jo tji̱o̱. Tu̱nga, ¿mí skan ka̱maha̱ ra̱ xu̱ta̱ nkjiu̱n niu̱? ");
INSERT INTO majNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","B'i̱ kitsú Jesu: —B'a̱ t'ihu̱un nga kat'entu ngayjee̱ xu̱ta̱. Tjín ṉkjún na̱xi̱ chu̱ kui a̱nte xu'bo̱ ko̱ y'entu a̱jin na̱xi̱ chu̱ nkú ra̱ ma un mii̱ jáx'i̱n. ");
INSERT INTO majNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","A̱s'a̱i jakj'á Jesu ni̱nku̱o̱n, kitsjáha̱ máb'a̱chjíhi̱ Nti̱a̱ná ko̱ kits'ínndzjoho̱ xu̱ta̱ xi kab'entu yo̱. B'a̱ ta̱ kits'íhi̱n tji̱o̱ nga kitsjáha̱ xi nkú tjín mjehe̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nk'ie nga kik'ie sisihi̱n xu̱ta̱, a̱s'a̱i b'i̱ kitsúhu̱ já ni'yakuyáha̱: —Chj'a̱yo ni̱nku̱a̱n xi k'uankiu̱ tu̱ xi najmi ku̱a̱tsúhun. ");
INSERT INTO majNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","A̱s'a̱i j'áya jóo̱ ni̱nku̱a̱n xi ts'ankiu̱, kui xi nibaha̱ ra̱ ni̱nku̱a̱n cebada̱ xi uu̱n. Te jo ni̱si̱n kama ni̱nku̱a̱n xi ts'ankihi̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nk'ie nga kikie xu̱ta̱ nkjiu̱n kju̱a̱nkjún xi kits'ín Jesu, a̱s'a̱i b'a̱ i̱ncha kitsúhu̱ xinkjín: —Kju̱axi̱ kjáíhin nga kui nda̱i̱ xi nda̱ profeta̱ xi tjíhin nga kj'u̱a̱í a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tu̱nga kamankjihín ra̱ Jesu nga mjehe̱ jóo̱ ngju̱a̱i̱ko̱ kju̱a̱'yúhu̱n nga nda̱ rei̱ ts'i̱ín maha̱. Kui nga ngji t'axín suba ngáha a̱suntu tje̱nki̱u̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nk'ie nga ja tíma jyun, a̱s'a̱i i̱ncha j'aijen a̱ndai ntáchak'uu̱n já ni'yakuyáha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jas'en yábarku̱ tu̱ xi kj'u̱a̱tikjáha ntáchak'uu̱n nga ngju̱a̱i̱ nanki Capernaum. A̱s'a̱i tu̱ kama jyunt'aihín nk'ie nga najmi kje̱e bichú tje̱nnkihi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ko̱ tu̱ nkuhú ntjo̱ xi tu̱ xí 'yúhún kama. Xí kits'ín xuhú ntáchak'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nk'ie nga tsichu nkú ma tsa un ko̱ tsa jun kilome̱tru̱ tjíhin, kikie jóo̱ nga Jesu nibásun ntáchak'uu̱n nga nibák'un tiñaha̱ yábarku̱. I̱ncha kitsankjún jóo̱, ");
INSERT INTO majNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","tu̱nga b'i̱hí kitsú Jesu: —An ní niu̱. Najmi tu̱ binkjun. ");
INSERT INTO majNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tsjo kamaha̱ jóo̱ nga jas'en Jesu yábarku̱ ko̱ tu̱ tsichu sahá yábarku̱ nanki xi má nga tíi̱ncha fi. ");
INSERT INTO majNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ni̱stjin xi ma ndyjuu̱n kamankjihi̱n xu̱ta̱ xi y'entu ngabantá ntáchak'uu̱n nga tu̱ nkuhú maha yábarku̱ xi tsitju yo̱ ko̱ nga Jesu najmi jas'en nga ngjiko̱ já ni'yakuyáha̱, a̱t'aha̱ tu̱ já ni'yakuyáha̱ ngji subahá. ");
INSERT INTO majNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","A̱s'a̱i i̱ncha j'ai kj'a̱í yábarku̱ xi tsitjuhu nanki Tiberi̱a̱ nga j'ai tiña má xi tje̱hen kikjine ni̱nku̱a̱n xu̱ta̱ nk'ie nga kitsjáha̱ Jesu máb'a̱chjíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kui b'a̱ maha, nk'ie nga kikiehe xu̱ta̱ nga najmi ta̱ tjíhin Jesu yo̱ ko̱ ta̱ ndaha já ni'yakuyáha̱, a̱s'a̱i jas'en yábarku̱ nga ngjingisjai nanki Capernaum. ");
INSERT INTO majNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ngabantá xinkuu̱ kisakúhu̱ ko̱ b'i̱ i̱ncha kitsúhu̱: —Ji nda̱ maestru̱, ¿nkú n'e jái̱hini e̱i̱? ");
INSERT INTO majNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A̱s'a̱i b'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Kiyo kju̱a̱nkjún xi kits'ian, tu̱nga najmi kuihí kju̱a̱ha tíbinchisjáíhinú. Tu̱ nga̱t'aha̱ ní ni̱nku̱a̱n xi kichinehenu nga kitse susunnu̱u, kui kju̱a̱ha nga tíbinchisjáíhinú. ");
INSERT INTO majNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Najmi tu̱ n'exántjaihinu ni̱nku̱a̱n xi maha̱ fe. Ni̱nku̱a̱n xi najmi ma níhi̱ fe n'e̱xántjaihinu. Kui xi ts'i̱ínk'íéntu tík'unnu̱u. Ntíhi̱ Nda̱x'i̱u̱n tsjánu̱u ni̱nku̱a̱n xu'bo̱. Nti̱a̱ Na̱'miu̱ tsakúnu̱u nga kui xi kits'ín nibá. ");
INSERT INTO majNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","B'a̱ kitsú jóo̱: —¿Mí ni xi tjíhin nga n'e̱i̱ ji̱n tu̱ xi n'e̱tjusuhu̱nni̱ ni xi mjehe̱ ra̱ Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","B'i̱ kitsú Jesu: —Kui ni xu'bi̱ xi mjehe̱ Nti̱a̱ná nga n'e̱tjusun. Kas'ejinnu̱u nda̱ xi kits'ín nibá. ");
INSERT INTO majNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","A̱s'a̱i b'a̱ i̱ncha kitsú jóo̱: —¿Mí kju̱a̱nkjúhun xi ku̱a̱kúchjini̱ nga Nti̱a̱ná kits'ín nibáhi tu̱ xi cha̱ha̱ni̱ ko̱ s'e̱jinni̱ ji? ¿Mí xáha̱ Nti̱a̱ná xi mahi? ");
INSERT INTO majNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","A̱t'aha̱ ntje̱ cháná kikjine mana nk'ie nga y'entu a̱nte kixiu̱. Kui nihi xi tjít'a éhe̱n Nti̱a̱ná nga b'a̱ títsu: “Ni̱nku̱a̱n xi ndji̱o̱jmi ján nibaha̱ ra̱ kitsjáha̱ nga kikjine.” ");
INSERT INTO majNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","B'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Na̱'mina̱há xi kitsjánu̱u ni̱nku̱a̱n xi ndji̱o̱jmi ján nibaha, najmi Moise. Ko̱ nd'a̱i̱ títsjánu̱u ni̱nku̱a̱n xi nda kjikjin. Kui xi ndji̱o̱jmi ján nibáha. ");
INSERT INTO majNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","A̱t'aha̱ ni̱nku̱a̱n xi tsjá Nti̱a̱ná, kui xi nibajehen ndji̱o̱jmi ján ko̱ ts'ínk'íéntu tík'un xu̱ta̱ a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Ji nda̱ nti̱a̱ —kitsú jóo̱—, k'u̱a̱i̱ tehe̱nteni̱ ni̱nku̱a̱n xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A̱s'a̱i b'i̱ kitsú Jesu: —An ni̱nku̱a̱n xi ts'ínk'íéntu tík'uhu̱n xu̱ta̱. Xi kj'u̱a̱ísena najmi ta̱ ka̱ma bjoho̱ ra̱ ko̱ xi s'e̱jihi̱n an najmi ta̱ ka̱ma xintáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tu̱nga jahá b'a̱ kuaxinnu̱u, ndaha tsa tíyanú tu̱nga najmi tís'ejihínnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kj'u̱a̱ísena ngayjee̱ xu̱ta̱ xi tsjána Na̱'mina̱, ko̱ xi kj'u̱a̱ísena najmi k'onsje̱ na̱tsin ján. ");
INSERT INTO majNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","’A̱t'aha̱ ndji̱o̱jmi ján nibaje̱henna tu̱ xi ts'intjusuhunna xi nkú ts'ín mjehe̱ Na̱'mi xi kits'ín nibána ko̱ najmi xi nkú ts'ín mjena. ");
INSERT INTO majNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ko̱ ni xi mjehe̱ xi kits'ín nibána, najmi mjehe̱ tsa ts'inndyja ndaha nku xi kitsjána. Mje níhi̱ nga ts'inkj'áíya ngáha̱ ra̱ ngabayoo̱ xu̱ta̱ xu'bo̱ ni̱stjin xi fekuu̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","A̱t'aha̱ ni xi mjehe̱ Na̱'mina̱, mjehe̱ nga k'úéntu tík'un sín ngayjee̱ xi kj'u̱a̱ísehe̱ Ntíu̱ ko̱ s'e̱jihi̱n. Ko̱ an ts'inkj'áíya ngáha̱ ra̱ ngabayoo̱ xu̱ta̱ xu'bo̱ ni̱stjin xi fekuu̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nk'ie nga b'a̱ kitsú Jesu nga kui xi ni̱nku̱a̱n xi ndji̱o̱jmi ján nibajehen, a̱s'a̱i já judio̱ kinchja̱yanehe̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","B'a̱ i̱ncha kitsúhu̱ xinkjín: —¿A najmi kuihí nda̱i̱ xi Jesu, ntíhi̱ Kuse? Yaá na̱'mihi̱ ko̱ na̱aha̱. ¿Nkú tjíhi̱n ra̱ nga b'a̱ títsuhu nga ndji̱o̱jmi ján nibajehen? ");
INSERT INTO majNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi tu̱ chubayanenú. ");
INSERT INTO majNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ndaha nku najmi ka̱ma kj'u̱a̱ísena tsa najmi kj'u̱a̱íko̱ho̱ Na̱'mi xi kits'ín nibána. Ko̱ xi kj'u̱a̱ísena an ts'inkj'áíya ngáha̱ ra̱ ngabayoo̱ ni̱stjin xi fekuu̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","B'a̱ ts'ín y'ét'a já profeta̱: “Nti̱a̱ná ku̱a̱kúyaha̱ ngayjee̱ xu̱ta̱.” Kui b'a̱ maha, ngayjee̱ xi mjéñjuhu̱ ra̱ ko̱ bangiya ni xi bakúyaha̱ Nti̱a̱ Na̱'miu̱, kui xi kj'u̱a̱ísena. ");
INSERT INTO majNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ndaha nku najmi kje̱e be yáha Nti̱a̱ Na̱'miu̱. Nku tutuhú xi nibaha má tíjña Nti̱a̱ná, kui xi ja be Nti̱a̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kju̱axi̱ ni xi tíxinnu̱u. Xi s'e̱jihi̱n an, kui xi k'úéntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","An ni̱nku̱a̱n xi ts'ínk'íéntu tík'uhu̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ntje̱ chánu̱u kikjine mana a̱nte kixiu̱, tu̱nga tu̱ nkú jesuhún. ");
INSERT INTO majNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tu̱nga ni̱nku̱a̱n xu'bi̱ ndji̱o̱jmi ján nibajehen tu̱ xi kji̱ne̱he xu̱ta̱ ko̱ najmi ta̱ ku̱a̱yáha. ");
INSERT INTO majNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","An xi ni̱nku̱a̱n tík'un xi ndji̱o̱jmi ján nibajehen. Tsa tjín xi kji̱ne̱ ni̱nku̱a̱n xu'bi̱, kui xi k'úéjña tík'un sín. Ko̱ ni̱nku̱a̱n xi tsja, kui xi yjonintena̱ xi tsjantjáíhina xu̱ta̱ a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A̱s'a̱i tu̱ y'ésiko̱hó xinkjín já judio̱ nga b'a̱ kitsú: —¿Nkú ts'ín tsjáhaná yjonintehe̱ nda̱i̱ nga chi̱ne̱é? ");
INSERT INTO majNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","B'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Tsa najmi chi̱no̱o yjonintehe̱ Ntíhi̱ Nda̱x'i̱u̱n ko̱ s'i̱u jníhi̱, najmi ku̱i̱ntsu̱ba̱ tík'un. ");
INSERT INTO majNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Xi kji̱ne̱ yjonintena̱ ko̱ k'úí jnína̱, kui xi k'úéntu tík'un sín, ko̱ an ts'inkj'áíya ngáha̱ ra̱ xu̱ta̱ xu'bo̱ ni̱stjin xi fekuu̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","A̱t'aha̱ yjonintena̱ xi nichine xi ndoo̱ ko̱ jnína̱ xi ntá xi ndoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xi kji̱ne̱ yjonintena̱ ko̱ k'úí jnína̱, kui xi k'úéntujínna ko̱ an kúáte̱jñajihi̱n. ");
INSERT INTO majNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","’Na̱'miu̱ kits'ín nibána. A̱t'aha̱ tíjña, kui nga tíi̱jñahana. B'a̱ ta̱ ts'ín a̱t'aha̱ tíi̱jña tík'an, kui nga k'úéntu tík'uhun xu̱ta̱ xi ts'i̱ín mana nichinehe̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kui xu'bi̱ ni̱nku̱a̱n xi ndji̱o̱jmi ján nibajehen. Kui xi najmi xi nkú joyaha mana xi kikjine ntje̱ chánu̱u ko̱ tu̱ nkú jesuhún. A̱t'aha̱ xi kji̱ne̱ ni̱nku̱a̱n xu'bi̱, k'úéntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","B'a̱ ts'ín kinchja̱ Jesu nga tsakúya a̱yaha̱ nku ni'ya sinagoga̱ xi tíjña nanki Capernaum. ");
INSERT INTO majNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nk'ie nga kint'é xu̱ta̱ ni'yakuyáha̱ én xi kinchja̱, a̱s'a̱i nkjin xi b'a̱ kitsú: —'Ni tjín tsa n'e̱sihi̱n én xi tínchja̱. ¿Yá xi ts'i̱ínkjáíhi̱n ni xi kuatsú? ");
INSERT INTO majNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kamankjihi̱n Jesu nga kinchja̱yanehe̱ xu̱ta̱ ni'yakuyáha̱ nga b'a̱ kitsú. A̱s'a̱i b'i̱ kitsú Jesu: —¿A tín'endyjajihín ru̱u yjonu̱u én xi kuanchja? ");
INSERT INTO majNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Nkú sa ka̱manu̱u tsa cho̱o Ntíhi̱ Nda̱x'i̱u̱n nk'ie nga ngju̱a̱i̱nji ngáha a̱nte má nga nibaha? ");
INSERT INTO majNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espiri̱tu̱ Santo̱ ts'ínk'íéntu tík'un xu̱ta̱. Xu̱ta̱ bi, najmi maha̱ ts'ínk'íéntu tík'un xu̱ta̱ xinkjín. Én xi kuaxinnu̱u Espiri̱tu̱ Santo̱ nibáha̱ ra̱ ko̱ kui ée̱n ts'i̱ínk'íéntu tík'unnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tu̱nga tjín a̱jinnu̱u xi najmi s'ejihi̱n an. B'a̱ kitsú Jesu a̱t'aha̱ be santaha nga tuts'ihi̱n ni yá xi najmi s'ejihi̱n ko̱ yá xi ts'i̱ínkjas'ehe̱n. ");
INSERT INTO majNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ko̱ b'i̱ ta̱ kitsú ya: —Kui kju̱a̱ha nga b'a̱ kuaxihi̱nnu̱u nga ndaha nku najmi ka̱ma kj'u̱a̱ísehena tsa najmi Nti̱a̱ Na̱'miu̱ kitsjáha̱ nga kj'u̱a̱ísena. ");
INSERT INTO majNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yo̱ kik'atuts'i̱hi̱n ra̱ nga nkjin xu̱ta̱ ni'yakuyáha̱ y'éjñaha̱. Najmi ta̱ kitsjenko̱ho̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","A̱s'a̱i b'i̱ kitsúhu̱ já ni'yakuyá xi te joo̱: —¿A mjenu̱u kuankíún ko̱ jun? ");
INSERT INTO majNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","—Ji Nda̱ Nti̱a̱ —kitsú Simon Pedro̱—, ¿yá sa ka̱ma tsjénnkihi̱ ji̱n? Jihí xi chubai én xi ts'ínk'íéntu tík'un síhi̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","S'ejinni̱ ko̱ ja kamankjinni̱ nga ji Cristo̱, xi Ntíhi̱ Nti̱a̱ná xi tíjña tík'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","B'i̱ kitsú Jesu: —An j'ajínnu̱u jun xi te joo̱, tu̱nga tje̱njihínnu̱u nku nda̱ninda. ");
INSERT INTO majNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","B'a̱ kitsú Jesu nga kinchja̱ni̱jmíyaha Juda̱ Iscariote̱, ntíhi̱ Simon. A̱t'aha̱ kui xi ts'i̱ínkjas'ehe̱n ko̱ kui xi nku nda̱ ni'yakuyá xi te joo̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","A̱skahan kikjatsú'ba Jesu a̱nte Galilea̱. Najmi kama mjehe̱ nga kikjatsú'ba chji a̱nte Judea̱, a̱t'aha̱ já judio̱ k'aku̱ tsangisjai ni̱yá xi nkú ts'ín ts'i̱ínk'iehen. ");
INSERT INTO majNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tu̱nga jahá tíbichú tiña s'í xi b'asje xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱, s'í xi 'mi S'íhi̱ Ni'ya Kichoo̱, ");
INSERT INTO majNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ko̱ b'a̱ kitsú já nts'e̱ Jesu: —Najmi tu̱ e̱i̱ binchin. Tu̱ sahá t'in Judea̱ tu̱ xi sku̱e̱he xu̱ta̱ ni'yakuyáhi̱ ni xi n'ei. ");
INSERT INTO majNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","A̱t'aha̱ najmi tjín xi b'éjña 'ma ni xi ts'ín tsa mjehe̱ cha̱. Tu̱ sahá ta̱kúchjihi̱ yjohi̱ xu̱ta̱ a̱sunntei̱ nga n'e̱i ni xi tín'ei. ");
INSERT INTO majNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","B'a̱ kitsú já nts'e̱ a̱t'aha̱ ta̱ ndaha kui najmi i̱ncha kis'ejihi̱n yáha Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi kje̱e bichú chu̱ba̱na̱ nga ts'ian ni xi tjíhin nga ts'ian. Jun bi, tu̱ mí chu̱ba̱há ni ma n'o ni xi tjíhin nga n'o̱o. ");
INSERT INTO majNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Najmi títs'ín unkienu̱u xu̱ta̱ a̱sunntei̱. An bi, títs'ín unkiena a̱t'aha̱ tíb'ejñá chja nga ch'on tjín ni xi tíi̱ncha ts'ín. ");
INSERT INTO majNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tankíún s'íu̱. Najmi kfíán an a̱t'aha̱ najmi kje̱e bichú chu̱ba̱na̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","B'a̱ kitsú Jesu, a̱s'a̱i y'ejña a̱nte Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tu̱nga nk'iehé nga i̱ncha ngji s'íu̱ já nts'e̱, a̱s'a̱i ngji ko̱ kui. Tu̱nga najmi ngji chjihí, tsa jóo̱ tje̱njihi̱n. Ngji suba. ");
INSERT INTO majNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A̱s'a̱i a̱jin s'íu̱ já judio̱ k'aku̱ tsangisjaihi̱. B'a̱ i̱ncha kitsúhu̱ xinkjín: —¿A najmi kj'u̱a̱íhí ndo̱? ");
INSERT INTO majNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ko̱ xu̱ta̱ nkjiu̱n ta̱ kinchja̱ni̱jmíyaha Jesu. Tjín xi b'a̱ kitsú: “Ndahá ndo̱.” K'u̱a̱ ngá xi b'a̱ kitsú: “Najmi nda ndo̱. Xu̱ta̱há b'ana̱cha̱ha̱ ndo̱.” ");
INSERT INTO majNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tu̱nga najmi kama tak'uhún xu̱ta̱ kinchja̱ni̱jmíya chji chjihi Jesu a̱t'aha̱ tsankjún já judio̱ k'aku̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nk'ie nga a̱jihi̱n s'íu̱, jas'en Jesu má ma na̱tsihi̱n ni̱nku̱ ko̱ tsakúya. ");
INSERT INTO majNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kama nkjúhu̱n já judio̱ k'aku̱ ko̱ b'a̱ kitsúhu̱ xinkjín: —¿Nkú ts'ín behe ni xi ts'e̱ Nti̱a̱ná nda̱i̱ nga najmi tsangiyaha? ");
INSERT INTO majNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi an ts'a̱n ni xi tíbakuyá. Xi kits'ín nibá nína ts'e̱ ée̱n. ");
INSERT INTO majNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Xi mjehe̱ ts'i̱ín xi nkú ts'ín mjehe̱ Nti̱a̱ná, kui xi sku̱e̱ tsa Nti̱a̱ná ts'e̱ ni xi tíbakuyá ko̱ tsa an ts'a̱n. ");
INSERT INTO majNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nku xu̱ta̱ xi nchja̱ ni xi ts'e̱, kui xi bankisjai kju̱a̱chánka xi ts'e̱. Tu̱nga xi bankisjai kju̱a̱chánkaha̱ xi kits'ín nibáha̱, kui xi kju̱axi̱ ni xi tsu ko̱ na̱xu̱ ts'ín. ");
INSERT INTO majNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿A najmi kitsjáhánu̱u Moise kju̱a̱téxumoo̱? Tu̱nga ndaha nku jun najmi títs'íntjusun kju̱a̱téxumoo̱. ¿Á mjehe̱nu̱u n'e̱k'iehennú? ");
INSERT INTO majNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A̱s'a̱i b'a̱ i̱ncha kitsú xu̱to̱: —¡Kutsa nda̱nindahá tíjñajihin! ¿Yá xi mjehe̱ ts'i̱ínk'iehin? ");
INSERT INTO majNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","B'i̱ kitsú Jesu: —Nku ni kits'ian ko̱ ngatentoo̱ kama nkjúnnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tsakúyanu̱u Moise nga n'e̱tjusun circuncision, ndaha tsa najmi Moise kik'atuts'i̱hi̱n ra̱ niu̱. Ntje̱ chánu̱u ní kik'atuts'i̱hi̱n ra̱ niu̱. Kui nga n'etjusuhun niu̱ ndaha tsa ni̱stjin nkjún. ");
INSERT INTO majNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","B'a̱ n'oho̱o ntíx'i̱nnu̱u ndaha tsa ni̱stjin nkjún tu̱ xi najmi ndyja̱ha kju̱a̱téxumaha̱ Moise. Tu̱nga tsa b'a̱ n'o nga ni̱stjin nkjúu̱n, ¿á tín'ekjanko̱honú nga ni̱stjin nkjún kits'innkíhi̱ ra̱ nku nda̱? ");
INSERT INTO majNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Najmi tu̱ kju̱a̱ sunnk'a n'o. Kixi̱ ní n'o̱o kju̱a̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","A̱s'a̱i b'a̱ kitsú k'u̱a̱ xu̱ta̱ nanki Jerusalen: —¿A najmi kuihí nda̱i̱ xi mjehe̱ ts'i̱ínk'iehe̱n jóo̱? ");
INSERT INTO majNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tu̱nga, á tínchja̱ chji chjihi ko̱ najmi ch'a nkú títsuhu̱ ra̱. ¿A kju̱axi̱hí nga ja kamankjihi̱n já tjíxóo̱ nga kui nda̱i̱ xi kitsú Nti̱a̱ná nga ts'i̱ín nibá? ");
INSERT INTO majNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tu̱nga yanáá má nibáha nda̱i̱. Nk'ie nga kj'u̱a̱í xi Cristo̱, najmi ch'a sku̱e̱ má ni̱baha. ");
INSERT INTO majNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","A̱s'a̱i 'yún kinchja̱ Jesu nga b'i̱ ts'ín tsakúya má ma na̱tsihi̱n ni̱nku̱: —B'a̱ tíbixíún nga yanú ko̱ yo má nibáhana. Tu̱nga najmi kuenta̱na̱há jái̱hina. Tjín xi kits'ín nibána. Ko̱ xi kits'ín nibána ma n'e s'ejián ni xi tsu. Kui xi najmi yo. ");
INSERT INTO majNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tu̱nga an be yáha, a̱t'aha̱ má tíjña nibahana ko̱ kui xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","A̱s'a̱i kama mjehe̱ jóo̱ nga ku̱a̱kj'ánijéhe̱. Tu̱nga ndahá nku najmi kits'ínko̱ho̱, a̱t'aha̱ najmi kje̱e bichú chu̱ba̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tu̱nga nkjin xu̱ta̱ xi tíi̱nchajihi̱n xu̱ta̱ nkjiu̱n kis'ejihi̱n Jesu. B'a̱ kitsúhu̱ xinkjín: —Nk'ie nga kj'u̱a̱í xi Cristo̱, ¿a 'yún ts'i̱ín sa kju̱a̱nkjún nga nda̱ xu'bi̱? ");
INSERT INTO majNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kint'é já fariseo̱ ni xi kitsú xu̱to̱ nga kinchja̱ni̱jmíyaha Jesu. A̱s'a̱i já na̱'mi k'aku̱ ko̱ já fariseo̱ kits'ínkji já xi kunntá ni̱nku̱ tu̱ xi ku̱a̱kj'ánijéhe Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","A̱s'a̱i b'i̱ kitsú Jesu: —Tu̱ chuba ni̱stjihín kúáte̱jñajin sanu̱u ko̱ kfín ngáhana má tíjña xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ku̱i̱nchísjainú tu̱nga najmi ta̱ sa̱kúhu̱nu̱u an. Má nga kfínte̱jña najmi ka̱ma kuankíún. ");
INSERT INTO majNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","B'a̱ kitsúhu̱ xinkjín já judio̱ k'aku̱: —¿Má ngju̱a̱i̱hi̱ nda̱i̱ nga najmi ta̱ sa̱kúhuná? ¿A xu̱ta̱ judio̱ xinki̱á xi tjíntujíhi̱n xu̱ta̱ xi nchja̱ griego̱ ngju̱a̱i̱sehe̱? ¿A ta̱ ku̱a̱kúyaha̱ xi nchja̱ én griego̱? ");
INSERT INTO majNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ni xi kuanchja̱: “Ku̱i̱nchísjainú tu̱nga najmi ta̱ sa̱kúhu̱nu̱u an”, ko̱: “Má nga kfínte̱jña najmi ka̱ma kuankíún”, ¿nkú tsuhu̱ ra̱ ni xi kuatsú? ");
INSERT INTO majNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ni̱stjin xi fekuhu̱ s'íu̱, kui xi 'yún b'asje xu̱ta̱, a̱s'a̱i tsasinjña ndju Jesu ko̱ 'yún kinchja̱: —Tsa tjín xi tíma xintáha̱, kanibásena ko̱ kat'i. ");
INSERT INTO majNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","B'a̱ ka̱maha̱ xi nkú ts'ín tjít'a éhe̱n Nti̱a̱ná. Xi s'e̱jihi̱n an ani̱ma̱ha̱ stjújin ntáje̱, ntá xi ts'ínk'íéntu tík'uhu̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","B'a̱ kitsú Jesu nga kinchja̱ni̱jmíyaha Espiri̱tu̱ xi a̱skahan ts'i̱ínkjáíhi̱n xu̱ta̱ xi s'e̱jihi̱n Jesu. Najmi kje̱e f'ai Espiri̱tu̱ Santo̱ kui ni̱stjiu̱n, a̱t'aha̱ najmi kje̱e s'e̱jña chji kju̱a̱chánkaha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nk'ie nga kint'é xu̱to̱ éi̱n, k'u̱a̱ xi b'a̱ kitsú: —Kju̱axi̱ kjáíhin nga kui nda̱i̱ nda̱ profeta̱ xi tjíhin nga kj'u̱a̱í. ");
INSERT INTO majNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","B'a̱ kitsú ngá k'u̱a̱: —Kui nda̱i̱ xi kitsú Nti̱a̱ná nga ts'i̱ín nibá. Tu̱nga tjín ngá xi b'a̱ kitsú: —¿Nkú ts'ín Galilea̱ ni̱baha xi Cristo̱? ");
INSERT INTO majNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿A najmi b'a̱há ts'ín tjít'a éhe̱n Nti̱a̱ná, nga ntje̱he̱ David ni̱baha̱ ra̱ xi Cristo̱, ko̱ nga Belen ni̱baha, má nga nankihi̱ David? ");
INSERT INTO majNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","B'a̱ ts'ín tsakjányaha yjoho̱ xu̱ta̱ na̱nti̱o̱ nga i̱ncha kinchja̱ni̱jmíyaha Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tjín xi kama mjehe̱ nga ku̱a̱kj'ánijéhe̱ tu̱nga ndahá nku najmi kits'ínko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A̱s'a̱i já xi kunntá ni̱nku̱ j'ai ngáha má tjíntu já na̱'mi k'aku̱ ko̱ já fariseo̱ ko̱ b'i̱ kik'ihi̱n: —¿Á najmi kjúái̱ko̱honu ndo̱? ");
INSERT INTO majNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","B'a̱ kitsú jóo̱: —Ndaha nku najmi kje̱e b'a̱ ts'ín nchja̱ xi nkú ts'ín nchja̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","B'a̱ kitsú já fariseo̱: —¿A ko̱hó jun ta̱ kuak'ana̱cha̱nu̱u ndo̱? ");
INSERT INTO majNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿A tjíhín a̱jihi̱n já tjíxóo̱ ko̱ a ra̱ a̱jihi̱n já fariseo̱ xi s'ejihi̱n Jesu? ");
INSERT INTO majNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tu̱nga xu̱ta̱ xu'bi̱ bi, najmi mankjihi̱n kju̱a̱téxumoo̱. Kui xi najmi nda nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","A̱s'a̱i kinchja̱ Nicodemo̱, nda̱ fariseo̱ xi j'aisehe̱ Jesu nga jyuu̱n: ");
INSERT INTO majNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Xi nkú ts'ín tíjña kju̱a̱téxumaná, títjun tjíhin nga ku̱a̱sinñjuhu̱ú xu̱ta̱ tu̱ xi cha̱haná ni xi kits'ín ko̱ a̱skahan n'e̱ ra̱á kju̱a̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","B'a̱ kitsú jóo̱: —¿A ta̱ ko̱hó ji xi nibáhani Galilea̱? N'e̱ya nda ndai xu̱ju̱n éhe̱n Nti̱a̱ná ko̱ cha̱i̱ nga ndaha nku nda̱ profeta̱ najmi kje̱e tjujín Galilea̱. ");
INSERT INTO majNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","A̱s'a̱i b'i̱ ngján i̱ncha ngji ngáha ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","A̱s'a̱i ngji Jesu a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nk'ie nga ja kama sehe̱n ni̱stjin xi ma ndyjuu̱n, j'ai ngáha má ma na̱tsihi̱n ni̱nku̱. Yo̱ j'aise ṉkjúhu̱n xu̱ta̱ ko̱ yo̱ y'ejña nga tsakúya. ");
INSERT INTO majNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A̱s'a̱i i̱ncha j'aiko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱ ko̱ já fariseo̱ nku ta̱chju̱ún xi kiya nga kj'a̱í nda̱ kjijñako̱ho̱. J'aisínjña nginku̱n Jesu ko̱ nginku̱n xu̱to̱ ");
INSERT INTO majNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ko̱ b'a̱ kitsú: —Ji nda̱ maestru̱, kuaya ta̱chjíi̱n nga kj'a̱í nda̱ kjijñako̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","B'a̱ ts'ín y'ét'a Moise kju̱a̱téxumoo̱ nga ndji̱o̱ n'e̱k'iehen xi b'a̱ ts'i̱íu̱n. Ji bi, ¿nkú bixín? ");
INSERT INTO majNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tu̱ xi kikjut'ayák'uhún ni Jesu nga b'a̱ i̱ncha kitsú, a̱t'aha̱ mjehe̱ ku̱a̱téjéne. A̱s'a̱i y'ejñantu Jesu ko̱ na̱jnú ntsja kits'ínntuko̱ho t'anankiu̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nk'ie nga tu̱ nku tíi̱ncha bjásjaiyahá ra̱ jóo̱, tsasinjña ngáha ko̱ b'i̱ kitsú: —Xi najmi tjíhi̱n ngatitsun, kui xi tjun kat'éhe̱ ndji̱o̱ ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","A̱s'a̱i ta̱ y'ejñantuhú ngáha nga tu̱ nku kits'ínntuhú t'anankiu̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nk'ie nga kint'é jóo̱ éi̱n, nkúnkú b'i̱ ngján i̱ncha ngji. Xi 'yún cháha̱ tjun ngji. A̱s'a̱i tu̱ Jesu ko̱ ta̱chjúu̱n tsinchajin subaha̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ta̱ tsasinjña ngáha Jesu ko̱ b'i̱ kitsú: —Ji ta̱chju̱ún, ¿má kfihi̱ jóo̱? ¿A ndaha nku najmi ta̱ tíbatéjénehe ri? ");
INSERT INTO majNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Najmi, Chá Nti̱a̱. Ndaha nku —kitsú ta̱chjúu̱n. B'i̱ kitsú Jesu: —Ta̱ ndaha an najmi chumi ni kjaninéhe. T'in ngáhani ko̱ najmi ta̱ n'eheni ngatitsun. ");
INSERT INTO majNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","A̱s'a̱i kinchja̱ko̱ ngáha xu̱to̱: —An nd'í xi ts'ín ndzjehe̱n xu̱ta̱ a̱sunntei̱. Xi tsjénnkina najmi jyun má k'úéma. S'e̱he̱ nd'í xi ts'i̱ínk'íéntu tík'uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A̱s'a̱i b'a̱ i̱ncha kitsú já fariseo̱: —Ji tí'mi su̱ba̱i̱ kju̱a̱nda yjohi̱. Kui nga najmi chjíhi̱ ra̱ én xi tíchubahani. ");
INSERT INTO majNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","B'i̱ kitsú Jesu nga kinchja̱: —Ta̱ ndaha tsa an tífi su̱ba̱ha̱ ra̱ kju̱a̱nda yjona̱, tu̱nga chjíhi̱ ra̱ én xi tínchja, a̱t'aha̱ be má nibahana ko̱ má kfín ngáhana. Jun najmi yo má nibáhana ko̱ najmi yo má kfín ngáhana. ");
INSERT INTO majNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jun bi, xi nkú ts'ín tíjñaha̱ a̱sunntei̱, b'a̱ ts'ín chasoho̱o ni xi nda ko̱ ni xi najmi nda, tu̱nga an najmi basjehe̱ ni xi nda ko̱ ni xi najmi nda ts'ín xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tu̱nga tsa ni xi b'a̱ ts'ihinna, kixi̱ ts'ian, a̱t'aha̱ najmi kuenta̱na̱ b'a̱ ts'ihinna. Na̱'mi xi kits'ín nibá nína b'a̱ ts'inka̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Santaha kju̱a̱téxumanu̱u b'a̱ ts'ín tjít'a: Tsa jo já ku̱i̱tsu̱ya nku ni, chjíhi̱ ra̱ ni xi ku̱i̱tsu̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","An tífihi̱ ra̱ kju̱a̱nda yjona̱ ko̱ Na̱'mina̱ xi kits'ín nibána ta̱ tífina kju̱a̱nda. ");
INSERT INTO majNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","B'a̱ kitsú jóo̱: —¿Má tíjña Na̱'mihi̱? B'i̱ kitsú Jesu: —Najmi yanú ko̱ ta̱ ndaha najmi yo Na̱'mina̱. Tsa yanú, ta̱ cha̱ ru̱u Na̱'mina̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","B'a̱ ts'ín kinchja̱ nga tsakúya má ma na̱tsihi̱n ni̱nku̱, má tíjña kaxa̱ha̱ to̱on chje̱. Ndaha nku najmi jakj'ánijéhe̱, a̱t'aha̱ najmi kje̱e bichú chu̱ba̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","A̱s'a̱i ta̱ kinchja̱há ngáha: —An kfíán ko̱ ku̱i̱nchísjainú. A̱jihi̱n ngatitsunnu̱u ku̱a̱yájiun nga najmi ta̱ tíi̱jñahana. Má nga kfíán najmi ka̱ma kuankíún. ");
INSERT INTO majNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","B'a̱ kitsú já judio̱ k'aku̱: —¿A ts'i̱ínk'ien subahá yjoho̱? ¿Á: “má nga kfíán najmi ka̱ma kuankíún”, títsuhu? ");
INSERT INTO majNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","B'i̱ kitsú Jesu: —Kintei̱ ts'a̱jun, nk'a ján ts'a̱n. A̱sunntei̱ tje̱he̱nnu̱u, nk'a ján tje̱he̱nna. ");
INSERT INTO majNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tsa najmi s'e̱jinnu̱u nga an xi tíi̱jña, ngatitsunnu̱u ku̱a̱yájiun. Kui kju̱a̱ha nga b'a̱ kuaxihi̱nnu̱u na̱nd'a̱i̱ nga ngatitsunnu̱u ku̱a̱yájiun. ");
INSERT INTO majNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Yáha ji? —kitsú jóo̱. B'i̱ kitsú Jesu: —Xi ja kixinnu̱u nga tuts'ihi̱n ni. ");
INSERT INTO majNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Benu̱u. Ka̱ma xínya xi nkú ts'ín tjíntuyánu̱u. Ka̱ma xínya má nihi xi nda ko̱ má nihi xi najmi nda tín'o. Tu̱nga xi kits'ín nibána, kui xi ma n'e s'ejián ni xi tsu. Ko̱ ni xi kint'e nga kinchja̱, kui xi tínchja ngáhana a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tu̱nga najmi kamankjihín ra̱ jóo̱ nga Nti̱a̱ Na̱'miu̱ kinchja̱ni̱jmíyaha. ");
INSERT INTO majNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kui nga b'i̱hí ta̱ kitsú ngáha Jesu: —Nk'ie nga chjúsíntje̱nnk'o Ntíhi̱ Nda̱x'i̱u̱n, nk'iehé nga ka̱mankjinnu̱u nga an xi tíi̱jña ko̱ nga ndaha nku ni najmi ts'ian kuenta̱na̱. Xi nkú ts'ín tsakúyana Na̱'mina̱, kui nihi xi tínchja. ");
INSERT INTO majNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Xi kits'ín nibána tíjñako̱na. Najmi b'éjña subana, a̱t'aha̱ ts'intjusun tehe̱nte ni xi sasíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nk'ie nga b'a̱ kitsú, nkjin ṉkjún xi kis'ejihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","A̱s'a̱i kinchja̱ko̱ xu̱ta̱ judio̱ xi kis'ejihi̱n: —Tsa ku̱i̱ntsu̱ba̱jiun énna̱, kju̱axi̱ nga ka̱mo xu̱ta̱ ni'yakuyána̱ ");
INSERT INTO majNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ko̱ cho̱o ni xi na̱xu̱ tjín ko̱ kui niu̱ xi ts'i̱ín nda̱ínu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","B'a̱ kitsú jóo̱: —Ntje̱he̱ Abraham ji̱n. Ndaha nku najmi kje̱e ts'ín mani̱ xu̱ta̱ musu, tsa ts'atseni̱. ¿Nkú ts'ín b'a̱ tíbixíhinni nga ka̱ma nda̱íhi̱ni̱? ");
INSERT INTO majNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","B'i̱hí ta̱ kitsú ngáha Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Ngayjee̱ xi títs'ín ngatitsun, nga'yúhu̱n ngatitsuu̱n tíjñajin. Najmi nda̱íhi̱ yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nku nda̱ musu̱ xi kich'atse najmi nda̱íhi̱ yjoho̱, ndaha tsa ni'yaha̱ nda̱ nti̱a̱ha̱ ts'ínxá. Tu̱nga ntíhi̱ ní nda nti̱a̱ha̱ ka̱ma ts'e̱ ni'yoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kui nga tsa Ntíhi̱ Nti̱a̱ná ts'i̱ín nda̱ínu̱u, kju̱axi̱ nga ka̱ma nda̱ínu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Be nga ntje̱he̱ Abraham nibáhanu, tu̱nga mjehénu̱u n'e̱k'iennú a̱t'aha̱ najmi mjenu̱u n'e̱kjóho̱on énna̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","An nchja ni xi bakúchjina Na̱'mina̱. Jun bi, n'o ni xi bakúyanu̱u na̱'minu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","B'a̱ kitsú jóo̱: —Abraham na̱'mini̱. B'i̱ kitsú Jesu: —Tsa ntíhi̱ Abraham jun, b'a̱ ra̱ n'o̱o xi nkú kits'ín Abraham. ");
INSERT INTO majNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tu̱nga nd'a̱i̱ mjenu̱u n'e̱k'iennú, ndaha tsa tíxinyanu̱u ni xi na̱xu̱ tjín xi tsakúyana Nti̱a̱ná. Ndaha̱chí najmi b'a̱ kits'ín Abraham. ");
INSERT INTO majNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jun bi, ni xi ts'íhín na̱'minu̱u n'o. B'a̱ kitsú jóo̱: —Ntí nda níi̱. Tíjñaháni̱ nku na̱'mi nku tutu. Kui xi Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","B'i̱ kitsú Jesu: —Tsa Nti̱a̱ná xi na̱'minu̱u, jun ra̱ xi n'e̱tjónú, a̱t'aha̱ má tíjña Nti̱a̱ná nibahana. Najmi kuenta̱na̱ jái̱hina. Kui ní xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Najmi mankjinnu̱u ni xi tínchja a̱t'aha̱ najmi mjenu̱u ku̱a̱sinñjuhu̱u énna̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nda̱nindoo̱ ní na̱'minu̱u. Kui ts'e̱nu̱u ko̱ mjenu̱u n'o̱o xi nkú ts'ín mjehe̱. Kui xi santaha nga tuts'ihi̱n ni kits'ínk'ien xu̱ta̱. Najmi y'ejñajin ni xi na̱xu̱ tjín, a̱t'aha̱ najmi tíjñajihi̱n ni xi na̱xu̱. Nkú ts'ín tjíyaha̱, b'a̱ ts'ín nchja̱. Én tsank'á nchja̱. Kui xi tsank'á ko̱ na̱'mihi̱ én tsank'óo̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","’An bi, ni xi na̱xu̱ tínchja. Kui kju̱a̱ha nga najmi tís'ejihi̱nnu̱u an. ");
INSERT INTO majNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿A tjín a̱jinnu̱u xi ka̱ma ku̱a̱kúchji nga tjínna ngatitsun? Tu̱nga tsa na̱xu̱ tjín ni xi tínchja, ¿á najmi s'ejihi̱nnu̱u an? ");
INSERT INTO majNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xi Nti̱a̱ná ts'e̱he̱ mjéñjuhu̱ én xi ts'e̱ Nti̱a̱ná. Tu̱nga najmi Nti̱a̱náhá ts'e̱nu̱u. Kui kju̱a̱ha nga najmi mjeñjúhunú. ");
INSERT INTO majNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","B'a̱ kitsú já judio̱: —Kju̱axi̱hí ni xi tíbixíi̱n. Samari̱a̱ nibáhani. Nda̱nindoo̱ tíjñajihin. ");
INSERT INTO majNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","B'i̱ kitsú Jesu: —Najmi nda̱nindoo̱ tíjñajinna. Benkján Na̱'mina̱ tu̱nga jun najmi tíyankjúnnú. ");
INSERT INTO majNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Najmi kju̱a̱chánka tíbangisja nginku̱n xu̱ta̱, tu̱nga tíjñahá xi tíbangisjai kju̱a̱chánkana̱. Kui xi ku̱i̱tsu̱ya yá xi na̱xu̱ títs'ín. ");
INSERT INTO majNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kju̱axi̱ ni xi tíxinnu̱u. Xi k'úéjñajin énna̱, najmi ts'i̱ínkjáíhi̱n ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","B'a̱há ta̱ kitsú ngáha já judio̱: —Kju̱axi̱hí nga nda̱nindoo̱ tíjñajihin. Abraham ko̱ já profeta̱ ta̱ k'ien. Tu̱nga ji b'a̱ tíbixín nga najmi ts'i̱ínkjáíhi̱n ngabayoo̱ xi k'úéjñajin éhi̱n. ");
INSERT INTO majNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿A 'yún chánka sai nga Abraham xi ntje̱ cháná? Kui xi ta̱ k'ien ko̱ já profeta̱. ¿Yá xi tín'e mai yjohi̱? ");
INSERT INTO majNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","B'i̱ kitsú Jesu: —Tsa an su̱ba̱ chánka tíb'asje yjona̱, najmi chumi ni chjíhi̱ ra̱ kju̱a̱chánka xi tísakúna. Tu̱nga Na̱'mina̱há xi chánka tíb'asjena, kui xi ta̱ Nti̱a̱ 'mihu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kui xi najmi yo, tu̱nga máha an, be. Tsa b'a̱ xínnu̱u nga najmi be, ta̱ nda̱ tsank'á ka̱ma xi nkúhu jun. Tu̱nga bená ko̱ tíi̱jñajian éhe̱n. ");
INSERT INTO majNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tsjo kamaha̱ Abraham xi ntje̱ chánu̱u nga sku̱e̱ ni̱stjin nga kjúa̱. Kikie kjáíhin ko̱ tsjo kamaha̱. ");
INSERT INTO majNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","B'a̱ kitsú já judio̱: —Ndaha najmi kje̱e tjíhin cháte nú nga b'a̱ tíbixín. ¿Nkú ts'ín nga kiyahani Abraham? ");
INSERT INTO majNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","B'i̱ kitsú Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Kintehe̱ ni nga tsín Abraham, tu̱ b'a̱ ts'ín jahá tíi̱jña. ");
INSERT INTO majNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","A̱s'a̱i jakj'á ndji̱o̱ jóo̱ xi má nga mjehe̱ ts'i̱ínk'iehe̱n, tu̱nga Jesu ngji t'axíhi̱n jóo̱ ko̱ tsitju má ma na̱tsihi̱n ni̱nku̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Má xi tje̱hen j'a Jesu, kikie nku nda̱ xi tu̱ b'a̱ ts'ín ka̱há nkúhu nga kitsin. ");
INSERT INTO majNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A̱s'a̱i kingjásjaiya já ni'yakuyáha̱: —Ji nda̱ maestru̱, ¿yá xi kits'ín ngatitsun tu̱ xi b'a̱ ts'ín ka̱ kitsihin nda̱i̱? ¿A kui, a ra̱ xi cháha̱ ní? ");
INSERT INTO majNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","B'i̱ kitsú Jesu: —Ta̱ ndaha kui ko̱ ta̱ ndaha xi cháha̱ najmi kits'ín ngatitsun nga b'a̱ kamoo̱. B'a̱ ts'ín kitsin tu̱ xi sa̱kúchjihi ni xi maha̱ ts'ín Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tjíhin nga n'e̱é xá xi ts'e̱ xi kits'ín nibána nk'ie nga ndzjen sa. A̱t'aha̱ nga ka̱ma jyun, najmi ta̱ ch'a ka̱ma ts'i̱ínxá saha. ");
INSERT INTO majNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nk'ie nga tíi̱jña a̱sunntei̱, an xi nd'í xi ts'ín ndzjehe̱n xu̱ta̱ a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","B'a̱ kitsú Jesu, a̱s'a̱i tsatété t'anankiu̱ ko̱ ntá na̱téhe̱ kits'ínndako̱ho si. Kui xi kingjájnuhu̱ tunku̱n ndo̱ ko̱ b'i̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—T'ihi̱nnejnui tunkuin ntá ti̱xa̱ Siloe. Kui nga ngjinéjnuhu tunku̱n ndo̱. Ja chjihi̱ nk'ie nga kik'óya ngáha. ");
INSERT INTO majNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A̱s'a̱i já xi nda nchja̱ko̱ho̱ ko̱ já xi kikiehe̱ nga banki to̱on kinchja̱ni̱jmíyaha ndo̱. B'a̱ kitsú k'u̱a̱: —¿A najmi kuihí nda̱i̱ xi b'ejña nga banki to̱on? ");
INSERT INTO majNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Joho̱n, kui —kitsú k'u̱a̱. —Najmi kui, tu̱nga b'a̱ tjín xi kuihí tjín —kitsú ngá kj'a̱í. —Ahán niu̱ —kitsú ndo̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿Nkú ts'ín tsix'ánkihi tunkuin? —kitsú jóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","B'a̱ kitsú ndo̱: —Nda̱ xi 'mi Jesu kuats'ínnda si ko̱ kuangjájnuhu̱ tunkán ko̱ b'i̱ kuatsúna: “T'in ntá ti̱xa̱ Siloe ko̱ ta̱nejnui tunkuin.” Kui nga kfihina ko̱ nk'ie nga kuakanejná tunkán, kama chjina. ");
INSERT INTO majNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Má tíjña ndo̱? —kitsú jóo̱. —Najmi be —kitsú ndo̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","A̱s'a̱i ngjiko̱ho̱ jóo̱ nda̱ xi kama chjihi̱ nginku̱n já fariseo̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ni̱stjin nga kits'ínnda siu̱ Jesu ko̱ tsix'ánki tunku̱n ndo̱, kui xi ni̱stjin nkjún. Xua̱tu̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kui nga já fariseo̱ kingjásjaiyaha̱ ra̱ nkú ts'ín kama chjihi̱ ra̱ ko̱ b'a̱ kitsú ndo̱: —Si kuangjájnuhu̱ tunkán, kuakanejná, ko̱ kama chjina. ");
INSERT INTO majNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","A̱s'a̱i b'a̱ kitsú k'u̱a̱ já fariseo̱: —Najmi Nti̱a̱ná kits'ín nibáha̱ nda̱ xi b'a̱ kuats'íu̱n, a̱t'aha̱ najmi benkjún ni̱stjin nkjúu̱n. B'a̱ kitsú ngá k'u̱a̱: —¿Nkú ts'ín nku nda̱ ngatitsun ka̱ma ts'i̱íhin kju̱a̱nkjún xi nkúhu xu'bi̱? B'a̱ ts'ín tsakjányaha yjoho̱ já fariseo̱ nga̱t'aha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","A̱s'a̱i ta̱ i̱ncha kingjásjaiyahá ngáha̱ ra̱ nda̱ xi kama chjihi̱: —Ko̱ ji xi kuix'ánki tunkuin, ¿yáha ndo̱? ¿Nkú bixín? —Nda̱ profeta̱ niu̱ —kitsú. ");
INSERT INTO majNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tu̱nga najmi kis'ejihín ra̱ já judio̱ k'aku̱ tsa kui ndo̱ xi ka̱ nk'ie ko̱ tsa kui xi ja chji ngáha̱ ra̱. Kui nga kinchja̱ha̱ ra̱ xi cháha̱ ");
INSERT INTO majNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ko̱ kingjásjaiyaha̱: —¿A kui ntínu̱u xu'bi̱ xi bixíún nga ka̱ nga kitsin? ¿Nkú ts'ín kama chjihi̱ ra̱? ");
INSERT INTO majNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","B'a̱ kitsú xi cháha̱ ndo̱: —Yai̱ nga kui xi ntíni̱ ko̱ ka̱ nga kitsin. ");
INSERT INTO majNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tu̱nga najmi yaníi̱ nkú ts'ín kama chjihi̱ ra̱. Najmi yai̱ yá xi kuakjex'ánki tunku̱n. Tu̱ sahá kui cha̱sjaiyoho̱o. Ja chá. Ka̱ma ku̱i̱tsu̱ya subanu̱u ni xi kamat'ain. ");
INSERT INTO majNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","B'a̱ kitsú xi cháha̱ ndo̱ a̱t'aha̱ tsankjún já judio̱ k'aku̱. A̱t'aha̱ y'éndako̱ xinkjín já judio̱ k'aku̱ tsa tjín xi ts'i̱ínkie yjoho̱ nga Jesu xi kits'ín nibá Nti̱a̱ná, kui xi ku̱i̱ch'onsje a̱jihi̱n xu̱ta̱ sinagoga̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kui kju̱a̱ha nga: “Cha̱sjaiyoho̱o, ja chá”, kitsúhu xi cháha̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A̱s'a̱i ta̱ kinchja̱há ngáha̱ ra̱ ni̱yá xi ma joho já judio̱ k'aku̱ nda̱ xi kama chjihi̱ ko̱ b'a̱ kitsúhu̱: —Yai̱ nga nda̱ ngatitsuhún xi kuats'ínnkihi. N'e̱kiei yjohi̱ nginku̱n Nti̱a̱ná xi tjíhi̱n kju̱a̱chánka nga kju̱axi̱ ni xi tíbixín. ");
INSERT INTO majNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","B'a̱ kitsú ndo̱: —Tsa nku nda̱ ngatitsun niu̱ najmi be. Tu̱ nkuhú ni xi be. Ka̱ná ni̱stjin nk'ie tu̱nga nd'a̱i̱ ja chjina. ");
INSERT INTO majNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","B'a̱ kitsú jóo̱: —¿Mí xi kuats'íhin? ¿Nkú ts'ín kuakjex'ánkihi tunkuin? ");
INSERT INTO majNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A̱s'a̱i b'a̱ kitsú ndo̱: —Ja kuaxinyanu̱u tu̱nga najmi tín'esihínnú. ¿Á mjehe̱nu̱u nga b'a̱há ta̱ xín ngáha̱nu̱u? ¿A ko̱hó jun mjenu̱u ka̱mo já ni'yakuyáha̱ ndo̱? ");
INSERT INTO majNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","B'a̱ kitsú jóo̱ nga kinchja̱tiko̱: —Nda̱ ni'yakuyáha̱ ní ndo̱ ji. Tu̱nga ji̱n já ni'yakuyáha̱ ní Moise ji̱n. ");
INSERT INTO majNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yai̱ nga Moise kinchja̱ én xi Nti̱a̱ná kitsúyaha̱, tu̱nga najmi ya níi̱ má j'aihi̱ ra̱ nda̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A̱s'a̱i b'i̱ kitsú ndo̱: —Ma nkjúnna nga najmi yo má j'aihi̱ ra̱ nda̱ xi kamaha̱ kuakjex'ánki tunkán. ");
INSERT INTO majNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yaá nga Nti̱a̱ná najmi basínñjuhu̱ xu̱ta̱ ngatitsuu̱n. Tsa tjín xi sku̱e̱nkjún Nti̱a̱ná ko̱ ts'i̱ín ni xi mjehe̱, kuihí xi basínñjuhu̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ndaha̱chí najmi kje̱e nu'yá tsa tjín xi kjex'ánki tunku̱n xu̱ta̱ xi ka̱ nga kitsin. ");
INSERT INTO majNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tsa najmi Nti̱a̱ná kits'ín nibáha̱ nda̱ xu'bo̱, najmi chumi nihi xi ka̱maha̱ ra̱ ts'i̱ín. ");
INSERT INTO majNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","B'i̱ kitsú jóo̱ nga tsich'onsje ndo̱ a̱jihi̱n xu̱ta̱ sinagoga̱: —Ngatitsun kitsinjín. ¿A jihí xi ku̱a̱kúyani̱? ");
INSERT INTO majNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kint'é Jesu nga tsich'onsje ndo̱. B'i̱ kitsúhu̱ nk'ie nga kisatéjin ngáha: —¿A s'ejihin Ntíhi̱ Nda̱x'i̱u̱n? ");
INSERT INTO majNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Ji Nda̱ Nti̱a̱ —kitsú ndo̱—, ¿yáha xu'bo̱, tu̱ xi s'e̱jihinna? ");
INSERT INTO majNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","B'i̱ kitsú Jesu: —Ja kuayai. An ní niu̱, an xi tínchjako̱hi. ");
INSERT INTO majNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—S'ejinna ji, Nda̱ Nti̱a̱ —kitsú ndo̱ ko̱ tsasinkúnch'int'aha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","A̱s'a̱i b'i̱ kitsú Jesu: —An jáa̱ a̱sunntei̱ tu̱ xi n'e̱ko̱kju̱a̱ha, tu̱ xi ka̱ma chjihi̱ ra̱ xi ka̱ ko̱ ka̱ma ka̱ xi chjihi̱. ");
INSERT INTO majNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ta̱ kint'é éi̱n k'u̱a̱ já fariseo̱ xi tíi̱nchako̱ Jesu ko̱ b'a̱ kitsúhu̱: —¿A ko̱hó ji̱n xi ta̱ ka̱i̱? ");
INSERT INTO majNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","B'i̱ kitsú Jesu: —Tsa ni xi ka̱hanu, najmi tjínnu̱u jé kai. Tu̱nga b'a̱há tíbixínnú nga chjinu̱u. Kuihí kju̱a̱ha nga tjíhi̱nnu̱u jé. ");
INSERT INTO majNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","B'i̱ ts'ín kinchja̱ Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. Tu̱ yáhá ni xi najmi kju̱a̱s'en a̱nkju̱a̱ ni'yaha̱ chu̱tsa̱nko̱ nga tu̱ sahá xin kju̱a̱s'enntjai, kui xi nda̱ ndyjé xi mjehe̱ ngju̱a̱i̱ko̱ chu̱tsa̱nko̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tu̱nga xi kju̱a̱s'en má tje̱n a̱nkju̱o̱, kui xi nda̱ bastuhu̱ chu̱tsa̱nko̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kjex'á nda̱ xi basehe̱ a̱nkju̱o̱ nk'ie nga be nda̱ bastuu̱. Chu̱tsa̱nka̱ xi ts'e̱ nt'é nta̱ha̱, ko̱ nga nkúnkú chu̱tsa̱nka̱ha̱ j'áíhi̱n nchja̱ha̱ ra̱ nga bitjuko̱ ni'yoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nk'ie nga bitjuko̱ ngayjee̱ chu̱tsa̱nka̱ xi ts'e̱, a̱s'a̱i tsjen títjuhu̱n ko̱ chu̱tsa̱nko̱ tsjennkíhi̱ a̱t'aha̱ be nta̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Chu̱ xi ts'e̱ najmi tsjennkíhi̱ xu̱ta̱ xi kj'a̱í. Tu̱ sahá banka, a̱t'aha̱ najmi be nta̱ha̱ xu̱ta̱ xi kj'a̱í. ");
INSERT INTO majNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","B'a̱ kitsú Jesu nga y'éjña chu̱ba̱ya ni xu'bi̱. Tu̱nga najmi kamankjihín ra̱ xu̱ta̱ ni xi kinchja̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","A̱s'a̱i b'a̱há ta̱ kitsú ngáha Jesu: —Kju̱axi̱ ni xi tíxinnu̱u. An xi nkú joyaha a̱nkju̱a̱ má nga fas'en chu̱tsa̱nko̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ngayjee̱ já xi j'ai títjun nga an, kui xi já ndyjé xi kama mjehe̱ nga ngju̱a̱i̱ko̱ chu̱tsa̱nko̱. Tu̱nga najmi kint'éhé chu̱tsa̱nko̱ nta̱ha̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","An xi nkú joyaha a̱nkju̱o̱. Xu̱ta̱ xi kju̱a̱s'enjinna k'u̱a̱nki. Kui xi ka̱ma xi nkú joyaha chu̱tsa̱nka̱ xi fas'en ko̱ bitju ni'yaha̱ nga fi kjine jñá. ");
INSERT INTO majNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Nda̱ ndyjée̱ f'ai tu̱ xi fiko̱ho ko̱ ts'ínk'ien ko̱ ts'ínkje chu̱tsa̱nko̱. Tu̱nga ahán jáa̱ tu̱ xi ka̱ma k'úéntu tík'uhun xu̱ta̱, tu̱ xi sa̱kúhu̱ ra̱ kju̱a̱tík'un xi ndoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","An xi nda̱ bastu xi ndoo̱, ko̱ nda̱ bastu xi ndoo̱ tsjá yjoho̱ nga ku̱a̱yántjaihi chu̱tsa̱nka̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nda̱ xi tu̱ to̱ohón ts'ínxántjaihi, xi najmi kui ts'e̱ xóo̱ ko̱ najmi kui ts'e̱ chu̱tsa̱nko̱, kui xi binchá masen chu̱tsa̱nko̱ ko̱ banka nk'ie nga be nga nibá chu̱ kjoo̱n. A̱s'a̱i chu̱ kjoo̱n kjine chu̱tsa̱nko̱ ko̱ ts'ínndzjoya. ");
INSERT INTO majNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","B'a̱ ts'ín bankaha ndo̱ a̱t'aha̱ tu̱ to̱ohón ts'ínxántjaihi ko̱ najmi nkjún maha̱ chu̱tsa̱nko̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’An xi nda̱ bastu xi ndoo̱. Be chu̱tsa̱nka̱na̱ ko̱ ta̱ bena, ");
INSERT INTO majNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","xi nkú ts'ín bena Nti̱a̱ Na̱'miu̱ ko̱ an be Nti̱a̱ Na̱'miu̱. Tsja yjona̱ nga ku̱a̱yántjaihina chu̱tsa̱nko̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tíi̱ncha sana kj'a̱í chu̱tsa̱nka̱ xi najmi tíi̱ncha nch'á xu'bi̱. Kui xi ta̱ tjíhin nga kjúái̱ka̱. Ku̱i̱nt'é nta̱na̱. B'a̱ ts'ín nku stíhín ka̱maha ko̱ nkuhú nda̱ bastu xi ku̱a̱se̱he̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Kui kju̱a̱i̱ nga tjoho̱ ra̱ an Nti̱a̱ Na̱'miu̱. Tsja yjona̱ nga ku̱a̱yá tu̱ xi kj'u̱a̱íya ngáhana. ");
INSERT INTO majNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Najmi ch'a ka̱ma kjé'ana nga tíi̱jña tík'an. An ní tsja su̱ba̱ yjona̱ nga ku̱a̱yá. Tjínna nga'yún xi má nga tsja yjona̱ ko̱ ta̱ tjínna nga'yún nga kúáte̱jña tík'un ngáhana. Kui xái̱ xi kitsjána Na̱'mina̱ nga ts'ian. ");
INSERT INTO majNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nk'ie nga kint'é jóo̱ éi̱n, a̱s'a̱i ta̱ tsakjányahá ngáha yjoho̱. Nkjin xi b'a̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Nda̱nindahá tíjñajihi̱n ndo̱ ko̱ luku̱. ¿Á jun tíbasinñjuhu̱ru̱u? ");
INSERT INTO majNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","B'a̱ kitsú ngá k'u̱a̱: —Najmi b'a̱ ts'ín ku̱i̱nchja̱ xi tíjñajihi̱n nda̱nindoo̱. ¿A ka̱mahá ra̱ nda̱nindoo̱ kjéx'ánki tunku̱n xu̱ta̱ ka̱? ");
INSERT INTO majNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nk'ie nga ni̱stjin chu̱nch'óo̱n, nanki Jerusalen tíi̱ncha b'asje s'í xu̱ta̱ nga tíi̱ncha ts'ínkj'áítsjen ni̱stjin nk'ie nga kis'ejña chji ni̱nku̱ nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kikjatsú'ba Jesu má ma na̱tsihi̱n ni̱nku̱ xi tje̱hen má nga 'mi Kinte Ni'yaha̱ Salomon. ");
INSERT INTO majNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A̱s'a̱i y'étjindaihi̱ jóo̱ ko̱ b'a̱ kitsúhu̱: —¿Nkú tjín ni̱stjin n'e̱sti sani̱? Tsa kju̱axi̱ nga ji xi kits'ín nibá Nti̱a̱ná, t'inya kixi̱ kixi̱ni̱ nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","B'i̱ kitsú Jesu: —Ja b'a̱ kixinnu̱u tu̱nga najmi kis'ejihínnu̱u. Ni xi títs'ian ngajoho̱ Na̱'mina̱, tíbakúchji yáha an. ");
INSERT INTO majNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tu̱nga najmi s'ejihínnu̱u a̱t'aha̱ najmi chu̱tsa̱nka̱na̱ jun. ");
INSERT INTO majNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chu̱tsa̱nka̱na̱ nt'é nta̱na̱. An be chu̱tsa̱nka̱na̱ ko̱ tsjennkína. ");
INSERT INTO majNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","An ts'ink'íéntu tík'un síán. Najmi ka̱ma ndyja̱ ko̱ najmi ch'a xi kjé'ana a̱ya ntsa̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na̱'mina̱ kitsjána chu̱tsa̱nko̱ ko̱ kui xi 'yún chánka nga tu̱ yáhá ni. Ndaha nku najmi ka̱maha̱ kjé'aha̱ chu̱tsa̱nka̱ xi tjíntu a̱ya ntsja. ");
INSERT INTO majNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na̱'miu̱ ko̱ an nkuhú maha̱ni̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nk'ie nga kint'é éi̱n já judio̱ k'aku̱, a̱s'a̱i ta̱ jakj'á ngáha ndji̱o̱ nga mjehe̱ ts'i̱ínk'ien Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","B'i̱ kitsú Jesu nga kinchja̱: —Nkjin ṉkjún ni xi nda kits'ian a̱jinnu̱u, xá xi kitsjána Na̱'mina̱. ¿Má nga̱t'aha̱ mjehe̱nu̱u k'úéhenú ndji̱o̱? ");
INSERT INTO majNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","A̱s'a̱i b'i̱ kitsú jóo̱: —Najmi nga̱t'aha̱ ni nda xi kin'ei. Tu̱ nga̱t'aha̱ ní nga najmi tíyankjúín Nti̱a̱ná nga b'a̱ tíbixín. Kui kju̱a̱ha nga ndji̱o̱ s'e̱he ri. Nda̱ a̱sunnte ní, tu̱nga Nti̱a̱náhá tín'e mai yjohi̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","B'i̱ kitsú Jesu: —Kju̱a̱téxumanu̱u tjít'a má nga b'a̱ kitsú Nti̱a̱ná nga kinchja̱ko̱ xu̱ta̱: “Nti̱a̱nú kixinnu̱u.” ");
INSERT INTO majNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","B'a̱ ts'ín Nti̱a̱ná b'a̱ kitsúhu nga nti̱a̱ xu̱ta̱ xi tsichuk'úhu̱n éhe̱n. Ko̱ yaá nga chjíhi̱ ra̱ ngayjee̱ ni xi tjít'a éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","An bi, Nti̱a̱ Na̱'miu̱ kitsjána xá xi tjíhin nga ts'ian ko̱ kits'ín nibána a̱sunntei̱. Kui nga, ¿nkú tjíhi̱n ra̱ nga b'a̱ tíbixíhinnu nga najmi tíbenkjúhunna Nti̱a̱ná nk'ie nga b'a̱ tíxian nga an xi Ntíhi̱ Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tsa najmi títs'ian xá xi ts'e̱ Na̱'mina̱, najmi tu̱ n'e s'ejinnú. ");
INSERT INTO majNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tu̱nga tsa títs'ian xáha̱, ndaha tsa najmi s'e̱jinnu̱u an, tu̱nga n'e̱ s'ejinnú xóo̱. B'a̱ ts'ín cha̱hanu ko̱ ka̱mankjinnu̱u nga Nti̱a̱ Na̱'miu̱ tíjñajinna ko̱ nga an tíi̱jñajihi̱n Nti̱a̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","A̱s'a̱i ta̱ kama mjehé ngáha̱ ra̱ jóo̱ nga ku̱a̱kj'ánijéhe̱, tu̱nga tsitjuhú Jesu yo̱ nga ngji t'axín. ");
INSERT INTO majNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","A̱s'a̱i tsichu ngáha ngabantá ntáje̱ Jordan. Ngjik'iejña a̱nte má nga tsaténtá Jua xu̱ta̱ nga tjuhun. ");
INSERT INTO majNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nkjin xu̱ta̱ xi j'aisehe̱ Jesu yo̱ ko̱ b'a̱ i̱ncha kitsú: —Ndaha nku kju̱a̱nkjún najmi kits'ín Jua, tu̱nga kju̱axi̱hí ngayjee̱ ni xi kinchja̱ni̱jmíyaha nda̱i̱. ");
INSERT INTO majNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nkjin xu̱ta̱ kis'ejihi̱n Jesu a̱nte xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kjijña un nku nda̱ xi 'mi Laza̱ro̱ xi nda̱ Betani̱a̱, má nga ta̱ nankihi̱ Maria̱ ko̱ Marta̱ xi nichja maha xinkjín. ");
INSERT INTO majNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Kui Maria̱ xi tsaténdzjojnúhu̱ ntá sinjne̱ sjai Nda̱ Nti̱a̱ná Jesu ko̱ ta̱ kuihi ntsja̱ku̱ kits'ínxijnuko̱ho. Kui xi nts'e̱ maha Laza̱ro̱ xi kjijña uu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","A̱s'a̱i i̱ncha kits'ínkjihi̱ én Jesu nga joo̱ jminchjíu̱n. B'a̱ kitsúhu̱: —Ji Chá Nti̱a̱, xi tjohi kjijña un. ");
INSERT INTO majNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nk'ie nga kint'é ée̱n Jesu, b'i̱ kitsú: —Najmi ts'i̱ínk'ien kjihi̱n ch'in xi k'uhu̱n. Tu̱ sahá ku̱a̱kúchji ch'iu̱n kju̱a̱chánkaha̱ Nti̱a̱ná. B'a̱ ts'ín s'e̱jña chjihi kju̱a̱chánkaha̱ Ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ndaha tsa Jesu 'yún tjoho̱ Marta̱ ko̱ na̱ nichja ko̱ Laza̱ro̱, ");
INSERT INTO majNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","tu̱nga nk'ie nga kint'é nga kjijña un Laza̱ro̱, tu̱ sahá y'ejña sa jo ni̱stjin a̱nte má nga tíjña. ");
INSERT INTO majNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","A̱skahan b'i̱ kitsúhu̱ já ni'yakuyáha̱: —Ta̱ tjihín ngáhaná Judea̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","B'a̱ kitsú já ni'yakuyóo̱: —Ji nda̱ maestru̱, najmi kje̱e tjíhi̱n ni̱stjin nga já judio̱ k'aku̱ ndji̱o̱ mjehe̱ ts'i̱ínk'iehen ri. ¿Á ta̱ yo̱hó mje ngáha ri k'úín? ");
INSERT INTO majNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","B'i̱ kitsú Jesu: —¿A najmi te johó ora̱ tjíhi̱n nku ni̱stjin? Tsa tjín xi tsú'ba nga ni̱stjiu̱n, najmi sa̱ténki, a̱t'aha̱ tíbe nd'íhi̱ a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tu̱nga tsa tjín xi tsú'ba nga ni̱stje̱n, kui xi sa̱ténki, a̱t'aha̱ najmi tjíhi̱n nd'í. ");
INSERT INTO majNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","A̱s'a̱i b'i̱hí ta̱ kitsú ngáha Jesu: —Kjifehé nda̱ xinki̱á Laza̱ro̱, tu̱nga kfín ts'inkj'áhá ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","B'a̱ kitsú já ni'yakuyóo̱: —Ji Nda̱ Nti̱a̱, tsa kjife, kj'u̱á ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nk'ie nga b'a̱ kitsú Jesu, kju̱a̱bayaha̱ ní Laza̱ro̱ kinchja̱ni̱jmíyaha tu̱nga nijñóo̱ ní kamankjihi̱n já ni'yakuyáha̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kui nga kinchja̱ko̱ kixi̱ kixi̱hi jóo̱: —Ja ka'me Laza̱ro̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ko̱ tsjo mana nga najmi tíi̱jña yo̱, a̱t'aha̱ tu̱ sahá ngandanu̱u, tu̱ xi s'e̱jihi̱nnu̱u Nti̱a̱ná. Tu̱nga tjihi̱nse̱hé ra̱á. ");
INSERT INTO majNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","A̱s'a̱i kinchja̱ Toma xi ta̱ 'mi Nda̱'yu̱n nga b'a̱ kitsúhu̱ já ni'yakuyá xingisoo̱: —Tjián ko̱ ñá tu̱ xi ku̱a̱yáko̱honá. ");
INSERT INTO majNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nk'ie nga tsichu Jesu nanki Betani̱a̱, kik'inyaha̱ nga ja tjíhi̱n ñju ni̱stjin nga ngjiyanji Laza̱ro̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani̱a̱ tiña maha̱ nanki Jerusalen, tjíhi̱n ra̱ tsa jan kilome̱tro̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ko̱ nkjin xu̱ta̱ i̱ncha j'aisehe̱ Marta̱ ko̱ Maria̱ nga̱t'aha̱ nda̱ nts'e̱ xi k'ie̱n. ");
INSERT INTO majNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nk'ie nga kint'é Marta̱ nga j'ai tiña Jesu, a̱s'a̱i tsitjusje nga ngjikj'á ni̱yá ko̱ Maria̱ y'ejñantaha̱ ni'yoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","B'a̱ kitsú Marta̱: —Ji Chá Nti̱a̱, tsa tu̱ e̱i̱hi ma tinchuhunni, najmi k'ien ra̱ chá nts'é. ");
INSERT INTO majNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tu̱nga bená nga tsjáhi Nti̱a̱ná tu̱ mí nihí ni xi ku̱i̱nchíhi̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","B'i̱ kitsú Jesu: —Kj'u̱a̱íya ngáha̱ ra̱ nda̱ nts'ei. ");
INSERT INTO majNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","B'a̱ kitsú Marta̱: —Be nga kj'u̱a̱íya ngáha̱ ra̱ chá nts'é ni̱stjin xi fekuu̱, nk'ie nga kj'u̱a̱íya tente ngáha̱ ra̱ xu̱ta̱ k'ie̱n. ");
INSERT INTO majNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","B'i̱hí ta̱ kitsú ngáha Jesu: —An xi ts'inkj'áíyaha̱ xu̱ta̱ k'ie̱n ko̱ an xi ts'ink'íéntu tík'an. Xi s'e̱jihi̱n an, ndaha tsa ja k'ien tu̱nga k'úéntu tík'uhún. ");
INSERT INTO majNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ko̱ ngayjee̱ xi tjíntu tík'un ko̱ s'ejihi̱n an, ndaha nku ni̱stjin najmi ku̱a̱yá. ¿A s'ejihin ni xi tíxihin? ");
INSERT INTO majNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","B'a̱ kitsú Marta̱: —Joho̱n, Chá Nti̱a̱. S'ejinna nga ji xi kits'ín nibá Nti̱a̱ná, nga ji xi Ntíhi̱ Nti̱a̱ná xi tjíhin nga kj'u̱a̱í a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nk'ie nga b'a̱ kitsú Marta̱, ngji nchja̱ko̱ se̱n Maria̱ xi na̱ nichja maha. B'a̱ kitsúhu̱: —Ja kj'uai Chá Maestru̱ ko̱ tínchja̱hi. ");
INSERT INTO majNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nk'ie nga kint'é Maria̱ éi̱n, ki̱tsa̱ tsisintje̱n nga ngjisehe̱ Jesu má nga síjña. ");
INSERT INTO majNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Najmi kje̱e fas'en Jesu a̱jin na̱nti̱o̱. Yo̱ síjña má kisatékjá Marta̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Máha xu̱ta̱ xi kab'entu na̱xa̱'yo̱, nk'ie nga kikie nga tsisintje̱n ntsu ntsu Maria̱ ko̱ tsitjusje, a̱s'a̱i ta̱ i̱ncha kitsjennkíhi̱. B'a̱ i̱ncha kitsú nga má tíjña tsjóo̱ ngju̱a̱i̱ kjintá. ");
INSERT INTO majNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nk'ie nga tsichu Maria̱ má síjña Jesu, tsasinkúnch'int'aha̱ ko̱ b'a̱ kitsúhu̱: —Ji Chá Nti̱a̱, tsa tu̱ e̱i̱hi ma tinchuhunni, najmi k'ien ra̱ chá nts'é. ");
INSERT INTO majNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nk'ie nga kikie Jesu nga tíkjintá Maria̱ ko̱ nga tíi̱ncha kjintá xu̱ta̱ xi tje̱nko̱ho̱, kik'ie nusin nusihi̱n ko̱ kama ni̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","B'i̱ kitsú: —¿Má kikjayanjiu? B'a̱ i̱ncha kitsú jóo̱: —Nibáa̱se̱i̱hi̱, Nda̱ Nti̱a̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A̱s'a̱i kikjintá Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","B'a̱ kitsú xu̱to̱: —Cha̱se̱ maru̱u. Tu̱ xí kits'íntjohó ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tu̱nga b'a̱há kitsú k'u̱a̱: —Kui nda̱i̱ xi kikjex'ánki tunku̱n nku nda̱ ka̱. Kutsa kamahá ra̱ kits'ínnkihi̱ Laza̱ro̱ ko̱ najmi k'ien ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ta̱ kik'ie nusin nusihín ngáha̱ ra̱ Jesu nga tsichu tsjóo̱. Kui xi nku ti̱xa̱ ngijo. Nku ndji̱o̱ tjíchjaneko̱ho a̱nkju̱a̱ha̱. B'i̱ kitsú Jesu: ");
INSERT INTO majNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Chjúxiun ndji̱o̱. B'a̱ kitsú Marta̱, na̱ nichja nda̱ xi k'ie̱n: —Ji Chá Nti̱a̱, ja ra̱ ch'on jne̱, a̱t'aha̱ ja tjíhi̱n ñju ni̱stjin nd'a̱i̱ nga k'ien. ");
INSERT INTO majNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","B'i̱ kitsú Jesu: —¿A najmi b'a̱há kuaxihin nga tsa s'e̱jihin an, cha̱i̱ kju̱a̱chánkaha̱ Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","A̱s'a̱i kikjexín jóo̱ ndji̱o̱. Tsasenjinki Jesu nk'a ján ko̱ b'i̱ kitsú: —Na̱'mi, máb'a̱chjíhi nga tímjeñjuní. ");
INSERT INTO majNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Be nga mjeñju tehe̱ntení, tu̱nga tínchjako̱hó ra ngandaha̱ xu̱ta̱ xi tíi̱ncha e̱i̱ tu̱ xi s'e̱jihi̱n ra̱ nga ji kin'e nibání. ");
INSERT INTO majNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nk'ie nga ja kamaha̱ nga b'a̱ kitsú, a̱s'a̱i 'yún kinchja̱: —¡Laza̱ro̱, ti̱tjusje̱i̱ yo̱! ");
INSERT INTO majNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A̱s'a̱i tsitju nda̱ k'ie̱n nga najyun tjí'yúnko̱ ts'íhin ntsja ko̱ sjai, ko̱ a̱nkjín tjí'mako̱ho kj'a̱í najyun. B'a̱ kitsú Jesu nga kinchja̱ko̱ xu̱to̱: —Chjúxihi̱un najyuu̱n. N'e̱ndo̱hóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Máha xu̱ta̱ xi j'aisehe̱ Maria̱ ko̱ kikie ni xi kits'ín Jesu, nkjin maha xi kis'ejihi̱n. ");
INSERT INTO majNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tu̱nga tjíhín xi ngjisehe̱ já fariseo̱ ko̱ kitsúyaha̱ ni xi kits'ín Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","A̱s'a̱i já na̱'mi k'aku̱ ko̱ já fariseo̱ kinchja̱ ñjaha̱ ngayjee̱ já tjíxóo̱ ko̱ b'a̱ kitsúhu̱: —¿Nkú n'e̱é e̱i̱ ni̱? A̱t'aha̱ ja 'yún títs'ín kju̱a̱nkjún ndo̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tsa tu̱ nku k'u̱a̱i̱ntehé ra̱á nga b'a̱ ts'i̱ín, a̱s'a̱i ngayjee̱ xu̱ta̱ tsjénnkihi̱ ndo̱ ko̱ i̱ncha kj'u̱a̱í já Roma̱ nga ts'i̱ínkje ni̱nku̱ná ko̱ xu̱ta̱ nankiná. ");
INSERT INTO majNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","A̱s'a̱i b'i̱ kitsú Caifa xi tjíhi̱n nda̱ na̱'mi títjun nú xu'bo̱: —¿Á najmi mankjihi̱nnu̱u? ");
INSERT INTO majNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿A najmi ma chu̱ba̱yahánu̱u nga tu̱ sahá nda tjín tsa nku nda̱ ku̱a̱yántjaihi ngandaha̱ ngayjee̱ xu̱ta̱, tu̱ xi b'a̱ ts'ín najmi n'e̱kjehe xu̱ta̱ nankiná? ");
INSERT INTO majNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tu̱nga najmi kuenta̱ha̱ ní Caifa kinchja̱ha nga b'a̱ kitsú. Kui xi nda̱ na̱'mi títjun nú xu'bo̱ ko̱ xi nkúhu nku nda̱ profeta̱ kinchja̱ éhe̱n Nti̱a̱ná nga ku̱a̱yá Jesu ngandaha̱ na̱xi̱nantóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ko̱ najmi tu̱ suba ngandaha̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ ku̱a̱yáha Jesu. Ta̱ ku̱a̱yá ní tu̱ xi k'u̱ékúhu ngayjee̱ ntíhi̱ Nti̱a̱ná xi tjímasún. ");
INSERT INTO majNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kui b'a̱ maha, ni̱stjin xu'bo̱ kik'atuts'i̱hi̱n ra̱ já tjíxóo̱ nga y'éndako̱ho xinkjín xi má nga mjehe̱ ts'i̱ínk'ien Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kui nga najmi ta̱ kikjatsú'ba chjihi Jesu a̱jihi̱n xu̱ta̱ judio̱. Ngji t'axín nanki xi 'mi Efrain xi tiña maha̱ a̱nte kixiu̱. Yo̱ y'ejñako̱ já ni'yakuyáha̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nk'ie nga ja tíbichú tiña S'í Pascu̱a̱ xi b'asje xu̱ta̱ judio̱, nkjin ṉkjún xu̱ta̱ i̱ncha ngji nanki Jerusalen tu̱ xi ts'i̱ín jehe yjoho̱ nginku̱n Nti̱a̱ná kintehe̱ ni nga ku̱i̱chú s'íu̱. ");
INSERT INTO majNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yo̱ tsangisjai Jesu ko̱ kingjásjaiyaha̱ xinkjín nga kabincha má ma na̱tsihi̱n ni̱nku̱. B'i̱ ngján b'i̱ kitsúhu̱ xinkjín: —¿Nkú manu̱u? ¿A nibá ndo̱ s'íu̱? ¿A ra̱ najmi nibáhá? ");
INSERT INTO majNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kui chu̱bo̱ ja kitsjá kju̱a̱ já na̱'mi k'aku̱ ko̱ já fariseo̱, tsa tjín xi be má tíjña Jesu tjíhin nga ku̱i̱tsu̱ya tu̱ xi ka̱ma ku̱a̱kj'ánijéhe. ");
INSERT INTO majNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nk'ie nga ndyja sa jun ni̱stjin nga ku̱i̱chú S'í Pascu̱a̱, a̱s'a̱i j'ai Jesu nanki Betani̱a̱, má síjña ni'yaha̱ Laza̱ro̱, nda̱ xi kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yo̱ kis'endaha̱ nku nichine. Marta̱ y'éya nichinee̱ ko̱ Laza̱ro̱ ta̱ y'ejñajihi̱n xu̱ta̱ xi y'entut'áko̱ Jesu yámixo̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","A̱s'a̱i j'aiko̱ Maria̱ nkú ra̱ ma masen litru̱ ntá sinjne̱ xi 'mi nardo̱, xi 'yún nda ko̱ xi 'yún chjí. Kui xi tsaténdzjojnúhu̱ sjai Jesu ko̱ ta̱ kuihi ntsja̱ku̱ kits'ínxijnuko̱ho. I̱xí kitsjehén nta̱ sinjne̱ a̱yoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","A̱s'a̱i b'i̱ kitsú Juda̱ Iscariote̱, xi nda̱ ni'yakuyáha̱ Jesu xi a̱skahan ts'i̱ínkjas'ehe̱n: ");
INSERT INTO majNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Tsa tu̱ sahá kuasatéña ntá sinjne̱i̱ kai. Tsa jan unchan to̱on denari̱o̱ kuach'a, tu̱ xi ka̱ma ku̱i̱si̱nko̱ho xu̱ta̱ x'a̱n. ");
INSERT INTO majNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tu̱nga najmi xu̱ta̱ x'a̱hán kits'ínnkjink'un nga b'a̱ kitsú. Tu̱ nga̱t'aha̱ ní to̱oo̱n b'a̱ kitsúhu, a̱t'aha̱ kui xi f'átjo to̱oo̱n ko̱ bakjá ndyjé. ");
INSERT INTO majNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","B'i̱ kitsú Jesu: —Najmi tu̱ ji b'echj'áíhi̱ ta̱chjúu̱n. A̱t'aha̱ ni̱stjin nga s'e̱yanjia j'átjona ntá sinjne̱i̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Xu̱ta̱ x'a̱n bi tehe̱nte k'úéntujínnu̱u, tu̱nga an najmi tehe̱nte kúáte̱jñajinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nkjin ṉkjún xu̱ta̱ kint'é nga nanki Betani̱a̱ tíjña Jesu ko̱ i̱ncha ngjisehe̱. Tu̱nga najmi tu̱ nkuhú Jesu ngjisehe̱. Ta̱ i̱ncha ngji ní a̱t'aha̱ ta̱ mjehe̱ nga sku̱e̱ Laza̱ro̱ xi kin'ekj'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","A̱s'a̱i kama ñjakú já na̱'mi k'aku̱ ko̱ y'éndako̱ xinkjín xi má nga ko̱ Laza̱ro̱ tjíhin nga n'e̱k'ien. ");
INSERT INTO majNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","A̱t'aha̱ nga̱t'aha̱ Laza̱ro̱ nkjin ṉkjún xu̱ta̱ ts'asje t'axíhi̱n yjoho̱ jóo̱. Tu̱ sahá Jesu kis'ejihi̱n. ");
INSERT INTO majNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ni̱stjin xi ma ndyjuu̱n ngáha nkjin ṉkjún xu̱ta̱ kint'é nga Jesu kj'u̱a̱í nanki Jerusalen, a̱t'aha̱ nkjin maha xi j'aik'asje S'í Pascu̱a̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","A̱s'a̱i i̱ncha jakj'á tjiaha̱ yá xka̱jén ko̱ tsitju nga i̱ncha ngjikj'á ni̱yá. B'i̱ i̱ncha kitsú nga 'yún kinchja̱: —¡Kats'ínk'ankiná Nti̱a̱ná! ¡Nti̱a̱ná nda kats'ínko̱ xi nibáha ngajoho̱, xi Nda̱ Rei̱hi̱ xu̱ta̱ Israel! ");
INSERT INTO majNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nku ntí búrrú kisakúhu̱ Jesu ko̱ y'esún, xi nkú ts'ín tjít'a éhe̱n Nti̱a̱ná: ");
INSERT INTO majNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Xu̱ta̱ Sion, najmi tu̱ binkjun. Cha̱so̱o, ja nibá Nda̱ Rei̱nu̱u nga tjísun nku ntí búrrú. ");
INSERT INTO majNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kui ni xu'bi̱ najmi kamankjihi̱n já ni'yakuyáha̱ nga tjuhun. Tu̱nga a̱skahán ni, nk'ie nga tsakúchji kju̱a̱chánkaha̱, nk'iehé j'áítsjehe̱n já ni'yakuyáha̱ nga b'a̱ ts'ín tjít'a éhe̱n Nti̱a̱ná nga kinchja̱ni̱jmíyaha Jesu ko̱ nga b'a̱ kin'ehe̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Xu̱ta̱ xi tíi̱nchako̱ Jesu nk'ie nga kinchja̱ha̱ Laza̱ro̱ a̱ya tsjóo̱ nga kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱, kui xi i̱ncha kitsúya ni xi kikie. ");
INSERT INTO majNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kui kju̱a̱ha nga nkjin ṉkjún xu̱ta̱ tsitjuhu nga ngjikj'á ni̱yáha Jesu, a̱t'aha̱ kint'é kju̱a̱nkjún xi kits'ín. ");
INSERT INTO majNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","A̱s'a̱i kinchja̱ni̱jmíyaha já fariseo̱ niu̱. B'i̱ ngján b'i̱ kitsúhu̱ xinkjín: —¿A tíyo? Najmi chumi nihi xi ka̱ma n'e̱é. Cha̱se̱ maru̱u. Ngayjee̱ xu̱ta̱ títsjennkíhi̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ta tje̱njihi̱n xu̱ta̱ k'u̱a̱ xu̱ta̱ xi nchja̱ griego̱ xi ta̱ i̱ncha j'ai nanki Jerusalen nga j'ai ts'íntsjoho̱ Nti̱a̱ná a̱jihi̱n s'íu̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kui xi j'aisehe̱ Felipe̱ xi nda̱ Betsaida̱, nanki xi tíjñajihi̱n a̱nte Galilea̱, ko̱ b'a̱ kitsúhu̱: —Ji nda̱ nti̱a̱, mjeni̱ nga cha̱i̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","A̱s'a̱i Felipe̱ ngji tsúyaha̱ Andre ko̱ nga joo̱ ngji tsúya ngáha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A̱s'a̱i b'i̱ kitsú Jesu: —Ja kuichu chu̱ba̱ nga sa̱kúchji kju̱a̱chánkaha̱ Ntíhi̱ Nda̱x'i̱u̱n. ");
INSERT INTO majNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kju̱axi̱ ni xi tíxinnu̱u. Tsa najmi ku̱i̱jne̱ t'anankiu̱ nku xujmá tuni̱ñu̱ ko̱ ku̱a̱yá, tu̱ nku s'e̱jña subahá. Tu̱nga tsa ku̱a̱yá, nk'iehé nga tsjá cha̱n xi 'yún tse. ");
INSERT INTO majNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Xi tjoho̱ yjoho̱, kui xi tu̱ sahá ndyja̱. Tu̱nga xi najmi tjoho̱ yjoho̱ a̱sunntei̱, kui xi tu̱ sahá kj'u̱átjo ko̱ k'úéjña tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tsa tjín xi títs'ínkjáínna nga an xi ka̱ma Nda̱ Nti̱a̱ha̱, katsjennkína. Má kúáte̱jña, ta̱ yo̱ k'úéjña xi ts'i̱ínkjáínna, ko̱ Nti̱a̱ Na̱'miu̱ k'u̱a̱sjenk'aha̱ xu̱ta̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’'Yún un tíbehe̱ ani̱ma̱na̱ nd'a̱i̱. ¿Nkú xíán? ¿A b'i̱ xíán: Ji Na̱'mi, n'e̱kj'a t'axínní kju̱a̱ni̱ma̱ xu'bi̱ nd'a̱i̱? Tu̱nga kuihí xá jái̱hina. ");
INSERT INTO majNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tu̱ sahá ta̱kúchji kju̱a̱chánkahi̱, Na̱'mi. Nk'ie nga b'a̱ kitsú Jesu, a̱s'a̱i b'i̱ kitsú nku nta̱ xi nibaha nk'a ján: —Ja tsakuchjá kju̱a̱chánkana̱ ko̱ ta̱ kuakuchjíhí ngáhana. ");
INSERT INTO majNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nk'ie nga kint'é nto̱ xu̱ta̱ xi tíi̱ncha yo̱, tjín xi b'a̱ kitsú: —Nku ch'o̱n kjuaneya. Ko̱ k'u̱a̱ xi b'a̱ kitsú: —Nku ntítsje kuanchja̱ko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","A̱s'a̱i b'a̱ kitsú Jesu: —Najmi ngandana̱ kuanu'yáha nto̱. Ngandanu̱ ní b'a̱ kamaha. ");
INSERT INTO majNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nd'a̱i̱ n'e̱ko̱kju̱a̱ a̱sunntei̱ ko̱ nd'a̱i̱ ku̱i̱ch'onsje na̱tsin ján xi tíbatéxumaha̱ a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ko̱ nga chjúsíntje̱n nk'ana t'anankiu̱, ts'ian nga ni̱bak'únna ngayjee̱ xu̱ta̱ xi tjín a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","B'a̱ kitsú Jesu nga kitsúya xi nkú ts'ín ku̱a̱yáha. ");
INSERT INTO majNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A̱s'a̱i b'a̱ kitsú xu̱ta̱: —Tu̱nga yaníi̱ ni xi tjít'a kju̱a̱téxumoo̱, nga xi ts'i̱ín nibá Nti̱a̱ná ngajoho̱ k'úéjña sín. ¿Nkú ts'ín b'a̱ tíbixíhinni nga tjíhin nga chjúsíntje̱n nk'aha Ntíhi̱ Nda̱x'i̱u̱n? ¿Yá xi Ntíhi̱ Nda̱x'i̱n xi tíbixín? ");
INSERT INTO majNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","B'i̱ kitsú Jesu: —An nd'íu̱. Tu̱ chuba ni̱stjihín tíi̱jñajin sanu̱u. Ti̱nimo nga tíjña sanu̱u nd'íu̱ tu̱ xi najmi ka̱ma jyunt'aihinnu. A̱t'aha̱ xi tsú'ba má jyuu̱n najmi be má fi. ");
INSERT INTO majNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nk'ie nga tíi̱jñajinnu̱u xi nkúhu nd'í, n'e̱ s'ejinnú tu̱ xi ku̱i̱nimahanu má ndzjee̱n. B'a̱ kitsú Jesu ko̱ a̱s'a̱i ngji t'axíhi̱n xu̱to̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ndaha tsa nkjin ṉkjún kju̱a̱nkjún xi kits'ín Jesu nginku̱n xu̱ta̱, tu̱nga najmi kis'ejihín ra̱ yáha kui. ");
INSERT INTO majNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","B'a̱ kama tu̱ xi tsitjusuhun én xi kitsú nda̱ profeta̱ Isaia̱ má nga b'a̱ ts'ín y'ét'a: Ji Nti̱a̱, ¿yá xi kis'ejihi̱n én xi kichubai̱? ¿Yá xi kis'ejña chjihi̱ nga'yúhu̱n Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kui kju̱a̱ha nga najmi kama kis'ejihi̱n ra̱ xu̱ta̱, a̱t'aha̱ b'i̱ ta̱ ts'ín y'ét'a ya Isaia̱ éhe̱n Nti̱a̱ná: ");
INSERT INTO majNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nti̱a̱ná y'échja tunku̱n xu̱ta̱ xu'bi̱ ko̱ kits'ín ndjá ani̱ma̱ha̱, tu̱ xi najmi sku̱e̱he ko̱ tu̱ xi najmi ka̱mankjihi̱n ra̱, tsa ts'i̱ínk'óntjaiya ani̱ma̱ha̱ xi má nga ts'innkíhi̱ xu̱ta̱ xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","B'a̱ kitsú Isaia̱ a̱t'aha̱ kikie kju̱a̱chánkaha̱ Jesu ko̱ kinchja̱ni̱jmíyaha. ");
INSERT INTO majNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ko̱ ta̱ nkjin maha já tjíxá xi kis'ejihi̱n Jesu, tu̱nga najmi kits'ínkiehé yjoho̱ a̱t'aha̱ tsankjún já fariseo̱ ko̱ najmi mjehe̱ nga ku̱i̱ch'onsje a̱jihi̱n xu̱ta̱ sinagoga̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","B'a̱ kits'ín a̱t'aha̱ 'yún kama tsjo saha̱ nga s'e̱he̱ kju̱a̱chánka a̱jihi̱n xu̱ta̱ nga nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","'Yún kinchja̱ Jesu nga b'i̱ kitsú: —Xi s'ejihi̱n an, najmi tu̱ nku an tís'ejihi̱n. Ta̱ tís'ejihi̱n xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Xi tíbena, tíbe xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","An nd'í xi j'ai ts'ín ndzjehe̱n xu̱ta̱ a̱sunntei̱, tu̱ xi ngayjee̱ xi s'e̱jihi̱n ra̱ an najmi k'úéntuhu má jyuu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","’Tsa tjín xi ku̱i̱nt'é én xi tínchja tu̱nga najmi ts'i̱íntjusuhún, najmi an kuasehe̱ má ni xi nda ko̱ má ni xi najmi nda xi kits'ín xu̱ta̱ xu'bo̱. A̱t'aha̱ najmi kui xóo̱ jái̱hina. Jái̱ ts'ink'anki níná xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Xi ts'i̱ín t'axínna ko̱ najmi ts'i̱ínkjáíhi̱n én xi tínchja, tíjña xi ku̱a̱se̱he̱ má ni xi nda ko̱ má ni xi najmi nda xi kits'ín. Én xi tínchja, kui xi k'u̱éjñanehe̱ ni xi kanéhe̱ xu̱ta̱ xu'bo̱ ni̱stjin xi fekuu̱. ");
INSERT INTO majNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","’A̱t'aha̱ najmi kuenta̱na̱ tínchjahana. Kuenta̱ha̱ ní Na̱'mi xi kits'ín nibána tínchjahana. Kui xi kitsjána kju̱a̱ má nihi xi tjíhin nga kuinchja ko̱ kuakuyá. ");
INSERT INTO majNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ko̱ be nga kju̱a̱téxumaha̱ ts'i̱ínk'íéntu tík'un síhi̱n xu̱ta̱. Kui kju̱a̱ha, xi nkú kitsúhuna Nti̱a̱ Na̱'miu̱, b'a̱ ts'ín tínchja. ");
INSERT INTO majNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Chubahá ndyjaha̱ ni̱stjihi̱n S'í Pascu̱a̱ ko̱ be Jesu nga ja tíbichú chu̱ba̱ nga k'u̱éjña a̱sunntee̱ nga ngju̱a̱i̱ ngáha má tíjña Nti̱a̱ Na̱'miu̱. Tehe̱nte kits'íntjo xu̱ta̱ xi ts'e̱ xi tjíntu a̱sunntee̱ ko̱ ngayjehe k'un kits'íntjo. ");
INSERT INTO majNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kikjineko̱ já ni'yakuyáha̱ nichinehe̱ s'íu̱, ko̱ kui chu̱bo̱ nda̱nindoo̱ ja kab'éjñajin ani̱ma̱ha̱ Juda̱ Iscariote̱ ntíhi̱ Simon nga ts'i̱ínkjas'en Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Be Jesu nga Nti̱a̱ Na̱'miu̱ kits'ínkjas'en a̱ya ntsja ngayjee̱ ni xi tjín. Be nga má tíjña Nti̱a̱ná nibaha ko̱ nga yo̱ ngju̱a̱i̱se ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kui b'a̱ maha, nk'ie nga tjíntut'áha yámixo̱, a̱s'a̱i tsisintje̱n Jesu, ts'asje najyun ndju xi yja ko̱ jakj'á nku najyunxú nga y'ékjá ndayáha̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jakj'á ntánijua, tsanéjnu sjai já ni'yakuyáha̱ ko̱ kits'ínxijnuko̱ho najyunxú xi y'ékjá ndayáha̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nk'ie nga tsichuk'úhu̱n Simon Pedro̱, b'a̱ kitsú ndo̱: —Ji Nda̱ Nti̱a̱, ¿nkú ts'ín ji ku̱a̱nejnuhuni tsu̱ká? ");
INSERT INTO majNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","B'i̱ kitsú Jesu: —Nd'a̱i̱ najmi yai ni xi títs'ian tu̱nga a̱skahán ni ka̱mankjihin. ");
INSERT INTO majNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","B'a̱há ta̱ kitsú ngáha Pedro̱: —Ndaha tsa mí yjehe najmi ku̱a̱nejnui tsu̱ká. B'i̱ kitsú Jesu: —Tsa najmi kuanejná tsu̱kui, najmi ta̱ xu̱ta̱ xi ts'a̱n ka̱mahani. ");
INSERT INTO majNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","A̱s'a̱i b'a̱ kitsú Simon Pedro̱: —Ji Nda̱ Nti̱a̱, najmi tu̱ suba tsu̱ká xi ta̱nejnui ma. Ta̱ ta̱nejnui ntsa̱ ko̱ nintaká. ");
INSERT INTO majNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","B'i̱ kitsú Jesu: —Xi a̱s'a̱i kabinguyahá tu̱ tsu̱ku̱hú machjéhe̱n nga kfe̱jnú, a̱t'aha̱ je yje. Jun bi ja jo, tu̱nga najmi ngatentenú. ");
INSERT INTO majNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","A̱t'aha̱ be Jesu yá xi ts'i̱ínkjas'ehe̱n, kui nga: “Najmi ngatentoo̱ xi jo”, kitsúhu. ");
INSERT INTO majNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nk'ie nga ja kamaha̱ nga tsanéjnu sjai já ni'yakuyáha̱, a̱s'a̱i kingja ngáha najyun ndjuhu̱, y'ejñat'a yámixo̱ ko̱ b'i̱ kitsú: —¿A mankjinnu̱u ni xi kuats'inko̱nu̱u? ");
INSERT INTO majNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jun xi 'minú Nda̱ Maestru̱ ko̱ Nda̱ Nti̱a̱. Ko̱ tjínnu̱u kixi̱ nga b'a̱ bixínnú, a̱t'aha̱ b'a̱ tjín kjáíhin. ");
INSERT INTO majNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kui b'a̱ maha, tsa an xi kuakanejnúhuna tsu̱ku, nga an xi Nda̱ Maestru̱nu̱u ko̱ Nda̱ Nti̱a̱nu̱u, kui nga ko̱ jun tjíhin nga ku̱a̱nejnuhunu tsu̱ku̱ xinki̱u. ");
INSERT INTO majNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ja kuak'iejñá chu̱ba̱yanu̱u tu̱ xi b'a̱ n'e̱henu xi nkú kuats'innu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kju̱axi̱ ni xi tíxinnu̱u. Ndaha nku nda̱ musu̱ najmi 'yún nk'a tje̱n nga nda̱ nti̱a̱ha̱. Ko̱ nku nda̱ xi s'exá najmi 'yún nk'a tje̱n nga xi b'éxáha̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tsa tímankjinnu̱u ni xi tíxian ko̱ ta̱ n'e̱tjusun, á b'a̱ nda tjíhin ts'a̱jun. ");
INSERT INTO majNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Najmi nga tentoo̱ b'a̱ tíxinnu̱u. An be yá xi j'ajián. Tu̱nga tjíhín ni nga ku̱i̱tjusun éhe̱n Nti̱a̱ná xi b'a̱ ts'ín tjít'a: “Xi kjineko̱na ni̱ñu̱, kui xi ja kama nda̱ kontra̱na̱.” ");
INSERT INTO majNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nd'a̱i̱ b'a̱ tíxinnu̱u kintehe̱ ni nga ku̱i̱tjusun ni xi tjíhin nga ka̱ma, tu̱ xi nk'ie nga b'a̱ ka̱moo̱ s'e̱jihi̱nnu̱u nga an xi tu̱ b'a̱ ts'ín tíi̱jñaná. ");
INSERT INTO majNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kju̱axi̱ ni xi tíxinnu̱u. Xi ts'i̱ínkjáíhi̱n xu̱ta̱ xi ts'inkjíá, kui xi an títs'ínkjáínna. Ko̱ xi ts'i̱ínkjáínna, kui xi títs'ínkjáíhi̱n xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","A̱s'a̱i xí ts'atséhé ani̱ma̱ha̱ Jesu ko̱ b'i̱ kitsú: —Kju̱axi̱ ni xi tíxinnu̱u. Tíjñajinnu̱u nku xi ts'i̱ínkjas'enna. ");
INSERT INTO majNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A̱s'a̱i b'i̱ ngján i̱ncha tsase'a xinkjín já ni'yakuyóo̱, a̱t'aha̱ najmi be yá xi títsu Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yo̱ tíjñat'a tiñaha̱ Jesu nda̱ ni'yakuyá xi 'yún tjoho̱ nga tíjñat'ako̱ho̱ yámixo̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kui nga jyukj'i Simon Pedro̱ kingjásjaiya se̱he̱n ra̱ nda̱ ni'yakuyá xu'bo̱ nga ngju̱ásjaiyaha̱ Jesu yá xi títsu. ");
INSERT INTO majNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A̱s'a̱i nda̱ ni'yakuyóo̱ 'yún ngjik'ún saha̱ Jesu ko̱ b'i̱ kitsú: —Ji Nda̱ Nti̱a̱, ¿yá xi b'a̱ ts'i̱íu̱n? ");
INSERT INTO majNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","B'i̱ kitsú Jesu: —Xi ts'ink'anchi̱hi̱ ni̱nku̱a̱n ko̱ tsjaha̱, kui xi b'a̱ ts'i̱íu̱n. A̱s'a̱i kits'ínk'anchi̱ ni̱nku̱o̱n ko̱ Juda̱ Iscariote̱ kitsjáha̱, kui xi ntíhi̱ Simon. ");
INSERT INTO majNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nk'ie nga kik'a̱i̱hi̱ Juda̱ ni̱nku̱o̱n, jas'enjihi̱n nda̱nindoo̱. A̱s'a̱i b'i̱ kitsúhu̱ Jesu ndo̱: —Ki̱tsa̱ n'e̱i̱ ni xi n'e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tu̱nga ndahá nku xi tjíntut'á yámixo̱ najmi kamankjihi̱n á b'a̱ kitsúhu̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tjín xi kits'ínnkjink'un nga b'a̱ kitsú nga tjíhin nga k'u̱a̱tse Juda̱ ni xi machjén s'íu̱ ko̱ a ra̱ nga tsjáha̱ to̱on xu̱ta̱ x'a̱n, a̱t'aha̱ Juda̱ f'átjo to̱oo̱n. ");
INSERT INTO majNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nk'ie nga kik'a̱i̱hi̱ ni̱nku̱o̱n Juda̱, tje̱n'yún tsitjusjehé na̱tsiu̱n. Ja jyun kui chu̱bo̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nk'ie nga ja ngji Juda̱, b'a̱ kitsú Jesu: —Nd'a̱i̱ sa̱kúchji kju̱a̱chánkaha̱ Ntíhi̱ Nda̱x'i̱u̱n, ko̱ ni xi ts'i̱ín Ntíhi̱ Nda̱x'i̱u̱n ku̱a̱kúchji kju̱a̱chánkaha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ko̱ tsa Ntíhi̱ Nda̱x'i̱u̱n ku̱a̱kúchji kju̱a̱chánkaha̱ Nti̱a̱ná, b'a̱ ta̱ ts'ín Nti̱a̱ná ku̱a̱kúchji kju̱a̱chánkaha̱ Ntíu̱. Ja ma ma b'a̱ ka̱moo̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Jun ntína̱, tu̱ kutjuhú tíi̱jñajin sanu̱u. Ku̱i̱nchísjainú tu̱nga má nga kfíán najmi ka̱ma kuankíún. B'a̱ ta̱ tíxinnu̱u nd'a̱i̱ xi nkú nga ta̱ kixihi̱n xu̱ta̱ xingisoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","’Tsjanu̱u nku kju̱a̱téxuma tse̱tse̱: N'e̱tjó xinki̱u. Xi nkú nga ts'ín tjona jun, b'a̱ ta̱ ts'ín n'e̱tjó xinki̱u. ");
INSERT INTO majNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","B'a̱ ts'ín sku̱e̱he ngayjee̱ xu̱ta̱ nga jun xi já ni'yakuyána̱, tsa n'e̱tjó xinki̱u. ");
INSERT INTO majNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","B'a̱ kitsú Simon Pedro̱: —Ji Nda̱ Nti̱a̱, ¿má xi tje̱hen k'úín? B'i̱ kitsú Jesu: —Najmi ka̱ma tsjénnkiní nd'a̱i̱ má nga kfíán, tu̱nga a̱skahán ni tsjénnkiní. ");
INSERT INTO majNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","B'a̱há ta̱ kitsú ngáha Pedro̱: —Ji Nda̱ Nti̱a̱, ¿á najmi ka̱ma tsjénnkihi ra nd'a̱i̱? Tjínkuhu̱ k'an nga ku̱a̱yántjaihi ra. ");
INSERT INTO majNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","B'i̱ kitsú Jesu: —¿A tjínkuhu̱ k'uin nga ku̱a̱yántjaihiní? Kju̱axi̱ ni xi tíxihin. Kintehe̱ ni nga kji̱ntá xa̱nto̱ b'a̱ ku̱i̱xín nga najmi yaní jan ni̱yá tjíhin. ");
INSERT INTO majNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","B'i̱ ta̱ kitsú ya Jesu: —Najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u. N'e̱ s'ejiun Nti̱a̱ná ko̱ kas'ejinnu̱u an. ");
INSERT INTO majNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ni'yaha̱ Na̱'mina̱ tjín ṉkjún a̱nte. Tsa najmi kju̱axi̱, ja ra̱ nd'a̱i̱ kixinyaha̱nu̱u kai. Kfín k'uendánu̱u a̱nte. ");
INSERT INTO majNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tsa kfín k'uendánu̱u a̱nte, a̱s'a̱i kjúái̱kj'a ngáha̱nu̱u tu̱ xi ta̱ yo̱ ku̱i̱ntsu̱ba̱hanu má nga kúáte̱jña. ");
INSERT INTO majNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yo ni̱yá xi fi má nga kfíán. ");
INSERT INTO majNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","B'a̱ kitsú Toma: —Ji Nda̱ Nti̱a̱, najmi yai̱ má k'úín. ¿Nkú n'e̱ cha̱ha̱ni̱ ni̱yóo̱? ");
INSERT INTO majNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","B'i̱ kitsú Jesu: —An ni̱yá xi fi má tíjña Nti̱a̱ Na̱'miu̱, an bakuyá én xi na̱xu̱ ko̱ an tsja kju̱a̱tík'un. Ndaha nku najmi ku̱i̱chúsehe̱ Nti̱a̱ Na̱'miu̱ tsa najmi an. ");
INSERT INTO majNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tsa yanú, ta̱ cha̱ ru̱u Na̱'mina̱. Ko̱ nd'a̱i̱ tích'atuts'i̱hi̱n ru̱u nga tíyo ko̱ tunkun tíyako̱honu. ");
INSERT INTO majNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","B'a̱ kitsú Felipe̱: —Ji Nda̱ Nti̱a̱, ta̱kúchjini̱ Nti̱a̱ Na̱'miu̱ ko̱ s'e̱nkuni̱. ");
INSERT INTO majNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","B'i̱ kitsú Jesu: —Ji Felipe̱, ja nd'a̱i tíi̱jñajihi̱nnu̱u. ¿A tu̱ yje najmi kje̱hé yaní? Xi tíbena ta̱ tíbe Nti̱a̱ Na̱'miu̱. ¿Á: “ta̱kúchjini̱ Nti̱a̱ Na̱'miu̱” tíbixíhinni? ");
INSERT INTO majNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A najmi s'ejihín ri nga an xi tíi̱jñajihi̱n Nti̱a̱ Na̱'miu̱ ko̱ Nti̱a̱ Na̱'miu̱ tíjñajinna? Én xi tínchjako̱nu̱u najmi kuenta̱na̱ tínchjahana. Na̱'mi xi tíjñajinna, kui xi títs'ín ni xi ts'e̱. ");
INSERT INTO majNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","N'e̱ s'ejiun nga an tíi̱jñajihi̱n Nti̱a̱ Na̱'miu̱ ko̱ nga kui tíjñajinna. Tsa najmi s'ejinnu̱u énna̱, ndaha tsa tu̱ ni xi kits'ian n'e̱ s'ejiun. ");
INSERT INTO majNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","’Kju̱axi̱ ni xi tíxinnu̱u. Xi s'e̱jihi̱n an ta̱ kui nihi xi ts'i̱ín xi nkúhu xi títs'ian. Ko̱ 'yún chánka sa ni xi ts'i̱ín xu̱ta̱ xu'bo̱, a̱t'aha̱ an tífia má tíjña Nti̱a̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ngayjee̱ ni xi ku̱i̱nchíhu̱u Na̱'miu̱ ngajona̱, tsjanu̱u. B'a̱ ts'ín an xi Ntíu̱ kuakuchjíhina kju̱a̱chánkaha̱ Nti̱a̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ts'ian ni xi ku̱i̱nchúhu̱u ngajona̱. ");
INSERT INTO majNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tsa tjonu̱u an, n'e̱tjusun kju̱a̱téxumana̱. ");
INSERT INTO majNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kuankihi̱ Nti̱a̱ Na̱'miu̱, ko̱ tsjánu̱u kj'a̱í xi ta̱ ku̱a̱si̱nko̱nu̱u ko̱ xi k'úéjñajin sínnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kui xi Espiri̱tu̱ xi ku̱a̱kúchji ni xi na̱xu̱. Xu̱ta̱ xi najmi be Nti̱a̱ná najmi ka̱ma ts'i̱ínkjáíhi̱n, a̱t'aha̱ najmi ma chjihi̱ ko̱ najmi be yáha. Tu̱nga máha jun, ja yo yáha, a̱t'aha̱ kui xi tíjñajinnu̱u ko̱ k'úéjñajinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Najmi k'uentú masennu̱u. Kjúái̱se ngáha̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sa kutju najmi ta̱ sku̱e̱hena xu̱ta̱, tu̱nga máha jun, cha̱nú. A̱t'aha̱ tíi̱jña tík'an, kui nga ta̱ ku̱i̱ntsu̱ba̱ tík'uhunnu. ");
INSERT INTO majNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nk'ie nga b'a̱ ka̱moo̱, cho̱o nga an tíi̱jñajihi̱n Na̱'mina̱ ko̱ jun tintsu̱ba̱jinnú ko̱ an tíi̱jñajinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Xi kj'u̱átjo kju̱a̱téxumana̱ ko̱ ts'i̱íntjusun, kui xi tjoho̱ an. Ko̱ xi ts'i̱íntjona, Na̱'mina̱ ta̱ ts'i̱íntjoho̱ ko̱ an ts'intjá ko̱ kuakuchjíhi̱ yjona̱. ");
INSERT INTO majNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A̱s'a̱i kinchja̱ Juda̱, tu̱nga najmi Juda̱ Iscariote̱hé: —Ji Nda̱ Nti̱a̱, ¿nkú tjíhi̱n ra̱ nga tu̱ ji̱n ku̱a̱kúchjihíni̱ yjohi̱ ko̱ nga najmi ku̱a̱kúchjihi̱ yjohi̱ xu̱ta̱ xi k'oo̱? ");
INSERT INTO majNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","B'i̱ kitsú Jesu: —Xi tjoho̱ an, kui xi ts'i̱íntjusun énna̱. Na̱'mina̱ ts'i̱íntjoho̱ xu̱ta̱ xu'bo̱, ko̱ Na̱'mina̱ ko̱ an kjúái̱sei̱hi̱ nga ku̱i̱ntsu̱ba̱ko̱ tehe̱ntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tu̱nga xi najmi tjoho̱ an, najmi ts'i̱íntjusun énna̱. Én xi tínu'yó, najmi an ts'a̱n. Ts'e̱ Na̱'mi xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’B'i̱ tíxinnu̱u nk'ie nga tíi̱jñajin sanu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tu̱nga Nti̱a̱ Na̱'miu̱ ts'i̱ín nibá Espiri̱tu̱ Santo̱ ngajona̱. Kui xi ku̱a̱si̱nko̱nu̱u. Ku̱a̱kúya yjenu̱u ko̱ ts'i̱ínkj'áítsjen yjenu̱u ni xi kixinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Tíb'ejñánu̱u kju̱a̱jyu. Kju̱a̱jyuna̱ títsjanu̱u. Najmi b'a̱ ts'ín tsja xi nkú ts'ín tsjá a̱sunntei̱. Najmi tu̱ fanta̱ha̱ ru̱u yjonu̱u ko̱ najmi tu̱ binkjun. ");
INSERT INTO majNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ja kuanu'yó nga b'a̱ kuaxinnu̱u nga kfíán ko̱ kjúái̱se ngáha̱nu̱u. Tsa kju̱axi̱ nga tjonu̱u an, ta̱ tsjo ka̱manu̱u nga kfíán má tíjña Nti̱a̱ Na̱'miu̱, a̱t'aha̱ 'yún chánka sa Nti̱a̱ Na̱'miu̱ nga an. ");
INSERT INTO majNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nd'a̱i̱ b'a̱ tíxinnu̱u kintehe̱ ni nga ku̱i̱tjusun ni xi tjíhin nga ka̱ma tu̱ xi s'e̱jihi̱nnu̱u nk'ie nga b'a̱ ka̱moo̱. ");
INSERT INTO majNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Najmi ta̱ tse kuinchjako̱ saha̱nu̱u, a̱t'aha̱ kj'u̱a̱í xi tíbatéxumaha̱ a̱sunntei̱. Najmi tjíhi̱n nga'yún tsa kui xi ts'i̱ín ngana̱na. ");
INSERT INTO majNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tu̱nga tjíhín ni nga b'a̱ ka̱ma, tu̱ xi ka̱mankjihi̱n ra̱ a̱sunntei̱ nga tjona Nti̱a̱ Na̱'miu̱ ko̱ nga títs'intjusan xi nkú kitsúna. Ti̱síntjo̱on ko̱ tjián. ");
INSERT INTO majNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","21 ’An tuts'in yá tuntsja̱jé xi nda, ko̱ Na̱'mina̱ xi ts'e̱ yá tuntsja̱jée̱. ");
INSERT INTO majNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ngayjee̱ tjia xi tjínna xi najmi tsjá tu, batet'a. Ko̱ ngayjee̱ tjia xi tsjá tu, ts'ín chuhu̱n tu̱ xi 'yún ngju̱a̱ saha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nga̱t'a ts'a̱jun, én xi tsakuyánu̱u kits'ínchjén Na̱'mina̱ nga kits'ín chunnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ti̱ntsu̱ba̱jinnú ko̱ an kúáte̱jñajinnu̱u. Nku tjia najmi ma tsjá suba tu tsa najmi tjít'a yáha̱. B'a̱ ta̱ ts'ín najmi k'u̱o tu tsa najmi ku̱i̱ntsu̱ba̱jinnú. ");
INSERT INTO majNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’An tuts'in yá tuntsja̱jée̱ ko̱ jun tjiaha̱. Xi tíjñajinna ko̱ an tíi̱jñajihi̱n, kui xi 'yún tsjá tu. A̱t'aha̱ tsa najmi tjíán, najmi chumi nihi xi ka̱ma n'o̱o. ");
INSERT INTO majNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Xi najmi k'úéjñajinna ngju̱a̱i̱ya na̱tsin ján xi nkúhu tjia xi tit'áha̱ yá tuntsja̱jée̱. Yo̱ xi̱ ko̱ s'e̱ntukú ko̱ n'e̱kj'ajin a̱jin nd'íu̱ nga ku̱i̱ti̱. ");
INSERT INTO majNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Tsa ku̱i̱ntsu̱ba̱jinnú ko̱ tsa énna̱ k'úéjñajinnu̱u, ti̱nchíú tu̱ mí ni xi mjehénu̱u ko̱ k'u̱a̱i̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kui ni xu'bi̱ xi ku̱a̱kúchji kju̱a̱chánkaha̱ Na̱'mina̱, nga 'yún k'u̱o tu ko̱ nga xu̱ta̱ ni'yakuyána̱ ka̱mo. ");
INSERT INTO majNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Xi nkú ts'ín tjoho̱ an Nti̱a̱ Na̱'miu̱, b'a̱ ta̱ ts'ín tjona jun. Ti̱ntsu̱ba̱jin sahanu kju̱a̱tjona̱. ");
INSERT INTO majNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tsa n'e̱tjusun kju̱a̱téxumana̱, tu̱ nkú ku̱i̱tsu̱ba̱jinnú kju̱a̱tjona̱, xi nkú ts'ín títs'intjusan kju̱a̱téxumaha̱ Na̱'mina̱ ko̱ tu̱ nkú tíi̱jñajinná kju̱a̱tjoho̱. ");
INSERT INTO majNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’B'a̱ tíxinnu̱u tu̱ xi tsjo k'úéhe̱nu̱u xi nkú ts'ín tsjo tjínna. Nk'ie nga b'a̱ n'o̱o, b'i̱hí ts'ín nga tsjo k'úénu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kui kju̱a̱téxumana̱ xu'bi̱: B'i̱ ngján n'e̱tjó xinki̱u xi nkú ts'ín tjona jun. ");
INSERT INTO majNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kui xu'bi̱ kju̱a̱tjo xi 'yún chánka xi tíjña, tsa tjín xi ku̱a̱yántjaihi xinkjín. ");
INSERT INTO majNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jun xi xu̱ta̱ xinkjíán tsa n'e̱tjusun kju̱a̱téxuma xi títsjanu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Najmi ta̱ já musu̱ tíxihi̱nnu̱u, a̱t'aha̱ já musu̱ najmi be ni xi ts'ín nda̱ nti̱a̱ha̱. Tu̱nga xu̱ta̱ xinkjíáhán tíxinnu̱u, a̱t'aha̱ tíb'ejñá chjinu̱u ngayjee̱ ni xi kitsúna Na̱'mina̱. ");
INSERT INTO majNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","’Najmi jun xi kichj'ajinnú. An ní xi j'ajínnu̱u ko̱ kitsja xánu̱u nga kuankíún ko̱ k'u̱o tu. 'Yún tse ku̱i̱chúkju̱a̱ha̱ tunu̱u. Kui kju̱a̱ha nga tsjáha̱nu̱u Nti̱a̱ Na̱'miu̱ tu̱ mí nihí ni xi ku̱i̱nchíhu̱u ngajona̱. ");
INSERT INTO majNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kui kju̱a̱téxumana̱ xu'bi̱: B'i̱ ngján n'e̱tjó xinki̱u. ");
INSERT INTO majNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tsa ts'i̱ín unkienu̱u xu̱ta̱ a̱sunntee̱, n'e̱kj'áítsjon nga an tjun kits'ín unkiena. ");
INSERT INTO majNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tsa a̱sunntei̱ ts'e̱nu̱u, ts'i̱íntjonu̱u xu̱ta̱ a̱sunntei̱ xi nkú ts'ín tjoho̱ xinkjín. Tu̱nga najmi a̱sunntei̱hí ts'e̱nu̱u, a̱t'aha̱ an j'ajínnu̱u a̱jihi̱n xu̱ta̱ xi tjín a̱sunntei̱. Kui kju̱a̱ha nga ts'i̱ín unkiehe̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","’T'ejin tak'un én xi kuaxinnu̱u, nga nku nda̱ musu̱ najmi 'yún nk'a tje̱n nga nda̱ nti̱a̱ha̱. Tsa tje̱nnki unkiena xu̱ta̱, ko̱ ta̱ jun tsjénnki unkienu̱u. Ko̱ tsa títs'íntjusun énna̱, ta̱ ts'i̱íntjusun énnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngayjee̱ ni xu'bi̱ ts'i̱ínko̱nu̱u xu̱ta̱ tu̱ nga̱t'ana̱, a̱t'aha̱ najmi i̱ncha be xi kits'ín nibána. ");
INSERT INTO majNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tsa najmi jái̱ nchjaka̱ xu̱ta̱ xu'bo̱, najmi s'e̱he̱ ra̱ jé. Tu̱nga nd'a̱i̱ najmi ta̱ tjín nkú ts'ín ku̱a̱si̱nko̱ho yjoho̱ nga̱t'aha̱ ngatitsun xi tíi̱ncha ts'ín. ");
INSERT INTO majNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Xi unkiena ta̱ unkie Na̱'mina̱. ");
INSERT INTO majNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ni xi ndaha nku najmi kje̱e ch'aha ts'ín kits'ian a̱jihi̱n xu̱ta̱ xu'bo̱. Tsa najmi b'a̱ kits'ian, najmi s'e̱he̱ ra̱ jé. Tu̱nga ndaha tsa i̱ncha kikie ni xi kits'ian, tu̱ nkú i̱ncha kits'ín unkiehéni̱ Na̱'mina̱ ko̱ an. ");
INSERT INTO majNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","B'a̱ kama tu̱ xi tsitjusuhun ni xi tjít'a xu̱ju̱n kju̱a̱téxumaha̱ xu̱ta̱ xu'bo̱ má nga b'a̱ títsu: “Chu̱ba̱ i̱ncha kits'ín unkiehéna.” ");
INSERT INTO majNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Tu̱nga kj'u̱a̱íhí xi ku̱a̱si̱nko̱nu̱u, xi ts'in nibásenu̱u nk'ie nga tíi̱jñaka̱ Na̱'miu̱. Má tíjña Na̱'miu̱ ni̱baha. Kui xi Espiri̱tu̱ Santo̱ xi ku̱a̱kúchji ni xi na̱xu̱. Kui ku̱i̱nchja̱ni̱jmíyahana. ");
INSERT INTO majNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jun bi ta̱ chu̱bani̱jmíyahanú, a̱t'aha̱ santaha nkúhu nga tuts'ihi̱n ni tintsu̱ba̱ko̱nú. ");
INSERT INTO majNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Tíxinyanu̱u ni xu'bi̱ tu̱ xi najmi n'e̱ndyjajihi̱n ru̱u yjonu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A̱t'aha̱ ku̱i̱ch'onsjenu̱u a̱jihi̱n xu̱ta̱ sinagoga̱. Ku̱i̱chú chu̱ba̱ nk'ie nga tu̱ yáhá ni xi ts'i̱ínk'iennu̱u, b'a̱ ka̱maha̱ nk'ie nga sa̱síhi̱n Nti̱a̱ná nk'ie nga b'a̱ ts'i̱ínnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","B'a̱ ts'i̱ínnu̱u xu̱ta̱ a̱t'aha̱ najmi beni̱, ta̱ ndaha Na̱'miu̱ ko̱ ta̱ ndaha an. ");
INSERT INTO majNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tíxinyanu̱u nga b'a̱ ka̱ma tu̱ xi nk'ie nga ku̱i̱chúhu chu̱bo̱ kj'u̱a̱ítsjehe̱nnu̱u nga b'a̱ kixinnu̱u. ’Najmi kixinyanu̱u ni xu'bi̱ nga tuts'ihi̱n ni a̱t'aha̱ an tíi̱jñajin sanu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tu̱nga nd'a̱i̱ tífia má tíjña xi kits'ín nibána. Jun najmi tíchasjaiyanú má kfíán. ");
INSERT INTO majNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tu̱ sa ní tí'be nusin nusinnu̱u a̱t'aha̱ b'a̱ tíxinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tu̱nga kju̱axi̱hí ni xi tíxinnu̱u. Tu̱ sahá ngandanu̱u nga kfíán. A̱t'aha̱ tsa najmi kfíán, najmi kj'u̱a̱í xi ku̱a̱si̱nko̱nu̱u. Tu̱nga tsa kfíán, kui xi ts'in nibásenu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","’Nk'ie nga kj'u̱a̱í, ts'i̱ín nga ka̱mankjihi̱n xu̱ta̱ xi tjín a̱sunntei̱ nga ngatitsun tjíhi̱n, ko̱ nga an kits'ian ni xi na̱xu̱ nginku̱n Nti̱a̱ná, ko̱ nga Nti̱a̱ná ku̱a̱se̱he̱ ni xi nda ko̱ ni xi najmi nda kits'ín xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ka̱mankjihi̱n xu̱ta̱ nga ngatitsun tjíhi̱n, a̱t'aha̱ najmi s'ejihi̱n an. ");
INSERT INTO majNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ka̱mankjihi̱n nga na̱xu̱ kits'ian, a̱t'aha̱ tífia má tíjña Na̱'miu̱. Najmi ta̱ cha̱hanú. ");
INSERT INTO majNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ko̱ ka̱mankjihi̱n nga Nti̱a̱ná ku̱a̱se̱he̱ ni xi nda ko̱ ni xi najmi nda kits'ín, a̱t'aha̱ ja kis'enéhe̱ ni xi kanéhe̱ xi batéxumaha̱ a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Tjín ṉkjún sana ni xi xínyanu̱u tu̱nga najmi ka̱makjinnu̱u nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nk'ie ní kj'u̱a̱í Espiri̱tu̱ xi b'éjña chji ni xi na̱xu̱ tjín, kui xi ku̱a̱kúyanu̱u ngayjee̱ ni xi na̱xu̱ tjín. A̱t'aha̱ najmi kuenta̱ha̱ ku̱i̱nchja̱ha. Ni xi ku̱i̱nt'é ní, kui ní nihi xi ku̱i̱nchja̱. Ko̱ ta̱ ku̱i̱tsu̱yanu̱u ni xi ka̱ma a̱skahan. ");
INSERT INTO majNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","’Kui xi ts'i̱ín nga ka̱mankjinnu̱u ni xi títs'ian. B'a̱ ts'ín k'u̱éjña chjihi kju̱a̱chánkana̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ngayjee̱ ni xi y'aha̱ ra̱ Nti̱a̱ Na̱'miu̱, ko̱ ta̱ an y'ahana. Kui kju̱a̱ha nga b'a̱ tíxihi̱nnu̱u nga Espiri̱tu̱ ts'i̱ín nga ka̱mankjinnu̱u ni xi títs'ian. ");
INSERT INTO majNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Sa kutju najmi ta̱ cha̱hanú, ko̱ sa kutju cha̱ ngáhanú. A̱t'aha̱ má tíjña Na̱'miu̱ kfíán. ");
INSERT INTO majNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","A̱s'a̱i k'u̱a̱ já ni'yakuyáha̱ b'i̱ ngján kingjásjaiyaha̱ xinkjín: —¿Nkú tsuhu̱ ra̱ niu̱? B'a̱ títsuná: “Sa kutju najmi ta̱ cha̱hanú ko̱ sa kutju cha̱ ngáhanú.” Ko̱ ta̱ b'a̱ títsu: “A̱t'aha̱ má tíjña Na̱'miu̱ kfíán.” ");
INSERT INTO majNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Nkú tsuhu̱ ra̱ én xi tsu: “sa kutju”? Najmi mankjinná ni xi tínchja̱ko̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kamankjihi̱n Jesu nga mjehe̱ já ni'yakuyóo̱ ngju̱ásjaiyaha̱ nkú tsuhu̱ ra̱ niu̱ ko̱ b'a̱ kitsú: —Ja b'a̱ kuaxinnu̱u nga sa kutju najmi ta̱ cha̱hanú ko̱ sa kutju cha̱ ngáhanú. ¿A kui nihi xi tíchubani̱jmíyako̱honu xinki̱u? ");
INSERT INTO majNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kju̱axi̱ ni xi tíxinnu̱u. Ch'i̱ú ko̱ k'úé nusin nusinnu̱u, tu̱nga xu̱ta̱ xi najmi be Nti̱a̱ná bi s'e̱he̱ kju̱a̱tsjo. Ndaha tsa k'úé nusin nusinnu̱u, tu̱nga a̱skahán ni kju̱a̱tsjo ka̱ma ngáha kju̱a̱nusinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","’Xi nkúhu nku ta̱chju̱ún xi tsihi̱n nku ntí, s'ehe̱ kju̱a̱ba a̱t'aha̱ ja kuichu chu̱ba̱ha̱. Tu̱nga nk'ie nga ja kuatsin ntíu̱, najmi ta̱ f'áítsjehe̱n ra̱ kju̱a̱ni̱mo̱, a̱t'aha̱ tsjo maha̱ nga nku ntí s'ejñaha̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","B'a̱ ta̱ ts'ín tíma nusinnu̱u nd'a̱i̱, tu̱nga ni̱basehé ngáha̱nu̱u. Tsjo k'úé ngáha̱ ra̱ ani̱ma̱nu̱u ko̱ najmi ch'a xi ka̱ma kjé'anu̱u kju̱a̱tsjonu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Kui ni̱stjiu̱n ndaha nku ni najmi ta̱ cha̱sjaiyahanú. Kju̱axi̱ ni xi tíxinnu̱u. Tsjánu̱u Nti̱a̱ Na̱'miu̱ tu̱ mí nihí ni xi ku̱i̱nchíhu̱u ngajona̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Santaha nd'a̱i̱ ndaha nku ni najmi kje̱e binchiu ngajona̱, tu̱nga nd'a̱i̱ ti̱nchíú ko̱ n'e̱kjóho̱on tu̱ xi 'yún s'e̱he̱nu̱u kju̱a̱tsjo. ");
INSERT INTO majNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Tíb'ejñá chu̱ba̱yanu̱u nd'a̱i̱ tu̱nga ku̱i̱chúhú chu̱ba̱ nk'ie nga najmi ta̱ k'uejñá chu̱ba̱yaha̱nu̱u. K'uejñá chji sisinnu̱u Nti̱a̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kui ni̱stjiu̱n ku̱i̱nchíú ni xi mjenu̱u ngajona̱. Najmi ka̱machjén tsa an kuankintjáínu̱u nginku̱n Nti̱a̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kui xi ta̱ tjoho̱ jun, a̱t'aha̱ tjonu̱u an ko̱ s'ejinnu̱u nga má tíjña Nti̱a̱ná nibahana. ");
INSERT INTO majNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Má tíjña Nti̱a̱ Na̱'miu̱ nibahana ko̱ jáa̱ a̱sunntei̱. K'uejñá ngáhana a̱sunntei̱ ko̱ kfínse ngáha̱ ra̱ Nti̱a̱ Na̱'miu̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","B'a̱ i̱ncha kitsú já ni'yakuyáha̱: —Nd'a̱i̱ tíchubako̱ kixi̱ kixi̱ni̱. Najmi tíb'ejña chu̱ba̱yani̱. ");
INSERT INTO majNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tímankjinni̱ nd'a̱i̱ nga yai ngayjee̱ ni xi tjín ko̱ najmi machjén tsa tjín xi ngju̱ásjaiyahi. Kui kju̱a̱ha nga s'ejihi̱nni̱ nga má tíjña Nti̱a̱ná nibahani. ");
INSERT INTO majNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","B'i̱ kitsú Jesu: —¿A s'ejinnu̱u nd'a̱i̱? ");
INSERT INTO majNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tu̱nga ku̱i̱chúhú chu̱ba̱ ko̱ ja kuichu chu̱bo̱ nd'a̱i̱ nk'ie nga nkúnkú kuankín t'axíún nga sa̱téndzjoyo ko̱ k'úéjña su̱ba̱nú. Tu̱nga najmi tíi̱jña su̱ba̱ná, a̱t'aha̱ Nti̱a̱ Na̱'miu̱ tíjñako̱na. ");
INSERT INTO majNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tíxinyanu̱u ni xu'bi̱ tu̱ xi s'e̱he̱nu̱u kju̱a̱jyuna̱. Un sku̱e̱nu̱u a̱sunntei̱, tu̱nga tsjohó kat'enu̱u a̱t'aha̱ an ja kits'in ngana̱ha̱ a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nk'ie nga ja kamaha̱ Jesu nga b'a̱ kitsú, a̱s'a̱i tsasenjinki nk'a ján ko̱ kinchja̱ko̱ Nti̱a̱ná nga b'i̱ kitsú: —Ji Na̱'mi, ja kuichu chu̱ba̱. Ta̱kúchji kju̱a̱chánkaha̱ Ntíhi̱ tu̱ xi ko̱ kui Ntíhi̱ ku̱a̱kúchjihi kju̱a̱chánkahi̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A̱t'aha̱ kik'a̱i̱ xáhi̱ xi má nga ku̱a̱téxumaha̱ ngayjee̱ xu̱ta̱, tu̱ xi ts'i̱ínk'íéntu tík'un síhin ngayjee̱ xi ji kik'a̱i̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nga k'úéntu tík'un sín xu̱ta̱, kui xi tsuhu̱ ra̱ nga sku̱e̱hi ji xi Nti̱a̱ nku tutuu̱ ko̱ nga sku̱e̱na an Jesucristo̱ xi kin'e nibáí. ");
INSERT INTO majNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ja tsakuchjá kju̱a̱chánkahi̱ a̱sunntei̱ nga kits'intjusan xá xi kik'a̱i̱ní. ");
INSERT INTO majNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nd'a̱i̱ Na̱'mi, ta̱kúchji kju̱a̱chánkana̱ nginkuin, kju̱a̱chánka xi tu̱ b'a̱ ts'ín jahá tíjñana nginkuin kintehe̱ ni nga kis'ejña a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ja y'ejñá chjihi̱ xu̱ta̱ yáha ji, xu̱ta̱ xi kik'a̱i̱ní a̱jihi̱n xu̱ta̱ xi tjín a̱sunntei̱. Ji ts'i̱ xu̱ta̱ xu'bi̱ ko̱ kik'a̱i̱ní, ko̱ kits'íntjusun éhi̱n. ");
INSERT INTO majNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mankjihi̱n nd'a̱i̱ nga ngayjee̱ ni xi kik'a̱i̱ní má tinchin nibáha. ");
INSERT INTO majNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","A̱t'aha̱ én xi kik'a̱i̱ní, kixinyaha̱ xu̱ta̱ xu'bi̱. Kits'ínkjáíhi̱n ko̱ kamankjihi̱n nga kju̱axi̱ nga má tinchin nibahana. S'ejihi̱n nga ji kin'e nibání. ");
INSERT INTO majNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Tíbankintjáíhi xu̱ta̱i̱. Najmi tíbankintjáíhi xu̱ta̱ a̱sunntei̱. Tíbankintja xu̱ta̱ xi kik'a̱i̱ní a̱t'aha̱ ji ts'i̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ngayjee̱ xu̱ta̱ xi ts'a̱n ji ta̱ ts'i̱, ko̱ xi ts'i̱ an ta̱ ts'a̱n. Tíma chji kju̱a̱chánkana̱ a̱jihi̱n xu̱ta̱ xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’An kfíán má tinchin, tu̱nga kui k'úéntu sa a̱sunntei̱. Tsje ní ji, Na̱'mi. Nga'yíhi̱n chúnko̱ho̱ ri̱ xu̱ta̱ xu'bi̱ xi kik'a̱i̱ní tu̱ xi nkuhú i̱ncha ka̱maha xi nkúhu ñá. ");
INSERT INTO majNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nk'ie nga tsáte̱jñajihi̱n xu̱ta̱ xu'bi̱ a̱sunntei̱, kikunko̱ho̱ ra̱ nga'yíhi̱n ko̱ tsasehe̱. Ndaha nku najmi kindyja. Tu̱ nku sahá xi tje̱he̱n ra̱ nga ndyja̱, kui xi kindyja tu̱ xi ku̱i̱tjusuhun ni xi tjít'a xu̱ju̱n éhi̱n. ");
INSERT INTO majNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Tu̱nga nd'a̱i̱ má tinchin tífia. Tíxinya ni xu'bi̱ nk'ie nga tíi̱jña sa a̱sunntei̱ tu̱ xi s'e̱jñajin kikjihi̱n ra̱ kju̱a̱tsjona̱ xu̱ta̱ xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","An kixinyaha̱ éhi̱n, ko̱ xu̱ta̱ a̱sunntei̱ kits'ín unkiehe̱ a̱t'aha̱ najmi a̱sunntei̱ a̱ntehe̱ xi nkú ts'ín najmi a̱sunntei̱ a̱ntena̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Najmi tíbankihi nga ku̱i̱ch'onsjei a̱sunntei̱, tu̱nga chjúxin t'axíhín ri̱ ni xi ch'onk'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Najmi a̱sunntei̱ a̱ntehe̱ xi nkú ts'ín najmi a̱sunntei̱ a̱ntena̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Éhi̱n bakúya ni xi na̱xu̱ tjín. N'e̱i nga katumankjihi̱n xu̱ta̱ xu'bi̱ ni xi na̱xu̱, tu̱ xi kats'ínkjas'ehen ri yjoho̱ nga ts'i̱ín ni xi mjehi. ");
INSERT INTO majNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Xi nkú ts'ín kin'e nibání a̱sunntei̱, b'a̱ ts'ín títs'inkjíá xu̱ta̱ xu'bi̱ a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ngandaha̱ xu̱ta̱ xu'bi̱ títsjaha̱ yjona̱ nga ts'ian ni xi mjehi, tu̱ xi ko̱ ta̱ kui ka̱maha̱ ra̱ ts'i̱ínkjas'ehen ri yjoho̱ nk'ie nga ka̱mankjihi̱n ni xi na̱xu̱ tjín. ");
INSERT INTO majNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Najmi tu̱ nku xu̱ta̱ xu'bi̱ tíbankintja. Ta̱ tíbankintjá xi s'e̱jihi̱n an nk'ie nga ku̱i̱nt'é én xi ku̱i̱tsu̱ya xu̱ta̱ xu'bi̱, ");
INSERT INTO majNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","tu̱ xi nkuhú ka̱maha ngayjee̱. Xi nkú ts'ín tinchunjinní ko̱ an tíi̱jñajihin, Na̱'mi, b'a̱ ta̱ ts'ín nkuhú katumajinná xu̱ta̱ xu'bi̱, tu̱ xi s'e̱jihi̱n ra̱ xu̱ta̱ a̱sunntei̱ nga ji kin'e nibání. ");
INSERT INTO majNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kitsjaha̱ xu̱ta̱ xu'bi̱ kju̱a̱chánka xi kik'a̱i̱ní tu̱ xi nkuhú ka̱maha xi nkú ts'ín nkuhú mahaná. ");
INSERT INTO majNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","An tíi̱jñajihi̱n xu̱ta̱ xu'bi̱ ko̱ ji tinchunjínní tu̱ xi b'a̱ ts'ín nkuhú ku̱i̱chú maha. B'a̱ ts'ín xu̱ta̱ a̱sunntei̱ ka̱mankjihi̱n ra̱ nga ji kin'e nibání ko̱ nga tjohi xu̱ta̱ xu'bi̱ xi nkú ts'ín tjohi an. ");
INSERT INTO majNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Ji Na̱'mi, mjena nga k'úéntuko̱na xu̱ta̱ xi kik'a̱i̱ní má nga kúáte̱jña, tu̱ xi sku̱e̱he kju̱a̱chánkana̱ xi kik'a̱i̱ní a̱t'aha̱ kin'etjóní kintehe̱ ni nga kamanda a̱sunntei̱. ");
INSERT INTO majNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ji Na̱'mi xi na̱xu̱ n'eko̱i xu̱ta̱, xu̱ta̱ a̱sunntei̱ najmi behi. Tu̱nga máha an, behe ko̱ ta̱ xu̱ta̱ xu'bi̱ be nga ji kin'e nibání. ");
INSERT INTO majNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Y'ejñá chjihi̱ xu̱ta̱ xu'bi̱ yáha ji ko̱ tu̱ nku k'uejñá chjihí saha̱, tu̱ xi ka̱maha̱ ra̱ ts'i̱íntjoho xu̱ta̱ xinkjín xi nkú ts'ín tjohi an. B'a̱ ts'ín kúáte̱jñajihi̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nk'ie nga ja kamaha̱ nga kinchja̱ko̱ Nti̱a̱ná Jesu, a̱s'a̱i tsitjuko̱ já ni'yakuyáha̱. I̱ncha ngji ngabantá ntáxu̱nká Cedron ko̱ jas'en nku a̱nte má tjíntje̱ yá tu. ");
INSERT INTO majNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Juda̱ xi títs'ínkjas'ehe̱n ta̱ be a̱nte xu'bo̱, a̱t'aha̱ nkjin ni̱yá kama ñjako̱ Jesu já ni'yakuyáha̱ yo̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kui nga Juda̱ j'aiko̱ho já jun ko̱ chuba já xi kunntá ni̱nku̱ xi kits'ín nibá já na̱'mi k'aku̱ ko̱ já fariseo̱. Kui xi i̱ncha y'a nd'í ko̱ ki̱cha̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ja be Jesu ngayjee̱ ni xi ka̱maha̱ ko̱ tsasinjña títjun nga b'i̱ kitsúhu̱ jóo̱: —¿Yá xi tíbinchisjó? ");
INSERT INTO majNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","B'a̱ i̱ncha kitsú jóo̱: —Jesu, nda̱ xi nibáha Nazaret. —Ahán niu̱ —kitsú Jesu. Ta̱ kabasinjñajihi̱n jóo̱ Juda̱ xi títs'ínkjas'ehe̱n. ");
INSERT INTO majNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nk'ie nga b'a̱ kitsú Jesu: “Ahán niu̱”, i̱ncha ngjinji a̱stu̱n jóo̱ ko̱ tsixuntu. ");
INSERT INTO majNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","A̱s'a̱i Jesu ta̱ kingjásjaiyahá ngáha̱ ra̱: —¿Yá xi tíbinchisjó? B'a̱ i̱ncha kitsú jóo̱: —Jesu, nda̱ xi nibáha Nazaret. ");
INSERT INTO majNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","B'i̱ kitsú Jesu: —Ja b'a̱ kuaxinnu̱u nga ahán niu̱. Tsa an xi tíbinchisjáínú, tjehe̱nnto nga katji já xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","B'a̱ kama tu̱ xi tsitjusuhun én xi kinchja̱ Jesu nga kinchja̱ko̱ Nti̱a̱ná nk'ie nga b'a̱ kitsú: “Na̱'mi, xu̱ta̱ xi kik'a̱i̱ní, ndaha nku najmi kits'inndyja.” ");
INSERT INTO majNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","A̱s'a̱i ts'asje ki̱cha̱ xi y'a Simon Pedro̱ ko̱ kingjáha̱ nga tsatet'a tja̱ba̱xínñju kixi̱ nda̱ xi 'mi Malco̱, xi nda̱ musu̱hu̱ nda̱ na̱'mi títjuu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tu̱nga b'i̱hí kitsúhu̱ Jesu Pedro̱: —Tjaya ngáhani ki̱cha̱hi̱ tja̱ba̱xíhi̱n. Tsa Nti̱a̱ Na̱'miu̱ títsjána kju̱a̱ni̱ma̱ xu'bi̱, ¿a najmi tjíhín ni nga un sku̱e̱na? ");
INSERT INTO majNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","A̱s'a̱i já juu̱n ko̱ nda̱ jun k'aku̱hu̱ ko̱ já xi kunntá ni̱nku̱ i̱ncha jakj'ánijé Jesu nga y'ét'a'yún. ");
INSERT INTO majNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Títjun ngjiko̱ ni'yaha̱ Ana, na̱'mi nchí'yaha̱ Caifa, xi tjíhi̱n nda̱ na̱'mi títjun nú xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kui Caifa xi tsinchá'a já judio̱ k'aku̱ nga b'a̱ kitsú nga tu̱ sahá nda tjín tsa nku nda̱ ku̱a̱yántjai ngandaha̱ ngayjee̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pedro̱ ko̱ kj'a̱í sa nda̱ ni'yakuyá i̱ncha kitsjennkíhi̱ Jesu. Nda̱ ni'yakuyá xu'bi̱ behe̱ nda̱ na̱'mi títjuu̱n ko̱ jas'enko̱ Jesu na̱tsin ni'yaha̱ nda̱ na̱'mi títjuu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tu̱nga máha Pedro̱, tsasinjña na̱tsiu̱n má tje̱n a̱nkju̱o̱. Kui nga a̱s'a̱i tsitjuhu nda̱ ni'yakuyá xi behe̱ ra̱ nda̱ na̱'mi títjuu̱n ko̱ kinchja̱ko̱ na̱ xi tíkunntá a̱nkju̱o̱ nga kits'ínkjas'en Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","A̱s'a̱i kingjásjaiya na̱ xi tíkunntá a̱nkju̱o̱: —¿A najmi ko̱hó ji xi ta̱ chá ni'yakuyáha̱ chá xu'bo̱? —Najmi an —kitsú Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nch'án kui ni̱stjiu̱n. Kui nga já musu̱ ko̱ já xi kunntáha ni̱nku̱ tíi̱ncha ts'ínsut'áha yjoho̱ t'a nd'í xi kats'ín'yún. Pedro̱ ta̱ síjñajihi̱n nga títs'ínsut'á yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","A̱s'a̱i nda̱ na̱'mi títjuu̱n kingjásjaiyaha̱ Jesu yáha já ni'yakuyáha̱ ko̱ mí nihi xi bakúya. ");
INSERT INTO majNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","B'i̱ kitsú Jesu: —Kinchja chji chja nginku̱n ngayjee̱ xu̱ta̱. Tehe̱nte tsakuyá ni'ya sinagoga̱ ko̱ na̱tsihi̱n ni̱nku̱ má nga ma ñjakú ngayjee̱ xu̱ta̱ judio̱. Ndaha nku ni najmi kinchja 'ma. ");
INSERT INTO majNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Á an tíchasjaiyahaní? Cha̱sjaiyaihi̱ xu̱ta̱ xi kint'é ni xi kinchja. Kui xi be ni xi kinchja. ");
INSERT INTO majNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nk'ie nga b'a̱ kitsú Jesu, a̱s'a̱i kik'onjihi̱n nku nda̱ xi kunntá ni̱nku̱ ko̱ b'a̱ kitsúhu̱: —¿Á b'a̱ n'e tíchubako̱honi nda̱ na̱'mi títjuu̱n? ");
INSERT INTO majNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","B'i̱ kitsú Jesu: —Tsa ch'on kuaxian, t'inyaní má én ch'on tsuhu xi kuanchja. Tu̱nga tsa b'a̱ tjín ni xi kuaxian, ¿á kuakich'onjihinní? ");
INSERT INTO majNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","A̱s'a̱i Ana kits'ínkji Jesu nginku̱n Caifa xi nda̱ na̱'mi títjun nga tjín'yún ts'íhi̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Máha Simon Pedro̱, kabasinjña sa nga títs'ínsut'á yjoho̱ t'a nd'íu̱. A̱s'a̱i kichasjaiyaha̱: —¿A najmi ko̱hó ji xi ta̱ nku nda̱ ni'yakuyáha̱ ndo̱? Tu̱nga najmi kits'ínkiehé yjoho̱ Pedro̱. B'a̱ kitsú: —Najmi an niu̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nku nda̱ musu̱hu̱ nda̱ na̱'mi títjuu̱n xi xinkjín maha nda̱ xi Pedro̱ tsatet'a tja̱ba̱xínñju, kui xi ta̱ kingjásjaiyaha̱: —¿A najmi kuakiehé ra nga ko̱ ji kabisinjñako̱i̱ ndo̱ ján má tjíntje̱ yá tuu̱? ");
INSERT INTO majNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tu̱nga b'a̱há ta̱ kitsú ngáha Pedro̱ nga najmi be Jesu. Ko̱ ta̱ kuihi chu̱bo̱ kikjintá nku xa̱nta̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","A̱s'a̱i tsitjuko̱ho̱ jóo̱ Jesu ni'yaha̱ Caifa nga ngjiko̱ho̱ ni'ya pretori̱o̱, má nga ts'ín kju̱a̱ nda̱ títjun Roma̱. Ja tífi ma sen niu̱ ko̱ najmi i̱ncha jas'en jóo̱ ni'ya pretori̱o̱, a̱t'aha̱ tsa kju̱a̱s'en nku ni'ya xi najmi xu̱ta̱ judio̱ ts'e̱, tsuhu̱ ra̱ nga najmi ta̱ jehe nginku̱n Nti̱a̱ná ko̱ najmi ta̱ ma kjinehe nichinehe̱ S'í Pascu̱a̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kui nga tsitjusjehe Pilato̱ na̱tsiu̱n nga j'ai nchja̱ko̱ho̱ ra̱. B'a̱ kitsúhu̱ jóo̱: —¿Mí kju̱a̱ha tíbatejénehenu nda̱i̱? ");
INSERT INTO majNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","B'a̱ kitsú jóo̱: —Tsa najmi nda̱ ch'onk'un niu̱, najmi a̱ya ntsa̱i̱ ra̱ n'e̱kjas'ei̱n. ");
INSERT INTO majNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","B'a̱ kitsú Pilato̱: —Tu̱ sahá tankínko̱o ko̱ n'e̱ko̱kju̱o̱o xi nkú ts'ín tíjña kju̱a̱téxumanu̱u. B'a̱ kitsú já judio̱ k'aku̱: —Tíjña nkjúnni̱ tsa n'e̱k'iei̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","B'a̱ ts'ín tsitjusuhun én xi kinchja̱ Jesu nga kitsúya títjun nkú ts'ín ku̱a̱yáha. ");
INSERT INTO majNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","A̱s'a̱i jas'en ngáha Pilato̱ ni'ya pretori̱o̱. Kinchja̱ha̱ Jesu ko̱ b'a̱ kitsúhu̱: —¿A ji xi nda̱ rei̱hi̱ xu̱ta̱ judio̱? ");
INSERT INTO majNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","B'i̱ kitsú Jesu: —¿A kuenta̱hi̱ b'a̱ tíbixíhinni, a ra̱ tjíhín xi kuatsúyahi yáha an? ");
INSERT INTO majNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","B'a̱ kitsú Pilato̱: —¿A nda̱ judio̱ná? Xu̱ta̱ nankihi̱ ko̱ já na̱'mi k'aku̱ kuats'ínkjas'enna ji. ¿Mí nihi xi kin'ei? ");
INSERT INTO majNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","B'i̱ kitsú Jesu: —Najmi b'a̱ ts'ín batexuma xi nkú ts'ín batéxuma já rei̱ xi tjín a̱sunntei̱. Tsa ni xi b'a̱ ts'ín tíbatexumahana kai, kja̱ántjaina xi tíi̱ncha ts'ínxát'ana tu̱ xi najmi n'e̱kjas'ehe̱n ra̱ an já judio̱ k'aku̱. Tu̱nga najmi b'a̱há ts'ín tíbatexuma. ");
INSERT INTO majNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","B'a̱ kitsú Pilato̱: —¿A xúhu̱ nda̱ rei̱ ní? B'i̱ kitsú Jesu: —Nda̱ rei̱, xi nkú tíbixín. Tu̱nga kitsinná ko̱ jáa̱ a̱sunntei̱ tu̱ xi kuakuyáhana ni xi na̱xu̱ tjín. Ngayjee̱ xu̱ta̱ xi ts'ínkjáíhi̱n ni xi na̱xu̱ tjín nt'é nta̱na̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","B'a̱ ta̱ kitsú ngáha Pilato̱: —¿Mí nihi xi na̱xu̱? Nk'ie nga b'a̱ kitsú, a̱s'a̱i tsitju nga ngjise ngáha̱ ra̱ xu̱ta̱ judio̱. B'a̱ kitsúhu̱: —Najmi chumi jéhe tísakújinna tsa tje̱he̱n ndo̱. ");
INSERT INTO majNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tu̱nga b'a̱há ts'ín tíjña ni̱yánu̱u nga ts'in nda̱íhi̱ nku nda̱ nu̱ba̱yá xi binchinú nga S'í Pascu̱a̱. ¿A mjenu̱u nga ts'in nda̱íhi̱ nda̱ rei̱hi̱ xu̱ta̱ judio̱? ");
INSERT INTO majNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","A̱s'a̱i b'a̱ i̱ncha kitsú jóo̱ nga kikjintáya: —¡Najmi tu̱ kui ndo̱ n'e nda̱íhi̱! ¡Tu̱ sahá Barraba n'e nda̱íhi̱! Máha nda̱ Barraba, nda̱ ndyjéhé niu̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","A̱s'a̱i kitsjá kju̱a̱ Pilato̱ nga s'e̱he̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Já juu̱n kits'ínnda nku corona̱ na'yá ko̱ y'é'aha̱ nintaku̱. Kits'ínngja nku najyun ndju kuan xi nkúhu xi bja já rei̱ nga i̱ncha kik'aya. ");
INSERT INTO majNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","J'aik'úhu̱n ko̱ kik'onjin nga b'a̱ kitsúhu̱: —¡Antahi, nda̱ rei̱hi̱ xu̱ta̱ judio̱! ");
INSERT INTO majNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","A̱s'a̱i ta̱ tsitjuhú ngáha Pilato̱ na̱tsiu̱n ko̱ b'a̱ kitsúhu̱ jóo̱: —Ts'ink'onsje̱nu̱u ndo̱ na̱tsiu̱n tu̱ xi cha̱hanu nga najmi chumi jéhe xi tísakújinna ndo̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","A̱s'a̱i tsitju Jesu na̱tsiu̱n nga tjí'a ts'íhi̱n ra̱ corona̱ na'yóo̱ ko̱ nga yja ts'íhin najyun ndju kuo̱n. B'a̱ kitsú Pilato̱: —¡Á ndo̱ e̱i̱! ");
INSERT INTO majNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Já na̱'mi k'aku̱ ko̱ já xi kunntá ni̱nku̱, nk'ie nga i̱ncha kikie Jesu kikjintáya: —¡Tjat'a krui̱ ndo̱! ¡Tjat'a krui̱! B'a̱ kitsú Pilato̱: —Tu̱ sahá jun tankínko̱o ko̱ tjat'a kruu̱. An najmi chumi jéhe xi tísakújinna ndo̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","B'a̱há ta̱ kitsú ngáha já judio̱ k'aku̱: —Tíjñani̱ kju̱a̱téxuma ko̱ xi nkú ts'ín tíjña kju̱a̱téxumani̱ tjíhin nga ku̱a̱yá nda̱i̱, a̱t'aha̱ Ntíhi̱ Nti̱a̱ná títs'ín ma yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nk'ie nga kint'é Pilato̱ niu̱, 'yún kitsankjún sa. ");
INSERT INTO majNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ta̱ jas'ehén ngáha ni'ya pretori̱o̱ ko̱ b'a̱ kitsúhu̱ Jesu: —¿Má nibáhani? Tu̱nga najmi kinchja̱há Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","A̱s'a̱i b'a̱ kitsú Pilato̱: —¿A najmi chu̱bako̱hóní? ¿A najmi yaní tsa ka̱ma kjuat'á kruu̱hu ko̱ tsa ts'in nda̱í ngáhara? ");
INSERT INTO majNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","B'i̱ kitsú Jesu: —Ndaha nku ni najmi ka̱ma n'e̱ní tsa najmi Nti̱a̱ná kitsjá xáhi. Kui kju̱a̱ha, xi kits'ínkjas'ehenna a̱ya ntsa̱i̱ 'yún tje̱n saha̱ ra̱ jé nga ji. ");
INSERT INTO majNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kui chu̱bo̱ kik'atuts'i̱hi̱n Pilato̱ nga tsangisjai ni̱yá xi nkú ts'ín ka̱ma ts'i̱ín nda̱í ngáha̱ ra̱ Jesu. Tu̱nga b'i̱hí ts'ín i̱ncha kikjintáya já judio̱ k'aku̱: —¡Tsa n'e̱ nda̱íhi̱ ndo̱, najmi nda tín'ei nginku̱n nda̱ títjun Cesa̱r! ¡Xi nda̱ rei̱ ts'ín ma suba yjoho̱, kui xi tífi kontra̱ha̱ nda̱ títjun Cesa̱r! ");
INSERT INTO majNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nk'ie nga kint'é Pilato̱ én xu'bi̱, a̱s'a̱i kik'onsje Jesu na̱tsiu̱n ko̱ y'ejña a̱nte xi má nga ts'ín kju̱a̱, a̱nte xi 'mi Má Kjiya Ndji̱o̱, én xi tsuhu̱ ra̱ Gabata nga én hebreo̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ni̱stjin xu'bi̱ ja tíi̱ncha b'énda xu̱ta̱ ni xi ts'e̱ S'í Pascu̱a̱, a̱t'aha̱ ja tíbichú tiña s'íu̱. Nkú ra̱ ma nga chu̱ba̱ te jo niu̱. A̱s'a̱i b'a̱ kitsúhu̱ Pilato̱ xu̱ta̱ judio̱: —¡Á nda̱ rei̱nu̱u e̱i̱! ");
INSERT INTO majNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","B'a̱ i̱ncha kitsú xu̱to̱ nga kikjintáya: —¡Ti̱ch'onsje̱i ndo̱! ¡Ti̱ch'onsje̱i! ¡Tjat'a krui̱ ndo̱! B'a̱ kitsú Pilato̱: —¿A ngjuat'á kruu̱ná nda̱ rei̱nu̱u? B'a̱ kitsú já na̱'mi k'aku̱: —¡Najmi tjín sani̱ kj'a̱í nda̱ rei̱, tu̱ nku sahá nda̱ títjun Cesa̱r! ");
INSERT INTO majNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","A̱s'a̱i Pilato̱ kitsjá kju̱a̱ nga s'e̱t'a kruu̱ Jesu ko̱ i̱ncha ngjiko̱ho̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","A̱s'a̱i tsitju Jesu nga y'anji kruu̱hu̱ nga ngji a̱nte xi 'mi Nintaku̱ A̱ni̱ma̱, én xi tsuhu̱ ra̱ Golgo̱ta̱ nga én hebreo̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yo̱ kis'et'a kruu̱ kui ko̱ jo sa já. Nku xi kis'et'a kruu̱ nga kixi̱hi̱ ko̱ nku nga skúhu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kitsjá kju̱a̱ Pilato̱ nga s'e̱t'a nku yáte a̱ntsjáku̱ kruu̱. B'i̱ ts'ín kis'et'a: “Jesu, nda̱ xi nibáha Nazaret, nda̱ rei̱hi̱ xu̱ta̱ judio̱.” ");
INSERT INTO majNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nkjin xu̱ta̱ judio̱ kits'ínya ntuu̱, a̱t'aha̱ tiña maha̱ na̱xi̱nantóo̱ a̱nte má nga kis'et'a kruu̱ Jesu ko̱ a̱t'aha̱ kis'et'a yátee̱ én hebreo̱ ko̱ én latin ko̱ én griego̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","A̱s'a̱i j'aisehe̱ Pilato̱ já na̱'mi k'aku̱hu̱ xu̱ta̱ judio̱ ko̱ b'a̱ kitsúhu̱: —Najmi nda tjín nga: “Nda̱ rei̱hi̱ xu̱ta̱ judio̱”, tjít'a yátee̱. Tu̱ sahá t'et'ai nga: “Kui xi kitsú: An xi nda̱ rei̱hi̱ xu̱ta̱ judio̱.” ");
INSERT INTO majNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","B'a̱ kitsú Pilato̱: —Ni xi kab'et'á, ja kab'et'á. ");
INSERT INTO majNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Máha já juu̱n, nk'ie nga ja kingját'a kruu̱ Jesu, jakj'á najyun xi yja nga kits'ínxi̱. Ñju ts'asje ko̱ nkúnkú kikanéhe̱. Ko̱ ta̱ jakj'á najyun ndju xi yja Jesu, xi najmi tjíhi̱n ni̱yá chjuya. Nkuhú nga ngji'aha kásin santaha tuts'in. Kui nga b'a̱ kitsúhu̱ ra̱ xinkjín: ");
INSERT INTO majNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","—Najmi tu̱ chjunti̱yaá xu'bi̱. Tu̱ sahá ti̱nútonyáhaná yá xi ka̱ma ts'e̱. B'a̱ kama tu̱ xi tsitjusuhun éhe̱n Nti̱a̱ná xi b'a̱ ts'ín tjít'a: “Kits'ínxi̱hi̱ xinkjín najyunna̱ ko̱ kitsutonyáha najyun ndjuna̱.” Kui nga b'a̱ kits'íhin já juu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tíi̱nchat'a tiñaha̱ kruu̱ na̱aha̱ Jesu, na̱ nichja na̱aha̱, Maria̱ chju̱úhu̱n Kleofa ko̱ Maria̱ Magdalena̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nk'ie nga kikie Jesu na̱aha̱ ko̱ nda̱ ni'yakuyá xi 'yún tjoho̱ nga síjña yo̱, b'a̱ kitsúhu̱ na̱aha̱: —Ji ta̱chju̱ún, á ntíhi̱ yo̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ko̱ b'i̱ kitsúhu̱ nda̱ ni'yakuyóo̱: —Á na̱ahi̱ yo̱. Ta̱ kuihi chu̱bo̱ nda̱ ni'yakuyá xu'bi̱ kitsjántehe̱ na̱aha̱ Jesu ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nk'ie nga ja kama ni xu'bi̱, be Jesu nga ja kama ndju̱ú ngayjee̱ ni xi tjíhin nga ku̱i̱tjusun. Tu̱ xi tsitjusuhun xi nkú ts'ín tjít'a éhe̱n Nti̱a̱ná, kui nga b'i̱ kitsúhu: —Xintá tímana. ");
INSERT INTO majNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Síjña yo̱ nku nisa ninte xi tíi̱ncha binu̱ san. Nku nixú kits'ínk'anchi̱ko̱ho jóo̱ binu̱ soo̱n. Kui xi y'éku k'aku̱hu̱ nku yáxá nga kitsungi'a ts'a Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nk'ie nga kits'i Jesu binu̱ soo̱n, b'a̱ kitsú: —Ja kuitjusunyje. A̱s'a̱i kingjénsten nintaku̱ ko̱ a̱kui k'iehén. ");
INSERT INTO majNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kui ni̱stjiu̱n tís'enda ni xi ts'e̱ S'í Pascu̱a̱. Kui nga najmi mjehe̱ ra̱ já judio̱ k'aku̱ tsa s'e̱t'a kruu̱ yjoninte k'ie̱n nk'ie nga ku̱i̱chú ni̱stjin nkjúu̱n, a̱t'aha̱ 'yún ṉkjún kui ni̱stjin xu'bo̱. Kui nga tsankihi̱ ra̱ kju̱a̱ Pilato̱ nga chjút'o̱kjáha sjai já xi kjintut'á kruu̱ ko̱ nga chjúxin yjonintehe̱ t'a kruu̱. ");
INSERT INTO majNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","A̱s'a̱i j'ai já juu̱n ko̱ kikjet'o̱kjá sjai nda̱ xi tjun kjit'a ko̱ sjai nda̱ xinkuu̱ xi ta̱ kjit'a kruu̱ko̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tu̱nga nk'ie nga i̱ncha tsichu má kjit'a Jesu, kikie nga ja ka'me. Najmi kikjet'o̱kjáha sjai. ");
INSERT INTO majNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tu̱nga nkuhú nda̱ juu̱n kik'íénjinkihi̱ ki̱cha̱ 'me̱he̱ Jesu ko̱ tje̱n'yún tsitjuhú jní ko̱ ntánijua. ");
INSERT INTO majNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nda̱ xi kikie ni xi kamoo̱, kui xi kitsúya ni xi kama ko̱ kju̱axi̱ ni xi tsuya. Be nga kju̱axi̱ ni xi tsuya tu̱ xi ta̱ s'e̱jihi̱nnu̱u ko̱ jun. ");
INSERT INTO majNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","A̱t'aha̱ b'a̱ kama tu̱ xi tsitjusuhun éhe̱n Nti̱a̱ná xi b'a̱ ts'ín tjít'a: “Ndaha nku nintaha̱ najmi chjút'o̱kjá.” ");
INSERT INTO majNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ko̱ ta̱ tjít'a ya éhe̱n Nti̱a̱ná má nga b'a̱ títsu: “Ku̱a̱se̱he̱ jóo̱ nda̱ xi kis'enjinkihi̱ ki̱cha̱.” ");
INSERT INTO majNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","A̱skahan nk'ie nga ja b'a̱ kamoo̱, nku nda̱ xi nibáha nanki Arimatea̱ xi 'mi Kuse tsankihi̱ kju̱a̱ Pilato̱ nga ngju̱a̱i̱ko̱ yjonintehe̱ Jesu. Kui Kuse xi ta̱ nda̱ ni'yakuyáha̱ Jesu tu̱nga tu̱ kitsjennkí 'mahá ra̱ a̱t'aha̱ tsankjún já judio̱ k'aku̱. A̱s'a̱i kitsjá kju̱a̱ Pilato̱ ko̱ ngjikj'á ndo̱ yjonintehe̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ko̱ ta̱ Nicodemo̱, nda̱ xi ngjisehe̱ Jesu nga jyuu̱n, j'aiko̱ nkú ra̱ ma katé kilu̱ ni xi sinjne̱ xi 'mi mirra̱ ko̱ aloe xi j'atjijinko̱ho̱ xinkjín. ");
INSERT INTO majNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","I̱ncha jakj'á nga joo̱ yjonintehe̱ Jesu ko̱ kik'ontikjájnu najyun ndju nga kik'onjnu ts'íhi̱n ra̱ ni xi sinjne̱, xi nkú ts'ín tíjña ni̱yáha̱ xu̱ta̱ judio̱ nga fáyanji xinkjín. ");
INSERT INTO majNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Má kis'et'a kruu̱ Jesu, tiña maha̱ nku a̱nte má nga tjíntje̱ yá tu. A̱nte xu'bo̱ tíjña nku tsjó tse̱tse̱ xi ndaha nku najmi kje̱e s'eya. ");
INSERT INTO majNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yo̱ kingjáya jóo̱ yjonintehe̱ Jesu, a̱t'aha̱ tíjña tiña tsjóo̱ ko̱ a̱t'aha̱ kui ni̱stjiu̱n tíi̱ncha b'énda xu̱ta̱ judio̱ ni xi ts'e̱ s'íu̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tuminku̱ ta̱ jyun nk'ie nga jyunya sa, ngjisehe̱ tsjóo̱ Maria̱ Magdalena̱ ko̱ kikie nga kachjuxín ndji̱o̱ xi kis'echjanehe ti̱xa̱ tsjóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","A̱s'a̱i tsangatsanka nga ngjisehe̱ Simon Pedro̱ ko̱ nda̱ ni'yakuyá xinkuu̱ xi Jesu 'yún tjoho̱. B'i̱ kitsú: —¡Ja kachjuxín yjonintehe̱ Chá Nti̱a̱ná a̱ya tsjóo̱ ko̱ najmi yai̱ má kas'ejña ngáha! ");
INSERT INTO majNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","A̱s'a̱i tsitjusje Pedro̱ ko̱ nda̱ ni'yakuyá xinkuu̱ nga ngjisehe̱ tsjóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tsangatsanka nga joo̱, tu̱nga nda̱ ni'yakuyá xinkuu̱ 'yún ki̱tsa̱ tsangatsanka sa nga Pedro̱ ko̱ tjun tsichu tsjóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tu̱nga tu̱ tsasekjás'ehén ko̱ kikie nga kjijña najyun ndju xi tsich'ontikjájnu yjonintehe̱ Jesu. Najmi jas'en tsjóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","A̱s'a̱i tsichu tje̱nnkihi̱ Pedro̱ ko̱ jas'en a̱ya tsjóo̱. Kikie najyun ndju xi kjijña yo̱ ");
INSERT INTO majNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ko̱ najyun xi tsich'ontikjájnu nintaku̱ Jesu. Kui xi najmi kjijñakjoko̱ najyun ndjuu̱. T'axín kjijña nga tjíkjoya. ");
INSERT INTO majNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","A̱s'a̱i ta̱ jas'en nda̱ ni'yakuyá xinkuu̱ xi tjun tsichusehe̱ tsjóo̱. Kikie ko̱ kis'ejihi̱n nga tíjña tík'un Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","A̱t'aha̱ najmi kje̱e mankjihi̱n jóo̱ éhe̱n Nti̱a̱ná xi b'a̱ ts'ín tjít'a nga tjíhin nga kj'u̱a̱íya ngáha̱ ra̱ Jesu ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","A̱s'a̱i kik'óya ngáha já ni'yakuyóo̱ ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tu̱nga máha Maria̱, tsasinjña na̱tsihi̱n tsjóo̱ nga tíkjintá. Ta̱ tíkjintá ts'íhin nga tsasekjás'en tsjóo̱ ");
INSERT INTO majNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ko̱ kikie jo ntítsje xi yja najyun taba, xi kab'entusún a̱nte má nga kis'ejña yjonintehe̱ Jesu. Nku xi kab'ejña má kis'ejña nintaku̱ ko̱ nku xi kab'ejña má kitsjen sjai. ");
INSERT INTO majNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","B'a̱ kitsú ntítsjee̱: —Ji ta̱chju̱ún, ¿á tích'íhini? B'a̱ kitsú Maria̱: —A̱t'aha̱ kachjuxín yjonintehe̱ Chá Nti̱a̱na̱. Najmi be má kafi s'ejña ngáha. ");
INSERT INTO majNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A̱s'a̱i kits'ínk'ótjiya ko̱ kikie nga yo̱ kabasinjña Jesu, tu̱nga najmi kamankjihín ra̱ tsa Jesu niu̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","B'i̱ kitsú Jesu: —Ji ta̱chju̱ún, ¿á tích'íhini? ¿Yá xi tíbinchisjáí? Tu̱ nda̱ xi kunntáhá yá tu xi tjín yo̱ kits'ín ma Maria̱ ko̱ b'a̱ kitsú: —Ji, tsa ji ka'miko̱i̱ yjonintee̱, t'inyaní má kafajñai ko̱ kfínkj'a ngáhana. ");
INSERT INTO majNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—Ji Maria̱ —kitsú Jesu. Kits'ínk'ótjiya Maria̱ ko̱ b'a̱ kitsúhu̱ nga én hebreo̱: —¡Raboni̱! Kui éi̱n xi tsuhu̱ ra̱ Maestru̱. B'i̱ kitsú Jesu: ");
INSERT INTO majNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—Najmi tu̱ nuba'yúnní, a̱t'aha̱ najmi kje̱e finjia má tíjña Na̱'mina̱. Tu̱nga t'inyahá ri̱ já nts'é nga kfínnjia má tíjña Na̱'mina̱ xi ta̱ Na̱'minu̱u, Nti̱a̱na̱ xi ta̱ Nti̱a̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","A̱s'a̱i Maria̱ Magdalena̱ ngji tsúyaha̱ já ni'yakuyóo̱ nga kabe Nda̱ Nti̱a̱ná ko̱ kitsúyaha̱ ni xi kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nk'ie nga ja kama jyuu̱n ta̱ kuihi ni̱stjin tuminku̱, tjíchja a̱nkju̱a̱ má nga kab'entu já ni'yakuyóo̱, a̱t'aha̱ tíi̱ncha tsankjún já judio̱ k'aku̱. A̱s'a̱i Jesu j'ai sinjñajihi̱n ko̱ kikjaniñaha̱ nga b'i̱ kitsúhu̱: —Kas'enu̱u kju̱a̱jyu. ");
INSERT INTO majNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nk'ie nga b'a̱ kitsú, tsakúchji ntsja ko̱ 'me̱he̱. Tsjo kamaha̱ já ni'yakuyóo̱ nga kikie ngáha Nda̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","A̱s'a̱i b'a̱há ta̱ kitsú ngáha Jesu: —Kas'enu̱u kju̱a̱jyu. Xi nkú ts'ín kits'ín nibána Nti̱a̱ Na̱'miu̱, b'a̱ ta̱ ts'ín ts'inkjínu̱u nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kikjenimajin jóo̱ ko̱ b'i̱ kitsúhu̱: —N'e̱kjóho̱on Espiri̱tu̱ Santo̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Xi n'e̱ndyjat'oho̱o jéhe̱ ka̱ma ndyjat'aha̱ jéhe̱. Xi najmi n'e̱ndyjat'oho̱o jéhe̱ tu̱ nku s'e̱hé ra̱ jé. ");
INSERT INTO majNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma xi ta̱ 'mi nda̱'yu̱n, xi ta̱ nku nda̱ ni'yakuyá xi te joo̱, najmi tíjña nk'ie nga j'ai Jesu. ");
INSERT INTO majNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","A̱s'a̱i já ni'yakuyá xingisoo̱ b'a̱ kitsúhu̱ ndo̱: —Kuayai̱ Nda̱ Nti̱a̱ná. B'a̱ kitsú Toma: —Tsa najmi skue chu̱ba̱ha̱ xiu̱n a̱ya ntsja ko̱ tsa najmi tsungis'en na̱jnú ntsa̱ má ngjihi̱ xiu̱n ko̱ tsa najmi tsungis'en ntsa̱ 'me̱he̱, najmi s'e̱jinna. ");
INSERT INTO majNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nk'ie nga j'a jin ni̱stjin, ta̱ tjíntuhú ngáha já ni'yakuyóo̱ nku a̱ya ni'ya ko̱ ta̱ tíjña ñja Toma. A̱s'a̱i ta̱ j'ai sinjñajihín ngáha̱ ra̱ Jesu, nk'ie nga tjíchja a̱nkju̱o̱. B'i̱ kitsúhu̱ nga kikjaniñaha̱: —Kas'enu̱u kju̱a̱jyu. ");
INSERT INTO majNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","A̱s'a̱i b'a̱ kitsúhu̱ Toma: —Nibá mahi e̱i̱. Cha̱se̱i̱hi̱ ntsa̱ ko̱ ti̱núngis'ein na̱jnú ntsa̱i̱ ko̱ ti̱núngis'ein ntsa̱i̱ 'me̱na̱. Najmi nda tín'ei nga najmi tís'ejihin. N'e̱ s'ejinní. ");
INSERT INTO majNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","B'a̱ kitsú Toma: —¡Ji Nda̱ Nti̱a̱ ko̱ Nti̱a̱na̱! ");
INSERT INTO majNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","B'i̱ kitsú Jesu: —¿A a̱t'aha̱ kuayaní, a kui kju̱a̱ha kuas'ejihin ri? Á b'a̱ nda tjíhin ts'e̱ xu̱ta̱ xi tís'ejihi̱n an ndaha tsa najmi tíbena. ");
INSERT INTO majNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nkjin ko̱ kj'a̱í sa kju̱a̱nkjún xi kits'ín Jesu nginku̱n já ni'yakuyáha̱. Kui xi najmi kis'et'ayje xu̱ju̱n xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tu̱nga ni xu'bi̱ kis'et'a tu̱ xi s'e̱jihi̱nnu̱u nga Jesu xi kits'ín nibá Nti̱a̱ná, nga kui xi Ntíhi̱ Nti̱a̱ná, tu̱ xi b'a̱ ts'ín ku̱i̱ntsu̱ba̱ tík'uhunnu nga s'e̱jinnu̱u kui. ");
INSERT INTO majNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","A̱skahan ta̱ tsakúchjihí ngáha̱ ra̱ yjoho̱ Jesu já ni'yakuyáha̱ a̱ndai ntáchak'un Tiberi̱a̱. B'i̱ ts'ín tsakúchjihi̱ yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nkuhú i̱ncha kab'a xinkjín nga kab'entu Simon Pedro̱, Toma xi ta̱ 'mi nda̱'yu̱n, Natanael xi nda̱ xi nibáha nanki Cana, nanki xi tíjñajihi̱n a̱nte Galilea̱, jáha̱ Zebedeo̱ ko̱ kj'a̱í sa jo já ni'yakuyá. ");
INSERT INTO majNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","A̱s'a̱i b'a̱ kitsú Simon Pedro̱: —Tji̱o̱ kfín tsuba. B'a̱ kitsú já xingisoo̱: —Ko̱ ji̱n kuankíi̱n. A̱s'a̱i i̱ncha jas'en nku tsutsu, tu̱nga kui ni̱stje̱n xu'bo̱ ndaha nku tji̱o̱ najmi kisakúhu̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nkú ra̱ ma nga ja tífi ma sen, j'ai sinjña Jesu a̱ndai ntáchak'uu̱n, tu̱nga najmi kamankjihín ra̱ já ni'yakuyóo̱ tsa Jesu niu̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","A̱s'a̱i b'i̱ kitsú Jesu: —Jun já, ¿a najmi kje̱e sakúnu̱u tji̱o̱? —Najmi —kitsú jóo̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","B'a̱há ta̱ kitsú ngáha Jesu: —Xi tje̱hen nga kixi̱hi̱ tsutsuu̱ chja̱nikj'o na̱'yanu̱u ko̱ sa̱kúnu̱u. B'a̱ kits'ín jóo̱ ko̱ a̱s'a̱i ndaha najmi ta̱ ma kjenjihi na̱'yoo̱, a̱t'aha̱ nkjin ṉkjún tji̱o̱ xi kisakúhu̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nda̱ ni'yakuyá xi Jesu 'yún tjoho̱ b'a̱ kitsúhu̱ Pedro̱: —¡Nda̱ Nti̱a̱náhá niu̱! Nk'ie nga kint'é Simon Pedro̱ nga “Nda̱ Nti̱a̱ná niu̱” kik'ihi̱n, kingja ngáha najyuhu̱n, a̱t'aha̱ kab'asje, ko̱ kikjaníkj'ajin yjoho̱ ntáchak'uu̱n. ");
INSERT INTO majNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A̱skahan já ni'yakuyá xingisoo̱ tsichuko̱ tsutsuu̱ nga tíb'éfe ts'íhin na̱'ya xi katsehe tji̱o̱, a̱t'aha̱ tiña maha̱ a̱ndai ntóo̱ nkú ra̱ ma unchan metru̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nk'ie nga tsitjujen jóo̱ tsutsuu̱, kikie nku nd'í xi tíma 'yún ko̱ nku tji̱o̱ xi kjijñajin x'íu̱ ko̱ ni̱nku̱a̱n. ");
INSERT INTO majNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","B'i̱ kitsú Jesu: —Nibáko̱o chuba tji̱o̱ xi kuasakúnu̱u. ");
INSERT INTO majNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tsiyajnu Simon Pedro̱ tsutsuu̱ ko̱ y'éfe má kixiu̱ na̱'ya xi katsehe tji̱o̱ i. Unchan ko̱ cháte ko̱ jan maha. Tu̱nga ndahá tsa b'a̱ ts'ín nkjin kamaha tji̱o̱, najmi kitiyá na̱'yoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","A̱s'a̱i b'i̱ kitsú Jesu: —Nibá chi̱no̱o. Ndaha nku já ni'yakuyóo̱ najmi kama k'un kingjásjaiyaha̱: “¿Yáha ji?”, tsa kitsúhu̱, a̱t'aha̱ be nga Nda̱ Nti̱a̱ná niu̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","A̱s'a̱i j'ai tiña Jesu, jakj'á ni̱nku̱o̱n ko̱ kitsjáha̱ jóo̱. B'a̱ ta̱ kits'íhi̱n tji̱o̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kui xu'bi̱ xi ni̱yá xi ma jahan nga tsakúchjihi̱ Jesu yjoho̱ já ni'yakuyáha̱ a̱skahan nk'ie nga j'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nk'ie nga ja kamaha̱ nga kikjine, Jesu kingjásjaiyaha̱ Simon Pedro̱: —Ji Simon ntíhi̱ Jona, ¿a 'yún tjo sahi an nga já xu'bi̱? B'a̱ kitsú Pedro̱: —Joho̱n, Nda̱ Nti̱a̱, yai nga tjona ji. B'i̱ kitsú Jesu: —Chúnntai chu̱tsa̱nka̱na̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","A̱s'a̱i b'a̱há ta̱ kitsú ngáha̱ ra̱ ni̱yá xi ma joho: —Ji Simon ntíhi̱ Jona, ¿a tjohi an? B'a̱ kitsú Pedro̱: —Joho̱n, Nda̱ Nti̱a̱, yai nga tjona ji. B'i̱ kitsú Jesu: —Cha̱se̱i̱hi̱ chu̱tsa̱nka̱na̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A̱s'a̱i b'a̱há ta̱ kitsú ngáha̱ ra̱ ni̱yá xi ma jahan: —Ji Simon ntíhi̱ Jona, ¿a tjohi an? Kik'ie nusin nusihi̱n Pedro̱ nga kichasjaiyaha̱: “¿A tjohi an?”, ni̱yá xi ma jahan. B'a̱ kitsúhu̱: —Ji Nda̱ Nti̱a̱, ji xi yai ngayjee̱ ni xi tjín. Yai nga tjona ji. B'i̱ kitsú Jesu: —Chúnntai chu̱tsa̱nka̱na̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kju̱axi̱ ni xi tíxihin. Nk'ie nga ndyja sahi, kindyja su̱ba̱i̱ najyihi̱n ko̱ k'in tu̱ má nga kama mjehé ri. Tu̱nga nk'ie nga ka̱ma cháí, kféntei ntsa̱i̱ ko̱ kj'a̱í xi ts'i̱ínngja ngáha ri najyihi̱n ko̱ ngju̱a̱i̱ko̱hi má nga najmi mjehi k'úín. ");
INSERT INTO majNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","B'a̱ ts'ín kitsúya títjuhun Jesu xi nkú ts'ín ku̱a̱yá Pedro̱ nga ku̱a̱kúchji kju̱a̱chánkaha̱ Nti̱a̱ná. Ko̱ b'i̱ ta̱ kitsú yaha̱: —Tsjénnkiní. ");
INSERT INTO majNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","A̱s'a̱i tsasenji a̱stu̱n Pedro̱ ko̱ kikie nga tje̱nnkihi̱ nda̱ ni'yakuyá xi Jesu 'yún tjoho̱, xi tíjñat'a tiñaha̱ Jesu nk'ie nga i̱ncha kikjine nichinehe̱ S'í Pascu̱a̱ ko̱ xi b'a̱ kitsúhu̱: “Ji Nda̱ Nti̱a̱, ¿yá xi ts'i̱ínkjas'ehin?” ");
INSERT INTO majNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nk'ie nga kikie Pedro̱ nda̱ ni'yakuyóo̱, kingjásjaiyaha̱ Jesu: —Ji Nda̱ Nti̱a̱, kui nda̱i̱, ¿nkú ka̱maha̱? ");
INSERT INTO majNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","B'i̱ kitsú Jesu: —Tsa mjena nga k'úéjña santa nkúhu nga kjúái̱ ngáhana, najmi ji tje̱hen ri nga cha̱i ni xu'bo̱. Ji tsjénnkiní. ");
INSERT INTO majNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A̱skahan kik'inyaha̱ én xu'bi̱ xu̱ta̱ ni̱nku̱, nga najmi ku̱a̱yá nda̱ ni'yakuyá xu'bo̱. Tu̱nga najmi b'a̱há kitsú Jesu tsa najmi ku̱a̱yá ndo̱. B'i̱ ní kitsú: “Tsa mjena nga k'úéjña santa nkúhu nga kjúái̱ ngáhana, najmi ji tje̱hen ri nga cha̱i ni xu'bo̱.” ");
INSERT INTO majNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kui nda̱ ni'yakuyóo̱ tsuya kixi̱ niu̱ ko̱ kui xi y'ét'a ni xu'bi̱. Ko̱ yai̱ nga kju̱axi̱ én xi kinchja̱. ");
INSERT INTO majNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nkjin sa ni xi kits'ín Jesu. Tsa s'e̱t'a ngayjee̱ ni xi kits'ín, b'a̱ mana nga najmi s'e̱n ngayjee̱ a̱sunntee̱ xu̱ju̱n xi s'e̱t'a niu̱.");
INSERT INTO majNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ji nda̱ xinkjíán Teofi̱lo̱, xu̱ju̱n xi tjun y'entúhu kixinyaha ngayjee̱ ni xi kik'atuts'i̱hi̱n nga kits'ín ko̱ tsakúya Jesu ");
INSERT INTO majNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","santa nkúhu nga ngjinji nk'a ján. Kintehe̱ ni nga ngju̱a̱i̱, Espiri̱tu̱ Santo̱ho̱ Nti̱a̱ná tsakúyako̱ho̱ ra̱ já postru̱ xi j'ájin ni xi tjíhin nga ts'i̱ín. ");
INSERT INTO majNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nga k'ien Jesu ko̱ j'áíya ngáha̱ ra̱ ngabayoo̱, nkjin ni̱yá j'aikúchjihi̱ yjoho̱ já postru̱hu̱ nga ja tíjña tík'un. Yachán ni̱stjin kamaha̱ nga tsakúchjihi̱ yjoho̱ ko̱ kinchja̱ni̱jmíyako̱ho jóo̱ Nti̱a̱ná ko̱ nkú tjíhi̱n ra̱ nga kui batéxuma. ");
INSERT INTO majNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nk'ie nga tíjñajin saha̱ já postru̱, b'a̱ kitsúhu̱ nga najmi tu̱ ku̱i̱tju nanki Jerusalen. B'i̱ kitsúhu̱: —Chúyo santaha nga ku̱i̱tjusun ni xi kitsúya títjun Na̱'mina̱. Kui niu̱ xi kinchjani̱jmíyako̱ho̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jua bi ntánijua tsaténtáha xu̱ta̱ tu̱nga jun tu̱ chuba ni̱stjihín ndyjaha̱ nga Espiri̱tu̱ Santo̱ sa̱téntáko̱ho̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","A̱s'a̱i já xi kama ñjakúko̱ Jesu i̱ncha kingjásjaiyaha̱: —Ji Nda̱ Nti̱a̱, ¿a nd'a̱i̱ k'u̱a̱i̱hi̱ xu̱ta̱ Israel nga ku̱a̱téxuma ngáha̱ ra̱ nanki xi ts'e̱? ");
INSERT INTO majNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A̱s'a̱i b'i̱ kitsú Jesu: —Najmi jun tjíhin nga cho̱o mí chu̱ba̱ha ko̱ mí ni̱stjihin ku̱i̱tjusun ni xi y'énda Nti̱a̱ Na̱'miu̱ nga ka̱ma. ");
INSERT INTO majNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tu̱nga n'e̱kjáíhín ru̱u nga'yún nk'ie nga kj'u̱a̱íjinnu̱u Espiri̱tu̱ Santo̱. Ku̱i̱xínyo e̱i̱ Jerusalen, ngayjee̱ a̱nte Judea̱ ko̱ a̱nte Samari̱a̱ ko̱ nga ngúsuhu̱n a̱sunntee̱ ni xi kits'ian. ");
INSERT INTO majNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A̱skahan nga ja b'a̱ kitsú Jesu ko̱ nga tíi̱ncha base ts'íhi̱n ra̱ já postru̱hu̱, a̱s'a̱i ngjinji nk'a ján. Nku ni̱nti̱ y'é'maha̱ ko̱ najmi ta̱ kikiehe̱ ra̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nk'ie nga tíi̱ncha basenjinki nk'a ján jóo̱ nga tífi Jesu, tu̱ johó já xi yja najyun taba j'ainchat'aha̱. ");
INSERT INTO majNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","B'i̱ kitsúhu̱: —Jun xi nibáhanu Galilea̱, ¿á b'a̱ n'e tíchasenjinkihinu nk'a ján? Xi nkú ts'ín kuitjujinnu̱u Jesu nga kfi nk'a ján, b'a̱há ta̱ ts'ín kj'u̱a̱í ngáha xi nkú ts'ín kuayo nga kfi. ");
INSERT INTO majNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","A̱s'a̱i a̱sunntu tje̱nki̱ xi 'mi Yá Olivo̱ i̱ncha nibaha já postru̱ nga j'ai ngáha nanki Jerusalen. Kui tje̱nki̱u̱ xi tiña maha̱ Jerusalen nkú ra̱ ma tsa nku kilome̱tru̱. ");
INSERT INTO majNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nk'ie nga i̱ncha jas'en a̱jin na̱nti̱o̱, i̱ncha ngjinji ni'ya xi jo tjíxjó xi i̱ncha tjíntuyá. Kui xu'bi̱ já postru̱ xi tjíntu yo̱: Pedro̱, Santiago̱, Jua, Andre, Felipe̱, Toma, Bartolome, Mateo̱, Santiago̱ xi ntíhi̱ Alfeo̱, Simon xi mako̱ já xi mjehe̱ kjaánko̱ já Roma̱, ko̱ Juda̱ xi nts'e̱ Santiago̱. ");
INSERT INTO majNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nkuhú i̱ncha kits'ín kju̱a̱nkjintak'uhu̱n nga tehe̱nte kinchja̱ko̱ Nti̱a̱ná ngayjee̱ já xu'bi̱ ko̱ já nts'e̱ Jesu, Maria̱ xi na̱aha̱ maha ko̱ kj'a̱í sa jminchjín. ");
INSERT INTO majNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nku ni̱stjin nk'ie nga kama ñjakú xu̱ta̱ xi s'ejihi̱n Jesu, ma ra̱ tsa unchan ko̱ kan, a̱s'a̱i Pedro̱ tsasinjñajin masehe̱n ko̱ b'i̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Jun já nts'e, tjíhin nga tsitjusun ni xi Espiri̱tu̱ Santo̱ kits'ínkinchja̱ha̱ David. Kui niu̱ xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná. Kinchja̱ni̱jmíyaha Juda̱, nda̱ xi ngjiko̱ já xi j'aikj'ánijé Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kui xi ta̱ kama nku nda̱ postru̱ xi nkúhu ji̱n ko̱ ta̱ kik'a̱i̱hi̱ xá xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Tu̱nga najmi ndahá kits'ín. A̱s'a̱i to̱on xi kama chjíhi̱ ra̱ kju̱a̱ najmi ndaha̱ ts'atseko̱ho nku xu'ba. A̱s'a̱i nintaku̱ tsijnehe, i̱xí kits'ohón nga tsijne ko̱ tsitju ngayjee̱ ts'ehe̱. ");
INSERT INTO majNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kint'é ngayjee̱ xu̱ta̱ xi tjíntu Jerusalen ni xi kamoo̱. Xu'baha̱ Jní 'mi a̱nte xu'bo̱, én xi tsuhu̱ ra̱ Acelda̱ma̱ nga éhe̱n. ");
INSERT INTO majNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","A̱t'aha̱ b'i̱ ts'ín tjít'a xu̱ju̱n salmo̱: Kas'e tiya ni'yaha̱ ndo̱, najmi tu̱ ch'a xi kat'ejñaya. Ko̱ b'a̱ ts'ín ta̱ tjít'a ya: Kj'a̱í xi kats'ínkjáíhi̱n xáha̱. ");
INSERT INTO majNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Kui nga a̱jihi̱n já xi kitsjenko̱ tehe̱ntehe̱ná nk'ie nga tíjñajin saná Nda̱ Nti̱a̱ná Jesu, ");
INSERT INTO majNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","b'aha̱ ra̱ nk'ie nga tsaténtáha̱ Jua ko̱ santaha ni̱stjin nga ngji nk'a ján, a̱jihi̱n já xu'bi̱ kachj'ajin nku xi ku̱i̱tsu̱yako̱ni̱ nga j'áíya ngáha̱ ra̱ Jesu ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","A̱s'a̱i i̱ncha kits'ínkjó jo já, nku xi 'mi Kuse xi ta̱ 'mi ya Barsaba, xi ta̱ Justo̱ chubaha̱, ko̱ nku xi 'mi Matia̱. ");
INSERT INTO majNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","A̱s'a̱i b'i̱ i̱ncha kitsú nga kinchja̱ko̱ Nti̱a̱ná: —Ji Nti̱a̱, yai xi nkú ts'ín tjíntuyá ani̱ma̱ha̱ ngayjee̱ xu̱ta̱. Ta̱kúchjini̱ má xi kui já xi joi̱ xi kichj'ajin ");
INSERT INTO majNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tu̱ xi ka̱maha nku nda̱ postru̱ ko̱ ts'i̱ínko̱ni̱ xá xi najmi kits'ínndju̱ú Juda̱ Iscariote̱. A̱t'aha̱ ngatitsun kits'ín Juda̱ ko̱ a̱nte xi tje̱he̱n ra̱ ngji. ");
INSERT INTO majNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","A̱s'a̱i tsasehe̱ jóo̱ yá xi ka̱ma ts'e̱ xóo̱. Tu̱ Matia̱há kikanéhe̱. Kui nga kik'a̱i̱ xáko̱ho̱ ra̱ já postru̱ xi te nkuu̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nk'ie nga tsichu ni̱stjihi̱n S'í Pentecoste, nkuhú a̱nte kama ñjakú ngayjee̱ xu̱ta̱ xi s'ejihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tu̱ janeyahá nk'a ján. B'a̱ kama xi nkú ma nga 'yún kjenima ntjo̱. Kinu'yá kui nii̱ ngayjee̱ a̱ya ni'yoo̱ xi má nga kab'entu jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","A̱s'a̱i kama chji a̱sun nintaku̱ jóo̱ ni xi b'a̱ k'un nja̱i̱ nd'í k'un nga kik'a̱i̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ngayjee̱ kitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱ ko̱ kik'atuts'i̱hi̱n nga kinchja̱ kj'a̱í kj'a̱í én xi nkú ts'ín kitsjáha̱ Espiri̱tu̱ nga ku̱i̱nchja̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kui ni̱stjiu̱n tjíntu nanki Jerusalen xu̱ta̱ judio̱ xi benkjún Nti̱a̱ná xi nibaha ngayje tíkjá nanki xi tjín a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","A̱s'a̱i kama ñjakú xu̱ta̱ nk'ie nga kint'é ni xi janeyoo̱. Ndaha najmi i̱ncha be ni xi i̱ncha ku̱i̱tsu̱, a̱t'aha̱ tu̱ éhe̱n ní i̱ncha kint'é nga nkúnkú. ");
INSERT INTO majNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tu̱ ni xí kama nkjúhu̱n ra̱ ko̱ b'i̱ ngján b'i̱ kitsúhu̱ xinkjín: —¿A najmi xu̱ta̱ Galilea̱há ngayjee̱ xi b'i̱ ts'ín tínchja̱? ");
INSERT INTO majNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nkú ts'ín én xi mahaná nga nkúnkáá tínu'yáhaná nga tíi̱ncha nchja̱ha? ");
INSERT INTO majNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","A̱t'aha̱ tjínjinná e̱i̱ xu̱ta̱ Parti̱a̱, xu̱ta̱ Medi̱a̱, xu̱ta̱ Elam, xu̱ta̱ xi nibáha a̱nte Mesopotami̱a̱, xu̱ta̱ Judea̱, xu̱ta̱ Capadoci̱a̱, xu̱ta̱ Ponto̱, xu̱ta̱ Asi̱a̱, ");
INSERT INTO majNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","xu̱ta̱ Frigi̱a̱, xu̱ta̱ Panfili̱a̱, xu̱ta̱ Egipto̱, xu̱ta̱ xi nibáha a̱nte Libi̱a̱ xi tiña maha̱ nanki Cirene̱, ko̱ xu̱ta̱ Roma̱. Tjín xi ntje̱ judio̱ tje̱he̱n ra̱ ko̱ tjín xi najmi ntje̱ judio̱ tje̱he̱n ra̱ tu̱nga s'ejihín ra̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tjín xu̱ta̱ Creta̱ ko̱ xu̱ta̱ Ara̱be̱. Ngatenteé tínu'yáá nga énná tíi̱ncha tsuyaha̱ xu̱ta̱ xu'bi̱ kju̱a̱chánka xi ts'ín Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ngayjee̱ xu̱ta̱ kama nkjúhu̱n. Ndaha najmi be ni xi ku̱i̱tsu̱. Kingjásjaiyaha̱ xinkjín: —¿Nkú tsuhu̱ ra̱ ni xu'bi̱? ");
INSERT INTO majNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","A̱s'a̱i k'u̱a̱ xi tu̱ tohón kamaha̱ ko̱ b'a̱ kitsú: —Ch'i̱hí jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","A̱s'a̱i tsasinjña ndju Pedro̱ ko̱ já postru̱ xi te nkuu̱. 'Yún kinchja̱ nga b'i̱ kitsúhu̱ xu̱ta̱ nkjiu̱n: —Jun xi ntje̱ judio̱ tje̱he̱nnu̱u ko̱ ngatentoo̱ xi tintsu̱bo̱o Jerusalen, katumankjinnu̱u ko̱ ta̱sinñju ni xi xínnu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Najmi ch'i̱ jái̱ xi nkú nga ts'ín tín'enkjíntak'un, a̱t'aha̱ a̱s'a̱ihí chu̱ba̱ ñja yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ni xi tíyo, kui ni xu'bi̱ xi kitsúya títjun nda̱ profeta̱ Joel má nga b'i̱ ts'ín y'ét'a: ");
INSERT INTO majNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","B'i̱ títsu Nti̱a̱ná: Kui nii̱ xi ka̱ma ni̱stjin xi fekuu̱, tsjaha̱ Espiri̱tu̱na̱ ngayjee̱ xu̱ta̱. Ntíx'i̱nnu̱u ko̱ ntíchju̱únnu̱u ts'a k'ue'á énna̱ nga profeta̱ ka̱ma. Já xu̱nkúnu̱u sku̱e̱ ni xi k'uejñá chjihi̱, ko̱ jáchánu̱u ku̱i̱nt'é ni xi xíhi̱n nga nijñá ján. ");
INSERT INTO majNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kui ni̱stjin xu'bo̱ tsjaha̱ Espiri̱tu̱na̱ já musu̱na̱ ko̱ jminchjín musu̱na̱, tu̱ xi ku̱i̱nchja̱ha ngajona̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ts'ian kju̱a̱nkjún nk'a ján, ko̱ kuakuchjá kju̱a̱chánkana̱ t'anankiu̱. S'e̱ jní ko̱ nd'í ko̱ ni̱nti̱ tjain. ");
INSERT INTO majNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ka̱ma jyun ts'íu̱ ko̱ xi nkúhu jní ka̱ma sóo̱. B'a̱ ka̱ma kintehe̱ ni nga ku̱i̱chú ni̱stjin xi y'énda Nti̱a̱ná, kui ni̱stjiu̱n xi chánka ko̱ nkjún tjín. ");
INSERT INTO majNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","N'e̱k'anki ngayjee̱ xi k'u̱a̱nkihi̱ Nti̱a̱ná nga ts'i̱ínnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Jun já Israel, ta̱sinñju ni xi xínnu̱u. Ya sisiun ni xi kits'ín Jesu, nda̱ xi nibáha Nazaret. Kits'ín kju̱a̱chánka ko̱ kju̱a̱nkjún ko̱ ni xi tsakúchji kju̱a̱chánkaha̱ Nti̱a̱ná. Nti̱a̱ná kitsjáha̱ nga b'a̱ kits'ín tu̱ xi y'éjña chjihi̱nu̱u nga kui kits'ín nibáha̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Y'énda títjun Nti̱a̱ná ko̱ be nkúhu nga tuts'ihi̱n ni nga já kontra̱ n'e̱kjas'ehe̱n Jesu. Jun kichjubénijó ko̱ kin'ek'ion. Já xi najmi ntje̱ Israel tje̱he̱n ra̱ kin'e chjón nga kikjat'a kruu̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tu̱nga Nti̱a̱náhá kits'ín nda̱íhi̱ a̱jihi̱n kju̱a̱'uhu̱n ngabayoo̱. Kits'ínk'íéjña tík'un ngáha̱ ra̱. Ndaha̱chí najmi kamaha̱ ngabayoo̱ kits'ínk'íéjña'yúhu̱n. ");
INSERT INTO majNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","’B'i̱ ts'ín yét'a xu̱ju̱n David nga kinchja̱ni̱jmíyaha Jesu: Kikie tehe̱nte Nti̱a̱ná nginkán, kixi̱na̱ síjñat'a tu̱ xi najmi tsankjuhunna. ");
INSERT INTO majNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kui kju̱a̱ha nga tíma tsjoho̱ ra̱ ani̱ma̱na̱, én tsjo tsu tíbitju tsu̱'bá, ko̱ tjínkuhu̱ k'an nga chúhu̱n yjonintena̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","A̱t'aha̱ najmi n'e̱ nga maní a̱ntehe̱ xu̱ta̱ k'ie̱n, najmi k'u̱a̱i̱ntei tsa kfe̱ntu nda̱ xi na̱xu̱ nginkuin. ");
INSERT INTO majNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tsakuchjíní ni̱yá xi fi má nga k'úéntu tík'un xu̱ta̱, n'e̱tsehení kju̱a̱tsjo nga kúáte̱jña nginkuin. ");
INSERT INTO majNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Jun já nts'e, xínya kixi̱ kixi̱nu̱u nga ntje̱ cháná David k'ien ko̱ kis'eyanji. Santaha ni̱stjin nd'a̱i̱ tíjñajin saná tsjóho̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kui xi kama nku nda̱ profeta̱ ko̱ kikie nga Nti̱a̱ná kitsúya kixi̱ títjuhu̱n nga ntje̱ xi ts'e̱ stjújin xi k'úéjñasun a̱ntehe̱ nga ku̱a̱téxuma. ");
INSERT INTO majNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kui nga kikie títjuhun David ni xi ka̱ma ko̱ kitsúya nga kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱ xi kits'ín nibá Nti̱a̱ná, nga najmi s'e̱jña a̱ntehe̱ xu̱ta̱ k'ie̱n ko̱ nga najmi ku̱a̱tsún yjonintehe̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","’Jesu, kui xi Nti̱a̱ná kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱ ko̱ ji̱n kiyai̱ nga b'a̱ kama. ");
INSERT INTO majNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kui xi tíyankjún nd'a̱i̱ nga tíjñat'a Nti̱a̱ná ko̱ kits'ínkjáíhi̱n Espiri̱tu̱ Santo̱ xi kitsúya títjuhu̱n Na̱'miu̱ nga tsjáha̱. Kui xi títs'ín nibá ni xi tíyo ko̱ tínu'yó nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","A̱t'aha̱ najmi David xi ngjinji nk'a ján, tu̱nga b'a̱há kitsú: Nti̱a̱ná b'a̱ kitsúhu̱ Nda̱ Nti̱a̱na̱: “Ti̱nchint'aná má batexuma, ");
INSERT INTO majNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","k'uentú maná xi fi kontra̱hi kinte tsu̱kui.” ");
INSERT INTO majNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Kui nga tjíhin nga sku̱e̱ kixi̱hi ngatentee̱ xu̱ta̱ Israel nga Jesu, xi jun kikjat'a kruu̱, kui xi Nti̱a̱ná kitsjá xáha̱ nga tíbatéxuma nd'a̱i̱. Kui xi kits'ín nibá Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nk'ie nga kint'é jóo̱ ni xu'bi̱, tu̱ ni xí kik'ie nusin nusihín ra̱. A̱s'a̱i b'i̱ i̱ncha kitsúhu̱ Pedro̱ ko̱ já postru̱ xingisoo̱: —Jun já nts'e, ¿mí ni xi tjíhin nga n'e̱i̱? ");
INSERT INTO majNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","B'i̱ kitsú Pedro̱: —Tankínchj'a̱ha̱ ru̱u ani̱ma̱nu̱u. N'e̱kjóho̱on Jesucristo̱ ko̱ sa̱téntó nga nkúnkú tu̱ xi ka̱ma ndyjat'aha̱nu̱u ngatitsunnu̱u. B'a̱ ts'ín k'u̱a̱i̱hi̱nu̱u Espiri̱tu̱ Santo̱ xi tsjánu̱u Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","A̱t'aha̱ k'u̱a̱i̱nu̱u ko̱ ku̱a̱i̱hi̱ ntínu̱u ni xi kitsúya títjun Nti̱a̱ná nga tsjáha̱ xu̱ta̱ xi ts'e̱, ko̱ ta̱ k'u̱a̱i̱hi̱ xu̱ta̱ xi kjin tjíntu, ngayjee̱ xi Nti̱a̱ná ku̱i̱nchja̱ha̱ nga ka̱ma ts'e̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kui én xu'bi̱ ko̱ kj'a̱í sa xi kitsú Pedro̱ nga kinchja̱ ko̱ nga kitsjáni̱yáha̱ xu̱ta̱. B'i̱ kitsúhu̱: —Ti̱tjujihu̱un kju̱a̱'un xi ni̱banehe̱ xu̱ta̱ xi najmi na̱xu̱ nginku̱n Nti̱a̱ná xi tjín nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","A̱s'a̱i kisaténtá xu̱ta̱ xi kits'ínkjáíhi̱n én xi y'éni̱jmí Pedro̱. Kui ni̱stjiu̱n jan mii̱ xu̱ta̱ j'aijín saha̱ xu̱ta̱ xi ja s'ejihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tehe̱nte tsasínñjuhu̱ xu̱to̱ ni xi tsakúya já postru̱. Nkuhú i̱ncha kik'a xinkjín. Kama ñjakú nga kikjine ni̱ñu̱ ko̱ nga kinchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kama nkjúhu̱n ngayjee̱ xu̱ta̱, a̱t'aha̱ nkjin kju̱a̱nkjún ko̱ ni xi tsakúchji kju̱a̱chánkaha̱ Nti̱a̱ná kits'ín já postru̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ngatentee̱ xu̱ta̱ xi s'ejihi̱n Jesu nkuhú kits'ín yjoho̱ ko̱ kits'ínchjénko̱ ngujin xinkjín ngayjee̱ ni xi tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tsatéña xu'baha̱ ko̱ ni xi tjíhi̱n ko̱ kits'ínndzjoho̱ to̱oho̱n ngayjee̱ xu̱ta̱ xi nkú tjín machjéhe̱n nga nkúnkú. ");
INSERT INTO majNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Xki̱ ni̱stjin kama ñjakú má ma na̱tsihi̱n ni̱nku̱. Ni'yaha̱ tsakjánya ni̱nku̱a̱n nga kikjineko̱ xinkjín, nga tjíntuyá tsjo ts'íhi̱n ra̱ ko̱ nga ni̱ma̱kju̱a̱ tjíntuyá ani̱ma̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","I̱ncha ts'íntsjoho̱ Nti̱a̱ná, ko̱ ngayjee̱ xu̱ta̱ na̱nti̱o̱ nda kikiehe̱. Xki̱ ni̱stjin Nti̱a̱ná kits'ín nibájin saha̱ xu̱ta̱ ni̱nku̱ kj'a̱í sa xi tíi̱ncha b'anki. ");
INSERT INTO majNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nku ni̱stjin Pedro̱ ko̱ Jua i̱ncha ngji má ma na̱tsihi̱n ni̱nku̱ nga chu̱ba̱ jan. Kui chu̱bo̱ xi tíjñaha̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ nga nchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yo̱ b'ejña nku nda̱ xi tu̱ b'a̱ ts'ín najmi mahá fi santa nkúhu nga kitsin. Xki̱ ni̱stjin n'ek'íéjña ndo̱ a̱nkju̱a̱ má ma na̱tsihi̱n ni̱nku̱ xi 'mi A̱nkju̱a̱ Tsjo Tjín tu̱ xi bankihi̱ ra̱ to̱on xu̱ta̱ xi fas'ehen na̱tsihi̱n ni̱nku̱. ");
INSERT INTO majNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nk'ie nga kikie ndo̱ nga tífas'en Pedro̱ ko̱ Jua na̱tsihi̱n ni̱nku̱, tsankihi̱ to̱on. ");
INSERT INTO majNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","A̱s'a̱i Pedro̱ ko̱ Jua i̱ncha tsasehe̱ ndo̱ ko̱ b'a̱ kitsú Pedro̱: —Cha̱se̱'ani̱. ");
INSERT INTO majNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","A̱s'a̱i tsase ndo̱ nga kikuyá nga k'u̱a̱i̱hi̱ to̱on. ");
INSERT INTO majNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tu̱nga b'i̱hí kitsú Pedro̱: —Najmi tjínna to̱ontaba ko̱ ta̱ ndaha to̱onsine xi tsjaha tu̱nga ni xi tíjñahána tsjaha. Ngajoho̱ Jesucristo̱, nda̱ xi nibáha Nazaret, an b'a̱ tíxihin: Ti̱síntje̱i̱n ko̱ ti̱tsutjai. ");
INSERT INTO majNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","A̱s'a̱i jakj'á Pedro̱ ntsja kixi̱ ndo̱ nga kikjesíntje̱n. Tje̱n'yún kisakú nga'yúhún ra̱ sjai ndo̱. ");
INSERT INTO majNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kikjennk'á ko̱ kikjatsú'ba. Sjai jas'enko̱ho Pedro̱ ko̱ Jua má ma na̱tsihi̱n ni̱nku̱. Tíkjennk'á ko̱ títs'íntsjohó ts'íhi̱n ra̱ Nti̱a̱ná nga tsú'ba. ");
INSERT INTO majNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ngayjee̱ xu̱ta̱ kikiehe̱ nga tsú'ba ndo̱ ko̱ nga títs'íntsjoho̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tu̱ ni xí kama nkjúhún ra̱ ko̱ kitsankjún nga̱t'aha̱ ni xi kamat'ain ndo̱. A̱t'aha̱ i̱ncha kamankjihi̱n nga kui ndo̱ xi b'ejña a̱nkju̱a̱ ni̱nku̱ xi 'mi A̱nkju̱a̱ Tsjo Tjín nga banki to̱on. ");
INSERT INTO majNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nda̱ xi kama nkihi̱ najmi ta̱ tíbinkféhen Pedro̱ ko̱ Jua. A̱s'a̱i ngayjee̱ xu̱ta̱ kama nkjúhun nga kama ñjakú má 'mihi̱ Kinte Ni'yaha̱ Salomon, a̱t'aha̱ yo̱ tíi̱ncha jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nk'ie nga kikie Pedro̱ ni xu'bi̱, b'i̱ kitsú: —Jun já Israel, ¿á tíma nkjúhu̱nnu̱u ni xu'bi̱? ¿Á tíchasehe̱ni̱ xi nkúhu tsa nga'yún ts'a̱ji̱n ko̱ tsa nga̱t'aha̱ tsa ji̱n su̱ba̱i̱ 'yún yankjúi̱n Nti̱a̱ná, tsa kui kju̱a̱ha nga kuan'ekjatsú'baha̱ni̱ nda̱i̱? ");
INSERT INTO majNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nti̱a̱ha̱ ntje̱ cháná Abraham, Isaac ko̱ Jacob kitsjáha̱ kju̱a̱chánka Ntíhi̱. Kui xi Jesu xi jun kin'ekjas'on ko̱ najmi kin'ekjóho̱n nginku̱n Pilato̱ nk'ie nga Pilato̱ mjehe̱ ts'i̱ín nda̱íhi̱. ");
INSERT INTO majNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Najmi kin'ekjóho̱on nda̱ xi je nginku̱n Nti̱a̱ná, nda̱ xi na̱xu̱ nginku̱n Nti̱a̱ná. Tu̱ sa ní tsinchu nga n'e̱ nda̱íhi̱ nku nda̱ xi ani̱ma̱ ts'ínk'ien. ");
INSERT INTO majNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jun kin'ek'ion nda̱ xi ts'ínk'íéntu tík'un xu̱ta̱, tu̱nga Nti̱a̱náhá kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱. Ji̱n kiyai̱ ko̱ tí'miyai̱hi̱ nga b'a̱ kama. ");
INSERT INTO majNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nga̱t'aha̱ nga s'ejinni̱ Jesu, kui kju̱a̱ha nga Jesu kuats'ínchjénni̱ nga kuatsjá nga'yúhu̱n ra̱ nda̱i̱ xi yo ko̱ tíyo e̱i̱. Nga̱t'aha̱ nga s'ejinni̱ Jesu, kui kju̱a̱ha nga kamandaha nda̱i̱ nginkun. ");
INSERT INTO majNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Be nd'a̱i̱, já nts'e, nga najmi yo ni xi kin'o ko̱ ta̱ ndaha já tjíxánu̱u najmi be ni xi kits'ín. ");
INSERT INTO majNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tu̱nga b'a̱há ts'ín kits'íntjusuhun Nti̱a̱ná ni xi kitsúya títjun nk'ie nga kits'ínkinchja̱ ngayjee̱ já profeta̱, nga tjíhin nga un sku̱e̱he̱ nda̱ xi kits'ín nibá. ");
INSERT INTO majNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kui nga tankínchj'a̱ha̱ ru̱u ani̱ma̱nu̱u ko̱ n'e̱k'óntjaiyo yjonu̱u tu̱ xi n'e̱ndyjajnuhu ngatitsunnu̱u. Tsa b'a̱ n'o̱o, Nti̱a̱ná tsjánu̱u ni̱stjin nga chjúnto̱o ");
INSERT INTO majNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ko̱ ts'i̱ín nibásenu̱u nda̱ xi y'énda títjun nga ts'i̱ín nibá. Kui xi Jesucristo̱. ");
INSERT INTO majNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kui xi tjíhin nga k'úéjña nk'a ján nd'a̱i̱ santaha nkúhu nga ku̱i̱chú ni̱stjin nga s'e̱nda ngáha ngayjee̱ ni xi tjín. Já profeta̱ha̱ Nti̱a̱ná kinchja̱ni̱jmíyaha niu̱ nk'ie. ");
INSERT INTO majNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","’Xi nkú kitsú Moise nk'ie: “Nti̱a̱ná xi Nti̱a̱nu̱u, kui xi kjésíntje̱n nku nda̱ profeta̱ xi nkúhu an. A̱jinnu̱u ku̱i̱tjuhu. Ta̱sinñju ngatentee̱ ni xi ku̱i̱tsu̱nu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A̱t'aha̱ tu̱ yáha ni xi najmi ku̱a̱sínñjuhu̱ nda̱ profeta̱ xu'bo̱ ku̱i̱ch'onsje a̱jihi̱n xu̱ta̱ Israel.” ");
INSERT INTO majNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel ko̱ ngayjee̱ já profeta̱ xi kis'e a̱skahan ta̱ kinchja̱ni̱jmíyaha ni xi tíma ni̱stjin nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","’Jun ts'a̱jun ni xi kinchja̱ já profeta̱. Ngandanu̱u Nti̱a̱ná y'éndako̱ho ntje̱ chánu̱u nk'ie nga b'a̱ kitsúhu̱ Abraham: “Ngayjee̱ xu̱ta̱ na̱xi̱nantá xi tjín a̱sunntee̱ nda ka̱mat'ain nga̱t'aha̱ ntje̱ xi s'e̱hi.” ");
INSERT INTO majNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Títjun jun Nti̱a̱ná kits'ín nibásenu̱u Ntíhi̱ nk'ie nga kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱. Nda kits'ínko̱nu̱u nga b'a̱ kits'ín ko̱ tu̱ xi k'úéntuhunu ni ch'onk'un xi manu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro̱ ko̱ Jua tíi̱ncha nchja̱ko̱ sa xu̱ta̱ na̱nti̱o̱ nk'ie nga i̱ncha j'ai já na̱'miu̱ ko̱ nda̱ k'aku̱hu̱ já xi kunntá ni̱nku̱ ko̱ já saduseo̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kui xi kama kjaha̱n a̱t'aha̱ Pedro̱ ko̱ Jua tíbakúyaha̱ xu̱ta̱ na̱nti̱o̱ ko̱ tíb'éni̱jmí nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱, a̱t'aha̱ j'áíya ngáha̱ ra̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","A̱s'a̱i jakj'ánijé jóo̱ ko̱ kits'ínkjas'en nu̱ba̱yá santaha ni̱stjin xi ma ndyjuu̱n, a̱t'aha̱ ja ngixun kui chu̱bo̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Xu̱ta̱ xi kint'é ni xi kinchja̱ Pedro̱ ko̱ Jua, nkjin maha xi kis'ejihi̱n Jesu. Un ra̱ mii̱ tsichu ma já xi kis'ejihi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ni̱stjin xi ma ndyjuu̱n kama ñjakú nanki Jerusalen já k'aku̱, jáchá xi ta̱ tjíhi̱n xá ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","J'ai Ana xi tjíhi̱n nda̱ na̱'mi títjun, ko̱ Kaifa, Jua, Alejandro̱ ko̱ ngatentee̱ já xi y'aha̱ ra̱ já na̱'mi k'aku̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A̱s'a̱i ngjichj'a Pedro̱ ko̱ Jua ko̱ kin'ekinchá a̱jihi̱n jóo̱. B'a̱ kitsú jóo̱: —¿Mí xáha xi tjínnu̱u? ¿Yá xi tíb'éxánu̱u nga b'a̱ tín'o? ");
INSERT INTO majNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","A̱s'a̱i b'i̱ kitsú Pedro̱ nga kitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱: —Jun já tjíxá ko̱ jáchá xi tjíhi̱n xá, ");
INSERT INTO majNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tín'eko̱kju̱a̱ni̱ nd'a̱i̱ nga̱t'aha̱ kju̱a̱nda xi kin'ehe̱ nku nda̱ un ko̱ xi nkú ts'ín kama nkihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kui nga tjíhin nga cha̱hanu ngatentoo̱ ko̱ ngayjee̱ xu̱ta̱ Israel nga nga̱t'aha̱ nga'yúhu̱n Jesucristo̱, nda̱ xi nibáha Nazaret, kama nkihi̱ ra̱ nda̱ xi kabasinjña e̱i̱ nginkun. Jun kingjat'a kruhu̱u Jesu tu̱nga Nti̱a̱náhá kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesu, kui ndji̱o̱ xi najmi kits'ín mje já chji̱ne̱xjóo̱ tu̱nga nd'a̱i̱ ja j'ai ma ndji̱o̱ k'aku̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Najmi tjín sa kj'a̱í xi maha̱ ts'ínk'anki xu̱ta̱. Nti̱a̱ná najmi kits'ín nibá sa kj'a̱í a̱sunntei̱ xi ka̱ma ts'i̱ínk'ankiná. ");
INSERT INTO majNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","A̱s'a̱i kama nkjúhu̱n já tjíxóo̱ nk'ie nga kint'é nga b'a̱ ts'ín ndjá tínchja̱ Pedro̱ ko̱ Jua ko̱ i̱ncha kikie nga tu̱ já tu̱ k'un tu̱ mahá niu̱ xi najmi 'yún maha̱ xu̱ju̱n. I̱ncha kamankjihi̱n nga kui jóo̱ xi y'emako̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tu̱nga najmi behé mí nihi xi kja̱nínehe̱, a̱t'aha̱ tíi̱ncha be nga nda̱ xi kama nkihi̱ kabasinjñako̱ho̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","A̱s'a̱i i̱ncha kitsjá kju̱a̱ nga ku̱i̱tju jóo̱ má tíma kju̱o̱ ko̱ kinchja̱ni̱jmíyako̱ho xinkjín niu̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","B'i̱ i̱ncha kitsú: —¿Nkú n'e̱éhe̱ jóo̱? Ngayjee̱ xu̱ta̱ xi tjíntu Jerusalen be kju̱a̱nkjún xi kits'ín jóo̱ ko̱ najmi ma b'e'máá. ");
INSERT INTO majNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tu̱nga tu̱ xi najmi ta̱ ngju̱a̱i̱ndju saha ée̱n a̱jihi̱n xu̱ta̱, kui nga tu̱ sahá ku̱i̱nchankjúhu̱n ra̱á tu̱ xi najmi ta̱ ch'a k'u̱éni̱jmíhi Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","A̱s'a̱i kinchja̱ ngáha̱ ra̱ jóo̱. Y'éch'oho̱ nga najmi ta̱ i̱ncha k'u̱éni̱jmíhi ko̱ tsa ku̱i̱nchja̱ni̱jmíyaha Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tu̱nga b'i̱hí kitsú Pedro̱ ko̱ Jua nga kinchja̱ko̱ já tjíxóo̱: —N'e̱nkjíntak'un má nihi xi b'a̱ tjín nginku̱n Nti̱a̱ná. ¿A nga jun xi ku̱i̱nú'yá'éi̱hi̱n a ra̱ Nti̱a̱náhá? ");
INSERT INTO majNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","A̱t'aha̱ ji̱n tjíhin nga ku̱i̱xínyai̱ ni xi kiyai̱ ko̱ xi kinu'yái̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","A̱s'a̱i já tjíxóo̱ tsinchánkjúhu̱n tu̱nga kits'ín nda̱íhí ra̱. Najmi kisakúhu̱ mí nihi xi ts'i̱ínnijéhe̱ ra̱, a̱t'aha̱ ngayjee̱ xu̱ta̱ kits'íntsjoho̱ Nti̱a̱ná nga̱t'aha̱ ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ts'ati yachán nú tjín ko̱ yaha̱ ra̱ nga uhu̱n nda̱ xi kamat'ain kju̱a̱nkjún xu'bi̱ nga kama nkihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nk'ie nga ja kin'e nda̱í ngáha̱ ra̱ Pedro̱ ko̱ Jua, a̱s'a̱i ngjisehe̱ xu̱ta̱ xi ts'e̱ ko̱ kitsúyaha̱ ngayjee̱ ni xi kitsú já na̱'mi k'aku̱ ko̱ jáchá xi ta̱ tjíhi̱n xá. ");
INSERT INTO majNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nk'ie nga kint'é xu̱ta̱ xingisoo̱ éi̱n, ngayjee̱ nkuhú kits'ín kju̱a̱nkjintak'uhu̱n nga i̱ncha kinchja̱ko̱ Nti̱a̱ná. B'i̱ i̱ncha kitsú: —Ji Nti̱a̱ni̱, ji xi kin'endai nk'a ján ko̱ a̱sunntee̱, ntáchak'uu̱n ko̱ ngayjee̱ ni xi tjíhín. ");
INSERT INTO majNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ntje̱ cháni̱ David xi nda̱ musu̱hi̱ kin'ekínchja̱ko̱honi Espiri̱tu̱ Santo̱. B'i̱ tsixín: ¿Á xa̱áha̱n i̱ncha ts'íhin xu̱ta̱ xi tjíhin a̱sunntee̱? ¿Á ni xi najmi chumi ni chjíhi̱ ra̱ tíi̱ncha ts'ínnkjin k'uhun? ");
INSERT INTO majNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Y'énda yjoho̱ já rei̱ xi tjín a̱sunntee̱ ko̱ kama ñjakú já tjíxóo̱. I̱ncha ngji kontra̱ha̱ Nti̱a̱ná ko̱ nda̱ xi kits'ín nibá. ");
INSERT INTO majNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’A̱t'aha̱ kju̱axi̱ nga nanki xu'bi̱ nda̱ rei̱ Herode̱ Antipa̱ ko̱ Ponci̱o̱ Pilato̱ kama ñjakúko̱ xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱ ko̱ xi najmi ntje̱ Israel tje̱he̱n ra̱ nga i̱ncha ngji kontra̱ha̱ Jesu xi Ntíhi̱, kui xi y'exáí nga kin'e nibáí. Kui xi je. ");
INSERT INTO majNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","B'a̱ ts'ín kits'íntjusuhun jóo̱ ngayjee̱ ni xi ja y'enda títjuin ko̱ xi tsixínyai nga tjíhin nga ka̱ma. ");
INSERT INTO majNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","’Nd'a̱i̱ ji Nti̱a̱ni̱, cha̱se̱i̱hi̱ ni xi mjehe̱ ts'i̱ínni̱ jóo̱. Tjeihi̱n xu̱ta̱ xi ts'i̱ nga ndjá k'u̱éni̱jmí én xi ts'i̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nga'yíhi̱n katuma nkihi̱ ra̱ xu̱ta̱ un ko̱ katuma kju̱a̱nkjún ko̱ ni xi ku̱a̱kúchji kju̱a̱chánkahi̱. N'e̱chjénni̱ nga n'e̱i̱ kui niu̱ ngajoho̱ Jesu, kui xi Ntíhi̱ ko̱ tsje. ");
INSERT INTO majNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nk'ie nga ja kamaha̱ jóo̱ nga kinchja̱ko̱ Nti̱a̱ná, ts'ajniyá a̱nte xi má nga kama ñjakú. Ngayjee̱ j'aijíhi̱n Espiri̱tu̱ Santo̱ ko̱ ndjá i̱ncha y'éni̱jmí éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nkuhú kits'ín ani̱ma̱ha̱ ko̱ kju̱a̱nkjintak'uhu̱n ngayjee̱ xi kis'ejihi̱n Jesu. Ndaha nku najmi b'a̱ kitsú tsa nkuhú kui ts'e̱ ni xi tjíhi̱n. Tu̱ sa ní ngujihín kits'ínchjénko̱ xinkjín ni xi tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","'Yún kis'ehe̱ nga'yún já postru̱ nga kitsúya nga j'áíya ngáha̱ ra̱ ngabayoo̱ Nda̱ Nti̱a̱ná Jesu ko̱ ngayjee̱ 'yún nda kits'ínko̱ho̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","A̱jihi̱n xu̱to̱ najmi kis'e xi kindyjat'aha̱ tsa mí nihi, a̱t'aha̱ ngayjee̱ xi tjíhi̱n xu'ba ko̱ tsa ni'ya tsatéña ko̱ j'aiko̱ to̱on xi kik'a̱i̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","J'ai tsjáha̱ já postru̱ ko̱ kui xi tsakjánya to̱oo̱n nga kitsjáha̱ xi nkú tjín machjéhe̱n nga nkúnkú xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Y'ejña nku nda̱ xi y'aha̱ ra̱ ntje̱ chá Levi xi kitsin xjo̱ Chipre̱ xi 'mi Kuse, xi já postru̱ y'ét'a j'áíhi̱n nga Bernabe k'úín. Kui j'áín xi tsuhu̱ ra̱: xi tsjá nga'yúhu̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bernabe tsatéña nku xu'ba xi tíjñaha̱ ko̱ j'ai tsjáha̱ já postru̱ to̱on xi kik'a̱i̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nku nda̱ xi 'mi Anania̱ ko̱ Safira̱ 'mi chju̱úhu̱n i̱ncha tsatéña nku xu'ba. ");
INSERT INTO majNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Jakj'á chuba to̱on xi kik'a̱i̱hi̱ xu'baha̱ ndo̱ ko̱ tu̱ nkuhú tíkjá j'ai tsjáha̱ já postru̱. Ta̱ kikie chju̱úhu̱n ni xi kits'ín. ");
INSERT INTO majNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","A̱s'a̱i b'i̱ kitsú Pedro̱: —Ji Anania̱, ¿á nda̱nindoo̱ jas'enjihin ani̱ma̱hi̱ nga tích'ana̱cha̱ha̱ ri̱ Espiri̱tu̱ Santo̱? Tsateñai xu'bahi̱ ko̱ tí'ba̱i̱yjeni̱ to̱oo̱n tíbixín. ");
INSERT INTO majNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kintehe̱ ni nga tsateñai xu'boo̱, ¿a najmi jihí ts'i̱? Nk'ie nga tsateñai, ¿a najmi jihí ka̱ma ts'i̱hi to̱oo̱n? ¿Á b'a̱ kitsúhu ani̱ma̱hi̱ nga kichjubéheni chuba? Nti̱a̱ná tích'ana̱cha̱i̱hi̱, najmi xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nk'ie nga kint'é Anania̱ éi̱n, tje̱n'yún j'aikijnehé nga k'ien. Tu̱ ni xí kitsankjúhún ngayjee̱ xu̱ta̱ xi kint'é ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","A̱s'a̱i j'ai k'u̱a̱ já a̱sti, kik'otikjájnu najyun yjonintee̱ ko̱ tsitjusjeko̱ nga ngjingjáyanji. ");
INSERT INTO majNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","J'a ra̱ tsa nkú ma jan ora̱ j'ai chju̱úhu̱n Anania̱ nga najmi be ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A̱s'a̱i kingjásjaiya Pedro̱: —T'inyaní, ¿a b'a̱ tjín kich'o xu'banu̱u nga tsateño? —Joho̱n, b'a̱ tjín tsateñai̱ —kitsú Safira̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","A̱s'a̱i b'i̱ kitsú Pedro̱: —¿Á kabincha'ahanu xinki̱u nga mjehe̱nu̱u chjút'ayák'uhunnu Espiri̱tu̱hu̱ Nti̱a̱ná? A̱stiu̱ a̱nkju̱o̱ yja já xi kfingjáyanji x'i̱hi̱n ko̱ ji ta̱ ngju̱a̱i̱ko̱hi nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ta̱ kuihi chu̱bo̱ j'aikijnet'a sjai Pedro̱ ta̱chjúu̱n nga k'ien. Nk'ie nga jas'en já a̱stiu̱, kikie nga kjijña k'ien ta̱chjúu̱n ko̱ tsitjuko̱ nga ngjingjáyanjit'aha̱ x'i̱hi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tu̱ xí kitsankjúhún ngayjee̱ xu̱ta̱ ni̱nku̱ ko̱ ngayjee̱ xu̱ta̱ xi kint'é ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Já postru̱ kits'ín ṉkjún kju̱a̱nkjún ko̱ ni xi tsakúchji kju̱a̱chánkaha̱ Nti̱a̱ná a̱jihi̱n xu̱ta̱, ko̱ ngayjee̱ nkuhú kik'a xinkjín nga kama ñjakú a̱nte xi 'mi Kinte Ni'yaha̱ Salomon. ");
INSERT INTO majNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ndaha nku xu̱ta̱ xingisoo̱ najmi kama k'un nga ka̱ma ngujihi̱n xu̱ta̱ xi kama ñjakú yo̱, tu̱nga xu̱ta̱ na̱nti̱o̱hó tjo ṉkjún kits'íhi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nkjin ṉkjún já ko̱ jminchjín j'aijín saha̱ xu̱ta̱ xi s'ejihi̱n Nda̱ Nti̱a̱ná Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Santaha a̱ya ni̱yátée̱ kik'onsje xu̱ta̱ xu̱ta̱ uhu̱n nga kama̱ ko̱ na̱chan kingjántusún, tu̱ xi nk'ie nga kj'u̱a̱ha Pedro̱ ndaha tsa tu̱ nk'íéhe̱n kj'u̱a̱nehe̱ xu̱ta̱ uu̱n, ka̱ma nkihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ta̱ j'ai ṉkjún xu̱ta̱ xi tjíntu a̱ndai nanki Jerusalen nga j'aiko̱ xu̱ta̱ uhu̱n ko̱ xi tjíntujíhi̱n jánindoo̱. Ngayjee̱ kama nkihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","A̱s'a̱i tu̱ ni xí kama xintak'uhún nda̱ na̱'mi títjuu̱n ko̱ ngayjee̱ já xi mako̱ho̱, kui xi já saduseo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kits'ínkji já xi jakj'ánijé já postru̱ ko̱ kits'ínkjas'en nu̱ba̱yá. ");
INSERT INTO majNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tu̱nga nk'iehé nga ni̱stje̱n nku ntítsjehe̱ Nti̱a̱ná kikjex'á nu̱ba̱yóo̱ ko̱ kik'onsje jóo̱ nga b'i̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Tankíún. Ti̱ncho má ma na̱tsihi̱n ni̱nku̱ ko̱ t'inyoho̱o xu̱ta̱ ngayjee̱ én xi tsjá kju̱a̱tík'un. ");
INSERT INTO majNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","A̱s'a̱i kits'íntjusun já postru̱ én xi kik'ihi̱n. Ni̱stjin xi ma ndyjuu̱n jas'en má ma na̱tsihi̱n ni̱nku̱ ko̱ tsakúya. A̱s'a̱i j'ai nda̱ na̱'mi títjuu̱n ko̱ já xi mako̱ho̱ a̱nte má nga ma ñjakúko̱ xinkjín ko̱ kinchja̱ ñjaha̱ ngayjee̱ já k'aku̱hu̱ xu̱ta̱ Israel. Kitsjá kju̱a̱ nga ngju̱a̱i̱chj'a já postru̱ a̱ya nu̱ba̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tu̱nga nk'iehé nga tsichu nu̱ba̱yóo̱ já xi kunntá ni̱nku̱, najmi kisakúhu̱ já postru̱. A̱s'a̱i kik'óya ngáha nga j'aiko̱ én. ");
INSERT INTO majNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","B'i̱ i̱ncha kitsú: —Tjíchja tsjan tsjan a̱nkju̱a̱ nu̱ba̱yóo̱ nga kuichii̱ ko̱ tíi̱nchasti a̱nkju̱o̱ já xi tíkunntá yo̱. Tu̱nga nk'iehé nga kuachjux'ái̱, ndaha nku najmi kuayai̱ a̱yoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nk'ie nga kint'é én xu'bi̱ nda̱ na̱'mi títjuu̱n ko̱ já na̱'mi k'aku̱ ko̱ nda̱ k'aku̱hu̱ já xi kunntá ni̱nku̱, ndaha najmi ta̱ be mí ni xi ku̱i̱tsu̱. Kingjásjaiyaha̱ xinkjín má ku̱i̱chúkjet'a ni xi tímoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tu̱nga b'a̱há j'ai tsú nku nda̱: —Jun, já xi kin'ekjas'on nu̱ba̱yá tíi̱ncha na̱tsihi̱n ni̱nku̱ ko̱ tíbakúyaha̱ xu̱ta̱ na̱nti̱o̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","A̱s'a̱i nda̱ k'aku̱hu̱ já xi kunntá ni̱nku̱ ko̱ já xi yjankihi̱ i̱ncha ngjikj'á já postru̱. Najmi i̱ncha kits'ín'uhu̱n nga j'aiko̱, a̱t'aha̱ tsankjún tsa ndji̱o̱ k'u̱éhe̱ xu̱ta̱ na̱nti̱o̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nk'ie nga j'aiko̱, tsinchá nginku̱n já tjíxá xi kama ñjakú yo̱. A̱s'a̱i b'i̱ kitsúhu̱ nda̱ na̱'mi títjuu̱n: ");
INSERT INTO majNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Ja b'a̱ kik'in sisinnu̱u nga ndaha̱chí najmi ka̱ma k'úéni̱jmíhu̱u Jesu xu̱ta̱, tu̱nga tu̱ sahá b'a̱ tín'o. Ngayjee̱ xu̱ta̱ Jerusalen be ni xi tíbakuyó, ko̱ mjenu̱u nga ji̱n ch'a̱njii̱ ngabayaha̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","A̱s'a̱i b'i̱ kitsú Pedro̱ ko̱ já postru̱ xingisoo̱: —Títjun tjíhin nga ku̱i̱nú'yá'éi̱hi̱n Nti̱a̱ná nga xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jun kin'ek'ion Jesu nga kikjat'a kruu̱, tu̱nga Nti̱a̱ha̱ ntje̱ cháháná kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nti̱a̱ná kitsjáha̱ kju̱a̱chánka nga kits'ín nga y'ejñat'aha̱. Kui xi tíjña títjun nd'a̱i̱ ko̱ xi ts'ínk'anki xu̱ta̱, tu̱ xi tsjáha̱ ra̱ xu̱ta̱ Israel nga ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱ ko̱ ka̱ma ndyjat'aha̱ jéhe̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ji̱n kiyai̱ ko̱ tíbixínyai̱ ni xu'bi̱ ko̱ Espiri̱tu̱ Santo̱ ya, Espiri̱tu̱ Santo̱ xi Nti̱a̱ná tsjáha̱ xu̱ta̱ xi nt'é'éhe̱n. ");
INSERT INTO majNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nk'ie nga kint'é já tjíxóo̱ én xu'bi̱, tu̱ ni xí 'yúhún kama kjaha̱n, santaha kama mjehe̱ nga ts'i̱ínk'ien já postru̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tu̱nga nkuhú nda̱ fariseo̱ xi 'mi Gamaliel, xi nku nda̱ chji̱ne̱'én xi bakúya kju̱a̱téxumoo̱ ko̱ xi benkjúhu̱n ngayjee̱ xu̱ta̱, kui xi b'a̱ kitsú nga ku̱i̱ch'onsje kutju já postru̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","A̱s'a̱i b'i̱ kitsúhu̱ já tjíxá xingisoo̱: —Jun xi ntje̱ Israel tje̱he̱nnu̱u, nda nda cha̱so̱o tsa mí nihi xi n'o̱ho̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","A̱t'aha̱ xi nkú kama nd'a̱i ngáha, nda̱ chánka kits'ín ma yjoho̱ nda̱ Teuda̱ ko̱ ma ra̱ ñju unchan já xi kitsjennkíhi̱. Tu̱nga kin'ek'iehén ndo̱ ko̱ kindzjoya ngayjee̱ xi kitsjennkíhi̱. B'a̱ ts'ín tsichukjehe ni xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ko̱ a̱skan ngáha, ni̱stjin nga tís'exki̱ ngayjee̱ xu̱ta̱, j'ai Juda̱, nda̱ xi nibáha a̱nte Galilea̱, ko̱ nkjin ṉkjún xu̱ta̱ kitsjennkíhi̱. Tu̱nga ta̱ kin'ek'iehén ndo̱ ko̱ kindzjoya ngayjee̱ xi kitsjennkíhi̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","’Kui b'a̱ maha, b'a̱ tíxihi̱nnu̱u nd'a̱i̱. Najmi tu̱ nungijiun yjonu̱u ni xi tíi̱ncha ts'ín já xu'bi̱. Najmi tu̱ jun nkú n'oho̱o. A̱t'aha̱ tsa ts'e̱ xu̱ta̱ a̱sunntei̱ ni xi tíi̱ncha ts'ín jóo̱, ku̱i̱chúkje. ");
INSERT INTO majNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tu̱nga tsa Nti̱a̱náhá ts'e̱ niu̱, najmi ka̱manu̱u n'e̱kjio. Kutsa santahá ni ko̱ Nti̱a̱ná tíbankíún kontro̱o. ");
INSERT INTO majNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A̱s'a̱i kits'ínkjáíhi̱n já tjíxóo̱ ni xi kitsú Gamaliel. Kinchja̱ha̱ já postru̱, kingjáha̱ ko̱ y'éjña nkjúhu̱n nga k'u̱éni̱jmíyaha Jesu. I̱ncha kits'ín nda̱í ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","I̱ncha tsitju já postru̱ nginku̱n já tjíxóo̱ nga tsjo tíi̱ncha ma ts'íhi̱n ra̱, a̱t'aha̱ Nti̱a̱ná kitsjántehe̱ nga un sku̱e̱he̱ nga̱t'aha̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ngayje ni̱stjin tsakúya tehe̱nte ko̱ y'éni̱jmí má ma na̱tsihi̱n ni̱nku̱ ko̱ xki̱ ni'ya nga Jesu xi kits'ín nibá Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ni̱stjin nk'ie nga ja tíi̱ncha ma nkjin xu̱ta̱ xi yjankihi̱ Jesu, a̱s'a̱i xi nchja̱ én griego̱ b'a̱ kitsú nga najmi nda títs'ín xi nchja̱ én hebreo̱. B'a̱ i̱ncha kitsú nga najmi nda tíchasehe̱ jminchjín xi nchja̱ én griego̱ xi ja k'ien x'i̱hi̱n nk'ie nga tímandzjo nichine xki̱ ni̱stjin. ");
INSERT INTO majNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","A̱s'a̱i já postru̱ xi te joo̱ kinchja̱ ñjaha̱ ngayjee̱ xu̱ta̱ ni'yakuyáha̱ Jesu ko̱ b'i̱ kitsúhu̱: —Ji̱n tjíhin nga k'úéni̱jmíi̱ éhe̱n Nti̱a̱ná. Najmi nda tjín tsa k'úéjñai̱ nga b'a̱ n'e̱i̱, tsa tu̱ xi yámixo̱ cha̱se̱he̱ ri̱. ");
INSERT INTO majNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kui nga jun, já nts'e, ti̱nchísjaihinu a̱jinnu̱u yatu já xi yankjún, xi kitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱ ko̱ xi na̱nka̱ ts'ínnkjink'un, tu̱ xi k'u̱a̱i̱hi̱ ri̱ xá xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","B'a̱ ts'ín ji̱n n'e̱kjas'ehe̱n ri̱ yjoni̱ nga chu̱bako̱i̱ Nti̱a̱ná ko̱ nga k'úéni̱jmíi̱ éhe̱n. ");
INSERT INTO majNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ngayjee̱ xu̱ta̱ kits'ínkjáíhi̱n ni xi kitsú já postru̱ ko̱ j'ájin já xu'bi̱: Esteba̱n, nku nda̱ xi 'yún s'ejihi̱n Nti̱a̱ná ko̱ xi kitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱, Felipe̱, Proco̱ro̱, Nicanor, Timon, Parmena̱, ko̱ Nicola, nda̱ xi nibáha nanki Antiokia̱. Kui nda̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱ tu̱nga jahá nd'a̱i s'ejihi̱n ra̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Já postru̱ jaich'áha̱ já xi yatui̱. A̱s'a̱i já postru̱ kinchja̱ntjai jóo̱ nginku̱n Nti̱a̱ná ko̱ kingjénne ntsja. ");
INSERT INTO majNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","'Yún ngjindju éhe̱n Nti̱a̱ná nanki Jerusalen ko̱ 'yún nkjin kama xu̱ta̱ ni'yakuyáha̱ Jesu. Ta̱ nkjin já na̱'mi kis'ejihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteba̱n 'yún nda kits'ínko̱ho̱ Nti̱a̱ná ko̱ kitsjáha̱ nga'yún. Kits'ín kju̱a̱nkjún ko̱ ni i xi tsakúchji kju̱a̱chánkaha̱ Nti̱a̱ná a̱jihi̱n xu̱ta̱ na̱nti̱o̱. ");
INSERT INTO majNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","A̱s'a̱i k'u̱a̱ xu̱ta̱ ni'ya sinagoga̱ xi 'mi Sinagoga̱ha̱ Xu̱ta̱ Nda̱í i̱ncha ngji kontra̱ha̱ Esteba̱n, ko̱ k'u̱a̱ xu̱ta̱ Cirene̱ ya, ko̱ xu̱ta̱ Alejandria̱, ko̱ k'u̱a̱ xi nibáha a̱nte Cilici̱a̱ ko̱ a̱nte Asi̱a̱. Kui xi i̱ncha y'ésiko̱ Esteba̱n. ");
INSERT INTO majNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tu̱nga najmi kamahá ra̱ kits'ín ngana̱ha̱, a̱t'aha̱ Espiri̱tu̱ Santo̱ kitsjáha̱ Esteba̱n kju̱a̱nkjink'un na̱nka̱ nga kinchja̱. ");
INSERT INTO majNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","A̱s'a̱i i̱ncha y'échjíhi̱ k'u̱a̱ já tu̱ xi b'a̱ ku̱i̱tsu̱hu nga kui xi kint'é nga Esteba̱n ch'on kitsúhu̱ Moise ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","B'a̱ ts'ín tsinchákjaha̱n ra̱ xu̱ta̱ na̱nti̱o̱ ko̱ jáchá xi tjíhi̱n xá ko̱ já chji̱ne̱'éhe̱n kju̱a̱téxumoo̱. A̱s'a̱i ngjikj'ánijé Esteba̱n ko̱ ngjiko̱ má nga ma ñja já tjíxóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ta̱ i̱ncha j'aiko̱ já testiyu̱ tsank'á xi b'i̱ kitsú: —Kui nda̱i̱ tu̱ nku én ch'on tsuhú títsuhu̱ ni̱nku̱hu̱ Nti̱a̱ná ko̱ kju̱a̱téxumoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kinu'yái̱ nga b'a̱ kitsú nga Jesu, nda̱ xi nibáha Nazaret, ts'i̱ínkatsúnya ni̱nku̱ xu'bi̱ ko̱ nga ts'i̱ínk'óntjaiya sin xi kich'aá xi tsakúyaná Moise. ");
INSERT INTO majNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","A̱s'a̱i ngayjee̱ já tjíxá xi kab'entu yo̱ tsasehe̱ Esteba̱n ko̱ kikie nga b'a̱ tjín a̱nkjín ntítsje tjín a̱nkjín Esteba̱n. ");
INSERT INTO majNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","A̱s'a̱i nda̱ na̱'mi títjuu̱n kingjásjaiyaha̱ Esteba̱n: —¿A kju̱axi̱ ni xi tíi̱ncha tsu jóo̱? ");
INSERT INTO majNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A̱s'a̱i b'i̱ kitsú Esteba̱n: —Jun xi ntje̱ Israel tje̱he̱nnu̱u ko̱ jun xi tjínnu̱u xá, ta̱sinñju manú. Nti̱a̱ chánkaná tsakúchjihi̱ yjoho̱ ntje̱ cháná Abraham nk'ie nga tíjña sa a̱nte Mesopotami̱a̱, kintehe̱ ni nga ngju̱a̱i̱k'iejña nanki Haran. ");
INSERT INTO majNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","B'a̱ kitsúhu̱: “Ti̱tjui nankihi̱ ko̱ t'entui xu̱ta̱ xinki̱. T'ihi̱nnchin a̱nte xi kuakuhu.” ");
INSERT INTO majNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","A̱s'a̱i tsitju Abraham a̱ntehe̱ xu̱ta̱ Caldea̱ ko̱ ngjik'iejña nanki Haran. Nk'ie nga k'ien na̱'mihi̱ Abraham, Nti̱a̱ná kits'ín nibáha̱ má tintsu̱bo̱o nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","’E̱i̱ najmi kitsjáha̱ a̱nte xi ka̱ma ts'e̱, ndaha nku te má ka̱ma ku̱a̱sín tsu̱ku̱. Tu̱nga kitsúya títjuhún ra̱ nga tsjáha̱ nga ka̱ma ts'e̱ e̱i̱ má tintsu̱bo̱o nd'a̱i̱ ko̱ nga ntje̱ xi s'e̱he̱ a̱skahan ta̱ ka̱ma ts'e̱, ndaha tsa najmi tjíhi̱n ntí Abraham kui ni̱stjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nti̱a̱ná b'a̱ kitsú yaha̱ Abraham nga ntje̱ xi s'e̱he̱ k'úéntu má nga najmi kui ts'e̱, ko̱ nga xu̱ta̱ musu̱ n'e̱ ma, ko̱ nga ñju unchan nú tjíhin un sku̱e̱he̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","B'a̱ kitsú ya Nti̱a̱ná: “An ts'inko̱kju̱a̱ xu̱ta̱ xi musu̱ ts'i̱ín maha̱. A̱skahan i̱ncha ku̱i̱tju yo̱ ko̱ ts'i̱íntsjona a̱nte xu'bi̱.” ");
INSERT INTO majNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","’Nti̱a̱ná b'a̱ kitsúhu̱ nga ts'i̱ín ni circuncision, tu̱ xi b'a̱ ts'ín sa̱kúchji ni nda xi y'éndako̱. Kui b'a̱ maha, nk'ie nga kitsihin Isaac ko̱ nga ja tjíhi̱n jin ni̱stjin, Abraham kits'íhi̱n ni circuncision. Isaac b'a̱ ta̱ kits'íhi̱n Jacob, ko̱ Jacob b'a̱ ta̱ kits'íhi̱n ntí xi te joho̱, xi kama ntje̱ cháná. ");
INSERT INTO majNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Kits'ínnchi̱ni̱hi̱ já nts'e̱ Kuse ko̱ tsatéñaha̱ xu̱ta̱ xí tjín a̱nte Egipto̱. Tu̱nga Nti̱a̱náhá tsasinko̱ho̱ Kuse ");
INSERT INTO majNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ko̱ kits'ínkj'a t'axíhi̱n ngayjee̱ kju̱a̱'un xi kisatéjin. Kitsjáha̱ kju̱a̱nkjintak'un na̱nka̱ ko̱ kju̱a̱nda nginku̱n nda̱ faraon, xi nda̱ rei̱hi̱ xu̱ta̱ Egipto̱. Nda̱ rei̱ kitsjá xáha̱ Kuse nga ka̱ma nda̱ títjuhu̱n xu̱ta̱ Egipto̱ ko̱ nda̱ k'aku̱hu̱ ngayjee̱ xu̱ta̱ xi tjín ni'yaha̱ nda̱ rei̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’A̱s'a̱i kis'e kjintíá ko̱ kju̱a̱'un chánka ngayjee̱ a̱nte Egipto̱ ko̱ a̱nte Canaan, má nga tjíntu ntje̱ cháná. Najmi ta̱ kisakúhu̱ ra̱ nichine. ");
INSERT INTO majNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nk'ie nga kint'é én Jacob nga Egipto̱ tjín tuni̱ñu̱, kits'ínkji ntíhi̱ xi ntje̱ cháná maha ni̱yá xi tjuhun. ");
INSERT INTO majNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ko̱ ni̱yá xi ma joho Kuse tsakúchjihi̱ yjoho̱ já nts'e̱. B'a̱ ts'ín kikiehe nda̱ faraon xu̱ta̱ xi ts'e̱ Kuse. ");
INSERT INTO majNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","’A̱s'a̱i b'a̱ kitsú Kuse nga ngju̱a̱i̱chj'a Jacob xi na̱'mihi̱ maha ko̱ ngayjee̱ xu̱ta̱ xi y'aha̱ ra̱, xi cháte ko̱ kan ún maha. ");
INSERT INTO majNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","B'a̱ ts'ín j'aik'iejñaha Jacob Egipto̱ ko̱ yo̱ k'ien. Ta̱ yo̱ ya i̱ncha k'ien ntíhi̱ xi kama ntje̱ cháná. ");
INSERT INTO majNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","A̱skahan ngji s'eyanji Jacob nanki Sikem, má nga tíjña tsjó xi ts'atse Abraham nga kitsjáha̱ to̱ontaba ntíhi̱ Hamor. ");
INSERT INTO majNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Nk'ie nga tsichu tiña ni̱stjin nga ts'i̱íntjusun Nti̱a̱ná ni xi kitsúya títjuhu̱n Abraham, 'yún nkjin kama sa xu̱ta̱ná xi kik'ientu Egipto̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","A̱s'a̱i tsatéxuma yo̱ kj'a̱í nda̱ rei̱ xi najmi be Kuse. ");
INSERT INTO majNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kui xi ts'ana̱cha̱ha̱ xu̱ta̱ná ko̱ kits'ín'uhu̱n ntje̱ cháná. Kits'ín kju̱a̱'yúhu̱n ra̱ nga k'u̱éntu masen ntíhi̱ tu̱ xi ku̱a̱yáha. ");
INSERT INTO majNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","’Kui ni̱stjiu̱n kitsin Moise ko̱ Nti̱a̱ná kisasíhi̱n Moise. Jan sá kamaha̱ xi cháha̱ nga kikuhu̱n. ");
INSERT INTO majNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nk'ie nga kis'ejña masen, ta̱kjíhi̱n nda̱ faraon jakj'áha̱ ko̱ kits'íncháha̱ xi nkúhu tsa ntíhi̱ maha. ");
INSERT INTO majNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","B'a̱ ts'ín tsangiyaha Moise ngayjee̱ ni xi maha̱ xu̱ta̱ Egipto̱. Nku nda̱ chánka kama. Kinchja̱ ko̱ tse ni xi kits'ín. ");
INSERT INTO majNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Nk'ie nga jehe̱ yachán nú Moise, ani̱ma̱ha̱ nibaha̱ ra̱ nga ngjitsubek'ún xu̱ta̱ xinkjín, xi xu̱ta̱ Israel. ");
INSERT INTO majNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nk'ie nga kikie nga tín'e'uhu̱n nku nda̱ xi ntje̱ Israel tje̱he̱n ra̱, tsasinko̱. Kits'ínk'ien nda̱ Egipto̱ xi b'a̱ kits'íhi̱n. B'a̱ ts'ín kits'ín ngajoyaha ni xi tín'ehe̱ nda̱ xi ntje̱ Israel tje̱he̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A̱t'aha̱ b'i̱ kitsú Moise nga kits'ínnkjink'un: “Ka̱mankjihi̱n xu̱ta̱ xinkjíán nga an ts'i̱ínchjénna Nti̱a̱ná tu̱ xi ka̱ma nda̱íhi̱ ra̱ xu̱ta̱na̱.” Tu̱nga najmi b'a̱há ts'ín kits'ínnkjink'un xu̱to̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","’Ni̱stjin xi ma ndyjuu̱n kikie Moise nga jo já xi ntje̱ Israel tje̱he̱n ra̱ tíi̱ncha kjánko̱ xinkjín ko̱ mjehe̱ nga ku̱a̱tekj'áíyaha̱ jóo̱. B'i̱ kitsúhu̱: “Jun já, nts'o mahanu xinki̱u. ¿Á ta̱ jun tín'e'uhu̱n ru̱u xinki̱u?” ");
INSERT INTO majNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","A̱s'a̱i nda̱ xi títs'ín'uhu̱n nda̱ xinkuu̱ kitsuniña Moise nga b'a̱ kitsúhu̱: “¿Yá xi kitsjá xáhi nga ji xi ka̱mai nda̱ k'aku̱ni̱ ko̱ nga cha̱se̱i̱hi̱ tsa nda ko̱ tsa najmi nda tín'ei̱? ");
INSERT INTO majNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A ko̱hó an mjehi n'e̱k'ienní xi nkú ts'ín kin'ek'iein nda̱ Egipto̱ kujña̱?” ");
INSERT INTO majNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nk'ie nga kint'é Moise éi̱n, tsanka ko̱ ngjik'iejña a̱nte Madian. Yo̱ y'ejñasún ko̱ yo̱ kis'entuhu̱ jo ntí. ");
INSERT INTO majNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Nk'ie nga j'a yachán nú, nku ntítsje j'aisehe̱ Moise a̱nte kixiu̱ tiña a̱sunntu tje̱nki̱ Sinai. A̱jihi̱n nku na̱'yá ntsje̱ xi títi tsakúchjihi̱ yjoho̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kama nkjúhu̱n Moise nk'ie nga kikie ni xi tíma chjihi̱ ko̱ ngjise tiñaha̱ tu̱ xi ku̱a̱se̱ sisihi̱n ra̱. Tu̱ kint'éhé nta̱ha̱ Nti̱a̱ná nga b'a̱ kitsúhu̱: ");
INSERT INTO majNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“An xi Nti̱a̱ha̱ ntje̱ cháhi̱, Nti̱a̱ha̱ Abraham, Isaac ko̱ Jacob.” Ts'atsé nkjún Moise ko̱ najmi kama k'un nga tsase. ");
INSERT INTO majNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","B'a̱ kitsú Nti̱a̱ná: “N'e̱sjei tja̱ba̱xín ntéhi̱, a̱t'aha̱ a̱nte nkjúhún má nga kabisinjñai. ");
INSERT INTO majNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tíbe kju̱a̱ni̱ma̱ xi tíf'a xu̱ta̱ xi ts'a̱n xi tjíntu Egipto̱ ko̱ tínt'e nga un tíi̱ncha maha̱. Kaf'ái̱je̱n tu̱ xi ts'in nda̱íhi̱ ra̱. T'endai yjohi̱. An ts'inkjíhi Egipto̱.” ");
INSERT INTO majNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Najmi kits'ín mjehe̱ jóo̱ Moise nga b'i̱ kik'ihi̱n: “¿Yá xi kitsjá xáhi nga ji xi ka̱mai nda̱ k'aku̱ni̱ ko̱ nga cha̱se̱i̱hi̱ tsa nda ko̱ tsa najmi nda tín'ei̱?” Tu̱nga kuihí Moise xi kama chjihi̱ ntítsjehe̱ Nti̱a̱ná a̱jin na'yá ntsje̱ xi títiu̱. B'a̱ ts'ín Nti̱a̱ná kits'ínkjihi̱ ra̱ ko̱ kik'a̱i̱ xáha̱ nga kui xi kama nda̱ k'aku̱hu̱ xu̱ta̱ná ko̱ nga ts'i̱ín nda̱íhi̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kui xi kik'onsje xu̱ta̱ná Egipto̱. Yachán nú tjíhin kits'ín kju̱a̱nkjún ko̱ ni xi tsakúchji kju̱a̱chánkaha̱ Nti̱a̱ná Egipto̱ ko̱ a̱jihi̱n Ntáchak'un Niu̱ ko̱ a̱nte kixiu̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","’Kui Moise xi b'a̱ kitsúhu̱ xu̱ta̱ Israel: “Nti̱a̱ná kjésíntje̱n nku nda̱ profeta̱ xi nkúhu an. A̱jinnu̱u ku̱i̱tjuhu.” ");
INSERT INTO majNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kui Moise xi y'ejñajihi̱n xu̱ta̱ nga kama ñjakú nk'ie nga y'entu a̱nte kixiu̱. Kinchja̱ko̱ ntítsjee̱ a̱sunntu tje̱nki̱ Sinai ko̱ ta̱ kinchja̱ko̱ ntje̱ cháná. Kik'a̱i̱hi̱ nga tsjáná én xi ts'ínk'íéntu tík'unná. ");
INSERT INTO majNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Tu̱nga ntje̱ cháná najmi kama mjehe̱ nga ku̱i̱nt'é'éhe̱n. Tu̱ sahá kits'ín t'axín ko̱ kama mjehe̱ nga k'o̱óya ngáha Egipto̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","B'a̱ i̱ncha kitsúhu̱ Aaron: “N'e̱ndani̱ nti̱a̱ xi tsjén títjunni̱, a̱t'aha̱ najmi yai̱ mí nihi xi kamaha̱ Moise, nda̱ xi kik'onsjeni̱ Egipto̱.” ");
INSERT INTO majNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","A̱s'a̱i i̱ncha kits'ínnda nku turu̱ nti̱a̱ ko̱ kits'ínk'ien chu̱ nga kitsjáha̱ chje̱. Kits'íntsjoho̱ ni xi ntsja kits'ínndako̱ho. ");
INSERT INTO majNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","’A̱s'a̱i Nti̱a̱ná najmi ta̱ kits'ínsihi̱n ra̱ xu̱ta̱ xu'bo̱. Kitsjántehe̱ nga ts'i̱íntsjoho̱ niñu xi tjín nk'a ján. B'a̱ kama xi nkú ts'ín tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná xi y'ét'a já profeta̱: Jun xu̱ta̱ Israel, ¿a ahán kik'a̱i̱nú chje̱, nk'ie nga tintsu̱bo̱o a̱nte kixiu̱ yachán nú tjíhin? ");
INSERT INTO majNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ni'ya najyuntehe̱ ní nti̱a̱ Moloc ko̱ niñuhu̱ nti̱a̱ Renfan tsankinko̱o. Sénni̱stjin kin'endo tu̱ xi n'e̱tsjoho̱ru̱u, kui nga kjin ts'inkjíhi̱nu̱u xi tje̱hen a̱stu̱n Babiloni̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Kits'ínnda Moise ni̱nku̱ najyunte xi bakúchji nga Nti̱a̱ná tíjñajihi̱n xu̱ta̱ xi ts'e̱. Kin'enda xi nkú ts'ín kisakúchjihi̱ nga ka̱manda. B'a̱ ts'ín a̱nte kixiu̱ kis'ejñaha̱ ra̱ ntje̱ cháná ni̱nku̱ najyuntee̱ xi nkú nga kitsú Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kik'a̱i̱hi̱ ntje̱ cháná nga ka̱ma ts'e̱ niu̱. I̱ncha y'a nk'ie nga i̱ncha jas'en e̱i̱ má tintsu̱bo̱o nd'a̱i̱, ni̱stjin nk'ie nga tjíhi̱n xá Josue ko̱ kikjánko̱ xu̱ta̱ xi tjíntu e̱i̱, xi Nti̱a̱ná kik'onsje ngandaha̱ ntje̱ cháná. B'a̱ ts'ín kis'ejña ni̱nku̱ najyuntee̱ santaha nkúhu nga y'ejña nda̱ rei̱ David. ");
INSERT INTO majNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","’Nti̱a̱ná kisasíhi̱n David ko̱ David kama mjehe̱ nga ts'i̱índaha̱ nku a̱nte Nti̱a̱ná, Nti̱a̱ha̱ ntje̱ cháná Jacob. ");
INSERT INTO majNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tu̱nga Salomon kits'ínndaha̱ ni'ya Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","B'a̱ tjín kjáíhin nga nk'a ján tíjña Nti̱a̱ná ko̱ nga najmi b'ejñaya ni'ya xi ts'ínnda xu̱ta̱. A̱t'aha̱ b'a̱ ts'ín y'ét'a éhe̱n Nti̱a̱ná nda̱ profeta̱: ");
INSERT INTO majNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ndji̱o̱jmi ján báte̱jña nga batexuma, ko̱ t'anankiu̱ basinjñásan tsu̱ká. ¿Mí ni'yaha xi n'e̱ndanú, títsu Nti̱a̱ná, ko̱ má a̱ntehe ka̱ma ts'inkj'áíya? ");
INSERT INTO majNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","An ní kits'inndá ngayjee̱ ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","B'a̱ ta̱ kitsú ya Esteba̱n nga ngjindju: —Tu̱nga jun najmi mjenu̱u ku̱i̱nú'yá'ón. B'a̱ ts'ín nu'yó ko̱ tjíya ani̱ma̱nu̱u xi nkú joyaha xu̱ta̱ xi najmi be Nti̱a̱ná. Nkuhú nga tintsu̱ba̱ kontra̱ha̱ ru̱u Espiri̱tu̱ Santo̱. Jun xi b'a̱ k'un xi nkúhu ntje̱ chánu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Má já profeta̱ha xi najmi kitsjennkí unkie ntje̱ chánu̱u? Kits'ínk'ien já xi kitsúya títjun nga kj'u̱a̱í nda̱ xi na̱xu̱ ts'i̱ín. Ko̱ nk'ie nga j'ai ndo̱, jun kin'ekjas'on ko̱ kin'ek'ion. ");
INSERT INTO majNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jun bi ntítsje kits'ínkjas'ennu̱u kju̱a̱téxumaha̱ Nti̱a̱ná tu̱nga najmi tín'etjusunnú. ");
INSERT INTO majNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nk'ie nga kint'é já tjíxóo̱ ni xi kitsú Esteba̱n, tu̱ ni xí i̱ncha kama kjahán ra̱ ko̱ i̱xí tsatehé ni̱'yu̱n. ");
INSERT INTO majNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tu̱nga máha Esteba̱n, kitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱. Tsasenjinki nk'a ján ko̱ kikie kju̱a̱chánkaha̱ Nti̱a̱ná ko̱ nga Jesu kabasinjñat'aha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","B'i̱ kitsú: —¡Cha̱so̱o! Tíbe nga tje̱n ti̱xa̱ ndji̱o̱jmi ján ko̱ nga Ntíhi̱ Nda̱x'i̱u̱n kabasinjñat'aha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Najmi ta̱ tsasínñjuhu̱ ra̱ jóo̱ Esteba̱n. Xa̱áha̱n i̱ncha kits'ín. Ngatentee̱ nkuhú nga ngjikj'á. ");
INSERT INTO majNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","I̱ncha kik'onsje na̱tsihi̱n na̱nti̱o̱ ko̱ yo̱ i̱ncha y'éhe̱ ndji̱o̱. Nku nda̱ti xi 'mi Saulo̱ kikunntá najyuhu̱n já testiyu̱ tsank'óo̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nk'ie nga tís'ehe̱ ndji̱o̱ Esteba̱n, b'i̱ kitsú nga kinchja̱ko̱ Nti̱a̱ná: —Ji Nda̱ Nti̱a̱ Jesu, n'e̱kjáíhi̱n ani̱ma̱na̱. ");
INSERT INTO majNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","A̱s'a̱i tsasinkúnch'in ko̱ 'yún kikjintáya nga b'i̱ kitsú: —Ji Nda̱ Nti̱a̱, najmi tu̱ ch'axki̱hi̱ ri̱ jái̱ ngatitsun xu'bi̱. Nk'ie nga ja b'a̱ kitsú, k'ien. ");
INSERT INTO majNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kisasíhi̱n Saulo̱ nga kin'ek'ien Esteba̱n, ko̱ ta̱ kuihi ni̱stjin xu'bo̱ kich'atuts'i̱hi̱n nga tu̱ ni xí kitsjennkí unchahá xu̱ta̱ ni̱nku̱ xi tjín nanki Jerusalen. Kindzjoyayje nga ngji a̱nte xi tjín Judea̱ ko̱ Samari̱a̱. Tu̱ já postru̱ y'entu subahá sa Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","K'u̱a̱ já xi nda tjíntuyáha̱ kingjáyanji Esteba̱n ko̱ kikjintát'a. ");
INSERT INTO majNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tu̱nga tu̱ xí kitsjenkí unkiehé Saulo̱ xu̱ta̱ ni̱nku̱. Xki̱ ni'ya jas'en nga kikjebéfe jáx'i̱n ko̱ jminchjín ko̱ kits'ínkjas'en nu̱ba̱yá. ");
INSERT INTO majNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Máha xu̱ta̱ xi kindzjoyoo̱, tu̱ má xi tje̱hén ni nga i̱ncha ngji, yo̱ i̱ncha y'éni̱jmí én nda tsuhu̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","A̱nte Samari̱a̱ ngji Felipe̱ nga y'éni̱jmíhi̱ xu̱ta̱ xi tjín yo̱ nga Jesu xi kits'ín nibá Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kama ñja xu̱to̱ nga kingjénñjuhu̱ ni xi kinchja̱ Felipe̱ nk'ie nga i̱ncha kint'é ko̱ kikie ni xi kits'ín nga tsakúchji kju̱a̱chánkaha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","A̱t'aha̱ nkjin jáninda xi tsitjujíhi̱n xu̱ta̱ nga 'yún kikjintáya nga tsitju, ko̱ nkjin xu̱ta̱ xi najmi ma fi ko̱ xi ni̱ma̱ sjai kama nkihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kui nga tsjo ṉkjún kamaha̱ ra̱ xu̱to̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tu̱nga ta̱ y'ejñahá yo̱ nku nda̱ xi 'mi Simon xi kits'ín tj'e ni̱stjin nk'ie. Kui xi ts'ana̱cha̱ha̱ xu̱ta̱ xi tjín a̱nte Samari̱a̱. B'a̱ kitsú nga kui xi nku nda̱ chánka. ");
INSERT INTO majNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ngayjee̱ xu̱ta̱ tsasínñjuhu̱ ndo̱, b'aha̱ ra̱ xi ndyjaha̱ ko̱ santaha xi cháha̱. B'a̱ i̱ncha kitsú: —Kui nda̱ xu'bi̱ xi nga'yún chánkaha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","I̱ncha ts'ínsihi̱n a̱t'aha̱ nkjin nú kits'ín tj'e ndo̱. B'a̱ ts'ín ts'ana̱cha̱ha̱ xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tu̱nga nk'ie nga tsakúya Felipe̱ nga Nti̱a̱ná xi batéxuma ko̱ nga Jesu xi kits'ín nibá Nti̱a̱ná, kis'ejihi̱n xu̱ta̱ ko̱ kisaténtá jmichjín ko̱ jáx'i̱n. ");
INSERT INTO majNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Santaha ko̱ Simon ta̱ kis'ejihi̱n ko̱ kisaténtá. A̱s'a̱i kitsjenko̱ tehe̱nte Felipe̱ ko̱ kama nkjúhu̱n nk'ie nga kikie ni xi tsakúchji kju̱a̱chánkaha̱ Nti̱a̱ná ko̱ kju̱a̱nkjún i xi kits'ín Felipe̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nk'ie nga kint'é én já postru̱ xi tjíntu nanki Jerusalen nga xu̱ta̱ xi tjín a̱nte Samari̱a̱ kits'ínkjáíhi̱n éhe̱n Nti̱a̱ná, a̱s'a̱i kits'ínkji yo̱ Pedro̱ ko̱ Jua. ");
INSERT INTO majNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nk'ie nga i̱ncha j'ai jóo̱ yo̱, kinchja̱ntjai xu̱ta̱ Samari̱a̱ nginku̱n Nti̱a̱ná tu̱ xi ts'i̱ínkjáíhi̱n ra̱ Espiri̱tu̱ Santo̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","A̱t'aha̱ ndaha nku najmi kje̱e f'aijíhi̱n Espiri̱tu̱ Santo̱ ko̱ tu̱ ntáhá kisaténtáhá xu̱ta̱ nga kits'ínkjáíhi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","A̱s'a̱i Pedro̱ ko̱ Jua kingjénne ntsja xu̱ta̱ ko̱ kits'ínkjáíhi̱n Espiri̱tu̱ Santo̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kikie Simon nga kits'ínkjáíhi̱n xu̱ta̱ Espiri̱tu̱ Santo̱ nk'ie nga kingjénnehe̱ ntsja já postru̱. A̱s'a̱i kingjén'a to̱on já postru̱ ");
INSERT INTO majNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nga b'i̱ kitsúhu̱: —K'u̱a̱i̱nú ko̱ an nga'yún xu'bi̱, tu̱ xi nk'ie nga ngjuenné ntsa̱hana tu̱ yáha ni ta̱ ts'i̱ínkjáíhi̱n Espiri̱tu̱ Santo̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","A̱s'a̱i b'i̱ kitsú Pedro̱: —Kandyjai ko̱ ta̱ kandyja tjo̱ohi̱n, a̱t'aha̱ b'a̱ n'e tín'enkjíntak'uin nga to̱on ma ch'atseko̱ho ni xi tsjá Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Najmi ji tsuhu ri ko̱ najmi ji tje̱hen ri xá xu'bi̱, a̱t'aha̱ najmi kixi̱ tjíya ani̱ma̱hi̱ nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","T'inchj'a̱ha̱ ri̱ ani̱ma̱hi̱ nga̱t'aha̱ ngatitsun xu'bi̱ ko̱ chu̱bani̱ma̱ko̱i̱ Nti̱a̱ná, tsa tu̱ 'yaha ts'i̱ínndyjat'ahi ni xi kuan'enkjíntak'uin. ");
INSERT INTO majNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","A̱t'aha̱ tíbe nga najmi je tjíya ani̱ma̱hi̱ ko̱ tíbe nga ni ch'onk'uu̱n tjí'yíhi̱n ji. ");
INSERT INTO majNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","B'i̱ kitsú Simon: —Chu̱bani̱ma̱ko̱o Nti̱a̱ná tu̱ xi ndaha nku ni xi kuak'ihinnú najmi ni̱banehena. ");
INSERT INTO majNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nk'ie nga ja i̱ncha y'éni̱jmí éhe̱n Nti̱a̱ná yo̱ Pedro̱ ko̱ Jua ko̱ y'éjña chjihi̱ xu̱ta̱ yáha Jesu, a̱s'a̱i kik'óya ngáha nanki Jerusalen. B'a̱ ts'ín i̱ncha j'aha nkjin a̱nte nanki xi tjín a̱nte Samari̱a̱ nga y'éni̱jmí ts'íhin én nda tsuhu̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","A̱s'a̱i nku ntítsjehe̱ Nti̱a̱ná kinchja̱ko̱ho̱ Felipe̱. B'i̱ kitsúhu̱: —Ti̱síntje̱i̱n ko̱ chjúbéí ni̱yá xi bitju Jerusalen nga t'in nanki Gaza̱. A̱nte kixiu̱ f'a ni̱yá xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","A̱s'a̱i tsisintje̱n Felipe̱ ko̱ ngji, ko̱ a̱ya ni̱yóo̱ kisatéjin nku nda̱ xi nibáha a̱nte Etiopia̱. Nku nda̱ eunuko̱ niu̱, nku nda̱ k'aku̱ xi ts'ínxát'aha̱ na̱ Candace̱ xi na̱ rei̱na̱ha̱ xu̱ta̱ Etiopia̱. Kui xi f'átjo ngayjee̱ to̱oho̱n na̱ rei̱na̱. Nti̱a̱ná ngji ts'íntsjoho̱ ndo̱ nanki Jerusalen ");
INSERT INTO majNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ko̱ ja tíb'óya ngáha nankihi̱. Yá xi tje̱nko̱ kab'ejñaya ko̱ títs'ínya xu̱ju̱n éhe̱n Nti̱a̱ná xi y'ét'a nda̱ profeta̱ Isaia̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","A̱s'a̱i Espiri̱tu̱ b'i̱ kitsúhu̱ Felipe̱: —T'ihi̱nse̱ tiñaihi̱ nda̱ xi kab'ejñaya yá ján. ");
INSERT INTO majNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nk'ie nga tsichuk'úhu̱n, kint'é Felipe̱ nga xu̱ju̱n xi y'ét'a nda̱ profeta̱ Isaia̱ títs'ínya ndo̱. A̱s'a̱i b'i̱ kitsúhu̱: —¿A tímankjihin ni xi tín'eyai? ");
INSERT INTO majNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","—¿Nkú ts'ín ka̱mankjihinna nga najmi tjín xi ku̱i̱tsu̱ya sisinna? —kitsú ndo̱ ko̱ tsankihi̱ Felipe̱ nga ku̱i̱yájnut'aha̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","B'i̱ ts'ín tjít'a má nga títs'ínya ndo̱: Ngji n'ek'ien xi nkúhu chu̱tsa̱nka̱, najmi kikjex'á ts'a, xi nkúhu chu̱tsa̱nka̱ xi tíchj'ajnu tsa̱nka̱ha̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kichajnucha ko̱ najmi na̱xu̱ kin'ehe̱ kju̱a̱. Tsichakjá ntje̱he̱ a̱t'aha̱ kin'ek'ien. ");
INSERT INTO majNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","A̱s'a̱i b'i̱ ts'ín kinchja̱ nda̱ k'aku̱ xi nibáha Etiopia̱ nga kingjásjaiyaha̱ Felipe̱: —T'inyaní, ¿yá xi tínchja̱ni̱jmíyaha nda̱ profeta̱ e̱i̱? ¿A kui tínchja̱ni̱jmíyaha yjoho̱ a ra̱ kj'a̱íhí xi tínchja̱ni̱jmíyaha? ");
INSERT INTO majNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","A̱s'a̱i kinchja̱ Felipe̱. Má nga títs'ínya ndo̱ kik'atuts'i̱hi̱n ra̱ nga kitsúyaha̱ én nda tsuhu̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nk'ie nga tíi̱ncha ts'ín ni̱yá, tu̱ i̱ncha tsichuhú má nga tjín ntánijua ko̱ b'i̱ kitsú nda̱ k'aku̱ Etiopia̱: —Á ntánijua e̱i̱. ¿A najmi ka̱mahá sa̱téntá? ");
INSERT INTO majNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","B'i̱ kitsú Felipe̱: —Tsa ngayjee̱ ani̱ma̱hi̱ s'ejihin yáha Jesu, ka̱ma. B'i̱ kitsú ndo̱: —S'ejinna nga Jesucristo̱ xi Ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","A̱s'a̱i b'a̱ kitsú nga s'e̱jña'yún yóo̱ ko̱ nga joo̱ tsitjujenya má tíjña ntánijuo̱. A̱s'a̱i Felipe̱ tsaténtá ndo̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nk'ie nga i̱ncha tsitjujin ntánijuo̱, Espiri̱tu̱ Santo̱ ngjiko̱ t'axíhi̱n Felipe̱. Nda̱ k'aku̱ xi nabáha Etiopia̱ najmi ta̱ kikiehe Felipe̱, tu̱nga tsjohó kik'iehe̱ nk'ie nga kits'ínndju̱ú ni̱yáha̱. ");
INSERT INTO majNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tsichu Felipe̱ nanki Azoto̱ ko̱ xki̱ a̱nte ngji nga y'éni̱jmí én nda tsuhu̱ Jesu santaha nkúhu nga tsichu nanki Cesarea̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo̱ tu̱ nku tsinchánkjúhún ra̱ xu̱ta̱ xi s'ejihi̱n Nda̱ Nti̱a̱ná Jesu nga mjehe̱ ts'i̱ínk'ien. Kui nga ngjisehe̱ ra̱ nda̱ na̱'mi títjuu̱n ");
INSERT INTO majNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ko̱ tsankihi̱ xu̱ju̱n xi má nga tí'ba̱i̱hi̱ kju̱a̱, tu̱ xi ka̱ma ngju̱a̱i̱hi ni'ya sinagoga̱ xi tjín nanki Damasco̱ ko̱ ku̱a̱ngisjai yo̱ xu̱ta̱ xi s'ejihi̱n Jesu ko̱ kj'u̱a̱íko̱nijé nanki Jerusalen, ndaha tsa jáx'i̱n ko̱ ndaha tsa jminchjín. ");
INSERT INTO majNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tu̱nga nk'iehé nga títs'ín ni̱yá ko̱ ja tíbichú tiña nanki Damasco̱, tje̱n'yún kits'ín ndzjehé ra̱ Saulo̱ nku nd'í xi nibaha nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A̱s'a̱i tsijne t'anankiu̱ ko̱ kint'é nku nta̱ xi b'i̱ kitsúhu̱: —Saulo̱, Saulo̱, ¿á an tje̱nnki unchahaní? ");
INSERT INTO majNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—¿Yáha ji, Nda̱ Nti̱a̱? —kitsú Saulo̱. B'i̱ kitsú xi kinchja̱ko̱ho̱: —An Jesu xi tje̱nnki unchai. ");
INSERT INTO majNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ti̱síntje̱i̱n ko̱ t'in a̱jin na̱nti̱o̱. Yo̱ k'úínyahi ni xi tjíhin nga n'e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kitsankjún já xi tje̱nko̱ Saulo̱, a̱t'aha̱ kint'é nto̱ tu̱nga najmi ch'a xi kikiehé. ");
INSERT INTO majNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","A̱s'a̱i tsisintje̱n Saulo̱, tu̱nga nk'ie nga kikjex'á tunku̱n najmi ta̱ kama chjihi̱ ra̱. Kui nga tu̱ kichjubénkihí ni nga ngjiko̱ jóo̱ nanki Damasco̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yo̱ kamaha̱ jan ni̱stjin nga y'ejña ka̱. Najmi chumi nihi xi kikjine ko̱ najmi chumi ntáha xi kik'i. ");
INSERT INTO majNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco̱ y'ejña nku nda̱ xi tje̱nnkihi̱ Jesu xi 'mi Anania̱. Kui xi Nda̱ Nti̱a̱ná tsakúchjihi̱ yjoho̱ xi nkúhu tsa nchi̱ni kik'a̱i̱hi̱ ko̱ b'a̱ kitsúhu̱: —¡Ji Anania̱! —Á an e̱i̱, Nda̱ Nti̱a̱ —kitsú Anania̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","B'i̱ kitsúhu̱ Nda̱ Nti̱a̱ná: —Ti̱síntje̱i̱n ko̱ t'in ni̱yáté xi 'mi Ni̱yá Kixi̱. Ni'yaha̱ Juda̱ cha̱sjaiyai nku nda̱ xi nibáha nanki Tarso̱ xi 'mi Saulo̱. Nti̱a̱ná tínchja̱ko̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ja kama chjihi̱ xi nkúhu tsa nchi̱ni kuak'a̱i̱hi̱ nga nku nda̱ xi 'mi Anania̱ kafas'en má tíjña ko̱ nga kamjénehe̱ ntsja tu̱ xi ka̱ma chji ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","B'i̱ kitsú Anania̱: —Ji Nda̱ Nti̱a̱, nkjin xu̱ta̱ títsuyana xi nkú k'uhu̱n ndo̱ ko̱ ni xi najmi nda xi kits'íhi̱n xu̱ta̱ xi ts'i̱ xi tjíntu Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Já na̱'mi k'aku̱ ja kitsjáha̱ kju̱a̱ xi má nga ka̱ma ngju̱a̱i̱ko̱ kju̱a̱'yún ngayjee̱ xi s'ejihi̱n ji. ");
INSERT INTO majNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","A̱s'a̱i b'i̱ kitsú Nda̱ Nti̱a̱ná: —T'in, a̱t'aha̱ an ja j'ajián ndo̱ nga kui xi k'u̱éni̱jmíhi̱ an xu̱ta̱ xi najmi ntje̱ Israel tje̱he̱n ra̱ ko̱ já rei̱ ko̱ xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","An kuakuchjíhi̱ nk'ie nga nkjin kju̱a̱ni̱ma̱ kj'u̱a̱jin nga̱t'ana̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","A̱s'a̱i ngji Anania̱. Jas'en ni'ya má nga tíjña Saulo̱ ko̱ kingjénne ntsja nga b'i̱ kitsúhu̱: —Ji nda̱ nts'é Saulo̱, Nda̱ Nti̱a̱ná Jesu xi tsakúchjihi yjoho̱ a̱ya ni̱yá má nga tínibáí, kui kuats'ín nibána tu̱ xi ka̱ma chji ngáha ri ko̱ tu̱ xi tséjihin ri Espiri̱tu̱ Santo̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tje̱n'yún tsitjunkihí tunku̱n Saulo̱ ni xi b'a̱ k'un tja̱ba̱xkfi̱ k'un ko̱ kama chji ngáha̱ ra̱. A̱s'a̱i tsisintje̱n ko̱ kisaténtá. ");
INSERT INTO majNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nk'ie nga ja kikjine nichine, kisakú nga'yún ngáha̱ ra̱ ko̱ chuba ni̱stjin y'ejñajihi̱n xu̱ta̱ xi yjankihi̱ Jesu xi tjín Damasco̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","A̱s'a̱i y'éni̱jmí Saulo̱ éhe̱n Nti̱a̱ná ni'ya sinagoga̱ xi tjín yo̱ nga b'a̱ kitsú nga Jesu xi Ntíhi̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kama nkjúhu̱n ngayjee̱ xu̱ta̱ xi kint'éhe̱. B'i̱ i̱ncha kitsúhu̱ xinkjín: —¿A najmi kuihí nda̱i̱ xi tje̱nnki unkie xu̱ta̱ xi s'ejihi̱n Jesu nanki Jerusalen? Ko̱ ta̱ kui xá j'aihi e̱i̱ tu̱ xi ngju̱a̱i̱ko̱nijéhe xu̱ta̱ nginku̱n já na̱'mi k'aku̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tu̱nga tu̱ sahá 'yún y'éni̱jmí sa Saulo̱ ko̱ y'éjña chji nga Jesu xi kits'ín nibá Nti̱a̱ná. Kits'ínndyja̱jihi̱n xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ xi tjíntu Damasco̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nk'ie nga j'a nkjin ni̱stjin, a̱s'a̱i y'éndako̱ xinkjín já judio̱ nga i̱ncha ts'i̱ínk'ien Saulo̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tu̱nga tjíhín xi kitsúyaha̱ Saulo̱ ni xi y'énda jóo̱. Ni̱stjin ni̱stje̱n i̱ncha kikunntá a̱nkju̱a̱ha̱ nankiu̱ tu̱ xi ts'i̱ínk'iehen Saulo̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","A̱s'a̱i xu̱ta̱ xi yjankihi̱ Jesu tsasinko̱ho̱ Saulo̱. Y'éyaha̱ nku ni̱si̱n ko̱ kikjeje̱nntjaihi̱ xjóho̱ nankiu̱ nga jyuu̱n. ");
INSERT INTO majNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nk'ie nga tsichu Saulo̱ nanki Jerusalen, mjehe̱ nga ka̱mangujinko̱ xu̱ta̱ xi yjankihi̱ Jesu, tu̱nga kitsankjúhún ra̱ ngayjee̱ jóo̱, a̱t'aha̱ najmi kis'ejihi̱n tsa ja ta̱ nku nda̱ xi tje̱nnkihi̱ Jesu Saulo̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","A̱s'a̱i Bernabe ngjiko̱ Saulo̱ nginku̱n já postru̱ ko̱ kitsúyaha̱ xi nkú ts'ín a̱ya ni̱yóo̱ kikie Saulo̱ Nda̱ Nti̱a̱ná ko̱ nga Nda̱ Nti̱a̱ná kinchja̱ko̱ho̱ ko̱ xi nkú ts'ín ndjá y'éni̱jmí éhe̱n Jesu nanki Damasco̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","A̱s'a̱i y'ejña Saulo̱ nanki Jerusalen. Y'emako̱ já postru̱ ko̱ ndjá y'éni̱jmí nga tsakúya yáha Nda̱ Nti̱a̱ná Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kinchja̱ni̱jmíko̱ ko̱ y'ésiko̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ xi nchja̱ én griego̱. Tu̱nga já xu'bi̱ tsangisjai ni̱yá xi nkú ts'ín ka̱ma ts'i̱ínk'ien Saulo̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nk'ie nga kint'é já nts'eé ni xu'bi̱, a̱s'a̱i ngjiko̱ Saulo̱ nanki Cesarea̱. Ja kamoo̱ kits'ínkji Tarso̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kis'ehe̱ kju̱a̱jyu xu̱ta̱ ni̱nku̱ xi tjín ngayjee̱ a̱nte Judea̱, a̱nte Galilea̱ ko̱ a̱nte Samari̱a̱. 'Yún kis'ejin saha̱ Nti̱a̱ná. Kikienkjún Nti̱a̱ná nga y'entu ko̱ Espiri̱tu̱ Santo̱ tsasinko̱ho̱ nga 'yún kama nkjin sa. ");
INSERT INTO majNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nk'ie nga tsú'bak'un Pedro̱ xu̱ta̱ ni̱nku̱ xi tjín xki̱ a̱nte, a̱s'a̱i ta̱ j'aisehe̱ xu̱ta̱ xi ts'e̱ Nti̱a̱ná xi tjín nanki Lida̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yo̱ kikie nku nda̱ xi 'mi Enea̱ xi jin nú tjíhi̱n nga kjijñasun na̱chan, a̱t'aha̱ nta sjai. ");
INSERT INTO majNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","A̱s'a̱i b'a̱ kitsúhu̱: —Ji Enea̱, Jesucristo̱ títs'ínnkihi. Ti̱síntje̱i̱n ko̱ t'endai kama̱hi̱. Ta̱ kuihi chu̱bo̱ tsisintje̱n Enea̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ngayjee̱ xu̱ta̱ xi tjíntu Lida̱ ko̱ Saron kikie nga tsisintje̱n Enea̱ ko̱ kits'ínkjáíhi̱n Nda̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nanki Jope̱ y'ejña nku ta̱chju̱ún xi tje̱nnkihi̱ Jesu xi 'mi Tabita̱, j'áín xi tsuhu̱ ra̱ Dorca̱ nga én griego̱. Kui xi ngayje ni̱stjin kits'ín ni xi nda ko̱ kitsjáha̱ xu̱ta̱ x'a̱n ni xi machjéhe̱n. ");
INSERT INTO majNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kui ni̱stjiu̱n kisate ch'in ko̱ k'ien. A̱skahan nga ja jejnú yjonintehe̱, kis'ejña nku a̱ya 'ma. ");
INSERT INTO majNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nk'ie nga kint'é xu̱ta̱ ni'yakuyáha̱ Jesu xi tjíntu nanki Jope̱ nga nanki Lida̱ tíjña Pedro̱, a̱s'a̱i kits'ínkjisehe̱ jo já, a̱t'aha̱ tiña maha̱ xinkjín nankiu̱. B'i̱ kitsú jóo̱ nga j'ai nchja̱ko̱ Pedro̱: —Najmi tu̱ n'ek'andayai. Nibáa̱se̱ni̱. ");
INSERT INTO majNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","A̱s'a̱i tsisintje̱n Pedro̱ ko̱ ngjiko̱ jóo̱. Nk'ie nga ja tsichu nanki Jope̱, xu̱ta̱ xi tíi̱ncha yo̱ ngjiko̱ho̱ a̱ya 'ma xi má nga kjijña yjoninte k'ie̱n. Ngayjee̱ jminchjín xi ja k'ien x'i̱hi̱n j'aitset'áha̱ Pedro̱ nga tíi̱ncha kjintá ko̱ tíi̱ncha bakú x'ótji ko̱ kj'a̱í sa najyun xi ts'ínnda Dorca̱ nk'ie nga y'ejña. ");
INSERT INTO majNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","A̱s'a̱i kik'onsje Pedro̱ ngayjee̱ xu̱ta̱ xi tíi̱ncha yo̱ ko̱ tsasinkúnch'in nga kinchja̱ko̱ Nti̱a̱ná. Tsase ts'íhi̱n ra̱ yjoninte k'ie̱n nga b'i̱ kitsú: —Ji Tabita̱, ti̱síntje̱i̱n. A̱s'a̱i kikjex'ánki tunku̱n ta̱chjúu̱n. Nk'ie nga kikie nga yo̱ síjña Pedro̱, y'ejña kutu. ");
INSERT INTO majNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro̱ jakj'á ntsja ta̱chjúu̱n ko̱ kikjesíntje̱n. Kinchja̱ha̱ xu̱ta̱ ni̱nku̱ ko̱ jminchjín xi ja k'ien x'i̱hi̱n ko̱ kits'ínkjas'en tík'un ngáha̱ ra̱ ta̱chjúu̱n. ");
INSERT INTO majNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ngayjee̱ xu̱ta̱ xi tjín nanki Jope̱ kint'é ni xi kamoo̱ ko̱ nkjin xi kis'ejihi̱n Nda̱ Nti̱a̱ná Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nkjin ni̱stjin kamaha̱ Pedro̱ nga y'ejña nanki Jope̱ ni'yaha̱ nda̱ xi 'mi Simon xi f'áxi tja̱ba̱xín. ");
INSERT INTO majNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nanki Cesarea̱ y'ejña nku nda̱ xi 'mi Corneli̱o̱ xi nda̱ jun k'aku̱hu̱ já jun xi 'mi Já jun Italiano̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kui ko̱ ngayjee̱ xu̱ta̱ xi tjíntu ni'yaha̱ tjoho̱ ko̱ benkjún Nti̱a̱ná. Tsjáha̱ xu̱ta̱ x'a̱n ni xi machjéhe̱n ko̱ tehe̱nte nchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nku ni̱yá nkú ra̱ ma nga chu̱ba̱ jan nga ngixuu̱n kama chjihi̱ nku ntítsjehe̱ Nti̱a̱ná xi nkúhu tsa nchi̱ni kik'a̱i̱hi̱ kamaha̱. Kikie Corneli̱o̱ nga jas'en ntítsjee̱ má tíjña ko̱ b'a̱ kitsúhu̱: —¡Ji Corneli̱o̱! ");
INSERT INTO majNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","—¿Mí nihi, Nda̱ Nti̱a̱? —kitsú Corneli̱o̱ nga tsase ko̱ títsankjúhún ts'íhin. B'i̱ kitsú ntítsjee̱: —Tsasínñjuhu̱ Nti̱a̱ná ni xi tsinchihi̱ ko̱ tíbe nga tí'ba̱i̱hi̱ xu̱ta̱ x'a̱n ni xi machjéhe̱n. ");
INSERT INTO majNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kui nga n'e̱kjíhini nanki Jope̱ já xi ku̱i̱nchja̱ha̱ ra̱ Simon, kui xi ta̱ 'mi Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kui xi tíjña ni'yaha̱ nda̱ Simon xi f'áxi tja̱ba̱xín, nda̱ xi tiña a̱ndai ntáchak'uu̱n síjña ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nk'ie nga ja ngji ntítsje xi tínchja̱ko̱ho̱, a̱s'a̱i kinchja̱ha̱ Corneli̱o̱ jo já musu̱hu̱ ko̱ j'ájin a̱jihi̱n já jun xi tjíhi̱n nku nda̱ jun xi tjoho̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kitsúyaha̱ ngayjee̱ ni xi kamoo̱, a̱s'a̱i kits'ínkji nanki Jope̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ni̱stjin xi ma ndyjuu̱n, nk'ie nga títs'ín ni̱yá jóo̱ ko̱ nga ja tíbichú tiña a̱jin na̱nti̱o̱, Pedro̱ ngji nchja̱ko̱ Nti̱a̱ná nk'a ni'ya má nga tíjña, nkú ra̱ ma nga chu̱ba̱ te jo. ");
INSERT INTO majNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A̱s'a̱i tu̱ kama bjohó ra̱ ko̱ mjehe̱ kji̱ne̱ ni. Nk'ie nga tís'echjáha̱n nichine, kama chjihi̱ nku ni xi nkú joyaha tsa nchi̱ni kik'a̱i̱hi̱ kamaha̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kikie nga tsix'á nk'a ján ko̱ nga nibajen t'anankiu̱ nku ni xi b'a̱ tjín xi nkú joyaha nku najyun tjebe chánka xi tjít'a'yún nga ñjuu̱ nku̱n. ");
INSERT INTO majNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tjíntuyá a̱yaha̱ niu̱ ngayje tíkjá chu̱ xi b'ema ko̱ xi b'éfe yjoho̱ t'anankiu̱ ko̱ ni̱se xi b'ematje̱n nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","A̱s'a̱i kint'é Pedro̱ nku nta̱ xi b'i̱ kitsúhu̱: —Pedro̱, ti̱síntje̱i̱n. N'e̱k'iein chu̱ ko̱ chi̱ne̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","B'i̱ kitsú Pedro̱: —Najmi, Nda̱ Nti̱a̱. Ndaha̱chí najmi kje̱e kjíne̱ ni xi tíjña nkjúhu̱n kju̱a̱téxumoo̱ nga ka̱ma chi̱ne̱, ni xi najmi je nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","A̱s'a̱i ta̱ kinchja̱ ngáha nto̱ ni̱yá xi ma joho. B'i̱ kitsú: —Ni xi kits'ín Nti̱a̱ná nga ja je nginku̱n, najmi tu̱ ji 'mihi̱ nga najmi je. ");
INSERT INTO majNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jan ni̱yá b'a̱ kama, a̱s'a̱i ngjinji ngáha niu̱ nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nk'ie nga ta̱ títs'ínnkjink'uhun Pedro̱ nkú tsuhu̱ ra̱ ni xi kama chjihi̱, tu̱ tsichuhú a̱sti a̱nkju̱o̱ já xi kits'ín nibá nda̱ Corneli̱o̱. Kisakúhu̱ jóo̱ ni'yaha̱ Simon, nda̱ xi f'áxi tja̱ba̱xín. ");
INSERT INTO majNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","A̱s'a̱i kingjásjaiya tsa yo̱ tíjña Simon xi ta̱ 'mi Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nk'ie nga tu̱ nku títs'ínnkjink'uhún Pedro̱ ni xi kama chjihi̱, Espiri̱tu̱ Santo̱ b'i̱ kitsúhu̱: —Cha̱se̱ mai. Jan já tíbangisjaihi. ");
INSERT INTO majNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ti̱síntje̱i̱n ko̱ ti̱tjuje̱i̱n. Najmi tu̱ n'ejó tak'uin nga t'inko̱i̱, a̱t'aha̱ an kats'in nibá jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","A̱s'a̱i tsitjujen Pedro̱ nga j'aisehe̱ jóo̱ ko̱ b'i̱ kitsúhu̱: —An xi tíbinchisjó. ¿Mí xáha xi kj'úái̱hinu? ");
INSERT INTO majNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","B'a̱ i̱ncha kitsú jóo̱: —Nda̱ jun k'aku̱ Corneli̱o̱ kats'ín nibáni̱. Benkjún Nti̱a̱ná ndo̱ ko̱ na̱xu̱ ts'ín ni xi ts'ín. Nda ts'ín nchja̱ni̱jmíyaha̱ ra̱ ngayjee̱ xu̱ta̱ judio̱ ndo̱. Nku ntítsjehe̱ Nti̱a̱ná b'a̱ kitsúhu̱ nga kju̱a̱íchj'aihi nga k'úín ni'yaha̱ ko̱ nga ku̱a̱sínñjuhu̱ ni xi k'úíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kits'ínkjáíhi̱n Pedro̱ jóo̱ ko̱ yo̱ i̱ncha kits'ínkj'a ni̱stje̱n. Ni̱stjin xi ma ndyjuu̱n ngjiko̱ jóo̱. Ta̱ ngjiko̱ k'u̱a̱ já ni̱nku̱ xi tjín nanki Jope̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ni̱stjin xi ma joho tsichu nanki Cesarea̱. Tíkuyá Corneli̱o̱ ko̱ ta̱ tíkuyá xu̱ta̱ xi kits'ínkint'é, kui xi xu̱ta̱ xinkjín ko̱ xu̱ta̱ xi nda nchja̱ko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nk'ie nga ja tífas'en Pedro̱ a̱yoo̱, Corneli̱o̱ j'ai ts'ínkjáíhi̱n ko̱ tsasinkúnch'int'aha̱ nga kits'íntsjoho̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tu̱nga kikjesíntje̱hén ra̱ Pedro̱ ko̱ b'i̱ kitsúhu̱: —Ti̱síntje̱i̱n. Ta̱ xu̱ta̱ná xi nkúhu ji. ");
INSERT INTO majNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tínchja̱ko̱ ts'íhin nga jas'en a̱yoo̱ ko̱ kikie nga nkjin xu̱ta̱ kama ñjakú yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","A̱s'a̱i b'i̱ kitsúhu̱: —Jun yo nga nku nda̱ xi ntje̱ judio̱ tje̱he̱n ra̱ najmi tsjántehe̱ kju̱a̱téxumaha̱ tsa ka̱ma ñjako̱ xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱ ko̱ tsa kju̱a̱s'en ni'yaha̱. Tu̱nga Nti̱a̱náhá tsakúchjina nga najmi tjíhin nga kj'uajíán xu̱ta̱, tsa xi je ko̱ xi najmi je xi nkú títsu kju̱a̱téxumani̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kui kju̱a̱ha nk'ie nga kichubahanú, najmi jo jan tjíhinna nga kjúái̱senu̱u. Kui b'a̱ maha, t'inyahanú mí kju̱a̱ha nga kichubahanú. ");
INSERT INTO majNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A̱s'a̱i b'i̱ kitsú Corneli̱o̱: —Ma ñju ni̱stjin, nkú ra̱ ma chu̱ba̱ jan nga ngixuu̱n, ni'yana̱ tínchjaka̱ Nti̱a̱ná. Tu̱ j'ai sinjñahá nku nda̱ xi tíb'at'ai najyun xi yja. ");
INSERT INTO majNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kui xi b'a̱ kitsúna: “Corneli̱o̱, Nti̱a̱ná tsasínñjuhu̱ ni xi tsinchihi̱ ko̱ tíbe nga tí'ba̱i̱hi̱ xu̱ta̱ x'a̱n ni xi machjéhe̱n. ");
INSERT INTO majNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kui nga n'e̱kjíhini nanki Jope̱ já xi ku̱i̱nchja̱ha̱ ra̱ Simon, kui xi ta̱ 'mi Pedro̱. Kui xi tíjña ni'yaha̱ Simon xi f'áxi tja̱ba̱xín, nda̱ xi tiña a̱ndai ntáchak'uu̱n síjña ni'yaha̱.” ");
INSERT INTO majNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kui nga tje̱n'yún ngjichj'ahána ji, ko̱ nda kuan'ei nga kjúái̱. Kui kju̱a̱ha kabintsu̱ba̱ha̱ni̱ e̱i̱ ngayjei̱ nginku̱n Nti̱a̱ná tu̱ xi k'u̱a̱sinñjuhu̱ ri̱ ngayjee̱ én xi kitsúhi Nti̱a̱ná nga ku̱i̱xínyani̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","A̱s'a̱i b'i̱ kitsú Pedro̱ nga kik'aha̱ éhe̱n: —Mankjinna nd'a̱i̱ nga kju̱axi̱ kjáíhin nga najmi ngabi ts'ín Nti̱a̱ná a̱jihi̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ts'ínkjáín níhi̱ tu̱ má xu̱ta̱ na̱xi̱nantáha ni xi tjín a̱sunntee̱ xi benkjúhu̱n ko̱ xi na̱xu̱ ts'ín nginku̱n. ");
INSERT INTO majNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","’Nti̱a̱ná kits'ínkint'é xu̱ta̱ xi ntje̱ Israel tje̱he̱n ra̱ én nda tsuhu̱ Jesucristo̱. Kui xi Nda̱ Nti̱a̱ha̱ ngayjee̱ xu̱ta̱ ko̱ kui xi tsjáha̱ xu̱ta̱ kju̱a̱jyuhu̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yo én xi kichuba ngayjee̱ a̱nte Judea̱, b'aha̱ ra̱ a̱nte Galilea̱ nk'ie nga ja kamaha̱ Jua nga tsaténtá ko̱ y'éni̱jmí éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yo xi nkú ts'ín Nti̱a̱ná kits'ín nibájen Espiri̱tu̱ Santo̱ nga j'aitsejíhi̱n ra̱ Jesu, nda̱ xi nibáha nanki Nazaret, ko̱ kitsjáha̱ nga'yún. Kui xi kikjatsú'ba nga kits'ín ni xi nda ko̱ kits'ínnkihi̱ ngayjee̱ xi tjíntujíhi̱n jánindoo̱. Nti̱a̱ná kits'ínxájihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","’Ji̱n kiyai̱ ko̱ bixíyai̱ ngayjee̱ ni xi kits'ín Jesu a̱nte Judea̱ ko̱ nanki Jerusalen. Kis'et'a kruu̱ nga kin'ek'ien. ");
INSERT INTO majNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tu̱nga Nti̱a̱náhá kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱ ni̱stjin xi ma jahan ko̱ tsakúchjini̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Najmi ngayjee̱ xu̱ta̱ tsakúchjihi̱ yjoho̱, tu̱ nkuhú ji̱n xi j'ájin títjunni̱ Nti̱a̱ná nga ku̱i̱xínyai̱ xu̱ta̱ xingisoo̱. Ji̱n kichineko̱i̱ ko̱ ki'yuko̱i̱ nk'ie nga ja j'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","’Y'éxáni̱ nga tjíhin nga k'úéni̱jmíhi̱ xu̱ta̱ ko̱ ku̱i̱xínyai̱ nga Nti̱a̱ná kitsjá xáha̱ nga kui ku̱a̱se̱he̱ ni xi nda ko̱ ni xi najmi nda kits'ín xu̱ta̱ xi tjíntu tík'un ko̱ xi k'ien. ");
INSERT INTO majNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ngayjee̱ já profeta̱ kinchja̱ni̱jmíyaha Jesu. B'a̱ i̱ncha kitsú nga nga̱t'aha̱ Jesu ka̱ma ndyjat'aha̱ ra̱ jéhe̱ ngayjee̱ xu̱ta̱ xi s'e̱jihi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nk'ie nga ta̱ tínchja̱ha Pedro̱, tu̱ nibajennehé ra̱ Espiri̱tu̱ Santo̱ ngayjee̱ xu̱ta̱ xi tíi̱ncha basínñjuhu̱ én xi tínchja̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Kama nkjúhu̱n já ni̱nku̱ xi ntje̱ judio̱ tje̱he̱n ra̱ xi tje̱nko̱ Pedro̱ nk'ie nga kikie nga Nti̱a̱ná kitsjáha̱ Espiri̱tu̱ Santo̱ xu̱ta̱ xi najmi judio̱. ");
INSERT INTO majNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","A̱t'aha̱ kint'é nga kj'a̱í kj'a̱í én kinchja̱ xu̱ta̱ ko̱ nga kits'ínkie yjoho̱ nga Nti̱a̱ná xi tjíhi̱n kju̱a̱chánka. A̱s'a̱i b'i̱ kitsú Pedro̱: ");
INSERT INTO majNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—¿A tjín xi najmi tsjánte nga sa̱téntá xu̱ta̱ xu'bi̱ xi ja kuats'ínkjáíhi̱n Espiri̱tu̱ Santo̱ xi nkúhu ñá? ");
INSERT INTO majNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","B'a̱ kitsú Pedro̱ nga sa̱téntá xu̱to̱ a̱t'aha̱ ja kis'ejihi̱n Jesucristo̱. Ja kamoo̱, tsinchihi̱ Pedro̱ nga k'úéjña sa yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kint'é já postru̱ ko̱ já nts'eé xi tjín a̱nte Judea̱ nga xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱ ta̱ kits'ínkjáíhi̱n éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nk'ie nga j'ai ngáha Pedro̱ nanki Jerusalen, y'ésiko̱ho̱ já judio̱ xi tíi̱ncha tsu nga tjíhin nga n'e̱ ni circuncision xi nkú nga títsu kju̱a̱téxumoo̱. B'i̱ kik'ihi̱n: ");
INSERT INTO majNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—¿Á ji tsitjas'e̱henni ni'yaha̱ ko̱ kichineko̱honi já xi najmi kin'ehe̱ ra̱ ni circuncision? ");
INSERT INTO majNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","A̱s'a̱i kik'atuts'i̱hi̱n Pedro̱ nga kitsúya chich'in ngayjee̱ ni xi kamoo̱. B'i̱ kitsú: ");
INSERT INTO majNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Nk'ie nga tínchjaka̱ Nti̱a̱ná nanki Jope̱, kama chjina nku ni xi nkúhu tsa nchi̱ni kik'a̱i̱na. Kikie nku ni xi b'a̱ tjín xi nkú joyaha nku najyun tjebe chánka xi tjít'a'yún nga ñjuu̱ nku̱n. Nibajehen nk'a ján ko̱ j'aijén santaha má tíi̱jña. ");
INSERT INTO majNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nk'ie nga tsase nda nda mí nihi xi tíi̱nchaha̱, kikie chu̱ xi b'ema, chu̱ xi tjín ngijñóo̱, xi b'éfe yjoho̱ t'anankiu̱ ko̱ ni̱se xi b'ematje̱n nk'a ján. ");
INSERT INTO majNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","’A̱s'a̱i kint'e nku nta̱ xi b'i̱ kitsúna: “Pedro̱, ti̱síntje̱i̱n. N'e̱k'iein chu̱ ko̱ chi̱ne̱i̱.” ");
INSERT INTO majNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","B'a̱ kixian: “Najmi, Nda̱ Nti̱a̱. Ndaha̱chí najmi kje̱e kjíne̱ ni xi tíjña nkjúhu̱n kju̱a̱téxumoo̱ nga ka̱ma chi̱ne̱, ni xi najmi je nginku̱n Nti̱a̱ná.” ");
INSERT INTO majNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","A̱s'a̱i ta̱ kinchja̱ko̱hó ngáhana nta̱ xi nibaha nk'a ján ni̱yá xi ma joho. “Ni xi kits'ín Nti̱a̱ná nga ja je nginku̱n, najmi tu̱ ji 'mihi̱ nga najmi je nginku̱n”, kitsúna. ");
INSERT INTO majNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jan ni̱yá b'a̱ kama, a̱s'a̱i ngjinji ngáha nk'a ján ngayjee̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","’Ta̱ kuihi chu̱bo̱ tsichu ni'ya xi má nga tíi̱jña jan já xi nibaha Cesarea̱ nga j'aikj'ána. ");
INSERT INTO majNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","B'a̱ kitsúna Espiri̱tu̱ nga najmi jo jan ka̱mana nga kfínka̱ jóo̱. Ta̱ ngjiko̱na já nts'eé xi jun xu'bi̱ ko̱ tsitjas'e̱i̱n ni'yaha̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","A̱s'a̱i kitsúyani̱ xi nkú ts'ín kikie nku ntítsje a̱ya ni'yaha̱ nga j'ai sinjñat'aha̱ ko̱ b'a̱ kitsúhu̱: “N'e̱kjí naki Jope̱ já xi ku̱i̱nchja̱ha̱ Simon, kui xi ta̱ 'mi Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kui xi ku̱i̱nchja̱ko̱hi. Én xi ku̱i̱tsu̱hi, kui xi ts'i̱ínk'ankihi ko̱ ngayjee̱ xu̱ta̱ xi ts'i̱.” ");
INSERT INTO majNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","’Nk'ie nga kik'atuts'i̱hi̱n nga kinchja, Espiri̱tu̱ Santo̱ nibajennehe̱ xu̱ta̱ xu'bo̱ xi nkú ts'ín nibajennená nga tjuhun. ");
INSERT INTO majNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","A̱s'a̱i j'áítsjenna ni xi kitsúná Nda̱ Nti̱a̱ná: “Ntánijua tsaténtáha Jua tu̱nga máha jun, Espiri̱tu̱ Santo̱ sa̱téntáhanu.” ");
INSERT INTO majNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kui b'a̱ maha, tsa Nti̱a̱ná ta̱ títsjáha̱ ra̱ xu̱ta̱ xu'bo̱ ta̱ kui nihi xi kitsjáná xi s'ejinná Nda̱ Nti̱a̱ná Jesucristo̱, ¿yáha an tsa k'uechjáha̱ ra̱ Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nk'ie nga kint'é jóo̱ ni xi kitsú Pedro̱, najmi ta̱ ngji kontra̱ha̱ ra̱. Tu̱ sahá kits'íntsjoho̱ Nti̱a̱ná. B'i̱ i̱ncha kitsú: —A xúhu̱ ta̱ ko̱hó xu̱ta̱ xi najmi ntje̱ Israel tje̱he̱n ra̱ kitsjáha̱ Nti̱a̱ná nga ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱ tu̱ xi ka̱ma k'úéntu tík'un síhin. ");
INSERT INTO majNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nk'ie nga kin'ek'ien Esteba̱n, ta̱ kin'e uncha xu̱ta̱ ni̱nku̱ xi k'oo̱. Xi kindzjoya i̱ncha tsichu santaha a̱nte Fenici̱a̱, xjo̱ Chipre̱ ko̱ nanki Antiokia̱. Tu̱ nkuhú xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ y'éni̱jmíhi̱ éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tu̱nga kis'ehé a̱jihi̱n jóo̱ k'u̱a̱ já xi nibáha xjo̱ Chipre̱ ko̱ já xi nibáha a̱nte Cirene̱ xi i̱ncha tsichu nanki Antiokia̱ ko̱ kinchja̱ko̱ xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱, xi nchja̱ én griego̱. Y'éni̱jmíhi̱ xu̱to̱ én nda tsuhu̱ Nda̱ Nti̱a̱ná Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nga'yúhu̱n Nti̱a̱ná tsasinko̱ho̱ ko̱ nkjin kama xi kis'ejihi̱n ko̱ kits'ínkjáíhi̱n Nda̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","A̱s'a̱i kint'é xu̱ta̱ ni̱nku̱ xi tjín nanki Jerusalen ni xu'bi̱. Kui nga kits'ínkjihi Bernabe nanki Antiokia̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nk'ie nga tsichu Bernabe yo̱, kikie xi nkú ts'ín Nti̱a̱ná títsjáha̱ kju̱a̱ndaha̱ xu̱ta̱ xi tjín yo̱ ko̱ kama tsjoho̱. B'a̱ kitsúhu̱ ngayjee̱ xu̱ta̱ nga ngayjehe k'un kas'ejin tehe̱ntehe̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","B'a̱ ts'ín kinchja̱ Bernabe a̱t'aha̱ nda ani̱ma̱ha̱. Kitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱ ko̱ 'yún s'ejihi̱n Nti̱a̱ná. Nkjin ṉkjún sa xu̱ta̱ kis'ejihi̱n Nda̱ Nti̱a̱ná yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","A̱s'a̱i ngji Bernabe nanki Tarso̱ nga ngjingisjáí Saulo̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nk'ie nga kisakúhu̱, j'aiko̱ Antiokia̱. Yo̱ y'entujíhi̱n xu̱ta̱ ni̱nku̱ nku nú tjíhin ko̱ i̱ncha tsakúyaha̱ nkjin ṉkjún xu̱ta̱. Xu̱ta̱ ni'yakuyáha̱ Jesu xi kis'e Antiokia̱, kui xi tjun kik'in xu̱ta̱ cristiano̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A̱s'a̱i tsitju nanki Jerusalen k'u̱a̱ já profeta̱ nga ngji nanki Antiokia̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nku ndo̱ xi 'mi Aga̱bo̱ tsasinjña nk'ie nga Espiri̱tu̱ kits'ínkinchja̱ha̱ ko̱ kitsúya nga kjintíá s'e̱ ngayjee̱ a̱sunntee̱. B'a̱ kama nk'ie nga tjíhi̱n xá nda̱ títjun Roma̱ xi 'mi Claudi̱o̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nk'ie nga kiyaha̱ nga b'a̱ ka̱ma, a̱s'a̱i y'éndako̱ xinkjín xu̱ta̱ ni'yakuyáha̱ Jesu xi tjín nanki Antiokia̱ xi má nga tsjá nga nkúnkú ni xi tjíhi̱n xi nkú ts'ín behe̱ k'un, tu̱ xi ku̱a̱si̱nko̱ho já nts'eé xi tjín a̱nte Judea̱. ");
INSERT INTO majNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","B'a̱ i̱ncha kits'ín ko̱ kits'ínkji Bernabe ko̱ Saulo̱ nga kui xi ts'i̱ínkjas'ehe̱n to̱on chje̱ jácháha̱ xu̱ta̱ ni̱nku̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kui ni̱stjin xu'bo̱ nda̱ rei̱ Herode̱ Agripa̱ jakj'ánijé k'u̱a̱ xu̱ta̱ ni̱nku̱ tu̱ xi kits'ín'uhu̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","B'a̱ kitsú nga ki̱cha̱ n'e̱k'iehen Santiago̱ nda̱ nts'e̱ Jua. ");
INSERT INTO majNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nk'ie nga kikie nga tsjo kamaha̱ já judio̱ ni xi kits'ín, ta̱ jakj'ánijé Pedro̱. S'í Pascu̱a̱ b'a̱ kamoo̱, ni̱stjin nga chine ni̱nku̱a̱n xi najmi tjíhi̱n na̱'yu̱ san. ");
INSERT INTO majNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nk'ie nga jakj'ánijé Pedro̱, kits'ínkjas'en nu̱ba̱yá má nga ñju tjíhin kits'ínk'a xinkjín já jun xi kúnntaha̱. A̱t'aha̱ mjehe̱ Herode̱ ts'i̱ínko̱kju̱a̱ Pedro̱ nginku̱n xu̱ta̱ nk'ie nga kj'u̱a̱ s'íu̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kui nga kichunntáha Pedro̱ nga kjiyaha nu̱ba̱yóo̱, tu̱nga 'yúhún kinchja̱ko̱ Nti̱a̱ná xu̱ta̱ ni̱nku̱ nga tíbankintjáí Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ni xi kama nku ni̱stje̱n kintehe̱ ni nga ts'i̱ínko̱kju̱a̱ Herode̱ Pedro̱ nginku̱n xu̱ta̱, kjife Pedro̱ nga kjijñaya masehe̱n jo já jun. Jo n'úki̱cha̱ tjíkjáha̱. Ko̱ kj'a̱í já jun xi tíi̱ncha kunntá a̱nkju̱a̱ nu̱ba̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","A̱s'a̱i tu̱ nkuhú ntítsjehe̱ Nti̱a̱ná j'ai sinjña yo̱ ko̱ kama ndzjen a̱ya nu̱ba̱yóo̱. Kits'ínko̱ tjiaha̱ Pedro̱ nga kits'ínkj'áha̱ ko̱ b'i̱ kitsúhu̱: —Ki̱tsa̱ ti̱síntje̱i̱n. A̱s'a̱i tsixuntu n'úki̱cha̱ xi tjíkjá ntsja Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","B'i̱ kitsú ya ntítsjee̱: —T'e'yúnkjáí tja̱ba̱xín ndayáhi̱ ko̱ tjayai tja̱ba̱xín ntéhi̱. A̱s'a̱i b'a̱ kits'ín Pedro̱. B'i̱ kitsú yaha̱: —Tjasuntjiai najyun ndjuhi̱ ko̱ tsjénnkiní. ");
INSERT INTO majNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","A̱s'a̱i kitsjennkíhi̱ Pedro̱ ntítsjee̱ nga ndaha najmi be tsa kju̱axi̱ a ra̱ najmi kju̱axi̱ ni xi títs'ín ntítsjee̱. B'a̱ kamaha̱ xi nkúhu tsa chi̱ni tí'ba̱i̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","I̱ncha j'a má tjíntu já jun xi tjun tíi̱ncha kunntá yo̱ ko̱ ta̱ j'a xi ma joho. I̱ncha tsichu a̱nkju̱a̱ ki̱cha̱ xi tje̱n ni̱yáté xi fi a̱jin na̱nti̱o̱. Tsix'á suba a̱nkju̱o̱. Nk'ie nga i̱ncha tsitju ko̱ j'a nku ni̱yáté tjíhin, tje̱n'yún kindyjahá ntítsjee̱ nga ngji t'axíhi̱n Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","A̱s'a̱i kamankjihi̱n Pedro̱ xi nkúhu tsa j'a ngáha̱ ra̱ ko̱ b'a̱ kitsú: —Kju̱axi̱ nga Nti̱a̱ná kuats'ín nibá ntítsjehe̱. K'uakasje'ana a̱ya ntsja Herode̱ Agripa̱ ko̱ ngayjee̱ ni xi tíkuyáha̱ xu̱ta̱ judio̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nk'ie nga ja kamankjihi̱n ni xi kamoo̱, a̱s'a̱i ngji ni'yaha̱ Maria̱ na̱aha̱ Jua xi ta̱ 'mi ya Marco̱, má kama ñjakú nkjin xu̱ta̱ nga tínchja̱ko̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kits'ínkjane Pedro̱ a̱nkju̱o̱ ko̱ ta̱kjín xi 'mi Rode̱ j'aisehe̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nk'ie nga kint'é ta̱kjíu̱n nta̱ha̱ Pedro̱, 'yún kama tsjoho̱ ko̱ tsangatsanka nga ngji tsúyaha̱ xu̱ta̱ xingisoo̱ nga a̱sti a̱nkju̱o̱ síjña Pedro̱. Ta̱ ndaha najmi kikjex'á a̱nkju̱o̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","—¿A tíma luku̱ ní? —kik'ihi̱n. Tu̱nga b'a̱há kitsú ta̱kjíu̱n nga kju̱axi̱ niu̱. —Kutsa ntítsjehe̱ ní Pedro̱ niu̱ —kitsú jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Máha Pedro̱, tu̱ nku títs'ínkjanehé a̱nkju̱o̱. Nk'ie nga kikjex'á a̱nkju̱o̱ jóo̱ ko̱ kikie nga Pedro̱ niu̱, tu̱ ni xí kitsankjúhún. ");
INSERT INTO majNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tu̱nga kits'ínk'ajnihí ntsja Pedro̱ nga b'a̱ kitsú nga najmi ku̱i̱nchja̱ jóo̱. Kitsúyaha̱ xi nkú ts'ín Nti̱a̱ná kik'onsjehe̱ a̱ya nu̱ba̱yóo̱ ko̱ b'a̱ kitsúhu̱ jóo̱: —T'inyoho̱o Santiago̱ ko̱ já nts'eé ni xi kamoo̱. A̱s'a̱i tsitju nga ngji t'axín. ");
INSERT INTO majNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nk'ie nga kama see̱n, ndaha najmi be nkú ts'i̱ín já juu̱n, a̱t'aha̱ najmi be má kafíhi̱ Pedro̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kitsjá kju̱a̱ Herode̱ Antipa̱ nga ku̱i̱nchísjai, tu̱nga najmi kisakúhú ra̱. Kui nga kits'ínko̱kju̱a̱ha já jun xi tíi̱ncha kunntá nu̱ba̱yóo̱ ko̱ b'a̱ kitsú nga n'e̱k'ien. Kui ni̱stjiu̱n tsitju Herode̱ Agripa̱ a̱nte Judea̱ nga ngjik'iejña nanki Cesarea̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herode̱ Agripa̱ tíjñachánko̱ xu̱ta̱ nanki Tiro̱ ko̱ xu̱ta̱ nanki Sidon. A̱s'a̱i nkuhú kits'ín yjoho̱ xu̱ta̱ xu'bo̱ nga j'aisehe̱ Herode̱. Títjun nda kinchja̱ko̱ nda̱ Blasto̱, kui xi nku nda̱ k'aku̱ a̱jihi̱n já xi ts'ínxát'aha̱ nda̱ rei̱. A̱skahan kinchja̱ko̱ nda̱ rei̱ nga tsankihi̱ kju̱a̱jyu, a̱t'aha̱ xu̱ta̱ nankihi̱ jóo̱ nankihi̱ nda̱ rei̱ b'atse nichine. ");
INSERT INTO majNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ni̱stjin xi kitsú Herode̱ nga ku̱i̱nchja̱ni̱jmíko̱ jóo̱, kingja najyun tsjo tjíhi̱n ko̱ y'ejña a̱nte má nga ts'ín kju̱a̱ ko̱ kinchja̱ya. ");
INSERT INTO majNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A̱s'a̱i b'i̱ kitsú xu̱ta̱ nga i̱ncha kikjintáya: —Najmi nda̱ xi tínchja̱i̱. Nti̱a̱há niu̱. ");
INSERT INTO majNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ta̱ kuihi chu̱bo̱ nku ntítsjehe̱ Nti̱a̱ná kitsjá ch'ihi̱n Herode̱, a̱t'aha̱ najmi tjun y'éjña Nti̱a̱ná tsa kits'ínkie yjoho̱ nga Nti̱a̱náhá xi chánka. Chju̱ntu kikjinehe̱ ko̱ k'ien. ");
INSERT INTO majNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tu̱nga ngjindjuhú éhe̱n Nti̱a̱ná ko̱ kis'eni̱jmí tu̱ má xi tje̱hén ni. ");
INSERT INTO majNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabe ko̱ Saulo̱, nk'ie nga kama ndju̱úhu̱ xá xi kik'a̱i̱hi̱ nanki Jerusalen, kik'óya ngáha nga ngjiko̱ Jua xi ta̱ 'mi Marco̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A̱jihi̱n xu̱ta̱ ni̱nku̱ nanki Antiokia̱ y'entu Bernabe, Simon xi ta̱ 'mi Nda̱ Jma, Luci̱o̱ xi nibáha a̱nte Cirene̱, Manaen xi kama cháko̱ Herode̱ Antipa̱ xi tsatéxuma a̱nte Galilea̱, ko̱ Saulo̱. Kui jái̱ xi já profeta̱ ko̱ já maestru̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nk'ie nga kama ñjakú nga tíi̱ncha ts'íntsjoho̱ Nti̱a̱ná ko̱ nga tjíntu kjintíá, a̱s'a̱i Espiri̱tu̱ Santo̱ b'i̱ kitsúhu̱: —N'e̱ t'axínnú Bernabe ko̱ Saulo̱ tu̱ xi ts'i̱íhin xá xi tsjaha̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Y'entu kjintíá xu̱ta̱ ni̱nku̱, kinchja̱ko̱ Nti̱a̱ná ko̱ kingjénne ntsja Bernabe ko̱ Saulo̱. A̱s'a̱i kits'ínkji. ");
INSERT INTO majNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kui b'a̱ maha, nk'ie nga kits'ínkjihi̱ ra̱ Espiri̱tu̱ Santo̱ jóo̱, i̱ncha ngji nanki Seleuci̱a̱ ko̱ yo̱ jas'en nku tsutsu xi ngjiko̱ho̱ xjo̱ Chipre̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nk'ie nga tsichu nanki Salamina̱, y'éni̱jmí éhe̱n Nti̱a̱ná ni'ya sinagoga̱ha̱ xu̱ta̱ judio̱ xi tjín yo̱. Ta̱ i̱ncha tje̱nko̱ ya Jua nga tíbasinko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","A̱s'a̱i i̱ncha j'atikjá ngayjee̱ xjo̱ Chipre̱ ko̱ tsichu nanki Pafo̱. Yo̱ kisatéjin nku nda̱tj'e judio̱ xi 'mi Barjesu. Nku nda̱ profeta̱ kits'ín ma yjoho̱ ");
INSERT INTO majNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ko̱ tje̱nko̱ nda̱ títjuhu̱n Chipre̱. Nku nda̱ kitikju̱a̱ xi 'mi Sergi̱o̱ Paulo̱ nda̱ títjuu̱n. A̱s'a̱i kinchja̱ha̱ Bernabe ko̱ Saulo̱, a̱t'aha̱ mjehe̱ ku̱a̱sínñjuhu̱ éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tu̱nga nda̱tj'ee̱, xi ta̱ Elima̱ 'mi ya nga én griego̱, ngji kontra̱ha̱ Bernabe ko̱ Saulo̱. Y'éch'oho̱ nda̱ títjuu̱n tu̱ xi najmi s'e̱jihi̱n ra̱ yáha Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","A̱s'a̱i j'aitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱ Saulo̱, xi ta̱ 'mi ya Pablo̱. Tsase'a nda̱tj'ee̱ ");
INSERT INTO majNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ko̱ b'i̱ kitsú: —¡Ji xi tu̱ nku ch'ana̱cha̱há ri̱ xu̱ta̱ ko̱ 'yún ch'onk'uin! ¡Ji xi ntíhi̱ nda̱nindoo̱, a̱t'aha̱ b'a̱ tín'ei xi nkú ts'ín! ¡Ji xi tinchun kontra̱i̱hi̱ ngayjee̱ ni xi na̱xu̱ nginku̱n Nti̱a̱ná! ¿A tu̱ nku n'e̱tsitinní ni xi nda tjíhi̱n Nti̱a̱ná? ");
INSERT INTO majNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nd'a̱i̱ ngju̱a̱i̱ kontra̱hi nga'yúhu̱n Nti̱a̱ná. Ka̱ma ka̱i̱. Chuba ni̱stjin najmi ta̱ cha̱hani ts'íu̱. Ta̱ kuihi chu̱bo̱ tje̱n'yún najmi ta̱ kama chjihí ra̱ nda̱tj'ee̱. Kama jyuhu̱n ko̱ chu̱ba̱ kikjatsú'bahá nga tsangisjai nku xi kjébénkihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nk'ie nga kikie nda̱ títjuu̱n ni xi kamoo̱, kama nkjúhu̱n ni xi tsakúya Pablo̱ nga yáha Nda̱ Nti̱a̱ná Jesu ko̱ kis'ejihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","A̱s'a̱i Pablo̱ ko̱ já xi tje̱nko̱ jas'en nku tsutsu. Tsitju nanki Pafo̱ ko̱ tsichu Perge̱, nanki xi tíjñajihi̱n a̱nte Panfili̱a̱. Yo̱ y'éjña Jua jóo̱ ko̱ kik'óya ngáha nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pablo̱ ko̱ já xingisoo̱ tsitju nanki Perge̱ ko̱ ngji nanki Antiokia̱, nanki xi tíjñajihi̱n a̱nte Pisidi̱a̱. Nku xua̱tu̱ jas'en ni'ya sinagoga̱ xi síjña yo̱ ko̱ y'entu. ");
INSERT INTO majNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nk'ie nga kin'eya xu̱ju̱n kju̱a̱téxumoo̱ ko̱ xu̱ju̱n já profeta̱, b'i̱ kitsú já k'aku̱hu̱ xu̱ta̱ ni'ya sinagoga̱ nga kinchja̱: —Jun já nts'e, tsa tjínnu̱u én xi k'úéni̱jmíhu̱u xu̱ta̱, chu̱bo nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","A̱s'a̱i tsisintje̱n Pablo̱. Kingjénnk'a ntsja tu̱ xi ku̱a̱sínñjuhu xu̱ta̱ ko̱ b'i̱ kitsú: —Jun xi ntje̱ Israel tje̱he̱nnu̱u ko̱ jun xi najmi ntje̱ Israel tje̱he̱nnu̱u xi yankjún Nti̱a̱ná, ta̱sinñjunú. ");
INSERT INTO majNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nti̱a̱ha̱ xu̱ta̱ Israel, kui xi j'ájihi̱n ntje̱ cháná ko̱ nku na̱xi̱nantá chánka kits'ín ma nk'ie nga tjíntu sa a̱nte Egipto̱, má nga y'entut'á x'a̱n. A̱skahan nga'yúhu̱n kik'onsjeko̱ho ntje̱ cháná a̱nte Egipto̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kits'íntsentaha̱ a̱nte kixiu̱ nkú ra̱ ma yachán nú. ");
INSERT INTO majNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kits'ínkje yatu nanki i xi tjín a̱nte Canaan ko̱ kitsjáha̱ ntje̱ cháná a̱ntehe̱ tu̱ xi ka̱ma ts'e̱he. ");
INSERT INTO majNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","’A̱skahan, nkú ra̱ ma tsa ñju unchan ko̱ cháte nú, Nti̱a̱ná kitsjá xáha̱ já jue tu̱ xi ku̱a̱téxumaha̱ ra̱ na̱xi̱nantáná santaha nga tsichu ni̱stjihi̱n nda̱ profeta̱ Samuel. ");
INSERT INTO majNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","A̱s'a̱i tsanki na̱xi̱nantáná nga nku nda̱ rei̱ ku̱a̱téxumaha̱. B'a̱ ts'ín Nti̱a̱ná kitsjáha̱ ra̱ nku nda̱ rei̱. Yachán nú tjíhin tsatéxuma Saul xi ntíhi̱ Cis xi y'aha̱ ra̱ ntje̱he̱ Benjamin. ");
INSERT INTO majNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","’A̱skahan Nti̱a̱ná kikje'áha̱ xóo̱ Saul ko̱ David kits'ín ma nda̱ rei̱hi̱ xu̱ta̱. Kitsúya Nti̱a̱ná yáha David: “Kuasakúna David ntíhi̱ Isai. Kui xi nku nda̱ xi tsjo maha̱ ani̱ma̱na̱, xi ts'i̱íntjusunyje xi nkú nga ts'ín mjena.” ");
INSERT INTO majNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ntje̱he̱ David nibaha nda̱ xi kitsúya títjun Nti̱a̱ná nga ts'i̱ín nibásehe̱ xu̱ta̱ Israel tu̱ xi ts'i̱ínk'ankihi. Kui ndo̱ xi Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","’Kintehe̱ ni nga j'ai Jesu, Jua y'éni̱jmíhi̱ ngayjee̱ xu̱ta̱ Israel. B'a̱ kitsúhu̱ nga tjíhin nga ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱ ko̱ sa̱téntá. ");
INSERT INTO majNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nk'ie nga ja tíbichúkjet'a xáha̱ Jua, b'a̱ kitsú: “¿Yá xi tíbixíún nga an? Najmi an nda̱ xi tíchuyóho̱o. A̱skahan nibá nku xi 'yún nk'a tje̱n sa nga an, nga santaha najmi an tsuhuna tsa an kjendáya n'úhu̱ ntéhe̱.” ");
INSERT INTO majNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Jun já nts'e, jun xi ntje̱he̱ Abraham ko̱ jun xi najmi Israel tje̱he̱nnu̱u xi yankjún Nti̱a̱ná, ñá kin'e nibáná én xu'bi̱ xi ts'i̱ínk'ankiná. ");
INSERT INTO majNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","A̱t'aha̱ xu̱ta̱ Jerusalen ko̱ já tjíxáha̱ najmi kamankjihi̱n yáha Jesu ko̱ ta̱ ndaha ni xi tjít'a xu̱ju̱hu̱n já profeta̱ xi n'eya xki̱ xua̱tu̱. I̱ncha kitsú nga ngabaya tje̱he̱n ra̱ Jesu. B'a̱ ts'ín i̱ncha kits'íntjusuhun ni xi y'ét'a já profeta̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ndaha tsa najmi kisakújihi̱n mí kju̱a̱ha nga ka̱ma n'e̱k'iehen, tu̱nga tsinchihí ra̱ Pilato̱ nga n'e̱k'ien Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","’Nk'ie nga ja kits'íntjusun jóo̱ ngayjee̱ ni xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná má nga tínchja̱ni̱jmíyaha Jesu, a̱s'a̱i kikjeje̱nt'a kruu̱ ko̱ kingjáyanji. ");
INSERT INTO majNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tu̱nga Nti̱a̱náhá kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jesu nkjin ni̱stjin tsakúchjihi̱ yjoho̱ já xi tsitjuko̱ho̱ a̱nte Galilea̱ nga ngjiko̱ho̱ nanki Jerusalen. Nd'a̱i̱ kui já xu'bo̱ xi tíi̱ncha tsuyaha̱ xu̱ta̱ ni xi i̱ncha kikie. ");
INSERT INTO majNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Ji̱n ta̱ tíbixínyai̱ én nda tsu xu'bi̱ xi tínchja̱ ni xi Nti̱a̱ná kitsúya títjuhu̱n ntje̱ cháná nga tsjáha̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Kui niu̱ xi ja kits'íntjusun Nti̱a̱ná ngandaná ñá xi y'ahaná ntje̱he̱ ntje̱ cháná, nk'ie nga kits'ínkj'áíyaha̱ Jesu ngabayoo̱. Xi nkú ts'ín tjít'a xu̱ju̱n salmo̱ xki̱ jo: “Ji xi Ntína̱, an xi tsichu ma Na̱'mihi̱.” ");
INSERT INTO majNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nti̱a̱ná kits'ínkj'áíya ngáha̱ ra̱ Jesu ngabayoo̱ tu̱ xi najmi ta̱ ku̱a̱tsúhun yjonintehe̱. A̱t'aha̱ b'a̱ kitsú: “Tsjanu̱u kju̱a̱ndana̱ xi kixihi̱n David.” ");
INSERT INTO majNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","’Kui nga b'a̱ ta̱ ts'ín tjít'a yaha kj'a̱í salmo̱: “Najmi k'u̱a̱i̱ntei nga ku̱a̱tsún yjonintehe̱ nda̱ xi ts'i̱.” ");
INSERT INTO majNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David, ni̱stjin nga y'ejña kits'ín ni xi mjehe̱ Nti̱a̱ná, a̱s'a̱i k'ien. Kama ñjakúko̱ xi cháha̱ ko̱ jentu yjonintehe̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tu̱nga máha nda̱ xi Nti̱a̱ná kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱, kui xi najmi jentu yjonintehe̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","’Kui b'a̱ maha, jun já nts'e, tjíhin nga cha̱hanu ni xu'bi̱. Jesu kits'ín nga ka̱ma ndyjat'aha̱ xu̱ta̱ jéhe̱. Kui nihi xi tíb'eni̱jmíi̱ nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kju̱a̱téxumaha̱ Moise najmi kamaha̱ kits'ín nda̱ínu̱u ngayjee̱ jé xi tjínnu̱u nginku̱n Nti̱a̱ná, tu̱nga Jesu ts'ín nda̱íhi̱ jéhe̱ ngayjee̱ xu̱ta̱ xi s'ejihi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","’Kui nga chúhu̱n ru̱u yjonu̱u nga najmi tu̱ jun ni̱banenu̱u ni xi y'ét'a já profeta̱. A̱t'aha̱ b'i̱ ts'ín tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná: ");
INSERT INTO majNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Cha̱so̱o, jun xi chajnucho xu̱ta̱ xingisoo̱, katuma nkjúnnu̱u ko̱ kandyjajihi̱nsón. A̱t'aha̱ an ts'ian nku ni ni̱stjin nga tintsu̱bo̱o, nku ni xi najmi s'e̱jinnu̱u ndaha tsa tjín xi ku̱i̱tsu̱yanu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","A̱s'a̱i tsitju ni'ya sinagoga̱ Pablo̱ ko̱ já xi tje̱nko̱. Xu̱ta̱ xi tjín yo̱ i̱ncha tsanki nga k'úínya saha̱ ni xu'bi̱ xua̱tu̱ xinkuu̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nk'ie nga tsitju xu̱to̱, nkjin xu̱ta̱ judio̱ ko̱ xi najmi judio̱ xi benkjún Nti̱a̱ná kitsjennkíhi̱ Pablo̱ ko̱ Bernabe. Kui b'a̱ kitsúhu̱ xu̱to̱ nga tjíhin nga k'úéntujín kju̱a̱ndaha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Xua̱tu̱ xinkuu̱ xi mjehé kama ñjakúyjee̱ xu̱ta̱ xi tjín yo̱ tu̱ xi ku̱a̱sínñjuhu̱ ra̱ éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tu̱nga nk'ie nga i̱ncha kikie já judio̱ xu̱ta̱ nkjiu̱n, 'yún kama nchi̱ni̱. Ngji kontra̱ha̱ ni xi tíb'éni̱jmí Pablo̱ ko̱ ch'on kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","A̱s'a̱i 'yún ndjá kinchja̱ sa Pablo̱ ko̱ Bernabe. B'i̱ i̱ncha kitsú: —Kamachjéhe̱n nk'ie nga jun títjun kis'eni̱jmínu̱u éhe̱n Nti̱a̱ná, tu̱nga najmi tín'ekjáíhín ru̱u ée̱n. B'a̱ ts'ín tíbakuchjíhinu nga najmi tje̱he̱nnu̱u nga ku̱i̱ntsu̱ba̱ tík'un síún. Kui kju̱a̱ha nga tu̱ sahá xu̱ta̱ xi tjín a̱sunntee̱ kuankínk'ieni̱jmíhi̱ ri̱ nd'a̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","A̱t'aha̱ b'i̱ kitsúni̱ Nti̱a̱ná nga y'éxáni̱: Ji xi nkú joyaha nku nd'í xi tsjaha̱ xu̱ta̱ xi tjín a̱sunntee̱, tu̱ xi k'úínko̱honi én xi ts'ínk'ankihi̱ xu̱ta̱ santaha má fekuhu̱ a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nk'ie nga kint'é én xu'bi̱ xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱, kama tsjoho̱ ko̱ b'a̱ i̱ncha kitsú nga tjíhi̱n kju̱a̱chánka éhe̱n Nti̱a̱ná. Kis'ejihi̱n ni xi y'éni̱jmí Pablo̱ ngayjee̱ xu̱ta̱ xi ja j'ájin Nti̱a̱ná nga tjíhin nga k'úéntu tík'un sín. ");
INSERT INTO majNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ngjindju éhe̱n Nti̱a̱ná nga kis'eni̱jmí ngayjee̱ a̱nte xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tu̱nga já judio̱hó tsinchá'a jminchjín xi benkjún Nti̱a̱ná ko̱ xi nda behe̱ xu̱ta̱, ko̱ ta̱ tsinchá'a já k'aku̱hu̱ nankiu̱ xi má nga tsinchákjaha̱n. Kitsjennkí unkie Pablo̱ ko̱ Bernabe ko̱ kik'onsje nankihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","A̱s'a̱i y'étsujne ndyjo tsu̱ku̱ Pablo̱ ko̱ Bernabe tu̱ xi tsakúchjihi nga najmi kui xi tjíhi̱n jé. A̱s'a̱i i̱ncha ngji nanki Iconi̱o̱. ");
INSERT INTO majNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Xu̱ta̱ xi yjankihi̱ Jesu xi y'entu Antiokia̱, nanki xi tíjñajihi̱n Panfili̱a̱, kis'e ṉkjúhu̱n kju̱a̱tsjo ko̱ kitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nk'ie nga jas'en Pablo̱ ko̱ Bernabe ni'ya sinagoga̱ha̱ xu̱ta̱ judio̱ xi tjín nanki Iconi̱o̱, i̱ncha y'éni̱jmí éhe̱n Nti̱a̱ná nga i̱xí nkjihín xu̱ta̱ judio̱ ko̱ xi najmi judio̱ kis'ejihi̱n ni xi tíi̱ncha b'éni̱jmí. ");
INSERT INTO majNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tu̱nga já judio̱ xi najmi s'ejihi̱n yáha Jesu tsinchákjaha̱n xu̱ta̱ xi najmi judio̱ xi má nga ch'on ts'ín ku̱a̱se̱he̱ já nts'eé. ");
INSERT INTO majNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nkjin ni̱stjin ts'andayaha̱ Pablo̱ ko̱ Bernabe yo̱. I̱ncha behe̱ k'un nga Nda̱ Nti̱a̱ná Jesu tíbasinko̱ho̱ ko̱ ndjá kinchja̱ni̱jmíyaha kju̱a̱ndaha̱ Nda̱ Nti̱a̱ná. Kin'echjén jóo̱ nga kits'ín kju̱a̱nkjún ko̱ kama ni xi tsakúchji nga kju̱axi̱ én xi tínchja̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A̱s'a̱i tsakjánya yjoho̱ xu̱ta̱ na̱nti̱o̱. Tjín xi kamako̱ xu̱ta̱ judio̱ ko̱ tjín xi kamako̱ já postru̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Já nankiu̱ ko̱ já judio̱ y'éndako̱ já tjíxóo̱ tu̱ xi ts'i̱ín'uhu̱n ra̱ ko̱ k'u̱éhe̱ ra̱ ndji̱o̱ já postru̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nk'ie nga kint'é já postru̱ niu̱, Listra̱ ko̱ Derbe̱ i̱ncha tsanka, nanki xi tjíntujíhi̱n a̱nte Licaoni̱a̱. Ko̱ ngji ya a̱nte xi tjíndai yo̱ ");
INSERT INTO majNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","má nga ta̱ i̱ncha y'éni̱jmí én nda tsuhu̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra̱ y'ejña nku nda̱ ni̱ma̱ xi tu̱ b'a̱ ts'ín najmi mahá fi nkúhu nga kitsin. Kui xi y'ejña ");
INSERT INTO majNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","nga tsasínñjuhu̱ ni xi tínchja̱ Pablo̱. A̱s'a̱i Pablo̱ tsase'a ndo̱ ko̱ kikie nga s'ejihi̱n xi má nga ka̱manda. ");
INSERT INTO majNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","A̱s'a̱i b'i̱ kitsúhu̱ nga 'yún kinchja̱: —Ti̱si̱njña kixi̱. A̱s'a̱i i̱xí kikjennk'áhá ndo̱ ko̱ kikjatsú'ba. ");
INSERT INTO majNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nk'ie nga kikie xu̱to̱ ni xi kits'ín Pablo̱, b'i̱ i̱ncha kitsú nga i̱ncha kikjintáya nga én Licaoni̱a̱: —Ja kaf'aijénjinná jo nti̱a̱. Yjonintehe̱ xu̱ta̱ i̱ncha kab'a. ");
INSERT INTO majNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","B'a̱ i̱ncha kitsú nga Bernabe xi nti̱a̱ Zeu̱s ko̱ nga Pablo̱ xi nti̱a̱ Herme̱s, a̱t'aha̱ Pablo̱ xi tínchja̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A̱s'a̱i nda̱ na̱'mi xi ts'ínxáha̱ nti̱a̱ Zeu̱s j'aiko̱ turu̱ ko̱ naxú tsjo k'un a̱nkju̱a̱ha̱ nankiu̱, má nga síjña ni̱nku̱hu̱ nti̱a̱ Zeu̱s. Nda̱ na̱'miu̱ ko̱ xu̱ta̱ na̱nti̱o̱ i̱ncha mjehe̱ tsjáha̱ chje̱ já postru̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tu̱nga nk'ie nga kamankjihi̱n Bernabe ko̱ Pablo̱ ni xi tímoo̱, kikjenti̱yajen najyuhu̱n ko̱ ki̱tsa̱ ngjijihi̱n xu̱ta̱ na̱nti̱o̱ nga i̱ncha kikjintáya nga ");
INSERT INTO majNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","b'i̱ i̱ncha kitsú: —Jun já, ¿á b'a̱ tín'ehenu? Ta̱ xu̱ta̱ níi̱ xi nkúhu jun. Tíb'eni̱jmíi̱ a̱jinnu̱u nga tjíhin nga k'úéntu ni xu'bi̱ xi najmi chumi ni chjíhi̱ ra̱ ko̱ n'e̱kjóho̱on Nti̱a̱ xi tíjña tík'un. Kui xi kits'ínnda nk'a ján, t'anankiu̱, ntáchak'uu̱n ko̱ ngayjee̱ ni xi tjíhi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ni̱stjin nk'ie kitsjánte Nti̱a̱ná nga xu̱ta̱ xi tjín a̱sunntee̱ ts'i̱ín sin chá xi be. ");
INSERT INTO majNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tu̱nga tu̱ nkú kitsjáhá ra̱ xu̱ta̱ ni xi nda tu̱ xi tsakúchjihi yjoho̱. A̱t'aha̱ kui xi ts'ín nibáná ts'í ko̱ tsjáná cha̱n xi nda. Tsjáná nichine ko̱ ts'íntsehe ani̱ma̱ná kju̱a̱tsjo. ");
INSERT INTO majNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","B'a̱ kitsú Pablo̱ ko̱ Bernabe. A̱s'a̱i tu̱ ni xí kis'enkihí ra̱ kju̱a̱ni̱ma̱ nga k'u̱éch'oho̱ xu̱ta̱ nga̱t'aha̱ chje̱ xi mjehe̱ tsjá. ");
INSERT INTO majNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","A̱s'a̱i já judio̱ xi nibaha nanki Antiokia̱ ko̱ nanki Iconi̱o̱ j'ainchá'a xu̱ta̱ nkjiu̱n. I̱ncha y'éhe̱ ndji̱o̱ Pablo̱ ko̱ kikjebéfehe̱ na̱tsin na̱nti̱o̱. Ja ka'me i̱ncha kitsú. ");
INSERT INTO majNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tu̱nga nk'iehé nga kama ñjakúndaihi̱ Pablo̱ xu̱ta̱ xi yjankihi̱ Jesu, tsisintje̱n Pablo̱ ko̱ jas'en a̱jin na̱nti̱o̱. Ni̱stjin xi ma ndyjuu̱n ngjiko̱ Bernabe nanki Derbe̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Y'éni̱jmí Pablo̱ ko̱ Bernabe én nda tsuhu̱ Jesu nanki Derbe̱ ko̱ nkjin ṉkjún xu̱ta̱ xi tjín yo̱ kitsjennkíhi̱ Jesu. A̱s'a̱i kik'óya ngáha jóo̱ nanki Listra̱, Iconi̱o̱ ko̱ Antiokia̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nk'ie nga i̱ncha j'a yo̱, b'a̱ i̱ncha kitsúhu̱ xu̱ta̱ ni'yakuyóo̱ nga tjíhin nga k'úéntujín tehe̱nte ni xi s'ejihi̱n. B'i̱ kitsú yaha̱: —Nkjin tíkjá kju̱a̱ni̱ma̱ bitjajiáán tu̱ xi bitjas'e̱njihinná nga Nti̱a̱ná xi batéxumaná. ");
INSERT INTO majNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Xki̱ ni̱nku̱ xi tjín nanki xu'bo̱ i̱ncha kinchja̱ko̱ Nti̱a̱ná ko̱ y'entu kjintíá, a̱s'a̱i y'ét'a xá já xi ku̱a̱se̱he̱ ni̱nku̱. Kits'ínkjas'en jóo̱ a̱ya ntsja Nti̱a̱ná a̱t'aha̱ kis'ejihi̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","A̱s'a̱i i̱ncha j'a Pablo̱ ko̱ Bernabe nanki xi tjín a̱nte Pisidi̱a̱ ko̱ i̱ncha j'ai a̱nte Panfili̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nk'ie nga ja y'éni̱jmí éhe̱n Nti̱a̱ná nanki Perge̱, i̱ncha ngji nanki Atali̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Yo̱ jas'en nku tsutsu xi ngjiko̱ho̱ nanki Antiokia̱, yo̱ má nga kin'ekjas'en a̱ya ntsja Nti̱a̱ná nga tjuhu̱n ni tu̱ xi ku̱a̱si̱nko̱ho̱ ra̱ xá xi ts'i̱ín. J'ai yo̱ a̱t'aha̱ ja kama ndju̱ú xóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nk'ie nga j'ai nanki Antiokia̱, kinchja̱ ñjakúhu̱ xu̱ta̱ ni̱nku̱ ko̱ kitsúyaha̱ ngayjee̱ ni xi kits'ínko̱ho̱ Nti̱a̱ná ko̱ xi nkú ts'ín Nti̱a̱ná kitsjántehe̱ xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱ xi má nga ko̱ kui s'e̱jihi̱n éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nkjin ni̱stjin ts'andayaha̱ Pablo̱ ko̱ Bernabe yo̱ nga y'entujíhi̱n xu̱ta̱ xi yjankihi̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","A̱s'a̱i tsichu nanki Antiokia̱ k'u̱a̱ já xi nibaha a̱nte Judea̱. Kui xi b'i̱ ts'ín tsakúyaha̱ xu̱ta̱ ni̱nku̱: —Tsa najmi n'e̱nu̱u ni circuncision xi nkú ts'ín tíjña sin chá xi y'ét'aná Moise, najmi ka̱ma k'u̱a̱nkiu. ");
INSERT INTO majNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kui nga Pablo̱ ko̱ Bernabe y'ésiko̱ho jóo̱. 'Yún kinchja̱ni̱jmíyako̱ho jóo̱ niu̱. Kui nga b'a̱ ts'ín i̱ncha y'éndako̱ho xinkjín xu̱ta̱ ni̱nku̱ nga Pablo̱ ko̱ Bernabe ko̱ k'u̱a̱ já ni̱nku̱ nanki Antiokia̱ i̱ncha ngju̱a̱i̱ nanki Jerusalen xi má nga ku̱i̱nchja̱ni̱jmíyako̱ho já postru̱ ko̱ jácháha̱ ni̱nku̱ nanki Jerusalen kju̱a̱sti xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","A̱s'a̱i tsitju já xi kits'ínkji xu̱ta̱ ni̱nku̱. I̱ncha j'a a̱nte Fenici̱a̱ ko̱ a̱nte Samari̱a̱ nga tíi̱ncha tsuya xi nkú ts'ín kits'ínk'óntjaiya yjoho̱ ko̱ kis'ejihi̱n Nti̱a̱ná xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱. Ngayjee̱ já nts'eé tu̱ xí tsjohó kamaha̱ nga kint'é én xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nk'ie nga i̱ncha j'ai nanki Jerusalen, xu̱ta̱ ni̱nku̱, já postru̱ ko̱ jácháha̱ ni̱nku̱ kits'ínkjáíhi̱n. A̱s'a̱i kitsúya jóo̱ ngayjee̱ ni xi kits'ínko̱ho̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tu̱nga tsisintje̱hén k'u̱a̱ já fariseo̱ xi ja kis'ejihi̱n Jesu ko̱ b'i̱ i̱ncha kitsú: —Xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱ tjíhin nga n'e̱he̱ ni circuncision ko̱ tjíhin nga s'e̱ni̱jmíhi̱ nga ts'i̱íntjusun kju̱a̱téxumaha̱ Moise. ");
INSERT INTO majNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","A̱s'a̱i kama ñjakú já postru̱ ko̱ jácháha̱ ni̱nku̱ nga kinchja̱ni̱jmíyako̱ho xinkjín ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nk'ie nga ja 'yún tse kinchja̱ni̱jmíyaha niu̱, a̱s'a̱i tsisintje̱n Pedro̱ ko̱ b'i̱ kitsú: —Jun já nts'e, ja yo nga nd'a̱i j'ájihinna Nti̱a̱ná a̱jinnu̱u xi má nga an xínyaha̱ xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱ én nda tsuhu̱ Jesu tu̱ xi s'e̱jihi̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nti̱a̱ná be ani̱ma̱ha̱ ngayjee̱ xu̱ta̱ ko̱ kui tsakúchji nga ta̱ kits'ínkjáíhi̱n xu̱ta̱ xu'bo̱ nk'ie nga kitsjáha̱ Espiri̱tu̱ Santo̱ xi nkú ts'ín kitsjáná. ");
INSERT INTO majNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Najmi ngabi kits'ín Nti̱a̱ná a̱jihi̱n xu̱ta̱ xu'bo̱ ko̱ a̱jinná. Tu̱ sahá ta̱ kits'ín je ani̱ma̱ha̱ tu̱ nga̱t'aha̱ nga kis'ejihi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","’Kui b'a̱ maha nd'a̱i̱, ¿á tíbankín kontra̱ha̱ ru̱u Nti̱a̱ná nga mjehe̱nu̱u n'e̱k'anjihinu xu̱ta̱ xi s'ejihi̱n ra̱ Jesu ch'á xi najmi tsichukju̱a̱ha̱ ra̱ ntje̱ cháná ko̱ xi ta̱ ndaha ñá najmi chúkju̱a̱ná nga ch'anjiá? ");
INSERT INTO majNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","S'ejin níná nga k'u̱a̱nkiá tu̱ nga̱t'aha̱ kju̱a̱ndaha̱ Nda̱ Nti̱a̱ná Jesu xi nkú ko̱ ta̱ ts'ín k'u̱a̱nki xu̱ta̱ xu'bo̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","A̱s'a̱i kindyjanta ngayjee̱ xu̱ta̱ ko̱ tsasínñjuhu̱ ni xi kitsú Bernabe ko̱ Pablo̱, xi nkú ts'ín Nti̱a̱ná kitsjáha̱ nga'yún nga kits'ín a̱jihi̱n xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱ kju̱a̱nkjún ko̱ ni xi tsakúchji kju̱a̱chánkaha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nk'ie nga ja kamaha̱ nga i̱ncha kinchja̱ Bernabe ko̱ Pablo̱, b'i̱ kitsú Santiago̱ nga kinchja̱: —Jun já nts'e, ta̱sinñjunú. ");
INSERT INTO majNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ja kuatsúyaná Simon xi nkú ts'ín Nti̱a̱ná kik'atuts'i̱hi̱n ra̱ nga kama ni̱ma̱ha̱ xu̱ta̱ xi najmi ntje̱ Israel tje̱he̱n ra̱ ko̱ j'ájin a̱jihi̱n xu̱ta̱ xu'bo̱ nku na̱xi̱nantá xi ta̱ ka̱ma ts'e̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ta̱ kui nii̱ xi kitsú já profeta̱ má nga b'i̱ ts'ín y'ét'a: ");
INSERT INTO majNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","A̱skahan kjúái̱ ngáhana ko̱ ts'inndáya ngáhana ni'yaha̱ David xi ja tsijneya. Ts'inndáya ni xi tsatsuu̱n ko̱ kjesíntje̱n ngáhana, ");
INSERT INTO majNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tu̱ xi xu̱ta̱ xingisoo̱ ku̱a̱ngisjaihina, ngayjee̱ xu̱ta̱ xi j'ajíán. ");
INSERT INTO majNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","B'a̱ kitsú Nti̱a̱ná, kui xi y'éjña chji ni xu'bi̱ santaha nkúhu nú chá ján. ");
INSERT INTO majNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Kui nga b'a̱ tíxihinna nga najmi tu̱ nchjá n'ehe̱ ra̱á ée̱n xu̱ta̱ xi najmi ntje̱ Israel tje̱he̱n ra̱ xi s'ejihi̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tu̱ sahá n'e̱kjíhi̱í xu̱ju̱n nga b'a̱ k'úíhi̱ín nga najmi tu̱ kji̱ne̱ nichine xi chje̱ kik'a̱i̱hi̱ ra̱ nti̱a̱ xi ts'ínnda xu̱ta̱, nga najmi tu̱ katjantuko̱ jminchín nga najmi kje̱e bixan, nga najmi kji̱ne̱ yjoho̱ chu̱ xi nubantu, ko̱ nga najmi kji̱ne̱ jní. ");
INSERT INTO majNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","A̱t'aha̱ santaha nkúhu nk'ie tjín xi b'éni̱jmí kju̱a̱téxumaha̱ Moise xki̱ nanki nk'ie nga n'eya kju̱a̱téxumoo̱ xki̱ xua̱tu̱ ni'ya sinagoga̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","A̱s'a̱i y'éndako̱ xinkjín já postru̱ ko̱ jácháha̱ ni̱nku̱ ko̱ ngayjee̱ xu̱ta̱ ni̱nku̱ nga kj'u̱ájin já xi ts'i̱ínkjiko̱ Pablo̱ ko̱ Bernabe nanki Antiokia̱. Y'ét'a xá Juda̱ xi ta̱ 'mi Barsaba ko̱ Sila̱. Já k'aku̱ a̱jihi̱n já nts'eé já xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","B'i̱ tsu xu̱ju̱n xi kamanda: “Ji̱n, já postru̱ ko̱ jácháha̱ ni̱nku̱ Jerusalen, tín'ekjíi̱hi̱ kju̱a̱suniña já nts'eé xi najmi ntje̱ judio̱ tje̱he̱n ra̱ xi tjíntu nanki Antiokia̱ ko̱ nanki xi tjíntujín a̱nte Siri̱a̱ ko̱ a̱nte Silici̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","’Kinu'yái̱ nga tjín k'u̱a̱ já xi e̱i̱ tsitjujihi̱nni̱, já xi najmi ji̱n y'exái̱. Kits'ín ntji̱nu̱u ni xi tsakúya jóo̱ ko̱ kits'ínndyjajinnu̱u xi nkú ts'ín s'ejinnu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kui nga tjínkuhu̱ni̱ nga y'ét'a xái̱ já xi tín'ekjíko̱i̱ Bernabe ko̱ Pablo̱. Kui xi tjoni̱ ");
INSERT INTO majNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ko̱ kui xi ja kitsjáha̱ yjoho̱ nga tsa ku̱a̱yá nga̱t'aha̱ Nda̱ Nti̱a̱ná Jesucristo̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tín'ekjíi̱ Juda̱ ko̱ Sila̱, kui xi ku̱i̱nchja̱ko̱nu̱u nga ku̱i̱tsu̱yanu̱u ni xi y'endai̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","’A̱t'aha̱ Espiri̱tu̱ Santo̱ ko̱ ji̱n b'a̱ mani̱ nga nda tjín nga tu̱ nkuhú ch'á xu'bi̱ xi n'e̱k'anjii̱hi̱, xi tjíhin nga n'e̱tjusun. ");
INSERT INTO majNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Najmi tu̱ chino nichine xi chje̱ kik'a̱i̱hi̱ ra̱ nti̱a̱ xi ts'ínnda xu̱ta̱, ta̱ ndaha jní, ta̱ ndaha yjoho̱ chu̱ xi kinubantu, ko̱ najmi tu̱ suntuko̱ jminchjín nga najmi kje̱e bixon. Tsa k'úéntu t'axíún ni xu'bi̱, nda n'o̱o. Nda kat'enu̱u.” ");
INSERT INTO majNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","A̱s'a̱i i̱ncha ngji já xi kis'et'a xóo̱ ko̱ i̱ncha tsichu nanki Antiokia̱. Yo̱ kinchja̱ ñjakúhu̱ ngayjee̱ xu̱ta̱ ni̱nku̱ ko̱ kits'ínkjas'ehe̱n xu̱ju̱n. ");
INSERT INTO majNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nk'ie nga kits'ínyaha̱ xu̱ju̱n xu̱ta̱ ni̱nku̱, tsjo i̱ncha kamaha̱ a̱t'aha̱ kichjuxíhi̱n ni xi títs'ín ntji̱hi̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juda̱ ko̱ Sila̱ xi ta̱ já profeta̱ tse kinchja̱ni̱jmíko̱ xu̱ta̱ ni̱nku̱. B'a̱ ts'ín kisakú nga'yúhu̱n ra̱ já nts'eé ko̱ ndjá tsinchajin ni xi kis'ejihi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Já xi i̱ncha tsichu nanki Antiokia̱ ts'andaya jaha̱ yo̱, a̱s'a̱i i̱ncha kik'óya ngáha nanki Jerusalen. Nda ts'ín i̱ncha kits'ínkjihi̱ já nts'eé. ");
INSERT INTO majNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tu̱nga y'ejñahá Sila̱ yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo̱ ko̱ Bernabe ta̱ y'entu Antiokia̱ nga tsakúya éhe̱n Nti̱a̱ná ko̱ y'éni̱jmí én nda tsuhu̱ Jesucristo̱. Nkjin já nts'eé xi b'a̱ ta̱ i̱ncha kits'ín. ");
INSERT INTO majNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","J'a ni̱stjiu̱n, a̱s'a̱i Pablo̱ b'i̱ kitsúhu̱ Bernabe: —Tankíhi̱ntsubek'áán já nts'eé xi tjíntu má nga y'eni̱jmíaá én nda tsuhu̱ Nda̱ Nti̱a̱ná tu̱ xi cha̱haná nkú ts'ín tjíntu. ");
INSERT INTO majNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Mjehe̱ Bernabe nga ngju̱a̱i̱ko̱ Jua xi ta̱ 'mi ya Marco̱. ");
INSERT INTO majNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tu̱nga b'a̱há kitsú Pablo̱ nga najmi nda tjín tsa ngju̱a̱i̱ko̱ nda̱ xi kits'ín nga maha̱ a̱nte Panfili̱a̱, nda̱ xi najmi kits'ínndju̱úko̱ho̱ xáha̱ nga tjuhun. ");
INSERT INTO majNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kits'ín ngabihi̱ xinkjín, a̱t'aha̱ kits'ínstiko̱. Kui nga Bernabe ngjiko̱ho Marco̱ xjo̱ Chipre̱. Ni̱yá ntá i̱ncha kits'ín. ");
INSERT INTO majNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Máha Pablo̱, Sila̱ ngjiko̱. I̱ncha tsitju nk'ie nga já nts'eé kits'ínkjas'ehe̱n a̱ya ntsja Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","A̱s'a̱i i̱ncha j'a a̱nte Siri̱a̱ ko̱ a̱nte Cilici̱a̱. Kitsjáha̱ nga'yúhu̱n xu̱ta̱ ni̱nku̱ xi tjín yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","A̱s'a̱i tsichu Pablo̱ nanki Derbe̱ ko̱ nanki Listra̱. Yo̱ kisakúhu̱ nku nda̱ xi tje̱nnki Jesucristo̱ xi 'mi Timoteo̱. Na̱aha̱ Timoteo̱ ntje̱ judio̱ tje̱he̱n ra̱ ko̱ s'ejihi̱n Nti̱a̱ná, tu̱nga nda̱ griego̱hó na̱'mihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Já nts'eé xi tjíntu Listra̱ ko̱ Iconi̱o̱ nda ts'ín i̱ncha kinchja̱ni̱jmíyaha Timoteo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","A̱s'a̱i b'a̱ kitsú Pablo̱ nga Timoteo̱ tsjénko̱ho̱ ko̱ kits'íhi̱n ni circuncision, tu̱ xi najmi ch'on ka̱maha̱ ra̱ xu̱ta̱ judio̱ xi tjíntu a̱nte xu'bo̱. A̱t'aha̱ ngayjee̱ xu̱ta̱ be nga ntje̱ griego̱ tje̱he̱n ra̱ na̱'mihi̱ Timoteo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Xki̱ a̱nte má nga j'a kitsúyaha̱ xu̱ta̱ ni̱nku̱ ni xi y'énda já postru̱ ko̱ jácháha̱ ni̱nku̱ Jerusalen, tu̱ xi ts'i̱íntjusuhun. ");
INSERT INTO majNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kui b'a̱ maha, xu̱ta̱ ni̱nku̱ 'yún kama 'yún tak'uhun Nti̱a̱ná ko̱ xki̱ ni̱stjin 'yún i̱ncha kama nkjin. ");
INSERT INTO majNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","J'a ni̱yá Pablo̱ ko̱ já xi tje̱nko̱ nanki xi tjíntujín a̱nte Frigi̱a̱ ko̱ a̱nte Galaci̱a̱, a̱t'aha̱ Espiri̱tu̱ Santo̱ najmi kitsjántehe̱ nga k'u̱éni̱jmí éhe̱n Nti̱a̱ná nanki xi tjín a̱nte Asi̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nk'ie nga tsichu tiña nanki Misi̱a̱, mjehe̱ jóo̱ kju̱a̱s'en a̱nte Bitini̱a̱, tu̱nga najmi kitsjántehé ra̱ Espiri̱tu̱hu̱ Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kui nga tu̱ j'a ni̱yáhá ni nanki Misi̱a̱ nga i̱ncha ngji nanki Troa̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nk'ie nga jyuu̱n xi nkúhu tsa nchi̱ni kik'a̱i̱hi̱ Pablo̱ nga kama chjihi̱ nku nda̱ xi nibáha Macedoni̱a̱ xi kabasinjña ndju. “Nibáí a̱nte Macedoni̱a̱ ko̱ ti̱si̱nko̱ni̱”, kitsúhu̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nk'ie nga kama chjihi̱ Pablo̱ niu̱, tje̱n'yún y'enda níi̱ yjoni̱ tu̱ xi kuankíhi̱nni̱ a̱nte Macedoni̱a̱. A̱t'aha̱ b'a̱ tsixíi̱n nga Nti̱a̱ná tínchja̱ni̱ tu̱ xi k'úéni̱jmíhi̱ ri̱ én nda tsuhu̱ Jesucristo̱ xu̱ta̱ xi tjín yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tsitjui̱ nanki Troa̱ ko̱ nkuhú nga tsankihi̱nni̱ xjo̱ xi 'mi Samotraci̱a̱. Ni̱stjin xi ma ndyjuu̱n tsichii̱ nanki Neapo̱li̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Yo̱ tsitjuhu̱ni̱ nga tsankii̱n Filipo̱. Nanki k'aku̱hu̱ a̱nte Macedoni̱a̱ niu̱, má nga tjíntu nkjin xu̱ta̱ Roma̱. Chuba ni̱stjin kamani̱ yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nku xua̱tu̱ tsitjui̱ a̱jin na̱nti̱o̱ ko̱ tsankii̱n tiña má f'a ntáje̱ nga tsankinnchisjái̱ a̱nte má ma ñjakú xu̱ta̱ nga nchja̱ko̱ Nti̱a̱ná. Tintsu̱ba̱i̱ yo̱ nga tsixínyai̱hi̱ éhe̱n Nti̱a̱ná jminchjín xi kama ñjakú. ");
INSERT INTO majNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","A̱s'a̱i nku ta̱chju̱ún xi benkjún Nti̱a̱ná xi 'mi Lidi̱a̱, xi nanki Tiatira̱ nibáha ko̱ najyun kuan batéña, nk'ie nga tíbasínñju, Nti̱a̱ná kits'ínko̱ ani̱ma̱ha̱ tu̱ xi 'yún nda ts'ín ts'i̱ínsihi̱n ra̱ ni xi tínchja̱ Pablo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kisatentá ta̱chjúu̱n ko̱ xu̱ta̱ xi tjíntu ni'yaha̱. A̱s'a̱i b'i̱ kitsúni̱: —Tsa b'a̱ tíbixíún nga s'ejin kju̱axi̱na Nti̱a̱ná, nibá n'e̱kj'áíyo ni'yana̱. Kits'ín kju̱a̱'yúhu̱nni̱ nga ku̱i̱ntsu̱ba̱i̱ ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ni xi kama nk'ie nga tíbankíi̱n a̱nte má ma ñjakú xu̱ta̱ nga nchja̱ko̱ Nti̱a̱ná, kisatéjii̱n nku ta̱kjín musu̱ xi tíjñajihi̱n ntjo̱ xi maha̱ basejin ni xi 'ma tíjña. Ts'ín ngana̱ ṉkjún to̱on já nti̱a̱ha̱ nga b'éjña chji ni xi basejin. ");
INSERT INTO majNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","B'i̱ kitsúni̱ nk'ie nga kitsjennkíni̱ ko̱ kikjintáya tje̱nnkini̱: —Kui jmii̱ xi ts'ínxát'aha̱ Nti̱a̱ná xi tíjña nk'a ján. Tíbakú ni̱yánu̱u xi nkú ts'ín k'u̱a̱nkihinu. ");
INSERT INTO majNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nkjin ni̱stjin tu̱ nku b'a̱há kits'ín. Tu̱ chahán kama stihi̱ Pablo̱, kits'ínk'ótjiya ko̱ b'a̱ kitsúhu̱ nda̱ninda xi tíjñajihi̱n ta̱kjíu̱n: —Ngajoho̱ Jesucristo̱ b'a̱ tíxihin nga ti̱tjujihi̱n ta̱kjíu̱n. Ta̱ kuihi chu̱bo̱ tsitjujíhi̱n ta̱kjíu̱n nda̱nindoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nk'ie nga kikie já nti̱a̱ha̱ ta̱kjíu̱n nga najmi ta̱ ka̱ma ts'i̱ín ngana̱ha to̱on, jakj'ánijé Pablo̱ ko̱ Sila̱. Ngjiko̱ kju̱a̱'yún a̱jin na̱nti̱o̱. Nginku̱n já tjíxóo̱ i̱ncha ngjiko̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nk'ie nga i̱ncha tsichuko̱ jóo̱ nginku̱n já jue, b'i̱ i̱ncha kitsú: —Já xi ntje̱ judio̱ tje̱he̱n ra̱ jái̱. Xu̱ta̱ná tíi̱ncha ts'ínndyjajihi̱n. ");
INSERT INTO majNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ni xi najmi ma ñá n'ekjáíhi̱ín ko̱ ta̱ ndaha najmi ma n'eé tíi̱ncha bakúya, a̱t'aha̱ já Roma̱há ñá. ");
INSERT INTO majNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A̱s'a̱i ko̱ xu̱ta̱ nkjiu̱n ngji kontra̱ha̱ Pablo̱ ko̱ Sila̱. B'a̱ i̱ncha kitsú já jue nga n'e̱sje najyun ndjuhu̱ jóo̱ ko̱ nga yá s'e̱he̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","A̱skahan nga ja kingjáha̱ nkjin ni̱yá, kits'ínkjas'en nu̱ba̱yóo̱ ko̱ b'a̱ kitsúhu̱ nda̱ xi basehe̱ nu̱ba̱yóo̱ nga 'yún kúnnta jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nk'ie nga b'a̱ kik'ihi̱n ndo̱, ngjiko̱ jóo̱. Kits'ínkjas'en má nga 'yún ndjáha̱ nu̱ba̱yóo̱ ko̱ y'ékj'á'yún tsjantsjan sjai jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tu̱nga nkú ra̱ ma nga masen ni̱stje̱n, Pablo̱ ko̱ Sila̱ tíi̱ncha nchja̱ko̱ Nti̱a̱ná ko̱ tíi̱ncha sehe̱ Nti̱a̱ná. Já nu̱ba̱yá xingisoo̱ tíi̱ncha basínñju nga b'a̱ tíi̱ncha ts'ín. ");
INSERT INTO majNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tu̱ nkuhú chón xi tu̱ xí 'yúhún kama. Xí y'étsujneyáha santaha má tjíyanji nu̱ba̱yóo̱. Tje̱n'yún tsix'ahá ngayjee̱ a̱nkju̱a̱ nu̱ba̱yóo̱ ko̱ tsixuntu ngayjee̱ n'úki̱cha̱ xi tjíntukj'áha̱ já nu̱ba̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nk'ie nga j'áha̱ nda̱ xi basehe̱ nu̱ba̱yóo̱ ko̱ kikie nga tje̱n ti̱xa̱ a̱nkju̱a̱ nu̱ba̱yóo̱, a̱s'a̱i ts'asje ki̱cha̱ha̱ xi má nga mjehe̱ ts'i̱ínk'ien yjoho̱. A̱t'aha̱ b'a̱ kitsú nga kits'ínnkjink'un nk'ie nga ja kabitju já nu̱ba̱yóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tu̱nga b'i̱hí kitsú Pablo̱ nga kikjintáya: —Najmi tu̱ n'e'uihi̱n yjohi̱. Tintsu̱ba̱ tente níi̱ e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","A̱s'a̱i tsanki nd'í ndo̱ ko̱ ki̱tsa̱ jas'en a̱yoo̱. I̱xí tíb'atsé nkjúhún nga tsasinkúnch'int'aha̱ Pablo̱ ko̱ Sila̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kik'onsje ko̱ b'i̱ kitsúhu̱: —Jun já nti̱a̱, ¿mí ni xi tjíhin nga ts'ian tu̱ xi k'u̱a̱nkihina? ");
INSERT INTO majNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","B'i̱ i̱ncha kitsú jóo̱: —N'e̱ s'ejin Nda̱ Nti̱a̱ná Jesucristo̱. B'a̱ ts'ín k'u̱a̱nkihini ji ko̱ xu̱ta̱ xi tjíntu ni'yahi̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Y'éni̱jmíhi̱ éhe̱n Nti̱a̱ná ndo̱ ko̱ ngayjee̱ xu̱ta̱ xi tjíntu ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ta̱ kuihi chu̱bo̱ nga jyuu̱n tsanéjnu ndo̱ má uhu̱n Pablo̱ ko̱ Sila̱. Ko̱ kisaténtá ndo̱ ko̱ ngayjee̱ xu̱ta̱ xi tjíntu ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ngjiko̱ ni'yaha̱ ko̱ kits'ínkjen ko̱ tsjo kik'ientuhu̱ ngayjee̱ nga kis'ejihi̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nk'ie nga ja kama see̱n, kits'ínkji já jue já xi b'a̱ ku̱i̱tsu̱hu̱ nda̱ xi basehe̱ nu̱ba̱yóo̱ nga ts'i̱ín nda̱íhi̱ Pablo̱ ko̱ Sila̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kitsúyaha̱ ndo̱ Pablo̱ én xi j'aik'íhi̱n nga b'i̱ kitsúhu̱: —Ja kuats'ín nibá én já jue nga k'uasjé'anu̱u. Kui nga ti̱tjusje̱henu nd'a̱i̱ ko̱ kas'enu̱u kju̱a̱jyu nga n'o̱o ni̱yá. ");
INSERT INTO majNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Tu̱nga b'a̱há kitsú Pablo̱ nga kinchja̱ko̱ já xi kits'ín nibá já jue: —Ta̱ Roma̱ ní tje̱he̱nni̱. ¿Nkú ts'ín nga kis'ehe̱ni̱ nginku̱n xu̱ta̱ nga ndaha najmi títjun kin'eko̱kju̱a̱ni̱, a̱s'a̱i kin'ekjas'enni̱ nu̱ba̱yá? ¿Á nd'a̱i̱ mjehe̱ ra̱ k'o̱nsje 'maha̱ni̱? ¡Najmi ka̱ma ni xi tíi̱ncha tsu! Kui ní kanibák'osjeni̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kik'óya ngáha jóo̱ ko̱ j'ai tsúyaha̱ já jue ni xi kitsú Pablo̱. A̱s'a̱i i̱ncha kitsankjún já jue nk'ie nga i̱ncha kint'é nga já Roma̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kui nga i̱ncha j'ainkihi̱ ra̱ kju̱a̱n'endyjat'a. Kik'onsje ko̱ tsankihi̱ nga i̱ncha ku̱i̱tjujin na̱nti̱o̱. ");
INSERT INTO majNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nk'ie nga ja tsitju'a Pablo̱ ko̱ Sila̱ nu̱ba̱yóo̱, ngji ni'yaha̱ Lidi̱a̱. A̱skahan nga ja kamaha̱ nga kikie já nts'eé ko̱ kitsjáha̱ nga'yúhu̱n, i̱ncha ngji ngáha. ");
INSERT INTO majNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","J'a Pablo̱ ko̱ já xi tje̱nko̱ nanki Amfipo̱li̱ ko̱ nanki Apoloni̱a̱. A̱s'a̱i i̱ncha tsichu nanki Tesaloni̱ka̱ má tíjñaha̱ nku ni'ya sinagoga̱ xu̱ta̱ judio̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Xi nkú ts'ín nkaha̱ Pablo̱ jas'en yo̱ jan xua̱tu̱ tjíhin nga kinchja̱ni̱jmíyako̱ho xu̱ta̱ ni xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kitsúyaha̱ xu̱ta̱ ko̱ y'éjña chjihi̱ nga tjíhin nga un sku̱e̱he̱ xi kits'ín nibá Nti̱a̱ná ko̱ nga kj'u̱a̱íya ngáha̱ ra̱ ngabayoo̱. B'i̱ kitsúhu̱ jóo̱: —Jesu xi tíb'eni̱jmínu̱u nd'a̱i̱, kui xi kits'ín nibá Nti̱a̱ná ngajoho̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","K'u̱a̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ kis'ejihi̱n ko̱ i̱ncha kamako̱ Pablo̱ ko̱ Sila̱. Ko̱ b'a̱ ta̱ i̱ncha kits'ín nkjin ṉkjún xu̱ta̱ griego̱ xi benkjún Nti̱a̱ná ko̱ nkjin jminchjín xi benkjúhu̱n na̱xi̱nantóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","A̱s'a̱i kama xintak'un xu̱ta̱ judio̱ xi najmi s'ejihi̱n. I̱ncha tsinchá'a k'u̱a̱ já ts'e ch'onk'un ko̱ kinchja̱ ñjaha̱ xu̱ta̱ nkjiu̱n. Xa̱áha̱n kits'ín xu̱ta̱. A̱s'a̱i i̱ncha j'ai kján ni'yaha̱ Jason nga tsangisjai Pablo̱ ko̱ Sila̱ tu̱ xi k'o̱nsjehe ko̱ ts'i̱ínkjas'ehe̱n ra̱ xu̱ta̱ nkjiu̱n. ");
INSERT INTO majNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nk'ie nga najmi kisakúhu̱ Pablo̱ ko̱ Sila̱, i̱ncha ngjiko̱ kju̱a̱'yún nginku̱n já tjíxóo̱ Jason ko̱ k'u̱a̱ já nts'eé xi tjíntu yo̱. B'i̱ i̱ncha kitsú nga i̱ncha kikjintáya: —Já xi títs'ínndyja̱jihi̱n ngayjee̱ xu̱ta̱ a̱sunntee̱ ta̱ ko̱ e̱i̱ ja i̱ncha j'ai. ");
INSERT INTO majNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason kits'ínkjáíhi̱n jóo̱ ni'yaha̱. Ngayjee̱ jóo̱ tífi kontra̱ha̱ kju̱a̱téxumaha̱ nda̱ títjun k'aku̱ Cesa̱r ko̱ b'a̱ tíi̱ncha tsu nga tíjña sa kj'a̱í nda̱ rei̱ xi 'mi Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nk'ie nga kint'é én xu'bi̱ xu̱ta̱ nkjiu̱n ko̱ já tjíxóo̱, xa̱áha̱n i̱ncha kits'ín. ");
INSERT INTO majNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","A̱skahan nk'ie nga y'échjíntjai yjoho̱ Jason ko̱ já xingisoo̱, kin'e nda̱í ngáha̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","A̱s'a̱i já nts'eé tje̱n'yún kits'ínkjihí Pablo̱ ko̱ Sila̱ nga jyuu̱n nanki Berea̱. Nk'ie nga tsichu yo̱, jas'en ni'ya sinagoga̱ha̱ xu̱ta̱ judio̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Xu̱ta̱ judio̱ xu'bi̱ 'yún nda sa ani̱ma̱ha̱ nga xi tjín nanki Tesaloni̱ka̱ ko̱ tsjo ts'ín kits'ínkjáíhi̱n én xi kinchja̱ Pablo̱. Xki̱ ni̱stjin i̱ncha kits'ínya xu̱ju̱n éhe̱n Nti̱a̱ná tu̱ xi i̱ncha sku̱e̱he tsa kju̱axi̱ ni xi tís'eni̱jmíhi̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kui b'a̱ maha, nkjin xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ xi kis'ejihi̱n én xi y'a Pablo̱. A̱jihi̱n xu̱ta̱ xi nchja̱ griego̱ ta̱ kis'ejihi̱n nkjin jminchjín xi benkjúhu̱n xu̱ta̱ ko̱ nkjin já. ");
INSERT INTO majNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tu̱nga nk'iehé nga kint'é xu̱ta̱ judio̱ xi tjín nanki Tesaloni̱ka̱ nga nanki Berea̱ ta̱ tíb'éni̱jmí Pablo̱ éhe̱n Nti̱a̱ná, i̱ncha j'ai yo̱ ko̱ ta̱ tsinchákjaha̱n xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","A̱s'a̱i ki̱tsa̱ kits'ínkjihi̱ já nts'eé Pablo̱ a̱ndai ntáchak'uu̱n. Tu̱nga y'entuhú sa Berea̱ Sila̱ ko̱ Timoteo̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Já xi tsasín ni̱yáha̱ Pablo̱ ngjiko̱ho̱ santaha nanki Atena̱. A̱s'a̱i kik'óya ngáha nga ja kits'ínkjáíhi̱n én xi kits'ínk'at'aha̱ Pablo̱, xi ku̱i̱tsu̱yaha̱ Sila̱ ko̱ Timoteo̱ nga tjíhin nga ki̱tsa̱ ngju̱a̱i̱ tje̱nnkihi̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nk'ie nga tíkuyá Pablo̱ nanki Atena̱ nga ku̱i̱chú Sila̱ ko̱ Timoteo̱, kama stihi̱ nga kikie nga tjín ṉkjún nti̱a̱ xi ts'ínnda xu̱ta̱ yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kui b'a̱ maha, a̱ya ni'ya sinagoga̱ kinchja̱ni̱jmíko̱ho xu̱ta̱ judio̱ ko̱ xi najmi judio̱ xi benkjún Nti̱a̱ná, ko̱ xki̱ ni̱stjin kinchja̱ni̱jmíko̱ xi kisatekjá ni̱yátée̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","A̱s'a̱i kinchja̱ko̱ Pablo̱ k'u̱a̱ já nkjink'un xi 'mi já epicure̱o̱ ko̱ k'u̱a̱ xi 'mi já estoi̱co̱. K'u̱a̱ b'i̱ i̱ncha kitsú: —¿Nkú títsu nda̱i̱ nk'ie nga b'a̱ nkjún ts'ín tínchja̱? Kj'a̱í ngá b'i̱ i̱ncha kitsú: —Kj'a̱í ra̱ nti̱a̱ha tíb'éjña chji. B'a̱ i̱ncha kitsú jóo̱ a̱t'aha̱ én nda tsuhu̱ Jesu ko̱ nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱ y'éni̱jmí Pablo̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","A̱s'a̱i i̱ncha ngjiko̱ho̱ jóo̱ a̱nte xi 'mi Areopa̱go̱ ko̱ b'i̱ kitsúhu̱: —¿A ka̱ma ko̱ ji̱n cha̱i̱ mí ni tse̱tse̱he xi tíb'eni̱jmí? ");
INSERT INTO majNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","A̱t'aha̱ tíchubai ni xi najmi kje̱e nu'yái̱. Kui nga mjehe̱ni̱ cha̱ha̱ni̱ nkú tsuhu̱ ra̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","B'a̱ i̱ncha kitsú a̱t'aha̱ ngayjee̱ xu̱ta̱ nanki Atena̱ ko̱ xu̱ta̱ xi xin nankihi̱ xi tjíntu yo̱ i̱ncha tsjoho̱ nga ku̱i̱nchja̱ni̱jmíyaha ko̱ a ra̱ ku̱a̱sínñjuhu̱ nku kju̱a̱nkjink'un tse̱tse̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","A̱s'a̱i tsasinjña ndju Pablo̱ kamasehe̱n já xi kama ñjakú Areopa̱go̱ ko̱ b'i̱ kitsúhu̱: —Jun já Atena̱, mankjinna nga jun xi 'yún yankjún nti̱a̱ xi tjín a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","A̱t'aha̱ nk'ie nga tsú'ba̱ a̱jin nankinu̱u, kikie nga nkjin maha nti̱a̱ xi yankjún. Ko̱ ta̱ kikie nku na̱chan chje̱ má nga b'i̱ ts'ín tjít'a: “Nti̱a̱ xi najmi yaha̱.” Kui b'a̱ maha, Nti̱a̱ xi yankjún nga najmi yo, kui xi tíb'eni̱jmínu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Nti̱a̱ xi kits'ínnda a̱sunntee̱ ko̱ ngayjee̱ ni xi tjíhi̱n, xi batéxumaha̱ nk'a ján ko̱ t'anankiu̱, najmi ni̱nku̱ xi xu̱ta̱ ts'ínnda b'ejñaya. ");
INSERT INTO majNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Najmi machjéhe̱n tsa xu̱ta̱ ku̱a̱si̱nko̱ho̱. Najmi chumi nihi xi machjéhe̱n. A̱t'aha̱ kui xi tsjáná ni̱stjin ko̱ tsjáná ntjo̱ ko̱ ngayjee̱ ni xi tjínná. ");
INSERT INTO majNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kui xi nkuhú ntje̱ kits'ínndaha ngayjee̱ xu̱ta̱ xi tjín nga ngúsuhu̱n a̱sunntee̱. Y'éjña nga nkjé ko̱ má nga k'úéntu nga nkúnkú. ");
INSERT INTO majNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","’B'a̱ kits'ín tu̱ xi ngayjee̱ xu̱ta̱ ku̱a̱ngisjaihi Nti̱a̱ná, tsa tu̱ ahá ni sa̱kúhu̱ nga ku̱a̱ngisjai. B'a̱ tjín kjáíhin nga najmi kjin tíjñaná Nti̱a̱ná nga nkúnkáá. ");
INSERT INTO majNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","A̱t'aha̱ Nti̱a̱ná tintsu̱ba̱ tík'uhunná, tinimaá ko̱ tjínná ni̱stjin, xi nkú nga ta̱ kitsú k'u̱a̱ já nkjink'un xi tjín a̱jinnu̱u: “Ntíhi̱ ní Nti̱a̱ná ñá.” ");
INSERT INTO majNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","’Kui b'a̱ maha, tsa ntíhi̱ Nti̱a̱ná ñá, najmi tjíhin nga n'e̱nkjíntak'aán tsa b'a̱ tjín Nti̱a̱ná xi nkú joyaha sénni̱stjin xi kamandako̱ho to̱onsine ko̱ tsa to̱ontaba ko̱ tsa ndji̱o̱. Kui niu̱ xi ts'ínnda xu̱ta̱. Xi nkú ts'ín maha̱ ko̱ xi nkú ts'ín ts'ínnkjink'un, b'a̱ i̱ncha ts'ínk'íé. ");
INSERT INTO majNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","’Nti̱a̱ná najmi kits'ín kuenta̱ ni xi kits'ín xu̱ta̱ ni̱stjin nk'ie, a̱t'aha̱ najmi kje̱e behe̱ xu̱ta̱. Tu̱nga nd'a̱i̱ tu̱ má xi tje̱hén ni nga tjíntu xu̱ta̱ Nti̱a̱ná b'a̱ títsuhu̱ nga ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱ ngayjee̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","A̱t'aha̱ Nti̱a̱ná ja tíjñaha̱ ni̱stjin nga na̱xu̱ ku̱a̱se̱he̱ ni xi nda ko̱ ni xi najmi nda kits'ín xu̱ta̱. Nda̱ xi Nti̱a̱ná kitsjá xáha̱ nga b'a̱ ts'i̱ín, kui xi b'a̱ ts'i̱ín. Kits'ínkj'áíya ngáha̱ ra̱ ngabayoo̱ nda̱ xu'bo̱. B'a̱ ts'ín tsakúchjihi̱ ra̱ ngayjee̱ xu̱ta̱ nga kju̱axi̱ niu̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nk'ie nga kint'é jóo̱ nga kj'u̱a̱íya ngáha̱ ra̱ xu̱ta̱ ngabayoo̱, tjín xi tsajnukiehe̱ Pablo̱. Tu̱nga k'u̱a̱há xi b'i̱ kitsú: —Mjeni̱ ku̱i̱nú'yái̱ ni xu'bi̱ kj'a̱í ni̱stjin ngáha. ");
INSERT INTO majNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","A̱s'a̱i tsitju yo̱ Pablo̱. ");
INSERT INTO majNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tu̱nga k'u̱a̱há xi kis'ejihi̱n ko̱ kamako̱ho̱. Kis'ejihi̱n nda̱ xi 'mi Dionisi̱o̱, xi ta̱ ma ñjakúko̱ jóo̱ a̱nte xi 'mi Areopa̱go̱, ko̱ nku ta̱chju̱ún xi 'mi Dama̱ri̱ ko̱ kj'a̱í sa. ");
INSERT INTO majNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","A̱s'a̱i tsitju Pablo̱ Atena̱ ko̱ ngji nanki Corinto̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Yo̱ kisakúhu̱ nku nda̱ judio̱ xi 'mi Akila̱ xi kitsinjín a̱nte Ponto̱, ko̱ Priscila̱ xi chju̱úhu̱n maha. Kui xi a̱s'a̱i i̱ncha nibahá a̱nte Itali̱a̱, a̱t'aha̱ Claudi̱o̱ xi nda̱ títjun k'aku̱ Roma̱ b'a̱ kitsú nga tjíhin nga ku̱i̱tju nanki Roma̱ ngayjee̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱. A̱s'a̱i Pablo̱ ngjisehe̱ jóo̱ ");
INSERT INTO majNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ko̱ y'ejñajihi̱n. Kits'ínxáko̱ nga kits'ínnda ni'ya najyunte, a̱t'aha̱ ta̱ kuihi xá xi maha̱ jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Xki̱ xua̱tu̱ ngji nchja̱ko̱ Pablo̱ xu̱ta̱ ni'ya sinagoga̱. Y'éjña chjihi̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ ko̱ xi a̱nte Greci̱a̱ y'aha̱ ra̱ nga kju̱axi̱ ni xi tínchja̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nk'ie nga tsitju Sila̱ ko̱ Timoteo̱ a̱nte Macedoni̱a̱ ko̱ tsichu nanki Corinto̱, tu̱ nku y'éni̱jmíhí Pablo̱ éhe̱n Nti̱a̱ná ko̱ y'éjña chjihi̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ nga Jesu xi kits'ín nibá Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tu̱nga xu̱ta̱ judio̱ ngji kontra̱ha̱ Pablo̱ ko̱ ch'on kitsúhu̱. Kui nga y'étsujnehe najyuhu̱n Pablo̱ ko̱ b'i̱ kitsúhu̱ jóo̱: —Jun katjinénu̱u ngabayanu̱u. Najmi an ngju̱a̱i̱néna. Nd'a̱i̱ k'uatuts'i̱hi̱n nga kfínsehe̱ xi najmi ntje̱ Israel tje̱he̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","A̱s'a̱i tsitju yo̱ ko̱ ngji ni'yaha̱ nku nda̱ xi 'mi Tici̱o̱ Justo̱ xi benkjún Nti̱a̱ná. Kui xi tiña ni'yaha̱ síjña ni'ya sinagoga̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","A̱s'a̱i nda̱ xi 'mi Crispo̱ xi nda̱ k'aku̱hu̱ xu̱ta̱ sinagoga̱ ko̱ ngayjee̱ xu̱ta̱ xinkjín kis'ejihi̱n Nda̱ Nti̱a̱ná. Ko̱ ta̱ nkjin xu̱ta̱ Corinto̱ kis'ejihi̱n ko̱ kisaténtá nk'ie nga kint'é ni xi tíb'éni̱jmí Pablo̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","A̱s'a̱i Nda̱ Nti̱a̱ná kinchja̱ko̱ho̱ Pablo̱ nga ni̱stje̱n xi nkúhu tsa nchi̱ni kik'a̱i̱hi̱. B'i̱ kik'ihi̱n: —Najmi tu̱ binkjuin. T'eni̱jmí sahani ée̱n. Najmi tu̱ b'echjáí tsu̱'bai. ");
INSERT INTO majNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","A̱t'aha̱ an tíi̱jñako̱ho. Najmi ch'a ka̱maha̱ ts'i̱ín'uhin. A̱t'aha̱ nkjin xu̱ta̱ tjínna nanki xu'bi̱ xi s'e̱jihi̱n an. ");
INSERT INTO majNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Yo̱ y'ejña Pablo̱ nku nú masen tjíhin nga tsakúya a̱jihi̱n xu̱ta̱ Corinto̱ éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tu̱nga nk'ie nga tjíhi̱n xá nda̱ Galion a̱nte Akaya̱, nkuhú kits'ín yjoho̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ nga ngji kontra̱ha̱ Pablo̱. I̱ncha ngjiko̱ho̱ má ts'ínko̱kju̱a̱ xu̱ta̱ Galion ");
INSERT INTO majNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ko̱ b'i̱ i̱ncha kitsú: —Kui nda̱i̱ tífi kontra̱ha̱ kju̱a̱téxumani̱, a̱t'aha̱ kj'a̱í ts'ín tíbakúyaha̱ xu̱ta̱ nga tjíhin nga cha̱nkjún Nti̱a̱ni̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nk'ie nga ja ku̱i̱nchja̱ Pablo̱, tu̱ tjuhún Galion kinchja̱ko̱ xu̱ta̱ judio̱ nga b'i̱ kitsúhu̱: —Jun xu̱ta̱ judio̱, tsa tjín má tsangane nda̱i̱ ko̱ tsa mí ni ch'on tjíhin xi kits'ín, tjíhin nga ts'intsenta ko̱ kuasinñjúnu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Tu̱nga ni xu'bi̱ kju̱a̱téxumanu̱u ko̱ kj'a̱í sa ni xi manu̱u y'aha̱ ra̱ nii̱. Kui nga t'enda su̱ba̱hanu niu̱. Najmi mjena ts'ihi̱n kju̱a̱ ni xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","A̱s'a̱i kik'onsje jóo̱ na̱tsihi̱n a̱nte má nga ts'ínko̱kju̱a̱ xu̱ta̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","A̱s'a̱i ngayjee̱ xu̱ta̱ jakj'á Soste̱ne̱ xi nda̱ k'aku̱hu̱ xu̱ta̱ sinagoga̱ ko̱ ta̱ yo̱hó y'éhe̱ ndo̱. Tu̱nga ndaha najmi kits'ínsihi̱n Galion ni xi kamoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Nkjin ni̱stjin ts'andaya yo̱ Pablo̱. A̱s'a̱i kitsubakjá já nts'eé a̱t'aha̱ ja tífi a̱nte Siri̱a̱. Nk'ie nga tsichu nanki Cencrea̱ nga kits'ín ni̱yá, j'ájnu kaha̱ yjoho̱ a̱t'aha̱ ja títs'íntjusun nku ni xi kits'ínkie Nti̱a̱ná. A̱s'a̱i jakj'á nku tsutsu ko̱ ngji a̱nte Siri̱a̱ nga tje̱nko̱ ts'íhin Akila̱ ko̱ Priscila̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nk'ie nga i̱ncha tsichu nanki Efe̱so̱, yo̱ i̱ncha kits'ín ngabihi̱ xinkjín. Kama kinchja̱ni̱jmíko̱ Pablo̱ xu̱ta̱ judio̱ ni'ya sinagoga̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","A̱s'a̱i tjín xi tsankihi̱ nga nkjin ni̱stjin k'úéjña yo̱, tu̱nga najmi kits'ín yuhú Pablo̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","B'i̱ kitsú: —Tífia. Tsa Nti̱a̱ná b'a̱ ku̱i̱tsu̱, kjúái̱se ngáha̱nu̱u. A̱s'a̱i jakj'á nku tsutsu xi tsitju Efe̱so̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nk'ie nga tsichu nanki Cesarea̱, ngjikjaniñaha̱ xu̱ta̱ ni̱nku̱ ko̱ a̱s'a̱i ngji nanki Antiokia̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A̱skahan nga ja ts'andayaha̱ chuba ni̱stjin yo̱, tsitju nga j'a xki̱ nanki xi tjín a̱nte Galaci̱a̱ ko̱ a̱nte Frigi̱a̱. Kitsjá nga'yúhu̱n ngayjee̱ xu̱ta̱ xi yjankihi̱ Jesu xi nkú ts'ín ndjá ku̱i̱ncha nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","A̱s'a̱i tsichu nanki Efe̱so̱ nku nda̱ judio̱ xi 'mi Apolo̱ xi kitsin nanki Alejandria̱. Tsjo ts'ín b'éni̱jmí ndo̱ ko̱ 'yún be xu̱ju̱n éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tsangiya ni xi tsakúya Nda̱ Nti̱a̱ná Jesu ko̱ ngayjehe k'un y'éni̱jmíhi̱ xu̱ta̱. Tsakúya sisin yáha Jesu, tu̱nga najmi 'yúhún mankjihi̱n á saténtáha xu̱ta̱. Tu̱ xi nkúhú ts'ín tsaténtá xu̱ta̱ Jua be. ");
INSERT INTO majNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ndjá y'éni̱jmí ndo̱ ni'ya sinagoga̱. Nk'ie nga kint'é Akila̱ ko̱ Priscila̱ ni xi y'éni̱jmí, ngjiko̱ t'axín ko̱ kitsúya sisihi̱n xi nkú ts'ín mjehe̱ Nti̱a̱ná nga k'úéntu xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nk'ie nga kama mjehe̱ Apolo̱ nga ngju̱a̱i̱ a̱nte Akaya̱, já nts'eé xi tjín Efe̱so̱ tsasinko̱ho̱. Kits'ínndaha̱ nku xu̱ju̱n xu̱ta̱ ni'yakuyáha̱ Jesu xi tjín Akaya̱ tu̱ xi nda ts'ín ts'i̱ínkjáíhi̱n ra̱. Nk'ie nga tsichu Apolo̱ yo̱, tsasinko̱ ṉkjún xu̱ta̱ xi ja s'ejihi̱n Jesu tu̱ nga̱t'aha̱ kju̱a̱ndaha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","A̱t'aha̱ nginku̱n ngayjee̱ xu̱ta̱ ndjá tsakúya nga najmi kju̱axi̱ ni xi bakúya xu̱ta̱ judio̱. Tsakúya ni xi tjít'a xu̱ju̱n éhe̱n Nti̱a̱ná. B'a̱ ts'ín y'éjña chjihi nga Jesu xi kits'ín nibá Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nk'ie nga tíjña Apolo̱ nanki Corinto̱, Pablo̱ j'ajin a̱sunntu tje̱nki̱ xi tjín a̱nte Asi̱a̱ ko̱ tsichu nanki Efe̱so̱. Yo̱ kisakúhu̱ k'u̱a̱ xu̱ta̱ xi yjankihi̱ Jesu. A̱s'a̱i b'i̱ kitsúhu̱ jóo̱: ");
INSERT INTO majNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","—¿A kin'ekjóho̱on Espiri̱tu̱ Santo̱ nk'ie nga kis'ejinnu̱u Jesu? B'i̱ i̱ncha kitsú jóo̱: —Ndaha̱chí najmi kje̱e nu'yái̱ tsa tjín Espiri̱tu̱ Santo̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","—¿Nkú n'e kisatentó? —kitsú Pablo̱. —Xi nkú ts'ín tsaténtá Jua —i̱ncha kitsú. ");
INSERT INTO majNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","B'i̱ kitsú Pablo̱: —Xu̱ta̱ xi ngjikj'áha̱ ra̱ ani̱ma̱ha̱ tsaténtá Jua, tu̱nga b'a̱há kitsúhu̱ nga tjíhin nga s'e̱jihi̱n xi kj'u̱a̱í a̱skahan nga kui. Jesu, kui xi a̱skahan j'ai. ");
INSERT INTO majNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nk'ie nga kint'é jóo̱ ni xu'bi̱, a̱s'a̱i kisaténtá nga kits'ínkjáíhi̱n Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nk'ie nga kingjénne ntsja Pablo̱ jóo̱, j'aitsejíhi̱n ra̱ Espiri̱tu̱ Santo̱ ko̱ kj'a̱í kj'a̱í éhen i̱ncha kinchja̱ ko̱ Nti̱a̱ná kitsjáha̱ én xi kinchja̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ma ra̱ te jo jáx'i̱n xi b'i̱ i̱ncha kamat'ain. ");
INSERT INTO majNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Jan ra̱ sá kamaha̱ Pablo̱ nga ngji ni'ya sinagoga̱ ko̱ ndjá kinchja̱ko̱ xu̱ta̱. Kitsúyaha̱ ko̱ y'éjña chjihi̱ nkú tjíhi̱n ra̱ nga batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tu̱nga k'u̱a̱há xi ndjá kits'ín ani̱ma̱ha̱. Najmi kits'ínkjáíhi̱n nga s'e̱jihi̱n ni xi títsu Pablo̱. Nginku̱n ngayjee̱ xu̱ta̱ tu̱ ch'ohón ts'ín i̱ncha kinchja̱ne xu̱ta̱ xi s'ejihi̱n Jesu. Kui nga ngji t'axíhin Pablo̱. Má nga bakúya nda̱ xi 'mi Tirano̱ ngjiko̱ xu̱ta̱ xi yjankihi̱ Jesu. Yo̱ tsakúyaha̱ xu̱ta̱ xki̱ ni̱stjin. ");
INSERT INTO majNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Jo nú kamaha̱ nga b'a̱ kits'ín. Kint'é éhe̱n Nti̱a̱ná ngayjee̱ xu̱ta̱ xi tjín a̱nte Asi̱a̱, xi judio̱ ko̱ xi griego̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nti̱a̱ná kitsjáha̱ nga'yún Pablo̱ xi má nga kits'ín kju̱a̱nkjún xi i. ");
INSERT INTO majNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Santaha xu̱ta̱ ngjiko̱ pañu̱ ko̱ najyun xi kits'ínko̱ Pablo̱. Kui xi j'aiko̱ho̱ xu̱ta̱ uhu̱n. A̱s'a̱i kamanda ko̱ tsitjujíhi̱n jánindoo̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ta̱ kikjatsú'ba̱ yo̱ k'u̱a̱ já judio̱ xi b'ema xki̱ a̱nte ko̱ m'osje jánindoo̱. Kui xi i̱ncha kama k'un kits'ínchjén nga'yúhu̱n Nda̱ Nti̱a̱ná Jesu. B'i̱ i̱ncha kitsúhu̱ jánindoo̱: —Ngajoho̱ Jesu xi tíb'éni̱jmí Pablo̱ b'a̱ tí'mii̱hi̱ nga ti̱tjujiun yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yatu jáha̱ nda̱ na̱'mi k'aku̱ judio̱ xi 'mi Esceba̱ b'a̱ i̱ncha kits'ín. ");
INSERT INTO majNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Tu̱nga kinchja̱há nda̱nindoo̱ nga b'i̱ kitsúhu̱ jóo̱: —Be Jesu ko̱ ta̱ be Pablo̱, tu̱nga, ¿yáha jun? ");
INSERT INTO majNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","A̱s'a̱i nda̱ xi tíjñajihi̱n nda̱nindoo̱ jakj'á já xi yatuu̱. Kikjánko̱ ko̱ kits'ín ngana̱ha̱. A̱s'a̱i tsanka jóo̱ nga kama uhu̱n. Xí kjintustíhí nga i̱ncha tsitju ni'yaha̱ ndo̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ngayjee̱ xu̱ta̱ xi tjín Efe̱so̱, xi judio̱ ko̱ xi griego̱, kint'é ni xi kamoo̱. I̱ncha kitsankjún ngayjee̱ ko̱ b'a̱ i̱ncha kitsú nga tjíhi̱n kju̱a̱chánka Nda̱ Nti̱a̱ná Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nkjin xi kis'ejihi̱n Jesu i̱ncha j'ai tsúya nginku̱n xu̱ta̱ xingisoo̱ ni ch'onk'un xi i̱ncha kits'ín nk'ie. ");
INSERT INTO majNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Xi i̱ncha kits'ín tj'e j'aiko̱ xu̱ju̱n tj'ehe̱ ko̱ kis'etí xu̱ju̱n nginku̱n ngayjee̱ xu̱ta̱. Nk'ie nga kin'esjehe̱ xki̱ xu̱ju̱n xi kis'etíu̱, cháte ra̱ mii̱ to̱ontaba kama chjíhi̱ xu̱ju̱n. ");
INSERT INTO majNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","B'a̱ ts'ín 'yún ngji tse ko̱ ngji ndju éhe̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","A̱skahan b'a̱ kitsú kju̱a̱nkjintak'uhu̱n Pablo̱ nga ngju̱a̱i̱ nanki xi tjín a̱nte Macedoni̱a̱ ko̱ a̱nte Akaya̱ ko̱ a̱s'a̱i ts'i̱ín ni̱yá nga ngju̱a̱i̱ santaha nanki Jerusalen. B'i̱ kitsú: —A̱skahan nga ku̱i̱cha yo̱, tjíhin nga ta̱ kfíán nanki Roma̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","A̱s'a̱i kits'ínkji Macedoni̱a̱ Timoteo̱ ko̱ Erasto̱, já xi i̱ncha basinko̱ho̱. Ko̱ máha kui, y'ejña sa chuba ni̱stjin Asi̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kui ni̱stjiu̱n xu̱ta̱ xi yjankihi̱ Jesu nanki Efe̱so̱ nku kju̱a̱sti j'ajin. ");
INSERT INTO majNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nku nda̱ xi 'mi Demetri̱o̱ xi ts'ínnda ni̱nku̱ to̱ontaba xi̱. B'a̱ ts'ínk'íéntu ni̱nku̱ xi ts'ínnda xi nkúhu ni̱nku̱hu̱ nti̱a̱ Artemisa̱. Kui ni̱stjiu̱n já xi kui xáha ts'ín 'yún ts'ín ngana̱ to̱on. ");
INSERT INTO majNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetri̱o̱ kinchja̱ ñjakúhu̱ já xi ts'ínxát'aha̱ ko̱ já xi ta̱ kui xáha ts'ín. B'i̱ kitsúhu̱ jóo̱: —Jun já, yo nga b'éjñaná to̱on xá xu'bi̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Tu̱nga tíyanú ko̱ tínu'yó ni xi títs'ín Pablo̱ e̱i̱ Efe̱so̱ ko̱ santaha tu̱ má nankihí ni xi tjín a̱nte Asi̱a̱. B'a̱ títsu nga nti̱a̱ xi ts'ínnda xu̱ta̱ najmi nti̱a̱. Nkjin xu̱ta̱ ja i̱ncha kits'ínkjáíhi̱n ni xi tíbakúya ndo̱ ko̱ i̱ncha kits'ínk'óntjaiya kju̱a̱nkjintak'uhu̱n. ");
INSERT INTO majNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Najmi tu̱ suba xáná títs'ínkji kinte. Ta̱ títs'ín nga nku ni xi najmi ta̱ chumi ni chjíhi̱ ra̱ ka̱ma ni̱nku̱hu̱ nti̱a̱ chánka Artemisa̱. Najmi ta̱ cha̱nkjúhun kju̱a̱chánkaha̱ nti̱a̱ xu'bi̱, nti̱a̱ xi benkjúnyje xu̱ta̱ xi tjín a̱nte Asi̱a̱ ko̱ nga ngúsuhu̱n a̱sunntee̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nk'ie nga i̱ncha kint'é jóo̱ niu̱, tu̱ xí i̱ncha kama kjahán ra̱. B'i̱ i̱ncha kitsú nga kikjintáya: —¡Chánkahá Artemisa̱, nti̱a̱ha̱ xu̱ta̱ Efe̱so̱! ");
INSERT INTO majNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","A̱s'a̱i xu̱ta̱ ndaha najmi be mí nihi xi ts'i̱ín. Nkuhú kik'a xinkjín nga ngjikj'á Gayo̱ ko̱ Aristarko̱, kui xi já Macedoni̱a̱ xi tje̱nko̱ Pablo̱. I̱ncha kikjebéfe nga ngjiko̱ a̱nte má ma ñjakú xu̱ta̱ na̱nti̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Mjehe̱ Pablo̱ nga ngju̱a̱i̱sehe̱ xu̱ta̱ xi kama ñjakú yo̱, tu̱nga najmi kitsjántehé ra̱ xu̱ta̱ xi yjanki Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ko̱ ta̱ já k'aku̱ xi tjín a̱nte Asi̱a̱ xi nda nchja̱ko̱ Pablo̱ i̱ncha kits'ínkjihi̱ én nga tsankihi̱ nga najmi tu̱ ngju̱a̱i̱ a̱nte má nga kama ñjakú xu̱ta̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","B'i̱ ngján i̱ncha kinchja̱ xu̱ta̱ nga xa̱áha̱n i̱ncha kits'ín. Ko̱ santaha nkjin ṉkjún xi najmi be á yo̱ kama ñjakúhu. ");
INSERT INTO majNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","A̱s'a̱i tjín xi jakj'áha̱ Alejandro̱. Xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ kitsuniñaha̱ ndo̱ nginku̱n ngayjee̱ xu̱ta̱. Kingjén nk'a ntsja Alejandro̱ nga tsanki nga ngju̱én jyu xu̱ta̱ tu̱ xi ku̱i̱nchja̱ntjaihi xu̱ta̱ judio̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tu̱nga nk'ie nga kikie xu̱ta̱ nga ta̱ nda̱ judio̱ niu̱, nkuhú kits'ín nta̱ha̱ nga b'i̱ i̱ncha kitsú nga kikjintáya nkú ra̱ ma tsa jo ora̱: —¡Chánkahá Artemisa̱, nti̱a̱ha̱ xu̱ta̱ Efe̱so̱! ");
INSERT INTO majNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","A̱s'a̱i nda̱ xi ts'ínxát'aha̱ já k'aku̱ kamaha̱ kits'ínk'íéjyu xu̱ta̱ nkjiu̱n. B'i̱ kitsú: —Jun já Efe̱so̱, ngayjee̱ xu̱ta̱ be nga nankiná Efe̱so̱ kunntá ni̱nku̱hu̱ nti̱a̱ chánka Artemisa̱ ko̱ sénni̱stjihi̱n xi nibaha nk'a ján nga j'aikijne e̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tíjña chji chji ni xu'bi̱. Kui nga tjenjyúhunu ko̱ n'e̱nkjíntak'un ni xi n'o̱o. ");
INSERT INTO majNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","A̱t'aha̱ já xi kaf'ái̱ko̱o e̱i̱ najmi ni xi tíi̱ncha ni̱nku̱ jakj'á ndyjé ko̱ ta̱ ndaha najmi ch'on títsuhu̱ nti̱a̱ ts'a̱ñá. ");
INSERT INTO majNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","’Tsa Demetri̱o̱ ko̱ já xi ts'ínxáko̱ tjínko̱ho̱ kju̱a̱ xu̱ta̱ xi kj'a̱í, tjín já jue ko̱ tjín já tjíxá. Yo̱ kats'ínko̱kju̱a̱ xinkjín. ");
INSERT INTO majNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ko̱ tsa tjín sa kj'a̱í ni xi mjenu̱u, nk'ie nga ma ñja já tjíxóo̱ s'e̱nda niu̱. ");
INSERT INTO majNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","A̱t'aha̱ ka̱ma sa̱téjéneé nga̱t'aha̱ ni xi kama nd'a̱i̱, nga xa̱áha̱n tín'eé. Tsa cha̱sjaiyaná nga̱t'aha̱ niu̱, najmi yaá nkú ku̱i̱xíaán. ");
INSERT INTO majNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nk'ie nga ja kamaha̱ nga b'a̱ kitsú, kits'ínkji ngáha ni'yaha̱ xu̱ta̱ xi kama ñjakú yo̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","A̱skahan nga ja kis'ejyú xu̱ta̱ nkjiu̱n, Pablo̱ kinchja̱ ñjaha̱ xu̱ta̱ xi yjankihi̱ Jesu ko̱ kitsjá nga'yúhu̱n. A̱s'a̱i tsitju nga ngji Macedoni̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Xki̱ nanki xi tjín a̱nte Macedoni̱a̱ j'a ko̱ 'yún kitsjá nga'yúhu̱n xu̱ta̱ ni̱nku̱ nga kinchja̱ko̱. A̱skahan tsichu Greci̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Jan sá kamaha̱ nga y'ejña yo̱. Nk'ie nga ja ku̱a̱kj'á tsutsu xi ngju̱a̱i̱ko̱ho̱ a̱nte Siri̱a̱, tu̱ kint'éhé én nga já judio̱ ja y'éndako̱ xinkjín nga ts'i̱ín'uhu̱n. Kui nga ta̱ a̱nte Macedoni̱a̱ ngji ngáha. ");
INSERT INTO majNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kui já xu'bi̱ xi kitsjennkíhi̱ Pablo̱: Sopa̱te̱r xi Berea̱ nibáha xi ntíhi̱ Pirro̱ maha, Aristarco̱ ko̱ Segundo̱ xi Tesaloni̱ka̱ i̱ncha nibáha, Gayo̱ xi Derbe̱ nibáha, Timoteo̱, Tiki̱co̱ ko̱ Trofi̱mo̱ xi Asi̱a̱ i̱ncha nibáha. ");
INSERT INTO majNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","I̱ncha ngji títjun jái̱ ko̱ nanki Troa̱ kikuyáni̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ji̱n bi a̱skahan nga j'a s'í nk'ie nga chine ni̱nku̱a̱n xi najmi tjíhi̱n na̱'yu̱ san, tsitjas'e̱i̱n nku tsutsu ko̱ tsitjui̱ Filipo̱. Ni̱stjin xi ma uhun tsichu tje̱nnkii̱ jóo̱ Troa̱. Yo̱ ts'andayani̱ yatu ni̱stjin. ");
INSERT INTO majNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nk'ie nga tíb'atuts'i̱hi̱n tuntjóo̱ kama ñjakúi̱ tu̱ xi chi̱ne̱he̱ni̱ ni̱ñu̱. A̱s'a̱i Pablo̱ tsakúyaha̱ xu̱to̱, a̱t'aha̱ ni̱stjin xi ma ndyjuu̱n ngju̱a̱i̱ ngáha. Tu̱ nku ngjindjuko̱hó ée̱n santaha nkúhu nga masen ni̱stje̱n. ");
INSERT INTO majNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Chun ndzjen ndzjen yo̱, a̱t'aha̱ nkjin maha nd'í seti̱ xi tjín nk'a ni'ya xi má nga kama ñjakúi̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Tu̱ nkuhú nda̱ti xi 'mi Eutiko̱ xi a̱nkju̱a̱ nk'oo̱ kab'ejña stiu̱. Kui xi kis'efe nk'ie nga 'yún ngjindjuko̱ Pablo̱ ée̱n. 'Yún ṉkjún kis'efe tjain. A̱s'a̱i tsijnenki. Ni'ya xi ma jahan niba nga tsijnenki. Ja ka'me nga kichjusíntje̱n. ");
INSERT INTO majNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","A̱s'a̱i tsitjujen Pablo̱ ko̱ ngjik'úhu̱n. Kitsubakj'á nda̱tiu̱ ko̱ b'i̱ kitsú: —Najmi tu̱ binkjun. Tíjñahá ndo̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","A̱s'a̱i ta̱ ngji ts'ínndju̱ú ngáha éhe̱n Pablo̱. Tsakjánya ni̱nku̱o̱n, i̱ncha kikjine ni̱ñu̱ ko̱ ta̱ ngjindjuhú ngáha nga tsakúyaha̱ xu̱to̱ santa nkúhu nga kama see̱n. A̱s'a̱i ngji. ");
INSERT INTO majNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Máha nda̱tiu̱, i̱ncha ngjiko̱ tík'uhu̱n xu̱ta̱ ni'yaha̱ ko̱ i̱ncha kisakú nga'yúhu̱n nga̱t'aha̱ ni xi kama. ");
INSERT INTO majNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ja kamoo̱. Ji̱n tje̱n tsankinko̱ho̱ni̱ tsutsu nanki Ason, yo̱ má nga chúyai̱hi̱ Pablo̱. B'a̱ ts'ín y'éndako̱ni̱, a̱t'aha̱ mjehe̱ nga ni̱yá t'ananki ts'i̱ín. ");
INSERT INTO majNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nk'ie nga kisakúni̱ Pablo̱ nanki Ason, a̱s'a̱i jas'enko̱ni̱ tsutsuu̱ ko̱ tsankii̱n nanki Mitilene̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tsitjui̱ nanki Mitilene̱ ko̱ ni̱stjin xi ma ndyjuu̱n tsitjai̱ xjo̱ Kio̱. Nk'ie nga kama ndyjuu̱n tsitjandái̱ nanki Samo̱, nku a̱nte má bichú tsutsu. Kin'ekj'áíyai̱ nanki Trogili̱o̱ ko̱ ni̱stjin ma ndyjuu̱n tsichii̱ nanki Mileto̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","B'a̱ kin'ei̱ a̱t'aha̱ Pablo̱ mjehe̱ kj'u̱a̱ ni̱yá nanki Efe̱so̱ tu̱ xi najmi k'u̱a̱ndayaha̱ ra̱ nanki xi tjín a̱nte Asi̱a̱. Kits'ín xatíhi̱ yjoho̱ nga ku̱i̱chú nanki Jerusalen, tsa tu̱ ahá ni sa̱kúhu̱ nga k'úéjña yo̱ nk'ie nga ku̱i̱tju S'í Pentecoste. ");
INSERT INTO majNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nk'ie nga tsichii̱ nanki Mileto̱, kits'ínkji én Pablo̱ nga kinchja̱ha̱ jácháha̱ xu̱ta̱ ni̱nku̱ Efe̱so̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nk'ie nga i̱ncha j'ai jóo̱, b'i̱ kitsú Pablo̱: —Yo xi nkú ts'ín tsáte̱jñajin tehe̱ntenu̱u santa nkúhu nga tuts'ihi̱n ni nga jáa̱ e̱i̱ a̱nte Asi̱a̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ni̱ma̱kju̱a̱ ts'asjé yjona̱ nga kits'inxát'aha̱ Nti̱a̱ná. Kikjíi̱nta nga un kikiena ni xi y'éndat'áínna já judio̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tu̱nga najmi kingjent'íáhá ra̱ nga y'eni̱jmínu̱u ni xi ts'e̱ ngandanu̱u. Tsakuyánu̱u ni̱yátée̱ ko̱ xki̱ ni'yanu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Y'ejñá chjihi̱ xu̱ta̱ xi ntje̱ judio̱ tje̱he̱n ra̱ ko̱ xu̱ta̱ xi najmi ntje̱ judio̱ tje̱he̱n ra̱ nga tjíhin nga ngju̱a̱i̱kj'áha̱ ra̱ ani̱ma̱ha̱ nginku̱n Nti̱a̱ná ko̱ nga s'e̱jihi̱n Nda̱ Nti̱a̱ná Jesucristo̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","’Nga tínt'e'éhe̱n Espiri̱tu̱ Santo̱ nd'a̱i̱ tífia Jerusalen. Najmi be mí nihi xi ka̱mat'an ján. ");
INSERT INTO majNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Tu̱nga xki̱ a̱nte má nga fia tsuya títjunna Espiri̱tu̱ Santo̱ tsa nu̱ba̱yá ko̱ tsa kju̱a̱'un tíkuyána. ");
INSERT INTO majNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tu̱nga najmi kjinta̱hána tsa ku̱a̱yá. Nga̱t'a ts'a̱n najmi 'yún chjíhi̱ ra̱ ni xu'bo̱. Tu̱ nkuhú ni xi mjena. Mjena nga ku̱i̱chúkjet'a tsjo tsjo ni xi títs'ian ko̱ ts'inndja̱á xá xi kitsjána Nda̱ Nti̱a̱ná Jesu, nga xínya sisian én nda tsuhu̱ Jesu xi b'éjña chji kju̱a̱ndaha̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Be nd'a̱i̱ nga najmi ta̱ cha̱hanú ngatento xi jái̱senu̱u, jun xi y'eni̱jmínu̱u nkú ts'ín batéxuma Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kui b'a̱ maha, ni̱stjin nd'a̱i̱ tíxinyaha̱nu̱u nga najmi an y'anjiá tsa tjín xi ndyja̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","A̱t'aha̱ najmi chumi nihi xi y'ejñá 'manu̱u. Ngayjee̱ ni xi mjehe̱ Nti̱a̱ná y'eni̱jmínu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","’Kui b'a̱ maha, chúhu̱n ru̱u yjonu̱u ko̱ chúhu̱un ngayjee̱ xu̱ta̱ ni̱nku̱. A̱t'aha̱ Espiri̱tu̱ Santo̱ kitsjá xánu̱u nga jun xi cha̱so̱ho̱ xu̱ta̱ ni̱nku̱hu̱ Nda̱ Nti̱a̱ná xi jníhi̱ ts'atseko̱ho. ");
INSERT INTO majNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A̱t'aha̱ be nga a̱skahan nga kfíán kj'u̱a̱íjinnu̱u já xi mjehe̱ ts'i̱ínndyja xu̱ta̱ ni̱nku̱ xi nkú ts'ín chu̱ kjoo̱n a̱jihi̱n chu̱tsa̱nko̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Santaha a̱jinnu̱u s'e̱ xi ku̱a̱kúya ni xi najmi b'a̱ tjín tu̱ xi xu̱ta̱ ni̱nku̱ tsjénnkihi̱ ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kui nga ti̱ntsu̱ba̱ ndahanu. N'e̱kj'áítsjon nga ni̱stjin ni̱stje̱n jan nú najmi kits'inkj'áíya nga ntánkán tsatendzjá nga kitsjani̱yáha̱nu̱u nga nkúnkú. ");
INSERT INTO majNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Nd'a̱i̱ já nts'e, títs'inkjas'ennu̱u a̱ya ntsja Nti̱a̱ná. Katasinko̱nu̱u én xi tínchja̱ kju̱a̱ndaha̱ Nti̱a̱ná, kui éhe̱n xi ka̱maha̱ tsjánu̱u nga'yún nginku̱n Nti̱a̱ná ko̱ tsjánu̱u ni xi ts'i̱ínkjáíhi̱n ngayjee̱ xu̱ta̱ xi tsichu ma je nginku̱n Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Najmi kits'in mje to̱ontabanu̱u ko̱ tsa to̱onsinenu̱u ko̱ ta̱ ndaha najyunnu̱u. ");
INSERT INTO majNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Jun yo xi nkú ts'ín kits'inxá tu̱ xi kisakúhuna ni xi kamachjénna ko̱ ni xi kamachjéhe̱n já xi kitsjenko̱na. ");
INSERT INTO majNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Tehe̱nte y'ejñá chu̱ba̱yanu̱u nga tjíhin nga n'e̱xáá tu̱ xi ku̱i̱si̱nko̱honá xu̱ta̱ xi najmi tjíhi̱n ni xi machjéhe̱n. N'e̱kj'áítsjon éhe̱n Nda̱ Nti̱a̱ná Jesu xi b'i̱ títsu: “Xi tu̱ tsjáhá ra̱ ni xu̱ta̱ xi kj'a̱í, kui xi 'yún s'e saha̱ kju̱a̱tsjo nga xi ts'ínkjáíhi̱n niu̱.” ");
INSERT INTO majNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nk'ie nga ja kama nga b'a̱ kitsú Pablo̱, tsasinkúnch'in nga kinchja̱ko̱ Nti̱a̱ná ko̱ b'a̱ ta̱ i̱ncha kits'ín jóo̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","I̱ncha kikjintá ko̱ kitsubakjá ko̱ kikjexu̱'ba tsa̱ha̱ Pablo̱. ");
INSERT INTO majNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","'Yún i̱ncha kik'ie babaha̱ jóo̱ a̱t'aha̱ b'a̱ kitsú nga najmi ta̱ i̱ncha sku̱e̱he Pablo̱. A̱s'a̱i i̱ncha ngjisín ni̱yá santaha má kjijña tsutsu xi ngju̱a̱i̱ko̱ho̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nk'ie nga y'entui̱ já nts'eé xi tjín nanki Efe̱so̱, tsitjas'e̱i̱n nku tsutsu. Tsankin na̱xu̱i̱ na̱xu̱i̱ xjo̱ Cos. Ni̱stjin xi ma ndyjuu̱n tsichii̱ xjo̱ Roda̱ ko̱ a̱skahan tsichii̱ nanki Pata̱ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Yo̱ kisakúni̱ kj'a̱í tsutsu xi tífi a̱nte Fenici̱a̱. Tsitjas'e̱i̱n ko̱ tsankinko̱i̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kiyai̱ xjo̱ Chipre̱. Skjúhu̱n tsitjai̱ nga tsankii̱n a̱nte Siri̱a̱. A̱s'a̱i tsichii̱ nanki Tiro̱, a̱t'aha̱ yo̱ tjíhin nga chjúje̱n ch'á xi y'a tsutsuu̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kisakúni̱ xu̱ta̱ xi yjankihi̱ Jesu xi tjín yo̱. Yatu ni̱stjin ts'andayani̱. Kui xi b'a̱ kitsúhu̱ Pablo̱ nga najmi tu̱ ngju̱a̱i̱ nanki Jerusalen, a̱t'aha̱ Espiri̱tu̱ Santo̱ tsakúchjihi̱ ni xi ka̱ma. ");
INSERT INTO majNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nk'ie nga j'a ni̱stjin xi yatuu̱, tsitjui̱ yo̱ ko̱ i̱ncha ngjisín ni̱yáni̱ ngayjee̱ jáx'i̱n ko̱ jminchjíhi̱n ko̱ ntíhi̱ santaha na̱tsin na̱nti̱o̱. A̱s'a̱i tsinchakúnch'ii̱n a̱ndai ntáchak'uu̱n ko̱ kichubako̱i̱ Nti̱a̱ná. ");
INSERT INTO majNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","A̱s'a̱i b'i̱ ngján kinubakjái̱ xinki̱, ji̱n tsitjas'e̱i̱n tsutsuu̱ ko̱ kui i̱ncha kik'óya ngáha ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nku tsutsu tsitjuko̱i̱ Tiro̱ ko̱ tsankii̱n nanki Tolemaida̱. Kisuniñai̱hi̱ já nts'eé xi tjín yo̱ ko̱ ts'andayani̱ nku ni̱stjin. ");
INSERT INTO majNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ni̱stjin xi ma ndyjuu̱n tsitjui̱ ko̱ tsichii̱ nanki Cesarea̱. A̱s'a̱i tsankii̱n ni'yaha̱ Felipe̱ ko̱ tintsu̱ba̱ko̱i̱. Felipe̱ xi ta̱ b'éni̱jmí én nda tsuhu̱ Jesu ko̱ ta̱ tjíhi̱n xá a̱jihi̱n já yatu xi basinko̱ já postru̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ta̱ tjíntuhu̱ ñju i̱stinchjín xu̱nkú xi Nti̱a̱ná tsjáha̱ éhe̱n. ");
INSERT INTO majNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ja tjíhi̱n nkjin ni̱stjin nga tintsu̱ba̱i̱ yo̱ nk'ie nga j'ai nku nda̱ profeta̱ xi 'mi Aga̱bo̱ xi nibaha a̱nte Judea̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","J'aitsubek'únni̱, jakj'á tja̱ba̱xín ndayáha̱ Pablo̱ ko̱ y'ét'a'yúnko̱ho ntsja ko̱ sjai. A̱s'a̱i b'i̱ kitsú: —B'i̱ títsu Espiri̱tu̱ Santo̱ nga b'i̱ ts'ín k'u̱ét'a'yúhu̱n já judio̱ xi tjín Jerusalen nda̱ xi ts'e̱ tja̱ba̱xín ndayái̱. Ts'i̱ínkjas'en a̱ya ntsja já xi najmi ntje̱ Israel tje̱he̱n ra̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nk'ie nga kinu'yái̱ niu̱, b'a̱ kik'ii̱hi̱n Pablo̱ ko̱ b'a̱ ta̱ kitsúhu̱ xu̱ta̱ xi tjín yo̱, nga najmi tu̱ ngju̱a̱i̱ nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","A̱s'a̱i b'a̱ kitsú Pablo̱: —¿Á tích'íhinu ko̱ tín'e bahanú? Tjínkuhu̱ k'an nga najmi tu̱ nku nga s'e̱t'a'yán. Ta̱ tjínku níhi̱ k'an nga santaha ku̱a̱yá Jerusalen nga̱t'aha̱ Nda̱ Nti̱a̱ná Jesu. ");
INSERT INTO majNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nk'ie nga najmi kits'ín yu Pablo̱ ni xi tí'mii̱hi̱, najmi b'a̱ ta̱ kik'in saha̱ ri̱. —Katuma xi nkú ts'ín mjehe̱ Nti̱a̱ná —tu̱ tsixíhín sai̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","A̱skahan y'endai̱ yjoni̱ ko̱ tsankii̱n nanki Jerusalen. ");
INSERT INTO majNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kitsjennkíni̱ k'u̱a̱ já xi yjankihi̱ Jesu xi tjín nanki Cesarea̱ ko̱ ngjiko̱ni̱ ni'yaha̱ nku nda̱ xi nibáha xjo̱ Chipre̱ xi 'mi Mnason xi ja nd'a̱i tje̱nnkihi̱ ra̱ Jesu. Kui xi kitsjánteni̱ nga ku̱i̱ntsu̱ba̱i̱ ni'yaha̱. ");
INSERT INTO majNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nk'ie nga tsichii̱ nanki Jerusalen, tsjo ts'ín kits'ínkjáínni̱ já nts'eé. ");
INSERT INTO majNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ni̱stjin xi ma ndyjuu̱n